(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[   2082873,      39121]
NotebookOptionsPosition[   2081636,      39075]
NotebookOutlinePosition[   2082291,      39100]
CellTagsIndexPosition[   2082248,      39097]
WindowTitle->Light Refraction with a Waterdrop - Source
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Light Refraction with a Waterdrop", "Section",
 CellFrame->{{0, 0}, {0, 0}},
 ShowCellBracket->False,
 FontColor->RGBColor[0.597406, 0, 0.0527047]],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztnVuSozgWQDNiPqa3MJ+zpVlCbaB3WlGVNV9dvYH6TQRUph/ZGIHQmwvG
xoZzQu3Aku7VfUj4Nk53//fLn//78q+Xl5f/NP/88e+Xl8v154Xj5+fp89y0
4+X63L7VnQu02XqOt9FzjRK5qtRMoYZFpk11/Ji+WDye92+r7+fFfbnGkuu9
eIQ4LBVJ+YRo5DPnRdITDp0TLRg6m/62nY/n08f5+H461G37fWqum57z4Xy2
jby0prMZOh4/jodLOx2bt6fzRSEA3B/KMKGSBy/DSKVcyYOn8krHqajvqed6
G6iol4qkfAIVNQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAADsizPA/lj72AEA
AMCmWLu0AXh01j6jAAAAcdb+hNwUJ5e1zZnPDEeey/e1jx0AAABsirVLm03x
XFVlhs1X1JNY+4wCAAB02B9PJ4BdsvYpBAAAgOeGihpADo9GAUDIr+Lnr7ef
a9vw16/i73VtMPx6+2v1gGwMijeAE89FAQA2DRW1BxX14lBRA0wi+lx0baMA
AAAAAAAAAAAAbkj0uegR4L4cDoe1TYA1YQMAbIaDy9rm3JU9+w4AjwB3np3D
BgDYDHuuKu/su3k0ynNRACGLHMy93dm2ijCPpHvD7LliAQAAmA0VNRioqIGK
GlYk9Vz0AAAAAAAAAAAAALBR9KPR8Kf0a9sFAAAAAAAAAAAAcCt4LgoAAAAA
AAAAAAB7I/Vc9ONheH9/X9uEzUJsZ0PoAGBZ3gNuLQgggR21GUjl7SC2syF0
ALAsVNQgxMv14XAI/xOja9sIAAAAT0lYWM5jbT/msGffAQAAAGAp9lxV3sF3
b1r0uehSZgAAAAAAAAAAAAA8Ar9b6rpuXpu3+tf0PBcFWJcFvxYBAAAAANgh
VNQAADCK5LnobwAAAAAAAAAAAIANUbcPRav+wehH7LmoUqpsqKqmNTSXRVE0
by593mtRXlrfo7mImTlVN6ebUOhR07q3jmxVWXqquqxVOUjZq1eDVNe662ro
Nxe1Xr5o2lt5cUc7VWr3BpGindNL6TkDl5nVIGWtbuaXWbwJo/OVKjSX68oL
shMTO4ylHf+yy5GbhU5EubJJPeWgx5ayBfvOIR2qD5QJXWmFtJs2pLsLvu40
4oOesh/tJ3TKW/3DomZONgVdVPtNXvVXYWydyBRl/NWNWNW62L06G344TcNW
L/SVpaTqcmeOWGWOm3W+TFPWsbL8dE1yklUal73ghDtBH+Hu1dE/HBM7/t7h
sjNoN29Calrl2GadWfsMeoc0elcR584clrm5qzO5a+5mQe4imy2Tu1qcu+g2
7od7mkvVtqJtajgInQuqzUrRtWFCzIAkzQdK0/RR1U33JEhtgOhosnmLKtX0
DArVhaJHtZOlmgPbVN+mWZhRGzNvEc13MD61kIRcEPS2WciRp/C97a0ow569
DCOVRurZU0lFnUoBFbWkKiv7I0xFLc4dFXUAFfVUtVTUYRD2V1EnfTd7u920
v+va/NXoSXM86qXVwFtzgNvS7vJG3730Ga76Wkq/6lFz3dlWOa+69XpUOSix
ixQtrrVV1pxBleO+uesMsv6QjenXF+bViFjGO5rtObaUp7bVoENe21Kqy1Un
1M8xOaxNftysOh61q5joKStQpbkIQ2p54HRWXcqsOsbVU7oZNBr8Fbv+yotk
GBkvbuFbu9/LkY6DF3ZvTvqtOVXdBi0dlN6WZekEsHfQ2flmjpnQ+25vfn//
2yH1eswnokp/tNkpsJNrTqJruX4tzAkKBJXJVdUbbJmtrwtrUfuoGm2Ru5S3
AcrEGQyPld3jzbFTH+oP+is3d+XVuev2wI1zN9w8rZM1I3dFf203xxKvuUyT
TevJkd8JSzF7iVHBzJa+D0vFZJLapawNh6xiQ91ixaf03R+lDHvaMqwPCKl8
+lRGgkZF3W3Q0oGKmoq685yKmoo6L5jZ0vdhqZhMUruUteEQFfUk37VU98C8
qRvq+uPjQz8UPZ/P+snoZYIqVAwtaFY0r+E0+8l8VIM3Gs70JkelUoLR0XBm
2X5dldcmWS5lQ2r1jDue+DBaRvrzvidVpc2WOKJicRvVZu+HaFqjgpngC/MS
Fek2rRvSjKCy9rnxfepWFFKokVMzWaEsU9GDbEYnbfuoYOpGkdcwql/Sv+fc
CVdJcY1a+Yo3WuUaZsfE+9S+j3mTRuFZoAxL9eTtFK6ecccTH0bnlmGkMtXz
dKnMLCTpifZTUUfnyNOR4QGrstQuHTXGFqSiXiV3wlVSXKNWvuKNVrmG2TGh
ooZb0+T0rUWf/br9e1HvuWjR/z1/+JOUIujKPxYu+l9YCEX0kGVARDxjjHxa
ygZv6ejF6KiE0cfp0eUk6JMrmVamQx1qkPTIRzNSo4LC0OnbV7S/tD7WRw32
ElFYP1/y7EkZn09lPhHedej7vDiHSkbzq79YsWcWfUUUzYgXf7mdqa04eiK0
ebYxe86d9yE+T3n+OzuVqHbMx01Up/kkCud7Q0ZJ5uvCRQhNGvVCoueayK9O
mKP8qDDd9szol7b5AM5LSup0P7LvxXBX8dWGvlCGTTJm1IBwianK3QySyo2k
clR/KtShBkmPfDQjNSpIRS0xexJRy8NjS0UtMfVBcmegoh6FijrkEarKPVfU
Gd89w+rwd/Tt34uq/kuT6C2xsG5WhXvLsu+KUb+8/kxsvQMryUIxdp8PLc/c
FiblXaJEcgvKuODFf54N8yYXwYejZ2fUbO8i5b7kXwRSPfJtFu1JWZ7BtlZu
eRg9XXJEbcuriorIU2xkjYjQi2hJFjXeFvFmhjeNUWu9HhO3/LQoe8tdSKqC
ys+f+tE5aZVoBSU0T87U+sr2emq4Ur7k9eQrhydiaqiF3LqSX4QFfacMk684
yaT7l2GkUr7iJJOoqKMrUlGPritxZ9RyT9aIUFHn133e3IVQUQvVUlHPhor6
1r6r/k9G9X1A/47+dDrZ/9+lb9++vbr8+PHDe7X7w077rafHU+JNTo1GF/Wu
U52hhtCjqGEZJVGdoZsp5ZmZoRe2kc3Fd0tnKGKvJQ9UKr8pRh15dY0MZTOO
e/pTa43OSUmFpn5Pbzzv7agveTNCJRnZ70FCX4OU5ZWn9KfiELrpLZ3aIZn0
RYmGN+NRPsIpd7y19pa7qIhQZ15coicVmamMLjpb1SLmLUgmzlOtzau6RRAm
bYxFTJoh9Vy+U4aNKonqDN1MKc/MDL2wjXydWIaRylElz5LKVExSS2Scigqm
HHl1jQxlM457+lNrjc5JSYWmUlF7jqQ2RmqHZNIXJRrejEf5CKfc8dbaW+6i
IkKdeXGJnlRkpjK66GxVi5i3IJk4T7U2r+oWQZi0MRYxaYbUZnyPLvH/lte2
FP/69esnAAAAAAAAAAAAwM74B4thROM=
   "], {{0, 0}, {1800, 25}}, {0, 255},
   ColorFunction->RGBColor],
  ImageSize->{1800, 25},
  PlotRange->{{0, 1800}, {0, 25}}]], "Section",
 CellFrame->{{0, 0}, {0, 0}},
 ShowCellBracket->False],

Cell[BoxData[
 RowBox[{"Manipulate", "[", "\n", " ", 
  RowBox[{
   RowBox[{"Show", "[", 
    RowBox[{
     RowBox[{"Graphics", "[", 
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Opacity", "[", "0.8", "]"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"GrayLevel", "[", "0", "]"}], ",", " ", 
           RowBox[{"AbsoluteThickness", "[", "0.5", "]"}], ",", " ", 
           RowBox[{"Line", "[", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "1.4203048459560108*^-17"}], ",", " ", 
                  RowBox[{"-", "0.05688284915968362"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "1.22514845490862*^-17"}], ",", " ", 
                  RowBox[{"-", "0.05688284915968362"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.00782820398473696"}], ",", " ", 
                  RowBox[{"-", "0.0564921568493474"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.008104353120789472"}], ",", " ", 
                  RowBox[{"-", "0.0564921568493474"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "1.4203048459560108*^-17"}], ",", " ", 
                  RowBox[{"-", "0.05688284915968362"}]}], "}"}]}], "}"}], ",",
               " ", "\n", "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.008104353120789472"}], ",", " ", 
                  RowBox[{"-", "0.0564921568493474"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.00782820398473696"}], ",", " ", 
                  RowBox[{"-", "0.0564921568493474"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.015898487724570993"}], ",", " ", 
                  RowBox[{"-", "0.05521682457414796"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.016459325645790453"}], ",", " ", 
                  RowBox[{"-", "0.05521682457414796"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.008104353120789472"}], ",", " ", 
                  RowBox[{"-", "0.0564921568493474"}]}], "}"}]}], "}"}], ",", 
              " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.01645932564579044"}], ",", " ", 
                  RowBox[{"-", "0.05521682457414796"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.01589848772457098"}], ",", " ", 
                  RowBox[{"-", "0.05521682457414796"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.024195029355291737"}], ",", " ", 
                  RowBox[{"-", "0.0530770008349515"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.02504853757585627"}], ",", " ", 
                  RowBox[{"-", "0.0530770008349515"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.01645932564579044"}], ",", " ", 
                  RowBox[{"-", "0.05521682457414796"}]}], "}"}]}], "}"}], ",",
               " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.02504853757585627"}], ",", " ", 
                  RowBox[{"-", "0.0530770008349515"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.024195029355291737"}], ",", " ", 
                  RowBox[{"-", "0.0530770008349515"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.03256808447334166"}], ",", " ", 
                  RowBox[{"-", "0.05009952120873742"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.03371696209683408"}], ",", " ", 
                  RowBox[{"-", "0.05009952120873742"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.02504853757585627"}], ",", " ", 
                  RowBox[{"-", "0.0530770008349515"}]}], "}"}]}], "}"}], ",", 
              " ", "\n", "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.03371696209683407"}], ",", " ", 
                  RowBox[{"-", "0.050099521208737424"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.032568084473341655"}], ",", " ", 
                  RowBox[{"-", "0.050099521208737424"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.04073731929958602"}], ",", " ", 
                  RowBox[{"-", "0.046318106341445356"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.04217437632462138"}], ",", " ", 
                  RowBox[{"-", "0.046318106341445356"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.03371696209683407"}], ",", " ", 
                  RowBox[{"-", "0.050099521208737424"}]}], "}"}]}], "}"}], 
              ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.04217437632462138"}], ",", " ", 
                  RowBox[{"-", "0.046318106341445356"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.04073731929958602"}], ",", " ", 
                  RowBox[{"-", "0.046318106341445356"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.04833010830338694"}], ",", " ", 
                  RowBox[{"-", "0.04177394503607659"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.05003500992313608"}], ",", " ", 
                  RowBox[{"-", "0.04177394503607659"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.04217437632462138"}], ",", " ", 
                  RowBox[{"-", "0.046318106341445356"}]}], "}"}]}], "}"}], 
              ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.05003500992313608"}], ",", " ", 
                  RowBox[{"-", "0.04177394503607659"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.04833010830338694"}], ",", " ", 
                  RowBox[{"-", "0.04177394503607659"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.05494543573487883"}], ",", " ", 
                  RowBox[{"-", "0.03651657383838262"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.05688370083857305"}], ",", " ", 
                  RowBox[{"-", "0.03651657383838262"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.05003500992313608"}], ",", " ", 
                  RowBox[{"-", "0.04177394503607659"}]}], "}"}]}], "}"}], ",",
               " ", "\n", "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.05688370083857304"}], ",", " ", 
                  RowBox[{"-", "0.03651657383838262"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.054945435734878825"}], ",", " ", 
                  RowBox[{"-", "0.03651657383838262"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.06022754534689994"}], ",", " ", 
                  RowBox[{"-", "0.03060493068010821"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.06235214310221366"}], ",", " ", 
                  RowBox[{"-", "0.03060493068010821"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.05688370083857304"}], ",", " ", 
                  RowBox[{"-", "0.03651657383838262"}]}], "}"}]}], "}"}], ",",
               " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.06235214310221367"}], ",", " ", 
                  RowBox[{"-", "0.0306049306801082"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.06022754534689994"}], ",", " ", 
                  RowBox[{"-", "0.0306049306801082"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.06393111794538205"}], ",", " ", 
                  RowBox[{"-", "0.024108435682384573"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.06618636359584165"}], ",", " ", 
                  RowBox[{"-", "0.024108435682384573"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.06235214310221367"}], ",", " ", 
                  RowBox[{"-", "0.0306049306801082"}]}], "}"}]}], "}"}], ",", 
              " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.06618636359584165"}], ",", " ", 
                  RowBox[{"-", "0.024108435682384573"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.06393111794538205"}], ",", " ", 
                  RowBox[{"-", "0.024108435682384573"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.06596209888890318"}], ",", " ", 
                  RowBox[{"-", "0.017107939026036665"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.06828898978953588"}], ",", " ", 
                  RowBox[{"-", "0.017107939026036665"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.06618636359584165"}], ",", " ", 
                  RowBox[{"-", "0.024108435682384573"}]}], "}"}]}], "}"}], 
              ",", " ", "\n", "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.06828898978953588"}], ",", " ", 
                  RowBox[{"-", "0.017107939026036665"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.06596209888890318"}], ",", " ", 
                  RowBox[{"-", "0.017107939026036665"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.06638468989817264"}], ",", " ", 
                  RowBox[{"-", "0.009696374951067403"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.06872648819548799"}], ",", " ", 
                  RowBox[{"-", "0.009696374951067403"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.06828898978953588"}], ",", " ", 
                  RowBox[{"-", "0.017107939026036665"}]}], "}"}]}], "}"}], 
              ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.06872648819548799"}], ",", " ", 
                  RowBox[{"-", "0.009696374951067403"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.06638468989817264"}], ",", " ", 
                  RowBox[{"-", "0.009696374951067403"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.06539375152165473"}], ",", " ", 
                  RowBox[{"-", "0.0019789726801209746"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.0677005932980248"}], ",", " ", 
                  RowBox[{"-", "0.0019789726801209746"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.06872648819548799"}], ",", " ", 
                  RowBox[{"-", "0.009696374951067403"}]}], "}"}]}], "}"}], 
              ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.0677005932980248"}], ",", " ", 
                  RowBox[{"-", "0.0019789726801209746"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.06539375152165473"}], ",", " ", 
                  RowBox[{"-", "0.0019789726801209746"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.0632606296877138"}], ",", " ", 
                  "0.005927101286260139"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.06549222307343307"}], ",", " ", 
                  "0.005927101286260139"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.0677005932980248"}], ",", " ", 
                  RowBox[{"-", "0.0019789726801209746"}]}], "}"}]}], "}"}], 
              ",", " ", "\n", "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.06549222307343307"}], ",", " ", 
                  "0.0059271012862601264"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.06326062968771382"}], ",", " ", 
                  "0.0059271012862601264"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.06026693480785181"}], ",", " ", 
                  "0.013893760977926984"}], "}"}], ",", " ", "\n", 
                "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.062392922072896304"}], ",", " ", 
                  "0.013893760977926984"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.06549222307343307"}], ",", " ", 
                  "0.0059271012862601264"}], "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.062392922072896304"}], ",", " ", 
                  "0.013893760977926984"}], "}"}], ",", " ", "\n", 
                "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.06026693480785181"}], ",", " ", 
                  "0.013893760977926984"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.05664339846652768"}], ",", " ", 
                  "0.021783728078581376"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.05864156120987315"}], ",", " ", 
                  "0.021783728078581376"}], "}"}], ",", " ", "\n", 
                "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.062392922072896304"}], ",", " ", 
                  "0.013893760977926984"}], "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.05864156120987315"}], ",", " ", 
                  "0.021783728078581376"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.05664339846652768"}], ",", " ", 
                  "0.021783728078581376"}], "}"}], ",", " ", "\n", 
                "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.05252899951874454"}], ",", " ", 
                  "0.02945296995204571"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.05438202198252895"}], ",", " ", 
                  "0.02945296995204571"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.05864156120987315"}], ",", " ", 
                  "0.021783728078581376"}], "}"}]}], "}"}], ",", " ", "\n", 
              "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.05438202198252895"}], ",", " ", 
                  "0.02945296995204571"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.05252899951874454"}], ",", " ", 
                  "0.02945296995204571"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.04795968325887588"}], ",", " ", 
                  "0.03675380039988509"}], "}"}], ",", " ", "\n", 
                "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.04965151769792643"}], ",", " ", 
                  "0.03675380039988509"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.05438202198252895"}], ",", " ", 
                  "0.02945296995204571"}], "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.04965151769792643"}], ",", " ", 
                  "0.03675380039988509"}], "}"}], ",", " ", "\n", 
                "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.04795968325887588"}], ",", " ", 
                  "0.03675380039988509"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.04288782451225172"}], ",", " ", 
                  "0.04353854648936185"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.04440074314714191"}], ",", " ", 
                  "0.04353854648936185"}], "}"}], ",", " ", "\n", 
                "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.04965151769792643"}], ",", " ", 
                  "0.03675380039988509"}], "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.04440074314714191"}], ",", " ", 
                  "0.04353854648936185"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.04288782451225172"}], ",", " ", 
                  "0.04353854648936185"}], "}"}], ",", " ", "\n", 
                "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.03722532866199545"}], ",", " ", 
                  "0.04966364092329548"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.03853849607170062"}], ",", " ", 
                  "0.04966364092329548"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.04440074314714191"}], ",", " ", 
                  "0.04353854648936185"}], "}"}]}], "}"}], ",", " ", "\n", 
              "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.03853849607170066"}], ",", " ", 
                  "0.049663640923295456"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.037225328661995453"}], ",", " ", 
                  "0.049663640923295456"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.030897135585250375"}], ",", " ", 
                  "0.054993963249953474"}], "}"}], ",", " ", "\n", 
                "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.03198706851431048"}], ",", " ", 
                  "0.054993963249953474"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.03853849607170066"}], ",", " ", 
                  "0.049663640923295456"}], "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.03198706851431048"}], ",", " ", 
                  "0.054993963249953474"}], "}"}], ",", " ", "\n", 
                "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.030897135585250375"}], ",", " ", 
                  "0.054993963249953474"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.023889501059992435"}], ",", " ", 
                  "0.0594072273124165"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.0247322314092916"}], ",", " ", 
                  "0.0594072273124165"}], "}"}], ",", " ", "\n", 
                "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.03198706851431048"}], ",", " ", 
                  "0.054993963249953474"}], "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.0247322314092916"}], ",", " ", 
                  "0.0594072273124165"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.023889501059992435"}], ",", " ", 
                  "0.0594072273124165"}], "}"}], ",", " ", "\n", 
                "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.01627936139255439"}], ",", " ", 
                  "0.06279819862535355"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.016853635081999087"}], ",", " ", 
                  "0.06279819862535355"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.0247322314092916"}], ",", " ", 
                  "0.0594072273124165"}], "}"}]}], "}"}], ",", " ", "\n", 
              "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.016853635081999087"}], ",", " ", 
                  "0.06279819862535355"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.01627936139255439"}], ",", " ", 
                  "0.06279819862535355"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.008236746983106976"}], ",", " ", 
                  "0.06508252495431804"}], "}"}], ",", " ", "\n", 
                "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.008527307955675266"}], ",", " ", 
                  "0.06508252495431804"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.016853635081999087"}], ",", " ", 
                  "0.06279819862535355"}], "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.008527307955675266"}], ",", " ", 
                  "0.06508252495431804"}], "}"}], ",", " ", "\n", 
                "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.008236746983106976"}], ",", " ", 
                  "0.06508252495431804"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "2.1141942363467336*^-17", ",", " ", "0.06619997649057771"}],
                  "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "2.200930410145574*^-17", ",", " ", "0.06619997649057771"}], 
                 "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.008527307955675266"}], ",", " ", 
                  "0.06508252495431804"}], "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "1.22514845490862*^-17"}], ",", " ", 
                  RowBox[{"-", "0.05688284915968362"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "1.1438332919722072*^-17"}], ",", " ", 
                  RowBox[{"-", "0.05688284915968362"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.007018575683843376"}], ",", " ", 
                  RowBox[{"-", "0.0564921568493474"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.00782820398473696"}], ",", " ", 
                  RowBox[{"-", "0.0564921568493474"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "1.22514845490862*^-17"}], ",", " ", 
                  RowBox[{"-", "0.05688284915968362"}]}], "}"}]}], "}"}], ",",
               " ", "\n", "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.00782820398473696"}], ",", " ", 
                  RowBox[{"-", "0.0564921568493474"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.007018575683843376"}], ",", " ", 
                  RowBox[{"-", "0.0564921568493474"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.014254194138415235"}], ",", " ", 
                  RowBox[{"-", "0.05521682457414796"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.015898487724570993"}], ",", " ", 
                  RowBox[{"-", "0.05521682457414796"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.00782820398473696"}], ",", " ", 
                  RowBox[{"-", "0.0564921568493474"}]}], "}"}]}], "}"}], ",", 
              " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.01589848772457098"}], ",", " ", 
                  RowBox[{"-", "0.05521682457414796"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.014254194138415225"}], ",", " ", 
                  RowBox[{"-", "0.05521682457414796"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.021692669868340602"}], ",", " ", 
                  RowBox[{"-", "0.0530770008349515"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.024195029355291737"}], ",", " ", 
                  RowBox[{"-", "0.0530770008349515"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.01589848772457098"}], ",", " ", 
                  RowBox[{"-", "0.05521682457414796"}]}], "}"}]}], "}"}], ",",
               " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.024195029355291737"}], ",", " ", 
                  RowBox[{"-", "0.0530770008349515"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.021692669868340602"}], ",", " ", 
                  RowBox[{"-", "0.0530770008349515"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.029199745714295344"}], ",", " ", 
                  RowBox[{"-", "0.05009952120873742"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.03256808447334166"}], ",", " ", 
                  RowBox[{"-", "0.05009952120873742"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.024195029355291737"}], ",", " ", 
                  RowBox[{"-", "0.0530770008349515"}]}], "}"}]}], "}"}], ",", 
              " ", "\n", "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.032568084473341655"}], ",", " ", 
                  RowBox[{"-", "0.050099521208737424"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.029199745714295337"}], ",", " ", 
                  RowBox[{"-", "0.050099521208737424"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.03652408128588709"}], ",", " ", 
                  RowBox[{"-", "0.046318106341445356"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.04073731929958602"}], ",", " ", 
                  RowBox[{"-", "0.046318106341445356"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.032568084473341655"}], ",", " ", 
                  RowBox[{"-", "0.050099521208737424"}]}], "}"}]}], "}"}], 
              ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.04073731929958602"}], ",", " ", 
                  RowBox[{"-", "0.046318106341445356"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.03652408128588709"}], ",", " ", 
                  RowBox[{"-", "0.046318106341445356"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.04333158967204231"}], ",", " ", 
                  RowBox[{"-", "0.04177394503607659"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.04833010830338694"}], ",", " ", 
                  RowBox[{"-", "0.04177394503607659"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.04073731929958602"}], ",", " ", 
                  RowBox[{"-", "0.046318106341445356"}]}], "}"}]}], "}"}], 
              ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.04833010830338694"}], ",", " ", 
                  RowBox[{"-", "0.04177394503607659"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.04333158967204231"}], ",", " ", 
                  RowBox[{"-", "0.04177394503607659"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.04926272998747843"}], ",", " ", 
                  RowBox[{"-", "0.03651657383838262"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.05494543573487883"}], ",", " ", 
                  RowBox[{"-", "0.03651657383838262"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.04833010830338694"}], ",", " ", 
                  RowBox[{"-", "0.04177394503607659"}]}], "}"}]}], "}"}], ",",
               " ", "\n", "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.054945435734878825"}], ",", " ", 
                  RowBox[{"-", "0.03651657383838262"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.049262729987478424"}], ",", " ", 
                  RowBox[{"-", "0.03651657383838262"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.05399853990691967"}], ",", " ", 
                  RowBox[{"-", "0.03060493068010821"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.06022754534689994"}], ",", " ", 
                  RowBox[{"-", "0.03060493068010821"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.054945435734878825"}], ",", " ", 
                  RowBox[{"-", "0.03651657383838262"}]}], "}"}]}], "}"}], ",",
               " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.06022754534689994"}], ",", " ", 
                  RowBox[{"-", "0.0306049306801082"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.053998539906919676"}], ",", " ", 
                  RowBox[{"-", "0.0306049306801082"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.05731907225811242"}], ",", " ", 
                  RowBox[{"-", "0.024108435682384573"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.06393111794538205"}], ",", " ", 
                  RowBox[{"-", "0.024108435682384573"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.06022754534689994"}], ",", " ", 
                  RowBox[{"-", "0.0306049306801082"}]}], "}"}]}], "}"}], ",", 
              " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.06393111794538205"}], ",", " ", 
                  RowBox[{"-", "0.024108435682384573"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.05731907225811242"}], ",", " ", 
                  RowBox[{"-", "0.024108435682384573"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.0591399999565142"}], ",", " ", 
                  RowBox[{"-", "0.017107939026036665"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.06596209888890318"}], ",", " ", 
                  RowBox[{"-", "0.017107939026036665"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.06393111794538205"}], ",", " ", 
                  RowBox[{"-", "0.024108435682384573"}]}], "}"}]}], "}"}], 
              ",", " ", "\n", "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.06596209888890318"}], ",", " ", 
                  RowBox[{"-", "0.017107939026036665"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.0591399999565142"}], ",", " ", 
                  RowBox[{"-", "0.017107939026036665"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.05951888469018394"}], ",", " ", 
                  RowBox[{"-", "0.009696374951067403"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.06638468989817264"}], ",", " ", 
                  RowBox[{"-", "0.009696374951067403"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.06596209888890318"}], ",", " ", 
                  RowBox[{"-", "0.017107939026036665"}]}], "}"}]}], "}"}], 
              ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.06638468989817264"}], ",", " ", 
                  RowBox[{"-", "0.009696374951067403"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.05951888469018394"}], ",", " ", 
                  RowBox[{"-", "0.009696374951067403"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.05863043364736797"}], ",", " ", 
                  RowBox[{"-", "0.0019789726801209746"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.06539375152165473"}], ",", " ", 
                  RowBox[{"-", "0.0019789726801209746"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.06638468989817264"}], ",", " ", 
                  RowBox[{"-", "0.009696374951067403"}]}], "}"}]}], "}"}], 
              ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.06539375152165473"}], ",", " ", 
                  RowBox[{"-", "0.0019789726801209746"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.05863043364736797"}], ",", " ", 
                  RowBox[{"-", "0.0019789726801209746"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.056717928931910376"}], ",", " ", 
                  "0.005927101286260139"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.0632606296877138"}], ",", " ", 
                  "0.005927101286260139"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.06539375152165473"}], ",", " ", 
                  RowBox[{"-", "0.0019789726801209746"}]}], "}"}]}], "}"}], 
              ",", " ", "\n", "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.06326062968771382"}], ",", " ", 
                  "0.0059271012862601264"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.056717928931910376"}], ",", " ", 
                  "0.0059271012862601264"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.05403385553147103"}], ",", " ", 
                  "0.013893760977926984"}], "}"}], ",", " ", "\n", 
                "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.06026693480785181"}], ",", " ", 
                  "0.013893760977926984"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.06326062968771382"}], ",", " ", 
                  "0.0059271012862601264"}], "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.06026693480785181"}], ",", " ", 
                  "0.013893760977926984"}], "}"}], ",", " ", "\n", 
                "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.05403385553147103"}], ",", " ", 
                  "0.013893760977926984"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.05078508172533024"}], ",", " ", 
                  "0.021783728078581376"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.05664339846652768"}], ",", " ", 
                  "0.021783728078581376"}], "}"}], ",", " ", "\n", 
                "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.06026693480785181"}], ",", " ", 
                  "0.013893760977926984"}], "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.05664339846652768"}], ",", " ", 
                  "0.021783728078581376"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.05078508172533024"}], ",", " ", 
                  "0.021783728078581376"}], "}"}], ",", " ", "\n", 
                "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.04709621254603385"}], ",", " ", 
                  "0.02945296995204571"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.05252899951874454"}], ",", " ", 
                  "0.02945296995204571"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.05664339846652768"}], ",", " ", 
                  "0.021783728078581376"}], "}"}]}], "}"}], ",", " ", "\n", 
              "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.05252899951874454"}], ",", " ", 
                  "0.02945296995204571"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.04709621254603385"}], ",", " ", 
                  "0.02945296995204571"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.04299947566285693"}], ",", " ", 
                  "0.03675380039988509"}], "}"}], ",", " ", "\n", 
                "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.04795968325887588"}], ",", " ", 
                  "0.03675380039988509"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.05252899951874454"}], ",", " ", 
                  "0.02945296995204571"}], "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.04795968325887588"}], ",", " ", 
                  "0.03675380039988509"}], "}"}], ",", " ", "\n", 
                "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.04299947566285693"}], ",", " ", 
                  "0.03675380039988509"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.0384521715123327"}], ",", " ", 
                  "0.04353854648936185"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.04288782451225172"}], ",", " ", 
                  "0.04353854648936185"}], "}"}], ",", " ", "\n", 
                "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.04795968325887588"}], ",", " ", 
                  "0.03675380039988509"}], "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.04288782451225172"}], ",", " ", 
                  "0.04353854648936185"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.0384521715123327"}], ",", " ", 
                  "0.04353854648936185"}], "}"}], ",", " ", "\n", 
                "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.03337531662173954"}], ",", " ", 
                  "0.04966364092329548"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.03722532866199545"}], ",", " ", 
                  "0.04966364092329548"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.04288782451225172"}], ",", " ", 
                  "0.04353854648936185"}], "}"}]}], "}"}], ",", " ", "\n", 
              "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.037225328661995453"}], ",", " ", 
                  "0.049663640923295456"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.03337531662173955"}], ",", " ", 
                  "0.049663640923295456"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.02770161392598622"}], ",", " ", 
                  "0.054993963249953474"}], "}"}], ",", " ", "\n", 
                "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.030897135585250375"}], ",", " ", 
                  "0.054993963249953474"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.037225328661995453"}], ",", " ", 
                  "0.049663640923295456"}], "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.030897135585250375"}], ",", " ", 
                  "0.054993963249953474"}], "}"}], ",", " ", "\n", 
                "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.02770161392598622"}], ",", " ", 
                  "0.054993963249953474"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.02141874069272193"}], ",", " ", 
                  "0.0594072273124165"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.023889501059992435"}], ",", " ", 
                  "0.0594072273124165"}], "}"}], ",", " ", "\n", 
                "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.030897135585250375"}], ",", " ", 
                  "0.054993963249953474"}], "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.023889501059992435"}], ",", " ", 
                  "0.0594072273124165"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.02141874069272193"}], ",", " ", 
                  "0.0594072273124165"}], "}"}], ",", " ", "\n", 
                "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.014595676127123836"}], ",", " ", 
                  "0.06279819862535355"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.01627936139255439"}], ",", " ", 
                  "0.06279819862535355"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.023889501059992435"}], ",", " ", 
                  "0.0594072273124165"}], "}"}]}], "}"}], ",", " ", "\n", 
              "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.01627936139255439"}], ",", " ", 
                  "0.06279819862535355"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.014595676127123836"}], ",", " ", 
                  "0.06279819862535355"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.007384865315507925"}], ",", " ", 
                  "0.06508252495431804"}], "}"}], ",", " ", "\n", 
                "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.008236746983106976"}], ",", " ", 
                  "0.06508252495431804"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.01627936139255439"}], ",", " ", 
                  "0.06279819862535355"}], "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.008236746983106976"}], ",", " ", 
                  "0.06508252495431804"}], "}"}], ",", " ", "\n", 
                "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.007384865315507925"}], ",", " ", 
                  "0.06508252495431804"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "1.9081958235744878*^-17", ",", " ", "0.06619997649057771"}],
                  "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "2.1141942363467336*^-17", ",", " ", "0.06619997649057771"}],
                  "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.008236746983106976"}], ",", " ", 
                  "0.06508252495431804"}], "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "1.1384122811097797*^-17"}], ",", " ", 
                  RowBox[{"-", "0.05688284915968362"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "9.595189226496714*^-18"}], ",", " ", 
                  RowBox[{"-", "0.05688284915968362"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.005730643048840595"}], ",", " ", 
                  RowBox[{"-", "0.0564921568493474"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.007018575683843379"}], ",", " ", 
                  RowBox[{"-", "0.0564921568493474"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "1.1384122811097797*^-17"}], ",", " ", 
                  RowBox[{"-", "0.05688284915968362"}]}], "}"}]}], "}"}], ",",
               " ", "\n", "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.007018575683843379"}], ",", " ", 
                  RowBox[{"-", "0.0564921568493474"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.005730643048840595"}], ",", " ", 
                  RowBox[{"-", "0.0564921568493474"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.011638500777896077"}], ",", " ", 
                  RowBox[{"-", "0.05521682457414796"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.014254194138415242"}], ",", " ", 
                  RowBox[{"-", "0.05521682457414796"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.007018575683843379"}], ",", " ", 
                  RowBox[{"-", "0.0564921568493474"}]}], "}"}]}], "}"}], ",", 
              " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.014254194138415232"}], ",", " ", 
                  RowBox[{"-", "0.05521682457414796"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.01163850077789607"}], ",", " ", 
                  RowBox[{"-", "0.05521682457414796"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.017711990778694012"}], ",", " ", 
                  RowBox[{"-", "0.0530770008349515"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.021692669868340612"}], ",", " ", 
                  RowBox[{"-", "0.0530770008349515"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.014254194138415232"}], ",", " ", 
                  RowBox[{"-", "0.05521682457414796"}]}], "}"}]}], "}"}], ",",
               " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.021692669868340612"}], ",", " ", 
                  RowBox[{"-", "0.0530770008349515"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.017711990778694012"}], ",", " ", 
                  RowBox[{"-", "0.0530770008349515"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.02384149253968117"}], ",", " ", 
                  RowBox[{"-", "0.05009952120873742"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.029199745714295358"}], ",", " ", 
                  RowBox[{"-", "0.05009952120873742"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.021692669868340612"}], ",", " ", 
                  RowBox[{"-", "0.0530770008349515"}]}], "}"}]}], "}"}], ",", 
              " ", "\n", "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.029199745714295344"}], ",", " ", 
                  RowBox[{"-", "0.050099521208737424"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.023841492539681167"}], ",", " ", 
                  RowBox[{"-", "0.050099521208737424"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.029821787491453155"}], ",", " ", 
                  RowBox[{"-", "0.046318106341445356"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.0365240812858871"}], ",", " ", 
                  RowBox[{"-", "0.046318106341445356"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.029199745714295344"}], ",", " ", 
                  RowBox[{"-", "0.050099521208737424"}]}], "}"}]}], "}"}], 
              ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.0365240812858871"}], ",", " ", 
                  RowBox[{"-", "0.046318106341445356"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.029821787491453155"}], ",", " ", 
                  RowBox[{"-", "0.046318106341445356"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.03538009481338571"}], ",", " ", 
                  RowBox[{"-", "0.04177394503607659"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.04333158967204232"}], ",", " ", 
                  RowBox[{"-", "0.04177394503607659"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.0365240812858871"}], ",", " ", 
                  RowBox[{"-", "0.046318106341445356"}]}], "}"}]}], "}"}], 
              ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.04333158967204232"}], ",", " ", 
                  RowBox[{"-", "0.04177394503607659"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.03538009481338571"}], ",", " ", 
                  RowBox[{"-", "0.04177394503607659"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.04022285060194191"}], ",", " ", 
                  RowBox[{"-", "0.03651657383838262"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.049262729987478444"}], ",", " ", 
                  RowBox[{"-", "0.03651657383838262"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.04333158967204232"}], ",", " ", 
                  RowBox[{"-", "0.04177394503607659"}]}], "}"}]}], "}"}], ",",
               " ", "\n", "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.04926272998747844"}], ",", " ", 
                  RowBox[{"-", "0.03651657383838262"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.040222850601941904"}], ",", " ", 
                  RowBox[{"-", "0.03651657383838262"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.04408962320908928"}], ",", " ", 
                  RowBox[{"-", "0.03060493068010821"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.05399853990691968"}], ",", " ", 
                  RowBox[{"-", "0.03060493068010821"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.04926272998747844"}], ",", " ", 
                  RowBox[{"-", "0.03651657383838262"}]}], "}"}]}], "}"}], ",",
               " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.0539985399069197"}], ",", " ", 
                  RowBox[{"-", "0.0306049306801082"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.04408962320908929"}], ",", " ", 
                  RowBox[{"-", "0.0306049306801082"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.04680082652069807"}], ",", " ", 
                  RowBox[{"-", "0.024108435682384573"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.05731907225811244"}], ",", " ", 
                  RowBox[{"-", "0.024108435682384573"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.0539985399069197"}], ",", " ", 
                  RowBox[{"-", "0.0306049306801082"}]}], "}"}]}], "}"}], ",", 
              " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.05731907225811244"}], ",", " ", 
                  RowBox[{"-", "0.024108435682384573"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.04680082652069807"}], ",", " ", 
                  RowBox[{"-", "0.024108435682384573"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.04828760776055972"}], ",", " ", 
                  RowBox[{"-", "0.017107939026036665"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.05913999995651422"}], ",", " ", 
                  RowBox[{"-", "0.017107939026036665"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.05731907225811244"}], ",", " ", 
                  RowBox[{"-", "0.024108435682384573"}]}], "}"}]}], "}"}], 
              ",", " ", "\n", "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.05913999995651422"}], ",", " ", 
                  RowBox[{"-", "0.017107939026036665"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.04828760776055972"}], ",", " ", 
                  RowBox[{"-", "0.017107939026036665"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.048596965850166776"}], ",", " ", 
                  RowBox[{"-", "0.009696374951067403"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.05951888469018396"}], ",", " ", 
                  RowBox[{"-", "0.009696374951067403"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.05913999995651422"}], ",", " ", 
                  RowBox[{"-", "0.017107939026036665"}]}], "}"}]}], "}"}], 
              ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.05951888469018396"}], ",", " ", 
                  RowBox[{"-", "0.009696374951067403"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.048596965850166776"}], ",", " ", 
                  RowBox[{"-", "0.009696374951067403"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.04787154861138586"}], ",", " ", 
                  RowBox[{"-", "0.0019789726801209746"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.05863043364736799"}], ",", " ", 
                  RowBox[{"-", "0.0019789726801209746"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.05951888469018396"}], ",", " ", 
                  RowBox[{"-", "0.009696374951067403"}]}], "}"}]}], "}"}], 
              ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.05863043364736799"}], ",", " ", 
                  RowBox[{"-", "0.0019789726801209746"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.04787154861138586"}], ",", " ", 
                  RowBox[{"-", "0.0019789726801209746"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.04630999505020658"}], ",", " ", 
                  "0.005927101286260139"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.0567179289319104"}], ",", " ", 
                  "0.005927101286260139"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.05863043364736799"}], ",", " ", 
                  RowBox[{"-", "0.0019789726801209746"}]}], "}"}]}], "}"}], 
              ",", " ", "\n", "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.0567179289319104"}], ",", " ", 
                  "0.0059271012862601264"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.04630999505020658"}], ",", " ", 
                  "0.0059271012862601264"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.0441184582957888"}], ",", " ", 
                  "0.013893760977926984"}], "}"}], ",", " ", "\n", 
                "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.05403385553147106"}], ",", " ", 
                  "0.013893760977926984"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.0567179289319104"}], ",", " ", 
                  "0.0059271012862601264"}], "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.05403385553147106"}], ",", " ", 
                  "0.013893760977926984"}], "}"}], ",", " ", "\n", 
                "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.0441184582957888"}], ",", " ", 
                  "0.013893760977926984"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.041465845590867294"}], ",", " ", 
                  "0.021783728078581376"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.05078508172533026"}], ",", " ", 
                  "0.021783728078581376"}], "}"}], ",", " ", "\n", 
                "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.05403385553147106"}], ",", " ", 
                  "0.013893760977926984"}], "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.05078508172533026"}], ",", " ", 
                  "0.021783728078581376"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.041465845590867294"}], ",", " ", 
                  "0.021783728078581376"}], "}"}], ",", " ", "\n", 
                "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.03845389651848211"}], ",", " ", 
                  "0.02945296995204571"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.04709621254603387"}], ",", " ", 
                  "0.02945296995204571"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.05078508172533026"}], ",", " ", 
                  "0.021783728078581376"}], "}"}]}], "}"}], ",", " ", "\n", 
              "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.04709621254603387"}], ",", " ", 
                  "0.02945296995204571"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.03845389651848211"}], ",", " ", 
                  "0.02945296995204571"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.03510892486040766"}], ",", " ", 
                  "0.03675380039988509"}], "}"}], ",", " ", "\n", 
                "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.042999475662856945"}], ",", " ", 
                  "0.03675380039988509"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.04709621254603387"}], ",", " ", 
                  "0.02945296995204571"}], "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.042999475662856945"}], ",", " ", 
                  "0.03675380039988509"}], "}"}], ",", " ", "\n", 
                "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.03510892486040766"}], ",", " ", 
                  "0.03675380039988509"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.03139606656906616"}], ",", " ", 
                  "0.04353854648936185"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.03845217151233271"}], ",", " ", 
                  "0.04353854648936185"}], "}"}], ",", " ", "\n", 
                "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.042999475662856945"}], ",", " ", 
                  "0.03675380039988509"}], "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.03845217151233271"}], ",", " ", 
                  "0.04353854648936185"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.03139606656906616"}], ",", " ", 
                  "0.04353854648936185"}], "}"}], ",", " ", "\n", 
                "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.027250831909030635"}], ",", " ", 
                  "0.04966364092329548"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.03337531662173955"}], ",", " ", 
                  "0.04966364092329548"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.03845217151233271"}], ",", " ", 
                  "0.04353854648936185"}], "}"}]}], "}"}], ",", " ", "\n", 
              "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.03337531662173956"}], ",", " ", 
                  "0.049663640923295456"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.02725083190903065"}], ",", " ", 
                  "0.049663640923295456"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.022618273056747636"}], ",", " ", 
                  "0.054993963249953474"}], "}"}], ",", " ", "\n", 
                "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.02770161392598624"}], ",", " ", 
                  "0.054993963249953474"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.03337531662173956"}], ",", " ", 
                  "0.049663640923295456"}], "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.02770161392598624"}], ",", " ", 
                  "0.054993963249953474"}], "}"}], ",", " ", "\n", 
                "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.022618273056747636"}], ",", " ", 
                  "0.054993963249953474"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.01748832854338501"}], ",", " ", 
                  "0.0594072273124165"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.021418740692721937"}], ",", " ", 
                  "0.0594072273124165"}], "}"}], ",", " ", "\n", 
                "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.02770161392598624"}], ",", " ", 
                  "0.054993963249953474"}], "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.021418740692721937"}], ",", " ", 
                  "0.0594072273124165"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.01748832854338501"}], ",", " ", 
                  "0.0594072273124165"}], "}"}], ",", " ", "\n", 
                "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.011917319654125048"}], ",", " ", 
                  "0.06279819862535355"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.01459567612712384"}], ",", " ", 
                  "0.06279819862535355"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.021418740692721937"}], ",", " ", 
                  "0.0594072273124165"}], "}"}]}], "}"}], ",", " ", "\n", 
              "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.01459567612712384"}], ",", " ", 
                  "0.06279819862535355"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.011917319654125048"}], ",", " ", 
                  "0.06279819862535355"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.006029717280723975"}], ",", " ", 
                  "0.06508252495431804"}], "}"}], ",", " ", "\n", 
                "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.007384865315507928"}], ",", " ", 
                  "0.06508252495431804"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.01459567612712384"}], ",", " ", 
                  "0.06279819862535355"}], "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.007384865315507928"}], ",", " ", 
                  "0.06508252495431804"}], "}"}], ",", " ", "\n", 
                "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.006029717280723975"}], ",", " ", 
                  "0.06508252495431804"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "1.5233040523421337*^-17", ",", " ", "0.06619997649057771"}],
                  "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "1.8973538018496328*^-17", ",", " ", "0.06619997649057771"}],
                  "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.007384865315507928"}], ",", " ", 
                  "0.06508252495431804"}], "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "9.595189226496714*^-18"}], ",", " ", 
                  RowBox[{"-", "0.05688284915968362"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "6.7220534694101275*^-18"}], ",", " ", 
                  RowBox[{"-", "0.05688284915968362"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.004052176560394734"}], ",", " ", 
                  RowBox[{"-", "0.0564921568493474"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.005730643048840595"}], ",", " ", 
                  RowBox[{"-", "0.0564921568493474"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "9.595189226496714*^-18"}], ",", " ", 
                  RowBox[{"-", "0.05688284915968362"}]}], "}"}]}], "}"}], ",",
               " ", "\n", "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.005730643048840595"}], ",", " ", 
                  RowBox[{"-", "0.0564921568493474"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.004052176560394734"}], ",", " ", 
                  RowBox[{"-", "0.0564921568493474"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.008229662822895223"}], ",", " ", 
                  RowBox[{"-", "0.05521682457414796"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.011638500777896077"}], ",", " ", 
                  RowBox[{"-", "0.05521682457414796"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.005730643048840595"}], ",", " ", 
                  RowBox[{"-", "0.0564921568493474"}]}], "}"}]}], "}"}], ",", 
              " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.01163850077789607"}], ",", " ", 
                  RowBox[{"-", "0.05521682457414796"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.008229662822895216"}], ",", " ", 
                  RowBox[{"-", "0.05521682457414796"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.01252426878792813"}], ",", " ", 
                  RowBox[{"-", "0.0530770008349515"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.017711990778694012"}], ",", " ", 
                  RowBox[{"-", "0.0530770008349515"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.01163850077789607"}], ",", " ", 
                  RowBox[{"-", "0.05521682457414796"}]}], "}"}]}], "}"}], ",",
               " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.017711990778694012"}], ",", " ", 
                  RowBox[{"-", "0.0530770008349515"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.01252426878792813"}], ",", " ", 
                  RowBox[{"-", "0.0530770008349515"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.016858481048417036"}], ",", " ", 
                  RowBox[{"-", "0.05009952120873742"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.02384149253968117"}], ",", " ", 
                  RowBox[{"-", "0.05009952120873742"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.017711990778694012"}], ",", " ", 
                  RowBox[{"-", "0.0530770008349515"}]}], "}"}]}], "}"}], ",", 
              " ", "\n", "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.023841492539681167"}], ",", " ", 
                  RowBox[{"-", "0.050099521208737424"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.016858481048417032"}], ",", " ", 
                  RowBox[{"-", "0.050099521208737424"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.021087188162310682"}], ",", " ", 
                  RowBox[{"-", "0.046318106341445356"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.029821787491453155"}], ",", " ", 
                  RowBox[{"-", "0.046318106341445356"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.023841492539681167"}], ",", " ", 
                  RowBox[{"-", "0.050099521208737424"}]}], "}"}]}], "}"}], 
              ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.029821787491453155"}], ",", " ", 
                  RowBox[{"-", "0.046318106341445356"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.021087188162310682"}], ",", " ", 
                  RowBox[{"-", "0.046318106341445356"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.025017504961568026"}], ",", " ", 
                  RowBox[{"-", "0.04177394503607659"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.03538009481338571"}], ",", " ", 
                  RowBox[{"-", "0.04177394503607659"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.029821787491453155"}], ",", " ", 
                  RowBox[{"-", "0.046318106341445356"}]}], "}"}]}], "}"}], 
              ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.03538009481338571"}], ",", " ", 
                  RowBox[{"-", "0.04177394503607659"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.025017504961568026"}], ",", " ", 
                  RowBox[{"-", "0.04177394503607659"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.028441850419286513"}], ",", " ", 
                  RowBox[{"-", "0.03651657383838262"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.04022285060194191"}], ",", " ", 
                  RowBox[{"-", "0.03651657383838262"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.03538009481338571"}], ",", " ", 
                  RowBox[{"-", "0.04177394503607659"}]}], "}"}]}], "}"}], ",",
               " ", "\n", "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.040222850601941904"}], ",", " ", 
                  RowBox[{"-", "0.03651657383838262"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.02844185041928651"}], ",", " ", 
                  RowBox[{"-", "0.03651657383838262"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.031176071551106816"}], ",", " ", 
                  RowBox[{"-", "0.03060493068010821"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.04408962320908928"}], ",", " ", 
                  RowBox[{"-", "0.03060493068010821"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.040222850601941904"}], ",", " ", 
                  RowBox[{"-", "0.03651657383838262"}]}], "}"}]}], "}"}], ",",
               " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.04408962320908929"}], ",", " ", 
                  RowBox[{"-", "0.0306049306801082"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.03117607155110682"}], ",", " ", 
                  RowBox[{"-", "0.0306049306801082"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.03309318179792082"}], ",", " ", 
                  RowBox[{"-", "0.024108435682384573"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.04680082652069807"}], ",", " ", 
                  RowBox[{"-", "0.024108435682384573"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.04408962320908929"}], ",", " ", 
                  RowBox[{"-", "0.0306049306801082"}]}], "}"}]}], "}"}], ",", 
              " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.04680082652069807"}], ",", " ", 
                  RowBox[{"-", "0.024108435682384573"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.03309318179792082"}], ",", " ", 
                  RowBox[{"-", "0.024108435682384573"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.034144494894767924"}], ",", " ", 
                  RowBox[{"-", "0.017107939026036665"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.04828760776055972"}], ",", " ", 
                  RowBox[{"-", "0.017107939026036665"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.04680082652069807"}], ",", " ", 
                  RowBox[{"-", "0.024108435682384573"}]}], "}"}]}], "}"}], 
              ",", " ", "\n", "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.04828760776055972"}], ",", " ", 
                  RowBox[{"-", "0.017107939026036665"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.034144494894767924"}], ",", " ", 
                  RowBox[{"-", "0.017107939026036665"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.03436324409774398"}], ",", " ", 
                  RowBox[{"-", "0.009696374951067403"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.048596965850166776"}], ",", " ", 
                  RowBox[{"-", "0.009696374951067403"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.04828760776055972"}], ",", " ", 
                  RowBox[{"-", "0.017107939026036665"}]}], "}"}]}], "}"}], 
              ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.048596965850166776"}], ",", " ", 
                  RowBox[{"-", "0.009696374951067403"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.03436324409774398"}], ",", " ", 
                  RowBox[{"-", "0.009696374951067403"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.03385029664901239"}], ",", " ", 
                  RowBox[{"-", "0.0019789726801209746"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.04787154861138586"}], ",", " ", 
                  RowBox[{"-", "0.0019789726801209746"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.048596965850166776"}], ",", " ", 
                  RowBox[{"-", "0.009696374951067403"}]}], "}"}]}], "}"}], 
              ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.04787154861138586"}], ",", " ", 
                  RowBox[{"-", "0.0019789726801209746"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.03385029664901239"}], ",", " ", 
                  RowBox[{"-", "0.0019789726801209746"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.03274611153671652"}], ",", " ", 
                  "0.005927101286260139"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.04630999505020658"}], ",", " ", 
                  "0.005927101286260139"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.04787154861138586"}], ",", " ", 
                  RowBox[{"-", "0.0019789726801209746"}]}], "}"}]}], "}"}], 
              ",", " ", "\n", "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.04630999505020658"}], ",", " ", 
                  "0.0059271012862601264"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.03274611153671652"}], ",", " ", 
                  "0.0059271012862601264"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.031196461036448145"}], ",", " ", 
                  "0.013893760977926984"}], "}"}], ",", " ", "\n", 
                "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.0441184582957888"}], ",", " ", 
                  "0.013893760977926984"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.04630999505020658"}], ",", " ", 
                  "0.0059271012862601264"}], "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.0441184582957888"}], ",", " ", 
                  "0.013893760977926984"}], "}"}], ",", " ", "\n", 
                "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.031196461036448145"}], ",", " ", 
                  "0.013893760977926984"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.02932078060493656"}], ",", " ", 
                  "0.021783728078581376"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.041465845590867294"}], ",", " ", 
                  "0.021783728078581376"}], "}"}], ",", " ", "\n", 
                "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.0441184582957888"}], ",", " ", 
                  "0.013893760977926984"}], "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.041465845590867294"}], ",", " ", 
                  "0.021783728078581376"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.02932078060493656"}], ",", " ", 
                  "0.021783728078581376"}], "}"}], ",", " ", "\n", 
                "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.027191010991264468"}], ",", " ", 
                  "0.02945296995204571"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.03845389651848211"}], ",", " ", 
                  "0.02945296995204571"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.041465845590867294"}], ",", " ", 
                  "0.021783728078581376"}], "}"}]}], "}"}], ",", " ", "\n", 
              "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.03845389651848211"}], ",", " ", 
                  "0.02945296995204571"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.027191010991264468"}], ",", " ", 
                  "0.02945296995204571"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.02482575884896321"}], ",", " ", 
                  "0.03675380039988509"}], "}"}], ",", " ", "\n", 
                "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.03510892486040766"}], ",", " ", 
                  "0.03675380039988509"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.03845389651848211"}], ",", " ", 
                  "0.02945296995204571"}], "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.03510892486040766"}], ",", " ", 
                  "0.03675380039988509"}], "}"}], ",", " ", "\n", 
                "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.02482575884896321"}], ",", " ", 
                  "0.03675380039988509"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.022200371573570948"}], ",", " ", 
                  "0.04353854648936185"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.03139606656906616"}], ",", " ", 
                  "0.04353854648936185"}], "}"}], ",", " ", "\n", 
                "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.03510892486040766"}], ",", " ", 
                  "0.03675380039988509"}], "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.03139606656906616"}], ",", " ", 
                  "0.04353854648936185"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.022200371573570948"}], ",", " ", 
                  "0.04353854648936185"}], "}"}], ",", " ", "\n", 
                "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.019269248035850308"}], ",", " ", 
                  "0.04966364092329548"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.027250831909030635"}], ",", " ", 
                  "0.04966364092329548"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.03139606656906616"}], ",", " ", 
                  "0.04353854648936185"}], "}"}]}], "}"}], ",", " ", "\n", 
              "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.02725083190903065"}], ",", " ", 
                  "0.049663640923295456"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.019269248035850315"}], ",", " ", 
                  "0.049663640923295456"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.01599353425715523"}], ",", " ", 
                  "0.054993963249953474"}], "}"}], ",", " ", "\n", 
                "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.022618273056747636"}], ",", " ", 
                  "0.054993963249953474"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.02725083190903065"}], ",", " ", 
                  "0.049663640923295456"}], "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.022618273056747636"}], ",", " ", 
                  "0.054993963249953474"}], "}"}], ",", " ", "\n", 
                "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.01599353425715523"}], ",", " ", 
                  "0.054993963249953474"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.012366115704645799"}], ",", " ", 
                  "0.0594072273124165"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.01748832854338501"}], ",", " ", 
                  "0.0594072273124165"}], "}"}], ",", " ", "\n", 
                "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.022618273056747636"}], ",", " ", 
                  "0.054993963249953474"}], "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.01748832854338501"}], ",", " ", 
                  "0.0594072273124165"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.012366115704645799"}], ",", " ", 
                  "0.0594072273124165"}], "}"}], ",", " ", "\n", 
                "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.00842681754099954"}], ",", " ", 
                  "0.06279819862535355"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.011917319654125048"}], ",", " ", 
                  "0.06279819862535355"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.01748832854338501"}], ",", " ", 
                  "0.0594072273124165"}], "}"}]}], "}"}], ",", " ", "\n", 
              "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.011917319654125048"}], ",", " ", 
                  "0.06279819862535355"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.00842681754099954"}], ",", " ", 
                  "0.06279819862535355"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.004263653977837631"}], ",", " ", 
                  "0.06508252495431804"}], "}"}], ",", " ", "\n", 
                "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.006029717280723975"}], ",", " ", 
                  "0.06508252495431804"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.011917319654125048"}], ",", " ", 
                  "0.06279819862535355"}], "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.006029717280723975"}], ",", " ", 
                  "0.06508252495431804"}], "}"}], ",", " ", "\n", 
                "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.004263653977837631"}], ",", " ", 
                  "0.06508252495431804"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "1.0625181290357943*^-17", ",", " ", "0.06619997649057771"}],
                  "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "1.5233040523421337*^-17", ",", " ", "0.06619997649057771"}],
                  "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.006029717280723975"}], ",", " ", 
                  "0.06508252495431804"}], "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "6.993104012531504*^-18"}], ",", " ", 
                  RowBox[{"-", "0.05688284915968362"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "3.415236843329339*^-18"}], ",", " ", 
                  RowBox[{"-", "0.05688284915968362"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.0020975609358963683"}], ",", " ", 
                  RowBox[{"-", "0.0564921568493474"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.004052176560394739"}], ",", " ", 
                  RowBox[{"-", "0.0564921568493474"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "6.993104012531504*^-18"}], ",", " ", 
                  RowBox[{"-", "0.05688284915968362"}]}], "}"}]}], "}"}], ",",
               " ", "\n", "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.004052176560394739"}], ",", " ", 
                  RowBox[{"-", "0.0564921568493474"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.0020975609358963683"}], ",", " ", 
                  RowBox[{"-", "0.0564921568493474"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.004259986946674921"}], ",", " ", 
                  RowBox[{"-", "0.05521682457414796"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.00822966282289523"}], ",", " ", 
                  RowBox[{"-", "0.05521682457414796"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.004052176560394739"}], ",", " ", 
                  RowBox[{"-", "0.0564921568493474"}]}], "}"}]}], "}"}], ",", 
              " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.008229662822895221"}], ",", " ", 
                  RowBox[{"-", "0.05521682457414796"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.004259986946674917"}], ",", " ", 
                  RowBox[{"-", "0.05521682457414796"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.0064830385765977366"}], ",", " ", 
                  RowBox[{"-", "0.0530770008349515"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.012524268787928141"}], ",", " ", 
                  RowBox[{"-", "0.0530770008349515"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.008229662822895221"}], ",", " ", 
                  RowBox[{"-", "0.05521682457414796"}]}], "}"}]}], "}"}], ",",
               " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.012524268787928141"}], ",", " ", 
                  RowBox[{"-", "0.0530770008349515"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.0064830385765977366"}], ",", " ", 
                  RowBox[{"-", "0.0530770008349515"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.008726591933660491"}], ",", " ", 
                  RowBox[{"-", "0.05009952120873742"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.01685848104841705"}], ",", " ", 
                  RowBox[{"-", "0.05009952120873742"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.012524268787928141"}], ",", " ", 
                  RowBox[{"-", "0.0530770008349515"}]}], "}"}]}], "}"}], ",", 
              " ", "\n", "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.016858481048417043"}], ",", " ", 
                  RowBox[{"-", "0.050099521208737424"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.00872659193366049"}], ",", " ", 
                  RowBox[{"-", "0.050099521208737424"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.010915531808132877"}], ",", " ", 
                  RowBox[{"-", "0.046318106341445356"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.021087188162310696"}], ",", " ", 
                  RowBox[{"-", "0.046318106341445356"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.016858481048417043"}], ",", " ", 
                  RowBox[{"-", "0.050099521208737424"}]}], "}"}]}], "}"}], 
              ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.021087188162310696"}], ",", " ", 
                  RowBox[{"-", "0.046318106341445356"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.010915531808132877"}], ",", " ", 
                  RowBox[{"-", "0.046318106341445356"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.012950013490001244"}], ",", " ", 
                  RowBox[{"-", "0.04177394503607659"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.02501750496156805"}], ",", " ", 
                  RowBox[{"-", "0.04177394503607659"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.021087188162310696"}], ",", " ", 
                  RowBox[{"-", "0.046318106341445356"}]}], "}"}]}], "}"}], 
              ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.02501750496156805"}], ",", " ", 
                  RowBox[{"-", "0.04177394503607659"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.012950013490001244"}], ",", " ", 
                  RowBox[{"-", "0.04177394503607659"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.014722585132936955"}], ",", " ", 
                  RowBox[{"-", "0.03651657383838262"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.02844185041928654"}], ",", " ", 
                  RowBox[{"-", "0.03651657383838262"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.02501750496156805"}], ",", " ", 
                  RowBox[{"-", "0.04177394503607659"}]}], "}"}]}], "}"}], ",",
               " ", "\n", "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.028441850419286537"}], ",", " ", 
                  RowBox[{"-", "0.03651657383838262"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.014722585132936953"}], ",", " ", 
                  RowBox[{"-", "0.03651657383838262"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.016137922137810682"}], ",", " ", 
                  RowBox[{"-", "0.03060493068010821"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.03117607155110684"}], ",", " ", 
                  RowBox[{"-", "0.03060493068010821"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.028441850419286537"}], ",", " ", 
                  RowBox[{"-", "0.03651657383838262"}]}], "}"}]}], "}"}], ",",
               " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.031176071551106844"}], ",", " ", 
                  RowBox[{"-", "0.0306049306801082"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.016137922137810685"}], ",", " ", 
                  RowBox[{"-", "0.0306049306801082"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.017130291424684"}], ",", " ", 
                  RowBox[{"-", "0.024108435682384573"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.03309318179792084"}], ",", " ", 
                  RowBox[{"-", "0.024108435682384573"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.031176071551106844"}], ",", " ", 
                  RowBox[{"-", "0.0306049306801082"}]}], "}"}]}], "}"}], ",", 
              " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.03309318179792084"}], ",", " ", 
                  RowBox[{"-", "0.024108435682384573"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.017130291424684"}], ",", " ", 
                  RowBox[{"-", "0.024108435682384573"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.017674491128343486"}], ",", " ", 
                  RowBox[{"-", "0.017107939026036665"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.03414449489476795"}], ",", " ", 
                  RowBox[{"-", "0.017107939026036665"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.03309318179792084"}], ",", " ", 
                  RowBox[{"-", "0.024108435682384573"}]}], "}"}]}], "}"}], 
              ",", " ", "\n", "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.03414449489476795"}], ",", " ", 
                  RowBox[{"-", "0.017107939026036665"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.017674491128343486"}], ",", " ", 
                  RowBox[{"-", "0.017107939026036665"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.017787724048005892"}], ",", " ", 
                  RowBox[{"-", "0.009696374951067403"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.03436324409774401"}], ",", " ", 
                  RowBox[{"-", "0.009696374951067403"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.03414449489476795"}], ",", " ", 
                  RowBox[{"-", "0.017107939026036665"}]}], "}"}]}], "}"}], 
              ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.03436324409774401"}], ",", " ", 
                  RowBox[{"-", "0.009696374951067403"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.017787724048005892"}], ",", " ", 
                  RowBox[{"-", "0.009696374951067403"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.017522202910268913"}], ",", " ", 
                  RowBox[{"-", "0.0019789726801209746"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.033850296649012415"}], ",", " ", 
                  RowBox[{"-", "0.0019789726801209746"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.03436324409774401"}], ",", " ", 
                  RowBox[{"-", "0.009696374951067403"}]}], "}"}]}], "}"}], 
              ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.033850296649012415"}], ",", " ", 
                  RowBox[{"-", "0.0019789726801209746"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.017522202910268913"}], ",", " ", 
                  RowBox[{"-", "0.0019789726801209746"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.016950634637507244"}], ",", " ", 
                  "0.005927101286260139"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.03274611153671655"}], ",", " ", 
                  "0.005927101286260139"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.033850296649012415"}], ",", " ", 
                  RowBox[{"-", "0.0019789726801209746"}]}], "}"}]}], "}"}], 
              ",", " ", "\n", "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.03274611153671655"}], ",", " ", 
                  "0.0059271012862601264"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.016950634637507244"}], ",", " ", 
                  "0.0059271012862601264"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.016148476512063033"}], ",", " ", 
                  "0.013893760977926984"}], "}"}], ",", " ", "\n", 
                "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.031196461036448166"}], ",", " ", 
                  "0.013893760977926984"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.03274611153671655"}], ",", " ", 
                  "0.0059271012862601264"}], "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.031196461036448166"}], ",", " ", 
                  "0.013893760977926984"}], "}"}], ",", " ", "\n", 
                "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.016148476512063033"}], ",", " ", 
                  "0.013893760977926984"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.015177552875660407"}], ",", " ", 
                  "0.021783728078581376"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.029320780604936585"}], ",", " ", 
                  "0.021783728078581376"}], "}"}], ",", " ", "\n", 
                "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.031196461036448166"}], ",", " ", 
                  "0.013893760977926984"}], "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.029320780604936585"}], ",", " ", 
                  "0.021783728078581376"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.015177552875660407"}], ",", " ", 
                  "0.021783728078581376"}], "}"}], ",", " ", "\n", 
                "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.014075103000262452"}], ",", " ", 
                  "0.02945296995204571"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.027191010991264485"}], ",", " ", 
                  "0.02945296995204571"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.029320780604936585"}], ",", " ", 
                  "0.021783728078581376"}], "}"}]}], "}"}], ",", " ", "\n", 
              "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.027191010991264485"}], ",", " ", 
                  "0.02945296995204571"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.014075103000262452"}], ",", " ", 
                  "0.02945296995204571"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.012850758398468245"}], ",", " ", 
                  "0.03675380039988509"}], "}"}], ",", " ", "\n", 
                "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.024825758848963226"}], ",", " ", 
                  "0.03675380039988509"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.027191010991264485"}], ",", " ", 
                  "0.02945296995204571"}], "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.024825758848963226"}], ",", " ", 
                  "0.03675380039988509"}], "}"}], ",", " ", "\n", 
                "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.012850758398468245"}], ",", " ", 
                  "0.03675380039988509"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.011491757943185575"}], ",", " ", 
                  "0.04353854648936185"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.02220037157357096"}], ",", " ", 
                  "0.04353854648936185"}], "}"}], ",", " ", "\n", 
                "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.024825758848963226"}], ",", " ", 
                  "0.03675380039988509"}], "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.02220037157357096"}], ",", " ", 
                  "0.04353854648936185"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.011491757943185575"}], ",", " ", 
                  "0.04353854648936185"}], "}"}], ",", " ", "\n", 
                "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.009974496752964817"}], ",", " ", 
                  "0.04966364092329548"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.019269248035850322"}], ",", " ", 
                  "0.04966364092329548"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.02220037157357096"}], ",", " ", 
                  "0.04353854648936185"}], "}"}]}], "}"}], ",", " ", "\n", 
              "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.019269248035850332"}], ",", " ", 
                  "0.049663640923295456"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.00997449675296482"}], ",", " ", 
                  "0.049663640923295456"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.008278862528502753"}], ",", " ", 
                  "0.054993963249953474"}], "}"}], ",", " ", "\n", 
                "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.015993534257155245"}], ",", " ", 
                  "0.054993963249953474"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.019269248035850332"}], ",", " ", 
                  "0.049663640923295456"}], "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.015993534257155245"}], ",", " ", 
                  "0.054993963249953474"}], "}"}], ",", " ", "\n", 
                "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.008278862528502753"}], ",", " ", 
                  "0.054993963249953474"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.0064011725166074306"}], ",", " ", 
                  "0.0594072273124165"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.012366115704645806"}], ",", " ", 
                  "0.0594072273124165"}], "}"}], ",", " ", "\n", 
                "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.015993534257155245"}], ",", " ", 
                  "0.054993963249953474"}], "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.012366115704645806"}], ",", " ", 
                  "0.0594072273124165"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.0064011725166074306"}], ",", " ", 
                  "0.0594072273124165"}], "}"}], ",", " ", "\n", 
                "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.004362041738429352"}], ",", " ", 
                  "0.06279819862535355"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.008426817540999547"}], ",", " ", 
                  "0.06279819862535355"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.012366115704645806"}], ",", " ", 
                  "0.0594072273124165"}], "}"}]}], "}"}], ",", " ", "\n", 
              "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.008426817540999547"}], ",", " ", 
                  "0.06279819862535355"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.004362041738429352"}], ",", " ", 
                  "0.06279819862535355"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.002207029702383003"}], ",", " ", 
                  "0.06508252495431804"}], "}"}], ",", " ", "\n", 
                "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.004263653977837635"}], ",", " ", 
                  "0.06508252495431804"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.008426817540999547"}], ",", " ", 
                  "0.06279819862535355"}], "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.004263653977837635"}], ",", " ", 
                  "0.06508252495431804"}], "}"}], ",", " ", "\n", 
                "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.002207029702383003"}], ",", " ", 
                  "0.06508252495431804"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "5.583641188300348*^-18", ",", " ", "0.06619997649057771"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "1.1058862159352145*^-17", ",", " ", "0.06619997649057771"}],
                  "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.004263653977837635"}], ",", " ", 
                  "0.06508252495431804"}], "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "3.5236570605778894*^-18"}], ",", " ", 
                  RowBox[{"-", "0.05688284915968362"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "2.202782373892901*^-33"}], ",", " ", 
                  RowBox[{"-", "0.05688284915968362"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "1.3032793814519085*^-18"}], ",", " ", 
                  RowBox[{"-", "0.0564921568493474"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.0020975609358963665"}], ",", " ", 
                  RowBox[{"-", "0.0564921568493474"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "3.5236570605778894*^-18"}], ",", " ", 
                  RowBox[{"-", "0.05688284915968362"}]}], "}"}]}], "}"}], ",",
               " ", "\n", "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.0020975609358963665"}], ",", " ", 
                  RowBox[{"-", "0.0564921568493474"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "1.3032793814519085*^-18"}], ",", " ", 
                  RowBox[{"-", "0.0564921568493474"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "2.6468614369399157*^-18"}], ",", " ", 
                  RowBox[{"-", "0.05521682457414796"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.004259986946674917"}], ",", " ", 
                  RowBox[{"-", "0.05521682457414796"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.0020975609358963665"}], ",", " ", 
                  RowBox[{"-", "0.0564921568493474"}]}], "}"}]}], "}"}], ",", 
              " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.004259986946674913"}], ",", " ", 
                  RowBox[{"-", "0.05521682457414796"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "2.6468614369399134*^-18"}], ",", " ", 
                  RowBox[{"-", "0.05521682457414796"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "4.0281120617010774*^-18"}], ",", " ", 
                  RowBox[{"-", "0.0530770008349515"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.006483038576597734"}], ",", " ", 
                  RowBox[{"-", "0.0530770008349515"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.004259986946674913"}], ",", " ", 
                  RowBox[{"-", "0.05521682457414796"}]}], "}"}]}], "}"}], ",",
               " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.006483038576597734"}], ",", " ", 
                  RowBox[{"-", "0.0530770008349515"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "4.0281120617010774*^-18"}], ",", " ", 
                  RowBox[{"-", "0.0530770008349515"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "5.422101042620754*^-18"}], ",", " ", 
                  RowBox[{"-", "0.05009952120873742"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.008726591933660488"}], ",", " ", 
                  RowBox[{"-", "0.05009952120873742"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.006483038576597734"}], ",", " ", 
                  RowBox[{"-", "0.0530770008349515"}]}], "}"}]}], "}"}], ",", 
              " ", "\n", "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.008726591933660485"}], ",", " ", 
                  RowBox[{"-", "0.050099521208737424"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "5.422101042620753*^-18"}], ",", " ", 
                  RowBox[{"-", "0.050099521208737424"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "6.782156980360972*^-18"}], ",", " ", 
                  RowBox[{"-", "0.046318106341445356"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.010915531808132869"}], ",", " ", 
                  RowBox[{"-", "0.046318106341445356"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.008726591933660485"}], ",", " ", 
                  RowBox[{"-", "0.050099521208737424"}]}], "}"}]}], "}"}], 
              ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.010915531808132869"}], ",", " ", 
                  RowBox[{"-", "0.046318106341445356"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "6.782156980360972*^-18"}], ",", " ", 
                  RowBox[{"-", "0.046318106341445356"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "8.046243273419037*^-18"}], ",", " ", 
                  RowBox[{"-", "0.04177394503607659"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.012950013490001234"}], ",", " ", 
                  RowBox[{"-", "0.04177394503607659"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.010915531808132869"}], ",", " ", 
                  RowBox[{"-", "0.046318106341445356"}]}], "}"}]}], "}"}], 
              ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.012950013490001234"}], ",", " ", 
                  RowBox[{"-", "0.04177394503607659"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "8.046243273419037*^-18"}], ",", " ", 
                  RowBox[{"-", "0.04177394503607659"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "9.147596771593921*^-18"}], ",", " ", 
                  RowBox[{"-", "0.03651657383838262"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.014722585132936943"}], ",", " ", 
                  RowBox[{"-", "0.03651657383838262"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.012950013490001234"}], ",", " ", 
                  RowBox[{"-", "0.04177394503607659"}]}], "}"}]}], "}"}], ",",
               " ", "\n", "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.01472258513293694"}], ",", " ", 
                  RowBox[{"-", "0.03651657383838262"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "9.14759677159392*^-18"}], ",", " ", 
                  RowBox[{"-", "0.03651657383838262"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "1.0026989357854863*^-17"}], ",", " ", 
                  RowBox[{"-", "0.03060493068010821"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.016137922137810668"}], ",", " ", 
                  RowBox[{"-", "0.03060493068010821"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.01472258513293694"}], ",", " ", 
                  RowBox[{"-", "0.03651657383838262"}]}], "}"}]}], "}"}], ",",
               " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.01613792213781067"}], ",", " ", 
                  RowBox[{"-", "0.0306049306801082"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "1.0026989357854864*^-17"}], ",", " ", 
                  RowBox[{"-", "0.0306049306801082"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "1.0643579039820616*^-17"}], ",", " ", 
                  RowBox[{"-", "0.024108435682384573"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.017130291424683988"}], ",", " ", 
                  RowBox[{"-", "0.024108435682384573"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.01613792213781067"}], ",", " ", 
                  RowBox[{"-", "0.0306049306801082"}]}], "}"}]}], "}"}], ",", 
              " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.017130291424683988"}], ",", " ", 
                  RowBox[{"-", "0.024108435682384573"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "1.0643579039820616*^-17"}], ",", " ", 
                  RowBox[{"-", "0.024108435682384573"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "1.0981707120408922*^-17"}], ",", " ", 
                  RowBox[{"-", "0.017107939026036665"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.017674491128343472"}], ",", " ", 
                  RowBox[{"-", "0.017107939026036665"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.017130291424683988"}], ",", " ", 
                  RowBox[{"-", "0.024108435682384573"}]}], "}"}]}], "}"}], 
              ",", " ", "\n", "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.017674491128343472"}], ",", " ", 
                  RowBox[{"-", "0.017107939026036665"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "1.0981707120408922*^-17"}], ",", " ", 
                  RowBox[{"-", "0.017107939026036665"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "1.1052062229989824*^-17"}], ",", " ", 
                  RowBox[{"-", "0.009696374951067403"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.01778772404800588"}], ",", " ", 
                  RowBox[{"-", "0.009696374951067403"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.017674491128343472"}], ",", " ", 
                  RowBox[{"-", "0.017107939026036665"}]}], "}"}]}], "}"}], 
              ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.01778772404800588"}], ",", " ", 
                  RowBox[{"-", "0.009696374951067403"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "1.1052062229989824*^-17"}], ",", " ", 
                  RowBox[{"-", "0.009696374951067403"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "1.0887085747909996*^-17"}], ",", " ", 
                  RowBox[{"-", "0.0019789726801209746"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.0175222029102689"}], ",", " ", 
                  RowBox[{"-", "0.0019789726801209746"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.01778772404800588"}], ",", " ", 
                  RowBox[{"-", "0.009696374951067403"}]}], "}"}]}], "}"}], 
              ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.0175222029102689"}], ",", " ", 
                  RowBox[{"-", "0.0019789726801209746"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "1.0887085747909996*^-17"}], ",", " ", 
                  RowBox[{"-", "0.0019789726801209746"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "1.053195273020625*^-17"}], ",", " ", 
                  "0.005927101286260139"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.01695063463750723"}], ",", " ", 
                  "0.005927101286260139"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.0175222029102689"}], ",", " ", 
                  RowBox[{"-", "0.0019789726801209746"}]}], "}"}]}], "}"}], 
              ",", " ", "\n", "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.01695063463750723"}], ",", " ", 
                  "0.0059271012862601264"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "1.053195273020625*^-17"}], ",", " ", 
                  "0.0059271012862601264"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "1.003354711649339*^-17"}], ",", " ", 
                  "0.013893760977926984"}], "}"}], ",", " ", "\n", 
                "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.016148476512063022"}], ",", " ", 
                  "0.013893760977926984"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.01695063463750723"}], ",", " ", 
                  "0.0059271012862601264"}], "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.016148476512063022"}], ",", " ", 
                  "0.013893760977926984"}], "}"}], ",", " ", "\n", 
                "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "1.003354711649339*^-17"}], ",", " ", 
                  "0.013893760977926984"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "9.430282279399587*^-18"}], ",", " ", 
                  "0.021783728078581376"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.015177552875660394"}], ",", " ", 
                  "0.021783728078581376"}], "}"}], ",", " ", "\n", 
                "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.016148476512063022"}], ",", " ", 
                  "0.013893760977926984"}], "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.015177552875660394"}], ",", " ", 
                  "0.021783728078581376"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "9.430282279399587*^-18"}], ",", " ", 
                  "0.021783728078581376"}], "}"}], ",", " ", "\n", 
                "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "8.745296128531755*^-18"}], ",", " ", 
                  "0.02945296995204571"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.014075103000262445"}], ",", " ", 
                  "0.02945296995204571"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.015177552875660394"}], ",", " ", 
                  "0.021783728078581376"}], "}"}]}], "}"}], ",", " ", "\n", 
              "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.014075103000262445"}], ",", " ", 
                  "0.02945296995204571"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "8.745296128531755*^-18"}], ",", " ", 
                  "0.02945296995204571"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "7.984573020085587*^-18"}], ",", " ", 
                  "0.03675380039988509"}], "}"}], ",", " ", "\n", 
                "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.012850758398468234"}], ",", " ", 
                  "0.03675380039988509"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.014075103000262445"}], ",", " ", 
                  "0.02945296995204571"}], "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.012850758398468234"}], ",", " ", 
                  "0.03675380039988509"}], "}"}], ",", " ", "\n", 
                "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "7.984573020085587*^-18"}], ",", " ", 
                  "0.03675380039988509"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "7.140184071739357*^-18"}], ",", " ", 
                  "0.04353854648936185"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.011491757943185563"}], ",", " ", 
                  "0.04353854648936185"}], "}"}], ",", " ", "\n", 
                "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.012850758398468234"}], ",", " ", 
                  "0.03675380039988509"}], "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.011491757943185563"}], ",", " ", 
                  "0.04353854648936185"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "7.140184071739357*^-18"}], ",", " ", 
                  "0.04353854648936185"}], "}"}], ",", " ", "\n", 
                "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "6.197462841737585*^-18"}], ",", " ", 
                  "0.04966364092329548"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.009974496752964808"}], ",", " ", 
                  "0.04966364092329548"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.011491757943185563"}], ",", " ", 
                  "0.04353854648936185"}], "}"}]}], "}"}], ",", " ", "\n", 
              "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.009974496752964813"}], ",", " ", 
                  "0.049663640923295456"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "6.1974628417375896*^-18"}], ",", " ", 
                  "0.049663640923295456"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "5.143912937462107*^-18"}], ",", " ", 
                  "0.054993963249953474"}], "}"}], ",", " ", "\n", 
                "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.008278862528502748"}], ",", " ", 
                  "0.054993963249953474"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.009974496752964813"}], ",", " ", 
                  "0.049663640923295456"}], "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.008278862528502748"}], ",", " ", 
                  "0.054993963249953474"}], "}"}], ",", " ", "\n", 
                "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "5.143912937462107*^-18"}], ",", " ", 
                  "0.054993963249953474"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "3.9772461506325744*^-18"}], ",", " ", 
                  "0.0594072273124165"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.006401172516607426"}], ",", " ", 
                  "0.0594072273124165"}], "}"}], ",", " ", "\n", 
                "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.008278862528502748"}], ",", " ", 
                  "0.054993963249953474"}], "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.006401172516607426"}], ",", " ", 
                  "0.0594072273124165"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "3.9772461506325744*^-18"}], ",", " ", 
                  "0.0594072273124165"}], "}"}], ",", " ", "\n", 
                "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "2.7102712304747488*^-18"}], ",", " ", 
                  "0.06279819862535355"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.0043620417384293494"}], ",", " ", 
                  "0.06279819862535355"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.006401172516607426"}], ",", " ", 
                  "0.0594072273124165"}], "}"}]}], "}"}], ",", " ", "\n", 
              "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.0043620417384293494"}], ",", " ", 
                  "0.06279819862535355"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "2.7102712304747488*^-18"}], ",", " ", 
                  "0.06279819862535355"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "1.371295706428917*^-18"}], ",", " ", 
                  "0.06508252495431804"}], "}"}], ",", " ", "\n", 
                "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.0022070297023830017"}], ",", " ", 
                  "0.06508252495431804"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.0043620417384293494"}], ",", " ", 
                  "0.06279819862535355"}], "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.0022070297023830017"}], ",", " ", 
                  "0.06508252495431804"}], "}"}], ",", " ", "\n", 
                "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "1.371295706428917*^-18"}], ",", " ", 
                  "0.06508252495431804"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "3.538896272811546*^-33", ",", " ", "0.06619997649057771"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "5.854691731421724*^-18", ",", " ", "0.06619997649057771"}], 
                 "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.0022070297023830017"}], ",", " ", 
                  "0.06508252495431804"}], "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"7.884275709835247*^-34", ",", " ", 
                  RowBox[{"-", "0.05688284915968362"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"3.604972223514302*^-18", ",", " ", 
                  RowBox[{"-", "0.05688284915968362"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"0.0020975609358963657", ",", " ", 
                  RowBox[{"-", "0.0564921568493474"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"4.962485054267345*^-19", ",", " ", 
                  RowBox[{"-", "0.0564921568493474"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"7.884275709835247*^-34", ",", " ", 
                  RowBox[{"-", "0.05688284915968362"}]}], "}"}]}], "}"}], ",",
               " ", "\n", "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"4.962485054267345*^-19", ",", " ", 
                  RowBox[{"-", "0.0564921568493474"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.0020975609358963657", ",", " ", 
                  RowBox[{"-", "0.0564921568493474"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.004259986946674917", ",", " ", 
                  RowBox[{"-", "0.05521682457414796"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"1.0078430234120608*^-18", ",", " ", 
                  RowBox[{"-", "0.05521682457414796"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"4.962485054267345*^-19", ",", " ", 
                  RowBox[{"-", "0.0564921568493474"}]}], "}"}]}], "}"}], ",", 
              " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"1.0078430234120602*^-18", ",", " ", 
                  RowBox[{"-", "0.05521682457414796"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"0.0042599869466749115", ",", " ", 
                  RowBox[{"-", "0.05521682457414796"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.006483038576597731", ",", " ", 
                  RowBox[{"-", "0.0530770008349515"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"1.533780568279729*^-18", ",", " ", 
                  RowBox[{"-", "0.0530770008349515"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"1.0078430234120602*^-18", ",", " ", 
                  RowBox[{"-", "0.05521682457414796"}]}], "}"}]}], "}"}], ",",
               " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"1.533780568279729*^-18", ",", " ", 
                  RowBox[{"-", "0.0530770008349515"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.006483038576597731", ",", " ", 
                  RowBox[{"-", "0.0530770008349515"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"0.008726591933660483", ",", " ", 
                  RowBox[{"-", "0.05009952120873742"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"2.0645684854430247*^-18", ",", " ", 
                  RowBox[{"-", "0.05009952120873742"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"1.533780568279729*^-18", ",", " ", 
                  RowBox[{"-", "0.0530770008349515"}]}], "}"}]}], "}"}], ",", 
              " ", "\n", "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"2.0645684854430243*^-18", ",", " ", 
                  RowBox[{"-", "0.050099521208737424"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.008726591933660481", ",", " ", 
                  RowBox[{"-", "0.050099521208737424"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.010915531808132864", ",", " ", 
                  RowBox[{"-", "0.046318106341445356"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"2.5824357485991746*^-18", ",", " ", 
                  RowBox[{"-", "0.046318106341445356"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"2.0645684854430243*^-18", ",", " ", 
                  RowBox[{"-", "0.050099521208737424"}]}], "}"}]}], "}"}], 
              ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"2.5824357485991746*^-18", ",", " ", 
                  RowBox[{"-", "0.046318106341445356"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"0.010915531808132864", ",", " ", 
                  RowBox[{"-", "0.046318106341445356"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.012950013490001229", ",", " ", 
                  RowBox[{"-", "0.04177394503607659"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"3.0637607373837326*^-18", ",", " ", 
                  RowBox[{"-", "0.04177394503607659"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"2.5824357485991746*^-18", ",", " ", 
                  RowBox[{"-", "0.046318106341445356"}]}], "}"}]}], "}"}], 
              ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"3.0637607373837326*^-18", ",", " ", 
                  RowBox[{"-", "0.04177394503607659"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.012950013490001229", ",", " ", 
                  RowBox[{"-", "0.04177394503607659"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"0.014722585132936937", ",", " ", 
                  RowBox[{"-", "0.03651657383838262"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"3.4831221077807054*^-18", ",", " ", 
                  RowBox[{"-", "0.03651657383838262"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"3.0637607373837326*^-18", ",", " ", 
                  RowBox[{"-", "0.04177394503607659"}]}], "}"}]}], "}"}], ",",
               " ", "\n", "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"3.483122107780705*^-18", ",", " ", 
                  RowBox[{"-", "0.03651657383838262"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.014722585132936936", ",", " ", 
                  RowBox[{"-", "0.03651657383838262"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.016137922137810665", ",", " ", 
                  RowBox[{"-", "0.03060493068010821"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"3.817967623505183*^-18", ",", " ", 
                  RowBox[{"-", "0.03060493068010821"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"3.483122107780705*^-18", ",", " ", 
                  RowBox[{"-", "0.03651657383838262"}]}], "}"}]}], "}"}], ",",
               " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"3.817967623505185*^-18", ",", " ", 
                  RowBox[{"-", "0.0306049306801082"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"0.016137922137810668", ",", " ", 
                  RowBox[{"-", "0.0306049306801082"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.01713029142468398", ",", " ", 
                  RowBox[{"-", "0.024108435682384573"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"4.0527459162425184*^-18", ",", " ", 
                  RowBox[{"-", "0.024108435682384573"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"3.817967623505185*^-18", ",", " ", 
                  RowBox[{"-", "0.0306049306801082"}]}], "}"}]}], "}"}], ",", 
              " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"4.0527459162425184*^-18", ",", " ", 
                  RowBox[{"-", "0.024108435682384573"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.01713029142468398", ",", " ", 
                  RowBox[{"-", "0.024108435682384573"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"0.017674491128343465", ",", " ", 
                  RowBox[{"-", "0.017107939026036665"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"4.18149463813807*^-18", ",", " ", 
                  RowBox[{"-", "0.017107939026036665"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"4.0527459162425184*^-18", ",", " ", 
                  RowBox[{"-", "0.024108435682384573"}]}], "}"}]}], "}"}], 
              ",", " ", "\n", "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"4.18149463813807*^-18", ",", " ", 
                  RowBox[{"-", "0.017107939026036665"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.017674491128343465", ",", " ", 
                  RowBox[{"-", "0.017107939026036665"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.01778772404800587", ",", " ", 
                  RowBox[{"-", "0.009696374951067403"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"4.208283689262138*^-18", ",", " ", 
                  RowBox[{"-", "0.009696374951067403"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"4.18149463813807*^-18", ",", " ", 
                  RowBox[{"-", "0.017107939026036665"}]}], "}"}]}], "}"}], 
              ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"4.208283689262138*^-18", ",", " ", 
                  RowBox[{"-", "0.009696374951067403"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"0.01778772404800587", ",", " ", 
                  RowBox[{"-", "0.009696374951067403"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.017522202910268892", ",", " ", 
                  RowBox[{"-", "0.0019789726801209746"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"4.1454657441401395*^-18", ",", " ", 
                  RowBox[{"-", "0.0019789726801209746"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"4.208283689262138*^-18", ",", " ", 
                  RowBox[{"-", "0.009696374951067403"}]}], "}"}]}], "}"}], 
              ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"4.1454657441401395*^-18", ",", " ", 
                  RowBox[{"-", "0.0019789726801209746"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.017522202910268892", ",", " ", 
                  RowBox[{"-", "0.0019789726801209746"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.016950634637507223", ",", " ", "0.005927101286260139"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "4.0102420677962115*^-18", ",", " ", 
                  "0.005927101286260139"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"4.1454657441401395*^-18", ",", " ", 
                  RowBox[{"-", "0.0019789726801209746"}]}], "}"}]}], "}"}], 
              ",", " ", "\n", "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                 "4.0102420677962115*^-18", ",", " ", 
                  "0.0059271012862601264"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.016950634637507223", ",", " ", "0.0059271012862601264"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.016148476512063015", ",", " ", "0.013893760977926984"}], 
                 "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "3.820464615301136*^-18", ",", " ", "0.013893760977926984"}],
                  "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "4.0102420677962115*^-18", ",", " ", 
                  "0.0059271012862601264"}], "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                 "3.820464615301136*^-18", ",", " ", "0.013893760977926984"}],
                  "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.016148476512063015", ",", " ", "0.013893760977926984"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.015177552875660388", ",", " ", "0.021783728078581376"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "3.590760011633737*^-18", ",", " ", "0.021783728078581376"}],
                  "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "3.820464615301136*^-18", ",", " ", "0.013893760977926984"}],
                  "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                 "3.590760011633737*^-18", ",", " ", "0.021783728078581376"}],
                  "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.015177552875660388", ",", " ", "0.021783728078581376"}], 
                 "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.014075103000262438", ",", " ", "0.02945296995204571"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "3.3299384576032546*^-18", ",", " ", "0.02945296995204571"}],
                  "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "3.590760011633737*^-18", ",", " ", "0.021783728078581376"}],
                  "}"}]}], "}"}], ",", " ", "\n", "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                 "3.3299384576032546*^-18", ",", " ", "0.02945296995204571"}],
                  "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.014075103000262438", ",", " ", "0.02945296995204571"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.01285075839846823", ",", " ", "0.03675380039988509"}], 
                 "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "3.040278611078688*^-18", ",", " ", "0.03675380039988509"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "3.3299384576032546*^-18", ",", " ", "0.02945296995204571"}],
                  "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                 "3.040278611078688*^-18", ",", " ", "0.03675380039988509"}], 
                 "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.01285075839846823", ",", " ", "0.03675380039988509"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.01149175794318556", ",", " ", "0.04353854648936185"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "2.7187613987455556*^-18", ",", " ", "0.04353854648936185"}],
                  "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "3.040278611078688*^-18", ",", " ", "0.03675380039988509"}], 
                 "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                 "2.7187613987455556*^-18", ",", " ", "0.04353854648936185"}],
                  "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.01149175794318556", ",", " ", "0.04353854648936185"}], 
                 "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.009974496752964804", ",", " ", "0.04966364092329548"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "2.3598022929080513*^-18", ",", " ", "0.04966364092329548"}],
                  "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "2.7187613987455556*^-18", ",", " ", "0.04353854648936185"}],
                  "}"}]}], "}"}], ",", " ", "\n", "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                 "2.3598022929080517*^-18", ",", " ", 
                  "0.049663640923295456"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.009974496752964808", ",", " ", "0.049663640923295456"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.008278862528502743", ",", " ", "0.054993963249953474"}], 
                 "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "1.95864305350787*^-18", ",", " ", "0.054993963249953474"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "2.3598022929080517*^-18", ",", " ", 
                  "0.049663640923295456"}], "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                 "1.95864305350787*^-18", ",", " ", "0.054993963249953474"}], 
                 "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.008278862528502743", ",", " ", "0.054993963249953474"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.006401172516607424", ",", " ", "0.0594072273124165"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "1.5144124015580296*^-18", ",", " ", "0.0594072273124165"}], 
                 "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "1.95864305350787*^-18", ",", " ", "0.054993963249953474"}], 
                 "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                 "1.5144124015580296*^-18", ",", " ", "0.0594072273124165"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.006401172516607424", ",", " ", "0.0594072273124165"}], 
                 "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.004362041738429349", ",", " ", "0.06279819862535355"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "1.031987512858386*^-18", ",", " ", "0.06279819862535355"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "1.5144124015580296*^-18", ",", " ", "0.0594072273124165"}], 
                 "}"}]}], "}"}], ",", " ", "\n", "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                 "1.031987512858386*^-18", ",", " ", "0.06279819862535355"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.004362041738429349", ",", " ", "0.06279819862535355"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.0022070297023830004", ",", " ", "0.06508252495431804"}], 
                 "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "5.221470196630737*^-19", ",", " ", "0.06508252495431804"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "1.031987512858386*^-18", ",", " ", "0.06279819862535355"}], 
                 "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                 "5.221470196630737*^-19", ",", " ", "0.06508252495431804"}], 
                 "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.0022070297023830004", ",", " ", "0.06508252495431804"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "5.637851296924623*^-18"}], ",", " ", 
                  "0.06619997649057771"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "1.3000027124613842*^-33"}], ",", " ", 
                  "0.06619997649057771"}], "}"}], ",", " ", "\n", 
                "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "5.221470196630737*^-19", ",", " ", "0.06508252495431804"}], 
                 "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"3.604972223514302*^-18", ",", " ", 
                  RowBox[{"-", "0.05688284915968362"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"6.7220534694101275*^-18", ",", " ", 
                  RowBox[{"-", "0.05688284915968362"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"0.004052176560394736", ",", " ", 
                  RowBox[{"-", "0.0564921568493474"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.0020975609358963657", ",", " ", 
                  RowBox[{"-", "0.0564921568493474"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"3.604972223514302*^-18", ",", " ", 
                  RowBox[{"-", "0.05688284915968362"}]}], "}"}]}], "}"}], ",",
               " ", "\n", "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"0.0020975609358963657", ",", " ", 
                  RowBox[{"-", "0.0564921568493474"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.004052176560394736", ",", " ", 
                  RowBox[{"-", "0.0564921568493474"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.008229662822895225", ",", " ", 
                  RowBox[{"-", "0.05521682457414796"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"0.004259986946674917", ",", " ", 
                  RowBox[{"-", "0.05521682457414796"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.0020975609358963657", ",", " ", 
                  RowBox[{"-", "0.0564921568493474"}]}], "}"}]}], "}"}], ",", 
              " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"0.0042599869466749115", ",", " ", 
                  RowBox[{"-", "0.05521682457414796"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"0.008229662822895218", ",", " ", 
                  RowBox[{"-", "0.05521682457414796"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.012524268787928132", ",", " ", 
                  RowBox[{"-", "0.0530770008349515"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.006483038576597731", ",", " ", 
                  RowBox[{"-", "0.0530770008349515"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"0.0042599869466749115", ",", " ", 
                  RowBox[{"-", "0.05521682457414796"}]}], "}"}]}], "}"}], ",",
               " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"0.006483038576597731", ",", " ", 
                  RowBox[{"-", "0.0530770008349515"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.012524268787928132", ",", " ", 
                  RowBox[{"-", "0.0530770008349515"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"0.01685848104841704", ",", " ", 
                  RowBox[{"-", "0.05009952120873742"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.008726591933660483", ",", " ", 
                  RowBox[{"-", "0.05009952120873742"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.006483038576597731", ",", " ", 
                  RowBox[{"-", "0.0530770008349515"}]}], "}"}]}], "}"}], ",", 
              " ", "\n", "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"0.008726591933660481", ",", " ", 
                  RowBox[{"-", "0.050099521208737424"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.016858481048417032", ",", " ", 
                  RowBox[{"-", "0.050099521208737424"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.021087188162310682", ",", " ", 
                  RowBox[{"-", "0.046318106341445356"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"0.010915531808132864", ",", " ", 
                  RowBox[{"-", "0.046318106341445356"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.008726591933660481", ",", " ", 
                  RowBox[{"-", "0.050099521208737424"}]}], "}"}]}], "}"}], 
              ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"0.010915531808132864", ",", " ", 
                  RowBox[{"-", "0.046318106341445356"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"0.021087188162310682", ",", " ", 
                  RowBox[{"-", "0.046318106341445356"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.025017504961568033", ",", " ", 
                  RowBox[{"-", "0.04177394503607659"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.012950013490001229", ",", " ", 
                  RowBox[{"-", "0.04177394503607659"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"0.010915531808132864", ",", " ", 
                  RowBox[{"-", "0.046318106341445356"}]}], "}"}]}], "}"}], 
              ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"0.012950013490001229", ",", " ", 
                  RowBox[{"-", "0.04177394503607659"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.025017504961568033", ",", " ", 
                  RowBox[{"-", "0.04177394503607659"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"0.02844185041928652", ",", " ", 
                  RowBox[{"-", "0.03651657383838262"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.014722585132936937", ",", " ", 
                  RowBox[{"-", "0.03651657383838262"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.012950013490001229", ",", " ", 
                  RowBox[{"-", "0.04177394503607659"}]}], "}"}]}], "}"}], ",",
               " ", "\n", "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"0.014722585132936936", ",", " ", 
                  RowBox[{"-", "0.03651657383838262"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.028441850419286516", ",", " ", 
                  RowBox[{"-", "0.03651657383838262"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.031176071551106823", ",", " ", 
                  RowBox[{"-", "0.03060493068010821"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"0.016137922137810665", ",", " ", 
                  RowBox[{"-", "0.03060493068010821"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.014722585132936936", ",", " ", 
                  RowBox[{"-", "0.03651657383838262"}]}], "}"}]}], "}"}], ",",
               " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"0.016137922137810668", ",", " ", 
                  RowBox[{"-", "0.0306049306801082"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"0.031176071551106826", ",", " ", 
                  RowBox[{"-", "0.0306049306801082"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.03309318179792082", ",", " ", 
                  RowBox[{"-", "0.024108435682384573"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.01713029142468398", ",", " ", 
                  RowBox[{"-", "0.024108435682384573"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"0.016137922137810668", ",", " ", 
                  RowBox[{"-", "0.0306049306801082"}]}], "}"}]}], "}"}], ",", 
              " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"0.01713029142468398", ",", " ", 
                  RowBox[{"-", "0.024108435682384573"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.03309318179792082", ",", " ", 
                  RowBox[{"-", "0.024108435682384573"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"0.03414449489476793", ",", " ", 
                  RowBox[{"-", "0.017107939026036665"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.017674491128343465", ",", " ", 
                  RowBox[{"-", "0.017107939026036665"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.01713029142468398", ",", " ", 
                  RowBox[{"-", "0.024108435682384573"}]}], "}"}]}], "}"}], 
              ",", " ", "\n", "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"0.017674491128343465", ",", " ", 
                  RowBox[{"-", "0.017107939026036665"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.03414449489476793", ",", " ", 
                  RowBox[{"-", "0.017107939026036665"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.03436324409774399", ",", " ", 
                  RowBox[{"-", "0.009696374951067403"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"0.01778772404800587", ",", " ", 
                  RowBox[{"-", "0.009696374951067403"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.017674491128343465", ",", " ", 
                  RowBox[{"-", "0.017107939026036665"}]}], "}"}]}], "}"}], 
              ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"0.01778772404800587", ",", " ", 
                  RowBox[{"-", "0.009696374951067403"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"0.03436324409774399", ",", " ", 
                  RowBox[{"-", "0.009696374951067403"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.033850296649012394", ",", " ", 
                  RowBox[{"-", "0.0019789726801209746"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.017522202910268892", ",", " ", 
                  RowBox[{"-", "0.0019789726801209746"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"0.01778772404800587", ",", " ", 
                  RowBox[{"-", "0.009696374951067403"}]}], "}"}]}], "}"}], 
              ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"0.017522202910268892", ",", " ", 
                  RowBox[{"-", "0.0019789726801209746"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.033850296649012394", ",", " ", 
                  RowBox[{"-", "0.0019789726801209746"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.03274611153671653", ",", " ", "0.005927101286260139"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.016950634637507223", ",", " ", "0.005927101286260139"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.017522202910268892", ",", " ", 
                  RowBox[{"-", "0.0019789726801209746"}]}], "}"}]}], "}"}], 
              ",", " ", "\n", "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                 "0.016950634637507223", ",", " ", "0.0059271012862601264"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.03274611153671653", ",", " ", "0.0059271012862601264"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.031196461036448145", ",", " ", "0.013893760977926984"}], 
                 "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.016148476512063015", ",", " ", "0.013893760977926984"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.016950634637507223", ",", " ", "0.0059271012862601264"}], 
                 "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                 "0.016148476512063015", ",", " ", "0.013893760977926984"}], 
                 "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.031196461036448145", ",", " ", "0.013893760977926984"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.029320780604936567", ",", " ", "0.021783728078581376"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.015177552875660388", ",", " ", "0.021783728078581376"}], 
                 "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.016148476512063015", ",", " ", "0.013893760977926984"}], 
                 "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                 "0.015177552875660388", ",", " ", "0.021783728078581376"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.029320780604936567", ",", " ", "0.021783728078581376"}], 
                 "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.02719101099126447", ",", " ", "0.02945296995204571"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.014075103000262438", ",", " ", "0.02945296995204571"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.015177552875660388", ",", " ", "0.021783728078581376"}], 
                 "}"}]}], "}"}], ",", " ", "\n", "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                 "0.014075103000262438", ",", " ", "0.02945296995204571"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.02719101099126447", ",", " ", "0.02945296995204571"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.024825758848963212", ",", " ", "0.03675380039988509"}], 
                 "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.01285075839846823", ",", " ", "0.03675380039988509"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.014075103000262438", ",", " ", "0.02945296995204571"}], 
                 "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                 "0.01285075839846823", ",", " ", "0.03675380039988509"}], 
                 "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.024825758848963212", ",", " ", "0.03675380039988509"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.02220037157357095", ",", " ", "0.04353854648936185"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.01149175794318556", ",", " ", "0.04353854648936185"}], 
                 "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.01285075839846823", ",", " ", "0.03675380039988509"}], 
                 "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                 "0.01149175794318556", ",", " ", "0.04353854648936185"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.02220037157357095", ",", " ", "0.04353854648936185"}], 
                 "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.019269248035850308", ",", " ", "0.04966364092329548"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.009974496752964804", ",", " ", "0.04966364092329548"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.01149175794318556", ",", " ", "0.04353854648936185"}], 
                 "}"}]}], "}"}], ",", " ", "\n", "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                 "0.009974496752964808", ",", " ", "0.049663640923295456"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.019269248035850325", ",", " ", "0.049663640923295456"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.015993534257155235", ",", " ", "0.054993963249953474"}], 
                 "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.008278862528502743", ",", " ", "0.054993963249953474"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.009974496752964808", ",", " ", "0.049663640923295456"}], 
                 "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                 "0.008278862528502743", ",", " ", "0.054993963249953474"}], 
                 "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.015993534257155235", ",", " ", "0.054993963249953474"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.012366115704645799", ",", " ", "0.0594072273124165"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.006401172516607424", ",", " ", "0.0594072273124165"}], 
                 "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.008278862528502743", ",", " ", "0.054993963249953474"}], 
                 "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                 "0.006401172516607424", ",", " ", "0.0594072273124165"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.012366115704645799", ",", " ", "0.0594072273124165"}], 
                 "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.008426817540999542", ",", " ", "0.06279819862535355"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.004362041738429349", ",", " ", "0.06279819862535355"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.006401172516607424", ",", " ", "0.0594072273124165"}], 
                 "}"}]}], "}"}], ",", " ", "\n", "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                 "0.004362041738429349", ",", " ", "0.06279819862535355"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.008426817540999542", ",", " ", "0.06279819862535355"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.004263653977837632", ",", " ", "0.06508252495431804"}], 
                 "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.0022070297023830004", ",", " ", "0.06508252495431804"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.004362041738429349", ",", " ", "0.06279819862535355"}], 
                 "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                 "0.0022070297023830004", ",", " ", "0.06508252495431804"}], 
                 "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.004263653977837632", ",", " ", "0.06508252495431804"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "1.0625181290357943*^-17"}], ",", " ", 
                  "0.06619997649057771"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "5.637851296924623*^-18"}], ",", " ", 
                  "0.06619997649057771"}], "}"}], ",", " ", "\n", 
                "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.0022070297023830004", ",", " ", "0.06508252495431804"}], 
                 "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"6.7220534694101275*^-18", ",", " ", 
                  RowBox[{"-", "0.05688284915968362"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"9.161508357502512*^-18", ",", " ", 
                  RowBox[{"-", "0.05688284915968362"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"0.005730643048840594", ",", " ", 
                  RowBox[{"-", "0.0564921568493474"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.004052176560394736", ",", " ", 
                  RowBox[{"-", "0.0564921568493474"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"6.7220534694101275*^-18", ",", " ", 
                  RowBox[{"-", "0.05688284915968362"}]}], "}"}]}], "}"}], ",",
               " ", "\n", "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"0.004052176560394736", ",", " ", 
                  RowBox[{"-", "0.0564921568493474"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.005730643048840594", ",", " ", 
                  RowBox[{"-", "0.0564921568493474"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.011638500777896077", ",", " ", 
                  RowBox[{"-", "0.05521682457414796"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"0.008229662822895225", ",", " ", 
                  RowBox[{"-", "0.05521682457414796"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.004052176560394736", ",", " ", 
                  RowBox[{"-", "0.0564921568493474"}]}], "}"}]}], "}"}], ",", 
              " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"0.008229662822895218", ",", " ", 
                  RowBox[{"-", "0.05521682457414796"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"0.011638500777896067", ",", " ", 
                  RowBox[{"-", "0.05521682457414796"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.01771199077869401", ",", " ", 
                  RowBox[{"-", "0.0530770008349515"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.012524268787928132", ",", " ", 
                  RowBox[{"-", "0.0530770008349515"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"0.008229662822895218", ",", " ", 
                  RowBox[{"-", "0.05521682457414796"}]}], "}"}]}], "}"}], ",",
               " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"0.012524268787928132", ",", " ", 
                  RowBox[{"-", "0.0530770008349515"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.01771199077869401", ",", " ", 
                  RowBox[{"-", "0.0530770008349515"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"0.023841492539681167", ",", " ", 
                  RowBox[{"-", "0.05009952120873742"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.01685848104841704", ",", " ", 
                  RowBox[{"-", "0.05009952120873742"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.012524268787928132", ",", " ", 
                  RowBox[{"-", "0.0530770008349515"}]}], "}"}]}], "}"}], ",", 
              " ", "\n", "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"0.016858481048417032", ",", " ", 
                  RowBox[{"-", "0.050099521208737424"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.02384149253968116", ",", " ", 
                  RowBox[{"-", "0.050099521208737424"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.029821787491453155", ",", " ", 
                  RowBox[{"-", "0.046318106341445356"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"0.021087188162310682", ",", " ", 
                  RowBox[{"-", "0.046318106341445356"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.016858481048417032", ",", " ", 
                  RowBox[{"-", "0.050099521208737424"}]}], "}"}]}], "}"}], 
              ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"0.021087188162310682", ",", " ", 
                  RowBox[{"-", "0.046318106341445356"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"0.029821787491453155", ",", " ", 
                  RowBox[{"-", "0.046318106341445356"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.03538009481338571", ",", " ", 
                  RowBox[{"-", "0.04177394503607659"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.025017504961568033", ",", " ", 
                  RowBox[{"-", "0.04177394503607659"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"0.021087188162310682", ",", " ", 
                  RowBox[{"-", "0.046318106341445356"}]}], "}"}]}], "}"}], 
              ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"0.025017504961568033", ",", " ", 
                  RowBox[{"-", "0.04177394503607659"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.03538009481338571", ",", " ", 
                  RowBox[{"-", "0.04177394503607659"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"0.0402228506019419", ",", " ", 
                  RowBox[{"-", "0.03651657383838262"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.02844185041928652", ",", " ", 
                  RowBox[{"-", "0.03651657383838262"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.025017504961568033", ",", " ", 
                  RowBox[{"-", "0.04177394503607659"}]}], "}"}]}], "}"}], ",",
               " ", "\n", "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"0.028441850419286516", ",", " ", 
                  RowBox[{"-", "0.03651657383838262"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.0402228506019419", ",", " ", 
                  RowBox[{"-", "0.03651657383838262"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.044089623209089275", ",", " ", 
                  RowBox[{"-", "0.03060493068010821"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"0.031176071551106823", ",", " ", 
                  RowBox[{"-", "0.03060493068010821"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.028441850419286516", ",", " ", 
                  RowBox[{"-", "0.03651657383838262"}]}], "}"}]}], "}"}], ",",
               " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"0.031176071551106826", ",", " ", 
                  RowBox[{"-", "0.0306049306801082"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"0.04408962320908928", ",", " ", 
                  RowBox[{"-", "0.0306049306801082"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.046800826520698065", ",", " ", 
                  RowBox[{"-", "0.024108435682384573"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.03309318179792082", ",", " ", 
                  RowBox[{"-", "0.024108435682384573"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"0.031176071551106826", ",", " ", 
                  RowBox[{"-", "0.0306049306801082"}]}], "}"}]}], "}"}], ",", 
              " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"0.03309318179792082", ",", " ", 
                  RowBox[{"-", "0.024108435682384573"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.046800826520698065", ",", " ", 
                  RowBox[{"-", "0.024108435682384573"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"0.048287607760559716", ",", " ", 
                  RowBox[{"-", "0.017107939026036665"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.03414449489476793", ",", " ", 
                  RowBox[{"-", "0.017107939026036665"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.03309318179792082", ",", " ", 
                  RowBox[{"-", "0.024108435682384573"}]}], "}"}]}], "}"}], 
              ",", " ", "\n", "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"0.03414449489476793", ",", " ", 
                  RowBox[{"-", "0.017107939026036665"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.048287607760559716", ",", " ", 
                  RowBox[{"-", "0.017107939026036665"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.04859696585016677", ",", " ", 
                  RowBox[{"-", "0.009696374951067403"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"0.03436324409774399", ",", " ", 
                  RowBox[{"-", "0.009696374951067403"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.03414449489476793", ",", " ", 
                  RowBox[{"-", "0.017107939026036665"}]}], "}"}]}], "}"}], 
              ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"0.03436324409774399", ",", " ", 
                  RowBox[{"-", "0.009696374951067403"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"0.04859696585016677", ",", " ", 
                  RowBox[{"-", "0.009696374951067403"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.04787154861138585", ",", " ", 
                  RowBox[{"-", "0.0019789726801209746"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.033850296649012394", ",", " ", 
                  RowBox[{"-", "0.0019789726801209746"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"0.03436324409774399", ",", " ", 
                  RowBox[{"-", "0.009696374951067403"}]}], "}"}]}], "}"}], 
              ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"0.033850296649012394", ",", " ", 
                  RowBox[{"-", "0.0019789726801209746"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.04787154861138585", ",", " ", 
                  RowBox[{"-", "0.0019789726801209746"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.046309995050206575", ",", " ", "0.005927101286260139"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.03274611153671653", ",", " ", "0.005927101286260139"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.033850296649012394", ",", " ", 
                  RowBox[{"-", "0.0019789726801209746"}]}], "}"}]}], "}"}], 
              ",", " ", "\n", "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                 "0.03274611153671653", ",", " ", "0.0059271012862601264"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.046309995050206575", ",", " ", "0.0059271012862601264"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.044118458295788796", ",", " ", "0.013893760977926984"}], 
                 "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.031196461036448145", ",", " ", "0.013893760977926984"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.03274611153671653", ",", " ", "0.0059271012862601264"}], 
                 "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                 "0.031196461036448145", ",", " ", "0.013893760977926984"}], 
                 "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.044118458295788796", ",", " ", "0.013893760977926984"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.04146584559086729", ",", " ", "0.021783728078581376"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.029320780604936567", ",", " ", "0.021783728078581376"}], 
                 "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.031196461036448145", ",", " ", "0.013893760977926984"}], 
                 "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                 "0.029320780604936567", ",", " ", "0.021783728078581376"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.04146584559086729", ",", " ", "0.021783728078581376"}], 
                 "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.038453896518482106", ",", " ", "0.02945296995204571"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.02719101099126447", ",", " ", "0.02945296995204571"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.029320780604936567", ",", " ", "0.021783728078581376"}], 
                 "}"}]}], "}"}], ",", " ", "\n", "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                 "0.02719101099126447", ",", " ", "0.02945296995204571"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.038453896518482106", ",", " ", "0.02945296995204571"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.035108924860407655", ",", " ", "0.03675380039988509"}], 
                 "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.024825758848963212", ",", " ", "0.03675380039988509"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.02719101099126447", ",", " ", "0.02945296995204571"}], 
                 "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                 "0.024825758848963212", ",", " ", "0.03675380039988509"}], 
                 "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.035108924860407655", ",", " ", "0.03675380039988509"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.03139606656906616", ",", " ", "0.04353854648936185"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.02220037157357095", ",", " ", "0.04353854648936185"}], 
                 "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.024825758848963212", ",", " ", "0.03675380039988509"}], 
                 "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                 "0.02220037157357095", ",", " ", "0.04353854648936185"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.03139606656906616", ",", " ", "0.04353854648936185"}], 
                 "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.02725083190903063", ",", " ", "0.04966364092329548"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.019269248035850308", ",", " ", "0.04966364092329548"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.02220037157357095", ",", " ", "0.04353854648936185"}], 
                 "}"}]}], "}"}], ",", " ", "\n", "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                 "0.019269248035850325", ",", " ", "0.049663640923295456"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.027250831909030646", ",", " ", "0.049663640923295456"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.022618273056747632", ",", " ", "0.054993963249953474"}], 
                 "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.015993534257155235", ",", " ", "0.054993963249953474"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.019269248035850325", ",", " ", "0.049663640923295456"}], 
                 "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                 "0.015993534257155235", ",", " ", "0.054993963249953474"}], 
                 "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.022618273056747632", ",", " ", "0.054993963249953474"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.01748832854338501", ",", " ", "0.0594072273124165"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.012366115704645799", ",", " ", "0.0594072273124165"}], 
                 "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.015993534257155235", ",", " ", "0.054993963249953474"}], 
                 "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                 "0.012366115704645799", ",", " ", "0.0594072273124165"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.01748832854338501", ",", " ", "0.0594072273124165"}], 
                 "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.011917319654125047", ",", " ", "0.06279819862535355"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.008426817540999542", ",", " ", "0.06279819862535355"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.012366115704645799", ",", " ", "0.0594072273124165"}], 
                 "}"}]}], "}"}], ",", " ", "\n", "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                 "0.008426817540999542", ",", " ", "0.06279819862535355"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.011917319654125047", ",", " ", "0.06279819862535355"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.006029717280723974", ",", " ", "0.06508252495431804"}], 
                 "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.004263653977837632", ",", " ", "0.06508252495431804"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.008426817540999542", ",", " ", "0.06279819862535355"}], 
                 "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                 "0.004263653977837632", ",", " ", "0.06508252495431804"}], 
                 "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.006029717280723974", ",", " ", "0.06508252495431804"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "1.5233040523421337*^-17"}], ",", " ", 
                  "0.06619997649057771"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "1.0625181290357943*^-17"}], ",", " ", 
                  "0.06619997649057771"}], "}"}], ",", " ", "\n", 
                "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.004263653977837632", ",", " ", "0.06508252495431804"}], 
                 "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"9.595189226496714*^-18", ",", " ", 
                  RowBox[{"-", "0.05688284915968362"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"1.1438332919722072*^-17", ",", " ", 
                  RowBox[{"-", "0.05688284915968362"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"0.007018575683843379", ",", " ", 
                  RowBox[{"-", "0.0564921568493474"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.005730643048840595", ",", " ", 
                  RowBox[{"-", "0.0564921568493474"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"9.595189226496714*^-18", ",", " ", 
                  RowBox[{"-", "0.05688284915968362"}]}], "}"}]}], "}"}], ",",
               " ", "\n", "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"0.005730643048840595", ",", " ", 
                  RowBox[{"-", "0.0564921568493474"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.007018575683843379", ",", " ", 
                  RowBox[{"-", "0.0564921568493474"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.014254194138415242", ",", " ", 
                  RowBox[{"-", "0.05521682457414796"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"0.011638500777896077", ",", " ", 
                  RowBox[{"-", "0.05521682457414796"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.005730643048840595", ",", " ", 
                  RowBox[{"-", "0.0564921568493474"}]}], "}"}]}], "}"}], ",", 
              " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"0.01163850077789607", ",", " ", 
                  RowBox[{"-", "0.05521682457414796"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"0.014254194138415228", ",", " ", 
                  RowBox[{"-", "0.05521682457414796"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.02169266986834061", ",", " ", 
                  RowBox[{"-", "0.0530770008349515"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.017711990778694012", ",", " ", 
                  RowBox[{"-", "0.0530770008349515"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"0.01163850077789607", ",", " ", 
                  RowBox[{"-", "0.05521682457414796"}]}], "}"}]}], "}"}], ",",
               " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"0.017711990778694012", ",", " ", 
                  RowBox[{"-", "0.0530770008349515"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.02169266986834061", ",", " ", 
                  RowBox[{"-", "0.0530770008349515"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"0.02919974571429535", ",", " ", 
                  RowBox[{"-", "0.05009952120873742"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.02384149253968117", ",", " ", 
                  RowBox[{"-", "0.05009952120873742"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.017711990778694012", ",", " ", 
                  RowBox[{"-", "0.0530770008349515"}]}], "}"}]}], "}"}], ",", 
              " ", "\n", "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"0.023841492539681167", ",", " ", 
                  RowBox[{"-", "0.050099521208737424"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.029199745714295344", ",", " ", 
                  RowBox[{"-", "0.050099521208737424"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.03652408128588709", ",", " ", 
                  RowBox[{"-", "0.046318106341445356"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"0.029821787491453155", ",", " ", 
                  RowBox[{"-", "0.046318106341445356"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.023841492539681167", ",", " ", 
                  RowBox[{"-", "0.050099521208737424"}]}], "}"}]}], "}"}], 
              ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"0.029821787491453155", ",", " ", 
                  RowBox[{"-", "0.046318106341445356"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"0.03652408128588709", ",", " ", 
                  RowBox[{"-", "0.046318106341445356"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.043331589672042314", ",", " ", 
                  RowBox[{"-", "0.04177394503607659"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.03538009481338571", ",", " ", 
                  RowBox[{"-", "0.04177394503607659"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"0.029821787491453155", ",", " ", 
                  RowBox[{"-", "0.046318106341445356"}]}], "}"}]}], "}"}], 
              ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"0.03538009481338571", ",", " ", 
                  RowBox[{"-", "0.04177394503607659"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.043331589672042314", ",", " ", 
                  RowBox[{"-", "0.04177394503607659"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"0.04926272998747844", ",", " ", 
                  RowBox[{"-", "0.03651657383838262"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.04022285060194191", ",", " ", 
                  RowBox[{"-", "0.03651657383838262"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.03538009481338571", ",", " ", 
                  RowBox[{"-", "0.04177394503607659"}]}], "}"}]}], "}"}], ",",
               " ", "\n", "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"0.040222850601941904", ",", " ", 
                  RowBox[{"-", "0.03651657383838262"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.04926272998747844", ",", " ", 
                  RowBox[{"-", "0.03651657383838262"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.053998539906919676", ",", " ", 
                  RowBox[{"-", "0.03060493068010821"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"0.04408962320908928", ",", " ", 
                  RowBox[{"-", "0.03060493068010821"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.040222850601941904", ",", " ", 
                  RowBox[{"-", "0.03651657383838262"}]}], "}"}]}], "}"}], ",",
               " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"0.04408962320908929", ",", " ", 
                  RowBox[{"-", "0.0306049306801082"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"0.05399853990691969", ",", " ", 
                  RowBox[{"-", "0.0306049306801082"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.05731907225811243", ",", " ", 
                  RowBox[{"-", "0.024108435682384573"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.04680082652069807", ",", " ", 
                  RowBox[{"-", "0.024108435682384573"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"0.04408962320908929", ",", " ", 
                  RowBox[{"-", "0.0306049306801082"}]}], "}"}]}], "}"}], ",", 
              " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"0.04680082652069807", ",", " ", 
                  RowBox[{"-", "0.024108435682384573"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.05731907225811243", ",", " ", 
                  RowBox[{"-", "0.024108435682384573"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"0.059139999956514214", ",", " ", 
                  RowBox[{"-", "0.017107939026036665"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.04828760776055972", ",", " ", 
                  RowBox[{"-", "0.017107939026036665"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.04680082652069807", ",", " ", 
                  RowBox[{"-", "0.024108435682384573"}]}], "}"}]}], "}"}], 
              ",", " ", "\n", "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"0.04828760776055972", ",", " ", 
                  RowBox[{"-", "0.017107939026036665"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.059139999956514214", ",", " ", 
                  RowBox[{"-", "0.017107939026036665"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.05951888469018395", ",", " ", 
                  RowBox[{"-", "0.009696374951067403"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"0.048596965850166776", ",", " ", 
                  RowBox[{"-", "0.009696374951067403"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.04828760776055972", ",", " ", 
                  RowBox[{"-", "0.017107939026036665"}]}], "}"}]}], "}"}], 
              ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"0.048596965850166776", ",", " ", 
                  RowBox[{"-", "0.009696374951067403"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"0.05951888469018395", ",", " ", 
                  RowBox[{"-", "0.009696374951067403"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.05863043364736798", ",", " ", 
                  RowBox[{"-", "0.0019789726801209746"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.04787154861138586", ",", " ", 
                  RowBox[{"-", "0.0019789726801209746"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"0.048596965850166776", ",", " ", 
                  RowBox[{"-", "0.009696374951067403"}]}], "}"}]}], "}"}], 
              ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"0.04787154861138586", ",", " ", 
                  RowBox[{"-", "0.0019789726801209746"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.05863043364736798", ",", " ", 
                  RowBox[{"-", "0.0019789726801209746"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.05671792893191039", ",", " ", "0.005927101286260139"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.04630999505020658", ",", " ", "0.005927101286260139"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.04787154861138586", ",", " ", 
                  RowBox[{"-", "0.0019789726801209746"}]}], "}"}]}], "}"}], 
              ",", " ", "\n", "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                 "0.04630999505020658", ",", " ", "0.0059271012862601264"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.05671792893191039", ",", " ", "0.0059271012862601264"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.05403385553147105", ",", " ", "0.013893760977926984"}], 
                 "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.0441184582957888", ",", " ", "0.013893760977926984"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.04630999505020658", ",", " ", "0.0059271012862601264"}], 
                 "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                 "0.0441184582957888", ",", " ", "0.013893760977926984"}], 
                 "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.05403385553147105", ",", " ", "0.013893760977926984"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.05078508172533026", ",", " ", "0.021783728078581376"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.041465845590867294", ",", " ", "0.021783728078581376"}], 
                 "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.0441184582957888", ",", " ", "0.013893760977926984"}], 
                 "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                 "0.041465845590867294", ",", " ", "0.021783728078581376"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.05078508172533026", ",", " ", "0.021783728078581376"}], 
                 "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.04709621254603386", ",", " ", "0.02945296995204571"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.03845389651848211", ",", " ", "0.02945296995204571"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.041465845590867294", ",", " ", "0.021783728078581376"}], 
                 "}"}]}], "}"}], ",", " ", "\n", "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                 "0.03845389651848211", ",", " ", "0.02945296995204571"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.04709621254603386", ",", " ", "0.02945296995204571"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.042999475662856945", ",", " ", "0.03675380039988509"}], 
                 "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.03510892486040766", ",", " ", "0.03675380039988509"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.03845389651848211", ",", " ", "0.02945296995204571"}], 
                 "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                 "0.03510892486040766", ",", " ", "0.03675380039988509"}], 
                 "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.042999475662856945", ",", " ", "0.03675380039988509"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.038452171512332704", ",", " ", "0.04353854648936185"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.03139606656906616", ",", " ", "0.04353854648936185"}], 
                 "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.03510892486040766", ",", " ", "0.03675380039988509"}], 
                 "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                 "0.03139606656906616", ",", " ", "0.04353854648936185"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.038452171512332704", ",", " ", "0.04353854648936185"}], 
                 "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.033375316621739544", ",", " ", "0.04966364092329548"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.027250831909030635", ",", " ", "0.04966364092329548"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.03139606656906616", ",", " ", "0.04353854648936185"}], 
                 "}"}]}], "}"}], ",", " ", "\n", "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                 "0.02725083190903065", ",", " ", "0.049663640923295456"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.03337531662173956", ",", " ", "0.049663640923295456"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.02770161392598623", ",", " ", "0.054993963249953474"}], 
                 "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.022618273056747636", ",", " ", "0.054993963249953474"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.02725083190903065", ",", " ", "0.049663640923295456"}], 
                 "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                 "0.022618273056747636", ",", " ", "0.054993963249953474"}], 
                 "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.02770161392598623", ",", " ", "0.054993963249953474"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.021418740692721937", ",", " ", "0.0594072273124165"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.01748832854338501", ",", " ", "0.0594072273124165"}], 
                 "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.022618273056747636", ",", " ", "0.054993963249953474"}], 
                 "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                 "0.01748832854338501", ",", " ", "0.0594072273124165"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.021418740692721937", ",", " ", "0.0594072273124165"}], 
                 "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.01459567612712384", ",", " ", "0.06279819862535355"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.011917319654125048", ",", " ", "0.06279819862535355"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.01748832854338501", ",", " ", "0.0594072273124165"}], 
                 "}"}]}], "}"}], ",", " ", "\n", "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                 "0.011917319654125048", ",", " ", "0.06279819862535355"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.01459567612712384", ",", " ", "0.06279819862535355"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.007384865315507927", ",", " ", "0.06508252495431804"}], 
                 "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.006029717280723975", ",", " ", "0.06508252495431804"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.011917319654125048", ",", " ", "0.06279819862535355"}], 
                 "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                 "0.006029717280723975", ",", " ", "0.06508252495431804"}], 
                 "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.007384865315507927", ",", " ", "0.06508252495431804"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "1.9027748127120603*^-17"}], ",", " ", 
                  "0.06619997649057771"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "1.5233040523421337*^-17"}], ",", " ", 
                  "0.06619997649057771"}], "}"}], ",", " ", "\n", 
                "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.006029717280723975", ",", " ", "0.06508252495431804"}], 
                 "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"1.1492543028346347*^-17", ",", " ", 
                  RowBox[{"-", "0.05688284915968362"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"1.22514845490862*^-17", ",", " ", 
                  RowBox[{"-", "0.05688284915968362"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"0.00782820398473696", ",", " ", 
                  RowBox[{"-", "0.0564921568493474"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.007018575683843378", ",", " ", 
                  RowBox[{"-", "0.0564921568493474"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"1.1492543028346347*^-17", ",", " ", 
                  RowBox[{"-", "0.05688284915968362"}]}], "}"}]}], "}"}], ",",
               " ", "\n", "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"0.007018575683843378", ",", " ", 
                  RowBox[{"-", "0.0564921568493474"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.00782820398473696", ",", " ", 
                  RowBox[{"-", "0.0564921568493474"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.015898487724570993", ",", " ", 
                  RowBox[{"-", "0.05521682457414796"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"0.014254194138415239", ",", " ", 
                  RowBox[{"-", "0.05521682457414796"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.007018575683843378", ",", " ", 
                  RowBox[{"-", "0.0564921568493474"}]}], "}"}]}], "}"}], ",", 
              " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"0.014254194138415225", ",", " ", 
                  RowBox[{"-", "0.05521682457414796"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"0.01589848772457098", ",", " ", 
                  RowBox[{"-", "0.05521682457414796"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.024195029355291737", ",", " ", 
                  RowBox[{"-", "0.0530770008349515"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.021692669868340606", ",", " ", 
                  RowBox[{"-", "0.0530770008349515"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"0.014254194138415225", ",", " ", 
                  RowBox[{"-", "0.05521682457414796"}]}], "}"}]}], "}"}], ",",
               " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"0.021692669868340606", ",", " ", 
                  RowBox[{"-", "0.0530770008349515"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.024195029355291737", ",", " ", 
                  RowBox[{"-", "0.0530770008349515"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"0.03256808447334166", ",", " ", 
                  RowBox[{"-", "0.05009952120873742"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.02919974571429535", ",", " ", 
                  RowBox[{"-", "0.05009952120873742"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.021692669868340606", ",", " ", 
                  RowBox[{"-", "0.0530770008349515"}]}], "}"}]}], "}"}], ",", 
              " ", "\n", "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"0.029199745714295344", ",", " ", 
                  RowBox[{"-", "0.050099521208737424"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.032568084473341655", ",", " ", 
                  RowBox[{"-", "0.050099521208737424"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.04073731929958602", ",", " ", 
                  RowBox[{"-", "0.046318106341445356"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"0.03652408128588709", ",", " ", 
                  RowBox[{"-", "0.046318106341445356"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.029199745714295344", ",", " ", 
                  RowBox[{"-", "0.050099521208737424"}]}], "}"}]}], "}"}], 
              ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"0.03652408128588709", ",", " ", 
                  RowBox[{"-", "0.046318106341445356"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"0.04073731929958602", ",", " ", 
                  RowBox[{"-", "0.046318106341445356"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.04833010830338694", ",", " ", 
                  RowBox[{"-", "0.04177394503607659"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.04333158967204231", ",", " ", 
                  RowBox[{"-", "0.04177394503607659"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"0.03652408128588709", ",", " ", 
                  RowBox[{"-", "0.046318106341445356"}]}], "}"}]}], "}"}], 
              ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"0.04333158967204231", ",", " ", 
                  RowBox[{"-", "0.04177394503607659"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.04833010830338694", ",", " ", 
                  RowBox[{"-", "0.04177394503607659"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"0.05494543573487883", ",", " ", 
                  RowBox[{"-", "0.03651657383838262"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.04926272998747844", ",", " ", 
                  RowBox[{"-", "0.03651657383838262"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.04333158967204231", ",", " ", 
                  RowBox[{"-", "0.04177394503607659"}]}], "}"}]}], "}"}], ",",
               " ", "\n", "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"0.04926272998747843", ",", " ", 
                  RowBox[{"-", "0.03651657383838262"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.054945435734878825", ",", " ", 
                  RowBox[{"-", "0.03651657383838262"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.06022754534689994", ",", " ", 
                  RowBox[{"-", "0.03060493068010821"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"0.053998539906919676", ",", " ", 
                  RowBox[{"-", "0.03060493068010821"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.04926272998747843", ",", " ", 
                  RowBox[{"-", "0.03651657383838262"}]}], "}"}]}], "}"}], ",",
               " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"0.05399853990691968", ",", " ", 
                  RowBox[{"-", "0.0306049306801082"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"0.06022754534689994", ",", " ", 
                  RowBox[{"-", "0.0306049306801082"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.06393111794538205", ",", " ", 
                  RowBox[{"-", "0.024108435682384573"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.057319072258112426", ",", " ", 
                  RowBox[{"-", "0.024108435682384573"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"0.05399853990691968", ",", " ", 
                  RowBox[{"-", "0.0306049306801082"}]}], "}"}]}], "}"}], ",", 
              " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"0.057319072258112426", ",", " ", 
                  RowBox[{"-", "0.024108435682384573"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.06393111794538205", ",", " ", 
                  RowBox[{"-", "0.024108435682384573"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"0.06596209888890318", ",", " ", 
                  RowBox[{"-", "0.017107939026036665"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.05913999995651421", ",", " ", 
                  RowBox[{"-", "0.017107939026036665"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.057319072258112426", ",", " ", 
                  RowBox[{"-", "0.024108435682384573"}]}], "}"}]}], "}"}], 
              ",", " ", "\n", "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"0.05913999995651421", ",", " ", 
                  RowBox[{"-", "0.017107939026036665"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.06596209888890318", ",", " ", 
                  RowBox[{"-", "0.017107939026036665"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.06638468989817264", ",", " ", 
                  RowBox[{"-", "0.009696374951067403"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"0.059518884690183946", ",", " ", 
                  RowBox[{"-", "0.009696374951067403"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.05913999995651421", ",", " ", 
                  RowBox[{"-", "0.017107939026036665"}]}], "}"}]}], "}"}], 
              ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"0.059518884690183946", ",", " ", 
                  RowBox[{"-", "0.009696374951067403"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"0.06638468989817264", ",", " ", 
                  RowBox[{"-", "0.009696374951067403"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.06539375152165473", ",", " ", 
                  RowBox[{"-", "0.0019789726801209746"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.058630433647367974", ",", " ", 
                  RowBox[{"-", "0.0019789726801209746"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"0.059518884690183946", ",", " ", 
                  RowBox[{"-", "0.009696374951067403"}]}], "}"}]}], "}"}], 
              ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"0.058630433647367974", ",", " ", 
                  RowBox[{"-", "0.0019789726801209746"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.06539375152165473", ",", " ", 
                  RowBox[{"-", "0.0019789726801209746"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.0632606296877138", ",", " ", "0.005927101286260139"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.05671792893191038", ",", " ", "0.005927101286260139"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.058630433647367974", ",", " ", 
                  RowBox[{"-", "0.0019789726801209746"}]}], "}"}]}], "}"}], 
              ",", " ", "\n", "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                 "0.05671792893191038", ",", " ", "0.0059271012862601264"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.06326062968771382", ",", " ", "0.0059271012862601264"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.06026693480785181", ",", " ", "0.013893760977926984"}], 
                 "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.054033855531471046", ",", " ", "0.013893760977926984"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.05671792893191038", ",", " ", "0.0059271012862601264"}], 
                 "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                 "0.054033855531471046", ",", " ", "0.013893760977926984"}], 
                 "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.06026693480785181", ",", " ", "0.013893760977926984"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.05664339846652768", ",", " ", "0.021783728078581376"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.05078508172533025", ",", " ", "0.021783728078581376"}], 
                 "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.054033855531471046", ",", " ", "0.013893760977926984"}], 
                 "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                 "0.05078508172533025", ",", " ", "0.021783728078581376"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.05664339846652768", ",", " ", "0.021783728078581376"}], 
                 "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.05252899951874454", ",", " ", "0.02945296995204571"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.047096212546033855", ",", " ", "0.02945296995204571"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.05078508172533025", ",", " ", "0.021783728078581376"}], 
                 "}"}]}], "}"}], ",", " ", "\n", "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                 "0.047096212546033855", ",", " ", "0.02945296995204571"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.05252899951874454", ",", " ", "0.02945296995204571"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.04795968325887588", ",", " ", "0.03675380039988509"}], 
                 "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.04299947566285694", ",", " ", "0.03675380039988509"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.047096212546033855", ",", " ", "0.02945296995204571"}], 
                 "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                 "0.04299947566285694", ",", " ", "0.03675380039988509"}], 
                 "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.04795968325887588", ",", " ", "0.03675380039988509"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.04288782451225172", ",", " ", "0.04353854648936185"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.038452171512332704", ",", " ", "0.04353854648936185"}], 
                 "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.04299947566285694", ",", " ", "0.03675380039988509"}], 
                 "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                 "0.038452171512332704", ",", " ", "0.04353854648936185"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.04288782451225172", ",", " ", "0.04353854648936185"}], 
                 "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.03722532866199545", ",", " ", "0.04966364092329548"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.03337531662173954", ",", " ", "0.04966364092329548"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.038452171512332704", ",", " ", "0.04353854648936185"}], 
                 "}"}]}], "}"}], ",", " ", "\n", "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                 "0.03337531662173955", ",", " ", "0.049663640923295456"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.037225328661995453", ",", " ", "0.049663640923295456"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.030897135585250375", ",", " ", "0.054993963249953474"}], 
                 "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.02770161392598623", ",", " ", "0.054993963249953474"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.03337531662173955", ",", " ", "0.049663640923295456"}], 
                 "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                 "0.02770161392598623", ",", " ", "0.054993963249953474"}], 
                 "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.030897135585250375", ",", " ", "0.054993963249953474"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.023889501059992435", ",", " ", "0.0594072273124165"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.021418740692721934", ",", " ", "0.0594072273124165"}], 
                 "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.02770161392598623", ",", " ", "0.054993963249953474"}], 
                 "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                 "0.021418740692721934", ",", " ", "0.0594072273124165"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.023889501059992435", ",", " ", "0.0594072273124165"}], 
                 "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.01627936139255439", ",", " ", "0.06279819862535355"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.014595676127123836", ",", " ", "0.06279819862535355"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.021418740692721934", ",", " ", "0.0594072273124165"}], 
                 "}"}]}], "}"}], ",", " ", "\n", "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                 "0.014595676127123836", ",", " ", "0.06279819862535355"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.01627936139255439", ",", " ", "0.06279819862535355"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.008236746983106976", ",", " ", "0.06508252495431804"}], 
                 "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.007384865315507927", ",", " ", "0.06508252495431804"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.014595676127123836", ",", " ", "0.06279819862535355"}], 
                 "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                 "0.007384865315507927", ",", " ", "0.06508252495431804"}], 
                 "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.008236746983106976", ",", " ", "0.06508252495431804"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "2.1141942363467336*^-17"}], ",", " ", 
                  "0.06619997649057771"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "1.8973538018496328*^-17"}], ",", " ", 
                  "0.06619997649057771"}], "}"}], ",", " ", "\n", 
                "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.007384865315507927", ",", " ", "0.06508252495431804"}], 
                 "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"1.22514845490862*^-17", ",", " ", 
                  RowBox[{"-", "0.05688284915968362"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"1.4203048459560108*^-17", ",", " ", 
                  RowBox[{"-", "0.05688284915968362"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"0.008104353120789472", ",", " ", 
                  RowBox[{"-", "0.0564921568493474"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.00782820398473696", ",", " ", 
                  RowBox[{"-", "0.0564921568493474"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"1.22514845490862*^-17", ",", " ", 
                  RowBox[{"-", "0.05688284915968362"}]}], "}"}]}], "}"}], ",",
               " ", "\n", "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"0.00782820398473696", ",", " ", 
                  RowBox[{"-", "0.0564921568493474"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.008104353120789472", ",", " ", 
                  RowBox[{"-", "0.0564921568493474"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.016459325645790453", ",", " ", 
                  RowBox[{"-", "0.05521682457414796"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"0.015898487724570993", ",", " ", 
                  RowBox[{"-", "0.05521682457414796"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.00782820398473696", ",", " ", 
                  RowBox[{"-", "0.0564921568493474"}]}], "}"}]}], "}"}], ",", 
              " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"0.01589848772457098", ",", " ", 
                  RowBox[{"-", "0.05521682457414796"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"0.01645932564579044", ",", " ", 
                  RowBox[{"-", "0.05521682457414796"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.02504853757585627", ",", " ", 
                  RowBox[{"-", "0.0530770008349515"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.024195029355291737", ",", " ", 
                  RowBox[{"-", "0.0530770008349515"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"0.01589848772457098", ",", " ", 
                  RowBox[{"-", "0.05521682457414796"}]}], "}"}]}], "}"}], ",",
               " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"0.024195029355291737", ",", " ", 
                  RowBox[{"-", "0.0530770008349515"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.02504853757585627", ",", " ", 
                  RowBox[{"-", "0.0530770008349515"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"0.03371696209683408", ",", " ", 
                  RowBox[{"-", "0.05009952120873742"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.03256808447334166", ",", " ", 
                  RowBox[{"-", "0.05009952120873742"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.024195029355291737", ",", " ", 
                  RowBox[{"-", "0.0530770008349515"}]}], "}"}]}], "}"}], ",", 
              " ", "\n", "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"0.032568084473341655", ",", " ", 
                  RowBox[{"-", "0.050099521208737424"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.03371696209683407", ",", " ", 
                  RowBox[{"-", "0.050099521208737424"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.04217437632462138", ",", " ", 
                  RowBox[{"-", "0.046318106341445356"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"0.04073731929958602", ",", " ", 
                  RowBox[{"-", "0.046318106341445356"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.032568084473341655", ",", " ", 
                  RowBox[{"-", "0.050099521208737424"}]}], "}"}]}], "}"}], 
              ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"0.04073731929958602", ",", " ", 
                  RowBox[{"-", "0.046318106341445356"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"0.04217437632462138", ",", " ", 
                  RowBox[{"-", "0.046318106341445356"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.05003500992313608", ",", " ", 
                  RowBox[{"-", "0.04177394503607659"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.04833010830338694", ",", " ", 
                  RowBox[{"-", "0.04177394503607659"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"0.04073731929958602", ",", " ", 
                  RowBox[{"-", "0.046318106341445356"}]}], "}"}]}], "}"}], 
              ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"0.04833010830338694", ",", " ", 
                  RowBox[{"-", "0.04177394503607659"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.05003500992313608", ",", " ", 
                  RowBox[{"-", "0.04177394503607659"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"0.05688370083857305", ",", " ", 
                  RowBox[{"-", "0.03651657383838262"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.05494543573487883", ",", " ", 
                  RowBox[{"-", "0.03651657383838262"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.04833010830338694", ",", " ", 
                  RowBox[{"-", "0.04177394503607659"}]}], "}"}]}], "}"}], ",",
               " ", "\n", "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"0.054945435734878825", ",", " ", 
                  RowBox[{"-", "0.03651657383838262"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.05688370083857304", ",", " ", 
                  RowBox[{"-", "0.03651657383838262"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.06235214310221366", ",", " ", 
                  RowBox[{"-", "0.03060493068010821"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"0.06022754534689994", ",", " ", 
                  RowBox[{"-", "0.03060493068010821"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.054945435734878825", ",", " ", 
                  RowBox[{"-", "0.03651657383838262"}]}], "}"}]}], "}"}], ",",
               " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"0.06022754534689994", ",", " ", 
                  RowBox[{"-", "0.0306049306801082"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"0.06235214310221367", ",", " ", 
                  RowBox[{"-", "0.0306049306801082"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.06618636359584165", ",", " ", 
                  RowBox[{"-", "0.024108435682384573"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.06393111794538205", ",", " ", 
                  RowBox[{"-", "0.024108435682384573"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"0.06022754534689994", ",", " ", 
                  RowBox[{"-", "0.0306049306801082"}]}], "}"}]}], "}"}], ",", 
              " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"0.06393111794538205", ",", " ", 
                  RowBox[{"-", "0.024108435682384573"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.06618636359584165", ",", " ", 
                  RowBox[{"-", "0.024108435682384573"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"0.06828898978953588", ",", " ", 
                  RowBox[{"-", "0.017107939026036665"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.06596209888890318", ",", " ", 
                  RowBox[{"-", "0.017107939026036665"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.06393111794538205", ",", " ", 
                  RowBox[{"-", "0.024108435682384573"}]}], "}"}]}], "}"}], 
              ",", " ", "\n", "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"0.06596209888890318", ",", " ", 
                  RowBox[{"-", "0.017107939026036665"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.06828898978953588", ",", " ", 
                  RowBox[{"-", "0.017107939026036665"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.06872648819548799", ",", " ", 
                  RowBox[{"-", "0.009696374951067403"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"0.06638468989817264", ",", " ", 
                  RowBox[{"-", "0.009696374951067403"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.06596209888890318", ",", " ", 
                  RowBox[{"-", "0.017107939026036665"}]}], "}"}]}], "}"}], 
              ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"0.06638468989817264", ",", " ", 
                  RowBox[{"-", "0.009696374951067403"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"0.06872648819548799", ",", " ", 
                  RowBox[{"-", "0.009696374951067403"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.0677005932980248", ",", " ", 
                  RowBox[{"-", "0.0019789726801209746"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.06539375152165473", ",", " ", 
                  RowBox[{"-", "0.0019789726801209746"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"0.06638468989817264", ",", " ", 
                  RowBox[{"-", "0.009696374951067403"}]}], "}"}]}], "}"}], 
              ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"0.06539375152165473", ",", " ", 
                  RowBox[{"-", "0.0019789726801209746"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.0677005932980248", ",", " ", 
                  RowBox[{"-", "0.0019789726801209746"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.06549222307343307", ",", " ", "0.005927101286260139"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.0632606296877138", ",", " ", "0.005927101286260139"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.06539375152165473", ",", " ", 
                  RowBox[{"-", "0.0019789726801209746"}]}], "}"}]}], "}"}], 
              ",", " ", "\n", "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                 "0.06326062968771382", ",", " ", "0.0059271012862601264"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.06549222307343307", ",", " ", "0.0059271012862601264"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.062392922072896304", ",", " ", "0.013893760977926984"}], 
                 "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.06026693480785181", ",", " ", "0.013893760977926984"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.06326062968771382", ",", " ", "0.0059271012862601264"}], 
                 "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                 "0.06026693480785181", ",", " ", "0.013893760977926984"}], 
                 "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.062392922072896304", ",", " ", "0.013893760977926984"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.05864156120987315", ",", " ", "0.021783728078581376"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.05664339846652768", ",", " ", "0.021783728078581376"}], 
                 "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.06026693480785181", ",", " ", "0.013893760977926984"}], 
                 "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                 "0.05664339846652768", ",", " ", "0.021783728078581376"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.05864156120987315", ",", " ", "0.021783728078581376"}], 
                 "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.05438202198252895", ",", " ", "0.02945296995204571"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.05252899951874454", ",", " ", "0.02945296995204571"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.05664339846652768", ",", " ", "0.021783728078581376"}], 
                 "}"}]}], "}"}], ",", " ", "\n", "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                 "0.05252899951874454", ",", " ", "0.02945296995204571"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.05438202198252895", ",", " ", "0.02945296995204571"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.04965151769792643", ",", " ", "0.03675380039988509"}], 
                 "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.04795968325887588", ",", " ", "0.03675380039988509"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.05252899951874454", ",", " ", "0.02945296995204571"}], 
                 "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                 "0.04795968325887588", ",", " ", "0.03675380039988509"}], 
                 "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.04965151769792643", ",", " ", "0.03675380039988509"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.04440074314714191", ",", " ", "0.04353854648936185"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.04288782451225172", ",", " ", "0.04353854648936185"}], 
                 "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.04795968325887588", ",", " ", "0.03675380039988509"}], 
                 "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                 "0.04288782451225172", ",", " ", "0.04353854648936185"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.04440074314714191", ",", " ", "0.04353854648936185"}], 
                 "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.03853849607170062", ",", " ", "0.04966364092329548"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.03722532866199545", ",", " ", "0.04966364092329548"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.04288782451225172", ",", " ", "0.04353854648936185"}], 
                 "}"}]}], "}"}], ",", " ", "\n", "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                 "0.037225328661995453", ",", " ", "0.049663640923295456"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.03853849607170066", ",", " ", "0.049663640923295456"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.03198706851431048", ",", " ", "0.054993963249953474"}], 
                 "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.030897135585250375", ",", " ", "0.054993963249953474"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.037225328661995453", ",", " ", "0.049663640923295456"}], 
                 "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                 "0.030897135585250375", ",", " ", "0.054993963249953474"}], 
                 "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.03198706851431048", ",", " ", "0.054993963249953474"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.0247322314092916", ",", " ", "0.0594072273124165"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.023889501059992435", ",", " ", "0.0594072273124165"}], 
                 "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.030897135585250375", ",", " ", "0.054993963249953474"}], 
                 "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                 "0.023889501059992435", ",", " ", "0.0594072273124165"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.0247322314092916", ",", " ", "0.0594072273124165"}], 
                 "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.016853635081999087", ",", " ", "0.06279819862535355"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.01627936139255439", ",", " ", "0.06279819862535355"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.023889501059992435", ",", " ", "0.0594072273124165"}], 
                 "}"}]}], "}"}], ",", " ", "\n", "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                 "0.01627936139255439", ",", " ", "0.06279819862535355"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.016853635081999087", ",", " ", "0.06279819862535355"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.008527307955675266", ",", " ", "0.06508252495431804"}], 
                 "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.008236746983106976", ",", " ", "0.06508252495431804"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.01627936139255439", ",", " ", "0.06279819862535355"}], 
                 "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                 "0.008236746983106976", ",", " ", "0.06508252495431804"}], 
                 "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.008527307955675266", ",", " ", "0.06508252495431804"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "2.200930410145574*^-17"}], ",", " ", 
                  "0.06619997649057771"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "2.1141942363467336*^-17"}], ",", " ", 
                  "0.06619997649057771"}], "}"}], ",", " ", "\n", 
                "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.008236746983106976", ",", " ", "0.06508252495431804"}], 
                 "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"1.4203048459560108*^-17", ",", " ", 
                  RowBox[{"-", "0.05688284915968362"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"1.2902005852577503*^-17", ",", " ", 
                  RowBox[{"-", "0.05688284915968362"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"0.007828203984736963", ",", " ", 
                  RowBox[{"-", "0.0564921568493474"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.008104353120789472", ",", " ", 
                  RowBox[{"-", "0.0564921568493474"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"1.4203048459560108*^-17", ",", " ", 
                  RowBox[{"-", "0.05688284915968362"}]}], "}"}]}], "}"}], ",",
               " ", "\n", "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"0.008104353120789472", ",", " ", 
                  RowBox[{"-", "0.0564921568493474"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.007828203984736963", ",", " ", 
                  RowBox[{"-", "0.0564921568493474"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.015898487724570996", ",", " ", 
                  RowBox[{"-", "0.05521682457414796"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"0.016459325645790453", ",", " ", 
                  RowBox[{"-", "0.05521682457414796"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.008104353120789472", ",", " ", 
                  RowBox[{"-", "0.0564921568493474"}]}], "}"}]}], "}"}], ",", 
              " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"0.01645932564579044", ",", " ", 
                  RowBox[{"-", "0.05521682457414796"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"0.01589848772457098", ",", " ", 
                  RowBox[{"-", "0.05521682457414796"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.024195029355291744", ",", " ", 
                  RowBox[{"-", "0.0530770008349515"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.02504853757585627", ",", " ", 
                  RowBox[{"-", "0.0530770008349515"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"0.01645932564579044", ",", " ", 
                  RowBox[{"-", "0.05521682457414796"}]}], "}"}]}], "}"}], ",",
               " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"0.02504853757585627", ",", " ", 
                  RowBox[{"-", "0.0530770008349515"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.024195029355291744", ",", " ", 
                  RowBox[{"-", "0.0530770008349515"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"0.03256808447334167", ",", " ", 
                  RowBox[{"-", "0.05009952120873742"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.03371696209683408", ",", " ", 
                  RowBox[{"-", "0.05009952120873742"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.02504853757585627", ",", " ", 
                  RowBox[{"-", "0.0530770008349515"}]}], "}"}]}], "}"}], ",", 
              " ", "\n", "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"0.03371696209683407", ",", " ", 
                  RowBox[{"-", "0.050099521208737424"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.03256808447334166", ",", " ", 
                  RowBox[{"-", "0.050099521208737424"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.040737319299586024", ",", " ", 
                  RowBox[{"-", "0.046318106341445356"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"0.04217437632462138", ",", " ", 
                  RowBox[{"-", "0.046318106341445356"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.03371696209683407", ",", " ", 
                  RowBox[{"-", "0.050099521208737424"}]}], "}"}]}], "}"}], 
              ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"0.04217437632462138", ",", " ", 
                  RowBox[{"-", "0.046318106341445356"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"0.040737319299586024", ",", " ", 
                  RowBox[{"-", "0.046318106341445356"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.048330108303386944", ",", " ", 
                  RowBox[{"-", "0.04177394503607659"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.05003500992313608", ",", " ", 
                  RowBox[{"-", "0.04177394503607659"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"0.04217437632462138", ",", " ", 
                  RowBox[{"-", "0.046318106341445356"}]}], "}"}]}], "}"}], 
              ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"0.05003500992313608", ",", " ", 
                  RowBox[{"-", "0.04177394503607659"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.048330108303386944", ",", " ", 
                  RowBox[{"-", "0.04177394503607659"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"0.054945435734878846", ",", " ", 
                  RowBox[{"-", "0.03651657383838262"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.05688370083857305", ",", " ", 
                  RowBox[{"-", "0.03651657383838262"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.05003500992313608", ",", " ", 
                  RowBox[{"-", "0.04177394503607659"}]}], "}"}]}], "}"}], ",",
               " ", "\n", "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"0.05688370083857304", ",", " ", 
                  RowBox[{"-", "0.03651657383838262"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.05494543573487884", ",", " ", 
                  RowBox[{"-", "0.03651657383838262"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.060227545346899954", ",", " ", 
                  RowBox[{"-", "0.03060493068010821"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"0.06235214310221366", ",", " ", 
                  RowBox[{"-", "0.03060493068010821"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.05688370083857304", ",", " ", 
                  RowBox[{"-", "0.03651657383838262"}]}], "}"}]}], "}"}], ",",
               " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"0.06235214310221367", ",", " ", 
                  RowBox[{"-", "0.0306049306801082"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"0.060227545346899954", ",", " ", 
                  RowBox[{"-", "0.0306049306801082"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.06393111794538206", ",", " ", 
                  RowBox[{"-", "0.024108435682384573"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.06618636359584165", ",", " ", 
                  RowBox[{"-", "0.024108435682384573"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"0.06235214310221367", ",", " ", 
                  RowBox[{"-", "0.0306049306801082"}]}], "}"}]}], "}"}], ",", 
              " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"0.06618636359584165", ",", " ", 
                  RowBox[{"-", "0.024108435682384573"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.06393111794538206", ",", " ", 
                  RowBox[{"-", "0.024108435682384573"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"0.0659620988889032", ",", " ", 
                  RowBox[{"-", "0.017107939026036665"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.06828898978953588", ",", " ", 
                  RowBox[{"-", "0.017107939026036665"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.06618636359584165", ",", " ", 
                  RowBox[{"-", "0.024108435682384573"}]}], "}"}]}], "}"}], 
              ",", " ", "\n", "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"0.06828898978953588", ",", " ", 
                  RowBox[{"-", "0.017107939026036665"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.0659620988889032", ",", " ", 
                  RowBox[{"-", "0.017107939026036665"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.06638468989817266", ",", " ", 
                  RowBox[{"-", "0.009696374951067403"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"0.06872648819548799", ",", " ", 
                  RowBox[{"-", "0.009696374951067403"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.06828898978953588", ",", " ", 
                  RowBox[{"-", "0.017107939026036665"}]}], "}"}]}], "}"}], 
              ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"0.06872648819548799", ",", " ", 
                  RowBox[{"-", "0.009696374951067403"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"0.06638468989817266", ",", " ", 
                  RowBox[{"-", "0.009696374951067403"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.06539375152165475", ",", " ", 
                  RowBox[{"-", "0.0019789726801209746"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.0677005932980248", ",", " ", 
                  RowBox[{"-", "0.0019789726801209746"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"0.06872648819548799", ",", " ", 
                  RowBox[{"-", "0.009696374951067403"}]}], "}"}]}], "}"}], 
              ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"0.0677005932980248", ",", " ", 
                  RowBox[{"-", "0.0019789726801209746"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.06539375152165475", ",", " ", 
                  RowBox[{"-", "0.0019789726801209746"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.06326062968771382", ",", " ", "0.005927101286260139"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.06549222307343307", ",", " ", "0.005927101286260139"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.0677005932980248", ",", " ", 
                  RowBox[{"-", "0.0019789726801209746"}]}], "}"}]}], "}"}], 
              ",", " ", "\n", "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                 "0.06549222307343307", ",", " ", "0.0059271012862601264"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.06326062968771383", ",", " ", "0.0059271012862601264"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.06026693480785182", ",", " ", "0.013893760977926984"}], 
                 "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.062392922072896304", ",", " ", "0.013893760977926984"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.06549222307343307", ",", " ", "0.0059271012862601264"}], 
                 "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                 "0.062392922072896304", ",", " ", "0.013893760977926984"}], 
                 "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.06026693480785182", ",", " ", "0.013893760977926984"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.056643398466527696", ",", " ", "0.021783728078581376"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.05864156120987315", ",", " ", "0.021783728078581376"}], 
                 "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.062392922072896304", ",", " ", "0.013893760977926984"}], 
                 "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                 "0.05864156120987315", ",", " ", "0.021783728078581376"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.056643398466527696", ",", " ", "0.021783728078581376"}], 
                 "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.05252899951874456", ",", " ", "0.02945296995204571"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.05438202198252895", ",", " ", "0.02945296995204571"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.05864156120987315", ",", " ", "0.021783728078581376"}], 
                 "}"}]}], "}"}], ",", " ", "\n", "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                 "0.05438202198252895", ",", " ", "0.02945296995204571"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.05252899951874456", ",", " ", "0.02945296995204571"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.047959683258875896", ",", " ", "0.03675380039988509"}], 
                 "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.04965151769792643", ",", " ", "0.03675380039988509"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.05438202198252895", ",", " ", "0.02945296995204571"}], 
                 "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                 "0.04965151769792643", ",", " ", "0.03675380039988509"}], 
                 "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.047959683258875896", ",", " ", "0.03675380039988509"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.04288782451225173", ",", " ", "0.04353854648936185"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.04440074314714191", ",", " ", "0.04353854648936185"}], 
                 "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.04965151769792643", ",", " ", "0.03675380039988509"}], 
                 "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                 "0.04440074314714191", ",", " ", "0.04353854648936185"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.04288782451225173", ",", " ", "0.04353854648936185"}], 
                 "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.037225328661995453", ",", " ", "0.04966364092329548"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.03853849607170062", ",", " ", "0.04966364092329548"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.04440074314714191", ",", " ", "0.04353854648936185"}], 
                 "}"}]}], "}"}], ",", " ", "\n", "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                 "0.03853849607170066", ",", " ", "0.049663640923295456"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.03722532866199546", ",", " ", "0.049663640923295456"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.030897135585250382", ",", " ", "0.054993963249953474"}], 
                 "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.03198706851431048", ",", " ", "0.054993963249953474"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.03853849607170066", ",", " ", "0.049663640923295456"}], 
                 "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                 "0.03198706851431048", ",", " ", "0.054993963249953474"}], 
                 "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.030897135585250382", ",", " ", "0.054993963249953474"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.02388950105999244", ",", " ", "0.0594072273124165"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.0247322314092916", ",", " ", "0.0594072273124165"}], 
                 "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.03198706851431048", ",", " ", "0.054993963249953474"}], 
                 "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                 "0.0247322314092916", ",", " ", "0.0594072273124165"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.02388950105999244", ",", " ", "0.0594072273124165"}], 
                 "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.016279361392554398", ",", " ", "0.06279819862535355"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.016853635081999087", ",", " ", "0.06279819862535355"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.0247322314092916", ",", " ", "0.0594072273124165"}], 
                 "}"}]}], "}"}], ",", " ", "\n", "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                 "0.016853635081999087", ",", " ", "0.06279819862535355"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.016279361392554398", ",", " ", "0.06279819862535355"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.008236746983106977", ",", " ", "0.06508252495431804"}], 
                 "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.008527307955675266", ",", " ", "0.06508252495431804"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.016853635081999087", ",", " ", "0.06279819862535355"}], 
                 "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                 "0.008527307955675266", ",", " ", "0.06508252495431804"}], 
                 "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.008236746983106977", ",", " ", "0.06508252495431804"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "2.1033522146218786*^-17"}], ",", " ", 
                  "0.06619997649057771"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "2.200930410145574*^-17"}], ",", " ", 
                  "0.06619997649057771"}], "}"}], ",", " ", "\n", 
                "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.008527307955675266", ",", " ", "0.06508252495431804"}], 
                 "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"1.2902005852577503*^-17", ",", " ", 
                  RowBox[{"-", "0.05688284915968362"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"1.214306433183765*^-17", ",", " ", 
                  RowBox[{"-", "0.05688284915968362"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"0.00701857568384338", ",", " ", 
                  RowBox[{"-", "0.0564921568493474"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.007828203984736963", ",", " ", 
                  RowBox[{"-", "0.0564921568493474"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"1.2902005852577503*^-17", ",", " ", 
                  RowBox[{"-", "0.05688284915968362"}]}], "}"}]}], "}"}], ",",
               " ", "\n", "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"0.007828203984736963", ",", " ", 
                  RowBox[{"-", "0.0564921568493474"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.00701857568384338", ",", " ", 
                  RowBox[{"-", "0.0564921568493474"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.014254194138415244", ",", " ", 
                  RowBox[{"-", "0.05521682457414796"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"0.015898487724570996", ",", " ", 
                  RowBox[{"-", "0.05521682457414796"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.007828203984736963", ",", " ", 
                  RowBox[{"-", "0.0564921568493474"}]}], "}"}]}], "}"}], ",", 
              " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"0.01589848772457098", ",", " ", 
                  RowBox[{"-", "0.05521682457414796"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"0.014254194138415232", ",", " ", 
                  RowBox[{"-", "0.05521682457414796"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.021692669868340616", ",", " ", 
                  RowBox[{"-", "0.0530770008349515"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.024195029355291744", ",", " ", 
                  RowBox[{"-", "0.0530770008349515"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"0.01589848772457098", ",", " ", 
                  RowBox[{"-", "0.05521682457414796"}]}], "}"}]}], "}"}], ",",
               " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"0.024195029355291744", ",", " ", 
                  RowBox[{"-", "0.0530770008349515"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.021692669868340616", ",", " ", 
                  RowBox[{"-", "0.0530770008349515"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"0.029199745714295358", ",", " ", 
                  RowBox[{"-", "0.05009952120873742"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.03256808447334167", ",", " ", 
                  RowBox[{"-", "0.05009952120873742"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.024195029355291744", ",", " ", 
                  RowBox[{"-", "0.0530770008349515"}]}], "}"}]}], "}"}], ",", 
              " ", "\n", "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"0.03256808447334166", ",", " ", 
                  RowBox[{"-", "0.050099521208737424"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.029199745714295344", ",", " ", 
                  RowBox[{"-", "0.050099521208737424"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.0365240812858871", ",", " ", 
                  RowBox[{"-", "0.046318106341445356"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"0.040737319299586024", ",", " ", 
                  RowBox[{"-", "0.046318106341445356"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.03256808447334166", ",", " ", 
                  RowBox[{"-", "0.050099521208737424"}]}], "}"}]}], "}"}], 
              ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"0.040737319299586024", ",", " ", 
                  RowBox[{"-", "0.046318106341445356"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"0.0365240812858871", ",", " ", 
                  RowBox[{"-", "0.046318106341445356"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.04333158967204233", ",", " ", 
                  RowBox[{"-", "0.04177394503607659"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.048330108303386944", ",", " ", 
                  RowBox[{"-", "0.04177394503607659"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"0.040737319299586024", ",", " ", 
                  RowBox[{"-", "0.046318106341445356"}]}], "}"}]}], "}"}], 
              ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"0.048330108303386944", ",", " ", 
                  RowBox[{"-", "0.04177394503607659"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.04333158967204233", ",", " ", 
                  RowBox[{"-", "0.04177394503607659"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"0.04926272998747845", ",", " ", 
                  RowBox[{"-", "0.03651657383838262"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.054945435734878846", ",", " ", 
                  RowBox[{"-", "0.03651657383838262"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.048330108303386944", ",", " ", 
                  RowBox[{"-", "0.04177394503607659"}]}], "}"}]}], "}"}], ",",
               " ", "\n", "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"0.05494543573487884", ",", " ", 
                  RowBox[{"-", "0.03651657383838262"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.049262729987478444", ",", " ", 
                  RowBox[{"-", "0.03651657383838262"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.05399853990691969", ",", " ", 
                  RowBox[{"-", "0.03060493068010821"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"0.060227545346899954", ",", " ", 
                  RowBox[{"-", "0.03060493068010821"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.05494543573487884", ",", " ", 
                  RowBox[{"-", "0.03651657383838262"}]}], "}"}]}], "}"}], ",",
               " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"0.060227545346899954", ",", " ", 
                  RowBox[{"-", "0.0306049306801082"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"0.053998539906919704", ",", " ", 
                  RowBox[{"-", "0.0306049306801082"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.05731907225811245", ",", " ", 
                  RowBox[{"-", "0.024108435682384573"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.06393111794538206", ",", " ", 
                  RowBox[{"-", "0.024108435682384573"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"0.060227545346899954", ",", " ", 
                  RowBox[{"-", "0.0306049306801082"}]}], "}"}]}], "}"}], ",", 
              " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"0.06393111794538206", ",", " ", 
                  RowBox[{"-", "0.024108435682384573"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.05731907225811245", ",", " ", 
                  RowBox[{"-", "0.024108435682384573"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"0.05913999995651423", ",", " ", 
                  RowBox[{"-", "0.017107939026036665"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.0659620988889032", ",", " ", 
                  RowBox[{"-", "0.017107939026036665"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.06393111794538206", ",", " ", 
                  RowBox[{"-", "0.024108435682384573"}]}], "}"}]}], "}"}], 
              ",", " ", "\n", "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"0.0659620988889032", ",", " ", 
                  RowBox[{"-", "0.017107939026036665"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.05913999995651423", ",", " ", 
                  RowBox[{"-", "0.017107939026036665"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.05951888469018397", ",", " ", 
                  RowBox[{"-", "0.009696374951067403"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"0.06638468989817266", ",", " ", 
                  RowBox[{"-", "0.009696374951067403"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.0659620988889032", ",", " ", 
                  RowBox[{"-", "0.017107939026036665"}]}], "}"}]}], "}"}], 
              ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"0.06638468989817266", ",", " ", 
                  RowBox[{"-", "0.009696374951067403"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"0.05951888469018397", ",", " ", 
                  RowBox[{"-", "0.009696374951067403"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.058630433647367995", ",", " ", 
                  RowBox[{"-", "0.0019789726801209746"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.06539375152165475", ",", " ", 
                  RowBox[{"-", "0.0019789726801209746"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"0.06638468989817266", ",", " ", 
                  RowBox[{"-", "0.009696374951067403"}]}], "}"}]}], "}"}], 
              ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"0.06539375152165475", ",", " ", 
                  RowBox[{"-", "0.0019789726801209746"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.058630433647367995", ",", " ", 
                  RowBox[{"-", "0.0019789726801209746"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.056717928931910404", ",", " ", "0.005927101286260139"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.06326062968771382", ",", " ", "0.005927101286260139"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.06539375152165475", ",", " ", 
                  RowBox[{"-", "0.0019789726801209746"}]}], "}"}]}], "}"}], 
              ",", " ", "\n", "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                 "0.06326062968771383", ",", " ", "0.0059271012862601264"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.056717928931910404", ",", " ", "0.0059271012862601264"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.05403385553147106", ",", " ", "0.013893760977926984"}], 
                 "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.06026693480785182", ",", " ", "0.013893760977926984"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.06326062968771383", ",", " ", "0.0059271012862601264"}], 
                 "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                 "0.06026693480785182", ",", " ", "0.013893760977926984"}], 
                 "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.05403385553147106", ",", " ", "0.013893760977926984"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.050785081725330264", ",", " ", "0.021783728078581376"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.056643398466527696", ",", " ", "0.021783728078581376"}], 
                 "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.06026693480785182", ",", " ", "0.013893760977926984"}], 
                 "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                 "0.056643398466527696", ",", " ", "0.021783728078581376"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.050785081725330264", ",", " ", "0.021783728078581376"}], 
                 "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.04709621254603387", ",", " ", "0.02945296995204571"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.05252899951874456", ",", " ", "0.02945296995204571"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.056643398466527696", ",", " ", "0.021783728078581376"}], 
                 "}"}]}], "}"}], ",", " ", "\n", "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                 "0.05252899951874456", ",", " ", "0.02945296995204571"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.04709621254603387", ",", " ", "0.02945296995204571"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.04299947566285695", ",", " ", "0.03675380039988509"}], 
                 "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.047959683258875896", ",", " ", "0.03675380039988509"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.05252899951874456", ",", " ", "0.02945296995204571"}], 
                 "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                 "0.047959683258875896", ",", " ", "0.03675380039988509"}], 
                 "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.04299947566285695", ",", " ", "0.03675380039988509"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.03845217151233272", ",", " ", "0.04353854648936185"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.04288782451225173", ",", " ", "0.04353854648936185"}], 
                 "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.047959683258875896", ",", " ", "0.03675380039988509"}], 
                 "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                 "0.04288782451225173", ",", " ", "0.04353854648936185"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.03845217151233272", ",", " ", "0.04353854648936185"}], 
                 "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.03337531662173955", ",", " ", "0.04966364092329548"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.037225328661995453", ",", " ", "0.04966364092329548"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.04288782451225173", ",", " ", "0.04353854648936185"}], 
                 "}"}]}], "}"}], ",", " ", "\n", "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                 "0.03722532866199546", ",", " ", "0.049663640923295456"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.03337531662173956", ",", " ", "0.049663640923295456"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.02770161392598624", ",", " ", "0.054993963249953474"}], 
                 "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.030897135585250382", ",", " ", "0.054993963249953474"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.03722532866199546", ",", " ", "0.049663640923295456"}], 
                 "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                 "0.030897135585250382", ",", " ", "0.054993963249953474"}], 
                 "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.02770161392598624", ",", " ", "0.054993963249953474"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.02141874069272194", ",", " ", "0.0594072273124165"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.02388950105999244", ",", " ", "0.0594072273124165"}], 
                 "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.030897135585250382", ",", " ", "0.054993963249953474"}], 
                 "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                 "0.02388950105999244", ",", " ", "0.0594072273124165"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.02141874069272194", ",", " ", "0.0594072273124165"}], 
                 "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.014595676127123841", ",", " ", "0.06279819862535355"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.016279361392554398", ",", " ", "0.06279819862535355"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.02388950105999244", ",", " ", "0.0594072273124165"}], 
                 "}"}]}], "}"}], ",", " ", "\n", "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                 "0.016279361392554398", ",", " ", "0.06279819862535355"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.014595676127123841", ",", " ", "0.06279819862535355"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.007384865315507929", ",", " ", "0.06508252495431804"}], 
                 "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.008236746983106977", ",", " ", "0.06508252495431804"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.016279361392554398", ",", " ", "0.06279819862535355"}], 
                 "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                 "0.008236746983106977", ",", " ", "0.06508252495431804"}], 
                 "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.007384865315507929", ",", " ", "0.06508252495431804"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "1.8973538018496328*^-17"}], ",", " ", 
                  "0.06619997649057771"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "2.1033522146218786*^-17"}], ",", " ", 
                  "0.06619997649057771"}], "}"}], ",", " ", "\n", 
                "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.008236746983106977", ",", " ", "0.06508252495431804"}], 
                 "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"1.1384122811097797*^-17", ",", " ", 
                  RowBox[{"-", "0.05688284915968362"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"9.432558900623889*^-18", ",", " ", 
                  RowBox[{"-", "0.05688284915968362"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"0.005730643048840598", ",", " ", 
                  RowBox[{"-", "0.0564921568493474"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.007018575683843379", ",", " ", 
                  RowBox[{"-", "0.0564921568493474"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"1.1384122811097797*^-17", ",", " ", 
                  RowBox[{"-", "0.05688284915968362"}]}], "}"}]}], "}"}], ",",
               " ", "\n", "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"0.007018575683843379", ",", " ", 
                  RowBox[{"-", "0.0564921568493474"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.005730643048840598", ",", " ", 
                  RowBox[{"-", "0.0564921568493474"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.011638500777896079", ",", " ", 
                  RowBox[{"-", "0.05521682457414796"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"0.014254194138415242", ",", " ", 
                  RowBox[{"-", "0.05521682457414796"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.007018575683843379", ",", " ", 
                  RowBox[{"-", "0.0564921568493474"}]}], "}"}]}], "}"}], ",", 
              " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"0.014254194138415232", ",", " ", 
                  RowBox[{"-", "0.05521682457414796"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"0.01163850077789607", ",", " ", 
                  RowBox[{"-", "0.05521682457414796"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.01771199077869402", ",", " ", 
                  RowBox[{"-", "0.0530770008349515"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.021692669868340612", ",", " ", 
                  RowBox[{"-", "0.0530770008349515"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"0.014254194138415232", ",", " ", 
                  RowBox[{"-", "0.05521682457414796"}]}], "}"}]}], "}"}], ",",
               " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"0.021692669868340612", ",", " ", 
                  RowBox[{"-", "0.0530770008349515"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.01771199077869402", ",", " ", 
                  RowBox[{"-", "0.0530770008349515"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"0.02384149253968118", ",", " ", 
                  RowBox[{"-", "0.05009952120873742"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.029199745714295358", ",", " ", 
                  RowBox[{"-", "0.05009952120873742"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.021692669868340612", ",", " ", 
                  RowBox[{"-", "0.0530770008349515"}]}], "}"}]}], "}"}], ",", 
              " ", "\n", "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"0.029199745714295344", ",", " ", 
                  RowBox[{"-", "0.050099521208737424"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.023841492539681174", ",", " ", 
                  RowBox[{"-", "0.050099521208737424"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.029821787491453165", ",", " ", 
                  RowBox[{"-", "0.046318106341445356"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"0.0365240812858871", ",", " ", 
                  RowBox[{"-", "0.046318106341445356"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.029199745714295344", ",", " ", 
                  RowBox[{"-", "0.050099521208737424"}]}], "}"}]}], "}"}], 
              ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"0.0365240812858871", ",", " ", 
                  RowBox[{"-", "0.046318106341445356"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"0.029821787491453165", ",", " ", 
                  RowBox[{"-", "0.046318106341445356"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.03538009481338573", ",", " ", 
                  RowBox[{"-", "0.04177394503607659"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.04333158967204232", ",", " ", 
                  RowBox[{"-", "0.04177394503607659"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"0.0365240812858871", ",", " ", 
                  RowBox[{"-", "0.046318106341445356"}]}], "}"}]}], "}"}], 
              ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"0.04333158967204232", ",", " ", 
                  RowBox[{"-", "0.04177394503607659"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.03538009481338573", ",", " ", 
                  RowBox[{"-", "0.04177394503607659"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"0.04022285060194192", ",", " ", 
                  RowBox[{"-", "0.03651657383838262"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.049262729987478444", ",", " ", 
                  RowBox[{"-", "0.03651657383838262"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.04333158967204232", ",", " ", 
                  RowBox[{"-", "0.04177394503607659"}]}], "}"}]}], "}"}], ",",
               " ", "\n", "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"0.04926272998747844", ",", " ", 
                  RowBox[{"-", "0.03651657383838262"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.04022285060194191", ",", " ", 
                  RowBox[{"-", "0.03651657383838262"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.044089623209089296", ",", " ", 
                  RowBox[{"-", "0.03060493068010821"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"0.05399853990691968", ",", " ", 
                  RowBox[{"-", "0.03060493068010821"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.04926272998747844", ",", " ", 
                  RowBox[{"-", "0.03651657383838262"}]}], "}"}]}], "}"}], ",",
               " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"0.0539985399069197", ",", " ", 
                  RowBox[{"-", "0.0306049306801082"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"0.044089623209089296", ",", " ", 
                  RowBox[{"-", "0.0306049306801082"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.04680082652069809", ",", " ", 
                  RowBox[{"-", "0.024108435682384573"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.05731907225811244", ",", " ", 
                  RowBox[{"-", "0.024108435682384573"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"0.0539985399069197", ",", " ", 
                  RowBox[{"-", "0.0306049306801082"}]}], "}"}]}], "}"}], ",", 
              " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"0.05731907225811244", ",", " ", 
                  RowBox[{"-", "0.024108435682384573"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.04680082652069809", ",", " ", 
                  RowBox[{"-", "0.024108435682384573"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"0.048287607760559736", ",", " ", 
                  RowBox[{"-", "0.017107939026036665"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.05913999995651422", ",", " ", 
                  RowBox[{"-", "0.017107939026036665"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.05731907225811244", ",", " ", 
                  RowBox[{"-", "0.024108435682384573"}]}], "}"}]}], "}"}], 
              ",", " ", "\n", "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"0.05913999995651422", ",", " ", 
                  RowBox[{"-", "0.017107939026036665"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.048287607760559736", ",", " ", 
                  RowBox[{"-", "0.017107939026036665"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.04859696585016679", ",", " ", 
                  RowBox[{"-", "0.009696374951067403"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"0.05951888469018396", ",", " ", 
                  RowBox[{"-", "0.009696374951067403"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.05913999995651422", ",", " ", 
                  RowBox[{"-", "0.017107939026036665"}]}], "}"}]}], "}"}], 
              ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"0.05951888469018396", ",", " ", 
                  RowBox[{"-", "0.009696374951067403"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"0.04859696585016679", ",", " ", 
                  RowBox[{"-", "0.009696374951067403"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.04787154861138587", ",", " ", 
                  RowBox[{"-", "0.0019789726801209746"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.05863043364736799", ",", " ", 
                  RowBox[{"-", "0.0019789726801209746"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"0.05951888469018396", ",", " ", 
                  RowBox[{"-", "0.009696374951067403"}]}], "}"}]}], "}"}], 
              ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"0.05863043364736799", ",", " ", 
                  RowBox[{"-", "0.0019789726801209746"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.04787154861138587", ",", " ", 
                  RowBox[{"-", "0.0019789726801209746"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.046309995050206595", ",", " ", "0.005927101286260139"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.0567179289319104", ",", " ", "0.005927101286260139"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.05863043364736799", ",", " ", 
                  RowBox[{"-", "0.0019789726801209746"}]}], "}"}]}], "}"}], 
              ",", " ", "\n", "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                 "0.0567179289319104", ",", " ", "0.0059271012862601264"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.046309995050206595", ",", " ", "0.0059271012862601264"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.044118458295788816", ",", " ", "0.013893760977926984"}], 
                 "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.05403385553147106", ",", " ", "0.013893760977926984"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.0567179289319104", ",", " ", "0.0059271012862601264"}], 
                 "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                 "0.05403385553147106", ",", " ", "0.013893760977926984"}], 
                 "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.044118458295788816", ",", " ", "0.013893760977926984"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.04146584559086731", ",", " ", "0.021783728078581376"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.05078508172533026", ",", " ", "0.021783728078581376"}], 
                 "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.05403385553147106", ",", " ", "0.013893760977926984"}], 
                 "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                 "0.05078508172533026", ",", " ", "0.021783728078581376"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.04146584559086731", ",", " ", "0.021783728078581376"}], 
                 "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.03845389651848213", ",", " ", "0.02945296995204571"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.04709621254603387", ",", " ", "0.02945296995204571"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.05078508172533026", ",", " ", "0.021783728078581376"}], 
                 "}"}]}], "}"}], ",", " ", "\n", "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                 "0.04709621254603387", ",", " ", "0.02945296995204571"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.03845389651848213", ",", " ", "0.02945296995204571"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.03510892486040767", ",", " ", "0.03675380039988509"}], 
                 "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.042999475662856945", ",", " ", "0.03675380039988509"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.04709621254603387", ",", " ", "0.02945296995204571"}], 
                 "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                 "0.042999475662856945", ",", " ", "0.03675380039988509"}], 
                 "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.03510892486040767", ",", " ", "0.03675380039988509"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.031396066569066176", ",", " ", "0.04353854648936185"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.03845217151233271", ",", " ", "0.04353854648936185"}], 
                 "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.042999475662856945", ",", " ", "0.03675380039988509"}], 
                 "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                 "0.03845217151233271", ",", " ", "0.04353854648936185"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.031396066569066176", ",", " ", "0.04353854648936185"}], 
                 "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.027250831909030646", ",", " ", "0.04966364092329548"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.03337531662173955", ",", " ", "0.04966364092329548"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.03845217151233271", ",", " ", "0.04353854648936185"}], 
                 "}"}]}], "}"}], ",", " ", "\n", "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                 "0.03337531662173956", ",", " ", "0.049663640923295456"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.027250831909030656", ",", " ", "0.049663640923295456"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.022618273056747643", ",", " ", "0.054993963249953474"}], 
                 "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.02770161392598624", ",", " ", "0.054993963249953474"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.03337531662173956", ",", " ", "0.049663640923295456"}], 
                 "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                 "0.02770161392598624", ",", " ", "0.054993963249953474"}], 
                 "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.022618273056747643", ",", " ", "0.054993963249953474"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.01748832854338502", ",", " ", "0.0594072273124165"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.021418740692721937", ",", " ", "0.0594072273124165"}], 
                 "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.02770161392598624", ",", " ", "0.054993963249953474"}], 
                 "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                 "0.021418740692721937", ",", " ", "0.0594072273124165"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.01748832854338502", ",", " ", "0.0594072273124165"}], 
                 "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.011917319654125052", ",", " ", "0.06279819862535355"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.01459567612712384", ",", " ", "0.06279819862535355"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.021418740692721937", ",", " ", "0.0594072273124165"}], 
                 "}"}]}], "}"}], ",", " ", "\n", "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                 "0.01459567612712384", ",", " ", "0.06279819862535355"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.011917319654125052", ",", " ", "0.06279819862535355"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.006029717280723977", ",", " ", "0.06508252495431804"}], 
                 "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.007384865315507928", ",", " ", "0.06508252495431804"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.01459567612712384", ",", " ", "0.06279819862535355"}], 
                 "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                 "0.007384865315507928", ",", " ", "0.06508252495431804"}], 
                 "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.006029717280723977", ",", " ", "0.06508252495431804"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "1.566672139241554*^-17"}], ",", " ", 
                  "0.06619997649057771"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "1.8973538018496328*^-17"}], ",", " ", 
                  "0.06619997649057771"}], "}"}], ",", " ", "\n", 
                "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.007384865315507928", ",", " ", "0.06508252495431804"}], 
                 "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"8.836247705756861*^-18", ",", " ", 
                  RowBox[{"-", "0.05688284915968362"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"6.884683795282953*^-18", ",", " ", 
                  RowBox[{"-", "0.05688284915968362"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"0.0040521765603947395", ",", " ", 
                  RowBox[{"-", "0.0564921568493474"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.005730643048840596", ",", " ", 
                  RowBox[{"-", "0.0564921568493474"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"8.836247705756861*^-18", ",", " ", 
                  RowBox[{"-", "0.05688284915968362"}]}], "}"}]}], "}"}], ",",
               " ", "\n", "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"0.005730643048840596", ",", " ", 
                  RowBox[{"-", "0.0564921568493474"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.0040521765603947395", ",", " ", 
                  RowBox[{"-", "0.0564921568493474"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.008229662822895232", ",", " ", 
                  RowBox[{"-", "0.05521682457414796"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"0.011638500777896084", ",", " ", 
                  RowBox[{"-", "0.05521682457414796"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.005730643048840596", ",", " ", 
                  RowBox[{"-", "0.0564921568493474"}]}], "}"}]}], "}"}], ",", 
              " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"0.011638500777896072", ",", " ", 
                  RowBox[{"-", "0.05521682457414796"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"0.008229662822895225", ",", " ", 
                  RowBox[{"-", "0.05521682457414796"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.012524268787928144", ",", " ", 
                  RowBox[{"-", "0.0530770008349515"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.01771199077869402", ",", " ", 
                  RowBox[{"-", "0.0530770008349515"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"0.011638500777896072", ",", " ", 
                  RowBox[{"-", "0.05521682457414796"}]}], "}"}]}], "}"}], ",",
               " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"0.01771199077869402", ",", " ", 
                  RowBox[{"-", "0.0530770008349515"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.012524268787928144", ",", " ", 
                  RowBox[{"-", "0.0530770008349515"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"0.016858481048417053", ",", " ", 
                  RowBox[{"-", "0.05009952120873742"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.02384149253968118", ",", " ", 
                  RowBox[{"-", "0.05009952120873742"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.01771199077869402", ",", " ", 
                  RowBox[{"-", "0.0530770008349515"}]}], "}"}]}], "}"}], ",", 
              " ", "\n", "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"0.023841492539681177", ",", " ", 
                  RowBox[{"-", "0.050099521208737424"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.01685848104841705", ",", " ", 
                  RowBox[{"-", "0.050099521208737424"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.02108718816231071", ",", " ", 
                  RowBox[{"-", "0.046318106341445356"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"0.029821787491453165", ",", " ", 
                  RowBox[{"-", "0.046318106341445356"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.023841492539681177", ",", " ", 
                  RowBox[{"-", "0.050099521208737424"}]}], "}"}]}], "}"}], 
              ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"0.029821787491453165", ",", " ", 
                  RowBox[{"-", "0.046318106341445356"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"0.02108718816231071", ",", " ", 
                  RowBox[{"-", "0.046318106341445356"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.025017504961568064", ",", " ", 
                  RowBox[{"-", "0.04177394503607659"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.035380094813385735", ",", " ", 
                  RowBox[{"-", "0.04177394503607659"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"0.029821787491453165", ",", " ", 
                  RowBox[{"-", "0.046318106341445356"}]}], "}"}]}], "}"}], 
              ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"0.035380094813385735", ",", " ", 
                  RowBox[{"-", "0.04177394503607659"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.025017504961568064", ",", " ", 
                  RowBox[{"-", "0.04177394503607659"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"0.02844185041928655", ",", " ", 
                  RowBox[{"-", "0.03651657383838262"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.040222850601941924", ",", " ", 
                  RowBox[{"-", "0.03651657383838262"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.035380094813385735", ",", " ", 
                  RowBox[{"-", "0.04177394503607659"}]}], "}"}]}], "}"}], ",",
               " ", "\n", "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"0.04022285060194192", ",", " ", 
                  RowBox[{"-", "0.03651657383838262"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.028441850419286548", ",", " ", 
                  RowBox[{"-", "0.03651657383838262"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.031176071551106854", ",", " ", 
                  RowBox[{"-", "0.03060493068010821"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"0.0440896232090893", ",", " ", 
                  RowBox[{"-", "0.03060493068010821"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.04022285060194192", ",", " ", 
                  RowBox[{"-", "0.03651657383838262"}]}], "}"}]}], "}"}], ",",
               " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"0.0440896232090893", ",", " ", 
                  RowBox[{"-", "0.0306049306801082"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"0.031176071551106858", ",", " ", 
                  RowBox[{"-", "0.0306049306801082"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.033093181797920854", ",", " ", 
                  RowBox[{"-", "0.024108435682384573"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.0468008265206981", ",", " ", 
                  RowBox[{"-", "0.024108435682384573"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"0.0440896232090893", ",", " ", 
                  RowBox[{"-", "0.0306049306801082"}]}], "}"}]}], "}"}], ",", 
              " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"0.0468008265206981", ",", " ", 
                  RowBox[{"-", "0.024108435682384573"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.033093181797920854", ",", " ", 
                  RowBox[{"-", "0.024108435682384573"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"0.034144494894767966", ",", " ", 
                  RowBox[{"-", "0.017107939026036665"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.04828760776055974", ",", " ", 
                  RowBox[{"-", "0.017107939026036665"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.0468008265206981", ",", " ", 
                  RowBox[{"-", "0.024108435682384573"}]}], "}"}]}], "}"}], 
              ",", " ", "\n", "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"0.04828760776055974", ",", " ", 
                  RowBox[{"-", "0.017107939026036665"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.034144494894767966", ",", " ", 
                  RowBox[{"-", "0.017107939026036665"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.03436324409774402", ",", " ", 
                  RowBox[{"-", "0.009696374951067403"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"0.0485969658501668", ",", " ", 
                  RowBox[{"-", "0.009696374951067403"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.04828760776055974", ",", " ", 
                  RowBox[{"-", "0.017107939026036665"}]}], "}"}]}], "}"}], 
              ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"0.0485969658501668", ",", " ", 
                  RowBox[{"-", "0.009696374951067403"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"0.03436324409774402", ",", " ", 
                  RowBox[{"-", "0.009696374951067403"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.03385029664901243", ",", " ", 
                  RowBox[{"-", "0.0019789726801209746"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.04787154861138588", ",", " ", 
                  RowBox[{"-", "0.0019789726801209746"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"0.0485969658501668", ",", " ", 
                  RowBox[{"-", "0.009696374951067403"}]}], "}"}]}], "}"}], 
              ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"0.04787154861138588", ",", " ", 
                  RowBox[{"-", "0.0019789726801209746"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.03385029664901243", ",", " ", 
                  RowBox[{"-", "0.0019789726801209746"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.03274611153671656", ",", " ", "0.005927101286260139"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.0463099950502066", ",", " ", "0.005927101286260139"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.04787154861138588", ",", " ", 
                  RowBox[{"-", "0.0019789726801209746"}]}], "}"}]}], "}"}], 
              ",", " ", "\n", "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                 "0.0463099950502066", ",", " ", "0.0059271012862601264"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.03274611153671656", ",", " ", "0.0059271012862601264"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.031196461036448186", ",", " ", "0.013893760977926984"}], 
                 "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.04411845829578882", ",", " ", "0.013893760977926984"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.0463099950502066", ",", " ", "0.0059271012862601264"}], 
                 "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                 "0.04411845829578882", ",", " ", "0.013893760977926984"}], 
                 "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.031196461036448186", ",", " ", "0.013893760977926984"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.029320780604936595", ",", " ", "0.021783728078581376"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.04146584559086731", ",", " ", "0.021783728078581376"}], 
                 "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.04411845829578882", ",", " ", "0.013893760977926984"}], 
                 "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                 "0.04146584559086731", ",", " ", "0.021783728078581376"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.029320780604936595", ",", " ", "0.021783728078581376"}], 
                 "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.0271910109912645", ",", " ", "0.02945296995204571"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.03845389651848213", ",", " ", "0.02945296995204571"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.04146584559086731", ",", " ", "0.021783728078581376"}], 
                 "}"}]}], "}"}], ",", " ", "\n", "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                 "0.03845389651848213", ",", " ", "0.02945296995204571"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.0271910109912645", ",", " ", "0.02945296995204571"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.024825758848963236", ",", " ", "0.03675380039988509"}], 
                 "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.035108924860407675", ",", " ", "0.03675380039988509"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.03845389651848213", ",", " ", "0.02945296995204571"}], 
                 "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                 "0.035108924860407675", ",", " ", "0.03675380039988509"}], 
                 "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.024825758848963236", ",", " ", "0.03675380039988509"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.022200371573570972", ",", " ", "0.04353854648936185"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.03139606656906618", ",", " ", "0.04353854648936185"}], 
                 "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.035108924860407675", ",", " ", "0.03675380039988509"}], 
                 "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                 "0.03139606656906618", ",", " ", "0.04353854648936185"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.022200371573570972", ",", " ", "0.04353854648936185"}], 
                 "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.01926924803585033", ",", " ", "0.04966364092329548"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.02725083190903065", ",", " ", "0.04966364092329548"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.03139606656906618", ",", " ", "0.04353854648936185"}], 
                 "}"}]}], "}"}], ",", " ", "\n", "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                 "0.027250831909030663", ",", " ", "0.049663640923295456"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.01926924803585034", ",", " ", "0.049663640923295456"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.01599353425715525", ",", " ", "0.054993963249953474"}], 
                 "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.02261827305674765", ",", " ", "0.054993963249953474"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.027250831909030663", ",", " ", "0.049663640923295456"}], 
                 "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                 "0.02261827305674765", ",", " ", "0.054993963249953474"}], 
                 "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.01599353425715525", ",", " ", "0.054993963249953474"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.01236611570464581", ",", " ", "0.0594072273124165"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.017488328543385022", ",", " ", "0.0594072273124165"}], 
                 "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.02261827305674765", ",", " ", "0.054993963249953474"}], 
                 "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                 "0.017488328543385022", ",", " ", "0.0594072273124165"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.01236611570464581", ",", " ", "0.0594072273124165"}], 
                 "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.008426817540999552", ",", " ", "0.06279819862535355"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.011917319654125054", ",", " ", "0.06279819862535355"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.017488328543385022", ",", " ", "0.0594072273124165"}], 
                 "}"}]}], "}"}], ",", " ", "\n", "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                 "0.011917319654125054", ",", " ", "0.06279819862535355"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.008426817540999552", ",", " ", "0.06279819862535355"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.0042636539778376364", ",", " ", "0.06508252495431804"}], 
                 "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.006029717280723979", ",", " ", "0.06508252495431804"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.011917319654125054", ",", " ", "0.06279819862535355"}], 
                 "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                 "0.006029717280723979", ",", " ", "0.06508252495431804"}], 
                 "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.0042636539778376364", ",", " ", "0.06508252495431804"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "1.0516761073109393*^-17"}], ",", " ", 
                  "0.06619997649057771"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "1.5178830414797062*^-17"}], ",", " ", 
                  "0.06619997649057771"}], "}"}], ",", " ", "\n", 
                "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.006029717280723979", ",", " ", "0.06508252495431804"}], 
                 "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"6.5052130349130266*^-18", ",", " ", 
                  RowBox[{"-", "0.05688284915968362"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"3.3610267347050637*^-18", ",", " ", 
                  RowBox[{"-", "0.05688284915968362"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"0.0020975609358963683", ",", " ", 
                  RowBox[{"-", "0.0564921568493474"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.004052176560394739", ",", " ", 
                  RowBox[{"-", "0.0564921568493474"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"6.5052130349130266*^-18", ",", " ", 
                  RowBox[{"-", "0.05688284915968362"}]}], "}"}]}], "}"}], ",",
               " ", "\n", "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"0.004052176560394739", ",", " ", 
                  RowBox[{"-", "0.0564921568493474"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.0020975609358963683", ",", " ", 
                  RowBox[{"-", "0.0564921568493474"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.004259986946674922", ",", " ", 
                  RowBox[{"-", "0.05521682457414796"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"0.00822966282289523", ",", " ", 
                  RowBox[{"-", "0.05521682457414796"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.004052176560394739", ",", " ", 
                  RowBox[{"-", "0.0564921568493474"}]}], "}"}]}], "}"}], ",", 
              " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"0.008229662822895223", ",", " ", 
                  RowBox[{"-", "0.05521682457414796"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"0.0042599869466749185", ",", " ", 
                  RowBox[{"-", "0.05521682457414796"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.006483038576597741", ",", " ", 
                  RowBox[{"-", "0.0530770008349515"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.012524268787928143", ",", " ", 
                  RowBox[{"-", "0.0530770008349515"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"0.008229662822895223", ",", " ", 
                  RowBox[{"-", "0.05521682457414796"}]}], "}"}]}], "}"}], ",",
               " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"0.012524268787928143", ",", " ", 
                  RowBox[{"-", "0.0530770008349515"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.006483038576597741", ",", " ", 
                  RowBox[{"-", "0.0530770008349515"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"0.008726591933660495", ",", " ", 
                  RowBox[{"-", "0.05009952120873742"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.01685848104841705", ",", " ", 
                  RowBox[{"-", "0.05009952120873742"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.012524268787928143", ",", " ", 
                  RowBox[{"-", "0.0530770008349515"}]}], "}"}]}], "}"}], ",", 
              " ", "\n", "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"0.016858481048417046", ",", " ", 
                  RowBox[{"-", "0.050099521208737424"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.008726591933660493", ",", " ", 
                  RowBox[{"-", "0.050099521208737424"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.010915531808132881", ",", " ", 
                  RowBox[{"-", "0.046318106341445356"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"0.021087188162310706", ",", " ", 
                  RowBox[{"-", "0.046318106341445356"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.016858481048417046", ",", " ", 
                  RowBox[{"-", "0.050099521208737424"}]}], "}"}]}], "}"}], 
              ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"0.021087188162310706", ",", " ", 
                  RowBox[{"-", "0.046318106341445356"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"0.010915531808132881", ",", " ", 
                  RowBox[{"-", "0.046318106341445356"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.012950013490001248", ",", " ", 
                  RowBox[{"-", "0.04177394503607659"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.025017504961568057", ",", " ", 
                  RowBox[{"-", "0.04177394503607659"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"0.021087188162310706", ",", " ", 
                  RowBox[{"-", "0.046318106341445356"}]}], "}"}]}], "}"}], 
              ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"0.025017504961568057", ",", " ", 
                  RowBox[{"-", "0.04177394503607659"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.012950013490001248", ",", " ", 
                  RowBox[{"-", "0.04177394503607659"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"0.01472258513293696", ",", " ", 
                  RowBox[{"-", "0.03651657383838262"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.028441850419286544", ",", " ", 
                  RowBox[{"-", "0.03651657383838262"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.025017504961568057", ",", " ", 
                  RowBox[{"-", "0.04177394503607659"}]}], "}"}]}], "}"}], ",",
               " ", "\n", "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"0.02844185041928654", ",", " ", 
                  RowBox[{"-", "0.03651657383838262"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.014722585132936956", ",", " ", 
                  RowBox[{"-", "0.03651657383838262"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.01613792213781069", ",", " ", 
                  RowBox[{"-", "0.03060493068010821"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"0.031176071551106847", ",", " ", 
                  RowBox[{"-", "0.03060493068010821"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.02844185041928654", ",", " ", 
                  RowBox[{"-", "0.03651657383838262"}]}], "}"}]}], "}"}], ",",
               " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"0.03117607155110685", ",", " ", 
                  RowBox[{"-", "0.0306049306801082"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"0.01613792213781069", ",", " ", 
                  RowBox[{"-", "0.0306049306801082"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.017130291424684006", ",", " ", 
                  RowBox[{"-", "0.024108435682384573"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.03309318179792085", ",", " ", 
                  RowBox[{"-", "0.024108435682384573"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"0.03117607155110685", ",", " ", 
                  RowBox[{"-", "0.0306049306801082"}]}], "}"}]}], "}"}], ",", 
              " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"0.03309318179792085", ",", " ", 
                  RowBox[{"-", "0.024108435682384573"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.017130291424684006", ",", " ", 
                  RowBox[{"-", "0.024108435682384573"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"0.017674491128343493", ",", " ", 
                  RowBox[{"-", "0.017107939026036665"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.03414449489476796", ",", " ", 
                  RowBox[{"-", "0.017107939026036665"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.03309318179792085", ",", " ", 
                  RowBox[{"-", "0.024108435682384573"}]}], "}"}]}], "}"}], 
              ",", " ", "\n", "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"0.03414449489476796", ",", " ", 
                  RowBox[{"-", "0.017107939026036665"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.017674491128343493", ",", " ", 
                  RowBox[{"-", "0.017107939026036665"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.0177877240480059", ",", " ", 
                  RowBox[{"-", "0.009696374951067403"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"0.034363244097744015", ",", " ", 
                  RowBox[{"-", "0.009696374951067403"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.03414449489476796", ",", " ", 
                  RowBox[{"-", "0.017107939026036665"}]}], "}"}]}], "}"}], 
              ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"0.034363244097744015", ",", " ", 
                  RowBox[{"-", "0.009696374951067403"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"0.0177877240480059", ",", " ", 
                  RowBox[{"-", "0.009696374951067403"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.01752220291026892", ",", " ", 
                  RowBox[{"-", "0.0019789726801209746"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.03385029664901242", ",", " ", 
                  RowBox[{"-", "0.0019789726801209746"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"0.034363244097744015", ",", " ", 
                  RowBox[{"-", "0.009696374951067403"}]}], "}"}]}], "}"}], 
              ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"0.03385029664901242", ",", " ", 
                  RowBox[{"-", "0.0019789726801209746"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.01752220291026892", ",", " ", 
                  RowBox[{"-", "0.0019789726801209746"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.01695063463750725", ",", " ", "0.005927101286260139"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.032746111536716555", ",", " ", "0.005927101286260139"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.03385029664901242", ",", " ", 
                  RowBox[{"-", "0.0019789726801209746"}]}], "}"}]}], "}"}], 
              ",", " ", "\n", "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                 "0.032746111536716555", ",", " ", "0.0059271012862601264"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.01695063463750725", ",", " ", "0.0059271012862601264"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.01614847651206304", ",", " ", "0.013893760977926984"}], 
                 "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.031196461036448173", ",", " ", "0.013893760977926984"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.032746111536716555", ",", " ", "0.0059271012862601264"}], 
                 "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                 "0.031196461036448173", ",", " ", "0.013893760977926984"}], 
                 "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.01614847651206304", ",", " ", "0.013893760977926984"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.015177552875660414", ",", " ", "0.021783728078581376"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.029320780604936588", ",", " ", "0.021783728078581376"}], 
                 "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.031196461036448173", ",", " ", "0.013893760977926984"}], 
                 "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                 "0.029320780604936588", ",", " ", "0.021783728078581376"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.015177552875660414", ",", " ", "0.021783728078581376"}], 
                 "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.014075103000262457", ",", " ", "0.02945296995204571"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.027191010991264492", ",", " ", "0.02945296995204571"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.029320780604936588", ",", " ", "0.021783728078581376"}], 
                 "}"}]}], "}"}], ",", " ", "\n", "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                 "0.027191010991264492", ",", " ", "0.02945296995204571"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.014075103000262457", ",", " ", "0.02945296995204571"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.012850758398468252", ",", " ", "0.03675380039988509"}], 
                 "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.024825758848963233", ",", " ", "0.03675380039988509"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.027191010991264492", ",", " ", "0.02945296995204571"}], 
                 "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                 "0.024825758848963233", ",", " ", "0.03675380039988509"}], 
                 "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.012850758398468252", ",", " ", "0.03675380039988509"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.011491757943185577", ",", " ", "0.04353854648936185"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.02220037157357097", ",", " ", "0.04353854648936185"}], 
                 "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.024825758848963233", ",", " ", "0.03675380039988509"}], 
                 "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                 "0.02220037157357097", ",", " ", "0.04353854648936185"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.011491757943185577", ",", " ", "0.04353854648936185"}], 
                 "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.00997449675296482", ",", " ", "0.04966364092329548"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.019269248035850325", ",", " ", "0.04966364092329548"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.02220037157357097", ",", " ", "0.04353854648936185"}], 
                 "}"}]}], "}"}], ",", " ", "\n", "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                 "0.019269248035850336", ",", " ", "0.049663640923295456"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.009974496752964824", ",", " ", "0.049663640923295456"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.008278862528502757", ",", " ", "0.054993963249953474"}], 
                 "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.015993534257155245", ",", " ", "0.054993963249953474"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.019269248035850336", ",", " ", "0.049663640923295456"}], 
                 "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                 "0.015993534257155245", ",", " ", "0.054993963249953474"}], 
                 "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.008278862528502757", ",", " ", "0.054993963249953474"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.006401172516607435", ",", " ", "0.0594072273124165"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.01236611570464581", ",", " ", "0.0594072273124165"}], 
                 "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.015993534257155245", ",", " ", "0.054993963249953474"}], 
                 "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                 "0.01236611570464581", ",", " ", "0.0594072273124165"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.006401172516607435", ",", " ", "0.0594072273124165"}], 
                 "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.004362041738429354", ",", " ", "0.06279819862535355"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.00842681754099955", ",", " ", "0.06279819862535355"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.01236611570464581", ",", " ", "0.0594072273124165"}], 
                 "}"}]}], "}"}], ",", " ", "\n", "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                 "0.00842681754099955", ",", " ", "0.06279819862535355"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.004362041738429354", ",", " ", "0.06279819862535355"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.002207029702383004", ",", " ", "0.06508252495431804"}], 
                 "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.004263653977837636", ",", " ", "0.06508252495431804"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.00842681754099955", ",", " ", "0.06279819862535355"}], 
                 "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                 "0.004263653977837636", ",", " ", "0.06508252495431804"}], 
                 "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.002207029702383004", ",", " ", "0.06508252495431804"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "5.55653613398821*^-18"}], ",", " ", 
                  "0.06619997649057771"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "1.0516761073109393*^-17"}], ",", " ", 
                  "0.06619997649057771"}], "}"}], ",", " ", "\n", 
                "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.004263653977837636", ",", " ", "0.06508252495431804"}], 
                 "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"3.469446951953614*^-18", ",", " ", 
                  RowBox[{"-", "0.05688284915968362"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"1.0448169948300755*^-32", ",", " ", 
                  RowBox[{"-", "0.05688284915968362"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"5.894832166062664*^-18", ",", " ", 
                  RowBox[{"-", "0.0564921568493474"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.0020975609358963713", ",", " ", 
                  RowBox[{"-", "0.0564921568493474"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"3.469446951953614*^-18", ",", " ", 
                  RowBox[{"-", "0.05688284915968362"}]}], "}"}]}], "}"}], ",",
               " ", "\n", "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"0.0020975609358963713", ",", " ", 
                  RowBox[{"-", "0.0564921568493474"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"5.894832166062664*^-18", ",", " ", 
                  RowBox[{"-", "0.0564921568493474"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"1.1971956404467993*^-17", ",", " ", 
                  RowBox[{"-", "0.05521682457414796"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"0.004259986946674926", ",", " ", 
                  RowBox[{"-", "0.05521682457414796"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.0020975609358963713", ",", " ", 
                  RowBox[{"-", "0.0564921568493474"}]}], "}"}]}], "}"}], ",", 
              " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"0.004259986946674923", ",", " ", 
                  RowBox[{"-", "0.05521682457414796"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"1.1971956404467981*^-17", ",", " ", 
                  RowBox[{"-", "0.05521682457414796"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"1.8219458458222152*^-17", ",", " ", 
                  RowBox[{"-", "0.0530770008349515"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.006483038576597747", ",", " ", 
                  RowBox[{"-", "0.0530770008349515"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"0.004259986946674923", ",", " ", 
                  RowBox[{"-", "0.05521682457414796"}]}], "}"}]}], "}"}], ",",
               " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"0.006483038576597747", ",", " ", 
                  RowBox[{"-", "0.0530770008349515"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"1.8219458458222152*^-17", ",", " ", 
                  RowBox[{"-", "0.0530770008349515"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"2.4524577069634367*^-17", ",", " ", 
                  RowBox[{"-", "0.05009952120873742"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.008726591933660507", ",", " ", 
                  RowBox[{"-", "0.05009952120873742"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.006483038576597747", ",", " ", 
                  RowBox[{"-", "0.0530770008349515"}]}], "}"}]}], "}"}], ",", 
              " ", "\n", "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"0.008726591933660504", ",", " ", 
                  RowBox[{"-", "0.050099521208737424"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"2.452457706963436*^-17", ",", " ", 
                  RowBox[{"-", "0.050099521208737424"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"3.0676213935479624*^-17", ",", " ", 
                  RowBox[{"-", "0.046318106341445356"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"0.010915531808132893", ",", " ", 
                  RowBox[{"-", "0.046318106341445356"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.008726591933660504", ",", " ", 
                  RowBox[{"-", "0.050099521208737424"}]}], "}"}]}], "}"}], 
              ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"0.010915531808132893", ",", " ", 
                  RowBox[{"-", "0.046318106341445356"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"3.0676213935479624*^-17", ",", " ", 
                  RowBox[{"-", "0.046318106341445356"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"3.639377276979205*^-17", ",", " ", 
                  RowBox[{"-", "0.04177394503607659"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.012950013490001265", ",", " ", 
                  RowBox[{"-", "0.04177394503607659"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"0.010915531808132893", ",", " ", 
                  RowBox[{"-", "0.046318106341445356"}]}], "}"}]}], "}"}], 
              ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"0.012950013490001265", ",", " ", 
                  RowBox[{"-", "0.04177394503607659"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"3.639377276979205*^-17", ",", " ", 
                  RowBox[{"-", "0.04177394503607659"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"4.1375278745904585*^-17", ",", " ", 
                  RowBox[{"-", "0.03651657383838262"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.014722585132936976", ",", " ", 
                  RowBox[{"-", "0.03651657383838262"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.012950013490001265", ",", " ", 
                  RowBox[{"-", "0.04177394503607659"}]}], "}"}]}], "}"}], ",",
               " ", "\n", "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"0.014722585132936974", ",", " ", 
                  RowBox[{"-", "0.03651657383838262"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"4.137527874590458*^-17", ",", " ", 
                  RowBox[{"-", "0.03651657383838262"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"4.5352838567585327*^-17", ",", " ", 
                  RowBox[{"-", "0.03060493068010821"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"0.016137922137810703", ",", " ", 
                  RowBox[{"-", "0.03060493068010821"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.014722585132936974", ",", " ", 
                  RowBox[{"-", "0.03651657383838262"}]}], "}"}]}], "}"}], ",",
               " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"0.016137922137810706", ",", " ", 
                  RowBox[{"-", "0.0306049306801082"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"4.535283856758533*^-17", ",", " ", 
                  RowBox[{"-", "0.0306049306801082"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"4.814172078443193*^-17", ",", " ", 
                  RowBox[{"-", "0.024108435682384573"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.017130291424684023", ",", " ", 
                  RowBox[{"-", "0.024108435682384573"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"0.016137922137810706", ",", " ", 
                  RowBox[{"-", "0.0306049306801082"}]}], "}"}]}], "}"}], ",", 
              " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"0.017130291424684023", ",", " ", 
                  RowBox[{"-", "0.024108435682384573"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"4.814172078443193*^-17", ",", " ", 
                  RowBox[{"-", "0.024108435682384573"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"4.967109991377905*^-17", ",", " ", 
                  RowBox[{"-", "0.017107939026036665"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.017674491128343513", ",", " ", 
                  RowBox[{"-", "0.017107939026036665"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.017130291424684023", ",", " ", 
                  RowBox[{"-", "0.024108435682384573"}]}], "}"}]}], "}"}], 
              ",", " ", "\n", "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"0.017674491128343513", ",", " ", 
                  RowBox[{"-", "0.017107939026036665"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"4.967109991377905*^-17", ",", " ", 
                  RowBox[{"-", "0.017107939026036665"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"4.998932144701803*^-17", ",", " ", 
                  RowBox[{"-", "0.009696374951067403"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"0.017787724048005916", ",", " ", 
                  RowBox[{"-", "0.009696374951067403"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.017674491128343513", ",", " ", 
                  RowBox[{"-", "0.017107939026036665"}]}], "}"}]}], "}"}], 
              ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"0.017787724048005916", ",", " ", 
                  RowBox[{"-", "0.009696374951067403"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"4.998932144701803*^-17", ",", " ", 
                  RowBox[{"-", "0.009696374951067403"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"4.924312022029056*^-17", ",", " ", 
                  RowBox[{"-", "0.0019789726801209746"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.017522202910268937", ",", " ", 
                  RowBox[{"-", "0.0019789726801209746"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"0.017787724048005916", ",", " ", 
                  RowBox[{"-", "0.009696374951067403"}]}], "}"}]}], "}"}], 
              ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"0.017522202910268937", ",", " ", 
                  RowBox[{"-", "0.0019789726801209746"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"4.924312022029056*^-17", ",", " ", 
                  RowBox[{"-", "0.0019789726801209746"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "4.76368264618036*^-17", ",", " ", "0.005927101286260139"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.016950634637507265", ",", " ", "0.005927101286260139"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"0.017522202910268937", ",", " ", 
                  RowBox[{"-", "0.0019789726801209746"}]}], "}"}]}], "}"}], 
              ",", " ", "\n", "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                 "0.01695063463750727", ",", " ", "0.0059271012862601264"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "4.7636826461803607*^-17", ",", " ", 
                  "0.0059271012862601264"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "4.538249981068472*^-17", ",", " ", "0.013893760977926984"}],
                  "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.016148476512063057", ",", " ", "0.013893760977926984"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.01695063463750727", ",", " ", "0.0059271012862601264"}], 
                 "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                 "0.016148476512063057", ",", " ", "0.013893760977926984"}], 
                 "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "4.538249981068472*^-17", ",", " ", "0.013893760977926984"}],
                  "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "4.265388688473371*^-17", ",", " ", "0.021783728078581376"}],
                  "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.015177552875660427", ",", " ", "0.021783728078581376"}], 
                 "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.016148476512063057", ",", " ", "0.013893760977926984"}], 
                 "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                 "0.015177552875660427", ",", " ", "0.021783728078581376"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "4.265388688473371*^-17", ",", " ", "0.021783728078581376"}],
                  "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "3.955564221600828*^-17", ",", " ", "0.02945296995204571"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.014075103000262473", ",", " ", "0.02945296995204571"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.015177552875660427", ",", " ", "0.021783728078581376"}], 
                 "}"}]}], "}"}], ",", " ", "\n", "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                 "0.014075103000262473", ",", " ", "0.02945296995204571"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "3.955564221600828*^-17", ",", " ", "0.02945296995204571"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "3.6114833504571513*^-17", ",", " ", "0.03675380039988509"}],
                  "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.012850758398468264", ",", " ", "0.03675380039988509"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.014075103000262473", ",", " ", "0.02945296995204571"}], 
                 "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                 "0.012850758398468264", ",", " ", "0.03675380039988509"}], 
                 "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "3.6114833504571513*^-17", ",", " ", "0.03675380039988509"}],
                  "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "3.2295597810200304*^-17", ",", " ", "0.04353854648936185"}],
                  "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.01149175794318559", ",", " ", "0.04353854648936185"}], 
                 "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.012850758398468264", ",", " ", "0.03675380039988509"}], 
                 "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                 "0.01149175794318559", ",", " ", "0.04353854648936185"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "3.2295597810200304*^-17", ",", " ", "0.04353854648936185"}],
                  "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "2.803159769684496*^-17", ",", " ", "0.04966364092329548"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.00997449675296483", ",", " ", "0.04966364092329548"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.01149175794318559", ",", " ", "0.04353854648936185"}], 
                 "}"}]}], "}"}], ",", " ", "\n", "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                 "0.009974496752964836", ",", " ", "0.049663640923295456"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "2.803159769684498*^-17", ",", " ", "0.049663640923295456"}],
                  "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "2.3266311026417802*^-17", ",", " ", 
                  "0.054993963249953474"}], "}"}], ",", " ", "\n", 
                "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.008278862528502766", ",", " ", "0.054993963249953474"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.009974496752964836", ",", " ", "0.049663640923295456"}], 
                 "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                 "0.008278862528502766", ",", " ", "0.054993963249953474"}], 
                 "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "2.3266311026417802*^-17", ",", " ", 
                  "0.054993963249953474"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "1.7989388058129848*^-17", ",", " ", "0.0594072273124165"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.00640117251660744", ",", " ", "0.0594072273124165"}], 
                 "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.008278862528502766", ",", " ", "0.054993963249953474"}], 
                 "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                 "0.00640117251660744", ",", " ", "0.0594072273124165"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "1.7989388058129848*^-17", ",", " ", "0.0594072273124165"}], 
                 "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "1.2258763742857792*^-17", ",", " ", "0.06279819862535355"}],
                  "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.004362041738429359", ",", " ", "0.06279819862535355"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.00640117251660744", ",", " ", "0.0594072273124165"}], 
                 "}"}]}], "}"}], ",", " ", "\n", "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                 "0.004362041738429359", ",", " ", "0.06279819862535355"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "1.2258763742857792*^-17", ",", " ", "0.06279819862535355"}],
                  "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "6.202475197939047*^-18", ",", " ", "0.06508252495431804"}], 
                 "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.002207029702383006", ",", " ", "0.06508252495431804"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.004362041738429359", ",", " ", "0.06279819862535355"}], 
                 "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                 "0.002207029702383006", ",", " ", "0.06508252495431804"}], 
                 "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "6.202475197939047*^-18", ",", " ", "0.06508252495431804"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "1.617781153285278*^-32"}], ",", " ", 
                  "0.06619997649057771"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "5.800481622797449*^-18"}], ",", " ", 
                  "0.06619997649057771"}], "}"}], ",", " ", "\n", 
                "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "0.002207029702383006", ",", " ", "0.06508252495431804"}], 
                 "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"7.884275709835247*^-34", ",", " ", 
                  RowBox[{"-", "0.05688284915968362"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "3.63207727782644*^-18"}], ",", " ", 
                  RowBox[{"-", "0.05688284915968362"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.0020975609358963652"}], ",", " ", 
                  RowBox[{"-", "0.0564921568493474"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"4.962485054267345*^-19", ",", " ", 
                  RowBox[{"-", "0.0564921568493474"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"7.884275709835247*^-34", ",", " ", 
                  RowBox[{"-", "0.05688284915968362"}]}], "}"}]}], "}"}], ",",
               " ", "\n", "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"4.962485054267345*^-19", ",", " ", 
                  RowBox[{"-", "0.0564921568493474"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.0020975609358963652"}], ",", " ", 
                  RowBox[{"-", "0.0564921568493474"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.004259986946674914"}], ",", " ", 
                  RowBox[{"-", "0.05521682457414796"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"1.0078430234120608*^-18", ",", " ", 
                  RowBox[{"-", "0.05521682457414796"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"4.962485054267345*^-19", ",", " ", 
                  RowBox[{"-", "0.0564921568493474"}]}], "}"}]}], "}"}], ",", 
              " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"1.0078430234120602*^-18", ",", " ", 
                  RowBox[{"-", "0.05521682457414796"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.004259986946674911"}], ",", " ", 
                  RowBox[{"-", "0.05521682457414796"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.006483038576597728"}], ",", " ", 
                  RowBox[{"-", "0.0530770008349515"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"1.533780568279729*^-18", ",", " ", 
                  RowBox[{"-", "0.0530770008349515"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"1.0078430234120602*^-18", ",", " ", 
                  RowBox[{"-", "0.05521682457414796"}]}], "}"}]}], "}"}], ",",
               " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"1.533780568279729*^-18", ",", " ", 
                  RowBox[{"-", "0.0530770008349515"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.006483038576597728"}], ",", " ", 
                  RowBox[{"-", "0.0530770008349515"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.008726591933660481"}], ",", " ", 
                  RowBox[{"-", "0.05009952120873742"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"2.0645684854430247*^-18", ",", " ", 
                  RowBox[{"-", "0.05009952120873742"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"1.533780568279729*^-18", ",", " ", 
                  RowBox[{"-", "0.0530770008349515"}]}], "}"}]}], "}"}], ",", 
              " ", "\n", "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"2.0645684854430243*^-18", ",", " ", 
                  RowBox[{"-", "0.050099521208737424"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.00872659193366048"}], ",", " ", 
                  RowBox[{"-", "0.050099521208737424"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.010915531808132858"}], ",", " ", 
                  RowBox[{"-", "0.046318106341445356"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"2.5824357485991746*^-18", ",", " ", 
                  RowBox[{"-", "0.046318106341445356"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"2.0645684854430243*^-18", ",", " ", 
                  RowBox[{"-", "0.050099521208737424"}]}], "}"}]}], "}"}], 
              ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"2.5824357485991746*^-18", ",", " ", 
                  RowBox[{"-", "0.046318106341445356"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.010915531808132858"}], ",", " ", 
                  RowBox[{"-", "0.046318106341445356"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.012950013490001223"}], ",", " ", 
                  RowBox[{"-", "0.04177394503607659"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"3.0637607373837326*^-18", ",", " ", 
                  RowBox[{"-", "0.04177394503607659"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"2.5824357485991746*^-18", ",", " ", 
                  RowBox[{"-", "0.046318106341445356"}]}], "}"}]}], "}"}], 
              ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"3.0637607373837326*^-18", ",", " ", 
                  RowBox[{"-", "0.04177394503607659"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.012950013490001223"}], ",", " ", 
                  RowBox[{"-", "0.04177394503607659"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.014722585132936932"}], ",", " ", 
                  RowBox[{"-", "0.03651657383838262"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"3.4831221077807054*^-18", ",", " ", 
                  RowBox[{"-", "0.03651657383838262"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"3.0637607373837326*^-18", ",", " ", 
                  RowBox[{"-", "0.04177394503607659"}]}], "}"}]}], "}"}], ",",
               " ", "\n", "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"3.483122107780705*^-18", ",", " ", 
                  RowBox[{"-", "0.03651657383838262"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.01472258513293693"}], ",", " ", 
                  RowBox[{"-", "0.03651657383838262"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.01613792213781066"}], ",", " ", 
                  RowBox[{"-", "0.03060493068010821"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"3.817967623505183*^-18", ",", " ", 
                  RowBox[{"-", "0.03060493068010821"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"3.483122107780705*^-18", ",", " ", 
                  RowBox[{"-", "0.03651657383838262"}]}], "}"}]}], "}"}], ",",
               " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"3.817967623505185*^-18", ",", " ", 
                  RowBox[{"-", "0.0306049306801082"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.016137922137810658"}], ",", " ", 
                  RowBox[{"-", "0.0306049306801082"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.017130291424683974"}], ",", " ", 
                  RowBox[{"-", "0.024108435682384573"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"4.0527459162425184*^-18", ",", " ", 
                  RowBox[{"-", "0.024108435682384573"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"3.817967623505185*^-18", ",", " ", 
                  RowBox[{"-", "0.0306049306801082"}]}], "}"}]}], "}"}], ",", 
              " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"4.0527459162425184*^-18", ",", " ", 
                  RowBox[{"-", "0.024108435682384573"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.017130291424683974"}], ",", " ", 
                  RowBox[{"-", "0.024108435682384573"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.017674491128343458"}], ",", " ", 
                  RowBox[{"-", "0.017107939026036665"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"4.18149463813807*^-18", ",", " ", 
                  RowBox[{"-", "0.017107939026036665"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"4.0527459162425184*^-18", ",", " ", 
                  RowBox[{"-", "0.024108435682384573"}]}], "}"}]}], "}"}], 
              ",", " ", "\n", "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"4.18149463813807*^-18", ",", " ", 
                  RowBox[{"-", "0.017107939026036665"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.017674491128343458"}], ",", " ", 
                  RowBox[{"-", "0.017107939026036665"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.017787724048005864"}], ",", " ", 
                  RowBox[{"-", "0.009696374951067403"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"4.208283689262138*^-18", ",", " ", 
                  RowBox[{"-", "0.009696374951067403"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"4.18149463813807*^-18", ",", " ", 
                  RowBox[{"-", "0.017107939026036665"}]}], "}"}]}], "}"}], 
              ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"4.208283689262138*^-18", ",", " ", 
                  RowBox[{"-", "0.009696374951067403"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.017787724048005864"}], ",", " ", 
                  RowBox[{"-", "0.009696374951067403"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.017522202910268885"}], ",", " ", 
                  RowBox[{"-", "0.0019789726801209746"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"4.1454657441401395*^-18", ",", " ", 
                  RowBox[{"-", "0.0019789726801209746"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{"4.208283689262138*^-18", ",", " ", 
                  RowBox[{"-", "0.009696374951067403"}]}], "}"}]}], "}"}], 
              ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"4.1454657441401395*^-18", ",", " ", 
                  RowBox[{"-", "0.0019789726801209746"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.017522202910268885"}], ",", " ", 
                  RowBox[{"-", "0.0019789726801209746"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.016950634637507213"}], ",", " ", 
                  "0.005927101286260139"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "4.0102420677962115*^-18", ",", " ", 
                  "0.005927101286260139"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{"4.1454657441401395*^-18", ",", " ", 
                  RowBox[{"-", "0.0019789726801209746"}]}], "}"}]}], "}"}], 
              ",", " ", "\n", "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                 "4.0102420677962115*^-18", ",", " ", 
                  "0.0059271012862601264"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.016950634637507216"}], ",", " ", 
                  "0.0059271012862601264"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.01614847651206301"}], ",", " ", 
                  "0.013893760977926984"}], "}"}], ",", " ", "\n", 
                "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "3.820464615301136*^-18", ",", " ", "0.013893760977926984"}],
                  "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "4.0102420677962115*^-18", ",", " ", 
                  "0.0059271012862601264"}], "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                 "3.820464615301136*^-18", ",", " ", "0.013893760977926984"}],
                  "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.01614847651206301"}], ",", " ", 
                  "0.013893760977926984"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.015177552875660381"}], ",", " ", 
                  "0.021783728078581376"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "3.590760011633737*^-18", ",", " ", "0.021783728078581376"}],
                  "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "3.820464615301136*^-18", ",", " ", "0.013893760977926984"}],
                  "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                 "3.590760011633737*^-18", ",", " ", "0.021783728078581376"}],
                  "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.015177552875660381"}], ",", " ", 
                  "0.021783728078581376"}], "}"}], ",", " ", "\n", 
                "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.014075103000262431"}], ",", " ", 
                  "0.02945296995204571"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "3.3299384576032546*^-18", ",", " ", "0.02945296995204571"}],
                  "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "3.590760011633737*^-18", ",", " ", "0.021783728078581376"}],
                  "}"}]}], "}"}], ",", " ", "\n", "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                 "3.3299384576032546*^-18", ",", " ", "0.02945296995204571"}],
                  "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.014075103000262431"}], ",", " ", 
                  "0.02945296995204571"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.012850758398468224"}], ",", " ", 
                  "0.03675380039988509"}], "}"}], ",", " ", "\n", 
                "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "3.040278611078688*^-18", ",", " ", "0.03675380039988509"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "3.3299384576032546*^-18", ",", " ", "0.02945296995204571"}],
                  "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                 "3.040278611078688*^-18", ",", " ", "0.03675380039988509"}], 
                 "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.012850758398468224"}], ",", " ", 
                  "0.03675380039988509"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.011491757943185554"}], ",", " ", 
                  "0.04353854648936185"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "2.7187613987455556*^-18", ",", " ", "0.04353854648936185"}],
                  "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "3.040278611078688*^-18", ",", " ", "0.03675380039988509"}], 
                 "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                 "2.7187613987455556*^-18", ",", " ", "0.04353854648936185"}],
                  "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.011491757943185554"}], ",", " ", 
                  "0.04353854648936185"}], "}"}], ",", " ", "\n", 
                "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.009974496752964801"}], ",", " ", 
                  "0.04966364092329548"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "2.3598022929080513*^-18", ",", " ", "0.04966364092329548"}],
                  "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "2.7187613987455556*^-18", ",", " ", "0.04353854648936185"}],
                  "}"}]}], "}"}], ",", " ", "\n", "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                 "2.3598022929080517*^-18", ",", " ", 
                  "0.049663640923295456"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.009974496752964806"}], ",", " ", 
                  "0.049663640923295456"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.008278862528502741"}], ",", " ", 
                  "0.054993963249953474"}], "}"}], ",", " ", "\n", 
                "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "1.95864305350787*^-18", ",", " ", "0.054993963249953474"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "2.3598022929080517*^-18", ",", " ", 
                  "0.049663640923295456"}], "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                 "1.95864305350787*^-18", ",", " ", "0.054993963249953474"}], 
                 "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.008278862528502741"}], ",", " ", 
                  "0.054993963249953474"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.00640117251660742"}], ",", " ", 
                  "0.0594072273124165"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "1.5144124015580296*^-18", ",", " ", "0.0594072273124165"}], 
                 "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "1.95864305350787*^-18", ",", " ", "0.054993963249953474"}], 
                 "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                 "1.5144124015580296*^-18", ",", " ", "0.0594072273124165"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.00640117251660742"}], ",", " ", 
                  "0.0594072273124165"}], "}"}], ",", " ", "\n", 
                "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.004362041738429346"}], ",", " ", 
                  "0.06279819862535355"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "1.031987512858386*^-18", ",", " ", "0.06279819862535355"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "1.5144124015580296*^-18", ",", " ", "0.0594072273124165"}], 
                 "}"}]}], "}"}], ",", " ", "\n", "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                 "1.031987512858386*^-18", ",", " ", "0.06279819862535355"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.004362041738429346"}], ",", " ", 
                  "0.06279819862535355"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.0022070297023829995"}], ",", " ", 
                  "0.06508252495431804"}], "}"}], ",", " ", "\n", 
                "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "5.221470196630737*^-19", ",", " ", "0.06508252495431804"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "1.031987512858386*^-18", ",", " ", "0.06279819862535355"}], 
                 "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                 "5.221470196630737*^-19", ",", " ", "0.06508252495431804"}], 
                 "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.0022070297023829995"}], ",", " ", 
                  "0.06508252495431804"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "5.854691731421724*^-18", ",", " ", "0.06619997649057771"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "1.3000027124613842*^-33"}], ",", " ", 
                  "0.06619997649057771"}], "}"}], ",", " ", "\n", 
                "           ", 
                RowBox[{"{", 
                 RowBox[{
                 "5.221470196630737*^-19", ",", " ", "0.06508252495431804"}], 
                 "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "3.3068166260807885*^-18"}], ",", " ", 
                  RowBox[{"-", "0.05688284915968362"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "6.7220534694101275*^-18"}], ",", " ", 
                  RowBox[{"-", "0.05688284915968362"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.004052176560394734"}], ",", " ", 
                  RowBox[{"-", "0.0564921568493474"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.002097560935896362"}], ",", " ", 
                  RowBox[{"-", "0.0564921568493474"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "3.3068166260807885*^-18"}], ",", " ", 
                  RowBox[{"-", "0.05688284915968362"}]}], "}"}]}], "}"}], ",",
               " ", "\n", "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.002097560935896362"}], ",", " ", 
                  RowBox[{"-", "0.0564921568493474"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.004052176560394734"}], ",", " ", 
                  RowBox[{"-", "0.0564921568493474"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.008229662822895223"}], ",", " ", 
                  RowBox[{"-", "0.05521682457414796"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.004259986946674909"}], ",", " ", 
                  RowBox[{"-", "0.05521682457414796"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.002097560935896362"}], ",", " ", 
                  RowBox[{"-", "0.0564921568493474"}]}], "}"}]}], "}"}], ",", 
              " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.004259986946674905"}], ",", " ", 
                  RowBox[{"-", "0.05521682457414796"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.008229662822895216"}], ",", " ", 
                  RowBox[{"-", "0.05521682457414796"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.01252426878792813"}], ",", " ", 
                  RowBox[{"-", "0.0530770008349515"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.00648303857659772"}], ",", " ", 
                  RowBox[{"-", "0.0530770008349515"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.004259986946674905"}], ",", " ", 
                  RowBox[{"-", "0.05521682457414796"}]}], "}"}]}], "}"}], ",",
               " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.00648303857659772"}], ",", " ", 
                  RowBox[{"-", "0.0530770008349515"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.01252426878792813"}], ",", " ", 
                  RowBox[{"-", "0.0530770008349515"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.016858481048417036"}], ",", " ", 
                  RowBox[{"-", "0.05009952120873742"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.00872659193366047"}], ",", " ", 
                  RowBox[{"-", "0.05009952120873742"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.00648303857659772"}], ",", " ", 
                  RowBox[{"-", "0.0530770008349515"}]}], "}"}]}], "}"}], ",", 
              " ", "\n", "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.008726591933660469"}], ",", " ", 
                  RowBox[{"-", "0.050099521208737424"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.016858481048417032"}], ",", " ", 
                  RowBox[{"-", "0.050099521208737424"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.021087188162310682"}], ",", " ", 
                  RowBox[{"-", "0.046318106341445356"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.01091553180813285"}], ",", " ", 
                  RowBox[{"-", "0.046318106341445356"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.008726591933660469"}], ",", " ", 
                  RowBox[{"-", "0.050099521208737424"}]}], "}"}]}], "}"}], 
              ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.01091553180813285"}], ",", " ", 
                  RowBox[{"-", "0.046318106341445356"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.021087188162310682"}], ",", " ", 
                  RowBox[{"-", "0.046318106341445356"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.025017504961568026"}], ",", " ", 
                  RowBox[{"-", "0.04177394503607659"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.01295001349000121"}], ",", " ", 
                  RowBox[{"-", "0.04177394503607659"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.01091553180813285"}], ",", " ", 
                  RowBox[{"-", "0.046318106341445356"}]}], "}"}]}], "}"}], 
              ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.01295001349000121"}], ",", " ", 
                  RowBox[{"-", "0.04177394503607659"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.025017504961568026"}], ",", " ", 
                  RowBox[{"-", "0.04177394503607659"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.028441850419286513"}], ",", " ", 
                  RowBox[{"-", "0.03651657383838262"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.014722585132936917"}], ",", " ", 
                  RowBox[{"-", "0.03651657383838262"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.01295001349000121"}], ",", " ", 
                  RowBox[{"-", "0.04177394503607659"}]}], "}"}]}], "}"}], ",",
               " ", "\n", "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.014722585132936913"}], ",", " ", 
                  RowBox[{"-", "0.03651657383838262"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.02844185041928651"}], ",", " ", 
                  RowBox[{"-", "0.03651657383838262"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.031176071551106816"}], ",", " ", 
                  RowBox[{"-", "0.03060493068010821"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.01613792213781064"}], ",", " ", 
                  RowBox[{"-", "0.03060493068010821"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.014722585132936913"}], ",", " ", 
                  RowBox[{"-", "0.03651657383838262"}]}], "}"}]}], "}"}], ",",
               " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.016137922137810644"}], ",", " ", 
                  RowBox[{"-", "0.0306049306801082"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.03117607155110682"}], ",", " ", 
                  RowBox[{"-", "0.0306049306801082"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.03309318179792082"}], ",", " ", 
                  RowBox[{"-", "0.024108435682384573"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.017130291424683957"}], ",", " ", 
                  RowBox[{"-", "0.024108435682384573"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.016137922137810644"}], ",", " ", 
                  RowBox[{"-", "0.0306049306801082"}]}], "}"}]}], "}"}], ",", 
              " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.017130291424683957"}], ",", " ", 
                  RowBox[{"-", "0.024108435682384573"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.03309318179792082"}], ",", " ", 
                  RowBox[{"-", "0.024108435682384573"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.034144494894767924"}], ",", " ", 
                  RowBox[{"-", "0.017107939026036665"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.01767449112834344"}], ",", " ", 
                  RowBox[{"-", "0.017107939026036665"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.017130291424683957"}], ",", " ", 
                  RowBox[{"-", "0.024108435682384573"}]}], "}"}]}], "}"}], 
              ",", " ", "\n", "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.01767449112834344"}], ",", " ", 
                  RowBox[{"-", "0.017107939026036665"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.034144494894767924"}], ",", " ", 
                  RowBox[{"-", "0.017107939026036665"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.03436324409774398"}], ",", " ", 
                  RowBox[{"-", "0.009696374951067403"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.017787724048005844"}], ",", " ", 
                  RowBox[{"-", "0.009696374951067403"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.01767449112834344"}], ",", " ", 
                  RowBox[{"-", "0.017107939026036665"}]}], "}"}]}], "}"}], 
              ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.017787724048005844"}], ",", " ", 
                  RowBox[{"-", "0.009696374951067403"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.03436324409774398"}], ",", " ", 
                  RowBox[{"-", "0.009696374951067403"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.03385029664901239"}], ",", " ", 
                  RowBox[{"-", "0.0019789726801209746"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.017522202910268868"}], ",", " ", 
                  RowBox[{"-", "0.0019789726801209746"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.017787724048005844"}], ",", " ", 
                  RowBox[{"-", "0.009696374951067403"}]}], "}"}]}], "}"}], 
              ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.017522202910268868"}], ",", " ", 
                  RowBox[{"-", "0.0019789726801209746"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.03385029664901239"}], ",", " ", 
                  RowBox[{"-", "0.0019789726801209746"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.03274611153671652"}], ",", " ", 
                  "0.005927101286260139"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.016950634637507195"}], ",", " ", 
                  "0.005927101286260139"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.017522202910268868"}], ",", " ", 
                  RowBox[{"-", "0.0019789726801209746"}]}], "}"}]}], "}"}], 
              ",", " ", "\n", "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.016950634637507195"}], ",", " ", 
                  "0.0059271012862601264"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.03274611153671652"}], ",", " ", 
                  "0.0059271012862601264"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.031196461036448145"}], ",", " ", 
                  "0.013893760977926984"}], "}"}], ",", " ", "\n", 
                "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.01614847651206299"}], ",", " ", 
                  "0.013893760977926984"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.016950634637507195"}], ",", " ", 
                  "0.0059271012862601264"}], "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.01614847651206299"}], ",", " ", 
                  "0.013893760977926984"}], "}"}], ",", " ", "\n", 
                "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.031196461036448145"}], ",", " ", 
                  "0.013893760977926984"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.02932078060493656"}], ",", " ", 
                  "0.021783728078581376"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.015177552875660368"}], ",", " ", 
                  "0.021783728078581376"}], "}"}], ",", " ", "\n", 
                "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.01614847651206299"}], ",", " ", 
                  "0.013893760977926984"}], "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.015177552875660368"}], ",", " ", 
                  "0.021783728078581376"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.02932078060493656"}], ",", " ", 
                  "0.021783728078581376"}], "}"}], ",", " ", "\n", 
                "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.027191010991264468"}], ",", " ", 
                  "0.02945296995204571"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.014075103000262417"}], ",", " ", 
                  "0.02945296995204571"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.015177552875660368"}], ",", " ", 
                  "0.021783728078581376"}], "}"}]}], "}"}], ",", " ", "\n", 
              "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.014075103000262417"}], ",", " ", 
                  "0.02945296995204571"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.027191010991264468"}], ",", " ", 
                  "0.02945296995204571"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.02482575884896321"}], ",", " ", 
                  "0.03675380039988509"}], "}"}], ",", " ", "\n", 
                "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.01285075839846821"}], ",", " ", 
                  "0.03675380039988509"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.014075103000262417"}], ",", " ", 
                  "0.02945296995204571"}], "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.01285075839846821"}], ",", " ", 
                  "0.03675380039988509"}], "}"}], ",", " ", "\n", 
                "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.02482575884896321"}], ",", " ", 
                  "0.03675380039988509"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.022200371573570948"}], ",", " ", 
                  "0.04353854648936185"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.011491757943185545"}], ",", " ", 
                  "0.04353854648936185"}], "}"}], ",", " ", "\n", 
                "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.01285075839846821"}], ",", " ", 
                  "0.03675380039988509"}], "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.011491757943185545"}], ",", " ", 
                  "0.04353854648936185"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.022200371573570948"}], ",", " ", 
                  "0.04353854648936185"}], "}"}], ",", " ", "\n", 
                "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.019269248035850308"}], ",", " ", 
                  "0.04966364092329548"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.009974496752964789"}], ",", " ", 
                  "0.04966364092329548"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.011491757943185545"}], ",", " ", 
                  "0.04353854648936185"}], "}"}]}], "}"}], ",", " ", "\n", 
              "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.009974496752964796"}], ",", " ", 
                  "0.049663640923295456"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.019269248035850315"}], ",", " ", 
                  "0.049663640923295456"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.01599353425715523"}], ",", " ", 
                  "0.054993963249953474"}], "}"}], ",", " ", "\n", 
                "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.008278862528502733"}], ",", " ", 
                  "0.054993963249953474"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.009974496752964796"}], ",", " ", 
                  "0.049663640923295456"}], "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.008278862528502733"}], ",", " ", 
                  "0.054993963249953474"}], "}"}], ",", " ", "\n", 
                "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.01599353425715523"}], ",", " ", 
                  "0.054993963249953474"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.012366115704645799"}], ",", " ", 
                  "0.0594072273124165"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.006401172516607415"}], ",", " ", 
                  "0.0594072273124165"}], "}"}], ",", " ", "\n", 
                "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.008278862528502733"}], ",", " ", 
                  "0.054993963249953474"}], "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.006401172516607415"}], ",", " ", 
                  "0.0594072273124165"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.012366115704645799"}], ",", " ", 
                  "0.0594072273124165"}], "}"}], ",", " ", "\n", 
                "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.00842681754099954"}], ",", " ", 
                  "0.06279819862535355"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.004362041738429342"}], ",", " ", 
                  "0.06279819862535355"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.006401172516607415"}], ",", " ", 
                  "0.0594072273124165"}], "}"}]}], "}"}], ",", " ", "\n", 
              "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.004362041738429342"}], ",", " ", 
                  "0.06279819862535355"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.00842681754099954"}], ",", " ", 
                  "0.06279819862535355"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.004263653977837631"}], ",", " ", 
                  "0.06508252495431804"}], "}"}], ",", " ", "\n", 
                "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.002207029702382998"}], ",", " ", 
                  "0.06508252495431804"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.004362041738429342"}], ",", " ", 
                  "0.06279819862535355"}], "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.002207029702382998"}], ",", " ", 
                  "0.06508252495431804"}], "}"}], ",", " ", "\n", 
                "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.004263653977837631"}], ",", " ", 
                  "0.06508252495431804"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "1.0625181290357943*^-17", ",", " ", "0.06619997649057771"}],
                  "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "5.44811591673966*^-18", ",", " ", "0.06619997649057771"}], 
                 "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.002207029702382998"}], ",", " ", 
                  "0.06508252495431804"}], "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "6.993104012531504*^-18"}], ",", " ", 
                  RowBox[{"-", "0.05688284915968362"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "9.703609443745265*^-18"}], ",", " ", 
                  RowBox[{"-", "0.05688284915968362"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.005730643048840594"}], ",", " ", 
                  RowBox[{"-", "0.0564921568493474"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.0040521765603947334"}], ",", " ", 
                  RowBox[{"-", "0.0564921568493474"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "6.993104012531504*^-18"}], ",", " ", 
                  RowBox[{"-", "0.05688284915968362"}]}], "}"}]}], "}"}], ",",
               " ", "\n", "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.0040521765603947334"}], ",", " ", 
                  RowBox[{"-", "0.0564921568493474"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.005730643048840594"}], ",", " ", 
                  RowBox[{"-", "0.0564921568493474"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.011638500777896075"}], ",", " ", 
                  RowBox[{"-", "0.05521682457414796"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.008229662822895218"}], ",", " ", 
                  RowBox[{"-", "0.05521682457414796"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.0040521765603947334"}], ",", " ", 
                  RowBox[{"-", "0.0564921568493474"}]}], "}"}]}], "}"}], ",", 
              " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.008229662822895209"}], ",", " ", 
                  RowBox[{"-", "0.05521682457414796"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.011638500777896063"}], ",", " ", 
                  RowBox[{"-", "0.05521682457414796"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.017711990778694005"}], ",", " ", 
                  RowBox[{"-", "0.0530770008349515"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.012524268787928124"}], ",", " ", 
                  RowBox[{"-", "0.0530770008349515"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.008229662822895209"}], ",", " ", 
                  RowBox[{"-", "0.05521682457414796"}]}], "}"}]}], "}"}], ",",
               " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.012524268787928124"}], ",", " ", 
                  RowBox[{"-", "0.0530770008349515"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.017711990778694005"}], ",", " ", 
                  RowBox[{"-", "0.0530770008349515"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.023841492539681163"}], ",", " ", 
                  RowBox[{"-", "0.05009952120873742"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.016858481048417025"}], ",", " ", 
                  RowBox[{"-", "0.05009952120873742"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.012524268787928124"}], ",", " ", 
                  RowBox[{"-", "0.0530770008349515"}]}], "}"}]}], "}"}], ",", 
              " ", "\n", "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.016858481048417022"}], ",", " ", 
                  RowBox[{"-", "0.050099521208737424"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.023841492539681156"}], ",", " ", 
                  RowBox[{"-", "0.050099521208737424"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.029821787491453148"}], ",", " ", 
                  RowBox[{"-", "0.046318106341445356"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.021087188162310668"}], ",", " ", 
                  RowBox[{"-", "0.046318106341445356"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.016858481048417022"}], ",", " ", 
                  RowBox[{"-", "0.050099521208737424"}]}], "}"}]}], "}"}], 
              ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.021087188162310668"}], ",", " ", 
                  RowBox[{"-", "0.046318106341445356"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.029821787491453148"}], ",", " ", 
                  RowBox[{"-", "0.046318106341445356"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.0353800948133857"}], ",", " ", 
                  RowBox[{"-", "0.04177394503607659"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.025017504961568016"}], ",", " ", 
                  RowBox[{"-", "0.04177394503607659"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.021087188162310668"}], ",", " ", 
                  RowBox[{"-", "0.046318106341445356"}]}], "}"}]}], "}"}], 
              ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.025017504961568016"}], ",", " ", 
                  RowBox[{"-", "0.04177394503607659"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.0353800948133857"}], ",", " ", 
                  RowBox[{"-", "0.04177394503607659"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.04022285060194189"}], ",", " ", 
                  RowBox[{"-", "0.03651657383838262"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.028441850419286496"}], ",", " ", 
                  RowBox[{"-", "0.03651657383838262"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.025017504961568016"}], ",", " ", 
                  RowBox[{"-", "0.04177394503607659"}]}], "}"}]}], "}"}], ",",
               " ", "\n", "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.028441850419286492"}], ",", " ", 
                  RowBox[{"-", "0.03651657383838262"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.04022285060194188"}], ",", " ", 
                  RowBox[{"-", "0.03651657383838262"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.04408962320908927"}], ",", " ", 
                  RowBox[{"-", "0.03060493068010821"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.0311760715511068"}], ",", " ", 
                  RowBox[{"-", "0.03060493068010821"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.028441850419286492"}], ",", " ", 
                  RowBox[{"-", "0.03651657383838262"}]}], "}"}]}], "}"}], ",",
               " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.031176071551106802"}], ",", " ", 
                  RowBox[{"-", "0.0306049306801082"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.044089623209089275"}], ",", " ", 
                  RowBox[{"-", "0.0306049306801082"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.04680082652069806"}], ",", " ", 
                  RowBox[{"-", "0.024108435682384573"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.0330931817979208"}], ",", " ", 
                  RowBox[{"-", "0.024108435682384573"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.031176071551106802"}], ",", " ", 
                  RowBox[{"-", "0.0306049306801082"}]}], "}"}]}], "}"}], ",", 
              " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.0330931817979208"}], ",", " ", 
                  RowBox[{"-", "0.024108435682384573"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.04680082652069806"}], ",", " ", 
                  RowBox[{"-", "0.024108435682384573"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.04828760776055971"}], ",", " ", 
                  RowBox[{"-", "0.017107939026036665"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.0341444948947679"}], ",", " ", 
                  RowBox[{"-", "0.017107939026036665"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.0330931817979208"}], ",", " ", 
                  RowBox[{"-", "0.024108435682384573"}]}], "}"}]}], "}"}], 
              ",", " ", "\n", "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.0341444948947679"}], ",", " ", 
                  RowBox[{"-", "0.017107939026036665"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.04828760776055971"}], ",", " ", 
                  RowBox[{"-", "0.017107939026036665"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.04859696585016676"}], ",", " ", 
                  RowBox[{"-", "0.009696374951067403"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.03436324409774396"}], ",", " ", 
                  RowBox[{"-", "0.009696374951067403"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.0341444948947679"}], ",", " ", 
                  RowBox[{"-", "0.017107939026036665"}]}], "}"}]}], "}"}], 
              ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.03436324409774396"}], ",", " ", 
                  RowBox[{"-", "0.009696374951067403"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.04859696585016676"}], ",", " ", 
                  RowBox[{"-", "0.009696374951067403"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.047871548611385845"}], ",", " ", 
                  RowBox[{"-", "0.0019789726801209746"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.03385029664901237"}], ",", " ", 
                  RowBox[{"-", "0.0019789726801209746"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.03436324409774396"}], ",", " ", 
                  RowBox[{"-", "0.009696374951067403"}]}], "}"}]}], "}"}], 
              ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.03385029664901237"}], ",", " ", 
                  RowBox[{"-", "0.0019789726801209746"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.047871548611385845"}], ",", " ", 
                  RowBox[{"-", "0.0019789726801209746"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.04630999505020657"}], ",", " ", 
                  "0.005927101286260139"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.0327461115367165"}], ",", " ", 
                  "0.005927101286260139"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.03385029664901237"}], ",", " ", 
                  RowBox[{"-", "0.0019789726801209746"}]}], "}"}]}], "}"}], 
              ",", " ", "\n", "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.0327461115367165"}], ",", " ", 
                  "0.0059271012862601264"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.04630999505020657"}], ",", " ", 
                  "0.0059271012862601264"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.04411845829578879"}], ",", " ", 
                  "0.013893760977926984"}], "}"}], ",", " ", "\n", 
                "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.031196461036448124"}], ",", " ", 
                  "0.013893760977926984"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.0327461115367165"}], ",", " ", 
                  "0.0059271012862601264"}], "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.031196461036448124"}], ",", " ", 
                  "0.013893760977926984"}], "}"}], ",", " ", "\n", 
                "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.04411845829578879"}], ",", " ", 
                  "0.013893760977926984"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.04146584559086728"}], ",", " ", 
                  "0.021783728078581376"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.02932078060493654"}], ",", " ", 
                  "0.021783728078581376"}], "}"}], ",", " ", "\n", 
                "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.031196461036448124"}], ",", " ", 
                  "0.013893760977926984"}], "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.02932078060493654"}], ",", " ", 
                  "0.021783728078581376"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.04146584559086728"}], ",", " ", 
                  "0.021783728078581376"}], "}"}], ",", " ", "\n", 
                "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.0384538965184821"}], ",", " ", 
                  "0.02945296995204571"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.02719101099126445"}], ",", " ", 
                  "0.02945296995204571"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.02932078060493654"}], ",", " ", 
                  "0.021783728078581376"}], "}"}]}], "}"}], ",", " ", "\n", 
              "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.02719101099126445"}], ",", " ", 
                  "0.02945296995204571"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.0384538965184821"}], ",", " ", 
                  "0.02945296995204571"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.03510892486040765"}], ",", " ", 
                  "0.03675380039988509"}], "}"}], ",", " ", "\n", 
                "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.024825758848963195"}], ",", " ", 
                  "0.03675380039988509"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.02719101099126445"}], ",", " ", 
                  "0.02945296995204571"}], "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.024825758848963195"}], ",", " ", 
                  "0.03675380039988509"}], "}"}], ",", " ", "\n", 
                "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.03510892486040765"}], ",", " ", 
                  "0.03675380039988509"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.031396066569066156"}], ",", " ", 
                  "0.04353854648936185"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.02220037157357093"}], ",", " ", 
                  "0.04353854648936185"}], "}"}], ",", " ", "\n", 
                "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.024825758848963195"}], ",", " ", 
                  "0.03675380039988509"}], "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.02220037157357093"}], ",", " ", 
                  "0.04353854648936185"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.031396066569066156"}], ",", " ", 
                  "0.04353854648936185"}], "}"}], ",", " ", "\n", 
                "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.027250831909030625"}], ",", " ", 
                  "0.04966364092329548"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.019269248035850294"}], ",", " ", 
                  "0.04966364092329548"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.02220037157357093"}], ",", " ", 
                  "0.04353854648936185"}], "}"}]}], "}"}], ",", " ", "\n", 
              "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.019269248035850305"}], ",", " ", 
                  "0.049663640923295456"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.027250831909030642"}], ",", " ", 
                  "0.049663640923295456"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.02261827305674763"}], ",", " ", 
                  "0.054993963249953474"}], "}"}], ",", " ", "\n", 
                "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.015993534257155217"}], ",", " ", 
                  "0.054993963249953474"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.019269248035850305"}], ",", " ", 
                  "0.049663640923295456"}], "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.015993534257155217"}], ",", " ", 
                  "0.054993963249953474"}], "}"}], ",", " ", "\n", 
                "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.02261827305674763"}], ",", " ", 
                  "0.054993963249953474"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.017488328543385008"}], ",", " ", 
                  "0.0594072273124165"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.012366115704645788"}], ",", " ", 
                  "0.0594072273124165"}], "}"}], ",", " ", "\n", 
                "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.015993534257155217"}], ",", " ", 
                  "0.054993963249953474"}], "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.012366115704645788"}], ",", " ", 
                  "0.0594072273124165"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.017488328543385008"}], ",", " ", 
                  "0.0594072273124165"}], "}"}], ",", " ", "\n", 
                "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.011917319654125043"}], ",", " ", 
                  "0.06279819862535355"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.008426817540999535"}], ",", " ", 
                  "0.06279819862535355"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.012366115704645788"}], ",", " ", 
                  "0.0594072273124165"}], "}"}]}], "}"}], ",", " ", "\n", 
              "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.008426817540999535"}], ",", " ", 
                  "0.06279819862535355"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.011917319654125043"}], ",", " ", 
                  "0.06279819862535355"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.006029717280723973"}], ",", " ", 
                  "0.06508252495431804"}], "}"}], ",", " ", "\n", 
                "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.004263653977837628"}], ",", " ", 
                  "0.06508252495431804"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.008426817540999535"}], ",", " ", 
                  "0.06279819862535355"}], "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.004263653977837628"}], ",", " ", 
                  "0.06508252495431804"}], "}"}], ",", " ", "\n", 
                "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.006029717280723973"}], ",", " ", 
                  "0.06508252495431804"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "1.5612511283791264*^-17", ",", " ", "0.06619997649057771"}],
                  "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "1.111307226797642*^-17", ",", " ", "0.06619997649057771"}], 
                 "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.004263653977837628"}], ",", " ", 
                  "0.06508252495431804"}], "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "9.595189226496714*^-18"}], ",", " ", 
                  RowBox[{"-", "0.05688284915968362"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "1.1384122811097797*^-17"}], ",", " ", 
                  RowBox[{"-", "0.05688284915968362"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.007018575683843379"}], ",", " ", 
                  RowBox[{"-", "0.0564921568493474"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.005730643048840595"}], ",", " ", 
                  RowBox[{"-", "0.0564921568493474"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "9.595189226496714*^-18"}], ",", " ", 
                  RowBox[{"-", "0.05688284915968362"}]}], "}"}]}], "}"}], ",",
               " ", "\n", "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.005730643048840595"}], ",", " ", 
                  RowBox[{"-", "0.0564921568493474"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.007018575683843379"}], ",", " ", 
                  RowBox[{"-", "0.0564921568493474"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.014254194138415242"}], ",", " ", 
                  RowBox[{"-", "0.05521682457414796"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.011638500777896077"}], ",", " ", 
                  RowBox[{"-", "0.05521682457414796"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.005730643048840595"}], ",", " ", 
                  RowBox[{"-", "0.0564921568493474"}]}], "}"}]}], "}"}], ",", 
              " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.01163850077789607"}], ",", " ", 
                  RowBox[{"-", "0.05521682457414796"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.014254194138415232"}], ",", " ", 
                  RowBox[{"-", "0.05521682457414796"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.021692669868340612"}], ",", " ", 
                  RowBox[{"-", "0.0530770008349515"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.017711990778694012"}], ",", " ", 
                  RowBox[{"-", "0.0530770008349515"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.01163850077789607"}], ",", " ", 
                  RowBox[{"-", "0.05521682457414796"}]}], "}"}]}], "}"}], ",",
               " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.017711990778694012"}], ",", " ", 
                  RowBox[{"-", "0.0530770008349515"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.021692669868340612"}], ",", " ", 
                  RowBox[{"-", "0.0530770008349515"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.029199745714295358"}], ",", " ", 
                  RowBox[{"-", "0.05009952120873742"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.02384149253968117"}], ",", " ", 
                  RowBox[{"-", "0.05009952120873742"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.017711990778694012"}], ",", " ", 
                  RowBox[{"-", "0.0530770008349515"}]}], "}"}]}], "}"}], ",", 
              " ", "\n", "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.023841492539681167"}], ",", " ", 
                  RowBox[{"-", "0.050099521208737424"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.029199745714295344"}], ",", " ", 
                  RowBox[{"-", "0.050099521208737424"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.0365240812858871"}], ",", " ", 
                  RowBox[{"-", "0.046318106341445356"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.029821787491453155"}], ",", " ", 
                  RowBox[{"-", "0.046318106341445356"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.023841492539681167"}], ",", " ", 
                  RowBox[{"-", "0.050099521208737424"}]}], "}"}]}], "}"}], 
              ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.029821787491453155"}], ",", " ", 
                  RowBox[{"-", "0.046318106341445356"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.0365240812858871"}], ",", " ", 
                  RowBox[{"-", "0.046318106341445356"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.04333158967204232"}], ",", " ", 
                  RowBox[{"-", "0.04177394503607659"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.03538009481338571"}], ",", " ", 
                  RowBox[{"-", "0.04177394503607659"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.029821787491453155"}], ",", " ", 
                  RowBox[{"-", "0.046318106341445356"}]}], "}"}]}], "}"}], 
              ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.03538009481338571"}], ",", " ", 
                  RowBox[{"-", "0.04177394503607659"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.04333158967204232"}], ",", " ", 
                  RowBox[{"-", "0.04177394503607659"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.049262729987478444"}], ",", " ", 
                  RowBox[{"-", "0.03651657383838262"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.04022285060194191"}], ",", " ", 
                  RowBox[{"-", "0.03651657383838262"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.03538009481338571"}], ",", " ", 
                  RowBox[{"-", "0.04177394503607659"}]}], "}"}]}], "}"}], ",",
               " ", "\n", "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.040222850601941904"}], ",", " ", 
                  RowBox[{"-", "0.03651657383838262"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.04926272998747844"}], ",", " ", 
                  RowBox[{"-", "0.03651657383838262"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.05399853990691968"}], ",", " ", 
                  RowBox[{"-", "0.03060493068010821"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.04408962320908928"}], ",", " ", 
                  RowBox[{"-", "0.03060493068010821"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.040222850601941904"}], ",", " ", 
                  RowBox[{"-", "0.03651657383838262"}]}], "}"}]}], "}"}], ",",
               " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.04408962320908929"}], ",", " ", 
                  RowBox[{"-", "0.0306049306801082"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.0539985399069197"}], ",", " ", 
                  RowBox[{"-", "0.0306049306801082"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.05731907225811244"}], ",", " ", 
                  RowBox[{"-", "0.024108435682384573"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.04680082652069807"}], ",", " ", 
                  RowBox[{"-", "0.024108435682384573"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.04408962320908929"}], ",", " ", 
                  RowBox[{"-", "0.0306049306801082"}]}], "}"}]}], "}"}], ",", 
              " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.04680082652069807"}], ",", " ", 
                  RowBox[{"-", "0.024108435682384573"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.05731907225811244"}], ",", " ", 
                  RowBox[{"-", "0.024108435682384573"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.05913999995651422"}], ",", " ", 
                  RowBox[{"-", "0.017107939026036665"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.04828760776055972"}], ",", " ", 
                  RowBox[{"-", "0.017107939026036665"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.04680082652069807"}], ",", " ", 
                  RowBox[{"-", "0.024108435682384573"}]}], "}"}]}], "}"}], 
              ",", " ", "\n", "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.04828760776055972"}], ",", " ", 
                  RowBox[{"-", "0.017107939026036665"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.05913999995651422"}], ",", " ", 
                  RowBox[{"-", "0.017107939026036665"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.05951888469018396"}], ",", " ", 
                  RowBox[{"-", "0.009696374951067403"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.048596965850166776"}], ",", " ", 
                  RowBox[{"-", "0.009696374951067403"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.04828760776055972"}], ",", " ", 
                  RowBox[{"-", "0.017107939026036665"}]}], "}"}]}], "}"}], 
              ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.048596965850166776"}], ",", " ", 
                  RowBox[{"-", "0.009696374951067403"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.05951888469018396"}], ",", " ", 
                  RowBox[{"-", "0.009696374951067403"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.05863043364736799"}], ",", " ", 
                  RowBox[{"-", "0.0019789726801209746"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.04787154861138586"}], ",", " ", 
                  RowBox[{"-", "0.0019789726801209746"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.048596965850166776"}], ",", " ", 
                  RowBox[{"-", "0.009696374951067403"}]}], "}"}]}], "}"}], 
              ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.04787154861138586"}], ",", " ", 
                  RowBox[{"-", "0.0019789726801209746"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.05863043364736799"}], ",", " ", 
                  RowBox[{"-", "0.0019789726801209746"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.0567179289319104"}], ",", " ", 
                  "0.005927101286260139"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.04630999505020658"}], ",", " ", 
                  "0.005927101286260139"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.04787154861138586"}], ",", " ", 
                  RowBox[{"-", "0.0019789726801209746"}]}], "}"}]}], "}"}], 
              ",", " ", "\n", "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.04630999505020658"}], ",", " ", 
                  "0.0059271012862601264"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.0567179289319104"}], ",", " ", 
                  "0.0059271012862601264"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.05403385553147106"}], ",", " ", 
                  "0.013893760977926984"}], "}"}], ",", " ", "\n", 
                "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.0441184582957888"}], ",", " ", 
                  "0.013893760977926984"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.04630999505020658"}], ",", " ", 
                  "0.0059271012862601264"}], "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.0441184582957888"}], ",", " ", 
                  "0.013893760977926984"}], "}"}], ",", " ", "\n", 
                "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.05403385553147106"}], ",", " ", 
                  "0.013893760977926984"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.05078508172533026"}], ",", " ", 
                  "0.021783728078581376"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.041465845590867294"}], ",", " ", 
                  "0.021783728078581376"}], "}"}], ",", " ", "\n", 
                "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.0441184582957888"}], ",", " ", 
                  "0.013893760977926984"}], "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.041465845590867294"}], ",", " ", 
                  "0.021783728078581376"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.05078508172533026"}], ",", " ", 
                  "0.021783728078581376"}], "}"}], ",", " ", "\n", 
                "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.04709621254603387"}], ",", " ", 
                  "0.02945296995204571"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.03845389651848211"}], ",", " ", 
                  "0.02945296995204571"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.041465845590867294"}], ",", " ", 
                  "0.021783728078581376"}], "}"}]}], "}"}], ",", " ", "\n", 
              "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.03845389651848211"}], ",", " ", 
                  "0.02945296995204571"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.04709621254603387"}], ",", " ", 
                  "0.02945296995204571"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.042999475662856945"}], ",", " ", 
                  "0.03675380039988509"}], "}"}], ",", " ", "\n", 
                "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.03510892486040766"}], ",", " ", 
                  "0.03675380039988509"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.03845389651848211"}], ",", " ", 
                  "0.02945296995204571"}], "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.03510892486040766"}], ",", " ", 
                  "0.03675380039988509"}], "}"}], ",", " ", "\n", 
                "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.042999475662856945"}], ",", " ", 
                  "0.03675380039988509"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.03845217151233271"}], ",", " ", 
                  "0.04353854648936185"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.03139606656906616"}], ",", " ", 
                  "0.04353854648936185"}], "}"}], ",", " ", "\n", 
                "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.03510892486040766"}], ",", " ", 
                  "0.03675380039988509"}], "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.03139606656906616"}], ",", " ", 
                  "0.04353854648936185"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.03845217151233271"}], ",", " ", 
                  "0.04353854648936185"}], "}"}], ",", " ", "\n", 
                "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.03337531662173955"}], ",", " ", 
                  "0.04966364092329548"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.027250831909030635"}], ",", " ", 
                  "0.04966364092329548"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.03139606656906616"}], ",", " ", 
                  "0.04353854648936185"}], "}"}]}], "}"}], ",", " ", "\n", 
              "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.02725083190903065"}], ",", " ", 
                  "0.049663640923295456"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.03337531662173956"}], ",", " ", 
                  "0.049663640923295456"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.02770161392598624"}], ",", " ", 
                  "0.054993963249953474"}], "}"}], ",", " ", "\n", 
                "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.022618273056747636"}], ",", " ", 
                  "0.054993963249953474"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.02725083190903065"}], ",", " ", 
                  "0.049663640923295456"}], "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.022618273056747636"}], ",", " ", 
                  "0.054993963249953474"}], "}"}], ",", " ", "\n", 
                "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.02770161392598624"}], ",", " ", 
                  "0.054993963249953474"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.021418740692721937"}], ",", " ", 
                  "0.0594072273124165"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.01748832854338501"}], ",", " ", 
                  "0.0594072273124165"}], "}"}], ",", " ", "\n", 
                "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.022618273056747636"}], ",", " ", 
                  "0.054993963249953474"}], "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.01748832854338501"}], ",", " ", 
                  "0.0594072273124165"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.021418740692721937"}], ",", " ", 
                  "0.0594072273124165"}], "}"}], ",", " ", "\n", 
                "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.01459567612712384"}], ",", " ", 
                  "0.06279819862535355"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.011917319654125048"}], ",", " ", 
                  "0.06279819862535355"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.01748832854338501"}], ",", " ", 
                  "0.0594072273124165"}], "}"}]}], "}"}], ",", " ", "\n", 
              "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.011917319654125048"}], ",", " ", 
                  "0.06279819862535355"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.01459567612712384"}], ",", " ", 
                  "0.06279819862535355"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.007384865315507928"}], ",", " ", 
                  "0.06508252495431804"}], "}"}], ",", " ", "\n", 
                "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.006029717280723975"}], ",", " ", 
                  "0.06508252495431804"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.011917319654125048"}], ",", " ", 
                  "0.06279819862535355"}], "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.006029717280723975"}], ",", " ", 
                  "0.06508252495431804"}], "}"}], ",", " ", "\n", 
                "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.007384865315507928"}], ",", " ", 
                  "0.06508252495431804"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "1.8973538018496328*^-17", ",", " ", "0.06619997649057771"}],
                  "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "1.5233040523421337*^-17", ",", " ", "0.06619997649057771"}],
                  "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.006029717280723975"}], ",", " ", 
                  "0.06508252495431804"}], "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "1.1438332919722072*^-17"}], ",", " ", 
                  RowBox[{"-", "0.05688284915968362"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "1.22514845490862*^-17"}], ",", " ", 
                  RowBox[{"-", "0.05688284915968362"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.00782820398473696"}], ",", " ", 
                  RowBox[{"-", "0.0564921568493474"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.007018575683843376"}], ",", " ", 
                  RowBox[{"-", "0.0564921568493474"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "1.1438332919722072*^-17"}], ",", " ", 
                  RowBox[{"-", "0.05688284915968362"}]}], "}"}]}], "}"}], ",",
               " ", "\n", "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.007018575683843376"}], ",", " ", 
                  RowBox[{"-", "0.0564921568493474"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.00782820398473696"}], ",", " ", 
                  RowBox[{"-", "0.0564921568493474"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.015898487724570993"}], ",", " ", 
                  RowBox[{"-", "0.05521682457414796"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.014254194138415235"}], ",", " ", 
                  RowBox[{"-", "0.05521682457414796"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.007018575683843376"}], ",", " ", 
                  RowBox[{"-", "0.0564921568493474"}]}], "}"}]}], "}"}], ",", 
              " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.014254194138415225"}], ",", " ", 
                  RowBox[{"-", "0.05521682457414796"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.01589848772457098"}], ",", " ", 
                  RowBox[{"-", "0.05521682457414796"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.024195029355291737"}], ",", " ", 
                  RowBox[{"-", "0.0530770008349515"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.021692669868340602"}], ",", " ", 
                  RowBox[{"-", "0.0530770008349515"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.014254194138415225"}], ",", " ", 
                  RowBox[{"-", "0.05521682457414796"}]}], "}"}]}], "}"}], ",",
               " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.021692669868340602"}], ",", " ", 
                  RowBox[{"-", "0.0530770008349515"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.024195029355291737"}], ",", " ", 
                  RowBox[{"-", "0.0530770008349515"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.03256808447334166"}], ",", " ", 
                  RowBox[{"-", "0.05009952120873742"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.029199745714295344"}], ",", " ", 
                  RowBox[{"-", "0.05009952120873742"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.021692669868340602"}], ",", " ", 
                  RowBox[{"-", "0.0530770008349515"}]}], "}"}]}], "}"}], ",", 
              " ", "\n", "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.029199745714295337"}], ",", " ", 
                  RowBox[{"-", "0.050099521208737424"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.032568084473341655"}], ",", " ", 
                  RowBox[{"-", "0.050099521208737424"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.04073731929958602"}], ",", " ", 
                  RowBox[{"-", "0.046318106341445356"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.03652408128588709"}], ",", " ", 
                  RowBox[{"-", "0.046318106341445356"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.029199745714295337"}], ",", " ", 
                  RowBox[{"-", "0.050099521208737424"}]}], "}"}]}], "}"}], 
              ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.03652408128588709"}], ",", " ", 
                  RowBox[{"-", "0.046318106341445356"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.04073731929958602"}], ",", " ", 
                  RowBox[{"-", "0.046318106341445356"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.04833010830338694"}], ",", " ", 
                  RowBox[{"-", "0.04177394503607659"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.04333158967204231"}], ",", " ", 
                  RowBox[{"-", "0.04177394503607659"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.03652408128588709"}], ",", " ", 
                  RowBox[{"-", "0.046318106341445356"}]}], "}"}]}], "}"}], 
              ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.04333158967204231"}], ",", " ", 
                  RowBox[{"-", "0.04177394503607659"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.04833010830338694"}], ",", " ", 
                  RowBox[{"-", "0.04177394503607659"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.05494543573487883"}], ",", " ", 
                  RowBox[{"-", "0.03651657383838262"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.04926272998747843"}], ",", " ", 
                  RowBox[{"-", "0.03651657383838262"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.04333158967204231"}], ",", " ", 
                  RowBox[{"-", "0.04177394503607659"}]}], "}"}]}], "}"}], ",",
               " ", "\n", "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.049262729987478424"}], ",", " ", 
                  RowBox[{"-", "0.03651657383838262"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.054945435734878825"}], ",", " ", 
                  RowBox[{"-", "0.03651657383838262"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.06022754534689994"}], ",", " ", 
                  RowBox[{"-", "0.03060493068010821"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.05399853990691967"}], ",", " ", 
                  RowBox[{"-", "0.03060493068010821"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.049262729987478424"}], ",", " ", 
                  RowBox[{"-", "0.03651657383838262"}]}], "}"}]}], "}"}], ",",
               " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.053998539906919676"}], ",", " ", 
                  RowBox[{"-", "0.0306049306801082"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.06022754534689994"}], ",", " ", 
                  RowBox[{"-", "0.0306049306801082"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.06393111794538205"}], ",", " ", 
                  RowBox[{"-", "0.024108435682384573"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.05731907225811242"}], ",", " ", 
                  RowBox[{"-", "0.024108435682384573"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.053998539906919676"}], ",", " ", 
                  RowBox[{"-", "0.0306049306801082"}]}], "}"}]}], "}"}], ",", 
              " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.05731907225811242"}], ",", " ", 
                  RowBox[{"-", "0.024108435682384573"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.06393111794538205"}], ",", " ", 
                  RowBox[{"-", "0.024108435682384573"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.06596209888890318"}], ",", " ", 
                  RowBox[{"-", "0.017107939026036665"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.0591399999565142"}], ",", " ", 
                  RowBox[{"-", "0.017107939026036665"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.05731907225811242"}], ",", " ", 
                  RowBox[{"-", "0.024108435682384573"}]}], "}"}]}], "}"}], 
              ",", " ", "\n", "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.0591399999565142"}], ",", " ", 
                  RowBox[{"-", "0.017107939026036665"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.06596209888890318"}], ",", " ", 
                  RowBox[{"-", "0.017107939026036665"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.06638468989817264"}], ",", " ", 
                  RowBox[{"-", "0.009696374951067403"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.05951888469018394"}], ",", " ", 
                  RowBox[{"-", "0.009696374951067403"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.0591399999565142"}], ",", " ", 
                  RowBox[{"-", "0.017107939026036665"}]}], "}"}]}], "}"}], 
              ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.05951888469018394"}], ",", " ", 
                  RowBox[{"-", "0.009696374951067403"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.06638468989817264"}], ",", " ", 
                  RowBox[{"-", "0.009696374951067403"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.06539375152165473"}], ",", " ", 
                  RowBox[{"-", "0.0019789726801209746"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.05863043364736797"}], ",", " ", 
                  RowBox[{"-", "0.0019789726801209746"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.05951888469018394"}], ",", " ", 
                  RowBox[{"-", "0.009696374951067403"}]}], "}"}]}], "}"}], 
              ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.05863043364736797"}], ",", " ", 
                  RowBox[{"-", "0.0019789726801209746"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.06539375152165473"}], ",", " ", 
                  RowBox[{"-", "0.0019789726801209746"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.0632606296877138"}], ",", " ", 
                  "0.005927101286260139"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.056717928931910376"}], ",", " ", 
                  "0.005927101286260139"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.05863043364736797"}], ",", " ", 
                  RowBox[{"-", "0.0019789726801209746"}]}], "}"}]}], "}"}], 
              ",", " ", "\n", "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.056717928931910376"}], ",", " ", 
                  "0.0059271012862601264"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.06326062968771382"}], ",", " ", 
                  "0.0059271012862601264"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.06026693480785181"}], ",", " ", 
                  "0.013893760977926984"}], "}"}], ",", " ", "\n", 
                "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.05403385553147103"}], ",", " ", 
                  "0.013893760977926984"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.056717928931910376"}], ",", " ", 
                  "0.0059271012862601264"}], "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.05403385553147103"}], ",", " ", 
                  "0.013893760977926984"}], "}"}], ",", " ", "\n", 
                "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.06026693480785181"}], ",", " ", 
                  "0.013893760977926984"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.05664339846652768"}], ",", " ", 
                  "0.021783728078581376"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.05078508172533024"}], ",", " ", 
                  "0.021783728078581376"}], "}"}], ",", " ", "\n", 
                "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.05403385553147103"}], ",", " ", 
                  "0.013893760977926984"}], "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.05078508172533024"}], ",", " ", 
                  "0.021783728078581376"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.05664339846652768"}], ",", " ", 
                  "0.021783728078581376"}], "}"}], ",", " ", "\n", 
                "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.05252899951874454"}], ",", " ", 
                  "0.02945296995204571"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.04709621254603385"}], ",", " ", 
                  "0.02945296995204571"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.05078508172533024"}], ",", " ", 
                  "0.021783728078581376"}], "}"}]}], "}"}], ",", " ", "\n", 
              "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.04709621254603385"}], ",", " ", 
                  "0.02945296995204571"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.05252899951874454"}], ",", " ", 
                  "0.02945296995204571"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.04795968325887588"}], ",", " ", 
                  "0.03675380039988509"}], "}"}], ",", " ", "\n", 
                "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.04299947566285693"}], ",", " ", 
                  "0.03675380039988509"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.04709621254603385"}], ",", " ", 
                  "0.02945296995204571"}], "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.04299947566285693"}], ",", " ", 
                  "0.03675380039988509"}], "}"}], ",", " ", "\n", 
                "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.04795968325887588"}], ",", " ", 
                  "0.03675380039988509"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.04288782451225172"}], ",", " ", 
                  "0.04353854648936185"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.0384521715123327"}], ",", " ", 
                  "0.04353854648936185"}], "}"}], ",", " ", "\n", 
                "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.04299947566285693"}], ",", " ", 
                  "0.03675380039988509"}], "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.0384521715123327"}], ",", " ", 
                  "0.04353854648936185"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.04288782451225172"}], ",", " ", 
                  "0.04353854648936185"}], "}"}], ",", " ", "\n", 
                "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.03722532866199545"}], ",", " ", 
                  "0.04966364092329548"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.03337531662173954"}], ",", " ", 
                  "0.04966364092329548"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.0384521715123327"}], ",", " ", 
                  "0.04353854648936185"}], "}"}]}], "}"}], ",", " ", "\n", 
              "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.03337531662173955"}], ",", " ", 
                  "0.049663640923295456"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.037225328661995453"}], ",", " ", 
                  "0.049663640923295456"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.030897135585250375"}], ",", " ", 
                  "0.054993963249953474"}], "}"}], ",", " ", "\n", 
                "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.02770161392598622"}], ",", " ", 
                  "0.054993963249953474"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.03337531662173955"}], ",", " ", 
                  "0.049663640923295456"}], "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.02770161392598622"}], ",", " ", 
                  "0.054993963249953474"}], "}"}], ",", " ", "\n", 
                "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.030897135585250375"}], ",", " ", 
                  "0.054993963249953474"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.023889501059992435"}], ",", " ", 
                  "0.0594072273124165"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.02141874069272193"}], ",", " ", 
                  "0.0594072273124165"}], "}"}], ",", " ", "\n", 
                "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.02770161392598622"}], ",", " ", 
                  "0.054993963249953474"}], "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.02141874069272193"}], ",", " ", 
                  "0.0594072273124165"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.023889501059992435"}], ",", " ", 
                  "0.0594072273124165"}], "}"}], ",", " ", "\n", 
                "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.01627936139255439"}], ",", " ", 
                  "0.06279819862535355"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.014595676127123836"}], ",", " ", 
                  "0.06279819862535355"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.02141874069272193"}], ",", " ", 
                  "0.0594072273124165"}], "}"}]}], "}"}], ",", " ", "\n", 
              "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.014595676127123836"}], ",", " ", 
                  "0.06279819862535355"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.01627936139255439"}], ",", " ", 
                  "0.06279819862535355"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.008236746983106976"}], ",", " ", 
                  "0.06508252495431804"}], "}"}], ",", " ", "\n", 
                "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.007384865315507925"}], ",", " ", 
                  "0.06508252495431804"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.014595676127123836"}], ",", " ", 
                  "0.06279819862535355"}], "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.007384865315507925"}], ",", " ", 
                  "0.06508252495431804"}], "}"}], ",", " ", "\n", 
                "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.008236746983106976"}], ",", " ", 
                  "0.06508252495431804"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "2.1141942363467336*^-17", ",", " ", "0.06619997649057771"}],
                  "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "1.9081958235744878*^-17", ",", " ", "0.06619997649057771"}],
                  "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.007384865315507925"}], ",", " ", 
                  "0.06508252495431804"}], "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "1.22514845490862*^-17"}], ",", " ", 
                  RowBox[{"-", "0.05688284915968362"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "1.4203048459560108*^-17"}], ",", " ", 
                  RowBox[{"-", "0.05688284915968362"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.008104353120789472"}], ",", " ", 
                  RowBox[{"-", "0.0564921568493474"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.007828203984736957"}], ",", " ", 
                  RowBox[{"-", "0.0564921568493474"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "1.22514845490862*^-17"}], ",", " ", 
                  RowBox[{"-", "0.05688284915968362"}]}], "}"}]}], "}"}], ",",
               " ", "\n", "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.007828203984736957"}], ",", " ", 
                  RowBox[{"-", "0.0564921568493474"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.008104353120789472"}], ",", " ", 
                  RowBox[{"-", "0.0564921568493474"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.016459325645790453"}], ",", " ", 
                  RowBox[{"-", "0.05521682457414796"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.015898487724570993"}], ",", " ", 
                  RowBox[{"-", "0.05521682457414796"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.007828203984736957"}], ",", " ", 
                  RowBox[{"-", "0.0564921568493474"}]}], "}"}]}], "}"}], ",", 
              " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.01589848772457098"}], ",", " ", 
                  RowBox[{"-", "0.05521682457414796"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.01645932564579044"}], ",", " ", 
                  RowBox[{"-", "0.05521682457414796"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.02504853757585627"}], ",", " ", 
                  RowBox[{"-", "0.0530770008349515"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.02419502935529174"}], ",", " ", 
                  RowBox[{"-", "0.0530770008349515"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.01589848772457098"}], ",", " ", 
                  RowBox[{"-", "0.05521682457414796"}]}], "}"}]}], "}"}], ",",
               " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.02419502935529174"}], ",", " ", 
                  RowBox[{"-", "0.0530770008349515"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.02504853757585627"}], ",", " ", 
                  RowBox[{"-", "0.0530770008349515"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.03371696209683408"}], ",", " ", 
                  RowBox[{"-", "0.05009952120873742"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.03256808447334166"}], ",", " ", 
                  RowBox[{"-", "0.05009952120873742"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.02419502935529174"}], ",", " ", 
                  RowBox[{"-", "0.0530770008349515"}]}], "}"}]}], "}"}], ",", 
              " ", "\n", "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.032568084473341655"}], ",", " ", 
                  RowBox[{"-", "0.050099521208737424"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.03371696209683407"}], ",", " ", 
                  RowBox[{"-", "0.050099521208737424"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.04217437632462138"}], ",", " ", 
                  RowBox[{"-", "0.046318106341445356"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.04073731929958602"}], ",", " ", 
                  RowBox[{"-", "0.046318106341445356"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.032568084473341655"}], ",", " ", 
                  RowBox[{"-", "0.050099521208737424"}]}], "}"}]}], "}"}], 
              ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.04073731929958602"}], ",", " ", 
                  RowBox[{"-", "0.046318106341445356"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.04217437632462138"}], ",", " ", 
                  RowBox[{"-", "0.046318106341445356"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.05003500992313608"}], ",", " ", 
                  RowBox[{"-", "0.04177394503607659"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.04833010830338694"}], ",", " ", 
                  RowBox[{"-", "0.04177394503607659"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.04073731929958602"}], ",", " ", 
                  RowBox[{"-", "0.046318106341445356"}]}], "}"}]}], "}"}], 
              ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.04833010830338694"}], ",", " ", 
                  RowBox[{"-", "0.04177394503607659"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.05003500992313608"}], ",", " ", 
                  RowBox[{"-", "0.04177394503607659"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.05688370083857305"}], ",", " ", 
                  RowBox[{"-", "0.03651657383838262"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.05494543573487883"}], ",", " ", 
                  RowBox[{"-", "0.03651657383838262"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.04833010830338694"}], ",", " ", 
                  RowBox[{"-", "0.04177394503607659"}]}], "}"}]}], "}"}], ",",
               " ", "\n", "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.054945435734878825"}], ",", " ", 
                  RowBox[{"-", "0.03651657383838262"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.05688370083857304"}], ",", " ", 
                  RowBox[{"-", "0.03651657383838262"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.06235214310221366"}], ",", " ", 
                  RowBox[{"-", "0.03060493068010821"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.06022754534689994"}], ",", " ", 
                  RowBox[{"-", "0.03060493068010821"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.054945435734878825"}], ",", " ", 
                  RowBox[{"-", "0.03651657383838262"}]}], "}"}]}], "}"}], ",",
               " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.06022754534689994"}], ",", " ", 
                  RowBox[{"-", "0.0306049306801082"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.06235214310221367"}], ",", " ", 
                  RowBox[{"-", "0.0306049306801082"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.06618636359584165"}], ",", " ", 
                  RowBox[{"-", "0.024108435682384573"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.06393111794538205"}], ",", " ", 
                  RowBox[{"-", "0.024108435682384573"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.06022754534689994"}], ",", " ", 
                  RowBox[{"-", "0.0306049306801082"}]}], "}"}]}], "}"}], ",", 
              " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.06393111794538205"}], ",", " ", 
                  RowBox[{"-", "0.024108435682384573"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.06618636359584165"}], ",", " ", 
                  RowBox[{"-", "0.024108435682384573"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.06828898978953588"}], ",", " ", 
                  RowBox[{"-", "0.017107939026036665"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.06596209888890317"}], ",", " ", 
                  RowBox[{"-", "0.017107939026036665"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.06393111794538205"}], ",", " ", 
                  RowBox[{"-", "0.024108435682384573"}]}], "}"}]}], "}"}], 
              ",", " ", "\n", "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.06596209888890317"}], ",", " ", 
                  RowBox[{"-", "0.017107939026036665"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.06828898978953588"}], ",", " ", 
                  RowBox[{"-", "0.017107939026036665"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.06872648819548799"}], ",", " ", 
                  RowBox[{"-", "0.009696374951067403"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.06638468989817264"}], ",", " ", 
                  RowBox[{"-", "0.009696374951067403"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.06596209888890317"}], ",", " ", 
                  RowBox[{"-", "0.017107939026036665"}]}], "}"}]}], "}"}], 
              ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.06638468989817264"}], ",", " ", 
                  RowBox[{"-", "0.009696374951067403"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.06872648819548799"}], ",", " ", 
                  RowBox[{"-", "0.009696374951067403"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.0677005932980248"}], ",", " ", 
                  RowBox[{"-", "0.0019789726801209746"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.06539375152165473"}], ",", " ", 
                  RowBox[{"-", "0.0019789726801209746"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.06638468989817264"}], ",", " ", 
                  RowBox[{"-", "0.009696374951067403"}]}], "}"}]}], "}"}], 
              ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.06539375152165473"}], ",", " ", 
                  RowBox[{"-", "0.0019789726801209746"}]}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.0677005932980248"}], ",", " ", 
                  RowBox[{"-", "0.0019789726801209746"}]}], "}"}], ",", " ", 
                "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.06549222307343307"}], ",", " ", 
                  "0.005927101286260139"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.0632606296877138"}], ",", " ", 
                  "0.005927101286260139"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.06539375152165473"}], ",", " ", 
                  RowBox[{"-", "0.0019789726801209746"}]}], "}"}]}], "}"}], 
              ",", " ", "\n", "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.06326062968771382"}], ",", " ", 
                  "0.0059271012862601264"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.06549222307343307"}], ",", " ", 
                  "0.0059271012862601264"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.062392922072896304"}], ",", " ", 
                  "0.013893760977926984"}], "}"}], ",", " ", "\n", 
                "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.06026693480785181"}], ",", " ", 
                  "0.013893760977926984"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.06326062968771382"}], ",", " ", 
                  "0.0059271012862601264"}], "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.06026693480785181"}], ",", " ", 
                  "0.013893760977926984"}], "}"}], ",", " ", "\n", 
                "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.062392922072896304"}], ",", " ", 
                  "0.013893760977926984"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.05864156120987315"}], ",", " ", 
                  "0.021783728078581376"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.05664339846652768"}], ",", " ", 
                  "0.021783728078581376"}], "}"}], ",", " ", "\n", 
                "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.06026693480785181"}], ",", " ", 
                  "0.013893760977926984"}], "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.05664339846652768"}], ",", " ", 
                  "0.021783728078581376"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.05864156120987315"}], ",", " ", 
                  "0.021783728078581376"}], "}"}], ",", " ", "\n", 
                "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.05438202198252895"}], ",", " ", 
                  "0.02945296995204571"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.05252899951874454"}], ",", " ", 
                  "0.02945296995204571"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.05664339846652768"}], ",", " ", 
                  "0.021783728078581376"}], "}"}]}], "}"}], ",", " ", "\n", 
              "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.05252899951874454"}], ",", " ", 
                  "0.02945296995204571"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.05438202198252895"}], ",", " ", 
                  "0.02945296995204571"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.04965151769792643"}], ",", " ", 
                  "0.03675380039988509"}], "}"}], ",", " ", "\n", 
                "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.04795968325887588"}], ",", " ", 
                  "0.03675380039988509"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.05252899951874454"}], ",", " ", 
                  "0.02945296995204571"}], "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.04795968325887588"}], ",", " ", 
                  "0.03675380039988509"}], "}"}], ",", " ", "\n", 
                "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.04965151769792643"}], ",", " ", 
                  "0.03675380039988509"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.04440074314714191"}], ",", " ", 
                  "0.04353854648936185"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.04288782451225172"}], ",", " ", 
                  "0.04353854648936185"}], "}"}], ",", " ", "\n", 
                "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.04795968325887588"}], ",", " ", 
                  "0.03675380039988509"}], "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.04288782451225172"}], ",", " ", 
                  "0.04353854648936185"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.04440074314714191"}], ",", " ", 
                  "0.04353854648936185"}], "}"}], ",", " ", "\n", 
                "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.03853849607170062"}], ",", " ", 
                  "0.04966364092329548"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.03722532866199545"}], ",", " ", 
                  "0.04966364092329548"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.04288782451225172"}], ",", " ", 
                  "0.04353854648936185"}], "}"}]}], "}"}], ",", " ", "\n", 
              "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.037225328661995453"}], ",", " ", 
                  "0.049663640923295456"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.03853849607170066"}], ",", " ", 
                  "0.049663640923295456"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.03198706851431048"}], ",", " ", 
                  "0.054993963249953474"}], "}"}], ",", " ", "\n", 
                "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.03089713558525038"}], ",", " ", 
                  "0.054993963249953474"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.037225328661995453"}], ",", " ", 
                  "0.049663640923295456"}], "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.03089713558525038"}], ",", " ", 
                  "0.054993963249953474"}], "}"}], ",", " ", "\n", 
                "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.03198706851431048"}], ",", " ", 
                  "0.054993963249953474"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.0247322314092916"}], ",", " ", 
                  "0.0594072273124165"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.023889501059992435"}], ",", " ", 
                  "0.0594072273124165"}], "}"}], ",", " ", "\n", 
                "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.03089713558525038"}], ",", " ", 
                  "0.054993963249953474"}], "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.023889501059992435"}], ",", " ", 
                  "0.0594072273124165"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.0247322314092916"}], ",", " ", 
                  "0.0594072273124165"}], "}"}], ",", " ", "\n", 
                "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.016853635081999087"}], ",", " ", 
                  "0.06279819862535355"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.016279361392554394"}], ",", " ", 
                  "0.06279819862535355"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.023889501059992435"}], ",", " ", 
                  "0.0594072273124165"}], "}"}]}], "}"}], ",", " ", "\n", 
              "          ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.016279361392554394"}], ",", " ", 
                  "0.06279819862535355"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.016853635081999087"}], ",", " ", 
                  "0.06279819862535355"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.008527307955675266"}], ",", " ", 
                  "0.06508252495431804"}], "}"}], ",", " ", "\n", 
                "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.008236746983106976"}], ",", " ", 
                  "0.06508252495431804"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.016279361392554394"}], ",", " ", 
                  "0.06279819862535355"}], "}"}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.008236746983106976"}], ",", " ", 
                  "0.06508252495431804"}], "}"}], ",", " ", "\n", 
                "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.008527307955675266"}], ",", " ", 
                  "0.06508252495431804"}], "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "2.200930410145574*^-17", ",", " ", "0.06619997649057771"}], 
                 "}"}], ",", " ", 
                RowBox[{"{", 
                 RowBox[{
                 "2.1141942363467336*^-17", ",", " ", "0.06619997649057771"}],
                  "}"}], ",", " ", "\n", "           ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "0.008236746983106976"}], ",", " ", 
                  "0.06508252495431804"}], "}"}]}], "}"}]}], "}"}], "]"}]}], 
          "}"}], ",", " ", 
         RowBox[{"Opacity", "[", "1", "]"}], ",", " ", "\n", "       ", 
         RowBox[{"Dynamic", "[", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"RGBColor", "[", 
              RowBox[{
               RowBox[{"Abs", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"-", "0.3183098861837907"}], "*", 
                  RowBox[{"ArcTan", "[", 
                   RowBox[{"63.75", " ", "-", " ", 
                    RowBox[{"0.25", "*", 
                    RowBox[{"Abs", "[", 
                    RowBox[{
                    RowBox[{"-", "500."}], " ", "+", " ", 
                    RowBox[{"2.", "*", 
                    RowBox[{"Mod", "[", 
                    RowBox[{
                    RowBox[{"100.", " ", "+", " ", 
                    RowBox[{"500.", "*", "#1"}]}], ",", " ", "500."}], 
                    "]"}]}]}], "]"}]}]}], "]"}]}], " ", "+", " ", 
                 RowBox[{"0.3183098861837907", "*", "\n", "              ", 
                  RowBox[{"ArcTan", "[", 
                   RowBox[{"43.", " ", "-", " ", 
                    RowBox[{"0.1", "*", 
                    RowBox[{"Abs", "[", 
                    RowBox[{
                    RowBox[{"-", "500."}], " ", "+", " ", 
                    RowBox[{"2.", "*", 
                    RowBox[{"Mod", "[", 
                    RowBox[{
                    RowBox[{"100.", " ", "+", " ", 
                    RowBox[{"500.", "*", "#1"}]}], ",", " ", "500."}], 
                    "]"}]}]}], "]"}]}]}], "]"}]}]}], "]"}], ",", " ", 
               RowBox[{"Abs", "[", 
                RowBox[{
                 RowBox[{"0.3183098861837907", "*", 
                  RowBox[{"ArcTan", "[", 
                   RowBox[{"60.", " ", "-", " ", 
                    RowBox[{"0.2", "*", 
                    RowBox[{"Abs", "[", 
                    RowBox[{
                    RowBox[{"-", "500."}], " ", "+", " ", 
                    RowBox[{"2.", "*", 
                    RowBox[{"Mod", "[", 
                    RowBox[{
                    RowBox[{"100.", " ", "+", " ", 
                    RowBox[{"500.", "*", "#1"}]}], ",", " ", "500."}], 
                    "]"}]}]}], "]"}]}]}], "]"}]}], " ", "-", " ", "\n", 
                 "             ", 
                 RowBox[{"0.3183098861837907", "*", 
                  RowBox[{"ArcTan", "[", 
                   RowBox[{"18.", " ", "-", " ", 
                    RowBox[{"0.1", "*", 
                    RowBox[{"Abs", "[", 
                    RowBox[{
                    RowBox[{"-", "500."}], " ", "+", " ", 
                    RowBox[{"2.", "*", 
                    RowBox[{"Mod", "[", 
                    RowBox[{
                    RowBox[{"100.", " ", "+", " ", 
                    RowBox[{"500.", "*", "#1"}]}], ",", " ", "500."}], 
                    "]"}]}]}], "]"}]}]}], "]"}]}]}], "]"}], ",", " ", 
               RowBox[{"Abs", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"-", "0.3183098861837907"}], "*", 
                  RowBox[{"ArcTan", "[", 
                   RowBox[{"10.", " ", "-", " ", 
                    RowBox[{"0.2", "*", 
                    RowBox[{"Abs", "[", 
                    RowBox[{
                    RowBox[{"-", "500."}], " ", "+", " ", 
                    RowBox[{"2.", "*", 
                    RowBox[{"Mod", "[", 
                    RowBox[{
                    RowBox[{"100.", " ", "+", " ", 
                    RowBox[{"500.", "*", "#1"}]}], ",", " ", "500."}], 
                    "]"}]}]}], "]"}]}]}], "]"}]}], " ", "+", " ", "\n", 
                 "             ", 
                 RowBox[{"0.3183098861837907", "*", 
                  RowBox[{"ArcTan", "[", 
                   RowBox[{"22.5", " ", "-", " ", 
                    RowBox[{"0.125", "*", 
                    RowBox[{"Abs", "[", 
                    RowBox[{
                    RowBox[{"-", "500."}], " ", "+", " ", 
                    RowBox[{"2.", "*", 
                    RowBox[{"Mod", "[", 
                    RowBox[{
                    RowBox[{"100.", " ", "+", " ", 
                    RowBox[{"500.", "*", "#1"}]}], ",", " ", "500."}], 
                    "]"}]}]}], "]"}]}]}], "]"}]}]}], "]"}]}], "]"}], " ", 
             "&"}], " ", ")"}], "[", "\[Lambda]", "]"}], "]"}], ",", " ", 
         RowBox[{"AbsoluteThickness", "[", "Medium", "]"}], ",", " ", "\n", 
         "       ", 
         RowBox[{"Line", "[", 
          RowBox[{"Dynamic", "[", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{
                RowBox[{"#1", "[", 
                 RowBox[{"[", 
                  RowBox[{"{", 
                   RowBox[{"1", ",", " ", "2"}], "}"}], "]"}], "]"}], ",", 
                " ", 
                RowBox[{"#1", "[", 
                 RowBox[{"[", 
                  RowBox[{"{", 
                   RowBox[{"4", ",", " ", "5"}], "}"}], "]"}], "]"}]}], "}"}],
               " ", "&"}], " ", ")"}], " ", "/@", " ", 
            RowBox[{"Select", "[", 
             RowBox[{
              RowBox[{"raytracefunction13020200710911545612259", "[", 
               RowBox[{
               "x", ",", " ", "y", ",", " ", "\[Theta]", ",", " ", 
                "\[Lambda]"}], "]"}], ",", " ", 
              RowBox[{
               RowBox[{
                RowBox[{"#1", "[", 
                 RowBox[{"[", "1", "]"}], "]"}], " ", ">", " ", 
                RowBox[{"-", "9.87654321*^8"}]}], " ", "&"}]}], " ", "]"}]}], 
           "]"}], "]"}], ",", " ", 
         RowBox[{"Arrowheads", "[", "Large", "]"}], ",", " ", "\n", "       ", 
         RowBox[{"Thickness", "[", "Large", "]"}], ",", " ", 
         RowBox[{"Dashing", "[", 
          RowBox[{"{", 
           RowBox[{"Small", ",", " ", "Small"}], "}"}], "]"}], ",", " ", 
         RowBox[{"RGBColor", "[", 
          RowBox[{"1", ",", " ", "1", ",", " ", "0"}], "]"}], ",", " ", "\n", 
         "       ", 
         RowBox[{"Arrow", "[", 
          RowBox[{"Dynamic", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{
                RowBox[{"laststartpos\[Theta]", " ", "!=", " ", 
                 RowBox[{"{", 
                  RowBox[{"x", ",", " ", "y"}], "}"}]}], " ", "||", " ", 
                RowBox[{"last\[Theta]", " ", "=!=", " ", "\[Theta]"}]}], ",", 
               " ", 
               RowBox[{
                RowBox[{"laststartpos\[Theta]", " ", "=", " ", 
                 RowBox[{"{", 
                  RowBox[{"x", ",", " ", "y"}], "}"}]}], ";", " ", 
                RowBox[{"last\[Theta]", " ", "=", " ", "\[Theta]"}], ";", " ",
                 "\n", "            ", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{"x\[Theta]", ",", " ", "y\[Theta]"}], "}"}], " ", 
                 "=", " ", 
                 RowBox[{"laststartpos\[Theta]", " ", "+", " ", 
                  RowBox[{"radius\[Theta]", "*", 
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"\[Theta]", "*", "Degree"}], "]"}], ",", " ", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"\[Theta]", "*", "Degree"}], "]"}]}], 
                    "}"}]}]}]}]}]}], "]"}], ";", " ", 
             RowBox[{"{", 
              RowBox[{"laststartpos\[Theta]", ",", " ", 
               RowBox[{"{", 
                RowBox[{"x\[Theta]", ",", " ", "y\[Theta]"}], "}"}]}], 
              "}"}]}], ",", " ", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"laststartpos\[Theta]", ",", " ", 
                 RowBox[{"{", 
                  RowBox[{"x\[Theta]", ",", " ", "y\[Theta]"}], "}"}]}], 
                "}"}], " ", "=", " ", "#1"}], ")"}], " ", "&"}]}], " ", "]"}],
           "]"}], ",", " ", "\n", "       ", 
         RowBox[{"Tooltip", "[", 
          RowBox[{
           RowBox[{"Locator", "[", 
            RowBox[{
             RowBox[{"Dynamic", "[", 
              RowBox[{
               RowBox[{
                RowBox[{"If", "[", 
                 RowBox[{
                  RowBox[{
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{"x\[Theta]", ",", " ", "y\[Theta]"}], "}"}], " ", 
                    "!=", " ", "lastlocpos\[Theta]"}], " ", "||", " ", 
                   RowBox[{"last\[Theta]", " ", "!=", " ", "\[Theta]"}]}], 
                  ",", " ", 
                  RowBox[{
                   RowBox[{"lastlocpos\[Theta]", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"x\[Theta]", ",", " ", "y\[Theta]"}], "}"}]}], 
                   ";", " ", 
                   RowBox[{"last\[Theta]", " ", "=", " ", "\[Theta]"}], ";", 
                   " ", "\n", "             ", 
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{"x\[Theta]", ",", " ", "y\[Theta]"}], "}"}], " ", 
                    "=", " ", 
                    RowBox[{"laststartpos\[Theta]", " ", "+", " ", 
                    RowBox[{"radius\[Theta]", "*", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"\[Theta]", "*", "Degree"}], "]"}], ",", " ", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"\[Theta]", "*", "Degree"}], "]"}]}], 
                    "}"}]}]}]}]}]}], "]"}], ";", " ", 
                RowBox[{"{", 
                 RowBox[{"x\[Theta]", ",", " ", "y\[Theta]"}], "}"}]}], ",", 
               " ", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"{", 
                    RowBox[{"x\[Theta]", ",", " ", "y\[Theta]"}], "}"}], " ", 
                   "=", " ", "#1"}], ";", " ", 
                  RowBox[{"xoff\[Theta]", " ", "=", " ", 
                   RowBox[{"x\[Theta]", " ", "-", " ", "x"}]}], ";", " ", 
                  RowBox[{"yoff\[Theta]", " ", "=", " ", 
                   RowBox[{"y\[Theta]", " ", "-", " ", "y"}]}], ";", " ", 
                  "\n", "            ", 
                  RowBox[{"radius\[Theta]", " ", "=", " ", 
                   RowBox[{"Sqrt", "[", 
                    RowBox[{
                    RowBox[{"xoff\[Theta]", "^", "2"}], " ", "+", " ", 
                    RowBox[{"yoff\[Theta]", "^", "2"}]}], "]"}]}], ";", " ", 
                  RowBox[{"\[Theta]", " ", "=", " ", 
                   RowBox[{"Chop", "[", 
                    RowBox[{
                    RowBox[{"ArcTan", "[", 
                    RowBox[{"xoff\[Theta]", ",", " ", "yoff\[Theta]"}], "]"}],
                     "/", "Degree"}], "]"}]}], ";", " ", 
                  RowBox[{"{", 
                   RowBox[{"x\[Theta]", ",", " ", "y\[Theta]"}], "}"}]}], 
                 ")"}], " ", "&"}]}], " ", "]"}], ",", " ", 
             RowBox[{"Graphics", "[", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"RGBColor", "[", 
                  RowBox[{
                   RowBox[{"1", "/", "3"}], ",", " ", 
                   RowBox[{"1", "/", "3"}], ",", " ", "1"}], "]"}], ",", " ", 
                 
                 RowBox[{"Disk", "[", 
                  RowBox[{
                   RowBox[{"{", 
                    RowBox[{"0", ",", " ", "0"}], "}"}], ",", " ", "0.5"}], 
                  "]"}]}], "}"}], ",", " ", "\n", "          ", 
               RowBox[{"ImageSize", " ", "\[Rule]", " ", "10"}]}], "]"}]}], 
            "]"}], ",", " ", 
           RowBox[{"Dynamic", "[", 
            RowBox[{"StringJoin", "[", 
             RowBox[{"\"\<\[Theta] = \>\"", ",", " ", 
              RowBox[{"ToString", "[", "\[Theta]", "]"}]}], "]"}], "]"}]}], 
          "]"}], ",", " ", 
         RowBox[{"Tooltip", "[", 
          RowBox[{
           RowBox[{"Locator", "[", 
            RowBox[{
             RowBox[{"Dynamic", "[", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"x", ",", " ", "y"}], "}"}], ",", " ", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{"x", ",", " ", "y"}], "}"}], " ", "=", " ", 
                  RowBox[{"Chop", "[", "#1", "]"}]}], ")"}], " ", "&"}]}], 
              " ", "]"}], ",", " ", "\n", "         ", 
             RowBox[{"Graphics", "[", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"RGBColor", "[", 
                  RowBox[{"1", ",", " ", 
                   RowBox[{"1", "/", "3"}], ",", " ", 
                   RowBox[{"1", "/", "3"}]}], "]"}], ",", " ", 
                 RowBox[{"Disk", "[", 
                  RowBox[{
                   RowBox[{"{", 
                    RowBox[{"0", ",", " ", "0"}], "}"}], ",", " ", "0.8"}], 
                  "]"}]}], "}"}], ",", " ", 
               RowBox[{"ImageSize", " ", "\[Rule]", " ", "10"}]}], "]"}]}], 
            "]"}], ",", " ", 
           RowBox[{"Dynamic", "[", 
            RowBox[{"StringJoin", "[", 
             RowBox[{"\"\<{x, y} = \>\"", ",", " ", 
              RowBox[{"ToString", "[", 
               RowBox[{"Chop", "[", 
                RowBox[{"{", 
                 RowBox[{"x", ",", " ", "y"}], "}"}], "]"}], "]"}]}], "]"}], 
            "]"}]}], "]"}]}], "}"}], "}"}], "]"}], ",", " ", "\n", "    ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"ImageSize", " ", "\[Rule]", " ", 
        RowBox[{"{", 
         RowBox[{"420", ",", "400"}], "}"}]}], ",", " ", 
       RowBox[{"AspectRatio", " ", "\[Rule]", " ", "Automatic"}], ",", 
       RowBox[{"Axes", "\[Rule]", "False"}], ",", 
       RowBox[{"PlotRange", "\[Rule]", ".1"}], ",", 
       RowBox[{"Frame", "\[Rule]", "False"}]}], "}"}]}], "]"}], ",", " ", 
   "\n", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\[Lambda]", ",", ".532", ",", "\"\<wavelength\>\""}], "}"}], 
     ",", ".4", ",", ".7", ",", 
     RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}], ",", " ", 
   "\n", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", " ", "0."}], "}"}], ",", " ", 
     RowBox[{"ControlType", " ", "\[Rule]", " ", "None"}]}], "}"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"y", ",", " ", "0."}], "}"}], ",", " ", 
     RowBox[{"ControlType", " ", "\[Rule]", " ", "None"}]}], "}"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\[Theta]", ",", " ", "0."}], "}"}], ",", " ", 
     RowBox[{"ControlType", " ", "\[Rule]", " ", "None"}]}], "}"}], ",", " ", 
   "\n", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x\[Theta]", ",", " ", "0.005"}], "}"}], ",", " ", 
     RowBox[{"ControlType", " ", "\[Rule]", " ", "None"}]}], "}"}], ",", " ", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"y\[Theta]", ",", " ", "0."}], "}"}], ",", " ", 
     RowBox[{"ControlType", " ", "\[Rule]", " ", "None"}]}], "}"}], ",", " ", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"radius\[Theta]", ",", " ", "0.005"}], "}"}], ",", " ", 
     RowBox[{"ControlType", " ", "\[Rule]", " ", "None"}]}], "}"}], ",", " ", 
   "\n", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"xoff\[Theta]", ",", " ", "0.005"}], "}"}], ",", " ", 
     RowBox[{"ControlType", " ", "\[Rule]", " ", "None"}]}], "}"}], ",", " ", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"yoff\[Theta]", ",", " ", "0."}], "}"}], ",", " ", 
     RowBox[{"ControlType", " ", "\[Rule]", " ", "None"}]}], "}"}], ",", " ", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"laststartpos\[Theta]", ",", " ", 
       RowBox[{"{", 
        RowBox[{"0", ",", " ", "0"}], "}"}]}], "}"}], ",", " ", 
     RowBox[{"ControlType", " ", "\[Rule]", " ", "None"}]}], "}"}], ",", " ", 
   "\n", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"lastlocpos\[Theta]", ",", " ", 
       RowBox[{"{", 
        RowBox[{"0.005", ",", " ", "0."}], "}"}]}], "}"}], ",", " ", 
     RowBox[{"ControlType", " ", "\[Rule]", " ", "None"}]}], "}"}], ",", " ", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"last\[Theta]", ",", " ", "0"}], "}"}], ",", " ", 
     RowBox[{"ControlType", " ", "\[Rule]", " ", "None"}]}], "}"}], ",", " ", 
   
   RowBox[{"AutorunSequencing", "\[Rule]", 
    RowBox[{"{", "1", "}"}]}], ",", "\n", " ", 
   RowBox[{"Initialization", " ", "\[RuleDelayed]", " ", 
    RowBox[{"(", 
     RowBox[{"raytracefunction13020200710911545612259", " ", "=", " ", 
      RowBox[{"Compile", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"x", ",", " ", "_Real"}], "}"}], ",", " ", 
          RowBox[{"{", 
           RowBox[{"y", ",", " ", "_Real"}], "}"}], ",", " ", 
          RowBox[{"{", 
           RowBox[{"\[Theta]", ",", " ", "_Real"}], "}"}], ",", " ", 
          RowBox[{"{", 
           RowBox[{"\[Lambda]", ",", " ", "_Real"}], "}"}]}], "}"}], ",", " ",
         "\n", "    ", 
        RowBox[{"Module", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
           "activeregion", ",", " ", "allcreatedamplitudes", ",", " ", 
            "allcreatedrays", ",", " ", "allowzeroraylength", ",", " ", 
            "alternateindex", ",", " ", "amplitude", ",", " ", 
            "axismagnitude", ",", " ", "axismatrix", ",", " ", "clonedata", 
            ",", " ", "clonegenerationnumber", ",", " ", "\n", "      ", 
            "cloneinput", ",", " ", "clonenumber", ",", " ", "cloneposition", 
            ",", " ", "clonereportedrays", ",", " ", "clonerotation", ",", 
            " ", "clonescale", ",", " ", "clonescalevector", ",", " ", 
            "clonesorthistogram", ",", " ", "clonetraceinput", ",", " ", 
            "clonetraceoutput", ",", " ", "\n", "      ", "closestdistances", 
            ",", " ", "closestposition", ",", " ", "closestpositions", ",", 
            " ", "closestraylength", ",", " ", "completedray", ",", " ", 
            "componentnumber", ",", " ", "cosangle", ",", " ", "crossmatrix", 
            ",", " ", "deflecteddummyrayspresent", ",", " ", 
            "deflectedlocalrays", ",", " ", "\n", "      ", "deflectedrays", 
            ",", " ", "deflectedrayspresent", ",", " ", "dummymatrix", ",", 
            " ", "dummymatrixlist", ",", " ", "dummyvector", ",", " ", 
            "frontid", ",", " ", "generationlimit", ",", " ", 
            "generationnumber", ",", " ", "holeintersections", ",", " ", 
            "holeQ", ",", " ", "holeQlist", ",", " ", "hor", ",", " ", 
            "index", ",", " ", "\n", "      ", "index1", ",", " ", "index2", 
            ",", " ", "inrays", ",", " ", "intensity", ",", " ", 
            "intensityscale", ",", " ", "intersectionnumber", ",", " ", 
            "intersections", ",", " ", "intersectionslist", ",", " ", 
            "intersectionspresent", ",", " ", "localdummyoutrayspresent", ",",
             " ", "localoutrays", ",", " ", "\n", "      ", 
            "localoutrayspresent", ",", " ", "magnitude", ",", " ", 
            "maxclonegenerationnumber", ",", " ", "maximumposition", ",", " ",
             "minimumraylength", ",", " ", "minresonateraylength", ",", " ", 
            "n12", ",", " ", "newcomponentnumber", ",", " ", 
            "newdeflectedrays", ",", " ", "newdistance", ",", " ", "\n", 
            "      ", "newsurfaceid", ",", " ", "newsurfacenumber", ",", " ", 
            "nonintersectingrays", ",", " ", "normalizedpolarization", ",", 
            " ", "oldgenerationnumber", ",", " ", "opticallength", ",", " ", 
            "originalray", ",", " ", "originalraytilt", ",", " ", 
            "originalrotation", ",", " ", "\n", "      ", "originalsurfnorm", 
            ",", " ", "outrays", ",", " ", "parallelamplitude", ",", " ", 
            "PAxis", ",", " ", "perpendicularamplitude", ",", " ", 
            "phaseshift", ",", " ", "pol1", ",", " ", "pol2", ",", " ", 
            "pol3", ",", " ", "previoustilt", ",", " ", "propagate", ",", " ",
             "propagatedrays", ",", " ", "r1", ",", " ", "r2", ",", " ", "r3",
             ",", " ", "r4", ",", " ", "r5", ",", " ", "r6", ",", " ", "r7", 
            ",", " ", "\n", "      ", "r8", ",", " ", "r9", ",", " ", "ray1", 
            ",", " ", "ray2", ",", " ", "ray3", ",", " ", "RayL", ",", " ", 
            "rayslot", ",", " ", "raysreported", ",", " ", "raytiltx", ",", 
            " ", "raytiltz", ",", " ", "reporteddummyrayspresent", ",", " ", 
            "reportedlocalrays", ",", " ", "reportedrays", ",", " ", 
            "reportedrayspresent", ",", " ", "\n", "      ", 
            "resonateintersections", ",", " ", "resonatenumber", ",", " ", 
            "resonateraylength", ",", " ", "rex", ",", " ", "rey", ",", " ", 
            "rez", ",", " ", "rotationaxis", ",", " ", "rsx", ",", " ", "RSx",
             ",", " ", "rsy", ",", " ", "RSy", ",", " ", "rsz", ",", " ", 
            "RSz", ",", " ", "RTx", ",", " ", "RTy", ",", " ", "RTz", ",", 
            " ", "rx", ",", " ", "rxhlp", ",", " ", "ry", ",", " ", "ryhlp", 
            ",", " ", "rz", ",", " ", "rzhlp", ",", " ", "SCx", ",", " ", 
            "SCy", ",", " ", "\n", "      ", "sid", ",", " ", "sinangle", ",",
             " ", "sno1", ",", " ", "sno2", ",", " ", "sno3", ",", " ", 
            "sno4", ",", " ", "surfaceid", ",", " ", "surfacenumber", ",", 
            " ", "surfacerotationmatrix", ",", " ", 
            "surfacetranslationvector", ",", " ", "surfnorm", ",", " ", 
            "symr1", ",", " ", "symr2", ",", " ", "symr3", ",", " ", "symr4", 
            ",", " ", "symr5", ",", " ", "symr6", ",", " ", "symr7", ",", " ",
             "\n", "      ", "symr8", ",", " ", "symr9", ",", " ", 
            "tempclonedata", ",", " ", "terminatedeflection", ",", " ", 
            "thresholdintensity", ",", " ", "tiltmagnitude", ",", " ", 
            "transmatrix", ",", " ", "TV1", ",", " ", "TV10", ",", " ", "TV2",
             ",", " ", "TV3", ",", " ", "TV4", ",", " ", "TV5", ",", " ", 
            "TV6", ",", " ", "TV7", ",", " ", "TV8", ",", " ", "TV9", ",", 
            " ", "u", ",", " ", "\n", "      ", "unfilteredintersections", 
            ",", " ", "unit", ",", " ", "uu", ",", " ", "ver", ",", " ", 
            "wavelength", ",", " ", "XAxis", ",", " ", "xunit", ",", " ", 
            "YAxis", ",", " ", "yunit", ",", " ", "ZAxis", ",", " ", 
            "zunit"}], "}"}], ",", " ", 
          RowBox[{
           RowBox[{"activeregion", " ", "=", " ", "1."}], ";", " ", 
           RowBox[{"allcreatedamplitudes", " ", "=", " ", 
            RowBox[{"{", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"0.", " ", "+", " ", 
                RowBox[{"0.", "*", "I"}]}], ",", " ", 
               RowBox[{"0.", " ", "+", " ", 
                RowBox[{"0.", "*", "I"}]}], ",", " ", 
               RowBox[{"0.", " ", "+", " ", 
                RowBox[{"0.", "*", "I"}]}]}], "}"}], "}"}]}], ";", " ", "\n", 
           "      ", 
           RowBox[{"allcreatedrays", " ", "=", " ", 
            RowBox[{"{", 
             RowBox[{"{", "1.", "}"}], "}"}]}], ";", " ", 
           RowBox[{"allowzeroraylength", " ", "=", " ", "True"}], ";", " ", 
           RowBox[{"alternateindex", " ", "=", " ", "1."}], ";", " ", 
           RowBox[{"amplitude", " ", "=", " ", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"1.", " ", "+", " ", 
               RowBox[{"0.", "*", "I"}]}], ",", " ", 
              RowBox[{"0.", " ", "+", " ", 
               RowBox[{"0.", "*", "I"}]}], ",", " ", 
              RowBox[{"0.", " ", "+", " ", 
               RowBox[{"0.", "*", "I"}]}]}], "}"}]}], ";", " ", 
           RowBox[{"axismagnitude", " ", "=", " ", "1."}], ";", " ", "\n", 
           "      ", 
           RowBox[{"axismatrix", " ", "=", " ", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"1.", ",", " ", "0.", ",", " ", "0."}], "}"}], ",", 
              " ", 
              RowBox[{"{", 
               RowBox[{"0.", ",", " ", "1.", ",", " ", "0."}], "}"}], ",", 
              " ", 
              RowBox[{"{", 
               RowBox[{"0.", ",", " ", "0.", ",", " ", "1."}], "}"}]}], 
             "}"}]}], ";", " ", 
           RowBox[{"clonedata", " ", "=", " ", 
            RowBox[{"{", 
             RowBox[{"{", "1.", "}"}], "}"}]}], ";", " ", 
           RowBox[{"clonegenerationnumber", " ", "=", " ", "1."}], ";", " ", 
           RowBox[{"cloneinput", " ", "=", " ", 
            RowBox[{"{", "1.", "}"}]}], ";", " ", 
           RowBox[{"clonenumber", " ", "=", " ", "1"}], ";", " ", 
           RowBox[{"cloneposition", " ", "=", " ", 
            RowBox[{"{", 
             RowBox[{"0.", ",", " ", "0.", ",", " ", "0."}], "}"}]}], ";", 
           " ", "\n", "      ", 
           RowBox[{"clonereportedrays", " ", "=", " ", 
            RowBox[{"{", 
             RowBox[{"{", "1.", "}"}], "}"}]}], ";", " ", 
           RowBox[{"clonerotation", " ", "=", " ", 
            RowBox[{"{", 
             RowBox[{"{", "1.", "}"}], "}"}]}], ";", " ", 
           RowBox[{"clonescale", " ", "=", " ", "1."}], ";", " ", 
           RowBox[{"clonescalevector", " ", "=", " ", 
            RowBox[{"{", "1.", "}"}]}], ";", " ", 
           RowBox[{"clonesorthistogram", " ", "=", " ", 
            RowBox[{"{", "1", "}"}]}], ";", " ", 
           RowBox[{"clonetraceinput", " ", "=", " ", 
            RowBox[{"{", 
             RowBox[{"{", "1.", "}"}], "}"}]}], ";", " ", 
           RowBox[{"clonetraceoutput", " ", "=", " ", 
            RowBox[{"{", 
             RowBox[{"{", "1.", "}"}], "}"}]}], ";", " ", "\n", "      ", 
           RowBox[{"closestdistances", " ", "=", " ", 
            RowBox[{"{", "1.", "}"}]}], ";", " ", 
           RowBox[{"closestposition", " ", "=", " ", "0"}], ";", " ", 
           RowBox[{"closestpositions", " ", "=", " ", 
            RowBox[{"{", "0", "}"}]}], ";", " ", 
           RowBox[{"closestraylength", " ", "=", " ", "1."}], ";", " ", 
           RowBox[{"completedray", " ", "=", " ", 
            RowBox[{"{", "1.", "}"}]}], ";", " ", 
           RowBox[{"componentnumber", " ", "=", " ", 
            RowBox[{"-", "1."}]}], ";", " ", 
           RowBox[{"cosangle", " ", "=", " ", "1."}], ";", " ", "\n", 
           "      ", 
           RowBox[{"crossmatrix", " ", "=", " ", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"1.", ",", " ", "0.", ",", " ", "0."}], "}"}], ",", 
              " ", 
              RowBox[{"{", 
               RowBox[{"0.", ",", " ", "1.", ",", " ", "0."}], "}"}], ",", 
              " ", 
              RowBox[{"{", 
               RowBox[{"0.", ",", " ", "0.", ",", " ", "1."}], "}"}]}], 
             "}"}]}], ";", " ", 
           RowBox[{"deflecteddummyrayspresent", " ", "=", " ", "False"}], ";",
            " ", 
           RowBox[{"deflectedlocalrays", " ", "=", " ", 
            RowBox[{"{", 
             RowBox[{"{", "1.", "}"}], "}"}]}], ";", " ", 
           RowBox[{"deflectedrays", " ", "=", " ", 
            RowBox[{"{", 
             RowBox[{"{", "1.", "}"}], "}"}]}], ";", " ", 
           RowBox[{"deflectedrayspresent", " ", "=", " ", "False"}], ";", " ",
            "\n", "      ", 
           RowBox[{"dummymatrix", " ", "=", " ", 
            RowBox[{"{", 
             RowBox[{"{", "1.", "}"}], "}"}]}], ";", " ", 
           RowBox[{"dummymatrixlist", " ", "=", " ", 
            RowBox[{"{", 
             RowBox[{"{", 
              RowBox[{"{", "1.", "}"}], "}"}], "}"}]}], ";", " ", 
           RowBox[{"dummyvector", " ", "=", " ", 
            RowBox[{"{", "1.", "}"}]}], ";", " ", 
           RowBox[{"frontid", " ", "=", " ", "1."}], ";", " ", 
           RowBox[{"generationlimit", " ", "=", " ", "200."}], ";", " ", 
           RowBox[{"generationnumber", " ", "=", " ", "1."}], ";", " ", 
           RowBox[{"holeintersections", " ", "=", " ", 
            RowBox[{"{", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], "}"}], 
             "}"}]}], ";", " ", "\n", "      ", 
           RowBox[{"holeQ", " ", "=", " ", "False"}], ";", " ", 
           RowBox[{"holeQlist", " ", "=", " ", 
            RowBox[{"{", "0", "}"}]}], ";", " ", 
           RowBox[{"hor", " ", "=", " ", 
            RowBox[{"1.", " ", "+", " ", 
             RowBox[{"0.", "*", "I"}]}]}], ";", " ", 
           RowBox[{"index", " ", "=", " ", "1."}], ";", " ", 
           RowBox[{"index1", " ", "=", " ", "1."}], ";", " ", 
           RowBox[{"index2", " ", "=", " ", "1."}], ";", " ", 
           RowBox[{"inrays", " ", "=", " ", 
            RowBox[{"{", 
             RowBox[{"{", "1.", "}"}], "}"}]}], ";", " ", 
           RowBox[{"intensity", " ", "=", " ", "1."}], ";", " ", 
           RowBox[{"intensityscale", " ", "=", " ", "1."}], ";", " ", 
           RowBox[{"intersectionnumber", " ", "=", " ", "1."}], ";", " ", 
           "\n", "      ", 
           RowBox[{"intersections", " ", "=", " ", 
            RowBox[{"{", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], "}"}], 
             "}"}]}], ";", " ", 
           RowBox[{"intersectionslist", " ", "=", " ", 
            RowBox[{"{", 
             RowBox[{"{", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], "}"}], 
              "}"}], "}"}]}], ";", " ", 
           RowBox[{"intersectionspresent", " ", "=", " ", "False"}], ";", " ", 
           RowBox[{"localdummyoutrayspresent", " ", "=", " ", "False"}], ";", 
           " ", 
           RowBox[{"localoutrays", " ", "=", " ", 
            RowBox[{"{", 
             RowBox[{"{", "1.", "}"}], "}"}]}], ";", " ", "\n", "      ", 
           RowBox[{"localoutrayspresent", " ", "=", " ", "False"}], ";", " ", 
           
           RowBox[{"magnitude", " ", "=", " ", "1."}], ";", " ", 
           RowBox[{"maxclonegenerationnumber", " ", "=", " ", "1."}], ";", 
           " ", 
           RowBox[{"maximumposition", " ", "=", " ", "1"}], ";", " ", 
           RowBox[{"minimumraylength", " ", "=", " ", "0.0001"}], ";", " ", 
           RowBox[{"minresonateraylength", " ", "=", " ", "1."}], ";", " ", 
           RowBox[{"n12", " ", "=", " ", "1."}], ";", " ", "\n", "      ", 
           RowBox[{"newcomponentnumber", " ", "=", " ", 
            RowBox[{"-", "1."}]}], ";", " ", 
           RowBox[{"newdeflectedrays", " ", "=", " ", 
            RowBox[{"{", 
             RowBox[{"{", "1.", "}"}], "}"}]}], ";", " ", 
           RowBox[{"newdistance", " ", "=", " ", "1."}], ";", " ", 
           RowBox[{"newsurfaceid", " ", "=", " ", 
            RowBox[{"-", "1."}]}], ";", " ", 
           RowBox[{"newsurfacenumber", " ", "=", " ", 
            RowBox[{"-", "1."}]}], ";", " ", 
           RowBox[{"nonintersectingrays", " ", "=", " ", 
            RowBox[{"{", 
             RowBox[{"{", "1.", "}"}], "}"}]}], ";", " ", "\n", "      ", 
           RowBox[{"normalizedpolarization", " ", "=", " ", 
            RowBox[{"{", 
             RowBox[{"1.", ",", " ", "1."}], "}"}]}], ";", " ", 
           RowBox[{"oldgenerationnumber", " ", "=", " ", "1."}], ";", " ", 
           RowBox[{"opticallength", " ", "=", " ", "1."}], ";", " ", 
           RowBox[{"originalray", " ", "=", " ", 
            RowBox[{"{", "1.", "}"}]}], ";", " ", 
           RowBox[{"originalraytilt", " ", "=", " ", 
            RowBox[{"{", "1.", "}"}]}], ";", " ", "\n", "      ", 
           RowBox[{"originalrotation", " ", "=", " ", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"1.", ",", " ", "0.", ",", " ", "0."}], "}"}], ",", 
              " ", 
              RowBox[{"{", 
               RowBox[{"0.", ",", " ", "1.", ",", " ", "0."}], "}"}], ",", 
              " ", 
              RowBox[{"{", 
               RowBox[{"0.", ",", " ", "0.", ",", " ", "1."}], "}"}]}], 
             "}"}]}], ";", " ", 
           RowBox[{"originalsurfnorm", " ", "=", " ", 
            RowBox[{"{", 
             RowBox[{"{", "1.", "}"}], "}"}]}], ";", " ", 
           RowBox[{"outrays", " ", "=", " ", 
            RowBox[{"{", 
             RowBox[{"{", "1.", "}"}], "}"}]}], ";", " ", 
           RowBox[{"parallelamplitude", " ", "=", " ", 
            RowBox[{"1.", " ", "+", " ", 
             RowBox[{"0.", "*", "I"}]}]}], ";", " ", 
           RowBox[{"PAxis", " ", "=", " ", 
            RowBox[{"{", 
             RowBox[{"1.", ",", " ", "0.", ",", " ", "0."}], "}"}]}], ";", 
           " ", "\n", "      ", 
           RowBox[{"perpendicularamplitude", " ", "=", " ", 
            RowBox[{"1.", " ", "+", " ", 
             RowBox[{"0.", "*", "I"}]}]}], ";", " ", 
           RowBox[{"phaseshift", " ", "=", " ", "0."}], ";", " ", 
           RowBox[{"pol1", " ", "=", " ", "1."}], ";", " ", 
           RowBox[{"pol2", " ", "=", " ", "1."}], ";", " ", 
           RowBox[{"pol3", " ", "=", " ", "1."}], ";", " ", 
           RowBox[{"previoustilt", " ", "=", " ", 
            RowBox[{"{", 
             RowBox[{"1.", ",", " ", "0.", ",", " ", "0."}], "}"}]}], ";", 
           " ", 
           RowBox[{"propagate", " ", "=", " ", "True"}], ";", " ", 
           RowBox[{"propagatedrays", " ", "=", " ", 
            RowBox[{"{", 
             RowBox[{"{", "1.", "}"}], "}"}]}], ";", " ", 
           RowBox[{"r1", " ", "=", " ", "1."}], ";", " ", 
           RowBox[{"r2", " ", "=", " ", "1."}], ";", " ", "\n", "      ", 
           RowBox[{"r3", " ", "=", " ", "1."}], ";", " ", 
           RowBox[{"r4", " ", "=", " ", "1."}], ";", " ", 
           RowBox[{"r5", " ", "=", " ", "1."}], ";", " ", 
           RowBox[{"r6", " ", "=", " ", "1."}], ";", " ", 
           RowBox[{"r7", " ", "=", " ", "1."}], ";", " ", 
           RowBox[{"r8", " ", "=", " ", "1."}], ";", " ", 
           RowBox[{"r9", " ", "=", " ", "1."}], ";", " ", 
           RowBox[{"ray1", " ", "=", " ", "1."}], ";", " ", 
           RowBox[{"ray2", " ", "=", " ", "1."}], ";", " ", 
           RowBox[{"ray3", " ", "=", " ", "1."}], ";", " ", 
           RowBox[{"RayL", " ", "=", " ", "1."}], ";", " ", 
           RowBox[{"rayslot", " ", "=", " ", "1."}], ";", " ", 
           RowBox[{"raysreported", " ", "=", " ", "False"}], ";", " ", 
           RowBox[{"raytiltx", " ", "=", " ", "1."}], ";", " ", 
           RowBox[{"raytiltz", " ", "=", " ", "1."}], ";", " ", "\n", 
           "      ", 
           RowBox[{"reporteddummyrayspresent", " ", "=", " ", "False"}], ";", 
           " ", 
           RowBox[{"reportedlocalrays", " ", "=", " ", 
            RowBox[{"{", 
             RowBox[{"{", "1.", "}"}], "}"}]}], ";", " ", 
           RowBox[{"reportedrays", " ", "=", " ", 
            RowBox[{"{", 
             RowBox[{"{", "1.", "}"}], "}"}]}], ";", " ", 
           RowBox[{"reportedrayspresent", " ", "=", " ", "False"}], ";", " ", 
           
           RowBox[{"resonateintersections", " ", "=", " ", 
            RowBox[{"{", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], "}"}], 
             "}"}]}], ";", " ", 
           RowBox[{"resonatenumber", " ", "=", " ", "0"}], ";", " ", "\n", 
           "      ", 
           RowBox[{"resonateraylength", " ", "=", " ", "1."}], ";", " ", 
           RowBox[{"rex", " ", "=", " ", "1."}], ";", " ", 
           RowBox[{"rey", " ", "=", " ", "1."}], ";", " ", 
           RowBox[{"rez", " ", "=", " ", "1."}], ";", " ", 
           RowBox[{"rsx", " ", "=", " ", "1."}], ";", " ", 
           RowBox[{"RSx", " ", "=", " ", "1."}], ";", " ", 
           RowBox[{"rsy", " ", "=", " ", "1."}], ";", " ", 
           RowBox[{"RSy", " ", "=", " ", "1."}], ";", " ", 
           RowBox[{"rsz", " ", "=", " ", "1."}], ";", " ", 
           RowBox[{"RSz", " ", "=", " ", "1."}], ";", " ", 
           RowBox[{"RTx", " ", "=", " ", "1."}], ";", " ", 
           RowBox[{"RTy", " ", "=", " ", "1."}], ";", " ", 
           RowBox[{"RTz", " ", "=", " ", "1."}], ";", " ", 
           RowBox[{"rx", " ", "=", " ", "1."}], ";", " ", 
           RowBox[{"rxhlp", " ", "=", " ", "1."}], ";", " ", 
           RowBox[{"ry", " ", "=", " ", "1."}], ";", " ", "\n", "      ", 
           RowBox[{"ryhlp", " ", "=", " ", "1."}], ";", " ", 
           RowBox[{"rz", " ", "=", " ", "1."}], ";", " ", 
           RowBox[{"rzhlp", " ", "=", " ", "1."}], ";", " ", 
           RowBox[{"SCx", " ", "=", " ", "1."}], ";", " ", 
           RowBox[{"SCy", " ", "=", " ", "1."}], ";", " ", 
           RowBox[{"sid", " ", "=", " ", "1."}], ";", " ", 
           RowBox[{"sinangle", " ", "=", " ", "1."}], ";", " ", 
           RowBox[{"sno1", " ", "=", " ", "1."}], ";", " ", 
           RowBox[{"sno2", " ", "=", " ", "1."}], ";", " ", 
           RowBox[{"sno3", " ", "=", " ", "1."}], ";", " ", 
           RowBox[{"sno4", " ", "=", " ", "1."}], ";", " ", 
           RowBox[{"surfaceid", " ", "=", " ", 
            RowBox[{"-", "1."}]}], ";", " ", 
           RowBox[{"surfacenumber", " ", "=", " ", 
            RowBox[{"-", "1."}]}], ";", " ", "\n", "      ", 
           RowBox[{"surfacerotationmatrix", " ", "=", " ", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"1.", ",", " ", "0.", ",", " ", "0."}], "}"}], ",", 
              " ", 
              RowBox[{"{", 
               RowBox[{"0.", ",", " ", "1.", ",", " ", "0."}], "}"}], ",", 
              " ", 
              RowBox[{"{", 
               RowBox[{"0.", ",", " ", "0.", ",", " ", "1."}], "}"}]}], 
             "}"}]}], ";", " ", 
           RowBox[{"surfacetranslationvector", " ", "=", " ", 
            RowBox[{"{", 
             RowBox[{"0.", ",", " ", "0.", ",", " ", "0."}], "}"}]}], ";", 
           " ", 
           RowBox[{"surfnorm", " ", "=", " ", 
            RowBox[{"{", 
             RowBox[{"{", "1.", "}"}], "}"}]}], ";", " ", 
           RowBox[{"symr1", " ", "=", " ", "1."}], ";", " ", 
           RowBox[{"symr2", " ", "=", " ", "1."}], ";", " ", 
           RowBox[{"symr3", " ", "=", " ", "1."}], ";", " ", 
           RowBox[{"symr4", " ", "=", " ", "1."}], ";", " ", "\n", "      ", 
           RowBox[{"symr5", " ", "=", " ", "1."}], ";", " ", 
           RowBox[{"symr6", " ", "=", " ", "1."}], ";", " ", 
           RowBox[{"symr7", " ", "=", " ", "1."}], ";", " ", 
           RowBox[{"symr8", " ", "=", " ", "1."}], ";", " ", 
           RowBox[{"symr9", " ", "=", " ", "1."}], ";", " ", 
           RowBox[{"tempclonedata", " ", "=", " ", 
            RowBox[{"{", 
             RowBox[{"{", "1.", "}"}], "}"}]}], ";", " ", 
           RowBox[{"terminatedeflection", " ", "=", " ", "False"}], ";", " ", 
           
           RowBox[{"thresholdintensity", " ", "=", " ", "1."}], ";", " ", 
           RowBox[{"tiltmagnitude", " ", "=", " ", "1."}], ";", " ", "\n", 
           "      ", 
           RowBox[{"transmatrix", " ", "=", " ", 
            RowBox[{"{", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"1.", ",", " ", "0.", ",", " ", "0."}], "}"}], ",", 
               " ", 
               RowBox[{"{", 
                RowBox[{"0.", ",", " ", "1.", ",", " ", "0."}], "}"}], ",", 
               " ", 
               RowBox[{"{", 
                RowBox[{"0.", ",", " ", "0.", ",", " ", "1."}], "}"}]}], 
              "}"}], "}"}]}], ";", " ", 
           RowBox[{"TV1", " ", "=", " ", "1."}], ";", " ", 
           RowBox[{"TV10", " ", "=", " ", "1."}], ";", " ", 
           RowBox[{"TV2", " ", "=", " ", "1."}], ";", " ", 
           RowBox[{"TV3", " ", "=", " ", "1."}], ";", " ", 
           RowBox[{"TV4", " ", "=", " ", "1."}], ";", " ", 
           RowBox[{"TV5", " ", "=", " ", "1."}], ";", " ", 
           RowBox[{"TV6", " ", "=", " ", "1."}], ";", " ", 
           RowBox[{"TV7", " ", "=", " ", "1."}], ";", " ", 
           RowBox[{"TV8", " ", "=", " ", "1."}], ";", " ", 
           RowBox[{"TV9", " ", "=", " ", "1."}], ";", " ", "\n", "      ", 
           RowBox[{"u", " ", "=", " ", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"1.", ",", " ", "0.", ",", " ", "0."}], "}"}], ",", 
              " ", 
              RowBox[{"{", 
               RowBox[{"0.", ",", " ", "1.", ",", " ", "0."}], "}"}], ",", 
              " ", 
              RowBox[{"{", 
               RowBox[{"0.", ",", " ", "0.", ",", " ", "1."}], "}"}]}], 
             "}"}]}], ";", " ", 
           RowBox[{"unfilteredintersections", " ", "=", " ", 
            RowBox[{"{", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], "}"}], 
             "}"}]}], ";", " ", 
           RowBox[{"unit", " ", "=", " ", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"1.", ",", " ", "0.", ",", " ", "0."}], "}"}], ",", 
              " ", 
              RowBox[{"{", 
               RowBox[{"0.", ",", " ", "1.", ",", " ", "0."}], "}"}], ",", 
              " ", 
              RowBox[{"{", 
               RowBox[{"0.", ",", " ", "0.", ",", " ", "1."}], "}"}]}], 
             "}"}]}], ";", " ", "\n", "      ", 
           RowBox[{"uu", " ", "=", " ", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"1.", ",", " ", "0.", ",", " ", "0."}], "}"}], ",", 
              " ", 
              RowBox[{"{", 
               RowBox[{"0.", ",", " ", "1.", ",", " ", "0."}], "}"}], ",", 
              " ", 
              RowBox[{"{", 
               RowBox[{"0.", ",", " ", "0.", ",", " ", "1."}], "}"}]}], 
             "}"}]}], ";", " ", 
           RowBox[{"ver", " ", "=", " ", 
            RowBox[{"0.", " ", "+", " ", 
             RowBox[{"0.", "*", "I"}]}]}], ";", " ", 
           RowBox[{"wavelength", " ", "=", " ", "1."}], ";", " ", 
           RowBox[{"XAxis", " ", "=", " ", 
            RowBox[{"{", 
             RowBox[{"1.", ",", " ", "0.", ",", " ", "0."}], "}"}]}], ";", 
           " ", 
           RowBox[{"xunit", " ", "=", " ", "1."}], ";", " ", 
           RowBox[{"YAxis", " ", "=", " ", 
            RowBox[{"{", 
             RowBox[{"1.", ",", " ", "0.", ",", " ", "0."}], "}"}]}], ";", 
           " ", 
           RowBox[{"yunit", " ", "=", " ", "1."}], ";", " ", 
           RowBox[{"ZAxis", " ", "=", " ", 
            RowBox[{"{", 
             RowBox[{"1.", ",", " ", "0.", ",", " ", "0."}], "}"}]}], ";", 
           " ", "\n", "      ", 
           RowBox[{"zunit", " ", "=", " ", "1."}], ";", " ", 
           RowBox[{"propagatedrays", " ", "=", " ", 
            RowBox[{"Join", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                "symr1", ",", " ", "symr2", ",", " ", "symr3", ",", " ", 
                 "symr4", ",", " ", "symr5", ",", " ", "symr6", ",", " ", 
                 "symr7", ",", " ", "symr8", ",", " ", "symr9"}], "}"}], " ", 
               "=", " ", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"Cos", "[", 
                  RowBox[{"Degree", "*", "\[Theta]"}], "]"}], ",", " ", 
                 RowBox[{"Sin", "[", 
                  RowBox[{"Degree", "*", "\[Theta]"}], "]"}], ",", " ", "0", 
                 ",", " ", 
                 RowBox[{"-", 
                  RowBox[{"Sin", "[", 
                   RowBox[{"Degree", "*", "\[Theta]"}], "]"}]}], ",", " ", 
                 RowBox[{"Cos", "[", 
                  RowBox[{"Degree", "*", "\[Theta]"}], "]"}], ",", " ", "0", 
                 ",", " ", "\n", "           ", "0", ",", " ", "0", ",", " ", 
                 "1"}], "}"}]}], ";", " ", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "rez", ",", " ", "r1", ",", 
                    " ", "r2", ",", " ", "r3", ",", " ", "r4", ",", " ", "r5",
                     ",", " ", "r6", ",", " ", "r7", ",", " ", "r8", ",", " ",
                     "r9", ",", " ", "wavelength", ",", " ", "intensity", ",",
                     " ", "intensityscale", ",", " ", "ray1", ",", " ", 
                    "index", ",", " ", "opticallength", ",", " ", 
                    "phaseshift", ",", " ", "\n", "              ", 
                    "componentnumber", ",", " ", "surfacenumber", ",", " ", 
                    "surfaceid", ",", " ", "ray2", ",", " ", "ray3", ",", " ",
                     "sid", ",", " ", "frontid", ",", " ", "sno1", ",", " ", 
                    "sno2", ",", " ", "sno3", ",", " ", "sno4", ",", " ", 
                    "rayslot", ",", " ", "oldgenerationnumber", ",", " ", 
                    "intersectionnumber", ",", " ", "pol1", ",", " ", "pol2", 
                    ",", " ", "pol3"}], "}"}], " ", "=", " ", "#1"}], ";", 
                   " ", "\n", "            ", 
                   RowBox[{"wavelength", " ", "=", " ", "\[Lambda]"}], ";", 
                   " ", 
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{"TV1", ",", " ", "TV2", ",", " ", "TV3"}], "}"}], 
                    " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"rsx", "*", "symr1"}], " ", "+", " ", 
                    RowBox[{"rsy", "*", "symr4"}], " ", "+", " ", 
                    RowBox[{"rsz", "*", "symr7"}], " ", "+", " ", "x"}], ",", 
                    " ", 
                    RowBox[{
                    RowBox[{"rsx", "*", "symr2"}], " ", "+", " ", 
                    RowBox[{"rsy", "*", "symr5"}], " ", "+", " ", 
                    RowBox[{"rsz", "*", "symr8"}], " ", "+", " ", "y"}], ",", 
                    " ", 
                    RowBox[{
                    RowBox[{"rsx", "*", "symr3"}], " ", "+", " ", 
                    RowBox[{"rsy", "*", "symr6"}], " ", "+", " ", 
                    RowBox[{"rsz", "*", "symr9"}]}]}], "}"}]}], ";", " ", 
                   "\n", "            ", 
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{"rsx", ",", " ", "rsy", ",", " ", "rsz"}], "}"}], 
                    " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"TV1", ",", " ", "TV2", ",", " ", "TV3"}], 
                    "}"}]}], ";", " ", 
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{"TV1", ",", " ", "TV2", ",", " ", "TV3"}], "}"}], 
                    " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"rex", "*", "symr1"}], " ", "+", " ", 
                    RowBox[{"rey", "*", "symr4"}], " ", "+", " ", 
                    RowBox[{"rez", "*", "symr7"}], " ", "+", " ", "x"}], ",", 
                    " ", 
                    RowBox[{
                    RowBox[{"rex", "*", "symr2"}], " ", "+", " ", 
                    RowBox[{"rey", "*", "symr5"}], " ", "+", " ", 
                    RowBox[{"rez", "*", "symr8"}], " ", "+", " ", "y"}], ",", 
                    " ", 
                    RowBox[{
                    RowBox[{"rex", "*", "symr3"}], " ", "+", " ", 
                    RowBox[{"rey", "*", "symr6"}], " ", "+", " ", 
                    RowBox[{"rez", "*", "symr9"}]}]}], "}"}]}], ";", " ", 
                   "\n", "            ", 
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{"rex", ",", " ", "rey", ",", " ", "rez"}], "}"}], 
                    " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"TV1", ",", " ", "TV2", ",", " ", "TV3"}], 
                    "}"}]}], ";", " ", 
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{"TV1", ",", " ", "TV2", ",", " ", "TV3"}], "}"}], 
                    " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"r1", "*", "symr1"}], " ", "+", " ", 
                    RowBox[{"r2", "*", "symr4"}], " ", "+", " ", 
                    RowBox[{"r3", "*", "symr7"}]}], ",", " ", 
                    RowBox[{
                    RowBox[{"r1", "*", "symr2"}], " ", "+", " ", 
                    RowBox[{"r2", "*", "symr5"}], " ", "+", " ", 
                    RowBox[{"r3", "*", "symr8"}]}], ",", " ", 
                    RowBox[{
                    RowBox[{"r1", "*", "symr3"}], " ", "+", " ", 
                    RowBox[{"r2", "*", "symr6"}], " ", "+", " ", 
                    RowBox[{"r3", "*", "symr9"}]}]}], "}"}]}], ";", " ", "\n",
                    "            ", 
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{"TV4", ",", " ", "TV5", ",", " ", "TV6"}], "}"}], 
                    " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"r4", "*", "symr1"}], " ", "+", " ", 
                    RowBox[{"r5", "*", "symr4"}], " ", "+", " ", 
                    RowBox[{"r6", "*", "symr7"}]}], ",", " ", 
                    RowBox[{
                    RowBox[{"r4", "*", "symr2"}], " ", "+", " ", 
                    RowBox[{"r5", "*", "symr5"}], " ", "+", " ", 
                    RowBox[{"r6", "*", "symr8"}]}], ",", " ", 
                    RowBox[{
                    RowBox[{"r4", "*", "symr3"}], " ", "+", " ", 
                    RowBox[{"r5", "*", "symr6"}], " ", "+", " ", 
                    RowBox[{"r6", "*", "symr9"}]}]}], "}"}]}], ";", " ", "\n",
                    "            ", 
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{"TV7", ",", " ", "TV8", ",", " ", "TV9"}], "}"}], 
                    " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"r7", "*", "symr1"}], " ", "+", " ", 
                    RowBox[{"r8", "*", "symr4"}], " ", "+", " ", 
                    RowBox[{"r9", "*", "symr7"}]}], ",", " ", 
                    RowBox[{
                    RowBox[{"r7", "*", "symr2"}], " ", "+", " ", 
                    RowBox[{"r8", "*", "symr5"}], " ", "+", " ", 
                    RowBox[{"r9", "*", "symr8"}]}], ",", " ", 
                    RowBox[{
                    RowBox[{"r7", "*", "symr3"}], " ", "+", " ", 
                    RowBox[{"r8", "*", "symr6"}], " ", "+", " ", 
                    RowBox[{"r9", "*", "symr9"}]}]}], "}"}]}], ";", " ", 
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"r4", ",", " ", "r5", ",", " ", "r6"}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"r7", ",", " ", "r8", ",", " ", "r9"}], "}"}]}], 
                    "}"}], " ", "=", " ", "\n", "             ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"TV1", ",", " ", "TV2", ",", " ", "TV3"}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"TV4", ",", " ", "TV5", ",", " ", "TV6"}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"TV7", ",", " ", "TV8", ",", " ", "TV9"}], 
                    "}"}]}], "}"}]}], ";", " ", 
                   RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "rez", ",", " ", "r1", ",", 
                    " ", "r2", ",", " ", "r3", ",", " ", "r4", ",", " ", "r5",
                     ",", " ", "r6", ",", " ", "r7", ",", " ", "r8", ",", " ",
                     "r9", ",", " ", "wavelength", ",", " ", "intensity", ",",
                     " ", "intensityscale", ",", " ", "ray1", ",", " ", "\n", 
                    "             ", "index", ",", " ", "opticallength", ",", 
                    " ", "phaseshift", ",", " ", "componentnumber", ",", " ", 
                    "surfacenumber", ",", " ", "surfaceid", ",", " ", "ray2", 
                    ",", " ", "ray3", ",", " ", "sid", ",", " ", "frontid", 
                    ",", " ", "sno1", ",", " ", "sno2", ",", " ", "sno3", ",",
                     " ", "sno4", ",", " ", "rayslot", ",", " ", 
                    "generationnumber", ",", " ", "\n", "             ", 
                    "intersectionnumber", ",", " ", "pol1", ",", " ", "pol2", 
                    ",", " ", "pol3"}], "}"}]}], ")"}], " ", "&"}], " ", 
                ")"}], " ", "/@", " ", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{
                  "0.", ",", " ", "0.", ",", " ", "0.", ",", " ", "0.", ",", 
                   " ", "0.", ",", " ", "0.", ",", " ", "0.9063077870366499", 
                   ",", " ", "0.42261826174069944", ",", " ", "0.", ",", " ", 
                   
                   RowBox[{"-", "0.42261826174069944"}], ",", " ", 
                   "0.9063077870366499", ",", " ", "0.", ",", " ", "0.", ",", 
                   " ", "\n", "            ", "0.", ",", " ", "1.", ",", " ", 
                   "0.532", ",", " ", "100.", ",", " ", "0.14285714285714285",
                    ",", " ", "0.", ",", " ", "1.3352653477480756", ",", " ", 
                   "0.", ",", " ", "0.", ",", " ", "1.", ",", " ", "0.", ",", 
                   " ", "0.", ",", " ", "0.", ",", " ", "0.", ",", " ", 
                   "9602.", ",", " ", "9602.", ",", " ", "1.", ",", " ", "7.",
                    ",", " ", "1.", ",", " ", "0.", ",", " ", "1.", ",", " ", 
                   "0.", ",", " ", "0.", ",", " ", "0.", ",", " ", "1.", ",", 
                   " ", "0."}], "}"}], ",", " ", "\n", "           ", 
                 RowBox[{"{", 
                  RowBox[{
                  "0.", ",", " ", "0.", ",", " ", "0.", ",", " ", "0.", ",", 
                   " ", "0.", ",", " ", "0.", ",", " ", "0.9579895123154889", 
                   ",", " ", "0.2868032327110903", ",", " ", "0.", ",", " ", 
                   RowBox[{"-", "0.2868032327110903"}], ",", " ", 
                   "0.9579895123154889", ",", " ", "0.", ",", " ", "0.", ",", 
                   " ", "0.", ",", " ", "1.", ",", " ", "0.532", ",", " ", 
                   "100.", ",", " ", "0.14285714285714285", ",", " ", "0.", 
                   ",", " ", "\n", "            ", "1.3352653477480756", ",", 
                   " ", "0.", ",", " ", "0.", ",", " ", "1.", ",", " ", "0.", 
                   ",", " ", "0.", ",", " ", "0.", ",", " ", "0.", ",", " ", 
                   "9602.", ",", " ", "9602.", ",", " ", "2.", ",", " ", "7.",
                    ",", " ", "2.", ",", " ", "0.", ",", " ", "1.", ",", " ", 
                   "0.", ",", " ", "0.", ",", " ", "0.", ",", " ", "1.", ",", 
                   " ", "0."}], "}"}], ",", " ", 
                 RowBox[{"{", 
                  RowBox[{
                  "0.", ",", " ", "0.", ",", " ", "0.", ",", " ", "0.", ",", 
                   " ", "0.", ",", " ", "0.", ",", " ", "0.9894416385809445", 
                   ",", " ", "0.14493185930724678", ",", " ", "\n", 
                   "            ", "0.", ",", " ", 
                   RowBox[{"-", "0.14493185930724678"}], ",", " ", 
                   "0.9894416385809445", ",", " ", "0.", ",", " ", "0.", ",", 
                   " ", "0.", ",", " ", "1.", ",", " ", "0.532", ",", " ", 
                   "100.", ",", " ", "0.14285714285714285", ",", " ", "0.", 
                   ",", " ", "1.3352653477480756", ",", " ", "0.", ",", " ", 
                   "0.", ",", " ", "1.", ",", " ", "0.", ",", " ", "0.", ",", 
                   " ", "0.", ",", " ", "0.", ",", " ", "9602.", ",", " ", 
                   "9602.", ",", " ", "3.", ",", " ", "7.", ",", " ", "\n", 
                   "            ", "3.", ",", " ", "0.", ",", " ", "1.", ",", 
                   " ", "0.", ",", " ", "0.", ",", " ", "0.", ",", " ", "1.", 
                   ",", " ", "0."}], "}"}], ",", " ", 
                 RowBox[{"{", 
                  RowBox[{
                  "0.", ",", " ", "0.", ",", " ", "0.", ",", " ", "0.", ",", 
                   " ", "0.", ",", " ", "0.", ",", " ", "1.", ",", " ", 
                   "6.200655107570901*^-17", ",", " ", "0.", ",", " ", 
                   RowBox[{"-", "6.200655107570901*^-17"}], ",", " ", "1.", 
                   ",", " ", "0.", ",", " ", "0.", ",", " ", "0.", ",", " ", 
                   "1.", ",", " ", "0.532", ",", " ", "100.", ",", " ", 
                   "0.14285714285714285", ",", " ", "\n", "            ", 
                   "0.", ",", " ", "1.3352653477480756", ",", " ", "0.", ",", 
                   " ", "0.", ",", " ", "1.", ",", " ", "0.", ",", " ", "0.", 
                   ",", " ", "0.", ",", " ", "0.", ",", " ", "9602.", ",", 
                   " ", "9602.", ",", " ", "4.", ",", " ", "7.", ",", " ", 
                   "4.", ",", " ", "0.", ",", " ", "1.", ",", " ", "0.", ",", 
                   " ", "0.", ",", " ", "0.", ",", " ", "1.", ",", " ", 
                   "0."}], "}"}], ",", " ", 
                 RowBox[{"{", 
                  RowBox[{
                  "0.", ",", " ", "0.", ",", " ", "0.", ",", " ", "0.", ",", 
                   " ", "0.", ",", " ", "0.", ",", " ", "0.9894416385809446", 
                   ",", " ", "\n", "            ", 
                   RowBox[{"-", "0.14493185930724664"}], ",", " ", "0.", ",", 
                   " ", "0.14493185930724664", ",", " ", "0.9894416385809446",
                    ",", " ", "0.", ",", " ", "0.", ",", " ", "0.", ",", " ", 
                   "1.", ",", " ", "0.532", ",", " ", "100.", ",", " ", 
                   "0.14285714285714285", ",", " ", "0.", ",", " ", 
                   "1.3352653477480756", ",", " ", "0.", ",", " ", "0.", ",", 
                   " ", "1.", ",", " ", "0.", ",", " ", "0.", ",", " ", "0.", 
                   ",", " ", "0.", ",", " ", "\n", "            ", "9602.", 
                   ",", " ", "9602.", ",", " ", "5.", ",", " ", "7.", ",", 
                   " ", "5.", ",", " ", "0.", ",", " ", "1.", ",", " ", "0.", 
                   ",", " ", "0.", ",", " ", "0.", ",", " ", "1.", ",", " ", 
                   "0."}], "}"}], ",", " ", 
                 RowBox[{"{", 
                  RowBox[{
                  "0.", ",", " ", "0.", ",", " ", "0.", ",", " ", "0.", ",", 
                   " ", "0.", ",", " ", "0.", ",", " ", "0.9579895123154889", 
                   ",", " ", 
                   RowBox[{"-", "0.2868032327110902"}], ",", " ", "0.", ",", 
                   " ", "0.2868032327110902", ",", " ", "0.9579895123154889", 
                   ",", " ", "0.", ",", " ", "\n", "            ", "0.", ",", 
                   " ", "0.", ",", " ", "1.", ",", " ", "0.532", ",", " ", 
                   "100.", ",", " ", "0.14285714285714285", ",", " ", "0.", 
                   ",", " ", "1.3352653477480756", ",", " ", "0.", ",", " ", 
                   "0.", ",", " ", "1.", ",", " ", "0.", ",", " ", "0.", ",", 
                   " ", "0.", ",", " ", "0.", ",", " ", "9602.", ",", " ", 
                   "9602.", ",", " ", "6.", ",", " ", "7.", ",", " ", "6.", 
                   ",", " ", "0.", ",", " ", "1.", ",", " ", "0.", ",", " ", 
                   "0.", ",", " ", "0.", ",", " ", "1.", ",", " ", "0."}], 
                  "}"}], ",", " ", "\n", "           ", 
                 RowBox[{"{", 
                  RowBox[{
                  "0.", ",", " ", "0.", ",", " ", "0.", ",", " ", "0.", ",", 
                   " ", "0.", ",", " ", "0.", ",", " ", "0.90630778703665", 
                   ",", " ", 
                   RowBox[{"-", "0.42261826174069933"}], ",", " ", "0.", ",", 
                   " ", "0.42261826174069933", ",", " ", "0.90630778703665", 
                   ",", " ", "0.", ",", " ", "0.", ",", " ", "0.", ",", " ", 
                   "1.", ",", " ", "0.532", ",", " ", "100.", ",", " ", 
                   "0.14285714285714285", ",", " ", "0.", ",", " ", "\n", 
                   "            ", "1.3352653477480756", ",", " ", "0.", ",", 
                   " ", "0.", ",", " ", "1.", ",", " ", "0.", ",", " ", "0.", 
                   ",", " ", "0.", ",", " ", "0.", ",", " ", "9602.", ",", 
                   " ", "9602.", ",", " ", "7.", ",", " ", "7.", ",", " ", 
                   "7.", ",", " ", "0.", ",", " ", "1.", ",", " ", "0.", ",", 
                   " ", "0.", ",", " ", "0.", ",", " ", "1.", ",", " ", 
                   "0."}], "}"}]}], "}"}]}]}], "]"}]}], ";", " ", "\n", 
           "      ", 
           RowBox[{"propagatedrays", " ", "=", " ", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{
                   "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "rez", ",", " ", "r1", ",", 
                    " ", "r2", ",", " ", "r3", ",", " ", "r4", ",", " ", "r5",
                     ",", " ", "r6", ",", " ", "r7", ",", " ", "r8", ",", " ",
                     "r9", ",", " ", "wavelength", ",", " ", "intensity", ",",
                     " ", "intensityscale", ",", " ", "ray1", ",", " ", 
                    "index", ",", " ", "opticallength", ",", " ", 
                    "phaseshift", ",", " ", "\n", "            ", 
                    "componentnumber", ",", " ", "surfacenumber", ",", " ", 
                    "surfaceid", ",", " ", "ray2", ",", " ", "ray3", ",", " ",
                     "sid", ",", " ", "frontid", ",", " ", "sno1", ",", " ", 
                    "sno2", ",", " ", "sno3", ",", " ", "sno4", ",", " ", 
                    "rayslot", ",", " ", "oldgenerationnumber", ",", " ", 
                    "intersectionnumber", ",", " ", "pol1", ",", " ", "pol2", 
                    ",", " ", "pol3"}], "}"}], " ", "=", " ", "#1"}], ";", 
                 " ", "\n", "          ", 
                 RowBox[{"componentnumber", " ", "=", " ", "1."}], ";", " ", 
                 RowBox[{"frontid", " ", "=", " ", "1."}], ";", " ", 
                 RowBox[{"{", 
                  RowBox[{
                  "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                   ",", " ", "rey", ",", " ", "rez", ",", " ", "r1", ",", " ",
                    "r2", ",", " ", "r3", ",", " ", "r4", ",", " ", "r5", ",",
                    " ", "r6", ",", " ", "r7", ",", " ", "r8", ",", " ", "r9",
                    ",", " ", "wavelength", ",", " ", "intensity", ",", " ", 
                   "intensityscale", ",", " ", "ray1", ",", " ", "index", ",",
                    " ", "opticallength", ",", " ", "\n", "           ", 
                   "phaseshift", ",", " ", "componentnumber", ",", " ", 
                   "surfacenumber", ",", " ", "surfaceid", ",", " ", "ray2", 
                   ",", " ", "ray3", ",", " ", "sid", ",", " ", "frontid", 
                   ",", " ", "sno1", ",", " ", "sno2", ",", " ", "sno3", ",", 
                   " ", "sno4", ",", " ", "rayslot", ",", " ", 
                   "generationnumber", ",", " ", "intersectionnumber", ",", 
                   " ", "pol1", ",", " ", "pol2", ",", " ", "\n", 
                   "           ", "pol3"}], "}"}]}], ")"}], " ", "&"}], " ", 
              ")"}], " ", "/@", " ", "propagatedrays"}]}], ";", " ", 
           RowBox[{"thresholdintensity", " ", "=", " ", "1."}], ";", " ", 
           RowBox[{"generationlimit", " ", "=", " ", "50."}], ";", " ", "\n", 
           "      ", 
           RowBox[{"reportedrays", " ", "=", " ", 
            RowBox[{"{", 
             RowBox[{"{", 
              RowBox[{
              "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", ",", 
               " ", "rey", ",", " ", "rez", ",", " ", "r1", ",", " ", "r2", 
               ",", " ", "r3", ",", " ", "r4", ",", " ", "r5", ",", " ", "r6",
                ",", " ", "r7", ",", " ", "r8", ",", " ", "r9", ",", " ", 
               "wavelength", ",", " ", "0", ",", " ", "intensityscale", ",", 
               " ", "ray1", ",", " ", "index", ",", " ", "opticallength", ",",
                " ", "phaseshift", ",", " ", "componentnumber", ",", " ", 
               "\n", "         ", "surfacenumber", ",", " ", "surfaceid", ",",
                " ", "ray2", ",", " ", "ray3", ",", " ", "sid", ",", " ", 
               "frontid", ",", " ", "sno1", ",", " ", "sno2", ",", " ", 
               "sno3", ",", " ", "sno4", ",", " ", "rayslot", ",", " ", 
               "generationnumber", ",", " ", "intersectionnumber", ",", " ", 
               "pol1", ",", " ", "pol2", ",", " ", "pol3"}], "}"}], "}"}]}], 
           ";", " ", 
           RowBox[{"generationnumber", " ", "=", " ", "0."}], ";", " ", "\n", 
           "      ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"inrays", " ", "=", " ", "propagatedrays"}], ";", " ", 
             RowBox[{"outrays", " ", "=", " ", 
              RowBox[{"{", 
               RowBox[{"{", 
                RowBox[{
                "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", 
                 " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", 
                 ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", 
                 "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", 
                 " ", "1.", ",", " ", 
                 RowBox[{"-", "9.87654321*^8"}], ",", " ", "1.", ",", " ", 
                 "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "0.", ",", 
                 " ", 
                 RowBox[{"-", "1."}], ",", " ", 
                 RowBox[{"-", "1."}], ",", " ", 
                 RowBox[{"-", "1."}], ",", " ", "1.", ",", " ", "1.", ",", 
                 " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "\n", 
                 "          ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ",
                  "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", 
                 " ", "1.", ",", " ", "1."}], "}"}], "}"}]}], ";", " ", 
             RowBox[{"deflectedrayspresent", " ", "=", " ", "True"}], ";", 
             " ", 
             RowBox[{"reportedrayspresent", " ", "=", " ", "False"}], ";", 
             " ", 
             RowBox[{"propagate", " ", "=", " ", "True"}], ";", " ", "\n", 
             "       ", 
             RowBox[{"While", "[", 
              RowBox[{
               RowBox[{"deflectedrayspresent", " ", "&&", " ", "propagate"}], 
               ",", " ", 
               RowBox[{
                RowBox[{"generationnumber", " ", "+=", " ", "1."}], ";", " ", 
                
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                  "deflecteddummyrayspresent", " ", "=", " ", "False"}], ";", 
                  " ", 
                  RowBox[{"deflectedrayspresent", " ", "=", " ", "False"}], 
                  ";", " ", 
                  RowBox[{"reportedrayspresent", " ", "=", " ", "False"}], 
                  ";", " ", "\n", "          ", 
                  RowBox[{"reporteddummyrayspresent", " ", "=", " ", "True"}],
                   ";", " ", 
                  RowBox[{
                  "localdummyoutrayspresent", " ", "=", " ", "False"}], ";", 
                  " ", 
                  RowBox[{"localoutrayspresent", " ", "=", " ", "False"}], 
                  ";", " ", 
                  RowBox[{
                   RowBox[{"{", 
                    RowBox[{
                    "deflectedlocalrays", ",", " ", "localoutrays", ",", " ", 
                    "reportedlocalrays"}], "}"}], " ", "=", " ", "\n", 
                   "           ", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"Flatten", "[", 
                    RowBox[{"#1", ",", " ", "1"}], "]"}], " ", "&"}], " ", 
                    ")"}], " ", "/@", " ", 
                    RowBox[{"Transpose", "[", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "rez", ",", " ", "r1", ",", 
                    " ", "r2", ",", " ", "r3", ",", " ", "r4", ",", " ", "r5",
                     ",", " ", "r6", ",", " ", "r7", ",", " ", "r8", ",", " ",
                     "r9", ",", " ", "wavelength", ",", " ", "intensity", ",",
                     " ", "intensityscale", ",", " ", "ray1", ",", " ", 
                    "index", ",", " ", "opticallength", ",", " ", "\n", 
                    "                  ", "phaseshift", ",", " ", 
                    "componentnumber", ",", " ", "surfacenumber", ",", " ", 
                    "surfaceid", ",", " ", "ray2", ",", " ", "ray3", ",", " ",
                     "sid", ",", " ", "frontid", ",", " ", "sno1", ",", " ", 
                    "sno2", ",", " ", "sno3", ",", " ", "sno4", ",", " ", 
                    "rayslot", ",", " ", "oldgenerationnumber", ",", " ", 
                    "intersectionnumber", ",", " ", "pol1", ",", " ", "\n", 
                    "                  ", "pol2", ",", " ", "pol3"}], "}"}], 
                    " ", "=", " ", "#1"}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    "intensity", " ", ">", " ", "thresholdintensity"}], " ", "&&",
                     " ", 
                    RowBox[{
                    "generationnumber", " ", "<", " ", "generationlimit"}]}], 
                    ",", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"resonatenumber", " ", "=", " ", "0"}], ";", " ", 
                    
                    RowBox[{
                    "resonateraylength", " ", "=", " ", "9.87654321*^8"}], 
                    ";", " ", "\n", "                   ", 
                    RowBox[{"resonateintersections", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}], "}"}]}], ";", " ", 
                    RowBox[{"MapIndexed", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"#1", "[", 
                    RowBox[{"[", 
                    RowBox[{"1", ",", "1"}], "]"}], "]"}], " ", ">", " ", 
                    RowBox[{"-", "1."}]}], " ", "&&", " ", 
                    RowBox[{
                    RowBox[{"#1", "[", 
                    RowBox[{"[", 
                    RowBox[{"1", ",", "1"}], "]"}], "]"}], " ", "<", " ", 
                    "resonateraylength"}]}], ",", " ", 
                    RowBox[{
                    RowBox[{"resonateraylength", " ", "=", " ", 
                    RowBox[{"#1", "[", 
                    RowBox[{"[", 
                    RowBox[{"1", ",", "1"}], "]"}], "]"}]}], ";", " ", 
                    RowBox[{
                    "resonateintersections", " ", "=", " ", "\n", 
                    "                        ", "#1"}], ";", " ", 
                    RowBox[{"resonatenumber", " ", "=", " ", 
                    RowBox[{"First", "[", "#2", "]"}]}]}], ",", " ", 
                    "resonatenumber"}], "]"}], " ", "&"}], " ", ",", " ", 
                    RowBox[{
                    RowBox[{"intersectionslist", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}], "}"}], "}"}]}], ";", " ", 
                    RowBox[{"holeQlist", " ", "=", " ", 
                    RowBox[{"{", "0", "}"}]}], ";", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "rez", ",", " ", "r1", ",", 
                    " ", "r2", ",", " ", "r3", ",", " ", "r4", ",", " ", "\n",
                     "                        ", "r5", ",", " ", "r6", ",", 
                    " ", "r7", ",", " ", "r8", ",", " ", "r9", ",", " ", 
                    "wavelength", ",", " ", "intensity", ",", " ", 
                    "intensityscale", ",", " ", "ray1", ",", " ", "index", 
                    ",", " ", "opticallength", ",", " ", "phaseshift", ",", 
                    " ", "componentnumber", ",", " ", "surfacenumber", ",", 
                    " ", "surfaceid", ",", " ", "ray2", ",", " ", "ray3", ",",
                     " ", "\n", "                        ", "sid", ",", " ", 
                    "frontid", ",", " ", "sno1", ",", " ", "sno2", ",", " ", 
                    "sno3", ",", " ", "sno4", ",", " ", "rayslot", ",", " ", 
                    "oldgenerationnumber", ",", " ", "intersectionnumber", 
                    ",", " ", "pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], " ", "=", " ", "#1"}], ";", " ", 
                    RowBox[{"index1", " ", "=", " ", "index"}], ";", " ", 
                    RowBox[{"xunit", " ", "=", " ", "r1"}], ";", " ", 
                    RowBox[{"yunit", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"-", "1."}], "*", "r3"}]}], ";", " ", "\n", 
                    "                      ", 
                    RowBox[{"zunit", " ", "=", " ", "r2"}], ";", " ", 
                    RowBox[{"xunit", " ", "=", " ", 
                    RowBox[{"Chop", "[", "xunit", "]"}]}], ";", " ", 
                    RowBox[{"yunit", " ", "=", " ", 
                    RowBox[{"Chop", "[", "yunit", "]"}]}], ";", " ", 
                    RowBox[{"zunit", " ", "=", " ", 
                    RowBox[{"Chop", "[", "zunit", "]"}]}], ";", " ", 
                    RowBox[{"magnitude", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"xunit", "^", "2"}], " ", "+", " ", 
                    RowBox[{"yunit", "^", "2"}], " ", "+", " ", 
                    RowBox[{"zunit", "^", "2"}]}], ")"}], "^", 
                    RowBox[{"2", "^", 
                    RowBox[{"(", 
                    RowBox[{"-", "1"}], ")"}]}]}]}], ";", " ", 
                    RowBox[{"xunit", " ", "=", " ", 
                    RowBox[{"xunit", "/", "magnitude"}]}], ";", " ", "\n", 
                    "                      ", 
                    RowBox[{"yunit", " ", "=", " ", 
                    RowBox[{"yunit", "/", "magnitude"}]}], ";", " ", 
                    RowBox[{"zunit", " ", "=", " ", 
                    RowBox[{"zunit", "/", "magnitude"}]}], ";", " ", 
                    RowBox[{"rx", " ", "=", " ", "rex"}], ";", " ", 
                    RowBox[{"ry", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"-", "1."}], "*", "rez"}]}], ";", " ", 
                    RowBox[{"rz", " ", "=", " ", 
                    RowBox[{"0.68", " ", "+", " ", "rey"}]}], ";", " ", 
                    RowBox[{"rx", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rx", "]"}]}], ";", " ", 
                    RowBox[{"ry", " ", "=", " ", 
                    RowBox[{"Chop", "[", "ry", "]"}]}], ";", " ", 
                    RowBox[{"rz", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rz", "]"}]}], ";", " ", 
                    RowBox[{
                    "terminatedeflection", " ", "=", " ", "\n", 
                    "                       ", "False"}], ";", " ", 
                    RowBox[{"intersections", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}], "}"}]}], ";", " ", 
                    RowBox[{"intersections", " ", "=", " ", 
                    RowBox[{"Block", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "surfaceapprox", ",", " ", "tempapprox", ",", " ", 
                    "intersects", ",", " ", "RayL", ",", " ", "SCx", ",", " ",
                     "SCy"}], "}"}], ",", " ", 
                    RowBox[{
                    RowBox[{"RayL", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"SCx", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"SCy", " ", "=", " ", "1."}], ";", " ", "\n", 
                    "                         ", 
                    RowBox[{"surfaceapprox", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}], "}"}]}], ";", " ", 
                    RowBox[{"tempapprox", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}], "}"}]}], ";", " ", 
                    RowBox[{"intersects", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}], "}"}]}], ";", " ", 
                    RowBox[{"surfaceapprox", " ", "=", " ", 
                    RowBox[{"Block", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "trintersects", ",", " ", "minratio", ",", " ", "ratio12",
                     ",", " ", "ss", ",", " ", "tt", ",", " ", "\n", 
                    "                            ", "raylength", ",", " ", 
                    "p1ss", ",", " ", "p1tt", ",", " ", "p2ss", ",", " ", 
                    "p2tt", ",", " ", "p3ss", ",", " ", "p3tt", ",", " ", 
                    "p4ss", ",", " ", "p4tt", ",", " ", "tempvalue", ",", " ",
                     "p1raylength", ",", " ", "p1x", ",", " ", "p1y", ",", 
                    " ", "p1z", ",", " ", "p2raylength", ",", " ", "p2x", ",",
                     " ", "p2y", ",", " ", "p2z", ",", " ", "p3raylength", 
                    ",", " ", "p3x", ",", " ", "p3y", ",", " ", "p3z", ",", 
                    " ", "\n", "                            ", "p4raylength", 
                    ",", " ", "p4x", ",", " ", "p4y", ",", " ", "p4z", ",", 
                    " ", "goodintersection"}], "}"}], ",", " ", 
                    RowBox[{
                    RowBox[{"trintersects", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}], "}"}]}], ";", " ", 
                    RowBox[{"minratio", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"p1ss", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"p2ss", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"p3ss", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"p1tt", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"p2tt", " ", "=", " ", "1."}], ";", " ", "\n", 
                    "                            ", 
                    RowBox[{"p3tt", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"ratio12", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"p1x", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"p1y", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"p1z", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"p2x", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"p2y", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"p2z", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"p3x", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"p3y", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"p3z", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"p4x", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"p4y", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"p4z", " ", "=", " ", "1."}], ";", " ", "\n", 
                    "                            ", 
                    RowBox[{"p4ss", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"p4tt", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"ss", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"tt", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"raylength", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"p1raylength", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"p2raylength", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"p3raylength", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"p4raylength", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"tempvalue", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", "1.", "}"}], "}"}]}], ";", " ", "\n", 
                    "                            ", 
                    RowBox[{"goodintersection", " ", "=", " ", "True"}], ";", 
                    " ", 
                    RowBox[{"trintersects", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"Function", "[", 
                    RowBox[{"trval$", ",", " ", 
                    RowBox[{
                    RowBox[{"Function", "[", 
                    RowBox[{"trinter$", ",", " ", 
                    RowBox[{"Join", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"trinter$", " ", "!=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}]}], ",", " ", 
                    RowBox[{
                    RowBox[{"Function", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"point", ",", " ", "select"}], "}"}], ",", " ", 
                    "\n", "                                      ", 
                    RowBox[{
                    RowBox[{"Function", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "a", ",", " ", "b", ",", " ", "c", ",", " ", "l1", ",", 
                    " ", "l2", ",", " ", "l3"}], "}"}], ",", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"Abs", "[", 
                    RowBox[{
                    RowBox[{"2", "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"l1", "*", "l3"}], " ", "+", " ", 
                    RowBox[{"l1", "*", "c"}], " ", "+", " ", 
                    RowBox[{"l3", "*", "c"}]}], ")"}]}], " ", "-", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"l1", "^", "2"}], " ", "+", " ", 
                    RowBox[{"l3", "^", "2"}], " ", "+", " ", 
                    RowBox[{"c", "^", "2"}]}], ")"}]}], "]"}], "]"}], " ", 
                    "+", " ", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"Abs", "[", 
                    RowBox[{
                    RowBox[{"2", "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"a", "*", "l2"}], " ", "+", " ", 
                    RowBox[{"a", "*", "l1"}], " ", "+", " ", 
                    RowBox[{"l2", "*", "l1"}]}], ")"}]}], " ", "-", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"a", "^", "2"}], " ", "+", " ", 
                    RowBox[{"l2", "^", "2"}], " ", "+", " ", "\n", 
                    "                                              ", 
                    RowBox[{"l1", "^", "2"}]}], ")"}]}], "]"}], "]"}], " ", 
                    "+", " ", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"Abs", "[", 
                    RowBox[{
                    RowBox[{"2", "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"l2", "*", "b"}], " ", "+", " ", 
                    RowBox[{"l2", "*", "l3"}], " ", "+", " ", 
                    RowBox[{"b", "*", "l3"}]}], ")"}]}], " ", "-", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"l2", "^", "2"}], " ", "+", " ", 
                    RowBox[{"b", "^", "2"}], " ", "+", " ", 
                    RowBox[{"l3", "^", "2"}]}], ")"}]}], "]"}], "]"}]}], 
                    ")"}], "/", 
                    RowBox[{"select", "[", 
                    RowBox[{"[", "4", "]"}], "]"}]}]}], "]"}], "[", 
                    RowBox[{
                    RowBox[{"select", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], ",", " ", 
                    RowBox[{"select", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], ",", " ", 
                    RowBox[{"select", "[", 
                    RowBox[{"[", "3", "]"}], "]"}], ",", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"#1", " ", ".", " ", "#1"}], " ", "&"}], " ", 
                    ")"}], "[", "\n", 
                    "                                        ", 
                    RowBox[{"point", " ", "-", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"select", "[", 
                    RowBox[{"[", "7", "]"}], "]"}], ",", " ", 
                    RowBox[{"select", "[", 
                    RowBox[{"[", "8", "]"}], "]"}], ",", " ", 
                    RowBox[{"select", "[", 
                    RowBox[{"[", "9", "]"}], "]"}]}], "}"}]}], "]"}], ",", 
                    " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"#1", " ", ".", " ", "#1"}], " ", "&"}], " ", 
                    ")"}], "[", 
                    RowBox[{"point", " ", "-", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"select", "[", 
                    RowBox[{"[", "12", "]"}], "]"}], ",", " ", 
                    RowBox[{"select", "[", 
                    RowBox[{"[", "13", "]"}], "]"}], ",", " ", 
                    RowBox[{"select", "[", 
                    RowBox[{"[", "14", "]"}], "]"}]}], "}"}]}], "]"}], ",", 
                    " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"#1", " ", ".", " ", "#1"}], " ", "&"}], " ", 
                    ")"}], "[", "\n", 
                    "                                        ", 
                    RowBox[{"point", " ", "-", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"select", "[", 
                    RowBox[{"[", "17", "]"}], "]"}], ",", " ", 
                    RowBox[{"select", "[", 
                    RowBox[{"[", "18", "]"}], "]"}], ",", " ", 
                    RowBox[{"select", "[", 
                    RowBox[{"[", "19", "]"}], "]"}]}], "}"}]}], "]"}]}], 
                    "]"}]}], "]"}], "[", 
                    RowBox[{"trinter$", ",", " ", 
                    RowBox[{"Take", "[", 
                    RowBox[{"trval$", ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"20", ",", " ", "38"}], "}"}]}], "]"}]}], "]"}], 
                    ",", " ", "10000."}], "]"}], "}"}], ",", " ", "trinter$", 
                    ",", " ", 
                    RowBox[{"Take", "[", 
                    RowBox[{"trval$", ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"24", ",", " ", "38"}], "}"}]}], "]"}]}], "]"}]}],
                     "]"}], "[", "\n", "                                ", 
                    RowBox[{
                    RowBox[{"Function", "[", 
                    RowBox[{"intersect", ",", " ", 
                    RowBox[{
                    RowBox[{"Function", "[", 
                    RowBox[{"denom", ",", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"denom", " ", "!=", " ", "0"}], ",", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"intersect", "[", 
                    RowBox[{"[", "17", "]"}], "]"}], ",", " ", 
                    RowBox[{"intersect", "[", 
                    RowBox[{"[", "18", "]"}], "]"}], ",", " ", 
                    RowBox[{"intersect", "[", 
                    RowBox[{"[", "19", "]"}], "]"}]}], "}"}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"xunit", "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"rz", "*", 
                    RowBox[{"intersect", "[", 
                    RowBox[{"[", "5", "]"}], "]"}]}], " ", "-", " ", "\n", 
                    "                                           ", 
                    RowBox[{"ry", "*", 
                    RowBox[{"intersect", "[", 
                    RowBox[{"[", "6", "]"}], "]"}]}], " ", "+", " ", 
                    RowBox[{"intersect", "[", 
                    RowBox[{"[", "7", "]"}], "]"}]}], ")"}]}], " ", "+", " ", 
                    
                    RowBox[{"yunit", "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"rx", "*", 
                    RowBox[{"intersect", "[", 
                    RowBox[{"[", "6", "]"}], "]"}]}], " ", "-", " ", 
                    RowBox[{"rz", "*", 
                    RowBox[{"intersect", "[", 
                    RowBox[{"[", "8", "]"}], "]"}]}], " ", "+", " ", 
                    RowBox[{"intersect", "[", 
                    RowBox[{"[", "9", "]"}], "]"}]}], ")"}]}], " ", "+", " ", 
                    
                    RowBox[{"zunit", "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"ry", "*", 
                    RowBox[{"intersect", "[", 
                    RowBox[{"[", "8", "]"}], "]"}]}], " ", "-", " ", "\n", 
                    "                                           ", 
                    RowBox[{"rx", "*", 
                    RowBox[{"intersect", "[", 
                    RowBox[{"[", "5", "]"}], "]"}]}], " ", "+", " ", 
                    RowBox[{"intersect", "[", 
                    RowBox[{"[", "10", "]"}], "]"}]}], ")"}]}]}], ")"}], "*", 
                    
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"intersect", "[", 
                    RowBox[{"[", "14", "]"}], "]"}], ",", " ", 
                    RowBox[{"intersect", "[", 
                    RowBox[{"[", "11", "]"}], "]"}], ",", " ", 
                    RowBox[{"intersect", "[", 
                    RowBox[{"[", "12", "]"}], "]"}]}], "}"}]}], ")"}], "/", 
                    "denom"}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"xunit", "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"rz", "*", 
                    RowBox[{"intersect", "[", 
                    RowBox[{"[", "11", "]"}], "]"}]}], " ", "-", " ", "\n", 
                    "                                           ", 
                    RowBox[{"ry", "*", 
                    RowBox[{"intersect", "[", 
                    RowBox[{"[", "12", "]"}], "]"}]}], " ", "+", " ", 
                    RowBox[{"intersect", "[", 
                    RowBox[{"[", "13", "]"}], "]"}]}], ")"}]}], " ", "-", " ", 
                    RowBox[{"yunit", "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"rz", "*", 
                    RowBox[{"intersect", "[", 
                    RowBox[{"[", "14", "]"}], "]"}]}], " ", "-", " ", 
                    RowBox[{"rx", "*", 
                    RowBox[{"intersect", "[", 
                    RowBox[{"[", "12", "]"}], "]"}]}], " ", "+", " ", 
                    RowBox[{"intersect", "[", 
                    RowBox[{"[", "15", "]"}], "]"}]}], ")"}]}], " ", "+", " ", 
                    RowBox[{"zunit", "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"ry", "*", 
                    RowBox[{"intersect", "[", 
                    RowBox[{"[", "14", "]"}], "]"}]}], " ", "-", " ", "\n", 
                    "                                           ", 
                    RowBox[{"rx", "*", 
                    RowBox[{"intersect", "[", 
                    RowBox[{"[", "11", "]"}], "]"}]}], " ", "+", " ", 
                    RowBox[{"intersect", "[", 
                    RowBox[{"[", "16", "]"}], "]"}]}], ")"}]}]}], ")"}], "*", 
                    
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"intersect", "[", 
                    RowBox[{"[", "8", "]"}], "]"}], ",", " ", 
                    RowBox[{"intersect", "[", 
                    RowBox[{"[", "5", "]"}], "]"}], ",", " ", 
                    RowBox[{"intersect", "[", 
                    RowBox[{"[", "6", "]"}], "]"}]}], "}"}]}], ")"}], "/", 
                    RowBox[{"(", 
                    RowBox[{"-", "denom"}], ")"}]}]}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}]}], "]"}]}], "]"}], "[", 
                    RowBox[{
                    RowBox[{"xunit", "*", 
                    RowBox[{"intersect", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], " ", "+", " ", "\n", 
                    "                                    ", 
                    RowBox[{"yunit", "*", 
                    RowBox[{"intersect", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], " ", "+", " ", 
                    RowBox[{"zunit", "*", 
                    RowBox[{"intersect", "[", 
                    RowBox[{"[", "3", "]"}], "]"}]}]}], "]"}]}], "]"}], "[", 
                    RowBox[{"Take", "[", 
                    RowBox[{"trval$", ",", " ", "19"}], "]"}], "]"}], "]"}]}],
                     "]"}], " ", "/@", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "0", ",", " ", "0.", ",", " ", "0", ",", " ", "0", ",", 
                    " ", "0", ",", " ", "0.", ",", " ", "0", ",", " ", "0", 
                    ",", " ", "0", ",", " ", "0", ",", " ", "0", ",", " ", 
                    "0.0024195679317141616", ",", " ", "0", ",", " ", "\n", 
                    "                                ", 
                    RowBox[{"-", "0.019872334842201373"}], ",", " ", 
                    "0.012382792667417267", ",", " ", "0", ",", " ", "0", ",",
                     " ", "0", ",", " ", "0.6231171508403164", ",", " ", 
                    "0.00040076400105675024", ",", " ", 
                    "0.00040076400105675024", ",", " ", "0.", ",", " ", "0.", 
                    ",", " ", 
                    RowBox[{"-", "3.141592653589793"}], ",", " ", "\n", 
                    "                                ", 
                    RowBox[{"-", "0.1090287493478726"}], ",", " ", "0", ",", 
                    " ", "0", ",", " ", "0.6231171508403164", ",", " ", 
                    RowBox[{"-", "3.141592653589793"}], ",", " ", 
                    RowBox[{"-", "0.08722299947829808"}], ",", " ", 
                    RowBox[{"-", "0.019872334842201373"}], ",", " ", "0", ",",
                     " ", "0.6255367187720305", ",", " ", "\n", 
                    "                                ", 
                    RowBox[{"-", "2.356194490192345"}], ",", " ", 
                    RowBox[{"-", "0.1090287493478726"}], ",", " ", "0", ",", 
                    " ", "0", ",", " ", "0.6231171508403164"}], "}"}], ",", 
                    " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "0.00003399943643008982", ",", " ", 
                    "0.000014083027682385701", ",", " ", 
                    "0.00027924332122646295", ",", " ", "\n", 
                    "                                ", 
                    "0.00017400130271382082", ",", " ", "0", ",", " ", 
                    "0.0024195679317141616", ",", " ", "0", ",", " ", 
                    RowBox[{"-", "0.019872334842201373"}], ",", " ", 
                    RowBox[{"-", "0.012382792667417267"}], ",", " ", "0", ",",
                     " ", 
                    RowBox[{"-", "0.014051862724930291"}], ",", " ", 
                    "0.0024195679317141616", ",", " ", "\n", 
                    "                                ", 
                    "0.008755956665157808", ",", " ", 
                    RowBox[{"-", "0.01405186272493029"}], ",", " ", 
                    "0.008755956665157806", ",", " ", "0", ",", " ", "0", ",",
                     " ", "0", ",", " ", "0.6231171508403164", ",", " ", 
                    "0.00040076400105675024", ",", " ", 
                    "0.0002313327417082155", ",", " ", "\n", 
                    "                                ", 
                    "0.00040076400105675024", ",", " ", 
                    "0.0005633156337111628", ",", " ", 
                    RowBox[{"-", "2.356194490192345"}], ",", " ", 
                    RowBox[{"-", "0.1090287493478726"}], ",", " ", "0", ",", 
                    " ", "0", ",", " ", "0.6231171508403164", ",", " ", 
                    RowBox[{"-", "2.356194490192345"}], ",", " ", "\n", 
                    "                                ", 
                    RowBox[{"-", "0.08722299947829808"}], ",", " ", 
                    RowBox[{"-", "0.01405186272493029"}], ",", " ", 
                    RowBox[{"-", "0.014051862724930291"}], ",", " ", 
                    "0.6255367187720305", ",", " ", 
                    RowBox[{"-", "3.141592653589793"}], ",", " ", 
                    RowBox[{"-", "0.08722299947829808"}], ",", " ", "\n", 
                    "                                ", 
                    RowBox[{"-", "0.019872334842201373"}], ",", " ", "0", ",",
                     " ", "0.6255367187720305"}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "0.00010295013224607963"}], ",", " ", 
                    RowBox[{"-", "0.000042643341024429376"}], ",", " ", 
                    RowBox[{"-", "0.00029010153472220366"}], ",", " ", 
                    RowBox[{"-", "0.00017942330264081454"}], ",", " ", "\n", 
                    "                                ", 
                    RowBox[{"-", "0.014051862724930291"}], ",", " ", "0.", 
                    ",", " ", "0.008789956101587898", ",", " ", 
                    "0.005820472117271084", ",", " ", "0.003640919029941847", 
                    ",", " ", "0.00027924332122646295", ",", " ", "0", ",", 
                    " ", "0.007326440220870367", ",", " ", "0", ",", " ", 
                    "\n", "                                ", 
                    RowBox[{"-", "0.020645058979085838"}], ",", " ", 
                    "0.012768648979361894", ",", " ", "0", ",", " ", 
                    RowBox[{"-", "0.019872334842201373"}], ",", " ", "0", ",",
                     " ", "0.6255367187720305", ",", " ", 
                    "0.0004798951865599198", ",", " ", 
                    "0.0009515559085625077", ",", " ", "\n", 
                    "                                ", 
                    "0.0002313327417082155", ",", " ", 
                    "0.0006215338597739907", ",", " ", 
                    RowBox[{"-", "3.141592653589793"}], ",", " ", 
                    RowBox[{"-", "0.08722299947829808"}], ",", " ", 
                    RowBox[{"-", "0.019872334842201373"}], ",", " ", "0", ",",
                     " ", "0.6255367187720305", ",", " ", "\n", 
                    "                                ", 
                    RowBox[{"-", "3.141592653589793"}], ",", " ", 
                    RowBox[{"-", "0.06541724960872355"}], ",", " ", 
                    RowBox[{"-", "0.04051739382128721"}], ",", " ", "0", ",", 
                    " ", "0.6328631589929009", ",", " ", 
                    RowBox[{"-", "2.356194490192345"}], ",", " ", 
                    RowBox[{"-", "0.08722299947829808"}], ",", " ", "\n", 
                    "                                ", 
                    RowBox[{"-", "0.01405186272493029"}], ",", " ", 
                    RowBox[{"-", "0.014051862724930291"}], ",", " ", 
                    "0.6255367187720305"}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "0.00020990342027197434", ",", " ", 
                    "0.00008694484346514954", ",", " ", 
                    "0.0005914834982318202", ",", " ", "\n", 
                    "                                ", 
                    "0.000365823375639567", ",", " ", "0.014051862724930291", 
                    ",", " ", "0.007326440220870367", ",", " ", 
                    RowBox[{"-", "0.008892906233833977"}], ",", " ", 
                    RowBox[{"-", "0.026465531096356923"}], ",", " ", 
                    RowBox[{"-", "0.01645221135032817"}], ",", " ", "\n", 
                    "                                ", 
                    RowBox[{"-", "0.0005693448559486666"}], ",", " ", 
                    RowBox[{"-", "0.014598261202107818"}], ",", " ", 
                    "0.007326440220870367", ",", " ", "0.009028798279897483", 
                    ",", " ", 
                    RowBox[{"-", "0.014598261202107816"}], ",", " ", 
                    "0.009028798279897485", ",", " ", "0.", ",", " ", "\n", 
                    "                                ", 
                    RowBox[{"-", "0.01405186272493029"}], ",", " ", 
                    RowBox[{"-", "0.014051862724930291"}], ",", " ", 
                    "0.6255367187720305", ",", " ", "0.0004798951865599198", 
                    ",", " ", "0.0009616616957775927", ",", " ", 
                    "0.0009515559085625077", ",", " ", "\n", 
                    "                                ", 
                    "0.0012672357007717284", ",", " ", 
                    RowBox[{"-", "2.356194490192345"}], ",", " ", 
                    RowBox[{"-", "0.08722299947829808"}], ",", " ", 
                    RowBox[{"-", "0.01405186272493029"}], ",", " ", 
                    RowBox[{"-", "0.014051862724930291"}], ",", " ", 
                    "0.6255367187720305", ",", " ", 
                    RowBox[{"-", "2.356194490192345"}], ",", " ", "\n", 
                    "                                ", 
                    RowBox[{"-", "0.06541724960872355"}], ",", " ", 
                    RowBox[{"-", "0.028650123927038106"}], ",", " ", 
                    RowBox[{"-", "0.02865012392703811"}], ",", " ", 
                    "0.6328631589929009", ",", " ", 
                    RowBox[{"-", "3.141592653589793"}], ",", " ", 
                    RowBox[{"-", "0.06541724960872355"}], ",", " ", "\n", 
                    "                                ", 
                    RowBox[{"-", "0.04051739382128721"}], ",", " ", "0", ",", 
                    " ", "0.6328631589929009"}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "0.00033670536496174103"}], ",", " ", 
                    RowBox[{"-", "0.0001394679286909374"}], ",", " ", 
                    RowBox[{"-", "0.0005036849306382233"}], ",", " ", 
                    RowBox[{"-", "0.000305121212466931"}], ",", " ", "\n", 
                    "                                ", 
                    RowBox[{"-", "0.02865012392703811"}], ",", " ", "0.", ",",
                     " ", "0.018131607934003435", ",", " ", 
                    "0.011867269894249105", ",", " ", "0.007510357913895836", 
                    ",", " ", "0.0011608283541804868", ",", " ", "0", ",", 
                    " ", "0.011752317924320854", ",", " ", "0", ",", " ", 
                    "\n", "                                ", 
                    RowBox[{"-", "0.017580549805680898"}], ",", " ", 
                    "0.010649908993202561", ",", " ", "0", ",", " ", 
                    RowBox[{"-", "0.04051739382128721"}], ",", " ", "0", ",", 
                    " ", "0.6328631589929009", ",", " ", 
                    "0.00044719270806433986", ",", " ", 
                    "0.0018261206627085403", ",", " ", "\n", 
                    "                                ", 
                    "0.0009616616957775927", ",", " ", 
                    "0.0012434151604020164", ",", " ", 
                    RowBox[{"-", "3.141592653589793"}], ",", " ", 
                    RowBox[{"-", "0.06541724960872355"}], ",", " ", 
                    RowBox[{"-", "0.04051739382128721"}], ",", " ", "0", ",", 
                    " ", "0.6328631589929009", ",", " ", "\n", 
                    "                                ", 
                    RowBox[{"-", "3.141592653589793"}], ",", " ", 
                    RowBox[{"-", "0.04361149973914903"}], ",", " ", 
                    RowBox[{"-", "0.05809794362696811"}], ",", " ", "0", ",", 
                    " ", "0.6446154769172218", ",", " ", 
                    RowBox[{"-", "2.356194490192345"}], ",", " ", 
                    RowBox[{"-", "0.06541724960872355"}], ",", " ", "\n", 
                    "                                ", 
                    RowBox[{"-", "0.028650123927038106"}], ",", " ", 
                    RowBox[{"-", "0.02865012392703811"}], ",", " ", 
                    "0.6328631589929009"}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "0.00048280226015345526", ",", " ", 
                    "0.00019998324409994592", ",", " ", 
                    "0.0007222344762608719", ",", " ", "\n", 
                    "                                ", 
                    "0.0004375137028675933", ",", " ", "0.02865012392703811", 
                    ",", " ", "0.011752317924320854", ",", " ", 
                    RowBox[{"-", "0.018468313298965176"}], ",", " ", 
                    RowBox[{"-", "0.029447819699930003"}], ",", " ", 
                    RowBox[{"-", "0.018299734835789335"}], ",", " ", "\n", 
                    "                                ", 
                    RowBox[{"-", "0.0016645132848187101"}], ",", " ", 
                    RowBox[{"-", "0.012431325984584806"}], ",", " ", 
                    "0.011752317924320854", ",", " ", "0.007530622868113131", 
                    ",", " ", 
                    RowBox[{"-", "0.012431325984584803"}], ",", " ", 
                    "0.007530622868113127", ",", " ", "0.", ",", " ", "\n", 
                    "                                ", 
                    RowBox[{"-", "0.028650123927038106"}], ",", " ", 
                    RowBox[{"-", "0.02865012392703811"}], ",", " ", 
                    "0.6328631589929009", ",", " ", "0.0004471927080643399", 
                    ",", " ", "0.001977246585205565", ",", " ", 
                    "0.0018261206627085403", ",", " ", "\n", 
                    "                                ", 
                    "0.0017829346135288739", ",", " ", 
                    RowBox[{"-", "2.356194490192345"}], ",", " ", 
                    RowBox[{"-", "0.06541724960872355"}], ",", " ", 
                    RowBox[{"-", "0.028650123927038106"}], ",", " ", 
                    RowBox[{"-", "0.02865012392703811"}], ",", " ", 
                    "0.6328631589929009", ",", " ", 
                    RowBox[{"-", "2.356194490192345"}], ",", " ", "\n", 
                    "                                ", 
                    RowBox[{"-", "0.04361149973914903"}], ",", " ", 
                    RowBox[{"-", "0.04108144991162291"}], ",", " ", 
                    RowBox[{"-", "0.041081449911622915"}], ",", " ", 
                    "0.6446154769172218", ",", " ", 
                    RowBox[{"-", "3.141592653589793"}], ",", " ", 
                    RowBox[{"-", "0.04361149973914903"}], ",", " ", "\n", 
                    "                                ", 
                    RowBox[{"-", "0.05809794362696811"}], ",", " ", "0", ",", 
                    " ", "0.6446154769172218"}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "0.0006335407616358708"}], ",", " ", 
                    RowBox[{"-", "0.00026242117578575974"}], ",", " ", 
                    RowBox[{"-", "0.00039261647813520735"}], ",", " ", 
                    RowBox[{"-", "0.00021627924284377937"}], ",", " ", "\n", 
                    "                                ", 
                    RowBox[{"-", "0.041081449911622915"}], ",", " ", "0.", 
                    ",", " ", "0.02648173842723176", ",", " ", 
                    "0.0170164937153452", ",", " ", "0.010969095211776154", 
                    ",", " ", "0.002386747761079582", ",", " ", "0", ",", " ",
                     "0.015421577451593893", ",", " ", "0", ",", " ", "\n", 
                    "                                ", 
                    RowBox[{"-", "0.009557025834770423"}], ",", " ", 
                    "0.005264644828969121", ",", " ", "0", ",", " ", 
                    RowBox[{"-", "0.05809794362696811"}], ",", " ", "0", ",", 
                    " ", "0.6446154769172218", ",", " ", 
                    "0.0003291617939019785", ",", " ", 
                    "0.0026316625192170685", ",", " ", "\n", 
                    "                                ", 
                    "0.001977246585205565", ",", " ", "0.0015803625774590193",
                     ",", " ", 
                    RowBox[{"-", "3.141592653589793"}], ",", " ", 
                    RowBox[{"-", "0.04361149973914903"}], ",", " ", 
                    RowBox[{"-", "0.05809794362696811"}], ",", " ", "0", ",", 
                    " ", "0.6446154769172218", ",", " ", "\n", 
                    "                                ", 
                    RowBox[{"-", "3.141592653589793"}], ",", " ", 
                    RowBox[{"-", "0.02180574986957451"}], ",", " ", 
                    RowBox[{"-", "0.06765496946173853"}], ",", " ", "0", ",", 
                    " ", "0.6600370543688157", ",", " ", 
                    RowBox[{"-", "2.356194490192345"}], ",", " ", 
                    RowBox[{"-", "0.04361149973914903"}], ",", " ", "\n", 
                    "                                ", 
                    RowBox[{"-", "0.04108144991162291"}], ",", " ", 
                    RowBox[{"-", "0.041081449911622915"}], ",", " ", 
                    "0.6446154769172218"}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "0.0007377572802997681", ",", " ", "0.000305589071239655",
                     ",", " ", "0.0004572013083451532", ",", " ", "\n", 
                    "                                ", 
                    "0.0002518568585448476", ",", " ", "0.041081449911622915",
                     ",", " ", "0.015421577451593893", ",", " ", 
                    RowBox[{"-", "0.027115279188867632"}], ",", " ", 
                    RowBox[{"-", "0.026573519550115623"}], ",", " ", 
                    RowBox[{"-", "0.016496161216531035"}], ",", " ", "\n", 
                    "                                ", 
                    RowBox[{"-", "0.0027793642392147893"}], ",", " ", 
                    RowBox[{"-", "0.006757837775741189"}], ",", " ", 
                    "0.015421577451593893", ",", " ", "0.0037226660591027534",
                     ",", " ", 
                    RowBox[{"-", "0.006757837775741189"}], ",", " ", 
                    "0.003722666059102757", ",", " ", "0.", ",", " ", "\n", 
                    "                                ", 
                    RowBox[{"-", "0.04108144991162291"}], ",", " ", 
                    RowBox[{"-", "0.041081449911622915"}], ",", " ", 
                    "0.6446154769172218", ",", " ", "0.00032916179390197846", 
                    ",", " ", "0.0026812586906176617", ",", " ", 
                    "0.0026316625192170685", ",", " ", "\n", 
                    "                                ", 
                    "0.0018403298850466385", ",", " ", 
                    RowBox[{"-", "2.356194490192345"}], ",", " ", 
                    RowBox[{"-", "0.04361149973914903"}], ",", " ", 
                    RowBox[{"-", "0.04108144991162291"}], ",", " ", 
                    RowBox[{"-", "0.041081449911622915"}], ",", " ", 
                    "0.6446154769172218", ",", " ", 
                    RowBox[{"-", "2.356194490192345"}], ",", " ", "\n", 
                    "                                ", 
                    RowBox[{"-", "0.02180574986957451"}], ",", " ", 
                    RowBox[{"-", "0.0478392876873641"}], ",", " ", 
                    RowBox[{"-", "0.047839287687364104"}], ",", " ", 
                    "0.6600370543688157", ",", " ", 
                    RowBox[{"-", "3.141592653589793"}], ",", " ", 
                    RowBox[{"-", "0.02180574986957451"}], ",", " ", 
                    RowBox[{"-", "0.06765496946173853"}], ",", " ", "\n", 
                    "                                ", "0", ",", " ", 
                    "0.6600370543688157"}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "0.0008603404557676955"}], ",", " ", 
                    RowBox[{"-", "0.00035636468503722797"}], ",", " ", 
                    RowBox[{"-", "2.1826118294997025*^-6"}], ",", " ", 
                    "0.00005676570257888815", ",", " ", 
                    RowBox[{"-", "0.047839287687364104"}], ",", " ", "0.", 
                    ",", " ", "\n", "                                ", 
                    "0.031575702528270154", ",", " ", "0.019815681774374434", 
                    ",", " ", "0.01307908422866793", ",", " ", 
                    "0.0032365655475599425", ",", " ", "0", ",", " ", 
                    "0.017983972951063354", ",", " ", "0", ",", " ", 
                    RowBox[{"-", "0.0000456238362862571"}], ",", " ", "\n", 
                    "                                ", 
                    RowBox[{"-", "0.0011865917182935365"}], ",", " ", "0", 
                    ",", " ", 
                    RowBox[{"-", "0.06765496946173853"}], ",", " ", "0", ",", 
                    " ", "0.6600370543688157", ",", " ", 
                    "0.00032342536463901583", ",", " ", 
                    "0.0030064921900990267", ",", " ", 
                    "0.0026812586906176617", ",", " ", "\n", 
                    "                                ", 
                    "0.0018624567134477475", ",", " ", 
                    RowBox[{"-", "3.141592653589793"}], ",", " ", 
                    RowBox[{"-", "0.02180574986957451"}], ",", " ", 
                    RowBox[{"-", "0.06765496946173853"}], ",", " ", "0", ",", 
                    " ", "0.6600370543688157", ",", " ", 
                    RowBox[{"-", "3.141592653589793"}], ",", " ", "0", ",", 
                    " ", "\n", "                                ", 
                    RowBox[{"-", "0.06770059329802479"}], ",", " ", "0", ",", 
                    " ", "0.678021027319879", ",", " ", 
                    RowBox[{"-", "2.356194490192345"}], ",", " ", 
                    RowBox[{"-", "0.02180574986957451"}], ",", " ", 
                    RowBox[{"-", "0.0478392876873641"}], ",", " ", 
                    RowBox[{"-", "0.047839287687364104"}], ",", " ", "\n", 
                    "                                ", 
                    "0.6600370543688157"}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "0.0008609206353526813", ",", " ", 
                    "0.0003566050032899424", ",", " ", 
                    "2.184083696615737*^-6", ",", " ", 
                    RowBox[{"-", "0.00005680398312415697"}], ",", " ", 
                    "0.047839287687364104", ",", " ", "\n", 
                    "                                ", 
                    "0.017983972951063354", ",", " ", 
                    RowBox[{"-", "0.03243604298403785"}], ",", " ", 
                    RowBox[{"-", "0.01986130561066069"}], ",", " ", 
                    RowBox[{"-", "0.01224885719541162"}], ",", " ", 
                    RowBox[{"-", "0.0032387481593894422"}], ",", " ", 
                    RowBox[{"-", "0.00003226092402176112"}], ",", " ", "\n", 
                    "                                ", 
                    "0.017983972951063354", ",", " ", 
                    RowBox[{"-", "0.0008390470505051581"}], ",", " ", 
                    RowBox[{"-", "0.00003226092402176112"}], ",", " ", 
                    RowBox[{"-", "0.0008390470505051512"}], ",", " ", "0.", 
                    ",", " ", 
                    RowBox[{"-", "0.0478392876873641"}], ",", " ", 
                    RowBox[{"-", "0.047839287687364104"}], ",", " ", "\n", 
                    "                                ", "0.6600370543688157", 
                    ",", " ", "0.00032342536463901583", ",", " ", 
                    "0.0026848761796370037", ",", " ", 
                    "0.0030064921900990267", ",", " ", 
                    "0.0018637126806126225", ",", " ", 
                    RowBox[{"-", "2.356194490192345"}], ",", " ", "\n", 
                    "                                ", 
                    RowBox[{"-", "0.02180574986957451"}], ",", " ", 
                    RowBox[{"-", "0.0478392876873641"}], ",", " ", 
                    RowBox[{"-", "0.047839287687364104"}], ",", " ", 
                    "0.6600370543688157", ",", " ", 
                    RowBox[{"-", "2.356194490192345"}], ",", " ", "0", ",", 
                    " ", 
                    RowBox[{"-", "0.04787154861138586"}], ",", " ", "\n", 
                    "                                ", 
                    RowBox[{"-", "0.047871548611385865"}], ",", " ", 
                    "0.678021027319879", ",", " ", 
                    RowBox[{"-", "3.141592653589793"}], ",", " ", "0", ",", 
                    " ", 
                    RowBox[{"-", "0.06770059329802479"}], ",", " ", "0", ",", 
                    " ", "0.678021027319879"}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "0.0009117552227386957"}], ",", " ", "\n", 
                    "                                ", 
                    RowBox[{"-", "0.000377661378822872"}], ",", " ", 
                    "0.0003226750016321464", ",", " ", 
                    "0.0002805068056190539", ",", " ", 
                    RowBox[{"-", "0.047871548611385865"}], ",", " ", "0.", 
                    ",", " ", "0.03245791656888537", ",", " ", 
                    "0.01982904468663893", ",", " ", "\n", 
                    "                                ", 
                    "0.013444509249206718", ",", " ", "0.003240932243086058", 
                    ",", " ", "0", ",", " ", "0.019045868562560853", ",", " ",
                     "0", ",", " ", "0.006740433743883535", ",", " ", 
                    RowBox[{"-", "0.00585957241317106"}], ",", " ", "0", ",", 
                    " ", 
                    RowBox[{"-", "0.06770059329802479"}], ",", " ", "0", ",", 
                    " ", "\n", "                                ", 
                    "0.678021027319879", ",", " ", "0.0004081785563580276", 
                    ",", " ", "0.00282574201216544", ",", " ", 
                    "0.0026848761796370037", ",", " ", 
                    "0.0020765787824438445", ",", " ", 
                    RowBox[{"-", "3.141592653589793"}], ",", " ", "0", ",", 
                    " ", "\n", "                                ", 
                    RowBox[{"-", "0.06770059329802479"}], ",", " ", "0", ",", 
                    " ", "0.678021027319879", ",", " ", 
                    RowBox[{"-", "3.141592653589793"}], ",", " ", 
                    "0.021805749869574537", ",", " ", 
                    RowBox[{"-", "0.060960159554141254"}], ",", " ", "0", ",",
                     " ", "0.6970668958824399", ",", " ", "\n", 
                    "                                ", 
                    RowBox[{"-", "2.356194490192345"}], ",", " ", "0", ",", 
                    " ", 
                    RowBox[{"-", "0.04787154861138586"}], ",", " ", 
                    RowBox[{"-", "0.047871548611385865"}], ",", " ", 
                    "0.678021027319879"}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "0.000820978681941538", ",", " ", "0.0003400605044793746",
                     ",", " ", "\n", "                                ", 
                    RowBox[{"-", "0.00029054870312639246"}], ",", " ", 
                    RowBox[{"-", "0.00025257887403268785"}], ",", " ", 
                    "0.047871548611385865", ",", " ", "0.019045868562560853", 
                    ",", " ", 
                    RowBox[{"-", "0.03336967179162407"}], ",", " ", 
                    RowBox[{"-", "0.013088610942755395"}], ",", " ", "\n", 
                    "                                ", 
                    RowBox[{"-", "0.007962598214858528"}], ",", " ", 
                    RowBox[{"-", "0.0029182572414539116"}], ",", " ", 
                    "0.004766206408438681", ",", " ", "0.019045868562560853", 
                    ",", " ", 
                    RowBox[{"-", "0.0041433433882068806"}], ",", " ", 
                    "0.004766206408438681", ",", " ", "\n", 
                    "                                ", 
                    RowBox[{"-", "0.0041433433882068806"}], ",", " ", "0.", 
                    ",", " ", 
                    RowBox[{"-", "0.04787154861138586"}], ",", " ", 
                    RowBox[{"-", "0.047871548611385865"}], ",", " ", 
                    "0.678021027319879", ",", " ", "0.0004081785563580277", 
                    ",", " ", "0.002176865029077681", ",", " ", "\n", 
                    "                                ", "0.00282574201216544",
                     ",", " ", "0.0018698296091330482", ",", " ", 
                    RowBox[{"-", "2.356194490192345"}], ",", " ", "0", ",", 
                    " ", 
                    RowBox[{"-", "0.04787154861138586"}], ",", " ", 
                    RowBox[{"-", "0.047871548611385865"}], ",", " ", 
                    "0.678021027319879", ",", " ", "\n", 
                    "                                ", 
                    RowBox[{"-", "2.356194490192345"}], ",", " ", 
                    "0.021805749869574537", ",", " ", 
                    RowBox[{"-", "0.04310534220294718"}], ",", " ", 
                    RowBox[{"-", "0.043105342202947185"}], ",", " ", 
                    "0.6970668958824399", ",", " ", 
                    RowBox[{"-", "3.141592653589793"}], ",", " ", 
                    "0.021805749869574537", ",", " ", "\n", 
                    "                                ", 
                    RowBox[{"-", "0.060960159554141254"}], ",", " ", "0", ",",
                     " ", "0.6970668958824399"}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "0.0007872471687269574"}], ",", " ", 
                    RowBox[{"-", "0.0003260884542265292"}], ",", " ", 
                    "0.00044499526160833277", ",", " ", 
                    "0.00035818217870585596", ",", " ", "\n", 
                    "                                ", 
                    RowBox[{"-", "0.043105342202947185"}], ",", " ", "0.", 
                    ",", " ", "0.030047307085358726", ",", " ", 
                    "0.017854817351194076", ",", " ", "0.012446002107544783", 
                    ",", " ", "0.002627708538327519", ",", " ", "0", ",", " ",
                     "0.018263331839948438", ",", " ", "0", ",", " ", "\n", 
                    "                                ", 
                    "0.010323436466719606", ",", " ", 
                    RowBox[{"-", "0.008309461435649299"}], ",", " ", "0", ",",
                     " ", 
                    RowBox[{"-", "0.060960159554141254"}], ",", " ", "0", ",",
                     " ", "0.6970668958824399", ",", " ", 
                    "0.0004401226303784706", ",", " ", 
                    "0.0022483415143562816", ",", " ", "\n", 
                    "                                ", 
                    "0.002176865029077681", ",", " ", "0.0019226154763782863",
                     ",", " ", 
                    RowBox[{"-", "3.141592653589793"}], ",", " ", 
                    "0.021805749869574537", ",", " ", 
                    RowBox[{"-", "0.060960159554141254"}], ",", " ", "0", ",",
                     " ", "0.6970668958824399", ",", " ", "\n", 
                    "                                ", 
                    RowBox[{"-", "3.141592653589793"}], ",", " ", 
                    "0.04361149973914906", ",", " ", 
                    RowBox[{"-", "0.05063672308742165"}], ",", " ", "0", ",", 
                    " ", "0.7153302277223883", ",", " ", 
                    RowBox[{"-", "2.356194490192345"}], ",", " ", 
                    "0.021805749869574537", ",", " ", 
                    RowBox[{"-", "0.04310534220294718"}], ",", " ", "\n", 
                    "                                ", 
                    RowBox[{"-", "0.043105342202947185"}], ",", " ", 
                    "0.6970668958824399"}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "0.0006539290115994377", ",", " ", 
                    "0.00027086626543372516", ",", " ", 
                    RowBox[{"-", "0.0003696365298595269"}], ",", " ", 
                    RowBox[{"-", "0.00029752500535812105"}], ",", " ", "\n", 
                    "                                ", 
                    "0.043105342202947185", ",", " ", "0.018263331839948438", 
                    ",", " ", 
                    RowBox[{"-", "0.030834554254085683"}], ",", " ", 
                    RowBox[{"-", "0.00753138088447447"}], ",", " ", 
                    RowBox[{"-", "0.004462629126122008"}], ",", " ", 
                    RowBox[{"-", "0.0021827132767191864"}], ",", " ", "\n", 
                    "                                ", 
                    "0.007299771930765926", ",", " ", "0.018263331839948438", 
                    ",", " ", 
                    RowBox[{"-", "0.005875676529155726"}], ",", " ", 
                    "0.007299771930765919", ",", " ", 
                    RowBox[{"-", "0.0058756765291557225"}], ",", " ", 
                    RowBox[{"-", "2.168404344971009*^-19"}], ",", " ", "\n", 
                    "                                ", 
                    RowBox[{"-", "0.04310534220294718"}], ",", " ", 
                    RowBox[{"-", "0.043105342202947185"}], ",", " ", 
                    "0.6970668958824399", ",", " ", "0.0004401226303784705", 
                    ",", " ", "0.0015020019563451233", ",", " ", 
                    "0.0022483415143562816", ",", " ", "\n", 
                    "                                ", 
                    "0.001597025798373995", ",", " ", 
                    RowBox[{"-", "2.356194490192345"}], ",", " ", 
                    "0.021805749869574537", ",", " ", 
                    RowBox[{"-", "0.04310534220294718"}], ",", " ", 
                    RowBox[{"-", "0.043105342202947185"}], ",", " ", 
                    "0.6970668958824399", ",", " ", 
                    RowBox[{"-", "2.356194490192345"}], ",", " ", "\n", 
                    "                                ", "0.04361149973914906",
                     ",", " ", 
                    RowBox[{"-", "0.03580557027218126"}], ",", " ", 
                    RowBox[{"-", "0.03580557027218126"}], ",", " ", 
                    "0.7153302277223883", ",", " ", 
                    RowBox[{"-", "3.141592653589793"}], ",", " ", 
                    "0.04361149973914906", ",", " ", 
                    RowBox[{"-", "0.05063672308742165"}], ",", " ", "\n", 
                    "                                ", "0", ",", " ", 
                    "0.7153302277223883"}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "0.0005538113768028229"}], ",", " ", 
                    RowBox[{"-", "0.0002293961832682441"}], ",", " ", 
                    "0.0004780667427576441", ",", " ", 
                    "0.00037001878529315413", ",", " ", 
                    RowBox[{"-", "0.03580557027218126"}], ",", " ", "0.", ",",
                     " ", "\n", "                                ", 
                    "0.025612806736529395", ",", " ", "0.01483115281524039", 
                    ",", " ", "0.010609171920711452", ",", " ", 
                    "0.001813076746859659", ",", " ", "0", ",", " ", 
                    "0.015467184926617361", ",", " ", "0", ",", " ", 
                    "0.013351742176525891", ",", " ", "\n", 
                    "                                ", 
                    RowBox[{"-", "0.010334112331695944"}], ",", " ", "0", ",",
                     " ", 
                    RowBox[{"-", "0.05063672308742165"}], ",", " ", "0", ",", 
                    " ", "0.7153302277223883", ",", " ", 
                    "0.00041750282870259964", ",", " ", 
                    "0.0015234613279082312", ",", " ", 
                    "0.0015020019563451233", ",", " ", "\n", 
                    "                                ", 
                    "0.0015334633487699373", ",", " ", 
                    RowBox[{"-", "3.141592653589793"}], ",", " ", 
                    "0.04361149973914906", ",", " ", 
                    RowBox[{"-", "0.05063672308742165"}], ",", " ", "0", ",", 
                    " ", "0.7153302277223883", ",", " ", 
                    RowBox[{"-", "3.141592653589793"}], ",", " ", 
                    "0.06541724960872358", ",", " ", "\n", 
                    "                                ", 
                    RowBox[{"-", "0.03728498091089576"}], ",", " ", "0", ",", 
                    " ", "0.7307974126490057", ",", " ", 
                    RowBox[{"-", "2.356194490192345"}], ",", " ", 
                    "0.04361149973914906", ",", " ", 
                    RowBox[{"-", "0.03580557027218126"}], ",", " ", 
                    RowBox[{"-", "0.03580557027218126"}], ",", " ", "\n", 
                    "                                ", 
                    "0.7153302277223883"}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "0.000407784022214093", ",", " ", 
                    "0.00016890967252013167", ",", " ", 
                    RowBox[{"-", "0.0003520115104423218"}], ",", " ", 
                    RowBox[{"-", "0.00027245332053793807"}], ",", " ", 
                    "0.03580557027218126", ",", " ", "\n", 
                    "                                ", 
                    "0.015467184926617361", ",", " ", 
                    RowBox[{"-", "0.026166618113332218"}], ",", " ", 
                    RowBox[{"-", "0.0014794106387144984"}], ",", " ", 
                    RowBox[{"-", "0.0005044557722837448"}], ",", " ", 
                    RowBox[{"-", "0.001335010004102015"}], ",", " ", 
                    "0.009441107433675891", ",", " ", "\n", 
                    "                                ", 
                    "0.015467184926617361", ",", " ", 
                    RowBox[{"-", "0.007307320907285728"}], ",", " ", 
                    "0.009441107433675894", ",", " ", 
                    RowBox[{"-", "0.007307320907285732"}], ",", " ", 
                    "1.0842021724855044*^-19", ",", " ", 
                    RowBox[{"-", "0.03580557027218126"}], ",", " ", "\n", 
                    "                                ", 
                    RowBox[{"-", "0.03580557027218126"}], ",", " ", 
                    "0.7153302277223883", ",", " ", "0.0004175028287025997", 
                    ",", " ", "0.0008143426157323357", ",", " ", 
                    "0.0015234613279082312", ",", " ", 
                    "0.0011291242442315133", ",", " ", "\n", 
                    "                                ", 
                    RowBox[{"-", "2.356194490192345"}], ",", " ", 
                    "0.04361149973914906", ",", " ", 
                    RowBox[{"-", "0.03580557027218126"}], ",", " ", 
                    RowBox[{"-", "0.03580557027218126"}], ",", " ", 
                    "0.7153302277223883", ",", " ", 
                    RowBox[{"-", "2.356194490192345"}], ",", " ", 
                    "0.06541724960872358", ",", " ", "\n", 
                    "                                ", 
                    RowBox[{"-", "0.026364462838505364"}], ",", " ", 
                    RowBox[{"-", "0.026364462838505368"}], ",", " ", 
                    "0.7307974126490057", ",", " ", 
                    RowBox[{"-", "3.141592653589793"}], ",", " ", 
                    "0.06541724960872358", ",", " ", 
                    RowBox[{"-", "0.03728498091089576"}], ",", " ", "0", ",", 
                    " ", "\n", "                                ", 
                    "0.7307974126490057"}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "0.00028402382658134287"}], ",", " ", 
                    RowBox[{"-", "0.00011764652100709847"}], ",", " ", 
                    "0.00045384687913854727", ",", " ", 
                    "0.0003422599479656013", ",", " ", 
                    RowBox[{"-", "0.026364462838505368"}], ",", " ", "0.", 
                    ",", " ", "\n", "                                ", 
                    "0.019267081228260582", ",", " ", "0.010920518072390393", 
                    ",", " ", "0.007980686352089608", ",", " ", 
                    "0.000982998493659693", ",", " ", "0", ",", " ", 
                    "0.010772979837333385", ",", " ", "0", ",", " ", 
                    "0.01721434196928537", ",", " ", "\n", 
                    "                                ", 
                    RowBox[{"-", "0.012981866919197374"}], ",", " ", "0", ",",
                     " ", 
                    RowBox[{"-", "0.03728498091089576"}], ",", " ", "0", ",", 
                    " ", "0.7307974126490057", ",", " ", 
                    "0.0004123906640110913", ",", " ", 
                    "0.0008507542145836484", ",", " ", 
                    "0.0008143426157323357", ",", " ", "\n", 
                    "                                ", 
                    "0.001096334306085113", ",", " ", 
                    RowBox[{"-", "3.141592653589793"}], ",", " ", 
                    "0.06541724960872358", ",", " ", 
                    RowBox[{"-", "0.03728498091089576"}], ",", " ", "0", ",", 
                    " ", "0.7307974126490057", ",", " ", 
                    RowBox[{"-", "3.141592653589793"}], ",", " ", 
                    "0.0872229994782981", ",", " ", "\n", 
                    "                                ", 
                    RowBox[{"-", "0.02007063894161039"}], ",", " ", "0", ",", 
                    " ", "0.741570392486339", ",", " ", 
                    RowBox[{"-", "2.356194490192345"}], ",", " ", 
                    "0.06541724960872358", ",", " ", 
                    RowBox[{"-", "0.026364462838505364"}], ",", " ", 
                    RowBox[{"-", "0.026364462838505368"}], ",", " ", "\n", 
                    "                                ", 
                    "0.7307974126490057"}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "0.0001528910444597506", ",", " ", 
                    "0.00006332954418061722", ",", " ", 
                    RowBox[{"-", "0.00024430740269749094"}], ",", " ", 
                    RowBox[{"-", "0.00018423975745645384"}], ",", " ", 
                    "0.026364462838505368", ",", " ", "\n", 
                    "                                ", 
                    "0.010772979837333385", ",", " ", 
                    RowBox[{"-", "0.019551105054841925"}], ",", " ", 
                    "0.006293823896894975", ",", " ", "0.004883534046100672", 
                    ",", " ", 
                    RowBox[{"-", "0.0005291516145211458"}], ",", " ", 
                    "0.012172377940145869", ",", " ", "\n", 
                    "                                ", 
                    "0.010772979837333385", ",", " ", 
                    RowBox[{"-", "0.009179566131025777"}], ",", " ", 
                    "0.012172377940145869", ",", " ", 
                    RowBox[{"-", "0.009179566131025777"}], ",", " ", "0.", 
                    ",", " ", 
                    RowBox[{"-", "0.026364462838505364"}], ",", " ", 
                    RowBox[{"-", "0.026364462838505368"}], ",", " ", "\n", 
                    "                                ", "0.7307974126490057", 
                    ",", " ", "0.00041239066401109123", ",", " ", 
                    "0.00023597267140166515", ",", " ", 
                    "0.0008507542145836484", ",", " ", 
                    "0.0005901606888125033", ",", " ", 
                    RowBox[{"-", "2.356194490192345"}], ",", " ", "\n", 
                    "                                ", "0.06541724960872358",
                     ",", " ", 
                    RowBox[{"-", "0.026364462838505364"}], ",", " ", 
                    RowBox[{"-", "0.026364462838505368"}], ",", " ", 
                    "0.7307974126490057", ",", " ", 
                    RowBox[{"-", "2.356194490192345"}], ",", " ", 
                    "0.0872229994782981", ",", " ", 
                    RowBox[{"-", "0.014192084898359495"}], ",", " ", "\n", 
                    "                                ", 
                    RowBox[{"-", "0.014192084898359499"}], ",", " ", 
                    "0.741570392486339", ",", " ", 
                    RowBox[{"-", "3.141592653589793"}], ",", " ", 
                    "0.0872229994782981", ",", " ", 
                    RowBox[{"-", "0.02007063894161039"}], ",", " ", "0", ",", 
                    " ", "0.741570392486339"}], "}"}], ",", " ", "\n", 
                    "                               ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "0.00006570344923224371"}], ",", " ", 
                    RowBox[{"-", "0.000027215259766686165"}], ",", " ", 
                    "0.0002848442118236549", ",", " ", 
                    "0.00021255074416628842", ",", " ", 
                    RowBox[{"-", "0.014192084898359499"}], ",", " ", "0.", 
                    ",", " ", "0.010524429968275899", ",", " ", "\n", 
                    "                                ", 
                    "0.0058785540432508936", ",", " ", 
                    "0.0043593616291057215", ",", " ", 
                    "0.0002848442118236549", ",", " ", "0", ",", " ", 
                    "0.00462958400423874", ",", " ", "0", ",", " ", 
                    "0.02007063894161039", ",", " ", 
                    RowBox[{"-", "0.014976710306380547"}], ",", " ", "0", ",",
                     " ", "\n", "                                ", 
                    RowBox[{"-", "0.02007063894161039"}], ",", " ", "0", ",", 
                    " ", "0.741570392486339", ",", " ", 
                    "0.00042426359557679055", ",", " ", 
                    "0.0004242635955767906", ",", " ", 
                    "0.00023597267140166515", ",", " ", 
                    "0.000587175744099231", ",", " ", "\n", 
                    "                                ", 
                    RowBox[{"-", "3.141592653589793"}], ",", " ", 
                    "0.0872229994782981", ",", " ", 
                    RowBox[{"-", "0.02007063894161039"}], ",", " ", "0", ",", 
                    " ", "0.741570392486339", ",", " ", 
                    RowBox[{"-", "3.141592653589793"}], ",", " ", 
                    "0.10902874934787263", ",", " ", "0", ",", " ", "0", ",", 
                    " ", "\n", "                                ", 
                    "0.7461999764905778", ",", " ", 
                    RowBox[{"-", "2.356194490192345"}], ",", " ", 
                    "0.0872229994782981", ",", " ", 
                    RowBox[{"-", "0.014192084898359495"}], ",", " ", 
                    RowBox[{"-", "0.014192084898359499"}], ",", " ", 
                    "0.741570392486339"}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "0.", ",", " ", "0.", ",", " ", "0", ",", " ", "0", ",", 
                    " ", "\n", "                                ", 
                    "0.014192084898359499", ",", " ", "0.00462958400423874", 
                    ",", " ", 
                    RowBox[{"-", "0.010590133417508142"}], ",", " ", 
                    "0.014192084898359495", ",", " ", "0.010590133417508139", 
                    ",", " ", "0", ",", " ", "0.014192084898359499", ",", " ",
                     "\n", "                                ", 
                    "0.00462958400423874", ",", " ", 
                    RowBox[{"-", "0.010590133417508142"}], ",", " ", 
                    "0.014192084898359495", ",", " ", 
                    RowBox[{"-", "0.010590133417508139"}], ",", " ", "0", ",",
                     " ", 
                    RowBox[{"-", "0.014192084898359495"}], ",", " ", 
                    RowBox[{"-", "0.014192084898359499"}], ",", " ", "\n", 
                    "                                ", "0.741570392486339", 
                    ",", " ", "0.0004242635955767906", ",", " ", "0.", ",", 
                    " ", "0.0004242635955767906", ",", " ", "0.", ",", " ", 
                    RowBox[{"-", "2.356194490192345"}], ",", " ", 
                    "0.0872229994782981", ",", " ", 
                    RowBox[{"-", "0.014192084898359495"}], ",", " ", "\n", 
                    "                                ", 
                    RowBox[{"-", "0.014192084898359499"}], ",", " ", 
                    "0.741570392486339", ",", " ", 
                    RowBox[{"-", "2.356194490192345"}], ",", " ", 
                    "0.10902874934787263", ",", " ", "0", ",", " ", "0", ",", 
                    " ", "0.7461999764905778", ",", " ", 
                    RowBox[{"-", "3.141592653589793"}], ",", " ", 
                    "0.10902874934787263", ",", " ", "\n", 
                    "                                ", "0", ",", " ", "0", 
                    ",", " ", "0.7461999764905778"}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "0.", ",", " ", "0.", ",", " ", "0", ",", " ", "0", ",", 
                    " ", "0", ",", " ", "0.", ",", " ", "0", ",", " ", "0", 
                    ",", " ", "0", ",", " ", "0", ",", " ", 
                    RowBox[{"-", "0.014051862724930291"}], ",", " ", 
                    "0.0024195679317141616", ",", " ", "0.008755956665157808",
                     ",", " ", "\n", "                                ", 
                    RowBox[{"-", "0.01405186272493029"}], ",", " ", 
                    "0.008755956665157806", ",", " ", "0", ",", " ", "0", ",",
                     " ", "0", ",", " ", "0.6231171508403164", ",", " ", 
                    "0.00040076400105675024", ",", " ", 
                    "0.00040076400105675024", ",", " ", "0.", ",", " ", "0.", 
                    ",", " ", 
                    RowBox[{"-", "2.356194490192345"}], ",", " ", "\n", 
                    "                                ", 
                    RowBox[{"-", "0.1090287493478726"}], ",", " ", "0", ",", 
                    " ", "0", ",", " ", "0.6231171508403164", ",", " ", 
                    RowBox[{"-", "2.356194490192345"}], ",", " ", 
                    RowBox[{"-", "0.08722299947829808"}], ",", " ", 
                    RowBox[{"-", "0.01405186272493029"}], ",", " ", 
                    RowBox[{"-", "0.014051862724930291"}], ",", " ", "\n", 
                    "                                ", "0.6255367187720305", 
                    ",", " ", 
                    RowBox[{"-", "1.5707963267948966"}], ",", " ", 
                    RowBox[{"-", "0.1090287493478726"}], ",", " ", "0", ",", 
                    " ", "0", ",", " ", "0.6231171508403164"}], "}"}], ",", 
                    " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "0.000014083027682386569", ",", " ", 
                    "0.000033999436430091554", ",", " ", "\n", 
                    "                                ", 
                    "0.0002792433212264629", ",", " ", 
                    "0.0001740013027138208", ",", " ", 
                    RowBox[{"-", "0.014051862724930291"}], ",", " ", 
                    "0.0024195679317141616", ",", " ", "0.008755956665157808",
                     ",", " ", 
                    RowBox[{"-", "0.01405186272493029"}], ",", " ", "\n", 
                    "                                ", 
                    RowBox[{"-", "0.008755956665157806"}], ",", " ", "0", ",",
                     " ", 
                    RowBox[{"-", "0.019872334842201373"}], ",", " ", 
                    "0.0024195679317141616", ",", " ", "0.012382792667417267",
                     ",", " ", "0", ",", " ", "0", ",", " ", "0", ",", " ", 
                    "0", ",", " ", "0", ",", " ", "0.6231171508403164", ",", 
                    " ", "\n", "                                ", 
                    "0.00040076400105675024", ",", " ", 
                    "0.00023133274170821544", ",", " ", 
                    "0.00040076400105675024", ",", " ", 
                    "0.0005633156337111625", ",", " ", 
                    RowBox[{"-", "1.5707963267948966"}], ",", " ", 
                    RowBox[{"-", "0.1090287493478726"}], ",", " ", "0", ",", 
                    " ", "0", ",", " ", "\n", 
                    "                                ", "0.6231171508403164", 
                    ",", " ", 
                    RowBox[{"-", "1.5707963267948966"}], ",", " ", 
                    RowBox[{"-", "0.08722299947829808"}], ",", " ", "0", ",", 
                    " ", 
                    RowBox[{"-", "0.019872334842201373"}], ",", " ", 
                    "0.6255367187720305", ",", " ", 
                    RowBox[{"-", "2.356194490192345"}], ",", " ", "\n", 
                    "                                ", 
                    RowBox[{"-", "0.08722299947829808"}], ",", " ", 
                    RowBox[{"-", "0.01405186272493029"}], ",", " ", 
                    RowBox[{"-", "0.014051862724930291"}], ",", " ", 
                    "0.6255367187720305"}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "0.000042643341024429376"}], ",", " ", 
                    RowBox[{"-", "0.00010295013224607963"}], ",", " ", "\n", 
                    "                                ", 
                    RowBox[{"-", "0.0002901015347222037"}], ",", " ", 
                    RowBox[{"-", "0.00017942330264081454"}], ",", " ", 
                    RowBox[{"-", "0.005820472117271082"}], ",", " ", "0.", 
                    ",", " ", "0.003640919029941847", ",", " ", 
                    "0.01405186272493029", ",", " ", "0.008789956101587898", 
                    ",", " ", "\n", "                                ", 
                    "0.0002792433212264629", ",", " ", 
                    RowBox[{"-", "0.014598261202107818"}], ",", " ", 
                    "0.007326440220870367", ",", " ", "0.009028798279897483", 
                    ",", " ", 
                    RowBox[{"-", "0.014598261202107816"}], ",", " ", 
                    "0.009028798279897485", ",", " ", "0.", ",", " ", "\n", 
                    "                                ", 
                    RowBox[{"-", "0.01405186272493029"}], ",", " ", 
                    RowBox[{"-", "0.014051862724930291"}], ",", " ", 
                    "0.6255367187720305", ",", " ", "0.0004798951865599198", 
                    ",", " ", "0.0009515559085625073", ",", " ", 
                    "0.00023133274170821544", ",", " ", "\n", 
                    "                                ", 
                    "0.0006215338597739909", ",", " ", 
                    RowBox[{"-", "2.356194490192345"}], ",", " ", 
                    RowBox[{"-", "0.08722299947829808"}], ",", " ", 
                    RowBox[{"-", "0.01405186272493029"}], ",", " ", 
                    RowBox[{"-", "0.014051862724930291"}], ",", " ", 
                    "0.6255367187720305", ",", " ", 
                    RowBox[{"-", "2.356194490192345"}], ",", " ", "\n", 
                    "                                ", 
                    RowBox[{"-", "0.06541724960872355"}], ",", " ", 
                    RowBox[{"-", "0.028650123927038106"}], ",", " ", 
                    RowBox[{"-", "0.02865012392703811"}], ",", " ", 
                    "0.6328631589929009", ",", " ", 
                    RowBox[{"-", "1.5707963267948966"}], ",", " ", 
                    RowBox[{"-", "0.08722299947829808"}], ",", " ", "0", ",", 
                    " ", "\n", "                                ", 
                    RowBox[{"-", "0.019872334842201373"}], ",", " ", 
                    "0.6255367187720305"}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "0.00008694484346514781", ",", " ", 
                    "0.00020990342027197087", ",", " ", "0.00059148349823182",
                     ",", " ", "0.0003658233756395669", ",", " ", "\n", 
                    "                                ", 
                    RowBox[{"-", "0.008777789084836736"}], ",", " ", 
                    "0.007326440220870367", ",", " ", "0.005345235908931208", 
                    ",", " ", 
                    RowBox[{"-", "0.028650123927038106"}], ",", " ", 
                    RowBox[{"-", "0.01792170451373146"}], ",", " ", 
                    RowBox[{"-", "0.0005693448559486666"}], ",", " ", "\n", 
                    "                                ", 
                    RowBox[{"-", "0.020645058979085838"}], ",", " ", 
                    "0.007326440220870367", ",", " ", "0.012768648979361894", 
                    ",", " ", "0", ",", " ", "0", ",", " ", "0", ",", " ", 
                    "0", ",", " ", 
                    RowBox[{"-", "0.019872334842201373"}], ",", " ", 
                    "0.6255367187720305", ",", " ", "0.0004798951865599198", 
                    ",", " ", "\n", "                                ", 
                    "0.0009616616957775924", ",", " ", 
                    "0.0009515559085625073", ",", " ", 
                    "0.0012672357007717282", ",", " ", 
                    RowBox[{"-", "1.5707963267948966"}], ",", " ", 
                    RowBox[{"-", "0.08722299947829808"}], ",", " ", "0", ",", 
                    " ", 
                    RowBox[{"-", "0.019872334842201373"}], ",", " ", "\n", 
                    "                                ", "0.6255367187720305", 
                    ",", " ", 
                    RowBox[{"-", "1.5707963267948966"}], ",", " ", 
                    RowBox[{"-", "0.06541724960872355"}], ",", " ", "0", ",", 
                    " ", 
                    RowBox[{"-", "0.04051739382128721"}], ",", " ", 
                    "0.6328631589929009", ",", " ", 
                    RowBox[{"-", "2.356194490192345"}], ",", " ", 
                    RowBox[{"-", "0.06541724960872355"}], ",", " ", "\n", 
                    "                                ", 
                    RowBox[{"-", "0.028650123927038106"}], ",", " ", 
                    RowBox[{"-", "0.02865012392703811"}], ",", " ", 
                    "0.6328631589929009"}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "0.00013946792869093822"}], ",", " ", 
                    RowBox[{"-", "0.0003367053649617445"}], ",", " ", 
                    RowBox[{"-", "0.0005036849306382237"}], ",", " ", "\n", 
                    "                                ", 
                    RowBox[{"-", "0.000305121212466931"}], ",", " ", 
                    RowBox[{"-", "0.011867269894249102"}], ",", " ", "0.", 
                    ",", " ", "0.007510357913895833", ",", " ", 
                    "0.028650123927038106", ",", " ", "0.01813160793400343", 
                    ",", " ", "0.0011608283541804866", ",", " ", "\n", 
                    "                                ", 
                    RowBox[{"-", "0.012431325984584806"}], ",", " ", 
                    "0.011752317924320854", ",", " ", "0.007530622868113131", 
                    ",", " ", 
                    RowBox[{"-", "0.012431325984584803"}], ",", " ", 
                    "0.007530622868113127", ",", " ", "0.", ",", " ", 
                    RowBox[{"-", "0.028650123927038106"}], ",", " ", "\n", 
                    "                                ", 
                    RowBox[{"-", "0.02865012392703811"}], ",", " ", 
                    "0.6328631589929009", ",", " ", "0.0004471927080643399", 
                    ",", " ", "0.0018261206627085398", ",", " ", 
                    "0.0009616616957775924", ",", " ", 
                    "0.0012434151604020164", ",", " ", "\n", 
                    "                                ", 
                    RowBox[{"-", "2.356194490192345"}], ",", " ", 
                    RowBox[{"-", "0.06541724960872355"}], ",", " ", 
                    RowBox[{"-", "0.028650123927038106"}], ",", " ", 
                    RowBox[{"-", "0.02865012392703811"}], ",", " ", 
                    "0.6328631589929009", ",", " ", 
                    RowBox[{"-", "2.356194490192345"}], ",", " ", 
                    RowBox[{"-", "0.04361149973914903"}], ",", " ", "\n", 
                    "                                ", 
                    RowBox[{"-", "0.04108144991162291"}], ",", " ", 
                    RowBox[{"-", "0.041081449911622915"}], ",", " ", 
                    "0.6446154769172218", ",", " ", 
                    RowBox[{"-", "1.5707963267948966"}], ",", " ", 
                    RowBox[{"-", "0.06541724960872355"}], ",", " ", "0", ",", 
                    " ", 
                    RowBox[{"-", "0.04051739382128721"}], ",", " ", "\n", 
                    "                                ", 
                    "0.6328631589929009"}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "0.00019998324409994592", ",", " ", 
                    "0.00048280226015345526", ",", " ", 
                    "0.0007222344762608714", ",", " ", 
                    "0.0004375137028675934", ",", " ", 
                    RowBox[{"-", "0.0005640560903357045"}], ",", " ", "\n", 
                    "                                ", 
                    "0.011752317924320854", ",", " ", 
                    RowBox[{"-", "0.00011920297447364295"}], ",", " ", 
                    RowBox[{"-", "0.04108144991162291"}], ",", " ", 
                    RowBox[{"-", "0.025998936167078303"}], ",", " ", 
                    RowBox[{"-", "0.0016645132848187101"}], ",", " ", 
                    RowBox[{"-", "0.017580549805680898"}], ",", " ", "\n", 
                    "                                ", 
                    "0.011752317924320854", ",", " ", "0.010649908993202561", 
                    ",", " ", "0", ",", " ", "0", ",", " ", "0", ",", " ", 
                    "0", ",", " ", 
                    RowBox[{"-", "0.04051739382128721"}], ",", " ", 
                    "0.6328631589929009", ",", " ", "0.00044719270806433986", 
                    ",", " ", "0.0019772465852055643", ",", " ", "\n", 
                    "                                ", 
                    "0.0018261206627085398", ",", " ", 
                    "0.0017829346135288737", ",", " ", 
                    RowBox[{"-", "1.5707963267948966"}], ",", " ", 
                    RowBox[{"-", "0.06541724960872355"}], ",", " ", "0", ",", 
                    " ", 
                    RowBox[{"-", "0.04051739382128721"}], ",", " ", 
                    "0.6328631589929009", ",", " ", "\n", 
                    "                                ", 
                    RowBox[{"-", "1.5707963267948966"}], ",", " ", 
                    RowBox[{"-", "0.04361149973914903"}], ",", " ", "0", ",", 
                    " ", 
                    RowBox[{"-", "0.05809794362696811"}], ",", " ", 
                    "0.6446154769172218", ",", " ", 
                    RowBox[{"-", "2.356194490192345"}], ",", " ", 
                    RowBox[{"-", "0.04361149973914903"}], ",", " ", "\n", 
                    "                                ", 
                    RowBox[{"-", "0.04108144991162291"}], ",", " ", 
                    RowBox[{"-", "0.041081449911622915"}], ",", " ", 
                    "0.6446154769172218"}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "0.00026242117578575974"}], ",", " ", 
                    RowBox[{"-", "0.0006335407616358674"}], ",", " ", 
                    RowBox[{"-", "0.00039261647813520735"}], ",", " ", "\n", 
                    "                                ", 
                    RowBox[{"-", "0.00021627924284377948"}], ",", " ", 
                    RowBox[{"-", "0.017016493715345193"}], ",", " ", "0.", 
                    ",", " ", "0.01096909521177615", ",", " ", 
                    "0.04108144991162291", ",", " ", "0.026481738427231758", 
                    ",", " ", "0.0023867477610795816", ",", " ", "\n", 
                    "                                ", 
                    RowBox[{"-", "0.006757837775741189"}], ",", " ", 
                    "0.015421577451593893", ",", " ", "0.0037226660591027534",
                     ",", " ", 
                    RowBox[{"-", "0.006757837775741189"}], ",", " ", 
                    "0.003722666059102757", ",", " ", "0.", ",", " ", 
                    RowBox[{"-", "0.04108144991162291"}], ",", " ", "\n", 
                    "                                ", 
                    RowBox[{"-", "0.041081449911622915"}], ",", " ", 
                    "0.6446154769172218", ",", " ", "0.00032916179390197846", 
                    ",", " ", "0.0026316625192170677", ",", " ", 
                    "0.0019772465852055643", ",", " ", 
                    "0.0015803625774590188", ",", " ", "\n", 
                    "                                ", 
                    RowBox[{"-", "2.356194490192345"}], ",", " ", 
                    RowBox[{"-", "0.04361149973914903"}], ",", " ", 
                    RowBox[{"-", "0.04108144991162291"}], ",", " ", 
                    RowBox[{"-", "0.041081449911622915"}], ",", " ", 
                    "0.6446154769172218", ",", " ", 
                    RowBox[{"-", "2.356194490192345"}], ",", " ", 
                    RowBox[{"-", "0.02180574986957451"}], ",", " ", "\n", 
                    "                                ", 
                    RowBox[{"-", "0.0478392876873641"}], ",", " ", 
                    RowBox[{"-", "0.047839287687364104"}], ",", " ", 
                    "0.6600370543688157", ",", " ", 
                    RowBox[{"-", "1.5707963267948966"}], ",", " ", 
                    RowBox[{"-", "0.04361149973914903"}], ",", " ", "0", ",", 
                    " ", 
                    RowBox[{"-", "0.05809794362696811"}], ",", " ", "\n", 
                    "                                ", 
                    "0.6446154769172218"}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "0.00030558907123965154", ",", " ", 
                    "0.0007377572802997646", ",", " ", 
                    "0.0004572013083451532", ",", " ", 
                    "0.0002518568585448478", ",", " ", "0.010258655939604004",
                     ",", " ", "\n", "                                ", 
                    "0.015421577451593893", ",", " ", 
                    RowBox[{"-", "0.007508850328459153"}], ",", " ", 
                    RowBox[{"-", "0.0478392876873641"}], ",", " ", 
                    RowBox[{"-", "0.030837945247970382"}], ",", " ", 
                    RowBox[{"-", "0.002779364239214789"}], ",", " ", 
                    RowBox[{"-", "0.009557025834770423"}], ",", " ", "\n", 
                    "                                ", 
                    "0.015421577451593893", ",", " ", "0.005264644828969121", 
                    ",", " ", "0", ",", " ", "0", ",", " ", "0", ",", " ", 
                    "0", ",", " ", 
                    RowBox[{"-", "0.05809794362696811"}], ",", " ", 
                    "0.6446154769172218", ",", " ", "0.0003291617939019785", 
                    ",", " ", "0.0026812586906176613", ",", " ", "\n", 
                    "                                ", 
                    "0.0026316625192170677", ",", " ", 
                    "0.0018403298850466381", ",", " ", 
                    RowBox[{"-", "1.5707963267948966"}], ",", " ", 
                    RowBox[{"-", "0.04361149973914903"}], ",", " ", "0", ",", 
                    " ", 
                    RowBox[{"-", "0.05809794362696811"}], ",", " ", 
                    "0.6446154769172218", ",", " ", "\n", 
                    "                                ", 
                    RowBox[{"-", "1.5707963267948966"}], ",", " ", 
                    RowBox[{"-", "0.02180574986957451"}], ",", " ", "0", ",", 
                    " ", 
                    RowBox[{"-", "0.06765496946173853"}], ",", " ", 
                    "0.6600370543688157", ",", " ", 
                    RowBox[{"-", "2.356194490192345"}], ",", " ", 
                    RowBox[{"-", "0.02180574986957451"}], ",", " ", "\n", 
                    "                                ", 
                    RowBox[{"-", "0.0478392876873641"}], ",", " ", 
                    RowBox[{"-", "0.047839287687364104"}], ",", " ", 
                    "0.6600370543688157"}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "0.0003563646850372297"}], ",", " ", 
                    RowBox[{"-", "0.0008603404557676955"}], ",", " ", 
                    RowBox[{"-", "2.1826118294997025*^-6"}], ",", " ", "\n", 
                    "                                ", 
                    "0.00005676570257888837", ",", " ", 
                    RowBox[{"-", "0.019815681774374427"}], ",", " ", "0.", 
                    ",", " ", "0.013079084228667923", ",", " ", 
                    "0.0478392876873641", ",", " ", "0.03157570252827015", 
                    ",", " ", "0.003236565547559942", ",", " ", "\n", 
                    "                                ", 
                    RowBox[{"-", "0.00003226092402176112"}], ",", " ", 
                    "0.017983972951063354", ",", " ", 
                    RowBox[{"-", "0.0008390470505051581"}], ",", " ", 
                    RowBox[{"-", "0.00003226092402176112"}], ",", " ", 
                    RowBox[{"-", "0.0008390470505051512"}], ",", " ", "0.", 
                    ",", " ", 
                    RowBox[{"-", "0.0478392876873641"}], ",", " ", "\n", 
                    "                                ", 
                    RowBox[{"-", "0.047839287687364104"}], ",", " ", 
                    "0.6600370543688157", ",", " ", "0.00032342536463901583", 
                    ",", " ", "0.0030064921900990263", ",", " ", 
                    "0.0026812586906176613", ",", " ", 
                    "0.0018624567134477466", ",", " ", "\n", 
                    "                                ", 
                    RowBox[{"-", "2.356194490192345"}], ",", " ", 
                    RowBox[{"-", "0.02180574986957451"}], ",", " ", 
                    RowBox[{"-", "0.0478392876873641"}], ",", " ", 
                    RowBox[{"-", "0.047839287687364104"}], ",", " ", 
                    "0.6600370543688157", ",", " ", 
                    RowBox[{"-", "2.356194490192345"}], ",", " ", "0", ",", 
                    " ", "\n", "                                ", 
                    RowBox[{"-", "0.04787154861138586"}], ",", " ", 
                    RowBox[{"-", "0.047871548611385865"}], ",", " ", 
                    "0.678021027319879", ",", " ", 
                    RowBox[{"-", "1.5707963267948966"}], ",", " ", 
                    RowBox[{"-", "0.02180574986957451"}], ",", " ", "0", ",", 
                    " ", 
                    RowBox[{"-", "0.06765496946173853"}], ",", " ", "\n", 
                    "                                ", 
                    "0.6600370543688157"}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "0.00035660500328994066", ",", " ", 
                    "0.0008609206353526744", ",", " ", 
                    "2.184083696615737*^-6", ",", " ", 
                    RowBox[{"-", "0.00005680398312415654"}], ",", " ", 
                    "0.019783420850352666", ",", " ", "\n", 
                    "                                ", 
                    "0.017983972951063354", ",", " ", 
                    RowBox[{"-", "0.014274495964210307"}], ",", " ", 
                    RowBox[{"-", "0.04787154861138586"}], ",", " ", 
                    RowBox[{"-", "0.03159699593353269"}], ",", " ", 
                    RowBox[{"-", "0.003238748159389442"}], ",", " ", 
                    RowBox[{"-", "0.0000456238362862571"}], ",", " ", "\n", 
                    "                                ", 
                    "0.017983972951063354", ",", " ", 
                    RowBox[{"-", "0.0011865917182935365"}], ",", " ", "0", 
                    ",", " ", "0", ",", " ", "0", ",", " ", "0", ",", " ", 
                    RowBox[{"-", "0.06765496946173853"}], ",", " ", 
                    "0.6600370543688157", ",", " ", "0.00032342536463901583", 
                    ",", " ", "0.002684876179637003", ",", " ", "\n", 
                    "                                ", 
                    "0.0030064921900990263", ",", " ", 
                    "0.0018637126806126225", ",", " ", 
                    RowBox[{"-", "1.5707963267948966"}], ",", " ", 
                    RowBox[{"-", "0.02180574986957451"}], ",", " ", "0", ",", 
                    " ", 
                    RowBox[{"-", "0.06765496946173853"}], ",", " ", 
                    "0.6600370543688157", ",", " ", "\n", 
                    "                                ", 
                    RowBox[{"-", "1.5707963267948966"}], ",", " ", "0", ",", 
                    " ", "0", ",", " ", 
                    RowBox[{"-", "0.06770059329802479"}], ",", " ", 
                    "0.678021027319879", ",", " ", 
                    RowBox[{"-", "2.356194490192345"}], ",", " ", "0", ",", 
                    " ", 
                    RowBox[{"-", "0.04787154861138586"}], ",", " ", 
                    RowBox[{"-", "0.047871548611385865"}], ",", " ", "\n", 
                    "                                ", "0.678021027319879"}],
                     "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "0.0003776613788228668"}], ",", " ", 
                    RowBox[{"-", "0.0009117552227386992"}], ",", " ", 
                    "0.0003226750016321468", ",", " ", 
                    "0.00028050680561905424", ",", " ", 
                    RowBox[{"-", "0.019829044686638923"}], ",", " ", "0.", 
                    ",", " ", "\n", "                                ", 
                    "0.013444509249206711", ",", " ", "0.04787154861138586", 
                    ",", " ", "0.032457916568885366", ",", " ", 
                    "0.0032409322430860575", ",", " ", "0.004766206408438681",
                     ",", " ", "0.019045868562560853", ",", " ", "\n", 
                    "                                ", 
                    RowBox[{"-", "0.0041433433882068806"}], ",", " ", 
                    "0.004766206408438681", ",", " ", 
                    RowBox[{"-", "0.0041433433882068806"}], ",", " ", "0.", 
                    ",", " ", 
                    RowBox[{"-", "0.04787154861138586"}], ",", " ", 
                    RowBox[{"-", "0.047871548611385865"}], ",", " ", 
                    "0.678021027319879", ",", " ", "\n", 
                    "                                ", 
                    "0.0004081785563580277", ",", " ", "0.002825742012165439",
                     ",", " ", "0.002684876179637003", ",", " ", 
                    "0.0020765787824438445", ",", " ", 
                    RowBox[{"-", "2.356194490192345"}], ",", " ", "0", ",", 
                    " ", 
                    RowBox[{"-", "0.04787154861138586"}], ",", " ", "\n", 
                    "                                ", 
                    RowBox[{"-", "0.047871548611385865"}], ",", " ", 
                    "0.678021027319879", ",", " ", 
                    RowBox[{"-", "2.356194490192345"}], ",", " ", 
                    "0.021805749869574537", ",", " ", 
                    RowBox[{"-", "0.04310534220294718"}], ",", " ", 
                    RowBox[{"-", "0.043105342202947185"}], ",", " ", 
                    "0.6970668958824399", ",", " ", "\n", 
                    "                                ", 
                    RowBox[{"-", "1.5707963267948966"}], ",", " ", "0", ",", 
                    " ", "0", ",", " ", 
                    RowBox[{"-", "0.06770059329802479"}], ",", " ", 
                    "0.678021027319879"}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "0.00034006050447937634", ",", " ", 
                    "0.0008209786819415414", ",", " ", 
                    RowBox[{"-", "0.00029054870312639203"}], ",", " ", "\n", 
                    "                                ", 
                    RowBox[{"-", "0.00025257887403268764"}], ",", " ", 
                    "0.024595251095077604", ",", " ", "0.019045868562560853", 
                    ",", " ", 
                    RowBox[{"-", "0.017965514016236462"}], ",", " ", 
                    RowBox[{"-", "0.04310534220294718"}], ",", " ", 
                    RowBox[{"-", "0.02922632840341718"}], ",", " ", "\n", 
                    "                                ", 
                    RowBox[{"-", "0.0029182572414539107"}], ",", " ", 
                    "0.006740433743883535", ",", " ", "0.019045868562560853", 
                    ",", " ", 
                    RowBox[{"-", "0.00585957241317106"}], ",", " ", "0", ",", 
                    " ", "0", ",", " ", "0", ",", " ", "0", ",", " ", 
                    RowBox[{"-", "0.06770059329802479"}], ",", " ", 
                    "0.678021027319879", ",", " ", "\n", 
                    "                                ", 
                    "0.0004081785563580276", ",", " ", "0.00217686502907768", 
                    ",", " ", "0.002825742012165439", ",", " ", 
                    "0.0018698296091330473", ",", " ", 
                    RowBox[{"-", "1.5707963267948966"}], ",", " ", "0", ",", 
                    " ", "0", ",", " ", 
                    RowBox[{"-", "0.06770059329802479"}], ",", " ", "\n", 
                    "                                ", "0.678021027319879", 
                    ",", " ", 
                    RowBox[{"-", "1.5707963267948966"}], ",", " ", 
                    "0.021805749869574537", ",", " ", "0", ",", " ", 
                    RowBox[{"-", "0.060960159554141254"}], ",", " ", 
                    "0.6970668958824399", ",", " ", 
                    RowBox[{"-", "2.356194490192345"}], ",", " ", 
                    "0.021805749869574537", ",", " ", "\n", 
                    "                                ", 
                    RowBox[{"-", "0.04310534220294718"}], ",", " ", 
                    RowBox[{"-", "0.043105342202947185"}], ",", " ", 
                    "0.6970668958824399"}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "0.0003260884542265266"}], ",", " ", 
                    RowBox[{"-", "0.0007872471687269574"}], ",", " ", 
                    "0.00044499526160833233", ",", " ", "\n", 
                    "                                ", 
                    "0.00035818217870585596", ",", " ", 
                    RowBox[{"-", "0.01785481735119407"}], ",", " ", "0.", ",",
                     " ", "0.01244600210754478", ",", " ", 
                    "0.04310534220294718", ",", " ", "0.030047307085358722", 
                    ",", " ", "0.0026277085383275187", ",", " ", "\n", 
                    "                                ", 
                    "0.007299771930765926", ",", " ", "0.018263331839948438", 
                    ",", " ", 
                    RowBox[{"-", "0.005875676529155726"}], ",", " ", 
                    "0.007299771930765919", ",", " ", 
                    RowBox[{"-", "0.0058756765291557225"}], ",", " ", 
                    RowBox[{"-", "2.168404344971009*^-19"}], ",", " ", "\n", 
                    "                                ", 
                    RowBox[{"-", "0.04310534220294718"}], ",", " ", 
                    RowBox[{"-", "0.043105342202947185"}], ",", " ", 
                    "0.6970668958824399", ",", " ", "0.0004401226303784705", 
                    ",", " ", "0.002248341514356281", ",", " ", 
                    "0.00217686502907768", ",", " ", "\n", 
                    "                                ", 
                    "0.001922615476378286", ",", " ", 
                    RowBox[{"-", "2.356194490192345"}], ",", " ", 
                    "0.021805749869574537", ",", " ", 
                    RowBox[{"-", "0.04310534220294718"}], ",", " ", 
                    RowBox[{"-", "0.043105342202947185"}], ",", " ", 
                    "0.6970668958824399", ",", " ", 
                    RowBox[{"-", "2.356194490192345"}], ",", " ", "\n", 
                    "                                ", "0.04361149973914906",
                     ",", " ", 
                    RowBox[{"-", "0.03580557027218126"}], ",", " ", 
                    RowBox[{"-", "0.03580557027218126"}], ",", " ", 
                    "0.7153302277223883", ",", " ", 
                    RowBox[{"-", "1.5707963267948966"}], ",", " ", 
                    "0.021805749869574537", ",", " ", "0", ",", " ", "\n", 
                    "                                ", 
                    RowBox[{"-", "0.060960159554141254"}], ",", " ", 
                    "0.6970668958824399"}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "0.00027086626543372516", ",", " ", 
                    "0.0006539290115994377", ",", " ", 
                    RowBox[{"-", "0.00036963652985952736"}], ",", " ", 
                    RowBox[{"-", "0.00029752500535812115"}], ",", " ", "\n", 
                    "                                ", 
                    "0.025154589281959995", ",", " ", "0.018263331839948438", 
                    ",", " ", 
                    RowBox[{"-", "0.01864776709092703"}], ",", " ", 
                    RowBox[{"-", "0.03580557027218126"}], ",", " ", 
                    RowBox[{"-", "0.024958877724929957"}], ",", " ", 
                    RowBox[{"-", "0.0021827132767191864"}], ",", " ", "\n", 
                    "                                ", 
                    "0.010323436466719606", ",", " ", "0.018263331839948438", 
                    ",", " ", 
                    RowBox[{"-", "0.008309461435649299"}], ",", " ", "0", ",",
                     " ", "0", ",", " ", "0", ",", " ", "0", ",", " ", 
                    RowBox[{"-", "0.060960159554141254"}], ",", " ", 
                    "0.6970668958824399", ",", " ", "0.0004401226303784706", 
                    ",", " ", "\n", "                                ", 
                    "0.0015020019563451233", ",", " ", "0.002248341514356281",
                     ",", " ", "0.0015970257983739943", ",", " ", 
                    RowBox[{"-", "1.5707963267948966"}], ",", " ", 
                    "0.021805749869574537", ",", " ", "0", ",", " ", 
                    RowBox[{"-", "0.060960159554141254"}], ",", " ", "\n", 
                    "                                ", "0.6970668958824399", 
                    ",", " ", 
                    RowBox[{"-", "1.5707963267948966"}], ",", " ", 
                    "0.04361149973914906", ",", " ", "0", ",", " ", 
                    RowBox[{"-", "0.05063672308742165"}], ",", " ", 
                    "0.7153302277223883", ",", " ", 
                    RowBox[{"-", "2.356194490192345"}], ",", " ", 
                    "0.04361149973914906", ",", " ", "\n", 
                    "                                ", 
                    RowBox[{"-", "0.03580557027218126"}], ",", " ", 
                    RowBox[{"-", "0.03580557027218126"}], ",", " ", 
                    "0.7153302277223883"}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "0.00022939618326824063"}], ",", " ", 
                    RowBox[{"-", "0.0005538113768028194"}], ",", " ", 
                    "0.0004780667427576441", ",", " ", "\n", 
                    "                                ", 
                    "0.000370018785293154", ",", " ", 
                    RowBox[{"-", "0.01483115281524039"}], ",", " ", "0.", ",",
                     " ", "0.010609171920711452", ",", " ", 
                    "0.03580557027218126", ",", " ", "0.025612806736529395", 
                    ",", " ", "0.001813076746859659", ",", " ", "\n", 
                    "                                ", 
                    "0.009441107433675891", ",", " ", "0.015467184926617361", 
                    ",", " ", 
                    RowBox[{"-", "0.007307320907285728"}], ",", " ", 
                    "0.009441107433675894", ",", " ", 
                    RowBox[{"-", "0.007307320907285732"}], ",", " ", 
                    "1.0842021724855044*^-19", ",", " ", "\n", 
                    "                                ", 
                    RowBox[{"-", "0.03580557027218126"}], ",", " ", 
                    RowBox[{"-", "0.03580557027218126"}], ",", " ", 
                    "0.7153302277223883", ",", " ", "0.0004175028287025997", 
                    ",", " ", "0.001523461327908231", ",", " ", 
                    "0.0015020019563451233", ",", " ", "\n", 
                    "                                ", 
                    "0.0015334633487699373", ",", " ", 
                    RowBox[{"-", "2.356194490192345"}], ",", " ", 
                    "0.04361149973914906", ",", " ", 
                    RowBox[{"-", "0.03580557027218126"}], ",", " ", 
                    RowBox[{"-", "0.03580557027218126"}], ",", " ", 
                    "0.7153302277223883", ",", " ", 
                    RowBox[{"-", "2.356194490192345"}], ",", " ", "\n", 
                    "                                ", "0.06541724960872358",
                     ",", " ", 
                    RowBox[{"-", "0.026364462838505364"}], ",", " ", 
                    RowBox[{"-", "0.026364462838505368"}], ",", " ", 
                    "0.7307974126490057", ",", " ", 
                    RowBox[{"-", "1.5707963267948966"}], ",", " ", 
                    "0.04361149973914906", ",", " ", "0", ",", " ", "\n", 
                    "                                ", 
                    RowBox[{"-", "0.05063672308742165"}], ",", " ", 
                    "0.7153302277223883"}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "0.0001689096725201308", ",", " ", "0.000407784022214093",
                     ",", " ", 
                    RowBox[{"-", "0.0003520115104423216"}], ",", " ", 
                    RowBox[{"-", "0.00027245332053793775"}], ",", " ", "\n", 
                    "                                ", "0.02427226024891628",
                     ",", " ", "0.015467184926617361", ",", " ", 
                    RowBox[{"-", "0.018145889011265418"}], ",", " ", 
                    RowBox[{"-", "0.026364462838505364"}], ",", " ", 
                    RowBox[{"-", "0.018859297206046486"}], ",", " ", 
                    RowBox[{"-", "0.0013350100041020147"}], ",", " ", "\n", 
                    "                                ", 
                    "0.013351742176525891", ",", " ", "0.015467184926617361", 
                    ",", " ", 
                    RowBox[{"-", "0.010334112331695944"}], ",", " ", "0", ",",
                     " ", "0", ",", " ", "0", ",", " ", "0", ",", " ", 
                    RowBox[{"-", "0.05063672308742165"}], ",", " ", 
                    "0.7153302277223883", ",", " ", "0.00041750282870259964", 
                    ",", " ", "\n", "                                ", 
                    "0.0008143426157323354", ",", " ", "0.001523461327908231",
                     ",", " ", "0.001129124244231513", ",", " ", 
                    RowBox[{"-", "1.5707963267948966"}], ",", " ", 
                    "0.04361149973914906", ",", " ", "0", ",", " ", 
                    RowBox[{"-", "0.05063672308742165"}], ",", " ", "\n", 
                    "                                ", "0.7153302277223883", 
                    ",", " ", 
                    RowBox[{"-", "1.5707963267948966"}], ",", " ", 
                    "0.06541724960872358", ",", " ", "0", ",", " ", 
                    RowBox[{"-", "0.03728498091089576"}], ",", " ", 
                    "0.7307974126490057", ",", " ", 
                    RowBox[{"-", "2.356194490192345"}], ",", " ", 
                    "0.06541724960872358", ",", " ", "\n", 
                    "                                ", 
                    RowBox[{"-", "0.026364462838505364"}], ",", " ", 
                    RowBox[{"-", "0.026364462838505368"}], ",", " ", 
                    "0.7307974126490057"}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "0.00011764652100709413"}], ",", " ", 
                    RowBox[{"-", "0.00028402382658134287"}], ",", " ", 
                    "0.0004538468791385474", ",", " ", "\n", 
                    "                                ", 
                    "0.00034225994796560123", ",", " ", 
                    RowBox[{"-", "0.01092051807239039"}], ",", " ", "0.", ",",
                     " ", "0.007980686352089605", ",", " ", 
                    "0.026364462838505364", ",", " ", "0.01926708122826058", 
                    ",", " ", "0.000982998493659693", ",", " ", "\n", 
                    "                                ", 
                    "0.012172377940145869", ",", " ", "0.010772979837333385", 
                    ",", " ", 
                    RowBox[{"-", "0.009179566131025777"}], ",", " ", 
                    "0.012172377940145869", ",", " ", 
                    RowBox[{"-", "0.009179566131025777"}], ",", " ", "0.", 
                    ",", " ", 
                    RowBox[{"-", "0.026364462838505364"}], ",", " ", "\n", 
                    "                                ", 
                    RowBox[{"-", "0.026364462838505368"}], ",", " ", 
                    "0.7307974126490057", ",", " ", "0.00041239066401109123", 
                    ",", " ", "0.0008507542145836483", ",", " ", 
                    "0.0008143426157323354", ",", " ", "0.001096334306085113",
                     ",", " ", "\n", "                                ", 
                    RowBox[{"-", "2.356194490192345"}], ",", " ", 
                    "0.06541724960872358", ",", " ", 
                    RowBox[{"-", "0.026364462838505364"}], ",", " ", 
                    RowBox[{"-", "0.026364462838505368"}], ",", " ", 
                    "0.7307974126490057", ",", " ", 
                    RowBox[{"-", "2.356194490192345"}], ",", " ", 
                    "0.0872229994782981", ",", " ", "\n", 
                    "                                ", 
                    RowBox[{"-", "0.014192084898359495"}], ",", " ", 
                    RowBox[{"-", "0.014192084898359499"}], ",", " ", 
                    "0.741570392486339", ",", " ", 
                    RowBox[{"-", "1.5707963267948966"}], ",", " ", 
                    "0.06541724960872358", ",", " ", "0", ",", " ", 
                    RowBox[{"-", "0.03728498091089576"}], ",", " ", "\n", 
                    "                                ", 
                    "0.7307974126490057"}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "0.00006332954418061636", ",", " ", 
                    "0.0001528910444597506", ",", " ", 
                    RowBox[{"-", "0.00024430740269749094"}], ",", " ", 
                    RowBox[{"-", "0.0001842397574564538"}], ",", " ", 
                    "0.02309289601253626", ",", " ", "\n", 
                    "                                ", 
                    "0.010772979837333385", ",", " ", 
                    RowBox[{"-", "0.017277899004122476"}], ",", " ", 
                    RowBox[{"-", "0.014192084898359495"}], ",", " ", 
                    RowBox[{"-", "0.010371538923816145"}], ",", " ", 
                    RowBox[{"-", "0.0005291516145211457"}], ",", " ", 
                    "0.01721434196928537", ",", " ", "\n", 
                    "                                ", 
                    "0.010772979837333385", ",", " ", 
                    RowBox[{"-", "0.012981866919197374"}], ",", " ", "0", ",",
                     " ", "0", ",", " ", "0", ",", " ", "0", ",", " ", 
                    RowBox[{"-", "0.03728498091089576"}], ",", " ", 
                    "0.7307974126490057", ",", " ", "0.0004123906640110913", 
                    ",", " ", "0.00023597267140166504", ",", " ", "\n", 
                    "                                ", 
                    "0.0008507542145836483", ",", " ", 
                    "0.0005901606888125031", ",", " ", 
                    RowBox[{"-", "1.5707963267948966"}], ",", " ", 
                    "0.06541724960872358", ",", " ", "0", ",", " ", 
                    RowBox[{"-", "0.03728498091089576"}], ",", " ", 
                    "0.7307974126490057", ",", " ", "\n", 
                    "                                ", 
                    RowBox[{"-", "1.5707963267948966"}], ",", " ", 
                    "0.0872229994782981", ",", " ", "0", ",", " ", 
                    RowBox[{"-", "0.02007063894161039"}], ",", " ", 
                    "0.741570392486339", ",", " ", 
                    RowBox[{"-", "2.356194490192345"}], ",", " ", 
                    "0.0872229994782981", ",", " ", 
                    RowBox[{"-", "0.014192084898359495"}], ",", " ", "\n", 
                    "                                ", 
                    RowBox[{"-", "0.014192084898359499"}], ",", " ", 
                    "0.741570392486339"}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "0.000027215259766686165"}], ",", " ", 
                    RowBox[{"-", "0.00006570344923224331"}], ",", " ", 
                    "0.0002848442118236548", ",", " ", 
                    "0.00021255074416628837", ",", " ", "\n", 
                    "                                ", 
                    RowBox[{"-", "0.00587855404325089"}], ",", " ", "0.", ",",
                     " ", "0.004359361629105718", ",", " ", 
                    "0.014192084898359495", ",", " ", "0.010524429968275895", 
                    ",", " ", "0.0002848442118236548", ",", " ", 
                    "0.014192084898359499", ",", " ", "\n", 
                    "                                ", "0.00462958400423874",
                     ",", " ", 
                    RowBox[{"-", "0.010590133417508142"}], ",", " ", 
                    "0.014192084898359495", ",", " ", 
                    RowBox[{"-", "0.010590133417508139"}], ",", " ", "0", ",",
                     " ", 
                    RowBox[{"-", "0.014192084898359495"}], ",", " ", 
                    RowBox[{"-", "0.014192084898359499"}], ",", " ", "\n", 
                    "                                ", "0.741570392486339", 
                    ",", " ", "0.0004242635955767906", ",", " ", 
                    "0.00042426359557679055", ",", " ", 
                    "0.00023597267140166504", ",", " ", 
                    "0.0005871757440992308", ",", " ", 
                    RowBox[{"-", "2.356194490192345"}], ",", " ", "\n", 
                    "                                ", "0.0872229994782981", 
                    ",", " ", 
                    RowBox[{"-", "0.014192084898359495"}], ",", " ", 
                    RowBox[{"-", "0.014192084898359499"}], ",", " ", 
                    "0.741570392486339", ",", " ", 
                    RowBox[{"-", "2.356194490192345"}], ",", " ", 
                    "0.10902874934787263", ",", " ", "0", ",", " ", "0", ",", 
                    " ", "\n", "                                ", 
                    "0.7461999764905778", ",", " ", 
                    RowBox[{"-", "1.5707963267948966"}], ",", " ", 
                    "0.0872229994782981", ",", " ", "0", ",", " ", 
                    RowBox[{"-", "0.02007063894161039"}], ",", " ", 
                    "0.741570392486339"}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "0.", ",", " ", "0", ",", " ", "0", ",", " ", "0", ",", 
                    " ", "0.02007063894161039", ",", " ", "\n", 
                    "                                ", "0.00462958400423874",
                     ",", " ", 
                    RowBox[{"-", "0.014976710306380547"}], ",", " ", "0", ",",
                     " ", "0", ",", " ", "0", ",", " ", "0.02007063894161039",
                     ",", " ", "0.00462958400423874", ",", " ", 
                    RowBox[{"-", "0.014976710306380547"}], ",", " ", "0", ",",
                     " ", "0", ",", " ", "0", ",", " ", "0", ",", " ", "\n", 
                    "                                ", 
                    RowBox[{"-", "0.02007063894161039"}], ",", " ", 
                    "0.741570392486339", ",", " ", "0.00042426359557679055", 
                    ",", " ", "0.", ",", " ", "0.00042426359557679055", ",", 
                    " ", "0.", ",", " ", 
                    RowBox[{"-", "1.5707963267948966"}], ",", " ", 
                    "0.0872229994782981", ",", " ", "0", ",", " ", "\n", 
                    "                                ", 
                    RowBox[{"-", "0.02007063894161039"}], ",", " ", 
                    "0.741570392486339", ",", " ", 
                    RowBox[{"-", "1.5707963267948966"}], ",", " ", 
                    "0.10902874934787263", ",", " ", "0", ",", " ", "0", ",", 
                    " ", "0.7461999764905778", ",", " ", 
                    RowBox[{"-", "2.356194490192345"}], ",", " ", 
                    "0.10902874934787263", ",", " ", "\n", 
                    "                                ", "0", ",", " ", "0", 
                    ",", " ", "0.7461999764905778"}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "0.", ",", " ", "0", ",", " ", "0", ",", " ", "0", ",", 
                    " ", "0", ",", " ", "0.", ",", " ", "0", ",", " ", "0", 
                    ",", " ", "0", ",", " ", "0", ",", " ", 
                    RowBox[{"-", "0.019872334842201373"}], ",", " ", 
                    "0.0024195679317141616", ",", " ", "0.012382792667417267",
                     ",", " ", "0", ",", " ", "0", ",", " ", "0", ",", " ", 
                    "0", ",", " ", "0", ",", " ", "\n", 
                    "                                ", "0.6231171508403164", 
                    ",", " ", "0.00040076400105675024", ",", " ", 
                    "0.00040076400105675024", ",", " ", "0.", ",", " ", "0.", 
                    ",", " ", 
                    RowBox[{"-", "1.5707963267948966"}], ",", " ", 
                    RowBox[{"-", "0.1090287493478726"}], ",", " ", "0", ",", 
                    " ", "0", ",", " ", "0.6231171508403164", ",", " ", "\n", 
                    "                                ", 
                    RowBox[{"-", "1.5707963267948966"}], ",", " ", 
                    RowBox[{"-", "0.08722299947829808"}], ",", " ", "0", ",", 
                    " ", 
                    RowBox[{"-", "0.019872334842201373"}], ",", " ", 
                    "0.6255367187720305", ",", " ", 
                    RowBox[{"-", "0.7853981633974483"}], ",", " ", 
                    RowBox[{"-", "0.1090287493478726"}], ",", " ", "0", ",", 
                    " ", "0", ",", " ", "\n", 
                    "                                ", 
                    "0.6231171508403164"}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "0.000014083027682386569"}], ",", " ", 
                    "0.000033999436430091554", ",", " ", 
                    "0.0002792433212264629", ",", " ", 
                    "0.0001740013027138208", ",", " ", 
                    RowBox[{"-", "0.019872334842201373"}], ",", " ", "\n", 
                    "                                ", 
                    "0.0024195679317141616", ",", " ", "0.012382792667417267",
                     ",", " ", "0", ",", " ", "0", ",", " ", "0", ",", " ", 
                    RowBox[{"-", "0.014051862724930291"}], ",", " ", 
                    "0.0024195679317141616", ",", " ", "0.008755956665157808",
                     ",", " ", "0.01405186272493029", ",", " ", "\n", 
                    "                                ", 
                    RowBox[{"-", "0.008755956665157806"}], ",", " ", "0", ",",
                     " ", "0", ",", " ", "0", ",", " ", "0.6231171508403164", 
                    ",", " ", "0.00040076400105675024", ",", " ", 
                    "0.00023133274170821544", ",", " ", 
                    "0.00040076400105675024", ",", " ", 
                    "0.0005633156337111625", ",", " ", "\n", 
                    "                                ", 
                    RowBox[{"-", "0.7853981633974483"}], ",", " ", 
                    RowBox[{"-", "0.1090287493478726"}], ",", " ", "0", ",", 
                    " ", "0", ",", " ", "0.6231171508403164", ",", " ", 
                    RowBox[{"-", "0.7853981633974483"}], ",", " ", 
                    RowBox[{"-", "0.08722299947829808"}], ",", " ", 
                    "0.01405186272493029", ",", " ", "\n", 
                    "                                ", 
                    RowBox[{"-", "0.014051862724930291"}], ",", " ", 
                    "0.6255367187720305", ",", " ", 
                    RowBox[{"-", "1.5707963267948966"}], ",", " ", 
                    RowBox[{"-", "0.08722299947829808"}], ",", " ", "0", ",", 
                    " ", 
                    RowBox[{"-", "0.019872334842201373"}], ",", " ", 
                    "0.6255367187720305"}], "}"}], ",", " ", "\n", 
                    "                               ", 
                    RowBox[{"{", 
                    RowBox[{"0.000042643341024432846", ",", " ", 
                    RowBox[{"-", "0.0001029501322460779"}], ",", " ", 
                    RowBox[{"-", "0.0002901015347222037"}], ",", " ", 
                    RowBox[{"-", "0.00017942330264081457"}], ",", " ", 
                    "0.005820472117271082", ",", " ", "0.", ",", " ", 
                    RowBox[{"-", "0.003640919029941847"}], ",", " ", "\n", 
                    "                                ", "0.01405186272493029",
                     ",", " ", "0.008789956101587898", ",", " ", 
                    "0.0002792433212264629", ",", " ", 
                    RowBox[{"-", "0.020645058979085838"}], ",", " ", 
                    "0.007326440220870367", ",", " ", "0.012768648979361894", 
                    ",", " ", "0", ",", " ", "0", ",", " ", "0", ",", " ", 
                    "0", ",", " ", "\n", "                                ", 
                    RowBox[{"-", "0.019872334842201373"}], ",", " ", 
                    "0.6255367187720305", ",", " ", "0.0004798951865599198", 
                    ",", " ", "0.0009515559085625074", ",", " ", 
                    "0.00023133274170821544", ",", " ", 
                    "0.0006215338597739909", ",", " ", "\n", 
                    "                                ", 
                    RowBox[{"-", "1.5707963267948966"}], ",", " ", 
                    RowBox[{"-", "0.08722299947829808"}], ",", " ", "0", ",", 
                    " ", 
                    RowBox[{"-", "0.019872334842201373"}], ",", " ", 
                    "0.6255367187720305", ",", " ", 
                    RowBox[{"-", "1.5707963267948966"}], ",", " ", 
                    RowBox[{"-", "0.06541724960872355"}], ",", " ", "0", ",", 
                    " ", "\n", "                                ", 
                    RowBox[{"-", "0.04051739382128721"}], ",", " ", 
                    "0.6328631589929009", ",", " ", 
                    RowBox[{"-", "0.7853981633974483"}], ",", " ", 
                    RowBox[{"-", "0.08722299947829808"}], ",", " ", 
                    "0.01405186272493029", ",", " ", 
                    RowBox[{"-", "0.014051862724930291"}], ",", " ", 
                    "0.6255367187720305"}], "}"}], ",", " ", "\n", 
                    "                               ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "0.00008694484346514781"}], ",", " ", 
                    "0.00020990342027197087", ",", " ", "0.00059148349823182",
                     ",", " ", "0.00036582337563956696", ",", " ", 
                    RowBox[{"-", "0.02646553109635692"}], ",", " ", 
                    "0.007326440220870367", ",", " ", "\n", 
                    "                                ", "0.01645221135032817",
                     ",", " ", 
                    RowBox[{"-", "0.01405186272493029"}], ",", " ", 
                    RowBox[{"-", "0.008892906233833976"}], ",", " ", 
                    RowBox[{"-", "0.0005693448559486666"}], ",", " ", 
                    RowBox[{"-", "0.014598261202107818"}], ",", " ", 
                    "0.007326440220870367", ",", " ", "\n", 
                    "                                ", 
                    "0.009028798279897483", ",", " ", "0.014598261202107816", 
                    ",", " ", 
                    RowBox[{"-", "0.009028798279897485"}], ",", " ", "0.", 
                    ",", " ", "0.01405186272493029", ",", " ", 
                    RowBox[{"-", "0.014051862724930291"}], ",", " ", 
                    "0.6255367187720305", ",", " ", "\n", 
                    "                                ", 
                    "0.0004798951865599198", ",", " ", 
                    "0.0009616616957775924", ",", " ", 
                    "0.0009515559085625074", ",", " ", 
                    "0.0012672357007717282", ",", " ", 
                    RowBox[{"-", "0.7853981633974483"}], ",", " ", 
                    RowBox[{"-", "0.08722299947829808"}], ",", " ", "\n", 
                    "                                ", "0.01405186272493029",
                     ",", " ", 
                    RowBox[{"-", "0.014051862724930291"}], ",", " ", 
                    "0.6255367187720305", ",", " ", 
                    RowBox[{"-", "0.7853981633974483"}], ",", " ", 
                    RowBox[{"-", "0.06541724960872355"}], ",", " ", 
                    "0.028650123927038106", ",", " ", "\n", 
                    "                                ", 
                    RowBox[{"-", "0.02865012392703811"}], ",", " ", 
                    "0.6328631589929009", ",", " ", 
                    RowBox[{"-", "1.5707963267948966"}], ",", " ", 
                    RowBox[{"-", "0.06541724960872355"}], ",", " ", "0", ",", 
                    " ", 
                    RowBox[{"-", "0.04051739382128721"}], ",", " ", 
                    "0.6328631589929009"}], "}"}], ",", " ", "\n", 
                    "                               ", 
                    RowBox[{"{", 
                    RowBox[{"0.0001394679286909374", ",", " ", 
                    RowBox[{"-", "0.0003367053649617445"}], ",", " ", 
                    RowBox[{"-", "0.0005036849306382235"}], ",", " ", 
                    RowBox[{"-", "0.000305121212466931"}], ",", " ", 
                    "0.011867269894249102", ",", " ", "0.", ",", " ", 
                    RowBox[{"-", "0.007510357913895833"}], ",", " ", "\n", 
                    "                                ", 
                    "0.028650123927038106", ",", " ", "0.01813160793400343", 
                    ",", " ", "0.0011608283541804866", ",", " ", 
                    RowBox[{"-", "0.017580549805680898"}], ",", " ", 
                    "0.011752317924320854", ",", " ", "0.010649908993202561", 
                    ",", " ", "0", ",", " ", "0", ",", " ", "0", ",", " ", 
                    "0", ",", " ", "\n", "                                ", 
                    RowBox[{"-", "0.04051739382128721"}], ",", " ", 
                    "0.6328631589929009", ",", " ", "0.00044719270806433986", 
                    ",", " ", "0.0018261206627085398", ",", " ", 
                    "0.0009616616957775924", ",", " ", 
                    "0.0012434151604020164", ",", " ", "\n", 
                    "                                ", 
                    RowBox[{"-", "1.5707963267948966"}], ",", " ", 
                    RowBox[{"-", "0.06541724960872355"}], ",", " ", "0", ",", 
                    " ", 
                    RowBox[{"-", "0.04051739382128721"}], ",", " ", 
                    "0.6328631589929009", ",", " ", 
                    RowBox[{"-", "1.5707963267948966"}], ",", " ", 
                    RowBox[{"-", "0.04361149973914903"}], ",", " ", "0", ",", 
                    " ", "\n", "                                ", 
                    RowBox[{"-", "0.05809794362696811"}], ",", " ", 
                    "0.6446154769172218", ",", " ", 
                    RowBox[{"-", "0.7853981633974483"}], ",", " ", 
                    RowBox[{"-", "0.06541724960872355"}], ",", " ", 
                    "0.028650123927038106", ",", " ", 
                    RowBox[{"-", "0.02865012392703811"}], ",", " ", 
                    "0.6328631589929009"}], "}"}], ",", " ", "\n", 
                    "                               ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "0.00019998324409994592"}], ",", " ", 
                    "0.00048280226015345526", ",", " ", 
                    "0.0007222344762608717", ",", " ", 
                    "0.0004375137028675933", ",", " ", 
                    RowBox[{"-", "0.02944781969993"}], ",", " ", 
                    "0.011752317924320854", ",", " ", "\n", 
                    "                                ", 
                    "0.018299734835789335", ",", " ", 
                    RowBox[{"-", "0.028650123927038106"}], ",", " ", 
                    RowBox[{"-", "0.018468313298965176"}], ",", " ", 
                    RowBox[{"-", "0.0016645132848187101"}], ",", " ", 
                    RowBox[{"-", "0.012431325984584806"}], ",", " ", 
                    "0.011752317924320854", ",", " ", "\n", 
                    "                                ", 
                    "0.007530622868113131", ",", " ", "0.012431325984584803", 
                    ",", " ", 
                    RowBox[{"-", "0.007530622868113127"}], ",", " ", "0.", 
                    ",", " ", "0.028650123927038106", ",", " ", 
                    RowBox[{"-", "0.02865012392703811"}], ",", " ", 
                    "0.6328631589929009", ",", " ", "\n", 
                    "                                ", 
                    "0.0004471927080643399", ",", " ", 
                    "0.0019772465852055643", ",", " ", 
                    "0.0018261206627085398", ",", " ", 
                    "0.0017829346135288734", ",", " ", 
                    RowBox[{"-", "0.7853981633974483"}], ",", " ", 
                    RowBox[{"-", "0.06541724960872355"}], ",", " ", "\n", 
                    "                                ", 
                    "0.028650123927038106", ",", " ", 
                    RowBox[{"-", "0.02865012392703811"}], ",", " ", 
                    "0.6328631589929009", ",", " ", 
                    RowBox[{"-", "0.7853981633974483"}], ",", " ", 
                    RowBox[{"-", "0.04361149973914903"}], ",", " ", 
                    "0.04108144991162291", ",", " ", "\n", 
                    "                                ", 
                    RowBox[{"-", "0.041081449911622915"}], ",", " ", 
                    "0.6446154769172218", ",", " ", 
                    RowBox[{"-", "1.5707963267948966"}], ",", " ", 
                    RowBox[{"-", "0.04361149973914903"}], ",", " ", "0", ",", 
                    " ", 
                    RowBox[{"-", "0.05809794362696811"}], ",", " ", 
                    "0.6446154769172218"}], "}"}], ",", " ", "\n", 
                    "                               ", 
                    RowBox[{"{", 
                    RowBox[{"0.00026242117578575627", ",", " ", 
                    RowBox[{"-", "0.0006335407616358674"}], ",", " ", 
                    RowBox[{"-", "0.00039261647813520735"}], ",", " ", 
                    RowBox[{"-", "0.00021627924284377958"}], ",", " ", 
                    "0.017016493715345193", ",", " ", "0.", ",", " ", 
                    RowBox[{"-", "0.01096909521177615"}], ",", " ", "\n", 
                    "                                ", "0.04108144991162291",
                     ",", " ", "0.026481738427231758", ",", " ", 
                    "0.0023867477610795816", ",", " ", 
                    RowBox[{"-", "0.009557025834770423"}], ",", " ", 
                    "0.015421577451593893", ",", " ", "0.005264644828969121", 
                    ",", " ", "0", ",", " ", "0", ",", " ", "0", ",", " ", 
                    "0", ",", " ", "\n", "                                ", 
                    RowBox[{"-", "0.05809794362696811"}], ",", " ", 
                    "0.6446154769172218", ",", " ", "0.0003291617939019785", 
                    ",", " ", "0.0026316625192170677", ",", " ", 
                    "0.0019772465852055643", ",", " ", 
                    "0.0015803625774590193", ",", " ", "\n", 
                    "                                ", 
                    RowBox[{"-", "1.5707963267948966"}], ",", " ", 
                    RowBox[{"-", "0.04361149973914903"}], ",", " ", "0", ",", 
                    " ", 
                    RowBox[{"-", "0.05809794362696811"}], ",", " ", 
                    "0.6446154769172218", ",", " ", 
                    RowBox[{"-", "1.5707963267948966"}], ",", " ", 
                    RowBox[{"-", "0.02180574986957451"}], ",", " ", "0", ",", 
                    " ", "\n", "                                ", 
                    RowBox[{"-", "0.06765496946173853"}], ",", " ", 
                    "0.6600370543688157", ",", " ", 
                    RowBox[{"-", "0.7853981633974483"}], ",", " ", 
                    RowBox[{"-", "0.04361149973914903"}], ",", " ", 
                    "0.04108144991162291", ",", " ", 
                    RowBox[{"-", "0.041081449911622915"}], ",", " ", 
                    "0.6446154769172218"}], "}"}], ",", " ", "\n", 
                    "                               ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "0.00030558907123965154"}], ",", " ", 
                    "0.0007377572802997646", ",", " ", 
                    "0.0004572013083451532", ",", " ", 
                    "0.0002518568585448476", ",", " ", 
                    RowBox[{"-", "0.026573519550115617"}], ",", " ", 
                    "0.015421577451593893", ",", " ", "\n", 
                    "                                ", 
                    "0.016496161216531028", ",", " ", 
                    RowBox[{"-", "0.04108144991162291"}], ",", " ", 
                    RowBox[{"-", "0.027115279188867625"}], ",", " ", 
                    RowBox[{"-", "0.002779364239214789"}], ",", " ", 
                    RowBox[{"-", "0.006757837775741189"}], ",", " ", 
                    "0.015421577451593893", ",", " ", "\n", 
                    "                                ", 
                    "0.0037226660591027534", ",", " ", "0.006757837775741189",
                     ",", " ", 
                    RowBox[{"-", "0.003722666059102757"}], ",", " ", "0.", 
                    ",", " ", "0.04108144991162291", ",", " ", 
                    RowBox[{"-", "0.041081449911622915"}], ",", " ", 
                    "0.6446154769172218", ",", " ", "\n", 
                    "                                ", 
                    "0.00032916179390197846", ",", " ", 
                    "0.0026812586906176613", ",", " ", 
                    "0.0026316625192170677", ",", " ", 
                    "0.0018403298850466381", ",", " ", 
                    RowBox[{"-", "0.7853981633974483"}], ",", " ", 
                    RowBox[{"-", "0.04361149973914903"}], ",", " ", "\n", 
                    "                                ", "0.04108144991162291",
                     ",", " ", 
                    RowBox[{"-", "0.041081449911622915"}], ",", " ", 
                    "0.6446154769172218", ",", " ", 
                    RowBox[{"-", "0.7853981633974483"}], ",", " ", 
                    RowBox[{"-", "0.02180574986957451"}], ",", " ", 
                    "0.0478392876873641", ",", " ", 
                    RowBox[{"-", "0.047839287687364104"}], ",", " ", "\n", 
                    "                                ", "0.6600370543688157", 
                    ",", " ", 
                    RowBox[{"-", "1.5707963267948966"}], ",", " ", 
                    RowBox[{"-", "0.02180574986957451"}], ",", " ", "0", ",", 
                    " ", 
                    RowBox[{"-", "0.06765496946173853"}], ",", " ", 
                    "0.6600370543688157"}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "0.00035636468503722624", ",", " ", "\n", 
                    "                                ", 
                    RowBox[{"-", "0.0008603404557676955"}], ",", " ", 
                    RowBox[{"-", "2.1826118294997025*^-6"}], ",", " ", 
                    "0.00005676570257888815", ",", " ", 
                    "0.019815681774374427", ",", " ", "0.", ",", " ", 
                    RowBox[{"-", "0.013079084228667923"}], ",", " ", 
                    "0.0478392876873641", ",", " ", "\n", 
                    "                                ", "0.03157570252827015",
                     ",", " ", "0.003236565547559942", ",", " ", 
                    RowBox[{"-", "0.0000456238362862571"}], ",", " ", 
                    "0.017983972951063354", ",", " ", 
                    RowBox[{"-", "0.0011865917182935365"}], ",", " ", "0", 
                    ",", " ", "0", ",", " ", "0", ",", " ", "0", ",", " ", 
                    RowBox[{"-", "0.06765496946173853"}], ",", " ", "\n", 
                    "                                ", "0.6600370543688157", 
                    ",", " ", "0.00032342536463901583", ",", " ", 
                    "0.003006492190099026", ",", " ", "0.0026812586906176613",
                     ",", " ", "0.0018624567134477466", ",", " ", 
                    RowBox[{"-", "1.5707963267948966"}], ",", " ", "\n", 
                    "                                ", 
                    RowBox[{"-", "0.02180574986957451"}], ",", " ", "0", ",", 
                    " ", 
                    RowBox[{"-", "0.06765496946173853"}], ",", " ", 
                    "0.6600370543688157", ",", " ", 
                    RowBox[{"-", "1.5707963267948966"}], ",", " ", "0", ",", 
                    " ", "0", ",", " ", 
                    RowBox[{"-", "0.06770059329802479"}], ",", " ", 
                    "0.678021027319879", ",", " ", "\n", 
                    "                                ", 
                    RowBox[{"-", "0.7853981633974483"}], ",", " ", 
                    RowBox[{"-", "0.02180574986957451"}], ",", " ", 
                    "0.0478392876873641", ",", " ", 
                    RowBox[{"-", "0.047839287687364104"}], ",", " ", 
                    "0.6600370543688157"}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "0.00035660500328994066"}], ",", " ", "\n", 
                    "                                ", 
                    "0.0008609206353526744", ",", " ", 
                    "2.184083696615737*^-6", ",", " ", 
                    RowBox[{"-", "0.00005680398312415632"}], ",", " ", 
                    RowBox[{"-", "0.019861305610660684"}], ",", " ", 
                    "0.017983972951063354", ",", " ", "0.012248857195411612", 
                    ",", " ", "\n", "                                ", 
                    RowBox[{"-", "0.0478392876873641"}], ",", " ", 
                    RowBox[{"-", "0.03243604298403784"}], ",", " ", 
                    RowBox[{"-", "0.003238748159389442"}], ",", " ", 
                    RowBox[{"-", "0.00003226092402176112"}], ",", " ", 
                    "0.017983972951063354", ",", " ", 
                    RowBox[{"-", "0.0008390470505051581"}], ",", " ", "\n", 
                    "                                ", 
                    "0.00003226092402176112", ",", " ", 
                    "0.0008390470505051512", ",", " ", "0.", ",", " ", 
                    "0.0478392876873641", ",", " ", 
                    RowBox[{"-", "0.047839287687364104"}], ",", " ", 
                    "0.6600370543688157", ",", " ", "0.00032342536463901583", 
                    ",", " ", "\n", "                                ", 
                    "0.002684876179637003", ",", " ", "0.003006492190099026", 
                    ",", " ", "0.0018637126806126214", ",", " ", 
                    RowBox[{"-", "0.7853981633974483"}], ",", " ", 
                    RowBox[{"-", "0.02180574986957451"}], ",", " ", 
                    "0.0478392876873641", ",", " ", "\n", 
                    "                                ", 
                    RowBox[{"-", "0.047839287687364104"}], ",", " ", 
                    "0.6600370543688157", ",", " ", 
                    RowBox[{"-", "0.7853981633974483"}], ",", " ", "0", ",", 
                    " ", "0.04787154861138586", ",", " ", 
                    RowBox[{"-", "0.047871548611385865"}], ",", " ", 
                    "0.678021027319879", ",", " ", "\n", 
                    "                                ", 
                    RowBox[{"-", "1.5707963267948966"}], ",", " ", "0", ",", 
                    " ", "0", ",", " ", 
                    RowBox[{"-", "0.06770059329802479"}], ",", " ", 
                    "0.678021027319879"}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.00037766137882287026", ",", " ", 
                    RowBox[{"-", "0.0009117552227386957"}], ",", " ", 
                    "0.0003226750016321464", ",", " ", "\n", 
                    "                                ", 
                    "0.0002805068056190539", ",", " ", "0.019829044686638923",
                     ",", " ", "0.", ",", " ", 
                    RowBox[{"-", "0.013444509249206711"}], ",", " ", 
                    "0.04787154861138586", ",", " ", "0.032457916568885366", 
                    ",", " ", "0.0032409322430860575", ",", " ", "\n", 
                    "                                ", 
                    "0.006740433743883535", ",", " ", "0.019045868562560853", 
                    ",", " ", 
                    RowBox[{"-", "0.00585957241317106"}], ",", " ", "0", ",", 
                    " ", "0", ",", " ", "0", ",", " ", "0", ",", " ", 
                    RowBox[{"-", "0.06770059329802479"}], ",", " ", 
                    "0.678021027319879", ",", " ", "0.0004081785563580276", 
                    ",", " ", "\n", "                                ", 
                    "0.0028257420121654392", ",", " ", "0.002684876179637003",
                     ",", " ", "0.0020765787824438436", ",", " ", 
                    RowBox[{"-", "1.5707963267948966"}], ",", " ", "0", ",", 
                    " ", "0", ",", " ", 
                    RowBox[{"-", "0.06770059329802479"}], ",", " ", 
                    "0.678021027319879", ",", " ", "\n", 
                    "                                ", 
                    RowBox[{"-", "1.5707963267948966"}], ",", " ", 
                    "0.021805749869574537", ",", " ", "0", ",", " ", 
                    RowBox[{"-", "0.060960159554141254"}], ",", " ", 
                    "0.6970668958824399", ",", " ", 
                    RowBox[{"-", "0.7853981633974483"}], ",", " ", "0", ",", 
                    " ", "0.04787154861138586", ",", " ", "\n", 
                    "                                ", 
                    RowBox[{"-", "0.047871548611385865"}], ",", " ", 
                    "0.678021027319879"}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "0.00034006050447937634"}], ",", " ", 
                    "0.0008209786819415414", ",", " ", 
                    RowBox[{"-", "0.00029054870312639246"}], ",", " ", 
                    RowBox[{"-", "0.00025257887403268785"}], ",", " ", "\n", 
                    "                                ", 
                    RowBox[{"-", "0.013088610942755388"}], ",", " ", 
                    "0.019045868562560853", ",", " ", "0.007962598214858521", 
                    ",", " ", 
                    RowBox[{"-", "0.04787154861138586"}], ",", " ", 
                    RowBox[{"-", "0.03336967179162406"}], ",", " ", 
                    RowBox[{"-", "0.002918257241453911"}], ",", " ", "\n", 
                    "                                ", 
                    "0.004766206408438681", ",", " ", "0.019045868562560853", 
                    ",", " ", 
                    RowBox[{"-", "0.0041433433882068806"}], ",", " ", 
                    RowBox[{"-", "0.004766206408438681"}], ",", " ", 
                    "0.0041433433882068806", ",", " ", "0.", ",", " ", 
                    "0.04787154861138586", ",", " ", "\n", 
                    "                                ", 
                    RowBox[{"-", "0.047871548611385865"}], ",", " ", 
                    "0.678021027319879", ",", " ", "0.0004081785563580277", 
                    ",", " ", "0.00217686502907768", ",", " ", 
                    "0.0028257420121654392", ",", " ", 
                    "0.0018698296091330473", ",", " ", "\n", 
                    "                                ", 
                    RowBox[{"-", "0.7853981633974483"}], ",", " ", "0", ",", 
                    " ", "0.04787154861138586", ",", " ", 
                    RowBox[{"-", "0.047871548611385865"}], ",", " ", 
                    "0.678021027319879", ",", " ", 
                    RowBox[{"-", "0.7853981633974483"}], ",", " ", 
                    "0.021805749869574537", ",", " ", "\n", 
                    "                                ", "0.04310534220294718",
                     ",", " ", 
                    RowBox[{"-", "0.043105342202947185"}], ",", " ", 
                    "0.6970668958824399", ",", " ", 
                    RowBox[{"-", "1.5707963267948966"}], ",", " ", 
                    "0.021805749869574537", ",", " ", "0", ",", " ", 
                    RowBox[{"-", "0.060960159554141254"}], ",", " ", "\n", 
                    "                                ", 
                    "0.6970668958824399"}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.00032608845422653094", ",", " ", 
                    RowBox[{"-", "0.0007872471687269574"}], ",", " ", 
                    "0.00044499526160833277", ",", " ", 
                    "0.00035818217870585596", ",", " ", "0.01785481735119407",
                     ",", " ", "0.", ",", " ", "\n", 
                    "                                ", 
                    RowBox[{"-", "0.01244600210754478"}], ",", " ", 
                    "0.04310534220294718", ",", " ", "0.030047307085358722", 
                    ",", " ", "0.0026277085383275187", ",", " ", 
                    "0.010323436466719606", ",", " ", "0.018263331839948438", 
                    ",", " ", "\n", "                                ", 
                    RowBox[{"-", "0.008309461435649299"}], ",", " ", "0", ",",
                     " ", "0", ",", " ", "0", ",", " ", "0", ",", " ", 
                    RowBox[{"-", "0.060960159554141254"}], ",", " ", 
                    "0.6970668958824399", ",", " ", "0.0004401226303784706", 
                    ",", " ", "0.0022483415143562807", ",", " ", 
                    "0.00217686502907768", ",", " ", "\n", 
                    "                                ", 
                    "0.0019226154763782855", ",", " ", 
                    RowBox[{"-", "1.5707963267948966"}], ",", " ", 
                    "0.021805749869574537", ",", " ", "0", ",", " ", 
                    RowBox[{"-", "0.060960159554141254"}], ",", " ", 
                    "0.6970668958824399", ",", " ", 
                    RowBox[{"-", "1.5707963267948966"}], ",", " ", "\n", 
                    "                                ", "0.04361149973914906",
                     ",", " ", "0", ",", " ", 
                    RowBox[{"-", "0.05063672308742165"}], ",", " ", 
                    "0.7153302277223883", ",", " ", 
                    RowBox[{"-", "0.7853981633974483"}], ",", " ", 
                    "0.021805749869574537", ",", " ", "0.04310534220294718", 
                    ",", " ", "\n", "                                ", 
                    RowBox[{"-", "0.043105342202947185"}], ",", " ", 
                    "0.6970668958824399"}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "0.00027086626543372516"}], ",", " ", 
                    "0.0006539290115994377", ",", " ", 
                    RowBox[{"-", "0.00036963652985952736"}], ",", " ", 
                    RowBox[{"-", "0.0002975250053581212"}], ",", " ", "\n", 
                    "                                ", 
                    RowBox[{"-", "0.007531380884474463"}], ",", " ", 
                    "0.018263331839948438", ",", " ", "0.004462629126122004", 
                    ",", " ", 
                    RowBox[{"-", "0.04310534220294718"}], ",", " ", 
                    RowBox[{"-", "0.03083455425408568"}], ",", " ", 
                    RowBox[{"-", "0.002182713276719186"}], ",", " ", "\n", 
                    "                                ", 
                    "0.007299771930765926", ",", " ", "0.018263331839948438", 
                    ",", " ", 
                    RowBox[{"-", "0.005875676529155726"}], ",", " ", 
                    RowBox[{"-", "0.007299771930765919"}], ",", " ", 
                    "0.0058756765291557225", ",", " ", 
                    "2.168404344971009*^-19", ",", " ", "\n", 
                    "                                ", "0.04310534220294718",
                     ",", " ", 
                    RowBox[{"-", "0.043105342202947185"}], ",", " ", 
                    "0.6970668958824399", ",", " ", "0.0004401226303784705", 
                    ",", " ", "0.0015020019563451233", ",", " ", 
                    "0.0022483415143562807", ",", " ", "\n", 
                    "                                ", 
                    "0.001597025798373995", ",", " ", 
                    RowBox[{"-", "0.7853981633974483"}], ",", " ", 
                    "0.021805749869574537", ",", " ", "0.04310534220294718", 
                    ",", " ", 
                    RowBox[{"-", "0.043105342202947185"}], ",", " ", 
                    "0.6970668958824399", ",", " ", 
                    RowBox[{"-", "0.7853981633974483"}], ",", " ", "\n", 
                    "                                ", "0.04361149973914906",
                     ",", " ", "0.03580557027218126", ",", " ", 
                    RowBox[{"-", "0.03580557027218126"}], ",", " ", 
                    "0.7153302277223883", ",", " ", 
                    RowBox[{"-", "1.5707963267948966"}], ",", " ", 
                    "0.04361149973914906", ",", " ", "0", ",", " ", "\n", 
                    "                                ", 
                    RowBox[{"-", "0.05063672308742165"}], ",", " ", 
                    "0.7153302277223883"}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.0002293961832682441", ",", " ", 
                    RowBox[{"-", "0.0005538113768028229"}], ",", " ", 
                    "0.0004780667427576441", ",", " ", 
                    "0.00037001878529315413", ",", " ", "\n", 
                    "                                ", "0.01483115281524039",
                     ",", " ", "0.", ",", " ", 
                    RowBox[{"-", "0.010609171920711452"}], ",", " ", 
                    "0.03580557027218126", ",", " ", "0.025612806736529395", 
                    ",", " ", "0.001813076746859659", ",", " ", 
                    "0.013351742176525891", ",", " ", "\n", 
                    "                                ", 
                    "0.015467184926617361", ",", " ", 
                    RowBox[{"-", "0.010334112331695944"}], ",", " ", "0", ",",
                     " ", "0", ",", " ", "0", ",", " ", "0", ",", " ", 
                    RowBox[{"-", "0.05063672308742165"}], ",", " ", 
                    "0.7153302277223883", ",", " ", "0.00041750282870259964", 
                    ",", " ", "0.0015234613279082312", ",", " ", "\n", 
                    "                                ", 
                    "0.0015020019563451233", ",", " ", 
                    "0.0015334633487699373", ",", " ", 
                    RowBox[{"-", "1.5707963267948966"}], ",", " ", 
                    "0.04361149973914906", ",", " ", "0", ",", " ", 
                    RowBox[{"-", "0.05063672308742165"}], ",", " ", 
                    "0.7153302277223883", ",", " ", "\n", 
                    "                                ", 
                    RowBox[{"-", "1.5707963267948966"}], ",", " ", 
                    "0.06541724960872358", ",", " ", "0", ",", " ", 
                    RowBox[{"-", "0.03728498091089576"}], ",", " ", 
                    "0.7307974126490057", ",", " ", 
                    RowBox[{"-", "0.7853981633974483"}], ",", " ", 
                    "0.04361149973914906", ",", " ", "0.03580557027218126", 
                    ",", " ", "\n", "                                ", 
                    RowBox[{"-", "0.03580557027218126"}], ",", " ", 
                    "0.7153302277223883"}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "0.0001689096725201308"}], ",", " ", 
                    "0.000407784022214093", ",", " ", 
                    RowBox[{"-", "0.0003520115104423216"}], ",", " ", 
                    RowBox[{"-", "0.00027245332053793786"}], ",", " ", "\n", 
                    "                                ", 
                    RowBox[{"-", "0.0014794106387144984"}], ",", " ", 
                    "0.015467184926617361", ",", " ", "0.0005044557722837448",
                     ",", " ", 
                    RowBox[{"-", "0.03580557027218126"}], ",", " ", 
                    RowBox[{"-", "0.026166618113332218"}], ",", " ", 
                    RowBox[{"-", "0.001335010004102015"}], ",", " ", "\n", 
                    "                                ", 
                    "0.009441107433675891", ",", " ", "0.015467184926617361", 
                    ",", " ", 
                    RowBox[{"-", "0.007307320907285728"}], ",", " ", 
                    RowBox[{"-", "0.009441107433675894"}], ",", " ", 
                    "0.007307320907285732", ",", " ", 
                    RowBox[{"-", "1.0842021724855044*^-19"}], ",", " ", "\n", 
                    "                                ", "0.03580557027218126",
                     ",", " ", 
                    RowBox[{"-", "0.03580557027218126"}], ",", " ", 
                    "0.7153302277223883", ",", " ", "0.0004175028287025997", 
                    ",", " ", "0.0008143426157323354", ",", " ", 
                    "0.0015234613279082312", ",", " ", "\n", 
                    "                                ", 
                    "0.001129124244231513", ",", " ", 
                    RowBox[{"-", "0.7853981633974483"}], ",", " ", 
                    "0.04361149973914906", ",", " ", "0.03580557027218126", 
                    ",", " ", 
                    RowBox[{"-", "0.03580557027218126"}], ",", " ", 
                    "0.7153302277223883", ",", " ", 
                    RowBox[{"-", "0.7853981633974483"}], ",", " ", "\n", 
                    "                                ", "0.06541724960872358",
                     ",", " ", "0.026364462838505364", ",", " ", 
                    RowBox[{"-", "0.026364462838505368"}], ",", " ", 
                    "0.7307974126490057", ",", " ", 
                    RowBox[{"-", "1.5707963267948966"}], ",", " ", 
                    "0.06541724960872358", ",", " ", "0", ",", " ", "\n", 
                    "                                ", 
                    RowBox[{"-", "0.03728498091089576"}], ",", " ", 
                    "0.7307974126490057"}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.0001176465210070976", ",", " ", 
                    RowBox[{"-", "0.00028402382658134287"}], ",", " ", 
                    "0.0004538468791385474", ",", " ", 
                    "0.0003422599479656013", ",", " ", "\n", 
                    "                                ", "0.01092051807239039",
                     ",", " ", "0.", ",", " ", 
                    RowBox[{"-", "0.007980686352089605"}], ",", " ", 
                    "0.026364462838505364", ",", " ", "0.01926708122826058", 
                    ",", " ", "0.000982998493659693", ",", " ", 
                    "0.01721434196928537", ",", " ", "\n", 
                    "                                ", 
                    "0.010772979837333385", ",", " ", 
                    RowBox[{"-", "0.012981866919197374"}], ",", " ", "0", ",",
                     " ", "0", ",", " ", "0", ",", " ", "0", ",", " ", 
                    RowBox[{"-", "0.03728498091089576"}], ",", " ", 
                    "0.7307974126490057", ",", " ", "0.0004123906640110913", 
                    ",", " ", "0.0008507542145836482", ",", " ", "\n", 
                    "                                ", 
                    "0.0008143426157323354", ",", " ", 
                    "0.0010963343060851128", ",", " ", 
                    RowBox[{"-", "1.5707963267948966"}], ",", " ", 
                    "0.06541724960872358", ",", " ", "0", ",", " ", 
                    RowBox[{"-", "0.03728498091089576"}], ",", " ", 
                    "0.7307974126490057", ",", " ", "\n", 
                    "                                ", 
                    RowBox[{"-", "1.5707963267948966"}], ",", " ", 
                    "0.0872229994782981", ",", " ", "0", ",", " ", 
                    RowBox[{"-", "0.02007063894161039"}], ",", " ", 
                    "0.741570392486339", ",", " ", 
                    RowBox[{"-", "0.7853981633974483"}], ",", " ", 
                    "0.06541724960872358", ",", " ", "0.026364462838505364", 
                    ",", " ", "\n", "                                ", 
                    RowBox[{"-", "0.026364462838505368"}], ",", " ", 
                    "0.7307974126490057"}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "0.00006332954418061636"}], ",", " ", 
                    "0.0001528910444597506", ",", " ", 
                    RowBox[{"-", "0.00024430740269749094"}], ",", " ", 
                    RowBox[{"-", "0.00018423975745645376"}], ",", " ", "\n", 
                    "                                ", 
                    "0.006293823896894979", ",", " ", "0.010772979837333385", 
                    ",", " ", 
                    RowBox[{"-", "0.0048835340461006755"}], ",", " ", 
                    RowBox[{"-", "0.026364462838505364"}], ",", " ", 
                    RowBox[{"-", "0.019551105054841922"}], ",", " ", 
                    RowBox[{"-", "0.0005291516145211457"}], ",", " ", "\n", 
                    "                                ", 
                    "0.012172377940145869", ",", " ", "0.010772979837333385", 
                    ",", " ", 
                    RowBox[{"-", "0.009179566131025777"}], ",", " ", 
                    RowBox[{"-", "0.012172377940145869"}], ",", " ", 
                    "0.009179566131025777", ",", " ", "0.", ",", " ", 
                    "0.026364462838505364", ",", " ", "\n", 
                    "                                ", 
                    RowBox[{"-", "0.026364462838505368"}], ",", " ", 
                    "0.7307974126490057", ",", " ", "0.00041239066401109123", 
                    ",", " ", "0.00023597267140166504", ",", " ", 
                    "0.0008507542145836482", ",", " ", 
                    "0.0005901606888125031", ",", " ", "\n", 
                    "                                ", 
                    RowBox[{"-", "0.7853981633974483"}], ",", " ", 
                    "0.06541724960872358", ",", " ", "0.026364462838505364", 
                    ",", " ", 
                    RowBox[{"-", "0.026364462838505368"}], ",", " ", 
                    "0.7307974126490057", ",", " ", 
                    RowBox[{"-", "0.7853981633974483"}], ",", " ", 
                    "0.0872229994782981", ",", " ", "\n", 
                    "                                ", 
                    "0.014192084898359495", ",", " ", 
                    RowBox[{"-", "0.014192084898359499"}], ",", " ", 
                    "0.741570392486339", ",", " ", 
                    RowBox[{"-", "1.5707963267948966"}], ",", " ", 
                    "0.0872229994782981", ",", " ", "0", ",", " ", 
                    RowBox[{"-", "0.02007063894161039"}], ",", " ", 
                    "0.741570392486339"}], "}"}], ",", " ", "\n", 
                    "                               ", 
                    RowBox[{"{", 
                    RowBox[{"0.000027215259766686165", ",", " ", 
                    RowBox[{"-", "0.00006570344923224371"}], ",", " ", 
                    "0.0002848442118236548", ",", " ", 
                    "0.00021255074416628837", ",", " ", "0.00587855404325089",
                     ",", " ", "0.", ",", " ", 
                    RowBox[{"-", "0.004359361629105718"}], ",", " ", "\n", 
                    "                                ", 
                    "0.014192084898359495", ",", " ", "0.010524429968275895", 
                    ",", " ", "0.0002848442118236548", ",", " ", 
                    "0.02007063894161039", ",", " ", "0.00462958400423874", 
                    ",", " ", 
                    RowBox[{"-", "0.014976710306380547"}], ",", " ", "0", ",",
                     " ", "0", ",", " ", "0", ",", " ", "0", ",", " ", "\n", 
                    "                                ", 
                    RowBox[{"-", "0.02007063894161039"}], ",", " ", 
                    "0.741570392486339", ",", " ", "0.00042426359557679055", 
                    ",", " ", "0.0004242635955767906", ",", " ", 
                    "0.00023597267140166504", ",", " ", 
                    "0.0005871757440992307", ",", " ", "\n", 
                    "                                ", 
                    RowBox[{"-", "1.5707963267948966"}], ",", " ", 
                    "0.0872229994782981", ",", " ", "0", ",", " ", 
                    RowBox[{"-", "0.02007063894161039"}], ",", " ", 
                    "0.741570392486339", ",", " ", 
                    RowBox[{"-", "1.5707963267948966"}], ",", " ", 
                    "0.10902874934787263", ",", " ", "0", ",", " ", "0", ",", 
                    " ", "\n", "                                ", 
                    "0.7461999764905778", ",", " ", 
                    RowBox[{"-", "0.7853981633974483"}], ",", " ", 
                    "0.0872229994782981", ",", " ", "0.014192084898359495", 
                    ",", " ", 
                    RowBox[{"-", "0.014192084898359499"}], ",", " ", 
                    "0.741570392486339"}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "0.", ",", " ", "0.", ",", " ", "0", ",", " ", "0", ",", 
                    " ", "\n", "                                ", 
                    "0.014192084898359499", ",", " ", "0.00462958400423874", 
                    ",", " ", 
                    RowBox[{"-", "0.010590133417508142"}], ",", " ", 
                    RowBox[{"-", "0.014192084898359495"}], ",", " ", 
                    RowBox[{"-", "0.010590133417508139"}], ",", " ", "0", ",",
                     " ", "0.014192084898359499", ",", " ", "\n", 
                    "                                ", "0.00462958400423874",
                     ",", " ", 
                    RowBox[{"-", "0.010590133417508142"}], ",", " ", 
                    RowBox[{"-", "0.014192084898359495"}], ",", " ", 
                    "0.010590133417508139", ",", " ", "0", ",", " ", 
                    "0.014192084898359495", ",", " ", 
                    RowBox[{"-", "0.014192084898359499"}], ",", " ", "\n", 
                    "                                ", "0.741570392486339", 
                    ",", " ", "0.0004242635955767906", ",", " ", "0.", ",", 
                    " ", "0.0004242635955767906", ",", " ", "0.", ",", " ", 
                    RowBox[{"-", "0.7853981633974483"}], ",", " ", 
                    "0.0872229994782981", ",", " ", "0.014192084898359495", 
                    ",", " ", "\n", "                                ", 
                    RowBox[{"-", "0.014192084898359499"}], ",", " ", 
                    "0.741570392486339", ",", " ", 
                    RowBox[{"-", "0.7853981633974483"}], ",", " ", 
                    "0.10902874934787263", ",", " ", "0", ",", " ", "0", ",", 
                    " ", "0.7461999764905778", ",", " ", 
                    RowBox[{"-", "1.5707963267948966"}], ",", " ", "\n", 
                    "                                ", "0.10902874934787263",
                     ",", " ", "0", ",", " ", "0", ",", " ", 
                    "0.7461999764905778"}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "0.", ",", " ", "0.", ",", " ", "0", ",", " ", "0", ",", 
                    " ", "0", ",", " ", "0.", ",", " ", "0", ",", " ", "0", 
                    ",", " ", "0", ",", " ", "0", ",", " ", 
                    RowBox[{"-", "0.014051862724930291"}], ",", " ", 
                    "0.0024195679317141616", ",", " ", "0.008755956665157808",
                     ",", " ", "\n", "                                ", 
                    "0.01405186272493029", ",", " ", 
                    RowBox[{"-", "0.008755956665157806"}], ",", " ", "0", ",",
                     " ", "0", ",", " ", "0", ",", " ", "0.6231171508403164", 
                    ",", " ", "0.00040076400105675024", ",", " ", 
                    "0.00040076400105675024", ",", " ", "0.", ",", " ", "0.", 
                    ",", " ", 
                    RowBox[{"-", "0.7853981633974483"}], ",", " ", "\n", 
                    "                                ", 
                    RowBox[{"-", "0.1090287493478726"}], ",", " ", "0", ",", 
                    " ", "0", ",", " ", "0.6231171508403164", ",", " ", 
                    RowBox[{"-", "0.7853981633974483"}], ",", " ", 
                    RowBox[{"-", "0.08722299947829808"}], ",", " ", 
                    "0.01405186272493029", ",", " ", 
                    RowBox[{"-", "0.014051862724930291"}], ",", " ", "\n", 
                    "                                ", "0.6255367187720305", 
                    ",", " ", "0", ",", " ", 
                    RowBox[{"-", "0.1090287493478726"}], ",", " ", "0", ",", 
                    " ", "0", ",", " ", "0.6231171508403164"}], "}"}], ",", 
                    " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "0.00003399943643008982"}], ",", " ", 
                    "0.000014083027682385701", ",", " ", 
                    "0.00027924332122646295", ",", " ", "\n", 
                    "                                ", 
                    "0.00017400130271382082", ",", " ", 
                    RowBox[{"-", "0.014051862724930291"}], ",", " ", 
                    "0.0024195679317141616", ",", " ", "0.008755956665157808",
                     ",", " ", "0.01405186272493029", ",", " ", 
                    "0.008755956665157806", ",", " ", "0", ",", " ", "0", ",",
                     " ", "\n", "                                ", 
                    "0.0024195679317141616", ",", " ", "0", ",", " ", 
                    "0.019872334842201373", ",", " ", 
                    RowBox[{"-", "0.012382792667417267"}], ",", " ", "0", ",",
                     " ", "0", ",", " ", "0", ",", " ", "0.6231171508403164", 
                    ",", " ", "0.00040076400105675024", ",", " ", 
                    "0.0002313327417082155", ",", " ", "\n", 
                    "                                ", 
                    "0.00040076400105675024", ",", " ", 
                    "0.0005633156337111628", ",", " ", "0", ",", " ", 
                    RowBox[{"-", "0.1090287493478726"}], ",", " ", "0", ",", 
                    " ", "0", ",", " ", "0.6231171508403164", ",", " ", "0", 
                    ",", " ", 
                    RowBox[{"-", "0.08722299947829808"}], ",", " ", 
                    "0.019872334842201373", ",", " ", "0", ",", " ", "\n", 
                    "                                ", "0.6255367187720305", 
                    ",", " ", 
                    RowBox[{"-", "0.7853981633974483"}], ",", " ", 
                    RowBox[{"-", "0.08722299947829808"}], ",", " ", 
                    "0.01405186272493029", ",", " ", 
                    RowBox[{"-", "0.014051862724930291"}], ",", " ", 
                    "0.6255367187720305"}], "}"}], ",", " ", "\n", 
                    "                               ", 
                    RowBox[{"{", 
                    RowBox[{"0.00010295013224607963", ",", " ", 
                    RowBox[{"-", "0.00004264334102442764"}], ",", " ", 
                    RowBox[{"-", "0.00029010153472220366"}], ",", " ", 
                    RowBox[{"-", "0.00017942330264081454"}], ",", " ", 
                    "0.014051862724930291", ",", " ", "0.", ",", " ", 
                    RowBox[{"-", "0.008789956101587898"}], ",", " ", "\n", 
                    "                                ", 
                    "0.005820472117271084", ",", " ", "0.003640919029941847", 
                    ",", " ", "0.00027924332122646295", ",", " ", 
                    RowBox[{"-", "0.014598261202107818"}], ",", " ", 
                    "0.007326440220870367", ",", " ", "0.009028798279897483", 
                    ",", " ", "\n", "                                ", 
                    "0.014598261202107816", ",", " ", 
                    RowBox[{"-", "0.009028798279897485"}], ",", " ", "0.", 
                    ",", " ", "0.01405186272493029", ",", " ", 
                    RowBox[{"-", "0.014051862724930291"}], ",", " ", 
                    "0.6255367187720305", ",", " ", "0.0004798951865599198", 
                    ",", " ", "\n", "                                ", 
                    "0.0009515559085625074", ",", " ", 
                    "0.0002313327417082155", ",", " ", 
                    "0.0006215338597739909", ",", " ", 
                    RowBox[{"-", "0.7853981633974483"}], ",", " ", 
                    RowBox[{"-", "0.08722299947829808"}], ",", " ", 
                    "0.01405186272493029", ",", " ", "\n", 
                    "                                ", 
                    RowBox[{"-", "0.014051862724930291"}], ",", " ", 
                    "0.6255367187720305", ",", " ", 
                    RowBox[{"-", "0.7853981633974483"}], ",", " ", 
                    RowBox[{"-", "0.06541724960872355"}], ",", " ", 
                    "0.028650123927038106", ",", " ", 
                    RowBox[{"-", "0.02865012392703811"}], ",", " ", 
                    "0.6328631589929009", ",", " ", "\n", 
                    "                                ", "0", ",", " ", 
                    RowBox[{"-", "0.08722299947829808"}], ",", " ", 
                    "0.019872334842201373", ",", " ", "0", ",", " ", 
                    "0.6255367187720305"}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "0.00020990342027197434"}], ",", " ", 
                    "0.00008694484346514954", ",", " ", 
                    "0.0005914834982318202", ",", " ", "\n", 
                    "                                ", 
                    "0.00036582337563956696", ",", " ", 
                    RowBox[{"-", "0.02865012392703811"}], ",", " ", 
                    "0.007326440220870367", ",", " ", "0.01792170451373146", 
                    ",", " ", "0.008777789084836733", ",", " ", 
                    "0.005345235908931208", ",", " ", "\n", 
                    "                                ", 
                    RowBox[{"-", "0.0005693448559486666"}], ",", " ", "0", 
                    ",", " ", "0.007326440220870367", ",", " ", "0", ",", " ",
                     "0.020645058979085838", ",", " ", 
                    RowBox[{"-", "0.012768648979361894"}], ",", " ", "0", ",",
                     " ", "0.019872334842201373", ",", " ", "0", ",", " ", 
                    "0.6255367187720305", ",", " ", "\n", 
                    "                                ", 
                    "0.0004798951865599198", ",", " ", 
                    "0.0009616616957775927", ",", " ", 
                    "0.0009515559085625074", ",", " ", 
                    "0.0012672357007717282", ",", " ", "0", ",", " ", 
                    RowBox[{"-", "0.08722299947829808"}], ",", " ", 
                    "0.019872334842201373", ",", " ", "0", ",", " ", "\n", 
                    "                                ", "0.6255367187720305", 
                    ",", " ", "0", ",", " ", 
                    RowBox[{"-", "0.06541724960872355"}], ",", " ", 
                    "0.04051739382128721", ",", " ", "0", ",", " ", 
                    "0.6328631589929009", ",", " ", 
                    RowBox[{"-", "0.7853981633974483"}], ",", " ", 
                    RowBox[{"-", "0.06541724960872355"}], ",", " ", "\n", 
                    "                                ", 
                    "0.028650123927038106", ",", " ", 
                    RowBox[{"-", "0.02865012392703811"}], ",", " ", 
                    "0.6328631589929009"}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.0003367053649617445", ",", " ", 
                    RowBox[{"-", "0.00013946792869093736"}], ",", " ", 
                    RowBox[{"-", "0.0005036849306382237"}], ",", " ", "\n", 
                    "                                ", 
                    RowBox[{"-", "0.0003051212124669312"}], ",", " ", 
                    "0.02865012392703811", ",", " ", "0.", ",", " ", 
                    RowBox[{"-", "0.018131607934003435"}], ",", " ", 
                    "0.011867269894249105", ",", " ", "0.007510357913895836", 
                    ",", " ", "0.0011608283541804868", ",", " ", "\n", 
                    "                                ", 
                    RowBox[{"-", "0.012431325984584806"}], ",", " ", 
                    "0.011752317924320854", ",", " ", "0.007530622868113131", 
                    ",", " ", "0.012431325984584803", ",", " ", 
                    RowBox[{"-", "0.007530622868113127"}], ",", " ", "0.", 
                    ",", " ", "0.028650123927038106", ",", " ", "\n", 
                    "                                ", 
                    RowBox[{"-", "0.02865012392703811"}], ",", " ", 
                    "0.6328631589929009", ",", " ", "0.0004471927080643399", 
                    ",", " ", "0.0018261206627085405", ",", " ", 
                    "0.0009616616957775927", ",", " ", 
                    "0.0012434151604020169", ",", " ", "\n", 
                    "                                ", 
                    RowBox[{"-", "0.7853981633974483"}], ",", " ", 
                    RowBox[{"-", "0.06541724960872355"}], ",", " ", 
                    "0.028650123927038106", ",", " ", 
                    RowBox[{"-", "0.02865012392703811"}], ",", " ", 
                    "0.6328631589929009", ",", " ", 
                    RowBox[{"-", "0.7853981633974483"}], ",", " ", 
                    RowBox[{"-", "0.04361149973914903"}], ",", " ", "\n", 
                    "                                ", "0.04108144991162291",
                     ",", " ", 
                    RowBox[{"-", "0.041081449911622915"}], ",", " ", 
                    "0.6446154769172218", ",", " ", "0", ",", " ", 
                    RowBox[{"-", "0.06541724960872355"}], ",", " ", 
                    "0.04051739382128721", ",", " ", "0", ",", " ", 
                    "0.6328631589929009"}], "}"}], ",", " ", "\n", 
                    "                               ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "0.00048280226015345526"}], ",", " ", 
                    "0.00019998324409994592", ",", " ", 
                    "0.0007222344762608717", ",", " ", 
                    "0.0004375137028675934", ",", " ", 
                    RowBox[{"-", "0.041081449911622915"}], ",", " ", 
                    "0.011752317924320854", ",", " ", "\n", 
                    "                                ", 
                    "0.025998936167078306", ",", " ", "0.0005640560903356975",
                     ",", " ", 
                    RowBox[{"-", "0.00011920297447364642"}], ",", " ", 
                    RowBox[{"-", "0.0016645132848187103"}], ",", " ", "0", 
                    ",", " ", "0.011752317924320854", ",", " ", "0", ",", " ",
                     "0.017580549805680898", ",", " ", "\n", 
                    "                                ", 
                    RowBox[{"-", "0.010649908993202561"}], ",", " ", "0", ",",
                     " ", "0.04051739382128721", ",", " ", "0", ",", " ", 
                    "0.6328631589929009", ",", " ", "0.00044719270806433986", 
                    ",", " ", "0.001977246585205565", ",", " ", 
                    "0.0018261206627085405", ",", " ", "\n", 
                    "                                ", 
                    "0.0017829346135288739", ",", " ", "0", ",", " ", 
                    RowBox[{"-", "0.06541724960872355"}], ",", " ", 
                    "0.04051739382128721", ",", " ", "0", ",", " ", 
                    "0.6328631589929009", ",", " ", "0", ",", " ", 
                    RowBox[{"-", "0.04361149973914903"}], ",", " ", 
                    "0.05809794362696811", ",", " ", "0", ",", " ", "\n", 
                    "                                ", "0.6446154769172218", 
                    ",", " ", 
                    RowBox[{"-", "0.7853981633974483"}], ",", " ", 
                    RowBox[{"-", "0.04361149973914903"}], ",", " ", 
                    "0.04108144991162291", ",", " ", 
                    RowBox[{"-", "0.041081449911622915"}], ",", " ", 
                    "0.6446154769172218"}], "}"}], ",", " ", "\n", 
                    "                               ", 
                    RowBox[{"{", 
                    RowBox[{"0.0006335407616358674", ",", " ", 
                    RowBox[{"-", "0.00026242117578575974"}], ",", " ", 
                    RowBox[{"-", "0.00039261647813520735"}], ",", " ", 
                    RowBox[{"-", "0.00021627924284377937"}], ",", " ", 
                    "0.041081449911622915", ",", " ", "0.", ",", " ", 
                    RowBox[{"-", "0.02648173842723176"}], ",", " ", "\n", 
                    "                                ", "0.0170164937153452", 
                    ",", " ", "0.010969095211776154", ",", " ", 
                    "0.002386747761079582", ",", " ", 
                    RowBox[{"-", "0.006757837775741189"}], ",", " ", 
                    "0.015421577451593893", ",", " ", "0.0037226660591027534",
                     ",", " ", "\n", "                                ", 
                    "0.006757837775741189", ",", " ", 
                    RowBox[{"-", "0.003722666059102757"}], ",", " ", "0.", 
                    ",", " ", "0.04108144991162291", ",", " ", 
                    RowBox[{"-", "0.041081449911622915"}], ",", " ", 
                    "0.6446154769172218", ",", " ", "0.00032916179390197846", 
                    ",", " ", "\n", "                                ", 
                    "0.0026316625192170685", ",", " ", "0.001977246585205565",
                     ",", " ", "0.0015803625774590193", ",", " ", 
                    RowBox[{"-", "0.7853981633974483"}], ",", " ", 
                    RowBox[{"-", "0.04361149973914903"}], ",", " ", 
                    "0.04108144991162291", ",", " ", "\n", 
                    "                                ", 
                    RowBox[{"-", "0.041081449911622915"}], ",", " ", 
                    "0.6446154769172218", ",", " ", 
                    RowBox[{"-", "0.7853981633974483"}], ",", " ", 
                    RowBox[{"-", "0.02180574986957451"}], ",", " ", 
                    "0.0478392876873641", ",", " ", 
                    RowBox[{"-", "0.047839287687364104"}], ",", " ", 
                    "0.6600370543688157", ",", " ", "\n", 
                    "                                ", "0", ",", " ", 
                    RowBox[{"-", "0.04361149973914903"}], ",", " ", 
                    "0.05809794362696811", ",", " ", "0", ",", " ", 
                    "0.6446154769172218"}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "0.0007377572802997681"}], ",", " ", 
                    "0.000305589071239655", ",", " ", "0.0004572013083451532",
                     ",", " ", "\n", "                                ", 
                    "0.0002518568585448478", ",", " ", 
                    RowBox[{"-", "0.047839287687364104"}], ",", " ", 
                    "0.015421577451593893", ",", " ", "0.030837945247970386", 
                    ",", " ", 
                    RowBox[{"-", "0.010258655939604011"}], ",", " ", 
                    RowBox[{"-", "0.007508850328459157"}], ",", " ", "\n", 
                    "                                ", 
                    RowBox[{"-", "0.0027793642392147893"}], ",", " ", "0", 
                    ",", " ", "0.015421577451593893", ",", " ", "0", ",", " ",
                     "0.009557025834770423", ",", " ", 
                    RowBox[{"-", "0.005264644828969121"}], ",", " ", "0", ",",
                     " ", "0.05809794362696811", ",", " ", "0", ",", " ", 
                    "0.6446154769172218", ",", " ", "\n", 
                    "                                ", 
                    "0.0003291617939019785", ",", " ", 
                    "0.0026812586906176617", ",", " ", 
                    "0.0026316625192170685", ",", " ", 
                    "0.0018403298850466385", ",", " ", "0", ",", " ", 
                    RowBox[{"-", "0.04361149973914903"}], ",", " ", 
                    "0.05809794362696811", ",", " ", "0", ",", " ", "\n", 
                    "                                ", "0.6446154769172218", 
                    ",", " ", "0", ",", " ", 
                    RowBox[{"-", "0.02180574986957451"}], ",", " ", 
                    "0.06765496946173853", ",", " ", "0", ",", " ", 
                    "0.6600370543688157", ",", " ", 
                    RowBox[{"-", "0.7853981633974483"}], ",", " ", 
                    RowBox[{"-", "0.02180574986957451"}], ",", " ", "\n", 
                    "                                ", "0.0478392876873641", 
                    ",", " ", 
                    RowBox[{"-", "0.047839287687364104"}], ",", " ", 
                    "0.6600370543688157"}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.0008603404557676955", ",", " ", 
                    RowBox[{"-", "0.0003563646850372245"}], ",", " ", 
                    RowBox[{"-", "2.182611829499269*^-6"}], ",", " ", "\n", 
                    "                                ", 
                    "0.00005676570257888772", ",", " ", 
                    "0.047839287687364104", ",", " ", "0.", ",", " ", 
                    RowBox[{"-", "0.031575702528270154"}], ",", " ", 
                    "0.019815681774374434", ",", " ", "0.01307908422866793", 
                    ",", " ", "0.0032365655475599425", ",", " ", "\n", 
                    "                                ", 
                    RowBox[{"-", "0.00003226092402176112"}], ",", " ", 
                    "0.017983972951063354", ",", " ", 
                    RowBox[{"-", "0.0008390470505051581"}], ",", " ", 
                    "0.00003226092402176112", ",", " ", 
                    "0.0008390470505051512", ",", " ", "0.", ",", " ", 
                    "0.0478392876873641", ",", " ", "\n", 
                    "                                ", 
                    RowBox[{"-", "0.047839287687364104"}], ",", " ", 
                    "0.6600370543688157", ",", " ", "0.00032342536463901583", 
                    ",", " ", "0.003006492190099027", ",", " ", 
                    "0.0026812586906176617", ",", " ", 
                    "0.0018624567134477475", ",", " ", "\n", 
                    "                                ", 
                    RowBox[{"-", "0.7853981633974483"}], ",", " ", 
                    RowBox[{"-", "0.02180574986957451"}], ",", " ", 
                    "0.0478392876873641", ",", " ", 
                    RowBox[{"-", "0.047839287687364104"}], ",", " ", 
                    "0.6600370543688157", ",", " ", 
                    RowBox[{"-", "0.7853981633974483"}], ",", " ", "0", ",", 
                    " ", "\n", "                                ", 
                    "0.04787154861138586", ",", " ", 
                    RowBox[{"-", "0.047871548611385865"}], ",", " ", 
                    "0.678021027319879", ",", " ", "0", ",", " ", 
                    RowBox[{"-", "0.02180574986957451"}], ",", " ", 
                    "0.06765496946173853", ",", " ", "0", ",", " ", 
                    "0.6600370543688157"}], "}"}], ",", " ", "\n", 
                    "                               ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "0.0008609206353526813"}], ",", " ", 
                    "0.0003566050032899424", ",", " ", 
                    "2.184083696615737*^-6", ",", " ", 
                    RowBox[{"-", "0.00005680398312415697"}], ",", " ", 
                    RowBox[{"-", "0.047871548611385865"}], ",", " ", 
                    "0.017983972951063354", ",", " ", "\n", 
                    "                                ", "0.03159699593353269",
                     ",", " ", 
                    RowBox[{"-", "0.019783420850352673"}], ",", " ", 
                    RowBox[{"-", "0.014274495964210307"}], ",", " ", 
                    RowBox[{"-", "0.0032387481593894422"}], ",", " ", "0", 
                    ",", " ", "0.017983972951063354", ",", " ", "0", ",", " ",
                     "0.0000456238362862571", ",", " ", "\n", 
                    "                                ", 
                    "0.0011865917182935365", ",", " ", "0", ",", " ", 
                    "0.06765496946173853", ",", " ", "0", ",", " ", 
                    "0.6600370543688157", ",", " ", "0.00032342536463901583", 
                    ",", " ", "0.0026848761796370037", ",", " ", 
                    "0.003006492190099027", ",", " ", "\n", 
                    "                                ", 
                    "0.0018637126806126214", ",", " ", "0", ",", " ", 
                    RowBox[{"-", "0.02180574986957451"}], ",", " ", 
                    "0.06765496946173853", ",", " ", "0", ",", " ", 
                    "0.6600370543688157", ",", " ", "0", ",", " ", "0", ",", 
                    " ", "0.06770059329802479", ",", " ", "0", ",", " ", 
                    "0.678021027319879", ",", " ", "\n", 
                    "                                ", 
                    RowBox[{"-", "0.7853981633974483"}], ",", " ", "0", ",", 
                    " ", "0.04787154861138586", ",", " ", 
                    RowBox[{"-", "0.047871548611385865"}], ",", " ", 
                    "0.678021027319879"}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.0009117552227386992", ",", " ", 
                    RowBox[{"-", "0.00037766137882287026"}], ",", " ", "\n", 
                    "                                ", 
                    "0.0003226750016321464", ",", " ", 
                    "0.00028050680561905457", ",", " ", 
                    "0.047871548611385865", ",", " ", "0.", ",", " ", 
                    RowBox[{"-", "0.03245791656888537"}], ",", " ", 
                    "0.01982904468663893", ",", " ", "0.013444509249206718", 
                    ",", " ", "\n", "                                ", 
                    "0.003240932243086058", ",", " ", "0.004766206408438681", 
                    ",", " ", "0.019045868562560853", ",", " ", 
                    RowBox[{"-", "0.0041433433882068806"}], ",", " ", 
                    RowBox[{"-", "0.004766206408438681"}], ",", " ", 
                    "0.0041433433882068806", ",", " ", "0.", ",", " ", "\n", 
                    "                                ", "0.04787154861138586",
                     ",", " ", 
                    RowBox[{"-", "0.047871548611385865"}], ",", " ", 
                    "0.678021027319879", ",", " ", "0.0004081785563580277", 
                    ",", " ", "0.00282574201216544", ",", " ", 
                    "0.0026848761796370037", ",", " ", "\n", 
                    "                                ", 
                    "0.0020765787824438445", ",", " ", 
                    RowBox[{"-", "0.7853981633974483"}], ",", " ", "0", ",", 
                    " ", "0.04787154861138586", ",", " ", 
                    RowBox[{"-", "0.047871548611385865"}], ",", " ", 
                    "0.678021027319879", ",", " ", 
                    RowBox[{"-", "0.7853981633974483"}], ",", " ", "\n", 
                    "                                ", 
                    "0.021805749869574537", ",", " ", "0.04310534220294718", 
                    ",", " ", 
                    RowBox[{"-", "0.043105342202947185"}], ",", " ", 
                    "0.6970668958824399", ",", " ", "0", ",", " ", "0", ",", 
                    " ", "0.06770059329802479", ",", " ", "0", ",", " ", 
                    "0.678021027319879"}], "}"}], ",", " ", "\n", 
                    "                               ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "0.000820978681941538"}], ",", " ", 
                    "0.0003400605044793746", ",", " ", 
                    RowBox[{"-", "0.00029054870312639203"}], ",", " ", 
                    RowBox[{"-", "0.0002525788740326874"}], ",", " ", 
                    RowBox[{"-", "0.043105342202947185"}], ",", " ", 
                    "0.019045868562560853", ",", " ", "\n", 
                    "                                ", 
                    "0.029226328403417188", ",", " ", 
                    RowBox[{"-", "0.02459525109507761"}], ",", " ", 
                    RowBox[{"-", "0.01796551401623647"}], ",", " ", 
                    RowBox[{"-", "0.002918257241453911"}], ",", " ", "0", ",",
                     " ", "0.019045868562560853", ",", " ", "0", ",", " ", 
                    RowBox[{"-", "0.006740433743883535"}], ",", " ", "\n", 
                    "                                ", "0.00585957241317106",
                     ",", " ", "0", ",", " ", "0.06770059329802479", ",", " ",
                     "0", ",", " ", "0.678021027319879", ",", " ", 
                    "0.0004081785563580276", ",", " ", "0.002176865029077681",
                     ",", " ", "0.00282574201216544", ",", " ", "\n", 
                    "                                ", 
                    "0.0018698296091330482", ",", " ", "0", ",", " ", "0", 
                    ",", " ", "0.06770059329802479", ",", " ", "0", ",", " ", 
                    "0.678021027319879", ",", " ", "0", ",", " ", 
                    "0.021805749869574537", ",", " ", "0.060960159554141254", 
                    ",", " ", "0", ",", " ", "0.6970668958824399", ",", " ", 
                    "\n", "                                ", 
                    RowBox[{"-", "0.7853981633974483"}], ",", " ", 
                    "0.021805749869574537", ",", " ", "0.04310534220294718", 
                    ",", " ", 
                    RowBox[{"-", "0.043105342202947185"}], ",", " ", 
                    "0.6970668958824399"}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "0.0007872471687269574", ",", " ", "\n", 
                    "                                ", 
                    RowBox[{"-", "0.0003260884542265266"}], ",", " ", 
                    "0.00044499526160833233", ",", " ", 
                    "0.00035818217870585596", ",", " ", 
                    "0.043105342202947185", ",", " ", "0.", ",", " ", 
                    RowBox[{"-", "0.030047307085358726"}], ",", " ", 
                    "0.017854817351194076", ",", " ", "\n", 
                    "                                ", 
                    "0.012446002107544783", ",", " ", "0.002627708538327519", 
                    ",", " ", "0.007299771930765926", ",", " ", 
                    "0.018263331839948438", ",", " ", 
                    RowBox[{"-", "0.005875676529155726"}], ",", " ", 
                    RowBox[{"-", "0.007299771930765919"}], ",", " ", "\n", 
                    "                                ", 
                    "0.0058756765291557225", ",", " ", 
                    "2.168404344971009*^-19", ",", " ", "0.04310534220294718",
                     ",", " ", 
                    RowBox[{"-", "0.043105342202947185"}], ",", " ", 
                    "0.6970668958824399", ",", " ", "0.0004401226303784705", 
                    ",", " ", "\n", "                                ", 
                    "0.002248341514356281", ",", " ", "0.002176865029077681", 
                    ",", " ", "0.001922615476378286", ",", " ", 
                    RowBox[{"-", "0.7853981633974483"}], ",", " ", 
                    "0.021805749869574537", ",", " ", "0.04310534220294718", 
                    ",", " ", "\n", "                                ", 
                    RowBox[{"-", "0.043105342202947185"}], ",", " ", 
                    "0.6970668958824399", ",", " ", 
                    RowBox[{"-", "0.7853981633974483"}], ",", " ", 
                    "0.04361149973914906", ",", " ", "0.03580557027218126", 
                    ",", " ", 
                    RowBox[{"-", "0.03580557027218126"}], ",", " ", 
                    "0.7153302277223883", ",", " ", "\n", 
                    "                                ", "0", ",", " ", 
                    "0.021805749869574537", ",", " ", "0.060960159554141254", 
                    ",", " ", "0", ",", " ", "0.6970668958824399"}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "0.0006539290115994377"}], ",", " ", 
                    "0.00027086626543372516", ",", " ", 
                    RowBox[{"-", "0.00036963652985952736"}], ",", " ", "\n", 
                    "                                ", 
                    RowBox[{"-", "0.00029752500535812115"}], ",", " ", 
                    RowBox[{"-", "0.03580557027218126"}], ",", " ", 
                    "0.018263331839948438", ",", " ", "0.024958877724929957", 
                    ",", " ", 
                    RowBox[{"-", "0.025154589281959995"}], ",", " ", 
                    RowBox[{"-", "0.01864776709092703"}], ",", " ", "\n", 
                    "                                ", 
                    RowBox[{"-", "0.0021827132767191864"}], ",", " ", "0", 
                    ",", " ", "0.018263331839948438", ",", " ", "0", ",", " ", 
                    RowBox[{"-", "0.010323436466719606"}], ",", " ", 
                    "0.008309461435649299", ",", " ", "0", ",", " ", 
                    "0.060960159554141254", ",", " ", "0", ",", " ", 
                    "0.6970668958824399", ",", " ", "\n", 
                    "                                ", 
                    "0.0004401226303784706", ",", " ", 
                    "0.0015020019563451233", ",", " ", "0.002248341514356281",
                     ",", " ", "0.0015970257983739943", ",", " ", "0", ",", 
                    " ", "0.021805749869574537", ",", " ", 
                    "0.060960159554141254", ",", " ", "0", ",", " ", "\n", 
                    "                                ", "0.6970668958824399", 
                    ",", " ", "0", ",", " ", "0.04361149973914906", ",", " ", 
                    "0.05063672308742165", ",", " ", "0", ",", " ", 
                    "0.7153302277223883", ",", " ", 
                    RowBox[{"-", "0.7853981633974483"}], ",", " ", 
                    "0.04361149973914906", ",", " ", "\n", 
                    "                                ", "0.03580557027218126",
                     ",", " ", 
                    RowBox[{"-", "0.03580557027218126"}], ",", " ", 
                    "0.7153302277223883"}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.0005538113768028194", ",", " ", 
                    RowBox[{"-", "0.0002293961832682441"}], ",", " ", 
                    "0.0004780667427576443", ",", " ", "\n", 
                    "                                ", 
                    "0.00037001878529315435", ",", " ", "0.03580557027218126",
                     ",", " ", "0.", ",", " ", 
                    RowBox[{"-", "0.025612806736529395"}], ",", " ", 
                    "0.01483115281524039", ",", " ", "0.010609171920711452", 
                    ",", " ", "0.001813076746859659", ",", " ", "\n", 
                    "                                ", 
                    "0.009441107433675891", ",", " ", "0.015467184926617361", 
                    ",", " ", 
                    RowBox[{"-", "0.007307320907285728"}], ",", " ", 
                    RowBox[{"-", "0.009441107433675894"}], ",", " ", 
                    "0.007307320907285732", ",", " ", 
                    RowBox[{"-", "1.0842021724855044*^-19"}], ",", " ", "\n", 
                    "                                ", "0.03580557027218126",
                     ",", " ", 
                    RowBox[{"-", "0.03580557027218126"}], ",", " ", 
                    "0.7153302277223883", ",", " ", "0.0004175028287025997", 
                    ",", " ", "0.0015234613279082314", ",", " ", 
                    "0.0015020019563451233", ",", " ", "\n", 
                    "                                ", 
                    "0.0015334633487699373", ",", " ", 
                    RowBox[{"-", "0.7853981633974483"}], ",", " ", 
                    "0.04361149973914906", ",", " ", "0.03580557027218126", 
                    ",", " ", 
                    RowBox[{"-", "0.03580557027218126"}], ",", " ", 
                    "0.7153302277223883", ",", " ", 
                    RowBox[{"-", "0.7853981633974483"}], ",", " ", "\n", 
                    "                                ", "0.06541724960872358",
                     ",", " ", "0.026364462838505364", ",", " ", 
                    RowBox[{"-", "0.026364462838505368"}], ",", " ", 
                    "0.7307974126490057", ",", " ", "0", ",", " ", 
                    "0.04361149973914906", ",", " ", "0.05063672308742165", 
                    ",", " ", "0", ",", " ", "\n", 
                    "                                ", 
                    "0.7153302277223883"}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "0.000407784022214093"}], ",", " ", 
                    "0.00016890967252013167", ",", " ", 
                    RowBox[{"-", "0.0003520115104423216"}], ",", " ", 
                    RowBox[{"-", "0.00027245332053793796"}], ",", " ", 
                    RowBox[{"-", "0.026364462838505368"}], ",", " ", "\n", 
                    "                                ", 
                    "0.015467184926617361", ",", " ", "0.01885929720604649", 
                    ",", " ", 
                    RowBox[{"-", "0.024272260248916284"}], ",", " ", 
                    RowBox[{"-", "0.01814588901126542"}], ",", " ", 
                    RowBox[{"-", "0.0013350100041020147"}], ",", " ", "0", 
                    ",", " ", "0.015467184926617361", ",", " ", "0", ",", " ",
                     "\n", "                                ", 
                    RowBox[{"-", "0.013351742176525891"}], ",", " ", 
                    "0.010334112331695944", ",", " ", "0", ",", " ", 
                    "0.05063672308742165", ",", " ", "0", ",", " ", 
                    "0.7153302277223883", ",", " ", "0.00041750282870259964", 
                    ",", " ", "0.0008143426157323357", ",", " ", "\n", 
                    "                                ", 
                    "0.0015234613279082314", ",", " ", 
                    "0.0011291242442315133", ",", " ", "0", ",", " ", 
                    "0.04361149973914906", ",", " ", "0.05063672308742165", 
                    ",", " ", "0", ",", " ", "0.7153302277223883", ",", " ", 
                    "0", ",", " ", "0.06541724960872358", ",", " ", "\n", 
                    "                                ", "0.03728498091089576",
                     ",", " ", "0", ",", " ", "0.7307974126490057", ",", " ", 
                    
                    RowBox[{"-", "0.7853981633974483"}], ",", " ", 
                    "0.06541724960872358", ",", " ", "0.026364462838505364", 
                    ",", " ", 
                    RowBox[{"-", "0.026364462838505368"}], ",", " ", "\n", 
                    "                                ", 
                    "0.7307974126490057"}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.00028402382658134287", ",", " ", 
                    RowBox[{"-", "0.0001176465210070976"}], ",", " ", 
                    "0.00045384687913854727", ",", " ", 
                    "0.00034225994796560134", ",", " ", 
                    "0.026364462838505368", ",", " ", "0.", ",", " ", "\n", 
                    "                                ", 
                    RowBox[{"-", "0.019267081228260582"}], ",", " ", 
                    "0.010920518072390393", ",", " ", "0.007980686352089608", 
                    ",", " ", "0.000982998493659693", ",", " ", 
                    "0.012172377940145869", ",", " ", "0.010772979837333385", 
                    ",", " ", "\n", "                                ", 
                    RowBox[{"-", "0.009179566131025777"}], ",", " ", 
                    RowBox[{"-", "0.012172377940145869"}], ",", " ", 
                    "0.009179566131025777", ",", " ", "0.", ",", " ", 
                    "0.026364462838505364", ",", " ", 
                    RowBox[{"-", "0.026364462838505368"}], ",", " ", 
                    "0.7307974126490057", ",", " ", "\n", 
                    "                                ", 
                    "0.00041239066401109123", ",", " ", 
                    "0.0008507542145836485", ",", " ", 
                    "0.0008143426157323357", ",", " ", "0.001096334306085113",
                     ",", " ", 
                    RowBox[{"-", "0.7853981633974483"}], ",", " ", 
                    "0.06541724960872358", ",", " ", "\n", 
                    "                                ", 
                    "0.026364462838505364", ",", " ", 
                    RowBox[{"-", "0.026364462838505368"}], ",", " ", 
                    "0.7307974126490057", ",", " ", 
                    RowBox[{"-", "0.7853981633974483"}], ",", " ", 
                    "0.0872229994782981", ",", " ", "0.014192084898359495", 
                    ",", " ", "\n", "                                ", 
                    RowBox[{"-", "0.014192084898359499"}], ",", " ", 
                    "0.741570392486339", ",", " ", "0", ",", " ", 
                    "0.06541724960872358", ",", " ", "0.03728498091089576", 
                    ",", " ", "0", ",", " ", "0.7307974126490057"}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "0.0001528910444597506"}], ",", " ", "\n", 
                    "                                ", 
                    "0.00006332954418061722", ",", " ", 
                    RowBox[{"-", "0.00024430740269749094"}], ",", " ", 
                    RowBox[{"-", "0.00018423975745645384"}], ",", " ", 
                    RowBox[{"-", "0.014192084898359499"}], ",", " ", 
                    "0.010772979837333385", ",", " ", "0.010371538923816148", 
                    ",", " ", "\n", "                                ", 
                    RowBox[{"-", "0.023092896012536262"}], ",", " ", 
                    RowBox[{"-", "0.01727789900412248"}], ",", " ", 
                    RowBox[{"-", "0.0005291516145211458"}], ",", " ", "0", 
                    ",", " ", "0.010772979837333385", ",", " ", "0", ",", " ", 
                    RowBox[{"-", "0.01721434196928537"}], ",", " ", 
                    "0.012981866919197374", ",", " ", "0", ",", " ", "\n", 
                    "                                ", "0.03728498091089576",
                     ",", " ", "0", ",", " ", "0.7307974126490057", ",", " ", 
                    "0.0004123906640110913", ",", " ", 
                    "0.00023597267140166515", ",", " ", 
                    "0.0008507542145836485", ",", " ", 
                    "0.0005901606888125033", ",", " ", "0", ",", " ", "\n", 
                    "                                ", "0.06541724960872358",
                     ",", " ", "0.03728498091089576", ",", " ", "0", ",", " ",
                     "0.7307974126490057", ",", " ", "0", ",", " ", 
                    "0.0872229994782981", ",", " ", "0.02007063894161039", 
                    ",", " ", "0", ",", " ", "0.741570392486339", ",", " ", 
                    "\n", "                                ", 
                    RowBox[{"-", "0.7853981633974483"}], ",", " ", 
                    "0.0872229994782981", ",", " ", "0.014192084898359495", 
                    ",", " ", 
                    RowBox[{"-", "0.014192084898359499"}], ",", " ", 
                    "0.741570392486339"}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "0.00006570344923224333", ",", " ", "\n", 
                    "                                ", 
                    RowBox[{"-", "0.000027215259766686165"}], ",", " ", 
                    "0.0002848442118236549", ",", " ", 
                    "0.00021255074416628842", ",", " ", 
                    "0.014192084898359499", ",", " ", "0.", ",", " ", 
                    RowBox[{"-", "0.010524429968275899"}], ",", " ", 
                    "0.0058785540432508936", ",", " ", "\n", 
                    "                                ", 
                    "0.0043593616291057215", ",", " ", 
                    "0.0002848442118236549", ",", " ", "0.014192084898359499",
                     ",", " ", "0.00462958400423874", ",", " ", 
                    RowBox[{"-", "0.010590133417508142"}], ",", " ", 
                    RowBox[{"-", "0.014192084898359495"}], ",", " ", "\n", 
                    "                                ", 
                    "0.010590133417508139", ",", " ", "0", ",", " ", 
                    "0.014192084898359495", ",", " ", 
                    RowBox[{"-", "0.014192084898359499"}], ",", " ", 
                    "0.741570392486339", ",", " ", "0.0004242635955767906", 
                    ",", " ", "0.00042426359557679055", ",", " ", "\n", 
                    "                                ", 
                    "0.00023597267140166515", ",", " ", 
                    "0.000587175744099231", ",", " ", 
                    RowBox[{"-", "0.7853981633974483"}], ",", " ", 
                    "0.0872229994782981", ",", " ", "0.014192084898359495", 
                    ",", " ", 
                    RowBox[{"-", "0.014192084898359499"}], ",", " ", "\n", 
                    "                                ", "0.741570392486339", 
                    ",", " ", 
                    RowBox[{"-", "0.7853981633974483"}], ",", " ", 
                    "0.10902874934787263", ",", " ", "0", ",", " ", "0", ",", 
                    " ", "0.7461999764905778", ",", " ", "0", ",", " ", 
                    "0.0872229994782981", ",", " ", "0.02007063894161039", 
                    ",", " ", "0", ",", " ", "\n", 
                    "                                ", "0.741570392486339"}],
                     "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "0", ",", " ", "0.", ",", " ", "0", ",", " ", "0", ",", 
                    " ", "0", ",", " ", "0.00462958400423874", ",", " ", "0", 
                    ",", " ", 
                    RowBox[{"-", "0.02007063894161039"}], ",", " ", 
                    RowBox[{"-", "0.014976710306380547"}], ",", " ", "0", ",",
                     " ", "0", ",", " ", "0.00462958400423874", ",", " ", "0",
                     ",", " ", "\n", "                                ", 
                    RowBox[{"-", "0.02007063894161039"}], ",", " ", 
                    "0.014976710306380547", ",", " ", "0", ",", " ", 
                    "0.02007063894161039", ",", " ", "0", ",", " ", 
                    "0.741570392486339", ",", " ", "0.00042426359557679055", 
                    ",", " ", "0.", ",", " ", "0.00042426359557679055", ",", 
                    " ", "0.", ",", " ", "0", ",", " ", "\n", 
                    "                                ", "0.0872229994782981", 
                    ",", " ", "0.02007063894161039", ",", " ", "0", ",", " ", 
                    "0.741570392486339", ",", " ", "0", ",", " ", 
                    "0.10902874934787263", ",", " ", "0", ",", " ", "0", ",", 
                    " ", "0.7461999764905778", ",", " ", 
                    RowBox[{"-", "0.7853981633974483"}], ",", " ", "\n", 
                    "                                ", "0.10902874934787263",
                     ",", " ", "0", ",", " ", "0", ",", " ", 
                    "0.7461999764905778"}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "0", ",", " ", "0.", ",", " ", "0", ",", " ", "0", ",", 
                    " ", "0", ",", " ", "0.", ",", " ", "0", ",", " ", "0", 
                    ",", " ", "0", ",", " ", "0", ",", " ", "0", ",", " ", 
                    "0.0024195679317141616", ",", " ", "0", ",", " ", 
                    "0.019872334842201373", ",", " ", "\n", 
                    "                                ", 
                    RowBox[{"-", "0.012382792667417267"}], ",", " ", "0", ",",
                     " ", "0", ",", " ", "0", ",", " ", "0.6231171508403164", 
                    ",", " ", "0.00040076400105675024", ",", " ", 
                    "0.00040076400105675024", ",", " ", "0.", ",", " ", "0.", 
                    ",", " ", "0", ",", " ", 
                    RowBox[{"-", "0.1090287493478726"}], ",", " ", "0", ",", 
                    " ", "0", ",", " ", "\n", 
                    "                                ", "0.6231171508403164", 
                    ",", " ", "0", ",", " ", 
                    RowBox[{"-", "0.08722299947829808"}], ",", " ", 
                    "0.019872334842201373", ",", " ", "0", ",", " ", 
                    "0.6255367187720305", ",", " ", "0.7853981633974483", ",",
                     " ", 
                    RowBox[{"-", "0.1090287493478726"}], ",", " ", "0", ",", 
                    " ", "0", ",", " ", "\n", 
                    "                                ", 
                    "0.6231171508403164"}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "0.00003399943643008982"}], ",", " ", 
                    RowBox[{"-", "0.000014083027682385701"}], ",", " ", 
                    "0.00027924332122646295", ",", " ", 
                    "0.00017400130271382082", ",", " ", "0", ",", " ", 
                    "0.0024195679317141616", ",", " ", "0", ",", " ", "\n", 
                    "                                ", 
                    "0.019872334842201373", ",", " ", "0.012382792667417267", 
                    ",", " ", "0", ",", " ", "0.014051862724930291", ",", " ",
                     "0.0024195679317141616", ",", " ", 
                    RowBox[{"-", "0.008755956665157808"}], ",", " ", 
                    "0.01405186272493029", ",", " ", "\n", 
                    "                                ", 
                    RowBox[{"-", "0.008755956665157806"}], ",", " ", "0", ",",
                     " ", "0", ",", " ", "0", ",", " ", "0.6231171508403164", 
                    ",", " ", "0.00040076400105675024", ",", " ", 
                    "0.0002313327417082155", ",", " ", 
                    "0.00040076400105675024", ",", " ", 
                    "0.0005633156337111628", ",", " ", "\n", 
                    "                                ", "0.7853981633974483", 
                    ",", " ", 
                    RowBox[{"-", "0.1090287493478726"}], ",", " ", "0", ",", 
                    " ", "0", ",", " ", "0.6231171508403164", ",", " ", 
                    "0.7853981633974483", ",", " ", 
                    RowBox[{"-", "0.08722299947829808"}], ",", " ", 
                    "0.01405186272493029", ",", " ", "\n", 
                    "                                ", 
                    "0.014051862724930291", ",", " ", "0.6255367187720305", 
                    ",", " ", "0", ",", " ", 
                    RowBox[{"-", "0.08722299947829808"}], ",", " ", 
                    "0.019872334842201373", ",", " ", "0", ",", " ", 
                    "0.6255367187720305"}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "0.00010295013224607963", ",", " ", "\n", 
                    "                                ", 
                    "0.000042643341024429376", ",", " ", 
                    RowBox[{"-", "0.00029010153472220366"}], ",", " ", 
                    RowBox[{"-", "0.00017942330264081454"}], ",", " ", 
                    "0.014051862724930291", ",", " ", "0.", ",", " ", 
                    RowBox[{"-", "0.008789956101587898"}], ",", " ", 
                    RowBox[{"-", "0.005820472117271084"}], ",", " ", "\n", 
                    "                                ", 
                    RowBox[{"-", "0.003640919029941847"}], ",", " ", 
                    "0.00027924332122646295", ",", " ", "0", ",", " ", 
                    "0.007326440220870367", ",", " ", "0", ",", " ", 
                    "0.020645058979085838", ",", " ", 
                    RowBox[{"-", "0.012768648979361894"}], ",", " ", "0", ",",
                     " ", "0.019872334842201373", ",", " ", "0", ",", " ", 
                    "\n", "                                ", 
                    "0.6255367187720305", ",", " ", "0.0004798951865599198", 
                    ",", " ", "0.0009515559085625077", ",", " ", 
                    "0.0002313327417082155", ",", " ", 
                    "0.0006215338597739907", ",", " ", "0", ",", " ", 
                    RowBox[{"-", "0.08722299947829808"}], ",", " ", "\n", 
                    "                                ", 
                    "0.019872334842201373", ",", " ", "0", ",", " ", 
                    "0.6255367187720305", ",", " ", "0", ",", " ", 
                    RowBox[{"-", "0.06541724960872355"}], ",", " ", 
                    "0.04051739382128721", ",", " ", "0", ",", " ", 
                    "0.6328631589929009", ",", " ", "0.7853981633974483", ",",
                     " ", "\n", "                                ", 
                    RowBox[{"-", "0.08722299947829808"}], ",", " ", 
                    "0.01405186272493029", ",", " ", "0.014051862724930291", 
                    ",", " ", "0.6255367187720305"}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "0.00020990342027197434"}], ",", " ", 
                    RowBox[{"-", "0.00008694484346514954"}], ",", " ", "\n", 
                    "                                ", 
                    "0.0005914834982318202", ",", " ", "0.000365823375639567",
                     ",", " ", 
                    RowBox[{"-", "0.014051862724930291"}], ",", " ", 
                    "0.007326440220870367", ",", " ", "0.008892906233833977", 
                    ",", " ", "0.026465531096356923", ",", " ", "\n", 
                    "                                ", "0.01645221135032817",
                     ",", " ", 
                    RowBox[{"-", "0.0005693448559486666"}], ",", " ", 
                    "0.014598261202107818", ",", " ", "0.007326440220870367", 
                    ",", " ", 
                    RowBox[{"-", "0.009028798279897483"}], ",", " ", 
                    "0.014598261202107816", ",", " ", "\n", 
                    "                                ", 
                    RowBox[{"-", "0.009028798279897485"}], ",", " ", "0.", 
                    ",", " ", "0.01405186272493029", ",", " ", 
                    "0.014051862724930291", ",", " ", "0.6255367187720305", 
                    ",", " ", "0.0004798951865599198", ",", " ", 
                    "0.0009616616957775927", ",", " ", "\n", 
                    "                                ", 
                    "0.0009515559085625077", ",", " ", 
                    "0.0012672357007717284", ",", " ", "0.7853981633974483", 
                    ",", " ", 
                    RowBox[{"-", "0.08722299947829808"}], ",", " ", 
                    "0.01405186272493029", ",", " ", "0.014051862724930291", 
                    ",", " ", "\n", "                                ", 
                    "0.6255367187720305", ",", " ", "0.7853981633974483", ",",
                     " ", 
                    RowBox[{"-", "0.06541724960872355"}], ",", " ", 
                    "0.028650123927038106", ",", " ", "0.02865012392703811", 
                    ",", " ", "0.6328631589929009", ",", " ", "0", ",", " ", 
                    RowBox[{"-", "0.06541724960872355"}], ",", " ", "\n", 
                    "                                ", "0.04051739382128721",
                     ",", " ", "0", ",", " ", "0.6328631589929009"}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "0.00033670536496174103", ",", " ", 
                    "0.0001394679286909374", ",", " ", 
                    RowBox[{"-", "0.0005036849306382233"}], ",", " ", 
                    RowBox[{"-", "0.000305121212466931"}], ",", " ", "\n", 
                    "                                ", "0.02865012392703811",
                     ",", " ", "0.", ",", " ", 
                    RowBox[{"-", "0.018131607934003435"}], ",", " ", 
                    RowBox[{"-", "0.011867269894249105"}], ",", " ", 
                    RowBox[{"-", "0.007510357913895836"}], ",", " ", 
                    "0.0011608283541804868", ",", " ", "0", ",", " ", 
                    "0.011752317924320854", ",", " ", "0", ",", " ", "\n", 
                    "                                ", 
                    "0.017580549805680898", ",", " ", 
                    RowBox[{"-", "0.010649908993202561"}], ",", " ", "0", ",",
                     " ", "0.04051739382128721", ",", " ", "0", ",", " ", 
                    "0.6328631589929009", ",", " ", "0.00044719270806433986", 
                    ",", " ", "0.0018261206627085403", ",", " ", "\n", 
                    "                                ", 
                    "0.0009616616957775927", ",", " ", 
                    "0.0012434151604020164", ",", " ", "0", ",", " ", 
                    RowBox[{"-", "0.06541724960872355"}], ",", " ", 
                    "0.04051739382128721", ",", " ", "0", ",", " ", 
                    "0.6328631589929009", ",", " ", "0", ",", " ", 
                    RowBox[{"-", "0.04361149973914903"}], ",", " ", "\n", 
                    "                                ", "0.05809794362696811",
                     ",", " ", "0", ",", " ", "0.6446154769172218", ",", " ", 
                    "0.7853981633974483", ",", " ", 
                    RowBox[{"-", "0.06541724960872355"}], ",", " ", 
                    "0.028650123927038106", ",", " ", "0.02865012392703811", 
                    ",", " ", "0.6328631589929009"}], "}"}], ",", " ", "\n", 
                    "                               ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "0.00048280226015345526"}], ",", " ", 
                    RowBox[{"-", "0.00019998324409994592"}], ",", " ", 
                    "0.0007222344762608719", ",", " ", 
                    "0.0004375137028675933", ",", " ", 
                    RowBox[{"-", "0.02865012392703811"}], ",", " ", 
                    "0.011752317924320854", ",", " ", "\n", 
                    "                                ", 
                    "0.018468313298965176", ",", " ", "0.029447819699930003", 
                    ",", " ", "0.018299734835789335", ",", " ", 
                    RowBox[{"-", "0.0016645132848187101"}], ",", " ", 
                    "0.012431325984584806", ",", " ", "0.011752317924320854", 
                    ",", " ", "\n", "                                ", 
                    RowBox[{"-", "0.007530622868113131"}], ",", " ", 
                    "0.012431325984584803", ",", " ", 
                    RowBox[{"-", "0.007530622868113127"}], ",", " ", "0.", 
                    ",", " ", "0.028650123927038106", ",", " ", 
                    "0.02865012392703811", ",", " ", "0.6328631589929009", 
                    ",", " ", "\n", "                                ", 
                    "0.0004471927080643399", ",", " ", "0.001977246585205565",
                     ",", " ", "0.0018261206627085403", ",", " ", 
                    "0.0017829346135288739", ",", " ", "0.7853981633974483", 
                    ",", " ", 
                    RowBox[{"-", "0.06541724960872355"}], ",", " ", "\n", 
                    "                                ", 
                    "0.028650123927038106", ",", " ", "0.02865012392703811", 
                    ",", " ", "0.6328631589929009", ",", " ", 
                    "0.7853981633974483", ",", " ", 
                    RowBox[{"-", "0.04361149973914903"}], ",", " ", 
                    "0.04108144991162291", ",", " ", "0.041081449911622915", 
                    ",", " ", "\n", "                                ", 
                    "0.6446154769172218", ",", " ", "0", ",", " ", 
                    RowBox[{"-", "0.04361149973914903"}], ",", " ", 
                    "0.05809794362696811", ",", " ", "0", ",", " ", 
                    "0.6446154769172218"}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "0.0006335407616358708", ",", " ", 
                    "0.00026242117578575974", ",", " ", "\n", 
                    "                                ", 
                    RowBox[{"-", "0.00039261647813520735"}], ",", " ", 
                    RowBox[{"-", "0.00021627924284377937"}], ",", " ", 
                    "0.041081449911622915", ",", " ", "0.", ",", " ", 
                    RowBox[{"-", "0.02648173842723176"}], ",", " ", 
                    RowBox[{"-", "0.0170164937153452"}], ",", " ", 
                    RowBox[{"-", "0.010969095211776154"}], ",", " ", "\n", 
                    "                                ", 
                    "0.002386747761079582", ",", " ", "0", ",", " ", 
                    "0.015421577451593893", ",", " ", "0", ",", " ", 
                    "0.009557025834770423", ",", " ", 
                    RowBox[{"-", "0.005264644828969121"}], ",", " ", "0", ",",
                     " ", "0.05809794362696811", ",", " ", "0", ",", " ", 
                    "0.6446154769172218", ",", " ", "\n", 
                    "                                ", 
                    "0.0003291617939019785", ",", " ", 
                    "0.0026316625192170685", ",", " ", "0.001977246585205565",
                     ",", " ", "0.0015803625774590193", ",", " ", "0", ",", 
                    " ", 
                    RowBox[{"-", "0.04361149973914903"}], ",", " ", 
                    "0.05809794362696811", ",", " ", "0", ",", " ", "\n", 
                    "                                ", "0.6446154769172218", 
                    ",", " ", "0", ",", " ", 
                    RowBox[{"-", "0.02180574986957451"}], ",", " ", 
                    "0.06765496946173853", ",", " ", "0", ",", " ", 
                    "0.6600370543688157", ",", " ", "0.7853981633974483", ",",
                     " ", 
                    RowBox[{"-", "0.04361149973914903"}], ",", " ", "\n", 
                    "                                ", "0.04108144991162291",
                     ",", " ", "0.041081449911622915", ",", " ", 
                    "0.6446154769172218"}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "0.0007377572802997681"}], ",", " ", 
                    RowBox[{"-", "0.000305589071239655"}], ",", " ", 
                    "0.0004572013083451532", ",", " ", "\n", 
                    "                                ", 
                    "0.0002518568585448476", ",", " ", 
                    RowBox[{"-", "0.041081449911622915"}], ",", " ", 
                    "0.015421577451593893", ",", " ", "0.027115279188867632", 
                    ",", " ", "0.026573519550115623", ",", " ", 
                    "0.016496161216531035", ",", " ", "\n", 
                    "                                ", 
                    RowBox[{"-", "0.0027793642392147893"}], ",", " ", 
                    "0.006757837775741189", ",", " ", "0.015421577451593893", 
                    ",", " ", 
                    RowBox[{"-", "0.0037226660591027534"}], ",", " ", 
                    "0.006757837775741189", ",", " ", 
                    RowBox[{"-", "0.003722666059102757"}], ",", " ", "0.", 
                    ",", " ", "\n", "                                ", 
                    "0.04108144991162291", ",", " ", "0.041081449911622915", 
                    ",", " ", "0.6446154769172218", ",", " ", 
                    "0.00032916179390197846", ",", " ", 
                    "0.0026812586906176617", ",", " ", 
                    "0.0026316625192170685", ",", " ", "\n", 
                    "                                ", 
                    "0.0018403298850466385", ",", " ", "0.7853981633974483", 
                    ",", " ", 
                    RowBox[{"-", "0.04361149973914903"}], ",", " ", 
                    "0.04108144991162291", ",", " ", "0.041081449911622915", 
                    ",", " ", "0.6446154769172218", ",", " ", 
                    "0.7853981633974483", ",", " ", "\n", 
                    "                                ", 
                    RowBox[{"-", "0.02180574986957451"}], ",", " ", 
                    "0.0478392876873641", ",", " ", "0.047839287687364104", 
                    ",", " ", "0.6600370543688157", ",", " ", "0", ",", " ", 
                    RowBox[{"-", "0.02180574986957451"}], ",", " ", 
                    "0.06765496946173853", ",", " ", "0", ",", " ", "\n", 
                    "                                ", 
                    "0.6600370543688157"}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "0.0008603404557676955", ",", " ", 
                    "0.00035636468503722797", ",", " ", 
                    RowBox[{"-", "2.1826118294997025*^-6"}], ",", " ", 
                    "0.00005676570257888815", ",", " ", 
                    "0.047839287687364104", ",", " ", "0.", ",", " ", "\n", 
                    "                                ", 
                    RowBox[{"-", "0.031575702528270154"}], ",", " ", 
                    RowBox[{"-", "0.019815681774374434"}], ",", " ", 
                    RowBox[{"-", "0.01307908422866793"}], ",", " ", 
                    "0.0032365655475599425", ",", " ", "0", ",", " ", 
                    "0.017983972951063354", ",", " ", "0", ",", " ", 
                    "0.0000456238362862571", ",", " ", "\n", 
                    "                                ", 
                    "0.0011865917182935365", ",", " ", "0", ",", " ", 
                    "0.06765496946173853", ",", " ", "0", ",", " ", 
                    "0.6600370543688157", ",", " ", "0.00032342536463901583", 
                    ",", " ", "0.0030064921900990267", ",", " ", 
                    "0.0026812586906176617", ",", " ", "\n", 
                    "                                ", 
                    "0.0018624567134477475", ",", " ", "0", ",", " ", 
                    RowBox[{"-", "0.02180574986957451"}], ",", " ", 
                    "0.06765496946173853", ",", " ", "0", ",", " ", 
                    "0.6600370543688157", ",", " ", "0", ",", " ", "0", ",", 
                    " ", "0.06770059329802479", ",", " ", "0", ",", " ", 
                    "0.678021027319879", ",", " ", "\n", 
                    "                                ", "0.7853981633974483", 
                    ",", " ", 
                    RowBox[{"-", "0.02180574986957451"}], ",", " ", 
                    "0.0478392876873641", ",", " ", "0.047839287687364104", 
                    ",", " ", "0.6600370543688157"}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "0.0008609206353526813"}], ",", " ", "\n", 
                    "                                ", 
                    RowBox[{"-", "0.0003566050032899424"}], ",", " ", 
                    "2.184083696615737*^-6", ",", " ", 
                    RowBox[{"-", "0.00005680398312415697"}], ",", " ", 
                    RowBox[{"-", "0.047839287687364104"}], ",", " ", 
                    "0.017983972951063354", ",", " ", "0.03243604298403785", 
                    ",", " ", "\n", "                                ", 
                    "0.01986130561066069", ",", " ", "0.01224885719541162", 
                    ",", " ", 
                    RowBox[{"-", "0.0032387481593894422"}], ",", " ", 
                    "0.00003226092402176112", ",", " ", 
                    "0.017983972951063354", ",", " ", "0.0008390470505051581",
                     ",", " ", "\n", "                                ", 
                    "0.00003226092402176112", ",", " ", 
                    "0.0008390470505051512", ",", " ", "0.", ",", " ", 
                    "0.0478392876873641", ",", " ", "0.047839287687364104", 
                    ",", " ", "0.6600370543688157", ",", " ", 
                    "0.00032342536463901583", ",", " ", "\n", 
                    "                                ", 
                    "0.0026848761796370037", ",", " ", 
                    "0.0030064921900990267", ",", " ", 
                    "0.0018637126806126225", ",", " ", "0.7853981633974483", 
                    ",", " ", 
                    RowBox[{"-", "0.02180574986957451"}], ",", " ", 
                    "0.0478392876873641", ",", " ", "\n", 
                    "                                ", 
                    "0.047839287687364104", ",", " ", "0.6600370543688157", 
                    ",", " ", "0.7853981633974483", ",", " ", "0", ",", " ", 
                    "0.04787154861138586", ",", " ", "0.047871548611385865", 
                    ",", " ", "0.678021027319879", ",", " ", "0", ",", " ", 
                    "0", ",", " ", "\n", "                                ", 
                    "0.06770059329802479", ",", " ", "0", ",", " ", 
                    "0.678021027319879"}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "0.0009117552227386957", ",", " ", "0.000377661378822872",
                     ",", " ", "0.0003226750016321464", ",", " ", 
                    "0.0002805068056190539", ",", " ", "\n", 
                    "                                ", 
                    "0.047871548611385865", ",", " ", "0.", ",", " ", 
                    RowBox[{"-", "0.03245791656888537"}], ",", " ", 
                    RowBox[{"-", "0.01982904468663893"}], ",", " ", 
                    RowBox[{"-", "0.013444509249206718"}], ",", " ", 
                    "0.003240932243086058", ",", " ", "0", ",", " ", 
                    "0.019045868562560853", ",", " ", "0", ",", " ", "\n", 
                    "                                ", 
                    RowBox[{"-", "0.006740433743883535"}], ",", " ", 
                    "0.00585957241317106", ",", " ", "0", ",", " ", 
                    "0.06770059329802479", ",", " ", "0", ",", " ", 
                    "0.678021027319879", ",", " ", "0.0004081785563580276", 
                    ",", " ", "0.00282574201216544", ",", " ", "\n", 
                    "                                ", 
                    "0.0026848761796370037", ",", " ", 
                    "0.0020765787824438445", ",", " ", "0", ",", " ", "0", 
                    ",", " ", "0.06770059329802479", ",", " ", "0", ",", " ", 
                    "0.678021027319879", ",", " ", "0", ",", " ", 
                    "0.021805749869574537", ",", " ", "0.060960159554141254", 
                    ",", " ", "0", ",", " ", "\n", 
                    "                                ", "0.6970668958824399", 
                    ",", " ", "0.7853981633974483", ",", " ", "0", ",", " ", 
                    "0.04787154861138586", ",", " ", "0.047871548611385865", 
                    ",", " ", "0.678021027319879"}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "0.000820978681941538"}], ",", " ", "\n", 
                    "                                ", 
                    RowBox[{"-", "0.0003400605044793746"}], ",", " ", 
                    RowBox[{"-", "0.00029054870312639246"}], ",", " ", 
                    RowBox[{"-", "0.00025257887403268785"}], ",", " ", 
                    RowBox[{"-", "0.047871548611385865"}], ",", " ", 
                    "0.019045868562560853", ",", " ", "0.03336967179162407", 
                    ",", " ", "\n", "                                ", 
                    "0.013088610942755395", ",", " ", "0.007962598214858528", 
                    ",", " ", 
                    RowBox[{"-", "0.0029182572414539116"}], ",", " ", 
                    RowBox[{"-", "0.004766206408438681"}], ",", " ", 
                    "0.019045868562560853", ",", " ", "0.0041433433882068806",
                     ",", " ", "\n", "                                ", 
                    RowBox[{"-", "0.004766206408438681"}], ",", " ", 
                    "0.0041433433882068806", ",", " ", "0.", ",", " ", 
                    "0.04787154861138586", ",", " ", "0.047871548611385865", 
                    ",", " ", "0.678021027319879", ",", " ", 
                    "0.0004081785563580277", ",", " ", "\n", 
                    "                                ", 
                    "0.002176865029077681", ",", " ", "0.00282574201216544", 
                    ",", " ", "0.0018698296091330482", ",", " ", 
                    "0.7853981633974483", ",", " ", "0", ",", " ", 
                    "0.04787154861138586", ",", " ", "0.047871548611385865", 
                    ",", " ", "\n", "                                ", 
                    "0.678021027319879", ",", " ", "0.7853981633974483", ",", 
                    " ", "0.021805749869574537", ",", " ", 
                    "0.04310534220294718", ",", " ", "0.043105342202947185", 
                    ",", " ", "0.6970668958824399", ",", " ", "0", ",", " ", 
                    "0.021805749869574537", ",", " ", "\n", 
                    "                                ", 
                    "0.060960159554141254", ",", " ", "0", ",", " ", 
                    "0.6970668958824399"}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "0.0007872471687269574", ",", " ", 
                    "0.0003260884542265292", ",", " ", 
                    "0.00044499526160833277", ",", " ", 
                    "0.00035818217870585596", ",", " ", "\n", 
                    "                                ", 
                    "0.043105342202947185", ",", " ", "0.", ",", " ", 
                    RowBox[{"-", "0.030047307085358726"}], ",", " ", 
                    RowBox[{"-", "0.017854817351194076"}], ",", " ", 
                    RowBox[{"-", "0.012446002107544783"}], ",", " ", 
                    "0.002627708538327519", ",", " ", "0", ",", " ", 
                    "0.018263331839948438", ",", " ", "0", ",", " ", "\n", 
                    "                                ", 
                    RowBox[{"-", "0.010323436466719606"}], ",", " ", 
                    "0.008309461435649299", ",", " ", "0", ",", " ", 
                    "0.060960159554141254", ",", " ", "0", ",", " ", 
                    "0.6970668958824399", ",", " ", "0.0004401226303784706", 
                    ",", " ", "0.0022483415143562816", ",", " ", "\n", 
                    "                                ", 
                    "0.002176865029077681", ",", " ", "0.0019226154763782863",
                     ",", " ", "0", ",", " ", "0.021805749869574537", ",", 
                    " ", "0.060960159554141254", ",", " ", "0", ",", " ", 
                    "0.6970668958824399", ",", " ", "0", ",", " ", 
                    "0.04361149973914906", ",", " ", "\n", 
                    "                                ", "0.05063672308742165",
                     ",", " ", "0", ",", " ", "0.7153302277223883", ",", " ", 
                    "0.7853981633974483", ",", " ", "0.021805749869574537", 
                    ",", " ", "0.04310534220294718", ",", " ", 
                    "0.043105342202947185", ",", " ", "0.6970668958824399"}], 
                    "}"}], ",", " ", "\n", "                               ", 
                    
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "0.0006539290115994377"}], ",", " ", 
                    RowBox[{"-", "0.00027086626543372516"}], ",", " ", 
                    RowBox[{"-", "0.0003696365298595269"}], ",", " ", 
                    RowBox[{"-", "0.00029752500535812105"}], ",", " ", 
                    RowBox[{"-", "0.043105342202947185"}], ",", " ", 
                    "0.018263331839948438", ",", " ", "\n", 
                    "                                ", 
                    "0.030834554254085683", ",", " ", "0.00753138088447447", 
                    ",", " ", "0.004462629126122008", ",", " ", 
                    RowBox[{"-", "0.0021827132767191864"}], ",", " ", 
                    RowBox[{"-", "0.007299771930765926"}], ",", " ", 
                    "0.018263331839948438", ",", " ", "\n", 
                    "                                ", 
                    "0.005875676529155726", ",", " ", 
                    RowBox[{"-", "0.007299771930765919"}], ",", " ", 
                    "0.0058756765291557225", ",", " ", 
                    RowBox[{"-", "2.168404344971009*^-19"}], ",", " ", 
                    "0.04310534220294718", ",", " ", "0.043105342202947185", 
                    ",", " ", "\n", "                                ", 
                    "0.6970668958824399", ",", " ", "0.0004401226303784705", 
                    ",", " ", "0.0015020019563451233", ",", " ", 
                    "0.0022483415143562816", ",", " ", "0.001597025798373995",
                     ",", " ", "0.7853981633974483", ",", " ", "\n", 
                    "                                ", 
                    "0.021805749869574537", ",", " ", "0.04310534220294718", 
                    ",", " ", "0.043105342202947185", ",", " ", 
                    "0.6970668958824399", ",", " ", "0.7853981633974483", ",",
                     " ", "0.04361149973914906", ",", " ", 
                    "0.03580557027218126", ",", " ", "\n", 
                    "                                ", "0.03580557027218126",
                     ",", " ", "0.7153302277223883", ",", " ", "0", ",", " ", 
                    "0.04361149973914906", ",", " ", "0.05063672308742165", 
                    ",", " ", "0", ",", " ", "0.7153302277223883"}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "0.0005538113768028229", ",", " ", "\n", 
                    "                                ", 
                    "0.0002293961832682441", ",", " ", 
                    "0.0004780667427576441", ",", " ", 
                    "0.00037001878529315413", ",", " ", "0.03580557027218126",
                     ",", " ", "0.", ",", " ", 
                    RowBox[{"-", "0.025612806736529395"}], ",", " ", 
                    RowBox[{"-", "0.01483115281524039"}], ",", " ", "\n", 
                    "                                ", 
                    RowBox[{"-", "0.010609171920711452"}], ",", " ", 
                    "0.001813076746859659", ",", " ", "0", ",", " ", 
                    "0.015467184926617361", ",", " ", "0", ",", " ", 
                    RowBox[{"-", "0.013351742176525891"}], ",", " ", 
                    "0.010334112331695944", ",", " ", "0", ",", " ", 
                    "0.05063672308742165", ",", " ", "0", ",", " ", "\n", 
                    "                                ", "0.7153302277223883", 
                    ",", " ", "0.00041750282870259964", ",", " ", 
                    "0.0015234613279082312", ",", " ", 
                    "0.0015020019563451233", ",", " ", 
                    "0.0015334633487699373", ",", " ", "0", ",", " ", 
                    "0.04361149973914906", ",", " ", "\n", 
                    "                                ", "0.05063672308742165",
                     ",", " ", "0", ",", " ", "0.7153302277223883", ",", " ", 
                    "0", ",", " ", "0.06541724960872358", ",", " ", 
                    "0.03728498091089576", ",", " ", "0", ",", " ", 
                    "0.7307974126490057", ",", " ", "0.7853981633974483", ",",
                     " ", "\n", "                                ", 
                    "0.04361149973914906", ",", " ", "0.03580557027218126", 
                    ",", " ", "0.03580557027218126", ",", " ", 
                    "0.7153302277223883"}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "0.000407784022214093"}], ",", " ", 
                    RowBox[{"-", "0.00016890967252013167"}], ",", " ", "\n", 
                    "                                ", 
                    RowBox[{"-", "0.0003520115104423218"}], ",", " ", 
                    RowBox[{"-", "0.00027245332053793807"}], ",", " ", 
                    RowBox[{"-", "0.03580557027218126"}], ",", " ", 
                    "0.015467184926617361", ",", " ", "0.026166618113332218", 
                    ",", " ", "0.0014794106387144984", ",", " ", "\n", 
                    "                                ", 
                    "0.0005044557722837448", ",", " ", 
                    RowBox[{"-", "0.001335010004102015"}], ",", " ", 
                    RowBox[{"-", "0.009441107433675891"}], ",", " ", 
                    "0.015467184926617361", ",", " ", "0.007307320907285728", 
                    ",", " ", 
                    RowBox[{"-", "0.009441107433675894"}], ",", " ", "\n", 
                    "                                ", 
                    "0.007307320907285732", ",", " ", 
                    "1.0842021724855044*^-19", ",", " ", 
                    "0.03580557027218126", ",", " ", "0.03580557027218126", 
                    ",", " ", "0.7153302277223883", ",", " ", 
                    "0.0004175028287025997", ",", " ", "\n", 
                    "                                ", 
                    "0.0008143426157323357", ",", " ", 
                    "0.0015234613279082312", ",", " ", 
                    "0.0011291242442315133", ",", " ", "0.7853981633974483", 
                    ",", " ", "0.04361149973914906", ",", " ", 
                    "0.03580557027218126", ",", " ", "\n", 
                    "                                ", "0.03580557027218126",
                     ",", " ", "0.7153302277223883", ",", " ", 
                    "0.7853981633974483", ",", " ", "0.06541724960872358", 
                    ",", " ", "0.026364462838505364", ",", " ", 
                    "0.026364462838505368", ",", " ", "0.7307974126490057", 
                    ",", " ", "0", ",", " ", "\n", 
                    "                                ", "0.06541724960872358",
                     ",", " ", "0.03728498091089576", ",", " ", "0", ",", " ",
                     "0.7307974126490057"}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "0.00028402382658134287", ",", " ", 
                    "0.00011764652100709847", ",", " ", 
                    "0.00045384687913854727", ",", " ", "\n", 
                    "                                ", 
                    "0.0003422599479656013", ",", " ", "0.026364462838505368",
                     ",", " ", "0.", ",", " ", 
                    RowBox[{"-", "0.019267081228260582"}], ",", " ", 
                    RowBox[{"-", "0.010920518072390393"}], ",", " ", 
                    RowBox[{"-", "0.007980686352089608"}], ",", " ", 
                    "0.000982998493659693", ",", " ", "0", ",", " ", "\n", 
                    "                                ", 
                    "0.010772979837333385", ",", " ", "0", ",", " ", 
                    RowBox[{"-", "0.01721434196928537"}], ",", " ", 
                    "0.012981866919197374", ",", " ", "0", ",", " ", 
                    "0.03728498091089576", ",", " ", "0", ",", " ", 
                    "0.7307974126490057", ",", " ", "0.0004123906640110913", 
                    ",", " ", "\n", "                                ", 
                    "0.0008507542145836484", ",", " ", 
                    "0.0008143426157323357", ",", " ", "0.001096334306085113",
                     ",", " ", "0", ",", " ", "0.06541724960872358", ",", " ",
                     "0.03728498091089576", ",", " ", "0", ",", " ", 
                    "0.7307974126490057", ",", " ", "0", ",", " ", "\n", 
                    "                                ", "0.0872229994782981", 
                    ",", " ", "0.02007063894161039", ",", " ", "0", ",", " ", 
                    "0.741570392486339", ",", " ", "0.7853981633974483", ",", 
                    " ", "0.06541724960872358", ",", " ", 
                    "0.026364462838505364", ",", " ", "0.026364462838505368", 
                    ",", " ", "\n", "                                ", 
                    "0.7307974126490057"}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "0.0001528910444597506"}], ",", " ", 
                    RowBox[{"-", "0.00006332954418061722"}], ",", " ", 
                    RowBox[{"-", "0.00024430740269749094"}], ",", " ", 
                    RowBox[{"-", "0.00018423975745645384"}], ",", " ", 
                    RowBox[{"-", "0.026364462838505368"}], ",", " ", "\n", 
                    "                                ", 
                    "0.010772979837333385", ",", " ", "0.019551105054841925", 
                    ",", " ", 
                    RowBox[{"-", "0.006293823896894975"}], ",", " ", 
                    RowBox[{"-", "0.004883534046100672"}], ",", " ", 
                    RowBox[{"-", "0.0005291516145211458"}], ",", " ", 
                    RowBox[{"-", "0.012172377940145869"}], ",", " ", "\n", 
                    "                                ", 
                    "0.010772979837333385", ",", " ", "0.009179566131025777", 
                    ",", " ", 
                    RowBox[{"-", "0.012172377940145869"}], ",", " ", 
                    "0.009179566131025777", ",", " ", "0.", ",", " ", 
                    "0.026364462838505364", ",", " ", "0.026364462838505368", 
                    ",", " ", "\n", "                                ", 
                    "0.7307974126490057", ",", " ", "0.00041239066401109123", 
                    ",", " ", "0.00023597267140166515", ",", " ", 
                    "0.0008507542145836484", ",", " ", 
                    "0.0005901606888125033", ",", " ", "0.7853981633974483", 
                    ",", " ", "\n", "                                ", 
                    "0.06541724960872358", ",", " ", "0.026364462838505364", 
                    ",", " ", "0.026364462838505368", ",", " ", 
                    "0.7307974126490057", ",", " ", "0.7853981633974483", ",",
                     " ", "0.0872229994782981", ",", " ", 
                    "0.014192084898359495", ",", " ", "\n", 
                    "                                ", 
                    "0.014192084898359499", ",", " ", "0.741570392486339", 
                    ",", " ", "0", ",", " ", "0.0872229994782981", ",", " ", 
                    "0.02007063894161039", ",", " ", "0", ",", " ", 
                    "0.741570392486339"}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "0.00006570344923224371", ",", " ", "\n", 
                    "                                ", 
                    "0.000027215259766686165", ",", " ", 
                    "0.0002848442118236549", ",", " ", 
                    "0.00021255074416628842", ",", " ", 
                    "0.014192084898359499", ",", " ", "0.", ",", " ", 
                    RowBox[{"-", "0.010524429968275899"}], ",", " ", 
                    RowBox[{"-", "0.0058785540432508936"}], ",", " ", "\n", 
                    "                                ", 
                    RowBox[{"-", "0.0043593616291057215"}], ",", " ", 
                    "0.0002848442118236549", ",", " ", "0", ",", " ", 
                    "0.00462958400423874", ",", " ", "0", ",", " ", 
                    RowBox[{"-", "0.02007063894161039"}], ",", " ", 
                    "0.014976710306380547", ",", " ", "0", ",", " ", 
                    "0.02007063894161039", ",", " ", "0", ",", " ", "\n", 
                    "                                ", "0.741570392486339", 
                    ",", " ", "0.00042426359557679055", ",", " ", 
                    "0.0004242635955767906", ",", " ", 
                    "0.00023597267140166515", ",", " ", 
                    "0.000587175744099231", ",", " ", "0", ",", " ", 
                    "0.0872229994782981", ",", " ", "\n", 
                    "                                ", "0.02007063894161039",
                     ",", " ", "0", ",", " ", "0.741570392486339", ",", " ", 
                    "0", ",", " ", "0.10902874934787263", ",", " ", "0", ",", 
                    " ", "0", ",", " ", "0.7461999764905778", ",", " ", 
                    "0.7853981633974483", ",", " ", "0.0872229994782981", ",",
                     " ", "\n", "                                ", 
                    "0.014192084898359495", ",", " ", "0.014192084898359499", 
                    ",", " ", "0.741570392486339"}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "0.", ",", " ", "0.", ",", " ", "0", ",", " ", "0", ",", 
                    " ", 
                    RowBox[{"-", "0.014192084898359499"}], ",", " ", 
                    "0.00462958400423874", ",", " ", "0.010590133417508142", 
                    ",", " ", "\n", "                                ", 
                    RowBox[{"-", "0.014192084898359495"}], ",", " ", 
                    RowBox[{"-", "0.010590133417508139"}], ",", " ", "0", ",",
                     " ", 
                    RowBox[{"-", "0.014192084898359499"}], ",", " ", 
                    "0.00462958400423874", ",", " ", "0.010590133417508142", 
                    ",", " ", 
                    RowBox[{"-", "0.014192084898359495"}], ",", " ", "\n", 
                    "                                ", 
                    "0.010590133417508139", ",", " ", "0", ",", " ", 
                    "0.014192084898359495", ",", " ", "0.014192084898359499", 
                    ",", " ", "0.741570392486339", ",", " ", 
                    "0.0004242635955767906", ",", " ", "0.", ",", " ", 
                    "0.0004242635955767906", ",", " ", "0.", ",", " ", "\n", 
                    "                                ", "0.7853981633974483", 
                    ",", " ", "0.0872229994782981", ",", " ", 
                    "0.014192084898359495", ",", " ", "0.014192084898359499", 
                    ",", " ", "0.741570392486339", ",", " ", 
                    "0.7853981633974483", ",", " ", "0.10902874934787263", 
                    ",", " ", "0", ",", " ", "0", ",", " ", "\n", 
                    "                                ", "0.7461999764905778", 
                    ",", " ", "0", ",", " ", "0.10902874934787263", ",", " ", 
                    "0", ",", " ", "0", ",", " ", "0.7461999764905778"}], 
                    "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "0.", ",", " ", "0.", ",", " ", "0", ",", " ", "0", ",", 
                    " ", "0", ",", " ", "0.", ",", " ", "0", ",", " ", "0", 
                    ",", " ", "0", ",", " ", "0", ",", " ", 
                    "0.014051862724930291", ",", " ", "0.0024195679317141616",
                     ",", " ", "\n", "                                ", 
                    RowBox[{"-", "0.008755956665157808"}], ",", " ", 
                    "0.01405186272493029", ",", " ", 
                    RowBox[{"-", "0.008755956665157806"}], ",", " ", "0", ",",
                     " ", "0", ",", " ", "0", ",", " ", "0.6231171508403164", 
                    ",", " ", "0.00040076400105675024", ",", " ", 
                    "0.00040076400105675024", ",", " ", "0.", ",", " ", "\n", 
                    "                                ", "0.", ",", " ", 
                    "0.7853981633974483", ",", " ", 
                    RowBox[{"-", "0.1090287493478726"}], ",", " ", "0", ",", 
                    " ", "0", ",", " ", "0.6231171508403164", ",", " ", 
                    "0.7853981633974483", ",", " ", 
                    RowBox[{"-", "0.08722299947829808"}], ",", " ", 
                    "0.01405186272493029", ",", " ", "\n", 
                    "                                ", 
                    "0.014051862724930291", ",", " ", "0.6255367187720305", 
                    ",", " ", "1.5707963267948966", ",", " ", 
                    RowBox[{"-", "0.1090287493478726"}], ",", " ", "0", ",", 
                    " ", "0", ",", " ", "0.6231171508403164"}], "}"}], ",", 
                    " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "0.000014083027682386569"}], ",", " ", "\n", 
                    "                                ", 
                    RowBox[{"-", "0.000033999436430091554"}], ",", " ", 
                    "0.0002792433212264629", ",", " ", 
                    "0.0001740013027138208", ",", " ", "0.014051862724930291",
                     ",", " ", "0.0024195679317141616", ",", " ", 
                    RowBox[{"-", "0.008755956665157808"}], ",", " ", "\n", 
                    "                                ", "0.01405186272493029",
                     ",", " ", "0.008755956665157806", ",", " ", "0", ",", 
                    " ", "0.019872334842201373", ",", " ", 
                    "0.0024195679317141616", ",", " ", 
                    RowBox[{"-", "0.012382792667417267"}], ",", " ", "0", ",",
                     " ", "0", ",", " ", "0", ",", " ", "0", ",", " ", "0", 
                    ",", " ", "0.6231171508403164", ",", " ", "\n", 
                    "                                ", 
                    "0.00040076400105675024", ",", " ", 
                    "0.00023133274170821544", ",", " ", 
                    "0.00040076400105675024", ",", " ", 
                    "0.0005633156337111625", ",", " ", "1.5707963267948966", 
                    ",", " ", 
                    RowBox[{"-", "0.1090287493478726"}], ",", " ", "0", ",", 
                    " ", "0", ",", " ", "\n", 
                    "                                ", "0.6231171508403164", 
                    ",", " ", "1.5707963267948966", ",", " ", 
                    RowBox[{"-", "0.08722299947829808"}], ",", " ", "0", ",", 
                    " ", "0.019872334842201373", ",", " ", 
                    "0.6255367187720305", ",", " ", "0.7853981633974483", ",",
                     " ", 
                    RowBox[{"-", "0.08722299947829808"}], ",", " ", "\n", 
                    "                                ", "0.01405186272493029",
                     ",", " ", "0.014051862724930291", ",", " ", 
                    "0.6255367187720305"}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "0.000042643341024429376", ",", " ", 
                    "0.00010295013224607963", ",", " ", 
                    RowBox[{"-", "0.0002901015347222037"}], ",", " ", "\n", 
                    "                                ", 
                    RowBox[{"-", "0.00017942330264081454"}], ",", " ", 
                    "0.005820472117271082", ",", " ", "0.", ",", " ", 
                    RowBox[{"-", "0.003640919029941847"}], ",", " ", 
                    RowBox[{"-", "0.01405186272493029"}], ",", " ", 
                    RowBox[{"-", "0.008789956101587898"}], ",", " ", 
                    "0.0002792433212264629", ",", " ", "\n", 
                    "                                ", 
                    "0.014598261202107818", ",", " ", "0.007326440220870367", 
                    ",", " ", 
                    RowBox[{"-", "0.009028798279897483"}], ",", " ", 
                    "0.014598261202107816", ",", " ", 
                    RowBox[{"-", "0.009028798279897485"}], ",", " ", "0.", 
                    ",", " ", "0.01405186272493029", ",", " ", "\n", 
                    "                                ", 
                    "0.014051862724930291", ",", " ", "0.6255367187720305", 
                    ",", " ", "0.0004798951865599198", ",", " ", 
                    "0.0009515559085625073", ",", " ", 
                    "0.00023133274170821544", ",", " ", 
                    "0.0006215338597739909", ",", " ", "\n", 
                    "                                ", "0.7853981633974483", 
                    ",", " ", 
                    RowBox[{"-", "0.08722299947829808"}], ",", " ", 
                    "0.01405186272493029", ",", " ", "0.014051862724930291", 
                    ",", " ", "0.6255367187720305", ",", " ", 
                    "0.7853981633974483", ",", " ", 
                    RowBox[{"-", "0.06541724960872355"}], ",", " ", "\n", 
                    "                                ", 
                    "0.028650123927038106", ",", " ", "0.02865012392703811", 
                    ",", " ", "0.6328631589929009", ",", " ", 
                    "1.5707963267948966", ",", " ", 
                    RowBox[{"-", "0.08722299947829808"}], ",", " ", "0", ",", 
                    " ", "0.019872334842201373", ",", " ", "\n", 
                    "                                ", 
                    "0.6255367187720305"}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "0.00008694484346514781"}], ",", " ", 
                    RowBox[{"-", "0.00020990342027197087"}], ",", " ", 
                    "0.00059148349823182", ",", " ", "0.0003658233756395669", 
                    ",", " ", "0.008777789084836736", ",", " ", "\n", 
                    "                                ", 
                    "0.007326440220870367", ",", " ", 
                    RowBox[{"-", "0.005345235908931208"}], ",", " ", 
                    "0.028650123927038106", ",", " ", "0.01792170451373146", 
                    ",", " ", 
                    RowBox[{"-", "0.0005693448559486666"}], ",", " ", 
                    "0.020645058979085838", ",", " ", "\n", 
                    "                                ", 
                    "0.007326440220870367", ",", " ", 
                    RowBox[{"-", "0.012768648979361894"}], ",", " ", "0", ",",
                     " ", "0", ",", " ", "0", ",", " ", "0", ",", " ", 
                    "0.019872334842201373", ",", " ", "0.6255367187720305", 
                    ",", " ", "0.0004798951865599198", ",", " ", 
                    "0.0009616616957775924", ",", " ", "\n", 
                    "                                ", 
                    "0.0009515559085625073", ",", " ", 
                    "0.0012672357007717282", ",", " ", "1.5707963267948966", 
                    ",", " ", 
                    RowBox[{"-", "0.08722299947829808"}], ",", " ", "0", ",", 
                    " ", "0.019872334842201373", ",", " ", 
                    "0.6255367187720305", ",", " ", "\n", 
                    "                                ", "1.5707963267948966", 
                    ",", " ", 
                    RowBox[{"-", "0.06541724960872355"}], ",", " ", "0", ",", 
                    " ", "0.04051739382128721", ",", " ", 
                    "0.6328631589929009", ",", " ", "0.7853981633974483", ",",
                     " ", 
                    RowBox[{"-", "0.06541724960872355"}], ",", " ", 
                    "0.028650123927038106", ",", " ", "\n", 
                    "                                ", "0.02865012392703811",
                     ",", " ", "0.6328631589929009"}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "0.00013946792869093822", ",", " ", 
                    "0.0003367053649617445", ",", " ", 
                    RowBox[{"-", "0.0005036849306382237"}], ",", " ", 
                    RowBox[{"-", "0.000305121212466931"}], ",", " ", "\n", 
                    "                                ", 
                    "0.011867269894249102", ",", " ", "0.", ",", " ", 
                    RowBox[{"-", "0.007510357913895833"}], ",", " ", 
                    RowBox[{"-", "0.028650123927038106"}], ",", " ", 
                    RowBox[{"-", "0.01813160793400343"}], ",", " ", 
                    "0.0011608283541804866", ",", " ", "0.012431325984584806",
                     ",", " ", "\n", "                                ", 
                    "0.011752317924320854", ",", " ", 
                    RowBox[{"-", "0.007530622868113131"}], ",", " ", 
                    "0.012431325984584803", ",", " ", 
                    RowBox[{"-", "0.007530622868113127"}], ",", " ", "0.", 
                    ",", " ", "0.028650123927038106", ",", " ", 
                    "0.02865012392703811", ",", " ", "\n", 
                    "                                ", "0.6328631589929009", 
                    ",", " ", "0.0004471927080643399", ",", " ", 
                    "0.0018261206627085398", ",", " ", 
                    "0.0009616616957775924", ",", " ", 
                    "0.0012434151604020164", ",", " ", "0.7853981633974483", 
                    ",", " ", "\n", "                                ", 
                    RowBox[{"-", "0.06541724960872355"}], ",", " ", 
                    "0.028650123927038106", ",", " ", "0.02865012392703811", 
                    ",", " ", "0.6328631589929009", ",", " ", 
                    "0.7853981633974483", ",", " ", 
                    RowBox[{"-", "0.04361149973914903"}], ",", " ", 
                    "0.04108144991162291", ",", " ", "\n", 
                    "                                ", 
                    "0.041081449911622915", ",", " ", "0.6446154769172218", 
                    ",", " ", "1.5707963267948966", ",", " ", 
                    RowBox[{"-", "0.06541724960872355"}], ",", " ", "0", ",", 
                    " ", "0.04051739382128721", ",", " ", 
                    "0.6328631589929009"}], "}"}], ",", " ", "\n", 
                    "                               ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "0.00019998324409994592"}], ",", " ", 
                    RowBox[{"-", "0.00048280226015345526"}], ",", " ", 
                    "0.0007222344762608714", ",", " ", 
                    "0.0004375137028675934", ",", " ", 
                    "0.0005640560903357045", ",", " ", "0.011752317924320854",
                     ",", " ", "\n", "                                ", 
                    "0.00011920297447364295", ",", " ", "0.04108144991162291",
                     ",", " ", "0.025998936167078303", ",", " ", 
                    RowBox[{"-", "0.0016645132848187101"}], ",", " ", 
                    "0.017580549805680898", ",", " ", "0.011752317924320854", 
                    ",", " ", "\n", "                                ", 
                    RowBox[{"-", "0.010649908993202561"}], ",", " ", "0", ",",
                     " ", "0", ",", " ", "0", ",", " ", "0", ",", " ", 
                    "0.04051739382128721", ",", " ", "0.6328631589929009", 
                    ",", " ", "0.00044719270806433986", ",", " ", 
                    "0.0019772465852055643", ",", " ", 
                    "0.0018261206627085398", ",", " ", "\n", 
                    "                                ", 
                    "0.0017829346135288737", ",", " ", "1.5707963267948966", 
                    ",", " ", 
                    RowBox[{"-", "0.06541724960872355"}], ",", " ", "0", ",", 
                    " ", "0.04051739382128721", ",", " ", 
                    "0.6328631589929009", ",", " ", "1.5707963267948966", ",",
                     " ", "\n", "                                ", 
                    RowBox[{"-", "0.04361149973914903"}], ",", " ", "0", ",", 
                    " ", "0.05809794362696811", ",", " ", 
                    "0.6446154769172218", ",", " ", "0.7853981633974483", ",",
                     " ", 
                    RowBox[{"-", "0.04361149973914903"}], ",", " ", 
                    "0.04108144991162291", ",", " ", "\n", 
                    "                                ", 
                    "0.041081449911622915", ",", " ", "0.6446154769172218"}], 
                    "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "0.00026242117578575974", ",", " ", 
                    "0.0006335407616358674", ",", " ", 
                    RowBox[{"-", "0.00039261647813520735"}], ",", " ", 
                    RowBox[{"-", "0.00021627924284377948"}], ",", " ", "\n", 
                    "                                ", 
                    "0.017016493715345193", ",", " ", "0.", ",", " ", 
                    RowBox[{"-", "0.01096909521177615"}], ",", " ", 
                    RowBox[{"-", "0.04108144991162291"}], ",", " ", 
                    RowBox[{"-", "0.026481738427231758"}], ",", " ", 
                    "0.0023867477610795816", ",", " ", "0.006757837775741189",
                     ",", " ", "\n", "                                ", 
                    "0.015421577451593893", ",", " ", 
                    RowBox[{"-", "0.0037226660591027534"}], ",", " ", 
                    "0.006757837775741189", ",", " ", 
                    RowBox[{"-", "0.003722666059102757"}], ",", " ", "0.", 
                    ",", " ", "0.04108144991162291", ",", " ", 
                    "0.041081449911622915", ",", " ", "\n", 
                    "                                ", "0.6446154769172218", 
                    ",", " ", "0.00032916179390197846", ",", " ", 
                    "0.0026316625192170677", ",", " ", 
                    "0.0019772465852055643", ",", " ", 
                    "0.0015803625774590188", ",", " ", "0.7853981633974483", 
                    ",", " ", "\n", "                                ", 
                    RowBox[{"-", "0.04361149973914903"}], ",", " ", 
                    "0.04108144991162291", ",", " ", "0.041081449911622915", 
                    ",", " ", "0.6446154769172218", ",", " ", 
                    "0.7853981633974483", ",", " ", 
                    RowBox[{"-", "0.02180574986957451"}], ",", " ", 
                    "0.0478392876873641", ",", " ", "\n", 
                    "                                ", 
                    "0.047839287687364104", ",", " ", "0.6600370543688157", 
                    ",", " ", "1.5707963267948966", ",", " ", 
                    RowBox[{"-", "0.04361149973914903"}], ",", " ", "0", ",", 
                    " ", "0.05809794362696811", ",", " ", 
                    "0.6446154769172218"}], "}"}], ",", " ", "\n", 
                    "                               ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "0.00030558907123965154"}], ",", " ", 
                    RowBox[{"-", "0.0007377572802997646"}], ",", " ", 
                    "0.0004572013083451532", ",", " ", 
                    "0.0002518568585448478", ",", " ", 
                    RowBox[{"-", "0.010258655939604004"}], ",", " ", 
                    "0.015421577451593893", ",", " ", "\n", 
                    "                                ", 
                    "0.007508850328459153", ",", " ", "0.0478392876873641", 
                    ",", " ", "0.030837945247970382", ",", " ", 
                    RowBox[{"-", "0.002779364239214789"}], ",", " ", 
                    "0.009557025834770423", ",", " ", "0.015421577451593893", 
                    ",", " ", "\n", "                                ", 
                    RowBox[{"-", "0.005264644828969121"}], ",", " ", "0", ",",
                     " ", "0", ",", " ", "0", ",", " ", "0", ",", " ", 
                    "0.05809794362696811", ",", " ", "0.6446154769172218", 
                    ",", " ", "0.0003291617939019785", ",", " ", 
                    "0.0026812586906176613", ",", " ", 
                    "0.0026316625192170677", ",", " ", "\n", 
                    "                                ", 
                    "0.0018403298850466381", ",", " ", "1.5707963267948966", 
                    ",", " ", 
                    RowBox[{"-", "0.04361149973914903"}], ",", " ", "0", ",", 
                    " ", "0.05809794362696811", ",", " ", 
                    "0.6446154769172218", ",", " ", "1.5707963267948966", ",",
                     " ", "\n", "                                ", 
                    RowBox[{"-", "0.02180574986957451"}], ",", " ", "0", ",", 
                    " ", "0.06765496946173853", ",", " ", 
                    "0.6600370543688157", ",", " ", "0.7853981633974483", ",",
                     " ", 
                    RowBox[{"-", "0.02180574986957451"}], ",", " ", 
                    "0.0478392876873641", ",", " ", "0.047839287687364104", 
                    ",", " ", "\n", "                                ", 
                    "0.6600370543688157"}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "0.0003563646850372297", ",", " ", 
                    "0.0008603404557676955", ",", " ", 
                    RowBox[{"-", "2.1826118294997025*^-6"}], ",", " ", 
                    "0.00005676570257888837", ",", " ", 
                    "0.019815681774374427", ",", " ", "0.", ",", " ", "\n", 
                    "                                ", 
                    RowBox[{"-", "0.013079084228667923"}], ",", " ", 
                    RowBox[{"-", "0.0478392876873641"}], ",", " ", 
                    RowBox[{"-", "0.03157570252827015"}], ",", " ", 
                    "0.003236565547559942", ",", " ", 
                    "0.00003226092402176112", ",", " ", 
                    "0.017983972951063354", ",", " ", "\n", 
                    "                                ", 
                    "0.0008390470505051581", ",", " ", 
                    "0.00003226092402176112", ",", " ", 
                    "0.0008390470505051512", ",", " ", "0.", ",", " ", 
                    "0.0478392876873641", ",", " ", "0.047839287687364104", 
                    ",", " ", "0.6600370543688157", ",", " ", "\n", 
                    "                                ", 
                    "0.00032342536463901583", ",", " ", 
                    "0.0030064921900990263", ",", " ", 
                    "0.0026812586906176613", ",", " ", 
                    "0.0018624567134477466", ",", " ", "0.7853981633974483", 
                    ",", " ", 
                    RowBox[{"-", "0.02180574986957451"}], ",", " ", "\n", 
                    "                                ", "0.0478392876873641", 
                    ",", " ", "0.047839287687364104", ",", " ", 
                    "0.6600370543688157", ",", " ", "0.7853981633974483", ",",
                     " ", "0", ",", " ", "0.04787154861138586", ",", " ", 
                    "0.047871548611385865", ",", " ", "0.678021027319879", 
                    ",", " ", "\n", "                                ", 
                    "1.5707963267948966", ",", " ", 
                    RowBox[{"-", "0.02180574986957451"}], ",", " ", "0", ",", 
                    " ", "0.06765496946173853", ",", " ", 
                    "0.6600370543688157"}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "0.00035660500328994066"}], ",", " ", 
                    RowBox[{"-", "0.0008609206353526744"}], ",", " ", "\n", 
                    "                                ", 
                    "2.184083696615737*^-6", ",", " ", 
                    RowBox[{"-", "0.00005680398312415654"}], ",", " ", 
                    RowBox[{"-", "0.019783420850352666"}], ",", " ", 
                    "0.017983972951063354", ",", " ", "0.014274495964210307", 
                    ",", " ", "0.04787154861138586", ",", " ", "\n", 
                    "                                ", "0.03159699593353269",
                     ",", " ", 
                    RowBox[{"-", "0.003238748159389442"}], ",", " ", 
                    "0.0000456238362862571", ",", " ", "0.017983972951063354",
                     ",", " ", "0.0011865917182935365", ",", " ", "0", ",", 
                    " ", "0", ",", " ", "0", ",", " ", "0", ",", " ", 
                    "0.06765496946173853", ",", " ", "\n", 
                    "                                ", "0.6600370543688157", 
                    ",", " ", "0.00032342536463901583", ",", " ", 
                    "0.002684876179637003", ",", " ", "0.0030064921900990263",
                     ",", " ", "0.0018637126806126225", ",", " ", 
                    "1.5707963267948966", ",", " ", "\n", 
                    "                                ", 
                    RowBox[{"-", "0.02180574986957451"}], ",", " ", "0", ",", 
                    " ", "0.06765496946173853", ",", " ", 
                    "0.6600370543688157", ",", " ", "1.5707963267948966", ",",
                     " ", "0", ",", " ", "0", ",", " ", "0.06770059329802479",
                     ",", " ", "0.678021027319879", ",", " ", "\n", 
                    "                                ", "0.7853981633974483", 
                    ",", " ", "0", ",", " ", "0.04787154861138586", ",", " ", 
                    "0.047871548611385865", ",", " ", "0.678021027319879"}], 
                    "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "0.0003776613788228668", ",", " ", 
                    "0.0009117552227386992", ",", " ", "\n", 
                    "                                ", 
                    "0.0003226750016321468", ",", " ", 
                    "0.00028050680561905424", ",", " ", 
                    "0.019829044686638923", ",", " ", "0.", ",", " ", 
                    RowBox[{"-", "0.013444509249206711"}], ",", " ", 
                    RowBox[{"-", "0.04787154861138586"}], ",", " ", 
                    RowBox[{"-", "0.032457916568885366"}], ",", " ", "\n", 
                    "                                ", 
                    "0.0032409322430860575", ",", " ", 
                    RowBox[{"-", "0.004766206408438681"}], ",", " ", 
                    "0.019045868562560853", ",", " ", "0.0041433433882068806",
                     ",", " ", 
                    RowBox[{"-", "0.004766206408438681"}], ",", " ", 
                    "0.0041433433882068806", ",", " ", "0.", ",", " ", "\n", 
                    "                                ", "0.04787154861138586",
                     ",", " ", "0.047871548611385865", ",", " ", 
                    "0.678021027319879", ",", " ", "0.0004081785563580277", 
                    ",", " ", "0.002825742012165439", ",", " ", 
                    "0.002684876179637003", ",", " ", "\n", 
                    "                                ", 
                    "0.0020765787824438445", ",", " ", "0.7853981633974483", 
                    ",", " ", "0", ",", " ", "0.04787154861138586", ",", " ", 
                    "0.047871548611385865", ",", " ", "0.678021027319879", 
                    ",", " ", "0.7853981633974483", ",", " ", 
                    "0.021805749869574537", ",", " ", "\n", 
                    "                                ", "0.04310534220294718",
                     ",", " ", "0.043105342202947185", ",", " ", 
                    "0.6970668958824399", ",", " ", "1.5707963267948966", ",",
                     " ", "0", ",", " ", "0", ",", " ", "0.06770059329802479",
                     ",", " ", "0.678021027319879"}], "}"}], ",", " ", "\n", 
                    "                               ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "0.00034006050447937634"}], ",", " ", 
                    RowBox[{"-", "0.0008209786819415414"}], ",", " ", 
                    RowBox[{"-", "0.00029054870312639203"}], ",", " ", 
                    RowBox[{"-", "0.00025257887403268764"}], ",", " ", 
                    RowBox[{"-", "0.024595251095077604"}], ",", " ", 
                    "0.019045868562560853", ",", " ", "\n", 
                    "                                ", 
                    "0.017965514016236462", ",", " ", "0.04310534220294718", 
                    ",", " ", "0.02922632840341718", ",", " ", 
                    RowBox[{"-", "0.0029182572414539107"}], ",", " ", 
                    RowBox[{"-", "0.006740433743883535"}], ",", " ", 
                    "0.019045868562560853", ",", " ", "\n", 
                    "                                ", "0.00585957241317106",
                     ",", " ", "0", ",", " ", "0", ",", " ", "0", ",", " ", 
                    "0", ",", " ", "0.06770059329802479", ",", " ", 
                    "0.678021027319879", ",", " ", "0.0004081785563580276", 
                    ",", " ", "0.00217686502907768", ",", " ", 
                    "0.002825742012165439", ",", " ", "\n", 
                    "                                ", 
                    "0.0018698296091330473", ",", " ", "1.5707963267948966", 
                    ",", " ", "0", ",", " ", "0", ",", " ", 
                    "0.06770059329802479", ",", " ", "0.678021027319879", ",",
                     " ", "1.5707963267948966", ",", " ", 
                    "0.021805749869574537", ",", " ", "0", ",", " ", "\n", 
                    "                                ", 
                    "0.060960159554141254", ",", " ", "0.6970668958824399", 
                    ",", " ", "0.7853981633974483", ",", " ", 
                    "0.021805749869574537", ",", " ", "0.04310534220294718", 
                    ",", " ", "0.043105342202947185", ",", " ", 
                    "0.6970668958824399"}], "}"}], ",", " ", "\n", 
                    "                               ", 
                    RowBox[{"{", 
                    RowBox[{
                    "0.0003260884542265266", ",", " ", 
                    "0.0007872471687269574", ",", " ", 
                    "0.00044499526160833233", ",", " ", 
                    "0.00035818217870585596", ",", " ", "0.01785481735119407",
                     ",", " ", "0.", ",", " ", 
                    RowBox[{"-", "0.01244600210754478"}], ",", " ", "\n", 
                    "                                ", 
                    RowBox[{"-", "0.04310534220294718"}], ",", " ", 
                    RowBox[{"-", "0.030047307085358722"}], ",", " ", 
                    "0.0026277085383275187", ",", " ", 
                    RowBox[{"-", "0.007299771930765926"}], ",", " ", 
                    "0.018263331839948438", ",", " ", "0.005875676529155726", 
                    ",", " ", "\n", "                                ", 
                    RowBox[{"-", "0.007299771930765919"}], ",", " ", 
                    "0.0058756765291557225", ",", " ", 
                    RowBox[{"-", "2.168404344971009*^-19"}], ",", " ", 
                    "0.04310534220294718", ",", " ", "0.043105342202947185", 
                    ",", " ", "0.6970668958824399", ",", " ", "\n", 
                    "                                ", 
                    "0.0004401226303784705", ",", " ", "0.002248341514356281",
                     ",", " ", "0.00217686502907768", ",", " ", 
                    "0.001922615476378286", ",", " ", "0.7853981633974483", 
                    ",", " ", "0.021805749869574537", ",", " ", "\n", 
                    "                                ", "0.04310534220294718",
                     ",", " ", "0.043105342202947185", ",", " ", 
                    "0.6970668958824399", ",", " ", "0.7853981633974483", ",",
                     " ", "0.04361149973914906", ",", " ", 
                    "0.03580557027218126", ",", " ", "0.03580557027218126", 
                    ",", " ", "\n", "                                ", 
                    "0.7153302277223883", ",", " ", "1.5707963267948966", ",",
                     " ", "0.021805749869574537", ",", " ", "0", ",", " ", 
                    "0.060960159554141254", ",", " ", "0.6970668958824399"}], 
                    "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "0.00027086626543372516"}], ",", " ", "\n", 
                    "                                ", 
                    RowBox[{"-", "0.0006539290115994377"}], ",", " ", 
                    RowBox[{"-", "0.00036963652985952736"}], ",", " ", 
                    RowBox[{"-", "0.00029752500535812115"}], ",", " ", 
                    RowBox[{"-", "0.025154589281959995"}], ",", " ", 
                    "0.018263331839948438", ",", " ", "0.01864776709092703", 
                    ",", " ", "\n", "                                ", 
                    "0.03580557027218126", ",", " ", "0.024958877724929957", 
                    ",", " ", 
                    RowBox[{"-", "0.0021827132767191864"}], ",", " ", 
                    RowBox[{"-", "0.010323436466719606"}], ",", " ", 
                    "0.018263331839948438", ",", " ", "0.008309461435649299", 
                    ",", " ", "0", ",", " ", "0", ",", " ", "0", ",", " ", 
                    "0", ",", " ", "\n", "                                ", 
                    "0.060960159554141254", ",", " ", "0.6970668958824399", 
                    ",", " ", "0.0004401226303784706", ",", " ", 
                    "0.0015020019563451233", ",", " ", "0.002248341514356281",
                     ",", " ", "0.0015970257983739943", ",", " ", "\n", 
                    "                                ", "1.5707963267948966", 
                    ",", " ", "0.021805749869574537", ",", " ", "0", ",", " ",
                     "0.060960159554141254", ",", " ", "0.6970668958824399", 
                    ",", " ", "1.5707963267948966", ",", " ", 
                    "0.04361149973914906", ",", " ", "0", ",", " ", "\n", 
                    "                                ", "0.05063672308742165",
                     ",", " ", "0.7153302277223883", ",", " ", 
                    "0.7853981633974483", ",", " ", "0.04361149973914906", 
                    ",", " ", "0.03580557027218126", ",", " ", 
                    "0.03580557027218126", ",", " ", "0.7153302277223883"}], 
                    "}"}], ",", " ", "\n", "                               ", 
                    
                    RowBox[{"{", 
                    RowBox[{"0.00022939618326824063", ",", " ", 
                    "0.0005538113768028194", ",", " ", 
                    "0.0004780667427576441", ",", " ", "0.000370018785293154",
                     ",", " ", "0.01483115281524039", ",", " ", "0.", ",", 
                    " ", 
                    RowBox[{"-", "0.010609171920711452"}], ",", " ", "\n", 
                    "                                ", 
                    RowBox[{"-", "0.03580557027218126"}], ",", " ", 
                    RowBox[{"-", "0.025612806736529395"}], ",", " ", 
                    "0.001813076746859659", ",", " ", 
                    RowBox[{"-", "0.009441107433675891"}], ",", " ", 
                    "0.015467184926617361", ",", " ", "0.007307320907285728", 
                    ",", " ", "\n", "                                ", 
                    RowBox[{"-", "0.009441107433675894"}], ",", " ", 
                    "0.007307320907285732", ",", " ", 
                    "1.0842021724855044*^-19", ",", " ", 
                    "0.03580557027218126", ",", " ", "0.03580557027218126", 
                    ",", " ", "0.7153302277223883", ",", " ", "\n", 
                    "                                ", 
                    "0.0004175028287025997", ",", " ", "0.001523461327908231",
                     ",", " ", "0.0015020019563451233", ",", " ", 
                    "0.0015334633487699373", ",", " ", "0.7853981633974483", 
                    ",", " ", "0.04361149973914906", ",", " ", "\n", 
                    "                                ", "0.03580557027218126",
                     ",", " ", "0.03580557027218126", ",", " ", 
                    "0.7153302277223883", ",", " ", "0.7853981633974483", ",",
                     " ", "0.06541724960872358", ",", " ", 
                    "0.026364462838505364", ",", " ", "0.026364462838505368", 
                    ",", " ", "\n", "                                ", 
                    "0.7307974126490057", ",", " ", "1.5707963267948966", ",",
                     " ", "0.04361149973914906", ",", " ", "0", ",", " ", 
                    "0.05063672308742165", ",", " ", "0.7153302277223883"}], 
                    "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "0.0001689096725201308"}], ",", " ", "\n", 
                    "                                ", 
                    RowBox[{"-", "0.000407784022214093"}], ",", " ", 
                    RowBox[{"-", "0.0003520115104423216"}], ",", " ", 
                    RowBox[{"-", "0.00027245332053793775"}], ",", " ", 
                    RowBox[{"-", "0.02427226024891628"}], ",", " ", 
                    "0.015467184926617361", ",", " ", "0.018145889011265418", 
                    ",", " ", "\n", "                                ", 
                    "0.026364462838505364", ",", " ", "0.018859297206046486", 
                    ",", " ", 
                    RowBox[{"-", "0.0013350100041020147"}], ",", " ", 
                    RowBox[{"-", "0.013351742176525891"}], ",", " ", 
                    "0.015467184926617361", ",", " ", "0.010334112331695944", 
                    ",", " ", "0", ",", " ", "0", ",", " ", "0", ",", " ", 
                    "0", ",", " ", "\n", "                                ", 
                    "0.05063672308742165", ",", " ", "0.7153302277223883", 
                    ",", " ", "0.00041750282870259964", ",", " ", 
                    "0.0008143426157323354", ",", " ", "0.001523461327908231",
                     ",", " ", "0.001129124244231513", ",", " ", "\n", 
                    "                                ", "1.5707963267948966", 
                    ",", " ", "0.04361149973914906", ",", " ", "0", ",", " ", 
                    "0.05063672308742165", ",", " ", "0.7153302277223883", 
                    ",", " ", "1.5707963267948966", ",", " ", 
                    "0.06541724960872358", ",", " ", "0", ",", " ", 
                    "0.03728498091089576", ",", " ", "\n", 
                    "                                ", "0.7307974126490057", 
                    ",", " ", "0.7853981633974483", ",", " ", 
                    "0.06541724960872358", ",", " ", "0.026364462838505364", 
                    ",", " ", "0.026364462838505368", ",", " ", 
                    "0.7307974126490057"}], "}"}], ",", " ", "\n", 
                    "                               ", 
                    RowBox[{"{", 
                    RowBox[{
                    "0.00011764652100709413", ",", " ", 
                    "0.00028402382658134287", ",", " ", 
                    "0.0004538468791385474", ",", " ", 
                    "0.00034225994796560123", ",", " ", "0.01092051807239039",
                     ",", " ", "0.", ",", " ", 
                    RowBox[{"-", "0.007980686352089605"}], ",", " ", "\n", 
                    "                                ", 
                    RowBox[{"-", "0.026364462838505364"}], ",", " ", 
                    RowBox[{"-", "0.01926708122826058"}], ",", " ", 
                    "0.000982998493659693", ",", " ", 
                    RowBox[{"-", "0.012172377940145869"}], ",", " ", 
                    "0.010772979837333385", ",", " ", "0.009179566131025777", 
                    ",", " ", "\n", "                                ", 
                    RowBox[{"-", "0.012172377940145869"}], ",", " ", 
                    "0.009179566131025777", ",", " ", "0.", ",", " ", 
                    "0.026364462838505364", ",", " ", "0.026364462838505368", 
                    ",", " ", "0.7307974126490057", ",", " ", 
                    "0.00041239066401109123", ",", " ", "\n", 
                    "                                ", 
                    "0.0008507542145836483", ",", " ", 
                    "0.0008143426157323354", ",", " ", "0.001096334306085113",
                     ",", " ", "0.7853981633974483", ",", " ", 
                    "0.06541724960872358", ",", " ", "0.026364462838505364", 
                    ",", " ", "\n", "                                ", 
                    "0.026364462838505368", ",", " ", "0.7307974126490057", 
                    ",", " ", "0.7853981633974483", ",", " ", 
                    "0.0872229994782981", ",", " ", "0.014192084898359495", 
                    ",", " ", "0.014192084898359499", ",", " ", 
                    "0.741570392486339", ",", " ", "\n", 
                    "                                ", "1.5707963267948966", 
                    ",", " ", "0.06541724960872358", ",", " ", "0", ",", " ", 
                    "0.03728498091089576", ",", " ", "0.7307974126490057"}], 
                    "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "0.00006332954418061636"}], ",", " ", 
                    RowBox[{"-", "0.0001528910444597506"}], ",", " ", "\n", 
                    "                                ", 
                    RowBox[{"-", "0.00024430740269749094"}], ",", " ", 
                    RowBox[{"-", "0.0001842397574564538"}], ",", " ", 
                    RowBox[{"-", "0.02309289601253626"}], ",", " ", 
                    "0.010772979837333385", ",", " ", "0.017277899004122476", 
                    ",", " ", "0.014192084898359495", ",", " ", "\n", 
                    "                                ", 
                    "0.010371538923816145", ",", " ", 
                    RowBox[{"-", "0.0005291516145211457"}], ",", " ", 
                    RowBox[{"-", "0.01721434196928537"}], ",", " ", 
                    "0.010772979837333385", ",", " ", "0.012981866919197374", 
                    ",", " ", "0", ",", " ", "0", ",", " ", "0", ",", " ", 
                    "0", ",", " ", "0.03728498091089576", ",", " ", "\n", 
                    "                                ", "0.7307974126490057", 
                    ",", " ", "0.0004123906640110913", ",", " ", 
                    "0.00023597267140166504", ",", " ", 
                    "0.0008507542145836483", ",", " ", 
                    "0.0005901606888125031", ",", " ", "1.5707963267948966", 
                    ",", " ", "\n", "                                ", 
                    "0.06541724960872358", ",", " ", "0", ",", " ", 
                    "0.03728498091089576", ",", " ", "0.7307974126490057", 
                    ",", " ", "1.5707963267948966", ",", " ", 
                    "0.0872229994782981", ",", " ", "0", ",", " ", 
                    "0.02007063894161039", ",", " ", "0.741570392486339", ",",
                     " ", "\n", "                                ", 
                    "0.7853981633974483", ",", " ", "0.0872229994782981", ",",
                     " ", "0.014192084898359495", ",", " ", 
                    "0.014192084898359499", ",", " ", "0.741570392486339"}], 
                    "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "0.000027215259766686165", ",", " ", "\n", 
                    "                                ", 
                    "0.00006570344923224331", ",", " ", 
                    "0.0002848442118236548", ",", " ", 
                    "0.00021255074416628837", ",", " ", "0.00587855404325089",
                     ",", " ", "0.", ",", " ", 
                    RowBox[{"-", "0.004359361629105718"}], ",", " ", 
                    RowBox[{"-", "0.014192084898359495"}], ",", " ", "\n", 
                    "                                ", 
                    RowBox[{"-", "0.010524429968275895"}], ",", " ", 
                    "0.0002848442118236548", ",", " ", 
                    RowBox[{"-", "0.014192084898359499"}], ",", " ", 
                    "0.00462958400423874", ",", " ", "0.010590133417508142", 
                    ",", " ", 
                    RowBox[{"-", "0.014192084898359495"}], ",", " ", "\n", 
                    "                                ", 
                    "0.010590133417508139", ",", " ", "0", ",", " ", 
                    "0.014192084898359495", ",", " ", "0.014192084898359499", 
                    ",", " ", "0.741570392486339", ",", " ", 
                    "0.0004242635955767906", ",", " ", 
                    "0.00042426359557679055", ",", " ", "\n", 
                    "                                ", 
                    "0.00023597267140166504", ",", " ", 
                    "0.0005871757440992308", ",", " ", "0.7853981633974483", 
                    ",", " ", "0.0872229994782981", ",", " ", 
                    "0.014192084898359495", ",", " ", "0.014192084898359499", 
                    ",", " ", "0.741570392486339", ",", " ", "\n", 
                    "                                ", "0.7853981633974483", 
                    ",", " ", "0.10902874934787263", ",", " ", "0", ",", " ", 
                    "0", ",", " ", "0.7461999764905778", ",", " ", 
                    "1.5707963267948966", ",", " ", "0.0872229994782981", ",",
                     " ", "0", ",", " ", "0.02007063894161039", ",", " ", 
                    "\n", "                                ", 
                    "0.741570392486339"}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "0.", ",", " ", "0", ",", " ", "0", ",", " ", "0", ",", 
                    " ", 
                    RowBox[{"-", "0.02007063894161039"}], ",", " ", 
                    "0.00462958400423874", ",", " ", "0.014976710306380547", 
                    ",", " ", "0", ",", " ", "0", ",", " ", "0", ",", " ", 
                    RowBox[{"-", "0.02007063894161039"}], ",", " ", "\n", 
                    "                                ", "0.00462958400423874",
                     ",", " ", "0.014976710306380547", ",", " ", "0", ",", 
                    " ", "0", ",", " ", "0", ",", " ", "0", ",", " ", 
                    "0.02007063894161039", ",", " ", "0.741570392486339", ",",
                     " ", "0.00042426359557679055", ",", " ", "0.", ",", " ", 
                    "0.00042426359557679055", ",", " ", "\n", 
                    "                                ", "0.", ",", " ", 
                    "1.5707963267948966", ",", " ", "0.0872229994782981", ",",
                     " ", "0", ",", " ", "0.02007063894161039", ",", " ", 
                    "0.741570392486339", ",", " ", "1.5707963267948966", ",", 
                    " ", "0.10902874934787263", ",", " ", "0", ",", " ", "0", 
                    ",", " ", "\n", "                                ", 
                    "0.7461999764905778", ",", " ", "0.7853981633974483", ",",
                     " ", "0.10902874934787263", ",", " ", "0", ",", " ", "0",
                     ",", " ", "0.7461999764905778"}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "0.", ",", " ", "0", ",", " ", "0", ",", " ", "0", ",", 
                    " ", "0", ",", " ", "0.", ",", " ", "0", ",", " ", "0", 
                    ",", " ", "0", ",", " ", "0", ",", " ", 
                    "0.019872334842201373", ",", " ", "\n", 
                    "                                ", 
                    "0.0024195679317141616", ",", " ", 
                    RowBox[{"-", "0.012382792667417267"}], ",", " ", "0", ",",
                     " ", "0", ",", " ", "0", ",", " ", "0", ",", " ", "0", 
                    ",", " ", "0.6231171508403164", ",", " ", 
                    "0.00040076400105675024", ",", " ", 
                    "0.00040076400105675024", ",", " ", "0.", ",", " ", "0.", 
                    ",", " ", "\n", "                                ", 
                    "1.5707963267948966", ",", " ", 
                    RowBox[{"-", "0.1090287493478726"}], ",", " ", "0", ",", 
                    " ", "0", ",", " ", "0.6231171508403164", ",", " ", 
                    "1.5707963267948966", ",", " ", 
                    RowBox[{"-", "0.08722299947829808"}], ",", " ", "0", ",", 
                    " ", "0.019872334842201373", ",", " ", "\n", 
                    "                                ", "0.6255367187720305", 
                    ",", " ", "2.356194490192345", ",", " ", 
                    RowBox[{"-", "0.1090287493478726"}], ",", " ", "0", ",", 
                    " ", "0", ",", " ", "0.6231171508403164"}], "}"}], ",", 
                    " ", 
                    RowBox[{"{", 
                    RowBox[{"0.000014083027682386569", ",", " ", 
                    RowBox[{"-", "0.000033999436430091554"}], ",", " ", "\n", 
                    "                                ", 
                    "0.0002792433212264629", ",", " ", 
                    "0.0001740013027138208", ",", " ", "0.019872334842201373",
                     ",", " ", "0.0024195679317141616", ",", " ", 
                    RowBox[{"-", "0.012382792667417267"}], ",", " ", "0", ",",
                     " ", "0", ",", " ", "0", ",", " ", 
                    "0.014051862724930291", ",", " ", "\n", 
                    "                                ", 
                    "0.0024195679317141616", ",", " ", 
                    RowBox[{"-", "0.008755956665157808"}], ",", " ", 
                    RowBox[{"-", "0.01405186272493029"}], ",", " ", 
                    "0.008755956665157806", ",", " ", "0", ",", " ", "0", ",",
                     " ", "0", ",", " ", "0.6231171508403164", ",", " ", 
                    "0.00040076400105675024", ",", " ", "\n", 
                    "                                ", 
                    "0.00023133274170821544", ",", " ", 
                    "0.00040076400105675024", ",", " ", 
                    "0.0005633156337111625", ",", " ", "2.356194490192345", 
                    ",", " ", 
                    RowBox[{"-", "0.1090287493478726"}], ",", " ", "0", ",", 
                    " ", "0", ",", " ", "0.6231171508403164", ",", " ", "\n", 
                    "                                ", "2.356194490192345", 
                    ",", " ", 
                    RowBox[{"-", "0.08722299947829808"}], ",", " ", 
                    RowBox[{"-", "0.01405186272493029"}], ",", " ", 
                    "0.014051862724930291", ",", " ", "0.6255367187720305", 
                    ",", " ", "1.5707963267948966", ",", " ", 
                    RowBox[{"-", "0.08722299947829808"}], ",", " ", "0", ",", 
                    " ", "\n", "                                ", 
                    "0.019872334842201373", ",", " ", "0.6255367187720305"}], 
                    "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "0.000042643341024432846"}], ",", " ", 
                    "0.0001029501322460779", ",", " ", 
                    RowBox[{"-", "0.0002901015347222037"}], ",", " ", 
                    RowBox[{"-", "0.00017942330264081457"}], ",", " ", "\n", 
                    "                                ", 
                    RowBox[{"-", "0.005820472117271082"}], ",", " ", "0.", 
                    ",", " ", "0.003640919029941847", ",", " ", 
                    RowBox[{"-", "0.01405186272493029"}], ",", " ", 
                    RowBox[{"-", "0.008789956101587898"}], ",", " ", 
                    "0.0002792433212264629", ",", " ", "0.020645058979085838",
                     ",", " ", "\n", "                                ", 
                    "0.007326440220870367", ",", " ", 
                    RowBox[{"-", "0.012768648979361894"}], ",", " ", "0", ",",
                     " ", "0", ",", " ", "0", ",", " ", "0", ",", " ", 
                    "0.019872334842201373", ",", " ", "0.6255367187720305", 
                    ",", " ", "0.0004798951865599198", ",", " ", 
                    "0.0009515559085625074", ",", " ", "\n", 
                    "                                ", 
                    "0.00023133274170821544", ",", " ", 
                    "0.0006215338597739909", ",", " ", "1.5707963267948966", 
                    ",", " ", 
                    RowBox[{"-", "0.08722299947829808"}], ",", " ", "0", ",", 
                    " ", "0.019872334842201373", ",", " ", 
                    "0.6255367187720305", ",", " ", "\n", 
                    "                                ", "1.5707963267948966", 
                    ",", " ", 
                    RowBox[{"-", "0.06541724960872355"}], ",", " ", "0", ",", 
                    " ", "0.04051739382128721", ",", " ", 
                    "0.6328631589929009", ",", " ", "2.356194490192345", ",", 
                    " ", 
                    RowBox[{"-", "0.08722299947829808"}], ",", " ", 
                    RowBox[{"-", "0.01405186272493029"}], ",", " ", "\n", 
                    "                                ", 
                    "0.014051862724930291", ",", " ", "0.6255367187720305"}], 
                    "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.00008694484346514781", ",", " ", 
                    RowBox[{"-", "0.00020990342027197087"}], ",", " ", 
                    "0.00059148349823182", ",", " ", "0.00036582337563956696",
                     ",", " ", "\n", "                                ", 
                    "0.02646553109635692", ",", " ", "0.007326440220870367", 
                    ",", " ", 
                    RowBox[{"-", "0.01645221135032817"}], ",", " ", 
                    "0.01405186272493029", ",", " ", "0.008892906233833976", 
                    ",", " ", 
                    RowBox[{"-", "0.0005693448559486666"}], ",", " ", "\n", 
                    "                                ", 
                    "0.014598261202107818", ",", " ", "0.007326440220870367", 
                    ",", " ", 
                    RowBox[{"-", "0.009028798279897483"}], ",", " ", 
                    RowBox[{"-", "0.014598261202107816"}], ",", " ", 
                    "0.009028798279897485", ",", " ", "0.", ",", " ", 
                    RowBox[{"-", "0.01405186272493029"}], ",", " ", "\n", 
                    "                                ", 
                    "0.014051862724930291", ",", " ", "0.6255367187720305", 
                    ",", " ", "0.0004798951865599198", ",", " ", 
                    "0.0009616616957775924", ",", " ", 
                    "0.0009515559085625074", ",", " ", 
                    "0.0012672357007717282", ",", " ", "\n", 
                    "                                ", "2.356194490192345", 
                    ",", " ", 
                    RowBox[{"-", "0.08722299947829808"}], ",", " ", 
                    RowBox[{"-", "0.01405186272493029"}], ",", " ", 
                    "0.014051862724930291", ",", " ", "0.6255367187720305", 
                    ",", " ", "2.356194490192345", ",", " ", 
                    RowBox[{"-", "0.06541724960872355"}], ",", " ", "\n", 
                    "                                ", 
                    RowBox[{"-", "0.028650123927038106"}], ",", " ", 
                    "0.02865012392703811", ",", " ", "0.6328631589929009", 
                    ",", " ", "1.5707963267948966", ",", " ", 
                    RowBox[{"-", "0.06541724960872355"}], ",", " ", "0", ",", 
                    " ", "0.04051739382128721", ",", " ", "\n", 
                    "                                ", 
                    "0.6328631589929009"}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "0.0001394679286909374"}], ",", " ", 
                    "0.0003367053649617445", ",", " ", 
                    RowBox[{"-", "0.0005036849306382235"}], ",", " ", 
                    RowBox[{"-", "0.000305121212466931"}], ",", " ", 
                    RowBox[{"-", "0.011867269894249102"}], ",", " ", "0.", 
                    ",", " ", "\n", "                                ", 
                    "0.007510357913895833", ",", " ", 
                    RowBox[{"-", "0.028650123927038106"}], ",", " ", 
                    RowBox[{"-", "0.01813160793400343"}], ",", " ", 
                    "0.0011608283541804866", ",", " ", "0.017580549805680898",
                     ",", " ", "0.011752317924320854", ",", " ", "\n", 
                    "                                ", 
                    RowBox[{"-", "0.010649908993202561"}], ",", " ", "0", ",",
                     " ", "0", ",", " ", "0", ",", " ", "0", ",", " ", 
                    "0.04051739382128721", ",", " ", "0.6328631589929009", 
                    ",", " ", "0.00044719270806433986", ",", " ", 
                    "0.0018261206627085398", ",", " ", 
                    "0.0009616616957775924", ",", " ", "\n", 
                    "                                ", 
                    "0.0012434151604020164", ",", " ", "1.5707963267948966", 
                    ",", " ", 
                    RowBox[{"-", "0.06541724960872355"}], ",", " ", "0", ",", 
                    " ", "0.04051739382128721", ",", " ", 
                    "0.6328631589929009", ",", " ", "1.5707963267948966", ",",
                     " ", "\n", "                                ", 
                    RowBox[{"-", "0.04361149973914903"}], ",", " ", "0", ",", 
                    " ", "0.05809794362696811", ",", " ", 
                    "0.6446154769172218", ",", " ", "2.356194490192345", ",", 
                    " ", 
                    RowBox[{"-", "0.06541724960872355"}], ",", " ", 
                    RowBox[{"-", "0.028650123927038106"}], ",", " ", "\n", 
                    "                                ", "0.02865012392703811",
                     ",", " ", "0.6328631589929009"}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.00019998324409994592", ",", " ", 
                    RowBox[{"-", "0.00048280226015345526"}], ",", " ", 
                    "0.0007222344762608717", ",", " ", 
                    "0.0004375137028675933", ",", " ", "\n", 
                    "                                ", "0.02944781969993", 
                    ",", " ", "0.011752317924320854", ",", " ", 
                    RowBox[{"-", "0.018299734835789335"}], ",", " ", 
                    "0.028650123927038106", ",", " ", "0.018468313298965176", 
                    ",", " ", 
                    RowBox[{"-", "0.0016645132848187101"}], ",", " ", "\n", 
                    "                                ", 
                    "0.012431325984584806", ",", " ", "0.011752317924320854", 
                    ",", " ", 
                    RowBox[{"-", "0.007530622868113131"}], ",", " ", 
                    RowBox[{"-", "0.012431325984584803"}], ",", " ", 
                    "0.007530622868113127", ",", " ", "0.", ",", " ", 
                    RowBox[{"-", "0.028650123927038106"}], ",", " ", "\n", 
                    "                                ", "0.02865012392703811",
                     ",", " ", "0.6328631589929009", ",", " ", 
                    "0.0004471927080643399", ",", " ", 
                    "0.0019772465852055643", ",", " ", 
                    "0.0018261206627085398", ",", " ", 
                    "0.0017829346135288734", ",", " ", "\n", 
                    "                                ", "2.356194490192345", 
                    ",", " ", 
                    RowBox[{"-", "0.06541724960872355"}], ",", " ", 
                    RowBox[{"-", "0.028650123927038106"}], ",", " ", 
                    "0.02865012392703811", ",", " ", "0.6328631589929009", 
                    ",", " ", "2.356194490192345", ",", " ", 
                    RowBox[{"-", "0.04361149973914903"}], ",", " ", "\n", 
                    "                                ", 
                    RowBox[{"-", "0.04108144991162291"}], ",", " ", 
                    "0.041081449911622915", ",", " ", "0.6446154769172218", 
                    ",", " ", "1.5707963267948966", ",", " ", 
                    RowBox[{"-", "0.04361149973914903"}], ",", " ", "0", ",", 
                    " ", "0.05809794362696811", ",", " ", "\n", 
                    "                                ", 
                    "0.6446154769172218"}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "0.00026242117578575627"}], ",", " ", 
                    "0.0006335407616358674", ",", " ", 
                    RowBox[{"-", "0.00039261647813520735"}], ",", " ", 
                    RowBox[{"-", "0.00021627924284377958"}], ",", " ", 
                    RowBox[{"-", "0.017016493715345193"}], ",", " ", "0.", 
                    ",", " ", "\n", "                                ", 
                    "0.01096909521177615", ",", " ", 
                    RowBox[{"-", "0.04108144991162291"}], ",", " ", 
                    RowBox[{"-", "0.026481738427231758"}], ",", " ", 
                    "0.0023867477610795816", ",", " ", "0.009557025834770423",
                     ",", " ", "0.015421577451593893", ",", " ", "\n", 
                    "                                ", 
                    RowBox[{"-", "0.005264644828969121"}], ",", " ", "0", ",",
                     " ", "0", ",", " ", "0", ",", " ", "0", ",", " ", 
                    "0.05809794362696811", ",", " ", "0.6446154769172218", 
                    ",", " ", "0.0003291617939019785", ",", " ", 
                    "0.0026316625192170677", ",", " ", 
                    "0.0019772465852055643", ",", " ", "\n", 
                    "                                ", 
                    "0.0015803625774590193", ",", " ", "1.5707963267948966", 
                    ",", " ", 
                    RowBox[{"-", "0.04361149973914903"}], ",", " ", "0", ",", 
                    " ", "0.05809794362696811", ",", " ", 
                    "0.6446154769172218", ",", " ", "1.5707963267948966", ",",
                     " ", "\n", "                                ", 
                    RowBox[{"-", "0.02180574986957451"}], ",", " ", "0", ",", 
                    " ", "0.06765496946173853", ",", " ", 
                    "0.6600370543688157", ",", " ", "2.356194490192345", ",", 
                    " ", 
                    RowBox[{"-", "0.04361149973914903"}], ",", " ", 
                    RowBox[{"-", "0.04108144991162291"}], ",", " ", "\n", 
                    "                                ", 
                    "0.041081449911622915", ",", " ", "0.6446154769172218"}], 
                    "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.00030558907123965154", ",", " ", 
                    RowBox[{"-", "0.0007377572802997646"}], ",", " ", 
                    "0.0004572013083451532", ",", " ", 
                    "0.0002518568585448476", ",", " ", "\n", 
                    "                                ", 
                    "0.026573519550115617", ",", " ", "0.015421577451593893", 
                    ",", " ", 
                    RowBox[{"-", "0.016496161216531028"}], ",", " ", 
                    "0.04108144991162291", ",", " ", "0.027115279188867625", 
                    ",", " ", 
                    RowBox[{"-", "0.002779364239214789"}], ",", " ", "\n", 
                    "                                ", 
                    "0.006757837775741189", ",", " ", "0.015421577451593893", 
                    ",", " ", 
                    RowBox[{"-", "0.0037226660591027534"}], ",", " ", 
                    RowBox[{"-", "0.006757837775741189"}], ",", " ", 
                    "0.003722666059102757", ",", " ", "0.", ",", " ", 
                    RowBox[{"-", "0.04108144991162291"}], ",", " ", "\n", 
                    "                                ", 
                    "0.041081449911622915", ",", " ", "0.6446154769172218", 
                    ",", " ", "0.00032916179390197846", ",", " ", 
                    "0.0026812586906176613", ",", " ", 
                    "0.0026316625192170677", ",", " ", 
                    "0.0018403298850466381", ",", " ", "\n", 
                    "                                ", "2.356194490192345", 
                    ",", " ", 
                    RowBox[{"-", "0.04361149973914903"}], ",", " ", 
                    RowBox[{"-", "0.04108144991162291"}], ",", " ", 
                    "0.041081449911622915", ",", " ", "0.6446154769172218", 
                    ",", " ", "2.356194490192345", ",", " ", 
                    RowBox[{"-", "0.02180574986957451"}], ",", " ", "\n", 
                    "                                ", 
                    RowBox[{"-", "0.0478392876873641"}], ",", " ", 
                    "0.047839287687364104", ",", " ", "0.6600370543688157", 
                    ",", " ", "1.5707963267948966", ",", " ", 
                    RowBox[{"-", "0.02180574986957451"}], ",", " ", "0", ",", 
                    " ", "0.06765496946173853", ",", " ", 
                    "0.6600370543688157"}], "}"}], ",", " ", "\n", 
                    "                               ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "0.00035636468503722624"}], ",", " ", 
                    "0.0008603404557676955", ",", " ", 
                    RowBox[{"-", "2.1826118294997025*^-6"}], ",", " ", 
                    "0.00005676570257888815", ",", " ", 
                    RowBox[{"-", "0.019815681774374427"}], ",", " ", "0.", 
                    ",", " ", "0.013079084228667923", ",", " ", "\n", 
                    "                                ", 
                    RowBox[{"-", "0.0478392876873641"}], ",", " ", 
                    RowBox[{"-", "0.03157570252827015"}], ",", " ", 
                    "0.003236565547559942", ",", " ", "0.0000456238362862571",
                     ",", " ", "0.017983972951063354", ",", " ", 
                    "0.0011865917182935365", ",", " ", "0", ",", " ", "0", 
                    ",", " ", "0", ",", " ", "0", ",", " ", "\n", 
                    "                                ", "0.06765496946173853",
                     ",", " ", "0.6600370543688157", ",", " ", 
                    "0.00032342536463901583", ",", " ", 
                    "0.003006492190099026", ",", " ", "0.0026812586906176613",
                     ",", " ", "0.0018624567134477466", ",", " ", "\n", 
                    "                                ", "1.5707963267948966", 
                    ",", " ", 
                    RowBox[{"-", "0.02180574986957451"}], ",", " ", "0", ",", 
                    " ", "0.06765496946173853", ",", " ", 
                    "0.6600370543688157", ",", " ", "1.5707963267948966", ",",
                     " ", "0", ",", " ", "0", ",", " ", "0.06770059329802479",
                     ",", " ", "\n", "                                ", 
                    "0.678021027319879", ",", " ", "2.356194490192345", ",", 
                    " ", 
                    RowBox[{"-", "0.02180574986957451"}], ",", " ", 
                    RowBox[{"-", "0.0478392876873641"}], ",", " ", 
                    "0.047839287687364104", ",", " ", "0.6600370543688157"}], 
                    "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "0.00035660500328994066", ",", " ", "\n", 
                    "                                ", 
                    RowBox[{"-", "0.0008609206353526744"}], ",", " ", 
                    "2.184083696615737*^-6", ",", " ", 
                    RowBox[{"-", "0.00005680398312415632"}], ",", " ", 
                    "0.019861305610660684", ",", " ", "0.017983972951063354", 
                    ",", " ", 
                    RowBox[{"-", "0.012248857195411612"}], ",", " ", "\n", 
                    "                                ", "0.0478392876873641", 
                    ",", " ", "0.03243604298403784", ",", " ", 
                    RowBox[{"-", "0.003238748159389442"}], ",", " ", 
                    "0.00003226092402176112", ",", " ", 
                    "0.017983972951063354", ",", " ", "0.0008390470505051581",
                     ",", " ", "\n", "                                ", 
                    RowBox[{"-", "0.00003226092402176112"}], ",", " ", 
                    RowBox[{"-", "0.0008390470505051512"}], ",", " ", "0.", 
                    ",", " ", 
                    RowBox[{"-", "0.0478392876873641"}], ",", " ", 
                    "0.047839287687364104", ",", " ", "0.6600370543688157", 
                    ",", " ", "0.00032342536463901583", ",", " ", "\n", 
                    "                                ", 
                    "0.002684876179637003", ",", " ", "0.003006492190099026", 
                    ",", " ", "0.0018637126806126214", ",", " ", 
                    "2.356194490192345", ",", " ", 
                    RowBox[{"-", "0.02180574986957451"}], ",", " ", 
                    RowBox[{"-", "0.0478392876873641"}], ",", " ", "\n", 
                    "                                ", 
                    "0.047839287687364104", ",", " ", "0.6600370543688157", 
                    ",", " ", "2.356194490192345", ",", " ", "0", ",", " ", 
                    RowBox[{"-", "0.04787154861138586"}], ",", " ", 
                    "0.047871548611385865", ",", " ", "0.678021027319879", 
                    ",", " ", "1.5707963267948966", ",", " ", "0", ",", " ", 
                    "\n", "                                ", "0", ",", " ", 
                    "0.06770059329802479", ",", " ", "0.678021027319879"}], 
                    "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "0.00037766137882287026"}], ",", " ", 
                    "0.0009117552227386957", ",", " ", 
                    "0.0003226750016321464", ",", " ", 
                    "0.0002805068056190539", ",", " ", "\n", 
                    "                                ", 
                    RowBox[{"-", "0.019829044686638923"}], ",", " ", "0.", 
                    ",", " ", "0.013444509249206711", ",", " ", 
                    RowBox[{"-", "0.04787154861138586"}], ",", " ", 
                    RowBox[{"-", "0.032457916568885366"}], ",", " ", 
                    "0.0032409322430860575", ",", " ", 
                    RowBox[{"-", "0.006740433743883535"}], ",", " ", "\n", 
                    "                                ", 
                    "0.019045868562560853", ",", " ", "0.00585957241317106", 
                    ",", " ", "0", ",", " ", "0", ",", " ", "0", ",", " ", 
                    "0", ",", " ", "0.06770059329802479", ",", " ", 
                    "0.678021027319879", ",", " ", "0.0004081785563580276", 
                    ",", " ", "0.0028257420121654392", ",", " ", "\n", 
                    "                                ", 
                    "0.002684876179637003", ",", " ", "0.0020765787824438436",
                     ",", " ", "1.5707963267948966", ",", " ", "0", ",", " ", 
                    "0", ",", " ", "0.06770059329802479", ",", " ", 
                    "0.678021027319879", ",", " ", "1.5707963267948966", ",", 
                    " ", "\n", "                                ", 
                    "0.021805749869574537", ",", " ", "0", ",", " ", 
                    "0.060960159554141254", ",", " ", "0.6970668958824399", 
                    ",", " ", "2.356194490192345", ",", " ", "0", ",", " ", 
                    RowBox[{"-", "0.04787154861138586"}], ",", " ", 
                    "0.047871548611385865", ",", " ", "\n", 
                    "                                ", "0.678021027319879"}],
                     "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.00034006050447937634", ",", " ", 
                    RowBox[{"-", "0.0008209786819415414"}], ",", " ", 
                    RowBox[{"-", "0.00029054870312639246"}], ",", " ", 
                    RowBox[{"-", "0.00025257887403268785"}], ",", " ", 
                    "0.013088610942755388", ",", " ", "\n", 
                    "                                ", 
                    "0.019045868562560853", ",", " ", 
                    RowBox[{"-", "0.007962598214858521"}], ",", " ", 
                    "0.04787154861138586", ",", " ", "0.03336967179162406", 
                    ",", " ", 
                    RowBox[{"-", "0.002918257241453911"}], ",", " ", 
                    RowBox[{"-", "0.004766206408438681"}], ",", " ", "\n", 
                    "                                ", 
                    "0.019045868562560853", ",", " ", "0.0041433433882068806",
                     ",", " ", "0.004766206408438681", ",", " ", 
                    RowBox[{"-", "0.0041433433882068806"}], ",", " ", "0.", 
                    ",", " ", 
                    RowBox[{"-", "0.04787154861138586"}], ",", " ", 
                    "0.047871548611385865", ",", " ", "\n", 
                    "                                ", "0.678021027319879", 
                    ",", " ", "0.0004081785563580277", ",", " ", 
                    "0.00217686502907768", ",", " ", "0.0028257420121654392", 
                    ",", " ", "0.0018698296091330473", ",", " ", 
                    "2.356194490192345", ",", " ", "0", ",", " ", "\n", 
                    "                                ", 
                    RowBox[{"-", "0.04787154861138586"}], ",", " ", 
                    "0.047871548611385865", ",", " ", "0.678021027319879", 
                    ",", " ", "2.356194490192345", ",", " ", 
                    "0.021805749869574537", ",", " ", 
                    RowBox[{"-", "0.04310534220294718"}], ",", " ", 
                    "0.043105342202947185", ",", " ", "\n", 
                    "                                ", "0.6970668958824399", 
                    ",", " ", "1.5707963267948966", ",", " ", 
                    "0.021805749869574537", ",", " ", "0", ",", " ", 
                    "0.060960159554141254", ",", " ", "0.6970668958824399"}], 
                    "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "0.00032608845422653094"}], ",", " ", "\n", 
                    "                                ", 
                    "0.0007872471687269574", ",", " ", 
                    "0.00044499526160833277", ",", " ", 
                    "0.00035818217870585596", ",", " ", 
                    RowBox[{"-", "0.01785481735119407"}], ",", " ", "0.", ",",
                     " ", "0.01244600210754478", ",", " ", 
                    RowBox[{"-", "0.04310534220294718"}], ",", " ", "\n", 
                    "                                ", 
                    RowBox[{"-", "0.030047307085358722"}], ",", " ", 
                    "0.0026277085383275187", ",", " ", 
                    RowBox[{"-", "0.010323436466719606"}], ",", " ", 
                    "0.018263331839948438", ",", " ", "0.008309461435649299", 
                    ",", " ", "0", ",", " ", "0", ",", " ", "0", ",", " ", 
                    "0", ",", " ", "0.060960159554141254", ",", " ", "\n", 
                    "                                ", "0.6970668958824399", 
                    ",", " ", "0.0004401226303784706", ",", " ", 
                    "0.0022483415143562807", ",", " ", "0.00217686502907768", 
                    ",", " ", "0.0019226154763782855", ",", " ", 
                    "1.5707963267948966", ",", " ", "\n", 
                    "                                ", 
                    "0.021805749869574537", ",", " ", "0", ",", " ", 
                    "0.060960159554141254", ",", " ", "0.6970668958824399", 
                    ",", " ", "1.5707963267948966", ",", " ", 
                    "0.04361149973914906", ",", " ", "0", ",", " ", 
                    "0.05063672308742165", ",", " ", "\n", 
                    "                                ", "0.7153302277223883", 
                    ",", " ", "2.356194490192345", ",", " ", 
                    "0.021805749869574537", ",", " ", 
                    RowBox[{"-", "0.04310534220294718"}], ",", " ", 
                    "0.043105342202947185", ",", " ", "0.6970668958824399"}], 
                    "}"}], ",", " ", "\n", "                               ", 
                    
                    RowBox[{"{", 
                    RowBox[{"0.00027086626543372516", ",", " ", 
                    RowBox[{"-", "0.0006539290115994377"}], ",", " ", 
                    RowBox[{"-", "0.00036963652985952736"}], ",", " ", 
                    RowBox[{"-", "0.0002975250053581212"}], ",", " ", 
                    "0.007531380884474463", ",", " ", "0.018263331839948438", 
                    ",", " ", "\n", "                                ", 
                    RowBox[{"-", "0.004462629126122004"}], ",", " ", 
                    "0.04310534220294718", ",", " ", "0.03083455425408568", 
                    ",", " ", 
                    RowBox[{"-", "0.002182713276719186"}], ",", " ", 
                    RowBox[{"-", "0.007299771930765926"}], ",", " ", 
                    "0.018263331839948438", ",", " ", "\n", 
                    "                                ", 
                    "0.005875676529155726", ",", " ", "0.007299771930765919", 
                    ",", " ", 
                    RowBox[{"-", "0.0058756765291557225"}], ",", " ", 
                    "2.168404344971009*^-19", ",", " ", 
                    RowBox[{"-", "0.04310534220294718"}], ",", " ", 
                    "0.043105342202947185", ",", " ", "\n", 
                    "                                ", "0.6970668958824399", 
                    ",", " ", "0.0004401226303784705", ",", " ", 
                    "0.0015020019563451233", ",", " ", 
                    "0.0022483415143562807", ",", " ", "0.001597025798373995",
                     ",", " ", "2.356194490192345", ",", " ", "\n", 
                    "                                ", 
                    "0.021805749869574537", ",", " ", 
                    RowBox[{"-", "0.04310534220294718"}], ",", " ", 
                    "0.043105342202947185", ",", " ", "0.6970668958824399", 
                    ",", " ", "2.356194490192345", ",", " ", 
                    "0.04361149973914906", ",", " ", 
              