(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[    160277,       3704]
NotebookOptionsPosition[    159072,       3658]
NotebookOutlinePosition[    159714,       3683]
CellTagsIndexPosition[    159671,       3680]
WindowTitle->Light Rays in a Lens - Source
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Light Rays in a Lens", "Section",
 CellFrame->{{0, 0}, {0, 0}},
 ShowCellBracket->False,
 FontColor->RGBColor[0.597406, 0, 0.0527047]],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztnVuSozgWQDNiPqa3MJ+zpVlCbaB3WlGVNV9dvYH6TQRUph/ZGIHQmwvG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   "], {{0, 0}, {1800, 25}}, {0, 255},
   ColorFunction->RGBColor],
  ImageSize->{1800, 25},
  PlotRange->{{0, 1800}, {0, 25}}]], "Section",
 CellFrame->{{0, 0}, {0, 0}},
 ShowCellBracket->False],

Cell[BoxData[
 RowBox[{"Manipulate", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"h", "=", "2.5"}], ",", "head", ",", "radius", ",", 
       "lfocusloc", ",", "rfocusloc", ",", "imgloc", ",", "objdist"}], "}"}], 
     ",", "\[IndentingNewLine]", "            ", 
     RowBox[{"(*", "\:041e\:043f\:0438\:0441", "*)"}], "\[IndentingNewLine]", 
     
     RowBox[{
      RowBox[{
       RowBox[{"imagedistance", "[", 
        RowBox[{"foclength_", ",", "objdistance_"}], "]"}], ":=", 
       "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"lenstype", "\[Equal]", "\"\<converging\>\""}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{
             "ptobj", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], 
             "\[Equal]", 
             RowBox[{
             "rfocusloc", "\[LeftDoubleBracket]", "1", 
              "\[RightDoubleBracket]"}]}], "||", 
            RowBox[{
             RowBox[{
             "ptobj", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], 
             "\[Equal]", 
             RowBox[{
             "lfocusloc", "\[LeftDoubleBracket]", "1", 
              "\[RightDoubleBracket]"}]}], "||", 
            RowBox[{"objdistance", "==", "0"}]}], ",", "0", ",", 
           RowBox[{
            RowBox[{"Solve", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"1", "/", "foclength"}], " ", "==", " ", 
               RowBox[{
                RowBox[{"1", "/", "objdistance"}], " ", "+", " ", 
                RowBox[{"1", "/", "q"}]}]}], ",", "q"}], "]"}], "[", 
            RowBox[{"[", 
             RowBox[{"1", ",", "1", ",", "2"}], "]"}], "]"}]}], "]"}], ",", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{
             "ptobj", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], 
             "\[Equal]", 
             RowBox[{
             "rfocusloc", "\[LeftDoubleBracket]", "1", 
              "\[RightDoubleBracket]"}]}], "||", 
            RowBox[{
             RowBox[{
             "ptobj", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], 
             "\[Equal]", 
             RowBox[{
             "lfocusloc", "\[LeftDoubleBracket]", "1", 
              "\[RightDoubleBracket]"}]}], "||", 
            RowBox[{"objdistance", "==", "0"}]}], ",", "0", ",", 
           RowBox[{
            RowBox[{"Solve", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"1", "/", 
                RowBox[{"-", "foclength"}]}], " ", "==", " ", 
               RowBox[{
                RowBox[{"1", "/", "objdistance"}], " ", "+", " ", 
                RowBox[{"1", "/", "q"}]}]}], ",", "q"}], "]"}], "[", 
            RowBox[{"[", 
             RowBox[{"1", ",", "1", ",", "2"}], "]"}], "]"}]}], "]"}]}], 
        "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"magnification", "[", 
        RowBox[{"imgdistance_", ",", "objdistance_"}], "]"}], ":=", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{
           "ptobj", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], 
           "\[Equal]", 
           RowBox[{
           "rfocusloc", "\[LeftDoubleBracket]", "1", 
            "\[RightDoubleBracket]"}]}], "||", 
          RowBox[{
           RowBox[{
           "ptobj", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], 
           "\[Equal]", 
           RowBox[{
           "lfocusloc", "\[LeftDoubleBracket]", "1", 
            "\[RightDoubleBracket]"}]}], "||", 
          RowBox[{"objdistance", "==", "0"}], "||", 
          RowBox[{"imgdistance", "\[Equal]", "0"}]}], ",", "0", ",", 
         RowBox[{"imgdistance", "/", "objdistance"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", "            ", 
      RowBox[{
      "(*", "\:0420\:043e\:0437\:0440\:0430\:0445\:0443\:043d\:043e\:043a", 
       "*)"}], "\[IndentingNewLine]", 
      RowBox[{"radius", " ", "=", 
       RowBox[{"7", "focus"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"lfocusloc", " ", "=", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "focus"}], "+", 
          RowBox[{
          "location", "\[LeftDoubleBracket]", "1", 
           "\[RightDoubleBracket]"}]}], ",", "0"}], "}"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"rfocusloc", " ", "=", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"focus", "+", 
          RowBox[{
          "location", "\[LeftDoubleBracket]", "1", 
           "\[RightDoubleBracket]"}]}], ",", "0"}], "}"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"objdist", " ", "=", 
       RowBox[{"Abs", "[", 
        RowBox[{
         RowBox[{
         "location", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], 
         "-", 
         RowBox[{
         "ptobj", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}]}], 
        "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"imgloc", " ", "=", " ", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
          "ptobj", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], 
          "<", 
          RowBox[{
          "location", "\[LeftDoubleBracket]", "1", 
           "\[RightDoubleBracket]"}]}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{
            "location", "\[LeftDoubleBracket]", "1", 
             "\[RightDoubleBracket]"}], "+", 
            RowBox[{"imagedistance", "[", 
             RowBox[{"focus", ",", "objdist"}], "]"}]}], ",", 
           RowBox[{
            RowBox[{"magnification", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "1"}], "*", 
               RowBox[{"imagedistance", "[", 
                RowBox[{"focus", ",", "objdist"}], "]"}]}], ",", "objdist"}], 
             "]"}], "*", 
            RowBox[{"Last", "[", "ptobj", "]"}]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{
            "location", "\[LeftDoubleBracket]", "1", 
             "\[RightDoubleBracket]"}], "-", 
            RowBox[{"imagedistance", "[", 
             RowBox[{"focus", ",", "objdist"}], "]"}]}], ",", 
           RowBox[{
            RowBox[{"magnification", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "1"}], "*", 
               RowBox[{"imagedistance", "[", 
                RowBox[{"focus", ",", "objdist"}], "]"}]}], ",", "objdist"}], 
             "]"}], "*", 
            RowBox[{"Last", "[", "ptobj", "]"}]}]}], "}"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"head", "=", 
       RowBox[{"Graphics", "[", 
        RowBox[{"Line", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "1"}], "/", "2"}], ",", 
             RowBox[{"1", "/", "4"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"0", ",", "0"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "1"}], "/", "2"}], ",", 
             RowBox[{
              RowBox[{"-", "1"}], "/", "4"}]}], "}"}]}], "}"}], "]"}], 
        "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"source", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"x0_", ",", "y0_"}], "}"}], ",", "r0_"}], "]"}], ":=", 
       RowBox[{"{", 
        RowBox[{"Orange", ",", 
         RowBox[{"Disk", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"x0", ",", "y0"}], "}"}], ",", "r0"}], "]"}], ",", 
         RowBox[{"Line", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"x0", ",", "y0"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"x0", "+", 
               RowBox[{"2", "r0"}]}], ",", "y0"}], "}"}]}], "}"}], "]"}], ",", 
         RowBox[{"Line", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"x0", ",", "y0"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"x0", "-", 
               RowBox[{"2", "r0"}]}], ",", "y0"}], "}"}]}], "}"}], "]"}], ",", 
         RowBox[{"Line", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"x0", ",", "y0"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"x0", ",", 
              RowBox[{"y0", "+", 
               RowBox[{"2", "r0"}]}]}], "}"}]}], "}"}], "]"}], ",", 
         RowBox[{"Line", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"x0", ",", "y0"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"x0", ",", 
              RowBox[{"y0", "-", 
               RowBox[{"2", "r0"}]}]}], "}"}]}], "}"}], "]"}], ",", 
         RowBox[{"Line", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"x0", ",", "y0"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"x0", "-", 
               RowBox[{"1.6", "r0"}]}], ",", 
              RowBox[{"y0", "-", 
               RowBox[{"1.6", "r0"}]}]}], "}"}]}], "}"}], "]"}], ",", 
         RowBox[{"Line", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"x0", ",", "y0"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"x0", "+", 
               RowBox[{"1.6", "r0"}]}], ",", 
              RowBox[{"y0", "-", 
               RowBox[{"1.6", "r0"}]}]}], "}"}]}], "}"}], "]"}], ",", 
         RowBox[{"Line", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"x0", ",", "y0"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"x0", "-", 
               RowBox[{"1.6", "r0"}]}], ",", 
              RowBox[{"y0", "+", 
               RowBox[{"1.6", "r0"}]}]}], "}"}]}], "}"}], "]"}], ",", 
         RowBox[{"Line", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"x0", ",", "y0"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"x0", "+", 
               RowBox[{"1.6", "r0"}]}], ",", 
              RowBox[{"y0", "+", 
               RowBox[{"1.6", "r0"}]}]}], "}"}]}], "}"}], "]"}]}], "}"}]}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"line2", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"x1_", ",", "y1_"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"x2_", ",", "y2_"}], "}"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"x3_", ",", "x4_"}], "}"}]}], "]"}], ":=", 
       RowBox[{"Line", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"x3", ",", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"y2", "-", "y1"}], ")"}], "/", 
               RowBox[{"(", 
                RowBox[{"x2", "-", "x1"}], ")"}]}], "x3"}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"x2", " ", "y1"}], "-", 
                RowBox[{"x1", " ", "y2"}]}], ")"}], "/", 
              RowBox[{"(", 
               RowBox[{"x2", "-", "x1"}], ")"}]}]}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"x4", ",", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"y2", "-", "y1"}], ")"}], "/", 
               RowBox[{"(", 
                RowBox[{"x2", "-", "x1"}], ")"}]}], "x4"}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"x2", " ", "y1"}], "-", 
                RowBox[{"x1", " ", "y2"}]}], ")"}], "/", 
              RowBox[{"(", 
               RowBox[{"x2", "-", "x1"}], ")"}]}]}]}], "}"}]}], "}"}], 
        "]"}]}], ";", 
      RowBox[{"(*", 
       RowBox[{
        RowBox[{
        "\:043b\:0456\:043d\:0456\:044f", " ", "\:0437", " ", 
         "\:043f\:043e\:0447\:0430\:0442\:043a\:043e\:043c", " ", "\:0432", 
         " ", "\:0442", ".3"}], ",", " ", 
        RowBox[{
        "\:0437\:0430\:043a\:0456\:043d\:0447\:0435\:043d\:043d\:044f\:043c", 
         " ", "\:0432", " ", "\:0442", ".4", "  ", "\:0456", " ", 
         "\:043f\:0440\:043e\:0445\:043e\:0434\:0438\:0442\:044c", " ", 
         "\:0447\:0435\:0440\:0435\:0437", " ", 
         "\:0442\:043e\:0447\:043a\:0438", " ", "1", " ", "\:0456", " ", 
         "2"}]}], "*)"}], "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"arrow2", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"x1_", ",", "y1_"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"x2_", ",", "y2_"}], "}"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"x3_", ",", "x4_"}], "}"}]}], "]"}], ":=", 
       RowBox[{"Arrow", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"x3", ",", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"y2", "-", "y1"}], ")"}], "/", 
               RowBox[{"(", 
                RowBox[{"x2", "-", "x1"}], ")"}]}], "x3"}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"x2", " ", "y1"}], "-", 
                RowBox[{"x1", " ", "y2"}]}], ")"}], "/", 
              RowBox[{"(", 
               RowBox[{"x2", "-", "x1"}], ")"}]}]}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"x4", ",", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"y2", "-", "y1"}], ")"}], "/", 
               RowBox[{"(", 
                RowBox[{"x2", "-", "x1"}], ")"}]}], "x4"}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"x2", " ", "y1"}], "-", 
                RowBox[{"x1", " ", "y2"}]}], ")"}], "/", 
              RowBox[{"(", 
               RowBox[{"x2", "-", "x1"}], ")"}]}]}]}], "}"}]}], "}"}], 
        "]"}]}], ";", 
      RowBox[{"(*", 
       RowBox[{
        RowBox[{
        "\:0441\:0442\:0440\:0456\:043b\:043a\:0430", " ", "\:0437", " ", 
         "\:043f\:043e\:0447\:0430\:0442\:043a\:043e\:043c", " ", "\:0432", 
         " ", "\:0442", ".3"}], ",", " ", 
        RowBox[{
        "\:0437\:0430\:043a\:0456\:043d\:0447\:0435\:043d\:043d\:044f\:043c", 
         " ", "\:0432", " ", "\:0442", ".4", "  ", "\:0456", " ", 
         "\:043f\:0440\:043e\:0445\:043e\:0434\:0438\:0442\:044c", " ", 
         "\:0447\:0435\:0440\:0435\:0437", " ", 
         "\:0442\:043e\:0447\:043a\:0438", " ", "1", " ", "\:0456", " ", 
         "2"}]}], "*)"}], "\[IndentingNewLine]", 
      RowBox[{"(*", 
       RowBox[{
       "\:041f\:043e\:0431\:0443\:0434\:043e\:0432\:0430", " ", 
        "\:0413\:0440\:0430\:0444\:0456\:0447\:043d\:043e\:0433\:043e", " ", 
        "\:0437\:043e\:0431\:0440\:0430\:0436\:0435\:043d\:043d\:044f"}], 
       "*)"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"Graphics", "[", "\[IndentingNewLine]", 
       RowBox[{"(*", 
        RowBox[{
        "\:041f\:0435\:0440\:0435\:0432\:0456\:0440\:043a\:0430", " ", 
         "\:0442\:0438\:043f\:0443", " ", "\:043b\:0456\:043d\:0437\:0438"}], 
        "*)"}], "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"lenstype", "\[Equal]", "\"\<converging\>\""}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"{", 
           RowBox[{"(*", 
            RowBox[{
            "\:0414\:043b\:044f", " ", 
             "\:0437\:0431\:0438\:0440\:0430\:043b\:044c\:043d\:043e\:0457", 
             " ", "\:043b\:0456\:043d\:0437\:0438"}], "*)"}], 
           "\[IndentingNewLine]", 
           RowBox[{"(*", 
            RowBox[{
            "\:043b\:0456\:0432\:0430", " ", 
             "\:0447\:0430\:0441\:0442\:0438\:043d\:0430", " ", 
             RowBox[{
             "\:0437\:0431\:0438\:0440", ".", 
              "\:043b\:0456\:043d\:0437\:0438"}]}], "*)"}], 
           "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"Thick", ",", "LightGray", ",", 
              RowBox[{"Circle", "[", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"First", "[", "location", "]"}], "+", 
                   RowBox[{"Sqrt", "[", 
                    RowBox[{
                    RowBox[{"radius", "^", "2"}], "-", 
                    RowBox[{"h", "^", "2"}]}], "]"}]}], ",", "0"}], "}"}], 
                ",", "radius", ",", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"Pi", " ", "-", " ", 
                   RowBox[{"ArcTan", "[", 
                    RowBox[{"h", "/", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{
                    RowBox[{"radius", "^", "2"}], "-", 
                    RowBox[{"h", "^", "2"}]}], "]"}]}], "]"}]}], ",", 
                  RowBox[{"Pi", " ", "+", " ", 
                   RowBox[{"ArcTan", "[", 
                    RowBox[{"h", "/", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{
                    RowBox[{"radius", "^", "2"}], "-", 
                    RowBox[{"h", "^", "2"}]}], "]"}]}], "]"}]}]}], "}"}]}], 
               "]"}]}], "}"}], ",", "\[IndentingNewLine]", 
            RowBox[{"(*", 
             RowBox[{
             "\:043f\:0440\:0430\:0432\:0430", " ", 
              "\:0447\:0430\:0441\:0442\:0438\:043d\:0430", " ", 
              RowBox[{
              "\:0437\:0431\:0438\:0440", ".", 
               "\:043b\:0456\:043d\:0437\:0438"}]}], "*)"}], 
            "\[IndentingNewLine]", 
            RowBox[{"{", 
             RowBox[{"Thick", ",", "LightGray", ",", 
              RowBox[{"Circle", "[", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{
                   RowBox[{
                   "location", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}], "-", 
                   RowBox[{"Sqrt", "[", 
                    RowBox[{
                    RowBox[{"radius", "^", "2"}], "-", 
                    RowBox[{"h", "^", "2"}]}], "]"}]}], ",", "0"}], "}"}], 
                ",", "radius", ",", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", 
                   RowBox[{"ArcTan", "[", 
                    RowBox[{"h", "/", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{
                    RowBox[{"radius", "^", "2"}], "-", 
                    RowBox[{"h", "^", "2"}]}], "]"}]}], "]"}]}], ",", 
                  RowBox[{"ArcTan", "[", 
                   RowBox[{"h", "/", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{
                    RowBox[{"radius", "^", "2"}], "-", 
                    RowBox[{"h", "^", "2"}]}], "]"}]}], "]"}]}], "}"}]}], 
               "]"}]}], "}"}], ",", "\[IndentingNewLine]", " ", 
            RowBox[{"(*", 
             RowBox[{
             "\:0441\:0445\:0435\:043c\:0430\:0442\:0438\:0447\:043d\:0435", 
              " ", "\:0437\:043e\:0431\:0440\:0430\:0436\:0435\:043d\:043d\
\:044f", " ", 
              RowBox[{
              "\:0437\:0431\:0438\:0440", ".", 
               "\:043b\:0456\:043d\:0437\:0438"}]}], "*)"}], 
            "\[IndentingNewLine]", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"Arrowheads", "[", 
               RowBox[{"{", 
                RowBox[{"{", 
                 RowBox[{"Automatic", ",", "Automatic", ",", "head"}], "}"}], 
                "}"}], "]"}], ",", "Thick", ",", 
              RowBox[{"Arrow", "[", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{
                   "location", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}], ",", "0"}], "}"}], ",", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{
                   "location", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}], ",", 
                   RowBox[{"1.3", "h"}]}], "}"}]}], "}"}], "]"}]}], "}"}], 
            ",", "\[IndentingNewLine]", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"Arrowheads", "[", 
               RowBox[{"{", 
                RowBox[{"{", 
                 RowBox[{"Automatic", ",", "Automatic", ",", "head"}], "}"}], 
                "}"}], "]"}], ",", "Thick", ",", 
              RowBox[{"Arrow", "[", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{
                   "location", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}], ",", "0"}], "}"}], ",", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{
                   "location", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}], ",", 
                   RowBox[{
                    RowBox[{"-", "1.3"}], "h"}]}], "}"}]}], "}"}], "]"}]}], 
             "}"}], ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"PointSize", "[", "Large", "]"}], ",", "Red", ",", 
              RowBox[{"Point", "[", "rfocusloc", "]"}]}], "}"}], ",", 
            RowBox[{"(*", 
             RowBox[{
             "\:0442\:043e\:0447\:043a\:0430", " ", 
              "\:043f\:0440\:0430\:0432\:043e\:0433\:043e", " ", 
              "\:0444\:043e\:043a\:0443\:0441\:0430"}], "*)"}], 
            "\[IndentingNewLine]", 
            RowBox[{"Text", "[", 
             RowBox[{
              RowBox[{"Style", "[", 
               RowBox[{"\"\<F\>\"", ",", 
                RowBox[{"FontSize", "\[Rule]", "14"}], ",", "Italic", ",", 
                RowBox[{"FontColor", "\[Rule]", "Red"}]}], "]"}], ",", 
              RowBox[{"rfocusloc", "+", ".2"}]}], "]"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"PointSize", "[", "Large", "]"}], ",", "Red", ",", 
              RowBox[{"Point", "[", "lfocusloc", "]"}]}], "}"}], ",", 
            RowBox[{"(*", 
             RowBox[{
             "\:0442\:043e\:0447\:043a\:0430", " ", 
              "\:043b\:0456\:0432\:043e\:0433\:043e", " ", 
              "\:0444\:043e\:043a\:0443\:0441\:0430"}], "*)"}], 
            "\[IndentingNewLine]", 
            RowBox[{
            "(*", "\:043f\:0440\:0435\:0434\:043c\:0435\:0442", "*)"}], 
            "\[IndentingNewLine]", 
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"Abs", "[", 
                RowBox[{
                "ptobj", "\[LeftDoubleBracket]", "2", 
                 "\[RightDoubleBracket]"}], "]"}], ">", 
               RowBox[{"0.02", "h"}]}], ",", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"Arrowheads", "[", "Large", "]"}], ",", "Thick", ",", 
                "Blue", ",", 
                RowBox[{"Arrow", "[", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    "ptobj", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}], ",", "0"}], "}"}], ",", 
                   "ptobj"}], "}"}], "]"}]}], "}"}], ",", 
              RowBox[{"source", "[", 
               RowBox[{"ptobj", ",", "0.15"}], "]"}]}], "]"}], ",", 
            "\[IndentingNewLine]", "\[IndentingNewLine]", 
            RowBox[{"{", 
             RowBox[{"Thick", ",", 
              RowBox[{"Line", "[", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"-", "5"}], ",", "0"}], "}"}], ",", 
                 RowBox[{"{", 
                  RowBox[{"5", ",", "0"}], "}"}]}], "}"}], "]"}]}], "}"}], 
            ",", "\[IndentingNewLine]", 
            RowBox[{"Line", "[", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                 RowBox[{
                 "location", "\[LeftDoubleBracket]", "1", 
                  "\[RightDoubleBracket]"}], ",", 
                 RowBox[{"-", "h"}]}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{
                 "location", "\[LeftDoubleBracket]", "1", 
                  "\[RightDoubleBracket]"}], ",", "h"}], "}"}]}], "}"}], 
             "]"}], ",", 
            RowBox[{"(*", 
             RowBox[{
             "\:043e\:043f\:0442\:0438\:0447\:043d\:0430", " ", 
              "\:0432\:0456\:0441\:044c"}], "*)"}], "\[IndentingNewLine]", 
            RowBox[{"{", "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"If", " ", "[", 
               RowBox[{"ray1", ",", 
                RowBox[{"(*", 
                 RowBox[{
                 "\:043f\:0440\:043e\:043c\:0456\:043d\:044c", " ", 
                  "\:0432\:0456\:0434", " ", 
                  "\:043f\:0440\:0435\:0434\:043c\:0435\:0442\:0430", " ", 
                  "\:0434\:043e", " ", "\:043b\:0456\:043d\:0437\:0438", " ", 
                  "\:043f\:0430\:0440\:0430\:043b\:0435\:043b\:044c\:043d\
\:0438\:0439", " ", "\:043e\:043f\:0442\:0438\:0447\:043d\:0456\:0439", " ", 
                  "\:043e\:0441\:0456"}], "*)"}], "\[IndentingNewLine]", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"Arrowheads", "[", "Medium", "]"}], ",", "Brown", 
                    ",", 
                    RowBox[{"Arrow", "[", 
                    RowBox[{"{", 
                    RowBox[{"ptobj", ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    "location", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}], ",", 
                    RowBox[{
                    "ptobj", "\[LeftDoubleBracket]", "2", 
                    "\[RightDoubleBracket]"}]}], "}"}]}], "}"}], "]"}]}], 
                   "}"}], ",", "\[IndentingNewLine]", 
                  RowBox[{"If", "[", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", 
                    RowBox[{
                    RowBox[{
                    "ptobj", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}], "-", 
                    RowBox[{
                    "location", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}]}], "]"}], "<", 
                    RowBox[{"Abs", "[", "focus", "]"}]}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"Brown", ",", "Dashed", ",", 
                    RowBox[{"Line", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    "location", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}], ",", 
                    RowBox[{
                    "ptobj", "\[LeftDoubleBracket]", "2", 
                    "\[RightDoubleBracket]"}]}], "}"}], ",", "imgloc"}], 
                    "}"}], "]"}]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Arrowheads", "[", "Medium", "]"}], ",", "Brown", 
                    ",", 
                    RowBox[{"Arrow", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    "location", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}], ",", 
                    RowBox[{
                    "ptobj", "\[LeftDoubleBracket]", "2", 
                    "\[RightDoubleBracket]"}]}], "}"}], ",", 
                    "\[IndentingNewLine]", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    "ptobj", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}], "<", 
                    RowBox[{
                    "location", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}]}], ",", "rfocusloc", ",", 
                    "lfocusloc"}], "]"}]}], "}"}], "]"}]}], "}"}]}], "}"}], 
                    ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Arrowheads", "[", "Medium", "]"}], ",", "Brown", 
                    ",", 
                    RowBox[{"Arrow", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    "location", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}], ",", 
                    RowBox[{
                    "ptobj", "\[LeftDoubleBracket]", "2", 
                    "\[RightDoubleBracket]"}]}], "}"}], ",", "imgloc"}], 
                    "}"}], "]"}]}], "}"}]}], "]"}]}], "}"}], ",", 
                "\[IndentingNewLine]", 
                RowBox[{"{", "}"}]}], "]"}], ",", "\[IndentingNewLine]", 
              "\[IndentingNewLine]", 
              RowBox[{"If", " ", "[", 
               RowBox[{"ray2", ",", 
                RowBox[{"(*", 
                 RowBox[{
                 "\:043b\:0456\:043d\:0456\:044f", " ", "\:0432\:0456\:0434", 
                  " ", "\:043f\:0440\:0435\:0434\:043c\:0435\:0442\:0430", 
                  " ", "\:0434\:043e", " ", 
                  "\:0437\:043e\:0431\:0440\:0430\:0436\:0435\:043d\:043d\
\:044f", " ", "\:0447\:0435\:0440\:0435\:0437", " ", 
                  "\:0446\:0435\:043d\:0442\:0440", " ", 
                  "\:043b\:0456\:043d\:0437\:0438"}], "*)"}], 
                "\[IndentingNewLine]", 
                RowBox[{"If", "[", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"Abs", "[", 
                    RowBox[{
                    RowBox[{
                    "ptobj", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}], "-", 
                    RowBox[{
                    "location", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}]}], "]"}], ">", 
                   RowBox[{"Abs", "[", "focus", "]"}]}], ",", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"Arrowheads", "[", "Medium", "]"}], ",", "Pink", 
                    ",", 
                    RowBox[{"Arrow", "[", 
                    RowBox[{"{", 
                    RowBox[{"ptobj", ",", "imgloc"}], "}"}], "]"}]}], "}"}], 
                  ",", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{"Pink", ",", "Dashed", ",", 
                    RowBox[{"Line", "[", 
                    RowBox[{"{", 
                    RowBox[{"ptobj", ",", "imgloc"}], "}"}], "]"}]}], "}"}], 
                    ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Arrowheads", "[", "Medium", "]"}], ",", "Pink", 
                    ",", 
                    RowBox[{"Arrow", "[", 
                    RowBox[{"{", 
                    RowBox[{"ptobj", ",", 
                    RowBox[{
                    RowBox[{"2", "location"}], "-", "ptobj"}]}], "}"}], 
                    "]"}]}], "}"}]}], "}"}]}], "]"}], ",", 
                "\[IndentingNewLine]", 
                RowBox[{"{", "}"}]}], "]"}], ",", "\[IndentingNewLine]", 
              "\[IndentingNewLine]", 
              RowBox[{"If", " ", "[", 
               RowBox[{"ray3", ",", 
                RowBox[{"(*", 
                 RowBox[{
                 "\:043b\:0456\:043d\:0456\:044f", " ", "\:0432\:0456\:0434", 
                  " ", "\:043f\:0440\:0435\:0434\:043c\:0435\:0442\:0430", 
                  " ", "\:0434\:043e", " ", "\:043b\:0456\:043d\:0437\:0438", 
                  " ", "\:0447\:0435\:0440\:0435\:0437", " ", 
                  "\:0444\:043e\:043a\:0443\:0441"}], "*)"}], 
                "\[IndentingNewLine]", 
                RowBox[{"{", 
                 RowBox[{"If", "[", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"Abs", "[", 
                    RowBox[{
                    RowBox[{
                    "ptobj", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}], "-", 
                    RowBox[{
                    "location", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}]}], "]"}], "<", 
                    RowBox[{"Abs", "[", "focus", "]"}]}], ",", 
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Arrowheads", "[", "Medium", "]"}], ",", 
                    RowBox[{"Darker", "[", 
                    RowBox[{"Green", ",", ".6"}], "]"}], ",", 
                    RowBox[{"Arrow", "[", 
                    RowBox[{"{", 
                    RowBox[{"ptobj", ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    "location", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}], ",", 
                    RowBox[{
                    "imgloc", "\[LeftDoubleBracket]", "2", 
                    "\[RightDoubleBracket]"}]}], "}"}]}], "}"}], "]"}]}], 
                    "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Arrowheads", "[", "Medium", "]"}], ",", 
                    RowBox[{"Darker", "[", 
                    RowBox[{"Green", ",", ".6"}], "]"}], ",", 
                    RowBox[{"Arrow", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    "location", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}], ",", 
                    RowBox[{
                    "imgloc", "\[LeftDoubleBracket]", "2", 
                    "\[RightDoubleBracket]"}]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    "ptobj", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}], ">", 
                    RowBox[{
                    "location", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}]}], "&&", 
                    RowBox[{
                    RowBox[{
                    "imgloc", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}], ">", 
                    RowBox[{
                    "location", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}]}]}], ",", 
                    RowBox[{
                    "lfocusloc", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}], ",", " ", 
                    RowBox[{
                    "rfocusloc", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}]}], "]"}], ",", 
                    RowBox[{
                    "imgloc", "\[LeftDoubleBracket]", "2", 
                    "\[RightDoubleBracket]"}]}], "}"}]}], "}"}], "]"}]}], 
                    "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Darker", "[", 
                    RowBox[{"Green", ",", ".6"}], "]"}], ",", "Dashed", ",", 
                    RowBox[{"Line", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    "location", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}], ",", 
                    RowBox[{
                    "imgloc", "\[LeftDoubleBracket]", "2", 
                    "\[RightDoubleBracket]"}]}], "}"}], ",", "imgloc"}], 
                    "}"}], "]"}]}], "}"}]}], "}"}], ",", 
                   "\[IndentingNewLine]", 
                   RowBox[{"{", "\[IndentingNewLine]", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Arrowheads", "[", "Medium", "]"}], ",", 
                    RowBox[{"Darker", "[", 
                    RowBox[{"Green", ",", ".6"}], "]"}], ",", 
                    RowBox[{"Arrow", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    "location", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}], ",", 
                    RowBox[{
                    "imgloc", "\[LeftDoubleBracket]", "2", 
                    "\[RightDoubleBracket]"}]}], "}"}], ",", "imgloc"}], 
                    "}"}], "]"}]}], "}"}], ",", "\[IndentingNewLine]", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Arrowheads", "[", "Medium", "]"}], ",", 
                    RowBox[{"Darker", "[", 
                    RowBox[{"Green", ",", ".6"}], "]"}], ",", 
                    RowBox[{"Arrow", "[", 
                    RowBox[{"{", 
                    RowBox[{"ptobj", ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    "location", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}], ",", 
                    RowBox[{
                    "imgloc", "\[LeftDoubleBracket]", "2", 
                    "\[RightDoubleBracket]"}]}], "}"}]}], "}"}], "]"}]}], 
                    "}"}]}], "}"}]}], "]"}], "\[IndentingNewLine]", "}"}], 
                ",", "\[IndentingNewLine]", 
                RowBox[{"{", "}"}]}], "]"}], ",", "\[IndentingNewLine]", 
              RowBox[{
              "(*", "\:0437\:043e\:0431\:0440\:0430\:0436\:0435\:043d\:043d\
\:044f", "*)"}], "\[IndentingNewLine]", 
              RowBox[{"If", "[", 
               RowBox[{
                RowBox[{
                 RowBox[{"Abs", "[", 
                  RowBox[{
                  "ptobj", "\[LeftDoubleBracket]", "2", 
                   "\[RightDoubleBracket]"}], "]"}], ">", 
                 RowBox[{"0.02", "h"}]}], ",", 
                RowBox[{"If", "[", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"Abs", "[", 
                    RowBox[{
                    RowBox[{
                    "ptobj", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}], "-", 
                    RowBox[{
                    "location", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}]}], "]"}], "<", 
                   RowBox[{"Abs", "[", "focus", "]"}]}], ",", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"Arrowheads", "[", "Large", "]"}], ",", "Thick", 
                    ",", "Dashed", ",", "Blue", ",", 
                    RowBox[{"Arrow", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    "imgloc", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}], ",", "0"}], "}"}], ",", 
                    "imgloc"}], "}"}], "]"}]}], "}"}], ",", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"Arrowheads", "[", "Large", "]"}], ",", "Thick", 
                    ",", "Blue", ",", 
                    RowBox[{"Arrow", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    "imgloc", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}], ",", "0"}], "}"}], ",", 
                    "imgloc"}], "}"}], "]"}]}], "}"}]}], "]"}], ",", 
                RowBox[{"source", "[", 
                 RowBox[{"imgloc", ",", "0.12"}], "]"}]}], "]"}]}], 
             "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
            RowBox[{"(*", 
             RowBox[{
             "\:043f\:043e\:0431\:0443\:0434\:043e\:0432\:0430", " ", 
              "\:043f\:0440\:043e\:043c\:0435\:043d\:0456\:0432", " ", 
              "\:0437\:0430", " ", 
              "\:0434\:043e\:043f\:043e\:043c\:043e\:0433\:043e\:044e", " ", 
              "\:043f\:043e\:0431\:0456\:0447\:043d\:043e\:0433\:043e", " ", 
              "\:0444\:043e\:043a\:0443\:0441\:0430"}], "*)"}], 
            "\[IndentingNewLine]", 
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{"Abs", "[", 
                 RowBox[{
                 "ptobj", "\[LeftDoubleBracket]", "2", 
                  "\[RightDoubleBracket]"}], "]"}], "<", 
                RowBox[{"0.02", " ", "h"}]}], "&&", 
               RowBox[{
                RowBox[{
                "ptobj", "\[LeftDoubleBracket]", "1", 
                 "\[RightDoubleBracket]"}], "<", 
                RowBox[{
                "location", "\[LeftDoubleBracket]", "1", 
                 "\[RightDoubleBracket]"}]}]}], ",", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"Red", ",", "Dashed", ",", 
                  RowBox[{"Line", "[", 
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    "rfocusloc", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}], ",", 
                    RowBox[{"-", "h"}]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    "rfocusloc", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}], ",", "h"}], "}"}]}], "}"}], 
                   "]"}]}], "}"}], ",", "\[IndentingNewLine]", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"PointSize", "[", "Large", "]"}], ",", "Red", ",", 
                  RowBox[{"Point", "[", 
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    "rfocusloc", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}], ",", 
                    RowBox[{"h", "/", "3"}]}], "}"}], "]"}]}], "}"}], ",", 
                RowBox[{"(*", 
                 RowBox[{
                 "\:0442\:043e\:0447\:043a\:0430", " ", 
                  "\:043f\:0440\:0430\:0432\:043e\:0433\:043e", " ", 
                  "\:043f\:043e\:0431\:0456\:0447\:043d\:043e\:0433\:043e", 
                  " ", "\:0444\:043e\:043a\:0443\:0441\:0430"}], "*)"}], 
                "\[IndentingNewLine]", 
                RowBox[{"Text", "[", 
                 RowBox[{
                  RowBox[{"Style", "[", 
                   RowBox[{"\"\<F'\>\"", ",", 
                    RowBox[{"FontSize", "\[Rule]", "14"}], ",", "Italic", ",", 
                    RowBox[{"FontColor", "\[Rule]", "Red"}]}], "]"}], ",", 
                  RowBox[{
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    "rfocusloc", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}], ",", 
                    RowBox[{"h", "/", "3"}]}], "}"}], "+", ".2"}]}], "]"}], 
                ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
                RowBox[{"(*", 
                 RowBox[{
                 "\:043f\:043e\:0431\:0443\:0434\:043e\:0432\:0430", " ", 
                  "\:043f\:043e\:0431\:0456\:0447\:043d\:043e\:0457", " ", 
                  "\:043e\:043f\:0442\:0438\:0447\:043d\:043e\:0457", " ", 
                  "\:0432\:0456\:0441\:0456"}], "*)"}], "\[IndentingNewLine]", 
                RowBox[{"{", 
                 RowBox[{"line2", "[", 
                  RowBox[{
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    "lfocusloc", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}], ",", 
                    RowBox[{
                    RowBox[{"-", "h"}], "/", "3"}]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    "rfocusloc", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}], ",", 
                    RowBox[{"h", "/", "3"}]}], "}"}]}], "}"}], ",", 
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "2"}], "focus"}], "+", 
                    RowBox[{
                    "location", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}]}], ",", 
                    RowBox[{
                    RowBox[{"2", "focus"}], "+", 
                    RowBox[{
                    "location", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}]}]}], "}"}]}], " ", "]"}], "}"}],
                 ",", "\[IndentingNewLine]", 
                RowBox[{"(*", 
                 RowBox[{
                  RowBox[{
                  "\:043f\:043e\:0431\:0443\:0434\:043e\:0432\:0430", " ", 
                   "\:043f\:0440\:043e\:043c\:0435\:043d\:044f"}], ",", " ", 
                  RowBox[{
                  "\:0449\:043e", " ", 
                   "\:043f\:0440\:043e\:0445\:043e\:0434\:0438\:0442\:044c", 
                   " ", "\:0447\:0435\:0440\:0435\:0437", " ", 
                   "\:043f\:0440\:0430\:0432\:0438\:0439", " ", 
                   "\:043f\:043e\:0431\:0456\:0447\:043d\:0438\:0439", " ", 
                   "\:0444\:043e\:043a\:0443\:0441"}]}], " ", "*)"}], 
                "\[IndentingNewLine]", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"Arrowheads", "[", "Medium", "]"}], ",", 
                  RowBox[{"Darker", "[", "Green", "]"}], ",", 
                  RowBox[{"Arrow", "[", 
                   RowBox[{"{", 
                    RowBox[{"ptobj", ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    "location", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}], ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"h", "/", "3"}], "/", "focus"}], 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    "location", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}], "-", 
                    RowBox[{
                    "ptobj", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}]}], ")"}]}]}], "}"}]}], "}"}], 
                   "]"}]}], "}"}], ",", 
                RowBox[{"If", "[", 
                 RowBox[{
                  RowBox[{
                   RowBox[{
                   "imgloc", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}], ">", "0"}], " ", ",", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"Arrowheads", "[", "Medium", "]"}], ",", 
                    RowBox[{"Darker", "[", "Green", "]"}], ",", 
                    RowBox[{"Arrow", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    "location", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}], ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"h", "/", "3"}], "/", "focus"}], 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    "location", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}], "-", 
                    RowBox[{
                    "ptobj", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}]}], ")"}]}]}], "}"}], ",", 
                    "imgloc"}], "}"}], "]"}]}], "}"}], ",", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Darker", "[", "Green", "]"}], ",", "Dashed", ",", 
                    RowBox[{"Line", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    "location", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}], ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"h", "/", "3"}], "/", "focus"}], 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    "location", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}], "-", 
                    RowBox[{
                    "ptobj", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}]}], ")"}]}]}], "}"}], ",", 
                    "imgloc"}], "}"}], "]"}]}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Arrowheads", "[", "Medium", "]"}], ",", 
                    RowBox[{"Darker", "[", "Green", "]"}], ",", 
                    RowBox[{"Arrow", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    "location", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}], ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"h", "/", "3"}], "/", "focus"}], 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    "location", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}], "-", 
                    RowBox[{
                    "ptobj", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}]}], ")"}]}]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    "rfocusloc", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}], ",", 
                    RowBox[{"h", "/", "3"}]}], "}"}]}], "}"}], "]"}]}], 
                    "}"}]}], "}"}]}], "]"}]}], "\[IndentingNewLine]", "}"}], 
              ",", "\[IndentingNewLine]", 
              RowBox[{"{", "}"}]}], "]"}], ",", "\[IndentingNewLine]", 
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{"Abs", "[", 
                 RowBox[{
                 "ptobj", "\[LeftDoubleBracket]", "2", 
                  "\[RightDoubleBracket]"}], "]"}], "<", 
                RowBox[{"0.02", " ", "h"}]}], "&&", 
               RowBox[{
                RowBox[{
                "ptobj", "\[LeftDoubleBracket]", "1", 
                 "\[RightDoubleBracket]"}], ">", 
                RowBox[{
                "location", "\[LeftDoubleBracket]", "1", 
                 "\[RightDoubleBracket]"}]}]}], ",", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"Red", ",", "Dashed", ",", 
                  RowBox[{"Line", "[", 
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    "lfocusloc", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}], ",", 
                    RowBox[{"-", "h"}]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    "lfocusloc", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}], ",", "h"}], "}"}]}], "}"}], 
                   "]"}]}], "}"}], ",", "\[IndentingNewLine]", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"PointSize", "[", "Large", "]"}], ",", "Red", ",", 
                  RowBox[{"Point", "[", 
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    "lfocusloc", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}], ",", 
                    RowBox[{
                    RowBox[{"-", "h"}], "/", "3"}]}], "}"}], "]"}]}], "}"}], 
                ",", 
                RowBox[{"(*", 
                 RowBox[{
                 "\:0442\:043e\:0447\:043a\:0430", " ", 
                  "\:043b\:0456\:0432\:043e\:0433\:043e", " ", 
                  "\:043f\:043e\:0431\:0456\:0447\:043d\:043e\:0433\:043e", 
                  " ", "\:0444\:043e\:043a\:0443\:0441\:0430"}], "*)"}], 
                "\[IndentingNewLine]", 
                RowBox[{"Text", "[", 
                 RowBox[{
                  RowBox[{"Style", "[", 
                   RowBox[{"\"\<F'\>\"", ",", 
                    RowBox[{"FontSize", "\[Rule]", "14"}], ",", "Italic", ",", 
                    RowBox[{"FontColor", "\[Rule]", "Red"}]}], "]"}], ",", 
                  RowBox[{
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    "lfocusloc", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}], ",", 
                    RowBox[{
                    RowBox[{"-", "h"}], "/", "3"}]}], "}"}], "+", ".2"}]}], 
                 "]"}], ",", "\[IndentingNewLine]", 
                RowBox[{"(*", 
                 RowBox[{
                 "\:043f\:043e\:0431\:0443\:0434\:043e\:0432\:0430", " ", 
                  "\:043f\:043e\:0431\:0456\:0447\:043d\:043e\:0457", " ", 
                  "\:043e\:043f\:0442\:0438\:0447\:043d\:043e\:0457", " ", 
                  "\:0432\:0456\:0441\:0456"}], "*)"}], "\[IndentingNewLine]", 
                RowBox[{"{", 
                 RowBox[{"line2", "[", 
                  RowBox[{
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    "lfocusloc", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}], ",", 
                    RowBox[{
                    RowBox[{"-", "h"}], "/", "3"}]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    "rfocusloc", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}], ",", 
                    RowBox[{"h", "/", "3"}]}], "}"}]}], "}"}], ",", 
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "2"}], "focus"}], "+", 
                    RowBox[{
                    "location", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}]}], ",", 
                    RowBox[{
                    RowBox[{"2", "focus"}], "+", 
                    RowBox[{
                    "location", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}]}]}], "}"}]}], " ", "]"}], "}"}],
                 ",", "\[IndentingNewLine]", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"Arrowheads", "[", "Medium", "]"}], ",", 
                  RowBox[{"Darker", "[", "Green", "]"}], ",", 
                  RowBox[{"Arrow", "[", 
                   RowBox[{"{", 
                    RowBox[{"ptobj", ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    "location", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}], ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"h", "/", "3"}], "/", "focus"}], 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    "location", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}], "-", 
                    RowBox[{
                    "ptobj", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}]}], ")"}]}]}], "}"}]}], "}"}], 
                   "]"}]}], "}"}], ",", "\[IndentingNewLine]", 
                RowBox[{"If", "[", 
                 RowBox[{
                  RowBox[{
                   RowBox[{
                   "imgloc", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}], "<", "0"}], ",", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"Arrowheads", "[", "Medium", "]"}], ",", 
                    RowBox[{"Darker", "[", "Green", "]"}], ",", 
                    RowBox[{"Arrow", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    "location", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}], ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"h", "/", "3"}], "/", "focus"}], 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    "location", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}], "-", 
                    RowBox[{
                    "ptobj", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}]}], ")"}]}]}], "}"}], ",", 
                    "imgloc"}], "}"}], "]"}]}], "}"}], ",", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Arrowheads", "[", "Medium", "]"}], ",", 
                    RowBox[{"Darker", "[", "Green", "]"}], ",", 
                    RowBox[{"Arrow", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"location", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}], ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"h", "/", "3"}], "/", "focus"}], 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    "location", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}], "-", 
                    RowBox[{
                    "ptobj", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}]}], ")"}]}]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    "lfocusloc", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}], ",", 
                    RowBox[{
                    RowBox[{"-", "h"}], "/", "3"}]}], "}"}]}], " ", "}"}], 
                    "]"}]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Darker", "[", "Green", "]"}], ",", "Dashed", ",", 
                    RowBox[{"Line", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    "location", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}], ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"h", "/", "3"}], "/", "focus"}], 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    "location", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}], "-", 
                    RowBox[{
                    "ptobj", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}]}], ")"}]}]}], "}"}], ",", 
                    "imgloc"}], "}"}], "]"}]}], "}"}]}], "}"}]}], "]"}]}], 
               "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
              RowBox[{"{", "}"}]}], "]"}]}], "\[IndentingNewLine]", "}"}], 
          ",", "\[IndentingNewLine]", 
          RowBox[{"{", 
           RowBox[{"(*", 
            RowBox[{
            "\:0414\:043b\:044f", " ", 
             "\:0440\:043e\:0437\:0441\:0456\:044e\:0432\:0430\:043b\:044c\
\:043d\:043e\:0457", " ", "\:043b\:0456\:043d\:0437\:0438"}], "*)"}], 
           "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"Thick", ",", "LightGray", ",", 
              RowBox[{"Circle", "[", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"radius", "/", 
                    RowBox[{"(", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"ArcTan", "[", 
                    RowBox[{"h", "/", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{
                    RowBox[{"radius", "^", "2"}], "-", 
                    RowBox[{"h", "^", "2"}]}], "]"}]}], "]"}], "]"}], ")"}]}],
                    "+", 
                   RowBox[{
                   "location", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}]}], ",", "0"}], "}"}], ",", 
                "radius", ",", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"Pi", "-", " ", 
                   RowBox[{"ArcTan", "[", 
                    RowBox[{"h", "/", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{
                    RowBox[{"radius", "^", "2"}], "-", 
                    RowBox[{"h", "^", "2"}]}], "]"}]}], "]"}]}], ",", 
                  RowBox[{"Pi", "+", 
                   RowBox[{"ArcTan", "[", 
                    RowBox[{"h", "/", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{
                    RowBox[{"radius", "^", "2"}], "-", 
                    RowBox[{"h", "^", "2"}]}], "]"}]}], "]"}]}]}], "}"}]}], 
               "]"}]}], "}"}], ",", 
            RowBox[{"(*", 
             RowBox[{
             "\:043b\:0456\:0432\:0430", " ", 
              "\:0447\:0430\:0441\:0442\:0438\:043d\:0430", " ", 
              RowBox[{
              "\:0440\:043e\:0437\:0441", ".", 
               "\:043b\:0456\:043d\:0437\:0438"}]}], "*)"}], 
            "\[IndentingNewLine]", "\[IndentingNewLine]", 
            RowBox[{"{", 
             RowBox[{"Thick", ",", "LightGray", ",", 
              RowBox[{"Circle", "[", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{
                   RowBox[{
                    RowBox[{"-", "radius"}], "/", 
                    RowBox[{"(", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"ArcTan", "[", 
                    RowBox[{"h", "/", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{
                    RowBox[{"radius", "^", "2"}], "-", 
                    RowBox[{"h", "^", "2"}]}], "]"}]}], "]"}], "]"}], ")"}]}],
                    "+", 
                   RowBox[{
                   "location", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}]}], ",", "0"}], "}"}], ",", 
                "radius", ",", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", 
                   RowBox[{"ArcTan", "[", 
                    RowBox[{"h", "/", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{
                    RowBox[{"radius", "^", "2"}], "-", 
                    RowBox[{"h", "^", "2"}]}], "]"}]}], "]"}]}], ",", 
                  RowBox[{"ArcTan", "[", 
                   RowBox[{"h", "/", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{
                    RowBox[{"radius", "^", "2"}], "-", 
                    RowBox[{"h", "^", "2"}]}], "]"}]}], "]"}]}], "}"}]}], 
               "]"}]}], "}"}], ",", "\[IndentingNewLine]", 
            "                                                                \
", 
            RowBox[{"(*", 
             RowBox[{
             "\:043f\:0440\:0430\:0432\:0430", " ", 
              "\:0447\:0430\:0441\:0442\:0438\:043d\:0430", " ", 
              RowBox[{
              "\:0440\:043e\:0437\:0441", ".", 
               "\:043b\:0456\:043d\:0437\:0438"}]}], "*)"}], 
            "\[IndentingNewLine]", 
            RowBox[{"{", 
             RowBox[{"Thick", ",", "LightGray", ",", 
              RowBox[{"(*", 
               RowBox[{
               "\:0432\:0435\:0440\:0445\:043d\:044f", " ", 
                "\:0447\:0430\:0441\:0442\:0438\:043d\:0430", " ", 
                RowBox[{
                "\:0440\:043e\:0437\:0441", ".", 
                 "\:043b\:0456\:043d\:0437\:0438"}]}], "*)"}], 
              RowBox[{"Line", "[", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"radius", "/", 
                    RowBox[{"(", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"ArcTan", "[", 
                    RowBox[{"h", "/", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{
                    RowBox[{"radius", "^", "2"}], "-", 
                    RowBox[{"h", "^", "2"}]}], "]"}]}], "]"}], "]"}], ")"}]}],
                     " ", "-", " ", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{
                    RowBox[{"radius", "^", "2"}], "-", 
                    RowBox[{"h", "^", "2"}]}], "]"}], "+", 
                    RowBox[{
                    "location", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}]}], ",", "h"}], "}"}], ",", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"-", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"radius", "/", 
                    RowBox[{"(", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"ArcTan", "[", 
                    RowBox[{"h", "/", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{
                    RowBox[{"radius", "^", "2"}], "-", 
                    RowBox[{"h", "^", "2"}]}], "]"}]}], "]"}], "]"}], ")"}]}],
                     " ", "-", " ", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{
                    RowBox[{"radius", "^", "2"}], "-", 
                    RowBox[{"h", "^", "2"}]}], "]"}]}], ")"}]}], "+", 
                    RowBox[{
                    "location", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}]}], ",", "h"}], "}"}]}], "}"}], 
               "]"}]}], "}"}], ",", "\[IndentingNewLine]", 
            "\[IndentingNewLine]", 
            RowBox[{"{", 
             RowBox[{"Thick", ",", "LightGray", ",", 
              RowBox[{"(*", 
               RowBox[{
               "\:043d\:0438\:0436\:043d\:044f", " ", 
                "\:0447\:0430\:0441\:0442\:0438\:043d\:0430", " ", 
                RowBox[{
                "\:0440\:043e\:0437\:0441", ".", 
                 "\:043b\:0456\:043d\:0437\:0438"}]}], "*)"}], 
              RowBox[{"Line", "[", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"radius", "/", 
                    RowBox[{"(", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"ArcTan", "[", 
                    RowBox[{"h", "/", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{
                    RowBox[{"radius", "^", "2"}], "-", 
                    RowBox[{"h", "^", "2"}]}], "]"}]}], "]"}], "]"}], ")"}]}],
                     " ", "-", " ", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{
                    RowBox[{"radius", "^", "2"}], "-", 
                    RowBox[{"h", "^", "2"}]}], "]"}], "+", 
                    RowBox[{
                    "location", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}]}], ",", 
                   RowBox[{"-", "h"}]}], "}"}], ",", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"-", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"radius", "/", 
                    RowBox[{"(", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"ArcTan", "[", 
                    RowBox[{"h", "/", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{
                    RowBox[{"radius", "^", "2"}], "-", 
                    RowBox[{"h", "^", "2"}]}], "]"}]}], "]"}], "]"}], ")"}]}],
                     " ", "-", " ", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{
                    RowBox[{"radius", "^", "2"}], "-", 
                    RowBox[{"h", "^", "2"}]}], "]"}]}], ")"}]}], "+", 
                    RowBox[{
                    "location", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}]}], ",", 
                   RowBox[{"-", "h"}]}], "}"}]}], "}"}], "]"}]}], "}"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"Arrowheads", "[", 
               RowBox[{"{", 
                RowBox[{"{", 
                 RowBox[{"0.05", ",", "0", ",", "head"}], "}"}], "}"}], "]"}],
               ",", "Thick", ",", 
              RowBox[{"Arrow", "[", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{
                   "location", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}], ",", 
                   RowBox[{"1.3", "h"}]}], "}"}], ",", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{
                   "location", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}], ",", "0"}], "}"}]}], "}"}], 
               "]"}]}], "}"}], ",", "\[IndentingNewLine]", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"Arrowheads", "[", 
               RowBox[{"{", 
                RowBox[{"{", 
                 RowBox[{"0.05", ",", "0", ",", "head"}], "}"}], "}"}], "]"}],
               ",", "Thick", ",", 
              RowBox[{"Arrow", "[", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{
                   "location", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}], ",", 
                   RowBox[{
                    RowBox[{"-", "1.3"}], "h"}]}], "}"}], ",", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{
                   "location", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}], ",", "0"}], "}"}]}], "}"}], 
               "]"}]}], "}"}], ",", "\[IndentingNewLine]", 
            "\[IndentingNewLine]", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"PointSize", "[", "Large", "]"}], ",", "Red", ",", 
              RowBox[{"Point", "[", "rfocusloc", "]"}]}], "}"}], ",", 
            RowBox[{"(*", 
             RowBox[{
             "\:0442\:043e\:0447\:043a\:0430", " ", 
              "\:043f\:0440\:0430\:0432\:043e\:0433\:043e", " ", 
              "\:0444\:043e\:043a\:0443\:0441\:0430"}], "*)"}], 
            "\[IndentingNewLine]", 
            RowBox[{"Text", "[", 
             RowBox[{
              RowBox[{"Style", "[", 
               RowBox[{"\"\<F\>\"", ",", 
                RowBox[{"FontSize", "\[Rule]", "14"}], ",", "Italic", ",", 
                RowBox[{"FontColor", "\[Rule]", "Red"}]}], "]"}], ",", 
              RowBox[{"rfocusloc", "+", ".2"}]}], "]"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"PointSize", "[", "Large", "]"}], ",", "Red", ",", 
              RowBox[{"Point", "[", "lfocusloc", "]"}]}], "}"}], ",", 
            RowBox[{"(*", 
             RowBox[{
             "\:0442\:043e\:0447\:043a\:0430", " ", 
              "\:043b\:0456\:0432\:043e\:0433\:043e", " ", 
              "\:0444\:043e\:043a\:0443\:0441\:0430"}], "*)"}], 
            "\[IndentingNewLine]", 
            RowBox[{
            "(*", "\:043f\:0440\:0435\:0434\:043c\:0435\:0442", "*)"}], 
            "\[IndentingNewLine]", 
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"Abs", "[", 
                RowBox[{
                "ptobj", "\[LeftDoubleBracket]", "2", 
                 "\[RightDoubleBracket]"}], "]"}], ">", 
               RowBox[{"0.02", "h"}]}], ",", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"Arrowheads", "[", "Large", "]"}], ",", "Thick", ",", 
                "Blue", ",", 
                RowBox[{"Arrow", "[", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    "ptobj", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}], ",", "0"}], "}"}], ",", 
                   "ptobj"}], "}"}], "]"}]}], "}"}], ",", 
              RowBox[{"source", "[", 
               RowBox[{"ptobj", ",", "0.15"}], "]"}]}], "]"}], ",", 
            "\[IndentingNewLine]", "\[IndentingNewLine]", 
            RowBox[{"{", 
             RowBox[{"Thick", ",", 
              RowBox[{"Line", "[", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"-", "5"}], ",", "0"}], "}"}], ",", 
                 RowBox[{"{", 
                  RowBox[{"5", ",", "0"}], "}"}]}], "}"}], "]"}]}], "}"}], 
            ",", "\[IndentingNewLine]", 
            RowBox[{"Line", "[", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                 RowBox[{
                 "location", "\[LeftDoubleBracket]", "1", 
                  "\[RightDoubleBracket]"}], ",", 
                 RowBox[{"-", "h"}]}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{
                 "location", "\[LeftDoubleBracket]", "1", 
                  "\[RightDoubleBracket]"}], ",", "h"}], "}"}]}], "}"}], 
             "]"}], ",", 
            RowBox[{"(*", 
             RowBox[{
             "\:043e\:043f\:0442\:0438\:0447\:043d\:0430", " ", 
              "\:0432\:0456\:0441\:044c"}], "*)"}], "\[IndentingNewLine]", 
            "\[IndentingNewLine]", 
            RowBox[{
            "(*", "\:0437\:043e\:0431\:0440\:0430\:0436\:0435\:043d\:043d\
\:044f", "*)"}], "\[IndentingNewLine]", 
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"Abs", "[", 
                RowBox[{
                "ptobj", "\[LeftDoubleBracket]", "2", 
                 "\[RightDoubleBracket]"}], "]"}], ">", 
               RowBox[{"0.02", "h"}]}], ",", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"Arrowheads", "[", "Large", "]"}], ",", "Thick", ",", 
                "Dashed", ",", "Blue", ",", 
                RowBox[{"Arrow", "[", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    "imgloc", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}], ",", "0"}], "}"}], ",", 
                   "imgloc"}], "}"}], "]"}]}], "}"}], ",", 
              RowBox[{"source", "[", 
               RowBox[{"imgloc", ",", "0.12"}], "]"}]}], "]"}], ",", 
            "\[IndentingNewLine]", "\[IndentingNewLine]", 
            RowBox[{"If", " ", "[", 
             RowBox[{"ray1", ",", 
              RowBox[{"{", "\[IndentingNewLine]", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"Arrowheads", "[", "Medium", "]"}], ",", "Brown", 
                  ",", 
                  RowBox[{"Arrow", "[", 
                   RowBox[{"{", 
                    RowBox[{"ptobj", ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    "location", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}], ",", 
                    RowBox[{
                    "ptobj", "\[LeftDoubleBracket]", "2", 
                    "\[RightDoubleBracket]"}]}], "}"}]}], "}"}], "]"}]}], 
                 "}"}], ",", "\[IndentingNewLine]", 
                RowBox[{"If", "[", 
                 RowBox[{
                  RowBox[{
                   RowBox[{
                   "ptobj", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}], "<", 
                   RowBox[{
                   "location", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}]}], ",", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Arrowheads", "[", "Medium", "]"}], ",", "Brown", 
                    ",", 
                    RowBox[{"arrow2", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    "location", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}], ",", 
                    RowBox[{
                    "ptobj", "\[LeftDoubleBracket]", "2", 
                    "\[RightDoubleBracket]"}]}], "}"}], ",", "lfocusloc"}], 
                    "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    "location", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}], ",", 
                    RowBox[{
                    "rfocusloc", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}]}], "}"}]}], "]"}]}], "}"}], ",",
                     "\[IndentingNewLine]", 
                    RowBox[{"{", 
                    RowBox[{"Brown", ",", "Dashed", ",", 
                    RowBox[{"Line", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    "location", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}], ",", 
                    RowBox[{
                    "ptobj", "\[LeftDoubleBracket]", "2", 
                    "\[RightDoubleBracket]"}]}], "}"}], ",", "lfocusloc"}], 
                    "}"}], "]"}]}], "}"}]}], "}"}], ",", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Arrowheads", "[", "Medium", "]"}], ",", "Brown", 
                    ",", 
                    RowBox[{"arrow2", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    "location", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}], ",", 
                    RowBox[{
                    "ptobj", "\[LeftDoubleBracket]", "2", 
                    "\[RightDoubleBracket]"}]}], "}"}], ",", "rfocusloc"}], 
                    "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    "location", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}], ",", 
                    RowBox[{
                    "lfocusloc", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}]}], "}"}]}], "]"}]}], "}"}], ",",
                     "\[IndentingNewLine]", 
                    RowBox[{"{", 
                    RowBox[{"Brown", ",", "Dashed", ",", 
                    RowBox[{"Line", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    "location", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}], ",", 
                    RowBox[{
                    "ptobj", "\[LeftDoubleBracket]", "2", 
                    "\[RightDoubleBracket]"}]}], "}"}], ",", "rfocusloc"}], 
                    "}"}], "]"}]}], "}"}]}], "}"}]}], "]"}]}], 
               "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
              RowBox[{"{", "}"}]}], "]"}], ",", "\[IndentingNewLine]", 
            RowBox[{"If", " ", "[", 
             RowBox[{"ray2", ",", "\[IndentingNewLine]", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"Arrowheads", "[", "Medium", "]"}], ",", "Pink", ",", 
                
                RowBox[{"arrow2", "[", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{"ptobj", ",", "imgloc"}], "}"}], ",", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{
                    "ptobj", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    "ptobj", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}], "<", 
                    RowBox[{
                    "location", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}]}], ",", 
                    RowBox[{
                    "rfocusloc", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}], ",", 
                    RowBox[{
                    "lfocusloc", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}]}], "]"}]}], "}"}]}], "]"}]}], 
               "}"}], ",", "\[IndentingNewLine]", 
              RowBox[{"{", "}"}]}], "]"}], ",", "\[IndentingNewLine]", 
            RowBox[{"If", " ", "[", 
             RowBox[{"ray3", ",", 
              RowBox[{"{", "\[IndentingNewLine]", 
               RowBox[{
                RowBox[{"If", "[", 
                 RowBox[{
                  RowBox[{
                   RowBox[{
                   "ptobj", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}], "<", 
                   RowBox[{
                   "location", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}]}], ",", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Arrowheads", "[", "Medium", "]"}], ",", 
                    RowBox[{"Darker", "[", 
                    RowBox[{"Green", ",", ".6"}], "]"}], ",", 
                    RowBox[{"arrow2", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"ptobj", ",", "rfocusloc"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    "ptobj", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}], ",", 
                    RowBox[{
                    "location", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}]}], "}"}]}], "]"}]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Arrowheads", "[", "Medium", "]"}], ",", 
                    RowBox[{"Darker", "[", 
                    RowBox[{"Green", ",", ".6"}], "]"}], ",", 
                    RowBox[{"Arrow", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    "location", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}], ",", 
                    RowBox[{
                    "imgloc", "\[LeftDoubleBracket]", "2", 
                    "\[RightDoubleBracket]"}]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    "rfocusloc", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}], ",", 
                    RowBox[{
                    "imgloc", "\[LeftDoubleBracket]", "2", 
                    "\[RightDoubleBracket]"}]}], "}"}]}], "}"}], "]"}]}], 
                    "}"}]}], "}"}], ",", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Arrowheads", "[", "Medium", "]"}], ",", 
                    RowBox[{"Darker", "[", 
                    RowBox[{"Green", ",", ".6"}], "]"}], ",", 
                    RowBox[{"arrow2", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"ptobj", ",", "lfocusloc"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    "ptobj", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}], ",", 
                    RowBox[{
                    "location", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}]}], "}"}]}], "]"}]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Arrowheads", "[", "Medium", "]"}], ",", 
                    RowBox[{"Darker", "[", 
                    RowBox[{"Green", ",", ".6"}], "]"}], ",", 
                    RowBox[{"Arrow", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    "location", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}], ",", 
                    RowBox[{
                    "imgloc", "\[LeftDoubleBracket]", "2", 
                    "\[RightDoubleBracket]"}]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    "lfocusloc", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}], ",", 
                    RowBox[{
                    "imgloc", "\[LeftDoubleBracket]", "2", 
                    "\[RightDoubleBracket]"}]}], "}"}]}], "}"}], "]"}]}], 
                    "}"}]}], "}"}]}], "]"}], ",", "\[IndentingNewLine]", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"Darker", "[", 
                   RowBox[{"Green", ",", ".6"}], "]"}], ",", "Dashed", ",", 
                  RowBox[{"Line", "[", 
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    "location", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}], ",", 
                    RowBox[{
                    "imgloc", "\[LeftDoubleBracket]", "2", 
                    "\[RightDoubleBracket]"}]}], "}"}], ",", "imgloc"}], 
                    "}"}], "]"}]}], "}"}]}], "\[IndentingNewLine]", "}"}], 
              ",", "\[IndentingNewLine]", 
              RowBox[{"{", "}"}]}], "]"}], ",", "\[IndentingNewLine]", 
            RowBox[{"(*", 
             RowBox[{
             "\:043f\:043e\:0431\:0443\:0434\:043e\:0432\:0430", " ", 
              "\:043f\:0440\:043e\:043c\:0435\:043d\:0456\:0432", " ", 
              "\:0437\:0430", " ", 
              "\:0434\:043e\:043f\:043e\:043c\:043e\:0433\:043e\:044e", " ", 
              "\:043f\:043e\:0431\:0456\:0447\:043d\:043e\:0433\:043e", " ", 
              "\:0444\:043e\:043a\:0443\:0441\:0430"}], "*)"}], 
            "\[IndentingNewLine]", 
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"Abs", "[", 
                RowBox[{
                "ptobj", "\[LeftDoubleBracket]", "2", 
                 "\[RightDoubleBracket]"}], "]"}], "<", 
               RowBox[{"0.02", " ", "h"}]}], ",", 
              RowBox[{"If", "[", 
               RowBox[{
                RowBox[{
                 RowBox[{
                 "ptobj", "\[LeftDoubleBracket]", "1", 
                  "\[RightDoubleBracket]"}], "<", 
                 RowBox[{
                 "location", "\[LeftDoubleBracket]", "1", 
                  "\[RightDoubleBracket]"}]}], ",", 
                RowBox[{"(*", 
                 RowBox[{
                 "\:043f\:0440\:0435\:0434\:043c\:0435\:0442", " ", 
                  "\:0437\:043b\:0456\:0432\:0430"}], "*)"}], 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{"Red", ",", "Dashed", ",", 
                    RowBox[{"Line", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    "lfocusloc", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}], ",", 
                    RowBox[{"-", "h"}]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    "lfocusloc", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}], ",", "h"}], "}"}]}], "}"}], 
                    "]"}]}], "}"}], ",", "\[IndentingNewLine]", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"PointSize", "[", "Large", "]"}], ",", "Red", ",", 
                    RowBox[{"Point", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    "lfocusloc", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}], ",", 
                    RowBox[{
                    RowBox[{"-", "h"}], "/", "3"}]}], "}"}], "]"}]}], "}"}], 
                  ",", 
                  RowBox[{"(*", 
                   RowBox[{
                   "\:0442\:043e\:0447\:043a\:0430", " ", 
                    "\:043b\:0456\:0432\:043e\:0433\:043e", " ", 
                    "\:043f\:043e\:0431\:0456\:0447\:043d\:043e\:0433\:043e", 
                    " ", "\:0444\:043e\:043a\:0443\:0441\:0430"}], "*)"}], 
                  "\[IndentingNewLine]", 
                  RowBox[{"Text", "[", 
                   RowBox[{
                    RowBox[{"Style", "[", 
                    RowBox[{"\"\<F'\>\"", ",", 
                    RowBox[{"FontSize", "\[Rule]", "14"}], ",", "Italic", ",", 
                    RowBox[{"FontColor", "\[Rule]", "Red"}]}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    "lfocusloc", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}], "+", ".2"}], ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "h"}], "/", "3"}], "-", ".2"}]}], "}"}]}], 
                   "]"}], ",", "\[IndentingNewLine]", 
                  RowBox[{"(*", 
                   RowBox[{
                   "\:043f\:043e\:0431\:0443\:0434\:043e\:0432\:0430", " ", 
                    "\:043f\:043e\:0431\:0456\:0447\:043d\:043e\:0457", " ", 
                    "\:043e\:043f\:0442\:0438\:0447\:043d\:043e\:0457", " ", 
                    "\:0432\:0456\:0441\:0456"}], "*)"}], 
                  "\[IndentingNewLine]", 
                  RowBox[{"{", 
                   RowBox[{"line2", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    "lfocusloc", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}], ",", 
                    RowBox[{
                    RowBox[{"-", "h"}], "/", "3"}]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    "rfocusloc", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}], ",", 
                    RowBox[{"h", "/", "3"}]}], "}"}]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "2"}], "focus"}], "+", 
                    RowBox[{
                    "location", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}]}], ",", 
                    RowBox[{
                    RowBox[{"2", "focus"}], "+", 
                    RowBox[{
                    "location", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}]}]}], "}"}]}], " ", "]"}], "}"}],
                   ",", "\[IndentingNewLine]", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"Arrowheads", "[", "Medium", "]"}], ",", 
                    RowBox[{"Darker", "[", "Green", "]"}], ",", 
                    RowBox[{"Arrow", "[", 
                    RowBox[{"{", 
                    RowBox[{"ptobj", ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    "location", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}], ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"h", "/", "3"}], "/", "focus"}], 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    "location", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}], "-", 
                    RowBox[{
                    "ptobj", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}]}], ")"}]}]}], "}"}]}], "}"}], 
                    "]"}]}], "}"}], ",", "\[IndentingNewLine]", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"Darker", "[", "Green", "]"}], ",", "Dashed", ",", 
                    RowBox[{"Line", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    "location", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}], ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"h", "/", "3"}], "/", "focus"}], 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    "location", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}], "-", 
                    RowBox[{
                    "ptobj", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}]}], ")"}]}]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    "lfocusloc", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}], ",", 
                    RowBox[{
                    RowBox[{"-", "h"}], "/", "3"}]}], "}"}]}], "}"}], "]"}]}],
                    "}"}], ",", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"Arrowheads", "[", "Medium", "]"}], ",", 
                    RowBox[{"Darker", "[", "Green", "]"}], ",", 
                    RowBox[{"arrow2", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    "location", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}], ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"h", "/", "3"}], "/", "focus"}], 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    "location", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}], "-", 
                    RowBox[{
                    "ptobj", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}]}], ")"}]}]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    "lfocusloc", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}], ",", 
                    RowBox[{
                    RowBox[{"-", "h"}], "/", "3"}]}], "}"}]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    "location", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}], ",", 
                    RowBox[{
                    "rfocusloc", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}]}], "}"}]}], "]"}]}], "}"}]}], 
                 "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
                "      ", 
                RowBox[{"(*", 
                 RowBox[{
                 "\:043f\:0440\:0435\:0434\:043c\:0435\:0442", " ", 
                  "\:0441\:043f\:0440\:0430\:0432\:0430"}], "*)"}], 
                "\[IndentingNewLine]", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{"Red", ",", "Dashed", ",", 
                    RowBox[{"Line", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    "rfocusloc", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}], ",", 
                    RowBox[{"-", "h"}]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    "rfocusloc", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}], ",", "h"}], "}"}]}], "}"}], 
                    "]"}]}], "}"}], ",", "\[IndentingNewLine]", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"PointSize", "[", "Large", "]"}], ",", "Red", ",", 
                    RowBox[{"Point", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    "rfocusloc", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}], ",", 
                    RowBox[{"h", "/", "3"}]}], "}"}], "]"}]}], "}"}], ",", 
                  RowBox[{"(*", 
                   RowBox[{
                   "\:0442\:043e\:0447\:043a\:0430", " ", 
                    "\:043b\:0456\:0432\:043e\:0433\:043e", " ", 
                    "\:043f\:043e\:0431\:0456\:0447\:043d\:043e\:0433\:043e", 
                    " ", "\:0444\:043e\:043a\:0443\:0441\:0430"}], "*)"}], 
                  "\[IndentingNewLine]", 
                  RowBox[{"Text", "[", 
                   RowBox[{
                    RowBox[{"Style", "[", 
                    RowBox[{"\"\<F'\>\"", ",", 
                    RowBox[{"FontSize", "\[Rule]", "14"}], ",", "Italic", ",", 
                    RowBox[{"FontColor", "\[Rule]", "Red"}]}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    "rfocusloc", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}], "+", ".2"}], ",", 
                    RowBox[{
                    RowBox[{"h", "/", "3"}], "+", ".2"}]}], "}"}]}], "]"}], 
                  ",", "\[IndentingNewLine]", 
                  RowBox[{"(*", 
                   RowBox[{
                   "\:043f\:043e\:0431\:0443\:0434\:043e\:0432\:0430", " ", 
                    "\:043f\:043e\:0431\:0456\:0447\:043d\:043e\:0457", " ", 
                    "\:043e\:043f\:0442\:0438\:0447\:043d\:043e\:0457", " ", 
                    "\:0432\:0456\:0441\:0456"}], "*)"}], 
                  "\[IndentingNewLine]", 
                  RowBox[{"{", 
                   RowBox[{"line2", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    "lfocusloc", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}], ",", 
                    RowBox[{
                    RowBox[{"-", "h"}], "/", "3"}]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    "rfocusloc", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}], ",", 
                    RowBox[{"h", "/", "3"}]}], "}"}]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "2"}], "focus"}], "+", 
                    RowBox[{
                    "location", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}]}], ",", 
                    RowBox[{
                    RowBox[{"2", "focus"}], "+", 
                    RowBox[{
                    "location", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}]}]}], "}"}]}], " ", "]"}], "}"}],
                   ",", "\[IndentingNewLine]", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"Arrowheads", "[", "Medium", "]"}], ",", 
                    RowBox[{"Darker", "[", "Green", "]"}], ",", 
                    RowBox[{"Arrow", "[", 
                    RowBox[{"{", 
                    RowBox[{"ptobj", ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    "location", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}], ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"h", "/", "3"}], "/", "focus"}], 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    "location", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}], "-", 
                    RowBox[{
                    "ptobj", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}]}], ")"}]}]}], "}"}]}], "}"}], 
                    "]"}]}], "}"}], ",", "\[IndentingNewLine]", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"Arrowheads", "[", "Medium", "]"}], ",", 
                    RowBox[{"Darker", "[", "Green", "]"}], ",", 
                    RowBox[{"arrow2", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    "location", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}], ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"h", "/", "3"}], "/", "focus"}], 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    "location", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}], "-", 
                    RowBox[{
                    "ptobj", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}]}], ")"}]}]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    "rfocusloc", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}], ",", 
                    RowBox[{"h", "/", "3"}]}], "}"}]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    "location", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}], ",", 
                    RowBox[{
                    "lfocusloc", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}]}], "}"}]}], "]"}]}], "}"}], ",", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"Darker", "[", "Green", "]"}], ",", "Dashed", ",", 
                    RowBox[{"Line", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    "location", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}], ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"h", "/", "3"}], "/", "focus"}], 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    "location", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}], "-", 
                    RowBox[{
                    "ptobj", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}]}], ")"}]}]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    "rfocusloc", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}], ",", 
                    RowBox[{"h", "/", "3"}]}], "}"}]}], "}"}], "]"}]}], 
                   "}"}]}], "\[IndentingNewLine]", "}"}]}], "]"}], ",", 
              RowBox[{"{", "}"}]}], "]"}]}], "\[IndentingNewLine]", "}"}]}], 
         RowBox[{"(*", 
          RowBox[{
          "End", " ", 
           "\:0440\:043e\:0437\:0441\:0456\:044e\:0432\:0430\:043b\:044c\:043d\
\:0430", " ", "\:043b\:0456\:043d\:0437\:0430", " ", "Graphics"}], "*)"}], 
         "\[IndentingNewLine]", "\[IndentingNewLine]", "]"}], ",", 
        RowBox[{"(*", 
         RowBox[{"End", " ", "If"}], "*)"}], "\[IndentingNewLine]", 
        "\[IndentingNewLine]", 
        RowBox[{"(*", 
         RowBox[{
         "\:041e\:043f\:0446\:0456\:0457", " ", 
          "\:0413\:0440\:0430\:0444\:0456\:043a\:0430"}], "*)"}], 
        "\[IndentingNewLine]", 
        RowBox[{"ImageSize", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{"550", ",", "400"}], "}"}]}], ",", 
        RowBox[{"Axes", "\[Rule]", "axes"}], ",", 
        RowBox[{"PlotRange", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"-", "3.5"}], ",", "3.5"}], "}"}]}], "}"}]}], ",", 
        RowBox[{"ImagePadding", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"10", ",", "10"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"0", ",", "40"}], "}"}]}], "}"}]}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"PlotLabel", "\[Rule]", 
         RowBox[{"Style", "[", 
          RowBox[{
           RowBox[{"Column", "[", 
            RowBox[{"{", 
             RowBox[{"If", "[", 
              RowBox[{
               RowBox[{
                RowBox[{"Last", "[", "ptobj", "]"}], "\[Equal]", "0"}], ",", 
               "\"\<  \>\"", ",", 
               RowBox[{"Text", "[", 
                RowBox[{"\"\<The linear lens magnification is \>\"", "<>", 
                 RowBox[{"ToString", "[", 
                  RowBox[{"Abs", "[", 
                   RowBox[{"Round", "[", 
                    RowBox[{
                    RowBox[{"magnification", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "1"}], "*", 
                    RowBox[{"imagedistance", "[", 
                    RowBox[{"focus", ",", "objdist"}], "]"}]}], ",", 
                    "objdist"}], "]"}], ",", ".01"}], "]"}], "]"}], "]"}], 
                 "<>", "\"\<.   The image is \>\"", "<>", 
                 RowBox[{"If", "[", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"magnification", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "1"}], "*", 
                    RowBox[{"imagedistance", "[", 
                    RowBox[{"focus", ",", "objdist"}], "]"}]}], ",", 
                    "objdist"}], "]"}], ">", "0"}], ",", "\"\<virtual.\>\"", 
                   ",", "\"\<real.\>\""}], "]"}]}], "]"}]}], "]"}], "}"}], 
            "]"}], ",", 
           RowBox[{"FontSize", "\[Rule]", "14"}]}], "]"}]}]}], 
       "\[IndentingNewLine]", "\[IndentingNewLine]", "]"}]}]}], 
    RowBox[{"(*", 
     RowBox[{"End", " ", "Graphics"}], "*)"}], "\[IndentingNewLine]", "]"}], 
   ",", 
   RowBox[{"(*", 
    RowBox[{"End", " ", "Module"}], "*)"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
    "\:0456\:043d\:0441\:0442\:0440\:0443\:043c\:0435\:043d\:0442\:0438", " ",
      "\:0434\:043b\:044f", " ", 
     "\:043a\:0435\:0440\:0443\:0432\:0430\:043d\:043d\:044f"}], "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "lenstype", ",", "\"\<converging\>\"", ",", "\"\<lens type\>\""}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\"\<converging\>\"", ",", "\"\<diverging\>\""}], "}"}]}], 
    "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"focus", ",", "1.5", ",", "\"\<focal length\>\""}], "}"}], ",", 
     "1.0", ",", "2.5", ",", 
     RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"ptobj", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "5"}], ",", "2"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "5"}], ",", 
       RowBox[{"-", "2"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "2"}], "}"}], ",", "Locator"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"location", ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "5"}], ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "0"}], "}"}], ",", "Locator"}], "}"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"axes", ",", "False", ",", "\"\<coordinates\>\""}], "}"}], ",", 
     
     RowBox[{"{", 
      RowBox[{"True", ",", "False"}], "}"}]}], "}"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"ray1", ",", "True", ",", "\"\<ray 1\>\""}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"True", ",", "False"}], "}"}]}], "}"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"ray2", ",", "True", ",", "\"\<ray 2\>\""}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"True", ",", "False"}], "}"}]}], "}"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"ray3", ",", "True", ",", "\"\<ray 3\>\""}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"True", ",", "False"}], "}"}]}], "}"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"Button", "[", 
    RowBox[{"\"\<reset to default values\>\"", ",", 
     RowBox[{
      RowBox[{"lenstype", " ", "=", " ", "\"\<converging\>\""}], ";", 
      RowBox[{"focus", " ", "=", " ", "1.5"}], ";", 
      RowBox[{"ptobj", " ", "=", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "5"}], ",", "2"}], "}"}]}], ";", 
      RowBox[{"location", " ", "=", " ", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}]}], ";"}]}], "]"}], ",", 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"TrackedSymbols", "\[RuleDelayed]", "Manipulate"}]}], 
  "\[IndentingNewLine]", "]"}]], "Input",
 CellChangeTimes->{
  3.35696210375764*^9, {3.446655357339888*^9, 3.4466553645993285`*^9}, {
   3.446656108424958*^9, 3.44665612207981*^9}, {3.4466561826986017`*^9, 
   3.4466562084615884`*^9}, {3.4466562400844445`*^9, 3.446656348737218*^9}, {
   3.446656420703665*^9, 3.446656437656247*^9}, {3.4466564680458994`*^9, 
   3.446656488967105*^9}, {3.4468232315203457`*^9, 3.446823234098454*^9}, {
   3.446928396223708*^9, 3.446928412864227*^9}, 3.448732723977426*^9, 
   3.448732771967033*^9, 3.448732802317231*^9},
 CellID->49321582]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`axes$$ = False, $CellContext`focus$$ = 
    1.5, $CellContext`lenstype$$ = "converging", $CellContext`location$$ = {0,
     0}, $CellContext`ptobj$$ = {-5, 2}, $CellContext`ray1$$ = 
    True, $CellContext`ray2$$ = True, $CellContext`ray3$$ = True, 
    Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
    Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
    1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`lenstype$$], "converging", "lens type"}, {
      "converging", "diverging"}}, {{
       Hold[$CellContext`focus$$], 1.5, "focal length"}, 1., 2.5}, {{
       Hold[$CellContext`ptobj$$], {-5, 2}}, {-5, -2}, {5, 2}}, {{
       Hold[$CellContext`location$$], {0, 0}}, {-5, 0}, {5, 0}}, {{
       Hold[$CellContext`axes$$], False, "coordinates"}, {True, False}}, {{
       Hold[$CellContext`ray1$$], True, "ray 1"}, {True, False}}, {{
       Hold[$CellContext`ray2$$], True, "ray 2"}, {True, False}}, {{
       Hold[$CellContext`ray3$$], True, "ray 3"}, {True, False}}, {
      Hold[
       Button[
       "reset to default values", $CellContext`lenstype$$ = 
         "converging"; $CellContext`focus$$ = 
         1.5; $CellContext`ptobj$$ = {-5, 2}; $CellContext`location$$ = {0, 
          0}; Null]], Manipulate`Dump`ThisIsNotAControl}}, Typeset`size$$ = {
    550., {198., 202.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True, $CellContext`lenstype$13682$$ = 
    False, $CellContext`focus$13683$$ = 0, $CellContext`ptobj$13684$$ = {0, 
    0}, $CellContext`location$13685$$ = {0, 0}, $CellContext`axes$13686$$ = 
    False, $CellContext`ray1$13687$$ = False, $CellContext`ray2$13688$$ = 
    False, $CellContext`ray3$13689$$ = False}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`axes$$ = False, $CellContext`focus$$ = 
        1.5, $CellContext`lenstype$$ = 
        "converging", $CellContext`location$$ = {0, 
         0}, $CellContext`ptobj$$ = {-5, 2}, $CellContext`ray1$$ = 
        True, $CellContext`ray2$$ = True, $CellContext`ray3$$ = True}, 
      "ControllerVariables" :> {
        Hold[$CellContext`lenstype$$, $CellContext`lenstype$13682$$, False], 
        Hold[$CellContext`focus$$, $CellContext`focus$13683$$, 0], 
        Hold[$CellContext`ptobj$$, $CellContext`ptobj$13684$$, {0, 0}], 
        Hold[$CellContext`location$$, $CellContext`location$13685$$, {0, 0}], 
        
        Hold[$CellContext`axes$$, $CellContext`axes$13686$$, False], 
        Hold[$CellContext`ray1$$, $CellContext`ray1$13687$$, False], 
        Hold[$CellContext`ray2$$, $CellContext`ray2$13688$$, False], 
        Hold[$CellContext`ray3$$, $CellContext`ray3$13689$$, False]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> 
      Module[{$CellContext`h$ = 
         2.5, $CellContext`head$, $CellContext`radius$, \
$CellContext`lfocusloc$, $CellContext`rfocusloc$, $CellContext`imgloc$, \
$CellContext`objdist$}, $CellContext`imagedistance[
           Pattern[$CellContext`foclength$, 
            Blank[]], 
           Pattern[$CellContext`objdistance$, 
            Blank[]]] := If[$CellContext`lenstype$$ == "converging", 
           If[
            Or[
            Part[$CellContext`ptobj$$, 1] == Part[$CellContext`rfocusloc$, 1],
              Part[$CellContext`ptobj$$, 1] == 
             Part[$CellContext`lfocusloc$, 1], $CellContext`objdistance$ == 
             0], 0, 
            Part[
             Solve[
             1/$CellContext`foclength$ == 
              1/$CellContext`objdistance$ + 1/$CellContext`q, $CellContext`q],
              1, 1, 2]], 
           If[
            Or[
            Part[$CellContext`ptobj$$, 1] == Part[$CellContext`rfocusloc$, 1],
              Part[$CellContext`ptobj$$, 1] == 
             Part[$CellContext`lfocusloc$, 1], $CellContext`objdistance$ == 
             0], 0, 
            Part[
             Solve[
             1/(-$CellContext`foclength$) == 
              1/$CellContext`objdistance$ + 1/$CellContext`q, $CellContext`q],
              1, 1, 2]]]; $CellContext`magnification[
           Pattern[$CellContext`imgdistance$, 
            Blank[]], 
           Pattern[$CellContext`objdistance$, 
            Blank[]]] := If[
           Or[
           Part[$CellContext`ptobj$$, 1] == Part[$CellContext`rfocusloc$, 1], 
            Part[$CellContext`ptobj$$, 1] == 
            Part[$CellContext`lfocusloc$, 1], $CellContext`objdistance$ == 
            0, $CellContext`imgdistance$ == 0], 
           0, $CellContext`imgdistance$/$CellContext`objdistance$]; \
$CellContext`radius$ = 
         7 $CellContext`focus$$; $CellContext`lfocusloc$ = \
{-$CellContext`focus$$ + Part[$CellContext`location$$, 1], 
           0}; $CellContext`rfocusloc$ = {$CellContext`focus$$ + 
           Part[$CellContext`location$$, 1], 0}; $CellContext`objdist$ = 
         Abs[Part[$CellContext`location$$, 1] - 
           Part[$CellContext`ptobj$$, 1]]; $CellContext`imgloc$ = 
         If[Part[$CellContext`ptobj$$, 1] < 
           Part[$CellContext`location$$, 1], {
           Part[$CellContext`location$$, 
              1] + $CellContext`imagedistance[$CellContext`focus$$, \
$CellContext`objdist$], \
$CellContext`magnification[-$CellContext`imagedistance[$CellContext`focus$$, \
$CellContext`objdist$], $CellContext`objdist$] Last[$CellContext`ptobj$$]}, {
           Part[$CellContext`location$$, 
              1] - $CellContext`imagedistance[$CellContext`focus$$, \
$CellContext`objdist$], \
$CellContext`magnification[-$CellContext`imagedistance[$CellContext`focus$$, \
$CellContext`objdist$], $CellContext`objdist$] 
            Last[$CellContext`ptobj$$]}]; $CellContext`head$ = Graphics[
           
           Line[{{(-1)/2, 1/4}, {0, 
             0}, {(-1)/2, (-1)/4}}]]; $CellContext`source[{
            Pattern[$CellContext`x0, 
             Blank[]], 
            Pattern[$CellContext`y0, 
             Blank[]]}, 
           Pattern[$CellContext`r0, 
            Blank[]]] := {Orange, 
           Disk[{$CellContext`x0, $CellContext`y0}, $CellContext`r0], 
           
           Line[{{$CellContext`x0, $CellContext`y0}, {$CellContext`x0 + 
              2 $CellContext`r0, $CellContext`y0}}], 
           
           Line[{{$CellContext`x0, $CellContext`y0}, {$CellContext`x0 - 
              2 $CellContext`r0, $CellContext`y0}}], 
           
           Line[{{$CellContext`x0, $CellContext`y0}, {$CellContext`x0, \
$CellContext`y0 + 2 $CellContext`r0}}], 
           
           Line[{{$CellContext`x0, $CellContext`y0}, {$CellContext`x0, \
$CellContext`y0 - 2 $CellContext`r0}}], 
           
           Line[{{$CellContext`x0, $CellContext`y0}, {$CellContext`x0 - 
              1.6 $CellContext`r0, $CellContext`y0 - 1.6 $CellContext`r0}}], 
           
           Line[{{$CellContext`x0, $CellContext`y0}, {$CellContext`x0 + 
              1.6 $CellContext`r0, $CellContext`y0 - 1.6 $CellContext`r0}}], 
           
           Line[{{$CellContext`x0, $CellContext`y0}, {$CellContext`x0 - 
              1.6 $CellContext`r0, $CellContext`y0 + 1.6 $CellContext`r0}}], 
           
           Line[{{$CellContext`x0, $CellContext`y0}, {$CellContext`x0 + 
              1.6 $CellContext`r0, $CellContext`y0 + 
              1.6 $CellContext`r0}}]}; $CellContext`line2[{{
             Pattern[$CellContext`x1, 
              Blank[]], 
             Pattern[$CellContext`y1, 
              Blank[]]}, {
             Pattern[$CellContext`x2, 
              Blank[]], 
             Pattern[$CellContext`y2, 
              Blank[]]}}, {
            Pattern[$CellContext`x3, 
             Blank[]], 
            Pattern[$CellContext`x4, 
             Blank[]]}] := 
         Line[{{$CellContext`x3, (($CellContext`y2 - \
$CellContext`y1)/($CellContext`x2 - $CellContext`x1)) $CellContext`x3 + \
($CellContext`x2 $CellContext`y1 - $CellContext`x1 \
$CellContext`y2)/($CellContext`x2 - $CellContext`x1)}, {$CellContext`x4, \
(($CellContext`y2 - $CellContext`y1)/($CellContext`x2 - $CellContext`x1)) \
$CellContext`x4 + ($CellContext`x2 $CellContext`y1 - $CellContext`x1 \
$CellContext`y2)/($CellContext`x2 - $CellContext`x1)}}]; $CellContext`arrow2[{{
             Pattern[$CellContext`x1, 
              Blank[]], 
             Pattern[$CellContext`y1, 
              Blank[]]}, {
             Pattern[$CellContext`x2, 
              Blank[]], 
             Pattern[$CellContext`y2, 
              Blank[]]}}, {
            Pattern[$CellContext`x3, 
             Blank[]], 
            Pattern[$CellContext`x4, 
             Blank[]]}] := 
         Arrow[{{$CellContext`x3, (($CellContext`y2 - \
$CellContext`y1)/($CellContext`x2 - $CellContext`x1)) $CellContext`x3 + \
($CellContext`x2 $CellContext`y1 - $CellContext`x1 \
$CellContext`y2)/($CellContext`x2 - $CellContext`x1)}, {$CellContext`x4, \
(($CellContext`y2 - $CellContext`y1)/($CellContext`x2 - $CellContext`x1)) \
$CellContext`x4 + ($CellContext`x2 $CellContext`y1 - $CellContext`x1 \
$CellContext`y2)/($CellContext`x2 - $CellContext`x1)}}]; Graphics[
          If[$CellContext`lenstype$$ == "converging", {{Thick, LightGray, 
             
             Circle[{First[$CellContext`location$$] + 
               Sqrt[$CellContext`radius$^2 - $CellContext`h$^2], 
               0}, $CellContext`radius$, {
              Pi - ArcTan[$CellContext`h$/
                Sqrt[$CellContext`radius$^2 - $CellContext`h$^2]], Pi + 
               ArcTan[$CellContext`h$/
                 Sqrt[$CellContext`radius$^2 - $CellContext`h$^2]]}]}, {
            Thick, LightGray, 
             
             Circle[{Part[$CellContext`location$$, 1] - 
               Sqrt[$CellContext`radius$^2 - $CellContext`h$^2], 
               0}, $CellContext`radius$, {-
               ArcTan[$CellContext`h$/
                 Sqrt[$CellContext`radius$^2 - $CellContext`h$^2]], 
               
               ArcTan[$CellContext`h$/
                Sqrt[$CellContext`radius$^2 - $CellContext`h$^2]]}]}, {
             Arrowheads[{{Automatic, Automatic, $CellContext`head$}}], Thick, 
             
             Arrow[{{
                Part[$CellContext`location$$, 1], 0}, {
                Part[$CellContext`location$$, 1], 1.3 $CellContext`h$}}]}, {
             Arrowheads[{{Automatic, Automatic, $CellContext`head$}}], Thick, 
             
             Arrow[{{
                Part[$CellContext`location$$, 1], 0}, {
                Part[$CellContext`location$$, 1], (-1.3) $CellContext`h$}}]}, {
             PointSize[Large], Red, 
             Point[$CellContext`rfocusloc$]}, 
            Text[
             Style[
             "F", FontSize -> 14, Italic, FontColor -> 
              Red], $CellContext`rfocusloc$ + 0.2], {
             PointSize[Large], Red, 
             Point[$CellContext`lfocusloc$]}, 
            If[Abs[
               Part[$CellContext`ptobj$$, 2]] > 0.02 $CellContext`h$, {
              Arrowheads[Large], Thick, Blue, 
              Arrow[{{
                 Part[$CellContext`ptobj$$, 1], 0}, $CellContext`ptobj$$}]}, 
             $CellContext`source[$CellContext`ptobj$$, 0.15]], {Thick, 
             Line[{{-5, 0}, {5, 0}}]}, 
            Line[{{
               Part[$CellContext`location$$, 1], -$CellContext`h$}, {
               Part[$CellContext`location$$, 1], $CellContext`h$}}], {
             If[$CellContext`ray1$$, {{
                Arrowheads[Medium], Brown, 
                Arrow[{$CellContext`ptobj$$, {
                   Part[$CellContext`location$$, 1], 
                   Part[$CellContext`ptobj$$, 2]}}]}, 
               If[
               Abs[Part[$CellContext`ptobj$$, 1] - 
                  Part[$CellContext`location$$, 1]] < 
                Abs[$CellContext`focus$$], {{Brown, Dashed, 
                  Line[{{
                    Part[$CellContext`location$$, 1], 
                    Part[$CellContext`ptobj$$, 2]}, $CellContext`imgloc$}]}, {
                 
                  Arrowheads[Medium], Brown, 
                  Arrow[{{
                    Part[$CellContext`location$$, 1], 
                    Part[$CellContext`ptobj$$, 2]}, 
                    If[
                    Part[$CellContext`ptobj$$, 1] < 
                    Part[$CellContext`location$$, 
                    1], $CellContext`rfocusloc$, \
$CellContext`lfocusloc$]}]}}, {
                 Arrowheads[Medium], Brown, 
                 Arrow[{{
                    Part[$CellContext`location$$, 1], 
                    
                    Part[$CellContext`ptobj$$, 
                    2]}, $CellContext`imgloc$}]}]}, {}], 
             If[$CellContext`ray2$$, 
              If[
              Abs[Part[$CellContext`ptobj$$, 1] - 
                 Part[$CellContext`location$$, 1]] > 
               Abs[$CellContext`focus$$], {
                Arrowheads[Medium], Pink, 
                Arrow[{$CellContext`ptobj$$, $CellContext`imgloc$}]}, {{
                Pink, Dashed, 
                 Line[{$CellContext`ptobj$$, $CellContext`imgloc$}]}, {
                 Arrowheads[Medium], Pink, 
                 
                 Arrow[{$CellContext`ptobj$$, 
                   2 $CellContext`location$$ - $CellContext`ptobj$$}]}}], {}], 
             If[$CellContext`ray3$$, {
               If[
               Abs[Part[$CellContext`ptobj$$, 1] - 
                  Part[$CellContext`location$$, 1]] < 
                Abs[$CellContext`focus$$], {{
                  Arrowheads[Medium], 
                  Darker[Green, 0.6], 
                  Arrow[{$CellContext`ptobj$$, {
                    Part[$CellContext`location$$, 1], 
                    Part[$CellContext`imgloc$, 2]}}]}, {
                  Arrowheads[Medium], 
                  Darker[Green, 0.6], 
                  Arrow[{{
                    Part[$CellContext`location$$, 1], 
                    Part[$CellContext`imgloc$, 2]}, {
                    If[
                    And[
                    Part[$CellContext`ptobj$$, 1] > 
                    Part[$CellContext`location$$, 1], 
                    Part[$CellContext`imgloc$, 1] > 
                    Part[$CellContext`location$$, 1]], 
                    Part[$CellContext`lfocusloc$, 1], 
                    Part[$CellContext`rfocusloc$, 1]], 
                    Part[$CellContext`imgloc$, 2]}}]}, {
                  Darker[Green, 0.6], Dashed, 
                  Line[{{
                    Part[$CellContext`location$$, 1], 
                    
                    Part[$CellContext`imgloc$, 
                    2]}, $CellContext`imgloc$}]}}, {{
                  Arrowheads[Medium], 
                  Darker[Green, 0.6], 
                  Arrow[{{
                    Part[$CellContext`location$$, 1], 
                    Part[$CellContext`imgloc$, 2]}, $CellContext`imgloc$}]}, {
                 
                  Arrowheads[Medium], 
                  Darker[Green, 0.6], 
                  Arrow[{$CellContext`ptobj$$, {
                    Part[$CellContext`location$$, 1], 
                    Part[$CellContext`imgloc$, 2]}}]}}]}, {}], 
             If[Abs[
                Part[$CellContext`ptobj$$, 2]] > 0.02 $CellContext`h$, 
              If[
              Abs[Part[$CellContext`ptobj$$, 1] - 
                 Part[$CellContext`location$$, 1]] < 
               Abs[$CellContext`focus$$], {
                Arrowheads[Large], Thick, Dashed, Blue, 
                Arrow[{{
                   Part[$CellContext`imgloc$, 1], 
                   0}, $CellContext`imgloc$}]}, {
                Arrowheads[Large], Thick, Blue, 
                Arrow[{{
                   Part[$CellContext`imgloc$, 1], 
                   0}, $CellContext`imgloc$}]}], 
              $CellContext`source[$CellContext`imgloc$, 0.12]]}, 
            If[
             And[Abs[
                Part[$CellContext`ptobj$$, 2]] < 0.02 $CellContext`h$, 
              Part[$CellContext`ptobj$$, 1] < 
              Part[$CellContext`location$$, 1]], {{Red, Dashed, 
               Line[{{
                  Part[$CellContext`rfocusloc$, 1], -$CellContext`h$}, {
                  Part[$CellContext`rfocusloc$, 1], $CellContext`h$}}]}, {
               PointSize[Large], Red, 
               Point[{
                 Part[$CellContext`rfocusloc$, 1], $CellContext`h$/3}]}, 
              Text[
               Style["F'", FontSize -> 14, Italic, FontColor -> Red], {
                 Part[$CellContext`rfocusloc$, 1], $CellContext`h$/3} + 0.2], {
               $CellContext`line2[{{
                  Part[$CellContext`lfocusloc$, 1], (-$CellContext`h$)/3}, {
                  Part[$CellContext`rfocusloc$, 1], $CellContext`h$/
                  3}}, {(-2) $CellContext`focus$$ + 
                 Part[$CellContext`location$$, 1], 2 $CellContext`focus$$ + 
                 Part[$CellContext`location$$, 1]}]}, {
               Arrowheads[Medium], 
               Darker[Green], 
               Arrow[{$CellContext`ptobj$$, {
                  
                  Part[$CellContext`location$$, 
                   1], (($CellContext`h$/3)/$CellContext`focus$$) (
                   Part[$CellContext`location$$, 1] - 
                   Part[$CellContext`ptobj$$, 1])}}]}, 
              If[Part[$CellContext`imgloc$, 1] > 0, {
                Arrowheads[Medium], 
                Darker[Green], 
                Arrow[{{
                   
                   Part[$CellContext`location$$, 
                    1], (($CellContext`h$/3)/$CellContext`focus$$) (
                    Part[$CellContext`location$$, 1] - 
                    Part[$CellContext`ptobj$$, 
                    1])}, $CellContext`imgloc$}]}, {{
                 Darker[Green], Dashed, 
                 Line[{{
                    
                    Part[$CellContext`location$$, 
                    1], (($CellContext`h$/3)/$CellContext`focus$$) (
                    Part[$CellContext`location$$, 1] - 
                    Part[$CellContext`ptobj$$, 1])}, $CellContext`imgloc$}]}, {
                 Arrowheads[Medium], 
                 Darker[Green], 
                 Arrow[{{
                    
                    Part[$CellContext`location$$, 
                    1], (($CellContext`h$/3)/$CellContext`focus$$) (
                    Part[$CellContext`location$$, 1] - 
                    Part[$CellContext`ptobj$$, 1])}, {
                    Part[$CellContext`rfocusloc$, 1], $CellContext`h$/
                    3}}]}}]}, {}], 
            If[
             And[Abs[
                Part[$CellContext`ptobj$$, 2]] < 0.02 $CellContext`h$, 
              Part[$CellContext`ptobj$$, 1] > 
              Part[$CellContext`location$$, 1]], {{Red, Dashed, 
               Line[{{
                  Part[$CellContext`lfocusloc$, 1], -$CellContext`h$}, {
                  Part[$CellContext`lfocusloc$, 1], $CellContext`h$}}]}, {
               PointSize[Large], Red, 
               Point[{
                 Part[$CellContext`lfocusloc$, 1], (-$CellContext`h$)/3}]}, 
              Text[
               Style["F'", FontSize -> 14, Italic, FontColor -> Red], {
                 Part[$CellContext`lfocusloc$, 1], (-$CellContext`h$)/3} + 
               0.2], {
               $CellContext`line2[{{
                  Part[$CellContext`lfocusloc$, 1], (-$CellContext`h$)/3}, {
                  Part[$CellContext`rfocusloc$, 1], $CellContext`h$/
                  3}}, {(-2) $CellContext`focus$$ + 
                 Part[$CellContext`location$$, 1], 2 $CellContext`focus$$ + 
                 Part[$CellContext`location$$, 1]}]}, {
               Arrowheads[Medium], 
               Darker[Green], 
               Arrow[{$CellContext`ptobj$$, {
                  
                  Part[$CellContext`location$$, 
                   1], (($CellContext`h$/3)/$CellContext`focus$$) (
                   Part[$CellContext`location$$, 1] - 
                   Part[$CellContext`ptobj$$, 1])}}]}, 
              If[Part[$CellContext`imgloc$, 1] < 0, {
                Arrowheads[Medium], 
                Darker[Green], 
                Arrow[{{
                   
                   Part[$CellContext`location$$, 
                    1], (($CellContext`h$/3)/$CellContext`focus$$) (
                    Part[$CellContext`location$$, 1] - 
                    Part[$CellContext`ptobj$$, 
                    1])}, $CellContext`imgloc$}]}, {{
                 Arrowheads[Medium], 
                 Darker[Green], 
                 Arrow[{{
                    
                    Part[$CellContext`location$$, 
                    1], (($CellContext`h$/3)/$CellContext`focus$$) (
                    Part[$CellContext`location$$, 1] - 
                    Part[$CellContext`ptobj$$, 1])}, {
                    Part[$CellContext`lfocusloc$, 1], (-$CellContext`h$)/
                    3}}]}, {
                 Darker[Green], Dashed, 
                 Line[{{
                    
                    Part[$CellContext`location$$, 
                    1], (($CellContext`h$/3)/$CellContext`focus$$) (
                    Part[$CellContext`location$$, 1] - 
                    Part[$CellContext`ptobj$$, 
                    1])}, $CellContext`imgloc$}]}}]}, {}]}, {{
            Thick, LightGray, 
             Circle[{$CellContext`radius$/Cos[
                 
                 ArcTan[$CellContext`h$/
                  Sqrt[$CellContext`radius$^2 - $CellContext`h$^2]]] + 
               Part[$CellContext`location$$, 1], 0}, $CellContext`radius$, {
              Pi - ArcTan[$CellContext`h$/
                Sqrt[$CellContext`radius$^2 - $CellContext`h$^2]], Pi + 
               ArcTan[$CellContext`h$/
                 Sqrt[$CellContext`radius$^2 - $CellContext`h$^2]]}]}, {
            Thick, LightGray, 
             Circle[{(-$CellContext`radius$)/Cos[
                 
                 ArcTan[$CellContext`h$/
                  Sqrt[$CellContext`radius$^2 - $CellContext`h$^2]]] + 
               Part[$CellContext`location$$, 1], 0}, $CellContext`radius$, {-
               ArcTan[$CellContext`h$/
                 Sqrt[$CellContext`radius$^2 - $CellContext`h$^2]], 
               
               ArcTan[$CellContext`h$/
                Sqrt[$CellContext`radius$^2 - $CellContext`h$^2]]}]}, {
            Thick, LightGray, 
             Line[{{$CellContext`radius$/Cos[
                  
                  ArcTan[$CellContext`h$/
                   Sqrt[$CellContext`radius$^2 - $CellContext`h$^2]]] - 
                Sqrt[$CellContext`radius$^2 - $CellContext`h$^2] + 
                Part[$CellContext`location$$, 
                  1], $CellContext`h$}, {-($CellContext`radius$/Cos[
                    
                    ArcTan[$CellContext`h$/
                    Sqrt[$CellContext`radius$^2 - $CellContext`h$^2]]] - 
                  Sqrt[$CellContext`radius$^2 - $CellContext`h$^2]) + 
                Part[$CellContext`location$$, 1], $CellContext`h$}}]}, {
            Thick, LightGray, 
             Line[{{$CellContext`radius$/Cos[
                  
                  ArcTan[$CellContext`h$/
                   Sqrt[$CellContext`radius$^2 - $CellContext`h$^2]]] - 
                Sqrt[$CellContext`radius$^2 - $CellContext`h$^2] + 
                Part[$CellContext`location$$, 
                  1], -$CellContext`h$}, {-($CellContext`radius$/Cos[
                    
                    ArcTan[$CellContext`h$/
                    Sqrt[$CellContext`radius$^2 - $CellContext`h$^2]]] - 
                  Sqrt[$CellContext`radius$^2 - $CellContext`h$^2]) + 
                Part[$CellContext`location$$, 1], -$CellContext`h$}}]}, {
             Arrowheads[{{0.05, 0, $CellContext`head$}}], Thick, 
             Arrow[{{
                Part[$CellContext`location$$, 1], 1.3 $CellContext`h$}, {
                Part[$CellContext`location$$, 1], 0}}]}, {
             Arrowheads[{{0.05, 0, $CellContext`head$}}], Thick, 
             Arrow[{{
                Part[$CellContext`location$$, 1], (-1.3) $CellContext`h$}, {
                Part[$CellContext`location$$, 1], 0}}]}, {
             PointSize[Large], Red, 
             Point[$CellContext`rfocusloc$]}, 
            Text[
             Style[
             "F", FontSize -> 14, Italic, FontColor -> 
              Red], $CellContext`rfocusloc$ + 0.2], {
             PointSize[Large], Red, 
             Point[$CellContext`lfocusloc$]}, 
            If[Abs[
               Part[$CellContext`ptobj$$, 2]] > 0.02 $CellContext`h$, {
              Arrowheads[Large], Thick, Blue, 
              Arrow[{{
                 Part[$CellContext`ptobj$$, 1], 0}, $CellContext`ptobj$$}]}, 
             $CellContext`source[$CellContext`ptobj$$, 0.15]], {Thick, 
             Line[{{-5, 0}, {5, 0}}]}, 
            Line[{{
               Part[$CellContext`location$$, 1], -$CellContext`h$}, {
               Part[$CellContext`location$$, 1], $CellContext`h$}}], 
            If[Abs[
               Part[$CellContext`ptobj$$, 2]] > 0.02 $CellContext`h$, {
              Arrowheads[Large], Thick, Dashed, Blue, 
              Arrow[{{
                 Part[$CellContext`imgloc$, 1], 0}, $CellContext`imgloc$}]}, 
             $CellContext`source[$CellContext`imgloc$, 0.12]], 
            If[$CellContext`ray1$$, {{
               Arrowheads[Medium], Brown, 
               Arrow[{$CellContext`ptobj$$, {
                  Part[$CellContext`location$$, 1], 
                  Part[$CellContext`ptobj$$, 2]}}]}, 
              If[
              Part[$CellContext`ptobj$$, 1] < 
               Part[$CellContext`location$$, 1], {{
                 Arrowheads[Medium], Brown, 
                 $CellContext`arrow2[{{
                    Part[$CellContext`location$$, 1], 
                    Part[$CellContext`ptobj$$, 2]}, $CellContext`lfocusloc$}, {
                   Part[$CellContext`location$$, 1], 
                   Part[$CellContext`rfocusloc$, 1]}]}, {Brown, Dashed, 
                 Line[{{
                    Part[$CellContext`location$$, 1], 
                    
                    Part[$CellContext`ptobj$$, 
                    2]}, $CellContext`lfocusloc$}]}}, {{
                 Arrowheads[Medium], Brown, 
                 $CellContext`arrow2[{{
                    Part[$CellContext`location$$, 1], 
                    Part[$CellContext`ptobj$$, 2]}, $CellContext`rfocusloc$}, {
                   Part[$CellContext`location$$, 1], 
                   Part[$CellContext`lfocusloc$, 1]}]}, {Brown, Dashed, 
                 Line[{{
                    Part[$CellContext`location$$, 1], 
                    
                    Part[$CellContext`ptobj$$, 
                    2]}, $CellContext`rfocusloc$}]}}]}, {}], 
            If[$CellContext`ray2$$, {
              Arrowheads[Medium], Pink, 
              $CellContext`arrow2[{$CellContext`ptobj$$, \
$CellContext`imgloc$}, {
                Part[$CellContext`ptobj$$, 1], 
                If[
                Part[$CellContext`ptobj$$, 1] < 
                 Part[$CellContext`location$$, 1], 
                 Part[$CellContext`rfocusloc$, 1], 
                 Part[$CellContext`lfocusloc$, 1]]}]}, {}], 
            If[$CellContext`ray3$$, {
              If[
              Part[$CellContext`ptobj$$, 1] < 
               Part[$CellContext`location$$, 1], {{
                 Arrowheads[Medium], 
                 Darker[Green, 0.6], 
                 $CellContext`arrow2[{$CellContext`ptobj$$, \
$CellContext`rfocusloc$}, {
                   Part[$CellContext`ptobj$$, 1], 
                   Part[$CellContext`location$$, 1]}]}, {
                 Arrowheads[Medium], 
                 Darker[Green, 0.6], 
                 Arrow[{{
                    Part[$CellContext`location$$, 1], 
                    Part[$CellContext`imgloc$, 2]}, {
                    Part[$CellContext`rfocusloc$, 1], 
                    Part[$CellContext`imgloc$, 2]}}]}}, {{
                 Arrowheads[Medium], 
                 Darker[Green, 0.6], 
                 $CellContext`arrow2[{$CellContext`ptobj$$, \
$CellContext`lfocusloc$}, {
                   Part[$CellContext`ptobj$$, 1], 
                   Part[$CellContext`location$$, 1]}]}, {
                 Arrowheads[Medium], 
                 Darker[Green, 0.6], 
                 Arrow[{{
                    Part[$CellContext`location$$, 1], 
                    Part[$CellContext`imgloc$, 2]}, {
                    Part[$CellContext`lfocusloc$, 1], 
                    Part[$CellContext`imgloc$, 2]}}]}}], {
               Darker[Green, 0.6], Dashed, 
               Line[{{
                  Part[$CellContext`location$$, 1], 
                  
                  Part[$CellContext`imgloc$, 
                   2]}, $CellContext`imgloc$}]}}, {}], 
            If[Abs[
               Part[$CellContext`ptobj$$, 2]] < 0.02 $CellContext`h$, 
             If[
             Part[$CellContext`ptobj$$, 1] < 
              Part[$CellContext`location$$, 1], {{Red, Dashed, 
                Line[{{
                   Part[$CellContext`lfocusloc$, 1], -$CellContext`h$}, {
                   Part[$CellContext`lfocusloc$, 1], $CellContext`h$}}]}, {
                PointSize[Large], Red, 
                Point[{
                  Part[$CellContext`lfocusloc$, 1], (-$CellContext`h$)/3}]}, 
               Text[
                Style["F'", FontSize -> 14, Italic, FontColor -> Red], {
                Part[$CellContext`lfocusloc$, 1] + 0.2, (-$CellContext`h$)/3 - 
                 0.2}], {
                $CellContext`line2[{{
                   Part[$CellContext`lfocusloc$, 1], (-$CellContext`h$)/3}, {
                   Part[$CellContext`rfocusloc$, 1], $CellContext`h$/
                   3}}, {(-2) $CellContext`focus$$ + 
                  Part[$CellContext`location$$, 1], 2 $CellContext`focus$$ + 
                  Part[$CellContext`location$$, 1]}]}, {
                Arrowheads[Medium], 
                Darker[Green], 
                Arrow[{$CellContext`ptobj$$, {
                   
                   Part[$CellContext`location$$, 
                    1], (($CellContext`h$/3)/$CellContext`focus$$) (
                    Part[$CellContext`location$$, 1] - 
                    Part[$CellContext`ptobj$$, 1])}}]}, {
                Darker[Green], Dashed, 
                Line[{{
                   
                   Part[$CellContext`location$$, 
                    1], (($CellContext`h$/3)/$CellContext`focus$$) (
                    Part[$CellContext`location$$, 1] - 
                    Part[$CellContext`ptobj$$, 1])}, {
                   Part[$CellContext`lfocusloc$, 1], (-$CellContext`h$)/
                   3}}]}, {
                Arrowheads[Medium], 
                Darker[Green], 
                $CellContext`arrow2[{{
                   
                   Part[$CellContext`location$$, 
                    1], (($CellContext`h$/3)/$CellContext`focus$$) (
                    Part[$CellContext`location$$, 1] - 
                    Part[$CellContext`ptobj$$, 1])}, {
                   Part[$CellContext`lfocusloc$, 1], (-$CellContext`h$)/3}}, {
                 
                  Part[$CellContext`location$$, 1], 
                  Part[$CellContext`rfocusloc$, 1]}]}}, {{Red, Dashed, 
                Line[{{
                   Part[$CellContext`rfocusloc$, 1], -$CellContext`h$}, {
                   Part[$CellContext`rfocusloc$, 1], $CellContext`h$}}]}, {
                PointSize[Large], Red, 
                Point[{
                  Part[$CellContext`rfocusloc$, 1], $CellContext`h$/3}]}, 
               Text[
                Style["F'", FontSize -> 14, Italic, FontColor -> Red], {
                Part[$CellContext`rfocusloc$, 1] + 0.2, $CellContext`h$/3 + 
                 0.2}], {
                $CellContext`line2[{{
                   Part[$CellContext`lfocusloc$, 1], (-$CellContext`h$)/3}, {
                   Part[$CellContext`rfocusloc$, 1], $CellContext`h$/
                   3}}, {(-2) $CellContext`focus$$ + 
                  Part[$CellContext`location$$, 1], 2 $CellContext`focus$$ + 
                  Part[$CellContext`location$$, 1]}]}, {
                Arrowheads[Medium], 
                Darker[Green], 
                Arrow[{$CellContext`ptobj$$, {
                   
                   Part[$CellContext`location$$, 
                    1], (($CellContext`h$/3)/$CellContext`focus$$) (
                    Part[$CellContext`location$$, 1] - 
                    Part[$CellContext`ptobj$$, 1])}}]}, {
                Arrowheads[Medium], 
                Darker[Green], 
                $CellContext`arrow2[{{
                   
                   Part[$CellContext`location$$, 
                    1], (($CellContext`h$/3)/$CellContext`focus$$) (
                    Part[$CellContext`location$$, 1] - 
                    Part[$CellContext`ptobj$$, 1])}, {
                   Part[$CellContext`rfocusloc$, 1], $CellContext`h$/3}}, {
                  Part[$CellContext`location$$, 1], 
                  Part[$CellContext`lfocusloc$, 1]}]}, {
                Darker[Green], Dashed, 
                Line[{{
                   
                   Part[$CellContext`location$$, 
                    1], (($CellContext`h$/3)/$CellContext`focus$$) (
                    Part[$CellContext`location$$, 1] - 
                    Part[$CellContext`ptobj$$, 1])}, {
                   Part[$CellContext`rfocusloc$, 1], $CellContext`h$/
                   3}}]}}], {}]}], ImageSize -> {550, 400}, 
          Axes -> $CellContext`axes$$, PlotRange -> {{-5, 5}, {-3.5, 3.5}}, 
          ImagePadding -> {{10, 10}, {0, 40}}, PlotLabel -> Style[
            Column[{
              If[Last[$CellContext`ptobj$$] == 0, "  ", 
               Text[
                StringJoin["The linear lens magnification is ", 
                 ToString[
                  Abs[
                   Round[
                    $CellContext`magnification[-$CellContext`imagedistance[$\
CellContext`focus$$, $CellContext`objdist$], $CellContext`objdist$], 0.01]]], 
                 ".   The image is ", 
                 
                 If[$CellContext`magnification[-$CellContext`imagedistance[$\
CellContext`focus$$, $CellContext`objdist$], $CellContext`objdist$] > 0, 
                  "virtual.", "real."]]]]}], FontSize -> 14]]], 
      "Specifications" :> {{{$CellContext`lenstype$$, "converging", 
          "lens type"}, {
         "converging", "diverging"}}, {{$CellContext`focus$$, 1.5, 
          "focal length"}, 1., 2.5, Appearance -> 
         "Labeled"}, {{$CellContext`ptobj$$, {-5, 2}}, {-5, -2}, {5, 2}, 
         ControlType -> Locator}, {{$CellContext`location$$, {0, 0}}, {-5, 
         0}, {5, 0}, ControlType -> 
         Locator}, {{$CellContext`axes$$, False, "coordinates"}, {
         True, False}}, {{$CellContext`ray1$$, True, "ray 1"}, {
         True, False}}, {{$CellContext`ray2$$, True, "ray 2"}, {
         True, False}}, {{$CellContext`ray3$$, True, "ray 3"}, {True, False}}, 
        Button[
        "reset to default values", $CellContext`lenstype$$ = 
          "converging"; $CellContext`focus$$ = 
          1.5; $CellContext`ptobj$$ = {-5, 2}; $CellContext`location$$ = {0, 
           0}; Null]}, "Options" :> {TrackedSymbols :> Manipulate}, 
      "DefaultOptions" :> {ControllerLinking -> True}],
     ImageSizeCache->{601., {304., 309.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellID->280012750],

Cell[CellGroupData[{

Cell["CAPTION", "Section",
 CellFrame->{{0, 0}, {1, 0}},
 CellFrameColor->RGBColor[0.87, 0.87, 0.87],
 FontFamily->"Helvetica",
 FontSize->12,
 FontWeight->"Bold",
 FontColor->RGBColor[0.597406, 0, 0.0527047]],

Cell["\<\
This Demonstration shows the path of light rays passing through a convex or \
concave lens. \
\>", "Text"]
}, Close]]
}, Open  ]],

Cell[CellGroupData[{

Cell["THIS NOTEBOOK IS THE SOURCE CODE FROM", "Text",
 CellFrame->{{0, 0}, {0, 0}},
 CellMargins->{{48, 10}, {4, 28}},
 CellGroupingRules->{"SectionGrouping", 25},
 CellFrameMargins->{{48, 48}, {6, 5}},
 CellFrameColor->RGBColor[0.87, 0.87, 0.87],
 FontFamily->"Helvetica",
 FontSize->10,
 FontWeight->"Bold",
 FontColor->RGBColor[0.597406, 0, 0.0527047]],

Cell[TextData[{
 "\"",
 ButtonBox["Light Rays in a Lens",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/LightRaysInALens/"], None},
  ButtonNote->"http://demonstrations.wolfram.com/LightRaysInALens/"],
 "\"",
 " from ",
 ButtonBox["the Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->"http://demonstrations.wolfram.com/"],
 "\[ParagraphSeparator]\[NonBreakingSpace]",
 ButtonBox["http://demonstrations.wolfram.com/LightRaysInALens/",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/LightRaysInALens/"], None},
  ButtonNote->"http://demonstrations.wolfram.com/LightRaysInALens/"]
}], "Text",
 CellMargins->{{48, Inherited}, {0, Inherited}},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.5]],

Cell[TextData[{
 "Contributed by: ",
 ButtonBox["Volodymyr Holovatsky",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/author.html?author=Volodymyr+\
Holovatsky"], None},
  ButtonNote->
   "http://demonstrations.wolfram.com/author.html?author=Volodymyr+\
Holovatsky"],
 " (Chernivtsi National University, Ukraine)"
}], "Text",
 CellDingbat->"\[FilledSmallSquare]",
 CellMargins->{{66, 48}, {2, 4}},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.6]],

Cell[CellGroupData[{

Cell[TextData[{
 "A full-function Wolfram ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " system (Version 6 or higher) is required to edit this notebook.\n",
 StyleBox[ButtonBox["GET WOLFRAM MATHEMATICA \[RightGuillemet]",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolfram.com/products/mathematica/"], None},
  ButtonNote->"http://www.wolfram.com/products/mathematica/"],
  FontFamily->"Helvetica",
  FontWeight->"Bold",
  FontSlant->"Italic",
  FontColor->RGBColor[1, 0.42, 0]]
}], "Text",
 CellFrame->True,
 CellMargins->{{48, 68}, {8, 28}},
 CellFrameMargins->12,
 CellFrameColor->RGBColor[0.87, 0.87, 0.87],
 CellChangeTimes->{3.3750111182355957`*^9},
 ParagraphSpacing->{1., 1.},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.411765],
 Background->RGBColor[1, 1, 1]],

Cell[TextData[{
 "\[Copyright] ",
 StyleBox[ButtonBox["Wolfram Demonstrations Project & Contributors",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->"http://demonstrations.wolfram.com/"],
  FontColor->GrayLevel[0.6]],
 "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
 StyleBox[ButtonBox["Terms of Use",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/termsofuse.html"], None},
  ButtonNote->"http://demonstrations.wolfram.com/termsofuse.html"],
  FontColor->GrayLevel[0.6]],
 "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
 StyleBox[ButtonBox["Make a new version of this Demonstration \
\[RightGuillemet]",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/participate/upload.jsp?id=\
LightRaysInALens"], None},
  ButtonNote->None],
  FontColor->GrayLevel[0.6]]
}], "Text",
 CellFrame->{{0, 0}, {0, 0.5}},
 CellMargins->{{48, 10}, {20, 50}},
 CellFrameMargins->{{6, 0}, {6, 6}},
 CellFrameColor->GrayLevel[0.6],
 FontFamily->"Verdana",
 FontSize->9,
 FontColor->GrayLevel[0.6]]
}, Open  ]]
}, Open  ]]
},
Editable->True,
Saveable->False,
ScreenStyleEnvironment->"Working",
CellInsertionPointCell->None,
WindowSize->{780, 650},
WindowMargins->{{Inherited, Inherited}, {Inherited, 0}},
WindowElements->{
 "StatusArea", "MemoryMonitor", "MagnificationPopUp", "VerticalScrollBar", 
  "MenuBar"},
WindowTitle->"Light Rays in a Lens - Source",
DockedCells->{},
CellContext->Notebook,
FrontEndVersion->"8.0 for Microsoft Windows (32-bit) (November 7, 2010)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[622, 23, 140, 3, 70, "Section"],
Cell[765, 28, 3700, 64, 70, "Section"],
Cell[4468, 94, 114561, 2684, 70, "Input",
 CellID->49321582]
}, Open  ]],
Cell[CellGroupData[{
Cell[119066, 2783, 35805, 734, 70, "Output",
 CellID->280012750],
Cell[CellGroupData[{
Cell[154896, 3521, 209, 6, 70, "Section"],
Cell[155108, 3529, 116, 3, 70, "Text"]
}, Close]]
}, Open  ]],
Cell[CellGroupData[{
Cell[155272, 3538, 355, 9, 70, "Text",
 CellGroupingRules->{"SectionGrouping", 25}],
Cell[155630, 3549, 877, 24, 70, "Text"],
Cell[156510, 3575, 503, 16, 70, "Text"],
Cell[CellGroupData[{
Cell[157038, 3595, 815, 24, 70, "Text"],
Cell[157856, 3621, 1188, 33, 70, "Text"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
(* NotebookSignature nT4L7TeisRSZ3CTzDwFqqKvb *)
