(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     61445,       1500]
NotebookOptionsPosition[     60252,       1454]
NotebookOutlinePosition[     60894,       1479]
CellTagsIndexPosition[     60851,       1476]
WindowTitle->Light Ray in a Prism - Source
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Light Ray in a Prism", "Section",
 CellFrame->{{0, 0}, {0, 0}},
 ShowCellBracket->False,
 FontColor->RGBColor[0.597406, 0, 0.0527047]],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztnVuSozgWQDNiPqa3MJ+zpVlCbaB3WlGVNV9dvYH6TQRUph/ZGIHQmwvG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   "], {{0, 0}, {1800, 25}}, {0, 255},
   ColorFunction->RGBColor],
  ImageSize->{1800, 25},
  PlotRange->{{0, 1800}, {0, 25}}]], "Section",
 CellFrame->{{0, 0}, {0, 0}},
 ShowCellBracket->False],

Cell[BoxData[
 RowBox[{"Manipulate", "[", "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
   "\:0440\:043e\:0437\:0440\:0430\:0445\:0443\:043d\:043e\:043a", " ", 
    "\:043a\:0443\:0442\:0430", " ", "\:043c\:0456\:0436", " ", 
    "\:0432\:0435\:043a\:0442\:043e\:0440\:0430\:043c\:0438", " ", "\:0437", 
    " ", "\:0457\:0445", " ", 
    "\:0441\:043a\:0430\:043b\:044f\:0440\:043d\:043e\:0433\:043e", " ", 
    "\:0434\:043e\:0431\:0443\:0442\:043a\:0443"}], "*)"}], 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"angle", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"x1_", ",", "y1_"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"x0_", ",", "y0_"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"x2_", ",", "y2_"}], "}"}]}], "]"}], " ", ":=", 
     RowBox[{"ArcCos", "[", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"x1", ",", "y1"}], "}"}], "-", 
          RowBox[{"{", 
           RowBox[{"x0", ",", "y0"}], "}"}]}], ")"}], ".", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"x2", ",", "y2"}], "}"}], "-", 
          RowBox[{"{", 
           RowBox[{"x0", ",", "y0"}], "}"}]}], ")"}]}], 
       RowBox[{
        SqrtBox[
         RowBox[{
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"x1", "-", "x0"}], ")"}], "2"], "+", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"y1", "-", "y0"}], ")"}], "2"]}]], 
        SqrtBox[
         RowBox[{
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"x2", "-", "x0"}], ")"}], "2"], "+", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"y2", "-", "y0"}], ")"}], "2"]}]]}]], "]"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"(*", 
     RowBox[{
     "\:0440\:043e\:0437\:0440\:0430\:0445\:0443\:043d\:043e\:043a", " ", 
      "\:0442\:043e\:0447\:043a\:0438", " ", 
      "\:043f\:0435\:0440\:0435\:0442\:0438\:043d\:0443", " ", "2", " ", 
      "\:043f\:0440\:044f\:043c\:0438\:0445"}], "*)"}], "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"pcros", "[", 
      RowBox[{"k1_", ",", "b1_", ",", "k2_", ",", "b2_"}], "]"}], ":=", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y"}], "}"}], "/.", 
      RowBox[{
       RowBox[{"Solve", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"y", "==", 
            RowBox[{
             RowBox[{"k1", " ", "x"}], "+", "b1"}]}], ",", 
           RowBox[{"y", "==", 
            RowBox[{
             RowBox[{"k2", " ", "x"}], "+", "b2"}]}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"x", ",", "y"}], "}"}]}], "]"}], "\[LeftDoubleBracket]", 
       "1", "\[RightDoubleBracket]"}]}]}], ";", "\n", 
    RowBox[{
     RowBox[{"k", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"x1_", ",", "y1_"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"x2_", ",", "y2_"}], "}"}]}], "]"}], ":=", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"y2", "-", "y1"}], ")"}], "/", 
      RowBox[{"(", 
       RowBox[{"x2", "-", "x1"}], ")"}]}]}], ";", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"b", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"x1_", ",", "y1_"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"x2_", ",", "y2_"}], "}"}]}], "]"}], ":=", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"y1", " ", "x2"}], " ", "-", " ", 
        RowBox[{"y2", " ", "x1"}]}], ")"}], "/", 
      RowBox[{"(", 
       RowBox[{"x2", "-", "x1"}], ")"}]}]}], ";", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"refangle", "[", 
      RowBox[{"\[Theta]1_", ",", "n_"}], "]"}], ":=", 
     RowBox[{
      RowBox[{"If", " ", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          FractionBox["1", "n"], 
          RowBox[{"Sin", "[", "\[Theta]1", " ", "]"}]}], "\[GreaterEqual]", 
         "1"}], ",", 
        RowBox[{"\[Pi]", "/", "2"}], ",", 
        RowBox[{"ArcSin", "[", 
         RowBox[{
          FractionBox["1", "n"], 
          RowBox[{"Sin", "[", "\[Theta]1", " ", "]"}]}], "]"}]}], "]"}], "//",
       "N"}]}], " ", ";", "  ", 
    RowBox[{"(*", 
     RowBox[{
     "Angle", " ", "of", " ", "Refraction", " ", "at", " ", "the", " ", "1", 
      "st", " ", "interface"}], "*)"}], "\[IndentingNewLine]", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"pnt", ",", "pcr", ",", "k2", ",", 
        RowBox[{"prleft", "=", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "5"}], ",", "0"}], "}"}]}], ",", 
        RowBox[{"prright", "=", 
         RowBox[{"{", 
          RowBox[{"5", ",", "0"}], "}"}]}], ",", " ", 
        RowBox[{"x1norm", "=", 
         RowBox[{"-", "9"}]}], ",", 
        RowBox[{"x2norm", "=", "9"}], ",", 
        RowBox[{"x2ray", "=", "9"}], ",", 
        RowBox[{"rainbow", "=", 
         RowBox[{"{", 
          RowBox[{
          "Red", ",", "Orange", ",", "Yellow", ",", "Green", ",", "LightBlue",
            ",", "Blue", ",", "Purple"}], "}"}]}]}], "}"}], ",", "  ", "\n", 
      RowBox[{
       RowBox[{
        RowBox[{"source", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"x0_", ",", "y0_"}], "}"}], ",", "r0_"}], "]"}], ":=", 
        RowBox[{"{", 
         RowBox[{"Orange", ",", 
          RowBox[{"Disk", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"x0", ",", "y0"}], "}"}], ",", "r0"}], "]"}], ",", 
          RowBox[{"Line", "[", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"x0", ",", "y0"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"x0", "+", 
                RowBox[{"2", "r0"}]}], ",", "y0"}], "}"}]}], "}"}], "]"}], 
          ",", 
          RowBox[{"Line", "[", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"x0", ",", "y0"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"x0", "-", 
                RowBox[{"2", "r0"}]}], ",", "y0"}], "}"}]}], "}"}], "]"}], 
          ",", 
          RowBox[{"Line", "[", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"x0", ",", "y0"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"x0", ",", 
               RowBox[{"y0", "+", 
                RowBox[{"2", "r0"}]}]}], "}"}]}], "}"}], "]"}], ",", 
          RowBox[{"Line", "[", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"x0", ",", "y0"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"x0", ",", 
               RowBox[{"y0", "-", 
                RowBox[{"2", "r0"}]}]}], "}"}]}], "}"}], "]"}], ",", 
          RowBox[{"Line", "[", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"x0", ",", "y0"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"x0", "-", 
                RowBox[{"1.6", "r0"}]}], ",", 
               RowBox[{"y0", "-", 
                RowBox[{"1.6", "r0"}]}]}], "}"}]}], "}"}], "]"}], ",", 
          RowBox[{"Line", "[", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"x0", ",", "y0"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"x0", "+", 
                RowBox[{"1.6", "r0"}]}], ",", 
               RowBox[{"y0", "-", 
                RowBox[{"1.6", "r0"}]}]}], "}"}]}], "}"}], "]"}], ",", 
          RowBox[{"Line", "[", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"x0", ",", "y0"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"x0", "-", 
                RowBox[{"1.6", "r0"}]}], ",", 
               RowBox[{"y0", "+", 
                RowBox[{"1.6", "r0"}]}]}], "}"}]}], "}"}], "]"}], ",", 
          RowBox[{"Line", "[", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"x0", ",", "y0"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"x0", "+", 
                RowBox[{"1.6", "r0"}]}], ",", 
               RowBox[{"y0", "+", 
                RowBox[{"1.6", "r0"}]}]}], "}"}]}], "}"}], "]"}]}], "}"}]}], 
       ";", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"line2", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"x1_", ",", "y1_"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"x2_", ",", "y2_"}], "}"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"x3_", ",", "x4_"}], "}"}]}], "]"}], ":=", 
        RowBox[{"Line", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"x3", ",", 
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"y2", "-", "y1"}], ")"}], "/", 
                RowBox[{"(", 
                 RowBox[{"x2", "-", "x1"}], ")"}]}], "x3"}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"x2", " ", "y1"}], "-", 
                 RowBox[{"x1", " ", "y2"}]}], ")"}], "/", 
               RowBox[{"(", 
                RowBox[{"x2", "-", "x1"}], ")"}]}]}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"x4", ",", 
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"y2", "-", "y1"}], ")"}], "/", 
                RowBox[{"(", 
                 RowBox[{"x2", "-", "x1"}], ")"}]}], "x4"}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"x2", " ", "y1"}], "-", 
                 RowBox[{"x1", " ", "y2"}]}], ")"}], "/", 
               RowBox[{"(", 
                RowBox[{"x2", "-", "x1"}], ")"}]}]}]}], "}"}]}], "}"}], 
         "]"}]}], ";", 
       RowBox[{"(*", 
        RowBox[{
         RowBox[{
         "\:043b\:0456\:043d\:0456\:044f", " ", "\:0437", " ", 
          "\:043f\:043e\:0447\:0430\:0442\:043a\:043e\:043c", " ", "\:0432", 
          " ", "\:0442", ".3"}], ",", " ", 
         RowBox[{
         "\:0437\:0430\:043a\:0456\:043d\:0447\:0435\:043d\:043d\:044f\:043c",
           " ", "\:0432", " ", "\:0442", ".4", "  ", "\:0456", " ", 
          "\:043f\:0440\:043e\:0445\:043e\:0434\:0438\:0442\:044c", " ", 
          "\:0447\:0435\:0440\:0435\:0437", " ", 
          "\:0442\:043e\:0447\:043a\:0438", " ", "1", " ", "\:0456", " ", 
          "2"}]}], "*)"}], "\[IndentingNewLine]", 
       RowBox[{"Graphics", "[", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"(*", "\:043f\:0440\:0438\:0437\:043c\:0430", "*)"}], 
          "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"Thick", ",", 
             RowBox[{"Darker", "[", 
              RowBox[{"Gray", ",", ".7"}], "]"}], ",", 
             RowBox[{"Line", "[", 
              RowBox[{"{", 
               RowBox[{"prtop", ",", "prleft"}], "}"}], "]"}], ",", 
             RowBox[{"Line", "[", 
              RowBox[{"{", 
               RowBox[{"prleft", ",", "prright"}], "}"}], "]"}], ",", 
             RowBox[{"Line", "[", 
              RowBox[{"{", 
               RowBox[{"prtop", ",", "prright"}], "}"}], "]"}], ",", 
             RowBox[{"Lighter", "[", 
              RowBox[{"Blue", ",", ".85"}], "]"}], ",", 
             RowBox[{"Polygon", "[", 
              RowBox[{"{", 
               RowBox[{"prtop", ",", "prleft", ",", "prright"}], "}"}], 
              "]"}]}], "}"}], ",", "\[IndentingNewLine]", 
           RowBox[{"(*", 
            RowBox[{
             RowBox[{
             "\:0431\:0456\:043b\:0438\:0439", " ", 
              "\:043f\:0440\:043e\:043c\:0456\:043d\:044c"}], ",", " ", 
             RowBox[{
             "\:0449\:043e", " ", "\:043f\:0430\:0434\:0430\:0454", " ", 
              "\:043d\:0430", " ", "\:043f\:0440\:0438\:0437\:043c\:0443"}]}],
             "*)"}], "\[IndentingNewLine]", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"source", "[", 
              RowBox[{"sunloc", ",", "0.3"}], "]"}], ",", "Thick", ",", 
             "White", ",", 
             RowBox[{"Line", "[", 
              RowBox[{"{", 
               RowBox[{"sunloc", ",", 
                RowBox[{"pnt", "=", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"prtop", "+", "prleft"}], ")"}], "/", "2"}]}]}], 
               "}"}], "]"}]}], "}"}], ",", "\[IndentingNewLine]", 
           RowBox[{"(*", 
            RowBox[{
            "\:043d\:043e\:0440\:043c\:0430\:043b\:044c", " ", "\:0434\:043e",
              " ", "\:043f\:043e\:0432\:0435\:0440\:0445\:043d\:0456", " ", 
             "\:043f\:0440\:0438\:0437\:043c\:0438", " ", "\:0432", " ", 
             "\:0442\:043e\:0447\:0446\:0456", " ", 
             "\:043f\:0430\:0434\:0456\:043d\:043d\:044f"}], " ", "*)"}], 
           "\[IndentingNewLine]", 
           RowBox[{"If", "[", 
            RowBox[{"pozn", ",", 
             RowBox[{"{", 
              RowBox[{"Thin", ",", "Black", ",", "Dashed", ",", 
               RowBox[{"line2", "[", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"{", 
                    RowBox[{"x1norm", ",", 
                    RowBox[{"y1norm", "=", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    "prtop", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}], "-", 
                    RowBox[{
                    "prleft", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}]}], ")"}], 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "x1norm"}], "+", 
                    RowBox[{
                    "pnt", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}]}], ")"}], "/", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    "prtop", "\[LeftDoubleBracket]", "2", 
                    "\[RightDoubleBracket]"}], "-", 
                    RowBox[{
                    "prleft", "\[LeftDoubleBracket]", "2", 
                    "\[RightDoubleBracket]"}]}], ")"}]}]}], "+", 
                    RowBox[{
                    "pnt", "\[LeftDoubleBracket]", "2", 
                    "\[RightDoubleBracket]"}]}], ")"}]}]}], "}"}], ",", 
                   "pnt"}], "}"}], ",", 
                 RowBox[{"{", 
                  RowBox[{"x1norm", ",", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    "prright", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}], "+", 
                    RowBox[{
                    "prtop", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}]}], ")"}], "/", "2"}]}], "}"}]}],
                 "]"}]}], "}"}], ",", 
             RowBox[{"{", "}"}]}], "]"}], ",", "\[IndentingNewLine]", 
           RowBox[{"(*", 
            RowBox[{
            "\:0437\:0430\:043b\:043e\:043c\:043b\:0435\:043d\:0438\:0439", 
             " ", "\:043f\:0440\:043e\:043c\:0456\:043d\:044c"}], "*)"}], 
           "\[IndentingNewLine]", 
           RowBox[{"Table", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"Thin", ",", 
               RowBox[{
               "rainbow", "\[LeftDoubleBracket]", "i", 
                "\[RightDoubleBracket]"}], ",", 
               RowBox[{"(*", 
                RowBox[{
                "\:0437\:0430\:043b\:043e\:043c\:043b\:0435\:043d\:0456", " ",
                  "\:043f\:0440\:043e\:043c\:0435\:043d\:0456", " ", "\:0432",
                  " ", "\:043f\:0440\:0438\:0437\:043c\:0456"}], "*)"}], 
               RowBox[{"Line", "[", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"prtop", "+", "prleft"}], ")"}], "/", "2"}], ",", 
                  
                  RowBox[{"(", 
                   RowBox[{"pcr", "=", 
                    RowBox[{"pcros", "[", 
                    RowBox[{
                    RowBox[{"k", "[", 
                    RowBox[{"prtop", ",", "prright"}], "]"}], ",", 
                    RowBox[{"b", "[", 
                    RowBox[{"prtop", ",", "prright"}], "]"}], ",", 
                    RowBox[{"k2", "=", 
                    RowBox[{"Tan", "[", 
                    RowBox[{
                    RowBox[{"ArcTan", "[", 
                    RowBox[{"k", "[", 
                    RowBox[{"sunloc", ",", "pnt"}], "]"}], "]"}], "-", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    "sunloc", "\[LeftDoubleBracket]", "2", 
                    "\[RightDoubleBracket]"}], "<", 
                    RowBox[{"(", 
                    RowBox[{"y1norm", "=", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    "prtop", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}], "-", 
                    RowBox[{
                    "prleft", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}]}], ")"}], 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "x1norm"}], "+", 
                    RowBox[{
                    "pnt", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}]}], ")"}], "/", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    "prtop", "\[LeftDoubleBracket]", "2", 
                    "\[RightDoubleBracket]"}], "-", 
                    RowBox[{
                    "prleft", "\[LeftDoubleBracket]", "2", 
                    "\[RightDoubleBracket]"}]}], ")"}]}]}], "+", 
                    RowBox[{
                    "pnt", "\[LeftDoubleBracket]", "2", 
                    "\[RightDoubleBracket]"}]}]}], ")"}]}], ",", "1", ",", 
                    RowBox[{"-", "1"}]}], "]"}], 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"\[Beta]", "=", 
                    RowBox[{"angle", "[", 
                    RowBox[{"sunloc", ",", "pnt", ",", 
                    RowBox[{"{", 
                    RowBox[{"x1norm", ",", "y1norm"}], "}"}]}], "]"}]}], 
                    ")"}], "-", 
                    RowBox[{"refangle", "[", 
                    RowBox[{"\[Beta]", ",", 
                    RowBox[{"(", 
                    RowBox[{"n1", "=", 
                    RowBox[{"nred", "+", 
                    RowBox[{"disp", "*", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"i", "-", "1"}], ")"}], "/", "6"}]}]}]}], ")"}]}],
                     "]"}]}], ")"}]}]}], "]"}]}], ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    "prtop", "\[LeftDoubleBracket]", "2", 
                    "\[RightDoubleBracket]"}], "+", 
                    RowBox[{
                    "prleft", "\[LeftDoubleBracket]", "2", 
                    "\[RightDoubleBracket]"}]}], ")"}], "/", "2"}], "-", 
                    RowBox[{"k2", " ", 
                    RowBox[{
                    "pnt", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}]}]}]}], "]"}]}], ")"}]}], "}"}], 
                "]"}], ",", 
               RowBox[{"(*", 
                RowBox[{
                 RowBox[{
                 "\:0437\:0430\:043b\:043e\:043c\:043b\:0435\:043d\:0456", 
                  " ", "\:043f\:0440\:043e\:043c\:0435\:043d\:0456"}], ",", 
                 " ", 
                 RowBox[{
                 "\:0449\:043e", " ", 
                  "\:0432\:0438\:0445\:043e\:0434\:044f\:0442\:044c", " ", 
                  "\:0437", " ", "\:043f\:0440\:0438\:0437\:043c\:0438"}]}], 
                "*)"}], 
               RowBox[{"Line", "[", 
                RowBox[{"{", 
                 RowBox[{"pcr", ",", 
                  RowBox[{"{", 
                   RowBox[{"x2ray", ",", 
                    RowBox[{
                    RowBox[{"x2ray", " ", 
                    RowBox[{"(", 
                    RowBox[{"k3", "=", 
                    RowBox[{"Tan", "[", 
                    RowBox[{
                    RowBox[{"ArcTan", "[", 
                    RowBox[{"k", "[", 
                    RowBox[{"prtop", ",", "prright"}], "]"}], "]"}], "+", 
                    RowBox[{"\[Pi]", "/", "2"}], "-", 
                    RowBox[{"refangle", "[", 
                    RowBox[{
                    RowBox[{"\[CapitalOmega]", "-", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    "sunloc", "\[LeftDoubleBracket]", "2", 
                    "\[RightDoubleBracket]"}], "<", "y1norm"}], ",", "1", ",", 
                    RowBox[{"-", "1"}]}], "]"}], 
                    RowBox[{"refangle", "[", 
                    RowBox[{"\[Beta]", ",", 
                    RowBox[{"(", 
                    RowBox[{"nred", "+", 
                    RowBox[{"disp", "*", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"i", "-", "1"}], ")"}], "/", "6"}]}]}], ")"}]}], 
                    "]"}]}]}], ",", 
                    RowBox[{"1", "/", 
                    RowBox[{"(", 
                    RowBox[{"nred", "+", 
                    RowBox[{"disp", "*", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"i", "-", "1"}], ")"}], "/", "6"}]}]}], ")"}]}]}],
                     "]"}]}], "]"}]}], ")"}]}], "+", 
                    RowBox[{
                    "pcr", "\[LeftDoubleBracket]", "2", 
                    "\[RightDoubleBracket]"}], "-", 
                    RowBox[{"k3", " ", 
                    RowBox[{
                    "pcr", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}]}]}]}], "}"}]}], "}"}], "]"}]}], 
              "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"i", ",", "7", ",", "1", ",", 
               RowBox[{"-", "1"}]}], "}"}]}], "]"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"If", "[", 
            RowBox[{"pozn", ",", 
             RowBox[{"{", 
              RowBox[{"Thin", ",", 
               RowBox[{"Darker", "[", 
                RowBox[{"Red", ",", ".6"}], "]"}], ",", 
               RowBox[{"Text", "[", 
                RowBox[{
                 RowBox[{"Style", "[", 
                  RowBox[{"\"\<\[CapitalOmega]\>\"", ",", 
                   RowBox[{"FontSize", "\[Rule]", "14"}]}], "]"}], ",", 
                 RowBox[{"prtop", "+", 
                  RowBox[{"{", 
                   RowBox[{"0", ",", 
                    RowBox[{"-", "1"}]}], "}"}]}]}], "]"}], ",", 
               RowBox[{"Text", "[", 
                RowBox[{
                 RowBox[{"Style", "[", 
                  RowBox[{"\"\<\[Alpha]\>\"", ",", 
                   RowBox[{"FontSize", "\[Rule]", "14"}]}], "]"}], ",", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"prtop", "+", "prleft"}], ")"}], "/", "2"}], "+", 
                  
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"-", ".9"}], ",", ".2"}], "}"}]}]}], "]"}], ",", 
               RowBox[{"Text", "[", 
                RowBox[{
                 RowBox[{"Style", "[", 
                  RowBox[{"\"\<\[Alpha]'\>\"", ",", 
                   RowBox[{"FontSize", "\[Rule]", "14"}]}], "]"}], ",", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"prtop", "+", "prleft"}], ")"}], "/", "2"}], "+", 
                  
                  RowBox[{"{", 
                   RowBox[{".9", ",", ".2"}], "}"}]}]}], "]"}], ",", 
               RowBox[{"Text", "[", 
                RowBox[{
                 RowBox[{"Style", "[", 
                  RowBox[{"\"\<\[Beta]\>\"", ",", 
                   RowBox[{"FontSize", "\[Rule]", "14"}]}], "]"}], ",", 
                 RowBox[{"pcr", "+", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"-", "1"}], ",", 
                    RowBox[{"-", ".2"}]}], "}"}]}]}], "]"}], ",", 
               RowBox[{"Text", "[", 
                RowBox[{
                 RowBox[{"Style", "[", 
                  RowBox[{"\"\<\[Beta]'\>\"", ",", 
                   RowBox[{"FontSize", "\[Rule]", "14"}]}], "]"}], ",", 
                 RowBox[{"pcr", "+", 
                  RowBox[{"{", 
                   RowBox[{"1", ",", "0"}], "}"}]}]}], "]"}], ",", "Dashed", 
               ",", 
               RowBox[{"(*", 
                RowBox[{
                "\:043d\:043e\:0440\:043c\:0430\:043b\:044c2", " ", 
                 "\:0434\:043e", " ", 
                 "\:043f\:043e\:0432\:0435\:0440\:0445\:043d\:0456", " ", 
                 "\:043f\:0440\:0438\:0437\:043c\:0438"}], "*)"}], 
               RowBox[{"line2", "[", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"{", 
                    RowBox[{"x2norm", ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    "prtop", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}], "-", 
                    RowBox[{
                    "prright", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}]}], ")"}], 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "x2norm"}], "+", 
                    RowBox[{
                    "pcr", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}]}], ")"}], "/", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    "prtop", "\[LeftDoubleBracket]", "2", 
                    "\[RightDoubleBracket]"}], "-", 
                    RowBox[{
                    "prright", "\[LeftDoubleBracket]", "2", 
                    "\[RightDoubleBracket]"}]}], ")"}]}]}], "+", 
                    RowBox[{
                    "pcr", "\[LeftDoubleBracket]", "2", 
                    "\[RightDoubleBracket]"}]}]}], "}"}], ",", "pcr"}], "}"}],
                  ",", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{
                   "pnt", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}], ",", "x2norm"}], "}"}]}], 
                "]"}]}], "}"}], ",", 
             RowBox[{"{", "}"}]}], "]"}], ",", 
           RowBox[{"GrayLevel", "[", "0.8", "]"}], ",", 
           RowBox[{"Rectangle", "[", 
            RowBox[{
             RowBox[{"prleft", "-", 
              RowBox[{"{", 
               RowBox[{"0", ",", "2.3"}], "}"}]}], ",", 
             RowBox[{"prright", "+", 
              RowBox[{"{", 
               RowBox[{"5", ",", 
                RowBox[{"-", ".08"}]}], "}"}]}]}], "]"}]}], 
          "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
         RowBox[{"(*", 
          RowBox[{
          "\:041e\:043f\:0446\:0456\:0457", " ", 
           "\:0413\:0440\:0430\:0444\:0456\:043a\:0430"}], "*)"}], 
         "\[IndentingNewLine]", 
         RowBox[{"ImageSize", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{"420", ",", "400"}], "}"}]}], ",", 
         RowBox[{"AspectRatio", "\[Rule]", " ", "0.72"}], ",", 
         RowBox[{"Axes", "\[Rule]", "False"}], ",", 
         RowBox[{"PlotRange", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"-", "9"}], ",", "9"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"-", "2"}], ",", "12"}], "}"}]}], "}"}]}], ",", 
         RowBox[{"ImagePadding", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"10", ",", "10"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"0", ",", "40"}], "}"}]}], "}"}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"PlotLabel", "\[Rule]", 
          RowBox[{"Style", "[", 
           RowBox[{
            RowBox[{"Column", "[", 
             RowBox[{"If", "[", 
              RowBox[{"pozn", ",", 
               RowBox[{"{", 
                RowBox[{"Text", "[", 
                 RowBox[{"\"\<\[CapitalOmega] = \>\"", "<>", 
                  RowBox[{"ToString", "[", 
                   RowBox[{"Round", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"\[CapitalOmega]", "=", 
                    RowBox[{"angle", "[", 
                    RowBox[{"prleft", ",", "prtop", ",", "prright"}], "]"}]}],
                     ")"}], "/", "Degree"}], ",", "1"}], "]"}], "]"}], "<>", 
                  "\"\<\[Degree]  \[Alpha] = \>\"", "<>", 
                  RowBox[{"ToString", "[", 
                   RowBox[{"Round", "[", 
                    RowBox[{
                    RowBox[{"\[Beta]", "/", "Degree"}], ",", ".1"}], "]"}], 
                   "]"}], "<>", "\"\<\[Degree]  \[Alpha]' = \>\"", "<>", 
                  RowBox[{"ToString", "[", 
                   RowBox[{"Round", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"refangle", "[", 
                    RowBox[{"\[Beta]", ",", "nred"}], "]"}], "/", "Degree"}], 
                    ",", ".1"}], "]"}], "]"}], "<>", 
                  "\"\<\[Degree]  \[Beta] = \>\"", "<>", 
                  RowBox[{"ToString", "[", 
                   RowBox[{"Round", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"\[CapitalOmega]", "-", 
                    RowBox[{"refangle", "[", 
                    RowBox[{"\[Beta]", ",", "nred"}], "]"}]}], ")"}], "/", 
                    "Degree"}], ",", ".1"}], "]"}], "]"}], "<>", 
                  "\"\<\[Degree]  \[Beta]' = \>\"", "<>", 
                  RowBox[{"ToString", "[", 
                   RowBox[{"Round", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"refangle", "[", 
                    RowBox[{
                    RowBox[{"\[CapitalOmega]", "-", 
                    RowBox[{"refangle", "[", 
                    RowBox[{"\[Beta]", ",", "nred"}], "]"}]}], ",", 
                    RowBox[{"1", "/", "nred"}]}], "]"}], "/", "Degree"}], ",",
                     ".1"}], "]"}], "]"}], "<>", "\"\<\[Degree]\>\""}], "]"}],
                 "}"}], ",", 
               RowBox[{"{", "}"}]}], "]"}], "]"}], ",", 
            RowBox[{"FontSize", "\[Rule]", "14"}]}], "]"}]}], ",", 
         RowBox[{"Background", "\[Rule]", 
          RowBox[{"GrayLevel", "[", "0.8", "]"}]}]}], "]"}]}]}], 
     RowBox[{"(*", 
      RowBox[{"End", " ", "Graphics"}], "*)"}], "\[IndentingNewLine]", 
     "]"}]}], ",", 
   RowBox[{"(*", 
    RowBox[{"End", " ", "Module"}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
    "\:0456\:043d\:0441\:0442\:0440\:0443\:043c\:0435\:043d\:0442\:0438", " ",
      "\:0434\:043b\:044f", " ", 
     "\:043a\:0435\:0440\:0443\:0432\:0430\:043d\:043d\:044f"}], "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "nred", ",", "1.5111", ",", "\"\<refraction index for red light\>\""}], 
      "\[IndentingNewLine]", 
      RowBox[{
      "(*", "\"\<\:043f\:043e\:043a\:0430\:0437\:043d\:0438\:043a \
\:0437\:0430\:043b\:043e\:043c\:043b\:0435\:043d\:043d\:044f \:043c\:0430\
\:0442\:0435\:0440\:0456\:0430\:043b\:0443 \:043f\:0440\:0438\:0437\:043c\
\:0438 \\n (\:0434\:043b\:044f \:0447\:0435\:0440\:0432\:043e\:043d\:043e\
\:0433\:043e \:043f\:0440\:043e\:043c\:0435\:043d\:044f)\>\"", "*)"}], "}"}], 
     ",", "0.8", ",", "2.2", ",", 
     RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "disp", ",", "0.0057", ",", 
       "\"\<difference between violet \\nand red refraction indices\>\""}], 
      " ", "\[IndentingNewLine]", 
      RowBox[{
      "(*", "\"\<\:0440\:0456\:0437\:043d\:0438\:0446\:044f \
\:043c\:0456\:0436 \:043f\:043e\:043a\:0430\:0437\:043d\:0438\:043a\:0430\
\:043c\:0438 \:0437\:0430\:043b\:043e\:043c\:043b\:0435\:043d\:043d\:044f \\n \
\:0434\:043b\:044f \:0447\:0435\:0440\:0432. \:0442\:0430 \:0444\:0456\:043e\
\:043b. \:043f\:0440\:043e\:043c\:0435\:043d\:044f\>\"", "*)"}], "}"}], ",", 
     "0", ",", 
     RowBox[{"8", "*", "0.0057"}], ",", 
     RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"prtop", ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "10"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "5"}], ",", "6.5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4.95", ",", "12"}], "}"}], ",", "Locator"}], "}"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"sunloc", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "9"}], ",", "4"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "9"}], ",", 
       RowBox[{"-", "2"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "8"}], ",", "12"}], "}"}], ",", "Locator"}], "}"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "pozn", ",", "True", ",", "\"\<annotations and surface normals\>\""}], 
      RowBox[{
      "(*", "\"\<\:041f\:043e\:0437\:043d\:0430\:0447\:0435\:043d\:043d\:044f \
\:0442\:0430 \:043d\:043e\:0440\:043c\:0430\:043b\:0456 \:0434\:043e \:043f\
\:043e\:0432\:0435\:0440\:0445\:043d\:0456 \:043f\:0440\:0438\:0437\:043c\
\:0438\>\"", "*)"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"True", ",", "False"}], "}"}]}], "}"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"Button", "[", 
    RowBox[{"\"\<reset to initial values\>\"", 
     RowBox[{
     "(*", "\"\<\:0432\:0441\:0442\:0430\:043d\:043e\:0432\:0438\:0442\:0438 \
\:043f\:043e\:0447\:0430\:0442\:043a\:043e\:0432\:0456 \:0437\:043d\:0430\
\:0447\:0435\:043d\:043d\:044f\>\"", "*)"}], ",", 
     RowBox[{
      RowBox[{"prtop", "=", 
       RowBox[{"{", 
        RowBox[{"0", ",", "10"}], "}"}]}], ";", 
      RowBox[{"sunloc", "=", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "9"}], ",", "4"}], "}"}]}], ";", 
      RowBox[{"disp", "=", "0.0057"}], ";", 
      RowBox[{"nred", "=", "1.5111"}]}]}], "]"}], ",", "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"TrackedSymbols", "\[RuleDelayed]", "True"}]}], 
  "\[IndentingNewLine]", "]"}]], "Input",
 CellChangeTimes->{
  3.35696210375764*^9, {3.44484682934375*^9, 3.44484682984375*^9}, {
   3.445182807217108*^9, 3.4451828322481976`*^9}, {3.4451829517474327`*^9, 
   3.4451829862940865`*^9}, {3.445183055637393*^9, 3.44518309054342*^9}, {
   3.4451851795516343`*^9, 3.445185306472697*^9}, {3.4451853549567614`*^9, 
   3.4451854071908026`*^9}, {3.445185439534345*^9, 3.445185531143134*^9}, {
   3.445185572970991*^9, 3.445185613861355*^9}},
 CellID->570476082]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`disp$$ = 0.0057, $CellContext`nred$$ = 
    1.5111, $CellContext`pozn$$ = True, $CellContext`prtop$$ = {0, 
    10}, $CellContext`sunloc$$ = {-9, 4}, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`nred$$], 1.5111, "refraction index for red light"}, 
      0.8, 2.2}, {{
       Hold[$CellContext`disp$$], 0.0057, 
       "difference between violet \nand red refraction indices"}, 0, 
      0.0456}, {{
       Hold[$CellContext`prtop$$], {0, 10}}, {-5, 6.5}, {4.95, 12}}, {{
       Hold[$CellContext`sunloc$$], {-9, 4}}, {-9, -2}, {-8, 12}}, {{
       Hold[$CellContext`pozn$$], True, "annotations and surface normals"}, {
      True, False}}, {
      Hold[
       Button[
       "reset to initial values", $CellContext`prtop$$ = {0, 
          10}; $CellContext`sunloc$$ = {-9, 4}; $CellContext`disp$$ = 
         0.0057; $CellContext`nred$$ = 1.5111]], 
      Manipulate`Dump`ThisIsNotAControl}}, Typeset`size$$ = {
    420., {198., 202.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True, $CellContext`nred$551172$$ = 
    0, $CellContext`disp$551173$$ = 0, $CellContext`prtop$551174$$ = {0, 
    0}, $CellContext`sunloc$551175$$ = {0, 0}, $CellContext`pozn$551176$$ = 
    False}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`disp$$ = 0.0057, $CellContext`nred$$ = 
        1.5111, $CellContext`pozn$$ = 
        True, $CellContext`prtop$$ = {0, 10}, $CellContext`sunloc$$ = {-9, 
         4}}, "ControllerVariables" :> {
        Hold[$CellContext`nred$$, $CellContext`nred$551172$$, 0], 
        Hold[$CellContext`disp$$, $CellContext`disp$551173$$, 0], 
        Hold[$CellContext`prtop$$, $CellContext`prtop$551174$$, {0, 0}], 
        Hold[$CellContext`sunloc$$, $CellContext`sunloc$551175$$, {0, 0}], 
        Hold[$CellContext`pozn$$, $CellContext`pozn$551176$$, False]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> ($CellContext`angle[{
           Pattern[$CellContext`x1, 
            Blank[]], 
           Pattern[$CellContext`y1, 
            Blank[]]}, {
           Pattern[$CellContext`x0, 
            Blank[]], 
           Pattern[$CellContext`y0, 
            Blank[]]}, {
           Pattern[$CellContext`x2, 
            Blank[]], 
           Pattern[$CellContext`y2, 
            Blank[]]}] := 
        ArcCos[Dot[{$CellContext`x1, $CellContext`y1} - {$CellContext`x0, \
$CellContext`y0}, {$CellContext`x2, $CellContext`y2} - {$CellContext`x0, \
$CellContext`y0}]/((($CellContext`x1 - $CellContext`x0)^2 + ($CellContext`y1 - \
$CellContext`y0)^2)^
           Rational[
            1, 2] (($CellContext`x2 - $CellContext`x0)^2 + ($CellContext`y2 - \
$CellContext`y0)^2)^Rational[1, 2])]; $CellContext`pcros[
          Pattern[$CellContext`k1, 
           Blank[]], 
          Pattern[$CellContext`b1, 
           Blank[]], 
          Pattern[$CellContext`k2, 
           Blank[]], 
          Pattern[$CellContext`b2, 
           Blank[]]] := ReplaceAll[{$CellContext`x, $CellContext`y}, 
          Part[
           
           Solve[{$CellContext`y == $CellContext`k1 $CellContext`x + \
$CellContext`b1, $CellContext`y == $CellContext`k2 $CellContext`x + \
$CellContext`b2}, {$CellContext`x, $CellContext`y}], 1]]; $CellContext`k[{
           Pattern[$CellContext`x1, 
            Blank[]], 
           Pattern[$CellContext`y1, 
            Blank[]]}, {
           Pattern[$CellContext`x2, 
            Blank[]], 
           Pattern[$CellContext`y2, 
            
            Blank[]]}] := ($CellContext`y2 - \
$CellContext`y1)/($CellContext`x2 - $CellContext`x1); $CellContext`b[{
           Pattern[$CellContext`x1, 
            Blank[]], 
           Pattern[$CellContext`y1, 
            Blank[]]}, {
           Pattern[$CellContext`x2, 
            Blank[]], 
           Pattern[$CellContext`y2, 
            
            Blank[]]}] := ($CellContext`y1 $CellContext`x2 - $CellContext`y2 \
$CellContext`x1)/($CellContext`x2 - $CellContext`x1); $CellContext`refangle[
          Pattern[$CellContext`\[Theta]1, 
           Blank[]], 
          Pattern[$CellContext`n, 
           Blank[]]] := N[
          If[(1/$CellContext`n) Sin[$CellContext`\[Theta]1] >= 1, Pi/2, 
           ArcSin[(1/$CellContext`n) Sin[$CellContext`\[Theta]1]]]]; 
       Module[{$CellContext`pnt$, $CellContext`pcr$, $CellContext`k2$, \
$CellContext`prleft$ = {-5, 0}, $CellContext`prright$ = {5, 
           0}, $CellContext`x1norm$ = -9, $CellContext`x2norm$ = 
          9, $CellContext`x2ray$ = 
          9, $CellContext`rainbow$ = {
           Red, Orange, Yellow, Green, LightBlue, Blue, 
            Purple}}, $CellContext`source[{
             Pattern[$CellContext`x0, 
              Blank[]], 
             Pattern[$CellContext`y0, 
              Blank[]]}, 
            Pattern[$CellContext`r0, 
             Blank[]]] := {Orange, 
            Disk[{$CellContext`x0, $CellContext`y0}, $CellContext`r0], 
            
            Line[{{$CellContext`x0, $CellContext`y0}, {$CellContext`x0 + 
               2 $CellContext`r0, $CellContext`y0}}], 
            
            Line[{{$CellContext`x0, $CellContext`y0}, {$CellContext`x0 - 
               2 $CellContext`r0, $CellContext`y0}}], 
            
            Line[{{$CellContext`x0, $CellContext`y0}, {$CellContext`x0, \
$CellContext`y0 + 2 $CellContext`r0}}], 
            
            Line[{{$CellContext`x0, $CellContext`y0}, {$CellContext`x0, \
$CellContext`y0 - 2 $CellContext`r0}}], 
            
            Line[{{$CellContext`x0, $CellContext`y0}, {$CellContext`x0 - 
               1.6 $CellContext`r0, $CellContext`y0 - 1.6 $CellContext`r0}}], 
            
            
            Line[{{$CellContext`x0, $CellContext`y0}, {$CellContext`x0 + 
               1.6 $CellContext`r0, $CellContext`y0 - 1.6 $CellContext`r0}}], 
            
            
            Line[{{$CellContext`x0, $CellContext`y0}, {$CellContext`x0 - 
               1.6 $CellContext`r0, $CellContext`y0 + 1.6 $CellContext`r0}}], 
            
            
            Line[{{$CellContext`x0, $CellContext`y0}, {$CellContext`x0 + 
               1.6 $CellContext`r0, $CellContext`y0 + 
               1.6 $CellContext`r0}}]}; $CellContext`line2[{{
              Pattern[$CellContext`x1, 
               Blank[]], 
              Pattern[$CellContext`y1, 
               Blank[]]}, {
              Pattern[$CellContext`x2, 
               Blank[]], 
              Pattern[$CellContext`y2, 
               Blank[]]}}, {
             Pattern[$CellContext`x3, 
              Blank[]], 
             Pattern[$CellContext`x4, 
              Blank[]]}] := 
          Line[{{$CellContext`x3, (($CellContext`y2 - \
$CellContext`y1)/($CellContext`x2 - $CellContext`x1)) $CellContext`x3 + \
($CellContext`x2 $CellContext`y1 - $CellContext`x1 \
$CellContext`y2)/($CellContext`x2 - $CellContext`x1)}, {$CellContext`x4, \
(($CellContext`y2 - $CellContext`y1)/($CellContext`x2 - $CellContext`x1)) \
$CellContext`x4 + ($CellContext`x2 $CellContext`y1 - $CellContext`x1 \
$CellContext`y2)/($CellContext`x2 - $CellContext`x1)}}]; Graphics[{{Thick, 
             Darker[Gray, 0.7], 
             Line[{$CellContext`prtop$$, $CellContext`prleft$}], 
             Line[{$CellContext`prleft$, $CellContext`prright$}], 
             Line[{$CellContext`prtop$$, $CellContext`prright$}], 
             Lighter[Blue, 0.85], 
             
             Polygon[{$CellContext`prtop$$, $CellContext`prleft$, \
$CellContext`prright$}]}, {
             $CellContext`source[$CellContext`sunloc$$, 0.3], Thick, White, 
             
             Line[{$CellContext`sunloc$$, $CellContext`pnt$ = \
($CellContext`prtop$$ + $CellContext`prleft$)/2}]}, 
            If[$CellContext`pozn$$, {Thin, Black, Dashed, 
              $CellContext`line2[{{$CellContext`x1norm$, $CellContext`y1norm = (\
Part[$CellContext`prtop$$, 1] - 
                    Part[$CellContext`prleft$, 1]) ((-$CellContext`x1norm$ + 
                    Part[$CellContext`pnt$, 1])/(
                    Part[$CellContext`prtop$$, 2] - 
                    Part[$CellContext`prleft$, 2])) + 
                  Part[$CellContext`pnt$, 
                    2]}, $CellContext`pnt$}, {$CellContext`x1norm$, (
                 Part[$CellContext`prright$, 1] + 
                 Part[$CellContext`prtop$$, 1])/2}]}, {}], 
            Table[{Thin, 
              Part[$CellContext`rainbow$, $CellContext`i], 
              
              Line[{($CellContext`prtop$$ + $CellContext`prleft$)/
                2, $CellContext`pcr$ = $CellContext`pcros[
                  $CellContext`k[$CellContext`prtop$$, $CellContext`prright$], 
                  $CellContext`b[$CellContext`prtop$$, \
$CellContext`prright$], $CellContext`k2$ = Tan[ArcTan[
                    $CellContext`k[$CellContext`sunloc$$, $CellContext`pnt$]] - 
                    If[Part[$CellContext`sunloc$$, 
                    2] < ($CellContext`y1norm = (
                    Part[$CellContext`prtop$$, 1] - 
                    Part[$CellContext`prleft$, 1]) ((-$CellContext`x1norm$ + 
                    Part[$CellContext`pnt$, 1])/(
                    Part[$CellContext`prtop$$, 2] - 
                    Part[$CellContext`prleft$, 2])) + 
                    Part[$CellContext`pnt$, 2]), 
                    1, -1] (($CellContext`\[Beta] = \
$CellContext`angle[$CellContext`sunloc$$, $CellContext`pnt$, \
{$CellContext`x1norm$, $CellContext`y1norm}]) - \
$CellContext`refangle[$CellContext`\[Beta], $CellContext`n1 = \
$CellContext`nred$$ + $CellContext`disp$$ (($CellContext`i - 1)/6)])], (
                    Part[$CellContext`prtop$$, 2] + 
                    Part[$CellContext`prleft$, 2])/2 - $CellContext`k2$ 
                  Part[$CellContext`pnt$, 1]]}], 
              
              Line[{$CellContext`pcr$, {$CellContext`x2ray$, \
$CellContext`x2ray$ ($CellContext`k3 = Tan[ArcTan[
                    $CellContext`k[$CellContext`prtop$$, \
$CellContext`prright$]] + 
                    Pi/2 - $CellContext`refangle[$CellContext`\[CapitalOmega] - 
                    If[Part[$CellContext`sunloc$$, 2] < $CellContext`y1norm, 
                    1, -1] $CellContext`refangle[$CellContext`\[Beta], \
$CellContext`nred$$ + $CellContext`disp$$ (($CellContext`i - 1)/6)], 
                    
                    1/($CellContext`nred$$ + $CellContext`disp$$ \
(($CellContext`i - 1)/6))]]) + Part[$CellContext`pcr$, 2] - $CellContext`k3 
                 Part[$CellContext`pcr$, 1]}}]}, {$CellContext`i, 7, 1, -1}], 
            
            If[$CellContext`pozn$$, {Thin, 
              Darker[Red, 0.6], 
              Text[
               Style[
               "\[CapitalOmega]", FontSize -> 14], $CellContext`prtop$$ + {
                0, -1}], 
              Text[
               Style[
               "\[Alpha]", FontSize -> 
                14], ($CellContext`prtop$$ + $CellContext`prleft$)/2 + {-0.9, 
                0.2}], 
              Text[
               Style[
               "\[Alpha]'", FontSize -> 
                14], ($CellContext`prtop$$ + $CellContext`prleft$)/2 + {0.9, 
                0.2}], 
              Text[
               Style[
               "\[Beta]", FontSize -> 14], $CellContext`pcr$ + {-1, -0.2}], 
              Text[
               Style["\[Beta]'", FontSize -> 14], $CellContext`pcr$ + {1, 0}],
               Dashed, 
              $CellContext`line2[{{$CellContext`x2norm$, (
                   Part[$CellContext`prtop$$, 1] - 
                   Part[$CellContext`prright$, 1]) ((-$CellContext`x2norm$ + 
                    Part[$CellContext`pcr$, 1])/(
                   Part[$CellContext`prtop$$, 2] - 
                   Part[$CellContext`prright$, 2])) + 
                 Part[$CellContext`pcr$, 2]}, $CellContext`pcr$}, {
                Part[$CellContext`pnt$, 1], $CellContext`x2norm$}]}, {}], 
            GrayLevel[0.8], 
            
            Rectangle[$CellContext`prleft$ - {
             0, 2.3}, $CellContext`prright$ + {5, -0.08}]}, 
           ImageSize -> {420, 400}, AspectRatio -> 0.72, Axes -> False, 
           PlotRange -> {{-9, 9}, {-2, 12}}, 
           ImagePadding -> {{10, 10}, {0, 40}}, PlotLabel -> Style[
             Column[
              If[$CellContext`pozn$$, {
                Text[
                 StringJoin["\[CapitalOmega] = ", 
                  ToString[
                   
                   Round[($CellContext`\[CapitalOmega] = \
$CellContext`angle[$CellContext`prleft$, $CellContext`prtop$$, \
$CellContext`prright$])/Degree, 1]], "\[Degree]  \[Alpha] = ", 
                  ToString[
                   Round[$CellContext`\[Beta]/Degree, 0.1]], 
                  "\[Degree]  \[Alpha]' = ", 
                  ToString[
                   
                   Round[$CellContext`refangle[$CellContext`\[Beta], \
$CellContext`nred$$]/Degree, 0.1]], "\[Degree]  \[Beta] = ", 
                  ToString[
                   
                   Round[($CellContext`\[CapitalOmega] - \
$CellContext`refangle[$CellContext`\[Beta], $CellContext`nred$$])/Degree, 
                    0.1]], "\[Degree]  \[Beta]' = ", 
                  ToString[
                   
                   Round[$CellContext`refangle[$CellContext`\[CapitalOmega] - \
$CellContext`refangle[$CellContext`\[Beta], $CellContext`nred$$], 
                    1/$CellContext`nred$$]/Degree, 0.1]], 
                  "\[Degree]"]]}, {}]], FontSize -> 14], Background -> 
           GrayLevel[0.8]]]), 
      "Specifications" :> {{{$CellContext`nred$$, 1.5111, 
          "refraction index for red light"}, 0.8, 2.2, Appearance -> 
         "Labeled"}, {{$CellContext`disp$$, 0.0057, 
          "difference between violet \nand red refraction indices"}, 0, 
         0.0456, Appearance -> 
         "Labeled"}, {{$CellContext`prtop$$, {0, 10}}, {-5, 6.5}, {4.95, 12}, 
         ControlType -> 
         Locator}, {{$CellContext`sunloc$$, {-9, 4}}, {-9, -2}, {-8, 12}, 
         ControlType -> 
         Locator}, {{$CellContext`pozn$$, True, 
          "annotations and surface normals"}, {True, False}}, 
        Button[
        "reset to initial values", $CellContext`prtop$$ = {0, 
           10}; $CellContext`sunloc$$ = {-9, 4}; $CellContext`disp$$ = 
          0.0057; $CellContext`nred$$ = 1.5111]}, 
      "Options" :> {TrackedSymbols :> True}, 
      "DefaultOptions" :> {ControllerLinking -> True}],
     ImageSizeCache->{471., {284., 289.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellID->12083050],

Cell[CellGroupData[{

Cell["CAPTION", "Section",
 CellFrame->{{0, 0}, {1, 0}},
 CellFrameColor->RGBColor[0.87, 0.87, 0.87],
 FontFamily->"Helvetica",
 FontSize->12,
 FontWeight->"Bold",
 FontColor->RGBColor[0.597406, 0, 0.0527047]],

Cell["This Demonstration shows the path of a ray in a prism. ", "Text"]
}, Close]]
}, Open  ]],

Cell[CellGroupData[{

Cell["THIS NOTEBOOK IS THE SOURCE CODE FROM", "Text",
 CellFrame->{{0, 0}, {0, 0}},
 CellMargins->{{48, 10}, {4, 28}},
 CellGroupingRules->{"SectionGrouping", 25},
 CellFrameMargins->{{48, 48}, {6, 5}},
 CellFrameColor->RGBColor[0.87, 0.87, 0.87],
 FontFamily->"Helvetica",
 FontSize->10,
 FontWeight->"Bold",
 FontColor->RGBColor[0.597406, 0, 0.0527047]],

Cell[TextData[{
 "\"",
 ButtonBox["Light Ray in a Prism",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/LightRayInAPrism/"], None},
  ButtonNote->"http://demonstrations.wolfram.com/LightRayInAPrism/"],
 "\"",
 " from ",
 ButtonBox["the Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->"http://demonstrations.wolfram.com/"],
 "\[ParagraphSeparator]\[NonBreakingSpace]",
 ButtonBox["http://demonstrations.wolfram.com/LightRayInAPrism/",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/LightRayInAPrism/"], None},
  ButtonNote->"http://demonstrations.wolfram.com/LightRayInAPrism/"]
}], "Text",
 CellMargins->{{48, Inherited}, {0, Inherited}},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.5]],

Cell[TextData[{
 "Contributed by: ",
 ButtonBox["Volodymyr Holovatsky",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/author.html?author=Volodymyr+\
Holovatsky"], None},
  ButtonNote->
   "http://demonstrations.wolfram.com/author.html?author=Volodymyr+\
Holovatsky"],
 " (Chernivtsi National University, Ukraine)"
}], "Text",
 CellDingbat->"\[FilledSmallSquare]",
 CellMargins->{{66, 48}, {2, 4}},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.6]],

Cell[CellGroupData[{

Cell[TextData[{
 "A full-function Wolfram ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " system (Version 6 or higher) is required to edit this notebook.\n",
 StyleBox[ButtonBox["GET WOLFRAM MATHEMATICA \[RightGuillemet]",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolfram.com/products/mathematica/"], None},
  ButtonNote->"http://www.wolfram.com/products/mathematica/"],
  FontFamily->"Helvetica",
  FontWeight->"Bold",
  FontSlant->"Italic",
  FontColor->RGBColor[1, 0.42, 0]]
}], "Text",
 CellFrame->True,
 CellMargins->{{48, 68}, {8, 28}},
 CellFrameMargins->12,
 CellFrameColor->RGBColor[0.87, 0.87, 0.87],
 CellChangeTimes->{3.3750111182355957`*^9},
 ParagraphSpacing->{1., 1.},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.411765],
 Background->RGBColor[1, 1, 1]],

Cell[TextData[{
 "\[Copyright] ",
 StyleBox[ButtonBox["Wolfram Demonstrations Project & Contributors",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->"http://demonstrations.wolfram.com/"],
  FontColor->GrayLevel[0.6]],
 "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
 StyleBox[ButtonBox["Terms of Use",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/termsofuse.html"], None},
  ButtonNote->"http://demonstrations.wolfram.com/termsofuse.html"],
  FontColor->GrayLevel[0.6]],
 "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
 StyleBox[ButtonBox["Make a new version of this Demonstration \
\[RightGuillemet]",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/participate/upload.jsp?id=\
LightRayInAPrism"], None},
  ButtonNote->None],
  FontColor->GrayLevel[0.6]]
}], "Text",
 CellFrame->{{0, 0}, {0, 0.5}},
 CellMargins->{{48, 10}, {20, 50}},
 CellFrameMargins->{{6, 0}, {6, 6}},
 CellFrameColor->GrayLevel[0.6],
 FontFamily->"Verdana",
 FontSize->9,
 FontColor->GrayLevel[0.6]]
}, Open  ]]
}, Open  ]]
},
Editable->True,
Saveable->False,
ScreenStyleEnvironment->"Working",
CellInsertionPointCell->None,
WindowSize->{710, 650},
WindowMargins->{{Inherited, Inherited}, {Inherited, 0}},
WindowElements->{
 "StatusArea", "MemoryMonitor", "MagnificationPopUp", "VerticalScrollBar", 
  "MenuBar"},
WindowTitle->"Light Ray in a Prism - Source",
DockedCells->{},
CellContext->Notebook,
FrontEndVersion->"8.0 for Microsoft Windows (32-bit) (November 7, 2010)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[622, 23, 140, 3, 70, "Section"],
Cell[765, 28, 3700, 64, 70, "Section"],
Cell[4468, 94, 36405, 899, 70, "Input",
 CellID->570476082]
}, Open  ]],
Cell[CellGroupData[{
Cell[40910, 998, 15186, 318, 70, "Output",
 CellID->12083050],
Cell[CellGroupData[{
Cell[56121, 1320, 209, 6, 70, "Section"],
Cell[56333, 1328, 71, 0, 70, "Text"]
}, Close]]
}, Open  ]],
Cell[CellGroupData[{
Cell[56452, 1334, 355, 9, 70, "Text",
 CellGroupingRules->{"SectionGrouping", 25}],
Cell[56810, 1345, 877, 24, 70, "Text"],
Cell[57690, 1371, 503, 16, 70, "Text"],
Cell[CellGroupData[{
Cell[58218, 1391, 815, 24, 70, "Text"],
Cell[59036, 1417, 1188, 33, 70, "Text"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
(* NotebookSignature 9TzZM@hJ1NIsMApONTA2QDUx *)
