(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[   1405392,      26226]
NotebookOptionsPosition[   1403898,      26170]
NotebookOutlinePosition[   1404533,      26195]
CellTagsIndexPosition[   1404490,      26192]
WindowTitle->Lens Doublets - Source
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Lens Doublets", "Section",
 CellFrame->{{0, 0}, {0, 0}},
 ShowCellBracket->False,
 FontColor->RGBColor[0.597406, 0, 0.0527047]],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztnVuSozgWQDNiPqa3MJ+zpVlCbaB3WlGVNV9dvYH6TQRUph/ZGIHQmwvG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   "], {{0, 0}, {1800, 25}}, {0, 255},
   ColorFunction->RGBColor],
  ImageSize->{1800, 25},
  PlotRange->{{0, 1800}, {0, 25}}]], "Section",
 CellFrame->{{0, 0}, {0, 0}},
 ShowCellBracket->False],

Cell[BoxData[
 RowBox[{"Manipulate", "[", "\n", " ", 
  RowBox[{
   RowBox[{"Column", "[", "\n", "  ", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"Show", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"Graphics", "[", 
          RowBox[{"{", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"Opacity", "[", "0.8", "]"}], ",", " ", 
             RowBox[{"GeometricTransformation", "[", "\n", "         ", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"AbsoluteThickness", "[", "1", "]"}], ",", " ", 
                 RowBox[{"AbsolutePointSize", "[", "1", "]"}], ",", " ", 
                 RowBox[{"EdgeForm", "[", "]"}], ",", " ", "\n", "          ", 
                 RowBox[{"RGBColor", "[", 
                  RowBox[{"0.4", ",", " ", "0.6", ",", " ", "0.8"}], "]"}], 
                 ",", " ", 
                 RowBox[{"Polygon", "[", 
                  RowBox[{"Dynamic", "[", "\n", "            ", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Function", "[", 
                    RowBox[{
                    RowBox[{"{", "element", "}"}], ",", " ", 
                    RowBox[{"Take", "[", 
                    RowBox[{"#1", ",", " ", "element"}], "]"}]}], "]"}], " ", 
                    "/@", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"1", ",", " ", "27"}], "}"}], ",", " ", "\n", 
                    "                ", 
                    RowBox[{"{", 
                    RowBox[{"28", ",", " ", "54"}], "}"}]}], "}"}]}], " ", 
                    "&"}], " ", ")"}], "[", 
                    RowBox[{"polygons11188572008312134018969656", "[", 
                    RowBox[{
                    "r11", ",", " ", "\n", "              ", "r12", ",", " ", 
                    "r13"}], "]"}], "]"}], "]"}], "]"}]}], "}"}], ",", " ", 
               RowBox[{"Dynamic", "[", 
                RowBox[{
                 RowBox[{"BesselJ", "[", 
                  RowBox[{"1.", ",", " ", "3."}], "]"}], ";", " ", "\n", 
                 "           ", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"Degree", "*", "\[Theta]13"}], "]"}], ",", " ", 
                    RowBox[{"-", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"Degree", "*", "\[Theta]13"}], "]"}]}]}], "}"}], 
                    ",", " ", "\n", "             ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Sin", "[", 
                    RowBox[{"Degree", "*", "\[Theta]13"}], "]"}], ",", " ", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"Degree", "*", "\[Theta]13"}], "]"}]}], "}"}]}], 
                    "}"}], ",", " ", 
                   RowBox[{"{", 
                    RowBox[{"x13", ",", " ", "0"}], "}"}]}], "}"}]}], "]"}]}],
               "]"}], ",", " ", "\n", "        ", 
             RowBox[{"GeometricTransformation", "[", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"AbsoluteThickness", "[", "1", "]"}], ",", " ", "\n",
                  "          ", 
                 RowBox[{"AbsolutePointSize", "[", "1", "]"}], ",", " ", 
                 RowBox[{"EdgeForm", "[", "]"}], ",", " ", 
                 RowBox[{"RGBColor", "[", 
                  RowBox[{"0.4", ",", " ", "0.6", ",", " ", "0.8"}], "]"}], 
                 ",", " ", "\n", "          ", 
                 RowBox[{"Polygon", "[", 
                  RowBox[{"Dynamic", "[", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Function", "[", 
                    RowBox[{
                    RowBox[{"{", "element", "}"}], ",", " ", 
                    RowBox[{"Take", "[", 
                    RowBox[{"#1", ",", " ", "element"}], "]"}]}], "]"}], " ", 
                    "/@", " ", 
                    RowBox[{"{", "\n", "                ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"1", ",", " ", "27"}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"28", ",", " ", "54"}], "}"}]}], "}"}]}], " ", 
                    "&"}], " ", ")"}], "[", "\n", "             ", 
                    RowBox[{"polygons12188572008312134018987715", "[", 
                    RowBox[{"r21", ",", " ", "r22", ",", " ", "r23"}], "]"}], 
                    "]"}], "]"}], "]"}]}], "}"}], ",", " ", "\n", "         ", 
               RowBox[{"Dynamic", "[", 
                RowBox[{
                 RowBox[{"BesselJ", "[", 
                  RowBox[{"1.", ",", " ", "3."}], "]"}], ";", " ", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"Degree", "*", "\[Theta]23"}], "]"}], ",", " ", 
                    "\n", "              ", 
                    RowBox[{"-", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"Degree", "*", "\[Theta]23"}], "]"}]}]}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Sin", "[", 
                    RowBox[{"Degree", "*", "\[Theta]23"}], "]"}], ",", " ", 
                    RowBox[{"Cos", "[", 
                    RowBox[{
                    "Degree", "*", "\n", "                ", "\[Theta]23"}], 
                    "]"}]}], "}"}]}], "}"}], ",", " ", 
                   RowBox[{"{", 
                    RowBox[{"x23", ",", " ", "0"}], "}"}]}], "}"}]}], "]"}]}],
               "]"}], ",", " ", "\n", "        ", 
             "staticpolygons13188572008312134018989499", ",", " ", 
             RowBox[{"Opacity", "[", "1", "]"}], ",", " ", "\n", "        ", 
             RowBox[{"RGBColor", "[", 
              RowBox[{
              "0.038747429704798886", ",", " ", "0.9161617552424038", ",", 
               " ", "\n", "         ", "0.03984721226918142"}], "]"}], ",", 
             " ", 
             RowBox[{"AbsoluteThickness", "[", "Medium", "]"}], ",", " ", 
             "\n", "        ", 
             RowBox[{"Line", "[", 
              RowBox[{"Dynamic", "[", 
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"#1", "[", 
                    RowBox[{"[", 
                    RowBox[{"{", 
                    RowBox[{"1", ",", " ", "2"}], "}"}], "]"}], "]"}], ",", 
                    " ", 
                    RowBox[{"#1", "[", 
                    RowBox[{"[", 
                    RowBox[{"{", 
                    RowBox[{"4", ",", " ", "5"}], "}"}], "]"}], "]"}]}], 
                    "}"}], " ", "&"}], " ", ")"}], " ", "/@", " ", "\n", 
                 "           ", 
                 RowBox[{"Select", "[", 
                  RowBox[{
                   RowBox[{"raytracefunction1188572008312134018995817", "[", 
                    RowBox[{
                    "r11", ",", " ", "r12", ",", " ", "\n", "             ", 
                    "r13", ",", " ", "r21", ",", " ", "r22", ",", " ", "r23", 
                    ",", " ", "x13", ",", " ", "x23", ",", " ", "\[Theta]13", 
                    ",", " ", "\[Theta]23"}], "]"}], ",", " ", "\n", 
                   "            ", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"#1", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], " ", ">", " ", 
                    RowBox[{"-", "9.87654321*^8"}]}], " ", "&"}]}], " ", 
                  "]"}]}], ",", " ", 
                RowBox[{
                "SynchronousUpdating", " ", "\[Rule]", " ", "\n", 
                 "           ", "False"}]}], "]"}], "]"}], ",", " ", 
             RowBox[{"Arrowheads", "[", "Large", "]"}], ",", " ", 
             RowBox[{"Thickness", "[", "Large", "]"}], ",", " ", "\n", 
             "        ", 
             RowBox[{"Dashing", "[", 
              RowBox[{"{", 
               RowBox[{"Small", ",", " ", "Small"}], "}"}], "]"}], ",", " ", 
             RowBox[{"RGBColor", "[", 
              RowBox[{"1", ",", " ", "1", ",", " ", "0"}], "]"}], ",", " ", 
             "\n", "        ", 
             RowBox[{"Arrow", "[", 
              RowBox[{"Dynamic", "[", 
               RowBox[{
                RowBox[{
                 RowBox[{"If", "[", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"laststartpos\[Theta]13", " ", "!=", " ", 
                    RowBox[{"{", 
                    RowBox[{"x13", ",", " ", "0"}], "}"}]}], " ", "||", " ", 
                    "\n", "             ", 
                    RowBox[{
                    "last\[Theta]13", " ", "=!=", " ", "\[Theta]13"}]}], ",", 
                   " ", 
                   RowBox[{
                    RowBox[{"laststartpos\[Theta]13", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"x13", ",", " ", "0"}], "}"}]}], ";", " ", "\n", 
                    "             ", 
                    RowBox[{"last\[Theta]13", " ", "=", " ", "\[Theta]13"}], 
                    ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"x\[Theta]13", ",", " ", "y\[Theta]13"}], "}"}], 
                    " ", "=", " ", 
                    RowBox[{
                    "laststartpos\[Theta]13", " ", "+", " ", "\n", 
                    "               ", 
                    RowBox[{"radius\[Theta]13", "*", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"\[Theta]13", "*", "Degree"}], "]"}], ",", " ", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"\[Theta]13", "*", "Degree"}], "]"}]}], 
                    "}"}]}]}]}]}]}], "]"}], ";", " ", "\n", "           ", 
                 RowBox[{"{", 
                  RowBox[{"laststartpos\[Theta]13", ",", " ", 
                   RowBox[{"{", 
                    RowBox[{"x\[Theta]13", ",", " ", "y\[Theta]13"}], "}"}]}],
                   "}"}]}], ",", " ", "\n", "          ", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"{", 
                    RowBox[{"laststartpos\[Theta]13", ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"x\[Theta]13", ",", " ", "y\[Theta]13"}], "}"}]}],
                     "}"}], " ", "=", " ", "#1"}], ")"}], " ", "&"}]}], " ", 
               "]"}], "]"}], ",", " ", "\n", "        ", 
             RowBox[{"Tooltip", "[", 
              RowBox[{
               RowBox[{"Locator", "[", 
                RowBox[{
                 RowBox[{"Dynamic", "[", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"BesselJ", "[", 
                    RowBox[{"1.", ",", " ", "3."}], "]"}], ";", " ", "\n", 
                    "            ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"x\[Theta]13", ",", " ", "y\[Theta]13"}], "}"}], 
                    " ", "!=", " ", "lastlocpos\[Theta]13"}], " ", "||", " ", 
                    
                    RowBox[{
                    "last\[Theta]13", " ", "!=", " ", "\n", 
                    "                ", "\[Theta]13"}]}], ",", " ", 
                    RowBox[{
                    RowBox[{"lastlocpos\[Theta]13", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"x\[Theta]13", ",", " ", "y\[Theta]13"}], "}"}]}],
                     ";", " ", 
                    RowBox[{
                    "last\[Theta]13", " ", "=", " ", "\n", "                ",
                     "\[Theta]13"}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"x\[Theta]13", ",", " ", "y\[Theta]13"}], "}"}], 
                    " ", "=", " ", 
                    RowBox[{
                    "laststartpos\[Theta]13", " ", "+", " ", "\n", 
                    "                 ", 
                    RowBox[{"radius\[Theta]13", "*", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"\[Theta]13", "*", "Degree"}], "]"}], ",", " ", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"\[Theta]13", "*", "Degree"}], "]"}]}], 
                    "}"}]}]}]}]}]}], "]"}], ";", " ", "\n", "             ", 
                    RowBox[{"{", 
                    RowBox[{"x\[Theta]13", ",", " ", "y\[Theta]13"}], "}"}]}],
                     ")"}]}], ",", " ", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"x\[Theta]13", ",", " ", "y\[Theta]13"}], "}"}], 
                    " ", "=", " ", "#1"}], ";", " ", "\n", "             ", 
                    RowBox[{"xoff\[Theta]13", " ", "=", " ", 
                    RowBox[{"x\[Theta]13", " ", "-", " ", "x13"}]}], ";", " ", 
                    RowBox[{"yoff\[Theta]13", " ", "=", " ", 
                    RowBox[{"y\[Theta]13", " ", "+", " ", "0"}]}], ";", " ", 
                    "\n", "             ", 
                    RowBox[{"radius\[Theta]13", " ", "=", " ", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{
                    RowBox[{"xoff\[Theta]13", "^", "2"}], " ", "+", " ", 
                    RowBox[{"yoff\[Theta]13", "^", "2"}]}], "]"}]}], ";", " ",
                     "\n", "             ", 
                    RowBox[{"\[Theta]13", " ", "=", " ", 
                    RowBox[{"Chop", "[", 
                    RowBox[{
                    RowBox[{"ArcTan", "[", 
                    RowBox[{"xoff\[Theta]13", ",", " ", "yoff\[Theta]13"}], 
                    "]"}], "/", "Degree"}], "]"}]}], ";", " ", "\n", 
                    "             ", 
                    RowBox[{"{", 
                    RowBox[{"x\[Theta]13", ",", " ", "y\[Theta]13"}], "}"}]}],
                     ")"}], " ", "&"}]}], " ", "]"}], ",", " ", 
                 RowBox[{"Graphics", "[", 
                  RowBox[{
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"RGBColor", "[", 
                    RowBox[{
                    RowBox[{"1", "/", "3"}], ",", " ", 
                    RowBox[{"1", "/", "3"}], ",", " ", "1"}], "]"}], ",", " ",
                     "\n", "            ", 
                    RowBox[{"Disk", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0", ",", " ", "0"}], "}"}], ",", " ", "0.5"}], 
                    "]"}]}], "}"}], ",", " ", 
                   RowBox[{"ImageSize", " ", "\[Rule]", " ", "10"}]}], 
                  "]"}]}], "]"}], ",", " ", "\n", "         ", 
               RowBox[{"Dynamic", "[", 
                RowBox[{"StringJoin", "[", 
                 RowBox[{"\"\<\[Theta]13 = \>\"", ",", " ", 
                  RowBox[{"ToString", "[", "\[Theta]13", "]"}]}], "]"}], 
                "]"}]}], "]"}], ",", " ", "\n", "        ", 
             RowBox[{"Arrowheads", "[", "Large", "]"}], ",", " ", 
             RowBox[{"Thickness", "[", "Large", "]"}], ",", " ", 
             RowBox[{"Dashing", "[", 
              RowBox[{"{", 
               RowBox[{"Small", ",", " ", "Small"}], "}"}], "]"}], ",", " ", 
             "\n", "        ", 
             RowBox[{"RGBColor", "[", 
              RowBox[{"1", ",", " ", "1", ",", " ", "0"}], "]"}], ",", " ", 
             RowBox[{"Arrow", "[", 
              RowBox[{"Dynamic", "[", "\n", "          ", 
               RowBox[{
                RowBox[{
                 RowBox[{"If", "[", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"laststartpos\[Theta]23", " ", "!=", " ", 
                    RowBox[{"{", 
                    RowBox[{"x23", ",", " ", "0"}], "}"}]}], " ", "||", " ", 
                    RowBox[{
                    "last\[Theta]23", " ", "=!=", " ", "\[Theta]23"}]}], ",", 
                   " ", "\n", "            ", 
                   RowBox[{
                    RowBox[{"laststartpos\[Theta]23", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"x23", ",", " ", "0"}], "}"}]}], ";", " ", 
                    RowBox[{"last\[Theta]23", " ", "=", " ", "\[Theta]23"}], 
                    ";", " ", "\n", "             ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"x\[Theta]23", ",", " ", "y\[Theta]23"}], "}"}], 
                    " ", "=", " ", 
                    RowBox[{"laststartpos\[Theta]23", " ", "+", " ", 
                    RowBox[{"radius\[Theta]23", "*", "\n", "                ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"\[Theta]23", "*", "Degree"}], "]"}], ",", " ", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"\[Theta]23", "*", "Degree"}], "]"}]}], 
                    "}"}]}]}]}]}]}], "]"}], ";", " ", "\n", "           ", 
                 RowBox[{"{", 
                  RowBox[{"laststartpos\[Theta]23", ",", " ", 
                   RowBox[{"{", 
                    RowBox[{"x\[Theta]23", ",", " ", "y\[Theta]23"}], "}"}]}],
                   "}"}]}], ",", " ", "\n", "          ", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"{", 
                    RowBox[{"laststartpos\[Theta]23", ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"x\[Theta]23", ",", " ", "y\[Theta]23"}], "}"}]}],
                     "}"}], " ", "=", " ", "#1"}], ")"}], " ", "&"}]}], " ", 
               "]"}], "]"}], ",", " ", "\n", "        ", 
             RowBox[{"Tooltip", "[", 
              RowBox[{
               RowBox[{"Locator", "[", 
                RowBox[{
                 RowBox[{"Dynamic", "[", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"BesselJ", "[", 
                    RowBox[{"1.", ",", " ", "3."}], "]"}], ";", " ", "\n", 
                    "            ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"x\[Theta]23", ",", " ", "y\[Theta]23"}], "}"}], 
                    " ", "!=", " ", "lastlocpos\[Theta]23"}], " ", "||", " ", 
                    
                    RowBox[{
                    "last\[Theta]23", " ", "!=", " ", "\n", 
                    "                ", "\[Theta]23"}]}], ",", " ", 
                    RowBox[{
                    RowBox[{"lastlocpos\[Theta]23", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"x\[Theta]23", ",", " ", "y\[Theta]23"}], "}"}]}],
                     ";", " ", 
                    RowBox[{
                    "last\[Theta]23", " ", "=", " ", "\n", "                ",
                     "\[Theta]23"}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"x\[Theta]23", ",", " ", "y\[Theta]23"}], "}"}], 
                    " ", "=", " ", 
                    RowBox[{
                    "laststartpos\[Theta]23", " ", "+", " ", "\n", 
                    "                 ", 
                    RowBox[{"radius\[Theta]23", "*", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"\[Theta]23", "*", "Degree"}], "]"}], ",", " ", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"\[Theta]23", "*", "Degree"}], "]"}]}], 
                    "}"}]}]}]}]}]}], "]"}], ";", " ", "\n", "             ", 
                    RowBox[{"{", 
                    RowBox[{"x\[Theta]23", ",", " ", "y\[Theta]23"}], "}"}]}],
                     ")"}]}], ",", " ", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"x\[Theta]23", ",", " ", "y\[Theta]23"}], "}"}], 
                    " ", "=", " ", "#1"}], ";", " ", "\n", "             ", 
                    RowBox[{"xoff\[Theta]23", " ", "=", " ", 
                    RowBox[{"x\[Theta]23", " ", "-", " ", "x23"}]}], ";", " ", 
                    RowBox[{"yoff\[Theta]23", " ", "=", " ", 
                    RowBox[{"y\[Theta]23", " ", "+", " ", "0"}]}], ";", " ", 
                    "\n", "             ", 
                    RowBox[{"radius\[Theta]23", " ", "=", " ", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{
                    RowBox[{"xoff\[Theta]23", "^", "2"}], " ", "+", " ", 
                    RowBox[{"yoff\[Theta]23", "^", "2"}]}], "]"}]}], ";", " ",
                     "\n", "             ", 
                    RowBox[{"\[Theta]23", " ", "=", " ", 
                    RowBox[{"Chop", "[", 
                    RowBox[{
                    RowBox[{"ArcTan", "[", 
                    RowBox[{"xoff\[Theta]23", ",", " ", "yoff\[Theta]23"}], 
                    "]"}], "/", "Degree"}], "]"}]}], ";", " ", "\n", 
                    "             ", 
                    RowBox[{"{", 
                    RowBox[{"x\[Theta]23", ",", " ", "y\[Theta]23"}], "}"}]}],
                     ")"}], " ", "&"}]}], " ", "]"}], ",", " ", 
                 RowBox[{"Graphics", "[", 
                  RowBox[{
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"RGBColor", "[", 
                    RowBox[{
                    RowBox[{"1", "/", "3"}], ",", " ", 
                    RowBox[{"1", "/", "3"}], ",", " ", "1"}], "]"}], ",", " ",
                     "\n", "            ", 
                    RowBox[{"Disk", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0", ",", " ", "0"}], "}"}], ",", " ", "0.5"}], 
                    "]"}]}], "}"}], ",", " ", 
                   RowBox[{"ImageSize", " ", "\[Rule]", " ", "10"}]}], 
                  "]"}]}], "]"}], ",", " ", "\n", "         ", 
               RowBox[{"Dynamic", "[", 
                RowBox[{"StringJoin", "[", 
                 RowBox[{"\"\<\[Theta]23 = \>\"", ",", " ", 
                  RowBox[{"ToString", "[", "\[Theta]23", "]"}]}], "]"}], 
                "]"}]}], "]"}], ",", " ", "\n", "        ", 
             RowBox[{"Tooltip", "[", 
              RowBox[{
               RowBox[{"Locator", "[", 
                RowBox[{
                 RowBox[{"Dynamic", "[", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"BesselJ", "[", 
                    RowBox[{"1.", ",", " ", "3."}], "]"}], ";", " ", 
                    RowBox[{"{", 
                    RowBox[{"x13", ",", " ", "0"}], "}"}]}], ",", " ", "\n", 
                   "           ", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"x13", " ", "=", " ", 
                    RowBox[{"Chop", "[", 
                    RowBox[{"#1", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "]"}]}], ")"}], " ", 
                    "&"}]}], " ", "]"}], ",", " ", 
                 RowBox[{"Graphics", "[", 
                  RowBox[{
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"1", ",", " ", 
                    RowBox[{"1", "/", "3"}], ",", " ", 
                    RowBox[{"1", "/", "3"}]}], "]"}], ",", " ", "\n", 
                    "            ", 
                    RowBox[{"Disk", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0", ",", " ", "0"}], "}"}], ",", " ", "0.8"}], 
                    "]"}]}], "}"}], ",", " ", 
                   RowBox[{"ImageSize", " ", "\[Rule]", " ", "10"}]}], 
                  "]"}]}], "]"}], ",", " ", "\n", "         ", 
               RowBox[{"Dynamic", "[", 
                RowBox[{"StringJoin", "[", 
                 RowBox[{"\"\<x13 = \>\"", ",", " ", 
                  RowBox[{"ToString", "[", "x13", "]"}]}], "]"}], "]"}]}], 
              "]"}], ",", " ", "\n", "        ", 
             RowBox[{"Tooltip", "[", 
              RowBox[{
               RowBox[{"Locator", "[", 
                RowBox[{
                 RowBox[{"Dynamic", "[", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"BesselJ", "[", 
                    RowBox[{"1.", ",", " ", "3."}], "]"}], ";", " ", 
                    RowBox[{"{", 
                    RowBox[{"x23", ",", " ", "0"}], "}"}]}], ",", " ", "\n", 
                   "           ", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"x23", " ", "=", " ", 
                    RowBox[{"Chop", "[", 
                    RowBox[{"#1", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "]"}]}], ")"}], " ", 
                    "&"}]}], " ", "]"}], ",", " ", 
                 RowBox[{"Graphics", "[", 
                  RowBox[{
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"RGBColor", "[", 
                    RowBox[{"1", ",", " ", 
                    RowBox[{"1", "/", "3"}], ",", " ", 
                    RowBox[{"1", "/", "3"}]}], "]"}], ",", " ", "\n", 
                    "            ", 
                    RowBox[{"Disk", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0", ",", " ", "0"}], "}"}], ",", " ", "0.8"}], 
                    "]"}]}], "}"}], ",", " ", 
                   RowBox[{"ImageSize", " ", "\[Rule]", " ", "10"}]}], 
                  "]"}]}], "]"}], ",", " ", "\n", "         ", 
               RowBox[{"Dynamic", "[", 
                RowBox[{"StringJoin", "[", 
                 RowBox[{"\"\<x23 = \>\"", ",", " ", 
                  RowBox[{"ToString", "[", "x23", "]"}]}], "]"}], "]"}]}], 
              "]"}]}], "}"}], "}"}], "]"}], "}"}], ",", " ", "\n", "    ", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"PlotLabel", " ", "\[Rule]", " ", "\"\<lens doublets\>\""}],
           ",", " ", 
          RowBox[{"PlotRange", " ", "\[Rule]", " ", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"0", ",", " ", "200"}], "}"}], ",", " ", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"-", "15"}], ",", " ", "15"}], "}"}]}], "}"}]}], ",", 
          " ", "\n", "     ", 
          RowBox[{"ImageSize", " ", "\[Rule]", " ", 
           RowBox[{"{", 
            RowBox[{"500", ",", " ", "200"}], "}"}]}], ",", " ", 
          RowBox[{"Axes", " ", "\[Rule]", " ", "True"}], ",", " ", 
          RowBox[{"ImageSize", " ", "\[Rule]", " ", "800"}], ",", " ", "\n", 
          "     ", 
          RowBox[{"AspectRatio", " ", "\[Rule]", " ", "Automatic"}]}], 
         "}"}]}], "]"}], "}"}], ",", " ", "\n", "  ", "Center"}], "]"}], ",", 
   "\n", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"r11", ",", " ", "71.89"}], "}"}], ",", " ", "50", ",", " ", 
     "80", ",", " ", 
     RowBox[{"ControlType", " ", "\[Rule]", " ", "None"}]}], "}"}], ",", " ", 
   "\n", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"r12", ",", " ", "26.81"}], "}"}], ",", " ", "20", ",", " ", 
     "50", ",", " ", 
     RowBox[{"ControlType", " ", "\[Rule]", " ", "None"}]}], "}"}], ",", " ", 
   "\n", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"r13", ",", " ", 
       RowBox[{"-", "38.35"}]}], "}"}], ",", " ", 
     RowBox[{"-", "50"}], ",", " ", 
     RowBox[{"-", "30"}], ",", " ", 
     RowBox[{"ControlType", " ", "\[Rule]", " ", "None"}]}], "}"}], ",", " ", 
   "\n", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"r21", ",", " ", "38.35"}], "}"}], ",", " ", "30", ",", " ", 
     "50", ",", " ", 
     RowBox[{"ControlType", " ", "\[Rule]", " ", "None"}]}], "}"}], ",", " ", 
   "\n", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"r22", ",", " ", 
       RowBox[{"-", "26.81"}]}], "}"}], ",", " ", 
     RowBox[{"-", "50"}], ",", " ", 
     RowBox[{"-", "20"}], ",", " ", 
     RowBox[{"ControlType", " ", "\[Rule]", " ", "None"}]}], "}"}], ",", " ", 
   "\n", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"r23", ",", " ", 
       RowBox[{"-", "71.89"}]}], "}"}], ",", " ", 
     RowBox[{"-", "80"}], ",", " ", 
     RowBox[{"-", "50"}], ",", " ", 
     RowBox[{"ControlType", " ", "\[Rule]", " ", "None"}]}], "}"}], ",", " ", 
   "\n", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x13", ",", " ", "50"}], "}"}], ",", " ", "20", ",", " ", "150",
      ",", " ", 
     RowBox[{"ControlType", " ", "\[Rule]", " ", "None"}]}], "}"}], ",", " ", 
   "\n", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x23", ",", " ", "100"}], "}"}], ",", " ", "20", ",", " ", 
     "150", ",", " ", 
     RowBox[{"ControlType", " ", "\[Rule]", " ", "None"}]}], "}"}], ",", " ", 
   "\n", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\[Theta]13", ",", " ", "0"}], "}"}], ",", " ", "0", ",", " ", 
     "360", ",", " ", 
     RowBox[{"ControlType", " ", "\[Rule]", " ", "None"}]}], "}"}], ",", " ", 
   "\n", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\[Theta]23", ",", " ", "0"}], "}"}], ",", " ", "0", ",", " ", 
     "360", ",", " ", 
     RowBox[{"ControlType", " ", "\[Rule]", " ", "None"}]}], "}"}], ",", " ", 
   "\n", " ", 
   RowBox[{"Style", "[", 
    RowBox[{"Grid", "[", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"\"\<r11\>\"", ",", " ", 
        RowBox[{"Manipulator", "[", 
         RowBox[{
          RowBox[{"Dynamic", "[", "r11", "]"}], ",", " ", 
          RowBox[{"{", 
           RowBox[{"50", ",", " ", "80"}], "}"}]}], "]"}], ",", " ", "\n", 
        "     ", 
        RowBox[{"Dynamic", "[", "r11", "]"}]}], "}"}], "}"}], "]"}], "]"}], 
   ",", " ", "\n", " ", 
   RowBox[{"Style", "[", 
    RowBox[{"Grid", "[", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"\"\<r12\>\"", ",", " ", 
        RowBox[{"Manipulator", "[", 
         RowBox[{
          RowBox[{"Dynamic", "[", "r12", "]"}], ",", " ", 
          RowBox[{"{", 
           RowBox[{"20", ",", " ", "50"}], "}"}]}], "]"}], ",", " ", "\n", 
        "     ", 
        RowBox[{"Dynamic", "[", "r12", "]"}]}], "}"}], "}"}], "]"}], "]"}], 
   ",", " ", "\n", " ", 
   RowBox[{"Style", "[", 
    RowBox[{"Grid", "[", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"\"\<r13\>\"", ",", " ", 
        RowBox[{"Manipulator", "[", 
         RowBox[{
          RowBox[{"Dynamic", "[", "r13", "]"}], ",", " ", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "50"}], ",", " ", 
            RowBox[{"-", "30"}]}], "}"}]}], "]"}], ",", " ", "\n", "     ", 
        RowBox[{"Dynamic", "[", "r13", "]"}]}], "}"}], "}"}], "]"}], "]"}], 
   ",", " ", "\n", " ", 
   RowBox[{"Style", "[", 
    RowBox[{"Grid", "[", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"\"\<r21\>\"", ",", " ", 
        RowBox[{"Manipulator", "[", 
         RowBox[{
          RowBox[{"Dynamic", "[", "r21", "]"}], ",", " ", 
          RowBox[{"{", 
           RowBox[{"30", ",", " ", "50"}], "}"}]}], "]"}], ",", " ", "\n", 
        "     ", 
        RowBox[{"Dynamic", "[", "r21", "]"}]}], "}"}], "}"}], "]"}], "]"}], 
   ",", " ", "\n", " ", 
   RowBox[{"Style", "[", 
    RowBox[{"Grid", "[", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"\"\<r22\>\"", ",", " ", 
        RowBox[{"Manipulator", "[", 
         RowBox[{
          RowBox[{"Dynamic", "[", "r22", "]"}], ",", " ", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "50"}], ",", " ", 
            RowBox[{"-", "20"}]}], "}"}]}], "]"}], ",", " ", "\n", "     ", 
        RowBox[{"Dynamic", "[", "r22", "]"}]}], "}"}], "}"}], "]"}], "]"}], 
   ",", " ", "\n", " ", 
   RowBox[{"Style", "[", 
    RowBox[{"Grid", "[", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"\"\<r23\>\"", ",", " ", 
        RowBox[{"Manipulator", "[", 
         RowBox[{
          RowBox[{"Dynamic", "[", "r23", "]"}], ",", " ", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "80"}], ",", " ", 
            RowBox[{"-", "50"}]}], "}"}]}], "]"}], ",", " ", "\n", "     ", 
        RowBox[{"Dynamic", "[", "r23", "]"}]}], "}"}], "}"}], "]"}], "]"}], 
   ",", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x\[Theta]13", ",", " ", "55."}], "}"}], ",", " ", 
     RowBox[{"ControlType", " ", "\[Rule]", " ", "None"}]}], "}"}], ",", " ", 
   "\n", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"y\[Theta]13", ",", " ", "0"}], "}"}], ",", " ", 
     RowBox[{"ControlType", " ", "\[Rule]", " ", "None"}]}], "}"}], ",", " ", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"radius\[Theta]13", ",", " ", "5."}], "}"}], ",", " ", "\n", 
     "  ", 
     RowBox[{"ControlType", " ", "\[Rule]", " ", "None"}]}], "}"}], ",", " ", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"xoff\[Theta]13", ",", " ", "5."}], "}"}], ",", " ", 
     RowBox[{"ControlType", " ", "\[Rule]", " ", "None"}]}], "}"}], ",", " ", 
   "\n", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"yoff\[Theta]13", ",", " ", "0"}], "}"}], ",", " ", 
     RowBox[{"ControlType", " ", "\[Rule]", " ", "None"}]}], "}"}], ",", " ", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"laststartpos\[Theta]13", ",", " ", 
       RowBox[{"{", 
        RowBox[{"50", ",", " ", "0"}], "}"}]}], "}"}], ",", " ", "\n", "  ", 
     RowBox[{"ControlType", " ", "\[Rule]", " ", "None"}]}], "}"}], ",", " ", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"lastlocpos\[Theta]13", ",", " ", 
       RowBox[{"{", 
        RowBox[{"55.", ",", " ", "0"}], "}"}]}], "}"}], ",", " ", "\n", "  ", 
     
     RowBox[{"ControlType", " ", "\[Rule]", " ", "None"}]}], "}"}], ",", " ", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"last\[Theta]13", ",", " ", "0"}], "}"}], ",", " ", 
     RowBox[{"ControlType", " ", "\[Rule]", " ", "None"}]}], "}"}], ",", " ", 
   "\n", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x\[Theta]23", ",", " ", "105."}], "}"}], ",", " ", 
     RowBox[{"ControlType", " ", "\[Rule]", " ", "None"}]}], "}"}], ",", " ", 
   "\n", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"y\[Theta]23", ",", " ", "0"}], "}"}], ",", " ", 
     RowBox[{"ControlType", " ", "\[Rule]", " ", "None"}]}], "}"}], ",", " ", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"radius\[Theta]23", ",", " ", "5."}], "}"}], ",", " ", "\n", 
     "  ", 
     RowBox[{"ControlType", " ", "\[Rule]", " ", "None"}]}], "}"}], ",", " ", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"xoff\[Theta]23", ",", " ", "5."}], "}"}], ",", " ", 
     RowBox[{"ControlType", " ", "\[Rule]", " ", "None"}]}], "}"}], ",", " ", 
   "\n", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"yoff\[Theta]23", ",", " ", "0"}], "}"}], ",", " ", 
     RowBox[{"ControlType", " ", "\[Rule]", " ", "None"}]}], "}"}], ",", " ", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"laststartpos\[Theta]23", ",", " ", 
       RowBox[{"{", 
        RowBox[{"100", ",", " ", "0"}], "}"}]}], "}"}], ",", " ", "\n", "  ", 
     
     RowBox[{"ControlType", " ", "\[Rule]", " ", "None"}]}], "}"}], ",", " ", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"lastlocpos\[Theta]23", ",", " ", 
       RowBox[{"{", 
        RowBox[{"105.", ",", " ", "0"}], "}"}]}], "}"}], ",", " ", "\n", "  ", 
     RowBox[{"ControlType", " ", "\[Rule]", " ", "None"}]}], "}"}], ",", " ", 
   
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"last\[Theta]23", ",", " ", "0"}], "}"}], ",", " ", 
     RowBox[{"ControlType", " ", "\[Rule]", " ", "None"}]}], "}"}], ",", " ", 
   "\n", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "staticpolygons13188572008312134018989499", ",", " ", "\n", "   ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"GrayLevel", "[", "0", "]"}], ",", " ", 
         RowBox[{"AbsoluteThickness", "[", "0.5", "]"}], ",", " ", "\n", 
         "    ", 
         RowBox[{"Line", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"200.", ",", " ", "100."}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{"200.", ",", " ", 
                RowBox[{"-", "100."}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{"200.", ",", " ", 
                RowBox[{"-", "100."}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{"200.", ",", " ", "100."}], "}"}], ",", " ", "\n", 
              "       ", 
              RowBox[{"{", 
               RowBox[{"200.", ",", " ", "100."}], "}"}]}], "}"}], ",", " ", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"200.", ",", " ", 
                RowBox[{"-", "100."}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{"0.", ",", " ", 
                RowBox[{"-", "100."}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{"0.", ",", " ", 
                RowBox[{"-", "100."}]}], "}"}], ",", " ", "\n", "       ", 
              RowBox[{"{", 
               RowBox[{"200.", ",", " ", 
                RowBox[{"-", "100."}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{"200.", ",", " ", 
                RowBox[{"-", "100."}]}], "}"}]}], "}"}], ",", " ", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"0.", ",", " ", 
                RowBox[{"-", "100."}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{"0.", ",", " ", "100."}], "}"}], ",", " ", "\n", 
              "       ", 
              RowBox[{"{", 
               RowBox[{"0.", ",", " ", "100."}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{"0.", ",", " ", 
                RowBox[{"-", "100."}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{"0.", ",", " ", 
                RowBox[{"-", "100."}]}], "}"}]}], "}"}], ",", " ", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"0.", ",", " ", "100."}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{"200.", ",", " ", "100."}], "}"}], ",", " ", "\n", 
              "       ", 
              RowBox[{"{", 
               RowBox[{"200.", ",", " ", "100."}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{"0.", ",", " ", "100."}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{"0.", ",", " ", "100."}], "}"}]}], "}"}], ",", " ", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"200.", ",", " ", 
                RowBox[{"-", "100."}]}], "}"}], ",", " ", "\n", "       ", 
              RowBox[{"{", 
               RowBox[{"200.", ",", " ", "100."}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{"0.", ",", " ", "100."}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{"0.", ",", " ", 
                RowBox[{"-", "100."}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{"200.", ",", " ", 
                RowBox[{"-", "100."}]}], "}"}]}], "}"}], ",", " ", "\n", 
            "      ", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"200.", ",", " ", "100."}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{"200.", ",", " ", 
                RowBox[{"-", "100."}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{"0.", ",", " ", 
                RowBox[{"-", "100."}]}], "}"}], ",", " ", 
              RowBox[{"{", 
               RowBox[{"0.", ",", " ", "100."}], "}"}], ",", " ", "\n", 
              "       ", 
              RowBox[{"{", 
               RowBox[{"200.", ",", " ", "100."}], "}"}]}], "}"}]}], "}"}], 
          "]"}]}], "}"}]}], "}"}], ",", " ", 
     RowBox[{"ControlType", " ", "\[Rule]", " ", "None"}]}], "}"}], ",", " ", 
   "\n", " ", 
   RowBox[{"Initialization", " ", ":>", " ", 
    RowBox[{"(", "\n", "   ", 
     RowBox[{
      RowBox[{
      "raytracefunction1188572008312134018995817", " ", "=", " ", "\n", 
       "    ", 
       RowBox[{"Compile", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"r11", ",", " ", "_Real"}], "}"}], ",", " ", 
           RowBox[{"{", 
            RowBox[{"r12", ",", " ", "_Real"}], "}"}], ",", " ", 
           RowBox[{"{", 
            RowBox[{"r13", ",", " ", "_Real"}], "}"}], ",", " ", 
           RowBox[{"{", 
            RowBox[{"r21", ",", " ", "_Real"}], "}"}], ",", " ", "\n", 
           "      ", 
           RowBox[{"{", 
            RowBox[{"r22", ",", " ", "_Real"}], "}"}], ",", " ", 
           RowBox[{"{", 
            RowBox[{"r23", ",", " ", "_Real"}], "}"}], ",", " ", 
           RowBox[{"{", 
            RowBox[{"x13", ",", " ", "_Real"}], "}"}], ",", " ", 
           RowBox[{"{", 
            RowBox[{"x23", ",", " ", "_Real"}], "}"}], ",", " ", "\n", 
           "      ", 
           RowBox[{"{", 
            RowBox[{"\[Theta]13", ",", " ", "_Real"}], "}"}], ",", " ", 
           RowBox[{"{", 
            RowBox[{"\[Theta]23", ",", " ", "_Real"}], "}"}]}], "}"}], ",", 
         " ", "\n", "     ", 
         RowBox[{"Module", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
            "activeregion", ",", " ", "allcreatedamplitudes", ",", " ", 
             "allcreatedrays", ",", " ", "\n", "       ", 
             "allowzeroraylength", ",", " ", "alternateindex", ",", " ", 
             "amplitude", ",", " ", "axismagnitude", ",", " ", "\n", 
             "       ", "axismatrix", ",", " ", "clonedata", ",", " ", 
             "clonegenerationnumber", ",", " ", "cloneinput", ",", " ", "\n", 
             "       ", "clonenumber", ",", " ", "cloneposition", ",", " ", 
             "clonereportedrays", ",", " ", "clonerotation", ",", " ", "\n", 
             "       ", "clonescale", ",", " ", "clonescalevector", ",", " ", 
             "clonesorthistogram", ",", " ", "\n", "       ", 
             "clonetraceinput", ",", " ", "clonetraceoutput", ",", " ", 
             "closestdistances", ",", " ", "\n", "       ", "closestposition",
              ",", " ", "closestpositions", ",", " ", "closestraylength", ",",
              " ", "\n", "       ", "completedray", ",", " ", 
             "componentnumber", ",", " ", "cosangle", ",", " ", "crossmatrix",
              ",", " ", "\n", "       ", "deflecteddummyrayspresent", ",", 
             " ", "deflectedlocalrays", ",", " ", "deflectedrays", ",", " ", 
             "\n", "       ", "deflectedrayspresent", ",", " ", "dummymatrix",
              ",", " ", "dummymatrixlist", ",", " ", "dummyvector", ",", " ", 
             "\n", "       ", "frontid", ",", " ", "generationlimit", ",", 
             " ", "generationnumber", ",", " ", "holeintersections", ",", " ",
              "\n", "       ", "holeQ", ",", " ", "holeQlist", ",", " ", 
             "hor", ",", " ", "index", ",", " ", "index1", ",", " ", "index2",
              ",", " ", "inrays", ",", " ", "intensity", ",", " ", "\n", 
             "       ", "intensityscale", ",", " ", "intersectionnumber", ",",
              " ", "intersections", ",", " ", "\n", "       ", 
             "intersectionslist", ",", " ", "intersectionspresent", ",", " ", 
             "\n", "       ", "localdummyoutrayspresent", ",", " ", 
             "localoutrays", ",", " ", "localoutrayspresent", ",", " ", "\n", 
             "       ", "magnitude", ",", " ", "maxclonegenerationnumber", 
             ",", " ", "maximumposition", ",", " ", "\n", "       ", 
             "minimumraylength", ",", " ", "minresonateraylength", ",", " ", 
             "n12", ",", " ", "newcomponentnumber", ",", " ", "\n", "       ",
              "newdeflectedrays", ",", " ", "newdistance", ",", " ", 
             "newsurfaceid", ",", " ", "newsurfacenumber", ",", " ", "\n", 
             "       ", "nonintersectingrays", ",", " ", 
             "normalizedpolarization", ",", " ", "oldgenerationnumber", ",", 
             " ", "\n", "       ", "opticallength", ",", " ", "originalray", 
             ",", " ", "originalraytilt", ",", " ", "originalrotation", ",", 
             " ", "\n", "       ", "originalsurfnorm", ",", " ", "outrays", 
             ",", " ", "parallelamplitude", ",", " ", "PAxis", ",", " ", "\n",
              "       ", "perpendicularamplitude", ",", " ", "phaseshift", 
             ",", " ", "pol1", ",", " ", "pol2", ",", " ", "pol3", ",", " ", 
             "\n", "       ", "previoustilt", ",", " ", "propagate", ",", " ",
              "propagatedrays", ",", " ", "r1", ",", " ", "r2", ",", " ", 
             "r3", ",", " ", "r4", ",", " ", "r5", ",", " ", "r6", ",", " ", 
             "\n", "       ", "r7", ",", " ", "r8", ",", " ", "r9", ",", " ", 
             "ray1", ",", " ", "ray2", ",", " ", "ray3", ",", " ", "LocRayL", 
             ",", " ", "rayslot", ",", " ", "raysreported", ",", " ", "\n", 
             "       ", "raytiltx", ",", " ", "raytiltz", ",", " ", 
             "reporteddummyrayspresent", ",", " ", "reportedlocalrays", ",", 
             " ", "\n", "       ", "reportedrays", ",", " ", 
             "reportedrayspresent", ",", " ", "resonateintersections", ",", 
             " ", "\n", "       ", "resonatenumber", ",", " ", 
             "resonateraylength", ",", " ", "rex", ",", " ", "rey", ",", " ", 
             "rez", ",", " ", "rotationaxis", ",", " ", "\n", "       ", 
             "rsx", ",", " ", "LocRSx", ",", " ", "rsy", ",", " ", "LocRSy", 
             ",", " ", "rsz", ",", " ", "LocRSz", ",", " ", "RTx", ",", " ", 
             "LocRTy", ",", " ", "LocRTz", ",", " ", "rx", ",", " ", "\n", 
             "       ", "rxhlp", ",", " ", "ry", ",", " ", "ryhlp", ",", " ", 
             "rz", ",", " ", "rzhlp", ",", " ", "LocSCx", ",", " ", "LocSCy", 
             ",", " ", "sid", ",", " ", "sinangle", ",", " ", "sno1", ",", 
             " ", "\n", "       ", "sno2", ",", " ", "sno3", ",", " ", "sno4",
              ",", " ", "surfaceid", ",", " ", "surfacenumber", ",", " ", 
             "\n", "       ", "surfacerotationmatrix", ",", " ", 
             "surfacetranslationvector", ",", " ", "surfnorm", ",", " ", 
             "symr1", ",", " ", "\n", "       ", "symr2", ",", " ", "symr3", 
             ",", " ", "symr4", ",", " ", "symr5", ",", " ", "symr6", ",", 
             " ", "symr7", ",", " ", "symr8", ",", " ", "symr9", ",", " ", 
             "\n", "       ", "tempclonedata", ",", " ", 
             "terminatedeflection", ",", " ", "thresholdintensity", ",", " ", 
             "\n", "       ", "tiltmagnitude", ",", " ", "transmatrix", ",", 
             " ", "LocTV1", ",", " ", "LocTV10", ",", " ", "LocTV2", ",", " ",
              "LocTV3", ",", " ", "\n", "       ", "LocTV4", ",", " ", 
             "LocTV5", ",", " ", "LocTV6", ",", " ", "LocTV7", ",", " ", 
             "LocTV8", ",", " ", "LocTV9", ",", " ", "u", ",", " ", "\n", 
             "       ", "unfilteredintersections", ",", " ", "unit", ",", " ",
              "uu", ",", " ", "ver", ",", " ", "wavelength", ",", " ", 
             "XAxis", ",", " ", "xunit", ",", " ", "\n", "       ", "YAxis", 
             ",", " ", "yunit", ",", " ", "ZAxis", ",", " ", "zunit"}], "}"}],
            ",", " ", 
           RowBox[{
            RowBox[{"activeregion", " ", "=", " ", "1."}], ";", " ", "\n", 
            "       ", 
            RowBox[{"allcreatedamplitudes", " ", "=", " ", 
             RowBox[{"{", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"0.", " ", "+", " ", 
                 RowBox[{"0.", "*", "I"}]}], ",", " ", 
                RowBox[{"0.", " ", "+", " ", 
                 RowBox[{"0.", "*", "I"}]}], ",", " ", 
                RowBox[{"0.", " ", "+", " ", 
                 RowBox[{"0.", "*", "I"}]}]}], "}"}], "}"}]}], ";", " ", "\n",
             "       ", 
            RowBox[{"allcreatedrays", " ", "=", " ", 
             RowBox[{"{", 
              RowBox[{"{", "1.", "}"}], "}"}]}], ";", " ", 
            RowBox[{"allowzeroraylength", " ", "=", " ", "True"}], ";", " ", 
            "\n", "       ", 
            RowBox[{"alternateindex", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"amplitude", " ", "=", " ", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"1.", " ", "+", " ", 
                RowBox[{"0.", "*", "I"}]}], ",", " ", 
               RowBox[{"0.", " ", "+", " ", 
                RowBox[{"0.", "*", "I"}]}], ",", " ", "\n", "         ", 
               RowBox[{"0.", " ", "+", " ", 
                RowBox[{"0.", "*", "I"}]}]}], "}"}]}], ";", " ", 
            RowBox[{"axismagnitude", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"axismatrix", " ", "=", " ", "\n", "        ", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"1.", ",", " ", "0.", ",", " ", "0."}], "}"}], ",", 
               " ", 
               RowBox[{"{", 
                RowBox[{"0.", ",", " ", "1.", ",", " ", "0."}], "}"}], ",", 
               " ", 
               RowBox[{"{", 
                RowBox[{"0.", ",", " ", "0.", ",", " ", "1."}], "}"}]}], 
              "}"}]}], ";", " ", 
            RowBox[{"clonedata", " ", "=", " ", 
             RowBox[{"{", 
              RowBox[{"{", "1.", "}"}], "}"}]}], ";", " ", "\n", "       ", 
            RowBox[{"clonegenerationnumber", " ", "=", " ", "1."}], ";", " ", 
            
            RowBox[{"cloneinput", " ", "=", " ", 
             RowBox[{"{", "1.", "}"}]}], ";", " ", 
            RowBox[{"clonenumber", " ", "=", " ", "1"}], ";", " ", "\n", 
            "       ", 
            RowBox[{"cloneposition", " ", "=", " ", 
             RowBox[{"{", 
              RowBox[{"0.", ",", " ", "0.", ",", " ", "0."}], "}"}]}], ";", 
            " ", 
            RowBox[{"clonereportedrays", " ", "=", " ", 
             RowBox[{"{", 
              RowBox[{"{", "1.", "}"}], "}"}]}], ";", " ", "\n", "       ", 
            RowBox[{"clonerotation", " ", "=", " ", 
             RowBox[{"{", 
              RowBox[{"{", "1.", "}"}], "}"}]}], ";", " ", 
            RowBox[{"clonescale", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"clonescalevector", " ", "=", " ", 
             RowBox[{"{", "1.", "}"}]}], ";", " ", "\n", "       ", 
            RowBox[{"clonesorthistogram", " ", "=", " ", 
             RowBox[{"{", "1", "}"}]}], ";", " ", 
            RowBox[{"clonetraceinput", " ", "=", " ", 
             RowBox[{"{", 
              RowBox[{"{", "1.", "}"}], "}"}]}], ";", " ", "\n", "       ", 
            RowBox[{"clonetraceoutput", " ", "=", " ", 
             RowBox[{"{", 
              RowBox[{"{", "1.", "}"}], "}"}]}], ";", " ", 
            RowBox[{"closestdistances", " ", "=", " ", 
             RowBox[{"{", "1.", "}"}]}], ";", " ", "\n", "       ", 
            RowBox[{"closestposition", " ", "=", " ", "0"}], ";", " ", 
            RowBox[{"closestpositions", " ", "=", " ", 
             RowBox[{"{", "0", "}"}]}], ";", " ", "\n", "       ", 
            RowBox[{"closestraylength", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"completedray", " ", "=", " ", 
             RowBox[{"{", "1.", "}"}]}], ";", " ", "\n", "       ", 
            RowBox[{"componentnumber", " ", "=", " ", 
             RowBox[{"-", "1."}]}], ";", " ", 
            RowBox[{"cosangle", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"crossmatrix", " ", "=", " ", "\n", "        ", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"1.", ",", " ", "0.", ",", " ", "0."}], "}"}], ",", 
               " ", 
               RowBox[{"{", 
                RowBox[{"0.", ",", " ", "1.", ",", " ", "0."}], "}"}], ",", 
               " ", 
               RowBox[{"{", 
                RowBox[{"0.", ",", " ", "0.", ",", " ", "1."}], "}"}]}], 
              "}"}]}], ";", " ", "\n", "       ", 
            RowBox[{"deflecteddummyrayspresent", " ", "=", " ", "False"}], 
            ";", " ", 
            RowBox[{"deflectedlocalrays", " ", "=", " ", 
             RowBox[{"{", 
              RowBox[{"{", "1.", "}"}], "}"}]}], ";", " ", "\n", "       ", 
            RowBox[{"deflectedrays", " ", "=", " ", 
             RowBox[{"{", 
              RowBox[{"{", "1.", "}"}], "}"}]}], ";", " ", 
            RowBox[{"deflectedrayspresent", " ", "=", " ", "False"}], ";", 
            " ", "\n", "       ", 
            RowBox[{"dummymatrix", " ", "=", " ", 
             RowBox[{"{", 
              RowBox[{"{", "1.", "}"}], "}"}]}], ";", " ", 
            RowBox[{"dummymatrixlist", " ", "=", " ", 
             RowBox[{"{", 
              RowBox[{"{", 
               RowBox[{"{", "1.", "}"}], "}"}], "}"}]}], ";", " ", "\n", 
            "       ", 
            RowBox[{"dummyvector", " ", "=", " ", 
             RowBox[{"{", "1.", "}"}]}], ";", " ", 
            RowBox[{"frontid", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"generationlimit", " ", "=", " ", "200."}], ";", " ", 
            "\n", "       ", 
            RowBox[{"generationnumber", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"holeintersections", " ", "=", " ", 
             RowBox[{"{", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], "}"}], 
              "}"}]}], ";", " ", "\n", "       ", 
            RowBox[{"holeQ", " ", "=", " ", "False"}], ";", " ", 
            RowBox[{"holeQlist", " ", "=", " ", 
             RowBox[{"{", "0", "}"}]}], ";", " ", 
            RowBox[{"hor", " ", "=", " ", 
             RowBox[{"1.", " ", "+", " ", 
              RowBox[{"0.", "*", "I"}]}]}], ";", " ", 
            RowBox[{"index", " ", "=", " ", "1."}], ";", " ", "\n", "       ", 
            RowBox[{"index1", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"index2", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"inrays", " ", "=", " ", 
             RowBox[{"{", 
              RowBox[{"{", "1.", "}"}], "}"}]}], ";", " ", 
            RowBox[{"intensity", " ", "=", " ", "1."}], ";", " ", "\n", 
            "       ", 
            RowBox[{"intensityscale", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"intersectionnumber", " ", "=", " ", "1."}], ";", " ", 
            "\n", "       ", 
            RowBox[{"intersections", " ", "=", " ", 
             RowBox[{"{", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], "}"}], 
              "}"}]}], ";", " ", 
            RowBox[{"intersectionslist", " ", "=", " ", "\n", "        ", 
             RowBox[{"{", 
              RowBox[{"{", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], "}"}],
                "}"}], "}"}]}], ";", " ", 
            RowBox[{"intersectionspresent", " ", "=", " ", "False"}], ";", 
            " ", "\n", "       ", 
            RowBox[{"localdummyoutrayspresent", " ", "=", " ", "False"}], ";",
             " ", 
            RowBox[{"localoutrays", " ", "=", " ", 
             RowBox[{"{", 
              RowBox[{"{", "1.", "}"}], "}"}]}], ";", " ", "\n", "       ", 
            RowBox[{"localoutrayspresent", " ", "=", " ", "False"}], ";", " ", 
            RowBox[{"magnitude", " ", "=", " ", "1."}], ";", " ", "\n", 
            "       ", 
            RowBox[{"maxclonegenerationnumber", " ", "=", " ", "1."}], ";", 
            " ", 
            RowBox[{"maximumposition", " ", "=", " ", "1"}], ";", " ", "\n", 
            "       ", 
            RowBox[{"minimumraylength", " ", "=", " ", "0.0001"}], ";", " ", 
            RowBox[{"minresonateraylength", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"n12", " ", "=", " ", "1."}], ";", " ", "\n", "       ", 
            RowBox[{"newcomponentnumber", " ", "=", " ", 
             RowBox[{"-", "1."}]}], ";", " ", 
            RowBox[{"newdeflectedrays", " ", "=", " ", 
             RowBox[{"{", 
              RowBox[{"{", "1.", "}"}], "}"}]}], ";", " ", "\n", "       ", 
            RowBox[{"newdistance", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"newsurfaceid", " ", "=", " ", 
             RowBox[{"-", "1."}]}], ";", " ", 
            RowBox[{"newsurfacenumber", " ", "=", " ", 
             RowBox[{"-", "1."}]}], ";", " ", "\n", "       ", 
            RowBox[{"nonintersectingrays", " ", "=", " ", 
             RowBox[{"{", 
              RowBox[{"{", "1.", "}"}], "}"}]}], ";", " ", 
            RowBox[{"normalizedpolarization", " ", "=", " ", 
             RowBox[{"{", 
              RowBox[{"1.", ",", " ", "1."}], "}"}]}], ";", " ", "\n", 
            "       ", 
            RowBox[{"oldgenerationnumber", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"opticallength", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"originalray", " ", "=", " ", 
             RowBox[{"{", "1.", "}"}]}], ";", " ", "\n", "       ", 
            RowBox[{"originalraytilt", " ", "=", " ", 
             RowBox[{"{", "1.", "}"}]}], ";", " ", 
            RowBox[{"originalrotation", " ", "=", " ", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"1.", ",", " ", "0.", ",", " ", "0."}], "}"}], ",", 
               " ", "\n", "         ", 
               RowBox[{"{", 
                RowBox[{"0.", ",", " ", "1.", ",", " ", "0."}], "}"}], ",", 
               " ", 
               RowBox[{"{", 
                RowBox[{"0.", ",", " ", "0.", ",", " ", "1."}], "}"}]}], 
              "}"}]}], ";", " ", 
            RowBox[{"originalsurfnorm", " ", "=", " ", 
             RowBox[{"{", 
              RowBox[{"{", "1.", "}"}], "}"}]}], ";", " ", "\n", "       ", 
            RowBox[{"outrays", " ", "=", " ", 
             RowBox[{"{", 
              RowBox[{"{", "1.", "}"}], "}"}]}], ";", " ", 
            RowBox[{"parallelamplitude", " ", "=", " ", 
             RowBox[{"1.", " ", "+", " ", 
              RowBox[{"0.", "*", "I"}]}]}], ";", " ", "\n", "       ", 
            RowBox[{"PAxis", " ", "=", " ", 
             RowBox[{"{", 
              RowBox[{"1.", ",", " ", "0.", ",", " ", "0."}], "}"}]}], ";", 
            " ", 
            RowBox[{"perpendicularamplitude", " ", "=", " ", 
             RowBox[{"1.", " ", "+", " ", 
              RowBox[{"0.", "*", "I"}]}]}], ";", " ", "\n", "       ", 
            RowBox[{"phaseshift", " ", "=", " ", "0."}], ";", " ", 
            RowBox[{"pol1", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"pol2", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"pol3", " ", "=", " ", "1."}], ";", " ", "\n", "       ", 
            
            RowBox[{"previoustilt", " ", "=", " ", 
             RowBox[{"{", 
              RowBox[{"1.", ",", " ", "0.", ",", " ", "0."}], "}"}]}], ";", 
            " ", 
            RowBox[{"propagate", " ", "=", " ", "True"}], ";", " ", "\n", 
            "       ", 
            RowBox[{"propagatedrays", " ", "=", " ", 
             RowBox[{"{", 
              RowBox[{"{", "1.", "}"}], "}"}]}], ";", " ", 
            RowBox[{"r1", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"r2", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"r3", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"r4", " ", "=", " ", "1."}], ";", " ", "\n", "       ", 
            RowBox[{"r5", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"r6", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"r7", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"r8", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"r9", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"ray1", " ", "=", " ", "1."}], ";", " ", "\n", "       ", 
            
            RowBox[{"ray2", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"ray3", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"LocRayL", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"rayslot", " ", "=", " ", "1."}], ";", " ", "\n", 
            "       ", 
            RowBox[{"raysreported", " ", "=", " ", "False"}], ";", " ", 
            RowBox[{"raytiltx", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"raytiltz", " ", "=", " ", "1."}], ";", " ", "\n", 
            "       ", 
            RowBox[{"reporteddummyrayspresent", " ", "=", " ", "False"}], ";",
             " ", 
            RowBox[{"reportedlocalrays", " ", "=", " ", 
             RowBox[{"{", 
              RowBox[{"{", "1.", "}"}], "}"}]}], ";", " ", "\n", "       ", 
            RowBox[{"reportedrays", " ", "=", " ", 
             RowBox[{"{", 
              RowBox[{"{", "1.", "}"}], "}"}]}], ";", " ", 
            RowBox[{"reportedrayspresent", " ", "=", " ", "False"}], ";", " ",
             "\n", "       ", 
            RowBox[{"resonateintersections", " ", "=", " ", 
             RowBox[{"{", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], "}"}], 
              "}"}]}], ";", " ", 
            RowBox[{"resonatenumber", " ", "=", " ", "0"}], ";", " ", "\n", 
            "       ", 
            RowBox[{"resonateraylength", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"rex", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"rey", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"rez", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"rsx", " ", "=", " ", "1."}], ";", " ", "\n", "       ", 
            RowBox[{"LocRSx", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"rsy", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"LocRSy", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"rsz", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"LocRSz", " ", "=", " ", "1."}], ";", " ", "\n", 
            "       ", 
            RowBox[{"RTx", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"LocRTy", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"LocRTz", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"rx", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"rxhlp", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"ry", " ", "=", " ", "1."}], ";", " ", "\n", "       ", 
            RowBox[{"ryhlp", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"rz", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"rzhlp", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"LocSCx", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"LocSCy", " ", "=", " ", "1."}], ";", " ", "\n", 
            "       ", 
            RowBox[{"sid", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"sinangle", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"sno1", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"sno2", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"sno3", " ", "=", " ", "1."}], ";", " ", "\n", "       ", 
            
            RowBox[{"sno4", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"surfaceid", " ", "=", " ", 
             RowBox[{"-", "1."}]}], ";", " ", 
            RowBox[{"surfacenumber", " ", "=", " ", 
             RowBox[{"-", "1."}]}], ";", " ", "\n", "       ", 
            RowBox[{"surfacerotationmatrix", " ", "=", " ", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"1.", ",", " ", "0.", ",", " ", "0."}], "}"}], ",", 
               " ", 
               RowBox[{"{", 
                RowBox[{"0.", ",", " ", "1.", ",", " ", "0."}], "}"}], ",", 
               " ", "\n", "         ", 
               RowBox[{"{", 
                RowBox[{"0.", ",", " ", "0.", ",", " ", "1."}], "}"}]}], 
              "}"}]}], ";", " ", 
            RowBox[{"surfacetranslationvector", " ", "=", " ", 
             RowBox[{"{", 
              RowBox[{"0.", ",", " ", "0.", ",", " ", "0."}], "}"}]}], ";", 
            " ", "\n", "       ", 
            RowBox[{"surfnorm", " ", "=", " ", 
             RowBox[{"{", 
              RowBox[{"{", "1.", "}"}], "}"}]}], ";", " ", 
            RowBox[{"symr1", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"symr2", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"symr3", " ", "=", " ", "1."}], ";", " ", "\n", "       ", 
            RowBox[{"symr4", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"symr5", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"symr6", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"symr7", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"symr8", " ", "=", " ", "1."}], ";", " ", "\n", "       ", 
            RowBox[{"symr9", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"tempclonedata", " ", "=", " ", 
             RowBox[{"{", 
              RowBox[{"{", "1.", "}"}], "}"}]}], ";", " ", 
            RowBox[{"terminatedeflection", " ", "=", " ", "False"}], ";", " ",
             "\n", "       ", 
            RowBox[{"thresholdintensity", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"tiltmagnitude", " ", "=", " ", "1."}], ";", " ", "\n", 
            "       ", 
            RowBox[{"transmatrix", " ", "=", " ", 
             RowBox[{"{", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"1.", ",", " ", "0.", ",", " ", "0."}], "}"}], ",", 
                " ", 
                RowBox[{"{", 
                 RowBox[{"0.", ",", " ", "1.", ",", " ", "0."}], "}"}], ",", 
                " ", 
                RowBox[{"{", 
                 RowBox[{"0.", ",", " ", "0.", ",", " ", "1."}], "}"}]}], 
               "}"}], "}"}]}], ";", " ", "\n", "       ", 
            RowBox[{"LocTV1", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"LocTV10", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"LocTV2", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"LocTV3", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"LocTV4", " ", "=", " ", "1."}], ";", " ", "\n", 
            "       ", 
            RowBox[{"LocTV5", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"LocTV6", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"LocTV7", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"LocTV8", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"LocTV9", " ", "=", " ", "1."}], ";", " ", "\n", 
            "       ", 
            RowBox[{"u", " ", "=", " ", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"1.", ",", " ", "0.", ",", " ", "0."}], "}"}], ",", 
               " ", 
               RowBox[{"{", 
                RowBox[{"0.", ",", " ", "1.", ",", " ", "0."}], "}"}], ",", 
               " ", 
               RowBox[{"{", 
                RowBox[{"0.", ",", " ", "0.", ",", " ", "1."}], "}"}]}], 
              "}"}]}], ";", " ", "\n", "       ", 
            RowBox[{"unfilteredintersections", " ", "=", " ", 
             RowBox[{"{", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], "}"}], 
              "}"}]}], ";", " ", "\n", "       ", 
            RowBox[{"unit", " ", "=", " ", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"1.", ",", " ", "0.", ",", " ", "0."}], "}"}], ",", 
               " ", 
               RowBox[{"{", 
                RowBox[{"0.", ",", " ", "1.", ",", " ", "0."}], "}"}], ",", 
               " ", 
               RowBox[{"{", 
                RowBox[{"0.", ",", " ", "0.", ",", " ", "1."}], "}"}]}], 
              "}"}]}], ";", " ", "\n", "       ", 
            RowBox[{"uu", " ", "=", " ", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"1.", ",", " ", "0.", ",", " ", "0."}], "}"}], ",", 
               " ", 
               RowBox[{"{", 
                RowBox[{"0.", ",", " ", "1.", ",", " ", "0."}], "}"}], ",", 
               " ", 
               RowBox[{"{", 
                RowBox[{"0.", ",", " ", "0.", ",", " ", "1."}], "}"}]}], 
              "}"}]}], ";", " ", 
            RowBox[{"ver", " ", "=", " ", 
             RowBox[{"0.", " ", "+", " ", 
              RowBox[{"0.", "*", "I"}]}]}], ";", " ", "\n", "       ", 
            RowBox[{"wavelength", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"XAxis", " ", "=", " ", 
             RowBox[{"{", 
              RowBox[{"1.", ",", " ", "0.", ",", " ", "0."}], "}"}]}], ";", 
            " ", 
            RowBox[{"xunit", " ", "=", " ", "1."}], ";", " ", "\n", "       ", 
            RowBox[{"YAxis", " ", "=", " ", 
             RowBox[{"{", 
              RowBox[{"1.", ",", " ", "0.", ",", " ", "0."}], "}"}]}], ";", 
            " ", 
            RowBox[{"yunit", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"ZAxis", " ", "=", " ", 
             RowBox[{"{", 
              RowBox[{"1.", ",", " ", "0.", ",", " ", "0."}], "}"}]}], ";", 
            " ", "\n", "       ", 
            RowBox[{"zunit", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"propagatedrays", " ", "=", " ", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                "0.", ",", " ", "0.", ",", " ", "0.", ",", " ", "0.", ",", 
                 " ", "0.", ",", " ", "0.", ",", " ", "\n", "          ", 
                 "0.9961946980917455", ",", " ", "0.08715574274765817", ",", 
                 " ", "0.", ",", " ", "\n", "          ", 
                 RowBox[{"-", "0.08715574274765817"}], ",", " ", 
                 "0.9961946980917455", ",", " ", "0.", ",", " ", "0.", ",", 
                 " ", "0.", ",", " ", "1.", ",", " ", "\n", "          ", 
                 "0.532", ",", " ", "100.", ",", " ", "0.16666666666666669", 
                 ",", " ", "0.", ",", " ", "1.00026945145708", ",", " ", "0.",
                  ",", " ", "\n", "          ", "0.", ",", " ", "1.", ",", 
                 " ", "0.", ",", " ", "0.", ",", " ", "0.", ",", " ", "0.", 
                 ",", " ", "92010.", ",", " ", "92010.", ",", " ", "1.", ",", 
                 " ", "6.", ",", " ", "1.", ",", " ", "0.", ",", " ", "1.", 
                 ",", " ", "\n", "          ", "0.", ",", " ", "0.", ",", " ",
                  "0.", ",", " ", "1.", ",", " ", "0."}], "}"}], ",", " ", 
               RowBox[{"{", 
                RowBox[{
                "0.", ",", " ", "0.", ",", " ", "0.", ",", " ", "0.", ",", 
                 " ", "0.", ",", " ", "0.", ",", " ", "\n", "          ", 
                 "0.9986295347545738", ",", " ", "0.052335956242943835", ",", 
                 " ", "0.", ",", " ", "\n", "          ", 
                 RowBox[{"-", "0.052335956242943835"}], ",", " ", 
                 "0.9986295347545738", ",", " ", "0.", ",", " ", "0.", ",", 
                 " ", "0.", ",", " ", "1.", ",", " ", "\n", "          ", 
                 "0.532", ",", " ", "100.", ",", " ", "0.16666666666666669", 
                 ",", " ", "0.", ",", " ", "1.00026945145708", ",", " ", "0.",
                  ",", " ", "\n", "          ", "0.", ",", " ", "1.", ",", 
                 " ", "0.", ",", " ", "0.", ",", " ", "0.", ",", " ", "0.", 
                 ",", " ", "92010.", ",", " ", "92010.", ",", " ", "2.", ",", 
                 " ", "6.", ",", " ", "2.", ",", " ", "0.", ",", " ", "1.", 
                 ",", " ", "\n", "          ", "0.", ",", " ", "0.", ",", " ",
                  "0.", ",", " ", "1.", ",", " ", "0."}], "}"}], ",", " ", 
               RowBox[{"{", 
                RowBox[{
                "0.", ",", " ", "0.", ",", " ", "0.", ",", " ", "0.", ",", 
                 " ", "0.", ",", " ", "0.", ",", " ", "\n", "          ", 
                 "0.9998476951563913", ",", " ", "0.01745240643728351", ",", 
                 " ", "0.", ",", " ", "\n", "          ", 
                 RowBox[{"-", "0.01745240643728351"}], ",", " ", 
                 "0.9998476951563913", ",", " ", "0.", ",", " ", "0.", ",", 
                 " ", "0.", ",", " ", "1.", ",", " ", "\n", "          ", 
                 "0.532", ",", " ", "100.", ",", " ", "0.16666666666666669", 
                 ",", " ", "0.", ",", " ", "1.00026945145708", ",", " ", "0.",
                  ",", " ", "\n", "          ", "0.", ",", " ", "1.", ",", 
                 " ", "0.", ",", " ", "0.", ",", " ", "0.", ",", " ", "0.", 
                 ",", " ", "92010.", ",", " ", "92010.", ",", " ", "3.", ",", 
                 " ", "6.", ",", " ", "3.", ",", " ", "0.", ",", " ", "1.", 
                 ",", " ", "\n", "          ", "0.", ",", " ", "0.", ",", " ",
                  "0.", ",", " ", "1.", ",", " ", "0."}], "}"}], ",", " ", 
               RowBox[{"{", 
                RowBox[{
                "0.", ",", " ", "0.", ",", " ", "0.", ",", " ", "0.", ",", 
                 " ", "0.", ",", " ", "0.", ",", " ", "\n", "          ", 
                 "0.9998476951563913", ",", " ", 
                 RowBox[{"-", "0.01745240643728351"}], ",", " ", "0.", ",", 
                 " ", "\n", "          ", "0.01745240643728351", ",", " ", 
                 "0.9998476951563913", ",", " ", "0.", ",", " ", "0.", ",", 
                 " ", "0.", ",", " ", "1.", ",", " ", "\n", "          ", 
                 "0.532", ",", " ", "100.", ",", " ", "0.16666666666666669", 
                 ",", " ", "0.", ",", " ", "1.00026945145708", ",", " ", "0.",
                  ",", " ", "\n", "          ", "0.", ",", " ", "1.", ",", 
                 " ", "0.", ",", " ", "0.", ",", " ", "0.", ",", " ", "0.", 
                 ",", " ", "92010.", ",", " ", "92010.", ",", " ", "4.", ",", 
                 " ", "6.", ",", " ", "4.", ",", " ", "0.", ",", " ", "1.", 
                 ",", " ", "\n", "          ", "0.", ",", " ", "0.", ",", " ",
                  "0.", ",", " ", "1.", ",", " ", "0."}], "}"}], ",", " ", 
               RowBox[{"{", 
                RowBox[{
                "0.", ",", " ", "0.", ",", " ", "0.", ",", " ", "0.", ",", 
                 " ", "0.", ",", " ", "0.", ",", " ", "\n", "          ", 
                 "0.9986295347545738", ",", " ", 
                 RowBox[{"-", "0.052335956242943835"}], ",", " ", "0.", ",", 
                 " ", "\n", "          ", "0.052335956242943835", ",", " ", 
                 "0.9986295347545738", ",", " ", "0.", ",", " ", "0.", ",", 
                 " ", "0.", ",", " ", "1.", ",", " ", "\n", "          ", 
                 "0.532", ",", " ", "100.", ",", " ", "0.16666666666666669", 
                 ",", " ", "0.", ",", " ", "1.00026945145708", ",", " ", "0.",
                  ",", " ", "\n", "          ", "0.", ",", " ", "1.", ",", 
                 " ", "0.", ",", " ", "0.", ",", " ", "0.", ",", " ", "0.", 
                 ",", " ", "92010.", ",", " ", "92010.", ",", " ", "5.", ",", 
                 " ", "6.", ",", " ", "5.", ",", " ", "0.", ",", " ", "1.", 
                 ",", " ", "\n", "          ", "0.", ",", " ", "0.", ",", " ",
                  "0.", ",", " ", "1.", ",", " ", "0."}], "}"}], ",", " ", 
               RowBox[{"{", 
                RowBox[{
                "0.", ",", " ", "0.", ",", " ", "0.", ",", " ", "0.", ",", 
                 " ", "0.", ",", " ", "0.", ",", " ", "\n", "          ", 
                 "0.9961946980917455", ",", " ", 
                 RowBox[{"-", "0.08715574274765817"}], ",", " ", "0.", ",", 
                 " ", "\n", "          ", "0.08715574274765817", ",", " ", 
                 "0.9961946980917455", ",", " ", "0.", ",", " ", "0.", ",", 
                 " ", "0.", ",", " ", "1.", ",", " ", "\n", "          ", 
                 "0.532", ",", " ", "100.", ",", " ", "0.16666666666666669", 
                 ",", " ", "0.", ",", " ", "1.00026945145708", ",", " ", "0.",
                  ",", " ", "\n", "          ", "0.", ",", " ", "1.", ",", 
                 " ", "0.", ",", " ", "0.", ",", " ", "0.", ",", " ", "0.", 
                 ",", " ", "92010.", ",", " ", "92010.", ",", " ", "6.", ",", 
                 " ", "6.", ",", " ", "6.", ",", " ", "0.", ",", " ", "1.", 
                 ",", " ", "\n", "          ", "0.", ",", " ", "0.", ",", " ",
                  "0.", ",", " ", "1.", ",", " ", "0."}], "}"}]}], "}"}]}], 
            ";", " ", 
            RowBox[{"propagatedrays", " ", "=", " ", "\n", "        ", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "rez", ",", " ", "r1", ",", 
                    " ", "r2", ",", " ", "r3", ",", " ", "r4", ",", " ", "r5",
                     ",", " ", "r6", ",", " ", "r7", ",", " ", "r8", ",", " ",
                     "\n", "             ", "r9", ",", " ", "wavelength", ",",
                     " ", "intensity", ",", " ", "intensityscale", ",", " ", 
                    "ray1", ",", " ", "index", ",", " ", "\n", 
                    "             ", "opticallength", ",", " ", "phaseshift", 
                    ",", " ", "componentnumber", ",", " ", "surfacenumber", 
                    ",", " ", "\n", "             ", "surfaceid", ",", " ", 
                    "ray2", ",", " ", "ray3", ",", " ", "sid", ",", " ", 
                    "frontid", ",", " ", "sno1", ",", " ", "sno2", ",", " ", 
                    "sno3", ",", " ", "\n", "             ", "sno4", ",", " ",
                     "rayslot", ",", " ", "oldgenerationnumber", ",", " ", 
                    "intersectionnumber", ",", " ", "\n", "             ", 
                    "pol1", ",", " ", "pol2", ",", " ", "pol3"}], "}"}], " ", 
                   "=", " ", "#1"}], ";", " ", 
                  RowBox[{"componentnumber", " ", "=", " ", "1."}], ";", " ", 
                  
                  RowBox[{"frontid", " ", "=", " ", "1."}], ";", " ", "\n", 
                  "           ", 
                  RowBox[{"{", 
                   RowBox[{
                   "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "rez", ",", " ", "r1", ",", 
                    " ", "r2", ",", " ", "r3", ",", " ", "r4", ",", " ", "r5",
                     ",", " ", "r6", ",", " ", "r7", ",", " ", "\n", 
                    "            ", "r8", ",", " ", "r9", ",", " ", 
                    "wavelength", ",", " ", "intensity", ",", " ", 
                    "intensityscale", ",", " ", "ray1", ",", " ", "index", 
                    ",", " ", "\n", "            ", "opticallength", ",", " ",
                     "phaseshift", ",", " ", "componentnumber", ",", " ", 
                    "surfacenumber", ",", " ", "\n", "            ", 
                    "surfaceid", ",", " ", "ray2", ",", " ", "ray3", ",", " ",
                     "sid", ",", " ", "frontid", ",", " ", "sno1", ",", " ", 
                    "sno2", ",", " ", "sno3", ",", " ", "sno4", ",", " ", 
                    "\n", "            ", "rayslot", ",", " ", 
                    "generationnumber", ",", " ", "intersectionnumber", ",", 
                    " ", "pol1", ",", " ", "pol2", ",", " ", "\n", 
                    "            ", "pol3"}], "}"}]}], ")"}], " ", "&"}], " ",
                ")"}], " ", "/@", " ", "propagatedrays"}]}], ";", " ", 
            RowBox[{"thresholdintensity", " ", "=", " ", "1."}], ";", " ", 
            "\n", "       ", 
            RowBox[{"generationlimit", " ", "=", " ", "200."}], ";", " ", 
            RowBox[{"reportedrays", " ", "=", " ", "\n", "        ", 
             RowBox[{"{", 
              RowBox[{"{", 
               RowBox[{
               "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", ",", 
                " ", "rey", ",", " ", "rez", ",", " ", "r1", ",", " ", "r2", 
                ",", " ", "r3", ",", " ", "r4", ",", " ", "r5", ",", " ", 
                "r6", ",", " ", "r7", ",", " ", "r8", ",", " ", "\n", 
                "          ", "r9", ",", " ", "wavelength", ",", " ", 
                "intensity", ",", " ", "intensityscale", ",", " ", "ray1", 
                ",", " ", "index", ",", " ", "\n", "          ", 
                "opticallength", ",", " ", "phaseshift", ",", " ", 
                "componentnumber", ",", " ", "surfacenumber", ",", " ", "\n", 
                "          ", "surfaceid", ",", " ", "ray2", ",", " ", "ray3",
                 ",", " ", "sid", ",", " ", "frontid", ",", " ", "sno1", ",", 
                " ", "sno2", ",", " ", "sno3", ",", " ", "sno4", ",", " ", 
                "\n", "          ", "rayslot", ",", " ", "generationnumber", 
                ",", " ", "intersectionnumber", ",", " ", "pol1", ",", " ", 
                "pol2", ",", " ", "\n", "          ", "pol3"}], "}"}], 
              "}"}]}], ";", " ", 
            RowBox[{"generationnumber", " ", "=", " ", "0."}], ";", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"inrays", " ", "=", " ", "propagatedrays"}], ";", " ", 
              "\n", "        ", 
              RowBox[{"outrays", " ", "=", " ", 
               RowBox[{"{", 
                RowBox[{"{", 
                 RowBox[{
                 "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", 
                  " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", 
                  ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", 
                  "1.", ",", " ", "1.", ",", " ", "\n", "           ", "1.", 
                  ",", " ", "1.", ",", " ", "1.", ",", " ", 
                  RowBox[{"-", "9.87654321*^8"}], ",", " ", "1.", ",", " ", 
                  "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "0.", ",", 
                  " ", 
                  RowBox[{"-", "1."}], ",", " ", 
                  RowBox[{"-", "1."}], ",", " ", "\n", "           ", 
                  RowBox[{"-", "1."}], ",", " ", "1.", ",", " ", "1.", ",", 
                  " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", 
                  ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", 
                  "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", 
                  " ", "\n", "           ", "1."}], "}"}], "}"}]}], ";", " ", 
              
              RowBox[{"deflectedrayspresent", " ", "=", " ", "True"}], ";", 
              " ", 
              RowBox[{
              "reportedrayspresent", " ", "=", " ", "\n", "         ", 
               "False"}], ";", " ", 
              RowBox[{"propagate", " ", "=", " ", "True"}], ";", " ", 
              RowBox[{"While", "[", 
               RowBox[{
                RowBox[{
                "deflectedrayspresent", " ", "&&", " ", "\n", "          ", 
                 "propagate"}], ",", " ", 
                RowBox[{
                 RowBox[{"generationnumber", " ", "+=", " ", "1."}], ";", " ",
                  "\n", "          ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                   "deflecteddummyrayspresent", " ", "=", " ", "False"}], ";",
                    " ", 
                   RowBox[{
                   "deflectedrayspresent", " ", "=", " ", "\n", 
                    "            ", "False"}], ";", " ", 
                   RowBox[{"reportedrayspresent", " ", "=", " ", "False"}], 
                   ";", " ", "\n", "           ", 
                   RowBox[{
                   "reporteddummyrayspresent", " ", "=", " ", "True"}], ";", 
                   " ", 
                   RowBox[{
                   "localdummyoutrayspresent", " ", "=", " ", "\n", 
                    "            ", "False"}], ";", " ", 
                   RowBox[{"localoutrayspresent", " ", "=", " ", "False"}], 
                   ";", " ", "\n", "           ", 
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "deflectedlocalrays", ",", " ", "localoutrays", ",", " ", 
                    "reportedlocalrays"}], "}"}], " ", "=", " ", "\n", 
                    "            ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"Flatten", "[", 
                    RowBox[{"#1", ",", " ", "1"}], "]"}], " ", "&"}], " ", 
                    ")"}], " ", "/@", " ", 
                    RowBox[{"Transpose", "[", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "\n", "                   ", 
                    "rez", ",", " ", "r1", ",", " ", "r2", ",", " ", "r3", 
                    ",", " ", "r4", ",", " ", "r5", ",", " ", "r6", ",", " ", 
                    "r7", ",", " ", "r8", ",", " ", "r9", ",", " ", 
                    "wavelength", ",", " ", "\n", "                   ", 
                    "intensity", ",", " ", "intensityscale", ",", " ", "ray1",
                     ",", " ", "index", ",", " ", "\n", "                   ",
                     "opticallength", ",", " ", "phaseshift", ",", " ", 
                    "componentnumber", ",", " ", "\n", "                   ", 
                    "surfacenumber", ",", " ", "surfaceid", ",", " ", "ray2", 
                    ",", " ", "ray3", ",", " ", "sid", ",", " ", "frontid", 
                    ",", " ", "\n", "                   ", "sno1", ",", " ", 
                    "sno2", ",", " ", "sno3", ",", " ", "sno4", ",", " ", 
                    "rayslot", ",", " ", "oldgenerationnumber", ",", " ", 
                    "\n", "                   ", "intersectionnumber", ",", 
                    " ", "pol1", ",", " ", "pol2", ",", " ", "pol3"}], "}"}], 
                    " ", "=", " ", "#1"}], ";", " ", "\n", 
                    "                 ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    "intensity", " ", ">", " ", "thresholdintensity"}], " ", "&&",
                     " ", 
                    RowBox[{
                    "generationnumber", " ", "<", " ", "\n", 
                    "                    ", "generationlimit"}]}], ",", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"resonatenumber", " ", "=", " ", "0"}], ";", " ", 
                    "\n", "                    ", 
                    RowBox[{
                    "resonateraylength", " ", "=", " ", "9.87654321*^8"}], 
                    ";", " ", "\n", "                    ", 
                    RowBox[{"resonateintersections", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}], "}"}]}], ";", " ", 
                    RowBox[{
                    "MapIndexed", "[", "\n", "                     ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"#1", "[", 
                    RowBox[{"[", 
                    RowBox[{"1", ",", "1"}], "]"}], "]"}], " ", ">", " ", 
                    RowBox[{"-", "1."}]}], " ", "&&", " ", 
                    RowBox[{
                    RowBox[{"#1", "[", 
                    RowBox[{"[", 
                    RowBox[{"1", ",", "1"}], "]"}], "]"}], " ", "<", " ", 
                    "\n", "                        ", "resonateraylength"}]}],
                     ",", " ", 
                    RowBox[{
                    RowBox[{"resonateraylength", " ", "=", " ", 
                    RowBox[{"#1", "[", 
                    RowBox[{"[", 
                    RowBox[{"1", ",", "\n", "                        ", "1"}],
                     "]"}], "]"}]}], ";", " ", 
                    RowBox[{"resonateintersections", " ", "=", " ", "#1"}], 
                    ";", " ", "\n", "                        ", 
                    RowBox[{"resonatenumber", " ", "=", " ", 
                    RowBox[{"First", "[", "#2", "]"}]}]}], ",", " ", 
                    "resonatenumber"}], "]"}], " ", "&"}], " ", ",", " ", 
                    "\n", "                     ", 
                    RowBox[{
                    RowBox[{"intersectionslist", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}], "}"}], "}"}]}], ";", " ", 
                    RowBox[{
                    "holeQlist", " ", "=", " ", "\n", 
                    "                       ", 
                    RowBox[{"{", "0", "}"}]}], ";", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "rez", ",", " ", "r1", ",", 
                    " ", "r2", ",", " ", "r3", ",", " ", "\n", 
                    "                        ", "r4", ",", " ", "r5", ",", 
                    " ", "r6", ",", " ", "r7", ",", " ", "r8", ",", " ", "r9",
                     ",", " ", "wavelength", ",", " ", "intensity", ",", " ", 
                    "\n", "                        ", "intensityscale", ",", 
                    " ", "ray1", ",", " ", "index", ",", " ", "opticallength",
                     ",", " ", "\n", "                        ", "phaseshift",
                     ",", " ", "componentnumber", ",", " ", "surfacenumber", 
                    ",", " ", "\n", "                        ", "surfaceid", 
                    ",", " ", "ray2", ",", " ", "ray3", ",", " ", "sid", ",", 
                    " ", "frontid", ",", " ", "sno1", ",", " ", "sno2", ",", 
                    " ", "\n", "                        ", "sno3", ",", " ", 
                    "sno4", ",", " ", "rayslot", ",", " ", 
                    "oldgenerationnumber", ",", " ", "\n", 
                    "                        ", "intersectionnumber", ",", 
                    " ", "pol1", ",", " ", "pol2", ",", " ", "pol3"}], "}"}], 
                    " ", "=", " ", "#1"}], ";", " ", "\n", 
                    "                       ", 
                    RowBox[{"index1", " ", "=", " ", "index"}], ";", " ", 
                    RowBox[{"xunit", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"r1", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", "\n", "                        ", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]13"}], 
                    "]"}], "]"}]}], " ", "+", " ", 
                    RowBox[{"r2", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", "\n", "                        ", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]13"}], 
                    "]"}], "]"}]}]}]}], ";", " ", 
                    RowBox[{
                    "yunit", " ", "=", " ", "\n", "                        ", 
                    
                    RowBox[{
                    RowBox[{"r2", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]13"}], 
                    "]"}], "]"}]}], " ", "-", " ", "\n", 
                    "                        ", 
                    RowBox[{"1.", "*", "r1", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]13"}], 
                    "]"}], "]"}]}]}]}], ";", " ", "\n", 
                    "                       ", 
                    RowBox[{"zunit", " ", "=", " ", 
                    RowBox[{"r3", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]13"}], 
                    "]"}], "^", "2"}], " ", "+", " ", "\n", 
                    "                        ", 
                    RowBox[{
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]13"}], 
                    "]"}], "^", "2"}]}], "]"}]}]}], ";", " ", 
                    RowBox[{
                    "xunit", " ", "=", " ", "\n", "                        ", 
                    
                    RowBox[{"Chop", "[", "xunit", "]"}]}], ";", " ", 
                    RowBox[{"yunit", " ", "=", " ", 
                    RowBox[{"Chop", "[", "yunit", "]"}]}], ";", " ", 
                    RowBox[{
                    "zunit", " ", "=", " ", "\n", "                        ", 
                    
                    RowBox[{"Chop", "[", "zunit", "]"}]}], ";", " ", 
                    RowBox[{"magnitude", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"xunit", "^", "2"}], " ", "+", " ", 
                    RowBox[{"yunit", "^", "2"}], " ", "+", " ", "\n", 
                    "                        ", 
                    RowBox[{"zunit", "^", "2"}]}], ")"}], "^", 
                    RowBox[{"2", "^", 
                    RowBox[{"(", 
                    RowBox[{"-", "1"}], ")"}]}]}]}], ";", " ", 
                    RowBox[{"xunit", " ", "=", " ", 
                    RowBox[{"xunit", "/", "magnitude"}]}], ";", " ", "\n", 
                    "                       ", 
                    RowBox[{"yunit", " ", "=", " ", 
                    RowBox[{"yunit", "/", "magnitude"}]}], ";", " ", 
                    RowBox[{"zunit", " ", "=", " ", 
                    RowBox[{"zunit", "/", "magnitude"}]}], ";", " ", "\n", 
                    "                       ", 
                    RowBox[{"rx", " ", "=", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"rex", " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"Re", "[", "x13", "]"}]}]}], ")"}], "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", "\n", "                        ", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]13"}], 
                    "]"}], "]"}]}], " ", "+", " ", 
                    RowBox[{"rey", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", "\n", "                        ", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]13"}], 
                    "]"}], "]"}]}]}]}], ";", " ", 
                    RowBox[{
                    "ry", " ", "=", " ", "\n", "                        ", 
                    RowBox[{
                    RowBox[{"rey", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]13"}], 
                    "]"}], "]"}]}], " ", "-", " ", "\n", 
                    "                        ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"(", 
                    RowBox[{"rex", " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"Re", "[", "x13", "]"}]}]}], ")"}], "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", "\n", "                        ", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]13"}], 
                    "]"}], "]"}]}]}]}], ";", " ", 
                    RowBox[{"rz", " ", "=", " ", 
                    RowBox[{"rez", "*", "\n", "                        ", 
                    RowBox[{"Re", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]13"}], 
                    "]"}], "^", "2"}], " ", "+", " ", "\n", 
                    "                        ", 
                    RowBox[{
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]13"}], 
                    "]"}], "^", "2"}]}], "]"}]}]}], ";", " ", 
                    RowBox[{
                    "rx", " ", "=", " ", "\n", "                        ", 
                    RowBox[{"Chop", "[", "rx", "]"}]}], ";", " ", 
                    RowBox[{"ry", " ", "=", " ", 
                    RowBox[{"Chop", "[", "ry", "]"}]}], ";", " ", 
                    RowBox[{"rz", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rz", "]"}]}], ";", " ", "\n", 
                    "                       ", 
                    RowBox[{"terminatedeflection", " ", "=", " ", "False"}], 
                    ";", " ", 
                    RowBox[{
                    "intersections", " ", "=", " ", "\n", 
                    "                        ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}], "}"}]}], ";", " ", 
                    RowBox[{"intersections", " ", "=", " ", 
                    RowBox[{"Block", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "TempVar", ",", " ", "\n", "                        ", 
                    "TempVar1", ",", " ", "TempVar2", ",", " ", "TempVar3", 
                    ",", " ", "LocRayL", ",", " ", "LocSCx", ",", " ", "\n", 
                    "                        ", "LocSCy"}], "}"}], ",", " ", 
                    RowBox[{
                    RowBox[{"TempVar1", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"TempVar2", " ", "=", " ", "1."}], ";", " ", "\n",
                     "                        ", 
                    RowBox[{"TempVar3", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"TempVar", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}], "}"}]}], ";", " ", "\n", 
                    "                        ", 
                    RowBox[{"LocRayL", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"LocSCx", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"LocSCy", " ", "=", " ", "1."}], ";", " ", "\n", 
                    "                        ", 
                    RowBox[{"TempVar1", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"rx", "^", "2"}], " ", "+", " ", 
                    RowBox[{"ry", "^", "2"}], " ", "+", " ", 
                    RowBox[{"rz", "^", "2"}]}]}], ";", " ", 
                    RowBox[{
                    "TempVar2", " ", "=", " ", "\n", 
                    "                        ", 
                    RowBox[{
                    RowBox[{"rx", "*", "xunit"}], " ", "+", " ", 
                    RowBox[{"ry", "*", "yunit"}], " ", "+", " ", 
                    RowBox[{"rz", "*", "zunit"}], " ", "-", " ", 
                    RowBox[{"r11", "*", "xunit"}]}]}], ";", " ", "\n", 
                    "                        ", 
                    RowBox[{"TempVar3", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"-", "TempVar1"}], " ", "+", " ", 
                    RowBox[{"TempVar2", "^", "2"}], " ", "+", " ", 
                    RowBox[{"2", "*", "rx", "*", "r11"}]}]}], ";", " ", "\n", 
                    "                        ", 
                    RowBox[{"TempVar3", " ", "=", " ", 
                    RowBox[{"Re", "[", "TempVar3", "]"}]}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"N", "[", 
                    RowBox[{"Chop", "[", "TempVar3", "]"}], "]"}], " ", ">=", 
                    " ", "\n", "                        ", "0."}], ",", " ", 
                    RowBox[{
                    RowBox[{"TempVar3", " ", "=", " ", 
                    RowBox[{"Sqrt", "[", "TempVar3", "]"}]}], ";", " ", 
                    RowBox[{
                    "TempVar", " ", "=", " ", "\n", 
                    "                        ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "LocRayL", ",", " ", "LocSCx", ",", " ", "LocSCy"}], 
                    "}"}], " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "TempVar2"}], " ", "-", " ", "\n", 
                    "                        ", "TempVar3"}], ",", " ", 
                    RowBox[{"ry", " ", "-", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"TempVar2", " ", "+", " ", "TempVar3"}], ")"}], 
                    "*", "yunit"}]}], ",", " ", "\n", 
                    "                        ", 
                    RowBox[{"rz", " ", "-", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"TempVar2", " ", "+", " ", "TempVar3"}], ")"}], 
                    "*", "zunit"}]}]}], "}"}]}], ";", " ", 
                    RowBox[{"If", "[", "\n", "                        ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"N", "[", 
                    RowBox[{"Chop", "[", "LocRayL", "]"}], "]"}], " ", ">=", 
                    " ", "0."}], " ", "&&", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"LocSCx", "^", "2"}], " ", "+", " ", 
                    RowBox[{"LocSCy", "^", "2"}]}], " ", "<=", " ", "\n", 
                    "                        ", "161.29"}], " ", "&&", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", 
                    RowBox[{"ry", " ", "+", " ", 
                    RowBox[{"LocRayL", "*", "yunit"}], " ", "-", " ", 
                    "LocSCx"}], "]"}], " ", "+", " ", "\n", 
                    "                        ", 
                    RowBox[{"Abs", "[", 
                    RowBox[{"rz", " ", "+", " ", 
                    RowBox[{"LocRayL", "*", "zunit"}], " ", "-", " ", 
                    "LocSCy"}], "]"}], " ", "+", " ", 
                    RowBox[{"Abs", "[", 
                    RowBox[{
                    RowBox[{"-", "r11"}], " ", "+", " ", "\n", 
                    "                        ", "rx", " ", "+", " ", 
                    RowBox[{"LocRayL", "*", "xunit"}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"Sqrt", "[", 
                    RowBox[{
                    RowBox[{"r11", "^", "2"}], " ", "-", " ", 
                    RowBox[{"LocSCx", "^", "2"}], " ", "-", " ", "\n", 
                    "                        ", 
                    RowBox[{"LocSCy", "^", "2"}]}], "]"}], "*", 
                    RowBox[{"Sign", "[", "r11", "]"}]}]}], "]"}]}], " ", "<", 
                    " ", "1.*^-7"}]}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "LocRayL", ",", " ", "LocSCx", ",", " ", "\n", 
                    "                        ", "LocSCy"}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}]}], "]"}]}], ",", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"LocRayL", ",", " ", "LocSCx", ",", " ", "\n", 
                    "                        ", "LocSCy"}], "}"}], " ", "=", 
                    " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "TempVar2"}], " ", "+", " ", "TempVar3"}], 
                    ",", " ", 
                    RowBox[{
                    "ry", " ", "+", " ", "\n", "                        ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "TempVar2"}], " ", "+", " ", "TempVar3"}], 
                    ")"}], "*", "yunit"}]}], ",", " ", 
                    RowBox[{"rz", " ", "+", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "TempVar2"}], " ", "+", " ", "\n", 
                    "                        ", "TempVar3"}], ")"}], "*", 
                    "zunit"}]}]}], "}"}]}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"N", "[", 
                    RowBox[{"Chop", "[", "LocRayL", "]"}], "]"}], " ", ">=", 
                    " ", "0."}], " ", "&&", " ", "\n", 
                    "                        ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"LocSCx", "^", "2"}], " ", "+", " ", 
                    RowBox[{"LocSCy", "^", "2"}]}], " ", "<=", " ", 
                    "161.29"}], " ", "&&", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", 
                    RowBox[{
                    "ry", " ", "+", " ", "\n", "                        ", 
                    RowBox[{"LocRayL", "*", "yunit"}], " ", "-", " ", 
                    "LocSCx"}], "]"}], " ", "+", " ", 
                    RowBox[{"Abs", "[", 
                    RowBox[{"rz", " ", "+", " ", 
                    RowBox[{
                    "LocRayL", "*", "\n", "                        ", 
                    "zunit"}], " ", "-", " ", "LocSCy"}], "]"}], " ", "+", 
                    " ", 
                    RowBox[{"Abs", "[", 
                    RowBox[{
                    RowBox[{"-", "r11"}], " ", "+", " ", "rx", " ", "+", " ", 
                    
                    RowBox[{"LocRayL", "*", "\n", "                        ", 
                    "xunit"}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"Sqrt", "[", 
                    RowBox[{
                    RowBox[{"r11", "^", "2"}], " ", "-", " ", 
                    RowBox[{"LocSCx", "^", "2"}], " ", "-", " ", 
                    RowBox[{"LocSCy", "^", "2"}]}], "]"}], "*", 
                    RowBox[{
                    "Sign", "[", "\n", "                        ", "r11", 
                    "]"}]}]}], "]"}]}], " ", "<", " ", "1.*^-7"}]}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "LocRayL", ",", " ", "LocSCx", ",", " ", "LocSCy"}], 
                    "}"}], ",", " ", "\n", "                        ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}]}], "]"}]}]}], "}"}]}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"TempVar", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], " ", "==", " ", 
                    RowBox[{"TempVar", "[", 
                    RowBox[{"[", "\n", "                        ", "2", "]"}],
                     "]"}]}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"TempVar", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "}"}], ",", " ", 
                    "TempVar"}], "]"}]}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "\n", 
                    "                        ", "0."}], "}"}], "}"}]}], 
                    "]"}]}]}], "]"}]}], ";", " ", 
                    RowBox[{"AppendTo", "[", 
                    RowBox[{"intersections", ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}]}], "]"}], ";", " ", "\n", "                       ", 
                    RowBox[{"holeQ", " ", "=", " ", "False"}], ";", " ", 
                    RowBox[{"If", "[", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"!", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Chop", "[", 
                    RowBox[{"surfaceid", " ", "-", " ", "92155."}], "]"}], 
                    " ", "==", " ", "\n", "                        ", "0."}], 
                    " ", "||", " ", 
                    RowBox[{
                    RowBox[{"N", "[", 
                    RowBox[{"Chop", "[", "ray1", "]"}], "]"}], " ", "<", " ", 
                    "0.0001"}]}], ")"}]}], " ", "||", " ", "\n", 
                    "                        ", 
                    RowBox[{"generationnumber", " ", "==", " ", "1."}]}], ",",
                     " ", 
                    RowBox[{
                    "minresonateraylength", " ", "=", " ", "\n", 
                    "                        ", "0."}], ",", " ", 
                    RowBox[{
                    "minresonateraylength", " ", "=", " ", "0.0001"}]}], 
                    "]"}], ";", " ", 
                    RowBox[{"Block", "[", "\n", "                        ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "LocRayL", ",", " ", "LocSCx", ",", " ", "LocSCy"}], 
                    "}"}], ",", " ", 
                    RowBox[{
                    RowBox[{"LocRayL", " ", "=", " ", "1."}], ";", " ", "\n", 
                    "                        ", 
                    RowBox[{"LocSCx", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"LocSCy", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"dummymatrix", " ", "=", " ", 
                    RowBox[{"Union", "[", "\n", "                        ", 
                    RowBox[{"Select", "[", 
                    RowBox[{"intersections", ",", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "LocRayL", ",", " ", "LocSCx", ",", " ", "\n", 
                    "                        ", "LocSCy"}], "}"}], " ", "=", 
                    " ", "#1"}], ";", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "LocRayL", ",", " ", "LocSCx", ",", " ", "LocSCy"}], 
                    "}"}], " ", "==", " ", "\n", "                        ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}]}], " ", "||", " ", 
                    RowBox[{
                    RowBox[{"N", "[", 
                    RowBox[{"Chop", "[", "LocRayL", "]"}], "]"}], " ", ">=", 
                    " ", "\n", "                        ", 
                    "minresonateraylength"}]}]}], ")"}], " ", "&"}]}], " ", 
                    "]"}], "]"}]}], ";", " ", 
                    RowBox[{
                    "intersections", " ", "=", " ", "\n", 
                    "                        ", "dummymatrix"}]}]}], "]"}], 
                    ";", " ", 
                    RowBox[{
                    "unfilteredintersections", " ", "=", " ", "\n", 
                    "                        ", "intersections"}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", "intersections", "]"}], " ", ">", 
                    " ", "1"}], ",", " ", "\n", "                        ", 
                    RowBox[{
                    RowBox[{"dummymatrix", " ", "=", " ", 
                    RowBox[{"Take", "[", 
                    RowBox[{"intersections", ",", " ", 
                    RowBox[{"{", "2", "}"}]}], "]"}]}], ";", " ", "\n", 
                    "                        ", 
                    RowBox[{"intersections", " ", "=", " ", "dummymatrix"}], 
                    ";", " ", "1."}], ",", " ", "1."}], "]"}], ";", " ", 
                    RowBox[{"AppendTo", "[", "\n", "                        ", 
                    RowBox[{"intersectionslist", ",", " ", "intersections"}], 
                    "]"}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    "holeQ", ",", " ", "\n", "                        ", 
                    RowBox[{"AppendTo", "[", 
                    RowBox[{"holeQlist", ",", " ", "1"}], "]"}], ",", " ", 
                    RowBox[{"AppendTo", "[", 
                    RowBox[{"holeQlist", ",", " ", "0"}], "]"}]}], "]"}], ";",
                     " ", "\n", "                       ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "rez", ",", " ", "r1", ",", 
                    " ", "r2", ",", " ", "r3", ",", " ", "r4", ",", " ", "\n",
                     "                        ", "r5", ",", " ", "r6", ",", 
                    " ", "r7", ",", " ", "r8", ",", " ", "r9", ",", " ", 
                    "wavelength", ",", " ", "intensity", ",", " ", "\n", 
                    "                        ", "intensityscale", ",", " ", 
                    "ray1", ",", " ", "index", ",", " ", "opticallength", ",",
                     " ", "\n", "                        ", "phaseshift", ",",
                     " ", "componentnumber", ",", " ", "surfacenumber", ",", 
                    " ", "\n", "                        ", "surfaceid", ",", 
                    " ", "ray2", ",", " ", "ray3", ",", " ", "sid", ",", " ", 
                    "frontid", ",", " ", "sno1", ",", " ", "sno2", ",", " ", 
                    "\n", "                        ", "sno3", ",", " ", 
                    "sno4", ",", " ", "rayslot", ",", " ", 
                    "oldgenerationnumber", ",", " ", "\n", 
                    "                        ", "intersectionnumber", ",", 
                    " ", "pol1", ",", " ", "pol2", ",", " ", "pol3"}], "}"}], 
                    " ", "=", " ", "#1"}], ";", " ", "\n", 
                    "                       ", 
                    RowBox[{"index1", " ", "=", " ", "index"}], ";", " ", 
                    RowBox[{"xunit", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"r1", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", "\n", "                        ", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]13"}], 
                    "]"}], "]"}]}], " ", "+", " ", 
                    RowBox[{"r2", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", "\n", "                        ", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]13"}], 
                    "]"}], "]"}]}]}]}], ";", " ", 
                    RowBox[{
                    "yunit", " ", "=", " ", "\n", "                        ", 
                    
                    RowBox[{
                    RowBox[{"r2", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]13"}], 
                    "]"}], "]"}]}], " ", "-", " ", "\n", 
                    "                        ", 
                    RowBox[{"1.", "*", "r1", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]13"}], 
                    "]"}], "]"}]}]}]}], ";", " ", "\n", 
                    "                       ", 
                    RowBox[{"zunit", " ", "=", " ", 
                    RowBox[{"r3", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]13"}], 
                    "]"}], "^", "2"}], " ", "+", " ", "\n", 
                    "                        ", 
                    RowBox[{
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]13"}], 
                    "]"}], "^", "2"}]}], "]"}]}]}], ";", " ", 
                    RowBox[{
                    "xunit", " ", "=", " ", "\n", "                        ", 
                    
                    RowBox[{"Chop", "[", "xunit", "]"}]}], ";", " ", 
                    RowBox[{"yunit", " ", "=", " ", 
                    RowBox[{"Chop", "[", "yunit", "]"}]}], ";", " ", 
                    RowBox[{
                    "zunit", " ", "=", " ", "\n", "                        ", 
                    
                    RowBox[{"Chop", "[", "zunit", "]"}]}], ";", " ", 
                    RowBox[{"magnitude", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"xunit", "^", "2"}], " ", "+", " ", 
                    RowBox[{"yunit", "^", "2"}], " ", "+", " ", "\n", 
                    "                        ", 
                    RowBox[{"zunit", "^", "2"}]}], ")"}], "^", 
                    RowBox[{"2", "^", 
                    RowBox[{"(", 
                    RowBox[{"-", "1"}], ")"}]}]}]}], ";", " ", 
                    RowBox[{"xunit", " ", "=", " ", 
                    RowBox[{"xunit", "/", "magnitude"}]}], ";", " ", "\n", 
                    "                       ", 
                    RowBox[{"yunit", " ", "=", " ", 
                    RowBox[{"yunit", "/", "magnitude"}]}], ";", " ", 
                    RowBox[{"zunit", " ", "=", " ", 
                    RowBox[{"zunit", "/", "magnitude"}]}], ";", " ", "\n", 
                    "                       ", 
                    RowBox[{"rx", " ", "=", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]13"}], 
                    "]"}], "]"}], "*", 
                    RowBox[{"(", 
                    RowBox[{
                    "rex", " ", "-", " ", "\n", "                        ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"x13", " ", "+", " ", 
                    RowBox[{"2.1", "*", 
                    RowBox[{"Cos", "[", 
                    RowBox[{
                    "0.017453292519943295", "*", "\n", 
                    "                        ", "\[Theta]13"}], "]"}]}]}], 
                    "]"}]}]}], ")"}]}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"rey", " ", "-", " ", 
                    RowBox[{"2.1", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", "\n", "                        ", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]13"}], 
                    "]"}], "]"}]}]}], ")"}], "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", "\n", "                        ", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]13"}], 
                    "]"}], "]"}]}]}]}], ";", " ", 
                    RowBox[{
                    "ry", " ", "=", " ", "\n", "                        ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]13"}], 
                    "]"}], "]"}], "*", 
                    RowBox[{"(", 
                    RowBox[{
                    "rey", " ", "-", " ", "\n", "                        ", 
                    RowBox[{"2.1", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]13"}], 
                    "]"}], "]"}]}]}], ")"}]}], " ", "-", " ", "\n", 
                    "                        ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"(", 
                    RowBox[{"rex", " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"x13", " ", "+", " ", 
                    RowBox[{"2.1", "*", 
                    RowBox[{"Cos", "[", "\n", "                        ", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]13"}], 
                    "]"}]}]}], "]"}]}]}], ")"}], "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", "\n", "                        ", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]13"}], 
                    "]"}], "]"}]}]}]}], ";", " ", 
                    RowBox[{"rz", " ", "=", " ", 
                    RowBox[{"rez", "*", "\n", "                        ", 
                    RowBox[{"Re", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]13"}], 
                    "]"}], "^", "2"}], " ", "+", " ", "\n", 
                    "                        ", 
                    RowBox[{
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]13"}], 
                    "]"}], "^", "2"}]}], "]"}]}]}], ";", " ", 
                    RowBox[{
                    "rx", " ", "=", " ", "\n", "                        ", 
                    RowBox[{"Chop", "[", "rx", "]"}]}], ";", " ", 
                    RowBox[{"ry", " ", "=", " ", 
                    RowBox[{"Chop", "[", "ry", "]"}]}], ";", " ", 
                    RowBox[{"rz", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rz", "]"}]}], ";", " ", "\n", 
                    "                       ", 
                    RowBox[{"terminatedeflection", " ", "=", " ", "False"}], 
                    ";", " ", 
                    RowBox[{
                    "intersections", " ", "=", " ", "\n", 
                    "                        ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}], "}"}]}], ";", " ", 
                    RowBox[{"intersections", " ", "=", " ", 
                    RowBox[{"Block", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "TempVar", ",", " ", "\n", "                        ", 
                    "TempVar1", ",", " ", "TempVar2", ",", " ", "TempVar3", 
                    ",", " ", "LocRayL", ",", " ", "LocSCx", ",", " ", "\n", 
                    "                        ", "LocSCy"}], "}"}], ",", " ", 
                    RowBox[{
                    RowBox[{"TempVar1", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"TempVar2", " ", "=", " ", "1."}], ";", " ", "\n",
                     "                        ", 
                    RowBox[{"TempVar3", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"TempVar", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}], "}"}]}], ";", " ", "\n", 
                    "                        ", 
                    RowBox[{"LocRayL", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"LocSCx", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"LocSCy", " ", "=", " ", "1."}], ";", " ", "\n", 
                    "                        ", 
                    RowBox[{"TempVar1", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"rx", "^", "2"}], " ", "+", " ", 
                    RowBox[{"ry", "^", "2"}], " ", "+", " ", 
                    RowBox[{"rz", "^", "2"}]}]}], ";", " ", 
                    RowBox[{
                    "TempVar2", " ", "=", " ", "\n", 
                    "                        ", 
                    RowBox[{
                    RowBox[{"rx", "*", "xunit"}], " ", "+", " ", 
                    RowBox[{"ry", "*", "yunit"}], " ", "+", " ", 
                    RowBox[{"rz", "*", "zunit"}], " ", "-", " ", 
                    RowBox[{"r12", "*", "xunit"}]}]}], ";", " ", "\n", 
                    "                        ", 
                    RowBox[{"TempVar3", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"-", "TempVar1"}], " ", "+", " ", 
                    RowBox[{"TempVar2", "^", "2"}], " ", "+", " ", 
                    RowBox[{"2", "*", "rx", "*", "r12"}]}]}], ";", " ", "\n", 
                    "                        ", 
                    RowBox[{"TempVar3", " ", "=", " ", 
                    RowBox[{"Re", "[", "TempVar3", "]"}]}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"N", "[", 
                    RowBox[{"Chop", "[", "TempVar3", "]"}], "]"}], " ", ">=", 
                    " ", "\n", "                        ", "0."}], ",", " ", 
                    RowBox[{
                    RowBox[{"TempVar3", " ", "=", " ", 
                    RowBox[{"Sqrt", "[", "TempVar3", "]"}]}], ";", " ", 
                    RowBox[{
                    "TempVar", " ", "=", " ", "\n", 
                    "                        ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "LocRayL", ",", " ", "LocSCx", ",", " ", "LocSCy"}], 
                    "}"}], " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "TempVar2"}], " ", "-", " ", "\n", 
                    "                        ", "TempVar3"}], ",", " ", 
                    RowBox[{"ry", " ", "-", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"TempVar2", " ", "+", " ", "TempVar3"}], ")"}], 
                    "*", "yunit"}]}], ",", " ", "\n", 
                    "                        ", 
                    RowBox[{"rz", " ", "-", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"TempVar2", " ", "+", " ", "TempVar3"}], ")"}], 
                    "*", "zunit"}]}]}], "}"}]}], ";", " ", 
                    RowBox[{"If", "[", "\n", "                        ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"N", "[", 
                    RowBox[{"Chop", "[", "LocRayL", "]"}], "]"}], " ", ">=", 
                    " ", "0."}], " ", "&&", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"LocSCx", "^", "2"}], " ", "+", " ", 
                    RowBox[{"LocSCy", "^", "2"}]}], " ", "<=", " ", "\n", 
                    "                        ", "161.29"}], " ", "&&", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", 
                    RowBox[{"ry", " ", "+", " ", 
                    RowBox[{"LocRayL", "*", "yunit"}], " ", "-", " ", 
                    "LocSCx"}], "]"}], " ", "+", " ", "\n", 
                    "                        ", 
                    RowBox[{"Abs", "[", 
                    RowBox[{"rz", " ", "+", " ", 
                    RowBox[{"LocRayL", "*", "zunit"}], " ", "-", " ", 
                    "LocSCy"}], "]"}], " ", "+", " ", 
                    RowBox[{"Abs", "[", 
                    RowBox[{
                    RowBox[{"-", "r12"}], " ", "+", " ", "\n", 
                    "                        ", "rx", " ", "+", " ", 
                    RowBox[{"LocRayL", "*", "xunit"}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"Sqrt", "[", 
                    RowBox[{
                    RowBox[{"r12", "^", "2"}], " ", "-", " ", 
                    RowBox[{"LocSCx", "^", "2"}], " ", "-", " ", "\n", 
                    "                        ", 
                    RowBox[{"LocSCy", "^", "2"}]}], "]"}], "*", 
                    RowBox[{"Sign", "[", "r12", "]"}]}]}], "]"}]}], " ", "<", 
                    " ", "1.*^-7"}]}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "LocRayL", ",", " ", "LocSCx", ",", " ", "\n", 
                    "                        ", "LocSCy"}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}]}], "]"}]}], ",", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "LocRayL", ",", " ", "LocSCx", ",", " ", "\n", 
                    "                        ", "LocSCy"}], "}"}], " ", "=", 
                    " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "TempVar2"}], " ", "+", " ", "TempVar3"}], 
                    ",", " ", 
                    RowBox[{
                    "ry", " ", "+", " ", "\n", "                        ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "TempVar2"}], " ", "+", " ", "TempVar3"}], 
                    ")"}], "*", "yunit"}]}], ",", " ", 
                    RowBox[{"rz", " ", "+", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "TempVar2"}], " ", "+", " ", "\n", 
                    "                        ", "TempVar3"}], ")"}], "*", 
                    "zunit"}]}]}], "}"}]}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"N", "[", 
                    RowBox[{"Chop", "[", "LocRayL", "]"}], "]"}], " ", ">=", 
                    " ", "0."}], " ", "&&", " ", "\n", 
                    "                        ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"LocSCx", "^", "2"}], " ", "+", " ", 
                    RowBox[{"LocSCy", "^", "2"}]}], " ", "<=", " ", 
                    "161.29"}], " ", "&&", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", 
                    RowBox[{
                    "ry", " ", "+", " ", "\n", "                        ", 
                    RowBox[{"LocRayL", "*", "yunit"}], " ", "-", " ", 
                    "LocSCx"}], "]"}], " ", "+", " ", 
                    RowBox[{"Abs", "[", 
                    RowBox[{"rz", " ", "+", " ", 
                    RowBox[{
                    "LocRayL", "*", "\n", "                        ", 
                    "zunit"}], " ", "-", " ", "LocSCy"}], "]"}], " ", "+", 
                    " ", 
                    RowBox[{"Abs", "[", 
                    RowBox[{
                    RowBox[{"-", "r12"}], " ", "+", " ", "rx", " ", "+", " ", 
                    
                    RowBox[{"LocRayL", "*", "\n", "                        ", 
                    "xunit"}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"Sqrt", "[", 
                    RowBox[{
                    RowBox[{"r12", "^", "2"}], " ", "-", " ", 
                    RowBox[{"LocSCx", "^", "2"}], " ", "-", " ", 
                    RowBox[{"LocSCy", "^", "2"}]}], "]"}], "*", 
                    RowBox[{
                    "Sign", "[", "\n", "                        ", "r12", 
                    "]"}]}]}], "]"}]}], " ", "<", " ", "1.*^-7"}]}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "LocRayL", ",", " ", "LocSCx", ",", " ", "LocSCy"}], 
                    "}"}], ",", " ", "\n", "                        ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}]}], "]"}]}]}], "}"}]}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"TempVar", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], " ", "==", " ", 
                    RowBox[{"TempVar", "[", 
                    RowBox[{"[", "\n", "                        ", "2", "]"}],
                     "]"}]}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"TempVar", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "}"}], ",", " ", 
                    "TempVar"}], "]"}]}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "\n", 
                    "                        ", "0."}], "}"}], "}"}]}], 
                    "]"}]}]}], "]"}]}], ";", " ", 
                    RowBox[{"AppendTo", "[", 
                    RowBox[{"intersections", ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}]}], "]"}], ";", " ", "\n", "                       ", 
                    RowBox[{"holeQ", " ", "=", " ", "False"}], ";", " ", 
                    RowBox[{"If", "[", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"!", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Chop", "[", 
                    RowBox[{"surfaceid", " ", "-", " ", "92156."}], "]"}], 
                    " ", "==", " ", "\n", "                        ", "0."}], 
                    " ", "||", " ", 
                    RowBox[{
                    RowBox[{"N", "[", 
                    RowBox[{"Chop", "[", "ray1", "]"}], "]"}], " ", "<", " ", 
                    "0.0001"}]}], ")"}]}], " ", "||", " ", "\n", 
                    "                        ", 
                    RowBox[{"generationnumber", " ", "==", " ", "1."}]}], ",",
                     " ", 
                    RowBox[{
                    "minresonateraylength", " ", "=", " ", "\n", 
                    "                        ", "0."}], ",", " ", 
                    RowBox[{
                    "minresonateraylength", " ", "=", " ", "0.0001"}]}], 
                    "]"}], ";", " ", 
                    RowBox[{"Block", "[", "\n", "                        ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "LocRayL", ",", " ", "LocSCx", ",", " ", "LocSCy"}], 
                    "}"}], ",", " ", 
                    RowBox[{
                    RowBox[{"LocRayL", " ", "=", " ", "1."}], ";", " ", "\n", 
                    "                        ", 
                    RowBox[{"LocSCx", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"LocSCy", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"dummymatrix", " ", "=", " ", 
                    RowBox[{"Union", "[", "\n", "                        ", 
                    RowBox[{"Select", "[", 
                    RowBox[{"intersections", ",", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "LocRayL", ",", " ", "LocSCx", ",", " ", "\n", 
                    "                        ", "LocSCy"}], "}"}], " ", "=", 
                    " ", "#1"}], ";", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "LocRayL", ",", " ", "LocSCx", ",", " ", "LocSCy"}], 
                    "}"}], " ", "==", " ", "\n", "                        ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}]}], " ", "||", " ", 
                    RowBox[{
                    RowBox[{"N", "[", 
                    RowBox[{"Chop", "[", "LocRayL", "]"}], "]"}], " ", ">=", 
                    " ", "\n", "                        ", 
                    "minresonateraylength"}]}]}], ")"}], " ", "&"}]}], " ", 
                    "]"}], "]"}]}], ";", " ", 
                    RowBox[{
                    "intersections", " ", "=", " ", "\n", 
                    "                        ", "dummymatrix"}]}]}], "]"}], 
                    ";", " ", 
                    RowBox[{
                    "unfilteredintersections", " ", "=", " ", "\n", 
                    "                        ", "intersections"}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", "intersections", "]"}], " ", ">", 
                    " ", "1"}], ",", " ", "\n", "                        ", 
                    RowBox[{
                    RowBox[{"dummymatrix", " ", "=", " ", 
                    RowBox[{"Take", "[", 
                    RowBox[{"intersections", ",", " ", 
                    RowBox[{"{", "2", "}"}]}], "]"}]}], ";", " ", "\n", 
                    "                        ", 
                    RowBox[{"intersections", " ", "=", " ", "dummymatrix"}], 
                    ";", " ", "1."}], ",", " ", "1."}], "]"}], ";", " ", 
                    RowBox[{"AppendTo", "[", "\n", "                        ", 
                    RowBox[{"intersectionslist", ",", " ", "intersections"}], 
                    "]"}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    "holeQ", ",", " ", "\n", "                        ", 
                    RowBox[{"AppendTo", "[", 
                    RowBox[{"holeQlist", ",", " ", "1"}], "]"}], ",", " ", 
                    RowBox[{"AppendTo", "[", 
                    RowBox[{"holeQlist", ",", " ", "0"}], "]"}]}], "]"}], ";",
                     " ", "\n", "                       ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "rez", ",", " ", "r1", ",", 
                    " ", "r2", ",", " ", "r3", ",", " ", "r4", ",", " ", "\n",
                     "                        ", "r5", ",", " ", "r6", ",", 
                    " ", "r7", ",", " ", "r8", ",", " ", "r9", ",", " ", 
                    "wavelength", ",", " ", "intensity", ",", " ", "\n", 
                    "                        ", "intensityscale", ",", " ", 
                    "ray1", ",", " ", "index", ",", " ", "opticallength", ",",
                     " ", "\n", "                        ", "phaseshift", ",",
                     " ", "componentnumber", ",", " ", "surfacenumber", ",", 
                    " ", "\n", "                        ", "surfaceid", ",", 
                    " ", "ray2", ",", " ", "ray3", ",", " ", "sid", ",", " ", 
                    "frontid", ",", " ", "sno1", ",", " ", "sno2", ",", " ", 
                    "\n", "                        ", "sno3", ",", " ", 
                    "sno4", ",", " ", "rayslot", ",", " ", 
                    "oldgenerationnumber", ",", " ", "\n", 
                    "                        ", "intersectionnumber", ",", 
                    " ", "pol1", ",", " ", "pol2", ",", " ", "pol3"}], "}"}], 
                    " ", "=", " ", "#1"}], ";", " ", "\n", 
                    "                       ", 
                    RowBox[{"index1", " ", "=", " ", "index"}], ";", " ", 
                    RowBox[{"xunit", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"r1", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", "\n", "                        ", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]13"}], 
                    "]"}], "]"}]}], " ", "+", " ", 
                    RowBox[{"r2", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", "\n", "                        ", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]13"}], 
                    "]"}], "]"}]}]}]}], ";", " ", 
                    RowBox[{
                    "yunit", " ", "=", " ", "\n", "                        ", 
                    
                    RowBox[{
                    RowBox[{"r2", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]13"}], 
                    "]"}], "]"}]}], " ", "-", " ", "\n", 
                    "                        ", 
                    RowBox[{"1.", "*", "r1", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]13"}], 
                    "]"}], "]"}]}]}]}], ";", " ", "\n", 
                    "                       ", 
                    RowBox[{"zunit", " ", "=", " ", 
                    RowBox[{"r3", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]13"}], 
                    "]"}], "^", "2"}], " ", "+", " ", "\n", 
                    "                        ", 
                    RowBox[{
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]13"}], 
                    "]"}], "^", "2"}]}], "]"}]}]}], ";", " ", 
                    RowBox[{
                    "xunit", " ", "=", " ", "\n", "                        ", 
                    
                    RowBox[{"Chop", "[", "xunit", "]"}]}], ";", " ", 
                    RowBox[{"yunit", " ", "=", " ", 
                    RowBox[{"Chop", "[", "yunit", "]"}]}], ";", " ", 
                    RowBox[{
                    "zunit", " ", "=", " ", "\n", "                        ", 
                    
                    RowBox[{"Chop", "[", "zunit", "]"}]}], ";", " ", 
                    RowBox[{"magnitude", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"xunit", "^", "2"}], " ", "+", " ", 
                    RowBox[{"yunit", "^", "2"}], " ", "+", " ", "\n", 
                    "                        ", 
                    RowBox[{"zunit", "^", "2"}]}], ")"}], "^", 
                    RowBox[{"2", "^", 
                    RowBox[{"(", 
                    RowBox[{"-", "1"}], ")"}]}]}]}], ";", " ", 
                    RowBox[{"xunit", " ", "=", " ", 
                    RowBox[{"xunit", "/", "magnitude"}]}], ";", " ", "\n", 
                    "                       ", 
                    RowBox[{"yunit", " ", "=", " ", 
                    RowBox[{"yunit", "/", "magnitude"}]}], ";", " ", 
                    RowBox[{"zunit", " ", "=", " ", 
                    RowBox[{"zunit", "/", "magnitude"}]}], ";", " ", "\n", 
                    "                       ", 
                    RowBox[{"rx", " ", "=", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]13"}], 
                    "]"}], "]"}], "*", 
                    RowBox[{"(", 
                    RowBox[{
                    "rex", " ", "-", " ", "\n", "                        ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"x13", " ", "+", " ", 
                    RowBox[{"9.6", "*", 
                    RowBox[{"Cos", "[", 
                    RowBox[{
                    "0.017453292519943295", "*", "\n", 
                    "                        ", "\[Theta]13"}], "]"}]}]}], 
                    "]"}]}]}], ")"}]}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"rey", " ", "-", " ", 
                    RowBox[{"9.6", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", "\n", "                        ", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]13"}], 
                    "]"}], "]"}]}]}], ")"}], "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", "\n", "                        ", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]13"}], 
                    "]"}], "]"}]}]}]}], ";", " ", 
                    RowBox[{
                    "ry", " ", "=", " ", "\n", "                        ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]13"}], 
                    "]"}], "]"}], "*", 
                    RowBox[{"(", 
                    RowBox[{
                    "rey", " ", "-", " ", "\n", "                        ", 
                    RowBox[{"9.6", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]13"}], 
                    "]"}], "]"}]}]}], ")"}]}], " ", "-", " ", "\n", 
                    "                        ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"(", 
                    RowBox[{"rex", " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"x13", " ", "+", " ", 
                    RowBox[{"9.6", "*", 
                    RowBox[{"Cos", "[", "\n", "                        ", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]13"}], 
                    "]"}]}]}], "]"}]}]}], ")"}], "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", "\n", "                        ", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]13"}], 
                    "]"}], "]"}]}]}]}], ";", " ", 
                    RowBox[{"rz", " ", "=", " ", 
                    RowBox[{"rez", "*", "\n", "                        ", 
                    RowBox[{"Re", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]13"}], 
                    "]"}], "^", "2"}], " ", "+", " ", "\n", 
                    "                        ", 
                    RowBox[{
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]13"}], 
                    "]"}], "^", "2"}]}], "]"}]}]}], ";", " ", 
                    RowBox[{
                    "rx", " ", "=", " ", "\n", "                        ", 
                    RowBox[{"Chop", "[", "rx", "]"}]}], ";", " ", 
                    RowBox[{"ry", " ", "=", " ", 
                    RowBox[{"Chop", "[", "ry", "]"}]}], ";", " ", 
                    RowBox[{"rz", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rz", "]"}]}], ";", " ", "\n", 
                    "                       ", 
                    RowBox[{"terminatedeflection", " ", "=", " ", "False"}], 
                    ";", " ", 
                    RowBox[{
                    "intersections", " ", "=", " ", "\n", 
                    "                        ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}], "}"}]}], ";", " ", 
                    RowBox[{"intersections", " ", "=", " ", 
                    RowBox[{"Block", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "TempVar", ",", " ", "\n", "                        ", 
                    "TempVar1", ",", " ", "TempVar2", ",", " ", "TempVar3", 
                    ",", " ", "LocRayL", ",", " ", "LocSCx", ",", " ", "\n", 
                    "                        ", "LocSCy"}], "}"}], ",", " ", 
                    RowBox[{
                    RowBox[{"TempVar1", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"TempVar2", " ", "=", " ", "1."}], ";", " ", "\n",
                     "                        ", 
                    RowBox[{"TempVar3", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"TempVar", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}], "}"}]}], ";", " ", "\n", 
                    "                        ", 
                    RowBox[{"LocRayL", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"LocSCx", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"LocSCy", " ", "=", " ", "1."}], ";", " ", "\n", 
                    "                        ", 
                    RowBox[{"TempVar1", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"rx", "^", "2"}], " ", "+", " ", 
                    RowBox[{"ry", "^", "2"}], " ", "+", " ", 
                    RowBox[{"rz", "^", "2"}]}]}], ";", " ", 
                    RowBox[{
                    "TempVar2", " ", "=", " ", "\n", 
                    "                        ", 
                    RowBox[{
                    RowBox[{"rx", "*", "xunit"}], " ", "+", " ", 
                    RowBox[{"ry", "*", "yunit"}], " ", "+", " ", 
                    RowBox[{"rz", "*", "zunit"}], " ", "-", " ", 
                    RowBox[{"r13", "*", "xunit"}]}]}], ";", " ", "\n", 
                    "                        ", 
                    RowBox[{"TempVar3", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"-", "TempVar1"}], " ", "+", " ", 
                    RowBox[{"TempVar2", "^", "2"}], " ", "+", " ", 
                    RowBox[{"2", "*", "rx", "*", "r13"}]}]}], ";", " ", "\n", 
                    "                        ", 
                    RowBox[{"TempVar3", " ", "=", " ", 
                    RowBox[{"Re", "[", "TempVar3", "]"}]}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"N", "[", 
                    RowBox[{"Chop", "[", "TempVar3", "]"}], "]"}], " ", ">=", 
                    " ", "\n", "                        ", "0."}], ",", " ", 
                    RowBox[{
                    RowBox[{"TempVar3", " ", "=", " ", 
                    RowBox[{"Sqrt", "[", "TempVar3", "]"}]}], ";", " ", 
                    RowBox[{
                    "TempVar", " ", "=", " ", "\n", 
                    "                        ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "LocRayL", ",", " ", "LocSCx", ",", " ", "LocSCy"}], 
                    "}"}], " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "TempVar2"}], " ", "-", " ", "\n", 
                    "                        ", "TempVar3"}], ",", " ", 
                    RowBox[{"ry", " ", "-", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"TempVar2", " ", "+", " ", "TempVar3"}], ")"}], 
                    "*", "yunit"}]}], ",", " ", "\n", 
                    "                        ", 
                    RowBox[{"rz", " ", "-", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"TempVar2", " ", "+", " ", "TempVar3"}], ")"}], 
                    "*", "zunit"}]}]}], "}"}]}], ";", " ", 
                    RowBox[{"If", "[", "\n", "                        ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"N", "[", 
                    RowBox[{"Chop", "[", "LocRayL", "]"}], "]"}], " ", ">=", 
                    " ", "0."}], " ", "&&", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"LocSCx", "^", "2"}], " ", "+", " ", 
                    RowBox[{"LocSCy", "^", "2"}]}], " ", "<=", " ", "\n", 
                    "                        ", "161.29"}], " ", "&&", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", 
                    RowBox[{"ry", " ", "+", " ", 
                    RowBox[{"LocRayL", "*", "yunit"}], " ", "-", " ", 
                    "LocSCx"}], "]"}], " ", "+", " ", "\n", 
                    "                        ", 
                    RowBox[{"Abs", "[", 
                    RowBox[{"rz", " ", "+", " ", 
                    RowBox[{"LocRayL", "*", "zunit"}], " ", "-", " ", 
                    "LocSCy"}], "]"}], " ", "+", " ", 
                    RowBox[{"Abs", "[", 
                    RowBox[{
                    RowBox[{"-", "r13"}], " ", "+", " ", "\n", 
                    "                        ", "rx", " ", "+", " ", 
                    RowBox[{"LocRayL", "*", "xunit"}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"Sqrt", "[", 
                    RowBox[{
                    RowBox[{"r13", "^", "2"}], " ", "-", " ", 
                    RowBox[{"LocSCx", "^", "2"}], " ", "-", " ", "\n", 
                    "                        ", 
                    RowBox[{"LocSCy", "^", "2"}]}], "]"}], "*", 
                    RowBox[{"Sign", "[", "r13", "]"}]}]}], "]"}]}], " ", "<", 
                    " ", "1.*^-7"}]}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "LocRayL", ",", " ", "LocSCx", ",", " ", "\n", 
                    "                        ", "LocSCy"}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}]}], "]"}]}], ",", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "LocRayL", ",", " ", "LocSCx", ",", " ", "\n", 
                    "                        ", "LocSCy"}], "}"}], " ", "=", 
                    " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "TempVar2"}], " ", "+", " ", "TempVar3"}], 
                    ",", " ", 
                    RowBox[{
                    "ry", " ", "+", " ", "\n", "                        ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "TempVar2"}], " ", "+", " ", "TempVar3"}], 
                    ")"}], "*", "yunit"}]}], ",", " ", 
                    RowBox[{"rz", " ", "+", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "TempVar2"}], " ", "+", " ", "\n", 
                    "                        ", "TempVar3"}], ")"}], "*", 
                    "zunit"}]}]}], "}"}]}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"N", "[", 
                    RowBox[{"Chop", "[", "LocRayL", "]"}], "]"}], " ", ">=", 
                    " ", "0."}], " ", "&&", " ", "\n", 
                    "                        ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"LocSCx", "^", "2"}], " ", "+", " ", 
                    RowBox[{"LocSCy", "^", "2"}]}], " ", "<=", " ", 
                    "161.29"}], " ", "&&", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", 
                    RowBox[{
                    "ry", " ", "+", " ", "\n", "                        ", 
                    RowBox[{"LocRayL", "*", "yunit"}], " ", "-", " ", 
                    "LocSCx"}], "]"}], " ", "+", " ", 
                    RowBox[{"Abs", "[", 
                    RowBox[{"rz", " ", "+", " ", 
                    RowBox[{
                    "LocRayL", "*", "\n", "                        ", 
                    "zunit"}], " ", "-", " ", "LocSCy"}], "]"}], " ", "+", 
                    " ", 
                    RowBox[{"Abs", "[", 
                    RowBox[{
                    RowBox[{"-", "r13"}], " ", "+", " ", "rx", " ", "+", " ", 
                    
                    RowBox[{"LocRayL", "*", "\n", "                        ", 
                    "xunit"}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"Sqrt", "[", 
                    RowBox[{
                    RowBox[{"r13", "^", "2"}], " ", "-", " ", 
                    RowBox[{"LocSCx", "^", "2"}], " ", "-", " ", 
                    RowBox[{"LocSCy", "^", "2"}]}], "]"}], "*", 
                    RowBox[{
                    "Sign", "[", "\n", "                        ", "r13", 
                    "]"}]}]}], "]"}]}], " ", "<", " ", "1.*^-7"}]}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "LocRayL", ",", " ", "LocSCx", ",", " ", "LocSCy"}], 
                    "}"}], ",", " ", "\n", "                        ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}]}], "]"}]}]}], "}"}]}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"TempVar", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], " ", "==", " ", 
                    RowBox[{"TempVar", "[", 
                    RowBox[{"[", "\n", "                        ", "2", "]"}],
                     "]"}]}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"TempVar", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "}"}], ",", " ", 
                    "TempVar"}], "]"}]}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "\n", 
                    "                        ", "0."}], "}"}], "}"}]}], 
                    "]"}]}]}], "]"}]}], ";", " ", 
                    RowBox[{"AppendTo", "[", 
                    RowBox[{"intersections", ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}]}], "]"}], ";", " ", "\n", "                       ", 
                    RowBox[{"holeQ", " ", "=", " ", "False"}], ";", " ", 
                    RowBox[{"If", "[", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"!", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Chop", "[", 
                    RowBox[{"surfaceid", " ", "-", " ", "92157."}], "]"}], 
                    " ", "==", " ", "\n", "                        ", "0."}], 
                    " ", "||", " ", 
                    RowBox[{
                    RowBox[{"N", "[", 
                    RowBox[{"Chop", "[", "ray1", "]"}], "]"}], " ", "<", " ", 
                    "0.0001"}]}], ")"}]}], " ", "||", " ", "\n", 
                    "                        ", 
                    RowBox[{"generationnumber", " ", "==", " ", "1."}]}], ",",
                     " ", 
                    RowBox[{
                    "minresonateraylength", " ", "=", " ", "\n", 
                    "                        ", "0."}], ",", " ", 
                    RowBox[{
                    "minresonateraylength", " ", "=", " ", "0.0001"}]}], 
                    "]"}], ";", " ", 
                    RowBox[{"Block", "[", "\n", "                        ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "LocRayL", ",", " ", "LocSCx", ",", " ", "LocSCy"}], 
                    "}"}], ",", " ", 
                    RowBox[{
                    RowBox[{"LocRayL", " ", "=", " ", "1."}], ";", " ", "\n", 
                    "                        ", 
                    RowBox[{"LocSCx", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"LocSCy", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"dummymatrix", " ", "=", " ", 
                    RowBox[{"Union", "[", "\n", "                        ", 
                    RowBox[{"Select", "[", 
                    RowBox[{"intersections", ",", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "LocRayL", ",", " ", "LocSCx", ",", " ", "\n", 
                    "                        ", "LocSCy"}], "}"}], " ", "=", 
                    " ", "#1"}], ";", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "LocRayL", ",", " ", "LocSCx", ",", " ", "LocSCy"}], 
                    "}"}], " ", "==", " ", "\n", "                        ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}]}], " ", "||", " ", 
                    RowBox[{
                    RowBox[{"N", "[", 
                    RowBox[{"Chop", "[", "LocRayL", "]"}], "]"}], " ", ">=", 
                    " ", "\n", "                        ", 
                    "minresonateraylength"}]}]}], ")"}], " ", "&"}]}], " ", 
                    "]"}], "]"}]}], ";", " ", 
                    RowBox[{
                    "intersections", " ", "=", " ", "\n", 
                    "                        ", "dummymatrix"}]}]}], "]"}], 
                    ";", " ", 
                    RowBox[{
                    "unfilteredintersections", " ", "=", " ", "\n", 
                    "                        ", "intersections"}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", "intersections", "]"}], " ", ">", 
                    " ", "1"}], ",", " ", "\n", "                        ", 
                    RowBox[{
                    RowBox[{"dummymatrix", " ", "=", " ", 
                    RowBox[{"Take", "[", 
                    RowBox[{"intersections", ",", " ", 
                    RowBox[{"{", "2", "}"}]}], "]"}]}], ";", " ", "\n", 
                    "                        ", 
                    RowBox[{"intersections", " ", "=", " ", "dummymatrix"}], 
                    ";", " ", "1."}], ",", " ", "1."}], "]"}], ";", " ", 
                    RowBox[{"AppendTo", "[", "\n", "                        ", 
                    RowBox[{"intersectionslist", ",", " ", "intersections"}], 
                    "]"}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    "holeQ", ",", " ", "\n", "                        ", 
                    RowBox[{"AppendTo", "[", 
                    RowBox[{"holeQlist", ",", " ", "1"}], "]"}], ",", " ", 
                    RowBox[{"AppendTo", "[", 
                    RowBox[{"holeQlist", ",", " ", "0"}], "]"}]}], "]"}], ";",
                     " ", "\n", "                       ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "rez", ",", " ", "r1", ",", 
                    " ", "r2", ",", " ", "r3", ",", " ", "r4", ",", " ", "\n",
                     "                        ", "r5", ",", " ", "r6", ",", 
                    " ", "r7", ",", " ", "r8", ",", " ", "r9", ",", " ", 
                    "wavelength", ",", " ", "intensity", ",", " ", "\n", 
                    "                        ", "intensityscale", ",", " ", 
                    "ray1", ",", " ", "index", ",", " ", "opticallength", ",",
                     " ", "\n", "                        ", "phaseshift", ",",
                     " ", "componentnumber", ",", " ", "surfacenumber", ",", 
                    " ", "\n", "                        ", "surfaceid", ",", 
                    " ", "ray2", ",", " ", "ray3", ",", " ", "sid", ",", " ", 
                    "frontid", ",", " ", "sno1", ",", " ", "sno2", ",", " ", 
                    "\n", "                        ", "sno3", ",", " ", 
                    "sno4", ",", " ", "rayslot", ",", " ", 
                    "oldgenerationnumber", ",", " ", "\n", 
                    "                        ", "intersectionnumber", ",", 
                    " ", "pol1", ",", " ", "pol2", ",", " ", "pol3"}], "}"}], 
                    " ", "=", " ", "#1"}], ";", " ", "\n", 
                    "                       ", 
                    RowBox[{"index1", " ", "=", " ", "index"}], ";", " ", 
                    RowBox[{"xunit", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"r1", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", "\n", "                        ", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]23"}], 
                    "]"}], "]"}]}], " ", "+", " ", 
                    RowBox[{"r2", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", "\n", "                        ", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]23"}], 
                    "]"}], "]"}]}]}]}], ";", " ", 
                    RowBox[{
                    "yunit", " ", "=", " ", "\n", "                        ", 
                    
                    RowBox[{
                    RowBox[{"r2", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]23"}], 
                    "]"}], "]"}]}], " ", "-", " ", "\n", 
                    "                        ", 
                    RowBox[{"1.", "*", "r1", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]23"}], 
                    "]"}], "]"}]}]}]}], ";", " ", "\n", 
                    "                       ", 
                    RowBox[{"zunit", " ", "=", " ", 
                    RowBox[{"r3", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]23"}], 
                    "]"}], "^", "2"}], " ", "+", " ", "\n", 
                    "                        ", 
                    RowBox[{
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]23"}], 
                    "]"}], "^", "2"}]}], "]"}]}]}], ";", " ", 
                    RowBox[{
                    "xunit", " ", "=", " ", "\n", "                        ", 
                    
                    RowBox[{"Chop", "[", "xunit", "]"}]}], ";", " ", 
                    RowBox[{"yunit", " ", "=", " ", 
                    RowBox[{"Chop", "[", "yunit", "]"}]}], ";", " ", 
                    RowBox[{
                    "zunit", " ", "=", " ", "\n", "                        ", 
                    
                    RowBox[{"Chop", "[", "zunit", "]"}]}], ";", " ", 
                    RowBox[{"magnitude", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"xunit", "^", "2"}], " ", "+", " ", 
                    RowBox[{"yunit", "^", "2"}], " ", "+", " ", "\n", 
                    "                        ", 
                    RowBox[{"zunit", "^", "2"}]}], ")"}], "^", 
                    RowBox[{"2", "^", 
                    RowBox[{"(", 
                    RowBox[{"-", "1"}], ")"}]}]}]}], ";", " ", 
                    RowBox[{"xunit", " ", "=", " ", 
                    RowBox[{"xunit", "/", "magnitude"}]}], ";", " ", "\n", 
                    "                       ", 
                    RowBox[{"yunit", " ", "=", " ", 
                    RowBox[{"yunit", "/", "magnitude"}]}], ";", " ", 
                    RowBox[{"zunit", " ", "=", " ", 
                    RowBox[{"zunit", "/", "magnitude"}]}], ";", " ", "\n", 
                    "                       ", 
                    RowBox[{"rx", " ", "=", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"rex", " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"Re", "[", "x23", "]"}]}]}], ")"}], "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", "\n", "                        ", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]23"}], 
                    "]"}], "]"}]}], " ", "+", " ", 
                    RowBox[{"rey", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", "\n", "                        ", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]23"}], 
                    "]"}], "]"}]}]}]}], ";", " ", 
                    RowBox[{
                    "ry", " ", "=", " ", "\n", "                        ", 
                    RowBox[{
                    RowBox[{"rey", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]23"}], 
                    "]"}], "]"}]}], " ", "-", " ", "\n", 
                    "                        ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"(", 
                    RowBox[{"rex", " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"Re", "[", "x23", "]"}]}]}], ")"}], "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", "\n", "                        ", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]23"}], 
                    "]"}], "]"}]}]}]}], ";", " ", 
                    RowBox[{"rz", " ", "=", " ", 
                    RowBox[{"rez", "*", "\n", "                        ", 
                    RowBox[{"Re", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]23"}], 
                    "]"}], "^", "2"}], " ", "+", " ", "\n", 
                    "                        ", 
                    RowBox[{
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]23"}], 
                    "]"}], "^", "2"}]}], "]"}]}]}], ";", " ", 
                    RowBox[{
                    "rx", " ", "=", " ", "\n", "                        ", 
                    RowBox[{"Chop", "[", "rx", "]"}]}], ";", " ", 
                    RowBox[{"ry", " ", "=", " ", 
                    RowBox[{"Chop", "[", "ry", "]"}]}], ";", " ", 
                    RowBox[{"rz", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rz", "]"}]}], ";", " ", "\n", 
                    "                       ", 
                    RowBox[{"terminatedeflection", " ", "=", " ", "False"}], 
                    ";", " ", 
                    RowBox[{
                    "intersections", " ", "=", " ", "\n", 
                    "                        ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}], "}"}]}], ";", " ", 
                    RowBox[{"intersections", " ", "=", " ", 
                    RowBox[{"Block", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "TempVar", ",", " ", "\n", "                        ", 
                    "TempVar1", ",", " ", "TempVar2", ",", " ", "TempVar3", 
                    ",", " ", "LocRayL", ",", " ", "LocSCx", ",", " ", "\n", 
                    "                        ", "LocSCy"}], "}"}], ",", " ", 
                    RowBox[{
                    RowBox[{"TempVar1", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"TempVar2", " ", "=", " ", "1."}], ";", " ", "\n",
                     "                        ", 
                    RowBox[{"TempVar3", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"TempVar", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}], "}"}]}], ";", " ", "\n", 
                    "                        ", 
                    RowBox[{"LocRayL", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"LocSCx", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"LocSCy", " ", "=", " ", "1."}], ";", " ", "\n", 
                    "                        ", 
                    RowBox[{"TempVar1", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"rx", "^", "2"}], " ", "+", " ", 
                    RowBox[{"ry", "^", "2"}], " ", "+", " ", 
                    RowBox[{"rz", "^", "2"}]}]}], ";", " ", 
                    RowBox[{
                    "TempVar2", " ", "=", " ", "\n", 
                    "                        ", 
                    RowBox[{
                    RowBox[{"rx", "*", "xunit"}], " ", "+", " ", 
                    RowBox[{"ry", "*", "yunit"}], " ", "+", " ", 
                    RowBox[{"rz", "*", "zunit"}], " ", "-", " ", 
                    RowBox[{"r21", "*", "xunit"}]}]}], ";", " ", "\n", 
                    "                        ", 
                    RowBox[{"TempVar3", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"-", "TempVar1"}], " ", "+", " ", 
                    RowBox[{"TempVar2", "^", "2"}], " ", "+", " ", 
                    RowBox[{"2", "*", "rx", "*", "r21"}]}]}], ";", " ", "\n", 
                    "                        ", 
                    RowBox[{"TempVar3", " ", "=", " ", 
                    RowBox[{"Re", "[", "TempVar3", "]"}]}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"N", "[", 
                    RowBox[{"Chop", "[", "TempVar3", "]"}], "]"}], " ", ">=", 
                    " ", "\n", "                        ", "0."}], ",", " ", 
                    RowBox[{
                    RowBox[{"TempVar3", " ", "=", " ", 
                    RowBox[{"Sqrt", "[", "TempVar3", "]"}]}], ";", " ", 
                    RowBox[{
                    "TempVar", " ", "=", " ", "\n", 
                    "                        ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "LocRayL", ",", " ", "LocSCx", ",", " ", "LocSCy"}], 
                    "}"}], " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "TempVar2"}], " ", "-", " ", "\n", 
                    "                        ", "TempVar3"}], ",", " ", 
                    RowBox[{"ry", " ", "-", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"TempVar2", " ", "+", " ", "TempVar3"}], ")"}], 
                    "*", "yunit"}]}], ",", " ", "\n", 
                    "                        ", 
                    RowBox[{"rz", " ", "-", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"TempVar2", " ", "+", " ", "TempVar3"}], ")"}], 
                    "*", "zunit"}]}]}], "}"}]}], ";", " ", 
                    RowBox[{"If", "[", "\n", "                        ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"N", "[", 
                    RowBox[{"Chop", "[", "LocRayL", "]"}], "]"}], " ", ">=", 
                    " ", "0."}], " ", "&&", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"LocSCx", "^", "2"}], " ", "+", " ", 
                    RowBox[{"LocSCy", "^", "2"}]}], " ", "<=", " ", "\n", 
                    "                        ", "161.29"}], " ", "&&", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", 
                    RowBox[{"ry", " ", "+", " ", 
                    RowBox[{"LocRayL", "*", "yunit"}], " ", "-", " ", 
                    "LocSCx"}], "]"}], " ", "+", " ", "\n", 
                    "                        ", 
                    RowBox[{"Abs", "[", 
                    RowBox[{"rz", " ", "+", " ", 
                    RowBox[{"LocRayL", "*", "zunit"}], " ", "-", " ", 
                    "LocSCy"}], "]"}], " ", "+", " ", 
                    RowBox[{"Abs", "[", 
                    RowBox[{
                    RowBox[{"-", "r21"}], " ", "+", " ", "\n", 
                    "                        ", "rx", " ", "+", " ", 
                    RowBox[{"LocRayL", "*", "xunit"}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"Sqrt", "[", 
                    RowBox[{
                    RowBox[{"r21", "^", "2"}], " ", "-", " ", 
                    RowBox[{"LocSCx", "^", "2"}], " ", "-", " ", "\n", 
                    "                        ", 
                    RowBox[{"LocSCy", "^", "2"}]}], "]"}], "*", 
                    RowBox[{"Sign", "[", "r21", "]"}]}]}], "]"}]}], " ", "<", 
                    " ", "1.*^-7"}]}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "LocRayL", ",", " ", "LocSCx", ",", " ", "\n", 
                    "                        ", "LocSCy"}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}]}], "]"}]}], ",", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"LocRayL", ",", " ", "LocSCx", ",", " ", "\n", 
                    "                        ", "LocSCy"}], "}"}], " ", "=", 
                    " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "TempVar2"}], " ", "+", " ", "TempVar3"}], 
                    ",", " ", 
                    RowBox[{
                    "ry", " ", "+", " ", "\n", "                        ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "TempVar2"}], " ", "+", " ", "TempVar3"}], 
                    ")"}], "*", "yunit"}]}], ",", " ", 
                    RowBox[{"rz", " ", "+", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "TempVar2"}], " ", "+", " ", "\n", 
                    "                        ", "TempVar3"}], ")"}], "*", 
                    "zunit"}]}]}], "}"}]}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"N", "[", 
                    RowBox[{"Chop", "[", "LocRayL", "]"}], "]"}], " ", ">=", 
                    " ", "0."}], " ", "&&", " ", "\n", 
                    "                        ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"LocSCx", "^", "2"}], " ", "+", " ", 
                    RowBox[{"LocSCy", "^", "2"}]}], " ", "<=", " ", 
                    "161.29"}], " ", "&&", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", 
                    RowBox[{
                    "ry", " ", "+", " ", "\n", "                        ", 
                    RowBox[{"LocRayL", "*", "yunit"}], " ", "-", " ", 
                    "LocSCx"}], "]"}], " ", "+", " ", 
                    RowBox[{"Abs", "[", 
                    RowBox[{"rz", " ", "+", " ", 
                    RowBox[{
                    "LocRayL", "*", "\n", "                        ", 
                    "zunit"}], " ", "-", " ", "LocSCy"}], "]"}], " ", "+", 
                    " ", 
                    RowBox[{"Abs", "[", 
                    RowBox[{
                    RowBox[{"-", "r21"}], " ", "+", " ", "rx", " ", "+", " ", 
                    
                    RowBox[{"LocRayL", "*", "\n", "                        ", 
                    "xunit"}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"Sqrt", "[", 
                    RowBox[{
                    RowBox[{"r21", "^", "2"}], " ", "-", " ", 
                    RowBox[{"LocSCx", "^", "2"}], " ", "-", " ", 
                    RowBox[{"LocSCy", "^", "2"}]}], "]"}], "*", 
                    RowBox[{
                    "Sign", "[", "\n", "                        ", "r21", 
                    "]"}]}]}], "]"}]}], " ", "<", " ", "1.*^-7"}]}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "LocRayL", ",", " ", "LocSCx", ",", " ", "LocSCy"}], 
                    "}"}], ",", " ", "\n", "                        ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}]}], "]"}]}]}], "}"}]}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"TempVar", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], " ", "==", " ", 
                    RowBox[{"TempVar", "[", 
                    RowBox[{"[", "\n", "                        ", "2", "]"}],
                     "]"}]}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"TempVar", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "}"}], ",", " ", 
                    "TempVar"}], "]"}]}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "\n", 
                    "                        ", "0."}], "}"}], "}"}]}], 
                    "]"}]}]}], "]"}]}], ";", " ", 
                    RowBox[{"AppendTo", "[", 
                    RowBox[{"intersections", ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}]}], "]"}], ";", " ", "\n", "                       ", 
                    RowBox[{"holeQ", " ", "=", " ", "False"}], ";", " ", 
                    RowBox[{"If", "[", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"!", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Chop", "[", 
                    RowBox[{"surfaceid", " ", "-", " ", "92310."}], "]"}], 
                    " ", "==", " ", "\n", "                        ", "0."}], 
                    " ", "||", " ", 
                    RowBox[{
                    RowBox[{"N", "[", 
                    RowBox[{"Chop", "[", "ray1", "]"}], "]"}], " ", "<", " ", 
                    "0.0001"}]}], ")"}]}], " ", "||", " ", "\n", 
                    "                        ", 
                    RowBox[{"generationnumber", " ", "==", " ", "1."}]}], ",",
                     " ", 
                    RowBox[{
                    "minresonateraylength", " ", "=", " ", "\n", 
                    "                        ", "0."}], ",", " ", 
                    RowBox[{
                    "minresonateraylength", " ", "=", " ", "0.0001"}]}], 
                    "]"}], ";", " ", 
                    RowBox[{"Block", "[", "\n", "                        ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "LocRayL", ",", " ", "LocSCx", ",", " ", "LocSCy"}], 
                    "}"}], ",", " ", 
                    RowBox[{
                    RowBox[{"LocRayL", " ", "=", " ", "1."}], ";", " ", "\n", 
                    "                        ", 
                    RowBox[{"LocSCx", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"LocSCy", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"dummymatrix", " ", "=", " ", 
                    RowBox[{"Union", "[", "\n", "                        ", 
                    RowBox[{"Select", "[", 
                    RowBox[{"intersections", ",", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "LocRayL", ",", " ", "LocSCx", ",", " ", "\n", 
                    "                        ", "LocSCy"}], "}"}], " ", "=", 
                    " ", "#1"}], ";", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "LocRayL", ",", " ", "LocSCx", ",", " ", "LocSCy"}], 
                    "}"}], " ", "==", " ", "\n", "                        ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}]}], " ", "||", " ", 
                    RowBox[{
                    RowBox[{"N", "[", 
                    RowBox[{"Chop", "[", "LocRayL", "]"}], "]"}], " ", ">=", 
                    " ", "\n", "                        ", 
                    "minresonateraylength"}]}]}], ")"}], " ", "&"}]}], " ", 
                    "]"}], "]"}]}], ";", " ", 
                    RowBox[{
                    "intersections", " ", "=", " ", "\n", 
                    "                        ", "dummymatrix"}]}]}], "]"}], 
                    ";", " ", 
                    RowBox[{
                    "unfilteredintersections", " ", "=", " ", "\n", 
                    "                        ", "intersections"}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", "intersections", "]"}], " ", ">", 
                    " ", "1"}], ",", " ", "\n", "                        ", 
                    RowBox[{
                    RowBox[{"dummymatrix", " ", "=", " ", 
                    RowBox[{"Take", "[", 
                    RowBox[{"intersections", ",", " ", 
                    RowBox[{"{", "2", "}"}]}], "]"}]}], ";", " ", "\n", 
                    "                        ", 
                    RowBox[{"intersections", " ", "=", " ", "dummymatrix"}], 
                    ";", " ", "1."}], ",", " ", "1."}], "]"}], ";", " ", 
                    RowBox[{"AppendTo", "[", "\n", "                        ", 
                    RowBox[{"intersectionslist", ",", " ", "intersections"}], 
                    "]"}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    "holeQ", ",", " ", "\n", "                        ", 
                    RowBox[{"AppendTo", "[", 
                    RowBox[{"holeQlist", ",", " ", "1"}], "]"}], ",", " ", 
                    RowBox[{"AppendTo", "[", 
                    RowBox[{"holeQlist", ",", " ", "0"}], "]"}]}], "]"}], ";",
                     " ", "\n", "                       ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "rez", ",", " ", "r1", ",", 
                    " ", "r2", ",", " ", "r3", ",", " ", "r4", ",", " ", "\n",
                     "                        ", "r5", ",", " ", "r6", ",", 
                    " ", "r7", ",", " ", "r8", ",", " ", "r9", ",", " ", 
                    "wavelength", ",", " ", "intensity", ",", " ", "\n", 
                    "                        ", "intensityscale", ",", " ", 
                    "ray1", ",", " ", "index", ",", " ", "opticallength", ",",
                     " ", "\n", "                        ", "phaseshift", ",",
                     " ", "componentnumber", ",", " ", "surfacenumber", ",", 
                    " ", "\n", "                        ", "surfaceid", ",", 
                    " ", "ray2", ",", " ", "ray3", ",", " ", "sid", ",", " ", 
                    "frontid", ",", " ", "sno1", ",", " ", "sno2", ",", " ", 
                    "\n", "                        ", "sno3", ",", " ", 
                    "sno4", ",", " ", "rayslot", ",", " ", 
                    "oldgenerationnumber", ",", " ", "\n", 
                    "                        ", "intersectionnumber", ",", 
                    " ", "pol1", ",", " ", "pol2", ",", " ", "pol3"}], "}"}], 
                    " ", "=", " ", "#1"}], ";", " ", "\n", 
                    "                       ", 
                    RowBox[{"index1", " ", "=", " ", "index"}], ";", " ", 
                    RowBox[{"xunit", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"r1", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", "\n", "                        ", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]23"}], 
                    "]"}], "]"}]}], " ", "+", " ", 
                    RowBox[{"r2", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", "\n", "                        ", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]23"}], 
                    "]"}], "]"}]}]}]}], ";", " ", 
                    RowBox[{
                    "yunit", " ", "=", " ", "\n", "                        ", 
                    
                    RowBox[{
                    RowBox[{"r2", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]23"}], 
                    "]"}], "]"}]}], " ", "-", " ", "\n", 
                    "                        ", 
                    RowBox[{"1.", "*", "r1", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]23"}], 
                    "]"}], "]"}]}]}]}], ";", " ", "\n", 
                    "                       ", 
                    RowBox[{"zunit", " ", "=", " ", 
                    RowBox[{"r3", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]23"}], 
                    "]"}], "^", "2"}], " ", "+", " ", "\n", 
                    "                        ", 
                    RowBox[{
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]23"}], 
                    "]"}], "^", "2"}]}], "]"}]}]}], ";", " ", 
                    RowBox[{
                    "xunit", " ", "=", " ", "\n", "                        ", 
                    
                    RowBox[{"Chop", "[", "xunit", "]"}]}], ";", " ", 
                    RowBox[{"yunit", " ", "=", " ", 
                    RowBox[{"Chop", "[", "yunit", "]"}]}], ";", " ", 
                    RowBox[{
                    "zunit", " ", "=", " ", "\n", "                        ", 
                    
                    RowBox[{"Chop", "[", "zunit", "]"}]}], ";", " ", 
                    RowBox[{"magnitude", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"xunit", "^", "2"}], " ", "+", " ", 
                    RowBox[{"yunit", "^", "2"}], " ", "+", " ", "\n", 
                    "                        ", 
                    RowBox[{"zunit", "^", "2"}]}], ")"}], "^", 
                    RowBox[{"2", "^", 
                    RowBox[{"(", 
                    RowBox[{"-", "1"}], ")"}]}]}]}], ";", " ", 
                    RowBox[{"xunit", " ", "=", " ", 
                    RowBox[{"xunit", "/", "magnitude"}]}], ";", " ", "\n", 
                    "                       ", 
                    RowBox[{"yunit", " ", "=", " ", 
                    RowBox[{"yunit", "/", "magnitude"}]}], ";", " ", 
                    RowBox[{"zunit", " ", "=", " ", 
                    RowBox[{"zunit", "/", "magnitude"}]}], ";", " ", "\n", 
                    "                       ", 
                    RowBox[{"rx", " ", "=", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]23"}], 
                    "]"}], "]"}], "*", 
                    RowBox[{"(", 
                    RowBox[{
                    "rex", " ", "-", " ", "\n", "                        ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"x23", " ", "+", " ", 
                    RowBox[{"7.5", "*", 
                    RowBox[{"Cos", "[", 
                    RowBox[{
                    "0.017453292519943295", "*", "\n", 
                    "                        ", "\[Theta]23"}], "]"}]}]}], 
                    "]"}]}]}], ")"}]}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"rey", " ", "-", " ", 
                    RowBox[{"7.5", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", "\n", "                        ", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]23"}], 
                    "]"}], "]"}]}]}], ")"}], "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", "\n", "                        ", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]23"}], 
                    "]"}], "]"}]}]}]}], ";", " ", 
                    RowBox[{
                    "ry", " ", "=", " ", "\n", "                        ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]23"}], 
                    "]"}], "]"}], "*", 
                    RowBox[{"(", 
                    RowBox[{
                    "rey", " ", "-", " ", "\n", "                        ", 
                    RowBox[{"7.5", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]23"}], 
                    "]"}], "]"}]}]}], ")"}]}], " ", "-", " ", "\n", 
                    "                        ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"(", 
                    RowBox[{"rex", " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"x23", " ", "+", " ", 
                    RowBox[{"7.5", "*", 
                    RowBox[{"Cos", "[", "\n", "                        ", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]23"}], 
                    "]"}]}]}], "]"}]}]}], ")"}], "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", "\n", "                        ", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]23"}], 
                    "]"}], "]"}]}]}]}], ";", " ", 
                    RowBox[{"rz", " ", "=", " ", 
                    RowBox[{"rez", "*", "\n", "                        ", 
                    RowBox[{"Re", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]23"}], 
                    "]"}], "^", "2"}], " ", "+", " ", "\n", 
                    "                        ", 
                    RowBox[{
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]23"}], 
                    "]"}], "^", "2"}]}], "]"}]}]}], ";", " ", 
                    RowBox[{
                    "rx", " ", "=", " ", "\n", "                        ", 
                    RowBox[{"Chop", "[", "rx", "]"}]}], ";", " ", 
                    RowBox[{"ry", " ", "=", " ", 
                    RowBox[{"Chop", "[", "ry", "]"}]}], ";", " ", 
                    RowBox[{"rz", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rz", "]"}]}], ";", " ", "\n", 
                    "                       ", 
                    RowBox[{"terminatedeflection", " ", "=", " ", "False"}], 
                    ";", " ", 
                    RowBox[{
                    "intersections", " ", "=", " ", "\n", 
                    "                        ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}], "}"}]}], ";", " ", 
                    RowBox[{"intersections", " ", "=", " ", 
                    RowBox[{"Block", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "TempVar", ",", " ", "\n", "                        ", 
                    "TempVar1", ",", " ", "TempVar2", ",", " ", "TempVar3", 
                    ",", " ", "LocRayL", ",", " ", "LocSCx", ",", " ", "\n", 
                    "                        ", "LocSCy"}], "}"}], ",", " ", 
                    RowBox[{
                    RowBox[{"TempVar1", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"TempVar2", " ", "=", " ", "1."}], ";", " ", "\n",
                     "                        ", 
                    RowBox[{"TempVar3", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"TempVar", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}], "}"}]}], ";", " ", "\n", 
                    "                        ", 
                    RowBox[{"LocRayL", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"LocSCx", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"LocSCy", " ", "=", " ", "1."}], ";", " ", "\n", 
                    "                        ", 
                    RowBox[{"TempVar1", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"rx", "^", "2"}], " ", "+", " ", 
                    RowBox[{"ry", "^", "2"}], " ", "+", " ", 
                    RowBox[{"rz", "^", "2"}]}]}], ";", " ", 
                    RowBox[{
                    "TempVar2", " ", "=", " ", "\n", 
                    "                        ", 
                    RowBox[{
                    RowBox[{"rx", "*", "xunit"}], " ", "+", " ", 
                    RowBox[{"ry", "*", "yunit"}], " ", "+", " ", 
                    RowBox[{"rz", "*", "zunit"}], " ", "-", " ", 
                    RowBox[{"r22", "*", "xunit"}]}]}], ";", " ", "\n", 
                    "                        ", 
                    RowBox[{"TempVar3", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"-", "TempVar1"}], " ", "+", " ", 
                    RowBox[{"TempVar2", "^", "2"}], " ", "+", " ", 
                    RowBox[{"2", "*", "rx", "*", "r22"}]}]}], ";", " ", "\n", 
                    "                        ", 
                    RowBox[{"TempVar3", " ", "=", " ", 
                    RowBox[{"Re", "[", "TempVar3", "]"}]}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"N", "[", 
                    RowBox[{"Chop", "[", "TempVar3", "]"}], "]"}], " ", ">=", 
                    " ", "\n", "                        ", "0."}], ",", " ", 
                    RowBox[{
                    RowBox[{"TempVar3", " ", "=", " ", 
                    RowBox[{"Sqrt", "[", "TempVar3", "]"}]}], ";", " ", 
                    RowBox[{
                    "TempVar", " ", "=", " ", "\n", 
                    "                        ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "LocRayL", ",", " ", "LocSCx", ",", " ", "LocSCy"}], 
                    "}"}], " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "TempVar2"}], " ", "-", " ", "\n", 
                    "                        ", "TempVar3"}], ",", " ", 
                    RowBox[{"ry", " ", "-", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"TempVar2", " ", "+", " ", "TempVar3"}], ")"}], 
                    "*", "yunit"}]}], ",", " ", "\n", 
                    "                        ", 
                    RowBox[{"rz", " ", "-", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"TempVar2", " ", "+", " ", "TempVar3"}], ")"}], 
                    "*", "zunit"}]}]}], "}"}]}], ";", " ", 
                    RowBox[{"If", "[", "\n", "                        ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"N", "[", 
                    RowBox[{"Chop", "[", "LocRayL", "]"}], "]"}], " ", ">=", 
                    " ", "0."}], " ", "&&", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"LocSCx", "^", "2"}], " ", "+", " ", 
                    RowBox[{"LocSCy", "^", "2"}]}], " ", "<=", " ", "\n", 
                    "                        ", "161.29"}], " ", "&&", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", 
                    RowBox[{"ry", " ", "+", " ", 
                    RowBox[{"LocRayL", "*", "yunit"}], " ", "-", " ", 
                    "LocSCx"}], "]"}], " ", "+", " ", "\n", 
                    "                        ", 
                    RowBox[{"Abs", "[", 
                    RowBox[{"rz", " ", "+", " ", 
                    RowBox[{"LocRayL", "*", "zunit"}], " ", "-", " ", 
                    "LocSCy"}], "]"}], " ", "+", " ", 
                    RowBox[{"Abs", "[", 
                    RowBox[{
                    RowBox[{"-", "r22"}], " ", "+", " ", "\n", 
                    "                        ", "rx", " ", "+", " ", 
                    RowBox[{"LocRayL", "*", "xunit"}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"Sqrt", "[", 
                    RowBox[{
                    RowBox[{"r22", "^", "2"}], " ", "-", " ", 
                    RowBox[{"LocSCx", "^", "2"}], " ", "-", " ", "\n", 
                    "                        ", 
                    RowBox[{"LocSCy", "^", "2"}]}], "]"}], "*", 
                    RowBox[{"Sign", "[", "r22", "]"}]}]}], "]"}]}], " ", "<", 
                    " ", "1.*^-7"}]}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "LocRayL", ",", " ", "LocSCx", ",", " ", "\n", 
                    "                        ", "LocSCy"}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}]}], "]"}]}], ",", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "LocRayL", ",", " ", "LocSCx", ",", " ", "\n", 
                    "                        ", "LocSCy"}], "}"}], " ", "=", 
                    " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "TempVar2"}], " ", "+", " ", "TempVar3"}], 
                    ",", " ", 
                    RowBox[{
                    "ry", " ", "+", " ", "\n", "                        ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "TempVar2"}], " ", "+", " ", "TempVar3"}], 
                    ")"}], "*", "yunit"}]}], ",", " ", 
                    RowBox[{"rz", " ", "+", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "TempVar2"}], " ", "+", " ", "\n", 
                    "                        ", "TempVar3"}], ")"}], "*", 
                    "zunit"}]}]}], "}"}]}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"N", "[", 
                    RowBox[{"Chop", "[", "LocRayL", "]"}], "]"}], " ", ">=", 
                    " ", "0."}], " ", "&&", " ", "\n", 
                    "                        ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"LocSCx", "^", "2"}], " ", "+", " ", 
                    RowBox[{"LocSCy", "^", "2"}]}], " ", "<=", " ", 
                    "161.29"}], " ", "&&", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", 
                    RowBox[{
                    "ry", " ", "+", " ", "\n", "                        ", 
                    RowBox[{"LocRayL", "*", "yunit"}], " ", "-", " ", 
                    "LocSCx"}], "]"}], " ", "+", " ", 
                    RowBox[{"Abs", "[", 
                    RowBox[{"rz", " ", "+", " ", 
                    RowBox[{
                    "LocRayL", "*", "\n", "                        ", 
                    "zunit"}], " ", "-", " ", "LocSCy"}], "]"}], " ", "+", 
                    " ", 
                    RowBox[{"Abs", "[", 
                    RowBox[{
                    RowBox[{"-", "r22"}], " ", "+", " ", "rx", " ", "+", " ", 
                    
                    RowBox[{"LocRayL", "*", "\n", "                        ", 
                    "xunit"}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"Sqrt", "[", 
                    RowBox[{
                    RowBox[{"r22", "^", "2"}], " ", "-", " ", 
                    RowBox[{"LocSCx", "^", "2"}], " ", "-", " ", 
                    RowBox[{"LocSCy", "^", "2"}]}], "]"}], "*", 
                    RowBox[{
                    "Sign", "[", "\n", "                        ", "r22", 
                    "]"}]}]}], "]"}]}], " ", "<", " ", "1.*^-7"}]}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "LocRayL", ",", " ", "LocSCx", ",", " ", "LocSCy"}], 
                    "}"}], ",", " ", "\n", "                        ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}]}], "]"}]}]}], "}"}]}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"TempVar", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], " ", "==", " ", 
                    RowBox[{"TempVar", "[", 
                    RowBox[{"[", "\n", "                        ", "2", "]"}],
                     "]"}]}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"TempVar", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "}"}], ",", " ", 
                    "TempVar"}], "]"}]}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "\n", 
                    "                        ", "0."}], "}"}], "}"}]}], 
                    "]"}]}]}], "]"}]}], ";", " ", 
                    RowBox[{"AppendTo", "[", 
                    RowBox[{"intersections", ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}]}], "]"}], ";", " ", "\n", "                       ", 
                    RowBox[{"holeQ", " ", "=", " ", "False"}], ";", " ", 
                    RowBox[{"If", "[", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"!", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Chop", "[", 
                    RowBox[{"surfaceid", " ", "-", " ", "92311."}], "]"}], 
                    " ", "==", " ", "\n", "                        ", "0."}], 
                    " ", "||", " ", 
                    RowBox[{
                    RowBox[{"N", "[", 
                    RowBox[{"Chop", "[", "ray1", "]"}], "]"}], " ", "<", " ", 
                    "0.0001"}]}], ")"}]}], " ", "||", " ", "\n", 
                    "                        ", 
                    RowBox[{"generationnumber", " ", "==", " ", "1."}]}], ",",
                     " ", 
                    RowBox[{
                    "minresonateraylength", " ", "=", " ", "\n", 
                    "                        ", "0."}], ",", " ", 
                    RowBox[{
                    "minresonateraylength", " ", "=", " ", "0.0001"}]}], 
                    "]"}], ";", " ", 
                    RowBox[{"Block", "[", "\n", "                        ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "LocRayL", ",", " ", "LocSCx", ",", " ", "LocSCy"}], 
                    "}"}], ",", " ", 
                    RowBox[{
                    RowBox[{"LocRayL", " ", "=", " ", "1."}], ";", " ", "\n", 
                    "                        ", 
                    RowBox[{"LocSCx", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"LocSCy", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"dummymatrix", " ", "=", " ", 
                    RowBox[{"Union", "[", "\n", "                        ", 
                    RowBox[{"Select", "[", 
                    RowBox[{"intersections", ",", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "LocRayL", ",", " ", "LocSCx", ",", " ", "\n", 
                    "                        ", "LocSCy"}], "}"}], " ", "=", 
                    " ", "#1"}], ";", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "LocRayL", ",", " ", "LocSCx", ",", " ", "LocSCy"}], 
                    "}"}], " ", "==", " ", "\n", "                        ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}]}], " ", "||", " ", 
                    RowBox[{
                    RowBox[{"N", "[", 
                    RowBox[{"Chop", "[", "LocRayL", "]"}], "]"}], " ", ">=", 
                    " ", "\n", "                        ", 
                    "minresonateraylength"}]}]}], ")"}], " ", "&"}]}], " ", 
                    "]"}], "]"}]}], ";", " ", 
                    RowBox[{
                    "intersections", " ", "=", " ", "\n", 
                    "                        ", "dummymatrix"}]}]}], "]"}], 
                    ";", " ", 
                    RowBox[{
                    "unfilteredintersections", " ", "=", " ", "\n", 
                    "                        ", "intersections"}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", "intersections", "]"}], " ", ">", 
                    " ", "1"}], ",", " ", "\n", "                        ", 
                    RowBox[{
                    RowBox[{"dummymatrix", " ", "=", " ", 
                    RowBox[{"Take", "[", 
                    RowBox[{"intersections", ",", " ", 
                    RowBox[{"{", "2", "}"}]}], "]"}]}], ";", " ", "\n", 
                    "                        ", 
                    RowBox[{"intersections", " ", "=", " ", "dummymatrix"}], 
                    ";", " ", "1."}], ",", " ", "1."}], "]"}], ";", " ", 
                    RowBox[{"AppendTo", "[", "\n", "                        ", 
                    RowBox[{"intersectionslist", ",", " ", "intersections"}], 
                    "]"}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    "holeQ", ",", " ", "\n", "                        ", 
                    RowBox[{"AppendTo", "[", 
                    RowBox[{"holeQlist", ",", " ", "1"}], "]"}], ",", " ", 
                    RowBox[{"AppendTo", "[", 
                    RowBox[{"holeQlist", ",", " ", "0"}], "]"}]}], "]"}], ";",
                     " ", "\n", "                       ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "rez", ",", " ", "r1", ",", 
                    " ", "r2", ",", " ", "r3", ",", " ", "r4", ",", " ", "\n",
                     "                        ", "r5", ",", " ", "r6", ",", 
                    " ", "r7", ",", " ", "r8", ",", " ", "r9", ",", " ", 
                    "wavelength", ",", " ", "intensity", ",", " ", "\n", 
                    "                        ", "intensityscale", ",", " ", 
                    "ray1", ",", " ", "index", ",", " ", "opticallength", ",",
                     " ", "\n", "                        ", "phaseshift", ",",
                     " ", "componentnumber", ",", " ", "surfacenumber", ",", 
                    " ", "\n", "                        ", "surfaceid", ",", 
                    " ", "ray2", ",", " ", "ray3", ",", " ", "sid", ",", " ", 
                    "frontid", ",", " ", "sno1", ",", " ", "sno2", ",", " ", 
                    "\n", "                        ", "sno3", ",", " ", 
                    "sno4", ",", " ", "rayslot", ",", " ", 
                    "oldgenerationnumber", ",", " ", "\n", 
                    "                        ", "intersectionnumber", ",", 
                    " ", "pol1", ",", " ", "pol2", ",", " ", "pol3"}], "}"}], 
                    " ", "=", " ", "#1"}], ";", " ", "\n", 
                    "                       ", 
                    RowBox[{"index1", " ", "=", " ", "index"}], ";", " ", 
                    RowBox[{"xunit", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"r1", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", "\n", "                        ", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]23"}], 
                    "]"}], "]"}]}], " ", "+", " ", 
                    RowBox[{"r2", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", "\n", "                        ", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]23"}], 
                    "]"}], "]"}]}]}]}], ";", " ", 
                    RowBox[{
                    "yunit", " ", "=", " ", "\n", "                        ", 
                    
                    RowBox[{
                    RowBox[{"r2", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]23"}], 
                    "]"}], "]"}]}], " ", "-", " ", "\n", 
                    "                        ", 
                    RowBox[{"1.", "*", "r1", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]23"}], 
                    "]"}], "]"}]}]}]}], ";", " ", "\n", 
                    "                       ", 
                    RowBox[{"zunit", " ", "=", " ", 
                    RowBox[{"r3", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]23"}], 
                    "]"}], "^", "2"}], " ", "+", " ", "\n", 
                    "                        ", 
                    RowBox[{
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]23"}], 
                    "]"}], "^", "2"}]}], "]"}]}]}], ";", " ", 
                    RowBox[{
                    "xunit", " ", "=", " ", "\n", "                        ", 
                    
                    RowBox[{"Chop", "[", "xunit", "]"}]}], ";", " ", 
                    RowBox[{"yunit", " ", "=", " ", 
                    RowBox[{"Chop", "[", "yunit", "]"}]}], ";", " ", 
                    RowBox[{
                    "zunit", " ", "=", " ", "\n", "                        ", 
                    
                    RowBox[{"Chop", "[", "zunit", "]"}]}], ";", " ", 
                    RowBox[{"magnitude", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"xunit", "^", "2"}], " ", "+", " ", 
                    RowBox[{"yunit", "^", "2"}], " ", "+", " ", "\n", 
                    "                        ", 
                    RowBox[{"zunit", "^", "2"}]}], ")"}], "^", 
                    RowBox[{"2", "^", 
                    RowBox[{"(", 
                    RowBox[{"-", "1"}], ")"}]}]}]}], ";", " ", 
                    RowBox[{"xunit", " ", "=", " ", 
                    RowBox[{"xunit", "/", "magnitude"}]}], ";", " ", "\n", 
                    "                       ", 
                    RowBox[{"yunit", " ", "=", " ", 
                    RowBox[{"yunit", "/", "magnitude"}]}], ";", " ", 
                    RowBox[{"zunit", " ", "=", " ", 
                    RowBox[{"zunit", "/", "magnitude"}]}], ";", " ", "\n", 
                    "                       ", 
                    RowBox[{"rx", " ", "=", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]23"}], 
                    "]"}], "]"}], "*", 
                    RowBox[{"(", 
                    RowBox[{
                    "rex", " ", "-", " ", "\n", "                        ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"x23", " ", "+", " ", 
                    RowBox[{"9.6", "*", 
                    RowBox[{"Cos", "[", 
                    RowBox[{
                    "0.017453292519943295", "*", "\n", 
                    "                        ", "\[Theta]23"}], "]"}]}]}], 
                    "]"}]}]}], ")"}]}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"rey", " ", "-", " ", 
                    RowBox[{"9.6", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", "\n", "                        ", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]23"}], 
                    "]"}], "]"}]}]}], ")"}], "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", "\n", "                        ", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]23"}], 
                    "]"}], "]"}]}]}]}], ";", " ", 
                    RowBox[{
                    "ry", " ", "=", " ", "\n", "                        ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]23"}], 
                    "]"}], "]"}], "*", 
                    RowBox[{"(", 
                    RowBox[{
                    "rey", " ", "-", " ", "\n", "                        ", 
                    RowBox[{"9.6", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]23"}], 
                    "]"}], "]"}]}]}], ")"}]}], " ", "-", " ", "\n", 
                    "                        ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"(", 
                    RowBox[{"rex", " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"x23", " ", "+", " ", 
                    RowBox[{"9.6", "*", 
                    RowBox[{"Cos", "[", "\n", "                        ", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]23"}], 
                    "]"}]}]}], "]"}]}]}], ")"}], "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", "\n", "                        ", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]23"}], 
                    "]"}], "]"}]}]}]}], ";", " ", 
                    RowBox[{"rz", " ", "=", " ", 
                    RowBox[{"rez", "*", "\n", "                        ", 
                    RowBox[{"Re", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]23"}], 
                    "]"}], "^", "2"}], " ", "+", " ", "\n", 
                    "                        ", 
                    RowBox[{
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]23"}], 
                    "]"}], "^", "2"}]}], "]"}]}]}], ";", " ", 
                    RowBox[{
                    "rx", " ", "=", " ", "\n", "                        ", 
                    RowBox[{"Chop", "[", "rx", "]"}]}], ";", " ", 
                    RowBox[{"ry", " ", "=", " ", 
                    RowBox[{"Chop", "[", "ry", "]"}]}], ";", " ", 
                    RowBox[{"rz", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rz", "]"}]}], ";", " ", "\n", 
                    "                       ", 
                    RowBox[{"terminatedeflection", " ", "=", " ", "False"}], 
                    ";", " ", 
                    RowBox[{
                    "intersections", " ", "=", " ", "\n", 
                    "                        ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}], "}"}]}], ";", " ", 
                    RowBox[{"intersections", " ", "=", " ", 
                    RowBox[{"Block", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "TempVar", ",", " ", "\n", "                        ", 
                    "TempVar1", ",", " ", "TempVar2", ",", " ", "TempVar3", 
                    ",", " ", "LocRayL", ",", " ", "LocSCx", ",", " ", "\n", 
                    "                        ", "LocSCy"}], "}"}], ",", " ", 
                    RowBox[{
                    RowBox[{"TempVar1", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"TempVar2", " ", "=", " ", "1."}], ";", " ", "\n",
                     "                        ", 
                    RowBox[{"TempVar3", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"TempVar", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}], "}"}]}], ";", " ", "\n", 
                    "                        ", 
                    RowBox[{"LocRayL", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"LocSCx", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"LocSCy", " ", "=", " ", "1."}], ";", " ", "\n", 
                    "                        ", 
                    RowBox[{"TempVar1", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"rx", "^", "2"}], " ", "+", " ", 
                    RowBox[{"ry", "^", "2"}], " ", "+", " ", 
                    RowBox[{"rz", "^", "2"}]}]}], ";", " ", 
                    RowBox[{
                    "TempVar2", " ", "=", " ", "\n", 
                    "                        ", 
                    RowBox[{
                    RowBox[{"rx", "*", "xunit"}], " ", "+", " ", 
                    RowBox[{"ry", "*", "yunit"}], " ", "+", " ", 
                    RowBox[{"rz", "*", "zunit"}], " ", "-", " ", 
                    RowBox[{"r23", "*", "xunit"}]}]}], ";", " ", "\n", 
                    "                        ", 
                    RowBox[{"TempVar3", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"-", "TempVar1"}], " ", "+", " ", 
                    RowBox[{"TempVar2", "^", "2"}], " ", "+", " ", 
                    RowBox[{"2", "*", "rx", "*", "r23"}]}]}], ";", " ", "\n", 
                    "                        ", 
                    RowBox[{"TempVar3", " ", "=", " ", 
                    RowBox[{"Re", "[", "TempVar3", "]"}]}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"N", "[", 
                    RowBox[{"Chop", "[", "TempVar3", "]"}], "]"}], " ", ">=", 
                    " ", "\n", "                        ", "0."}], ",", " ", 
                    RowBox[{
                    RowBox[{"TempVar3", " ", "=", " ", 
                    RowBox[{"Sqrt", "[", "TempVar3", "]"}]}], ";", " ", 
                    RowBox[{
                    "TempVar", " ", "=", " ", "\n", 
                    "                        ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "LocRayL", ",", " ", "LocSCx", ",", " ", "LocSCy"}], 
                    "}"}], " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "TempVar2"}], " ", "-", " ", "\n", 
                    "                        ", "TempVar3"}], ",", " ", 
                    RowBox[{"ry", " ", "-", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"TempVar2", " ", "+", " ", "TempVar3"}], ")"}], 
                    "*", "yunit"}]}], ",", " ", "\n", 
                    "                        ", 
                    RowBox[{"rz", " ", "-", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"TempVar2", " ", "+", " ", "TempVar3"}], ")"}], 
                    "*", "zunit"}]}]}], "}"}]}], ";", " ", 
                    RowBox[{"If", "[", "\n", "                        ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"N", "[", 
                    RowBox[{"Chop", "[", "LocRayL", "]"}], "]"}], " ", ">=", 
                    " ", "0."}], " ", "&&", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"LocSCx", "^", "2"}], " ", "+", " ", 
                    RowBox[{"LocSCy", "^", "2"}]}], " ", "<=", " ", "\n", 
                    "                        ", "161.29"}], " ", "&&", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", 
                    RowBox[{"ry", " ", "+", " ", 
                    RowBox[{"LocRayL", "*", "yunit"}], " ", "-", " ", 
                    "LocSCx"}], "]"}], " ", "+", " ", "\n", 
                    "                        ", 
                    RowBox[{"Abs", "[", 
                    RowBox[{"rz", " ", "+", " ", 
                    RowBox[{"LocRayL", "*", "zunit"}], " ", "-", " ", 
                    "LocSCy"}], "]"}], " ", "+", " ", 
                    RowBox[{"Abs", "[", 
                    RowBox[{
                    RowBox[{"-", "r23"}], " ", "+", " ", "\n", 
                    "                        ", "rx", " ", "+", " ", 
                    RowBox[{"LocRayL", "*", "xunit"}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"Sqrt", "[", 
                    RowBox[{
                    RowBox[{"r23", "^", "2"}], " ", "-", " ", 
                    RowBox[{"LocSCx", "^", "2"}], " ", "-", " ", "\n", 
                    "                        ", 
                    RowBox[{"LocSCy", "^", "2"}]}], "]"}], "*", 
                    RowBox[{"Sign", "[", "r23", "]"}]}]}], "]"}]}], " ", "<", 
                    " ", "1.*^-7"}]}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "LocRayL", ",", " ", "LocSCx", ",", " ", "\n", 
                    "                        ", "LocSCy"}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}]}], "]"}]}], ",", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "LocRayL", ",", " ", "LocSCx", ",", " ", "\n", 
                    "                        ", "LocSCy"}], "}"}], " ", "=", 
                    " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "TempVar2"}], " ", "+", " ", "TempVar3"}], 
                    ",", " ", 
                    RowBox[{
                    "ry", " ", "+", " ", "\n", "                        ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "TempVar2"}], " ", "+", " ", "TempVar3"}], 
                    ")"}], "*", "yunit"}]}], ",", " ", 
                    RowBox[{"rz", " ", "+", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "TempVar2"}], " ", "+", " ", "\n", 
                    "                        ", "TempVar3"}], ")"}], "*", 
                    "zunit"}]}]}], "}"}]}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"N", "[", 
                    RowBox[{"Chop", "[", "LocRayL", "]"}], "]"}], " ", ">=", 
                    " ", "0."}], " ", "&&", " ", "\n", 
                    "                        ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"LocSCx", "^", "2"}], " ", "+", " ", 
                    RowBox[{"LocSCy", "^", "2"}]}], " ", "<=", " ", 
                    "161.29"}], " ", "&&", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", 
                    RowBox[{
                    "ry", " ", "+", " ", "\n", "                        ", 
                    RowBox[{"LocRayL", "*", "yunit"}], " ", "-", " ", 
                    "LocSCx"}], "]"}], " ", "+", " ", 
                    RowBox[{"Abs", "[", 
                    RowBox[{"rz", " ", "+", " ", 
                    RowBox[{
                    "LocRayL", "*", "\n", "                        ", 
                    "zunit"}], " ", "-", " ", "LocSCy"}], "]"}], " ", "+", 
                    " ", 
                    RowBox[{"Abs", "[", 
                    RowBox[{
                    RowBox[{"-", "r23"}], " ", "+", " ", "rx", " ", "+", " ", 
                    
                    RowBox[{"LocRayL", "*", "\n", "                        ", 
                    "xunit"}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"Sqrt", "[", 
                    RowBox[{
                    RowBox[{"r23", "^", "2"}], " ", "-", " ", 
                    RowBox[{"LocSCx", "^", "2"}], " ", "-", " ", 
                    RowBox[{"LocSCy", "^", "2"}]}], "]"}], "*", 
                    RowBox[{
                    "Sign", "[", "\n", "                        ", "r23", 
                    "]"}]}]}], "]"}]}], " ", "<", " ", "1.*^-7"}]}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "LocRayL", ",", " ", "LocSCx", ",", " ", "LocSCy"}], 
                    "}"}], ",", " ", "\n", "                        ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}]}], "]"}]}]}], "}"}]}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"TempVar", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], " ", "==", " ", 
                    RowBox[{"TempVar", "[", 
                    RowBox[{"[", "\n", "                        ", "2", "]"}],
                     "]"}]}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"TempVar", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "}"}], ",", " ", 
                    "TempVar"}], "]"}]}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "\n", 
                    "                        ", "0."}], "}"}], "}"}]}], 
                    "]"}]}]}], "]"}]}], ";", " ", 
                    RowBox[{"AppendTo", "[", 
                    RowBox[{"intersections", ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}]}], "]"}], ";", " ", "\n", "                       ", 
                    RowBox[{"holeQ", " ", "=", " ", "False"}], ";", " ", 
                    RowBox[{"If", "[", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"!", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Chop", "[", 
                    RowBox[{"surfaceid", " ", "-", " ", "92312."}], "]"}], 
                    " ", "==", " ", "\n", "                        ", "0."}], 
                    " ", "||", " ", 
                    RowBox[{
                    RowBox[{"N", "[", 
                    RowBox[{"Chop", "[", "ray1", "]"}], "]"}], " ", "<", " ", 
                    "0.0001"}]}], ")"}]}], " ", "||", " ", "\n", 
                    "                        ", 
                    RowBox[{"generationnumber", " ", "==", " ", "1."}]}], ",",
                     " ", 
                    RowBox[{
                    "minresonateraylength", " ", "=", " ", "\n", 
                    "                        ", "0."}], ",", " ", 
                    RowBox[{
                    "minresonateraylength", " ", "=", " ", "0.0001"}]}], 
                    "]"}], ";", " ", 
                    RowBox[{"Block", "[", "\n", "                        ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "LocRayL", ",", " ", "LocSCx", ",", " ", "LocSCy"}], 
                    "}"}], ",", " ", 
                    RowBox[{
                    RowBox[{"LocRayL", " ", "=", " ", "1."}], ";", " ", "\n", 
                    "                        ", 
                    RowBox[{"LocSCx", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"LocSCy", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"dummymatrix", " ", "=", " ", 
                    RowBox[{"Union", "[", "\n", "                        ", 
                    RowBox[{"Select", "[", 
                    RowBox[{"intersections", ",", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "LocRayL", ",", " ", "LocSCx", ",", " ", "\n", 
                    "                        ", "LocSCy"}], "}"}], " ", "=", 
                    " ", "#1"}], ";", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "LocRayL", ",", " ", "LocSCx", ",", " ", "LocSCy"}], 
                    "}"}], " ", "==", " ", "\n", "                        ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}]}], " ", "||", " ", 
                    RowBox[{
                    RowBox[{"N", "[", 
                    RowBox[{"Chop", "[", "LocRayL", "]"}], "]"}], " ", ">=", 
                    " ", "\n", "                        ", 
                    "minresonateraylength"}]}]}], ")"}], " ", "&"}]}], " ", 
                    "]"}], "]"}]}], ";", " ", 
                    RowBox[{
                    "intersections", " ", "=", " ", "\n", 
                    "                        ", "dummymatrix"}]}]}], "]"}], 
                    ";", " ", 
                    RowBox[{
                    "unfilteredintersections", " ", "=", " ", "\n", 
                    "                        ", "intersections"}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", "intersections", "]"}], " ", ">", 
                    " ", "1"}], ",", " ", "\n", "                        ", 
                    RowBox[{
                    RowBox[{"dummymatrix", " ", "=", " ", 
                    RowBox[{"Take", "[", 
                    RowBox[{"intersections", ",", " ", 
                    RowBox[{"{", "2", "}"}]}], "]"}]}], ";", " ", "\n", 
                    "                        ", 
                    RowBox[{"intersections", " ", "=", " ", "dummymatrix"}], 
                    ";", " ", "1."}], ",", " ", "1."}], "]"}], ";", " ", 
                    RowBox[{"AppendTo", "[", "\n", "                        ", 
                    RowBox[{"intersectionslist", ",", " ", "intersections"}], 
                    "]"}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    "holeQ", ",", " ", "\n", "                        ", 
                    RowBox[{"AppendTo", "[", 
                    RowBox[{"holeQlist", ",", " ", "1"}], "]"}], ",", " ", 
                    RowBox[{"AppendTo", "[", 
                    RowBox[{
                    "holeQlist", ",", " ", "\n", "                        ", 
                    "0"}], "]"}]}], "]"}]}], ")"}], ";", " ", 
                    RowBox[{"holeQlist", " ", "=", " ", 
                    RowBox[{"Drop", "[", 
                    RowBox[{"holeQlist", ",", " ", "1"}], "]"}]}], ";", " ", 
                    RowBox[{"Drop", "[", "\n", "                       ", 
                    RowBox[{"intersectionslist", ",", " ", "1"}], "]"}]}]}], 
                    "]"}]}], ")"}], ";", " ", 
                    RowBox[{"Which", "[", 
                    RowBox[{
                    RowBox[{
                    "resonatenumber", " ", "==", " ", "\n", 
                    "                     ", "1"}], ",", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "rez", ",", " ", "r1", ",", 
                    " ", "r2", ",", " ", "r3", ",", " ", "r4", ",", " ", "\n",
                     "                       ", "r5", ",", " ", "r6", ",", 
                    " ", "r7", ",", " ", "r8", ",", " ", "r9", ",", " ", 
                    "wavelength", ",", " ", "intensity", ",", " ", "\n", 
                    "                       ", "intensityscale", ",", " ", 
                    "ray1", ",", " ", "index", ",", " ", "opticallength", ",",
                     " ", "\n", "                       ", "phaseshift", ",", 
                    " ", "componentnumber", ",", " ", "surfacenumber", ",", 
                    " ", "\n", "                       ", "surfaceid", ",", 
                    " ", "ray2", ",", " ", "ray3", ",", " ", "sid", ",", " ", 
                    "frontid", ",", " ", "sno1", ",", " ", "sno2", ",", " ", 
                    "\n", "                       ", "sno3", ",", " ", "sno4",
                     ",", " ", "rayslot", ",", " ", "oldgenerationnumber", 
                    ",", " ", "\n", "                       ", 
                    "intersectionnumber", ",", " ", "pol1", ",", " ", "pol2", 
                    ",", " ", "pol3"}], "}"}], " ", "=", " ", "#1"}], ";", 
                    " ", "\n", "                     ", 
                    RowBox[{"index1", " ", "=", " ", "index"}], ";", " ", 
                    RowBox[{"xunit", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"r1", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", "\n", "                        ", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]13"}], 
                    "]"}], "]"}]}], " ", "+", " ", 
                    RowBox[{"r2", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", "\n", "                        ", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]13"}], 
                    "]"}], "]"}]}]}]}], ";", " ", 
                    RowBox[{
                    "yunit", " ", "=", " ", "\n", "                      ", 
                    RowBox[{
                    RowBox[{"r2", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]13"}], 
                    "]"}], "]"}]}], " ", "-", " ", 
                    RowBox[{
                    "1.", "*", "r1", "*", "\n", "                        ", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]13"}], 
                    "]"}], "]"}]}]}]}], ";", " ", 
                    RowBox[{
                    "zunit", " ", "=", " ", "\n", "                      ", 
                    RowBox[{"r3", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]13"}], 
                    "]"}], "^", "2"}], " ", "+", " ", "\n", 
                    "                        ", 
                    RowBox[{
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]13"}], 
                    "]"}], "^", "2"}]}], "]"}]}]}], ";", " ", 
                    RowBox[{
                    "xunit", " ", "=", " ", "\n", "                      ", 
                    RowBox[{"Chop", "[", "xunit", "]"}]}], ";", " ", 
                    RowBox[{"yunit", " ", "=", " ", 
                    RowBox[{"Chop", "[", "yunit", "]"}]}], ";", " ", 
                    RowBox[{
                    "zunit", " ", "=", " ", "\n", "                      ", 
                    RowBox[{"Chop", "[", "zunit", "]"}]}], ";", " ", 
                    RowBox[{"magnitude", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"xunit", "^", "2"}], " ", "+", " ", 
                    RowBox[{"yunit", "^", "2"}], " ", "+", " ", "\n", 
                    "                        ", 
                    RowBox[{"zunit", "^", "2"}]}], ")"}], "^", 
                    RowBox[{"2", "^", 
                    RowBox[{"(", 
                    RowBox[{"-", "1"}], ")"}]}]}]}], ";", " ", 
                    RowBox[{"xunit", " ", "=", " ", 
                    RowBox[{"xunit", "/", "magnitude"}]}], ";", " ", "\n", 
                    "                     ", 
                    RowBox[{"yunit", " ", "=", " ", 
                    RowBox[{"yunit", "/", "magnitude"}]}], ";", " ", 
                    RowBox[{"zunit", " ", "=", " ", 
                    RowBox[{"zunit", "/", "magnitude"}]}], ";", " ", "\n", 
                    "                     ", 
                    RowBox[{"rx", " ", "=", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"rex", " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"Re", "[", "x13", "]"}]}]}], ")"}], "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{
                    "0.017453292519943295", "*", "\n", 
                    "                        ", "\[Theta]13"}], "]"}], 
                    "]"}]}], " ", "+", " ", 
                    RowBox[{"rey", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{
                    "0.017453292519943295", "*", "\n", 
                    "                        ", "\[Theta]13"}], "]"}], 
                    "]"}]}]}]}], ";", " ", 
                    RowBox[{"ry", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"rey", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{
                    "0.017453292519943295", "*", "\n", 
                    "                        ", "\[Theta]13"}], "]"}], 
                    "]"}]}], " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"(", 
                    RowBox[{"rex", " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"Re", "[", "x13", "]"}]}]}], ")"}], "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", "\n", "                        ", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]13"}], 
                    "]"}], "]"}]}]}]}], ";", " ", 
                    RowBox[{"rz", " ", "=", " ", 
                    RowBox[{"rez", "*", "\n", "                       ", 
                    RowBox[{"Re", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]13"}], 
                    "]"}], "^", "2"}], " ", "+", " ", "\n", 
                    "                        ", 
                    RowBox[{
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]13"}], 
                    "]"}], "^", "2"}]}], "]"}]}]}], ";", " ", 
                    RowBox[{
                    "rx", " ", "=", " ", "\n", "                      ", 
                    RowBox[{"Chop", "[", "rx", "]"}]}], ";", " ", 
                    RowBox[{"ry", " ", "=", " ", 
                    RowBox[{"Chop", "[", "ry", "]"}]}], ";", " ", 
                    RowBox[{"rz", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rz", "]"}]}], ";", " ", "\n", 
                    "                     ", 
                    RowBox[{"terminatedeflection", " ", "=", " ", "False"}], 
                    ";", " ", 
                    RowBox[{
                    "intersections", " ", "=", " ", "\n", 
                    "                      ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}], "}"}]}], ";", " ", 
                    RowBox[{
                    "intersections", " ", "=", " ", "\n", 
                    "                      ", "resonateintersections"}], ";", 
                    " ", 
                    RowBox[{"holeQ", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"holeQlist", "[", 
                    RowBox[{
                    "[", "\n", "                        ", "resonatenumber", 
                    "]"}], "]"}], " ", "==", " ", "1"}]}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "newcomponentnumber", ",", " ", "\n", 
                    "                       ", "newsurfacenumber", ",", " ", 
                    "newsurfaceid"}], "}"}], " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "1.", ",", " ", "1.", ",", " ", "\n", 
                    "                       ", "92155."}], "}"}]}], ";", " ", 
                    
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "componentnumber", ",", " ", "surfacenumber", ",", " ", 
                    "\n", "                       ", "surfaceid"}], "}"}], 
                    " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"1.", ",", " ", "1.", ",", " ", "92155."}], 
                    "}"}]}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "ray1", ",", " ", "ray2", ",", " ", "\n", 
                    "                       ", "ray3"}], "}"}], " ", "=", " ", 
                    RowBox[{"intersections", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], ";", " ", 
                    RowBox[{"rsx", " ", "=", " ", "rex"}], ";", " ", 
                    RowBox[{"rsy", " ", "=", " ", "rey"}], ";", " ", "\n", 
                    "                     ", 
                    RowBox[{"rsz", " ", "=", " ", "rez"}], ";", " ", 
                    RowBox[{"rxhlp", " ", "=", " ", 
                    RowBox[{"rx", " ", "+", " ", 
                    RowBox[{"ray1", "*", "xunit"}]}]}], ";", " ", 
                    RowBox[{
                    "ryhlp", " ", "=", " ", "\n", "                      ", 
                    RowBox[{"ry", " ", "+", " ", 
                    RowBox[{"ray1", "*", "yunit"}]}]}], ";", " ", 
                    RowBox[{"rzhlp", " ", "=", " ", 
                    RowBox[{"rz", " ", "+", " ", 
                    RowBox[{"ray1", "*", "zunit"}]}]}], ";", " ", "\n", 
                    "                     ", 
                    RowBox[{"rex", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"Re", "[", "x13", "]"}], " ", "+", " ", 
                    RowBox[{"rxhlp", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{
                    "0.017453292519943295", "*", "\n", 
                    "                        ", "\[Theta]13"}], "]"}], 
                    "]"}]}], " ", "-", " ", 
                    RowBox[{"1.", "*", "ryhlp", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{
                    "0.017453292519943295", "*", "\n", 
                    "                        ", "\[Theta]13"}], "]"}], 
                    "]"}]}]}]}], ";", " ", 
                    RowBox[{"rey", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"ryhlp", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{
                    "0.017453292519943295", "*", "\n", 
                    "                        ", "\[Theta]13"}], "]"}], 
                    "]"}]}], " ", "+", " ", 
                    RowBox[{"rxhlp", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{
                    "0.017453292519943295", "*", "\n", 
                    "                        ", "\[Theta]13"}], "]"}], 
                    "]"}]}]}]}], ";", " ", 
                    RowBox[{"rez", " ", "=", " ", 
                    RowBox[{"rzhlp", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{
                    "0.017453292519943295", "*", "\n", 
                    "                        ", "\[Theta]13"}], "]"}], "^", 
                    "2"}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]13"}], 
                    "]"}], "^", "2"}]}], "]"}]}]}], ";", " ", "\n", 
                    "                     ", 
                    RowBox[{"rex", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rex", "]"}]}], ";", " ", 
                    RowBox[{"rey", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rey", "]"}]}], ";", " ", 
                    RowBox[{"rez", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rez", "]"}]}], ";", " ", "\n", 
                    "                     ", 
                    RowBox[{"intersectionnumber", " ", "=", " ", 
                    RowBox[{"intersectionnumber", " ", "+", " ", "1."}]}], 
                    ";", " ", "\n", "                     ", 
                    RowBox[{"opticallength", " ", "=", " ", 
                    RowBox[{"opticallength", " ", "+", " ", 
                    RowBox[{"ray1", "*", "index1"}]}]}], ";", " ", "\n", 
                    "                     ", 
                    RowBox[{"completedray", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "rez", ",", " ", "r1", ",", 
                    " ", "\n", "                       ", "r2", ",", " ", 
                    "r3", ",", " ", "r4", ",", " ", "r5", ",", " ", "r6", ",",
                     " ", "r7", ",", " ", "r8", ",", " ", "r9", ",", " ", 
                    "wavelength", ",", " ", "\n", "                       ", 
                    "intensity", ",", " ", "intensityscale", ",", " ", "ray1",
                     ",", " ", "index", ",", " ", "\n", 
                    "                       ", "opticallength", ",", " ", 
                    "phaseshift", ",", " ", "componentnumber", ",", " ", "\n",
                     "                       ", "surfacenumber", ",", " ", 
                    "surfaceid", ",", " ", "ray2", ",", " ", "ray3", ",", " ",
                     "sid", ",", " ", "\n", "                       ", 
                    "frontid", ",", " ", "sno1", ",", " ", "sno2", ",", " ", 
                    "sno3", ",", " ", "sno4", ",", " ", "rayslot", ",", " ", 
                    "\n", "                       ", "generationnumber", ",", 
                    " ", "intersectionnumber", ",", " ", "pol1", ",", " ", 
                    "pol2", ",", " ", "\n", "                       ", 
                    "pol3"}], "}"}]}], ";", " ", 
                    RowBox[{"reportedrayspresent", " ", "=", " ", "True"}], 
                    ";", " ", "\n", "                     ", 
                    RowBox[{"intersectionspresent", " ", "=", " ", "True"}], 
                    ";", " ", 
                    RowBox[{
                    "deflectedrayspresent", " ", "=", " ", "\n", 
                    "                      ", "True"}], ";", " ", 
                    RowBox[{
                    "localdummyoutrayspresent", " ", "=", " ", "True"}], ";", 
                    " ", "\n", "                     ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"surfnorm", " ", "=", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"1.", ",", " ", 
                    RowBox[{
                    RowBox[{"-", "1."}], "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"Sign", "[", "r11", "]"}], "*", "ray2"}], ")"}], 
                    "/", "\n", "                        ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"r11", "^", "2"}], " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"ray2", "^", "2"}]}], " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"ray3", "^", "2"}]}]}], ")"}], "^", "0.5"}]}], 
                    ")"}]}], ",", " ", 
                    RowBox[{
                    RowBox[{"-", "1."}], "*", "\n", 
                    "                        ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"Sign", "[", "r11", "]"}], "*", "ray3"}], ")"}], 
                    "/", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"r11", "^", "2"}], " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"ray2", "^", "2"}]}], " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{
                    "ray3", "^", "\n", "                        ", "2"}]}]}], 
                    ")"}], "^", "0.5"}]}], ")"}]}]}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"Sign", "[", "r11", "]"}], "*", "ray2"}], ")"}], 
                    "/", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"r11", "^", "2"}], " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"ray2", "^", "2"}]}], " ", "-", " ", "\n", 
                    "                        ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"ray3", "^", "2"}]}]}], ")"}], "^", "0.5"}]}], 
                    ",", " ", "1.", ",", " ", "0."}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"Sign", "[", "r11", "]"}], "*", "ray3"}], ")"}], 
                    "/", "\n", "                        ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"r11", "^", "2"}], " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"ray2", "^", "2"}]}], " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"ray3", "^", "2"}]}]}], ")"}], "^", "0.5"}]}], 
                    ",", " ", "0.", ",", " ", "1."}], "}"}]}], "}"}], 
                    "]"}]}]}], ";", " ", "\n", "                      ", 
                    RowBox[{"dummymatrix", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{
                    "0.017453292519943295", "*", "\n", 
                    "                        ", "\[Theta]13"}], "]"}], "]"}], 
                    ",", " ", 
                    RowBox[{
                    RowBox[{"-", "1."}], "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{
                    "0.017453292519943295", "*", "\n", 
                    "                        ", "\[Theta]13"}], "]"}], 
                    "]"}]}], ",", " ", "0."}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{
                    "0.017453292519943295", "*", "\n", 
                    "                        ", "\[Theta]13"}], "]"}], "]"}], 
                    ",", " ", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]13"}], 
                    "]"}], "]"}], ",", " ", "\n", "                        ", 
                    "0."}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "0.", ",", " ", "1."}], "}"}]}], 
                    "}"}], " ", ".", " ", "#1"}], " ", "&"}], " ", ")"}], " ",
                     "/@", " ", "surfnorm"}]}], ";", " ", "\n", 
                    "                      ", 
                    RowBox[{"surfnorm", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"#1", "/", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"#1", " ", ".", " ", "#1"}], "]"}]}], " ", "&"}], 
                    " ", ")"}], " ", "/@", " ", "dummymatrix"}]}], ";", " ", 
                    "\n", "                      ", 
                    RowBox[{"surfacerotationmatrix", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", "\n", "                        ", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]13"}], 
                    "]"}], "]"}], ",", " ", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", "\n", "                        ", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]13"}], 
                    "]"}], "]"}], ",", " ", "0."}], "}"}], ",", " ", "\n", 
                    "                        ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "1."}], "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]13"}], 
                    "]"}], "]"}]}], ",", " ", "\n", 
                    "                        ", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]13"}], 
                    "]"}], "]"}], ",", " ", "0."}], "}"}], ",", " ", "\n", 
                    "                        ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "0.", ",", " ", "1."}], "}"}]}], 
                    "}"}]}], ";", " ", 
                    RowBox[{
                    "surfacetranslationvector", " ", "=", " ", "\n", 
                    "                       ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Re", "[", "x13", "]"}], ",", " ", "0.", ",", " ",
                     "0."}], "}"}]}], ";", " ", 
                    RowBox[{"activeregion", " ", "=", " ", "1."}], ";", " ", 
                    "\n", "                      ", 
                    RowBox[{"completedray", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "rez", ",", " ", "r1", ",", 
                    " ", "\n", "                        ", "r2", ",", " ", 
                    "r3", ",", " ", "r4", ",", " ", "r5", ",", " ", "r6", ",",
                     " ", "r7", ",", " ", "r8", ",", " ", "r9", ",", " ", 
                    "wavelength", ",", " ", "\n", "                        ", 
                    "intensity", ",", " ", "intensityscale", ",", " ", "ray1",
                     ",", " ", "index", ",", " ", "\n", 
                    "                        ", "opticallength", ",", " ", 
                    "phaseshift", ",", " ", "componentnumber", ",", " ", "\n",
                     "                        ", "surfacenumber", ",", " ", 
                    "surfaceid", ",", " ", "ray2", ",", " ", "ray3", ",", " ",
                     "sid", ",", " ", "\n", "                        ", 
                    "frontid", ",", " ", "sno1", ",", " ", "sno2", ",", " ", 
                    "sno3", ",", " ", "sno4", ",", " ", "rayslot", ",", " ", 
                    "\n", "                        ", "generationnumber", ",",
                     " ", "intersectionnumber", ",", " ", "pol1", ",", " ", 
                    "\n", "                        ", "pol2", ",", " ", 
                    "pol3"}], "}"}]}], ";", " ", 
                    RowBox[{
                    "componentnumber", " ", "=", " ", "\n", 
                    "                       ", "newcomponentnumber"}], ";", 
                    " ", 
                    RowBox[{
                    "surfacenumber", " ", "=", " ", "\n", 
                    "                       ", "newsurfacenumber"}], ";", " ", 
                    RowBox[{"surfaceid", " ", "=", " ", "newsurfaceid"}], ";",
                     " ", "\n", "                      ", 
                    RowBox[{"originalray", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "rez", ",", " ", "r1", ",", 
                    " ", "\n", "                        ", "r2", ",", " ", 
                    "r3", ",", " ", "r4", ",", " ", "r5", ",", " ", "r6", ",",
                     " ", "r7", ",", " ", "r8", ",", " ", "r9", ",", " ", 
                    "wavelength", ",", " ", "\n", "                        ", 
                    "intensity", ",", " ", "intensityscale", ",", " ", "ray1",
                     ",", " ", "index", ",", " ", "\n", 
                    "                        ", "opticallength", ",", " ", 
                    "phaseshift", ",", " ", "componentnumber", ",", " ", "\n",
                     "                        ", "surfacenumber", ",", " ", 
                    "surfaceid", ",", " ", "ray2", ",", " ", "ray3", ",", " ",
                     "sid", ",", " ", "\n", "                        ", 
                    "frontid", ",", " ", "sno1", ",", " ", "sno2", ",", " ", 
                    "sno3", ",", " ", "sno4", ",", " ", "rayslot", ",", " ", 
                    "\n", "                        ", "generationnumber", ",",
                     " ", "intersectionnumber", ",", " ", "pol1", ",", " ", 
                    "\n", "                        ", "pol2", ",", " ", 
                    "pol3"}], "}"}]}], ";", " ", 
                    RowBox[{"ZAxis", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"First", "[", "surfnorm", "]"}], "*", 
                    RowBox[{"Sign", "[", "\n", "                        ", 
                    RowBox[{
                    RowBox[{"First", "[", "surfnorm", "]"}], " ", ".", " ", 
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}]}], 
                    "]"}]}]}], ";", " ", 
                    RowBox[{"raytiltz", " ", "=", " ", "\n", 
                    "                       ", 
                    RowBox[{"ZAxis", " ", ".", " ", 
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}]}]}],
                     ";", " ", 
                    RowBox[{"raytiltx", " ", "=", " ", 
                    RowBox[{"1", " ", "-", " ", 
                    RowBox[{"raytiltz", "^", "2"}]}]}], ";", " ", "\n", 
                    "                      ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    "raytiltx", " ", "<", " ", "2.220446049250313*^-16"}], 
                    ",", " ", 
                    RowBox[{
                    "raytiltx", " ", "=", " ", "\n", 
                    "                        ", "0."}], ",", " ", 
                    RowBox[{"raytiltx", " ", "=", " ", 
                    RowBox[{"Sqrt", "[", "raytiltx", "]"}]}]}], "]"}], ";", 
                    " ", 
                    RowBox[{
                    "XAxis", " ", "=", " ", "\n", "                       ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    " ", "-", " ", 
                    RowBox[{"ZAxis", "*", "raytiltz"}]}]}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", "raytiltx", "]"}], " ", "<", " ", 
                    "\n", "                        ", "1.*^-7"}], ",", " ", 
                    RowBox[{"XAxis", " ", "=", " ", 
                    RowBox[{"surfnorm", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], ",", " ", 
                    RowBox[{"XAxis", " ", "=", " ", 
                    RowBox[{
                    "XAxis", "/", "\n", "                        ", 
                    "raytiltx"}]}]}], "]"}], ";", " ", 
                    RowBox[{"YAxis", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"ZAxis", "[", 
                    RowBox[{"[", "3", "]"}], "]"}], "*", 
                    RowBox[{"XAxis", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], ")"}]}], " ", "+", " ", 
                    "\n", "                        ", 
                    RowBox[{
                    RowBox[{"ZAxis", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "*", 
                    RowBox[{"XAxis", "[", 
                    RowBox[{"[", "3", "]"}], "]"}]}]}], ",", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"ZAxis", "[", 
                    RowBox[{"[", "3", "]"}], "]"}], "*", 
                    RowBox[{"XAxis", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], " ", "-", " ", "\n", 
                    "                        ", 
                    RowBox[{
                    RowBox[{"ZAxis", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "*", 
                    RowBox[{"XAxis", "[", 
                    RowBox[{"[", "3", "]"}], "]"}]}]}], ",", " ", 
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"ZAxis", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "*", 
                    RowBox[{"XAxis", "[", 
                    RowBox[{"[", "\n", "                        ", "1", "]"}],
                     "]"}]}], ")"}]}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"ZAxis", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "*", 
                    RowBox[{"XAxis", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}]}]}], "}"}]}], ";", " ", 
                    RowBox[{"YAxis", " ", "=", " ", 
                    RowBox[{"YAxis", "/", "\n", "                        ", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"YAxis", " ", ".", " ", "YAxis"}], "]"}]}]}], ";",
                     " ", 
                    RowBox[{"PAxis", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"ZAxis", "*", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "r1", ",", " ", "r2", ",", " ", "\n", 
                    "                        ", "r3"}], "}"}], " ", ".", " ", 
                    "XAxis"}]}], " ", "-", " ", 
                    RowBox[{"XAxis", "*", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    " ", ".", " ", "ZAxis"}]}]}]}], ";", " ", "\n", 
                    "                      ", 
                    RowBox[{"PAxis", " ", "=", " ", 
                    RowBox[{"PAxis", "/", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"PAxis", " ", ".", " ", "PAxis"}], "]"}]}]}], ";",
                     " ", "\n", "                      ", 
                    RowBox[{"normalizedpolarization", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], "[", 
                    RowBox[{"[", "\n", "                        ", 
                    RowBox[{"{", 
                    RowBox[{"1", ",", " ", "2"}], "}"}], "]"}], "]"}]}], ";", 
                    " ", 
                    RowBox[{
                    "normalizedpolarization", " ", "=", " ", "\n", 
                    "                       ", 
                    RowBox[{"normalizedpolarization", "/", 
                    RowBox[{"Sqrt", "[", "\n", "                        ", 
                    RowBox[{
                    "normalizedpolarization", " ", ".", " ", "\n", 
                    "                        ", "normalizedpolarization"}], 
                    "]"}]}]}], ";", " ", 
                    RowBox[{"allcreatedamplitudes", " ", "=", " ", "\n", 
                    "                       ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"I", "*", "0."}], ",", " ", 
                    RowBox[{"I", "*", "0."}], ",", " ", 
                    RowBox[{"I", "*", "0."}]}], "}"}], "}"}]}], ";", " ", 
                    RowBox[{"amplitude", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"Sqrt", "[", "intensity", "]"}], "*", "\n", 
                    "                        ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"normalizedpolarization", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "*", 
                    RowBox[{"{", 
                    RowBox[{"r4", ",", " ", "r5", ",", " ", "r6"}], "}"}]}], 
                    " ", "+", " ", "\n", "                        ", 
                    RowBox[{
                    RowBox[{"normalizedpolarization", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "*", 
                    RowBox[{"{", 
                    RowBox[{"r7", ",", " ", "r8", ",", " ", "r9"}], "}"}], 
                    "*", "\n", "                        ", 
                    RowBox[{"Exp", "[", 
                    RowBox[{"I", "*", "pol3", "*", "0.017453292519943295"}], 
                    "]"}]}]}], ")"}]}]}], ";", " ", "\n", 
                    "                      ", 
                    RowBox[{"perpendicularamplitude", " ", "=", " ", 
                    RowBox[{"amplitude", " ", ".", " ", "YAxis"}]}], ";", " ",
                     "\n", "                      ", 
                    RowBox[{"parallelamplitude", " ", "=", " ", 
                    RowBox[{"amplitude", " ", ".", " ", "PAxis"}]}], ";", " ",
                     "\n", "                      ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"activeregion", "*", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"surfacerotationmatrix", " ", ".", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "r1", ",", " ", "r2", ",", " ", "\n", 
                    "                        ", "r3"}], "}"}]}], ")"}], "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], " ", ">", " ", "0"}], 
                    ",", " ", 
                    RowBox[{
                    RowBox[{"index2", " ", "=", " ", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{
                    "2.7105646", " ", "-", " ", "\n", 
                    "                        ", 
                    RowBox[{"0.009121199600000001", "*", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", 
                    RowBox[{
                    "0.027760538", "/", "\n", "                        ", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", 
                    RowBox[{"0.0012739656", "/", 
                    RowBox[{"wavelength", "^", "4"}]}], " ", "-", " ", "\n", 
                    "                        ", 
                    RowBox[{"0.000047889342", "/", 
                    RowBox[{"wavelength", "^", "6"}]}], " ", "+", " ", 
                    RowBox[{
                    "8.0562028*^-6", "/", "\n", "                        ", 
                    RowBox[{"wavelength", "^", "8"}]}]}], "]"}]}], ";", " ", 
                    RowBox[{"index1", " ", "=", " ", "index"}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", 
                    RowBox[{
                    "index2", " ", "-", " ", "\n", "                        ",
                     "index1"}], "]"}], " ", "<", " ", "0.01"}], ",", " ", 
                    RowBox[{
                    RowBox[{"alternateindex", " ", "=", " ", 
                    RowBox[{"Sqrt", "[", "\n", "                        ", 
                    RowBox[{"1.0005281111748805", " ", "-", " ", 
                    RowBox[{
                    "2.364805676582992*^-10", "*", "\n", 
                    "                        ", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", 
                    RowBox[{"2.9781670902982902*^-6", "/", 
                    RowBox[{
                    "wavelength", "^", "\n", "                        ", 
                    "2"}]}], " ", "+", " ", 
                    RowBox[{"2.6004099469477187*^-8", "/", 
                    RowBox[{"wavelength", "^", "4"}]}], " ", "+", " ", "\n", 
                    "                        ", 
                    RowBox[{"3.7787839314048715*^-10", "/", 
                    RowBox[{"wavelength", "^", "6"}]}], " ", "+", " ", "\n", 
                    "                        ", 
                    RowBox[{"2.830549017940716*^-12", "/", 
                    RowBox[{"wavelength", "^", "8"}]}]}], "]"}]}], ";", " ", 
                    "\n", "                        ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", 
                    RowBox[{"alternateindex", " ", "-", " ", "index1"}], 
                    "]"}], " ", ">", " ", 
                    RowBox[{"Abs", "[", 
                    RowBox[{
                    "index2", " ", "-", " ", "\n", "                        ",
                     "index1"}], "]"}]}], ",", " ", 
                    RowBox[{
                    RowBox[{"index1", " ", "=", " ", "index2"}], ";", " ", 
                    RowBox[{
                    "index2", " ", "=", " ", "\n", "                        ",
                     "alternateindex"}]}], ",", " ", 
                    RowBox[{"index1", " ", "=", " ", "alternateindex"}]}], 
                    "]"}]}], ",", " ", "\n", "                        ", 
                    RowBox[{"index1", " ", "=", " ", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{
                    "1.0005281111748805", " ", "-", " ", "\n", 
                    "                        ", 
                    RowBox[{"2.364805676582992*^-10", "*", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", "\n", 
                    "                        ", 
                    RowBox[{"2.9781670902982902*^-6", "/", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", "\n", 
                    "                        ", 
                    RowBox[{"2.6004099469477187*^-8", "/", 
                    RowBox[{"wavelength", "^", "4"}]}], " ", "+", " ", "\n", 
                    "                        ", 
                    RowBox[{"3.7787839314048715*^-10", "/", 
                    RowBox[{"wavelength", "^", "6"}]}], " ", "+", " ", "\n", 
                    "                        ", 
                    RowBox[{"2.830549017940716*^-12", "/", 
                    RowBox[{"wavelength", "^", "8"}]}]}], "]"}]}]}], "]"}]}], 
                    ",", " ", "\n", "                       ", 
                    RowBox[{
                    RowBox[{"index2", " ", "=", " ", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{
                    "1.0005281111748805", " ", "-", " ", "\n", 
                    "                        ", 
                    RowBox[{"2.364805676582992*^-10", "*", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", "\n", 
                    "                        ", 
                    RowBox[{"2.9781670902982902*^-6", "/", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", "\n", 
                    "                        ", 
                    RowBox[{"2.6004099469477187*^-8", "/", 
                    RowBox[{"wavelength", "^", "4"}]}], " ", "+", " ", "\n", 
                    "                        ", 
                    RowBox[{"3.7787839314048715*^-10", "/", 
                    RowBox[{"wavelength", "^", "6"}]}], " ", "+", " ", "\n", 
                    "                        ", 
                    RowBox[{"2.830549017940716*^-12", "/", 
                    RowBox[{"wavelength", "^", "8"}]}]}], "]"}]}], ";", " ", 
                    RowBox[{
                    "index1", " ", "=", " ", "\n", "                        ",
                     "index"}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", 
                    RowBox[{"index2", " ", "-", " ", "index1"}], "]"}], " ", 
                    "<", " ", "0.01"}], ",", " ", "\n", 
                    "                        ", 
                    RowBox[{
                    RowBox[{"alternateindex", " ", "=", " ", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{
                    "2.7105646", " ", "-", " ", "\n", 
                    "                        ", 
                    RowBox[{"0.009121199600000001", "*", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", 
                    RowBox[{
                    "0.027760538", "/", "\n", "                        ", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", 
                    RowBox[{"0.0012739656", "/", 
                    RowBox[{"wavelength", "^", "4"}]}], " ", "-", " ", "\n", 
                    "                        ", 
                    RowBox[{"0.000047889342", "/", 
                    RowBox[{"wavelength", "^", "6"}]}], " ", "+", " ", 
                    RowBox[{
                    "8.0562028*^-6", "/", "\n", "                        ", 
                    RowBox[{"wavelength", "^", "8"}]}]}], "]"}]}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", 
                    RowBox[{"alternateindex", " ", "-", " ", "index1"}], 
                    "]"}], " ", ">", " ", "\n", "                        ", 
                    RowBox[{"Abs", "[", 
                    RowBox[{"index2", " ", "-", " ", "index1"}], "]"}]}], ",",
                     " ", 
                    RowBox[{
                    RowBox[{"index1", " ", "=", " ", "index2"}], ";", " ", 
                    RowBox[{
                    "index2", " ", "=", " ", "\n", "                        ",
                     "alternateindex"}]}], ",", " ", 
                    RowBox[{"index1", " ", "=", " ", "alternateindex"}]}], 
                    "]"}]}], ",", " ", "\n", "                        ", 
                    RowBox[{"index1", " ", "=", " ", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"2.7105646", " ", "-", " ", 
                    RowBox[{
                    "0.009121199600000001", "*", "\n", 
                    "                        ", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", 
                    RowBox[{"0.027760538", "/", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", "\n", 
                    "                        ", 
                    RowBox[{"0.0012739656", "/", 
                    RowBox[{"wavelength", "^", "4"}]}], " ", "-", " ", 
                    RowBox[{
                    "0.000047889342", "/", "\n", "                        ", 
                    RowBox[{"wavelength", "^", "6"}]}], " ", "+", " ", 
                    RowBox[{"8.0562028*^-6", "/", 
                    RowBox[{"wavelength", "^", "8"}]}]}], "]"}]}]}], 
                    "]"}]}]}], "]"}], ";", " ", "\n", 
                    "                      ", 
                    RowBox[{"n12", " ", "=", " ", 
                    RowBox[{"index1", "/", "index2"}]}], ";", " ", 
                    RowBox[{"index", " ", "=", " ", "index2"}], ";", " ", 
                    "\n", "                      ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"1", " ", "-", " ", 
                    RowBox[{
                    RowBox[{"n12", "^", "2"}], "*", 
                    RowBox[{"raytiltx", "^", "2"}]}]}], " ", ">=", " ", 
                    "0."}], ",", " ", 
                    RowBox[{
                    RowBox[{
                    "dummyvector", " ", "=", " ", "\n", 
                    "                        ", 
                    RowBox[{
                    RowBox[{"n12", "*", 
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}]}], 
                    " ", "+", " ", 
                    RowBox[{"ZAxis", "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"(", 
                    RowBox[{"n12", "*", "raytiltz"}], ")"}]}], " ", "+", " ", 
                    "\n", "                        ", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"1", " ", "-", " ", 
                    RowBox[{
                    RowBox[{"n12", "^", "2"}], "*", 
                    RowBox[{"raytiltx", "^", "2"}]}]}], "]"}]}], ")"}]}]}]}], 
                    ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    " ", "=", " ", "\n", "                        ", 
                    "dummyvector"}], ";", " ", "1."}], ",", " ", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    " ", ".", " ", 
                    RowBox[{"surfnorm", "[", 
                    RowBox[{"[", "\n", "                        ", "1", "]"}],
                     "]"}]}], " ", ">", " ", "0"}], ",", " ", 
                    RowBox[{"phaseshift", " ", "=", " ", 
                    RowBox[{"phaseshift", " ", "+", " ", "0.5"}]}], ",", " ", 
                    "1."}], "]"}], ";", " ", "\n", "                        ", 
                    RowBox[{"index2", " ", "=", " ", "index1"}], ";", " ", 
                    RowBox[{"index", " ", "=", " ", "index1"}], ";", " ", 
                    RowBox[{
                    "dummyvector", " ", "=", " ", "\n", 
                    "                        ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    " ", "-", " ", 
                    RowBox[{"2", "*", "ZAxis", "*", 
                    RowBox[{"ZAxis", " ", ".", " ", 
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], 
                    "}"}]}]}]}]}], ";", " ", "\n", "                        ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    " ", "=", " ", "dummyvector"}], ";", " ", 
                    RowBox[{
                    "dummyvector", " ", "=", " ", "\n", 
                    "                        ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], " ", "+", " ", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", " ", "0", ",", " ", 
                    RowBox[{"-", "180"}]}], "}"}]}]}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "pol1", ",", " ", "pol2", ",", " ", "\n", 
                    "                        ", "pol3"}], "}"}], " ", "=", 
                    " ", "dummyvector"}], ";", " ", "1."}]}], "]"}], ";", " ", 
                    RowBox[{
                    "allcreatedrays", " ", "=", " ", "\n", 
                    "                       ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "rez", ",", " ", "r1", ",", 
                    " ", "r2", ",", " ", "r3", ",", " ", "r4", ",", " ", "\n",
                     "                        ", "r5", ",", " ", "r6", ",", 
                    " ", "r7", ",", " ", "r8", ",", " ", "r9", ",", " ", 
                    "wavelength", ",", " ", "intensity", ",", " ", "\n", 
                    "                        ", "intensityscale", ",", " ", 
                    "ray1", ",", " ", "index", ",", " ", "opticallength", ",",
                     " ", "\n", "                        ", "phaseshift", ",",
                     " ", "componentnumber", ",", " ", "surfacenumber", ",", 
                    " ", "\n", "                        ", "surfaceid", ",", 
                    " ", "ray2", ",", " ", "ray3", ",", " ", "sid", ",", " ", 
                    "frontid", ",", " ", "sno1", ",", " ", "sno2", ",", " ", 
                    "\n", "                        ", "sno3", ",", " ", 
                    "sno4", ",", " ", "rayslot", ",", " ", "generationnumber",
                     ",", " ", "\n", "                        ", 
                    "intersectionnumber", ",", " ", "pol1", ",", " ", "pol2", 
                    ",", " ", "pol3"}], "}"}], "}"}]}], ";", " ", "\n", 
                    "                      ", 
                    RowBox[{"originalrotation", " ", "=", " ", 
                    RowBox[{"Partition", "[", 
                    RowBox[{
                    RowBox[{"Take", "[", 
                    RowBox[{
                    "originalray", ",", " ", "\n", "                        ", 
                    RowBox[{"{", 
                    RowBox[{"7", ",", " ", "15"}], "}"}]}], "]"}], ",", " ", 
                    "3"}], "]"}]}], ";", " ", 
                    RowBox[{"previoustilt", " ", "=", " ", 
                    RowBox[{"originalrotation", "[", 
                    RowBox[{"[", "\n", "                        ", "1", "]"}],
                     "]"}]}], ";", " ", 
                    RowBox[{"transmatrix", " ", "=", " ", 
                    RowBox[{"MapIndexed", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "\n", 
                    "                        ", "rex", ",", " ", "rey", ",", 
                    " ", "rez", ",", " ", "r1", ",", " ", "r2", ",", " ", 
                    "r3", ",", " ", "r4", ",", " ", "r5", ",", " ", "r6", ",",
                     " ", "r7", ",", " ", "r8", ",", " ", "\n", 
                    "                        ", "r9", ",", " ", "wavelength", 
                    ",", " ", "intensity", ",", " ", "intensityscale", ",", 
                    " ", "ray1", ",", " ", "\n", "                        ", 
                    "index", ",", " ", "opticallength", ",", " ", 
                    "phaseshift", ",", " ", "\n", "                        ", 
                    "componentnumber", ",", " ", "surfacenumber", ",", " ", 
                    "surfaceid", ",", " ", "ray2", ",", " ", "\n", 
                    "                        ", "ray3", ",", " ", "sid", ",", 
                    " ", "frontid", ",", " ", "sno1", ",", " ", "sno2", ",", 
                    " ", "sno3", ",", " ", "sno4", ",", " ", "\n", 
                    "                        ", "rayslot", ",", " ", 
                    "oldgenerationnumber", ",", " ", "\n", 
                    "                        ", "intersectionnumber", ",", 
                    " ", "pol1", ",", " ", "pol2", ",", " ", "pol3"}], "}"}], 
                    " ", "=", " ", "#1"}], ";", " ", "\n", 
                    "                        ", 
                    RowBox[{"rotationaxis", " ", "=", " ", 
                    RowBox[{"Cross", "[", 
                    RowBox[{"previoustilt", ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "r1", ",", " ", "r2", ",", " ", "\n", 
                    "                        ", "r3"}], "}"}]}], "]"}]}], ";",
                     " ", 
                    RowBox[{"axismagnitude", " ", "=", " ", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{
                    "rotationaxis", " ", ".", " ", "\n", 
                    "                        ", "rotationaxis"}], "]"}]}], 
                    ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Chop", "[", "axismagnitude", "]"}], " ", "!=", 
                    " ", "0."}], ",", " ", "\n", "                        ", 
                    RowBox[{
                    RowBox[{"rotationaxis", " ", "=", " ", 
                    RowBox[{"rotationaxis", "/", "axismagnitude"}]}], ";", 
                    " ", "\n", "                        ", 
                    RowBox[{"axismatrix", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"#1", "*", "rotationaxis"}], " ", "&"}], " ", 
                    ")"}], " ", "/@", " ", "\n", "                        ", 
                    "rotationaxis"}]}], ";", " ", 
                    RowBox[{"crossmatrix", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", 
                    RowBox[{"-", 
                    RowBox[{"rotationaxis", "[", 
                    RowBox[{"[", "\n", "                        ", "3", "]"}],
                     "]"}]}], ",", " ", 
                    RowBox[{"rotationaxis", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"rotationaxis", "[", 
                    RowBox[{"[", "3", "]"}], "]"}], ",", " ", "0.", ",", " ", 
                    "\n", "                        ", 
                    RowBox[{"-", 
                    RowBox[{"rotationaxis", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}]}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"rotationaxis", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], ",", " ", "\n", 
                    "                        ", 
                    RowBox[{"rotationaxis", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], ",", " ", "0."}], "}"}]}],
                     "}"}]}], ";", " ", 
                    RowBox[{
                    "cosangle", " ", "=", " ", "\n", 
                    "                        ", 
                    RowBox[{"previoustilt", " ", ".", " ", 
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}]}]}],
                     ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"1.", " ", "-", " ", "cosangle"}], " ", "<", " ", 
                    "\n", "                        ", 
                    "2.220446049250313*^-16"}], ",", " ", 
                    RowBox[{"cosangle", " ", "=", " ", "1."}]}], "]"}], ";", 
                    " ", "\n", "                        ", 
                    RowBox[{"sinangle", " ", "=", " ", 
                    RowBox[{"1", " ", "-", " ", 
                    RowBox[{"cosangle", "^", "2"}]}]}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    "sinangle", " ", "<", " ", "\n", 
                    "                        ", "2.220446049250313*^-16"}], 
                    ",", " ", 
                    RowBox[{"sinangle", " ", "=", " ", "0."}], ",", " ", "\n",
                     "                        ", 
                    RowBox[{"sinangle", " ", "=", " ", 
                    RowBox[{"Sqrt", "[", "sinangle", "]"}]}]}], "]"}], ";", 
                    " ", 
                    RowBox[{
                    "axismatrix", " ", "+", " ", "\n", 
                    "                        ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"1.", ",", " ", "0.", ",", " ", "0."}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "1.", ",", " ", "0."}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "0.", ",", " ", "1."}], "}"}]}], 
                    "}"}], " ", "-", " ", "\n", "                        ", 
                    "axismatrix"}], ")"}], "*", "cosangle"}], " ", "+", " ", 
                    RowBox[{"crossmatrix", "*", "sinangle"}]}]}], ",", " ", 
                    "\n", "                        ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"r4", ",", " ", "r5", ",", " ", "r6"}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"r7", ",", " ", "r8", ",", " ", "r9"}], "}"}]}], 
                    "}"}], " ", "=", " ", "\n", "                        ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Sign", "[", 
                    RowBox[{"previoustilt", " ", ".", " ", 
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}]}], 
                    "]"}], " ", "===", " ", "1"}], ",", " ", "\n", 
                    "                        ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"1.", ",", " ", "0.", ",", " ", "0."}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "1.", ",", " ", "0."}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "0.", ",", " ", "1."}], "}"}]}], 
                    "}"}], ",", " ", "\n", "                        ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", 
                    RowBox[{"-", "1."}], ",", " ", "0."}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "0.", ",", " ", "0.", ",", " ", "\n", 
                    "                        ", 
                    RowBox[{"-", "1."}]}], "}"}]}], "}"}]}], "]"}]}]}], 
                    "]"}]}], ")"}], " ", "&"}], " ", ",", " ", 
                    "allcreatedrays"}], "]"}]}], ";", " ", 
                    RowBox[{
                    "allcreatedrays", " ", "=", " ", "\n", 
                    "                       ", 
                    RowBox[{"MapIndexed", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "rez", ",", " ", "r1", ",", 
                    " ", "\n", "                        ", "r2", ",", " ", 
                    "r3", ",", " ", "r4", ",", " ", "r5", ",", " ", "r6", ",",
                     " ", "r7", ",", " ", "r8", ",", " ", "r9", ",", " ", 
                    "wavelength", ",", " ", "\n", "                        ", 
                    "intensity", ",", " ", "intensityscale", ",", " ", "ray1",
                     ",", " ", "index", ",", " ", "\n", 
                    "                        ", "opticallength", ",", " ", 
                    "phaseshift", ",", " ", "componentnumber", ",", " ", "\n",
                     "                        ", "surfacenumber", ",", " ", 
                    "surfaceid", ",", " ", "ray2", ",", " ", "ray3", ",", " ",
                     "sid", ",", " ", "\n", "                        ", 
                    "frontid", ",", " ", "sno1", ",", " ", "sno2", ",", " ", 
                    "sno3", ",", " ", "sno4", ",", " ", "rayslot", ",", " ", 
                    "\n", "                        ", "oldgenerationnumber", 
                    ",", " ", "intersectionnumber", ",", " ", "pol1", ",", 
                    " ", "\n", "                        ", "pol2", ",", " ", 
                    "pol3"}], "}"}], " ", "=", " ", "#1"}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"r4", ",", " ", "r5", ",", " ", "r6"}], "}"}], 
                    ",", " ", "\n", "                        ", 
                    RowBox[{"{", 
                    RowBox[{"r7", ",", " ", "r8", ",", " ", "r9"}], "}"}]}], 
                    "}"}], " ", "=", " ", 
                    RowBox[{
                    RowBox[{"Function", "[", 
                    RowBox[{"mm", ",", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"mm", " ", ".", " ", "#1"}], " ", "&"}], " ", 
                    ")"}], " ", "/@", " ", "\n", "                        ", 
                    "originalrotation"}]}], "]"}], "[", 
                    RowBox[{"transmatrix", "[", 
                    RowBox[{"[", 
                    RowBox[{"First", "[", "#2", "]"}], "]"}], "]"}], "]"}]}], 
                    ";", " ", "\n", "                        ", 
                    RowBox[{"tiltmagnitude", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    " ", ".", " ", 
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}]}]}],
                     ";", " ", "\n", "                        ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", 
                    RowBox[{"tiltmagnitude", " ", "-", " ", "1."}], "]"}], 
                    " ", ">", " ", "1.*^-6"}], ",", " ", "\n", 
                    "                        ", 
                    RowBox[{
                    RowBox[{"dummyvector", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    "/", 
                    RowBox[{"Sqrt", "[", "tiltmagnitude", "]"}]}]}], ";", " ",
                     "\n", "                        ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    " ", "=", " ", "dummyvector"}], ";", " ", 
                    RowBox[{
                    "dummymatrix", " ", "=", " ", "\n", 
                    "                        ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"#1", "/", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"#1", " ", ".", " ", "#1"}], "]"}]}], " ", "&"}], 
                    " ", ")"}], " ", "/@", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "r4", ",", " ", "r5", ",", " ", "\n", 
                    "                        ", "r6"}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"r7", ",", " ", "r8", ",", " ", "r9"}], "}"}]}], 
                    "}"}]}]}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"r4", ",", " ", "r5", ",", " ", "r6"}], "}"}], 
                    ",", " ", "\n", "                        ", 
                    RowBox[{"{", 
                    RowBox[{"r7", ",", " ", "r8", ",", " ", "r9"}], "}"}]}], 
                    "}"}], " ", "=", " ", "dummymatrix"}], ";", " ", "1."}], 
                    ",", " ", "1."}], "]"}], ";", " ", "\n", 
                    "                        ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"allcreatedamplitudes", " ", "!=", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"I", "*", "0."}], ",", " ", 
                    RowBox[{"I", "*", "0."}], ",", " ", 
                    RowBox[{"I", "*", "0."}]}], "}"}], "}"}]}], ",", " ", 
                    "\n", "                        ", 
                    RowBox[{
                    RowBox[{"amplitude", " ", "=", " ", 
                    RowBox[{"allcreatedamplitudes", "[", 
                    RowBox[{"[", 
                    RowBox[{"First", "[", "#2", "]"}], "]"}], "]"}]}], ";", 
                    " ", "\n", "                        ", 
                    RowBox[{"hor", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r4", ",", " ", "r5", ",", " ", "r6"}], "}"}], 
                    " ", ".", " ", "amplitude"}]}], ";", " ", 
                    RowBox[{"ver", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "r7", ",", " ", "r8", ",", " ", "\n", 
                    "                        ", "r9"}], "}"}], " ", ".", " ", 
                    "amplitude"}]}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", "hor", "]"}], " ", ">", " ", "0."}], 
                    " ", "||", " ", 
                    RowBox[{
                    RowBox[{"Abs", "[", "ver", "]"}], " ", ">", " ", "\n", 
                    "                        ", "0."}]}], ",", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Abs", "[", "hor", "]"}], ",", " ", 
                    RowBox[{"Abs", "[", "ver", "]"}], ",", " ", "\n", 
                    "                        ", "0."}], "}"}]}], ";", " ", 
                    RowBox[{"dummyvector", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], "/", 
                    RowBox[{"Sqrt", "[", "\n", "                        ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], " ", ".", " ", 
                    RowBox[{"{", 
                    RowBox[{"pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}]}], "]"}]}]}], ";", " ", "\n", 
                    "                        ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], " ", "=", " ", "dummyvector"}], ";", " ", 
                    RowBox[{
                    "dummyvector", " ", "=", " ", "\n", 
                    "                        ", 
                    RowBox[{"ReplacePart", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], ",", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"ver", " ", "==", " ", "0."}], ",", " ", "\n", 
                    "                        ", "0.", ",", " ", 
                    RowBox[{"Arg", "[", "ver", "]"}]}], "]"}], " ", "-", " ", 
                    
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"hor", " ", "==", " ", "0."}], ",", " ", "0.", 
                    ",", " ", 
                    RowBox[{"Arg", "[", "hor", "]"}]}], "]"}]}], ")"}], "/", 
                    "\n", "                        ", "Degree"}], ",", " ", 
                    "3"}], "]"}]}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], " ", "=", " ", "dummyvector"}]}]}], "]"}], ";", 
                    " ", "\n", "                        ", "1."}], ",", " ", 
                    "1."}], "]"}], ";", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "rez", ",", " ", "r1", ",", 
                    " ", "r2", ",", " ", "\n", "                        ", 
                    "r3", ",", " ", "r4", ",", " ", "r5", ",", " ", "r6", ",",
                     " ", "r7", ",", " ", "r8", ",", " ", "r9", ",", " ", 
                    "wavelength", ",", " ", "\n", "                        ", 
                    "intensity", ",", " ", "intensityscale", ",", " ", "ray1",
                     ",", " ", "index", ",", " ", "\n", 
                    "                        ", "opticallength", ",", " ", 
                    "phaseshift", ",", " ", "componentnumber", ",", " ", "\n",
                     "                        ", "surfacenumber", ",", " ", 
                    "surfaceid", ",", " ", "ray2", ",", " ", "ray3", ",", " ",
                     "sid", ",", " ", "\n", "                        ", 
                    "frontid", ",", " ", "sno1", ",", " ", "sno2", ",", " ", 
                    "sno3", ",", " ", "sno4", ",", " ", "rayslot", ",", " ", 
                    "\n", "                        ", "generationnumber", ",",
                     " ", "intersectionnumber", ",", " ", "pol1", ",", " ", 
                    "\n", "                        ", "pol2", ",", " ", 
                    "pol3"}], "}"}]}], ")"}], " ", "&"}], " ", ",", " ", 
                    "allcreatedrays"}], "]"}]}]}], ")"}], ";", " ", "\n", 
                    "                     ", 
                    RowBox[{"{", 
                    RowBox[{"allcreatedrays", ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",",
                     " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", 
                    "1.", ",", " ", "\n", "                        ", "1.", 
                    ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", 
                    "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",",
                     " ", 
                    RowBox[{"-", "9.87654321*^8"}], ",", " ", "\n", 
                    "                        ", "1.", ",", " ", "1.", ",", 
                    " ", "1.", ",", " ", "1.", ",", " ", "0.", ",", " ", 
                    RowBox[{"-", "1."}], ",", " ", 
                    RowBox[{"-", "1."}], ",", " ", 
                    RowBox[{"-", "1."}], ",", " ", "1.", ",", " ", "1.", ",", 
                    " ", "1.", ",", " ", "\n", "                        ", 
                    "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",",
                     " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", 
                    "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1."}], 
                    "}"}], "}"}], ",", " ", "\n", "                      ", 
                    RowBox[{"{", "completedray", "}"}]}], "}"}]}], ",", " ", 
                    RowBox[{"resonatenumber", " ", "==", " ", "2"}], ",", " ",
                     "\n", "                    ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "rez", ",", " ", "r1", ",", 
                    " ", "r2", ",", " ", "r3", ",", " ", "r4", ",", " ", "r5",
                     ",", " ", "\n", "                       ", "r6", ",", 
                    " ", "r7", ",", " ", "r8", ",", " ", "r9", ",", " ", 
                    "wavelength", ",", " ", "intensity", ",", " ", "\n", 
                    "                       ", "intensityscale", ",", " ", 
                    "ray1", ",", " ", "index", ",", " ", "opticallength", ",",
                     " ", "\n", "                       ", "phaseshift", ",", 
                    " ", "componentnumber", ",", " ", "surfacenumber", ",", 
                    " ", "\n", "                       ", "surfaceid", ",", 
                    " ", "ray2", ",", " ", "ray3", ",", " ", "sid", ",", " ", 
                    "frontid", ",", " ", "sno1", ",", " ", "sno2", ",", " ", 
                    "\n", "                       ", "sno3", ",", " ", "sno4",
                     ",", " ", "rayslot", ",", " ", "oldgenerationnumber", 
                    ",", " ", "\n", "                       ", 
                    "intersectionnumber", ",", " ", "pol1", ",", " ", "pol2", 
                    ",", " ", "pol3"}], "}"}], " ", "=", " ", "#1"}], ";", 
                    " ", "\n", "                     ", 
                    RowBox[{"index1", " ", "=", " ", "index"}], ";", " ", 
                    RowBox[{"xunit", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"r1", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", "\n", "                        ", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]13"}], 
                    "]"}], "]"}]}], " ", "+", " ", 
                    RowBox[{"r2", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", "\n", "                        ", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]13"}], 
                    "]"}], "]"}]}]}]}], ";", " ", 
                    RowBox[{
                    "yunit", " ", "=", " ", "\n", "                      ", 
                    RowBox[{
                    RowBox[{"r2", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]13"}], 
                    "]"}], "]"}]}], " ", "-", " ", 
                    RowBox[{
                    "1.", "*", "r1", "*", "\n", "                        ", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]13"}], 
                    "]"}], "]"}]}]}]}], ";", " ", 
                    RowBox[{
                    "zunit", " ", "=", " ", "\n", "                      ", 
                    RowBox[{"r3", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]13"}], 
                    "]"}], "^", "2"}], " ", "+", " ", "\n", 
                    "                        ", 
                    RowBox[{
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]13"}], 
                    "]"}], "^", "2"}]}], "]"}]}]}], ";", " ", 
                    RowBox[{
                    "xunit", " ", "=", " ", "\n", "                      ", 
                    RowBox[{"Chop", "[", "xunit", "]"}]}], ";", " ", 
                    RowBox[{"yunit", " ", "=", " ", 
                    RowBox[{"Chop", "[", "yunit", "]"}]}], ";", " ", 
                    RowBox[{
                    "zunit", " ", "=", " ", "\n", "                      ", 
                    RowBox[{"Chop", "[", "zunit", "]"}]}], ";", " ", 
                    RowBox[{"magnitude", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"xunit", "^", "2"}], " ", "+", " ", 
                    RowBox[{"yunit", "^", "2"}], " ", "+", " ", "\n", 
                    "                        ", 
                    RowBox[{"zunit", "^", "2"}]}], ")"}], "^", 
                    RowBox[{"2", "^", 
                    RowBox[{"(", 
                    RowBox[{"-", "1"}], ")"}]}]}]}], ";", " ", 
                    RowBox[{"xunit", " ", "=", " ", 
                    RowBox[{"xunit", "/", "magnitude"}]}], ";", " ", "\n", 
                    "                     ", 
                    RowBox[{"yunit", " ", "=", " ", 
                    RowBox[{"yunit", "/", "magnitude"}]}], ";", " ", 
                    RowBox[{"zunit", " ", "=", " ", 
                    RowBox[{"zunit", "/", "magnitude"}]}], ";", " ", "\n", 
                    "                     ", 
                    RowBox[{"rx", " ", "=", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]13"}], 
                    "]"}], "]"}], "*", 
                    RowBox[{"(", 
                    RowBox[{
                    "rex", " ", "-", " ", "\n", "                        ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"x13", " ", "+", " ", 
                    RowBox[{"2.1", "*", 
                    RowBox[{"Cos", "[", 
                    RowBox[{
                    "0.017453292519943295", "*", "\n", 
                    "                        ", "\[Theta]13"}], "]"}]}]}], 
                    "]"}]}]}], ")"}]}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"rey", " ", "-", " ", 
                    RowBox[{"2.1", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", "\n", "                        ", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]13"}], 
                    "]"}], "]"}]}]}], ")"}], "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", "\n", "                        ", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]13"}], 
                    "]"}], "]"}]}]}]}], ";", " ", 
                    RowBox[{
                    "ry", " ", "=", " ", "\n", "                      ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]13"}], 
                    "]"}], "]"}], "*", 
                    RowBox[{"(", 
                    RowBox[{
                    "rey", " ", "-", " ", "\n", "                        ", 
                    RowBox[{"2.1", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]13"}], 
                    "]"}], "]"}]}]}], ")"}]}], " ", "-", " ", "\n", 
                    "                       ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"(", 
                    RowBox[{"rex", " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"x13", " ", "+", " ", 
                    RowBox[{"2.1", "*", 
                    RowBox[{"Cos", "[", "\n", "                        ", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]13"}], 
                    "]"}]}]}], "]"}]}]}], ")"}], "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", "\n", "                        ", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]13"}], 
                    "]"}], "]"}]}]}]}], ";", " ", 
                    RowBox[{"rz", " ", "=", " ", 
                    RowBox[{"rez", "*", "\n", "                       ", 
                    RowBox[{"Re", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]13"}], 
                    "]"}], "^", "2"}], " ", "+", " ", "\n", 
                    "                        ", 
                    RowBox[{
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]13"}], 
                    "]"}], "^", "2"}]}], "]"}]}]}], ";", " ", 
                    RowBox[{
                    "rx", " ", "=", " ", "\n", "                      ", 
                    RowBox[{"Chop", "[", "rx", "]"}]}], ";", " ", 
                    RowBox[{"ry", " ", "=", " ", 
                    RowBox[{"Chop", "[", "ry", "]"}]}], ";", " ", 
                    RowBox[{"rz", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rz", "]"}]}], ";", " ", "\n", 
                    "                     ", 
                    RowBox[{"terminatedeflection", " ", "=", " ", "False"}], 
                    ";", " ", 
                    RowBox[{
                    "intersections", " ", "=", " ", "\n", 
                    "                      ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}], "}"}]}], ";", " ", 
                    RowBox[{
                    "intersections", " ", "=", " ", "\n", 
                    "                      ", "resonateintersections"}], ";", 
                    " ", 
                    RowBox[{"holeQ", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"holeQlist", "[", 
                    RowBox[{
                    "[", "\n", "                        ", "resonatenumber", 
                    "]"}], "]"}], " ", "==", " ", "1"}]}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "newcomponentnumber", ",", " ", "\n", 
                    "                       ", "newsurfacenumber", ",", " ", 
                    "newsurfaceid"}], "}"}], " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"1.", ",", " ", "2.", ",", " ", "\n", 
                    "                       ", "92156."}], "}"}]}], ";", " ", 
                    
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "componentnumber", ",", " ", "surfacenumber", ",", " ", 
                    "\n", "                       ", "surfaceid"}], "}"}], 
                    " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"1.", ",", " ", "2.", ",", " ", "92156."}], 
                    "}"}]}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "ray1", ",", " ", "ray2", ",", " ", "\n", 
                    "                       ", "ray3"}], "}"}], " ", "=", " ", 
                    RowBox[{"intersections", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], ";", " ", 
                    RowBox[{"rsx", " ", "=", " ", "rex"}], ";", " ", 
                    RowBox[{"rsy", " ", "=", " ", "rey"}], ";", " ", "\n", 
                    "                     ", 
                    RowBox[{"rsz", " ", "=", " ", "rez"}], ";", " ", 
                    RowBox[{"rxhlp", " ", "=", " ", 
                    RowBox[{"rx", " ", "+", " ", 
                    RowBox[{"ray1", "*", "xunit"}]}]}], ";", " ", 
                    RowBox[{
                    "ryhlp", " ", "=", " ", "\n", "                      ", 
                    RowBox[{"ry", " ", "+", " ", 
                    RowBox[{"ray1", "*", "yunit"}]}]}], ";", " ", 
                    RowBox[{"rzhlp", " ", "=", " ", 
                    RowBox[{"rz", " ", "+", " ", 
                    RowBox[{"ray1", "*", "zunit"}]}]}], ";", " ", "\n", 
                    "                     ", 
                    RowBox[{"rex", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"rxhlp", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]13"}], 
                    "]"}], "]"}]}], " ", "+", " ", "\n", 
                    "                       ", 
                    RowBox[{"Re", "[", 
                    RowBox[{"x13", " ", "+", " ", 
                    RowBox[{"2.1", "*", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]13"}], 
                    "]"}]}]}], "]"}], " ", "-", " ", "\n", 
                    "                       ", 
                    RowBox[{"1.", "*", "ryhlp", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]13"}], 
                    "]"}], "]"}]}]}]}], ";", " ", "\n", 
                    "                     ", 
                    RowBox[{"rey", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"ryhlp", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]13"}], 
                    "]"}], "]"}]}], " ", "+", " ", "\n", 
                    "                       ", 
                    RowBox[{"2.1", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]13"}], 
                    "]"}], "]"}]}], " ", "+", " ", "\n", 
                    "                       ", 
                    RowBox[{"rxhlp", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]13"}], 
                    "]"}], "]"}]}]}]}], ";", " ", "\n", 
                    "                     ", 
                    RowBox[{"rez", " ", "=", " ", 
                    RowBox[{"rzhlp", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]13"}], 
                    "]"}], "^", "2"}], " ", "+", " ", "\n", 
                    "                        ", 
                    RowBox[{
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]13"}], 
                    "]"}], "^", "2"}]}], "]"}]}]}], ";", " ", 
                    RowBox[{
                    "rex", " ", "=", " ", "\n", "                      ", 
                    RowBox[{"Chop", "[", "rex", "]"}]}], ";", " ", 
                    RowBox[{"rey", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rey", "]"}]}], ";", " ", 
                    RowBox[{"rez", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rez", "]"}]}], ";", " ", "\n", 
                    "                     ", 
                    RowBox[{"intersectionnumber", " ", "=", " ", 
                    RowBox[{"intersectionnumber", " ", "+", " ", "1."}]}], 
                    ";", " ", "\n", "                     ", 
                    RowBox[{"opticallength", " ", "=", " ", 
                    RowBox[{"opticallength", " ", "+", " ", 
                    RowBox[{"ray1", "*", "index1"}]}]}], ";", " ", "\n", 
                    "                     ", 
                    RowBox[{"completedray", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "rez", ",", " ", "r1", ",", 
                    " ", "\n", "                       ", "r2", ",", " ", 
                    "r3", ",", " ", "r4", ",", " ", "r5", ",", " ", "r6", ",",
                     " ", "r7", ",", " ", "r8", ",", " ", "r9", ",", " ", 
                    "wavelength", ",", " ", "\n", "                       ", 
                    "intensity", ",", " ", "intensityscale", ",", " ", "ray1",
                     ",", " ", "index", ",", " ", "\n", 
                    "                       ", "opticallength", ",", " ", 
                    "phaseshift", ",", " ", "componentnumber", ",", " ", "\n",
                     "                       ", "surfacenumber", ",", " ", 
                    "surfaceid", ",", " ", "ray2", ",", " ", "ray3", ",", " ",
                     "sid", ",", " ", "\n", "                       ", 
                    "frontid", ",", " ", "sno1", ",", " ", "sno2", ",", " ", 
                    "sno3", ",", " ", "sno4", ",", " ", "rayslot", ",", " ", 
                    "\n", "                       ", "generationnumber", ",", 
                    " ", "intersectionnumber", ",", " ", "pol1", ",", " ", 
                    "pol2", ",", " ", "\n", "                       ", 
                    "pol3"}], "}"}]}], ";", " ", 
                    RowBox[{"reportedrayspresent", " ", "=", " ", "True"}], 
                    ";", " ", "\n", "                     ", 
                    RowBox[{"intersectionspresent", " ", "=", " ", "True"}], 
                    ";", " ", 
                    RowBox[{
                    "deflectedrayspresent", " ", "=", " ", "\n", 
                    "                      ", "True"}], ";", " ", 
                    RowBox[{
                    "localdummyoutrayspresent", " ", "=", " ", "True"}], ";", 
                    " ", "\n", "                     ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"surfnorm", " ", "=", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"1.", ",", " ", 
                    RowBox[{
                    RowBox[{"-", "1."}], "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"Sign", "[", "r12", "]"}], "*", "ray2"}], ")"}], 
                    "/", "\n", "                        ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"r12", "^", "2"}], " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"ray2", "^", "2"}]}], " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"ray3", "^", "2"}]}]}], ")"}], "^", "0.5"}]}], 
                    ")"}]}], ",", " ", 
                    RowBox[{
                    RowBox[{"-", "1."}], "*", "\n", 
                    "                        ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"Sign", "[", "r12", "]"}], "*", "ray3"}], ")"}], 
                    "/", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"r12", "^", "2"}], " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"ray2", "^", "2"}]}], " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{
                    "ray3", "^", "\n", "                        ", "2"}]}]}], 
                    ")"}], "^", "0.5"}]}], ")"}]}]}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"Sign", "[", "r12", "]"}], "*", "ray2"}], ")"}], 
                    "/", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"r12", "^", "2"}], " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"ray2", "^", "2"}]}], " ", "-", " ", "\n", 
                    "                        ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"ray3", "^", "2"}]}]}], ")"}], "^", "0.5"}]}], 
                    ",", " ", "1.", ",", " ", "0."}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"Sign", "[", "r12", "]"}], "*", "ray3"}], ")"}], 
                    "/", "\n", "                        ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"r12", "^", "2"}], " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"ray2", "^", "2"}]}], " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"ray3", "^", "2"}]}]}], ")"}], "^", "0.5"}]}], 
                    ",", " ", "0.", ",", " ", "1."}], "}"}]}], "}"}], 
                    "]"}]}]}], ";", " ", "\n", "                      ", 
                    RowBox[{"dummymatrix", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{
                    "0.017453292519943295", "*", "\n", 
                    "                        ", "\[Theta]13"}], "]"}], "]"}], 
                    ",", " ", 
                    RowBox[{
                    RowBox[{"-", "1."}], "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{
                    "0.017453292519943295", "*", "\n", 
                    "                        ", "\[Theta]13"}], "]"}], 
                    "]"}]}], ",", " ", "0."}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{
                    "0.017453292519943295", "*", "\n", 
                    "                        ", "\[Theta]13"}], "]"}], "]"}], 
                    ",", " ", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]13"}], 
                    "]"}], "]"}], ",", " ", "\n", "                        ", 
                    "0."}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "0.", ",", " ", "1."}], "}"}]}], 
                    "}"}], " ", ".", " ", "#1"}], " ", "&"}], " ", ")"}], " ",
                     "/@", " ", "surfnorm"}]}], ";", " ", "\n", 
                    "                      ", 
                    RowBox[{"surfnorm", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"#1", "/", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"#1", " ", ".", " ", "#1"}], "]"}]}], " ", "&"}], 
                    " ", ")"}], " ", "/@", " ", "dummymatrix"}]}], ";", " ", 
                    "\n", "                      ", 
                    RowBox[{"surfacerotationmatrix", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", "\n", "                        ", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]13"}], 
                    "]"}], "]"}], ",", " ", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", "\n", "                        ", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]13"}], 
                    "]"}], "]"}], ",", " ", "0."}], "}"}], ",", " ", "\n", 
                    "                        ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "1."}], "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]13"}], 
                    "]"}], "]"}]}], ",", " ", "\n", 
                    "                        ", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]13"}], 
                    "]"}], "]"}], ",", " ", "0."}], "}"}], ",", " ", "\n", 
                    "                        ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "0.", ",", " ", "1."}], "}"}]}], 
                    "}"}]}], ";", " ", 
                    RowBox[{"surfacetranslationvector", " ", "=", " ", "\n", 
                    "                       ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"x13", " ", "+", " ", 
                    RowBox[{"2.1", "*", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]13"}], 
                    "]"}]}]}], "]"}], ",", " ", "\n", 
                    "                        ", 
                    RowBox[{"2.1", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]13"}], 
                    "]"}], "]"}]}], ",", " ", "0."}], "}"}]}], ";", " ", "\n",
                     "                      ", 
                    RowBox[{"activeregion", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"completedray", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "\n", 
                    "                        ", "rex", ",", " ", "rey", ",", 
                    " ", "rez", ",", " ", "r1", ",", " ", "r2", ",", " ", 
                    "r3", ",", " ", "r4", ",", " ", "r5", ",", " ", "r6", ",",
                     " ", "r7", ",", " ", "r8", ",", " ", "\n", 
                    "                        ", "r9", ",", " ", "wavelength", 
                    ",", " ", "intensity", ",", " ", "intensityscale", ",", 
                    " ", "ray1", ",", " ", "\n", "                        ", 
                    "index", ",", " ", "opticallength", ",", " ", 
                    "phaseshift", ",", " ", "\n", "                        ", 
                    "componentnumber", ",", " ", "surfacenumber", ",", " ", 
                    "surfaceid", ",", " ", "ray2", ",", " ", "\n", 
                    "                        ", "ray3", ",", " ", "sid", ",", 
                    " ", "frontid", ",", " ", "sno1", ",", " ", "sno2", ",", 
                    " ", "sno3", ",", " ", "sno4", ",", " ", "\n", 
                    "                        ", "rayslot", ",", " ", 
                    "generationnumber", ",", " ", "intersectionnumber", ",", 
                    " ", "\n", "                        ", "pol1", ",", " ", 
                    "pol2", ",", " ", "pol3"}], "}"}]}], ";", " ", 
                    RowBox[{
                    "componentnumber", " ", "=", " ", "\n", 
                    "                       ", "newcomponentnumber"}], ";", 
                    " ", 
                    RowBox[{
                    "surfacenumber", " ", "=", " ", "\n", 
                    "                       ", "newsurfacenumber"}], ";", " ", 
                    RowBox[{"surfaceid", " ", "=", " ", "newsurfaceid"}], ";",
                     " ", "\n", "                      ", 
                    RowBox[{"originalray", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "rez", ",", " ", "r1", ",", 
                    " ", "\n", "                        ", "r2", ",", " ", 
                    "r3", ",", " ", "r4", ",", " ", "r5", ",", " ", "r6", ",",
                     " ", "r7", ",", " ", "r8", ",", " ", "r9", ",", " ", 
                    "wavelength", ",", " ", "\n", "                        ", 
                    "intensity", ",", " ", "intensityscale", ",", " ", "ray1",
                     ",", " ", "index", ",", " ", "\n", 
                    "                        ", "opticallength", ",", " ", 
                    "phaseshift", ",", " ", "componentnumber", ",", " ", "\n",
                     "                        ", "surfacenumber", ",", " ", 
                    "surfaceid", ",", " ", "ray2", ",", " ", "ray3", ",", " ",
                     "sid", ",", " ", "\n", "                        ", 
                    "frontid", ",", " ", "sno1", ",", " ", "sno2", ",", " ", 
                    "sno3", ",", " ", "sno4", ",", " ", "rayslot", ",", " ", 
                    "\n", "                        ", "generationnumber", ",",
                     " ", "intersectionnumber", ",", " ", "pol1", ",", " ", 
                    "\n", "                        ", "pol2", ",", " ", 
                    "pol3"}], "}"}]}], ";", " ", 
                    RowBox[{"ZAxis", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"First", "[", "surfnorm", "]"}], "*", 
                    RowBox[{"Sign", "[", "\n", "                        ", 
                    RowBox[{
                    RowBox[{"First", "[", "surfnorm", "]"}], " ", ".", " ", 
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}]}], 
                    "]"}]}]}], ";", " ", 
                    RowBox[{
                    "raytiltz", " ", "=", " ", "\n", 
                    "                       ", 
                    RowBox[{"ZAxis", " ", ".", " ", 
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}]}]}],
                     ";", " ", 
                    RowBox[{"raytiltx", " ", "=", " ", 
                    RowBox[{"1", " ", "-", " ", 
                    RowBox[{"raytiltz", "^", "2"}]}]}], ";", " ", "\n", 
                    "                      ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    "raytiltx", " ", "<", " ", "2.220446049250313*^-16"}], 
                    ",", " ", 
                    RowBox[{
                    "raytiltx", " ", "=", " ", "\n", 
                    "                        ", "0."}], ",", " ", 
                    RowBox[{"raytiltx", " ", "=", " ", 
                    RowBox[{"Sqrt", "[", "raytiltx", "]"}]}]}], "]"}], ";", 
                    " ", 
                    RowBox[{
                    "XAxis", " ", "=", " ", "\n", "                       ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    " ", "-", " ", 
                    RowBox[{"ZAxis", "*", "raytiltz"}]}]}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", "raytiltx", "]"}], " ", "<", " ", 
                    "\n", "                        ", "1.*^-7"}], ",", " ", 
                    RowBox[{"XAxis", " ", "=", " ", 
                    RowBox[{"surfnorm", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], ",", " ", 
                    RowBox[{"XAxis", " ", "=", " ", 
                    RowBox[{"XAxis", "/", "\n", "                        ", 
                    "raytiltx"}]}]}], "]"}], ";", " ", 
                    RowBox[{"YAxis", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"ZAxis", "[", 
                    RowBox[{"[", "3", "]"}], "]"}], "*", 
                    RowBox[{"XAxis", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], ")"}]}], " ", "+", " ", 
                    "\n", "                        ", 
                    RowBox[{
                    RowBox[{"ZAxis", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "*", 
                    RowBox[{"XAxis", "[", 
                    RowBox[{"[", "3", "]"}], "]"}]}]}], ",", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"ZAxis", "[", 
                    RowBox[{"[", "3", "]"}], "]"}], "*", 
                    RowBox[{"XAxis", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], " ", "-", " ", "\n", 
                    "                        ", 
                    RowBox[{
                    RowBox[{"ZAxis", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "*", 
                    RowBox[{"XAxis", "[", 
                    RowBox[{"[", "3", "]"}], "]"}]}]}], ",", " ", 
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"ZAxis", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "*", 
                    RowBox[{"XAxis", "[", 
                    RowBox[{"[", "\n", "                        ", "1", "]"}],
                     "]"}]}], ")"}]}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"ZAxis", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "*", 
                    RowBox[{"XAxis", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}]}]}], "}"}]}], ";", " ", 
                    RowBox[{"YAxis", " ", "=", " ", 
                    RowBox[{"YAxis", "/", "\n", "                        ", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"YAxis", " ", ".", " ", "YAxis"}], "]"}]}]}], ";",
                     " ", 
                    RowBox[{"PAxis", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"ZAxis", "*", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "r1", ",", " ", "r2", ",", " ", "\n", 
                    "                        ", "r3"}], "}"}], " ", ".", " ", 
                    "XAxis"}]}], " ", "-", " ", 
                    RowBox[{"XAxis", "*", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    " ", ".", " ", "ZAxis"}]}]}]}], ";", " ", "\n", 
                    "                      ", 
                    RowBox[{"PAxis", " ", "=", " ", 
                    RowBox[{"PAxis", "/", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"PAxis", " ", ".", " ", "PAxis"}], "]"}]}]}], ";",
                     " ", "\n", "                      ", 
                    RowBox[{"normalizedpolarization", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], "[", 
                    RowBox[{"[", "\n", "                        ", 
                    RowBox[{"{", 
                    RowBox[{"1", ",", " ", "2"}], "}"}], "]"}], "]"}]}], ";", 
                    " ", 
                    RowBox[{
                    "normalizedpolarization", " ", "=", " ", "\n", 
                    "                       ", 
                    RowBox[{"normalizedpolarization", "/", 
                    RowBox[{"Sqrt", "[", "\n", "                        ", 
                    RowBox[{
                    "normalizedpolarization", " ", ".", " ", "\n", 
                    "                        ", "normalizedpolarization"}], 
                    "]"}]}]}], ";", " ", 
                    RowBox[{
                    "allcreatedamplitudes", " ", "=", " ", "\n", 
                    "                       ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"I", "*", "0."}], ",", " ", 
                    RowBox[{"I", "*", "0."}], ",", " ", 
                    RowBox[{"I", "*", "0."}]}], "}"}], "}"}]}], ";", " ", 
                    RowBox[{"amplitude", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"Sqrt", "[", "intensity", "]"}], "*", "\n", 
                    "                        ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"normalizedpolarization", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "*", 
                    RowBox[{"{", 
                    RowBox[{"r4", ",", " ", "r5", ",", " ", "r6"}], "}"}]}], 
                    " ", "+", " ", "\n", "                        ", 
                    RowBox[{
                    RowBox[{"normalizedpolarization", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "*", 
                    RowBox[{"{", 
                    RowBox[{"r7", ",", " ", "r8", ",", " ", "r9"}], "}"}], 
                    "*", "\n", "                        ", 
                    RowBox[{"Exp", "[", 
                    RowBox[{"I", "*", "pol3", "*", "0.017453292519943295"}], 
                    "]"}]}]}], ")"}]}]}], ";", " ", "\n", 
                    "                      ", 
                    RowBox[{"perpendicularamplitude", " ", "=", " ", 
                    RowBox[{"amplitude", " ", ".", " ", "YAxis"}]}], ";", " ",
                     "\n", "                      ", 
                    RowBox[{"parallelamplitude", " ", "=", " ", 
                    RowBox[{"amplitude", " ", ".", " ", "PAxis"}]}], ";", " ",
                     "\n", "                      ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"activeregion", "*", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"surfacerotationmatrix", " ", ".", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "r1", ",", " ", "r2", ",", " ", "\n", 
                    "                        ", "r3"}], "}"}]}], ")"}], "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], " ", ">", " ", "0"}], 
                    ",", " ", 
                    RowBox[{
                    RowBox[{"index2", " ", "=", " ", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{
                    "2.2718929", " ", "-", " ", "\n", 
                    "                        ", 
                    RowBox[{"0.010108077", "*", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", 
                    RowBox[{
                    "0.010592509", "/", "\n", "                        ", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", 
                    RowBox[{"0.00020816965", "/", 
                    RowBox[{"wavelength", "^", "4"}]}], " ", "-", " ", "\n", 
                    "                        ", 
                    RowBox[{"7.6472538*^-6", "/", 
                    RowBox[{"wavelength", "^", "6"}]}], " ", "+", " ", 
                    RowBox[{
                    "4.9240991*^-7", "/", "\n", "                        ", 
                    RowBox[{"wavelength", "^", "8"}]}]}], "]"}]}], ";", " ", 
                    RowBox[{"index1", " ", "=", " ", "index"}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", 
                    RowBox[{
                    "index2", " ", "-", " ", "\n", "                        ",
                     "index1"}], "]"}], " ", "<", " ", "0.01"}], ",", " ", 
                    RowBox[{
                    RowBox[{"alternateindex", " ", "=", " ", 
                    RowBox[{"Sqrt", "[", "\n", "                        ", 
                    RowBox[{"2.7105646", " ", "-", " ", 
                    RowBox[{"0.009121199600000001", "*", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", "\n", 
                    "                        ", 
                    RowBox[{"0.027760538", "/", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", 
                    RowBox[{
                    "0.0012739656", "/", "\n", "                        ", 
                    RowBox[{"wavelength", "^", "4"}]}], " ", "-", " ", 
                    RowBox[{"0.000047889342", "/", 
                    RowBox[{"wavelength", "^", "6"}]}], " ", "+", " ", "\n", 
                    "                        ", 
                    RowBox[{"8.0562028*^-6", "/", 
                    RowBox[{"wavelength", "^", "8"}]}]}], "]"}]}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", "\n", "                        ", 
                    RowBox[{"alternateindex", " ", "-", " ", "index1"}], 
                    "]"}], " ", ">", " ", 
                    RowBox[{"Abs", "[", 
                    RowBox[{"index2", " ", "-", " ", "index1"}], "]"}]}], ",",
                     " ", "\n", "                        ", 
                    RowBox[{
                    RowBox[{"index1", " ", "=", " ", "index2"}], ";", " ", 
                    RowBox[{"index2", " ", "=", " ", "alternateindex"}]}], 
                    ",", " ", "\n", "                        ", 
                    RowBox[{"index1", " ", "=", " ", "alternateindex"}]}], 
                    "]"}]}], ",", " ", 
                    RowBox[{"index1", " ", "=", " ", 
                    RowBox[{"Sqrt", "[", "\n", "                        ", 
                    RowBox[{"2.7105646", " ", "-", " ", 
                    RowBox[{"0.009121199600000001", "*", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", "\n", 
                    "                        ", 
                    RowBox[{"0.027760538", "/", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", 
                    RowBox[{
                    "0.0012739656", "/", "\n", "                        ", 
                    RowBox[{"wavelength", "^", "4"}]}], " ", "-", " ", 
                    RowBox[{"0.000047889342", "/", 
                    RowBox[{"wavelength", "^", "6"}]}], " ", "+", " ", "\n", 
                    "                        ", 
                    RowBox[{"8.0562028*^-6", "/", 
                    RowBox[{"wavelength", "^", "8"}]}]}], "]"}]}]}], "]"}]}], 
                    ",", " ", 
                    RowBox[{
                    RowBox[{"index2", " ", "=", " ", 
                    RowBox[{"Sqrt", "[", "\n", "                        ", 
                    RowBox[{"2.7105646", " ", "-", " ", 
                    RowBox[{"0.009121199600000001", "*", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", "\n", 
                    "                        ", 
                    RowBox[{"0.027760538", "/", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", 
                    RowBox[{
                    "0.0012739656", "/", "\n", "                        ", 
                    RowBox[{"wavelength", "^", "4"}]}], " ", "-", " ", 
                    RowBox[{"0.000047889342", "/", 
                    RowBox[{"wavelength", "^", "6"}]}], " ", "+", " ", "\n", 
                    "                        ", 
                    RowBox[{"8.0562028*^-6", "/", 
                    RowBox[{"wavelength", "^", "8"}]}]}], "]"}]}], ";", " ", 
                    RowBox[{"index1", " ", "=", " ", "index"}], ";", " ", 
                    "\n", "                        ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", 
                    RowBox[{"index2", " ", "-", " ", "index1"}], "]"}], " ", 
                    "<", " ", "0.01"}], ",", " ", 
                    RowBox[{
                    RowBox[{
                    "alternateindex", " ", "=", " ", "\n", 
                    "                        ", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"2.2718929", " ", "-", " ", 
                    RowBox[{"0.010108077", "*", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", "\n", 
                    "                        ", 
                    RowBox[{"0.010592509", "/", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", 
                    RowBox[{
                    "0.00020816965", "/", "\n", "                        ", 
                    RowBox[{"wavelength", "^", "4"}]}], " ", "-", " ", 
                    RowBox[{"7.6472538*^-6", "/", 
                    RowBox[{"wavelength", "^", "6"}]}], " ", "+", " ", "\n", 
                    "                        ", 
                    RowBox[{"4.9240991*^-7", "/", 
                    RowBox[{"wavelength", "^", "8"}]}]}], "]"}]}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", "\n", "                        ", 
                    RowBox[{"alternateindex", " ", "-", " ", "index1"}], 
                    "]"}], " ", ">", " ", 
                    RowBox[{"Abs", "[", 
                    RowBox[{"index2", " ", "-", " ", "index1"}], "]"}]}], ",",
                     " ", "\n", "                        ", 
                    RowBox[{
                    RowBox[{"index1", " ", "=", " ", "index2"}], ";", " ", 
                    RowBox[{"index2", " ", "=", " ", "alternateindex"}]}], 
                    ",", " ", "\n", "                        ", 
                    RowBox[{"index1", " ", "=", " ", "alternateindex"}]}], 
                    "]"}]}], ",", " ", 
                    RowBox[{"index1", " ", "=", " ", 
                    RowBox[{"Sqrt", "[", "\n", "                        ", 
                    RowBox[{"2.2718929", " ", "-", " ", 
                    RowBox[{"0.010108077", "*", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", "\n", 
                    "                        ", 
                    RowBox[{"0.010592509", "/", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", 
                    RowBox[{
                    "0.00020816965", "/", "\n", "                        ", 
                    RowBox[{"wavelength", "^", "4"}]}], " ", "-", " ", 
                    RowBox[{"7.6472538*^-6", "/", 
                    RowBox[{"wavelength", "^", "6"}]}], " ", "+", " ", "\n", 
                    "                        ", 
                    RowBox[{"4.9240991*^-7", "/", 
                    RowBox[{"wavelength", "^", "8"}]}]}], "]"}]}]}], 
                    "]"}]}]}], "]"}], ";", " ", 
                    RowBox[{"n12", " ", "=", " ", 
                    RowBox[{
                    "index1", "/", "\n", "                        ", 
                    "index2"}]}], ";", " ", 
                    RowBox[{"index", " ", "=", " ", "index2"}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"1", " ", "-", " ", 
                    RowBox[{
                    RowBox[{"n12", "^", "2"}], "*", 
                    RowBox[{
                    "raytiltx", "^", "\n", "                        ", 
                    "2"}]}]}], " ", ">=", " ", "0."}], ",", " ", 
                    RowBox[{
                    RowBox[{"dummyvector", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"n12", "*", 
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}]}], 
                    " ", "+", " ", "\n", "                        ", 
                    RowBox[{"ZAxis", "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"(", 
                    RowBox[{"n12", "*", "raytiltz"}], ")"}]}], " ", "+", " ", 
                    
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"1", " ", "-", " ", 
                    RowBox[{
                    RowBox[{"n12", "^", "2"}], "*", 
                    RowBox[{
                    "raytiltx", "^", "\n", "                        ", 
                    "2"}]}]}], "]"}]}], ")"}]}]}]}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    " ", "=", " ", "dummyvector"}], ";", " ", "1."}], ",", 
                    " ", "\n", "                       ", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    " ", ".", " ", 
                    RowBox[{"surfnorm", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], " ", ">", " ", "0"}], 
                    ",", " ", 
                    RowBox[{
                    "phaseshift", " ", "=", " ", "\n", 
                    "                        ", 
                    RowBox[{"phaseshift", " ", "+", " ", "0.5"}]}], ",", " ", 
                    "1."}], "]"}], ";", " ", 
                    RowBox[{"index2", " ", "=", " ", "index1"}], ";", " ", 
                    RowBox[{
                    "index", " ", "=", " ", "\n", "                        ", 
                    "index1"}], ";", " ", 
                    RowBox[{"dummyvector", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    " ", "-", " ", 
                    RowBox[{
                    "2", "*", "ZAxis", "*", "\n", "                        ", 
                    
                    RowBox[{"ZAxis", " ", ".", " ", 
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], 
                    "}"}]}]}]}]}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    " ", "=", " ", "\n", "                        ", 
                    "dummyvector"}], ";", " ", 
                    RowBox[{"dummyvector", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], " ", "+", " ", "\n", "                        ", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", " ", "0", ",", " ", 
                    RowBox[{"-", "180"}]}], "}"}]}]}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], " ", "=", " ", "dummyvector"}], ";", " ", "\n", 
                    "                        ", "1."}]}], "]"}], ";", " ", 
                    RowBox[{"allcreatedrays", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "\n", 
                    "                        ", "rez", ",", " ", "r1", ",", 
                    " ", "r2", ",", " ", "r3", ",", " ", "r4", ",", " ", "r5",
                     ",", " ", "r6", ",", " ", "r7", ",", " ", "r8", ",", " ",
                     "r9", ",", " ", "\n", "                        ", 
                    "wavelength", ",", " ", "intensity", ",", " ", 
                    "intensityscale", ",", " ", "ray1", ",", " ", "\n", 
                    "                        ", "index", ",", " ", 
                    "opticallength", ",", " ", "phaseshift", ",", " ", "\n", 
                    "                        ", "componentnumber", ",", " ", 
                    "surfacenumber", ",", " ", "surfaceid", ",", " ", "ray2", 
                    ",", " ", "\n", "                        ", "ray3", ",", 
                    " ", "sid", ",", " ", "frontid", ",", " ", "sno1", ",", 
                    " ", "sno2", ",", " ", "sno3", ",", " ", "sno4", ",", " ",
                     "\n", "                        ", "rayslot", ",", " ", 
                    "generationnumber", ",", " ", "intersectionnumber", ",", 
                    " ", "\n", "                        ", "pol1", ",", " ", 
                    "pol2", ",", " ", "pol3"}], "}"}], "}"}]}], ";", " ", 
                    RowBox[{"originalrotation", " ", "=", " ", 
                    RowBox[{
                    "Partition", "[", "\n", "                        ", 
                    RowBox[{
                    RowBox[{"Take", "[", 
                    RowBox[{"originalray", ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"7", ",", " ", "15"}], "}"}]}], "]"}], ",", " ", 
                    "3"}], "]"}]}], ";", " ", 
                    RowBox[{
                    "previoustilt", " ", "=", " ", "\n", 
                    "                       ", 
                    RowBox[{"originalrotation", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], ";", " ", 
                    RowBox[{"transmatrix", " ", "=", " ", 
                    RowBox[{
                    "MapIndexed", "[", "\n", "                        ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "rez", ",", " ", "r1", ",", 
                    " ", "r2", ",", " ", "r3", ",", " ", "r4", ",", " ", "\n",
                     "                        ", "r5", ",", " ", "r6", ",", 
                    " ", "r7", ",", " ", "r8", ",", " ", "r9", ",", " ", 
                    "wavelength", ",", " ", "intensity", ",", " ", "\n", 
                    "                        ", "intensityscale", ",", " ", 
                    "ray1", ",", " ", "index", ",", " ", "opticallength", ",",
                     " ", "\n", "                        ", "phaseshift", ",",
                     " ", "componentnumber", ",", " ", "surfacenumber", ",", 
                    " ", "\n", "                        ", "surfaceid", ",", 
                    " ", "ray2", ",", " ", "ray3", ",", " ", "sid", ",", " ", 
                    "frontid", ",", " ", "sno1", ",", " ", "sno2", ",", " ", 
                    "\n", "                        ", "sno3", ",", " ", 
                    "sno4", ",", " ", "rayslot", ",", " ", 
                    "oldgenerationnumber", ",", " ", "\n", 
                    "                        ", "intersectionnumber", ",", 
                    " ", "pol1", ",", " ", "pol2", ",", " ", "pol3"}], "}"}], 
                    " ", "=", " ", "#1"}], ";", " ", "\n", 
                    "                        ", 
                    RowBox[{"rotationaxis", " ", "=", " ", 
                    RowBox[{"Cross", "[", 
                    RowBox[{"previoustilt", ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "r1", ",", " ", "r2", ",", " ", "\n", 
                    "                        ", "r3"}], "}"}]}], "]"}]}], ";",
                     " ", 
                    RowBox[{"axismagnitude", " ", "=", " ", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{
                    "rotationaxis", " ", ".", " ", "\n", 
                    "                        ", "rotationaxis"}], "]"}]}], 
                    ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Chop", "[", "axismagnitude", "]"}], " ", "!=", 
                    " ", "0."}], ",", " ", "\n", "                        ", 
                    RowBox[{
                    RowBox[{"rotationaxis", " ", "=", " ", 
                    RowBox[{"rotationaxis", "/", "axismagnitude"}]}], ";", 
                    " ", "\n", "                        ", 
                    RowBox[{"axismatrix", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"#1", "*", "rotationaxis"}], " ", "&"}], " ", 
                    ")"}], " ", "/@", " ", "\n", "                        ", 
                    "rotationaxis"}]}], ";", " ", 
                    RowBox[{"crossmatrix", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", 
                    RowBox[{"-", 
                    RowBox[{"rotationaxis", "[", 
                    RowBox[{"[", "\n", "                        ", "3", "]"}],
                     "]"}]}], ",", " ", 
                    RowBox[{"rotationaxis", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"rotationaxis", "[", 
                    RowBox[{"[", "3", "]"}], "]"}], ",", " ", "0.", ",", " ", 
                    "\n", "                        ", 
                    RowBox[{"-", 
                    RowBox[{"rotationaxis", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}]}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"rotationaxis", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], ",", " ", "\n", 
                    "                        ", 
                    RowBox[{"rotationaxis", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], ",", " ", "0."}], "}"}]}],
                     "}"}]}], ";", " ", 
                    RowBox[{
                    "cosangle", " ", "=", " ", "\n", 
                    "                        ", 
                    RowBox[{"previoustilt", " ", ".", " ", 
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}]}]}],
                     ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"1.", " ", "-", " ", "cosangle"}], " ", "<", " ", 
                    "\n", "                        ", 
                    "2.220446049250313*^-16"}], ",", " ", 
                    RowBox[{"cosangle", " ", "=", " ", "1."}]}], "]"}], ";", 
                    " ", "\n", "                        ", 
                    RowBox[{"sinangle", " ", "=", " ", 
                    RowBox[{"1", " ", "-", " ", 
                    RowBox[{"cosangle", "^", "2"}]}]}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    "sinangle", " ", "<", " ", "\n", 
                    "                        ", "2.220446049250313*^-16"}], 
                    ",", " ", 
                    RowBox[{"sinangle", " ", "=", " ", "0."}], ",", " ", "\n",
                     "                        ", 
                    RowBox[{"sinangle", " ", "=", " ", 
                    RowBox[{"Sqrt", "[", "sinangle", "]"}]}]}], "]"}], ";", 
                    " ", 
                    RowBox[{
                    "axismatrix", " ", "+", " ", "\n", 
                    "                        ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"1.", ",", " ", "0.", ",", " ", "0."}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "1.", ",", " ", "0."}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "0.", ",", " ", "1."}], "}"}]}], 
                    "}"}], " ", "-", " ", "\n", "                        ", 
                    "axismatrix"}], ")"}], "*", "cosangle"}], " ", "+", " ", 
                    RowBox[{"crossmatrix", "*", "sinangle"}]}]}], ",", " ", 
                    "\n", "                        ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"r4", ",", " ", "r5", ",", " ", "r6"}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"r7", ",", " ", "r8", ",", " ", "r9"}], "}"}]}], 
                    "}"}], " ", "=", " ", "\n", "                        ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Sign", "[", 
                    RowBox[{"previoustilt", " ", ".", " ", 
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}]}], 
                    "]"}], " ", "===", " ", "1"}], ",", " ", "\n", 
                    "                        ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"1.", ",", " ", "0.", ",", " ", "0."}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "1.", ",", " ", "0."}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "0.", ",", " ", "1."}], "}"}]}], 
                    "}"}], ",", " ", "\n", "                        ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", 
                    RowBox[{"-", "1."}], ",", " ", "0."}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "0.", ",", " ", "0.", ",", " ", "\n", 
                    "                        ", 
                    RowBox[{"-", "1."}]}], "}"}]}], "}"}]}], "]"}]}]}], 
                    "]"}]}], ")"}], " ", "&"}], " ", ",", " ", 
                    "allcreatedrays"}], "]"}]}], ";", " ", 
                    RowBox[{
                    "allcreatedrays", " ", "=", " ", "\n", 
                    "                       ", 
                    RowBox[{"MapIndexed", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "rez", ",", " ", "r1", ",", 
                    " ", "\n", "                        ", "r2", ",", " ", 
                    "r3", ",", " ", "r4", ",", " ", "r5", ",", " ", "r6", ",",
                     " ", "r7", ",", " ", "r8", ",", " ", "r9", ",", " ", 
                    "wavelength", ",", " ", "\n", "                        ", 
                    "intensity", ",", " ", "intensityscale", ",", " ", "ray1",
                     ",", " ", "index", ",", " ", "\n", 
                    "                        ", "opticallength", ",", " ", 
                    "phaseshift", ",", " ", "componentnumber", ",", " ", "\n",
                     "                        ", "surfacenumber", ",", " ", 
                    "surfaceid", ",", " ", "ray2", ",", " ", "ray3", ",", " ",
                     "sid", ",", " ", "\n", "                        ", 
                    "frontid", ",", " ", "sno1", ",", " ", "sno2", ",", " ", 
                    "sno3", ",", " ", "sno4", ",", " ", "rayslot", ",", " ", 
                    "\n", "                        ", "oldgenerationnumber", 
                    ",", " ", "intersectionnumber", ",", " ", "pol1", ",", 
                    " ", "\n", "                        ", "pol2", ",", " ", 
                    "pol3"}], "}"}], " ", "=", " ", "#1"}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"r4", ",", " ", "r5", ",", " ", "r6"}], "}"}], 
                    ",", " ", "\n", "                        ", 
                    RowBox[{"{", 
                    RowBox[{"r7", ",", " ", "r8", ",", " ", "r9"}], "}"}]}], 
                    "}"}], " ", "=", " ", 
                    RowBox[{
                    RowBox[{"Function", "[", 
                    RowBox[{"mm", ",", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"mm", " ", ".", " ", "#1"}], " ", "&"}], " ", 
                    ")"}], " ", "/@", " ", "\n", "                        ", 
                    "originalrotation"}]}], "]"}], "[", 
                    RowBox[{"transmatrix", "[", 
                    RowBox[{"[", 
                    RowBox[{"First", "[", "#2", "]"}], "]"}], "]"}], "]"}]}], 
                    ";", " ", "\n", "                        ", 
                    RowBox[{"tiltmagnitude", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    " ", ".", " ", 
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}]}]}],
                     ";", " ", "\n", "                        ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", 
                    RowBox[{"tiltmagnitude", " ", "-", " ", "1."}], "]"}], 
                    " ", ">", " ", "1.*^-6"}], ",", " ", "\n", 
                    "                        ", 
                    RowBox[{
                    RowBox[{"dummyvector", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    "/", 
                    RowBox[{"Sqrt", "[", "tiltmagnitude", "]"}]}]}], ";", " ",
                     "\n", "                        ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    " ", "=", " ", "dummyvector"}], ";", " ", 
                    RowBox[{
                    "dummymatrix", " ", "=", " ", "\n", 
                    "                        ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"#1", "/", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"#1", " ", ".", " ", "#1"}], "]"}]}], " ", "&"}], 
                    " ", ")"}], " ", "/@", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "r4", ",", " ", "r5", ",", " ", "\n", 
                    "                        ", "r6"}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"r7", ",", " ", "r8", ",", " ", "r9"}], "}"}]}], 
                    "}"}]}]}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"r4", ",", " ", "r5", ",", " ", "r6"}], "}"}], 
                    ",", " ", "\n", "                        ", 
                    RowBox[{"{", 
                    RowBox[{"r7", ",", " ", "r8", ",", " ", "r9"}], "}"}]}], 
                    "}"}], " ", "=", " ", "dummymatrix"}], ";", " ", "1."}], 
                    ",", " ", "1."}], "]"}], ";", " ", "\n", 
                    "                        ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"allcreatedamplitudes", " ", "!=", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"I", "*", "0."}], ",", " ", 
                    RowBox[{"I", "*", "0."}], ",", " ", 
                    RowBox[{"I", "*", "0."}]}], "}"}], "}"}]}], ",", " ", 
                    "\n", "                        ", 
                    RowBox[{
                    RowBox[{"amplitude", " ", "=", " ", 
                    RowBox[{"allcreatedamplitudes", "[", 
                    RowBox[{"[", 
                    RowBox[{"First", "[", "#2", "]"}], "]"}], "]"}]}], ";", 
                    " ", "\n", "                        ", 
                    RowBox[{"hor", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r4", ",", " ", "r5", ",", " ", "r6"}], "}"}], 
                    " ", ".", " ", "amplitude"}]}], ";", " ", 
                    RowBox[{"ver", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "r7", ",", " ", "r8", ",", " ", "\n", 
                    "                        ", "r9"}], "}"}], " ", ".", " ", 
                    "amplitude"}]}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", "hor", "]"}], " ", ">", " ", "0."}], 
                    " ", "||", " ", 
                    RowBox[{
                    RowBox[{"Abs", "[", "ver", "]"}], " ", ">", " ", "\n", 
                    "                        ", "0."}]}], ",", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Abs", "[", "hor", "]"}], ",", " ", 
                    RowBox[{"Abs", "[", "ver", "]"}], ",", " ", "\n", 
                    "                        ", "0."}], "}"}]}], ";", " ", 
                    RowBox[{"dummyvector", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], "/", 
                    RowBox[{"Sqrt", "[", "\n", "                        ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], " ", ".", " ", 
                    RowBox[{"{", 
                    RowBox[{"pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}]}], "]"}]}]}], ";", " ", "\n", 
                    "                        ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], " ", "=", " ", "dummyvector"}], ";", " ", 
                    RowBox[{
                    "dummyvector", " ", "=", " ", "\n", 
                    "                        ", 
                    RowBox[{"ReplacePart", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], ",", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"ver", " ", "==", " ", "0."}], ",", " ", "\n", 
                    "                        ", "0.", ",", " ", 
                    RowBox[{"Arg", "[", "ver", "]"}]}], "]"}], " ", "-", " ", 
                    
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"hor", " ", "==", " ", "0."}], ",", " ", "0.", 
                    ",", " ", 
                    RowBox[{"Arg", "[", "hor", "]"}]}], "]"}]}], ")"}], "/", 
                    "\n", "                        ", "Degree"}], ",", " ", 
                    "3"}], "]"}]}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], " ", "=", " ", "dummyvector"}]}]}], "]"}], ";", 
                    " ", "\n", "                        ", "1."}], ",", " ", 
                    "1."}], "]"}], ";", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "rez", ",", " ", "r1", ",", 
                    " ", "r2", ",", " ", "\n", "                        ", 
                    "r3", ",", " ", "r4", ",", " ", "r5", ",", " ", "r6", ",",
                     " ", "r7", ",", " ", "r8", ",", " ", "r9", ",", " ", 
                    "wavelength", ",", " ", "\n", "                        ", 
                    "intensity", ",", " ", "intensityscale", ",", " ", "ray1",
                     ",", " ", "index", ",", " ", "\n", 
                    "                        ", "opticallength", ",", " ", 
                    "phaseshift", ",", " ", "componentnumber", ",", " ", "\n",
                     "                        ", "surfacenumber", ",", " ", 
                    "surfaceid", ",", " ", "ray2", ",", " ", "ray3", ",", " ",
                     "sid", ",", " ", "\n", "                        ", 
                    "frontid", ",", " ", "sno1", ",", " ", "sno2", ",", " ", 
                    "sno3", ",", " ", "sno4", ",", " ", "rayslot", ",", " ", 
                    "\n", "                        ", "generationnumber", ",",
                     " ", "intersectionnumber", ",", " ", "pol1", ",", " ", 
                    "\n", "                        ", "pol2", ",", " ", 
                    "pol3"}], "}"}]}], ")"}], " ", "&"}], " ", ",", " ", 
                    "allcreatedrays"}], "]"}]}]}], ")"}], ";", " ", "\n", 
                    "                     ", 
                    RowBox[{"{", 
                    RowBox[{"allcreatedrays", ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",",
                     " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", 
                    "1.", ",", " ", "\n", "                        ", "1.", 
                    ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", 
                    "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",",
                     " ", 
                    RowBox[{"-", "9.87654321*^8"}], ",", " ", "\n", 
                    "                        ", "1.", ",", " ", "1.", ",", 
                    " ", "1.", ",", " ", "1.", ",", " ", "0.", ",", " ", 
                    RowBox[{"-", "1."}], ",", " ", 
                    RowBox[{"-", "1."}], ",", " ", 
                    RowBox[{"-", "1."}], ",", " ", "1.", ",", " ", "1.", ",", 
                    " ", "1.", ",", " ", "\n", "                        ", 
                    "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",",
                     " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", 
                    "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1."}], 
                    "}"}], "}"}], ",", " ", "\n", "                      ", 
                    RowBox[{"{", "completedray", "}"}]}], "}"}]}], ",", " ", 
                    RowBox[{"resonatenumber", " ", "==", " ", "3"}], ",", " ",
                     "\n", "                    ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "rez", ",", " ", "r1", ",", 
                    " ", "r2", ",", " ", "r3", ",", " ", "r4", ",", " ", "r5",
                     ",", " ", "\n", "                       ", "r6", ",", 
                    " ", "r7", ",", " ", "r8", ",", " ", "r9", ",", " ", 
                    "wavelength", ",", " ", "intensity", ",", " ", "\n", 
                    "                       ", "intensityscale", ",", " ", 
                    "ray1", ",", " ", "index", ",", " ", "opticallength", ",",
                     " ", "\n", "                       ", "phaseshift", ",", 
                    " ", "componentnumber", ",", " ", "surfacenumber", ",", 
                    " ", "\n", "                       ", "surfaceid", ",", 
                    " ", "ray2", ",", " ", "ray3", ",", " ", "sid", ",", " ", 
                    "frontid", ",", " ", "sno1", ",", " ", "sno2", ",", " ", 
                    "\n", "                       ", "sno3", ",", " ", "sno4",
                     ",", " ", "rayslot", ",", " ", "oldgenerationnumber", 
                    ",", " ", "\n", "                       ", 
                    "intersectionnumber", ",", " ", "pol1", ",", " ", "pol2", 
                    ",", " ", "pol3"}], "}"}], " ", "=", " ", "#1"}], ";", 
                    " ", "\n", "                     ", 
                    RowBox[{"index1", " ", "=", " ", "index"}], ";", " ", 
                    RowBox[{"xunit", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"r1", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", "\n", "                        ", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]13"}], 
                    "]"}], "]"}]}], " ", "+", " ", 
                    RowBox[{"r2", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", "\n", "                        ", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]13"}], 
                    "]"}], "]"}]}]}]}], ";", " ", 
                    RowBox[{
                    "yunit", " ", "=", " ", "\n", "                      ", 
                    RowBox[{
                    RowBox[{"r2", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]13"}], 
                    "]"}], "]"}]}], " ", "-", " ", 
                    RowBox[{
                    "1.", "*", "r1", "*", "\n", "                        ", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]13"}], 
                    "]"}], "]"}]}]}]}], ";", " ", 
                    RowBox[{
                    "zunit", " ", "=", " ", "\n", "                      ", 
                    RowBox[{"r3", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]13"}], 
                    "]"}], "^", "2"}], " ", "+", " ", "\n", 
                    "                        ", 
                    RowBox[{
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]13"}], 
                    "]"}], "^", "2"}]}], "]"}]}]}], ";", " ", 
                    RowBox[{
                    "xunit", " ", "=", " ", "\n", "                      ", 
                    RowBox[{"Chop", "[", "xunit", "]"}]}], ";", " ", 
                    RowBox[{"yunit", " ", "=", " ", 
                    RowBox[{"Chop", "[", "yunit", "]"}]}], ";", " ", 
                    RowBox[{
                    "zunit", " ", "=", " ", "\n", "                      ", 
                    RowBox[{"Chop", "[", "zunit", "]"}]}], ";", " ", 
                    RowBox[{"magnitude", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"xunit", "^", "2"}], " ", "+", " ", 
                    RowBox[{"yunit", "^", "2"}], " ", "+", " ", "\n", 
                    "                        ", 
                    RowBox[{"zunit", "^", "2"}]}], ")"}], "^", 
                    RowBox[{"2", "^", 
                    RowBox[{"(", 
                    RowBox[{"-", "1"}], ")"}]}]}]}], ";", " ", 
                    RowBox[{"xunit", " ", "=", " ", 
                    RowBox[{"xunit", "/", "magnitude"}]}], ";", " ", "\n", 
                    "                     ", 
                    RowBox[{"yunit", " ", "=", " ", 
                    RowBox[{"yunit", "/", "magnitude"}]}], ";", " ", 
                    RowBox[{"zunit", " ", "=", " ", 
                    RowBox[{"zunit", "/", "magnitude"}]}], ";", " ", "\n", 
                    "                     ", 
                    RowBox[{"rx", " ", "=", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]13"}], 
                    "]"}], "]"}], "*", 
                    RowBox[{"(", 
                    RowBox[{
                    "rex", " ", "-", " ", "\n", "                        ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"x13", " ", "+", " ", 
                    RowBox[{"9.6", "*", 
                    RowBox[{"Cos", "[", 
                    RowBox[{
                    "0.017453292519943295", "*", "\n", 
                    "                        ", "\[Theta]13"}], "]"}]}]}], 
                    "]"}]}]}], ")"}]}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"rey", " ", "-", " ", 
                    RowBox[{"9.6", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", "\n", "                        ", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]13"}], 
                    "]"}], "]"}]}]}], ")"}], "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", "\n", "                        ", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]13"}], 
                    "]"}], "]"}]}]}]}], ";", " ", 
                    RowBox[{
                    "ry", " ", "=", " ", "\n", "                      ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]13"}], 
                    "]"}], "]"}], "*", 
                    RowBox[{"(", 
                    RowBox[{
                    "rey", " ", "-", " ", "\n", "                        ", 
                    RowBox[{"9.6", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]13"}], 
                    "]"}], "]"}]}]}], ")"}]}], " ", "-", " ", "\n", 
                    "                       ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"(", 
                    RowBox[{"rex", " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"x13", " ", "+", " ", 
                    RowBox[{"9.6", "*", 
                    RowBox[{"Cos", "[", "\n", "                        ", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]13"}], 
                    "]"}]}]}], "]"}]}]}], ")"}], "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", "\n", "                        ", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]13"}], 
                    "]"}], "]"}]}]}]}], ";", " ", 
                    RowBox[{"rz", " ", "=", " ", 
                    RowBox[{"rez", "*", "\n", "                       ", 
                    RowBox[{"Re", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]13"}], 
                    "]"}], "^", "2"}], " ", "+", " ", "\n", 
                    "                        ", 
                    RowBox[{
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]13"}], 
                    "]"}], "^", "2"}]}], "]"}]}]}], ";", " ", 
                    RowBox[{
                    "rx", " ", "=", " ", "\n", "                      ", 
                    RowBox[{"Chop", "[", "rx", "]"}]}], ";", " ", 
                    RowBox[{"ry", " ", "=", " ", 
                    RowBox[{"Chop", "[", "ry", "]"}]}], ";", " ", 
                    RowBox[{"rz", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rz", "]"}]}], ";", " ", "\n", 
                    "                     ", 
                    RowBox[{"terminatedeflection", " ", "=", " ", "False"}], 
                    ";", " ", 
                    RowBox[{
                    "intersections", " ", "=", " ", "\n", 
                    "                      ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}], "}"}]}], ";", " ", 
                    RowBox[{
                    "intersections", " ", "=", " ", "\n", 
                    "                      ", "resonateintersections"}], ";", 
                    " ", 
                    RowBox[{"holeQ", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"holeQlist", "[", 
                    RowBox[{
                    "[", "\n", "                        ", "resonatenumber", 
                    "]"}], "]"}], " ", "==", " ", "1"}]}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "newcomponentnumber", ",", " ", "\n", 
                    "                       ", "newsurfacenumber", ",", " ", 
                    "newsurfaceid"}], "}"}], " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"1.", ",", " ", "3.", ",", " ", "\n", 
                    "                       ", "92157."}], "}"}]}], ";", " ", 
                    
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "componentnumber", ",", " ", "surfacenumber", ",", " ", 
                    "\n", "                       ", "surfaceid"}], "}"}], 
                    " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"1.", ",", " ", "3.", ",", " ", "92157."}], 
                    "}"}]}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "ray1", ",", " ", "ray2", ",", " ", "\n", 
                    "                       ", "ray3"}], "}"}], " ", "=", " ", 
                    RowBox[{"intersections", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], ";", " ", 
                    RowBox[{"rsx", " ", "=", " ", "rex"}], ";", " ", 
                    RowBox[{"rsy", " ", "=", " ", "rey"}], ";", " ", "\n", 
                    "                     ", 
                    RowBox[{"rsz", " ", "=", " ", "rez"}], ";", " ", 
                    RowBox[{"rxhlp", " ", "=", " ", 
                    RowBox[{"rx", " ", "+", " ", 
                    RowBox[{"ray1", "*", "xunit"}]}]}], ";", " ", 
                    RowBox[{
                    "ryhlp", " ", "=", " ", "\n", "                      ", 
                    RowBox[{"ry", " ", "+", " ", 
                    RowBox[{"ray1", "*", "yunit"}]}]}], ";", " ", 
                    RowBox[{"rzhlp", " ", "=", " ", 
                    RowBox[{"rz", " ", "+", " ", 
                    RowBox[{"ray1", "*", "zunit"}]}]}], ";", " ", "\n", 
                    "                     ", 
                    RowBox[{"rex", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"rxhlp", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]13"}], 
                    "]"}], "]"}]}], " ", "+", " ", "\n", 
                    "                       ", 
                    RowBox[{"Re", "[", 
                    RowBox[{"x13", " ", "+", " ", 
                    RowBox[{"9.6", "*", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]13"}], 
                    "]"}]}]}], "]"}], " ", "-", " ", "\n", 
                    "                       ", 
                    RowBox[{"1.", "*", "ryhlp", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]13"}], 
                    "]"}], "]"}]}]}]}], ";", " ", "\n", 
                    "                     ", 
                    RowBox[{"rey", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"ryhlp", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]13"}], 
                    "]"}], "]"}]}], " ", "+", " ", "\n", 
                    "                       ", 
                    RowBox[{"9.6", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]13"}], 
                    "]"}], "]"}]}], " ", "+", " ", "\n", 
                    "                       ", 
                    RowBox[{"rxhlp", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]13"}], 
                    "]"}], "]"}]}]}]}], ";", " ", "\n", 
                    "                     ", 
                    RowBox[{"rez", " ", "=", " ", 
                    RowBox[{"rzhlp", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]13"}], 
                    "]"}], "^", "2"}], " ", "+", " ", "\n", 
                    "                        ", 
                    RowBox[{
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]13"}], 
                    "]"}], "^", "2"}]}], "]"}]}]}], ";", " ", 
                    RowBox[{
                    "rex", " ", "=", " ", "\n", "                      ", 
                    RowBox[{"Chop", "[", "rex", "]"}]}], ";", " ", 
                    RowBox[{"rey", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rey", "]"}]}], ";", " ", 
                    RowBox[{"rez", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rez", "]"}]}], ";", " ", "\n", 
                    "                     ", 
                    RowBox[{"intersectionnumber", " ", "=", " ", 
                    RowBox[{"intersectionnumber", " ", "+", " ", "1."}]}], 
                    ";", " ", "\n", "                     ", 
                    RowBox[{"opticallength", " ", "=", " ", 
                    RowBox[{"opticallength", " ", "+", " ", 
                    RowBox[{"ray1", "*", "index1"}]}]}], ";", " ", "\n", 
                    "                     ", 
                    RowBox[{"completedray", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "rez", ",", " ", "r1", ",", 
                    " ", "\n", "                       ", "r2", ",", " ", 
                    "r3", ",", " ", "r4", ",", " ", "r5", ",", " ", "r6", ",",
                     " ", "r7", ",", " ", "r8", ",", " ", "r9", ",", " ", 
                    "wavelength", ",", " ", "\n", "                       ", 
                    "intensity", ",", " ", "intensityscale", ",", " ", "ray1",
                     ",", " ", "index", ",", " ", "\n", 
                    "                       ", "opticallength", ",", " ", 
                    "phaseshift", ",", " ", "componentnumber", ",", " ", "\n",
                     "                       ", "surfacenumber", ",", " ", 
                    "surfaceid", ",", " ", "ray2", ",", " ", "ray3", ",", " ",
                     "sid", ",", " ", "\n", "                       ", 
                    "frontid", ",", " ", "sno1", ",", " ", "sno2", ",", " ", 
                    "sno3", ",", " ", "sno4", ",", " ", "rayslot", ",", " ", 
                    "\n", "                       ", "generationnumber", ",", 
                    " ", "intersectionnumber", ",", " ", "pol1", ",", " ", 
                    "pol2", ",", " ", "\n", "                       ", 
                    "pol3"}], "}"}]}], ";", " ", 
                    RowBox[{"reportedrayspresent", " ", "=", " ", "True"}], 
                    ";", " ", "\n", "                     ", 
                    RowBox[{"intersectionspresent", " ", "=", " ", "True"}], 
                    ";", " ", 
                    RowBox[{
                    "deflectedrayspresent", " ", "=", " ", "\n", 
                    "                      ", "True"}], ";", " ", 
                    RowBox[{
                    "localdummyoutrayspresent", " ", "=", " ", "True"}], ";", 
                    " ", "\n", "                     ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"surfnorm", " ", "=", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"1.", ",", " ", 
                    RowBox[{
                    RowBox[{"-", "1."}], "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"Sign", "[", "r13", "]"}], "*", "ray2"}], ")"}], 
                    "/", "\n", "                        ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"r13", "^", "2"}], " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"ray2", "^", "2"}]}], " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"ray3", "^", "2"}]}]}], ")"}], "^", "0.5"}]}], 
                    ")"}]}], ",", " ", 
                    RowBox[{
                    RowBox[{"-", "1."}], "*", "\n", 
                    "                        ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"Sign", "[", "r13", "]"}], "*", "ray3"}], ")"}], 
                    "/", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"r13", "^", "2"}], " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"ray2", "^", "2"}]}], " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{
                    "ray3", "^", "\n", "                        ", "2"}]}]}], 
                    ")"}], "^", "0.5"}]}], ")"}]}]}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"Sign", "[", "r13", "]"}], "*", "ray2"}], ")"}], 
                    "/", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"r13", "^", "2"}], " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"ray2", "^", "2"}]}], " ", "-", " ", "\n", 
                    "                        ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"ray3", "^", "2"}]}]}], ")"}], "^", "0.5"}]}], 
                    ",", " ", "1.", ",", " ", "0."}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"Sign", "[", "r13", "]"}], "*", "ray3"}], ")"}], 
                    "/", "\n", "                        ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"r13", "^", "2"}], " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"ray2", "^", "2"}]}], " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"ray3", "^", "2"}]}]}], ")"}], "^", "0.5"}]}], 
                    ",", " ", "0.", ",", " ", "1."}], "}"}]}], "}"}], 
                    "]"}]}]}], ";", " ", "\n", "                      ", 
                    RowBox[{"dummymatrix", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{
                    "0.017453292519943295", "*", "\n", 
                    "                        ", "\[Theta]13"}], "]"}], "]"}], 
                    ",", " ", 
                    RowBox[{
                    RowBox[{"-", "1."}], "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{
                    "0.017453292519943295", "*", "\n", 
                    "                        ", "\[Theta]13"}], "]"}], 
                    "]"}]}], ",", " ", "0."}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{
                    "0.017453292519943295", "*", "\n", 
                    "                        ", "\[Theta]13"}], "]"}], "]"}], 
                    ",", " ", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]13"}], 
                    "]"}], "]"}], ",", " ", "\n", "                        ", 
                    "0."}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "0.", ",", " ", "1."}], "}"}]}], 
                    "}"}], " ", ".", " ", "#1"}], " ", "&"}], " ", ")"}], " ",
                     "/@", " ", "surfnorm"}]}], ";", " ", "\n", 
                    "                      ", 
                    RowBox[{"surfnorm", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"#1", "/", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"#1", " ", ".", " ", "#1"}], "]"}]}], " ", "&"}], 
                    " ", ")"}], " ", "/@", " ", "dummymatrix"}]}], ";", " ", 
                    "\n", "                      ", 
                    RowBox[{"surfacerotationmatrix", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", "\n", "                        ", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]13"}], 
                    "]"}], "]"}], ",", " ", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", "\n", "                        ", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]13"}], 
                    "]"}], "]"}], ",", " ", "0."}], "}"}], ",", " ", "\n", 
                    "                        ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "1."}], "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]13"}], 
                    "]"}], "]"}]}], ",", " ", "\n", 
                    "                        ", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]13"}], 
                    "]"}], "]"}], ",", " ", "0."}], "}"}], ",", " ", "\n", 
                    "                        ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "0.", ",", " ", "1."}], "}"}]}], 
                    "}"}]}], ";", " ", 
                    RowBox[{"surfacetranslationvector", " ", "=", " ", "\n", 
                    "                       ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"x13", " ", "+", " ", 
                    RowBox[{"9.6", "*", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]13"}], 
                    "]"}]}]}], "]"}], ",", " ", "\n", 
                    "                        ", 
                    RowBox[{"9.6", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]13"}], 
                    "]"}], "]"}]}], ",", " ", "0."}], "}"}]}], ";", " ", "\n",
                     "                      ", 
                    RowBox[{"activeregion", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"completedray", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "\n", 
                    "                        ", "rex", ",", " ", "rey", ",", 
                    " ", "rez", ",", " ", "r1", ",", " ", "r2", ",", " ", 
                    "r3", ",", " ", "r4", ",", " ", "r5", ",", " ", "r6", ",",
                     " ", "r7", ",", " ", "r8", ",", " ", "\n", 
                    "                        ", "r9", ",", " ", "wavelength", 
                    ",", " ", "intensity", ",", " ", "intensityscale", ",", 
                    " ", "ray1", ",", " ", "\n", "                        ", 
                    "index", ",", " ", "opticallength", ",", " ", 
                    "phaseshift", ",", " ", "\n", "                        ", 
                    "componentnumber", ",", " ", "surfacenumber", ",", " ", 
                    "surfaceid", ",", " ", "ray2", ",", " ", "\n", 
                    "                        ", "ray3", ",", " ", "sid", ",", 
                    " ", "frontid", ",", " ", "sno1", ",", " ", "sno2", ",", 
                    " ", "sno3", ",", " ", "sno4", ",", " ", "\n", 
                    "                        ", "rayslot", ",", " ", 
                    "generationnumber", ",", " ", "intersectionnumber", ",", 
                    " ", "\n", "                        ", "pol1", ",", " ", 
                    "pol2", ",", " ", "pol3"}], "}"}]}], ";", " ", 
                    RowBox[{
                    "componentnumber", " ", "=", " ", "\n", 
                    "                       ", "newcomponentnumber"}], ";", 
                    " ", 
                    RowBox[{
                    "surfacenumber", " ", "=", " ", "\n", 
                    "                       ", "newsurfacenumber"}], ";", " ", 
                    RowBox[{"surfaceid", " ", "=", " ", "newsurfaceid"}], ";",
                     " ", "\n", "                      ", 
                    RowBox[{"originalray", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "rez", ",", " ", "r1", ",", 
                    " ", "\n", "                        ", "r2", ",", " ", 
                    "r3", ",", " ", "r4", ",", " ", "r5", ",", " ", "r6", ",",
                     " ", "r7", ",", " ", "r8", ",", " ", "r9", ",", " ", 
                    "wavelength", ",", " ", "\n", "                        ", 
                    "intensity", ",", " ", "intensityscale", ",", " ", "ray1",
                     ",", " ", "index", ",", " ", "\n", 
                    "                        ", "opticallength", ",", " ", 
                    "phaseshift", ",", " ", "componentnumber", ",", " ", "\n",
                     "                        ", "surfacenumber", ",", " ", 
                    "surfaceid", ",", " ", "ray2", ",", " ", "ray3", ",", " ",
                     "sid", ",", " ", "\n", "                        ", 
                    "frontid", ",", " ", "sno1", ",", " ", "sno2", ",", " ", 
                    "sno3", ",", " ", "sno4", ",", " ", "rayslot", ",", " ", 
                    "\n", "                        ", "generationnumber", ",",
                     " ", "intersectionnumber", ",", " ", "pol1", ",", " ", 
                    "\n", "                        ", "pol2", ",", " ", 
                    "pol3"}], "}"}]}], ";", " ", 
                    RowBox[{"ZAxis", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"First", "[", "surfnorm", "]"}], "*", 
                    RowBox[{"Sign", "[", "\n", "                        ", 
                    RowBox[{
                    RowBox[{"First", "[", "surfnorm", "]"}], " ", ".", " ", 
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}]}], 
                    "]"}]}]}], ";", " ", 
                    RowBox[{
                    "raytiltz", " ", "=", " ", "\n", 
                    "                       ", 
                    RowBox[{"ZAxis", " ", ".", " ", 
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}]}]}],
                     ";", " ", 
                    RowBox[{"raytiltx", " ", "=", " ", 
                    RowBox[{"1", " ", "-", " ", 
                    RowBox[{"raytiltz", "^", "2"}]}]}], ";", " ", "\n", 
                    "                      ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    "raytiltx", " ", "<", " ", "2.220446049250313*^-16"}], 
                    ",", " ", 
                    RowBox[{
                    "raytiltx", " ", "=", " ", "\n", 
                    "                        ", "0."}], ",", " ", 
                    RowBox[{"raytiltx", " ", "=", " ", 
                    RowBox[{"Sqrt", "[", "raytiltx", "]"}]}]}], "]"}], ";", 
                    " ", 
                    RowBox[{
                    "XAxis", " ", "=", " ", "\n", "                       ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    " ", "-", " ", 
                    RowBox[{"ZAxis", "*", "raytiltz"}]}]}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", "raytiltx", "]"}], " ", "<", " ", 
                    "\n", "                        ", "1.*^-7"}], ",", " ", 
                    RowBox[{"XAxis", " ", "=", " ", 
                    RowBox[{"surfnorm", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], ",", " ", 
                    RowBox[{"XAxis", " ", "=", " ", 
                    RowBox[{"XAxis", "/", "\n", "                        ", 
                    "raytiltx"}]}]}], "]"}], ";", " ", 
                    RowBox[{"YAxis", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"ZAxis", "[", 
                    RowBox[{"[", "3", "]"}], "]"}], "*", 
                    RowBox[{"XAxis", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], ")"}]}], " ", "+", " ", 
                    "\n", "                        ", 
                    RowBox[{
                    RowBox[{"ZAxis", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "*", 
                    RowBox[{"XAxis", "[", 
                    RowBox[{"[", "3", "]"}], "]"}]}]}], ",", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"ZAxis", "[", 
                    RowBox[{"[", "3", "]"}], "]"}], "*", 
                    RowBox[{"XAxis", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], " ", "-", " ", "\n", 
                    "                        ", 
                    RowBox[{
                    RowBox[{"ZAxis", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "*", 
                    RowBox[{"XAxis", "[", 
                    RowBox[{"[", "3", "]"}], "]"}]}]}], ",", " ", 
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"ZAxis", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "*", 
                    RowBox[{"XAxis", "[", 
                    RowBox[{"[", "\n", "                        ", "1", "]"}],
                     "]"}]}], ")"}]}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"ZAxis", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "*", 
                    RowBox[{"XAxis", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}]}]}], "}"}]}], ";", " ", 
                    RowBox[{"YAxis", " ", "=", " ", 
                    RowBox[{"YAxis", "/", "\n", "                        ", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"YAxis", " ", ".", " ", "YAxis"}], "]"}]}]}], ";",
                     " ", 
                    RowBox[{"PAxis", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"ZAxis", "*", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "r1", ",", " ", "r2", ",", " ", "\n", 
                    "                        ", "r3"}], "}"}], " ", ".", " ", 
                    "XAxis"}]}], " ", "-", " ", 
                    RowBox[{"XAxis", "*", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    " ", ".", " ", "ZAxis"}]}]}]}], ";", " ", "\n", 
                    "                      ", 
                    RowBox[{"PAxis", " ", "=", " ", 
                    RowBox[{"PAxis", "/", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"PAxis", " ", ".", " ", "PAxis"}], "]"}]}]}], ";",
                     " ", "\n", "                      ", 
                    RowBox[{"normalizedpolarization", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], "[", 
                    RowBox[{"[", "\n", "                        ", 
                    RowBox[{"{", 
                    RowBox[{"1", ",", " ", "2"}], "}"}], "]"}], "]"}]}], ";", 
                    " ", 
                    RowBox[{
                    "normalizedpolarization", " ", "=", " ", "\n", 
                    "                       ", 
                    RowBox[{"normalizedpolarization", "/", 
                    RowBox[{"Sqrt", "[", "\n", "                        ", 
                    RowBox[{
                    "normalizedpolarization", " ", ".", " ", "\n", 
                    "                        ", "normalizedpolarization"}], 
                    "]"}]}]}], ";", " ", 
                    RowBox[{
                    "allcreatedamplitudes", " ", "=", " ", "\n", 
                    "                       ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"I", "*", "0."}], ",", " ", 
                    RowBox[{"I", "*", "0."}], ",", " ", 
                    RowBox[{"I", "*", "0."}]}], "}"}], "}"}]}], ";", " ", 
                    RowBox[{"amplitude", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"Sqrt", "[", "intensity", "]"}], "*", "\n", 
                    "                        ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"normalizedpolarization", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "*", 
                    RowBox[{"{", 
                    RowBox[{"r4", ",", " ", "r5", ",", " ", "r6"}], "}"}]}], 
                    " ", "+", " ", "\n", "                        ", 
                    RowBox[{
                    RowBox[{"normalizedpolarization", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "*", 
                    RowBox[{"{", 
                    RowBox[{"r7", ",", " ", "r8", ",", " ", "r9"}], "}"}], 
                    "*", "\n", "                        ", 
                    RowBox[{"Exp", "[", 
                    RowBox[{"I", "*", "pol3", "*", "0.017453292519943295"}], 
                    "]"}]}]}], ")"}]}]}], ";", " ", "\n", 
                    "                      ", 
                    RowBox[{"perpendicularamplitude", " ", "=", " ", 
                    RowBox[{"amplitude", " ", ".", " ", "YAxis"}]}], ";", " ",
                     "\n", "                      ", 
                    RowBox[{"parallelamplitude", " ", "=", " ", 
                    RowBox[{"amplitude", " ", ".", " ", "PAxis"}]}], ";", " ",
                     "\n", "                      ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"activeregion", "*", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"surfacerotationmatrix", " ", ".", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "r1", ",", " ", "r2", ",", " ", "\n", 
                    "                        ", "r3"}], "}"}]}], ")"}], "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], " ", ">", " ", "0"}], 
                    ",", " ", 
                    RowBox[{
                    RowBox[{"index2", " ", "=", " ", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{
                    "2.2718929", " ", "-", " ", "\n", 
                    "                        ", 
                    RowBox[{"0.010108077", "*", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", 
                    RowBox[{
                    "0.010592509", "/", "\n", "                        ", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", 
                    RowBox[{"0.00020816965", "/", 
                    RowBox[{"wavelength", "^", "4"}]}], " ", "-", " ", "\n", 
                    "                        ", 
                    RowBox[{"7.6472538*^-6", "/", 
                    RowBox[{"wavelength", "^", "6"}]}], " ", "+", " ", 
                    RowBox[{
                    "4.9240991*^-7", "/", "\n", "                        ", 
                    RowBox[{"wavelength", "^", "8"}]}]}], "]"}]}], ";", " ", 
                    RowBox[{"index1", " ", "=", " ", "index"}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", 
                    RowBox[{
                    "index2", " ", "-", " ", "\n", "                        ",
                     "index1"}], "]"}], " ", "<", " ", "0.01"}], ",", " ", 
                    RowBox[{
                    RowBox[{"alternateindex", " ", "=", " ", 
                    RowBox[{"Sqrt", "[", "\n", "                        ", 
                    RowBox[{"1.0005281111748805", " ", "-", " ", 
                    RowBox[{
                    "2.364805676582992*^-10", "*", "\n", 
                    "                        ", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", 
                    RowBox[{"2.9781670902982902*^-6", "/", 
                    RowBox[{
                    "wavelength", "^", "\n", "                        ", 
                    "2"}]}], " ", "+", " ", 
                    RowBox[{"2.6004099469477187*^-8", "/", 
                    RowBox[{"wavelength", "^", "4"}]}], " ", "+", " ", "\n", 
                    "                        ", 
                    RowBox[{"3.7787839314048715*^-10", "/", 
                    RowBox[{"wavelength", "^", "6"}]}], " ", "+", " ", "\n", 
                    "                        ", 
                    RowBox[{"2.830549017940716*^-12", "/", 
                    RowBox[{"wavelength", "^", "8"}]}]}], "]"}]}], ";", " ", 
                    "\n", "                        ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", 
                    RowBox[{"alternateindex", " ", "-", " ", "index1"}], 
                    "]"}], " ", ">", " ", 
                    RowBox[{"Abs", "[", 
                    RowBox[{
                    "index2", " ", "-", " ", "\n", "                        ",
                     "index1"}], "]"}]}], ",", " ", 
                    RowBox[{
                    RowBox[{"index1", " ", "=", " ", "index2"}], ";", " ", 
                    RowBox[{
                    "index2", " ", "=", " ", "\n", "                        ",
                     "alternateindex"}]}], ",", " ", 
                    RowBox[{"index1", " ", "=", " ", "alternateindex"}]}], 
                    "]"}]}], ",", " ", "\n", "                        ", 
                    RowBox[{"index1", " ", "=", " ", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{
                    "1.0005281111748805", " ", "-", " ", "\n", 
                    "                        ", 
                    RowBox[{"2.364805676582992*^-10", "*", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", "\n", 
                    "                        ", 
                    RowBox[{"2.9781670902982902*^-6", "/", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", "\n", 
                    "                        ", 
                    RowBox[{"2.6004099469477187*^-8", "/", 
                    RowBox[{"wavelength", "^", "4"}]}], " ", "+", " ", "\n", 
                    "                        ", 
                    RowBox[{"3.7787839314048715*^-10", "/", 
                    RowBox[{"wavelength", "^", "6"}]}], " ", "+", " ", "\n", 
                    "                        ", 
                    RowBox[{"2.830549017940716*^-12", "/", 
                    RowBox[{"wavelength", "^", "8"}]}]}], "]"}]}]}], "]"}]}], 
                    ",", " ", "\n", "                       ", 
                    RowBox[{
                    RowBox[{"index2", " ", "=", " ", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{
                    "1.0005281111748805", " ", "-", " ", "\n", 
                    "                        ", 
                    RowBox[{"2.364805676582992*^-10", "*", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", "\n", 
                    "                        ", 
                    RowBox[{"2.9781670902982902*^-6", "/", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", "\n", 
                    "                        ", 
                    RowBox[{"2.6004099469477187*^-8", "/", 
                    RowBox[{"wavelength", "^", "4"}]}], " ", "+", " ", "\n", 
                    "                        ", 
                    RowBox[{"3.7787839314048715*^-10", "/", 
                    RowBox[{"wavelength", "^", "6"}]}], " ", "+", " ", "\n", 
                    "                        ", 
                    RowBox[{"2.830549017940716*^-12", "/", 
                    RowBox[{"wavelength", "^", "8"}]}]}], "]"}]}], ";", " ", 
                    RowBox[{
                    "index1", " ", "=", " ", "\n", "                        ",
                     "index"}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", 
                    RowBox[{"index2", " ", "-", " ", "index1"}], "]"}], " ", 
                    "<", " ", "0.01"}], ",", " ", "\n", 
                    "                        ", 
                    RowBox[{
                    RowBox[{"alternateindex", " ", "=", " ", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"2.2718929", " ", "-", " ", 
                    RowBox[{
                    "0.010108077", "*", "\n", "                        ", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", 
                    RowBox[{"0.010592509", "/", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", "\n", 
                    "                        ", 
                    RowBox[{"0.00020816965", "/", 
                    RowBox[{"wavelength", "^", "4"}]}], " ", "-", " ", 
                    RowBox[{
                    "7.6472538*^-6", "/", "\n", "                        ", 
                    RowBox[{"wavelength", "^", "6"}]}], " ", "+", " ", 
                    RowBox[{"4.9240991*^-7", "/", 
                    RowBox[{"wavelength", "^", "8"}]}]}], "]"}]}], ";", " ", 
                    "\n", "                        ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", 
                    RowBox[{"alternateindex", " ", "-", " ", "index1"}], 
                    "]"}], " ", ">", " ", 
                    RowBox[{"Abs", "[", 
                    RowBox[{
                    "index2", " ", "-", " ", "\n", "                        ",
                     "index1"}], "]"}]}], ",", " ", 
                    RowBox[{
                    RowBox[{"index1", " ", "=", " ", "index2"}], ";", " ", 
                    RowBox[{
                    "index2", " ", "=", " ", "\n", "                        ",
                     "alternateindex"}]}], ",", " ", 
                    RowBox[{"index1", " ", "=", " ", "alternateindex"}]}], 
                    "]"}]}], ",", " ", "\n", "                        ", 
                    RowBox[{"index1", " ", "=", " ", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"2.2718929", " ", "-", " ", 
                    RowBox[{"0.010108077", "*", 
                    RowBox[{
                    "wavelength", "^", "\n", "                        ", 
                    "2"}]}], " ", "+", " ", 
                    RowBox[{"0.010592509", "/", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", 
                    RowBox[{
                    "0.00020816965", "/", "\n", "                        ", 
                    RowBox[{"wavelength", "^", "4"}]}], " ", "-", " ", 
                    RowBox[{"7.6472538*^-6", "/", 
                    RowBox[{"wavelength", "^", "6"}]}], " ", "+", " ", "\n", 
                    "                        ", 
                    RowBox[{"4.9240991*^-7", "/", 
                    RowBox[{"wavelength", "^", "8"}]}]}], "]"}]}]}], 
                    "]"}]}]}], "]"}], ";", " ", 
                    RowBox[{"n12", " ", "=", " ", 
                    RowBox[{
                    "index1", "/", "\n", "                        ", 
                    "index2"}]}], ";", " ", 
                    RowBox[{"index", " ", "=", " ", "index2"}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"1", " ", "-", " ", 
                    RowBox[{
                    RowBox[{"n12", "^", "2"}], "*", 
                    RowBox[{
                    "raytiltx", "^", "\n", "                        ", 
                    "2"}]}]}], " ", ">=", " ", "0."}], ",", " ", 
                    RowBox[{
                    RowBox[{"dummyvector", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"n12", "*", 
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}]}], 
                    " ", "+", " ", "\n", "                        ", 
                    RowBox[{"ZAxis", "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"(", 
                    RowBox[{"n12", "*", "raytiltz"}], ")"}]}], " ", "+", " ", 
                    
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"1", " ", "-", " ", 
                    RowBox[{
                    RowBox[{"n12", "^", "2"}], "*", 
                    RowBox[{
                    "raytiltx", "^", "\n", "                        ", 
                    "2"}]}]}], "]"}]}], ")"}]}]}]}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    " ", "=", " ", "dummyvector"}], ";", " ", "1."}], ",", 
                    " ", "\n", "                       ", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    " ", ".", " ", 
                    RowBox[{"surfnorm", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], " ", ">", " ", "0"}], 
                    ",", " ", 
                    RowBox[{
                    "phaseshift", " ", "=", " ", "\n", 
                    "                        ", 
                    RowBox[{"phaseshift", " ", "+", " ", "0.5"}]}], ",", " ", 
                    "1."}], "]"}], ";", " ", 
                    RowBox[{"index2", " ", "=", " ", "index1"}], ";", " ", 
                    RowBox[{
                    "index", " ", "=", " ", "\n", "                        ", 
                    "index1"}], ";", " ", 
                    RowBox[{"dummyvector", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    " ", "-", " ", 
                    RowBox[{
                    "2", "*", "ZAxis", "*", "\n", "                        ", 
                    
                    RowBox[{"ZAxis", " ", ".", " ", 
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], 
                    "}"}]}]}]}]}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    " ", "=", " ", "\n", "                        ", 
                    "dummyvector"}], ";", " ", 
                    RowBox[{"dummyvector", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], " ", "+", " ", "\n", "                        ", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", " ", "0", ",", " ", 
                    RowBox[{"-", "180"}]}], "}"}]}]}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], " ", "=", " ", "dummyvector"}], ";", " ", "\n", 
                    "                        ", "1."}]}], "]"}], ";", " ", 
                    RowBox[{"allcreatedrays", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "\n", 
                    "                        ", "rez", ",", " ", "r1", ",", 
                    " ", "r2", ",", " ", "r3", ",", " ", "r4", ",", " ", "r5",
                     ",", " ", "r6", ",", " ", "r7", ",", " ", "r8", ",", " ",
                     "r9", ",", " ", "\n", "                        ", 
                    "wavelength", ",", " ", "intensity", ",", " ", 
                    "intensityscale", ",", " ", "ray1", ",", " ", "\n", 
                    "                        ", "index", ",", " ", 
                    "opticallength", ",", " ", "phaseshift", ",", " ", "\n", 
                    "                        ", "componentnumber", ",", " ", 
                    "surfacenumber", ",", " ", "surfaceid", ",", " ", "ray2", 
                    ",", " ", "\n", "                        ", "ray3", ",", 
                    " ", "sid", ",", " ", "frontid", ",", " ", "sno1", ",", 
                    " ", "sno2", ",", " ", "sno3", ",", " ", "sno4", ",", " ",
                     "\n", "                        ", "rayslot", ",", " ", 
                    "generationnumber", ",", " ", "intersectionnumber", ",", 
                    " ", "\n", "                        ", "pol1", ",", " ", 
                    "pol2", ",", " ", "pol3"}], "}"}], "}"}]}], ";", " ", 
                    RowBox[{"originalrotation", " ", "=", " ", 
                    RowBox[{
                    "Partition", "[", "\n", "                        ", 
                    RowBox[{
                    RowBox[{"Take", "[", 
                    RowBox[{"originalray", ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"7", ",", " ", "15"}], "}"}]}], "]"}], ",", " ", 
                    "3"}], "]"}]}], ";", " ", 
                    RowBox[{
                    "previoustilt", " ", "=", " ", "\n", 
                    "                       ", 
                    RowBox[{"originalrotation", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], ";", " ", 
                    RowBox[{"transmatrix", " ", "=", " ", 
                    RowBox[{
                    "MapIndexed", "[", "\n", "                        ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "rez", ",", " ", "r1", ",", 
                    " ", "r2", ",", " ", "r3", ",", " ", "r4", ",", " ", "\n",
                     "                        ", "r5", ",", " ", "r6", ",", 
                    " ", "r7", ",", " ", "r8", ",", " ", "r9", ",", " ", 
                    "wavelength", ",", " ", "intensity", ",", " ", "\n", 
                    "                        ", "intensityscale", ",", " ", 
                    "ray1", ",", " ", "index", ",", " ", "opticallength", ",",
                     " ", "\n", "                        ", "phaseshift", ",",
                     " ", "componentnumber", ",", " ", "surfacenumber", ",", 
                    " ", "\n", "                        ", "surfaceid", ",", 
                    " ", "ray2", ",", " ", "ray3", ",", " ", "sid", ",", " ", 
                    "frontid", ",", " ", "sno1", ",", " ", "sno2", ",", " ", 
                    "\n", "                        ", "sno3", ",", " ", 
                    "sno4", ",", " ", "rayslot", ",", " ", 
                    "oldgenerationnumber", ",", " ", "\n", 
                    "                        ", "intersectionnumber", ",", 
                    " ", "pol1", ",", " ", "pol2", ",", " ", "pol3"}], "}"}], 
                    " ", "=", " ", "#1"}], ";", " ", "\n", 
                    "                        ", 
                    RowBox[{"rotationaxis", " ", "=", " ", 
                    RowBox[{"Cross", "[", 
                    RowBox[{"previoustilt", ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "r1", ",", " ", "r2", ",", " ", "\n", 
                    "                        ", "r3"}], "}"}]}], "]"}]}], ";",
                     " ", 
                    RowBox[{"axismagnitude", " ", "=", " ", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{
                    "rotationaxis", " ", ".", " ", "\n", 
                    "                        ", "rotationaxis"}], "]"}]}], 
                    ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Chop", "[", "axismagnitude", "]"}], " ", "!=", 
                    " ", "0."}], ",", " ", "\n", "                        ", 
                    RowBox[{
                    RowBox[{"rotationaxis", " ", "=", " ", 
                    RowBox[{"rotationaxis", "/", "axismagnitude"}]}], ";", 
                    " ", "\n", "                        ", 
                    RowBox[{"axismatrix", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"#1", "*", "rotationaxis"}], " ", "&"}], " ", 
                    ")"}], " ", "/@", " ", "\n", "                        ", 
                    "rotationaxis"}]}], ";", " ", 
                    RowBox[{"crossmatrix", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", 
                    RowBox[{"-", 
                    RowBox[{"rotationaxis", "[", 
                    RowBox[{"[", "\n", "                        ", "3", "]"}],
                     "]"}]}], ",", " ", 
                    RowBox[{"rotationaxis", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"rotationaxis", "[", 
                    RowBox[{"[", "3", "]"}], "]"}], ",", " ", "0.", ",", " ", 
                    "\n", "                        ", 
                    RowBox[{"-", 
                    RowBox[{"rotationaxis", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}]}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"rotationaxis", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], ",", " ", "\n", 
                    "                        ", 
                    RowBox[{"rotationaxis", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], ",", " ", "0."}], "}"}]}],
                     "}"}]}], ";", " ", 
                    RowBox[{
                    "cosangle", " ", "=", " ", "\n", 
                    "                        ", 
                    RowBox[{"previoustilt", " ", ".", " ", 
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}]}]}],
                     ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"1.", " ", "-", " ", "cosangle"}], " ", "<", " ", 
                    "\n", "                        ", 
                    "2.220446049250313*^-16"}], ",", " ", 
                    RowBox[{"cosangle", " ", "=", " ", "1."}]}], "]"}], ";", 
                    " ", "\n", "                        ", 
                    RowBox[{"sinangle", " ", "=", " ", 
                    RowBox[{"1", " ", "-", " ", 
                    RowBox[{"cosangle", "^", "2"}]}]}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    "sinangle", " ", "<", " ", "\n", 
                    "                        ", "2.220446049250313*^-16"}], 
                    ",", " ", 
                    RowBox[{"sinangle", " ", "=", " ", "0."}], ",", " ", "\n",
                     "                        ", 
                    RowBox[{"sinangle", " ", "=", " ", 
                    RowBox[{"Sqrt", "[", "sinangle", "]"}]}]}], "]"}], ";", 
                    " ", 
                    RowBox[{
                    "axismatrix", " ", "+", " ", "\n", 
                    "                        ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"1.", ",", " ", "0.", ",", " ", "0."}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "1.", ",", " ", "0."}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "0.", ",", " ", "1."}], "}"}]}], 
                    "}"}], " ", "-", " ", "\n", "                        ", 
                    "axismatrix"}], ")"}], "*", "cosangle"}], " ", "+", " ", 
                    RowBox[{"crossmatrix", "*", "sinangle"}]}]}], ",", " ", 
                    "\n", "                        ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"r4", ",", " ", "r5", ",", " ", "r6"}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"r7", ",", " ", "r8", ",", " ", "r9"}], "}"}]}], 
                    "}"}], " ", "=", " ", "\n", "                        ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Sign", "[", 
                    RowBox[{"previoustilt", " ", ".", " ", 
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}]}], 
                    "]"}], " ", "===", " ", "1"}], ",", " ", "\n", 
                    "                        ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"1.", ",", " ", "0.", ",", " ", "0."}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "1.", ",", " ", "0."}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "0.", ",", " ", "1."}], "}"}]}], 
                    "}"}], ",", " ", "\n", "                        ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", 
                    RowBox[{"-", "1."}], ",", " ", "0."}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "0.", ",", " ", "0.", ",", " ", "\n", 
                    "                        ", 
                    RowBox[{"-", "1."}]}], "}"}]}], "}"}]}], "]"}]}]}], 
                    "]"}]}], ")"}], " ", "&"}], " ", ",", " ", 
                    "allcreatedrays"}], "]"}]}], ";", " ", 
                    RowBox[{
                    "allcreatedrays", " ", "=", " ", "\n", 
                    "                       ", 
                    RowBox[{"MapIndexed", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "rez", ",", " ", "r1", ",", 
                    " ", "\n", "                        ", "r2", ",", " ", 
                    "r3", ",", " ", "r4", ",", " ", "r5", ",", " ", "r6", ",",
                     " ", "r7", ",", " ", "r8", ",", " ", "r9", ",", " ", 
                    "wavelength", ",", " ", "\n", "                        ", 
                    "intensity", ",", " ", "intensityscale", ",", " ", "ray1",
                     ",", " ", "index", ",", " ", "\n", 
                    "                        ", "opticallength", ",", " ", 
                    "phaseshift", ",", " ", "componentnumber", ",", " ", "\n",
                     "                        ", "surfacenumber", ",", " ", 
                    "surfaceid", ",", " ", "ray2", ",", " ", "ray3", ",", " ",
                     "sid", ",", " ", "\n", "                        ", 
                    "frontid", ",", " ", "sno1", ",", " ", "sno2", ",", " ", 
                    "sno3", ",", " ", "sno4", ",", " ", "rayslot", ",", " ", 
                    "\n", "                        ", "oldgenerationnumber", 
                    ",", " ", "intersectionnumber", ",", " ", "pol1", ",", 
                    " ", "\n", "                        ", "pol2", ",", " ", 
                    "pol3"}], "}"}], " ", "=", " ", "#1"}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"r4", ",", " ", "r5", ",", " ", "r6"}], "}"}], 
                    ",", " ", "\n", "                        ", 
                    RowBox[{"{", 
                    RowBox[{"r7", ",", " ", "r8", ",", " ", "r9"}], "}"}]}], 
                    "}"}], " ", "=", " ", 
                    RowBox[{
                    RowBox[{"Function", "[", 
                    RowBox[{"mm", ",", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"mm", " ", ".", " ", "#1"}], " ", "&"}], " ", 
                    ")"}], " ", "/@", " ", "\n", "                        ", 
                    "originalrotation"}]}], "]"}], "[", 
                    RowBox[{"transmatrix", "[", 
                    RowBox[{"[", 
                    RowBox[{"First", "[", "#2", "]"}], "]"}], "]"}], "]"}]}], 
                    ";", " ", "\n", "                        ", 
                    RowBox[{"tiltmagnitude", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    " ", ".", " ", 
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}]}]}],
                     ";", " ", "\n", "                        ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", 
                    RowBox[{"tiltmagnitude", " ", "-", " ", "1."}], "]"}], 
                    " ", ">", " ", "1.*^-6"}], ",", " ", "\n", 
                    "                        ", 
                    RowBox[{
                    RowBox[{"dummyvector", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    "/", 
                    RowBox[{"Sqrt", "[", "tiltmagnitude", "]"}]}]}], ";", " ",
                     "\n", "                        ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    " ", "=", " ", "dummyvector"}], ";", " ", 
                    RowBox[{"dummymatrix", " ", "=", " ", "\n", 
                    "                        ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"#1", "/", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"#1", " ", ".", " ", "#1"}], "]"}]}], " ", "&"}], 
                    " ", ")"}], " ", "/@", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "r4", ",", " ", "r5", ",", " ", "\n", 
                    "                        ", "r6"}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"r7", ",", " ", "r8", ",", " ", "r9"}], "}"}]}], 
                    "}"}]}]}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"r4", ",", " ", "r5", ",", " ", "r6"}], "}"}], 
                    ",", " ", "\n", "                        ", 
                    RowBox[{"{", 
                    RowBox[{"r7", ",", " ", "r8", ",", " ", "r9"}], "}"}]}], 
                    "}"}], " ", "=", " ", "dummymatrix"}], ";", " ", "1."}], 
                    ",", " ", "1."}], "]"}], ";", " ", "\n", 
                    "                        ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"allcreatedamplitudes", " ", "!=", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"I", "*", "0."}], ",", " ", 
                    RowBox[{"I", "*", "0."}], ",", " ", 
                    RowBox[{"I", "*", "0."}]}], "}"}], "}"}]}], ",", " ", 
                    "\n", "                        ", 
                    RowBox[{
                    RowBox[{"amplitude", " ", "=", " ", 
                    RowBox[{"allcreatedamplitudes", "[", 
                    RowBox[{"[", 
                    RowBox[{"First", "[", "#2", "]"}], "]"}], "]"}]}], ";", 
                    " ", "\n", "                        ", 
                    RowBox[{"hor", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r4", ",", " ", "r5", ",", " ", "r6"}], "}"}], 
                    " ", ".", " ", "amplitude"}]}], ";", " ", 
                    RowBox[{"ver", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "r7", ",", " ", "r8", ",", " ", "\n", 
                    "                        ", "r9"}], "}"}], " ", ".", " ", 
                    "amplitude"}]}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", "hor", "]"}], " ", ">", " ", "0."}], 
                    " ", "||", " ", 
                    RowBox[{
                    RowBox[{"Abs", "[", "ver", "]"}], " ", ">", " ", "\n", 
                    "                        ", "0."}]}], ",", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Abs", "[", "hor", "]"}], ",", " ", 
                    RowBox[{"Abs", "[", "ver", "]"}], ",", " ", "\n", 
                    "                        ", "0."}], "}"}]}], ";", " ", 
                    RowBox[{"dummyvector", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], "/", 
                    RowBox[{"Sqrt", "[", "\n", "                        ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], " ", ".", " ", 
                    RowBox[{"{", 
                    RowBox[{"pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}]}], "]"}]}]}], ";", " ", "\n", 
                    "                        ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], " ", "=", " ", "dummyvector"}], ";", " ", 
                    RowBox[{
                    "dummyvector", " ", "=", " ", "\n", 
                    "                        ", 
                    RowBox[{"ReplacePart", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], ",", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"ver", " ", "==", " ", "0."}], ",", " ", "\n", 
                    "                        ", "0.", ",", " ", 
                    RowBox[{"Arg", "[", "ver", "]"}]}], "]"}], " ", "-", " ", 
                    
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"hor", " ", "==", " ", "0."}], ",", " ", "0.", 
                    ",", " ", 
                    RowBox[{"Arg", "[", "hor", "]"}]}], "]"}]}], ")"}], "/", 
                    "\n", "                        ", "Degree"}], ",", " ", 
                    "3"}], "]"}]}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], " ", "=", " ", "dummyvector"}]}]}], "]"}], ";", 
                    " ", "\n", "                        ", "1."}], ",", " ", 
                    "1."}], "]"}], ";", " ", 
                    RowBox[{"{", 
                    RowBox[{"rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ",
                     "rex", ",", " ", "rey", ",", " ", "rez", ",", " ", "r1", 
                    ",", " ", "r2", ",", " ", "\n", 
                    "                        ", "r3", ",", " ", "r4", ",", 
                    " ", "r5", ",", " ", "r6", ",", " ", "r7", ",", " ", "r8",
                     ",", " ", "r9", ",", " ", "wavelength", ",", " ", "\n", 
                    "                        ", "intensity", ",", " ", 
                    "intensityscale", ",", " ", "ray1", ",", " ", "index", 
                    ",", " ", "\n", "                        ", 
                    "opticallength", ",", " ", "phaseshift", ",", " ", 
                    "componentnumber", ",", " ", "\n", 
                    "                        ", "surfacenumber", ",", " ", 
                    "surfaceid", ",", " ", "ray2", ",", " ", "ray3", ",", " ",
                     "sid", ",", " ", "\n", "                        ", 
                    "frontid", ",", " ", "sno1", ",", " ", "sno2", ",", " ", 
                    "sno3", ",", " ", "sno4", ",", " ", "rayslot", ",", " ", 
                    "\n", "                        ", "generationnumber", ",",
                     " ", "intersectionnumber", ",", " ", "pol1", ",", " ", 
                    "\n", "                        ", "pol2", ",", " ", 
                    "pol3"}], "}"}]}], ")"}], " ", "&"}], " ", ",", " ", 
                    "allcreatedrays"}], "]"}]}]}], ")"}], ";", " ", "\n", 
                    "                     ", 
                    RowBox[{"{", 
                    RowBox[{"allcreatedrays", ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",",
                     " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", 
                    "1.", ",", " ", "\n", "                        ", "1.", 
                    ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", 
                    "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",",
                     " ", 
                    RowBox[{"-", "9.87654321*^8"}], ",", " ", "\n", 
                    "                        ", "1.", ",", " ", "1.", ",", 
                    " ", "1.", ",", " ", "1.", ",", " ", "0.", ",", " ", 
                    RowBox[{"-", "1."}], ",", " ", 
                    RowBox[{"-", "1."}], ",", " ", 
                    RowBox[{"-", "1."}], ",", " ", "1.", ",", " ", "1.", ",", 
                    " ", "1.", ",", " ", "\n", "                        ", 
                    "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",",
                     " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", 
                    "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1."}], 
                    "}"}], "}"}], ",", " ", "\n", "                      ", 
                    RowBox[{"{", "completedray", "}"}]}], "}"}]}], ",", " ", 
                    RowBox[{"resonatenumber", " ", "==", " ", "4"}], ",", " ",
                     "\n", "                    ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "rez", ",", " ", "r1", ",", 
                    " ", "r2", ",", " ", "r3", ",", " ", "r4", ",", " ", "r5",
                     ",", " ", "\n", "                       ", "r6", ",", 
                    " ", "r7", ",", " ", "r8", ",", " ", "r9", ",", " ", 
                    "wavelength", ",", " ", "intensity", ",", " ", "\n", 
                    "                       ", "intensityscale", ",", " ", 
                    "ray1", ",", " ", "index", ",", " ", "opticallength", ",",
                     " ", "\n", "                       ", "phaseshift", ",", 
                    " ", "componentnumber", ",", " ", "surfacenumber", ",", 
                    " ", "\n", "                       ", "surfaceid", ",", 
                    " ", "ray2", ",", " ", "ray3", ",", " ", "sid", ",", " ", 
                    "frontid", ",", " ", "sno1", ",", " ", "sno2", ",", " ", 
                    "\n", "                       ", "sno3", ",", " ", "sno4",
                     ",", " ", "rayslot", ",", " ", "oldgenerationnumber", 
                    ",", " ", "\n", "                       ", 
                    "intersectionnumber", ",", " ", "pol1", ",", " ", "pol2", 
                    ",", " ", "pol3"}], "}"}], " ", "=", " ", "#1"}], ";", 
                    " ", "\n", "                     ", 
                    RowBox[{"index1", " ", "=", " ", "index"}], ";", " ", 
                    RowBox[{"xunit", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"r1", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", "\n", "                        ", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]23"}], 
                    "]"}], "]"}]}], " ", "+", " ", 
                    RowBox[{"r2", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", "\n", "                        ", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]23"}], 
                    "]"}], "]"}]}]}]}], ";", " ", 
                    RowBox[{
                    "yunit", " ", "=", " ", "\n", "                      ", 
                    RowBox[{
                    RowBox[{"r2", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]23"}], 
                    "]"}], "]"}]}], " ", "-", " ", 
                    RowBox[{
                    "1.", "*", "r1", "*", "\n", "                        ", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]23"}], 
                    "]"}], "]"}]}]}]}], ";", " ", 
                    RowBox[{
                    "zunit", " ", "=", " ", "\n", "                      ", 
                    RowBox[{"r3", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]23"}], 
                    "]"}], "^", "2"}], " ", "+", " ", "\n", 
                    "                        ", 
                    RowBox[{
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]23"}], 
                    "]"}], "^", "2"}]}], "]"}]}]}], ";", " ", 
                    RowBox[{
                    "xunit", " ", "=", " ", "\n", "                      ", 
                    RowBox[{"Chop", "[", "xunit", "]"}]}], ";", " ", 
                    RowBox[{"yunit", " ", "=", " ", 
                    RowBox[{"Chop", "[", "yunit", "]"}]}], ";", " ", 
                    RowBox[{
                    "zunit", " ", "=", " ", "\n", "                      ", 
                    RowBox[{"Chop", "[", "zunit", "]"}]}], ";", " ", 
                    RowBox[{"magnitude", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"xunit", "^", "2"}], " ", "+", " ", 
                    RowBox[{"yunit", "^", "2"}], " ", "+", " ", "\n", 
                    "                        ", 
                    RowBox[{"zunit", "^", "2"}]}], ")"}], "^", 
                    RowBox[{"2", "^", 
                    RowBox[{"(", 
                    RowBox[{"-", "1"}], ")"}]}]}]}], ";", " ", 
                    RowBox[{"xunit", " ", "=", " ", 
                    RowBox[{"xunit", "/", "magnitude"}]}], ";", " ", "\n", 
                    "                     ", 
                    RowBox[{"yunit", " ", "=", " ", 
                    RowBox[{"yunit", "/", "magnitude"}]}], ";", " ", 
                    RowBox[{"zunit", " ", "=", " ", 
                    RowBox[{"zunit", "/", "magnitude"}]}], ";", " ", "\n", 
                    "                     ", 
                    RowBox[{"rx", " ", "=", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"rex", " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"Re", "[", "x23", "]"}]}]}], ")"}], "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{
                    "0.017453292519943295", "*", "\n", 
                    "                        ", "\[Theta]23"}], "]"}], 
                    "]"}]}], " ", "+", " ", 
                    RowBox[{"rey", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\n", 
                    "                        ", "\[Theta]23"}], "]"}], 
                    "]"}]}]}]}], ";", " ", 
                    RowBox[{"ry", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"rey", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{
                    "0.017453292519943295", "*", "\n", 
                    "                        ", "\[Theta]23"}], "]"}], 
                    "]"}]}], " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"(", 
                    RowBox[{"rex", " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"Re", "[", "x23", "]"}]}]}], ")"}], "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", "\n", "                        ", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]23"}], 
                    "]"}], "]"}]}]}]}], ";", " ", 
                    RowBox[{"rz", " ", "=", " ", 
                    RowBox[{"rez", "*", "\n", "                       ", 
                    RowBox[{"Re", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]23"}], 
                    "]"}], "^", "2"}], " ", "+", " ", "\n", 
                    "                        ", 
                    RowBox[{
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]23"}], 
                    "]"}], "^", "2"}]}], "]"}]}]}], ";", " ", 
                    RowBox[{
                    "rx", " ", "=", " ", "\n", "                      ", 
                    RowBox[{"Chop", "[", "rx", "]"}]}], ";", " ", 
                    RowBox[{"ry", " ", "=", " ", 
                    RowBox[{"Chop", "[", "ry", "]"}]}], ";", " ", 
                    RowBox[{"rz", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rz", "]"}]}], ";", " ", "\n", 
                    "                     ", 
                    RowBox[{"terminatedeflection", " ", "=", " ", "False"}], 
                    ";", " ", 
                    RowBox[{
                    "intersections", " ", "=", " ", "\n", 
                    "                      ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}], "}"}]}], ";", " ", 
                    RowBox[{
                    "intersections", " ", "=", " ", "\n", 
                    "                      ", "resonateintersections"}], ";", 
                    " ", 
                    RowBox[{"holeQ", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"holeQlist", "[", 
                    RowBox[{
                    "[", "\n", "                        ", "resonatenumber", 
                    "]"}], "]"}], " ", "==", " ", "1"}]}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "newcomponentnumber", ",", " ", "\n", 
                    "                       ", "newsurfacenumber", ",", " ", 
                    "newsurfaceid"}], "}"}], " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "1.", ",", " ", "4.", ",", " ", "\n", 
                    "                       ", "92310."}], "}"}]}], ";", " ", 
                    
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "componentnumber", ",", " ", "surfacenumber", ",", " ", 
                    "\n", "                       ", "surfaceid"}], "}"}], 
                    " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"1.", ",", " ", "4.", ",", " ", "92310."}], 
                    "}"}]}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "ray1", ",", " ", "ray2", ",", " ", "\n", 
                    "                       ", "ray3"}], "}"}], " ", "=", " ", 
                    RowBox[{"intersections", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], ";", " ", 
                    RowBox[{"rsx", " ", "=", " ", "rex"}], ";", " ", 
                    RowBox[{"rsy", " ", "=", " ", "rey"}], ";", " ", "\n", 
                    "                     ", 
                    RowBox[{"rsz", " ", "=", " ", "rez"}], ";", " ", 
                    RowBox[{"rxhlp", " ", "=", " ", 
                    RowBox[{"rx", " ", "+", " ", 
                    RowBox[{"ray1", "*", "xunit"}]}]}], ";", " ", 
                    RowBox[{
                    "ryhlp", " ", "=", " ", "\n", "                      ", 
                    RowBox[{"ry", " ", "+", " ", 
                    RowBox[{"ray1", "*", "yunit"}]}]}], ";", " ", 
                    RowBox[{"rzhlp", " ", "=", " ", 
                    RowBox[{"rz", " ", "+", " ", 
                    RowBox[{"ray1", "*", "zunit"}]}]}], ";", " ", "\n", 
                    "                     ", 
                    RowBox[{"rex", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"Re", "[", "x23", "]"}], " ", "+", " ", 
                    RowBox[{"rxhlp", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{
                    "0.017453292519943295", "*", "\n", 
                    "                        ", "\[Theta]23"}], "]"}], 
                    "]"}]}], " ", "-", " ", 
                    RowBox[{"1.", "*", "ryhlp", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{
                    "0.017453292519943295", "*", "\n", 
                    "                        ", "\[Theta]23"}], "]"}], 
                    "]"}]}]}]}], ";", " ", 
                    RowBox[{"rey", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"ryhlp", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{
                    "0.017453292519943295", "*", "\n", 
                    "                        ", "\[Theta]23"}], "]"}], 
                    "]"}]}], " ", "+", " ", 
                    RowBox[{"rxhlp", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{
                    "0.017453292519943295", "*", "\n", 
                    "                        ", "\[Theta]23"}], "]"}], 
                    "]"}]}]}]}], ";", " ", 
                    RowBox[{"rez", " ", "=", " ", 
                    RowBox[{"rzhlp", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{
                    "0.017453292519943295", "*", "\n", 
                    "                        ", "\[Theta]23"}], "]"}], "^", 
                    "2"}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]23"}], 
                    "]"}], "^", "2"}]}], "]"}]}]}], ";", " ", "\n", 
                    "                     ", 
                    RowBox[{"rex", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rex", "]"}]}], ";", " ", 
                    RowBox[{"rey", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rey", "]"}]}], ";", " ", 
                    RowBox[{"rez", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rez", "]"}]}], ";", " ", "\n", 
                    "                     ", 
                    RowBox[{"intersectionnumber", " ", "=", " ", 
                    RowBox[{"intersectionnumber", " ", "+", " ", "1."}]}], 
                    ";", " ", "\n", "                     ", 
                    RowBox[{"opticallength", " ", "=", " ", 
                    RowBox[{"opticallength", " ", "+", " ", 
                    RowBox[{"ray1", "*", "index1"}]}]}], ";", " ", "\n", 
                    "                     ", 
                    RowBox[{"completedray", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "rez", ",", " ", "r1", ",", 
                    " ", "\n", "                       ", "r2", ",", " ", 
                    "r3", ",", " ", "r4", ",", " ", "r5", ",", " ", "r6", ",",
                     " ", "r7", ",", " ", "r8", ",", " ", "r9", ",", " ", 
                    "wavelength", ",", " ", "\n", "                       ", 
                    "intensity", ",", " ", "intensityscale", ",", " ", "ray1",
                     ",", " ", "index", ",", " ", "\n", 
                    "                       ", "opticallength", ",", " ", 
                    "phaseshift", ",", " ", "componentnumber", ",", " ", "\n",
                     "                       ", "surfacenumber", ",", " ", 
                    "surfaceid", ",", " ", "ray2", ",", " ", "ray3", ",", " ",
                     "sid", ",", " ", "\n", "                       ", 
                    "frontid", ",", " ", "sno1", ",", " ", "sno2", ",", " ", 
                    "sno3", ",", " ", "sno4", ",", " ", "rayslot", ",", " ", 
                    "\n", "                       ", "generationnumber", ",", 
                    " ", "intersectionnumber", ",", " ", "pol1", ",", " ", 
                    "pol2", ",", " ", "\n", "                       ", 
                    "pol3"}], "}"}]}], ";", " ", 
                    RowBox[{"reportedrayspresent", " ", "=", " ", "True"}], 
                    ";", " ", "\n", "                     ", 
                    RowBox[{"intersectionspresent", " ", "=", " ", "True"}], 
                    ";", " ", 
                    RowBox[{
                    "deflectedrayspresent", " ", "=", " ", "\n", 
                    "                      ", "True"}], ";", " ", 
                    RowBox[{
                    "localdummyoutrayspresent", " ", "=", " ", "True"}], ";", 
                    " ", "\n", "                     ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"surfnorm", " ", "=", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"1.", ",", " ", 
                    RowBox[{
                    RowBox[{"-", "1."}], "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"Sign", "[", "r21", "]"}], "*", "ray2"}], ")"}], 
                    "/", "\n", "                        ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"r21", "^", "2"}], " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"ray2", "^", "2"}]}], " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"ray3", "^", "2"}]}]}], ")"}], "^", "0.5"}]}], 
                    ")"}]}], ",", " ", 
                    RowBox[{
                    RowBox[{"-", "1."}], "*", "\n", 
                    "                        ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"Sign", "[", "r21", "]"}], "*", "ray3"}], ")"}], 
                    "/", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"r21", "^", "2"}], " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"ray2", "^", "2"}]}], " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{
                    "ray3", "^", "\n", "                        ", "2"}]}]}], 
                    ")"}], "^", "0.5"}]}], ")"}]}]}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"Sign", "[", "r21", "]"}], "*", "ray2"}], ")"}], 
                    "/", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"r21", "^", "2"}], " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"ray2", "^", "2"}]}], " ", "-", " ", "\n", 
                    "                        ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"ray3", "^", "2"}]}]}], ")"}], "^", "0.5"}]}], 
                    ",", " ", "1.", ",", " ", "0."}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"Sign", "[", "r21", "]"}], "*", "ray3"}], ")"}], 
                    "/", "\n", "                        ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"r21", "^", "2"}], " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"ray2", "^", "2"}]}], " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"ray3", "^", "2"}]}]}], ")"}], "^", "0.5"}]}], 
                    ",", " ", "0.", ",", " ", "1."}], "}"}]}], "}"}], 
                    "]"}]}]}], ";", " ", "\n", "                      ", 
                    RowBox[{"dummymatrix", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{
                    "0.017453292519943295", "*", "\n", 
                    "                        ", "\[Theta]23"}], "]"}], "]"}], 
                    ",", " ", 
                    RowBox[{
                    RowBox[{"-", "1."}], "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{
                    "0.017453292519943295", "*", "\n", 
                    "                        ", "\[Theta]23"}], "]"}], 
                    "]"}]}], ",", " ", "0."}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{
                    "0.017453292519943295", "*", "\n", 
                    "                        ", "\[Theta]23"}], "]"}], "]"}], 
                    ",", " ", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]23"}], 
                    "]"}], "]"}], ",", " ", "\n", "                        ", 
                    "0."}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "0.", ",", " ", "1."}], "}"}]}], 
                    "}"}], " ", ".", " ", "#1"}], " ", "&"}], " ", ")"}], " ",
                     "/@", " ", "surfnorm"}]}], ";", " ", "\n", 
                    "                      ", 
                    RowBox[{"surfnorm", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"#1", "/", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"#1", " ", ".", " ", "#1"}], "]"}]}], " ", "&"}], 
                    " ", ")"}], " ", "/@", " ", "dummymatrix"}]}], ";", " ", 
                    "\n", "                      ", 
                    RowBox[{"surfacerotationmatrix", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", "\n", "                        ", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]23"}], 
                    "]"}], "]"}], ",", " ", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", "\n", "                        ", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]23"}], 
                    "]"}], "]"}], ",", " ", "0."}], "}"}], ",", " ", "\n", 
                    "                        ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "1."}], "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]23"}], 
                    "]"}], "]"}]}], ",", " ", "\n", 
                    "                        ", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]23"}], 
                    "]"}], "]"}], ",", " ", "0."}], "}"}], ",", " ", "\n", 
                    "                        ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "0.", ",", " ", "1."}], "}"}]}], 
                    "}"}]}], ";", " ", 
                    RowBox[{
                    "surfacetranslationvector", " ", "=", " ", "\n", 
                    "                       ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Re", "[", "x23", "]"}], ",", " ", "0.", ",", " ",
                     "0."}], "}"}]}], ";", " ", 
                    RowBox[{"activeregion", " ", "=", " ", "1."}], ";", " ", 
                    "\n", "                      ", 
                    RowBox[{"completedray", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "rez", ",", " ", "r1", ",", 
                    " ", "\n", "                        ", "r2", ",", " ", 
                    "r3", ",", " ", "r4", ",", " ", "r5", ",", " ", "r6", ",",
                     " ", "r7", ",", " ", "r8", ",", " ", "r9", ",", " ", 
                    "wavelength", ",", " ", "\n", "                        ", 
                    "intensity", ",", " ", "intensityscale", ",", " ", "ray1",
                     ",", " ", "index", ",", " ", "\n", 
                    "                        ", "opticallength", ",", " ", 
                    "phaseshift", ",", " ", "componentnumber", ",", " ", "\n",
                     "                        ", "surfacenumber", ",", " ", 
                    "surfaceid", ",", " ", "ray2", ",", " ", "ray3", ",", " ",
                     "sid", ",", " ", "\n", "                        ", 
                    "frontid", ",", " ", "sno1", ",", " ", "sno2", ",", " ", 
                    "sno3", ",", " ", "sno4", ",", " ", "rayslot", ",", " ", 
                    "\n", "                        ", "generationnumber", ",",
                     " ", "intersectionnumber", ",", " ", "pol1", ",", " ", 
                    "\n", "                        ", "pol2", ",", " ", 
                    "pol3"}], "}"}]}], ";", " ", 
                    RowBox[{
                    "componentnumber", " ", "=", " ", "\n", 
                    "                       ", "newcomponentnumber"}], ";", 
                    " ", 
                    RowBox[{
                    "surfacenumber", " ", "=", " ", "\n", 
                    "                       ", "newsurfacenumber"}], ";", " ", 
                    RowBox[{"surfaceid", " ", "=", " ", "newsurfaceid"}], ";",
                     " ", "\n", "                      ", 
                    RowBox[{"originalray", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "rez", ",", " ", "r1", ",", 
                    " ", "\n", "                        ", "r2", ",", " ", 
                    "r3", ",", " ", "r4", ",", " ", "r5", ",", " ", "r6", ",",
                     " ", "r7", ",", " ", "r8", ",", " ", "r9", ",", " ", 
                    "wavelength", ",", " ", "\n", "                        ", 
                    "intensity", ",", " ", "intensityscale", ",", " ", "ray1",
                     ",", " ", "index", ",", " ", "\n", 
                    "                        ", "opticallength", ",", " ", 
                    "phaseshift", ",", " ", "componentnumber", ",", " ", "\n",
                     "                        ", "surfacenumber", ",", " ", 
                    "surfaceid", ",", " ", "ray2", ",", " ", "ray3", ",", " ",
                     "sid", ",", " ", "\n", "                        ", 
                    "frontid", ",", " ", "sno1", ",", " ", "sno2", ",", " ", 
                    "sno3", ",", " ", "sno4", ",", " ", "rayslot", ",", " ", 
                    "\n", "                        ", "generationnumber", ",",
                     " ", "intersectionnumber", ",", " ", "pol1", ",", " ", 
                    "\n", "                        ", "pol2", ",", " ", 
                    "pol3"}], "}"}]}], ";", " ", 
                    RowBox[{"ZAxis", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"First", "[", "surfnorm", "]"}], "*", 
                    RowBox[{"Sign", "[", "\n", "                        ", 
                    RowBox[{
                    RowBox[{"First", "[", "surfnorm", "]"}], " ", ".", " ", 
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}]}], 
                    "]"}]}]}], ";", " ", 
                    RowBox[{
                    "raytiltz", " ", "=", " ", "\n", 
                    "                       ", 
                    RowBox[{"ZAxis", " ", ".", " ", 
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}]}]}],
                     ";", " ", 
                    RowBox[{"raytiltx", " ", "=", " ", 
                    RowBox[{"1", " ", "-", " ", 
                    RowBox[{"raytiltz", "^", "2"}]}]}], ";", " ", "\n", 
                    "                      ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    "raytiltx", " ", "<", " ", "2.220446049250313*^-16"}], 
                    ",", " ", 
                    RowBox[{
                    "raytiltx", " ", "=", " ", "\n", 
                    "                        ", "0."}], ",", " ", 
                    RowBox[{"raytiltx", " ", "=", " ", 
                    RowBox[{"Sqrt", "[", "raytiltx", "]"}]}]}], "]"}], ";", 
                    " ", 
                    RowBox[{
                    "XAxis", " ", "=", " ", "\n", "                       ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    " ", "-", " ", 
                    RowBox[{"ZAxis", "*", "raytiltz"}]}]}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", "raytiltx", "]"}], " ", "<", " ", 
                    "\n", "                        ", "1.*^-7"}], ",", " ", 
                    RowBox[{"XAxis", " ", "=", " ", 
                    RowBox[{"surfnorm", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], ",", " ", 
                    RowBox[{"XAxis", " ", "=", " ", 
                    RowBox[{
                    "XAxis", "/", "\n", "                        ", 
                    "raytiltx"}]}]}], "]"}], ";", " ", 
                    RowBox[{"YAxis", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"ZAxis", "[", 
                    RowBox[{"[", "3", "]"}], "]"}], "*", 
                    RowBox[{"XAxis", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], ")"}]}], " ", "+", " ", 
                    "\n", "                        ", 
                    RowBox[{
                    RowBox[{"ZAxis", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "*", 
                    RowBox[{"XAxis", "[", 
                    RowBox[{"[", "3", "]"}], "]"}]}]}], ",", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"ZAxis", "[", 
                    RowBox[{"[", "3", "]"}], "]"}], "*", 
                    RowBox[{"XAxis", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], " ", "-", " ", "\n", 
                    "                        ", 
                    RowBox[{
                    RowBox[{"ZAxis", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "*", 
                    RowBox[{"XAxis", "[", 
                    RowBox[{"[", "3", "]"}], "]"}]}]}], ",", " ", 
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"ZAxis", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "*", 
                    RowBox[{"XAxis", "[", 
                    RowBox[{"[", "\n", "                        ", "1", "]"}],
                     "]"}]}], ")"}]}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"ZAxis", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "*", 
                    RowBox[{"XAxis", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}]}]}], "}"}]}], ";", " ", 
                    RowBox[{"YAxis", " ", "=", " ", 
                    RowBox[{"YAxis", "/", "\n", "                        ", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"YAxis", " ", ".", " ", "YAxis"}], "]"}]}]}], ";",
                     " ", 
                    RowBox[{"PAxis", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"ZAxis", "*", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "r1", ",", " ", "r2", ",", " ", "\n", 
                    "                        ", "r3"}], "}"}], " ", ".", " ", 
                    "XAxis"}]}], " ", "-", " ", 
                    RowBox[{"XAxis", "*", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    " ", ".", " ", "ZAxis"}]}]}]}], ";", " ", "\n", 
                    "                      ", 
                    RowBox[{"PAxis", " ", "=", " ", 
                    RowBox[{"PAxis", "/", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"PAxis", " ", ".", " ", "PAxis"}], "]"}]}]}], ";",
                     " ", "\n", "                      ", 
                    RowBox[{"normalizedpolarization", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], "[", 
                    RowBox[{"[", "\n", "                        ", 
                    RowBox[{"{", 
                    RowBox[{"1", ",", " ", "2"}], "}"}], "]"}], "]"}]}], ";", 
                    " ", 
                    RowBox[{
                    "normalizedpolarization", " ", "=", " ", "\n", 
                    "                       ", 
                    RowBox[{"normalizedpolarization", "/", 
                    RowBox[{"Sqrt", "[", "\n", "                        ", 
                    RowBox[{"normalizedpolarization", " ", ".", " ", "\n", 
                    "                        ", "normalizedpolarization"}], 
                    "]"}]}]}], ";", " ", 
                    RowBox[{
                    "allcreatedamplitudes", " ", "=", " ", "\n", 
                    "                       ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"I", "*", "0."}], ",", " ", 
                    RowBox[{"I", "*", "0."}], ",", " ", 
                    RowBox[{"I", "*", "0."}]}], "}"}], "}"}]}], ";", " ", 
                    RowBox[{"amplitude", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"Sqrt", "[", "intensity", "]"}], "*", "\n", 
                    "                        ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"normalizedpolarization", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "*", 
                    RowBox[{"{", 
                    RowBox[{"r4", ",", " ", "r5", ",", " ", "r6"}], "}"}]}], 
                    " ", "+", " ", "\n", "                        ", 
                    RowBox[{
                    RowBox[{"normalizedpolarization", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "*", 
                    RowBox[{"{", 
                    RowBox[{"r7", ",", " ", "r8", ",", " ", "r9"}], "}"}], 
                    "*", "\n", "                        ", 
                    RowBox[{"Exp", "[", 
                    RowBox[{"I", "*", "pol3", "*", "0.017453292519943295"}], 
                    "]"}]}]}], ")"}]}]}], ";", " ", "\n", 
                    "                      ", 
                    RowBox[{"perpendicularamplitude", " ", "=", " ", 
                    RowBox[{"amplitude", " ", ".", " ", "YAxis"}]}], ";", " ",
                     "\n", "                      ", 
                    RowBox[{"parallelamplitude", " ", "=", " ", 
                    RowBox[{"amplitude", " ", ".", " ", "PAxis"}]}], ";", " ",
                     "\n", "                      ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"activeregion", "*", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"surfacerotationmatrix", " ", ".", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "r1", ",", " ", "r2", ",", " ", "\n", 
                    "                        ", "r3"}], "}"}]}], ")"}], "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], " ", ">", " ", "0"}], 
                    ",", " ", 
                    RowBox[{
                    RowBox[{"index2", " ", "=", " ", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{
                    "2.2718929", " ", "-", " ", "\n", 
                    "                        ", 
                    RowBox[{"0.010108077", "*", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", 
                    RowBox[{
                    "0.010592509", "/", "\n", "                        ", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", 
                    RowBox[{"0.00020816965", "/", 
                    RowBox[{"wavelength", "^", "4"}]}], " ", "-", " ", "\n", 
                    "                        ", 
                    RowBox[{"7.6472538*^-6", "/", 
                    RowBox[{"wavelength", "^", "6"}]}], " ", "+", " ", 
                    RowBox[{
                    "4.9240991*^-7", "/", "\n", "                        ", 
                    RowBox[{"wavelength", "^", "8"}]}]}], "]"}]}], ";", " ", 
                    RowBox[{"index1", " ", "=", " ", "index"}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", 
                    RowBox[{
                    "index2", " ", "-", " ", "\n", "                        ",
                     "index1"}], "]"}], " ", "<", " ", "0.01"}], ",", " ", 
                    RowBox[{
                    RowBox[{"alternateindex", " ", "=", " ", 
                    RowBox[{"Sqrt", "[", "\n", "                        ", 
                    RowBox[{"1.0005281111748805", " ", "-", " ", 
                    RowBox[{
                    "2.364805676582992*^-10", "*", "\n", 
                    "                        ", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", 
                    RowBox[{"2.9781670902982902*^-6", "/", 
                    RowBox[{
                    "wavelength", "^", "\n", "                        ", 
                    "2"}]}], " ", "+", " ", 
                    RowBox[{"2.6004099469477187*^-8", "/", 
                    RowBox[{"wavelength", "^", "4"}]}], " ", "+", " ", "\n", 
                    "                        ", 
                    RowBox[{"3.7787839314048715*^-10", "/", 
                    RowBox[{"wavelength", "^", "6"}]}], " ", "+", " ", "\n", 
                    "                        ", 
                    RowBox[{"2.830549017940716*^-12", "/", 
                    RowBox[{"wavelength", "^", "8"}]}]}], "]"}]}], ";", " ", 
                    "\n", "                        ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", 
                    RowBox[{"alternateindex", " ", "-", " ", "index1"}], 
                    "]"}], " ", ">", " ", 
                    RowBox[{"Abs", "[", 
                    RowBox[{
                    "index2", " ", "-", " ", "\n", "                        ",
                     "index1"}], "]"}]}], ",", " ", 
                    RowBox[{
                    RowBox[{"index1", " ", "=", " ", "index2"}], ";", " ", 
                    RowBox[{
                    "index2", " ", "=", " ", "\n", "                        ",
                     "alternateindex"}]}], ",", " ", 
                    RowBox[{"index1", " ", "=", " ", "alternateindex"}]}], 
                    "]"}]}], ",", " ", "\n", "                        ", 
                    RowBox[{"index1", " ", "=", " ", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{
                    "1.0005281111748805", " ", "-", " ", "\n", 
                    "                        ", 
                    RowBox[{"2.364805676582992*^-10", "*", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", "\n", 
                    "                        ", 
                    RowBox[{"2.9781670902982902*^-6", "/", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", "\n", 
                    "                        ", 
                    RowBox[{"2.6004099469477187*^-8", "/", 
                    RowBox[{"wavelength", "^", "4"}]}], " ", "+", " ", "\n", 
                    "                        ", 
                    RowBox[{"3.7787839314048715*^-10", "/", 
                    RowBox[{"wavelength", "^", "6"}]}], " ", "+", " ", "\n", 
                    "                        ", 
                    RowBox[{"2.830549017940716*^-12", "/", 
                    RowBox[{"wavelength", "^", "8"}]}]}], "]"}]}]}], "]"}]}], 
                    ",", " ", "\n", "                       ", 
                    RowBox[{
                    RowBox[{"index2", " ", "=", " ", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{
                    "1.0005281111748805", " ", "-", " ", "\n", 
                    "                        ", 
                    RowBox[{"2.364805676582992*^-10", "*", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", "\n", 
                    "                        ", 
                    RowBox[{"2.9781670902982902*^-6", "/", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", "\n", 
                    "                        ", 
                    RowBox[{"2.6004099469477187*^-8", "/", 
                    RowBox[{"wavelength", "^", "4"}]}], " ", "+", " ", "\n", 
                    "                        ", 
                    RowBox[{"3.7787839314048715*^-10", "/", 
                    RowBox[{"wavelength", "^", "6"}]}], " ", "+", " ", "\n", 
                    "                        ", 
                    RowBox[{"2.830549017940716*^-12", "/", 
                    RowBox[{"wavelength", "^", "8"}]}]}], "]"}]}], ";", " ", 
                    RowBox[{
                    "index1", " ", "=", " ", "\n", "                        ",
                     "index"}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", 
                    RowBox[{"index2", " ", "-", " ", "index1"}], "]"}], " ", 
                    "<", " ", "0.01"}], ",", " ", "\n", 
                    "                        ", 
                    RowBox[{
                    RowBox[{"alternateindex", " ", "=", " ", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"2.2718929", " ", "-", " ", 
                    RowBox[{
                    "0.010108077", "*", "\n", "                        ", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", 
                    RowBox[{"0.010592509", "/", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", "\n", 
                    "                        ", 
                    RowBox[{"0.00020816965", "/", 
                    RowBox[{"wavelength", "^", "4"}]}], " ", "-", " ", 
                    RowBox[{
                    "7.6472538*^-6", "/", "\n", "                        ", 
                    RowBox[{"wavelength", "^", "6"}]}], " ", "+", " ", 
                    RowBox[{"4.9240991*^-7", "/", 
                    RowBox[{"wavelength", "^", "8"}]}]}], "]"}]}], ";", " ", 
                    "\n", "                        ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", 
                    RowBox[{"alternateindex", " ", "-", " ", "index1"}], 
                    "]"}], " ", ">", " ", 
                    RowBox[{"Abs", "[", 
                    RowBox[{
                    "index2", " ", "-", " ", "\n", "                        ",
                     "index1"}], "]"}]}], ",", " ", 
                    RowBox[{
                    RowBox[{"index1", " ", "=", " ", "index2"}], ";", " ", 
                    RowBox[{
                    "index2", " ", "=", " ", "\n", "                        ",
                     "alternateindex"}]}], ",", " ", 
                    RowBox[{"index1", " ", "=", " ", "alternateindex"}]}], 
                    "]"}]}], ",", " ", "\n", "                        ", 
                    RowBox[{"index1", " ", "=", " ", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"2.2718929", " ", "-", " ", 
                    RowBox[{"0.010108077", "*", 
                    RowBox[{
                    "wavelength", "^", "\n", "                        ", 
                    "2"}]}], " ", "+", " ", 
                    RowBox[{"0.010592509", "/", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", 
                    RowBox[{
                    "0.00020816965", "/", "\n", "                        ", 
                    RowBox[{"wavelength", "^", "4"}]}], " ", "-", " ", 
                    RowBox[{"7.6472538*^-6", "/", 
                    RowBox[{"wavelength", "^", "6"}]}], " ", "+", " ", "\n", 
                    "                        ", 
                    RowBox[{"4.9240991*^-7", "/", 
                    RowBox[{"wavelength", "^", "8"}]}]}], "]"}]}]}], 
                    "]"}]}]}], "]"}], ";", " ", 
                    RowBox[{"n12", " ", "=", " ", 
                    RowBox[{
                    "index1", "/", "\n", "                        ", 
                    "index2"}]}], ";", " ", 
                    RowBox[{"index", " ", "=", " ", "index2"}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"1", " ", "-", " ", 
                    RowBox[{
                    RowBox[{"n12", "^", "2"}], "*", 
                    RowBox[{
                    "raytiltx", "^", "\n", "                        ", 
                    "2"}]}]}], " ", ">=", " ", "0."}], ",", " ", 
                    RowBox[{
                    RowBox[{"dummyvector", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"n12", "*", 
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}]}], 
                    " ", "+", " ", "\n", "                        ", 
                    RowBox[{"ZAxis", "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"(", 
                    RowBox[{"n12", "*", "raytiltz"}], ")"}]}], " ", "+", " ", 
                    
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"1", " ", "-", " ", 
                    RowBox[{
                    RowBox[{"n12", "^", "2"}], "*", 
                    RowBox[{
                    "raytiltx", "^", "\n", "                        ", 
                    "2"}]}]}], "]"}]}], ")"}]}]}]}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    " ", "=", " ", "dummyvector"}], ";", " ", "1."}], ",", 
                    " ", "\n", "                       ", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    " ", ".", " ", 
                    RowBox[{"surfnorm", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], " ", ">", " ", "0"}], 
                    ",", " ", 
                    RowBox[{
                    "phaseshift", " ", "=", " ", "\n", 
                    "                        ", 
                    RowBox[{"phaseshift", " ", "+", " ", "0.5"}]}], ",", " ", 
                    "1."}], "]"}], ";", " ", 
                    RowBox[{"index2", " ", "=", " ", "index1"}], ";", " ", 
                    RowBox[{
                    "index", " ", "=", " ", "\n", "                        ", 
                    "index1"}], ";", " ", 
                    RowBox[{"dummyvector", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    " ", "-", " ", 
                    RowBox[{
                    "2", "*", "ZAxis", "*", "\n", "                        ", 
                    
                    RowBox[{"ZAxis", " ", ".", " ", 
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], 
                    "}"}]}]}]}]}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    " ", "=", " ", "\n", "                        ", 
                    "dummyvector"}], ";", " ", 
                    RowBox[{"dummyvector", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], " ", "+", " ", "\n", "                        ", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", " ", "0", ",", " ", 
                    RowBox[{"-", "180"}]}], "}"}]}]}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], " ", "=", " ", "dummyvector"}], ";", " ", "\n", 
                    "                        ", "1."}]}], "]"}], ";", " ", 
                    RowBox[{"allcreatedrays", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "\n", 
                    "                        ", "rez", ",", " ", "r1", ",", 
                    " ", "r2", ",", " ", "r3", ",", " ", "r4", ",", " ", "r5",
                     ",", " ", "r6", ",", " ", "r7", ",", " ", "r8", ",", " ",
                     "r9", ",", " ", "\n", "                        ", 
                    "wavelength", ",", " ", "intensity", ",", " ", 
                    "intensityscale", ",", " ", "ray1", ",", " ", "\n", 
                    "                        ", "index", ",", " ", 
                    "opticallength", ",", " ", "phaseshift", ",", " ", "\n", 
                    "                        ", "componentnumber", ",", " ", 
                    "surfacenumber", ",", " ", "surfaceid", ",", " ", "ray2", 
                    ",", " ", "\n", "                        ", "ray3", ",", 
                    " ", "sid", ",", " ", "frontid", ",", " ", "sno1", ",", 
                    " ", "sno2", ",", " ", "sno3", ",", " ", "sno4", ",", " ",
                     "\n", "                        ", "rayslot", ",", " ", 
                    "generationnumber", ",", " ", "intersectionnumber", ",", 
                    " ", "\n", "                        ", "pol1", ",", " ", 
                    "pol2", ",", " ", "pol3"}], "}"}], "}"}]}], ";", " ", 
                    RowBox[{"originalrotation", " ", "=", " ", 
                    RowBox[{
                    "Partition", "[", "\n", "                        ", 
                    RowBox[{
                    RowBox[{"Take", "[", 
                    RowBox[{"originalray", ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"7", ",", " ", "15"}], "}"}]}], "]"}], ",", " ", 
                    "3"}], "]"}]}], ";", " ", 
                    RowBox[{
                    "previoustilt", " ", "=", " ", "\n", 
                    "                       ", 
                    RowBox[{"originalrotation", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], ";", " ", 
                    RowBox[{"transmatrix", " ", "=", " ", 
                    RowBox[{
                    "MapIndexed", "[", "\n", "                        ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "rez", ",", " ", "r1", ",", 
                    " ", "r2", ",", " ", "r3", ",", " ", "r4", ",", " ", "\n",
                     "                        ", "r5", ",", " ", "r6", ",", 
                    " ", "r7", ",", " ", "r8", ",", " ", "r9", ",", " ", 
                    "wavelength", ",", " ", "intensity", ",", " ", "\n", 
                    "                        ", "intensityscale", ",", " ", 
                    "ray1", ",", " ", "index", ",", " ", "opticallength", ",",
                     " ", "\n", "                        ", "phaseshift", ",",
                     " ", "componentnumber", ",", " ", "surfacenumber", ",", 
                    " ", "\n", "                        ", "surfaceid", ",", 
                    " ", "ray2", ",", " ", "ray3", ",", " ", "sid", ",", " ", 
                    "frontid", ",", " ", "sno1", ",", " ", "sno2", ",", " ", 
                    "\n", "                        ", "sno3", ",", " ", 
                    "sno4", ",", " ", "rayslot", ",", " ", 
                    "oldgenerationnumber", ",", " ", "\n", 
                    "                        ", "intersectionnumber", ",", 
                    " ", "pol1", ",", " ", "pol2", ",", " ", "pol3"}], "}"}], 
                    " ", "=", " ", "#1"}], ";", " ", "\n", 
                    "                        ", 
                    RowBox[{"rotationaxis", " ", "=", " ", 
                    RowBox[{"Cross", "[", 
                    RowBox[{"previoustilt", ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "r1", ",", " ", "r2", ",", " ", "\n", 
                    "                        ", "r3"}], "}"}]}], "]"}]}], ";",
                     " ", 
                    RowBox[{"axismagnitude", " ", "=", " ", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{
                    "rotationaxis", " ", ".", " ", "\n", 
                    "                        ", "rotationaxis"}], "]"}]}], 
                    ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Chop", "[", "axismagnitude", "]"}], " ", "!=", 
                    " ", "0."}], ",", " ", "\n", "                        ", 
                    RowBox[{
                    RowBox[{"rotationaxis", " ", "=", " ", 
                    RowBox[{"rotationaxis", "/", "axismagnitude"}]}], ";", 
                    " ", "\n", "                        ", 
                    RowBox[{"axismatrix", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"#1", "*", "rotationaxis"}], " ", "&"}], " ", 
                    ")"}], " ", "/@", " ", "\n", "                        ", 
                    "rotationaxis"}]}], ";", " ", 
                    RowBox[{"crossmatrix", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", 
                    RowBox[{"-", 
                    RowBox[{"rotationaxis", "[", 
                    RowBox[{"[", "\n", "                        ", "3", "]"}],
                     "]"}]}], ",", " ", 
                    RowBox[{"rotationaxis", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"rotationaxis", "[", 
                    RowBox[{"[", "3", "]"}], "]"}], ",", " ", "0.", ",", " ", 
                    "\n", "                        ", 
                    RowBox[{"-", 
                    RowBox[{"rotationaxis", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}]}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"rotationaxis", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], ",", " ", "\n", 
                    "                        ", 
                    RowBox[{"rotationaxis", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], ",", " ", "0."}], "}"}]}],
                     "}"}]}], ";", " ", 
                    RowBox[{
                    "cosangle", " ", "=", " ", "\n", 
                    "                        ", 
                    RowBox[{"previoustilt", " ", ".", " ", 
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}]}]}],
                     ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"1.", " ", "-", " ", "cosangle"}], " ", "<", " ", 
                    "\n", "                        ", 
                    "2.220446049250313*^-16"}], ",", " ", 
                    RowBox[{"cosangle", " ", "=", " ", "1."}]}], "]"}], ";", 
                    " ", "\n", "                        ", 
                    RowBox[{"sinangle", " ", "=", " ", 
                    RowBox[{"1", " ", "-", " ", 
                    RowBox[{"cosangle", "^", "2"}]}]}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    "sinangle", " ", "<", " ", "\n", 
                    "                        ", "2.220446049250313*^-16"}], 
                    ",", " ", 
                    RowBox[{"sinangle", " ", "=", " ", "0."}], ",", " ", "\n",
                     "                        ", 
                    RowBox[{"sinangle", " ", "=", " ", 
                    RowBox[{"Sqrt", "[", "sinangle", "]"}]}]}], "]"}], ";", 
                    " ", 
                    RowBox[{
                    "axismatrix", " ", "+", " ", "\n", 
                    "                        ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"1.", ",", " ", "0.", ",", " ", "0."}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "1.", ",", " ", "0."}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "0.", ",", " ", "1."}], "}"}]}], 
                    "}"}], " ", "-", " ", "\n", "                        ", 
                    "axismatrix"}], ")"}], "*", "cosangle"}], " ", "+", " ", 
                    RowBox[{"crossmatrix", "*", "sinangle"}]}]}], ",", " ", 
                    "\n", "                        ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"r4", ",", " ", "r5", ",", " ", "r6"}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"r7", ",", " ", "r8", ",", " ", "r9"}], "}"}]}], 
                    "}"}], " ", "=", " ", "\n", "                        ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Sign", "[", 
                    RowBox[{"previoustilt", " ", ".", " ", 
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}]}], 
                    "]"}], " ", "===", " ", "1"}], ",", " ", "\n", 
                    "                        ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"1.", ",", " ", "0.", ",", " ", "0."}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "1.", ",", " ", "0."}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "0.", ",", " ", "1."}], "}"}]}], 
                    "}"}], ",", " ", "\n", "                        ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", 
                    RowBox[{"-", "1."}], ",", " ", "0."}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "0.", ",", " ", "0.", ",", " ", "\n", 
                    "                        ", 
                    RowBox[{"-", "1."}]}], "}"}]}], "}"}]}], "]"}]}]}], 
                    "]"}]}], ")"}], " ", "&"}], " ", ",", " ", 
                    "allcreatedrays"}], "]"}]}], ";", " ", 
                    RowBox[{"allcreatedrays", " ", "=", " ", "\n", 
                    "                       ", 
                    RowBox[{"MapIndexed", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "rez", ",", " ", "r1", ",", 
                    " ", "\n", "                        ", "r2", ",", " ", 
                    "r3", ",", " ", "r4", ",", " ", "r5", ",", " ", "r6", ",",
                     " ", "r7", ",", " ", "r8", ",", " ", "r9", ",", " ", 
                    "wavelength", ",", " ", "\n", "                        ", 
                    "intensity", ",", " ", "intensityscale", ",", " ", "ray1",
                     ",", " ", "index", ",", " ", "\n", 
                    "                        ", "opticallength", ",", " ", 
                    "phaseshift", ",", " ", "componentnumber", ",", " ", "\n",
                     "                        ", "surfacenumber", ",", " ", 
                    "surfaceid", ",", " ", "ray2", ",", " ", "ray3", ",", " ",
                     "sid", ",", " ", "\n", "                        ", 
                    "frontid", ",", " ", "sno1", ",", " ", "sno2", ",", " ", 
                    "sno3", ",", " ", "sno4", ",", " ", "rayslot", ",", " ", 
                    "\n", "                        ", "oldgenerationnumber", 
                    ",", " ", "intersectionnumber", ",", " ", "pol1", ",", 
                    " ", "\n", "                        ", "pol2", ",", " ", 
                    "pol3"}], "}"}], " ", "=", " ", "#1"}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"r4", ",", " ", "r5", ",", " ", "r6"}], "}"}], 
                    ",", " ", "\n", "                        ", 
                    RowBox[{"{", 
                    RowBox[{"r7", ",", " ", "r8", ",", " ", "r9"}], "}"}]}], 
                    "}"}], " ", "=", " ", 
                    RowBox[{
                    RowBox[{"Function", "[", 
                    RowBox[{"mm", ",", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"mm", " ", ".", " ", "#1"}], " ", "&"}], " ", 
                    ")"}], " ", "/@", " ", "\n", "                        ", 
                    "originalrotation"}]}], "]"}], "[", 
                    RowBox[{"transmatrix", "[", 
                    RowBox[{"[", 
                    RowBox[{"First", "[", "#2", "]"}], "]"}], "]"}], "]"}]}], 
                    ";", " ", "\n", "                        ", 
                    RowBox[{"tiltmagnitude", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    " ", ".", " ", 
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}]}]}],
                     ";", " ", "\n", "                        ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", 
                    RowBox[{"tiltmagnitude", " ", "-", " ", "1."}], "]"}], 
                    " ", ">", " ", "1.*^-6"}], ",", " ", "\n", 
                    "                        ", 
                    RowBox[{
                    RowBox[{"dummyvector", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    "/", 
                    RowBox[{"Sqrt", "[", "tiltmagnitude", "]"}]}]}], ";", " ",
                     "\n", "                        ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    " ", "=", " ", "dummyvector"}], ";", " ", 
                    RowBox[{
                    "dummymatrix", " ", "=", " ", "\n", 
                    "                        ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"#1", "/", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"#1", " ", ".", " ", "#1"}], "]"}]}], " ", "&"}], 
                    " ", ")"}], " ", "/@", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "r4", ",", " ", "r5", ",", " ", "\n", 
                    "                        ", "r6"}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"r7", ",", " ", "r8", ",", " ", "r9"}], "}"}]}], 
                    "}"}]}]}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"r4", ",", " ", "r5", ",", " ", "r6"}], "}"}], 
                    ",", " ", "\n", "                        ", 
                    RowBox[{"{", 
                    RowBox[{"r7", ",", " ", "r8", ",", " ", "r9"}], "}"}]}], 
                    "}"}], " ", "=", " ", "dummymatrix"}], ";", " ", "1."}], 
                    ",", " ", "1."}], "]"}], ";", " ", "\n", 
                    "                        ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"allcreatedamplitudes", " ", "!=", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"I", "*", "0."}], ",", " ", 
                    RowBox[{"I", "*", "0."}], ",", " ", 
                    RowBox[{"I", "*", "0."}]}], "}"}], "}"}]}], ",", " ", 
                    "\n", "                        ", 
                    RowBox[{
                    RowBox[{"amplitude", " ", "=", " ", 
                    RowBox[{"allcreatedamplitudes", "[", 
                    RowBox[{"[", 
                    RowBox[{"First", "[", "#2", "]"}], "]"}], "]"}]}], ";", 
                    " ", "\n", "                        ", 
                    RowBox[{"hor", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r4", ",", " ", "r5", ",", " ", "r6"}], "}"}], 
                    " ", ".", " ", "amplitude"}]}], ";", " ", 
                    RowBox[{"ver", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "r7", ",", " ", "r8", ",", " ", "\n", 
                    "                        ", "r9"}], "}"}], " ", ".", " ", 
                    "amplitude"}]}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", "hor", "]"}], " ", ">", " ", "0."}], 
                    " ", "||", " ", 
                    RowBox[{
                    RowBox[{"Abs", "[", "ver", "]"}], " ", ">", " ", "\n", 
                    "                        ", "0."}]}], ",", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Abs", "[", "hor", "]"}], ",", " ", 
                    RowBox[{"Abs", "[", "ver", "]"}], ",", " ", "\n", 
                    "                        ", "0."}], "}"}]}], ";", " ", 
                    RowBox[{"dummyvector", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], "/", 
                    RowBox[{"Sqrt", "[", "\n", "                        ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], " ", ".", " ", 
                    RowBox[{"{", 
                    RowBox[{"pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}]}], "]"}]}]}], ";", " ", "\n", 
                    "                        ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], " ", "=", " ", "dummyvector"}], ";", " ", 
                    RowBox[{
                    "dummyvector", " ", "=", " ", "\n", 
                    "                        ", 
                    RowBox[{"ReplacePart", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], ",", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"ver", " ", "==", " ", "0."}], ",", " ", "\n", 
                    "                        ", "0.", ",", " ", 
                    RowBox[{"Arg", "[", "ver", "]"}]}], "]"}], " ", "-", " ", 
                    
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"hor", " ", "==", " ", "0."}], ",", " ", "0.", 
                    ",", " ", 
                    RowBox[{"Arg", "[", "hor", "]"}]}], "]"}]}], ")"}], "/", 
                    "\n", "                        ", "Degree"}], ",", " ", 
                    "3"}], "]"}]}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], " ", "=", " ", "dummyvector"}]}]}], "]"}], ";", 
                    " ", "\n", "                        ", "1."}], ",", " ", 
                    "1."}], "]"}], ";", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "rez", ",", " ", "r1", ",", 
                    " ", "r2", ",", " ", "\n", "                        ", 
                    "r3", ",", " ", "r4", ",", " ", "r5", ",", " ", "r6", ",",
                     " ", "r7", ",", " ", "r8", ",", " ", "r9", ",", " ", 
                    "wavelength", ",", " ", "\n", "                        ", 
                    "intensity", ",", " ", "intensityscale", ",", " ", "ray1",
                     ",", " ", "index", ",", " ", "\n", 
                    "                        ", "opticallength", ",", " ", 
                    "phaseshift", ",", " ", "componentnumber", ",", " ", "\n",
                     "                        ", "surfacenumber", ",", " ", 
                    "surfaceid", ",", " ", "ray2", ",", " ", "ray3", ",", " ",
                     "sid", ",", " ", "\n", "                        ", 
                    "frontid", ",", " ", "sno1", ",", " ", "sno2", ",", " ", 
                    "sno3", ",", " ", "sno4", ",", " ", "rayslot", ",", " ", 
                    "\n", "                        ", "generationnumber", ",",
                     " ", "intersectionnumber", ",", " ", "pol1", ",", " ", 
                    "\n", "                        ", "pol2", ",", " ", 
                    "pol3"}], "}"}]}], ")"}], " ", "&"}], " ", ",", " ", 
                    "allcreatedrays"}], "]"}]}]}], ")"}], ";", " ", "\n", 
                    "                     ", 
                    RowBox[{"{", 
                    RowBox[{"allcreatedrays", ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",",
                     " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", 
                    "1.", ",", " ", "\n", "                        ", "1.", 
                    ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", 
                    "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",",
                     " ", 
                    RowBox[{"-", "9.87654321*^8"}], ",", " ", "\n", 
                    "                        ", "1.", ",", " ", "1.", ",", 
                    " ", "1.", ",", " ", "1.", ",", " ", "0.", ",", " ", 
                    RowBox[{"-", "1."}], ",", " ", 
                    RowBox[{"-", "1."}], ",", " ", 
                    RowBox[{"-", "1."}], ",", " ", "1.", ",", " ", "1.", ",", 
                    " ", "1.", ",", " ", "\n", "                        ", 
                    "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",",
                     " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", 
                    "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1."}], 
                    "}"}], "}"}], ",", " ", "\n", "                      ", 
                    RowBox[{"{", "completedray", "}"}]}], "}"}]}], ",", " ", 
                    RowBox[{"resonatenumber", " ", "==", " ", "5"}], ",", " ",
                     "\n", "                    ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "rez", ",", " ", "r1", ",", 
                    " ", "r2", ",", " ", "r3", ",", " ", "r4", ",", " ", "r5",
                     ",", " ", "\n", "                       ", "r6", ",", 
                    " ", "r7", ",", " ", "r8", ",", " ", "r9", ",", " ", 
                    "wavelength", ",", " ", "intensity", ",", " ", "\n", 
                    "                       ", "intensityscale", ",", " ", 
                    "ray1", ",", " ", "index", ",", " ", "opticallength", ",",
                     " ", "\n", "                       ", "phaseshift", ",", 
                    " ", "componentnumber", ",", " ", "surfacenumber", ",", 
                    " ", "\n", "                       ", "surfaceid", ",", 
                    " ", "ray2", ",", " ", "ray3", ",", " ", "sid", ",", " ", 
                    "frontid", ",", " ", "sno1", ",", " ", "sno2", ",", " ", 
                    "\n", "                       ", "sno3", ",", " ", "sno4",
                     ",", " ", "rayslot", ",", " ", "oldgenerationnumber", 
                    ",", " ", "\n", "                       ", 
                    "intersectionnumber", ",", " ", "pol1", ",", " ", "pol2", 
                    ",", " ", "pol3"}], "}"}], " ", "=", " ", "#1"}], ";", 
                    " ", "\n", "                     ", 
                    RowBox[{"index1", " ", "=", " ", "index"}], ";", " ", 
                    RowBox[{"xunit", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"r1", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", "\n", "                        ", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]23"}], 
                    "]"}], "]"}]}], " ", "+", " ", 
                    RowBox[{"r2", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", "\n", "                        ", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]23"}], 
                    "]"}], "]"}]}]}]}], ";", " ", 
                    RowBox[{
                    "yunit", " ", "=", " ", "\n", "                      ", 
                    RowBox[{
                    RowBox[{"r2", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]23"}], 
                    "]"}], "]"}]}], " ", "-", " ", 
                    RowBox[{
                    "1.", "*", "r1", "*", "\n", "                        ", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]23"}], 
                    "]"}], "]"}]}]}]}], ";", " ", 
                    RowBox[{
                    "zunit", " ", "=", " ", "\n", "                      ", 
                    RowBox[{"r3", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]23"}], 
                    "]"}], "^", "2"}], " ", "+", " ", "\n", 
                    "                        ", 
                    RowBox[{
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]23"}], 
                    "]"}], "^", "2"}]}], "]"}]}]}], ";", " ", 
                    RowBox[{
                    "xunit", " ", "=", " ", "\n", "                      ", 
                    RowBox[{"Chop", "[", "xunit", "]"}]}], ";", " ", 
                    RowBox[{"yunit", " ", "=", " ", 
                    RowBox[{"Chop", "[", "yunit", "]"}]}], ";", " ", 
                    RowBox[{"zunit", " ", "=", " ", "\n", 
                    "                      ", 
                    RowBox[{"Chop", "[", "zunit", "]"}]}], ";", " ", 
                    RowBox[{"magnitude", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"xunit", "^", "2"}], " ", "+", " ", 
                    RowBox[{"yunit", "^", "2"}], " ", "+", " ", "\n", 
                    "                        ", 
                    RowBox[{"zunit", "^", "2"}]}], ")"}], "^", 
                    RowBox[{"2", "^", 
                    RowBox[{"(", 
                    RowBox[{"-", "1"}], ")"}]}]}]}], ";", " ", 
                    RowBox[{"xunit", " ", "=", " ", 
                    RowBox[{"xunit", "/", "magnitude"}]}], ";", " ", "\n", 
                    "                     ", 
                    RowBox[{"yunit", " ", "=", " ", 
                    RowBox[{"yunit", "/", "magnitude"}]}], ";", " ", 
                    RowBox[{"zunit", " ", "=", " ", 
                    RowBox[{"zunit", "/", "magnitude"}]}], ";", " ", "\n", 
                    "                     ", 
                    RowBox[{"rx", " ", "=", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]23"}], 
                    "]"}], "]"}], "*", 
                    RowBox[{"(", 
                    RowBox[{
                    "rex", " ", "-", " ", "\n", "                        ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"x23", " ", "+", " ", 
                    RowBox[{"7.5", "*", 
                    RowBox[{"Cos", "[", 
                    RowBox[{
                    "0.017453292519943295", "*", "\n", 
                    "                        ", "\[Theta]23"}], "]"}]}]}], 
                    "]"}]}]}], ")"}]}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"rey", " ", "-", " ", 
                    RowBox[{"7.5", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", "\n", "                        ", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]23"}], 
                    "]"}], "]"}]}]}], ")"}], "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", "\n", "                        ", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]23"}], 
                    "]"}], "]"}]}]}]}], ";", " ", 
                    RowBox[{
                    "ry", " ", "=", " ", "\n", "                      ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]23"}], 
                    "]"}], "]"}], "*", 
                    RowBox[{"(", 
                    RowBox[{
                    "rey", " ", "-", " ", "\n", "                        ", 
                    RowBox[{"7.5", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]23"}], 
                    "]"}], "]"}]}]}], ")"}]}], " ", "-", " ", "\n", 
                    "                       ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"(", 
                    RowBox[{"rex", " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"x23", " ", "+", " ", 
                    RowBox[{"7.5", "*", 
                    RowBox[{"Cos", "[", "\n", "                        ", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]23"}], 
                    "]"}]}]}], "]"}]}]}], ")"}], "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", "\n", "                        ", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]23"}], 
                    "]"}], "]"}]}]}]}], ";", " ", 
                    RowBox[{"rz", " ", "=", " ", 
                    RowBox[{"rez", "*", "\n", "                       ", 
                    RowBox[{"Re", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]23"}], 
                    "]"}], "^", "2"}], " ", "+", " ", "\n", 
                    "                        ", 
                    RowBox[{
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]23"}], 
                    "]"}], "^", "2"}]}], "]"}]}]}], ";", " ", 
                    RowBox[{
                    "rx", " ", "=", " ", "\n", "                      ", 
                    RowBox[{"Chop", "[", "rx", "]"}]}], ";", " ", 
                    RowBox[{"ry", " ", "=", " ", 
                    RowBox[{"Chop", "[", "ry", "]"}]}], ";", " ", 
                    RowBox[{"rz", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rz", "]"}]}], ";", " ", "\n", 
                    "                     ", 
                    RowBox[{"terminatedeflection", " ", "=", " ", "False"}], 
                    ";", " ", 
                    RowBox[{
                    "intersections", " ", "=", " ", "\n", 
                    "                      ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}], "}"}]}], ";", " ", 
                    RowBox[{
                    "intersections", " ", "=", " ", "\n", 
                    "                      ", "resonateintersections"}], ";", 
                    " ", 
                    RowBox[{"holeQ", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"holeQlist", "[", 
                    RowBox[{
                    "[", "\n", "                        ", "resonatenumber", 
                    "]"}], "]"}], " ", "==", " ", "1"}]}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "newcomponentnumber", ",", " ", "\n", 
                    "                       ", "newsurfacenumber", ",", " ", 
                    "newsurfaceid"}], "}"}], " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "1.", ",", " ", "5.", ",", " ", "\n", 
                    "                       ", "92311."}], "}"}]}], ";", " ", 
                    
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "componentnumber", ",", " ", "surfacenumber", ",", " ", 
                    "\n", "                       ", "surfaceid"}], "}"}], 
                    " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"1.", ",", " ", "5.", ",", " ", "92311."}], 
                    "}"}]}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "ray1", ",", " ", "ray2", ",", " ", "\n", 
                    "                       ", "ray3"}], "}"}], " ", "=", " ", 
                    RowBox[{"intersections", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], ";", " ", 
                    RowBox[{"rsx", " ", "=", " ", "rex"}], ";", " ", 
                    RowBox[{"rsy", " ", "=", " ", "rey"}], ";", " ", "\n", 
                    "                     ", 
                    RowBox[{"rsz", " ", "=", " ", "rez"}], ";", " ", 
                    RowBox[{"rxhlp", " ", "=", " ", 
                    RowBox[{"rx", " ", "+", " ", 
                    RowBox[{"ray1", "*", "xunit"}]}]}], ";", " ", 
                    RowBox[{
                    "ryhlp", " ", "=", " ", "\n", "                      ", 
                    RowBox[{"ry", " ", "+", " ", 
                    RowBox[{"ray1", "*", "yunit"}]}]}], ";", " ", 
                    RowBox[{"rzhlp", " ", "=", " ", 
                    RowBox[{"rz", " ", "+", " ", 
                    RowBox[{"ray1", "*", "zunit"}]}]}], ";", " ", "\n", 
                    "                     ", 
                    RowBox[{"rex", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"rxhlp", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]23"}], 
                    "]"}], "]"}]}], " ", "+", " ", "\n", 
                    "                       ", 
                    RowBox[{"Re", "[", 
                    RowBox[{"x23", " ", "+", " ", 
                    RowBox[{"7.5", "*", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]23"}], 
                    "]"}]}]}], "]"}], " ", "-", " ", "\n", 
                    "                       ", 
                    RowBox[{"1.", "*", "ryhlp", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]23"}], 
                    "]"}], "]"}]}]}]}], ";", " ", "\n", 
                    "                     ", 
                    RowBox[{"rey", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"ryhlp", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]23"}], 
                    "]"}], "]"}]}], " ", "+", " ", "\n", 
                    "                       ", 
                    RowBox[{"7.5", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]23"}], 
                    "]"}], "]"}]}], " ", "+", " ", "\n", 
                    "                       ", 
                    RowBox[{"rxhlp", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]23"}], 
                    "]"}], "]"}]}]}]}], ";", " ", "\n", 
                    "                     ", 
                    RowBox[{"rez", " ", "=", " ", 
                    RowBox[{"rzhlp", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]23"}], 
                    "]"}], "^", "2"}], " ", "+", " ", "\n", 
                    "                        ", 
                    RowBox[{
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]23"}], 
                    "]"}], "^", "2"}]}], "]"}]}]}], ";", " ", 
                    RowBox[{
                    "rex", " ", "=", " ", "\n", "                      ", 
                    RowBox[{"Chop", "[", "rex", "]"}]}], ";", " ", 
                    RowBox[{"rey", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rey", "]"}]}], ";", " ", 
                    RowBox[{"rez", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rez", "]"}]}], ";", " ", "\n", 
                    "                     ", 
                    RowBox[{"intersectionnumber", " ", "=", " ", 
                    RowBox[{"intersectionnumber", " ", "+", " ", "1."}]}], 
                    ";", " ", "\n", "                     ", 
                    RowBox[{"opticallength", " ", "=", " ", 
                    RowBox[{"opticallength", " ", "+", " ", 
                    RowBox[{"ray1", "*", "index1"}]}]}], ";", " ", "\n", 
                    "                     ", 
                    RowBox[{"completedray", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "rez", ",", " ", "r1", ",", 
                    " ", "\n", "                       ", "r2", ",", " ", 
                    "r3", ",", " ", "r4", ",", " ", "r5", ",", " ", "r6", ",",
                     " ", "r7", ",", " ", "r8", ",", " ", "r9", ",", " ", 
                    "wavelength", ",", " ", "\n", "                       ", 
                    "intensity", ",", " ", "intensityscale", ",", " ", "ray1",
                     ",", " ", "index", ",", " ", "\n", 
                    "                       ", "opticallength", ",", " ", 
                    "phaseshift", ",", " ", "componentnumber", ",", " ", "\n",
                     "                       ", "surfacenumber", ",", " ", 
                    "surfaceid", ",", " ", "ray2", ",", " ", "ray3", ",", " ",
                     "sid", ",", " ", "\n", "                       ", 
                    "frontid", ",", " ", "sno1", ",", " ", "sno2", ",", " ", 
                    "sno3", ",", " ", "sno4", ",", " ", "rayslot", ",", " ", 
                    "\n", "                       ", "generationnumber", ",", 
                    " ", "intersectionnumber", ",", " ", "pol1", ",", " ", 
                    "pol2", ",", " ", "\n", "                       ", 
                    "pol3"}], "}"}]}], ";", " ", 
                    RowBox[{"reportedrayspresent", " ", "=", " ", "True"}], 
                    ";", " ", "\n", "                     ", 
                    RowBox[{"intersectionspresent", " ", "=", " ", "True"}], 
                    ";", " ", 
                    RowBox[{
                    "deflectedrayspresent", " ", "=", " ", "\n", 
                    "                      ", "True"}], ";", " ", 
                    RowBox[{
                    "localdummyoutrayspresent", " ", "=", " ", "True"}], ";", 
                    " ", "\n", "                     ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"surfnorm", " ", "=", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"1.", ",", " ", 
                    RowBox[{
                    RowBox[{"-", "1."}], "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"Sign", "[", "r22", "]"}], "*", "ray2"}], ")"}], 
                    "/", "\n", "                        ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"r22", "^", "2"}], " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"ray2", "^", "2"}]}], " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"ray3", "^", "2"}]}]}], ")"}], "^", "0.5"}]}], 
                    ")"}]}], ",", " ", 
                    RowBox[{
                    RowBox[{"-", "1."}], "*", "\n", 
                    "                        ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"Sign", "[", "r22", "]"}], "*", "ray3"}], ")"}], 
                    "/", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"r22", "^", "2"}], " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"ray2", "^", "2"}]}], " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{
                    "ray3", "^", "\n", "                        ", "2"}]}]}], 
                    ")"}], "^", "0.5"}]}], ")"}]}]}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"Sign", "[", "r22", "]"}], "*", "ray2"}], ")"}], 
                    "/", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"r22", "^", "2"}], " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"ray2", "^", "2"}]}], " ", "-", " ", "\n", 
                    "                        ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"ray3", "^", "2"}]}]}], ")"}], "^", "0.5"}]}], 
                    ",", " ", "1.", ",", " ", "0."}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"Sign", "[", "r22", "]"}], "*", "ray3"}], ")"}], 
                    "/", "\n", "                        ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"r22", "^", "2"}], " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"ray2", "^", "2"}]}], " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"ray3", "^", "2"}]}]}], ")"}], "^", "0.5"}]}], 
                    ",", " ", "0.", ",", " ", "1."}], "}"}]}], "}"}], 
                    "]"}]}]}], ";", " ", "\n", "                      ", 
                    RowBox[{"dummymatrix", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{
                    "0.017453292519943295", "*", "\n", 
                    "                        ", "\[Theta]23"}], "]"}], "]"}], 
                    ",", " ", 
                    RowBox[{
                    RowBox[{"-", "1."}], "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{
                    "0.017453292519943295", "*", "\n", 
                    "                        ", "\[Theta]23"}], "]"}], 
                    "]"}]}], ",", " ", "0."}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{
                    "0.017453292519943295", "*", "\n", 
                    "                        ", "\[Theta]23"}], "]"}], "]"}], 
                    ",", " ", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]23"}], 
                    "]"}], "]"}], ",", " ", "\n", "                        ", 
                    "0."}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "0.", ",", " ", "1."}], "}"}]}], 
                    "}"}], " ", ".", " ", "#1"}], " ", "&"}], " ", ")"}], " ",
                     "/@", " ", "surfnorm"}]}], ";", " ", "\n", 
                    "                      ", 
                    RowBox[{"surfnorm", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"#1", "/", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"#1", " ", ".", " ", "#1"}], "]"}]}], " ", "&"}], 
                    " ", ")"}], " ", "/@", " ", "dummymatrix"}]}], ";", " ", 
                    "\n", "                      ", 
                    RowBox[{"surfacerotationmatrix", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", "\n", "                        ", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]23"}], 
                    "]"}], "]"}], ",", " ", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", "\n", "                        ", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]23"}], 
                    "]"}], "]"}], ",", " ", "0."}], "}"}], ",", " ", "\n", 
                    "                        ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "1."}], "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]23"}], 
                    "]"}], "]"}]}], ",", " ", "\n", 
                    "                        ", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]23"}], 
                    "]"}], "]"}], ",", " ", "0."}], "}"}], ",", " ", "\n", 
                    "                        ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "0.", ",", " ", "1."}], "}"}]}], 
                    "}"}]}], ";", " ", 
                    RowBox[{
                    "surfacetranslationvector", " ", "=", " ", "\n", 
                    "                       ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"x23", " ", "+", " ", 
                    RowBox[{"7.5", "*", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]23"}], 
                    "]"}]}]}], "]"}], ",", " ", "\n", 
                    "                        ", 
                    RowBox[{"7.5", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]23"}], 
                    "]"}], "]"}]}], ",", " ", "0."}], "}"}]}], ";", " ", "\n",
                     "                      ", 
                    RowBox[{"activeregion", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"completedray", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "\n", 
                    "                        ", "rex", ",", " ", "rey", ",", 
                    " ", "rez", ",", " ", "r1", ",", " ", "r2", ",", " ", 
                    "r3", ",", " ", "r4", ",", " ", "r5", ",", " ", "r6", ",",
                     " ", "r7", ",", " ", "r8", ",", " ", "\n", 
                    "                        ", "r9", ",", " ", "wavelength", 
                    ",", " ", "intensity", ",", " ", "intensityscale", ",", 
                    " ", "ray1", ",", " ", "\n", "                        ", 
                    "index", ",", " ", "opticallength", ",", " ", 
                    "phaseshift", ",", " ", "\n", "                        ", 
                    "componentnumber", ",", " ", "surfacenumber", ",", " ", 
                    "surfaceid", ",", " ", "ray2", ",", " ", "\n", 
                    "                        ", "ray3", ",", " ", "sid", ",", 
                    " ", "frontid", ",", " ", "sno1", ",", " ", "sno2", ",", 
                    " ", "sno3", ",", " ", "sno4", ",", " ", "\n", 
                    "                        ", "rayslot", ",", " ", 
                    "generationnumber", ",", " ", "intersectionnumber", ",", 
                    " ", "\n", "                        ", "pol1", ",", " ", 
                    "pol2", ",", " ", "pol3"}], "}"}]}], ";", " ", 
                    RowBox[{
                    "componentnumber", " ", "=", " ", "\n", 
                    "                       ", "newcomponentnumber"}], ";", 
                    " ", 
                    RowBox[{
                    "surfacenumber", " ", "=", " ", "\n", 
                    "                       ", "newsurfacenumber"}], ";", " ", 
                    RowBox[{"surfaceid", " ", "=", " ", "newsurfaceid"}], ";",
                     " ", "\n", "                      ", 
                    RowBox[{"originalray", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "rez", ",", " ", "r1", ",", 
                    " ", "\n", "                        ", "r2", ",", " ", 
                    "r3", ",", " ", "r4", ",", " ", "r5", ",", " ", "r6", ",",
                     " ", "r7", ",", " ", "r8", ",", " ", "r9", ",", " ", 
                    "wavelength", ",", " ", "\n", "                        ", 
                    "intensity", ",", " ", "intensityscale", ",", " ", "ray1",
                     ",", " ", "index", ",", " ", "\n", 
                    "                        ", "opticallength", ",", " ", 
                    "phaseshift", ",", " ", "componentnumber", ",", " ", "\n",
                     "                        ", "surfacenumber", ",", " ", 
                    "surfaceid", ",", " ", "ray2", ",", " ", "ray3", ",", " ",
                     "sid", ",", " ", "\n", "                        ", 
                    "frontid", ",", " ", "sno1", ",", " ", "sno2", ",", " ", 
                    "sno3", ",", " ", "sno4", ",", " ", "rayslot", ",", " ", 
                    "\n", "                        ", "generationnumber", ",",
                     " ", "intersectionnumber", ",", " ", "pol1", ",", " ", 
                    "\n", "                        ", "pol2", ",", " ", 
                    "pol3"}], "}"}]}], ";", " ", 
                    RowBox[{"ZAxis", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"First", "[", "surfnorm", "]"}], "*", 
                    RowBox[{"Sign", "[", "\n", "                        ", 
                    RowBox[{
                    RowBox[{"First", "[", "surfnorm", "]"}], " ", ".", " ", 
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}]}], 
                    "]"}]}]}], ";", " ", 
                    RowBox[{
                    "raytiltz", " ", "=", " ", "\n", 
                    "                       ", 
                    RowBox[{"ZAxis", " ", ".", " ", 
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}]}]}],
                     ";", " ", 
                    RowBox[{"raytiltx", " ", "=", " ", 
                    RowBox[{"1", " ", "-", " ", 
                    RowBox[{"raytiltz", "^", "2"}]}]}], ";", " ", "\n", 
                    "                      ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    "raytiltx", " ", "<", " ", "2.220446049250313*^-16"}], 
                    ",", " ", 
                    RowBox[{
                    "raytiltx", " ", "=", " ", "\n", 
                    "                        ", "0."}], ",", " ", 
                    RowBox[{"raytiltx", " ", "=", " ", 
                    RowBox[{"Sqrt", "[", "raytiltx", "]"}]}]}], "]"}], ";", 
                    " ", 
                    RowBox[{
                    "XAxis", " ", "=", " ", "\n", "                       ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    " ", "-", " ", 
                    RowBox[{"ZAxis", "*", "raytiltz"}]}]}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", "raytiltx", "]"}], " ", "<", " ", 
                    "\n", "                        ", "1.*^-7"}], ",", " ", 
                    RowBox[{"XAxis", " ", "=", " ", 
                    RowBox[{"surfnorm", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], ",", " ", 
                    RowBox[{"XAxis", " ", "=", " ", 
                    RowBox[{
                    "XAxis", "/", "\n", "                        ", 
                    "raytiltx"}]}]}], "]"}], ";", " ", 
                    RowBox[{"YAxis", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"ZAxis", "[", 
                    RowBox[{"[", "3", "]"}], "]"}], "*", 
                    RowBox[{"XAxis", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], ")"}]}], " ", "+", " ", 
                    "\n", "                        ", 
                    RowBox[{
                    RowBox[{"ZAxis", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "*", 
                    RowBox[{"XAxis", "[", 
                    RowBox[{"[", "3", "]"}], "]"}]}]}], ",", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"ZAxis", "[", 
                    RowBox[{"[", "3", "]"}], "]"}], "*", 
                    RowBox[{"XAxis", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], " ", "-", " ", "\n", 
                    "                        ", 
                    RowBox[{
                    RowBox[{"ZAxis", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "*", 
                    RowBox[{"XAxis", "[", 
                    RowBox[{"[", "3", "]"}], "]"}]}]}], ",", " ", 
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"ZAxis", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "*", 
                    RowBox[{"XAxis", "[", 
                    RowBox[{"[", "\n", "                        ", "1", "]"}],
                     "]"}]}], ")"}]}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"ZAxis", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "*", 
                    RowBox[{"XAxis", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}]}]}], "}"}]}], ";", " ", 
                    RowBox[{"YAxis", " ", "=", " ", 
                    RowBox[{"YAxis", "/", "\n", "                        ", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"YAxis", " ", ".", " ", "YAxis"}], "]"}]}]}], ";",
                     " ", 
                    RowBox[{"PAxis", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"ZAxis", "*", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "r1", ",", " ", "r2", ",", " ", "\n", 
                    "                        ", "r3"}], "}"}], " ", ".", " ", 
                    "XAxis"}]}], " ", "-", " ", 
                    RowBox[{"XAxis", "*", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    " ", ".", " ", "ZAxis"}]}]}]}], ";", " ", "\n", 
                    "                      ", 
                    RowBox[{"PAxis", " ", "=", " ", 
                    RowBox[{"PAxis", "/", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"PAxis", " ", ".", " ", "PAxis"}], "]"}]}]}], ";",
                     " ", "\n", "                      ", 
                    RowBox[{"normalizedpolarization", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], "[", 
                    RowBox[{"[", "\n", "                        ", 
                    RowBox[{"{", 
                    RowBox[{"1", ",", " ", "2"}], "}"}], "]"}], "]"}]}], ";", 
                    " ", 
                    RowBox[{
                    "normalizedpolarization", " ", "=", " ", "\n", 
                    "                       ", 
                    RowBox[{"normalizedpolarization", "/", 
                    RowBox[{"Sqrt", "[", "\n", "                        ", 
                    RowBox[{
                    "normalizedpolarization", " ", ".", " ", "\n", 
                    "                        ", "normalizedpolarization"}], 
                    "]"}]}]}], ";", " ", 
                    RowBox[{
                    "allcreatedamplitudes", " ", "=", " ", "\n", 
                    "                       ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"I", "*", "0."}], ",", " ", 
                    RowBox[{"I", "*", "0."}], ",", " ", 
                    RowBox[{"I", "*", "0."}]}], "}"}], "}"}]}], ";", " ", 
                    RowBox[{"amplitude", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"Sqrt", "[", "intensity", "]"}], "*", "\n", 
                    "                        ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"normalizedpolarization", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "*", 
                    RowBox[{"{", 
                    RowBox[{"r4", ",", " ", "r5", ",", " ", "r6"}], "}"}]}], 
                    " ", "+", " ", "\n", "                        ", 
                    RowBox[{
                    RowBox[{"normalizedpolarization", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "*", 
                    RowBox[{"{", 
                    RowBox[{"r7", ",", " ", "r8", ",", " ", "r9"}], "}"}], 
                    "*", "\n", "                        ", 
                    RowBox[{"Exp", "[", 
                    RowBox[{"I", "*", "pol3", "*", "0.017453292519943295"}], 
                    "]"}]}]}], ")"}]}]}], ";", " ", "\n", 
                    "                      ", 
                    RowBox[{"perpendicularamplitude", " ", "=", " ", 
                    RowBox[{"amplitude", " ", ".", " ", "YAxis"}]}], ";", " ",
                     "\n", "                      ", 
                    RowBox[{"parallelamplitude", " ", "=", " ", 
                    RowBox[{"amplitude", " ", ".", " ", "PAxis"}]}], ";", " ",
                     "\n", "                      ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"activeregion", "*", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"surfacerotationmatrix", " ", ".", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "r1", ",", " ", "r2", ",", " ", "\n", 
                    "                        ", "r3"}], "}"}]}], ")"}], "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], " ", ">", " ", "0"}], 
                    ",", " ", 
                    RowBox[{
                    RowBox[{"index2", " ", "=", " ", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{
                    "2.7105646", " ", "-", " ", "\n", 
                    "                        ", 
                    RowBox[{"0.009121199600000001", "*", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", 
                    RowBox[{
                    "0.027760538", "/", "\n", "                        ", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", 
                    RowBox[{"0.0012739656", "/", 
                    RowBox[{"wavelength", "^", "4"}]}], " ", "-", " ", "\n", 
                    "                        ", 
                    RowBox[{"0.000047889342", "/", 
                    RowBox[{"wavelength", "^", "6"}]}], " ", "+", " ", 
                    RowBox[{
                    "8.0562028*^-6", "/", "\n", "                        ", 
                    RowBox[{"wavelength", "^", "8"}]}]}], "]"}]}], ";", " ", 
                    RowBox[{"index1", " ", "=", " ", "index"}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", 
                    RowBox[{
                    "index2", " ", "-", " ", "\n", "                        ",
                     "index1"}], "]"}], " ", "<", " ", "0.01"}], ",", " ", 
                    RowBox[{
                    RowBox[{"alternateindex", " ", "=", " ", 
                    RowBox[{"Sqrt", "[", "\n", "                        ", 
                    RowBox[{"2.2718929", " ", "-", " ", 
                    RowBox[{"0.010108077", "*", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", "\n", 
                    "                        ", 
                    RowBox[{"0.010592509", "/", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", 
                    RowBox[{
                    "0.00020816965", "/", "\n", "                        ", 
                    RowBox[{"wavelength", "^", "4"}]}], " ", "-", " ", 
                    RowBox[{"7.6472538*^-6", "/", 
                    RowBox[{"wavelength", "^", "6"}]}], " ", "+", " ", "\n", 
                    "                        ", 
                    RowBox[{"4.9240991*^-7", "/", 
                    RowBox[{"wavelength", "^", "8"}]}]}], "]"}]}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", "\n", "                        ", 
                    RowBox[{"alternateindex", " ", "-", " ", "index1"}], 
                    "]"}], " ", ">", " ", 
                    RowBox[{"Abs", "[", 
                    RowBox[{"index2", " ", "-", " ", "index1"}], "]"}]}], ",",
                     " ", "\n", "                        ", 
                    RowBox[{
                    RowBox[{"index1", " ", "=", " ", "index2"}], ";", " ", 
                    RowBox[{"index2", " ", "=", " ", "alternateindex"}]}], 
                    ",", " ", "\n", "                        ", 
                    RowBox[{"index1", " ", "=", " ", "alternateindex"}]}], 
                    "]"}]}], ",", " ", 
                    RowBox[{"index1", " ", "=", " ", 
                    RowBox[{"Sqrt", "[", "\n", "                        ", 
                    RowBox[{"2.2718929", " ", "-", " ", 
                    RowBox[{"0.010108077", "*", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", "\n", 
                    "                        ", 
                    RowBox[{"0.010592509", "/", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", 
                    RowBox[{
                    "0.00020816965", "/", "\n", "                        ", 
                    RowBox[{"wavelength", "^", "4"}]}], " ", "-", " ", 
                    RowBox[{"7.6472538*^-6", "/", 
                    RowBox[{"wavelength", "^", "6"}]}], " ", "+", " ", "\n", 
                    "                        ", 
                    RowBox[{"4.9240991*^-7", "/", 
                    RowBox[{"wavelength", "^", "8"}]}]}], "]"}]}]}], "]"}]}], 
                    ",", " ", 
                    RowBox[{
                    RowBox[{"index2", " ", "=", " ", 
                    RowBox[{"Sqrt", "[", "\n", "                        ", 
                    RowBox[{"2.2718929", " ", "-", " ", 
                    RowBox[{"0.010108077", "*", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", "\n", 
                    "                        ", 
                    RowBox[{"0.010592509", "/", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", 
                    RowBox[{
                    "0.00020816965", "/", "\n", "                        ", 
                    RowBox[{"wavelength", "^", "4"}]}], " ", "-", " ", 
                    RowBox[{"7.6472538*^-6", "/", 
                    RowBox[{"wavelength", "^", "6"}]}], " ", "+", " ", "\n", 
                    "                        ", 
                    RowBox[{"4.9240991*^-7", "/", 
                    RowBox[{"wavelength", "^", "8"}]}]}], "]"}]}], ";", " ", 
                    RowBox[{"index1", " ", "=", " ", "index"}], ";", " ", 
                    "\n", "                        ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", 
                    RowBox[{"index2", " ", "-", " ", "index1"}], "]"}], " ", 
                    "<", " ", "0.01"}], ",", " ", 
                    RowBox[{
                    RowBox[{
                    "alternateindex", " ", "=", " ", "\n", 
                    "                        ", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"2.7105646", " ", "-", " ", 
                    RowBox[{"0.009121199600000001", "*", 
                    RowBox[{
                    "wavelength", "^", "\n", "                        ", 
                    "2"}]}], " ", "+", " ", 
                    RowBox[{"0.027760538", "/", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", 
                    RowBox[{
                    "0.0012739656", "/", "\n", "                        ", 
                    RowBox[{"wavelength", "^", "4"}]}], " ", "-", " ", 
                    RowBox[{"0.000047889342", "/", 
                    RowBox[{"wavelength", "^", "6"}]}], " ", "+", " ", "\n", 
                    "                        ", 
                    RowBox[{"8.0562028*^-6", "/", 
                    RowBox[{"wavelength", "^", "8"}]}]}], "]"}]}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", "\n", "                        ", 
                    RowBox[{"alternateindex", " ", "-", " ", "index1"}], 
                    "]"}], " ", ">", " ", 
                    RowBox[{"Abs", "[", 
                    RowBox[{"index2", " ", "-", " ", "index1"}], "]"}]}], ",",
                     " ", "\n", "                        ", 
                    RowBox[{
                    RowBox[{"index1", " ", "=", " ", "index2"}], ";", " ", 
                    RowBox[{"index2", " ", "=", " ", "alternateindex"}]}], 
                    ",", " ", "\n", "                        ", 
                    RowBox[{"index1", " ", "=", " ", "alternateindex"}]}], 
                    "]"}]}], ",", " ", 
                    RowBox[{"index1", " ", "=", " ", 
                    RowBox[{"Sqrt", "[", "\n", "                        ", 
                    RowBox[{"2.7105646", " ", "-", " ", 
                    RowBox[{"0.009121199600000001", "*", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", "\n", 
                    "                        ", 
                    RowBox[{"0.027760538", "/", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", 
                    RowBox[{
                    "0.0012739656", "/", "\n", "                        ", 
                    RowBox[{"wavelength", "^", "4"}]}], " ", "-", " ", 
                    RowBox[{"0.000047889342", "/", 
                    RowBox[{"wavelength", "^", "6"}]}], " ", "+", " ", "\n", 
                    "                        ", 
                    RowBox[{"8.0562028*^-6", "/", 
                    RowBox[{"wavelength", "^", "8"}]}]}], "]"}]}]}], 
                    "]"}]}]}], "]"}], ";", " ", 
                    RowBox[{"n12", " ", "=", " ", 
                    RowBox[{
                    "index1", "/", "\n", "                        ", 
                    "index2"}]}], ";", " ", 
                    RowBox[{"index", " ", "=", " ", "index2"}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"1", " ", "-", " ", 
                    RowBox[{
                    RowBox[{"n12", "^", "2"}], "*", 
                    RowBox[{
                    "raytiltx", "^", "\n", "                        ", 
                    "2"}]}]}], " ", ">=", " ", "0."}], ",", " ", 
                    RowBox[{
                    RowBox[{"dummyvector", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"n12", "*", 
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}]}], 
                    " ", "+", " ", "\n", "                        ", 
                    RowBox[{"ZAxis", "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"(", 
                    RowBox[{"n12", "*", "raytiltz"}], ")"}]}], " ", "+", " ", 
                    
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"1", " ", "-", " ", 
                    RowBox[{
                    RowBox[{"n12", "^", "2"}], "*", 
                    RowBox[{
                    "raytiltx", "^", "\n", "                        ", 
                    "2"}]}]}], "]"}]}], ")"}]}]}]}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    " ", "=", " ", "dummyvector"}], ";", " ", "1."}], ",", 
                    " ", "\n", "                       ", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    " ", ".", " ", 
                    RowBox[{"surfnorm", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], " ", ">", " ", "0"}], 
                    ",", " ", 
                    RowBox[{
                    "phaseshift", " ", "=", " ", "\n", 
                    "                        ", 
                    RowBox[{"phaseshift", " ", "+", " ", "0.5"}]}], ",", " ", 
                    "1."}], "]"}], ";", " ", 
                    RowBox[{"index2", " ", "=", " ", "index1"}], ";", " ", 
                    RowBox[{
                    "index", " ", "=", " ", "\n", "                        ", 
                    "index1"}], ";", " ", 
                    RowBox[{"dummyvector", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    " ", "-", " ", 
                    RowBox[{
                    "2", "*", "ZAxis", "*", "\n", "                        ", 
                    
                    RowBox[{"ZAxis", " ", ".", " ", 
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], 
                    "}"}]}]}]}]}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    " ", "=", " ", "\n", "                        ", 
                    "dummyvector"}], ";", " ", 
                    RowBox[{"dummyvector", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], " ", "+", " ", "\n", "                        ", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", " ", "0", ",", " ", 
                    RowBox[{"-", "180"}]}], "}"}]}]}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], " ", "=", " ", "dummyvector"}], ";", " ", "\n", 
                    "                        ", "1."}]}], "]"}], ";", " ", 
                    RowBox[{"allcreatedrays", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "\n", 
                    "                        ", "rez", ",", " ", "r1", ",", 
                    " ", "r2", ",", " ", "r3", ",", " ", "r4", ",", " ", "r5",
                     ",", " ", "r6", ",", " ", "r7", ",", " ", "r8", ",", " ",
                     "r9", ",", " ", "\n", "                        ", 
                    "wavelength", ",", " ", "intensity", ",", " ", 
                    "intensityscale", ",", " ", "ray1", ",", " ", "\n", 
                    "                        ", "index", ",", " ", 
                    "opticallength", ",", " ", "phaseshift", ",", " ", "\n", 
                    "                        ", "componentnumber", ",", " ", 
                    "surfacenumber", ",", " ", "surfaceid", ",", " ", "ray2", 
                    ",", " ", "\n", "                        ", "ray3", ",", 
                    " ", "sid", ",", " ", "frontid", ",", " ", "sno1", ",", 
                    " ", "sno2", ",", " ", "sno3", ",", " ", "sno4", ",", " ",
                     "\n", "                        ", "rayslot", ",", " ", 
                    "generationnumber", ",", " ", "intersectionnumber", ",", 
                    " ", "\n", "                        ", "pol1", ",", " ", 
                    "pol2", ",", " ", "pol3"}], "}"}], "}"}]}], ";", " ", 
                    RowBox[{"originalrotation", " ", "=", " ", 
                    RowBox[{
                    "Partition", "[", "\n", "                        ", 
                    RowBox[{
                    RowBox[{"Take", "[", 
                    RowBox[{"originalray", ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"7", ",", " ", "15"}], "}"}]}], "]"}], ",", " ", 
                    "3"}], "]"}]}], ";", " ", 
                    RowBox[{
                    "previoustilt", " ", "=", " ", "\n", 
                    "                       ", 
                    RowBox[{"originalrotation", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], ";", " ", 
                    RowBox[{"transmatrix", " ", "=", " ", 
                    RowBox[{
                    "MapIndexed", "[", "\n", "                        ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "rez", ",", " ", "r1", ",", 
                    " ", "r2", ",", " ", "r3", ",", " ", "r4", ",", " ", "\n",
                     "                        ", "r5", ",", " ", "r6", ",", 
                    " ", "r7", ",", " ", "r8", ",", " ", "r9", ",", " ", 
                    "wavelength", ",", " ", "intensity", ",", " ", "\n", 
                    "                        ", "intensityscale", ",", " ", 
                    "ray1", ",", " ", "index", ",", " ", "opticallength", ",",
                     " ", "\n", "                        ", "phaseshift", ",",
                     " ", "componentnumber", ",", " ", "surfacenumber", ",", 
                    " ", "\n", "                        ", "surfaceid", ",", 
                    " ", "ray2", ",", " ", "ray3", ",", " ", "sid", ",", " ", 
                    "frontid", ",", " ", "sno1", ",", " ", "sno2", ",", " ", 
                    "\n", "                        ", "sno3", ",", " ", 
                    "sno4", ",", " ", "rayslot", ",", " ", 
                    "oldgenerationnumber", ",", " ", "\n", 
                    "                        ", "intersectionnumber", ",", 
                    " ", "pol1", ",", " ", "pol2", ",", " ", "pol3"}], "}"}], 
                    " ", "=", " ", "#1"}], ";", " ", "\n", 
                    "                        ", 
                    RowBox[{"rotationaxis", " ", "=", " ", 
                    RowBox[{"Cross", "[", 
                    RowBox[{"previoustilt", ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "r1", ",", " ", "r2", ",", " ", "\n", 
                    "                        ", "r3"}], "}"}]}], "]"}]}], ";",
                     " ", 
                    RowBox[{"axismagnitude", " ", "=", " ", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{
                    "rotationaxis", " ", ".", " ", "\n", 
                    "                        ", "rotationaxis"}], "]"}]}], 
                    ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Chop", "[", "axismagnitude", "]"}], " ", "!=", 
                    " ", "0."}], ",", " ", "\n", "                        ", 
                    RowBox[{
                    RowBox[{"rotationaxis", " ", "=", " ", 
                    RowBox[{"rotationaxis", "/", "axismagnitude"}]}], ";", 
                    " ", "\n", "                        ", 
                    RowBox[{"axismatrix", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"#1", "*", "rotationaxis"}], " ", "&"}], " ", 
                    ")"}], " ", "/@", " ", "\n", "                        ", 
                    "rotationaxis"}]}], ";", " ", 
                    RowBox[{"crossmatrix", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", 
                    RowBox[{"-", 
                    RowBox[{"rotationaxis", "[", 
                    RowBox[{"[", "\n", "                        ", "3", "]"}],
                     "]"}]}], ",", " ", 
                    RowBox[{"rotationaxis", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"rotationaxis", "[", 
                    RowBox[{"[", "3", "]"}], "]"}], ",", " ", "0.", ",", " ", 
                    "\n", "                        ", 
                    RowBox[{"-", 
                    RowBox[{"rotationaxis", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}]}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"rotationaxis", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], ",", " ", "\n", 
                    "                        ", 
                    RowBox[{"rotationaxis", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], ",", " ", "0."}], "}"}]}],
                     "}"}]}], ";", " ", 
                    RowBox[{
                    "cosangle", " ", "=", " ", "\n", 
                    "                        ", 
                    RowBox[{"previoustilt", " ", ".", " ", 
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}]}]}],
                     ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"1.", " ", "-", " ", "cosangle"}], " ", "<", " ", 
                    "\n", "                        ", 
                    "2.220446049250313*^-16"}], ",", " ", 
                    RowBox[{"cosangle", " ", "=", " ", "1."}]}], "]"}], ";", 
                    " ", "\n", "                        ", 
                    RowBox[{"sinangle", " ", "=", " ", 
                    RowBox[{"1", " ", "-", " ", 
                    RowBox[{"cosangle", "^", "2"}]}]}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    "sinangle", " ", "<", " ", "\n", 
                    "                        ", "2.220446049250313*^-16"}], 
                    ",", " ", 
                    RowBox[{"sinangle", " ", "=", " ", "0."}], ",", " ", "\n",
                     "                        ", 
                    RowBox[{"sinangle", " ", "=", " ", 
                    RowBox[{"Sqrt", "[", "sinangle", "]"}]}]}], "]"}], ";", 
                    " ", 
                    RowBox[{
                    "axismatrix", " ", "+", " ", "\n", 
                    "                        ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"1.", ",", " ", "0.", ",", " ", "0."}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "1.", ",", " ", "0."}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "0.", ",", " ", "1."}], "}"}]}], 
                    "}"}], " ", "-", " ", "\n", "                        ", 
                    "axismatrix"}], ")"}], "*", "cosangle"}], " ", "+", " ", 
                    RowBox[{"crossmatrix", "*", "sinangle"}]}]}], ",", " ", 
                    "\n", "                        ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"r4", ",", " ", "r5", ",", " ", "r6"}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"r7", ",", " ", "r8", ",", " ", "r9"}], "}"}]}], 
                    "}"}], " ", "=", " ", "\n", "                        ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Sign", "[", 
                    RowBox[{"previoustilt", " ", ".", " ", 
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}]}], 
                    "]"}], " ", "===", " ", "1"}], ",", " ", "\n", 
                    "                        ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"1.", ",", " ", "0.", ",", " ", "0."}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "1.", ",", " ", "0."}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "0.", ",", " ", "1."}], "}"}]}], 
                    "}"}], ",", " ", "\n", "                        ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", 
                    RowBox[{"-", "1."}], ",", " ", "0."}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "0.", ",", " ", "0.", ",", " ", "\n", 
                    "                        ", 
                    RowBox[{"-", "1."}]}], "}"}]}], "}"}]}], "]"}]}]}], 
                    "]"}]}], ")"}], " ", "&"}], " ", ",", " ", 
                    "allcreatedrays"}], "]"}]}], ";", " ", 
                    RowBox[{
                    "allcreatedrays", " ", "=", " ", "\n", 
                    "                       ", 
                    RowBox[{"MapIndexed", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "rez", ",", " ", "r1", ",", 
                    " ", "\n", "                        ", "r2", ",", " ", 
                    "r3", ",", " ", "r4", ",", " ", "r5", ",", " ", "r6", ",",
                     " ", "r7", ",", " ", "r8", ",", " ", "r9", ",", " ", 
                    "wavelength", ",", " ", "\n", "                        ", 
                    "intensity", ",", " ", "intensityscale", ",", " ", "ray1",
                     ",", " ", "index", ",", " ", "\n", 
                    "                        ", "opticallength", ",", " ", 
                    "phaseshift", ",", " ", "componentnumber", ",", " ", "\n",
                     "                        ", "surfacenumber", ",", " ", 
                    "surfaceid", ",", " ", "ray2", ",", " ", "ray3", ",", " ",
                     "sid", ",", " ", "\n", "                        ", 
                    "frontid", ",", " ", "sno1", ",", " ", "sno2", ",", " ", 
                    "sno3", ",", " ", "sno4", ",", " ", "rayslot", ",", " ", 
                    "\n", "                        ", "oldgenerationnumber", 
                    ",", " ", "intersectionnumber", ",", " ", "pol1", ",", 
                    " ", "\n", "                        ", "pol2", ",", " ", 
                    "pol3"}], "}"}], " ", "=", " ", "#1"}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"r4", ",", " ", "r5", ",", " ", "r6"}], "}"}], 
                    ",", " ", "\n", "                        ", 
                    RowBox[{"{", 
                    RowBox[{"r7", ",", " ", "r8", ",", " ", "r9"}], "}"}]}], 
                    "}"}], " ", "=", " ", 
                    RowBox[{
                    RowBox[{"Function", "[", 
                    RowBox[{"mm", ",", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"mm", " ", ".", " ", "#1"}], " ", "&"}], " ", 
                    ")"}], " ", "/@", " ", "\n", "                        ", 
                    "originalrotation"}]}], "]"}], "[", 
                    RowBox[{"transmatrix", "[", 
                    RowBox[{"[", 
                    RowBox[{"First", "[", "#2", "]"}], "]"}], "]"}], "]"}]}], 
                    ";", " ", "\n", "                        ", 
                    RowBox[{"tiltmagnitude", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    " ", ".", " ", 
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}]}]}],
                     ";", " ", "\n", "                        ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", 
                    RowBox[{"tiltmagnitude", " ", "-", " ", "1."}], "]"}], 
                    " ", ">", " ", "1.*^-6"}], ",", " ", "\n", 
                    "                        ", 
                    RowBox[{
                    RowBox[{"dummyvector", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    "/", 
                    RowBox[{"Sqrt", "[", "tiltmagnitude", "]"}]}]}], ";", " ",
                     "\n", "                        ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    " ", "=", " ", "dummyvector"}], ";", " ", 
                    RowBox[{
                    "dummymatrix", " ", "=", " ", "\n", 
                    "                        ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"#1", "/", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"#1", " ", ".", " ", "#1"}], "]"}]}], " ", "&"}], 
                    " ", ")"}], " ", "/@", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "r4", ",", " ", "r5", ",", " ", "\n", 
                    "                        ", "r6"}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"r7", ",", " ", "r8", ",", " ", "r9"}], "}"}]}], 
                    "}"}]}]}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"r4", ",", " ", "r5", ",", " ", "r6"}], "}"}], 
                    ",", " ", "\n", "                        ", 
                    RowBox[{"{", 
                    RowBox[{"r7", ",", " ", "r8", ",", " ", "r9"}], "}"}]}], 
                    "}"}], " ", "=", " ", "dummymatrix"}], ";", " ", "1."}], 
                    ",", " ", "1."}], "]"}], ";", " ", "\n", 
                    "                        ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"allcreatedamplitudes", " ", "!=", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"I", "*", "0."}], ",", " ", 
                    RowBox[{"I", "*", "0."}], ",", " ", 
                    RowBox[{"I", "*", "0."}]}], "}"}], "}"}]}], ",", " ", 
                    "\n", "                        ", 
                    RowBox[{
                    RowBox[{"amplitude", " ", "=", " ", 
                    RowBox[{"allcreatedamplitudes", "[", 
                    RowBox[{"[", 
                    RowBox[{"First", "[", "#2", "]"}], "]"}], "]"}]}], ";", 
                    " ", "\n", "                        ", 
                    RowBox[{"hor", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r4", ",", " ", "r5", ",", " ", "r6"}], "}"}], 
                    " ", ".", " ", "amplitude"}]}], ";", " ", 
                    RowBox[{"ver", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "r7", ",", " ", "r8", ",", " ", "\n", 
                    "                        ", "r9"}], "}"}], " ", ".", " ", 
                    "amplitude"}]}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", "hor", "]"}], " ", ">", " ", "0."}], 
                    " ", "||", " ", 
                    RowBox[{
                    RowBox[{"Abs", "[", "ver", "]"}], " ", ">", " ", "\n", 
                    "                        ", "0."}]}], ",", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Abs", "[", "hor", "]"}], ",", " ", 
                    RowBox[{"Abs", "[", "ver", "]"}], ",", " ", "\n", 
                    "                        ", "0."}], "}"}]}], ";", " ", 
                    RowBox[{"dummyvector", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], "/", 
                    RowBox[{"Sqrt", "[", "\n", "                        ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], " ", ".", " ", 
                    RowBox[{"{", 
                    RowBox[{"pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}]}], "]"}]}]}], ";", " ", "\n", 
                    "                        ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], " ", "=", " ", "dummyvector"}], ";", " ", 
                    RowBox[{
                    "dummyvector", " ", "=", " ", "\n", 
                    "                        ", 
                    RowBox[{"ReplacePart", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], ",", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"ver", " ", "==", " ", "0."}], ",", " ", "\n", 
                    "                        ", "0.", ",", " ", 
                    RowBox[{"Arg", "[", "ver", "]"}]}], "]"}], " ", "-", " ", 
                    
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"hor", " ", "==", " ", "0."}], ",", " ", "0.", 
                    ",", " ", 
                    RowBox[{"Arg", "[", "hor", "]"}]}], "]"}]}], ")"}], "/", 
                    "\n", "                        ", "Degree"}], ",", " ", 
                    "3"}], "]"}]}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], " ", "=", " ", "dummyvector"}]}]}], "]"}], ";", 
                    " ", "\n", "                        ", "1."}], ",", " ", 
                    "1."}], "]"}], ";", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "rez", ",", " ", "r1", ",", 
                    " ", "r2", ",", " ", "\n", "                        ", 
                    "r3", ",", " ", "r4", ",", " ", "r5", ",", " ", "r6", ",",
                     " ", "r7", ",", " ", "r8", ",", " ", "r9", ",", " ", 
                    "wavelength", ",", " ", "\n", "                        ", 
                    "intensity", ",", " ", "intensityscale", ",", " ", "ray1",
                     ",", " ", "index", ",", " ", "\n", 
                    "                        ", "opticallength", ",", " ", 
                    "phaseshift", ",", " ", "componentnumber", ",", " ", "\n",
                     "                        ", "surfacenumber", ",", " ", 
                    "surfaceid", ",", " ", "ray2", ",", " ", "ray3", ",", " ",
                     "sid", ",", " ", "\n", "                        ", 
                    "frontid", ",", " ", "sno1", ",", " ", "sno2", ",", " ", 
                    "sno3", ",", " ", "sno4", ",", " ", "rayslot", ",", " ", 
                    "\n", "                        ", "generationnumber", ",",
                     " ", "intersectionnumber", ",", " ", "pol1", ",", " ", 
                    "\n", "                        ", "pol2", ",", " ", 
                    "pol3"}], "}"}]}], ")"}], " ", "&"}], " ", ",", " ", 
                    "allcreatedrays"}], "]"}]}]}], ")"}], ";", " ", "\n", 
                    "                     ", 
                    RowBox[{"{", 
                    RowBox[{"allcreatedrays", ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",",
                     " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", 
                    "1.", ",", " ", "\n", "                        ", "1.", 
                    ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", 
                    "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",",
                     " ", 
                    RowBox[{"-", "9.87654321*^8"}], ",", " ", "\n", 
                    "                        ", "1.", ",", " ", "1.", ",", 
                    " ", "1.", ",", " ", "1.", ",", " ", "0.", ",", " ", 
                    RowBox[{"-", "1."}], ",", " ", 
                    RowBox[{"-", "1."}], ",", " ", 
                    RowBox[{"-", "1."}], ",", " ", "1.", ",", " ", "1.", ",", 
                    " ", "1.", ",", " ", "\n", "                        ", 
                    "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",",
                     " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", 
                    "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1."}], 
                    "}"}], "}"}], ",", " ", "\n", "                      ", 
                    RowBox[{"{", "completedray", "}"}]}], "}"}]}], ",", " ", 
                    RowBox[{"resonatenumber", " ", "==", " ", "6"}], ",", " ",
                     "\n", "                    ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "rez", ",", " ", "r1", ",", 
                    " ", "r2", ",", " ", "r3", ",", " ", "r4", ",", " ", "r5",
                     ",", " ", "\n", "                       ", "r6", ",", 
                    " ", "r7", ",", " ", "r8", ",", " ", "r9", ",", " ", 
                    "wavelength", ",", " ", "intensity", ",", " ", "\n", 
                    "                       ", "intensityscale", ",", " ", 
                    "ray1", ",", " ", "index", ",", " ", "opticallength", ",",
                     " ", "\n", "                       ", "phaseshift", ",", 
                    " ", "componentnumber", ",", " ", "surfacenumber", ",", 
                    " ", "\n", "                       ", "surfaceid", ",", 
                    " ", "ray2", ",", " ", "ray3", ",", " ", "sid", ",", " ", 
                    "frontid", ",", " ", "sno1", ",", " ", "sno2", ",", " ", 
                    "\n", "                       ", "sno3", ",", " ", "sno4",
                     ",", " ", "rayslot", ",", " ", "oldgenerationnumber", 
                    ",", " ", "\n", "                       ", 
                    "intersectionnumber", ",", " ", "pol1", ",", " ", "pol2", 
                    ",", " ", "pol3"}], "}"}], " ", "=", " ", "#1"}], ";", 
                    " ", "\n", "                     ", 
                    RowBox[{"index1", " ", "=", " ", "index"}], ";", " ", 
                    RowBox[{"xunit", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"r1", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", "\n", "                        ", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]23"}], 
                    "]"}], "]"}]}], " ", "+", " ", 
                    RowBox[{"r2", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", "\n", "                        ", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]23"}], 
                    "]"}], "]"}]}]}]}], ";", " ", 
                    RowBox[{
                    "yunit", " ", "=", " ", "\n", "                      ", 
                    RowBox[{
                    RowBox[{"r2", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]23"}], 
                    "]"}], "]"}]}], " ", "-", " ", 
                    RowBox[{
                    "1.", "*", "r1", "*", "\n", "                        ", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]23"}], 
                    "]"}], "]"}]}]}]}], ";", " ", 
                    RowBox[{
                    "zunit", " ", "=", " ", "\n", "                      ", 
                    RowBox[{"r3", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]23"}], 
                    "]"}], "^", "2"}], " ", "+", " ", "\n", 
                    "                        ", 
                    RowBox[{
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]23"}], 
                    "]"}], "^", "2"}]}], "]"}]}]}], ";", " ", 
                    RowBox[{
                    "xunit", " ", "=", " ", "\n", "                      ", 
                    RowBox[{"Chop", "[", "xunit", "]"}]}], ";", " ", 
                    RowBox[{"yunit", " ", "=", " ", 
                    RowBox[{"Chop", "[", "yunit", "]"}]}], ";", " ", 
                    RowBox[{
                    "zunit", " ", "=", " ", "\n", "                      ", 
                    RowBox[{"Chop", "[", "zunit", "]"}]}], ";", " ", 
                    RowBox[{"magnitude", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"xunit", "^", "2"}], " ", "+", " ", 
                    RowBox[{"yunit", "^", "2"}], " ", "+", " ", "\n", 
                    "                        ", 
                    RowBox[{"zunit", "^", "2"}]}], ")"}], "^", 
                    RowBox[{"2", "^", 
                    RowBox[{"(", 
                    RowBox[{"-", "1"}], ")"}]}]}]}], ";", " ", 
                    RowBox[{"xunit", " ", "=", " ", 
                    RowBox[{"xunit", "/", "magnitude"}]}], ";", " ", "\n", 
                    "                     ", 
                    RowBox[{"yunit", " ", "=", " ", 
                    RowBox[{"yunit", "/", "magnitude"}]}], ";", " ", 
                    RowBox[{"zunit", " ", "=", " ", 
                    RowBox[{"zunit", "/", "magnitude"}]}], ";", " ", "\n", 
                    "                     ", 
                    RowBox[{"rx", " ", "=", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]23"}], 
                    "]"}], "]"}], "*", 
                    RowBox[{"(", 
                    RowBox[{
                    "rex", " ", "-", " ", "\n", "                        ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"x23", " ", "+", " ", 
                    RowBox[{"9.6", "*", 
                    RowBox[{"Cos", "[", 
                    RowBox[{
                    "0.017453292519943295", "*", "\n", 
                    "                        ", "\[Theta]23"}], "]"}]}]}], 
                    "]"}]}]}], ")"}]}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"rey", " ", "-", " ", 
                    RowBox[{"9.6", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", "\n", "                        ", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]23"}], 
                    "]"}], "]"}]}]}], ")"}], "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", "\n", "                        ", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]23"}], 
                    "]"}], "]"}]}]}]}], ";", " ", 
                    RowBox[{
                    "ry", " ", "=", " ", "\n", "                      ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]23"}], 
                    "]"}], "]"}], "*", 
                    RowBox[{"(", 
                    RowBox[{
                    "rey", " ", "-", " ", "\n", "                        ", 
                    RowBox[{"9.6", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]23"}], 
                    "]"}], "]"}]}]}], ")"}]}], " ", "-", " ", "\n", 
                    "                       ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"(", 
                    RowBox[{"rex", " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"x23", " ", "+", " ", 
                    RowBox[{"9.6", "*", 
                    RowBox[{"Cos", "[", "\n", "                        ", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]23"}], 
                    "]"}]}]}], "]"}]}]}], ")"}], "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", "\n", "                        ", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]23"}], 
                    "]"}], "]"}]}]}]}], ";", " ", 
                    RowBox[{"rz", " ", "=", " ", 
                    RowBox[{"rez", "*", "\n", "                       ", 
                    RowBox[{"Re", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]23"}], 
                    "]"}], "^", "2"}], " ", "+", " ", "\n", 
                    "                        ", 
                    RowBox[{
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]23"}], 
                    "]"}], "^", "2"}]}], "]"}]}]}], ";", " ", 
                    RowBox[{
                    "rx", " ", "=", " ", "\n", "                      ", 
                    RowBox[{"Chop", "[", "rx", "]"}]}], ";", " ", 
                    RowBox[{"ry", " ", "=", " ", 
                    RowBox[{"Chop", "[", "ry", "]"}]}], ";", " ", 
                    RowBox[{"rz", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rz", "]"}]}], ";", " ", "\n", 
                    "                     ", 
                    RowBox[{"terminatedeflection", " ", "=", " ", "False"}], 
                    ";", " ", 
                    RowBox[{
                    "intersections", " ", "=", " ", "\n", 
                    "                      ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}], "}"}]}], ";", " ", 
                    RowBox[{
                    "intersections", " ", "=", " ", "\n", 
                    "                      ", "resonateintersections"}], ";", 
                    " ", 
                    RowBox[{"holeQ", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"holeQlist", "[", 
                    RowBox[{
                    "[", "\n", "                        ", "resonatenumber", 
                    "]"}], "]"}], " ", "==", " ", "1"}]}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "newcomponentnumber", ",", " ", "\n", 
                    "                       ", "newsurfacenumber", ",", " ", 
                    "newsurfaceid"}], "}"}], " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"1.", ",", " ", "6.", ",", " ", "\n", 
                    "                       ", "92312."}], "}"}]}], ";", " ", 
                    
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "componentnumber", ",", " ", "surfacenumber", ",", " ", 
                    "\n", "                       ", "surfaceid"}], "}"}], 
                    " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"1.", ",", " ", "6.", ",", " ", "92312."}], 
                    "}"}]}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "ray1", ",", " ", "ray2", ",", " ", "\n", 
                    "                       ", "ray3"}], "}"}], " ", "=", " ", 
                    RowBox[{"intersections", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], ";", " ", 
                    RowBox[{"rsx", " ", "=", " ", "rex"}], ";", " ", 
                    RowBox[{"rsy", " ", "=", " ", "rey"}], ";", " ", "\n", 
                    "                     ", 
                    RowBox[{"rsz", " ", "=", " ", "rez"}], ";", " ", 
                    RowBox[{"rxhlp", " ", "=", " ", 
                    RowBox[{"rx", " ", "+", " ", 
                    RowBox[{"ray1", "*", "xunit"}]}]}], ";", " ", 
                    RowBox[{
                    "ryhlp", " ", "=", " ", "\n", "                      ", 
                    RowBox[{"ry", " ", "+", " ", 
                    RowBox[{"ray1", "*", "yunit"}]}]}], ";", " ", 
                    RowBox[{"rzhlp", " ", "=", " ", 
                    RowBox[{"rz", " ", "+", " ", 
                    RowBox[{"ray1", "*", "zunit"}]}]}], ";", " ", "\n", 
                    "                     ", 
                    RowBox[{"rex", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"rxhlp", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]23"}], 
                    "]"}], "]"}]}], " ", "+", " ", "\n", 
                    "                       ", 
                    RowBox[{"Re", "[", 
                    RowBox[{"x23", " ", "+", " ", 
                    RowBox[{"9.6", "*", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]23"}], 
                    "]"}]}]}], "]"}], " ", "-", " ", "\n", 
                    "                       ", 
                    RowBox[{"1.", "*", "ryhlp", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]23"}], 
                    "]"}], "]"}]}]}]}], ";", " ", "\n", 
                    "                     ", 
                    RowBox[{"rey", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"ryhlp", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]23"}], 
                    "]"}], "]"}]}], " ", "+", " ", "\n", 
                    "                       ", 
                    RowBox[{"9.6", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]23"}], 
                    "]"}], "]"}]}], " ", "+", " ", "\n", 
                    "                       ", 
                    RowBox[{"rxhlp", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]23"}], 
                    "]"}], "]"}]}]}]}], ";", " ", "\n", 
                    "                     ", 
                    RowBox[{"rez", " ", "=", " ", 
                    RowBox[{"rzhlp", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]23"}], 
                    "]"}], "^", "2"}], " ", "+", " ", "\n", 
                    "                        ", 
                    RowBox[{
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]23"}], 
                    "]"}], "^", "2"}]}], "]"}]}]}], ";", " ", 
                    RowBox[{
                    "rex", " ", "=", " ", "\n", "                      ", 
                    RowBox[{"Chop", "[", "rex", "]"}]}], ";", " ", 
                    RowBox[{"rey", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rey", "]"}]}], ";", " ", 
                    RowBox[{"rez", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rez", "]"}]}], ";", " ", "\n", 
                    "                     ", 
                    RowBox[{"intersectionnumber", " ", "=", " ", 
                    RowBox[{"intersectionnumber", " ", "+", " ", "1."}]}], 
                    ";", " ", "\n", "                     ", 
                    RowBox[{"opticallength", " ", "=", " ", 
                    RowBox[{"opticallength", " ", "+", " ", 
                    RowBox[{"ray1", "*", "index1"}]}]}], ";", " ", "\n", 
                    "                     ", 
                    RowBox[{"completedray", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "rez", ",", " ", "r1", ",", 
                    " ", "\n", "                       ", "r2", ",", " ", 
                    "r3", ",", " ", "r4", ",", " ", "r5", ",", " ", "r6", ",",
                     " ", "r7", ",", " ", "r8", ",", " ", "r9", ",", " ", 
                    "wavelength", ",", " ", "\n", "                       ", 
                    "intensity", ",", " ", "intensityscale", ",", " ", "ray1",
                     ",", " ", "index", ",", " ", "\n", 
                    "                       ", "opticallength", ",", " ", 
                    "phaseshift", ",", " ", "componentnumber", ",", " ", "\n",
                     "                       ", "surfacenumber", ",", " ", 
                    "surfaceid", ",", " ", "ray2", ",", " ", "ray3", ",", " ",
                     "sid", ",", " ", "\n", "                       ", 
                    "frontid", ",", " ", "sno1", ",", " ", "sno2", ",", " ", 
                    "sno3", ",", " ", "sno4", ",", " ", "rayslot", ",", " ", 
                    "\n", "                       ", "generationnumber", ",", 
                    " ", "intersectionnumber", ",", " ", "pol1", ",", " ", 
                    "pol2", ",", " ", "\n", "                       ", 
                    "pol3"}], "}"}]}], ";", " ", 
                    RowBox[{"reportedrayspresent", " ", "=", " ", "True"}], 
                    ";", " ", "\n", "                     ", 
                    RowBox[{"intersectionspresent", " ", "=", " ", "True"}], 
                    ";", " ", 
                    RowBox[{
                    "deflectedrayspresent", " ", "=", " ", "\n", 
                    "                      ", "True"}], ";", " ", 
                    RowBox[{
                    "localdummyoutrayspresent", " ", "=", " ", "True"}], ";", 
                    " ", "\n", "                     ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"surfnorm", " ", "=", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"1.", ",", " ", 
                    RowBox[{
                    RowBox[{"-", "1."}], "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"Sign", "[", "r23", "]"}], "*", "ray2"}], ")"}], 
                    "/", "\n", "                        ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"r23", "^", "2"}], " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"ray2", "^", "2"}]}], " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"ray3", "^", "2"}]}]}], ")"}], "^", "0.5"}]}], 
                    ")"}]}], ",", " ", 
                    RowBox[{
                    RowBox[{"-", "1."}], "*", "\n", 
                    "                        ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"Sign", "[", "r23", "]"}], "*", "ray3"}], ")"}], 
                    "/", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"r23", "^", "2"}], " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"ray2", "^", "2"}]}], " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{
                    "ray3", "^", "\n", "                        ", "2"}]}]}], 
                    ")"}], "^", "0.5"}]}], ")"}]}]}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"Sign", "[", "r23", "]"}], "*", "ray2"}], ")"}], 
                    "/", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"r23", "^", "2"}], " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"ray2", "^", "2"}]}], " ", "-", " ", "\n", 
                    "                        ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"ray3", "^", "2"}]}]}], ")"}], "^", "0.5"}]}], 
                    ",", " ", "1.", ",", " ", "0."}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"Sign", "[", "r23", "]"}], "*", "ray3"}], ")"}], 
                    "/", "\n", "                        ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"r23", "^", "2"}], " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"ray2", "^", "2"}]}], " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"ray3", "^", "2"}]}]}], ")"}], "^", "0.5"}]}], 
                    ",", " ", "0.", ",", " ", "1."}], "}"}]}], "}"}], 
                    "]"}]}]}], ";", " ", "\n", "                      ", 
                    RowBox[{"dummymatrix", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{
                    "0.017453292519943295", "*", "\n", 
                    "                        ", "\[Theta]23"}], "]"}], "]"}], 
                    ",", " ", 
                    RowBox[{
                    RowBox[{"-", "1."}], "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{
                    "0.017453292519943295", "*", "\n", 
                    "                        ", "\[Theta]23"}], "]"}], 
                    "]"}]}], ",", " ", "0."}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{
                    "0.017453292519943295", "*", "\n", 
                    "                        ", "\[Theta]23"}], "]"}], "]"}], 
                    ",", " ", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]23"}], 
                    "]"}], "]"}], ",", " ", "\n", "                        ", 
                    "0."}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "0.", ",", " ", "1."}], "}"}]}], 
                    "}"}], " ", ".", " ", "#1"}], " ", "&"}], " ", ")"}], " ",
                     "/@", " ", "surfnorm"}]}], ";", " ", "\n", 
                    "                      ", 
                    RowBox[{"surfnorm", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"#1", "/", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"#1", " ", ".", " ", "#1"}], "]"}]}], " ", "&"}], 
                    " ", ")"}], " ", "/@", " ", "dummymatrix"}]}], ";", " ", 
                    "\n", "                      ", 
                    RowBox[{"surfacerotationmatrix", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", "\n", "                        ", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]23"}], 
                    "]"}], "]"}], ",", " ", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", "\n", "                        ", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]23"}], 
                    "]"}], "]"}], ",", " ", "0."}], "}"}], ",", " ", "\n", 
                    "                        ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "1."}], "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]23"}], 
                    "]"}], "]"}]}], ",", " ", "\n", 
                    "                        ", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]23"}], 
                    "]"}], "]"}], ",", " ", "0."}], "}"}], ",", " ", "\n", 
                    "                        ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "0.", ",", " ", "1."}], "}"}]}], 
                    "}"}]}], ";", " ", 
                    RowBox[{"surfacetranslationvector", " ", "=", " ", "\n", 
                    "                       ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"x23", " ", "+", " ", 
                    RowBox[{"9.6", "*", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]23"}], 
                    "]"}]}]}], "]"}], ",", " ", "\n", 
                    "                        ", 
                    RowBox[{"9.6", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "\[Theta]23"}], 
                    "]"}], "]"}]}], ",", " ", "0."}], "}"}]}], ";", " ", "\n",
                     "                      ", 
                    RowBox[{"activeregion", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"completedray", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "\n", 
                    "                        ", "rex", ",", " ", "rey", ",", 
                    " ", "rez", ",", " ", "r1", ",", " ", "r2", ",", " ", 
                    "r3", ",", " ", "r4", ",", " ", "r5", ",", " ", "r6", ",",
                     " ", "r7", ",", " ", "r8", ",", " ", "\n", 
                    "                        ", "r9", ",", " ", "wavelength", 
                    ",", " ", "intensity", ",", " ", "intensityscale", ",", 
                    " ", "ray1", ",", " ", "\n", "                        ", 
                    "index", ",", " ", "opticallength", ",", " ", 
                    "phaseshift", ",", " ", "\n", "                        ", 
                    "componentnumber", ",", " ", "surfacenumber", ",", " ", 
                    "surfaceid", ",", " ", "ray2", ",", " ", "\n", 
                    "                        ", "ray3", ",", " ", "sid", ",", 
                    " ", "frontid", ",", " ", "sno1", ",", " ", "sno2", ",", 
                    " ", "sno3", ",", " ", "sno4", ",", " ", "\n", 
                    "                        ", "rayslot", ",", " ", 
                    "generationnumber", ",", " ", "intersectionnumber", ",", 
                    " ", "\n", "                        ", "pol1", ",", " ", 
                    "pol2", ",", " ", "pol3"}], "}"}]}], ";", " ", 
                    RowBox[{
                    "componentnumber", " ", "=", " ", "\n", 
                    "                       ", "newcomponentnumber"}], ";", 
                    " ", 
                    RowBox[{
                    "surfacenumber", " ", "=", " ", "\n", 
                    "                       ", "newsurfacenumber"}], ";", " ", 
                    RowBox[{"surfaceid", " ", "=", " ", "newsurfaceid"}], ";",
                     " ", "\n", "                      ", 
                    RowBox[{"originalray", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "rez", ",", " ", "r1", ",", 
                    " ", "\n", "                        ", "r2", ",", " ", 
                    "r3", ",", " ", "r4", ",", " ", "r5", ",", " ", "r6", ",",
                     " ", "r7", ",", " ", "r8", ",", " ", "r9", ",", " ", 
                    "wavelength", ",", " ", "\n", "                        ", 
                    "intensity", ",", " ", "intensityscale", ",", " ", "ray1",
                     ",", " ", "index", ",", " ", "\n", 
                    "                        ", "opticallength", ",", " ", 
                    "phaseshift", ",", " ", "componentnumber", ",", " ", "\n",
                     "                        ", "surfacenumber", ",", " ", 
                    "surfaceid", ",", " ", "ray2", ",", " ", "ray3", ",", " ",
                     "sid", ",", " ", "\n", "                        ", 
                    "frontid", ",", " ", "sno1", ",", " ", "sno2", ",", " ", 
                    "sno3", ",", " ", "sno4", ",", " ", "rayslot", ",", " ", 
                    "\n", "                        ", "generationnumber", ",",
                     " ", "intersectionnumber", ",", " ", "pol1", ",", " ", 
                    "\n", "                        ", "pol2", ",", " ", 
                    "pol3"}], "}"}]}], ";", " ", 
                    RowBox[{"ZAxis", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"First", "[", "surfnorm", "]"}], "*", 
                    RowBox[{"Sign", "[", "\n", "                        ", 
                    RowBox[{
                    RowBox[{"First", "[", "surfnorm", "]"}], " ", ".", " ", 
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}]}], 
                    "]"}]}]}], ";", " ", 
                    RowBox[{
                    "raytiltz", " ", "=", " ", "\n", 
                    "                       ", 
                    RowBox[{"ZAxis", " ", ".", " ", 
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}]}]}],
                     ";", " ", 
                    RowBox[{"raytiltx", " ", "=", " ", 
                    RowBox[{"1", " ", "-", " ", 
                    RowBox[{"raytiltz", "^", "2"}]}]}], ";", " ", "\n", 
                    "                      ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    "raytiltx", " ", "<", " ", "2.220446049250313*^-16"}], 
                    ",", " ", 
                    RowBox[{
                    "raytiltx", " ", "=", " ", "\n", 
                    "                        ", "0."}], ",", " ", 
                    RowBox[{"raytiltx", " ", "=", " ", 
                    RowBox[{"Sqrt", "[", "raytiltx", "]"}]}]}], "]"}], ";", 
                    " ", 
                    RowBox[{
                    "XAxis", " ", "=", " ", "\n", "                       ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    " ", "-", " ", 
                    RowBox[{"ZAxis", "*", "raytiltz"}]}]}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", "raytiltx", "]"}], " ", "<", " ", 
                    "\n", "                        ", "1.*^-7"}], ",", " ", 
                    RowBox[{"XAxis", " ", "=", " ", 
                    RowBox[{"surfnorm", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], ",", " ", 
                    RowBox[{"XAxis", " ", "=", " ", 
                    RowBox[{"XAxis", "/", "\n", "                        ", 
                    "raytiltx"}]}]}], "]"}], ";", " ", 
                    RowBox[{"YAxis", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"ZAxis", "[", 
                    RowBox[{"[", "3", "]"}], "]"}], "*", 
                    RowBox[{"XAxis", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], ")"}]}], " ", "+", " ", 
                    "\n", "                        ", 
                    RowBox[{
                    RowBox[{"ZAxis", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "*", 
                    RowBox[{"XAxis", "[", 
                    RowBox[{"[", "3", "]"}], "]"}]}]}], ",", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"ZAxis", "[", 
                    RowBox[{"[", "3", "]"}], "]"}], "*", 
                    RowBox[{"XAxis", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], " ", "-", " ", "\n", 
                    "                        ", 
                    RowBox[{
                    RowBox[{"ZAxis", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "*", 
                    RowBox[{"XAxis", "[", 
                    RowBox[{"[", "3", "]"}], "]"}]}]}], ",", " ", 
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"ZAxis", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "*", 
                    RowBox[{"XAxis", "[", 
                    RowBox[{"[", "\n", "                        ", "1", "]"}],
                     "]"}]}], ")"}]}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"ZAxis", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "*", 
                    RowBox[{"XAxis", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}]}]}], "}"}]}], ";", " ", 
                    RowBox[{"YAxis", " ", "=", " ", 
                    RowBox[{"YAxis", "/", "\n", "                        ", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"YAxis", " ", ".", " ", "YAxis"}], "]"}]}]}], ";",
                     " ", 
                    RowBox[{"PAxis", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"ZAxis", "*", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "r1", ",", " ", "r2", ",", " ", "\n", 
                    "                        ", "r3"}], "}"}], " ", ".", " ", 
                    "XAxis"}]}], " ", "-", " ", 
                    RowBox[{"XAxis", "*", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    " ", ".", " ", "ZAxis"}]}]}]}], ";", " ", "\n", 
                    "                      ", 
                    RowBox[{"PAxis", " ", "=", " ", 
                    RowBox[{"PAxis", "/", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"PAxis", " ", ".", " ", "PAxis"}], "]"}]}]}], ";",
                     " ", "\n", "                      ", 
                    RowBox[{"normalizedpolarization", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], "[", 
                    RowBox[{"[", "\n", "                        ", 
                    RowBox[{"{", 
                    RowBox[{"1", ",", " ", "2"}], "}"}], "]"}], "]"}]}], ";", 
                    " ", 
                    RowBox[{
                    "normalizedpolarization", " ", "=", " ", "\n", 
                    "                       ", 
                    RowBox[{"normalizedpolarization", "/", 
                    RowBox[{"Sqrt", "[", "\n", "                        ", 
                    RowBox[{
                    "normalizedpolarization", " ", ".", " ", "\n", 
                    "                        ", "normalizedpolarization"}], 
                    "]"}]}]}], ";", " ", 
                    RowBox[{
                    "allcreatedamplitudes", " ", "=", " ", "\n", 
                    "                       ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"I", "*", "0."}], ",", " ", 
                    RowBox[{"I", "*", "0."}], ",", " ", 
                    RowBox[{"I", "*", "0."}]}], "}"}], "}"}]}], ";", " ", 
                    RowBox[{"amplitude", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"Sqrt", "[", "intensity", "]"}], "*", "\n", 
                    "                        ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"normalizedpolarization", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "*", 
                    RowBox[{"{", 
                    RowBox[{"r4", ",", " ", "r5", ",", " ", "r6"}], "}"}]}], 
                    " ", "+", " ", "\n", "                        ", 
                    RowBox[{
                    RowBox[{"normalizedpolarization", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "*", 
                    RowBox[{"{", 
                    RowBox[{"r7", ",", " ", "r8", ",", " ", "r9"}], "}"}], 
                    "*", "\n", "                        ", 
                    RowBox[{"Exp", "[", 
                    RowBox[{"I", "*", "pol3", "*", "0.017453292519943295"}], 
                    "]"}]}]}], ")"}]}]}], ";", " ", "\n", 
                    "                      ", 
                    RowBox[{"perpendicularamplitude", " ", "=", " ", 
                    RowBox[{"amplitude", " ", ".", " ", "YAxis"}]}], ";", " ",
                     "\n", "                      ", 
                    RowBox[{"parallelamplitude", " ", "=", " ", 
                    RowBox[{"amplitude", " ", ".", " ", "PAxis"}]}], ";", " ",
                     "\n", "                      ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"activeregion", "*", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"surfacerotationmatrix", " ", ".", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "r1", ",", " ", "r2", ",", " ", "\n", 
                    "                        ", "r3"}], "}"}]}], ")"}], "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], " ", ">", " ", "0"}], 
                    ",", " ", 
                    RowBox[{
                    RowBox[{"index2", " ", "=", " ", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{
                    "2.7105646", " ", "-", " ", "\n", 
                    "                        ", 
                    RowBox[{"0.009121199600000001", "*", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", 
                    RowBox[{
                    "0.027760538", "/", "\n", "                        ", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", 
                    RowBox[{"0.0012739656", "/", 
                    RowBox[{"wavelength", "^", "4"}]}], " ", "-", " ", "\n", 
                    "                        ", 
                    RowBox[{"0.000047889342", "/", 
                    RowBox[{"wavelength", "^", "6"}]}], " ", "+", " ", 
                    RowBox[{
                    "8.0562028*^-6", "/", "\n", "                        ", 
                    RowBox[{"wavelength", "^", "8"}]}]}], "]"}]}], ";", " ", 
                    RowBox[{"index1", " ", "=", " ", "index"}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", 
                    RowBox[{
                    "index2", " ", "-", " ", "\n", "                        ",
                     "index1"}], "]"}], " ", "<", " ", "0.01"}], ",", " ", 
                    RowBox[{
                    RowBox[{"alternateindex", " ", "=", " ", 
                    RowBox[{"Sqrt", "[", "\n", "                        ", 
                    RowBox[{"1.0005281111748805", " ", "-", " ", 
                    RowBox[{
                    "2.364805676582992*^-10", "*", "\n", 
                    "                        ", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", 
                    RowBox[{"2.9781670902982902*^-6", "/", 
                    RowBox[{
                    "wavelength", "^", "\n", "                        ", 
                    "2"}]}], " ", "+", " ", 
                    RowBox[{"2.6004099469477187*^-8", "/", 
                    RowBox[{"wavelength", "^", "4"}]}], " ", "+", " ", "\n", 
                    "                        ", 
                    RowBox[{"3.7787839314048715*^-10", "/", 
                    RowBox[{"wavelength", "^", "6"}]}], " ", "+", " ", "\n", 
                    "                        ", 
                    RowBox[{"2.830549017940716*^-12", "/", 
                    RowBox[{"wavelength", "^", "8"}]}]}], "]"}]}], ";", " ", 
                    "\n", "                        ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", 
                    RowBox[{"alternateindex", " ", "-", " ", "index1"}], 
                    "]"}], " ", ">", " ", 
                    RowBox[{"Abs", "[", 
                    RowBox[{
                    "index2", " ", "-", " ", "\n", "                        ",
                     "index1"}], "]"}]}], ",", " ", 
                    RowBox[{
                    RowBox[{"index1", " ", "=", " ", "index2"}], ";", " ", 
                    RowBox[{
                    "index2", " ", "=", " ", "\n", "                        ",
                     "alternateindex"}]}], ",", " ", 
                    RowBox[{"index1", " ", "=", " ", "alternateindex"}]}], 
                    "]"}]}], ",", " ", "\n", "                        ", 
                    RowBox[{"index1", " ", "=", " ", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{
                    "1.0005281111748805", " ", "-", " ", "\n", 
                    "                        ", 
                    RowBox[{"2.364805676582992*^-10", "*", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", "\n", 
                    "                        ", 
                    RowBox[{"2.9781670902982902*^-6", "/", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", "\n", 
                    "                        ", 
                    RowBox[{"2.6004099469477187*^-8", "/", 
                    RowBox[{"wavelength", "^", "4"}]}], " ", "+", " ", "\n", 
                    "                        ", 
                    RowBox[{"3.7787839314048715*^-10", "/", 
                    RowBox[{"wavelength", "^", "6"}]}], " ", "+", " ", "\n", 
                    "                        ", 
                    RowBox[{"2.830549017940716*^-12", "/", 
                    RowBox[{"wavelength", "^", "8"}]}]}], "]"}]}]}], "]"}]}], 
                    ",", " ", "\n", "                       ", 
                    RowBox[{
                    RowBox[{"index2", " ", "=", " ", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{
                    "1.0005281111748805", " ", "-", " ", "\n", 
                    "                        ", 
                    RowBox[{"2.364805676582992*^-10", "*", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", "\n", 
                    "                        ", 
                    RowBox[{"2.9781670902982902*^-6", "/", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", "\n", 
                    "                        ", 
                    RowBox[{"2.6004099469477187*^-8", "/", 
                    RowBox[{"wavelength", "^", "4"}]}], " ", "+", " ", "\n", 
                    "                        ", 
                    RowBox[{"3.7787839314048715*^-10", "/", 
                    RowBox[{"wavelength", "^", "6"}]}], " ", "+", " ", "\n", 
                    "                        ", 
                    RowBox[{"2.830549017940716*^-12", "/", 
                    RowBox[{"wavelength", "^", "8"}]}]}], "]"}]}], ";", " ", 
                    RowBox[{
                    "index1", " ", "=", " ", "\n", "                        ",
                     "index"}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", 
                    RowBox[{"index2", " ", "-", " ", "index1"}], "]"}], " ", 
                    "<", " ", "0.01"}], ",", " ", "\n", 
                    "                        ", 
                    RowBox[{
                    RowBox[{"alternateindex", " ", "=", " ", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{
                    "2.7105646", " ", "-", " ", "\n", 
                    "                        ", 
                    RowBox[{"0.009121199600000001", "*", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", 
                    RowBox[{
                    "0.027760538", "/", "\n", "                        ", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", 
                    RowBox[{"0.0012739656", "/", 
                    RowBox[{"wavelength", "^", "4"}]}], " ", "-", " ", "\n", 
                    "                        ", 
                    RowBox[{"0.000047889342", "/", 
                    RowBox[{"wavelength", "^", "6"}]}], " ", "+", " ", 
                    RowBox[{
                    "8.0562028*^-6", "/", "\n", "                        ", 
                    RowBox[{"wavelength", "^", "8"}]}]}], "]"}]}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", 
                    RowBox[{"alternateindex", " ", "-", " ", "index1"}], 
                    "]"}], " ", ">", " ", "\n", "                        ", 
                    RowBox[{"Abs", "[", 
                    RowBox[{"index2", " ", "-", " ", "index1"}], "]"}]}], ",",
                     " ", 
                    RowBox[{
                    RowBox[{"index1", " ", "=", " ", "index2"}], ";", " ", 
                    RowBox[{
                    "index2", " ", "=", " ", "\n", "                        ",
                     "alternateindex"}]}], ",", " ", 
                    RowBox[{"index1", " ", "=", " ", "alternateindex"}]}], 
                    "]"}]}], ",", " ", "\n", "                        ", 
                    RowBox[{"index1", " ", "=", " ", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"2.7105646", " ", "-", " ", 
                    RowBox[{
                    "0.009121199600000001", "*", "\n", 
                    "                        ", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", 
                    RowBox[{"0.027760538", "/", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", "\n", 
                    "                        ", 
                    RowBox[{"0.0012739656", "/", 
                    RowBox[{"wavelength", "^", "4"}]}], " ", "-", " ", 
                    RowBox[{
                    "0.000047889342", "/", "\n", "                        ", 
                    RowBox[{"wavelength", "^", "6"}]}], " ", "+", " ", 
                    RowBox[{"8.0562028*^-6", "/", 
                    RowBox[{"wavelength", "^", "8"}]}]}], "]"}]}]}], 
                    "]"}]}]}], "]"}], ";", " ", "\n", 
                    "                      ", 
                    RowBox[{"n12", " ", "=", " ", 
                    RowBox[{"index1", "/", "index2"}]}], ";", " ", 
                    RowBox[{"index", " ", "=", " ", "index2"}], ";", " ", 
                    "\n", "                      ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"1", " ", "-", " ", 
                    RowBox[{
                    RowBox[{"n12", "^", "2"}], "*", 
                    RowBox[{"raytiltx", "^", "2"}]}]}], " ", ">=", " ", 
                    "0."}], ",", " ", 
                    RowBox[{
                    RowBox[{
                    "dummyvector", " ", "=", " ", "\n", 
                    "                        ", 
                    RowBox[{
                    RowBox[{"n12", "*", 
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}]}], 
                    " ", "+", " ", 
                    RowBox[{"ZAxis", "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"(", 
                    RowBox[{"n12", "*", "raytiltz"}], ")"}]}], " ", "+", " ", 
                    "\n", "                        ", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"1", " ", "-", " ", 
                    RowBox[{
                    RowBox[{"n12", "^", "2"}], "*", 
                    RowBox[{"raytiltx", "^", "2"}]}]}], "]"}]}], ")"}]}]}]}], 
                    ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    " ", "=", " ", "\n", "                        ", 
                    "dummyvector"}], ";", " ", "1."}], ",", " ", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    " ", ".", " ", 
                    RowBox[{"surfnorm", "[", 
                    RowBox[{"[", "\n", "                        ", "1", "]"}],
                     "]"}]}], " ", ">", " ", "0"}], ",", " ", 
                    RowBox[{"phaseshift", " ", "=", " ", 
                    RowBox[{"phaseshift", " ", "+", " ", "0.5"}]}], ",", " ", 
                    "1."}], "]"}], ";", " ", "\n", "                        ", 
                    RowBox[{"index2", " ", "=", " ", "index1"}], ";", " ", 
                    RowBox[{"index", " ", "=", " ", "index1"}], ";", " ", 
                    RowBox[{"dummyvector", " ", "=", " ", "\n", 
                    "                        ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    " ", "-", " ", 
                    RowBox[{"2", "*", "ZAxis", "*", 
                    RowBox[{"ZAxis", " ", ".", " ", 
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], 
                    "}"}]}]}]}]}], ";", " ", "\n", "                        ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    " ", "=", " ", "dummyvector"}], ";", " ", 
                    RowBox[{
                    "dummyvector", " ", "=", " ", "\n", 
                    "                        ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], " ", "+", " ", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", " ", "0", ",", " ", 
                    RowBox[{"-", "180"}]}], "}"}]}]}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "pol1", ",", " ", "pol2", ",", " ", "\n", 
                    "                        ", "pol3"}], "}"}], " ", "=", 
                    " ", "dummyvector"}], ";", " ", "1."}]}], "]"}], ";", " ", 
                    RowBox[{
                    "allcreatedrays", " ", "=", " ", "\n", 
                    "                       ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "rez", ",", " ", "r1", ",", 
                    " ", "r2", ",", " ", "r3", ",", " ", "r4", ",", " ", "\n",
                     "                        ", "r5", ",", " ", "r6", ",", 
                    " ", "r7", ",", " ", "r8", ",", " ", "r9", ",", " ", 
                    "wavelength", ",", " ", "intensity", ",", " ", "\n", 
                    "                        ", "intensityscale", ",", " ", 
                    "ray1", ",", " ", "index", ",", " ", "opticallength", ",",
                     " ", "\n", "                        ", "phaseshift", ",",
                     " ", "componentnumber", ",", " ", "surfacenumber", ",", 
                    " ", "\n", "                        ", "surfaceid", ",", 
                    " ", "ray2", ",", " ", "ray3", ",", " ", "sid", ",", " ", 
                    "frontid", ",", " ", "sno1", ",", " ", "sno2", ",", " ", 
                    "\n", "                        ", "sno3", ",", " ", 
                    "sno4", ",", " ", "rayslot", ",", " ", "generationnumber",
                     ",", " ", "\n", "                        ", 
                    "intersectionnumber", ",", " ", "pol1", ",", " ", "pol2", 
                    ",", " ", "pol3"}], "}"}], "}"}]}], ";", " ", "\n", 
                    "                      ", 
                    RowBox[{"originalrotation", " ", "=", " ", 
                    RowBox[{"Partition", "[", 
                    RowBox[{
                    RowBox[{"Take", "[", 
                    RowBox[{
                    "originalray", ",", " ", "\n", "                        ", 
                    RowBox[{"{", 
                    RowBox[{"7", ",", " ", "15"}], "}"}]}], "]"}], ",", " ", 
                    "3"}], "]"}]}], ";", " ", 
                    RowBox[{"previoustilt", " ", "=", " ", 
                    RowBox[{"originalrotation", "[", 
                    RowBox[{"[", "\n", "                        ", "1", "]"}],
                     "]"}]}], ";", " ", 
                    RowBox[{"transmatrix", " ", "=", " ", 
                    RowBox[{"MapIndexed", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "\n", 
                    "                        ", "rex", ",", " ", "rey", ",", 
                    " ", "rez", ",", " ", "r1", ",", " ", "r2", ",", " ", 
                    "r3", ",", " ", "r4", ",", " ", "r5", ",", " ", "r6", ",",
                     " ", "r7", ",", " ", "r8", ",", " ", "\n", 
                    "                        ", "r9", ",", " ", "wavelength", 
                    ",", " ", "intensity", ",", " ", "intensityscale", ",", 
                    " ", "ray1", ",", " ", "\n", "                        ", 
                    "index", ",", " ", "opticallength", ",", " ", 
                    "phaseshift", ",", " ", "\n", "                        ", 
                    "componentnumber", ",", " ", "surfacenumber", ",", " ", 
                    "surfaceid", ",", " ", "ray2", ",", " ", "\n", 
                    "                        ", "ray3", ",", " ", "sid", ",", 
                    " ", "frontid", ",", " ", "sno1", ",", " ", "sno2", ",", 
                    " ", "sno3", ",", " ", "sno4", ",", " ", "\n", 
                    "                        ", "rayslot", ",", " ", 
                    "oldgenerationnumber", ",", " ", "\n", 
                    "                        ", "intersectionnumber", ",", 
                    " ", "pol1", ",", " ", "pol2", ",", " ", "pol3"}], "}"}], 
                    " ", "=", " ", "#1"}], ";", " ", "\n", 
                    "                        ", 
                    RowBox[{"rotationaxis", " ", "=", " ", 
                    RowBox[{"Cross", "[", 
                    RowBox[{"previoustilt", ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "r1", ",", " ", "r2", ",", " ", "\n", 
                    "                        ", "r3"}], "}"}]}], "]"}]}], ";",
                     " ", 
                    RowBox[{"axismagnitude", " ", "=", " ", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{
                    "rotationaxis", " ", ".", " ", "\n", 
                    "                        ", "rotationaxis"}], "]"}]}], 
                    ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Chop", "[", "axismagnitude", "]"}], " ", "!=", 
                    " ", "0."}], ",", " ", "\n", "                        ", 
                    RowBox[{
                    RowBox[{"rotationaxis", " ", "=", " ", 
                    RowBox[{"rotationaxis", "/", "axismagnitude"}]}], ";", 
                    " ", "\n", "                        ", 
                    RowBox[{"axismatrix", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"#1", "*", "rotationaxis"}], " ", "&"}], " ", 
                    ")"}], " ", "/@", " ", "\n", "                        ", 
                    "rotationaxis"}]}], ";", " ", 
                    RowBox[{"crossmatrix", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", 
                    RowBox[{"-", 
                    RowBox[{"rotationaxis", "[", 
                    RowBox[{"[", "\n", "                        ", "3", "]"}],
                     "]"}]}], ",", " ", 
                    RowBox[{"rotationaxis", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"rotationaxis", "[", 
                    RowBox[{"[", "3", "]"}], "]"}], ",", " ", "0.", ",", " ", 
                    "\n", "                        ", 
                    RowBox[{"-", 
                    RowBox[{"rotationaxis", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}]}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"rotationaxis", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], ",", " ", "\n", 
                    "                        ", 
                    RowBox[{"rotationaxis", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], ",", " ", "0."}], "}"}]}],
                     "}"}]}], ";", " ", 
                    RowBox[{
                    "cosangle", " ", "=", " ", "\n", 
                    "                        ", 
                    RowBox[{"previoustilt", " ", ".", " ", 
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}]}]}],
                     ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"1.", " ", "-", " ", "cosangle"}], " ", "<", " ", 
                    "\n", "                        ", 
                    "2.220446049250313*^-16"}], ",", " ", 
                    RowBox[{"cosangle", " ", "=", " ", "1."}]}], "]"}], ";", 
                    " ", "\n", "                        ", 
                    RowBox[{"sinangle", " ", "=", " ", 
                    RowBox[{"1", " ", "-", " ", 
                    RowBox[{"cosangle", "^", "2"}]}]}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    "sinangle", " ", "<", " ", "\n", 
                    "                        ", "2.220446049250313*^-16"}], 
                    ",", " ", 
                    RowBox[{"sinangle", " ", "=", " ", "0."}], ",", " ", "\n",
                     "                        ", 
                    RowBox[{"sinangle", " ", "=", " ", 
                    RowBox[{"Sqrt", "[", "sinangle", "]"}]}]}], "]"}], ";", 
                    " ", 
                    RowBox[{
                    "axismatrix", " ", "+", " ", "\n", 
                    "                        ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"1.", ",", " ", "0.", ",", " ", "0."}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "1.", ",", " ", "0."}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "0.", ",", " ", "1."}], "}"}]}], 
                    "}"}], " ", "-", " ", "\n", "                        ", 
                    "axismatrix"}], ")"}], "*", "cosangle"}], " ", "+", " ", 
                    RowBox[{"crossmatrix", "*", "sinangle"}]}]}], ",", " ", 
                    "\n", "                        ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"r4", ",", " ", "r5", ",", " ", "r6"}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"r7", ",", " ", "r8", ",", " ", "r9"}], "}"}]}], 
                    "}"}], " ", "=", " ", "\n", "                        ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Sign", "[", 
                    RowBox[{"previoustilt", " ", ".", " ", 
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}]}], 
                    "]"}], " ", "===", " ", "1"}], ",", " ", "\n", 
                    "                        ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"1.", ",", " ", "0.", ",", " ", "0."}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "1.", ",", " ", "0."}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "0.", ",", " ", "1."}], "}"}]}], 
                    "}"}], ",", " ", "\n", "                        ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", 
                    RowBox[{"-", "1."}], ",", " ", "0."}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "0.", ",", " ", "0.", ",", " ", "\n", 
                    "                        ", 
                    RowBox[{"-", "1."}]}], "}"}]}], "}"}]}], "]"}]}]}], 
                    "]"}]}], ")"}], " ", "&"}], " ", ",", " ", 
                    "allcreatedrays"}], "]"}]}], ";", " ", 
                    RowBox[{
                    "allcreatedrays", " ", "=", " ", "\n", 
                    "                       ", 
                    RowBox[{"MapIndexed", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "rez", ",", " ", "r1", ",", 
                    " ", "\n", "                        ", "r2", ",", " ", 
                    "r3", ",", " ", "r4", ",", " ", "r5", ",", " ", "r6", ",",
                     " ", "r7", ",", " ", "r8", ",", " ", "r9", ",", " ", 
                    "wavelength", ",", " ", "\n", "                        ", 
                    "intensity", ",", " ", "intensityscale", ",", " ", "ray1",
                     ",", " ", "index", ",", " ", "\n", 
                    "                        ", "opticallength", ",", " ", 
                    "phaseshift", ",", " ", "componentnumber", ",", " ", "\n",
                     "                        ", "surfacenumber", ",", " ", 
                    "surfaceid", ",", " ", "ray2", ",", " ", "ray3", ",", " ",
                     "sid", ",", " ", "\n", "                        ", 
                    "frontid", ",", " ", "sno1", ",", " ", "sno2", ",", " ", 
                    "sno3", ",", " ", "sno4", ",", " ", "rayslot", ",", " ", 
                    "\n", "                        ", "oldgenerationnumber", 
                    ",", " ", "intersectionnumber", ",", " ", "pol1", ",", 
                    " ", "\n", "                        ", "pol2", ",", " ", 
                    "pol3"}], "}"}], " ", "=", " ", "#1"}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"r4", ",", " ", "r5", ",", " ", "r6"}], "}"}], 
                    ",", " ", "\n", "                        ", 
                    RowBox[{"{", 
                    RowBox[{"r7", ",", " ", "r8", ",", " ", "r9"}], "}"}]}], 
                    "}"}], " ", "=", " ", 
                    RowBox[{
                    RowBox[{"Function", "[", 
                    RowBox[{"mm", ",", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"mm", " ", ".", " ", "#1"}], " ", "&"}], " ", 
                    ")"}], " ", "/@", " ", "\n", "                        ", 
                    "originalrotation"}]}], "]"}], "[", 
                    RowBox[{"transmatrix", "[", 
                    RowBox[{"[", 
                    RowBox[{"First", "[", "#2", "]"}], "]"}], "]"}], "]"}]}], 
                    ";", " ", "\n", "                        ", 
                    RowBox[{"tiltmagnitude", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    " ", ".", " ", 
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}]}]}],
                     ";", " ", "\n", "                        ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", 
                    RowBox[{"tiltmagnitude", " ", "-", " ", "1."}], "]"}], 
                    " ", ">", " ", "1.*^-6"}], ",", " ", "\n", 
                    "                        ", 
                    RowBox[{
                    RowBox[{"dummyvector", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    "/", 
                    RowBox[{"Sqrt", "[", "tiltmagnitude", "]"}]}]}], ";", " ",
                     "\n", "                        ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    " ", "=", " ", "dummyvector"}], ";", " ", 
                    RowBox[{"dummymatrix", " ", "=", " ", "\n", 
                    "                        ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"#1", "/", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"#1", " ", ".", " ", "#1"}], "]"}]}], " ", "&"}], 
                    " ", ")"}], " ", "/@", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "r4", ",", " ", "r5", ",", " ", "\n", 
                    "                        ", "r6"}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"r7", ",", " ", "r8", ",", " ", "r9"}], "}"}]}], 
                    "}"}]}]}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"r4", ",", " ", "r5", ",", " ", "r6"}], "}"}], 
                    ",", " ", "\n", "                        ", 
                    RowBox[{"{", 
                    RowBox[{"r7", ",", " ", "r8", ",", " ", "r9"}], "}"}]}], 
                    "}"}], " ", "=", " ", "dummymatrix"}], ";", " ", "1."}], 
                    ",", " ", "1."}], "]"}], ";", " ", "\n", 
                    "                        ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"allcreatedamplitudes", " ", "!=", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"I", "*", "0."}], ",", " ", 
                    RowBox[{"I", "*", "0."}], ",", " ", 
                    RowBox[{"I", "*", "0."}]}], "}"}], "}"}]}], ",", " ", 
                    "\n", "                        ", 
                    RowBox[{
                    RowBox[{"amplitude", " ", "=", " ", 
                    RowBox[{"allcreatedamplitudes", "[", 
                    RowBox[{"[", 
                    RowBox[{"First", "[", "#2", "]"}], "]"}], "]"}]}], ";", 
                    " ", "\n", "                        ", 
                    RowBox[{"hor", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r4", ",", " ", "r5", ",", " ", "r6"}], "}"}], 
                    " ", ".", " ", "amplitude"}]}], ";", " ", 
                    RowBox[{"ver", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "r7", ",", " ", "r8", ",", " ", "\n", 
                    "                        ", "r9"}], "}"}], " ", ".", " ", 
                    "amplitude"}]}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", "hor", "]"}], " ", ">", " ", "0."}], 
                    " ", "||", " ", 
                    RowBox[{
                    RowBox[{"Abs", "[", "ver", "]"}], " ", ">", " ", "\n", 
                    "                        ", "0."}]}], ",", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Abs", "[", "hor", "]"}], ",", " ", 
                    RowBox[{"Abs", "[", "ver", "]"}], ",", " ", "\n", 
                    "                        ", "0."}], "}"}]}], ";", " ", 
                    RowBox[{"dummyvector", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], "/", 
                    RowBox[{"Sqrt", "[", "\n", "                        ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], " ", ".", " ", 
                    RowBox[{"{", 
                    RowBox[{"pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}]}], "]"}]}]}], ";", " ", "\n", 
                    "                        ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], " ", "=", " ", "dummyvector"}], ";", " ", 
                    RowBox[{
                    "dummyvector", " ", "=", " ", "\n", 
                    "                        ", 
                    RowBox[{"ReplacePart", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], ",", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"ver", " ", "==", " ", "0."}], ",", " ", "\n", 
                    "                        ", "0.", ",", " ", 
                    RowBox[{"Arg", "[", "ver", "]"}]}], "]"}], " ", "-", " ", 
                    
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"hor", " ", "==", " ", "0."}], ",", " ", "0.", 
                    ",", " ", 
                    RowBox[{"Arg", "[", "hor", "]"}]}], "]"}]}], ")"}], "/", 
                    "\n", "                        ", "Degree"}], ",", " ", 
                    "3"}], "]"}]}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], " ", "=", " ", "dummyvector"}]}]}], "]"}], ";", 
                    " ", "\n", "                        ", "1."}], ",", " ", 
                    "1."}], "]"}], ";", " ", 
                    RowBox[{"{", 
                    RowBox[{"rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ",
                     "rex", ",", " ", "rey", ",", " ", "rez", ",", " ", "r1", 
                    ",", " ", "r2", ",", " ", "\n", 
                    "                        ", "r3", ",", " ", "r4", ",", 
                    " ", "r5", ",", " ", "r6", ",", " ", "r7", ",", " ", "r8",
                     ",", " ", "r9", ",", " ", "wavelength", ",", " ", "\n", 
                    "                        ", "intensity", ",", " ", 
                    "intensityscale", ",", " ", "ray1", ",", " ", "index", 
                    ",", " ", "\n", "                        ", 
                    "opticallength", ",", " ", "phaseshift", ",", " ", 
                    "componentnumber", ",", " ", "\n", 
                    "                        ", "surfacenumber", ",", " ", 
                    "surfaceid", ",", " ", "ray2", ",", " ", "ray3", ",", " ",
                     "sid", ",", " ", "\n", "                        ", 
                    "frontid", ",", " ", "sno1", ",", " ", "sno2", ",", " ", 
                    "sno3", ",", " ", "sno4", ",", " ", "rayslot", ",", " ", 
                    "\n", "                        ", "generationnumber", ",",
                     " ", "intersectionnumber", ",", " ", "pol1", ",", " ", 
                    "\n", "                        ", "pol2", ",", " ", 
                    "pol3"}], "}"}]}], ")"}], " ", "&"}], " ", ",", " ", 
                    "allcreatedrays"}], "]"}]}]}], ")"}], ";", " ", "\n", 
                    "                     ", 
                    RowBox[{"{", 
                    RowBox[{"allcreatedrays", ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",",
                     " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", 
                    "1.", ",", " ", "\n", "                        ", "1.", 
                    ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", 
                    "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",",
                     " ", 
                    RowBox[{"-", "9.87654321*^8"}], ",", " ", "\n", 
                    "                        ", "1.", ",", " ", "1.", ",", 
                    " ", "1.", ",", " ", "1.", ",", " ", "0.", ",", " ", 
                    RowBox[{"-", "1."}], ",", " ", 
                    RowBox[{"-", "1."}], ",", " ", 
                    RowBox[{"-", "1."}], ",", " ", "1.", ",", " ", "1.", ",", 
                    " ", "1.", ",", " ", "\n", "                        ", 
                    "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",",
                     " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", 
                    "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1."}], 
                    "}"}], "}"}], ",", " ", "\n", "                      ", 
                    RowBox[{"{", "completedray", "}"}]}], "}"}]}], ",", " ", 
                    "True", ",", " ", 
                    RowBox[{
                    RowBox[{
                    "deflecteddummyrayspresent", " ", "=", " ", "\n", 
                    "                      ", "True"}], ";", " ", 
                    RowBox[{
                    "reporteddummyrayspresent", " ", "=", " ", "True"}], ";", 
                    " ", "\n", "                     ", 
                    RowBox[{"localoutrayspresent", " ", "=", " ", "True"}], 
                    ";", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",",
                     " ", "1.", ",", " ", "\n", "                        ", 
                    "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",",
                     " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", 
                    "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",",
                     " ", "\n", "                        ", 
                    RowBox[{"-", "9.87654321*^8"}], ",", " ", "1.", ",", " ", 
                    "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "0.", ",",
                     " ", 
                    RowBox[{"-", "1."}], ",", " ", 
                    RowBox[{"-", "1."}], ",", " ", "\n", 
                    "                        ", 
                    RowBox[{"-", "1."}], ",", " ", "1.", ",", " ", "1.", ",", 
                    " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.",
                     ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ",
                     "1.", ",", " ", "1.", ",", " ", "\n", 
                    "                        ", "1.", ",", " ", "1.", ",", 
                    " ", "1."}], "}"}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "rez", ",", " ", "\n", 
                    "                        ", "r1", ",", " ", "r2", ",", 
                    " ", "r3", ",", " ", "r4", ",", " ", "r5", ",", " ", "r6",
                     ",", " ", "r7", ",", " ", "r8", ",", " ", "r9", ",", " ",
                     "wavelength", ",", " ", "\n", "                        ",
                     "intensity", ",", " ", "intensityscale", ",", " ", 
                    "ray1", ",", " ", "index", ",", " ", "\n", 
                    "                        ", "opticallength", ",", " ", 
                    "phaseshift", ",", " ", "componentnumber", ",", " ", "\n",
                     "                        ", "surfacenumber", ",", " ", 
                    "surfaceid", ",", " ", "ray2", ",", " ", "ray3", ",", " ",
                     "sid", ",", " ", "\n", "                        ", 
                    "frontid", ",", " ", "sno1", ",", " ", "sno2", ",", " ", 
                    "sno3", ",", " ", "sno4", ",", " ", "rayslot", ",", " ", 
                    "\n", "                        ", "generationnumber", ",",
                     " ", "intersectionnumber", ",", " ", "pol1", ",", " ", 
                    "\n", "                        ", "pol2", ",", " ", 
                    "pol3"}], "}"}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",",
                     " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", 
                    "1.", ",", " ", "\n", "                        ", "1.", 
                    ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", 
                    "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",",
                     " ", 
                    RowBox[{"-", "9.87654321*^8"}], ",", " ", "\n", 
                    "                        ", "1.", ",", " ", "1.", ",", 
                    " ", "1.", ",", " ", "1.", ",", " ", "0.", ",", " ", 
                    RowBox[{"-", "1."}], ",", " ", 
                    RowBox[{"-", "1."}], ",", " ", 
                    RowBox[{"-", "1."}], ",", " ", "1.", ",", " ", "1.", ",", 
                    " ", "1.", ",", " ", "\n", "                        ", 
                    "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",",
                     " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", 
                    "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1."}], 
                    "}"}], "}"}]}], "}"}]}]}], "]"}]}], ",", " ", "\n", 
                    "                  ", 
                    RowBox[{
                    RowBox[{
                    "deflecteddummyrayspresent", " ", "=", " ", "True"}], ";",
                     " ", "\n", "                   ", 
                    RowBox[{
                    "reporteddummyrayspresent", " ", "=", " ", "True"}], ";", 
                    " ", "\n", "                   ", 
                    RowBox[{
                    "localdummyoutrayspresent", " ", "=", " ", "True"}], ";", 
                    " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",",
                     " ", "\n", "                      ", "1.", ",", " ", 
                    "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",",
                     " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", 
                    "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",",
                     " ", "\n", "                      ", 
                    RowBox[{"-", "9.87654321*^8"}], ",", " ", "1.", ",", " ", 
                    "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "0.", ",",
                     " ", 
                    RowBox[{"-", "1."}], ",", " ", 
                    RowBox[{"-", "1."}], ",", " ", 
                    RowBox[{"-", "1."}], ",", " ", "\n", 
                    "                      ", "1.", ",", " ", "1.", ",", " ", 
                    "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",",
                     " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", 
                    "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "\n", 
                    "                      ", "1.", ",", " ", "1."}], "}"}], 
                    "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",",
                     " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", 
                    "1.", ",", " ", "1.", ",", " ", "\n", 
                    "                      ", "1.", ",", " ", "1.", ",", " ", 
                    "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",",
                     " ", "1.", ",", " ", 
                    RowBox[{"-", "9.87654321*^8"}], ",", " ", "1.", ",", " ", 
                    "\n", "                      ", "1.", ",", " ", "1.", ",",
                     " ", "1.", ",", " ", "0.", ",", " ", 
                    RowBox[{"-", "1."}], ",", " ", 
                    RowBox[{"-", "1."}], ",", " ", 
                    RowBox[{"-", "1."}], ",", " ", "1.", ",", " ", "1.", ",", 
                    " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "\n",
                     "                      ", "1.", ",", " ", "1.", ",", " ",
                     "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", 
                    ",", " ", "1.", ",", " ", "1.", ",", " ", "1."}], "}"}], 
                    "}"}], ",", " ", "\n", "                    ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",",
                     " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", 
                    "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",",
                     " ", "1.", ",", " ", "\n", "                      ", 
                    "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",",
                     " ", 
                    RowBox[{"-", "9.87654321*^8"}], ",", " ", "1.", ",", " ", 
                    "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "\n", 
                    "                      ", "0.", ",", " ", 
                    RowBox[{"-", "1."}], ",", " ", 
                    RowBox[{"-", "1."}], ",", " ", 
                    RowBox[{"-", "1."}], ",", " ", "1.", ",", " ", "1.", ",", 
                    " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.",
                     ",", " ", "1.", ",", " ", "1.", ",", " ", "\n", 
                    "                      ", "1.", ",", " ", "1.", ",", " ", 
                    "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1."}], 
                    "}"}], "}"}]}], "}"}]}]}], "]"}]}], ")"}], " ", "&"}], 
                    " ", ")"}], " ", "/@", " ", "inrays"}], "]"}]}]}], ";", 
                   " ", "\n", "           ", 
                   RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    "deflectedrayspresent", " ", "&&", " ", 
                    "deflecteddummyrayspresent"}], ",", " ", "\n", 
                    "            ", 
                    RowBox[{"deflectedlocalrays", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"Select", "[", 
                    RowBox[{"deflectedlocalrays", ",", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"#1", "[", 
                    RowBox[{"[", "23", "]"}], "]"}], " ", ">", " ", "\n", 
                    "                 ", "0."}], " ", "&"}]}], " ", "]"}], 
                    "*", "1."}]}], ",", " ", "1."}], "]"}], ";", " ", 
                   RowBox[{"If", "[", 
                    RowBox[{
                    "localoutrayspresent", ",", " ", "\n", "            ", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{"localdummyoutrayspresent", ",", " ", 
                    RowBox[{
                    RowBox[{"localoutrays", " ", "=", " ", 
                    RowBox[{"Select", "[", "\n", "                 ", 
                    RowBox[{"localoutrays", ",", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"#1", "[", 
                    RowBox[{"[", "23", "]"}], "]"}], " ", ">", " ", "0."}], 
                    " ", "&"}]}], " ", "]"}]}], ";", " ", "1."}], ",", " ", 
                    "1."}], "]"}], ";", " ", "\n", "             ", 
                    RowBox[{"outrays", " ", "=", " ", 
                    RowBox[{"Join", "[", 
                    RowBox[{"outrays", ",", " ", "localoutrays"}], "]"}]}], 
                    ";", " ", "1."}], ",", " ", "1."}], "]"}], ";", " ", "\n",
                    "           ", 
                   RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    "reportedrayspresent", " ", "&&", " ", 
                    "reporteddummyrayspresent"}], ",", " ", "\n", 
                    "            ", 
                    RowBox[{
                    RowBox[{"reportedlocalrays", " ", "=", " ", 
                    RowBox[{"Select", "[", 
                    RowBox[{"reportedlocalrays", ",", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"#1", "[", 
                    RowBox[{"[", "23", "]"}], "]"}], " ", ">", " ", "\n", 
                    "                 ", "0."}], " ", "&"}]}], " ", "]"}]}], 
                    ";", " ", "1."}], ",", " ", "1."}], "]"}]}], ")"}], ";", 
                 " ", 
                 RowBox[{"If", "[", 
                  RowBox[{
                  "reportedrayspresent", ",", " ", "\n", "           ", 
                   RowBox[{
                    RowBox[{"raysreported", " ", "=", " ", "True"}], ";", " ", 
                    RowBox[{"reportedrays", " ", "=", " ", 
                    RowBox[{"Join", "[", 
                    RowBox[{
                    "reportedrays", ",", " ", "\n", "              ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "9.87654321*^8"}], ",", " ", 
                    RowBox[{"-", "9.87654321*^8"}], ",", " ", 
                    RowBox[{"-", "9.87654321*^8"}], ",", " ", "\n", 
                    "                ", 
                    RowBox[{"-", "9.87654321*^8"}], ",", " ", 
                    RowBox[{"-", "9.87654321*^8"}], ",", " ", 
                    RowBox[{"-", "9.87654321*^8"}], ",", " ", "\n", 
                    "                ", 
                    RowBox[{"-", "9.87654321*^8"}], ",", " ", 
                    RowBox[{"-", "9.87654321*^8"}], ",", " ", 
                    RowBox[{"-", "9.87654321*^8"}], ",", " ", "\n", 
                    "                ", 
                    RowBox[{"-", "9.87654321*^8"}], ",", " ", 
                    RowBox[{"-", "9.87654321*^8"}], ",", " ", 
                    RowBox[{"-", "9.87654321*^8"}], ",", " ", "\n", 
                    "                ", 
                    RowBox[{"-", "9.87654321*^8"}], ",", " ", 
                    RowBox[{"-", "9.87654321*^8"}], ",", " ", 
                    RowBox[{"-", "9.87654321*^8"}], ",", " ", "\n", 
                    "                ", 
                    RowBox[{"-", "9.87654321*^8"}], ",", " ", 
                    RowBox[{"-", "9.87654321*^8"}], ",", " ", 
                    RowBox[{"-", "9.87654321*^8"}], ",", " ", "\n", 
                    "                ", 
                    RowBox[{"-", "9.87654321*^8"}], ",", " ", 
                    RowBox[{"-", "9.87654321*^8"}], ",", " ", 
                    RowBox[{"-", "9.87654321*^8"}], ",", " ", "\n", 
                    "                ", 
                    RowBox[{"-", "9.87654321*^8"}], ",", " ", 
                    RowBox[{"-", "9.87654321*^8"}], ",", " ", 
                    RowBox[{"-", "9.87654321*^8"}], ",", " ", "\n", 
                    "                ", 
                    RowBox[{"-", "9.87654321*^8"}], ",", " ", 
                    RowBox[{"-", "9.87654321*^8"}], ",", " ", 
                    RowBox[{"-", "9.87654321*^8"}], ",", " ", "\n", 
                    "                ", 
                    RowBox[{"-", "9.87654321*^8"}], ",", " ", 
                    RowBox[{"-", "9.87654321*^8"}], ",", " ", 
                    RowBox[{"-", "9.87654321*^8"}], ",", " ", "\n", 
                    "                ", 
                    RowBox[{"-", "9.87654321*^8"}], ",", " ", 
                    RowBox[{"-", "9.87654321*^8"}], ",", " ", 
                    RowBox[{"-", "9.87654321*^8"}], ",", " ", "\n", 
                    "                ", 
                    RowBox[{"-", "9.87654321*^8"}], ",", " ", 
                    RowBox[{"-", "9.87654321*^8"}], ",", " ", 
                    RowBox[{"-", "9.87654321*^8"}], ",", " ", "\n", 
                    "                ", 
                    RowBox[{"-", "9.87654321*^8"}], ",", " ", 
                    RowBox[{"-", "9.87654321*^8"}], ",", " ", 
                    RowBox[{"-", "9.87654321*^8"}]}], "}"}], "}"}], ",", " ", 
                    "\n", "              ", "reportedlocalrays"}], "]"}]}], 
                    ";", " ", "1."}], ",", " ", "1."}], "]"}], ";", " ", 
                 RowBox[{"inrays", " ", "=", " ", "deflectedlocalrays"}], ";",
                  " ", "\n", "          ", 
                 RowBox[{"propagate", " ", "=", " ", 
                  RowBox[{
                  "generationnumber", " ", "<", " ", 
                   "generationlimit"}]}]}]}], "]"}], ";", " ", "\n", 
              "        ", 
              RowBox[{"propagatedrays", " ", "=", " ", 
               RowBox[{"If", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"Length", "[", "outrays", "]"}], " ", ">", " ", 
                  "1"}], ",", " ", 
                 RowBox[{"Drop", "[", 
                  RowBox[{"outrays", ",", " ", "1"}], "]"}], ",", " ", "\n", 
                 "          ", "outrays"}], "]"}]}], ";", " ", 
              RowBox[{"If", "[", 
               RowBox[{
                RowBox[{
                 RowBox[{
                 "generationnumber", " ", ">=", " ", "generationlimit"}], " ",
                  "&&", " ", "\n", "          ", "deflectedrayspresent"}], 
                ",", " ", 
                RowBox[{
                 RowBox[{"propagatedrays", " ", "=", " ", 
                  RowBox[{"Join", "[", 
                   RowBox[{
                   "propagatedrays", ",", " ", "\n", "            ", 
                    "deflectedlocalrays"}], "]"}]}], ";", " ", "1."}], ",", 
                " ", "1."}], "]"}]}], ")"}], ";", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"inrays", " ", "=", " ", "propagatedrays"}], ";", " ", 
              "\n", "        ", 
              RowBox[{"outrays", " ", "=", " ", 
               RowBox[{"{", 
                RowBox[{"{", 
                 RowBox[{
                 "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", 
                  " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", 
                  ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", 
                  "1.", ",", " ", "1.", ",", " ", "\n", "           ", "1.", 
                  ",", " ", "1.", ",", " ", "1.", ",", " ", 
                  RowBox[{"-", "9.87654321*^8"}], ",", " ", "1.", ",", " ", 
                  "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "0.", ",", 
                  " ", 
                  RowBox[{"-", "1."}], ",", " ", 
                  RowBox[{"-", "1."}], ",", " ", "\n", "           ", 
                  RowBox[{"-", "1."}], ",", " ", "1.", ",", " ", "1.", ",", 
                  " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", 
                  ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", 
                  "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", 
                  " ", "\n", "           ", "1."}], "}"}], "}"}]}], ";", " ", 
              
              RowBox[{"deflectedrayspresent", " ", "=", " ", "True"}], ";", 
              " ", 
              RowBox[{
              "reportedrayspresent", " ", "=", " ", "\n", "         ", 
               "False"}], ";", " ", 
              RowBox[{"propagate", " ", "=", " ", "True"}], ";", " ", 
              RowBox[{"While", "[", 
               RowBox[{
                RowBox[{
                "deflectedrayspresent", " ", "&&", " ", "\n", "          ", 
                 "propagate"}], ",", " ", 
                RowBox[{
                 RowBox[{"generationnumber", " ", "+=", " ", "1."}], ";", " ",
                  "\n", "          ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                   "deflecteddummyrayspresent", " ", "=", " ", "False"}], ";",
                    " ", 
                   RowBox[{
                   "deflectedrayspresent", " ", "=", " ", "\n", 
                    "            ", "False"}], ";", " ", 
                   RowBox[{"reportedrayspresent", " ", "=", " ", "False"}], 
                   ";", " ", "\n", "           ", 
                   RowBox[{
                   "reporteddummyrayspresent", " ", "=", " ", "True"}], ";", 
                   " ", 
                   RowBox[{
                   "localdummyoutrayspresent", " ", "=", " ", "\n", 
                    "            ", "False"}], ";", " ", 
                   RowBox[{"localoutrayspresent", " ", "=", " ", "False"}], 
                   ";", " ", "\n", "           ", 
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "deflectedlocalrays", ",", " ", "localoutrays", ",", " ", 
                    "reportedlocalrays"}], "}"}], " ", "=", " ", "\n", 
                    "            ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"Flatten", "[", 
                    RowBox[{"#1", ",", " ", "1"}], "]"}], " ", "&"}], " ", 
                    ")"}], " ", "/@", " ", 
                    RowBox[{"Transpose", "[", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "\n", "                   ", 
                    "rez", ",", " ", "r1", ",", " ", "r2", ",", " ", "r3", 
                    ",", " ", "r4", ",", " ", "r5", ",", " ", "r6", ",", " ", 
                    "r7", ",", " ", "r8", ",", " ", "r9", ",", " ", 
                    "wavelength", ",", " ", "\n", "                   ", 
                    "intensity", ",", " ", "intensityscale", ",", " ", "ray1",
                     ",", " ", "index", ",", " ", "\n", "                   ",
                     "opticallength", ",", " ", "phaseshift", ",", " ", 
                    "componentnumber", ",", " ", "\n", "                   ", 
                    "surfacenumber", ",", " ", "surfaceid", ",", " ", "ray2", 
                    ",", " ", "ray3", ",", " ", "sid", ",", " ", "frontid", 
                    ",", " ", "\n", "                   ", "sno1", ",", " ", 
                    "sno2", ",", " ", "sno3", ",", " ", "sno4", ",", " ", 
                    "rayslot", ",", " ", "oldgenerationnumber", ",", " ", 
                    "\n", "                   ", "intersectionnumber", ",", 
                    " ", "pol1", ",", " ", "pol2", ",", " ", "pol3"}], "}"}], 
                    " ", "=", " ", "#1"}], ";", " ", "\n", 
                    "                 ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    "intensity", " ", ">", " ", "thresholdintensity"}], " ", "&&",
                     " ", 
                    RowBox[{
                    "generationnumber", " ", "<", " ", "\n", 
                    "                    ", "generationlimit"}]}], ",", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"resonatenumber", " ", "=", " ", "0"}], ";", " ", 
                    "\n", "                    ", 
                    RowBox[{
                    "resonateraylength", " ", "=", " ", "9.87654321*^8"}], 
                    ";", " ", "\n", "                    ", 
                    RowBox[{"resonateintersections", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}], "}"}]}], ";", " ", 
                    RowBox[{
                    "MapIndexed", "[", "\n", "                     ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"#1", "[", 
                    RowBox[{"[", 
                    RowBox[{"1", ",", "1"}], "]"}], "]"}], " ", ">", " ", 
                    RowBox[{"-", "1."}]}], " ", "&&", " ", 
                    RowBox[{
                    RowBox[{"#1", "[", 
                    RowBox[{"[", 
                    RowBox[{"1", ",", "1"}], "]"}], "]"}], " ", "<", " ", 
                    "\n", "                        ", "resonateraylength"}]}],
                     ",", " ", 
                    RowBox[{
                    RowBox[{"resonateraylength", " ", "=", " ", 
                    RowBox[{"#1", "[", 
                    RowBox[{"[", 
                    RowBox[{"1", ",", "\n", "                        ", "1"}],
                     "]"}], "]"}]}], ";", " ", 
                    RowBox[{"resonateintersections", " ", "=", " ", "#1"}], 
                    ";", " ", "\n", "                        ", 
                    RowBox[{"resonatenumber", " ", "=", " ", 
                    RowBox[{"First", "[", "#2", "]"}]}]}], ",", " ", 
                    "resonatenumber"}], "]"}], " ", "&"}], " ", ",", " ", 
                    "\n", "                     ", 
                    RowBox[{
                    RowBox[{"intersectionslist", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}], "}"}], "}"}]}], ";", " ", 
                    RowBox[{
                    "holeQlist", " ", "=", " ", "\n", 
                    "                       ", 
                    RowBox[{"{", "0", "}"}]}], ";", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "rez", ",", " ", "r1", ",", 
                    " ", "r2", ",", " ", "r3", ",", " ", "\n", 
                    "                        ", "r4", ",", " ", "r5", ",", 
                    " ", "r6", ",", " ", "r7", ",", " ", "r8", ",", " ", "r9",
                     ",", " ", "wavelength", ",", " ", "intensity", ",", " ", 
                    "\n", "                        ", "intensityscale", ",", 
                    " ", "ray1", ",", " ", "index", ",", " ", "opticallength",
                     ",", " ", "\n", "                        ", "phaseshift",
                     ",", " ", "componentnumber", ",", " ", "surfacenumber", 
                    ",", " ", "\n", "                        ", "surfaceid", 
                    ",", " ", "ray2", ",", " ", "ray3", ",", " ", "sid", ",", 
                    " ", "frontid", ",", " ", "sno1", ",", " ", "sno2", ",", 
                    " ", "\n", "                        ", "sno3", ",", " ", 
                    "sno4", ",", " ", "rayslot", ",", " ", 
                    "oldgenerationnumber", ",", " ", "\n", 
                    "                        ", "intersectionnumber", ",", 
                    " ", "pol1", ",", " ", "pol2", ",", " ", "pol3"}], "}"}], 
                    " ", "=", " ", "#1"}], ";", " ", "\n", 
                    "                       ", 
                    RowBox[{"index1", " ", "=", " ", "index"}], ";", " ", 
                    RowBox[{"xunit", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"-", "1."}], "*", "r1"}]}], ";", " ", 
                    RowBox[{"yunit", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"-", "1."}], "*", "r2"}]}], ";", " ", "\n", 
                    "                       ", 
                    RowBox[{"zunit", " ", "=", " ", "r3"}], ";", " ", 
                    RowBox[{"xunit", " ", "=", " ", 
                    RowBox[{"Chop", "[", "xunit", "]"}]}], ";", " ", 
                    RowBox[{
                    "yunit", " ", "=", " ", "\n", "                        ", 
                    
                    RowBox[{"Chop", "[", "yunit", "]"}]}], ";", " ", 
                    RowBox[{"zunit", " ", "=", " ", 
                    RowBox[{"Chop", "[", "zunit", "]"}]}], ";", " ", 
                    RowBox[{
                    "magnitude", " ", "=", " ", "\n", 
                    "                        ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"xunit", "^", "2"}], " ", "+", " ", 
                    RowBox[{"yunit", "^", "2"}], " ", "+", " ", 
                    RowBox[{"zunit", "^", "2"}]}], ")"}], "^", 
                    RowBox[{"2", "^", 
                    RowBox[{"(", 
                    RowBox[{"-", "1"}], ")"}]}]}]}], ";", " ", 
                    RowBox[{
                    "xunit", " ", "=", " ", "\n", "                        ", 
                    
                    RowBox[{"xunit", "/", "magnitude"}]}], ";", " ", 
                    RowBox[{"yunit", " ", "=", " ", 
                    RowBox[{"yunit", "/", "magnitude"}]}], ";", " ", "\n", 
                    "                       ", 
                    RowBox[{"zunit", " ", "=", " ", 
                    RowBox[{"zunit", "/", "magnitude"}]}], ";", " ", 
                    RowBox[{"rx", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"-", "1."}], "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "200."}], " ", "+", " ", "rex"}], ")"}]}]}], 
                    ";", " ", "\n", "                       ", 
                    RowBox[{"ry", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"-", "1."}], "*", "rey"}]}], ";", " ", 
                    RowBox[{"rz", " ", "=", " ", "rez"}], ";", " ", 
                    RowBox[{"rx", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rx", "]"}]}], ";", " ", 
                    RowBox[{
                    "ry", " ", "=", " ", "\n", "                        ", 
                    RowBox[{"Chop", "[", "ry", "]"}]}], ";", " ", 
                    RowBox[{"rz", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rz", "]"}]}], ";", " ", 
                    RowBox[{
                    "terminatedeflection", " ", "=", " ", "\n", 
                    "                        ", "False"}], ";", " ", 
                    RowBox[{"intersections", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}], "}"}]}], ";", " ", "\n", "                       ", 
                    RowBox[{"intersections", " ", "=", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Chop", "[", "xunit", "]"}], " ", "!=", " ", 
                    "0"}], ",", " ", "\n", "                        ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"N", "[", 
                    RowBox[{"Chop", "[", 
                    RowBox[{"#1", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "]"}], "]"}], " ", ">=", 
                    " ", "0."}], " ", "&&", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"#1", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], " ", "<=", " ", "\n", 
                    "                        ", "100."}], " ", "&&", " ", 
                    RowBox[{
                    RowBox[{"#1", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], " ", ">=", " ", 
                    RowBox[{"-", "100."}]}], " ", "&&", " ", 
                    RowBox[{
                    RowBox[{"#1", "[", 
                    RowBox[{"[", "3", "]"}], "]"}], " ", ">=", " ", 
                    RowBox[{"-", "100."}]}], " ", "&&", " ", "\n", 
                    "                        ", 
                    RowBox[{
                    RowBox[{"#1", "[", 
                    RowBox[{"[", "3", "]"}], "]"}], " ", "<=", " ", 
                    "100."}]}], ")"}]}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"#1", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], ",", " ", 
                    RowBox[{"#1", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], ",", " ", 
                    RowBox[{"#1", "[", 
                    RowBox[{"[", "3", "]"}], "]"}]}], "}"}], ",", " ", "\n", 
                    "                        ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}]}], "]"}], " ", "&"}], " ", ")"}], "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"(", 
                    RowBox[{"rx", "/", "xunit"}], ")"}]}], ",", " ", 
                    RowBox[{"ry", " ", "-", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"rx", "*", "yunit"}], ")"}], "/", "\n", 
                    "                        ", "xunit"}]}], ",", " ", 
                    RowBox[{"rz", " ", "-", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"rx", "*", "zunit"}], ")"}], "/", "xunit"}]}]}], 
                    "}"}], "]"}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "\n", 
                    "                        ", "0."}], "}"}], "}"}]}], 
                    "]"}]}], ";", " ", 
                    RowBox[{"AppendTo", "[", 
                    RowBox[{"intersections", ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}]}], "]"}], ";", " ", "\n", "                       ", 
                    RowBox[{"holeQ", " ", "=", " ", "False"}], ";", " ", 
                    RowBox[{"If", "[", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"!", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Chop", "[", 
                    RowBox[{"surfaceid", " ", "-", " ", "92440."}], "]"}], 
                    " ", "==", " ", "\n", "                        ", "0."}], 
                    " ", "||", " ", 
                    RowBox[{
                    RowBox[{"N", "[", 
                    RowBox[{"Chop", "[", "ray1", "]"}], "]"}], " ", "<", " ", 
                    "0.0001"}]}], ")"}]}], " ", "||", " ", "\n", 
                    "                        ", 
                    RowBox[{"generationnumber", " ", "==", " ", "1."}]}], ",",
                     " ", 
                    RowBox[{
                    "minresonateraylength", " ", "=", " ", "\n", 
                    "                        ", "0."}], ",", " ", 
                    RowBox[{
                    "minresonateraylength", " ", "=", " ", "0.0001"}]}], 
                    "]"}], ";", " ", 
                    RowBox[{"Block", "[", "\n", "                        ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "LocRayL", ",", " ", "LocSCx", ",", " ", "LocSCy"}], 
                    "}"}], ",", " ", 
                    RowBox[{
                    RowBox[{"LocRayL", " ", "=", " ", "1."}], ";", " ", "\n", 
                    "                        ", 
                    RowBox[{"LocSCx", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"LocSCy", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"dummymatrix", " ", "=", " ", 
                    RowBox[{"Union", "[", "\n", "                        ", 
                    RowBox[{"Select", "[", 
                    RowBox[{"intersections", ",", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "LocRayL", ",", " ", "LocSCx", ",", " ", "\n", 
                    "                        ", "LocSCy"}], "}"}], " ", "=", 
                    " ", "#1"}], ";", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "LocRayL", ",", " ", "LocSCx", ",", " ", "LocSCy"}], 
                    "}"}], " ", "==", " ", "\n", "                        ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}]}], " ", "||", " ", 
                    RowBox[{
                    RowBox[{"N", "[", 
                    RowBox[{"Chop", "[", "LocRayL", "]"}], "]"}], " ", ">=", 
                    " ", "\n", "                        ", 
                    "minresonateraylength"}]}]}], ")"}], " ", "&"}]}], " ", 
                    "]"}], "]"}]}], ";", " ", 
                    RowBox[{
                    "intersections", " ", "=", " ", "\n", 
                    "                        ", "dummymatrix"}]}]}], "]"}], 
                    ";", " ", 
                    RowBox[{
                    "unfilteredintersections", " ", "=", " ", "\n", 
                    "                        ", "intersections"}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", "intersections", "]"}], " ", ">", 
                    " ", "1"}], ",", " ", "\n", "                        ", 
                    RowBox[{
                    RowBox[{"dummymatrix", " ", "=", " ", 
                    RowBox[{"Take", "[", 
                    RowBox[{"intersections", ",", " ", 
                    RowBox[{"{", "2", "}"}]}], "]"}]}], ";", " ", "\n", 
                    "                        ", 
                    RowBox[{"intersections", " ", "=", " ", "dummymatrix"}], 
                    ";", " ", "1."}], ",", " ", "1."}], "]"}], ";", " ", 
                    RowBox[{"AppendTo", "[", "\n", "                        ", 
                    RowBox[{"intersectionslist", ",", " ", "intersections"}], 
                    "]"}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    "holeQ", ",", " ", "\n", "                        ", 
                    RowBox[{"AppendTo", "[", 
                    RowBox[{"holeQlist", ",", " ", "1"}], "]"}], ",", " ", 
                    RowBox[{"AppendTo", "[", 
                    RowBox[{"holeQlist", ",", " ", "0"}], "]"}]}], "]"}], ";",
                     " ", "\n", "                       ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "rez", ",", " ", "r1", ",", 
                    " ", "r2", ",", " ", "r3", ",", " ", "r4", ",", " ", "\n",
                     "                        ", "r5", ",", " ", "r6", ",", 
                    " ", "r7", ",", " ", "r8", ",", " ", "r9", ",", " ", 
                    "wavelength", ",", " ", "intensity", ",", " ", "\n", 
                    "                        ", "intensityscale", ",", " ", 
                    "ray1", ",", " ", "index", ",", " ", "opticallength", ",",
                     " ", "\n", "                        ", "phaseshift", ",",
                     " ", "componentnumber", ",", " ", "surfacenumber", ",", 
                    " ", "\n", "                        ", "surfaceid", ",", 
                    " ", "ray2", ",", " ", "ray3", ",", " ", "sid", ",", " ", 
                    "frontid", ",", " ", "sno1", ",", " ", "sno2", ",", " ", 
                    "\n", "                        ", "sno3", ",", " ", 
                    "sno4", ",", " ", "rayslot", ",", " ", 
                    "oldgenerationnumber", ",", " ", "\n", 
                    "                        ", "intersectionnumber", ",", 
                    " ", "pol1", ",", " ", "pol2", ",", " ", "pol3"}], "}"}], 
                    " ", "=", " ", "#1"}], ";", " ", "\n", 
                    "                       ", 
                    RowBox[{"index1", " ", "=", " ", "index"}], ";", " ", 
                    RowBox[{"xunit", " ", "=", " ", "r2"}], ";", " ", 
                    RowBox[{"yunit", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"-", "1."}], "*", "r1"}]}], ";", " ", "\n", 
                    "                       ", 
                    RowBox[{"zunit", " ", "=", " ", "r3"}], ";", " ", 
                    RowBox[{"xunit", " ", "=", " ", 
                    RowBox[{"Chop", "[", "xunit", "]"}]}], ";", " ", 
                    RowBox[{
                    "yunit", " ", "=", " ", "\n", "                        ", 
                    
                    RowBox[{"Chop", "[", "yunit", "]"}]}], ";", " ", 
                    RowBox[{"zunit", " ", "=", " ", 
                    RowBox[{"Chop", "[", "zunit", "]"}]}], ";", " ", 
                    RowBox[{
                    "magnitude", " ", "=", " ", "\n", 
                    "                        ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"xunit", "^", "2"}], " ", "+", " ", 
                    RowBox[{"yunit", "^", "2"}], " ", "+", " ", 
                    RowBox[{"zunit", "^", "2"}]}], ")"}], "^", 
                    RowBox[{"2", "^", 
                    RowBox[{"(", 
                    RowBox[{"-", "1"}], ")"}]}]}]}], ";", " ", 
                    RowBox[{
                    "xunit", " ", "=", " ", "\n", "                        ", 
                    
                    RowBox[{"xunit", "/", "magnitude"}]}], ";", " ", 
                    RowBox[{"yunit", " ", "=", " ", 
                    RowBox[{"yunit", "/", "magnitude"}]}], ";", " ", "\n", 
                    "                       ", 
                    RowBox[{"zunit", " ", "=", " ", 
                    RowBox[{"zunit", "/", "magnitude"}]}], ";", " ", 
                    RowBox[{"rx", " ", "=", " ", 
                    RowBox[{"100.", " ", "+", " ", "rey"}]}], ";", " ", "\n", 
                    "                       ", 
                    RowBox[{"ry", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"-", "1."}], "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "100."}], " ", "+", " ", "rex"}], ")"}]}]}], 
                    ";", " ", 
                    RowBox[{"rz", " ", "=", " ", "rez"}], ";", " ", 
                    RowBox[{"rx", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rx", "]"}]}], ";", " ", "\n", 
                    "                       ", 
                    RowBox[{"ry", " ", "=", " ", 
                    RowBox[{"Chop", "[", "ry", "]"}]}], ";", " ", 
                    RowBox[{"rz", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rz", "]"}]}], ";", " ", "\n", 
                    "                       ", 
                    RowBox[{"terminatedeflection", " ", "=", " ", "False"}], 
                    ";", " ", 
                    RowBox[{
                    "intersections", " ", "=", " ", "\n", 
                    "                        ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}], "}"}]}], ";", " ", 
                    RowBox[{"intersections", " ", "=", " ", 
                    RowBox[{"If", "[", "\n", "                        ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Chop", "[", "xunit", "]"}], " ", "!=", " ", 
                    "0"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"N", "[", 
                    RowBox[{"Chop", "[", 
                    RowBox[{"#1", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "]"}], "]"}], " ", ">=", 
                    " ", "0."}], " ", "&&", " ", "\n", 
                    "                        ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"#1", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], " ", "<=", " ", "100."}], 
                    " ", "&&", " ", 
                    RowBox[{
                    RowBox[{"#1", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], " ", ">=", " ", 
                    RowBox[{"-", "100."}]}], " ", "&&", " ", "\n", 
                    "                        ", 
                    RowBox[{
                    RowBox[{"#1", "[", 
                    RowBox[{"[", "3", "]"}], "]"}], " ", ">=", " ", 
                    RowBox[{"-", "100."}]}], " ", "&&", " ", 
                    RowBox[{
                    RowBox[{"#1", "[", 
                    RowBox[{"[", "3", "]"}], "]"}], " ", "<=", " ", 
                    "100."}]}], ")"}]}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"#1", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], ",", " ", "\n", 
                    "                        ", 
                    RowBox[{"#1", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], ",", " ", 
                    RowBox[{"#1", "[", 
                    RowBox[{"[", "3", "]"}], "]"}]}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}]}], "]"}], " ", "&"}], " ", ")"}], "[", "\n", 
                    "                        ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"(", 
                    RowBox[{"rx", "/", "xunit"}], ")"}]}], ",", " ", 
                    RowBox[{"ry", " ", "-", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"rx", "*", "yunit"}], ")"}], "/", "xunit"}]}], 
                    ",", " ", 
                    RowBox[{
                    "rz", " ", "-", " ", "\n", "                        ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"rx", "*", "zunit"}], ")"}], "/", "xunit"}]}]}], 
                    "}"}], "]"}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}], "}"}]}], "]"}]}], ";", " ", 
                    RowBox[{"AppendTo", "[", "\n", "                        ", 
                    RowBox[{"intersections", ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}]}], "]"}], ";", " ", 
                    RowBox[{"holeQ", " ", "=", " ", "False"}], ";", " ", "\n",
                     "                       ", 
                    RowBox[{"If", "[", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"!", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Chop", "[", 
                    RowBox[{"surfaceid", " ", "-", " ", "92441."}], "]"}], 
                    " ", "==", " ", "0."}], " ", "||", " ", "\n", 
                    "                        ", 
                    RowBox[{
                    RowBox[{"N", "[", 
                    RowBox[{"Chop", "[", "ray1", "]"}], "]"}], " ", "<", " ", 
                    "0.0001"}]}], ")"}]}], " ", "||", " ", 
                    RowBox[{
                    "generationnumber", " ", "==", " ", "\n", 
                    "                        ", "1."}]}], ",", " ", 
                    RowBox[{"minresonateraylength", " ", "=", " ", "0."}], 
                    ",", " ", "\n", "                        ", 
                    RowBox[{
                    "minresonateraylength", " ", "=", " ", "0.0001"}]}], 
                    "]"}], ";", " ", 
                    RowBox[{"Block", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "LocRayL", ",", " ", "\n", "                        ", 
                    "LocSCx", ",", " ", "LocSCy"}], "}"}], ",", " ", 
                    RowBox[{
                    RowBox[{"LocRayL", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"LocSCx", " ", "=", " ", "1."}], ";", " ", "\n", 
                    "                        ", 
                    RowBox[{"LocSCy", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"dummymatrix", " ", "=", " ", 
                    RowBox[{"Union", "[", 
                    RowBox[{"Select", "[", "\n", "                        ", 
                    RowBox[{"intersections", ",", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "LocRayL", ",", " ", "LocSCx", ",", " ", "LocSCy"}], 
                    "}"}], " ", "=", " ", "#1"}], ";", " ", "\n", 
                    "                        ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "LocRayL", ",", " ", "LocSCx", ",", " ", "LocSCy"}], 
                    "}"}], " ", "==", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}]}], " ", "||", " ", "\n", "                        ", 
                    RowBox[{
                    RowBox[{"N", "[", 
                    RowBox[{"Chop", "[", "LocRayL", "]"}], "]"}], " ", ">=", 
                    " ", "minresonateraylength"}]}]}], ")"}], " ", "&"}]}], 
                    " ", "]"}], "]"}]}], ";", " ", "\n", 
                    "                        ", 
                    RowBox[{
                    "intersections", " ", "=", " ", "dummymatrix"}]}]}], 
                    "]"}], ";", " ", "\n", "                       ", 
                    RowBox[{
                    "unfilteredintersections", " ", "=", " ", 
                    "intersections"}], ";", " ", "\n", 
                    "                       ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", "intersections", "]"}], " ", ">", 
                    " ", "1"}], ",", " ", 
                    RowBox[{
                    RowBox[{
                    "dummymatrix", " ", "=", " ", "\n", 
                    "                        ", 
                    RowBox[{"Take", "[", 
                    RowBox[{"intersections", ",", " ", 
                    RowBox[{"{", "2", "}"}]}], "]"}]}], ";", " ", 
                    RowBox[{
                    "intersections", " ", "=", " ", "\n", 
                    "                        ", "dummymatrix"}], ";", " ", 
                    "1."}], ",", " ", "1."}], "]"}], ";", " ", 
                    RowBox[{"AppendTo", "[", "\n", "                        ", 
                    RowBox[{"intersectionslist", ",", " ", "intersections"}], 
                    "]"}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    "holeQ", ",", " ", "\n", "                        ", 
                    RowBox[{"AppendTo", "[", 
                    RowBox[{"holeQlist", ",", " ", "1"}], "]"}], ",", " ", 
                    RowBox[{"AppendTo", "[", 
                    RowBox[{"holeQlist", ",", " ", "0"}], "]"}]}], "]"}], ";",
                     " ", "\n", "                       ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "rez", ",", " ", "r1", ",", 
                    " ", "r2", ",", " ", "r3", ",", " ", "r4", ",", " ", "\n",
                     "                        ", "r5", ",", " ", "r6", ",", 
                    " ", "r7", ",", " ", "r8", ",", " ", "r9", ",", " ", 
                    "wavelength", ",", " ", "intensity", ",", " ", "\n", 
                    "                        ", "intensityscale", ",", " ", 
                    "ray1", ",", " ", "index", ",", " ", "opticallength", ",",
                     " ", "\n", "                        ", "phaseshift", ",",
                     " ", "componentnumber", ",", " ", "surfacenumber", ",", 
                    " ", "\n", "                        ", "surfaceid", ",", 
                    " ", "ray2", ",", " ", "ray3", ",", " ", "sid", ",", " ", 
                    "frontid", ",", " ", "sno1", ",", " ", "sno2", ",", " ", 
                    "\n", "                        ", "sno3", ",", " ", 
                    "sno4", ",", " ", "rayslot", ",", " ", 
                    "oldgenerationnumber", ",", " ", "\n", 
                    "                        ", "intersectionnumber", ",", 
                    " ", "pol1", ",", " ", "pol2", ",", " ", "pol3"}], "}"}], 
                    " ", "=", " ", "#1"}], ";", " ", "\n", 
                    "                       ", 
                    RowBox[{"index1", " ", "=", " ", "index"}], ";", " ", 
                    RowBox[{"xunit", " ", "=", " ", "r1"}], ";", " ", 
                    RowBox[{"yunit", " ", "=", " ", "r2"}], ";", " ", 
                    RowBox[{
                    "zunit", " ", "=", " ", "\n", "                        ", 
                    "r3"}], ";", " ", 
                    RowBox[{"xunit", " ", "=", " ", 
                    RowBox[{"Chop", "[", "xunit", "]"}]}], ";", " ", 
                    RowBox[{"yunit", " ", "=", " ", 
                    RowBox[{"Chop", "[", "yunit", "]"}]}], ";", " ", "\n", 
                    "                       ", 
                    RowBox[{"zunit", " ", "=", " ", 
                    RowBox[{"Chop", "[", "zunit", "]"}]}], ";", " ", 
                    RowBox[{"magnitude", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"xunit", "^", "2"}], " ", "+", " ", "\n", 
                    "                        ", 
                    RowBox[{"yunit", "^", "2"}], " ", "+", " ", 
                    RowBox[{"zunit", "^", "2"}]}], ")"}], "^", 
                    RowBox[{"2", "^", 
                    RowBox[{"(", 
                    RowBox[{"-", "1"}], ")"}]}]}]}], ";", " ", 
                    RowBox[{"xunit", " ", "=", " ", 
                    RowBox[{
                    "xunit", "/", "\n", "                        ", 
                    "magnitude"}]}], ";", " ", 
                    RowBox[{"yunit", " ", "=", " ", 
                    RowBox[{"yunit", "/", "magnitude"}]}], ";", " ", 
                    RowBox[{
                    "zunit", " ", "=", " ", "\n", "                        ", 
                    
                    RowBox[{"zunit", "/", "magnitude"}]}], ";", " ", 
                    RowBox[{"rx", " ", "=", " ", "rex"}], ";", " ", 
                    RowBox[{"ry", " ", "=", " ", "rey"}], ";", " ", 
                    RowBox[{"rz", " ", "=", " ", "rez"}], ";", " ", "\n", 
                    "                       ", 
                    RowBox[{"rx", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rx", "]"}]}], ";", " ", 
                    RowBox[{"ry", " ", "=", " ", 
                    RowBox[{"Chop", "[", "ry", "]"}]}], ";", " ", 
                    RowBox[{"rz", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rz", "]"}]}], ";", " ", "\n", 
                    "                       ", 
                    RowBox[{"terminatedeflection", " ", "=", " ", "False"}], 
                    ";", " ", 
                    RowBox[{
                    "intersections", " ", "=", " ", "\n", 
                    "                        ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}], "}"}]}], ";", " ", 
                    RowBox[{"intersections", " ", "=", " ", 
                    RowBox[{"If", "[", "\n", "                        ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Chop", "[", "xunit", "]"}], " ", "!=", " ", 
                    "0"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"N", "[", 
                    RowBox[{"Chop", "[", 
                    RowBox[{"#1", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "]"}], "]"}], " ", ">=", 
                    " ", "0."}], " ", "&&", " ", "\n", 
                    "                        ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"#1", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], " ", "<=", " ", "100."}], 
                    " ", "&&", " ", 
                    RowBox[{
                    RowBox[{"#1", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], " ", ">=", " ", 
                    RowBox[{"-", "100."}]}], " ", "&&", " ", "\n", 
                    "                        ", 
                    RowBox[{
                    RowBox[{"#1", "[", 
                    RowBox[{"[", "3", "]"}], "]"}], " ", ">=", " ", 
                    RowBox[{"-", "100."}]}], " ", "&&", " ", 
                    RowBox[{
                    RowBox[{"#1", "[", 
                    RowBox[{"[", "3", "]"}], "]"}], " ", "<=", " ", 
                    "100."}]}], ")"}]}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"#1", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], ",", " ", "\n", 
                    "                        ", 
                    RowBox[{"#1", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], ",", " ", 
                    RowBox[{"#1", "[", 
                    RowBox[{"[", "3", "]"}], "]"}]}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}]}], "]"}], " ", "&"}], " ", ")"}], "[", "\n", 
                    "                        ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"(", 
                    RowBox[{"rx", "/", "xunit"}], ")"}]}], ",", " ", 
                    RowBox[{"ry", " ", "-", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"rx", "*", "yunit"}], ")"}], "/", "xunit"}]}], 
                    ",", " ", 
                    RowBox[{
                    "rz", " ", "-", " ", "\n", "                        ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"rx", "*", "zunit"}], ")"}], "/", "xunit"}]}]}], 
                    "}"}], "]"}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}], "}"}]}], "]"}]}], ";", " ", 
                    RowBox[{"AppendTo", "[", "\n", "                        ", 
                    RowBox[{"intersections", ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}]}], "]"}], ";", " ", 
                    RowBox[{"holeQ", " ", "=", " ", "False"}], ";", " ", "\n",
                     "                       ", 
                    RowBox[{"If", "[", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"!", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Chop", "[", 
                    RowBox[{"surfaceid", " ", "-", " ", "92442."}], "]"}], 
                    " ", "==", " ", "0."}], " ", "||", " ", "\n", 
                    "                        ", 
                    RowBox[{
                    RowBox[{"N", "[", 
                    RowBox[{"Chop", "[", "ray1", "]"}], "]"}], " ", "<", " ", 
                    "0.0001"}]}], ")"}]}], " ", "||", " ", 
                    RowBox[{
                    "generationnumber", " ", "==", " ", "\n", 
                    "                        ", "1."}]}], ",", " ", 
                    RowBox[{"minresonateraylength", " ", "=", " ", "0."}], 
                    ",", " ", "\n", "                        ", 
                    RowBox[{
                    "minresonateraylength", " ", "=", " ", "0.0001"}]}], 
                    "]"}], ";", " ", 
                    RowBox[{"Block", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "LocRayL", ",", " ", "\n", "                        ", 
                    "LocSCx", ",", " ", "LocSCy"}], "}"}], ",", " ", 
                    RowBox[{
                    RowBox[{"LocRayL", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"LocSCx", " ", "=", " ", "1."}], ";", " ", "\n", 
                    "                        ", 
                    RowBox[{"LocSCy", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"dummymatrix", " ", "=", " ", 
                    RowBox[{"Union", "[", 
                    RowBox[{"Select", "[", "\n", "                        ", 
                    RowBox[{"intersections", ",", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "LocRayL", ",", " ", "LocSCx", ",", " ", "LocSCy"}], 
                    "}"}], " ", "=", " ", "#1"}], ";", " ", "\n", 
                    "                        ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "LocRayL", ",", " ", "LocSCx", ",", " ", "LocSCy"}], 
                    "}"}], " ", "==", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}]}], " ", "||", " ", "\n", "                        ", 
                    RowBox[{
                    RowBox[{"N", "[", 
                    RowBox[{"Chop", "[", "LocRayL", "]"}], "]"}], " ", ">=", 
                    " ", "minresonateraylength"}]}]}], ")"}], " ", "&"}]}], 
                    " ", "]"}], "]"}]}], ";", " ", "\n", 
                    "                        ", 
                    RowBox[{
                    "intersections", " ", "=", " ", "dummymatrix"}]}]}], 
                    "]"}], ";", " ", "\n", "                       ", 
                    RowBox[{
                    "unfilteredintersections", " ", "=", " ", 
                    "intersections"}], ";", " ", "\n", 
                    "                       ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", "intersections", "]"}], " ", ">", 
                    " ", "1"}], ",", " ", 
                    RowBox[{
                    RowBox[{
                    "dummymatrix", " ", "=", " ", "\n", 
                    "                        ", 
                    RowBox[{"Take", "[", 
                    RowBox[{"intersections", ",", " ", 
                    RowBox[{"{", "2", "}"}]}], "]"}]}], ";", " ", 
                    RowBox[{"intersections", " ", "=", " ", "\n", 
                    "                        ", "dummymatrix"}], ";", " ", 
                    "1."}], ",", " ", "1."}], "]"}], ";", " ", 
                    RowBox[{"AppendTo", "[", "\n", "                        ", 
                    RowBox[{"intersectionslist", ",", " ", "intersections"}], 
                    "]"}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    "holeQ", ",", " ", "\n", "                        ", 
                    RowBox[{"AppendTo", "[", 
                    RowBox[{"holeQlist", ",", " ", "1"}], "]"}], ",", " ", 
                    RowBox[{"AppendTo", "[", 
                    RowBox[{"holeQlist", ",", " ", "0"}], "]"}]}], "]"}], ";",
                     " ", "\n", "                       ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "rez", ",", " ", "r1", ",", 
                    " ", "r2", ",", " ", "r3", ",", " ", "r4", ",", " ", "\n",
                     "                        ", "r5", ",", " ", "r6", ",", 
                    " ", "r7", ",", " ", "r8", ",", " ", "r9", ",", " ", 
                    "wavelength", ",", " ", "intensity", ",", " ", "\n", 
                    "                        ", "intensityscale", ",", " ", 
                    "ray1", ",", " ", "index", ",", " ", "opticallength", ",",
                     " ", "\n", "                        ", "phaseshift", ",",
                     " ", "componentnumber", ",", " ", "surfacenumber", ",", 
                    " ", "\n", "                        ", "surfaceid", ",", 
                    " ", "ray2", ",", " ", "ray3", ",", " ", "sid", ",", " ", 
                    "frontid", ",", " ", "sno1", ",", " ", "sno2", ",", " ", 
                    "\n", "                        ", "sno3", ",", " ", 
                    "sno4", ",", " ", "rayslot", ",", " ", 
                    "oldgenerationnumber", ",", " ", "\n", 
                    "                        ", "intersectionnumber", ",", 
                    " ", "pol1", ",", " ", "pol2", ",", " ", "pol3"}], "}"}], 
                    " ", "=", " ", "#1"}], ";", " ", "\n", 
                    "                       ", 
                    RowBox[{"index1", " ", "=", " ", "index"}], ";", " ", 
                    RowBox[{"xunit", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"-", "1."}], "*", "r2"}]}], ";", " ", 
                    RowBox[{"yunit", " ", "=", " ", "r1"}], ";", " ", "\n", 
                    "                       ", 
                    RowBox[{"zunit", " ", "=", " ", "r3"}], ";", " ", 
                    RowBox[{"xunit", " ", "=", " ", 
                    RowBox[{"Chop", "[", "xunit", "]"}]}], ";", " ", 
                    RowBox[{
                    "yunit", " ", "=", " ", "\n", "                        ", 
                    
                    RowBox[{"Chop", "[", "yunit", "]"}]}], ";", " ", 
                    RowBox[{"zunit", " ", "=", " ", 
                    RowBox[{"Chop", "[", "zunit", "]"}]}], ";", " ", 
                    RowBox[{
                    "magnitude", " ", "=", " ", "\n", 
                    "                        ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"xunit", "^", "2"}], " ", "+", " ", 
                    RowBox[{"yunit", "^", "2"}], " ", "+", " ", 
                    RowBox[{"zunit", "^", "2"}]}], ")"}], "^", 
                    RowBox[{"2", "^", 
                    RowBox[{"(", 
                    RowBox[{"-", "1"}], ")"}]}]}]}], ";", " ", 
                    RowBox[{
                    "xunit", " ", "=", " ", "\n", "                        ", 
                    
                    RowBox[{"xunit", "/", "magnitude"}]}], ";", " ", 
                    RowBox[{"yunit", " ", "=", " ", 
                    RowBox[{"yunit", "/", "magnitude"}]}], ";", " ", "\n", 
                    "                       ", 
                    RowBox[{"zunit", " ", "=", " ", 
                    RowBox[{"zunit", "/", "magnitude"}]}], ";", " ", 
                    RowBox[{"rx", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"-", "1."}], "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "100."}], " ", "+", " ", "rey"}], ")"}]}]}], 
                    ";", " ", "\n", "                       ", 
                    RowBox[{"ry", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"-", "100."}], " ", "+", " ", "rex"}]}], ";", " ", 
                    RowBox[{"rz", " ", "=", " ", "rez"}], ";", " ", 
                    RowBox[{"rx", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rx", "]"}]}], ";", " ", "\n", 
                    "                       ", 
                    RowBox[{"ry", " ", "=", " ", 
                    RowBox[{"Chop", "[", "ry", "]"}]}], ";", " ", 
                    RowBox[{"rz", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rz", "]"}]}], ";", " ", "\n", 
                    "                       ", 
                    RowBox[{"terminatedeflection", " ", "=", " ", "False"}], 
                    ";", " ", 
                    RowBox[{
                    "intersections", " ", "=", " ", "\n", 
                    "                        ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}], "}"}]}], ";", " ", 
                    RowBox[{"intersections", " ", "=", " ", 
                    RowBox[{"If", "[", "\n", "                        ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Chop", "[", "xunit", "]"}], " ", "!=", " ", 
                    "0"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"N", "[", 
                    RowBox[{"Chop", "[", 
                    RowBox[{"#1", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "]"}], "]"}], " ", ">=", 
                    " ", "0."}], " ", "&&", " ", "\n", 
                    "                        ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"#1", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], " ", "<=", " ", "100."}], 
                    " ", "&&", " ", 
                    RowBox[{
                    RowBox[{"#1", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], " ", ">=", " ", 
                    RowBox[{"-", "100."}]}], " ", "&&", " ", "\n", 
                    "                        ", 
                    RowBox[{
                    RowBox[{"#1", "[", 
                    RowBox[{"[", "3", "]"}], "]"}], " ", ">=", " ", 
                    RowBox[{"-", "100."}]}], " ", "&&", " ", 
                    RowBox[{
                    RowBox[{"#1", "[", 
                    RowBox[{"[", "3", "]"}], "]"}], " ", "<=", " ", 
                    "100."}]}], ")"}]}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"#1", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], ",", " ", "\n", 
                    "                        ", 
                    RowBox[{"#1", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], ",", " ", 
                    RowBox[{"#1", "[", 
                    RowBox[{"[", "3", "]"}], "]"}]}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}]}], "]"}], " ", "&"}], " ", ")"}], "[", "\n", 
                    "                        ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"(", 
                    RowBox[{"rx", "/", "xunit"}], ")"}]}], ",", " ", 
                    RowBox[{"ry", " ", "-", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"rx", "*", "yunit"}], ")"}], "/", "xunit"}]}], 
                    ",", " ", 
                    RowBox[{
                    "rz", " ", "-", " ", "\n", "                        ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"rx", "*", "zunit"}], ")"}], "/", "xunit"}]}]}], 
                    "}"}], "]"}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}], "}"}]}], "]"}]}], ";", " ", 
                    RowBox[{"AppendTo", "[", "\n", "                        ", 
                    RowBox[{"intersections", ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}]}], "]"}], ";", " ", 
                    RowBox[{"holeQ", " ", "=", " ", "False"}], ";", " ", "\n",
                     "                       ", 
                    RowBox[{"If", "[", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"!", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Chop", "[", 
                    RowBox[{"surfaceid", " ", "-", " ", "92443."}], "]"}], 
                    " ", "==", " ", "0."}], " ", "||", " ", "\n", 
                    "                        ", 
                    RowBox[{
                    RowBox[{"N", "[", 
                    RowBox[{"Chop", "[", "ray1", "]"}], "]"}], " ", "<", " ", 
                    "0.0001"}]}], ")"}]}], " ", "||", " ", 
                    RowBox[{
                    "generationnumber", " ", "==", " ", "\n", 
                    "                        ", "1."}]}], ",", " ", 
                    RowBox[{"minresonateraylength", " ", "=", " ", "0."}], 
                    ",", " ", "\n", "                        ", 
                    RowBox[{
                    "minresonateraylength", " ", "=", " ", "0.0001"}]}], 
                    "]"}], ";", " ", 
                    RowBox[{"Block", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "LocRayL", ",", " ", "\n", "                        ", 
                    "LocSCx", ",", " ", "LocSCy"}], "}"}], ",", " ", 
                    RowBox[{
                    RowBox[{"LocRayL", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"LocSCx", " ", "=", " ", "1."}], ";", " ", "\n", 
                    "                        ", 
                    RowBox[{"LocSCy", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"dummymatrix", " ", "=", " ", 
                    RowBox[{"Union", "[", 
                    RowBox[{"Select", "[", "\n", "                        ", 
                    RowBox[{"intersections", ",", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "LocRayL", ",", " ", "LocSCx", ",", " ", "LocSCy"}], 
                    "}"}], " ", "=", " ", "#1"}], ";", " ", "\n", 
                    "                        ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "LocRayL", ",", " ", "LocSCx", ",", " ", "LocSCy"}], 
                    "}"}], " ", "==", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}]}], " ", "||", " ", "\n", "                        ", 
                    RowBox[{
                    RowBox[{"N", "[", 
                    RowBox[{"Chop", "[", "LocRayL", "]"}], "]"}], " ", ">=", 
                    " ", "minresonateraylength"}]}]}], ")"}], " ", "&"}]}], 
                    " ", "]"}], "]"}]}], ";", " ", "\n", 
                    "                        ", 
                    RowBox[{
                    "intersections", " ", "=", " ", "dummymatrix"}]}]}], 
                    "]"}], ";", " ", "\n", "                       ", 
                    RowBox[{"unfilteredintersections", " ", "=", " ", 
                    "intersections"}], ";", " ", "\n", 
                    "                       ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", "intersections", "]"}], " ", ">", 
                    " ", "1"}], ",", " ", 
                    RowBox[{
                    RowBox[{
                    "dummymatrix", " ", "=", " ", "\n", 
                    "                        ", 
                    RowBox[{"Take", "[", 
                    RowBox[{"intersections", ",", " ", 
                    RowBox[{"{", "2", "}"}]}], "]"}]}], ";", " ", 
                    RowBox[{
                    "intersections", " ", "=", " ", "\n", 
                    "                        ", "dummymatrix"}], ";", " ", 
                    "1."}], ",", " ", "1."}], "]"}], ";", " ", 
                    RowBox[{"AppendTo", "[", "\n", "                        ", 
                    RowBox[{"intersectionslist", ",", " ", "intersections"}], 
                    "]"}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    "holeQ", ",", " ", "\n", "                        ", 
                    RowBox[{"AppendTo", "[", 
                    RowBox[{"holeQlist", ",", " ", "1"}], "]"}], ",", " ", 
                    RowBox[{"AppendTo", "[", 
                    RowBox[{"holeQlist", ",", " ", "0"}], "]"}]}], "]"}], ";",
                     " ", "\n", "                       ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "rez", ",", " ", "r1", ",", 
                    " ", "r2", ",", " ", "r3", ",", " ", "r4", ",", " ", "\n",
                     "                        ", "r5", ",", " ", "r6", ",", 
                    " ", "r7", ",", " ", "r8", ",", " ", "r9", ",", " ", 
                    "wavelength", ",", " ", "intensity", ",", " ", "\n", 
                    "                        ", "intensityscale", ",", " ", 
                    "ray1", ",", " ", "index", ",", " ", "opticallength", ",",
                     " ", "\n", "                        ", "phaseshift", ",",
                     " ", "componentnumber", ",", " ", "surfacenumber", ",", 
                    " ", "\n", "                        ", "surfaceid", ",", 
                    " ", "ray2", ",", " ", "ray3", ",", " ", "sid", ",", " ", 
                    "frontid", ",", " ", "sno1", ",", " ", "sno2", ",", " ", 
                    "\n", "                        ", "sno3", ",", " ", 
                    "sno4", ",", " ", "rayslot", ",", " ", 
                    "oldgenerationnumber", ",", " ", "\n", 
                    "                        ", "intersectionnumber", ",", 
                    " ", "pol1", ",", " ", "pol2", ",", " ", "pol3"}], "}"}], 
                    " ", "=", " ", "#1"}], ";", " ", "\n", 
                    "                       ", 
                    RowBox[{"index1", " ", "=", " ", "index"}], ";", " ", 
                    RowBox[{"xunit", " ", "=", " ", "r3"}], ";", " ", 
                    RowBox[{"yunit", " ", "=", " ", "r2"}], ";", " ", 
                    RowBox[{
                    "zunit", " ", "=", " ", "\n", "                        ", 
                    
                    RowBox[{
                    RowBox[{"-", "1."}], "*", "r1"}]}], ";", " ", 
                    RowBox[{"xunit", " ", "=", " ", 
                    RowBox[{"Chop", "[", "xunit", "]"}]}], ";", " ", 
                    RowBox[{"yunit", " ", "=", " ", 
                    RowBox[{
                    "Chop", "[", "\n", "                        ", "yunit", 
                    "]"}]}], ";", " ", 
                    RowBox[{"zunit", " ", "=", " ", 
                    RowBox[{"Chop", "[", "zunit", "]"}]}], ";", " ", 
                    RowBox[{
                    "magnitude", " ", "=", " ", "\n", 
                    "                        ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"xunit", "^", "2"}], " ", "+", " ", 
                    RowBox[{"yunit", "^", "2"}], " ", "+", " ", 
                    RowBox[{"zunit", "^", "2"}]}], ")"}], "^", 
                    RowBox[{"2", "^", 
                    RowBox[{"(", 
                    RowBox[{"-", "1"}], ")"}]}]}]}], ";", " ", 
                    RowBox[{
                    "xunit", " ", "=", " ", "\n", "                        ", 
                    
                    RowBox[{"xunit", "/", "magnitude"}]}], ";", " ", 
                    RowBox[{"yunit", " ", "=", " ", 
                    RowBox[{"yunit", "/", "magnitude"}]}], ";", " ", "\n", 
                    "                       ", 
                    RowBox[{"zunit", " ", "=", " ", 
                    RowBox[{"zunit", "/", "magnitude"}]}], ";", " ", 
                    RowBox[{"rx", " ", "=", " ", 
                    RowBox[{"100.", " ", "+", " ", "rez"}]}], ";", " ", "\n", 
                    "                       ", 
                    RowBox[{"ry", " ", "=", " ", "rey"}], ";", " ", 
                    RowBox[{"rz", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"-", "1."}], "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "100."}], " ", "+", " ", "rex"}], ")"}]}]}], 
                    ";", " ", 
                    RowBox[{"rx", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rx", "]"}]}], ";", " ", "\n", 
                    "                       ", 
                    RowBox[{"ry", " ", "=", " ", 
                    RowBox[{"Chop", "[", "ry", "]"}]}], ";", " ", 
                    RowBox[{"rz", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rz", "]"}]}], ";", " ", "\n", 
                    "                       ", 
                    RowBox[{"terminatedeflection", " ", "=", " ", "False"}], 
                    ";", " ", 
                    RowBox[{
                    "intersections", " ", "=", " ", "\n", 
                    "                        ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}], "}"}]}], ";", " ", 
                    RowBox[{"intersections", " ", "=", " ", 
                    RowBox[{"If", "[", "\n", "                        ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Chop", "[", "xunit", "]"}], " ", "!=", " ", 
                    "0"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"N", "[", 
                    RowBox[{"Chop", "[", 
                    RowBox[{"#1", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "]"}], "]"}], " ", ">=", 
                    " ", "0."}], " ", "&&", " ", "\n", 
                    "                        ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"#1", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], " ", "<=", " ", "100."}], 
                    " ", "&&", " ", 
                    RowBox[{
                    RowBox[{"#1", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], " ", ">=", " ", 
                    RowBox[{"-", "100."}]}], " ", "&&", " ", "\n", 
                    "                        ", 
                    RowBox[{
                    RowBox[{"#1", "[", 
                    RowBox[{"[", "3", "]"}], "]"}], " ", ">=", " ", 
                    RowBox[{"-", "100."}]}], " ", "&&", " ", 
                    RowBox[{
                    RowBox[{"#1", "[", 
                    RowBox[{"[", "3", "]"}], "]"}], " ", "<=", " ", 
                    "100."}]}], ")"}]}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"#1", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], ",", " ", "\n", 
                    "                        ", 
                    RowBox[{"#1", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], ",", " ", 
                    RowBox[{"#1", "[", 
                    RowBox[{"[", "3", "]"}], "]"}]}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}]}], "]"}], " ", "&"}], " ", ")"}], "[", "\n", 
                    "                        ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"(", 
                    RowBox[{"rx", "/", "xunit"}], ")"}]}], ",", " ", 
                    RowBox[{"ry", " ", "-", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"rx", "*", "yunit"}], ")"}], "/", "xunit"}]}], 
                    ",", " ", 
                    RowBox[{
                    "rz", " ", "-", " ", "\n", "                        ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"rx", "*", "zunit"}], ")"}], "/", "xunit"}]}]}], 
                    "}"}], "]"}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}], "}"}]}], "]"}]}], ";", " ", 
                    RowBox[{"AppendTo", "[", "\n", "                        ", 
                    RowBox[{"intersections", ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}]}], "]"}], ";", " ", 
                    RowBox[{"holeQ", " ", "=", " ", "False"}], ";", " ", "\n",
                     "                       ", 
                    RowBox[{"If", "[", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"!", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Chop", "[", 
                    RowBox[{"surfaceid", " ", "-", " ", "92444."}], "]"}], 
                    " ", "==", " ", "0."}], " ", "||", " ", "\n", 
                    "                        ", 
                    RowBox[{
                    RowBox[{"N", "[", 
                    RowBox[{"Chop", "[", "ray1", "]"}], "]"}], " ", "<", " ", 
                    "0.0001"}]}], ")"}]}], " ", "||", " ", 
                    RowBox[{
                    "generationnumber", " ", "==", " ", "\n", 
                    "                        ", "1."}]}], ",", " ", 
                    RowBox[{"minresonateraylength", " ", "=", " ", "0."}], 
                    ",", " ", "\n", "                        ", 
                    RowBox[{
                    "minresonateraylength", " ", "=", " ", "0.0001"}]}], 
                    "]"}], ";", " ", 
                    RowBox[{"Block", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "LocRayL", ",", " ", "\n", "                        ", 
                    "LocSCx", ",", " ", "LocSCy"}], "}"}], ",", " ", 
                    RowBox[{
                    RowBox[{"LocRayL", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"LocSCx", " ", "=", " ", "1."}], ";", " ", "\n", 
                    "                        ", 
                    RowBox[{"LocSCy", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"dummymatrix", " ", "=", " ", 
                    RowBox[{"Union", "[", 
                    RowBox[{"Select", "[", "\n", "                        ", 
                    RowBox[{"intersections", ",", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "LocRayL", ",", " ", "LocSCx", ",", " ", "LocSCy"}], 
                    "}"}], " ", "=", " ", "#1"}], ";", " ", "\n", 
                    "                        ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "LocRayL", ",", " ", "LocSCx", ",", " ", "LocSCy"}], 
                    "}"}], " ", "==", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}]}], " ", "||", " ", "\n", "                        ", 
                    RowBox[{
                    RowBox[{"N", "[", 
                    RowBox[{"Chop", "[", "LocRayL", "]"}], "]"}], " ", ">=", 
                    " ", "minresonateraylength"}]}]}], ")"}], " ", "&"}]}], 
                    " ", "]"}], "]"}]}], ";", " ", "\n", 
                    "                        ", 
                    RowBox[{
                    "intersections", " ", "=", " ", "dummymatrix"}]}]}], 
                    "]"}], ";", " ", "\n", "                       ", 
                    RowBox[{
                    "unfilteredintersections", " ", "=", " ", 
                    "intersections"}], ";", " ", "\n", 
                    "                       ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", "intersections", "]"}], " ", ">", 
                    " ", "1"}], ",", " ", 
                    RowBox[{
                    RowBox[{
                    "dummymatrix", " ", "=", " ", "\n", 
                    "                        ", 
                    RowBox[{"Take", "[", 
                    RowBox[{"intersections", ",", " ", 
                    RowBox[{"{", "2", "}"}]}], "]"}]}], ";", " ", 
                    RowBox[{
                    "intersections", " ", "=", " ", "\n", 
                    "                        ", "dummymatrix"}], ";", " ", 
                    "1."}], ",", " ", "1."}], "]"}], ";", " ", 
                    RowBox[{"AppendTo", "[", "\n", "                        ", 
                    RowBox[{"intersectionslist", ",", " ", "intersections"}], 
                    "]"}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    "holeQ", ",", " ", "\n", "                        ", 
                    RowBox[{"AppendTo", "[", 
                    RowBox[{"holeQlist", ",", " ", "1"}], "]"}], ",", " ", 
                    RowBox[{"AppendTo", "[", 
                    RowBox[{"holeQlist", ",", " ", "0"}], "]"}]}], "]"}], ";",
                     " ", "\n", "                       ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "rez", ",", " ", "r1", ",", 
                    " ", "r2", ",", " ", "r3", ",", " ", "r4", ",", " ", "\n",
                     "                        ", "r5", ",", " ", "r6", ",", 
                    " ", "r7", ",", " ", "r8", ",", " ", "r9", ",", " ", 
                    "wavelength", ",", " ", "intensity", ",", " ", "\n", 
                    "                        ", "intensityscale", ",", " ", 
                    "ray1", ",", " ", "index", ",", " ", "opticallength", ",",
                     " ", "\n", "                        ", "phaseshift", ",",
                     " ", "componentnumber", ",", " ", "surfacenumber", ",", 
                    " ", "\n", "                        ", "surfaceid", ",", 
                    " ", "ray2", ",", " ", "ray3", ",", " ", "sid", ",", " ", 
                    "frontid", ",", " ", "sno1", ",", " ", "sno2", ",", " ", 
                    "\n", "                        ", "sno3", ",", " ", 
                    "sno4", ",", " ", "rayslot", ",", " ", 
                    "oldgenerationnumber", ",", " ", "\n", 
                    "                        ", "intersectionnumber", ",", 
                    " ", "pol1", ",", " ", "pol2", ",", " ", "pol3"}], "}"}], 
                    " ", "=", " ", "#1"}], ";", " ", "\n", 
                    "                       ", 
                    RowBox[{"index1", " ", "=", " ", "index"}], ";", " ", 
                    RowBox[{"xunit", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"-", "1."}], "*", "r3"}]}], ";", " ", 
                    RowBox[{"yunit", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"-", "1."}], "*", "r2"}]}], ";", " ", "\n", 
                    "                       ", 
                    RowBox[{"zunit", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"-", "1."}], "*", "r1"}]}], ";", " ", 
                    RowBox[{"xunit", " ", "=", " ", 
                    RowBox[{"Chop", "[", "xunit", "]"}]}], ";", " ", 
                    RowBox[{
                    "yunit", " ", "=", " ", "\n", "                        ", 
                    
                    RowBox[{"Chop", "[", "yunit", "]"}]}], ";", " ", 
                    RowBox[{"zunit", " ", "=", " ", 
                    RowBox[{"Chop", "[", "zunit", "]"}]}], ";", " ", 
                    RowBox[{
                    "magnitude", " ", "=", " ", "\n", 
                    "                        ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"xunit", "^", "2"}], " ", "+", " ", 
                    RowBox[{"yunit", "^", "2"}], " ", "+", " ", 
                    RowBox[{"zunit", "^", "2"}]}], ")"}], "^", 
                    RowBox[{"2", "^", 
                    RowBox[{"(", 
                    RowBox[{"-", "1"}], ")"}]}]}]}], ";", " ", 
                    RowBox[{
                    "xunit", " ", "=", " ", "\n", "                        ", 
                    
                    RowBox[{"xunit", "/", "magnitude"}]}], ";", " ", 
                    RowBox[{"yunit", " ", "=", " ", 
                    RowBox[{"yunit", "/", "magnitude"}]}], ";", " ", "\n", 
                    "                       ", 
                    RowBox[{"zunit", " ", "=", " ", 
                    RowBox[{"zunit", "/", "magnitude"}]}], ";", " ", 
                    RowBox[{"rx", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"-", "1."}], "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "100."}], " ", "+", " ", "rez"}], ")"}]}]}], 
                    ";", " ", "\n", "                       ", 
                    RowBox[{"ry", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"-", "1."}], "*", "rey"}]}], ";", " ", 
                    RowBox[{"rz", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"-", "1."}], "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "100."}], " ", "+", " ", "rex"}], ")"}]}]}], 
                    ";", " ", 
                    RowBox[{
                    "rx", " ", "=", " ", "\n", "                        ", 
                    RowBox[{"Chop", "[", "rx", "]"}]}], ";", " ", 
                    RowBox[{"ry", " ", "=", " ", 
                    RowBox[{"Chop", "[", "ry", "]"}]}], ";", " ", 
                    RowBox[{"rz", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rz", "]"}]}], ";", " ", "\n", 
                    "                       ", 
                    RowBox[{"terminatedeflection", " ", "=", " ", "False"}], 
                    ";", " ", 
                    RowBox[{
                    "intersections", " ", "=", " ", "\n", 
                    "                        ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}], "}"}]}], ";", " ", 
                    RowBox[{"intersections", " ", "=", " ", 
                    RowBox[{"If", "[", "\n", "                        ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Chop", "[", "xunit", "]"}], " ", "!=", " ", 
                    "0"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"N", "[", 
                    RowBox[{"Chop", "[", 
                    RowBox[{"#1", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "]"}], "]"}], " ", ">=", 
                    " ", "0."}], " ", "&&", " ", "\n", 
                    "                        ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"#1", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], " ", "<=", " ", "100."}], 
                    " ", "&&", " ", 
                    RowBox[{
                    RowBox[{"#1", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], " ", ">=", " ", 
                    RowBox[{"-", "100."}]}], " ", "&&", " ", "\n", 
                    "                        ", 
                    RowBox[{
                    RowBox[{"#1", "[", 
                    RowBox[{"[", "3", "]"}], "]"}], " ", ">=", " ", 
                    RowBox[{"-", "100."}]}], " ", "&&", " ", 
                    RowBox[{
                    RowBox[{"#1", "[", 
                    RowBox[{"[", "3", "]"}], "]"}], " ", "<=", " ", 
                    "100."}]}], ")"}]}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"#1", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], ",", " ", "\n", 
                    "                        ", 
                    RowBox[{"#1", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], ",", " ", 
                    RowBox[{"#1", "[", 
                    RowBox[{"[", "3", "]"}], "]"}]}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}]}], "]"}], " ", "&"}], " ", ")"}], "[", "\n", 
                    "                        ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"(", 
                    RowBox[{"rx", "/", "xunit"}], ")"}]}], ",", " ", 
                    RowBox[{"ry", " ", "-", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"rx", "*", "yunit"}], ")"}], "/", "xunit"}]}], 
                    ",", " ", 
                    RowBox[{
                    "rz", " ", "-", " ", "\n", "                        ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"rx", "*", "zunit"}], ")"}], "/", "xunit"}]}]}], 
                    "}"}], "]"}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}], "}"}]}], "]"}]}], ";", " ", 
                    RowBox[{"AppendTo", "[", "\n", "                        ", 
                    RowBox[{"intersections", ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}]}], "]"}], ";", " ", 
                    RowBox[{"holeQ", " ", "=", " ", "False"}], ";", " ", "\n",
                     "                       ", 
                    RowBox[{"If", "[", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"!", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Chop", "[", 
                    RowBox[{"surfaceid", " ", "-", " ", "92445."}], "]"}], 
                    " ", "==", " ", "0."}], " ", "||", " ", "\n", 
                    "                        ", 
                    RowBox[{
                    RowBox[{"N", "[", 
                    RowBox[{"Chop", "[", "ray1", "]"}], "]"}], " ", "<", " ", 
                    "0.0001"}]}], ")"}]}], " ", "||", " ", 
                    RowBox[{
                    "generationnumber", " ", "==", " ", "\n", 
                    "                        ", "1."}]}], ",", " ", 
                    RowBox[{"minresonateraylength", " ", "=", " ", "0."}], 
                    ",", " ", "\n", "                        ", 
                    RowBox[{
                    "minresonateraylength", " ", "=", " ", "0.0001"}]}], 
                    "]"}], ";", " ", 
                    RowBox[{"Block", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "LocRayL", ",", " ", "\n", "                        ", 
                    "LocSCx", ",", " ", "LocSCy"}], "}"}], ",", " ", 
                    RowBox[{
                    RowBox[{"LocRayL", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"LocSCx", " ", "=", " ", "1."}], ";", " ", "\n", 
                    "                        ", 
                    RowBox[{"LocSCy", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"dummymatrix", " ", "=", " ", 
                    RowBox[{"Union", "[", 
                    RowBox[{"Select", "[", "\n", "                        ", 
                    RowBox[{"intersections", ",", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "LocRayL", ",", " ", "LocSCx", ",", " ", "LocSCy"}], 
                    "}"}], " ", "=", " ", "#1"}], ";", " ", "\n", 
                    "                        ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "LocRayL", ",", " ", "LocSCx", ",", " ", "LocSCy"}], 
                    "}"}], " ", "==", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}]}], " ", "||", " ", "\n", "                        ", 
                    RowBox[{
                    RowBox[{"N", "[", 
                    RowBox[{"Chop", "[", "LocRayL", "]"}], "]"}], " ", ">=", 
                    " ", "minresonateraylength"}]}]}], ")"}], " ", "&"}]}], 
                    " ", "]"}], "]"}]}], ";", " ", "\n", 
                    "                        ", 
                    RowBox[{
                    "intersections", " ", "=", " ", "dummymatrix"}]}]}], 
                    "]"}], ";", " ", "\n", "                       ", 
                    RowBox[{
                    "unfilteredintersections", " ", "=", " ", 
                    "intersections"}], ";", " ", "\n", 
                    "                       ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", "intersections", "]"}], " ", ">", 
                    " ", "1"}], ",", " ", 
                    RowBox[{
                    RowBox[{
                    "dummymatrix", " ", "=", " ", "\n", 
                    "                        ", 
                    RowBox[{"Take", "[", 
                    RowBox[{"intersections", ",", " ", 
                    RowBox[{"{", "2", "}"}]}], "]"}]}], ";", " ", 
                    RowBox[{
                    "intersections", " ", "=", " ", "\n", 
                    "                        ", "dummymatrix"}], ";", " ", 
                    "1."}], ",", " ", "1."}], "]"}], ";", " ", 
                    RowBox[{"AppendTo", "[", "\n", "                        ", 
                    RowBox[{"intersectionslist", ",", " ", "intersections"}], 
                    "]"}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    "holeQ", ",", " ", "\n", "                        ", 
                    RowBox[{"AppendTo", "[", 
                    RowBox[{"holeQlist", ",", " ", "1"}], "]"}], ",", " ", 
                    RowBox[{"AppendTo", "[", 
                    RowBox[{
                    "holeQlist", ",", " ", "\n", "                        ", 
                    "0"}], "]"}]}], "]"}]}], ")"}], ";", " ", 
                    RowBox[{"holeQlist", " ", "=", " ", 
                    RowBox[{"Drop", "[", 
                    RowBox[{"holeQlist", ",", " ", "1"}], "]"}]}], ";", " ", 
                    RowBox[{"Drop", "[", "\n", "                       ", 
                    RowBox[{"intersectionslist", ",", " ", "1"}], "]"}]}]}], 
                    "]"}]}], ")"}], ";", " ", 
                    RowBox[{"Which", "[", 
                    RowBox[{
                    RowBox[{
                    "resonatenumber", " ", "==", " ", "\n", 
                    "                     ", "1"}], ",", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "rez", ",", " ", "r1", ",", 
                    " ", "r2", ",", " ", "r3", ",", " ", "r4", ",", " ", "\n",
                     "                       ", "r5", ",", " ", "r6", ",", 
                    " ", "r7", ",", " ", "r8", ",", " ", "r9", ",", " ", 
                    "wavelength", ",", " ", "intensity", ",", " ", "\n", 
                    "                       ", "intensityscale", ",", " ", 
                    "ray1", ",", " ", "index", ",", " ", "opticallength", ",",
                     " ", "\n", "                       ", "phaseshift", ",", 
                    " ", "componentnumber", ",", " ", "surfacenumber", ",", 
                    " ", "\n", "                       ", "surfaceid", ",", 
                    " ", "ray2", ",", " ", "ray3", ",", " ", "sid", ",", " ", 
                    "frontid", ",", " ", "sno1", ",", " ", "sno2", ",", " ", 
                    "\n", "                       ", "sno3", ",", " ", "sno4",
                     ",", " ", "rayslot", ",", " ", "oldgenerationnumber", 
                    ",", " ", "\n", "                       ", 
                    "intersectionnumber", ",", " ", "pol1", ",", " ", "pol2", 
                    ",", " ", "pol3"}], "}"}], " ", "=", " ", "#1"}], ";", 
                    " ", "\n", "                     ", 
                    RowBox[{"index1", " ", "=", " ", "index"}], ";", " ", 
                    RowBox[{"xunit", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"-", "1."}], "*", "r1"}]}], ";", " ", 
                    RowBox[{"yunit", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"-", "1."}], "*", "r2"}]}], ";", " ", "\n", 
                    "                     ", 
                    RowBox[{"zunit", " ", "=", " ", "r3"}], ";", " ", 
                    RowBox[{"xunit", " ", "=", " ", 
                    RowBox[{"Chop", "[", "xunit", "]"}]}], ";", " ", 
                    RowBox[{"yunit", " ", "=", " ", 
                    RowBox[{
                    "Chop", "[", "\n", "                       ", "yunit", 
                    "]"}]}], ";", " ", 
                    RowBox[{"zunit", " ", "=", " ", 
                    RowBox[{"Chop", "[", "zunit", "]"}]}], ";", " ", 
                    RowBox[{
                    "magnitude", " ", "=", " ", "\n", 
                    "                      ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"xunit", "^", "2"}], " ", "+", " ", 
                    RowBox[{"yunit", "^", "2"}], " ", "+", " ", 
                    RowBox[{"zunit", "^", "2"}]}], ")"}], "^", 
                    RowBox[{"2", "^", 
                    RowBox[{"(", 
                    RowBox[{"-", "1"}], ")"}]}]}]}], ";", " ", 
                    RowBox[{
                    "xunit", " ", "=", " ", "\n", "                      ", 
                    RowBox[{"xunit", "/", "magnitude"}]}], ";", " ", 
                    RowBox[{"yunit", " ", "=", " ", 
                    RowBox[{"yunit", "/", "magnitude"}]}], ";", " ", "\n", 
                    "                     ", 
                    RowBox[{"zunit", " ", "=", " ", 
                    RowBox[{"zunit", "/", "magnitude"}]}], ";", " ", 
                    RowBox[{"rx", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"-", "1."}], "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "200."}], " ", "+", " ", "rex"}], ")"}]}]}], 
                    ";", " ", "\n", "                     ", 
                    RowBox[{"ry", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"-", "1."}], "*", "rey"}]}], ";", " ", 
                    RowBox[{"rz", " ", "=", " ", "rez"}], ";", " ", 
                    RowBox[{"rx", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rx", "]"}]}], ";", " ", 
                    RowBox[{
                    "ry", " ", "=", " ", "\n", "                      ", 
                    RowBox[{"Chop", "[", "ry", "]"}]}], ";", " ", 
                    RowBox[{"rz", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rz", "]"}]}], ";", " ", 
                    RowBox[{
                    "terminatedeflection", " ", "=", " ", "\n", 
                    "                      ", "False"}], ";", " ", 
                    RowBox[{"intersections", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}], "}"}]}], ";", " ", "\n", "                     ", 
                    RowBox[{
                    "intersections", " ", "=", " ", "resonateintersections"}],
                     ";", " ", 
                    RowBox[{
                    "holeQ", " ", "=", " ", "\n", "                      ", 
                    RowBox[{
                    RowBox[{"holeQlist", "[", 
                    RowBox[{"[", "resonatenumber", "]"}], "]"}], " ", "==", 
                    " ", "1"}]}], ";", " ", "\n", "                     ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "newcomponentnumber", ",", " ", "newsurfacenumber", ",", 
                    " ", "\n", "                       ", "newsurfaceid"}], 
                    "}"}], " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"2.", ",", " ", "1.", ",", " ", "92440."}], 
                    "}"}]}], ";", " ", "\n", "                     ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "componentnumber", ",", " ", "surfacenumber", ",", " ", 
                    "surfaceid"}], "}"}], " ", "=", " ", "\n", 
                    "                      ", 
                    RowBox[{"{", 
                    RowBox[{"2.", ",", " ", "1.", ",", " ", "92440."}], 
                    "}"}]}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"ray1", ",", " ", "ray2", ",", " ", "ray3"}], 
                    "}"}], " ", "=", " ", "\n", "                      ", 
                    RowBox[{"intersections", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], ";", " ", 
                    RowBox[{"rsx", " ", "=", " ", "rex"}], ";", " ", 
                    RowBox[{"rsy", " ", "=", " ", "rey"}], ";", " ", "\n", 
                    "                     ", 
                    RowBox[{"rsz", " ", "=", " ", "rez"}], ";", " ", 
                    RowBox[{"rxhlp", " ", "=", " ", 
                    RowBox[{"rx", " ", "+", " ", 
                    RowBox[{"ray1", "*", "xunit"}]}]}], ";", " ", 
                    RowBox[{
                    "ryhlp", " ", "=", " ", "\n", "                      ", 
                    RowBox[{"ry", " ", "+", " ", 
                    RowBox[{"ray1", "*", "yunit"}]}]}], ";", " ", 
                    RowBox[{"rzhlp", " ", "=", " ", 
                    RowBox[{"rz", " ", "+", " ", 
                    RowBox[{"ray1", "*", "zunit"}]}]}], ";", " ", "\n", 
                    "                     ", 
                    RowBox[{"rex", " ", "=", " ", 
                    RowBox[{"200.", " ", "-", " ", 
                    RowBox[{"1.", "*", "rxhlp"}]}]}], ";", " ", 
                    RowBox[{"rey", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"-", "1."}], "*", "ryhlp"}]}], ";", " ", 
                    RowBox[{
                    "rez", " ", "=", " ", "\n", "                      ", 
                    "rzhlp"}], ";", " ", 
                    RowBox[{"rex", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rex", "]"}]}], ";", " ", 
                    RowBox[{"rey", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rey", "]"}]}], ";", " ", "\n", 
                    "                     ", 
                    RowBox[{"rez", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rez", "]"}]}], ";", " ", 
                    RowBox[{
                    "intersectionnumber", " ", "=", " ", "\n", 
                    "                      ", 
                    RowBox[{"intersectionnumber", " ", "+", " ", "1."}]}], 
                    ";", " ", 
                    RowBox[{
                    "opticallength", " ", "=", " ", "\n", 
                    "                      ", 
                    RowBox[{"opticallength", " ", "+", " ", 
                    RowBox[{"ray1", "*", "index1"}]}]}], ";", " ", 
                    RowBox[{
                    "completedray", " ", "=", " ", "\n", 
                    "                      ", 
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "rez", ",", " ", "r1", ",", 
                    " ", "r2", ",", " ", "r3", ",", " ", "r4", ",", " ", "r5",
                     ",", " ", "\n", "                       ", "r6", ",", 
                    " ", "r7", ",", " ", "r8", ",", " ", "r9", ",", " ", 
                    "wavelength", ",", " ", "intensity", ",", " ", "\n", 
                    "                       ", "intensityscale", ",", " ", 
                    "ray1", ",", " ", "index", ",", " ", "opticallength", ",",
                     " ", "\n", "                       ", "phaseshift", ",", 
                    " ", "componentnumber", ",", " ", "surfacenumber", ",", 
                    " ", "\n", "                       ", "surfaceid", ",", 
                    " ", "ray2", ",", " ", "ray3", ",", " ", "sid", ",", " ", 
                    "frontid", ",", " ", "sno1", ",", " ", "sno2", ",", " ", 
                    "\n", "                       ", "sno3", ",", " ", "sno4",
                     ",", " ", "rayslot", ",", " ", "generationnumber", ",", 
                    " ", "\n", "                       ", 
                    "intersectionnumber", ",", " ", "pol1", ",", " ", "pol2", 
                    ",", " ", "pol3"}], "}"}]}], ";", " ", "\n", 
                    "                     ", 
                    RowBox[{"reportedrayspresent", " ", "=", " ", "True"}], 
                    ";", " ", 
                    RowBox[{
                    "intersectionspresent", " ", "=", " ", "\n", 
                    "                      ", "True"}], ";", " ", 
                    RowBox[{"deflectedrayspresent", " ", "=", " ", "True"}], 
                    ";", " ", "\n", "                     ", 
                    RowBox[{
                    "localdummyoutrayspresent", " ", "=", " ", "True"}], ";", 
                    " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    "surfnorm", " ", "=", " ", "\n", 
                    "                       ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"1.", ",", " ", "0.", ",", " ", "0."}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "1.", ",", " ", "0."}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "0.", ",", " ", "0.", ",", " ", "\n", 
                    "                        ", "1."}], "}"}]}], "}"}], 
                    "]"}]}]}], ";", " ", 
                    RowBox[{"dummymatrix", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", 
                    RowBox[{"-", "1."}], ",", " ", "\n", 
                    "                        ", "0."}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "0.", ",", " ", "1."}], "}"}]}], 
                    "}"}], " ", ".", " ", "#1"}], " ", "&"}], " ", ")"}], " ",
                     "/@", " ", "surfnorm"}]}], ";", " ", "\n", 
                    "                      ", 
                    RowBox[{"surfnorm", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"#1", "/", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"#1", " ", ".", " ", "#1"}], "]"}]}], " ", "&"}], 
                    " ", ")"}], " ", "/@", " ", "dummymatrix"}]}], ";", " ", 
                    "\n", "                      ", 
                    RowBox[{"surfacerotationmatrix", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0", ",", " ", "0"}], 
                    "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", " ", 
                    RowBox[{"-", "1."}], ",", " ", "0"}], "}"}], ",", " ", 
                    "\n", "                        ", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", " ", "0", ",", " ", "1."}], "}"}]}], 
                    "}"}]}], ";", " ", 
                    RowBox[{"surfacetranslationvector", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "200.", ",", " ", "\n", "                        ", "0", 
                    ",", " ", "0"}], "}"}]}], ";", " ", 
                    RowBox[{"activeregion", " ", "=", " ", "0."}], ";", " ", 
                    RowBox[{
                    "completedray", " ", "=", " ", "\n", 
                    "                       ", 
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "rez", ",", " ", "r1", ",", 
                    " ", "r2", ",", " ", "r3", ",", " ", "r4", ",", " ", "\n",
                     "                        ", "r5", ",", " ", "r6", ",", 
                    " ", "r7", ",", " ", "r8", ",", " ", "r9", ",", " ", 
                    "wavelength", ",", " ", "intensity", ",", " ", "\n", 
                    "                        ", "intensityscale", ",", " ", 
                    "ray1", ",", " ", "index", ",", " ", "opticallength", ",",
                     " ", "\n", "                        ", "phaseshift", ",",
                     " ", "componentnumber", ",", " ", "surfacenumber", ",", 
                    " ", "\n", "                        ", "surfaceid", ",", 
                    " ", "ray2", ",", " ", "ray3", ",", " ", "sid", ",", " ", 
                    "frontid", ",", " ", "sno1", ",", " ", "sno2", ",", " ", 
                    "\n", "                        ", "sno3", ",", " ", 
                    "sno4", ",", " ", "rayslot", ",", " ", "generationnumber",
                     ",", " ", "\n", "                        ", 
                    "intersectionnumber", ",", " ", "pol1", ",", " ", "pol2", 
                    ",", " ", "pol3"}], "}"}]}], ";", " ", "\n", 
                    "                      ", 
                    RowBox[{
                    "componentnumber", " ", "=", " ", "newcomponentnumber"}], 
                    ";", " ", "\n", "                      ", 
                    RowBox[{
                    "surfacenumber", " ", "=", " ", "newsurfacenumber"}], ";",
                     " ", 
                    RowBox[{
                    "surfaceid", " ", "=", " ", "\n", 
                    "                       ", "newsurfaceid"}], ";", " ", 
                    RowBox[{"originalray", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "\n", "                        ", "rey", ",", 
                    " ", "rez", ",", " ", "r1", ",", " ", "r2", ",", " ", 
                    "r3", ",", " ", "r4", ",", " ", "r5", ",", " ", "r6", ",",
                     " ", "r7", ",", " ", "r8", ",", " ", "r9", ",", " ", 
                    "\n", "                        ", "wavelength", ",", " ", 
                    "intensity", ",", " ", "intensityscale", ",", " ", "ray1",
                     ",", " ", "\n", "                        ", "index", ",",
                     " ", "opticallength", ",", " ", "phaseshift", ",", " ", 
                    "\n", "                        ", "componentnumber", ",", 
                    " ", "surfacenumber", ",", " ", "surfaceid", ",", " ", 
                    "ray2", ",", " ", "\n", "                        ", 
                    "ray3", ",", " ", "sid", ",", " ", "frontid", ",", " ", 
                    "sno1", ",", " ", "sno2", ",", " ", "sno3", ",", " ", 
                    "sno4", ",", " ", "\n", "                        ", 
                    "rayslot", ",", " ", "generationnumber", ",", " ", 
                    "intersectionnumber", ",", " ", "\n", 
                    "                        ", "pol1", ",", " ", "pol2", ",",
                     " ", "pol3"}], "}"}]}], ";", " ", 
                    RowBox[{"intensity", " ", "=", " ", "0."}], ";", " ", 
                    "\n", "                      ", 
                    RowBox[{"allcreatedrays", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "rez", ",", " ", "\n", 
                    "                        ", "r1", ",", " ", "r2", ",", 
                    " ", "r3", ",", " ", "r4", ",", " ", "r5", ",", " ", "r6",
                     ",", " ", "r7", ",", " ", "r8", ",", " ", "r9", ",", " ",
                     "wavelength", ",", " ", "\n", "                        ",
                     "intensity", ",", " ", "intensityscale", ",", " ", 
                    "ray1", ",", " ", "index", ",", " ", "\n", 
                    "                        ", "opticallength", ",", " ", 
                    "phaseshift", ",", " ", "componentnumber", ",", " ", "\n",
                     "                        ", "surfacenumber", ",", " ", 
                    "surfaceid", ",", " ", "ray2", ",", " ", "ray3", ",", " ",
                     "sid", ",", " ", "\n", "                        ", 
                    "frontid", ",", " ", "sno1", ",", " ", "sno2", ",", " ", 
                    "sno3", ",", " ", "sno4", ",", " ", "rayslot", ",", " ", 
                    "\n", "                        ", "generationnumber", ",",
                     " ", "intersectionnumber", ",", " ", "pol1", ",", " ", 
                    "\n", "                        ", "pol2", ",", " ", 
                    "pol3"}], "}"}], "}"}]}]}], ")"}], ";", " ", 
                    RowBox[{"{", 
                    RowBox[{"allcreatedrays", ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "\n", 
                    "                        ", "1.", ",", " ", "1.", ",", 
                    " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.",
                     ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ",
                     "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "\n", 
                    "                        ", "1.", ",", " ", 
                    RowBox[{"-", "9.87654321*^8"}], ",", " ", "1.", ",", " ", 
                    "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "0.", ",",
                     " ", 
                    RowBox[{"-", "1."}], ",", " ", "\n", 
                    "                        ", 
                    RowBox[{"-", "1."}], ",", " ", 
                    RowBox[{"-", "1."}], ",", " ", "1.", ",", " ", "1.", ",", 
                    " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.",
                     ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ",
                     "\n", "                        ", "1.", ",", " ", "1.", 
                    ",", " ", "1.", ",", " ", "1.", ",", " ", "1."}], "}"}], 
                    "}"}], ",", " ", 
                    RowBox[{"{", "completedray", "}"}]}], "}"}]}], ",", " ", 
                    "\n", "                    ", 
                    RowBox[{"resonatenumber", " ", "==", " ", "2"}], ",", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "rez", ",", " ", "\n", 
                    "                       ", "r1", ",", " ", "r2", ",", " ",
                     "r3", ",", " ", "r4", ",", " ", "r5", ",", " ", "r6", 
                    ",", " ", "r7", ",", " ", "r8", ",", " ", "r9", ",", " ", 
                    "wavelength", ",", " ", "\n", "                       ", 
                    "intensity", ",", " ", "intensityscale", ",", " ", "ray1",
                     ",", " ", "index", ",", " ", "\n", 
                    "                       ", "opticallength", ",", " ", 
                    "phaseshift", ",", " ", "componentnumber", ",", " ", "\n",
                     "                       ", "surfacenumber", ",", " ", 
                    "surfaceid", ",", " ", "ray2", ",", " ", "ray3", ",", " ",
                     "sid", ",", " ", "\n", "                       ", 
                    "frontid", ",", " ", "sno1", ",", " ", "sno2", ",", " ", 
                    "sno3", ",", " ", "sno4", ",", " ", "rayslot", ",", " ", 
                    "\n", "                       ", "oldgenerationnumber", 
                    ",", " ", "intersectionnumber", ",", " ", "pol1", ",", 
                    " ", "\n", "                       ", "pol2", ",", " ", 
                    "pol3"}], "}"}], " ", "=", " ", "#1"}], ";", " ", 
                    RowBox[{"index1", " ", "=", " ", "index"}], ";", " ", 
                    RowBox[{"xunit", " ", "=", " ", "r2"}], ";", " ", "\n", 
                    "                     ", 
                    RowBox[{"yunit", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"-", "1."}], "*", "r1"}]}], ";", " ", 
                    RowBox[{"zunit", " ", "=", " ", "r3"}], ";", " ", 
                    RowBox[{"xunit", " ", "=", " ", 
                    RowBox[{"Chop", "[", "xunit", "]"}]}], ";", " ", "\n", 
                    "                     ", 
                    RowBox[{"yunit", " ", "=", " ", 
                    RowBox[{"Chop", "[", "yunit", "]"}]}], ";", " ", 
                    RowBox[{"zunit", " ", "=", " ", 
                    RowBox[{"Chop", "[", "zunit", "]"}]}], ";", " ", "\n", 
                    "                     ", 
                    RowBox[{"magnitude", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"xunit", "^", "2"}], " ", "+", " ", 
                    RowBox[{"yunit", "^", "2"}], " ", "+", " ", 
                    RowBox[{"zunit", "^", "2"}]}], ")"}], "^", 
                    RowBox[{"2", "^", 
                    RowBox[{"(", 
                    RowBox[{"-", "1"}], ")"}]}]}]}], ";", " ", "\n", 
                    "                     ", 
                    RowBox[{"xunit", " ", "=", " ", 
                    RowBox[{"xunit", "/", "magnitude"}]}], ";", " ", 
                    RowBox[{"yunit", " ", "=", " ", 
                    RowBox[{"yunit", "/", "magnitude"}]}], ";", " ", "\n", 
                    "                     ", 
                    RowBox[{"zunit", " ", "=", " ", 
                    RowBox[{"zunit", "/", "magnitude"}]}], ";", " ", 
                    RowBox[{"rx", " ", "=", " ", 
                    RowBox[{"100.", " ", "+", " ", "rey"}]}], ";", " ", "\n", 
                    "                     ", 
                    RowBox[{"ry", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"-", "1."}], "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "100."}], " ", "+", " ", "rex"}], ")"}]}]}], 
                    ";", " ", 
                    RowBox[{"rz", " ", "=", " ", "rez"}], ";", " ", 
                    RowBox[{"rx", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rx", "]"}]}], ";", " ", "\n", 
                    "                     ", 
                    RowBox[{"ry", " ", "=", " ", 
                    RowBox[{"Chop", "[", "ry", "]"}]}], ";", " ", 
                    RowBox[{"rz", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rz", "]"}]}], ";", " ", 
                    RowBox[{
                    "terminatedeflection", " ", "=", " ", "\n", 
                    "                      ", "False"}], ";", " ", 
                    RowBox[{"intersections", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}], "}"}]}], ";", " ", "\n", "                     ", 
                    RowBox[{
                    "intersections", " ", "=", " ", "resonateintersections"}],
                     ";", " ", 
                    RowBox[{
                    "holeQ", " ", "=", " ", "\n", "                      ", 
                    RowBox[{
                    RowBox[{"holeQlist", "[", 
                    RowBox[{"[", "resonatenumber", "]"}], "]"}], " ", "==", 
                    " ", "1"}]}], ";", " ", "\n", "                     ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "newcomponentnumber", ",", " ", "newsurfacenumber", ",", 
                    " ", "\n", "                       ", "newsurfaceid"}], 
                    "}"}], " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"2.", ",", " ", "2.", ",", " ", "92441."}], 
                    "}"}]}], ";", " ", "\n", "                     ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "componentnumber", ",", " ", "surfacenumber", ",", " ", 
                    "surfaceid"}], "}"}], " ", "=", " ", "\n", 
                    "                      ", 
                    RowBox[{"{", 
                    RowBox[{"2.", ",", " ", "2.", ",", " ", "92441."}], 
                    "}"}]}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"ray1", ",", " ", "ray2", ",", " ", "ray3"}], 
                    "}"}], " ", "=", " ", "\n", "                      ", 
                    RowBox[{"intersections", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], ";", " ", 
                    RowBox[{"rsx", " ", "=", " ", "rex"}], ";", " ", 
                    RowBox[{"rsy", " ", "=", " ", "rey"}], ";", " ", "\n", 
                    "                     ", 
                    RowBox[{"rsz", " ", "=", " ", "rez"}], ";", " ", 
                    RowBox[{"rxhlp", " ", "=", " ", 
                    RowBox[{"rx", " ", "+", " ", 
                    RowBox[{"ray1", "*", "xunit"}]}]}], ";", " ", 
                    RowBox[{
                    "ryhlp", " ", "=", " ", "\n", "                      ", 
                    RowBox[{"ry", " ", "+", " ", 
                    RowBox[{"ray1", "*", "yunit"}]}]}], ";", " ", 
                    RowBox[{"rzhlp", " ", "=", " ", 
                    RowBox[{"rz", " ", "+", " ", 
                    RowBox[{"ray1", "*", "zunit"}]}]}], ";", " ", "\n", 
                    "                     ", 
                    RowBox[{"rex", " ", "=", " ", 
                    RowBox[{"100.", " ", "-", " ", 
                    RowBox[{"1.", "*", "ryhlp"}]}]}], ";", " ", 
                    RowBox[{"rey", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"-", "100."}], " ", "+", " ", "rxhlp"}]}], ";", 
                    " ", "\n", "                     ", 
                    RowBox[{"rez", " ", "=", " ", "rzhlp"}], ";", " ", 
                    RowBox[{"rex", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rex", "]"}]}], ";", " ", 
                    RowBox[{"rey", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rey", "]"}]}], ";", " ", "\n", 
                    "                     ", 
                    RowBox[{"rez", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rez", "]"}]}], ";", " ", 
                    RowBox[{
                    "intersectionnumber", " ", "=", " ", "\n", 
                    "                      ", 
                    RowBox[{"intersectionnumber", " ", "+", " ", "1."}]}], 
                    ";", " ", 
                    RowBox[{
                    "opticallength", " ", "=", " ", "\n", 
                    "                      ", 
                    RowBox[{"opticallength", " ", "+", " ", 
                    RowBox[{"ray1", "*", "index1"}]}]}], ";", " ", 
                    RowBox[{
                    "completedray", " ", "=", " ", "\n", 
                    "                      ", 
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "rez", ",", " ", "r1", ",", 
                    " ", "r2", ",", " ", "r3", ",", " ", "r4", ",", " ", "r5",
                     ",", " ", "\n", "                       ", "r6", ",", 
                    " ", "r7", ",", " ", "r8", ",", " ", "r9", ",", " ", 
                    "wavelength", ",", " ", "intensity", ",", " ", "\n", 
                    "                       ", "intensityscale", ",", " ", 
                    "ray1", ",", " ", "index", ",", " ", "opticallength", ",",
                     " ", "\n", "                       ", "phaseshift", ",", 
                    " ", "componentnumber", ",", " ", "surfacenumber", ",", 
                    " ", "\n", "                       ", "surfaceid", ",", 
                    " ", "ray2", ",", " ", "ray3", ",", " ", "sid", ",", " ", 
                    "frontid", ",", " ", "sno1", ",", " ", "sno2", ",", " ", 
                    "\n", "                       ", "sno3", ",", " ", "sno4",
                     ",", " ", "rayslot", ",", " ", "generationnumber", ",", 
                    " ", "\n", "                       ", 
                    "intersectionnumber", ",", " ", "pol1", ",", " ", "pol2", 
                    ",", " ", "pol3"}], "}"}]}], ";", " ", "\n", 
                    "                     ", 
                    RowBox[{"reportedrayspresent", " ", "=", " ", "True"}], 
                    ";", " ", 
                    RowBox[{
                    "intersectionspresent", " ", "=", " ", "\n", 
                    "                      ", "True"}], ";", " ", 
                    RowBox[{"deflectedrayspresent", " ", "=", " ", "True"}], 
                    ";", " ", "\n", "                     ", 
                    RowBox[{
                    "localdummyoutrayspresent", " ", "=", " ", "True"}], ";", 
                    " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    "surfnorm", " ", "=", " ", "\n", 
                    "                       ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"1.", ",", " ", "0.", ",", " ", "0."}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "1.", ",", " ", "0."}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "0.", ",", " ", "0.", ",", " ", "\n", 
                    "                        ", "1."}], "}"}]}], "}"}], 
                    "]"}]}]}], ";", " ", 
                    RowBox[{"dummymatrix", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", 
                    RowBox[{"-", "1."}], ",", " ", "0."}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "1.", ",", " ", "0.", ",", " ", "\n", 
                    "                        ", "0."}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "0.", ",", " ", "1."}], "}"}]}], 
                    "}"}], " ", ".", " ", "#1"}], " ", "&"}], " ", ")"}], " ",
                     "/@", " ", "surfnorm"}]}], ";", " ", "\n", 
                    "                      ", 
                    RowBox[{"surfnorm", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"#1", "/", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"#1", " ", ".", " ", "#1"}], "]"}]}], " ", "&"}], 
                    " ", ")"}], " ", "/@", " ", "dummymatrix"}]}], ";", " ", 
                    "\n", "                      ", 
                    RowBox[{"surfacerotationmatrix", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0", ",", " ", "1.", ",", " ", "0"}], "}"}], ",", 
                    " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0", ",", " ", "0"}], 
                    "}"}], ",", " ", "\n", "                        ", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", " ", "0", ",", " ", "1."}], "}"}]}], 
                    "}"}]}], ";", " ", 
                    RowBox[{"surfacetranslationvector", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "100.", ",", " ", "\n", "                        ", 
                    RowBox[{"-", "100."}], ",", " ", "0"}], "}"}]}], ";", " ", 
                    RowBox[{"activeregion", " ", "=", " ", "0."}], ";", " ", 
                    RowBox[{
                    "completedray", " ", "=", " ", "\n", 
                    "                       ", 
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "rez", ",", " ", "r1", ",", 
                    " ", "r2", ",", " ", "r3", ",", " ", "r4", ",", " ", "\n",
                     "                        ", "r5", ",", " ", "r6", ",", 
                    " ", "r7", ",", " ", "r8", ",", " ", "r9", ",", " ", 
                    "wavelength", ",", " ", "intensity", ",", " ", "\n", 
                    "                        ", "intensityscale", ",", " ", 
                    "ray1", ",", " ", "index", ",", " ", "opticallength", ",",
                     " ", "\n", "                        ", "phaseshift", ",",
                     " ", "componentnumber", ",", " ", "surfacenumber", ",", 
                    " ", "\n", "                        ", "surfaceid", ",", 
                    " ", "ray2", ",", " ", "ray3", ",", " ", "sid", ",", " ", 
                    "frontid", ",", " ", "sno1", ",", " ", "sno2", ",", " ", 
                    "\n", "                        ", "sno3", ",", " ", 
                    "sno4", ",", " ", "rayslot", ",", " ", "generationnumber",
                     ",", " ", "\n", "                        ", 
                    "intersectionnumber", ",", " ", "pol1", ",", " ", "pol2", 
                    ",", " ", "pol3"}], "}"}]}], ";", " ", "\n", 
                    "                      ", 
                    RowBox[{
                    "componentnumber", " ", "=", " ", "newcomponentnumber"}], 
                    ";", " ", "\n", "                      ", 
                    RowBox[{
                    "surfacenumber", " ", "=", " ", "newsurfacenumber"}], ";",
                     " ", 
                    RowBox[{
                    "surfaceid", " ", "=", " ", "\n", 
                    "                       ", "newsurfaceid"}], ";", " ", 
                    RowBox[{"originalray", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "\n", "                        ", "rey", ",", 
                    " ", "rez", ",", " ", "r1", ",", " ", "r2", ",", " ", 
                    "r3", ",", " ", "r4", ",", " ", "r5", ",", " ", "r6", ",",
                     " ", "r7", ",", " ", "r8", ",", " ", "r9", ",", " ", 
                    "\n", "                        ", "wavelength", ",", " ", 
                    "intensity", ",", " ", "intensityscale", ",", " ", "ray1",
                     ",", " ", "\n", "                        ", "index", ",",
                     " ", "opticallength", ",", " ", "phaseshift", ",", " ", 
                    "\n", "                        ", "componentnumber", ",", 
                    " ", "surfacenumber", ",", " ", "surfaceid", ",", " ", 
                    "ray2", ",", " ", "\n", "                        ", 
                    "ray3", ",", " ", "sid", ",", " ", "frontid", ",", " ", 
                    "sno1", ",", " ", "sno2", ",", " ", "sno3", ",", " ", 
                    "sno4", ",", " ", "\n", "                        ", 
                    "rayslot", ",", " ", "generationnumber", ",", " ", 
                    "intersectionnumber", ",", " ", "\n", 
                    "                        ", "pol1", ",", " ", "pol2", ",",
                     " ", "pol3"}], "}"}]}], ";", " ", 
                    RowBox[{"intensity", " ", "=", " ", "0."}], ";", " ", 
                    "\n", "                      ", 
                    RowBox[{"allcreatedrays", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "rez", ",", " ", "\n", 
                    "                        ", "r1", ",", " ", "r2", ",", 
                    " ", "r3", ",", " ", "r4", ",", " ", "r5", ",", " ", "r6",
                     ",", " ", "r7", ",", " ", "r8", ",", " ", "r9", ",", " ",
                     "wavelength", ",", " ", "\n", "                        ",
                     "intensity", ",", " ", "intensityscale", ",", " ", 
                    "ray1", ",", " ", "index", ",", " ", "\n", 
                    "                        ", "opticallength", ",", " ", 
                    "phaseshift", ",", " ", "componentnumber", ",", " ", "\n",
                     "                        ", "surfacenumber", ",", " ", 
                    "surfaceid", ",", " ", "ray2", ",", " ", "ray3", ",", " ",
                     "sid", ",", " ", "\n", "                        ", 
                    "frontid", ",", " ", "sno1", ",", " ", "sno2", ",", " ", 
                    "sno3", ",", " ", "sno4", ",", " ", "rayslot", ",", " ", 
                    "\n", "                        ", "generationnumber", ",",
                     " ", "intersectionnumber", ",", " ", "pol1", ",", " ", 
                    "\n", "                        ", "pol2", ",", " ", 
                    "pol3"}], "}"}], "}"}]}]}], ")"}], ";", " ", 
                    RowBox[{"{", 
                    RowBox[{"allcreatedrays", ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "\n", 
                    "                        ", "1.", ",", " ", "1.", ",", 
                    " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.",
                     ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ",
                     "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "\n", 
                    "                        ", "1.", ",", " ", 
                    RowBox[{"-", "9.87654321*^8"}], ",", " ", "1.", ",", " ", 
                    "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "0.", ",",
                     " ", 
                    RowBox[{"-", "1."}], ",", " ", "\n", 
                    "                        ", 
                    RowBox[{"-", "1."}], ",", " ", 
                    RowBox[{"-", "1."}], ",", " ", "1.", ",", " ", "1.", ",", 
                    " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.",
                     ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ",
                     "\n", "                        ", "1.", ",", " ", "1.", 
                    ",", " ", "1.", ",", " ", "1.", ",", " ", "1."}], "}"}], 
                    "}"}], ",", " ", 
                    RowBox[{"{", "completedray", "}"}]}], "}"}]}], ",", " ", 
                    "\n", "                    ", 
                    RowBox[{"resonatenumber", " ", "==", " ", "3"}], ",", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "rez", ",", " ", "\n", 
                    "                       ", "r1", ",", " ", "r2", ",", " ",
                     "r3", ",", " ", "r4", ",", " ", "r5", ",", " ", "r6", 
                    ",", " ", "r7", ",", " ", "r8", ",", " ", "r9", ",", " ", 
                    "wavelength", ",", " ", "\n", "                       ", 
                    "intensity", ",", " ", "intensityscale", ",", " ", "ray1",
                     ",", " ", "index", ",", " ", "\n", 
                    "                       ", "opticallength", ",", " ", 
                    "phaseshift", ",", " ", "componentnumber", ",", " ", "\n",
                     "                       ", "surfacenumber", ",", " ", 
                    "surfaceid", ",", " ", "ray2", ",", " ", "ray3", ",", " ",
                     "sid", ",", " ", "\n", "                       ", 
                    "frontid", ",", " ", "sno1", ",", " ", "sno2", ",", " ", 
                    "sno3", ",", " ", "sno4", ",", " ", "rayslot", ",", " ", 
                    "\n", "                       ", "oldgenerationnumber", 
                    ",", " ", "intersectionnumber", ",", " ", "pol1", ",", 
                    " ", "\n", "                       ", "pol2", ",", " ", 
                    "pol3"}], "}"}], " ", "=", " ", "#1"}], ";", " ", 
                    RowBox[{"index1", " ", "=", " ", "index"}], ";", " ", 
                    RowBox[{"xunit", " ", "=", " ", "r1"}], ";", " ", "\n", 
                    "                     ", 
                    RowBox[{"yunit", " ", "=", " ", "r2"}], ";", " ", 
                    RowBox[{"zunit", " ", "=", " ", "r3"}], ";", " ", 
                    RowBox[{"xunit", " ", "=", " ", 
                    RowBox[{"Chop", "[", "xunit", "]"}]}], ";", " ", "\n", 
                    "                     ", 
                    RowBox[{"yunit", " ", "=", " ", 
                    RowBox[{"Chop", "[", "yunit", "]"}]}], ";", " ", 
                    RowBox[{"zunit", " ", "=", " ", 
                    RowBox[{"Chop", "[", "zunit", "]"}]}], ";", " ", "\n", 
                    "                     ", 
                    RowBox[{"magnitude", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"xunit", "^", "2"}], " ", "+", " ", 
                    RowBox[{"yunit", "^", "2"}], " ", "+", " ", 
                    RowBox[{"zunit", "^", "2"}]}], ")"}], "^", 
                    RowBox[{"2", "^", 
                    RowBox[{"(", 
                    RowBox[{"-", "1"}], ")"}]}]}]}], ";", " ", "\n", 
                    "                     ", 
                    RowBox[{"xunit", " ", "=", " ", 
                    RowBox[{"xunit", "/", "magnitude"}]}], ";", " ", 
                    RowBox[{"yunit", " ", "=", " ", 
                    RowBox[{"yunit", "/", "magnitude"}]}], ";", " ", "\n", 
                    "                     ", 
                    RowBox[{"zunit", " ", "=", " ", 
                    RowBox[{"zunit", "/", "magnitude"}]}], ";", " ", 
                    RowBox[{"rx", " ", "=", " ", "rex"}], ";", " ", 
                    RowBox[{"ry", " ", "=", " ", "rey"}], ";", " ", "\n", 
                    "                     ", 
                    RowBox[{"rz", " ", "=", " ", "rez"}], ";", " ", 
                    RowBox[{"rx", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rx", "]"}]}], ";", " ", 
                    RowBox[{"ry", " ", "=", " ", 
                    RowBox[{"Chop", "[", "ry", "]"}]}], ";", " ", 
                    RowBox[{
                    "rz", " ", "=", " ", "\n", "                      ", 
                    RowBox[{"Chop", "[", "rz", "]"}]}], ";", " ", 
                    RowBox[{"terminatedeflection", " ", "=", " ", "False"}], 
                    ";", " ", "\n", "                     ", 
                    RowBox[{"intersections", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}], "}"}]}], ";", " ", 
                    RowBox[{
                    "intersections", " ", "=", " ", "\n", 
                    "                      ", "resonateintersections"}], ";", 
                    " ", 
                    RowBox[{"holeQ", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"holeQlist", "[", 
                    RowBox[{
                    "[", "\n", "                        ", "resonatenumber", 
                    "]"}], "]"}], " ", "==", " ", "1"}]}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "newcomponentnumber", ",", " ", "\n", 
                    "                       ", "newsurfacenumber", ",", " ", 
                    "newsurfaceid"}], "}"}], " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "2.", ",", " ", "3.", ",", " ", "\n", 
                    "                       ", "92442."}], "}"}]}], ";", " ", 
                    
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "componentnumber", ",", " ", "surfacenumber", ",", " ", 
                    "\n", "                       ", "surfaceid"}], "}"}], 
                    " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"2.", ",", " ", "3.", ",", " ", "92442."}], 
                    "}"}]}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "ray1", ",", " ", "ray2", ",", " ", "\n", 
                    "                       ", "ray3"}], "}"}], " ", "=", " ", 
                    RowBox[{"intersections", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], ";", " ", 
                    RowBox[{"rsx", " ", "=", " ", "rex"}], ";", " ", 
                    RowBox[{"rsy", " ", "=", " ", "rey"}], ";", " ", "\n", 
                    "                     ", 
                    RowBox[{"rsz", " ", "=", " ", "rez"}], ";", " ", 
                    RowBox[{"rxhlp", " ", "=", " ", 
                    RowBox[{"rx", " ", "+", " ", 
                    RowBox[{"ray1", "*", "xunit"}]}]}], ";", " ", 
                    RowBox[{
                    "ryhlp", " ", "=", " ", "\n", "                      ", 
                    RowBox[{"ry", " ", "+", " ", 
                    RowBox[{"ray1", "*", "yunit"}]}]}], ";", " ", 
                    RowBox[{"rzhlp", " ", "=", " ", 
                    RowBox[{"rz", " ", "+", " ", 
                    RowBox[{"ray1", "*", "zunit"}]}]}], ";", " ", "\n", 
                    "                     ", 
                    RowBox[{"rex", " ", "=", " ", "rxhlp"}], ";", " ", 
                    RowBox[{"rey", " ", "=", " ", "ryhlp"}], ";", " ", 
                    RowBox[{"rez", " ", "=", " ", "rzhlp"}], ";", " ", 
                    RowBox[{
                    "rex", " ", "=", " ", "\n", "                      ", 
                    RowBox[{"Chop", "[", "rex", "]"}]}], ";", " ", 
                    RowBox[{"rey", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rey", "]"}]}], ";", " ", 
                    RowBox[{"rez", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rez", "]"}]}], ";", " ", "\n", 
                    "                     ", 
                    RowBox[{"intersectionnumber", " ", "=", " ", 
                    RowBox[{"intersectionnumber", " ", "+", " ", "1."}]}], 
                    ";", " ", "\n", "                     ", 
                    RowBox[{"opticallength", " ", "=", " ", 
                    RowBox[{"opticallength", " ", "+", " ", 
                    RowBox[{"ray1", "*", "index1"}]}]}], ";", " ", "\n", 
                    "                     ", 
                    RowBox[{"completedray", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "rez", ",", " ", "r1", ",", 
                    " ", "\n", "                       ", "r2", ",", " ", 
                    "r3", ",", " ", "r4", ",", " ", "r5", ",", " ", "r6", ",",
                     " ", "r7", ",", " ", "r8", ",", " ", "r9", ",", " ", 
                    "wavelength", ",", " ", "\n", "                       ", 
                    "intensity", ",", " ", "intensityscale", ",", " ", "ray1",
                     ",", " ", "index", ",", " ", "\n", 
                    "                       ", "opticallength", ",", " ", 
                    "phaseshift", ",", " ", "componentnumber", ",", " ", "\n",
                     "                       ", "surfacenumber", ",", " ", 
                    "surfaceid", ",", " ", "ray2", ",", " ", "ray3", ",", " ",
                     "sid", ",", " ", "\n", "                       ", 
                    "frontid", ",", " ", "sno1", ",", " ", "sno2", ",", " ", 
                    "sno3", ",", " ", "sno4", ",", " ", "rayslot", ",", " ", 
                    "\n", "                       ", "generationnumber", ",", 
                    " ", "intersectionnumber", ",", " ", "pol1", ",", " ", 
                    "pol2", ",", " ", "\n", "                       ", 
                    "pol3"}], "}"}]}], ";", " ", 
                    RowBox[{"reportedrayspresent", " ", "=", " ", "True"}], 
                    ";", " ", "\n", "                     ", 
                    RowBox[{"intersectionspresent", " ", "=", " ", "True"}], 
                    ";", " ", 
                    RowBox[{
                    "deflectedrayspresent", " ", "=", " ", "\n", 
                    "                      ", "True"}], ";", " ", 
                    RowBox[{"localdummyoutrayspresent", " ", "=", " ", 
                    "True"}], ";", " ", "\n", "                     ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"surfnorm", " ", "=", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"1.", ",", " ", "0.", ",", " ", "0."}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "1.", ",", " ", "0."}], "}"}], 
                    ",", " ", "\n", "                        ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "0.", ",", " ", "1."}], "}"}]}], 
                    "}"}], "]"}]}]}], ";", " ", 
                    RowBox[{"dummymatrix", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"#1", " ", "&"}], " ", ")"}], " ", "/@", " ", 
                    "\n", "                        ", "surfnorm"}]}], ";", 
                    " ", 
                    RowBox[{"surfnorm", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"#1", "/", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"#1", " ", ".", " ", "#1"}], "]"}]}], " ", "&"}], 
                    " ", ")"}], " ", "/@", " ", "\n", 
                    "                        ", "dummymatrix"}]}], ";", " ", 
                    RowBox[{"surfacerotationmatrix", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"1", ",", " ", "0", ",", " ", "0"}], "}"}], ",", 
                    " ", "\n", "                        ", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", " ", "1", ",", " ", "0"}], "}"}], ",", 
                    " ", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", " ", "0", ",", " ", "1"}], "}"}]}], 
                    "}"}]}], ";", " ", "\n", "                      ", 
                    RowBox[{"surfacetranslationvector", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", " ", "0", ",", " ", "0"}], "}"}]}], ";",
                     " ", "\n", "                      ", 
                    RowBox[{"activeregion", " ", "=", " ", "0."}], ";", " ", 
                    RowBox[{"completedray", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "\n", 
                    "                        ", "rex", ",", " ", "rey", ",", 
                    " ", "rez", ",", " ", "r1", ",", " ", "r2", ",", " ", 
                    "r3", ",", " ", "r4", ",", " ", "r5", ",", " ", "r6", ",",
                     " ", "r7", ",", " ", "r8", ",", " ", "\n", 
                    "                        ", "r9", ",", " ", "wavelength", 
                    ",", " ", "intensity", ",", " ", "intensityscale", ",", 
                    " ", "ray1", ",", " ", "\n", "                        ", 
                    "index", ",", " ", "opticallength", ",", " ", 
                    "phaseshift", ",", " ", "\n", "                        ", 
                    "componentnumber", ",", " ", "surfacenumber", ",", " ", 
                    "surfaceid", ",", " ", "ray2", ",", " ", "\n", 
                    "                        ", "ray3", ",", " ", "sid", ",", 
                    " ", "frontid", ",", " ", "sno1", ",", " ", "sno2", ",", 
                    " ", "sno3", ",", " ", "sno4", ",", " ", "\n", 
                    "                        ", "rayslot", ",", " ", 
                    "generationnumber", ",", " ", "intersectionnumber", ",", 
                    " ", "\n", "                        ", "pol1", ",", " ", 
                    "pol2", ",", " ", "pol3"}], "}"}]}], ";", " ", 
                    RowBox[{
                    "componentnumber", " ", "=", " ", "\n", 
                    "                       ", "newcomponentnumber"}], ";", 
                    " ", 
                    RowBox[{
                    "surfacenumber", " ", "=", " ", "\n", 
                    "                       ", "newsurfacenumber"}], ";", " ", 
                    RowBox[{"surfaceid", " ", "=", " ", "newsurfaceid"}], ";",
                     " ", "\n", "                      ", 
                    RowBox[{"originalray", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "rez", ",", " ", "r1", ",", 
                    " ", "\n", "                        ", "r2", ",", " ", 
                    "r3", ",", " ", "r4", ",", " ", "r5", ",", " ", "r6", ",",
                     " ", "r7", ",", " ", "r8", ",", " ", "r9", ",", " ", 
                    "wavelength", ",", " ", "\n", "                        ", 
                    "intensity", ",", " ", "intensityscale", ",", " ", "ray1",
                     ",", " ", "index", ",", " ", "\n", 
                    "                        ", "opticallength", ",", " ", 
                    "phaseshift", ",", " ", "componentnumber", ",", " ", "\n",
                     "                        ", "surfacenumber", ",", " ", 
                    "surfaceid", ",", " ", "ray2", ",", " ", "ray3", ",", " ",
                     "sid", ",", " ", "\n", "                        ", 
                    "frontid", ",", " ", "sno1", ",", " ", "sno2", ",", " ", 
                    "sno3", ",", " ", "sno4", ",", " ", "rayslot", ",", " ", 
                    "\n", "                        ", "generationnumber", ",",
                     " ", "intersectionnumber", ",", " ", "pol1", ",", " ", 
                    "\n", "                        ", "pol2", ",", " ", 
                    "pol3"}], "}"}]}], ";", " ", 
                    RowBox[{"intensity", " ", "=", " ", "0."}], ";", " ", 
                    RowBox[{
                    "allcreatedrays", " ", "=", " ", "\n", 
                    "                       ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "rez", ",", " ", "r1", ",", 
                    " ", "r2", ",", " ", "r3", ",", " ", "r4", ",", " ", "\n",
                     "                        ", "r5", ",", " ", "r6", ",", 
                    " ", "r7", ",", " ", "r8", ",", " ", "r9", ",", " ", 
                    "wavelength", ",", " ", "intensity", ",", " ", "\n", 
                    "                        ", "intensityscale", ",", " ", 
                    "ray1", ",", " ", "index", ",", " ", "opticallength", ",",
                     " ", "\n", "                        ", "phaseshift", ",",
                     " ", "componentnumber", ",", " ", "surfacenumber", ",", 
                    " ", "\n", "                        ", "surfaceid", ",", 
                    " ", "ray2", ",", " ", "ray3", ",", " ", "sid", ",", " ", 
                    "frontid", ",", " ", "sno1", ",", " ", "sno2", ",", " ", 
                    "\n", "                        ", "sno3", ",", " ", 
                    "sno4", ",", " ", "rayslot", ",", " ", "generationnumber",
                     ",", " ", "\n", "                        ", 
                    "intersectionnumber", ",", " ", "pol1", ",", " ", "pol2", 
                    ",", " ", "pol3"}], "}"}], "}"}]}]}], ")"}], ";", " ", 
                    "\n", "                     ", 
                    RowBox[{"{", 
                    RowBox[{"allcreatedrays", ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",",
                     " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", 
                    "1.", ",", " ", "\n", "                        ", "1.", 
                    ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", 
                    "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",",
                     " ", 
                    RowBox[{"-", "9.87654321*^8"}], ",", " ", "\n", 
                    "                        ", "1.", ",", " ", "1.", ",", 
                    " ", "1.", ",", " ", "1.", ",", " ", "0.", ",", " ", 
                    RowBox[{"-", "1."}], ",", " ", 
                    RowBox[{"-", "1."}], ",", " ", 
                    RowBox[{"-", "1."}], ",", " ", "1.", ",", " ", "1.", ",", 
                    " ", "1.", ",", " ", "\n", "                        ", 
                    "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",",
                     " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", 
                    "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1."}], 
                    "}"}], "}"}], ",", " ", "\n", "                      ", 
                    RowBox[{"{", "completedray", "}"}]}], "}"}]}], ",", " ", 
                    RowBox[{"resonatenumber", " ", "==", " ", "4"}], ",", " ",
                     "\n", "                    ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "rez", ",", " ", "r1", ",", 
                    " ", "r2", ",", " ", "r3", ",", " ", "r4", ",", " ", "r5",
                     ",", " ", "\n", "                       ", "r6", ",", 
                    " ", "r7", ",", " ", "r8", ",", " ", "r9", ",", " ", 
                    "wavelength", ",", " ", "intensity", ",", " ", "\n", 
                    "                       ", "intensityscale", ",", " ", 
                    "ray1", ",", " ", "index", ",", " ", "opticallength", ",",
                     " ", "\n", "                       ", "phaseshift", ",", 
                    " ", "componentnumber", ",", " ", "surfacenumber", ",", 
                    " ", "\n", "                       ", "surfaceid", ",", 
                    " ", "ray2", ",", " ", "ray3", ",", " ", "sid", ",", " ", 
                    "frontid", ",", " ", "sno1", ",", " ", "sno2", ",", " ", 
                    "\n", "                       ", "sno3", ",", " ", "sno4",
                     ",", " ", "rayslot", ",", " ", "oldgenerationnumber", 
                    ",", " ", "\n", "                       ", 
                    "intersectionnumber", ",", " ", "pol1", ",", " ", "pol2", 
                    ",", " ", "pol3"}], "}"}], " ", "=", " ", "#1"}], ";", 
                    " ", "\n", "                     ", 
                    RowBox[{"index1", " ", "=", " ", "index"}], ";", " ", 
                    RowBox[{"xunit", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"-", "1."}], "*", "r2"}]}], ";", " ", 
                    RowBox[{"yunit", " ", "=", " ", "r1"}], ";", " ", "\n", 
                    "                     ", 
                    RowBox[{"zunit", " ", "=", " ", "r3"}], ";", " ", 
                    RowBox[{"xunit", " ", "=", " ", 
                    RowBox[{"Chop", "[", "xunit", "]"}]}], ";", " ", 
                    RowBox[{"yunit", " ", "=", " ", 
                    RowBox[{
                    "Chop", "[", "\n", "                       ", "yunit", 
                    "]"}]}], ";", " ", 
                    RowBox[{"zunit", " ", "=", " ", 
                    RowBox[{"Chop", "[", "zunit", "]"}]}], ";", " ", 
                    RowBox[{
                    "magnitude", " ", "=", " ", "\n", 
                    "                      ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"xunit", "^", "2"}], " ", "+", " ", 
                    RowBox[{"yunit", "^", "2"}], " ", "+", " ", 
                    RowBox[{"zunit", "^", "2"}]}], ")"}], "^", 
                    RowBox[{"2", "^", 
                    RowBox[{"(", 
                    RowBox[{"-", "1"}], ")"}]}]}]}], ";", " ", 
                    RowBox[{
                    "xunit", " ", "=", " ", "\n", "                      ", 
                    RowBox[{"xunit", "/", "magnitude"}]}], ";", " ", 
                    RowBox[{"yunit", " ", "=", " ", 
                    RowBox[{"yunit", "/", "magnitude"}]}], ";", " ", "\n", 
                    "                     ", 
                    RowBox[{"zunit", " ", "=", " ", 
                    RowBox[{"zunit", "/", "magnitude"}]}], ";", " ", 
                    RowBox[{"rx", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"-", "1."}], "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "100."}], " ", "+", " ", "rey"}], ")"}]}]}], 
                    ";", " ", "\n", "                     ", 
                    RowBox[{"ry", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"-", "100."}], " ", "+", " ", "rex"}]}], ";", " ", 
                    RowBox[{"rz", " ", "=", " ", "rez"}], ";", " ", 
                    RowBox[{"rx", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rx", "]"}]}], ";", " ", "\n", 
                    "                     ", 
                    RowBox[{"ry", " ", "=", " ", 
                    RowBox[{"Chop", "[", "ry", "]"}]}], ";", " ", 
                    RowBox[{"rz", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rz", "]"}]}], ";", " ", 
                    RowBox[{
                    "terminatedeflection", " ", "=", " ", "\n", 
                    "                      ", "False"}], ";", " ", 
                    RowBox[{"intersections", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}], "}"}]}], ";", " ", "\n", "                     ", 
                    RowBox[{
                    "intersections", " ", "=", " ", "resonateintersections"}],
                     ";", " ", 
                    RowBox[{
                    "holeQ", " ", "=", " ", "\n", "                      ", 
                    RowBox[{
                    RowBox[{"holeQlist", "[", 
                    RowBox[{"[", "resonatenumber", "]"}], "]"}], " ", "==", 
                    " ", "1"}]}], ";", " ", "\n", "                     ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "newcomponentnumber", ",", " ", "newsurfacenumber", ",", 
                    " ", "\n", "                       ", "newsurfaceid"}], 
                    "}"}], " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"2.", ",", " ", "4.", ",", " ", "92443."}], 
                    "}"}]}], ";", " ", "\n", "                     ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "componentnumber", ",", " ", "surfacenumber", ",", " ", 
                    "surfaceid"}], "}"}], " ", "=", " ", "\n", 
                    "                      ", 
                    RowBox[{"{", 
                    RowBox[{"2.", ",", " ", "4.", ",", " ", "92443."}], 
                    "}"}]}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"ray1", ",", " ", "ray2", ",", " ", "ray3"}], 
                    "}"}], " ", "=", " ", "\n", "                      ", 
                    RowBox[{"intersections", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], ";", " ", 
                    RowBox[{"rsx", " ", "=", " ", "rex"}], ";", " ", 
                    RowBox[{"rsy", " ", "=", " ", "rey"}], ";", " ", "\n", 
                    "                     ", 
                    RowBox[{"rsz", " ", "=", " ", "rez"}], ";", " ", 
                    RowBox[{"rxhlp", " ", "=", " ", 
                    RowBox[{"rx", " ", "+", " ", 
                    RowBox[{"ray1", "*", "xunit"}]}]}], ";", " ", 
                    RowBox[{
                    "ryhlp", " ", "=", " ", "\n", "                      ", 
                    RowBox[{"ry", " ", "+", " ", 
                    RowBox[{"ray1", "*", "yunit"}]}]}], ";", " ", 
                    RowBox[{"rzhlp", " ", "=", " ", 
                    RowBox[{"rz", " ", "+", " ", 
                    RowBox[{"ray1", "*", "zunit"}]}]}], ";", " ", "\n", 
                    "                     ", 
                    RowBox[{"rex", " ", "=", " ", 
                    RowBox[{"100.", " ", "+", " ", "ryhlp"}]}], ";", " ", 
                    RowBox[{"rey", " ", "=", " ", 
                    RowBox[{"100.", " ", "-", " ", 
                    RowBox[{"1.", "*", "rxhlp"}]}]}], ";", " ", "\n", 
                    "                     ", 
                    RowBox[{"rez", " ", "=", " ", "rzhlp"}], ";", " ", 
                    RowBox[{"rex", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rex", "]"}]}], ";", " ", 
                    RowBox[{"rey", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rey", "]"}]}], ";", " ", "\n", 
                    "                     ", 
                    RowBox[{"rez", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rez", "]"}]}], ";", " ", 
                    RowBox[{
                    "intersectionnumber", " ", "=", " ", "\n", 
                    "                      ", 
                    RowBox[{"intersectionnumber", " ", "+", " ", "1."}]}], 
                    ";", " ", 
                    RowBox[{"opticallength", " ", "=", " ", "\n", 
                    "                      ", 
                    RowBox[{"opticallength", " ", "+", " ", 
                    RowBox[{"ray1", "*", "index1"}]}]}], ";", " ", 
                    RowBox[{
                    "completedray", " ", "=", " ", "\n", 
                    "                      ", 
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "rez", ",", " ", "r1", ",", 
                    " ", "r2", ",", " ", "r3", ",", " ", "r4", ",", " ", "r5",
                     ",", " ", "\n", "                       ", "r6", ",", 
                    " ", "r7", ",", " ", "r8", ",", " ", "r9", ",", " ", 
                    "wavelength", ",", " ", "intensity", ",", " ", "\n", 
                    "                       ", "intensityscale", ",", " ", 
                    "ray1", ",", " ", "index", ",", " ", "opticallength", ",",
                     " ", "\n", "                       ", "phaseshift", ",", 
                    " ", "componentnumber", ",", " ", "surfacenumber", ",", 
                    " ", "\n", "                       ", "surfaceid", ",", 
                    " ", "ray2", ",", " ", "ray3", ",", " ", "sid", ",", " ", 
                    "frontid", ",", " ", "sno1", ",", " ", "sno2", ",", " ", 
                    "\n", "                       ", "sno3", ",", " ", "sno4",
                     ",", " ", "rayslot", ",", " ", "generationnumber", ",", 
                    " ", "\n", "                       ", 
                    "intersectionnumber", ",", " ", "pol1", ",", " ", "pol2", 
                    ",", " ", "pol3"}], "}"}]}], ";", " ", "\n", 
                    "                     ", 
                    RowBox[{"reportedrayspresent", " ", "=", " ", "True"}], 
                    ";", " ", 
                    RowBox[{
                    "intersectionspresent", " ", "=", " ", "\n", 
                    "                      ", "True"}], ";", " ", 
                    RowBox[{"deflectedrayspresent", " ", "=", " ", "True"}], 
                    ";", " ", "\n", "                     ", 
                    RowBox[{
                    "localdummyoutrayspresent", " ", "=", " ", "True"}], ";", 
                    " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"surfnorm", " ", "=", " ", "\n", 
                    "                       ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"1.", ",", " ", "0.", ",", " ", "0."}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "1.", ",", " ", "0."}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "0.", ",", " ", "0.", ",", " ", "\n", 
                    "                        ", "1."}], "}"}]}], "}"}], 
                    "]"}]}]}], ";", " ", 
                    RowBox[{"dummymatrix", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "1.", ",", " ", "0."}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "\n", 
                    "                        ", "0."}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "0.", ",", " ", "1."}], "}"}]}], 
                    "}"}], " ", ".", " ", "#1"}], " ", "&"}], " ", ")"}], " ",
                     "/@", " ", "surfnorm"}]}], ";", " ", "\n", 
                    "                      ", 
                    RowBox[{"surfnorm", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"#1", "/", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"#1", " ", ".", " ", "#1"}], "]"}]}], " ", "&"}], 
                    " ", ")"}], " ", "/@", " ", "dummymatrix"}]}], ";", " ", 
                    "\n", "                      ", 
                    RowBox[{"surfacerotationmatrix", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0", ",", " ", 
                    RowBox[{"-", "1."}], ",", " ", "0"}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"1.", ",", " ", "0", ",", " ", "0"}], "}"}], ",", 
                    " ", "\n", "                        ", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", " ", "0", ",", " ", "1."}], "}"}]}], 
                    "}"}]}], ";", " ", 
                    RowBox[{"surfacetranslationvector", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "100.", ",", " ", "\n", "                        ", 
                    "100.", ",", " ", "0"}], "}"}]}], ";", " ", 
                    RowBox[{"activeregion", " ", "=", " ", "0."}], ";", " ", 
                    RowBox[{
                    "completedray", " ", "=", " ", "\n", 
                    "                       ", 
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "rez", ",", " ", "r1", ",", 
                    " ", "r2", ",", " ", "r3", ",", " ", "r4", ",", " ", "\n",
                     "                        ", "r5", ",", " ", "r6", ",", 
                    " ", "r7", ",", " ", "r8", ",", " ", "r9", ",", " ", 
                    "wavelength", ",", " ", "intensity", ",", " ", "\n", 
                    "                        ", "intensityscale", ",", " ", 
                    "ray1", ",", " ", "index", ",", " ", "opticallength", ",",
                     " ", "\n", "                        ", "phaseshift", ",",
                     " ", "componentnumber", ",", " ", "surfacenumber", ",", 
                    " ", "\n", "                        ", "surfaceid", ",", 
                    " ", "ray2", ",", " ", "ray3", ",", " ", "sid", ",", " ", 
                    "frontid", ",", " ", "sno1", ",", " ", "sno2", ",", " ", 
                    "\n", "                        ", "sno3", ",", " ", 
                    "sno4", ",", " ", "rayslot", ",", " ", "generationnumber",
                     ",", " ", "\n", "                        ", 
                    "intersectionnumber", ",", " ", "pol1", ",", " ", "pol2", 
                    ",", " ", "pol3"}], "}"}]}], ";", " ", "\n", 
                    "                      ", 
                    RowBox[{
                    "componentnumber", " ", "=", " ", "newcomponentnumber"}], 
                    ";", " ", "\n", "                      ", 
                    RowBox[{
                    "surfacenumber", " ", "=", " ", "newsurfacenumber"}], ";",
                     " ", 
                    RowBox[{
                    "surfaceid", " ", "=", " ", "\n", 
                    "                       ", "newsurfaceid"}], ";", " ", 
                    RowBox[{"originalray", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "\n", "                        ", "rey", ",", 
                    " ", "rez", ",", " ", "r1", ",", " ", "r2", ",", " ", 
                    "r3", ",", " ", "r4", ",", " ", "r5", ",", " ", "r6", ",",
                     " ", "r7", ",", " ", "r8", ",", " ", "r9", ",", " ", 
                    "\n", "                        ", "wavelength", ",", " ", 
                    "intensity", ",", " ", "intensityscale", ",", " ", "ray1",
                     ",", " ", "\n", "                        ", "index", ",",
                     " ", "opticallength", ",", " ", "phaseshift", ",", " ", 
                    "\n", "                        ", "componentnumber", ",", 
                    " ", "surfacenumber", ",", " ", "surfaceid", ",", " ", 
                    "ray2", ",", " ", "\n", "                        ", 
                    "ray3", ",", " ", "sid", ",", " ", "frontid", ",", " ", 
                    "sno1", ",", " ", "sno2", ",", " ", "sno3", ",", " ", 
                    "sno4", ",", " ", "\n", "                        ", 
                    "rayslot", ",", " ", "generationnumber", ",", " ", 
                    "intersectionnumber", ",", " ", "\n", 
                    "                        ", "pol1", ",", " ", "pol2", ",",
                     " ", "pol3"}], "}"}]}], ";", " ", 
                    RowBox[{"intensity", " ", "=", " ", "0."}], ";", " ", 
                    "\n", "                      ", 
                    RowBox[{"allcreatedrays", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "rez", ",", " ", "\n", 
                    "                        ", "r1", ",", " ", "r2", ",", 
                    " ", "r3", ",", " ", "r4", ",", " ", "r5", ",", " ", "r6",
                     ",", " ", "r7", ",", " ", "r8", ",", " ", "r9", ",", " ",
                     "wavelength", ",", " ", "\n", "                        ",
                     "intensity", ",", " ", "intensityscale", ",", " ", 
                    "ray1", ",", " ", "index", ",", " ", "\n", 
                    "                        ", "opticallength", ",", " ", 
                    "phaseshift", ",", " ", "componentnumber", ",", " ", "\n",
                     "                        ", "surfacenumber", ",", " ", 
                    "surfaceid", ",", " ", "ray2", ",", " ", "ray3", ",", " ",
                     "sid", ",", " ", "\n", "                        ", 
                    "frontid", ",", " ", "sno1", ",", " ", "sno2", ",", " ", 
                    "sno3", ",", " ", "sno4", ",", " ", "rayslot", ",", " ", 
                    "\n", "                        ", "generationnumber", ",",
                     " ", "intersectionnumber", ",", " ", "pol1", ",", " ", 
                    "\n", "                        ", "pol2", ",", " ", 
                    "pol3"}], "}"}], "}"}]}]}], ")"}], ";", " ", 
                    RowBox[{"{", 
                    RowBox[{"allcreatedrays", ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "\n", 
                    "                        ", "1.", ",", " ", "1.", ",", 
                    " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.",
                     ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ",
                     "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "\n", 
                    "                        ", "1.", ",", " ", 
                    RowBox[{"-", "9.87654321*^8"}], ",", " ", "1.", ",", " ", 
                    "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "0.", ",",
                     " ", 
                    RowBox[{"-", "1."}], ",", " ", "\n", 
                    "                        ", 
                    RowBox[{"-", "1."}], ",", " ", 
                    RowBox[{"-", "1."}], ",", " ", "1.", ",", " ", "1.", ",", 
                    " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.",
                     ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ",
                     "\n", "                        ", "1.", ",", " ", "1.", 
                    ",", " ", "1.", ",", " ", "1.", ",", " ", "1."}], "}"}], 
                    "}"}], ",", " ", 
                    RowBox[{"{", "completedray", "}"}]}], "}"}]}], ",", " ", 
                    "\n", "                    ", 
                    RowBox[{"resonatenumber", " ", "==", " ", "5"}], ",", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "rez", ",", " ", "\n", 
                    "                       ", "r1", ",", " ", "r2", ",", " ",
                     "r3", ",", " ", "r4", ",", " ", "r5", ",", " ", "r6", 
                    ",", " ", "r7", ",", " ", "r8", ",", " ", "r9", ",", " ", 
                    "wavelength", ",", " ", "\n", "                       ", 
                    "intensity", ",", " ", "intensityscale", ",", " ", "ray1",
                     ",", " ", "index", ",", " ", "\n", 
                    "                       ", "opticallength", ",", " ", 
                    "phaseshift", ",", " ", "componentnumber", ",", " ", "\n",
                     "                       ", "surfacenumber", ",", " ", 
                    "surfaceid", ",", " ", "ray2", ",", " ", "ray3", ",", " ",
                     "sid", ",", " ", "\n", "                       ", 
                    "frontid", ",", " ", "sno1", ",", " ", "sno2", ",", " ", 
                    "sno3", ",", " ", "sno4", ",", " ", "rayslot", ",", " ", 
                    "\n", "                       ", "oldgenerationnumber", 
                    ",", " ", "intersectionnumber", ",", " ", "pol1", ",", 
                    " ", "\n", "                       ", "pol2", ",", " ", 
                    "pol3"}], "}"}], " ", "=", " ", "#1"}], ";", " ", 
                    RowBox[{"index1", " ", "=", " ", "index"}], ";", " ", 
                    RowBox[{"xunit", " ", "=", " ", "r3"}], ";", " ", "\n", 
                    "                     ", 
                    RowBox[{"yunit", " ", "=", " ", "r2"}], ";", " ", 
                    RowBox[{"zunit", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"-", "1."}], "*", "r1"}]}], ";", " ", 
                    RowBox[{"xunit", " ", "=", " ", 
                    RowBox[{"Chop", "[", "xunit", "]"}]}], ";", " ", "\n", 
                    "                     ", 
                    RowBox[{"yunit", " ", "=", " ", 
                    RowBox[{"Chop", "[", "yunit", "]"}]}], ";", " ", 
                    RowBox[{"zunit", " ", "=", " ", 
                    RowBox[{"Chop", "[", "zunit", "]"}]}], ";", " ", "\n", 
                    "                     ", 
                    RowBox[{"magnitude", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"xunit", "^", "2"}], " ", "+", " ", 
                    RowBox[{"yunit", "^", "2"}], " ", "+", " ", 
                    RowBox[{"zunit", "^", "2"}]}], ")"}], "^", 
                    RowBox[{"2", "^", 
                    RowBox[{"(", 
                    RowBox[{"-", "1"}], ")"}]}]}]}], ";", " ", "\n", 
                    "                     ", 
                    RowBox[{"xunit", " ", "=", " ", 
                    RowBox[{"xunit", "/", "magnitude"}]}], ";", " ", 
                    RowBox[{"yunit", " ", "=", " ", 
                    RowBox[{"yunit", "/", "magnitude"}]}], ";", " ", "\n", 
                    "                     ", 
                    RowBox[{"zunit", " ", "=", " ", 
                    RowBox[{"zunit", "/", "magnitude"}]}], ";", " ", 
                    RowBox[{"rx", " ", "=", " ", 
                    RowBox[{"100.", " ", "+", " ", "rez"}]}], ";", " ", 
                    RowBox[{"ry", " ", "=", " ", "rey"}], ";", " ", "\n", 
                    "                     ", 
                    RowBox[{"rz", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"-", "1."}], "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "100."}], " ", "+", " ", "rex"}], ")"}]}]}], 
                    ";", " ", 
                    RowBox[{"rx", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rx", "]"}]}], ";", " ", 
                    RowBox[{
                    "ry", " ", "=", " ", "\n", "                      ", 
                    RowBox[{"Chop", "[", "ry", "]"}]}], ";", " ", 
                    RowBox[{"rz", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rz", "]"}]}], ";", " ", 
                    RowBox[{
                    "terminatedeflection", " ", "=", " ", "\n", 
                    "                      ", "False"}], ";", " ", 
                    RowBox[{"intersections", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}], "}"}]}], ";", " ", "\n", "                     ", 
                    RowBox[{
                    "intersections", " ", "=", " ", "resonateintersections"}],
                     ";", " ", 
                    RowBox[{
                    "holeQ", " ", "=", " ", "\n", "                      ", 
                    RowBox[{
                    RowBox[{"holeQlist", "[", 
                    RowBox[{"[", "resonatenumber", "]"}], "]"}], " ", "==", 
                    " ", "1"}]}], ";", " ", "\n", "                     ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "newcomponentnumber", ",", " ", "newsurfacenumber", ",", 
                    " ", "\n", "                       ", "newsurfaceid"}], 
                    "}"}], " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"2.", ",", " ", "5.", ",", " ", "92444."}], 
                    "}"}]}], ";", " ", "\n", "                     ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "componentnumber", ",", " ", "surfacenumber", ",", " ", 
                    "surfaceid"}], "}"}], " ", "=", " ", "\n", 
                    "                      ", 
                    RowBox[{"{", 
                    RowBox[{"2.", ",", " ", "5.", ",", " ", "92444."}], 
                    "}"}]}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"ray1", ",", " ", "ray2", ",", " ", "ray3"}], 
                    "}"}], " ", "=", " ", "\n", "                      ", 
                    RowBox[{"intersections", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], ";", " ", 
                    RowBox[{"rsx", " ", "=", " ", "rex"}], ";", " ", 
                    RowBox[{"rsy", " ", "=", " ", "rey"}], ";", " ", "\n", 
                    "                     ", 
                    RowBox[{"rsz", " ", "=", " ", "rez"}], ";", " ", 
                    RowBox[{"rxhlp", " ", "=", " ", 
                    RowBox[{"rx", " ", "+", " ", 
                    RowBox[{"ray1", "*", "xunit"}]}]}], ";", " ", 
                    RowBox[{
                    "ryhlp", " ", "=", " ", "\n", "                      ", 
                    RowBox[{"ry", " ", "+", " ", 
                    RowBox[{"ray1", "*", "yunit"}]}]}], ";", " ", 
                    RowBox[{"rzhlp", " ", "=", " ", 
                    RowBox[{"rz", " ", "+", " ", 
                    RowBox[{"ray1", "*", "zunit"}]}]}], ";", " ", "\n", 
                    "                     ", 
                    RowBox[{"rex", " ", "=", " ", 
                    RowBox[{"100.", " ", "-", " ", 
                    RowBox[{"1.", "*", "rzhlp"}]}]}], ";", " ", 
                    RowBox[{"rey", " ", "=", " ", "ryhlp"}], ";", " ", 
                    RowBox[{"rez", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"-", "100."}], " ", "+", " ", "\n", 
                    "                       ", "rxhlp"}]}], ";", " ", 
                    RowBox[{"rex", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rex", "]"}]}], ";", " ", 
                    RowBox[{"rey", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rey", "]"}]}], ";", " ", "\n", 
                    "                     ", 
                    RowBox[{"rez", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rez", "]"}]}], ";", " ", 
                    RowBox[{
                    "intersectionnumber", " ", "=", " ", "\n", 
                    "                      ", 
                    RowBox[{"intersectionnumber", " ", "+", " ", "1."}]}], 
                    ";", " ", 
                    RowBox[{
                    "opticallength", " ", "=", " ", "\n", 
                    "                      ", 
                    RowBox[{"opticallength", " ", "+", " ", 
                    RowBox[{"ray1", "*", "index1"}]}]}], ";", " ", 
                    RowBox[{
                    "completedray", " ", "=", " ", "\n", 
                    "                      ", 
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "rez", ",", " ", "r1", ",", 
                    " ", "r2", ",", " ", "r3", ",", " ", "r4", ",", " ", "r5",
                     ",", " ", "\n", "                       ", "r6", ",", 
                    " ", "r7", ",", " ", "r8", ",", " ", "r9", ",", " ", 
                    "wavelength", ",", " ", "intensity", ",", " ", "\n", 
                    "                       ", "intensityscale", ",", " ", 
                    "ray1", ",", " ", "index", ",", " ", "opticallength", ",",
                     " ", "\n", "                       ", "phaseshift", ",", 
                    " ", "componentnumber", ",", " ", "surfacenumber", ",", 
                    " ", "\n", "                       ", "surfaceid", ",", 
                    " ", "ray2", ",", " ", "ray3", ",", " ", "sid", ",", " ", 
                    "frontid", ",", " ", "sno1", ",", " ", "sno2", ",", " ", 
                    "\n", "                       ", "sno3", ",", " ", "sno4",
                     ",", " ", "rayslot", ",", " ", "generationnumber", ",", 
                    " ", "\n", "                       ", 
                    "intersectionnumber", ",", " ", "pol1", ",", " ", "pol2", 
                    ",", " ", "pol3"}], "}"}]}], ";", " ", "\n", 
                    "                     ", 
                    RowBox[{"reportedrayspresent", " ", "=", " ", "True"}], 
                    ";", " ", 
                    RowBox[{
                    "intersectionspresent", " ", "=", " ", "\n", 
                    "                      ", "True"}], ";", " ", 
                    RowBox[{"deflectedrayspresent", " ", "=", " ", "True"}], 
                    ";", " ", "\n", "                     ", 
                    RowBox[{
                    "localdummyoutrayspresent", " ", "=", " ", "True"}], ";", 
                    " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    "surfnorm", " ", "=", " ", "\n", 
                    "                       ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"1.", ",", " ", "0.", ",", " ", "0."}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "1.", ",", " ", "0."}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "0.", ",", " ", "0.", ",", " ", "\n", 
                    "                        ", "1."}], "}"}]}], "}"}], 
                    "]"}]}]}], ";", " ", 
                    RowBox[{"dummymatrix", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "0.", ",", " ", 
                    RowBox[{"-", "1."}]}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "0.", ",", " ", "1.", ",", " ", "\n", 
                    "                        ", "0."}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"1.", ",", " ", "0.", ",", " ", "0."}], "}"}]}], 
                    "}"}], " ", ".", " ", "#1"}], " ", "&"}], " ", ")"}], " ",
                     "/@", " ", "surfnorm"}]}], ";", " ", "\n", 
                    "                      ", 
                    RowBox[{"surfnorm", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"#1", "/", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"#1", " ", ".", " ", "#1"}], "]"}]}], " ", "&"}], 
                    " ", ")"}], " ", "/@", " ", "dummymatrix"}]}], ";", " ", 
                    "\n", "                      ", 
                    RowBox[{"surfacerotationmatrix", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0", ",", " ", "0", ",", " ", "1."}], "}"}], ",", 
                    " ", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", " ", "1.", ",", " ", "0"}], "}"}], ",", 
                    " ", "\n", "                        ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0", ",", " ", "0"}], 
                    "}"}]}], "}"}]}], ";", " ", 
                    RowBox[{
                    "surfacetranslationvector", " ", "=", " ", "\n", 
                    "                       ", 
                    RowBox[{"{", 
                    RowBox[{"100.", ",", " ", "0", ",", " ", 
                    RowBox[{"-", "100."}]}], "}"}]}], ";", " ", 
                    RowBox[{"activeregion", " ", "=", " ", "0."}], ";", " ", 
                    "\n", "                      ", 
                    RowBox[{"completedray", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "rez", ",", " ", "r1", ",", 
                    " ", "\n", "                        ", "r2", ",", " ", 
                    "r3", ",", " ", "r4", ",", " ", "r5", ",", " ", "r6", ",",
                     " ", "r7", ",", " ", "r8", ",", " ", "r9", ",", " ", 
                    "wavelength", ",", " ", "\n", "                        ", 
                    "intensity", ",", " ", "intensityscale", ",", " ", "ray1",
                     ",", " ", "index", ",", " ", "\n", 
                    "                        ", "opticallength", ",", " ", 
                    "phaseshift", ",", " ", "componentnumber", ",", " ", "\n",
                     "                        ", "surfacenumber", ",", " ", 
                    "surfaceid", ",", " ", "ray2", ",", " ", "ray3", ",", " ",
                     "sid", ",", " ", "\n", "                        ", 
                    "frontid", ",", " ", "sno1", ",", " ", "sno2", ",", " ", 
                    "sno3", ",", " ", "sno4", ",", " ", "rayslot", ",", " ", 
                    "\n", "                        ", "generationnumber", ",",
                     " ", "intersectionnumber", ",", " ", "pol1", ",", " ", 
                    "\n", "                        ", "pol2", ",", " ", 
                    "pol3"}], "}"}]}], ";", " ", 
                    RowBox[{
                    "componentnumber", " ", "=", " ", "\n", 
                    "                       ", "newcomponentnumber"}], ";", 
                    " ", 
                    RowBox[{
                    "surfacenumber", " ", "=", " ", "\n", 
                    "                       ", "newsurfacenumber"}], ";", " ", 
                    RowBox[{"surfaceid", " ", "=", " ", "newsurfaceid"}], ";",
                     " ", "\n", "                      ", 
                    RowBox[{"originalray", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "rez", ",", " ", "r1", ",", 
                    " ", "\n", "                        ", "r2", ",", " ", 
                    "r3", ",", " ", "r4", ",", " ", "r5", ",", " ", "r6", ",",
                     " ", "r7", ",", " ", "r8", ",", " ", "r9", ",", " ", 
                    "wavelength", ",", " ", "\n", "                        ", 
                    "intensity", ",", " ", "intensityscale", ",", " ", "ray1",
                     ",", " ", "index", ",", " ", "\n", 
                    "                        ", "opticallength", ",", " ", 
                    "phaseshift", ",", " ", "componentnumber", ",", " ", "\n",
                     "                        ", "surfacenumber", ",", " ", 
                    "surfaceid", ",", " ", "ray2", ",", " ", "ray3", ",", " ",
                     "sid", ",", " ", "\n", "                        ", 
                    "frontid", ",", " ", "sno1", ",", " ", "sno2", ",", " ", 
                    "sno3", ",", " ", "sno4", ",", " ", "rayslot", ",", " ", 
                    "\n", "                        ", "generationnumber", ",",
                     " ", "intersectionnumber", ",", " ", "pol1", ",", " ", 
                    "\n", "                        ", "pol2", ",", " ", 
                    "pol3"}], "}"}]}], ";", " ", 
                    RowBox[{"intensity", " ", "=", " ", "0."}], ";", " ", 
                    RowBox[{
                    "allcreatedrays", " ", "=", " ", "\n", 
                    "                       ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "rez", ",", " ", "r1", ",", 
                    " ", "r2", ",", " ", "r3", ",", " ", "r4", ",", " ", "\n",
                     "                        ", "r5", ",", " ", "r6", ",", 
                    " ", "r7", ",", " ", "r8", ",", " ", "r9", ",", " ", 
                    "wavelength", ",", " ", "intensity", ",", " ", "\n", 
                    "                        ", "intensityscale", ",", " ", 
                    "ray1", ",", " ", "index", ",", " ", "opticallength", ",",
                     " ", "\n", "                        ", "phaseshift", ",",
                     " ", "componentnumber", ",", " ", "surfacenumber", ",", 
                    " ", "\n", "                        ", "surfaceid", ",", 
                    " ", "ray2", ",", " ", "ray3", ",", " ", "sid", ",", " ", 
                    "frontid", ",", " ", "sno1", ",", " ", "sno2", ",", " ", 
                    "\n", "                        ", "sno3", ",", " ", 
                    "sno4", ",", " ", "rayslot", ",", " ", "generationnumber",
                     ",", " ", "\n", "                        ", 
                    "intersectionnumber", ",", " ", "pol1", ",", " ", "pol2", 
                    ",", " ", "pol3"}], "}"}], "}"}]}]}], ")"}], ";", " ", 
                    "\n", "                     ", 
                    RowBox[{"{", 
                    RowBox[{"allcreatedrays", ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",",
                     " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", 
                    "1.", ",", " ", "\n", "                        ", "1.", 
                    ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", 
                    "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",",
                     " ", 
                    RowBox[{"-", "9.87654321*^8"}], ",", " ", "\n", 
                    "                        ", "1.", ",", " ", "1.", ",", 
                    " ", "1.", ",", " ", "1.", ",", " ", "0.", ",", " ", 
                    RowBox[{"-", "1."}], ",", " ", 
                    RowBox[{"-", "1."}], ",", " ", 
                    RowBox[{"-", "1."}], ",", " ", "1.", ",", " ", "1.", ",", 
                    " ", "1.", ",", " ", "\n", "                        ", 
                    "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",",
                     " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", 
                    "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1."}], 
                    "}"}], "}"}], ",", " ", "\n", "                      ", 
                    RowBox[{"{", "completedray", "}"}]}], "}"}]}], ",", " ", 
                    RowBox[{"resonatenumber", " ", "==", " ", "6"}], ",", " ",
                     "\n", "                    ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "rez", ",", " ", "r1", ",", 
                    " ", "r2", ",", " ", "r3", ",", " ", "r4", ",", " ", "r5",
                     ",", " ", "\n", "                       ", "r6", ",", 
                    " ", "r7", ",", " ", "r8", ",", " ", "r9", ",", " ", 
                    "wavelength", ",", " ", "intensity", ",", " ", "\n", 
                    "                       ", "intensityscale", ",", " ", 
                    "ray1", ",", " ", "index", ",", " ", "opticallength", ",",
                     " ", "\n", "                       ", "phaseshift", ",", 
                    " ", "componentnumber", ",", " ", "surfacenumber", ",", 
                    " ", "\n", "                       ", "surfaceid", ",", 
                    " ", "ray2", ",", " ", "ray3", ",", " ", "sid", ",", " ", 
                    "frontid", ",", " ", "sno1", ",", " ", "sno2", ",", " ", 
                    "\n", "                       ", "sno3", ",", " ", "sno4",
                     ",", " ", "rayslot", ",", " ", "oldgenerationnumber", 
                    ",", " ", "\n", "                       ", 
                    "intersectionnumber", ",", " ", "pol1", ",", " ", "pol2", 
                    ",", " ", "pol3"}], "}"}], " ", "=", " ", "#1"}], ";", 
                    " ", "\n", "                     ", 
                    RowBox[{"index1", " ", "=", " ", "index"}], ";", " ", 
                    RowBox[{"xunit", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"-", "1."}], "*", "r3"}]}], ";", " ", 
                    RowBox[{"yunit", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"-", "1."}], "*", "r2"}]}], ";", " ", "\n", 
                    "                     ", 
                    RowBox[{"zunit", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"-", "1."}], "*", "r1"}]}], ";", " ", 
                    RowBox[{"xunit", " ", "=", " ", 
                    RowBox[{"Chop", "[", "xunit", "]"}]}], ";", " ", 
                    RowBox[{
                    "yunit", " ", "=", " ", "\n", "                      ", 
                    RowBox[{"Chop", "[", "yunit", "]"}]}], ";", " ", 
                    RowBox[{"zunit", " ", "=", " ", 
                    RowBox[{"Chop", "[", "zunit", "]"}]}], ";", " ", 
                    RowBox[{
                    "magnitude", " ", "=", " ", "\n", 
                    "                      ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"xunit", "^", "2"}], " ", "+", " ", 
                    RowBox[{"yunit", "^", "2"}], " ", "+", " ", 
                    RowBox[{"zunit", "^", "2"}]}], ")"}], "^", 
                    RowBox[{"2", "^", 
                    RowBox[{"(", 
                    RowBox[{"-", "1"}], ")"}]}]}]}], ";", " ", 
                    RowBox[{
                    "xunit", " ", "=", " ", "\n", "                      ", 
                    RowBox[{"xunit", "/", "magnitude"}]}], ";", " ", 
                    RowBox[{"yunit", " ", "=", " ", 
                    RowBox[{"yunit", "/", "magnitude"}]}], ";", " ", "\n", 
                    "                     ", 
                    RowBox[{"zunit", " ", "=", " ", 
                    RowBox[{"zunit", "/", "magnitude"}]}], ";", " ", 
                    RowBox[{"rx", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"-", "1."}], "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "100."}], " ", "+", " ", "rez"}], ")"}]}]}], 
                    ";", " ", "\n", "                     ", 
                    RowBox[{"ry", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"-", "1."}], "*", "rey"}]}], ";", " ", 
                    RowBox[{"rz", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"-", "1."}], "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "100."}], " ", "+", " ", "rex"}], ")"}]}]}], 
                    ";", " ", 
                    RowBox[{
                    "rx", " ", "=", " ", "\n", "                      ", 
                    RowBox[{"Chop", "[", "rx", "]"}]}], ";", " ", 
                    RowBox[{"ry", " ", "=", " ", 
                    RowBox[{"Chop", "[", "ry", "]"}]}], ";", " ", 
                    RowBox[{"rz", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rz", "]"}]}], ";", " ", "\n", 
                    "                     ", 
                    RowBox[{"terminatedeflection", " ", "=", " ", "False"}], 
                    ";", " ", 
                    RowBox[{
                    "intersections", " ", "=", " ", "\n", 
                    "                      ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}], "}"}]}], ";", " ", 
                    RowBox[{"intersections", " ", "=", " ", "\n", 
                    "                      ", "resonateintersections"}], ";", 
                    " ", 
                    RowBox[{"holeQ", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"holeQlist", "[", 
                    RowBox[{
                    "[", "\n", "                        ", "resonatenumber", 
                    "]"}], "]"}], " ", "==", " ", "1"}]}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "newcomponentnumber", ",", " ", "\n", 
                    "                       ", "newsurfacenumber", ",", " ", 
                    "newsurfaceid"}], "}"}], " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "2.", ",", " ", "6.", ",", " ", "\n", 
                    "                       ", "92445."}], "}"}]}], ";", " ", 
                    
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "componentnumber", ",", " ", "surfacenumber", ",", " ", 
                    "\n", "                       ", "surfaceid"}], "}"}], 
                    " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"2.", ",", " ", "6.", ",", " ", "92445."}], 
                    "}"}]}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "ray1", ",", " ", "ray2", ",", " ", "\n", 
                    "                       ", "ray3"}], "}"}], " ", "=", " ", 
                    RowBox[{"intersections", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], ";", " ", 
                    RowBox[{"rsx", " ", "=", " ", "rex"}], ";", " ", 
                    RowBox[{"rsy", " ", "=", " ", "rey"}], ";", " ", "\n", 
                    "                     ", 
                    RowBox[{"rsz", " ", "=", " ", "rez"}], ";", " ", 
                    RowBox[{"rxhlp", " ", "=", " ", 
                    RowBox[{"rx", " ", "+", " ", 
                    RowBox[{"ray1", "*", "xunit"}]}]}], ";", " ", 
                    RowBox[{
                    "ryhlp", " ", "=", " ", "\n", "                      ", 
                    RowBox[{"ry", " ", "+", " ", 
                    RowBox[{"ray1", "*", "yunit"}]}]}], ";", " ", 
                    RowBox[{"rzhlp", " ", "=", " ", 
                    RowBox[{"rz", " ", "+", " ", 
                    RowBox[{"ray1", "*", "zunit"}]}]}], ";", " ", "\n", 
                    "                     ", 
                    RowBox[{"rex", " ", "=", " ", 
                    RowBox[{"100.", " ", "-", " ", 
                    RowBox[{"1.", "*", "rzhlp"}]}]}], ";", " ", 
                    RowBox[{"rey", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"-", "1."}], "*", "ryhlp"}]}], ";", " ", 
                    RowBox[{
                    "rez", " ", "=", " ", "\n", "                      ", 
                    RowBox[{"100.", " ", "-", " ", 
                    RowBox[{"1.", "*", "rxhlp"}]}]}], ";", " ", 
                    RowBox[{"rex", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rex", "]"}]}], ";", " ", 
                    RowBox[{"rey", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rey", "]"}]}], ";", " ", "\n", 
                    "                     ", 
                    RowBox[{"rez", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rez", "]"}]}], ";", " ", 
                    RowBox[{
                    "intersectionnumber", " ", "=", " ", "\n", 
                    "                      ", 
                    RowBox[{"intersectionnumber", " ", "+", " ", "1."}]}], 
                    ";", " ", 
                    RowBox[{
                    "opticallength", " ", "=", " ", "\n", 
                    "                      ", 
                    RowBox[{"opticallength", " ", "+", " ", 
                    RowBox[{"ray1", "*", "index1"}]}]}], ";", " ", 
                    RowBox[{
                    "completedray", " ", "=", " ", "\n", 
                    "                      ", 
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "rez", ",", " ", "r1", ",", 
                    " ", "r2", ",", " ", "r3", ",", " ", "r4", ",", " ", "r5",
                     ",", " ", "\n", "                       ", "r6", ",", 
                    " ", "r7", ",", " ", "r8", ",", " ", "r9", ",", " ", 
                    "wavelength", ",", " ", "intensity", ",", " ", "\n", 
                    "                       ", "intensityscale", ",", " ", 
                    "ray1", ",", " ", "index", ",", " ", "opticallength", ",",
                     " ", "\n", "                       ", "phaseshift", ",", 
                    " ", "componentnumber", ",", " ", "surfacenumber", ",", 
                    " ", "\n", "                       ", "surfaceid", ",", 
                    " ", "ray2", ",", " ", "ray3", ",", " ", "sid", ",", " ", 
                    "frontid", ",", " ", "sno1", ",", " ", "sno2", ",", " ", 
                    "\n", "                       ", "sno3", ",", " ", "sno4",
                     ",", " ", "rayslot", ",", " ", "generationnumber", ",", 
                    " ", "\n", "                       ", 
                    "intersectionnumber", ",", " ", "pol1", ",", " ", "pol2", 
                    ",", " ", "pol3"}], "}"}]}], ";", " ", "\n", 
                    "                     ", 
                    RowBox[{"reportedrayspresent", " ", "=", " ", "True"}], 
                    ";", " ", 
                    RowBox[{
                    "intersectionspresent", " ", "=", " ", "\n", 
                    "                      ", "True"}], ";", " ", 
                    RowBox[{"deflectedrayspresent", " ", "=", " ", "True"}], 
                    ";", " ", "\n", "                     ", 
                    RowBox[{
                    "localdummyoutrayspresent", " ", "=", " ", "True"}], ";", 
                    " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    "surfnorm", " ", "=", " ", "\n", 
                    "                       ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"1.", ",", " ", "0.", ",", " ", "0."}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "1.", ",", " ", "0."}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "0.", ",", " ", "0.", ",", " ", "\n", 
                    "                        ", "1."}], "}"}]}], "}"}], 
                    "]"}]}]}], ";", " ", 
                    RowBox[{"dummymatrix", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "0.", ",", " ", 
                    RowBox[{"-", "1."}]}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", 
                    RowBox[{"-", "1."}], ",", " ", "\n", 
                    "                        ", "0."}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}]}], "}"}], " ", ".", " ", "#1"}], " ", "&"}], " ", 
                    ")"}], " ", "/@", " ", "surfnorm"}]}], ";", " ", "\n", 
                    "                      ", 
                    RowBox[{"surfnorm", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"#1", "/", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"#1", " ", ".", " ", "#1"}], "]"}]}], " ", "&"}], 
                    " ", ")"}], " ", "/@", " ", "dummymatrix"}]}], ";", " ", 
                    "\n", "                      ", 
                    RowBox[{"surfacerotationmatrix", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0", ",", " ", "0", ",", " ", 
                    RowBox[{"-", "1."}]}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", " ", 
                    RowBox[{"-", "1."}], ",", " ", "0"}], "}"}], ",", " ", 
                    "\n", "                        ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0", ",", " ", "0"}], 
                    "}"}]}], "}"}]}], ";", " ", 
                    RowBox[{
                    "surfacetranslationvector", " ", "=", " ", "\n", 
                    "                       ", 
                    RowBox[{"{", 
                    RowBox[{"100.", ",", " ", "0", ",", " ", "100."}], 
                    "}"}]}], ";", " ", 
                    RowBox[{"activeregion", " ", "=", " ", "0."}], ";", " ", 
                    "\n", "                      ", 
                    RowBox[{"completedray", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "rez", ",", " ", "r1", ",", 
                    " ", "\n", "                        ", "r2", ",", " ", 
                    "r3", ",", " ", "r4", ",", " ", "r5", ",", " ", "r6", ",",
                     " ", "r7", ",", " ", "r8", ",", " ", "r9", ",", " ", 
                    "wavelength", ",", " ", "\n", "                        ", 
                    "intensity", ",", " ", "intensityscale", ",", " ", "ray1",
                     ",", " ", "index", ",", " ", "\n", 
                    "                        ", "opticallength", ",", " ", 
                    "phaseshift", ",", " ", "componentnumber", ",", " ", "\n",
                     "                        ", "surfacenumber", ",", " ", 
                    "surfaceid", ",", " ", "ray2", ",", " ", "ray3", ",", " ",
                     "sid", ",", " ", "\n", "                        ", 
                    "frontid", ",", " ", "sno1", ",", " ", "sno2", ",", " ", 
                    "sno3", ",", " ", "sno4", ",", " ", "rayslot", ",", " ", 
                    "\n", "                        ", "generationnumber", ",",
                     " ", "intersectionnumber", ",", " ", "pol1", ",", " ", 
                    "\n", "                        ", "pol2", ",", " ", 
                    "pol3"}], "}"}]}], ";", " ", 
                    RowBox[{
                    "componentnumber", " ", "=", " ", "\n", 
                    "                       ", "newcomponentnumber"}], ";", 
                    " ", 
                    RowBox[{
                    "surfacenumber", " ", "=", " ", "\n", 
                    "                       ", "newsurfacenumber"}], ";", " ", 
                    RowBox[{"surfaceid", " ", "=", " ", "newsurfaceid"}], ";",
                     " ", "\n", "                      ", 
                    RowBox[{"originalray", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "rez", ",", " ", "r1", ",", 
                    " ", "\n", "                        ", "r2", ",", " ", 
                    "r3", ",", " ", "r4", ",", " ", "r5", ",", " ", "r6", ",",
                     " ", "r7", ",", " ", "r8", ",", " ", "r9", ",", " ", 
                    "wavelength", ",", " ", "\n", "                        ", 
                    "intensity", ",", " ", "intensityscale", ",", " ", "ray1",
                     ",", " ", "index", ",", " ", "\n", 
                    "                        ", "opticallength", ",", " ", 
                    "phaseshift", ",", " ", "componentnumber", ",", " ", "\n",
                     "                        ", "surfacenumber", ",", " ", 
                    "surfaceid", ",", " ", "ray2", ",", " ", "ray3", ",", " ",
                     "sid", ",", " ", "\n", "                        ", 
                    "frontid", ",", " ", "sno1", ",", " ", "sno2", ",", " ", 
                    "sno3", ",", " ", "sno4", ",", " ", "rayslot", ",", " ", 
                    "\n", "                        ", "generationnumber", ",",
                     " ", "intersectionnumber", ",", " ", "pol1", ",", " ", 
                    "\n", "                        ", "pol2", ",", " ", 
                    "pol3"}], "}"}]}], ";", " ", 
                    RowBox[{"intensity", " ", "=", " ", "0."}], ";", " ", 
                    RowBox[{
                    "allcreatedrays", " ", "=", " ", "\n", 
                    "                       ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "rez", ",", " ", "r1", ",", 
                    " ", "r2", ",", " ", "r3", ",", " ", "r4", ",", " ", "\n",
                     "                        ", "r5", ",", " ", "r6", ",", 
                    " ", "r7", ",", " ", "r8", ",", " ", "r9", ",", " ", 
                    "wavelength", ",", " ", "intensity", ",", " ", "\n", 
                    "                        ", "intensityscale", ",", " ", 
                    "ray1", ",", " ", "index", ",", " ", "opticallength", ",",
                     " ", "\n", "                        ", "phaseshift", ",",
                     " ", "componentnumber", ",", " ", "surfacenumber", ",", 
                    " ", "\n", "                        ", "surfaceid", ",", 
                    " ", "ray2", ",", " ", "ray3", ",", " ", "sid", ",", " ", 
                    "frontid", ",", " ", "sno1", ",", " ", "sno2", ",", " ", 
                    "\n", "                        ", "sno3", ",", " ", 
                    "sno4", ",", " ", "rayslot", ",", " ", "generationnumber",
                     ",", " ", "\n", "                        ", 
                    "intersectionnumber", ",", " ", "pol1", ",", " ", "pol2", 
                    ",", " ", "pol3"}], "}"}], "}"}]}]}], ")"}], ";", " ", 
                    "\n", "                     ", 
                    RowBox[{"{", 
                    RowBox[{"allcreatedrays", ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",",
                     " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", 
                    "1.", ",", " ", "\n", "                        ", "1.", 
                    ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", 
                    "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",",
                     " ", 
                    RowBox[{"-", "9.87654321*^8"}], ",", " ", "\n", 
                    "                        ", "1.", ",", " ", "1.", ",", 
                    " ", "1.", ",", " ", "1.", ",", " ", "0.", ",", " ", 
                    RowBox[{"-", "1."}], ",", " ", 
                    RowBox[{"-", "1."}], ",", " ", 
                    RowBox[{"-", "1."}], ",", " ", "1.", ",", " ", "1.", ",", 
                    " ", "1.", ",", " ", "\n", "                        ", 
                    "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",",
                     " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", 
                    "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1."}], 
                    "}"}], "}"}], ",", " ", "\n", "                      ", 
                    RowBox[{"{", "completedray", "}"}]}], "}"}]}], ",", " ", 
                    "True", ",", " ", 
                    RowBox[{
                    RowBox[{
                    "deflecteddummyrayspresent", " ", "=", " ", "\n", 
                    "                      ", "True"}], ";", " ", 
                    RowBox[{
                    "reporteddummyrayspresent", " ", "=", " ", "True"}], ";", 
                    " ", "\n", "                     ", 
                    RowBox[{"localoutrayspresent", " ", "=", " ", "True"}], 
                    ";", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",",
                     " ", "1.", ",", " ", "\n", "                        ", 
                    "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",",
                     " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", 
                    "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",",
                     " ", "\n", "                        ", 
                    RowBox[{"-", "9.87654321*^8"}], ",", " ", "1.", ",", " ", 
                    "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "0.", ",",
                     " ", 
                    RowBox[{"-", "1."}], ",", " ", 
                    RowBox[{"-", "1."}], ",", " ", "\n", 
                    "                        ", 
                    RowBox[{"-", "1."}], ",", " ", "1.", ",", " ", "1.", ",", 
                    " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.",
                     ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ",
                     "1.", ",", " ", "1.", ",", " ", "\n", 
                    "                        ", "1.", ",", " ", "1.", ",", 
                    " ", "1."}], "}"}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "rez", ",", " ", "\n", 
                    "                        ", "r1", ",", " ", "r2", ",", 
                    " ", "r3", ",", " ", "r4", ",", " ", "r5", ",", " ", "r6",
                     ",", " ", "r7", ",", " ", "r8", ",", " ", "r9", ",", " ",
                     "wavelength", ",", " ", "\n", "                        ",
                     "intensity", ",", " ", "intensityscale", ",", " ", 
                    "ray1", ",", " ", "index", ",", " ", "\n", 
                    "                        ", "opticallength", ",", " ", 
                    "phaseshift", ",", " ", "componentnumber", ",", " ", "\n",
                     "                        ", "surfacenumber", ",", " ", 
                    "surfaceid", ",", " ", "ray2", ",", " ", "ray3", ",", " ",
                     "sid", ",", " ", "\n", "                        ", 
                    "frontid", ",", " ", "sno1", ",", " ", "sno2", ",", " ", 
                    "sno3", ",", " ", "sno4", ",", " ", "rayslot", ",", " ", 
                    "\n", "                        ", "generationnumber", ",",
                     " ", "intersectionnumber", ",", " ", "pol1", ",", " ", 
                    "\n", "                        ", "pol2", ",", " ", 
                    "pol3"}], "}"}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",",
                     " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", 
                    "1.", ",", " ", "\n", "                        ", "1.", 
                    ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", 
                    "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",",
                     " ", 
                    RowBox[{"-", "9.87654321*^8"}], ",", " ", "\n", 
                    "                        ", "1.", ",", " ", "1.", ",", 
                    " ", "1.", ",", " ", "1.", ",", " ", "0.", ",", " ", 
                    RowBox[{"-", "1."}], ",", " ", 
                    RowBox[{"-", "1."}], ",", " ", 
                    RowBox[{"-", "1."}], ",", " ", "1.", ",", " ", "1.", ",", 
                    " ", "1.", ",", " ", "\n", "                        ", 
                    "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",",
                     " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", 
                    "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1."}], 
                    "}"}], "}"}]}], "}"}]}]}], "]"}]}], ",", " ", "\n", 
                    "                  ", 
                    RowBox[{
                    RowBox[{
                    "deflecteddummyrayspresent", " ", "=", " ", "True"}], ";",
                     " ", "\n", "                   ", 
                    RowBox[{
                    "reporteddummyrayspresent", " ", "=", " ", "True"}], ";", 
                    " ", "\n", "                   ", 
                    RowBox[{
                    "localdummyoutrayspresent", " ", "=", " ", "True"}], ";", 
                    " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",",
                     " ", "\n", "                      ", "1.", ",", " ", 
                    "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",",
                     " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", 
                    "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",",
                     " ", "\n", "                      ", 
                    RowBox[{"-", "9.87654321*^8"}], ",", " ", "1.", ",", " ", 
                    "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "0.", ",",
                     " ", 
                    RowBox[{"-", "1."}], ",", " ", 
                    RowBox[{"-", "1."}], ",", " ", 
                    RowBox[{"-", "1."}], ",", " ", "\n", 
                    "                      ", "1.", ",", " ", "1.", ",", " ", 
                    "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",",
                     " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", 
                    "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "\n", 
                    "                      ", "1.", ",", " ", "1."}], "}"}], 
                    "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",",
                     " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", 
                    "1.", ",", " ", "1.", ",", " ", "\n", 
                    "                      ", "1.", ",", " ", "1.", ",", " ", 
                    "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",",
                     " ", "1.", ",", " ", 
                    RowBox[{"-", "9.87654321*^8"}], ",", " ", "1.", ",", " ", 
                    "\n", "                      ", "1.", ",", " ", "1.", ",",
                     " ", "1.", ",", " ", "0.", ",", " ", 
                    RowBox[{"-", "1."}], ",", " ", 
                    RowBox[{"-", "1."}], ",", " ", 
                    RowBox[{"-", "1."}], ",", " ", "1.", ",", " ", "1.", ",", 
                    " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "\n",
                     "                      ", "1.", ",", " ", "1.", ",", " ",
                     "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", 
                    ",", " ", "1.", ",", " ", "1.", ",", " ", "1."}], "}"}], 
                    "}"}], ",", " ", "\n", "                    ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",",
                     " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", 
                    "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",",
                     " ", "1.", ",", " ", "\n", "                      ", 
                    "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",",
                     " ", 
                    RowBox[{"-", "9.87654321*^8"}], ",", " ", "1.", ",", " ", 
                    "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "\n", 
                    "                      ", "0.", ",", " ", 
                    RowBox[{"-", "1."}], ",", " ", 
                    RowBox[{"-", "1."}], ",", " ", 
                    RowBox[{"-", "1."}], ",", " ", "1.", ",", " ", "1.", ",", 
                    " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.",
                     ",", " ", "1.", ",", " ", "1.", ",", " ", "\n", 
                    "                      ", "1.", ",", " ", "1.", ",", " ", 
                    "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1."}], 
                    "}"}], "}"}]}], "}"}]}]}], "]"}]}], ")"}], " ", "&"}], 
                    " ", ")"}], " ", "/@", " ", "inrays"}], "]"}]}]}], ";", 
                   " ", "\n", "           ", 
                   RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    "deflectedrayspresent", " ", "&&", " ", 
                    "deflecteddummyrayspresent"}], ",", " ", "\n", 
                    "            ", 
                    RowBox[{"deflectedlocalrays", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"Select", "[", 
                    RowBox[{"deflectedlocalrays", ",", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"#1", "[", 
                    RowBox[{"[", "23", "]"}], "]"}], " ", ">", " ", "\n", 
                    "                 ", "0."}], " ", "&"}]}], " ", "]"}], 
                    "*", "1."}]}], ",", " ", "1."}], "]"}], ";", " ", 
                   RowBox[{"If", "[", 
                    RowBox[{
                    "localoutrayspresent", ",", " ", "\n", "            ", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{"localdummyoutrayspresent", ",", " ", 
                    RowBox[{
                    RowBox[{"localoutrays", " ", "=", " ", 
                    RowBox[{"Select", "[", "\n", "                 ", 
                    RowBox[{"localoutrays", ",", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"#1", "[", 
                    RowBox[{"[", "23", "]"}], "]"}], " ", ">", " ", "0."}], 
                    " ", "&"}]}], " ", "]"}]}], ";", " ", "1."}], ",", " ", 
                    "1."}], "]"}], ";", " ", "\n", "             ", 
                    RowBox[{"outrays", " ", "=", " ", 
                    RowBox[{"Join", "[", 
                    RowBox[{"outrays", ",", " ", "localoutrays"}], "]"}]}], 
                    ";", " ", "1."}], ",", " ", "1."}], "]"}], ";", " ", "\n",
                    "           ", 
                   RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    "reportedrayspresent", " ", "&&", " ", 
                    "reporteddummyrayspresent"}], ",", " ", "\n", 
                    "            ", 
                    RowBox[{
                    RowBox[{"reportedlocalrays", " ", "=", " ", 
                    RowBox[{"Select", "[", 
                    RowBox[{"reportedlocalrays", ",", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"#1", "[", 
                    RowBox[{"[", "23", "]"}], "]"}], " ", ">", " ", "\n", 
                    "                 ", "0."}], " ", "&"}]}], " ", "]"}]}], 
                    ";", " ", "1."}], ",", " ", "1."}], "]"}]}], ")"}], ";", 
                 " ", 
                 RowBox[{"If", "[", 
                  RowBox[{
                  "reportedrayspresent", ",", " ", "\n", "           ", 
                   RowBox[{
                    RowBox[{"raysreported", " ", "=", " ", "True"}], ";", " ", 
                    RowBox[{"reportedrays", " ", "=", " ", 
                    RowBox[{"Join", "[", 
                    RowBox[{
                    "reportedrays", ",", " ", "\n", "              ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "9.87654321*^8"}], ",", " ", 
                    RowBox[{"-", "9.87654321*^8"}], ",", " ", 
                    RowBox[{"-", "9.87654321*^8"}], ",", " ", "\n", 
                    "                ", 
                    RowBox[{"-", "9.87654321*^8"}], ",", " ", 
                    RowBox[{"-", "9.87654321*^8"}], ",", " ", 
                    RowBox[{"-", "9.87654321*^8"}], ",", " ", "\n", 
                    "                ", 
                    RowBox[{"-", "9.87654321*^8"}], ",", " ", 
                    RowBox[{"-", "9.87654321*^8"}], ",", " ", 
                    RowBox[{"-", "9.87654321*^8"}], ",", " ", "\n", 
                    "                ", 
                    RowBox[{"-", "9.87654321*^8"}], ",", " ", 
                    RowBox[{"-", "9.87654321*^8"}], ",", " ", 
                    RowBox[{"-", "9.87654321*^8"}], ",", " ", "\n", 
                    "                ", 
                    RowBox[{"-", "9.87654321*^8"}], ",", " ", 
                    RowBox[{"-", "9.87654321*^8"}], ",", " ", 
                    RowBox[{"-", "9.87654321*^8"}], ",", " ", "\n", 
                    "                ", 
                    RowBox[{"-", "9.87654321*^8"}], ",", " ", 
                    RowBox[{"-", "9.87654321*^8"}], ",", " ", 
                    RowBox[{"-", "9.87654321*^8"}], ",", " ", "\n", 
                    "                ", 
                    RowBox[{"-", "9.87654321*^8"}], ",", " ", 
                    RowBox[{"-", "9.87654321*^8"}], ",", " ", 
                    RowBox[{"-", "9.87654321*^8"}], ",", " ", "\n", 
                    "                ", 
                    RowBox[{"-", "9.87654321*^8"}], ",", " ", 
                    RowBox[{"-", "9.87654321*^8"}], ",", " ", 
                    RowBox[{"-", "9.87654321*^8"}], ",", " ", "\n", 
                    "                ", 
                    RowBox[{"-", "9.87654321*^8"}], ",", " ", 
                    RowBox[{"-", "9.87654321*^8"}], ",", " ", 
                    RowBox[{"-", "9.87654321*^8"}], ",", " ", "\n", 
                    "                ", 
                    RowBox[{"-", "9.87654321*^8"}], ",", " ", 
                    RowBox[{"-", "9.87654321*^8"}], ",", " ", 
                    RowBox[{"-", "9.87654321*^8"}], ",", " ", "\n", 
                    "                ", 
                    RowBox[{"-", "9.87654321*^8"}], ",", " ", 
                    RowBox[{"-", "9.87654321*^8"}], ",", " ", 
                    RowBox[{"-", "9.87654321*^8"}], ",", " ", "\n", 
                    "                ", 
                    RowBox[{"-", "9.87654321*^8"}], ",", " ", 
                    RowBox[{"-", "9.87654321*^8"}], ",", " ", 
                    RowBox[{"-", "9.87654321*^8"}], ",", " ", "\n", 
                    "                ", 
                    RowBox[{"-", "9.87654321*^8"}], ",", " ", 
                    RowBox[{"-", "9.87654321*^8"}], ",", " ", 
                    RowBox[{"-", "9.87654321*^8"}]}], "}"}], "}"}], ",", " ", 
                    "\n", "              ", "reportedlocalrays"}], "]"}]}], 
                    ";", " ", "1."}], ",", " ", "1."}], "]"}], ";", " ", 
                 RowBox[{"inrays", " ", "=", " ", "deflectedlocalrays"}], ";",
                  " ", "\n", "          ", 
                 RowBox[{"propagate", " ", "=", " ", 
                  RowBox[{
                  "generationnumber", " ", "<", " ", 
                   "generationlimit"}]}]}]}], "]"}], ";", " ", "\n", 
              "        ", 
              RowBox[{"propagatedrays", " ", "=", " ", 
               RowBox[{"If", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"Length", "[", "outrays", "]"}], " ", ">", " ", 
                  "1"}], ",", " ", 
                 RowBox[{"Drop", "[", 
                  RowBox[{"outrays", ",", " ", "1"}], "]"}], ",", " ", "\n", 
                 "          ", "outrays"}], "]"}]}], ";", " ", 
              RowBox[{"If", "[", 
               RowBox[{
                RowBox[{
                 RowBox[{
                 "generationnumber", " ", ">=", " ", "generationlimit"}], " ",
                  "&&", " ", "\n", "          ", "deflectedrayspresent"}], 
                ",", " ", 
                RowBox[{
                 RowBox[{"propagatedrays", " ", "=", " ", 
                  RowBox[{"Join", "[", 
                   RowBox[{
                   "propagatedrays", ",", " ", "\n", "            ", 
                    "deflectedlocalrays"}], "]"}]}], ";", " ", "1."}], ",", 
                " ", "1."}], "]"}]}], ")"}], ";", " ", 
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"Length", "[", "reportedrays", "]"}], " ", ">", " ", 
               "2"}], ",", " ", "\n", "        ", 
              RowBox[{"reportedrays", " ", "=", " ", 
               RowBox[{"Drop", "[", 
                RowBox[{"reportedrays", ",", " ", "2"}], "]"}]}], ",", " ", 
              "reportedrays"}], "]"}], ";", " ", "\n", "       ", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"#1", "[", 
                  RowBox[{"[", "1", "]"}], "]"}], ",", " ", 
                 RowBox[{"#1", "[", 
                  RowBox[{"[", "2", "]"}], "]"}], ",", " ", 
                 RowBox[{"#1", "[", 
                  RowBox[{"[", "3", "]"}], "]"}], ",", " ", 
                 RowBox[{"#1", "[", 
                  RowBox[{"[", "4", "]"}], "]"}], ",", " ", 
                 RowBox[{"#1", "[", 
                  RowBox[{"[", "5", "]"}], "]"}], ",", " ", 
                 RowBox[{"#1", "[", 
                  RowBox[{"[", "6", "]"}], "]"}]}], "}"}], " ", "&"}], " ", 
              ")"}], " ", "/@", " ", "\n", "        ", "reportedrays"}]}]}], 
          "]"}]}], "]"}]}], ";", " ", 
      RowBox[{
      "polygons11188572008312134018969656", " ", "=", " ", "\n", "    ", 
       RowBox[{"Compile", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"r11", ",", " ", "r12", ",", " ", "r13"}], "}"}], ",", " ", 
         
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"r11", " ", "-", " ", 
              RowBox[{"1.", "*", 
               RowBox[{"Sqrt", "[", 
                RowBox[{
                 RowBox[{"-", "161.29"}], " ", "+", " ", 
                 RowBox[{"r11", "^", "2"}]}], "]"}], "*", 
               RowBox[{"Sign", "[", "r11", "]"}]}]}], ",", " ", "\n", 
             "       ", 
             RowBox[{"-", "12.7"}]}], "}"}], ",", " ", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"r11", " ", "-", " ", 
              RowBox[{"1.", "*", 
               RowBox[{"Sqrt", "[", 
                RowBox[{
                 RowBox[{"-", "112.00694444444441"}], " ", "+", " ", 
                 RowBox[{"r11", "^", "2"}]}], "]"}], "*", 
               RowBox[{"Sign", "[", "r11", "]"}]}]}], ",", " ", "\n", 
             "       ", 
             RowBox[{"-", "10.583333333333332"}]}], "}"}], ",", " ", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"r11", " ", "-", " ", 
              RowBox[{"1.", "*", 
               RowBox[{"Sqrt", "[", 
                RowBox[{
                 RowBox[{"-", "71.68444444444445"}], " ", "+", " ", 
                 RowBox[{"r11", "^", "2"}]}], "]"}], "*", "\n", "         ", 
               RowBox[{"Sign", "[", "r11", "]"}]}]}], ",", " ", 
             RowBox[{"-", "8.466666666666667"}]}], "}"}], ",", " ", "\n", 
           "      ", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"r11", " ", "-", " ", 
              RowBox[{"1.", "*", 
               RowBox[{"Sqrt", "[", 
                RowBox[{
                 RowBox[{"-", "40.322500000000005"}], " ", "+", " ", 
                 RowBox[{"r11", "^", "2"}]}], "]"}], "*", 
               RowBox[{"Sign", "[", "r11", "]"}]}]}], ",", " ", "\n", 
             "       ", 
             RowBox[{"-", "6.3500000000000005"}]}], "}"}], ",", " ", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"r11", " ", "-", " ", 
              RowBox[{"1.", "*", 
               RowBox[{"Sqrt", "[", 
                RowBox[{
                 RowBox[{"-", "17.92111111111112"}], " ", "+", " ", 
                 RowBox[{"r11", "^", "2"}]}], "]"}], "*", "\n", "         ", 
               RowBox[{"Sign", "[", "r11", "]"}]}]}], ",", " ", 
             RowBox[{"-", "4.233333333333334"}]}], "}"}], ",", " ", "\n", 
           "      ", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"r11", " ", "-", " ", 
              RowBox[{"1.", "*", 
               RowBox[{"Sqrt", "[", 
                RowBox[{
                 RowBox[{"-", "4.48027777777778"}], " ", "+", " ", 
                 RowBox[{"r11", "^", "2"}]}], "]"}], "*", 
               RowBox[{"Sign", "[", "r11", "]"}]}]}], ",", " ", "\n", 
             "       ", 
             RowBox[{"-", "2.116666666666667"}]}], "}"}], ",", " ", "\n", 
           "      ", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"r11", " ", "-", " ", 
              RowBox[{"1.", "*", 
               RowBox[{"Sqrt", "[", 
                RowBox[{
                 RowBox[{"-", "3.1554436208840472*^-30"}], " ", "+", " ", 
                 RowBox[{"r11", "^", "2"}]}], "]"}], "*", 
               RowBox[{"Sign", "[", "r11", "]"}]}]}], ",", " ", "\n", 
             "       ", 
             RowBox[{"-", "1.7763568394002505*^-15"}]}], "}"}], ",", " ", 
           "\n", "      ", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"r11", " ", "-", " ", 
              RowBox[{"1.", "*", 
               RowBox[{"Sqrt", "[", 
                RowBox[{
                 RowBox[{"-", "4.480277777777765"}], " ", "+", " ", 
                 RowBox[{"r11", "^", "2"}]}], "]"}], "*", 
               RowBox[{"Sign", "[", "r11", "]"}]}]}], ",", " ", "\n", 
             "       ", "2.1166666666666636"}], "}"}], ",", " ", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"r11", " ", "-", " ", 
              RowBox[{"1.", "*", 
               RowBox[{"Sqrt", "[", 
                RowBox[{
                 RowBox[{"-", "17.921111111111088"}], " ", "+", " ", 
                 RowBox[{"r11", "^", "2"}]}], "]"}], "*", "\n", "         ", 
               RowBox[{"Sign", "[", "r11", "]"}]}]}], ",", " ", 
             "4.233333333333331"}], "}"}], ",", " ", "\n", "      ", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"r11", " ", "-", " ", 
              RowBox[{"1.", "*", 
               RowBox[{"Sqrt", "[", 
                RowBox[{
                 RowBox[{"-", "40.32249999999997"}], " ", "+", " ", 
                 RowBox[{"r11", "^", "2"}]}], "]"}], "*", 
               RowBox[{"Sign", "[", "r11", "]"}]}]}], ",", " ", "\n", 
             "       ", "6.349999999999998"}], "}"}], ",", " ", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"r11", " ", "-", " ", 
              RowBox[{"1.", "*", 
               RowBox[{"Sqrt", "[", 
                RowBox[{
                 RowBox[{"-", "71.68444444444441"}], " ", "+", " ", 
                 RowBox[{"r11", "^", "2"}]}], "]"}], "*", "\n", "         ", 
               RowBox[{"Sign", "[", "r11", "]"}]}]}], ",", " ", 
             "8.466666666666665"}], "}"}], ",", " ", "\n", "      ", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"r11", " ", "-", " ", 
              RowBox[{"1.", "*", 
               RowBox[{"Sqrt", "[", 
                RowBox[{
                 RowBox[{"-", "112.00694444444434"}], " ", "+", " ", 
                 RowBox[{"r11", "^", "2"}]}], "]"}], "*", 
               RowBox[{"Sign", "[", "r11", "]"}]}]}], ",", " ", "\n", 
             "       ", "10.583333333333329"}], "}"}], ",", " ", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"r11", " ", "-", " ", 
              RowBox[{"1.", "*", 
               RowBox[{"Sqrt", "[", 
                RowBox[{
                 RowBox[{"-", "161.28999999999988"}], " ", "+", " ", 
                 RowBox[{"r11", "^", "2"}]}], "]"}], "*", "\n", "         ", 
               RowBox[{"Sign", "[", "r11", "]"}]}]}], ",", " ", 
             "12.699999999999996"}], "}"}], ",", " ", "\n", "      ", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"2.1", " ", "+", " ", "r12", " ", "-", " ", 
              RowBox[{"1.", "*", 
               RowBox[{"Sqrt", "[", 
                RowBox[{
                 RowBox[{"-", "161.29"}], " ", "+", " ", 
                 RowBox[{"r12", "^", "2"}]}], "]"}], "*", 
               RowBox[{"Sign", "[", "r12", "]"}]}]}], ",", " ", "12.7"}], 
            "}"}], ",", " ", "\n", "      ", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"2.1", " ", "+", " ", "r12", " ", "-", " ", 
              RowBox[{"1.", "*", 
               RowBox[{"Sqrt", "[", 
                RowBox[{
                 RowBox[{"-", "112.00694444444441"}], " ", "+", " ", 
                 RowBox[{"r12", "^", "2"}]}], "]"}], "*", 
               RowBox[{"Sign", "[", "r12", "]"}]}]}], ",", " ", "\n", 
             "       ", "10.583333333333332"}], "}"}], ",", " ", "\n", 
           "      ", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"2.1", " ", "+", " ", "r12", " ", "-", " ", 
              RowBox[{"1.", "*", 
               RowBox[{"Sqrt", "[", 
                RowBox[{
                 RowBox[{"-", "71.68444444444445"}], " ", "+", " ", 
                 RowBox[{"r12", "^", "2"}]}], "]"}], "*", 
               RowBox[{"Sign", "[", "r12", "]"}]}]}], ",", " ", "\n", 
             "       ", "8.466666666666667"}], "}"}], ",", " ", "\n", 
           "      ", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"2.1", " ", "+", " ", "r12", " ", "-", " ", 
              RowBox[{"1.", "*", 
               RowBox[{"Sqrt", "[", 
                RowBox[{
                 RowBox[{"-", "40.322500000000005"}], " ", "+", " ", 
                 RowBox[{"r12", "^", "2"}]}], "]"}], "*", 
               RowBox[{"Sign", "[", "r12", "]"}]}]}], ",", " ", "\n", 
             "       ", "6.3500000000000005"}], "}"}], ",", " ", "\n", 
           "      ", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"2.1", " ", "+", " ", "r12", " ", "-", " ", 
              RowBox[{"1.", "*", 
               RowBox[{"Sqrt", "[", 
                RowBox[{
                 RowBox[{"-", "17.92111111111112"}], " ", "+", " ", 
                 RowBox[{"r12", "^", "2"}]}], "]"}], "*", 
               RowBox[{"Sign", "[", "r12", "]"}]}]}], ",", " ", "\n", 
             "       ", "4.233333333333334"}], "}"}], ",", " ", "\n", 
           "      ", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"2.1", " ", "+", " ", "r12", " ", "-", " ", 
              RowBox[{"1.", "*", 
               RowBox[{"Sqrt", "[", 
                RowBox[{
                 RowBox[{"-", "4.48027777777778"}], " ", "+", " ", 
                 RowBox[{"r12", "^", "2"}]}], "]"}], "*", 
               RowBox[{"Sign", "[", "r12", "]"}]}]}], ",", " ", "\n", 
             "       ", "2.116666666666667"}], "}"}], ",", " ", "\n", 
           "      ", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"2.1", " ", "+", " ", "r12", " ", "-", " ", 
              RowBox[{"1.", "*", 
               RowBox[{"Sqrt", "[", 
                RowBox[{
                 RowBox[{"-", "3.1554436208840472*^-30"}], " ", "+", " ", 
                 RowBox[{"r12", "^", "2"}]}], "]"}], "*", 
               RowBox[{"Sign", "[", "r12", "]"}]}]}], ",", " ", "\n", 
             "       ", "1.7763568394002505*^-15"}], "}"}], ",", " ", "\n", 
           "      ", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"2.1", " ", "+", " ", "r12", " ", "-", " ", 
              RowBox[{"1.", "*", 
               RowBox[{"Sqrt", "[", 
                RowBox[{
                 RowBox[{"-", "4.480277777777765"}], " ", "+", " ", 
                 RowBox[{"r12", "^", "2"}]}], "]"}], "*", 
               RowBox[{"Sign", "[", "r12", "]"}]}]}], ",", " ", "\n", 
             "       ", 
             RowBox[{"-", "2.1166666666666636"}]}], "}"}], ",", " ", "\n", 
           "      ", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"2.1", " ", "+", " ", "r12", " ", "-", " ", 
              RowBox[{"1.", "*", 
               RowBox[{"Sqrt", "[", 
                RowBox[{
                 RowBox[{"-", "17.921111111111088"}], " ", "+", " ", 
                 RowBox[{"r12", "^", "2"}]}], "]"}], "*", 
               RowBox[{"Sign", "[", "r12", "]"}]}]}], ",", " ", "\n", 
             "       ", 
             RowBox[{"-", "4.233333333333331"}]}], "}"}], ",", " ", "\n", 
           "      ", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"2.1", " ", "+", " ", "r12", " ", "-", " ", 
              RowBox[{"1.", "*", 
               RowBox[{"Sqrt", "[", 
                RowBox[{
                 RowBox[{"-", "40.32249999999997"}], " ", "+", " ", 
                 RowBox[{"r12", "^", "2"}]}], "]"}], "*", 
               RowBox[{"Sign", "[", "r12", "]"}]}]}], ",", " ", "\n", 
             "       ", 
             RowBox[{"-", "6.349999999999998"}]}], "}"}], ",", " ", "\n", 
           "      ", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"2.1", " ", "+", " ", "r12", " ", "-", " ", 
              RowBox[{"1.", "*", 
               RowBox[{"Sqrt", "[", 
                RowBox[{
                 RowBox[{"-", "71.68444444444441"}], " ", "+", " ", 
                 RowBox[{"r12", "^", "2"}]}], "]"}], "*", 
               RowBox[{"Sign", "[", "r12", "]"}]}]}], ",", " ", "\n", 
             "       ", 
             RowBox[{"-", "8.466666666666665"}]}], "}"}], ",", " ", "\n", 
           "      ", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"2.1", " ", "+", " ", "r12", " ", "-", " ", 
              RowBox[{"1.", "*", 
               RowBox[{"Sqrt", "[", 
                RowBox[{
                 RowBox[{"-", "112.00694444444434"}], " ", "+", " ", 
                 RowBox[{"r12", "^", "2"}]}], "]"}], "*", 
               RowBox[{"Sign", "[", "r12", "]"}]}]}], ",", " ", "\n", 
             "       ", 
             RowBox[{"-", "10.583333333333329"}]}], "}"}], ",", " ", "\n", 
           "      ", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"2.1", " ", "+", " ", "r12", " ", "-", " ", 
              RowBox[{"1.", "*", 
               RowBox[{"Sqrt", "[", 
                RowBox[{
                 RowBox[{"-", "161.28999999999988"}], " ", "+", " ", 
                 RowBox[{"r12", "^", "2"}]}], "]"}], "*", 
               RowBox[{"Sign", "[", "r12", "]"}]}]}], ",", " ", "\n", 
             "       ", 
             RowBox[{"-", "12.699999999999996"}]}], "}"}], ",", " ", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"r11", " ", "-", " ", 
              RowBox[{"1.", "*", 
               RowBox[{"Sqrt", "[", 
                RowBox[{
                 RowBox[{"-", "161.29"}], " ", "+", " ", 
                 RowBox[{"r11", "^", "2"}]}], "]"}], "*", 
               RowBox[{"Sign", "[", "r11", "]"}]}]}], ",", " ", "\n", 
             "       ", 
             RowBox[{"-", "12.7"}]}], "}"}], ",", " ", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"2.1", " ", "+", " ", "r12", " ", "-", " ", 
              RowBox[{"1.", "*", 
               RowBox[{"Sqrt", "[", 
                RowBox[{
                 RowBox[{"-", "161.29"}], " ", "+", " ", 
                 RowBox[{"r12", "^", "2"}]}], "]"}], "*", 
               RowBox[{"Sign", "[", "r12", "]"}]}]}], ",", " ", 
             RowBox[{"-", "12.7"}]}], "}"}], ",", " ", "\n", "      ", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"2.1", " ", "+", " ", "r12", " ", "-", " ", 
              RowBox[{"1.", "*", 
               RowBox[{"Sqrt", "[", 
                RowBox[{
                 RowBox[{"-", "112.00694444444441"}], " ", "+", " ", 
                 RowBox[{"r12", "^", "2"}]}], "]"}], "*", 
               RowBox[{"Sign", "[", "r12", "]"}]}]}], ",", " ", "\n", 
             "       ", 
             RowBox[{"-", "10.583333333333332"}]}], "}"}], ",", " ", "\n", 
           "      ", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"2.1", " ", "+", " ", "r12", " ", "-", " ", 
              RowBox[{"1.", "*", 
               RowBox[{"Sqrt", "[", 
                RowBox[{
                 RowBox[{"-", "71.68444444444445"}], " ", "+", " ", 
                 RowBox[{"r12", "^", "2"}]}], "]"}], "*", 
               RowBox[{"Sign", "[", "r12", "]"}]}]}], ",", " ", "\n", 
             "       ", 
             RowBox[{"-", "8.466666666666667"}]}], "}"}], ",", " ", "\n", 
           "      ", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"2.1", " ", "+", " ", "r12", " ", "-", " ", 
              RowBox[{"1.", "*", 
               RowBox[{"Sqrt", "[", 
                RowBox[{
                 RowBox[{"-", "40.322500000000005"}], " ", "+", " ", 
                 RowBox[{"r12", "^", "2"}]}], "]"}], "*", 
               RowBox[{"Sign", "[", "r12", "]"}]}]}], ",", " ", "\n", 
             "       ", 
             RowBox[{"-", "6.3500000000000005"}]}], "}"}], ",", " ", "\n", 
           "      ", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"2.1", " ", "+", " ", "r12", " ", "-", " ", 
              RowBox[{"1.", "*", 
               RowBox[{"Sqrt", "[", 
                RowBox[{
                 RowBox[{"-", "17.92111111111112"}], " ", "+", " ", 
                 RowBox[{"r12", "^", "2"}]}], "]"}], "*", 
               RowBox[{"Sign", "[", "r12", "]"}]}]}], ",", " ", "\n", 
             "       ", 
             RowBox[{"-", "4.233333333333334"}]}], "}"}], ",", " ", "\n", 
           "      ", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"2.1", " ", "+", " ", "r12", " ", "-", " ", 
              RowBox[{"1.", "*", 
               RowBox[{"Sqrt", "[", 
                RowBox[{
                 RowBox[{"-", "4.48027777777778"}], " ", "+", " ", 
                 RowBox[{"r12", "^", "2"}]}], "]"}], "*", 
               RowBox[{"Sign", "[", "r12", "]"}]}]}], ",", " ", "\n", 
             "       ", 
             RowBox[{"-", "2.116666666666667"}]}], "}"}], ",", " ", "\n", 
           "      ", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"2.1", " ", "+", " ", "r12", " ", "-", " ", 
              RowBox[{"1.", "*", 
               RowBox[{"Sqrt", "[", 
                RowBox[{
                 RowBox[{"-", "3.1554436208840472*^-30"}], " ", "+", " ", 
                 RowBox[{"r12", "^", "2"}]}], "]"}], "*", 
               RowBox[{"Sign", "[", "r12", "]"}]}]}], ",", " ", "\n", 
             "       ", 
             RowBox[{"-", "1.7763568394002505*^-15"}]}], "}"}], ",", " ", 
           "\n", "      ", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"2.1", " ", "+", " ", "r12", " ", "-", " ", 
              RowBox[{"1.", "*", 
               RowBox[{"Sqrt", "[", 
                RowBox[{
                 RowBox[{"-", "4.480277777777765"}], " ", "+", " ", 
                 RowBox[{"r12", "^", "2"}]}], "]"}], "*", 
               RowBox[{"Sign", "[", "r12", "]"}]}]}], ",", " ", "\n", 
             "       ", "2.1166666666666636"}], "}"}], ",", " ", "\n", 
           "      ", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"2.1", " ", "+", " ", "r12", " ", "-", " ", 
              RowBox[{"1.", "*", 
               RowBox[{"Sqrt", "[", 
                RowBox[{
                 RowBox[{"-", "17.921111111111088"}], " ", "+", " ", 
                 RowBox[{"r12", "^", "2"}]}], "]"}], "*", 
               RowBox[{"Sign", "[", "r12", "]"}]}]}], ",", " ", "\n", 
             "       ", "4.233333333333331"}], "}"}], ",", " ", "\n", 
           "      ", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"2.1", " ", "+", " ", "r12", " ", "-", " ", 
              RowBox[{"1.", "*", 
               RowBox[{"Sqrt", "[", 
                RowBox[{
                 RowBox[{"-", "40.32249999999997"}], " ", "+", " ", 
                 RowBox[{"r12", "^", "2"}]}], "]"}], "*", 
               RowBox[{"Sign", "[", "r12", "]"}]}]}], ",", " ", "\n", 
             "       ", "6.349999999999998"}], "}"}], ",", " ", "\n", 
           "      ", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"2.1", " ", "+", " ", "r12", " ", "-", " ", 
              RowBox[{"1.", "*", 
               RowBox[{"Sqrt", "[", 
                RowBox[{
                 RowBox[{"-", "71.68444444444441"}], " ", "+", " ", 
                 RowBox[{"r12", "^", "2"}]}], "]"}], "*", 
               RowBox[{"Sign", "[", "r12", "]"}]}]}], ",", " ", "\n", 
             "       ", "8.466666666666665"}], "}"}], ",", " ", "\n", 
           "      ", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"2.1", " ", "+", " ", "r12", " ", "-", " ", 
              RowBox[{"1.", "*", 
               RowBox[{"Sqrt", "[", 
                RowBox[{
                 RowBox[{"-", "112.00694444444434"}], " ", "+", " ", 
                 RowBox[{"r12", "^", "2"}]}], "]"}], "*", 
               RowBox[{"Sign", "[", "r12", "]"}]}]}], ",", " ", "\n", 
             "       ", "10.583333333333329"}], "}"}], ",", " ", "\n", 
           "      ", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"2.1", " ", "+", " ", "r12", " ", "-", " ", 
              RowBox[{"1.", "*", 
               RowBox[{"Sqrt", "[", 
                RowBox[{
                 RowBox[{"-", "161.28999999999988"}], " ", "+", " ", 
                 RowBox[{"r12", "^", "2"}]}], "]"}], "*", 
               RowBox[{"Sign", "[", "r12", "]"}]}]}], ",", " ", "\n", 
             "       ", "12.699999999999996"}], "}"}], ",", " ", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"9.6", " ", "+", " ", "r13", " ", "-", " ", 
              RowBox[{"1.", "*", 
               RowBox[{"Sqrt", "[", 
                RowBox[{
                 RowBox[{"-", "161.29"}], " ", "+", " ", 
                 RowBox[{"r13", "^", "2"}]}], "]"}], "*", "\n", "         ", 
               RowBox[{"Sign", "[", "r13", "]"}]}]}], ",", " ", "12.7"}], 
            "}"}], ",", " ", "\n", "      ", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"9.6", " ", "+", " ", "r13", " ", "-", " ", 
              RowBox[{"1.", "*", 
               RowBox[{"Sqrt", "[", 
                RowBox[{
                 RowBox[{"-", "112.00694444444441"}], " ", "+", " ", 
                 RowBox[{"r13", "^", "2"}]}], "]"}], "*", 
               RowBox[{"Sign", "[", "r13", "]"}]}]}], ",", " ", "\n", 
             "       ", "10.583333333333332"}], "}"}], ",", " ", "\n", 
           "      ", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"9.6", " ", "+", " ", "r13", " ", "-", " ", 
              RowBox[{"1.", "*", 
               RowBox[{"Sqrt", "[", 
                RowBox[{
                 RowBox[{"-", "71.68444444444445"}], " ", "+", " ", 
                 RowBox[{"r13", "^", "2"}]}], "]"}], "*", 
               RowBox[{"Sign", "[", "r13", "]"}]}]}], ",", " ", "\n", 
             "       ", "8.466666666666667"}], "}"}], ",", " ", "\n", 
           "      ", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"9.6", " ", "+", " ", "r13", " ", "-", " ", 
              RowBox[{"1.", "*", 
               RowBox[{"Sqrt", "[", 
                RowBox[{
                 RowBox[{"-", "40.322500000000005"}], " ", "+", " ", 
                 RowBox[{"r13", "^", "2"}]}], "]"}], "*", 
               RowBox[{"Sign", "[", "r13", "]"}]}]}], ",", " ", "\n", 
             "       ", "6.3500000000000005"}], "}"}], ",", " ", "\n", 
           "      ", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"9.6", " ", "+", " ", "r13", " ", "-", " ", 
              RowBox[{"1.", "*", 
               RowBox[{"Sqrt", "[", 
                RowBox[{
                 RowBox[{"-", "17.92111111111112"}], " ", "+", " ", 
                 RowBox[{"r13", "^", "2"}]}], "]"}], "*", 
               RowBox[{"Sign", "[", "r13", "]"}]}]}], ",", " ", "\n", 
             "       ", "4.233333333333334"}], "}"}], ",", " ", "\n", 
           "      ", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"9.6", " ", "+", " ", "r13", " ", "-", " ", 
              RowBox[{"1.", "*", 
               RowBox[{"Sqrt", "[", 
                RowBox[{
                 RowBox[{"-", "4.48027777777778"}], " ", "+", " ", 
                 RowBox[{"r13", "^", "2"}]}], "]"}], "*", 
               RowBox[{"Sign", "[", "r13", "]"}]}]}], ",", " ", "\n", 
             "       ", "2.116666666666667"}], "}"}], ",", " ", "\n", 
           "      ", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"9.6", " ", "+", " ", "r13", " ", "-", " ", 
              RowBox[{"1.", "*", 
               RowBox[{"Sqrt", "[", 
                RowBox[{
                 RowBox[{"-", "3.1554436208840472*^-30"}], " ", "+", " ", 
                 RowBox[{"r13", "^", "2"}]}], "]"}], "*", 
               RowBox[{"Sign", "[", "r13", "]"}]}]}], ",", " ", "\n", 
             "       ", "1.7763568394002505*^-15"}], "}"}], ",", " ", "\n", 
           "      ", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"9.6", " ", "+", " ", "r13", " ", "-", " ", 
              RowBox[{"1.", "*", 
               RowBox[{"Sqrt", "[", 
                RowBox[{
                 RowBox[{"-", "4.480277777777765"}], " ", "+", " ", 
                 RowBox[{"r13", "^", "2"}]}], "]"}], "*", 
               RowBox[{"Sign", "[", "r13", "]"}]}]}], ",", " ", "\n", 
             "       ", 
             RowBox[{"-", "2.1166666666666636"}]}], "}"}], ",", " ", "\n", 
           "      ", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"9.6", " ", "+", " ", "r13", " ", "-", " ", 
              RowBox[{"1.", "*", 
               RowBox[{"Sqrt", "[", 
                RowBox[{
                 RowBox[{"-", "17.921111111111088"}], " ", "+", " ", 
                 RowBox[{"r13", "^", "2"}]}], "]"}], "*", 
               RowBox[{"Sign", "[", "r13", "]"}]}]}], ",", " ", "\n", 
             "       ", 
             RowBox[{"-", "4.233333333333331"}]}], "}"}], ",", " ", "\n", 
           "      ", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"9.6", " ", "+", " ", "r13", " ", "-", " ", 
              RowBox[{"1.", "*", 
               RowBox[{"Sqrt", "[", 
                RowBox[{
                 RowBox[{"-", "40.32249999999997"}], " ", "+", " ", 
                 RowBox[{"r13", "^", "2"}]}], "]"}], "*", 
               RowBox[{"Sign", "[", "r13", "]"}]}]}], ",", " ", "\n", 
             "       ", 
             RowBox[{"-", "6.349999999999998"}]}], "}"}], ",", " ", "\n", 
           "      ", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"9.6", " ", "+", " ", "r13", " ", "-", " ", 
              RowBox[{"1.", "*", 
               RowBox[{"Sqrt", "[", 
                RowBox[{
                 RowBox[{"-", "71.68444444444441"}], " ", "+", " ", 
                 RowBox[{"r13", "^", "2"}]}], "]"}], "*", 
               RowBox[{"Sign", "[", "r13", "]"}]}]}], ",", " ", "\n", 
             "       ", 
             RowBox[{"-", "8.466666666666665"}]}], "}"}], ",", " ", "\n", 
           "      ", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"9.6", " ", "+", " ", "r13", " ", "-", " ", 
              RowBox[{"1.", "*", 
               RowBox[{"Sqrt", "[", 
                RowBox[{
                 RowBox[{"-", "112.00694444444434"}], " ", "+", " ", 
                 RowBox[{"r13", "^", "2"}]}], "]"}], "*", 
               RowBox[{"Sign", "[", "r13", "]"}]}]}], ",", " ", "\n", 
             "       ", 
             RowBox[{"-", "10.583333333333329"}]}], "}"}], ",", " ", "\n", 
           "      ", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"9.6", " ", "+", " ", "r13", " ", "-", " ", 
              RowBox[{"1.", "*", 
               RowBox[{"Sqrt", "[", 
                RowBox[{
                 RowBox[{"-", "161.28999999999988"}], " ", "+", " ", 
                 RowBox[{"r13", "^", "2"}]}], "]"}], "*", 
               RowBox[{"Sign", "[", "r13", "]"}]}]}], ",", " ", "\n", 
             "       ", 
             RowBox[{"-", "12.699999999999996"}]}], "}"}], ",", " ", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"2.1", " ", "+", " ", "r12", " ", "-", " ", 
              RowBox[{"1.", "*", 
               RowBox[{"Sqrt", "[", 
                RowBox[{
                 RowBox[{"-", "161.29"}], " ", "+", " ", 
                 RowBox[{"r12", "^", "2"}]}], "]"}], "*", "\n", "         ", 
               RowBox[{"Sign", "[", "r12", "]"}]}]}], ",", " ", 
             RowBox[{"-", "12.7"}]}], "}"}]}], "}"}]}], "]"}]}], ";", " ", 
      RowBox[{
      "polygons12188572008312134018987715", " ", "=", " ", "\n", "    ", 
       RowBox[{"Compile", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"r21", ",", " ", "r22", ",", " ", "r23"}], "}"}], ",", " ", 
         
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"r21", " ", "-", " ", 
              RowBox[{"1.", "*", 
               RowBox[{"Sqrt", "[", 
                RowBox[{
                 RowBox[{"-", "161.29"}], " ", "+", " ", 
                 RowBox[{"r21", "^", "2"}]}], "]"}], "*", 
               RowBox[{"Sign", "[", "r21", "]"}]}]}], ",", " ", "\n", 
             "       ", 
             RowBox[{"-", "12.7"}]}], "}"}], ",", " ", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"r21", " ", "-", " ", 
              RowBox[{"1.", "*", 
               RowBox[{"Sqrt", "[", 
                RowBox[{
                 RowBox[{"-", "112.00694444444441"}], " ", "+", " ", 
                 RowBox[{"r21", "^", "2"}]}], "]"}], "*", 
               RowBox[{"Sign", "[", "r21", "]"}]}]}], ",", " ", "\n", 
             "       ", 
             RowBox[{"-", "10.583333333333332"}]}], "}"}], ",", " ", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"r21", " ", "-", " ", 
              RowBox[{"1.", "*", 
               RowBox[{"Sqrt", "[", 
                RowBox[{
                 RowBox[{"-", "71.68444444444445"}], " ", "+", " ", 
                 RowBox[{"r21", "^", "2"}]}], "]"}], "*", "\n", "         ", 
               RowBox[{"Sign", "[", "r21", "]"}]}]}], ",", " ", 
             RowBox[{"-", "8.466666666666667"}]}], "}"}], ",", " ", "\n", 
           "      ", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"r21", " ", "-", " ", 
              RowBox[{"1.", "*", 
               RowBox[{"Sqrt", "[", 
                RowBox[{
                 RowBox[{"-", "40.322500000000005"}], " ", "+", " ", 
                 RowBox[{"r21", "^", "2"}]}], "]"}], "*", 
               RowBox[{"Sign", "[", "r21", "]"}]}]}], ",", " ", "\n", 
             "       ", 
             RowBox[{"-", "6.3500000000000005"}]}], "}"}], ",", " ", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"r21", " ", "-", " ", 
              RowBox[{"1.", "*", 
               RowBox[{"Sqrt", "[", 
                RowBox[{
                 RowBox[{"-", "17.92111111111112"}], " ", "+", " ", 
                 RowBox[{"r21", "^", "2"}]}], "]"}], "*", "\n", "         ", 
               RowBox[{"Sign", "[", "r21", "]"}]}]}], ",", " ", 
             RowBox[{"-", "4.233333333333334"}]}], "}"}], ",", " ", "\n", 
           "      ", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"r21", " ", "-", " ", 
              RowBox[{"1.", "*", 
               RowBox[{"Sqrt", "[", 
                RowBox[{
                 RowBox[{"-", "4.48027777777778"}], " ", "+", " ", 
                 RowBox[{"r21", "^", "2"}]}], "]"}], "*", 
               RowBox[{"Sign", "[", "r21", "]"}]}]}], ",", " ", "\n", 
             "       ", 
             RowBox[{"-", "2.116666666666667"}]}], "}"}], ",", " ", "\n", 
           "      ", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"r21", " ", "-", " ", 
              RowBox[{"1.", "*", 
               RowBox[{"Sqrt", "[", 
                RowBox[{
                 RowBox[{"-", "3.1554436208840472*^-30"}], " ", "+", " ", 
                 RowBox[{"r21", "^", "2"}]}], "]"}], "*", 
               RowBox[{"Sign", "[", "r21", "]"}]}]}], ",", " ", "\n", 
             "       ", 
             RowBox[{"-", "1.7763568394002505*^-15"}]}], "}"}], ",", " ", 
           "\n", "      ", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"r21", " ", "-", " ", 
              RowBox[{"1.", "*", 
               RowBox[{"Sqrt", "[", 
                RowBox[{
                 RowBox[{"-", "4.480277777777765"}], " ", "+", " ", 
                 RowBox[{"r21", "^", "2"}]}], "]"}], "*", 
               RowBox[{"Sign", "[", "r21", "]"}]}]}], ",", " ", "\n", 
             "       ", "2.1166666666666636"}], "}"}], ",", " ", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{