(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     18589,        480]
NotebookOptionsPosition[     17383,        433]
NotebookOutlinePosition[     18024,        458]
CellTagsIndexPosition[     17981,        455]
WindowTitle->Inverse Square Laws - Source
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Inverse Square Laws", "Section",
 CellFrame->{{0, 0}, {0, 0}},
 ShowCellBracket->False,
 FontColor->RGBColor[0.597406, 0, 0.0527047]],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztnVuSozgWQDNiPqa3MJ+zpVlCbaB3WlGVNV9dvYH6TQRUph/ZGIHQmwvG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   "], {{0, 0}, {1800, 25}}, {0, 255},
   ColorFunction->RGBColor],
  ImageSize->{1800, 25},
  PlotRange->{{0, 1800}, {0, 25}}]], "Section",
 CellFrame->{{0, 0}, {0, 0}},
 ShowCellBracket->False],

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"Show", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Graphics3D", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Point", "[", 
           RowBox[{"{", 
            RowBox[{"0", ",", "0", ",", "0"}], "}"}], "]"}], ",", 
          RowBox[{
           RowBox[{
            RowBox[{"Line", "[", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
               RowBox[{"radius", 
                RowBox[{"{", " ", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"Cos", "[", 
                    RowBox[{"#", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "]"}], " ", 
                   RowBox[{"Sin", "[", 
                    RowBox[{"#", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "]"}]}], ",", " ", 
                  RowBox[{
                   RowBox[{"Sin", "[", 
                    RowBox[{"#", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "]"}], " ", 
                   RowBox[{"Sin", "[", 
                    RowBox[{"#", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "]"}]}], ",", " ", 
                  RowBox[{"Cos", "[", 
                   RowBox[{"#", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "]"}]}], "}"}]}]}], "}"}],
              "]"}], "&"}], "/@", 
           RowBox[{"Tuples", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"\[Pi]", "/", "3"}], ",", 
               RowBox[{"2", 
                RowBox[{"\[Pi]", "/", "3"}]}]}], "}"}], ",", "2"}], "]"}]}], 
          ",", 
          RowBox[{"Opacity", "[", ".3", "]"}], ",", 
          RowBox[{"Sphere", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", "1"}], "]"}]}], 
         "}"}], "]"}], ",", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"ParametricPlot3D", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"r", " ", 
              RowBox[{"Cos", "[", "\[Theta]", "]"}], " ", 
              RowBox[{"Sin", "[", "\[Phi]", "]"}]}], ",", 
             RowBox[{"r", " ", 
              RowBox[{"Sin", "[", "\[Theta]", "]"}], " ", 
              RowBox[{"Sin", "[", "\[Phi]", "]"}]}], ",", 
             RowBox[{"r", " ", 
              RowBox[{"Cos", "[", "\[Phi]", "]"}]}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"\[Theta]", ",", 
             RowBox[{"\[Pi]", "/", "3"}], ",", 
             RowBox[{"2", 
              RowBox[{"\[Pi]", "/", "3"}]}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"\[Phi]", ",", 
             RowBox[{"\[Pi]", "/", "3"}], ",", 
             RowBox[{"2", 
              RowBox[{"\[Pi]", "/", "3"}]}]}], "}"}], ",", 
           RowBox[{"Mesh", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"r", "-", "1"}], ",", 
              RowBox[{"r", "-", "1"}]}], "}"}]}], ",", 
           RowBox[{"PlotStyle", "\[Rule]", 
            RowBox[{"{", 
             RowBox[{"Opacity", "[", ".7", "]"}], "}"}]}], ",", 
           RowBox[{"PerformanceGoal", "\[Rule]", "\"\<Speed\>\""}]}], "]"}], 
         ",", 
         RowBox[{"{", 
          RowBox[{"r", ",", "1", ",", "radius"}], "}"}]}], "]"}]}], "}"}], 
     ",", 
     RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
     RowBox[{"Boxed", "\[Rule]", "False"}], ",", 
     RowBox[{"ViewPoint", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"2.7550229340996077`", ",", 
        RowBox[{"-", "1.2783201504632618`"}], ",", "1.4918935034059142`"}], 
       "}"}]}], ",", 
     RowBox[{"ViewVertical", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
       "0.3754558387166779`", ",", "0.14865676602154548`", ",", 
        "1.2639319106668794`"}], "}"}]}], ",", 
     RowBox[{"ImageSize", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"500", ",", "400"}], "}"}]}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"radius", ",", "2"}], "}"}], ",", "0", ",", "10", ",", "1", ",", 
     RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.378593488841316*^9, 3.378593519720236*^9}, {
   3.3785935697408543`*^9, 3.37859358880234*^9}, {3.378593641595831*^9, 
   3.378593654156117*^9}, {3.3785936959420547`*^9, 3.3785937011096153`*^9}, {
   3.378593879577771*^9, 3.3785940888944893`*^9}, {3.3785941796417437`*^9, 
   3.378594297711123*^9}, {3.3785943522998343`*^9, 3.378594358311051*^9}, {
   3.378594606963765*^9, 3.378594608346088*^9}, 3.378594647252776*^9, {
   3.37859469945269*^9, 3.378594741852455*^9}, {3.378594905991783*^9, 
   3.3785950153211107`*^9}, {3.378595103864924*^9, 3.378595135036439*^9}, 
   3.378595165255993*^9, {3.378595202387108*^9, 3.3785952767366953`*^9}, {
   3.378595308278079*^9, 3.3785954085607023`*^9}, 3.3785958138619413`*^9, {
   3.3810937519046164`*^9, 3.38109377139926*^9}, {3.381093842817013*^9, 
   3.381093844156502*^9}, {3.38109419318257*^9, 3.3810941960005503`*^9}, 
   3.3810949113852654`*^9, {3.381333661983562*^9, 3.3813336623927717`*^9}, {
   3.3813363005625*^9, 3.381336302546875*^9}, {3.381336695671875*^9, 
   3.381336697421875*^9}, {3.3813367771875*^9, 3.3813369595625*^9}, {
   3.381337040859375*^9, 3.3813370533125*^9}, {3.381337205671875*^9, 
   3.381337235875*^9}, {3.384787621716762*^9, 3.3847876541838017`*^9}, {
   3.384787764114094*^9, 3.384787781036458*^9}, {3.38478788945645*^9, 
   3.384787948561759*^9}, {3.3847880538689203`*^9, 3.384788066427133*^9}, {
   3.3847881562668753`*^9, 3.384788183205167*^9}},
 CellID->1787967397]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`radius$$ = 2, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`radius$$], 2}, 0, 10, 1}}, Typeset`size$$ = {
    500., {198., 202.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True, $CellContext`radius$87114$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`radius$$ = 2}, 
      "ControllerVariables" :> {
        Hold[$CellContext`radius$$, $CellContext`radius$87114$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Show[{
         Graphics3D[{
           Point[{0, 0, 0}], 
           Map[Line[{{0, 0, 0}, $CellContext`radius$$ {Cos[
                  Part[#, 1]] Sin[
                  Part[#, 2]], Sin[
                  Part[#, 1]] Sin[
                  Part[#, 2]], 
                Cos[
                 Part[#, 2]]}}]& , 
            Tuples[{Pi/3, 2 (Pi/3)}, 2]], 
           Opacity[0.3], 
           Sphere[{0, 0, 0}, 1]}], 
         Table[
          
          ParametricPlot3D[{$CellContext`r Cos[$CellContext`\[Theta]] 
            Sin[$CellContext`\[Phi]], $CellContext`r 
            Sin[$CellContext`\[Theta]] 
            Sin[$CellContext`\[Phi]], $CellContext`r 
            Cos[$CellContext`\[Phi]]}, {$CellContext`\[Theta], Pi/3, 
            2 (Pi/3)}, {$CellContext`\[Phi], Pi/3, 2 (Pi/3)}, 
           Mesh -> {$CellContext`r - 1, $CellContext`r - 1}, PlotStyle -> {
             Opacity[0.7]}, PerformanceGoal -> "Speed"], {$CellContext`r, 
           1, $CellContext`radius$$}]}, PlotRange -> All, Boxed -> False, 
        ViewPoint -> {2.7550229340996077`, -1.2783201504632618`, 
         1.4918935034059142`}, 
        ViewVertical -> {0.3754558387166779, 0.14865676602154548`, 
         1.2639319106668794`}, ImageSize -> {500, 400}], 
      "Specifications" :> {{{$CellContext`radius$$, 2}, 0, 10, 1, Appearance -> 
         "Labeled"}}, "Options" :> {}, 
      "DefaultOptions" :> {ControllerLinking -> True}],
     ImageSizeCache->{545., {242., 247.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellID->199046993],

Cell[CellGroupData[{

Cell["CAPTION", "Section",
 CellFrame->{{0, 0}, {1, 0}},
 CellFrameColor->RGBColor[0.87, 0.87, 0.87],
 FontFamily->"Helvetica",
 FontSize->12,
 FontWeight->"Bold",
 FontColor->RGBColor[0.597406, 0, 0.0527047]],

Cell["\<\
Gravity, electrostatic force, and luminosity are inversely proportional to \
the square of the distance. This Demonstration gives an idea of why: an area \
projected from the center of a sphere grows proportionately to the square of \
the distance.\
\>", "Text"]
}, Close]]
}, Open  ]],

Cell[CellGroupData[{

Cell["THIS NOTEBOOK IS THE SOURCE CODE FROM", "Text",
 CellFrame->{{0, 0}, {0, 0}},
 CellMargins->{{48, 10}, {4, 28}},
 CellGroupingRules->{"SectionGrouping", 25},
 CellFrameMargins->{{48, 48}, {6, 5}},
 CellFrameColor->RGBColor[0.87, 0.87, 0.87],
 FontFamily->"Helvetica",
 FontSize->10,
 FontWeight->"Bold",
 FontColor->RGBColor[0.597406, 0, 0.0527047]],

Cell[TextData[{
 "\"",
 ButtonBox["Inverse Square Laws",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/InverseSquareLaws/"], None},
  ButtonNote->"http://demonstrations.wolfram.com/InverseSquareLaws/"],
 "\"",
 " from ",
 ButtonBox["the Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->"http://demonstrations.wolfram.com/"],
 "\[ParagraphSeparator]\[NonBreakingSpace]",
 ButtonBox["http://demonstrations.wolfram.com/InverseSquareLaws/",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/InverseSquareLaws/"], None},
  ButtonNote->"http://demonstrations.wolfram.com/InverseSquareLaws/"]
}], "Text",
 CellMargins->{{48, Inherited}, {0, Inherited}},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.5]],

Cell[TextData[{
 "Contributed by: ",
 ButtonBox["Enrique Zeleny V.",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/author.html?author=Enrique+Zeleny+\
V."], None},
  ButtonNote->
   "http://demonstrations.wolfram.com/author.html?author=Enrique+Zeleny+V."]
}], "Text",
 CellDingbat->"\[FilledSmallSquare]",
 CellMargins->{{66, 48}, {2, 4}},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.6],
 CellID->1322003451],

Cell[CellGroupData[{

Cell[TextData[{
 "A full-function Wolfram ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " system (Version 6 or higher) is required to edit this notebook.\n",
 StyleBox[ButtonBox["GET WOLFRAM MATHEMATICA \[RightGuillemet]",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolfram.com/products/mathematica/"], None},
  ButtonNote->"http://www.wolfram.com/products/mathematica/"],
  FontFamily->"Helvetica",
  FontWeight->"Bold",
  FontSlant->"Italic",
  FontColor->RGBColor[1, 0.42, 0]]
}], "Text",
 CellFrame->True,
 CellMargins->{{48, 68}, {8, 28}},
 CellFrameMargins->12,
 CellFrameColor->RGBColor[0.87, 0.87, 0.87],
 CellChangeTimes->{3.3750111182355957`*^9},
 ParagraphSpacing->{1., 1.},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.411765],
 Background->RGBColor[1, 1, 1]],

Cell[TextData[{
 "\[Copyright] ",
 StyleBox[ButtonBox["Wolfram Demonstrations Project & Contributors",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->"http://demonstrations.wolfram.com/"],
  FontColor->GrayLevel[0.6]],
 "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
 StyleBox[ButtonBox["Terms of Use",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/termsofuse.html"], None},
  ButtonNote->"http://demonstrations.wolfram.com/termsofuse.html"],
  FontColor->GrayLevel[0.6]],
 "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
 StyleBox[ButtonBox["Make a new version of this Demonstration \
\[RightGuillemet]",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/participate/upload.jsp?id=\
InverseSquareLaws"], None},
  ButtonNote->None],
  FontColor->GrayLevel[0.6]]
}], "Text",
 CellFrame->{{0, 0}, {0, 0.5}},
 CellMargins->{{48, 10}, {20, 50}},
 CellFrameMargins->{{6, 0}, {6, 6}},
 CellFrameColor->GrayLevel[0.6],
 FontFamily->"Verdana",
 FontSize->9,
 FontColor->GrayLevel[0.6]]
}, Open  ]]
}, Open  ]]
},
Editable->True,
Saveable->False,
ScreenStyleEnvironment->"Working",
CellInsertionPointCell->None,
WindowSize->{745, 650},
WindowMargins->{{Inherited, Inherited}, {Inherited, 0}},
WindowElements->{
 "StatusArea", "MemoryMonitor", "MagnificationPopUp", "VerticalScrollBar", 
  "MenuBar"},
WindowTitle->"Inverse Square Laws - Source",
DockedCells->{},
CellContext->Notebook,
FrontEndVersion->"8.0 for Microsoft Windows (32-bit) (November 7, 2010)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[621, 23, 139, 3, 70, "Section"],
Cell[763, 28, 3700, 64, 70, "Section"],
Cell[4466, 94, 5759, 133, 70, "Input",
 CellID->1787967397]
}, Open  ]],
Cell[CellGroupData[{
Cell[10262, 232, 2796, 59, 70, "Output",
 CellID->199046993],
Cell[CellGroupData[{
Cell[13083, 295, 209, 6, 70, "Section"],
Cell[13295, 303, 272, 5, 70, "Text"]
}, Close]]
}, Open  ]],
Cell[CellGroupData[{
Cell[13615, 314, 355, 9, 70, "Text",
 CellGroupingRules->{"SectionGrouping", 25}],
Cell[13973, 325, 881, 24, 70, "Text"],
Cell[14857, 351, 466, 15, 70, "Text",
 CellID->1322003451],
Cell[CellGroupData[{
Cell[15348, 370, 815, 24, 70, "Text"],
Cell[16166, 396, 1189, 33, 70, "Text"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
(* NotebookSignature KRjBNk6S#7tg6ApobvJjIekv *)
