(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     23674,        598]
NotebookOptionsPosition[     22611,        559]
NotebookOutlinePosition[     23239,        583]
CellTagsIndexPosition[     23196,        580]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Fourier Synthesis for Selected Waveforms", "Section",
 CellFrameColor->RGBColor[
  0.6449835965514611, 0.758632791638056, 0.2516823071641108],
 FontColor->RGBColor[
  0.6449835965514611, 0.758632791638056, 0.2516823071641108]],

Cell[BoxData[
 RowBox[{"Manipulate", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Switch", "[", 
     RowBox[{"waveshape", ",", 
      RowBox[{"(*", " ", 
       RowBox[{
       "select", " ", "the", " ", "waveshape", " ", "based", " ", "on", " ", 
        "the", " ", "PopupMenu", " ", "value"}], " ", "*)"}], 
      "\[IndentingNewLine]", "\"\<sine\>\"", ",", 
      RowBox[{
       RowBox[{"a1", "=", "1"}], ";", 
       RowBox[{"a2", "=", "0"}], ";", 
       RowBox[{"a3", "=", "0"}], ";", 
       RowBox[{"a4", "=", "0"}], ";", 
       RowBox[{"a5", "=", "0"}], ";", 
       RowBox[{"a6", "=", "0"}], ";", 
       RowBox[{"a7", "=", "0"}], ";", 
       RowBox[{"a8", "=", "0"}], ";", 
       RowBox[{"a9", "=", "0"}]}], ",", "\[IndentingNewLine]", 
      "\"\<square\>\"", ",", 
      RowBox[{
       RowBox[{"a1", "=", "1"}], ";", 
       RowBox[{"a2", "=", "0"}], ";", 
       RowBox[{"a3", "=", 
        FractionBox["1", "3"]}], ";", 
       RowBox[{"a4", "=", "0"}], ";", 
       RowBox[{"a5", "=", 
        FractionBox["1", "5"]}], ";", 
       RowBox[{"a6", "=", "0"}], ";", 
       RowBox[{"a7", "=", 
        FractionBox["1", "7"]}], ";", 
       RowBox[{"a8", "=", "0"}], ";", 
       RowBox[{"a9", "=", 
        FractionBox["1", "9"]}]}], ",", "\[IndentingNewLine]", 
      "\"\<sawtooth\>\"", ",", 
      RowBox[{
       RowBox[{"a1", "=", "1"}], ";", 
       RowBox[{"a2", "=", 
        FractionBox["1", "2"]}], ";", 
       RowBox[{"a3", "=", 
        FractionBox["1", "3"]}], ";", 
       RowBox[{"a4", "=", 
        FractionBox["1", "4"]}], ";", 
       RowBox[{"a5", "=", 
        FractionBox["1", "5"]}], ";", 
       RowBox[{"a6", "=", 
        FractionBox["1", "6"]}], ";", 
       RowBox[{"a7", "=", 
        FractionBox["1", "7"]}], ";", 
       RowBox[{"a8", "=", 
        FractionBox["1", "8"]}], ";", 
       RowBox[{"a9", "=", 
        FractionBox["1", "9"]}]}], ",", "\[IndentingNewLine]", 
      "\"\<triangle\>\"", ",", 
      RowBox[{
       RowBox[{"a1", "=", "1"}], ";", 
       RowBox[{"a2", "=", 
        FractionBox["1", 
         SuperscriptBox["2", "2"]]}], ";", 
       RowBox[{"a3", "=", 
        FractionBox["1", 
         SuperscriptBox["3", "2"]]}], ";", 
       RowBox[{"a4", "=", 
        FractionBox["1", 
         SuperscriptBox["4", "2"]]}], ";", 
       RowBox[{"a5", "=", 
        FractionBox["1", 
         SuperscriptBox["5", "2"]]}], ";", 
       RowBox[{"a6", "=", 
        FractionBox["1", 
         SuperscriptBox["6", "2"]]}], ";", 
       RowBox[{"a7", "=", 
        FractionBox["1", 
         SuperscriptBox["7", "2"]]}], ";", 
       RowBox[{"a8", "=", 
        FractionBox["1", 
         SuperscriptBox["8", "2"]]}], ";", 
       RowBox[{"a9", "=", 
        FractionBox["1", 
         SuperscriptBox["9", "2"]]}]}], ",", "\[IndentingNewLine]", 
      "\"\<user\>\"", ",", "Null"}], " ", 
     RowBox[{"(*", " ", 
      RowBox[{
       RowBox[{"allow", " ", "user"}], "-", 
       RowBox[{"control", " ", "--"}], "-", " ", 
       RowBox[{"no", " ", "preset", " ", "values"}]}], " ", "*)"}], "]"}], 
    ";", "\[IndentingNewLine]", 
    RowBox[{"(*", " ", 
     RowBox[{
      RowBox[{"with", " ", "the", " ", "amplitudes", " ", "set"}], ",", " ", 
      RowBox[{"plot", " ", "the", " ", "resulting", " ", "waveform"}]}], " ", 
     "*)"}], "\[IndentingNewLine]", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"a1", " ", 
        RowBox[{"Sin", "[", "x", "]"}]}], "+", 
       RowBox[{"a2", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"2", "x"}], "]"}]}], "+", 
       RowBox[{"a3", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"3", "x"}], "]"}]}], "+", 
       RowBox[{"a4", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"4", "x"}], "]"}]}], "+", 
       RowBox[{"a5", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"5", "x"}], "]"}]}], "+", 
       RowBox[{"a6", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"6", "x"}], "]"}]}], "+", 
       RowBox[{"a7", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"7", "x"}], "]"}]}], "+", 
       RowBox[{"a8", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"8", "x"}], "]"}]}], "+", 
       RowBox[{"a9", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"9", "x"}], "]"}]}]}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "0", ",", 
        RowBox[{"4", "\[Pi]"}]}], "}"}], ",", 
      RowBox[{"PlotRange", "\[Rule]", "All"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", "Thick"}], ",", 
      RowBox[{"Ticks", "\[Rule]", "None"}], ",", 
      RowBox[{"ImageSize", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"400", ",", "300"}], "}"}]}]}], "]"}]}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"setup", " ", "the", " ", "controls"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"waveshape", ",", "\"\<sine\>\"", ",", "\"\<waveform\>\""}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "\"\<sine\>\"", ",", "\"\<square\>\"", ",", "\"\<sawtooth\>\"", ",", 
       "\"\<triangle\>\"", ",", "\"\<user-defined\>\""}], "}"}], ",", 
     RowBox[{"ControlType", "\[Rule]", "PopupMenu"}]}], "}"}], ",", 
   "\[IndentingNewLine]", "Delimiter", ",", "\[IndentingNewLine]", 
   RowBox[{"Style", "[", 
    RowBox[{"\"\<harmonics\>\"", ",", "Bold"}], "]"}], ",", 
   "\[IndentingNewLine]", 
   "\"\<enabled when waveform\\nis \\\"user-defined\\\":\\n\>\"", ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a1", ",", "1", ",", "\"\<fundamental\>\""}], "}"}], ",", "0", 
     ",", "1", ",", 
     RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "Tiny"}], ",", 
     RowBox[{"Enabled", "\[Rule]", 
      RowBox[{"waveshape", "===", "\"\<user-defined\>\""}]}]}], "}"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a2", ",", "0", ",", "\"\<2nd\>\""}], "}"}], ",", "0", ",", "1",
      ",", 
     RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "Tiny"}], ",", 
     RowBox[{"Enabled", "\[Rule]", 
      RowBox[{"waveshape", "===", "\"\<user-defined\>\""}]}]}], "}"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a3", ",", "0", ",", "\"\<3rd\>\""}], "}"}], ",", "0", ",", "1",
      ",", 
     RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "Tiny"}], ",", 
     RowBox[{"Enabled", "\[Rule]", 
      RowBox[{"waveshape", "===", "\"\<user-defined\>\""}]}]}], "}"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a4", ",", "0", ",", "\"\<4th\>\""}], "}"}], ",", "0", ",", "1",
      ",", 
     RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "Tiny"}], ",", 
     RowBox[{"Enabled", "\[Rule]", 
      RowBox[{"waveshape", "===", "\"\<user-defined\>\""}]}]}], "}"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a5", ",", "0", ",", "\"\<5th\>\""}], "}"}], ",", "0", ",", "1",
      ",", 
     RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "Tiny"}], ",", 
     RowBox[{"Enabled", "\[Rule]", 
      RowBox[{"waveshape", "===", "\"\<user-defined\>\""}]}]}], "}"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a6", ",", "0", ",", "\"\<6th\>\""}], "}"}], ",", "0", ",", "1",
      ",", 
     RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "Tiny"}], ",", 
     RowBox[{"Enabled", "\[Rule]", 
      RowBox[{"waveshape", "===", "\"\<user-defined\>\""}]}]}], "}"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a7", ",", "0", ",", "\"\<7th\>\""}], "}"}], ",", "0", ",", "1",
      ",", 
     RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "Tiny"}], ",", 
     RowBox[{"Enabled", "\[Rule]", 
      RowBox[{"waveshape", "===", "\"\<user-defined\>\""}]}]}], "}"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a8", ",", "0", ",", "\"\<8th\>\""}], "}"}], ",", "0", ",", "1",
      ",", 
     RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "Tiny"}], ",", 
     RowBox[{"Enabled", "\[Rule]", 
      RowBox[{"waveshape", "===", "\"\<user-defined\>\""}]}]}], "}"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a9", ",", "0", ",", "\"\<9th\>\""}], "}"}], ",", "0", ",", "1",
      ",", 
     RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "Tiny"}], ",", 
     RowBox[{"Enabled", "\[Rule]", 
      RowBox[{"waveshape", "===", "\"\<user-defined\>\""}]}]}], "}"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"AutorunSequencing", "\[Rule]", 
    RowBox[{"{", "1", "}"}]}]}], "\[IndentingNewLine]", "]"}]], "Input",
 CellChangeTimes->{
  3.35696210375764*^9, {3.429396701671875*^9, 3.4293967295*^9}, {
   3.429399180546875*^9, 3.4293993559375*^9}, {3.429399401484375*^9, 
   3.429399437359375*^9}, {3.429399588046875*^9, 3.42939969615625*^9}, {
   3.429399733625*^9, 3.4293997826875*^9}, {3.42939981759375*^9, 
   3.429399883015625*^9}, {3.4293999203125*^9, 3.429399980984375*^9}, {
   3.42940009209375*^9, 3.429400397625*^9}, 3.42940045365625*^9, {
   3.429400573625*^9, 3.429400659703125*^9}, {3.4294008140625*^9, 
   3.429400835296875*^9}, {3.429400969578125*^9, 3.429400989046875*^9}, {
   3.429401402046875*^9, 3.429401450875*^9}, {3.42940148821875*^9, 
   3.429401563578125*^9}, {3.4294572296624117`*^9, 3.4294572714105864`*^9}, {
   3.4294573225547*^9, 3.429457442707714*^9}, {3.429463884428878*^9, 
   3.4294639333507533`*^9}, {3.4294640616320033`*^9, 
   3.4294640796320033`*^9}, {3.429469902795584*^9, 3.4294700239677*^9}, {
   3.429545752791993*^9, 3.4295457602327366`*^9}}]
}, Open  ]],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`a1$$ = 1, $CellContext`a2$$ = 
    0, $CellContext`a3$$ = 0, $CellContext`a4$$ = 0, $CellContext`a5$$ = 
    0, $CellContext`a6$$ = 0, $CellContext`a7$$ = 0, $CellContext`a8$$ = 
    0, $CellContext`a9$$ = 0, $CellContext`waveshape$$ = "sine", 
    Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
    Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
    1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`waveshape$$], "sine", "waveform"}, {
      "sine", "square", "sawtooth", "triangle", "user-defined"}}, {
      Hold[
       Style["harmonics", Bold]], Manipulate`Dump`ThisIsNotAControl}, {
      Hold["enabled when waveform\nis \"user-defined\":\n"], 
      Manipulate`Dump`ThisIsNotAControl}, {{
       Hold[$CellContext`a1$$], 1, "fundamental"}, 0, 1}, {{
       Hold[$CellContext`a2$$], 0, "2nd"}, 0, 1}, {{
       Hold[$CellContext`a3$$], 0, "3rd"}, 0, 1}, {{
       Hold[$CellContext`a4$$], 0, "4th"}, 0, 1}, {{
       Hold[$CellContext`a5$$], 0, "5th"}, 0, 1}, {{
       Hold[$CellContext`a6$$], 0, "6th"}, 0, 1}, {{
       Hold[$CellContext`a7$$], 0, "7th"}, 0, 1}, {{
       Hold[$CellContext`a8$$], 0, "8th"}, 0, 1}, {{
       Hold[$CellContext`a9$$], 0, "9th"}, 0, 1}}, Typeset`size$$ = {
    400., {148., 152.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True, $CellContext`waveshape$2278871$$ = 
    0, $CellContext`a1$2278872$$ = 0, $CellContext`a2$2278873$$ = 
    0, $CellContext`a3$2278874$$ = 0, $CellContext`a4$2278875$$ = 
    0, $CellContext`a5$2278876$$ = 0, $CellContext`a6$2278877$$ = 
    0, $CellContext`a7$2278878$$ = 0, $CellContext`a8$2278879$$ = 
    0, $CellContext`a9$2278880$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`a1$$ = 1, $CellContext`a2$$ = 
        0, $CellContext`a3$$ = 0, $CellContext`a4$$ = 0, $CellContext`a5$$ = 
        0, $CellContext`a6$$ = 0, $CellContext`a7$$ = 0, $CellContext`a8$$ = 
        0, $CellContext`a9$$ = 0, $CellContext`waveshape$$ = "sine"}, 
      "ControllerVariables" :> {
        Hold[$CellContext`waveshape$$, $CellContext`waveshape$2278871$$, 0], 
        Hold[$CellContext`a1$$, $CellContext`a1$2278872$$, 0], 
        Hold[$CellContext`a2$$, $CellContext`a2$2278873$$, 0], 
        Hold[$CellContext`a3$$, $CellContext`a3$2278874$$, 0], 
        Hold[$CellContext`a4$$, $CellContext`a4$2278875$$, 0], 
        Hold[$CellContext`a5$$, $CellContext`a5$2278876$$, 0], 
        Hold[$CellContext`a6$$, $CellContext`a6$2278877$$, 0], 
        Hold[$CellContext`a7$$, $CellContext`a7$2278878$$, 0], 
        Hold[$CellContext`a8$$, $CellContext`a8$2278879$$, 0], 
        Hold[$CellContext`a9$$, $CellContext`a9$2278880$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, 
      "Body" :> (
       Switch[$CellContext`waveshape$$, 
         "sine", $CellContext`a1$$ = 1; $CellContext`a2$$ = 
          0; $CellContext`a3$$ = 0; $CellContext`a4$$ = 0; $CellContext`a5$$ = 
          0; $CellContext`a6$$ = 0; $CellContext`a7$$ = 0; $CellContext`a8$$ = 
          0; $CellContext`a9$$ = 0, 
         "square", $CellContext`a1$$ = 1; $CellContext`a2$$ = 
          0; $CellContext`a3$$ = 1/3; $CellContext`a4$$ = 
          0; $CellContext`a5$$ = 1/5; $CellContext`a6$$ = 
          0; $CellContext`a7$$ = 1/7; $CellContext`a8$$ = 
          0; $CellContext`a9$$ = 1/9, 
         "sawtooth", $CellContext`a1$$ = 1; $CellContext`a2$$ = 
          1/2; $CellContext`a3$$ = 1/3; $CellContext`a4$$ = 
          1/4; $CellContext`a5$$ = 1/5; $CellContext`a6$$ = 
          1/6; $CellContext`a7$$ = 1/7; $CellContext`a8$$ = 
          1/8; $CellContext`a9$$ = 1/9, 
         "triangle", $CellContext`a1$$ = 1; $CellContext`a2$$ = 
          1/2^2; $CellContext`a3$$ = 1/3^2; $CellContext`a4$$ = 
          1/4^2; $CellContext`a5$$ = 1/5^2; $CellContext`a6$$ = 
          1/6^2; $CellContext`a7$$ = 1/7^2; $CellContext`a8$$ = 
          1/8^2; $CellContext`a9$$ = 1/9^2, "user", Null]; 
       Plot[$CellContext`a1$$ Sin[$CellContext`x] + $CellContext`a2$$ 
          Sin[2 $CellContext`x] + $CellContext`a3$$ 
          Sin[3 $CellContext`x] + $CellContext`a4$$ 
          Sin[4 $CellContext`x] + $CellContext`a5$$ 
          Sin[5 $CellContext`x] + $CellContext`a6$$ 
          Sin[6 $CellContext`x] + $CellContext`a7$$ 
          Sin[7 $CellContext`x] + $CellContext`a8$$ 
          Sin[8 $CellContext`x] + $CellContext`a9$$ 
          Sin[9 $CellContext`x], {$CellContext`x, 0, 4 Pi}, PlotRange -> All, 
         PlotStyle -> Thick, Ticks -> None, ImageSize -> {400, 300}]), 
      "Specifications" :> {{{$CellContext`waveshape$$, "sine", "waveform"}, {
         "sine", "square", "sawtooth", "triangle", "user-defined"}, 
         ControlType -> PopupMenu}, Delimiter, 
        Style["harmonics", Bold], 
        "enabled when waveform\nis \"user-defined\":\n", {{$CellContext`a1$$, 
          1, "fundamental"}, 0, 1, Appearance -> "Labeled", ImageSize -> Tiny,
          Enabled -> 
         Dynamic[$CellContext`waveshape$$ === 
           "user-defined"]}, {{$CellContext`a2$$, 0, "2nd"}, 0, 1, Appearance -> 
         "Labeled", ImageSize -> Tiny, Enabled -> 
         Dynamic[$CellContext`waveshape$$ === 
           "user-defined"]}, {{$CellContext`a3$$, 0, "3rd"}, 0, 1, Appearance -> 
         "Labeled", ImageSize -> Tiny, Enabled -> 
         Dynamic[$CellContext`waveshape$$ === 
           "user-defined"]}, {{$CellContext`a4$$, 0, "4th"}, 0, 1, Appearance -> 
         "Labeled", ImageSize -> Tiny, Enabled -> 
         Dynamic[$CellContext`waveshape$$ === 
           "user-defined"]}, {{$CellContext`a5$$, 0, "5th"}, 0, 1, Appearance -> 
         "Labeled", ImageSize -> Tiny, Enabled -> 
         Dynamic[$CellContext`waveshape$$ === 
           "user-defined"]}, {{$CellContext`a6$$, 0, "6th"}, 0, 1, Appearance -> 
         "Labeled", ImageSize -> Tiny, Enabled -> 
         Dynamic[$CellContext`waveshape$$ === 
           "user-defined"]}, {{$CellContext`a7$$, 0, "7th"}, 0, 1, Appearance -> 
         "Labeled", ImageSize -> Tiny, Enabled -> 
         Dynamic[$CellContext`waveshape$$ === 
           "user-defined"]}, {{$CellContext`a8$$, 0, "8th"}, 0, 1, Appearance -> 
         "Labeled", ImageSize -> Tiny, Enabled -> 
         Dynamic[$CellContext`waveshape$$ === 
           "user-defined"]}, {{$CellContext`a9$$, 0, "9th"}, 0, 1, Appearance -> 
         "Labeled", ImageSize -> Tiny, Enabled -> 
         Dynamic[$CellContext`waveshape$$ === "user-defined"]}}, 
      "Options" :> {AutorunSequencing -> {1}}, 
      "DefaultOptions" :> {ControllerLinking -> True}],
     ImageSizeCache->{626., {175., 180.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellID->87807621],

Cell[CellGroupData[{

Cell["THIS NOTEBOOK IS THE SOURCE CODE FROM", "Text",
 CellFrame->{{0, 0}, {0, 1}},
 CellMargins->{{48, 10}, {4, 28}},
 CellGroupingRules->{"SectionGrouping", 25},
 CellFrameMargins->{{48, 48}, {6, 5}},
 CellFrameColor->RGBColor[0.691905, 0.790311, 0.300252],
 FontFamily->"Helvetica",
 FontSize->10,
 FontWeight->"Bold",
 FontColor->RGBColor[0.691905, 0.790311, 0.300252]],

Cell[TextData[{
 "\"",
 ButtonBox["Fourier Synthesis for Selected Waveforms",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/\
FourierSynthesisForSelectedWaveforms/"], None},
  ButtonNote->
   "http://demonstrations.wolfram.com/FourierSynthesisForSelectedWaveforms/"],\

 "\"",
 " from ",
 ButtonBox["The Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->"http://demonstrations.wolfram.com/"],
 "\[ParagraphSeparator]\[NonBreakingSpace]",
 ButtonBox["http://demonstrations.wolfram.com/\
FourierSynthesisForSelectedWaveforms/",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/\
FourierSynthesisForSelectedWaveforms/"], None},
  ButtonNote->
   "http://demonstrations.wolfram.com/FourierSynthesisForSelectedWaveforms/"]
}], "Text",
 CellMargins->{{48, Inherited}, {0, Inherited}},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.5]],

Cell[" ", "Text",
 CellFrame->{{0, 0}, {0, 1}},
 CellMargins->{{48, 10}, {4, 28}},
 CellGroupingRules->{"SectionGrouping", 25},
 CellFrameMargins->{{48, 48}, {6, 5}},
 CellFrameColor->RGBColor[0.691905, 0.790311, 0.300252],
 FontFamily->"Helvetica",
 FontSize->10,
 FontWeight->"Bold",
 FontColor->RGBColor[0.691905, 0.790311, 0.300252]],

Cell[TextData[{
 "Contributed by: ",
 ButtonBox["Kenny F. Stephens II",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/author.html?author=Kenny+F.+\
Stephens+II"], None},
  ButtonNote->
   "http://demonstrations.wolfram.com/author.html?author=Kenny+F.+Stephens+\
II"]
}], "Text",
 CellDingbat->"\[FilledSmallSquare]",
 CellMargins->{{66, 48}, {2, 4}},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.6]],

Cell[CellGroupData[{

Cell[TextData[{
 "A full-function Wolfram ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " 6 system is required to edit this notebook.\n",
 StyleBox[ButtonBox["GET WOLFRAM MATHEMATICA 6 \[RightGuillemet]",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolfram.com/products/mathematica/"], None},
  ButtonNote->"http://www.wolfram.com/products/mathematica/"],
  FontFamily->"Helvetica",
  FontWeight->"Bold",
  FontSlant->"Italic",
  FontColor->RGBColor[1, 0.42, 0]]
}], "Text",
 CellFrame->True,
 CellMargins->{{48, 68}, {8, 28}},
 CellFrameMargins->12,
 CellFrameColor->RGBColor[0.865507, 0.90634, 0.680751],
 CellChangeTimes->{3.3750111182355957`*^9},
 ParagraphSpacing->{1., 1.},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.411765],
 Background->RGBColor[0.986023, 0.991363, 0.969818]],

Cell[TextData[{
 "\[Copyright] ",
 StyleBox[ButtonBox["The Wolfram Demonstrations Project & Contributors",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->"http://demonstrations.wolfram.com/"],
  FontColor->GrayLevel[0.6]],
 "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
 StyleBox[ButtonBox["Terms of Use",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/termsofuse.html"], None},
  ButtonNote->"http://demonstrations.wolfram.com/termsofuse.html"],
  FontColor->GrayLevel[0.6]],
 "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
 StyleBox[ButtonBox["Make a new version of this Demonstration \
\[RightGuillemet]",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/participate/upload.jsp?id=\
FourierSynthesisForSelectedWaveforms"], None},
  ButtonNote->None],
  FontColor->GrayLevel[0.6]]
}], "Text",
 CellFrame->{{0, 0}, {0, 0.5}},
 CellMargins->{{48, 10}, {20, 50}},
 CellFrameMargins->{{6, 0}, {6, 6}},
 CellFrameColor->GrayLevel[0.6],
 FontFamily->"Verdana",
 FontSize->9,
 FontColor->GrayLevel[0.6]]
}, Open  ]]
}, Open  ]]
},
Editable->True,
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{780, 650},
WindowMargins->{{Inherited, Inherited}, {Inherited, 0}},
WindowElements->{
 "StatusArea", "MemoryMonitor", "MagnificationPopUp", "VerticalScrollBar", 
  "MenuBar"},
WindowTitle->"Fourier Synthesis for Selected Waveforms - Source",
DockedCells->{},
CellContext->Notebook,
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (May 21, 2008)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[590, 23, 232, 4, 70, "Section"],
Cell[825, 29, 10158, 258, 70, "Input"]
}, Open  ]],
Cell[10998, 290, 7303, 129, 70, "Output",
 CellID->87807621],
Cell[CellGroupData[{
Cell[18326, 423, 373, 9, 70, "Text",
 CellGroupingRules->{"SectionGrouping", 25}],
Cell[18702, 434, 1013, 30, 70, "Text"],
Cell[19718, 466, 337, 9, 70, "Text",
 CellGroupingRules->{"SectionGrouping", 25}],
Cell[20058, 477, 456, 15, 70, "Text"],
Cell[CellGroupData[{
Cell[20539, 496, 829, 24, 70, "Text"],
Cell[21371, 522, 1212, 33, 70, "Text"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
(* NotebookSignature 7Q4#QEH8z9Lr0BTun7sQyxDG *)
