(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     94811,       2200]
NotebookOptionsPosition[     93331,       2146]
NotebookOutlinePosition[     94005,       2171]
CellTagsIndexPosition[     93962,       2168]
WindowTitle->Fixation and Distraction (Visual Depth Perception 5) - Source
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Fixation and Distraction (Visual Depth Perception 5)", "Section",
 CellFrame->{{0, 0}, {0, 0}},
 ShowCellBracket->False,
 FontColor->RGBColor[0.597406, 0, 0.0527047]],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztnVuSozgWQDNiPqa3MJ+zpVlCbaB3WlGVNV9dvYH6TQRUph/ZGIHQmwvG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   "], {{0, 0}, {1800, 25}}, {0, 255},
   ColorFunction->RGBColor],
  ImageSize->{1800, 25},
  PlotRange->{{0, 1800}, {0, 25}}]], "Section",
 CellFrame->{{0, 0}, {0, 0}},
 ShowCellBracket->False],

Cell[BoxData[
 RowBox[{"Manipulate", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "nORM", ",", "degrees", ",", "arcMinutes", ",", "aim\[Psi]", ",", 
       "midPoint", ",", "rightEyeCenter", ",", "aimOffset", ",", 
       "interOcular", ",", "leftEyeCenter", ",", "rightViewVector", ",", 
       "right\[CurlyPhi]", ",", "rightEyeNode", ",", "nodePercent", ",", 
       "eyeRadius", ",", "leftViewVector", ",", "left\[CurlyPhi]", ",", 
       "leftEyeNode", ",", "fixateConvergence", ",", "left\[Alpha]", ",", 
       "right\[Alpha]", ",", "rightDistractVector", ",", "right\[Delta]", ",",
        "leftDistractVector", ",", "left\[Delta]", ",", 
       "convergenceDistraction", ",", "right\[Theta]", ",", "left\[Theta]", 
       ",", "right\[Theta]inside", ",", "left\[Theta]inside", ",", 
       "retinalDisparity", ",", "eyePict", ",", "eyeEdge", ",", "inRays", ",",
        "min", ",", "MAX", ",", "outRays", ",", "headAimVector"}], "}"}], ",",
      "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"nORM", "[", 
        RowBox[{"vector_", "?", "VectorQ"}], "]"}], ":=", 
       SqrtBox[
        RowBox[{"vector", ".", "vector"}]]}], ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"degrees", "[", "q_", "]"}], ":=", 
       RowBox[{"q", "*", 
        RowBox[{"180", "/", "\[Pi]"}]}]}], ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"arcMinutes", "[", "q_", "]"}], ":=", 
       RowBox[{"q", "*", "60", "*", 
        RowBox[{"180", "/", "\[Pi]"}]}]}], ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"aim\[Psi]", "[", 
        RowBox[{
         RowBox[{"headAimVector_", "?", "VectorQ"}], ",", 
         RowBox[{"base_", "?", "VectorQ"}]}], "]"}], ":=", 
       RowBox[{"ArcTan", "[", 
        RowBox[{
         RowBox[{"headAimVector", "[", 
          RowBox[{"[", "1", "]"}], "]"}], ",", 
         RowBox[{"headAimVector", "[", 
          RowBox[{"[", "2", "]"}], "]"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"midPoint", "[", 
        RowBox[{
         RowBox[{"headAimVector_", "?", "VectorQ"}], ",", 
         RowBox[{"base_", "?", "VectorQ"}]}], "]"}], ":=", 
       RowBox[{"base", "-", 
        RowBox[{"aimOffset", "*", "interOcular", "*", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"headAimVector", "[", 
            RowBox[{"[", "2", "]"}], "]"}], ",", 
           RowBox[{"-", 
            RowBox[{"headAimVector", "[", 
             RowBox[{"[", "1", "]"}], "]"}]}]}], "}"}]}]}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"rightEyeCenter", "[", 
        RowBox[{
         RowBox[{"headAimVector_", "?", "VectorQ"}], ",", 
         RowBox[{"base_", "?", "VectorQ"}]}], "]"}], ":=", 
       RowBox[{"base", "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           FractionBox["1", "2"], "-", "aimOffset"}], ")"}], "*", 
         "interOcular", "*", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"headAimVector", "[", 
            RowBox[{"[", "2", "]"}], "]"}], ",", 
           RowBox[{"-", 
            RowBox[{"headAimVector", "[", 
             RowBox[{"[", "1", "]"}], "]"}]}]}], "}"}]}]}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"leftEyeCenter", "[", 
        RowBox[{
         RowBox[{"headAimVector_", "?", "VectorQ"}], ",", 
         RowBox[{"base_", "?", "VectorQ"}]}], "]"}], ":=", 
       RowBox[{"base", "-", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           FractionBox["1", "2"], "+", "aimOffset"}], ")"}], "*", 
         "interOcular", "*", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"headAimVector", "[", 
            RowBox[{"[", "2", "]"}], "]"}], ",", 
           RowBox[{"-", 
            RowBox[{"headAimVector", "[", 
             RowBox[{"[", "1", "]"}], "]"}]}]}], "}"}]}]}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"rightViewVector", "[", 
        RowBox[{
         RowBox[{"headAimVector_", "?", "VectorQ"}], ",", 
         RowBox[{"fixate_", "?", "VectorQ"}], ",", 
         RowBox[{"base_", "?", "VectorQ"}]}], "]"}], ":=", 
       RowBox[{"fixate", "-", 
        RowBox[{"rightEyeCenter", "[", 
         RowBox[{"headAimVector", ",", " ", "base"}], "]"}]}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"right\[CurlyPhi]", "[", 
        RowBox[{
         RowBox[{"headAimVector_", "?", "VectorQ"}], ",", 
         RowBox[{"fixate_", "?", "VectorQ"}], ",", 
         RowBox[{"base_", "?", "VectorQ"}]}], "]"}], ":=", 
       RowBox[{"ArcTan", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"rightViewVector", "[", 
           RowBox[{"headAimVector", ",", " ", "fixate", ",", " ", "base"}], 
           "]"}], "[", 
          RowBox[{"[", "1", "]"}], "]"}], ",", 
         RowBox[{
          RowBox[{"rightViewVector", "[", 
           RowBox[{"headAimVector", ",", " ", "fixate", ",", " ", "base"}], 
           "]"}], "[", 
          RowBox[{"[", "2", "]"}], "]"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"rightEyeNode", "[", 
        RowBox[{
         RowBox[{"headAimVector_", "?", "VectorQ"}], ",", 
         RowBox[{"fixate_", "?", "VectorQ"}], ",", 
         RowBox[{"base_", "?", "VectorQ"}]}], "]"}], ":=", 
       RowBox[{
        RowBox[{"rightEyeCenter", "[", 
         RowBox[{"headAimVector", ",", " ", "base"}], "]"}], "+", 
        RowBox[{"nodePercent", "*", "eyeRadius", "*", 
         RowBox[{
          RowBox[{"rightViewVector", "[", 
           RowBox[{"headAimVector", ",", "fixate", ",", " ", "base"}], "]"}], 
          "/", 
          RowBox[{"nORM", "[", 
           RowBox[{"rightViewVector", "[", 
            RowBox[{"headAimVector", ",", " ", "fixate", ",", " ", "base"}], 
            "]"}], "]"}]}]}]}]}], ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"leftViewVector", "[", 
        RowBox[{
         RowBox[{"headAimVector_", "?", "VectorQ"}], ",", 
         RowBox[{"fixate_", "?", "VectorQ"}], ",", 
         RowBox[{"base_", "?", "VectorQ"}]}], "]"}], ":=", 
       RowBox[{"fixate", "-", 
        RowBox[{"leftEyeCenter", "[", 
         RowBox[{"headAimVector", ",", " ", "base"}], "]"}]}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"left\[CurlyPhi]", "[", 
        RowBox[{
         RowBox[{"headAimVector_", "?", "VectorQ"}], ",", 
         RowBox[{"fixate_", "?", "VectorQ"}], ",", 
         RowBox[{"base_", "?", "VectorQ"}]}], "]"}], ":=", 
       RowBox[{"ArcTan", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"leftViewVector", "[", 
           RowBox[{"headAimVector", ",", " ", "fixate", ",", " ", "base"}], 
           "]"}], "[", 
          RowBox[{"[", "1", "]"}], "]"}], ",", 
         RowBox[{
          RowBox[{"leftViewVector", "[", 
           RowBox[{"headAimVector", ",", " ", "fixate", ",", " ", "base"}], 
           "]"}], "[", 
          RowBox[{"[", "2", "]"}], "]"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"leftEyeNode", "[", 
        RowBox[{
         RowBox[{"headAimVector_", "?", "VectorQ"}], ",", 
         RowBox[{"fixate_", "?", "VectorQ"}], ",", 
         RowBox[{"base_", "?", "VectorQ"}]}], "]"}], ":=", 
       RowBox[{
        RowBox[{"leftEyeCenter", "[", 
         RowBox[{"headAimVector", ",", " ", "base"}], "]"}], "+", 
        RowBox[{"nodePercent", "*", "eyeRadius", "*", 
         RowBox[{
          RowBox[{"leftViewVector", "[", 
           RowBox[{"headAimVector", ",", " ", "fixate", ",", " ", "base"}], 
           "]"}], "/", 
          RowBox[{"nORM", "[", 
           RowBox[{"leftViewVector", "[", 
            RowBox[{"headAimVector", ",", " ", "fixate", ",", " ", "base"}], 
            "]"}], "]"}]}]}]}]}], ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"fixateConvergence", "[", 
        RowBox[{
         RowBox[{"headAimVector_", "?", "VectorQ"}], ",", 
         RowBox[{"fixate_", "?", "VectorQ"}], ",", 
         RowBox[{"base_", "?", "VectorQ"}]}], "]"}], ":=", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"right\[CurlyPhi]", "[", 
          RowBox[{"headAimVector", ",", "fixate", ",", "base"}], "]"}], "-", 
         RowBox[{"left\[CurlyPhi]", "[", 
          RowBox[{"headAimVector", ",", "fixate", ",", "base"}], "]"}]}], 
        ")"}]}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"left\[Alpha]", "[", 
        RowBox[{
         RowBox[{"headAimVector_", "?", "VectorQ"}], ",", 
         RowBox[{"fixate_", "?", "VectorQ"}], ",", 
         RowBox[{"base_", "?", "VectorQ"}]}], "]"}], ":=", 
       RowBox[{
        RowBox[{"left\[CurlyPhi]", "[", 
         RowBox[{"headAimVector", ",", "fixate", ",", "base"}], "]"}], "-", 
        RowBox[{"aim\[Psi]", "[", 
         RowBox[{"headAimVector", ",", "base"}], "]"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"right\[Alpha]", "[", 
        RowBox[{
         RowBox[{"headAimVector_", "?", "VectorQ"}], ",", 
         RowBox[{"fixate_", "?", "VectorQ"}], ",", 
         RowBox[{"base_", "?", "VectorQ"}]}], "]"}], ":=", 
       RowBox[{
        RowBox[{"right\[CurlyPhi]", "[", 
         RowBox[{"headAimVector", ",", "fixate", ",", "base"}], "]"}], "-", 
        RowBox[{"aim\[Psi]", "[", 
         RowBox[{"headAimVector", ",", "base"}], "]"}]}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"rightDistractVector", "[", 
        RowBox[{
         RowBox[{"headAimVector_", "?", "VectorQ"}], ",", 
         RowBox[{"fixate_", "?", "VectorQ"}], ",", 
         RowBox[{"distraction_", "?", "VectorQ"}], ",", 
         RowBox[{"base_", "?", "VectorQ"}]}], "]"}], ":=", 
       RowBox[{"distraction", "-", 
        RowBox[{"rightEyeNode", "[", 
         RowBox[{"headAimVector", ",", "fixate", ",", " ", "base"}], 
         "]"}]}]}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"right\[Delta]", "[", 
        RowBox[{
         RowBox[{"headAimVector_", "?", "VectorQ"}], ",", 
         RowBox[{"fixate_", "?", "VectorQ"}], ",", 
         RowBox[{"distraction_", "?", "VectorQ"}], ",", 
         RowBox[{"base_", "?", "VectorQ"}]}], "]"}], ":=", 
       RowBox[{"ArcTan", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"rightDistractVector", "[", 
           RowBox[{
           "headAimVector", ",", "fixate", ",", "distraction", ",", "base"}], 
           "]"}], "[", 
          RowBox[{"[", "1", "]"}], "]"}], ",", 
         RowBox[{
          RowBox[{"rightDistractVector", "[", 
           RowBox[{
           "headAimVector", ",", "fixate", ",", "distraction", ",", "base"}], 
           "]"}], "[", 
          RowBox[{"[", "2", "]"}], "]"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"leftDistractVector", "[", 
        RowBox[{
         RowBox[{"headAimVector_", "?", "VectorQ"}], ",", 
         RowBox[{"fixate_", "?", "VectorQ"}], ",", 
         RowBox[{"distraction_", "?", "VectorQ"}], ",", 
         RowBox[{"base_", "?", "VectorQ"}]}], "]"}], ":=", 
       RowBox[{"distraction", "-", 
        RowBox[{"leftEyeNode", "[", 
         RowBox[{"headAimVector", ",", "fixate", ",", " ", "base"}], 
         "]"}]}]}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"left\[Delta]", "[", 
        RowBox[{
         RowBox[{"headAimVector_", "?", "VectorQ"}], ",", 
         RowBox[{"fixate_", "?", "VectorQ"}], ",", 
         RowBox[{"distraction_", "?", "VectorQ"}], ",", 
         RowBox[{"base_", "?", "VectorQ"}]}], "]"}], ":=", 
       RowBox[{"ArcTan", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"leftDistractVector", "[", 
           RowBox[{
           "headAimVector", ",", "fixate", ",", "distraction", ",", "base"}], 
           "]"}], "[", 
          RowBox[{"[", "1", "]"}], "]"}], ",", 
         RowBox[{
          RowBox[{"leftDistractVector", "[", 
           RowBox[{
           "headAimVector", ",", "fixate", ",", "distraction", ",", "base"}], 
           "]"}], "[", 
          RowBox[{"[", "2", "]"}], "]"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"convergenceDistraction", "[", 
        RowBox[{
         RowBox[{"headAimVector_", "?", "VectorQ"}], ",", 
         RowBox[{"fixate_", "?", "VectorQ"}], ",", 
         RowBox[{"distraction_", "?", "VectorQ"}], ",", 
         RowBox[{"base_", "?", "VectorQ"}]}], "]"}], ":=", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"Or", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"Abs", "[", 
             RowBox[{
              RowBox[{"left\[CurlyPhi]", "[", 
               RowBox[{"headAimVector", ",", "fixate", ",", " ", "base"}], 
               "]"}], "-", 
              RowBox[{"left\[Delta]", "[", 
               RowBox[{
               "headAimVector", ",", "fixate", ",", " ", "distraction", ",", 
                "base"}], "]"}]}], "]"}], ">", 
            RowBox[{"\[Pi]", "/", "3."}]}], ",", 
           RowBox[{
            RowBox[{"Abs", "[", 
             RowBox[{
              RowBox[{"right\[CurlyPhi]", "[", 
               RowBox[{"headAimVector", ",", "fixate", ",", " ", "base"}], 
               "]"}], "-", 
              RowBox[{"right\[Delta]", "[", 
               RowBox[{
               "headAimVector", ",", "fixate", ",", " ", "distraction", ",", 
                "base"}], "]"}]}], "]"}], ">", 
            RowBox[{"\[Pi]", "/", "3."}]}]}], "]"}], ",", "0.0", ",", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"right\[Delta]", "[", 
            RowBox[{
            "headAimVector", ",", "fixate", ",", " ", "distraction", ",", 
             "base"}], "]"}], "-", 
           RowBox[{"left\[Delta]", "[", 
            RowBox[{
            "headAimVector", ",", "fixate", ",", " ", "distraction", ",", 
             "base"}], "]"}]}], ")"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"right\[Theta]", "[", 
        RowBox[{
         RowBox[{"headAimVector_", "?", "VectorQ"}], ",", 
         RowBox[{"fixate_", "?", "VectorQ"}], ",", 
         RowBox[{"distraction_", "?", "VectorQ"}], ",", 
         RowBox[{"base_", "?", "VectorQ"}]}], "]"}], ":=", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"right\[CurlyPhi]", "[", 
          RowBox[{"headAimVector", ",", "fixate", ",", " ", "base"}], "]"}], 
         "-", 
         RowBox[{"right\[Delta]", "[", 
          RowBox[{
          "headAimVector", ",", "fixate", ",", "distraction", ",", "base"}], 
          "]"}]}], ")"}]}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"left\[Theta]", "[", 
        RowBox[{
         RowBox[{"headAimVector_", "?", "VectorQ"}], ",", 
         RowBox[{"fixate_", "?", "VectorQ"}], ",", 
         RowBox[{"distraction_", "?", "VectorQ"}], ",", 
         RowBox[{"base_", "?", "VectorQ"}]}], "]"}], ":=", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"left\[CurlyPhi]", "[", 
          RowBox[{"headAimVector", ",", "fixate", ",", " ", "base"}], "]"}], 
         "-", 
         RowBox[{"left\[Delta]", "[", 
          RowBox[{
          "headAimVector", ",", "fixate", ",", "distraction", ",", "base"}], 
          "]"}]}], ")"}]}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"right\[Theta]inside", "[", 
        RowBox[{
         RowBox[{"headAimVector_", "?", "VectorQ"}], ",", 
         RowBox[{"fixate_", "?", "VectorQ"}], ",", 
         RowBox[{"distraction_", "?", "VectorQ"}], ",", 
         RowBox[{"base_", "?", "VectorQ"}]}], "]"}], ":=", 
       RowBox[{
        RowBox[{"right\[Theta]", "[", 
         RowBox[{
         "headAimVector", ",", "fixate", ",", "distraction", ",", "base"}], 
         "]"}], "+", 
        RowBox[{"ArcSin", "[", 
         RowBox[{"nodePercent", "*", 
          RowBox[{"Sin", "[", 
           RowBox[{"right\[Theta]", "[", 
            RowBox[{
            "headAimVector", ",", "fixate", ",", "distraction", ",", "base"}],
             "]"}], "]"}]}], "]"}]}]}], ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"left\[Theta]inside", "[", 
        RowBox[{
         RowBox[{"headAimVector_", "?", "VectorQ"}], ",", 
         RowBox[{"fixate_", "?", "VectorQ"}], ",", 
         RowBox[{"distraction_", "?", "VectorQ"}], ",", 
         RowBox[{"base_", "?", "VectorQ"}]}], "]"}], ":=", 
       RowBox[{
        RowBox[{"left\[Theta]", "[", 
         RowBox[{
         "headAimVector", ",", "fixate", ",", "distraction", ",", "base"}], 
         "]"}], "+", 
        RowBox[{"ArcSin", "[", 
         RowBox[{"nodePercent", "*", 
          RowBox[{"Sin", "[", 
           RowBox[{"left\[Theta]", "[", 
            RowBox[{
            "headAimVector", ",", "fixate", ",", "distraction", ",", "base"}],
             "]"}], "]"}]}], "]"}]}]}], ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"retinalDisparity", "[", 
        RowBox[{
         RowBox[{"headAimVector_", "?", "VectorQ"}], ",", 
         RowBox[{"fixate_", "?", "VectorQ"}], ",", 
         RowBox[{"distraction_", "?", "VectorQ"}], ",", 
         RowBox[{"base_", "?", "VectorQ"}]}], "]"}], ":=", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"Or", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"left\[Theta]", "[", 
             RowBox[{
             "headAimVector", ",", "fixate", ",", "distraction", ",", 
              "base"}], "]"}], "<", 
            RowBox[{
             RowBox[{"-", "\[Pi]"}], "/", "2."}]}], ",", 
           RowBox[{
            RowBox[{"left\[Theta]", "[", 
             RowBox[{
             "headAimVector", ",", "fixate", ",", "distraction", ",", 
              "base"}], "]"}], ">", 
            RowBox[{"\[Pi]", "/", "3."}]}], ",", 
           RowBox[{
            RowBox[{"right\[Theta]", "[", 
             RowBox[{
             "headAimVector", ",", "fixate", ",", "distraction", ",", 
              "base"}], "]"}], "<", 
            RowBox[{
             RowBox[{"-", "\[Pi]"}], "/", "3."}]}], ",", 
           RowBox[{
            RowBox[{"right\[Theta]", "[", 
             RowBox[{
             "headAimVector", ",", "fixate", ",", "distraction", ",", 
              "base"}], "]"}], ">", 
            RowBox[{"\[Pi]", "/", "2."}]}]}], "]"}], ",", "0", ",", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"right\[Theta]inside", "[", 
            RowBox[{
            "headAimVector", ",", "fixate", ",", "distraction", ",", "base"}],
             "]"}], "-", 
           RowBox[{"left\[Theta]inside", "[", 
            RowBox[{
            "headAimVector", ",", "fixate", ",", "distraction", ",", "base"}],
             "]"}]}], ")"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"eyePict", "[", 
        RowBox[{
         RowBox[{"eyeCenter_", "?", "VectorQ"}], ",", 
         RowBox[{"fixate_", "?", "VectorQ"}]}], "]"}], ":=", 
       RowBox[{"Module", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"\[Lambda]", ",", "viewVector"}], "}"}], ",", 
         RowBox[{
          RowBox[{"viewVector", "=", 
           RowBox[{"fixate", "-", "eyeCenter"}]}], ";", "\[IndentingNewLine]", 
          RowBox[{"\[Lambda]", "=", 
           RowBox[{"ArcTan", "[", 
            RowBox[{
             RowBox[{"viewVector", "[", 
              RowBox[{"[", "1", "]"}], "]"}], ",", 
             RowBox[{"viewVector", "[", 
              RowBox[{"[", "2", "]"}], "]"}]}], "]"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"viewVector", "=", 
           RowBox[{"viewVector", "/", 
            RowBox[{"nORM", "[", "viewVector", "]"}]}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"Show", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"Graphics", "[", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"AbsoluteThickness", "[", "2", "]"}], ",", "Gray", 
                 ",", 
                 RowBox[{"Circle", "[", 
                  RowBox[{"eyeCenter", ",", "eyeRadius", ",", 
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"\[Lambda]", "+", ".4"}], ",", 
                    RowBox[{
                    RowBox[{"2", "\[Pi]"}], "+", "\[Lambda]", "-", ".4"}]}], 
                    "}"}]}], "]"}]}], "}"}], "]"}], ",", 
              RowBox[{"Graphics", "[", 
               RowBox[{"{", 
                RowBox[{"Gray", ",", "\[IndentingNewLine]", 
                 RowBox[{"Circle", "[", 
                  RowBox[{
                   RowBox[{"eyeCenter", "+", " ", 
                    RowBox[{".8", "eyeRadius", " ", "viewVector"}]}], ",", 
                   RowBox[{".5", "eyeRadius"}], ",", 
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"\[Lambda]", "-", "1.5"}], ",", 
                    RowBox[{"\[Lambda]", "+", "1.5"}]}], "}"}]}], "]"}]}], 
                "}"}], "]"}], ",", "\[IndentingNewLine]", 
              RowBox[{"Graphics", "[", 
               RowBox[{"{", 
                RowBox[{"Green", ",", "\[IndentingNewLine]", 
                 RowBox[{"Disk", "[", 
                  RowBox[{
                   RowBox[{"eyeCenter", "+", 
                    RowBox[{
                    "eyeRadius", "*", "nodePercent", "*", "viewVector"}]}], 
                   ",", 
                   RowBox[{"eyeRadius", "/", "10"}]}], "]"}]}], 
                "\[IndentingNewLine]", "}"}], "]"}]}], "\[IndentingNewLine]", 
             "}"}], ",", 
            RowBox[{"AspectRatio", "\[Rule]", "Automatic"}]}], "]"}]}]}], 
        "]"}]}], ";", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"eyeEdge", "[", "\[Theta]_", "]"}], ":=", 
       RowBox[{"eyeRadius", "*", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Cos", "[", "\[Theta]", "]"}], ",", 
          RowBox[{"Sin", "[", "\[Theta]", "]"}]}], "}"}]}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"inRays", "[", 
        RowBox[{
         RowBox[{"headAimVector_", "?", "VectorQ"}], ",", 
         RowBox[{"fixate_", "?", "VectorQ"}], ",", 
         RowBox[{"distraction_", "?", "VectorQ"}], ",", 
         RowBox[{"base_", "?", "VectorQ"}]}], "]"}], ":=", 
       RowBox[{"Show", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"eyePict", "[", 
            RowBox[{
             RowBox[{"leftEyeCenter", "[", 
              RowBox[{"headAimVector", ",", " ", "base"}], "]"}], ",", 
             "fixate"}], "]"}], ",", 
           RowBox[{"eyePict", "[", 
            RowBox[{
             RowBox[{"rightEyeCenter", "[", 
              RowBox[{"headAimVector", ",", "base"}], "]"}], ",", "fixate"}], 
            "]"}], ",", 
           RowBox[{"Graphics", "[", 
            RowBox[{"{", 
             RowBox[{"Red", ",", 
              RowBox[{"{", 
               RowBox[{"Line", "[", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"rightEyeNode", "[", 
                   RowBox[{"headAimVector", ",", "fixate", ",", "base"}], 
                   "]"}], ",", 
                  RowBox[{
                   RowBox[{"rightEyeCenter", "[", 
                    RowBox[{"headAimVector", ",", "base"}], "]"}], "-", 
                   RowBox[{"eyeRadius", "*", 
                    RowBox[{
                    RowBox[{"rightViewVector", "[", 
                    RowBox[{"headAimVector", ",", "fixate", ",", "base"}], 
                    "]"}], "/", 
                    RowBox[{"nORM", "[", 
                    RowBox[{"rightViewVector", "[", 
                    RowBox[{"headAimVector", ",", "fixate", ",", "base"}], 
                    "]"}], "]"}]}]}]}]}], "}"}], "]"}], "}"}]}], "}"}], "]"}],
            ",", 
           RowBox[{"Graphics", "[", 
            RowBox[{"{", 
             RowBox[{"Red", ",", 
              RowBox[{"{", 
               RowBox[{"Line", "[", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"leftEyeNode", "[", 
                   RowBox[{"headAimVector", ",", "fixate", ",", "base"}], 
                   "]"}], ",", 
                  RowBox[{
                   RowBox[{"leftEyeCenter", "[", 
                    RowBox[{"headAimVector", ",", " ", "base"}], "]"}], "-", 
                   RowBox[{"eyeRadius", "*", 
                    RowBox[{
                    RowBox[{"leftViewVector", "[", 
                    RowBox[{"headAimVector", ",", "fixate", ",", "base"}], 
                    "]"}], "/", 
                    RowBox[{"nORM", "[", 
                    RowBox[{"leftViewVector", "[", 
                    RowBox[{"headAimVector", ",", "fixate", ",", "base"}], 
                    "]"}], "]"}]}]}]}]}], "}"}], "]"}], "}"}]}], "}"}], "]"}],
            ",", 
           RowBox[{"Graphics", "[", 
            RowBox[{"{", 
             RowBox[{"Blue", ",", 
              RowBox[{"{", 
               RowBox[{"Line", "[", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"rightEyeNode", "[", 
                   RowBox[{"headAimVector", ",", "fixate", ",", "base"}], 
                   "]"}], ",", 
                  RowBox[{
                   RowBox[{"rightEyeCenter", "[", 
                    RowBox[{"headAimVector", ",", "base"}], "]"}], "+", 
                   RowBox[{"eyeEdge", "[", 
                    RowBox[{
                    RowBox[{"right\[CurlyPhi]", "[", 
                    RowBox[{"headAimVector", ",", "fixate", ",", "base"}], 
                    "]"}], "-", "\[Pi]", "-", 
                    RowBox[{"right\[Theta]inside", "[", 
                    RowBox[{
                    "headAimVector", ",", "fixate", ",", "distraction", ",", 
                    "base"}], "]"}]}], "]"}]}]}], "}"}], "]"}], "}"}]}], 
             "}"}], "]"}], ",", "\[IndentingNewLine]", 
           RowBox[{"Graphics", "[", 
            RowBox[{"{", 
             RowBox[{"Blue", ",", 
              RowBox[{"{", 
               RowBox[{"Line", "[", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"leftEyeNode", "[", 
                   RowBox[{"headAimVector", ",", "fixate", ",", "base"}], 
                   "]"}], ",", 
                  RowBox[{
                   RowBox[{"leftEyeCenter", "[", 
                    RowBox[{"headAimVector", ",", "base"}], "]"}], "+", 
                   RowBox[{"eyeEdge", "[", 
                    RowBox[{
                    RowBox[{"left\[CurlyPhi]", "[", 
                    RowBox[{"headAimVector", ",", "fixate", ",", "base"}], 
                    "]"}], "-", "\[Pi]", "-", 
                    RowBox[{"left\[Theta]inside", "[", 
                    RowBox[{
                    "headAimVector", ",", "fixate", ",", "distraction", ",", 
                    "base"}], "]"}]}], "]"}]}]}], "}"}], "]"}], "}"}]}], 
             "}"}], "]"}], ",", "\[IndentingNewLine]", 
           RowBox[{"Graphics", "[", 
            RowBox[{"{", 
             RowBox[{"Purple", ",", 
              RowBox[{"{", 
               RowBox[{"Line", "[", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"rightEyeCenter", "[", 
                   RowBox[{"headAimVector", ",", "base"}], "]"}], ",", 
                  RowBox[{
                   RowBox[{"rightEyeCenter", "[", 
                    RowBox[{"headAimVector", ",", "base"}], "]"}], "+", 
                   RowBox[{"eyeEdge", "[", 
                    RowBox[{
                    RowBox[{"right\[CurlyPhi]", "[", 
                    RowBox[{"headAimVector", ",", "fixate", ",", "base"}], 
                    "]"}], "-", "\[Pi]", "-", 
                    RowBox[{"right\[Theta]inside", "[", 
                    RowBox[{
                    "headAimVector", ",", "fixate", ",", "distraction", ",", 
                    "base"}], "]"}]}], "]"}]}]}], "}"}], "]"}], "}"}]}], 
             "}"}], "]"}], ",", "\[IndentingNewLine]", 
           RowBox[{"Graphics", "[", 
            RowBox[{"{", 
             RowBox[{"Purple", ",", 
              RowBox[{"{", 
               RowBox[{"Line", "[", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"leftEyeCenter", "[", 
                   RowBox[{"headAimVector", ",", "base"}], "]"}], ",", 
                  RowBox[{
                   RowBox[{"leftEyeCenter", "[", 
                    RowBox[{"headAimVector", ",", "base"}], "]"}], "+", 
                   RowBox[{"eyeEdge", "[", 
                    RowBox[{
                    RowBox[{"left\[CurlyPhi]", "[", 
                    RowBox[{"headAimVector", ",", "fixate", ",", "base"}], 
                    "]"}], "-", "\[Pi]", "-", 
                    RowBox[{"left\[Theta]inside", "[", 
                    RowBox[{
                    "headAimVector", ",", "fixate", ",", "distraction", ",", 
                    "base"}], "]"}]}], "]"}]}]}], "}"}], "]"}], "}"}]}], 
             "}"}], "]"}], ",", "\[IndentingNewLine]", 
           RowBox[{"Graphics", "[", 
            RowBox[{"{", 
             RowBox[{"Green", ",", 
              RowBox[{"{", 
               RowBox[{"Line", "[", 
                RowBox[{"N", "[", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"leftEyeCenter", "[", 
                    RowBox[{"headAimVector", ",", " ", "base"}], "]"}], ",", 
                   RowBox[{"rightEyeCenter", "[", 
                    RowBox[{"headAimVector", ",", " ", "base"}], "]"}]}], 
                  "}"}], "]"}], "]"}], "}"}]}], "}"}], "]"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"min", "=", 
             RowBox[{"Min", "[", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{
                 RowBox[{"left\[CurlyPhi]", "[", 
                  RowBox[{"headAimVector", ",", "fixate", ",", "base"}], 
                  "]"}], "-", "\[Pi]", "-", 
                 RowBox[{"left\[Theta]inside", "[", 
                  RowBox[{
                  "headAimVector", ",", "fixate", ",", "distraction", ",", 
                   "base"}], "]"}], "-", 
                 RowBox[{"retinalDisparity", "[", 
                  RowBox[{
                  "headAimVector", ",", "fixate", ",", "distraction", ",", 
                   "base"}], "]"}]}], ",", 
                RowBox[{
                 RowBox[{"left\[CurlyPhi]", "[", 
                  RowBox[{"headAimVector", ",", "fixate", ",", "base"}], 
                  "]"}], "-", "\[Pi]", "-", 
                 RowBox[{"left\[Theta]inside", "[", 
                  RowBox[{
                  "headAimVector", ",", "fixate", ",", "distraction", ",", 
                   "base"}], "]"}]}]}], "}"}], "]"}]}], ";", 
            "\[IndentingNewLine]", 
            RowBox[{"MAX", "=", 
             RowBox[{"Max", "[", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{
                 RowBox[{"left\[CurlyPhi]", "[", 
                  RowBox[{"headAimVector", ",", "fixate", ",", "base"}], 
                  "]"}], "-", "\[Pi]", "-", 
                 RowBox[{"left\[Theta]inside", "[", 
                  RowBox[{
                  "headAimVector", ",", "fixate", ",", "distraction", ",", 
                   "base"}], "]"}], "-", 
                 RowBox[{"retinalDisparity", "[", 
                  RowBox[{
                  "headAimVector", ",", "fixate", ",", "distraction", ",", 
                   "base"}], "]"}]}], ",", 
                RowBox[{
                 RowBox[{"left\[CurlyPhi]", "[", 
                  RowBox[{"headAimVector", ",", "fixate", ",", "base"}], 
                  "]"}], "-", "\[Pi]", "-", 
                 RowBox[{"left\[Theta]inside", "[", 
                  RowBox[{
                  "headAimVector", ",", "fixate", ",", "distraction", ",", 
                   "base"}], "]"}]}]}], "}"}], "]"}]}], ";", 
            "\[IndentingNewLine]", 
            RowBox[{"Graphics", "[", 
             RowBox[{"{", 
              RowBox[{"Brown", ",", 
               RowBox[{"AbsoluteThickness", "[", "3", "]"}], ",", 
               RowBox[{"{", 
                RowBox[{"Circle", "[", 
                 RowBox[{
                  RowBox[{"leftEyeCenter", "[", 
                   RowBox[{"headAimVector", ",", " ", "base"}], "]"}], ",", 
                  "eyeRadius", ",", 
                  RowBox[{"{", 
                   RowBox[{"min", ",", "MAX"}], "}"}]}], "]"}], "}"}]}], 
              "}"}], "]"}]}]}], "\[IndentingNewLine]", "}"}], ",", 
         RowBox[{"AspectRatio", "\[Rule]", "Automatic"}], ",", 
         RowBox[{"PlotRange", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{"midPoint", "[", 
                 RowBox[{"headAimVector", ",", "base"}], "]"}], "[", 
                RowBox[{"[", "1", "]"}], "]"}], "-", "interOcular"}], ",", 
              RowBox[{
               RowBox[{
                RowBox[{"midPoint", "[", 
                 RowBox[{"headAimVector", ",", "base"}], "]"}], "[", 
                RowBox[{"[", "1", "]"}], "]"}], "+", "interOcular"}]}], "}"}],
             ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{"midPoint", "[", 
                 RowBox[{"headAimVector", ",", "base"}], "]"}], "[", 
                RowBox[{"[", "2", "]"}], "]"}], "-", "interOcular"}], ",", 
              RowBox[{
               RowBox[{
                RowBox[{"midPoint", "[", 
                 RowBox[{"headAimVector", ",", "base"}], "]"}], "[", 
                RowBox[{"[", "2", "]"}], "]"}], "+", "interOcular"}]}], 
             "}"}]}], "}"}]}]}], "]"}]}], ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"outRays", "[", 
        RowBox[{
         RowBox[{"headAimVector_", "?", "VectorQ"}], ",", 
         RowBox[{"fixate_", "?", "VectorQ"}], ",", 
         RowBox[{"distraction_", "?", "VectorQ"}], ",", 
         RowBox[{"base_", "?", "VectorQ"}]}], "]"}], ":=", 
       RowBox[{"Show", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Graphics", "[", 
            RowBox[{"{", 
             RowBox[{"Red", ",", 
              RowBox[{"AbsolutePointSize", "[", "4", "]"}], ",", 
              RowBox[{"{", 
               RowBox[{"Point", "[", 
                RowBox[{"N", "[", "fixate", "]"}], "]"}], "}"}]}], "}"}], 
            "]"}], ",", 
           RowBox[{"Graphics", "[", 
            RowBox[{"{", 
             RowBox[{"Blue", ",", 
              RowBox[{"AbsolutePointSize", "[", "4", "]"}], ",", 
              RowBox[{"{", 
               RowBox[{"Point", "[", 
                RowBox[{"N", "[", "distraction", "]"}], "]"}], "}"}]}], "}"}],
             "]"}], ",", 
           RowBox[{"Graphics", "[", 
            RowBox[{"{", 
             RowBox[{"Red", ",", 
              RowBox[{"{", 
               RowBox[{"Line", "[", 
                RowBox[{"N", "[", 
                 RowBox[{"{", 
                  RowBox[{"fixate", ",", 
                   RowBox[{"rightEyeNode", "[", 
                    RowBox[{
                    "headAimVector", ",", "fixate", ",", " ", "base"}], 
                    "]"}]}], "}"}], "]"}], "]"}], "}"}]}], "}"}], "]"}], ",", 
           
           RowBox[{"Graphics", "[", 
            RowBox[{"{", 
             RowBox[{"Red", ",", 
              RowBox[{"{", 
               RowBox[{"Line", "[", 
                RowBox[{"N", "[", 
                 RowBox[{"{", 
                  RowBox[{"fixate", ",", 
                   RowBox[{"leftEyeNode", "[", 
                    RowBox[{
                    "headAimVector", ",", "fixate", ",", " ", "base"}], 
                    "]"}]}], "}"}], "]"}], "]"}], "}"}]}], "}"}], "]"}], ",", 
           
           RowBox[{"Graphics", "[", 
            RowBox[{"{", 
             RowBox[{"Blue", ",", 
              RowBox[{"{", 
               RowBox[{"Line", "[", 
                RowBox[{"N", "[", 
                 RowBox[{"{", 
                  RowBox[{"distraction", ",", 
                   RowBox[{"rightEyeNode", "[", 
                    RowBox[{
                    "headAimVector", ",", "fixate", ",", " ", "base"}], 
                    "]"}]}], "}"}], "]"}], "]"}], "}"}]}], "}"}], "]"}], ",", 
           
           RowBox[{"Graphics", "[", 
            RowBox[{"{", 
             RowBox[{"Blue", ",", 
              RowBox[{"{", 
               RowBox[{"Line", "[", 
                RowBox[{"N", "[", 
                 RowBox[{"{", 
                  RowBox[{"distraction", ",", 
                   RowBox[{"leftEyeNode", "[", 
                    RowBox[{
                    "headAimVector", ",", "fixate", ",", " ", "base"}], 
                    "]"}]}], "}"}], "]"}], "]"}], "}"}]}], "}"}], "]"}]}], 
          "\[IndentingNewLine]", "}"}], ",", 
         RowBox[{"AspectRatio", "\[Rule]", "Automatic"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"(*", 
       RowBox[{"Real", " ", "Program", " ", "Starts", " ", "Here"}], "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{"eyeRadius", "=", "1.3"}], ";", 
      RowBox[{"interOcular", "=", "6.5"}], ";", 
      RowBox[{"aimOffset", "=", ".125"}], ";", 
      RowBox[{"nodePercent", "=", ".5"}], ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"headAimVector", "[", "aim_", "]"}], ":=", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Sin", "[", 
          RowBox[{"aim", " ", 
           RowBox[{"\[Pi]", "/", "180"}]}], "]"}], ",", 
         RowBox[{"Cos", "[", 
          RowBox[{"aim", " ", 
           RowBox[{"\[Pi]", "/", "180"}]}], "]"}]}], "}"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Show", "[", 
       RowBox[{
        RowBox[{"{", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"inRays", "[", 
           RowBox[{
            RowBox[{"headAimVector", "[", "aim", "]"}], ",", "fixate", ",", 
            "distraction", ",", "base"}], "]"}], "\[IndentingNewLine]", ",", 
          "\[IndentingNewLine]", 
          RowBox[{"outRays", "[", 
           RowBox[{
            RowBox[{"headAimVector", "[", "aim", "]"}], ",", "fixate", ",", 
            "distraction", ",", "base"}], "]"}], "\[IndentingNewLine]", ",", 
          "\[IndentingNewLine]", 
          RowBox[{"Graphics", "[", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"AbsolutePointSize", "[", "4", "]"}], ",", 
             RowBox[{"Point", "[", 
              RowBox[{"midPoint", "[", 
               RowBox[{
                RowBox[{"headAimVector", "[", "aim", "]"}], ",", "base"}], 
               "]"}], "]"}]}], "}"}], "]"}], "\[IndentingNewLine]", ",", 
          "\[IndentingNewLine]", 
          RowBox[{"Graphics", "[", 
           RowBox[{"{", 
            RowBox[{"Green", ",", 
             RowBox[{"AbsolutePointSize", "[", "4", "]"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"Point", "[", "base", "]"}], "\[IndentingNewLine]", 
               ",", "\[IndentingNewLine]", 
               RowBox[{"Text", "[", 
                RowBox[{"\"\<B\>\"", ",", 
                 RowBox[{"base", "-", 
                  RowBox[{"{", 
                   RowBox[{"0", ",", ".5"}], "}"}]}]}], "]"}], 
               "\[IndentingNewLine]", ",", "\[IndentingNewLine]", 
               RowBox[{"Point", "[", 
                RowBox[{
                 RowBox[{"headAimVector", "[", "aim", "]"}], "+", "base"}], 
                "]"}], "\[IndentingNewLine]", ",", "\[IndentingNewLine]", 
               RowBox[{"Text", "[", 
                RowBox[{"\"\<A\>\"", ",", 
                 RowBox[{
                  RowBox[{"1.05", 
                   RowBox[{"headAimVector", "[", "aim", "]"}]}], "+", "base", 
                  "+", 
                  RowBox[{"{", 
                   RowBox[{"0", ",", ".5"}], "}"}]}]}], "]"}], 
               "\[IndentingNewLine]", ",", "\[IndentingNewLine]", 
               RowBox[{"Line", "[", 
                RowBox[{"{", 
                 RowBox[{"base", ",", 
                  RowBox[{
                   RowBox[{"headAimVector", "[", "aim", "]"}], "+", 
                   "base"}]}], "}"}], "]"}]}], "\[IndentingNewLine]", "}"}]}],
             "}"}], "]"}], "\[IndentingNewLine]", ",", "\[IndentingNewLine]", 
          
          RowBox[{"Graphics", "[", 
           RowBox[{"{", 
            RowBox[{"Red", ",", 
             RowBox[{"AbsolutePointSize", "[", "4", "]"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"Point", "[", "fixate", "]"}], ",", 
               RowBox[{"Text", "[", 
                RowBox[{"\"\<F\>\"", ",", 
                 RowBox[{"1.1", "fixate"}]}], "]"}], ",", 
               RowBox[{"Line", "[", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"leftEyeNode", "[", 
                   RowBox[{
                    RowBox[{"headAimVector", "[", "aim", "]"}], ",", "fixate",
                     ",", "base"}], "]"}], ",", "fixate"}], "}"}], "]"}], ",", 
               RowBox[{"Line", "[", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"rightEyeNode", "[", 
                   RowBox[{
                    RowBox[{"headAimVector", "[", "aim", "]"}], ",", "fixate",
                     ",", "base"}], "]"}], ",", "fixate"}], "}"}], "]"}], ",",
                "\[IndentingNewLine]", 
               RowBox[{"Circle", "[", 
                RowBox[{"fixate", ",", "1", ",", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"left\[CurlyPhi]", "[", 
                    RowBox[{
                    RowBox[{"headAimVector", "[", "aim", "]"}], ",", "fixate",
                     ",", "base"}], "]"}], "+", "\[Pi]"}], ",", 
                   RowBox[{
                    RowBox[{"right\[CurlyPhi]", "[", 
                    RowBox[{
                    RowBox[{"headAimVector", "[", "aim", "]"}], ",", "fixate",
                     ",", "base"}], "]"}], "+", "\[Pi]"}]}], "}"}]}], "]"}]}],
               "}"}]}], "}"}], "]"}], "\[IndentingNewLine]", ",", 
          "\[IndentingNewLine]", 
          RowBox[{"Graphics", "[", 
           RowBox[{"{", 
            RowBox[{"Blue", ",", 
             RowBox[{"AbsolutePointSize", "[", "5", "]"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"Point", "[", "distraction", "]"}], ",", 
               RowBox[{"Text", "[", 
                RowBox[{"\"\<D\>\"", ",", 
                 RowBox[{"1.05", "distraction"}]}], "]"}], ",", 
               RowBox[{"Line", "[", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"leftEyeNode", "[", 
                   RowBox[{
                    RowBox[{"headAimVector", "[", "aim", "]"}], ",", "fixate",
                     ",", "base"}], "]"}], ",", "distraction"}], "}"}], "]"}],
                ",", 
               RowBox[{"Line", "[", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"rightEyeNode", "[", 
                   RowBox[{
                    RowBox[{"headAimVector", "[", "aim", "]"}], ",", "fixate",
                     ",", "base"}], "]"}], ",", "distraction"}], "}"}], "]"}],
                ",", 
               RowBox[{"Circle", "[", 
                RowBox[{"distraction", ",", "1", ",", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"left\[Delta]", "[", 
                    RowBox[{
                    RowBox[{"headAimVector", "[", "aim", "]"}], ",", "fixate",
                     ",", " ", "distraction", ",", "base"}], "]"}], "+", 
                    "\[Pi]"}], ",", 
                   RowBox[{
                    RowBox[{"right\[Delta]", "[", 
                    RowBox[{
                    RowBox[{"headAimVector", "[", "aim", "]"}], ",", "fixate",
                     ",", " ", "distraction", ",", "base"}], "]"}], "+", 
                    "\[Pi]"}]}], "}"}]}], "]"}]}], "}"}]}], "}"}], "]"}]}], 
         "\[IndentingNewLine]", "}"}], ",", 
        RowBox[{"PlotRange", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"-", "9"}], ",", "9"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"-", "3"}], ",", "14"}], "}"}]}], "}"}]}], ",", 
        RowBox[{"AspectRatio", "\[Rule]", "Automatic"}], ",", 
        RowBox[{"ImageSize", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{"400", ",", "400"}], "}"}]}]}], "]"}]}]}], "]"}], 
   "\[IndentingNewLine]", ",", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"base", ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "2"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", ".5"}], "}"}], ",", "Locator"}], "}"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"aim", ",", "0", ",", "\"\<head aim\>\""}], "}"}], ",", 
     RowBox[{"-", "15"}], ",", "15"}], "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"fixate", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1.6"}], ",", "10.43"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "7"}], ",", "6"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"7", ",", "13"}], "}"}], ",", "Locator"}], "}"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"distraction", ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "13"}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "8"}], ",", "5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"8", ",", "14"}], "}"}], ",", "Locator"}], "}"}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.415631056611476*^9, 3.415631100678975*^9}, 
   3.4156311776434717`*^9, {3.415631212455894*^9, 3.415631221344046*^9}, {
   3.415631553121703*^9, 3.415631584441774*^9}, {3.41563170387989*^9, 
   3.4156318135764427`*^9}, {3.415631844613402*^9, 3.415631994351959*^9}, 
   3.415632076206313*^9, {3.415632132888604*^9, 3.415632230077179*^9}, {
   3.415632280138607*^9, 3.4156323162096653`*^9}, {3.415632358076092*^9, 
   3.415632459415897*^9}, {3.415632515962677*^9, 3.415632542101994*^9}, {
   3.415636745825086*^9, 3.415636757515396*^9}, 3.415636809129287*^9, {
   3.4156368697570744`*^9, 3.4156370774816113`*^9}, {3.415637124942294*^9, 
   3.4156371289234953`*^9}, {3.415637159617889*^9, 3.415637159753862*^9}, {
   3.415637209897422*^9, 3.4156372205903378`*^9}, {3.415637281112441*^9, 
   3.415637331448494*^9}, {3.4156373639313393`*^9, 3.415637389769145*^9}, {
   3.4156374701608963`*^9, 3.415637473497898*^9}, {3.4156375228988132`*^9, 
   3.4156375667511044`*^9}, {3.4156379721031313`*^9, 
   3.4156380063918877`*^9}, {3.415638187553422*^9, 3.415638214899034*^9}, {
   3.41563824614327*^9, 3.415638285774281*^9}, {3.415638356485004*^9, 
   3.415638358483034*^9}, {3.415638451030836*^9, 3.415638470884265*^9}, {
   3.41563852409552*^9, 3.415638602895067*^9}, {3.41563865045817*^9, 
   3.4156387126590767`*^9}, {3.415638796930463*^9, 3.415638800740904*^9}, {
   3.415638985477434*^9, 3.415638997282158*^9}, 3.4156390318566437`*^9, {
   3.415639073626341*^9, 3.415639135728075*^9}, {3.415639186619458*^9, 
   3.415639216906703*^9}, {3.4156392506044197`*^9, 3.41563928550809*^9}, {
   3.415639336954619*^9, 3.415639338739873*^9}, {3.415639445470993*^9, 
   3.415639507758444*^9}, {3.423236864281934*^9, 3.4232369041648808`*^9}, {
   3.42323693781913*^9, 3.423236948696603*^9}, {3.423236987940701*^9, 
   3.42323699450814*^9}, {3.42324075058843*^9, 3.423240784500957*^9}, {
   3.42324082715154*^9, 3.423240878720771*^9}, {3.423240952497807*^9, 
   3.4232410792185802`*^9}, {3.423241113594832*^9, 3.423241157247817*^9}, {
   3.423241216406419*^9, 3.4232412549667683`*^9}, {3.423241296569034*^9, 
   3.423241311944028*^9}, {3.423241429185226*^9, 3.423241435061102*^9}, {
   3.423241468957822*^9, 3.423241469564419*^9}, {3.423241597066033*^9, 
   3.4232416231309357`*^9}, {3.423241732448762*^9, 3.423241743791564*^9}, {
   3.423241824352323*^9, 3.42324182498847*^9}, {3.4232420001722717`*^9, 
   3.423242001484967*^9}, {3.423242109602983*^9, 3.423242136039236*^9}, {
   3.42324220196975*^9, 3.423242203801272*^9}, 3.423251361254836*^9, {
   3.4263571686680546`*^9, 3.4263573169138775`*^9}, {3.4263575840085845`*^9, 
   3.426357760602242*^9}, 3.4268554900412817`*^9, 3.426855560299074*^9, {
   3.42685559988981*^9, 3.4268556820547743`*^9}, 3.426856137944798*^9, {
   3.426856177058839*^9, 3.426856191891952*^9}, {3.426856241167424*^9, 
   3.426856243242841*^9}, {3.4268562751957703`*^9, 3.426856276534717*^9}, 
   3.426856321954015*^9, 3.4268563549737787`*^9, 3.42685639142301*^9, 
   3.4268564546004*^9, {3.426856496088283*^9, 3.426856505348198*^9}},
 CellID->1618709942]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`aim$$ = 6.25, $CellContext`base$$ = {0, 
    0}, $CellContext`distraction$$ = {2, 13}, $CellContext`fixate$$ = {-4.01, 
    12.29}, Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
    Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
    1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`base$$], {0, 0}}, {-3, -2}, {3, 0.5}}, {{
       Hold[$CellContext`aim$$], 0, "head aim"}, -15, 15}, {{
       Hold[$CellContext`fixate$$], {-1.6, 10.43}}, {-7, 6}, {7, 13}}, {{
       Hold[$CellContext`distraction$$], {2, 13}}, {-8, 5}, {8, 14}}}, 
    Typeset`size$$ = {400., {198., 202.}}, Typeset`update$$ = 0, 
    Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`base$8925$$ = {0, 0}, $CellContext`aim$8926$$ = 
    0, $CellContext`fixate$8927$$ = {0, 
    0}, $CellContext`distraction$8928$$ = {0, 0}}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`aim$$ = 
        0, $CellContext`base$$ = {0, 0}, $CellContext`distraction$$ = {2, 
         13}, $CellContext`fixate$$ = {-1.6, 10.43}}, "ControllerVariables" :> {
        Hold[$CellContext`base$$, $CellContext`base$8925$$, {0, 0}], 
        Hold[$CellContext`aim$$, $CellContext`aim$8926$$, 0], 
        Hold[$CellContext`fixate$$, $CellContext`fixate$8927$$, {0, 0}], 
        Hold[$CellContext`distraction$$, $CellContext`distraction$8928$$, {0, 
         0}]}, "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> 
      Module[{$CellContext`nORM$, $CellContext`degrees$, \
$CellContext`arcMinutes$, $CellContext`aim\[Psi]$, $CellContext`midPoint$, \
$CellContext`rightEyeCenter$, $CellContext`aimOffset$, \
$CellContext`interOcular$, $CellContext`leftEyeCenter$, \
$CellContext`rightViewVector$, $CellContext`right\[CurlyPhi]$, \
$CellContext`rightEyeNode$, $CellContext`nodePercent$, \
$CellContext`eyeRadius$, $CellContext`leftViewVector$, $CellContext`left\
\[CurlyPhi]$, $CellContext`leftEyeNode$, $CellContext`fixateConvergence$, \
$CellContext`left\[Alpha]$, $CellContext`right\[Alpha]$, \
$CellContext`rightDistractVector$, $CellContext`right\[Delta]$, \
$CellContext`leftDistractVector$, $CellContext`left\[Delta]$, \
$CellContext`convergenceDistraction$, $CellContext`right\[Theta]$, \
$CellContext`left\[Theta]$, $CellContext`right\[Theta]inside$, \
$CellContext`left\[Theta]inside$, $CellContext`retinalDisparity$, \
$CellContext`eyePict$, $CellContext`eyeEdge$, $CellContext`inRays$, \
$CellContext`min$, $CellContext`MAX$, $CellContext`outRays$, \
$CellContext`headAimVector$}, $CellContext`nORM$[
           PatternTest[
            Pattern[$CellContext`vector, 
             Blank[]], VectorQ]] := 
         Dot[$CellContext`vector, $CellContext`vector]^
          Rational[1, 2]; $CellContext`degrees$[
           Pattern[$CellContext`q, 
            Blank[]]] := $CellContext`q (180/Pi); $CellContext`arcMinutes$[
           Pattern[$CellContext`q, 
            Blank[]]] := ($CellContext`q 60) (180/Pi); $CellContext`aim\[Psi]$[
           PatternTest[
            Pattern[$CellContext`headAimVector, 
             Blank[]], VectorQ], 
           PatternTest[
            Pattern[$CellContext`base, 
             Blank[]], VectorQ]] := ArcTan[
           Part[$CellContext`headAimVector, 1], 
           Part[$CellContext`headAimVector, 2]]; $CellContext`midPoint$[
           PatternTest[
            Pattern[$CellContext`headAimVector$, 
             Blank[]], VectorQ], 
           PatternTest[
            Pattern[$CellContext`base$, 
             Blank[]], 
            VectorQ]] := $CellContext`base$ - ($CellContext`aimOffset$ \
$CellContext`interOcular$) {
            Part[$CellContext`headAimVector$, 2], -
            Part[$CellContext`headAimVector$, 
              1]}; $CellContext`rightEyeCenter$[
           PatternTest[
            Pattern[$CellContext`headAimVector$, 
             Blank[]], VectorQ], 
           PatternTest[
            Pattern[$CellContext`base$, 
             Blank[]], 
            VectorQ]] := $CellContext`base$ + ((
             1/2 - $CellContext`aimOffset$) $CellContext`interOcular$) {
             Part[$CellContext`headAimVector$, 2], -
             Part[$CellContext`headAimVector$, 
               1]}; $CellContext`leftEyeCenter$[
           PatternTest[
            Pattern[$CellContext`headAimVector$, 
             Blank[]], VectorQ], 
           PatternTest[
            Pattern[$CellContext`base$, 
             Blank[]], VectorQ]] := $CellContext`base$ - ((
            1/2 + $CellContext`aimOffset$) $CellContext`interOcular$) {
            Part[$CellContext`headAimVector$, 2], -
            Part[$CellContext`headAimVector$, 
              1]}; $CellContext`rightViewVector$[
           PatternTest[
            Pattern[$CellContext`headAimVector$, 
             Blank[]], VectorQ], 
           PatternTest[
            Pattern[$CellContext`fixate$, 
             Blank[]], VectorQ], 
           PatternTest[
            Pattern[$CellContext`base$, 
             Blank[]], 
            VectorQ]] := $CellContext`fixate$ - \
$CellContext`rightEyeCenter$[$CellContext`headAimVector$, $CellContext`base$]; \
$CellContext`right\[CurlyPhi]$[
           PatternTest[
            Pattern[$CellContext`headAimVector$, 
             Blank[]], VectorQ], 
           PatternTest[
            Pattern[$CellContext`fixate$, 
             Blank[]], VectorQ], 
           PatternTest[
            Pattern[$CellContext`base$, 
             Blank[]], VectorQ]] := ArcTan[
           Part[
            $CellContext`rightViewVector$[$CellContext`headAimVector$, \
$CellContext`fixate$, $CellContext`base$], 1], 
           Part[
            $CellContext`rightViewVector$[$CellContext`headAimVector$, \
$CellContext`fixate$, $CellContext`base$], 2]]; $CellContext`rightEyeNode$[
           PatternTest[
            Pattern[$CellContext`headAimVector$, 
             Blank[]], VectorQ], 
           PatternTest[
            Pattern[$CellContext`fixate$, 
             Blank[]], VectorQ], 
           PatternTest[
            Pattern[$CellContext`base$, 
             Blank[]], 
            VectorQ]] := \
$CellContext`rightEyeCenter$[$CellContext`headAimVector$, $CellContext`base$] + \
($CellContext`nodePercent$ $CellContext`eyeRadius$) \
($CellContext`rightViewVector$[$CellContext`headAimVector$, \
$CellContext`fixate$, $CellContext`base$]/$CellContext`nORM$[
             $CellContext`rightViewVector$[$CellContext`headAimVector$, \
$CellContext`fixate$, $CellContext`base$]]); $CellContext`leftViewVector$[
           PatternTest[
            Pattern[$CellContext`headAimVector$, 
             Blank[]], VectorQ], 
           PatternTest[
            Pattern[$CellContext`fixate$, 
             Blank[]], VectorQ], 
           PatternTest[
            Pattern[$CellContext`base$, 
             Blank[]], 
            VectorQ]] := $CellContext`fixate$ - \
$CellContext`leftEyeCenter$[$CellContext`headAimVector$, $CellContext`base$]; \
$CellContext`left\[CurlyPhi]$[
           PatternTest[
            Pattern[$CellContext`headAimVector$, 
             Blank[]], VectorQ], 
           PatternTest[
            Pattern[$CellContext`fixate$, 
             Blank[]], VectorQ], 
           PatternTest[
            Pattern[$CellContext`base$, 
             Blank[]], VectorQ]] := ArcTan[
           Part[
            $CellContext`leftViewVector$[$CellContext`headAimVector$, \
$CellContext`fixate$, $CellContext`base$], 1], 
           Part[
            $CellContext`leftViewVector$[$CellContext`headAimVector$, \
$CellContext`fixate$, $CellContext`base$], 2]]; $CellContext`leftEyeNode$[
           PatternTest[
            Pattern[$CellContext`headAimVector$, 
             Blank[]], VectorQ], 
           PatternTest[
            Pattern[$CellContext`fixate$, 
             Blank[]], VectorQ], 
           PatternTest[
            Pattern[$CellContext`base$, 
             Blank[]], 
            VectorQ]] := \
$CellContext`leftEyeCenter$[$CellContext`headAimVector$, $CellContext`base$] + \
($CellContext`nodePercent$ $CellContext`eyeRadius$) \
($CellContext`leftViewVector$[$CellContext`headAimVector$, \
$CellContext`fixate$, $CellContext`base$]/$CellContext`nORM$[
             $CellContext`leftViewVector$[$CellContext`headAimVector$, \
$CellContext`fixate$, $CellContext`base$]]); $CellContext`fixateConvergence$[
           PatternTest[
            Pattern[$CellContext`headAimVector$, 
             Blank[]], VectorQ], 
           PatternTest[
            Pattern[$CellContext`fixate$, 
             Blank[]], VectorQ], 
           PatternTest[
            Pattern[$CellContext`base$, 
             Blank[]], 
            VectorQ]] := \
$CellContext`right\[CurlyPhi]$[$CellContext`headAimVector$, \
$CellContext`fixate$, $CellContext`base$] - \
$CellContext`left\[CurlyPhi]$[$CellContext`headAimVector$, \
$CellContext`fixate$, $CellContext`base$]; $CellContext`left\[Alpha]$[
           PatternTest[
            Pattern[$CellContext`headAimVector$, 
             Blank[]], VectorQ], 
           PatternTest[
            Pattern[$CellContext`fixate$, 
             Blank[]], VectorQ], 
           PatternTest[
            Pattern[$CellContext`base$, 
             Blank[]], 
            VectorQ]] := \
$CellContext`left\[CurlyPhi]$[$CellContext`headAimVector$, \
$CellContext`fixate$, $CellContext`base$] - \
$CellContext`aim\[Psi]$[$CellContext`headAimVector$, $CellContext`base$]; \
$CellContext`right\[Alpha]$[
           PatternTest[
            Pattern[$CellContext`headAimVector$, 
             Blank[]], VectorQ], 
           PatternTest[
            Pattern[$CellContext`fixate$, 
             Blank[]], VectorQ], 
           PatternTest[
            Pattern[$CellContext`base$, 
             Blank[]], 
            VectorQ]] := \
$CellContext`right\[CurlyPhi]$[$CellContext`headAimVector$, \
$CellContext`fixate$, $CellContext`base$] - \
$CellContext`aim\[Psi]$[$CellContext`headAimVector$, $CellContext`base$]; \
$CellContext`rightDistractVector$[
           PatternTest[
            Pattern[$CellContext`headAimVector$, 
             Blank[]], VectorQ], 
           PatternTest[
            Pattern[$CellContext`fixate$, 
             Blank[]], VectorQ], 
           PatternTest[
            Pattern[$CellContext`distraction$, 
             Blank[]], VectorQ], 
           PatternTest[
            Pattern[$CellContext`base$, 
             Blank[]], 
            VectorQ]] := $CellContext`distraction$ - \
$CellContext`rightEyeNode$[$CellContext`headAimVector$, $CellContext`fixate$, \
$CellContext`base$]; $CellContext`right\[Delta]$[
           PatternTest[
            Pattern[$CellContext`headAimVector$, 
             Blank[]], VectorQ], 
           PatternTest[
            Pattern[$CellContext`fixate$, 
             Blank[]], VectorQ], 
           PatternTest[
            Pattern[$CellContext`distraction$, 
             Blank[]], VectorQ], 
           PatternTest[
            Pattern[$CellContext`base$, 
             Blank[]], VectorQ]] := ArcTan[
           Part[
            $CellContext`rightDistractVector$[$CellContext`headAimVector$, \
$CellContext`fixate$, $CellContext`distraction$, $CellContext`base$], 1], 
           Part[
            $CellContext`rightDistractVector$[$CellContext`headAimVector$, \
$CellContext`fixate$, $CellContext`distraction$, $CellContext`base$], 
            2]]; $CellContext`leftDistractVector$[
           PatternTest[
            Pattern[$CellContext`headAimVector$, 
             Blank[]], VectorQ], 
           PatternTest[
            Pattern[$CellContext`fixate$, 
             Blank[]], VectorQ], 
           PatternTest[
            Pattern[$CellContext`distraction$, 
             Blank[]], VectorQ], 
           PatternTest[
            Pattern[$CellContext`base$, 
             Blank[]], 
            VectorQ]] := $CellContext`distraction$ - \
$CellContext`leftEyeNode$[$CellContext`headAimVector$, $CellContext`fixate$, \
$CellContext`base$]; $CellContext`left\[Delta]$[
           PatternTest[
            Pattern[$CellContext`headAimVector$, 
             Blank[]], VectorQ], 
           PatternTest[
            Pattern[$CellContext`fixate$, 
             Blank[]], VectorQ], 
           PatternTest[
            Pattern[$CellContext`distraction$, 
             Blank[]], VectorQ], 
           PatternTest[
            Pattern[$CellContext`base$, 
             Blank[]], VectorQ]] := ArcTan[
           Part[
            $CellContext`leftDistractVector$[$CellContext`headAimVector$, \
$CellContext`fixate$, $CellContext`distraction$, $CellContext`base$], 1], 
           Part[
            $CellContext`leftDistractVector$[$CellContext`headAimVector$, \
$CellContext`fixate$, $CellContext`distraction$, $CellContext`base$], 
            2]]; $CellContext`convergenceDistraction$[
           PatternTest[
            Pattern[$CellContext`headAimVector$, 
             Blank[]], VectorQ], 
           PatternTest[
            Pattern[$CellContext`fixate$, 
             Blank[]], VectorQ], 
           PatternTest[
            Pattern[$CellContext`distraction$, 
             Blank[]], VectorQ], 
           PatternTest[
            Pattern[$CellContext`base$, 
             Blank[]], VectorQ]] := If[
           Or[
           Abs[$CellContext`left\[CurlyPhi]$[$CellContext`headAimVector$, \
$CellContext`fixate$, $CellContext`base$] - \
$CellContext`left\[Delta]$[$CellContext`headAimVector$, $CellContext`fixate$, \
$CellContext`distraction$, $CellContext`base$]] > Pi/3., 
            Abs[$CellContext`right\[CurlyPhi]$[$CellContext`headAimVector$, \
$CellContext`fixate$, $CellContext`base$] - \
$CellContext`right\[Delta]$[$CellContext`headAimVector$, \
$CellContext`fixate$, $CellContext`distraction$, $CellContext`base$]] > 
            Pi/3.], 0., \
$CellContext`right\[Delta]$[$CellContext`headAimVector$, \
$CellContext`fixate$, $CellContext`distraction$, $CellContext`base$] - \
$CellContext`left\[Delta]$[$CellContext`headAimVector$, $CellContext`fixate$, \
$CellContext`distraction$, $CellContext`base$]]; $CellContext`right\[Theta]$[
           PatternTest[
            Pattern[$CellContext`headAimVector$, 
             Blank[]], VectorQ], 
           PatternTest[
            Pattern[$CellContext`fixate$, 
             Blank[]], VectorQ], 
           PatternTest[
            Pattern[$CellContext`distraction$, 
             Blank[]], VectorQ], 
           PatternTest[
            Pattern[$CellContext`base$, 
             Blank[]], 
            VectorQ]] := \
$CellContext`right\[CurlyPhi]$[$CellContext`headAimVector$, \
$CellContext`fixate$, $CellContext`base$] - \
$CellContext`right\[Delta]$[$CellContext`headAimVector$, \
$CellContext`fixate$, $CellContext`distraction$, $CellContext`base$]; \
$CellContext`left\[Theta]$[
           PatternTest[
            Pattern[$CellContext`headAimVector$, 
             Blank[]], VectorQ], 
           PatternTest[
            Pattern[$CellContext`fixate$, 
             Blank[]], VectorQ], 
           PatternTest[
            Pattern[$CellContext`distraction$, 
             Blank[]], VectorQ], 
           PatternTest[
            Pattern[$CellContext`base$, 
             Blank[]], 
            VectorQ]] := \
$CellContext`left\[CurlyPhi]$[$CellContext`headAimVector$, \
$CellContext`fixate$, $CellContext`base$] - \
$CellContext`left\[Delta]$[$CellContext`headAimVector$, $CellContext`fixate$, \
$CellContext`distraction$, $CellContext`base$]; \
$CellContext`right\[Theta]inside$[
           PatternTest[
            Pattern[$CellContext`headAimVector$, 
             Blank[]], VectorQ], 
           PatternTest[
            Pattern[$CellContext`fixate$, 
             Blank[]], VectorQ], 
           PatternTest[
            Pattern[$CellContext`distraction$, 
             Blank[]], VectorQ], 
           PatternTest[
            Pattern[$CellContext`base$, 
             Blank[]], 
            VectorQ]] := \
$CellContext`right\[Theta]$[$CellContext`headAimVector$, \
$CellContext`fixate$, $CellContext`distraction$, $CellContext`base$] + 
          ArcSin[$CellContext`nodePercent$ Sin[
              $CellContext`right\[Theta]$[$CellContext`headAimVector$, \
$CellContext`fixate$, $CellContext`distraction$, $CellContext`base$]]]; \
$CellContext`left\[Theta]inside$[
           PatternTest[
            Pattern[$CellContext`headAimVector$, 
             Blank[]], VectorQ], 
           PatternTest[
            Pattern[$CellContext`fixate$, 
             Blank[]], VectorQ], 
           PatternTest[
            Pattern[$CellContext`distraction$, 
             Blank[]], VectorQ], 
           PatternTest[
            Pattern[$CellContext`base$, 
             Blank[]], 
            VectorQ]] := \
$CellContext`left\[Theta]$[$CellContext`headAimVector$, $CellContext`fixate$, \
$CellContext`distraction$, $CellContext`base$] + 
          ArcSin[$CellContext`nodePercent$ Sin[
              $CellContext`left\[Theta]$[$CellContext`headAimVector$, \
$CellContext`fixate$, $CellContext`distraction$, $CellContext`base$]]]; \
$CellContext`retinalDisparity$[
           PatternTest[
            Pattern[$CellContext`headAimVector$, 
             Blank[]], VectorQ], 
           PatternTest[
            Pattern[$CellContext`fixate$, 
             Blank[]], VectorQ], 
           PatternTest[
            Pattern[$CellContext`distraction$, 
             Blank[]], VectorQ], 
           PatternTest[
            Pattern[$CellContext`base$, 
             Blank[]], VectorQ]] := If[
           
           Or[$CellContext`left\[Theta]$[$CellContext`headAimVector$, \
$CellContext`fixate$, $CellContext`distraction$, $CellContext`base$] < (-Pi)/
             2., $CellContext`left\[Theta]$[$CellContext`headAimVector$, \
$CellContext`fixate$, $CellContext`distraction$, $CellContext`base$] > 
            Pi/3., $CellContext`right\[Theta]$[$CellContext`headAimVector$, \
$CellContext`fixate$, $CellContext`distraction$, $CellContext`base$] < (-Pi)/
             3., $CellContext`right\[Theta]$[$CellContext`headAimVector$, \
$CellContext`fixate$, $CellContext`distraction$, $CellContext`base$] > Pi/2.],
            0, $CellContext`right\[Theta]inside$[$CellContext`headAimVector$, \
$CellContext`fixate$, $CellContext`distraction$, $CellContext`base$] - \
$CellContext`left\[Theta]inside$[$CellContext`headAimVector$, \
$CellContext`fixate$, $CellContext`distraction$, $CellContext`base$]]; \
$CellContext`eyePict$[
           PatternTest[
            Pattern[$CellContext`eyeCenter$, 
             Blank[]], VectorQ], 
           PatternTest[
            Pattern[$CellContext`fixate$, 
             Blank[]], VectorQ]] := 
         Module[{$CellContext`\[Lambda]$, $CellContext`viewVector$}, \
$CellContext`viewVector$ = $CellContext`fixate$ - $CellContext`eyeCenter$; \
$CellContext`\[Lambda]$ = ArcTan[
              Part[$CellContext`viewVector$, 1], 
              
              Part[$CellContext`viewVector$, 
               2]]; $CellContext`viewVector$ = \
$CellContext`viewVector$/$CellContext`nORM$[$CellContext`viewVector$]; Show[{
              Graphics[{
                AbsoluteThickness[2], Gray, 
                
                Circle[$CellContext`eyeCenter$, $CellContext`eyeRadius$, \
{$CellContext`\[Lambda]$ + 0.4, 2 Pi + $CellContext`\[Lambda]$ - 0.4}]}], 
              Graphics[{Gray, 
                
                Circle[$CellContext`eyeCenter$ + (
                   0.8 $CellContext`eyeRadius$) $CellContext`viewVector$, 
                 0.5 $CellContext`eyeRadius$, {$CellContext`\[Lambda]$ - 
                  1.5, $CellContext`\[Lambda]$ + 1.5}]}], 
              Graphics[{Green, 
                
                Disk[$CellContext`eyeCenter$ + ($CellContext`eyeRadius$ \
$CellContext`nodePercent$) $CellContext`viewVector$, $CellContext`eyeRadius$/
                 10]}]}, AspectRatio -> Automatic]]; $CellContext`eyeEdge$[
           Pattern[$CellContext`\[Theta]$, 
            Blank[]]] := $CellContext`eyeRadius$ {
            Cos[$CellContext`\[Theta]$], 
            Sin[$CellContext`\[Theta]$]}; $CellContext`inRays$[
           PatternTest[
            Pattern[$CellContext`headAimVector$, 
             Blank[]], VectorQ], 
           PatternTest[
            Pattern[$CellContext`fixate$, 
             Blank[]], VectorQ], 
           PatternTest[
            Pattern[$CellContext`distraction$, 
             Blank[]], VectorQ], 
           PatternTest[
            Pattern[$CellContext`base$, 
             Blank[]], VectorQ]] := Show[{
            $CellContext`eyePict$[
             $CellContext`leftEyeCenter$[$CellContext`headAimVector$, \
$CellContext`base$], $CellContext`fixate$], 
            $CellContext`eyePict$[
             $CellContext`rightEyeCenter$[$CellContext`headAimVector$, \
$CellContext`base$], $CellContext`fixate$], 
            Graphics[{Red, {
               Line[{
                 $CellContext`rightEyeNode$[$CellContext`headAimVector$, \
$CellContext`fixate$, $CellContext`base$], \
$CellContext`rightEyeCenter$[$CellContext`headAimVector$, $CellContext`base$] - \
$CellContext`eyeRadius$ \
($CellContext`rightViewVector$[$CellContext`headAimVector$, \
$CellContext`fixate$, $CellContext`base$]/$CellContext`nORM$[
                   $CellContext`rightViewVector$[$CellContext`headAimVector$, \
$CellContext`fixate$, $CellContext`base$]])}]}}], 
            Graphics[{Red, {
               Line[{
                 $CellContext`leftEyeNode$[$CellContext`headAimVector$, \
$CellContext`fixate$, $CellContext`base$], \
$CellContext`leftEyeCenter$[$CellContext`headAimVector$, $CellContext`base$] - \
$CellContext`eyeRadius$ \
($CellContext`leftViewVector$[$CellContext`headAimVector$, \
$CellContext`fixate$, $CellContext`base$]/$CellContext`nORM$[
                   $CellContext`leftViewVector$[$CellContext`headAimVector$, \
$CellContext`fixate$, $CellContext`base$]])}]}}], 
            Graphics[{Blue, {
               Line[{
                 $CellContext`rightEyeNode$[$CellContext`headAimVector$, \
$CellContext`fixate$, $CellContext`base$], \
$CellContext`rightEyeCenter$[$CellContext`headAimVector$, $CellContext`base$] + \
$CellContext`eyeEdge$[$CellContext`right\[CurlyPhi]$[$CellContext`\
headAimVector$, $CellContext`fixate$, $CellContext`base$] - 
                   Pi - $CellContext`right\[Theta]inside$[$CellContext`\
headAimVector$, $CellContext`fixate$, $CellContext`distraction$, \
$CellContext`base$]]}]}}], 
            Graphics[{Blue, {
               Line[{
                 $CellContext`leftEyeNode$[$CellContext`headAimVector$, \
$CellContext`fixate$, $CellContext`base$], \
$CellContext`leftEyeCenter$[$CellContext`headAimVector$, $CellContext`base$] + \
$CellContext`eyeEdge$[$CellContext`left\[CurlyPhi]$[$CellContext`\
headAimVector$, $CellContext`fixate$, $CellContext`base$] - 
                   Pi - $CellContext`left\[Theta]inside$[$CellContext`\
headAimVector$, $CellContext`fixate$, $CellContext`distraction$, \
$CellContext`base$]]}]}}], 
            Graphics[{Purple, {
               Line[{
                 $CellContext`rightEyeCenter$[$CellContext`headAimVector$, \
$CellContext`base$], \
$CellContext`rightEyeCenter$[$CellContext`headAimVector$, $CellContext`base$] + \
$CellContext`eyeEdge$[$CellContext`right\[CurlyPhi]$[$CellContext`\
headAimVector$, $CellContext`fixate$, $CellContext`base$] - 
                   Pi - $CellContext`right\[Theta]inside$[$CellContext`\
headAimVector$, $CellContext`fixate$, $CellContext`distraction$, \
$CellContext`base$]]}]}}], 
            Graphics[{Purple, {
               Line[{
                 $CellContext`leftEyeCenter$[$CellContext`headAimVector$, \
$CellContext`base$], $CellContext`leftEyeCenter$[$CellContext`headAimVector$, \
$CellContext`base$] + \
$CellContext`eyeEdge$[$CellContext`left\[CurlyPhi]$[$CellContext`\
headAimVector$, $CellContext`fixate$, $CellContext`base$] - 
                   Pi - $CellContext`left\[Theta]inside$[$CellContext`\
headAimVector$, $CellContext`fixate$, $CellContext`distraction$, \
$CellContext`base$]]}]}}], 
            Graphics[{Green, {
               Line[
                N[{
                  $CellContext`leftEyeCenter$[$CellContext`headAimVector$, \
$CellContext`base$], 
                  $CellContext`rightEyeCenter$[$CellContext`headAimVector$, \
$CellContext`base$]}]]}}], $CellContext`min$ = 
             Min[{$CellContext`left\[CurlyPhi]$[$CellContext`headAimVector$, \
$CellContext`fixate$, $CellContext`base$] - 
                Pi - $CellContext`left\[Theta]inside$[$CellContext`\
headAimVector$, $CellContext`fixate$, $CellContext`distraction$, \
$CellContext`base$] - \
$CellContext`retinalDisparity$[$CellContext`headAimVector$, \
$CellContext`fixate$, $CellContext`distraction$, $CellContext`base$], \
$CellContext`left\[CurlyPhi]$[$CellContext`headAimVector$, \
$CellContext`fixate$, $CellContext`base$] - 
                Pi - $CellContext`left\[Theta]inside$[$CellContext`\
headAimVector$, $CellContext`fixate$, $CellContext`distraction$, \
$CellContext`base$]}]; $CellContext`MAX$ = 
             Max[{$CellContext`left\[CurlyPhi]$[$CellContext`headAimVector$, \
$CellContext`fixate$, $CellContext`base$] - 
                Pi - $CellContext`left\[Theta]inside$[$CellContext`\
headAimVector$, $CellContext`fixate$, $CellContext`distraction$, \
$CellContext`base$] - \
$CellContext`retinalDisparity$[$CellContext`headAimVector$, \
$CellContext`fixate$, $CellContext`distraction$, $CellContext`base$], \
$CellContext`left\[CurlyPhi]$[$CellContext`headAimVector$, \
$CellContext`fixate$, $CellContext`base$] - 
                Pi - $CellContext`left\[Theta]inside$[$CellContext`\
headAimVector$, $CellContext`fixate$, $CellContext`distraction$, \
$CellContext`base$]}]; Graphics[{Brown, 
               AbsoluteThickness[3], {
                Circle[
                 $CellContext`leftEyeCenter$[$CellContext`headAimVector$, \
$CellContext`base$], $CellContext`eyeRadius$, {$CellContext`min$, \
$CellContext`MAX$}]}}]}, AspectRatio -> Automatic, PlotRange -> {{Part[
                $CellContext`midPoint$[$CellContext`headAimVector$, \
$CellContext`base$], 1] - $CellContext`interOcular$, Part[
                $CellContext`midPoint$[$CellContext`headAimVector$, \
$CellContext`base$], 1] + $CellContext`interOcular$}, {Part[
                $CellContext`midPoint$[$CellContext`headAimVector$, \
$CellContext`base$], 2] - $CellContext`interOcular$, Part[
                $CellContext`midPoint$[$CellContext`headAimVector$, \
$CellContext`base$], 2] + $CellContext`interOcular$}}]; $CellContext`outRays$[
          
           PatternTest[
            Pattern[$CellContext`headAimVector$, 
             Blank[]], VectorQ], 
           PatternTest[
            Pattern[$CellContext`fixate$, 
             Blank[]], VectorQ], 
           PatternTest[
            Pattern[$CellContext`distraction$, 
             Blank[]], VectorQ], 
           PatternTest[
            Pattern[$CellContext`base$, 
             Blank[]], VectorQ]] := Show[{
            Graphics[{Red, 
              AbsolutePointSize[4], {
               Point[
                N[$CellContext`fixate$]]}}], 
            Graphics[{Blue, 
              AbsolutePointSize[4], {
               Point[
                N[$CellContext`distraction$]]}}], 
            Graphics[{Red, {
               Line[
                N[{$CellContext`fixate$, 
                  $CellContext`rightEyeNode$[$CellContext`headAimVector$, \
$CellContext`fixate$, $CellContext`base$]}]]}}], 
            Graphics[{Red, {
               Line[
                N[{$CellContext`fixate$, 
                  $CellContext`leftEyeNode$[$CellContext`headAimVector$, \
$CellContext`fixate$, $CellContext`base$]}]]}}], 
            Graphics[{Blue, {
               Line[
                N[{$CellContext`distraction$, 
                  $CellContext`rightEyeNode$[$CellContext`headAimVector$, \
$CellContext`fixate$, $CellContext`base$]}]]}}], 
            Graphics[{Blue, {
               Line[
                N[{$CellContext`distraction$, 
                  $CellContext`leftEyeNode$[$CellContext`headAimVector$, \
$CellContext`fixate$, $CellContext`base$]}]]}}]}, AspectRatio -> 
           Automatic]; $CellContext`eyeRadius$ = 
         1.3; $CellContext`interOcular$ = 6.5; $CellContext`aimOffset$ = 
         0.125; $CellContext`nodePercent$ = 0.5; $CellContext`headAimVector$[
           Pattern[$CellContext`aim, 
            Blank[]]] := {
           Sin[$CellContext`aim (Pi/180)], 
           Cos[$CellContext`aim (Pi/180)]}; Show[{
           $CellContext`inRays$[
            $CellContext`headAimVector$[$CellContext`aim$$], \
$CellContext`fixate$$, $CellContext`distraction$$, $CellContext`base$$], 
           $CellContext`outRays$[
            $CellContext`headAimVector$[$CellContext`aim$$], \
$CellContext`fixate$$, $CellContext`distraction$$, $CellContext`base$$], 
           Graphics[{
             AbsolutePointSize[4], 
             Point[
              $CellContext`midPoint$[
               $CellContext`headAimVector$[$CellContext`aim$$], \
$CellContext`base$$]]}], 
           Graphics[{Green, 
             AbsolutePointSize[4], {
              Point[$CellContext`base$$], 
              Text["B", $CellContext`base$$ - {0, 0.5}], 
              
              Point[$CellContext`headAimVector$[$CellContext`aim$$] + \
$CellContext`base$$], 
              Text[
              "A", 1.05 $CellContext`headAimVector$[$CellContext`aim$$] + \
$CellContext`base$$ + {0, 0.5}], 
              
              Line[{$CellContext`base$$, \
$CellContext`headAimVector$[$CellContext`aim$$] + $CellContext`base$$}]}}], 
           Graphics[{Red, 
             AbsolutePointSize[4], {
              Point[$CellContext`fixate$$], 
              Text["F", 1.1 $CellContext`fixate$$], 
              Line[{
                $CellContext`leftEyeNode$[
                 $CellContext`headAimVector$[$CellContext`aim$$], \
$CellContext`fixate$$, $CellContext`base$$], $CellContext`fixate$$}], 
              Line[{
                $CellContext`rightEyeNode$[
                 $CellContext`headAimVector$[$CellContext`aim$$], \
$CellContext`fixate$$, $CellContext`base$$], $CellContext`fixate$$}], 
              
              Circle[$CellContext`fixate$$, 
               1, {$CellContext`left\[CurlyPhi]$[
                  $CellContext`headAimVector$[$CellContext`aim$$], \
$CellContext`fixate$$, $CellContext`base$$] + 
                Pi, $CellContext`right\[CurlyPhi]$[
                  $CellContext`headAimVector$[$CellContext`aim$$], \
$CellContext`fixate$$, $CellContext`base$$] + Pi}]}}], 
           Graphics[{Blue, 
             AbsolutePointSize[5], {
              Point[$CellContext`distraction$$], 
              Text["D", 1.05 $CellContext`distraction$$], 
              Line[{
                $CellContext`leftEyeNode$[
                 $CellContext`headAimVector$[$CellContext`aim$$], \
$CellContext`fixate$$, $CellContext`base$$], $CellContext`distraction$$}], 
              Line[{
                $CellContext`rightEyeNode$[
                 $CellContext`headAimVector$[$CellContext`aim$$], \
$CellContext`fixate$$, $CellContext`base$$], $CellContext`distraction$$}], 
              
              Circle[$CellContext`distraction$$, 
               1, {$CellContext`left\[Delta]$[
                  $CellContext`headAimVector$[$CellContext`aim$$], \
$CellContext`fixate$$, $CellContext`distraction$$, $CellContext`base$$] + 
                Pi, $CellContext`right\[Delta]$[
                  $CellContext`headAimVector$[$CellContext`aim$$], \
$CellContext`fixate$$, $CellContext`distraction$$, $CellContext`base$$] + 
                Pi}]}}]}, PlotRange -> {{-9, 9}, {-3, 14}}, AspectRatio -> 
          Automatic, ImageSize -> {400, 400}]], 
      "Specifications" :> {{{$CellContext`base$$, {0, 0}}, {-3, -2}, {3, 0.5},
          ControlType -> Locator}, {{$CellContext`aim$$, 0, "head aim"}, -15, 
         15}, {{$CellContext`fixate$$, {-1.6, 10.43}}, {-7, 6}, {7, 13}, 
         ControlType -> Locator}, {{$CellContext`distraction$$, {2, 13}}, {-8,
          5}, {8, 14}, ControlType -> Locator}}, "Options" :> {}, 
      "DefaultOptions" :> {ControllerLinking -> True}],
     ImageSizeCache->{451., {245., 250.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellID->295219802],

Cell[CellGroupData[{

Cell["CAPTION", "Section",
 CellFrame->{{0, 0}, {1, 0}},
 CellFrameColor->RGBColor[0.87, 0.87, 0.87],
 FontFamily->"Helvetica",
 FontSize->12,
 FontWeight->"Bold",
 FontColor->RGBColor[0.597406, 0, 0.0527047]],

Cell["\<\
This Demonstration shows the horizontal \"fixation plane\" of the eyes. The \
observer is looking mainly at F, but also sees D. The point F is called the \
\"fixate\" and the secondary point D the \"distractor\". You can drag the \
base point, B, fixate point, F, and distractor point, D. The slider lets you \
move the direction of the aim of the head.\
\>", "Text"]
}, Close]]
}, Open  ]],

Cell["\<\
\"Fixation\" means that the point F is aligned so that its image falls on the \
\"fovea\" at the center of the retina where vision is sharpest. As you move \
the various controls, notice that the red lines from F to the back of the eye \
include a diameter of the cross section of the eye. In particular, move F and \
watch the eyes.\
\>", "Text"],

Cell["\<\
The point D represents another object that the viewer also sees, but it is \
not her primary visual attention. \
\>", "Text"],

Cell[TextData[{
 "The scale is very small, with the fixate point 10 ",
 Cell[BoxData[
  FormBox["cm", TraditionalForm]]],
 " from the base point.",
 " ",
 "This scale exaggerates the angles to help see what they measure at normal \
viewing distances."
}], "Text"],

Cell[CellGroupData[{

Cell["DETAILS", "Section",
 CellFrame->{{0, 0}, {1, 0}},
 CellFrameColor->RGBColor[0.87, 0.87, 0.87],
 FontFamily->"Helvetica",
 FontSize->12,
 FontWeight->"Bold",
 FontColor->RGBColor[0.597406, 0, 0.0527047]],

Cell[TextData[{
 "For more information on the fovea, see the ",
 ButtonBox["Wikipedia entry",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://en.wikipedia.org/wiki/Fovea"], None}],
 "."
}], "Text"]
}, Close]],

Cell[CellGroupData[{

Cell["THIS NOTEBOOK IS THE SOURCE CODE FROM", "Text",
 CellFrame->{{0, 0}, {0, 0}},
 CellMargins->{{48, 10}, {4, 28}},
 CellGroupingRules->{"SectionGrouping", 25},
 CellFrameMargins->{{48, 48}, {6, 5}},
 CellFrameColor->RGBColor[0.87, 0.87, 0.87],
 FontFamily->"Helvetica",
 FontSize->10,
 FontWeight->"Bold",
 FontColor->RGBColor[0.597406, 0, 0.0527047]],

Cell[TextData[{
 "\"",
 ButtonBox["Fixation and Distraction (Visual Depth Perception 5)",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/\
FixationAndDistractionVisualDepthPerception5/"], None},
  ButtonNote->
   "http://demonstrations.wolfram.com/\
FixationAndDistractionVisualDepthPerception5/"],
 "\"",
 " from ",
 ButtonBox["the Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->"http://demonstrations.wolfram.com/"],
 "\[ParagraphSeparator]\[NonBreakingSpace]",
 ButtonBox["http://demonstrations.wolfram.com/\
FixationAndDistractionVisualDepthPerception5/",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/\
FixationAndDistractionVisualDepthPerception5/"], None},
  ButtonNote->
   "http://demonstrations.wolfram.com/\
FixationAndDistractionVisualDepthPerception5/"]
}], "Text",
 CellMargins->{{48, Inherited}, {0, Inherited}},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.5]],

Cell[TextData[{
 "Contributed by: ",
 ButtonBox["Keith Stroyan",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/author.html?author=Keith+Stroyan"],
     None},
  ButtonNote->
   "http://demonstrations.wolfram.com/author.html?author=Keith+Stroyan"]
}], "Text",
 CellDingbat->"\[FilledSmallSquare]",
 CellMargins->{{66, 48}, {2, 4}},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.6],
 CellID->95413255],

Cell[CellGroupData[{

Cell[TextData[{
 "A full-function Wolfram ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " system (Version 6 or higher) is required to edit this notebook.\n",
 StyleBox[ButtonBox["GET WOLFRAM MATHEMATICA \[RightGuillemet]",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolfram.com/products/mathematica/"], None},
  ButtonNote->"http://www.wolfram.com/products/mathematica/"],
  FontFamily->"Helvetica",
  FontWeight->"Bold",
  FontSlant->"Italic",
  FontColor->RGBColor[1, 0.42, 0]]
}], "Text",
 CellFrame->True,
 CellMargins->{{48, 68}, {8, 28}},
 CellFrameMargins->12,
 CellFrameColor->RGBColor[0.87, 0.87, 0.87],
 CellChangeTimes->{3.3750111182355957`*^9},
 ParagraphSpacing->{1., 1.},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.411765],
 Background->RGBColor[1, 1, 1]],

Cell[TextData[{
 "\[Copyright] ",
 StyleBox[ButtonBox["Wolfram Demonstrations Project & Contributors",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->"http://demonstrations.wolfram.com/"],
  FontColor->GrayLevel[0.6]],
 "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
 StyleBox[ButtonBox["Terms of Use",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/termsofuse.html"], None},
  ButtonNote->"http://demonstrations.wolfram.com/termsofuse.html"],
  FontColor->GrayLevel[0.6]],
 "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
 StyleBox[ButtonBox["Make a new version of this Demonstration \
\[RightGuillemet]",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/participate/upload.jsp?id=\
FixationAndDistractionVisualDepthPerception5"], None},
  ButtonNote->None],
  FontColor->GrayLevel[0.6]]
}], "Text",
 CellFrame->{{0, 0}, {0, 0.5}},
 CellMargins->{{48, 10}, {20, 50}},
 CellFrameMargins->{{6, 0}, {6, 6}},
 CellFrameColor->GrayLevel[0.6],
 FontFamily->"Verdana",
 FontSize->9,
 FontColor->GrayLevel[0.6]]
}, Open  ]]
}, Open  ]]
},
Editable->True,
Saveable->False,
ScreenStyleEnvironment->"Working",
CellInsertionPointCell->None,
WindowSize->{710, 650},
WindowMargins->{{Inherited, Inherited}, {Inherited, 0}},
WindowElements->{
 "StatusArea", "MemoryMonitor", "MagnificationPopUp", "VerticalScrollBar", 
  "MenuBar"},
WindowTitle->"Fixation and Distraction (Visual Depth Perception 5) - Source",
DockedCells->{},
CellContext->Notebook,
FrontEndVersion->"8.0 for Microsoft Windows (32-bit) (November 7, 2010)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[654, 23, 172, 3, 70, "Section"],
Cell[829, 28, 3700, 64, 70, "Section"],
Cell[4532, 94, 50071, 1148, 70, "Input",
 CellID->1618709942]
}, Open  ]],
Cell[CellGroupData[{
Cell[54640, 1247, 32840, 706, 70, "Output",
 CellID->295219802],
Cell[CellGroupData[{
Cell[87505, 1957, 209, 6, 70, "Section"],
Cell[87717, 1965, 377, 6, 70, "Text"]
}, Close]]
}, Open  ]],
Cell[88120, 1975, 357, 6, 70, "Text"],
Cell[88480, 1983, 135, 3, 70, "Text"],
Cell[88618, 1988, 263, 8, 70, "Text"],
Cell[CellGroupData[{
Cell[88906, 2000, 209, 6, 70, "Section"],
Cell[89118, 2008, 207, 7, 70, "Text"]
}, Close]],
Cell[CellGroupData[{
Cell[89361, 2020, 355, 9, 70, "Text",
 CellGroupingRules->{"SectionGrouping", 25}],
Cell[89719, 2031, 1067, 31, 70, "Text"],
Cell[90789, 2064, 455, 15, 70, "Text",
 CellID->95413255],
Cell[CellGroupData[{
Cell[91269, 2083, 815, 24, 70, "Text"],
Cell[92087, 2109, 1216, 33, 70, "Text"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
(* NotebookSignature 2QzFR8rWVzAoaADM06EZkEfB *)
