(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     31754,        719]
NotebookOptionsPosition[     30509,        673]
NotebookOutlinePosition[     31167,        698]
CellTagsIndexPosition[     31124,        695]
WindowTitle->Dispersion of Light through a Prism - Source
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Dispersion of Light through a Prism", "Section",
 CellFrame->{{0, 0}, {0, 0}},
 ShowCellBracket->False,
 FontColor->RGBColor[0.597406, 0, 0.0527047]],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztnVuSozgWQDNiPqa3MJ+zpVlCbaB3WlGVNV9dvYH6TQRUph/ZGIHQmwvG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   "], {{0, 0}, {1800, 25}}, {0, 255},
   ColorFunction->RGBColor],
  ImageSize->{1800, 25},
  PlotRange->{{0, 1800}, {0, 25}}]], "Section",
 CellFrame->{{0, 0}, {0, 0}},
 ShowCellBracket->False],

Cell[BoxData[
 RowBox[{"Manipulate", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Line", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "1"}], ",", 
            RowBox[{"-", 
             SqrtBox["3"]}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"1", ",", 
            RowBox[{"-", 
             SqrtBox["3"]}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "1"}], ",", 
            RowBox[{"-", 
             SqrtBox["3"]}]}], "}"}]}], "}"}], "]"}], ",", "Thick", ",", 
       "White", ",", "\[IndentingNewLine]", 
       RowBox[{"Rotate", "[", 
        RowBox[{
         RowBox[{"Line", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"-", "4"}], ",", 
              RowBox[{
               RowBox[{"-", 
                SqrtBox["3"]}], "/", "2"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "1"}], "/", "2"}], ",", 
              RowBox[{
               RowBox[{"-", 
                SqrtBox["3"]}], "/", "2"}]}], "}"}]}], "}"}], "]"}], ",", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"\[Theta]", "-", "30"}], ")"}], "\[Degree]"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "1"}], "/", "2"}], ",", 
           RowBox[{
            RowBox[{"-", 
             SqrtBox["3"]}], "/", "2"}]}], "}"}]}], "]"}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"color", "[", 
            RowBox[{"[", "k", "]"}], "]"}], ",", 
           RowBox[{"Line", "[", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{
                RowBox[{
                 RowBox[{"-", "1"}], "/", "2"}], ",", 
                RowBox[{
                 RowBox[{"-", 
                  SqrtBox["3"]}], "/", "2"}]}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"x", "[", 
                 RowBox[{"k", ",", "\[Theta]"}], "]"}], ",", 
                RowBox[{
                 RowBox[{"-", 
                  SqrtBox["3"]}], 
                 RowBox[{"x", "[", 
                  RowBox[{"k", ",", "\[Theta]"}], "]"}]}]}], "}"}], ",", 
              "\[IndentingNewLine]", 
              RowBox[{"{", 
               RowBox[{"2.5", ",", 
                RowBox[{
                 RowBox[{
                  RowBox[{"-", 
                   RowBox[{"Tan", "[", 
                    RowBox[{"\[CapitalTheta]", "[", 
                    RowBox[{"k", ",", "\[Theta]"}], "]"}], "]"}]}], 
                  RowBox[{"x", "[", 
                   RowBox[{"k", ",", "\[Theta]"}], "]"}]}], "-", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    SqrtBox["3"], "+", 
                    RowBox[{"Tan", "[", 
                    RowBox[{
                    RowBox[{"\[CapitalTheta]", "[", 
                    RowBox[{"k", ",", "\[Theta]"}], "]"}], "-", 
                    RowBox[{"\[Pi]", "/", "6"}]}], "]"}]}], ")"}], 
                  RowBox[{"x", "[", 
                   RowBox[{"k", ",", "\[Theta]"}], "]"}]}]}]}], "}"}]}], 
             "}"}], "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"k", ",", "1", ",", "7"}], "}"}]}], "]"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"ImageSize", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"575", ",", "475"}], "}"}]}], ",", 
     RowBox[{"PlotRange", " ", "\[Rule]", " ", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1.5"}], ",", "2.5"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{".5", ",", 
          RowBox[{
           RowBox[{"-", "2"}], 
           SqrtBox["3"]}]}], "}"}]}], "}"}]}], ",", 
     RowBox[{"Background", "\[Rule]", "LightGray"}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "\[Theta]", ",", "60", ",", "\"\<prism incidence angle (deg)\>\""}], 
      "}"}], ",", "40", " ", ",", "80", " ", ",", "1", " ", ",", 
     RowBox[{"Appearance", " ", "\[Rule]", " ", "\"\<Labeled\>\""}]}], "}"}], 
   ",", 
   RowBox[{"TrackedSymbols", "\[RuleDelayed]", 
    RowBox[{"{", "\[Theta]", "}"}]}], ",", 
   RowBox[{"ControlPlacement", "\[Rule]", "Top"}], ",", "\[IndentingNewLine]", 
   RowBox[{"Initialization", "\[RuleDelayed]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"color", "=", 
       RowBox[{"{", 
        RowBox[{"Magenta", ",", 
         RowBox[{"Lighter", "[", "Blue", "]"}], ",", "Blue", ",", "Green", 
         ",", " ", "Yellow", ",", " ", "Orange", ",", " ", "Red"}], "}"}]}], 
      ";", 
      RowBox[{
       RowBox[{"n", "[", "k_", "]"}], ":=", 
       RowBox[{"1.6", "-", 
        RowBox[{".02", "k"}]}]}], ";", 
      RowBox[{
       RowBox[{"m", "[", 
        RowBox[{"k_", ",", "\[Theta]_"}], "]"}], ":=", 
       RowBox[{"Tan", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "\[Pi]"}], "/", "6"}], "+", 
         RowBox[{"ArcSin", "[", 
          RowBox[{
           RowBox[{"Sin", "[", 
            RowBox[{"\[Theta]", " ", "\[Degree]"}], "]"}], "/", 
           RowBox[{"n", "[", "k", "]"}]}], "]"}]}], "]"}]}], ";", 
      RowBox[{
       RowBox[{"x", "[", 
        RowBox[{"k_", ",", "\[Theta]_"}], "]"}], ":=", 
       RowBox[{
        FractionBox["1", "2"], 
        RowBox[{"(", 
         FractionBox[
          RowBox[{
           SqrtBox["3"], "-", 
           RowBox[{"m", "[", 
            RowBox[{"k", ",", "\[Theta]"}], "]"}]}], 
          RowBox[{
           SqrtBox["3"], "+", 
           RowBox[{"m", "[", 
            RowBox[{"k", ",", "\[Theta]"}], "]"}]}]], ")"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"\[CapitalTheta]", "[", 
        RowBox[{"k_", ",", "\[Theta]_"}], "]"}], ":=", 
       RowBox[{"ArcSin", "[", 
        RowBox[{
         RowBox[{"n", "[", "k", "]"}], 
         RowBox[{"Sin", "[", 
          RowBox[{
           RowBox[{"\[Pi]", "/", "3"}], "-", 
           RowBox[{"ArcSin", "[", 
            RowBox[{
             RowBox[{"Sin", "[", 
              RowBox[{"\[Theta]", " ", "\[Degree]"}], "]"}], "/", 
             RowBox[{"n", "[", "k", "]"}]}], "]"}]}], "]"}]}], "]"}]}], ";"}],
      ")"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.393095767586604*^9, 3.3930958075087347`*^9}, {
   3.393097673098799*^9, 3.393097807865287*^9}, {3.3930980338823586`*^9, 
   3.393098041866784*^9}, {3.3931006197426577`*^9, 3.393100683524316*^9}, {
   3.3931007353840227`*^9, 3.393100736040277*^9}, {3.3931016304835014`*^9, 
   3.393101646811731*^9}, {3.393101754687421*^9, 3.3931018216097245`*^9}, 
   3.393101859969345*^9, {3.393151897010124*^9, 3.393151919544114*^9}, {
   3.393151974769579*^9, 3.393151985177094*^9}, {3.393152263320287*^9, 
   3.393152339860843*^9}, {3.393153643034915*^9, 3.393153680508221*^9}, {
   3.393154455883745*^9, 3.3931544969981194`*^9}, {3.3931550213743753`*^9, 
   3.393155029031557*^9}, {3.3931552055530195`*^9, 3.3931552732800035`*^9}, 
   3.3931553668851347`*^9, {3.393155417985098*^9, 3.3931554202978787`*^9}, {
   3.3931561109287243`*^9, 3.393156119804804*^9}, {3.3931561853909025`*^9, 
   3.393156185844083*^9}, {3.39315717438615*^9, 3.3931571869970584`*^9}, 
   3.3931573296394014`*^9, {3.3931574661091194`*^9, 3.3931574718129377`*^9}, {
   3.3931586938677716`*^9, 3.393158715214117*^9}, {3.393159544564954*^9, 
   3.3931596008530474`*^9}, {3.3931597043187523`*^9, 
   3.3931597803905015`*^9}, {3.3931598146759205`*^9, 
   3.3931598675260963`*^9}, {3.3931599198449574`*^9, 3.393160047079177*^9}, {
   3.393160432969846*^9, 3.3931604430179424`*^9}, {3.393160989224978*^9, 
   3.3931610014608407`*^9}, {3.393161074422837*^9, 3.3931611020199423`*^9}, {
   3.3931611332581153`*^9, 3.393161157589199*^9}, {3.393161202594671*^9, 
   3.393161204032346*^9}, {3.3931612428026843`*^9, 3.393161254804144*^9}, {
   3.3931616545402455`*^9, 3.393161661791127*^9}, {3.393161705780851*^9, 
   3.3931617472858973`*^9}, {3.393161792978953*^9, 3.393161793525894*^9}, {
   3.393161831327365*^9, 3.393161911587124*^9}, {3.3931735798808155`*^9, 
   3.3931735933824573`*^9}, {3.3931738527733707`*^9, 3.393173879479742*^9}, {
   3.3931739268292494`*^9, 3.3931739802888746`*^9}, 3.3931740370457754`*^9, {
   3.393174362741625*^9, 3.393174401652606*^9}, {3.3931745044776077`*^9, 
   3.3931745063840895`*^9}, {3.3931746426350307`*^9, 3.393174643072584*^9}, {
   3.3931754921758223`*^9, 3.3931755683725867`*^9}, {3.3931756206758213`*^9, 
   3.393175621660316*^9}, {3.3931757023420005`*^9, 3.3931757050923347`*^9}, {
   3.3931762218895445`*^9, 3.3931762224052324`*^9}, {3.393176274739721*^9, 
   3.393176275302289*^9}, {3.3931770710240374`*^9, 3.393177099808787*^9}, {
   3.3931771497679863`*^9, 3.393177221636099*^9}, 3.393177734151539*^9, {
   3.3931779572454004`*^9, 3.393178010675344*^9}, {3.393178104008663*^9, 
   3.3931781940336394`*^9}, {3.3931787965500464`*^9, 3.393178853004123*^9}, {
   3.39317889187875*^9, 3.3931789005435767`*^9}, {3.39317903707314*^9, 
   3.3931790408672967`*^9}, {3.393179476324894*^9, 3.393179565608053*^9}, {
   3.393181194804206*^9, 3.3931812146936855`*^9}, {3.393181245270049*^9, 
   3.3931812721591253`*^9}, {3.393181303688559*^9, 3.393181444336707*^9}, {
   3.393181644778286*^9, 3.393181662683505*^9}, {3.3931817223206944`*^9, 
   3.3931817365386257`*^9}, {3.3931827755568995`*^9, 
   3.3931829176424646`*^9}, {3.3931829587650957`*^9, 3.393182989982048*^9}, {
   3.3931830342763715`*^9, 3.3931830345732293`*^9}, {3.393183077461384*^9, 
   3.393183083711024*^9}, {3.393183120833885*^9, 3.3931831549412956`*^9}, {
   3.3931832628569546`*^9, 3.393183277465488*^9}, {3.393183361726259*^9, 
   3.3931834058487177`*^9}, {3.393183455673972*^9, 3.3931834857659893`*^9}, {
   3.393183515936126*^9, 3.3931835722297583`*^9}, {3.39318360718087*^9, 
   3.393183720486843*^9}, {3.3931837864361696`*^9, 3.393183804513253*^9}, {
   3.3931838388706493`*^9, 3.3931838848679996`*^9}, {3.393184509800751*^9, 
   3.393184548798505*^9}, {3.393184672931979*^9, 3.3931846740569143`*^9}, {
   3.3932450155253596`*^9, 3.393245067008416*^9}, {3.393245132131749*^9, 
   3.393245169958906*^9}, {3.3932452167233334`*^9, 3.393245236597825*^9}, {
   3.393245343423215*^9, 3.3932453671882315`*^9}, {3.3932456765540805`*^9, 
   3.393245681819537*^9}, {3.3932560565798225`*^9, 3.3932560836050515`*^9}, {
   3.3932562105606484`*^9, 3.3932562547315936`*^9}, {3.393256601178469*^9, 
   3.393256660794711*^9}, {3.3932567377254477`*^9, 3.393256764322261*^9}, {
   3.393258055615574*^9, 3.393258071131099*^9}, 3.393258933016208*^9, {
   3.393258991390835*^9, 3.393258996203304*^9}, {3.3932624838756037`*^9, 
   3.3932625679197893`*^9}, {3.3932627781005635`*^9, 3.39326278586594*^9}, 
   3.393262817880541*^9, {3.393262996265457*^9, 3.3932630088119307`*^9}, {
   3.393263128698719*^9, 3.3932631508230114`*^9}, {3.3932632085867877`*^9, 
   3.393263209024274*^9}, {3.3932633199738483`*^9, 3.393263345254289*^9}, {
   3.393264684586429*^9, 3.3932646933986473`*^9}, {3.394971419584529*^9, 
   3.394971460209789*^9}, {3.3949715089288507`*^9, 3.394971585226214*^9}, {
   3.3949716205858154`*^9, 3.39497163380465*^9}, {3.3949718167589455`*^9, 
   3.3949718717592974`*^9}, {3.3949719103064194`*^9, 
   3.3949719993226137`*^9}, {3.3949720323228254`*^9, 3.394972039807248*^9}, {
   3.394972096198234*^9, 3.3949721676986914`*^9}, {3.5357484199849463`*^9, 
   3.535748422927297*^9}, {3.53574862227096*^9, 3.535748630064617*^9}, {
   3.535751392396373*^9, 3.5357515805918283`*^9}, {3.535751653838718*^9, 
   3.5357516560290327`*^9}, 3.53575235260853*^9, {3.53575239927029*^9, 
   3.535752413173709*^9}, {3.535752485591243*^9, 3.5357524969348497`*^9}, {
   3.535752539248321*^9, 3.5357527080003242`*^9}, {3.535752744610705*^9, 
   3.5357528233960743`*^9}, {3.535752956400343*^9, 3.53575296320091*^9}, {
   3.535753021453538*^9, 3.5357531052639093`*^9}, 3.535753172140297*^9, {
   3.5357532055177383`*^9, 3.5357532059462757`*^9}, {3.535753277245599*^9, 
   3.535753402513302*^9}, {3.5357534687195883`*^9, 3.5357534753345013`*^9}, {
   3.535753512333518*^9, 3.5357535163155613`*^9}, {3.535753663997444*^9, 
   3.5357536809478188`*^9}, {3.535753711061513*^9, 3.535753740262352*^9}, {
   3.535753771009512*^9, 3.5357537766969967`*^9}, {3.535816805503769*^9, 
   3.535816885298232*^9}, {3.535816970103971*^9, 3.535817193060219*^9}, 
   3.535817625594316*^9, {3.5358177045474577`*^9, 3.535817913023616*^9}, {
   3.535821078618133*^9, 3.5358210851917477`*^9}, {3.535824755753375*^9, 
   3.5358247911189203`*^9}, {3.535824832009912*^9, 3.535824851663306*^9}, {
   3.5358293909949427`*^9, 3.535829417786442*^9}, {3.5358296429958973`*^9, 
   3.535829665596239*^9}, {3.535829804444025*^9, 3.5358298327770643`*^9}, {
   3.535830041371539*^9, 3.535830054306561*^9}, {3.535830288656021*^9, 
   3.535830372020423*^9}, {3.535830436275488*^9, 3.535830533502913*^9}, {
   3.535830744309609*^9, 3.535830783200943*^9}, {3.535831100999626*^9, 
   3.535831110424253*^9}, {3.5358311677059*^9, 3.535831192177313*^9}, 
   3.535831288356018*^9, {3.5358313184369907`*^9, 3.535831362808587*^9}, {
   3.535831407717008*^9, 3.535831410310211*^9}, 3.535831444170033*^9, {
   3.535831524359375*^9, 3.535831547101645*^9}, {3.535831583177312*^9, 
   3.5358315842381563`*^9}, {3.535831902521656*^9, 3.535831933408268*^9}, {
   3.5358320399427*^9, 3.535832082868773*^9}, {3.535832122622241*^9, 
   3.535832150991288*^9}, {3.535832192953147*^9, 3.535832225722797*^9}, {
   3.535833520048704*^9, 3.535833526740407*^9}, {3.535833560335186*^9, 
   3.5358337465006332`*^9}, {3.53583381145295*^9, 3.5358339461559343`*^9}, {
   3.535834051930861*^9, 3.535834152237891*^9}, {3.535834198457597*^9, 
   3.5358342043445177`*^9}, {3.5358342982648478`*^9, 3.535834525400877*^9}, {
   3.535834564901713*^9, 3.535834589969186*^9}, {3.535838627133132*^9, 
   3.535838661296897*^9}, {3.5358390967940817`*^9, 3.535839368585206*^9}, {
   3.535839415698975*^9, 3.535839439490025*^9}, 3.535839486707878*^9, {
   3.535839651626896*^9, 3.5358397488604717`*^9}, {3.535840293096882*^9, 
   3.5358403028635674`*^9}, 3.535840419462867*^9, 3.535840501942007*^9, {
   3.535840544655208*^9, 3.535840562805958*^9}, {3.5358405965481052`*^9, 
   3.535840616097036*^9}, {3.5358406530504227`*^9, 3.5358406562296667`*^9}, 
   3.535840701108886*^9, {3.535840769791506*^9, 3.5358408163288593`*^9}, {
   3.53584089219016*^9, 3.535840910569285*^9}, {3.53584109447742*^9, 
   3.535841109261217*^9}, {3.535841143495521*^9, 3.535841158640699*^9}, {
   3.5358411901170263`*^9, 3.535841206623323*^9}, {3.5358424939684477`*^9, 
   3.5358425360916567`*^9}, {3.5358425812635527`*^9, 3.535842665277072*^9}, {
   3.535842982052693*^9, 3.5358429934113283`*^9}, {3.535844148601973*^9, 
   3.5358442524863567`*^9}, {3.535844291556554*^9, 3.535844345580597*^9}, {
   3.535844376947261*^9, 3.535844409786182*^9}, {3.535844444896762*^9, 
   3.535844450474732*^9}, 3.535844572039609*^9, {3.535846458925726*^9, 
   3.535846461210709*^9}, {3.535847089223858*^9, 3.535847246930169*^9}, {
   3.535847292348365*^9, 3.5358472980884323`*^9}, {3.535847345005611*^9, 
   3.5358473632006207`*^9}, {3.535847400281044*^9, 3.535847401427908*^9}, {
   3.53584746083022*^9, 3.535847488109262*^9}, {3.5358493746984367`*^9, 
   3.535849381100011*^9}, {3.5358494720835943`*^9, 3.535849489371461*^9}, {
   3.535849537523864*^9, 3.535849583983239*^9}, 3.53584966470601*^9, 
   3.5358497739288263`*^9, {3.535849805736246*^9, 3.535849852609296*^9}, {
   3.5358499177461853`*^9, 3.535849950766603*^9}, {3.535850356614429*^9, 
   3.535850384575663*^9}, 3.535850524348134*^9, 3.535850566533022*^9, {
   3.535850696978228*^9, 3.535850756401932*^9}, 3.5358508565671797`*^9, {
   3.53585089433969*^9, 3.535850903652726*^9}, 3.53585094621216*^9, {
   3.535851104354521*^9, 3.5358511138484917`*^9}, 3.5358511796823273`*^9, {
   3.5358512301816597`*^9, 3.535851237716199*^9}, {3.535851270527772*^9, 
   3.535851275758658*^9}, 3.535851327240058*^9, {3.535851370299571*^9, 
   3.535851371730875*^9}, 3.5358514272808447`*^9, 3.535851465383308*^9, {
   3.535851524382144*^9, 3.535851548657881*^9}, {3.535851936659096*^9, 
   3.535851941690037*^9}, 3.535851995709511*^9, {3.535852035807227*^9, 
   3.5358520436552353`*^9}, {3.535852098537492*^9, 3.535852100087569*^9}, {
   3.536408151998633*^9, 3.536408186908456*^9}, {3.5364083501574583`*^9, 
   3.5364083672443953`*^9}, {3.5364083996053333`*^9, 3.536408436265895*^9}, {
   3.536408467121798*^9, 3.536408474415889*^9}},
 CellID->50152040]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`\[Theta]$$ = 60, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`\[Theta]$$], 60, "prism incidence angle (deg)"}, 40, 
      80, 1}}, Typeset`size$$ = {575., {235., 240.}}, Typeset`update$$ = 0, 
    Typeset`initDone$$, Typeset`skipInitDone$$ = 
    False, $CellContext`\[Theta]$829$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`\[Theta]$$ = 60}, 
      "ControllerVariables" :> {
        Hold[$CellContext`\[Theta]$$, $CellContext`\[Theta]$829$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Graphics[{
         Line[{{-1, -3^Rational[1, 2]}, {0, 0}, {
           1, -3^Rational[1, 2]}, {-1, -3^Rational[1, 2]}}], Thick, White, 
         Rotate[
          
          Line[{{-4, (-3^Rational[1, 2])/2}, {(-1)/2, (-3^Rational[1, 2])/
             2}}], ($CellContext`\[Theta]$$ - 30) 
          Degree, {(-1)/2, (-3^Rational[1, 2])/2}], 
         Table[{
           Part[$CellContext`color, $CellContext`k], 
           Line[{{(-1)/2, (-3^Rational[1, 2])/2}, {
              $CellContext`x[$CellContext`k, $CellContext`\[Theta]$$], (-3^
                Rational[
                 1, 2]) $CellContext`x[$CellContext`k, \
$CellContext`\[Theta]$$]}, {2.5, (-Tan[
                  $CellContext`\[CapitalTheta][$CellContext`k, $CellContext`\
\[Theta]$$]]) $CellContext`x[$CellContext`k, $CellContext`\[Theta]$$] - (
               3^Rational[1, 2] + 
               Tan[$CellContext`\[CapitalTheta][$CellContext`k, $CellContext`\
\[Theta]$$] - Pi/
                 6]) $CellContext`x[$CellContext`k, \
$CellContext`\[Theta]$$]}}]}, {$CellContext`k, 1, 7}]}, 
        ImageSize -> {575, 475}, 
        PlotRange -> {{-1.5, 2.5}, {0.5, (-2) 3^Rational[1, 2]}}, Background -> 
        LightGray], 
      "Specifications" :> {{{$CellContext`\[Theta]$$, 60, 
          "prism incidence angle (deg)"}, 40, 80, 1, Appearance -> 
         "Labeled"}}, 
      "Options" :> {
       TrackedSymbols :> {$CellContext`\[Theta]$$}, ControlPlacement -> Top}, 
      "DefaultOptions" :> {ControllerLinking -> True}],
     ImageSizeCache->{620., {279., 284.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    Initialization:>(($CellContext`color = {Magenta, 
         Lighter[Blue], Blue, Green, Yellow, Orange, Red}; $CellContext`n[
         Pattern[$CellContext`k, 
          Blank[]]] := 1.6 - 0.02 $CellContext`k; $CellContext`m[
         Pattern[$CellContext`k, 
          Blank[]], 
         Pattern[$CellContext`\[Theta], 
          Blank[]]] := 
       Tan[(-Pi)/6 + 
         ArcSin[Sin[$CellContext`\[Theta] 
             Degree]/$CellContext`n[$CellContext`k]]]; $CellContext`x[
         Pattern[$CellContext`k, 
          Blank[]], 
         Pattern[$CellContext`\[Theta], 
          Blank[]]] := (1/
         2) ((3^Rational[
            1, 2] - $CellContext`m[$CellContext`k, $CellContext`\[Theta]])/(
         3^Rational[
           1, 2] + $CellContext`m[$CellContext`k, $CellContext`\[Theta]])); \
$CellContext`\[CapitalTheta][
         Pattern[$CellContext`k, 
          Blank[]], 
         Pattern[$CellContext`\[Theta], 
          Blank[]]] := 
       ArcSin[$CellContext`n[$CellContext`k] 
         Sin[Pi/3 - ArcSin[
           Sin[$CellContext`\[Theta] 
              Degree]/$CellContext`n[$CellContext`k]]]]; Null); 
     Typeset`initDone$$ = True),
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellID->540216353],

Cell[CellGroupData[{

Cell["CAPTION", "Section",
 CellFrame->{{0, 0}, {1, 0}},
 CellFrameColor->RGBColor[0.87, 0.87, 0.87],
 FontFamily->"Helvetica",
 FontSize->12,
 FontWeight->"Bold",
 FontColor->RGBColor[0.597406, 0, 0.0527047]],

Cell["\<\
This Demonstration shows the dispersion of white light through a prism as the \
incidence angle is varied.\
\>", "Text"]
}, Close]]
}, Open  ]],

Cell["\<\
When a light ray passes from one medium to another at an angle, it refracts \
(or bends). The refraction of light at the interface is governed by Snell's \
law. White light is a combination of different colors in the visible \
spectrum, and different colors have different indexes of refraction. Thus, \
when the ray of white light passes through a prism, the colors refract at \
different angles. The frequency variation of the index of refraction has been \
slightly exaggerated for better graphic representation.\
\>", "Text"],

Cell["\<\
Borosilicate optical glass has an index of refraction varying between 1.51 to \
1.53 in the visible range.\
\>", "Text"],

Cell["THIS NOTEBOOK IS THE SOURCE CODE FROM", "Text",
 CellFrame->{{0, 0}, {0, 0}},
 CellMargins->{{48, 10}, {4, 28}},
 CellGroupingRules->{"SectionGrouping", 25},
 CellFrameMargins->{{48, 48}, {6, 5}},
 CellFrameColor->RGBColor[0.87, 0.87, 0.87],
 FontFamily->"Helvetica",
 FontSize->10,
 FontWeight->"Bold",
 FontColor->RGBColor[0.597406, 0, 0.0527047]],

Cell[TextData[{
 "\[NonBreakingSpace]",
 ButtonBox["Siva Perla",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/author.html?author=Siva+Perla"], 
    None},
  ButtonNote->
   "http://demonstrations.wolfram.com/author.html?author=Siva+Perla"]
}], "Text",
 CellMargins->{{48, Inherited}, {0, Inherited}},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.6]],

Cell[TextData[{
 "\"",
 ButtonBox["Dispersion of Light through a Prism",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/DispersionOfLightThroughAPrism/"], 
    None},
  ButtonNote->
   "http://demonstrations.wolfram.com/DispersionOfLightThroughAPrism/"],
 "\"",
 "\[ParagraphSeparator]\[NonBreakingSpace]",
 ButtonBox["http://demonstrations.wolfram.com/DispersionOfLightThroughAPrism/",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/DispersionOfLightThroughAPrism/"], 
    None},
  ButtonNote->
   "http://demonstrations.wolfram.com/DispersionOfLightThroughAPrism/"],
 "\[ParagraphSeparator]\[NonBreakingSpace]",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->"http://demonstrations.wolfram.com/"],
 "\[ParagraphSeparator]\[NonBreakingSpace]",
 "Published: ",
 "August 3, 2007"
}], "Text",
 CellMargins->{{48, Inherited}, {0, Inherited}},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.5]],

Cell[CellGroupData[{

Cell[TextData[{
 "A full-function Wolfram ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " system is required to edit this notebook.\n",
 StyleBox[ButtonBox["GET WOLFRAM MATHEMATICA \[RightGuillemet]",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolfram.com/products/mathematica/"], None},
  ButtonNote->"http://www.wolfram.com/products/mathematica/"],
  FontFamily->"Helvetica",
  FontWeight->"Bold",
  FontSlant->"Italic",
  FontColor->RGBColor[1, 0.42, 0]]
}], "Text",
 CellFrame->True,
 CellMargins->{{48, 68}, {8, 28}},
 CellFrameMargins->12,
 CellFrameColor->RGBColor[0.87, 0.87, 0.87],
 CellChangeTimes->{3.3750111182355957`*^9},
 ParagraphSpacing->{1., 1.},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.411765],
 Background->RGBColor[1, 1, 1]],

Cell[TextData[{
 "\[Copyright] ",
 StyleBox[ButtonBox["Wolfram Demonstrations Project & Contributors",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->"http://demonstrations.wolfram.com/"],
  FontColor->GrayLevel[0.6]],
 "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
 StyleBox[ButtonBox["Terms of Use",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/termsofuse.html"], None},
  ButtonNote->"http://demonstrations.wolfram.com/termsofuse.html"],
  FontColor->GrayLevel[0.6]],
 "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
 StyleBox[ButtonBox["Make a new version of this Demonstration \
\[RightGuillemet]",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/participate/upload.jsp?id=\
DispersionOfLightThroughAPrism"], None},
  ButtonNote->None],
  FontColor->GrayLevel[0.6]]
}], "Text",
 CellFrame->{{0, 0}, {0, 0.5}},
 CellMargins->{{48, 10}, {20, 50}},
 CellFrameMargins->{{6, 0}, {6, 6}},
 CellFrameColor->GrayLevel[0.6],
 FontFamily->"Verdana",
 FontSize->9,
 FontColor->GrayLevel[0.6]]
}, Open  ]]
},
Editable->True,
Saveable->False,
ScreenStyleEnvironment->"Working",
CellInsertionPointCell->None,
WindowSize->{780, 650},
WindowMargins->{{Inherited, Inherited}, {Inherited, 0}},
WindowElements->{
 "StatusArea", "MemoryMonitor", "MagnificationPopUp", "VerticalScrollBar", 
  "MenuBar"},
WindowTitle->"Dispersion of Light through a Prism - Source",
DockedCells->{},
CellContext->Notebook,
FrontEndVersion->"8.0 for Microsoft Windows (32-bit) (February 23, 2011)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[637, 23, 155, 3, 70, "Section"],
Cell[795, 28, 3700, 64, 70, "Section"],
Cell[4498, 94, 16914, 328, 70, "Input",
 CellID->50152040]
}, Open  ]],
Cell[CellGroupData[{
Cell[21449, 427, 4095, 89, 70, "Output",
 CellID->540216353],
Cell[CellGroupData[{
Cell[25569, 520, 209, 6, 70, "Section"],
Cell[25781, 528, 130, 3, 70, "Text"]
}, Close]]
}, Open  ]],
Cell[25937, 535, 539, 8, 70, "Text"],
Cell[26479, 545, 130, 3, 70, "Text"],
Cell[26612, 550, 355, 9, 70, "Text",
 CellGroupingRules->{"SectionGrouping", 25}],
Cell[26970, 561, 407, 13, 70, "Text"],
Cell[27380, 576, 1090, 31, 70, "Text"],
Cell[CellGroupData[{
Cell[28495, 611, 793, 24, 70, "Text"],
Cell[29291, 637, 1202, 33, 70, "Text"]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
(* NotebookSignature TRNNNC1vlrFnTCDIwaQPpFaa *)
