(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[   1112914,      20895]
NotebookOptionsPosition[   1111666,      20848]
NotebookOutlinePosition[   1112313,      20873]
CellTagsIndexPosition[   1112270,      20870]
WindowTitle->Designing Optical Systems - Source
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Designing Optical Systems", "Section",
 CellFrame->{{0, 0}, {0, 0}},
 ShowCellBracket->False,
 FontColor->RGBColor[0.597406, 0, 0.0527047]],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztnVuSozgWQDNiPqa3MJ+zpVlCbaB3WlGVNV9dvYH6TQRUph/ZGIHQmwvG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   "], {{0, 0}, {1800, 25}}, {0, 255},
   ColorFunction->RGBColor],
  ImageSize->{1800, 25},
  PlotRange->{{0, 1800}, {0, 25}}]], "Section",
 CellFrame->{{0, 0}, {0, 0}},
 ShowCellBracket->False],

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"Deploy", "[", 
    RowBox[{"LensLayout", "[", 
     RowBox[{"{", 
      RowBox[{
      "wavelength1", ",", "wavelength2", ",", "sourceAngle", ",", "sourceXY1",
        ",", "sourceXY2", ",", "lensAngle", ",", "thicknessAndAperture1", ",",
        "thicknessAndAperture2", ",", "curvature1", ",", "curvature2", ",", 
       "lensLocation1", ",", "lensLocation2"}], "}"}], "]"}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "wavelength1", ",", "0.532", ",", 
       "\"\<\!\(\*SubscriptBox[\(\[Lambda]\), \(1\)]\)\>\""}], "}"}], ",", 
     ".2", ",", "1", ",", 
     RowBox[{"ControlType", "\[Rule]", "Manipulator"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "wavelength2", ",", "0.532", ",", 
       "\"\<\!\(\*SubscriptBox[\(\[Lambda]\), \(2\)]\)\>\""}], "}"}], ",", 
     ".2", ",", "1", ",", 
     RowBox[{"ControlType", "\[Rule]", "Manipulator"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"sourceAngle", ",", 
       RowBox[{"{", 
        RowBox[{"0.", ",", "0."}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "Pi"}], ",", 
       RowBox[{"-", "Pi"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"Pi", ",", "Pi"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"sourceXY1", ",", 
       RowBox[{"{", 
        RowBox[{"0.", ",", "0."}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "80"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"200", ",", "80"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"sourceXY2", ",", 
       RowBox[{"{", 
        RowBox[{"0.", ",", "10."}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "80"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"200", ",", "80"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"lensAngle", ",", 
       RowBox[{"{", 
        RowBox[{"0.", ",", "0."}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "Pi"}], ",", 
       RowBox[{"-", "Pi"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"Pi", ",", "Pi"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"thicknessAndAperture1", ",", 
       RowBox[{"{", 
        RowBox[{"10.", ",", "50."}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"100", ",", "100"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"thicknessAndAperture2", ",", 
       RowBox[{"{", 
        RowBox[{"10.", ",", "50."}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"100", ",", "100"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"curvature1", ",", 
       RowBox[{"{", 
        RowBox[{"0.01", ",", 
         RowBox[{"-", "0.01"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.03"}], ",", 
       RowBox[{"-", "0.03"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.03", ",", "0.03"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"curvature2", ",", 
       RowBox[{"{", 
        RowBox[{"0.01", ",", 
         RowBox[{"-", "0.01"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.03"}], ",", 
       RowBox[{"-", "0.03"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.03", ",", "0.03"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"lensLocation1", ",", 
       RowBox[{"{", 
        RowBox[{"50.", ",", "0."}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "80"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"200", ",", "80"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"lensLocation2", ",", 
       RowBox[{"{", 
        RowBox[{"75.", ",", "0."}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "80"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"200", ",", "80"}], "}"}]}], "}"}], ",", 
   RowBox[{"ControlType", "\[Rule]", "None"}], ",", "\[IndentingNewLine]", 
   RowBox[{"AutorunSequencing", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "9", ",", "10"}], "}"}]}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"SynchronousInitialization", "\[Rule]", "False"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"Initialization", "\[RuleDelayed]", 
    RowBox[{"(", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"micronsToColor", "[", "m_", "]"}], ":=", 
       RowBox[{"RGBColor", "[", 
        RowBox[{
         RowBox[{"Abs", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "0.3183098861837907"}], "*", 
            RowBox[{"ArcTan", "[", 
             RowBox[{"63.75", " ", "-", " ", 
              RowBox[{"0.25", "*", 
               RowBox[{"Abs", "[", 
                RowBox[{
                 RowBox[{"-", "500."}], " ", "+", " ", 
                 RowBox[{"2.", "*", 
                  RowBox[{"Mod", "[", 
                   RowBox[{
                    RowBox[{"100.", " ", "+", " ", 
                    RowBox[{"500.", "*", "m"}]}], ",", " ", "500."}], 
                   "]"}]}]}], "]"}]}]}], "]"}]}], " ", "+", " ", "\n", "    ", 
           RowBox[{"0.3183098861837907", "*", 
            RowBox[{"ArcTan", "[", 
             RowBox[{"43.", " ", "-", " ", 
              RowBox[{"0.1", "*", 
               RowBox[{"Abs", "[", 
                RowBox[{
                 RowBox[{"-", "500."}], " ", "+", " ", 
                 RowBox[{"2.", "*", 
                  RowBox[{"Mod", "[", 
                   RowBox[{
                    RowBox[{"100.", " ", "+", " ", 
                    RowBox[{"500.", "*", "m"}]}], ",", " ", "500."}], 
                   "]"}]}]}], "]"}]}]}], "]"}]}]}], "]"}], ",", " ", "\n", 
         "  ", 
         RowBox[{"Abs", "[", 
          RowBox[{
           RowBox[{"0.3183098861837907", "*", 
            RowBox[{"ArcTan", "[", 
             RowBox[{"60.", " ", "-", " ", 
              RowBox[{"0.2", "*", 
               RowBox[{"Abs", "[", 
                RowBox[{
                 RowBox[{"-", "500."}], " ", "+", " ", 
                 RowBox[{"2.", "*", 
                  RowBox[{"Mod", "[", 
                   RowBox[{
                    RowBox[{"100.", " ", "+", " ", 
                    RowBox[{"500.", "*", "m"}]}], ",", " ", "500."}], 
                   "]"}]}]}], "]"}]}]}], "]"}]}], " ", "-", " ", "\n", "    ", 
           RowBox[{"0.3183098861837907", "*", 
            RowBox[{"ArcTan", "[", 
             RowBox[{"18.", " ", "-", " ", 
              RowBox[{"0.1", "*", 
               RowBox[{"Abs", "[", 
                RowBox[{
                 RowBox[{"-", "500."}], " ", "+", " ", 
                 RowBox[{"2.", "*", 
                  RowBox[{"Mod", "[", 
                   RowBox[{
                    RowBox[{"100.", " ", "+", " ", 
                    RowBox[{"500.", "*", "m"}]}], ",", " ", "500."}], 
                   "]"}]}]}], "]"}]}]}], "]"}]}]}], "]"}], ",", " ", "\n", 
         "  ", 
         RowBox[{"Abs", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "0.3183098861837907"}], "*", 
            RowBox[{"ArcTan", "[", 
             RowBox[{"10.", " ", "-", " ", 
              RowBox[{"0.2", "*", 
               RowBox[{"Abs", "[", 
                RowBox[{
                 RowBox[{"-", "500."}], " ", "+", " ", 
                 RowBox[{"2.", "*", 
                  RowBox[{"Mod", "[", 
                   RowBox[{
                    RowBox[{"100.", " ", "+", " ", 
                    RowBox[{"500.", "*", "m"}]}], ",", " ", "500."}], 
                   "]"}]}]}], "]"}]}]}], "]"}]}], " ", "+", " ", "\n", "    ", 
           RowBox[{"0.3183098861837907", "*", 
            RowBox[{"ArcTan", "[", 
             RowBox[{"22.5", " ", "-", " ", 
              RowBox[{"0.125", "*", 
               RowBox[{"Abs", "[", 
                RowBox[{
                 RowBox[{"-", "500."}], " ", "+", " ", 
                 RowBox[{"2.", "*", 
                  RowBox[{"Mod", "[", 
                   RowBox[{
                    RowBox[{"100.", " ", "+", " ", 
                    RowBox[{"500.", "*", "m"}]}], ",", " ", "500."}], 
                   "]"}]}]}], "]"}]}]}], "]"}]}]}], "]"}]}], "]"}]}], ";", 
      "\n", 
      RowBox[{"(*", 
       RowBox[{"rayfunction", "-", "wedge"}], "*)"}], "\n", 
      RowBox[{"rayfunction", " ", "=", " ", 
       RowBox[{"Compile", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
          "as1", ",", " ", "wl1", ",", " ", "xs1", ",", " ", "ys1", ",", " ", 
           "aa", ",", " ", "ab", ",", " ", "apa", ",", " ", "apb", ",", " ", 
           "ca1", ",", " ", "ca2", ",", " ", "cb1", ",", " ", "cb2", ",", " ",
            "ta", ",", " ", "tb", ",", " ", "xa1", ",", " ", "xb1", ",", " ", 
           "ya1", ",", " ", "yb1"}], "}"}], ",", " ", "\n", " ", 
         RowBox[{"Module", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
            "activeregion", ",", " ", "allcreatedamplitudes", ",", " ", 
             "allcreatedrays", ",", " ", "\n", "   ", "allowzeroraylength", 
             ",", " ", "alternateindex", ",", " ", "amplitude", ",", " ", 
             "axismagnitude", ",", " ", "\n", "   ", "axismatrix", ",", " ", 
             "clonedata", ",", " ", "clonegenerationnumber", ",", " ", 
             "cloneinput", ",", " ", "\n", "   ", "clonenumber", ",", " ", 
             "cloneposition", ",", " ", "clonereportedrays", ",", " ", 
             "clonerotation", ",", " ", "\n", "   ", "clonescale", ",", " ", 
             "clonescalevector", ",", " ", "clonesorthistogram", ",", " ", 
             "clonetraceinput", ",", " ", "\n", "   ", "clonetraceoutput", 
             ",", " ", "closestdistances", ",", " ", "closestposition", ",", 
             " ", "closestpositions", ",", " ", "\n", "   ", 
             "closestraylength", ",", " ", "completedray", ",", " ", 
             "componentnumber", ",", " ", "cosangle", ",", " ", "\n", "   ", 
             "crossmatrix", ",", " ", "deflecteddummyrayspresent", ",", " ", 
             "deflectedlocalrays", ",", " ", "deflectedrays", ",", " ", "\n", 
             "   ", "deflectedrayspresent", ",", " ", "dummymatrix", ",", " ",
              "dummymatrixlist", ",", " ", "dummyvector", ",", " ", "\n", 
             "   ", "frontid", ",", " ", "generationlimit", ",", " ", 
             "generationnumber", ",", " ", "holeintersections", ",", " ", 
             "\n", "   ", "holeQ", ",", " ", "holeQlist", ",", " ", "hor", 
             ",", " ", "index", ",", " ", "index1", ",", " ", "\n", "   ", 
             "index2", ",", " ", "inrays", ",", " ", "intensity", ",", " ", 
             "intensityscale", ",", " ", "\n", "   ", "intersectionnumber", 
             ",", " ", "intersections", ",", " ", "intersectionslist", ",", 
             " ", "\n", "   ", "intersectionspresent", ",", " ", 
             "localdummyoutrayspresent", ",", " ", "localoutrays", ",", " ", 
             "\n", "   ", "localoutrayspresent", ",", " ", "magnitude", ",", 
             " ", "maxclonegenerationnumber", ",", " ", "maximumposition", 
             ",", " ", "\n", "   ", "minimumraylength", ",", " ", 
             "minresonateraylength", ",", " ", "n12", ",", " ", 
             "newcomponentnumber", ",", " ", "\n", "   ", "newdeflectedrays", 
             ",", " ", "newdistance", ",", " ", "newsurfaceid", ",", " ", 
             "newsurfacenumber", ",", " ", "\n", "   ", "nonintersectingrays",
              ",", " ", "normalizedpolarization", ",", " ", 
             "oldgenerationnumber", ",", " ", "\n", "   ", "opticallength", 
             ",", " ", "originalray", ",", " ", "originalraytilt", ",", " ", 
             "originalrotation", ",", " ", "\n", "   ", "originalsurfnorm", 
             ",", " ", "outrays", ",", " ", "parallelamplitude", ",", " ", 
             "PAxis", ",", " ", "\n", "   ", "perpendicularamplitude", ",", 
             " ", "phaseshift", ",", " ", "pol1", ",", " ", "pol2", ",", " ", 
             "\n", "   ", "pol3", ",", " ", "previoustilt", ",", " ", 
             "propagate", ",", " ", "propagatedrays", ",", " ", "r1", ",", 
             " ", "\n", "   ", "r2", ",", " ", "r3", ",", " ", "r4", ",", " ",
              "r5", ",", " ", "r6", ",", " ", "r7", ",", " ", "\n", "   ", 
             "r8", ",", " ", "r9", ",", " ", "ray1", ",", " ", "ray2", ",", 
             " ", "ray3", ",", " ", "RayL", ",", " ", "\n", "   ", "rayslot", 
             ",", " ", "raysreported", ",", " ", "raytiltx", ",", " ", 
             "raytiltz", ",", " ", "\n", "   ", "reporteddummyrayspresent", 
             ",", " ", "reportedlocalrays", ",", " ", "reportedrays", ",", 
             " ", "\n", "   ", "reportedrayspresent", ",", " ", 
             "resonateintersections", ",", " ", "resonatenumber", ",", " ", 
             "\n", "   ", "resonateraylength", ",", " ", "rex", ",", " ", 
             "rey", ",", " ", "rez", ",", " ", "rotationaxis", ",", " ", "\n",
              "   ", "rsx", ",", " ", "RSx", ",", " ", "rsy", ",", " ", "RSy",
              ",", " ", "rsz", ",", " ", "RSz", ",", " ", "RTx", ",", " ", 
             "RTy", ",", " ", "RTz", ",", " ", "rx", ",", " ", "\n", "   ", 
             "rxhlp", ",", " ", "ry", ",", " ", "ryhlp", ",", " ", "rz", ",", 
             " ", "rzhlp", ",", " ", "SCx", ",", " ", "SCy", ",", " ", "\n", 
             "   ", "sid", ",", " ", "sinangle", ",", " ", "sno1", ",", " ", 
             "sno2", ",", " ", "sno3", ",", " ", "\n", "   ", "sno4", ",", 
             " ", "surfaceid", ",", " ", "surfacenumber", ",", " ", 
             "surfacerotationmatrix", ",", " ", "\n", "   ", 
             "surfacetranslationvector", ",", " ", "surfnorm", ",", " ", 
             "symr1", ",", " ", "symr2", ",", " ", "\n", "   ", "symr3", ",", 
             " ", "symr4", ",", " ", "symr5", ",", " ", "symr6", ",", " ", 
             "symr7", ",", " ", "\n", "   ", "symr8", ",", " ", "symr9", ",", 
             " ", "tempclonedata", ",", " ", "terminatedeflection", ",", " ", 
             "\n", "   ", "thresholdintensity", ",", " ", "tiltmagnitude", 
             ",", " ", "transmatrix", ",", " ", "TV1", ",", " ", "TV10", ",", 
             " ", "TV2", ",", " ", "TV3", ",", " ", "TV4", ",", " ", "TV5", 
             ",", " ", "TV6", ",", " ", "TV7", ",", " ", "TV8", ",", " ", 
             "\n", "   ", "TV9", ",", " ", "u", ",", " ", 
             "unfilteredintersections", ",", " ", "unit", ",", " ", "uu", ",",
              " ", "ver", ",", " ", "\n", "   ", "wavelength", ",", " ", 
             "XAxis", ",", " ", "xunit", ",", " ", "YAxis", ",", " ", "yunit",
              ",", " ", "\n", "   ", "ZAxis", ",", " ", "zunit"}], "}"}], ",",
            " ", 
           RowBox[{
            RowBox[{"activeregion", " ", "=", " ", "1."}], ";", " ", "\n", 
            "   ", 
            RowBox[{"allcreatedamplitudes", " ", "=", " ", 
             RowBox[{"{", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"0.", " ", "+", " ", 
                 RowBox[{"0.", "*", "I"}]}], ",", " ", 
                RowBox[{"0.", " ", "+", " ", 
                 RowBox[{"0.", "*", "I"}]}], ",", " ", 
                RowBox[{"0.", " ", "+", " ", 
                 RowBox[{"0.", "*", "I"}]}]}], "}"}], "}"}]}], ";", " ", 
            RowBox[{"allcreatedrays", " ", "=", " ", 
             RowBox[{"{", 
              RowBox[{"{", "1.", "}"}], "}"}]}], ";", " ", "\n", "   ", 
            RowBox[{"allowzeroraylength", " ", "=", " ", "True"}], ";", " ", 
            RowBox[{"alternateindex", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"amplitude", " ", "=", " ", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"1.", " ", "+", " ", 
                RowBox[{"0.", "*", "I"}]}], ",", " ", 
               RowBox[{"0.", " ", "+", " ", 
                RowBox[{"0.", "*", "I"}]}], ",", " ", 
               RowBox[{"0.", " ", "+", " ", 
                RowBox[{"0.", "*", "I"}]}]}], "}"}]}], ";", " ", "\n", "   ", 
            
            RowBox[{"axismagnitude", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"axismatrix", " ", "=", " ", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"1.", ",", " ", "0.", ",", " ", "0."}], "}"}], ",", 
               " ", 
               RowBox[{"{", 
                RowBox[{"0.", ",", " ", "1.", ",", " ", "0."}], "}"}], ",", 
               " ", 
               RowBox[{"{", 
                RowBox[{"0.", ",", " ", "0.", ",", " ", "1."}], "}"}]}], 
              "}"}]}], ";", " ", 
            RowBox[{"clonedata", " ", "=", " ", 
             RowBox[{"{", 
              RowBox[{"{", "1.", "}"}], "}"}]}], ";", " ", "\n", "   ", 
            RowBox[{"clonegenerationnumber", " ", "=", " ", "1."}], ";", " ", 
            
            RowBox[{"cloneinput", " ", "=", " ", 
             RowBox[{"{", "1.", "}"}]}], ";", " ", 
            RowBox[{"clonenumber", " ", "=", " ", "1"}], ";", " ", "\n", 
            "   ", 
            RowBox[{"cloneposition", " ", "=", " ", 
             RowBox[{"{", 
              RowBox[{"0.", ",", " ", "0.", ",", " ", "0."}], "}"}]}], ";", 
            " ", 
            RowBox[{"clonereportedrays", " ", "=", " ", 
             RowBox[{"{", 
              RowBox[{"{", "1.", "}"}], "}"}]}], ";", " ", 
            RowBox[{"clonerotation", " ", "=", " ", 
             RowBox[{"{", 
              RowBox[{"{", "1.", "}"}], "}"}]}], ";", " ", "\n", "   ", 
            RowBox[{"clonescale", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"clonescalevector", " ", "=", " ", 
             RowBox[{"{", "1.", "}"}]}], ";", " ", 
            RowBox[{"clonesorthistogram", " ", "=", " ", 
             RowBox[{"{", "1", "}"}]}], ";", " ", "\n", "   ", 
            RowBox[{"clonetraceinput", " ", "=", " ", 
             RowBox[{"{", 
              RowBox[{"{", "1.", "}"}], "}"}]}], ";", " ", 
            RowBox[{"clonetraceoutput", " ", "=", " ", 
             RowBox[{"{", 
              RowBox[{"{", "1.", "}"}], "}"}]}], ";", " ", 
            RowBox[{"closestdistances", " ", "=", " ", 
             RowBox[{"{", "1.", "}"}]}], ";", " ", "\n", "   ", 
            RowBox[{"closestposition", " ", "=", " ", "0"}], ";", " ", 
            RowBox[{"closestpositions", " ", "=", " ", 
             RowBox[{"{", "0", "}"}]}], ";", " ", 
            RowBox[{"closestraylength", " ", "=", " ", "1."}], ";", " ", "\n",
             "   ", 
            RowBox[{"completedray", " ", "=", " ", 
             RowBox[{"{", "1.", "}"}]}], ";", " ", 
            RowBox[{"componentnumber", " ", "=", " ", 
             RowBox[{"-", "1."}]}], ";", " ", 
            RowBox[{"cosangle", " ", "=", " ", "1."}], ";", " ", "\n", "   ", 
            
            RowBox[{"crossmatrix", " ", "=", " ", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"1.", ",", " ", "0.", ",", " ", "0."}], "}"}], ",", 
               " ", 
               RowBox[{"{", 
                RowBox[{"0.", ",", " ", "1.", ",", " ", "0."}], "}"}], ",", 
               " ", 
               RowBox[{"{", 
                RowBox[{"0.", ",", " ", "0.", ",", " ", "1."}], "}"}]}], 
              "}"}]}], ";", " ", 
            RowBox[{"deflecteddummyrayspresent", " ", "=", " ", "False"}], 
            ";", " ", "\n", "   ", 
            RowBox[{"deflectedlocalrays", " ", "=", " ", 
             RowBox[{"{", 
              RowBox[{"{", "1.", "}"}], "}"}]}], ";", " ", 
            RowBox[{"deflectedrays", " ", "=", " ", 
             RowBox[{"{", 
              RowBox[{"{", "1.", "}"}], "}"}]}], ";", " ", 
            RowBox[{"deflectedrayspresent", " ", "=", " ", "False"}], ";", 
            " ", "\n", "   ", 
            RowBox[{"dummymatrix", " ", "=", " ", 
             RowBox[{"{", 
              RowBox[{"{", "1.", "}"}], "}"}]}], ";", " ", 
            RowBox[{"dummymatrixlist", " ", "=", " ", 
             RowBox[{"{", 
              RowBox[{"{", 
               RowBox[{"{", "1.", "}"}], "}"}], "}"}]}], ";", " ", 
            RowBox[{"dummyvector", " ", "=", " ", 
             RowBox[{"{", "1.", "}"}]}], ";", " ", "\n", "   ", 
            RowBox[{"frontid", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"generationlimit", " ", "=", " ", "200."}], ";", " ", 
            RowBox[{"generationnumber", " ", "=", " ", "1."}], ";", " ", "\n",
             "   ", 
            RowBox[{"holeintersections", " ", "=", " ", 
             RowBox[{"{", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], "}"}], 
              "}"}]}], ";", " ", 
            RowBox[{"holeQ", " ", "=", " ", "False"}], ";", " ", 
            RowBox[{"holeQlist", " ", "=", " ", 
             RowBox[{"{", "0", "}"}]}], ";", " ", "\n", "   ", 
            RowBox[{"hor", " ", "=", " ", 
             RowBox[{"1.", " ", "+", " ", 
              RowBox[{"0.", "*", "I"}]}]}], ";", " ", 
            RowBox[{"index", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"index1", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"index2", " ", "=", " ", "1."}], ";", " ", "\n", "   ", 
            RowBox[{"inrays", " ", "=", " ", 
             RowBox[{"{", 
              RowBox[{"{", "1.", "}"}], "}"}]}], ";", " ", 
            RowBox[{"intensity", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"intensityscale", " ", "=", " ", "1."}], ";", " ", "\n", 
            "   ", 
            RowBox[{"intersectionnumber", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"intersections", " ", "=", " ", 
             RowBox[{"{", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], "}"}], 
              "}"}]}], ";", " ", 
            RowBox[{"intersectionslist", " ", "=", " ", 
             RowBox[{"{", 
              RowBox[{"{", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], "}"}],
                "}"}], "}"}]}], ";", " ", "\n", "   ", 
            RowBox[{"intersectionspresent", " ", "=", " ", "False"}], ";", 
            " ", 
            RowBox[{"localdummyoutrayspresent", " ", "=", " ", "False"}], ";",
             " ", 
            RowBox[{"localoutrays", " ", "=", " ", 
             RowBox[{"{", 
              RowBox[{"{", "1.", "}"}], "}"}]}], ";", " ", "\n", "   ", 
            RowBox[{"localoutrayspresent", " ", "=", " ", "False"}], ";", " ", 
            RowBox[{"magnitude", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"maxclonegenerationnumber", " ", "=", " ", "1."}], ";", 
            " ", "\n", "   ", 
            RowBox[{"maximumposition", " ", "=", " ", "1"}], ";", " ", 
            RowBox[{"minimumraylength", " ", "=", " ", "0.0001"}], ";", " ", 
            RowBox[{"minresonateraylength", " ", "=", " ", "1."}], ";", " ", 
            "\n", "   ", 
            RowBox[{"n12", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"newcomponentnumber", " ", "=", " ", 
             RowBox[{"-", "1."}]}], ";", " ", 
            RowBox[{"newdeflectedrays", " ", "=", " ", 
             RowBox[{"{", 
              RowBox[{"{", "1.", "}"}], "}"}]}], ";", " ", "\n", "   ", 
            RowBox[{"newdistance", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"newsurfaceid", " ", "=", " ", 
             RowBox[{"-", "1."}]}], ";", " ", 
            RowBox[{"newsurfacenumber", " ", "=", " ", 
             RowBox[{"-", "1."}]}], ";", " ", "\n", "   ", 
            RowBox[{"nonintersectingrays", " ", "=", " ", 
             RowBox[{"{", 
              RowBox[{"{", "1.", "}"}], "}"}]}], ";", " ", 
            RowBox[{"normalizedpolarization", " ", "=", " ", 
             RowBox[{"{", 
              RowBox[{"1.", ",", " ", "1."}], "}"}]}], ";", " ", 
            RowBox[{"oldgenerationnumber", " ", "=", " ", "1."}], ";", " ", 
            "\n", "   ", 
            RowBox[{"opticallength", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"originalray", " ", "=", " ", 
             RowBox[{"{", "1.", "}"}]}], ";", " ", 
            RowBox[{"originalraytilt", " ", "=", " ", 
             RowBox[{"{", "1.", "}"}]}], ";", " ", "\n", "   ", 
            RowBox[{"originalrotation", " ", "=", " ", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"1.", ",", " ", "0.", ",", " ", "0."}], "}"}], ",", 
               " ", 
               RowBox[{"{", 
                RowBox[{"0.", ",", " ", "1.", ",", " ", "0."}], "}"}], ",", 
               " ", 
               RowBox[{"{", 
                RowBox[{"0.", ",", " ", "0.", ",", " ", "1."}], "}"}]}], 
              "}"}]}], ";", " ", 
            RowBox[{"originalsurfnorm", " ", "=", " ", 
             RowBox[{"{", 
              RowBox[{"{", "1.", "}"}], "}"}]}], ";", " ", "\n", "   ", 
            RowBox[{"outrays", " ", "=", " ", 
             RowBox[{"{", 
              RowBox[{"{", "1.", "}"}], "}"}]}], ";", " ", 
            RowBox[{"parallelamplitude", " ", "=", " ", 
             RowBox[{"1.", " ", "+", " ", 
              RowBox[{"0.", "*", "I"}]}]}], ";", " ", 
            RowBox[{"PAxis", " ", "=", " ", 
             RowBox[{"{", 
              RowBox[{"1.", ",", " ", "0.", ",", " ", "0."}], "}"}]}], ";", 
            " ", "\n", "   ", 
            RowBox[{"perpendicularamplitude", " ", "=", " ", 
             RowBox[{"1.", " ", "+", " ", 
              RowBox[{"0.", "*", "I"}]}]}], ";", " ", 
            RowBox[{"phaseshift", " ", "=", " ", "0."}], ";", " ", 
            RowBox[{"pol1", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"pol2", " ", "=", " ", "1."}], ";", " ", "\n", "   ", 
            RowBox[{"pol3", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"previoustilt", " ", "=", " ", 
             RowBox[{"{", 
              RowBox[{"1.", ",", " ", "0.", ",", " ", "0."}], "}"}]}], ";", 
            " ", 
            RowBox[{"propagate", " ", "=", " ", "True"}], ";", " ", "\n", 
            "   ", 
            RowBox[{"propagatedrays", " ", "=", " ", 
             RowBox[{"{", 
              RowBox[{"{", "1.", "}"}], "}"}]}], ";", " ", 
            RowBox[{"r1", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"r2", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"r3", " ", "=", " ", "1."}], ";", " ", "\n", "   ", 
            RowBox[{"r4", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"r5", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"r6", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"r7", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"r8", " ", "=", " ", "1."}], ";", " ", "\n", "   ", 
            RowBox[{"r9", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"ray1", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"ray2", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"ray3", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"RayL", " ", "=", " ", "1."}], ";", " ", "\n", "   ", 
            RowBox[{"rayslot", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"raysreported", " ", "=", " ", "False"}], ";", " ", 
            RowBox[{"raytiltx", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"raytiltz", " ", "=", " ", "1."}], ";", " ", "\n", "   ", 
            
            RowBox[{"reporteddummyrayspresent", " ", "=", " ", "False"}], ";",
             " ", 
            RowBox[{"reportedlocalrays", " ", "=", " ", 
             RowBox[{"{", 
              RowBox[{"{", "1.", "}"}], "}"}]}], ";", " ", 
            RowBox[{"reportedrays", " ", "=", " ", 
             RowBox[{"{", 
              RowBox[{"{", "1.", "}"}], "}"}]}], ";", " ", "\n", "   ", 
            RowBox[{"reportedrayspresent", " ", "=", " ", "False"}], ";", " ", 
            RowBox[{"resonateintersections", " ", "=", " ", 
             RowBox[{"{", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], "}"}], 
              "}"}]}], ";", " ", 
            RowBox[{"resonatenumber", " ", "=", " ", "0"}], ";", " ", "\n", 
            "   ", 
            RowBox[{"resonateraylength", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"rex", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"rey", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"rez", " ", "=", " ", "1."}], ";", " ", "\n", "   ", 
            RowBox[{"rsx", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"RSx", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"rsy", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"RSy", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"rsz", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"RSz", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"RTx", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"RTy", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"RTz", " ", "=", " ", "1."}], ";", " ", "\n", "   ", 
            RowBox[{"rx", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"rxhlp", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"ry", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"ryhlp", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"rz", " ", "=", " ", "1."}], ";", " ", "\n", "   ", 
            RowBox[{"rzhlp", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"SCx", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"SCy", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"sid", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"sinangle", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"sno1", " ", "=", " ", "1."}], ";", " ", "\n", "   ", 
            RowBox[{"sno2", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"sno3", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"sno4", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"surfaceid", " ", "=", " ", 
             RowBox[{"-", "1."}]}], ";", " ", "\n", "   ", 
            RowBox[{"surfacenumber", " ", "=", " ", 
             RowBox[{"-", "1."}]}], ";", " ", 
            RowBox[{"surfacerotationmatrix", " ", "=", " ", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"1.", ",", " ", "0.", ",", " ", "0."}], "}"}], ",", 
               " ", 
               RowBox[{"{", 
                RowBox[{"0.", ",", " ", "1.", ",", " ", "0."}], "}"}], ",", 
               " ", 
               RowBox[{"{", 
                RowBox[{"0.", ",", " ", "0.", ",", " ", "1."}], "}"}]}], 
              "}"}]}], ";", " ", "\n", "   ", 
            RowBox[{"surfacetranslationvector", " ", "=", " ", 
             RowBox[{"{", 
              RowBox[{"0.", ",", " ", "0.", ",", " ", "0."}], "}"}]}], ";", 
            " ", 
            RowBox[{"surfnorm", " ", "=", " ", 
             RowBox[{"{", 
              RowBox[{"{", "1.", "}"}], "}"}]}], ";", " ", 
            RowBox[{"symr1", " ", "=", " ", "1."}], ";", " ", "\n", "   ", 
            RowBox[{"symr2", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"symr3", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"symr4", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"symr5", " ", "=", " ", "1."}], ";", " ", "\n", "   ", 
            RowBox[{"symr6", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"symr7", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"symr8", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"symr9", " ", "=", " ", "1."}], ";", " ", "\n", "   ", 
            RowBox[{"tempclonedata", " ", "=", " ", 
             RowBox[{"{", 
              RowBox[{"{", "1.", "}"}], "}"}]}], ";", " ", 
            RowBox[{"terminatedeflection", " ", "=", " ", "False"}], ";", " ", 
            RowBox[{"thresholdintensity", " ", "=", " ", "1."}], ";", " ", 
            "\n", "   ", 
            RowBox[{"tiltmagnitude", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"transmatrix", " ", "=", " ", 
             RowBox[{"{", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{"1.", ",", " ", "0.", ",", " ", "0."}], "}"}], ",", 
                " ", 
                RowBox[{"{", 
                 RowBox[{"0.", ",", " ", "1.", ",", " ", "0."}], "}"}], ",", 
                " ", 
                RowBox[{"{", 
                 RowBox[{"0.", ",", " ", "0.", ",", " ", "1."}], "}"}]}], 
               "}"}], "}"}]}], ";", " ", 
            RowBox[{"TV1", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"TV10", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"TV2", " ", "=", " ", "1."}], ";", " ", "\n", "   ", 
            RowBox[{"TV3", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"TV4", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"TV5", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"TV6", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"TV7", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"TV8", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"TV9", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"u", " ", "=", " ", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"1.", ",", " ", "0.", ",", " ", "0."}], "}"}], ",", 
               " ", 
               RowBox[{"{", 
                RowBox[{"0.", ",", " ", "1.", ",", " ", "0."}], "}"}], ",", 
               " ", 
               RowBox[{"{", 
                RowBox[{"0.", ",", " ", "0.", ",", " ", "1."}], "}"}]}], 
              "}"}]}], ";", " ", "\n", "   ", 
            RowBox[{"unfilteredintersections", " ", "=", " ", 
             RowBox[{"{", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], "}"}], 
              "}"}]}], ";", " ", 
            RowBox[{"unit", " ", "=", " ", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"1.", ",", " ", "0.", ",", " ", "0."}], "}"}], ",", 
               " ", 
               RowBox[{"{", 
                RowBox[{"0.", ",", " ", "1.", ",", " ", "0."}], "}"}], ",", 
               " ", 
               RowBox[{"{", 
                RowBox[{"0.", ",", " ", "0.", ",", " ", "1."}], "}"}]}], 
              "}"}]}], ";", " ", "\n", "   ", 
            RowBox[{"uu", " ", "=", " ", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"1.", ",", " ", "0.", ",", " ", "0."}], "}"}], ",", 
               " ", 
               RowBox[{"{", 
                RowBox[{"0.", ",", " ", "1.", ",", " ", "0."}], "}"}], ",", 
               " ", 
               RowBox[{"{", 
                RowBox[{"0.", ",", " ", "0.", ",", " ", "1."}], "}"}]}], 
              "}"}]}], ";", " ", 
            RowBox[{"ver", " ", "=", " ", 
             RowBox[{"0.", " ", "+", " ", 
              RowBox[{"0.", "*", "I"}]}]}], ";", " ", 
            RowBox[{"wavelength", " ", "=", " ", "1."}], ";", " ", "\n", 
            "   ", 
            RowBox[{"XAxis", " ", "=", " ", 
             RowBox[{"{", 
              RowBox[{"1.", ",", " ", "0.", ",", " ", "0."}], "}"}]}], ";", 
            " ", 
            RowBox[{"xunit", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"YAxis", " ", "=", " ", 
             RowBox[{"{", 
              RowBox[{"1.", ",", " ", "0.", ",", " ", "0."}], "}"}]}], ";", 
            " ", 
            RowBox[{"yunit", " ", "=", " ", "1."}], ";", " ", "\n", "   ", 
            RowBox[{"ZAxis", " ", "=", " ", 
             RowBox[{"{", 
              RowBox[{"1.", ",", " ", "0.", ",", " ", "0."}], "}"}]}], ";", 
            " ", 
            RowBox[{"zunit", " ", "=", " ", "1."}], ";", " ", 
            RowBox[{"propagatedrays", " ", "=", " ", "\n", "    ", 
             RowBox[{"Join", "[", 
              RowBox[{
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                 "symr1", ",", " ", "symr2", ",", " ", "symr3", ",", " ", 
                  "symr4", ",", " ", "symr5", ",", " ", "\n", "        ", 
                  "symr6", ",", " ", "symr7", ",", " ", "symr8", ",", " ", 
                  "symr9"}], "}"}], " ", "=", " ", "\n", "       ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"Cos", "[", 
                   RowBox[{"as1", "*", "Degree"}], "]"}], ",", " ", 
                  RowBox[{"Sin", "[", 
                   RowBox[{"as1", "*", "Degree"}], "]"}], ",", " ", "0", ",", 
                  " ", 
                  RowBox[{"-", 
                   RowBox[{"Sin", "[", 
                    RowBox[{"as1", "*", "Degree"}], "]"}]}], ",", " ", 
                  RowBox[{"Cos", "[", 
                   RowBox[{"as1", "*", "Degree"}], "]"}], ",", " ", "0", ",", 
                  " ", "0", ",", " ", "0", ",", " ", "1"}], "}"}]}], ";", " ",
                "\n", "      ", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "\n", "           ", "rez", 
                    ",", " ", "r1", ",", " ", "r2", ",", " ", "r3", ",", " ", 
                    "r4", ",", " ", "\n", "           ", "r5", ",", " ", "r6",
                     ",", " ", "r7", ",", " ", "r8", ",", " ", "r9", ",", " ",
                     "\n", "           ", "wavelength", ",", " ", "intensity",
                     ",", " ", "intensityscale", ",", " ", "ray1", ",", " ", 
                    "\n", "           ", "index", ",", " ", "opticallength", 
                    ",", " ", "phaseshift", ",", " ", "componentnumber", ",", 
                    " ", "\n", "           ", "surfacenumber", ",", " ", 
                    "surfaceid", ",", " ", "ray2", ",", " ", "ray3", ",", " ",
                     "sid", ",", " ", "\n", "           ", "frontid", ",", 
                    " ", "sno1", ",", " ", "sno2", ",", " ", "sno3", ",", " ",
                     "sno4", ",", " ", "\n", "           ", "rayslot", ",", 
                    " ", "oldgenerationnumber", ",", " ", 
                    "intersectionnumber", ",", " ", "pol1", ",", " ", "\n", 
                    "           ", "pol2", ",", " ", "pol3"}], "}"}], " ", 
                    "=", " ", "#1"}], ";", " ", 
                    RowBox[{"wavelength", " ", "=", " ", "wl1"}], ";", " ", 
                    "\n", "         ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"TV1", ",", " ", "TV2", ",", " ", "TV3"}], "}"}], 
                    " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"rsx", "*", "symr1"}], " ", "+", " ", 
                    RowBox[{"rsy", "*", "symr4"}], " ", "+", " ", "\n", 
                    "            ", 
                    RowBox[{"rsz", "*", "symr7"}], " ", "+", " ", "xs1"}], 
                    ",", " ", 
                    RowBox[{
                    RowBox[{"rsx", "*", "symr2"}], " ", "+", " ", "\n", 
                    "            ", 
                    RowBox[{"rsy", "*", "symr5"}], " ", "+", " ", 
                    RowBox[{"rsz", "*", "symr8"}], " ", "+", " ", "ys1"}], 
                    ",", " ", "\n", "           ", 
                    RowBox[{
                    RowBox[{"rsx", "*", "symr3"}], " ", "+", " ", 
                    RowBox[{"rsy", "*", "symr6"}], " ", "+", " ", "\n", 
                    "            ", 
                    RowBox[{"rsz", "*", "symr9"}]}]}], "}"}]}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"rsx", ",", " ", "rsy", ",", " ", "rsz"}], "}"}], 
                    " ", "=", " ", "\n", "          ", 
                    RowBox[{"{", 
                    RowBox[{"TV1", ",", " ", "TV2", ",", " ", "TV3"}], 
                    "}"}]}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"TV1", ",", " ", "TV2", ",", " ", "TV3"}], "}"}], 
                    " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"rex", "*", "symr1"}], " ", "+", " ", 
                    RowBox[{"rey", "*", "symr4"}], " ", "+", " ", "\n", 
                    "            ", 
                    RowBox[{"rez", "*", "symr7"}], " ", "+", " ", "xs1"}], 
                    ",", " ", 
                    RowBox[{
                    RowBox[{"rex", "*", "symr2"}], " ", "+", " ", "\n", 
                    "            ", 
                    RowBox[{"rey", "*", "symr5"}], " ", "+", " ", 
                    RowBox[{"rez", "*", "symr8"}], " ", "+", " ", "ys1"}], 
                    ",", " ", "\n", "           ", 
                    RowBox[{
                    RowBox[{"rex", "*", "symr3"}], " ", "+", " ", 
                    RowBox[{"rey", "*", "symr6"}], " ", "+", " ", "\n", 
                    "            ", 
                    RowBox[{"rez", "*", "symr9"}]}]}], "}"}]}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"rex", ",", " ", "rey", ",", " ", "rez"}], "}"}], 
                    " ", "=", " ", "\n", "          ", 
                    RowBox[{"{", 
                    RowBox[{"TV1", ",", " ", "TV2", ",", " ", "TV3"}], 
                    "}"}]}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"TV1", ",", " ", "TV2", ",", " ", "TV3"}], "}"}], 
                    " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"r1", "*", "symr1"}], " ", "+", " ", 
                    RowBox[{"r2", "*", "symr4"}], " ", "+", " ", "\n", 
                    "            ", 
                    RowBox[{"r3", "*", "symr7"}]}], ",", " ", 
                    RowBox[{
                    RowBox[{"r1", "*", "symr2"}], " ", "+", " ", 
                    RowBox[{"r2", "*", "\n", "             ", "symr5"}], " ", 
                    "+", " ", 
                    RowBox[{"r3", "*", "symr8"}]}], ",", " ", 
                    RowBox[{
                    RowBox[{"r1", "*", "symr3"}], " ", "+", " ", "\n", 
                    "            ", 
                    RowBox[{"r2", "*", "symr6"}], " ", "+", " ", 
                    RowBox[{"r3", "*", "symr9"}]}]}], "}"}]}], ";", " ", "\n",
                     "         ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"TV4", ",", " ", "TV5", ",", " ", "TV6"}], "}"}], 
                    " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"r4", "*", "symr1"}], " ", "+", " ", 
                    RowBox[{"r5", "*", "symr4"}], " ", "+", " ", "\n", 
                    "            ", 
                    RowBox[{"r6", "*", "symr7"}]}], ",", " ", 
                    RowBox[{
                    RowBox[{"r4", "*", "symr2"}], " ", "+", " ", 
                    RowBox[{"r5", "*", "\n", "             ", "symr5"}], " ", 
                    "+", " ", 
                    RowBox[{"r6", "*", "symr8"}]}], ",", " ", 
                    RowBox[{
                    RowBox[{"r4", "*", "symr3"}], " ", "+", " ", "\n", 
                    "            ", 
                    RowBox[{"r5", "*", "symr6"}], " ", "+", " ", 
                    RowBox[{"r6", "*", "symr9"}]}]}], "}"}]}], ";", " ", "\n",
                     "         ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"TV7", ",", " ", "TV8", ",", " ", "TV9"}], "}"}], 
                    " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"r7", "*", "symr1"}], " ", "+", " ", 
                    RowBox[{"r8", "*", "symr4"}], " ", "+", " ", "\n", 
                    "            ", 
                    RowBox[{"r9", "*", "symr7"}]}], ",", " ", 
                    RowBox[{
                    RowBox[{"r7", "*", "symr2"}], " ", "+", " ", 
                    RowBox[{"r8", "*", "\n", "             ", "symr5"}], " ", 
                    "+", " ", 
                    RowBox[{"r9", "*", "symr8"}]}], ",", " ", 
                    RowBox[{
                    RowBox[{"r7", "*", "symr3"}], " ", "+", " ", "\n", 
                    "            ", 
                    RowBox[{"r8", "*", "symr6"}], " ", "+", " ", 
                    RowBox[{"r9", "*", "symr9"}]}]}], "}"}]}], ";", " ", "\n",
                     "         ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "r4", ",", " ", "r5", ",", " ", "\n", "            ", 
                    "r6"}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"r7", ",", " ", "r8", ",", " ", "r9"}], "}"}]}], 
                    "}"}], " ", "=", " ", "\n", "          ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"TV1", ",", " ", "TV2", ",", " ", "TV3"}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"TV4", ",", " ", "TV5", ",", " ", "TV6"}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"TV7", ",", " ", "TV8", ",", " ", "TV9"}], 
                    "}"}]}], "}"}]}], ";", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "\n", 
                    "          ", "rex", ",", " ", "rey", ",", " ", "rez", 
                    ",", " ", "r1", ",", " ", "r2", ",", " ", "\n", 
                    "          ", "r3", ",", " ", "r4", ",", " ", "r5", ",", 
                    " ", "r6", ",", " ", "r7", ",", " ", "r8", ",", " ", "\n",
                     "          ", "r9", ",", " ", "wavelength", ",", " ", 
                    "intensity", ",", " ", "intensityscale", ",", " ", "\n", 
                    "          ", "ray1", ",", " ", "index", ",", " ", 
                    "opticallength", ",", " ", "phaseshift", ",", " ", "\n", 
                    "          ", "componentnumber", ",", " ", 
                    "surfacenumber", ",", " ", "surfaceid", ",", " ", "ray2", 
                    ",", " ", "\n", "          ", "ray3", ",", " ", "sid", 
                    ",", " ", "frontid", ",", " ", "sno1", ",", " ", "sno2", 
                    ",", " ", "\n", "          ", "sno3", ",", " ", "sno4", 
                    ",", " ", "rayslot", ",", " ", "generationnumber", ",", 
                    " ", "\n", "          ", "intersectionnumber", ",", " ", 
                    "pol1", ",", " ", "pol2", ",", " ", "pol3"}], "}"}]}], 
                   ")"}], " ", "&"}], " ", ")"}], " ", "/@", " ", "\n", 
                "       ", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{
                   "0.", ",", " ", "0.", ",", " ", "0.", ",", " ", "0.", ",", 
                    " ", "0.", ",", " ", "0.", ",", " ", "0.9659258262890683",
                     ",", " ", "0.25881904510252074", ",", " ", "0.", ",", 
                    " ", 
                    RowBox[{"-", "0.25881904510252074"}], ",", " ", 
                    "0.9659258262890683", ",", " ", "0.", ",", " ", "0.", ",",
                     " ", "0.", ",", " ", "1.", ",", " ", "0.532", ",", " ", 
                    "100.", ",", " ", "\n", "         ", 
                    "0.09090909090909091", ",", " ", "0.", ",", " ", 
                    "1.0002694514570802", ",", " ", "0.", ",", " ", "0.", ",",
                     " ", "1.", ",", " ", "0.", ",", " ", "0.", ",", " ", 
                    "0.", ",", " ", "0.", ",", " ", "16497.", ",", " ", 
                    "16497.", ",", " ", "1.", ",", " ", "11.", ",", " ", "1.",
                     ",", " ", "0.", ",", " ", "1.", ",", " ", "0.", ",", " ",
                     "0.", ",", " ", "0.", ",", " ", "1.", ",", " ", "0."}], 
                   "}"}], ",", " ", "\n", "        ", 
                  RowBox[{"{", 
                   RowBox[{
                   "0.", ",", " ", "0.", ",", " ", "0.", ",", " ", "0.", ",", 
                    " ", "0.", ",", " ", "0.", ",", " ", "0.9781476007338057",
                     ",", " ", "0.20791169081775934", ",", " ", "0.", ",", 
                    " ", 
                    RowBox[{"-", "0.20791169081775934"}], ",", " ", 
                    "0.9781476007338057", ",", " ", "0.", ",", " ", "0.", ",",
                     " ", "0.", ",", " ", "1.", ",", " ", "0.532", ",", " ", 
                    "100.", ",", " ", "\n", "         ", 
                    "0.09090909090909091", ",", " ", "0.", ",", " ", 
                    "1.0002694514570802", ",", " ", "0.", ",", " ", "0.", ",",
                     " ", "1.", ",", " ", "0.", ",", " ", "0.", ",", " ", 
                    "0.", ",", " ", "0.", ",", " ", "16497.", ",", " ", 
                    "16497.", ",", " ", "2.", ",", " ", "11.", ",", " ", "2.",
                     ",", " ", "0.", ",", " ", "1.", ",", " ", "0.", ",", " ",
                     "0.", ",", " ", "0.", ",", " ", "1.", ",", " ", "0."}], 
                   "}"}], ",", " ", "\n", "        ", 
                  RowBox[{"{", 
                   RowBox[{
                   "0.", ",", " ", "0.", ",", " ", "0.", ",", " ", "0.", ",", 
                    " ", "0.", ",", " ", "0.", ",", " ", "0.9876883405951378",
                     ",", " ", "0.15643446504023087", ",", " ", "0.", ",", 
                    " ", 
                    RowBox[{"-", "0.15643446504023087"}], ",", " ", 
                    "0.9876883405951378", ",", " ", "0.", ",", " ", "0.", ",",
                     " ", "0.", ",", " ", "1.", ",", " ", "0.532", ",", " ", 
                    "100.", ",", " ", "\n", "         ", 
                    "0.09090909090909091", ",", " ", "0.", ",", " ", 
                    "1.0002694514570802", ",", " ", "0.", ",", " ", "0.", ",",
                     " ", "1.", ",", " ", "0.", ",", " ", "0.", ",", " ", 
                    "0.", ",", " ", "0.", ",", " ", "16497.", ",", " ", 
                    "16497.", ",", " ", "3.", ",", " ", "11.", ",", " ", "3.",
                     ",", " ", "0.", ",", " ", "1.", ",", " ", "0.", ",", " ",
                     "0.", ",", " ", "0.", ",", " ", "1.", ",", " ", "0."}], 
                   "}"}], ",", " ", "\n", "        ", 
                  RowBox[{"{", 
                   RowBox[{
                   "0.", ",", " ", "0.", ",", " ", "0.", ",", " ", "0.", ",", 
                    " ", "0.", ",", " ", "0.", ",", " ", "0.9945218953682733",
                     ",", " ", "0.10452846326765348", ",", " ", "0.", ",", 
                    " ", 
                    RowBox[{"-", "0.10452846326765348"}], ",", " ", 
                    "0.9945218953682733", ",", " ", "0.", ",", " ", "0.", ",",
                     " ", "0.", ",", " ", "1.", ",", " ", "0.532", ",", " ", 
                    "100.", ",", " ", "\n", "         ", 
                    "0.09090909090909091", ",", " ", "0.", ",", " ", 
                    "1.0002694514570802", ",", " ", "0.", ",", " ", "0.", ",",
                     " ", "1.", ",", " ", "0.", ",", " ", "0.", ",", " ", 
                    "0.", ",", " ", "0.", ",", " ", "16497.", ",", " ", 
                    "16497.", ",", " ", "4.", ",", " ", "11.", ",", " ", "4.",
                     ",", " ", "0.", ",", " ", "1.", ",", " ", "0.", ",", " ",
                     "0.", ",", " ", "0.", ",", " ", "1.", ",", " ", "0."}], 
                   "}"}], ",", " ", "\n", "        ", 
                  RowBox[{"{", 
                   RowBox[{
                   "0.", ",", " ", "0.", ",", " ", "0.", ",", " ", "0.", ",", 
                    " ", "0.", ",", " ", "0.", ",", " ", "0.9986295347545738",
                     ",", " ", "0.052335956242943835", ",", " ", "0.", ",", 
                    " ", 
                    RowBox[{"-", "0.052335956242943835"}], ",", " ", 
                    "0.9986295347545738", ",", " ", "0.", ",", " ", "0.", ",",
                     " ", "0.", ",", " ", "1.", ",", " ", "0.532", ",", " ", 
                    "100.", ",", " ", "\n", "         ", 
                    "0.09090909090909091", ",", " ", "0.", ",", " ", 
                    "1.0002694514570802", ",", " ", "0.", ",", " ", "0.", ",",
                     " ", "1.", ",", " ", "0.", ",", " ", "0.", ",", " ", 
                    "0.", ",", " ", "0.", ",", " ", "16497.", ",", " ", 
                    "16497.", ",", " ", "5.", ",", " ", "11.", ",", " ", "5.",
                     ",", " ", "0.", ",", " ", "1.", ",", " ", "0.", ",", " ",
                     "0.", ",", " ", "0.", ",", " ", "1.", ",", " ", "0."}], 
                   "}"}], ",", " ", "\n", "        ", 
                  RowBox[{"{", 
                   RowBox[{
                   "0.", ",", " ", "0.", ",", " ", "0.", ",", " ", "0.", ",", 
                    " ", "0.", ",", " ", "0.", ",", " ", "1.", ",", " ", "0.",
                     ",", " ", "0.", ",", " ", "0.", ",", " ", "1.", ",", " ",
                     "0.", ",", " ", "0.", ",", " ", "0.", ",", " ", "1.", 
                    ",", " ", "0.532", ",", " ", "100.", ",", " ", 
                    "0.09090909090909091", ",", " ", "0.", ",", " ", 
                    "1.0002694514570802", ",", " ", "0.", ",", " ", "0.", ",",
                     " ", "1.", ",", " ", "0.", ",", " ", "0.", ",", " ", 
                    "0.", ",", " ", "0.", ",", " ", "16497.", ",", " ", "\n", 
                    "         ", "16497.", ",", " ", "6.", ",", " ", "11.", 
                    ",", " ", "6.", ",", " ", "0.", ",", " ", "1.", ",", " ", 
                    "0.", ",", " ", "0.", ",", " ", "0.", ",", " ", "1.", ",",
                     " ", "0."}], "}"}], ",", " ", 
                  RowBox[{"{", 
                   RowBox[{
                   "0.", ",", " ", "0.", ",", " ", "0.", ",", " ", "0.", ",", 
                    " ", "0.", ",", " ", "0.", ",", " ", "0.9986295347545738",
                     ",", " ", 
                    RowBox[{"-", "0.052335956242943835"}], ",", " ", "0.", 
                    ",", " ", "0.052335956242943835", ",", " ", "\n", 
                    "         ", "0.9986295347545738", ",", " ", "0.", ",", 
                    " ", "0.", ",", " ", "0.", ",", " ", "1.", ",", " ", 
                    "0.532", ",", " ", "100.", ",", " ", 
                    "0.09090909090909091", ",", " ", "0.", ",", " ", 
                    "1.0002694514570802", ",", " ", "0.", ",", " ", "0.", ",",
                     " ", "1.", ",", " ", "0.", ",", " ", "0.", ",", " ", 
                    "0.", ",", " ", "0.", ",", " ", "16497.", ",", " ", 
                    "16497.", ",", " ", "7.", ",", " ", "11.", ",", " ", "7.",
                     ",", " ", "0.", ",", " ", "\n", "         ", "1.", ",", 
                    " ", "0.", ",", " ", "0.", ",", " ", "0.", ",", " ", "1.",
                     ",", " ", "0."}], "}"}], ",", " ", 
                  RowBox[{"{", 
                   RowBox[{
                   "0.", ",", " ", "0.", ",", " ", "0.", ",", " ", "0.", ",", 
                    " ", "0.", ",", " ", "0.", ",", " ", "0.9945218953682733",
                     ",", " ", 
                    RowBox[{"-", "0.10452846326765348"}], ",", " ", "0.", ",",
                     " ", "0.10452846326765348", ",", " ", 
                    "0.9945218953682733", ",", " ", "0.", ",", " ", "0.", ",",
                     " ", "0.", ",", " ", "1.", ",", " ", "\n", "         ", 
                    "0.532", ",", " ", "100.", ",", " ", 
                    "0.09090909090909091", ",", " ", "0.", ",", " ", 
                    "1.0002694514570802", ",", " ", "0.", ",", " ", "0.", ",",
                     " ", "1.", ",", " ", "0.", ",", " ", "0.", ",", " ", 
                    "0.", ",", " ", "0.", ",", " ", "16497.", ",", " ", 
                    "16497.", ",", " ", "8.", ",", " ", "11.", ",", " ", "8.",
                     ",", " ", "0.", ",", " ", "1.", ",", " ", "0.", ",", " ",
                     "0.", ",", " ", "0.", ",", " ", "1.", ",", " ", "0."}], 
                   "}"}], ",", " ", "\n", "        ", 
                  RowBox[{"{", 
                   RowBox[{
                   "0.", ",", " ", "0.", ",", " ", "0.", ",", " ", "0.", ",", 
                    " ", "0.", ",", " ", "0.", ",", " ", "0.9876883405951378",
                     ",", " ", 
                    RowBox[{"-", "0.15643446504023087"}], ",", " ", "0.", ",",
                     " ", "0.15643446504023087", ",", " ", 
                    "0.9876883405951378", ",", " ", "0.", ",", " ", "0.", ",",
                     " ", "0.", ",", " ", "1.", ",", " ", "0.532", ",", " ", 
                    "100.", ",", " ", "\n", "         ", 
                    "0.09090909090909091", ",", " ", "0.", ",", " ", 
                    "1.0002694514570802", ",", " ", "0.", ",", " ", "0.", ",",
                     " ", "1.", ",", " ", "0.", ",", " ", "0.", ",", " ", 
                    "0.", ",", " ", "0.", ",", " ", "16497.", ",", " ", 
                    "16497.", ",", " ", "9.", ",", " ", "11.", ",", " ", "9.",
                     ",", " ", "0.", ",", " ", "1.", ",", " ", "0.", ",", " ",
                     "0.", ",", " ", "0.", ",", " ", "1.", ",", " ", "0."}], 
                   "}"}], ",", " ", "\n", "        ", 
                  RowBox[{"{", 
                   RowBox[{
                   "0.", ",", " ", "0.", ",", " ", "0.", ",", " ", "0.", ",", 
                    " ", "0.", ",", " ", "0.", ",", " ", "0.9781476007338057",
                     ",", " ", 
                    RowBox[{"-", "0.20791169081775934"}], ",", " ", "0.", ",",
                     " ", "0.20791169081775934", ",", " ", 
                    "0.9781476007338057", ",", " ", "0.", ",", " ", "0.", ",",
                     " ", "0.", ",", " ", "1.", ",", " ", "0.532", ",", " ", 
                    "100.", ",", " ", "\n", "         ", 
                    "0.09090909090909091", ",", " ", "0.", ",", " ", 
                    "1.0002694514570802", ",", " ", "0.", ",", " ", "0.", ",",
                     " ", "1.", ",", " ", "0.", ",", " ", "0.", ",", " ", 
                    "0.", ",", " ", "0.", ",", " ", "16497.", ",", " ", 
                    "16497.", ",", " ", "10.", ",", " ", "11.", ",", " ", 
                    "10.", ",", " ", "0.", ",", " ", "1.", ",", " ", "0.", 
                    ",", " ", "0.", ",", " ", "0.", ",", " ", "1.", ",", " ", 
                    "0."}], "}"}], ",", " ", "\n", "        ", 
                  RowBox[{"{", 
                   RowBox[{
                   "0.", ",", " ", "0.", ",", " ", "0.", ",", " ", "0.", ",", 
                    " ", "0.", ",", " ", "0.", ",", " ", "0.9659258262890683",
                     ",", " ", 
                    RowBox[{"-", "0.25881904510252074"}], ",", " ", "0.", ",",
                     " ", "0.25881904510252074", ",", " ", 
                    "0.9659258262890683", ",", " ", "0.", ",", " ", "0.", ",",
                     " ", "0.", ",", " ", "1.", ",", " ", "0.532", ",", " ", 
                    "100.", ",", " ", "\n", "         ", 
                    "0.09090909090909091", ",", " ", "0.", ",", " ", 
                    "1.0002694514570802", ",", " ", "0.", ",", " ", "0.", ",",
                     " ", "1.", ",", " ", "0.", ",", " ", "0.", ",", " ", 
                    "0.", ",", " ", "0.", ",", " ", "16497.", ",", " ", 
                    "16497.", ",", " ", "11.", ",", " ", "11.", ",", " ", 
                    "11.", ",", " ", "0.", ",", " ", "1.", ",", " ", "0.", 
                    ",", " ", "0.", ",", " ", "0.", ",", " ", "1.", ",", " ", 
                    "0."}], "}"}]}], "}"}]}]}], "]"}]}], ";", " ", "\n", 
            "   ", 
            RowBox[{"propagatedrays", " ", "=", " ", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "\n", "         ", "rey", ",", " ", "rez", ",", 
                    " ", "r1", ",", " ", "r2", ",", " ", "r3", ",", " ", "\n",
                     "         ", "r4", ",", " ", "r5", ",", " ", "r6", ",", 
                    " ", "r7", ",", " ", "r8", ",", " ", "r9", ",", " ", "\n",
                     "         ", "wavelength", ",", " ", "intensity", ",", 
                    " ", "intensityscale", ",", " ", "ray1", ",", " ", "\n", 
                    "         ", "index", ",", " ", "opticallength", ",", " ",
                     "phaseshift", ",", " ", "componentnumber", ",", " ", 
                    "\n", "         ", "surfacenumber", ",", " ", "surfaceid",
                     ",", " ", "ray2", ",", " ", "ray3", ",", " ", "sid", ",",
                     " ", "\n", "         ", "frontid", ",", " ", "sno1", ",",
                     " ", "sno2", ",", " ", "sno3", ",", " ", "sno4", ",", 
                    " ", "\n", "         ", "rayslot", ",", " ", 
                    "oldgenerationnumber", ",", " ", "intersectionnumber", 
                    ",", " ", "pol1", ",", " ", "\n", "         ", "pol2", 
                    ",", " ", "pol3"}], "}"}], " ", "=", " ", "#1"}], ";", 
                  " ", 
                  RowBox[{"componentnumber", " ", "=", " ", "1."}], ";", " ", 
                  
                  RowBox[{"frontid", " ", "=", " ", "1."}], ";", " ", "\n", 
                  "       ", 
                  RowBox[{"{", 
                   RowBox[{
                   "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "\n", "        ", "rez", ",", 
                    " ", "r1", ",", " ", "r2", ",", " ", "r3", ",", " ", "r4",
                     ",", " ", "r5", ",", " ", "\n", "        ", "r6", ",", 
                    " ", "r7", ",", " ", "r8", ",", " ", "r9", ",", " ", 
                    "wavelength", ",", " ", "\n", "        ", "intensity", 
                    ",", " ", "intensityscale", ",", " ", "ray1", ",", " ", 
                    "index", ",", " ", "\n", "        ", "opticallength", ",",
                     " ", "phaseshift", ",", " ", "componentnumber", ",", " ",
                     "surfacenumber", ",", " ", "\n", "        ", "surfaceid",
                     ",", " ", "ray2", ",", " ", "ray3", ",", " ", "sid", ",",
                     " ", "frontid", ",", " ", "\n", "        ", "sno1", ",", 
                    " ", "sno2", ",", " ", "sno3", ",", " ", "sno4", ",", " ",
                     "rayslot", ",", " ", "\n", "        ", 
                    "generationnumber", ",", " ", "intersectionnumber", ",", 
                    " ", "pol1", ",", " ", "pol2", ",", " ", "\n", "        ",
                     "pol3"}], "}"}]}], ")"}], " ", "&"}], " ", ")"}], " ", "/@",
               " ", "propagatedrays"}]}], ";", " ", 
            RowBox[{"thresholdintensity", " ", "=", " ", "1."}], ";", " ", 
            "\n", "   ", 
            RowBox[{"generationlimit", " ", "=", " ", "200."}], ";", " ", 
            RowBox[{"reportedrays", " ", "=", " ", "\n", "    ", 
             RowBox[{"{", 
              RowBox[{"{", 
               RowBox[{
               "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", ",", 
                " ", "rey", ",", " ", "\n", "      ", "rez", ",", " ", "r1", 
                ",", " ", "r2", ",", " ", "r3", ",", " ", "r4", ",", " ", 
                "r5", ",", " ", "\n", "      ", "r6", ",", " ", "r7", ",", 
                " ", "r8", ",", " ", "r9", ",", " ", "wavelength", ",", " ", 
                "\n", "      ", "intensity", ",", " ", "intensityscale", ",", 
                " ", "ray1", ",", " ", "index", ",", " ", "\n", "      ", 
                "opticallength", ",", " ", "phaseshift", ",", " ", 
                "componentnumber", ",", " ", "surfacenumber", ",", " ", "\n", 
                "      ", "surfaceid", ",", " ", "ray2", ",", " ", "ray3", 
                ",", " ", "sid", ",", " ", "frontid", ",", " ", "\n", 
                "      ", "sno1", ",", " ", "sno2", ",", " ", "sno3", ",", 
                " ", "sno4", ",", " ", "rayslot", ",", " ", "\n", "      ", 
                "generationnumber", ",", " ", "intersectionnumber", ",", " ", 
                "pol1", ",", " ", "pol2", ",", " ", "\n", "      ", "pol3"}], 
               "}"}], "}"}]}], ";", " ", 
            RowBox[{"generationnumber", " ", "=", " ", "0."}], ";", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"inrays", " ", "=", " ", "propagatedrays"}], ";", " ", 
              "\n", "    ", 
              RowBox[{"outrays", " ", "=", " ", 
               RowBox[{"{", 
                RowBox[{"{", 
                 RowBox[{
                 "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", 
                  " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", 
                  ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", 
                  "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", 
                  " ", "1.", ",", " ", 
                  RowBox[{"-", "1.7976931348623157*^308"}], ",", " ", "1.", 
                  ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", 
                  "0.", ",", " ", 
                  RowBox[{"-", "1."}], ",", " ", 
                  RowBox[{"-", "1."}], ",", " ", 
                  RowBox[{"-", "1."}], ",", " ", "\n", "       ", "1.", ",", 
                  " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", 
                  ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", 
                  "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", 
                  " ", "1.", ",", " ", "1."}], "}"}], "}"}]}], ";", " ", 
              RowBox[{"deflectedrayspresent", " ", "=", " ", "True"}], ";", 
              " ", "\n", "    ", 
              RowBox[{"reportedrayspresent", " ", "=", " ", "False"}], ";", 
              " ", 
              RowBox[{"propagate", " ", "=", " ", "True"}], ";", " ", "\n", 
              "    ", 
              RowBox[{"While", "[", 
               RowBox[{
                RowBox[{"deflectedrayspresent", " ", "&&", " ", "propagate"}],
                 ",", " ", 
                RowBox[{
                 RowBox[{"generationnumber", " ", "+=", " ", "1."}], ";", " ",
                  "\n", "      ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                   "deflecteddummyrayspresent", " ", "=", " ", "False"}], ";",
                    " ", 
                   RowBox[{"deflectedrayspresent", " ", "=", " ", "False"}], 
                   ";", " ", "\n", "       ", 
                   RowBox[{"reportedrayspresent", " ", "=", " ", "False"}], 
                   ";", " ", 
                   RowBox[{
                   "reporteddummyrayspresent", " ", "=", " ", "True"}], ";", 
                   " ", 
                   RowBox[{
                   "localdummyoutrayspresent", " ", "=", " ", "\n", 
                    "        ", "False"}], ";", " ", 
                   RowBox[{"localoutrayspresent", " ", "=", " ", "False"}], 
                   ";", " ", 
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "deflectedlocalrays", ",", " ", "localoutrays", ",", " ", 
                    "\n", "         ", "reportedlocalrays"}], "}"}], " ", "=",
                     " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"Flatten", "[", 
                    RowBox[{"#1", ",", " ", "1"}], "]"}], " ", "&"}], " ", 
                    ")"}], " ", "/@", " ", "\n", "         ", 
                    RowBox[{"Transpose", "[", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "\n", "               ", "rez",
                     ",", " ", "r1", ",", " ", "r2", ",", " ", "r3", ",", " ",
                     "r4", ",", " ", "\n", "               ", "r5", ",", " ", 
                    "r6", ",", " ", "r7", ",", " ", "r8", ",", " ", "r9", ",",
                     " ", "\n", "               ", "wavelength", ",", " ", 
                    "intensity", ",", " ", "intensityscale", ",", " ", "ray1",
                     ",", " ", "\n", "               ", "index", ",", " ", 
                    "opticallength", ",", " ", "phaseshift", ",", " ", 
                    "componentnumber", ",", " ", "\n", "               ", 
                    "surfacenumber", ",", " ", "surfaceid", ",", " ", "ray2", 
                    ",", " ", "ray3", ",", " ", "\n", "               ", 
                    "sid", ",", " ", "frontid", ",", " ", "sno1", ",", " ", 
                    "sno2", ",", " ", "sno3", ",", " ", "\n", 
                    "               ", "sno4", ",", " ", "rayslot", ",", " ", 
                    "oldgenerationnumber", ",", " ", "intersectionnumber", 
                    ",", " ", "\n", "               ", "pol1", ",", " ", 
                    "pol2", ",", " ", "pol3"}], "}"}], " ", "=", " ", "#1"}], 
                    ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    "intensity", " ", ">", " ", "\n", "                ", 
                    "thresholdintensity"}], " ", "&&", " ", 
                    RowBox[{
                    "generationnumber", " ", "<", " ", "generationlimit"}]}], 
                    ",", " ", "\n", "              ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"resonatenumber", " ", "=", " ", "0"}], ";", " ", 
                    
                    RowBox[{
                    "resonateraylength", " ", "=", " ", 
                    "1.7976931348623157*^308"}], ";", " ", "\n", 
                    "                ", 
                    RowBox[{"resonateintersections", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}], "}"}]}], ";", " ", 
                    RowBox[{"MapIndexed", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"#1", "[", 
                    RowBox[{"[", 
                    RowBox[{"1", ",", "1"}], "]"}], "]"}], " ", ">", " ", 
                    RowBox[{"-", "1."}]}], " ", "&&", " ", 
                    RowBox[{
                    RowBox[{"#1", "[", 
                    RowBox[{"[", 
                    RowBox[{"1", ",", "1"}], "]"}], "]"}], " ", "<", " ", 
                    "resonateraylength"}]}], ",", " ", "\n", 
                    "                   ", 
                    RowBox[{
                    RowBox[{"resonateraylength", " ", "=", " ", 
                    RowBox[{"#1", "[", 
                    RowBox[{"[", 
                    RowBox[{"1", ",", "1"}], "]"}], "]"}]}], ";", " ", 
                    RowBox[{"resonateintersections", " ", "=", " ", "#1"}], 
                    ";", " ", 
                    RowBox[{
                    "resonatenumber", " ", "=", " ", "\n", 
                    "                     ", 
                    RowBox[{"First", "[", "#2", "]"}]}]}], ",", " ", 
                    "resonatenumber"}], "]"}], " ", "&"}], " ", ",", " ", 
                    RowBox[{
                    RowBox[{"intersectionslist", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}], "}"}], "}"}]}], ";", " ", "\n", 
                    "                  ", 
                    RowBox[{"holeQlist", " ", "=", " ", 
                    RowBox[{"{", "0", "}"}]}], ";", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "\n", 
                    "                     ", "rex", ",", " ", "rey", ",", " ",
                     "rez", ",", " ", "r1", ",", " ", "r2", ",", " ", "\n", 
                    "                     ", "r3", ",", " ", "r4", ",", " ", 
                    "r5", ",", " ", "r6", ",", " ", "r7", ",", " ", "\n", 
                    "                     ", "r8", ",", " ", "r9", ",", " ", 
                    "wavelength", ",", " ", "intensity", ",", " ", "\n", 
                    "                     ", "intensityscale", ",", " ", 
                    "ray1", ",", " ", "index", ",", " ", "opticallength", ",",
                     " ", "\n", "                     ", "phaseshift", ",", 
                    " ", "componentnumber", ",", " ", "surfacenumber", ",", 
                    " ", "surfaceid", ",", " ", "\n", "                     ",
                     "ray2", ",", " ", "ray3", ",", " ", "sid", ",", " ", 
                    "frontid", ",", " ", "sno1", ",", " ", "\n", 
                    "                     ", "sno2", ",", " ", "sno3", ",", 
                    " ", "sno4", ",", " ", "rayslot", ",", " ", "\n", 
                    "                     ", "oldgenerationnumber", ",", " ", 
                    "intersectionnumber", ",", " ", "pol1", ",", " ", "pol2", 
                    ",", " ", "\n", "                     ", "pol3"}], "}"}], 
                    " ", "=", " ", "#1"}], ";", " ", 
                    RowBox[{"index1", " ", "=", " ", "index"}], ";", " ", 
                    RowBox[{"xunit", " ", "=", " ", "\n", 
                    "                    ", 
                    RowBox[{
                    RowBox[{"r1", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "aa"}], "]"}], 
                    "]"}]}], " ", "+", " ", 
                    RowBox[{"r2", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "aa"}], "]"}], 
                    "]"}]}]}]}], ";", " ", "\n", "                   ", 
                    RowBox[{"yunit", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"r2", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "aa"}], "]"}], 
                    "]"}]}], " ", "-", " ", 
                    RowBox[{
                    "1.", "*", "r1", "*", "\n", "                      ", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "aa"}], "]"}], 
                    "]"}]}]}]}], ";", " ", 
                    RowBox[{"zunit", " ", "=", " ", 
                    RowBox[{"r3", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "aa"}], "]"}], "^", 
                    "2"}], " ", "+", " ", "\n", "                       ", 
                    RowBox[{
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "aa"}], "]"}], "^", 
                    "2"}]}], "]"}]}]}], ";", " ", 
                    RowBox[{"xunit", " ", "=", " ", 
                    RowBox[{"Chop", "[", "xunit", "]"}]}], ";", " ", 
                    RowBox[{
                    "yunit", " ", "=", " ", "\n", "                    ", 
                    RowBox[{"Chop", "[", "yunit", "]"}]}], ";", " ", 
                    RowBox[{"zunit", " ", "=", " ", 
                    RowBox[{"Chop", "[", "zunit", "]"}]}], ";", " ", 
                    RowBox[{
                    "magnitude", " ", "=", " ", "\n", "                    ", 
                    
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"xunit", "^", "2"}], " ", "+", " ", 
                    RowBox[{"yunit", "^", "2"}], " ", "+", " ", 
                    RowBox[{"zunit", "^", "2"}]}], ")"}], "^", 
                    RowBox[{"2", "^", 
                    RowBox[{"(", 
                    RowBox[{"-", "1"}], ")"}]}]}]}], ";", " ", 
                    RowBox[{
                    "xunit", " ", "=", " ", "\n", "                    ", 
                    RowBox[{"xunit", "/", "magnitude"}]}], ";", " ", 
                    RowBox[{"yunit", " ", "=", " ", 
                    RowBox[{
                    "yunit", "/", "\n", "                     ", 
                    "magnitude"}]}], ";", " ", 
                    RowBox[{"zunit", " ", "=", " ", 
                    RowBox[{"zunit", "/", "magnitude"}]}], ";", " ", "\n", 
                    "                   ", 
                    RowBox[{"rx", " ", "=", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"rex", " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"Re", "[", "xa1", "]"}]}]}], ")"}], "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "aa"}], "]"}], 
                    "]"}]}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"rey", " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"Re", "[", "ya1", "]"}]}]}], ")"}], "*", "\n", 
                    "                      ", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "aa"}], "]"}], 
                    "]"}]}]}]}], ";", " ", 
                    RowBox[{"ry", " ", "=", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"rey", " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"Re", "[", "ya1", "]"}]}]}], ")"}], "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "aa"}], "]"}], 
                    "]"}]}], " ", "-", " ", "\n", "                     ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"(", 
                    RowBox[{"rex", " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"Re", "[", "xa1", "]"}]}]}], ")"}], "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "aa"}], "]"}], 
                    "]"}]}]}]}], ";", " ", 
                    RowBox[{"rz", " ", "=", " ", 
                    RowBox[{"rez", "*", "\n", "                     ", 
                    RowBox[{"Re", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "aa"}], "]"}], "^", 
                    "2"}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "aa"}], "]"}], "^", 
                    "2"}]}], "]"}]}]}], ";", " ", 
                    RowBox[{"rx", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rx", "]"}]}], ";", " ", "\n", 
                    "                   ", 
                    RowBox[{"ry", " ", "=", " ", 
                    RowBox[{"Chop", "[", "ry", "]"}]}], ";", " ", 
                    RowBox[{"rz", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rz", "]"}]}], ";", " ", "\n", 
                    "                   ", 
                    RowBox[{"terminatedeflection", " ", "=", " ", "False"}], 
                    ";", " ", 
                    RowBox[{"intersections", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}], "}"}]}], ";", " ", 
                    RowBox[{
                    "intersections", " ", "=", " ", "\n", 
                    "                    ", 
                    RowBox[{"Block", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "TempVar", ",", " ", "TempVar1", ",", " ", "TempVar2", 
                    ",", " ", "TempVar3", ",", " ", "RayL", ",", " ", "SCx", 
                    ",", " ", "SCy"}], "}"}], ",", " ", 
                    RowBox[{
                    RowBox[{"TempVar1", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"TempVar2", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"TempVar3", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"TempVar", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}], "}"}]}], ";", " ", 
                    RowBox[{"RayL", " ", "=", " ", "1."}], ";", " ", "\n", 
                    "                      ", 
                    RowBox[{"SCx", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"SCy", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"TempVar1", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"rx", "^", "2"}], " ", "+", " ", 
                    RowBox[{"ry", "^", "2"}], " ", "+", " ", 
                    RowBox[{"rz", "^", "2"}]}]}], ";", " ", 
                    RowBox[{
                    "TempVar2", " ", "=", " ", "\n", 
                    "                       ", 
                    RowBox[{
                    RowBox[{"rx", "*", "xunit"}], " ", "+", " ", 
                    RowBox[{"ry", "*", "yunit"}], " ", "+", " ", 
                    RowBox[{
                    "rz", "*", "\n", "                         ", "zunit"}], 
                    " ", "-", " ", 
                    RowBox[{"xunit", "/", "ca1"}]}]}], ";", " ", 
                    RowBox[{"TempVar3", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"-", "TempVar1"}], " ", "+", " ", 
                    RowBox[{"TempVar2", "^", "2"}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"2", "*", "rx"}], ")"}], "/", "ca1"}]}]}], ";", 
                    " ", "\n", "                      ", 
                    RowBox[{"TempVar3", " ", "=", " ", 
                    RowBox[{"Re", "[", "TempVar3", "]"}]}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"N", "[", 
                    RowBox[{"Chop", "[", "TempVar3", "]"}], "]"}], " ", ">=", 
                    " ", "0."}], ",", " ", 
                    RowBox[{
                    RowBox[{"TempVar3", " ", "=", " ", 
                    RowBox[{"Sqrt", "[", "TempVar3", "]"}]}], ";", " ", 
                    RowBox[{"TempVar", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"RayL", ",", " ", "SCx", ",", " ", "SCy"}], "}"}],
                     " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "TempVar2"}], " ", "-", " ", "TempVar3"}], 
                    ",", " ", "\n", "                             ", 
                    RowBox[{"ry", " ", "-", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"TempVar2", " ", "+", " ", "TempVar3"}], ")"}], 
                    "*", "yunit"}]}], ",", " ", 
                    RowBox[{"rz", " ", "-", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"TempVar2", " ", "+", " ", "TempVar3"}], ")"}], 
                    "*", "\n", "                               ", 
                    "zunit"}]}]}], "}"}]}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"N", "[", 
                    RowBox[{"Chop", "[", "RayL", "]"}], "]"}], " ", ">=", " ",
                     "0."}], " ", "&&", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"SCx", "^", "2"}], " ", "+", " ", 
                    RowBox[{"SCy", "^", "2"}]}], " ", "<=", " ", 
                    RowBox[{"0.25", "*", 
                    RowBox[{
                    RowBox[{"Abs", "[", "apa", "]"}], "^", "2"}]}]}], " ", "&&",
                     " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", 
                    RowBox[{
                    "ry", " ", "+", " ", "\n", 
                    "                                 ", 
                    RowBox[{"RayL", "*", "yunit"}], " ", "-", " ", "SCx"}], 
                    "]"}], " ", "+", " ", 
                    RowBox[{"Abs", "[", 
                    RowBox[{"rz", " ", "+", " ", 
                    RowBox[{"RayL", "*", "zunit"}], " ", "-", " ", "SCy"}], 
                    "]"}], " ", "+", " ", "\n", 
                    "                               ", 
                    RowBox[{"Abs", "[", 
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"ca1", "^", 
                    RowBox[{"(", 
                    RowBox[{"-", "1"}], ")"}]}]}], " ", "+", " ", "rx", " ", 
                    "+", " ", 
                    RowBox[{"RayL", "*", "xunit"}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"Sqrt", "[", 
                    RowBox[{
                    RowBox[{"ca1", "^", 
                    RowBox[{"(", 
                    RowBox[{"-", "2"}], ")"}]}], " ", "-", " ", 
                    RowBox[{"SCx", "^", "2"}], " ", "-", " ", 
                    RowBox[{"SCy", "^", "2"}]}], "]"}], "/", 
                    RowBox[{"Sign", "[", "ca1", "]"}]}]}], "]"}]}], " ", "<", 
                    " ", "1.*^-7"}]}], ",", " ", "\n", 
                    "                            ", 
                    RowBox[{"{", 
                    RowBox[{"RayL", ",", " ", "SCx", ",", " ", "SCy"}], "}"}],
                     ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}]}], "]"}]}], ",", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"RayL", ",", " ", "SCx", ",", " ", "SCy"}], "}"}],
                     " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "TempVar2"}], " ", "+", " ", "TempVar3"}], 
                    ",", " ", 
                    RowBox[{"ry", " ", "+", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "TempVar2"}], " ", "+", " ", "TempVar3"}], 
                    ")"}], "*", "\n", "                               ", 
                    "yunit"}]}], ",", " ", 
                    RowBox[{"rz", " ", "+", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "TempVar2"}], " ", "+", " ", "TempVar3"}], 
                    ")"}], "*", "zunit"}]}]}], "}"}]}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"N", "[", 
                    RowBox[{"Chop", "[", "RayL", "]"}], "]"}], " ", ">=", " ",
                     "0."}], " ", "&&", " ", "\n", 
                    "                             ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"SCx", "^", "2"}], " ", "+", " ", 
                    RowBox[{"SCy", "^", "2"}]}], " ", "<=", " ", 
                    RowBox[{"0.25", "*", 
                    RowBox[{
                    RowBox[{"Abs", "[", "apa", "]"}], "^", "2"}]}]}], " ", "&&",
                     " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", 
                    RowBox[{"ry", " ", "+", " ", 
                    RowBox[{"RayL", "*", "yunit"}], " ", "-", " ", "SCx"}], 
                    "]"}], " ", "+", " ", "\n", 
                    "                               ", 
                    RowBox[{"Abs", "[", 
                    RowBox[{"rz", " ", "+", " ", 
                    RowBox[{"RayL", "*", "zunit"}], " ", "-", " ", "SCy"}], 
                    "]"}], " ", "+", " ", 
                    RowBox[{"Abs", "[", 
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"ca1", "^", 
                    RowBox[{"(", 
                    RowBox[{"-", "1"}], ")"}]}]}], " ", "+", " ", "rx", " ", 
                    "+", " ", "\n", "                                 ", 
                    RowBox[{"RayL", "*", "xunit"}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"Sqrt", "[", 
                    RowBox[{
                    RowBox[{"ca1", "^", 
                    RowBox[{"(", 
                    RowBox[{"-", "2"}], ")"}]}], " ", "-", " ", 
                    RowBox[{"SCx", "^", "2"}], " ", "-", " ", 
                    RowBox[{"SCy", "^", "2"}]}], "]"}], "/", 
                    RowBox[{"Sign", "[", "ca1", "]"}]}]}], "]"}]}], " ", "<", 
                    " ", "1.*^-7"}]}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"RayL", ",", " ", "SCx", ",", " ", "SCy"}], "}"}],
                     ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}]}], "]"}]}]}], "}"}]}], ";", " ", "\n", 
                    "                        ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"TempVar", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], " ", "==", " ", 
                    RowBox[{"TempVar", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"TempVar", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "}"}], ",", " ", 
                    "TempVar"}], "]"}]}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}], "}"}]}], "]"}]}]}], "]"}]}], ";", " ", 
                    RowBox[{"AppendTo", "[", 
                    RowBox[{"intersections", ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}]}], "]"}], ";", " ", "\n", "                   ", 
                    RowBox[{"holeQ", " ", "=", " ", "False"}], ";", " ", 
                    RowBox[{"If", "[", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"!", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Chop", "[", 
                    RowBox[{"surfaceid", " ", "-", " ", "16519."}], "]"}], 
                    " ", "==", " ", "0."}], " ", "||", " ", 
                    RowBox[{
                    RowBox[{"N", "[", 
                    RowBox[{"Chop", "[", "ray1", "]"}], "]"}], " ", "<", " ", 
                    "\n", "                        ", "0.0001"}]}], ")"}]}], 
                    " ", "||", " ", 
                    RowBox[{"generationnumber", " ", "==", " ", "1."}]}], ",",
                     " ", 
                    RowBox[{"minresonateraylength", " ", "=", " ", "0."}], 
                    ",", " ", "\n", "                    ", 
                    RowBox[{
                    "minresonateraylength", " ", "=", " ", "0.0001"}]}], 
                    "]"}], ";", " ", 
                    RowBox[{"Block", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"RayL", ",", " ", "SCx", ",", " ", "SCy"}], "}"}],
                     ",", " ", 
                    RowBox[{
                    RowBox[{"RayL", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"SCx", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"SCy", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{
                    "dummymatrix", " ", "=", " ", "\n", 
                    "                      ", 
                    RowBox[{"Union", "[", 
                    RowBox[{"Select", "[", 
                    RowBox[{"intersections", ",", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"RayL", ",", " ", "SCx", ",", " ", "SCy"}], "}"}],
                     " ", "=", " ", "#1"}], ";", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"RayL", ",", " ", "SCx", ",", " ", "SCy"}], "}"}],
                     " ", "==", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}]}], " ", "||", " ", 
                    RowBox[{
                    RowBox[{"N", "[", 
                    RowBox[{"Chop", "[", "RayL", "]"}], "]"}], " ", ">=", " ",
                     "\n", "                            ", 
                    "minresonateraylength"}]}]}], ")"}], " ", "&"}]}], " ", 
                    "]"}], "]"}]}], ";", " ", 
                    RowBox[{
                    "intersections", " ", "=", " ", "dummymatrix"}]}]}], 
                    "]"}], ";", " ", "\n", "                   ", 
                    RowBox[{
                    "unfilteredintersections", " ", "=", " ", 
                    "intersections"}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", "intersections", "]"}], " ", ">", 
                    " ", "1"}], ",", " ", "\n", "                    ", 
                    RowBox[{
                    RowBox[{"dummymatrix", " ", "=", " ", 
                    RowBox[{"Take", "[", 
                    RowBox[{"intersections", ",", " ", 
                    RowBox[{"{", "2", "}"}]}], "]"}]}], ";", " ", 
                    RowBox[{
                    "intersections", " ", "=", " ", "\n", 
                    "                      ", "dummymatrix"}], ";", " ", 
                    "1."}], ",", " ", "1."}], "]"}], ";", " ", 
                    RowBox[{"AppendTo", "[", 
                    RowBox[{"intersectionslist", ",", " ", "intersections"}], 
                    "]"}], ";", " ", "\n", "                   ", 
                    RowBox[{"If", "[", 
                    RowBox[{"holeQ", ",", " ", 
                    RowBox[{"AppendTo", "[", 
                    RowBox[{"holeQlist", ",", " ", "1"}], "]"}], ",", " ", 
                    RowBox[{"AppendTo", "[", 
                    RowBox[{"holeQlist", ",", " ", "0"}], "]"}]}], "]"}], ";",
                     " ", "\n", "                   ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "\n", "                     ", 
                    "rez", ",", " ", "r1", ",", " ", "r2", ",", " ", "r3", 
                    ",", " ", "r4", ",", " ", "\n", "                     ", 
                    "r5", ",", " ", "r6", ",", " ", "r7", ",", " ", "r8", ",",
                     " ", "r9", ",", " ", "\n", "                     ", 
                    "wavelength", ",", " ", "intensity", ",", " ", 
                    "intensityscale", ",", " ", "ray1", ",", " ", "\n", 
                    "                     ", "index", ",", " ", 
                    "opticallength", ",", " ", "phaseshift", ",", " ", 
                    "componentnumber", ",", " ", "\n", 
                    "                     ", "surfacenumber", ",", " ", 
                    "surfaceid", ",", " ", "ray2", ",", " ", "ray3", ",", " ",
                     "\n", "                     ", "sid", ",", " ", 
                    "frontid", ",", " ", "sno1", ",", " ", "sno2", ",", " ", 
                    "sno3", ",", " ", "\n", "                     ", "sno4", 
                    ",", " ", "rayslot", ",", " ", "oldgenerationnumber", ",",
                     " ", "intersectionnumber", ",", " ", "\n", 
                    "                     ", "pol1", ",", " ", "pol2", ",", 
                    " ", "pol3"}], "}"}], " ", "=", " ", "#1"}], ";", " ", 
                    RowBox[{
                    "index1", " ", "=", " ", "\n", "                    ", 
                    "index"}], ";", " ", 
                    RowBox[{"xunit", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"r1", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "aa"}], "]"}], 
                    "]"}]}], " ", "+", " ", 
                    RowBox[{"r2", "*", "\n", "                      ", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "aa"}], "]"}], 
                    "]"}]}]}]}], ";", " ", 
                    RowBox[{"yunit", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"r2", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "aa"}], "]"}], 
                    "]"}]}], " ", "-", " ", "\n", "                     ", 
                    RowBox[{"1.", "*", "r1", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "aa"}], "]"}], 
                    "]"}]}]}]}], ";", " ", 
                    RowBox[{"zunit", " ", "=", " ", 
                    RowBox[{"r3", "*", "\n", "                     ", 
                    RowBox[{"Re", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "aa"}], "]"}], "^", 
                    "2"}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "aa"}], "]"}], "^", 
                    "2"}]}], "]"}]}]}], ";", " ", 
                    RowBox[{"xunit", " ", "=", " ", 
                    RowBox[{"Chop", "[", "xunit", "]"}]}], ";", " ", "\n", 
                    "                   ", 
                    RowBox[{"yunit", " ", "=", " ", 
                    RowBox[{"Chop", "[", "yunit", "]"}]}], ";", " ", 
                    RowBox[{"zunit", " ", "=", " ", 
                    RowBox[{"Chop", "[", "zunit", "]"}]}], ";", " ", "\n", 
                    "                   ", 
                    RowBox[{"magnitude", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"xunit", "^", "2"}], " ", "+", " ", 
                    RowBox[{"yunit", "^", "2"}], " ", "+", " ", 
                    RowBox[{"zunit", "^", "2"}]}], ")"}], "^", 
                    RowBox[{"2", "^", 
                    RowBox[{"(", 
                    RowBox[{"-", "1"}], ")"}]}]}]}], ";", " ", "\n", 
                    "                   ", 
                    RowBox[{"xunit", " ", "=", " ", 
                    RowBox[{"xunit", "/", "magnitude"}]}], ";", " ", 
                    RowBox[{
                    "yunit", " ", "=", " ", "\n", "                    ", 
                    RowBox[{"yunit", "/", "magnitude"}]}], ";", " ", 
                    RowBox[{"zunit", " ", "=", " ", 
                    RowBox[{
                    "zunit", "/", "\n", "                     ", 
                    "magnitude"}]}], ";", " ", 
                    RowBox[{"rx", " ", "=", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "aa"}], "]"}], "]"}],
                     "*", 
                    RowBox[{"(", 
                    RowBox[{
                    "rex", " ", "-", " ", "\n", "                       ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"xa1", " ", "+", " ", 
                    RowBox[{"ta", "*", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "aa"}], "]"}]}]}], 
                    "]"}]}]}], ")"}]}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "aa"}], "]"}], "]"}],
                     "*", 
                    RowBox[{"(", 
                    RowBox[{
                    "rey", " ", "-", " ", "\n", "                       ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"ya1", " ", "+", " ", 
                    RowBox[{"ta", "*", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "aa"}], "]"}]}]}], 
                    "]"}]}]}], ")"}]}]}]}], ";", " ", 
                    RowBox[{"ry", " ", "=", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "1."}], "*", 
                    RowBox[{"(", 
                    RowBox[{
                    "rex", " ", "-", " ", "\n", "                       ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"xa1", " ", "+", " ", 
                    RowBox[{"ta", "*", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "aa"}], "]"}]}]}], 
                    "]"}]}]}], ")"}], "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "aa"}], "]"}], 
                    "]"}]}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "aa"}], "]"}], "]"}],
                     "*", 
                    RowBox[{"(", 
                    RowBox[{
                    "rey", " ", "-", " ", "\n", "                       ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"ya1", " ", "+", " ", 
                    RowBox[{"ta", "*", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "aa"}], "]"}]}]}], 
                    "]"}]}]}], ")"}]}]}]}], ";", " ", 
                    RowBox[{"rz", " ", "=", " ", 
                    RowBox[{"rez", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "aa"}], "]"}], "^", 
                    "2"}], " ", "+", " ", "\n", "                       ", 
                    RowBox[{
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "aa"}], "]"}], "^", 
                    "2"}]}], "]"}]}]}], ";", " ", 
                    RowBox[{"rx", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rx", "]"}]}], ";", " ", 
                    RowBox[{"ry", " ", "=", " ", "\n", "                    ", 
                    RowBox[{"Chop", "[", "ry", "]"}]}], ";", " ", 
                    RowBox[{"rz", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rz", "]"}]}], ";", " ", 
                    RowBox[{"terminatedeflection", " ", "=", " ", "False"}], 
                    ";", " ", "\n", "                   ", 
                    RowBox[{"intersections", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}], "}"}]}], ";", " ", 
                    RowBox[{"intersections", " ", "=", " ", 
                    RowBox[{"Block", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "TempVar", ",", " ", "TempVar1", ",", " ", "TempVar2", 
                    ",", " ", "TempVar3", ",", " ", "RayL", ",", " ", "\n", 
                    "                      ", "SCx", ",", " ", "SCy"}], "}"}],
                     ",", " ", 
                    RowBox[{
                    RowBox[{"TempVar1", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"TempVar2", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"TempVar3", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"TempVar", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}], "}"}]}], ";", " ", 
                    RowBox[{"RayL", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"SCx", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"SCy", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{
                    "TempVar1", " ", "=", " ", "\n", 
                    "                       ", 
                    RowBox[{
                    RowBox[{"rx", "^", "2"}], " ", "+", " ", 
                    RowBox[{"ry", "^", "2"}], " ", "+", " ", 
                    RowBox[{"rz", "^", "2"}]}]}], ";", " ", 
                    RowBox[{"TempVar2", " ", "=", " ", 
                    RowBox[{
                    RowBox[{
                    "rx", "*", "\n", "                         ", "xunit"}], 
                    " ", "+", " ", 
                    RowBox[{"ry", "*", "yunit"}], " ", "+", " ", 
                    RowBox[{"rz", "*", "zunit"}], " ", "-", " ", "\n", 
                    "                        ", 
                    RowBox[{"xunit", "/", "ca2"}]}]}], ";", " ", 
                    RowBox[{"TempVar3", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"-", "TempVar1"}], " ", "+", " ", 
                    RowBox[{"TempVar2", "^", "2"}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"2", "*", "rx"}], ")"}], "/", "ca2"}]}]}], ";", 
                    " ", 
                    RowBox[{"TempVar3", " ", "=", " ", 
                    RowBox[{"Re", "[", "TempVar3", "]"}]}], ";", " ", "\n", 
                    "                      ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"N", "[", 
                    RowBox[{"Chop", "[", "TempVar3", "]"}], "]"}], " ", ">=", 
                    " ", "0."}], ",", " ", 
                    RowBox[{
                    RowBox[{"TempVar3", " ", "=", " ", 
                    RowBox[{"Sqrt", "[", "TempVar3", "]"}]}], ";", " ", 
                    RowBox[{"TempVar", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"RayL", ",", " ", "SCx", ",", " ", "SCy"}], "}"}],
                     " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "TempVar2"}], " ", "-", " ", "TempVar3"}], 
                    ",", " ", 
                    RowBox[{
                    "ry", " ", "-", " ", "\n", 
                    "                              ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"TempVar2", " ", "+", " ", "TempVar3"}], ")"}], 
                    "*", "yunit"}]}], ",", " ", 
                    RowBox[{"rz", " ", "-", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"TempVar2", " ", "+", " ", "TempVar3"}], ")"}], 
                    "*", "zunit"}]}]}], "}"}]}], ";", " ", "\n", 
                    "                           ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"N", "[", 
                    RowBox[{"Chop", "[", "RayL", "]"}], "]"}], " ", ">=", " ",
                     "0."}], " ", "&&", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"SCx", "^", "2"}], " ", "+", " ", 
                    RowBox[{"SCy", "^", "2"}]}], " ", "<=", " ", 
                    RowBox[{"0.25", "*", 
                    RowBox[{
                    RowBox[{"Abs", "[", "apa", "]"}], "^", "2"}]}]}], " ", "&&",
                     " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", 
                    RowBox[{"ry", " ", "+", " ", 
                    RowBox[{"RayL", "*", "yunit"}], " ", "-", " ", "SCx"}], 
                    "]"}], " ", "+", " ", "\n", 
                    "                               ", 
                    RowBox[{"Abs", "[", 
                    RowBox[{"rz", " ", "+", " ", 
                    RowBox[{"RayL", "*", "zunit"}], " ", "-", " ", "SCy"}], 
                    "]"}], " ", "+", " ", 
                    RowBox[{"Abs", "[", 
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"ca2", "^", 
                    RowBox[{"(", 
                    RowBox[{"-", "1"}], ")"}]}]}], " ", "+", " ", "rx", " ", 
                    "+", " ", "\n", "                                 ", 
                    RowBox[{"RayL", "*", "xunit"}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"Sqrt", "[", 
                    RowBox[{
                    RowBox[{"ca2", "^", 
                    RowBox[{"(", 
                    RowBox[{"-", "2"}], ")"}]}], " ", "-", " ", 
                    RowBox[{"SCx", "^", "2"}], " ", "-", " ", 
                    RowBox[{"SCy", "^", "2"}]}], "]"}], "/", 
                    RowBox[{"Sign", "[", "ca2", "]"}]}]}], "]"}]}], " ", "<", 
                    " ", "1.*^-7"}]}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"RayL", ",", " ", "SCx", ",", " ", "SCy"}], "}"}],
                     ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}]}], "]"}]}], ",", " ", "\n", 
                    "                          ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"RayL", ",", " ", "SCx", ",", " ", "SCy"}], "}"}],
                     " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "TempVar2"}], " ", "+", " ", "TempVar3"}], 
                    ",", " ", 
                    RowBox[{"ry", " ", "+", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "TempVar2"}], " ", "+", " ", "TempVar3"}], 
                    ")"}], "*", "yunit"}]}], ",", " ", "\n", 
                    "                             ", 
                    RowBox[{"rz", " ", "+", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "TempVar2"}], " ", "+", " ", "TempVar3"}], 
                    ")"}], "*", "zunit"}]}]}], "}"}]}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"N", "[", 
                    RowBox[{"Chop", "[", "RayL", "]"}], "]"}], " ", ">=", " ",
                     "0."}], " ", "&&", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"SCx", "^", "2"}], " ", "+", " ", 
                    RowBox[{"SCy", "^", "2"}]}], " ", "<=", " ", "\n", 
                    "                              ", 
                    RowBox[{"0.25", "*", 
                    RowBox[{
                    RowBox[{"Abs", "[", "apa", "]"}], "^", "2"}]}]}], " ", "&&",
                     " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", 
                    RowBox[{"ry", " ", "+", " ", 
                    RowBox[{"RayL", "*", "yunit"}], " ", "-", " ", "SCx"}], 
                    "]"}], " ", "+", " ", 
                    RowBox[{"Abs", "[", 
                    RowBox[{
                    "rz", " ", "+", " ", "\n", 
                    "                                 ", 
                    RowBox[{"RayL", "*", "zunit"}], " ", "-", " ", "SCy"}], 
                    "]"}], " ", "+", " ", 
                    RowBox[{"Abs", "[", 
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"ca2", "^", 
                    RowBox[{"(", 
                    RowBox[{"-", "1"}], ")"}]}]}], " ", "+", " ", "rx", " ", 
                    "+", " ", 
                    RowBox[{"RayL", "*", "xunit"}], " ", "+", " ", "\n", 
                    "                                 ", 
                    RowBox[{
                    RowBox[{"Sqrt", "[", 
                    RowBox[{
                    RowBox[{"ca2", "^", 
                    RowBox[{"(", 
                    RowBox[{"-", "2"}], ")"}]}], " ", "-", " ", 
                    RowBox[{"SCx", "^", "2"}], " ", "-", " ", 
                    RowBox[{"SCy", "^", "2"}]}], "]"}], "/", 
                    RowBox[{"Sign", "[", "ca2", "]"}]}]}], "]"}]}], " ", "<", 
                    " ", "1.*^-7"}]}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"RayL", ",", " ", "SCx", ",", " ", "SCy"}], "}"}],
                     ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}]}], "]"}]}]}], "}"}]}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"TempVar", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], " ", "==", " ", 
                    RowBox[{"TempVar", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], ",", " ", "\n", 
                    "                         ", 
                    RowBox[{"{", 
                    RowBox[{"TempVar", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "}"}], ",", " ", 
                    "TempVar"}], "]"}]}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}], "}"}]}], "]"}]}]}], "]"}]}], ";", " ", 
                    RowBox[{"AppendTo", "[", 
                    RowBox[{"intersections", ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}]}], "]"}], ";", " ", 
                    RowBox[{
                    "holeQ", " ", "=", " ", "\n", "                    ", 
                    "False"}], ";", " ", 
                    RowBox[{"If", "[", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"!", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Chop", "[", 
                    RowBox[{"surfaceid", " ", "-", " ", "16520."}], "]"}], 
                    " ", "==", " ", "0."}], " ", "||", " ", 
                    RowBox[{
                    RowBox[{"N", "[", 
                    RowBox[{"Chop", "[", "ray1", "]"}], "]"}], " ", "<", " ", 
                    "0.0001"}]}], ")"}]}], " ", "||", " ", "\n", 
                    "                     ", 
                    RowBox[{"generationnumber", " ", "==", " ", "1."}]}], ",",
                     " ", 
                    RowBox[{"minresonateraylength", " ", "=", " ", "0."}], 
                    ",", " ", 
                    RowBox[{
                    "minresonateraylength", " ", "=", " ", "\n", 
                    "                     ", "0.0001"}]}], "]"}], ";", " ", 
                    RowBox[{"Block", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"RayL", ",", " ", "SCx", ",", " ", "SCy"}], "}"}],
                     ",", " ", 
                    RowBox[{
                    RowBox[{"RayL", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"SCx", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"SCy", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"dummymatrix", " ", "=", " ", 
                    RowBox[{"Union", "[", 
                    RowBox[{"Select", "[", "\n", "                        ", 
                    RowBox[{"intersections", ",", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"RayL", ",", " ", "SCx", ",", " ", "SCy"}], "}"}],
                     " ", "=", " ", "#1"}], ";", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"RayL", ",", " ", "SCx", ",", " ", "SCy"}], "}"}],
                     " ", "==", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}]}], " ", "||", " ", 
                    RowBox[{
                    RowBox[{"N", "[", 
                    RowBox[{"Chop", "[", "RayL", "]"}], "]"}], " ", ">=", " ",
                     "\n", "                            ", 
                    "minresonateraylength"}]}]}], ")"}], " ", "&"}]}], " ", 
                    "]"}], "]"}]}], ";", " ", 
                    RowBox[{
                    "intersections", " ", "=", " ", "dummymatrix"}]}]}], 
                    "]"}], ";", " ", "\n", "                   ", 
                    RowBox[{
                    "unfilteredintersections", " ", "=", " ", 
                    "intersections"}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", "intersections", "]"}], " ", ">", 
                    " ", "1"}], ",", " ", "\n", "                    ", 
                    RowBox[{
                    RowBox[{"dummymatrix", " ", "=", " ", 
                    RowBox[{"Take", "[", 
                    RowBox[{"intersections", ",", " ", 
                    RowBox[{"{", "2", "}"}]}], "]"}]}], ";", " ", 
                    RowBox[{
                    "intersections", " ", "=", " ", "\n", 
                    "                      ", "dummymatrix"}], ";", " ", 
                    "1."}], ",", " ", "1."}], "]"}], ";", " ", 
                    RowBox[{"AppendTo", "[", 
                    RowBox[{"intersectionslist", ",", " ", "intersections"}], 
                    "]"}], ";", " ", "\n", "                   ", 
                    RowBox[{"If", "[", 
                    RowBox[{"holeQ", ",", " ", 
                    RowBox[{"AppendTo", "[", 
                    RowBox[{"holeQlist", ",", " ", "1"}], "]"}], ",", " ", 
                    RowBox[{"AppendTo", "[", 
                    RowBox[{"holeQlist", ",", " ", "0"}], "]"}]}], "]"}], ";",
                     " ", "\n", "                   ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "\n", "                     ", 
                    "rez", ",", " ", "r1", ",", " ", "r2", ",", " ", "r3", 
                    ",", " ", "r4", ",", " ", "\n", "                     ", 
                    "r5", ",", " ", "r6", ",", " ", "r7", ",", " ", "r8", ",",
                     " ", "r9", ",", " ", "\n", "                     ", 
                    "wavelength", ",", " ", "intensity", ",", " ", 
                    "intensityscale", ",", " ", "ray1", ",", " ", "\n", 
                    "                     ", "index", ",", " ", 
                    "opticallength", ",", " ", "phaseshift", ",", " ", 
                    "componentnumber", ",", " ", "\n", 
                    "                     ", "surfacenumber", ",", " ", 
                    "surfaceid", ",", " ", "ray2", ",", " ", "ray3", ",", " ",
                     "\n", "                     ", "sid", ",", " ", 
                    "frontid", ",", " ", "sno1", ",", " ", "sno2", ",", " ", 
                    "sno3", ",", " ", "\n", "                     ", "sno4", 
                    ",", " ", "rayslot", ",", " ", "oldgenerationnumber", ",",
                     " ", "intersectionnumber", ",", " ", "\n", 
                    "                     ", "pol1", ",", " ", "pol2", ",", 
                    " ", "pol3"}], "}"}], " ", "=", " ", "#1"}], ";", " ", 
                    RowBox[{
                    "index1", " ", "=", " ", "\n", "                    ", 
                    "index"}], ";", " ", 
                    RowBox[{"xunit", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"r1", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "ab"}], "]"}], 
                    "]"}]}], " ", "+", " ", 
                    RowBox[{"r2", "*", "\n", "                      ", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "ab"}], "]"}], 
                    "]"}]}]}]}], ";", " ", 
                    RowBox[{"yunit", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"r2", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "ab"}], "]"}], 
                    "]"}]}], " ", "-", " ", "\n", "                     ", 
                    RowBox[{"1.", "*", "r1", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "ab"}], "]"}], 
                    "]"}]}]}]}], ";", " ", 
                    RowBox[{"zunit", " ", "=", " ", 
                    RowBox[{"r3", "*", "\n", "                     ", 
                    RowBox[{"Re", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "ab"}], "]"}], "^", 
                    "2"}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "ab"}], "]"}], "^", 
                    "2"}]}], "]"}]}]}], ";", " ", 
                    RowBox[{"xunit", " ", "=", " ", 
                    RowBox[{"Chop", "[", "xunit", "]"}]}], ";", " ", "\n", 
                    "                   ", 
                    RowBox[{"yunit", " ", "=", " ", 
                    RowBox[{"Chop", "[", "yunit", "]"}]}], ";", " ", 
                    RowBox[{"zunit", " ", "=", " ", 
                    RowBox[{"Chop", "[", "zunit", "]"}]}], ";", " ", "\n", 
                    "                   ", 
                    RowBox[{"magnitude", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"xunit", "^", "2"}], " ", "+", " ", 
                    RowBox[{"yunit", "^", "2"}], " ", "+", " ", 
                    RowBox[{"zunit", "^", "2"}]}], ")"}], "^", 
                    RowBox[{"2", "^", 
                    RowBox[{"(", 
                    RowBox[{"-", "1"}], ")"}]}]}]}], ";", " ", "\n", 
                    "                   ", 
                    RowBox[{"xunit", " ", "=", " ", 
                    RowBox[{"xunit", "/", "magnitude"}]}], ";", " ", 
                    RowBox[{
                    "yunit", " ", "=", " ", "\n", "                    ", 
                    RowBox[{"yunit", "/", "magnitude"}]}], ";", " ", 
                    RowBox[{"zunit", " ", "=", " ", 
                    RowBox[{
                    "zunit", "/", "\n", "                     ", 
                    "magnitude"}]}], ";", " ", 
                    RowBox[{"rx", " ", "=", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"rex", " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"Re", "[", "xb1", "]"}]}]}], ")"}], "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "ab"}], "]"}], 
                    "]"}]}], " ", "+", " ", "\n", "                     ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"rey", " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"Re", "[", "yb1", "]"}]}]}], ")"}], "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "ab"}], "]"}], 
                    "]"}]}]}]}], ";", " ", 
                    RowBox[{"ry", " ", "=", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"rey", " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"Re", "[", "yb1", "]"}]}]}], ")"}], "*", "\n", 
                    "                      ", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "ab"}], "]"}], 
                    "]"}]}], " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"(", 
                    RowBox[{"rex", " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"Re", "[", "xb1", "]"}]}]}], ")"}], "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "ab"}], "]"}], 
                    "]"}]}]}]}], ";", " ", 
                    RowBox[{"rz", " ", "=", " ", "\n", "                    ", 
                    RowBox[{"rez", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "ab"}], "]"}], "^", 
                    "2"}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "ab"}], "]"}], "^", 
                    "2"}]}], "]"}]}]}], ";", " ", 
                    RowBox[{"rx", " ", "=", " ", "\n", "                    ", 
                    RowBox[{"Chop", "[", "rx", "]"}]}], ";", " ", 
                    RowBox[{"ry", " ", "=", " ", 
                    RowBox[{"Chop", "[", "ry", "]"}]}], ";", " ", 
                    RowBox[{"rz", " ", "=", " ", "\n", "                    ", 
                    RowBox[{"Chop", "[", "rz", "]"}]}], ";", " ", 
                    RowBox[{"terminatedeflection", " ", "=", " ", "False"}], 
                    ";", " ", 
                    RowBox[{"intersections", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}], "}"}]}], ";", " ", "\n", "                   ", 
                    RowBox[{"intersections", " ", "=", " ", 
                    RowBox[{"Block", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "TempVar", ",", " ", "TempVar1", ",", " ", "TempVar2", 
                    ",", " ", "TempVar3", ",", " ", "RayL", ",", " ", "SCx", 
                    ",", " ", "SCy"}], "}"}], ",", " ", 
                    RowBox[{
                    RowBox[{"TempVar1", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"TempVar2", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"TempVar3", " ", "=", " ", "1."}], ";", " ", "\n",
                     "                      ", 
                    RowBox[{"TempVar", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}], "}"}]}], ";", " ", 
                    RowBox[{"RayL", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"SCx", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"SCy", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"TempVar1", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"rx", "^", "2"}], " ", "+", " ", 
                    RowBox[{"ry", "^", "2"}], " ", "+", " ", "\n", 
                    "                        ", 
                    RowBox[{"rz", "^", "2"}]}]}], ";", " ", 
                    RowBox[{"TempVar2", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"rx", "*", "xunit"}], " ", "+", " ", 
                    RowBox[{
                    "ry", "*", "\n", "                         ", "yunit"}], 
                    " ", "+", " ", 
                    RowBox[{"rz", "*", "zunit"}], " ", "-", " ", 
                    RowBox[{"xunit", "/", "cb1"}]}]}], ";", " ", "\n", 
                    "                      ", 
                    RowBox[{"TempVar3", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"-", "TempVar1"}], " ", "+", " ", 
                    RowBox[{"TempVar2", "^", "2"}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"2", "*", "rx"}], ")"}], "/", "cb1"}]}]}], ";", 
                    " ", 
                    RowBox[{"TempVar3", " ", "=", " ", 
                    RowBox[{"Re", "[", "TempVar3", "]"}]}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"N", "[", 
                    RowBox[{"Chop", "[", "TempVar3", "]"}], "]"}], " ", ">=", 
                    " ", "0."}], ",", " ", "\n", "                       ", 
                    RowBox[{
                    RowBox[{"TempVar3", " ", "=", " ", 
                    RowBox[{"Sqrt", "[", "TempVar3", "]"}]}], ";", " ", 
                    RowBox[{"TempVar", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"RayL", ",", " ", "SCx", ",", " ", "SCy"}], "}"}],
                     " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "TempVar2"}], " ", "-", " ", "TempVar3"}], 
                    ",", " ", 
                    RowBox[{"ry", " ", "-", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"TempVar2", " ", "+", " ", "TempVar3"}], ")"}], 
                    "*", "\n", "                               ", "yunit"}]}],
                     ",", " ", 
                    RowBox[{"rz", " ", "-", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"TempVar2", " ", "+", " ", "TempVar3"}], ")"}], 
                    "*", "zunit"}]}]}], "}"}]}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"N", "[", 
                    RowBox[{"Chop", "[", "RayL", "]"}], "]"}], " ", ">=", " ",
                     "0."}], " ", "&&", " ", "\n", 
                    "                             ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"SCx", "^", "2"}], " ", "+", " ", 
                    RowBox[{"SCy", "^", "2"}]}], " ", "<=", " ", 
                    RowBox[{"0.25", "*", 
                    RowBox[{
                    RowBox[{"Abs", "[", "apb", "]"}], "^", "2"}]}]}], " ", "&&",
                     " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", 
                    RowBox[{"ry", " ", "+", " ", 
                    RowBox[{"RayL", "*", "yunit"}], " ", "-", " ", "SCx"}], 
                    "]"}], " ", "+", " ", "\n", 
                    "                               ", 
                    RowBox[{"Abs", "[", 
                    RowBox[{"rz", " ", "+", " ", 
                    RowBox[{"RayL", "*", "zunit"}], " ", "-", " ", "SCy"}], 
                    "]"}], " ", "+", " ", 
                    RowBox[{"Abs", "[", 
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"cb1", "^", 
                    RowBox[{"(", 
                    RowBox[{"-", "1"}], ")"}]}]}], " ", "+", " ", "rx", " ", 
                    "+", " ", "\n", "                                 ", 
                    RowBox[{"RayL", "*", "xunit"}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"Sqrt", "[", 
                    RowBox[{
                    RowBox[{"cb1", "^", 
                    RowBox[{"(", 
                    RowBox[{"-", "2"}], ")"}]}], " ", "-", " ", 
                    RowBox[{"SCx", "^", "2"}], " ", "-", " ", 
                    RowBox[{"SCy", "^", "2"}]}], "]"}], "/", 
                    RowBox[{"Sign", "[", "cb1", "]"}]}]}], "]"}]}], " ", "<", 
                    " ", "1.*^-7"}]}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"RayL", ",", " ", "SCx", ",", " ", "SCy"}], "}"}],
                     ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}]}], "]"}]}], ",", " ", "\n", 
                    "                          ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"RayL", ",", " ", "SCx", ",", " ", "SCy"}], "}"}],
                     " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "TempVar2"}], " ", "+", " ", "TempVar3"}], 
                    ",", " ", 
                    RowBox[{"ry", " ", "+", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "TempVar2"}], " ", "+", " ", "TempVar3"}], 
                    ")"}], "*", "yunit"}]}], ",", " ", "\n", 
                    "                             ", 
                    RowBox[{"rz", " ", "+", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "TempVar2"}], " ", "+", " ", "TempVar3"}], 
                    ")"}], "*", "zunit"}]}]}], "}"}]}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"N", "[", 
                    RowBox[{"Chop", "[", "RayL", "]"}], "]"}], " ", ">=", " ",
                     "0."}], " ", "&&", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"SCx", "^", "2"}], " ", "+", " ", 
                    RowBox[{"SCy", "^", "2"}]}], " ", "<=", " ", "\n", 
                    "                              ", 
                    RowBox[{"0.25", "*", 
                    RowBox[{
                    RowBox[{"Abs", "[", "apb", "]"}], "^", "2"}]}]}], " ", "&&",
                     " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", 
                    RowBox[{"ry", " ", "+", " ", 
                    RowBox[{"RayL", "*", "yunit"}], " ", "-", " ", "SCx"}], 
                    "]"}], " ", "+", " ", 
                    RowBox[{"Abs", "[", 
                    RowBox[{
                    "rz", " ", "+", " ", "\n", 
                    "                                 ", 
                    RowBox[{"RayL", "*", "zunit"}], " ", "-", " ", "SCy"}], 
                    "]"}], " ", "+", " ", 
                    RowBox[{"Abs", "[", 
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"cb1", "^", 
                    RowBox[{"(", 
                    RowBox[{"-", "1"}], ")"}]}]}], " ", "+", " ", "rx", " ", 
                    "+", " ", 
                    RowBox[{"RayL", "*", "xunit"}], " ", "+", " ", "\n", 
                    "                                 ", 
                    RowBox[{
                    RowBox[{"Sqrt", "[", 
                    RowBox[{
                    RowBox[{"cb1", "^", 
                    RowBox[{"(", 
                    RowBox[{"-", "2"}], ")"}]}], " ", "-", " ", 
                    RowBox[{"SCx", "^", "2"}], " ", "-", " ", 
                    RowBox[{"SCy", "^", "2"}]}], "]"}], "/", 
                    RowBox[{"Sign", "[", "cb1", "]"}]}]}], "]"}]}], " ", "<", 
                    " ", "1.*^-7"}]}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"RayL", ",", " ", "SCx", ",", " ", "SCy"}], "}"}],
                     ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}]}], "]"}]}]}], "}"}]}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"TempVar", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], " ", "==", " ", 
                    RowBox[{"TempVar", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], ",", " ", "\n", 
                    "                         ", 
                    RowBox[{"{", 
                    RowBox[{"TempVar", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "}"}], ",", " ", 
                    "TempVar"}], "]"}]}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}], "}"}]}], "]"}]}]}], "]"}]}], ";", " ", 
                    RowBox[{"AppendTo", "[", 
                    RowBox[{"intersections", ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}]}], "]"}], ";", " ", 
                    RowBox[{
                    "holeQ", " ", "=", " ", "\n", "                    ", 
                    "False"}], ";", " ", 
                    RowBox[{"If", "[", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"!", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Chop", "[", 
                    RowBox[{"surfaceid", " ", "-", " ", "16547."}], "]"}], 
                    " ", "==", " ", "0."}], " ", "||", " ", 
                    RowBox[{
                    RowBox[{"N", "[", 
                    RowBox[{"Chop", "[", "ray1", "]"}], "]"}], " ", "<", " ", 
                    "0.0001"}]}], ")"}]}], " ", "||", " ", "\n", 
                    "                     ", 
                    RowBox[{"generationnumber", " ", "==", " ", "1."}]}], ",",
                     " ", 
                    RowBox[{"minresonateraylength", " ", "=", " ", "0."}], 
                    ",", " ", 
                    RowBox[{
                    "minresonateraylength", " ", "=", " ", "\n", 
                    "                     ", "0.0001"}]}], "]"}], ";", " ", 
                    RowBox[{"Block", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"RayL", ",", " ", "SCx", ",", " ", "SCy"}], "}"}],
                     ",", " ", 
                    RowBox[{
                    RowBox[{"RayL", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"SCx", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"SCy", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"dummymatrix", " ", "=", " ", 
                    RowBox[{"Union", "[", 
                    RowBox[{"Select", "[", "\n", "                        ", 
                    RowBox[{"intersections", ",", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"RayL", ",", " ", "SCx", ",", " ", "SCy"}], "}"}],
                     " ", "=", " ", "#1"}], ";", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"RayL", ",", " ", "SCx", ",", " ", "SCy"}], "}"}],
                     " ", "==", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}]}], " ", "||", " ", 
                    RowBox[{
                    RowBox[{"N", "[", 
                    RowBox[{"Chop", "[", "RayL", "]"}], "]"}], " ", ">=", " ",
                     "\n", "                            ", 
                    "minresonateraylength"}]}]}], ")"}], " ", "&"}]}], " ", 
                    "]"}], "]"}]}], ";", " ", 
                    RowBox[{
                    "intersections", " ", "=", " ", "dummymatrix"}]}]}], 
                    "]"}], ";", " ", "\n", "                   ", 
                    RowBox[{
                    "unfilteredintersections", " ", "=", " ", 
                    "intersections"}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", "intersections", "]"}], " ", ">", 
                    " ", "1"}], ",", " ", "\n", "                    ", 
                    RowBox[{
                    RowBox[{"dummymatrix", " ", "=", " ", 
                    RowBox[{"Take", "[", 
                    RowBox[{"intersections", ",", " ", 
                    RowBox[{"{", "2", "}"}]}], "]"}]}], ";", " ", 
                    RowBox[{
                    "intersections", " ", "=", " ", "\n", 
                    "                      ", "dummymatrix"}], ";", " ", 
                    "1."}], ",", " ", "1."}], "]"}], ";", " ", 
                    RowBox[{"AppendTo", "[", 
                    RowBox[{"intersectionslist", ",", " ", "intersections"}], 
                    "]"}], ";", " ", "\n", "                   ", 
                    RowBox[{"If", "[", 
                    RowBox[{"holeQ", ",", " ", 
                    RowBox[{"AppendTo", "[", 
                    RowBox[{"holeQlist", ",", " ", "1"}], "]"}], ",", " ", 
                    RowBox[{"AppendTo", "[", 
                    RowBox[{"holeQlist", ",", " ", "0"}], "]"}]}], "]"}], ";",
                     " ", "\n", "                   ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "\n", "                     ", 
                    "rez", ",", " ", "r1", ",", " ", "r2", ",", " ", "r3", 
                    ",", " ", "r4", ",", " ", "\n", "                     ", 
                    "r5", ",", " ", "r6", ",", " ", "r7", ",", " ", "r8", ",",
                     " ", "r9", ",", " ", "\n", "                     ", 
                    "wavelength", ",", " ", "intensity", ",", " ", 
                    "intensityscale", ",", " ", "ray1", ",", " ", "\n", 
                    "                     ", "index", ",", " ", 
                    "opticallength", ",", " ", "phaseshift", ",", " ", 
                    "componentnumber", ",", " ", "\n", 
                    "                     ", "surfacenumber", ",", " ", 
                    "surfaceid", ",", " ", "ray2", ",", " ", "ray3", ",", " ",
                     "\n", "                     ", "sid", ",", " ", 
                    "frontid", ",", " ", "sno1", ",", " ", "sno2", ",", " ", 
                    "sno3", ",", " ", "\n", "                     ", "sno4", 
                    ",", " ", "rayslot", ",", " ", "oldgenerationnumber", ",",
                     " ", "intersectionnumber", ",", " ", "\n", 
                    "                     ", "pol1", ",", " ", "pol2", ",", 
                    " ", "pol3"}], "}"}], " ", "=", " ", "#1"}], ";", " ", 
                    RowBox[{
                    "index1", " ", "=", " ", "\n", "                    ", 
                    "index"}], ";", " ", 
                    RowBox[{"xunit", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"r1", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "ab"}], "]"}], 
                    "]"}]}], " ", "+", " ", 
                    RowBox[{"r2", "*", "\n", "                      ", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "ab"}], "]"}], 
                    "]"}]}]}]}], ";", " ", 
                    RowBox[{"yunit", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"r2", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "ab"}], "]"}], 
                    "]"}]}], " ", "-", " ", "\n", "                     ", 
                    RowBox[{"1.", "*", "r1", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "ab"}], "]"}], 
                    "]"}]}]}]}], ";", " ", 
                    RowBox[{"zunit", " ", "=", " ", 
                    RowBox[{"r3", "*", "\n", "                     ", 
                    RowBox[{"Re", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "ab"}], "]"}], "^", 
                    "2"}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "ab"}], "]"}], "^", 
                    "2"}]}], "]"}]}]}], ";", " ", 
                    RowBox[{"xunit", " ", "=", " ", 
                    RowBox[{"Chop", "[", "xunit", "]"}]}], ";", " ", "\n", 
                    "                   ", 
                    RowBox[{"yunit", " ", "=", " ", 
                    RowBox[{"Chop", "[", "yunit", "]"}]}], ";", " ", 
                    RowBox[{"zunit", " ", "=", " ", 
                    RowBox[{"Chop", "[", "zunit", "]"}]}], ";", " ", "\n", 
                    "                   ", 
                    RowBox[{"magnitude", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"xunit", "^", "2"}], " ", "+", " ", 
                    RowBox[{"yunit", "^", "2"}], " ", "+", " ", 
                    RowBox[{"zunit", "^", "2"}]}], ")"}], "^", 
                    RowBox[{"2", "^", 
                    RowBox[{"(", 
                    RowBox[{"-", "1"}], ")"}]}]}]}], ";", " ", "\n", 
                    "                   ", 
                    RowBox[{"xunit", " ", "=", " ", 
                    RowBox[{"xunit", "/", "magnitude"}]}], ";", " ", 
                    RowBox[{
                    "yunit", " ", "=", " ", "\n", "                    ", 
                    RowBox[{"yunit", "/", "magnitude"}]}], ";", " ", 
                    RowBox[{"zunit", " ", "=", " ", 
                    RowBox[{
                    "zunit", "/", "\n", "                     ", 
                    "magnitude"}]}], ";", " ", 
                    RowBox[{"rx", " ", "=", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "ab"}], "]"}], "]"}],
                     "*", 
                    RowBox[{"(", 
                    RowBox[{
                    "rex", " ", "-", " ", "\n", "                       ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"xb1", " ", "+", " ", 
                    RowBox[{"tb", "*", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "ab"}], "]"}]}]}], 
                    "]"}]}]}], ")"}]}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "ab"}], "]"}], "]"}],
                     "*", 
                    RowBox[{"(", 
                    RowBox[{
                    "rey", " ", "-", " ", "\n", "                       ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"yb1", " ", "+", " ", 
                    RowBox[{"tb", "*", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "ab"}], "]"}]}]}], 
                    "]"}]}]}], ")"}]}]}]}], ";", " ", 
                    RowBox[{"ry", " ", "=", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "1."}], "*", 
                    RowBox[{"(", 
                    RowBox[{
                    "rex", " ", "-", " ", "\n", "                       ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"xb1", " ", "+", " ", 
                    RowBox[{"tb", "*", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "ab"}], "]"}]}]}], 
                    "]"}]}]}], ")"}], "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "ab"}], "]"}], 
                    "]"}]}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "ab"}], "]"}], "]"}],
                     "*", 
                    RowBox[{"(", 
                    RowBox[{
                    "rey", " ", "-", " ", "\n", "                       ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"yb1", " ", "+", " ", 
                    RowBox[{"tb", "*", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "ab"}], "]"}]}]}], 
                    "]"}]}]}], ")"}]}]}]}], ";", " ", 
                    RowBox[{"rz", " ", "=", " ", 
                    RowBox[{"rez", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "ab"}], "]"}], "^", 
                    "2"}], " ", "+", " ", "\n", "                       ", 
                    RowBox[{
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "ab"}], "]"}], "^", 
                    "2"}]}], "]"}]}]}], ";", " ", 
                    RowBox[{"rx", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rx", "]"}]}], ";", " ", 
                    RowBox[{"ry", " ", "=", " ", "\n", "                    ", 
                    RowBox[{"Chop", "[", "ry", "]"}]}], ";", " ", 
                    RowBox[{"rz", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rz", "]"}]}], ";", " ", 
                    RowBox[{"terminatedeflection", " ", "=", " ", "False"}], 
                    ";", " ", "\n", "                   ", 
                    RowBox[{"intersections", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}], "}"}]}], ";", " ", 
                    RowBox[{"intersections", " ", "=", " ", 
                    RowBox[{"Block", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "TempVar", ",", " ", "TempVar1", ",", " ", "TempVar2", 
                    ",", " ", "TempVar3", ",", " ", "RayL", ",", " ", "\n", 
                    "                      ", "SCx", ",", " ", "SCy"}], "}"}],
                     ",", " ", 
                    RowBox[{
                    RowBox[{"TempVar1", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"TempVar2", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"TempVar3", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"TempVar", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}], "}"}]}], ";", " ", 
                    RowBox[{"RayL", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"SCx", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"SCy", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{
                    "TempVar1", " ", "=", " ", "\n", 
                    "                       ", 
                    RowBox[{
                    RowBox[{"rx", "^", "2"}], " ", "+", " ", 
                    RowBox[{"ry", "^", "2"}], " ", "+", " ", 
                    RowBox[{"rz", "^", "2"}]}]}], ";", " ", 
                    RowBox[{"TempVar2", " ", "=", " ", 
                    RowBox[{
                    RowBox[{
                    "rx", "*", "\n", "                         ", "xunit"}], 
                    " ", "+", " ", 
                    RowBox[{"ry", "*", "yunit"}], " ", "+", " ", 
                    RowBox[{"rz", "*", "zunit"}], " ", "-", " ", "\n", 
                    "                        ", 
                    RowBox[{"xunit", "/", "cb2"}]}]}], ";", " ", 
                    RowBox[{"TempVar3", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"-", "TempVar1"}], " ", "+", " ", 
                    RowBox[{"TempVar2", "^", "2"}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"2", "*", "rx"}], ")"}], "/", "cb2"}]}]}], ";", 
                    " ", 
                    RowBox[{"TempVar3", " ", "=", " ", 
                    RowBox[{"Re", "[", "TempVar3", "]"}]}], ";", " ", "\n", 
                    "                      ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"N", "[", 
                    RowBox[{"Chop", "[", "TempVar3", "]"}], "]"}], " ", ">=", 
                    " ", "0."}], ",", " ", 
                    RowBox[{
                    RowBox[{"TempVar3", " ", "=", " ", 
                    RowBox[{"Sqrt", "[", "TempVar3", "]"}]}], ";", " ", 
                    RowBox[{"TempVar", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"RayL", ",", " ", "SCx", ",", " ", "SCy"}], "}"}],
                     " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "TempVar2"}], " ", "-", " ", "TempVar3"}], 
                    ",", " ", 
                    RowBox[{
                    "ry", " ", "-", " ", "\n", 
                    "                              ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"TempVar2", " ", "+", " ", "TempVar3"}], ")"}], 
                    "*", "yunit"}]}], ",", " ", 
                    RowBox[{"rz", " ", "-", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"TempVar2", " ", "+", " ", "TempVar3"}], ")"}], 
                    "*", "zunit"}]}]}], "}"}]}], ";", " ", "\n", 
                    "                           ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"N", "[", 
                    RowBox[{"Chop", "[", "RayL", "]"}], "]"}], " ", ">=", " ",
                     "0."}], " ", "&&", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"SCx", "^", "2"}], " ", "+", " ", 
                    RowBox[{"SCy", "^", "2"}]}], " ", "<=", " ", 
                    RowBox[{"0.25", "*", 
                    RowBox[{
                    RowBox[{"Abs", "[", "apb", "]"}], "^", "2"}]}]}], " ", "&&",
                     " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", 
                    RowBox[{"ry", " ", "+", " ", 
                    RowBox[{"RayL", "*", "yunit"}], " ", "-", " ", "SCx"}], 
                    "]"}], " ", "+", " ", "\n", 
                    "                               ", 
                    RowBox[{"Abs", "[", 
                    RowBox[{"rz", " ", "+", " ", 
                    RowBox[{"RayL", "*", "zunit"}], " ", "-", " ", "SCy"}], 
                    "]"}], " ", "+", " ", 
                    RowBox[{"Abs", "[", 
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"cb2", "^", 
                    RowBox[{"(", 
                    RowBox[{"-", "1"}], ")"}]}]}], " ", "+", " ", "rx", " ", 
                    "+", " ", "\n", "                                 ", 
                    RowBox[{"RayL", "*", "xunit"}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"Sqrt", "[", 
                    RowBox[{
                    RowBox[{"cb2", "^", 
                    RowBox[{"(", 
                    RowBox[{"-", "2"}], ")"}]}], " ", "-", " ", 
                    RowBox[{"SCx", "^", "2"}], " ", "-", " ", 
                    RowBox[{"SCy", "^", "2"}]}], "]"}], "/", 
                    RowBox[{"Sign", "[", "cb2", "]"}]}]}], "]"}]}], " ", "<", 
                    " ", "1.*^-7"}]}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"RayL", ",", " ", "SCx", ",", " ", "SCy"}], "}"}],
                     ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}]}], "]"}]}], ",", " ", "\n", 
                    "                          ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"RayL", ",", " ", "SCx", ",", " ", "SCy"}], "}"}],
                     " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "TempVar2"}], " ", "+", " ", "TempVar3"}], 
                    ",", " ", 
                    RowBox[{"ry", " ", "+", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "TempVar2"}], " ", "+", " ", "TempVar3"}], 
                    ")"}], "*", "yunit"}]}], ",", " ", "\n", 
                    "                             ", 
                    RowBox[{"rz", " ", "+", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "TempVar2"}], " ", "+", " ", "TempVar3"}], 
                    ")"}], "*", "zunit"}]}]}], "}"}]}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"N", "[", 
                    RowBox[{"Chop", "[", "RayL", "]"}], "]"}], " ", ">=", " ",
                     "0."}], " ", "&&", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"SCx", "^", "2"}], " ", "+", " ", 
                    RowBox[{"SCy", "^", "2"}]}], " ", "<=", " ", "\n", 
                    "                              ", 
                    RowBox[{"0.25", "*", 
                    RowBox[{
                    RowBox[{"Abs", "[", "apb", "]"}], "^", "2"}]}]}], " ", "&&",
                     " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", 
                    RowBox[{"ry", " ", "+", " ", 
                    RowBox[{"RayL", "*", "yunit"}], " ", "-", " ", "SCx"}], 
                    "]"}], " ", "+", " ", 
                    RowBox[{"Abs", "[", 
                    RowBox[{
                    "rz", " ", "+", " ", "\n", 
                    "                                 ", 
                    RowBox[{"RayL", "*", "zunit"}], " ", "-", " ", "SCy"}], 
                    "]"}], " ", "+", " ", 
                    RowBox[{"Abs", "[", 
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"cb2", "^", 
                    RowBox[{"(", 
                    RowBox[{"-", "1"}], ")"}]}]}], " ", "+", " ", "rx", " ", 
                    "+", " ", 
                    RowBox[{"RayL", "*", "xunit"}], " ", "+", " ", "\n", 
                    "                                 ", 
                    RowBox[{
                    RowBox[{"Sqrt", "[", 
                    RowBox[{
                    RowBox[{"cb2", "^", 
                    RowBox[{"(", 
                    RowBox[{"-", "2"}], ")"}]}], " ", "-", " ", 
                    RowBox[{"SCx", "^", "2"}], " ", "-", " ", 
                    RowBox[{"SCy", "^", "2"}]}], "]"}], "/", 
                    RowBox[{"Sign", "[", "cb2", "]"}]}]}], "]"}]}], " ", "<", 
                    " ", "1.*^-7"}]}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"RayL", ",", " ", "SCx", ",", " ", "SCy"}], "}"}],
                     ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}]}], "]"}]}]}], "}"}]}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"TempVar", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], " ", "==", " ", 
                    RowBox[{"TempVar", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], ",", " ", "\n", 
                    "                         ", 
                    RowBox[{"{", 
                    RowBox[{"TempVar", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "}"}], ",", " ", 
                    "TempVar"}], "]"}]}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}], "}"}]}], "]"}]}]}], "]"}]}], ";", " ", 
                    RowBox[{"AppendTo", "[", 
                    RowBox[{"intersections", ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}]}], "]"}], ";", " ", 
                    RowBox[{
                    "holeQ", " ", "=", " ", "\n", "                    ", 
                    "False"}], ";", " ", 
                    RowBox[{"If", "[", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"!", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Chop", "[", 
                    RowBox[{"surfaceid", " ", "-", " ", "16548."}], "]"}], 
                    " ", "==", " ", "0."}], " ", "||", " ", 
                    RowBox[{
                    RowBox[{"N", "[", 
                    RowBox[{"Chop", "[", "ray1", "]"}], "]"}], " ", "<", " ", 
                    "0.0001"}]}], ")"}]}], " ", "||", " ", "\n", 
                    "                     ", 
                    RowBox[{"generationnumber", " ", "==", " ", "1."}]}], ",",
                     " ", 
                    RowBox[{"minresonateraylength", " ", "=", " ", "0."}], 
                    ",", " ", 
                    RowBox[{
                    "minresonateraylength", " ", "=", " ", "\n", 
                    "                     ", "0.0001"}]}], "]"}], ";", " ", 
                    RowBox[{"Block", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"RayL", ",", " ", "SCx", ",", " ", "SCy"}], "}"}],
                     ",", " ", 
                    RowBox[{
                    RowBox[{"RayL", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"SCx", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"SCy", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"dummymatrix", " ", "=", " ", 
                    RowBox[{"Union", "[", 
                    RowBox[{"Select", "[", "\n", "                        ", 
                    RowBox[{"intersections", ",", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"RayL", ",", " ", "SCx", ",", " ", "SCy"}], "}"}],
                     " ", "=", " ", "#1"}], ";", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"RayL", ",", " ", "SCx", ",", " ", "SCy"}], "}"}],
                     " ", "==", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}]}], " ", "||", " ", 
                    RowBox[{
                    RowBox[{"N", "[", 
                    RowBox[{"Chop", "[", "RayL", "]"}], "]"}], " ", ">=", " ",
                     "\n", "                            ", 
                    "minresonateraylength"}]}]}], ")"}], " ", "&"}]}], " ", 
                    "]"}], "]"}]}], ";", " ", 
                    RowBox[{
                    "intersections", " ", "=", " ", "dummymatrix"}]}]}], 
                    "]"}], ";", " ", "\n", "                   ", 
                    RowBox[{
                    "unfilteredintersections", " ", "=", " ", 
                    "intersections"}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", "intersections", "]"}], " ", ">", 
                    " ", "1"}], ",", " ", "\n", "                    ", 
                    RowBox[{
                    RowBox[{"dummymatrix", " ", "=", " ", 
                    RowBox[{"Take", "[", 
                    RowBox[{"intersections", ",", " ", 
                    RowBox[{"{", "2", "}"}]}], "]"}]}], ";", " ", 
                    RowBox[{
                    "intersections", " ", "=", " ", "\n", 
                    "                      ", "dummymatrix"}], ";", " ", 
                    "1."}], ",", " ", "1."}], "]"}], ";", " ", 
                    RowBox[{"AppendTo", "[", 
                    RowBox[{"intersectionslist", ",", " ", "intersections"}], 
                    "]"}], ";", " ", "\n", "                   ", 
                    RowBox[{"If", "[", 
                    RowBox[{"holeQ", ",", " ", 
                    RowBox[{"AppendTo", "[", 
                    RowBox[{"holeQlist", ",", " ", "1"}], "]"}], ",", " ", 
                    RowBox[{"AppendTo", "[", 
                    RowBox[{"holeQlist", ",", " ", "0"}], "]"}]}], "]"}]}], 
                    ")"}], ";", " ", "\n", "                  ", 
                    RowBox[{"holeQlist", " ", "=", " ", 
                    RowBox[{"Drop", "[", 
                    RowBox[{"holeQlist", ",", " ", "1"}], "]"}]}], ";", " ", 
                    RowBox[{"Drop", "[", 
                    RowBox[{"intersectionslist", ",", " ", "1"}], "]"}]}]}], 
                    "]"}]}], ")"}], ";", " ", 
                    RowBox[{"Which", "[", "\n", "                ", 
                    RowBox[{
                    RowBox[{"resonatenumber", " ", "==", " ", "1"}], ",", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "\n", 
                    "                   ", "rex", ",", " ", "rey", ",", " ", 
                    "rez", ",", " ", "r1", ",", " ", "r2", ",", " ", "\n", 
                    "                   ", "r3", ",", " ", "r4", ",", " ", 
                    "r5", ",", " ", "r6", ",", " ", "r7", ",", " ", "\n", 
                    "                   ", "r8", ",", " ", "r9", ",", " ", 
                    "wavelength", ",", " ", "intensity", ",", " ", "\n", 
                    "                   ", "intensityscale", ",", " ", "ray1",
                     ",", " ", "index", ",", " ", "opticallength", ",", " ", 
                    "\n", "                   ", "phaseshift", ",", " ", 
                    "componentnumber", ",", " ", "surfacenumber", ",", " ", 
                    "surfaceid", ",", " ", "\n", "                   ", 
                    "ray2", ",", " ", "ray3", ",", " ", "sid", ",", " ", 
                    "frontid", ",", " ", "sno1", ",", " ", "\n", 
                    "                   ", "sno2", ",", " ", "sno3", ",", " ",
                     "sno4", ",", " ", "rayslot", ",", " ", "\n", 
                    "                   ", "oldgenerationnumber", ",", " ", 
                    "intersectionnumber", ",", " ", "pol1", ",", " ", "pol2", 
                    ",", " ", "\n", "                   ", "pol3"}], "}"}], 
                    " ", "=", " ", "#1"}], ";", " ", 
                    RowBox[{"index1", " ", "=", " ", "index"}], ";", " ", 
                    RowBox[{
                    "xunit", " ", "=", " ", "\n", "                  ", 
                    RowBox[{
                    RowBox[{"r1", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "aa"}], "]"}], 
                    "]"}]}], " ", "+", " ", 
                    RowBox[{"r2", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "aa"}], "]"}], 
                    "]"}]}]}]}], ";", " ", "\n", "                 ", 
                    RowBox[{"yunit", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"r2", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "aa"}], "]"}], 
                    "]"}]}], " ", "-", " ", 
                    RowBox[{
                    "1.", "*", "r1", "*", "\n", "                    ", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "aa"}], "]"}], 
                    "]"}]}]}]}], ";", " ", 
                    RowBox[{"zunit", " ", "=", " ", 
                    RowBox[{"r3", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "aa"}], "]"}], "^", 
                    "2"}], " ", "+", " ", "\n", "                     ", 
                    RowBox[{
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "aa"}], "]"}], "^", 
                    "2"}]}], "]"}]}]}], ";", " ", 
                    RowBox[{"xunit", " ", "=", " ", 
                    RowBox[{"Chop", "[", "xunit", "]"}]}], ";", " ", 
                    RowBox[{
                    "yunit", " ", "=", " ", "\n", "                  ", 
                    RowBox[{"Chop", "[", "yunit", "]"}]}], ";", " ", 
                    RowBox[{"zunit", " ", "=", " ", 
                    RowBox[{"Chop", "[", "zunit", "]"}]}], ";", " ", 
                    RowBox[{
                    "magnitude", " ", "=", " ", "\n", "                  ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"xunit", "^", "2"}], " ", "+", " ", 
                    RowBox[{"yunit", "^", "2"}], " ", "+", " ", 
                    RowBox[{"zunit", "^", "2"}]}], ")"}], "^", 
                    RowBox[{"2", "^", 
                    RowBox[{"(", 
                    RowBox[{"-", "1"}], ")"}]}]}]}], ";", " ", 
                    RowBox[{
                    "xunit", " ", "=", " ", "\n", "                  ", 
                    RowBox[{"xunit", "/", "magnitude"}]}], ";", " ", 
                    RowBox[{"yunit", " ", "=", " ", 
                    RowBox[{
                    "yunit", "/", "\n", "                   ", 
                    "magnitude"}]}], ";", " ", 
                    RowBox[{"zunit", " ", "=", " ", 
                    RowBox[{"zunit", "/", "magnitude"}]}], ";", " ", "\n", 
                    "                 ", 
                    RowBox[{"rx", " ", "=", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"rex", " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"Re", "[", "xa1", "]"}]}]}], ")"}], "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "aa"}], "]"}], 
                    "]"}]}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"rey", " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"Re", "[", "ya1", "]"}]}]}], ")"}], "*", "\n", 
                    "                    ", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "aa"}], "]"}], 
                    "]"}]}]}]}], ";", " ", 
                    RowBox[{"ry", " ", "=", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"rey", " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"Re", "[", "ya1", "]"}]}]}], ")"}], "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "aa"}], "]"}], 
                    "]"}]}], " ", "-", " ", "\n", "                   ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"(", 
                    RowBox[{"rex", " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"Re", "[", "xa1", "]"}]}]}], ")"}], "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "aa"}], "]"}], 
                    "]"}]}]}]}], ";", " ", 
                    RowBox[{"rz", " ", "=", " ", 
                    RowBox[{"rez", "*", "\n", "                   ", 
                    RowBox[{"Re", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "aa"}], "]"}], "^", 
                    "2"}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "aa"}], "]"}], "^", 
                    "2"}]}], "]"}]}]}], ";", " ", 
                    RowBox[{"rx", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rx", "]"}]}], ";", " ", "\n", 
                    "                 ", 
                    RowBox[{"ry", " ", "=", " ", 
                    RowBox[{"Chop", "[", "ry", "]"}]}], ";", " ", 
                    RowBox[{"rz", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rz", "]"}]}], ";", " ", "\n", 
                    "                 ", 
                    RowBox[{"terminatedeflection", " ", "=", " ", "False"}], 
                    ";", " ", 
                    RowBox[{"intersections", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}], "}"}]}], ";", " ", 
                    RowBox[{
                    "intersections", " ", "=", " ", "\n", 
                    "                  ", "resonateintersections"}], ";", " ", 
                    RowBox[{"holeQ", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"holeQlist", "[", 
                    RowBox[{
                    "[", "\n", "                    ", "resonatenumber", 
                    "]"}], "]"}], " ", "==", " ", "1"}]}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "newcomponentnumber", ",", " ", "newsurfacenumber", ",", 
                    " ", "\n", "                   ", "newsurfaceid"}], "}"}],
                     " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"1.", ",", " ", "1.", ",", " ", "16519."}], 
                    "}"}]}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"componentnumber", ",", " ", "surfacenumber", ",",
                     " ", "\n", "                   ", "surfaceid"}], "}"}], 
                    " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"1.", ",", " ", "1.", ",", " ", "16519."}], 
                    "}"}]}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"ray1", ",", " ", "ray2", ",", " ", "ray3"}], 
                    "}"}], " ", "=", " ", "\n", "                  ", 
                    RowBox[{"intersections", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], ";", " ", 
                    RowBox[{"rsx", " ", "=", " ", "rex"}], ";", " ", 
                    RowBox[{
                    "rsy", " ", "=", " ", "\n", "                  ", "rey"}],
                     ";", " ", 
                    RowBox[{"rsz", " ", "=", " ", "rez"}], ";", " ", 
                    RowBox[{"rxhlp", " ", "=", " ", 
                    RowBox[{
                    "rx", " ", "+", " ", "\n", "                   ", 
                    RowBox[{"ray1", "*", "xunit"}]}]}], ";", " ", 
                    RowBox[{"ryhlp", " ", "=", " ", 
                    RowBox[{"ry", " ", "+", " ", 
                    RowBox[{
                    "ray1", "*", "\n", "                    ", "yunit"}]}]}], 
                    ";", " ", 
                    RowBox[{"rzhlp", " ", "=", " ", 
                    RowBox[{"rz", " ", "+", " ", 
                    RowBox[{"ray1", "*", "zunit"}]}]}], ";", " ", "\n", 
                    "                 ", 
                    RowBox[{"rex", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"Re", "[", "xa1", "]"}], " ", "+", " ", 
                    RowBox[{"rxhlp", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "aa"}], "]"}], 
                    "]"}]}], " ", "-", " ", 
                    RowBox[{
                    "1.", "*", "ryhlp", "*", "\n", "                    ", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "aa"}], "]"}], 
                    "]"}]}]}]}], ";", " ", 
                    RowBox[{"rey", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"Re", "[", "ya1", "]"}], " ", "+", " ", 
                    RowBox[{"ryhlp", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "aa"}], "]"}], 
                    "]"}]}], " ", "+", " ", "\n", "                   ", 
                    RowBox[{"rxhlp", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "aa"}], "]"}], 
                    "]"}]}]}]}], ";", " ", 
                    RowBox[{"rez", " ", "=", " ", 
                    RowBox[{"rzhlp", "*", "\n", "                   ", 
                    RowBox[{"Re", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "aa"}], "]"}], "^", 
                    "2"}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "aa"}], "]"}], "^", 
                    "2"}]}], "]"}]}]}], ";", " ", 
                    RowBox[{"rex", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rex", "]"}]}], ";", " ", "\n", 
                    "                 ", 
                    RowBox[{"rey", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rey", "]"}]}], ";", " ", 
                    RowBox[{"rez", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rez", "]"}]}], ";", " ", "\n", 
                    "                 ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"rex", " ", "==", " ", "0"}], " ", "&&", " ", 
                    RowBox[{"rey", " ", "==", " ", "0"}], " ", "&&", " ", 
                    RowBox[{"rez", " ", "==", " ", "0"}]}], ",", " ", 
                    RowBox[{
                    RowBox[{
                    "rex", " ", "=", " ", "\n", "                    ", 
                    RowBox[{"rxhlp", " ", "+", " ", 
                    RowBox[{"Re", "[", "xa1", "]"}]}]}], ";", " ", 
                    RowBox[{"rey", " ", "=", " ", 
                    RowBox[{"ryhlp", " ", "+", " ", 
                    RowBox[{"Re", "[", "ya1", "]"}]}]}], ";", " ", 
                    RowBox[{
                    "rez", " ", "=", " ", "\n", "                    ", 
                    "rzhlp"}]}], ",", " ", "rex"}], "]"}], ";", " ", 
                    RowBox[{"intersectionnumber", " ", "=", " ", 
                    RowBox[{
                    "intersectionnumber", " ", "+", " ", "\n", 
                    "                   ", "1."}]}], ";", " ", 
                    RowBox[{"opticallength", " ", "=", " ", 
                    RowBox[{"opticallength", " ", "+", " ", 
                    RowBox[{"ray1", "*", "index1"}]}]}], ";", " ", "\n", 
                    "                 ", 
                    RowBox[{"completedray", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "\n", "                   ", "rey", ",", " ", 
                    "rez", ",", " ", "r1", ",", " ", "r2", ",", " ", "r3", 
                    ",", " ", "\n", "                   ", "r4", ",", " ", 
                    "r5", ",", " ", "r6", ",", " ", "r7", ",", " ", "r8", ",",
                     " ", "\n", "                   ", "r9", ",", " ", 
                    "wavelength", ",", " ", "intensity", ",", " ", 
                    "intensityscale", ",", " ", "\n", "                   ", 
                    "ray1", ",", " ", "index", ",", " ", "opticallength", ",",
                     " ", "phaseshift", ",", " ", "\n", "                   ",
                     "componentnumber", ",", " ", "surfacenumber", ",", " ", 
                    "surfaceid", ",", " ", "ray2", ",", " ", "\n", 
                    "                   ", "ray3", ",", " ", "sid", ",", " ", 
                    "frontid", ",", " ", "sno1", ",", " ", "sno2", ",", " ", 
                    "\n", "                   ", "sno3", ",", " ", "sno4", 
                    ",", " ", "rayslot", ",", " ", "generationnumber", ",", 
                    " ", "\n", "                   ", "intersectionnumber", 
                    ",", " ", "pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}]}], ";", " ", "\n", "                 ", 
                    RowBox[{"reportedrayspresent", " ", "=", " ", "True"}], 
                    ";", " ", 
                    RowBox[{"intersectionspresent", " ", "=", " ", "True"}], 
                    ";", " ", 
                    RowBox[{
                    "deflectedrayspresent", " ", "=", " ", "\n", 
                    "                  ", "True"}], ";", " ", 
                    RowBox[{
                    "localdummyoutrayspresent", " ", "=", " ", "True"}], ";", 
                    " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    "surfnorm", " ", "=", " ", "\n", "                   ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"1.", ",", " ", 
                    RowBox[{
                    RowBox[{"-", "1."}], "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"ray2", "/", 
                    RowBox[{"Sign", "[", "ca1", "]"}]}], "/", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"ca1", "^", 
                    RowBox[{"(", 
                    RowBox[{"-", "2"}], ")"}]}], " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"ray2", "^", "2"}]}], " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"ray3", "^", "2"}]}]}], ")"}], "^", "0.5"}]}], 
                    ")"}]}], ",", " ", "\n", "                       ", 
                    RowBox[{
                    RowBox[{"-", "1."}], "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"ray3", "/", 
                    RowBox[{"Sign", "[", "ca1", "]"}]}], "/", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"ca1", "^", 
                    RowBox[{"(", 
                    RowBox[{"-", "2"}], ")"}]}], " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"ray2", "^", "2"}]}], " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"ray3", "^", "2"}]}]}], ")"}], "^", "0.5"}]}], 
                    ")"}]}]}], "}"}], ",", " ", "\n", 
                    "                      ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"ray2", "/", 
                    RowBox[{"Sign", "[", "ca1", "]"}]}], "/", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"ca1", "^", 
                    RowBox[{"(", 
                    RowBox[{"-", "2"}], ")"}]}], " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"ray2", "^", "2"}]}], " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"ray3", "^", "2"}]}]}], ")"}], "^", "0.5"}]}], 
                    ",", " ", "1.", ",", " ", "0."}], "}"}], ",", " ", "\n", 
                    "                      ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"ray3", "/", 
                    RowBox[{"Sign", "[", "ca1", "]"}]}], "/", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"ca1", "^", 
                    RowBox[{"(", 
                    RowBox[{"-", "2"}], ")"}]}], " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"ray2", "^", "2"}]}], " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"ray3", "^", "2"}]}]}], ")"}], "^", "0.5"}]}], 
                    ",", " ", "0.", ",", " ", "1."}], "}"}]}], "}"}], 
                    "]"}]}]}], ";", " ", "\n", "                  ", 
                    RowBox[{"dummymatrix", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "aa"}], "]"}], "]"}],
                     "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "aa"}], "]"}], "^", 
                    "2"}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "aa"}], "]"}], "^", 
                    "2"}]}], "]"}]}], ")"}], "/", "\n", 
                    "                         ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "aa"}], "]"}], "]"}],
                     "^", "2"}], "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "aa"}], "]"}], "^", 
                    "2"}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "aa"}], "]"}], "^", 
                    "2"}]}], "]"}]}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "aa"}], "]"}], "]"}],
                     "^", "2"}], "*", "\n", "                           ", 
                    RowBox[{"Re", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "aa"}], "]"}], "^", 
                    "2"}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "aa"}], "]"}], "^", 
                    "2"}]}], "]"}]}]}], ")"}]}], ",", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1."}], "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "aa"}], "]"}], "]"}],
                     "*", "\n", "                          ", 
                    RowBox[{"Re", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "aa"}], "]"}], "^", 
                    "2"}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "aa"}], "]"}], "^", 
                    "2"}]}], "]"}]}], ")"}], "/", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "aa"}], "]"}], "]"}],
                     "^", "2"}], "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "aa"}], "]"}], "^", 
                    "\n", "                              ", "2"}], " ", "+", 
                    " ", 
                    RowBox[{
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "aa"}], "]"}], "^", 
                    "2"}]}], "]"}]}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "aa"}], "]"}], "]"}],
                     "^", "2"}], "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "aa"}], "]"}], "^", 
                    "2"}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"Sin", "[", 
                    RowBox[{
                    "0.017453292519943295", "*", "\n", 
                    "                                ", "aa"}], "]"}], "^", 
                    "2"}]}], "]"}]}]}], ")"}]}], ",", " ", "0."}], "}"}], ",",
                     " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "aa"}], "]"}], "]"}],
                     "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "aa"}], "]"}], "^", 
                    "2"}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "aa"}], "]"}], "^", 
                    "2"}]}], "]"}]}], ")"}], "/", "\n", 
                    "                         ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "aa"}], "]"}], "]"}],
                     "^", "2"}], "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "aa"}], "]"}], "^", 
                    "2"}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "aa"}], "]"}], "^", 
                    "2"}]}], "]"}]}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "aa"}], "]"}], "]"}],
                     "^", "2"}], "*", "\n", "                           ", 
                    RowBox[{"Re", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "aa"}], "]"}], "^", 
                    "2"}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "aa"}], "]"}], "^", 
                    "2"}]}], "]"}]}]}], ")"}]}], ",", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "aa"}], "]"}], "]"}],
                     "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "aa"}], "]"}], "^", 
                    "\n", "                             ", "2"}], " ", "+", 
                    " ", 
                    RowBox[{
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "aa"}], "]"}], "^", 
                    "2"}]}], "]"}]}], ")"}], "/", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "aa"}], "]"}], "]"}],
                     "^", "2"}], "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "aa"}], "]"}], "^", 
                    "2"}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"Sin", "[", 
                    RowBox[{
                    "0.017453292519943295", "*", "\n", 
                    "                                ", "aa"}], "]"}], "^", 
                    "2"}]}], "]"}]}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "aa"}], "]"}], "]"}],
                     "^", "2"}], "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "aa"}], "]"}], "^", 
                    "2"}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "aa"}], "]"}], "^", 
                    "2"}]}], "]"}]}]}], ")"}]}], ",", " ", "0."}], "}"}], ",",
                     " ", "\n", "                       ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "0.", ",", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "aa"}], "]"}], "]"}],
                     "^", "2"}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "aa"}], "]"}], "]"}],
                     "^", "2"}]}], ")"}], "/", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "aa"}], "]"}], "]"}],
                     "^", "2"}], "*", "\n", "                           ", 
                    RowBox[{"Re", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "aa"}], "]"}], "^", 
                    "2"}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "aa"}], "]"}], "^", 
                    "2"}]}], "]"}]}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "aa"}], "]"}], "]"}],
                     "^", "2"}], "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "aa"}], "]"}], "^", 
                    "\n", "                              ", "2"}], " ", "+", 
                    " ", 
                    RowBox[{
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "aa"}], "]"}], "^", 
                    "2"}]}], "]"}]}]}], ")"}]}]}], "}"}]}], "}"}], " ", ".", 
                    " ", "#1"}], " ", "&"}], " ", ")"}], " ", "/@", " ", 
                    "surfnorm"}]}], ";", " ", 
                    RowBox[{
                    "surfnorm", " ", "=", " ", "\n", "                   ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"#1", "/", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"#1", " ", ".", " ", "#1"}], "]"}]}], " ", "&"}], 
                    " ", ")"}], " ", "/@", " ", "dummymatrix"}]}], ";", " ", 
                    RowBox[{"surfacerotationmatrix", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "aa"}], "]"}], "]"}],
                     ",", " ", "\n", "                     ", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "aa"}], "]"}], "]"}],
                     ",", " ", "0."}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "1."}], "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "aa"}], "]"}], 
                    "]"}]}], ",", " ", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "aa"}], "]"}], "]"}],
                     ",", " ", "0."}], "}"}], ",", " ", "\n", 
                    "                    ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "0.", ",", " ", 
                    RowBox[{"Re", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "aa"}], "]"}], "^", 
                    "2"}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "aa"}], "]"}], "^", 
                    "2"}]}], "]"}]}], "}"}]}], "}"}]}], ";", " ", 
                    RowBox[{
                    "surfacetranslationvector", " ", "=", " ", "\n", 
                    "                   ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Re", "[", "xa1", "]"}], ",", " ", 
                    RowBox[{"Re", "[", "ya1", "]"}], ",", " ", "0."}], 
                    "}"}]}], ";", " ", 
                    RowBox[{"activeregion", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"completedray", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "\n", "                    ", "rsy", ",",
                     " ", "rsz", ",", " ", "rex", ",", " ", "rey", ",", " ", 
                    "rez", ",", " ", "\n", "                    ", "r1", ",", 
                    " ", "r2", ",", " ", "r3", ",", " ", "r4", ",", " ", "r5",
                     ",", " ", "\n", "                    ", "r6", ",", " ", 
                    "r7", ",", " ", "r8", ",", " ", "r9", ",", " ", 
                    "wavelength", ",", " ", "\n", "                    ", 
                    "intensity", ",", " ", "intensityscale", ",", " ", "ray1",
                     ",", " ", "index", ",", " ", "\n", 
                    "                    ", "opticallength", ",", " ", 
                    "phaseshift", ",", " ", "componentnumber", ",", " ", "\n",
                     "                    ", "surfacenumber", ",", " ", 
                    "surfaceid", ",", " ", "ray2", ",", " ", "ray3", ",", " ",
                     "\n", "                    ", "sid", ",", " ", "frontid",
                     ",", " ", "sno1", ",", " ", "sno2", ",", " ", "sno3", 
                    ",", " ", "\n", "                    ", "sno4", ",", " ", 
                    "rayslot", ",", " ", "generationnumber", ",", " ", 
                    "intersectionnumber", ",", " ", "\n", 
                    "                    ", "pol1", ",", " ", "pol2", ",", 
                    " ", "pol3"}], "}"}]}], ";", " ", 
                    RowBox[{
                    "componentnumber", " ", "=", " ", "\n", 
                    "                   ", "newcomponentnumber"}], ";", " ", 
                    RowBox[{
                    "surfacenumber", " ", "=", " ", "newsurfacenumber"}], ";",
                     " ", "\n", "                  ", 
                    RowBox[{"surfaceid", " ", "=", " ", "newsurfaceid"}], ";",
                     " ", 
                    RowBox[{"originalray", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "\n", "                    ", "rsy", ",",
                     " ", "rsz", ",", " ", "rex", ",", " ", "rey", ",", " ", 
                    "rez", ",", " ", "\n", "                    ", "r1", ",", 
                    " ", "r2", ",", " ", "r3", ",", " ", "r4", ",", " ", "r5",
                     ",", " ", "\n", "                    ", "r6", ",", " ", 
                    "r7", ",", " ", "r8", ",", " ", "r9", ",", " ", 
                    "wavelength", ",", " ", "\n", "                    ", 
                    "intensity", ",", " ", "intensityscale", ",", " ", "ray1",
                     ",", " ", "index", ",", " ", "\n", 
                    "                    ", "opticallength", ",", " ", 
                    "phaseshift", ",", " ", "componentnumber", ",", " ", "\n",
                     "                    ", "surfacenumber", ",", " ", 
                    "surfaceid", ",", " ", "ray2", ",", " ", "ray3", ",", " ",
                     "\n", "                    ", "sid", ",", " ", "frontid",
                     ",", " ", "sno1", ",", " ", "sno2", ",", " ", "sno3", 
                    ",", " ", "\n", "                    ", "sno4", ",", " ", 
                    "rayslot", ",", " ", "generationnumber", ",", " ", 
                    "intersectionnumber", ",", " ", "\n", 
                    "                    ", "pol1", ",", " ", "pol2", ",", 
                    " ", "pol3"}], "}"}]}], ";", " ", 
                    RowBox[{
                    "ZAxis", " ", "=", " ", "\n", "                   ", 
                    RowBox[{
                    RowBox[{"First", "[", "surfnorm", "]"}], "*", 
                    RowBox[{"Sign", "[", 
                    RowBox[{
                    RowBox[{"First", "[", "surfnorm", "]"}], " ", ".", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "r1", ",", " ", "r2", ",", " ", "\n", 
                    "                       ", "r3"}], "}"}]}], "]"}]}]}], 
                    ";", " ", 
                    RowBox[{"raytiltz", " ", "=", " ", 
                    RowBox[{"ZAxis", " ", ".", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "r1", ",", " ", "\n", "                     ", "r2", ",", 
                    " ", "r3"}], "}"}]}]}], ";", " ", 
                    RowBox[{"raytiltx", " ", "=", " ", 
                    RowBox[{"1", " ", "-", " ", 
                    RowBox[{"raytiltz", "^", "2"}]}]}], ";", " ", "\n", 
                    "                  ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    "raytiltx", " ", "<", " ", "2.220446049250313*^-16"}], 
                    ",", " ", 
                    RowBox[{"raytiltx", " ", "=", " ", "0."}], ",", " ", 
                    RowBox[{
                    "raytiltx", " ", "=", " ", "\n", "                    ", 
                    RowBox[{"Sqrt", "[", "raytiltx", "]"}]}]}], "]"}], ";", 
                    " ", 
                    RowBox[{"XAxis", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "r1", ",", " ", "r2", ",", " ", "\n", 
                    "                     ", "r3"}], "}"}], " ", "-", " ", 
                    RowBox[{"ZAxis", "*", "raytiltz"}]}]}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", "raytiltx", "]"}], " ", "<", " ", 
                    "1.*^-7"}], ",", " ", "\n", "                   ", 
                    RowBox[{"XAxis", " ", "=", " ", 
                    RowBox[{"surfnorm", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], ",", " ", 
                    RowBox[{"XAxis", " ", "=", " ", 
                    RowBox[{
                    "XAxis", "/", "\n", "                     ", 
                    "raytiltx"}]}]}], "]"}], ";", " ", 
                    RowBox[{"YAxis", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"ZAxis", "[", 
                    RowBox[{"[", "3", "]"}], "]"}], "*", 
                    RowBox[{"XAxis", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], ")"}]}], " ", "+", " ", 
                    "\n", "                     ", 
                    RowBox[{
                    RowBox[{"ZAxis", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "*", 
                    RowBox[{"XAxis", "[", 
                    RowBox[{"[", "3", "]"}], "]"}]}]}], ",", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"ZAxis", "[", 
                    RowBox[{"[", "3", "]"}], "]"}], "*", 
                    RowBox[{"XAxis", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], " ", "-", " ", "\n", 
                    "                     ", 
                    RowBox[{
                    RowBox[{"ZAxis", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "*", 
                    RowBox[{"XAxis", "[", 
                    RowBox[{"[", "3", "]"}], "]"}]}]}], ",", " ", 
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"ZAxis", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "*", 
                    RowBox[{"XAxis", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], ")"}]}], " ", "+", " ", 
                    "\n", "                     ", 
                    RowBox[{
                    RowBox[{"ZAxis", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "*", 
                    RowBox[{"XAxis", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}]}]}], "}"}]}], ";", " ", 
                    RowBox[{"YAxis", " ", "=", " ", 
                    RowBox[{"YAxis", "/", "\n", "                    ", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"YAxis", " ", ".", " ", "YAxis"}], "]"}]}]}], ";",
                     " ", 
                    RowBox[{"PAxis", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"ZAxis", "*", "\n", "                     ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    " ", ".", " ", "XAxis"}]}], " ", "-", " ", 
                    RowBox[{"XAxis", "*", "\n", "                     ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    " ", ".", " ", "ZAxis"}]}]}]}], ";", " ", 
                    RowBox[{
                    "PAxis", " ", "=", " ", "\n", "                   ", 
                    RowBox[{"PAxis", "/", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"PAxis", " ", ".", " ", "PAxis"}], "]"}]}]}], ";",
                     " ", 
                    RowBox[{
                    "normalizedpolarization", " ", "=", " ", "\n", 
                    "                   ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], "[", 
                    RowBox[{"[", 
                    RowBox[{"{", 
                    RowBox[{"1", ",", " ", "2"}], "}"}], "]"}], "]"}]}], ";", 
                    " ", 
                    RowBox[{
                    "normalizedpolarization", " ", "=", " ", "\n", 
                    "                   ", 
                    RowBox[{"normalizedpolarization", "/", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{
                    "normalizedpolarization", " ", ".", " ", 
                    "normalizedpolarization"}], "]"}]}]}], ";", " ", "\n", 
                    "                  ", 
                    RowBox[{"allcreatedamplitudes", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"0.", "*", "I"}], ",", " ", 
                    RowBox[{"0.", "*", "I"}], ",", " ", 
                    RowBox[{"0.", "*", "I"}]}], "}"}], "}"}]}], ";", " ", 
                    RowBox[{"amplitude", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"Sqrt", "[", "intensity", "]"}], "*", "\n", 
                    "                    ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"normalizedpolarization", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "*", 
                    RowBox[{"{", 
                    RowBox[{"r4", ",", " ", "r5", ",", " ", "r6"}], "}"}]}], 
                    " ", "+", " ", "\n", "                     ", 
                    RowBox[{
                    RowBox[{"normalizedpolarization", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "*", 
                    RowBox[{"{", 
                    RowBox[{"r7", ",", " ", "r8", ",", " ", "r9"}], "}"}], 
                    "*", "\n", "                      ", 
                    RowBox[{"Exp", "[", 
                    RowBox[{"I", "*", "pol3", "*", "0.017453292519943295"}], 
                    "]"}]}]}], ")"}]}]}], ";", " ", 
                    RowBox[{"perpendicularamplitude", " ", "=", " ", 
                    RowBox[{
                    "amplitude", " ", ".", " ", "\n", "                    ", 
                    "YAxis"}]}], ";", " ", 
                    RowBox[{"parallelamplitude", " ", "=", " ", 
                    RowBox[{"amplitude", " ", ".", " ", "PAxis"}]}], ";", " ",
                     "\n", "                  ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"activeregion", "*", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"surfacerotationmatrix", " ", ".", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "r1", ",", " ", "r2", ",", " ", "\n", 
                    "                        ", "r3"}], "}"}]}], ")"}], "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], " ", ">", " ", "0"}], 
                    ",", " ", 
                    RowBox[{
                    RowBox[{"index2", " ", "=", " ", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"2.2718929", " ", "-", " ", 
                    RowBox[{"0.010108077", "*", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", "\n", 
                    "                       ", 
                    RowBox[{"0.010592509", "/", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", 
                    RowBox[{"0.00020816965", "/", 
                    RowBox[{"wavelength", "^", "4"}]}], " ", "-", " ", 
                    RowBox[{
                    "7.6472538*^-6", "/", "\n", "                        ", 
                    RowBox[{"wavelength", "^", "6"}]}], " ", "+", " ", 
                    RowBox[{"4.9240991*^-7", "/", 
                    RowBox[{"wavelength", "^", "8"}]}]}], "]"}]}], ";", " ", 
                    RowBox[{
                    "index1", " ", "=", " ", "\n", "                     ", 
                    "index"}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", 
                    RowBox[{"index2", " ", "-", " ", "index1"}], "]"}], " ", 
                    "<", " ", "0.01"}], ",", " ", 
                    RowBox[{
                    RowBox[{
                    "alternateindex", " ", "=", " ", "\n", 
                    "                       ", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"1.0005281111748805", " ", "-", " ", 
                    RowBox[{"2.364805676582992*^-10", "*", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", 
                    RowBox[{"2.9781670902982902*^-6", "/", 
                    RowBox[{
                    "wavelength", "^", "\n", "                           ", 
                    "2"}]}], " ", "+", " ", 
                    RowBox[{"2.6004099469477187*^-8", "/", 
                    RowBox[{"wavelength", "^", "4"}]}], " ", "+", " ", 
                    RowBox[{"3.7787839314048715*^-10", "/", 
                    RowBox[{"wavelength", "^", "6"}]}], " ", "+", " ", "\n", 
                    "                         ", 
                    RowBox[{"2.830549017940716*^-12", "/", 
                    RowBox[{"wavelength", "^", "8"}]}]}], "]"}]}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", 
                    RowBox[{"alternateindex", " ", "-", " ", "index1"}], 
                    "]"}], " ", ">", " ", "\n", "                        ", 
                    RowBox[{"Abs", "[", 
                    RowBox[{"index2", " ", "-", " ", "index1"}], "]"}]}], ",",
                     " ", 
                    RowBox[{
                    RowBox[{"index1", " ", "=", " ", "index2"}], ";", " ", 
                    "\n", "                        ", 
                    RowBox[{"index2", " ", "=", " ", "alternateindex"}]}], 
                    ",", " ", 
                    RowBox[{"index1", " ", "=", " ", "alternateindex"}]}], 
                    "]"}]}], ",", " ", "\n", "                     ", 
                    RowBox[{"index1", " ", "=", " ", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"1.0005281111748805", " ", "-", " ", 
                    RowBox[{"2.364805676582992*^-10", "*", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", 
                    RowBox[{"2.9781670902982902*^-6", "/", "\n", 
                    "                         ", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", 
                    RowBox[{"2.6004099469477187*^-8", "/", 
                    RowBox[{"wavelength", "^", "4"}]}], " ", "+", " ", 
                    RowBox[{
                    "3.7787839314048715*^-10", "/", "\n", 
                    "                         ", 
                    RowBox[{"wavelength", "^", "6"}]}], " ", "+", " ", 
                    RowBox[{"2.830549017940716*^-12", "/", 
                    RowBox[{"wavelength", "^", "8"}]}]}], "]"}]}]}], "]"}]}], 
                    ",", " ", 
                    RowBox[{
                    RowBox[{
                    "index2", " ", "=", " ", "\n", "                     ", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"1.0005281111748805", " ", "-", " ", 
                    RowBox[{"2.364805676582992*^-10", "*", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", 
                    RowBox[{"2.9781670902982902*^-6", "/", 
                    RowBox[{
                    "wavelength", "^", "\n", "                         ", 
                    "2"}]}], " ", "+", " ", 
                    RowBox[{"2.6004099469477187*^-8", "/", 
                    RowBox[{"wavelength", "^", "4"}]}], " ", "+", " ", 
                    RowBox[{"3.7787839314048715*^-10", "/", 
                    RowBox[{"wavelength", "^", "6"}]}], " ", "+", " ", "\n", 
                    "                       ", 
                    RowBox[{"2.830549017940716*^-12", "/", 
                    RowBox[{"wavelength", "^", "8"}]}]}], "]"}]}], ";", " ", 
                    RowBox[{"index1", " ", "=", " ", "index"}], ";", " ", 
                    "\n", "                    ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", 
                    RowBox[{"index2", " ", "-", " ", "index1"}], "]"}], " ", 
                    "<", " ", "0.01"}], ",", " ", 
                    RowBox[{
                    RowBox[{"alternateindex", " ", "=", " ", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{
                    "2.2718929", " ", "-", " ", "\n", 
                    "                         ", 
                    RowBox[{"0.010108077", "*", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", 
                    RowBox[{"0.010592509", "/", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", 
                    RowBox[{
                    "0.00020816965", "/", "\n", "                          ", 
                    
                    RowBox[{"wavelength", "^", "4"}]}], " ", "-", " ", 
                    RowBox[{"7.6472538*^-6", "/", 
                    RowBox[{"wavelength", "^", "6"}]}], " ", "+", " ", 
                    RowBox[{"4.9240991*^-7", "/", 
                    RowBox[{"wavelength", "^", "8"}]}]}], "]"}]}], ";", " ", 
                    "\n", "                      ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", 
                    RowBox[{"alternateindex", " ", "-", " ", "index1"}], 
                    "]"}], " ", ">", " ", 
                    RowBox[{"Abs", "[", 
                    RowBox[{"index2", " ", "-", " ", "index1"}], "]"}]}], ",",
                     " ", "\n", "                       ", 
                    RowBox[{
                    RowBox[{"index1", " ", "=", " ", "index2"}], ";", " ", 
                    RowBox[{"index2", " ", "=", " ", "alternateindex"}]}], 
                    ",", " ", "\n", "                       ", 
                    RowBox[{"index1", " ", "=", " ", "alternateindex"}]}], 
                    "]"}]}], ",", " ", 
                    RowBox[{"index1", " ", "=", " ", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"2.2718929", " ", "-", " ", 
                    RowBox[{
                    "0.010108077", "*", "\n", "                         ", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", 
                    RowBox[{"0.010592509", "/", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", 
                    RowBox[{"0.00020816965", "/", 
                    RowBox[{"wavelength", "^", "4"}]}], " ", "-", " ", "\n", 
                    "                        ", 
                    RowBox[{"7.6472538*^-6", "/", 
                    RowBox[{"wavelength", "^", "6"}]}], " ", "+", " ", 
                    RowBox[{"4.9240991*^-7", "/", 
                    RowBox[{"wavelength", "^", "8"}]}]}], "]"}]}]}], 
                    "]"}]}]}], "]"}], ";", " ", 
                    RowBox[{"n12", " ", "=", " ", "\n", "                   ", 
                    RowBox[{"index1", "/", "index2"}]}], ";", " ", 
                    RowBox[{"index", " ", "=", " ", "index2"}], ";", " ", 
                    "\n", "                  ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"1", " ", "-", " ", 
                    RowBox[{
                    RowBox[{"n12", "^", "2"}], "*", 
                    RowBox[{"raytiltx", "^", "2"}]}]}], " ", ">=", " ", 
                    "0."}], ",", " ", 
                    RowBox[{
                    RowBox[{"dummyvector", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"n12", "*", "\n", "                       ", 
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}]}], 
                    " ", "+", " ", 
                    RowBox[{"ZAxis", "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"(", 
                    RowBox[{
                    "n12", "*", "\n", "                          ", 
                    "raytiltz"}], ")"}]}], " ", "+", " ", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"1", " ", "-", " ", 
                    RowBox[{
                    RowBox[{"n12", "^", "2"}], "*", 
                    RowBox[{"raytiltx", "^", "2"}]}]}], "]"}]}], ")"}]}]}]}], 
                    ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "r1", ",", " ", "\n", "                      ", "r2", ",",
                     " ", "r3"}], "}"}], " ", "=", " ", "dummyvector"}], ";", 
                    " ", "1."}], ",", " ", "\n", "                   ", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    " ", ".", " ", 
                    RowBox[{"surfnorm", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], " ", ">", " ", "0"}], 
                    ",", " ", "\n", "                     ", 
                    RowBox[{"phaseshift", " ", "=", " ", 
                    RowBox[{"phaseshift", " ", "+", " ", "0.5"}]}], ",", " ", 
                    "1."}], "]"}], ";", " ", 
                    RowBox[{"index2", " ", "=", " ", "index1"}], ";", " ", 
                    "\n", "                    ", 
                    RowBox[{"index", " ", "=", " ", "index1"}], ";", " ", 
                    RowBox[{"dummyvector", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "r1", ",", " ", "\n", "                       ", "r2", 
                    ",", " ", "r3"}], "}"}], " ", "-", " ", 
                    RowBox[{"2", "*", "ZAxis", "*", 
                    RowBox[{"ZAxis", " ", ".", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "r1", ",", " ", "\n", "                         ", "r2", 
                    ",", " ", "r3"}], "}"}]}]}]}]}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    " ", "=", " ", "\n", "                     ", 
                    "dummyvector"}], ";", " ", 
                    RowBox[{"dummyvector", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "pol1", ",", " ", "pol2", ",", " ", "\n", 
                    "                       ", "pol3"}], "}"}], " ", "+", " ", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", " ", "0", ",", " ", 
                    RowBox[{"-", "180"}]}], "}"}]}]}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], " ", "=", " ", "\n", "                     ", 
                    "dummyvector"}], ";", " ", "1."}]}], "]"}], ";", " ", 
                    RowBox[{"allcreatedrays", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "\n", 
                    "                     ", "rsz", ",", " ", "rex", ",", " ",
                     "rey", ",", " ", "rez", ",", " ", "r1", ",", " ", "\n", 
                    "                     ", "r2", ",", " ", "r3", ",", " ", 
                    "r4", ",", " ", "r5", ",", " ", "r6", ",", " ", "\n", 
                    "                     ", "r7", ",", " ", "r8", ",", " ", 
                    "r9", ",", " ", "wavelength", ",", " ", "intensity", ",", 
                    " ", "\n", "                     ", "intensityscale", ",",
                     " ", "ray1", ",", " ", "index", ",", " ", 
                    "opticallength", ",", " ", "\n", "                     ", 
                    "phaseshift", ",", " ", "componentnumber", ",", " ", 
                    "surfacenumber", ",", " ", "surfaceid", ",", " ", "\n", 
                    "                     ", "ray2", ",", " ", "ray3", ",", 
                    " ", "sid", ",", " ", "frontid", ",", " ", "sno1", ",", 
                    " ", "\n", "                     ", "sno2", ",", " ", 
                    "sno3", ",", " ", "sno4", ",", " ", "rayslot", ",", " ", 
                    "\n", "                     ", "generationnumber", ",", 
                    " ", "intersectionnumber", ",", " ", "pol1", ",", " ", 
                    "pol2", ",", " ", "\n", "                     ", "pol3"}],
                     "}"}], "}"}]}], ";", " ", 
                    RowBox[{"originalrotation", " ", "=", " ", 
                    RowBox[{"Partition", "[", 
                    RowBox[{
                    RowBox[{"Take", "[", 
                    RowBox[{"originalray", ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"7", ",", " ", "15"}], "}"}]}], "]"}], ",", " ", 
                    "3"}], "]"}]}], ";", " ", "\n", "                  ", 
                    RowBox[{"previoustilt", " ", "=", " ", 
                    RowBox[{"originalrotation", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], ";", " ", 
                    RowBox[{
                    "transmatrix", " ", "=", " ", "\n", "                   ", 
                    RowBox[{"MapIndexed", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "\n", "                        ", "rey", ",", 
                    " ", "rez", ",", " ", "r1", ",", " ", "r2", ",", " ", 
                    "r3", ",", " ", "\n", "                        ", "r4", 
                    ",", " ", "r5", ",", " ", "r6", ",", " ", "r7", ",", " ", 
                    "r8", ",", " ", "\n", "                        ", "r9", 
                    ",", " ", "wavelength", ",", " ", "intensity", ",", " ", 
                    "intensityscale", ",", " ", "\n", 
                    "                        ", "ray1", ",", " ", "index", 
                    ",", " ", "opticallength", ",", " ", "phaseshift", ",", 
                    " ", "\n", "                        ", "componentnumber", 
                    ",", " ", "surfacenumber", ",", " ", "surfaceid", ",", 
                    " ", "ray2", ",", " ", "\n", "                        ", 
                    "ray3", ",", " ", "sid", ",", " ", "frontid", ",", " ", 
                    "sno1", ",", " ", "sno2", ",", " ", "\n", 
                    "                        ", "sno3", ",", " ", "sno4", ",",
                     " ", "rayslot", ",", " ", "oldgenerationnumber", ",", 
                    " ", "\n", "                        ", 
                    "intersectionnumber", ",", " ", "pol1", ",", " ", "pol2", 
                    ",", " ", "pol3"}], "}"}], " ", "=", " ", "#1"}], ";", 
                    " ", "\n", "                      ", 
                    RowBox[{"rotationaxis", " ", "=", " ", 
                    RowBox[{"Cross", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"1.", ",", " ", "0.", ",", " ", "0."}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}]}], 
                    "]"}]}], ";", " ", "\n", "                      ", 
                    RowBox[{"axismagnitude", " ", "=", " ", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"rotationaxis", " ", ".", " ", "rotationaxis"}], 
                    "]"}]}], ";", " ", "\n", "                      ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Chop", "[", "axismagnitude", "]"}], " ", "!=", 
                    " ", "0."}], ",", " ", 
                    RowBox[{
                    RowBox[{"rotationaxis", " ", "=", " ", 
                    RowBox[{
                    "rotationaxis", "/", "\n", "                          ", 
                    "axismagnitude"}]}], ";", " ", 
                    RowBox[{"axismatrix", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"#1", "*", "rotationaxis"}], " ", "&"}], " ", 
                    ")"}], " ", "/@", " ", "\n", "                          ",
                     "rotationaxis"}]}], ";", " ", 
                    RowBox[{"crossmatrix", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", 
                    RowBox[{"-", 
                    RowBox[{"rotationaxis", "[", 
                    RowBox[{"[", "3", "]"}], "]"}]}], ",", " ", "\n", 
                    "                           ", 
                    RowBox[{"rotationaxis", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"rotationaxis", "[", 
                    RowBox[{"[", "3", "]"}], "]"}], ",", " ", "0.", ",", " ", 
                    
                    RowBox[{"-", 
                    RowBox[{"rotationaxis", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}]}], "}"}], ",", " ", "\n",
                     "                          ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"rotationaxis", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], ",", " ", 
                    RowBox[{"rotationaxis", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], ",", " ", "0."}], "}"}]}],
                     "}"}]}], ";", " ", 
                    RowBox[{
                    "cosangle", " ", "=", " ", "\n", 
                    "                         ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"1.", ",", " ", "0.", ",", " ", "0."}], "}"}], 
                    " ", ".", " ", 
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}]}]}],
                     ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"1.", " ", "-", " ", "cosangle"}], " ", "<", " ", 
                    "\n", "                          ", 
                    "2.220446049250313*^-16"}], ",", " ", 
                    RowBox[{"cosangle", " ", "=", " ", "1."}]}], "]"}], ";", 
                    " ", 
                    RowBox[{"sinangle", " ", "=", " ", 
                    RowBox[{"1", " ", "-", " ", 
                    RowBox[{"cosangle", "^", "2"}]}]}], ";", " ", "\n", 
                    "                        ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    "sinangle", " ", "<", " ", "2.220446049250313*^-16"}], 
                    ",", " ", 
                    RowBox[{"sinangle", " ", "=", " ", "0."}], ",", " ", 
                    RowBox[{
                    "sinangle", " ", "=", " ", "\n", 
                    "                          ", 
                    RowBox[{"Sqrt", "[", "sinangle", "]"}]}]}], "]"}], ";", 
                    " ", 
                    RowBox[{"axismatrix", " ", "+", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"1.", ",", " ", "0.", ",", " ", "0."}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "1.", ",", " ", "0."}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "0.", ",", " ", "1."}], "}"}]}], 
                    "}"}], " ", "-", " ", "\n", "                           ",
                     "axismatrix"}], ")"}], "*", "cosangle"}], " ", "+", " ", 
                    
                    RowBox[{"crossmatrix", "*", "sinangle"}]}]}], ",", " ", 
                    "\n", "                       ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "r4", ",", " ", "r5", ",", " ", "\n", 
                    "                          ", "r6"}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"r7", ",", " ", "r8", ",", " ", "r9"}], "}"}]}], 
                    "}"}], " ", "=", " ", "\n", "                        ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Sign", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"1.", ",", " ", "0.", ",", " ", "0."}], "}"}], 
                    " ", ".", " ", 
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}]}], 
                    "]"}], " ", "===", " ", "1"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"1.", ",", " ", "0.", ",", " ", "0."}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "1.", ",", " ", "0."}], "}"}], 
                    ",", " ", "\n", "                          ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "0.", ",", " ", "1."}], "}"}]}], 
                    "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", 
                    RowBox[{"-", "1."}], ",", " ", "0."}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "0.", ",", " ", "1."}], "}"}]}], 
                    "}"}]}], "]"}]}]}], "]"}]}], ")"}], " ", "&"}], " ", ",", 
                    " ", "allcreatedrays"}], "]"}]}], ";", " ", "\n", 
                    "                  ", 
                    RowBox[{"allcreatedrays", " ", "=", " ", 
                    RowBox[{"MapIndexed", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "\n", 
                    "                        ", "rex", ",", " ", "rey", ",", 
                    " ", "rez", ",", " ", "r1", ",", " ", "r2", ",", " ", 
                    "\n", "                        ", "r3", ",", " ", "r4", 
                    ",", " ", "r5", ",", " ", "r6", ",", " ", "r7", ",", " ", 
                    "\n", "                        ", "r8", ",", " ", "r9", 
                    ",", " ", "wavelength", ",", " ", "intensity", ",", " ", 
                    "\n", "                        ", "intensityscale", ",", 
                    " ", "ray1", ",", " ", "index", ",", " ", "opticallength",
                     ",", " ", "\n", "                        ", "phaseshift",
                     ",", " ", "componentnumber", ",", " ", "surfacenumber", 
                    ",", " ", "\n", "                        ", "surfaceid", 
                    ",", " ", "ray2", ",", " ", "ray3", ",", " ", "sid", ",", 
                    " ", "\n", "                        ", "frontid", ",", 
                    " ", "sno1", ",", " ", "sno2", ",", " ", "sno3", ",", " ",
                     "\n", "                        ", "sno4", ",", " ", 
                    "rayslot", ",", " ", "oldgenerationnumber", ",", " ", 
                    "\n", "                        ", "intersectionnumber", 
                    ",", " ", "pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], " ", "=", " ", "#1"}], ";", " ", "\n", 
                    "                      ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "r4", ",", " ", "r5", ",", " ", "\n", 
                    "                         ", "r6"}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"r7", ",", " ", "r8", ",", " ", "r9"}], "}"}]}], 
                    "}"}], " ", "=", " ", "\n", "                       ", 
                    RowBox[{
                    RowBox[{"Function", "[", 
                    RowBox[{"mm", ",", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"mm", " ", ".", " ", "#1"}], " ", "&"}], " ", 
                    ")"}], " ", "/@", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"1.", ",", " ", "0.", ",", " ", "0."}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "1.", ",", " ", "0."}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "0.", ",", " ", "1."}], "}"}]}], 
                    "}"}]}]}], "]"}], "[", "\n", "                        ", 
                    RowBox[{"transmatrix", "[", 
                    RowBox[{"[", 
                    RowBox[{"First", "[", "#2", "]"}], "]"}], "]"}], "]"}]}], 
                    ";", " ", 
                    RowBox[{"tiltmagnitude", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "r1", ",", " ", "r2", ",", " ", "\n", 
                    "                         ", "r3"}], "}"}], " ", ".", " ", 
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}]}]}],
                     ";", " ", "\n", "                      ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", 
                    RowBox[{"tiltmagnitude", " ", "-", " ", "1."}], "]"}], 
                    " ", ">", " ", "1.*^-6"}], ",", " ", 
                    RowBox[{
                    RowBox[{"dummyvector", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "r1", ",", " ", "\n", "                           ", "r2",
                     ",", " ", "r3"}], "}"}], "/", 
                    RowBox[{"Sqrt", "[", "tiltmagnitude", "]"}]}]}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "r1", ",", " ", "\n", "                          ", "r2", 
                    ",", " ", "r3"}], "}"}], " ", "=", " ", "dummyvector"}], 
                    ";", " ", 
                    RowBox[{
                    "dummymatrix", " ", "=", " ", "\n", 
                    "                         ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"#1", "/", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"#1", " ", ".", " ", "#1"}], "]"}]}], " ", "&"}], 
                    " ", ")"}], " ", "/@", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "r4", ",", " ", "\n", "                            ", 
                    "r5", ",", " ", "r6"}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"r7", ",", " ", "r8", ",", " ", "r9"}], "}"}]}], 
                    "}"}]}]}], ";", " ", "\n", "                        ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "r4", ",", " ", "r5", ",", " ", "\n", 
                    "                           ", "r6"}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"r7", ",", " ", "r8", ",", " ", "r9"}], "}"}]}], 
                    "}"}], " ", "=", " ", "\n", "                         ", 
                    "dummymatrix"}], ";", " ", "1."}], ",", " ", "1."}], 
                    "]"}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"allcreatedamplitudes", " ", "!=", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"0.", "*", "I"}], ",", " ", 
                    RowBox[{"0.", "*", "I"}], ",", " ", 
                    RowBox[{"0.", "*", "I"}]}], "}"}], "}"}]}], ",", " ", 
                    "\n", "                       ", 
                    RowBox[{
                    RowBox[{"amplitude", " ", "=", " ", 
                    RowBox[{"allcreatedamplitudes", "[", 
                    RowBox[{"[", 
                    RowBox[{"First", "[", "#2", "]"}], "]"}], "]"}]}], ";", 
                    " ", 
                    RowBox[{
                    "hor", " ", "=", " ", "\n", "                         ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r4", ",", " ", "r5", ",", " ", "r6"}], "}"}], 
                    " ", ".", " ", "amplitude"}]}], ";", " ", "\n", 
                    "                        ", 
                    RowBox[{"ver", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r7", ",", " ", "r8", ",", " ", "r9"}], "}"}], 
                    " ", ".", " ", "amplitude"}]}], ";", " ", "\n", 
                    "                        ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", "hor", "]"}], " ", ">", " ", "0."}], 
                    " ", "||", " ", 
                    RowBox[{
                    RowBox[{"Abs", "[", "ver", "]"}], " ", ">", " ", "0."}]}],
                     ",", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "pol1", ",", " ", "pol2", ",", " ", "\n", 
                    "                            ", "pol3"}], "}"}], " ", "=",
                     " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Abs", "[", "hor", "]"}], ",", " ", 
                    RowBox[{"Abs", "[", "ver", "]"}], ",", " ", "0."}], 
                    "}"}]}], ";", " ", 
                    RowBox[{
                    "dummyvector", " ", "=", " ", "\n", 
                    "                           ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], "/", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "pol1", ",", " ", "\n", "                               ",
                     "pol2", ",", " ", "pol3"}], "}"}], " ", ".", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "pol1", ",", " ", "pol2", ",", " ", "\n", 
                    "                               ", "pol3"}], "}"}]}], 
                    "]"}]}]}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], " ", "=", " ", "\n", "                           ",
                     "dummyvector"}], ";", " ", 
                    RowBox[{"dummyvector", " ", "=", " ", 
                    RowBox[{"ReplacePart", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "pol1", ",", " ", "\n", "                             ", 
                    "pol2", ",", " ", "pol3"}], "}"}], ",", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"ver", " ", "==", " ", "0."}], ",", " ", "0.", 
                    ",", " ", 
                    RowBox[{"Arg", "[", "ver", "]"}]}], "]"}], " ", "-", " ", 
                    "\n", "                              ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"hor", " ", "==", " ", "0."}], ",", " ", "0.", 
                    ",", " ", 
                    RowBox[{"Arg", "[", "hor", "]"}]}], "]"}]}], ")"}], "/", 
                    "Degree"}], ",", " ", "3"}], "]"}]}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "pol1", ",", " ", "\n", "                            ", 
                    "pol2", ",", " ", "pol3"}], "}"}], " ", "=", " ", 
                    "dummyvector"}]}]}], "]"}], ";", " ", "1."}], ",", " ", 
                    "1."}], "]"}], ";", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "\n", "                       ", "rsy", 
                    ",", " ", "rsz", ",", " ", "rex", ",", " ", "rey", ",", 
                    " ", "rez", ",", " ", "\n", "                       ", 
                    "r1", ",", " ", "r2", ",", " ", "r3", ",", " ", "r4", ",",
                     " ", "r5", ",", " ", "\n", "                       ", 
                    "r6", ",", " ", "r7", ",", " ", "r8", ",", " ", "r9", ",",
                     " ", "wavelength", ",", " ", "\n", 
                    "                       ", "intensity", ",", " ", 
                    "intensityscale", ",", " ", "ray1", ",", " ", "index", 
                    ",", " ", "\n", "                       ", 
                    "opticallength", ",", " ", "phaseshift", ",", " ", 
                    "componentnumber", ",", " ", "\n", 
                    "                       ", "surfacenumber", ",", " ", 
                    "surfaceid", ",", " ", "ray2", ",", " ", "ray3", ",", " ",
                     "\n", "                       ", "sid", ",", " ", 
                    "frontid", ",", " ", "sno1", ",", " ", "sno2", ",", " ", 
                    "sno3", ",", " ", "\n", "                       ", "sno4",
                     ",", " ", "rayslot", ",", " ", "generationnumber", ",", 
                    " ", "intersectionnumber", ",", " ", "\n", 
                    "                       ", "pol1", ",", " ", "pol2", ",", 
                    " ", "pol3"}], "}"}]}], ")"}], " ", "&"}], " ", ",", " ", 
                    "allcreatedrays"}], "]"}]}]}], ")"}], ";", " ", "\n", 
                    "                 ", 
                    RowBox[{"{", 
                    RowBox[{"allcreatedrays", ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",",
                     " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", 
                    "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",",
                     " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", 
                    "1.", ",", " ", "1.", ",", " ", 
                    RowBox[{"-", "1.7976931348623157*^308"}], ",", " ", "1.", 
                    ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", 
                    "\n", "                    ", "0.", ",", " ", 
                    RowBox[{"-", "1."}], ",", " ", 
                    RowBox[{"-", "1."}], ",", " ", 
                    RowBox[{"-", "1."}], ",", " ", "1.", ",", " ", "1.", ",", 
                    " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.",
                     ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ",
                     "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", 
                    ",", " ", "1."}], "}"}], "}"}], ",", " ", 
                    RowBox[{"{", "completedray", "}"}]}], "}"}]}], ",", " ", 
                    "\n", "                ", 
                    RowBox[{"resonatenumber", " ", "==", " ", "2"}], ",", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "\n", 
                    "                   ", "rex", ",", " ", "rey", ",", " ", 
                    "rez", ",", " ", "r1", ",", " ", "r2", ",", " ", "\n", 
                    "                   ", "r3", ",", " ", "r4", ",", " ", 
                    "r5", ",", " ", "r6", ",", " ", "r7", ",", " ", "\n", 
                    "                   ", "r8", ",", " ", "r9", ",", " ", 
                    "wavelength", ",", " ", "intensity", ",", " ", "\n", 
                    "                   ", "intensityscale", ",", " ", "ray1",
                     ",", " ", "index", ",", " ", "opticallength", ",", " ", 
                    "\n", "                   ", "phaseshift", ",", " ", 
                    "componentnumber", ",", " ", "surfacenumber", ",", " ", 
                    "surfaceid", ",", " ", "\n", "                   ", 
                    "ray2", ",", " ", "ray3", ",", " ", "sid", ",", " ", 
                    "frontid", ",", " ", "sno1", ",", " ", "\n", 
                    "                   ", "sno2", ",", " ", "sno3", ",", " ",
                     "sno4", ",", " ", "rayslot", ",", " ", "\n", 
                    "                   ", "oldgenerationnumber", ",", " ", 
                    "intersectionnumber", ",", " ", "pol1", ",", " ", "pol2", 
                    ",", " ", "\n", "                   ", "pol3"}], "}"}], 
                    " ", "=", " ", "#1"}], ";", " ", 
                    RowBox[{"index1", " ", "=", " ", "index"}], ";", " ", 
                    RowBox[{"xunit", " ", "=", " ", "\n", 
                    "                  ", 
                    RowBox[{
                    RowBox[{"r1", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "aa"}], "]"}], 
                    "]"}]}], " ", "+", " ", 
                    RowBox[{"r2", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "aa"}], "]"}], 
                    "]"}]}]}]}], ";", " ", "\n", "                 ", 
                    RowBox[{"yunit", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"r2", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "aa"}], "]"}], 
                    "]"}]}], " ", "-", " ", 
                    RowBox[{
                    "1.", "*", "r1", "*", "\n", "                    ", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "aa"}], "]"}], 
                    "]"}]}]}]}], ";", " ", 
                    RowBox[{"zunit", " ", "=", " ", 
                    RowBox[{"r3", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "aa"}], "]"}], "^", 
                    "2"}], " ", "+", " ", "\n", "                     ", 
                    RowBox[{
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "aa"}], "]"}], "^", 
                    "2"}]}], "]"}]}]}], ";", " ", 
                    RowBox[{"xunit", " ", "=", " ", 
                    RowBox[{"Chop", "[", "xunit", "]"}]}], ";", " ", 
                    RowBox[{
                    "yunit", " ", "=", " ", "\n", "                  ", 
                    RowBox[{"Chop", "[", "yunit", "]"}]}], ";", " ", 
                    RowBox[{"zunit", " ", "=", " ", 
                    RowBox[{"Chop", "[", "zunit", "]"}]}], ";", " ", 
                    RowBox[{
                    "magnitude", " ", "=", " ", "\n", "                  ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"xunit", "^", "2"}], " ", "+", " ", 
                    RowBox[{"yunit", "^", "2"}], " ", "+", " ", 
                    RowBox[{"zunit", "^", "2"}]}], ")"}], "^", 
                    RowBox[{"2", "^", 
                    RowBox[{"(", 
                    RowBox[{"-", "1"}], ")"}]}]}]}], ";", " ", 
                    RowBox[{
                    "xunit", " ", "=", " ", "\n", "                  ", 
                    RowBox[{"xunit", "/", "magnitude"}]}], ";", " ", 
                    RowBox[{"yunit", " ", "=", " ", 
                    RowBox[{
                    "yunit", "/", "\n", "                   ", 
                    "magnitude"}]}], ";", " ", 
                    RowBox[{"zunit", " ", "=", " ", 
                    RowBox[{"zunit", "/", "magnitude"}]}], ";", " ", "\n", 
                    "                 ", 
                    RowBox[{"rx", " ", "=", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "aa"}], "]"}], "]"}],
                     "*", 
                    RowBox[{"(", 
                    RowBox[{"rex", " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"xa1", " ", "+", " ", 
                    RowBox[{"ta", "*", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "aa"}], "]"}]}]}], 
                    "]"}]}]}], ")"}]}], " ", "+", " ", "\n", 
                    "                   ", 
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "aa"}], "]"}], "]"}],
                     "*", 
                    RowBox[{"(", 
                    RowBox[{"rey", " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"ya1", " ", "+", " ", 
                    RowBox[{"ta", "*", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "aa"}], "]"}]}]}], 
                    "]"}]}]}], ")"}]}]}]}], ";", " ", 
                    RowBox[{"ry", " ", "=", " ", "\n", "                  ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "1."}], "*", 
                    RowBox[{"(", 
                    RowBox[{"rex", " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"xa1", " ", "+", " ", 
                    RowBox[{"ta", "*", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "aa"}], "]"}]}]}], 
                    "]"}]}]}], ")"}], "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "aa"}], "]"}], 
                    "]"}]}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "aa"}], "]"}], "]"}],
                     "*", "\n", "                    ", 
                    RowBox[{"(", 
                    RowBox[{"rey", " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"ya1", " ", "+", " ", 
                    RowBox[{"ta", "*", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "aa"}], "]"}]}]}], 
                    "]"}]}]}], ")"}]}]}]}], ";", " ", 
                    RowBox[{"rz", " ", "=", " ", 
                    RowBox[{"rez", "*", "\n", "                   ", 
                    RowBox[{"Re", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "aa"}], "]"}], "^", 
                    "2"}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "aa"}], "]"}], "^", 
                    "2"}]}], "]"}]}]}], ";", " ", 
                    RowBox[{"rx", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rx", "]"}]}], ";", " ", "\n", 
                    "                 ", 
                    RowBox[{"ry", " ", "=", " ", 
                    RowBox[{"Chop", "[", "ry", "]"}]}], ";", " ", 
                    RowBox[{"rz", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rz", "]"}]}], ";", " ", "\n", 
                    "                 ", 
                    RowBox[{"terminatedeflection", " ", "=", " ", "False"}], 
                    ";", " ", 
                    RowBox[{"intersections", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}], "}"}]}], ";", " ", 
                    RowBox[{
                    "intersections", " ", "=", " ", "\n", 
                    "                  ", "resonateintersections"}], ";", " ", 
                    RowBox[{"holeQ", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"holeQlist", "[", 
                    RowBox[{
                    "[", "\n", "                    ", "resonatenumber", 
                    "]"}], "]"}], " ", "==", " ", "1"}]}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"newcomponentnumber", ",", " ", 
                    "newsurfacenumber", ",", " ", "\n", "                   ",
                     "newsurfaceid"}], "}"}], " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"1.", ",", " ", "2.", ",", " ", "16520."}], 
                    "}"}]}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "componentnumber", ",", " ", "surfacenumber", ",", " ", 
                    "\n", "                   ", "surfaceid"}], "}"}], " ", 
                    "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"1.", ",", " ", "2.", ",", " ", "16520."}], 
                    "}"}]}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"ray1", ",", " ", "ray2", ",", " ", "ray3"}], 
                    "}"}], " ", "=", " ", "\n", "                  ", 
                    RowBox[{"intersections", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], ";", " ", 
                    RowBox[{"rsx", " ", "=", " ", "rex"}], ";", " ", 
                    RowBox[{
                    "rsy", " ", "=", " ", "\n", "                  ", "rey"}],
                     ";", " ", 
                    RowBox[{"rsz", " ", "=", " ", "rez"}], ";", " ", 
                    RowBox[{"rxhlp", " ", "=", " ", 
                    RowBox[{
                    "rx", " ", "+", " ", "\n", "                   ", 
                    RowBox[{"ray1", "*", "xunit"}]}]}], ";", " ", 
                    RowBox[{"ryhlp", " ", "=", " ", 
                    RowBox[{"ry", " ", "+", " ", 
                    RowBox[{
                    "ray1", "*", "\n", "                    ", "yunit"}]}]}], 
                    ";", " ", 
                    RowBox[{"rzhlp", " ", "=", " ", 
                    RowBox[{"rz", " ", "+", " ", 
                    RowBox[{"ray1", "*", "zunit"}]}]}], ";", " ", "\n", 
                    "                 ", 
                    RowBox[{"rex", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"rxhlp", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "aa"}], "]"}], 
                    "]"}]}], " ", "+", " ", 
                    RowBox[{"Re", "[", 
                    RowBox[{"xa1", " ", "+", " ", 
                    RowBox[{"ta", "*", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "aa"}], "]"}]}]}], 
                    "]"}], " ", "-", " ", "\n", "                   ", 
                    RowBox[{"1.", "*", "ryhlp", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "aa"}], "]"}], 
                    "]"}]}]}]}], ";", " ", 
                    RowBox[{"rey", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"ryhlp", "*", "\n", "                    ", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "aa"}], "]"}], 
                    "]"}]}], " ", "+", " ", 
                    RowBox[{"rxhlp", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "aa"}], "]"}], 
                    "]"}]}], " ", "+", " ", 
                    RowBox[{"Re", "[", 
                    RowBox[{"ya1", " ", "+", " ", 
                    RowBox[{"ta", "*", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "aa"}], "]"}]}]}], 
                    "]"}]}]}], ";", " ", "\n", "                 ", 
                    RowBox[{"rez", " ", "=", " ", 
                    RowBox[{"rzhlp", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "aa"}], "]"}], "^", 
                    "2"}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "aa"}], "]"}], "^", 
                    "2"}]}], "]"}]}]}], ";", " ", "\n", "                 ", 
                    RowBox[{"rex", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rex", "]"}]}], ";", " ", 
                    RowBox[{"rey", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rey", "]"}]}], ";", " ", "\n", 
                    "                 ", 
                    RowBox[{"rez", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rez", "]"}]}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"rex", " ", "==", " ", "0"}], " ", "&&", " ", 
                    RowBox[{"rey", " ", "==", " ", "0"}], " ", "&&", " ", 
                    "\n", "                   ", 
                    RowBox[{"rez", " ", "==", " ", "0"}]}], ",", " ", 
                    RowBox[{
                    RowBox[{"rex", " ", "=", " ", 
                    RowBox[{"rxhlp", " ", "+", " ", 
                    RowBox[{"Re", "[", 
                    RowBox[{"xa1", " ", "+", " ", 
                    RowBox[{"ta", "*", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "aa"}], "]"}]}]}], 
                    "]"}]}]}], ";", " ", "\n", "                   ", 
                    RowBox[{"rey", " ", "=", " ", 
                    RowBox[{"ryhlp", " ", "+", " ", 
                    RowBox[{"Re", "[", 
                    RowBox[{"ya1", " ", "+", " ", 
                    RowBox[{"ta", "*", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "aa"}], "]"}]}]}], 
                    "]"}]}]}], ";", " ", 
                    RowBox[{
                    "rez", " ", "=", " ", "\n", "                    ", 
                    "rzhlp"}]}], ",", " ", "rex"}], "]"}], ";", " ", 
                    RowBox[{"intersectionnumber", " ", "=", " ", 
                    RowBox[{
                    "intersectionnumber", " ", "+", " ", "\n", 
                    "                   ", "1."}]}], ";", " ", 
                    RowBox[{"opticallength", " ", "=", " ", 
                    RowBox[{"opticallength", " ", "+", " ", 
                    RowBox[{"ray1", "*", "index1"}]}]}], ";", " ", "\n", 
                    "                 ", 
                    RowBox[{"completedray", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "\n", "                   ", "rey", ",", " ", 
                    "rez", ",", " ", "r1", ",", " ", "r2", ",", " ", "r3", 
                    ",", " ", "\n", "                   ", "r4", ",", " ", 
                    "r5", ",", " ", "r6", ",", " ", "r7", ",", " ", "r8", ",",
                     " ", "\n", "                   ", "r9", ",", " ", 
                    "wavelength", ",", " ", "intensity", ",", " ", 
                    "intensityscale", ",", " ", "\n", "                   ", 
                    "ray1", ",", " ", "index", ",", " ", "opticallength", ",",
                     " ", "phaseshift", ",", " ", "\n", "                   ",
                     "componentnumber", ",", " ", "surfacenumber", ",", " ", 
                    "surfaceid", ",", " ", "ray2", ",", " ", "\n", 
                    "                   ", "ray3", ",", " ", "sid", ",", " ", 
                    "frontid", ",", " ", "sno1", ",", " ", "sno2", ",", " ", 
                    "\n", "                   ", "sno3", ",", " ", "sno4", 
                    ",", " ", "rayslot", ",", " ", "generationnumber", ",", 
                    " ", "\n", "                   ", "intersectionnumber", 
                    ",", " ", "pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}]}], ";", " ", "\n", "                 ", 
                    RowBox[{"reportedrayspresent", " ", "=", " ", "True"}], 
                    ";", " ", 
                    RowBox[{"intersectionspresent", " ", "=", " ", "True"}], 
                    ";", " ", 
                    RowBox[{
                    "deflectedrayspresent", " ", "=", " ", "\n", 
                    "                  ", "True"}], ";", " ", 
                    RowBox[{"localdummyoutrayspresent", " ", "=", " ", 
                    "True"}], ";", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    "surfnorm", " ", "=", " ", "\n", "                   ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"1.", ",", " ", 
                    RowBox[{
                    RowBox[{"-", "1."}], "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"ray2", "/", 
                    RowBox[{"Sign", "[", "ca2", "]"}]}], "/", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"ca2", "^", 
                    RowBox[{"(", 
                    RowBox[{"-", "2"}], ")"}]}], " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"ray2", "^", "2"}]}], " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"ray3", "^", "2"}]}]}], ")"}], "^", "0.5"}]}], 
                    ")"}]}], ",", " ", "\n", "                       ", 
                    RowBox[{
                    RowBox[{"-", "1."}], "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"ray3", "/", 
                    RowBox[{"Sign", "[", "ca2", "]"}]}], "/", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"ca2", "^", 
                    RowBox[{"(", 
                    RowBox[{"-", "2"}], ")"}]}], " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"ray2", "^", "2"}]}], " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"ray3", "^", "2"}]}]}], ")"}], "^", "0.5"}]}], 
                    ")"}]}]}], "}"}], ",", " ", "\n", 
                    "                      ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"ray2", "/", 
                    RowBox[{"Sign", "[", "ca2", "]"}]}], "/", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"ca2", "^", 
                    RowBox[{"(", 
                    RowBox[{"-", "2"}], ")"}]}], " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"ray2", "^", "2"}]}], " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"ray3", "^", "2"}]}]}], ")"}], "^", "0.5"}]}], 
                    ",", " ", "1.", ",", " ", "0."}], "}"}], ",", " ", "\n", 
                    "                      ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"ray3", "/", 
                    RowBox[{"Sign", "[", "ca2", "]"}]}], "/", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"ca2", "^", 
                    RowBox[{"(", 
                    RowBox[{"-", "2"}], ")"}]}], " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"ray2", "^", "2"}]}], " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"ray3", "^", "2"}]}]}], ")"}], "^", "0.5"}]}], 
                    ",", " ", "0.", ",", " ", "1."}], "}"}]}], "}"}], 
                    "]"}]}]}], ";", " ", "\n", "                  ", 
                    RowBox[{"dummymatrix", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "aa"}], "]"}], "]"}],
                     "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "aa"}], "]"}], "^", 
                    "2"}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "aa"}], "]"}], "^", 
                    "2"}]}], "]"}]}], ")"}], "/", "\n", 
                    "                         ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "aa"}], "]"}], "]"}],
                     "^", "2"}], "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "aa"}], "]"}], "^", 
                    "2"}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "aa"}], "]"}], "^", 
                    "2"}]}], "]"}]}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "aa"}], "]"}], "]"}],
                     "^", "2"}], "*", "\n", "                           ", 
                    RowBox[{"Re", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "aa"}], "]"}], "^", 
                    "2"}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "aa"}], "]"}], "^", 
                    "2"}]}], "]"}]}]}], ")"}]}], ",", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1."}], "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "aa"}], "]"}], "]"}],
                     "*", "\n", "                          ", 
                    RowBox[{"Re", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "aa"}], "]"}], "^", 
                    "2"}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "aa"}], "]"}], "^", 
                    "2"}]}], "]"}]}], ")"}], "/", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "aa"}], "]"}], "]"}],
                     "^", "2"}], "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "aa"}], "]"}], "^", 
                    "\n", "                              ", "2"}], " ", "+", 
                    " ", 
                    RowBox[{
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "aa"}], "]"}], "^", 
                    "2"}]}], "]"}]}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "aa"}], "]"}], "]"}],
                     "^", "2"}], "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "aa"}], "]"}], "^", 
                    "2"}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"Sin", "[", 
                    RowBox[{
                    "0.017453292519943295", "*", "\n", 
                    "                                ", "aa"}], "]"}], "^", 
                    "2"}]}], "]"}]}]}], ")"}]}], ",", " ", "0."}], "}"}], ",",
                     " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "aa"}], "]"}], "]"}],
                     "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "aa"}], "]"}], "^", 
                    "2"}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "aa"}], "]"}], "^", 
                    "2"}]}], "]"}]}], ")"}], "/", "\n", 
                    "                         ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "aa"}], "]"}], "]"}],
                     "^", "2"}], "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "aa"}], "]"}], "^", 
                    "2"}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "aa"}], "]"}], "^", 
                    "2"}]}], "]"}]}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "aa"}], "]"}], "]"}],
                     "^", "2"}], "*", "\n", "                           ", 
                    RowBox[{"Re", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "aa"}], "]"}], "^", 
                    "2"}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "aa"}], "]"}], "^", 
                    "2"}]}], "]"}]}]}], ")"}]}], ",", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "aa"}], "]"}], "]"}],
                     "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "aa"}], "]"}], "^", 
                    "\n", "                             ", "2"}], " ", "+", 
                    " ", 
                    RowBox[{
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "aa"}], "]"}], "^", 
                    "2"}]}], "]"}]}], ")"}], "/", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "aa"}], "]"}], "]"}],
                     "^", "2"}], "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "aa"}], "]"}], "^", 
                    "2"}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"Sin", "[", 
                    RowBox[{
                    "0.017453292519943295", "*", "\n", 
                    "                                ", "aa"}], "]"}], "^", 
                    "2"}]}], "]"}]}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "aa"}], "]"}], "]"}],
                     "^", "2"}], "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "aa"}], "]"}], "^", 
                    "2"}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "aa"}], "]"}], "^", 
                    "2"}]}], "]"}]}]}], ")"}]}], ",", " ", "0."}], "}"}], ",",
                     " ", "\n", "                       ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "0.", ",", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "aa"}], "]"}], "]"}],
                     "^", "2"}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "aa"}], "]"}], "]"}],
                     "^", "2"}]}], ")"}], "/", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "aa"}], "]"}], "]"}],
                     "^", "2"}], "*", "\n", "                           ", 
                    RowBox[{"Re", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "aa"}], "]"}], "^", 
                    "2"}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "aa"}], "]"}], "^", 
                    "2"}]}], "]"}]}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "aa"}], "]"}], "]"}],
                     "^", "2"}], "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "aa"}], "]"}], "^", 
                    "\n", "                              ", "2"}], " ", "+", 
                    " ", 
                    RowBox[{
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "aa"}], "]"}], "^", 
                    "2"}]}], "]"}]}]}], ")"}]}]}], "}"}]}], "}"}], " ", ".", 
                    " ", "#1"}], " ", "&"}], " ", ")"}], " ", "/@", " ", 
                    "surfnorm"}]}], ";", " ", 
                    RowBox[{
                    "surfnorm", " ", "=", " ", "\n", "                   ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"#1", "/", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"#1", " ", ".", " ", "#1"}], "]"}]}], " ", "&"}], 
                    " ", ")"}], " ", "/@", " ", "dummymatrix"}]}], ";", " ", 
                    RowBox[{"surfacerotationmatrix", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "aa"}], "]"}], "]"}],
                     ",", " ", "\n", "                     ", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "aa"}], "]"}], "]"}],
                     ",", " ", "0."}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "1."}], "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "aa"}], "]"}], 
                    "]"}]}], ",", " ", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "aa"}], "]"}], "]"}],
                     ",", " ", "0."}], "}"}], ",", " ", "\n", 
                    "                    ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "0.", ",", " ", 
                    RowBox[{"Re", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "aa"}], "]"}], "^", 
                    "2"}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "aa"}], "]"}], "^", 
                    "2"}]}], "]"}]}], "}"}]}], "}"}]}], ";", " ", 
                    RowBox[{
                    "surfacetranslationvector", " ", "=", " ", "\n", 
                    "                   ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"xa1", " ", "+", " ", 
                    RowBox[{"ta", "*", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "aa"}], "]"}]}]}], 
                    "]"}], ",", " ", 
                    RowBox[{"Re", "[", 
                    RowBox[{"ya1", " ", "+", " ", 
                    RowBox[{"ta", "*", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "aa"}], "]"}]}]}], 
                    "]"}], ",", " ", "0."}], "}"}]}], ";", " ", 
                    RowBox[{"activeregion", " ", "=", " ", 
                    RowBox[{"-", "1."}]}], ";", " ", "\n", 
                    "                  ", 
                    RowBox[{"completedray", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "\n", "                    ", "rey", ",", " ", 
                    "rez", ",", " ", "r1", ",", " ", "r2", ",", " ", "r3", 
                    ",", " ", "\n", "                    ", "r4", ",", " ", 
                    "r5", ",", " ", "r6", ",", " ", "r7", ",", " ", "r8", ",",
                     " ", "\n", "                    ", "r9", ",", " ", 
                    "wavelength", ",", " ", "intensity", ",", " ", 
                    "intensityscale", ",", " ", "\n", "                    ", 
                    "ray1", ",", " ", "index", ",", " ", "opticallength", ",",
                     " ", "phaseshift", ",", " ", "\n", 
                    "                    ", "componentnumber", ",", " ", 
                    "surfacenumber", ",", " ", "surfaceid", ",", " ", "ray2", 
                    ",", " ", "\n", "                    ", "ray3", ",", " ", 
                    "sid", ",", " ", "frontid", ",", " ", "sno1", ",", " ", 
                    "sno2", ",", " ", "\n", "                    ", "sno3", 
                    ",", " ", "sno4", ",", " ", "rayslot", ",", " ", 
                    "generationnumber", ",", " ", "\n", 
                    "                    ", "intersectionnumber", ",", " ", 
                    "pol1", ",", " ", "pol2", ",", " ", "pol3"}], "}"}]}], 
                    ";", " ", "\n", "                  ", 
                    RowBox[{
                    "componentnumber", " ", "=", " ", "newcomponentnumber"}], 
                    ";", " ", 
                    RowBox[{
                    "surfacenumber", " ", "=", " ", "\n", 
                    "                   ", "newsurfacenumber"}], ";", " ", 
                    RowBox[{"surfaceid", " ", "=", " ", "newsurfaceid"}], ";",
                     " ", 
                    RowBox[{
                    "originalray", " ", "=", " ", "\n", "                   ", 
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "\n", "                    ", 
                    "rez", ",", " ", "r1", ",", " ", "r2", ",", " ", "r3", 
                    ",", " ", "r4", ",", " ", "\n", "                    ", 
                    "r5", ",", " ", "r6", ",", " ", "r7", ",", " ", "r8", ",",
                     " ", "r9", ",", " ", "\n", "                    ", 
                    "wavelength", ",", " ", "intensity", ",", " ", 
                    "intensityscale", ",", " ", "ray1", ",", " ", "\n", 
                    "                    ", "index", ",", " ", 
                    "opticallength", ",", " ", "phaseshift", ",", " ", 
                    "componentnumber", ",", " ", "\n", "                    ",
                     "surfacenumber", ",", " ", "surfaceid", ",", " ", "ray2",
                     ",", " ", "ray3", ",", " ", "\n", "                    ",
                     "sid", ",", " ", "frontid", ",", " ", "sno1", ",", " ", 
                    "sno2", ",", " ", "sno3", ",", " ", "\n", 
                    "                    ", "sno4", ",", " ", "rayslot", ",", 
                    " ", "generationnumber", ",", " ", "intersectionnumber", 
                    ",", " ", "\n", "                    ", "pol1", ",", " ", 
                    "pol2", ",", " ", "pol3"}], "}"}]}], ";", " ", 
                    RowBox[{
                    "ZAxis", " ", "=", " ", "\n", "                   ", 
                    RowBox[{
                    RowBox[{"First", "[", "surfnorm", "]"}], "*", 
                    RowBox[{"Sign", "[", 
                    RowBox[{
                    RowBox[{"First", "[", "surfnorm", "]"}], " ", ".", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "r1", ",", " ", "r2", ",", " ", "\n", 
                    "                       ", "r3"}], "}"}]}], "]"}]}]}], 
                    ";", " ", 
                    RowBox[{"raytiltz", " ", "=", " ", 
                    RowBox[{"ZAxis", " ", ".", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "r1", ",", " ", "\n", "                     ", "r2", ",", 
                    " ", "r3"}], "}"}]}]}], ";", " ", 
                    RowBox[{"raytiltx", " ", "=", " ", 
                    RowBox[{"1", " ", "-", " ", 
                    RowBox[{"raytiltz", "^", "2"}]}]}], ";", " ", "\n", 
                    "                  ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    "raytiltx", " ", "<", " ", "2.220446049250313*^-16"}], 
                    ",", " ", 
                    RowBox[{"raytiltx", " ", "=", " ", "0."}], ",", " ", 
                    RowBox[{
                    "raytiltx", " ", "=", " ", "\n", "                    ", 
                    RowBox[{"Sqrt", "[", "raytiltx", "]"}]}]}], "]"}], ";", 
                    " ", 
                    RowBox[{"XAxis", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "r1", ",", " ", "r2", ",", " ", "\n", 
                    "                     ", "r3"}], "}"}], " ", "-", " ", 
                    RowBox[{"ZAxis", "*", "raytiltz"}]}]}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", "raytiltx", "]"}], " ", "<", " ", 
                    "1.*^-7"}], ",", " ", "\n", "                   ", 
                    RowBox[{"XAxis", " ", "=", " ", 
                    RowBox[{"surfnorm", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], ",", " ", 
                    RowBox[{"XAxis", " ", "=", " ", 
                    RowBox[{
                    "XAxis", "/", "\n", "                     ", 
                    "raytiltx"}]}]}], "]"}], ";", " ", 
                    RowBox[{"YAxis", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"ZAxis", "[", 
                    RowBox[{"[", "3", "]"}], "]"}], "*", 
                    RowBox[{"XAxis", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], ")"}]}], " ", "+", " ", 
                    "\n", "                     ", 
                    RowBox[{
                    RowBox[{"ZAxis", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "*", 
                    RowBox[{"XAxis", "[", 
                    RowBox[{"[", "3", "]"}], "]"}]}]}], ",", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"ZAxis", "[", 
                    RowBox[{"[", "3", "]"}], "]"}], "*", 
                    RowBox[{"XAxis", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], " ", "-", " ", "\n", 
                    "                     ", 
                    RowBox[{
                    RowBox[{"ZAxis", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "*", 
                    RowBox[{"XAxis", "[", 
                    RowBox[{"[", "3", "]"}], "]"}]}]}], ",", " ", 
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"ZAxis", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "*", 
                    RowBox[{"XAxis", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], ")"}]}], " ", "+", " ", 
                    "\n", "                     ", 
                    RowBox[{
                    RowBox[{"ZAxis", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "*", 
                    RowBox[{"XAxis", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}]}]}], "}"}]}], ";", " ", 
                    RowBox[{"YAxis", " ", "=", " ", 
                    RowBox[{"YAxis", "/", "\n", "                    ", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"YAxis", " ", ".", " ", "YAxis"}], "]"}]}]}], ";",
                     " ", 
                    RowBox[{"PAxis", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"ZAxis", "*", "\n", "                     ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    " ", ".", " ", "XAxis"}]}], " ", "-", " ", 
                    RowBox[{"XAxis", "*", "\n", "                     ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    " ", ".", " ", "ZAxis"}]}]}]}], ";", " ", 
                    RowBox[{
                    "PAxis", " ", "=", " ", "\n", "                   ", 
                    RowBox[{"PAxis", "/", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"PAxis", " ", ".", " ", "PAxis"}], "]"}]}]}], ";",
                     " ", 
                    RowBox[{
                    "normalizedpolarization", " ", "=", " ", "\n", 
                    "                   ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], "[", 
                    RowBox[{"[", 
                    RowBox[{"{", 
                    RowBox[{"1", ",", " ", "2"}], "}"}], "]"}], "]"}]}], ";", 
                    " ", 
                    RowBox[{
                    "normalizedpolarization", " ", "=", " ", "\n", 
                    "                   ", 
                    RowBox[{"normalizedpolarization", "/", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{
                    "normalizedpolarization", " ", ".", " ", 
                    "normalizedpolarization"}], "]"}]}]}], ";", " ", "\n", 
                    "                  ", 
                    RowBox[{"allcreatedamplitudes", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"0.", "*", "I"}], ",", " ", 
                    RowBox[{"0.", "*", "I"}], ",", " ", 
                    RowBox[{"0.", "*", "I"}]}], "}"}], "}"}]}], ";", " ", 
                    RowBox[{"amplitude", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"Sqrt", "[", "intensity", "]"}], "*", "\n", 
                    "                    ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"normalizedpolarization", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "*", 
                    RowBox[{"{", 
                    RowBox[{"r4", ",", " ", "r5", ",", " ", "r6"}], "}"}]}], 
                    " ", "+", " ", "\n", "                     ", 
                    RowBox[{
                    RowBox[{"normalizedpolarization", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "*", 
                    RowBox[{"{", 
                    RowBox[{"r7", ",", " ", "r8", ",", " ", "r9"}], "}"}], 
                    "*", "\n", "                      ", 
                    RowBox[{"Exp", "[", 
                    RowBox[{"I", "*", "pol3", "*", "0.017453292519943295"}], 
                    "]"}]}]}], ")"}]}]}], ";", " ", 
                    RowBox[{"perpendicularamplitude", " ", "=", " ", 
                    RowBox[{
                    "amplitude", " ", ".", " ", "\n", "                    ", 
                    "YAxis"}]}], ";", " ", 
                    RowBox[{"parallelamplitude", " ", "=", " ", 
                    RowBox[{"amplitude", " ", ".", " ", "PAxis"}]}], ";", " ",
                     "\n", "                  ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"activeregion", "*", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"surfacerotationmatrix", " ", ".", " ", 
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "\n", 
                    "                        ", "r3"}], "}"}]}], ")"}], "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], " ", ">", " ", "0"}], 
                    ",", " ", 
                    RowBox[{
                    RowBox[{"index2", " ", "=", " ", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"2.2718929", " ", "-", " ", 
                    RowBox[{"0.010108077", "*", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", "\n", 
                    "                       ", 
                    RowBox[{"0.010592509", "/", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", 
                    RowBox[{"0.00020816965", "/", 
                    RowBox[{"wavelength", "^", "4"}]}], " ", "-", " ", 
                    RowBox[{
                    "7.6472538*^-6", "/", "\n", "                        ", 
                    RowBox[{"wavelength", "^", "6"}]}], " ", "+", " ", 
                    RowBox[{"4.9240991*^-7", "/", 
                    RowBox[{"wavelength", "^", "8"}]}]}], "]"}]}], ";", " ", 
                    RowBox[{
                    "index1", " ", "=", " ", "\n", "                     ", 
                    "index"}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", 
                    RowBox[{"index2", " ", "-", " ", "index1"}], "]"}], " ", 
                    "<", " ", "0.01"}], ",", " ", 
                    RowBox[{
                    RowBox[{
                    "alternateindex", " ", "=", " ", "\n", 
                    "                       ", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"1.0005281111748805", " ", "-", " ", 
                    RowBox[{"2.364805676582992*^-10", "*", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", 
                    RowBox[{"2.9781670902982902*^-6", "/", 
                    RowBox[{"wavelength", "^", "\n", 
                    "                           ", "2"}]}], " ", "+", " ", 
                    RowBox[{"2.6004099469477187*^-8", "/", 
                    RowBox[{"wavelength", "^", "4"}]}], " ", "+", " ", 
                    RowBox[{"3.7787839314048715*^-10", "/", 
                    RowBox[{"wavelength", "^", "6"}]}], " ", "+", " ", "\n", 
                    "                         ", 
                    RowBox[{"2.830549017940716*^-12", "/", 
                    RowBox[{"wavelength", "^", "8"}]}]}], "]"}]}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", 
                    RowBox[{"alternateindex", " ", "-", " ", "index1"}], 
                    "]"}], " ", ">", " ", "\n", "                        ", 
                    RowBox[{"Abs", "[", 
                    RowBox[{"index2", " ", "-", " ", "index1"}], "]"}]}], ",",
                     " ", 
                    RowBox[{
                    RowBox[{"index1", " ", "=", " ", "index2"}], ";", " ", 
                    "\n", "                        ", 
                    RowBox[{"index2", " ", "=", " ", "alternateindex"}]}], 
                    ",", " ", 
                    RowBox[{"index1", " ", "=", " ", "alternateindex"}]}], 
                    "]"}]}], ",", " ", "\n", "                     ", 
                    RowBox[{"index1", " ", "=", " ", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"1.0005281111748805", " ", "-", " ", 
                    RowBox[{"2.364805676582992*^-10", "*", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", 
                    RowBox[{
                    "2.9781670902982902*^-6", "/", "\n", 
                    "                         ", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", 
                    RowBox[{"2.6004099469477187*^-8", "/", 
                    RowBox[{"wavelength", "^", "4"}]}], " ", "+", " ", 
                    RowBox[{"3.7787839314048715*^-10", "/", "\n", 
                    "                         ", 
                    RowBox[{"wavelength", "^", "6"}]}], " ", "+", " ", 
                    RowBox[{"2.830549017940716*^-12", "/", 
                    RowBox[{"wavelength", "^", "8"}]}]}], "]"}]}]}], "]"}]}], 
                    ",", " ", 
                    RowBox[{
                    RowBox[{
                    "index2", " ", "=", " ", "\n", "                     ", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"1.0005281111748805", " ", "-", " ", 
                    RowBox[{"2.364805676582992*^-10", "*", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", 
                    RowBox[{"2.9781670902982902*^-6", "/", 
                    RowBox[{
                    "wavelength", "^", "\n", "                         ", 
                    "2"}]}], " ", "+", " ", 
                    RowBox[{"2.6004099469477187*^-8", "/", 
                    RowBox[{"wavelength", "^", "4"}]}], " ", "+", " ", 
                    RowBox[{"3.7787839314048715*^-10", "/", 
                    RowBox[{"wavelength", "^", "6"}]}], " ", "+", " ", "\n", 
                    "                       ", 
                    RowBox[{"2.830549017940716*^-12", "/", 
                    RowBox[{"wavelength", "^", "8"}]}]}], "]"}]}], ";", " ", 
                    RowBox[{"index1", " ", "=", " ", "index"}], ";", " ", 
                    "\n", "                    ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", 
                    RowBox[{"index2", " ", "-", " ", "index1"}], "]"}], " ", 
                    "<", " ", "0.01"}], ",", " ", 
                    RowBox[{
                    RowBox[{"alternateindex", " ", "=", " ", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{
                    "2.2718929", " ", "-", " ", "\n", 
                    "                         ", 
                    RowBox[{"0.010108077", "*", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", 
                    RowBox[{"0.010592509", "/", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", 
                    RowBox[{
                    "0.00020816965", "/", "\n", "                          ", 
                    
                    RowBox[{"wavelength", "^", "4"}]}], " ", "-", " ", 
                    RowBox[{"7.6472538*^-6", "/", 
                    RowBox[{"wavelength", "^", "6"}]}], " ", "+", " ", 
                    RowBox[{"4.9240991*^-7", "/", 
                    RowBox[{"wavelength", "^", "8"}]}]}], "]"}]}], ";", " ", 
                    "\n", "                      ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", 
                    RowBox[{"alternateindex", " ", "-", " ", "index1"}], 
                    "]"}], " ", ">", " ", 
                    RowBox[{"Abs", "[", 
                    RowBox[{"index2", " ", "-", " ", "index1"}], "]"}]}], ",",
                     " ", "\n", "                       ", 
                    RowBox[{
                    RowBox[{"index1", " ", "=", " ", "index2"}], ";", " ", 
                    RowBox[{"index2", " ", "=", " ", "alternateindex"}]}], 
                    ",", " ", "\n", "                       ", 
                    RowBox[{"index1", " ", "=", " ", "alternateindex"}]}], 
                    "]"}]}], ",", " ", 
                    RowBox[{"index1", " ", "=", " ", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"2.2718929", " ", "-", " ", 
                    RowBox[{
                    "0.010108077", "*", "\n", "                         ", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", 
                    RowBox[{"0.010592509", "/", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", 
                    RowBox[{"0.00020816965", "/", 
                    RowBox[{"wavelength", "^", "4"}]}], " ", "-", " ", "\n", 
                    "                        ", 
                    RowBox[{"7.6472538*^-6", "/", 
                    RowBox[{"wavelength", "^", "6"}]}], " ", "+", " ", 
                    RowBox[{"4.9240991*^-7", "/", 
                    RowBox[{"wavelength", "^", "8"}]}]}], "]"}]}]}], 
                    "]"}]}]}], "]"}], ";", " ", 
                    RowBox[{"n12", " ", "=", " ", "\n", "                   ", 
                    RowBox[{"index1", "/", "index2"}]}], ";", " ", 
                    RowBox[{"index", " ", "=", " ", "index2"}], ";", " ", 
                    "\n", "                  ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"1", " ", "-", " ", 
                    RowBox[{
                    RowBox[{"n12", "^", "2"}], "*", 
                    RowBox[{"raytiltx", "^", "2"}]}]}], " ", ">=", " ", 
                    "0."}], ",", " ", 
                    RowBox[{
                    RowBox[{"dummyvector", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"n12", "*", "\n", "                       ", 
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}]}], 
                    " ", "+", " ", 
                    RowBox[{"ZAxis", "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"(", 
                    RowBox[{
                    "n12", "*", "\n", "                          ", 
                    "raytiltz"}], ")"}]}], " ", "+", " ", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"1", " ", "-", " ", 
                    RowBox[{
                    RowBox[{"n12", "^", "2"}], "*", 
                    RowBox[{"raytiltx", "^", "2"}]}]}], "]"}]}], ")"}]}]}]}], 
                    ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "\n", "                      ", 
                    "r2", ",", " ", "r3"}], "}"}], " ", "=", " ", 
                    "dummyvector"}], ";", " ", "1."}], ",", " ", "\n", 
                    "                   ", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    " ", ".", " ", 
                    RowBox[{"surfnorm", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], " ", ">", " ", "0"}], 
                    ",", " ", "\n", "                     ", 
                    RowBox[{"phaseshift", " ", "=", " ", 
                    RowBox[{"phaseshift", " ", "+", " ", "0.5"}]}], ",", " ", 
                    "1."}], "]"}], ";", " ", 
                    RowBox[{"index2", " ", "=", " ", "index1"}], ";", " ", 
                    "\n", "                    ", 
                    RowBox[{"index", " ", "=", " ", "index1"}], ";", " ", 
                    RowBox[{"dummyvector", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "r1", ",", " ", "\n", "                       ", "r2", 
                    ",", " ", "r3"}], "}"}], " ", "-", " ", 
                    RowBox[{"2", "*", "ZAxis", "*", 
                    RowBox[{"ZAxis", " ", ".", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "r1", ",", " ", "\n", "                         ", "r2", 
                    ",", " ", "r3"}], "}"}]}]}]}]}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    " ", "=", " ", "\n", "                     ", 
                    "dummyvector"}], ";", " ", 
                    RowBox[{"dummyvector", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "pol1", ",", " ", "pol2", ",", " ", "\n", 
                    "                       ", "pol3"}], "}"}], " ", "+", " ", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", " ", "0", ",", " ", 
                    RowBox[{"-", "180"}]}], "}"}]}]}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], " ", "=", " ", "\n", "                     ", 
                    "dummyvector"}], ";", " ", "1."}]}], "]"}], ";", " ", 
                    RowBox[{"allcreatedrays", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "\n", 
                    "                     ", "rsz", ",", " ", "rex", ",", " ",
                     "rey", ",", " ", "rez", ",", " ", "r1", ",", " ", "\n", 
                    "                     ", "r2", ",", " ", "r3", ",", " ", 
                    "r4", ",", " ", "r5", ",", " ", "r6", ",", " ", "\n", 
                    "                     ", "r7", ",", " ", "r8", ",", " ", 
                    "r9", ",", " ", "wavelength", ",", " ", "intensity", ",", 
                    " ", "\n", "                     ", "intensityscale", ",",
                     " ", "ray1", ",", " ", "index", ",", " ", 
                    "opticallength", ",", " ", "\n", "                     ", 
                    "phaseshift", ",", " ", "componentnumber", ",", " ", 
                    "surfacenumber", ",", " ", "surfaceid", ",", " ", "\n", 
                    "                     ", "ray2", ",", " ", "ray3", ",", 
                    " ", "sid", ",", " ", "frontid", ",", " ", "sno1", ",", 
                    " ", "\n", "                     ", "sno2", ",", " ", 
                    "sno3", ",", " ", "sno4", ",", " ", "rayslot", ",", " ", 
                    "\n", "                     ", "generationnumber", ",", 
                    " ", "intersectionnumber", ",", " ", "pol1", ",", " ", 
                    "pol2", ",", " ", "\n", "                     ", "pol3"}],
                     "}"}], "}"}]}], ";", " ", 
                    RowBox[{"originalrotation", " ", "=", " ", 
                    RowBox[{"Partition", "[", 
                    RowBox[{
                    RowBox[{"Take", "[", 
                    RowBox[{"originalray", ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"7", ",", " ", "15"}], "}"}]}], "]"}], ",", " ", 
                    "3"}], "]"}]}], ";", " ", "\n", "                  ", 
                    RowBox[{"previoustilt", " ", "=", " ", 
                    RowBox[{"originalrotation", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], ";", " ", 
                    RowBox[{
                    "transmatrix", " ", "=", " ", "\n", "                   ", 
                    RowBox[{"MapIndexed", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "\n", "                        ", "rey", ",", 
                    " ", "rez", ",", " ", "r1", ",", " ", "r2", ",", " ", 
                    "r3", ",", " ", "\n", "                        ", "r4", 
                    ",", " ", "r5", ",", " ", "r6", ",", " ", "r7", ",", " ", 
                    "r8", ",", " ", "\n", "                        ", "r9", 
                    ",", " ", "wavelength", ",", " ", "intensity", ",", " ", 
                    "intensityscale", ",", " ", "\n", 
                    "                        ", "ray1", ",", " ", "index", 
                    ",", " ", "opticallength", ",", " ", "phaseshift", ",", 
                    " ", "\n", "                        ", "componentnumber", 
                    ",", " ", "surfacenumber", ",", " ", "surfaceid", ",", 
                    " ", "ray2", ",", " ", "\n", "                        ", 
                    "ray3", ",", " ", "sid", ",", " ", "frontid", ",", " ", 
                    "sno1", ",", " ", "sno2", ",", " ", "\n", 
                    "                        ", "sno3", ",", " ", "sno4", ",",
                     " ", "rayslot", ",", " ", "oldgenerationnumber", ",", 
                    " ", "\n", "                        ", 
                    "intersectionnumber", ",", " ", "pol1", ",", " ", "pol2", 
                    ",", " ", "pol3"}], "}"}], " ", "=", " ", "#1"}], ";", 
                    " ", "\n", "                      ", 
                    RowBox[{"rotationaxis", " ", "=", " ", 
                    RowBox[{"Cross", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"1.", ",", " ", "0.", ",", " ", "0."}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}]}], 
                    "]"}]}], ";", " ", "\n", "                      ", 
                    RowBox[{"axismagnitude", " ", "=", " ", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"rotationaxis", " ", ".", " ", "rotationaxis"}], 
                    "]"}]}], ";", " ", "\n", "                      ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Chop", "[", "axismagnitude", "]"}], " ", "!=", 
                    " ", "0."}], ",", " ", 
                    RowBox[{
                    RowBox[{"rotationaxis", " ", "=", " ", 
                    RowBox[{
                    "rotationaxis", "/", "\n", "                          ", 
                    "axismagnitude"}]}], ";", " ", 
                    RowBox[{"axismatrix", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"#1", "*", "rotationaxis"}], " ", "&"}], " ", 
                    ")"}], " ", "/@", " ", "\n", "                          ",
                     "rotationaxis"}]}], ";", " ", 
                    RowBox[{"crossmatrix", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", 
                    RowBox[{"-", 
                    RowBox[{"rotationaxis", "[", 
                    RowBox[{"[", "3", "]"}], "]"}]}], ",", " ", "\n", 
                    "                           ", 
                    RowBox[{"rotationaxis", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"rotationaxis", "[", 
                    RowBox[{"[", "3", "]"}], "]"}], ",", " ", "0.", ",", " ", 
                    
                    RowBox[{"-", 
                    RowBox[{"rotationaxis", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}]}], "}"}], ",", " ", "\n",
                     "                          ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"rotationaxis", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], ",", " ", 
                    RowBox[{"rotationaxis", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], ",", " ", "0."}], "}"}]}],
                     "}"}]}], ";", " ", 
                    RowBox[{
                    "cosangle", " ", "=", " ", "\n", 
                    "                         ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"1.", ",", " ", "0.", ",", " ", "0."}], "}"}], 
                    " ", ".", " ", 
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}]}]}],
                     ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"1.", " ", "-", " ", "cosangle"}], " ", "<", " ", 
                    "\n", "                          ", 
                    "2.220446049250313*^-16"}], ",", " ", 
                    RowBox[{"cosangle", " ", "=", " ", "1."}]}], "]"}], ";", 
                    " ", 
                    RowBox[{"sinangle", " ", "=", " ", 
                    RowBox[{"1", " ", "-", " ", 
                    RowBox[{"cosangle", "^", "2"}]}]}], ";", " ", "\n", 
                    "                        ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    "sinangle", " ", "<", " ", "2.220446049250313*^-16"}], 
                    ",", " ", 
                    RowBox[{"sinangle", " ", "=", " ", "0."}], ",", " ", 
                    RowBox[{"sinangle", " ", "=", " ", "\n", 
                    "                          ", 
                    RowBox[{"Sqrt", "[", "sinangle", "]"}]}]}], "]"}], ";", 
                    " ", 
                    RowBox[{"axismatrix", " ", "+", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"1.", ",", " ", "0.", ",", " ", "0."}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "1.", ",", " ", "0."}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "0.", ",", " ", "1."}], "}"}]}], 
                    "}"}], " ", "-", " ", "\n", "                           ",
                     "axismatrix"}], ")"}], "*", "cosangle"}], " ", "+", " ", 
                    
                    RowBox[{"crossmatrix", "*", "sinangle"}]}]}], ",", " ", 
                    "\n", "                       ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "r4", ",", " ", "r5", ",", " ", "\n", 
                    "                          ", "r6"}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"r7", ",", " ", "r8", ",", " ", "r9"}], "}"}]}], 
                    "}"}], " ", "=", " ", "\n", "                        ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Sign", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"1.", ",", " ", "0.", ",", " ", "0."}], "}"}], 
                    " ", ".", " ", 
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}]}], 
                    "]"}], " ", "===", " ", "1"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"1.", ",", " ", "0.", ",", " ", "0."}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "1.", ",", " ", "0."}], "}"}], 
                    ",", " ", "\n", "                          ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "0.", ",", " ", "1."}], "}"}]}], 
                    "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", 
                    RowBox[{"-", "1."}], ",", " ", "0."}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "0.", ",", " ", "1."}], "}"}]}], 
                    "}"}]}], "]"}]}]}], "]"}]}], ")"}], " ", "&"}], " ", ",", 
                    " ", "allcreatedrays"}], "]"}]}], ";", " ", "\n", 
                    "                  ", 
                    RowBox[{"allcreatedrays", " ", "=", " ", 
                    RowBox[{"MapIndexed", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "\n", 
                    "                        ", "rex", ",", " ", "rey", ",", 
                    " ", "rez", ",", " ", "r1", ",", " ", "r2", ",", " ", 
                    "\n", "                        ", "r3", ",", " ", "r4", 
                    ",", " ", "r5", ",", " ", "r6", ",", " ", "r7", ",", " ", 
                    "\n", "                        ", "r8", ",", " ", "r9", 
                    ",", " ", "wavelength", ",", " ", "intensity", ",", " ", 
                    "\n", "                        ", "intensityscale", ",", 
                    " ", "ray1", ",", " ", "index", ",", " ", "opticallength",
                     ",", " ", "\n", "                        ", "phaseshift",
                     ",", " ", "componentnumber", ",", " ", "surfacenumber", 
                    ",", " ", "\n", "                        ", "surfaceid", 
                    ",", " ", "ray2", ",", " ", "ray3", ",", " ", "sid", ",", 
                    " ", "\n", "                        ", "frontid", ",", 
                    " ", "sno1", ",", " ", "sno2", ",", " ", "sno3", ",", " ",
                     "\n", "                        ", "sno4", ",", " ", 
                    "rayslot", ",", " ", "oldgenerationnumber", ",", " ", 
                    "\n", "                        ", "intersectionnumber", 
                    ",", " ", "pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], " ", "=", " ", "#1"}], ";", " ", "\n", 
                    "                      ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "r4", ",", " ", "r5", ",", " ", "\n", 
                    "                         ", "r6"}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"r7", ",", " ", "r8", ",", " ", "r9"}], "}"}]}], 
                    "}"}], " ", "=", " ", "\n", "                       ", 
                    RowBox[{
                    RowBox[{"Function", "[", 
                    RowBox[{"mm", ",", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"mm", " ", ".", " ", "#1"}], " ", "&"}], " ", 
                    ")"}], " ", "/@", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"1.", ",", " ", "0.", ",", " ", "0."}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "1.", ",", " ", "0."}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "0.", ",", " ", "1."}], "}"}]}], 
                    "}"}]}]}], "]"}], "[", "\n", "                        ", 
                    RowBox[{"transmatrix", "[", 
                    RowBox[{"[", 
                    RowBox[{"First", "[", "#2", "]"}], "]"}], "]"}], "]"}]}], 
                    ";", " ", 
                    RowBox[{"tiltmagnitude", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "r1", ",", " ", "r2", ",", " ", "\n", 
                    "                         ", "r3"}], "}"}], " ", ".", " ", 
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}]}]}],
                     ";", " ", "\n", "                      ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", 
                    RowBox[{"tiltmagnitude", " ", "-", " ", "1."}], "]"}], 
                    " ", ">", " ", "1.*^-6"}], ",", " ", 
                    RowBox[{
                    RowBox[{"dummyvector", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "r1", ",", " ", "\n", "                           ", "r2",
                     ",", " ", "r3"}], "}"}], "/", 
                    RowBox[{"Sqrt", "[", "tiltmagnitude", "]"}]}]}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "r1", ",", " ", "\n", "                          ", "r2", 
                    ",", " ", "r3"}], "}"}], " ", "=", " ", "dummyvector"}], 
                    ";", " ", 
                    RowBox[{
                    "dummymatrix", " ", "=", " ", "\n", 
                    "                         ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"#1", "/", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"#1", " ", ".", " ", "#1"}], "]"}]}], " ", "&"}], 
                    " ", ")"}], " ", "/@", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "r4", ",", " ", "\n", "                            ", 
                    "r5", ",", " ", "r6"}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"r7", ",", " ", "r8", ",", " ", "r9"}], "}"}]}], 
                    "}"}]}]}], ";", " ", "\n", "                        ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "r4", ",", " ", "r5", ",", " ", "\n", 
                    "                           ", "r6"}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"r7", ",", " ", "r8", ",", " ", "r9"}], "}"}]}], 
                    "}"}], " ", "=", " ", "\n", "                         ", 
                    "dummymatrix"}], ";", " ", "1."}], ",", " ", "1."}], 
                    "]"}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"allcreatedamplitudes", " ", "!=", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"0.", "*", "I"}], ",", " ", 
                    RowBox[{"0.", "*", "I"}], ",", " ", 
                    RowBox[{"0.", "*", "I"}]}], "}"}], "}"}]}], ",", " ", 
                    "\n", "                       ", 
                    RowBox[{
                    RowBox[{"amplitude", " ", "=", " ", 
                    RowBox[{"allcreatedamplitudes", "[", 
                    RowBox[{"[", 
                    RowBox[{"First", "[", "#2", "]"}], "]"}], "]"}]}], ";", 
                    " ", 
                    RowBox[{
                    "hor", " ", "=", " ", "\n", "                         ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r4", ",", " ", "r5", ",", " ", "r6"}], "}"}], 
                    " ", ".", " ", "amplitude"}]}], ";", " ", "\n", 
                    "                        ", 
                    RowBox[{"ver", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r7", ",", " ", "r8", ",", " ", "r9"}], "}"}], 
                    " ", ".", " ", "amplitude"}]}], ";", " ", "\n", 
                    "                        ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", "hor", "]"}], " ", ">", " ", "0."}], 
                    " ", "||", " ", 
                    RowBox[{
                    RowBox[{"Abs", "[", "ver", "]"}], " ", ">", " ", "0."}]}],
                     ",", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "pol1", ",", " ", "pol2", ",", " ", "\n", 
                    "                            ", "pol3"}], "}"}], " ", "=",
                     " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Abs", "[", "hor", "]"}], ",", " ", 
                    RowBox[{"Abs", "[", "ver", "]"}], ",", " ", "0."}], 
                    "}"}]}], ";", " ", 
                    RowBox[{
                    "dummyvector", " ", "=", " ", "\n", 
                    "                           ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], "/", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "pol1", ",", " ", "\n", "                               ",
                     "pol2", ",", " ", "pol3"}], "}"}], " ", ".", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "pol1", ",", " ", "pol2", ",", " ", "\n", 
                    "                               ", "pol3"}], "}"}]}], 
                    "]"}]}]}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], " ", "=", " ", "\n", "                           ",
                     "dummyvector"}], ";", " ", 
                    RowBox[{"dummyvector", " ", "=", " ", 
                    RowBox[{"ReplacePart", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "pol1", ",", " ", "\n", "                             ", 
                    "pol2", ",", " ", "pol3"}], "}"}], ",", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"ver", " ", "==", " ", "0."}], ",", " ", "0.", 
                    ",", " ", 
                    RowBox[{"Arg", "[", "ver", "]"}]}], "]"}], " ", "-", " ", 
                    "\n", "                              ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"hor", " ", "==", " ", "0."}], ",", " ", "0.", 
                    ",", " ", 
                    RowBox[{"Arg", "[", "hor", "]"}]}], "]"}]}], ")"}], "/", 
                    "Degree"}], ",", " ", "3"}], "]"}]}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "pol1", ",", " ", "\n", "                            ", 
                    "pol2", ",", " ", "pol3"}], "}"}], " ", "=", " ", 
                    "dummyvector"}]}]}], "]"}], ";", " ", "1."}], ",", " ", 
                    "1."}], "]"}], ";", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "\n", "                       ", "rsy", 
                    ",", " ", "rsz", ",", " ", "rex", ",", " ", "rey", ",", 
                    " ", "rez", ",", " ", "\n", "                       ", 
                    "r1", ",", " ", "r2", ",", " ", "r3", ",", " ", "r4", ",",
                     " ", "r5", ",", " ", "\n", "                       ", 
                    "r6", ",", " ", "r7", ",", " ", "r8", ",", " ", "r9", ",",
                     " ", "wavelength", ",", " ", "\n", 
                    "                       ", "intensity", ",", " ", 
                    "intensityscale", ",", " ", "ray1", ",", " ", "index", 
                    ",", " ", "\n", "                       ", 
                    "opticallength", ",", " ", "phaseshift", ",", " ", 
                    "componentnumber", ",", " ", "\n", 
                    "                       ", "surfacenumber", ",", " ", 
                    "surfaceid", ",", " ", "ray2", ",", " ", "ray3", ",", " ",
                     "\n", "                       ", "sid", ",", " ", 
                    "frontid", ",", " ", "sno1", ",", " ", "sno2", ",", " ", 
                    "sno3", ",", " ", "\n", "                       ", "sno4",
                     ",", " ", "rayslot", ",", " ", "generationnumber", ",", 
                    " ", "intersectionnumber", ",", " ", "\n", 
                    "                       ", "pol1", ",", " ", "pol2", ",", 
                    " ", "pol3"}], "}"}]}], ")"}], " ", "&"}], " ", ",", " ", 
                    "allcreatedrays"}], "]"}]}]}], ")"}], ";", " ", "\n", 
                    "                 ", 
                    RowBox[{"{", 
                    RowBox[{"allcreatedrays", ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",",
                     " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", 
                    "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",",
                     " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", 
                    "1.", ",", " ", "1.", ",", " ", 
                    RowBox[{"-", "1.7976931348623157*^308"}], ",", " ", "1.", 
                    ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", 
                    "\n", "                    ", "0.", ",", " ", 
                    RowBox[{"-", "1."}], ",", " ", 
                    RowBox[{"-", "1."}], ",", " ", 
                    RowBox[{"-", "1."}], ",", " ", "1.", ",", " ", "1.", ",", 
                    " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.",
                     ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ",
                     "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", 
                    ",", " ", "1."}], "}"}], "}"}], ",", " ", 
                    RowBox[{"{", "completedray", "}"}]}], "}"}]}], ",", " ", 
                    "\n", "                ", 
                    RowBox[{"resonatenumber", " ", "==", " ", "3"}], ",", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "\n", 
                    "                   ", "rex", ",", " ", "rey", ",", " ", 
                    "rez", ",", " ", "r1", ",", " ", "r2", ",", " ", "\n", 
                    "                   ", "r3", ",", " ", "r4", ",", " ", 
                    "r5", ",", " ", "r6", ",", " ", "r7", ",", " ", "\n", 
                    "                   ", "r8", ",", " ", "r9", ",", " ", 
                    "wavelength", ",", " ", "intensity", ",", " ", "\n", 
                    "                   ", "intensityscale", ",", " ", "ray1",
                     ",", " ", "index", ",", " ", "opticallength", ",", " ", 
                    "\n", "                   ", "phaseshift", ",", " ", 
                    "componentnumber", ",", " ", "surfacenumber", ",", " ", 
                    "surfaceid", ",", " ", "\n", "                   ", 
                    "ray2", ",", " ", "ray3", ",", " ", "sid", ",", " ", 
                    "frontid", ",", " ", "sno1", ",", " ", "\n", 
                    "                   ", "sno2", ",", " ", "sno3", ",", " ",
                     "sno4", ",", " ", "rayslot", ",", " ", "\n", 
                    "                   ", "oldgenerationnumber", ",", " ", 
                    "intersectionnumber", ",", " ", "pol1", ",", " ", "pol2", 
                    ",", " ", "\n", "                   ", "pol3"}], "}"}], 
                    " ", "=", " ", "#1"}], ";", " ", 
                    RowBox[{"index1", " ", "=", " ", "index"}], ";", " ", 
                    RowBox[{
                    "xunit", " ", "=", " ", "\n", "                  ", 
                    RowBox[{
                    RowBox[{"r1", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "ab"}], "]"}], 
                    "]"}]}], " ", "+", " ", 
                    RowBox[{"r2", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "ab"}], "]"}], 
                    "]"}]}]}]}], ";", " ", "\n", "                 ", 
                    RowBox[{"yunit", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"r2", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "ab"}], "]"}], 
                    "]"}]}], " ", "-", " ", 
                    RowBox[{
                    "1.", "*", "r1", "*", "\n", "                    ", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "ab"}], "]"}], 
                    "]"}]}]}]}], ";", " ", 
                    RowBox[{"zunit", " ", "=", " ", 
                    RowBox[{"r3", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "ab"}], "]"}], "^", 
                    "2"}], " ", "+", " ", "\n", "                     ", 
                    RowBox[{
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "ab"}], "]"}], "^", 
                    "2"}]}], "]"}]}]}], ";", " ", 
                    RowBox[{"xunit", " ", "=", " ", 
                    RowBox[{"Chop", "[", "xunit", "]"}]}], ";", " ", 
                    RowBox[{
                    "yunit", " ", "=", " ", "\n", "                  ", 
                    RowBox[{"Chop", "[", "yunit", "]"}]}], ";", " ", 
                    RowBox[{"zunit", " ", "=", " ", 
                    RowBox[{"Chop", "[", "zunit", "]"}]}], ";", " ", 
                    RowBox[{
                    "magnitude", " ", "=", " ", "\n", "                  ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"xunit", "^", "2"}], " ", "+", " ", 
                    RowBox[{"yunit", "^", "2"}], " ", "+", " ", 
                    RowBox[{"zunit", "^", "2"}]}], ")"}], "^", 
                    RowBox[{"2", "^", 
                    RowBox[{"(", 
                    RowBox[{"-", "1"}], ")"}]}]}]}], ";", " ", 
                    RowBox[{
                    "xunit", " ", "=", " ", "\n", "                  ", 
                    RowBox[{"xunit", "/", "magnitude"}]}], ";", " ", 
                    RowBox[{"yunit", " ", "=", " ", 
                    RowBox[{
                    "yunit", "/", "\n", "                   ", 
                    "magnitude"}]}], ";", " ", 
                    RowBox[{"zunit", " ", "=", " ", 
                    RowBox[{"zunit", "/", "magnitude"}]}], ";", " ", "\n", 
                    "                 ", 
                    RowBox[{"rx", " ", "=", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"rex", " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"Re", "[", "xb1", "]"}]}]}], ")"}], "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "ab"}], "]"}], 
                    "]"}]}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"rey", " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"Re", "[", "yb1", "]"}]}]}], ")"}], "*", "\n", 
                    "                    ", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "ab"}], "]"}], 
                    "]"}]}]}]}], ";", " ", 
                    RowBox[{"ry", " ", "=", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"rey", " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"Re", "[", "yb1", "]"}]}]}], ")"}], "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "ab"}], "]"}], 
                    "]"}]}], " ", "-", " ", "\n", "                   ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"(", 
                    RowBox[{"rex", " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"Re", "[", "xb1", "]"}]}]}], ")"}], "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "ab"}], "]"}], 
                    "]"}]}]}]}], ";", " ", 
                    RowBox[{"rz", " ", "=", " ", 
                    RowBox[{"rez", "*", "\n", "                   ", 
                    RowBox[{"Re", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "ab"}], "]"}], "^", 
                    "2"}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "ab"}], "]"}], "^", 
                    "2"}]}], "]"}]}]}], ";", " ", 
                    RowBox[{"rx", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rx", "]"}]}], ";", " ", "\n", 
                    "                 ", 
                    RowBox[{"ry", " ", "=", " ", 
                    RowBox[{"Chop", "[", "ry", "]"}]}], ";", " ", 
                    RowBox[{"rz", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rz", "]"}]}], ";", " ", "\n", 
                    "                 ", 
                    RowBox[{"terminatedeflection", " ", "=", " ", "False"}], 
                    ";", " ", 
                    RowBox[{"intersections", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}], "}"}]}], ";", " ", 
                    RowBox[{
                    "intersections", " ", "=", " ", "\n", 
                    "                  ", "resonateintersections"}], ";", " ", 
                    RowBox[{"holeQ", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"holeQlist", "[", 
                    RowBox[{
                    "[", "\n", "                    ", "resonatenumber", 
                    "]"}], "]"}], " ", "==", " ", "1"}]}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "newcomponentnumber", ",", " ", "newsurfacenumber", ",", 
                    " ", "\n", "                   ", "newsurfaceid"}], "}"}],
                     " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"1.", ",", " ", "3.", ",", " ", "16547."}], 
                    "}"}]}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "componentnumber", ",", " ", "surfacenumber", ",", " ", 
                    "\n", "                   ", "surfaceid"}], "}"}], " ", 
                    "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"1.", ",", " ", "3.", ",", " ", "16547."}], 
                    "}"}]}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"ray1", ",", " ", "ray2", ",", " ", "ray3"}], 
                    "}"}], " ", "=", " ", "\n", "                  ", 
                    RowBox[{"intersections", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], ";", " ", 
                    RowBox[{"rsx", " ", "=", " ", "rex"}], ";", " ", 
                    RowBox[{
                    "rsy", " ", "=", " ", "\n", "                  ", "rey"}],
                     ";", " ", 
                    RowBox[{"rsz", " ", "=", " ", "rez"}], ";", " ", 
                    RowBox[{"rxhlp", " ", "=", " ", 
                    RowBox[{
                    "rx", " ", "+", " ", "\n", "                   ", 
                    RowBox[{"ray1", "*", "xunit"}]}]}], ";", " ", 
                    RowBox[{"ryhlp", " ", "=", " ", 
                    RowBox[{"ry", " ", "+", " ", 
                    RowBox[{
                    "ray1", "*", "\n", "                    ", "yunit"}]}]}], 
                    ";", " ", 
                    RowBox[{"rzhlp", " ", "=", " ", 
                    RowBox[{"rz", " ", "+", " ", 
                    RowBox[{"ray1", "*", "zunit"}]}]}], ";", " ", "\n", 
                    "                 ", 
                    RowBox[{"rex", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"Re", "[", "xb1", "]"}], " ", "+", " ", 
                    RowBox[{"rxhlp", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "ab"}], "]"}], 
                    "]"}]}], " ", "-", " ", 
                    RowBox[{
                    "1.", "*", "ryhlp", "*", "\n", "                    ", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "ab"}], "]"}], 
                    "]"}]}]}]}], ";", " ", 
                    RowBox[{"rey", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"Re", "[", "yb1", "]"}], " ", "+", " ", 
                    RowBox[{"ryhlp", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "ab"}], "]"}], 
                    "]"}]}], " ", "+", " ", "\n", "                   ", 
                    RowBox[{"rxhlp", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "ab"}], "]"}], 
                    "]"}]}]}]}], ";", " ", 
                    RowBox[{"rez", " ", "=", " ", 
                    RowBox[{"rzhlp", "*", "\n", "                   ", 
                    RowBox[{"Re", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "ab"}], "]"}], "^", 
                    "2"}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "ab"}], "]"}], "^", 
                    "2"}]}], "]"}]}]}], ";", " ", 
                    RowBox[{"rex", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rex", "]"}]}], ";", " ", "\n", 
                    "                 ", 
                    RowBox[{"rey", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rey", "]"}]}], ";", " ", 
                    RowBox[{"rez", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rez", "]"}]}], ";", " ", "\n", 
                    "                 ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"rex", " ", "==", " ", "0"}], " ", "&&", " ", 
                    RowBox[{"rey", " ", "==", " ", "0"}], " ", "&&", " ", 
                    RowBox[{"rez", " ", "==", " ", "0"}]}], ",", " ", 
                    RowBox[{
                    RowBox[{
                    "rex", " ", "=", " ", "\n", "                    ", 
                    RowBox[{"rxhlp", " ", "+", " ", 
                    RowBox[{"Re", "[", "xb1", "]"}]}]}], ";", " ", 
                    RowBox[{"rey", " ", "=", " ", 
                    RowBox[{"ryhlp", " ", "+", " ", 
                    RowBox[{"Re", "[", "yb1", "]"}]}]}], ";", " ", 
                    RowBox[{
                    "rez", " ", "=", " ", "\n", "                    ", 
                    "rzhlp"}]}], ",", " ", "rex"}], "]"}], ";", " ", 
                    RowBox[{"intersectionnumber", " ", "=", " ", 
                    RowBox[{
                    "intersectionnumber", " ", "+", " ", "\n", 
                    "                   ", "1."}]}], ";", " ", 
                    RowBox[{"opticallength", " ", "=", " ", 
                    RowBox[{"opticallength", " ", "+", " ", 
                    RowBox[{"ray1", "*", "index1"}]}]}], ";", " ", "\n", 
                    "                 ", 
                    RowBox[{"completedray", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "\n", "                   ", "rey", ",", " ", 
                    "rez", ",", " ", "r1", ",", " ", "r2", ",", " ", "r3", 
                    ",", " ", "\n", "                   ", "r4", ",", " ", 
                    "r5", ",", " ", "r6", ",", " ", "r7", ",", " ", "r8", ",",
                     " ", "\n", "                   ", "r9", ",", " ", 
                    "wavelength", ",", " ", "intensity", ",", " ", 
                    "intensityscale", ",", " ", "\n", "                   ", 
                    "ray1", ",", " ", "index", ",", " ", "opticallength", ",",
                     " ", "phaseshift", ",", " ", "\n", "                   ",
                     "componentnumber", ",", " ", "surfacenumber", ",", " ", 
                    "surfaceid", ",", " ", "ray2", ",", " ", "\n", 
                    "                   ", "ray3", ",", " ", "sid", ",", " ", 
                    "frontid", ",", " ", "sno1", ",", " ", "sno2", ",", " ", 
                    "\n", "                   ", "sno3", ",", " ", "sno4", 
                    ",", " ", "rayslot", ",", " ", "generationnumber", ",", 
                    " ", "\n", "                   ", "intersectionnumber", 
                    ",", " ", "pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}]}], ";", " ", "\n", "                 ", 
                    RowBox[{"reportedrayspresent", " ", "=", " ", "True"}], 
                    ";", " ", 
                    RowBox[{"intersectionspresent", " ", "=", " ", "True"}], 
                    ";", " ", 
                    RowBox[{
                    "deflectedrayspresent", " ", "=", " ", "\n", 
                    "                  ", "True"}], ";", " ", 
                    RowBox[{
                    "localdummyoutrayspresent", " ", "=", " ", "True"}], ";", 
                    " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    "surfnorm", " ", "=", " ", "\n", "                   ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"1.", ",", " ", 
                    RowBox[{
                    RowBox[{"-", "1."}], "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"ray2", "/", 
                    RowBox[{"Sign", "[", "cb1", "]"}]}], "/", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"cb1", "^", 
                    RowBox[{"(", 
                    RowBox[{"-", "2"}], ")"}]}], " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"ray2", "^", "2"}]}], " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"ray3", "^", "2"}]}]}], ")"}], "^", "0.5"}]}], 
                    ")"}]}], ",", " ", "\n", "                       ", 
                    RowBox[{
                    RowBox[{"-", "1."}], "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"ray3", "/", 
                    RowBox[{"Sign", "[", "cb1", "]"}]}], "/", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"cb1", "^", 
                    RowBox[{"(", 
                    RowBox[{"-", "2"}], ")"}]}], " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"ray2", "^", "2"}]}], " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"ray3", "^", "2"}]}]}], ")"}], "^", "0.5"}]}], 
                    ")"}]}]}], "}"}], ",", " ", "\n", 
                    "                      ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"ray2", "/", 
                    RowBox[{"Sign", "[", "cb1", "]"}]}], "/", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"cb1", "^", 
                    RowBox[{"(", 
                    RowBox[{"-", "2"}], ")"}]}], " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"ray2", "^", "2"}]}], " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"ray3", "^", "2"}]}]}], ")"}], "^", "0.5"}]}], 
                    ",", " ", "1.", ",", " ", "0."}], "}"}], ",", " ", "\n", 
                    "                      ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"ray3", "/", 
                    RowBox[{"Sign", "[", "cb1", "]"}]}], "/", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"cb1", "^", 
                    RowBox[{"(", 
                    RowBox[{"-", "2"}], ")"}]}], " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"ray2", "^", "2"}]}], " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"ray3", "^", "2"}]}]}], ")"}], "^", "0.5"}]}], 
                    ",", " ", "0.", ",", " ", "1."}], "}"}]}], "}"}], 
                    "]"}]}]}], ";", " ", "\n", "                  ", 
                    RowBox[{"dummymatrix", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "ab"}], "]"}], "]"}],
                     "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "ab"}], "]"}], "^", 
                    "2"}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "ab"}], "]"}], "^", 
                    "2"}]}], "]"}]}], ")"}], "/", "\n", 
                    "                         ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "ab"}], "]"}], "]"}],
                     "^", "2"}], "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "ab"}], "]"}], "^", 
                    "2"}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "ab"}], "]"}], "^", 
                    "2"}]}], "]"}]}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "ab"}], "]"}], "]"}],
                     "^", "2"}], "*", "\n", "                           ", 
                    RowBox[{"Re", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "ab"}], "]"}], "^", 
                    "2"}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "ab"}], "]"}], "^", 
                    "2"}]}], "]"}]}]}], ")"}]}], ",", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1."}], "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "ab"}], "]"}], "]"}],
                     "*", "\n", "                          ", 
                    RowBox[{"Re", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "ab"}], "]"}], "^", 
                    "2"}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "ab"}], "]"}], "^", 
                    "2"}]}], "]"}]}], ")"}], "/", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "ab"}], "]"}], "]"}],
                     "^", "2"}], "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "ab"}], "]"}], "^", 
                    "\n", "                              ", "2"}], " ", "+", 
                    " ", 
                    RowBox[{
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "ab"}], "]"}], "^", 
                    "2"}]}], "]"}]}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "ab"}], "]"}], "]"}],
                     "^", "2"}], "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "ab"}], "]"}], "^", 
                    "2"}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"Sin", "[", 
                    RowBox[{
                    "0.017453292519943295", "*", "\n", 
                    "                                ", "ab"}], "]"}], "^", 
                    "2"}]}], "]"}]}]}], ")"}]}], ",", " ", "0."}], "}"}], ",",
                     " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "ab"}], "]"}], "]"}],
                     "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "ab"}], "]"}], "^", 
                    "2"}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "ab"}], "]"}], "^", 
                    "2"}]}], "]"}]}], ")"}], "/", "\n", 
                    "                         ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "ab"}], "]"}], "]"}],
                     "^", "2"}], "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "ab"}], "]"}], "^", 
                    "2"}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "ab"}], "]"}], "^", 
                    "2"}]}], "]"}]}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "ab"}], "]"}], "]"}],
                     "^", "2"}], "*", "\n", "                           ", 
                    RowBox[{"Re", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "ab"}], "]"}], "^", 
                    "2"}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "ab"}], "]"}], "^", 
                    "2"}]}], "]"}]}]}], ")"}]}], ",", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "ab"}], "]"}], "]"}],
                     "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "ab"}], "]"}], "^", 
                    "\n", "                             ", "2"}], " ", "+", 
                    " ", 
                    RowBox[{
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "ab"}], "]"}], "^", 
                    "2"}]}], "]"}]}], ")"}], "/", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "ab"}], "]"}], "]"}],
                     "^", "2"}], "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "ab"}], "]"}], "^", 
                    "2"}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"Sin", "[", 
                    RowBox[{
                    "0.017453292519943295", "*", "\n", 
                    "                                ", "ab"}], "]"}], "^", 
                    "2"}]}], "]"}]}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "ab"}], "]"}], "]"}],
                     "^", "2"}], "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "ab"}], "]"}], "^", 
                    "2"}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "ab"}], "]"}], "^", 
                    "2"}]}], "]"}]}]}], ")"}]}], ",", " ", "0."}], "}"}], ",",
                     " ", "\n", "                       ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "0.", ",", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "ab"}], "]"}], "]"}],
                     "^", "2"}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "ab"}], "]"}], "]"}],
                     "^", "2"}]}], ")"}], "/", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "ab"}], "]"}], "]"}],
                     "^", "2"}], "*", "\n", "                           ", 
                    RowBox[{"Re", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "ab"}], "]"}], "^", 
                    "2"}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "ab"}], "]"}], "^", 
                    "2"}]}], "]"}]}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "ab"}], "]"}], "]"}],
                     "^", "2"}], "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "ab"}], "]"}], "^", 
                    "\n", "                              ", "2"}], " ", "+", 
                    " ", 
                    RowBox[{
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "ab"}], "]"}], "^", 
                    "2"}]}], "]"}]}]}], ")"}]}]}], "}"}]}], "}"}], " ", ".", 
                    " ", "#1"}], " ", "&"}], " ", ")"}], " ", "/@", " ", 
                    "surfnorm"}]}], ";", " ", 
                    RowBox[{
                    "surfnorm", " ", "=", " ", "\n", "                   ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"#1", "/", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"#1", " ", ".", " ", "#1"}], "]"}]}], " ", "&"}], 
                    " ", ")"}], " ", "/@", " ", "dummymatrix"}]}], ";", " ", 
                    RowBox[{"surfacerotationmatrix", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "ab"}], "]"}], "]"}],
                     ",", " ", "\n", "                     ", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "ab"}], "]"}], "]"}],
                     ",", " ", "0."}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "1."}], "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "ab"}], "]"}], 
                    "]"}]}], ",", " ", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "ab"}], "]"}], "]"}],
                     ",", " ", "0."}], "}"}], ",", " ", "\n", 
                    "                    ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "0.", ",", " ", 
                    RowBox[{"Re", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "ab"}], "]"}], "^", 
                    "2"}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "ab"}], "]"}], "^", 
                    "2"}]}], "]"}]}], "}"}]}], "}"}]}], ";", " ", 
                    RowBox[{
                    "surfacetranslationvector", " ", "=", " ", "\n", 
                    "                   ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Re", "[", "xb1", "]"}], ",", " ", 
                    RowBox[{"Re", "[", "yb1", "]"}], ",", " ", "0."}], 
                    "}"}]}], ";", " ", 
                    RowBox[{"activeregion", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"completedray", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "\n", "                    ", "rsy", ",",
                     " ", "rsz", ",", " ", "rex", ",", " ", "rey", ",", " ", 
                    "rez", ",", " ", "\n", "                    ", "r1", ",", 
                    " ", "r2", ",", " ", "r3", ",", " ", "r4", ",", " ", "r5",
                     ",", " ", "\n", "                    ", "r6", ",", " ", 
                    "r7", ",", " ", "r8", ",", " ", "r9", ",", " ", 
                    "wavelength", ",", " ", "\n", "                    ", 
                    "intensity", ",", " ", "intensityscale", ",", " ", "ray1",
                     ",", " ", "index", ",", " ", "\n", 
                    "                    ", "opticallength", ",", " ", 
                    "phaseshift", ",", " ", "componentnumber", ",", " ", "\n",
                     "                    ", "surfacenumber", ",", " ", 
                    "surfaceid", ",", " ", "ray2", ",", " ", "ray3", ",", " ",
                     "\n", "                    ", "sid", ",", " ", "frontid",
                     ",", " ", "sno1", ",", " ", "sno2", ",", " ", "sno3", 
                    ",", " ", "\n", "                    ", "sno4", ",", " ", 
                    "rayslot", ",", " ", "generationnumber", ",", " ", 
                    "intersectionnumber", ",", " ", "\n", 
                    "                    ", "pol1", ",", " ", "pol2", ",", 
                    " ", "pol3"}], "}"}]}], ";", " ", 
                    RowBox[{
                    "componentnumber", " ", "=", " ", "\n", 
                    "                   ", "newcomponentnumber"}], ";", " ", 
                    RowBox[{
                    "surfacenumber", " ", "=", " ", "newsurfacenumber"}], ";",
                     " ", "\n", "                  ", 
                    RowBox[{"surfaceid", " ", "=", " ", "newsurfaceid"}], ";",
                     " ", 
                    RowBox[{"originalray", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "\n", "                    ", "rsy", ",",
                     " ", "rsz", ",", " ", "rex", ",", " ", "rey", ",", " ", 
                    "rez", ",", " ", "\n", "                    ", "r1", ",", 
                    " ", "r2", ",", " ", "r3", ",", " ", "r4", ",", " ", "r5",
                     ",", " ", "\n", "                    ", "r6", ",", " ", 
                    "r7", ",", " ", "r8", ",", " ", "r9", ",", " ", 
                    "wavelength", ",", " ", "\n", "                    ", 
                    "intensity", ",", " ", "intensityscale", ",", " ", "ray1",
                     ",", " ", "index", ",", " ", "\n", 
                    "                    ", "opticallength", ",", " ", 
                    "phaseshift", ",", " ", "componentnumber", ",", " ", "\n",
                     "                    ", "surfacenumber", ",", " ", 
                    "surfaceid", ",", " ", "ray2", ",", " ", "ray3", ",", " ",
                     "\n", "                    ", "sid", ",", " ", "frontid",
                     ",", " ", "sno1", ",", " ", "sno2", ",", " ", "sno3", 
                    ",", " ", "\n", "                    ", "sno4", ",", " ", 
                    "rayslot", ",", " ", "generationnumber", ",", " ", 
                    "intersectionnumber", ",", " ", "\n", 
                    "                    ", "pol1", ",", " ", "pol2", ",", 
                    " ", "pol3"}], "}"}]}], ";", " ", 
                    RowBox[{
                    "ZAxis", " ", "=", " ", "\n", "                   ", 
                    RowBox[{
                    RowBox[{"First", "[", "surfnorm", "]"}], "*", 
                    RowBox[{"Sign", "[", 
                    RowBox[{
                    RowBox[{"First", "[", "surfnorm", "]"}], " ", ".", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "r1", ",", " ", "r2", ",", " ", "\n", 
                    "                       ", "r3"}], "}"}]}], "]"}]}]}], 
                    ";", " ", 
                    RowBox[{"raytiltz", " ", "=", " ", 
                    RowBox[{"ZAxis", " ", ".", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "r1", ",", " ", "\n", "                     ", "r2", ",", 
                    " ", "r3"}], "}"}]}]}], ";", " ", 
                    RowBox[{"raytiltx", " ", "=", " ", 
                    RowBox[{"1", " ", "-", " ", 
                    RowBox[{"raytiltz", "^", "2"}]}]}], ";", " ", "\n", 
                    "                  ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    "raytiltx", " ", "<", " ", "2.220446049250313*^-16"}], 
                    ",", " ", 
                    RowBox[{"raytiltx", " ", "=", " ", "0."}], ",", " ", 
                    RowBox[{
                    "raytiltx", " ", "=", " ", "\n", "                    ", 
                    RowBox[{"Sqrt", "[", "raytiltx", "]"}]}]}], "]"}], ";", 
                    " ", 
                    RowBox[{"XAxis", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "r1", ",", " ", "r2", ",", " ", "\n", 
                    "                     ", "r3"}], "}"}], " ", "-", " ", 
                    RowBox[{"ZAxis", "*", "raytiltz"}]}]}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", "raytiltx", "]"}], " ", "<", " ", 
                    "1.*^-7"}], ",", " ", "\n", "                   ", 
                    RowBox[{"XAxis", " ", "=", " ", 
                    RowBox[{"surfnorm", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], ",", " ", 
                    RowBox[{"XAxis", " ", "=", " ", 
                    RowBox[{
                    "XAxis", "/", "\n", "                     ", 
                    "raytiltx"}]}]}], "]"}], ";", " ", 
                    RowBox[{"YAxis", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"ZAxis", "[", 
                    RowBox[{"[", "3", "]"}], "]"}], "*", 
                    RowBox[{"XAxis", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], ")"}]}], " ", "+", " ", 
                    "\n", "                     ", 
                    RowBox[{
                    RowBox[{"ZAxis", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "*", 
                    RowBox[{"XAxis", "[", 
                    RowBox[{"[", "3", "]"}], "]"}]}]}], ",", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"ZAxis", "[", 
                    RowBox[{"[", "3", "]"}], "]"}], "*", 
                    RowBox[{"XAxis", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], " ", "-", " ", "\n", 
                    "                     ", 
                    RowBox[{
                    RowBox[{"ZAxis", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "*", 
                    RowBox[{"XAxis", "[", 
                    RowBox[{"[", "3", "]"}], "]"}]}]}], ",", " ", 
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"ZAxis", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "*", 
                    RowBox[{"XAxis", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], ")"}]}], " ", "+", " ", 
                    "\n", "                     ", 
                    RowBox[{
                    RowBox[{"ZAxis", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "*", 
                    RowBox[{"XAxis", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}]}]}], "}"}]}], ";", " ", 
                    RowBox[{"YAxis", " ", "=", " ", 
                    RowBox[{"YAxis", "/", "\n", "                    ", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"YAxis", " ", ".", " ", "YAxis"}], "]"}]}]}], ";",
                     " ", 
                    RowBox[{"PAxis", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"ZAxis", "*", "\n", "                     ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    " ", ".", " ", "XAxis"}]}], " ", "-", " ", 
                    RowBox[{"XAxis", "*", "\n", "                     ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    " ", ".", " ", "ZAxis"}]}]}]}], ";", " ", 
                    RowBox[{
                    "PAxis", " ", "=", " ", "\n", "                   ", 
                    RowBox[{"PAxis", "/", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"PAxis", " ", ".", " ", "PAxis"}], "]"}]}]}], ";",
                     " ", 
                    RowBox[{
                    "normalizedpolarization", " ", "=", " ", "\n", 
                    "                   ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], "[", 
                    RowBox[{"[", 
                    RowBox[{"{", 
                    RowBox[{"1", ",", " ", "2"}], "}"}], "]"}], "]"}]}], ";", 
                    " ", 
                    RowBox[{
                    "normalizedpolarization", " ", "=", " ", "\n", 
                    "                   ", 
                    RowBox[{"normalizedpolarization", "/", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{
                    "normalizedpolarization", " ", ".", " ", 
                    "normalizedpolarization"}], "]"}]}]}], ";", " ", "\n", 
                    "                  ", 
                    RowBox[{"allcreatedamplitudes", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"0.", "*", "I"}], ",", " ", 
                    RowBox[{"0.", "*", "I"}], ",", " ", 
                    RowBox[{"0.", "*", "I"}]}], "}"}], "}"}]}], ";", " ", 
                    RowBox[{"amplitude", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"Sqrt", "[", "intensity", "]"}], "*", "\n", 
                    "                    ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"normalizedpolarization", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "*", 
                    RowBox[{"{", 
                    RowBox[{"r4", ",", " ", "r5", ",", " ", "r6"}], "}"}]}], 
                    " ", "+", " ", "\n", "                     ", 
                    RowBox[{
                    RowBox[{"normalizedpolarization", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "*", 
                    RowBox[{"{", 
                    RowBox[{"r7", ",", " ", "r8", ",", " ", "r9"}], "}"}], 
                    "*", "\n", "                      ", 
                    RowBox[{"Exp", "[", 
                    RowBox[{"I", "*", "pol3", "*", "0.017453292519943295"}], 
                    "]"}]}]}], ")"}]}]}], ";", " ", 
                    RowBox[{"perpendicularamplitude", " ", "=", " ", 
                    RowBox[{
                    "amplitude", " ", ".", " ", "\n", "                    ", 
                    "YAxis"}]}], ";", " ", 
                    RowBox[{"parallelamplitude", " ", "=", " ", 
                    RowBox[{"amplitude", " ", ".", " ", "PAxis"}]}], ";", " ",
                     "\n", "                  ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"activeregion", "*", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"surfacerotationmatrix", " ", ".", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "r1", ",", " ", "r2", ",", " ", "\n", 
                    "                        ", "r3"}], "}"}]}], ")"}], "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], " ", ">", " ", "0"}], 
                    ",", " ", 
                    RowBox[{
                    RowBox[{"index2", " ", "=", " ", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"3.0539614", " ", "-", " ", 
                    RowBox[{"0.011580432", "*", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", "\n", 
                    "                       ", 
                    RowBox[{"0.039199816", "/", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", 
                    RowBox[{"0.0029462812", "/", 
                    RowBox[{"wavelength", "^", "4"}]}], " ", "-", " ", 
                    RowBox[{
                    "0.00020371019000000004", "/", "\n", 
                    "                        ", 
                    RowBox[{"wavelength", "^", "6"}]}], " ", "+", " ", 
                    RowBox[{"0.000027633568999999998", "/", 
                    RowBox[{"wavelength", "^", "8"}]}]}], "]"}]}], ";", " ", 
                    RowBox[{
                    "index1", " ", "=", " ", "\n", "                     ", 
                    "index"}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", 
                    RowBox[{"index2", " ", "-", " ", "index1"}], "]"}], " ", 
                    "<", " ", "0.01"}], ",", " ", 
                    RowBox[{
                    RowBox[{
                    "alternateindex", " ", "=", " ", "\n", 
                    "                       ", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"1.0005281111748805", " ", "-", " ", 
                    RowBox[{"2.364805676582992*^-10", "*", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", 
                    RowBox[{"2.9781670902982902*^-6", "/", 
                    RowBox[{
                    "wavelength", "^", "\n", "                           ", 
                    "2"}]}], " ", "+", " ", 
                    RowBox[{"2.6004099469477187*^-8", "/", 
                    RowBox[{"wavelength", "^", "4"}]}], " ", "+", " ", 
                    RowBox[{"3.7787839314048715*^-10", "/", 
                    RowBox[{"wavelength", "^", "6"}]}], " ", "+", " ", "\n", 
                    "                         ", 
                    RowBox[{"2.830549017940716*^-12", "/", 
                    RowBox[{"wavelength", "^", "8"}]}]}], "]"}]}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", 
                    RowBox[{"alternateindex", " ", "-", " ", "index1"}], 
                    "]"}], " ", ">", " ", "\n", "                        ", 
                    RowBox[{"Abs", "[", 
                    RowBox[{"index2", " ", "-", " ", "index1"}], "]"}]}], ",",
                     " ", 
                    RowBox[{
                    RowBox[{"index1", " ", "=", " ", "index2"}], ";", " ", 
                    "\n", "                        ", 
                    RowBox[{"index2", " ", "=", " ", "alternateindex"}]}], 
                    ",", " ", 
                    RowBox[{"index1", " ", "=", " ", "alternateindex"}]}], 
                    "]"}]}], ",", " ", "\n", "                     ", 
                    RowBox[{"index1", " ", "=", " ", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"1.0005281111748805", " ", "-", " ", 
                    RowBox[{"2.364805676582992*^-10", "*", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", 
                    RowBox[{
                    "2.9781670902982902*^-6", "/", "\n", 
                    "                         ", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", 
                    RowBox[{"2.6004099469477187*^-8", "/", 
                    RowBox[{"wavelength", "^", "4"}]}], " ", "+", " ", 
                    RowBox[{
                    "3.7787839314048715*^-10", "/", "\n", 
                    "                         ", 
                    RowBox[{"wavelength", "^", "6"}]}], " ", "+", " ", 
                    RowBox[{"2.830549017940716*^-12", "/", 
                    RowBox[{"wavelength", "^", "8"}]}]}], "]"}]}]}], "]"}]}], 
                    ",", " ", 
                    RowBox[{
                    RowBox[{
                    "index2", " ", "=", " ", "\n", "                     ", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"1.0005281111748805", " ", "-", " ", 
                    RowBox[{"2.364805676582992*^-10", "*", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", 
                    RowBox[{"2.9781670902982902*^-6", "/", 
                    RowBox[{
                    "wavelength", "^", "\n", "                         ", 
                    "2"}]}], " ", "+", " ", 
                    RowBox[{"2.6004099469477187*^-8", "/", 
                    RowBox[{"wavelength", "^", "4"}]}], " ", "+", " ", 
                    RowBox[{"3.7787839314048715*^-10", "/", 
                    RowBox[{"wavelength", "^", "6"}]}], " ", "+", " ", "\n", 
                    "                       ", 
                    RowBox[{"2.830549017940716*^-12", "/", 
                    RowBox[{"wavelength", "^", "8"}]}]}], "]"}]}], ";", " ", 
                    RowBox[{"index1", " ", "=", " ", "index"}], ";", " ", 
                    "\n", "                    ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", 
                    RowBox[{"index2", " ", "-", " ", "index1"}], "]"}], " ", 
                    "<", " ", "0.01"}], ",", " ", 
                    RowBox[{
                    RowBox[{"alternateindex", " ", "=", " ", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{
                    "3.0539614", " ", "-", " ", "\n", 
                    "                         ", 
                    RowBox[{"0.011580432", "*", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", 
                    RowBox[{"0.039199816", "/", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", 
                    RowBox[{
                    "0.0029462812", "/", "\n", "                          ", 
                    RowBox[{"wavelength", "^", "4"}]}], " ", "-", " ", 
                    RowBox[{"0.00020371019000000004", "/", 
                    RowBox[{"wavelength", "^", "6"}]}], " ", "+", " ", 
                    RowBox[{
                    "0.000027633568999999998", "/", "\n", 
                    "                          ", 
                    RowBox[{"wavelength", "^", "8"}]}]}], "]"}]}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", 
                    RowBox[{"alternateindex", " ", "-", " ", "index1"}], 
                    "]"}], " ", ">", " ", "\n", "                        ", 
                    RowBox[{"Abs", "[", 
                    RowBox[{"index2", " ", "-", " ", "index1"}], "]"}]}], ",",
                     " ", 
                    RowBox[{
                    RowBox[{"index1", " ", "=", " ", "index2"}], ";", " ", 
                    "\n", "                        ", 
                    RowBox[{"index2", " ", "=", " ", "alternateindex"}]}], 
                    ",", " ", 
                    RowBox[{"index1", " ", "=", " ", "alternateindex"}]}], 
                    "]"}]}], ",", " ", "\n", "                     ", 
                    RowBox[{"index1", " ", "=", " ", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"3.0539614", " ", "-", " ", 
                    RowBox[{"0.011580432", "*", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", 
                    RowBox[{"0.039199816", "/", 
                    RowBox[{
                    "wavelength", "^", "\n", "                          ", 
                    "2"}]}], " ", "+", " ", 
                    RowBox[{"0.0029462812", "/", 
                    RowBox[{"wavelength", "^", "4"}]}], " ", "-", " ", 
                    RowBox[{"0.00020371019000000004", "/", 
                    RowBox[{"wavelength", "^", "6"}]}], " ", "+", " ", 
                    RowBox[{
                    "0.000027633568999999998", "/", "\n", 
                    "                         ", 
                    RowBox[{"wavelength", "^", "8"}]}]}], "]"}]}]}], 
                    "]"}]}]}], "]"}], ";", " ", 
                    RowBox[{"n12", " ", "=", " ", 
                    RowBox[{"index1", "/", "index2"}]}], ";", " ", "\n", 
                    "                  ", 
                    RowBox[{"index", " ", "=", " ", "index2"}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"1", " ", "-", " ", 
                    RowBox[{
                    RowBox[{"n12", "^", "2"}], "*", 
                    RowBox[{"raytiltx", "^", "2"}]}]}], " ", ">=", " ", 
                    "0."}], ",", " ", "\n", "                   ", 
                    RowBox[{
                    RowBox[{"dummyvector", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"n12", "*", 
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}]}], 
                    " ", "+", " ", "\n", "                      ", 
                    RowBox[{"ZAxis", "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"(", 
                    RowBox[{"n12", "*", "raytiltz"}], ")"}]}], " ", "+", " ", 
                    
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"1", " ", "-", " ", 
                    RowBox[{
                    RowBox[{"n12", "^", "2"}], "*", "\n", 
                    "                           ", 
                    RowBox[{"raytiltx", "^", "2"}]}]}], "]"}]}], ")"}]}]}]}], 
                    ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    " ", "=", " ", "\n", "                     ", 
                    "dummyvector"}], ";", " ", "1."}], ",", " ", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    " ", ".", " ", "\n", "                       ", 
                    RowBox[{"surfnorm", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], " ", ">", " ", "0"}], 
                    ",", " ", 
                    RowBox[{"phaseshift", " ", "=", " ", 
                    RowBox[{"phaseshift", " ", "+", " ", "0.5"}]}], ",", " ", 
                    "1."}], "]"}], ";", " ", "\n", "                    ", 
                    RowBox[{"index2", " ", "=", " ", "index1"}], ";", " ", 
                    RowBox[{"index", " ", "=", " ", "index1"}], ";", " ", 
                    "\n", "                    ", 
                    RowBox[{"dummyvector", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    " ", "-", " ", "\n", "                      ", 
                    RowBox[{"2", "*", "ZAxis", "*", 
                    RowBox[{"ZAxis", " ", ".", " ", 
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], 
                    "}"}]}]}]}]}], ";", " ", "\n", "                    ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    " ", "=", " ", "dummyvector"}], ";", " ", "\n", 
                    "                    ", 
                    RowBox[{"dummyvector", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], " ", "+", " ", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", " ", "0", ",", " ", 
                    RowBox[{"-", "180"}]}], "}"}]}]}], ";", " ", "\n", 
                    "                    ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], " ", "=", " ", "dummyvector"}], ";", " ", "1."}]}],
                     "]"}], ";", " ", "\n", "                  ", 
                    RowBox[{"allcreatedrays", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "\n", 
                    "                     ", "rex", ",", " ", "rey", ",", " ",
                     "rez", ",", " ", "r1", ",", " ", "r2", ",", " ", "\n", 
                    "                     ", "r3", ",", " ", "r4", ",", " ", 
                    "r5", ",", " ", "r6", ",", " ", "r7", ",", " ", "\n", 
                    "                     ", "r8", ",", " ", "r9", ",", " ", 
                    "wavelength", ",", " ", "intensity", ",", " ", "\n", 
                    "                     ", "intensityscale", ",", " ", 
                    "ray1", ",", " ", "index", ",", " ", "opticallength", ",",
                     " ", "\n", "                     ", "phaseshift", ",", 
                    " ", "componentnumber", ",", " ", "surfacenumber", ",", 
                    " ", "surfaceid", ",", " ", "\n", "                     ",
                     "ray2", ",", " ", "ray3", ",", " ", "sid", ",", " ", 
                    "frontid", ",", " ", "sno1", ",", " ", "\n", 
                    "                     ", "sno2", ",", " ", "sno3", ",", 
                    " ", "sno4", ",", " ", "rayslot", ",", " ", "\n", 
                    "                     ", "generationnumber", ",", " ", 
                    "intersectionnumber", ",", " ", "pol1", ",", " ", "pol2", 
                    ",", " ", "\n", "                     ", "pol3"}], "}"}], 
                    "}"}]}], ";", " ", 
                    RowBox[{"originalrotation", " ", "=", " ", 
                    RowBox[{"Partition", "[", 
                    RowBox[{
                    RowBox[{"Take", "[", 
                    RowBox[{"originalray", ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"7", ",", " ", "15"}], "}"}]}], "]"}], ",", " ", 
                    "3"}], "]"}]}], ";", " ", "\n", "                  ", 
                    RowBox[{"previoustilt", " ", "=", " ", 
                    RowBox[{"originalrotation", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], ";", " ", 
                    RowBox[{
                    "transmatrix", " ", "=", " ", "\n", "                   ", 
                    RowBox[{"MapIndexed", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "\n", "                        ", "rey", ",", 
                    " ", "rez", ",", " ", "r1", ",", " ", "r2", ",", " ", 
                    "r3", ",", " ", "\n", "                        ", "r4", 
                    ",", " ", "r5", ",", " ", "r6", ",", " ", "r7", ",", " ", 
                    "r8", ",", " ", "\n", "                        ", "r9", 
                    ",", " ", "wavelength", ",", " ", "intensity", ",", " ", 
                    "intensityscale", ",", " ", "\n", 
                    "                        ", "ray1", ",", " ", "index", 
                    ",", " ", "opticallength", ",", " ", "phaseshift", ",", 
                    " ", "\n", "                        ", "componentnumber", 
                    ",", " ", "surfacenumber", ",", " ", "surfaceid", ",", 
                    " ", "ray2", ",", " ", "\n", "                        ", 
                    "ray3", ",", " ", "sid", ",", " ", "frontid", ",", " ", 
                    "sno1", ",", " ", "sno2", ",", " ", "\n", 
                    "                        ", "sno3", ",", " ", "sno4", ",",
                     " ", "rayslot", ",", " ", "oldgenerationnumber", ",", 
                    " ", "\n", "                        ", 
                    "intersectionnumber", ",", " ", "pol1", ",", " ", "pol2", 
                    ",", " ", "pol3"}], "}"}], " ", "=", " ", "#1"}], ";", 
                    " ", "\n", "                      ", 
                    RowBox[{"rotationaxis", " ", "=", " ", 
                    RowBox[{"Cross", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"1.", ",", " ", "0.", ",", " ", "0."}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}]}], 
                    "]"}]}], ";", " ", "\n", "                      ", 
                    RowBox[{"axismagnitude", " ", "=", " ", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"rotationaxis", " ", ".", " ", "rotationaxis"}], 
                    "]"}]}], ";", " ", "\n", "                      ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Chop", "[", "axismagnitude", "]"}], " ", "!=", 
                    " ", "0."}], ",", " ", 
                    RowBox[{
                    RowBox[{"rotationaxis", " ", "=", " ", 
                    RowBox[{
                    "rotationaxis", "/", "\n", "                          ", 
                    "axismagnitude"}]}], ";", " ", 
                    RowBox[{"axismatrix", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"#1", "*", "rotationaxis"}], " ", "&"}], " ", 
                    ")"}], " ", "/@", " ", "\n", "                          ",
                     "rotationaxis"}]}], ";", " ", 
                    RowBox[{"crossmatrix", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", 
                    RowBox[{"-", 
                    RowBox[{"rotationaxis", "[", 
                    RowBox[{"[", "3", "]"}], "]"}]}], ",", " ", "\n", 
                    "                           ", 
                    RowBox[{"rotationaxis", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"rotationaxis", "[", 
                    RowBox[{"[", "3", "]"}], "]"}], ",", " ", "0.", ",", " ", 
                    
                    RowBox[{"-", 
                    RowBox[{"rotationaxis", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}]}], "}"}], ",", " ", "\n",
                     "                          ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"rotationaxis", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], ",", " ", 
                    RowBox[{"rotationaxis", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], ",", " ", "0."}], "}"}]}],
                     "}"}]}], ";", " ", 
                    RowBox[{
                    "cosangle", " ", "=", " ", "\n", 
                    "                         ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"1.", ",", " ", "0.", ",", " ", "0."}], "}"}], 
                    " ", ".", " ", 
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}]}]}],
                     ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"1.", " ", "-", " ", "cosangle"}], " ", "<", " ", 
                    "\n", "                          ", 
                    "2.220446049250313*^-16"}], ",", " ", 
                    RowBox[{"cosangle", " ", "=", " ", "1."}]}], "]"}], ";", 
                    " ", 
                    RowBox[{"sinangle", " ", "=", " ", 
                    RowBox[{"1", " ", "-", " ", 
                    RowBox[{"cosangle", "^", "2"}]}]}], ";", " ", "\n", 
                    "                        ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    "sinangle", " ", "<", " ", "2.220446049250313*^-16"}], 
                    ",", " ", 
                    RowBox[{"sinangle", " ", "=", " ", "0."}], ",", " ", 
                    RowBox[{
                    "sinangle", " ", "=", " ", "\n", 
                    "                          ", 
                    RowBox[{"Sqrt", "[", "sinangle", "]"}]}]}], "]"}], ";", 
                    " ", 
                    RowBox[{"axismatrix", " ", "+", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"1.", ",", " ", "0.", ",", " ", "0."}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "1.", ",", " ", "0."}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "0.", ",", " ", "1."}], "}"}]}], 
                    "}"}], " ", "-", " ", "\n", "                           ",
                     "axismatrix"}], ")"}], "*", "cosangle"}], " ", "+", " ", 
                    
                    RowBox[{"crossmatrix", "*", "sinangle"}]}]}], ",", " ", 
                    "\n", "                       ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "r4", ",", " ", "r5", ",", " ", "\n", 
                    "                          ", "r6"}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"r7", ",", " ", "r8", ",", " ", "r9"}], "}"}]}], 
                    "}"}], " ", "=", " ", "\n", "                        ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Sign", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"1.", ",", " ", "0.", ",", " ", "0."}], "}"}], 
                    " ", ".", " ", 
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}]}], 
                    "]"}], " ", "===", " ", "1"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"1.", ",", " ", "0.", ",", " ", "0."}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "1.", ",", " ", "0."}], "}"}], 
                    ",", " ", "\n", "                          ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "0.", ",", " ", "1."}], "}"}]}], 
                    "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", 
                    RowBox[{"-", "1."}], ",", " ", "0."}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "0.", ",", " ", "1."}], "}"}]}], 
                    "}"}]}], "]"}]}]}], "]"}]}], ")"}], " ", "&"}], " ", ",", 
                    " ", "allcreatedrays"}], "]"}]}], ";", " ", "\n", 
                    "                  ", 
                    RowBox[{"allcreatedrays", " ", "=", " ", 
                    RowBox[{"MapIndexed", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "\n", 
                    "                        ", "rex", ",", " ", "rey", ",", 
                    " ", "rez", ",", " ", "r1", ",", " ", "r2", ",", " ", 
                    "\n", "                        ", "r3", ",", " ", "r4", 
                    ",", " ", "r5", ",", " ", "r6", ",", " ", "r7", ",", " ", 
                    "\n", "                        ", "r8", ",", " ", "r9", 
                    ",", " ", "wavelength", ",", " ", "intensity", ",", " ", 
                    "\n", "                        ", "intensityscale", ",", 
                    " ", "ray1", ",", " ", "index", ",", " ", "opticallength",
                     ",", " ", "\n", "                        ", "phaseshift",
                     ",", " ", "componentnumber", ",", " ", "surfacenumber", 
                    ",", " ", "\n", "                        ", "surfaceid", 
                    ",", " ", "ray2", ",", " ", "ray3", ",", " ", "sid", ",", 
                    " ", "\n", "                        ", "frontid", ",", 
                    " ", "sno1", ",", " ", "sno2", ",", " ", "sno3", ",", " ",
                     "\n", "                        ", "sno4", ",", " ", 
                    "rayslot", ",", " ", "oldgenerationnumber", ",", " ", 
                    "\n", "                        ", "intersectionnumber", 
                    ",", " ", "pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], " ", "=", " ", "#1"}], ";", " ", "\n", 
                    "                      ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "r4", ",", " ", "r5", ",", " ", "\n", 
                    "                         ", "r6"}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"r7", ",", " ", "r8", ",", " ", "r9"}], "}"}]}], 
                    "}"}], " ", "=", " ", "\n", "                       ", 
                    RowBox[{
                    RowBox[{"Function", "[", 
                    RowBox[{"mm", ",", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"mm", " ", ".", " ", "#1"}], " ", "&"}], " ", 
                    ")"}], " ", "/@", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"1.", ",", " ", "0.", ",", " ", "0."}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "1.", ",", " ", "0."}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "0.", ",", " ", "1."}], "}"}]}], 
                    "}"}]}]}], "]"}], "[", "\n", "                        ", 
                    RowBox[{"transmatrix", "[", 
                    RowBox[{"[", 
                    RowBox[{"First", "[", "#2", "]"}], "]"}], "]"}], "]"}]}], 
                    ";", " ", 
                    RowBox[{"tiltmagnitude", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "r1", ",", " ", "r2", ",", " ", "\n", 
                    "                         ", "r3"}], "}"}], " ", ".", " ", 
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}]}]}],
                     ";", " ", "\n", "                      ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", 
                    RowBox[{"tiltmagnitude", " ", "-", " ", "1."}], "]"}], 
                    " ", ">", " ", "1.*^-6"}], ",", " ", 
                    RowBox[{
                    RowBox[{"dummyvector", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "r1", ",", " ", "\n", "                           ", "r2",
                     ",", " ", "r3"}], "}"}], "/", 
                    RowBox[{"Sqrt", "[", "tiltmagnitude", "]"}]}]}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "r1", ",", " ", "\n", "                          ", "r2", 
                    ",", " ", "r3"}], "}"}], " ", "=", " ", "dummyvector"}], 
                    ";", " ", 
                    RowBox[{
                    "dummymatrix", " ", "=", " ", "\n", 
                    "                         ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"#1", "/", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"#1", " ", ".", " ", "#1"}], "]"}]}], " ", "&"}], 
                    " ", ")"}], " ", "/@", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "r4", ",", " ", "\n", "                            ", 
                    "r5", ",", " ", "r6"}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"r7", ",", " ", "r8", ",", " ", "r9"}], "}"}]}], 
                    "}"}]}]}], ";", " ", "\n", "                        ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "r4", ",", " ", "r5", ",", " ", "\n", 
                    "                           ", "r6"}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"r7", ",", " ", "r8", ",", " ", "r9"}], "}"}]}], 
                    "}"}], " ", "=", " ", "\n", "                         ", 
                    "dummymatrix"}], ";", " ", "1."}], ",", " ", "1."}], 
                    "]"}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"allcreatedamplitudes", " ", "!=", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"0.", "*", "I"}], ",", " ", 
                    RowBox[{"0.", "*", "I"}], ",", " ", 
                    RowBox[{"0.", "*", "I"}]}], "}"}], "}"}]}], ",", " ", 
                    "\n", "                       ", 
                    RowBox[{
                    RowBox[{"amplitude", " ", "=", " ", 
                    RowBox[{"allcreatedamplitudes", "[", 
                    RowBox[{"[", 
                    RowBox[{"First", "[", "#2", "]"}], "]"}], "]"}]}], ";", 
                    " ", 
                    RowBox[{
                    "hor", " ", "=", " ", "\n", "                         ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r4", ",", " ", "r5", ",", " ", "r6"}], "}"}], 
                    " ", ".", " ", "amplitude"}]}], ";", " ", "\n", 
                    "                        ", 
                    RowBox[{"ver", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r7", ",", " ", "r8", ",", " ", "r9"}], "}"}], 
                    " ", ".", " ", "amplitude"}]}], ";", " ", "\n", 
                    "                        ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", "hor", "]"}], " ", ">", " ", "0."}], 
                    " ", "||", " ", 
                    RowBox[{
                    RowBox[{"Abs", "[", "ver", "]"}], " ", ">", " ", "0."}]}],
                     ",", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "pol1", ",", " ", "pol2", ",", " ", "\n", 
                    "                            ", "pol3"}], "}"}], " ", "=",
                     " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Abs", "[", "hor", "]"}], ",", " ", 
                    RowBox[{"Abs", "[", "ver", "]"}], ",", " ", "0."}], 
                    "}"}]}], ";", " ", 
                    RowBox[{
                    "dummyvector", " ", "=", " ", "\n", 
                    "                           ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], "/", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "pol1", ",", " ", "\n", "                               ",
                     "pol2", ",", " ", "pol3"}], "}"}], " ", ".", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "pol1", ",", " ", "pol2", ",", " ", "\n", 
                    "                               ", "pol3"}], "}"}]}], 
                    "]"}]}]}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], " ", "=", " ", "\n", "                           ",
                     "dummyvector"}], ";", " ", 
                    RowBox[{"dummyvector", " ", "=", " ", 
                    RowBox[{"ReplacePart", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "pol1", ",", " ", "\n", "                             ", 
                    "pol2", ",", " ", "pol3"}], "}"}], ",", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"ver", " ", "==", " ", "0."}], ",", " ", "0.", 
                    ",", " ", 
                    RowBox[{"Arg", "[", "ver", "]"}]}], "]"}], " ", "-", " ", 
                    "\n", "                              ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"hor", " ", "==", " ", "0."}], ",", " ", "0.", 
                    ",", " ", 
                    RowBox[{"Arg", "[", "hor", "]"}]}], "]"}]}], ")"}], "/", 
                    "Degree"}], ",", " ", "3"}], "]"}]}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "pol1", ",", " ", "\n", "                            ", 
                    "pol2", ",", " ", "pol3"}], "}"}], " ", "=", " ", 
                    "dummyvector"}]}]}], "]"}], ";", " ", "1."}], ",", " ", 
                    "1."}], "]"}], ";", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "\n", "                       ", "rsy", 
                    ",", " ", "rsz", ",", " ", "rex", ",", " ", "rey", ",", 
                    " ", "rez", ",", " ", "\n", "                       ", 
                    "r1", ",", " ", "r2", ",", " ", "r3", ",", " ", "r4", ",",
                     " ", "r5", ",", " ", "\n", "                       ", 
                    "r6", ",", " ", "r7", ",", " ", "r8", ",", " ", "r9", ",",
                     " ", "wavelength", ",", " ", "\n", 
                    "                       ", "intensity", ",", " ", 
                    "intensityscale", ",", " ", "ray1", ",", " ", "index", 
                    ",", " ", "\n", "                       ", 
                    "opticallength", ",", " ", "phaseshift", ",", " ", 
                    "componentnumber", ",", " ", "\n", 
                    "                       ", "surfacenumber", ",", " ", 
                    "surfaceid", ",", " ", "ray2", ",", " ", "ray3", ",", " ",
                     "\n", "                       ", "sid", ",", " ", 
                    "frontid", ",", " ", "sno1", ",", " ", "sno2", ",", " ", 
                    "sno3", ",", " ", "\n", "                       ", "sno4",
                     ",", " ", "rayslot", ",", " ", "generationnumber", ",", 
                    " ", "intersectionnumber", ",", " ", "\n", 
                    "                       ", "pol1", ",", " ", "pol2", ",", 
                    " ", "pol3"}], "}"}]}], ")"}], " ", "&"}], " ", ",", " ", 
                    "allcreatedrays"}], "]"}]}]}], ")"}], ";", " ", "\n", 
                    "                 ", 
                    RowBox[{"{", 
                    RowBox[{"allcreatedrays", ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",",
                     " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", 
                    "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",",
                     " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", 
                    "1.", ",", " ", "1.", ",", " ", 
                    RowBox[{"-", "1.7976931348623157*^308"}], ",", " ", "1.", 
                    ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", 
                    "\n", "                    ", "0.", ",", " ", 
                    RowBox[{"-", "1."}], ",", " ", 
                    RowBox[{"-", "1."}], ",", " ", 
                    RowBox[{"-", "1."}], ",", " ", "1.", ",", " ", "1.", ",", 
                    " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.",
                     ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ",
                     "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", 
                    ",", " ", "1."}], "}"}], "}"}], ",", " ", 
                    RowBox[{"{", "completedray", "}"}]}], "}"}]}], ",", " ", 
                    "\n", "                ", 
                    RowBox[{"resonatenumber", " ", "==", " ", "4"}], ",", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "\n", 
                    "                   ", "rex", ",", " ", "rey", ",", " ", 
                    "rez", ",", " ", "r1", ",", " ", "r2", ",", " ", "\n", 
                    "                   ", "r3", ",", " ", "r4", ",", " ", 
                    "r5", ",", " ", "r6", ",", " ", "r7", ",", " ", "\n", 
                    "                   ", "r8", ",", " ", "r9", ",", " ", 
                    "wavelength", ",", " ", "intensity", ",", " ", "\n", 
                    "                   ", "intensityscale", ",", " ", "ray1",
                     ",", " ", "index", ",", " ", "opticallength", ",", " ", 
                    "\n", "                   ", "phaseshift", ",", " ", 
                    "componentnumber", ",", " ", "surfacenumber", ",", " ", 
                    "surfaceid", ",", " ", "\n", "                   ", 
                    "ray2", ",", " ", "ray3", ",", " ", "sid", ",", " ", 
                    "frontid", ",", " ", "sno1", ",", " ", "\n", 
                    "                   ", "sno2", ",", " ", "sno3", ",", " ",
                     "sno4", ",", " ", "rayslot", ",", " ", "\n", 
                    "                   ", "oldgenerationnumber", ",", " ", 
                    "intersectionnumber", ",", " ", "pol1", ",", " ", "pol2", 
                    ",", " ", "\n", "                   ", "pol3"}], "}"}], 
                    " ", "=", " ", "#1"}], ";", " ", 
                    RowBox[{"index1", " ", "=", " ", "index"}], ";", " ", 
                    RowBox[{
                    "xunit", " ", "=", " ", "\n", "                  ", 
                    RowBox[{
                    RowBox[{"r1", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "ab"}], "]"}], 
                    "]"}]}], " ", "+", " ", 
                    RowBox[{"r2", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "ab"}], "]"}], 
                    "]"}]}]}]}], ";", " ", "\n", "                 ", 
                    RowBox[{"yunit", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"r2", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "ab"}], "]"}], 
                    "]"}]}], " ", "-", " ", 
                    RowBox[{
                    "1.", "*", "r1", "*", "\n", "                    ", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "ab"}], "]"}], 
                    "]"}]}]}]}], ";", " ", 
                    RowBox[{"zunit", " ", "=", " ", 
                    RowBox[{"r3", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "ab"}], "]"}], "^", 
                    "2"}], " ", "+", " ", "\n", "                     ", 
                    RowBox[{
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "ab"}], "]"}], "^", 
                    "2"}]}], "]"}]}]}], ";", " ", 
                    RowBox[{"xunit", " ", "=", " ", 
                    RowBox[{"Chop", "[", "xunit", "]"}]}], ";", " ", 
                    RowBox[{
                    "yunit", " ", "=", " ", "\n", "                  ", 
                    RowBox[{"Chop", "[", "yunit", "]"}]}], ";", " ", 
                    RowBox[{"zunit", " ", "=", " ", 
                    RowBox[{"Chop", "[", "zunit", "]"}]}], ";", " ", 
                    RowBox[{
                    "magnitude", " ", "=", " ", "\n", "                  ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"xunit", "^", "2"}], " ", "+", " ", 
                    RowBox[{"yunit", "^", "2"}], " ", "+", " ", 
                    RowBox[{"zunit", "^", "2"}]}], ")"}], "^", 
                    RowBox[{"2", "^", 
                    RowBox[{"(", 
                    RowBox[{"-", "1"}], ")"}]}]}]}], ";", " ", 
                    RowBox[{
                    "xunit", " ", "=", " ", "\n", "                  ", 
                    RowBox[{"xunit", "/", "magnitude"}]}], ";", " ", 
                    RowBox[{"yunit", " ", "=", " ", 
                    RowBox[{
                    "yunit", "/", "\n", "                   ", 
                    "magnitude"}]}], ";", " ", 
                    RowBox[{"zunit", " ", "=", " ", 
                    RowBox[{"zunit", "/", "magnitude"}]}], ";", " ", "\n", 
                    "                 ", 
                    RowBox[{"rx", " ", "=", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "ab"}], "]"}], "]"}],
                     "*", 
                    RowBox[{"(", 
                    RowBox[{"rex", " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"xb1", " ", "+", " ", 
                    RowBox[{"tb", "*", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "ab"}], "]"}]}]}], 
                    "]"}]}]}], ")"}]}], " ", "+", " ", "\n", 
                    "                   ", 
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "ab"}], "]"}], "]"}],
                     "*", 
                    RowBox[{"(", 
                    RowBox[{"rey", " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"yb1", " ", "+", " ", 
                    RowBox[{"tb", "*", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "ab"}], "]"}]}]}], 
                    "]"}]}]}], ")"}]}]}]}], ";", " ", 
                    RowBox[{"ry", " ", "=", " ", "\n", "                  ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "1."}], "*", 
                    RowBox[{"(", 
                    RowBox[{"rex", " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"xb1", " ", "+", " ", 
                    RowBox[{"tb", "*", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "ab"}], "]"}]}]}], 
                    "]"}]}]}], ")"}], "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "ab"}], "]"}], 
                    "]"}]}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "ab"}], "]"}], "]"}],
                     "*", "\n", "                    ", 
                    RowBox[{"(", 
                    RowBox[{"rey", " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"yb1", " ", "+", " ", 
                    RowBox[{"tb", "*", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "ab"}], "]"}]}]}], 
                    "]"}]}]}], ")"}]}]}]}], ";", " ", 
                    RowBox[{"rz", " ", "=", " ", 
                    RowBox[{"rez", "*", "\n", "                   ", 
                    RowBox[{"Re", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "ab"}], "]"}], "^", 
                    "2"}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "ab"}], "]"}], "^", 
                    "2"}]}], "]"}]}]}], ";", " ", 
                    RowBox[{"rx", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rx", "]"}]}], ";", " ", "\n", 
                    "                 ", 
                    RowBox[{"ry", " ", "=", " ", 
                    RowBox[{"Chop", "[", "ry", "]"}]}], ";", " ", 
                    RowBox[{"rz", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rz", "]"}]}], ";", " ", "\n", 
                    "                 ", 
                    RowBox[{"terminatedeflection", " ", "=", " ", "False"}], 
                    ";", " ", 
                    RowBox[{"intersections", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}], "}"}]}], ";", " ", 
                    RowBox[{
                    "intersections", " ", "=", " ", "\n", 
                    "                  ", "resonateintersections"}], ";", " ", 
                    RowBox[{"holeQ", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"holeQlist", "[", 
                    RowBox[{
                    "[", "\n", "                    ", "resonatenumber", 
                    "]"}], "]"}], " ", "==", " ", "1"}]}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "newcomponentnumber", ",", " ", "newsurfacenumber", ",", 
                    " ", "\n", "                   ", "newsurfaceid"}], "}"}],
                     " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"1.", ",", " ", "4.", ",", " ", "16548."}], 
                    "}"}]}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "componentnumber", ",", " ", "surfacenumber", ",", " ", 
                    "\n", "                   ", "surfaceid"}], "}"}], " ", 
                    "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"1.", ",", " ", "4.", ",", " ", "16548."}], 
                    "}"}]}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"ray1", ",", " ", "ray2", ",", " ", "ray3"}], 
                    "}"}], " ", "=", " ", "\n", "                  ", 
                    RowBox[{"intersections", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], ";", " ", 
                    RowBox[{"rsx", " ", "=", " ", "rex"}], ";", " ", 
                    RowBox[{
                    "rsy", " ", "=", " ", "\n", "                  ", "rey"}],
                     ";", " ", 
                    RowBox[{"rsz", " ", "=", " ", "rez"}], ";", " ", 
                    RowBox[{"rxhlp", " ", "=", " ", 
                    RowBox[{
                    "rx", " ", "+", " ", "\n", "                   ", 
                    RowBox[{"ray1", "*", "xunit"}]}]}], ";", " ", 
                    RowBox[{"ryhlp", " ", "=", " ", 
                    RowBox[{"ry", " ", "+", " ", 
                    RowBox[{
                    "ray1", "*", "\n", "                    ", "yunit"}]}]}], 
                    ";", " ", 
                    RowBox[{"rzhlp", " ", "=", " ", 
                    RowBox[{"rz", " ", "+", " ", 
                    RowBox[{"ray1", "*", "zunit"}]}]}], ";", " ", "\n", 
                    "                 ", 
                    RowBox[{"rex", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"rxhlp", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "ab"}], "]"}], 
                    "]"}]}], " ", "+", " ", 
                    RowBox[{"Re", "[", 
                    RowBox[{"xb1", " ", "+", " ", 
                    RowBox[{"tb", "*", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "ab"}], "]"}]}]}], 
                    "]"}], " ", "-", " ", "\n", "                   ", 
                    RowBox[{"1.", "*", "ryhlp", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "ab"}], "]"}], 
                    "]"}]}]}]}], ";", " ", 
                    RowBox[{"rey", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"ryhlp", "*", "\n", "                    ", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "ab"}], "]"}], 
                    "]"}]}], " ", "+", " ", 
                    RowBox[{"rxhlp", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "ab"}], "]"}], 
                    "]"}]}], " ", "+", " ", 
                    RowBox[{"Re", "[", 
                    RowBox[{"yb1", " ", "+", " ", 
                    RowBox[{"tb", "*", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "ab"}], "]"}]}]}], 
                    "]"}]}]}], ";", " ", "\n", "                 ", 
                    RowBox[{"rez", " ", "=", " ", 
                    RowBox[{"rzhlp", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "ab"}], "]"}], "^", 
                    "2"}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "ab"}], "]"}], "^", 
                    "2"}]}], "]"}]}]}], ";", " ", "\n", "                 ", 
                    RowBox[{"rex", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rex", "]"}]}], ";", " ", 
                    RowBox[{"rey", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rey", "]"}]}], ";", " ", "\n", 
                    "                 ", 
                    RowBox[{"rez", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rez", "]"}]}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"rex", " ", "==", " ", "0"}], " ", "&&", " ", 
                    RowBox[{"rey", " ", "==", " ", "0"}], " ", "&&", " ", 
                    "\n", "                   ", 
                    RowBox[{"rez", " ", "==", " ", "0"}]}], ",", " ", 
                    RowBox[{
                    RowBox[{"rex", " ", "=", " ", 
                    RowBox[{"rxhlp", " ", "+", " ", 
                    RowBox[{"Re", "[", 
                    RowBox[{"xb1", " ", "+", " ", 
                    RowBox[{"tb", "*", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "ab"}], "]"}]}]}], 
                    "]"}]}]}], ";", " ", "\n", "                   ", 
                    RowBox[{"rey", " ", "=", " ", 
                    RowBox[{"ryhlp", " ", "+", " ", 
                    RowBox[{"Re", "[", 
                    RowBox[{"yb1", " ", "+", " ", 
                    RowBox[{"tb", "*", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "ab"}], "]"}]}]}], 
                    "]"}]}]}], ";", " ", 
                    RowBox[{
                    "rez", " ", "=", " ", "\n", "                    ", 
                    "rzhlp"}]}], ",", " ", "rex"}], "]"}], ";", " ", 
                    RowBox[{"intersectionnumber", " ", "=", " ", 
                    RowBox[{
                    "intersectionnumber", " ", "+", " ", "\n", 
                    "                   ", "1."}]}], ";", " ", 
                    RowBox[{"opticallength", " ", "=", " ", 
                    RowBox[{"opticallength", " ", "+", " ", 
                    RowBox[{"ray1", "*", "index1"}]}]}], ";", " ", "\n", 
                    "                 ", 
                    RowBox[{"completedray", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "\n", "                   ", "rey", ",", " ", 
                    "rez", ",", " ", "r1", ",", " ", "r2", ",", " ", "r3", 
                    ",", " ", "\n", "                   ", "r4", ",", " ", 
                    "r5", ",", " ", "r6", ",", " ", "r7", ",", " ", "r8", ",",
                     " ", "\n", "                   ", "r9", ",", " ", 
                    "wavelength", ",", " ", "intensity", ",", " ", 
                    "intensityscale", ",", " ", "\n", "                   ", 
                    "ray1", ",", " ", "index", ",", " ", "opticallength", ",",
                     " ", "phaseshift", ",", " ", "\n", "                   ",
                     "componentnumber", ",", " ", "surfacenumber", ",", " ", 
                    "surfaceid", ",", " ", "ray2", ",", " ", "\n", 
                    "                   ", "ray3", ",", " ", "sid", ",", " ", 
                    "frontid", ",", " ", "sno1", ",", " ", "sno2", ",", " ", 
                    "\n", "                   ", "sno3", ",", " ", "sno4", 
                    ",", " ", "rayslot", ",", " ", "generationnumber", ",", 
                    " ", "\n", "                   ", "intersectionnumber", 
                    ",", " ", "pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}]}], ";", " ", "\n", "                 ", 
                    RowBox[{"reportedrayspresent", " ", "=", " ", "True"}], 
                    ";", " ", 
                    RowBox[{"intersectionspresent", " ", "=", " ", "True"}], 
                    ";", " ", 
                    RowBox[{
                    "deflectedrayspresent", " ", "=", " ", "\n", 
                    "                  ", "True"}], ";", " ", 
                    RowBox[{
                    "localdummyoutrayspresent", " ", "=", " ", "True"}], ";", 
                    " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    "surfnorm", " ", "=", " ", "\n", "                   ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"1.", ",", " ", 
                    RowBox[{
                    RowBox[{"-", "1."}], "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"ray2", "/", 
                    RowBox[{"Sign", "[", "cb2", "]"}]}], "/", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"cb2", "^", 
                    RowBox[{"(", 
                    RowBox[{"-", "2"}], ")"}]}], " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"ray2", "^", "2"}]}], " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"ray3", "^", "2"}]}]}], ")"}], "^", "0.5"}]}], 
                    ")"}]}], ",", " ", "\n", "                       ", 
                    RowBox[{
                    RowBox[{"-", "1."}], "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"ray3", "/", 
                    RowBox[{"Sign", "[", "cb2", "]"}]}], "/", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"cb2", "^", 
                    RowBox[{"(", 
                    RowBox[{"-", "2"}], ")"}]}], " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"ray2", "^", "2"}]}], " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"ray3", "^", "2"}]}]}], ")"}], "^", "0.5"}]}], 
                    ")"}]}]}], "}"}], ",", " ", "\n", 
                    "                      ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"ray2", "/", 
                    RowBox[{"Sign", "[", "cb2", "]"}]}], "/", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"cb2", "^", 
                    RowBox[{"(", 
                    RowBox[{"-", "2"}], ")"}]}], " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"ray2", "^", "2"}]}], " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"ray3", "^", "2"}]}]}], ")"}], "^", "0.5"}]}], 
                    ",", " ", "1.", ",", " ", "0."}], "}"}], ",", " ", "\n", 
                    "                      ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"ray3", "/", 
                    RowBox[{"Sign", "[", "cb2", "]"}]}], "/", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"cb2", "^", 
                    RowBox[{"(", 
                    RowBox[{"-", "2"}], ")"}]}], " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"ray2", "^", "2"}]}], " ", "-", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"ray3", "^", "2"}]}]}], ")"}], "^", "0.5"}]}], 
                    ",", " ", "0.", ",", " ", "1."}], "}"}]}], "}"}], 
                    "]"}]}]}], ";", " ", "\n", "                  ", 
                    RowBox[{"dummymatrix", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "ab"}], "]"}], "]"}],
                     "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "ab"}], "]"}], "^", 
                    "2"}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "ab"}], "]"}], "^", 
                    "2"}]}], "]"}]}], ")"}], "/", "\n", 
                    "                         ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "ab"}], "]"}], "]"}],
                     "^", "2"}], "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "ab"}], "]"}], "^", 
                    "2"}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "ab"}], "]"}], "^", 
                    "2"}]}], "]"}]}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "ab"}], "]"}], "]"}],
                     "^", "2"}], "*", "\n", "                           ", 
                    RowBox[{"Re", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "ab"}], "]"}], "^", 
                    "2"}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "ab"}], "]"}], "^", 
                    "2"}]}], "]"}]}]}], ")"}]}], ",", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1."}], "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "ab"}], "]"}], "]"}],
                     "*", "\n", "                          ", 
                    RowBox[{"Re", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "ab"}], "]"}], "^", 
                    "2"}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "ab"}], "]"}], "^", 
                    "2"}]}], "]"}]}], ")"}], "/", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "ab"}], "]"}], "]"}],
                     "^", "2"}], "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "ab"}], "]"}], "^", 
                    "\n", "                              ", "2"}], " ", "+", 
                    " ", 
                    RowBox[{
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "ab"}], "]"}], "^", 
                    "2"}]}], "]"}]}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "ab"}], "]"}], "]"}],
                     "^", "2"}], "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "ab"}], "]"}], "^", 
                    "2"}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"Sin", "[", 
                    RowBox[{
                    "0.017453292519943295", "*", "\n", 
                    "                                ", "ab"}], "]"}], "^", 
                    "2"}]}], "]"}]}]}], ")"}]}], ",", " ", "0."}], "}"}], ",",
                     " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "ab"}], "]"}], "]"}],
                     "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "ab"}], "]"}], "^", 
                    "2"}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "ab"}], "]"}], "^", 
                    "2"}]}], "]"}]}], ")"}], "/", "\n", 
                    "                         ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "ab"}], "]"}], "]"}],
                     "^", "2"}], "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "ab"}], "]"}], "^", 
                    "2"}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "ab"}], "]"}], "^", 
                    "2"}]}], "]"}]}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "ab"}], "]"}], "]"}],
                     "^", "2"}], "*", "\n", "                           ", 
                    RowBox[{"Re", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "ab"}], "]"}], "^", 
                    "2"}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "ab"}], "]"}], "^", 
                    "2"}]}], "]"}]}]}], ")"}]}], ",", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "ab"}], "]"}], "]"}],
                     "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "ab"}], "]"}], "^", 
                    "\n", "                             ", "2"}], " ", "+", 
                    " ", 
                    RowBox[{
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "ab"}], "]"}], "^", 
                    "2"}]}], "]"}]}], ")"}], "/", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "ab"}], "]"}], "]"}],
                     "^", "2"}], "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "ab"}], "]"}], "^", 
                    "2"}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"Sin", "[", 
                    RowBox[{
                    "0.017453292519943295", "*", "\n", 
                    "                                ", "ab"}], "]"}], "^", 
                    "2"}]}], "]"}]}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "ab"}], "]"}], "]"}],
                     "^", "2"}], "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "ab"}], "]"}], "^", 
                    "2"}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "ab"}], "]"}], "^", 
                    "2"}]}], "]"}]}]}], ")"}]}], ",", " ", "0."}], "}"}], ",",
                     " ", "\n", "                       ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "0.", ",", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "ab"}], "]"}], "]"}],
                     "^", "2"}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "ab"}], "]"}], "]"}],
                     "^", "2"}]}], ")"}], "/", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "ab"}], "]"}], "]"}],
                     "^", "2"}], "*", "\n", "                           ", 
                    RowBox[{"Re", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "ab"}], "]"}], "^", 
                    "2"}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "ab"}], "]"}], "^", 
                    "2"}]}], "]"}]}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "ab"}], "]"}], "]"}],
                     "^", "2"}], "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "ab"}], "]"}], "^", 
                    "\n", "                              ", "2"}], " ", "+", 
                    " ", 
                    RowBox[{
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "ab"}], "]"}], "^", 
                    "2"}]}], "]"}]}]}], ")"}]}]}], "}"}]}], "}"}], " ", ".", 
                    " ", "#1"}], " ", "&"}], " ", ")"}], " ", "/@", " ", 
                    "surfnorm"}]}], ";", " ", 
                    RowBox[{
                    "surfnorm", " ", "=", " ", "\n", "                   ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"#1", "/", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"#1", " ", ".", " ", "#1"}], "]"}]}], " ", "&"}], 
                    " ", ")"}], " ", "/@", " ", "dummymatrix"}]}], ";", " ", 
                    RowBox[{"surfacerotationmatrix", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "ab"}], "]"}], "]"}],
                     ",", " ", "\n", "                     ", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "ab"}], "]"}], "]"}],
                     ",", " ", "0."}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", "1."}], "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "ab"}], "]"}], 
                    "]"}]}], ",", " ", 
                    RowBox[{"Re", "[", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "ab"}], "]"}], "]"}],
                     ",", " ", "0."}], "}"}], ",", " ", "\n", 
                    "                    ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "0.", ",", " ", 
                    RowBox[{"Re", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "ab"}], "]"}], "^", 
                    "2"}], " ", "+", " ", 
                    RowBox[{
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "ab"}], "]"}], "^", 
                    "2"}]}], "]"}]}], "}"}]}], "}"}]}], ";", " ", 
                    RowBox[{
                    "surfacetranslationvector", " ", "=", " ", "\n", 
                    "                   ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Re", "[", 
                    RowBox[{"xb1", " ", "+", " ", 
                    RowBox[{"tb", "*", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"0.017453292519943295", "*", "ab"}], "]"}]}]}], 
                    "]"}], ",", " ", 
                    RowBox[{"Re", "[", 
                    RowBox[{"yb1", " ", "+", " ", 
                    RowBox[{"tb", "*", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"0.017453292519943295", "*", "ab"}], "]"}]}]}], 
                    "]"}], ",", " ", "0."}], "}"}]}], ";", " ", 
                    RowBox[{"activeregion", " ", "=", " ", 
                    RowBox[{"-", "1."}]}], ";", " ", "\n", 
                    "                  ", 
                    RowBox[{"completedray", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "\n", "                    ", "rey", ",", " ", 
                    "rez", ",", " ", "r1", ",", " ", "r2", ",", " ", "r3", 
                    ",", " ", "\n", "                    ", "r4", ",", " ", 
                    "r5", ",", " ", "r6", ",", " ", "r7", ",", " ", "r8", ",",
                     " ", "\n", "                    ", "r9", ",", " ", 
                    "wavelength", ",", " ", "intensity", ",", " ", 
                    "intensityscale", ",", " ", "\n", "                    ", 
                    "ray1", ",", " ", "index", ",", " ", "opticallength", ",",
                     " ", "phaseshift", ",", " ", "\n", 
                    "                    ", "componentnumber", ",", " ", 
                    "surfacenumber", ",", " ", "surfaceid", ",", " ", "ray2", 
                    ",", " ", "\n", "                    ", "ray3", ",", " ", 
                    "sid", ",", " ", "frontid", ",", " ", "sno1", ",", " ", 
                    "sno2", ",", " ", "\n", "                    ", "sno3", 
                    ",", " ", "sno4", ",", " ", "rayslot", ",", " ", 
                    "generationnumber", ",", " ", "\n", 
                    "                    ", "intersectionnumber", ",", " ", 
                    "pol1", ",", " ", "pol2", ",", " ", "pol3"}], "}"}]}], 
                    ";", " ", "\n", "                  ", 
                    RowBox[{
                    "componentnumber", " ", "=", " ", "newcomponentnumber"}], 
                    ";", " ", 
                    RowBox[{
                    "surfacenumber", " ", "=", " ", "\n", 
                    "                   ", "newsurfacenumber"}], ";", " ", 
                    RowBox[{"surfaceid", " ", "=", " ", "newsurfaceid"}], ";",
                     " ", 
                    RowBox[{
                    "originalray", " ", "=", " ", "\n", "                   ", 
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "\n", "                    ", 
                    "rez", ",", " ", "r1", ",", " ", "r2", ",", " ", "r3", 
                    ",", " ", "r4", ",", " ", "\n", "                    ", 
                    "r5", ",", " ", "r6", ",", " ", "r7", ",", " ", "r8", ",",
                     " ", "r9", ",", " ", "\n", "                    ", 
                    "wavelength", ",", " ", "intensity", ",", " ", 
                    "intensityscale", ",", " ", "ray1", ",", " ", "\n", 
                    "                    ", "index", ",", " ", 
                    "opticallength", ",", " ", "phaseshift", ",", " ", 
                    "componentnumber", ",", " ", "\n", "                    ",
                     "surfacenumber", ",", " ", "surfaceid", ",", " ", "ray2",
                     ",", " ", "ray3", ",", " ", "\n", "                    ",
                     "sid", ",", " ", "frontid", ",", " ", "sno1", ",", " ", 
                    "sno2", ",", " ", "sno3", ",", " ", "\n", 
                    "                    ", "sno4", ",", " ", "rayslot", ",", 
                    " ", "generationnumber", ",", " ", "intersectionnumber", 
                    ",", " ", "\n", "                    ", "pol1", ",", " ", 
                    "pol2", ",", " ", "pol3"}], "}"}]}], ";", " ", 
                    RowBox[{
                    "ZAxis", " ", "=", " ", "\n", "                   ", 
                    RowBox[{
                    RowBox[{"First", "[", "surfnorm", "]"}], "*", 
                    RowBox[{"Sign", "[", 
                    RowBox[{
                    RowBox[{"First", "[", "surfnorm", "]"}], " ", ".", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "r1", ",", " ", "r2", ",", " ", "\n", 
                    "                       ", "r3"}], "}"}]}], "]"}]}]}], 
                    ";", " ", 
                    RowBox[{"raytiltz", " ", "=", " ", 
                    RowBox[{"ZAxis", " ", ".", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "r1", ",", " ", "\n", "                     ", "r2", ",", 
                    " ", "r3"}], "}"}]}]}], ";", " ", 
                    RowBox[{"raytiltx", " ", "=", " ", 
                    RowBox[{"1", " ", "-", " ", 
                    RowBox[{"raytiltz", "^", "2"}]}]}], ";", " ", "\n", 
                    "                  ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    "raytiltx", " ", "<", " ", "2.220446049250313*^-16"}], 
                    ",", " ", 
                    RowBox[{"raytiltx", " ", "=", " ", "0."}], ",", " ", 
                    RowBox[{
                    "raytiltx", " ", "=", " ", "\n", "                    ", 
                    RowBox[{"Sqrt", "[", "raytiltx", "]"}]}]}], "]"}], ";", 
                    " ", 
                    RowBox[{"XAxis", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "r1", ",", " ", "r2", ",", " ", "\n", 
                    "                     ", "r3"}], "}"}], " ", "-", " ", 
                    RowBox[{"ZAxis", "*", "raytiltz"}]}]}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", "raytiltx", "]"}], " ", "<", " ", 
                    "1.*^-7"}], ",", " ", "\n", "                   ", 
                    RowBox[{"XAxis", " ", "=", " ", 
                    RowBox[{"surfnorm", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], ",", " ", 
                    RowBox[{"XAxis", " ", "=", " ", 
                    RowBox[{
                    "XAxis", "/", "\n", "                     ", 
                    "raytiltx"}]}]}], "]"}], ";", " ", 
                    RowBox[{"YAxis", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"ZAxis", "[", 
                    RowBox[{"[", "3", "]"}], "]"}], "*", 
                    RowBox[{"XAxis", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], ")"}]}], " ", "+", " ", 
                    "\n", "                     ", 
                    RowBox[{
                    RowBox[{"ZAxis", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "*", 
                    RowBox[{"XAxis", "[", 
                    RowBox[{"[", "3", "]"}], "]"}]}]}], ",", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"ZAxis", "[", 
                    RowBox[{"[", "3", "]"}], "]"}], "*", 
                    RowBox[{"XAxis", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], " ", "-", " ", "\n", 
                    "                     ", 
                    RowBox[{
                    RowBox[{"ZAxis", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "*", 
                    RowBox[{"XAxis", "[", 
                    RowBox[{"[", "3", "]"}], "]"}]}]}], ",", " ", 
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"ZAxis", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "*", 
                    RowBox[{"XAxis", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], ")"}]}], " ", "+", " ", 
                    "\n", "                     ", 
                    RowBox[{
                    RowBox[{"ZAxis", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "*", 
                    RowBox[{"XAxis", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}]}]}], "}"}]}], ";", " ", 
                    RowBox[{"YAxis", " ", "=", " ", 
                    RowBox[{"YAxis", "/", "\n", "                    ", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"YAxis", " ", ".", " ", "YAxis"}], "]"}]}]}], ";",
                     " ", 
                    RowBox[{"PAxis", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"ZAxis", "*", "\n", "                     ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    " ", ".", " ", "XAxis"}]}], " ", "-", " ", 
                    RowBox[{"XAxis", "*", "\n", "                     ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    " ", ".", " ", "ZAxis"}]}]}]}], ";", " ", 
                    RowBox[{
                    "PAxis", " ", "=", " ", "\n", "                   ", 
                    RowBox[{"PAxis", "/", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"PAxis", " ", ".", " ", "PAxis"}], "]"}]}]}], ";",
                     " ", 
                    RowBox[{
                    "normalizedpolarization", " ", "=", " ", "\n", 
                    "                   ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], "[", 
                    RowBox[{"[", 
                    RowBox[{"{", 
                    RowBox[{"1", ",", " ", "2"}], "}"}], "]"}], "]"}]}], ";", 
                    " ", 
                    RowBox[{
                    "normalizedpolarization", " ", "=", " ", "\n", 
                    "                   ", 
                    RowBox[{"normalizedpolarization", "/", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{
                    "normalizedpolarization", " ", ".", " ", 
                    "normalizedpolarization"}], "]"}]}]}], ";", " ", "\n", 
                    "                  ", 
                    RowBox[{"allcreatedamplitudes", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"0.", "*", "I"}], ",", " ", 
                    RowBox[{"0.", "*", "I"}], ",", " ", 
                    RowBox[{"0.", "*", "I"}]}], "}"}], "}"}]}], ";", " ", 
                    RowBox[{"amplitude", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"Sqrt", "[", "intensity", "]"}], "*", "\n", 
                    "                    ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"normalizedpolarization", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "*", 
                    RowBox[{"{", 
                    RowBox[{"r4", ",", " ", "r5", ",", " ", "r6"}], "}"}]}], 
                    " ", "+", " ", "\n", "                     ", 
                    RowBox[{
                    RowBox[{"normalizedpolarization", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "*", 
                    RowBox[{"{", 
                    RowBox[{"r7", ",", " ", "r8", ",", " ", "r9"}], "}"}], 
                    "*", "\n", "                      ", 
                    RowBox[{"Exp", "[", 
                    RowBox[{"I", "*", "pol3", "*", "0.017453292519943295"}], 
                    "]"}]}]}], ")"}]}]}], ";", " ", 
                    RowBox[{"perpendicularamplitude", " ", "=", " ", 
                    RowBox[{
                    "amplitude", " ", ".", " ", "\n", "                    ", 
                    "YAxis"}]}], ";", " ", 
                    RowBox[{"parallelamplitude", " ", "=", " ", 
                    RowBox[{"amplitude", " ", ".", " ", "PAxis"}]}], ";", " ",
                     "\n", "                  ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"activeregion", "*", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"surfacerotationmatrix", " ", ".", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "r1", ",", " ", "r2", ",", " ", "\n", 
                    "                        ", "r3"}], "}"}]}], ")"}], "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], " ", ">", " ", "0"}], 
                    ",", " ", 
                    RowBox[{
                    RowBox[{"index2", " ", "=", " ", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"3.0539614", " ", "-", " ", 
                    RowBox[{"0.011580432", "*", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", "\n", 
                    "                       ", 
                    RowBox[{"0.039199816", "/", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", 
                    RowBox[{"0.0029462812", "/", 
                    RowBox[{"wavelength", "^", "4"}]}], " ", "-", " ", 
                    RowBox[{
                    "0.00020371019000000004", "/", "\n", 
                    "                        ", 
                    RowBox[{"wavelength", "^", "6"}]}], " ", "+", " ", 
                    RowBox[{"0.000027633568999999998", "/", 
                    RowBox[{"wavelength", "^", "8"}]}]}], "]"}]}], ";", " ", 
                    RowBox[{
                    "index1", " ", "=", " ", "\n", "                     ", 
                    "index"}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", 
                    RowBox[{"index2", " ", "-", " ", "index1"}], "]"}], " ", 
                    "<", " ", "0.01"}], ",", " ", 
                    RowBox[{
                    RowBox[{
                    "alternateindex", " ", "=", " ", "\n", 
                    "                       ", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"1.0005281111748805", " ", "-", " ", 
                    RowBox[{"2.364805676582992*^-10", "*", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", 
                    RowBox[{"2.9781670902982902*^-6", "/", 
                    RowBox[{
                    "wavelength", "^", "\n", "                           ", 
                    "2"}]}], " ", "+", " ", 
                    RowBox[{"2.6004099469477187*^-8", "/", 
                    RowBox[{"wavelength", "^", "4"}]}], " ", "+", " ", 
                    RowBox[{"3.7787839314048715*^-10", "/", 
                    RowBox[{"wavelength", "^", "6"}]}], " ", "+", " ", "\n", 
                    "                         ", 
                    RowBox[{"2.830549017940716*^-12", "/", 
                    RowBox[{"wavelength", "^", "8"}]}]}], "]"}]}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", 
                    RowBox[{"alternateindex", " ", "-", " ", "index1"}], 
                    "]"}], " ", ">", " ", "\n", "                        ", 
                    RowBox[{"Abs", "[", 
                    RowBox[{"index2", " ", "-", " ", "index1"}], "]"}]}], ",",
                     " ", 
                    RowBox[{
                    RowBox[{"index1", " ", "=", " ", "index2"}], ";", " ", 
                    "\n", "                        ", 
                    RowBox[{"index2", " ", "=", " ", "alternateindex"}]}], 
                    ",", " ", 
                    RowBox[{"index1", " ", "=", " ", "alternateindex"}]}], 
                    "]"}]}], ",", " ", "\n", "                     ", 
                    RowBox[{"index1", " ", "=", " ", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"1.0005281111748805", " ", "-", " ", 
                    RowBox[{"2.364805676582992*^-10", "*", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", 
                    RowBox[{
                    "2.9781670902982902*^-6", "/", "\n", 
                    "                         ", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", 
                    RowBox[{"2.6004099469477187*^-8", "/", 
                    RowBox[{"wavelength", "^", "4"}]}], " ", "+", " ", 
                    RowBox[{
                    "3.7787839314048715*^-10", "/", "\n", 
                    "                         ", 
                    RowBox[{"wavelength", "^", "6"}]}], " ", "+", " ", 
                    RowBox[{"2.830549017940716*^-12", "/", 
                    RowBox[{"wavelength", "^", "8"}]}]}], "]"}]}]}], "]"}]}], 
                    ",", " ", 
                    RowBox[{
                    RowBox[{
                    "index2", " ", "=", " ", "\n", "                     ", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"1.0005281111748805", " ", "-", " ", 
                    RowBox[{"2.364805676582992*^-10", "*", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", 
                    RowBox[{"2.9781670902982902*^-6", "/", 
                    RowBox[{
                    "wavelength", "^", "\n", "                         ", 
                    "2"}]}], " ", "+", " ", 
                    RowBox[{"2.6004099469477187*^-8", "/", 
                    RowBox[{"wavelength", "^", "4"}]}], " ", "+", " ", 
                    RowBox[{"3.7787839314048715*^-10", "/", 
                    RowBox[{"wavelength", "^", "6"}]}], " ", "+", " ", "\n", 
                    "                       ", 
                    RowBox[{"2.830549017940716*^-12", "/", 
                    RowBox[{"wavelength", "^", "8"}]}]}], "]"}]}], ";", " ", 
                    RowBox[{"index1", " ", "=", " ", "index"}], ";", " ", 
                    "\n", "                    ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", 
                    RowBox[{"index2", " ", "-", " ", "index1"}], "]"}], " ", 
                    "<", " ", "0.01"}], ",", " ", 
                    RowBox[{
                    RowBox[{"alternateindex", " ", "=", " ", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{
                    "3.0539614", " ", "-", " ", "\n", 
                    "                         ", 
                    RowBox[{"0.011580432", "*", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", 
                    RowBox[{"0.039199816", "/", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", 
                    RowBox[{
                    "0.0029462812", "/", "\n", "                          ", 
                    RowBox[{"wavelength", "^", "4"}]}], " ", "-", " ", 
                    RowBox[{"0.00020371019000000004", "/", 
                    RowBox[{"wavelength", "^", "6"}]}], " ", "+", " ", 
                    RowBox[{
                    "0.000027633568999999998", "/", "\n", 
                    "                          ", 
                    RowBox[{"wavelength", "^", "8"}]}]}], "]"}]}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", 
                    RowBox[{"alternateindex", " ", "-", " ", "index1"}], 
                    "]"}], " ", ">", " ", "\n", "                        ", 
                    RowBox[{"Abs", "[", 
                    RowBox[{"index2", " ", "-", " ", "index1"}], "]"}]}], ",",
                     " ", 
                    RowBox[{
                    RowBox[{"index1", " ", "=", " ", "index2"}], ";", " ", 
                    "\n", "                        ", 
                    RowBox[{"index2", " ", "=", " ", "alternateindex"}]}], 
                    ",", " ", 
                    RowBox[{"index1", " ", "=", " ", "alternateindex"}]}], 
                    "]"}]}], ",", " ", "\n", "                     ", 
                    RowBox[{"index1", " ", "=", " ", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"3.0539614", " ", "-", " ", 
                    RowBox[{"0.011580432", "*", 
                    RowBox[{"wavelength", "^", "2"}]}], " ", "+", " ", 
                    RowBox[{"0.039199816", "/", 
                    RowBox[{
                    "wavelength", "^", "\n", "                          ", 
                    "2"}]}], " ", "+", " ", 
                    RowBox[{"0.0029462812", "/", 
                    RowBox[{"wavelength", "^", "4"}]}], " ", "-", " ", 
                    RowBox[{"0.00020371019000000004", "/", 
                    RowBox[{"wavelength", "^", "6"}]}], " ", "+", " ", 
                    RowBox[{
                    "0.000027633568999999998", "/", "\n", 
                    "                         ", 
                    RowBox[{"wavelength", "^", "8"}]}]}], "]"}]}]}], 
                    "]"}]}]}], "]"}], ";", " ", 
                    RowBox[{"n12", " ", "=", " ", 
                    RowBox[{"index1", "/", "index2"}]}], ";", " ", "\n", 
                    "                  ", 
                    RowBox[{"index", " ", "=", " ", "index2"}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"1", " ", "-", " ", 
                    RowBox[{
                    RowBox[{"n12", "^", "2"}], "*", 
                    RowBox[{"raytiltx", "^", "2"}]}]}], " ", ">=", " ", 
                    "0."}], ",", " ", "\n", "                   ", 
                    RowBox[{
                    RowBox[{"dummyvector", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"n12", "*", 
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}]}], 
                    " ", "+", " ", "\n", "                      ", 
                    RowBox[{"ZAxis", "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"(", 
                    RowBox[{"n12", "*", "raytiltz"}], ")"}]}], " ", "+", " ", 
                    
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"1", " ", "-", " ", 
                    RowBox[{
                    RowBox[{"n12", "^", "2"}], "*", "\n", 
                    "                           ", 
                    RowBox[{"raytiltx", "^", "2"}]}]}], "]"}]}], ")"}]}]}]}], 
                    ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    " ", "=", " ", "\n", "                     ", 
                    "dummyvector"}], ";", " ", "1."}], ",", " ", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    " ", ".", " ", "\n", "                       ", 
                    RowBox[{"surfnorm", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], " ", ">", " ", "0"}], 
                    ",", " ", 
                    RowBox[{"phaseshift", " ", "=", " ", 
                    RowBox[{"phaseshift", " ", "+", " ", "0.5"}]}], ",", " ", 
                    "1."}], "]"}], ";", " ", "\n", "                    ", 
                    RowBox[{"index2", " ", "=", " ", "index1"}], ";", " ", 
                    RowBox[{"index", " ", "=", " ", "index1"}], ";", " ", 
                    "\n", "                    ", 
                    RowBox[{"dummyvector", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    " ", "-", " ", "\n", "                      ", 
                    RowBox[{"2", "*", "ZAxis", "*", 
                    RowBox[{"ZAxis", " ", ".", " ", 
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], 
                    "}"}]}]}]}]}], ";", " ", "\n", "                    ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    " ", "=", " ", "dummyvector"}], ";", " ", "\n", 
                    "                    ", 
                    RowBox[{"dummyvector", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], " ", "+", " ", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", " ", "0", ",", " ", 
                    RowBox[{"-", "180"}]}], "}"}]}]}], ";", " ", "\n", 
                    "                    ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], " ", "=", " ", "dummyvector"}], ";", " ", "1."}]}],
                     "]"}], ";", " ", "\n", "                  ", 
                    RowBox[{"allcreatedrays", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "\n", 
                    "                     ", "rex", ",", " ", "rey", ",", " ",
                     "rez", ",", " ", "r1", ",", " ", "r2", ",", " ", "\n", 
                    "                     ", "r3", ",", " ", "r4", ",", " ", 
                    "r5", ",", " ", "r6", ",", " ", "r7", ",", " ", "\n", 
                    "                     ", "r8", ",", " ", "r9", ",", " ", 
                    "wavelength", ",", " ", "intensity", ",", " ", "\n", 
                    "                     ", "intensityscale", ",", " ", 
                    "ray1", ",", " ", "index", ",", " ", "opticallength", ",",
                     " ", "\n", "                     ", "phaseshift", ",", 
                    " ", "componentnumber", ",", " ", "surfacenumber", ",", 
                    " ", "surfaceid", ",", " ", "\n", "                     ",
                     "ray2", ",", " ", "ray3", ",", " ", "sid", ",", " ", 
                    "frontid", ",", " ", "sno1", ",", " ", "\n", 
                    "                     ", "sno2", ",", " ", "sno3", ",", 
                    " ", "sno4", ",", " ", "rayslot", ",", " ", "\n", 
                    "                     ", "generationnumber", ",", " ", 
                    "intersectionnumber", ",", " ", "pol1", ",", " ", "pol2", 
                    ",", " ", "\n", "                     ", "pol3"}], "}"}], 
                    "}"}]}], ";", " ", 
                    RowBox[{"originalrotation", " ", "=", " ", 
                    RowBox[{"Partition", "[", 
                    RowBox[{
                    RowBox[{"Take", "[", 
                    RowBox[{"originalray", ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"7", ",", " ", "15"}], "}"}]}], "]"}], ",", " ", 
                    "3"}], "]"}]}], ";", " ", "\n", "                  ", 
                    RowBox[{"previoustilt", " ", "=", " ", 
                    RowBox[{"originalrotation", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], ";", " ", 
                    RowBox[{
                    "transmatrix", " ", "=", " ", "\n", "                   ", 
                    RowBox[{"MapIndexed", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "\n", "                        ", "rey", ",", 
                    " ", "rez", ",", " ", "r1", ",", " ", "r2", ",", " ", 
                    "r3", ",", " ", "\n", "                        ", "r4", 
                    ",", " ", "r5", ",", " ", "r6", ",", " ", "r7", ",", " ", 
                    "r8", ",", " ", "\n", "                        ", "r9", 
                    ",", " ", "wavelength", ",", " ", "intensity", ",", " ", 
                    "intensityscale", ",", " ", "\n", 
                    "                        ", "ray1", ",", " ", "index", 
                    ",", " ", "opticallength", ",", " ", "phaseshift", ",", 
                    " ", "\n", "                        ", "componentnumber", 
                    ",", " ", "surfacenumber", ",", " ", "surfaceid", ",", 
                    " ", "ray2", ",", " ", "\n", "                        ", 
                    "ray3", ",", " ", "sid", ",", " ", "frontid", ",", " ", 
                    "sno1", ",", " ", "sno2", ",", " ", "\n", 
                    "                        ", "sno3", ",", " ", "sno4", ",",
                     " ", "rayslot", ",", " ", "oldgenerationnumber", ",", 
                    " ", "\n", "                        ", 
                    "intersectionnumber", ",", " ", "pol1", ",", " ", "pol2", 
                    ",", " ", "pol3"}], "}"}], " ", "=", " ", "#1"}], ";", 
                    " ", "\n", "                      ", 
                    RowBox[{"rotationaxis", " ", "=", " ", 
                    RowBox[{"Cross", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"1.", ",", " ", "0.", ",", " ", "0."}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}]}], 
                    "]"}]}], ";", " ", "\n", "                      ", 
                    RowBox[{"axismagnitude", " ", "=", " ", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"rotationaxis", " ", ".", " ", "rotationaxis"}], 
                    "]"}]}], ";", " ", "\n", "                      ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Chop", "[", "axismagnitude", "]"}], " ", "!=", 
                    " ", "0."}], ",", " ", 
                    RowBox[{
                    RowBox[{"rotationaxis", " ", "=", " ", 
                    RowBox[{
                    "rotationaxis", "/", "\n", "                          ", 
                    "axismagnitude"}]}], ";", " ", 
                    RowBox[{"axismatrix", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"#1", "*", "rotationaxis"}], " ", "&"}], " ", 
                    ")"}], " ", "/@", " ", "\n", "                          ",
                     "rotationaxis"}]}], ";", " ", 
                    RowBox[{"crossmatrix", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", 
                    RowBox[{"-", 
                    RowBox[{"rotationaxis", "[", 
                    RowBox[{"[", "3", "]"}], "]"}]}], ",", " ", "\n", 
                    "                           ", 
                    RowBox[{"rotationaxis", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"rotationaxis", "[", 
                    RowBox[{"[", "3", "]"}], "]"}], ",", " ", "0.", ",", " ", 
                    
                    RowBox[{"-", 
                    RowBox[{"rotationaxis", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}]}], "}"}], ",", " ", "\n",
                     "                          ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"rotationaxis", "[", 
                    RowBox[{"[", "2", "]"}], "]"}]}], ",", " ", 
                    RowBox[{"rotationaxis", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], ",", " ", "0."}], "}"}]}],
                     "}"}]}], ";", " ", 
                    RowBox[{
                    "cosangle", " ", "=", " ", "\n", 
                    "                         ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"1.", ",", " ", "0.", ",", " ", "0."}], "}"}], 
                    " ", ".", " ", 
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}]}]}],
                     ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"1.", " ", "-", " ", "cosangle"}], " ", "<", " ", 
                    "\n", "                          ", 
                    "2.220446049250313*^-16"}], ",", " ", 
                    RowBox[{"cosangle", " ", "=", " ", "1."}]}], "]"}], ";", 
                    " ", 
                    RowBox[{"sinangle", " ", "=", " ", 
                    RowBox[{"1", " ", "-", " ", 
                    RowBox[{"cosangle", "^", "2"}]}]}], ";", " ", "\n", 
                    "                        ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    "sinangle", " ", "<", " ", "2.220446049250313*^-16"}], 
                    ",", " ", 
                    RowBox[{"sinangle", " ", "=", " ", "0."}], ",", " ", 
                    RowBox[{
                    "sinangle", " ", "=", " ", "\n", 
                    "                          ", 
                    RowBox[{"Sqrt", "[", "sinangle", "]"}]}]}], "]"}], ";", 
                    " ", 
                    RowBox[{"axismatrix", " ", "+", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"1.", ",", " ", "0.", ",", " ", "0."}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "1.", ",", " ", "0."}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "0.", ",", " ", "1."}], "}"}]}], 
                    "}"}], " ", "-", " ", "\n", "                           ",
                     "axismatrix"}], ")"}], "*", "cosangle"}], " ", "+", " ", 
                    
                    RowBox[{"crossmatrix", "*", "sinangle"}]}]}], ",", " ", 
                    "\n", "                       ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "r4", ",", " ", "r5", ",", " ", "\n", 
                    "                          ", "r6"}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"r7", ",", " ", "r8", ",", " ", "r9"}], "}"}]}], 
                    "}"}], " ", "=", " ", "\n", "                        ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Sign", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"1.", ",", " ", "0.", ",", " ", "0."}], "}"}], 
                    " ", ".", " ", 
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}]}], 
                    "]"}], " ", "===", " ", "1"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"1.", ",", " ", "0.", ",", " ", "0."}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "1.", ",", " ", "0."}], "}"}], 
                    ",", " ", "\n", "                          ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "0.", ",", " ", "1."}], "}"}]}], 
                    "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", 
                    RowBox[{"-", "1."}], ",", " ", "0."}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "0.", ",", " ", "1."}], "}"}]}], 
                    "}"}]}], "]"}]}]}], "]"}]}], ")"}], " ", "&"}], " ", ",", 
                    " ", "allcreatedrays"}], "]"}]}], ";", " ", "\n", 
                    "                  ", 
                    RowBox[{"allcreatedrays", " ", "=", " ", 
                    RowBox[{"MapIndexed", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "\n", 
                    "                        ", "rex", ",", " ", "rey", ",", 
                    " ", "rez", ",", " ", "r1", ",", " ", "r2", ",", " ", 
                    "\n", "                        ", "r3", ",", " ", "r4", 
                    ",", " ", "r5", ",", " ", "r6", ",", " ", "r7", ",", " ", 
                    "\n", "                        ", "r8", ",", " ", "r9", 
                    ",", " ", "wavelength", ",", " ", "intensity", ",", " ", 
                    "\n", "                        ", "intensityscale", ",", 
                    " ", "ray1", ",", " ", "index", ",", " ", "opticallength",
                     ",", " ", "\n", "                        ", "phaseshift",
                     ",", " ", "componentnumber", ",", " ", "surfacenumber", 
                    ",", " ", "\n", "                        ", "surfaceid", 
                    ",", " ", "ray2", ",", " ", "ray3", ",", " ", "sid", ",", 
                    " ", "\n", "                        ", "frontid", ",", 
                    " ", "sno1", ",", " ", "sno2", ",", " ", "sno3", ",", " ",
                     "\n", "                        ", "sno4", ",", " ", 
                    "rayslot", ",", " ", "oldgenerationnumber", ",", " ", 
                    "\n", "                        ", "intersectionnumber", 
                    ",", " ", "pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], " ", "=", " ", "#1"}], ";", " ", "\n", 
                    "                      ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "r4", ",", " ", "r5", ",", " ", "\n", 
                    "                         ", "r6"}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"r7", ",", " ", "r8", ",", " ", "r9"}], "}"}]}], 
                    "}"}], " ", "=", " ", "\n", "                       ", 
                    RowBox[{
                    RowBox[{"Function", "[", 
                    RowBox[{"mm", ",", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"mm", " ", ".", " ", "#1"}], " ", "&"}], " ", 
                    ")"}], " ", "/@", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"1.", ",", " ", "0.", ",", " ", "0."}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "1.", ",", " ", "0."}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "0.", ",", " ", "1."}], "}"}]}], 
                    "}"}]}]}], "]"}], "[", "\n", "                        ", 
                    RowBox[{"transmatrix", "[", 
                    RowBox[{"[", 
                    RowBox[{"First", "[", "#2", "]"}], "]"}], "]"}], "]"}]}], 
                    ";", " ", 
                    RowBox[{"tiltmagnitude", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "r1", ",", " ", "r2", ",", " ", "\n", 
                    "                         ", "r3"}], "}"}], " ", ".", " ", 
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}]}]}],
                     ";", " ", "\n", "                      ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", 
                    RowBox[{"tiltmagnitude", " ", "-", " ", "1."}], "]"}], 
                    " ", ">", " ", "1.*^-6"}], ",", " ", 
                    RowBox[{
                    RowBox[{"dummyvector", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "r1", ",", " ", "\n", "                           ", "r2",
                     ",", " ", "r3"}], "}"}], "/", 
                    RowBox[{"Sqrt", "[", "tiltmagnitude", "]"}]}]}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "r1", ",", " ", "\n", "                          ", "r2", 
                    ",", " ", "r3"}], "}"}], " ", "=", " ", "dummyvector"}], 
                    ";", " ", 
                    RowBox[{
                    "dummymatrix", " ", "=", " ", "\n", 
                    "                         ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"#1", "/", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"#1", " ", ".", " ", "#1"}], "]"}]}], " ", "&"}], 
                    " ", ")"}], " ", "/@", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "r4", ",", " ", "\n", "                            ", 
                    "r5", ",", " ", "r6"}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"r7", ",", " ", "r8", ",", " ", "r9"}], "}"}]}], 
                    "}"}]}]}], ";", " ", "\n", "                        ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r1", ",", " ", "r2", ",", " ", "r3"}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "r4", ",", " ", "r5", ",", " ", "\n", 
                    "                           ", "r6"}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"r7", ",", " ", "r8", ",", " ", "r9"}], "}"}]}], 
                    "}"}], " ", "=", " ", "\n", "                         ", 
                    "dummymatrix"}], ";", " ", "1."}], ",", " ", "1."}], 
                    "]"}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"allcreatedamplitudes", " ", "!=", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"0.", "*", "I"}], ",", " ", 
                    RowBox[{"0.", "*", "I"}], ",", " ", 
                    RowBox[{"0.", "*", "I"}]}], "}"}], "}"}]}], ",", " ", 
                    "\n", "                       ", 
                    RowBox[{
                    RowBox[{"amplitude", " ", "=", " ", 
                    RowBox[{"allcreatedamplitudes", "[", 
                    RowBox[{"[", 
                    RowBox[{"First", "[", "#2", "]"}], "]"}], "]"}]}], ";", 
                    " ", 
                    RowBox[{
                    "hor", " ", "=", " ", "\n", "                         ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r4", ",", " ", "r5", ",", " ", "r6"}], "}"}], 
                    " ", ".", " ", "amplitude"}]}], ";", " ", "\n", 
                    "                        ", 
                    RowBox[{"ver", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"r7", ",", " ", "r8", ",", " ", "r9"}], "}"}], 
                    " ", ".", " ", "amplitude"}]}], ";", " ", "\n", 
                    "                        ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", "hor", "]"}], " ", ">", " ", "0."}], 
                    " ", "||", " ", 
                    RowBox[{
                    RowBox[{"Abs", "[", "ver", "]"}], " ", ">", " ", "0."}]}],
                     ",", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "pol1", ",", " ", "pol2", ",", " ", "\n", 
                    "                            ", "pol3"}], "}"}], " ", "=",
                     " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Abs", "[", "hor", "]"}], ",", " ", 
                    RowBox[{"Abs", "[", "ver", "]"}], ",", " ", "0."}], 
                    "}"}]}], ";", " ", 
                    RowBox[{
                    "dummyvector", " ", "=", " ", "\n", 
                    "                           ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], "/", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "pol1", ",", " ", "\n", "                               ",
                     "pol2", ",", " ", "pol3"}], "}"}], " ", ".", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "pol1", ",", " ", "pol2", ",", " ", "\n", 
                    "                               ", "pol3"}], "}"}]}], 
                    "]"}]}]}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}], " ", "=", " ", "\n", "                           ",
                     "dummyvector"}], ";", " ", 
                    RowBox[{"dummyvector", " ", "=", " ", 
                    RowBox[{"ReplacePart", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "pol1", ",", " ", "\n", "                             ", 
                    "pol2", ",", " ", "pol3"}], "}"}], ",", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"ver", " ", "==", " ", "0."}], ",", " ", "0.", 
                    ",", " ", 
                    RowBox[{"Arg", "[", "ver", "]"}]}], "]"}], " ", "-", " ", 
                    "\n", "                              ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"hor", " ", "==", " ", "0."}], ",", " ", "0.", 
                    ",", " ", 
                    RowBox[{"Arg", "[", "hor", "]"}]}], "]"}]}], ")"}], "/", 
                    "Degree"}], ",", " ", "3"}], "]"}]}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "pol1", ",", " ", "\n", "                            ", 
                    "pol2", ",", " ", "pol3"}], "}"}], " ", "=", " ", 
                    "dummyvector"}]}]}], "]"}], ";", " ", "1."}], ",", " ", 
                    "1."}], "]"}], ";", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "\n", "                       ", "rsy", 
                    ",", " ", "rsz", ",", " ", "rex", ",", " ", "rey", ",", 
                    " ", "rez", ",", " ", "\n", "                       ", 
                    "r1", ",", " ", "r2", ",", " ", "r3", ",", " ", "r4", ",",
                     " ", "r5", ",", " ", "\n", "                       ", 
                    "r6", ",", " ", "r7", ",", " ", "r8", ",", " ", "r9", ",",
                     " ", "wavelength", ",", " ", "\n", 
                    "                       ", "intensity", ",", " ", 
                    "intensityscale", ",", " ", "ray1", ",", " ", "index", 
                    ",", " ", "\n", "                       ", 
                    "opticallength", ",", " ", "phaseshift", ",", " ", 
                    "componentnumber", ",", " ", "\n", 
                    "                       ", "surfacenumber", ",", " ", 
                    "surfaceid", ",", " ", "ray2", ",", " ", "ray3", ",", " ",
                     "\n", "                       ", "sid", ",", " ", 
                    "frontid", ",", " ", "sno1", ",", " ", "sno2", ",", " ", 
                    "sno3", ",", " ", "\n", "                       ", "sno4",
                     ",", " ", "rayslot", ",", " ", "generationnumber", ",", 
                    " ", "intersectionnumber", ",", " ", "\n", 
                    "                       ", "pol1", ",", " ", "pol2", ",", 
                    " ", "pol3"}], "}"}]}], ")"}], " ", "&"}], " ", ",", " ", 
                    "allcreatedrays"}], "]"}]}]}], ")"}], ";", " ", "\n", 
                    "                 ", 
                    RowBox[{"{", 
                    RowBox[{"allcreatedrays", ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",",
                     " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", 
                    "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",",
                     " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", 
                    "1.", ",", " ", "1.", ",", " ", 
                    RowBox[{"-", "1.7976931348623157*^308"}], ",", " ", "1.", 
                    ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", 
                    "\n", "                    ", "0.", ",", " ", 
                    RowBox[{"-", "1."}], ",", " ", 
                    RowBox[{"-", "1."}], ",", " ", 
                    RowBox[{"-", "1."}], ",", " ", "1.", ",", " ", "1.", ",", 
                    " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.",
                     ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ",
                     "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", 
                    ",", " ", "1."}], "}"}], "}"}], ",", " ", 
                    RowBox[{"{", "completedray", "}"}]}], "}"}]}], ",", " ", 
                    "True", ",", " ", "\n", "                ", 
                    RowBox[{
                    RowBox[{
                    "deflecteddummyrayspresent", " ", "=", " ", "True"}], ";",
                     " ", 
                    RowBox[{
                    "reporteddummyrayspresent", " ", "=", " ", "True"}], ";", 
                    " ", "\n", "                 ", 
                    RowBox[{"localoutrayspresent", " ", "=", " ", "True"}], 
                    ";", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",",
                     " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", 
                    "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",",
                     " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", 
                    "1.", ",", " ", "1.", ",", " ", 
                    RowBox[{"-", "1.7976931348623157*^308"}], ",", " ", "1.", 
                    ",", " ", "\n", "                    ", "1.", ",", " ", 
                    "1.", ",", " ", "1.", ",", " ", "0.", ",", " ", 
                    RowBox[{"-", "1."}], ",", " ", 
                    RowBox[{"-", "1."}], ",", " ", 
                    RowBox[{"-", "1."}], ",", " ", "1.", ",", " ", "1.", ",", 
                    " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.",
                     ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ",
                     "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", 
                    ",", " ", "1."}], "}"}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "\n", 
                    "                    ", "rsz", ",", " ", "rex", ",", " ", 
                    "rey", ",", " ", "rez", ",", " ", "r1", ",", " ", "\n", 
                    "                    ", "r2", ",", " ", "r3", ",", " ", 
                    "r4", ",", " ", "r5", ",", " ", "r6", ",", " ", "\n", 
                    "                    ", "r7", ",", " ", "r8", ",", " ", 
                    "r9", ",", " ", "wavelength", ",", " ", "intensity", ",", 
                    " ", "\n", "                    ", "intensityscale", ",", 
                    " ", "ray1", ",", " ", "index", ",", " ", "opticallength",
                     ",", " ", "\n", "                    ", "phaseshift", 
                    ",", " ", "componentnumber", ",", " ", "surfacenumber", 
                    ",", " ", "surfaceid", ",", " ", "\n", 
                    "                    ", "ray2", ",", " ", "ray3", ",", 
                    " ", "sid", ",", " ", "frontid", ",", " ", "sno1", ",", 
                    " ", "\n", "                    ", "sno2", ",", " ", 
                    "sno3", ",", " ", "sno4", ",", " ", "rayslot", ",", " ", 
                    "\n", "                    ", "generationnumber", ",", 
                    " ", "intersectionnumber", ",", " ", "pol1", ",", " ", 
                    "pol2", ",", " ", "\n", "                    ", "pol3"}], 
                    "}"}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",",
                     " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", 
                    "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",",
                     " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", 
                    "1.", ",", " ", "1.", ",", " ", 
                    RowBox[{"-", "1.7976931348623157*^308"}], ",", " ", "1.", 
                    ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", 
                    "0.", ",", " ", "\n", "                    ", 
                    RowBox[{"-", "1."}], ",", " ", 
                    RowBox[{"-", "1."}], ",", " ", 
                    RowBox[{"-", "1."}], ",", " ", "1.", ",", " ", "1.", ",", 
                    " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.",
                     ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ",
                     "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", 
                    ",", " ", "1."}], "}"}], "}"}]}], "}"}]}]}], "]"}]}], ",",
                     " ", 
                    RowBox[{
                    RowBox[{
                    "deflecteddummyrayspresent", " ", "=", " ", "True"}], ";",
                     " ", "\n", "               ", 
                    RowBox[{
                    "reporteddummyrayspresent", " ", "=", " ", "True"}], ";", 
                    " ", 
                    RowBox[{
                    "localdummyoutrayspresent", " ", "=", " ", "True"}], ";", 
                    " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",",
                     " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", 
                    "1.", ",", " ", "1.", ",", " ", "\n", 
                    "                  ", "1.", ",", " ", "1.", ",", " ", 
                    "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",",
                     " ", "1.", ",", " ", 
                    RowBox[{"-", "1.7976931348623157*^308"}], ",", " ", "1.", 
                    ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", 
                    "0.", ",", " ", 
                    RowBox[{"-", "1."}], ",", " ", 
                    RowBox[{"-", "1."}], ",", " ", 
                    RowBox[{"-", "1."}], ",", " ", "1.", ",", " ", "1.", ",", 
                    " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.",
                     ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ",
                     "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", 
                    ",", " ", "1."}], "}"}], "}"}], ",", " ", "\n", 
                    "                ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",",
                     " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", 
                    "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",",
                     " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", 
                    "1.", ",", " ", "1.", ",", " ", 
                    RowBox[{"-", "1.7976931348623157*^308"}], ",", " ", "1.", 
                    ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", 
                    "0.", ",", " ", 
                    RowBox[{"-", "1."}], ",", " ", 
                    RowBox[{"-", "1."}], ",", " ", 
                    RowBox[{"-", "1."}], ",", " ", "1.", ",", " ", "1.", ",", 
                    " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "\n",
                     "                  ", "1.", ",", " ", "1.", ",", " ", 
                    "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",",
                     " ", "1.", ",", " ", "1.", ",", " ", "1."}], "}"}], 
                    "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",",
                     " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", 
                    "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",",
                     " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", 
                    "1.", ",", " ", "1.", ",", " ", 
                    RowBox[{"-", "1.7976931348623157*^308"}], ",", " ", "1.", 
                    ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", 
                    "\n", "                  ", "0.", ",", " ", 
                    RowBox[{"-", "1."}], ",", " ", 
                    RowBox[{"-", "1."}], ",", " ", 
                    RowBox[{"-", "1."}], ",", " ", "1.", ",", " ", "1.", ",", 
                    " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.",
                     ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ",
                     "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", 
                    ",", " ", "1."}], "}"}], "}"}]}], "}"}]}]}], "]"}]}], 
                    ")"}], " ", "&"}], " ", ")"}], " ", "/@", " ", "inrays"}],
                     "]"}]}]}], ";", " ", "\n", "       ", 
                   RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    "deflectedrayspresent", " ", "&&", " ", 
                    "deflecteddummyrayspresent"}], ",", " ", 
                    RowBox[{
                    "deflectedlocalrays", " ", "=", " ", "\n", "         ", 
                    RowBox[{
                    RowBox[{"Select", "[", 
                    RowBox[{"deflectedlocalrays", ",", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"#1", "[", 
                    RowBox[{"[", "23", "]"}], "]"}], " ", ">", " ", "0."}], 
                    " ", "&"}]}], " ", "]"}], "*", "1."}]}], ",", " ", "1."}],
                     "]"}], ";", " ", 
                   RowBox[{"If", "[", 
                    RowBox[{"localoutrayspresent", ",", " ", "\n", "        ", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{"localdummyoutrayspresent", ",", " ", 
                    RowBox[{
                    RowBox[{"localoutrays", " ", "=", " ", 
                    RowBox[{"Select", "[", 
                    RowBox[{"localoutrays", ",", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"#1", "[", 
                    RowBox[{"[", "23", "]"}], "]"}], " ", ">", " ", "0."}], 
                    " ", "&"}]}], " ", "]"}]}], ";", " ", "1."}], ",", " ", 
                    "\n", "          ", "1."}], "]"}], ";", " ", 
                    RowBox[{"outrays", " ", "=", " ", 
                    RowBox[{"Join", "[", 
                    RowBox[{"outrays", ",", " ", "localoutrays"}], "]"}]}], 
                    ";", " ", "1."}], ",", " ", "1."}], "]"}], ";", " ", "\n",
                    "       ", 
                   RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    "reportedrayspresent", " ", "&&", " ", 
                    "reporteddummyrayspresent"}], ",", " ", "\n", "        ", 
                    
                    RowBox[{
                    RowBox[{"reportedlocalrays", " ", "=", " ", 
                    RowBox[{"Select", "[", 
                    RowBox[{"reportedlocalrays", ",", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"#1", "[", 
                    RowBox[{"[", "23", "]"}], "]"}], " ", ">", " ", "0."}], 
                    " ", "&"}]}], " ", "]"}]}], ";", " ", "1."}], ",", " ", 
                    "1."}], "]"}]}], ")"}], ";", " ", "\n", "      ", 
                 RowBox[{"If", "[", 
                  RowBox[{"reportedrayspresent", ",", " ", 
                   RowBox[{
                    RowBox[{"raysreported", " ", "=", " ", "True"}], ";", " ", 
                    RowBox[{
                    "reportedrays", " ", "=", " ", "\n", "         ", 
                    RowBox[{"Join", "[", 
                    RowBox[{"reportedrays", ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1.7976931348623157*^308"}], ",", " ", 
                    RowBox[{"-", "1.7976931348623157*^308"}], ",", " ", 
                    RowBox[{"-", "1.7976931348623157*^308"}], ",", " ", 
                    RowBox[{"-", "1.7976931348623157*^308"}], ",", " ", "\n", 
                    "            ", 
                    RowBox[{"-", "1.7976931348623157*^308"}], ",", " ", 
                    RowBox[{"-", "1.7976931348623157*^308"}], ",", " ", 
                    RowBox[{"-", "1.7976931348623157*^308"}], ",", " ", 
                    RowBox[{"-", "1.7976931348623157*^308"}], ",", " ", 
                    RowBox[{"-", "1.7976931348623157*^308"}], ",", " ", "\n", 
                    "            ", 
                    RowBox[{"-", "1.7976931348623157*^308"}], ",", " ", 
                    RowBox[{"-", "1.7976931348623157*^308"}], ",", " ", 
                    RowBox[{"-", "1.7976931348623157*^308"}], ",", " ", 
                    RowBox[{"-", "1.7976931348623157*^308"}], ",", " ", 
                    RowBox[{"-", "1.7976931348623157*^308"}], ",", " ", "\n", 
                    "            ", 
                    RowBox[{"-", "1.7976931348623157*^308"}], ",", " ", 
                    RowBox[{"-", "1.7976931348623157*^308"}], ",", " ", 
                    RowBox[{"-", "1.7976931348623157*^308"}], ",", " ", 
                    RowBox[{"-", "1.7976931348623157*^308"}], ",", " ", 
                    RowBox[{"-", "1.7976931348623157*^308"}], ",", " ", "\n", 
                    "            ", 
                    RowBox[{"-", "1.7976931348623157*^308"}], ",", " ", 
                    RowBox[{"-", "1.7976931348623157*^308"}], ",", " ", 
                    RowBox[{"-", "1.7976931348623157*^308"}], ",", " ", 
                    RowBox[{"-", "1.7976931348623157*^308"}], ",", " ", 
                    RowBox[{"-", "1.7976931348623157*^308"}], ",", " ", "\n", 
                    "            ", 
                    RowBox[{"-", "1.7976931348623157*^308"}], ",", " ", 
                    RowBox[{"-", "1.7976931348623157*^308"}], ",", " ", 
                    RowBox[{"-", "1.7976931348623157*^308"}], ",", " ", 
                    RowBox[{"-", "1.7976931348623157*^308"}], ",", " ", 
                    RowBox[{"-", "1.7976931348623157*^308"}], ",", " ", "\n", 
                    "            ", 
                    RowBox[{"-", "1.7976931348623157*^308"}], ",", " ", 
                    RowBox[{"-", "1.7976931348623157*^308"}], ",", " ", 
                    RowBox[{"-", "1.7976931348623157*^308"}], ",", " ", 
                    RowBox[{"-", "1.7976931348623157*^308"}], ",", " ", 
                    RowBox[{"-", "1.7976931348623157*^308"}], ",", " ", "\n", 
                    "            ", 
                    RowBox[{"-", "1.7976931348623157*^308"}], ",", " ", 
                    RowBox[{"-", "1.7976931348623157*^308"}], ",", " ", 
                    RowBox[{"-", "1.7976931348623157*^308"}], ",", " ", 
                    RowBox[{"-", "1.7976931348623157*^308"}], ",", " ", 
                    RowBox[{"-", "1.7976931348623157*^308"}]}], "}"}], "}"}], 
                    ",", " ", "\n", "          ", "reportedlocalrays"}], 
                    "]"}]}], ";", " ", "1."}], ",", " ", "1."}], "]"}], ";", 
                 " ", 
                 RowBox[{"inrays", " ", "=", " ", "deflectedlocalrays"}], ";",
                  " ", "\n", "      ", 
                 RowBox[{"propagate", " ", "=", " ", 
                  RowBox[{
                  "generationnumber", " ", "<", " ", 
                   "generationlimit"}]}]}]}], "]"}], ";", " ", "\n", "    ", 
              RowBox[{"propagatedrays", " ", "=", " ", 
               RowBox[{"If", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"Length", "[", "outrays", "]"}], " ", ">", " ", 
                  "1"}], ",", " ", 
                 RowBox[{"Drop", "[", 
                  RowBox[{"outrays", ",", " ", "1"}], "]"}], ",", " ", 
                 "outrays"}], "]"}]}], ";", " ", "\n", "    ", 
              RowBox[{"If", "[", 
               RowBox[{
                RowBox[{
                 RowBox[{
                 "generationnumber", " ", ">=", " ", "generationlimit"}], " ",
                  "&&", " ", "deflectedrayspresent"}], ",", " ", "\n", 
                "     ", 
                RowBox[{
                 RowBox[{"propagatedrays", " ", "=", " ", 
                  RowBox[{"Join", "[", 
                   RowBox[{"propagatedrays", ",", " ", "deflectedlocalrays"}],
                    "]"}]}], ";", " ", "1."}], ",", " ", "1."}], "]"}]}], 
             ")"}], ";", " ", "\n", "   ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"inrays", " ", "=", " ", "propagatedrays"}], ";", " ", 
              RowBox[{"outrays", " ", "=", " ", "\n", "     ", 
               RowBox[{"{", 
                RowBox[{"{", 
                 RowBox[{
                 "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", 
                  " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", 
                  ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", 
                  "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", 
                  " ", "1.", ",", " ", 
                  RowBox[{"-", "1.7976931348623157*^308"}], ",", " ", "1.", 
                  ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", 
                  "0.", ",", " ", 
                  RowBox[{"-", "1."}], ",", " ", 
                  RowBox[{"-", "1."}], ",", " ", 
                  RowBox[{"-", "1."}], ",", " ", "1.", ",", " ", "1.", ",", 
                  " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", 
                  ",", " ", "1.", ",", " ", "1.", ",", " ", "\n", "       ", 
                  "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", 
                  " ", "1.", ",", " ", "1."}], "}"}], "}"}]}], ";", " ", 
              RowBox[{"deflectedrayspresent", " ", "=", " ", "True"}], ";", 
              " ", 
              RowBox[{"reportedrayspresent", " ", "=", " ", "False"}], ";", 
              " ", "\n", "    ", 
              RowBox[{"propagate", " ", "=", " ", "True"}], ";", " ", 
              RowBox[{"While", "[", 
               RowBox[{
                RowBox[{"deflectedrayspresent", " ", "&&", " ", "propagate"}],
                 ",", " ", "\n", "     ", 
                RowBox[{
                 RowBox[{"generationnumber", " ", "+=", " ", "1."}], ";", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                   "deflecteddummyrayspresent", " ", "=", " ", "False"}], ";",
                    " ", 
                   RowBox[{"deflectedrayspresent", " ", "=", " ", "False"}], 
                   ";", " ", "\n", "       ", 
                   RowBox[{"reportedrayspresent", " ", "=", " ", "False"}], 
                   ";", " ", 
                   RowBox[{
                   "reporteddummyrayspresent", " ", "=", " ", "True"}], ";", 
                   " ", 
                   RowBox[{
                   "localdummyoutrayspresent", " ", "=", " ", "\n", 
                    "        ", "False"}], ";", " ", 
                   RowBox[{"localoutrayspresent", " ", "=", " ", "False"}], 
                   ";", " ", 
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "deflectedlocalrays", ",", " ", "localoutrays", ",", " ", 
                    "\n", "         ", "reportedlocalrays"}], "}"}], " ", "=",
                     " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"Flatten", "[", 
                    RowBox[{"#1", ",", " ", "1"}], "]"}], " ", "&"}], " ", 
                    ")"}], " ", "/@", " ", "\n", "         ", 
                    RowBox[{"Transpose", "[", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "\n", "               ", "rez",
                     ",", " ", "r1", ",", " ", "r2", ",", " ", "r3", ",", " ",
                     "r4", ",", " ", "\n", "               ", "r5", ",", " ", 
                    "r6", ",", " ", "r7", ",", " ", "r8", ",", " ", "r9", ",",
                     " ", "\n", "               ", "wavelength", ",", " ", 
                    "intensity", ",", " ", "intensityscale", ",", " ", "ray1",
                     ",", " ", "\n", "               ", "index", ",", " ", 
                    "opticallength", ",", " ", "phaseshift", ",", " ", 
                    "componentnumber", ",", " ", "\n", "               ", 
                    "surfacenumber", ",", " ", "surfaceid", ",", " ", "ray2", 
                    ",", " ", "ray3", ",", " ", "\n", "               ", 
                    "sid", ",", " ", "frontid", ",", " ", "sno1", ",", " ", 
                    "sno2", ",", " ", "sno3", ",", " ", "\n", 
                    "               ", "sno4", ",", " ", "rayslot", ",", " ", 
                    "oldgenerationnumber", ",", " ", "intersectionnumber", 
                    ",", " ", "\n", "               ", "pol1", ",", " ", 
                    "pol2", ",", " ", "pol3"}], "}"}], " ", "=", " ", "#1"}], 
                    ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    "intensity", " ", ">", " ", "\n", "                ", 
                    "thresholdintensity"}], " ", "&&", " ", 
                    RowBox[{
                    "generationnumber", " ", "<", " ", "generationlimit"}]}], 
                    ",", " ", "\n", "              ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"resonatenumber", " ", "=", " ", "0"}], ";", " ", 
                    
                    RowBox[{
                    "resonateraylength", " ", "=", " ", 
                    "1.7976931348623157*^308"}], ";", " ", "\n", 
                    "                ", 
                    RowBox[{"resonateintersections", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}], "}"}]}], ";", " ", 
                    RowBox[{"MapIndexed", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"#1", "[", 
                    RowBox[{"[", 
                    RowBox[{"1", ",", "1"}], "]"}], "]"}], " ", ">", " ", 
                    RowBox[{"-", "1."}]}], " ", "&&", " ", 
                    RowBox[{
                    RowBox[{"#1", "[", 
                    RowBox[{"[", 
                    RowBox[{"1", ",", "1"}], "]"}], "]"}], " ", "<", " ", 
                    "resonateraylength"}]}], ",", " ", "\n", 
                    "                   ", 
                    RowBox[{
                    RowBox[{"resonateraylength", " ", "=", " ", 
                    RowBox[{"#1", "[", 
                    RowBox[{"[", 
                    RowBox[{"1", ",", "1"}], "]"}], "]"}]}], ";", " ", 
                    RowBox[{"resonateintersections", " ", "=", " ", "#1"}], 
                    ";", " ", 
                    RowBox[{
                    "resonatenumber", " ", "=", " ", "\n", 
                    "                     ", 
                    RowBox[{"First", "[", "#2", "]"}]}]}], ",", " ", 
                    "resonatenumber"}], "]"}], " ", "&"}], " ", ",", " ", 
                    RowBox[{
                    RowBox[{"intersectionslist", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}], "}"}], "}"}]}], ";", " ", "\n", 
                    "                  ", 
                    RowBox[{"holeQlist", " ", "=", " ", 
                    RowBox[{"{", "0", "}"}]}], ";", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "\n", 
                    "                     ", "rex", ",", " ", "rey", ",", " ",
                     "rez", ",", " ", "r1", ",", " ", "r2", ",", " ", "\n", 
                    "                     ", "r3", ",", " ", "r4", ",", " ", 
                    "r5", ",", " ", "r6", ",", " ", "r7", ",", " ", "\n", 
                    "                     ", "r8", ",", " ", "r9", ",", " ", 
                    "wavelength", ",", " ", "intensity", ",", " ", "\n", 
                    "                     ", "intensityscale", ",", " ", 
                    "ray1", ",", " ", "index", ",", " ", "opticallength", ",",
                     " ", "\n", "                     ", "phaseshift", ",", 
                    " ", "componentnumber", ",", " ", "surfacenumber", ",", 
                    " ", "surfaceid", ",", " ", "\n", "                     ",
                     "ray2", ",", " ", "ray3", ",", " ", "sid", ",", " ", 
                    "frontid", ",", " ", "sno1", ",", " ", "\n", 
                    "                     ", "sno2", ",", " ", "sno3", ",", 
                    " ", "sno4", ",", " ", "rayslot", ",", " ", "\n", 
                    "                     ", "oldgenerationnumber", ",", " ", 
                    "intersectionnumber", ",", " ", "pol1", ",", " ", "pol2", 
                    ",", " ", "\n", "                     ", "pol3"}], "}"}], 
                    " ", "=", " ", "#1"}], ";", " ", 
                    RowBox[{"index1", " ", "=", " ", "index"}], ";", " ", 
                    RowBox[{
                    "xunit", " ", "=", " ", "\n", "                    ", 
                    RowBox[{
                    RowBox[{"-", "1."}], "*", "r1"}]}], ";", " ", 
                    RowBox[{"yunit", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"-", "1."}], "*", "r2"}]}], ";", " ", 
                    RowBox[{"zunit", " ", "=", " ", "r3"}], ";", " ", "\n", 
                    "                   ", 
                    RowBox[{"xunit", " ", "=", " ", 
                    RowBox[{"Chop", "[", "xunit", "]"}]}], ";", " ", 
                    RowBox[{"yunit", " ", "=", " ", 
                    RowBox[{"Chop", "[", "yunit", "]"}]}], ";", " ", "\n", 
                    "                   ", 
                    RowBox[{"zunit", " ", "=", " ", 
                    RowBox[{"Chop", "[", "zunit", "]"}]}], ";", " ", 
                    RowBox[{"magnitude", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"xunit", "^", "2"}], " ", "+", " ", "\n", 
                    "                      ", 
                    RowBox[{"yunit", "^", "2"}], " ", "+", " ", 
                    RowBox[{"zunit", "^", "2"}]}], ")"}], "^", 
                    RowBox[{"2", "^", 
                    RowBox[{"(", 
                    RowBox[{"-", "1"}], ")"}]}]}]}], ";", " ", 
                    RowBox[{"xunit", " ", "=", " ", 
                    RowBox[{
                    "xunit", "/", "\n", "                     ", 
                    "magnitude"}]}], ";", " ", 
                    RowBox[{"yunit", " ", "=", " ", 
                    RowBox[{"yunit", "/", "magnitude"}]}], ";", " ", "\n", 
                    "                   ", 
                    RowBox[{"zunit", " ", "=", " ", 
                    RowBox[{"zunit", "/", "magnitude"}]}], ";", " ", 
                    RowBox[{"rx", " ", "=", " ", "\n", "                    ", 
                    RowBox[{
                    RowBox[{"-", "1."}], "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "200."}], " ", "+", " ", "rex"}], ")"}]}]}], 
                    ";", " ", 
                    RowBox[{"ry", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"-", "1."}], "*", "rey"}]}], ";", " ", 
                    RowBox[{
                    "rz", " ", "=", " ", "\n", "                    ", 
                    "rez"}], ";", " ", 
                    RowBox[{"rx", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rx", "]"}]}], ";", " ", 
                    RowBox[{"ry", " ", "=", " ", 
                    RowBox[{"Chop", "[", "ry", "]"}]}], ";", " ", "\n", 
                    "                   ", 
                    RowBox[{"rz", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rz", "]"}]}], ";", " ", 
                    RowBox[{"terminatedeflection", " ", "=", " ", "False"}], 
                    ";", " ", "\n", "                   ", 
                    RowBox[{"intersections", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}], "}"}]}], ";", " ", 
                    RowBox[{"intersections", " ", "=", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Chop", "[", "xunit", "]"}], " ", "!=", " ", 
                    "0"}], ",", " ", "\n", "                     ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"N", "[", 
                    RowBox[{"Chop", "[", 
                    RowBox[{"#1", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "]"}], "]"}], " ", ">=", 
                    " ", "0."}], " ", "&&", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"#1", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], " ", "<=", " ", "75."}], 
                    " ", "&&", " ", 
                    RowBox[{
                    RowBox[{"#1", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], " ", ">=", " ", 
                    RowBox[{"-", "75."}]}], " ", "&&", " ", 
                    RowBox[{
                    RowBox[{"#1", "[", 
                    RowBox[{"[", "3", "]"}], "]"}], " ", ">=", " ", 
                    RowBox[{"-", "75."}]}], " ", "&&", " ", 
                    RowBox[{
                    RowBox[{"#1", "[", 
                    RowBox[{"[", "3", "]"}], "]"}], " ", "<=", " ", "75."}]}],
                     ")"}]}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"#1", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], ",", " ", 
                    RowBox[{"#1", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], ",", " ", 
                    RowBox[{"#1", "[", 
                    RowBox[{"[", "3", "]"}], "]"}]}], "}"}], ",", " ", "\n", 
                    "                         ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}]}], "]"}], " ", "&"}], " ", ")"}], "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"(", 
                    RowBox[{"rx", "/", "xunit"}], ")"}]}], ",", " ", 
                    RowBox[{"ry", " ", "-", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    "rx", "*", "\n", "                           ", "yunit"}],
                     ")"}], "/", "xunit"}]}], ",", " ", 
                    RowBox[{"rz", " ", "-", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    "rx", "*", "\n", "                           ", "zunit"}],
                     ")"}], "/", "xunit"}]}]}], "}"}], "]"}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}], "}"}]}], "]"}]}], ";", " ", 
                    RowBox[{"AppendTo", "[", 
                    RowBox[{
                    "intersections", ",", " ", "\n", "                    ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}]}], "]"}], ";", " ", 
                    RowBox[{"holeQ", " ", "=", " ", "False"}], ";", " ", 
                    RowBox[{"If", "[", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"!", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Chop", "[", 
                    RowBox[{"surfaceid", " ", "-", " ", "16598."}], "]"}], 
                    " ", "==", " ", "0."}], " ", "||", " ", "\n", 
                    "                       ", 
                    RowBox[{
                    RowBox[{"N", "[", 
                    RowBox[{"Chop", "[", "ray1", "]"}], "]"}], " ", "<", " ", 
                    "0.0001"}]}], ")"}]}], " ", "||", " ", 
                    RowBox[{"generationnumber", " ", "==", " ", "1."}]}], ",",
                     " ", 
                    RowBox[{
                    "minresonateraylength", " ", "=", " ", "\n", 
                    "                     ", "0."}], ",", " ", 
                    RowBox[{
                    "minresonateraylength", " ", "=", " ", "0.0001"}]}], 
                    "]"}], ";", " ", 
                    RowBox[{"Block", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"RayL", ",", " ", "SCx", ",", " ", "SCy"}], "}"}],
                     ",", " ", 
                    RowBox[{
                    RowBox[{"RayL", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"SCx", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"SCy", " ", "=", " ", "1."}], ";", " ", "\n", 
                    "                     ", 
                    RowBox[{"dummymatrix", " ", "=", " ", 
                    RowBox[{"Union", "[", 
                    RowBox[{"Select", "[", 
                    RowBox[{"intersections", ",", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"RayL", ",", " ", "SCx", ",", " ", "SCy"}], "}"}],
                     " ", "=", " ", "#1"}], ";", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"RayL", ",", " ", "SCx", ",", " ", "SCy"}], "}"}],
                     " ", "==", " ", "\n", "                            ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}]}], " ", "||", " ", 
                    RowBox[{
                    RowBox[{"N", "[", 
                    RowBox[{"Chop", "[", "RayL", "]"}], "]"}], " ", ">=", " ",
                     "minresonateraylength"}]}]}], ")"}], " ", "&"}]}], " ", 
                    "]"}], "]"}]}], ";", " ", 
                    RowBox[{
                    "intersections", " ", "=", " ", "\n", 
                    "                      ", "dummymatrix"}]}]}], "]"}], ";",
                     " ", 
                    RowBox[{
                    "unfilteredintersections", " ", "=", " ", 
                    "intersections"}], ";", " ", "\n", "                   ", 
                    
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", "intersections", "]"}], " ", ">", 
                    " ", "1"}], ",", " ", 
                    RowBox[{
                    RowBox[{"dummymatrix", " ", "=", " ", 
                    RowBox[{"Take", "[", 
                    RowBox[{"intersections", ",", " ", 
                    RowBox[{"{", "2", "}"}]}], "]"}]}], ";", " ", "\n", 
                    "                     ", 
                    RowBox[{"intersections", " ", "=", " ", "dummymatrix"}], 
                    ";", " ", "1."}], ",", " ", "1."}], "]"}], ";", " ", 
                    RowBox[{"AppendTo", "[", 
                    RowBox[{
                    "intersectionslist", ",", " ", "\n", 
                    "                    ", "intersections"}], "]"}], ";", 
                    " ", 
                    RowBox[{"If", "[", 
                    RowBox[{"holeQ", ",", " ", 
                    RowBox[{"AppendTo", "[", 
                    RowBox[{"holeQlist", ",", " ", "1"}], "]"}], ",", " ", 
                    "\n", "                    ", 
                    RowBox[{"AppendTo", "[", 
                    RowBox[{"holeQlist", ",", " ", "0"}], "]"}]}], "]"}], ";",
                     " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "\n", 
                    "                     ", "rex", ",", " ", "rey", ",", " ",
                     "rez", ",", " ", "r1", ",", " ", "r2", ",", " ", "\n", 
                    "                     ", "r3", ",", " ", "r4", ",", " ", 
                    "r5", ",", " ", "r6", ",", " ", "r7", ",", " ", "\n", 
                    "                     ", "r8", ",", " ", "r9", ",", " ", 
                    "wavelength", ",", " ", "intensity", ",", " ", "\n", 
                    "                     ", "intensityscale", ",", " ", 
                    "ray1", ",", " ", "index", ",", " ", "opticallength", ",",
                     " ", "\n", "                     ", "phaseshift", ",", 
                    " ", "componentnumber", ",", " ", "surfacenumber", ",", 
                    " ", "surfaceid", ",", " ", "\n", "                     ",
                     "ray2", ",", " ", "ray3", ",", " ", "sid", ",", " ", 
                    "frontid", ",", " ", "sno1", ",", " ", "\n", 
                    "                     ", "sno2", ",", " ", "sno3", ",", 
                    " ", "sno4", ",", " ", "rayslot", ",", " ", "\n", 
                    "                     ", "oldgenerationnumber", ",", " ", 
                    "intersectionnumber", ",", " ", "pol1", ",", " ", "pol2", 
                    ",", " ", "\n", "                     ", "pol3"}], "}"}], 
                    " ", "=", " ", "#1"}], ";", " ", 
                    RowBox[{"index1", " ", "=", " ", "index"}], ";", " ", 
                    RowBox[{
                    "xunit", " ", "=", " ", "\n", "                    ", 
                    "r2"}], ";", " ", 
                    RowBox[{"yunit", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"-", "1."}], "*", "r1"}]}], ";", " ", 
                    RowBox[{"zunit", " ", "=", " ", "r3"}], ";", " ", "\n", 
                    "                   ", 
                    RowBox[{"xunit", " ", "=", " ", 
                    RowBox[{"Chop", "[", "xunit", "]"}]}], ";", " ", 
                    RowBox[{"yunit", " ", "=", " ", 
                    RowBox[{"Chop", "[", "yunit", "]"}]}], ";", " ", "\n", 
                    "                   ", 
                    RowBox[{"zunit", " ", "=", " ", 
                    RowBox[{"Chop", "[", "zunit", "]"}]}], ";", " ", 
                    RowBox[{"magnitude", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"xunit", "^", "2"}], " ", "+", " ", "\n", 
                    "                      ", 
                    RowBox[{"yunit", "^", "2"}], " ", "+", " ", 
                    RowBox[{"zunit", "^", "2"}]}], ")"}], "^", 
                    RowBox[{"2", "^", 
                    RowBox[{"(", 
                    RowBox[{"-", "1"}], ")"}]}]}]}], ";", " ", 
                    RowBox[{"xunit", " ", "=", " ", 
                    RowBox[{
                    "xunit", "/", "\n", "                     ", 
                    "magnitude"}]}], ";", " ", 
                    RowBox[{"yunit", " ", "=", " ", 
                    RowBox[{"yunit", "/", "magnitude"}]}], ";", " ", "\n", 
                    "                   ", 
                    RowBox[{"zunit", " ", "=", " ", 
                    RowBox[{"zunit", "/", "magnitude"}]}], ";", " ", 
                    RowBox[{"rx", " ", "=", " ", "\n", "                    ", 
                    RowBox[{"75.", " ", "+", " ", "rey"}]}], ";", " ", 
                    RowBox[{"ry", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"-", "1."}], "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "100."}], " ", "+", " ", "rex"}], ")"}]}]}], 
                    ";", " ", 
                    RowBox[{
                    "rz", " ", "=", " ", "\n", "                    ", 
                    "rez"}], ";", " ", 
                    RowBox[{"rx", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rx", "]"}]}], ";", " ", 
                    RowBox[{"ry", " ", "=", " ", 
                    RowBox[{"Chop", "[", "ry", "]"}]}], ";", " ", "\n", 
                    "                   ", 
                    RowBox[{"rz", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rz", "]"}]}], ";", " ", 
                    RowBox[{"terminatedeflection", " ", "=", " ", "False"}], 
                    ";", " ", "\n", "                   ", 
                    RowBox[{"intersections", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}], "}"}]}], ";", " ", 
                    RowBox[{"intersections", " ", "=", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Chop", "[", "xunit", "]"}], " ", "!=", " ", 
                    "0"}], ",", " ", "\n", "                     ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"N", "[", 
                    RowBox[{"Chop", "[", 
                    RowBox[{"#1", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "]"}], "]"}], " ", ">=", 
                    " ", "0."}], " ", "&&", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"#1", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], " ", "<=", " ", "100."}], 
                    " ", "&&", " ", 
                    RowBox[{
                    RowBox[{"#1", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], " ", ">=", " ", 
                    RowBox[{"-", "100."}]}], " ", "&&", " ", 
                    RowBox[{
                    RowBox[{"#1", "[", 
                    RowBox[{"[", "3", "]"}], "]"}], " ", ">=", " ", 
                    RowBox[{"-", "75."}]}], " ", "&&", " ", 
                    RowBox[{
                    RowBox[{"#1", "[", 
                    RowBox[{"[", "3", "]"}], "]"}], " ", "<=", " ", "75."}]}],
                     ")"}]}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"#1", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], ",", " ", 
                    RowBox[{"#1", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], ",", " ", 
                    RowBox[{"#1", "[", 
                    RowBox[{"[", "3", "]"}], "]"}]}], "}"}], ",", " ", "\n", 
                    "                         ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}]}], "]"}], " ", "&"}], " ", ")"}], "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"(", 
                    RowBox[{"rx", "/", "xunit"}], ")"}]}], ",", " ", 
                    RowBox[{"ry", " ", "-", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    "rx", "*", "\n", "                           ", "yunit"}],
                     ")"}], "/", "xunit"}]}], ",", " ", 
                    RowBox[{"rz", " ", "-", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    "rx", "*", "\n", "                           ", "zunit"}],
                     ")"}], "/", "xunit"}]}]}], "}"}], "]"}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}], "}"}]}], "]"}]}], ";", " ", 
                    RowBox[{"AppendTo", "[", 
                    RowBox[{
                    "intersections", ",", " ", "\n", "                    ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}]}], "]"}], ";", " ", 
                    RowBox[{"holeQ", " ", "=", " ", "False"}], ";", " ", 
                    RowBox[{"If", "[", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"!", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Chop", "[", 
                    RowBox[{"surfaceid", " ", "-", " ", "16599."}], "]"}], 
                    " ", "==", " ", "0."}], " ", "||", " ", "\n", 
                    "                       ", 
                    RowBox[{
                    RowBox[{"N", "[", 
                    RowBox[{"Chop", "[", "ray1", "]"}], "]"}], " ", "<", " ", 
                    "0.0001"}]}], ")"}]}], " ", "||", " ", 
                    RowBox[{"generationnumber", " ", "==", " ", "1."}]}], ",",
                     " ", 
                    RowBox[{
                    "minresonateraylength", " ", "=", " ", "\n", 
                    "                     ", "0."}], ",", " ", 
                    RowBox[{
                    "minresonateraylength", " ", "=", " ", "0.0001"}]}], 
                    "]"}], ";", " ", 
                    RowBox[{"Block", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"RayL", ",", " ", "SCx", ",", " ", "SCy"}], "}"}],
                     ",", " ", 
                    RowBox[{
                    RowBox[{"RayL", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"SCx", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"SCy", " ", "=", " ", "1."}], ";", " ", "\n", 
                    "                     ", 
                    RowBox[{"dummymatrix", " ", "=", " ", 
                    RowBox[{"Union", "[", 
                    RowBox[{"Select", "[", 
                    RowBox[{"intersections", ",", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"RayL", ",", " ", "SCx", ",", " ", "SCy"}], "}"}],
                     " ", "=", " ", "#1"}], ";", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"RayL", ",", " ", "SCx", ",", " ", "SCy"}], "}"}],
                     " ", "==", " ", "\n", "                            ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}]}], " ", "||", " ", 
                    RowBox[{
                    RowBox[{"N", "[", 
                    RowBox[{"Chop", "[", "RayL", "]"}], "]"}], " ", ">=", " ",
                     "minresonateraylength"}]}]}], ")"}], " ", "&"}]}], " ", 
                    "]"}], "]"}]}], ";", " ", 
                    RowBox[{
                    "intersections", " ", "=", " ", "\n", 
                    "                      ", "dummymatrix"}]}]}], "]"}], ";",
                     " ", 
                    RowBox[{
                    "unfilteredintersections", " ", "=", " ", 
                    "intersections"}], ";", " ", "\n", "                   ", 
                    
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", "intersections", "]"}], " ", ">", 
                    " ", "1"}], ",", " ", 
                    RowBox[{
                    RowBox[{"dummymatrix", " ", "=", " ", 
                    RowBox[{"Take", "[", 
                    RowBox[{"intersections", ",", " ", 
                    RowBox[{"{", "2", "}"}]}], "]"}]}], ";", " ", "\n", 
                    "                     ", 
                    RowBox[{"intersections", " ", "=", " ", "dummymatrix"}], 
                    ";", " ", "1."}], ",", " ", "1."}], "]"}], ";", " ", 
                    RowBox[{"AppendTo", "[", 
                    RowBox[{
                    "intersectionslist", ",", " ", "\n", 
                    "                    ", "intersections"}], "]"}], ";", 
                    " ", 
                    RowBox[{"If", "[", 
                    RowBox[{"holeQ", ",", " ", 
                    RowBox[{"AppendTo", "[", 
                    RowBox[{"holeQlist", ",", " ", "1"}], "]"}], ",", " ", 
                    "\n", "                    ", 
                    RowBox[{"AppendTo", "[", 
                    RowBox[{"holeQlist", ",", " ", "0"}], "]"}]}], "]"}], ";",
                     " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "\n", 
                    "                     ", "rex", ",", " ", "rey", ",", " ",
                     "rez", ",", " ", "r1", ",", " ", "r2", ",", " ", "\n", 
                    "                     ", "r3", ",", " ", "r4", ",", " ", 
                    "r5", ",", " ", "r6", ",", " ", "r7", ",", " ", "\n", 
                    "                     ", "r8", ",", " ", "r9", ",", " ", 
                    "wavelength", ",", " ", "intensity", ",", " ", "\n", 
                    "                     ", "intensityscale", ",", " ", 
                    "ray1", ",", " ", "index", ",", " ", "opticallength", ",",
                     " ", "\n", "                     ", "phaseshift", ",", 
                    " ", "componentnumber", ",", " ", "surfacenumber", ",", 
                    " ", "surfaceid", ",", " ", "\n", "                     ",
                     "ray2", ",", " ", "ray3", ",", " ", "sid", ",", " ", 
                    "frontid", ",", " ", "sno1", ",", " ", "\n", 
                    "                     ", "sno2", ",", " ", "sno3", ",", 
                    " ", "sno4", ",", " ", "rayslot", ",", " ", "\n", 
                    "                     ", "oldgenerationnumber", ",", " ", 
                    "intersectionnumber", ",", " ", "pol1", ",", " ", "pol2", 
                    ",", " ", "\n", "                     ", "pol3"}], "}"}], 
                    " ", "=", " ", "#1"}], ";", " ", 
                    RowBox[{"index1", " ", "=", " ", "index"}], ";", " ", 
                    RowBox[{
                    "xunit", " ", "=", " ", "\n", "                    ", 
                    "r1"}], ";", " ", 
                    RowBox[{"yunit", " ", "=", " ", "r2"}], ";", " ", 
                    RowBox[{"zunit", " ", "=", " ", "r3"}], ";", " ", "\n", 
                    "                   ", 
                    RowBox[{"xunit", " ", "=", " ", 
                    RowBox[{"Chop", "[", "xunit", "]"}]}], ";", " ", 
                    RowBox[{"yunit", " ", "=", " ", 
                    RowBox[{"Chop", "[", "yunit", "]"}]}], ";", " ", "\n", 
                    "                   ", 
                    RowBox[{"zunit", " ", "=", " ", 
                    RowBox[{"Chop", "[", "zunit", "]"}]}], ";", " ", 
                    RowBox[{"magnitude", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"xunit", "^", "2"}], " ", "+", " ", "\n", 
                    "                      ", 
                    RowBox[{"yunit", "^", "2"}], " ", "+", " ", 
                    RowBox[{"zunit", "^", "2"}]}], ")"}], "^", 
                    RowBox[{"2", "^", 
                    RowBox[{"(", 
                    RowBox[{"-", "1"}], ")"}]}]}]}], ";", " ", 
                    RowBox[{"xunit", " ", "=", " ", 
                    RowBox[{
                    "xunit", "/", "\n", "                     ", 
                    "magnitude"}]}], ";", " ", 
                    RowBox[{"yunit", " ", "=", " ", 
                    RowBox[{"yunit", "/", "magnitude"}]}], ";", " ", "\n", 
                    "                   ", 
                    RowBox[{"zunit", " ", "=", " ", 
                    RowBox[{"zunit", "/", "magnitude"}]}], ";", " ", 
                    RowBox[{"rx", " ", "=", " ", "rex"}], ";", " ", "\n", 
                    "                   ", 
                    RowBox[{"ry", " ", "=", " ", "rey"}], ";", " ", 
                    RowBox[{"rz", " ", "=", " ", "rez"}], ";", " ", 
                    RowBox[{"rx", " ", "=", " ", "\n", "                    ", 
                    RowBox[{"Chop", "[", "rx", "]"}]}], ";", " ", 
                    RowBox[{"ry", " ", "=", " ", 
                    RowBox[{"Chop", "[", "ry", "]"}]}], ";", " ", 
                    RowBox[{"rz", " ", "=", " ", "\n", "                    ", 
                    RowBox[{"Chop", "[", "rz", "]"}]}], ";", " ", 
                    RowBox[{"terminatedeflection", " ", "=", " ", "False"}], 
                    ";", " ", 
                    RowBox[{"intersections", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}], "}"}]}], ";", " ", "\n", "                   ", 
                    RowBox[{"intersections", " ", "=", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Chop", "[", "xunit", "]"}], " ", "!=", " ", 
                    "0"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"N", "[", 
                    RowBox[{"Chop", "[", 
                    RowBox[{"#1", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "]"}], "]"}], " ", ">=", 
                    " ", "0."}], " ", "&&", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"#1", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], " ", "<=", " ", "75."}], 
                    " ", "&&", " ", "\n", "                           ", 
                    RowBox[{
                    RowBox[{"#1", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], " ", ">=", " ", 
                    RowBox[{"-", "75."}]}], " ", "&&", " ", 
                    RowBox[{
                    RowBox[{"#1", "[", 
                    RowBox[{"[", "3", "]"}], "]"}], " ", ">=", " ", 
                    RowBox[{"-", "75."}]}], " ", "&&", " ", 
                    RowBox[{
                    RowBox[{"#1", "[", 
                    RowBox[{"[", "3", "]"}], "]"}], " ", "<=", " ", "75."}]}],
                     ")"}]}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"#1", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], ",", " ", 
                    RowBox[{"#1", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], ",", " ", 
                    RowBox[{"#1", "[", 
                    RowBox[{"[", "3", "]"}], "]"}]}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}]}], "]"}], " ", "&"}], " ", ")"}], "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"(", 
                    RowBox[{
                    "rx", "/", "\n", "                          ", "xunit"}], 
                    ")"}]}], ",", " ", 
                    RowBox[{"ry", " ", "-", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"rx", "*", "yunit"}], ")"}], "/", "\n", 
                    "                          ", "xunit"}]}], ",", " ", 
                    RowBox[{"rz", " ", "-", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"rx", "*", "zunit"}], ")"}], "/", "\n", 
                    "                          ", "xunit"}]}]}], "}"}], "]"}],
                     "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}], "}"}]}], "]"}]}], ";", " ", 
                    RowBox[{"AppendTo", "[", 
                    RowBox[{"intersections", ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}]}], "]"}], ";", " ", "\n", "                   ", 
                    RowBox[{"holeQ", " ", "=", " ", "False"}], ";", " ", 
                    RowBox[{"If", "[", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"!", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Chop", "[", 
                    RowBox[{"surfaceid", " ", "-", " ", "16600."}], "]"}], 
                    " ", "==", " ", "0."}], " ", "||", " ", 
                    RowBox[{
                    RowBox[{"N", "[", 
                    RowBox[{"Chop", "[", "ray1", "]"}], "]"}], " ", "<", " ", 
                    "\n", "                        ", "0.0001"}]}], ")"}]}], 
                    " ", "||", " ", 
                    RowBox[{"generationnumber", " ", "==", " ", "1."}]}], ",",
                     " ", 
                    RowBox[{"minresonateraylength", " ", "=", " ", "0."}], 
                    ",", " ", "\n", "                    ", 
                    RowBox[{
                    "minresonateraylength", " ", "=", " ", "0.0001"}]}], 
                    "]"}], ";", " ", 
                    RowBox[{"Block", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"RayL", ",", " ", "SCx", ",", " ", "SCy"}], "}"}],
                     ",", " ", 
                    RowBox[{
                    RowBox[{"RayL", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"SCx", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"SCy", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{
                    "dummymatrix", " ", "=", " ", "\n", 
                    "                      ", 
                    RowBox[{"Union", "[", 
                    RowBox[{"Select", "[", 
                    RowBox[{"intersections", ",", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"RayL", ",", " ", "SCx", ",", " ", "SCy"}], "}"}],
                     " ", "=", " ", "#1"}], ";", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"RayL", ",", " ", "SCx", ",", " ", "SCy"}], "}"}],
                     " ", "==", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}]}], " ", "||", " ", 
                    RowBox[{
                    RowBox[{"N", "[", 
                    RowBox[{"Chop", "[", "RayL", "]"}], "]"}], " ", ">=", " ",
                     "\n", "                            ", 
                    "minresonateraylength"}]}]}], ")"}], " ", "&"}]}], " ", 
                    "]"}], "]"}]}], ";", " ", 
                    RowBox[{
                    "intersections", " ", "=", " ", "dummymatrix"}]}]}], 
                    "]"}], ";", " ", "\n", "                   ", 
                    RowBox[{
                    "unfilteredintersections", " ", "=", " ", 
                    "intersections"}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", "intersections", "]"}], " ", ">", 
                    " ", "1"}], ",", " ", "\n", "                    ", 
                    RowBox[{
                    RowBox[{"dummymatrix", " ", "=", " ", 
                    RowBox[{"Take", "[", 
                    RowBox[{"intersections", ",", " ", 
                    RowBox[{"{", "2", "}"}]}], "]"}]}], ";", " ", 
                    RowBox[{
                    "intersections", " ", "=", " ", "\n", 
                    "                      ", "dummymatrix"}], ";", " ", 
                    "1."}], ",", " ", "1."}], "]"}], ";", " ", 
                    RowBox[{"AppendTo", "[", 
                    RowBox[{"intersectionslist", ",", " ", "intersections"}], 
                    "]"}], ";", " ", "\n", "                   ", 
                    RowBox[{"If", "[", 
                    RowBox[{"holeQ", ",", " ", 
                    RowBox[{"AppendTo", "[", 
                    RowBox[{"holeQlist", ",", " ", "1"}], "]"}], ",", " ", 
                    RowBox[{"AppendTo", "[", 
                    RowBox[{"holeQlist", ",", " ", "0"}], "]"}]}], "]"}], ";",
                     " ", "\n", "                   ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "\n", "                     ", 
                    "rez", ",", " ", "r1", ",", " ", "r2", ",", " ", "r3", 
                    ",", " ", "r4", ",", " ", "\n", "                     ", 
                    "r5", ",", " ", "r6", ",", " ", "r7", ",", " ", "r8", ",",
                     " ", "r9", ",", " ", "\n", "                     ", 
                    "wavelength", ",", " ", "intensity", ",", " ", 
                    "intensityscale", ",", " ", "ray1", ",", " ", "\n", 
                    "                     ", "index", ",", " ", 
                    "opticallength", ",", " ", "phaseshift", ",", " ", 
                    "componentnumber", ",", " ", "\n", 
                    "                     ", "surfacenumber", ",", " ", 
                    "surfaceid", ",", " ", "ray2", ",", " ", "ray3", ",", " ",
                     "\n", "                     ", "sid", ",", " ", 
                    "frontid", ",", " ", "sno1", ",", " ", "sno2", ",", " ", 
                    "sno3", ",", " ", "\n", "                     ", "sno4", 
                    ",", " ", "rayslot", ",", " ", "oldgenerationnumber", ",",
                     " ", "intersectionnumber", ",", " ", "\n", 
                    "                     ", "pol1", ",", " ", "pol2", ",", 
                    " ", "pol3"}], "}"}], " ", "=", " ", "#1"}], ";", " ", 
                    RowBox[{
                    "index1", " ", "=", " ", "\n", "                    ", 
                    "index"}], ";", " ", 
                    RowBox[{"xunit", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"-", "1."}], "*", "r2"}]}], ";", " ", 
                    RowBox[{"yunit", " ", "=", " ", "r1"}], ";", " ", "\n", 
                    "                   ", 
                    RowBox[{"zunit", " ", "=", " ", "r3"}], ";", " ", 
                    RowBox[{"xunit", " ", "=", " ", 
                    RowBox[{"Chop", "[", "xunit", "]"}]}], ";", " ", "\n", 
                    "                   ", 
                    RowBox[{"yunit", " ", "=", " ", 
                    RowBox[{"Chop", "[", "yunit", "]"}]}], ";", " ", 
                    RowBox[{"zunit", " ", "=", " ", 
                    RowBox[{"Chop", "[", "zunit", "]"}]}], ";", " ", "\n", 
                    "                   ", 
                    RowBox[{"magnitude", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"xunit", "^", "2"}], " ", "+", " ", 
                    RowBox[{"yunit", "^", "2"}], " ", "+", " ", 
                    RowBox[{"zunit", "^", "2"}]}], ")"}], "^", 
                    RowBox[{"2", "^", 
                    RowBox[{"(", 
                    RowBox[{"-", "1"}], ")"}]}]}]}], ";", " ", "\n", 
                    "                   ", 
                    RowBox[{"xunit", " ", "=", " ", 
                    RowBox[{"xunit", "/", "magnitude"}]}], ";", " ", 
                    RowBox[{
                    "yunit", " ", "=", " ", "\n", "                    ", 
                    RowBox[{"yunit", "/", "magnitude"}]}], ";", " ", 
                    RowBox[{"zunit", " ", "=", " ", 
                    RowBox[{
                    "zunit", "/", "\n", "                     ", 
                    "magnitude"}]}], ";", " ", 
                    RowBox[{"rx", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"-", "1."}], "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "75."}], " ", "+", " ", "rey"}], ")"}]}]}], 
                    ";", " ", 
                    RowBox[{"ry", " ", "=", " ", "\n", "                    ", 
                    RowBox[{
                    RowBox[{"-", "100."}], " ", "+", " ", "rex"}]}], ";", " ", 
                    RowBox[{"rz", " ", "=", " ", "rez"}], ";", " ", 
                    RowBox[{"rx", " ", "=", " ", "\n", "                    ", 
                    RowBox[{"Chop", "[", "rx", "]"}]}], ";", " ", 
                    RowBox[{"ry", " ", "=", " ", 
                    RowBox[{"Chop", "[", "ry", "]"}]}], ";", " ", 
                    RowBox[{"rz", " ", "=", " ", "\n", "                    ", 
                    RowBox[{"Chop", "[", "rz", "]"}]}], ";", " ", 
                    RowBox[{"terminatedeflection", " ", "=", " ", "False"}], 
                    ";", " ", 
                    RowBox[{"intersections", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}], "}"}]}], ";", " ", "\n", "                   ", 
                    RowBox[{"intersections", " ", "=", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Chop", "[", "xunit", "]"}], " ", "!=", " ", 
                    "0"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"N", "[", 
                    RowBox[{"Chop", "[", 
                    RowBox[{"#1", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "]"}], "]"}], " ", ">=", 
                    " ", "0."}], " ", "&&", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"#1", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], " ", "<=", " ", "100."}], 
                    " ", "&&", " ", "\n", "                           ", 
                    RowBox[{
                    RowBox[{"#1", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], " ", ">=", " ", 
                    RowBox[{"-", "100."}]}], " ", "&&", " ", 
                    RowBox[{
                    RowBox[{"#1", "[", 
                    RowBox[{"[", "3", "]"}], "]"}], " ", ">=", " ", 
                    RowBox[{"-", "75."}]}], " ", "&&", " ", 
                    RowBox[{
                    RowBox[{"#1", "[", 
                    RowBox[{"[", "3", "]"}], "]"}], " ", "<=", " ", "75."}]}],
                     ")"}]}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"#1", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], ",", " ", 
                    RowBox[{"#1", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], ",", " ", 
                    RowBox[{"#1", "[", 
                    RowBox[{"[", "3", "]"}], "]"}]}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}]}], "]"}], " ", "&"}], " ", ")"}], "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"(", 
                    RowBox[{
                    "rx", "/", "\n", "                          ", "xunit"}], 
                    ")"}]}], ",", " ", 
                    RowBox[{"ry", " ", "-", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"rx", "*", "yunit"}], ")"}], "/", "\n", 
                    "                          ", "xunit"}]}], ",", " ", 
                    RowBox[{"rz", " ", "-", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"rx", "*", "zunit"}], ")"}], "/", "\n", 
                    "                          ", "xunit"}]}]}], "}"}], "]"}],
                     "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}], "}"}]}], "]"}]}], ";", " ", 
                    RowBox[{"AppendTo", "[", 
                    RowBox[{"intersections", ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}]}], "]"}], ";", " ", "\n", "                   ", 
                    RowBox[{"holeQ", " ", "=", " ", "False"}], ";", " ", 
                    RowBox[{"If", "[", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"!", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Chop", "[", 
                    RowBox[{"surfaceid", " ", "-", " ", "16601."}], "]"}], 
                    " ", "==", " ", "0."}], " ", "||", " ", 
                    RowBox[{
                    RowBox[{"N", "[", 
                    RowBox[{"Chop", "[", "ray1", "]"}], "]"}], " ", "<", " ", 
                    "\n", "                        ", "0.0001"}]}], ")"}]}], 
                    " ", "||", " ", 
                    RowBox[{"generationnumber", " ", "==", " ", "1."}]}], ",",
                     " ", 
                    RowBox[{"minresonateraylength", " ", "=", " ", "0."}], 
                    ",", " ", "\n", "                    ", 
                    RowBox[{
                    "minresonateraylength", " ", "=", " ", "0.0001"}]}], 
                    "]"}], ";", " ", 
                    RowBox[{"Block", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"RayL", ",", " ", "SCx", ",", " ", "SCy"}], "}"}],
                     ",", " ", 
                    RowBox[{
                    RowBox[{"RayL", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"SCx", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"SCy", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{
                    "dummymatrix", " ", "=", " ", "\n", 
                    "                      ", 
                    RowBox[{"Union", "[", 
                    RowBox[{"Select", "[", 
                    RowBox[{"intersections", ",", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"RayL", ",", " ", "SCx", ",", " ", "SCy"}], "}"}],
                     " ", "=", " ", "#1"}], ";", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"RayL", ",", " ", "SCx", ",", " ", "SCy"}], "}"}],
                     " ", "==", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}]}], " ", "||", " ", 
                    RowBox[{
                    RowBox[{"N", "[", 
                    RowBox[{"Chop", "[", "RayL", "]"}], "]"}], " ", ">=", " ",
                     "\n", "                            ", 
                    "minresonateraylength"}]}]}], ")"}], " ", "&"}]}], " ", 
                    "]"}], "]"}]}], ";", " ", 
                    RowBox[{
                    "intersections", " ", "=", " ", "dummymatrix"}]}]}], 
                    "]"}], ";", " ", "\n", "                   ", 
                    RowBox[{
                    "unfilteredintersections", " ", "=", " ", 
                    "intersections"}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", "intersections", "]"}], " ", ">", 
                    " ", "1"}], ",", " ", "\n", "                    ", 
                    RowBox[{
                    RowBox[{"dummymatrix", " ", "=", " ", 
                    RowBox[{"Take", "[", 
                    RowBox[{"intersections", ",", " ", 
                    RowBox[{"{", "2", "}"}]}], "]"}]}], ";", " ", 
                    RowBox[{"intersections", " ", "=", " ", "\n", 
                    "                      ", "dummymatrix"}], ";", " ", 
                    "1."}], ",", " ", "1."}], "]"}], ";", " ", 
                    RowBox[{"AppendTo", "[", 
                    RowBox[{"intersectionslist", ",", " ", "intersections"}], 
                    "]"}], ";", " ", "\n", "                   ", 
                    RowBox[{"If", "[", 
                    RowBox[{"holeQ", ",", " ", 
                    RowBox[{"AppendTo", "[", 
                    RowBox[{"holeQlist", ",", " ", "1"}], "]"}], ",", " ", 
                    RowBox[{"AppendTo", "[", 
                    RowBox[{"holeQlist", ",", " ", "0"}], "]"}]}], "]"}], ";",
                     " ", "\n", "                   ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "\n", "                     ", 
                    "rez", ",", " ", "r1", ",", " ", "r2", ",", " ", "r3", 
                    ",", " ", "r4", ",", " ", "\n", "                     ", 
                    "r5", ",", " ", "r6", ",", " ", "r7", ",", " ", "r8", ",",
                     " ", "r9", ",", " ", "\n", "                     ", 
                    "wavelength", ",", " ", "intensity", ",", " ", 
                    "intensityscale", ",", " ", "ray1", ",", " ", "\n", 
                    "                     ", "index", ",", " ", 
                    "opticallength", ",", " ", "phaseshift", ",", " ", 
                    "componentnumber", ",", " ", "\n", 
                    "                     ", "surfacenumber", ",", " ", 
                    "surfaceid", ",", " ", "ray2", ",", " ", "ray3", ",", " ",
                     "\n", "                     ", "sid", ",", " ", 
                    "frontid", ",", " ", "sno1", ",", " ", "sno2", ",", " ", 
                    "sno3", ",", " ", "\n", "                     ", "sno4", 
                    ",", " ", "rayslot", ",", " ", "oldgenerationnumber", ",",
                     " ", "intersectionnumber", ",", " ", "\n", 
                    "                     ", "pol1", ",", " ", "pol2", ",", 
                    " ", "pol3"}], "}"}], " ", "=", " ", "#1"}], ";", " ", 
                    RowBox[{"index1", " ", "=", " ", "\n", 
                    "                    ", "index"}], ";", " ", 
                    RowBox[{"xunit", " ", "=", " ", "r3"}], ";", " ", 
                    RowBox[{"yunit", " ", "=", " ", "r2"}], ";", " ", "\n", 
                    "                   ", 
                    RowBox[{"zunit", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"-", "1."}], "*", "r1"}]}], ";", " ", 
                    RowBox[{"xunit", " ", "=", " ", 
                    RowBox[{"Chop", "[", "xunit", "]"}]}], ";", " ", "\n", 
                    "                   ", 
                    RowBox[{"yunit", " ", "=", " ", 
                    RowBox[{"Chop", "[", "yunit", "]"}]}], ";", " ", 
                    RowBox[{"zunit", " ", "=", " ", 
                    RowBox[{"Chop", "[", "zunit", "]"}]}], ";", " ", "\n", 
                    "                   ", 
                    RowBox[{"magnitude", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"xunit", "^", "2"}], " ", "+", " ", 
                    RowBox[{"yunit", "^", "2"}], " ", "+", " ", 
                    RowBox[{"zunit", "^", "2"}]}], ")"}], "^", 
                    RowBox[{"2", "^", 
                    RowBox[{"(", 
                    RowBox[{"-", "1"}], ")"}]}]}]}], ";", " ", "\n", 
                    "                   ", 
                    RowBox[{"xunit", " ", "=", " ", 
                    RowBox[{"xunit", "/", "magnitude"}]}], ";", " ", 
                    RowBox[{
                    "yunit", " ", "=", " ", "\n", "                    ", 
                    RowBox[{"yunit", "/", "magnitude"}]}], ";", " ", 
                    RowBox[{"zunit", " ", "=", " ", 
                    RowBox[{
                    "zunit", "/", "\n", "                     ", 
                    "magnitude"}]}], ";", " ", 
                    RowBox[{"rx", " ", "=", " ", 
                    RowBox[{"75.", " ", "+", " ", "rez"}]}], ";", " ", 
                    RowBox[{"ry", " ", "=", " ", "\n", "                    ",
                     "rey"}], ";", " ", 
                    RowBox[{"rz", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"-", "1."}], "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "100."}], " ", "+", " ", "rex"}], ")"}]}]}], 
                    ";", " ", 
                    RowBox[{"rx", " ", "=", " ", "\n", "                    ", 
                    RowBox[{"Chop", "[", "rx", "]"}]}], ";", " ", 
                    RowBox[{"ry", " ", "=", " ", 
                    RowBox[{"Chop", "[", "ry", "]"}]}], ";", " ", 
                    RowBox[{"rz", " ", "=", " ", "\n", "                    ", 
                    RowBox[{"Chop", "[", "rz", "]"}]}], ";", " ", 
                    RowBox[{"terminatedeflection", " ", "=", " ", "False"}], 
                    ";", " ", 
                    RowBox[{"intersections", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}], "}"}]}], ";", " ", "\n", "                   ", 
                    RowBox[{"intersections", " ", "=", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Chop", "[", "xunit", "]"}], " ", "!=", " ", 
                    "0"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"N", "[", 
                    RowBox[{"Chop", "[", 
                    RowBox[{"#1", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "]"}], "]"}], " ", ">=", 
                    " ", "0."}], " ", "&&", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"#1", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], " ", "<=", " ", "75."}], 
                    " ", "&&", " ", "\n", "                           ", 
                    RowBox[{
                    RowBox[{"#1", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], " ", ">=", " ", 
                    RowBox[{"-", "75."}]}], " ", "&&", " ", 
                    RowBox[{
                    RowBox[{"#1", "[", 
                    RowBox[{"[", "3", "]"}], "]"}], " ", ">=", " ", 
                    RowBox[{"-", "100."}]}], " ", "&&", " ", 
                    RowBox[{
                    RowBox[{"#1", "[", 
                    RowBox[{"[", "3", "]"}], "]"}], " ", "<=", " ", 
                    "100."}]}], ")"}]}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"#1", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], ",", " ", 
                    RowBox[{"#1", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], ",", " ", 
                    RowBox[{"#1", "[", 
                    RowBox[{"[", "3", "]"}], "]"}]}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}]}], "]"}], " ", "&"}], " ", ")"}], "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"(", 
                    RowBox[{
                    "rx", "/", "\n", "                          ", "xunit"}], 
                    ")"}]}], ",", " ", 
                    RowBox[{"ry", " ", "-", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"rx", "*", "yunit"}], ")"}], "/", "\n", 
                    "                          ", "xunit"}]}], ",", " ", 
                    RowBox[{"rz", " ", "-", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"rx", "*", "zunit"}], ")"}], "/", "\n", 
                    "                          ", "xunit"}]}]}], "}"}], "]"}],
                     "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}], "}"}]}], "]"}]}], ";", " ", 
                    RowBox[{"AppendTo", "[", 
                    RowBox[{"intersections", ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}]}], "]"}], ";", " ", "\n", "                   ", 
                    RowBox[{"holeQ", " ", "=", " ", "False"}], ";", " ", 
                    RowBox[{"If", "[", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"!", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Chop", "[", 
                    RowBox[{"surfaceid", " ", "-", " ", "16602."}], "]"}], 
                    " ", "==", " ", "0."}], " ", "||", " ", 
                    RowBox[{
                    RowBox[{"N", "[", 
                    RowBox[{"Chop", "[", "ray1", "]"}], "]"}], " ", "<", " ", 
                    "\n", "                        ", "0.0001"}]}], ")"}]}], 
                    " ", "||", " ", 
                    RowBox[{"generationnumber", " ", "==", " ", "1."}]}], ",",
                     " ", 
                    RowBox[{"minresonateraylength", " ", "=", " ", "0."}], 
                    ",", " ", "\n", "                    ", 
                    RowBox[{
                    "minresonateraylength", " ", "=", " ", "0.0001"}]}], 
                    "]"}], ";", " ", 
                    RowBox[{"Block", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"RayL", ",", " ", "SCx", ",", " ", "SCy"}], "}"}],
                     ",", " ", 
                    RowBox[{
                    RowBox[{"RayL", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"SCx", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"SCy", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{
                    "dummymatrix", " ", "=", " ", "\n", 
                    "                      ", 
                    RowBox[{"Union", "[", 
                    RowBox[{"Select", "[", 
                    RowBox[{"intersections", ",", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"RayL", ",", " ", "SCx", ",", " ", "SCy"}], "}"}],
                     " ", "=", " ", "#1"}], ";", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"RayL", ",", " ", "SCx", ",", " ", "SCy"}], "}"}],
                     " ", "==", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}]}], " ", "||", " ", 
                    RowBox[{
                    RowBox[{"N", "[", 
                    RowBox[{"Chop", "[", "RayL", "]"}], "]"}], " ", ">=", " ",
                     "\n", "                            ", 
                    "minresonateraylength"}]}]}], ")"}], " ", "&"}]}], " ", 
                    "]"}], "]"}]}], ";", " ", 
                    RowBox[{
                    "intersections", " ", "=", " ", "dummymatrix"}]}]}], 
                    "]"}], ";", " ", "\n", "                   ", 
                    RowBox[{
                    "unfilteredintersections", " ", "=", " ", 
                    "intersections"}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", "intersections", "]"}], " ", ">", 
                    " ", "1"}], ",", " ", "\n", "                    ", 
                    RowBox[{
                    RowBox[{"dummymatrix", " ", "=", " ", 
                    RowBox[{"Take", "[", 
                    RowBox[{"intersections", ",", " ", 
                    RowBox[{"{", "2", "}"}]}], "]"}]}], ";", " ", 
                    RowBox[{
                    "intersections", " ", "=", " ", "\n", 
                    "                      ", "dummymatrix"}], ";", " ", 
                    "1."}], ",", " ", "1."}], "]"}], ";", " ", 
                    RowBox[{"AppendTo", "[", 
                    RowBox[{"intersectionslist", ",", " ", "intersections"}], 
                    "]"}], ";", " ", "\n", "                   ", 
                    RowBox[{"If", "[", 
                    RowBox[{"holeQ", ",", " ", 
                    RowBox[{"AppendTo", "[", 
                    RowBox[{"holeQlist", ",", " ", "1"}], "]"}], ",", " ", 
                    RowBox[{"AppendTo", "[", 
                    RowBox[{"holeQlist", ",", " ", "0"}], "]"}]}], "]"}], ";",
                     " ", "\n", "                   ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "\n", "                     ", 
                    "rez", ",", " ", "r1", ",", " ", "r2", ",", " ", "r3", 
                    ",", " ", "r4", ",", " ", "\n", "                     ", 
                    "r5", ",", " ", "r6", ",", " ", "r7", ",", " ", "r8", ",",
                     " ", "r9", ",", " ", "\n", "                     ", 
                    "wavelength", ",", " ", "intensity", ",", " ", 
                    "intensityscale", ",", " ", "ray1", ",", " ", "\n", 
                    "                     ", "index", ",", " ", 
                    "opticallength", ",", " ", "phaseshift", ",", " ", 
                    "componentnumber", ",", " ", "\n", 
                    "                     ", "surfacenumber", ",", " ", 
                    "surfaceid", ",", " ", "ray2", ",", " ", "ray3", ",", " ",
                     "\n", "                     ", "sid", ",", " ", 
                    "frontid", ",", " ", "sno1", ",", " ", "sno2", ",", " ", 
                    "sno3", ",", " ", "\n", "                     ", "sno4", 
                    ",", " ", "rayslot", ",", " ", "oldgenerationnumber", ",",
                     " ", "intersectionnumber", ",", " ", "\n", 
                    "                     ", "pol1", ",", " ", "pol2", ",", 
                    " ", "pol3"}], "}"}], " ", "=", " ", "#1"}], ";", " ", 
                    RowBox[{
                    "index1", " ", "=", " ", "\n", "                    ", 
                    "index"}], ";", " ", 
                    RowBox[{"xunit", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"-", "1."}], "*", "r3"}]}], ";", " ", 
                    RowBox[{
                    "yunit", " ", "=", " ", "\n", "                    ", 
                    RowBox[{
                    RowBox[{"-", "1."}], "*", "r2"}]}], ";", " ", 
                    RowBox[{"zunit", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"-", "1."}], "*", "r1"}]}], ";", " ", 
                    RowBox[{
                    "xunit", " ", "=", " ", "\n", "                    ", 
                    RowBox[{"Chop", "[", "xunit", "]"}]}], ";", " ", 
                    RowBox[{"yunit", " ", "=", " ", 
                    RowBox[{"Chop", "[", "yunit", "]"}]}], ";", " ", 
                    RowBox[{
                    "zunit", " ", "=", " ", "\n", "                    ", 
                    RowBox[{"Chop", "[", "zunit", "]"}]}], ";", " ", 
                    RowBox[{"magnitude", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"xunit", "^", "2"}], " ", "+", " ", 
                    RowBox[{"yunit", "^", "2"}], " ", "+", " ", "\n", 
                    "                      ", 
                    RowBox[{"zunit", "^", "2"}]}], ")"}], "^", 
                    RowBox[{"2", "^", 
                    RowBox[{"(", 
                    RowBox[{"-", "1"}], ")"}]}]}]}], ";", " ", 
                    RowBox[{"xunit", " ", "=", " ", 
                    RowBox[{"xunit", "/", "magnitude"}]}], ";", " ", "\n", 
                    "                   ", 
                    RowBox[{"yunit", " ", "=", " ", 
                    RowBox[{"yunit", "/", "magnitude"}]}], ";", " ", 
                    RowBox[{
                    "zunit", " ", "=", " ", "\n", "                    ", 
                    RowBox[{"zunit", "/", "magnitude"}]}], ";", " ", 
                    RowBox[{"rx", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"-", "1."}], "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "75."}], " ", "+", " ", "rez"}], ")"}]}]}], 
                    ";", " ", "\n", "                   ", 
                    RowBox[{"ry", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"-", "1."}], "*", "rey"}]}], ";", " ", 
                    RowBox[{"rz", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"-", "1."}], "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "100."}], " ", "+", " ", "rex"}], ")"}]}]}], 
                    ";", " ", "\n", "                   ", 
                    RowBox[{"rx", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rx", "]"}]}], ";", " ", 
                    RowBox[{"ry", " ", "=", " ", 
                    RowBox[{"Chop", "[", "ry", "]"}]}], ";", " ", 
                    RowBox[{"rz", " ", "=", " ", "\n", "                    ", 
                    RowBox[{"Chop", "[", "rz", "]"}]}], ";", " ", 
                    RowBox[{"terminatedeflection", " ", "=", " ", "False"}], 
                    ";", " ", 
                    RowBox[{"intersections", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}], "}"}]}], ";", " ", "\n", "                   ", 
                    RowBox[{"intersections", " ", "=", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Chop", "[", "xunit", "]"}], " ", "!=", " ", 
                    "0"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"N", "[", 
                    RowBox[{"Chop", "[", 
                    RowBox[{"#1", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "]"}], "]"}], " ", ">=", 
                    " ", "0."}], " ", "&&", " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"#1", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], " ", "<=", " ", "75."}], 
                    " ", "&&", " ", "\n", "                           ", 
                    RowBox[{
                    RowBox[{"#1", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], " ", ">=", " ", 
                    RowBox[{"-", "75."}]}], " ", "&&", " ", 
                    RowBox[{
                    RowBox[{"#1", "[", 
                    RowBox[{"[", "3", "]"}], "]"}], " ", ">=", " ", 
                    RowBox[{"-", "100."}]}], " ", "&&", " ", 
                    RowBox[{
                    RowBox[{"#1", "[", 
                    RowBox[{"[", "3", "]"}], "]"}], " ", "<=", " ", 
                    "100."}]}], ")"}]}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"#1", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], ",", " ", 
                    RowBox[{"#1", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], ",", " ", 
                    RowBox[{"#1", "[", 
                    RowBox[{"[", "3", "]"}], "]"}]}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}]}], "]"}], " ", "&"}], " ", ")"}], "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", 
                    RowBox[{"(", 
                    RowBox[{
                    "rx", "/", "\n", "                          ", "xunit"}], 
                    ")"}]}], ",", " ", 
                    RowBox[{"ry", " ", "-", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"rx", "*", "yunit"}], ")"}], "/", "\n", 
                    "                          ", "xunit"}]}], ",", " ", 
                    RowBox[{"rz", " ", "-", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"rx", "*", "zunit"}], ")"}], "/", "\n", 
                    "                          ", "xunit"}]}]}], "}"}], "]"}],
                     "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}], "}"}]}], "]"}]}], ";", " ", 
                    RowBox[{"AppendTo", "[", 
                    RowBox[{"intersections", ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}]}], "]"}], ";", " ", "\n", "                   ", 
                    RowBox[{"holeQ", " ", "=", " ", "False"}], ";", " ", 
                    RowBox[{"If", "[", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"!", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Chop", "[", 
                    RowBox[{"surfaceid", " ", "-", " ", "16603."}], "]"}], 
                    " ", "==", " ", "0."}], " ", "||", " ", 
                    RowBox[{
                    RowBox[{"N", "[", 
                    RowBox[{"Chop", "[", "ray1", "]"}], "]"}], " ", "<", " ", 
                    "\n", "                        ", "0.0001"}]}], ")"}]}], 
                    " ", "||", " ", 
                    RowBox[{"generationnumber", " ", "==", " ", "1."}]}], ",",
                     " ", 
                    RowBox[{"minresonateraylength", " ", "=", " ", "0."}], 
                    ",", " ", "\n", "                    ", 
                    RowBox[{
                    "minresonateraylength", " ", "=", " ", "0.0001"}]}], 
                    "]"}], ";", " ", 
                    RowBox[{"Block", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"RayL", ",", " ", "SCx", ",", " ", "SCy"}], "}"}],
                     ",", " ", 
                    RowBox[{
                    RowBox[{"RayL", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"SCx", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{"SCy", " ", "=", " ", "1."}], ";", " ", 
                    RowBox[{
                    "dummymatrix", " ", "=", " ", "\n", 
                    "                      ", 
                    RowBox[{"Union", "[", 
                    RowBox[{"Select", "[", 
                    RowBox[{"intersections", ",", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"RayL", ",", " ", "SCx", ",", " ", "SCy"}], "}"}],
                     " ", "=", " ", "#1"}], ";", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"RayL", ",", " ", "SCx", ",", " ", "SCy"}], "}"}],
                     " ", "==", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}]}], " ", "||", " ", 
                    RowBox[{
                    RowBox[{"N", "[", 
                    RowBox[{"Chop", "[", "RayL", "]"}], "]"}], " ", ">=", " ",
                     "\n", "                            ", 
                    "minresonateraylength"}]}]}], ")"}], " ", "&"}]}], " ", 
                    "]"}], "]"}]}], ";", " ", 
                    RowBox[{
                    "intersections", " ", "=", " ", "dummymatrix"}]}]}], 
                    "]"}], ";", " ", "\n", "                   ", 
                    RowBox[{
                    "unfilteredintersections", " ", "=", " ", 
                    "intersections"}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", "intersections", "]"}], " ", ">", 
                    " ", "1"}], ",", " ", "\n", "                    ", 
                    RowBox[{
                    RowBox[{"dummymatrix", " ", "=", " ", 
                    RowBox[{"Take", "[", 
                    RowBox[{"intersections", ",", " ", 
                    RowBox[{"{", "2", "}"}]}], "]"}]}], ";", " ", 
                    RowBox[{
                    "intersections", " ", "=", " ", "\n", 
                    "                      ", "dummymatrix"}], ";", " ", 
                    "1."}], ",", " ", "1."}], "]"}], ";", " ", 
                    RowBox[{"AppendTo", "[", 
                    RowBox[{"intersectionslist", ",", " ", "intersections"}], 
                    "]"}], ";", " ", "\n", "                   ", 
                    RowBox[{"If", "[", 
                    RowBox[{"holeQ", ",", " ", 
                    RowBox[{"AppendTo", "[", 
                    RowBox[{"holeQlist", ",", " ", "1"}], "]"}], ",", " ", 
                    RowBox[{"AppendTo", "[", 
                    RowBox[{"holeQlist", ",", " ", "0"}], "]"}]}], "]"}]}], 
                    ")"}], ";", " ", "\n", "                  ", 
                    RowBox[{"holeQlist", " ", "=", " ", 
                    RowBox[{"Drop", "[", 
                    RowBox[{"holeQlist", ",", " ", "1"}], "]"}]}], ";", " ", 
                    RowBox[{"Drop", "[", 
                    RowBox[{"intersectionslist", ",", " ", "1"}], "]"}]}]}], 
                    "]"}]}], ")"}], ";", " ", 
                    RowBox[{"Which", "[", "\n", "                ", 
                    RowBox[{
                    RowBox[{"resonatenumber", " ", "==", " ", "1"}], ",", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "\n", 
                    "                   ", "rex", ",", " ", "rey", ",", " ", 
                    "rez", ",", " ", "r1", ",", " ", "r2", ",", " ", "\n", 
                    "                   ", "r3", ",", " ", "r4", ",", " ", 
                    "r5", ",", " ", "r6", ",", " ", "r7", ",", " ", "\n", 
                    "                   ", "r8", ",", " ", "r9", ",", " ", 
                    "wavelength", ",", " ", "intensity", ",", " ", "\n", 
                    "                   ", "intensityscale", ",", " ", "ray1",
                     ",", " ", "index", ",", " ", "opticallength", ",", " ", 
                    "\n", "                   ", "phaseshift", ",", " ", 
                    "componentnumber", ",", " ", "surfacenumber", ",", " ", 
                    "surfaceid", ",", " ", "\n", "                   ", 
                    "ray2", ",", " ", "ray3", ",", " ", "sid", ",", " ", 
                    "frontid", ",", " ", "sno1", ",", " ", "\n", 
                    "                   ", "sno2", ",", " ", "sno3", ",", " ",
                     "sno4", ",", " ", "rayslot", ",", " ", "\n", 
                    "                   ", "oldgenerationnumber", ",", " ", 
                    "intersectionnumber", ",", " ", "pol1", ",", " ", "pol2", 
                    ",", " ", "\n", "                   ", "pol3"}], "}"}], 
                    " ", "=", " ", "#1"}], ";", " ", 
                    RowBox[{"index1", " ", "=", " ", "index"}], ";", " ", 
                    RowBox[{
                    "xunit", " ", "=", " ", "\n", "                  ", 
                    RowBox[{
                    RowBox[{"-", "1."}], "*", "r1"}]}], ";", " ", 
                    RowBox[{"yunit", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"-", "1."}], "*", "r2"}]}], ";", " ", 
                    RowBox[{"zunit", " ", "=", " ", "r3"}], ";", " ", "\n", 
                    "                 ", 
                    RowBox[{"xunit", " ", "=", " ", 
                    RowBox[{"Chop", "[", "xunit", "]"}]}], ";", " ", 
                    RowBox[{"yunit", " ", "=", " ", 
                    RowBox[{"Chop", "[", "yunit", "]"}]}], ";", " ", "\n", 
                    "                 ", 
                    RowBox[{"zunit", " ", "=", " ", 
                    RowBox[{"Chop", "[", "zunit", "]"}]}], ";", " ", 
                    RowBox[{"magnitude", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"xunit", "^", "2"}], " ", "+", " ", "\n", 
                    "                    ", 
                    RowBox[{"yunit", "^", "2"}], " ", "+", " ", 
                    RowBox[{"zunit", "^", "2"}]}], ")"}], "^", 
                    RowBox[{"2", "^", 
                    RowBox[{"(", 
                    RowBox[{"-", "1"}], ")"}]}]}]}], ";", " ", 
                    RowBox[{"xunit", " ", "=", " ", 
                    RowBox[{
                    "xunit", "/", "\n", "                   ", 
                    "magnitude"}]}], ";", " ", 
                    RowBox[{"yunit", " ", "=", " ", 
                    RowBox[{"yunit", "/", "magnitude"}]}], ";", " ", "\n", 
                    "                 ", 
                    RowBox[{"zunit", " ", "=", " ", 
                    RowBox[{"zunit", "/", "magnitude"}]}], ";", " ", 
                    RowBox[{"rx", " ", "=", " ", "\n", "                  ", 
                    RowBox[{
                    RowBox[{"-", "1."}], "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "200."}], " ", "+", " ", "rex"}], ")"}]}]}], 
                    ";", " ", 
                    RowBox[{"ry", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"-", "1."}], "*", "rey"}]}], ";", " ", 
                    RowBox[{
                    "rz", " ", "=", " ", "\n", "                  ", "rez"}], 
                    ";", " ", 
                    RowBox[{"rx", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rx", "]"}]}], ";", " ", 
                    RowBox[{"ry", " ", "=", " ", 
                    RowBox[{"Chop", "[", "ry", "]"}]}], ";", " ", "\n", 
                    "                 ", 
                    RowBox[{"rz", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rz", "]"}]}], ";", " ", 
                    RowBox[{"terminatedeflection", " ", "=", " ", "False"}], 
                    ";", " ", 
                    RowBox[{
                    "intersections", " ", "=", " ", "\n", 
                    "                  ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}], "}"}]}], ";", " ", 
                    RowBox[{
                    "intersections", " ", "=", " ", "resonateintersections"}],
                     ";", " ", 
                    RowBox[{
                    "holeQ", " ", "=", " ", "\n", "                  ", 
                    RowBox[{
                    RowBox[{"holeQlist", "[", 
                    RowBox[{"[", "resonatenumber", "]"}], "]"}], " ", "==", 
                    " ", "1"}]}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "newcomponentnumber", ",", " ", "\n", 
                    "                   ", "newsurfacenumber", ",", " ", 
                    "newsurfaceid"}], "}"}], " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"2.", ",", " ", "1.", ",", " ", "16598."}], 
                    "}"}]}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "componentnumber", ",", " ", "\n", "                   ", 
                    "surfacenumber", ",", " ", "surfaceid"}], "}"}], " ", "=",
                     " ", 
                    RowBox[{"{", 
                    RowBox[{"2.", ",", " ", "1.", ",", " ", "16598."}], 
                    "}"}]}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "ray1", ",", " ", "ray2", ",", " ", "\n", 
                    "                   ", "ray3"}], "}"}], " ", "=", " ", 
                    RowBox[{"intersections", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], ";", " ", 
                    RowBox[{"rsx", " ", "=", " ", "rex"}], ";", " ", "\n", 
                    "                 ", 
                    RowBox[{"rsy", " ", "=", " ", "rey"}], ";", " ", 
                    RowBox[{"rsz", " ", "=", " ", "rez"}], ";", " ", 
                    RowBox[{
                    "rxhlp", " ", "=", " ", "\n", "                  ", 
                    RowBox[{"rx", " ", "+", " ", 
                    RowBox[{"ray1", "*", "xunit"}]}]}], ";", " ", 
                    RowBox[{"ryhlp", " ", "=", " ", 
                    RowBox[{
                    "ry", " ", "+", " ", "\n", "                   ", 
                    RowBox[{"ray1", "*", "yunit"}]}]}], ";", " ", 
                    RowBox[{"rzhlp", " ", "=", " ", 
                    RowBox[{"rz", " ", "+", " ", 
                    RowBox[{
                    "ray1", "*", "\n", "                    ", "zunit"}]}]}], 
                    ";", " ", 
                    RowBox[{"rex", " ", "=", " ", 
                    RowBox[{"200.", " ", "-", " ", 
                    RowBox[{"1.", "*", "rxhlp"}]}]}], ";", " ", 
                    RowBox[{
                    "rey", " ", "=", " ", "\n", "                  ", 
                    RowBox[{
                    RowBox[{"-", "1."}], "*", "ryhlp"}]}], ";", " ", 
                    RowBox[{"rez", " ", "=", " ", "rzhlp"}], ";", " ", 
                    RowBox[{
                    "rex", " ", "=", " ", "\n", "                  ", 
                    RowBox[{"Chop", "[", "rex", "]"}]}], ";", " ", 
                    RowBox[{"rey", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rey", "]"}]}], ";", " ", 
                    RowBox[{
                    "rez", " ", "=", " ", "\n", "                  ", 
                    RowBox[{"Chop", "[", "rez", "]"}]}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"rex", " ", "==", " ", "0"}], " ", "&&", " ", 
                    RowBox[{"rey", " ", "==", " ", "0"}], " ", "&&", " ", 
                    RowBox[{"rez", " ", "==", " ", "0"}]}], ",", " ", "\n", 
                    "                  ", 
                    RowBox[{
                    RowBox[{"rex", " ", "=", " ", 
                    RowBox[{"200.", " ", "+", " ", "rxhlp"}]}], ";", " ", 
                    RowBox[{"rey", " ", "=", " ", "ryhlp"}], ";", " ", "\n", 
                    "                   ", 
                    RowBox[{"rez", " ", "=", " ", "rzhlp"}]}], ",", " ", 
                    "rex"}], "]"}], ";", " ", 
                    RowBox[{
                    "intersectionnumber", " ", "=", " ", "\n", 
                    "                  ", 
                    RowBox[{"intersectionnumber", " ", "+", " ", "1."}]}], 
                    ";", " ", 
                    RowBox[{"opticallength", " ", "=", " ", 
                    RowBox[{
                    "opticallength", " ", "+", " ", "\n", 
                    "                   ", 
                    RowBox[{"ray1", "*", "index1"}]}]}], ";", " ", 
                    RowBox[{"completedray", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "\n", "                   ", "rsy", ",", 
                    " ", "rsz", ",", " ", "rex", ",", " ", "rey", ",", " ", 
                    "rez", ",", " ", "\n", "                   ", "r1", ",", 
                    " ", "r2", ",", " ", "r3", ",", " ", "r4", ",", " ", "r5",
                     ",", " ", "\n", "                   ", "r6", ",", " ", 
                    "r7", ",", " ", "r8", ",", " ", "r9", ",", " ", 
                    "wavelength", ",", " ", "\n", "                   ", 
                    "intensity", ",", " ", "intensityscale", ",", " ", "ray1",
                     ",", " ", "index", ",", " ", "\n", "                   ",
                     "opticallength", ",", " ", "phaseshift", ",", " ", 
                    "componentnumber", ",", " ", "surfacenumber", ",", " ", 
                    "\n", "                   ", "surfaceid", ",", " ", 
                    "ray2", ",", " ", "ray3", ",", " ", "sid", ",", " ", 
                    "frontid", ",", " ", "\n", "                   ", "sno1", 
                    ",", " ", "sno2", ",", " ", "sno3", ",", " ", "sno4", ",",
                     " ", "rayslot", ",", " ", "\n", "                   ", 
                    "generationnumber", ",", " ", "intersectionnumber", ",", 
                    " ", "pol1", ",", " ", "pol2", ",", " ", "\n", 
                    "                   ", "pol3"}], "}"}]}], ";", " ", 
                    RowBox[{"reportedrayspresent", " ", "=", " ", "True"}], 
                    ";", " ", 
                    RowBox[{"intersectionspresent", " ", "=", " ", "True"}], 
                    ";", " ", "\n", "                 ", 
                    RowBox[{"deflectedrayspresent", " ", "=", " ", "True"}], 
                    ";", " ", 
                    RowBox[{
                    "localdummyoutrayspresent", " ", "=", " ", "True"}], ";", 
                    " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    "surfnorm", " ", "=", " ", "\n", "                   ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"1", ",", " ", "0", ",", " ", "0"}], "}"}], ",", 
                    " ", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", " ", "1", ",", " ", "0"}], "}"}], ",", 
                    " ", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", " ", "0", ",", " ", "1"}], "}"}]}], 
                    "}"}], "]"}]}]}], ";", " ", 
                    RowBox[{"dummymatrix", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", 
                    RowBox[{"-", "1."}], ",", " ", "0."}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "0.", ",", " ", "1."}], "}"}]}], 
                    "}"}], " ", ".", " ", "#1"}], " ", "&"}], " ", ")"}], " ",
                     "/@", " ", "\n", "                    ", "surfnorm"}]}], 
                    ";", " ", 
                    RowBox[{"surfnorm", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"#1", "/", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"#1", " ", ".", " ", "#1"}], "]"}]}], " ", "&"}], 
                    " ", ")"}], " ", "/@", " ", "dummymatrix"}]}], ";", " ", 
                    "\n", "                  ", 
                    RowBox[{"surfacerotationmatrix", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0", ",", " ", "0"}], 
                    "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", " ", 
                    RowBox[{"-", "1."}], ",", " ", "0"}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", " ", "0", ",", " ", "1."}], "}"}]}], 
                    "}"}]}], ";", " ", 
                    RowBox[{
                    "surfacetranslationvector", " ", "=", " ", "\n", 
                    "                   ", 
                    RowBox[{"{", 
                    RowBox[{"200.", ",", " ", "0", ",", " ", "0"}], "}"}]}], 
                    ";", " ", 
                    RowBox[{"activeregion", " ", "=", " ", "0."}], ";", " ", 
                    RowBox[{"completedray", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "\n", 
                    "                    ", "rsz", ",", " ", "rex", ",", " ", 
                    "rey", ",", " ", "rez", ",", " ", "r1", ",", " ", "\n", 
                    "                    ", "r2", ",", " ", "r3", ",", " ", 
                    "r4", ",", " ", "r5", ",", " ", "r6", ",", " ", "\n", 
                    "                    ", "r7", ",", " ", "r8", ",", " ", 
                    "r9", ",", " ", "wavelength", ",", " ", "intensity", ",", 
                    " ", "\n", "                    ", "intensityscale", ",", 
                    " ", "ray1", ",", " ", "index", ",", " ", "opticallength",
                     ",", " ", "\n", "                    ", "phaseshift", 
                    ",", " ", "componentnumber", ",", " ", "surfacenumber", 
                    ",", " ", "surfaceid", ",", " ", "\n", 
                    "                    ", "ray2", ",", " ", "ray3", ",", 
                    " ", "sid", ",", " ", "frontid", ",", " ", "sno1", ",", 
                    " ", "\n", "                    ", "sno2", ",", " ", 
                    "sno3", ",", " ", "sno4", ",", " ", "rayslot", ",", " ", 
                    "\n", "                    ", "generationnumber", ",", 
                    " ", "intersectionnumber", ",", " ", "pol1", ",", " ", 
                    "pol2", ",", " ", "\n", "                    ", "pol3"}], 
                    "}"}]}], ";", " ", 
                    RowBox[{
                    "componentnumber", " ", "=", " ", "newcomponentnumber"}], 
                    ";", " ", "\n", "                  ", 
                    RowBox[{
                    "surfacenumber", " ", "=", " ", "newsurfacenumber"}], ";",
                     " ", 
                    RowBox[{"surfaceid", " ", "=", " ", "newsurfaceid"}], ";",
                     " ", "\n", "                  ", 
                    RowBox[{"originalray", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "\n", "                    ", "rey", ",", " ", 
                    "rez", ",", " ", "r1", ",", " ", "r2", ",", " ", "r3", 
                    ",", " ", "\n", "                    ", "r4", ",", " ", 
                    "r5", ",", " ", "r6", ",", " ", "r7", ",", " ", "r8", ",",
                     " ", "\n", "                    ", "r9", ",", " ", 
                    "wavelength", ",", " ", "intensity", ",", " ", 
                    "intensityscale", ",", " ", "\n", "                    ", 
                    "ray1", ",", " ", "index", ",", " ", "opticallength", ",",
                     " ", "phaseshift", ",", " ", "\n", 
                    "                    ", "componentnumber", ",", " ", 
                    "surfacenumber", ",", " ", "surfaceid", ",", " ", "ray2", 
                    ",", " ", "\n", "                    ", "ray3", ",", " ", 
                    "sid", ",", " ", "frontid", ",", " ", "sno1", ",", " ", 
                    "sno2", ",", " ", "\n", "                    ", "sno3", 
                    ",", " ", "sno4", ",", " ", "rayslot", ",", " ", 
                    "generationnumber", ",", " ", "\n", 
                    "                    ", "intersectionnumber", ",", " ", 
                    "pol1", ",", " ", "pol2", ",", " ", "pol3"}], "}"}]}], 
                    ";", " ", "\n", "                  ", 
                    RowBox[{"intensity", " ", "=", " ", "0."}], ";", " ", 
                    RowBox[{"allcreatedrays", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "\n", 
                    "                     ", "rsz", ",", " ", "rex", ",", " ",
                     "rey", ",", " ", "rez", ",", " ", "r1", ",", " ", "\n", 
                    "                     ", "r2", ",", " ", "r3", ",", " ", 
                    "r4", ",", " ", "r5", ",", " ", "r6", ",", " ", "\n", 
                    "                     ", "r7", ",", " ", "r8", ",", " ", 
                    "r9", ",", " ", "wavelength", ",", " ", "intensity", ",", 
                    " ", "\n", "                     ", "intensityscale", ",",
                     " ", "ray1", ",", " ", "index", ",", " ", 
                    "opticallength", ",", " ", "\n", "                     ", 
                    "phaseshift", ",", " ", "componentnumber", ",", " ", 
                    "surfacenumber", ",", " ", "surfaceid", ",", " ", "\n", 
                    "                     ", "ray2", ",", " ", "ray3", ",", 
                    " ", "sid", ",", " ", "frontid", ",", " ", "sno1", ",", 
                    " ", "\n", "                     ", "sno2", ",", " ", 
                    "sno3", ",", " ", "sno4", ",", " ", "rayslot", ",", " ", 
                    "\n", "                     ", "generationnumber", ",", 
                    " ", "intersectionnumber", ",", " ", "pol1", ",", " ", 
                    "pol2", ",", " ", "\n", "                     ", "pol3"}],
                     "}"}], "}"}]}]}], ")"}], ";", " ", 
                    RowBox[{"{", 
                    RowBox[{"allcreatedrays", ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",",
                     " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", 
                    "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",",
                     " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", 
                    "1.", ",", " ", "1.", ",", " ", "\n", 
                    "                    ", 
                    RowBox[{"-", "1.7976931348623157*^308"}], ",", " ", "1.", 
                    ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", 
                    "0.", ",", " ", 
                    RowBox[{"-", "1."}], ",", " ", 
                    RowBox[{"-", "1."}], ",", " ", 
                    RowBox[{"-", "1."}], ",", " ", "1.", ",", " ", "1.", ",", 
                    " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.",
                     ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ",
                     "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", 
                    ",", " ", "1."}], "}"}], "}"}], ",", " ", "\n", 
                    "                  ", 
                    RowBox[{"{", "completedray", "}"}]}], "}"}]}], ",", " ", 
                    RowBox[{"resonatenumber", " ", "==", " ", "2"}], ",", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "\n", 
                    "                   ", "rsz", ",", " ", "rex", ",", " ", 
                    "rey", ",", " ", "rez", ",", " ", "r1", ",", " ", "\n", 
                    "                   ", "r2", ",", " ", "r3", ",", " ", 
                    "r4", ",", " ", "r5", ",", " ", "r6", ",", " ", "\n", 
                    "                   ", "r7", ",", " ", "r8", ",", " ", 
                    "r9", ",", " ", "wavelength", ",", " ", "intensity", ",", 
                    " ", "\n", "                   ", "intensityscale", ",", 
                    " ", "ray1", ",", " ", "index", ",", " ", "opticallength",
                     ",", " ", "\n", "                   ", "phaseshift", ",",
                     " ", "componentnumber", ",", " ", "surfacenumber", ",", 
                    " ", "surfaceid", ",", " ", "\n", "                   ", 
                    "ray2", ",", " ", "ray3", ",", " ", "sid", ",", " ", 
                    "frontid", ",", " ", "sno1", ",", " ", "\n", 
                    "                   ", "sno2", ",", " ", "sno3", ",", " ",
                     "sno4", ",", " ", "rayslot", ",", " ", "\n", 
                    "                   ", "oldgenerationnumber", ",", " ", 
                    "intersectionnumber", ",", " ", "pol1", ",", " ", "pol2", 
                    ",", " ", "\n", "                   ", "pol3"}], "}"}], 
                    " ", "=", " ", "#1"}], ";", " ", 
                    RowBox[{"index1", " ", "=", " ", "index"}], ";", " ", 
                    RowBox[{
                    "xunit", " ", "=", " ", "\n", "                  ", 
                    "r2"}], ";", " ", 
                    RowBox[{"yunit", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"-", "1."}], "*", "r1"}]}], ";", " ", 
                    RowBox[{"zunit", " ", "=", " ", "r3"}], ";", " ", "\n", 
                    "                 ", 
                    RowBox[{"xunit", " ", "=", " ", 
                    RowBox[{"Chop", "[", "xunit", "]"}]}], ";", " ", 
                    RowBox[{"yunit", " ", "=", " ", 
                    RowBox[{"Chop", "[", "yunit", "]"}]}], ";", " ", "\n", 
                    "                 ", 
                    RowBox[{"zunit", " ", "=", " ", 
                    RowBox[{"Chop", "[", "zunit", "]"}]}], ";", " ", 
                    RowBox[{"magnitude", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"xunit", "^", "2"}], " ", "+", " ", "\n", 
                    "                    ", 
                    RowBox[{"yunit", "^", "2"}], " ", "+", " ", 
                    RowBox[{"zunit", "^", "2"}]}], ")"}], "^", 
                    RowBox[{"2", "^", 
                    RowBox[{"(", 
                    RowBox[{"-", "1"}], ")"}]}]}]}], ";", " ", 
                    RowBox[{"xunit", " ", "=", " ", 
                    RowBox[{
                    "xunit", "/", "\n", "                   ", 
                    "magnitude"}]}], ";", " ", 
                    RowBox[{"yunit", " ", "=", " ", 
                    RowBox[{"yunit", "/", "magnitude"}]}], ";", " ", "\n", 
                    "                 ", 
                    RowBox[{"zunit", " ", "=", " ", 
                    RowBox[{"zunit", "/", "magnitude"}]}], ";", " ", 
                    RowBox[{"rx", " ", "=", " ", "\n", "                  ", 
                    RowBox[{"75.", " ", "+", " ", "rey"}]}], ";", " ", 
                    RowBox[{"ry", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"-", "1."}], "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "100."}], " ", "+", " ", "rex"}], ")"}]}]}], 
                    ";", " ", 
                    RowBox[{
                    "rz", " ", "=", " ", "\n", "                  ", "rez"}], 
                    ";", " ", 
                    RowBox[{"rx", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rx", "]"}]}], ";", " ", 
                    RowBox[{"ry", " ", "=", " ", 
                    RowBox[{"Chop", "[", "ry", "]"}]}], ";", " ", "\n", 
                    "                 ", 
                    RowBox[{"rz", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rz", "]"}]}], ";", " ", 
                    RowBox[{"terminatedeflection", " ", "=", " ", "False"}], 
                    ";", " ", 
                    RowBox[{
                    "intersections", " ", "=", " ", "\n", 
                    "                  ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}], "}"}]}], ";", " ", 
                    RowBox[{
                    "intersections", " ", "=", " ", "resonateintersections"}],
                     ";", " ", 
                    RowBox[{
                    "holeQ", " ", "=", " ", "\n", "                  ", 
                    RowBox[{
                    RowBox[{"holeQlist", "[", 
                    RowBox[{"[", "resonatenumber", "]"}], "]"}], " ", "==", 
                    " ", "1"}]}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "newcomponentnumber", ",", " ", "\n", 
                    "                   ", "newsurfacenumber", ",", " ", 
                    "newsurfaceid"}], "}"}], " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"2.", ",", " ", "2.", ",", " ", "16599."}], 
                    "}"}]}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "componentnumber", ",", " ", "\n", "                   ", 
                    "surfacenumber", ",", " ", "surfaceid"}], "}"}], " ", "=",
                     " ", 
                    RowBox[{"{", 
                    RowBox[{"2.", ",", " ", "2.", ",", " ", "16599."}], 
                    "}"}]}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "ray1", ",", " ", "ray2", ",", " ", "\n", 
                    "                   ", "ray3"}], "}"}], " ", "=", " ", 
                    RowBox[{"intersections", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], ";", " ", 
                    RowBox[{"rsx", " ", "=", " ", "rex"}], ";", " ", "\n", 
                    "                 ", 
                    RowBox[{"rsy", " ", "=", " ", "rey"}], ";", " ", 
                    RowBox[{"rsz", " ", "=", " ", "rez"}], ";", " ", 
                    RowBox[{
                    "rxhlp", " ", "=", " ", "\n", "                  ", 
                    RowBox[{"rx", " ", "+", " ", 
                    RowBox[{"ray1", "*", "xunit"}]}]}], ";", " ", 
                    RowBox[{"ryhlp", " ", "=", " ", 
                    RowBox[{
                    "ry", " ", "+", " ", "\n", "                   ", 
                    RowBox[{"ray1", "*", "yunit"}]}]}], ";", " ", 
                    RowBox[{"rzhlp", " ", "=", " ", 
                    RowBox[{"rz", " ", "+", " ", 
                    RowBox[{
                    "ray1", "*", "\n", "                    ", "zunit"}]}]}], 
                    ";", " ", 
                    RowBox[{"rex", " ", "=", " ", 
                    RowBox[{"100.", " ", "-", " ", 
                    RowBox[{"1.", "*", "ryhlp"}]}]}], ";", " ", 
                    RowBox[{
                    "rey", " ", "=", " ", "\n", "                  ", 
                    RowBox[{
                    RowBox[{"-", "75."}], " ", "+", " ", "rxhlp"}]}], ";", 
                    " ", 
                    RowBox[{"rez", " ", "=", " ", "rzhlp"}], ";", " ", 
                    RowBox[{
                    "rex", " ", "=", " ", "\n", "                  ", 
                    RowBox[{"Chop", "[", "rex", "]"}]}], ";", " ", 
                    RowBox[{"rey", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rey", "]"}]}], ";", " ", 
                    RowBox[{
                    "rez", " ", "=", " ", "\n", "                  ", 
                    RowBox[{"Chop", "[", "rez", "]"}]}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"rex", " ", "==", " ", "0"}], " ", "&&", " ", 
                    RowBox[{"rey", " ", "==", " ", "0"}], " ", "&&", " ", 
                    RowBox[{"rez", " ", "==", " ", "0"}]}], ",", " ", "\n", 
                    "                  ", 
                    RowBox[{
                    RowBox[{"rex", " ", "=", " ", 
                    RowBox[{"100.", " ", "+", " ", "rxhlp"}]}], ";", " ", 
                    RowBox[{"rey", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"-", "75."}], " ", "+", " ", "ryhlp"}]}], ";", 
                    " ", "\n", "                   ", 
                    RowBox[{"rez", " ", "=", " ", "rzhlp"}]}], ",", " ", 
                    "rex"}], "]"}], ";", " ", 
                    RowBox[{
                    "intersectionnumber", " ", "=", " ", "\n", 
                    "                  ", 
                    RowBox[{"intersectionnumber", " ", "+", " ", "1."}]}], 
                    ";", " ", 
                    RowBox[{"opticallength", " ", "=", " ", 
                    RowBox[{
                    "opticallength", " ", "+", " ", "\n", 
                    "                   ", 
                    RowBox[{"ray1", "*", "index1"}]}]}], ";", " ", 
                    RowBox[{"completedray", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "\n", "                   ", "rsy", ",", 
                    " ", "rsz", ",", " ", "rex", ",", " ", "rey", ",", " ", 
                    "rez", ",", " ", "\n", "                   ", "r1", ",", 
                    " ", "r2", ",", " ", "r3", ",", " ", "r4", ",", " ", "r5",
                     ",", " ", "\n", "                   ", "r6", ",", " ", 
                    "r7", ",", " ", "r8", ",", " ", "r9", ",", " ", 
                    "wavelength", ",", " ", "\n", "                   ", 
                    "intensity", ",", " ", "intensityscale", ",", " ", "ray1",
                     ",", " ", "index", ",", " ", "\n", "                   ",
                     "opticallength", ",", " ", "phaseshift", ",", " ", 
                    "componentnumber", ",", " ", "surfacenumber", ",", " ", 
                    "\n", "                   ", "surfaceid", ",", " ", 
                    "ray2", ",", " ", "ray3", ",", " ", "sid", ",", " ", 
                    "frontid", ",", " ", "\n", "                   ", "sno1", 
                    ",", " ", "sno2", ",", " ", "sno3", ",", " ", "sno4", ",",
                     " ", "rayslot", ",", " ", "\n", "                   ", 
                    "generationnumber", ",", " ", "intersectionnumber", ",", 
                    " ", "pol1", ",", " ", "pol2", ",", " ", "\n", 
                    "                   ", "pol3"}], "}"}]}], ";", " ", 
                    RowBox[{"reportedrayspresent", " ", "=", " ", "True"}], 
                    ";", " ", 
                    RowBox[{"intersectionspresent", " ", "=", " ", "True"}], 
                    ";", " ", "\n", "                 ", 
                    RowBox[{"deflectedrayspresent", " ", "=", " ", "True"}], 
                    ";", " ", 
                    RowBox[{
                    "localdummyoutrayspresent", " ", "=", " ", "True"}], ";", 
                    " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    "surfnorm", " ", "=", " ", "\n", "                   ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"1", ",", " ", "0", ",", " ", "0"}], "}"}], ",", 
                    " ", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", " ", "1", ",", " ", "0"}], "}"}], ",", 
                    " ", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", " ", "0", ",", " ", "1"}], "}"}]}], 
                    "}"}], "]"}]}]}], ";", " ", 
                    RowBox[{"dummymatrix", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", 
                    RowBox[{"-", "1."}], ",", " ", "0."}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"1.", ",", " ", "0.", ",", " ", "0."}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "0.", ",", " ", "1."}], "}"}]}], 
                    "}"}], " ", ".", " ", "#1"}], " ", "&"}], " ", ")"}], " ",
                     "/@", " ", "\n", "                    ", "surfnorm"}]}], 
                    ";", " ", 
                    RowBox[{"surfnorm", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"#1", "/", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"#1", " ", ".", " ", "#1"}], "]"}]}], " ", "&"}], 
                    " ", ")"}], " ", "/@", " ", "dummymatrix"}]}], ";", " ", 
                    "\n", "                  ", 
                    RowBox[{"surfacerotationmatrix", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0", ",", " ", "1.", ",", " ", "0"}], "}"}], ",", 
                    " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0", ",", " ", "0"}], 
                    "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", " ", "0", ",", " ", "1."}], "}"}]}], 
                    "}"}]}], ";", " ", 
                    RowBox[{
                    "surfacetranslationvector", " ", "=", " ", "\n", 
                    "                   ", 
                    RowBox[{"{", 
                    RowBox[{"100.", ",", " ", 
                    RowBox[{"-", "75."}], ",", " ", "0"}], "}"}]}], ";", " ", 
                    
                    RowBox[{"activeregion", " ", "=", " ", "0."}], ";", " ", 
                    RowBox[{"completedray", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "\n", "                    ", "rsy", ",",
                     " ", "rsz", ",", " ", "rex", ",", " ", "rey", ",", " ", 
                    "rez", ",", " ", "\n", "                    ", "r1", ",", 
                    " ", "r2", ",", " ", "r3", ",", " ", "r4", ",", " ", "r5",
                     ",", " ", "\n", "                    ", "r6", ",", " ", 
                    "r7", ",", " ", "r8", ",", " ", "r9", ",", " ", 
                    "wavelength", ",", " ", "\n", "                    ", 
                    "intensity", ",", " ", "intensityscale", ",", " ", "ray1",
                     ",", " ", "index", ",", " ", "\n", 
                    "                    ", "opticallength", ",", " ", 
                    "phaseshift", ",", " ", "componentnumber", ",", " ", "\n",
                     "                    ", "surfacenumber", ",", " ", 
                    "surfaceid", ",", " ", "ray2", ",", " ", "ray3", ",", " ",
                     "\n", "                    ", "sid", ",", " ", "frontid",
                     ",", " ", "sno1", ",", " ", "sno2", ",", " ", "sno3", 
                    ",", " ", "\n", "                    ", "sno4", ",", " ", 
                    "rayslot", ",", " ", "generationnumber", ",", " ", 
                    "intersectionnumber", ",", " ", "\n", 
                    "                    ", "pol1", ",", " ", "pol2", ",", 
                    " ", "pol3"}], "}"}]}], ";", " ", 
                    RowBox[{
                    "componentnumber", " ", "=", " ", "\n", 
                    "                   ", "newcomponentnumber"}], ";", " ", 
                    RowBox[{
                    "surfacenumber", " ", "=", " ", "newsurfacenumber"}], ";",
                     " ", "\n", "                  ", 
                    RowBox[{"surfaceid", " ", "=", " ", "newsurfaceid"}], ";",
                     " ", 
                    RowBox[{"originalray", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "\n", "                    ", "rsy", ",",
                     " ", "rsz", ",", " ", "rex", ",", " ", "rey", ",", " ", 
                    "rez", ",", " ", "\n", "                    ", "r1", ",", 
                    " ", "r2", ",", " ", "r3", ",", " ", "r4", ",", " ", "r5",
                     ",", " ", "\n", "                    ", "r6", ",", " ", 
                    "r7", ",", " ", "r8", ",", " ", "r9", ",", " ", 
                    "wavelength", ",", " ", "\n", "                    ", 
                    "intensity", ",", " ", "intensityscale", ",", " ", "ray1",
                     ",", " ", "index", ",", " ", "\n", 
                    "                    ", "opticallength", ",", " ", 
                    "phaseshift", ",", " ", "componentnumber", ",", " ", "\n",
                     "                    ", "surfacenumber", ",", " ", 
                    "surfaceid", ",", " ", "ray2", ",", " ", "ray3", ",", " ",
                     "\n", "                    ", "sid", ",", " ", "frontid",
                     ",", " ", "sno1", ",", " ", "sno2", ",", " ", "sno3", 
                    ",", " ", "\n", "                    ", "sno4", ",", " ", 
                    "rayslot", ",", " ", "generationnumber", ",", " ", 
                    "intersectionnumber", ",", " ", "\n", 
                    "                    ", "pol1", ",", " ", "pol2", ",", 
                    " ", "pol3"}], "}"}]}], ";", " ", 
                    RowBox[{"intensity", " ", "=", " ", "0."}], ";", " ", 
                    "\n", "                  ", 
                    RowBox[{"allcreatedrays", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "\n", 
                    "                     ", "rex", ",", " ", "rey", ",", " ",
                     "rez", ",", " ", "r1", ",", " ", "r2", ",", " ", "\n", 
                    "                     ", "r3", ",", " ", "r4", ",", " ", 
                    "r5", ",", " ", "r6", ",", " ", "r7", ",", " ", "\n", 
                    "                     ", "r8", ",", " ", "r9", ",", " ", 
                    "wavelength", ",", " ", "intensity", ",", " ", "\n", 
                    "                     ", "intensityscale", ",", " ", 
                    "ray1", ",", " ", "index", ",", " ", "opticallength", ",",
                     " ", "\n", "                     ", "phaseshift", ",", 
                    " ", "componentnumber", ",", " ", "surfacenumber", ",", 
                    " ", "surfaceid", ",", " ", "\n", "                     ",
                     "ray2", ",", " ", "ray3", ",", " ", "sid", ",", " ", 
                    "frontid", ",", " ", "sno1", ",", " ", "\n", 
                    "                     ", "sno2", ",", " ", "sno3", ",", 
                    " ", "sno4", ",", " ", "rayslot", ",", " ", "\n", 
                    "                     ", "generationnumber", ",", " ", 
                    "intersectionnumber", ",", " ", "pol1", ",", " ", "pol2", 
                    ",", " ", "\n", "                     ", "pol3"}], "}"}], 
                    "}"}]}]}], ")"}], ";", " ", 
                    RowBox[{"{", 
                    RowBox[{"allcreatedrays", ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",",
                     " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", 
                    "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",",
                     " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", 
                    "1.", ",", " ", "1.", ",", " ", "\n", 
                    "                    ", 
                    RowBox[{"-", "1.7976931348623157*^308"}], ",", " ", "1.", 
                    ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", 
                    "0.", ",", " ", 
                    RowBox[{"-", "1."}], ",", " ", 
                    RowBox[{"-", "1."}], ",", " ", 
                    RowBox[{"-", "1."}], ",", " ", "1.", ",", " ", "1.", ",", 
                    " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.",
                     ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ",
                     "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", 
                    ",", " ", "1."}], "}"}], "}"}], ",", " ", "\n", 
                    "                  ", 
                    RowBox[{"{", "completedray", "}"}]}], "}"}]}], ",", " ", 
                    RowBox[{"resonatenumber", " ", "==", " ", "3"}], ",", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "\n", 
                    "                   ", "rsz", ",", " ", "rex", ",", " ", 
                    "rey", ",", " ", "rez", ",", " ", "r1", ",", " ", "\n", 
                    "                   ", "r2", ",", " ", "r3", ",", " ", 
                    "r4", ",", " ", "r5", ",", " ", "r6", ",", " ", "\n", 
                    "                   ", "r7", ",", " ", "r8", ",", " ", 
                    "r9", ",", " ", "wavelength", ",", " ", "intensity", ",", 
                    " ", "\n", "                   ", "intensityscale", ",", 
                    " ", "ray1", ",", " ", "index", ",", " ", "opticallength",
                     ",", " ", "\n", "                   ", "phaseshift", ",",
                     " ", "componentnumber", ",", " ", "surfacenumber", ",", 
                    " ", "surfaceid", ",", " ", "\n", "                   ", 
                    "ray2", ",", " ", "ray3", ",", " ", "sid", ",", " ", 
                    "frontid", ",", " ", "sno1", ",", " ", "\n", 
                    "                   ", "sno2", ",", " ", "sno3", ",", " ",
                     "sno4", ",", " ", "rayslot", ",", " ", "\n", 
                    "                   ", "oldgenerationnumber", ",", " ", 
                    "intersectionnumber", ",", " ", "pol1", ",", " ", "pol2", 
                    ",", " ", "\n", "                   ", "pol3"}], "}"}], 
                    " ", "=", " ", "#1"}], ";", " ", 
                    RowBox[{"index1", " ", "=", " ", "index"}], ";", " ", 
                    RowBox[{
                    "xunit", " ", "=", " ", "\n", "                  ", 
                    "r1"}], ";", " ", 
                    RowBox[{"yunit", " ", "=", " ", "r2"}], ";", " ", 
                    RowBox[{"zunit", " ", "=", " ", "r3"}], ";", " ", "\n", 
                    "                 ", 
                    RowBox[{"xunit", " ", "=", " ", 
                    RowBox[{"Chop", "[", "xunit", "]"}]}], ";", " ", 
                    RowBox[{"yunit", " ", "=", " ", 
                    RowBox[{"Chop", "[", "yunit", "]"}]}], ";", " ", "\n", 
                    "                 ", 
                    RowBox[{"zunit", " ", "=", " ", 
                    RowBox[{"Chop", "[", "zunit", "]"}]}], ";", " ", 
                    RowBox[{"magnitude", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"xunit", "^", "2"}], " ", "+", " ", "\n", 
                    "                    ", 
                    RowBox[{"yunit", "^", "2"}], " ", "+", " ", 
                    RowBox[{"zunit", "^", "2"}]}], ")"}], "^", 
                    RowBox[{"2", "^", 
                    RowBox[{"(", 
                    RowBox[{"-", "1"}], ")"}]}]}]}], ";", " ", 
                    RowBox[{"xunit", " ", "=", " ", 
                    RowBox[{
                    "xunit", "/", "\n", "                   ", 
                    "magnitude"}]}], ";", " ", 
                    RowBox[{"yunit", " ", "=", " ", 
                    RowBox[{"yunit", "/", "magnitude"}]}], ";", " ", "\n", 
                    "                 ", 
                    RowBox[{"zunit", " ", "=", " ", 
                    RowBox[{"zunit", "/", "magnitude"}]}], ";", " ", 
                    RowBox[{"rx", " ", "=", " ", "rex"}], ";", " ", "\n", 
                    "                 ", 
                    RowBox[{"ry", " ", "=", " ", "rey"}], ";", " ", 
                    RowBox[{"rz", " ", "=", " ", "rez"}], ";", " ", 
                    RowBox[{"rx", " ", "=", " ", "\n", "                  ", 
                    RowBox[{"Chop", "[", "rx", "]"}]}], ";", " ", 
                    RowBox[{"ry", " ", "=", " ", 
                    RowBox[{"Chop", "[", "ry", "]"}]}], ";", " ", 
                    RowBox[{"rz", " ", "=", " ", "\n", "                  ", 
                    RowBox[{"Chop", "[", "rz", "]"}]}], ";", " ", 
                    RowBox[{"terminatedeflection", " ", "=", " ", "False"}], 
                    ";", " ", 
                    RowBox[{"intersections", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}], "}"}]}], ";", " ", "\n", "                 ", 
                    RowBox[{
                    "intersections", " ", "=", " ", "resonateintersections"}],
                     ";", " ", 
                    RowBox[{"holeQ", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"holeQlist", "[", 
                    RowBox[{
                    "[", "\n", "                    ", "resonatenumber", 
                    "]"}], "]"}], " ", "==", " ", "1"}]}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "newcomponentnumber", ",", " ", "newsurfacenumber", ",", 
                    " ", "\n", "                   ", "newsurfaceid"}], "}"}],
                     " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"2.", ",", " ", "3.", ",", " ", "16600."}], 
                    "}"}]}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "componentnumber", ",", " ", "surfacenumber", ",", " ", 
                    "\n", "                   ", "surfaceid"}], "}"}], " ", 
                    "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"2.", ",", " ", "3.", ",", " ", "16600."}], 
                    "}"}]}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"ray1", ",", " ", "ray2", ",", " ", "ray3"}], 
                    "}"}], " ", "=", " ", "\n", "                  ", 
                    RowBox[{"intersections", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], ";", " ", 
                    RowBox[{"rsx", " ", "=", " ", "rex"}], ";", " ", 
                    RowBox[{
                    "rsy", " ", "=", " ", "\n", "                  ", "rey"}],
                     ";", " ", 
                    RowBox[{"rsz", " ", "=", " ", "rez"}], ";", " ", 
                    RowBox[{"rxhlp", " ", "=", " ", 
                    RowBox[{
                    "rx", " ", "+", " ", "\n", "                   ", 
                    RowBox[{"ray1", "*", "xunit"}]}]}], ";", " ", 
                    RowBox[{"ryhlp", " ", "=", " ", 
                    RowBox[{"ry", " ", "+", " ", 
                    RowBox[{
                    "ray1", "*", "\n", "                    ", "yunit"}]}]}], 
                    ";", " ", 
                    RowBox[{"rzhlp", " ", "=", " ", 
                    RowBox[{"rz", " ", "+", " ", 
                    RowBox[{"ray1", "*", "zunit"}]}]}], ";", " ", "\n", 
                    "                 ", 
                    RowBox[{"rex", " ", "=", " ", "rxhlp"}], ";", " ", 
                    RowBox[{"rey", " ", "=", " ", "ryhlp"}], ";", " ", 
                    RowBox[{
                    "rez", " ", "=", " ", "\n", "                  ", 
                    "rzhlp"}], ";", " ", 
                    RowBox[{"rex", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rex", "]"}]}], ";", " ", 
                    RowBox[{
                    "rey", " ", "=", " ", "\n", "                  ", 
                    RowBox[{"Chop", "[", "rey", "]"}]}], ";", " ", 
                    RowBox[{"rez", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rez", "]"}]}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"rex", " ", "==", " ", "0"}], " ", "&&", " ", 
                    "\n", "                   ", 
                    RowBox[{"rey", " ", "==", " ", "0"}], " ", "&&", " ", 
                    RowBox[{"rez", " ", "==", " ", "0"}]}], ",", " ", 
                    RowBox[{
                    RowBox[{"rex", " ", "=", " ", "rxhlp"}], ";", " ", "\n", 
                    "                   ", 
                    RowBox[{"rey", " ", "=", " ", "ryhlp"}], ";", " ", 
                    RowBox[{"rez", " ", "=", " ", "rzhlp"}]}], ",", " ", 
                    "rex"}], "]"}], ";", " ", "\n", "                 ", 
                    RowBox[{"intersectionnumber", " ", "=", " ", 
                    RowBox[{"intersectionnumber", " ", "+", " ", "1."}]}], 
                    ";", " ", 
                    RowBox[{
                    "opticallength", " ", "=", " ", "\n", 
                    "                  ", 
                    RowBox[{"opticallength", " ", "+", " ", 
                    RowBox[{"ray1", "*", "index1"}]}]}], ";", " ", 
                    RowBox[{
                    "completedray", " ", "=", " ", "\n", "                  ", 
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "\n", "                   ", 
                    "rez", ",", " ", "r1", ",", " ", "r2", ",", " ", "r3", 
                    ",", " ", "r4", ",", " ", "\n", "                   ", 
                    "r5", ",", " ", "r6", ",", " ", "r7", ",", " ", "r8", ",",
                     " ", "r9", ",", " ", "\n", "                   ", 
                    "wavelength", ",", " ", "intensity", ",", " ", 
                    "intensityscale", ",", " ", "ray1", ",", " ", "\n", 
                    "                   ", "index", ",", " ", "opticallength",
                     ",", " ", "phaseshift", ",", " ", "componentnumber", ",",
                     " ", "\n", "                   ", "surfacenumber", ",", 
                    " ", "surfaceid", ",", " ", "ray2", ",", " ", "ray3", ",",
                     " ", "\n", "                   ", "sid", ",", " ", 
                    "frontid", ",", " ", "sno1", ",", " ", "sno2", ",", " ", 
                    "sno3", ",", " ", "\n", "                   ", "sno4", 
                    ",", " ", "rayslot", ",", " ", "generationnumber", ",", 
                    " ", "intersectionnumber", ",", " ", "\n", 
                    "                   ", "pol1", ",", " ", "pol2", ",", " ",
                     "pol3"}], "}"}]}], ";", " ", 
                    RowBox[{"reportedrayspresent", " ", "=", " ", "True"}], 
                    ";", " ", "\n", "                 ", 
                    RowBox[{"intersectionspresent", " ", "=", " ", "True"}], 
                    ";", " ", 
                    RowBox[{"deflectedrayspresent", " ", "=", " ", "True"}], 
                    ";", " ", "\n", "                 ", 
                    RowBox[{
                    "localdummyoutrayspresent", " ", "=", " ", "True"}], ";", 
                    " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"surfnorm", " ", "=", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"1", ",", " ", "0", ",", " ", "0"}], "}"}], ",", 
                    " ", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", " ", "1", ",", " ", "0"}], "}"}], ",", 
                    " ", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", " ", "0", ",", " ", "1"}], "}"}]}], 
                    "}"}], "]"}]}]}], ";", " ", "\n", "                  ", 
                    RowBox[{"dummymatrix", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"#1", " ", "&"}], " ", ")"}], " ", "/@", " ", 
                    "surfnorm"}]}], ";", " ", 
                    RowBox[{"surfnorm", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"#1", "/", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"#1", " ", ".", " ", "#1"}], "]"}]}], " ", "&"}], 
                    " ", ")"}], " ", "/@", " ", "\n", "                    ", 
                    "dummymatrix"}]}], ";", " ", 
                    RowBox[{"surfacerotationmatrix", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"1", ",", " ", "0", ",", " ", "0"}], "}"}], ",", 
                    " ", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", " ", "1", ",", " ", "0"}], "}"}], ",", 
                    " ", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", " ", "0", ",", " ", "1"}], "}"}]}], 
                    "}"}]}], ";", " ", "\n", "                  ", 
                    RowBox[{"surfacetranslationvector", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", " ", "0", ",", " ", "0"}], "}"}]}], ";",
                     " ", 
                    RowBox[{"activeregion", " ", "=", " ", "0."}], ";", " ", 
                    RowBox[{
                    "completedray", " ", "=", " ", "\n", 
                    "                   ", 
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "\n", "                    ", 
                    "rez", ",", " ", "r1", ",", " ", "r2", ",", " ", "r3", 
                    ",", " ", "r4", ",", " ", "\n", "                    ", 
                    "r5", ",", " ", "r6", ",", " ", "r7", ",", " ", "r8", ",",
                     " ", "r9", ",", " ", "\n", "                    ", 
                    "wavelength", ",", " ", "intensity", ",", " ", 
                    "intensityscale", ",", " ", "ray1", ",", " ", "\n", 
                    "                    ", "index", ",", " ", 
                    "opticallength", ",", " ", "phaseshift", ",", " ", 
                    "componentnumber", ",", " ", "\n", "                    ",
                     "surfacenumber", ",", " ", "surfaceid", ",", " ", "ray2",
                     ",", " ", "ray3", ",", " ", "\n", "                    ",
                     "sid", ",", " ", "frontid", ",", " ", "sno1", ",", " ", 
                    "sno2", ",", " ", "sno3", ",", " ", "\n", 
                    "                    ", "sno4", ",", " ", "rayslot", ",", 
                    " ", "generationnumber", ",", " ", "intersectionnumber", 
                    ",", " ", "\n", "                    ", "pol1", ",", " ", 
                    "pol2", ",", " ", "pol3"}], "}"}]}], ";", " ", 
                    RowBox[{
                    "componentnumber", " ", "=", " ", "\n", 
                    "                   ", "newcomponentnumber"}], ";", " ", 
                    RowBox[{
                    "surfacenumber", " ", "=", " ", "newsurfacenumber"}], ";",
                     " ", "\n", "                  ", 
                    RowBox[{"surfaceid", " ", "=", " ", "newsurfaceid"}], ";",
                     " ", 
                    RowBox[{"originalray", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "\n", "                    ", "rsy", ",",
                     " ", "rsz", ",", " ", "rex", ",", " ", "rey", ",", " ", 
                    "rez", ",", " ", "\n", "                    ", "r1", ",", 
                    " ", "r2", ",", " ", "r3", ",", " ", "r4", ",", " ", "r5",
                     ",", " ", "\n", "                    ", "r6", ",", " ", 
                    "r7", ",", " ", "r8", ",", " ", "r9", ",", " ", 
                    "wavelength", ",", " ", "\n", "                    ", 
                    "intensity", ",", " ", "intensityscale", ",", " ", "ray1",
                     ",", " ", "index", ",", " ", "\n", 
                    "                    ", "opticallength", ",", " ", 
                    "phaseshift", ",", " ", "componentnumber", ",", " ", "\n",
                     "                    ", "surfacenumber", ",", " ", 
                    "surfaceid", ",", " ", "ray2", ",", " ", "ray3", ",", " ",
                     "\n", "                    ", "sid", ",", " ", "frontid",
                     ",", " ", "sno1", ",", " ", "sno2", ",", " ", "sno3", 
                    ",", " ", "\n", "                    ", "sno4", ",", " ", 
                    "rayslot", ",", " ", "generationnumber", ",", " ", 
                    "intersectionnumber", ",", " ", "\n", 
                    "                    ", "pol1", ",", " ", "pol2", ",", 
                    " ", "pol3"}], "}"}]}], ";", " ", 
                    RowBox[{"intensity", " ", "=", " ", "0."}], ";", " ", 
                    "\n", "                  ", 
                    RowBox[{"allcreatedrays", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "\n", 
                    "                     ", "rex", ",", " ", "rey", ",", " ",
                     "rez", ",", " ", "r1", ",", " ", "r2", ",", " ", "\n", 
                    "                     ", "r3", ",", " ", "r4", ",", " ", 
                    "r5", ",", " ", "r6", ",", " ", "r7", ",", " ", "\n", 
                    "                     ", "r8", ",", " ", "r9", ",", " ", 
                    "wavelength", ",", " ", "intensity", ",", " ", "\n", 
                    "                     ", "intensityscale", ",", " ", 
                    "ray1", ",", " ", "index", ",", " ", "opticallength", ",",
                     " ", "\n", "                     ", "phaseshift", ",", 
                    " ", "componentnumber", ",", " ", "surfacenumber", ",", 
                    " ", "surfaceid", ",", " ", "\n", "                     ",
                     "ray2", ",", " ", "ray3", ",", " ", "sid", ",", " ", 
                    "frontid", ",", " ", "sno1", ",", " ", "\n", 
                    "                     ", "sno2", ",", " ", "sno3", ",", 
                    " ", "sno4", ",", " ", "rayslot", ",", " ", "\n", 
                    "                     ", "generationnumber", ",", " ", 
                    "intersectionnumber", ",", " ", "pol1", ",", " ", "pol2", 
                    ",", " ", "\n", "                     ", "pol3"}], "}"}], 
                    "}"}]}]}], ")"}], ";", " ", 
                    RowBox[{"{", 
                    RowBox[{"allcreatedrays", ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",",
                     " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", 
                    "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",",
                     " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", 
                    "1.", ",", " ", "1.", ",", " ", "\n", 
                    "                    ", 
                    RowBox[{"-", "1.7976931348623157*^308"}], ",", " ", "1.", 
                    ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", 
                    "0.", ",", " ", 
                    RowBox[{"-", "1."}], ",", " ", 
                    RowBox[{"-", "1."}], ",", " ", 
                    RowBox[{"-", "1."}], ",", " ", "1.", ",", " ", "1.", ",", 
                    " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.",
                     ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ",
                     "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", 
                    ",", " ", "1."}], "}"}], "}"}], ",", " ", "\n", 
                    "                  ", 
                    RowBox[{"{", "completedray", "}"}]}], "}"}]}], ",", " ", 
                    RowBox[{"resonatenumber", " ", "==", " ", "4"}], ",", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "\n", 
                    "                   ", "rsz", ",", " ", "rex", ",", " ", 
                    "rey", ",", " ", "rez", ",", " ", "r1", ",", " ", "\n", 
                    "                   ", "r2", ",", " ", "r3", ",", " ", 
                    "r4", ",", " ", "r5", ",", " ", "r6", ",", " ", "\n", 
                    "                   ", "r7", ",", " ", "r8", ",", " ", 
                    "r9", ",", " ", "wavelength", ",", " ", "intensity", ",", 
                    " ", "\n", "                   ", "intensityscale", ",", 
                    " ", "ray1", ",", " ", "index", ",", " ", "opticallength",
                     ",", " ", "\n", "                   ", "phaseshift", ",",
                     " ", "componentnumber", ",", " ", "surfacenumber", ",", 
                    " ", "surfaceid", ",", " ", "\n", "                   ", 
                    "ray2", ",", " ", "ray3", ",", " ", "sid", ",", " ", 
                    "frontid", ",", " ", "sno1", ",", " ", "\n", 
                    "                   ", "sno2", ",", " ", "sno3", ",", " ",
                     "sno4", ",", " ", "rayslot", ",", " ", "\n", 
                    "                   ", "oldgenerationnumber", ",", " ", 
                    "intersectionnumber", ",", " ", "pol1", ",", " ", "pol2", 
                    ",", " ", "\n", "                   ", "pol3"}], "}"}], 
                    " ", "=", " ", "#1"}], ";", " ", 
                    RowBox[{"index1", " ", "=", " ", "index"}], ";", " ", 
                    RowBox[{
                    "xunit", " ", "=", " ", "\n", "                  ", 
                    RowBox[{
                    RowBox[{"-", "1."}], "*", "r2"}]}], ";", " ", 
                    RowBox[{"yunit", " ", "=", " ", "r1"}], ";", " ", 
                    RowBox[{"zunit", " ", "=", " ", "r3"}], ";", " ", "\n", 
                    "                 ", 
                    RowBox[{"xunit", " ", "=", " ", 
                    RowBox[{"Chop", "[", "xunit", "]"}]}], ";", " ", 
                    RowBox[{"yunit", " ", "=", " ", 
                    RowBox[{"Chop", "[", "yunit", "]"}]}], ";", " ", "\n", 
                    "                 ", 
                    RowBox[{"zunit", " ", "=", " ", 
                    RowBox[{"Chop", "[", "zunit", "]"}]}], ";", " ", 
                    RowBox[{"magnitude", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"xunit", "^", "2"}], " ", "+", " ", "\n", 
                    "                    ", 
                    RowBox[{"yunit", "^", "2"}], " ", "+", " ", 
                    RowBox[{"zunit", "^", "2"}]}], ")"}], "^", 
                    RowBox[{"2", "^", 
                    RowBox[{"(", 
                    RowBox[{"-", "1"}], ")"}]}]}]}], ";", " ", 
                    RowBox[{"xunit", " ", "=", " ", 
                    RowBox[{
                    "xunit", "/", "\n", "                   ", 
                    "magnitude"}]}], ";", " ", 
                    RowBox[{"yunit", " ", "=", " ", 
                    RowBox[{"yunit", "/", "magnitude"}]}], ";", " ", "\n", 
                    "                 ", 
                    RowBox[{"zunit", " ", "=", " ", 
                    RowBox[{"zunit", "/", "magnitude"}]}], ";", " ", 
                    RowBox[{"rx", " ", "=", " ", "\n", "                  ", 
                    RowBox[{
                    RowBox[{"-", "1."}], "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "75."}], " ", "+", " ", "rey"}], ")"}]}]}], 
                    ";", " ", 
                    RowBox[{"ry", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"-", "100."}], " ", "+", " ", "rex"}]}], ";", " ", 
                    RowBox[{
                    "rz", " ", "=", " ", "\n", "                  ", "rez"}], 
                    ";", " ", 
                    RowBox[{"rx", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rx", "]"}]}], ";", " ", 
                    RowBox[{"ry", " ", "=", " ", 
                    RowBox[{"Chop", "[", "ry", "]"}]}], ";", " ", "\n", 
                    "                 ", 
                    RowBox[{"rz", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rz", "]"}]}], ";", " ", 
                    RowBox[{"terminatedeflection", " ", "=", " ", "False"}], 
                    ";", " ", 
                    RowBox[{
                    "intersections", " ", "=", " ", "\n", 
                    "                  ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}], "}"}]}], ";", " ", 
                    RowBox[{
                    "intersections", " ", "=", " ", "resonateintersections"}],
                     ";", " ", 
                    RowBox[{
                    "holeQ", " ", "=", " ", "\n", "                  ", 
                    RowBox[{
                    RowBox[{"holeQlist", "[", 
                    RowBox[{"[", "resonatenumber", "]"}], "]"}], " ", "==", 
                    " ", "1"}]}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "newcomponentnumber", ",", " ", "\n", 
                    "                   ", "newsurfacenumber", ",", " ", 
                    "newsurfaceid"}], "}"}], " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"2.", ",", " ", "4.", ",", " ", "16601."}], 
                    "}"}]}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "componentnumber", ",", " ", "\n", "                   ", 
                    "surfacenumber", ",", " ", "surfaceid"}], "}"}], " ", "=",
                     " ", 
                    RowBox[{"{", 
                    RowBox[{"2.", ",", " ", "4.", ",", " ", "16601."}], 
                    "}"}]}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "ray1", ",", " ", "ray2", ",", " ", "\n", 
                    "                   ", "ray3"}], "}"}], " ", "=", " ", 
                    RowBox[{"intersections", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], ";", " ", 
                    RowBox[{"rsx", " ", "=", " ", "rex"}], ";", " ", "\n", 
                    "                 ", 
                    RowBox[{"rsy", " ", "=", " ", "rey"}], ";", " ", 
                    RowBox[{"rsz", " ", "=", " ", "rez"}], ";", " ", 
                    RowBox[{
                    "rxhlp", " ", "=", " ", "\n", "                  ", 
                    RowBox[{"rx", " ", "+", " ", 
                    RowBox[{"ray1", "*", "xunit"}]}]}], ";", " ", 
                    RowBox[{"ryhlp", " ", "=", " ", 
                    RowBox[{
                    "ry", " ", "+", " ", "\n", "                   ", 
                    RowBox[{"ray1", "*", "yunit"}]}]}], ";", " ", 
                    RowBox[{"rzhlp", " ", "=", " ", 
                    RowBox[{"rz", " ", "+", " ", 
                    RowBox[{
                    "ray1", "*", "\n", "                    ", "zunit"}]}]}], 
                    ";", " ", 
                    RowBox[{"rex", " ", "=", " ", 
                    RowBox[{"100.", " ", "+", " ", "ryhlp"}]}], ";", " ", 
                    RowBox[{
                    "rey", " ", "=", " ", "\n", "                  ", 
                    RowBox[{"75.", " ", "-", " ", 
                    RowBox[{"1.", "*", "rxhlp"}]}]}], ";", " ", 
                    RowBox[{"rez", " ", "=", " ", "rzhlp"}], ";", " ", 
                    RowBox[{
                    "rex", " ", "=", " ", "\n", "                  ", 
                    RowBox[{"Chop", "[", "rex", "]"}]}], ";", " ", 
                    RowBox[{"rey", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rey", "]"}]}], ";", " ", 
                    RowBox[{
                    "rez", " ", "=", " ", "\n", "                  ", 
                    RowBox[{"Chop", "[", "rez", "]"}]}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"rex", " ", "==", " ", "0"}], " ", "&&", " ", 
                    RowBox[{"rey", " ", "==", " ", "0"}], " ", "&&", " ", 
                    RowBox[{"rez", " ", "==", " ", "0"}]}], ",", " ", "\n", 
                    "                  ", 
                    RowBox[{
                    RowBox[{"rex", " ", "=", " ", 
                    RowBox[{"100.", " ", "+", " ", "rxhlp"}]}], ";", " ", 
                    RowBox[{"rey", " ", "=", " ", 
                    RowBox[{"75.", " ", "+", " ", "ryhlp"}]}], ";", " ", "\n",
                     "                   ", 
                    RowBox[{"rez", " ", "=", " ", "rzhlp"}]}], ",", " ", 
                    "rex"}], "]"}], ";", " ", 
                    RowBox[{
                    "intersectionnumber", " ", "=", " ", "\n", 
                    "                  ", 
                    RowBox[{"intersectionnumber", " ", "+", " ", "1."}]}], 
                    ";", " ", 
                    RowBox[{"opticallength", " ", "=", " ", 
                    RowBox[{
                    "opticallength", " ", "+", " ", "\n", 
                    "                   ", 
                    RowBox[{"ray1", "*", "index1"}]}]}], ";", " ", 
                    RowBox[{"completedray", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "\n", "                   ", "rsy", ",", 
                    " ", "rsz", ",", " ", "rex", ",", " ", "rey", ",", " ", 
                    "rez", ",", " ", "\n", "                   ", "r1", ",", 
                    " ", "r2", ",", " ", "r3", ",", " ", "r4", ",", " ", "r5",
                     ",", " ", "\n", "                   ", "r6", ",", " ", 
                    "r7", ",", " ", "r8", ",", " ", "r9", ",", " ", 
                    "wavelength", ",", " ", "\n", "                   ", 
                    "intensity", ",", " ", "intensityscale", ",", " ", "ray1",
                     ",", " ", "index", ",", " ", "\n", "                   ",
                     "opticallength", ",", " ", "phaseshift", ",", " ", 
                    "componentnumber", ",", " ", "surfacenumber", ",", " ", 
                    "\n", "                   ", "surfaceid", ",", " ", 
                    "ray2", ",", " ", "ray3", ",", " ", "sid", ",", " ", 
                    "frontid", ",", " ", "\n", "                   ", "sno1", 
                    ",", " ", "sno2", ",", " ", "sno3", ",", " ", "sno4", ",",
                     " ", "rayslot", ",", " ", "\n", "                   ", 
                    "generationnumber", ",", " ", "intersectionnumber", ",", 
                    " ", "pol1", ",", " ", "pol2", ",", " ", "\n", 
                    "                   ", "pol3"}], "}"}]}], ";", " ", 
                    RowBox[{"reportedrayspresent", " ", "=", " ", "True"}], 
                    ";", " ", 
                    RowBox[{"intersectionspresent", " ", "=", " ", "True"}], 
                    ";", " ", "\n", "                 ", 
                    RowBox[{"deflectedrayspresent", " ", "=", " ", "True"}], 
                    ";", " ", 
                    RowBox[{
                    "localdummyoutrayspresent", " ", "=", " ", "True"}], ";", 
                    " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    "surfnorm", " ", "=", " ", "\n", "                   ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"1", ",", " ", "0", ",", " ", "0"}], "}"}], ",", 
                    " ", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", " ", "1", ",", " ", "0"}], "}"}], ",", 
                    " ", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", " ", "0", ",", " ", "1"}], "}"}]}], 
                    "}"}], "]"}]}]}], ";", " ", 
                    RowBox[{"dummymatrix", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "1.", ",", " ", "0."}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "0.", ",", " ", "1."}], "}"}]}], 
                    "}"}], " ", ".", " ", "#1"}], " ", "&"}], " ", ")"}], " ",
                     "/@", " ", "\n", "                    ", "surfnorm"}]}], 
                    ";", " ", 
                    RowBox[{"surfnorm", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"#1", "/", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"#1", " ", ".", " ", "#1"}], "]"}]}], " ", "&"}], 
                    " ", ")"}], " ", "/@", " ", "dummymatrix"}]}], ";", " ", 
                    "\n", "                  ", 
                    RowBox[{"surfacerotationmatrix", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0", ",", " ", 
                    RowBox[{"-", "1."}], ",", " ", "0"}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"1.", ",", " ", "0", ",", " ", "0"}], "}"}], ",", 
                    " ", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", " ", "0", ",", " ", "1."}], "}"}]}], 
                    "}"}]}], ";", " ", 
                    RowBox[{
                    "surfacetranslationvector", " ", "=", " ", "\n", 
                    "                   ", 
                    RowBox[{"{", 
                    RowBox[{"100.", ",", " ", "75.", ",", " ", "0"}], "}"}]}],
                     ";", " ", 
                    RowBox[{"activeregion", " ", "=", " ", "0."}], ";", " ", 
                    RowBox[{"completedray", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "\n", "                    ", "rsy", ",",
                     " ", "rsz", ",", " ", "rex", ",", " ", "rey", ",", " ", 
                    "rez", ",", " ", "\n", "                    ", "r1", ",", 
                    " ", "r2", ",", " ", "r3", ",", " ", "r4", ",", " ", "r5",
                     ",", " ", "\n", "                    ", "r6", ",", " ", 
                    "r7", ",", " ", "r8", ",", " ", "r9", ",", " ", 
                    "wavelength", ",", " ", "\n", "                    ", 
                    "intensity", ",", " ", "intensityscale", ",", " ", "ray1",
                     ",", " ", "index", ",", " ", "\n", 
                    "                    ", "opticallength", ",", " ", 
                    "phaseshift", ",", " ", "componentnumber", ",", " ", "\n",
                     "                    ", "surfacenumber", ",", " ", 
                    "surfaceid", ",", " ", "ray2", ",", " ", "ray3", ",", " ",
                     "\n", "                    ", "sid", ",", " ", "frontid",
                     ",", " ", "sno1", ",", " ", "sno2", ",", " ", "sno3", 
                    ",", " ", "\n", "                    ", "sno4", ",", " ", 
                    "rayslot", ",", " ", "generationnumber", ",", " ", 
                    "intersectionnumber", ",", " ", "\n", 
                    "                    ", "pol1", ",", " ", "pol2", ",", 
                    " ", "pol3"}], "}"}]}], ";", " ", 
                    RowBox[{
                    "componentnumber", " ", "=", " ", "\n", 
                    "                   ", "newcomponentnumber"}], ";", " ", 
                    RowBox[{
                    "surfacenumber", " ", "=", " ", "newsurfacenumber"}], ";",
                     " ", "\n", "                  ", 
                    RowBox[{"surfaceid", " ", "=", " ", "newsurfaceid"}], ";",
                     " ", 
                    RowBox[{"originalray", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "\n", "                    ", "rsy", ",",
                     " ", "rsz", ",", " ", "rex", ",", " ", "rey", ",", " ", 
                    "rez", ",", " ", "\n", "                    ", "r1", ",", 
                    " ", "r2", ",", " ", "r3", ",", " ", "r4", ",", " ", "r5",
                     ",", " ", "\n", "                    ", "r6", ",", " ", 
                    "r7", ",", " ", "r8", ",", " ", "r9", ",", " ", 
                    "wavelength", ",", " ", "\n", "                    ", 
                    "intensity", ",", " ", "intensityscale", ",", " ", "ray1",
                     ",", " ", "index", ",", " ", "\n", 
                    "                    ", "opticallength", ",", " ", 
                    "phaseshift", ",", " ", "componentnumber", ",", " ", "\n",
                     "                    ", "surfacenumber", ",", " ", 
                    "surfaceid", ",", " ", "ray2", ",", " ", "ray3", ",", " ",
                     "\n", "                    ", "sid", ",", " ", "frontid",
                     ",", " ", "sno1", ",", " ", "sno2", ",", " ", "sno3", 
                    ",", " ", "\n", "                    ", "sno4", ",", " ", 
                    "rayslot", ",", " ", "generationnumber", ",", " ", 
                    "intersectionnumber", ",", " ", "\n", 
                    "                    ", "pol1", ",", " ", "pol2", ",", 
                    " ", "pol3"}], "}"}]}], ";", " ", 
                    RowBox[{"intensity", " ", "=", " ", "0."}], ";", " ", 
                    "\n", "                  ", 
                    RowBox[{"allcreatedrays", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "\n", 
                    "                     ", "rex", ",", " ", "rey", ",", " ",
                     "rez", ",", " ", "r1", ",", " ", "r2", ",", " ", "\n", 
                    "                     ", "r3", ",", " ", "r4", ",", " ", 
                    "r5", ",", " ", "r6", ",", " ", "r7", ",", " ", "\n", 
                    "                     ", "r8", ",", " ", "r9", ",", " ", 
                    "wavelength", ",", " ", "intensity", ",", " ", "\n", 
                    "                     ", "intensityscale", ",", " ", 
                    "ray1", ",", " ", "index", ",", " ", "opticallength", ",",
                     " ", "\n", "                     ", "phaseshift", ",", 
                    " ", "componentnumber", ",", " ", "surfacenumber", ",", 
                    " ", "surfaceid", ",", " ", "\n", "                     ",
                     "ray2", ",", " ", "ray3", ",", " ", "sid", ",", " ", 
                    "frontid", ",", " ", "sno1", ",", " ", "\n", 
                    "                     ", "sno2", ",", " ", "sno3", ",", 
                    " ", "sno4", ",", " ", "rayslot", ",", " ", "\n", 
                    "                     ", "generationnumber", ",", " ", 
                    "intersectionnumber", ",", " ", "pol1", ",", " ", "pol2", 
                    ",", " ", "\n", "                     ", "pol3"}], "}"}], 
                    "}"}]}]}], ")"}], ";", " ", 
                    RowBox[{"{", 
                    RowBox[{"allcreatedrays", ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",",
                     " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", 
                    "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",",
                     " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", 
                    "1.", ",", " ", "1.", ",", " ", "\n", 
                    "                    ", 
                    RowBox[{"-", "1.7976931348623157*^308"}], ",", " ", "1.", 
                    ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", 
                    "0.", ",", " ", 
                    RowBox[{"-", "1."}], ",", " ", 
                    RowBox[{"-", "1."}], ",", " ", 
                    RowBox[{"-", "1."}], ",", " ", "1.", ",", " ", "1.", ",", 
                    " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.",
                     ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ",
                     "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", 
                    ",", " ", "1."}], "}"}], "}"}], ",", " ", "\n", 
                    "                  ", 
                    RowBox[{"{", "completedray", "}"}]}], "}"}]}], ",", " ", 
                    RowBox[{"resonatenumber", " ", "==", " ", "5"}], ",", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "\n", 
                    "                   ", "rsz", ",", " ", "rex", ",", " ", 
                    "rey", ",", " ", "rez", ",", " ", "r1", ",", " ", "\n", 
                    "                   ", "r2", ",", " ", "r3", ",", " ", 
                    "r4", ",", " ", "r5", ",", " ", "r6", ",", " ", "\n", 
                    "                   ", "r7", ",", " ", "r8", ",", " ", 
                    "r9", ",", " ", "wavelength", ",", " ", "intensity", ",", 
                    " ", "\n", "                   ", "intensityscale", ",", 
                    " ", "ray1", ",", " ", "index", ",", " ", "opticallength",
                     ",", " ", "\n", "                   ", "phaseshift", ",",
                     " ", "componentnumber", ",", " ", "surfacenumber", ",", 
                    " ", "surfaceid", ",", " ", "\n", "                   ", 
                    "ray2", ",", " ", "ray3", ",", " ", "sid", ",", " ", 
                    "frontid", ",", " ", "sno1", ",", " ", "\n", 
                    "                   ", "sno2", ",", " ", "sno3", ",", " ",
                     "sno4", ",", " ", "rayslot", ",", " ", "\n", 
                    "                   ", "oldgenerationnumber", ",", " ", 
                    "intersectionnumber", ",", " ", "pol1", ",", " ", "pol2", 
                    ",", " ", "\n", "                   ", "pol3"}], "}"}], 
                    " ", "=", " ", "#1"}], ";", " ", 
                    RowBox[{"index1", " ", "=", " ", "index"}], ";", " ", 
                    RowBox[{
                    "xunit", " ", "=", " ", "\n", "                  ", 
                    "r3"}], ";", " ", 
                    RowBox[{"yunit", " ", "=", " ", "r2"}], ";", " ", 
                    RowBox[{"zunit", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"-", "1."}], "*", "r1"}]}], ";", " ", "\n", 
                    "                 ", 
                    RowBox[{"xunit", " ", "=", " ", 
                    RowBox[{"Chop", "[", "xunit", "]"}]}], ";", " ", 
                    RowBox[{"yunit", " ", "=", " ", 
                    RowBox[{"Chop", "[", "yunit", "]"}]}], ";", " ", "\n", 
                    "                 ", 
                    RowBox[{"zunit", " ", "=", " ", 
                    RowBox[{"Chop", "[", "zunit", "]"}]}], ";", " ", 
                    RowBox[{"magnitude", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"xunit", "^", "2"}], " ", "+", " ", "\n", 
                    "                    ", 
                    RowBox[{"yunit", "^", "2"}], " ", "+", " ", 
                    RowBox[{"zunit", "^", "2"}]}], ")"}], "^", 
                    RowBox[{"2", "^", 
                    RowBox[{"(", 
                    RowBox[{"-", "1"}], ")"}]}]}]}], ";", " ", 
                    RowBox[{"xunit", " ", "=", " ", 
                    RowBox[{
                    "xunit", "/", "\n", "                   ", 
                    "magnitude"}]}], ";", " ", 
                    RowBox[{"yunit", " ", "=", " ", 
                    RowBox[{"yunit", "/", "magnitude"}]}], ";", " ", "\n", 
                    "                 ", 
                    RowBox[{"zunit", " ", "=", " ", 
                    RowBox[{"zunit", "/", "magnitude"}]}], ";", " ", 
                    RowBox[{"rx", " ", "=", " ", "\n", "                  ", 
                    RowBox[{"75.", " ", "+", " ", "rez"}]}], ";", " ", 
                    RowBox[{"ry", " ", "=", " ", "rey"}], ";", " ", 
                    RowBox[{"rz", " ", "=", " ", "\n", "                  ", 
                    RowBox[{
                    RowBox[{"-", "1."}], "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "100."}], " ", "+", " ", "rex"}], ")"}]}]}], 
                    ";", " ", 
                    RowBox[{"rx", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rx", "]"}]}], ";", " ", 
                    RowBox[{"ry", " ", "=", " ", "\n", "                  ", 
                    RowBox[{"Chop", "[", "ry", "]"}]}], ";", " ", 
                    RowBox[{"rz", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rz", "]"}]}], ";", " ", 
                    RowBox[{"terminatedeflection", " ", "=", " ", "False"}], 
                    ";", " ", "\n", "                 ", 
                    RowBox[{"intersections", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}], "}"}]}], ";", " ", 
                    RowBox[{
                    "intersections", " ", "=", " ", "resonateintersections"}],
                     ";", " ", "\n", "                 ", 
                    RowBox[{"holeQ", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"holeQlist", "[", 
                    RowBox[{"[", "resonatenumber", "]"}], "]"}], " ", "==", 
                    " ", "1"}]}], ";", " ", "\n", "                 ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "newcomponentnumber", ",", " ", "newsurfacenumber", ",", 
                    " ", "newsurfaceid"}], "}"}], " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"2.", ",", " ", "5.", ",", " ", "16602."}], 
                    "}"}]}], ";", " ", "\n", "                 ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "componentnumber", ",", " ", "surfacenumber", ",", " ", 
                    "surfaceid"}], "}"}], " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"2.", ",", " ", "5.", ",", " ", "16602."}], 
                    "}"}]}], ";", " ", "\n", "                 ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"ray1", ",", " ", "ray2", ",", " ", "ray3"}], 
                    "}"}], " ", "=", " ", 
                    RowBox[{"intersections", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], ";", " ", "\n", 
                    "                 ", 
                    RowBox[{"rsx", " ", "=", " ", "rex"}], ";", " ", 
                    RowBox[{"rsy", " ", "=", " ", "rey"}], ";", " ", 
                    RowBox[{
                    "rsz", " ", "=", " ", "\n", "                  ", "rez"}],
                     ";", " ", 
                    RowBox[{"rxhlp", " ", "=", " ", 
                    RowBox[{"rx", " ", "+", " ", 
                    RowBox[{"ray1", "*", "xunit"}]}]}], ";", " ", "\n", 
                    "                 ", 
                    RowBox[{"ryhlp", " ", "=", " ", 
                    RowBox[{"ry", " ", "+", " ", 
                    RowBox[{"ray1", "*", "yunit"}]}]}], ";", " ", 
                    RowBox[{
                    "rzhlp", " ", "=", " ", "\n", "                  ", 
                    RowBox[{"rz", " ", "+", " ", 
                    RowBox[{"ray1", "*", "zunit"}]}]}], ";", " ", 
                    RowBox[{"rex", " ", "=", " ", "\n", "                  ", 
                    
                    RowBox[{"100.", " ", "-", " ", 
                    RowBox[{"1.", "*", "rzhlp"}]}]}], ";", " ", 
                    RowBox[{"rey", " ", "=", " ", "ryhlp"}], ";", " ", 
                    RowBox[{
                    "rez", " ", "=", " ", "\n", "                  ", 
                    RowBox[{
                    RowBox[{"-", "75."}], " ", "+", " ", "rxhlp"}]}], ";", 
                    " ", 
                    RowBox[{"rex", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rex", "]"}]}], ";", " ", 
                    RowBox[{
                    "rey", " ", "=", " ", "\n", "                  ", 
                    RowBox[{"Chop", "[", "rey", "]"}]}], ";", " ", 
                    RowBox[{"rez", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rez", "]"}]}], ";", " ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"rex", " ", "==", " ", "0"}], " ", "&&", " ", 
                    "\n", "                   ", 
                    RowBox[{"rey", " ", "==", " ", "0"}], " ", "&&", " ", 
                    RowBox[{"rez", " ", "==", " ", "0"}]}], ",", " ", 
                    RowBox[{
                    RowBox[{"rex", " ", "=", " ", 
                    RowBox[{"100.", " ", "+", " ", "rxhlp"}]}], ";", " ", 
                    "\n", "                   ", 
                    RowBox[{"rey", " ", "=", " ", "ryhlp"}], ";", " ", 
                    RowBox[{"rez", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"-", "75."}], " ", "+", " ", "rzhlp"}]}]}], ",", 
                    " ", "\n", "                  ", "rex"}], "]"}], ";", " ", 
                    RowBox[{"intersectionnumber", " ", "=", " ", 
                    RowBox[{"intersectionnumber", " ", "+", " ", "1."}]}], 
                    ";", " ", "\n", "                 ", 
                    RowBox[{"opticallength", " ", "=", " ", 
                    RowBox[{"opticallength", " ", "+", " ", 
                    RowBox[{"ray1", "*", "index1"}]}]}], ";", " ", "\n", 
                    "                 ", 
                    RowBox[{"completedray", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "\n", "                   ", "rey", ",", " ", 
                    "rez", ",", " ", "r1", ",", " ", "r2", ",", " ", "r3", 
                    ",", " ", "\n", "                   ", "r4", ",", " ", 
                    "r5", ",", " ", "r6", ",", " ", "r7", ",", " ", "r8", ",",
                     " ", "\n", "                   ", "r9", ",", " ", 
                    "wavelength", ",", " ", "intensity", ",", " ", 
                    "intensityscale", ",", " ", "\n", "                   ", 
                    "ray1", ",", " ", "index", ",", " ", "opticallength", ",",
                     " ", "phaseshift", ",", " ", "\n", "                   ",
                     "componentnumber", ",", " ", "surfacenumber", ",", " ", 
                    "surfaceid", ",", " ", "ray2", ",", " ", "\n", 
                    "                   ", "ray3", ",", " ", "sid", ",", " ", 
                    "frontid", ",", " ", "sno1", ",", " ", "sno2", ",", " ", 
                    "\n", "                   ", "sno3", ",", " ", "sno4", 
                    ",", " ", "rayslot", ",", " ", "generationnumber", ",", 
                    " ", "\n", "                   ", "intersectionnumber", 
                    ",", " ", "pol1", ",", " ", "pol2", ",", " ", "pol3"}], 
                    "}"}]}], ";", " ", "\n", "                 ", 
                    RowBox[{"reportedrayspresent", " ", "=", " ", "True"}], 
                    ";", " ", 
                    RowBox[{"intersectionspresent", " ", "=", " ", "True"}], 
                    ";", " ", 
                    RowBox[{
                    "deflectedrayspresent", " ", "=", " ", "\n", 
                    "                  ", "True"}], ";", " ", 
                    RowBox[{
                    "localdummyoutrayspresent", " ", "=", " ", "True"}], ";", 
                    " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"surfnorm", " ", "=", " ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"1", ",", " ", "0", ",", " ", "0"}], "}"}], ",", 
                    " ", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", " ", "1", ",", " ", "0"}], "}"}], ",", 
                    " ", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", " ", "0", ",", " ", "1"}], "}"}]}], 
                    "}"}], "]"}]}]}], ";", " ", "\n", "                  ", 
                    RowBox[{"dummymatrix", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "0.", ",", " ", 
                    RowBox[{"-", "1."}]}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "1.", ",", " ", "0."}], "}"}], 
                    ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"1.", ",", " ", "0.", ",", " ", "0."}], "}"}]}], 
                    "}"}], " ", ".", " ", "#1"}], " ", "&"}], " ", ")"}], " ",
                     "/@", " ", "surfnorm"}]}], ";", " ", "\n", 
                    "                  ", 
                    RowBox[{"surfnorm", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"#1", "/", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"#1", " ", ".", " ", "#1"}], "]"}]}], " ", "&"}], 
                    " ", ")"}], " ", "/@", " ", "dummymatrix"}]}], ";", " ", 
                    RowBox[{
                    "surfacerotationmatrix", " ", "=", " ", "\n", 
                    "                   ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0", ",", " ", "0", ",", " ", "1."}], "}"}], ",", 
                    " ", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", " ", "1.", ",", " ", "0"}], "}"}], ",", 
                    " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0", ",", " ", "0"}], 
                    "}"}]}], "}"}]}], ";", " ", 
                    RowBox[{"surfacetranslationvector", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"100.", ",", " ", "0", ",", " ", 
                    RowBox[{"-", "75."}]}], "}"}]}], ";", " ", 
                    RowBox[{"activeregion", " ", "=", " ", "0."}], ";", " ", 
                    "\n", "                  ", 
                    RowBox[{"completedray", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "\n", "                    ", "rey", ",", " ", 
                    "rez", ",", " ", "r1", ",", " ", "r2", ",", " ", "r3", 
                    ",", " ", "\n", "                    ", "r4", ",", " ", 
                    "r5", ",", " ", "r6", ",", " ", "r7", ",", " ", "r8", ",",
                     " ", "\n", "                    ", "r9", ",", " ", 
                    "wavelength", ",", " ", "intensity", ",", " ", 
                    "intensityscale", ",", " ", "\n", "                    ", 
                    "ray1", ",", " ", "index", ",", " ", "opticallength", ",",
                     " ", "phaseshift", ",", " ", "\n", 
                    "                    ", "componentnumber", ",", " ", 
                    "surfacenumber", ",", " ", "surfaceid", ",", " ", "ray2", 
                    ",", " ", "\n", "                    ", "ray3", ",", " ", 
                    "sid", ",", " ", "frontid", ",", " ", "sno1", ",", " ", 
                    "sno2", ",", " ", "\n", "                    ", "sno3", 
                    ",", " ", "sno4", ",", " ", "rayslot", ",", " ", 
                    "generationnumber", ",", " ", "\n", 
                    "                    ", "intersectionnumber", ",", " ", 
                    "pol1", ",", " ", "pol2", ",", " ", "pol3"}], "}"}]}], 
                    ";", " ", "\n", "                  ", 
                    RowBox[{
                    "componentnumber", " ", "=", " ", "newcomponentnumber"}], 
                    ";", " ", 
                    RowBox[{
                    "surfacenumber", " ", "=", " ", "\n", 
                    "                   ", "newsurfacenumber"}], ";", " ", 
                    RowBox[{"surfaceid", " ", "=", " ", "newsurfaceid"}], ";",
                     " ", 
                    RowBox[{
                    "originalray", " ", "=", " ", "\n", "                   ", 
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "\n", "                    ", 
                    "rez", ",", " ", "r1", ",", " ", "r2", ",", " ", "r3", 
                    ",", " ", "r4", ",", " ", "\n", "                    ", 
                    "r5", ",", " ", "r6", ",", " ", "r7", ",", " ", "r8", ",",
                     " ", "r9", ",", " ", "\n", "                    ", 
                    "wavelength", ",", " ", "intensity", ",", " ", 
                    "intensityscale", ",", " ", "ray1", ",", " ", "\n", 
                    "                    ", "index", ",", " ", 
                    "opticallength", ",", " ", "phaseshift", ",", " ", 
                    "componentnumber", ",", " ", "\n", "                    ",
                     "surfacenumber", ",", " ", "surfaceid", ",", " ", "ray2",
                     ",", " ", "ray3", ",", " ", "\n", "                    ",
                     "sid", ",", " ", "frontid", ",", " ", "sno1", ",", " ", 
                    "sno2", ",", " ", "sno3", ",", " ", "\n", 
                    "                    ", "sno4", ",", " ", "rayslot", ",", 
                    " ", "generationnumber", ",", " ", "intersectionnumber", 
                    ",", " ", "\n", "                    ", "pol1", ",", " ", 
                    "pol2", ",", " ", "pol3"}], "}"}]}], ";", " ", 
                    RowBox[{"intensity", " ", "=", " ", "0."}], ";", " ", 
                    "\n", "                  ", 
                    RowBox[{"allcreatedrays", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "\n", 
                    "                     ", "rex", ",", " ", "rey", ",", " ",
                     "rez", ",", " ", "r1", ",", " ", "r2", ",", " ", "\n", 
                    "                     ", "r3", ",", " ", "r4", ",", " ", 
                    "r5", ",", " ", "r6", ",", " ", "r7", ",", " ", "\n", 
                    "                     ", "r8", ",", " ", "r9", ",", " ", 
                    "wavelength", ",", " ", "intensity", ",", " ", "\n", 
                    "                     ", "intensityscale", ",", " ", 
                    "ray1", ",", " ", "index", ",", " ", "opticallength", ",",
                     " ", "\n", "                     ", "phaseshift", ",", 
                    " ", "componentnumber", ",", " ", "surfacenumber", ",", 
                    " ", "surfaceid", ",", " ", "\n", "                     ",
                     "ray2", ",", " ", "ray3", ",", " ", "sid", ",", " ", 
                    "frontid", ",", " ", "sno1", ",", " ", "\n", 
                    "                     ", "sno2", ",", " ", "sno3", ",", 
                    " ", "sno4", ",", " ", "rayslot", ",", " ", "\n", 
                    "                     ", "generationnumber", ",", " ", 
                    "intersectionnumber", ",", " ", "pol1", ",", " ", "pol2", 
                    ",", " ", "\n", "                     ", "pol3"}], "}"}], 
                    "}"}]}]}], ")"}], ";", " ", 
                    RowBox[{"{", 
                    RowBox[{"allcreatedrays", ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",",
                     " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", 
                    "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",",
                     " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", 
                    "1.", ",", " ", "1.", ",", " ", "\n", 
                    "                    ", 
                    RowBox[{"-", "1.7976931348623157*^308"}], ",", " ", "1.", 
                    ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", 
                    "0.", ",", " ", 
                    RowBox[{"-", "1."}], ",", " ", 
                    RowBox[{"-", "1."}], ",", " ", 
                    RowBox[{"-", "1."}], ",", " ", "1.", ",", " ", "1.", ",", 
                    " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.",
                     ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ",
                     "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", 
                    ",", " ", "1."}], "}"}], "}"}], ",", " ", "\n", 
                    "                  ", 
                    RowBox[{"{", "completedray", "}"}]}], "}"}]}], ",", " ", 
                    RowBox[{"resonatenumber", " ", "==", " ", "6"}], ",", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "\n", 
                    "                   ", "rsz", ",", " ", "rex", ",", " ", 
                    "rey", ",", " ", "rez", ",", " ", "r1", ",", " ", "\n", 
                    "                   ", "r2", ",", " ", "r3", ",", " ", 
                    "r4", ",", " ", "r5", ",", " ", "r6", ",", " ", "\n", 
                    "                   ", "r7", ",", " ", "r8", ",", " ", 
                    "r9", ",", " ", "wavelength", ",", " ", "intensity", ",", 
                    " ", "\n", "                   ", "intensityscale", ",", 
                    " ", "ray1", ",", " ", "index", ",", " ", "opticallength",
                     ",", " ", "\n", "                   ", "phaseshift", ",",
                     " ", "componentnumber", ",", " ", "surfacenumber", ",", 
                    " ", "surfaceid", ",", " ", "\n", "                   ", 
                    "ray2", ",", " ", "ray3", ",", " ", "sid", ",", " ", 
                    "frontid", ",", " ", "sno1", ",", " ", "\n", 
                    "                   ", "sno2", ",", " ", "sno3", ",", " ",
                     "sno4", ",", " ", "rayslot", ",", " ", "\n", 
                    "                   ", "oldgenerationnumber", ",", " ", 
                    "intersectionnumber", ",", " ", "pol1", ",", " ", "pol2", 
                    ",", " ", "\n", "                   ", "pol3"}], "}"}], 
                    " ", "=", " ", "#1"}], ";", " ", 
                    RowBox[{"index1", " ", "=", " ", "index"}], ";", " ", 
                    RowBox[{
                    "xunit", " ", "=", " ", "\n", "                  ", 
                    RowBox[{
                    RowBox[{"-", "1."}], "*", "r3"}]}], ";", " ", 
                    RowBox[{"yunit", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"-", "1."}], "*", "r2"}]}], ";", " ", 
                    RowBox[{
                    "zunit", " ", "=", " ", "\n", "                  ", 
                    RowBox[{
                    RowBox[{"-", "1."}], "*", "r1"}]}], ";", " ", 
                    RowBox[{"xunit", " ", "=", " ", 
                    RowBox[{"Chop", "[", "xunit", "]"}]}], ";", " ", 
                    RowBox[{
                    "yunit", " ", "=", " ", "\n", "                  ", 
                    RowBox[{"Chop", "[", "yunit", "]"}]}], ";", " ", 
                    RowBox[{"zunit", " ", "=", " ", 
                    RowBox[{"Chop", "[", "zunit", "]"}]}], ";", " ", 
                    RowBox[{
                    "magnitude", " ", "=", " ", "\n", "                  ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"xunit", "^", "2"}], " ", "+", " ", 
                    RowBox[{"yunit", "^", "2"}], " ", "+", " ", 
                    RowBox[{"zunit", "^", "2"}]}], ")"}], "^", 
                    RowBox[{"2", "^", 
                    RowBox[{"(", 
                    RowBox[{"-", "1"}], ")"}]}]}]}], ";", " ", 
                    RowBox[{
                    "xunit", " ", "=", " ", "\n", "                  ", 
                    RowBox[{"xunit", "/", "magnitude"}]}], ";", " ", 
                    RowBox[{"yunit", " ", "=", " ", 
                    RowBox[{
                    "yunit", "/", "\n", "                   ", 
                    "magnitude"}]}], ";", " ", 
                    RowBox[{"zunit", " ", "=", " ", 
                    RowBox[{"zunit", "/", "magnitude"}]}], ";", " ", "\n", 
                    "                 ", 
                    RowBox[{"rx", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"-", "1."}], "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "75."}], " ", "+", " ", "rez"}], ")"}]}]}], 
                    ";", " ", 
                    RowBox[{"ry", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"-", "1."}], "*", "rey"}]}], ";", " ", "\n", 
                    "                 ", 
                    RowBox[{"rz", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"-", "1."}], "*", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "100."}], " ", "+", " ", "rex"}], ")"}]}]}], 
                    ";", " ", 
                    RowBox[{"rx", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rx", "]"}]}], ";", " ", "\n", 
                    "                 ", 
                    RowBox[{"ry", " ", "=", " ", 
                    RowBox[{"Chop", "[", "ry", "]"}]}], ";", " ", 
                    RowBox[{"rz", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rz", "]"}]}], ";", " ", "\n", 
                    "                 ", 
                    RowBox[{"terminatedeflection", " ", "=", " ", "False"}], 
                    ";", " ", 
                    RowBox[{"intersections", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}], "}"}]}], ";", " ", 
                    RowBox[{
                    "intersections", " ", "=", " ", "\n", 
                    "                  ", "resonateintersections"}], ";", " ", 
                    RowBox[{"holeQ", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"holeQlist", "[", 
                    RowBox[{
                    "[", "\n", "                    ", "resonatenumber", 
                    "]"}], "]"}], " ", "==", " ", "1"}]}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    "newcomponentnumber", ",", " ", "newsurfacenumber", ",", 
                    " ", "\n", "                   ", "newsurfaceid"}], "}"}],
                     " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"2.", ",", " ", "6.", ",", " ", "16603."}], 
                    "}"}]}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"componentnumber", ",", " ", "surfacenumber", ",",
                     " ", "\n", "                   ", "surfaceid"}], "}"}], 
                    " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"2.", ",", " ", "6.", ",", " ", "16603."}], 
                    "}"}]}], ";", " ", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"ray1", ",", " ", "ray2", ",", " ", "ray3"}], 
                    "}"}], " ", "=", " ", "\n", "                  ", 
                    RowBox[{"intersections", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], ";", " ", 
                    RowBox[{"rsx", " ", "=", " ", "rex"}], ";", " ", 
                    RowBox[{
                    "rsy", " ", "=", " ", "\n", "                  ", "rey"}],
                     ";", " ", 
                    RowBox[{"rsz", " ", "=", " ", "rez"}], ";", " ", 
                    RowBox[{"rxhlp", " ", "=", " ", 
                    RowBox[{
                    "rx", " ", "+", " ", "\n", "                   ", 
                    RowBox[{"ray1", "*", "xunit"}]}]}], ";", " ", 
                    RowBox[{"ryhlp", " ", "=", " ", 
                    RowBox[{"ry", " ", "+", " ", 
                    RowBox[{
                    "ray1", "*", "\n", "                    ", "yunit"}]}]}], 
                    ";", " ", 
                    RowBox[{"rzhlp", " ", "=", " ", 
                    RowBox[{"rz", " ", "+", " ", 
                    RowBox[{"ray1", "*", "zunit"}]}]}], ";", " ", "\n", 
                    "                 ", 
                    RowBox[{"rex", " ", "=", " ", 
                    RowBox[{"100.", " ", "-", " ", 
                    RowBox[{"1.", "*", "rzhlp"}]}]}], ";", " ", 
                    RowBox[{"rey", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"-", "1."}], "*", "ryhlp"}]}], ";", " ", "\n", 
                    "                 ", 
                    RowBox[{"rez", " ", "=", " ", 
                    RowBox[{"75.", " ", "-", " ", 
                    RowBox[{"1.", "*", "rxhlp"}]}]}], ";", " ", 
                    RowBox[{"rex", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rex", "]"}]}], ";", " ", "\n", 
                    "                 ", 
                    RowBox[{"rey", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rey", "]"}]}], ";", " ", 
                    RowBox[{"rez", " ", "=", " ", 
                    RowBox[{"Chop", "[", "rez", "]"}]}], ";", " ", "\n", 
                    "                 ", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"rex", " ", "==", " ", "0"}], " ", "&&", " ", 
                    RowBox[{"rey", " ", "==", " ", "0"}], " ", "&&", " ", 
                    RowBox[{"rez", " ", "==", " ", "0"}]}], ",", " ", 
                    RowBox[{
                    RowBox[{
                    "rex", " ", "=", " ", "\n", "                    ", 
                    RowBox[{"100.", " ", "+", " ", "rxhlp"}]}], ";", " ", 
                    RowBox[{"rey", " ", "=", " ", "ryhlp"}], ";", " ", 
                    RowBox[{
                    "rez", " ", "=", " ", "\n", "                    ", 
                    RowBox[{"75.", " ", "+", " ", "rzhlp"}]}]}], ",", " ", 
                    "rex"}], "]"}], ";", " ", 
                    RowBox[{
                    "intersectionnumber", " ", "=", " ", "\n", 
                    "                  ", 
                    RowBox[{"intersectionnumber", " ", "+", " ", "1."}]}], 
                    ";", " ", 
                    RowBox[{"opticallength", " ", "=", " ", 
                    RowBox[{
                    "opticallength", " ", "+", " ", "\n", 
                    "                   ", 
                    RowBox[{"ray1", "*", "index1"}]}]}], ";", " ", 
                    RowBox[{"completedray", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "\n", "                   ", "rsy", ",", 
                    " ", "rsz", ",", " ", "rex", ",", " ", "rey", ",", " ", 
                    "rez", ",", " ", "\n", "                   ", "r1", ",", 
                    " ", "r2", ",", " ", "r3", ",", " ", "r4", ",", " ", "r5",
                     ",", " ", "\n", "                   ", "r6", ",", " ", 
                    "r7", ",", " ", "r8", ",", " ", "r9", ",", " ", 
                    "wavelength", ",", " ", "\n", "                   ", 
                    "intensity", ",", " ", "intensityscale", ",", " ", "ray1",
                     ",", " ", "index", ",", " ", "\n", "                   ",
                     "opticallength", ",", " ", "phaseshift", ",", " ", 
                    "componentnumber", ",", " ", "surfacenumber", ",", " ", 
                    "\n", "                   ", "surfaceid", ",", " ", 
                    "ray2", ",", " ", "ray3", ",", " ", "sid", ",", " ", 
                    "frontid", ",", " ", "\n", "                   ", "sno1", 
                    ",", " ", "sno2", ",", " ", "sno3", ",", " ", "sno4", ",",
                     " ", "rayslot", ",", " ", "\n", "                   ", 
                    "generationnumber", ",", " ", "intersectionnumber", ",", 
                    " ", "pol1", ",", " ", "pol2", ",", " ", "\n", 
                    "                   ", "pol3"}], "}"}]}], ";", " ", 
                    RowBox[{"reportedrayspresent", " ", "=", " ", "True"}], 
                    ";", " ", 
                    RowBox[{"intersectionspresent", " ", "=", " ", "True"}], 
                    ";", " ", "\n", "                 ", 
                    RowBox[{"deflectedrayspresent", " ", "=", " ", "True"}], 
                    ";", " ", 
                    RowBox[{
                    "localdummyoutrayspresent", " ", "=", " ", "True"}], ";", 
                    " ", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    "surfnorm", " ", "=", " ", "\n", "                   ", 
                    RowBox[{"1.", "*", 
                    RowBox[{"Re", "[", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"1", ",", " ", "0", ",", " ", "0"}], "}"}], ",", 
                    " ", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", " ", "1", ",", " ", "0"}], "}"}], ",", 
                    " ", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", " ", "0", ",", " ", "1"}], "}"}]}], 
                    "}"}], "]"}]}]}], ";", " ", 
                    RowBox[{"dummymatrix", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", "0.", ",", " ", 
                    RowBox[{"-", "1."}]}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0.", ",", " ", 
                    RowBox[{"-", "1."}], ",", " ", "0."}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0.", ",", " ", "0."}], 
                    "}"}]}], "}"}], " ", ".", " ", "#1"}], " ", "&"}], " ", 
                    ")"}], " ", "/@", " ", "\n", "                    ", 
                    "surfnorm"}]}], ";", " ", 
                    RowBox[{"surfnorm", " ", "=", " ", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"#1", "/", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"#1", " ", ".", " ", "#1"}], "]"}]}], " ", "&"}], 
                    " ", ")"}], " ", "/@", " ", "dummymatrix"}]}], ";", " ", 
                    "\n", "                  ", 
                    RowBox[{"surfacerotationmatrix", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0", ",", " ", "0", ",", " ", 
                    RowBox[{"-", "1."}]}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", " ", 
                    RowBox[{"-", "1."}], ",", " ", "0"}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1."}], ",", " ", "0", ",", " ", "0"}], 
                    "}"}]}], "}"}]}], ";", " ", 
                    RowBox[{
                    "surfacetranslationvector", " ", "=", " ", "\n", 
                    "                   ", 
                    RowBox[{"{", 
                    RowBox[{"100.", ",", " ", "0", ",", " ", "75."}], "}"}]}],
                     ";", " ", 
                    RowBox[{"activeregion", " ", "=", " ", "0."}], ";", " ", 
                    RowBox[{"completedray", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "\n", "                    ", "rsy", ",",
                     " ", "rsz", ",", " ", "rex", ",", " ", "rey", ",", " ", 
                    "rez", ",", " ", "\n", "                    ", "r1", ",", 
                    " ", "r2", ",", " ", "r3", ",", " ", "r4", ",", " ", "r5",
                     ",", " ", "\n", "                    ", "r6", ",", " ", 
                    "r7", ",", " ", "r8", ",", " ", "r9", ",", " ", 
                    "wavelength", ",", " ", "\n", "                    ", 
                    "intensity", ",", " ", "intensityscale", ",", " ", "ray1",
                     ",", " ", "index", ",", " ", "\n", 
                    "                    ", "opticallength", ",", " ", 
                    "phaseshift", ",", " ", "componentnumber", ",", " ", "\n",
                     "                    ", "surfacenumber", ",", " ", 
                    "surfaceid", ",", " ", "ray2", ",", " ", "ray3", ",", " ",
                     "\n", "                    ", "sid", ",", " ", "frontid",
                     ",", " ", "sno1", ",", " ", "sno2", ",", " ", "sno3", 
                    ",", " ", "\n", "                    ", "sno4", ",", " ", 
                    "rayslot", ",", " ", "generationnumber", ",", " ", 
                    "intersectionnumber", ",", " ", "\n", 
                    "                    ", "pol1", ",", " ", "pol2", ",", 
                    " ", "pol3"}], "}"}]}], ";", " ", 
                    RowBox[{
                    "componentnumber", " ", "=", " ", "\n", 
                    "                   ", "newcomponentnumber"}], ";", " ", 
                    RowBox[{
                    "surfacenumber", " ", "=", " ", "newsurfacenumber"}], ";",
                     " ", "\n", "                  ", 
                    RowBox[{"surfaceid", " ", "=", " ", "newsurfaceid"}], ";",
                     " ", 
                    RowBox[{"originalray", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "\n", "                    ", "rsy", ",",
                     " ", "rsz", ",", " ", "rex", ",", " ", "rey", ",", " ", 
                    "rez", ",", " ", "\n", "                    ", "r1", ",", 
                    " ", "r2", ",", " ", "r3", ",", " ", "r4", ",", " ", "r5",
                     ",", " ", "\n", "                    ", "r6", ",", " ", 
                    "r7", ",", " ", "r8", ",", " ", "r9", ",", " ", 
                    "wavelength", ",", " ", "\n", "                    ", 
                    "intensity", ",", " ", "intensityscale", ",", " ", "ray1",
                     ",", " ", "index", ",", " ", "\n", 
                    "                    ", "opticallength", ",", " ", 
                    "phaseshift", ",", " ", "componentnumber", ",", " ", "\n",
                     "                    ", "surfacenumber", ",", " ", 
                    "surfaceid", ",", " ", "ray2", ",", " ", "ray3", ",", " ",
                     "\n", "                    ", "sid", ",", " ", "frontid",
                     ",", " ", "sno1", ",", " ", "sno2", ",", " ", "sno3", 
                    ",", " ", "\n", "                    ", "sno4", ",", " ", 
                    "rayslot", ",", " ", "generationnumber", ",", " ", 
                    "intersectionnumber", ",", " ", "\n", 
                    "                    ", "pol1", ",", " ", "pol2", ",", 
                    " ", "pol3"}], "}"}]}], ";", " ", 
                    RowBox[{"intensity", " ", "=", " ", "0."}], ";", " ", 
                    "\n", "                  ", 
                    RowBox[{"allcreatedrays", " ", "=", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "\n", 
                    "                     ", "rex", ",", " ", "rey", ",", " ",
                     "rez", ",", " ", "r1", ",", " ", "r2", ",", " ", "\n", 
                    "                     ", "r3", ",", " ", "r4", ",", " ", 
                    "r5", ",", " ", "r6", ",", " ", "r7", ",", " ", "\n", 
                    "                     ", "r8", ",", " ", "r9", ",", " ", 
                    "wavelength", ",", " ", "intensity", ",", " ", "\n", 
                    "                     ", "intensityscale", ",", " ", 
                    "ray1", ",", " ", "index", ",", " ", "opticallength", ",",
                     " ", "\n", "                     ", "phaseshift", ",", 
                    " ", "componentnumber", ",", " ", "surfacenumber", ",", 
                    " ", "surfaceid", ",", " ", "\n", "                     ",
                     "ray2", ",", " ", "ray3", ",", " ", "sid", ",", " ", 
                    "frontid", ",", " ", "sno1", ",", " ", "\n", 
                    "                     ", "sno2", ",", " ", "sno3", ",", 
                    " ", "sno4", ",", " ", "rayslot", ",", " ", "\n", 
                    "                     ", "generationnumber", ",", " ", 
                    "intersectionnumber", ",", " ", "pol1", ",", " ", "pol2", 
                    ",", " ", "\n", "                     ", "pol3"}], "}"}], 
                    "}"}]}]}], ")"}], ";", " ", 
                    RowBox[{"{", 
                    RowBox[{"allcreatedrays", ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",",
                     " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", 
                    "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",",
                     " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", 
                    "1.", ",", " ", "1.", ",", " ", "\n", 
                    "                    ", 
                    RowBox[{"-", "1.7976931348623157*^308"}], ",", " ", "1.", 
                    ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", 
                    "0.", ",", " ", 
                    RowBox[{"-", "1."}], ",", " ", 
                    RowBox[{"-", "1."}], ",", " ", 
                    RowBox[{"-", "1."}], ",", " ", "1.", ",", " ", "1.", ",", 
                    " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.",
                     ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ",
                     "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", 
                    ",", " ", "1."}], "}"}], "}"}], ",", " ", "\n", 
                    "                  ", 
                    RowBox[{"{", "completedray", "}"}]}], "}"}]}], ",", " ", 
                    "True", ",", " ", 
                    RowBox[{
                    RowBox[{
                    "deflecteddummyrayspresent", " ", "=", " ", "True"}], ";",
                     " ", "\n", "                 ", 
                    RowBox[{
                    "reporteddummyrayspresent", " ", "=", " ", "True"}], ";", 
                    " ", 
                    RowBox[{"localoutrayspresent", " ", "=", " ", "True"}], 
                    ";", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",",
                     " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", 
                    "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "\n", 
                    "                    ", "1.", ",", " ", "1.", ",", " ", 
                    "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",",
                     " ", 
                    RowBox[{"-", "1.7976931348623157*^308"}], ",", " ", "1.", 
                    ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", 
                    "0.", ",", " ", 
                    RowBox[{"-", "1."}], ",", " ", 
                    RowBox[{"-", "1."}], ",", " ", 
                    RowBox[{"-", "1."}], ",", " ", "1.", ",", " ", "1.", ",", 
                    " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.",
                     ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ",
                     "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", 
                    ",", " ", "1."}], "}"}], "}"}], ",", " ", "\n", 
                    "                  ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    "rsx", ",", " ", "rsy", ",", " ", "rsz", ",", " ", "rex", 
                    ",", " ", "rey", ",", " ", "\n", "                    ", 
                    "rez", ",", " ", "r1", ",", " ", "r2", ",", " ", "r3", 
                    ",", " ", "r4", ",", " ", "\n", "                    ", 
                    "r5", ",", " ", "r6", ",", " ", "r7", ",", " ", "r8", ",",
                     " ", "r9", ",", " ", "\n", "                    ", 
                    "wavelength", ",", " ", "intensity", ",", " ", 
                    "intensityscale", ",", " ", "ray1", ",", " ", "\n", 
                    "                    ", "index", ",", " ", 
                    "opticallength", ",", " ", "phaseshift", ",", " ", 
                    "componentnumber", ",", " ", "\n", "                    ",
                     "surfacenumber", ",", " ", "surfaceid", ",", " ", "ray2",
                     ",", " ", "ray3", ",", " ", "\n", "                    ",
                     "sid", ",", " ", "frontid", ",", " ", "sno1", ",", " ", 
                    "sno2", ",", " ", "sno3", ",", " ", "\n", 
                    "                    ", "sno4", ",", " ", "rayslot", ",", 
                    " ", "generationnumber", ",", " ", "intersectionnumber", 
                    ",", " ", "\n", "                    ", "pol1", ",", " ", 
                    "pol2", ",", " ", "pol3"}], "}"}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",",
                     " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", 
                    "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",",
                     " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", 
                    "\n", "                    ", "1.", ",", " ", "1.", ",", 
                    " ", 
                    RowBox[{"-", "1.7976931348623157*^308"}], ",", " ", "1.", 
                    ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", 
                    "0.", ",", " ", 
                    RowBox[{"-", "1."}], ",", " ", 
                    RowBox[{"-", "1."}], ",", " ", 
                    RowBox[{"-", "1."}], ",", " ", "1.", ",", " ", "1.", ",", 
                    " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.",
                     ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ",
                     "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", 
                    ",", " ", "1."}], "}"}], "}"}]}], "}"}]}]}], "]"}]}], ",",
                     " ", "\n", "              ", 
                    RowBox[{
                    RowBox[{
                    "deflecteddummyrayspresent", " ", "=", " ", "True"}], ";",
                     " ", 
                    RowBox[{
                    "reporteddummyrayspresent", " ", "=", " ", "True"}], ";", 
                    " ", "\n", "               ", 
                    RowBox[{
                    "localdummyoutrayspresent", " ", "=", " ", "True"}], ";", 
                    " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",",
                     " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", 
                    "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",",
                     " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", 
                    "1.", ",", " ", "1.", ",", " ", 
                    RowBox[{"-", "1.7976931348623157*^308"}], ",", " ", "\n", 
                    "                  ", "1.", ",", " ", "1.", ",", " ", 
                    "1.", ",", " ", "1.", ",", " ", "0.", ",", " ", 
                    RowBox[{"-", "1."}], ",", " ", 
                    RowBox[{"-", "1."}], ",", " ", 
                    RowBox[{"-", "1."}], ",", " ", "1.", ",", " ", "1.", ",", 
                    " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.",
                     ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ",
                     "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", 
                    ",", " ", "1."}], "}"}], "}"}], ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",",
                     " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", 
                    "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",",
                     " ", "1.", ",", " ", "1.", ",", " ", "\n", 
                    "                  ", "1.", ",", " ", "1.", ",", " ", 
                    "1.", ",", " ", 
                    RowBox[{"-", "1.7976931348623157*^308"}], ",", " ", "1.", 
                    ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", 
                    "0.", ",", " ", 
                    RowBox[{"-", "1."}], ",", " ", 
                    RowBox[{"-", "1."}], ",", " ", 
                    RowBox[{"-", "1."}], ",", " ", "1.", ",", " ", "1.", ",", 
                    " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.",
                     ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ",
                     "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", 
                    ",", " ", "1."}], "}"}], "}"}], ",", " ", "\n", 
                    "                ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",",
                     " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", 
                    "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",",
                     " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", 
                    "1.", ",", " ", "1.", ",", " ", 
                    RowBox[{"-", "1.7976931348623157*^308"}], ",", " ", "1.", 
                    ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", 
                    "0.", ",", " ", 
                    RowBox[{"-", "1."}], ",", " ", 
                    RowBox[{"-", "1."}], ",", " ", 
                    RowBox[{"-", "1."}], ",", " ", "1.", ",", " ", "1.", ",", 
                    " ", "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "\n",
                     "                  ", "1.", ",", " ", "1.", ",", " ", 
                    "1.", ",", " ", "1.", ",", " ", "1.", ",", " ", "1.", ",",
                     " ", "1.", ",", " ", "1.", ",", " ", "1."}], "}"}], 
                    "}"}]}], "}"}]}]}], "]"}]}], ")"}], " ", "&"}], " ", 
                    ")"}], " ", "/@", " ", "inrays"}], "]"}]}]}], ";", " ", 
                   "\n", "       ", 
                   RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    "deflectedrayspresent", " ", "&&", " ", 
                    "deflecteddummyrayspresent"}], ",", " ", 
                    RowBox[{
                    "deflectedlocalrays", " ", "=", " ", "\n", "         ", 
                    RowBox[{
                    RowBox[{"Select", "[", 
                    RowBox[{"deflectedlocalrays", ",", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"#1", "[", 
                    RowBox[{"[", "23", "]"}], "]"}], " ", ">", " ", "0."}], 
                    " ", "&"}]}], " ", "]"}], "*", "1."}]}], ",", " ", "1."}],
                     "]"}], ";", " ", 
                   RowBox[{"If", "[", 
                    RowBox[{"localoutrayspresent", ",", " ", "\n", "        ", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{"localdummyoutrayspresent", ",", " ", 
                    RowBox[{
                    RowBox[{"localoutrays", " ", "=", " ", 
                    RowBox[{"Select", "[", 
                    RowBox[{"localoutrays", ",", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"#1", "[", 
                    RowBox[{"[", "23", "]"}], "]"}], " ", ">", " ", "0."}], 
                    " ", "&"}]}], " ", "]"}]}], ";", " ", "1."}], ",", " ", 
                    "\n", "          ", "1."}], "]"}], ";", " ", 
                    RowBox[{"outrays", " ", "=", " ", 
                    RowBox[{"Join", "[", 
                    RowBox[{"outrays", ",", " ", "localoutrays"}], "]"}]}], 
                    ";", " ", "1."}], ",", " ", "1."}], "]"}], ";", " ", "\n",
                    "       ", 
                   RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    "reportedrayspresent", " ", "&&", " ", 
                    "reporteddummyrayspresent"}], ",", " ", "\n", "        ", 
                    
                    RowBox[{
                    RowBox[{"reportedlocalrays", " ", "=", " ", 
                    RowBox[{"Select", "[", 
                    RowBox[{"reportedlocalrays", ",", " ", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"#1", "[", 
                    RowBox[{"[", "23", "]"}], "]"}], " ", ">", " ", "0."}], 
                    " ", "&"}]}], " ", "]"}]}], ";", " ", "1."}], ",", " ", 
                    "1."}], "]"}]}], ")"}], ";", " ", "\n", "      ", 
                 RowBox[{"If", "[", 
                  RowBox[{"reportedrayspresent", ",", " ", 
                   RowBox[{
                    RowBox[{"raysreported", " ", "=", " ", "True"}], ";", " ", 
                    RowBox[{
                    "reportedrays", " ", "=", " ", "\n", "         ", 
                    RowBox[{"Join", "[", 
                    RowBox[{"reportedrays", ",", " ", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"-", "1.7976931348623157*^308"}], ",", " ", 
                    RowBox[{"-", "1.7976931348623157*^308"}], ",", " ", 
                    RowBox[{"-", "1.7976931348623157*^308"}], ",", " ", 
                    RowBox[{"-", "1.7976931348623157*^308"}], ",", " ", "\n", 
                    "            ", 
                    RowBox[{"-", "1.7976931348623157*^308"}], ",", " ", 
                    RowBox[{"-", "1.7976931348623157*^308"}], ",", " ", 
                    RowBox[{"-", "1.7976931348623157*^308"}], ",", " ", 
                    RowBox[{"-", "1.7976931348623157*^308"}], ",", " ", 
                    RowBox[{"-", "1.7976931348623157*^308"}], ",", " ", "\n", 
                    "            ", 
                    RowBox[{"-", "1.7976931348623157*^308"}], ",", " ", 
                    RowBox[{"-", "1.7976931348623157*^308"}], ",", " ", 
                    RowBox[{"-", "1.7976931348623157*^308"}], ",", " ", 
                    RowBox[{"-", "1.7976931348623157*^308"}], ",", " ", 
                    RowBox[{"-", "1.7976931348623157*^308"}], ",", " ", "\n", 
                    "            ", 
                    RowBox[{"-", "1.7976931348623157*^308"}], ",", " ", 
                    RowBox[{"-", "1.7976931348623157*^308"}], ",", " ", 
                    RowBox[{"-", "1.7976931348623157*^308"}], ",", " ", 
                    RowBox[{"-", "1.7976931348623157*^308"}], ",", " ", 
                    RowBox[{"-", "1.7976931348623157*^308"}], ",", " ", "\n", 
                    "            ", 
                    RowBox[{"-", "1.7976931348623157*^308"}], ",", " ", 
                    RowBox[{"-", "1.7976931348623157*^308"}], ",", " ", 
                    RowBox[{"-", "1.7976931348623157*^308"}], ",", " ", 
                    RowBox[{"-", "1.7976931348623157*^308"}], ",", " ", 
                    RowBox[{"-", "1.7976931348623157*^308"}], ",", " ", "\n", 
                    "            ", 
                    RowBox[{"-", "1.7976931348623157*^308"}], ",", " ", 
                    RowBox[{"-", "1.7976931348623157*^308"}], ",", " ", 
                    RowBox[{"-", "1.7976931348623157*^308"}], ",", " ", 
                    RowBox[{"-", "1.7976931348623157*^308"}], ",", " ", 
                    RowBox[{"-", "1.7976931348623157*^308"}], ",", " ", "\n", 
                    "            ", 
                    RowBox[{"-", "1.7976931348623157*^308"}], ",", " ", 
                    RowBox[{"-", "1.7976931348623157*^308"}], ",", " ", 
                    RowBox[{"-", "1.7976931348623157*^308"}], ",", " ", 
                    RowBox[{"-", "1.7976931348623157*^308"}], ",", " ", 
                    RowBox[{"-", "1.7976931348623157*^308"}], ",", " ", "\n", 
                    "            ", 
                    RowBox[{"-", "1.7976931348623157*^308"}], ",", " ", 
                    RowBox[{"-", "1.7976931348623157*^308"}], ",", " ", 
                    RowBox[{"-", "1.7976931348623157*^308"}], ",", " ", 
                    RowBox[{"-", "1.7976931348623157*^308"}], ",", " ", 
                    RowBox[{"-", "1.7976931348623157*^308"}]}], "}"}], "}"}], 
                    ",", " ", "\n", "          ", "reportedlocalrays"}], 
                    "]"}]}], ";", " ", "1."}], ",", " ", "1."}], "]"}], ";", 
                 " ", 
                 RowBox[{"inrays", " ", "=", " ", "deflectedlocalrays"}], ";",
                  " ", "\n", "      ", 
                 RowBox[{"propagate", " ", "=", " ", 
                  RowBox[{
                  "generationnumber", " ", "<", " ", 
                   "generationlimit"}]}]}]}], "]"}], ";", " ", "\n", "    ", 
              RowBox[{"propagatedrays", " ", "=", " ", 
               RowBox[{"If", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"Length", "[", "outrays", "]"}], " ", ">", " ", 
                  "1"}], ",", " ", 
                 RowBox[{"Drop", "[", 
                  RowBox[{"outrays", ",", " ", "1"}], "]"}], ",", " ", 
                 "outrays"}], "]"}]}], ";", " ", "\n", "    ", 
              RowBox[{"If", "[", 
               RowBox[{
                RowBox[{
                 RowBox[{
                 "generationnumber", " ", ">=", " ", "generationlimit"}], " ",
                  "&&", " ", "deflectedrayspresent"}], ",", " ", "\n", 
                "     ", 
                RowBox[{
                 RowBox[{"propagatedrays", " ", "=", " ", 
                  RowBox[{"Join", "[", 
                   RowBox[{"propagatedrays", ",", " ", "deflectedlocalrays"}],
                    "]"}]}], ";", " ", "1."}], ",", " ", "1."}], "]"}]}], 
             ")"}], ";", " ", "\n", "   ", 
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"Length", "[", "reportedrays", "]"}], " ", ">", " ", 
               "2"}], ",", " ", 
              RowBox[{"reportedrays", " ", "=", " ", 
               RowBox[{"Drop", "[", 
                RowBox[{"reportedrays", ",", " ", "2"}], "]"}]}], ",", " ", 
              "\n", "    ", "reportedrays"}], "]"}], ";", " ", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"#1", "[", 
                  RowBox[{"[", "1", "]"}], "]"}], ",", " ", 
                 RowBox[{"#1", "[", 
                  RowBox[{"[", "2", "]"}], "]"}], ",", " ", 
                 RowBox[{"#1", "[", 
                  RowBox[{"[", "3", "]"}], "]"}], ",", " ", 
                 RowBox[{"#1", "[", 
                  RowBox[{"[", "4", "]"}], "]"}], ",", " ", 
                 RowBox[{"#1", "[", 
                  RowBox[{"[", "5", "]"}], "]"}], ",", " ", 
                 RowBox[{"#1", "[", 
                  RowBox[{"[", "6", "]"}], "]"}]}], "}"}], " ", "&"}], " ", 
              ")"}], " ", "/@", " ", "reportedrays"}]}]}], "]"}]}], "]"}]}], 
      ";", "\n", 
      RowBox[{"(*", "Surfaces", "*)"}], "\n", 
      RowBox[{
       RowBox[{"rot", "[", 
        RowBox[{"pt_", ",", "a_", ",", "cen_"}], "]"}], ":=", 
       RowBox[{"cen", "+", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"Cos", "[", 
              RowBox[{"-", "a"}], "]"}], ",", 
             RowBox[{"Sin", "[", 
              RowBox[{"-", "a"}], "]"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"-", 
              RowBox[{"Sin", "[", 
               RowBox[{"-", "a"}], "]"}]}], ",", 
             RowBox[{"Cos", "[", 
              RowBox[{"-", "a"}], "]"}]}], "}"}]}], "}"}], ".", 
         RowBox[{"(", 
          RowBox[{"pt", "-", "cen"}], ")"}]}]}]}], ";", "\n", 
      RowBox[{
       RowBox[{"surface", "[", 
        RowBox[{
        "r1_", ",", "r2_", ",", "ap_", ",", "x_", ",", "t_", ",", "y_"}], 
        "]"}], ":=", 
       RowBox[{"Join", "[", 
        RowBox[{
         RowBox[{"Table", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{"r1", "+", "x", "-", 
              RowBox[{
               RowBox[{"Sqrt", "[", 
                RowBox[{
                 RowBox[{"r1", "^", "2"}], "-", 
                 RowBox[{"yy", "^", "2"}]}], "]"}], "*", 
               RowBox[{"Sign", "[", "r1", "]"}]}]}], ",", 
             RowBox[{"y", "+", "yy"}]}], "}"}], " ", ",", 
           RowBox[{"{", 
            RowBox[{"yy", ",", 
             RowBox[{
              RowBox[{"-", "ap"}], "/", "2"}], ",", 
             RowBox[{"ap", "/", "2"}], ",", 
             RowBox[{"ap", "/", "20"}]}], "}"}]}], "]"}], ",", 
         RowBox[{"Reverse", "[", 
          RowBox[{"Table", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"r2", "+", "x", "+", "t", "-", 
               RowBox[{
                RowBox[{"Sqrt", "[", 
                 RowBox[{
                  RowBox[{"r2", "^", "2"}], "-", 
                  RowBox[{"yy", "^", "2"}]}], "]"}], "*", 
                RowBox[{"Sign", "[", "r2", "]"}]}]}], ",", 
              RowBox[{"y", "+", "yy"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"yy", ",", 
              RowBox[{
               RowBox[{"-", "ap"}], "/", "2"}], ",", 
              RowBox[{"ap", "/", "2"}], ",", 
              RowBox[{"ap", "/", "20"}]}], "}"}]}], "]"}], "]"}]}], "]"}]}], 
      ";", "\n", 
      RowBox[{
       RowBox[{"system", "[", 
        RowBox[{
        "as1_", ",", "as2_", ",", "wl1_", ",", "wl2_", ",", "xs1_", ",", 
         "xs2_", ",", "ys1_", ",", "ys2_", ",", "aa_", ",", "ab_", ",", 
         "apa_", ",", "apb_", ",", "ca1_", ",", "ca2_", ",", "cb1_", ",", 
         "cb2_", ",", "ta_", ",", "tb_", ",", "xa1_", ",", "xb1_", ",", 
         "ya1_", ",", "yb1_"}], "]"}], ":=", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"micronsToColor", "[", "wl1", "]"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{"wl1", "<", ".380"}], ")"}], "||", 
            RowBox[{"(", 
             RowBox[{"wl1", ">", ".780"}], ")"}]}], ",", 
           RowBox[{"AbsoluteDashing", "[", 
            RowBox[{"{", 
             RowBox[{"3", ",", "3"}], "}"}], "]"}], ",", 
           RowBox[{"Dashing", "[", 
            RowBox[{"{", "}"}], "]"}]}], "]"}], ",", 
         RowBox[{"Line", "[", 
          RowBox[{"Map", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"#", "[", 
                RowBox[{"[", 
                 RowBox[{"{", 
                  RowBox[{"1", ",", "2"}], "}"}], "]"}], "]"}], ",", 
               RowBox[{"#", "[", 
                RowBox[{"[", 
                 RowBox[{"{", 
                  RowBox[{"4", ",", "5"}], "}"}], "]"}], "]"}]}], "}"}], 
             "&"}], ",", 
            RowBox[{"rayfunction", "[", 
             RowBox[{
             "as1", ",", "wl1", ",", "xs1", ",", "ys1", ",", "aa", ",", "ab", 
              ",", "apa", ",", "apb", ",", "ca1", ",", "ca2", ",", "cb1", ",",
               "cb2", ",", "ta", ",", "tb", ",", "xa1", ",", "xb1", ",", 
              "ya1", ",", "yb1"}], "]"}]}], "]"}], "]"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"micronsToColor", "[", "wl2", "]"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{"wl2", "<", ".380"}], ")"}], "||", 
            RowBox[{"(", 
             RowBox[{"wl2", ">", ".780"}], ")"}]}], ",", 
           RowBox[{"AbsoluteDashing", "[", 
            RowBox[{"{", 
             RowBox[{"3", ",", "3"}], "}"}], "]"}], ",", 
           RowBox[{"Dashing", "[", 
            RowBox[{"{", "}"}], "]"}]}], "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"Line", "[", 
          RowBox[{"Map", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"#", "[", 
                RowBox[{"[", 
                 RowBox[{"{", 
                  RowBox[{"1", ",", "2"}], "}"}], "]"}], "]"}], ",", 
               RowBox[{"#", "[", 
                RowBox[{"[", 
                 RowBox[{"{", 
                  RowBox[{"4", ",", "5"}], "}"}], "]"}], "]"}]}], "}"}], 
             "&"}], ",", 
            RowBox[{"rayfunction", "[", 
             RowBox[{
             "as2", ",", "wl2", ",", "xs2", ",", "ys2", ",", "aa", ",", "ab", 
              ",", "apa", ",", "apb", ",", "ca1", ",", "ca2", ",", "cb1", ",",
               "cb2", ",", "ta", ",", "tb", ",", "xa1", ",", "xb1", ",", 
              "ya1", ",", "yb1"}], "]"}]}], "]"}], "]"}]}], "}"}]}], ";", 
      "\n", 
      RowBox[{"locatorSize", "=", "10"}], ";", "\n", 
      RowBox[{"locatorDot", "=", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Lighter", "[", "Blue", "]"}], ",", 
         RowBox[{"Disk", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", "0"}], "}"}], ",", ".5"}], "]"}]}], "}"}]}], 
      ";", "\n", 
      RowBox[{"locatorMaster", "=", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Lighter", "[", "Red", "]"}], ",", 
         RowBox[{"Disk", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", "0"}], "}"}], ",", ".8"}], "]"}]}], "}"}]}], 
      ";", "\n", 
      RowBox[{"locatorLeftRight", "=", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Lighter", "[", "Blue", "]"}], ",", 
         RowBox[{"AbsoluteThickness", "[", "2", "]"}], ",", 
         RowBox[{"Arrowheads", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{".5", ",", "1"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"-", ".5"}], ",", "0"}], "}"}]}], "}"}], "]"}], ",", 
         RowBox[{"Arrow", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"1", ",", "0"}], "}"}]}], "}"}], "]"}]}], "}"}]}], ";", 
      "\n", 
      RowBox[{"locatorUpDown", "=", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Lighter", "[", "Blue", "]"}], ",", 
         RowBox[{"AbsoluteThickness", "[", "2", "]"}], ",", 
         RowBox[{"Arrowheads", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{".5", ",", "1"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"-", ".5"}], ",", "0"}], "}"}]}], "}"}], "]"}], ",", 
         RowBox[{"Arrow", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"0", ",", 
              RowBox[{"-", "1"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"0", ",", "1"}], "}"}]}], "}"}], "]"}]}], "}"}]}], ";", 
      "\n", 
      RowBox[{"locatorAll", "=", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Lighter", "[", "Blue", "]"}], ",", 
         RowBox[{"AbsoluteThickness", "[", "2", "]"}], ",", 
         RowBox[{"Arrowheads", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{".5", ",", "1"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"-", ".5"}], ",", "0"}], "}"}]}], "}"}], "]"}], ",", 
         RowBox[{"Arrow", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"1", ",", "0"}], "}"}]}], "}"}], "]"}], ",", 
         RowBox[{"Arrow", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"0", ",", 
              RowBox[{"-", "1"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"0", ",", "1"}], "}"}]}], "}"}], "]"}]}], "}"}]}], ";", 
      "\n", 
      RowBox[{"locatorLeftRight", "=", 
       RowBox[{"locatorUpDown", "=", 
        RowBox[{"locatorAll", "=", "locatorDot"}]}]}], ";", "\n", 
      RowBox[{
       RowBox[{"lensWithControls", "[", 
        RowBox[{
         RowBox[{"Dynamic", "[", "r1_", "]"}], ",", 
         RowBox[{"Dynamic", "[", "r2_", "]"}], ",", 
         RowBox[{"Dynamic", "[", "a_", "]"}], ",", 
         RowBox[{"Dynamic", "[", "ap_", "]"}], ",", 
         RowBox[{"Dynamic", "[", "x_", "]"}], ",", 
         RowBox[{"Dynamic", "[", "t_", "]"}], ",", 
         RowBox[{"Dynamic", "[", "y_", "]"}]}], "]"}], ":=", 
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"Dynamic", "[", 
          RowBox[{"Rotate", "[", 
           RowBox[{
            RowBox[{"Polygon", "[", 
             RowBox[{"surface", "[", 
              RowBox[{
               RowBox[{"1", "/", "r1"}], ",", 
               RowBox[{"1", "/", "r2"}], ",", "ap", ",", "x", ",", "t", ",", 
               "y"}], "]"}], "]"}], ",", "a", ",", 
            RowBox[{"{", 
             RowBox[{"x", ",", "y"}], "}"}]}], "]"}], "]"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"Locator", "[", 
          RowBox[{
           RowBox[{"Dynamic", "[", 
            RowBox[{"{", 
             RowBox[{"x", ",", "y"}], "}"}], "]"}], ",", 
           RowBox[{"Graphics", "[", 
            RowBox[{"locatorMaster", ",", 
             RowBox[{"ImageSize", "\[Rule]", "locatorSize"}]}], "]"}]}], 
          "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"Locator", "[", 
          RowBox[{
           RowBox[{"Dynamic", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"{", 
               RowBox[{"x", ",", "y"}], "}"}], "+", 
              RowBox[{"5", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"Cos", "[", "a", "]"}], ",", 
                 RowBox[{"Sin", "[", "a", "]"}]}], "}"}]}]}], ",", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"a", "=", 
                RowBox[{"Apply", "[", 
                 RowBox[{"ArcTan", ",", 
                  RowBox[{"#", "-", 
                   RowBox[{"{", 
                    RowBox[{"x", ",", "y"}], "}"}]}]}], "]"}]}], ")"}], 
              "&"}]}], "]"}], ",", 
           RowBox[{"Graphics", "[", 
            RowBox[{"locatorDot", ",", 
             RowBox[{"ImageSize", "\[Rule]", "locatorSize"}]}], "]"}]}], 
          "]"}], ",", "\[IndentingNewLine]", "\[IndentingNewLine]", 
         RowBox[{"Locator", "[", 
          RowBox[{
           RowBox[{"Dynamic", "[", 
            RowBox[{
             RowBox[{"rot", "[", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"x", "+", "t"}], ",", "y"}], "}"}], ",", "a", ",", 
               RowBox[{"{", 
                RowBox[{"x", ",", "y"}], "}"}]}], "]"}], ",", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"t", "=", 
                RowBox[{
                 RowBox[{"First", "[", 
                  RowBox[{"rot", "[", 
                   RowBox[{"#", ",", 
                    RowBox[{"-", "a"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"x", ",", "y"}], "}"}]}], "]"}], "]"}], "-", 
                 "x"}]}], ")"}], "&"}]}], "]"}], ",", 
           RowBox[{"Graphics", "[", 
            RowBox[{"locatorLeftRight", ",", 
             RowBox[{"ImageSize", "\[Rule]", "locatorSize"}]}], "]"}]}], 
          "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"Locator", "[", 
          RowBox[{
           RowBox[{"Dynamic", "[", 
            RowBox[{
             RowBox[{"rot", "[", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"1", "/", "r1"}], "+", "x", "-", 
                    RowBox[{
                    RowBox[{"Sqrt", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "/", "r1"}], ")"}], "^", "2"}], "-", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"ap", "/", "2"}], ")"}], "^", "2"}]}], "]"}], "*", 
                    RowBox[{"Sign", "[", 
                    RowBox[{"1", "/", "r1"}], "]"}]}]}], ")"}], "+", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"1", "/", "r2"}], "+", "x", "-", 
                    RowBox[{
                    RowBox[{"Sqrt", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "/", "r2"}], ")"}], "^", "2"}], "-", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"ap", "/", "2"}], ")"}], "^", "2"}]}], "]"}], "*", 
                    RowBox[{"Sign", "[", 
                    RowBox[{"1", "/", "r2"}], "]"}]}], "+", "t"}], ")"}]}], 
                   ")"}], "/", "2"}], ",", 
                 RowBox[{"y", "-", 
                  RowBox[{"ap", "/", "2"}]}]}], "}"}], ",", "a", ",", 
               RowBox[{"{", 
                RowBox[{"x", ",", "y"}], "}"}]}], "]"}], ",", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"ap", "=", 
                RowBox[{"2", 
                 RowBox[{"(", 
                  RowBox[{"y", "-", 
                   RowBox[{"Last", "[", 
                    RowBox[{"rot", "[", 
                    RowBox[{"#", ",", 
                    RowBox[{"-", "a"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"x", ",", "y"}], "}"}]}], "]"}], "]"}]}], 
                  ")"}]}]}], ")"}], "&"}]}], "]"}], ",", 
           RowBox[{"Graphics", "[", 
            RowBox[{"locatorUpDown", ",", 
             RowBox[{"ImageSize", "\[Rule]", "locatorSize"}]}], "]"}]}], 
          "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"Locator", "[", 
          RowBox[{
           RowBox[{"Dynamic", "[", 
            RowBox[{
             RowBox[{"rot", "[", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                 RowBox[{
                  RowBox[{"1", "/", "r1"}], "+", "x", "-", 
                  RowBox[{
                   RowBox[{"Sqrt", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "/", "r1"}], ")"}], "^", "2"}], "-", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"ap", "/", "2"}], ")"}], "^", "2"}]}], "]"}], "*", 
                   RowBox[{"Sign", "[", 
                    RowBox[{"1", "/", "r1"}], "]"}]}]}], ",", 
                 RowBox[{"y", "+", 
                  RowBox[{"ap", "/", "2"}]}]}], "}"}], ",", "a", ",", 
               RowBox[{"{", 
                RowBox[{"x", ",", "y"}], "}"}]}], "]"}], ",", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"r1", "=", 
                RowBox[{"With", "[", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{"c", "=", 
                    RowBox[{"First", "[", 
                    RowBox[{"rot", "[", 
                    RowBox[{"#", ",", 
                    RowBox[{"-", "a"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"x", ",", "y"}], "}"}]}], "]"}], "]"}]}], "}"}], 
                  ",", 
                  RowBox[{"-", 
                   FractionBox[
                    RowBox[{"8", " ", 
                    RowBox[{"(", 
                    RowBox[{"x", "-", "c"}], ")"}]}], 
                    RowBox[{
                    SuperscriptBox["ap", "2"], "+", 
                    RowBox[{"4", " ", 
                    SuperscriptBox["x", "2"]}], "-", 
                    RowBox[{"8", " ", "x", " ", "c"}], "+", 
                    RowBox[{"4", " ", 
                    SuperscriptBox["c", "2"]}]}]]}]}], "]"}]}], ")"}], 
              "&"}]}], "]"}], ",", 
           RowBox[{"Graphics", "[", 
            RowBox[{"locatorLeftRight", ",", 
             RowBox[{"ImageSize", "\[Rule]", "locatorSize"}]}], "]"}]}], 
          "]"}], ",", "\[IndentingNewLine]", 
         RowBox[{"Locator", "[", 
          RowBox[{
           RowBox[{"Dynamic", "[", 
            RowBox[{
             RowBox[{"rot", "[", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                 RowBox[{
                  RowBox[{"1", "/", "r2"}], "+", "x", "-", 
                  RowBox[{
                   RowBox[{"Sqrt", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "/", "r2"}], ")"}], "^", "2"}], "-", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"ap", "/", "2"}], ")"}], "^", "2"}]}], "]"}], "*", 
                   RowBox[{"Sign", "[", 
                    RowBox[{"1", "/", "r2"}], "]"}]}], "+", "t"}], ",", 
                 RowBox[{"y", "+", 
                  RowBox[{"ap", "/", "2"}]}]}], "}"}], ",", "a", ",", 
               RowBox[{"{", 
                RowBox[{"x", ",", "y"}], "}"}]}], "]"}], ",", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"With", "[", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{"c", "=", 
                   RowBox[{"First", "[", 
                    RowBox[{"rot", "[", 
                    RowBox[{"#", ",", 
                    RowBox[{"-", "a"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"x", ",", "y"}], "}"}]}], "]"}], "]"}]}], "}"}], 
                 ",", 
                 RowBox[{"r2", "=", 
                  RowBox[{"-", 
                   FractionBox[
                    RowBox[{"8", " ", 
                    RowBox[{"(", 
                    RowBox[{"x", "-", 
                    RowBox[{"(", 
                    RowBox[{"c", "-", "t"}], ")"}]}], ")"}]}], 
                    RowBox[{
                    SuperscriptBox["ap", "2"], "+", 
                    RowBox[{"4", " ", 
                    SuperscriptBox["x", "2"]}], "-", 
                    RowBox[{"8", " ", "x", " ", 
                    RowBox[{"(", 
                    RowBox[{"c", "-", "t"}], ")"}]}], "+", 
                    RowBox[{"4", " ", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"c", "-", "t"}], ")"}], "2"]}]}]]}]}]}], "]"}], 
               ")"}], "&"}]}], "]"}], ",", 
           RowBox[{"Graphics", "[", 
            RowBox[{"locatorLeftRight", ",", 
             RowBox[{"ImageSize", "\[Rule]", "locatorSize"}]}], "]"}]}], 
          "]"}]}], "\[IndentingNewLine]", "}"}]}], ";", "\n", 
      RowBox[{
       RowBox[{"Attributes", "[", "LensLayout", "]"}], "=", 
       RowBox[{"{", "HoldAll", "}"}]}], ";", "\n", 
      RowBox[{
       RowBox[{"LensLayout", "[", 
        RowBox[{"{", 
         RowBox[{
         "wavelength1_", ",", "wavelength2_", ",", "sourceAngle_", ",", 
          "sourceXY1_", ",", "sourceXY2_", ",", "lensAngle_", ",", 
          "thicknessAndAperture1_", ",", "thicknessAndAperture2_", ",", 
          "curvature1_", ",", "curvature2_", ",", "a_", ",", "b_"}], "}"}], 
        "]"}], ":=", 
       RowBox[{"Graphics", "[", 
        RowBox[{
         RowBox[{"{", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"Dynamic", "[", 
            RowBox[{"{", "\[IndentingNewLine]", 
             RowBox[{
              RowBox[{"system", "[", 
               RowBox[{
                RowBox[{
                 RowBox[{"sourceAngle", "[", 
                  RowBox[{"[", "1", "]"}], "]"}], "/", "Degree"}], ",", 
                RowBox[{
                 RowBox[{"sourceAngle", "[", 
                  RowBox[{"[", "2", "]"}], "]"}], "/", "Degree"}], ",", 
                "wavelength1", ",", "wavelength2", ",", 
                RowBox[{"sourceXY1", "[", 
                 RowBox[{"[", "1", "]"}], "]"}], ",", 
                RowBox[{"sourceXY2", "[", 
                 RowBox[{"[", "1", "]"}], "]"}], ",", 
                RowBox[{"sourceXY1", "[", 
                 RowBox[{"[", "2", "]"}], "]"}], ",", 
                RowBox[{"sourceXY2", "[", 
                 RowBox[{"[", "2", "]"}], "]"}], ",", 
                RowBox[{
                 RowBox[{"lensAngle", "[", 
                  RowBox[{"[", "1", "]"}], "]"}], "/", "Degree"}], ",", 
                RowBox[{
                 RowBox[{"lensAngle", "[", 
                  RowBox[{"[", "2", "]"}], "]"}], "/", "Degree"}], ",", 
                RowBox[{"thicknessAndAperture1", "[", 
                 RowBox[{"[", "2", "]"}], "]"}], ",", 
                RowBox[{"thicknessAndAperture2", "[", 
                 RowBox[{"[", "2", "]"}], "]"}], ",", 
                RowBox[{"curvature1", "[", 
                 RowBox[{"[", "1", "]"}], "]"}], ",", 
                RowBox[{"curvature1", "[", 
                 RowBox[{"[", "2", "]"}], "]"}], ",", 
                RowBox[{"curvature2", "[", 
                 RowBox[{"[", "1", "]"}], "]"}], ",", 
                RowBox[{"curvature2", "[", 
                 RowBox[{"[", "2", "]"}], "]"}], ",", 
                RowBox[{"thicknessAndAperture1", "[", 
                 RowBox[{"[", "1", "]"}], "]"}], ",", 
                RowBox[{"thicknessAndAperture2", "[", 
                 RowBox[{"[", "1", "]"}], "]"}], ",", 
                RowBox[{"a", "[", 
                 RowBox[{"[", "1", "]"}], "]"}], ",", 
                RowBox[{"b", "[", 
                 RowBox[{"[", "1", "]"}], "]"}], ",", 
                RowBox[{"a", "[", 
                 RowBox[{"[", "2", "]"}], "]"}], ",", 
                RowBox[{"b", "[", 
                 RowBox[{"[", "2", "]"}], "]"}]}], "]"}], ",", 
              "\[IndentingNewLine]", 
              RowBox[{"Arrowheads", "\[Rule]", "Large"}], ",", 
              RowBox[{"Lighter", "[", "Blue", "]"}], ",", 
              "\[IndentingNewLine]", 
              RowBox[{"Arrow", "[", 
               RowBox[{"{", 
                RowBox[{"sourceXY1", ",", 
                 RowBox[{"sourceXY1", "+", 
                  RowBox[{"10", 
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"sourceAngle", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "]"}], ",", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"sourceAngle", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "]"}]}], "}"}]}]}]}], 
                "}"}], "]"}], ",", "\[IndentingNewLine]", 
              RowBox[{"Arrow", "[", 
               RowBox[{"{", 
                RowBox[{"sourceXY2", ",", 
                 RowBox[{"sourceXY2", "+", 
                  RowBox[{"10", 
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"sourceAngle", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "]"}], ",", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"sourceAngle", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "]"}]}], "}"}]}]}]}], 
                "}"}], "]"}], ",", "\[IndentingNewLine]", 
              RowBox[{"Arrowheads", "\[Rule]", "Medium"}], ",", 
              "\[IndentingNewLine]", 
              RowBox[{"Arrow", "[", 
               RowBox[{"{", 
                RowBox[{"a", ",", 
                 RowBox[{"a", "+", 
                  RowBox[{"5", 
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"lensAngle", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "]"}], ",", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"lensAngle", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "]"}]}], "}"}]}]}]}], 
                "}"}], "]"}], ",", "\[IndentingNewLine]", 
              RowBox[{"Arrow", "[", 
               RowBox[{"{", 
                RowBox[{"b", ",", 
                 RowBox[{"b", "+", 
                  RowBox[{"5", 
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Cos", "[", 
                    RowBox[{"lensAngle", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "]"}], ",", 
                    RowBox[{"Sin", "[", 
                    RowBox[{"lensAngle", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "]"}]}], "}"}]}]}]}], 
                "}"}], "]"}]}], "}"}], "]"}], ",", "\[IndentingNewLine]", 
           RowBox[{"Locator", "[", 
            RowBox[{
             RowBox[{"Dynamic", "[", "sourceXY1", "]"}], ",", 
             RowBox[{"Graphics", "[", 
              RowBox[{"locatorAll", ",", 
               RowBox[{"ImageSize", "\[Rule]", "locatorSize"}]}], "]"}]}], 
            "]"}], ",", "\[IndentingNewLine]", 
           RowBox[{"Locator", "[", 
            RowBox[{
             RowBox[{"Dynamic", "[", "sourceXY2", "]"}], ",", 
             RowBox[{"Graphics", "[", 
              RowBox[{"locatorAll", ",", 
               RowBox[{"ImageSize", "\[Rule]", "locatorSize"}]}], "]"}]}], 
            "]"}], ",", "\[IndentingNewLine]", 
           RowBox[{"Locator", "[", 
            RowBox[{
             RowBox[{"Dynamic", "[", 
              RowBox[{
               RowBox[{"sourceXY1", "+", 
                RowBox[{"10", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"Cos", "[", 
                    RowBox[{"sourceAngle", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "]"}], ",", 
                   RowBox[{"Sin", "[", 
                    RowBox[{"sourceAngle", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "]"}]}], "}"}]}]}], ",", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"sourceAngle", "[", 
                   RowBox[{"[", "1", "]"}], "]"}], "=", 
                  RowBox[{"Apply", "[", 
                   RowBox[{"ArcTan", ",", 
                    RowBox[{"#", "-", "sourceXY1"}]}], "]"}]}], ")"}], 
                "&"}]}], "]"}], ",", 
             RowBox[{"Graphics", "[", 
              RowBox[{"locatorAll", ",", 
               RowBox[{"ImageSize", "\[Rule]", "locatorSize"}]}], "]"}]}], 
            "]"}], ",", "\[IndentingNewLine]", 
           RowBox[{"Locator", "[", 
            RowBox[{
             RowBox[{"Dynamic", "[", 
              RowBox[{
               RowBox[{"sourceXY2", "+", 
                RowBox[{"10", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"Cos", "[", 
                    RowBox[{"sourceAngle", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "]"}], ",", 
                   RowBox[{"Sin", "[", 
                    RowBox[{"sourceAngle", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "]"}]}], "}"}]}]}], ",", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"sourceAngle", "[", 
                   RowBox[{"[", "2", "]"}], "]"}], "=", 
                  RowBox[{"Apply", "[", 
                   RowBox[{"ArcTan", ",", 
                    RowBox[{"#", "-", "sourceXY2"}]}], "]"}]}], ")"}], 
                "&"}]}], "]"}], ",", 
             RowBox[{"Graphics", "[", 
              RowBox[{"locatorAll", ",", 
               RowBox[{"ImageSize", "\[Rule]", "locatorSize"}]}], "]"}]}], 
            "]"}], ",", "\[IndentingNewLine]", "Cyan", ",", 
           RowBox[{"Opacity", "[", "0.4", "]"}], ",", "\[IndentingNewLine]", 
           RowBox[{"lensWithControls", "[", 
            RowBox[{
             RowBox[{"Dynamic", "[", 
              RowBox[{"curvature1", "[", 
               RowBox[{"[", "1", "]"}], "]"}], "]"}], ",", 
             RowBox[{"Dynamic", "[", 
              RowBox[{"curvature1", "[", 
               RowBox[{"[", "2", "]"}], "]"}], "]"}], ",", 
             RowBox[{"Dynamic", "[", 
              RowBox[{"lensAngle", "[", 
               RowBox[{"[", "1", "]"}], "]"}], "]"}], ",", 
             RowBox[{"Dynamic", "[", 
              RowBox[{"thicknessAndAperture1", "[", 
               RowBox[{"[", "2", "]"}], "]"}], "]"}], ",", 
             RowBox[{"Dynamic", "[", 
              RowBox[{"a", "[", 
               RowBox[{"[", "1", "]"}], "]"}], "]"}], ",", 
             RowBox[{"Dynamic", "[", 
              RowBox[{"thicknessAndAperture1", "[", 
               RowBox[{"[", "1", "]"}], "]"}], "]"}], ",", 
             RowBox[{"Dynamic", "[", 
              RowBox[{"a", "[", 
               RowBox[{"[", "2", "]"}], "]"}], "]"}]}], "]"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"RGBColor", "[", 
            RowBox[{".4", ",", ".6", ",", ".8"}], "]"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{"lensWithControls", "[", 
            RowBox[{
             RowBox[{"Dynamic", "[", 
              RowBox[{"curvature2", "[", 
               RowBox[{"[", "1", "]"}], "]"}], "]"}], ",", 
             RowBox[{"Dynamic", "[", 
              RowBox[{"curvature2", "[", 
               RowBox[{"[", "2", "]"}], "]"}], "]"}], ",", 
             RowBox[{"Dynamic", "[", 
              RowBox[{"lensAngle", "[", 
               RowBox[{"[", "2", "]"}], "]"}], "]"}], ",", 
             RowBox[{"Dynamic", "[", 
              RowBox[{"thicknessAndAperture2", "[", 
               RowBox[{"[", "2", "]"}], "]"}], "]"}], ",", 
             RowBox[{"Dynamic", "[", 
              RowBox[{"b", "[", 
               RowBox[{"[", "1", "]"}], "]"}], "]"}], ",", 
             RowBox[{"Dynamic", "[", 
              RowBox[{"thicknessAndAperture2", "[", 
               RowBox[{"[", "1", "]"}], "]"}], "]"}], ",", 
             RowBox[{"Dynamic", "[", 
              RowBox[{"b", "[", 
               RowBox[{"[", "2", "]"}], "]"}], "]"}]}], "]"}]}], 
          "\[IndentingNewLine]", "}"}], ",", 
         RowBox[{"PlotRange", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"-", "5"}], ",", "205"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"-", "80"}], ",", "80"}], "}"}]}], "}"}]}], ",", 
         RowBox[{"ImageSize", "\[Rule]", "500"}]}], "]"}]}], ";"}], 
     "\[IndentingNewLine]", ")"}]}]}], "]"}]], "Input",
 CellChangeTimes->{
  3.35696210375764*^9, {3.370008304354715*^9, 3.370008314307776*^9}, {
   3.370008367932433*^9, 3.370008425838312*^9}, {3.3700089734910574`*^9, 
   3.370008995209668*^9}, {3.3700090483655777`*^9, 3.370009049287447*^9}, {
   3.38445922021875*^9, 3.3844592205*^9}, {3.5056673993497744`*^9, 
   3.5056674211319523`*^9}, 3.505667612469084*^9, {3.505667768062642*^9, 
   3.505667820996935*^9}, 3.5056678584706817`*^9},
 CellID->1496021318]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`curvature1$$ = {
    0.01, -0.01}, $CellContext`curvature2$$ = {
    0.01, -0.01}, $CellContext`lensAngle$$ = {0., 
    0.}, $CellContext`lensLocation1$$ = {50., 
    0.}, $CellContext`lensLocation2$$ = {75., 
    0.}, $CellContext`sourceAngle$$ = {0., 0.}, $CellContext`sourceXY1$$ = {
    0., 0.}, $CellContext`sourceXY2$$ = {0., 
    10.}, $CellContext`thicknessAndAperture1$$ = {10., 
    50.}, $CellContext`thicknessAndAperture2$$ = {10., 
    50.}, $CellContext`wavelength1$$ = 0.532, $CellContext`wavelength2$$ = 
    0.532, Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
    Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
    1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`wavelength1$$], 0.532, 
       "\!\(\*SubscriptBox[\(\[Lambda]\), \(1\)]\)"}, 0.2, 1}, {{
       Hold[$CellContext`wavelength2$$], 0.532, 
       "\!\(\*SubscriptBox[\(\[Lambda]\), \(2\)]\)"}, 0.2, 1}, {{
       Hold[$CellContext`sourceAngle$$], {0., 0.}}, {-Pi, -Pi}, {Pi, Pi}}, {{
       Hold[$CellContext`sourceXY1$$], {0., 0.}}, {0, -80}, {200, 80}}, {{
       Hold[$CellContext`sourceXY2$$], {0., 10.}}, {0, -80}, {200, 80}}, {{
       Hold[$CellContext`lensAngle$$], {0., 0.}}, {-Pi, -Pi}, {Pi, Pi}}, {{
       Hold[$CellContext`thicknessAndAperture1$$], {10., 50.}}, {0, 1}, {100, 
      100}}, {{
       Hold[$CellContext`thicknessAndAperture2$$], {10., 50.}}, {0, 1}, {100, 
      100}}, {{
       Hold[$CellContext`curvature1$$], {0.01, -0.01}}, {-0.03, -0.03}, {0.03,
       0.03}}, {{
       Hold[$CellContext`curvature2$$], {0.01, -0.01}}, {-0.03, -0.03}, {0.03,
       0.03}}, {{
       Hold[$CellContext`lensLocation1$$], {50., 0.}}, {0, -80}, {200, 80}}, {{
       Hold[$CellContext`lensLocation2$$], {75., 0.}}, {0, -80}, {200, 80}}}, 
    Typeset`size$$ = Automatic, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = False, $CellContext`sourceAngle$29524$$ = {0, 
    0}, $CellContext`sourceXY1$29525$$ = {0, 
    0}, $CellContext`sourceXY2$29526$$ = {0, 
    0}, $CellContext`lensAngle$29527$$ = {0, 
    0}, $CellContext`thicknessAndAperture1$29528$$ = {0, 0}}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`curvature1$$ = {
         0.01, -0.01}, $CellContext`curvature2$$ = {
         0.01, -0.01}, $CellContext`lensAngle$$ = {0., 
         0.}, $CellContext`lensLocation1$$ = {50., 
         0.}, $CellContext`lensLocation2$$ = {75., 
         0.}, $CellContext`sourceAngle$$ = {0., 
         0.}, $CellContext`sourceXY1$$ = {0., 
         0.}, $CellContext`sourceXY2$$ = {0., 
         10.}, $CellContext`thicknessAndAperture1$$ = {10., 
         50.}, $CellContext`thicknessAndAperture2$$ = {10., 
         50.}, $CellContext`wavelength1$$ = 0.532, $CellContext`wavelength2$$ = 
        0.532}, "ControllerVariables" :> {
        Hold[$CellContext`sourceAngle$$, $CellContext`sourceAngle$29524$$, {0,
          0}], 
        Hold[$CellContext`sourceXY1$$, $CellContext`sourceXY1$29525$$, {0, 
         0}], 
        Hold[$CellContext`sourceXY2$$, $CellContext`sourceXY2$29526$$, {0, 
         0}], 
        Hold[$CellContext`lensAngle$$, $CellContext`lensAngle$29527$$, {0, 
         0}], 
        Hold[$CellContext`thicknessAndAperture1$$, \
$CellContext`thicknessAndAperture1$29528$$, {0, 0}]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Deploy[
        $CellContext`LensLayout[{$CellContext`wavelength1$$, \
$CellContext`wavelength2$$, $CellContext`sourceAngle$$, \
$CellContext`sourceXY1$$, $CellContext`sourceXY2$$, $CellContext`lensAngle$$, \
$CellContext`thicknessAndAperture1$$, $CellContext`thicknessAndAperture2$$, \
$CellContext`curvature1$$, $CellContext`curvature2$$, \
$CellContext`lensLocation1$$, $CellContext`lensLocation2$$}]], 
      "Specifications" :> {{{$CellContext`wavelength1$$, 0.532, 
          "\!\(\*SubscriptBox[\(\[Lambda]\), \(1\)]\)"}, 0.2, 1, ControlType -> 
         Manipulator}, {{$CellContext`wavelength2$$, 0.532, 
          "\!\(\*SubscriptBox[\(\[Lambda]\), \(2\)]\)"}, 0.2, 1, ControlType -> 
         Manipulator}, {{$CellContext`sourceAngle$$, {0., 0.}}, {-Pi, -Pi}, {
         Pi, Pi}}, {{$CellContext`sourceXY1$$, {0., 0.}}, {0, -80}, {200, 
         80}}, {{$CellContext`sourceXY2$$, {0., 10.}}, {0, -80}, {200, 
         80}}, {{$CellContext`lensAngle$$, {0., 0.}}, {-Pi, -Pi}, {
         Pi, Pi}}, {{$CellContext`thicknessAndAperture1$$, {10., 50.}}, {0, 
         1}, {100, 
         100}}, {{$CellContext`thicknessAndAperture2$$, {10., 50.}}, {0, 1}, {
         100, 100}}, {{$CellContext`curvature1$$, {
          0.01, -0.01}}, {-0.03, -0.03}, {0.03, 
         0.03}}, {{$CellContext`curvature2$$, {
          0.01, -0.01}}, {-0.03, -0.03}, {0.03, 
         0.03}}, {{$CellContext`lensLocation1$$, {50., 0.}}, {0, -80}, {200, 
         80}}, {{$CellContext`lensLocation2$$, {75., 0.}}, {0, -80}, {200, 
         80}}}, "Options" :> {
       ControlType -> None, AutorunSequencing -> {1, 2, 9, 10}, 
        SynchronousInitialization -> False}, 
      "DefaultOptions" :> {ControllerLinking -> True}],
     ImageSizeCache->{270., {64., 69.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    Initialization:>(($CellContext`micronsToColor[
         Pattern[$CellContext`m, 
          Blank[]]] := RGBColor[
         Abs[(-0.3183098861837907) 
           ArcTan[63.75 - 0.25 
             Abs[-500. + 2. Mod[100. + 500. $CellContext`m, 500.]]] + 
          0.3183098861837907 
           ArcTan[43. - 0.1 
             Abs[-500. + 2. Mod[100. + 500. $CellContext`m, 500.]]]], 
         Abs[
         0.3183098861837907 
           ArcTan[60. - 0.2 
             Abs[-500. + 2. Mod[100. + 500. $CellContext`m, 500.]]] - 
          0.3183098861837907 
          ArcTan[18. - 0.1 
            Abs[-500. + 2. Mod[100. + 500. $CellContext`m, 500.]]]], 
         Abs[(-0.3183098861837907) 
           ArcTan[10. - 0.2 
             Abs[-500. + 2. Mod[100. + 500. $CellContext`m, 500.]]] + 
          0.3183098861837907 
           ArcTan[22.5 - 0.125 
             Abs[-500. + 
               2. Mod[100. + 500. $CellContext`m, 
                  500.]]]]]; $CellContext`rayfunction = 
       Compile[{$CellContext`as1, $CellContext`wl1, $CellContext`xs1, \
$CellContext`ys1, $CellContext`aa, $CellContext`ab, $CellContext`apa, \
$CellContext`apb, $CellContext`ca1, $CellContext`ca2, $CellContext`cb1, \
$CellContext`cb2, $CellContext`ta, $CellContext`tb, $CellContext`xa1, \
$CellContext`xb1, $CellContext`ya1, $CellContext`yb1}, 
         Module[{$CellContext`activeregion, \
$CellContext`allcreatedamplitudes, $CellContext`allcreatedrays, \
$CellContext`allowzeroraylength, $CellContext`alternateindex, \
$CellContext`amplitude, $CellContext`axismagnitude, $CellContext`axismatrix, \
$CellContext`clonedata, $CellContext`clonegenerationnumber, \
$CellContext`cloneinput, $CellContext`clonenumber, \
$CellContext`cloneposition, $CellContext`clonereportedrays, \
$CellContext`clonerotation, $CellContext`clonescale, \
$CellContext`clonescalevector, $CellContext`clonesorthistogram, \
$CellContext`clonetraceinput, $CellContext`clonetraceoutput, \
$CellContext`closestdistances, $CellContext`closestposition, \
$CellContext`closestpositions, $CellContext`closestraylength, \
$CellContext`completedray, $CellContext`componentnumber, \
$CellContext`cosangle, $CellContext`crossmatrix, \
$CellContext`deflecteddummyrayspresent, $CellContext`deflectedlocalrays, \
$CellContext`deflectedrays, $CellContext`deflectedrayspresent, \
$CellContext`dummymatrix, $CellContext`dummymatrixlist, \
$CellContext`dummyvector, $CellContext`frontid, $CellContext`generationlimit, \
$CellContext`generationnumber, $CellContext`holeintersections, \
$CellContext`holeQ, $CellContext`holeQlist, $CellContext`hor, \
$CellContext`index, $CellContext`index1, $CellContext`index2, \
$CellContext`inrays, $CellContext`intensity, $CellContext`intensityscale, \
$CellContext`intersectionnumber, $CellContext`intersections, \
$CellContext`intersectionslist, $CellContext`intersectionspresent, \
$CellContext`localdummyoutrayspresent, $CellContext`localoutrays, \
$CellContext`localoutrayspresent, $CellContext`magnitude, \
$CellContext`maxclonegenerationnumber, $CellContext`maximumposition, \
$CellContext`minimumraylength, $CellContext`minresonateraylength, \
$CellContext`n12, $CellContext`newcomponentnumber, \
$CellContext`newdeflectedrays, $CellContext`newdistance, \
$CellContext`newsurfaceid, $CellContext`newsurfacenumber, \
$CellContext`nonintersectingrays, $CellContext`normalizedpolarization, \
$CellContext`oldgenerationnumber, $CellContext`opticallength, \
$CellContext`originalray, $CellContext`originalraytilt, \
$CellContext`originalrotation, $CellContext`originalsurfnorm, \
$CellContext`outrays, $CellContext`parallelamplitude, $CellContext`PAxis, \
$CellContext`perpendicularamplitude, $CellContext`phaseshift, \
$CellContext`pol1, $CellContext`pol2, $CellContext`pol3, \
$CellContext`previoustilt, $CellContext`propagate, \
$CellContext`propagatedrays, $CellContext`r1, $CellContext`r2, \
$CellContext`r3, $CellContext`r4, $CellContext`r5, $CellContext`r6, \
$CellContext`r7, $CellContext`r8, $CellContext`r9, $CellContext`ray1, \
$CellContext`ray2, $CellContext`ray3, $CellContext`RayL, \
$CellContext`rayslot, $CellContext`raysreported, $CellContext`raytiltx, \
$CellContext`raytiltz, $CellContext`reporteddummyrayspresent, \
$CellContext`reportedlocalrays, $CellContext`reportedrays, \
$CellContext`reportedrayspresent, $CellContext`resonateintersections, \
$CellContext`resonatenumber, $CellContext`resonateraylength, \
$CellContext`rex, $CellContext`rey, $CellContext`rez, \
$CellContext`rotationaxis, $CellContext`rsx, $CellContext`RSx, \
$CellContext`rsy, $CellContext`RSy, $CellContext`rsz, $CellContext`RSz, \
$CellContext`RTx, $CellContext`RTy, $CellContext`RTz, $CellContext`rx, \
$CellContext`rxhlp, $CellContext`ry, $CellContext`ryhlp, $CellContext`rz, \
$CellContext`rzhlp, $CellContext`SCx, $CellContext`SCy, $CellContext`sid, \
$CellContext`sinangle, $CellContext`sno1, $CellContext`sno2, \
$CellContext`sno3, $CellContext`sno4, $CellContext`surfaceid, \
$CellContext`surfacenumber, $CellContext`surfacerotationmatrix, \
$CellContext`surfacetranslationvector, $CellContext`surfnorm, \
$CellContext`symr1, $CellContext`symr2, $CellContext`symr3, \
$CellContext`symr4, $CellContext`symr5, $CellContext`symr6, \
$CellContext`symr7, $CellContext`symr8, $CellContext`symr9, \
$CellContext`tempclonedata, $CellContext`terminatedeflection, \
$CellContext`thresholdintensity, $CellContext`tiltmagnitude, \
$CellContext`transmatrix, $CellContext`TV1, $CellContext`TV10, \
$CellContext`TV2, $CellContext`TV3, $CellContext`TV4, $CellContext`TV5, \
$CellContext`TV6, $CellContext`TV7, $CellContext`TV8, $CellContext`TV9, \
$CellContext`u, $CellContext`unfilteredintersections, $CellContext`unit, \
$CellContext`uu, $CellContext`ver, $CellContext`wavelength, \
$CellContext`XAxis, $CellContext`xunit, $CellContext`YAxis, \
$CellContext`yunit, $CellContext`ZAxis, $CellContext`zunit}, \
$CellContext`activeregion = 
           1.; $CellContext`allcreatedamplitudes = {{
             0. + 0. I, 0. + 0. I, 0. + 
              0. I}}; $CellContext`allcreatedrays = {{
            1.}}; $CellContext`allowzeroraylength = 
           True; $CellContext`alternateindex = 
           1.; $CellContext`amplitude = {
            1. + 0. I, 0. + 0. I, 0. + 0. I}; $CellContext`axismagnitude = 
           1.; $CellContext`axismatrix = {{1., 0., 0.}, {0., 1., 0.}, {0., 0.,
             1.}}; $CellContext`clonedata = {{
            1.}}; $CellContext`clonegenerationnumber = 
           1.; $CellContext`cloneinput = {1.}; $CellContext`clonenumber = 
           1; $CellContext`cloneposition = {0., 0., 
            0.}; $CellContext`clonereportedrays = {{
            1.}}; $CellContext`clonerotation = {{
            1.}}; $CellContext`clonescale = 
           1.; $CellContext`clonescalevector = {
            1.}; $CellContext`clonesorthistogram = {
            1}; $CellContext`clonetraceinput = {{
            1.}}; $CellContext`clonetraceoutput = {{
            1.}}; $CellContext`closestdistances = {
            1.}; $CellContext`closestposition = 
           0; $CellContext`closestpositions = {
            0}; $CellContext`closestraylength = 
           1.; $CellContext`completedray = {
            1.}; $CellContext`componentnumber = -1.; $CellContext`cosangle = 
           1.; $CellContext`crossmatrix = {{1., 0., 0.}, {0., 1., 0.}, {0., 
            0., 1.}}; $CellContext`deflecteddummyrayspresent = 
           False; $CellContext`deflectedlocalrays = {{
            1.}}; $CellContext`deflectedrays = {{
            1.}}; $CellContext`deflectedrayspresent = 
           False; $CellContext`dummymatrix = {{
            1.}}; $CellContext`dummymatrixlist = {{{
            1.}}}; $CellContext`dummyvector = {1.}; $CellContext`frontid = 
           1.; $CellContext`generationlimit = 
           200.; $CellContext`generationnumber = 
           1.; $CellContext`holeintersections = {{-1., 0., 
            0.}}; $CellContext`holeQ = 
           False; $CellContext`holeQlist = {0}; $CellContext`hor = 
           1. + 0. I; $CellContext`index = 1.; $CellContext`index1 = 
           1.; $CellContext`index2 = 
           1.; $CellContext`inrays = {{1.}}; $CellContext`intensity = 
           1.; $CellContext`intensityscale = 
           1.; $CellContext`intersectionnumber = 
           1.; $CellContext`intersections = {{-1., 0., 
            0.}}; $CellContext`intersectionslist = {{{-1., 0., 
            0.}}}; $CellContext`intersectionspresent = 
           False; $CellContext`localdummyoutrayspresent = 
           False; $CellContext`localoutrays = {{
            1.}}; $CellContext`localoutrayspresent = 
           False; $CellContext`magnitude = 
           1.; $CellContext`maxclonegenerationnumber = 
           1.; $CellContext`maximumposition = 
           1; $CellContext`minimumraylength = 
           0.0001; $CellContext`minresonateraylength = 1.; $CellContext`n12 = 
           1.; $CellContext`newcomponentnumber = -1.; \
$CellContext`newdeflectedrays = {{1.}}; $CellContext`newdistance = 
           1.; $CellContext`newsurfaceid = -1.; $CellContext`newsurfacenumber = \
-1.; $CellContext`nonintersectingrays = {{
            1.}}; $CellContext`normalizedpolarization = {1., 
            1.}; $CellContext`oldgenerationnumber = 
           1.; $CellContext`opticallength = 
           1.; $CellContext`originalray = {
            1.}; $CellContext`originalraytilt = {
            1.}; $CellContext`originalrotation = {{1., 0., 0.}, {0., 1., 
            0.}, {0., 0., 1.}}; $CellContext`originalsurfnorm = {{
            1.}}; $CellContext`outrays = {{
            1.}}; $CellContext`parallelamplitude = 
           1. + 0. I; $CellContext`PAxis = {1., 0., 
            0.}; $CellContext`perpendicularamplitude = 
           1. + 0. I; $CellContext`phaseshift = 0.; $CellContext`pol1 = 
           1.; $CellContext`pol2 = 1.; $CellContext`pol3 = 
           1.; $CellContext`previoustilt = {1., 0., 
            0.}; $CellContext`propagate = 
           True; $CellContext`propagatedrays = {{1.}}; $CellContext`r1 = 
           1.; $CellContext`r2 = 1.; $CellContext`r3 = 1.; $CellContext`r4 = 
           1.; $CellContext`r5 = 1.; $CellContext`r6 = 1.; $CellContext`r7 = 
           1.; $CellContext`r8 = 1.; $CellContext`r9 = 1.; $CellContext`ray1 = 
           1.; $CellContext`ray2 = 1.; $CellContext`ray3 = 
           1.; $CellContext`RayL = 1.; $CellContext`rayslot = 
           1.; $CellContext`raysreported = False; $CellContext`raytiltx = 
           1.; $CellContext`raytiltz = 
           1.; $CellContext`reporteddummyrayspresent = 
           False; $CellContext`reportedlocalrays = {{
            1.}}; $CellContext`reportedrays = {{
            1.}}; $CellContext`reportedrayspresent = 
           False; $CellContext`resonateintersections = {{-1., 0., 
            0.}}; $CellContext`resonatenumber = 
           0; $CellContext`resonateraylength = 1.; $CellContext`rex = 
           1.; $CellContext`rey = 1.; $CellContext`rez = 1.; $CellContext`rsx = 
           1.; $CellContext`RSx = 1.; $CellContext`rsy = 1.; $CellContext`RSy = 
           1.; $CellContext`rsz = 1.; $CellContext`RSz = 1.; $CellContext`RTx = 
           1.; $CellContext`RTy = 1.; $CellContext`RTz = 1.; $CellContext`rx = 
           1.; $CellContext`rxhlp = 1.; $CellContext`ry = 
           1.; $CellContext`ryhlp = 1.; $CellContext`rz = 
           1.; $CellContext`rzhlp = 1.; $CellContext`SCx = 
           1.; $CellContext`SCy = 1.; $CellContext`sid = 
           1.; $CellContext`sinangle = 1.; $CellContext`sno1 = 
           1.; $CellContext`sno2 = 1.; $CellContext`sno3 = 
           1.; $CellContext`sno4 = 
           1.; $CellContext`surfaceid = -1.; $CellContext`surfacenumber = -1.; \
$CellContext`surfacerotationmatrix = {{1., 0., 0.}, {0., 1., 0.}, {0., 0., 
            1.}}; $CellContext`surfacetranslationvector = {0., 0., 
            0.}; $CellContext`surfnorm = {{1.}}; $CellContext`symr1 = 
           1.; $CellContext`symr2 = 1.; $CellContext`symr3 = 
           1.; $CellContext`symr4 = 1.; $CellContext`symr5 = 
           1.; $CellContext`symr6 = 1.; $CellContext`symr7 = 
           1.; $CellContext`symr8 = 1.; $CellContext`symr9 = 
           1.; $CellContext`tempclonedata = {{
            1.}}; $CellContext`terminatedeflection = 
           False; $CellContext`thresholdintensity = 
           1.; $CellContext`tiltmagnitude = 
           1.; $CellContext`transmatrix = {{{1., 0., 0.}, {0., 1., 0.}, {0., 
            0., 1.}}}; $CellContext`TV1 = 1.; $CellContext`TV10 = 
           1.; $CellContext`TV2 = 1.; $CellContext`TV3 = 1.; $CellContext`TV4 = 
           1.; $CellContext`TV5 = 1.; $CellContext`TV6 = 1.; $CellContext`TV7 = 
           1.; $CellContext`TV8 = 1.; $CellContext`TV9 = 
           1.; $CellContext`u = {{1., 0., 0.}, {0., 1., 0.}, {0., 0., 
            1.}}; $CellContext`unfilteredintersections = {{-1., 0., 
            0.}}; $CellContext`unit = {{1., 0., 0.}, {0., 1., 0.}, {0., 0., 
            1.}}; $CellContext`uu = {{1., 0., 0.}, {0., 1., 0.}, {0., 0., 
            1.}}; $CellContext`ver = 0. + 0. I; $CellContext`wavelength = 
           1.; $CellContext`XAxis = {1., 0., 0.}; $CellContext`xunit = 
           1.; $CellContext`YAxis = {1., 0., 0.}; $CellContext`yunit = 
           1.; $CellContext`ZAxis = {1., 0., 0.}; $CellContext`zunit = 
           1.; $CellContext`propagatedrays = 
           Join[{$CellContext`symr1, $CellContext`symr2, $CellContext`symr3, \
$CellContext`symr4, $CellContext`symr5, $CellContext`symr6, \
$CellContext`symr7, $CellContext`symr8, $CellContext`symr9} = {
                Cos[$CellContext`as1 Degree], 
                Sin[$CellContext`as1 Degree], 0, -
                Sin[$CellContext`as1 Degree], 
                Cos[$CellContext`as1 Degree], 0, 0, 0, 1}; 
             Map[({$CellContext`rsx, $CellContext`rsy, $CellContext`rsz, \
$CellContext`rex, $CellContext`rey, $CellContext`rez, $CellContext`r1, \
$CellContext`r2, $CellContext`r3, $CellContext`r4, $CellContext`r5, \
$CellContext`r6, $CellContext`r7, $CellContext`r8, $CellContext`r9, \
$CellContext`wavelength, $CellContext`intensity, $CellContext`intensityscale, \
$CellContext`ray1, $CellContext`index, $CellContext`opticallength, \
$CellContext`phaseshift, $CellContext`componentnumber, \
$CellContext`surfacenumber, $CellContext`surfaceid, $CellContext`ray2, \
$CellContext`ray3, $CellContext`sid, $CellContext`frontid, $CellContext`sno1, \
$CellContext`sno2, $CellContext`sno3, $CellContext`sno4, \
$CellContext`rayslot, $CellContext`oldgenerationnumber, \
$CellContext`intersectionnumber, $CellContext`pol1, $CellContext`pol2, \
$CellContext`pol3} = #; $CellContext`wavelength = $CellContext`wl1; \
{$CellContext`TV1, $CellContext`TV2, $CellContext`TV3} = {$CellContext`rsx \
$CellContext`symr1 + $CellContext`rsy $CellContext`symr4 + $CellContext`rsz \
$CellContext`symr7 + $CellContext`xs1, $CellContext`rsx $CellContext`symr2 + \
$CellContext`rsy $CellContext`symr5 + $CellContext`rsz $CellContext`symr8 + \
$CellContext`ys1, $CellContext`rsx $CellContext`symr3 + $CellContext`rsy \
$CellContext`symr6 + $CellContext`rsz $CellContext`symr9}; {$CellContext`rsx, \
$CellContext`rsy, $CellContext`rsz} = {$CellContext`TV1, $CellContext`TV2, \
$CellContext`TV3}; {$CellContext`TV1, $CellContext`TV2, $CellContext`TV3} = \
{$CellContext`rex $CellContext`symr1 + $CellContext`rey $CellContext`symr4 + \
$CellContext`rez $CellContext`symr7 + $CellContext`xs1, $CellContext`rex \
$CellContext`symr2 + $CellContext`rey $CellContext`symr5 + $CellContext`rez \
$CellContext`symr8 + $CellContext`ys1, $CellContext`rex $CellContext`symr3 + \
$CellContext`rey $CellContext`symr6 + $CellContext`rez $CellContext`symr9}; \
{$CellContext`rex, $CellContext`rey, $CellContext`rez} = {$CellContext`TV1, \
$CellContext`TV2, $CellContext`TV3}; {$CellContext`TV1, $CellContext`TV2, \
$CellContext`TV3} = {$CellContext`r1 $CellContext`symr1 + $CellContext`r2 \
$CellContext`symr4 + $CellContext`r3 $CellContext`symr7, $CellContext`r1 \
$CellContext`symr2 + $CellContext`r2 $CellContext`symr5 + $CellContext`r3 \
$CellContext`symr8, $CellContext`r1 $CellContext`symr3 + $CellContext`r2 \
$CellContext`symr6 + $CellContext`r3 $CellContext`symr9}; {$CellContext`TV4, \
$CellContext`TV5, $CellContext`TV6} = {$CellContext`r4 $CellContext`symr1 + \
$CellContext`r5 $CellContext`symr4 + $CellContext`r6 $CellContext`symr7, \
$CellContext`r4 $CellContext`symr2 + $CellContext`r5 $CellContext`symr5 + \
$CellContext`r6 $CellContext`symr8, $CellContext`r4 $CellContext`symr3 + \
$CellContext`r5 $CellContext`symr6 + $CellContext`r6 $CellContext`symr9}; \
{$CellContext`TV7, $CellContext`TV8, $CellContext`TV9} = {$CellContext`r7 \
$CellContext`symr1 + $CellContext`r8 $CellContext`symr4 + $CellContext`r9 \
$CellContext`symr7, $CellContext`r7 $CellContext`symr2 + $CellContext`r8 \
$CellContext`symr5 + $CellContext`r9 $CellContext`symr8, $CellContext`r7 \
$CellContext`symr3 + $CellContext`r8 $CellContext`symr6 + $CellContext`r9 \
$CellContext`symr9}; {{$CellContext`r1, $CellContext`r2, $CellContext`r3}, \
{$CellContext`r4, $CellContext`r5, $CellContext`r6}, {$CellContext`r7, \
$CellContext`r8, $CellContext`r9}} = {{$CellContext`TV1, $CellContext`TV2, \
$CellContext`TV3}, {$CellContext`TV4, $CellContext`TV5, $CellContext`TV6}, \
{$CellContext`TV7, $CellContext`TV8, $CellContext`TV9}}; {$CellContext`rsx, \
$CellContext`rsy, $CellContext`rsz, $CellContext`rex, $CellContext`rey, \
$CellContext`rez, $CellContext`r1, $CellContext`r2, $CellContext`r3, \
$CellContext`r4, $CellContext`r5, $CellContext`r6, $CellContext`r7, \
$CellContext`r8, $CellContext`r9, $CellContext`wavelength, \
$CellContext`intensity, $CellContext`intensityscale, $CellContext`ray1, \
$CellContext`index, $CellContext`opticallength, $CellContext`phaseshift, \
$CellContext`componentnumber, $CellContext`surfacenumber, \
$CellContext`surfaceid, $CellContext`ray2, $CellContext`ray3, \
$CellContext`sid, $CellContext`frontid, $CellContext`sno1, $CellContext`sno2, \
$CellContext`sno3, $CellContext`sno4, $CellContext`rayslot, \
$CellContext`generationnumber, $CellContext`intersectionnumber, \
$CellContext`pol1, $CellContext`pol2, $CellContext`pol3})& , CompressedData["
1:eJxTTMoPSmViYGDgBmJ1BtKB6H4P97sv3tlPYJt8sHbCBXuYOJS/HyaP35QP
9guk9O+qsD2Eqot0cBOPLbnouh2u76lScJcU4wcc5uASRwUOMhcckGmEPjU0
PrHmEmcvNtDAUGX0x+e9/bcIpzU355yCmwPl74fJE7J/YMKNAUqrofGJNZf8
cIt5oj9FZfZ7+9LgFencbEfg5kD5+2HyhOwfmHDjgNJqaHxizSU/3I6l/5gi
f/m9fW64zeyEQ7vg5kD5+2HyhOwfmHATgNJqaHxizSU/3GSfCb09+uW9Pd/J
9x7HT6+CmwPl74fJE7J/YMJNBEqrofGJNZf8cKOO+QMVbhJQWg2NT7y7ibEX
G0BLb/th4rD0N7jTmwyUVkPjE2su1co3eLjByrvBXb4pQGk1ND6x5lKtPoWH
G6x+Hdz1qRKUVkPjE2su1dpv8HCDtecGd/tNBUqrofGJNZf8cEPrL8DDDdZ/
GNz9BTUcNLHmIuQBD8V/Rg==
               "]]]; $CellContext`propagatedrays = 
           Map[({$CellContext`rsx, $CellContext`rsy, $CellContext`rsz, \
$CellContext`rex, $CellContext`rey, $CellContext`rez, $CellContext`r1, \
$CellContext`r2, $CellContext`r3, $CellContext`r4, $CellContext`r5, \
$CellContext`r6, $CellContext`r7, $CellContext`r8, $CellContext`r9, \
$CellContext`wavelength, $CellContext`intensity, $CellContext`intensityscale, \
$CellContext`ray1, $CellContext`index, $CellContext`opticallength, \
$CellContext`phaseshift, $CellContext`componentnumber, \
$CellContext`surfacenumber, $CellContext`surfaceid, $CellContext`ray2, \
$CellContext`ray3, $CellContext`sid, $CellContext`frontid, $CellContext`sno1, \
$CellContext`sno2, $CellContext`sno3, $CellContext`sno4, \
$CellContext`rayslot, $CellContext`oldgenerationnumber, \
$CellContext`intersectionnumber, $CellContext`pol1, $CellContext`pol2, \
$CellContext`pol3} = #; $CellContext`componentnumber = 
              1.; $CellContext`frontid = 
              1.; {$CellContext`rsx, $CellContext`rsy, $CellContext`rsz, \
$CellContext`rex, $CellContext`rey, $CellContext`rez, $CellContext`r1, \
$CellContext`r2, $CellContext`r3, $CellContext`r4, $CellContext`r5, \
$CellContext`r6, $CellContext`r7, $CellContext`r8, $CellContext`r9, \
$CellContext`wavelength, $CellContext`intensity, $CellContext`intensityscale, \
$CellContext`ray1, $CellContext`index, $CellContext`opticallength, \
$CellContext`phaseshift, $CellContext`componentnumber, \
$CellContext`surfacenumber, $CellContext`surfaceid, $CellContext`ray2, \
$CellContext`ray3, $CellContext`sid, $CellContext`frontid, $CellContext`sno1, \
$CellContext`sno2, $CellContext`sno3, $CellContext`sno4, \
$CellContext`rayslot, $CellContext`generationnumber, \
$CellContext`intersectionnumber, $CellContext`pol1, $CellContext`pol2, \
$CellContext`pol3})& , $CellContext`propagatedrays]; \
$CellContext`thresholdintensity = 1.; $CellContext`generationlimit = 
           200.; $CellContext`reportedrays = {{$CellContext`rsx, \
$CellContext`rsy, $CellContext`rsz, $CellContext`rex, $CellContext`rey, \
$CellContext`rez, $CellContext`r1, $CellContext`r2, $CellContext`r3, \
$CellContext`r4, $CellContext`r5, $CellContext`r6, $CellContext`r7, \
$CellContext`r8, $CellContext`r9, $CellContext`wavelength, \
$CellContext`intensity, $CellContext`intensityscale, $CellContext`ray1, \
$CellContext`index, $CellContext`opticallength, $CellContext`phaseshift, \
$CellContext`componentnumber, $CellContext`surfacenumber, \
$CellContext`surfaceid, $CellContext`ray2, $CellContext`ray3, \
$CellContext`sid, $CellContext`frontid, $CellContext`sno1, $CellContext`sno2, \
$CellContext`sno3, $CellContext`sno4, $CellContext`rayslot, \
$CellContext`generationnumber, $CellContext`intersectionnumber, \
$CellContext`pol1, $CellContext`pol2, $CellContext`pol3}}; \
$CellContext`generationnumber = 
           0.; ($CellContext`inrays = $CellContext`propagatedrays; \
$CellContext`outrays = CompressedData["
1:eJxTTMoPSmViYGBgBGJ1Bhj4YD9Q9H8weP+fOPVw9+7HQdPN3QDj4TcH
             
             "]; $CellContext`deflectedrayspresent = 
            True; $CellContext`reportedrayspresent = 
            False; $CellContext`propagate = True; While[
             And[$CellContext`deflectedrayspresent, $CellContext`propagate], 
             AddTo[$CellContext`generationnumber, 
               1.]; ($CellContext`deflecteddummyrayspresent = 
               False; $CellContext`deflectedrayspresent = 
               False; $CellContext`reportedrayspresent = 
               False; $CellContext`reporteddummyrayspresent = 
               True; $CellContext`localdummyoutrayspresent = 
               False; $CellContext`localoutrayspresent = 
               False; {$CellContext`deflectedlocalrays, \
$CellContext`localoutrays, $CellContext`reportedlocalrays} = 
               Map[Flatten[#, 1]& , 
                 Transpose[
                  
                  Map[({$CellContext`rsx, $CellContext`rsy, $CellContext`rsz, \
$CellContext`rex, $CellContext`rey, $CellContext`rez, $CellContext`r1, \
$CellContext`r2, $CellContext`r3, $CellContext`r4, $CellContext`r5, \
$CellContext`r6, $CellContext`r7, $CellContext`r8, $CellContext`r9, \
$CellContext`wavelength, $CellContext`intensity, $CellContext`intensityscale, \
$CellContext`ray1, $CellContext`index, $CellContext`opticallength, \
$CellContext`phaseshift, $CellContext`componentnumber, \
$CellContext`surfacenumber, $CellContext`surfaceid, $CellContext`ray2, \
$CellContext`ray3, $CellContext`sid, $CellContext`frontid, $CellContext`sno1, \
$CellContext`sno2, $CellContext`sno3, $CellContext`sno4, \
$CellContext`rayslot, $CellContext`oldgenerationnumber, \
$CellContext`intersectionnumber, $CellContext`pol1, $CellContext`pol2, \
$CellContext`pol3} = #; If[
                    
                    And[$CellContext`intensity > \
$CellContext`thresholdintensity, $CellContext`generationnumber < \
$CellContext`generationlimit], ($CellContext`resonatenumber = 
                    0; $CellContext`resonateraylength = 
                    1.7976931348623157`*^308; \
$CellContext`resonateintersections = {{-1., 0., 0.}}; MapIndexed[If[
                    And[Part[#, 1, 1] > -1., 
                    Part[#, 1, 
                    1] < $CellContext`resonateraylength], \
$CellContext`resonateraylength = 
                    Part[#, 1, 
                    1]; $CellContext`resonateintersections = #; \
$CellContext`resonatenumber = 
                    First[#2], $CellContext`resonatenumber]& , \
$CellContext`intersectionslist = {{{-1., 0., 0.}}}; $CellContext`holeQlist = {
                    0}; ({$CellContext`rsx, $CellContext`rsy, \
$CellContext`rsz, $CellContext`rex, $CellContext`rey, $CellContext`rez, \
$CellContext`r1, $CellContext`r2, $CellContext`r3, $CellContext`r4, \
$CellContext`r5, $CellContext`r6, $CellContext`r7, $CellContext`r8, \
$CellContext`r9, $CellContext`wavelength, $CellContext`intensity, \
$CellContext`intensityscale, $CellContext`ray1, $CellContext`index, \
$CellContext`opticallength, $CellContext`phaseshift, \
$CellContext`componentnumber, $CellContext`surfacenumber, \
$CellContext`surfaceid, $CellContext`ray2, $CellContext`ray3, \
$CellContext`sid, $CellContext`frontid, $CellContext`sno1, $CellContext`sno2, \
$CellContext`sno3, $CellContext`sno4, $CellContext`rayslot, \
$CellContext`oldgenerationnumber, $CellContext`intersectionnumber, \
$CellContext`pol1, $CellContext`pol2, $CellContext`pol3} = #; \
$CellContext`index1 = $CellContext`index; $CellContext`xunit = \
$CellContext`r1 Re[
                    Cos[
                    0.017453292519943295` $CellContext`aa]] + $CellContext`r2 
                    Re[
                    Sin[
                    0.017453292519943295` $CellContext`aa]]; \
$CellContext`yunit = $CellContext`r2 Re[
                    Cos[0.017453292519943295` $CellContext`aa]] - 
                    1. $CellContext`r1 Re[
                    Sin[
                    0.017453292519943295` $CellContext`aa]]; \
$CellContext`zunit = $CellContext`r3 
                    Re[Cos[0.017453292519943295` $CellContext`aa]^2 + 
                    Sin[0.017453292519943295` $CellContext`aa]^2]; \
$CellContext`xunit = Chop[$CellContext`xunit]; $CellContext`yunit = 
                    Chop[$CellContext`yunit]; $CellContext`zunit = 
                    Chop[$CellContext`zunit]; $CellContext`magnitude = \
($CellContext`xunit^2 + $CellContext`yunit^2 + $CellContext`zunit^2)^(
                    2^(-1)); $CellContext`xunit = \
$CellContext`xunit/$CellContext`magnitude; $CellContext`yunit = \
$CellContext`yunit/$CellContext`magnitude; $CellContext`zunit = \
$CellContext`zunit/$CellContext`magnitude; $CellContext`rx = \
($CellContext`rex - 1. Re[$CellContext`xa1]) Re[
                    Cos[
                    0.017453292519943295` $CellContext`aa]] + \
($CellContext`rey - 1. Re[$CellContext`ya1]) Re[
                    Sin[
                    0.017453292519943295` $CellContext`aa]]; $CellContext`ry = \
($CellContext`rey - 1. Re[$CellContext`ya1]) Re[
                    Cos[0.017453292519943295` $CellContext`aa]] - 
                    1. ($CellContext`rex - 1. Re[$CellContext`xa1]) Re[
                    Sin[
                    0.017453292519943295` $CellContext`aa]]; $CellContext`rz = \
$CellContext`rez Re[Cos[0.017453292519943295` $CellContext`aa]^2 + 
                    Sin[0.017453292519943295` $CellContext`aa]^2]; \
$CellContext`rx = Chop[$CellContext`rx]; $CellContext`ry = 
                    Chop[$CellContext`ry]; $CellContext`rz = 
                    Chop[$CellContext`rz]; $CellContext`terminatedeflection = 
                    False; $CellContext`intersections = {{-1., 0., 
                    0.}}; $CellContext`intersections = 
                    Block[{$CellContext`TempVar, $CellContext`TempVar1, \
$CellContext`TempVar2, $CellContext`TempVar3, $CellContext`RayL, \
$CellContext`SCx, $CellContext`SCy}, $CellContext`TempVar1 = 
                    1.; $CellContext`TempVar2 = 1.; $CellContext`TempVar3 = 
                    1.; $CellContext`TempVar = {{-1., 0., 
                    0.}}; $CellContext`RayL = 1.; $CellContext`SCx = 
                    1.; $CellContext`SCy = 
                    1.; $CellContext`TempVar1 = $CellContext`rx^2 + \
$CellContext`ry^2 + $CellContext`rz^2; $CellContext`TempVar2 = \
$CellContext`rx $CellContext`xunit + $CellContext`ry $CellContext`yunit + \
$CellContext`rz $CellContext`zunit - $CellContext`xunit/$CellContext`ca1; \
$CellContext`TempVar3 = -$CellContext`TempVar1 + $CellContext`TempVar2^2 + (
                    2 $CellContext`rx)/$CellContext`ca1; \
$CellContext`TempVar3 = Re[$CellContext`TempVar3]; If[N[
                    Chop[$CellContext`TempVar3]] >= 
                    0., $CellContext`TempVar3 = 
                    Sqrt[$CellContext`TempVar3]; $CellContext`TempVar = \
{{$CellContext`RayL, $CellContext`SCx, $CellContext`SCy} = \
{-$CellContext`TempVar2 - $CellContext`TempVar3, $CellContext`ry - \
($CellContext`TempVar2 + $CellContext`TempVar3) $CellContext`yunit, \
$CellContext`rz - ($CellContext`TempVar2 + $CellContext`TempVar3) \
$CellContext`zunit}; If[
                    And[N[
                    Chop[$CellContext`RayL]] >= 
                    0., $CellContext`SCx^2 + $CellContext`SCy^2 <= 
                    0.25 Abs[$CellContext`apa]^2, 
                    Abs[$CellContext`ry + $CellContext`RayL \
$CellContext`yunit - $CellContext`SCx] + 
                    Abs[$CellContext`rz + $CellContext`RayL \
$CellContext`zunit - $CellContext`SCy] + 
                    Abs[(-1)/$CellContext`ca1 + $CellContext`rx + \
$CellContext`RayL $CellContext`xunit + 
                    Sqrt[$CellContext`ca1^(-2) - $CellContext`SCx^2 - \
$CellContext`SCy^2]/Sign[$CellContext`ca1]] < 
                    1.*^-7], {$CellContext`RayL, $CellContext`SCx, \
$CellContext`SCy}, {-1., 0., 
                    0.}], {$CellContext`RayL, $CellContext`SCx, \
$CellContext`SCy} = {-$CellContext`TempVar2 + $CellContext`TempVar3, \
$CellContext`ry + (-$CellContext`TempVar2 + $CellContext`TempVar3) \
$CellContext`yunit, $CellContext`rz + (-$CellContext`TempVar2 + \
$CellContext`TempVar3) $CellContext`zunit}; If[
                    And[N[
                    Chop[$CellContext`RayL]] >= 
                    0., $CellContext`SCx^2 + $CellContext`SCy^2 <= 
                    0.25 Abs[$CellContext`apa]^2, 
                    Abs[$CellContext`ry + $CellContext`RayL \
$CellContext`yunit - $CellContext`SCx] + 
                    Abs[$CellContext`rz + $CellContext`RayL \
$CellContext`zunit - $CellContext`SCy] + 
                    Abs[(-1)/$CellContext`ca1 + $CellContext`rx + \
$CellContext`RayL $CellContext`xunit + 
                    Sqrt[$CellContext`ca1^(-2) - $CellContext`SCx^2 - \
$CellContext`SCy^2]/Sign[$CellContext`ca1]] < 
                    1.*^-7], {$CellContext`RayL, $CellContext`SCx, \
$CellContext`SCy}, {-1., 0., 0.}]}; 
                    If[Part[$CellContext`TempVar, 1] == 
                    Part[$CellContext`TempVar, 2], {
                    
                    Part[$CellContext`TempVar, 
                    1]}, $CellContext`TempVar], {{-1., 0., 0.}}]]; 
                    AppendTo[$CellContext`intersections, {-1., 0., 
                    0.}]; $CellContext`holeQ = False; If[
                    Or[
                    Not[
                    Or[Chop[$CellContext`surfaceid - 16519.] == 0., N[
                    Chop[$CellContext`ray1]] < 
                    0.0001]], $CellContext`generationnumber == 
                    1.], $CellContext`minresonateraylength = 
                    0., $CellContext`minresonateraylength = 0.0001]; 
                    Block[{$CellContext`RayL, $CellContext`SCx, \
$CellContext`SCy}, $CellContext`RayL = 1.; $CellContext`SCx = 
                    1.; $CellContext`SCy = 1.; $CellContext`dummymatrix = 
                    Union[
                    
                    Select[$CellContext`intersections, ({$CellContext`RayL, \
$CellContext`SCx, $CellContext`SCy} = #; 
                    Or[{$CellContext`RayL, $CellContext`SCx, \
$CellContext`SCy} == {-1., 0., 0.}, N[
                    
                    Chop[$CellContext`RayL]] >= \
$CellContext`minresonateraylength])& ]]; $CellContext`intersections = \
$CellContext`dummymatrix]; $CellContext`unfilteredintersections = \
$CellContext`intersections; 
                    If[Length[$CellContext`intersections] > 
                    1, $CellContext`dummymatrix = 
                    Take[$CellContext`intersections, {
                    2}]; $CellContext`intersections = \
$CellContext`dummymatrix; 1., 1.]; 
                    AppendTo[$CellContext`intersectionslist, \
$CellContext`intersections]; If[$CellContext`holeQ, 
                    AppendTo[$CellContext`holeQlist, 1], 
                    
                    AppendTo[$CellContext`holeQlist, 
                    0]]; {$CellContext`rsx, $CellContext`rsy, \
$CellContext`rsz, $CellContext`rex, $CellContext`rey, $CellContext`rez, \
$CellContext`r1, $CellContext`r2, $CellContext`r3, $CellContext`r4, \
$CellContext`r5, $CellContext`r6, $CellContext`r7, $CellContext`r8, \
$CellContext`r9, $CellContext`wavelength, $CellContext`intensity, \
$CellContext`intensityscale, $CellContext`ray1, $CellContext`index, \
$CellContext`opticallength, $CellContext`phaseshift, \
$CellContext`componentnumber, $CellContext`surfacenumber, \
$CellContext`surfaceid, $CellContext`ray2, $CellContext`ray3, \
$CellContext`sid, $CellContext`frontid, $CellContext`sno1, $CellContext`sno2, \
$CellContext`sno3, $CellContext`sno4, $CellContext`rayslot, \
$CellContext`oldgenerationnumber, $CellContext`intersectionnumber, \
$CellContext`pol1, $CellContext`pol2, $CellContext`pol3} = #; \
$CellContext`index1 = $CellContext`index; $CellContext`xunit = \
$CellContext`r1 Re[
                    Cos[
                    0.017453292519943295` $CellContext`aa]] + $CellContext`r2 
                    Re[
                    Sin[
                    0.017453292519943295` $CellContext`aa]]; \
$CellContext`yunit = $CellContext`r2 Re[
                    Cos[0.017453292519943295` $CellContext`aa]] - 
                    1. $CellContext`r1 Re[
                    Sin[
                    0.017453292519943295` $CellContext`aa]]; \
$CellContext`zunit = $CellContext`r3 
                    Re[Cos[0.017453292519943295` $CellContext`aa]^2 + 
                    Sin[0.017453292519943295` $CellContext`aa]^2]; \
$CellContext`xunit = Chop[$CellContext`xunit]; $CellContext`yunit = 
                    Chop[$CellContext`yunit]; $CellContext`zunit = 
                    Chop[$CellContext`zunit]; $CellContext`magnitude = \
($CellContext`xunit^2 + $CellContext`yunit^2 + $CellContext`zunit^2)^(
                    2^(-1)); $CellContext`xunit = \
$CellContext`xunit/$CellContext`magnitude; $CellContext`yunit = \
$CellContext`yunit/$CellContext`magnitude; $CellContext`zunit = \
$CellContext`zunit/$CellContext`magnitude; $CellContext`rx = Re[
                    Cos[
                    0.017453292519943295` $CellContext`aa]] ($CellContext`rex - 
                    1. Re[$CellContext`xa1 + $CellContext`ta 
                    Cos[0.017453292519943295` $CellContext`aa]]) + Re[
                    Sin[
                    0.017453292519943295` $CellContext`aa]] ($CellContext`rey - 
                    1. Re[$CellContext`ya1 + $CellContext`ta 
                    Sin[0.017453292519943295` $CellContext`aa]]); \
$CellContext`ry = -($CellContext`rex - 1. 
                    Re[$CellContext`xa1 + $CellContext`ta 
                    Cos[0.017453292519943295` $CellContext`aa]]) Re[
                    Sin[0.017453292519943295` $CellContext`aa]] + Re[
                    Cos[
                    0.017453292519943295` $CellContext`aa]] ($CellContext`rey - 
                    1. Re[$CellContext`ya1 + $CellContext`ta 
                    Sin[0.017453292519943295` $CellContext`aa]]); \
$CellContext`rz = $CellContext`rez 
                    Re[Cos[0.017453292519943295` $CellContext`aa]^2 + 
                    Sin[0.017453292519943295` $CellContext`aa]^2]; \
$CellContext`rx = Chop[$CellContext`rx]; $CellContext`ry = 
                    Chop[$CellContext`ry]; $CellContext`rz = 
                    Chop[$CellContext`rz]; $CellContext`terminatedeflection = 
                    False; $CellContext`intersections = {{-1., 0., 
                    0.}}; $CellContext`intersections = 
                    Block[{$CellContext`TempVar, $CellContext`TempVar1, \
$CellContext`TempVar2, $CellContext`TempVar3, $CellContext`RayL, \
$CellContext`SCx, $CellContext`SCy}, $CellContext`TempVar1 = 
                    1.; $CellContext`TempVar2 = 1.; $CellContext`TempVar3 = 
                    1.; $CellContext`TempVar = {{-1., 0., 
                    0.}}; $CellContext`RayL = 1.; $CellContext`SCx = 
                    1.; $CellContext`SCy = 
                    1.; $CellContext`TempVar1 = $CellContext`rx^2 + \
$CellContext`ry^2 + $CellContext`rz^2; $CellContext`TempVar2 = \
$CellContext`rx $CellContext`xunit + $CellContext`ry $CellContext`yunit + \
$CellContext`rz $CellContext`zunit - $CellContext`xunit/$CellContext`ca2; \
$CellContext`TempVar3 = -$CellContext`TempVar1 + $CellContext`TempVar2^2 + (
                    2 $CellContext`rx)/$CellContext`ca2; \
$CellContext`TempVar3 = Re[$CellContext`TempVar3]; If[N[
                    Chop[$CellContext`TempVar3]] >= 
                    0., $CellContext`TempVar3 = 
                    Sqrt[$CellContext`TempVar3]; $CellContext`TempVar = \
{{$CellContext`RayL, $CellContext`SCx, $CellContext`SCy} = \
{-$CellContext`TempVar2 - $CellContext`TempVar3, $CellContext`ry - \
($CellContext`TempVar2 + $CellContext`TempVar3) $CellContext`yunit, \
$CellContext`rz - ($CellContext`TempVar2 + $CellContext`TempVar3) \
$CellContext`zunit}; If[
                    And[N[
                    Chop[$CellContext`RayL]] >= 
                    0., $CellContext`SCx^2 + $CellContext`SCy^2 <= 
                    0.25 Abs[$CellContext`apa]^2, 
                    Abs[$CellContext`ry + $CellContext`RayL \
$CellContext`yunit - $CellContext`SCx] + 
                    Abs[$CellContext`rz + $CellContext`RayL \
$CellContext`zunit - $CellContext`SCy] + 
                    Abs[(-1)/$CellContext`ca2 + $CellContext`rx + \
$CellContext`RayL $CellContext`xunit + 
                    Sqrt[$CellContext`ca2^(-2) - $CellContext`SCx^2 - \
$CellContext`SCy^2]/Sign[$CellContext`ca2]] < 
                    1.*^-7], {$CellContext`RayL, $CellContext`SCx, \
$CellContext`SCy}, {-1., 0., 
                    0.}], {$CellContext`RayL, $CellContext`SCx, \
$CellContext`SCy} = {-$CellContext`TempVar2 + $CellContext`TempVar3, \
$CellContext`ry + (-$CellContext`TempVar2 + $CellContext`TempVar3) \
$CellContext`yunit, $CellContext`rz + (-$CellContext`TempVar2 + \
$CellContext`TempVar3) $CellContext`zunit}; If[
                    And[N[
                    Chop[$CellContext`RayL]] >= 
                    0., $CellContext`SCx^2 + $CellContext`SCy^2 <= 
                    0.25 Abs[$CellContext`apa]^2, 
                    Abs[$CellContext`ry + $CellContext`RayL \
$CellContext`yunit - $CellContext`SCx] + 
                    Abs[$CellContext`rz + $CellContext`RayL \
$CellContext`zunit - $CellContext`SCy] + 
                    Abs[(-1)/$CellContext`ca2 + $CellContext`rx + \
$CellContext`RayL $CellContext`xunit + 
                    Sqrt[$CellContext`ca2^(-2) - $CellContext`SCx^2 - \
$CellContext`SCy^2]/Sign[$CellContext`ca2]] < 
                    1.*^-7], {$CellContext`RayL, $CellContext`SCx, \
$CellContext`SCy}, {-1., 0., 0.}]}; 
                    If[Part[$CellContext`TempVar, 1] == 
                    Part[$CellContext`TempVar, 2], {
                    
                    Part[$CellContext`TempVar, 
                    1]}, $CellContext`TempVar], {{-1., 0., 0.}}]]; 
                    AppendTo[$CellContext`intersections, {-1., 0., 
                    0.}]; $CellContext`holeQ = False; If[
                    Or[
                    Not[
                    Or[Chop[$CellContext`surfaceid - 16520.] == 0., N[
                    Chop[$CellContext`ray1]] < 
                    0.0001]], $CellContext`generationnumber == 
                    1.], $CellContext`minresonateraylength = 
                    0., $CellContext`minresonateraylength = 0.0001]; 
                    Block[{$CellContext`RayL, $CellContext`SCx, \
$CellContext`SCy}, $CellContext`RayL = 1.; $CellContext`SCx = 
                    1.; $CellContext`SCy = 1.; $CellContext`dummymatrix = 
                    Union[
                    
                    Select[$CellContext`intersections, ({$CellContext`RayL, \
$CellContext`SCx, $CellContext`SCy} = #; 
                    Or[{$CellContext`RayL, $CellContext`SCx, \
$CellContext`SCy} == {-1., 0., 0.}, N[
                    
                    Chop[$CellContext`RayL]] >= \
$CellContext`minresonateraylength])& ]]; $CellContext`intersections = \
$CellContext`dummymatrix]; $CellContext`unfilteredintersections = \
$CellContext`intersections; 
                    If[Length[$CellContext`intersections] > 
                    1, $CellContext`dummymatrix = 
                    Take[$CellContext`intersections, {
                    2}]; $CellContext`intersections = \
$CellContext`dummymatrix; 1., 1.]; 
                    AppendTo[$CellContext`intersectionslist, \
$CellContext`intersections]; If[$CellContext`holeQ, 
                    AppendTo[$CellContext`holeQlist, 1], 
                    
                    AppendTo[$CellContext`holeQlist, 
                    0]]; {$CellContext`rsx, $CellContext`rsy, \
$CellContext`rsz, $CellContext`rex, $CellContext`rey, $CellContext`rez, \
$CellContext`r1, $CellContext`r2, $CellContext`r3, $CellContext`r4, \
$CellContext`r5, $CellContext`r6, $CellContext`r7, $CellContext`r8, \
$CellContext`r9, $CellContext`wavelength, $CellContext`intensity, \
$CellContext`intensityscale, $CellContext`ray1, $CellContext`index, \
$CellContext`opticallength, $CellContext`phaseshift, \
$CellContext`componentnumber, $CellContext`surfacenumber, \
$CellContext`surfaceid, $CellContext`ray2, $CellContext`ray3, \
$CellContext`sid, $CellContext`frontid, $CellContext`sno1, $CellContext`sno2, \
$CellContext`sno3, $CellContext`sno4, $CellContext`rayslot, \
$CellContext`oldgenerationnumber, $CellContext`intersectionnumber, \
$CellContext`pol1, $CellContext`pol2, $CellContext`pol3} = #; \
$CellContext`index1 = $CellContext`index; $CellContext`xunit = \
$CellContext`r1 Re[
                    Cos[
                    0.017453292519943295` $CellContext`ab]] + $CellContext`r2 
                    Re[
                    Sin[
                    0.017453292519943295` $CellContext`ab]]; \
$CellContext`yunit = $CellContext`r2 Re[
                    Cos[0.017453292519943295` $CellContext`ab]] - 
                    1. $CellContext`r1 Re[
                    Sin[
                    0.017453292519943295` $CellContext`ab]]; \
$CellContext`zunit = $CellContext`r3 
                    Re[Cos[0.017453292519943295` $CellContext`ab]^2 + 
                    Sin[0.017453292519943295` $CellContext`ab]^2]; \
$CellContext`xunit = Chop[$CellContext`xunit]; $CellContext`yunit = 
                    Chop[$CellContext`yunit]; $CellContext`zunit = 
                    Chop[$CellContext`zunit]; $CellContext`magnitude = \
($CellContext`xunit^2 + $CellContext`yunit^2 + $CellContext`zunit^2)^(
                    2^(-1)); $CellContext`xunit = \
$CellContext`xunit/$CellContext`magnitude; $CellContext`yunit = \
$CellContext`yunit/$CellContext`magnitude; $CellContext`zunit = \
$CellContext`zunit/$CellContext`magnitude; $CellContext`rx = \
($CellContext`rex - 1. Re[$CellContext`xb1]) Re[
                    Cos[
                    0.017453292519943295` $CellContext`ab]] + \
($CellContext`rey - 1. Re[$CellContext`yb1]) Re[
                    Sin[
                    0.017453292519943295` $CellContext`ab]]; $CellContext`ry = \
($CellContext`rey - 1. Re[$CellContext`yb1]) Re[
                    Cos[0.017453292519943295` $CellContext`ab]] - 
                    1. ($CellContext`rex - 1. Re[$CellContext`xb1]) Re[
                    Sin[
                    0.017453292519943295` $CellContext`ab]]; $CellContext`rz = \
$CellContext`rez Re[Cos[0.017453292519943295` $CellContext`ab]^2 + 
                    Sin[0.017453292519943295` $CellContext`ab]^2]; \
$CellContext`rx = Chop[$CellContext`rx]; $CellContext`ry = 
                    Chop[$CellContext`ry]; $CellContext`rz = 
                    Chop[$CellContext`rz]; $CellContext`terminatedeflection = 
                    False; $CellContext`intersections = {{-1., 0., 
                    0.}}; $CellContext`intersections = 
                    Block[{$CellContext`TempVar, $CellContext`TempVar1, \
$CellContext`TempVar2, $CellContext`TempVar3, $CellContext`RayL, \
$CellContext`SCx, $CellContext`SCy}, $CellContext`TempVar1 = 
                    1.; $CellContext`TempVar2 = 1.; $CellContext`TempVar3 = 
                    1.; $CellContext`TempVar = {{-1., 0., 
                    0.}}; $CellContext`RayL = 1.; $CellContext`SCx = 
                    1.; $CellContext`SCy = 
                    1.; $CellContext`TempVar1 = $CellContext`rx^2 + \
$CellContext`ry^2 + $CellContext`rz^2; $CellContext`TempVar2 = \
$CellContext`rx $CellContext`xunit + $CellContext`ry $CellContext`yunit + \
$CellContext`rz $CellContext`zunit - $CellContext`xunit/$CellContext`cb1; \
$CellContext`TempVar3 = -$CellContext`TempVar1 + $CellContext`TempVar2^2 + (
                    2 $CellContext`rx)/$CellContext`cb1; \
$CellContext`TempVar3 = Re[$CellContext`TempVar3]; If[N[
                    Chop[$CellContext`TempVar3]] >= 
                    0., $CellContext`TempVar3 = 
                    Sqrt[$CellContext`TempVar3]; $CellContext`TempVar = \
{{$CellContext`RayL, $CellContext`SCx, $CellContext`SCy} = \
{-$CellContext`TempVar2 - $CellContext`TempVar3, $CellContext`ry - \
($CellContext`TempVar2 + $CellContext`TempVar3) $CellContext`yunit, \
$CellContext`rz - ($CellContext`TempVar2 + $CellContext`TempVar3) \
$CellContext`zunit}; If[
                    And[N[
                    Chop[$CellContext`RayL]] >= 
                    0., $CellContext`SCx^2 + $CellContext`SCy^2 <= 
                    0.25 Abs[$CellContext`apb]^2, 
                    Abs[$CellContext`ry + $CellContext`RayL \
$CellContext`yunit - $CellContext`SCx] + 
                    Abs[$CellContext`rz + $CellContext`RayL \
$CellContext`zunit - $CellContext`SCy] + 
                    Abs[(-1)/$CellContext`cb1 + $CellContext`rx + \
$CellContext`RayL $CellContext`xunit + 
                    Sqrt[$CellContext`cb1^(-2) - $CellContext`SCx^2 - \
$CellContext`SCy^2]/Sign[$CellContext`cb1]] < 
                    1.*^-7], {$CellContext`RayL, $CellContext`SCx, \
$CellContext`SCy}, {-1., 0., 
                    0.}], {$CellContext`RayL, $CellContext`SCx, \
$CellContext`SCy} = {-$CellContext`TempVar2 + $CellContext`TempVar3, \
$CellContext`ry + (-$CellContext`TempVar2 + $CellContext`TempVar3) \
$CellContext`yunit, $CellContext`rz + (-$CellContext`TempVar2 + \
$CellContext`TempVar3) $CellContext`zunit}; If[
                    And[N[
                    Chop[$CellContext`RayL]] >= 
                    0., $CellContext`SCx^2 + $CellContext`SCy^2 <= 
                    0.25 Abs[$CellContext`apb]^2, 
                    Abs[$CellContext`ry + $CellContext`RayL \
$CellContext`yunit - $CellContext`SCx] + 
                    Abs[$CellContext`rz + $CellContext`RayL \
$CellContext`zunit - $CellContext`SCy] + 
                    Abs[(-1)/$CellContext`cb1 + $CellContext`rx + \
$CellContext`RayL $CellContext`xunit + 
                    Sqrt[$CellContext`cb1^(-2) - $CellContext`SCx^2 - \
$CellContext`SCy^2]/Sign[$CellContext`cb1]] < 
                    1.*^-7], {$CellContext`RayL, $CellContext`SCx, \
$CellContext`SCy}, {-1., 0., 0.}]}; 
                    If[Part[$CellContext`TempVar, 1] == 
                    Part[$CellContext`TempVar, 2], {
                    
                    Part[$CellContext`TempVar, 
                    1]}, $CellContext`TempVar], {{-1., 0., 0.}}]]; 
                    AppendTo[$CellContext`intersections, {-1., 0., 
                    0.}]; $CellContext`holeQ = False; If[
                    Or[
                    Not[
                    Or[Chop[$CellContext`surfaceid - 16547.] == 0., N[
                    Chop[$CellContext`ray1]] < 
                    0.0001]], $CellContext`generationnumber == 
                    1.], $CellContext`minresonateraylength = 
                    0., $CellContext`minresonateraylength = 0.0001]; 
                    Block[{$CellContext`RayL, $CellContext`SCx, \
$CellContext`SCy}, $CellContext`RayL = 1.; $CellContext`SCx = 
                    1.; $CellContext`SCy = 1.; $CellContext`dummymatrix = 
                    Union[
                    
                    Select[$CellContext`intersections, ({$CellContext`RayL, \
$CellContext`SCx, $CellContext`SCy} = #; 
                    Or[{$CellContext`RayL, $CellContext`SCx, \
$CellContext`SCy} == {-1., 0., 0.}, N[
                    
                    Chop[$CellContext`RayL]] >= \
$CellContext`minresonateraylength])& ]]; $CellContext`intersections = \
$CellContext`dummymatrix]; $CellContext`unfilteredintersections = \
$CellContext`intersections; 
                    If[Length[$CellContext`intersections] > 
                    1, $CellContext`dummymatrix = 
                    Take[$CellContext`intersections, {
                    2}]; $CellContext`intersections = \
$CellContext`dummymatrix; 1., 1.]; 
                    AppendTo[$CellContext`intersectionslist, \
$CellContext`intersections]; If[$CellContext`holeQ, 
                    AppendTo[$CellContext`holeQlist, 1], 
                    
                    AppendTo[$CellContext`holeQlist, 
                    0]]; {$CellContext`rsx, $CellContext`rsy, \
$CellContext`rsz, $CellContext`rex, $CellContext`rey, $CellContext`rez, \
$CellContext`r1, $CellContext`r2, $CellContext`r3, $CellContext`r4, \
$CellContext`r5, $CellContext`r6, $CellContext`r7, $CellContext`r8, \
$CellContext`r9, $CellContext`wavelength, $CellContext`intensity, \
$CellContext`intensityscale, $CellContext`ray1, $CellContext`index, \
$CellContext`opticallength, $CellContext`phaseshift, \
$CellContext`componentnumber, $CellContext`surfacenumber, \
$CellContext`surfaceid, $CellContext`ray2, $CellContext`ray3, \
$CellContext`sid, $CellContext`frontid, $CellContext`sno1, $CellContext`sno2, \
$CellContext`sno3, $CellContext`sno4, $CellContext`rayslot, \
$CellContext`oldgenerationnumber, $CellContext`intersectionnumber, \
$CellContext`pol1, $CellContext`pol2, $CellContext`pol3} = #; \
$CellContext`index1 = $CellContext`index; $CellContext`xunit = \
$CellContext`r1 Re[
                    Cos[
                    0.017453292519943295` $CellContext`ab]] + $CellContext`r2 
                    Re[
                    Sin[
                    0.017453292519943295` $CellContext`ab]]; \
$CellContext`yunit = $CellContext`r2 Re[
                    Cos[0.017453292519943295` $CellContext`ab]] - 
                    1. $CellContext`r1 Re[
                    Sin[
                    0.017453292519943295` $CellContext`ab]]; \
$CellContext`zunit = $CellContext`r3 
                    Re[Cos[0.017453292519943295` $CellContext`ab]^2 + 
                    Sin[0.017453292519943295` $CellContext`ab]^2]; \
$CellContext`xunit = Chop[$CellContext`xunit]; $CellContext`yunit = 
                    Chop[$CellContext`yunit]; $CellContext`zunit = 
                    Chop[$CellContext`zunit]; $CellContext`magnitude = \
($CellContext`xunit^2 + $CellContext`yunit^2 + $CellContext`zunit^2)^(
                    2^(-1)); $CellContext`xunit = \
$CellContext`xunit/$CellContext`magnitude; $CellContext`yunit = \
$CellContext`yunit/$CellContext`magnitude; $CellContext`zunit = \
$CellContext`zunit/$CellContext`magnitude; $CellContext`rx = Re[
                    Cos[
                    0.017453292519943295` $CellContext`ab]] ($CellContext`rex - 
                    1. Re[$CellContext`xb1 + $CellContext`tb 
                    Cos[0.017453292519943295` $CellContext`ab]]) + Re[
                    Sin[
                    0.017453292519943295` $CellContext`ab]] ($CellContext`rey - 
                    1. Re[$CellContext`yb1 + $CellContext`tb 
                    Sin[0.017453292519943295` $CellContext`ab]]); \
$CellContext`ry = -($CellContext`rex - 1. 
                    Re[$CellContext`xb1 + $CellContext`tb 
                    Cos[0.017453292519943295` $CellContext`ab]]) Re[
                    Sin[0.017453292519943295` $CellContext`ab]] + Re[
                    Cos[
                    0.017453292519943295` $CellContext`ab]] ($CellContext`rey - 
                    1. Re[$CellContext`yb1 + $CellContext`tb 
                    Sin[0.017453292519943295` $CellContext`ab]]); \
$CellContext`rz = $CellContext`rez 
                    Re[Cos[0.017453292519943295` $CellContext`ab]^2 + 
                    Sin[0.017453292519943295` $CellContext`ab]^2]; \
$CellContext`rx = Chop[$CellContext`rx]; $CellContext`ry = 
                    Chop[$CellContext`ry]; $CellContext`rz = 
                    Chop[$CellContext`rz]; $CellContext`terminatedeflection = 
                    False; $CellContext`intersections = {{-1., 0., 
                    0.}}; $CellContext`intersections = 
                    Block[{$CellContext`TempVar, $CellContext`TempVar1, \
$CellContext`TempVar2, $CellContext`TempVar3, $CellContext`RayL, \
$CellContext`SCx, $CellContext`SCy}, $CellContext`TempVar1 = 
                    1.; $CellContext`TempVar2 = 1.; $CellContext`TempVar3 = 
                    1.; $CellContext`TempVar = {{-1., 0., 
                    0.}}; $CellContext`RayL = 1.; $CellContext`SCx = 
                    1.; $CellContext`SCy = 
                    1.; $CellContext`TempVar1 = $CellContext`rx^2 + \
$CellContext`ry^2 + $CellContext`rz^2; $CellContext`TempVar2 = \
$CellContext`rx $CellContext`xunit + $CellContext`ry $CellContext`yunit + \
$CellContext`rz $CellContext`zunit - $CellContext`xunit/$CellContext`cb2; \
$CellContext`TempVar3 = -$CellContext`TempVar1 + $CellContext`TempVar2^2 + (
                    2 $CellContext`rx)/$CellContext`cb2; \
$CellContext`TempVar3 = Re[$CellContext`TempVar3]; If[N[
                    Chop[$CellContext`TempVar3]] >= 
                    0., $CellContext`TempVar3 = 
                    Sqrt[$CellContext`TempVar3]; $CellContext`TempVar = \
{{$CellContext`RayL, $CellContext`SCx, $CellContext`SCy} = \
{-$CellContext`TempVar2 - $CellContext`TempVar3, $CellContext`ry - \
($CellContext`TempVar2 + $CellContext`TempVar3) $CellContext`yunit, \
$CellContext`rz - ($CellContext`TempVar2 + $CellContext`TempVar3) \
$CellContext`zunit}; If[
                    And[N[
                    Chop[$CellContext`RayL]] >= 
                    0., $CellContext`SCx^2 + $CellContext`SCy^2 <= 
                    0.25 Abs[$CellContext`apb]^2, 
                    Abs[$CellContext`ry + $CellContext`RayL \
$CellContext`yunit - $CellContext`SCx] + 
                    Abs[$CellContext`rz + $CellContext`RayL \
$CellContext`zunit - $CellContext`SCy] + 
                    Abs[(-1)/$CellContext`cb2 + $CellContext`rx + \
$CellContext`RayL $CellContext`xunit + 
                    Sqrt[$CellContext`cb2^(-2) - $CellContext`SCx^2 - \
$CellContext`SCy^2]/Sign[$CellContext`cb2]] < 
                    1.*^-7], {$CellContext`RayL, $CellContext`SCx, \
$CellContext`SCy}, {-1., 0., 
                    0.}], {$CellContext`RayL, $CellContext`SCx, \
$CellContext`SCy} = {-$CellContext`TempVar2 + $CellContext`TempVar3, \
$CellContext`ry + (-$CellContext`TempVar2 + $CellContext`TempVar3) \
$CellContext`yunit, $CellContext`rz + (-$CellContext`TempVar2 + \
$CellContext`TempVar3) $CellContext`zunit}; If[
                    And[N[
                    Chop[$CellContext`RayL]] >= 
                    0., $CellContext`SCx^2 + $CellContext`SCy^2 <= 
                    0.25 Abs[$CellContext`apb]^2, 
                    Abs[$CellContext`ry + $CellContext`RayL \
$CellContext`yunit - $CellContext`SCx] + 
                    Abs[$CellContext`rz + $CellContext`RayL \
$CellContext`zunit - $CellContext`SCy] + 
                    Abs[(-1)/$CellContext`cb2 + $CellContext`rx + \
$CellContext`RayL $CellContext`xunit + 
                    Sqrt[$CellContext`cb2^(-2) - $CellContext`SCx^2 - \
$CellContext`SCy^2]/Sign[$CellContext`cb2]] < 
                    1.*^-7], {$CellContext`RayL, $CellContext`SCx, \
$CellContext`SCy}, {-1., 0., 0.}]}; 
                    If[Part[$CellContext`TempVar, 1] == 
                    Part[$CellContext`TempVar, 2], {
                    
                    Part[$CellContext`TempVar, 
                    1]}, $CellContext`TempVar], {{-1., 0., 0.}}]]; 
                    AppendTo[$CellContext`intersections, {-1., 0., 
                    0.}]; $CellContext`holeQ = False; If[
                    Or[
                    Not[
                    Or[Chop[$CellContext`surfaceid - 16548.] == 0., N[
                    Chop[$CellContext`ray1]] < 
                    0.0001]], $CellContext`generationnumber == 
                    1.], $CellContext`minresonateraylength = 
                    0., $CellContext`minresonateraylength = 0.0001]; 
                    Block[{$CellContext`RayL, $CellContext`SCx, \
$CellContext`SCy}, $CellContext`RayL = 1.; $CellContext`SCx = 
                    1.; $CellContext`SCy = 1.; $CellContext`dummymatrix = 
                    Union[
                    
                    Select[$CellContext`intersections, ({$CellContext`RayL, \
$CellContext`SCx, $CellContext`SCy} = #; 
                    Or[{$CellContext`RayL, $CellContext`SCx, \
$CellContext`SCy} == {-1., 0., 0.}, N[
                    
                    Chop[$CellContext`RayL]] >= \
$CellContext`minresonateraylength])& ]]; $CellContext`intersections = \
$CellContext`dummymatrix]; $CellContext`unfilteredintersections = \
$CellContext`intersections; 
                    If[Length[$CellContext`intersections] > 
                    1, $CellContext`dummymatrix = 
                    Take[$CellContext`intersections, {
                    2}]; $CellContext`intersections = \
$CellContext`dummymatrix; 1., 1.]; 
                    AppendTo[$CellContext`intersectionslist, \
$CellContext`intersections]; If[$CellContext`holeQ, 
                    AppendTo[$CellContext`holeQlist, 1], 
                    
                    AppendTo[$CellContext`holeQlist, 
                    0]]); $CellContext`holeQlist = 
                    Drop[$CellContext`holeQlist, 1]; 
                    Drop[$CellContext`intersectionslist, 1]]); 
                    Which[$CellContext`resonatenumber == 
                    1, {$CellContext`rsx, $CellContext`rsy, $CellContext`rsz, \
$CellContext`rex, $CellContext`rey, $CellContext`rez, $CellContext`r1, \
$CellContext`r2, $CellContext`r3, $CellContext`r4, $CellContext`r5, \
$CellContext`r6, $CellContext`r7, $CellContext`r8, $CellContext`r9, \
$CellContext`wavelength, $CellContext`intensity, $CellContext`intensityscale, \
$CellContext`ray1, $CellContext`index, $CellContext`opticallength, \
$CellContext`phaseshift, $CellContext`componentnumber, \
$CellContext`surfacenumber, $CellContext`surfaceid, $CellContext`ray2, \
$CellContext`ray3, $CellContext`sid, $CellContext`frontid, $CellContext`sno1, \
$CellContext`sno2, $CellContext`sno3, $CellContext`sno4, \
$CellContext`rayslot, $CellContext`oldgenerationnumber, \
$CellContext`intersectionnumber, $CellContext`pol1, $CellContext`pol2, \
$CellContext`pol3} = #; $CellContext`index1 = $CellContext`index; \
$CellContext`xunit = $CellContext`r1 Re[
                    Cos[
                    0.017453292519943295` $CellContext`aa]] + $CellContext`r2 
                    Re[
                    Sin[
                    0.017453292519943295` $CellContext`aa]]; \
$CellContext`yunit = $CellContext`r2 Re[
                    Cos[0.017453292519943295` $CellContext`aa]] - 
                    1. $CellContext`r1 Re[
                    Sin[
                    0.017453292519943295` $CellContext`aa]]; \
$CellContext`zunit = $CellContext`r3 
                    Re[Cos[0.017453292519943295` $CellContext`aa]^2 + 
                    Sin[0.017453292519943295` $CellContext`aa]^2]; \
$CellContext`xunit = Chop[$CellContext`xunit]; $CellContext`yunit = 
                    Chop[$CellContext`yunit]; $CellContext`zunit = 
                    Chop[$CellContext`zunit]; $CellContext`magnitude = \
($CellContext`xunit^2 + $CellContext`yunit^2 + $CellContext`zunit^2)^(
                    
                    2^(-1)); $CellContext`xunit = \
$CellContext`xunit/$CellContext`magnitude; $CellContext`yunit = \
$CellContext`yunit/$CellContext`magnitude; $CellContext`zunit = \
$CellContext`zunit/$CellContext`magnitude; $CellContext`rx = \
($CellContext`rex - 1. Re[$CellContext`xa1]) Re[
                    Cos[
                    0.017453292519943295` $CellContext`aa]] + \
($CellContext`rey - 1. Re[$CellContext`ya1]) Re[
                    Sin[
                    0.017453292519943295` $CellContext`aa]]; $CellContext`ry = \
($CellContext`rey - 1. Re[$CellContext`ya1]) Re[
                    Cos[0.017453292519943295` $CellContext`aa]] - 
                    1. ($CellContext`rex - 1. Re[$CellContext`xa1]) Re[
                    Sin[
                    0.017453292519943295` $CellContext`aa]]; $CellContext`rz = \
$CellContext`rez Re[Cos[0.017453292519943295` $CellContext`aa]^2 + 
                    Sin[0.017453292519943295` $CellContext`aa]^2]; \
$CellContext`rx = Chop[$CellContext`rx]; $CellContext`ry = 
                    Chop[$CellContext`ry]; $CellContext`rz = 
                    Chop[$CellContext`rz]; $CellContext`terminatedeflection = 
                    False; $CellContext`intersections = {{-1., 0., 
                    0.}}; $CellContext`intersections = \
$CellContext`resonateintersections; $CellContext`holeQ = 
                    Part[$CellContext`holeQlist, $CellContext`resonatenumber] == 
                    1; {$CellContext`newcomponentnumber, \
$CellContext`newsurfacenumber, $CellContext`newsurfaceid} = {1., 1., 
                    16519.}; {$CellContext`componentnumber, \
$CellContext`surfacenumber, $CellContext`surfaceid} = {1., 1., 
                    16519.}; {$CellContext`ray1, $CellContext`ray2, \
$CellContext`ray3} = Part[$CellContext`intersections, 
                    1]; $CellContext`rsx = $CellContext`rex; $CellContext`rsy = \
$CellContext`rey; $CellContext`rsz = $CellContext`rez; $CellContext`rxhlp = \
$CellContext`rx + $CellContext`ray1 $CellContext`xunit; $CellContext`ryhlp = \
$CellContext`ry + $CellContext`ray1 $CellContext`yunit; $CellContext`rzhlp = \
$CellContext`rz + $CellContext`ray1 $CellContext`zunit; $CellContext`rex = 
                    Re[$CellContext`xa1] + $CellContext`rxhlp Re[
                    Cos[0.017453292519943295` $CellContext`aa]] - 
                    1. $CellContext`ryhlp Re[
                    Sin[
                    0.017453292519943295` $CellContext`aa]]; $CellContext`rey = 
                    Re[$CellContext`ya1] + $CellContext`ryhlp Re[
                    Cos[
                    0.017453292519943295` $CellContext`aa]] + \
$CellContext`rxhlp Re[
                    Sin[
                    0.017453292519943295` $CellContext`aa]]; $CellContext`rez = \
$CellContext`rzhlp Re[Cos[0.017453292519943295` $CellContext`aa]^2 + 
                    Sin[0.017453292519943295` $CellContext`aa]^2]; \
$CellContext`rex = Chop[$CellContext`rex]; $CellContext`rey = 
                    Chop[$CellContext`rey]; $CellContext`rez = 
                    Chop[$CellContext`rez]; If[
                    
                    And[$CellContext`rex == 0, $CellContext`rey == 
                    0, $CellContext`rez == 
                    0], $CellContext`rex = $CellContext`rxhlp + 
                    Re[$CellContext`xa1]; $CellContext`rey = \
$CellContext`ryhlp + 
                    Re[$CellContext`ya1]; $CellContext`rez = \
$CellContext`rzhlp, $CellContext`rex]; $CellContext`intersectionnumber = \
$CellContext`intersectionnumber + 
                    1.; $CellContext`opticallength = \
$CellContext`opticallength + $CellContext`ray1 $CellContext`index1; \
$CellContext`completedray = {$CellContext`rsx, $CellContext`rsy, \
$CellContext`rsz, $CellContext`rex, $CellContext`rey, $CellContext`rez, \
$CellContext`r1, $CellContext`r2, $CellContext`r3, $CellContext`r4, \
$CellContext`r5, $CellContext`r6, $CellContext`r7, $CellContext`r8, \
$CellContext`r9, $CellContext`wavelength, $CellContext`intensity, \
$CellContext`intensityscale, $CellContext`ray1, $CellContext`index, \
$CellContext`opticallength, $CellContext`phaseshift, \
$CellContext`componentnumber, $CellContext`surfacenumber, \
$CellContext`surfaceid, $CellContext`ray2, $CellContext`ray3, \
$CellContext`sid, $CellContext`frontid, $CellContext`sno1, $CellContext`sno2, \
$CellContext`sno3, $CellContext`sno4, $CellContext`rayslot, \
$CellContext`generationnumber, $CellContext`intersectionnumber, \
$CellContext`pol1, $CellContext`pol2, $CellContext`pol3}; \
$CellContext`reportedrayspresent = True; $CellContext`intersectionspresent = 
                    True; $CellContext`deflectedrayspresent = 
                    True; $CellContext`localdummyoutrayspresent = 
                    True; ($CellContext`surfnorm = 
                    1. Re[{{1., -(($CellContext`ray2/
                    Sign[$CellContext`ca1])/($CellContext`ca1^(-2) - 
                    1. $CellContext`ray2^2 - 
                    1. $CellContext`ray3^2)^0.5), -(($CellContext`ray3/
                    Sign[$CellContext`ca1])/($CellContext`ca1^(-2) - 
                    1. $CellContext`ray2^2 - 
                    1. $CellContext`ray3^2)^0.5)}, {($CellContext`ray2/
                    Sign[$CellContext`ca1])/($CellContext`ca1^(-2) - 
                    1. $CellContext`ray2^2 - 1. $CellContext`ray3^2)^0.5, 1., 
                    0.}, {($CellContext`ray3/
                    Sign[$CellContext`ca1])/($CellContext`ca1^(-2) - 
                    1. $CellContext`ray2^2 - 1. $CellContext`ray3^2)^0.5, 0., 
                    1.}}]; $CellContext`dummymatrix = Map[Dot[{{(Re[
                    Cos[0.017453292519943295` $CellContext`aa]] 
                    Re[Cos[0.017453292519943295` $CellContext`aa]^2 + 
                    Sin[0.017453292519943295` $CellContext`aa]^2])/(Re[
                    Cos[0.017453292519943295` $CellContext`aa]]^2 
                    Re[Cos[0.017453292519943295` $CellContext`aa]^2 + 
                    Sin[0.017453292519943295` $CellContext`aa]^2] + Re[
                    Sin[0.017453292519943295` $CellContext`aa]]^2 
                    Re[Cos[0.017453292519943295` $CellContext`aa]^2 + 
                    Sin[0.017453292519943295` $CellContext`aa]^2]), (-Re[
                    Sin[0.017453292519943295` $CellContext`aa]] 
                    Re[Cos[0.017453292519943295` $CellContext`aa]^2 + 
                    Sin[0.017453292519943295` $CellContext`aa]^2])/(Re[
                    Cos[0.017453292519943295` $CellContext`aa]]^2 
                    Re[Cos[0.017453292519943295` $CellContext`aa]^2 + 
                    Sin[0.017453292519943295` $CellContext`aa]^2] + Re[
                    Sin[0.017453292519943295` $CellContext`aa]]^2 
                    Re[Cos[0.017453292519943295` $CellContext`aa]^2 + 
                    Sin[0.017453292519943295` $CellContext`aa]^2]), 
                    0.}, {(Re[
                    Sin[0.017453292519943295` $CellContext`aa]] 
                    Re[Cos[0.017453292519943295` $CellContext`aa]^2 + 
                    Sin[0.017453292519943295` $CellContext`aa]^2])/(Re[
                    Cos[0.017453292519943295` $CellContext`aa]]^2 
                    Re[Cos[0.017453292519943295` $CellContext`aa]^2 + 
                    Sin[0.017453292519943295` $CellContext`aa]^2] + Re[
                    Sin[0.017453292519943295` $CellContext`aa]]^2 
                    Re[Cos[0.017453292519943295` $CellContext`aa]^2 + 
                    Sin[0.017453292519943295` $CellContext`aa]^2]), (Re[
                    Cos[0.017453292519943295` $CellContext`aa]] 
                    Re[Cos[0.017453292519943295` $CellContext`aa]^2 + 
                    Sin[0.017453292519943295` $CellContext`aa]^2])/(Re[
                    Cos[0.017453292519943295` $CellContext`aa]]^2 
                    Re[Cos[0.017453292519943295` $CellContext`aa]^2 + 
                    Sin[0.017453292519943295` $CellContext`aa]^2] + Re[
                    Sin[0.017453292519943295` $CellContext`aa]]^2 
                    Re[Cos[0.017453292519943295` $CellContext`aa]^2 + 
                    Sin[0.017453292519943295` $CellContext`aa]^2]), 0.}, {
                    0., 0., (Re[
                    Cos[0.017453292519943295` $CellContext`aa]]^2 + Re[
                    Sin[0.017453292519943295` $CellContext`aa]]^2)/(Re[
                    Cos[0.017453292519943295` $CellContext`aa]]^2 
                    Re[Cos[0.017453292519943295` $CellContext`aa]^2 + 
                    Sin[0.017453292519943295` $CellContext`aa]^2] + Re[
                    Sin[0.017453292519943295` $CellContext`aa]]^2 
                    Re[Cos[0.017453292519943295` $CellContext`aa]^2 + 
                    Sin[0.017453292519943295` $CellContext`aa]^2])}}, #]& , \
$CellContext`surfnorm]; $CellContext`surfnorm = Map[#/Sqrt[
                    
                    Dot[#, #]]& , $CellContext`dummymatrix]; \
$CellContext`surfacerotationmatrix = {{
                    Re[
                    Cos[0.017453292519943295` $CellContext`aa]], 
                    Re[
                    Sin[0.017453292519943295` $CellContext`aa]], 0.}, {-Re[
                    Sin[0.017453292519943295` $CellContext`aa]], 
                    Re[
                    Cos[0.017453292519943295` $CellContext`aa]], 0.}, {0., 0., 
                    Re[
                    Cos[0.017453292519943295` $CellContext`aa]^2 + 
                    Sin[0.017453292519943295` $CellContext`aa]^2]}}; \
$CellContext`surfacetranslationvector = {
                    Re[$CellContext`xa1], 
                    Re[$CellContext`ya1], 0.}; $CellContext`activeregion = 
                    1.; $CellContext`completedray = {$CellContext`rsx, \
$CellContext`rsy, $CellContext`rsz, $CellContext`rex, $CellContext`rey, \
$CellContext`rez, $CellContext`r1, $CellContext`r2, $CellContext`r3, \
$CellContext`r4, $CellContext`r5, $CellContext`r6, $CellContext`r7, \
$CellContext`r8, $CellContext`r9, $CellContext`wavelength, \
$CellContext`intensity, $CellContext`intensityscale, $CellContext`ray1, \
$CellContext`index, $CellContext`opticallength, $CellContext`phaseshift, \
$CellContext`componentnumber, $CellContext`surfacenumber, \
$CellContext`surfaceid, $CellContext`ray2, $CellContext`ray3, \
$CellContext`sid, $CellContext`frontid, $CellContext`sno1, $CellContext`sno2, \
$CellContext`sno3, $CellContext`sno4, $CellContext`rayslot, \
$CellContext`generationnumber, $CellContext`intersectionnumber, \
$CellContext`pol1, $CellContext`pol2, $CellContext`pol3}; \
$CellContext`componentnumber = $CellContext`newcomponentnumber; \
$CellContext`surfacenumber = $CellContext`newsurfacenumber; \
$CellContext`surfaceid = $CellContext`newsurfaceid; $CellContext`originalray = \
{$CellContext`rsx, $CellContext`rsy, $CellContext`rsz, $CellContext`rex, \
$CellContext`rey, $CellContext`rez, $CellContext`r1, $CellContext`r2, \
$CellContext`r3, $CellContext`r4, $CellContext`r5, $CellContext`r6, \
$CellContext`r7, $CellContext`r8, $CellContext`r9, $CellContext`wavelength, \
$CellContext`intensity, $CellContext`intensityscale, $CellContext`ray1, \
$CellContext`index, $CellContext`opticallength, $CellContext`phaseshift, \
$CellContext`componentnumber, $CellContext`surfacenumber, \
$CellContext`surfaceid, $CellContext`ray2, $CellContext`ray3, \
$CellContext`sid, $CellContext`frontid, $CellContext`sno1, $CellContext`sno2, \
$CellContext`sno3, $CellContext`sno4, $CellContext`rayslot, \
$CellContext`generationnumber, $CellContext`intersectionnumber, \
$CellContext`pol1, $CellContext`pol2, $CellContext`pol3}; $CellContext`ZAxis = 
                    First[$CellContext`surfnorm] Sign[
                    Dot[
                    
                    First[$CellContext`surfnorm], {$CellContext`r1, \
$CellContext`r2, $CellContext`r3}]]; $CellContext`raytiltz = 
                    Dot[$CellContext`ZAxis, {$CellContext`r1, \
$CellContext`r2, $CellContext`r3}]; $CellContext`raytiltx = 
                    1 - $CellContext`raytiltz^2; 
                    If[$CellContext`raytiltx < 
                    2.220446049250313*^-16, $CellContext`raytiltx = 
                    0., $CellContext`raytiltx = 
                    Sqrt[$CellContext`raytiltx]]; $CellContext`XAxis = \
{$CellContext`r1, $CellContext`r2, $CellContext`r3} - $CellContext`ZAxis \
$CellContext`raytiltz; If[
                    Abs[$CellContext`raytiltx] < 1.*^-7, $CellContext`XAxis = 
                    Part[$CellContext`surfnorm, 
                    2], $CellContext`XAxis = \
$CellContext`XAxis/$CellContext`raytiltx]; $CellContext`YAxis = {-(
                    Part[$CellContext`ZAxis, 3] Part[$CellContext`XAxis, 2]) + 
                    Part[$CellContext`ZAxis, 2] Part[$CellContext`XAxis, 3], 
                    Part[$CellContext`ZAxis, 3] Part[$CellContext`XAxis, 1] - 
                    Part[$CellContext`ZAxis, 1] 
                    Part[$CellContext`XAxis, 3], -(
                    Part[$CellContext`ZAxis, 2] Part[$CellContext`XAxis, 1]) + 
                    Part[$CellContext`ZAxis, 1] 
                    Part[$CellContext`XAxis, 
                    2]}; $CellContext`YAxis = $CellContext`YAxis/Sqrt[
                    
                    Dot[$CellContext`YAxis, $CellContext`YAxis]]; \
$CellContext`PAxis = $CellContext`ZAxis 
                    Dot[{$CellContext`r1, $CellContext`r2, $CellContext`r3}, \
$CellContext`XAxis] - $CellContext`XAxis 
                    Dot[{$CellContext`r1, $CellContext`r2, $CellContext`r3}, \
$CellContext`ZAxis]; $CellContext`PAxis = $CellContext`PAxis/Sqrt[
                    
                    Dot[$CellContext`PAxis, $CellContext`PAxis]]; \
$CellContext`normalizedpolarization = 
                    Part[{$CellContext`pol1, $CellContext`pol2, \
$CellContext`pol3}, {1, 
                    2}]; $CellContext`normalizedpolarization = \
$CellContext`normalizedpolarization/Sqrt[
                    
                    Dot[$CellContext`normalizedpolarization, \
$CellContext`normalizedpolarization]]; $CellContext`allcreatedamplitudes = {{
                    0. I, 0. I, 0. I}}; $CellContext`amplitude = 
                    Sqrt[$CellContext`intensity] (
                    Part[$CellContext`normalizedpolarization, 
                    1] {$CellContext`r4, $CellContext`r5, $CellContext`r6} + 
                    Part[$CellContext`normalizedpolarization, 
                    2] {$CellContext`r7, $CellContext`r8, $CellContext`r9} 
                    Exp[I $CellContext`pol3 
                    0.017453292519943295`]); \
$CellContext`perpendicularamplitude = 
                    Dot[$CellContext`amplitude, $CellContext`YAxis]; \
$CellContext`parallelamplitude = 
                    Dot[$CellContext`amplitude, $CellContext`PAxis]; 
                    If[$CellContext`activeregion Part[
                    
                    Dot[$CellContext`surfacerotationmatrix, {$CellContext`r1, \
$CellContext`r2, $CellContext`r3}], 1] > 
                    0, $CellContext`index2 = 
                    Sqrt[2.2718929 - 0.010108077 $CellContext`wavelength^2 + 
                    0.010592509/$CellContext`wavelength^2 + 
                    0.00020816965/$CellContext`wavelength^4 - 
                    7.6472538*^-6/$CellContext`wavelength^6 + 
                    4.9240991*^-7/$CellContext`wavelength^8]; \
$CellContext`index1 = $CellContext`index; 
                    If[Abs[$CellContext`index2 - $CellContext`index1] < 
                    0.01, $CellContext`alternateindex = 
                    Sqrt[1.0005281111748805` - 
                    2.364805676582992*^-10 $CellContext`wavelength^2 + 
                    2.9781670902982902`*^-6/$CellContext`wavelength^2 + 
                    2.6004099469477187`*^-8/$CellContext`wavelength^4 + 
                    3.7787839314048715`*^-10/$CellContext`wavelength^6 + 
                    2.830549017940716*^-12/$CellContext`wavelength^8]; 
                    If[Abs[$CellContext`alternateindex - $CellContext`index1] > 
                    Abs[$CellContext`index2 - $CellContext`index1], \
$CellContext`index1 = $CellContext`index2; $CellContext`index2 = \
$CellContext`alternateindex, $CellContext`index1 = \
$CellContext`alternateindex], $CellContext`index1 = 
                    Sqrt[1.0005281111748805` - 
                    2.364805676582992*^-10 $CellContext`wavelength^2 + 
                    2.9781670902982902`*^-6/$CellContext`wavelength^2 + 
                    2.6004099469477187`*^-8/$CellContext`wavelength^4 + 
                    3.7787839314048715`*^-10/$CellContext`wavelength^6 + 
                    2.830549017940716*^-12/$CellContext`wavelength^8]], \
$CellContext`index2 = Sqrt[1.0005281111748805` - 
                    2.364805676582992*^-10 $CellContext`wavelength^2 + 
                    2.9781670902982902`*^-6/$CellContext`wavelength^2 + 
                    2.6004099469477187`*^-8/$CellContext`wavelength^4 + 
                    3.7787839314048715`*^-10/$CellContext`wavelength^6 + 
                    2.830549017940716*^-12/$CellContext`wavelength^8]; \
$CellContext`index1 = $CellContext`index; 
                    If[Abs[$CellContext`index2 - $CellContext`index1] < 
                    0.01, $CellContext`alternateindex = 
                    Sqrt[2.2718929 - 0.010108077 $CellContext`wavelength^2 + 
                    0.010592509/$CellContext`wavelength^2 + 
                    0.00020816965/$CellContext`wavelength^4 - 
                    7.6472538*^-6/$CellContext`wavelength^6 + 
                    4.9240991*^-7/$CellContext`wavelength^8]; 
                    If[Abs[$CellContext`alternateindex - $CellContext`index1] > 
                    Abs[$CellContext`index2 - $CellContext`index1], \
$CellContext`index1 = $CellContext`index2; $CellContext`index2 = \
$CellContext`alternateindex, $CellContext`index1 = \
$CellContext`alternateindex], $CellContext`index1 = 
                    Sqrt[2.2718929 - 0.010108077 $CellContext`wavelength^2 + 
                    0.010592509/$CellContext`wavelength^2 + 
                    0.00020816965/$CellContext`wavelength^4 - 
                    7.6472538*^-6/$CellContext`wavelength^6 + 
                    4.9240991*^-7/$CellContext`wavelength^8]]]; \
$CellContext`n12 = $CellContext`index1/$CellContext`index2; \
$CellContext`index = $CellContext`index2; 
                    If[1 - $CellContext`n12^2 $CellContext`raytiltx^2 >= 
                    0., $CellContext`dummyvector = $CellContext`n12 \
{$CellContext`r1, $CellContext`r2, $CellContext`r3} + $CellContext`ZAxis \
(-($CellContext`n12 $CellContext`raytiltz) + 
                    Sqrt[1 - $CellContext`n12^2 $CellContext`raytiltx^2]); \
{$CellContext`r1, $CellContext`r2, $CellContext`r3} = \
$CellContext`dummyvector; 1., 
                    If[Dot[{$CellContext`r1, $CellContext`r2, \
$CellContext`r3}, 
                    Part[$CellContext`surfnorm, 1]] > 
                    0, $CellContext`phaseshift = $CellContext`phaseshift + 
                    0.5, 1.]; $CellContext`index2 = $CellContext`index1; \
$CellContext`index = $CellContext`index1; $CellContext`dummyvector = \
{$CellContext`r1, $CellContext`r2, $CellContext`r3} - 2 $CellContext`ZAxis 
                    Dot[$CellContext`ZAxis, {$CellContext`r1, \
$CellContext`r2, $CellContext`r3}]; {$CellContext`r1, $CellContext`r2, \
$CellContext`r3} = $CellContext`dummyvector; $CellContext`dummyvector = \
{$CellContext`pol1, $CellContext`pol2, $CellContext`pol3} + {0, 
                    0, -180}; {$CellContext`pol1, $CellContext`pol2, \
$CellContext`pol3} = $CellContext`dummyvector; 
                    1.]; $CellContext`allcreatedrays = {{$CellContext`rsx, \
$CellContext`rsy, $CellContext`rsz, $CellContext`rex, $CellContext`rey, \
$CellContext`rez, $CellContext`r1, $CellContext`r2, $CellContext`r3, \
$CellContext`r4, $CellContext`r5, $CellContext`r6, $CellContext`r7, \
$CellContext`r8, $CellContext`r9, $CellContext`wavelength, \
$CellContext`intensity, $CellContext`intensityscale, $CellContext`ray1, \
$CellContext`index, $CellContext`opticallength, $CellContext`phaseshift, \
$CellContext`componentnumber, $CellContext`surfacenumber, \
$CellContext`surfaceid, $CellContext`ray2, $CellContext`ray3, \
$CellContext`sid, $CellContext`frontid, $CellContext`sno1, $CellContext`sno2, \
$CellContext`sno3, $CellContext`sno4, $CellContext`rayslot, \
$CellContext`generationnumber, $CellContext`intersectionnumber, \
$CellContext`pol1, $CellContext`pol2, $CellContext`pol3}}; \
$CellContext`originalrotation = Partition[
                    Take[$CellContext`originalray, {7, 15}], 
                    3]; $CellContext`previoustilt = 
                    Part[$CellContext`originalrotation, 
                    1]; $CellContext`transmatrix = 
                    MapIndexed[({$CellContext`rsx, $CellContext`rsy, \
$CellContext`rsz, $CellContext`rex, $CellContext`rey, $CellContext`rez, \
$CellContext`r1, $CellContext`r2, $CellContext`r3, $CellContext`r4, \
$CellContext`r5, $CellContext`r6, $CellContext`r7, $CellContext`r8, \
$CellContext`r9, $CellContext`wavelength, $CellContext`intensity, \
$CellContext`intensityscale, $CellContext`ray1, $CellContext`index, \
$CellContext`opticallength, $CellContext`phaseshift, \
$CellContext`componentnumber, $CellContext`surfacenumber, \
$CellContext`surfaceid, $CellContext`ray2, $CellContext`ray3, \
$CellContext`sid, $CellContext`frontid, $CellContext`sno1, $CellContext`sno2, \
$CellContext`sno3, $CellContext`sno4, $CellContext`rayslot, \
$CellContext`oldgenerationnumber, $CellContext`intersectionnumber, \
$CellContext`pol1, $CellContext`pol2, $CellContext`pol3} = #; \
$CellContext`rotationaxis = Cross[{1., 0., 
                    0.}, {$CellContext`r1, $CellContext`r2, $CellContext`r3}]; \
$CellContext`axismagnitude = Sqrt[
                    
                    Dot[$CellContext`rotationaxis, \
$CellContext`rotationaxis]]; 
                    If[Chop[$CellContext`axismagnitude] != 
                    0., $CellContext`rotationaxis = \
$CellContext`rotationaxis/$CellContext`axismagnitude; $CellContext`axismatrix = 
                    Map[# $CellContext`rotationaxis& , \
$CellContext`rotationaxis]; $CellContext`crossmatrix = {{
                    0., -Part[$CellContext`rotationaxis, 3], 
                    Part[$CellContext`rotationaxis, 2]}, {
                    Part[$CellContext`rotationaxis, 3], 0., -
                    Part[$CellContext`rotationaxis, 1]}, {-
                    Part[$CellContext`rotationaxis, 2], 
                    Part[$CellContext`rotationaxis, 1], 
                    0.}}; $CellContext`cosangle = 
                    Dot[{1., 0., 
                    0.}, {$CellContext`r1, $CellContext`r2, $CellContext`r3}]; 
                    If[1. - $CellContext`cosangle < 
                    2.220446049250313*^-16, $CellContext`cosangle = 
                    1.]; $CellContext`sinangle = 1 - $CellContext`cosangle^2; 
                    If[$CellContext`sinangle < 
                    2.220446049250313*^-16, $CellContext`sinangle = 
                    0., $CellContext`sinangle = 
                    Sqrt[$CellContext`sinangle]]; $CellContext`axismatrix + \
({{1., 0., 0.}, {0., 1., 0.}, {0., 0., 
                    1.}} - $CellContext`axismatrix) $CellContext`cosangle + \
$CellContext`crossmatrix $CellContext`sinangle, {{$CellContext`r1, \
$CellContext`r2, $CellContext`r3}, {$CellContext`r4, $CellContext`r5, \
$CellContext`r6}, {$CellContext`r7, $CellContext`r8, $CellContext`r9}} = 
                    If[Sign[
                    
                    Dot[{1., 0., 
                    0.}, {$CellContext`r1, $CellContext`r2, \
$CellContext`r3}]] === 1, {{1., 0., 0.}, {0., 1., 0.}, {0., 0., 1.}}, {{-1., 
                    0., 0.}, {0., -1., 0.}, {0., 0., 
                    1.}}]])& , $CellContext`allcreatedrays]; \
$CellContext`allcreatedrays = 
                    MapIndexed[({$CellContext`rsx, $CellContext`rsy, \
$CellContext`rsz, $CellContext`rex, $CellContext`rey, $CellContext`rez, \
$CellContext`r1, $CellContext`r2, $CellContext`r3, $CellContext`r4, \
$CellContext`r5, $CellContext`r6, $CellContext`r7, $CellContext`r8, \
$CellContext`r9, $CellContext`wavelength, $CellContext`intensity, \
$CellContext`intensityscale, $CellContext`ray1, $CellContext`index, \
$CellContext`opticallength, $CellContext`phaseshift, \
$CellContext`componentnumber, $CellContext`surfacenumber, \
$CellContext`surfaceid, $CellContext`ray2, $CellContext`ray3, \
$CellContext`sid, $CellContext`frontid, $CellContext`sno1, $CellContext`sno2, \
$CellContext`sno3, $CellContext`sno4, $CellContext`rayslot, \
$CellContext`oldgenerationnumber, $CellContext`intersectionnumber, \
$CellContext`pol1, $CellContext`pol2, $CellContext`pol3} = #; \
{{$CellContext`r1, $CellContext`r2, $CellContext`r3}, {$CellContext`r4, \
$CellContext`r5, $CellContext`r6}, {$CellContext`r7, $CellContext`r8, \
$CellContext`r9}} = Function[$CellContext`mm, 
                    Map[
                    Dot[$CellContext`mm, #]& , {{1., 0., 0.}, {0., 1., 0.}, {
                    0., 0., 1.}}]][
                    Part[$CellContext`transmatrix, 
                    First[#2]]]; $CellContext`tiltmagnitude = 
                    Dot[{$CellContext`r1, $CellContext`r2, $CellContext`r3}, \
{$CellContext`r1, $CellContext`r2, $CellContext`r3}]; 
                    If[Abs[$CellContext`tiltmagnitude - 1.] > 
                    1.*^-6, $CellContext`dummyvector = {$CellContext`r1, \
$CellContext`r2, $CellContext`r3}/
                    Sqrt[$CellContext`tiltmagnitude]; {$CellContext`r1, \
$CellContext`r2, $CellContext`r3} = $CellContext`dummyvector; \
$CellContext`dummymatrix = Map[#/Sqrt[
                    
                    Dot[#, #]]& , {{$CellContext`r1, $CellContext`r2, \
$CellContext`r3}, {$CellContext`r4, $CellContext`r5, $CellContext`r6}, \
{$CellContext`r7, $CellContext`r8, $CellContext`r9}}]; {{$CellContext`r1, \
$CellContext`r2, $CellContext`r3}, {$CellContext`r4, $CellContext`r5, \
$CellContext`r6}, {$CellContext`r7, $CellContext`r8, $CellContext`r9}} = \
$CellContext`dummymatrix; 1., 1.]; 
                    If[$CellContext`allcreatedamplitudes != {{
                    0. I, 0. I, 0. I}}, $CellContext`amplitude = 
                    Part[$CellContext`allcreatedamplitudes, 
                    First[#2]]; $CellContext`hor = 
                    Dot[{$CellContext`r4, $CellContext`r5, $CellContext`r6}, \
$CellContext`amplitude]; $CellContext`ver = 
                    Dot[{$CellContext`r7, $CellContext`r8, $CellContext`r9}, \
$CellContext`amplitude]; If[
                    Or[
                    Abs[$CellContext`hor] > 0., Abs[$CellContext`ver] > 
                    0.], {$CellContext`pol1, $CellContext`pol2, \
$CellContext`pol3} = {
                    Abs[$CellContext`hor], 
                    Abs[$CellContext`ver], 
                    0.}; $CellContext`dummyvector = {$CellContext`pol1, \
$CellContext`pol2, $CellContext`pol3}/Sqrt[
                    
                    Dot[{$CellContext`pol1, $CellContext`pol2, \
$CellContext`pol3}, {$CellContext`pol1, $CellContext`pol2, \
$CellContext`pol3}]]; {$CellContext`pol1, $CellContext`pol2, \
$CellContext`pol3} = $CellContext`dummyvector; $CellContext`dummyvector = 
                    ReplacePart[{$CellContext`pol1, $CellContext`pol2, \
$CellContext`pol3}, (If[$CellContext`ver == 0., 0., 
                    Arg[$CellContext`ver]] - If[$CellContext`hor == 0., 0., 
                    Arg[$CellContext`hor]])/Degree, 
                    3]; {$CellContext`pol1, $CellContext`pol2, \
$CellContext`pol3} = $CellContext`dummyvector]; 1., 
                    1.]; {$CellContext`rsx, $CellContext`rsy, \
$CellContext`rsz, $CellContext`rex, $CellContext`rey, $CellContext`rez, \
$CellContext`r1, $CellContext`r2, $CellContext`r3, $CellContext`r4, \
$CellContext`r5, $CellContext`r6, $CellContext`r7, $CellContext`r8, \
$CellContext`r9, $CellContext`wavelength, $CellContext`intensity, \
$CellContext`intensityscale, $CellContext`ray1, $CellContext`index, \
$CellContext`opticallength, $CellContext`phaseshift, \
$CellContext`componentnumber, $CellContext`surfacenumber, \
$CellContext`surfaceid, $CellContext`ray2, $CellContext`ray3, \
$CellContext`sid, $CellContext`frontid, $CellContext`sno1, $CellContext`sno2, \
$CellContext`sno3, $CellContext`sno4, $CellContext`rayslot, \
$CellContext`generationnumber, $CellContext`intersectionnumber, \
$CellContext`pol1, $CellContext`pol2, $CellContext`pol3})& , \
$CellContext`allcreatedrays]); {$CellContext`allcreatedrays, CompressedData["
1:eJxTTMoPSmViYGBgBGJ1Bhj4YD9Q9H8weP+fOPVw9+7HQdPN3QDj4TcH
                   
                     "], {$CellContext`completedray}}, \
$CellContext`resonatenumber == 
                    2, {$CellContext`rsx, $CellContext`rsy, $CellContext`rsz, \
$CellContext`rex, $CellContext`rey, $CellContext`rez, $CellContext`r1, \
$CellContext`r2, $CellContext`r3, $CellContext`r4, $CellContext`r5, \
$CellContext`r6, $CellContext`r7, $CellContext`r8, $CellContext`r9, \
$CellContext`wavelength, $CellContext`intensity, $CellContext`intensityscale, \
$CellContext`ray1, $CellContext`index, $CellContext`opticallength, \
$CellContext`phaseshift, $CellContext`componentnumber, \
$CellContext`surfacenumber, $CellContext`surfaceid, $CellContext`ray2, \
$CellContext`ray3, $CellContext`sid, $CellContext`frontid, $CellContext`sno1, \
$CellContext`sno2, $CellContext`sno3, $CellContext`sno4, \
$CellContext`rayslot, $CellContext`oldgenerationnumber, \
$CellContext`intersectionnumber, $CellContext`pol1, $CellContext`pol2, \
$CellContext`pol3} = #; $CellContext`index1 = $CellContext`index; \
$CellContext`xunit = $CellContext`r1 Re[
                    Cos[
                    0.017453292519943295` $CellContext`aa]] + $CellContext`r2 
                    Re[
                    Sin[
                    0.017453292519943295` $CellContext`aa]]; \
$CellContext`yunit = $CellContext`r2 Re[
                    Cos[0.017453292519943295` $CellContext`aa]] - 
                    1. $CellContext`r1 Re[
                    Sin[
                    0.017453292519943295` $CellContext`aa]]; \
$CellContext`zunit = $CellContext`r3 
                    Re[Cos[0.017453292519943295` $CellContext`aa]^2 + 
                    Sin[0.017453292519943295` $CellContext`aa]^2]; \
$CellContext`xunit = Chop[$CellContext`xunit]; $CellContext`yunit = 
                    Chop[$CellContext`yunit]; $CellContext`zunit = 
                    Chop[$CellContext`zunit]; $CellContext`magnitude = \
($CellContext`xunit^2 + $CellContext`yunit^2 + $CellContext`zunit^2)^(
                    2^(-1)); $CellContext`xunit = \
$CellContext`xunit/$CellContext`magnitude; $CellContext`yunit = \
$CellContext`yunit/$CellContext`magnitude; $CellContext`zunit = \
$CellContext`zunit/$CellContext`magnitude; $CellContext`rx = Re[
                    Cos[
                    0.017453292519943295` $CellContext`aa]] ($CellContext`rex - 
                    1. Re[$CellContext`xa1 + $CellContext`ta 
                    Cos[0.017453292519943295` $CellContext`aa]]) + Re[
                    Sin[
                    0.017453292519943295` $CellContext`aa]] ($CellContext`rey - 
                    1. Re[$CellContext`ya1 + $CellContext`ta 
                    Sin[0.017453292519943295` $CellContext`aa]]); \
$CellContext`ry = -($CellContext`rex - 1. 
                    Re[$CellContext`xa1 + $CellContext`ta 
                    Cos[0.017453292519943295` $CellContext`aa]]) Re[
                    Sin[0.017453292519943295` $CellContext`aa]] + Re[
                    Cos[
                    0.017453292519943295` $CellContext`aa]] ($CellContext`rey - 
                    1. Re[$CellContext`ya1 + $CellContext`ta 
                    Sin[0.017453292519943295` $CellContext`aa]]); \
$CellContext`rz = $CellContext`rez 
                    Re[Cos[0.017453292519943295` $CellContext`aa]^2 + 
                    Sin[0.017453292519943295` $CellContext`aa]^2]; \
$CellContext`rx = Chop[$CellContext`rx]; $CellContext`ry = 
                    Chop[$CellContext`ry]; $CellContext`rz = 
                    Chop[$CellContext`rz]; $CellContext`terminatedeflection = 
                    False; $CellContext`intersections = {{-1., 0., 
                    0.}}; $CellContext`intersections = \
$CellContext`resonateintersections; $CellContext`holeQ = 
                    Part[$CellContext`holeQlist, $CellContext`resonatenumber] == 
                    1; {$CellContext`newcomponentnumber, \
$CellContext`newsurfacenumber, $CellContext`newsurfaceid} = {1., 2., 
                    16520.}; {$CellContext`componentnumber, \
$CellContext`surfacenumber, $CellContext`surfaceid} = {1., 2., 
                    16520.}; {$CellContext`ray1, $CellContext`ray2, \
$CellContext`ray3} = Part[$CellContext`intersections, 
                    1]; $CellContext`rsx = $CellContext`rex; $CellContext`rsy = \
$CellContext`rey; $CellContext`rsz = $CellContext`rez; $CellContext`rxhlp = \
$CellContext`rx + $CellContext`ray1 $CellContext`xunit; $CellContext`ryhlp = \
$CellContext`ry + $CellContext`ray1 $CellContext`yunit; $CellContext`rzhlp = \
$CellContext`rz + $CellContext`ray1 $CellContext`zunit; $CellContext`rex = \
$CellContext`rxhlp Re[
                    Cos[0.017453292519943295` $CellContext`aa]] + 
                    Re[$CellContext`xa1 + $CellContext`ta 
                    Cos[0.017453292519943295` $CellContext`aa]] - 
                    1. $CellContext`ryhlp Re[
                    Sin[
                    0.017453292519943295` $CellContext`aa]]; $CellContext`rey = \
$CellContext`ryhlp Re[
                    Cos[
                    0.017453292519943295` $CellContext`aa]] + \
$CellContext`rxhlp Re[
                    Sin[0.017453292519943295` $CellContext`aa]] + 
                    Re[$CellContext`ya1 + $CellContext`ta 
                    Sin[0.017453292519943295` $CellContext`aa]]; \
$CellContext`rez = $CellContext`rzhlp 
                    Re[Cos[0.017453292519943295` $CellContext`aa]^2 + 
                    Sin[0.017453292519943295` $CellContext`aa]^2]; \
$CellContext`rex = Chop[$CellContext`rex]; $CellContext`rey = 
                    Chop[$CellContext`rey]; $CellContext`rez = 
                    Chop[$CellContext`rez]; If[
                    
                    And[$CellContext`rex == 0, $CellContext`rey == 
                    0, $CellContext`rez == 
                    0], $CellContext`rex = $CellContext`rxhlp + 
                    Re[$CellContext`xa1 + $CellContext`ta 
                    Cos[0.017453292519943295` $CellContext`aa]]; \
$CellContext`rey = $CellContext`ryhlp + 
                    Re[$CellContext`ya1 + $CellContext`ta 
                    Sin[0.017453292519943295` $CellContext`aa]]; \
$CellContext`rez = $CellContext`rzhlp, $CellContext`rex]; \
$CellContext`intersectionnumber = $CellContext`intersectionnumber + 
                    1.; $CellContext`opticallength = \
$CellContext`opticallength + $CellContext`ray1 $CellContext`index1; \
$CellContext`completedray = {$CellContext`rsx, $CellContext`rsy, \
$CellContext`rsz, $CellContext`rex, $CellContext`rey, $CellContext`rez, \
$CellContext`r1, $CellContext`r2, $CellContext`r3, $CellContext`r4, \
$CellContext`r5, $CellContext`r6, $CellContext`r7, $CellContext`r8, \
$CellContext`r9, $CellContext`wavelength, $CellContext`intensity, \
$CellContext`intensityscale, $CellContext`ray1, $CellContext`index, \
$CellContext`opticallength, $CellContext`phaseshift, \
$CellContext`componentnumber, $CellContext`surfacenumber, \
$CellContext`surfaceid, $CellContext`ray2, $CellContext`ray3, \
$CellContext`sid, $CellContext`frontid, $CellContext`sno1, $CellContext`sno2, \
$CellContext`sno3, $CellContext`sno4, $CellContext`rayslot, \
$CellContext`generationnumber, $CellContext`intersectionnumber, \
$CellContext`pol1, $CellContext`pol2, $CellContext`pol3}; \
$CellContext`reportedrayspresent = True; $CellContext`intersectionspresent = 
                    True; $CellContext`deflectedrayspresent = 
                    True; $CellContext`localdummyoutrayspresent = 
                    True; ($CellContext`surfnorm = 
                    1. Re[{{1., -(($CellContext`ray2/
                    Sign[$CellContext`ca2])/($CellContext`ca2^(-2) - 
                    1. $CellContext`ray2^2 - 
                    1. $CellContext`ray3^2)^0.5), -(($CellContext`ray3/
                    Sign[$CellContext`ca2])/($CellContext`ca2^(-2) - 
                    1. $CellContext`ray2^2 - 
                    1. $CellContext`ray3^2)^0.5)}, {($CellContext`ray2/
                    Sign[$CellContext`ca2])/($CellContext`ca2^(-2) - 
                    1. $CellContext`ray2^2 - 1. $CellContext`ray3^2)^0.5, 1., 
                    0.}, {($CellContext`ray3/
                    Sign[$CellContext`ca2])/($CellContext`ca2^(-2) - 
                    1. $CellContext`ray2^2 - 1. $CellContext`ray3^2)^0.5, 0., 
                    1.}}]; $CellContext`dummymatrix = Map[Dot[{{(Re[
                    Cos[0.017453292519943295` $CellContext`aa]] 
                    Re[Cos[0.017453292519943295` $CellContext`aa]^2 + 
                    Sin[0.017453292519943295` $CellContext`aa]^2])/(Re[
                    Cos[0.017453292519943295` $CellContext`aa]]^2 
                    Re[Cos[0.017453292519943295` $CellContext`aa]^2 + 
                    Sin[0.017453292519943295` $CellContext`aa]^2] + Re[
                    Sin[0.017453292519943295` $CellContext`aa]]^2 
                    Re[Cos[0.017453292519943295` $CellContext`aa]^2 + 
                    Sin[0.017453292519943295` $CellContext`aa]^2]), (-Re[
                    Sin[0.017453292519943295` $CellContext`aa]] 
                    Re[Cos[0.017453292519943295` $CellContext`aa]^2 + 
                    Sin[0.017453292519943295` $CellContext`aa]^2])/(Re[
                    Cos[0.017453292519943295` $CellContext`aa]]^2 
                    Re[Cos[0.017453292519943295` $CellContext`aa]^2 + 
                    Sin[0.017453292519943295` $CellContext`aa]^2] + Re[
                    Sin[0.017453292519943295` $CellContext`aa]]^2 
                    Re[Cos[0.017453292519943295` $CellContext`aa]^2 + 
                    Sin[0.017453292519943295` $CellContext`aa]^2]), 
                    0.}, {(Re[
                    Sin[0.017453292519943295` $CellContext`aa]] 
                    Re[Cos[0.017453292519943295` $CellContext`aa]^2 + 
                    Sin[0.017453292519943295` $CellContext`aa]^2])/(Re[
                    Cos[0.017453292519943295` $CellContext`aa]]^2 
                    Re[Cos[0.017453292519943295` $CellContext`aa]^2 + 
                    Sin[0.017453292519943295` $CellContext`aa]^2] + Re[
                    Sin[0.017453292519943295` $CellContext`aa]]^2 
                    Re[Cos[0.017453292519943295` $CellContext`aa]^2 + 
                    Sin[0.017453292519943295` $CellContext`aa]^2]), (Re[
                    Cos[0.017453292519943295` $CellContext`aa]] 
                    Re[Cos[0.017453292519943295` $CellContext`aa]^2 + 
                    Sin[0.017453292519943295` $CellContext`aa]^2])/(Re[
                    Cos[0.017453292519943295` $CellContext`aa]]^2 
                    Re[Cos[0.017453292519943295` $CellContext`aa]^2 + 
                    Sin[0.017453292519943295` $CellContext`aa]^2] + Re[
                    Sin[0.017453292519943295` $CellContext`aa]]^2 
                    Re[Cos[0.017453292519943295` $CellContext`aa]^2 + 
                    Sin[0.017453292519943295` $CellContext`aa]^2]), 0.}, {
                    0., 0., (Re[
                    Cos[0.017453292519943295` $CellContext`aa]]^2 + Re[
                    Sin[0.017453292519943295` $CellContext`aa]]^2)/(Re[
                    Cos[0.017453292519943295` $CellContext`aa]]^2 
                    Re[Cos[0.017453292519943295` $CellContext`aa]^2 + 
                    Sin[0.017453292519943295` $CellContext`aa]^2] + Re[
                    Sin[0.017453292519943295` $CellContext`aa]]^2 
                    Re[Cos[0.017453292519943295` $CellContext`aa]^2 + 
                    Sin[0.017453292519943295` $CellContext`aa]^2])}}, #]& , \
$CellContext`surfnorm]; $CellContext`surfnorm = Map[#/Sqrt[
                    
                    Dot[#, #]]& , $CellContext`dummymatrix]; \
$CellContext`surfacerotationmatrix = {{
                    Re[
                    Cos[0.017453292519943295` $CellContext`aa]], 
                    Re[
                    Sin[0.017453292519943295` $CellContext`aa]], 0.}, {-Re[
                    Sin[0.017453292519943295` $CellContext`aa]], 
                    Re[
                    Cos[0.017453292519943295` $CellContext`aa]], 0.}, {0., 0., 
                    Re[
                    Cos[0.017453292519943295` $CellContext`aa]^2 + 
                    Sin[0.017453292519943295` $CellContext`aa]^2]}}; \
$CellContext`surfacetranslationvector = {
                    
                    Re[$CellContext`xa1 + $CellContext`ta 
                    Cos[0.017453292519943295` $CellContext`aa]], 
                    
                    Re[$CellContext`ya1 + $CellContext`ta 
                    Sin[0.017453292519943295` $CellContext`aa]], 
                    0.}; $CellContext`activeregion = -1.; \
$CellContext`completedray = {$CellContext`rsx, $CellContext`rsy, \
$CellContext`rsz, $CellContext`rex, $CellContext`rey, $CellContext`rez, \
$CellContext`r1, $CellContext`r2, $CellContext`r3, $CellContext`r4, \
$CellContext`r5, $CellContext`r6, $CellContext`r7, $CellContext`r8, \
$CellContext`r9, $CellContext`wavelength, $CellContext`intensity, \
$CellContext`intensityscale, $CellContext`ray1, $CellContext`index, \
$CellContext`opticallength, $CellContext`phaseshift, \
$CellContext`componentnumber, $CellContext`surfacenumber, \
$CellContext`surfaceid, $CellContext`ray2, $CellContext`ray3, \
$CellContext`sid, $CellContext`frontid, $CellContext`sno1, $CellContext`sno2, \
$CellContext`sno3, $CellContext`sno4, $CellContext`rayslot, \
$CellContext`generationnumber, $CellContext`intersectionnumber, \
$CellContext`pol1, $CellContext`pol2, $CellContext`pol3}; \
$CellContext`componentnumber = $CellContext`newcomponentnumber; \
$CellContext`surfacenumber = $CellContext`newsurfacenumber; \
$CellContext`surfaceid = $CellContext`newsurfaceid; $CellContext`originalray = \
{$CellContext`rsx, $CellContext`rsy, $CellContext`rsz, $CellContext`rex, \
$CellContext`rey, $CellContext`rez, $CellContext`r1, $CellContext`r2, \
$CellContext`r3, $CellContext`r4, $CellContext`r5, $CellContext`r6, \
$CellContext`r7, $CellContext`r8, $CellContext`r9, $CellContext`wavelength, \
$CellContext`intensity, $CellContext`intensityscale, $CellContext`ray1, \
$CellContext`index, $CellContext`opticallength, $CellContext`phaseshift, \
$CellContext`componentnumber, $CellContext`surfacenumber, \
$CellContext`surfaceid, $CellContext`ray2, $CellContext`ray3, \
$CellContext`sid, $CellContext`frontid, $CellContext`sno1, $CellContext`sno2, \
$CellContext`sno3, $CellContext`sno4, $CellContext`rayslot, \
$CellContext`generationnumber, $CellContext`intersectionnumber, \
$CellContext`pol1, $CellContext`pol2, $CellContext`pol3}; $CellContext`ZAxis = 
                    First[$CellContext`surfnorm] Sign[
                    Dot[
                    
                    First[$CellContext`surfnorm], {$CellContext`r1, \
$CellContext`r2, $CellContext`r3}]]; $CellContext`raytiltz = 
                    Dot[$CellContext`ZAxis, {$CellContext`r1, \
$CellContext`r2, $CellContext`r3}]; $CellContext`raytiltx = 
                    1 - $CellContext`raytiltz^2; 
                    If[$CellContext`raytiltx < 
                    2.220446049250313*^-16, $CellContext`raytiltx = 
                    0., $CellContext`raytiltx = 
                    Sqrt[$CellContext`raytiltx]]; $CellContext`XAxis = \
{$CellContext`r1, $CellContext`r2, $CellContext`r3} - $CellContext`ZAxis \
$CellContext`raytiltz; If[
                    Abs[$CellContext`raytiltx] < 1.*^-7, $CellContext`XAxis = 
                    Part[$CellContext`surfnorm, 
                    2], $CellContext`XAxis = \
$CellContext`XAxis/$CellContext`raytiltx]; $CellContext`YAxis = {-(
                    Part[$CellContext`ZAxis, 3] Part[$CellContext`XAxis, 2]) + 
                    Part[$CellContext`ZAxis, 2] Part[$CellContext`XAxis, 3], 
                    Part[$CellContext`ZAxis, 3] Part[$CellContext`XAxis, 1] - 
                    Part[$CellContext`ZAxis, 1] 
                    Part[$CellContext`XAxis, 3], -(
                    Part[$CellContext`ZAxis, 2] Part[$CellContext`XAxis, 1]) + 
                    Part[$CellContext`ZAxis, 1] 
                    Part[$CellContext`XAxis, 
                    2]}; $CellContext`YAxis = $CellContext`YAxis/Sqrt[
                    
                    Dot[$CellContext`YAxis, $CellContext`YAxis]]; \
$CellContext`PAxis = $CellContext`ZAxis 
                    Dot[{$CellContext`r1, $CellContext`r2, $CellContext`r3}, \
$CellContext`XAxis] - $CellContext`XAxis 
                    Dot[{$CellContext`r1, $CellContext`r2, $CellContext`r3}, \
$CellContext`ZAxis]; $CellContext`PAxis = $CellContext`PAxis/Sqrt[
                    
                    Dot[$CellContext`PAxis, $CellContext`PAxis]]; \
$CellContext`normalizedpolarization = 
                    Part[{$CellContext`pol1, $CellContext`pol2, \
$CellContext`pol3}, {1, 
                    2}]; $CellContext`normalizedpolarization = \
$CellContext`normalizedpolarization/Sqrt[
                    
                    Dot[$CellContext`normalizedpolarization, \
$CellContext`normalizedpolarization]]; $CellContext`allcreatedamplitudes = {{
                    0. I, 0. I, 0. I}}; $CellContext`amplitude = 
                    Sqrt[$CellContext`intensity] (
                    Part[$CellContext`normalizedpolarization, 
                    1] {$CellContext`r4, $CellContext`r5, $CellContext`r6} + 
                    Part[$CellContext`normalizedpolarization, 
                    2] {$CellContext`r7, $CellContext`r8, $CellContext`r9} 
                    Exp[I $CellContext`pol3 
                    0.017453292519943295`]); \
$CellContext`perpendicularamplitude = 
                    Dot[$CellContext`amplitude, $CellContext`YAxis]; \
$CellContext`parallelamplitude = 
                    Dot[$CellContext`amplitude, $CellContext`PAxis]; 
                    If[$CellContext`activeregion Part[
                    
                    Dot[$CellContext`surfacerotationmatrix, {$CellContext`r1, \
$CellContext`r2, $CellContext`r3}], 1] > 
                    0, $CellContext`index2 = 
                    Sqrt[2.2718929 - 0.010108077 $CellContext`wavelength^2 + 
                    0.010592509/$CellContext`wavelength^2 + 
                    0.00020816965/$CellContext`wavelength^4 - 
                    7.6472538*^-6/$CellContext`wavelength^6 + 
                    4.9240991*^-7/$CellContext`wavelength^8]; \
$CellContext`index1 = $CellContext`index; 
                    If[Abs[$CellContext`index2 - $CellContext`index1] < 
                    0.01, $CellContext`alternateindex = 
                    Sqrt[1.0005281111748805` - 
                    2.364805676582992*^-10 $CellContext`wavelength^2 + 
                    2.9781670902982902`*^-6/$CellContext`wavelength^2 + 
                    2.6004099469477187`*^-8/$CellContext`wavelength^4 + 
                    3.7787839314048715`*^-10/$CellContext`wavelength^6 + 
                    2.830549017940716*^-12/$CellContext`wavelength^8]; 
                    If[Abs[$CellContext`alternateindex - $CellContext`index1] > 
                    Abs[$CellContext`index2 - $CellContext`index1], \
$CellContext`index1 = $CellContext`index2; $CellContext`index2 = \
$CellContext`alternateindex, $CellContext`index1 = \
$CellContext`alternateindex], $CellContext`index1 = 
                    Sqrt[1.0005281111748805` - 
                    2.364805676582992*^-10 $CellContext`wavelength^2 + 
                    2.9781670902982902`*^-6/$CellContext`wavelength^2 + 
                    2.6004099469477187`*^-8/$CellContext`wavelength^4 + 
                    3.7787839314048715`*^-10/$CellContext`wavelength^6 + 
                    2.830549017940716*^-12/$CellContext`wavelength^8]], \
$CellContext`index2 = Sqrt[1.0005281111748805` - 
                    2.364805676582992*^-10 $CellContext`wavelength^2 + 
                    2.9781670902982902`*^-6/$CellContext`wavelength^2 + 
                    2.6004099469477187`*^-8/$CellContext`wavelength^4 + 
                    3.7787839314048715`*^-10/$CellContext`wavelength^6 + 
                    2.830549017940716*^-12/$CellContext`wavelength^8]; \
$CellContext`index1 = $CellContext`index; 
                    If[Abs[$CellContext`index2 - $CellContext`index1] < 
                    0.01, $CellContext`alternateindex = 
                    Sqrt[2.2718929 - 0.010108077 $CellContext`wavelength^2 + 
                    0.010592509/$CellContext`wavelength^2 + 
                    0.00020816965/$CellContext`wavelength^4 - 
                    7.6472538*^-6/$CellContext`wavelength^6 + 
                    4.9240991*^-7/$CellContext`wavelength^8]; 
                    If[Abs[$CellContext`alternateindex - $CellContext`index1] > 
                    Abs[$CellContext`index2 - $CellContext`index1], \
$CellContext`index1 = $CellContext`index2; $CellContext`index2 = \
$CellContext`alternateindex, $CellContext`index1 = \
$CellContext`alternateindex], $CellContext`index1 = 
                    Sqrt[2.2718929 - 0.010108077 $CellContext`wavelength^2 + 
                    0.010592509/$CellContext`wavelength^2 + 
                    0.00020816965/$CellContext`wavelength^4 - 
                    7.6472538*^-6/$CellContext`wavelength^6 + 
                    4.9240991*^-7/$CellContext`wavelength^8]]]; \
$CellContext`n12 = $CellContext`index1/$CellContext`index2; \
$CellContext`index = $CellContext`index2; 
                    If[1 - $CellContext`n12^2 $CellContext`raytiltx^2 >= 
                    0., $CellContext`dummyvector = $CellContext`n12 \
{$CellContext`r1, $CellContext`r2, $CellContext`r3} + $CellContext`ZAxis \
(-($CellContext`n12 $CellContext`raytiltz) + 
                    Sqrt[1 - $CellContext`n12^2 $CellContext`raytiltx^2]); \
{$CellContext`r1, $CellContext`r2, $CellContext`r3} = \
$CellContext`dummyvector; 1., 
                    If[Dot[{$CellContext`r1, $CellContext`r2, \
$CellContext`r3}, 
                    Part[$CellContext`surfnorm, 1]] > 
                    0, $CellContext`phaseshift = $CellContext`phaseshift + 
                    0.5, 1.]; $CellContext`index2 = $CellContext`index1; \
$CellContext`index = $CellContext`index1; $CellContext`dummyvector = \
{$CellContext`r1, $CellContext`r2, $CellContext`r3} - 2 $CellContext`ZAxis 
                    Dot[$CellContext`ZAxis, {$CellContext`r1, \
$CellContext`r2, $CellContext`r3}]; {$CellContext`r1, $CellContext`r2, \
$CellContext`r3} = $CellContext`dummyvector; $CellContext`dummyvector = \
{$CellContext`pol1, $CellContext`pol2, $CellContext`pol3} + {0, 
                    0, -180}; {$CellContext`pol1, $CellContext`pol2, \
$CellContext`pol3} = $CellContext`dummyvector; 
                    1.]; $CellContext`allcreatedrays = {{$CellContext`rsx, \
$CellContext`rsy, $CellContext`rsz, $CellContext`rex, $CellContext`rey, \
$CellContext`rez, $CellContext`r1, $CellContext`r2, $CellContext`r3, \
$CellContext`r4, $CellContext`r5, $CellContext`r6, $CellContext`r7, \
$CellContext`r8, $CellContext`r9, $CellContext`wavelength, \
$CellContext`intensity, $CellContext`intensityscale, $CellContext`ray1, \
$CellContext`index, $CellContext`opticallength, $CellContext`phaseshift, \
$CellContext`componentnumber, $CellContext`surfacenumber, \
$CellContext`surfaceid, $CellContext`ray2, $CellContext`ray3, \
$CellContext`sid, $CellContext`frontid, $CellContext`sno1, $CellContext`sno2, \
$CellContext`sno3, $CellContext`sno4, $CellContext`rayslot, \
$CellContext`generationnumber, $CellContext`intersectionnumber, \
$CellContext`pol1, $CellContext`pol2, $CellContext`pol3}}; \
$CellContext`originalrotation = Partition[
                    Take[$CellContext`originalray, {7, 15}], 
                    3]; $CellContext`previoustilt = 
                    Part[$CellContext`originalrotation, 
                    1]; $CellContext`transmatrix = 
                    MapIndexed[({$CellContext`rsx, $CellContext`rsy, \
$CellContext`rsz, $CellContext`rex, $CellContext`rey, $CellContext`rez, \
$CellContext`r1, $CellContext`r2, $CellContext`r3, $CellContext`r4, \
$CellContext`r5, $CellContext`r6, $CellContext`r7, $CellContext`r8, \
$CellContext`r9, $CellContext`wavelength, $CellContext`intensity, \
$CellContext`intensityscale, $CellContext`ray1, $CellContext`index, \
$CellContext`opticallength, $CellContext`phaseshift, \
$CellContext`componentnumber, $CellContext`surfacenumber, \
$CellContext`surfaceid, $CellContext`ray2, $CellContext`ray3, \
$CellContext`sid, $CellContext`frontid, $CellContext`sno1, $CellContext`sno2, \
$CellContext`sno3, $CellContext`sno4, $CellContext`rayslot, \
$CellContext`oldgenerationnumber, $CellContext`intersectionnumber, \
$CellContext`pol1, $CellContext`pol2, $CellContext`pol3} = #; \
$CellContext`rotationaxis = Cross[{1., 0., 
                    0.}, {$CellContext`r1, $CellContext`r2, $CellContext`r3}]; \
$CellContext`axismagnitude = Sqrt[
                    
                    Dot[$CellContext`rotationaxis, \
$CellContext`rotationaxis]]; 
                    If[Chop[$CellContext`axismagnitude] != 
                    0., $CellContext`rotationaxis = \
$CellContext`rotationaxis/$CellContext`axismagnitude; $CellContext`axismatrix = 
                    Map[# $CellContext`rotationaxis& , \
$CellContext`rotationaxis]; $CellContext`crossmatrix = {{
                    0., -Part[$CellContext`rotationaxis, 3], 
                    Part[$CellContext`rotationaxis, 2]}, {
                    Part[$CellContext`rotationaxis, 3], 0., -
                    Part[$CellContext`rotationaxis, 1]}, {-
                    Part[$CellContext`rotationaxis, 2], 
                    Part[$CellContext`rotationaxis, 1], 
                    0.}}; $CellContext`cosangle = 
                    Dot[{1., 0., 
                    0.}, {$CellContext`r1, $CellContext`r2, $CellContext`r3}]; 
                    If[1. - $CellContext`cosangle < 
                    2.220446049250313*^-16, $CellContext`cosangle = 
                    1.]; $CellContext`sinangle = 1 - $CellContext`cosangle^2; 
                    If[$CellContext`sinangle < 
                    2.220446049250313*^-16, $CellContext`sinangle = 
                    0., $CellContext`sinangle = 
                    Sqrt[$CellContext`sinangle]]; $CellContext`axismatrix + \
({{1., 0., 0.}, {0., 1., 0.}, {0., 0., 
                    1.}} - $CellContext`axismatrix) $CellContext`cosangle + \
$CellContext`crossmatrix $CellContext`sinangle, {{$CellContext`r1, \
$CellContext`r2, $CellContext`r3}, {$CellContext`r4, $CellContext`r5, \
$CellContext`r6}, {$CellContext`r7, $CellContext`r8, $CellContext`r9}} = 
                    If[Sign[
                    
                    Dot[{1., 0., 
                    0.}, {$CellContext`r1, $CellContext`r2, \
$CellContext`r3}]] === 1, {{1., 0., 0.}, {0., 1., 0.}, {0., 0., 1.}}, {{-1., 
                    0., 0.}, {0., -1., 0.}, {0., 0., 
                    1.}}]])& , $CellContext`allcreatedrays]; \
$CellContext`allcreatedrays = 
                    MapIndexed[({$CellContext`rsx, $CellContext`rsy, \
$CellContext`rsz, $CellContext`rex, $CellContext`rey, $CellContext`rez, \
$CellContext`r1, $CellContext`r2, $CellContext`r3, $CellContext`r4, \
$CellContext`r5, $CellContext`r6, $CellContext`r7, $CellContext`r8, \
$CellContext`r9, $CellContext`wavelength, $CellContext`intensity, \
$CellContext`intensityscale, $CellContext`ray1, $CellContext`index, \
$CellContext`opticallength, $CellContext`phaseshift, \
$CellContext`componentnumber, $CellContext`surfacenumber, \
$CellContext`surfaceid, $CellContext`ray2, $CellContext`ray3, \
$CellContext`sid, $CellContext`frontid, $CellContext`sno1, $CellContext`sno2, \
$CellContext`sno3, $CellContext`sno4, $CellContext`rayslot, \
$CellContext`oldgenerationnumber, $CellContext`intersectionnumber, \
$CellContext`pol1, $CellContext`pol2, $CellContext`pol3} = #; \
{{$CellContext`r1, $CellContext`r2, $CellContext`r3}, {$CellContext`r4, \
$CellContext`r5, $CellContext`r6}, {$CellContext`r7, $CellContext`r8, \
$CellContext`r9}} = Function[$CellContext`mm, 
                    Map[
                    Dot[$CellContext`mm, #]& , {{1., 0., 0.}, {0., 1., 0.}, {
                    0., 0., 1.}}]][
                    Part[$CellContext`transmatrix, 
                    First[#2]]]; $CellContext`tiltmagnitude = 
                    Dot[{$CellContext`r1, $CellContext`r2, $CellContext`r3}, \
{$CellContext`r1, $CellContext`r2, $CellContext`r3}]; 
                    If[Abs[$CellContext`tiltmagnitude - 1.] > 
                    1.*^-6, $CellContext`dummyvector = {$CellContext`r1, \
$CellContext`r2, $CellContext`r3}/
                    Sqrt[$CellContext`tiltmagnitude]; {$CellContext`r1, \
$CellContext`r2, $CellContext`r3} = $CellContext`dummyvector; \
$CellContext`dummymatrix = Map[#/Sqrt[
                    
                    Dot[#, #]]& , {{$CellContext`r1, $CellContext`r2, \
$CellContext`r3}, {$CellContext`r4, $CellContext`r5, $CellContext`r6}, \
{$CellContext`r7, $CellContext`r8, $CellContext`r9}}]; {{$CellContext`r1, \
$CellContext`r2, $CellContext`r3}, {$CellContext`r4, $CellContext`r5, \
$CellContext`r6}, {$CellContext`r7, $CellContext`r8, $CellContext`r9}} = \
$CellContext`dummymatrix; 1., 1.]; 
                    If[$CellContext`allcreatedamplitudes != {{
                    0. I, 0. I, 0. I}}, $CellContext`amplitude = 
                    Part[$CellContext`allcreatedamplitudes, 
                    First[#2]]; $CellContext`hor = 
                    Dot[{$CellContext`r4, $CellContext`r5, $CellContext`r6}, \
$CellContext`amplitude]; $CellContext`ver = 
                    Dot[{$CellContext`r7, $CellContext`r8, $CellContext`r9}, \
$CellContext`amplitude]; If[
                    Or[
                    Abs[$CellContext`hor] > 0., Abs[$CellContext`ver] > 
                    0.], {$CellContext`pol1, $CellContext`pol2, \
$CellContext`pol3} = {
                    Abs[$CellContext`hor], 
                    Abs[$CellContext`ver], 
                    0.}; $CellContext`dummyvector = {$CellContext`pol1, \
$CellContext`pol2, $CellContext`pol3}/Sqrt[
                    
                    Dot[{$CellContext`pol1, $CellContext`pol2, \
$CellContext`pol3}, {$CellContext`pol1, $CellContext`pol2, \
$CellContext`pol3}]]; {$CellContext`pol1, $CellContext`pol2, \
$CellContext`pol3} = $CellContext`dummyvector; $CellContext`dummyvector = 
                    ReplacePart[{$CellContext`pol1, $CellContext`pol2, \
$CellContext`pol3}, (If[$CellContext`ver == 0., 0., 
                    Arg[$CellContext`ver]] - If[$CellContext`hor == 0., 0., 
                    Arg[$CellContext`hor]])/Degree, 
                    3]; {$CellContext`pol1, $CellContext`pol2, \
$CellContext`pol3} = $CellContext`dummyvector]; 1., 
                    1.]; {$CellContext`rsx, $CellContext`rsy, \
$CellContext`rsz, $CellContext`rex, $CellContext`rey, $CellContext`rez, \
$CellContext`r1, $CellContext`r2, $CellContext`r3, $CellContext`r4, \
$CellContext`r5, $CellContext`r6, $CellContext`r7, $CellContext`r8, \
$CellContext`r9, $CellContext`wavelength, $CellContext`intensity, \
$CellContext`intensityscale, $CellContext`ray1, $CellContext`index, \
$CellContext`opticallength, $CellContext`phaseshift, \
$CellContext`componentnumber, $CellContext`surfacenumber, \
$CellContext`surfaceid, $CellContext`ray2, $CellContext`ray3, \
$CellContext`sid, $CellContext`frontid, $CellContext`sno1, $CellContext`sno2, \
$CellContext`sno3, $CellContext`sno4, $CellContext`rayslot, \
$CellContext`generationnumber, $CellContext`intersectionnumber, \
$CellContext`pol1, $CellContext`pol2, $CellContext`pol3})& , \
$CellContext`allcreatedrays]); {$CellContext`allcreatedrays, CompressedData["
1:eJxTTMoPSmViYGBgBGJ1Bhj4YD9Q9H8weP+fOPVw9+7HQdPN3QDj4TcH
                   
                     "], {$CellContext`completedray}}, \
$CellContext`resonatenumber == 
                    3, {$CellContext`rsx, $CellContext`rsy, $CellContext`rsz, \
$CellContext`rex, $CellContext`rey, $CellContext`rez, $CellContext`r1, \
$CellContext`r2, $CellContext`r3, $CellContext`r4, $CellContext`r5, \
$CellContext`r6, $CellContext`r7, $CellContext`r8, $CellContext`r9, \
$CellContext`wavelength, $CellContext`intensity, $CellContext`intensityscale, \
$CellContext`ray1, $CellContext`index, $CellContext`opticallength, \
$CellContext`phaseshift, $CellContext`componentnumber, \
$CellContext`surfacenumber, $CellContext`surfaceid, $CellContext`ray2, \
$CellContext`ray3, $CellContext`sid, $CellContext`frontid, $CellContext`sno1, \
$CellContext`sno2, $CellContext`sno3, $CellContext`sno4, \
$CellContext`rayslot, $CellContext`oldgenerationnumber, \
$CellContext`intersectionnumber, $CellContext`pol1, $CellContext`pol2, \
$CellContext`pol3} = #; $CellContext`index1 = $CellContext`index; \
$CellContext`xunit = $CellContext`r1 Re[
                    Cos[
                    0.017453292519943295` $CellContext`ab]] + $CellContext`r2 
                    Re[
                    Sin[
                    0.017453292519943295` $CellContext`ab]]; \
$CellContext`yunit = $CellContext`r2 Re[
                    Cos[0.017453292519943295` $CellContext`ab]] - 
                    1. $CellContext`r1 Re[
                    Sin[
                    0.017453292519943295` $CellContext`ab]]; \
$CellContext`zunit = $CellContext`r3 
                    Re[Cos[0.017453292519943295` $CellContext`ab]^2 + 
                    Sin[0.017453292519943295` $CellContext`ab]^2]; \
$CellContext`xunit = Chop[$CellContext`xunit]; $CellContext`yunit = 
                    Chop[$CellContext`yunit]; $CellContext`zunit = 
                    Chop[$CellContext`zunit]; $CellContext`magnitude = \
($CellContext`xunit^2 + $CellContext`yunit^2 + $CellContext`zunit^2)^(
                    2^(-1)); $CellContext`xunit = \
$CellContext`xunit/$CellContext`magnitude; $CellContext`yunit = \
$CellContext`yunit/$CellContext`magnitude; $CellContext`zunit = \
$CellContext`zunit/$CellContext`magnitude; $CellContext`rx = \
($CellContext`rex - 1. Re[$CellContext`xb1]) Re[
                    Cos[
                    0.017453292519943295` $CellContext`ab]] + \
($CellContext`rey - 1. Re[$CellContext`yb1]) Re[
                    Sin[
                    0.017453292519943295` $CellContext`ab]]; $CellContext`ry = \
($CellContext`rey - 1. Re[$CellContext`yb1]) Re[
                    Cos[0.017453292519943295` $CellContext`ab]] - 
                    1. ($CellContext`rex - 1. Re[$CellContext`xb1]) Re[
                    Sin[
                    0.017453292519943295` $CellContext`ab]]; $CellContext`rz = \
$CellContext`rez Re[Cos[0.017453292519943295` $CellContext`ab]^2 + 
                    Sin[0.017453292519943295` $CellContext`ab]^2]; \
$CellContext`rx = Chop[$CellContext`rx]; $CellContext`ry = 
                    Chop[$CellContext`ry]; $CellContext`rz = 
                    Chop[$CellContext`rz]; $CellContext`terminatedeflection = 
                    False; $CellContext`intersections = {{-1., 0., 
                    0.}}; $CellContext`intersections = \
$CellContext`resonateintersections; $CellContext`holeQ = 
                    Part[$CellContext`holeQlist, $CellContext`resonatenumber] == 
                    1; {$CellContext`newcomponentnumber, \
$CellContext`newsurfacenumber, $CellContext`newsurfaceid} = {1., 3., 
                    16547.}; {$CellContext`componentnumber, \
$CellContext`surfacenumber, $CellContext`surfaceid} = {1., 3., 
                    16547.}; {$CellContext`ray1, $CellContext`ray2, \
$CellContext`ray3} = Part[$CellContext`intersections, 
                    1]; $CellContext`rsx = $CellContext`rex; $CellContext`rsy = \
$CellContext`rey; $CellContext`rsz = $CellContext`rez; $CellContext`rxhlp = \
$CellContext`rx + $CellContext`ray1 $CellContext`xunit; $CellContext`ryhlp = \
$CellContext`ry + $CellContext`ray1 $CellContext`yunit; $CellContext`rzhlp = \
$CellContext`rz + $CellContext`ray1 $CellContext`zunit; $CellContext`rex = 
                    Re[$CellContext`xb1] + $CellContext`rxhlp Re[
                    Cos[0.017453292519943295` $CellContext`ab]] - 
                    1. $CellContext`ryhlp Re[
                    Sin[
                    0.017453292519943295` $CellContext`ab]]; $CellContext`rey = 
                    Re[$CellContext`yb1] + $CellContext`ryhlp Re[
                    Cos[
                    0.017453292519943295` $CellContext`ab]] + \
$CellContext`rxhlp Re[
                    Sin[
                    0.017453292519943295` $CellContext`ab]]; $CellContext`rez = \
$CellContext`rzhlp Re[Cos[0.017453292519943295` $CellContext`ab]^2 + 
                    Sin[0.017453292519943295` $CellContext`ab]^2]; \
$CellContext`rex = Chop[$CellContext`rex]; $CellContext`rey = 
                    Chop[$CellContext`rey]; $CellContext`rez = 
                    Chop[$CellContext`rez]; If[
                    
                    And[$CellContext`rex == 0, $CellContext`rey == 
                    0, $CellContext`rez == 
                    0], $CellContext`rex = $CellContext`rxhlp + 
                    Re[$CellContext`xb1]; $CellContext`rey = \
$CellContext`ryhlp + 
                    Re[$CellContext`yb1]; $CellContext`rez = \
$CellContext`rzhlp, $CellContext`rex]; $CellContext`intersectionnumber = \
$CellContext`intersectionnumber + 
                    1.; $CellContext`opticallength = \
$CellContext`opticallength + $CellContext`ray1 $CellContext`index1; \
$CellContext`completedray = {$CellContext`rsx, $CellContext`rsy, \
$CellContext`rsz, $CellContext`rex, $CellContext`rey, $CellContext`rez, \
$CellContext`r1, $CellContext`r2, $CellContext`r3, $CellContext`r4, \
$CellContext`r5, $CellContext`r6, $CellContext`r7, $CellContext`r8, \
$CellContext`r9, $CellContext`wavelength, $CellContext`intensity, \
$CellContext`intensityscale, $CellContext`ray1, $CellContext`index, \
$CellContext`opticallength, $CellContext`phaseshift, \
$CellContext`componentnumber, $CellContext`surfacenumber, \
$CellContext`surfaceid, $CellContext`ray2, $CellContext`ray3, \
$CellContext`sid, $CellContext`frontid, $CellContext`sno1, $CellContext`sno2, \
$CellContext`sno3, $CellContext`sno4, $CellContext`rayslot, \
$CellContext`generationnumber, $CellContext`intersectionnumber, \
$CellContext`pol1, $CellContext`pol2, $CellContext`pol3}; \
$CellContext`reportedrayspresent = True; $CellContext`intersectionspresent = 
                    True; $CellContext`deflectedrayspresent = 
                    True; $CellContext`localdummyoutrayspresent = 
                    True; ($CellContext`surfnorm = 
                    1. Re[{{1., -(($CellContext`ray2/
                    Sign[$CellContext`cb1])/($CellContext`cb1^(-2) - 
                    1. $CellContext`ray2^2 - 
                    1. $CellContext`ray3^2)^0.5), -(($CellContext`ray3/
                    Sign[$CellContext`cb1])/($CellContext`cb1^(-2) - 
                    1. $CellContext`ray2^2 - 
                    1. $CellContext`ray3^2)^0.5)}, {($CellContext`ray2/
                    Sign[$CellContext`cb1])/($CellContext`cb1^(-2) - 
                    1. $CellContext`ray2^2 - 1. $CellContext`ray3^2)^0.5, 1., 
                    0.}, {($CellContext`ray3/
                    Sign[$CellContext`cb1])/($CellContext`cb1^(-2) - 
                    1. $CellContext`ray2^2 - 1. $CellContext`ray3^2)^0.5, 0., 
                    1.}}]; $CellContext`dummymatrix = Map[Dot[{{(Re[
                    Cos[0.017453292519943295` $CellContext`ab]] 
                    Re[Cos[0.017453292519943295` $CellContext`ab]^2 + 
                    Sin[0.017453292519943295` $CellContext`ab]^2])/(Re[
                    Cos[0.017453292519943295` $CellContext`ab]]^2 
                    Re[Cos[0.017453292519943295` $CellContext`ab]^2 + 
                    Sin[0.017453292519943295` $CellContext`ab]^2] + Re[
                    Sin[0.017453292519943295` $CellContext`ab]]^2 
                    Re[Cos[0.017453292519943295` $CellContext`ab]^2 + 
                    Sin[0.017453292519943295` $CellContext`ab]^2]), (-Re[
                    Sin[0.017453292519943295` $CellContext`ab]] 
                    Re[Cos[0.017453292519943295` $CellContext`ab]^2 + 
                    Sin[0.017453292519943295` $CellContext`ab]^2])/(Re[
                    Cos[0.017453292519943295` $CellContext`ab]]^2 
                    Re[Cos[0.017453292519943295` $CellContext`ab]^2 + 
                    Sin[0.017453292519943295` $CellContext`ab]^2] + Re[
                    Sin[0.017453292519943295` $CellContext`ab]]^2 
                    Re[Cos[0.017453292519943295` $CellContext`ab]^2 + 
                    Sin[0.017453292519943295` $CellContext`ab]^2]), 
                    0.}, {(Re[
                    Sin[0.017453292519943295` $CellContext`ab]] 
                    Re[Cos[0.017453292519943295` $CellContext`ab]^2 + 
                    Sin[0.017453292519943295` $CellContext`ab]^2])/(Re[
                    Cos[0.017453292519943295` $CellContext`ab]]^2 
                    Re[Cos[0.017453292519943295` $CellContext`ab]^2 + 
                    Sin[0.017453292519943295` $CellContext`ab]^2] + Re[
                    Sin[0.017453292519943295` $CellContext`ab]]^2 
                    Re[Cos[0.017453292519943295` $CellContext`ab]^2 + 
                    Sin[0.017453292519943295` $CellContext`ab]^2]), (Re[
                    Cos[0.017453292519943295` $CellContext`ab]] 
                    Re[Cos[0.017453292519943295` $CellContext`ab]^2 + 
                    Sin[0.017453292519943295` $CellContext`ab]^2])/(Re[
                    Cos[0.017453292519943295` $CellContext`ab]]^2 
                    Re[Cos[0.017453292519943295` $CellContext`ab]^2 + 
                    Sin[0.017453292519943295` $CellContext`ab]^2] + Re[
                    Sin[0.017453292519943295` $CellContext`ab]]^2 
                    Re[Cos[0.017453292519943295` $CellContext`ab]^2 + 
                    Sin[0.017453292519943295` $CellContext`ab]^2]), 0.}, {
                    0., 0., (Re[
                    Cos[0.017453292519943295` $CellContext`ab]]^2 + Re[
                    Sin[0.017453292519943295` $CellContext`ab]]^2)/(Re[
                    Cos[0.017453292519943295` $CellContext`ab]]^2 
                    Re[Cos[0.017453292519943295` $CellContext`ab]^2 + 
                    Sin[0.017453292519943295` $CellContext`ab]^2] + Re[
                    Sin[0.017453292519943295` $CellContext`ab]]^2 
                    Re[Cos[0.017453292519943295` $CellContext`ab]^2 + 
                    Sin[0.017453292519943295` $CellContext`ab]^2])}}, #]& , \
$CellContext`surfnorm]; $CellContext`surfnorm = Map[#/Sqrt[
                    
                    Dot[#, #]]& , $CellContext`dummymatrix]; \
$CellContext`surfacerotationmatrix = {{
                    Re[
                    Cos[0.017453292519943295` $CellContext`ab]], 
                    Re[
                    Sin[0.017453292519943295` $CellContext`ab]], 0.}, {-Re[
                    Sin[0.017453292519943295` $CellContext`ab]], 
                    Re[
                    Cos[0.017453292519943295` $CellContext`ab]], 0.}, {0., 0., 
                    Re[
                    Cos[0.017453292519943295` $CellContext`ab]^2 + 
                    Sin[0.017453292519943295` $CellContext`ab]^2]}}; \
$CellContext`surfacetranslationvector = {
                    Re[$CellContext`xb1], 
                    Re[$CellContext`yb1], 0.}; $CellContext`activeregion = 
                    1.; $CellContext`completedray = {$CellContext`rsx, \
$CellContext`rsy, $CellContext`rsz, $CellContext`rex, $CellContext`rey, \
$CellContext`rez, $CellContext`r1, $CellContext`r2, $CellContext`r3, \
$CellContext`r4, $CellContext`r5, $CellContext`r6, $CellContext`r7, \
$CellContext`r8, $CellContext`r9, $CellContext`wavelength, \
$CellContext`intensity, $CellContext`intensityscale, $CellContext`ray1, \
$CellContext`index, $CellContext`opticallength, $CellContext`phaseshift, \
$CellContext`componentnumber, $CellContext`surfacenumber, \
$CellContext`surfaceid, $CellContext`ray2, $CellContext`ray3, \
$CellContext`sid, $CellContext`frontid, $CellContext`sno1, $CellContext`sno2, \
$CellContext`sno3, $CellContext`sno4, $CellContext`rayslot, \
$CellContext`generationnumber, $CellContext`intersectionnumber, \
$CellContext`pol1, $CellContext`pol2, $CellContext`pol3}; \
$CellContext`componentnumber = $CellContext`newcomponentnumber; \
$CellContext`surfacenumber = $CellContext`newsurfacenumber; \
$CellContext`surfaceid = $CellContext`newsurfaceid; $CellContext`originalray = \
{$CellContext`rsx, $CellContext`rsy, $CellContext`rsz, $CellContext`rex, \
$CellContext`rey, $CellContext`rez, $CellContext`r1, $CellContext`r2, \
$CellContext`r3, $CellContext`r4, $CellContext`r5, $CellContext`r6, \
$CellContext`r7, $CellContext`r8, $CellContext`r9, $CellContext`wavelength, \
$CellContext`intensity, $CellContext`intensityscale, $CellContext`ray1, \
$CellContext`index, $CellContext`opticallength, $CellContext`phaseshift, \
$CellContext`componentnumber, $CellContext`surfacenumber, \
$CellContext`surfaceid, $CellContext`ray2, $CellContext`ray3, \
$CellContext`sid, $CellContext`frontid, $CellContext`sno1, $CellContext`sno2, \
$CellContext`sno3, $CellContext`sno4, $CellContext`rayslot, \
$CellContext`generationnumber, $CellContext`intersectionnumber, \
$CellContext`pol1, $CellContext`pol2, $CellContext`pol3}; $CellContext`ZAxis = 
                    First[$CellContext`surfnorm] Sign[
                    Dot[
                    
                    First[$CellContext`surfnorm], {$CellContext`r1, \
$CellContext`r2, $CellContext`r3}]]; $CellContext`raytiltz = 
                    Dot[$CellContext`ZAxis, {$CellContext`r1, \
$CellContext`r2, $CellContext`r3}]; $CellContext`raytiltx = 
                    1 - $CellContext`raytiltz^2; 
                    If[$CellContext`raytiltx < 
                    2.220446049250313*^-16, $CellContext`raytiltx = 
                    0., $CellContext`raytiltx = 
                    Sqrt[$CellContext`raytiltx]]; $CellContext`XAxis = \
{$CellContext`r1, $CellContext`r2, $CellContext`r3} - $CellContext`ZAxis \
$CellContext`raytiltz; If[
                    Abs[$CellContext`raytiltx] < 1.*^-7, $CellContext`XAxis = 
                    Part[$CellContext`surfnorm, 
                    2], $CellContext`XAxis = \
$CellContext`XAxis/$CellContext`raytiltx]; $CellContext`YAxis = {-(
                    Part[$CellContext`ZAxis, 3] Part[$CellContext`XAxis, 2]) + 
                    Part[$CellContext`ZAxis, 2] Part[$CellContext`XAxis, 3], 
                    Part[$CellContext`ZAxis, 3] Part[$CellContext`XAxis, 1] - 
                    Part[$CellContext`ZAxis, 1] 
                    Part[$CellContext`XAxis, 3], -(
                    Part[$CellContext`ZAxis, 2] Part[$CellContext`XAxis, 1]) + 
                    Part[$CellContext`ZAxis, 1] 
                    Part[$CellContext`XAxis, 
                    2]}; $CellContext`YAxis = $CellContext`YAxis/Sqrt[
                    
                    Dot[$CellContext`YAxis, $CellContext`YAxis]]; \
$CellContext`PAxis = $CellContext`ZAxis 
                    Dot[{$CellContext`r1, $CellContext`r2, $CellContext`r3}, \
$CellContext`XAxis] - $CellContext`XAxis 
                    Dot[{$CellContext`r1, $CellContext`r2, $CellContext`r3}, \
$CellContext`ZAxis]; $CellContext`PAxis = $CellContext`PAxis/Sqrt[
                    
                    Dot[$CellContext`PAxis, $CellContext`PAxis]]; \
$CellContext`normalizedpolarization = 
                    Part[{$CellContext`pol1, $CellContext`pol2, \
$CellContext`pol3}, {1, 
                    2}]; $CellContext`normalizedpolarization = \
$CellContext`normalizedpolarization/Sqrt[
                    
                    Dot[$CellContext`normalizedpolarization, \
$CellContext`normalizedpolarization]]; $CellContext`allcreatedamplitudes = {{
                    0. I, 0. I, 0. I}}; $CellContext`amplitude = 
                    Sqrt[$CellContext`intensity] (
                    Part[$CellContext`normalizedpolarization, 
                    1] {$CellContext`r4, $CellContext`r5, $CellContext`r6} + 
                    Part[$CellContext`normalizedpolarization, 
                    2] {$CellContext`r7, $CellContext`r8, $CellContext`r9} 
                    Exp[I $CellContext`pol3 
                    0.017453292519943295`]); \
$CellContext`perpendicularamplitude = 
                    Dot[$CellContext`amplitude, $CellContext`YAxis]; \
$CellContext`parallelamplitude = 
                    Dot[$CellContext`amplitude, $CellContext`PAxis]; 
                    If[$CellContext`activeregion Part[
                    
                    Dot[$CellContext`surfacerotationmatrix, {$CellContext`r1, \
$CellContext`r2, $CellContext`r3}], 1] > 
                    0, $CellContext`index2 = 
                    Sqrt[3.0539614 - 0.011580432 $CellContext`wavelength^2 + 
                    0.039199816/$CellContext`wavelength^2 + 
                    0.0029462812/$CellContext`wavelength^4 - 
                    0.00020371019000000004`/$CellContext`wavelength^6 + 
                    0.000027633568999999998`/$CellContext`wavelength^8]; \
$CellContext`index1 = $CellContext`index; 
                    If[Abs[$CellContext`index2 - $CellContext`index1] < 
                    0.01, $CellContext`alternateindex = 
                    Sqrt[1.0005281111748805` - 
                    2.364805676582992*^-10 $CellContext`wavelength^2 + 
                    2.9781670902982902`*^-6/$CellContext`wavelength^2 + 
                    2.6004099469477187`*^-8/$CellContext`wavelength^4 + 
                    3.7787839314048715`*^-10/$CellContext`wavelength^6 + 
                    2.830549017940716*^-12/$CellContext`wavelength^8]; 
                    If[Abs[$CellContext`alternateindex - $CellContext`index1] > 
                    Abs[$CellContext`index2 - $CellContext`index1], \
$CellContext`index1 = $CellContext`index2; $CellContext`index2 = \
$CellContext`alternateindex, $CellContext`index1 = \
$CellContext`alternateindex], $CellContext`index1 = 
                    Sqrt[1.0005281111748805` - 
                    2.364805676582992*^-10 $CellContext`wavelength^2 + 
                    2.9781670902982902`*^-6/$CellContext`wavelength^2 + 
                    2.6004099469477187`*^-8/$CellContext`wavelength^4 + 
                    3.7787839314048715`*^-10/$CellContext`wavelength^6 + 
                    2.830549017940716*^-12/$CellContext`wavelength^8]], \
$CellContext`index2 = Sqrt[1.0005281111748805` - 
                    2.364805676582992*^-10 $CellContext`wavelength^2 + 
                    2.9781670902982902`*^-6/$CellContext`wavelength^2 + 
                    2.6004099469477187`*^-8/$CellContext`wavelength^4 + 
                    3.7787839314048715`*^-10/$CellContext`wavelength^6 + 
                    2.830549017940716*^-12/$CellContext`wavelength^8]; \
$CellContext`index1 = $CellContext`index; 
                    If[Abs[$CellContext`index2 - $CellContext`index1] < 
                    0.01, $CellContext`alternateindex = 
                    Sqrt[3.0539614 - 0.011580432 $CellContext`wavelength^2 + 
                    0.039199816/$CellContext`wavelength^2 + 
                    0.0029462812/$CellContext`wavelength^4 - 
                    0.00020371019000000004`/$CellContext`wavelength^6 + 
                    0.000027633568999999998`/$CellContext`wavelength^8]; 
                    If[Abs[$CellContext`alternateindex - $CellContext`index1] > 
                    
                    Abs[$CellContext`index2 - $CellContext`index1], \
$CellContext`index1 = $CellContext`index2; $CellContext`index2 = \
$CellContext`alternateindex, $CellContext`index1 = \
$CellContext`alternateindex], $CellContext`index1 = 
                    Sqrt[3.0539614 - 0.011580432 $CellContext`wavelength^2 + 
                    0.039199816/$CellContext`wavelength^2 + 
                    0.0029462812/$CellContext`wavelength^4 - 
                    0.00020371019000000004`/$CellContext`wavelength^6 + 
                    0.000027633568999999998`/$CellContext`wavelength^8]]]; \
$CellContext`n12 = $CellContext`index1/$CellContext`index2; \
$CellContext`index = $CellContext`index2; 
                    If[1 - $CellContext`n12^2 $CellContext`raytiltx^2 >= 
                    0., $CellContext`dummyvector = $CellContext`n12 \
{$CellContext`r1, $CellContext`r2, $CellContext`r3} + $CellContext`ZAxis \
(-($CellContext`n12 $CellContext`raytiltz) + 
                    Sqrt[1 - $CellContext`n12^2 $CellContext`raytiltx^2]); \
{$CellContext`r1, $CellContext`r2, $CellContext`r3} = \
$CellContext`dummyvector; 1., 
                    If[Dot[{$CellContext`r1, $CellContext`r2, \
$CellContext`r3}, 
                    Part[$CellContext`surfnorm, 1]] > 
                    0, $CellContext`phaseshift = $CellContext`phaseshift + 
                    0.5, 1.]; $CellContext`index2 = $CellContext`index1; \
$CellContext`index = $CellContext`index1; $CellContext`dummyvector = \
{$CellContext`r1, $CellContext`r2, $CellContext`r3} - 2 $CellContext`ZAxis 
                    Dot[$CellContext`ZAxis, {$CellContext`r1, \
$CellContext`r2, $CellContext`r3}]; {$CellContext`r1, $CellContext`r2, \
$CellContext`r3} = $CellContext`dummyvector; $CellContext`dummyvector = \
{$CellContext`pol1, $CellContext`pol2, $CellContext`pol3} + {0, 
                    0, -180}; {$CellContext`pol1, $CellContext`pol2, \
$CellContext`pol3} = $CellContext`dummyvector; 
                    1.]; $CellContext`allcreatedrays = {{$CellContext`rsx, \
$CellContext`rsy, $CellContext`rsz, $CellContext`rex, $CellContext`rey, \
$CellContext`rez, $CellContext`r1, $CellContext`r2, $CellContext`r3, \
$CellContext`r4, $CellContext`r5, $CellContext`r6, $CellContext`r7, \
$CellContext`r8, $CellContext`r9, $CellContext`wavelength, \
$CellContext`intensity, $CellContext`intensityscale, $CellContext`ray1, \
$CellContext`index, $CellContext`opticallength, $CellContext`phaseshift, \
$CellContext`componentnumber, $CellContext`surfacenumber, \
$CellContext`surfaceid, $CellContext`ray2, $CellContext`ray3, \
$CellContext`sid, $CellContext`frontid, $CellContext`sno1, $CellContext`sno2, \
$CellContext`sno3, $CellContext`sno4, $CellContext`rayslot, \
$CellContext`generationnumber, $CellContext`intersectionnumber, \
$CellContext`pol1, $CellContext`pol2, $CellContext`pol3}}; \
$CellContext`originalrotation = Partition[
                    Take[$CellContext`originalray, {7, 15}], 
                    3]; $CellContext`previoustilt = 
                    Part[$CellContext`originalrotation, 
                    1]; $CellContext`transmatrix = 
                    MapIndexed[({$CellContext`rsx, $CellContext`rsy, \
$CellContext`rsz, $CellContext`rex, $CellContext`rey, $CellContext`rez, \
$CellContext`r1, $CellContext`r2, $CellContext`r3, $CellContext`r4, \
$CellContext`r5, $CellContext`r6, $CellContext`r7, $CellContext`r8, \
$CellContext`r9, $CellContext`wavelength, $CellContext`intensity, \
$CellContext`intensityscale, $CellContext`ray1, $CellContext`index, \
$CellContext`opticallength, $CellContext`phaseshift, \
$CellContext`componentnumber, $CellContext`surfacenumber, \
$CellContext`surfaceid, $CellContext`ray2, $CellContext`ray3, \
$CellContext`sid, $CellContext`frontid, $CellContext`sno1, $CellContext`sno2, \
$CellContext`sno3, $CellContext`sno4, $CellContext`rayslot, \
$CellContext`oldgenerationnumber, $CellContext`intersectionnumber, \
$CellContext`pol1, $CellContext`pol2, $CellContext`pol3} = #; \
$CellContext`rotationaxis = Cross[{1., 0., 
                    0.}, {$CellContext`r1, $CellContext`r2, $CellContext`r3}]; \
$CellContext`axismagnitude = Sqrt[
                    
                    Dot[$CellContext`rotationaxis, \
$CellContext`rotationaxis]]; If[
                    Chop[$CellContext`axismagnitude] != 
                    0., $CellContext`rotationaxis = \
$CellContext`rotationaxis/$CellContext`axismagnitude; $CellContext`axismatrix = 
                    Map[# $CellContext`rotationaxis& , \
$CellContext`rotationaxis]; $CellContext`crossmatrix = {{
                    0., -Part[$CellContext`rotationaxis, 3], 
                    Part[$CellContext`rotationaxis, 2]}, {
                    Part[$CellContext`rotationaxis, 3], 0., -
                    Part[$CellContext`rotationaxis, 1]}, {-
                    Part[$CellContext`rotationaxis, 2], 
                    Part[$CellContext`rotationaxis, 1], 
                    0.}}; $CellContext`cosangle = 
                    Dot[{1., 0., 
                    0.}, {$CellContext`r1, $CellContext`r2, $CellContext`r3}]; 
                    If[1. - $CellContext`cosangle < 
                    2.220446049250313*^-16, $CellContext`cosangle = 
                    1.]; $CellContext`sinangle = 1 - $CellContext`cosangle^2; 
                    If[$CellContext`sinangle < 
                    2.220446049250313*^-16, $CellContext`sinangle = 
                    0., $CellContext`sinangle = 
                    Sqrt[$CellContext`sinangle]]; $CellContext`axismatrix + \
({{1., 0., 0.}, {0., 1., 0.}, {0., 0., 
                    1.}} - $CellContext`axismatrix) $CellContext`cosangle + \
$CellContext`crossmatrix $CellContext`sinangle, {{$CellContext`r1, \
$CellContext`r2, $CellContext`r3}, {$CellContext`r4, $CellContext`r5, \
$CellContext`r6}, {$CellContext`r7, $CellContext`r8, $CellContext`r9}} = 
                    If[Sign[
                    
                    Dot[{1., 0., 
                    0.}, {$CellContext`r1, $CellContext`r2, \
$CellContext`r3}]] === 1, {{1., 0., 0.}, {0., 1., 0.}, {0., 0., 1.}}, {{-1., 
                    0., 0.}, {0., -1., 0.}, {0., 0., 
                    1.}}]])& , $CellContext`allcreatedrays]; \
$CellContext`allcreatedrays = 
                    MapIndexed[({$CellContext`rsx, $CellContext`rsy, \
$CellContext`rsz, $CellContext`rex, $CellContext`rey, $CellContext`rez, \
$CellContext`r1, $CellContext`r2, $CellContext`r3, $CellContext`r4, \
$CellContext`r5, $CellContext`r6, $CellContext`r7, $CellContext`r8, \
$CellContext`r9, $CellContext`wavelength, $CellContext`intensity, \
$CellContext`intensityscale, $CellContext`ray1, $CellContext`index, \
$CellContext`opticallength, $CellContext`phaseshift, \
$CellContext`componentnumber, $CellContext`surfacenumber, \
$CellContext`surfaceid, $CellContext`ray2, $CellContext`ray3, \
$CellContext`sid, $CellContext`frontid, $CellContext`sno1, $CellContext`sno2, \
$CellContext`sno3, $CellContext`sno4, $CellContext`rayslot, \
$CellContext`oldgenerationnumber, $CellContext`intersectionnumber, \
$CellContext`pol1, $CellContext`pol2, $CellContext`pol3} = #; \
{{$CellContext`r1, $CellContext`r2, $CellContext`r3}, {$CellContext`r4, \
$CellContext`r5, $CellContext`r6}, {$CellContext`r7, $CellContext`r8, \
$CellContext`r9}} = Function[$CellContext`mm, 
                    Map[
                    Dot[$CellContext`mm, #]& , {{1., 0., 0.}, {0., 1., 0.}, {
                    0., 0., 1.}}]][
                    Part[$CellContext`transmatrix, 
                    First[#2]]]; $CellContext`tiltmagnitude = 
                    Dot[{$CellContext`r1, $CellContext`r2, $CellContext`r3}, \
{$CellContext`r1, $CellContext`r2, $CellContext`r3}]; 
                    If[Abs[$CellContext`tiltmagnitude - 1.] > 
                    1.*^-6, $CellContext`dummyvector = {$CellContext`r1, \
$CellContext`r2, $CellContext`r3}/
                    Sqrt[$CellContext`tiltmagnitude]; {$CellContext`r1, \
$CellContext`r2, $CellContext`r3} = $CellContext`dummyvector; \
$CellContext`dummymatrix = Map[#/Sqrt[
                    
                    Dot[#, #]]& , {{$CellContext`r1, $CellContext`r2, \
$CellContext`r3}, {$CellContext`r4, $CellContext`r5, $CellContext`r6}, \
{$CellContext`r7, $CellContext`r8, $CellContext`r9}}]; {{$CellContext`r1, \
$CellContext`r2, $CellContext`r3}, {$CellContext`r4, $CellContext`r5, \
$CellContext`r6}, {$CellContext`r7, $CellContext`r8, $CellContext`r9}} = \
$CellContext`dummymatrix; 1., 1.]; 
                    If[$CellContext`allcreatedamplitudes != {{
                    0. I, 0. I, 0. I}}, $CellContext`amplitude = 
                    Part[$CellContext`allcreatedamplitudes, 
                    First[#2]]; $CellContext`hor = 
                    
                    Dot[{$CellContext`r4, $CellContext`r5, $CellContext`r6}, \
$CellContext`amplitude]; $CellContext`ver = 
                    Dot[{$CellContext`r7, $CellContext`r8, $CellContext`r9}, \
$CellContext`amplitude]; If[
                    Or[
                    Abs[$CellContext`hor] > 0., Abs[$CellContext`ver] > 
                    0.], {$CellContext`pol1, $CellContext`pol2, \
$CellContext`pol3} = {
                    Abs[$CellContext`hor], 
                    Abs[$CellContext`ver], 
                    0.}; $CellContext`dummyvector = {$CellContext`pol1, \
$CellContext`pol2, $CellContext`pol3}/Sqrt[
                    
                    Dot[{$CellContext`pol1, $CellContext`pol2, \
$CellContext`pol3}, {$CellContext`pol1, $CellContext`pol2, \
$CellContext`pol3}]]; {$CellContext`pol1, $CellContext`pol2, \
$CellContext`pol3} = $CellContext`dummyvector; $CellContext`dummyvector = 
                    ReplacePart[{$CellContext`pol1, $CellContext`pol2, \
$CellContext`pol3}, (If[$CellContext`ver == 0., 0., 
                    Arg[$CellContext`ver]] - If[$CellContext`hor == 0., 0., 
                    Arg[$CellContext`hor]])/Degree, 
                    3]; {$CellContext`pol1, $CellContext`pol2, \
$CellContext`pol3} = $CellContext`dummyvector]; 1., 
                    1.]; {$CellContext`rsx, $CellContext`rsy, \
$CellContext`rsz, $CellContext`rex, $CellContext`rey, $CellContext`rez, \
$CellContext`r1, $CellContext`r2, $CellContext`r3, $CellContext`r4, \
$CellContext`r5, $CellContext`r6, $CellContext`r7, $CellContext`r8, \
$CellContext`r9, $CellContext`wavelength, $CellContext`intensity, \
$CellContext`intensityscale, $CellContext`ray1, $CellContext`index, \
$CellContext`opticallength, $CellContext`phaseshift, \
$CellContext`componentnumber, $CellContext`surfacenumber, \
$CellContext`surfaceid, $CellContext`ray2, $CellContext`ray3, \
$CellContext`sid, $CellContext`frontid, $CellContext`sno1, $CellContext`sno2, \
$CellContext`sno3, $CellContext`sno4, $CellContext`rayslot, \
$CellContext`generationnumber, $CellContext`intersectionnumber, \
$CellContext`pol1, $CellContext`pol2, $CellContext`pol3})& , \
$CellContext`allcreatedrays]); {$CellContext`allcreatedrays, CompressedData["
1:eJxTTMoPSmViYGBgBGJ1Bhj4YD9Q9H8weP+fOPVw9+7HQdPN3QDj4TcH
                   
                     "], {$CellContext`completedray}}, \
$CellContext`resonatenumber == 
                    4, {$CellContext`rsx, $CellContext`rsy, $CellContext`rsz, \
$CellContext`rex, $CellContext`rey, $CellContext`rez, $CellContext`r1, \
$CellContext`r2, $CellContext`r3, $CellContext`r4, $CellContext`r5, \
$CellContext`r6, $CellContext`r7, $CellContext`r8, $CellContext`r9, \
$CellContext`wavelength, $CellContext`intensity, $CellContext`intensityscale, \
$CellContext`ray1, $CellContext`index, $CellContext`opticallength, \
$CellContext`phaseshift, $CellContext`componentnumber, \
$CellContext`surfacenumber, $CellContext`surfaceid, $CellContext`ray2, \
$CellContext`ray3, $CellContext`sid, $CellContext`frontid, $CellContext`sno1, \
$CellContext`sno2, $CellContext`sno3, $CellContext`sno4, \
$CellContext`rayslot, $CellContext`oldgenerationnumber, \
$CellContext`intersectionnumber, $CellContext`pol1, $CellContext`pol2, \
$CellContext`pol3} = #; $CellContext`index1 = $CellContext`index; \
$CellContext`xunit = $CellContext`r1 Re[
                    Cos[
                    0.017453292519943295` $CellContext`ab]] + $CellContext`r2 
                    Re[
                    Sin[
                    0.017453292519943295` $CellContext`ab]]; \
$CellContext`yunit = $CellContext`r2 Re[
                    Cos[0.017453292519943295` $CellContext`ab]] - 
                    1. $CellContext`r1 Re[
                    Sin[
                    0.017453292519943295` $CellContext`ab]]; \
$CellContext`zunit = $CellContext`r3 
                    Re[Cos[0.017453292519943295` $CellContext`ab]^2 + 
                    Sin[0.017453292519943295` $CellContext`ab]^2]; \
$CellContext`xunit = Chop[$CellContext`xunit]; $CellContext`yunit = 
                    Chop[$CellContext`yunit]; $CellContext`zunit = 
                    Chop[$CellContext`zunit]; $CellContext`magnitude = \
($CellContext`xunit^2 + $CellContext`yunit^2 + $CellContext`zunit^2)^(
                    
                    2^(-1)); $CellContext`xunit = \
$CellContext`xunit/$CellContext`magnitude; $CellContext`yunit = \
$CellContext`yunit/$CellContext`magnitude; $CellContext`zunit = \
$CellContext`zunit/$CellContext`magnitude; $CellContext`rx = Re[
                    Cos[
                    0.017453292519943295` $CellContext`ab]] ($CellContext`rex - 
                    1. Re[$CellContext`xb1 + $CellContext`tb 
                    Cos[0.017453292519943295` $CellContext`ab]]) + Re[
                    Sin[
                    0.017453292519943295` $CellContext`ab]] ($CellContext`rey - 
                    1. Re[$CellContext`yb1 + $CellContext`tb 
                    Sin[0.017453292519943295` $CellContext`ab]]); \
$CellContext`ry = -($CellContext`rex - 1. 
                    Re[$CellContext`xb1 + $CellContext`tb 
                    Cos[0.017453292519943295` $CellContext`ab]]) Re[
                    Sin[0.017453292519943295` $CellContext`ab]] + Re[
                    Cos[
                    0.017453292519943295` $CellContext`ab]] ($CellContext`rey - 
                    1. Re[$CellContext`yb1 + $CellContext`tb 
                    Sin[0.017453292519943295` $CellContext`ab]]); \
$CellContext`rz = $CellContext`rez 
                    Re[Cos[0.017453292519943295` $CellContext`ab]^2 + 
                    Sin[0.017453292519943295` $CellContext`ab]^2]; \
$CellContext`rx = Chop[$CellContext`rx]; $CellContext`ry = 
                    Chop[$CellContext`ry]; $CellContext`rz = 
                    Chop[$CellContext`rz]; $CellContext`terminatedeflection = 
                    False; $CellContext`intersections = {{-1., 0., 
                    0.}}; $CellContext`intersections = \
$CellContext`resonateintersections; $CellContext`holeQ = 
                    Part[$CellContext`holeQlist, $CellContext`resonatenumber] == 
                    1; {$CellContext`newcomponentnumber, \
$CellContext`newsurfacenumber, $CellContext`newsurfaceid} = {1., 4., 
                    16548.}; {$CellContext`componentnumber, \
$CellContext`surfacenumber, $CellContext`surfaceid} = {1., 4., 
                    16548.}; {$CellContext`ray1, $CellContext`ray2, \
$CellContext`ray3} = Part[$CellContext`intersections, 
                    1]; $CellContext`rsx = $CellContext`rex; $CellContext`rsy = \
$CellContext`rey; $CellContext`rsz = $CellContext`rez; $CellContext`rxhlp = \
$CellContext`rx + $CellContext`ray1 $CellContext`xunit; $CellContext`ryhlp = \
$CellContext`ry + $CellContext`ray1 $CellContext`yunit; $CellContext`rzhlp = \
$CellContext`rz + $CellContext`ray1 $CellContext`zunit; $CellContext`rex = \
$CellContext`rxhlp Re[
                    Cos[0.017453292519943295` $CellContext`ab]] + 
                    Re[$CellContext`xb1 + $CellContext`tb 
                    Cos[0.017453292519943295` $CellContext`ab]] - 
                    1. $CellContext`ryhlp Re[
                    Sin[
                    0.017453292519943295` $CellContext`ab]]; $CellContext`rey = \
$CellContext`ryhlp Re[
                    Cos[
                    0.017453292519943295` $CellContext`ab]] + \
$CellContext`rxhlp Re[
                    Sin[0.017453292519943295` $CellContext`ab]] + 
                    Re[$CellContext`yb1 + $CellContext`tb 
                    Sin[0.017453292519943295` $CellContext`ab]]; \
$CellContext`rez = $CellContext`rzhlp 
                    Re[Cos[0.017453292519943295` $CellContext`ab]^2 + 
                    Sin[0.017453292519943295` $CellContext`ab]^2]; \
$CellContext`rex = Chop[$CellContext`rex]; $CellContext`rey = 
                    Chop[$CellContext`rey]; $CellContext`rez = 
                    Chop[$CellContext`rez]; If[
                    
                    And[$CellContext`rex == 0, $CellContext`rey == 
                    0, $CellContext`rez == 
                    0], $CellContext`rex = $CellContext`rxhlp + 
                    Re[$CellContext`xb1 + $CellContext`tb 
                    Cos[0.017453292519943295` $CellContext`ab]]; \
$CellContext`rey = $CellContext`ryhlp + 
                    Re[$CellContext`yb1 + $CellContext`tb 
                    Sin[0.017453292519943295` $CellContext`ab]]; \
$CellContext`rez = $CellContext`rzhlp, $CellContext`rex]; \
$CellContext`intersectionnumber = $CellContext`intersectionnumber + 
                    1.; $CellContext`opticallength = \
$CellContext`opticallength + $CellContext`ray1 $CellContext`index1; \
$CellContext`completedray = {$CellContext`rsx, $CellContext`rsy, \
$CellContext`rsz, $CellContext`rex, $CellContext`rey, $CellContext`rez, \
$CellContext`r1, $CellContext`r2, $CellContext`r3, $CellContext`r4, \
$CellContext`r5, $CellContext`r6, $CellContext`r7, $CellContext`r8, \
$CellContext`r9, $CellContext`wavelength, $CellContext`intensity, \
$CellContext`intensityscale, $CellContext`ray1, $CellContext`index, \
$CellContext`opticallength, $CellContext`phaseshift, \
$CellContext`componentnumber, $CellContext`surfacenumber, \
$CellContext`surfaceid, $CellContext`ray2, $CellContext`ray3, \
$CellContext`sid, $CellContext`frontid, $CellContext`sno1, $CellContext`sno2, \
$CellContext`sno3, $CellContext`sno4, $CellContext`rayslot, \
$CellContext`generationnumber, $CellContext`intersectionnumber, \
$CellContext`pol1, $CellContext`pol2, $CellContext`pol3}; \
$CellContext`reportedrayspresent = True; $CellContext`intersectionspresent = 
                    True; $CellContext`deflectedrayspresent = 
                    True; $CellContext`localdummyoutrayspresent = 
                    True; ($CellContext`surfnorm = 
                    1. Re[{{1., -(($CellContext`ray2/
                    Sign[$CellContext`cb2])/($CellContext`cb2^(-2) - 
                    1. $CellContext`ray2^2 - 
                    1. $CellContext`ray3^2)^0.5), -(($CellContext`ray3/
                    Sign[$CellContext`cb2])/($CellContext`cb2^(-2) - 
                    1. $CellContext`ray2^2 - 
                    1. $CellContext`ray3^2)^0.5)}, {($CellContext`ray2/
                    Sign[$CellContext`cb2])/($CellContext`cb2^(-2) - 
                    1. $CellContext`ray2^2 - 1. $CellContext`ray3^2)^0.5, 1., 
                    0.}, {($CellContext`ray3/
                    Sign[$CellContext`cb2])/($CellContext`cb2^(-2) - 
                    1. $CellContext`ray2^2 - 1. $CellContext`ray3^2)^0.5, 0., 
                    1.}}]; $CellContext`dummymatrix = Map[Dot[{{(Re[
                    Cos[0.017453292519943295` $CellContext`ab]] 
                    Re[Cos[0.017453292519943295` $CellContext`ab]^2 + 
                    Sin[0.017453292519943295` $CellContext`ab]^2])/(Re[
                    Cos[0.017453292519943295` $CellContext`ab]]^2 
                    Re[Cos[0.017453292519943295` $CellContext`ab]^2 + 
                    Sin[0.017453292519943295` $CellContext`ab]^2] + Re[
                    Sin[0.017453292519943295` $CellContext`ab]]^2 
                    Re[Cos[0.017453292519943295` $CellContext`ab]^2 + 
                    Sin[0.017453292519943295` $CellContext`ab]^2]), (-Re[
                    Sin[0.017453292519943295` $CellContext`ab]] 
                    Re[Cos[0.017453292519943295` $CellContext`ab]^2 + 
                    Sin[0.017453292519943295` $CellContext`ab]^2])/(Re[
                    Cos[0.017453292519943295` $CellContext`ab]]^2 
                    Re[Cos[0.017453292519943295` $CellContext`ab]^2 + 
                    Sin[0.017453292519943295` $CellContext`ab]^2] + Re[
                    Sin[0.017453292519943295` $CellContext`ab]]^2 
                    Re[Cos[0.017453292519943295` $CellContext`ab]^2 + 
                    Sin[0.017453292519943295` $CellContext`ab]^2]), 
                    0.}, {(Re[
                    Sin[0.017453292519943295` $CellContext`ab]] 
                    Re[Cos[0.017453292519943295` $CellContext`ab]^2 + 
                    Sin[0.017453292519943295` $CellContext`ab]^2])/(Re[
                    Cos[0.017453292519943295` $CellContext`ab]]^2 
                    Re[Cos[0.017453292519943295` $CellContext`ab]^2 + 
                    Sin[0.017453292519943295` $CellContext`ab]^2] + Re[
                    Sin[0.017453292519943295` $CellContext`ab]]^2 
                    Re[Cos[0.017453292519943295` $CellContext`ab]^2 + 
                    Sin[0.017453292519943295` $CellContext`ab]^2]), (Re[
                    Cos[0.017453292519943295` $CellContext`ab]] 
                    Re[Cos[0.017453292519943295` $CellContext`ab]^2 + 
                    Sin[0.017453292519943295` $CellContext`ab]^2])/(Re[
                    Cos[0.017453292519943295` $CellContext`ab]]^2 
                    Re[Cos[0.017453292519943295` $CellContext`ab]^2 + 
                    Sin[0.017453292519943295` $CellContext`ab]^2] + Re[
                    Sin[0.017453292519943295` $CellContext`ab]]^2 
                    Re[Cos[0.017453292519943295` $CellContext`ab]^2 + 
                    Sin[0.017453292519943295` $CellContext`ab]^2]), 0.}, {
                    0., 0., (Re[
                    Cos[0.017453292519943295` $CellContext`ab]]^2 + Re[
                    Sin[0.017453292519943295` $CellContext`ab]]^2)/(Re[
                    Cos[0.017453292519943295` $CellContext`ab]]^2 
                    Re[Cos[0.017453292519943295` $CellContext`ab]^2 + 
                    Sin[0.017453292519943295` $CellContext`ab]^2] + Re[
                    Sin[0.017453292519943295` $CellContext`ab]]^2 
                    Re[Cos[0.017453292519943295` $CellContext`ab]^2 + 
                    Sin[
                    0.017453292519943295` $CellContext`ab]^2])}}, #]& , \
$CellContext`surfnorm]; $CellContext`surfnorm = Map[#/Sqrt[
                    
                    Dot[#, #]]& , $CellContext`dummymatrix]; \
$CellContext`surfacerotationmatrix = {{
                    Re[
                    Cos[0.017453292519943295` $CellContext`ab]], 
                    Re[
                    Sin[0.017453292519943295` $CellContext`ab]], 0.}, {-Re[
                    Sin[0.017453292519943295` $CellContext`ab]], 
                    Re[
                    Cos[0.017453292519943295` $CellContext`ab]], 0.}, {0., 0., 
                    Re[
                    Cos[0.017453292519943295` $CellContext`ab]^2 + 
                    Sin[0.017453292519943295` $CellContext`ab]^2]}}; \
$CellContext`surfacetranslationvector = {
                    
                    Re[$CellContext`xb1 + $CellContext`tb 
                    Cos[0.017453292519943295` $CellContext`ab]], 
                    
                    Re[$CellContext`yb1 + $CellContext`tb 
                    Sin[0.017453292519943295` $CellContext`ab]], 
                    0.}; $CellContext`activeregion = -1.; \
$CellContext`completedray = {$CellContext`rsx, $CellContext`rsy, \
$CellContext`rsz, $CellContext`rex, $CellContext`rey, $CellContext`rez, \
$CellContext`r1, $CellContext`r2, $CellContext`r3, $CellContext`r4, \
$CellContext`r5, $CellContext`r6, $CellContext`r7, $CellContext`r8, \
$CellContext`r9, $CellContext`wavelength, $CellContext`intensity, \
$CellContext`intensityscale, $CellContext`ray1, $CellContext`index, \
$CellContext`opticallength, $CellContext`phaseshift, \
$CellContext`componentnumber, $CellContext`surfacenumber, \
$CellContext`surfaceid, $CellContext`ray2, $CellContext`ray3, \
$CellContext`sid, $CellContext`frontid, $CellContext`sno1, $CellContext`sno2, \
$CellContext`sno3, $CellContext`sno4, $CellContext`rayslot, \
$CellContext`generationnumber, $CellContext`intersectionnumber, \
$CellContext`pol1, $CellContext`pol2, $CellContext`pol3}; \
$CellContext`componentnumber = $CellContext`newcomponentnumber; \
$CellContext`surfacenumber = $CellContext`newsurfacenumber; \
$CellContext`surfaceid = $CellContext`newsurfaceid; $CellContext`originalray = \
{$CellContext`rsx, $CellContext`rsy, $CellContext`rsz, $CellContext`rex, \
$CellContext`rey, $CellContext`rez, $CellContext`r1, $CellContext`r2, \
$CellContext`r3, $CellContext`r4, $CellContext`r5, $CellContext`r6, \
$CellContext`r7, $CellContext`r8, $CellContext`r9, $CellContext`wavelength, \
$CellContext`intensity, $CellContext`intensityscale, $CellContext`ray1, \
$CellContext`index, $CellContext`opticallength, $CellContext`phaseshift, \
$CellContext`componentnumber, $CellContext`surfacenumber, \
$CellContext`surfaceid, $CellContext`ray2, $CellContext`ray3, \
$CellContext`sid, $CellContext`frontid, $CellContext`sno1, $CellContext`sno2, \
$CellContext`sno3, $CellContext`sno4, $CellContext`rayslot, \
$CellContext`generationnumber, $CellContext`intersectionnumber, \
$CellContext`pol1, $CellContext`pol2, $CellContext`pol3}; $CellContext`ZAxis = 
                    First[$CellContext`surfnorm] Sign[
                    Dot[
                    
                    First[$CellContext`surfnorm], {$CellContext`r1, \
$CellContext`r2, $CellContext`r3}]]; $CellContext`raytiltz = 
                    Dot[$CellContext`ZAxis, {$CellContext`r1, \
$CellContext`r2, $CellContext`r3}]; $CellContext`raytiltx = 
                    1 - $CellContext`raytiltz^2; 
                    If[$CellContext`raytiltx < 
                    2.220446049250313*^-16, $CellContext`raytiltx = 
                    0., $CellContext`raytiltx = 
                    Sqrt[$CellContext`raytiltx]]; $CellContext`XAxis = \
{$CellContext`r1, $CellContext`r2, $CellContext`r3} - $CellContext`ZAxis \
$CellContext`raytiltz; If[
                    Abs[$CellContext`raytiltx] < 1.*^-7, $CellContext`XAxis = 
                    Part[$CellContext`surfnorm, 
                    2], $CellContext`XAxis = \
$CellContext`XAxis/$CellContext`raytiltx]; $CellContext`YAxis = {-(
                    Part[$CellContext`ZAxis, 3] Part[$CellContext`XAxis, 2]) + 
                    Part[$CellContext`ZAxis, 2] Part[$CellContext`XAxis, 3], 
                    Part[$CellContext`ZAxis, 3] Part[$CellContext`XAxis, 1] - 
                    Part[$CellContext`ZAxis, 1] 
                    Part[$CellContext`XAxis, 3], -(
                    Part[$CellContext`ZAxis, 2] Part[$CellContext`XAxis, 1]) + 
                    Part[$CellContext`ZAxis, 1] 
                    Part[$CellContext`XAxis, 
                    2]}; $CellContext`YAxis = $CellContext`YAxis/Sqrt[
                    
                    Dot[$CellContext`YAxis, $CellContext`YAxis]]; \
$CellContext`PAxis = $CellContext`ZAxis 
                    Dot[{$CellContext`r1, $CellContext`r2, $CellContext`r3}, \
$CellContext`XAxis] - $CellContext`XAxis 
                    Dot[{$CellContext`r1, $CellContext`r2, $CellContext`r3}, \
$CellContext`ZAxis]; $CellContext`PAxis = $CellContext`PAxis/Sqrt[
                    
                    Dot[$CellContext`PAxis, $CellContext`PAxis]]; \
$CellContext`normalizedpolarization = 
                    Part[{$CellContext`pol1, $CellContext`pol2, \
$CellContext`pol3}, {1, 
                    2}]; $CellContext`normalizedpolarization = \
$CellContext`normalizedpolarization/Sqrt[
                    
                    Dot[$CellContext`normalizedpolarization, \
$CellContext`normalizedpolarization]]; $CellContext`allcreatedamplitudes = {{
                    0. I, 0. I, 0. I}}; $CellContext`amplitude = 
                    Sqrt[$CellContext`intensity] (
                    Part[$CellContext`normalizedpolarization, 
                    1] {$CellContext`r4, $CellContext`r5, $CellContext`r6} + 
                    Part[$CellContext`normalizedpolarization, 
                    2] {$CellContext`r7, $CellContext`r8, $CellContext`r9} 
                    Exp[I $CellContext`pol3 
                    0.017453292519943295`]); \
$CellContext`perpendicularamplitude = 
                    Dot[$CellContext`amplitude, $CellContext`YAxis]; \
$CellContext`parallelamplitude = 
                    Dot[$CellContext`amplitude, $CellContext`PAxis]; 
                    If[$CellContext`activeregion Part[
                    
                    Dot[$CellContext`surfacerotationmatrix, {$CellContext`r1, \
$CellContext`r2, $CellContext`r3}], 1] > 
                    0, $CellContext`index2 = 
                    Sqrt[3.0539614 - 0.011580432 $CellContext`wavelength^2 + 
                    0.039199816/$CellContext`wavelength^2 + 
                    0.0029462812/$CellContext`wavelength^4 - 
                    0.00020371019000000004`/$CellContext`wavelength^6 + 
                    0.000027633568999999998`/$CellContext`wavelength^8]; \
$CellContext`index1 = $CellContext`index; 
                    If[Abs[$CellContext`index2 - $CellContext`index1] < 
                    0.01, $CellContext`alternateindex = 
                    Sqrt[1.0005281111748805` - 
                    2.364805676582992*^-10 $CellContext`wavelength^2 + 
                    2.9781670902982902`*^-6/$CellContext`wavelength^2 + 
                    2.6004099469477187`*^-8/$CellContext`wavelength^4 + 
                    3.7787839314048715`*^-10/$CellContext`wavelength^6 + 
                    2.830549017940716*^-12/$CellContext`wavelength^8]; 
                    If[Abs[$CellContext`alternateindex - $CellContext`index1] > 
                    Abs[$CellContext`index2 - $CellContext`index1], \
$CellContext`index1 = $CellContext`index2; $CellContext`index2 = \
$CellContext`alternateindex, $CellContext`index1 = \
$CellContext`alternateindex], $CellContext`index1 = 
                    Sqrt[1.0005281111748805` - 
                    2.364805676582992*^-10 $CellContext`wavelength^2 + 
                    2.9781670902982902`*^-6/$CellContext`wavelength^2 + 
                    2.6004099469477187`*^-8/$CellContext`wavelength^4 + 
                    3.7787839314048715`*^-10/$CellContext`wavelength^6 + 
                    2.830549017940716*^-12/$CellContext`wavelength^8]], \
$CellContext`index2 = Sqrt[1.0005281111748805` - 
                    2.364805676582992*^-10 $CellContext`wavelength^2 + 
                    2.9781670902982902`*^-6/$CellContext`wavelength^2 + 
                    2.6004099469477187`*^-8/$CellContext`wavelength^4 + 
                    3.7787839314048715`*^-10/$CellContext`wavelength^6 + 
                    2.830549017940716*^-12/$CellContext`wavelength^8]; \
$CellContext`index1 = $CellContext`index; 
                    If[Abs[$CellContext`index2 - $CellContext`index1] < 
                    0.01, $CellContext`alternateindex = 
                    Sqrt[3.0539614 - 0.011580432 $CellContext`wavelength^2 + 
                    0.039199816/$CellContext`wavelength^2 + 
                    0.0029462812/$CellContext`wavelength^4 - 
                    0.00020371019000000004`/$CellContext`wavelength^6 + 
                    0.000027633568999999998`/$CellContext`wavelength^8]; 
                    If[Abs[$CellContext`alternateindex - $CellContext`index1] > 
                    Abs[$CellContext`index2 - $CellContext`index1], \
$CellContext`index1 = $CellContext`index2; $CellContext`index2 = \
$CellContext`alternateindex, $CellContext`index1 = \
$CellContext`alternateindex], $CellContext`index1 = 
                    Sqrt[3.0539614 - 0.011580432 $CellContext`wavelength^2 + 
                    0.039199816/$CellContext`wavelength^2 + 
                    0.0029462812/$CellContext`wavelength^4 - 
                    0.00020371019000000004`/$CellContext`wavelength^6 + 
                    0.000027633568999999998`/$CellContext`wavelength^8]]]; \
$CellContext`n12 = $CellContext`index1/$CellContext`index2; \
$CellContext`index = $CellContext`index2; 
                    If[1 - $CellContext`n12^2 $CellContext`raytiltx^2 >= 
                    0., $CellContext`dummyvector = $CellContext`n12 \
{$CellContext`r1, $CellContext`r2, $CellContext`r3} + $CellContext`ZAxis \
(-($CellContext`n12 $CellContext`raytiltz) + 
                    Sqrt[1 - $CellContext`n12^2 $CellContext`raytiltx^2]); \
{$CellContext`r1, $CellContext`r2, $CellContext`r3} = \
$CellContext`dummyvector; 1., 
                    If[Dot[{$CellContext`r1, $CellContext`r2, \
$CellContext`r3}, 
                    Part[$CellContext`surfnorm, 1]] > 
                    0, $CellContext`phaseshift = $CellContext`phaseshift + 
                    0.5, 1.]; $CellContext`index2 = $CellContext`index1; \
$CellContext`index = $CellContext`index1; $CellContext`dummyvector = \
{$CellContext`r1, $CellContext`r2, $CellContext`r3} - 2 $CellContext`ZAxis 
                    Dot[$CellContext`ZAxis, {$CellContext`r1, \
$CellContext`r2, $CellContext`r3}]; {$CellContext`r1, $CellContext`r2, \
$CellContext`r3} = $CellContext`dummyvector; $CellContext`dummyvector = \
{$CellContext`pol1, $CellContext`pol2, $CellContext`pol3} + {0, 
                    0, -180}; {$CellContext`pol1, $CellContext`pol2, \
$CellContext`pol3} = $CellContext`dummyvector; 
                    1.]; $CellContext`allcreatedrays = {{$CellContext`rsx, \
$CellContext`rsy, $CellContext`rsz, $CellContext`rex, $CellContext`rey, \
$CellContext`rez, $CellContext`r1, $CellContext`r2, $CellContext`r3, \
$CellContext`r4, $CellContext`r5, $CellContext`r6, $CellContext`r7, \
$CellContext`r8, $CellContext`r9, $CellContext`wavelength, \
$CellContext`intensity, $CellContext`intensityscale, $CellContext`ray1, \
$CellContext`index, $CellContext`opticallength, $CellContext`phaseshift, \
$CellContext`componentnumber, $CellContext`surfacenumber, \
$CellContext`surfaceid, $CellContext`ray2, $CellContext`ray3, \
$CellContext`sid, $CellContext`frontid, $CellContext`sno1, $CellContext`sno2, \
$CellContext`sno3, $CellContext`sno4, $CellContext`rayslot, \
$CellContext`generationnumber, $CellContext`intersectionnumber, \
$CellContext`pol1, $CellContext`pol2, $CellContext`pol3}}; \
$CellContext`originalrotation = Partition[
                    Take[$CellContext`originalray, {7, 15}], 
                    3]; $CellContext`previoustilt = 
                    Part[$CellContext`originalrotation, 
                    1]; $CellContext`transmatrix = 
                    MapIndexed[({$CellContext`rsx, $CellContext`rsy, \
$CellContext`rsz, $CellContext`rex, $CellContext`rey, $CellContext`rez, \
$CellContext`r1, $CellContext`r2, $CellContext`r3, $CellContext`r4, \
$CellContext`r5, $CellContext`r6, $CellContext`r7, $CellContext`r8, \
$CellContext`r9, $CellContext`wavelength, $CellContext`intensity, \
$CellContext`intensityscale, $CellContext`ray1, $CellContext`index, \
$CellContext`opticallength, $CellContext`phaseshift, \
$CellContext`componentnumber, $CellContext`surfacenumber, \
$CellContext`surfaceid, $CellContext`ray2, $CellContext`ray3, \
$CellContext`sid, $CellContext`frontid, $CellContext`sno1, $CellContext`sno2, \
$CellContext`sno3, $CellContext`sno4, $CellContext`rayslot, \
$CellContext`oldgenerationnumber, $CellContext`intersectionnumber, \
$CellContext`pol1, $CellContext`pol2, $CellContext`pol3} = #; \
$CellContext`rotationaxis = Cross[{1., 0., 
                    0.}, {$CellContext`r1, $CellContext`r2, $CellContext`r3}]; \
$CellContext`axismagnitude = Sqrt[
                    
                    Dot[$CellContext`rotationaxis, \
$CellContext`rotationaxis]]; 
                    If[Chop[$CellContext`axismagnitude] != 
                    0., $CellContext`rotationaxis = \
$CellContext`rotationaxis/$CellContext`axismagnitude; $CellContext`axismatrix = 
                    Map[# $CellContext`rotationaxis& , \
$CellContext`rotationaxis]; $CellContext`crossmatrix = {{
                    0., -Part[$CellContext`rotationaxis, 3], 
                    Part[$CellContext`rotationaxis, 2]}, {
                    Part[$CellContext`rotationaxis, 3], 0., -
                    Part[$CellContext`rotationaxis, 1]}, {-
                    Part[$CellContext`rotationaxis, 2], 
                    Part[$CellContext`rotationaxis, 1], 
                    0.}}; $CellContext`cosangle = 
                    Dot[{1., 0., 
                    0.}, {$CellContext`r1, $CellContext`r2, $CellContext`r3}]; 
                    If[1. - $CellContext`cosangle < 
                    2.220446049250313*^-16, $CellContext`cosangle = 
                    1.]; $CellContext`sinangle = 1 - $CellContext`cosangle^2; 
                    If[$CellContext`sinangle < 
                    2.220446049250313*^-16, $CellContext`sinangle = 
                    0., $CellContext`sinangle = 
                    Sqrt[$CellContext`sinangle]]; $CellContext`axismatrix + \
({{1., 0., 0.}, {0., 1., 0.}, {0., 0., 
                    1.}} - $CellContext`axismatrix) $CellContext`cosangle + \
$CellContext`crossmatrix $CellContext`sinangle, {{$CellContext`r1, \
$CellContext`r2, $CellContext`r3}, {$CellContext`r4, $CellContext`r5, \
$CellContext`r6}, {$CellContext`r7, $CellContext`r8, $CellContext`r9}} = 
                    If[Sign[
                    
                    Dot[{1., 0., 
                    0.}, {$CellContext`r1, $CellContext`r2, \
$CellContext`r3}]] === 1, {{1., 0., 0.}, {0., 1., 0.}, {0., 0., 1.}}, {{-1., 
                    0., 0.}, {0., -1., 0.}, {0., 0., 
                    1.}}]])& , $CellContext`allcreatedrays]; \
$CellContext`allcreatedrays = 
                    MapIndexed[({$CellContext`rsx, $CellContext`rsy, \
$CellContext`rsz, $CellContext`rex, $CellContext`rey, $CellContext`rez, \
$CellContext`r1, $CellContext`r2, $CellContext`r3, $CellContext`r4, \
$CellContext`r5, $CellContext`r6, $CellContext`r7, $CellContext`r8, \
$CellContext`r9, $CellContext`wavelength, $CellContext`intensity, \
$CellContext`intensityscale, $CellContext`ray1, $CellContext`index, \
$CellContext`opticallength, $Ce