(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     29880,        752]
NotebookOptionsPosition[     28366,        696]
NotebookOutlinePosition[     29050,        722]
CellTagsIndexPosition[     29007,        719]
WindowTitle->Binocular Disparity versus Depth (Visual Depth Perception 9) - \
Source
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Binocular Disparity versus Depth (Visual Depth Perception 9)", "Section",
 CellFrame->{{0, 0}, {0, 0}},
 ShowCellBracket->False,
 FontColor->RGBColor[0.597406, 0, 0.0527047]],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztnVuSozgWQDNiPqa3MJ+zpVlCbaB3WlGVNV9dvYH6TQRUph/ZGIHQmwvG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   "], {{0, 0}, {1800, 25}}, {0, 255},
   ColorFunction->RGBColor],
  ImageSize->{1800, 25},
  PlotRange->{{0, 1800}, {0, 25}}]], "Section",
 CellFrame->{{0, 0}, {0, 0}},
 ShowCellBracket->False],

Cell[BoxData[
 RowBox[{"Manipulate", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "motion", ",", "df", ",", "d", ",", "\[Delta]", ",", "curve", ",", 
       "value\[CapitalDelta]", ",", "value\[Delta]", ",", "value\[Theta]", 
       ",", "i", ",", "n", ",", "r"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"motion", "[", 
        RowBox[{"ff_", ",", "df_"}], "]"}], "=", 
       RowBox[{"df", " ", 
        FractionBox["i", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"df", "+", "f"}], ")"}], 
          RowBox[{"(", 
           RowBox[{"f", "+", 
            RowBox[{"n", " ", "r"}]}], ")"}]}]]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"d", "[", "f_", "]"}], "=", 
       RowBox[{"f", 
        FractionBox[
         RowBox[{"4", " ", "+", 
          SuperscriptBox[
           RowBox[{"(", 
            FractionBox["i", "f"], ")"}], "2"]}], 
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{
            FractionBox["i", "f"], "-", 
            RowBox[{"2", " ", 
             RowBox[{"Tan", "[", 
              RowBox[{"\[Delta]", "/", "2"}], "]"}]}]}], ")"}]}]], 
        RowBox[{"Tan", "[", 
         RowBox[{"\[Delta]", "/", "2"}], "]"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"\[Delta]", "=", 
       RowBox[{"\[Pi]", "/", "180."}]}], ";", 
      RowBox[{"i", "=", 
       RowBox[{"13", "/", "2"}]}], ";", 
      RowBox[{"n", "=", 
       RowBox[{"1", "/", "2"}]}], ";", 
      RowBox[{"r", "=", 
       RowBox[{"13", "/", "10"}]}], ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"curve", "=", 
       RowBox[{"Plot", "[", 
        RowBox[{
         RowBox[{"d", "[", "ff", "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"ff", ",", "10", ",", "150"}], "}"}], ",", 
         RowBox[{"AxesLabel", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Style", "[", 
             RowBox[{"\"\<f\>\"", ",", "Italic"}], "]"}], ",", 
            RowBox[{"Style", "[", 
             RowBox[{"\"\<d\>\"", ",", "Italic"}], "]"}]}], "}"}]}], ",", 
         RowBox[{"PlotStyle", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"AbsoluteThickness", "[", "2", "]"}], ",", "Red"}], 
           "}"}]}], ",", 
         RowBox[{"AxesOrigin", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{"10", ",", "0"}], "}"}]}], ",", 
         RowBox[{"PlotRange", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"-", "15"}], ",", "170"}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"-", "15"}], ",", "110"}], "}"}]}], "}"}]}]}], "]"}]}], 
      ";", "\[IndentingNewLine]", 
      RowBox[{"value\[CapitalDelta]", "=", 
       RowBox[{"Graphics", "[", 
        RowBox[{"{", 
         RowBox[{"Blue", ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Text", "[", 
             RowBox[{
              RowBox[{"Row", "[", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"Style", "[", 
                  RowBox[{"\"\<d\>\"", ",", "Italic"}], "]"}], ",", 
                 "\"\< = \>\"", ",", 
                 RowBox[{"Round", "[", 
                  RowBox[{
                   RowBox[{"d", "[", "f", "]"}], ",", ".01"}], "]"}]}], "}"}],
                "]"}], ",", 
              RowBox[{"{", 
               RowBox[{"30", ",", "100"}], "}"}]}], "]"}], ",", 
            RowBox[{"Text", "[", 
             RowBox[{
              RowBox[{"Row", "[", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{
                  RowBox[{"Style", "[", 
                   RowBox[{"\"\<d\>\"", ",", "Italic"}], "]"}], "/", 
                  RowBox[{"Style", "[", 
                   RowBox[{"\"\<f\>\"", ",", "Italic"}], "]"}]}], ",", 
                 "\"\< = \>\"", ",", 
                 RowBox[{"Round", "[", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"d", "[", "f", "]"}], "/", "f"}], ",", ".001"}], 
                  "]"}]}], "}"}], "]"}], ",", 
              RowBox[{"{", 
               RowBox[{"30", ",", "90"}], "}"}]}], "]"}], ",", 
            RowBox[{"Text", "[", 
             RowBox[{
              RowBox[{"Row", "[", 
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"Style", "[", 
                  RowBox[{"\"\<f\>\"", ",", "Italic"}], "]"}], ",", 
                 "\"\< = \>\"", ",", 
                 RowBox[{"Round", "[", 
                  RowBox[{"f", ",", ".01"}], "]"}]}], "}"}], "]"}], ",", 
              RowBox[{"{", 
               RowBox[{"30", ",", "80"}], "}"}]}], "]"}], ",", 
            RowBox[{"Line", "[", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"f", ",", "0"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"f", ",", 
                 RowBox[{"d", "[", "f", "]"}]}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"0", ",", 
                 RowBox[{"d", "[", "f", "]"}]}], "}"}]}], "}"}], "]"}]}], 
           "}"}]}], "}"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"value\[Delta]", "=", 
       RowBox[{"Graphics", "[", 
        RowBox[{"{", 
         RowBox[{"Red", ",", 
          RowBox[{"Text", "[", 
           RowBox[{
            RowBox[{"Row", "[", 
             RowBox[{"{", 
              RowBox[{
              "\"\<\[Delta]\>\"", ",", "\"\< = \>\"", ",", "1", ",", " ", 
               "\"\< \[Degree]\>\""}], "}"}], "]"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"f", "-", "5"}], ",", 
              RowBox[{
               RowBox[{"d", "[", "f", "]"}], "+", "5"}]}], "}"}]}], "]"}]}], 
         "}"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"value\[Theta]", "=", 
       RowBox[{"Graphics", "[", 
        RowBox[{"{", 
         RowBox[{"Brown", ",", 
          RowBox[{"Text", "[", 
           RowBox[{
            RowBox[{"Row", "[", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"HoldForm", "[", 
                FractionBox[
                 RowBox[{
                  RowBox[{"Style", "[", 
                   RowBox[{"\"\<d\>\"", ",", "Italic"}], "]"}], 
                  "\[InvisibleSpace]", "\[Theta]"}], 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"Style", "[", 
                    RowBox[{"\"\<d\>\"", ",", "Italic"}], "]"}], 
                   "\[InvisibleSpace]", "t"}], ")"}]], "]"}], ",", 
               "\"\< = \>\"", ",", 
               RowBox[{"Round", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"motion", "[", 
                   RowBox[{"f", ",", 
                    RowBox[{"d", "[", "f", "]"}]}], "]"}], 
                  RowBox[{"180", "/", "\[Pi]"}]}], ",", ".001"}], "]"}]}], 
              "}"}], "]"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"f", "+", "10"}], ",", 
              RowBox[{
               RowBox[{"d", "[", "f", "]"}], "-", "8"}]}], "}"}]}], "]"}]}], 
         "}"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Show", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
         "curve", ",", "value\[CapitalDelta]", ",", "value\[Delta]", ",", 
          "value\[Theta]"}], "}"}], ",", 
        RowBox[{"ImageSize", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{"500", ",", "400"}], "}"}]}]}], "]"}]}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"f", ",", "62", ",", "\"\<symmetric fixate location f\>\""}], 
      "}"}], ",", ".1", ",", "150", ",", 
     RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.42013304247304*^9, 3.4201332635734587`*^9}, {
   3.420133305516191*^9, 3.4201333993520727`*^9}, {3.420133461654393*^9, 
   3.420133631488277*^9}, 3.420133676161952*^9, {3.4201339887853613`*^9, 
   3.420134026624064*^9}, {3.420134089546619*^9, 3.4201344584115887`*^9}, {
   3.4201345292758217`*^9, 3.420134530404902*^9}, {3.420134628954533*^9, 
   3.420134629198532*^9}, 3.420135562117124*^9, {3.420135617505176*^9, 
   3.420135633645266*^9}, {3.420135681310781*^9, 3.420135874852992*^9}, {
   3.4201359569814577`*^9, 3.420135999145249*^9}, {3.420136942140017*^9, 
   3.4201370989493103`*^9}, {3.420137150701764*^9, 3.420137228016164*^9}, {
   3.424211017881403*^9, 3.4242110838794127`*^9}, {3.424212359522769*^9, 
   3.424212359781739*^9}, {3.424212770330295*^9, 3.424212770477517*^9}, {
   3.424212827047008*^9, 3.424212852843824*^9}, 3.424212926559393*^9, {
   3.424280250043977*^9, 3.424280274619439*^9}, 3.424280304835287*^9, {
   3.426352842643495*^9, 3.426352952270457*^9}, {3.427044640202651*^9, 
   3.4270451167400107`*^9}, {3.427108706296144*^9, 3.427108724831296*^9}, {
   3.4271087977051764`*^9, 3.4271088215506783`*^9}},
 CellID->1993370312]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`f$$ = 62, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`f$$], 62, "symmetric fixate location f"}, 0.1, 150}},
     Typeset`size$$ = {500., {198., 202.}}, Typeset`update$$ = 0, 
    Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`f$1162463$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`f$$ = 62}, 
      "ControllerVariables" :> {
        Hold[$CellContext`f$$, $CellContext`f$1162463$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> 
      Module[{$CellContext`motion$, $CellContext`df$, $CellContext`d$, \
$CellContext`\[Delta]$, $CellContext`curve$, \
$CellContext`value\[CapitalDelta]$, $CellContext`value\[Delta]$, \
$CellContext`value\[Theta]$, $CellContext`i$, 
         DemonstrationsTools`n$, $CellContext`r$}, $CellContext`motion$[
           Pattern[$CellContext`ff$, 
            Blank[]], 
           Pattern[$CellContext`df$, 
            
            Blank[]]] = $CellContext`df$ ($CellContext`i$/(($CellContext`df$ + \
$CellContext`f$$) ($CellContext`f$$ + 
            DemonstrationsTools`n$ $CellContext`r$))); $CellContext`d$[
           Pattern[$CellContext`f$, 
            
            Blank[]]] = ($CellContext`f$ ((
             4 + ($CellContext`i$/$CellContext`f$)^2)/(
            2 ($CellContext`i$/$CellContext`f$ - 2 
             Tan[$CellContext`\[Delta]$/2])))) 
          Tan[$CellContext`\[Delta]$/2]; $CellContext`\[Delta]$ = 
         Pi/180.; $CellContext`i$ = 13/2; 
        DemonstrationsTools`n$ = 1/2; $CellContext`r$ = 
         13/10; $CellContext`curve$ = Plot[
           $CellContext`d$[$CellContext`ff], {$CellContext`ff, 10, 150}, 
           AxesLabel -> {
             Style["f", Italic], 
             Style["d", Italic]}, PlotStyle -> {
             AbsoluteThickness[2], Red}, AxesOrigin -> {10, 0}, 
           PlotRange -> {{-15, 170}, {-15, 
            110}}]; $CellContext`value\[CapitalDelta]$ = Graphics[{Blue, {
             Text[
              Row[{
                Style["d", Italic], " = ", 
                Round[
                 $CellContext`d$[$CellContext`f$$], 0.01]}], {30, 100}], 
             Text[
              Row[{Style["d", Italic]/Style["f", Italic], " = ", 
                
                Round[$CellContext`d$[$CellContext`f$$]/$CellContext`f$$, 
                 0.001]}], {30, 90}], 
             Text[
              Row[{
                Style["f", Italic], " = ", 
                Round[$CellContext`f$$, 0.01]}], {30, 80}], 
             Line[{{$CellContext`f$$, 0}, {$CellContext`f$$, 
                $CellContext`d$[$CellContext`f$$]}, {0, 
                $CellContext`d$[$CellContext`f$$]}}]}}]; $CellContext`value\
\[Delta]$ = Graphics[{Red, 
            Text[
             
             Row[{"\[Delta]", " = ", 1, " \[Degree]"}], {$CellContext`f$$ - 
              5, $CellContext`d$[$CellContext`f$$] + 
              5}]}]; $CellContext`value\[Theta]$ = Graphics[{Brown, 
            Text[
             Row[{
               HoldForm[
               Style["d", Italic] ($CellContext`\[Theta]/(
                 Style["d", Italic] $CellContext`t))], " = ", 
               Round[$CellContext`motion$[$CellContext`f$$, 
                  $CellContext`d$[$CellContext`f$$]] (180/Pi), 
                0.001]}], {$CellContext`f$$ + 
              10, $CellContext`d$[$CellContext`f$$] - 8}]}]; 
        Show[{$CellContext`curve$, $CellContext`value\[CapitalDelta]$, \
$CellContext`value\[Delta]$, $CellContext`value\[Theta]$}, 
          ImageSize -> {500, 400}]], 
      "Specifications" :> {{{$CellContext`f$$, 62, 
          "symmetric fixate location f"}, 0.1, 150, Appearance -> "Labeled"}},
       "Options" :> {}, "DefaultOptions" :> {ControllerLinking -> True}],
     ImageSizeCache->{545., {242., 247.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellID->324662095],

Cell[CellGroupData[{

Cell["CAPTION", "Section",
 CellFrame->{{0, 0}, {1, 0}},
 CellFrameColor->RGBColor[0.87, 0.87, 0.87],
 FontFamily->"Helvetica",
 FontSize->12,
 FontWeight->"Bold",
 FontColor->RGBColor[0.597406, 0, 0.0527047]],

Cell["\<\
This Demonstration shows that binocular disparity alone does NOT determine \
the relative depth of a distractor.\
\>", "Text"]
}, Close]]
}, Open  ]],

Cell[TextData[{
 "The slider ",
 Cell[BoxData[
  FormBox["f", TraditionalForm]], "InlineMath"],
 " allows you to vary the symmetric fixate location (shown in the details), \
while the program computes the symmetric depth ",
 Cell[BoxData[
  FormBox["d", TraditionalForm]], "InlineMath"],
 " needed to maintain a binocular disparity of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Delta]", "=", "1"}], TraditionalForm]], "InlineMath"],
 " degree. Distances are in centimeters."
}], "Text"],

Cell[CellGroupData[{

Cell["DETAILS", "Section",
 CellFrame->{{0, 0}, {1, 0}},
 CellFrameColor->RGBColor[0.87, 0.87, 0.87],
 FontFamily->"Helvetica",
 FontSize->12,
 FontWeight->"Bold",
 FontColor->RGBColor[0.597406, 0, 0.0527047]],

Cell["\<\
Binocular disparity is explained in more detail in the Demonstration \
\"Binocular Disparity (Visual Depth Perception 7)\" and the addition of \
convergence for depth is in \"Disparity, Convergence, and Depth (Visual Depth \
Perception 10)\" (see Related Links).\
\>", "Text"],

Cell[TextData[{
 "For this Demonstration, we also give the value of the retinal motion rate \
",
 Cell[BoxData[
  FormBox[
   RowBox[{"d", "\[VeryThinSpace]", 
    RowBox[{"\[Theta]", "/", "d"}], "\[VeryThinSpace]", "t"}], 
   TraditionalForm]], "InlineMath"],
 " for an observer moving at 6.5 cm/sec (interocular distance per second)."
}], "Text"],

Cell[TextData[Cell[BoxData[
 FormBox[
  GraphicsBox[{{}, {InsetBox[
      GraphicsBox[{{
         {GrayLevel[0.5], AbsoluteThickness[2], 
          CircleBox[{3.25, 0.}, 1.3, {2.54717154738608, 
           8.030356854565667}]}, 
         {GrayLevel[0.5], 
          CircleBox[{2.683212115380769, 0.8719813609526625}, 0.65, {
           0.6471715473860802, 3.64717154738608}]}, 
         {RGBColor[0, 1, 0], 
          DiskBox[{2.8957575721129807`, 0.5449883505954141}, 0.13]}}, {
         {GrayLevel[0.5], AbsoluteThickness[2], 
          CircleBox[{-3.25, 0.}, 1.3, {1.3944211062037128`, 
           6.877606413383299}]}, 
         {GrayLevel[0.5], 
          CircleBox[{-2.683212115380769, 0.8719813609526625}, 
           0.65, {-0.5055788937962871, 2.494421106203713}]}, 
         {RGBColor[0, 1, 0], 
          DiskBox[{-2.8957575721129807`, 0.5449883505954141}, 0.13]}}, 
        {GrayLevel[0], LineBox[{{9.75, 0.}, {-9.75, 0.}}]}, {
         {RGBColor[1, 0, 1], 
          InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Theta]\\), \
\\(r\\)]\\)\"\>", {1.1516245496631443`, 4.033254395495087}], 
          CircleBox[{2.8957575721129807`, 0.5449883505954141}, 3.25, {
           1.9412898100876528`, 2.14717154738608}]}, 
         {RGBColor[1, 0, 1], 
          InsetBox["\<\"\\!\\(\\*SubscriptBox[\\(\[Theta]\\), \
\\(l\\)]\\)\"\>", {-1.1516245496631443`, 4.033254395495087}], 
          CircleBox[{-2.8957575721129807`, 0.5449883505954141}, 3.25, {
           0.9944211062037129, 1.2003028435021403`}]}}, 
        {RGBColor[1, 0, 0], AbsolutePointSize[4], PointBox[{0, 5}], 
         InsetBox["\<\"F\"\>", {-0.5, 5.}], LineBox[{{0, 0}, {0, 5}}], 
         InsetBox["\<\"f\"\>", NCache[{-0.3, Rational[5, 2]}, {-0.3, 2.5}]], 
         LineBox[{{-2.8957575721129807`, 0.5449883505954141}, {0, 5}}], 
         LineBox[{{2.8957575721129807`, 0.5449883505954141}, {0, 5}}]}, 
        {RGBColor[0, 0, 1], AbsolutePointSize[5], PointBox[{0, 8}], 
         InsetBox["\<\"D\"\>", {0.5, 8.}], 
         LineBox[{{-2.8957575721129807`, 0.5449883505954141}, {0, 8}}], 
         LineBox[{{2.8957575721129807`, 0.5449883505954141}, {0, 8}}], 
         LineBox[{{0, 5}, {0, 8}}], InsetBox["\<\"d\"\>", {0.3, 6}]}},
       AspectRatio->Automatic,
       PlotRange->{{-5, 5}, {-3, 9}}], {192., -226.80000000000004`}, 
      ImageScaled[{0.5, 0.5}], {360., 432.00000000000006`}], InsetBox[
      GraphicsBox[{{
         {GrayLevel[0.5], AbsoluteThickness[2], Dashing[0.025], 
          LineBox[{{-1.3, -1.9500000000000002`}, {
           1.3, -1.9500000000000002`}, {0.9099999999999999, -2.08}}], 
          CircleBox[{0., 0.}, 1.3, {1.9707963267948965`, 7.453981633974482}]}, 
         {GrayLevel[0.5], 
          CircleBox[{0., 1.04}, 0.65, {0.07079632679489656, 
           3.0707963267948966`}]}, 
         {RGBColor[0, 1, 0], DiskBox[{0., 0.65}, 0.13]}}, 
        {GrayLevel[0], LineBox[{{6.5, 0.}, {-13., 0.}}]}, 
        {RGBColor[1, 0, 1], 
         InsetBox["\<\"\\!\\(\\*FractionBox[SubscriptBox[\\(d\[Theta]\\), \
\\(r\\)], \\(dt\\)]\\)[t=0]\"\>", {2, 3}]}, 
        {RGBColor[1, 0, 0], AbsolutePointSize[4], PointBox[{0, 5}], 
         InsetBox["\<\"F\"\>", {-0.5, 5.}], 
         InsetBox["\<\"f\"\>", NCache[{-0.3, Rational[5, 2]}, {-0.3, 2.5}]], 
         LineBox[{{-5.98479440708201, 0.39631199455230004`}, {0, 5}}], 
         LineBox[{{0., 0.65}, {0, 5}}]}, 
        {RGBColor[0, 0, 1], AbsolutePointSize[5], PointBox[{0, 8}], 
         InsetBox["\<\"D\"\>", {0.5, 8.}], 
         LineBox[{{-5.98479440708201, 0.39631199455230004`}, {0, 8}}], 
         LineBox[{{0.1, 0.65}, {0.1, 8}}], LineBox[{{0, 5}, {0, 8}}], 
         InsetBox["\<\"d\"\>", {0.3, 6}]}},
       AspectRatio->Automatic,
       PlotRange->{{-5, 5}, {-3, 9}}], {576., -226.80000000000004`}, 
      ImageScaled[{0.5, 0.5}], {360., 432.00000000000006`}]}, {}},
   ImageMargins->{{14., 0.}, {0., 0.}},
   ImageSize->{283., Automatic},
   PlotRangePadding->{6, 5}], TraditionalForm]], "InlineMath"]], "Text"],

Cell["\<\
Motion parallax is asymptotic to binocular disparity at long fixate \
distances; see the Demonstration \"Dynamic Approximation of Static Quantities \
(Visual Depth Perception 14)\" in the Related Links.\
\>", "Text"]
}, Close]],

Cell[CellGroupData[{

Cell["THIS NOTEBOOK IS THE SOURCE CODE FROM", "Text",
 CellFrame->{{0, 0}, {0, 0}},
 CellMargins->{{48, 10}, {4, 28}},
 CellGroupingRules->{"SectionGrouping", 25},
 CellFrameMargins->{{48, 48}, {6, 5}},
 CellFrameColor->RGBColor[0.87, 0.87, 0.87],
 FontFamily->"Helvetica",
 FontSize->10,
 FontWeight->"Bold",
 FontColor->RGBColor[0.597406, 0, 0.0527047]],

Cell[TextData[{
 "\"",
 ButtonBox["Binocular Disparity versus Depth (Visual Depth Perception 9)",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/\
BinocularDisparityVersusDepthVisualDepthPerception9/"], None},
  ButtonNote->
   "http://demonstrations.wolfram.com/\
BinocularDisparityVersusDepthVisualDepthPerception9/"],
 "\"",
 " from ",
 ButtonBox["the Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->"http://demonstrations.wolfram.com/"],
 "\[ParagraphSeparator]\[NonBreakingSpace]",
 ButtonBox["http://demonstrations.wolfram.com/\
BinocularDisparityVersusDepthVisualDepthPerception9/",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/\
BinocularDisparityVersusDepthVisualDepthPerception9/"], None},
  ButtonNote->
   "http://demonstrations.wolfram.com/\
BinocularDisparityVersusDepthVisualDepthPerception9/"]
}], "Text",
 CellMargins->{{48, Inherited}, {0, Inherited}},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.5]],

Cell[TextData[{
 "Contributed by: ",
 ButtonBox["Keith Stroyan",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/author.html?author=Keith+Stroyan"],
     None},
  ButtonNote->
   "http://demonstrations.wolfram.com/author.html?author=Keith+Stroyan"]
}], "Text",
 CellDingbat->"\[FilledSmallSquare]",
 CellMargins->{{66, 48}, {2, 4}},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.6],
 CellID->95413255],

Cell[CellGroupData[{

Cell[TextData[{
 "A full-function Wolfram ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " system (Version 6 or higher) is required to edit this notebook.\n",
 StyleBox[ButtonBox["GET WOLFRAM MATHEMATICA \[RightGuillemet]",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolfram.com/products/mathematica/"], None},
  ButtonNote->"http://www.wolfram.com/products/mathematica/"],
  FontFamily->"Helvetica",
  FontWeight->"Bold",
  FontSlant->"Italic",
  FontColor->RGBColor[1, 0.42, 0]]
}], "Text",
 CellFrame->True,
 CellMargins->{{48, 68}, {8, 28}},
 CellFrameMargins->12,
 CellFrameColor->RGBColor[0.87, 0.87, 0.87],
 CellChangeTimes->{3.3750111182355957`*^9},
 ParagraphSpacing->{1., 1.},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.411765],
 Background->RGBColor[1, 1, 1]],

Cell[TextData[{
 "\[Copyright] ",
 StyleBox[ButtonBox["Wolfram Demonstrations Project & Contributors",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->"http://demonstrations.wolfram.com/"],
  FontColor->GrayLevel[0.6]],
 "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
 StyleBox[ButtonBox["Terms of Use",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/termsofuse.html"], None},
  ButtonNote->"http://demonstrations.wolfram.com/termsofuse.html"],
  FontColor->GrayLevel[0.6]],
 "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
 StyleBox[ButtonBox["Make a new version of this Demonstration \
\[RightGuillemet]",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/participate/upload.jsp?id=\
BinocularDisparityVersusDepthVisualDepthPerception9"], None},
  ButtonNote->None],
  FontColor->GrayLevel[0.6]]
}], "Text",
 CellFrame->{{0, 0}, {0, 0.5}},
 CellMargins->{{48, 10}, {20, 50}},
 CellFrameMargins->{{6, 0}, {6, 6}},
 CellFrameColor->GrayLevel[0.6],
 FontFamily->"Verdana",
 FontSize->9,
 FontColor->GrayLevel[0.6]]
}, Open  ]]
}, Open  ]]
},
Editable->True,
Saveable->False,
ScreenStyleEnvironment->"Working",
CellInsertionPointCell->None,
WindowSize->{745, 650},
WindowMargins->{{Inherited, Inherited}, {Inherited, 0}},
WindowElements->{
 "StatusArea", "MemoryMonitor", "MagnificationPopUp", "VerticalScrollBar", 
  "MenuBar"},
WindowTitle->"Binocular Disparity versus Depth (Visual Depth Perception 9) - \
Source",
DockedCells->{},
CellContext->Notebook,
FrontEndVersion->"8.0 for Microsoft Windows (32-bit) (November 7, 2010)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[664, 24, 180, 3, 70, "Section"],
Cell[847, 29, 3700, 64, 70, "Section"],
Cell[4550, 95, 9146, 228, 70, "Input",
 CellID->1993370312]
}, Open  ]],
Cell[CellGroupData[{
Cell[13733, 328, 4614, 97, 70, "Output",
 CellID->324662095],
Cell[CellGroupData[{
Cell[18372, 429, 209, 6, 70, "Section"],
Cell[18584, 437, 136, 3, 70, "Text"]
}, Close]]
}, Open  ]],
Cell[18746, 444, 486, 13, 70, "Text"],
Cell[CellGroupData[{
Cell[19257, 461, 209, 6, 70, "Section"],
Cell[19469, 469, 286, 5, 70, "Text"],
Cell[19758, 476, 348, 9, 70, "Text"],
Cell[20109, 487, 3972, 72, 70, "Text"],
Cell[24084, 561, 226, 4, 70, "Text"]
}, Close]],
Cell[CellGroupData[{
Cell[24346, 570, 355, 9, 70, "Text",
 CellGroupingRules->{"SectionGrouping", 25}],
Cell[24704, 581, 1110, 31, 70, "Text"],
Cell[25817, 614, 455, 15, 70, "Text",
 CellID->95413255],
Cell[CellGroupData[{
Cell[26297, 633, 815, 24, 70, "Text"],
Cell[27115, 659, 1223, 33, 70, "Text"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
(* NotebookSignature JQzJPas0Ruj2bAD8e41R1sL6 *)
