(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     39665,        980]
NotebookOptionsPosition[     38432,        935]
NotebookOutlinePosition[     39051,        959]
CellTagsIndexPosition[     39008,        956]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["A Simple Model of Magnetization", "Section",
 CellFrameColor->RGBColor[
  0.6449835965514611, 0.758632791638056, 0.2516823071641108],
 FontColor->RGBColor[
  0.6449835965514611, 0.758632791638056, 0.2516823071641108]],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"elem", "[", 
    RowBox[{"x_", ",", "y_", ",", "z_", ",", "\[CurlyPhi]_"}], "]"}], ":=", 
   RowBox[{"Rotate", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"\[CurlyPhi]", ">", "0"}], ",", "Red", ",", "Green"}], 
          "]"}], ",", 
         RowBox[{"Polygon", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{
                RowBox[{"x", "-", ".4"}], ",", 
                RowBox[{"y", "+", ".1"}], ",", 
                RowBox[{"z", "-", ".1"}]}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"x", ",", 
                RowBox[{"y", "+", ".1"}], ",", 
                RowBox[{"z", "-", ".1"}]}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"x", ",", 
                RowBox[{"y", "-", ".1"}], ",", 
                RowBox[{"z", "-", ".1"}]}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"x", "-", ".4"}], ",", 
                RowBox[{"y", "-", ".1"}], ",", 
                RowBox[{"z", "-", ".1"}]}], "}"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{
                RowBox[{"x", "-", ".4"}], ",", 
                RowBox[{"y", "+", ".1"}], ",", 
                RowBox[{"z", "+", ".1"}]}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"x", ",", 
                RowBox[{"y", "+", ".1"}], ",", 
                RowBox[{"z", "+", ".1"}]}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"x", ",", 
                RowBox[{"y", "-", ".1"}], ",", 
                RowBox[{"z", "+", ".1"}]}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"x", "-", ".4"}], ",", 
                RowBox[{"y", "-", ".1"}], ",", 
                RowBox[{"z", "+", ".1"}]}], "}"}]}], "}"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{
                RowBox[{"x", "-", ".4"}], ",", 
                RowBox[{"y", "+", ".1"}], ",", 
                RowBox[{"z", "-", ".1"}]}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"x", ",", 
                RowBox[{"y", "+", ".1"}], ",", 
                RowBox[{"z", "-", ".1"}]}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"x", ",", 
                RowBox[{"y", "+", ".1"}], ",", 
                RowBox[{"z", "+", ".1"}]}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"x", "-", ".4"}], ",", 
                RowBox[{"y", "+", ".1"}], ",", 
                RowBox[{"z", "+", ".1"}]}], "}"}]}], "}"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{
                RowBox[{"x", "-", ".4"}], ",", 
                RowBox[{"y", "-", ".1"}], ",", 
                RowBox[{"z", "-", ".1"}]}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"x", ",", 
                RowBox[{"y", "-", ".1"}], ",", 
                RowBox[{"z", "-", ".1"}]}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"x", ",", 
                RowBox[{"y", "-", ".1"}], ",", 
                RowBox[{"z", "+", ".1"}]}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"x", "-", ".4"}], ",", 
                RowBox[{"y", "-", ".1"}], ",", 
                RowBox[{"z", "+", ".1"}]}], "}"}]}], "}"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"x", ",", 
                RowBox[{"y", "-", ".1"}], ",", 
                RowBox[{"z", "-", ".1"}]}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"x", ",", 
                RowBox[{"y", "+", ".1"}], ",", 
                RowBox[{"z", "-", ".1"}]}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"x", ",", 
                RowBox[{"y", "+", ".1"}], ",", 
                RowBox[{"z", "+", ".1"}]}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"x", ",", 
                RowBox[{"y", "-", ".1"}], ",", 
                RowBox[{"z", "+", ".1"}]}], "}"}]}], "}"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{
                RowBox[{"x", "-", ".4"}], ",", 
                RowBox[{"y", "-", ".1"}], ",", 
                RowBox[{"z", "-", ".1"}]}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"x", "-", ".4"}], ",", 
                RowBox[{"y", "+", ".1"}], ",", 
                RowBox[{"z", "-", ".1"}]}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"x", "-", ".4"}], ",", 
                RowBox[{"y", "+", ".1"}], ",", 
                RowBox[{"z", "+", ".1"}]}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"x", "-", ".4"}], ",", 
                RowBox[{"y", "-", ".1"}], ",", 
                RowBox[{"z", "+", ".1"}]}], "}"}]}], "}"}]}], "}"}], "]"}]}], 
        "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{"\[CurlyPhi]", ">", "0"}], ",", "Green", ",", "Red"}], 
          "]"}], ",", 
         RowBox[{"Polygon", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"x", ",", 
                RowBox[{"y", "+", ".1"}], ",", 
                RowBox[{"z", "-", ".1"}]}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"x", "+", ".4"}], ",", 
                RowBox[{"y", "+", ".1"}], ",", 
                RowBox[{"z", "-", ".1"}]}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"x", "+", ".4"}], ",", 
                RowBox[{"y", "-", ".1"}], ",", 
                RowBox[{"z", "-", ".1"}]}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"x", ",", 
                RowBox[{"y", "-", ".1"}], ",", 
                RowBox[{"z", "-", ".1"}]}], "}"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"x", ",", 
                RowBox[{"y", "+", ".1"}], ",", 
                RowBox[{"z", "+", ".1"}]}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"x", "+", ".4"}], ",", 
                RowBox[{"y", "+", ".1"}], ",", 
                RowBox[{"z", "+", ".1"}]}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"x", "+", ".4"}], ",", 
                RowBox[{"y", "-", ".1"}], ",", 
                RowBox[{"z", "+", ".1"}]}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"x", ",", 
                RowBox[{"y", "-", ".1"}], ",", 
                RowBox[{"z", "+", ".1"}]}], "}"}]}], "}"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"x", ",", 
                RowBox[{"y", "+", ".1"}], ",", 
                RowBox[{"z", "-", ".1"}]}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"x", "+", ".4"}], ",", 
                RowBox[{"y", "+", ".1"}], ",", 
                RowBox[{"z", "-", ".1"}]}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"x", "+", ".4"}], ",", 
                RowBox[{"y", "+", ".1"}], ",", 
                RowBox[{"z", "+", ".1"}]}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"x", ",", 
                RowBox[{"y", "+", ".1"}], ",", 
                RowBox[{"z", "+", ".1"}]}], "}"}]}], "}"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"x", ",", 
                RowBox[{"y", "-", ".1"}], ",", 
                RowBox[{"z", "-", ".1"}]}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"x", "+", ".4"}], ",", 
                RowBox[{"y", "-", ".1"}], ",", 
                RowBox[{"z", "-", ".1"}]}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"x", "+", ".4"}], ",", 
                RowBox[{"y", "-", ".1"}], ",", 
                RowBox[{"z", "+", ".1"}]}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"x", ",", 
                RowBox[{"y", "-", ".1"}], ",", 
                RowBox[{"z", "+", ".1"}]}], "}"}]}], "}"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{
                RowBox[{"x", "+", ".4"}], ",", 
                RowBox[{"y", "-", ".1"}], ",", 
                RowBox[{"z", "-", ".1"}]}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"x", "+", ".4"}], ",", 
                RowBox[{"y", "+", ".1"}], ",", 
                RowBox[{"z", "-", ".1"}]}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"x", "+", ".4"}], ",", 
                RowBox[{"y", "+", ".1"}], ",", 
                RowBox[{"z", "+", ".1"}]}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"x", "+", ".4"}], ",", 
                RowBox[{"y", "-", ".1"}], ",", 
                RowBox[{"z", "+", ".1"}]}], "}"}]}], "}"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"x", ",", 
                RowBox[{"y", "-", ".1"}], ",", 
                RowBox[{"z", "-", ".1"}]}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"x", ",", 
                RowBox[{"y", "+", ".1"}], ",", 
                RowBox[{"z", "-", ".1"}]}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"x", ",", 
                RowBox[{"y", "+", ".1"}], ",", 
                RowBox[{"z", "+", ".1"}]}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"x", ",", 
                RowBox[{"y", "-", ".1"}], ",", 
                RowBox[{"z", "+", ".1"}]}], "}"}]}], "}"}]}], "}"}], "]"}]}], 
        "}"}]}], "}"}], ",", 
     RowBox[{"RandomReal", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "\[Pi]"}], "+", 
         RowBox[{"Abs", "[", "\[CurlyPhi]", "]"}], "-", ".3"}], ",", 
        RowBox[{"\[Pi]", "-", 
         RowBox[{"Abs", "[", "\[CurlyPhi]", "]"}], "+", ".3"}]}], "}"}], 
      "]"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"RandomReal", "[", "]"}], ",", 
       RowBox[{"RandomReal", "[", "]"}], ",", 
       RowBox[{"RandomReal", "[", "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{
  3.35696210375764*^9, 3.429771524706707*^9, {3.42987207884375*^9, 
   3.429872111109375*^9}, {3.4298723076875*^9, 3.42987233590625*^9}, {
   3.429872510828125*^9, 3.42987251875*^9}, {3.429872553125*^9, 
   3.429872616125*^9}, 3.429882583761919*^9, {3.4298826449680395`*^9, 
   3.4298827246010017`*^9}},
 CellID->1917415700],

Cell[BoxData[
 RowBox[{
  RowBox[{"box", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Polygon", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "5"}], ",", "1.6", ",", 
          RowBox[{"-", "1.6"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"5", ",", "1.6", ",", 
          RowBox[{"-", "1.6"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"5", ",", "1.6", ",", "1.6"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "5"}], ",", "1.6", ",", "1.6"}], "}"}]}], "}"}], "]"}],
      ",", "\[IndentingNewLine]", 
     RowBox[{"Polygon", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "5"}], ",", 
          RowBox[{"-", "1.6"}], ",", 
          RowBox[{"-", "1.6"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"5", ",", 
          RowBox[{"-", "1.6"}], ",", 
          RowBox[{"-", "1.6"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"5", ",", "1.6", ",", 
          RowBox[{"-", "1.6"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "5"}], ",", "1.6", ",", 
          RowBox[{"-", "1.6"}]}], "}"}]}], "}"}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Polygon", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "5"}], ",", 
          RowBox[{"-", "1.6"}], ",", 
          RowBox[{"-", "1.6"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "5"}], ",", "1.6", ",", 
          RowBox[{"-", "1.6"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "5"}], ",", "1.6", ",", "1.6"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "5"}], ",", 
          RowBox[{"-", "1.6"}], ",", "1.6"}], "}"}]}], "}"}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Polygon", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "5"}], ",", 
          RowBox[{"-", "1.6"}], ",", 
          RowBox[{"-", "1.6"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"5", ",", 
          RowBox[{"-", "1.6"}], ",", 
          RowBox[{"-", "1.6"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"5", ",", 
          RowBox[{"-", "1.6"}], ",", "1.6"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "5"}], ",", 
          RowBox[{"-", "1.6"}], ",", "1.6"}], "}"}]}], "}"}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Polygon", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "5"}], ",", 
          RowBox[{"-", "1.6"}], ",", "1.6"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"5", ",", 
          RowBox[{"-", "1.6"}], ",", "1.6"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"5", ",", "1.6", ",", "1.6"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "5"}], ",", "1.6", ",", "1.6"}], "}"}]}], "}"}], "]"}],
      ",", "\[IndentingNewLine]", 
     RowBox[{"Polygon", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"5", ",", 
          RowBox[{"-", "1.6"}], ",", 
          RowBox[{"-", "1.6"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"5", ",", "1.6", ",", 
          RowBox[{"-", "1.6"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"5", ",", "1.6", ",", "1.6"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"5", ",", 
          RowBox[{"-", "1.6"}], ",", "1.6"}], "}"}]}], "}"}], "]"}]}], 
    "\[IndentingNewLine]", "}"}]}], ";"}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{
  3.35696210375764*^9, {3.4298857825558662`*^9, 3.429885787988082*^9}},
 CellID->158732606],

Cell[BoxData[
 RowBox[{"Manipulate", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Graphics3D", "[", 
    RowBox[{
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Opacity", "[", ".3", "]"}], ",", 
         RowBox[{"EdgeForm", "[", 
          RowBox[{"{", "}"}], "]"}], ",", "LightGray", ",", "box"}], "}"}], 
       ",", "\[IndentingNewLine]", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"elem", "[", 
          RowBox[{"i", ",", "j", ",", "k", ",", "\[Alpha]"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", 
           RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"j", ",", 
           RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"k", ",", 
           RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}], ",", 
       RowBox[{"Polygon", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "\[Alpha]"}], ",", "0", ",", 
            RowBox[{"3", "-", 
             RowBox[{".1", "\[Alpha]"}]}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{".6", "\[Alpha]"}], ",", "0", ",", 
            RowBox[{"3", "-", 
             RowBox[{".1", "\[Alpha]"}]}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{".6", "\[Alpha]"}], ",", "0", ",", 
            RowBox[{"3", "-", 
             RowBox[{".2", "\[Alpha]"}]}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"\[Alpha]", ",", "0", ",", "3"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{".6", "\[Alpha]"}], ",", "0", ",", 
            RowBox[{"3", "+", 
             RowBox[{".2", "\[Alpha]"}]}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{".6", "\[Alpha]"}], ",", "0", ",", 
            RowBox[{"3", "+", 
             RowBox[{".1", "\[Alpha]"}]}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "\[Alpha]"}], ",", "0", ",", 
            RowBox[{"3", "+", 
             RowBox[{".1", "\[Alpha]"}]}]}], "}"}]}], "}"}], "]"}]}], "}"}], 
     ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "6"}], ",", "6"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "2"}], ",", "4"}], "}"}]}], "}"}]}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "500"}], ",", 
     RowBox[{"Boxed", "\[Rule]", "False"}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\[Alpha]", ",", "0", ",", "\"\<magnetizing field\>\""}], "}"}],
      ",", 
     RowBox[{"-", "\[Pi]"}], ",", "\[Pi]", ",", 
     FractionBox["\[Pi]", "24."], ",", 
     RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}], ",", 
   RowBox[{"SaveDefinitions", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellChangeTimes->{
  3.35696210375764*^9, 3.429771543997901*^9, {3.4297715868130903`*^9, 
   3.429771595931602*^9}, {3.42987206090625*^9, 3.4298720684375*^9}, {
   3.429872174328125*^9, 3.4298721885*^9}, {3.429872456796875*^9, 
   3.429872470875*^9}, {3.4298848673381023`*^9, 3.4298848973290253`*^9}, {
   3.429884938475013*^9, 3.4298849589778976`*^9}, {3.4298854487702265`*^9, 
   3.4298854561685905`*^9}, {3.429885572144216*^9, 3.429885589198072*^9}, {
   3.429885796347745*^9, 3.42988579949436*^9}, 3.429892327580556*^9}]
}, Open  ]],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`\[Alpha]$$ = 0, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`\[Alpha]$$], 0, "magnetizing field"}, -Pi, Pi, 
      0.1308996938995747}}, Typeset`size$$ = {500., {196., 200.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    False, $CellContext`\[Alpha]$215261$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`\[Alpha]$$ = 0}, 
      "ControllerVariables" :> {
        Hold[$CellContext`\[Alpha]$$, $CellContext`\[Alpha]$215261$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Graphics3D[{{
          Opacity[0.3], 
          EdgeForm[{}], LightGray, $CellContext`box}, 
         Table[
          $CellContext`elem[$CellContext`i, $CellContext`j, $CellContext`k, \
$CellContext`\[Alpha]$$], {$CellContext`i, -4, 4}, {$CellContext`j, -1, 
           1}, {$CellContext`k, -1, 1}], 
         Polygon[{{-$CellContext`\[Alpha]$$, 0, 3 - 
            0.1 $CellContext`\[Alpha]$$}, {
           0.6 $CellContext`\[Alpha]$$, 0, 3 - 0.1 $CellContext`\[Alpha]$$}, {
           0.6 $CellContext`\[Alpha]$$, 0, 3 - 
            0.2 $CellContext`\[Alpha]$$}, {$CellContext`\[Alpha]$$, 0, 3}, {
           0.6 $CellContext`\[Alpha]$$, 0, 3 + 0.2 $CellContext`\[Alpha]$$}, {
           0.6 $CellContext`\[Alpha]$$, 0, 3 + 
            0.1 $CellContext`\[Alpha]$$}, {-$CellContext`\[Alpha]$$, 0, 3 + 
            0.1 $CellContext`\[Alpha]$$}}]}, 
        PlotRange -> {{-6, 6}, {-2, 2}, {-2, 4}}, ImageSize -> 500, Boxed -> 
        False], "Specifications" :> {{{$CellContext`\[Alpha]$$, 0, 
          "magnetizing field"}, -Pi, Pi, 0.1308996938995747, Appearance -> 
         "Labeled"}}, "Options" :> {}, 
      "DefaultOptions" :> {ControllerLinking -> True}],
     ImageSizeCache->{544., {239., 244.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    Initialization:>(({$CellContext`box = {
          
          Polygon[{{-5, 1.6, -1.6}, {5, 1.6, -1.6}, {
            5, 1.6, 1.6}, {-5, 1.6, 1.6}}], 
          
          Polygon[{{-5, -1.6, -1.6}, {5, -1.6, -1.6}, {
            5, 1.6, -1.6}, {-5, 1.6, -1.6}}], 
          
          Polygon[{{-5, -1.6, -1.6}, {-5, 1.6, -1.6}, {-5, 1.6, 
             1.6}, {-5, -1.6, 1.6}}], 
          
          Polygon[{{-5, -1.6, -1.6}, {5, -1.6, -1.6}, {
            5, -1.6, 1.6}, {-5, -1.6, 1.6}}], 
          
          Polygon[{{-5, -1.6, 1.6}, {5, -1.6, 1.6}, {
            5, 1.6, 1.6}, {-5, 1.6, 1.6}}], 
          
          Polygon[{{5, -1.6, -1.6}, {5, 1.6, -1.6}, {5, 1.6, 1.6}, {
            5, -1.6, 1.6}}]}, $CellContext`elem[
          Pattern[$CellContext`x, 
           Blank[]], 
          Pattern[$CellContext`y, 
           Blank[]], 
          Pattern[$CellContext`z, 
           Blank[]], 
          Pattern[$CellContext`\[CurlyPhi], 
           Blank[]]] := Rotate[{{
            If[$CellContext`\[CurlyPhi] > 0, Red, Green], 
            
            Polygon[{{{$CellContext`x - 0.4, $CellContext`y + 
                0.1, $CellContext`z - 0.1}, {$CellContext`x, $CellContext`y + 
                0.1, $CellContext`z - 0.1}, {$CellContext`x, $CellContext`y - 
                0.1, $CellContext`z - 0.1}, {$CellContext`x - 
                0.4, $CellContext`y - 0.1, $CellContext`z - 
                0.1}}, {{$CellContext`x - 0.4, $CellContext`y + 
                0.1, $CellContext`z + 0.1}, {$CellContext`x, $CellContext`y + 
                0.1, $CellContext`z + 0.1}, {$CellContext`x, $CellContext`y - 
                0.1, $CellContext`z + 0.1}, {$CellContext`x - 
                0.4, $CellContext`y - 0.1, $CellContext`z + 
                0.1}}, {{$CellContext`x - 0.4, $CellContext`y + 
                0.1, $CellContext`z - 0.1}, {$CellContext`x, $CellContext`y + 
                0.1, $CellContext`z - 0.1}, {$CellContext`x, $CellContext`y + 
                0.1, $CellContext`z + 0.1}, {$CellContext`x - 
                0.4, $CellContext`y + 0.1, $CellContext`z + 
                0.1}}, {{$CellContext`x - 0.4, $CellContext`y - 
                0.1, $CellContext`z - 0.1}, {$CellContext`x, $CellContext`y - 
                0.1, $CellContext`z - 0.1}, {$CellContext`x, $CellContext`y - 
                0.1, $CellContext`z + 0.1}, {$CellContext`x - 
                0.4, $CellContext`y - 0.1, $CellContext`z + 
                0.1}}, {{$CellContext`x, $CellContext`y - 0.1, $CellContext`z - 
                0.1}, {$CellContext`x, $CellContext`y + 0.1, $CellContext`z - 
                0.1}, {$CellContext`x, $CellContext`y + 0.1, $CellContext`z + 
                0.1}, {$CellContext`x, $CellContext`y - 0.1, $CellContext`z + 
                0.1}}, {{$CellContext`x - 0.4, $CellContext`y - 
                0.1, $CellContext`z - 0.1}, {$CellContext`x - 
                0.4, $CellContext`y + 0.1, $CellContext`z - 
                0.1}, {$CellContext`x - 0.4, $CellContext`y + 
                0.1, $CellContext`z + 0.1}, {$CellContext`x - 
                0.4, $CellContext`y - 0.1, $CellContext`z + 0.1}}}]}, {
            If[$CellContext`\[CurlyPhi] > 0, Green, Red], 
            
            Polygon[{{{$CellContext`x, $CellContext`y + 0.1, $CellContext`z - 
                0.1}, {$CellContext`x + 0.4, $CellContext`y + 
                0.1, $CellContext`z - 0.1}, {$CellContext`x + 
                0.4, $CellContext`y - 0.1, $CellContext`z - 
                0.1}, {$CellContext`x, $CellContext`y - 0.1, $CellContext`z - 
                0.1}}, {{$CellContext`x, $CellContext`y + 0.1, $CellContext`z + 
                0.1}, {$CellContext`x + 0.4, $CellContext`y + 
                0.1, $CellContext`z + 0.1}, {$CellContext`x + 
                0.4, $CellContext`y - 0.1, $CellContext`z + 
                0.1}, {$CellContext`x, $CellContext`y - 0.1, $CellContext`z + 
                0.1}}, {{$CellContext`x, $CellContext`y + 0.1, $CellContext`z - 
                0.1}, {$CellContext`x + 0.4, $CellContext`y + 
                0.1, $CellContext`z - 0.1}, {$CellContext`x + 
                0.4, $CellContext`y + 0.1, $CellContext`z + 
                0.1}, {$CellContext`x, $CellContext`y + 0.1, $CellContext`z + 
                0.1}}, {{$CellContext`x, $CellContext`y - 0.1, $CellContext`z - 
                0.1}, {$CellContext`x + 0.4, $CellContext`y - 
                0.1, $CellContext`z - 0.1}, {$CellContext`x + 
                0.4, $CellContext`y - 0.1, $CellContext`z + 
                0.1}, {$CellContext`x, $CellContext`y - 0.1, $CellContext`z + 
                0.1}}, {{$CellContext`x + 0.4, $CellContext`y - 
                0.1, $CellContext`z - 0.1}, {$CellContext`x + 
                0.4, $CellContext`y + 0.1, $CellContext`z - 
                0.1}, {$CellContext`x + 0.4, $CellContext`y + 
                0.1, $CellContext`z + 0.1}, {$CellContext`x + 
                0.4, $CellContext`y - 0.1, $CellContext`z + 
                0.1}}, {{$CellContext`x, $CellContext`y - 0.1, $CellContext`z - 
                0.1}, {$CellContext`x, $CellContext`y + 0.1, $CellContext`z - 
                0.1}, {$CellContext`x, $CellContext`y + 0.1, $CellContext`z + 
                0.1}, {$CellContext`x, $CellContext`y - 0.1, $CellContext`z + 
                0.1}}}]}}, 
          
          RandomReal[{-Pi + Abs[$CellContext`\[CurlyPhi]] - 0.3, Pi - 
            Abs[$CellContext`\[CurlyPhi]] + 0.3}], {
           RandomReal[], 
           RandomReal[], 
           RandomReal[]}, {$CellContext`x, $CellContext`y, $CellContext`z}], 
        Attributes[PlotRange] = {ReadProtected}}; Typeset`initDone$$ = True); 
     ReleaseHold[
       HoldComplete[{$CellContext`elem[
            Pattern[$CellContext`x, 
             Blank[]], 
            Pattern[$CellContext`y, 
             Blank[]], 
            Pattern[$CellContext`z, 
             Blank[]], 
            Pattern[$CellContext`\[CurlyPhi], 
             Blank[]]] := Rotate[{{
              If[$CellContext`\[CurlyPhi] > 0, Red, Green], 
              
              Polygon[{{{$CellContext`x - 0.4, $CellContext`y + 
                  0.1, $CellContext`z - 0.1}, {$CellContext`x, $CellContext`y + 
                  0.1, $CellContext`z - 0.1}, {$CellContext`x, $CellContext`y - 
                  0.1, $CellContext`z - 0.1}, {$CellContext`x - 
                  0.4, $CellContext`y - 0.1, $CellContext`z - 
                  0.1}}, {{$CellContext`x - 0.4, $CellContext`y + 
                  0.1, $CellContext`z + 0.1}, {$CellContext`x, $CellContext`y + 
                  0.1, $CellContext`z + 0.1}, {$CellContext`x, $CellContext`y - 
                  0.1, $CellContext`z + 0.1}, {$CellContext`x - 
                  0.4, $CellContext`y - 0.1, $CellContext`z + 
                  0.1}}, {{$CellContext`x - 0.4, $CellContext`y + 
                  0.1, $CellContext`z - 0.1}, {$CellContext`x, $CellContext`y + 
                  0.1, $CellContext`z - 0.1}, {$CellContext`x, $CellContext`y + 
                  0.1, $CellContext`z + 0.1}, {$CellContext`x - 
                  0.4, $CellContext`y + 0.1, $CellContext`z + 
                  0.1}}, {{$CellContext`x - 0.4, $CellContext`y - 
                  0.1, $CellContext`z - 0.1}, {$CellContext`x, $CellContext`y - 
                  0.1, $CellContext`z - 0.1}, {$CellContext`x, $CellContext`y - 
                  0.1, $CellContext`z + 0.1}, {$CellContext`x - 
                  0.4, $CellContext`y - 0.1, $CellContext`z + 
                  0.1}}, {{$CellContext`x, $CellContext`y - 
                  0.1, $CellContext`z - 0.1}, {$CellContext`x, $CellContext`y + 
                  0.1, $CellContext`z - 0.1}, {$CellContext`x, $CellContext`y + 
                  0.1, $CellContext`z + 0.1}, {$CellContext`x, $CellContext`y - 
                  0.1, $CellContext`z + 0.1}}, {{$CellContext`x - 
                  0.4, $CellContext`y - 0.1, $CellContext`z - 
                  0.1}, {$CellContext`x - 0.4, $CellContext`y + 
                  0.1, $CellContext`z - 0.1}, {$CellContext`x - 
                  0.4, $CellContext`y + 0.1, $CellContext`z + 
                  0.1}, {$CellContext`x - 0.4, $CellContext`y - 
                  0.1, $CellContext`z + 0.1}}}]}, {
              If[$CellContext`\[CurlyPhi] > 0, Green, Red], 
              
              Polygon[{{{$CellContext`x, $CellContext`y + 0.1, $CellContext`z - 
                  0.1}, {$CellContext`x + 0.4, $CellContext`y + 
                  0.1, $CellContext`z - 0.1}, {$CellContext`x + 
                  0.4, $CellContext`y - 0.1, $CellContext`z - 
                  0.1}, {$CellContext`x, $CellContext`y - 0.1, $CellContext`z - 
                  0.1}}, {{$CellContext`x, $CellContext`y + 
                  0.1, $CellContext`z + 0.1}, {$CellContext`x + 
                  0.4, $CellContext`y + 0.1, $CellContext`z + 
                  0.1}, {$CellContext`x + 0.4, $CellContext`y - 
                  0.1, $CellContext`z + 0.1}, {$CellContext`x, $CellContext`y - 
                  0.1, $CellContext`z + 
                  0.1}}, {{$CellContext`x, $CellContext`y + 
                  0.1, $CellContext`z - 0.1}, {$CellContext`x + 
                  0.4, $CellContext`y + 0.1, $CellContext`z - 
                  0.1}, {$CellContext`x + 0.4, $CellContext`y + 
                  0.1, $CellContext`z + 0.1}, {$CellContext`x, $CellContext`y + 
                  0.1, $CellContext`z + 
                  0.1}}, {{$CellContext`x, $CellContext`y - 
                  0.1, $CellContext`z - 0.1}, {$CellContext`x + 
                  0.4, $CellContext`y - 0.1, $CellContext`z - 
                  0.1}, {$CellContext`x + 0.4, $CellContext`y - 
                  0.1, $CellContext`z + 0.1}, {$CellContext`x, $CellContext`y - 
                  0.1, $CellContext`z + 0.1}}, {{$CellContext`x + 
                  0.4, $CellContext`y - 0.1, $CellContext`z - 
                  0.1}, {$CellContext`x + 0.4, $CellContext`y + 
                  0.1, $CellContext`z - 0.1}, {$CellContext`x + 
                  0.4, $CellContext`y + 0.1, $CellContext`z + 
                  0.1}, {$CellContext`x + 0.4, $CellContext`y - 
                  0.1, $CellContext`z + 
                  0.1}}, {{$CellContext`x, $CellContext`y - 
                  0.1, $CellContext`z - 0.1}, {$CellContext`x, $CellContext`y + 
                  0.1, $CellContext`z - 0.1}, {$CellContext`x, $CellContext`y + 
                  0.1, $CellContext`z + 0.1}, {$CellContext`x, $CellContext`y - 
                  0.1, $CellContext`z + 0.1}}}]}}, 
            
            RandomReal[{-Pi + Abs[$CellContext`\[CurlyPhi]] - 0.3, Pi - 
              Abs[$CellContext`\[CurlyPhi]] + 0.3}], {
             RandomReal[], 
             RandomReal[], 
             RandomReal[]}, {$CellContext`x, $CellContext`y, $CellContext`z}]; 
         Null, $CellContext`box = {
            
            Polygon[{{-5, 1.6, -1.6}, {5, 1.6, -1.6}, {
              5, 1.6, 1.6}, {-5, 1.6, 1.6}}], 
            
            Polygon[{{-5, -1.6, -1.6}, {5, -1.6, -1.6}, {
              5, 1.6, -1.6}, {-5, 1.6, -1.6}}], 
            
            Polygon[{{-5, -1.6, -1.6}, {-5, 1.6, -1.6}, {-5, 1.6, 
               1.6}, {-5, -1.6, 1.6}}], 
            
            Polygon[{{-5, -1.6, -1.6}, {5, -1.6, -1.6}, {
              5, -1.6, 1.6}, {-5, -1.6, 1.6}}], 
            
            Polygon[{{-5, -1.6, 1.6}, {5, -1.6, 1.6}, {
              5, 1.6, 1.6}, {-5, 1.6, 1.6}}], 
            
            Polygon[{{5, -1.6, -1.6}, {5, 1.6, -1.6}, {5, 1.6, 1.6}, {
              5, -1.6, 1.6}}]}; Null}]]; Typeset`initDone$$ = True),
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellID->359846505],

Cell[CellGroupData[{

Cell["THIS NOTEBOOK IS THE SOURCE CODE FROM", "Text",
 CellFrame->{{0, 0}, {0, 1}},
 CellMargins->{{48, 10}, {4, 28}},
 CellGroupingRules->{"SectionGrouping", 25},
 CellFrameMargins->{{48, 48}, {6, 5}},
 CellFrameColor->RGBColor[0.691905, 0.790311, 0.300252],
 FontFamily->"Helvetica",
 FontSize->10,
 FontWeight->"Bold",
 FontColor->RGBColor[0.691905, 0.790311, 0.300252]],

Cell[TextData[{
 "\"",
 ButtonBox["A Simple Model of Magnetization",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/ASimpleModelOfMagnetization/"], 
    None},
  ButtonNote->
   "http://demonstrations.wolfram.com/ASimpleModelOfMagnetization/"],
 "\"",
 " from ",
 ButtonBox["The Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->"http://demonstrations.wolfram.com/"],
 "\[ParagraphSeparator]\[NonBreakingSpace]",
 ButtonBox["http://demonstrations.wolfram.com/ASimpleModelOfMagnetization/",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/ASimpleModelOfMagnetization/"], 
    None},
  ButtonNote->
   "http://demonstrations.wolfram.com/ASimpleModelOfMagnetization/"]
}], "Text",
 CellMargins->{{48, Inherited}, {0, Inherited}},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.5]],

Cell[" ", "Text",
 CellFrame->{{0, 0}, {0, 1}},
 CellMargins->{{48, 10}, {4, 28}},
 CellGroupingRules->{"SectionGrouping", 25},
 CellFrameMargins->{{48, 48}, {6, 5}},
 CellFrameColor->RGBColor[0.691905, 0.790311, 0.300252],
 FontFamily->"Helvetica",
 FontSize->10,
 FontWeight->"Bold",
 FontColor->RGBColor[0.691905, 0.790311, 0.300252]],

Cell[TextData[{
 "Contributed by: ",
 ButtonBox["Hans-Joachim Domke",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/author.html?author=Hans-Joachim+\
Domke"], None},
  ButtonNote->
   "http://demonstrations.wolfram.com/author.html?author=Hans-Joachim+Domke"]
}], "Text",
 CellDingbat->"\[FilledSmallSquare]",
 CellMargins->{{66, 48}, {2, 4}},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.6]],

Cell[CellGroupData[{

Cell[TextData[{
 "A full-function Wolfram ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " 6 system is required to edit this notebook.\n",
 StyleBox[ButtonBox["GET WOLFRAM MATHEMATICA 6 \[RightGuillemet]",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolfram.com/products/mathematica/"], None},
  ButtonNote->"http://www.wolfram.com/products/mathematica/"],
  FontFamily->"Helvetica",
  FontWeight->"Bold",
  FontSlant->"Italic",
  FontColor->RGBColor[1, 0.42, 0]]
}], "Text",
 CellFrame->True,
 CellMargins->{{48, 68}, {8, 28}},
 CellFrameMargins->12,
 CellFrameColor->RGBColor[0.865507, 0.90634, 0.680751],
 CellChangeTimes->{3.3750111182355957`*^9},
 ParagraphSpacing->{1., 1.},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.411765],
 Background->RGBColor[0.986023, 0.991363, 0.969818]],

Cell[TextData[{
 "\[Copyright] ",
 StyleBox[ButtonBox["The Wolfram Demonstrations Project & Contributors",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->"http://demonstrations.wolfram.com/"],
  FontColor->GrayLevel[0.6]],
 "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
 StyleBox[ButtonBox["Terms of Use",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/termsofuse.html"], None},
  ButtonNote->"http://demonstrations.wolfram.com/termsofuse.html"],
  FontColor->GrayLevel[0.6]],
 "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
 StyleBox[ButtonBox["Make a new version of this Demonstration \
\[RightGuillemet]",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/participate/upload.jsp?id=\
ASimpleModelOfMagnetization"], None},
  ButtonNote->None],
  FontColor->GrayLevel[0.6]]
}], "Text",
 CellFrame->{{0, 0}, {0, 0.5}},
 CellMargins->{{48, 10}, {20, 50}},
 CellFrameMargins->{{6, 0}, {6, 6}},
 CellFrameColor->GrayLevel[0.6],
 FontFamily->"Verdana",
 FontSize->9,
 FontColor->GrayLevel[0.6]]
}, Open  ]]
}, Open  ]]
},
Editable->True,
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{710, 650},
WindowMargins->{{Inherited, Inherited}, {Inherited, 0}},
WindowElements->{
 "StatusArea", "MemoryMonitor", "MagnificationPopUp", "VerticalScrollBar", 
  "MenuBar"},
WindowTitle->"A Simple Model of Magnetization - Source",
DockedCells->{},
CellContext->Notebook,
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (May 21, 2008)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[590, 23, 223, 4, 70, "Section"],
Cell[816, 29, 11681, 300, 70, "Input",
 InitializationCell->True,
 CellID->1917415700],
Cell[12500, 331, 3830, 116, 70, "Input",
 InitializationCell->True,
 CellID->158732606],
Cell[16333, 449, 3633, 93, 70, "Input"]
}, Open  ]],
Cell[19981, 545, 14210, 253, 70, "Output",
 CellID->359846505],
Cell[CellGroupData[{
Cell[34216, 802, 373, 9, 70, "Text",
 CellGroupingRules->{"SectionGrouping", 25}],
Cell[34592, 813, 961, 28, 70, "Text"],
Cell[35556, 843, 337, 9, 70, "Text",
 CellGroupingRules->{"SectionGrouping", 25}],
Cell[35896, 854, 448, 14, 70, "Text"],
Cell[CellGroupData[{
Cell[36369, 872, 829, 24, 70, "Text"],
Cell[37201, 898, 1203, 33, 70, "Text"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
(* NotebookSignature ARNuKIiBnLiqWB0nbsOcaFqV *)
