(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 10.2' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     76198,       1838]
NotebookOptionsPosition[     74764,       1785]
NotebookOutlinePosition[     75410,       1810]
CellTagsIndexPosition[     75367,       1807]
WindowTitle->Checkerboard Bulge Illusion - Source
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Checkerboard Bulge Illusion", "Section",
 CellFrame->{{0, 0}, {0, 0}},
 ShowCellBracket->False,
 FontColor->RGBColor[0.597406, 0, 0.0527047]],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztnVuO40QUQFuAxGyBT5YCSxhWABL8IgESYpOjmR6+gA3Mb/s13Xk0jssu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   "], {{0, 0}, {1800, 25}}, {0, 255},
   ColorFunction->RGBColor],
  ImageSize->{1800, 25},
  PlotRange->{{0, 1800}, {0, 25}}]], "Section",
 CellFrame->{{0, 0}, {0, 0}},
 ShowCellBracket->False],

Cell[BoxData[
 RowBox[{
  RowBox[{"square", "[", 
   RowBox[{"clr_", ",", "num_", ",", "xcoor_", ",", "ycoor_"}], "]"}], ":=", 
  RowBox[{"{", "\[IndentingNewLine]", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Translate", "[", 
      RowBox[{
       RowBox[{"{", " ", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"clr", ",", 
           RowBox[{"Rectangle", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"1.15", ",", "5.85"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"1.35", ",", "5.65"}], "}"}]}], "]"}]}], "}"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{"clr", ",", 
           RowBox[{"Rectangle", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"1.65", ",", "5.35"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"1.85", ",", "5.15"}], "}"}]}], "]"}]}], "}"}]}], 
        "\[IndentingNewLine]", "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"x", "-", "num"}], ",", 
         RowBox[{"-", "x"}]}], "}"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "xcoor", ",", "ycoor"}], "}"}]}], "]"}], 
   "\[IndentingNewLine]", "}"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{3.696858408136832*^9, 3.696862412430851*^9},
 CellID->16327684],

Cell[BoxData[
 RowBox[{
  RowBox[{"circle", "[", 
   RowBox[{"clrs_", ",", "nums_", ",", "xcoors_", ",", "ycoors_"}], "]"}], ":=", 
  RowBox[{"{", "\[IndentingNewLine]", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Translate", "[", 
      RowBox[{
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"clrs", ",", " ", 
           RowBox[{"Disk", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"1.25", ",", "5.75"}], "}"}], ",", "0.15"}], "]"}]}], 
          "}"}], ",", "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{"clrs", ",", " ", 
           RowBox[{"Disk", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"1.75", ",", "5.25"}], "}"}], ",", "0.15"}], "]"}]}], 
          "}"}]}], "\[IndentingNewLine]", "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"x", "-", "nums"}], ",", 
         RowBox[{"-", "x"}]}], "}"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", " ", "xcoors", ",", " ", "ycoors"}], "}"}]}], "]"}], 
   "\[IndentingNewLine]", "}"}]}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.696858403576376*^9, 3.6968584186628847`*^9}, 
   3.69686241605145*^9},
 CellID->14215800],

Cell[BoxData[
 RowBox[{"Manipulate", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"shape", "\[Equal]", "1"}], ",", 
     RowBox[{"Graphics", "[", 
      RowBox[{
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"Table", "[", 
           RowBox[{
            RowBox[{"Translate", "[", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"Table", "[", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{"Black", ",", 
                   RowBox[{"Rectangle", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"x", ",", "1"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"x", "+", "1"}], ",", "0"}], "}"}]}], "]"}]}], 
                  "}"}], ",", 
                 RowBox[{"{", 
                  RowBox[{"x", ",", 
                   RowBox[{"-", "6"}], ",", "6", ",", "2"}], "}"}]}], "]"}], 
               "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"0", ",", "y"}], "}"}]}], "]"}], ",", 
            RowBox[{"{", 
             RowBox[{"y", ",", 
              RowBox[{"-", "6"}], ",", "6", ",", "2"}], "}"}]}], "]"}], "}"}],
          ",", "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{"Table", "[", 
           RowBox[{
            RowBox[{"Translate", "[", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"Table", "[", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{"Black", ",", 
                   RowBox[{"Rectangle", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"x", ",", "1"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"x", "+", "1"}], ",", "0"}], "}"}]}], "]"}]}], 
                  "}"}], ",", 
                 RowBox[{"{", 
                  RowBox[{"x", ",", 
                   RowBox[{"-", "6"}], ",", "4", ",", "2"}], "}"}]}], "]"}], 
               "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"1", ",", "y"}], "}"}]}], "]"}], ",", 
            RowBox[{"{", 
             RowBox[{"y", ",", 
              RowBox[{"-", "5"}], ",", "5", ",", "2"}], "}"}]}], "]"}], "}"}],
          ",", "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{"Table", "[", 
           RowBox[{
            RowBox[{"Translate", "[", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"Table", "[", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{"background", ",", 
                   RowBox[{"Rectangle", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"x", ",", "1"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"x", "+", "1"}], ",", "0"}], "}"}]}], "]"}]}], 
                  "}"}], ",", 
                 RowBox[{"{", 
                  RowBox[{"x", ",", 
                   RowBox[{"-", "6"}], ",", "4", ",", "2"}], "}"}]}], "]"}], 
               "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"1", ",", "y"}], "}"}]}], "]"}], ",", 
            RowBox[{"{", 
             RowBox[{"y", ",", 
              RowBox[{"-", "6"}], ",", "6", ",", "2"}], "}"}]}], "]"}], "}"}],
          ",", 
         RowBox[{"{", 
          RowBox[{"Table", "[", 
           RowBox[{
            RowBox[{"Translate", "[", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"Table", "[", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{"background", ",", 
                   RowBox[{"Rectangle", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"x", ",", "1"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"x", "+", "1"}], ",", "0"}], "}"}]}], "]"}]}], 
                  "}"}], ",", 
                 RowBox[{"{", 
                  RowBox[{"x", ",", 
                   RowBox[{"-", "6"}], ",", "6", ",", "2"}], "}"}]}], "]"}], 
               "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"0", ",", "y"}], "}"}]}], "]"}], ",", 
            RowBox[{"{", 
             RowBox[{"y", ",", 
              RowBox[{"-", "5"}], ",", "5", ",", "2"}], "}"}]}], "]"}], "}"}],
          ",", "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Opacity", "[", 
            RowBox[{"1", "-", "opacity"}], "]"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"square", "[", 
               RowBox[{"color", ",", "0", ",", "0", ",", "4"}], "]"}], "}"}], 
             ",", "\[IndentingNewLine]", 
             RowBox[{"{", 
              RowBox[{"square", "[", 
               RowBox[{"Black", ",", 
                RowBox[{"-", "1"}], ",", "1", ",", "2"}], "]"}], "}"}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{"{", 
              RowBox[{"square", "[", 
               RowBox[{"Black", ",", "1", ",", "1", ",", "4"}], "]"}], "}"}], 
             ",", "\[IndentingNewLine]", 
             RowBox[{"{", 
              RowBox[{"square", "[", 
               RowBox[{"color", ",", "2", ",", "2", ",", "4"}], "]"}], "}"}], 
             ",", "\[IndentingNewLine]", 
             RowBox[{"{", 
              RowBox[{"square", "[", 
               RowBox[{"Black", ",", "3", ",", "3", ",", "4"}], "]"}], "}"}], 
             ",", "\[IndentingNewLine]", 
             RowBox[{"{", 
              RowBox[{"square", "[", 
               RowBox[{"color", ",", "4", ",", "4", ",", "4"}], "]"}], "}"}], 
             ",", "\[IndentingNewLine]", 
             RowBox[{"{", 
              RowBox[{"Rotate", "[", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{"square", "[", 
                    RowBox[{"color", ",", "0", ",", "0", ",", "4"}], "]"}], 
                   "}"}], ",", "\[IndentingNewLine]", 
                  RowBox[{"{", 
                   RowBox[{"square", "[", 
                    RowBox[{"Black", ",", 
                    RowBox[{"-", "1"}], ",", "1", ",", "2"}], "]"}], "}"}], 
                  ",", "\[IndentingNewLine]", 
                  RowBox[{"{", 
                   RowBox[{"square", "[", 
                    RowBox[{"Black", ",", "1", ",", "1", ",", "4"}], "]"}], 
                   "}"}], ",", "\[IndentingNewLine]", 
                  RowBox[{"{", 
                   RowBox[{"square", "[", 
                    RowBox[{"color", ",", "2", ",", "2", ",", "4"}], "]"}], 
                   "}"}], ",", "\[IndentingNewLine]", 
                  RowBox[{"{", 
                   RowBox[{"square", "[", 
                    RowBox[{"Black", ",", "3", ",", "3", ",", "4"}], "]"}], 
                   "}"}], ",", "\[IndentingNewLine]", 
                  RowBox[{"{", 
                   RowBox[{"square", "[", 
                    RowBox[{"color", ",", "4", ",", "4", ",", "4"}], "]"}], 
                   "}"}]}], "}"}], ",", 
                RowBox[{"180", "Degree"}], ",", 
                RowBox[{"{", 
                 RowBox[{"0.5", ",", "0.5"}], "}"}]}], "]"}], "}"}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{"{", 
              RowBox[{"Rotate", "[", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{"square", "[", 
                    RowBox[{"color", ",", "0", ",", "0", ",", "4"}], "]"}], 
                   "}"}], ",", "\[IndentingNewLine]", 
                  RowBox[{"{", 
                   RowBox[{"square", "[", 
                    RowBox[{"Black", ",", 
                    RowBox[{"-", "1"}], ",", "1", ",", "2"}], "]"}], "}"}], 
                  ",", "\[IndentingNewLine]", 
                  RowBox[{"{", 
                   RowBox[{"square", "[", 
                    RowBox[{"Black", ",", "1", ",", "1", ",", "4"}], "]"}], 
                   "}"}], ",", "\[IndentingNewLine]", 
                  RowBox[{"{", 
                   RowBox[{"square", "[", 
                    RowBox[{"color", ",", "2", ",", "2", ",", "4"}], "]"}], 
                   "}"}], ",", "\[IndentingNewLine]", 
                  RowBox[{"{", 
                   RowBox[{"square", "[", 
                    RowBox[{"Black", ",", "3", ",", "3", ",", "4"}], "]"}], 
                   "}"}], ",", "\[IndentingNewLine]", 
                  RowBox[{"{", 
                   RowBox[{"square", "[", 
                    RowBox[{"color", ",", "4", ",", "4", ",", "4"}], "]"}], 
                   "}"}]}], "}"}], ",", 
                RowBox[{"90", "Degree"}], ",", 
                RowBox[{"{", 
                 RowBox[{"0.5", ",", "0.5"}], "}"}]}], "]"}], "}"}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{"{", 
              RowBox[{"Rotate", "[", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{"square", "[", 
                    RowBox[{"color", ",", "0", ",", "0", ",", "4"}], "]"}], 
                   "}"}], ",", "\[IndentingNewLine]", 
                  RowBox[{"{", 
                   RowBox[{"square", "[", 
                    RowBox[{"Black", ",", 
                    RowBox[{"-", "1"}], ",", "1", ",", "2"}], "]"}], "}"}], 
                  ",", "\[IndentingNewLine]", 
                  RowBox[{"{", 
                   RowBox[{"square", "[", 
                    RowBox[{"Black", ",", "1", ",", "1", ",", "4"}], "]"}], 
                   "}"}], ",", "\[IndentingNewLine]", 
                  RowBox[{"{", 
                   RowBox[{"square", "[", 
                    RowBox[{"color", ",", "2", ",", "2", ",", "4"}], "]"}], 
                   "}"}], ",", "\[IndentingNewLine]", 
                  RowBox[{"{", 
                   RowBox[{"square", "[", 
                    RowBox[{"Black", ",", "3", ",", "3", ",", "4"}], "]"}], 
                   "}"}], ",", "\[IndentingNewLine]", 
                  RowBox[{"{", 
                   RowBox[{"square", "[", 
                    RowBox[{"color", ",", "4", ",", "4", ",", "4"}], "]"}], 
                   "}"}]}], "}"}], ",", 
                RowBox[{"270", "Degree"}], ",", 
                RowBox[{"{", 
                 RowBox[{"0.5", ",", "0.5"}], "}"}]}], "]"}], "}"}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{"{", 
              RowBox[{"Table", "[", 
               RowBox[{
                RowBox[{"Translate", "[", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{"Black", ",", 
                    RowBox[{"Rectangle", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0.85", ",", "5.15"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"0.65", ",", "5.35"}], "}"}]}], "]"}]}], "}"}], 
                    ",", "\[IndentingNewLine]", 
                    RowBox[{"{", 
                    RowBox[{"Black", ",", 
                    RowBox[{"Rectangle", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0.15", ",", "5.15"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"0.35", ",", "5.35"}], "}"}]}], "]"}]}], "}"}]}], 
                   "}"}], ",", 
                  RowBox[{"{", 
                   RowBox[{"0", ",", 
                    RowBox[{"y", "-", "6"}]}], "}"}]}], "]"}], ",", 
                RowBox[{"{", 
                 RowBox[{"y", ",", "1", ",", "6"}], "}"}]}], "]"}], "}"}], 
             ",", "\[IndentingNewLine]", 
             RowBox[{"{", 
              RowBox[{"Table", "[", 
               RowBox[{
                RowBox[{"Translate", "[", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{"color", ",", 
                    RowBox[{"Rectangle", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0.85", ",", "4.15"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"0.65", ",", "4.35"}], "}"}]}], "]"}]}], "}"}], 
                    ",", "\[IndentingNewLine]", 
                    RowBox[{"{", 
                    RowBox[{"color", ",", 
                    RowBox[{"Rectangle", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0.15", ",", "4.15"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"0.35", ",", "4.35"}], "}"}]}], "]"}]}], "}"}]}], 
                   "}"}], ",", 
                  RowBox[{"{", 
                   RowBox[{"0", ",", 
                    RowBox[{"y", "-", "5"}]}], "}"}]}], "]"}], ",", 
                RowBox[{"{", 
                 RowBox[{"y", ",", "3", ",", "5", ",", "2"}], "}"}]}], "]"}], 
              "}"}], ",", "\[IndentingNewLine]", 
             RowBox[{"{", 
              RowBox[{"Rotate", "[", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{"Table", "[", 
                    RowBox[{
                    RowBox[{"Translate", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"Black", ",", 
                    RowBox[{"Rectangle", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0.85", ",", "5.15"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"0.65", ",", "5.35"}], "}"}]}], "]"}]}], "}"}], 
                    ",", "\[IndentingNewLine]", 
                    RowBox[{"{", 
                    RowBox[{"Black", ",", 
                    RowBox[{"Rectangle", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0.15", ",", "5.15"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"0.35", ",", "5.35"}], "}"}]}], "]"}]}], "}"}]}], 
                    "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", 
                    RowBox[{"y", "-", "6"}]}], "}"}]}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"y", ",", "1", ",", "6"}], "}"}]}], "]"}], "}"}], 
                  ",", "\[IndentingNewLine]", 
                  RowBox[{"{", 
                   RowBox[{"Table", "[", 
                    RowBox[{
                    RowBox[{"Translate", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"color", ",", 
                    RowBox[{"Rectangle", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0.85", ",", "4.15"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"0.65", ",", "4.35"}], "}"}]}], "]"}]}], "}"}], 
                    ",", "\[IndentingNewLine]", 
                    RowBox[{"{", 
                    RowBox[{"color", ",", 
                    RowBox[{"Rectangle", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0.15", ",", "4.15"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"0.35", ",", "4.35"}], "}"}]}], "]"}]}], "}"}]}], 
                    "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", 
                    RowBox[{"y", "-", "5"}]}], "}"}]}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"y", ",", "3", ",", "5", ",", "2"}], "}"}]}], 
                    "]"}], "}"}]}], "}"}], ",", 
                RowBox[{"180", "Degree"}], ",", 
                RowBox[{"{", 
                 RowBox[{"0.5", ",", "0.5"}], "}"}]}], "]"}], "}"}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{"{", 
              RowBox[{"Rotate", "[", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{"Table", "[", 
                    RowBox[{
                    RowBox[{"Translate", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"Black", ",", 
                    RowBox[{"Rectangle", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0.85", ",", "5.15"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"0.65", ",", "5.35"}], "}"}]}], "]"}]}], "}"}], 
                    ",", "\[IndentingNewLine]", 
                    RowBox[{"{", 
                    RowBox[{"Black", ",", 
                    RowBox[{"Rectangle", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0.15", ",", "5.15"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"0.35", ",", "5.35"}], "}"}]}], "]"}]}], "}"}]}], 
                    "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", 
                    RowBox[{"y", "-", "6"}]}], "}"}]}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"y", ",", "1", ",", "6"}], "}"}]}], "]"}], "}"}], 
                  ",", "\[IndentingNewLine]", 
                  RowBox[{"{", 
                   RowBox[{"Table", "[", 
                    RowBox[{
                    RowBox[{"Translate", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"color", ",", 
                    RowBox[{"Rectangle", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0.85", ",", "4.15"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"0.65", ",", "4.35"}], "}"}]}], "]"}]}], "}"}], 
                    ",", "\[IndentingNewLine]", 
                    RowBox[{"{", 
                    RowBox[{"color", ",", 
                    RowBox[{"Rectangle", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0.15", ",", "4.15"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"0.35", ",", "4.35"}], "}"}]}], "]"}]}], "}"}]}], 
                    "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", 
                    RowBox[{"y", "-", "5"}]}], "}"}]}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"y", ",", "3", ",", "5", ",", "2"}], "}"}]}], 
                    "]"}], "}"}]}], "}"}], ",", 
                RowBox[{"90", "Degree"}], ",", 
                RowBox[{"{", 
                 RowBox[{"0.5", ",", "0.5"}], "}"}]}], "]"}], "}"}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{"{", 
              RowBox[{"Rotate", "[", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{"Table", "[", 
                    RowBox[{
                    RowBox[{"Translate", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"Black", ",", 
                    RowBox[{"Rectangle", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0.85", ",", "5.15"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"0.65", ",", "5.35"}], "}"}]}], "]"}]}], "}"}], 
                    ",", "\[IndentingNewLine]", 
                    RowBox[{"{", 
                    RowBox[{"Black", ",", 
                    RowBox[{"Rectangle", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0.15", ",", "5.15"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"0.35", ",", "5.35"}], "}"}]}], "]"}]}], "}"}]}], 
                    "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", 
                    RowBox[{"y", "-", "6"}]}], "}"}]}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"y", ",", "1", ",", "6"}], "}"}]}], "]"}], "}"}], 
                  ",", "\[IndentingNewLine]", 
                  RowBox[{"{", 
                   RowBox[{"Table", "[", 
                    RowBox[{
                    RowBox[{"Translate", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"color", ",", 
                    RowBox[{"Rectangle", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0.85", ",", "4.15"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"0.65", ",", "4.35"}], "}"}]}], "]"}]}], "}"}], 
                    ",", "\[IndentingNewLine]", 
                    RowBox[{"{", 
                    RowBox[{"color", ",", 
                    RowBox[{"Rectangle", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0.15", ",", "4.15"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"0.35", ",", "4.35"}], "}"}]}], "]"}]}], "}"}]}], 
                    "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", 
                    RowBox[{"y", "-", "5"}]}], "}"}]}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"y", ",", "3", ",", "5", ",", "2"}], "}"}]}], 
                    "]"}], "}"}]}], "}"}], ",", 
                RowBox[{"270", "Degree"}], ",", 
                RowBox[{"{", 
                 RowBox[{"0.5", ",", "0.5"}], "}"}]}], "]"}], "}"}]}], "}"}], 
           ",", 
           RowBox[{"{", "}"}]}], "\[IndentingNewLine]", "}"}]}], 
        "\[IndentingNewLine]", "}"}], ",", 
       RowBox[{"Axes", "\[Rule]", "False"}], ",", 
       RowBox[{"ImageSize", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"475", ",", "400"}], "}"}]}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Graphics", "[", 
      RowBox[{
       RowBox[{"{", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"Table", "[", 
           RowBox[{
            RowBox[{"Translate", "[", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"Table", "[", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{"Black", ",", 
                   RowBox[{"Rectangle", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"x", ",", "1"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"x", "+", "1"}], ",", "0"}], "}"}]}], "]"}]}], 
                  "}"}], ",", 
                 RowBox[{"{", 
                  RowBox[{"x", ",", 
                   RowBox[{"-", "6"}], ",", "6", ",", "2"}], "}"}]}], "]"}], 
               "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"0", ",", "y"}], "}"}]}], "]"}], ",", 
            RowBox[{"{", 
             RowBox[{"y", ",", 
              RowBox[{"-", "6"}], ",", "6", ",", "2"}], "}"}]}], "]"}], "}"}],
          ",", "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{"Table", "[", 
           RowBox[{
            RowBox[{"Translate", "[", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"Table", "[", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{"Black", ",", 
                   RowBox[{"Rectangle", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"x", ",", "1"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"x", "+", "1"}], ",", "0"}], "}"}]}], "]"}]}], 
                  "}"}], ",", 
                 RowBox[{"{", 
                  RowBox[{"x", ",", 
                   RowBox[{"-", "6"}], ",", "4", ",", "2"}], "}"}]}], "]"}], 
               "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"1", ",", "y"}], "}"}]}], "]"}], ",", 
            RowBox[{"{", 
             RowBox[{"y", ",", 
              RowBox[{"-", "5"}], ",", "5", ",", "2"}], "}"}]}], "]"}], "}"}],
          ",", 
         RowBox[{"{", 
          RowBox[{"Table", "[", 
           RowBox[{
            RowBox[{"Translate", "[", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"Table", "[", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{"background", ",", 
                   RowBox[{"Rectangle", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"x", ",", "1"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"x", "+", "1"}], ",", "0"}], "}"}]}], "]"}]}], 
                  "}"}], ",", 
                 RowBox[{"{", 
                  RowBox[{"x", ",", 
                   RowBox[{"-", "6"}], ",", "4", ",", "2"}], "}"}]}], "]"}], 
               "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"1", ",", "y"}], "}"}]}], "]"}], ",", 
            RowBox[{"{", 
             RowBox[{"y", ",", 
              RowBox[{"-", "6"}], ",", "6", ",", "2"}], "}"}]}], "]"}], "}"}],
          ",", 
         RowBox[{"{", 
          RowBox[{"Table", "[", 
           RowBox[{
            RowBox[{"Translate", "[", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{"Table", "[", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{"background", ",", 
                   RowBox[{"Rectangle", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"x", ",", "1"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"x", "+", "1"}], ",", "0"}], "}"}]}], "]"}]}], 
                  "}"}], ",", 
                 RowBox[{"{", 
                  RowBox[{"x", ",", 
                   RowBox[{"-", "6"}], ",", "6", ",", "2"}], "}"}]}], "]"}], 
               "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"0", ",", "y"}], "}"}]}], "]"}], ",", 
            RowBox[{"{", 
             RowBox[{"y", ",", 
              RowBox[{"-", "5"}], ",", "5", ",", "2"}], "}"}]}], "]"}], "}"}],
          ",", "\[IndentingNewLine]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Opacity", "[", 
            RowBox[{"1", "-", "opacity"}], "]"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"circle", "[", 
               RowBox[{"color", ",", "0", ",", "0", ",", "4"}], "]"}], "}"}], 
             ",", "\[IndentingNewLine]", 
             RowBox[{"{", 
              RowBox[{"circle", "[", 
               RowBox[{"Black", ",", " ", "1", ",", " ", "1", ",", " ", "4"}],
                "]"}], "}"}], ",", "\[IndentingNewLine]", 
             RowBox[{"{", 
              RowBox[{"circle", "[", 
               RowBox[{"color", ",", "2", ",", "2", ",", "4"}], "]"}], "}"}], 
             ",", "\[IndentingNewLine]", 
             RowBox[{"{", 
              RowBox[{"circle", "[", 
               RowBox[{"Black", ",", "3", ",", "3", ",", "4"}], "]"}], "}"}], 
             ",", "\[IndentingNewLine]", 
             RowBox[{"{", 
              RowBox[{"circle", "[", 
               RowBox[{"color", ",", "4", ",", "4", ",", "4"}], "]"}], "}"}], 
             ",", "\[IndentingNewLine]", 
             RowBox[{"{", 
              RowBox[{"circle", "[", 
               RowBox[{"Black", ",", 
                RowBox[{"-", "1"}], ",", "1", ",", "2"}], "]"}], "}"}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{"{", 
              RowBox[{"Rotate", "[", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{"circle", "[", 
                    RowBox[{"color", ",", "0", ",", "0", ",", "4"}], "]"}], 
                   "}"}], ",", "\[IndentingNewLine]", 
                  RowBox[{"{", 
                   RowBox[{"circle", "[", 
                    RowBox[{
                    "Black", ",", " ", "1", ",", " ", "1", ",", " ", "4"}], 
                    "]"}], "}"}], ",", "\[IndentingNewLine]", 
                  RowBox[{"{", 
                   RowBox[{"circle", "[", 
                    RowBox[{"color", ",", "2", ",", "2", ",", "4"}], "]"}], 
                   "}"}], ",", "\[IndentingNewLine]", 
                  RowBox[{"{", 
                   RowBox[{"circle", "[", 
                    RowBox[{"Black", ",", "3", ",", "3", ",", "4"}], "]"}], 
                   "}"}], ",", "\[IndentingNewLine]", 
                  RowBox[{"{", 
                   RowBox[{"circle", "[", 
                    RowBox[{"color", ",", "4", ",", "4", ",", "4"}], "]"}], 
                   "}"}], ",", "\[IndentingNewLine]", 
                  RowBox[{"{", 
                   RowBox[{"circle", "[", 
                    RowBox[{"Black", ",", 
                    RowBox[{"-", "1"}], ",", "1", ",", "2"}], "]"}], "}"}]}], 
                 "}"}], ",", 
                RowBox[{"180", "Degree"}], ",", 
                RowBox[{"{", 
                 RowBox[{"0.5", ",", "0.5"}], "}"}]}], "]"}], "}"}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{"{", 
              RowBox[{"Rotate", "[", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{"circle", "[", 
                    RowBox[{"color", ",", "0", ",", "0", ",", "4"}], "]"}], 
                   "}"}], ",", "\[IndentingNewLine]", 
                  RowBox[{"{", 
                   RowBox[{"circle", "[", 
                    RowBox[{
                    "Black", ",", " ", "1", ",", " ", "1", ",", " ", "4"}], 
                    "]"}], "}"}], ",", "\[IndentingNewLine]", 
                  RowBox[{"{", 
                   RowBox[{"circle", "[", 
                    RowBox[{"color", ",", "2", ",", "2", ",", "4"}], "]"}], 
                   "}"}], ",", "\[IndentingNewLine]", 
                  RowBox[{"{", 
                   RowBox[{"circle", "[", 
                    RowBox[{"Black", ",", "3", ",", "3", ",", "4"}], "]"}], 
                   "}"}], ",", "\[IndentingNewLine]", 
                  RowBox[{"{", 
                   RowBox[{"circle", "[", 
                    RowBox[{"color", ",", "4", ",", "4", ",", "4"}], "]"}], 
                   "}"}], ",", "\[IndentingNewLine]", 
                  RowBox[{"{", 
                   RowBox[{"circle", "[", 
                    RowBox[{"Black", ",", 
                    RowBox[{"-", "1"}], ",", "1", ",", "2"}], "]"}], "}"}]}], 
                 "}"}], ",", 
                RowBox[{"90", "Degree"}], ",", 
                RowBox[{"{", 
                 RowBox[{"0.5", ",", "0.5"}], "}"}]}], "]"}], "}"}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{"{", 
              RowBox[{"Rotate", "[", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{"circle", "[", 
                    RowBox[{"color", ",", "0", ",", "0", ",", "4"}], "]"}], 
                   "}"}], ",", "\[IndentingNewLine]", 
                  RowBox[{"{", 
                   RowBox[{"circle", "[", 
                    RowBox[{
                    "Black", ",", " ", "1", ",", " ", "1", ",", " ", "4"}], 
                    "]"}], "}"}], ",", "\[IndentingNewLine]", 
                  RowBox[{"{", 
                   RowBox[{"circle", "[", 
                    RowBox[{"color", ",", "2", ",", "2", ",", "4"}], "]"}], 
                   "}"}], ",", "\[IndentingNewLine]", 
                  RowBox[{"{", 
                   RowBox[{"circle", "[", 
                    RowBox[{"Black", ",", "3", ",", "3", ",", "4"}], "]"}], 
                   "}"}], ",", "\[IndentingNewLine]", 
                  RowBox[{"{", 
                   RowBox[{"circle", "[", 
                    RowBox[{"color", ",", "4", ",", "4", ",", "4"}], "]"}], 
                   "}"}], ",", "\[IndentingNewLine]", 
                  RowBox[{"{", 
                   RowBox[{"circle", "[", 
                    RowBox[{"Black", ",", 
                    RowBox[{"-", "1"}], ",", "1", ",", "2"}], "]"}], "}"}]}], 
                 "}"}], ",", 
                RowBox[{"270", "Degree"}], ",", 
                RowBox[{"{", 
                 RowBox[{"0.5", ",", "0.5"}], "}"}]}], "]"}], "}"}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{"{", 
              RowBox[{"Table", "[", 
               RowBox[{
                RowBox[{"Translate", "[", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{"color", ",", " ", 
                    RowBox[{"Disk", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0.25", ",", "5.25"}], "}"}], ",", "0.15"}], 
                    "]"}]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"color", ",", 
                    RowBox[{"Disk", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0.75", ",", "5.25"}], "}"}], ",", "0.15"}], 
                    "]"}]}], "}"}]}], "}"}], ",", 
                  RowBox[{"{", 
                   RowBox[{"0", ",", 
                    RowBox[{"y", "-", "6"}]}], "}"}]}], "]"}], ",", 
                RowBox[{"{", 
                 RowBox[{"y", ",", "2", ",", "6"}], "}"}]}], "]"}], "}"}], 
             ",", "\[IndentingNewLine]", 
             RowBox[{"{", 
              RowBox[{"Table", "[", 
               RowBox[{
                RowBox[{"Translate", "[", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"{", 
                    RowBox[{"Black", ",", " ", 
                    RowBox[{"Disk", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0.25", ",", "5.25"}], "}"}], ",", "0.15"}], 
                    "]"}]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"Black", ",", 
                    RowBox[{"Disk", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0.75", ",", "5.25"}], "}"}], ",", "0.15"}], 
                    "]"}]}], "}"}]}], "}"}], ",", 
                  RowBox[{"{", 
                   RowBox[{"0", ",", 
                    RowBox[{"y", "-", "5"}]}], "}"}]}], "]"}], ",", 
                RowBox[{"{", 
                 RowBox[{"y", ",", "1", ",", "5", ",", "2"}], "}"}]}], "]"}], 
              "}"}], ",", "\[IndentingNewLine]", 
             RowBox[{"{", 
              RowBox[{"Rotate", "[", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{"Table", "[", 
                    RowBox[{
                    RowBox[{"Translate", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"color", ",", " ", 
                    RowBox[{"Disk", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0.25", ",", "5.25"}], "}"}], ",", "0.15"}], 
                    "]"}]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"color", ",", 
                    RowBox[{"Disk", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0.75", ",", "5.25"}], "}"}], ",", "0.15"}], 
                    "]"}]}], "}"}]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", 
                    RowBox[{"y", "-", "6"}]}], "}"}]}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"y", ",", "2", ",", "6"}], "}"}]}], "]"}], "}"}], 
                  ",", "\[IndentingNewLine]", 
                  RowBox[{"{", 
                   RowBox[{"Table", "[", 
                    RowBox[{
                    RowBox[{"Translate", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"Black", ",", " ", 
                    RowBox[{"Disk", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0.25", ",", "5.25"}], "}"}], ",", "0.15"}], 
                    "]"}]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"Black", ",", 
                    RowBox[{"Disk", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0.75", ",", "5.25"}], "}"}], ",", "0.15"}], 
                    "]"}]}], "}"}]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", 
                    RowBox[{"y", "-", "5"}]}], "}"}]}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"y", ",", "1", ",", "5", ",", "2"}], "}"}]}], 
                    "]"}], "}"}]}], "}"}], ",", 
                RowBox[{"180", "Degree"}], ",", 
                RowBox[{"{", 
                 RowBox[{"0.5", ",", "0.5"}], "}"}]}], "]"}], "}"}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{"{", 
              RowBox[{"Rotate", "[", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{"Table", "[", 
                    RowBox[{
                    RowBox[{"Translate", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"color", ",", " ", 
                    RowBox[{"Disk", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0.25", ",", "5.25"}], "}"}], ",", "0.15"}], 
                    "]"}]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"color", ",", 
                    RowBox[{"Disk", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0.75", ",", "5.25"}], "}"}], ",", "0.15"}], 
                    "]"}]}], "}"}]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", 
                    RowBox[{"y", "-", "6"}]}], "}"}]}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"y", ",", "2", ",", "6"}], "}"}]}], "]"}], "}"}], 
                  ",", "\[IndentingNewLine]", 
                  RowBox[{"{", 
                   RowBox[{"Table", "[", 
                    RowBox[{
                    RowBox[{"Translate", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"Black", ",", " ", 
                    RowBox[{"Disk", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0.25", ",", "5.25"}], "}"}], ",", "0.15"}], 
                    "]"}]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"Black", ",", 
                    RowBox[{"Disk", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0.75", ",", "5.25"}], "}"}], ",", "0.15"}], 
                    "]"}]}], "}"}]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", 
                    RowBox[{"y", "-", "5"}]}], "}"}]}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"y", ",", "1", ",", "5", ",", "2"}], "}"}]}], 
                    "]"}], "}"}]}], "}"}], ",", 
                RowBox[{"90", "Degree"}], ",", 
                RowBox[{"{", 
                 RowBox[{"0.5", ",", "0.5"}], "}"}]}], "]"}], "}"}], ",", 
             "\[IndentingNewLine]", 
             RowBox[{"{", 
              RowBox[{"Rotate", "[", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{"Table", "[", 
                    RowBox[{
                    RowBox[{"Translate", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"color", ",", " ", 
                    RowBox[{"Disk", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0.25", ",", "5.25"}], "}"}], ",", "0.15"}], 
                    "]"}]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"color", ",", 
                    RowBox[{"Disk", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0.75", ",", "5.25"}], "}"}], ",", "0.15"}], 
                    "]"}]}], "}"}]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", 
                    RowBox[{"y", "-", "6"}]}], "}"}]}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"y", ",", "2", ",", "6"}], "}"}]}], "]"}], "}"}], 
                  ",", "\[IndentingNewLine]", 
                  RowBox[{"{", 
                   RowBox[{"Table", "[", 
                    RowBox[{
                    RowBox[{"Translate", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"Black", ",", " ", 
                    RowBox[{"Disk", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0.25", ",", "5.25"}], "}"}], ",", "0.15"}], 
                    "]"}]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"Black", ",", 
                    RowBox[{"Disk", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"0.75", ",", "5.25"}], "}"}], ",", "0.15"}], 
                    "]"}]}], "}"}]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", 
                    RowBox[{"y", "-", "5"}]}], "}"}]}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"y", ",", "1", ",", "5", ",", "2"}], "}"}]}], 
                    "]"}], "}"}]}], "}"}], ",", 
                RowBox[{"270", "Degree"}], ",", 
                RowBox[{"{", 
                 RowBox[{"0.5", ",", "0.5"}], "}"}]}], "]"}], "}"}]}], "}"}], 
           ",", 
           RowBox[{"{", "}"}]}], "\[IndentingNewLine]", "}"}]}], 
        "\[IndentingNewLine]", "}"}], ",", 
       RowBox[{"Axes", "\[Rule]", "False"}], ",", 
       RowBox[{"ImageSize", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"475", ",", "400"}], "}"}]}]}], "]"}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"Row", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Control", "@", 
       RowBox[{"{", 
        RowBox[{"opacity", ",", "0", ",", "1", ",", 
         RowBox[{"Appearance", "\[Rule]", "\"\<Labeled\>\""}]}], "}"}]}], ",",
       "\[IndentingNewLine]", 
      RowBox[{"Spacer", "[", "20", "]"}], ",", "\[IndentingNewLine]", 
      RowBox[{"Control", "@", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"shape", ",", "1", ",", "\"\<small shape\>\""}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"1", "\[Rule]", "\"\<squares\>\""}], ",", 
           RowBox[{"2", "\[Rule]", "\"\<circles\>\""}]}], "}"}], ",", 
         "SetterBar"}], "}"}]}]}], "}"}], "]"}], ",", "\[IndentingNewLine]", 
   RowBox[{"Row", "[", 
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Control", "@", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"background", ",", "White", ",", "\"\<large color\>\""}], 
          "}"}], ",", "ColorSlider"}], "}"}]}], ",", "\[IndentingNewLine]", 
      RowBox[{"Spacer", "[", "10", "]"}], ",", "\[IndentingNewLine]", 
      RowBox[{"Control", "@", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"color", ",", "White", ",", "\"\<small color\>\""}], "}"}], 
         ",", "ColorSlider"}], "}"}]}]}], "}"}], "]"}], ",", " ", 
   RowBox[{"SaveDefinitions", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellChangeTimes->{
  3.694147852428081*^9, {3.6941479630614057`*^9, 3.694147965372366*^9}, {
   3.69414824659543*^9, 3.694148247672449*^9}, {3.694181922568551*^9, 
   3.6941819243870792`*^9}, 3.696169729182912*^9, {3.696170643623796*^9, 
   3.6961706732483063`*^9}, {3.696255414222509*^9, 3.696255447180505*^9}, {
   3.696255516686467*^9, 3.6962555338545847`*^9}, {3.6962563422360487`*^9, 
   3.696256408199451*^9}, {3.6962564583084793`*^9, 3.696256465944901*^9}, {
   3.6968584298960075`*^9, 3.6968584390589237`*^9}, {3.69686258648637*^9, 
   3.696862627996173*^9}, {3.6968626778247433`*^9, 3.696862678002366*^9}, {
   3.696883795987482*^9, 3.696883796145482*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`background$$ = GrayLevel[
    1], $CellContext`color$$ = GrayLevel[1], $CellContext`opacity$$ = 
    0, $CellContext`shape$$ = 1, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`opacity$$], 0, 1}, {{
       Hold[$CellContext`shape$$], 1, "small shape"}, {
      1 -> "squares", 2 -> "circles"}}, {
      Hold[
       Row[{
         Manipulate`Place[1], 
         Spacer[20], 
         Manipulate`Place[2]}]], Manipulate`Dump`ThisIsNotAControl}, {{
       Hold[$CellContext`background$$], 
       GrayLevel[1], "large color"}, 
      GrayLevel[0.5]}, {{
       Hold[$CellContext`color$$], 
       GrayLevel[1], "small color"}, 
      GrayLevel[0.5]}, {
      Hold[
       Row[{
         Manipulate`Place[3], 
         Spacer[10], 
         Manipulate`Place[4]}]], Manipulate`Dump`ThisIsNotAControl}}, 
    Typeset`size$$ = {475., {198., 202.}}, Typeset`update$$ = 0, 
    Typeset`initDone$$, Typeset`skipInitDone$$ = 
    False, $CellContext`opacity$461500$$ = 0, $CellContext`shape$461501$$ = 
    False}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     2, StandardForm, 
      "Variables" :> {$CellContext`background$$ = 
        GrayLevel[1], $CellContext`color$$ = 
        GrayLevel[1], $CellContext`opacity$$ = 0, $CellContext`shape$$ = 1}, 
      "ControllerVariables" :> {
        Hold[$CellContext`opacity$$, $CellContext`opacity$461500$$, 0], 
        Hold[$CellContext`shape$$, $CellContext`shape$461501$$, False]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> If[$CellContext`shape$$ == 1, 
        Graphics[{{
           Table[
            Translate[{
              Table[{Black, 
                
                Rectangle[{$CellContext`x, 1}, {$CellContext`x + 1, 
                  0}]}, {$CellContext`x, -6, 6, 2}]}, {
             0, $CellContext`y}], {$CellContext`y, -6, 6, 2}]}, {
           Table[
            Translate[{
              Table[{Black, 
                
                Rectangle[{$CellContext`x, 1}, {$CellContext`x + 1, 
                  0}]}, {$CellContext`x, -6, 4, 2}]}, {
             1, $CellContext`y}], {$CellContext`y, -5, 5, 2}]}, {
           Table[
            Translate[{
              Table[{$CellContext`background$$, 
                
                Rectangle[{$CellContext`x, 1}, {$CellContext`x + 1, 
                  0}]}, {$CellContext`x, -6, 4, 2}]}, {
             1, $CellContext`y}], {$CellContext`y, -6, 6, 2}]}, {
           Table[
            Translate[{
              Table[{$CellContext`background$$, 
                
                Rectangle[{$CellContext`x, 1}, {$CellContext`x + 1, 
                  0}]}, {$CellContext`x, -6, 6, 2}]}, {
             0, $CellContext`y}], {$CellContext`y, -5, 5, 2}]}, {
           Opacity[1 - $CellContext`opacity$$], {{
             $CellContext`square[$CellContext`color$$, 0, 0, 4]}, {
             $CellContext`square[Black, -1, 1, 2]}, {
             $CellContext`square[Black, 1, 1, 4]}, {
             $CellContext`square[$CellContext`color$$, 2, 2, 4]}, {
             $CellContext`square[Black, 3, 3, 4]}, {
             $CellContext`square[$CellContext`color$$, 4, 4, 4]}, {
             Rotate[{{
                $CellContext`square[$CellContext`color$$, 0, 0, 4]}, {
                $CellContext`square[Black, -1, 1, 2]}, {
                $CellContext`square[Black, 1, 1, 4]}, {
                $CellContext`square[$CellContext`color$$, 2, 2, 4]}, {
                $CellContext`square[Black, 3, 3, 4]}, {
                $CellContext`square[$CellContext`color$$, 4, 4, 4]}}, 180 
              Degree, {0.5, 0.5}]}, {
             Rotate[{{
                $CellContext`square[$CellContext`color$$, 0, 0, 4]}, {
                $CellContext`square[Black, -1, 1, 2]}, {
                $CellContext`square[Black, 1, 1, 4]}, {
                $CellContext`square[$CellContext`color$$, 2, 2, 4]}, {
                $CellContext`square[Black, 3, 3, 4]}, {
                $CellContext`square[$CellContext`color$$, 4, 4, 4]}}, 90 
              Degree, {0.5, 0.5}]}, {
             Rotate[{{
                $CellContext`square[$CellContext`color$$, 0, 0, 4]}, {
                $CellContext`square[Black, -1, 1, 2]}, {
                $CellContext`square[Black, 1, 1, 4]}, {
                $CellContext`square[$CellContext`color$$, 2, 2, 4]}, {
                $CellContext`square[Black, 3, 3, 4]}, {
                $CellContext`square[$CellContext`color$$, 4, 4, 4]}}, 270 
              Degree, {0.5, 0.5}]}, {
             Table[
              Translate[{{Black, 
                 Rectangle[{0.85, 5.15}, {0.65, 5.35}]}, {Black, 
                 Rectangle[{0.15, 5.15}, {0.35, 5.35}]}}, {
               0, $CellContext`y - 6}], {$CellContext`y, 1, 6}]}, {
             Table[
              Translate[{{$CellContext`color$$, 
                 
                 Rectangle[{0.85, 4.15}, {0.65, 
                  4.35}]}, {$CellContext`color$$, 
                 Rectangle[{0.15, 4.15}, {0.35, 4.35}]}}, {
               0, $CellContext`y - 5}], {$CellContext`y, 3, 5, 2}]}, {
             Rotate[{{
                Table[
                 Translate[{{Black, 
                    Rectangle[{0.85, 5.15}, {0.65, 5.35}]}, {Black, 
                    Rectangle[{0.15, 5.15}, {0.35, 5.35}]}}, {
                  0, $CellContext`y - 6}], {$CellContext`y, 1, 6}]}, {
                Table[
                 Translate[{{$CellContext`color$$, 
                    
                    Rectangle[{0.85, 4.15}, {0.65, 
                    4.35}]}, {$CellContext`color$$, 
                    Rectangle[{0.15, 4.15}, {0.35, 4.35}]}}, {
                  0, $CellContext`y - 5}], {$CellContext`y, 3, 5, 2}]}}, 180 
              Degree, {0.5, 0.5}]}, {
             Rotate[{{
                Table[
                 Translate[{{Black, 
                    Rectangle[{0.85, 5.15}, {0.65, 5.35}]}, {Black, 
                    Rectangle[{0.15, 5.15}, {0.35, 5.35}]}}, {
                  0, $CellContext`y - 6}], {$CellContext`y, 1, 6}]}, {
                Table[
                 Translate[{{$CellContext`color$$, 
                    
                    Rectangle[{0.85, 4.15}, {0.65, 
                    4.35}]}, {$CellContext`color$$, 
                    Rectangle[{0.15, 4.15}, {0.35, 4.35}]}}, {
                  0, $CellContext`y - 5}], {$CellContext`y, 3, 5, 2}]}}, 90 
              Degree, {0.5, 0.5}]}, {
             Rotate[{{
                Table[
                 Translate[{{Black, 
                    Rectangle[{0.85, 5.15}, {0.65, 5.35}]}, {Black, 
                    Rectangle[{0.15, 5.15}, {0.35, 5.35}]}}, {
                  0, $CellContext`y - 6}], {$CellContext`y, 1, 6}]}, {
                Table[
                 Translate[{{$CellContext`color$$, 
                    
                    Rectangle[{0.85, 4.15}, {0.65, 
                    4.35}]}, {$CellContext`color$$, 
                    Rectangle[{0.15, 4.15}, {0.35, 4.35}]}}, {
                  0, $CellContext`y - 5}], {$CellContext`y, 3, 5, 2}]}}, 270 
              Degree, {0.5, 0.5}]}}, {}}}, Axes -> False, 
         ImageSize -> {475, 400}], 
        Graphics[{{
           Table[
            Translate[{
              Table[{Black, 
                
                Rectangle[{$CellContext`x, 1}, {$CellContext`x + 1, 
                  0}]}, {$CellContext`x, -6, 6, 2}]}, {
             0, $CellContext`y}], {$CellContext`y, -6, 6, 2}]}, {
           Table[
            Translate[{
              Table[{Black, 
                
                Rectangle[{$CellContext`x, 1}, {$CellContext`x + 1, 
                  0}]}, {$CellContext`x, -6, 4, 2}]}, {
             1, $CellContext`y}], {$CellContext`y, -5, 5, 2}]}, {
           Table[
            Translate[{
              Table[{$CellContext`background$$, 
                
                Rectangle[{$CellContext`x, 1}, {$CellContext`x + 1, 
                  0}]}, {$CellContext`x, -6, 4, 2}]}, {
             1, $CellContext`y}], {$CellContext`y, -6, 6, 2}]}, {
           Table[
            Translate[{
              Table[{$CellContext`background$$, 
                
                Rectangle[{$CellContext`x, 1}, {$CellContext`x + 1, 
                  0}]}, {$CellContext`x, -6, 6, 2}]}, {
             0, $CellContext`y}], {$CellContext`y, -5, 5, 2}]}, {
           Opacity[1 - $CellContext`opacity$$], {{
             $CellContext`circle[$CellContext`color$$, 0, 0, 4]}, {
             $CellContext`circle[Black, 1, 1, 4]}, {
             $CellContext`circle[$CellContext`color$$, 2, 2, 4]}, {
             $CellContext`circle[Black, 3, 3, 4]}, {
             $CellContext`circle[$CellContext`color$$, 4, 4, 4]}, {
             $CellContext`circle[Black, -1, 1, 2]}, {
             Rotate[{{
                $CellContext`circle[$CellContext`color$$, 0, 0, 4]}, {
                $CellContext`circle[Black, 1, 1, 4]}, {
                $CellContext`circle[$CellContext`color$$, 2, 2, 4]}, {
                $CellContext`circle[Black, 3, 3, 4]}, {
                $CellContext`circle[$CellContext`color$$, 4, 4, 4]}, {
                $CellContext`circle[Black, -1, 1, 2]}}, 180 Degree, {0.5, 
              0.5}]}, {
             Rotate[{{
                $CellContext`circle[$CellContext`color$$, 0, 0, 4]}, {
                $CellContext`circle[Black, 1, 1, 4]}, {
                $CellContext`circle[$CellContext`color$$, 2, 2, 4]}, {
                $CellContext`circle[Black, 3, 3, 4]}, {
                $CellContext`circle[$CellContext`color$$, 4, 4, 4]}, {
                $CellContext`circle[Black, -1, 1, 2]}}, 90 Degree, {0.5, 
              0.5}]}, {
             Rotate[{{
                $CellContext`circle[$CellContext`color$$, 0, 0, 4]}, {
                $CellContext`circle[Black, 1, 1, 4]}, {
                $CellContext`circle[$CellContext`color$$, 2, 2, 4]}, {
                $CellContext`circle[Black, 3, 3, 4]}, {
                $CellContext`circle[$CellContext`color$$, 4, 4, 4]}, {
                $CellContext`circle[Black, -1, 1, 2]}}, 270 Degree, {0.5, 
              0.5}]}, {
             Table[
              Translate[{{$CellContext`color$$, 
                 Disk[{0.25, 5.25}, 0.15]}, {$CellContext`color$$, 
                 Disk[{0.75, 5.25}, 0.15]}}, {
               0, $CellContext`y - 6}], {$CellContext`y, 2, 6}]}, {
             Table[
              Translate[{{Black, 
                 Disk[{0.25, 5.25}, 0.15]}, {Black, 
                 Disk[{0.75, 5.25}, 0.15]}}, {
               0, $CellContext`y - 5}], {$CellContext`y, 1, 5, 2}]}, {
             Rotate[{{
                Table[
                 Translate[{{$CellContext`color$$, 
                    Disk[{0.25, 5.25}, 0.15]}, {$CellContext`color$$, 
                    Disk[{0.75, 5.25}, 0.15]}}, {
                  0, $CellContext`y - 6}], {$CellContext`y, 2, 6}]}, {
                Table[
                 Translate[{{Black, 
                    Disk[{0.25, 5.25}, 0.15]}, {Black, 
                    Disk[{0.75, 5.25}, 0.15]}}, {
                  0, $CellContext`y - 5}], {$CellContext`y, 1, 5, 2}]}}, 180 
              Degree, {0.5, 0.5}]}, {
             Rotate[{{
                Table[
                 Translate[{{$CellContext`color$$, 
                    Disk[{0.25, 5.25}, 0.15]}, {$CellContext`color$$, 
                    Disk[{0.75, 5.25}, 0.15]}}, {
                  0, $CellContext`y - 6}], {$CellContext`y, 2, 6}]}, {
                Table[
                 Translate[{{Black, 
                    Disk[{0.25, 5.25}, 0.15]}, {Black, 
                    Disk[{0.75, 5.25}, 0.15]}}, {
                  0, $CellContext`y - 5}], {$CellContext`y, 1, 5, 2}]}}, 90 
              Degree, {0.5, 0.5}]}, {
             Rotate[{{
                Table[
                 Translate[{{$CellContext`color$$, 
                    Disk[{0.25, 5.25}, 0.15]}, {$CellContext`color$$, 
                    Disk[{0.75, 5.25}, 0.15]}}, {
                  0, $CellContext`y - 6}], {$CellContext`y, 2, 6}]}, {
                Table[
                 Translate[{{Black, 
                    Disk[{0.25, 5.25}, 0.15]}, {Black, 
                    Disk[{0.75, 5.25}, 0.15]}}, {
                  0, $CellContext`y - 5}], {$CellContext`y, 1, 5, 2}]}}, 270 
              Degree, {0.5, 0.5}]}}, {}}}, Axes -> False, 
         ImageSize -> {475, 400}]], 
      "Specifications" :> {{$CellContext`opacity$$, 0, 1, Appearance -> 
         "Labeled", ControlPlacement -> 
         1}, {{$CellContext`shape$$, 1, "small shape"}, {
         1 -> "squares", 2 -> "circles"}, ControlType -> SetterBar, 
         ControlPlacement -> 2}, 
        Row[{
          Manipulate`Place[1], 
          Spacer[20], 
          Manipulate`Place[2]}], {{$CellContext`background$$, 
          GrayLevel[1], "large color"}, 
         GrayLevel[0.5], ControlType -> ColorSlider, ControlPlacement -> 
         3}, {{$CellContext`color$$, 
          GrayLevel[1], "small color"}, 
         GrayLevel[0.5], ControlType -> ColorSlider, ControlPlacement -> 4}, 
        Row[{
          Manipulate`Place[3], 
          Spacer[10], 
          Manipulate`Place[4]}]}, "Options" :> {}, 
      "DefaultOptions" :> {ControllerLinking -> True}],
     ImageSizeCache->{535., {259., 266.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    Initialization:>(({$CellContext`square[
          Pattern[$CellContext`clr, 
           Blank[]], 
          Pattern[$CellContext`num, 
           Blank[]], 
          Pattern[$CellContext`xcoor, 
           Blank[]], 
          Pattern[$CellContext`ycoor, 
           Blank[]]] := {
          Table[
           Translate[{{$CellContext`clr, 
              Rectangle[{1.15, 5.85}, {1.35, 5.65}]}, {$CellContext`clr, 
              
              Rectangle[{1.65, 5.35}, {1.85, 
               5.15}]}}, {$CellContext`x - $CellContext`num, \
-$CellContext`x}], {$CellContext`x, $CellContext`xcoor, \
$CellContext`ycoor}]}, $CellContext`circle[
          Pattern[$CellContext`clrs, 
           Blank[]], 
          Pattern[$CellContext`nums, 
           Blank[]], 
          Pattern[$CellContext`xcoors, 
           Blank[]], 
          Pattern[$CellContext`ycoors, 
           Blank[]]] := {
          Table[
           Translate[{{$CellContext`clrs, 
              Disk[{1.25, 5.75}, 0.15]}, {$CellContext`clrs, 
              
              Disk[{1.75, 5.25}, 
               0.15]}}, {$CellContext`x - $CellContext`nums, \
-$CellContext`x}], {$CellContext`x, $CellContext`xcoors, \
$CellContext`ycoors}]}}; Typeset`initDone$$ = True); ReleaseHold[
       HoldComplete[{$CellContext`square[
           Pattern[$CellContext`clr, 
            Blank[]], 
           Pattern[$CellContext`num, 
            Blank[]], 
           Pattern[$CellContext`xcoor, 
            Blank[]], 
           Pattern[$CellContext`ycoor, 
            Blank[]]] := {
           Table[
            Translate[{{$CellContext`clr, 
               Rectangle[{1.15, 5.85}, {1.35, 5.65}]}, {$CellContext`clr, 
               
               Rectangle[{1.65, 5.35}, {1.85, 
                5.15}]}}, {$CellContext`x - $CellContext`num, \
-$CellContext`x}], {$CellContext`x, $CellContext`xcoor, \
$CellContext`ycoor}]}, $CellContext`circle[
           Pattern[$CellContext`clrs, 
            Blank[]], 
           Pattern[$CellContext`nums, 
            Blank[]], 
           Pattern[$CellContext`xcoors, 
            Blank[]], 
           Pattern[$CellContext`ycoors, 
            Blank[]]] := {
           Table[
            Translate[{{$CellContext`clrs, 
               Disk[{1.25, 5.75}, 0.15]}, {$CellContext`clrs, 
               
               Disk[{1.75, 5.25}, 
                0.15]}}, {$CellContext`x - $CellContext`nums, \
-$CellContext`x}], {$CellContext`x, $CellContext`xcoors, \
$CellContext`ycoors}]}}]]; Typeset`initDone$$ = True),
    SynchronousInitialization->True,
    UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellID->1729145092],

Cell[CellGroupData[{

Cell["CAPTION", "Section",
 CellFrame->{{0, 0}, {1, 0}},
 CellFrameColor->RGBColor[0.87, 0.87, 0.87],
 FontFamily->"Helvetica",
 FontSize->12,
 FontWeight->"Bold",
 FontColor->RGBColor[0.597406, 0, 0.0527047]],

Cell["\<\
This illusion gives the appearance of the checkerboard bulging in the center \
when some smaller squares or circles are inserted in the squares near the \
center. However, when the smaller shapes disappear, you can see that the \
checkerboard is in fact undistorted. This Demonstration includes controls \
that change the appearance of the board in order to show how slight \
alterations affect the illusion. \
\>", "Text"]
}, Close]]
}, Open  ]],

Cell[CellGroupData[{

Cell["DETAILS", "Section",
 CellFrame->{{0, 0}, {1, 0}},
 CellFrameColor->RGBColor[0.87, 0.87, 0.87],
 FontFamily->"Helvetica",
 FontSize->12,
 FontWeight->"Bold",
 FontColor->RGBColor[0.597406, 0, 0.0527047]],

Cell["\<\
This was a project for Advanced\[NonBreakingSpace]Topics\[NonBreakingSpace]in\
\[NonBreakingSpace]Mathematics\[NonBreakingSpace]II,\[NonBreakingSpace]2016\
\[Dash]2017, Torrey Pines High School, San Diego, CA.\
\>", "Text"]
}, Close]],

Cell["THIS NOTEBOOK IS THE SOURCE CODE FROM", "Text",
 CellFrame->{{0, 0}, {0, 0}},
 CellMargins->{{48, 10}, {4, 28}},
 CellGroupingRules->{"SectionGrouping", 25},
 CellFrameMargins->{{48, 48}, {6, 5}},
 CellFrameColor->RGBColor[0.87, 0.87, 0.87],
 FontFamily->"Helvetica",
 FontSize->10,
 FontWeight->"Bold",
 FontColor->RGBColor[0.597406, 0, 0.0527047]],

Cell[TextData[{
 "\[NonBreakingSpace]",
 ButtonBox["Priyanka Multani ",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/author.html?author=Priyanka+\
Multani"], None},
  ButtonNote->
   "http://demonstrations.wolfram.com/author.html?author=Priyanka+Multani"]
}], "Text",
 CellMargins->{{48, Inherited}, {0, Inherited}},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.6]],

Cell[TextData[{
 "\"",
 ButtonBox["Checkerboard Bulge Illusion",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/CheckerboardBulgeIllusion/"], None},
  ButtonNote->
   "http://demonstrations.wolfram.com/CheckerboardBulgeIllusion/"],
 "\"",
 "\[ParagraphSeparator]\[NonBreakingSpace]",
 ButtonBox["http://demonstrations.wolfram.com/CheckerboardBulgeIllusion/",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/CheckerboardBulgeIllusion/"], None},
  ButtonNote->
   "http://demonstrations.wolfram.com/CheckerboardBulgeIllusion/"],
 "\[ParagraphSeparator]\[NonBreakingSpace]",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->"http://demonstrations.wolfram.com/"],
 "\[ParagraphSeparator]\[NonBreakingSpace]",
 "Published: ",
 "March 1, 2017"
}], "Text",
 CellMargins->{{48, Inherited}, {0, Inherited}},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.5]],

Cell[CellGroupData[{

Cell[TextData[{
 "A full-function Wolfram ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " system is required to edit this notebook.\n",
 StyleBox[ButtonBox["GET WOLFRAM MATHEMATICA \[RightGuillemet]",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolfram.com/products/mathematica/"], None},
  ButtonNote->"http://www.wolfram.com/products/mathematica/"],
  FontFamily->"Helvetica",
  FontWeight->"Bold",
  FontSlant->"Italic",
  FontColor->RGBColor[1, 0.42, 0]]
}], "Text",
 CellFrame->True,
 CellMargins->{{48, 68}, {8, 28}},
 CellFrameMargins->12,
 CellFrameColor->RGBColor[0.87, 0.87, 0.87],
 CellChangeTimes->{3.3750111182355957`*^9},
 ParagraphSpacing->{1., 1.},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.411765],
 Background->RGBColor[1, 1, 1]],

Cell[TextData[{
 "\[Copyright] ",
 StyleBox[ButtonBox["Wolfram Demonstrations Project & Contributors",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->"http://demonstrations.wolfram.com/"],
  FontColor->GrayLevel[0.6]],
 "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
 StyleBox[ButtonBox["Terms of Use",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/termsofuse.html"], None},
  ButtonNote->"http://demonstrations.wolfram.com/termsofuse.html"],
  FontColor->GrayLevel[0.6]],
 "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
 StyleBox[ButtonBox["Make a new version of this Demonstration \
\[RightGuillemet]",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/participate/upload.jsp?id=\
CheckerboardBulgeIllusion"], None},
  ButtonNote->None],
  FontColor->GrayLevel[0.6]]
}], "Text",
 CellFrame->{{0, 0}, {0, 0.5}},
 CellMargins->{{48, 10}, {20, 50}},
 CellFrameMargins->{{6, 0}, {6, 6}},
 CellFrameColor->GrayLevel[0.6],
 FontFamily->"Verdana",
 FontSize->9,
 FontColor->GrayLevel[0.6]]
}, Open  ]]
},
Editable->True,
Saveable->False,
ScreenStyleEnvironment->"Working",
CellInsertionPointCell->None,
WindowSize->{710, 650},
WindowMargins->{{Inherited, Inherited}, {Inherited, 0}},
WindowElements->{
 "StatusArea", "MemoryMonitor", "MagnificationPopUp", "VerticalScrollBar", 
  "MenuBar"},
WindowTitle->"Checkerboard Bulge Illusion - Source",
DockedCells->{},
CellContext->Notebook,
FrontEndVersion->"10.2 for Microsoft Windows (64-bit) (July 7, 2015)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[630, 23, 147, 3, 70, "Section"],
Cell[780, 28, 3749, 65, 70, "Section"],
Cell[4532, 95, 1367, 38, 70, "Input",
 InitializationCell->True,
 CellID->16327684],
Cell[5902, 135, 1269, 35, 70, "Input",
 InitializationCell->True,
 CellID->14215800],
Cell[7174, 172, 45964, 1084, 70, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[53175, 1261, 16548, 363, 70, "Output",
 CellID->1729145092],
Cell[CellGroupData[{
Cell[69748, 1628, 209, 6, 70, "Section"],
Cell[69960, 1636, 433, 7, 70, "Text"]
}, Close]]
}, Open  ]],
Cell[CellGroupData[{
Cell[70441, 1649, 209, 6, 70, "Section"],
Cell[70653, 1657, 233, 4, 70, "Text"]
}, Close]],
Cell[70900, 1664, 355, 9, 70, "Text",
 CellGroupingRules->{"SectionGrouping", 25}],
Cell[71258, 1675, 423, 13, 70, "Text"],
Cell[71684, 1690, 1046, 29, 70, "Text"],
Cell[CellGroupData[{
Cell[72755, 1723, 793, 24, 70, "Text"],
Cell[73551, 1749, 1197, 33, 70, "Text"]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
(* NotebookSignature fSjTKT4HMUk0VCDw8Y03BpD8 *)
