(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     22302,        565]
NotebookOptionsPosition[     21115,        519]
NotebookOutlinePosition[     21760,        544]
CellTagsIndexPosition[     21717,        541]
WindowTitle->Are the Lines Parallel? - Source
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Are the Lines Parallel?", "Section",
 CellFrame->{{0, 0}, {0, 0}},
 ShowCellBracket->False,
 FontColor->RGBColor[0.597406, 0, 0.0527047]],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztnVuSozgWQDNiPqa3MJ+zpVlCbaB3WlGVNV9dvYH6TQRUph/ZGIHQmwvG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   "], {{0, 0}, {1800, 25}}, {0, 255},
   ColorFunction->RGBColor],
  ImageSize->{1800, 25},
  PlotRange->{{0, 1800}, {0, 25}}]], "Section",
 CellFrame->{{0, 0}, {0, 0}},
 ShowCellBracket->False],

Cell[BoxData[
 RowBox[{"Manipulate", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{"Flatten", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Thickness", "[", "thickness", "]"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"Line", "[", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"6", "-", "n"}], ",", "0"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"0", ",", 
               RowBox[{"6", "-", "n"}]}], "}"}]}], "}"}], "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"n", ",", 
            RowBox[{"number", "/", "2"}]}], "}"}]}], "]"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"Line", "[", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"n", ",", "5"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"5", ",", "n"}], "}"}]}], "}"}], "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"n", ",", 
            RowBox[{"number", "/", "2"}]}], "}"}]}], "]"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"Thickness", "[", "thickness2", "]"}], ",", 
        "\[IndentingNewLine]", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"thickness2", "\[NotEqual]", "0"}], ",", 
          RowBox[{"Table", "[", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"crossline", "[", 
             RowBox[{
              RowBox[{"n", "-", "m"}], ",", 
              RowBox[{"n", "+", "m"}], ",", "angle"}], "]"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"{", 
             RowBox[{"n", ",", 
              RowBox[{"3", "-", 
               RowBox[{"number", "/", "4"}]}], ",", 
              RowBox[{"2.5", "+", 
               RowBox[{"number", "/", "4"}]}], ",", "0.5"}], "}"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"{", 
             RowBox[{"m", ",", 
              RowBox[{"-", "5"}], ",", "5", ",", "gap"}], "}"}]}], "]"}], ",", 
          RowBox[{"{", "}"}]}], "]"}]}], "}"}], "\[IndentingNewLine]", "]"}], 
     ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "5"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "5"}], "}"}]}], "}"}]}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"Style", "[", 
    RowBox[{"\"\<main lines\>\"", ",", 
     RowBox[{"FontWeight", "\[Rule]", "\"\<Bold\>\""}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"thickness", ",", "0.006", ",", "\"\<thickness\>\""}], "}"}], 
     ",", "0.001", ",", "0.02"}], "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"number", ",", "10", ",", "\"\<number\>\""}], "}"}], ",", "2", 
     ",", "10", ",", "2"}], "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{"Style", "[", 
    RowBox[{"\"\<cross lines\>\"", ",", 
     RowBox[{"FontWeight", "\[Rule]", "\"\<Bold\>\""}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{"angle", ",", "0", ",", 
     RowBox[{"\[Pi]", "/", "2"}]}], "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"thickness2", ",", "0.006", ",", "\"\<thickness\>\""}], "}"}], 
     ",", "0", ",", "0.02"}], "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"gap", ",", "0.5", ",", "\"\<separation\>\""}], "}"}], ",", 
     "0.25", ",", "1"}], "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{"Initialization", "\[RuleDelayed]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"crossline", "[", 
       RowBox[{"n_", ",", "m_", ",", "angle_"}], "]"}], ":=", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"EvenQ", "[", 
         RowBox[{"Round", "[", 
          RowBox[{"n", "+", "m"}], "]"}], "]"}], ",", "\[IndentingNewLine]", 
        RowBox[{"Line", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"{", 
             RowBox[{"n", ",", "m"}], "}"}], "-", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"Cos", "[", "angle", "]"}], ",", 
               RowBox[{"Sin", "[", "angle", "]"}]}], "}"}], "/", "3"}]}], ",", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"n", ",", "m"}], "}"}], "+", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"Cos", "[", "angle", "]"}], ",", 
               RowBox[{"Sin", "[", "angle", "]"}]}], "}"}], "/", "3"}]}]}], 
          "}"}], "]"}], ",", "\[IndentingNewLine]", 
        RowBox[{"Line", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"{", 
             RowBox[{"n", ",", "m"}], "}"}], "-", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"Cos", "[", 
                RowBox[{"angle", "+", 
                 RowBox[{"\[Pi]", "/", "2"}]}], "]"}], ",", 
               RowBox[{"Sin", "[", 
                RowBox[{"angle", "+", 
                 RowBox[{"\[Pi]", "/", "2"}]}], "]"}]}], "}"}], "/", "3"}]}], 
           ",", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"n", ",", "m"}], "}"}], "+", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{
               RowBox[{"Cos", "[", 
                RowBox[{"angle", "+", 
                 RowBox[{"\[Pi]", "/", "2"}]}], "]"}], ",", 
               RowBox[{"Sin", "[", 
                RowBox[{"angle", "+", 
                 RowBox[{"\[Pi]", "/", "2"}]}], "]"}]}], "}"}], "/", 
             "3"}]}]}], "}"}], "]"}]}], "]"}]}], ")"}]}]}], "]"}]], "Input",
 CellChangeTimes->{
  3.35696210375764*^9, 3.4372075581339865`*^9, 3.437249149962142*^9, {
   3.4645083459782567`*^9, 3.464508442268133*^9}, 3.464508477630532*^9, {
   3.464508523991687*^9, 3.464508671966119*^9}, {3.4645087311246405`*^9, 
   3.4645087419531813`*^9}, {3.464508784126437*^9, 3.4645088285020056`*^9}, {
   3.4645088707525463`*^9, 3.464508881283931*^9}, {3.4645089653318815`*^9, 
   3.464508993316615*^9}, {3.4645090509423523`*^9, 3.4645090539892664`*^9}, {
   3.4645091151931753`*^9, 3.464509198928628*^9}, {3.4645092396494627`*^9, 
   3.464509239774469*^9}, {3.4645092739012165`*^9, 3.4645094615514483`*^9}, {
   3.4645100738595104`*^9, 3.464510175594696*^9}, {3.4645102085480323`*^9, 
   3.4645102328936396`*^9}, {3.464510270662648*^9, 3.464510287492281*^9}, {
   3.464510620032192*^9, 3.464510639782951*^9}, {3.464510828055606*^9, 
   3.464510828696247*^9}, {3.464510910401464*^9, 3.4645109235893016`*^9}, {
   3.464511000747527*^9, 3.464511001731927*^9}, {3.4645111756578503`*^9, 
   3.464511185861171*^9}, {3.464511220252456*^9, 3.4645112730362325`*^9}, {
   3.4645113118829656`*^9, 3.464511378684971*^9}, {3.4645115745584993`*^9, 
   3.4645116580153627`*^9}, 3.4645117055799932`*^9, {3.4645118171474915`*^9, 
   3.464511817303749*^9}, {3.4645118488676233`*^9, 3.4645118886811423`*^9}, {
   3.464511990590001*^9, 3.4645120191219816`*^9}, {3.4645122195328965`*^9, 
   3.464512224829873*^9}, {3.464512314334335*^9, 3.464512314787492*^9}, {
   3.464512398090231*^9, 3.4645124502032747`*^9}, {3.4645124812210827`*^9, 
   3.4645124823930407`*^9}, 3.464512513129579*^9, {3.4645127479369946`*^9, 
   3.4645130305863*^9}, {3.464513078618779*^9, 3.46451307922817*^9}, {
   3.464513159105215*^9, 3.4645131997622557`*^9}, {3.464513262200955*^9, 
   3.4645132640447407`*^9}},
 CellID->102984921]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`angle$$ = 0, $CellContext`gap$$ = 
    0.5, $CellContext`number$$ = 10, $CellContext`thickness$$ = 
    0.006, $CellContext`thickness2$$ = 0.006, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[
       Style["main lines", FontWeight -> "Bold"]], 
      Manipulate`Dump`ThisIsNotAControl}, {{
       Hold[$CellContext`thickness$$], 0.006, "thickness"}, 0.001, 0.02}, {{
       Hold[$CellContext`number$$], 10, "number"}, 2, 10, 2}, {
      Hold[
       Style["cross lines", FontWeight -> "Bold"]], 
      Manipulate`Dump`ThisIsNotAControl}, {
      Hold[$CellContext`angle$$], 0, Rational[1, 2] Pi}, {{
       Hold[$CellContext`thickness2$$], 0.006, "thickness"}, 0, 0.02}, {{
       Hold[$CellContext`gap$$], 0.5, "separation"}, 0.25, 1}}, 
    Typeset`size$$ = {360., {178., 182.}}, Typeset`update$$ = 0, 
    Typeset`initDone$$, Typeset`skipInitDone$$ = 
    False, $CellContext`thickness$7597$$ = 0, $CellContext`number$7598$$ = 
    0, $CellContext`angle$7599$$ = 0, $CellContext`thickness2$7600$$ = 
    0, $CellContext`gap$7601$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`angle$$ = 0, $CellContext`gap$$ = 
        0.5, $CellContext`number$$ = 10, $CellContext`thickness$$ = 
        0.006, $CellContext`thickness2$$ = 0.006}, "ControllerVariables" :> {
        Hold[$CellContext`thickness$$, $CellContext`thickness$7597$$, 0], 
        Hold[$CellContext`number$$, $CellContext`number$7598$$, 0], 
        Hold[$CellContext`angle$$, $CellContext`angle$7599$$, 0], 
        Hold[$CellContext`thickness2$$, $CellContext`thickness2$7600$$, 0], 
        Hold[$CellContext`gap$$, $CellContext`gap$7601$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Graphics[
        Flatten[{
          Thickness[$CellContext`thickness$$], 
          Table[
           
           Line[{{6 - $CellContext`n, 0}, {
             0, 6 - $CellContext`n}}], {$CellContext`n, $CellContext`number$$/
            2}], 
          Table[
           
           Line[{{$CellContext`n, 5}, {
             5, $CellContext`n}}], {$CellContext`n, $CellContext`number$$/2}], 
          Thickness[$CellContext`thickness2$$], 
          If[$CellContext`thickness2$$ != 0, 
           Table[
            $CellContext`crossline[$CellContext`n - $CellContext`m, \
$CellContext`n + $CellContext`m, $CellContext`angle$$], {$CellContext`n, 
             3 - $CellContext`number$$/4, 2.5 + $CellContext`number$$/4, 
             0.5}, {$CellContext`m, -5, 5, $CellContext`gap$$}], {}]}], 
        PlotRange -> {{0, 5}, {0, 5}}], "Specifications" :> {
        Style[
        "main lines", FontWeight -> 
         "Bold"], {{$CellContext`thickness$$, 0.006, "thickness"}, 0.001, 
         0.02}, {{$CellContext`number$$, 10, "number"}, 2, 10, 2}, 
        Style[
        "cross lines", FontWeight -> "Bold"], {$CellContext`angle$$, 0, 
         Rational[1, 2] Pi}, {{$CellContext`thickness2$$, 0.006, "thickness"},
          0, 0.02}, {{$CellContext`gap$$, 0.5, "separation"}, 0.25, 1}}, 
      "Options" :> {}, "DefaultOptions" :> {ControllerLinking -> True}],
     ImageSizeCache->{405., {289., 294.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    Initialization:>($CellContext`crossline[
        Pattern[$CellContext`n, 
         Blank[]], 
        Pattern[$CellContext`m, 
         Blank[]], 
        Pattern[$CellContext`angle, 
         Blank[]]] := If[
        EvenQ[
         Round[$CellContext`n + $CellContext`m]], 
        Line[{{$CellContext`n, $CellContext`m} - {
            Cos[$CellContext`angle], 
            Sin[$CellContext`angle]}/3, {$CellContext`n, $CellContext`m} + {
             Cos[$CellContext`angle], 
             Sin[$CellContext`angle]}/3}], 
        Line[{{$CellContext`n, $CellContext`m} - {
            Cos[$CellContext`angle + Pi/2], 
            Sin[$CellContext`angle + Pi/2]}/
          3, {$CellContext`n, $CellContext`m} + {
             Cos[$CellContext`angle + Pi/2], 
             Sin[$CellContext`angle + Pi/2]}/3}]]; Typeset`initDone$$ = True),
    
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellID->306940531],

Cell[CellGroupData[{

Cell["CAPTION", "Section",
 CellFrame->{{0, 0}, {1, 0}},
 CellFrameColor->RGBColor[0.87, 0.87, 0.87],
 FontFamily->"Helvetica",
 FontSize->12,
 FontWeight->"Bold",
 FontColor->RGBColor[0.597406, 0, 0.0527047]],

Cell["Are the long lines parallel? Adjust the short lines to see.", "Text"]
}, Close]]
}, Open  ]],

Cell[CellGroupData[{

Cell["THIS NOTEBOOK IS THE SOURCE CODE FROM", "Text",
 CellFrame->{{0, 0}, {0, 0}},
 CellMargins->{{48, 10}, {4, 28}},
 CellGroupingRules->{"SectionGrouping", 25},
 CellFrameMargins->{{48, 48}, {6, 5}},
 CellFrameColor->RGBColor[0.87, 0.87, 0.87],
 FontFamily->"Helvetica",
 FontSize->10,
 FontWeight->"Bold",
 FontColor->RGBColor[0.597406, 0, 0.0527047]],

Cell[TextData[{
 "\"",
 ButtonBox["Are the Lines Parallel?",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/AreTheLinesParallel/"], None},
  ButtonNote->"http://demonstrations.wolfram.com/AreTheLinesParallel/"],
 "\"",
 " from ",
 ButtonBox["the Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->"http://demonstrations.wolfram.com/"],
 "\[ParagraphSeparator]\[NonBreakingSpace]",
 ButtonBox["http://demonstrations.wolfram.com/AreTheLinesParallel/",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/AreTheLinesParallel/"], None},
  ButtonNote->"http://demonstrations.wolfram.com/AreTheLinesParallel/"]
}], "Text",
 CellMargins->{{48, Inherited}, {0, Inherited}},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.5]],

Cell[TextData[{
 "Contributed by: ",
 ButtonBox["Jon McLoone",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/author.html?author=Jon+McLoone"], 
    None},
  ButtonNote->
   "http://demonstrations.wolfram.com/author.html?author=Jon+McLoone"]
}], "Text",
 CellDingbat->"\[FilledSmallSquare]",
 CellMargins->{{66, 48}, {2, 4}},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.6]],

Cell[CellGroupData[{

Cell[TextData[{
 "A full-function Wolfram ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " system (Version 6 or higher) is required to edit this notebook.\n",
 StyleBox[ButtonBox["GET WOLFRAM MATHEMATICA \[RightGuillemet]",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolfram.com/products/mathematica/"], None},
  ButtonNote->"http://www.wolfram.com/products/mathematica/"],
  FontFamily->"Helvetica",
  FontWeight->"Bold",
  FontSlant->"Italic",
  FontColor->RGBColor[1, 0.42, 0]]
}], "Text",
 CellFrame->True,
 CellMargins->{{48, 68}, {8, 28}},
 CellFrameMargins->12,
 CellFrameColor->RGBColor[0.87, 0.87, 0.87],
 CellChangeTimes->{3.3750111182355957`*^9},
 ParagraphSpacing->{1., 1.},
 FontFamily->"Verdana",
 FontSize->10,
 FontColor->GrayLevel[0.411765],
 Background->RGBColor[1, 1, 1]],

Cell[TextData[{
 "\[Copyright] ",
 StyleBox[ButtonBox["Wolfram Demonstrations Project & Contributors",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None},
  ButtonNote->"http://demonstrations.wolfram.com/"],
  FontColor->GrayLevel[0.6]],
 "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
 StyleBox[ButtonBox["Terms of Use",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/termsofuse.html"], None},
  ButtonNote->"http://demonstrations.wolfram.com/termsofuse.html"],
  FontColor->GrayLevel[0.6]],
 "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
 StyleBox[ButtonBox["Make a new version of this Demonstration \
\[RightGuillemet]",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/participate/upload.jsp?id=\
AreTheLinesParallel"], None},
  ButtonNote->None],
  FontColor->GrayLevel[0.6]]
}], "Text",
 CellFrame->{{0, 0}, {0, 0.5}},
 CellMargins->{{48, 10}, {20, 50}},
 CellFrameMargins->{{6, 0}, {6, 6}},
 CellFrameColor->GrayLevel[0.6],
 FontFamily->"Verdana",
 FontSize->9,
 FontColor->GrayLevel[0.6]]
}, Open  ]]
}, Open  ]]
},
Editable->True,
Saveable->False,
ScreenStyleEnvironment->"Working",
CellInsertionPointCell->None,
WindowSize->{710, 650},
WindowMargins->{{Inherited, Inherited}, {Inherited, 0}},
WindowElements->{
 "StatusArea", "MemoryMonitor", "MagnificationPopUp", "VerticalScrollBar", 
  "MenuBar"},
WindowTitle->"Are the Lines Parallel? - Source",
DockedCells->{},
CellContext->Notebook,
FrontEndVersion->"8.0 for Microsoft Windows (32-bit) (November 7, 2010)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[625, 23, 143, 3, 70, "Section"],
Cell[771, 28, 3700, 64, 70, "Section"],
Cell[4474, 94, 7702, 185, 70, "Input",
 CellID->102984921]
}, Open  ]],
Cell[CellGroupData[{
Cell[12213, 284, 4794, 99, 70, "Output",
 CellID->306940531],
Cell[CellGroupData[{
Cell[17032, 387, 209, 6, 70, "Section"],
Cell[17244, 395, 75, 0, 70, "Text"]
}, Close]]
}, Open  ]],
Cell[CellGroupData[{
Cell[17367, 401, 355, 9, 70, "Text",
 CellGroupingRules->{"SectionGrouping", 25}],
Cell[17725, 412, 895, 24, 70, "Text"],
Cell[18623, 438, 430, 14, 70, "Text"],
Cell[CellGroupData[{
Cell[19078, 456, 815, 24, 70, "Text"],
Cell[19896, 482, 1191, 33, 70, "Text"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
(* NotebookSignature NQ4CwphHAqIBuCTYjvhJi7yo *)
