(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[   1075044,      36791]*)
(*NotebookOutlinePosition[   1076814,      36849]*)
(*  CellTagsIndexPosition[   1076719,      36843]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[TextData[{
  "Programming with ",
  StyleBox["Mathematica",
    FontSlant->"Italic"]
}], "Title"],

Cell[CellGroupData[{

Cell["Evaluation", "Section"],

Cell[CellGroupData[{

Cell["Entering Commands", "Subsection"],

Cell[TextData[{
  "It is assumed that those taking this course are familiar with the \
following conventions used to type ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " input."
}], "Text"],

Cell[TextData[{
  "Built-in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " symbol names are typically one or more full-length English words (or a \
standard abbreviation), where the first letter of each word in the name is \
capitalized. ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " is case sensitive. Typical built-in symbol names are ",
  StyleBox["Integrate", "Input"],
  ", ",
  StyleBox["FactorInteger", "Input"],
  ", ",
  StyleBox["Pi", "Input"],
  ", and ",
  StyleBox["Cos", "Input"],
  "."
}], "Text"],

Cell[TextData[{
  "Function arguments are typed inside square brackets, as in ",
  Cell[BoxData[
      StyleBox[\(Factor[1 - x^9]\),
        "Input"]]],
  "."
}], "Text"],

Cell[TextData[{
  "In these notes, formatting functions will be entered on occasion using ",
  StyleBox["postfix",
    FontSlant->"Italic"],
  " notation, as in the following."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \({{a, b}, {c, d}} // MatrixForm\)], "Input"],

Cell[BoxData[
    TagBox[
      RowBox[{"(", GridBox[{
            {"a", "b"},
            {"c", "d"}
            }], ")"}],
      (MatrixForm[ #]&)]], "Output"]
}, Closed]],

Cell[TextData[{
  "Parentheses are used only for grouping, as in ",
  Cell[BoxData[
      \(\((a + b)\)^2\)], "Input"],
  " and ",
  Cell[BoxData[
      \(1/\((2  \[Pi])\)\)], "Input"],
  "."
}], "Text"],

Cell[TextData[{
  "Collections of objects (such as vectors or arrays of data) are called ",
  StyleBox["lists",
    FontSlant->"Italic"],
  ", and are entered as a sequence of elements inside curly brackets ",
  Cell[BoxData[
      \({}\)], "Input"],
  " and separated by commas. The elements of a list can themselves be lists; \
such nested lists are used to represent matrices, tensors, or arbitrary \
arrays. Lists need not be \[OpenCurlyDoubleQuote]rectangular\
\[CloseCurlyDoubleQuote]. A list of integers ranging from 1 to 3 is entered ",
  
  Cell[BoxData[
      \({1, 2, 3}\)], "Input"],
  "."
}], "Text"],

Cell[TextData[{
  "Strings are entered as a sequence of characters inside double quotes, as \
in ",
  StyleBox["\"This is a string.\"", "Input"],
  "."
}], "Text"],

Cell[TextData[{
  "One way to refer to previous results is to use percent sign (",
  StyleBox["%", "Input"],
  ") notation. A single percent sign ",
  StyleBox["%", "Input"],
  " refers to the last expression returned, a double percent sign ",
  StyleBox["%%", "Input"],
  " refers to the expression returned two evaluations ago, and so forth; a \
percent sign followed immediately by a number ",
  StyleBox["n",
    FontSlant->"Italic"],
  " (",
  StyleBox["%", "Input"],
  StyleBox["n",
    FontSlant->"Italic"],
  ") refers to the output line labeled ",
  StyleBox["Out[", "Output"],
  StyleBox["n",
    FontSlant->"Italic"],
  StyleBox["]", "Output"],
  "."
}], "Text"],

Cell[TextData[{
  "We use the on-line help by entering ",
  StyleBox["?", "Input"],
  StyleBox["FunctionName",
    FontSlant->"Italic"],
  ", which displays the usage message for ",
  StyleBox["FunctionName",
    FontSlant->"Italic"],
  ". The usage message for a function typically describes the function and \
the types of arguments that the function expects. Here is the usage message \
for ",
  StyleBox["Integrate", "Input"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell["?Integrate", "Input"],

Cell[BoxData[
    \("Integrate[f, x] gives the indefinite integral of f with respect to x. \
Integrate[f, {x, xmin, xmax}] gives the definite integral of f with respect \
to x from xmin to xmax. Integrate[f, {x, xmin, xmax}, {y, ymin, ymax}] gives \
a multiple definite integral of f with respect to x and y."\)], "Print"]
}, Closed]],

Cell[TextData[{
  "If we do not know the exact name of a function, we can print a listing of \
functions containing a given string by entering ",
  Cell[BoxData[
      RowBox[{
        StyleBox["?",
          FontWeight->"Bold"], 
        RowBox[{
          StyleBox["*",
            FontWeight->"Bold"], 
          StyleBox["String",
            FontFamily->"Times",
            FontSlant->"Italic"], 
          StyleBox["*",
            FontWeight->"Bold"]}]}]]],
  ". Here is a listing of the functions that contain the word \
\[OpenCurlyDoubleQuote]",
  StyleBox["Plot", "Input"],
  "\[CloseCurlyDoubleQuote]."
}], "Text"],

Cell[CellGroupData[{

Cell["? *Plot*", "Input"],

Cell["\<\
ContourPlot         ParametricPlot3D
DensityPlot         Plot
ListContourPlot     Plot3D
ListDensityPlot     Plot3Matrix
ListPlot            PlotDivision
ListPlot3D          PlotJoined
MovieContourPlot    PlotLabel
MovieDensityPlot    PlotPoints
MovieParametricPlot PlotRange
MoviePlot           PlotRegion
MoviePlot3D         PlotStyle
ParametricPlot\
\>", "Print"]
}, Closed]],

Cell[TextData[{
  "Many functions accept ",
  StyleBox["options",
    FontSlant->"Italic"],
  ", or named arguments, that control the behavior of the function. Options \
have the form ",
  StyleBox["OptionName",
    FontSlant->"Italic"],
  "\[Rule]",
  StyleBox["Value",
    FontSlant->"Italic"],
  ", and are entered after the function\[CloseCurlyQuote]s required \
arguments. ",
  StyleBox["Options[", "Input"],
  StyleBox["FunctionName", "Input",
    FontFamily->"Times",
    FontWeight->"Plain",
    FontSlant->"Italic"],
  StyleBox["]", "Input"],
  " returns a list of the options a function accepts and their default \
values. By default, ",
  StyleBox["FactorInteger", "Input"],
  " factors an integer over the real integers."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(FactorInteger[12]\)], "Input"],

Cell[BoxData[
    \({{2, 2}, {3, 1}}\)], "Output"]
}, Closed]],

Cell[TextData[{
  "Here are the options that ",
  StyleBox["FactorInteger", "Input"],
  " accepts."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Options[FactorInteger]\)], "Input"],

Cell[BoxData[
    \({FactorComplete \[Rule] True, GaussianIntegers \[Rule] False}\)], 
  "Output"]
}, Closed]],

Cell[TextData[{
  "By setting the option ",
  StyleBox["GaussianIntegers", "Input"],
  " to ",
  StyleBox["True", "Input"],
  ", ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " will factor an integer over the Gaussian (complex) integers."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(FactorInteger[12, GaussianIntegers -> True]\)], "Input"],

Cell[BoxData[
    \({{\(-1\), 1}, {1 + I, 4}, {3, 1}}\)], "Output"]
}, Closed]],

Cell[TextData[{
  "Many of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "\[CloseCurlyQuote]s built-in mathematical functions and plotting commands \
are used in these course notes. These are not explained if the meaning can be \
gathered from the usage message."
}], "Text"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "How ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " Evaluates Input"
}], "Subsection"],

Cell[TextData[{
  "Every valid input to ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " is an ",
  StyleBox["expression",
    FontSlant->"Italic"],
  ". While ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " allows us to type in many different kinds of questions and commands, all \
expressions have the same basic internal representation."
}], "Text"],

Cell["For example, we enter a sum by typing the following.", "Text"],

Cell[BoxData[
    \(a + b\)], "Input",
  Evaluatable->False],

Cell[TextData[{
  "Internally, however, ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " represents the sum in the following way."
}], "Text"],

Cell[BoxData[
    \(Plus[a, b]\)], "Input",
  Evaluatable->False],

Cell["Here is a list of two symbols.", "Text"],

Cell[BoxData[
    \({a, b}\)], "Input",
  Evaluatable->False],

Cell["Here is the internal form of the list.", "Text"],

Cell[BoxData[
    \(List[a, b]\)], "Input",
  Evaluatable->False],

Cell[TextData[{
  "A typical ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " expression has the following form (where each of the ",
  Cell[BoxData[
      \(TraditionalForm\`e\_i\)]],
  " can itself be a general expression)."
}], "Text"],

Cell[TextData[Cell[BoxData[
    \(TraditionalForm\`e\_0[e\_1, \ e\_2, \ \[Ellipsis], \ e\_n]\)]]], "Text",\

  CellMargins->{{54, Inherited}, {Inherited, Inherited}},
  TextAlignment->Left],

Cell[TextData[{
  "The first expression ",
  Cell[BoxData[
      \(TraditionalForm\`e\_0\)]],
  " is called the ",
  StyleBox["head",
    FontSlant->"Italic"],
  " of an expression, and can be extracted by evaluating ",
  StyleBox["Head[", "Input"],
  StyleBox["expression",
    FontSlant->"Italic"],
  StyleBox["]", "Input"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Head[a + b]\)], "Input"],

Cell[BoxData[
    \(Plus\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Head[{a, b}]\)], "Input"],

Cell[BoxData[
    \(List\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Head[Sin[1 + a]]\)], "Input"],

Cell[BoxData[
    \(Sin\)], "Output"]
}, Closed]],

Cell[TextData[{
  StyleBox["FullForm", "Input"],
  " allows us to view the entire internal form of an expression. Here are the \
internal forms of some expressions."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \({FullForm[a + b + c], FullForm[a == b], FullForm[Sin[2  a]]}\)], "Input"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        TagBox[
          StyleBox[\(Plus[a, b, c]\),
            ShowSpecialCharacters->False,
            ShowStringCharacters->True],
          FullForm], ",", 
        TagBox[
          StyleBox[\(Equal[a, b]\),
            ShowSpecialCharacters->False,
            ShowStringCharacters->True],
          FullForm], ",", 
        TagBox[
          StyleBox[\(Sin[Times[2, a]]\),
            ShowSpecialCharacters->False,
            ShowStringCharacters->True],
          FullForm]}], "}"}]], "Output"]
}, Closed]],

Cell[TextData[{
  "In some cases, use of the function ",
  StyleBox["Hold", "Input"],
  " is necessary to prevent evaluation of an expression. In the following \
example, the argument to ",
  StyleBox["FullForm", "Input"],
  " is evaluated before the internal form can be printed."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(FullForm[1 + 1]\)], "Input"],

Cell[BoxData[
    TagBox[
      StyleBox["2",
        ShowStringCharacters->True,
        NumberMarks->True],
      FullForm]], "Output"]
}, Closed]],

Cell[TextData[{
  StyleBox["Hold", "Input"],
  " prevents evaluation of an expression."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(FullForm[Hold[1 + 1]]\)], "Input"],

Cell[BoxData[
    TagBox[
      StyleBox["\(Hold[Plus[1, 1]]\)",
        ShowStringCharacters->True,
        NumberMarks->True],
      FullForm]], "Output"]
}, Closed]],

Cell[TextData[{
  "Some expressions are ",
  StyleBox["atomic",
    FontSlant->"Italic"],
  ", and do not have parts that can be extracted. Examples are numbers, \
strings, and symbols. The head of an atomic expression is a tag that \
describes its type."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \({Head[1234], Head[1.234], Head[23\/45], Head[1 + I], Head["\<str\>"], 
      Head[undefined]}\)], "Input"],

Cell[BoxData[
    \({Integer, Real, Rational, Complex, String, Symbol}\)], "Output"]
}, Closed]],

Cell[TextData[{
  "Note that the head of an atomic expression does not appear in its ",
  StyleBox["FullForm", "Input"],
  " representation."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(FullForm[7]\)], "Input"],

Cell[BoxData[
    TagBox[
      StyleBox["7",
        ShowStringCharacters->True,
        NumberMarks->True],
      FullForm]], "Output"]
}, Closed]],

Cell[TextData[{
  "Some ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " expressions are ",
  StyleBox["compound expressions",
    FontSlant->"Italic"],
  ", sequences of complete expressions separated by semicolons. While it is \
occasionally safe to separate the expressions in a compound expression with \
newlines instead of semicolons; it is recommended that semicolons be used to \
avoid ambiguity."
}], "Text"],

Cell[BoxData[
    \(fib[0] = 1; fib[1] = 1\)], "Input"],

Cell["\<\
Here is the internal form of the previous compound expression.\
\>",
   "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(FullForm[Hold[fib[0] = 1; fib[1] = 1]]\)], "Input"],

Cell[BoxData[
    TagBox[
      StyleBox["\(Hold[CompoundExpression[Set[fib[0], 1], Set[fib[1], 1]]]\)",
        
        ShowStringCharacters->True,
        NumberMarks->True],
      FullForm]], "Output"]
}, Closed]],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " generally evaluates a general expression of the form ",
  Cell[BoxData[
      \(TraditionalForm\`e\_0[e\_1, \ e\_2, \ \[Ellipsis], \ e\_n]\)]],
  " from left to right, first evaluating the head ",
  Cell[BoxData[
      \(TraditionalForm\`e\_0\)]],
  ", then recursively evaluating each of the ",
  Cell[BoxData[
      \(TraditionalForm\`e\_i\)]],
  " in turn. (That is, ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " performs depth-first evaluation.) We can alter the evaluation of an \
expression by using ",
  StyleBox["Hold", "Input"],
  " and its variants, and there are several classes of built-in functions \
that have nonstandard evaluation sequences."
}], "Text"],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " typically ",
  StyleBox["returns",
    FontSlant->"Italic"],
  " the value of an expression after it is evaluated, meaning we can refer to \
the result using ",
  StyleBox["%", "Input"],
  " notation. In the case of a compound expression, the value returned is the \
result of the last expression in the compound expression."
}], "Text"],

Cell["The following input returns a numerical value.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(2^50\)], "Input"],

Cell[BoxData[
    \(1125899906842624\)], "Output"]
}, Closed]],

Cell["The value returned can be used in further calculations.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(%^\((1/25)\)\)], "Input"],

Cell[BoxData[
    \(4\)], "Output"]
}, Closed]],

Cell["\<\
In the following compound expression, only the value of the last \
expression is returned.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(2\^25; \ 3\^100; \ 4\^50\)], "Input"],

Cell[BoxData[
    \(1267650600228229401496703205376\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(%^\((1/10)\)\)], "Input"],

Cell[BoxData[
    \(1024\)], "Output"]
}, Closed]],

Cell[TextData[{
  "If the last expression in a line of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " input is followed by a semicolon, the result will not be printed, but can \
still be referred to using ",
  StyleBox["%", "Input"],
  ". In this example, ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " computes the value of ",
  Cell[BoxData[
      \(TraditionalForm\`2\^50\)]],
  ", but does not print the result."
}], "Text"],

Cell[BoxData[
    \(\(2^50; \)\)], "Input"],

Cell[TextData[{
  "We still refer to the result using ",
  StyleBox["%", "Input"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(%^\((1/25)\)\)], "Input"],

Cell[BoxData[
    \(4\)], "Output"]
}, Closed]],

Cell[TextData[{
  "Some expressions do not evaluate to a value, but display a result as a \
side effect; in such cases, the value returned is ",
  StyleBox["Null", "Input"],
  ". For example, the command ",
  StyleBox["Print", "Input"],
  " prints its argument after evaluating it, but does not return a value."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Print["\<Print commands return nothing.\>"]\)], "Input"],

Cell[BoxData[
    \("Print commands return nothing."\)], "Print"]
}, Closed]],

Cell[TextData[{
  "The value returned by the ",
  StyleBox["Print", "Input"],
  " statement is ",
  StyleBox["Null", "Input"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(FullForm[%]\)], "Input"],

Cell[BoxData[
    TagBox[
      StyleBox["Null",
        ShowSpecialCharacters->False,
        ShowStringCharacters->True],
      FullForm]], "Output"]
}, Closed]],

Cell["\<\
Simply entering the string, on the other hand, returns the value of \
the string.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \("\<This string returns a value.\>"\)], "Input"],

Cell[BoxData[
    \("This string returns a value."\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(FullForm[%]\)], "Input"],

Cell[BoxData[
    TagBox[
      StyleBox[\("\<This string returns a value.\>"\),
        ShowSpecialCharacters->False,
        ShowStringCharacters->True],
      FullForm]], "Output"]
}, Closed]],

Cell[TextData[{
  "Compound expressions can be used inside other functions, where normally a \
simple expression would be used. For example, if we plot the compound \
expression ",
  StyleBox["(Print[x];", "Input"],
  " ",
  StyleBox["x)", "Input"],
  " ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " creates a graph of the values returned by the compound expression (the \
values returned are the values of ",
  StyleBox["x", "Input"],
  "), but prints each value of ",
  StyleBox["x", "Input"],
  " that is used to create the graph."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(Plot[\((Print[x]; x)\), {x, 0, 1}, PlotPoints \[Rule] 5]; \)\)], 
  "Input"],

Cell[BoxData[
    \(2.49999999999999955`*^-7\)], "Print"],

Cell[BoxData[
    \(0.243401949437494735`\)], "Print"],

Cell[BoxData[
    \(0.508852799156242152`\)], "Print"],

Cell[BoxData[
    \(0.758156198031231731`\)], "Print"],

Cell[BoxData[
    \(0.99791044662496855`\)], "Print"],

Cell[BoxData[
    \(0.99999974999999992`\)], "Print"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238093 0.952381 0.0147149 0.588604 [
[.21429 .00221 -9 -9 ]
[.21429 .00221 9 0 ]
[.40476 .00221 -9 -9 ]
[.40476 .00221 9 0 ]
[.59524 .00221 -9 -9 ]
[.59524 .00221 9 0 ]
[.78571 .00221 -9 -9 ]
[.78571 .00221 9 0 ]
[.97619 .00221 -3 -9 ]
[.97619 .00221 3 0 ]
[.01131 .13244 -18 -4.5 ]
[.01131 .13244 0 4.5 ]
[.01131 .25016 -18 -4.5 ]
[.01131 .25016 0 4.5 ]
[.01131 .36788 -18 -4.5 ]
[.01131 .36788 0 4.5 ]
[.01131 .4856 -18 -4.5 ]
[.01131 .4856 0 4.5 ]
[.01131 .60332 -6 -4.5 ]
[.01131 .60332 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.21429 .01471 m
.21429 .02096 L
s
[(0.2)] .21429 .00221 0 1 Mshowa
.40476 .01471 m
.40476 .02096 L
s
[(0.4)] .40476 .00221 0 1 Mshowa
.59524 .01471 m
.59524 .02096 L
s
[(0.6)] .59524 .00221 0 1 Mshowa
.78571 .01471 m
.78571 .02096 L
s
[(0.8)] .78571 .00221 0 1 Mshowa
.97619 .01471 m
.97619 .02096 L
s
[(1)] .97619 .00221 0 1 Mshowa
.125 Mabswid
.07143 .01471 m
.07143 .01846 L
s
.11905 .01471 m
.11905 .01846 L
s
.16667 .01471 m
.16667 .01846 L
s
.2619 .01471 m
.2619 .01846 L
s
.30952 .01471 m
.30952 .01846 L
s
.35714 .01471 m
.35714 .01846 L
s
.45238 .01471 m
.45238 .01846 L
s
.5 .01471 m
.5 .01846 L
s
.54762 .01471 m
.54762 .01846 L
s
.64286 .01471 m
.64286 .01846 L
s
.69048 .01471 m
.69048 .01846 L
s
.7381 .01471 m
.7381 .01846 L
s
.83333 .01471 m
.83333 .01846 L
s
.88095 .01471 m
.88095 .01846 L
s
.92857 .01471 m
.92857 .01846 L
s
.25 Mabswid
0 .01471 m
1 .01471 L
s
.02381 .13244 m
.03006 .13244 L
s
[(0.2)] .01131 .13244 1 0 Mshowa
.02381 .25016 m
.03006 .25016 L
s
[(0.4)] .01131 .25016 1 0 Mshowa
.02381 .36788 m
.03006 .36788 L
s
[(0.6)] .01131 .36788 1 0 Mshowa
.02381 .4856 m
.03006 .4856 L
s
[(0.8)] .01131 .4856 1 0 Mshowa
.02381 .60332 m
.03006 .60332 L
s
[(1)] .01131 .60332 1 0 Mshowa
.125 Mabswid
.02381 .04415 m
.02756 .04415 L
s
.02381 .07358 m
.02756 .07358 L
s
.02381 .10301 m
.02756 .10301 L
s
.02381 .16187 m
.02756 .16187 L
s
.02381 .1913 m
.02756 .1913 L
s
.02381 .22073 m
.02756 .22073 L
s
.02381 .27959 m
.02756 .27959 L
s
.02381 .30902 m
.02756 .30902 L
s
.02381 .33845 m
.02756 .33845 L
s
.02381 .39731 m
.02756 .39731 L
s
.02381 .42674 m
.02756 .42674 L
s
.02381 .45617 m
.02756 .45617 L
s
.02381 .51503 m
.02756 .51503 L
s
.02381 .54446 m
.02756 .54446 L
s
.02381 .57389 m
.02756 .57389 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .01472 m
.25562 .15798 L
.50843 .31423 L
.74586 .46097 L
.9742 .60209 L
.97619 .60332 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{35, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/@P10`4000010?ooobl_;oooZZVYZNSX
j?oo05FZZZZZZ_W0RS/k>gYjN[Vi^OShn03ooeGooj[ooonI<c<c<fi^KZf][Nc/k02ZoeFZojZZoonZ
oclo?ginO[fm_Oclo5D00:X00?l00?l0VCLg=g9bL[6a/O3`l03o05Go0:[o00<30d92@X61PL30`000
EED0EJX0EOl0ELbIoc/k>gIfM[Fe]OCdm03oEEGoEJ[oE@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0Z/`c
<clo?gYjN[Vi^OShn03oZUGoZZ[oZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`<30d92@WinO[fm_Ocl
o03ooeGooj[oo`l?3di>CXf=SLc<c01E05EE0:YE0?mE00L71dI6AX61PL30`000EED00:X00?l001<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@/;2dY:BXF5QLC4a000ZUD0EJX0EOl0EALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZPl?3di>CXV9RLS8b000oeD0ZZX0Z_l0ZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEoa<C
4e9BDXf=SLc<c01E05D0ojX0ool0oalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ01LG5eIFEY6ATM3@d01E
EEEE0:YE0?mE02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZEA/K6eYJFYFEUMCDe01EZUEEEJYEEOmEEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZQlO7eiNGYVIVMSHf01EoeEEZZYEZ_mEZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZob<S8f9RHYfMWMcLg02Z05EEojYEoomEobl_;fi^KZf][Nc/k03o05Go0:[o0=gW1RLW
9fIVIZ6QXN3Ph02ZEEFZ0:ZZ0?nZ03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooEB/[:fYZJZFUYNCTi02Z
ZUFZEJZZEOnZECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l08@000?l08@0004800_l400;o0`04obD0
0_l400;o1003ob@00_l400;o1002obH00_l400;o1002ob/00ol70000@@001?l00?l300;o10000ol0
000T0004o`00o`<00_l50003o`00028000Co003o0`02o`<000Co003o90001?l00?l300;o0`001?l0
0?l[0003o`0000H000110004o`00o`X000?o00008`001?l00?l800Co8`001?l00?l80004o`00ob@0
00Co003o20001?l00?l[0003o`0000H000110004o`00o`/000?o00008P001?l00?l80003o`3o02@0
00Co003o2003obD000Co003o2@02ob`000?o00001P00044000Co003o20001?l00?lT0004o`00o`P0
00?o0?l090001?l00?l80003o`0002D000Co003o20001?l00?l[0003o`0000H0001200;o2P02obH0
0_l:00;o9@02o`X00olU00;o2P02ob/00_l800005@000ol0003o00T0000E0003o`000?l02@0001D0
00?o0000o`0900005@000ol0003o00T0000?0?oo4Ol100005@000ol0o`0:0003o`0000X000?o0000
2P000ol0000:0003o`0000X000?o00002P000ol0000:0003o`0000X000?o00002P000ol000090003
o`0000X000?o00002P000ol0000:0003o`0000X000?o00002P000ol0000:0003o`0000X000?o0000
2P000ol0000:0003o`0000X000?o00001@0001D000?o00000_l_0003o`00034000?o0000<0000ol0
000a0003o`00034000?o00001@0001D000?o00000P02ool01@0001D000?o000010000ol0003o0080
000E0003o`0000D00_oo0080000E0003o`0000L00_oo00005@000ol000090003o`000?`0000E00;o
2`02oo`0000E0003o`0000`000?o0000n@0001D000?o00003@02ooT0000E0003o`0000l00_og0000
5@000ol0000A0003o`000?@0000E0003o`0001800_od00005@000ol0000D0003o`000?40000E0003
o`0001D00_oa00005@02oaP00_o_00005@000ol0000I0003o`000>`0000E0003o`0001X00_o/0000
5@000ol0000L00;ojP0001D000?o00007P000ol0003W00005@000ol0000O00;oi`0001D000?o0000
8@000ol0003T00005@000ol0000R00;oi00001D00_lU00;ohP0001D000?o00009P000ol0003O0000
5@000ol0000W00;og`0001D000?o0000:@000ol0003L00005@000ol0000Z00;og00001D000?o0000
;002omX0000200;o1002o`<01?l40003o`0002h000?o0000e`0000050?l00?l00`02o`@000?o0000
10000ol0000_00;oe`0000050?l00?l02P000ol0000300?o<@02omD000001@3o003o00/000?o0000
0P000ol0000c0003o`000=8000001@3o003o00P000Co003o10000ol0000d00;odP0000800_l:00;o
1@000ol0000f0003o`000<l0000E0003o`0003L00_o?00005@000ol0000i00;oc@0001D000?o0000
>`000ol0003:00005@000ol0000l00;obP0001D00_lo0003o`000<L0000E0003o`0003l00_o70000
5@000ol0001100;oa@0001D000?o0000@`000ol0003200005@000ol0001400;o`P0001D000?o0000
AP02ol00000E0003o`0004P000?o0000_@0001D000?o0000B@02okd0000E00;oC002ok/0000E0003
o`0004d000?o0000^00001D000?o0000CP02okP0000E0003o`0005000_nf00005@000ol0001B0003
o`000;<0000E0003o`0005<00_nc00005@000ol0001E0003o`000;00000E0003o`0005H00_n`0000
5@02oeT00_n^00005@000ol0001J0003o`000:/0000E0003o`0005/00_n[00005@000ol0001M00;o
Z@0001D000?o0000G`000ol0002V00005@000ol0001P00;oYP0000800_l400;o1003o`@000?o0000
HP02oj@000001@3o003o00<00_l50003o`0000<000?o0000I0000ol0002Q000000D0o`00o`0800Co
1003ofD00_nQ000000D0o`00o`080003o`3o00D000?o0000I`02oil000001@3o003o00P000?o0?l0
1@000ol0001Y0003o`0009`0000200;o2P02o`D000?o0000JP02oi`0000E0003o`0006`000?o0000
V@0001D000?o0000K@02oiT0000E0003o`0006l00_nG00005@000ol0001a0003o`0009@0000E00;o
L`02oi@0000E0003o`0007@00_nB00005@000ol0001f0003o`0008l0000E0003o`0007L00_n?0000
5@000ol0001i00;oS@0001D000?o0000N`000ol0002:00005@000ol0001l00;oRP0001D000?o0000
OP02ohP0000E00;oP@000ol0002500005@000ol0002100;oQ@0001D000?o0000P`000ol000220000
5@000ol0002400;oPP0001D000?o0000QP02oh00000E0003o`0008P000?o0000O@0001D000?o0000
R@02ogd0000E0003o`0008/000?o0000NP0001D00_n=00;oNP0001D000?o0000SP02ogP0000E0003
o`00090000?o0000M@0001D000?o0000T@02ogD0000E0003o`0009<000?o0000LP0001D000?o0000
U002og80000200;o1002o`@00_l50003o`0009H00_m`000000D0o`00o`0300;o0`001?l00?l40003
o`0009P000?o0000K@0000050?l00?l020001?l00?l400?oV@02ofd000001@3o003o00P00ol50003
o`0009/000?o0000JP0000050?l00?l020000ol000050003o`0009`00_mZ00000P02o`X00ol40003
o`0009h00_mX00005@000ol0002P0003o`0006D0000E0003o`000:400_mU00005@000ol0002S0003
o`000680000E0003o`000:@00_mR00005@02ojL00_mP00005@000ol0002X0003o`0005d0000E0003
o`000:T00_mM00005@000ol0002[0003o`0005X0000E0003o`000:`00_mJ00005@000ol0002^00;o
F00001D000?o0000/0000ol0001E00005@000ol0002a00;oE@0001D00_nd0003o`000580000E0003
o`000;@00_mB00005@000ol0002f00;oD00001D000?o0000^0000ol0001=00005@000ol0002i00;o
C@0001D000?o0000^`000ol0001:00005@000ol0002l00;oBP0001D000?o0000_P02odP0000E00;o
`@000ol0001500005@000ol0003100;oA@0001D000?o0000``000ol0001200005@000ol0003400;o
@P0001D000?o0000aP02od00000E0003o`000<P000?o0000?@0000800_l400;o1002o`D000?o0000
b@02ocd000001@3o003o00<00_l30004o`00o`@000?o0000b`000ol0000j000000D0o`00o`080004
o`00o`@00oo<00;o>P0000050?l00?l02@02o`D000?o0000cP02ocP000001@3o003o00P000Co003o
10000ol0003@0003o`0003D0000200;o2P02o`D000?o0000d@02ocD0000E0003o`000=<000?o0000
<P0001D000?o0000e002oc80000E0003o`000=H000?o0000;`0001D000?o0000e`02obl0000E00;o
fP02obd0000E0003o`000=/000?o0000:P0001D000?o0000g002obX0000E0003o`000=h000?o0000
9`0001D000?o0000g`02obL0000E0003o`000>400_lU00005@000ol0003S0003o`000280000E0003
o`000>@00_lR00005@02onL000?o00007`0001D000?o0000i`02oal0000E0003o`000>T00_lM0000
5@000ol0003[0003o`0001X0000E0003o`000>`00_lJ00005@000ol0003^0003o`0001L0000E0003
o`000>l00_lG00005@000ol0003a0003o`0001@0000E00;ol`02oa@0000E0003o`000?@00_lB0000
5@000ol0003f0003o`0000l0000E0003o`000?L00_l?00005@000ol0003i0003o`0000`0000E0003
o`000?X00_l<00003@03o`D000?o0000o002o`X0000>0003o`0000@000?o0000oP000ol000070000
3P000ol0000400?oo`02o`L0000>0003o`0000@000?o0000o`0900003P000ol000040003o`000?l0
2@0000d00_l60003o`000?l02@0001D000?o0000o`090000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.0829948, -0.0774876, 
  0.00386185, 0.00624861}}]
}, Closed]],

Cell[TextData[{
  "Of course, ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " has many rules for simplifying expressions that involve built-in \
functions. For example, ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " recognizes that the expressions ",
  Cell[BoxData[
      \(Sin[\[Pi]/4]\)], "Input"],
  ", ",
  Cell[BoxData[
      \(2  x - x\)], "Input"],
  ", ",
  Cell[BoxData[
      \(Integrate[Exp[\(-x^2\)], x]\)], "Input"],
  ", and ",
  Cell[BoxData[
      \(Plot[Sin[t]/t, {t, \(-10\), 10}]\)], "Input"],
  " should be replaced with their respective results."
}], "Text"],

Cell[TextData[{
  "See also ",
  StyleBox["TreeForm", "Input"],
  ", ",
  StyleBox["InputForm", "Input"],
  ", ",
  StyleBox["AtomQ", "Input"],
  ", ",
  StyleBox["Trace", "Input"],
  ", ",
  StyleBox["TracePrint", "Input"],
  ", ",
  StyleBox["Evaluate", "Input"],
  ", ",
  StyleBox["Unevaluated", "Input"],
  ", ",
  StyleBox["HoldComplete", "Input"],
  ", ",
  StyleBox["ReleaseHold", "Input"],
  " "
}], "SeeAlso"]
}, Closed]],

Cell[CellGroupData[{

Cell["Styles of Programming", "Subsection"],

Cell[CellGroupData[{

Cell["Programming Overview", "Subsubsection"],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " allows us to program in several different styles, including procedural, \
rule-based, mathematical, and functional programming, mirroring the styles of \
programming used in BASIC, Fortran, C, Lisp, APL, and many other languages. \
An important point to remember is that, while ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " contains programming structures that are similar to those in other \
programming languages, we must still adhere to ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " syntax and punctuation conventions."
}], "Text"],

Cell[TextData[{
  "A straightforward example for illustrating the different styles of \
programming is the implementation of the factorial function. The factorial \
function is built into ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "; the factorial of a positive integer ",
  StyleBox["n",
    FontSlant->"Italic"],
  " is defined as the product of the integers 1, 2, \[Ellipsis], ",
  StyleBox["n",
    FontSlant->"Italic"],
  ", and it can be entered into ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " as ",
  StyleBox["n",
    FontSlant->"Italic"],
  StyleBox["!", "Input"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(35!\)\)], "Input"],

Cell[BoxData[
    \(10333147966386144929666651337523200000000\)], "Output"]
}, Closed]],

Cell["\<\
In the following discussion, we show four different ways to program \
our own factorial function.\
\>", "Text"]
}, Closed]],

Cell[CellGroupData[{

Cell["Procedural Programming", "Subsubsection"],

Cell[TextData[{
  "One way we can compute a factorial is procedurally, as we would in Fortran \
or BASIC, using a ",
  StyleBox["Do", "Input"],
  " loop. First, we initialize the value of a partial-product variable ",
  StyleBox["temp", "Input"],
  " to 1; then we multiply ",
  StyleBox["temp", "Input"],
  " by each of the numbers from 1 to the desired value (say, 35) and print \
the final value of ",
  StyleBox["temp", "Input"],
  ". Here is a procedural way to compute 35 factorial."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(temp = 1; \  (*\ initialize\ the\ product\ *) \n\n
    Do[temp = temp*n, {n, 1, 35}]; 
     (*\ loop\ through\ n = 1, 2, \[Ellipsis], 35\ *) \n\ntemp\ 
     (*\ return\ the\ result\ *) \)\)], "Input"],

Cell[BoxData[
    \(10333147966386144929666651337523200000000\)], "Output"]
}, Closed]],

Cell[TextData[{
  "We verify the answer is correct by testing the equality of ",
  StyleBox["temp", "Input"],
  " and the built-in factorial function."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(temp == \(35!\)\)], "Input"],

Cell[BoxData[
    \(True\)], "Output"]
}, Closed]],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " contains many functions that control the flow of a procedural program. \
The functions ",
  StyleBox["Do", "Input"],
  ", ",
  StyleBox["For", "Input"],
  ", and ",
  StyleBox["While", "Input"],
  " set up different types of loops; ",
  StyleBox["If", "Input"],
  ", ",
  StyleBox["Which", "Input"],
  ", and ",
  StyleBox["Switch", "Input"],
  " direct the flow of an evaluation according to conditions that are met; \
and the pairs ",
  StyleBox["Goto", "Input"],
  "-",
  StyleBox["Label", "Input"],
  " and ",
  StyleBox["Throw", "Input"],
  "-",
  StyleBox["Catch", "Input"],
  " permit arbitrary branching within a group of expressions."
}], "Text"],

Cell[TextData[{
  "As a general rule, procedural programming is useful for translating \
existing programs written in other languages. However, the functional and \
rule-based styles of programming, discussed below, use operations that \
directly manipulate ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "\[CloseCurlyQuote]s internal representation of expressions, and are \
therefore more efficient and usually more elegant."
}], "Text"],

Cell[TextData[{
  "See also ",
  StyleBox["For", "Input"],
  ", ",
  StyleBox["While", "Input"],
  ", ",
  StyleBox["If", "Input"],
  ", ",
  StyleBox["Which", "Input"],
  ", ",
  StyleBox["Switch", "Input"],
  ", ",
  StyleBox["Goto", "Input"],
  ", ",
  StyleBox["Label", "Input"],
  ", ",
  StyleBox["Throw", "Input"],
  ", ",
  StyleBox["Catch", "Input"],
  ", ",
  StyleBox["Break", "Input"],
  ", ",
  StyleBox["Continue", "Input"],
  ", ",
  StyleBox["Return", "Input"],
  " "
}], "SeeAlso"]
}, Closed]],

Cell[CellGroupData[{

Cell["Rule-Based Programming", "Subsubsection"],

Cell[TextData[{
  "Instead of defining a procedure, we can define functions to perform \
computations",
  StyleBox[".",
    FontSlant->"Italic"],
  " For example, we can define a function ",
  StyleBox["fac", "Input"],
  " that computes factorials."
}], "Text"],

Cell[TextData[{
  "It is a property of the factorial function that ",
  Cell[BoxData[
      \(TraditionalForm\`\(m!\)\[InvisibleSpace] = \(\(m(m - 1)\)!\)\)]],
  " for positive integer values of ",
  StyleBox["m",
    FontSlant->"Italic"],
  ". That is, we can express a factorial ",
  StyleBox["m",
    FontSlant->"Italic"],
  "! in terms of an easier case, ",
  Cell[BoxData[
      \(TraditionalForm\`\(\((m - 1)\)!\)\)]],
  ". This is called a ",
  StyleBox["recursive definition",
    FontSlant->"Italic"],
  ", and in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " we can define a function recursively, as in C or Pascal. First we tell ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " that ",
  StyleBox["fac", "Input"],
  " of a number ",
  StyleBox["m",
    FontSlant->"Italic"],
  " is equal to ",
  StyleBox["m",
    FontSlant->"Italic"],
  " times ",
  StyleBox["fac", "Input"],
  " of ",
  Cell[BoxData[
      \(TraditionalForm\`m - 1\)]],
  ". (Later we will see how to change the definition of ",
  StyleBox["fac", "Input"],
  " so that it accepts only positive integer values of ",
  StyleBox["m",
    FontSlant->"Italic"],
  ".)"
}], "Text"],

Cell[BoxData[
    \(fac[m_] := m\ fac[m - 1]\)], "Input"],

Cell[TextData[{
  "The definition is not complete, however, because there is currently no way \
for the function to stop calling itself. It is necessary to define a stopping \
condition, or elementary case, for the definition. In this case we define ",
  StyleBox["fac", "Input"],
  " of 0 to be 1, corresponding to the definition ",
  Cell[BoxData[
      \(TraditionalForm\`\(0!\)\[InvisibleSpace] = 1\)]],
  "."
}], "Text"],

Cell[BoxData[
    \(\(fac[0] = 1; \)\)], "Input",
  CellGroupingRules->"NormalGrouping"],

Cell[TextData[{
  "We are now ready to compute factorial values using ",
  StyleBox["fac", "Input"],
  "."
}], "Text"],

Cell[BoxData[
    \(fac[35]\)], "Input",
  CellGroupingRules->"NormalGrouping"],

Cell[BoxData[
    \(10333147966386144929666651337523200000000\)], "Output"],

Cell[TextData[{
  "We can compare ",
  StyleBox["fac", "Input"],
  " to the built-in factorial function."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(fac[35] == \(35!\)\)], "Input"],

Cell[BoxData[
    \(True\)], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Mathematical Programming", "Subsubsection"],

Cell[TextData[{
  "In many cases there is a built-in mathematical function that performs the \
desired operation. Another way to compute a factorial is to multiply the \
desired numbers using the built-in function ",
  StyleBox["Product", "Input"],
  ". Our function ",
  StyleBox["fac2", "Input"],
  " computes the factorial of ",
  StyleBox["m",
    FontSlant->"Italic"],
  " by multiplying values of ",
  StyleBox["j",
    FontSlant->"Italic"],
  " as ",
  StyleBox["j",
    FontSlant->"Italic"],
  " ranges from 1 to ",
  StyleBox["m",
    FontSlant->"Italic"],
  "."
}], "Text"],

Cell[BoxData[
    \(fac2[m_]\  := \ Product[j, \ {j, 1, m}]\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(fac2[35]\)], "Input"],

Cell[BoxData[
    \(10333147966386144929666651337523200000000\)], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Functional Programming", "Subsubsection"],

Cell[TextData[{
  "The most abstract and most efficient style of programming in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " involves using high-level ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " programming constructs, such as ",
  StyleBox["Apply", "Input"],
  " and ",
  StyleBox["Map", "Input"],
  ". While procedures and recursive functions have to compute many values in \
the course of a computation, using high-level functions allows us to work \
with large structures as a whole."
}], "Text"],

Cell[TextData[{
  "Here is a third factorial function, called ",
  StyleBox["fac3", "Input"],
  ", programmed functionally; that is, by applying an operator (in this case, \
",
  StyleBox["Times", "Input"],
  ") to an entire list of values at once. We generate a list of integers from \
1 to ",
  StyleBox["m",
    FontSlant->"Italic"],
  ", using the built-in function ",
  StyleBox["Range", "Input"],
  ", then effectively insert multiplication signs between the numbers."
}], "Text"],

Cell[BoxData[
    \(fac3[m_]\  := \ Apply[Times, \ Range[m]]\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(fac3[35]\)], "Input"],

Cell[BoxData[
    \(10333147966386144929666651337523200000000\)], "Output"]
}, Closed]],

Cell[TextData[{
  "We can easily spot-check our answers by testing for equality among the \
built-in factorial, ",
  StyleBox["fac", "Input"],
  ", ",
  StyleBox["fac2", "Input"],
  ", and ",
  StyleBox["fac3", "Input"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(35!\)\  == \ fac[35]\  == \ fac2[35]\  == \ fac3[35]\)], "Input"],

Cell[BoxData[
    \(True\)], "Output"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Exercises: Evaluation", "Subsection"],

Cell[TextData[{
  "Use ",
  StyleBox["FullForm", "Input",
    FontFamily->"Courier"],
  " to inspect the internal form of each of the following expressions. (In \
some cases it will be necessary to use ",
  StyleBox["Hold", "Input",
    FontFamily->"Courier"],
  ".)"
}], "Question"],

Cell[TextData[Cell[BoxData[
    \(Sin[1/2 + 1/x]\)], "Input"]], "Question",
  CellGroupingRules->"NormalGrouping"],

Cell[TextData[{
  "Note that the internal form of an exact rational number ",
  StyleBox["a",
    FontSlant->"Italic"],
  StyleBox["/", "Input"],
  StyleBox["b",
    FontSlant->"Italic"],
  " is ",
  StyleBox["Rational[", "Input"],
  StyleBox["a",
    FontSlant->"Italic"],
  StyleBox[",", "Input"],
  " ",
  StyleBox["b",
    FontSlant->"Italic"],
  StyleBox["]", "Input"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(FullForm[Sin[1/2 + 1/x]]\)], "Input"],

Cell[BoxData[
    TagBox[
      StyleBox["\(Sin[Plus[Rational[1, 2], Power[x, -1]]]\)",
        ShowStringCharacters->True,
        NumberMarks->True],
      FullForm]], "Output"]
}, Closed]],

Cell[TextData[Cell[BoxData[
    \(f[x_] := x^x\)], "Input"]], "Question",
  CellGroupingRules->"NormalGrouping"],

Cell[TextData[{
  "A function definition made with ",
  Cell[BoxData[
      \( := \)], "Input"],
  " returns the value ",
  StyleBox["Null", "Input"],
  ", so it is necessary to wrap the definition in ",
  StyleBox["Hold", "Input"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(FullForm[Hold[f[x_]\  := \ x^x]]\)], "Input"],

Cell[BoxData[
    TagBox[
      StyleBox["\(Hold[SetDelayed[f[Pattern[x, Blank[]]], Power[x, x]]]\)",
        ShowStringCharacters->True,
        NumberMarks->True],
      FullForm]], "Output"]
}, Closed]],

Cell[TextData[StyleBox["g'[x]", "Input"]], "Question",
  CellGroupingRules->"NormalGrouping"],

Cell[TextData[{
  "The function ",
  StyleBox["Derivative", "Input"],
  " is a functional, meaning it operates on other functions."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(FullForm[\(g'\)[x]]\)], "Input"],

Cell[BoxData[
    TagBox[
      StyleBox["\(\(\(Derivative[1]\)[g]\)[x]\)",
        ShowSpecialCharacters->False,
        ShowStringCharacters->True,
        NumberMarks->True],
      FullForm]], "Output"]
}, Closed]],

Cell["\<\
Notice that the head of a derivative is an expression, and not just \
a symbol.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(FullForm[Head[\(g'\)[x]]]\)], "Input"],

Cell[BoxData[
    TagBox[
      StyleBox["\(\(Derivative[1]\)[g]\)",
        ShowSpecialCharacters->False,
        ShowStringCharacters->True,
        NumberMarks->True],
      FullForm]], "Output"]
}, Closed]],

Cell[TextData[Cell[BoxData[
    \({\((x^y)\)^z, \ x^\((y^z)\)}\)], "Input"]], "Question"],

Cell["\<\
This exercise shows the effect of grouping expressions in different \
ways.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(FullForm[{\((x^y)\)^z, x^\((y^z)\)}]\)], "Input"],

Cell[BoxData[
    TagBox[
      StyleBox["\(List[Power[Power[x, y], z], Power[x, Power[y, z]]]\)",
        ShowSpecialCharacters->False,
        ShowStringCharacters->True,
        NumberMarks->True],
      FullForm]], "Output"]
}, Closed]],

Cell[TextData[Cell[BoxData[
    \({x == y, x === y}\)], "Input"]], "Question",
  CellGroupingRules->"NormalGrouping"],

Cell[TextData[{
  "In this case, it is necessary to wrap the expression in ",
  StyleBox["Hold", "Input"],
  " because ",
  Cell[BoxData[
      \(x === y\)], "Input"],
  " evaluates to the value ",
  StyleBox["False", "Input"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(FullForm[{x == y, x === y}]\)], "Input"],

Cell[BoxData[
    TagBox[
      StyleBox["\(List[Equal[x, y], False]\)",
        ShowStringCharacters->True,
        NumberMarks->True],
      FullForm]], "Output"]
}, Closed]],

Cell[TextData[{
  "Here we use ",
  StyleBox["Hold", "Input"],
  "."
}], "Text"],

Cell[BoxData[
    \(FullForm[Hold[{x == y, x === y}]]\)], "Input",
  CellGroupingRules->"NormalGrouping"],

Cell[BoxData[
    TagBox[
      StyleBox["\(Hold[List[Equal[x, y], SameQ[x, y]]]\)",
        ShowStringCharacters->True,
        NumberMarks->True],
      FullForm]], "Output"],

Cell[TextData[Cell[BoxData[
    \(GaussianIntegers -> True\)], "Input"]], "Question",
  CellGroupingRules->"NormalGrouping"],

Cell[CellGroupData[{

Cell[BoxData[
    \(FullForm[GaussianIntegers -> True]\)], "Input"],

Cell[BoxData[
    TagBox[
      StyleBox["\(Rule[GaussianIntegers, True]\)",
        ShowStringCharacters->True,
        NumberMarks->True],
      FullForm]], "Output"]
}, Closed]],

Cell[" ", "EndExercises"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Functions", "Section"],

Cell[CellGroupData[{

Cell["Defining Variables", "Subsection"],

Cell[TextData[{
  "We define variables in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " by entering ",
  StyleBox["name",
    FontSlant->"Italic"],
  " ",
  StyleBox["=", "Input"],
  " ",
  StyleBox["value",
    FontSlant->"Italic"],
  ", using a single equal sign. (The internal form of ",
  StyleBox["name",
    FontSlant->"Italic"],
  " ",
  StyleBox["=", "Input"],
  " ",
  StyleBox["value",
    FontSlant->"Italic"],
  " is ",
  StyleBox["Set[", "Input"],
  StyleBox["name",
    FontSlant->"Italic"],
  StyleBox[",", "Input"],
  " ",
  StyleBox["value",
    FontSlant->"Italic"],
  StyleBox["]", "Input"],
  ".) Variable names can be as long as desired, and can be any combination of \
letters (both upper- and lower-case) and numbers, with the restriction that a \
variable name cannot begin with a number. Note that a variable name cannot \
contain an underscore character, so ",
  Cell["var_name", "Input"],
  " is not a valid variable name."
}], "Text"],

Cell[TextData[{
  "To set the variable called ",
  StyleBox["newvar", "Input"],
  " equal to 15, we enter the following."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(newvar = 15\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(15\)], "Output"]
}, Closed]],

Cell[TextData[{
  "Wherever ",
  StyleBox["newvar", "Input"],
  " is used, it is replaced with its assigned value."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Sqrt[newvar]\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(\@15\)], "Output"]
}, Closed]],

Cell[TextData[{
  "Variables can take symbolic values as well, so the following is a valid \
assignment. (We keep ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " from printing the result of a variable assignment by ending the input \
line with a semicolon.)"
}], "Text"],

Cell[BoxData[
    \(\(zzz = xxx\^2 + yyy\^2; \)\)], "Input"],

Cell[TextData[{
  "The right-hand side of a variable assignment can be a function or program, \
in which case ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " sets the value of the variable equal to the value returned after \
evaluating the right-hand side. Here we set the value of ",
  StyleBox["solutionset", "Input"],
  " to be the result of a ",
  StyleBox["Solve", "Input"],
  " command."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(solutionset = Solve[x\^2 == x + 1, x]\)], "Input"],

Cell[BoxData[
    \({{x \[Rule] 1\/2\ \((1 - \@5)\)}, {x \[Rule] 1\/2\ \((1 + \@5)\)}}\)], 
  "Output"]
}, Closed]],

Cell[TextData[{
  "We can even set a variable equal to a function name. For instance, we can \
set the variable ",
  StyleBox["int", "Input"],
  " equal to the built-in ",
  StyleBox["Integrate", "Input"],
  " function."
}], "Text"],

Cell[BoxData[
    \(\(int = Integrate; \)\)], "Input"],

Cell[TextData[{
  "We can now use ",
  StyleBox["int", "Input"],
  " in places we would use ",
  StyleBox["Integrate", "Input"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(int[Exp[\(-x\^2\)], x]\)], "Input"],

Cell[BoxData[
    \(1\/2\ \@\[Pi]\ Erf[x]\)], "Output"]
}, Closed]],

Cell[TextData[{
  "It is important to realize that variable assignments are permanent. The \
values of ",
  StyleBox["newvar", "Input"],
  ", ",
  StyleBox["zzz", "Input"],
  ", ",
  StyleBox["solutionset", "Input"],
  ", and ",
  StyleBox["int", "Input"],
  " will remain in memory until we quit ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ", or until we use ",
  StyleBox["Clear", "Input"],
  " to tell ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " to clear the value of the variable. Here is a calculation that uses the \
value of ",
  StyleBox["newvar", "Input"],
  " defined above."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(newvar\^2 + newvar + 200\)], "Input"],

Cell[BoxData[
    \(440\)], "Output"]
}, Closed]],

Cell[TextData[{
  StyleBox["Clear[newvar]", "Input"],
  " clears the value of ",
  StyleBox["newvar", "Input"],
  "."
}], "Text"],

Cell[BoxData[
    \(Clear[newvar]\)], "Input"],

Cell[TextData[{
  "The symbol ",
  StyleBox["newvar", "Input"],
  " no longer has a value."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(newvar\^2 + newvar + 200\)], "Input"],

Cell[BoxData[
    \(200 + newvar + newvar\^2\)], "Output"]
}, Closed]],

Cell["\<\
Here we clear the values of the other variables defined \
earlier.\
\>", "Text"],

Cell[BoxData[
    \(Clear[zzz, solutionset, int]\)], "Input"],

Cell[TextData[{
  "(To clear the value of every variable and function defined in the current \
session without having to enter a complete list, type ",
  StyleBox["Clear[\"Global`*\"]", "Input"],
  ". The form ",
  StyleBox["Global`", "Input"],
  " is explained in the chapter \[OpenCurlyDoubleQuote]Packages\
\[CloseCurlyDoubleQuote].)"
}], "Text"],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " applies the standard rules of algebra to symbols that have not been \
assigned values. One common use of symbols without definitions is to treat \
them as units."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(30  year \((365  day/year)\) \((24  hour/day)\)\)], "Input"],

Cell[BoxData[
    \(262800\ hour\)], "Output"]
}, Closed]],

Cell[TextData[{
  "In some cases we want to reevaluate the right side of a variable \
definition each time the variable is used. For example, we may wish to define \
a variable ",
  StyleBox["rnd", "Input"],
  " that returns a random integer from 1 to 10, so that it returns a \
different number each time. To tell ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " to reevaluate the right side of an assignment each time the variable is \
used, we use the colon-equal sign ",
  StyleBox[":=", "Input"],
  ". The internal form of ",
  StyleBox["name",
    FontSlant->"Italic"],
  " ",
  StyleBox[":=", "Input"],
  " ",
  StyleBox["value",
    FontSlant->"Italic"],
  " is ",
  StyleBox["SetDelayed[", "Input"],
  StyleBox["name",
    FontSlant->"Italic"],
  StyleBox[",", "Input"],
  " ",
  StyleBox["value",
    FontSlant->"Italic"],
  StyleBox["]", "Input"],
  "."
}], "Text"],

Cell[TextData[{
  "The following definition of ",
  StyleBox["rnd", "Input"],
  " works as desired. Notice that no value is returned when we use ",
  StyleBox[":=", "Input"],
  "."
}], "Text"],

Cell[BoxData[
    \(rnd := Random[Integer, {1, 10}]\)], "Input"],

Cell[TextData[{
  "Every time we use the name ",
  StyleBox["rnd", "Input"],
  ", ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " reevaluates the right-hand side of the assignment, and returns a (most \
likely) different random number."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \({rnd, rnd, rnd}\)], "Input"],

Cell[BoxData[
    \({5, 10, 3}\)], "Output"]
}, Closed]],

Cell[TextData[{
  "If we were to use the equal sign, ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " would evaluate the right-hand side of the assignment immediately, and \
return the same value every time the variable is used."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(samernd = Random[Integer, {1, 10}]\)], "Input"],

Cell[BoxData[
    \(3\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \({samernd, samernd, samernd}\)], "Input"],

Cell[BoxData[
    \({3, 3, 3}\)], "Output"]
}, Closed]],

Cell[TextData[{
  "See also ",
  StyleBox["ClearAll", "Input"],
  ", ",
  StyleBox["Remove", "Input"],
  ", ",
  StyleBox["Unset", "Input"],
  " "
}], "SeeAlso"],

Cell["Exercises: Defining Variables", "Exercises",
  PageBreakAbove->True],

Cell[TextData[{
  "Assign the symbol ",
  StyleBox["const", "Input",
    FontFamily->"Courier"],
  " the value of an approximation to ",
  Cell[BoxData[
      \(TraditionalForm\`1\/\(2  \[Pi]\)\)]],
  " with 30 significant digits."
}], "Question"],

Cell[TextData[{
  "We use ",
  StyleBox["N", "Input"],
  " to obtain the numeric approximation."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(const = N[1/\((2 Pi)\), 30]\)], "Input"],

Cell[BoxData[
    \(0.15915494309189533576888376337251436203446`30\)], "Output"]
}, Closed]],

Cell["The constant can now be used inside other expressions.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(const\ E\^\(-x\^2\)\)], "Input"],

Cell[BoxData[
    \(0.15915494309189533576888376337251436203446`30\ E\^\(-x\^2\)\)], 
  "Output"]
}, Closed]],

Cell[TextData[{
  "Define a variable named ",
  StyleBox["AorB", "Input",
    FontFamily->"Courier"],
  " that returns either the symbol ",
  StyleBox["A", "Input",
    FontFamily->"Courier"],
  " or the symbol ",
  StyleBox["B", "Input",
    FontFamily->"Courier"],
  ", with a 50 percent chance of each."
}], "Question"],

Cell[TextData[{
  "If we want to choose randomly between ",
  StyleBox["A", "Input"],
  " and ",
  StyleBox["B", "Input"],
  ", and have the same value returned each time ",
  StyleBox["AorB", "Input"],
  " is used, we use the equal sign ",
  StyleBox["=", "Input"],
  " in the definition."
}], "Text"],

Cell[BoxData[
    \(\(AorB = If[Random[] < 0.5, A, B]; \)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \({AorB, AorB, AorB, AorB}\)], "Input"],

Cell[BoxData[
    \({B, B, B, B}\)], "Output"]
}, Closed]],

Cell[TextData[{
  "If we want a (possibly) different value to be returned each time we use ",
  StyleBox["AorB", "Input"],
  ", we use the colon-equal sign ",
  StyleBox[":=", "Input"],
  " in the definition, which tells ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " to reevaluate the right-hand side of the definition each time we use ",
  StyleBox["AorB", "Input"],
  "."
}], "Text"],

Cell[BoxData[
    \(Clear[AorB]\)], "Input"],

Cell[BoxData[
    \(\(AorB := If[Random[] < 0.5, A, B]; \)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \({AorB, AorB, AorB, AorB}\)], "Input"],

Cell[OutputFormData["\<\
{B, B, A, B}\
\>", "\<\
{B, B, A, B}\
\>"], "Output"]
}, Closed]],

Cell[" ", "EndExercises"]
}, Closed]],

Cell[CellGroupData[{

Cell["Introduction to Functions and Patterns", "Subsection"],

Cell[TextData[{
  "We define a function by giving it a name, a template that describes its \
arguments (called a ",
  StyleBox["pattern",
    FontSlant->"Italic"],
  "), and an expression that describes the operations to be performed on the \
arguments. On the left side of the following definition, ",
  StyleBox["sinc", "Input"],
  " is the name of the function, ",
  StyleBox["x", "Input"],
  " is the name of the pattern, and the underscore ",
  StyleBox["_", "Input"],
  " is a pattern, or blank, that will match any single argument; on the right \
side of the definition is an expression that describes the operations to be \
performed on an expression that matches the pattern."
}], "Text"],

Cell[BoxData[
    \(sinc[x_] := Sin[x]/x\)], "Input"],

Cell["\<\
Notice that we do not include underscore characters on the \
right-hand side of the definition, and that nothing is returned after making \
the function definition.\
\>", "Text"],

Cell[TextData[{
  "When we enter the following expression, ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " looks in its rule table for ",
  StyleBox["sinc", "Input"],
  " and sees that it contains a rule for evaluating ",
  StyleBox["sinc", "Input"],
  " of a single expression; the single expression matches the pattern ",
  StyleBox["x_", "Input"],
  ", and ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " replaces every occurrence of ",
  StyleBox["x", "Input"],
  " on the right-hand side of the definition with the argument."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(sinc[1.23456]\)], "Input"],

Cell[OutputFormData["\<\
0.7646474224296834644\
\>", 
"\<\
0.764647\
\>"], "Output"]
}, Closed]],

Cell[TextData[
"It is important not to leave a space between a pattern\[CloseCurlyQuote]s \
name and the underscore, though we can separate the pattern name and the \
pattern structure with a colon, if desired."], "Text"],

Cell[BoxData[
    \(sinc[x : _] := Sin[x]/x\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(sinc[\[Pi]\/3]\)], "Input"],

Cell[BoxData[
    \(\(3\ \@3\)\/\(2\ \[Pi]\)\)], "Output"]
}, Closed]],

Cell[TextData[{
  "The pattern ",
  StyleBox["x_", "Input"],
  " matches any single expression, so the expression ",
  Cell[BoxData[
      StyleBox[\(a + b\),
        "Input"]]],
  " is a valid argument to ",
  StyleBox["sinc", "Input"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(sinc[a + b]\)], "Input"],

Cell[BoxData[
    \(Sin[a + b]\/\(a + b\)\)], "Output"]
}, Closed]],

Cell[TextData[{
  "The pattern ",
  StyleBox["x_", "Input"],
  " will not match zero arguments or a sequence of more than one argument. ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " returns an expression unevaluated when it has no definitions to apply, as \
in the case of ",
  StyleBox["sinc", "Input"],
  " called with zero arguments."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(sinc[]\)], "Input"],

Cell[BoxData[
    \(sinc[]\)], "Output"]
}, Closed]],

Cell[TextData[{
  "Similarly, ",
  StyleBox["sinc", "Input"],
  " does not evaluate if given a sequence of two arguments."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(sinc[1, 2]\)], "Input"],

Cell[BoxData[
    \(sinc[1, 2]\)], "Output"]
}, Closed]],

Cell[TextData[{
  "A list is considered a single argument, so ",
  StyleBox["sinc", "Input"],
  " will evaluate if given a list of arguments."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(sinc[{1, 2, 3}]\)], "Input"],

Cell[BoxData[
    \({Sin[1], Sin[2]\/2, Sin[3]\/3}\)], "Output"]
}, Closed]],

Cell[TextData[{
  "The name we give to a pattern is unimportant, and it is treated as a dummy \
variable. The pattern ",
  StyleBox["x_", "Input"],
  " on the left-hand side of the definition of ",
  StyleBox["sinc", "Input"],
  " could have expressed as ",
  StyleBox["num_", "Input"],
  ", ",
  StyleBox["z_", "Input"],
  ", or anything else."
}], "Text"],

Cell[TextData[{
  "Notice that we used a colon-equal sign ",
  StyleBox[":=", "Input"],
  " (",
  StyleBox["SetDelayed", "Input"],
  ") to separate the left and right sides of the definition of ",
  StyleBox["sinc", "Input"],
  ". It is usually safe, as a rule of thumb, to use the colon-equal sign \
whenever we define functions."
}], "Text"],

Cell["\<\
The expression on the right side of a function definition can be as \
complicated as desired. Functions we define can call other built-in and \
user-defined functions.\
\>", "Text"],

Cell[BoxData[
    \(complexPlot[z_] := \n\t
      ListPlot[\n\t\tTranspose[{Re[z], Im[z]}], 
        PlotStyle \[Rule] PointSize[0.03], \n\t\tPlotRange \[Rule] All]\)], 
  "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(complexPlot[N[Fourier[{1, 0, 0, 1, 1, 1, 0, 0, 0, 0, 1, 1, 1}]]]; 
    \)\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.178399 0.410926 0.309017 0.31083 [
[.38386 .29652 -9 -9 ]
[.38386 .29652 9 0 ]
[.58932 .29652 -3 -9 ]
[.58932 .29652 3 0 ]
[.79479 .29652 -9 -9 ]
[.79479 .29652 9 0 ]
[.1659 .07589 -30 -4.5 ]
[.1659 .07589 0 4.5 ]
[.1659 .1536 -24 -4.5 ]
[.1659 .1536 0 4.5 ]
[.1659 .23131 -30 -4.5 ]
[.1659 .23131 0 4.5 ]
[.1659 .38672 -24 -4.5 ]
[.1659 .38672 0 4.5 ]
[.1659 .46443 -18 -4.5 ]
[.1659 .46443 0 4.5 ]
[.1659 .54214 -24 -4.5 ]
[.1659 .54214 0 4.5 ]
[ 0 -0.00028 0 0 ]
[ 1 .61832 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.38386 .30902 m
.38386 .31527 L
s
[(0.5)] .38386 .29652 0 1 Mshowa
.58932 .30902 m
.58932 .31527 L
s
[(1)] .58932 .29652 0 1 Mshowa
.79479 .30902 m
.79479 .31527 L
s
[(1.5)] .79479 .29652 0 1 Mshowa
.125 Mabswid
.21949 .30902 m
.21949 .31277 L
s
.26058 .30902 m
.26058 .31277 L
s
.30168 .30902 m
.30168 .31277 L
s
.34277 .30902 m
.34277 .31277 L
s
.42495 .30902 m
.42495 .31277 L
s
.46605 .30902 m
.46605 .31277 L
s
.50714 .30902 m
.50714 .31277 L
s
.54823 .30902 m
.54823 .31277 L
s
.63042 .30902 m
.63042 .31277 L
s
.67151 .30902 m
.67151 .31277 L
s
.7126 .30902 m
.7126 .31277 L
s
.75369 .30902 m
.75369 .31277 L
s
.83588 .30902 m
.83588 .31277 L
s
.87697 .30902 m
.87697 .31277 L
s
.91806 .30902 m
.91806 .31277 L
s
.95916 .30902 m
.95916 .31277 L
s
.13731 .30902 m
.13731 .31277 L
s
.09621 .30902 m
.09621 .31277 L
s
.05512 .30902 m
.05512 .31277 L
s
.01403 .30902 m
.01403 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.1784 .07589 m
.18465 .07589 L
s
[(-0.75)] .1659 .07589 1 0 Mshowa
.1784 .1536 m
.18465 .1536 L
s
[(-0.5)] .1659 .1536 1 0 Mshowa
.1784 .23131 m
.18465 .23131 L
s
[(-0.25)] .1659 .23131 1 0 Mshowa
.1784 .38672 m
.18465 .38672 L
s
[(0.25)] .1659 .38672 1 0 Mshowa
.1784 .46443 m
.18465 .46443 L
s
[(0.5)] .1659 .46443 1 0 Mshowa
.1784 .54214 m
.18465 .54214 L
s
[(0.75)] .1659 .54214 1 0 Mshowa
.125 Mabswid
.1784 .01373 m
.18215 .01373 L
s
.1784 .02927 m
.18215 .02927 L
s
.1784 .04481 m
.18215 .04481 L
s
.1784 .06035 m
.18215 .06035 L
s
.1784 .09144 m
.18215 .09144 L
s
.1784 .10698 m
.18215 .10698 L
s
.1784 .12252 m
.18215 .12252 L
s
.1784 .13806 m
.18215 .13806 L
s
.1784 .16914 m
.18215 .16914 L
s
.1784 .18469 m
.18215 .18469 L
s
.1784 .20023 m
.18215 .20023 L
s
.1784 .21577 m
.18215 .21577 L
s
.1784 .24685 m
.18215 .24685 L
s
.1784 .26239 m
.18215 .26239 L
s
.1784 .27793 m
.18215 .27793 L
s
.1784 .29348 m
.18215 .29348 L
s
.1784 .32456 m
.18215 .32456 L
s
.1784 .3401 m
.18215 .3401 L
s
.1784 .35564 m
.18215 .35564 L
s
.1784 .37118 m
.18215 .37118 L
s
.1784 .40227 m
.18215 .40227 L
s
.1784 .41781 m
.18215 .41781 L
s
.1784 .43335 m
.18215 .43335 L
s
.1784 .44889 m
.18215 .44889 L
s
.1784 .47997 m
.18215 .47997 L
s
.1784 .49551 m
.18215 .49551 L
s
.1784 .51106 m
.18215 .51106 L
s
.1784 .5266 m
.18215 .5266 L
s
.1784 .55768 m
.18215 .55768 L
s
.1784 .57322 m
.18215 .57322 L
s
.1784 .58876 m
.18215 .58876 L
s
.1784 .60431 m
.18215 .60431 L
s
.25 Mabswid
.1784 0 m
.1784 .61803 L
s
.03 w
.97619 .30902 Mdot
.35978 .33578 Mdot
.02381 .01472 Mdot
.28028 .23369 Mdot
.27156 .35053 Mdot
.34054 .27674 Mdot
.13634 .33811 Mdot
.13634 .27993 Mdot
.34054 .3413 Mdot
.27156 .26751 Mdot
.28028 .38434 Mdot
.02381 .60332 Mdot
.35978 .28226 Mdot
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  Evaluatable->False,
  AspectRatioFixed->True,
  ImageSize->{235, 145},
  ImageMargins->{{119, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40003[0000T@P10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[oooclo5H/1EGooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00000EED0EJX00=d81Slo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0ZP00
e5D0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000>/0000Z0003o`000;h0000400Co8P000ol0
002n00000`06ob4000?o0000_P0000<01_lQ00;o_`0000<01_lQ0003o`000;h0000300Ko8@000ol0
002n00001004ob800_no0000:P000ol0002n0000:P000ol0002n0000:P000ol0002n0000:P02okl0
000Z0003o`000;h0000Z0003o`000;h0000Z0003o`000;h0000Z00;o_`0001400_l40003o`0000<0
00?o00000P03o`D000?o0000_P00010000Co003o2@001Ol0003o00<000?o00000P000ol0002n0000
2@05o`8000Co003o2P000ol000040003o`0000800_no000040001?l00?l:0003o`0000@000?o0000
0P000ol0002n000040001?l00?l;0003o`3o00?o1@000ol0002n000040001?l00?l70007o`000?l0
o`080003o`000;h0000A00;o2005o`030?oo00?o1002okl0000Z0003o`000;h0000Z0003o`000;h0
000Z00;o_`0002X000?o0000_P0002X000?o0000_P0002X000?o0000_P0002X00_no0000:P000ol0
002n0000:P000ol0002n0000:P000ol0002n0000:P02okl0000G00;o10000ol0000200?o1@000ol0
002n00005P001?l00?l70005o`000?l010000ol0002n00003`05o`8000Co003o2`000ol0000200;o
_`0001H000Co003o2`000ol000020003o`000;h0000F0004o`00o`L01?l50003o`000;h0000F0004
o`00o`L000?o00001P000ol0002n00005`02o`P01Ol400;o_`0002X000?o0000_P0002X000?o0000
_P0002X000?o0000_P0002X00_no0000:P000ol0002n0000:P000ol0002n0000:P02okl0000Z0003
o`000;h0000Z0003o`000;h0000Z0003o`000;h0000Z00;o_`0001400_l40004o`0000Go0P03o`D0
00?o0000_P00010000Co003o20001_l00?l0o`<000?o00000P000ol0000B00CoZ00000T01Ol20004
o`00o`T000?o00001@000ol0000200;o4P06ojL0000@0004o`00o`X000?o000010000ol000020003
o`0001401_nW000040001?l00?l70006o`000?l01?l50003o`0001401_nW000040001?l00?l70007
o`000?l0o`080003o`0001401_nW00004@02o`T00ol200Go1002oa<01?nX0000:P000ol0002n0000
:P000ol0002n0000:P000ol0000@00CoZP0002X00_l@00Ko4002o`@000?o00000P03obL00olW00?o
10000ol0000200?o:`0002X000?o00003`06o`/01Ol20003o`0000D000Go0000o`0W0003o`0002L0
00?o00001`001Ol0003o02X0000N00Co20000ol0000?00Ko2P0:o`X000?o00009@000ol0000W0003
o`0000/000?o0000:00001d01_l700;o4006o`X02ol90003o`0002D000?o00009`000ol0000;0003
o`0002P0000M00Ko1`000ol0000@00Co2`0;o`D01?lX0003o`0002L000?o00001`04ob/0000M00Ko
1`000ol0000O00_o1@000ol0000X00;o:002o`T000?o0000;00001d01_l70003o`0002002_l500Go
9`000ol0000W0003o`0000L01OlZ00007P04o`P00_lV00CoU@0002X000?o0000]004o`H0000Z0003
o`000;<01_l50000j_l100000`000ol000070003o`0000L000?o00001P000ol000070003o`0000H0
00?o00001`000ol000060003o`0000L000?o00001P000ol000070003o`0000L000?o00001P000ol0
00070003o`0000H000?o00001`000ol000060003o`0000L000?o00001`000ol000060003o`0000L0
00?o00001P000ol000070003o`0000H01ol50000:P000ol0000/0003o`0002d000?o0000;@000ol0
000T00Ko1@0002X000?o0000]004o`H0000Z00;o_`0001h01?l80003o`0002D01?nE00007@06o`L0
00?o0000800:oi@0000M00Ko1`000ol0000O00_oU00001d01_l700;o4@04o`/02onD00007@06o`L0
00?o00003`06o`X02onD00007P04o`P000?o00003`06o`X02_nE0000:P02oa001_l;00CoVP0002X0
00?o00003`06ojT0000Z0003o`0001001?nZ0000:P000ol0002n0000:P02okl0000A00;o10001?l0
0005o`800ol50003o`0001801?nX000040001?l00?l80006o`00o`3o0`000ol000020003o`000140
1_nW000040001?l00?l90003o`0000D000?o00000P000ol0000A00KoY`00010000Co003o2P000ol0
00040003o`0000800_lB00KoY`00010000Co003o1`001_l0003o00Co1@000ol0000A00KoY`000100
00Co003o1`001ol0003o0?l020000ol0000B00CoZ00001400_l900?o0P05o`@00_no0000:P000ol0
002n0000:P000ol0002n0000:P000ol0002n0000:P02okl0000Z0003o`000;h0000Z0003o`000;h0
000Z00;o_`0002X000?o0000_P0002X000?o0000_P0002X000?o0000_P0002X00_no00005`02o`@0
00?o00000P03o`D000?o0000_P0001H000Co003o1`001Ol0003o00@000?o0000_P0001H000Co003o
2`000ol000020003o`000;h0000F0004o`00o`/000?o00000P02okl0000F0004o`00o`L01?l50003
o`000;h0000F0004o`00o`L000?o00001P000ol0002n00005`02o`P01Ol400;o_`0002X000?o0000
_P0002X000?o0000_P0002X000?o0000_P0002X00_no0000:P000ol0002n0000:P000ol0002n0000
:P000ol0002n0000:P02okl0000Z0003o`000;h0000Z0003o`000;h0000Z00;o_`0001400_l40003
o`0000<000?o00000P03o`D000?o0000_P00010000Co003o2@001Ol0003o00<000?o00000P000ol0
002n000040001?l00?l:0003o`0000@000?o00000P000ol0002n000040001?l00?l:0003o`0000@0
00?o00000P02okl0000@0004o`00o`/000?o0?l00ol50003o`000;h0000@0004o`00o`L000Oo0000
o`3o00P000?o0000_P0001400_l800Go00<0ool00ol400;o_`0002X000?o0000_P0002X000?o0000
_P0002X000?o0000_P0002X00_no0000:P000ol0002n0000:P000ol0002n0000:P000ol0002n0000
:P02okl0000Z0003o`000;h0000400Co8P000ol0002n00000`06ob400_no00000`06ob4000?o0000
_P0000<01_lQ0003o`000;h0000300Ko8@000ol0002n0000
\>"],
  ImageRangeCache->{{{0, 234}, {144, 0}} -> {-0.440509, -0.995078, 0.0104541, 
  0.0138207}}]
}, Closed]],

Cell["\<\
The right side of a function definition can be a compound \
expression, in which case the value returned by the function is the value of \
the last expression in the definition. We must enclose the entire compound \
expression in parentheses to make it clear that the entire expression is part \
of the definition.\
\>", "Text"],

Cell[BoxData[
    \(sinc[x_] := \((Print["The argument to sinc is ", x]; Sin[x]\/x)\)\)], 
  "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(sinc[\(-1.1\)]\)], "Input"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{"\(\"The argument to sinc is \"\)", "\[InvisibleSpace]", 
        RowBox[{"-", 
          StyleBox["1.10000000000000008`",
            StyleBoxAutoDelete->True,
            PrintPrecision->2]}]}],
      SequenceForm[ "The argument to sinc is ", -1.1],
      Editable->False]], "Print"],

Cell[BoxData[
    \(0.810188509146759372`\)], "Output"]
}, Closed]],

Cell[TextData[{
  "Evaluating ",
  Cell[BoxData[
      \(sinc[a, b]\)], "Input"],
  " does not work because we have not entered a definition for ",
  StyleBox["sinc", "Input"],
  " when it is given any number of arguments other than one."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(sinc[a, b]\)], "Input"],

Cell[BoxData[
    \(sinc[a, b]\)], "Output"]
}, Closed]],

Cell[TextData[{
  "To give a definition to ",
  StyleBox["sinc", "Input"],
  " when it is applied to two arguments, we add the following definition."
}], "Text"],

Cell[BoxData[
    \(sinc[x_, y_] := Sin[x]/y\)], "Input"],

Cell[TextData[{
  "Now, when we give ",
  StyleBox["sinc", "Input"],
  " two arguments, the first matches the pattern ",
  StyleBox["x_", "Input"],
  " and the second matches the pattern ",
  StyleBox["y_", "Input"],
  ". The arguments that match these patterns are substituted wherever ",
  StyleBox["x", "Input"],
  " and ",
  StyleBox["y", "Input"],
  " appear in the right-hand side of the definition."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(sinc[a, 7]\)], "Input"],

Cell[BoxData[
    \(Sin[a]\/7\)], "Output"]
}, Closed]],

Cell[TextData[{
  "Notice that we can have several definitions attached to the same symbol. \
We can find all the definitions ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " has for a function by entering ",
  StyleBox["?", "Input"],
  " ",
  StyleBox["FunctionName",
    FontSlant->"Italic"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell["? sinc", "Input"],

Cell[BoxData[
    \("Global`"\[InvisibleSpace]"sinc"\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      StyleBox[
        "\(sinc[x_]\\  :=            \\ (Print[\"The argument to sinc is \", \
\\ x]; \\ Sin[x]/x)\\n\\ \\n         sinc[x_, \\ y_]\\  := \\ Sin[x]/y\)",
        ShowStringCharacters->True,
        NumberMarks->True],
      InputForm[ 
        Definition[ sinc]],
      Editable->True,
      AutoDelete->True]], "Print"]
}, Closed]],

Cell["\<\
The value a function returns does not have to be a number or a \
simple expression. The following function returns a list of graphics \
primitives, with the arguments substituted for the appropriate dummy \
variables.\
\>", "Text"],

Cell[BoxData[
    \(CircledDigit[d_, {x_, y_}] := {GrayLevel[0], Disk[{x, y}, 0.05], 
        GrayLevel[1], Text[ToString[d], {x, y}]}\)], "Input"],

Cell[TextData[{
  "Here is the result of one use of ",
  StyleBox["CircledDigit", "Input"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(CircledDigit[8, {0, 1}]\)], "Input"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{\(GrayLevel[0]\), ",", 
        RowBox[{"Disk", "[", 
          RowBox[{\({0, 1}\), ",", 
            StyleBox["0.05`",
              StyleBoxAutoDelete->True,
              PrintPrecision->1]}], "]"}], ",", \(GrayLevel[1]\), ",", 
        \(Text["8", {0, 1}]\)}], "}"}]], "Output"]
}, Closed]],

Cell[TextData[{
  "The function can be used in conjunction with other functions, in this case \
inside a ",
  StyleBox["Plot", "Input"],
  " statement."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(Plot[Sin[x\^2], {x, \(-1\), 1}, \n\t
      Epilog \[Rule] \n
        \t\t{CircledDigit[1, {0.50, 0.25}], 
          CircledDigit[2, {\(-0.75\), 0.53}]}, 
      AspectRatio \[Rule] Automatic]; \)\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .42074 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.476191 0.0100175 0.476191 [
[.02381 -0.00248 -6 -9 ]
[.02381 -0.00248 6 0 ]
[.2619 -0.00248 -12 -9 ]
[.2619 -0.00248 12 0 ]
[.7381 -0.00248 -9 -9 ]
[.7381 -0.00248 9 0 ]
[.97619 -0.00248 -3 -9 ]
[.97619 -0.00248 3 0 ]
[.4875 .10526 -18 -4.5 ]
[.4875 .10526 0 4.5 ]
[.4875 .20049 -18 -4.5 ]
[.4875 .20049 0 4.5 ]
[.4875 .29573 -18 -4.5 ]
[.4875 .29573 0 4.5 ]
[.4875 .39097 -18 -4.5 ]
[.4875 .39097 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .42074 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .01002 m
.02381 .01627 L
s
[(-1)] .02381 -0.00248 0 1 Mshowa
.2619 .01002 m
.2619 .01627 L
s
[(-0.5)] .2619 -0.00248 0 1 Mshowa
.7381 .01002 m
.7381 .01627 L
s
[(0.5)] .7381 -0.00248 0 1 Mshowa
.97619 .01002 m
.97619 .01627 L
s
[(1)] .97619 -0.00248 0 1 Mshowa
.125 Mabswid
.07143 .01002 m
.07143 .01377 L
s
.11905 .01002 m
.11905 .01377 L
s
.16667 .01002 m
.16667 .01377 L
s
.21429 .01002 m
.21429 .01377 L
s
.30952 .01002 m
.30952 .01377 L
s
.35714 .01002 m
.35714 .01377 L
s
.40476 .01002 m
.40476 .01377 L
s
.45238 .01002 m
.45238 .01377 L
s
.54762 .01002 m
.54762 .01377 L
s
.59524 .01002 m
.59524 .01377 L
s
.64286 .01002 m
.64286 .01377 L
s
.69048 .01002 m
.69048 .01377 L
s
.78571 .01002 m
.78571 .01377 L
s
.83333 .01002 m
.83333 .01377 L
s
.88095 .01002 m
.88095 .01377 L
s
.92857 .01002 m
.92857 .01377 L
s
.25 Mabswid
0 .01002 m
1 .01002 L
s
.5 .10526 m
.50625 .10526 L
s
[(0.2)] .4875 .10526 1 0 Mshowa
.5 .20049 m
.50625 .20049 L
s
[(0.4)] .4875 .20049 1 0 Mshowa
.5 .29573 m
.50625 .29573 L
s
[(0.6)] .4875 .29573 1 0 Mshowa
.5 .39097 m
.50625 .39097 L
s
[(0.8)] .4875 .39097 1 0 Mshowa
.125 Mabswid
.5 .03383 m
.50375 .03383 L
s
.5 .05764 m
.50375 .05764 L
s
.5 .08145 m
.50375 .08145 L
s
.5 .12907 m
.50375 .12907 L
s
.5 .15287 m
.50375 .15287 L
s
.5 .17668 m
.50375 .17668 L
s
.5 .2243 m
.50375 .2243 L
s
.5 .24811 m
.50375 .24811 L
s
.5 .27192 m
.50375 .27192 L
s
.5 .31954 m
.50375 .31954 L
s
.5 .34335 m
.50375 .34335 L
s
.5 .36716 m
.50375 .36716 L
s
.5 .41478 m
.50375 .41478 L
s
.25 Mabswid
.5 0 m
.5 .42074 L
s
0 0 m
1 0 L
1 .42074 L
0 .42074 L
closepath
clip
newpath
.5 Mabswid
.02381 .41072 m
.06244 .36598 L
.10458 .31296 L
.14415 .26233 L
.18221 .21516 L
.22272 .1684 L
.26171 .12802 L
.30316 .09099 L
.34309 .06162 L
.3815 .03949 L
.40095 .03062 L
.42237 .02267 L
.44268 .01692 L
.45178 .0149 L
.46172 .0131 L
.4671 .01229 L
.4721 .01165 L
.47727 .0111 L
.48196 .0107 L
.48658 .0104 L
.4887 .01029 L
.49093 .01019 L
.49332 .01011 L
.49438 .01008 L
.49552 .01006 L
.49675 .01004 L
.49789 .01003 L
.49859 .01002 L
.49925 .01002 L
.50049 .01002 L
.50163 .01002 L
.50286 .01003 L
.50401 .01005 L
.50508 .01007 L
.50754 .01014 L
.51014 .01023 L
.51268 .01036 L
.51504 .01049 L
.5204 .01089 L
.5293 .01182 L
.53882 .01318 L
.54906 .01507 L
.56016 .01762 L
.58032 .02356 L
.60019 .03109 L
.62123 .04086 L
.65912 .06308 L
.69946 .09314 L
.73829 .12801 L
.77956 .17091 L
Mistroke
.81932 .217 L
.85757 .26451 L
.89827 .3166 L
.93745 .36585 L
.97619 .41072 L
Mfstroke
.7381 .12907 m
.7381 .12907 .02381 0 365.73 arc
F
1 g
gsave
.7381 .12907 -66 -11.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 15.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
1.000000 1.000000 1.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 15.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
1.000000 1.000000 1.000000 setrgbcolor
(1) show
69.000000 15.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
1.000000 1.000000 1.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
0 g
.14286 .2624 m
.14286 .2624 .02381 0 365.73 arc
F
1 g
gsave
.14286 .2624 -66 -11.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 15.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
1.000000 1.000000 1.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 15.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
1.000000 1.000000 1.000000 setrgbcolor
(2) show
69.000000 15.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
1.000000 1.000000 1.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 121.125},
  ImageMargins->{{35, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000N@P10`4000010?ooobl_;oooZZVYZNSX
j?oo05FZZZZZZ_W0RS/k>gYjN[Vi^OShn03ooeGooj[ooonI<c<c<fi^KZf][Nc/k02ZoeFZojZZoonZ
oclo?ginO[fm_Oclo5D00:X00?l00?l0VCLg=g9bL[6a/O3`l03o05Go0:[o00<30d92@X61PL30`000
EED0EJX0EOl0ELbIoc/k>gIfM[Fe]OCdm03oEEGoEJ[oE@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0Z/`c
<clo?gYjN[Vi^OShn03oZUGoZZ[oZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`<30d92@WinO[fm_Ocl
o03ooeGooj[oo`l?3di>CXf=SLc<c01E05EE0:YE0?mE00L71dI6AX61PL30`000EED00:X00?l001<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@/;2dY:BXF5QLC4a000ZUD0EJX0EOl0EALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZPl?3di>CXV9RLS8b000oeD0ZZX0Z_l0ZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEoa<C
4e9BDXf=SLc<c01E05D0ojX0ool0oalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ01LG5eIFEY6ATM3@d01E
EEEE0:YE0?mE02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZEA/K6eYJFYFEUMCDe01EZUEEEJYEEOmEEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZQlO7eiNGYVIVMSHf01EoeEEZZYEZ_mEZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZob<S8f9RHYfMWMcLg02Z05EEojYEoomEobl_;fi^KZf][Nc/k03o05Go0:[o0=gW1RLW
9fIVIZ6QXN3Ph02ZEEFZ0:ZZ0?nZ03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooEB/[:fYZJZFUYNCTi02Z
ZUFZEJZZEOnZECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l08@000?l08@0001<00olf00;o1002o`<0
0om]00;o1002o`<00ole00?o4`0001@000?o0000=0001?l00?l300;o1P000ol0001Y0004o`00o`<0
0_l60003o`0003<000?o00004P0000d01Ol20003o`0002h01Ol01@3o003o00/000?o0000J@001?l0
0?l;0003o`0003<000?o00004P0001@000?o0000=0001?l00?l800?oK0001?l00?l800?o=P000ol0
000B000050000ol0000d0004o`00o`P000?o0000K0001?l00?l80003o`0003H000?o00004P0001<0
0_lg00;o2@04of`00_l900Co=002oa@0003o0240003o0240002?0003o`0008h0002?0003o`0008h0
002?0003o`0008h0000<0?oo2?l=00004P000ol000090003o`0000X000?o00002@000ol0000:0003
o`0000T000?o00002P000ol000090003o`0000X000?o00001P05o`/000?o00002P03o`T000?o0000
2P000ol000090003o`0000X000?o00002@000ol0000:0003o`0000T000?o00002P000ol000090003
o`000140001l00?o40000ol0000=00CoO@0007X00_lC0003o`0001400omj0000M`03oaD000?o0000
5003ogL0001d00?o60000ol0000G00;oM@0007400olK00;o6P02og<0001_00;o7P000ol0000K00;o
L@0006d00_lP0003o`0001d00_m_0000K0000ol0000P0003o`0001l00_m]0000JP02ob<000?o0000
8@000ol0001Z0000J002obD000?o00008P02ofX0001W0003o`0002D00_lU00;oJ00006D00_lX0003
o`0002H000?o0000I@0006@000?o0000:0000ol0000W00;oI@0006<000?o0000:@000ol0000Y0003
o`000680001Q00;o;0000ol0000Z00;oHP00060000?o0000;0000ol0000/0003o`0005l0001N00;o
;`02obh000?o0000GP0005d000?o0000;`000ol0000^00;oGP0005`000?o0000<0000ol0000`0003
o`0005/0001J00;o<`000ol0000a00;oF`0005T000?o0000<`000ol0000c0003o`0005P0001H0003
o`0002400_l400;o0`04o`@000?o0000=0000ol0001G0000E`000ol0000Q0004o`00o`<00_l40003
o`0000@000?o0000=@000ol0001F0000EP000ol0000R0004o`00o`X000?o00000`03ocH000?o0000
E@0005D000?o00008`001?l00?l;0003o`00008000?o0000=`000ol0o`05odl0001D0003o`0002@0
00Co003o20001?l00?l40003o`0003L02Om>0000D`000ol0000V00;o2P02o`D000?o0000=`03o`<0
0om>0000DP000ol0000j0003o`0003H01Ol00`3oo`03odd0001A0003o`0003/000?o0000=P05o`03
0?oo00?oC@00050000?o0000?002ocH01_l00`3oo`04od`0001?0003o`0003d000?o0000=@06o`03
0?oo00CoC00004h000?o0000?P000ol0000f00Co0P06od`0001=0003o`0003l000?o0000=P0;odd0
001<0003o`00040000?o0000=`0:odd0001;0003o`00044000?o0000>009odd0001:0003o`000480
0_lj00Ko0P000ol0001:0000B@000ol000130003o`00048000?o0000B@0004P000?o0000A0000ol0
00130003o`0004P000170003o`0004D000?o0000A0000ol000170000AP000ol000160003o`0004D0
00?o0000AP0004H000?o0000AP000ol000160003o`0004D000150003o`0004L00_m70003o`0004D0
00140003o`0004P000?o0000A`000ol000140000@`000ol000190003o`0004P000?o0000@`0004<0
00?o0000B@000ol000190003o`00048000120003o`0004X000?o0000BP000ol000110000@@000ol0
000h00;o1002o`@00ol40003o`0004/000?o0000@000040000?o0000>0001?l00?l300;o1@000ol0
00030003o`0004`000?o0000?`0003l000?o0000>@001?l00?l800Co1003odd000?o0000?P0003l0
00?o0000>@001?l00?l80003o`3o00D000?o0000CP000ol0000m0000?P000ol0000j0004o`00o`P0
00?o0?l01@000ol0001?0003o`0003`0000m0003o`0003`00_l:00;o1@000ol0001@0003o`0003/0
000l0003o`00050000?o0000D@000ol0000j0000?0000ol0001@0003o`00054000?o0000>P0003/0
00?o0000D@02oe<000?o0000>@0003X000?o0000DP000ol0001C0003o`0003P0000i0003o`0005<0
00?o0000E0000ol0000g0000>0000ol0001D0003o`0005D000?o0000=P0003L000?o0000E@000ol0
001F0003o`0003D0000^00Oo0P000ol0001E0003o`0005H000?o0000=@0002d02_mH00;oF0000ol0
000d0000;@02o`@00omI0003o`0005P000?o0000<`0002`01?l00`3oo`04oeP000?o0000F@000ol0
000b0000;005o`030?oo00?oF0000ol0001J0003o`000340000[00Oo00<0ool00_mH0003o`0005/0
00?o0000<00002/01?l0103oo`04oeP000?o0000F`000ol0000`0000:`05o`801OmH00;oG@000ol0
000_0000;00;oeP000?o0000G@000ol0000^0000;@0:oeP000?o0000GP000ol0000]0000;P08oeT0
00?o0000G`000ol0000/0000;@000ol0o`05oeX000?o0000G`000ol0000/0000;0000ol0001=00;o
1002o`@00_l50003o`00060000?o0000:`0002`000?o0000C0001?l00?l300;o0`001?l00?l40003
o`00064000?o0000:P0002/000?o0000C@001?l00?l80004o`00o`@00omR0003o`0002T0000Z0003
o`0004h000Co003o2003o`D000?o0000HP000ol0000Y0000:@000ol0001?0004o`00o`P000?o0000
1@000ol0001S0003o`0002P0000X0003o`0005400_l:00?o10000ol0001T0003o`0002L0000W0003
o`0006D000?o0000I@000ol0000V00009`000ol0001U0003o`0006H000?o00009@0002H000?o0000
IP02ofL000?o00009@0002D000?o0000I`000ol0001W0003o`0002@0000T0003o`0006P000?o0000
J0000ol0000S00008`000ol0001Y0003o`0006T000?o00008P0002<000?o0000J@000ol0001Y0003
o`000280000R0003o`0006X000?o0000JP000ol0000Q00008@000ol0001[00;oK0000ol0000P0000
80000ol0001/0003o`0006`000?o00007`00020000?o0000K0000ol0001]0003o`0001h0000O0003
o`0006d000?o0000K@000ol0000N00007P000ol0001^0003o`0006h000?o00007@0001d000?o0000
K`000ol0001_0003o`0001`0000L0003o`0007000_ma0003o`0001/0000L0003o`00070000?o0000
L0000ol0000K00006`000ol0001a0003o`00074000?o00006P0001X000?o0000LP000ol0001b0003
o`0001T0000I0003o`0007<000?o0000L`000ol0000H000060000ol0001Q00;o1002o`@00_l50003
o`0007@000?o00005`0001L000?o0000H@001?l00?l300;o0`001?l00?l40003o`0007D000?o0000
5P0001L000?o0000H@001?l00?l80004o`00o`@00ome0003o`0001H0000F0003o`00068000Co003o
2@02o`D000?o0000MP000ol0000E00005@000ol0001S0004o`00o`P000Co003o10000ol0001g0003
o`0001@0000D0003o`0006D00_l:00;o1@000ol0001h0003o`0001<0000C0003o`0007T000?o0000
N@000ol0000B00004P000ol0001j0003o`0007X000?o00004@0008l00_n?0000S`000ol0002>0000
\
\>"],
  ImageRangeCache->{{{0, 287}, {120.125, 0}} -> {-1.1477, -0.0982305, 
  0.00799793, 0.00799793}}]
}, Closed]],

Cell[TextData[{
  "Sometimes we may wish to define a function to act only on arguments with a \
particular ",
  StyleBox["form",
    FontSlant->"Italic"],
  ". For example, we can define a function called ",
  StyleBox["recip", "Input"],
  " that works only on symbolic rational expressions, and returns the \
reciprocal of its argument."
}], "Text"],

Cell[BoxData[
    \(recip[a_/b_] := b/a\)], "Input"],

Cell[TextData[{
  "If ",
  StyleBox["recip", "Input"],
  " is given a symbolic rational expression, the numerator matches the \
pattern ",
  StyleBox["a_", "Input"],
  ", the denominator matches the pattern ",
  StyleBox["b_", "Input"],
  ", and ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " returns ",
  Cell[BoxData[
      \(b/a\)], "Input"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(recip[c/d]\)], "Input"],

Cell[BoxData[
    \(d\/c\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(recip[\(u + v\)\/w]\)], "Input"],

Cell[BoxData[
    \(w\/\(u + v\)\)], "Output"]
}, Closed]],

Cell[TextData[{
  "The argument ",
  Cell[BoxData[
      \(u + v\)], "Input"],
  " does not match the pattern ",
  Cell[BoxData[
      \(a_/b_\)], "Input"],
  ", so ",
  Cell[BoxData[
      \(recip[u + v]\)], "Input"],
  " returns unevaluated."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(recip[u + v]\)], "Input"],

Cell[BoxData[
    \(recip[u + v]\)], "Output"]
}, Closed]],

Cell[TextData[{
  "Note that the argument ",
  Cell[BoxData[
      \(1/2\)], "Input"],
  " does not match ",
  Cell[BoxData[
      \(a_/b_\)], "Input"],
  " because the internal form of ",
  Cell[BoxData[
      \(1/2\)], "Input"],
  " is ",
  Cell[BoxData[
      \(Rational[1, 2]\)], "Input"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(recip[1\/2]\)], "Input"],

Cell[BoxData[
    \(recip[1\/2]\)], "Output"]
}, Closed]],

Cell["\<\
It is acceptable to leave a pattern unnamed if we do not refer to \
the corresponding argument on the right side of the definition. The following \
definition accepts any expression as an argument, but does not use the \
expression when computing a value.\
\>", "Text"],

Cell[BoxData[
    \(ignore[_] := "Ignored."\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ignore[10]\)], "Input"],

Cell[BoxData[
    \("Ignored."\)], "Output"]
}, Closed]],

Cell[TextData[{
  "A useful function for investigating which expressions match a given \
pattern is ",
  StyleBox["MatchQ", "Input"],
  ", which takes an expression and a pattern, and returns ",
  StyleBox["True", "Input"],
  " or ",
  StyleBox["False", "Input"],
  " to indicate if the given expression matches the given pattern."
}], "Text"],

Cell[TextData[{
  "Here we test if several expressions match the pattern ",
  Cell[BoxData[
      \(a_ + b_\)], "Input"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(MatchQ[c + d, a_ + b_]\)], "Input"],

Cell[BoxData[
    \(True\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(MatchQ[\((u + v)\) + w, a_ + b_]\)], "Input"],

Cell[BoxData[
    \(True\)], "Output"]
}, Closed]],

Cell[TextData[{
  "The expression ",
  Cell[BoxData[
      \(3  z + z\)], "Input"],
  " does not match the pattern ",
  Cell[BoxData[
      \(a_ + b_\)], "Input"],
  " because ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " evaluates the expression to ",
  Cell[BoxData[
      \(4  z\)], "Input"],
  ", which is not in the form of a sum."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(MatchQ[3\ z + z, a_ + b_]\)], "Input"],

Cell[BoxData[
    \(False\)], "Output"]
}, Closed]],

Cell[TextData[{
  "See also ",
  StyleBox["HoldAll", "Input"],
  ", ",
  StyleBox["HoldFirst", "Input"],
  ", ",
  StyleBox["HoldPattern", "Input"],
  ", ",
  StyleBox["Verbatim", "Input"],
  " "
}], "SeeAlso"],

Cell["Exercises: Introduction to Functions and Patterns", "Exercises",
  PageBreakAbove->True],

Cell[TextData[{
  "Define a function ",
  Cell["dist", "Input"],
  " that takes two arguments, ",
  Cell["x", "Input"],
  " and ",
  Cell["y", "Input"],
  ", and returns ",
  Cell[BoxData[
      \(Abs[x - y]\)], "Input"],
  "."
}], "Question"],

Cell[TextData[{
  "The definition is straightforward: we give two patterns, ",
  StyleBox["x_", "Input"],
  " and ",
  StyleBox["y_", "Input"],
  ", to match the two arguments."
}], "Text"],

Cell[BoxData[
    \(dist[x_, y_] := Abs[x - y]\)], "Input"],

Cell["Here we verify that the function works as desired.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(dist[\(-1\), 6]\)], "Input"],

Cell[BoxData[
    \(7\)], "Output"]
}, Closed]],

Cell[TextData[{
  "Define a function ",
  StyleBox["avg", "Input"],
  " that returns the average of its two arguments."
}], "Question"],

Cell["Again, the definition is straightforward.", "Text"],

Cell[BoxData[
    \(avg[a_, b_] := \((a + b)\)/2\)], "Input"],

Cell["Here is a test of the function.", "Text"],

Cell[CellGroupData[{

Cell["avg[10, 10000]", "Input"],

Cell[BoxData[
    \(5005\)], "Output"]
}, Closed]],

Cell[TextData[{
  "Create a function ",
  StyleBox["dx",
    FontFamily->"Courier"],
  " that accepts a single argument, and returns the derivative of its \
argument with respect to ",
  StyleBox["x",
    FontFamily->"Courier"],
  "."
}], "Question"],

Cell[TextData[{
  "Because ",
  StyleBox["x", "Input"],
  " is not the name of a pattern on the left side of the definition, ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " computes the derivative with respect to the literal symbol ",
  StyleBox["x", "Input"],
  "."
}], "Text"],

Cell[BoxData[
    \(dx[expr_] := D[expr, x]\)], "Input"],

Cell["Here is a test of the function.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(dx[Sin[Exp[x]]]\)], "Input"],

Cell[BoxData[
    \(E\^x\ Cos[E\^x]\)], "Output"]
}, Closed]],

Cell[" ", "EndExercises"]
}, Closed]],

Cell[CellGroupData[{

Cell["Limiting Arguments to Certain Types", "Subsection"],

Cell[TextData[{
  "We can limit the type of arguments that a function will accept by putting \
the head of an acceptable argument after the underscore in the pattern. The \
following function ",
  StyleBox["mersenne", "Input"],
  " accepts only one argument ",
  StyleBox["n",
    FontSlant->"Italic"],
  " with the head ",
  StyleBox["Integer", "Input"],
  ", and returns the Mersenne number corresponding to the ",
  Cell[BoxData[
      \(TraditionalForm\`n\^th\)]],
  " prime number (",
  Cell[BoxData[
      \(TraditionalForm\`M(p\_n)\)]],
  ")."
}], "Text"],

Cell[BoxData[
    \(mersenne[n_Integer] := 2^Prime[n] - 1\)], "Input"],

Cell[TextData[{
  "The argument 10 has the head ",
  StyleBox["Integer", "Input"],
  ", so it matches the pattern ",
  StyleBox["n_Integer", "Input"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(mersenne[10]\)], "Input"],

Cell[BoxData[
    \(536870911\)], "Output"]
}, Closed]],

Cell[TextData[{
  "Because ",
  StyleBox["mersenne", "Input"],
  " has not been defined for noninteger arguments, an attempt to use ",
  StyleBox["mersenne", "Input"],
  " with a noninteger argument returns unevaluated."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \({mersenne[1.5], mersenne[\[Pi]], mersenne[var]}\)], "Input"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{"mersenne", "[", 
          StyleBox["1.5`",
            StyleBoxAutoDelete->True,
            PrintPrecision->2], "]"}], ",", "\(mersenne[\[Pi]]\)", ",", 
        "\(mersenne[var]\)"}], "}"}]], "Output"]
}, Closed]],

Cell[TextData[{
  "The head of an equation is ",
  StyleBox["Equal", "Input"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Head[x\^2 == 1]\)], "Input"],

Cell[BoxData[
    \(Equal\)], "Output"]
}, Closed]],

Cell[TextData[{
  "We can create a function that recognizes equations by using the pattern ",
  StyleBox["_Equal", "Input"],
  " on the left side of the definition. The following function ",
  StyleBox["solveX", "Input"],
  " solves a given equation with respect to ",
  StyleBox["x", "Input"],
  ". (Because ",
  StyleBox["x", "Input"],
  " is not the name of a pattern on the left side of the definition, ",
  StyleBox["solveX", "Input"],
  " solves with respect to the literal symbol ",
  StyleBox["x", "Input"],
  ".)"
}], "Text"],

Cell[BoxData[
    \(solveX[eqn_Equal] := Solve[eqn, x]\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(solveX[x\^2 == 1]\)], "Input"],

Cell[BoxData[
    \({{x \[Rule] \(-1\)}, {x \[Rule] 1}}\)], "Output"]
}, Closed]],

Cell[TextData[{
  "Built-in mathematical constants such as ",
  StyleBox["Pi", "Input"],
  " and ",
  StyleBox["E", "Input"],
  " have the head ",
  StyleBox["Symbol", "Input"],
  "."
}], "Text"],

Cell[TextData[{
  "If a function can accept any of several types of arguments, we use \
alternative patterns of the form ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox[
            RowBox[{
              StyleBox["patname",
                FontSlant->"Italic"], "_", 
              StyleBox["head",
                FontSlant->"Italic"]}]], "1"], TraditionalForm]]],
  " ",
  StyleBox["|", "Input"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox[
            RowBox[{
              StyleBox["patname",
                FontSlant->"Italic"], "_", 
              StyleBox["head",
                FontSlant->"Italic"]}]], "2"], TraditionalForm]]],
  ". Any number of alternatives are allowed."
}], "Text"],

Cell[BoxData[
    \(IsASymbolOrInteger[x_Integer | x_Symbol] := True\)], "Input"],

Cell[CellGroupData[{

Cell["IsASymbolOrInteger[10]", "Input"],

Cell[BoxData[
    \(True\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell["IsASymbolOrInteger[Pi]", "Input"],

Cell[BoxData[
    \(True\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell["IsASymbolOrInteger[22/7]", "Input"],

Cell[BoxData[
    \(IsASymbolOrInteger[22\/7]\)], "Output"]
}, Closed]],

Cell[TextData[{
  "In many cases we define a function that accepts a list as an argument. If \
the length of the list is unimportant, we can use the pattern ",
  StyleBox["_List", "Input"],
  " on the left side of the definition."
}], "Text"],

Cell[BoxData[
    \(reverseAnyList[L_List] := Reverse[L]\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(reverseAnyList[{1, 2, 3}]\)], "Input"],

Cell[BoxData[
    \({3, 2, 1}\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(reverseAnyList[{1, 2, 3, 4}]\)], "Input"],

Cell[BoxData[
    \({4, 3, 2, 1}\)], "Output"]
}, Closed]],

Cell["\<\
If the length of the list is significant, we explicitly enter the \
allowable form. The following function accepts only a list with three \
elements.\
\>", "Text"],

Cell[BoxData[
    \(reverseTriple[{x_, y_, z_}] := {z, y, x}\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(reverseTriple[{1, 2, 3}]\)], "Input"],

Cell[BoxData[
    \({3, 2, 1}\)], "Output"]
}, Closed]],

Cell["\<\
The argument here has four elements, so it does not match the given \
pattern, and the function returns unevaluated.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(reverseTriple[{1, 2, 3, 4}]\)], "Input"],

Cell[BoxData[
    \(reverseTriple[{1, 2, 3, 4}]\)], "Output"]
}, Closed]],

Cell[TextData[{
  "It is important to keep in mind the difference between a function that \
accepts a ",
  StyleBox["list",
    FontSlant->"Italic"],
  " of several arguments and a function that accepts a ",
  StyleBox["sequence",
    FontSlant->"Italic"],
  " of several arguments. The pattern inside ",
  StyleBox["reverseTriple", "Input"],
  " does not match the following input because the arguments are in the form \
of a sequence of three arguments, not a list of three arguments."
}], "Text"],

Cell[CellGroupData[{

Cell["reverseTriple[1, 2, 3]", "Input"],

Cell[BoxData[
    \(reverseTriple[1, 2, 3]\)], "Output"]
}, Closed]],

Cell[TextData[{
  "See also ",
  StyleBox["BlankSequence", "Input"],
  ", ",
  StyleBox["BlankNullSequence", "Input"],
  ", ",
  StyleBox["Sequence", "Input"],
  " "
}], "SeeAlso"],

Cell["Exercises: Limiting Arguments to Certain Types", "Exercises",
  PageBreakAbove->True],

Cell[TextData[{
  "Define a function ",
  StyleBox["add3list", "Input",
    FontFamily->"Courier"],
  " that accepts a ",
  StyleBox["list",
    FontSlant->"Italic"],
  " of three integers and returns the sum of the arguments. Define a function \
",
  StyleBox["add3seq", "Input",
    FontFamily->"Courier"],
  " that accepts a ",
  StyleBox["sequence",
    FontSlant->"Italic"],
  " of three integers and returns their sum."
}], "Question"],

Cell[TextData[{
  "The functions ",
  StyleBox["add3list", "Input"],
  " and ",
  StyleBox["add3seq", "Input"],
  " differ only on their left sides: ",
  StyleBox["add3list", "Input"],
  " contains list brackets surrounding the patterns, while ",
  StyleBox["add3seq", "Input"],
  " does not."
}], "Text"],

Cell[BoxData[
    \(add3list[{x_Integer, y_Integer, z_Integer}] := x + y + z\)], "Input"],

Cell[BoxData[
    \(add3seq[x_Integer, y_Integer, z_Integer] := x + y + z\)], "Input"],

Cell["Here are tests of the functions.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(add3list[{1, 100, 10000}]\)], "Input"],

Cell[BoxData[
    \(10101\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(add3seq[1, 100, 10000]\)], "Input"],

Cell[BoxData[
    \(10101\)], "Output"]
}, Closed]],

Cell["Neither function accepts an argument intended for the other.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(add3list[1, 2, 3]\)], "Input"],

Cell[BoxData[
    \(add3list[1, 2, 3]\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(add3seq[{1, 2, 3}]\)], "Input"],

Cell[BoxData[
    \(add3seq[{1, 2, 3}]\)], "Output"]
}, Closed]],

Cell[TextData[{
  "Create a function ",
  StyleBox["doubleString", "Input",
    FontFamily->"Courier"],
  " that accepts a string and returns two copies of the string joined \
together. (Use the function ",
  StyleBox["StringJoin", "Input",
    FontFamily->"Courier"],
  " on the right side of the definition.)"
}], "Question"],

Cell[TextData[{
  "To limit arguments to those with the head ",
  StyleBox["String", "Input"],
  ", we use the pattern ",
  StyleBox["s_String", "Input"],
  "."
}], "Text"],

Cell[BoxData[
    \(doubleString[s_String] := StringJoin[s, s]\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(doubleString["Twice"]\)], "Input"],

Cell[BoxData[
    \("TwiceTwice"\)], "Output"]
}, Closed]],

Cell[" ", "EndExercises"]
}, Closed]],

Cell[CellGroupData[{

Cell["Conditions", "Subsection"],

Cell[TextData[{
  "Beyond limiting arguments to certain types, we can limit them according to \
given conditions by using the conditional operator slash-semicolon ",
  StyleBox["/;", "Input"],
  ". Expressions of the form ",
  StyleBox["expr",
    FontSlant->"Italic"],
  " ",
  StyleBox["/;", "Input"],
  " ",
  StyleBox["cond",
    FontSlant->"Italic"],
  " have the internal form ",
  StyleBox["Condition[", "Input"],
  StyleBox["expr",
    FontSlant->"Italic"],
  StyleBox[",", "Input"],
  " ",
  StyleBox["cond",
    FontSlant->"Italic"],
  StyleBox["]", "Input"],
  ", and we read them as \[OpenCurlyDoubleQuote]",
  StyleBox["expr",
    FontSlant->"Italic"],
  " provided that ",
  StyleBox["cond",
    FontSlant->"Italic"],
  "\[CloseCurlyDoubleQuote]. Functions commonly used in conditions are the \
tests for equality ",
  StyleBox["==", "Input"],
  " and ",
  StyleBox["!=", "Input"],
  ", which respectively test if two expressions are equal or unequal; the \
numerical tests ",
  StyleBox["<", "Input"],
  ", ",
  StyleBox["<=", "Input"],
  ", ",
  StyleBox[">", "Input"],
  ", ",
  StyleBox[">=", "Input"],
  "; and the built-in predicate functions ",
  StyleBox["Test",
    FontSlant->"Italic"],
  StyleBox["Q", "Input"],
  ", which are explained in the next section."
}], "Text"],

Cell[TextData[{
  "An example of a function requiring a condition is the function ",
  StyleBox["mersenne", "Input"],
  ", which should accept only positive integers; nonpositive arguments cause \
a warning message."
}], "Text"],

Cell[CellGroupData[{

Cell["mersenne[ -2 ]", "Input"],

Cell[BoxData[
    \(Prime::"intpp"\(:\ 
      \)"Positive integer argument expected in \!\(Prime[\(-2\)]\)."\)], 
  "Message"],

Cell[BoxData[
    \(\(-1\) + 2\^Prime[\(-2\)]\)], "Output"]
}, Closed]],

Cell[TextData[{
  "To limit the pattern ",
  StyleBox["n_Integer", "Input"],
  " to positive integers, we tell ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " to apply the definition only if ",
  StyleBox["n", "Input"],
  " is greater than zero by stating the condition after the ",
  StyleBox["/;", "Input"],
  " operator. (It is first necessary to clear the previous definition for ",
  StyleBox["mersenne", "Input"],
  ".)"
}], "Text"],

Cell[BoxData[
    \(Clear[mersenne]\)], "Input"],

Cell[BoxData[
    \(mersenne[n_Integer] := 2\^Prime[n] - 1 /; n > 0\)], "Input"],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " no longer tries to evaluate ",
  StyleBox["mersenne", "Input"],
  " for nonpositive arguments."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \({mersenne[15], mersenne[\(-15\)]}\)], "Input"],

Cell[BoxData[
    \({140737488355327, mersenne[\(-15\)]}\)], "Output"]
}, Closed]],

Cell["\<\
Alternatively, we can include the condition on the left side of the \
definition, directly following the pattern.\
\>", "Text"],

Cell[BoxData[
    \(Clear[mersenne]\)], "Input"],

Cell[BoxData[
    \(mersenne[n_Integer /; n > 0] := 2\^Prime[n] - 1\)], "Input"],

Cell["Again, the function works as intended.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \({mersenne[15], mersenne[\(-15\)]}\)], "Input"],

Cell[BoxData[
    \({140737488355327, mersenne[\(-15\)]}\)], "Output"]
}, Closed]],

Cell[TextData[{
  "Using the same technique, we define a square-wave function. We define ",
  StyleBox["squarewave[x]", "Input"],
  " to be ",
  Cell[BoxData[
      \(TraditionalForm\`\(-1\)\)]],
  " when the greatest integer less than ",
  StyleBox["x", "Input"],
  " is even, and 1 when the greatest integer less than ",
  StyleBox["x", "Input"],
  " is odd."
}], "Text"],

Cell[BoxData[
    \(squarewave[x_] := \(-1\) /; EvenQ[Floor[x]]\)], "Input"],

Cell[BoxData[
    \(squarewave[x_] := 1 /; OddQ[Floor[x]]\)], "Input"],

Cell[TextData[{
  "Here is a plot of ",
  StyleBox["squarewave", "Input"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(Plot[squarewave[x], {x, \(-2.5\), 2.5}, 
      PlotStyle \[Rule] Thickness[0.02]]; \)\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.190476 0.309017 0.294302 [
[.11905 .29652 -6 -9 ]
[.11905 .29652 6 0 ]
[.30952 .29652 -6 -9 ]
[.30952 .29652 6 0 ]
[.69048 .29652 -3 -9 ]
[.69048 .29652 3 0 ]
[.88095 .29652 -3 -9 ]
[.88095 .29652 3 0 ]
[.4875 .01472 -12 -4.5 ]
[.4875 .01472 0 4.5 ]
[.4875 .16187 -24 -4.5 ]
[.4875 .16187 0 4.5 ]
[.4875 .45617 -18 -4.5 ]
[.4875 .45617 0 4.5 ]
[.4875 .60332 -6 -4.5 ]
[.4875 .60332 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.11905 .30902 m
.11905 .31527 L
s
[(-2)] .11905 .29652 0 1 Mshowa
.30952 .30902 m
.30952 .31527 L
s
[(-1)] .30952 .29652 0 1 Mshowa
.69048 .30902 m
.69048 .31527 L
s
[(1)] .69048 .29652 0 1 Mshowa
.88095 .30902 m
.88095 .31527 L
s
[(2)] .88095 .29652 0 1 Mshowa
.125 Mabswid
.15714 .30902 m
.15714 .31277 L
s
.19524 .30902 m
.19524 .31277 L
s
.23333 .30902 m
.23333 .31277 L
s
.27143 .30902 m
.27143 .31277 L
s
.34762 .30902 m
.34762 .31277 L
s
.38571 .30902 m
.38571 .31277 L
s
.42381 .30902 m
.42381 .31277 L
s
.4619 .30902 m
.4619 .31277 L
s
.5381 .30902 m
.5381 .31277 L
s
.57619 .30902 m
.57619 .31277 L
s
.61429 .30902 m
.61429 .31277 L
s
.65238 .30902 m
.65238 .31277 L
s
.72857 .30902 m
.72857 .31277 L
s
.76667 .30902 m
.76667 .31277 L
s
.80476 .30902 m
.80476 .31277 L
s
.84286 .30902 m
.84286 .31277 L
s
.08095 .30902 m
.08095 .31277 L
s
.04286 .30902 m
.04286 .31277 L
s
.00476 .30902 m
.00476 .31277 L
s
.91905 .30902 m
.91905 .31277 L
s
.95714 .30902 m
.95714 .31277 L
s
.99524 .30902 m
.99524 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 .01472 m
.50625 .01472 L
s
[(-1)] .4875 .01472 1 0 Mshowa
.5 .16187 m
.50625 .16187 L
s
[(-0.5)] .4875 .16187 1 0 Mshowa
.5 .45617 m
.50625 .45617 L
s
[(0.5)] .4875 .45617 1 0 Mshowa
.5 .60332 m
.50625 .60332 L
s
[(1)] .4875 .60332 1 0 Mshowa
.125 Mabswid
.5 .04415 m
.50375 .04415 L
s
.5 .07358 m
.50375 .07358 L
s
.5 .10301 m
.50375 .10301 L
s
.5 .13244 m
.50375 .13244 L
s
.5 .1913 m
.50375 .1913 L
s
.5 .22073 m
.50375 .22073 L
s
.5 .25016 m
.50375 .25016 L
s
.5 .27959 m
.50375 .27959 L
s
.5 .33845 m
.50375 .33845 L
s
.5 .36788 m
.50375 .36788 L
s
.5 .39731 m
.50375 .39731 L
s
.5 .42674 m
.50375 .42674 L
s
.5 .4856 m
.50375 .4856 L
s
.5 .51503 m
.50375 .51503 L
s
.5 .54446 m
.50375 .54446 L
s
.5 .57389 m
.50375 .57389 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.02 w
.02381 .60332 m
.06244 .60332 L
.08255 .60332 L
.0932 .60332 L
.10458 .60332 L
.11009 .60332 L
.1128 .60332 L
.11531 .60332 L
.11758 .60332 L
.11872 .60332 L
.11999 .01472 L
.12125 .01472 L
.12261 .01472 L
.12507 .01472 L
.14415 .01472 L
.18538 .01472 L
.22508 .01472 L
.26328 .01472 L
.28459 .01472 L
.29466 .01472 L
.30392 .01472 L
.30636 .01472 L
.30755 .01472 L
.30863 .01472 L
.30977 .60332 L
.311 .60332 L
.3136 .60332 L
.32407 .60332 L
.34305 .60332 L
.3829 .60332 L
.42123 .60332 L
.44061 .60332 L
.46201 .60332 L
.47176 .60332 L
.48226 .60332 L
.48709 .60332 L
.49218 .60332 L
.49653 .60332 L
.49771 .60332 L
.49899 .60332 L
.50019 .01472 L
.50128 .01472 L
.54126 .01472 L
.57972 .01472 L
.62064 .01472 L
.641 .01472 L
.66005 .01472 L
.67831 .01472 L
.68357 .01472 L
.68616 .01472 L
Mistroke
.68742 .01472 L
.68856 .01472 L
.68968 .01472 L
.69074 .60332 L
.69185 .60332 L
.69305 .60332 L
.69793 .60332 L
.73899 .60332 L
.77853 .60332 L
.81655 .60332 L
.83774 .60332 L
.85703 .60332 L
.86662 .60332 L
.87168 .60332 L
.87445 .60332 L
.87705 .60332 L
.8793 .60332 L
.88057 .60332 L
.88173 .01472 L
.88293 .01472 L
.88425 .01472 L
.88689 .01472 L
.89599 .01472 L
.9366 .01472 L
.9757 .01472 L
.97619 .01472 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{35, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/@P10`4000010?ooobl_;oooZZVYZNSX
j?oo05FZZZZZZ_W0RS/k>gYjN[Vi^OShn03ooeGooj[ooonI<c<c<fi^KZf][Nc/k02ZoeFZojZZoonZ
oclo?ginO[fm_Oclo5D00:X00?l00?l0VCLg=g9bL[6a/O3`l03o05Go0:[o00<30d92@X61PL30`000
EED0EJX0EOl0ELbIoc/k>gIfM[Fe]OCdm03oEEGoEJ[oE@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0Z/`c
<clo?gYjN[Vi^OShn03oZUGoZZ[oZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`<30d92@WinO[fm_Ocl
o03ooeGooj[oo`l?3di>CXf=SLc<c01E05EE0:YE0?mE00L71dI6AX61PL30`000EED00:X00?l001<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@/;2dY:BXF5QLC4a000ZUD0EJX0EOl0EALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZPl?3di>CXV9RLS8b000oeD0ZZX0Z_l0ZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEoa<C
4e9BDXf=SLc<c01E05D0ojX0ool0oalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ01LG5eIFEY6ATM3@d01E
EEEE0:YE0?mE02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZEA/K6eYJFYFEUMCDe01EZUEEEJYEEOmEEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZQlO7eiNGYVIVMSHf01EoeEEZZYEZ_mEZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZob<S8f9RHYfMWMcLg02Z05EEojYEoomEobl_;fi^KZf][Nc/k03o05Go0:[o0=gW1RLW
9fIVIZ6QXN3Ph02ZEEFZ0:ZZ0?nZ03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooEB/[:fYZJZFUYNCTi02Z
ZUFZEJZZEOnZECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP0008l000?o0000SP0008l000?o0000SP000240
>_l[00?o100koc808?l600008@0job`000?o00000`0koc808?l600008@0jobD01Ol20003o`0000<0
>olb023o1P000240>_l/0003o`0000<0>olb023o1P000240>_l/0003o`0000<0>olb023o1P000240
1Ol`00Go:`02o`D01Ola00Go<P05ob40000Q00Go<005oc801Ola00Go<P05ob40000Q00Go<005oc80
1Ola00Go<P05ob40000Q00Go<005oc801Ola00Go<P05ob40000Q00Go<005oc801Ola00Go<P05ob40
000Q00Go<005oc801Ola00Go<P05ob40000Q00Go<005oc801Ola00Go<P05ob40000Q00Go<005oc80
1Ola00Go<P05ob40000Q00Go<005oc801Ola00Go<P05ob40000Q00Go<005oc801Ola00Go<P05ob40
000Q00Go<005oc801Ola00Go<P05ob40000Q00Go<005oc801Ola00Go<P05ob40000Q00Go<005oc80
1Ola00Go<P05ob40000Q00Go<005oc801Ola00Go<P05ob40000Q00Go<005oc801Ola00Go<P05ob40
000Q00Go<005oc801Ola00Go<P05ob40000Q00Go<005oc801Ola00Go<P05ob40000Q00Go<005oc80
1Ola00Go<P05ob40000Q00Go<005oc801Ola00Go<P05ob40000Q00Go<005oc801Ola00Go<P05ob40
000Q00Go<005oc801Ola00Go<P05ob40000Q00Go<005oc801Ola00Go<P05ob40000Q00Go<005oc80
1Ola00Go<P05ob40000Q00Go<005oc801Ola00Go<P05ob40000Q00Go<005oc801Ola00Go<P05ob40
000Q00Go<005oc801Ola00Go<P05ob40000Q00Go<005oc801Ola00Go<P05ob40000Q00Go<005oc80
1Ola00Go<P05ob40000Q00Go<005oc801Ola00Go<P05ob40000Q00Go<005oc801Ola00Go<P05ob40
000Q00Go<005oc801Ola00Go<P05ob40000Q00Go<005oc801Ola00Go<P05ob40000Q00Go<005oc80
1Ola00Go<P05ob40000Q00Go<005oc801Ola00Go<P05ob40000Q00Go<005oc801Ola00Go<P05ob40
000Q00Go<005oc801Ola00Go<P05ob40000Q00Go<005oc801Ola00Go<P05ob40000Q00Go<005ob00
0_l400;o0`03o`@01Ola00Go<P05ob40000Q00Go<005oal000Co003o0`02o`H000Co00001Ola00Go
<P05ob40000Q00Go<005oaT01Ol01@3o003o00/000Co00001Ola00Go<P05ob40000Q00Go<005oal0
00Co003o2003o`@01Ola00Go<P05ob40000Q00Go<005oal000Co003o20000ol0000400Go<@05oc80
1OlQ00008@05oc001OlP00;o2@04o`<01Ola00Go<P05ob40000Q00Go<005oc801Ola00Go<P05ob40
000Q00Go<005oc801Ola00Go<P05ob40000Q00Go<005oc801Ola00Go<P05ob40000Q00Go<005oc80
1Ola00Go<P05ob40000Q00Go<005oc801Ola00Go<P05ob40000Q00Go<005oc801Ola00Go<P05ob40
000Q00Go<005oc801Ola00Go<P05ob40000Q00Go<005oc801Ola00Go<P05ob40000Q00Go<005oc80
1Ola00Go<P05ob40000Q00Go<005oc801Ola00Go<P05ob40000Q00Go<005oc801Ola00Go<P05ob40
000Q00Go<005oc801Ola00Go<P05ob40000Q00Go<005oc801Ola00Go<P05ob40000Q00Go<005oc80
1Ola00Go<P05ob40000Q00Go<005oc801Ola00Go<P05ob40000Q00Go<005oc801Ola00Go<P05ob40
000Q00Go<005oc801Ola00Go<P05ob40000Q00Go<005oc801Ola00Go<P05ob40000Q00Go<005oc80
1Ola00Go<P05ob40000Q00Go<005oc801Ola00Go<P05ob40000Q00Go<005oc801Ola00Go<P05ob40
000Q00Go<005oc801Ola00Go<P05ob40000Q00Go<005oc801Ola00Go<P05ob40000Q00Go<005oc80
1Ola00Go<P05ob40000Q00Go<005oc801Ola00Go<P05ob40000Q00Go<005oc801Ola00Go<P05ob40
000Q00Go<005oc801Ola00Go<P05ob40000Q00Ko;`07oc001Ola00Go<P05ob40000Q00Go<006oc40
1Ola00Go<P05ob40000M00Wo;P08oc401Ola00Go<P05ob40000Q00Ko;`06oc401Ola00Go<P05ob40
000Q00Ko;`06oc401Ola00Go<P05ob40000Q00Go<006oc401Ola00Go<P05ob40000Q00Go<005oc80
1Ola00Go<P05ob40000Q00Go<005oc801Ola00Go<P05ob40000Q00Go<005oc801Ola00Go<P05ob40
000Q00Go<005oc801Ola00Go<P05ob40000P00Ko<006oc401Ola00Go<P05ob40003oob3o0@000080
00?o000020000ol000070003o`0000H01_l70003o`0000P000?o000020000ol000080003o`0000D0
1_l80003o`0000L000?o000020000ol000080003o`0000H01Ol80003o`0000P000?o000020000ol0
00070003o`0000H01Ol80003o`0000P000?o000020000ol000080003o`0000H01Ol80003o`0000L0
00?o000020000ol0000100008006oc001_la00Go<@05oc801OlQ00008005oc801Ola00Go<@05oc80
1OlQ00008005oc801Ola00Go<@05oc801OlQ00008005oc801Ola00Go<@05oc801OlQ00008005oc80
1Ola00Go<@05oc801OlQ00008005oc801Ola00Go<@05oc801OlQ00008005oc801Ola00Go<@05oc80
1OlQ00008005oc801Ola00Go<@05oc801OlQ00008005oc801Ola00Go<@05oc801OlQ00008005oc80
1Ola00Go<@05oc801OlQ00008005oc801Ola00Go<@05oc801OlQ00008005oc801Ola00Go<@05oc80
1OlQ00008005oc801Ola00Go<@05oc801OlQ00008005oc801Ola00Go<@05oc801OlQ00008005oc80
1Ola00Go<@05oc801OlQ00008005oc801Ola00Go<@05oc801OlQ00008005oc801Ola00Go<@05oc80
1OlQ00008005oc801Ola00Go<@05oc801OlQ00008005oc801Ola00Go<@05oc801OlQ00008005oc80
1Ola00Go<@05oc801OlQ00008005oc801Ola00Go<@05oc801OlQ00008005oc801Ola00Go<@05oc80
1OlQ00008005oc801Ola00Go<@05oc801OlQ00008005oc801Ola00Go<@05oc801OlQ00008005oc80
1Ola00Go<@05oc801OlQ00008005oc801Ola00Go<@05oc801OlQ00008005oc801Ola00Go<@05oc80
1OlQ00008005oc801Ola00Go<@05oc801OlQ00008005oc801Ola00Go<@05oc801OlQ00008005oc80
1Ola00Go<@05oc801OlQ00008005oc801Ola00Go<@05oc801OlQ00008005oc801Ola00Go<@05oc80
1OlQ00008005oc801Ola00Go<@05oc801OlQ00008005oc801Ola00Go<@05oc801OlQ00008005oc80
1Ola00Go<@05oc801OlQ00008005oc801Ola00Go<@05oc801OlQ00008005oc801Ola00Go<@05oc80
1OlQ00008005oc801Ola00Go<@05oc801OlQ00008005oc801OlO00;o1002o`<00ol400Go<@05oc80
1OlQ00008005oc801OlN0004o`00o`<00_l60004o`0000Go<@05oc801OlQ00008005oc801OlN0004
o`00o`/000Co00001Ola00Go<P05ob40000P00Go<P05oah000Co003o2003o`@01Ola00Go<P05ob40
000P00Go<P05oah000Co003o20000ol0000400Go<@05oc801OlQ00008005oc801OlO00;o2@04o`<0
1Ola00Go<P05ob40000P00Go<P05oc401Ola00Go<P05ob40000P00Go<P05oc401Ola00Go<P05ob40
000P00Go<P05oc401Ola00Go<P05ob40000P00Go<P05oc401Ola00Go<P05ob40000P00Go<P05oc40
1Ola00Go<P05ob40000P00Go<P05oc401Ola00Go<P05ob40000P00Go<P05oc401Ola00Go<P05ob40
000P00Go<P05oc401Ola00Go<P05ob40000P00Go<P05oc401Ola00Go<P05ob40000P00Go<P05oc40
1Ola00Go<P05ob40000P00Go<P05oc401Ola00Go<P05ob40000P00Go<P05oc401Ola00Go<P05ob40
000P00Go<P05oc401Ola00Go<P05ob40000P00Go<P05oc401Ola00Go<P05ob40000P00Go<P05oc40
1Ola00Go<P05ob40000P00Go<P05oc401Ola00Go<P05ob40000P00Go<P05oc401Ola00Go<P05ob40
000P00Go<P05oc401Ola00Go<P05ob40000P00Go<P05oc401Ola00Go<P05ob40000P00Go<P05oc40
1Ola00Go<P05ob40000P00Go<P05oc401Ola00Go<P05ob40000P00Go<P05oc401Ola00Go<P05ob40
000P00Go<P05oc401Ola00Go<P05ob40000P00Go<P05oc401Ola00Go<P05ob40000P00Go<P05oc40
1Ola00Go<P05ob40000P00Go<P05oc401Ola00Go<P05ob40000P00Go<P05oc401Ola00Go<P05ob40
000P00Go<P05oc401Ola00Go<P05ob40000P00Go<P05oc401Ola00Go<P05ob40000P00Go<P05oc40
1Ola00Go<P05ob40000P00Go<P05oc401Ola00Go<P05ob40000P00Go<P05oc401Ola00Go<P05ob40
000P00Go<P05oc401Ola00Go<P05ob40000P00Go<P05oc401Ola00Go<P05ob40000P00Go<P05oc40
1Ola00Go<P05ob40000P00Go<P05oc401Ola00Go<P05ob400005023o<P0koc40??lQ00001@0Poc80
>ola03co8@0000D08?lb03_o<@0lob400005023o<P0koc40??lQ00001@0Poc80>ola03co8@0008H0
0_l70003o`0008h0002?0003o`0008h00000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-2.64051, -1.05358, 
  0.0184008, 0.0119092}}]
}, Closed]],

Cell[TextData[{
  "Note that we can use the conditional function ",
  StyleBox["If", "Input"],
  " to achieve the same results."
}], "Text"],

Cell[BoxData[
    \(squarewave2[x_] := If[EvenQ[Floor[x]], \(-1\), 1]\)], "Input"],

Cell[TextData[{
  "The graph of ",
  StyleBox["squarewave2", "Input"],
  " is identical to the graph of ",
  StyleBox["squarewave", "Input"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(Plot[squarewave2[x], {x, \(-2.5\), 2.5}, 
      PlotStyle \[Rule] Thickness[0.02]]; \)\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.190476 0.309017 0.294302 [
[.11905 .29652 -6 -9 ]
[.11905 .29652 6 0 ]
[.30952 .29652 -6 -9 ]
[.30952 .29652 6 0 ]
[.69048 .29652 -3 -9 ]
[.69048 .29652 3 0 ]
[.88095 .29652 -3 -9 ]
[.88095 .29652 3 0 ]
[.4875 .01472 -12 -4.5 ]
[.4875 .01472 0 4.5 ]
[.4875 .16187 -24 -4.5 ]
[.4875 .16187 0 4.5 ]
[.4875 .45617 -18 -4.5 ]
[.4875 .45617 0 4.5 ]
[.4875 .60332 -6 -4.5 ]
[.4875 .60332 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.11905 .30902 m
.11905 .31527 L
s
[(-2)] .11905 .29652 0 1 Mshowa
.30952 .30902 m
.30952 .31527 L
s
[(-1)] .30952 .29652 0 1 Mshowa
.69048 .30902 m
.69048 .31527 L
s
[(1)] .69048 .29652 0 1 Mshowa
.88095 .30902 m
.88095 .31527 L
s
[(2)] .88095 .29652 0 1 Mshowa
.125 Mabswid
.15714 .30902 m
.15714 .31277 L
s
.19524 .30902 m
.19524 .31277 L
s
.23333 .30902 m
.23333 .31277 L
s
.27143 .30902 m
.27143 .31277 L
s
.34762 .30902 m
.34762 .31277 L
s
.38571 .30902 m
.38571 .31277 L
s
.42381 .30902 m
.42381 .31277 L
s
.4619 .30902 m
.4619 .31277 L
s
.5381 .30902 m
.5381 .31277 L
s
.57619 .30902 m
.57619 .31277 L
s
.61429 .30902 m
.61429 .31277 L
s
.65238 .30902 m
.65238 .31277 L
s
.72857 .30902 m
.72857 .31277 L
s
.76667 .30902 m
.76667 .31277 L
s
.80476 .30902 m
.80476 .31277 L
s
.84286 .30902 m
.84286 .31277 L
s
.08095 .30902 m
.08095 .31277 L
s
.04286 .30902 m
.04286 .31277 L
s
.00476 .30902 m
.00476 .31277 L
s
.91905 .30902 m
.91905 .31277 L
s
.95714 .30902 m
.95714 .31277 L
s
.99524 .30902 m
.99524 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 .01472 m
.50625 .01472 L
s
[(-1)] .4875 .01472 1 0 Mshowa
.5 .16187 m
.50625 .16187 L
s
[(-0.5)] .4875 .16187 1 0 Mshowa
.5 .45617 m
.50625 .45617 L
s
[(0.5)] .4875 .45617 1 0 Mshowa
.5 .60332 m
.50625 .60332 L
s
[(1)] .4875 .60332 1 0 Mshowa
.125 Mabswid
.5 .04415 m
.50375 .04415 L
s
.5 .07358 m
.50375 .07358 L
s
.5 .10301 m
.50375 .10301 L
s
.5 .13244 m
.50375 .13244 L
s
.5 .1913 m
.50375 .1913 L
s
.5 .22073 m
.50375 .22073 L
s
.5 .25016 m
.50375 .25016 L
s
.5 .27959 m
.50375 .27959 L
s
.5 .33845 m
.50375 .33845 L
s
.5 .36788 m
.50375 .36788 L
s
.5 .39731 m
.50375 .39731 L
s
.5 .42674 m
.50375 .42674 L
s
.5 .4856 m
.50375 .4856 L
s
.5 .51503 m
.50375 .51503 L
s
.5 .54446 m
.50375 .54446 L
s
.5 .57389 m
.50375 .57389 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.02 w
.02381 .60332 m
.06244 .60332 L
.08255 .60332 L
.0932 .60332 L
.10458 .60332 L
.11009 .60332 L
.1128 .60332 L
.11531 .60332 L
.11758 .60332 L
.11872 .60332 L
.11999 .01472 L
.12125 .01472 L
.12261 .01472 L
.12507 .01472 L
.14415 .01472 L
.18538 .01472 L
.22508 .01472 L
.26328 .01472 L
.28459 .01472 L
.29466 .01472 L
.30392 .01472 L
.30636 .01472 L
.30755 .01472 L
.30863 .01472 L
.30977 .60332 L
.311 .60332 L
.3136 .60332 L
.32407 .60332 L
.34305 .60332 L
.3829 .60332 L
.42123 .60332 L
.44061 .60332 L
.46201 .60332 L
.47176 .60332 L
.48226 .60332 L
.48709 .60332 L
.49218 .60332 L
.49653 .60332 L
.49771 .60332 L
.49899 .60332 L
.50019 .01472 L
.50128 .01472 L
.54126 .01472 L
.57972 .01472 L
.62064 .01472 L
.641 .01472 L
.66005 .01472 L
.67831 .01472 L
.68357 .01472 L
.68616 .01472 L
Mistroke
.68742 .01472 L
.68856 .01472 L
.68968 .01472 L
.69074 .60332 L
.69185 .60332 L
.69305 .60332 L
.69793 .60332 L
.73899 .60332 L
.77853 .60332 L
.81655 .60332 L
.83774 .60332 L
.85703 .60332 L
.86662 .60332 L
.87168 .60332 L
.87445 .60332 L
.87705 .60332 L
.8793 .60332 L
.88057 .60332 L
.88173 .01472 L
.88293 .01472 L
.88425 .01472 L
.88689 .01472 L
.89599 .01472 L
.9366 .01472 L
.9757 .01472 L
.97619 .01472 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{35, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/@P10`4000010?ooobl_;oooZZVYZNSX
j?oo05FZZZZZZ_W0RS/k>gYjN[Vi^OShn03ooeGooj[ooonI<c<c<fi^KZf][Nc/k02ZoeFZojZZoonZ
oclo?ginO[fm_Oclo5D00:X00?l00?l0VCLg=g9bL[6a/O3`l03o05Go0:[o00<30d92@X61PL30`000
EED0EJX0EOl0ELbIoc/k>gIfM[Fe]OCdm03oEEGoEJ[oE@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0Z/`c
<clo?gYjN[Vi^OShn03oZUGoZZ[oZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`<30d92@WinO[fm_Ocl
o03ooeGooj[oo`l?3di>CXf=SLc<c01E05EE0:YE0?mE00L71dI6AX61PL30`000EED00:X00?l001<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@/;2dY:BXF5QLC4a000ZUD0EJX0EOl0EALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZPl?3di>CXV9RLS8b000oeD0ZZX0Z_l0ZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEoa<C
4e9BDXf=SLc<c01E05D0ojX0ool0oalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ01LG5eIFEY6ATM3@d01E
EEEE0:YE0?mE02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZEA/K6eYJFYFEUMCDe01EZUEEEJYEEOmEEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZQlO7eiNGYVIVMSHf01EoeEEZZYEZ_mEZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZob<S8f9RHYfMWMcLg02Z05EEojYEoomEobl_;fi^KZf][Nc/k03o05Go0:[o0=gW1RLW
9fIVIZ6QXN3Ph02ZEEFZ0:ZZ0?nZ03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooEB/[:fYZJZFUYNCTi02Z
ZUFZEJZZEOnZECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP0008l000?o0000SP0008l000?o0000SP000240
>_l[00?o100koc808?l600008@0job`000?o00000`0koc808?l600008@0jobD01Ol20003o`0000<0
>olb023o1P000240>_l/0003o`0000<0>olb023o1P000240>_l/0003o`0000<0>olb023o1P000240
1Ol`00Go:`02o`D01Ola00Go<P05ob40000Q00Go<005oc801Ola00Go<P05ob40000Q00Go<005oc80
1Ola00Go<P05ob40000Q00Go<005oc801Ola00Go<P05ob40000Q00Go<005oc801Ola00Go<P05ob40
000Q00Go<005oc801Ola00Go<P05ob40000Q00Go<005oc801Ola00Go<P05ob40000Q00Go<005oc80
1Ola00Go<P05ob40000Q00Go<005oc801Ola00Go<P05ob40000Q00Go<005oc801Ola00Go<P05ob40
000Q00Go<005oc801Ola00Go<P05ob40000Q00Go<005oc801Ola00Go<P05ob40000Q00Go<005oc80
1Ola00Go<P05ob40000Q00Go<005oc801Ola00Go<P05ob40000Q00Go<005oc801Ola00Go<P05ob40
000Q00Go<005oc801Ola00Go<P05ob40000Q00Go<005oc801Ola00Go<P05ob40000Q00Go<005oc80
1Ola00Go<P05ob40000Q00Go<005oc801Ola00Go<P05ob40000Q00Go<005oc801Ola00Go<P05ob40
000Q00Go<005oc801Ola00Go<P05ob40000Q00Go<005oc801Ola00Go<P05ob40000Q00Go<005oc80
1Ola00Go<P05ob40000Q00Go<005oc801Ola00Go<P05ob40000Q00Go<005oc801Ola00Go<P05ob40
000Q00Go<005oc801Ola00Go<P05ob40000Q00Go<005oc801Ola00Go<P05ob40000Q00Go<005oc80
1Ola00Go<P05ob40000Q00Go<005oc801Ola00Go<P05ob40000Q00Go<005oc801Ola00Go<P05ob40
000Q00Go<005oc801Ola00Go<P05ob40000Q00Go<005oc801Ola00Go<P05ob40000Q00Go<005oc80
1Ola00Go<P05ob40000Q00Go<005oc801Ola00Go<P05ob40000Q00Go<005oc801Ola00Go<P05ob40
000Q00Go<005oc801Ola00Go<P05ob40000Q00Go<005oc801Ola00Go<P05ob40000Q00Go<005ob00
0_l400;o0`03o`@01Ola00Go<P05ob40000Q00Go<005oal000Co003o0`02o`H000Co00001Ola00Go
<P05ob40000Q00Go<005oaT01Ol01@3o003o00/000Co00001Ola00Go<P05ob40000Q00Go<005oal0
00Co003o2003o`@01Ola00Go<P05ob40000Q00Go<005oal000Co003o20000ol0000400Go<@05oc80
1OlQ00008@05oc001OlP00;o2@04o`<01Ola00Go<P05ob40000Q00Go<005oc801Ola00Go<P05ob40
000Q00Go<005oc801Ola00Go<P05ob40000Q00Go<005oc801Ola00Go<P05ob40000Q00Go<005oc80
1Ola00Go<P05ob40000Q00Go<005oc801Ola00Go<P05ob40000Q00Go<005oc801Ola00Go<P05ob40
000Q00Go<005oc801Ola00Go<P05ob40000Q00Go<005oc801Ola00Go<P05ob40000Q00Go<005oc80
1Ola00Go<P05ob40000Q00Go<005oc801Ola00Go<P05ob40000Q00Go<005oc801Ola00Go<P05ob40
000Q00Go<005oc801Ola00Go<P05ob40000Q00Go<005oc801Ola00Go<P05ob40000Q00Go<005oc80
1Ola00Go<P05ob40000Q00Go<005oc801Ola00Go<P05ob40000Q00Go<005oc801Ola00Go<P05ob40
000Q00Go<005oc801Ola00Go<P05ob40000Q00Go<005oc801Ola00Go<P05ob40000Q00Go<005oc80
1Ola00Go<P05ob40000Q00Go<005oc801Ola00Go<P05ob40000Q00Go<005oc801Ola00Go<P05ob40
000Q00Go<005oc801Ola00Go<P05ob40000Q00Go<005oc801Ola00Go<P05ob40000Q00Go<005oc80
1Ola00Go<P05ob40000Q00Go<005oc801Ola00Go<P05ob40000Q00Go<005oc801Ola00Go<P05ob40
000Q00Go<005oc801Ola00Go<P05ob40000Q00Ko;`07oc001Ola00Go<P05ob40000Q00Go<006oc40
1Ola00Go<P05ob40000M00Wo;P08oc401Ola00Go<P05ob40000Q00Ko;`06oc401Ola00Go<P05ob40
000Q00Ko;`06oc401Ola00Go<P05ob40000Q00Go<006oc401Ola00Go<P05ob40000Q00Go<005oc80
1Ola00Go<P05ob40000Q00Go<005oc801Ola00Go<P05ob40000Q00Go<005oc801Ola00Go<P05ob40
000Q00Go<005oc801Ola00Go<P05ob40000P00Ko<006oc401Ola00Go<P05ob40003oob3o0@000080
00?o000020000ol000070003o`0000H01_l70003o`0000P000?o000020000ol000080003o`0000D0
1_l80003o`0000L000?o000020000ol000080003o`0000H01Ol80003o`0000P000?o000020000ol0
00070003o`0000H01Ol80003o`0000P000?o000020000ol000080003o`0000H01Ol80003o`0000L0
00?o000020000ol0000100008006oc001_la00Go<@05oc801OlQ00008005oc801Ola00Go<@05oc80
1OlQ00008005oc801Ola00Go<@05oc801OlQ00008005oc801Ola00Go<@05oc801OlQ00008005oc80
1Ola00Go<@05oc801OlQ00008005oc801Ola00Go<@05oc801OlQ00008005oc801Ola00Go<@05oc80
1OlQ00008005oc801Ola00Go<@05oc801OlQ00008005oc801Ola00Go<@05oc801OlQ00008005oc80
1Ola00Go<@05oc801OlQ00008005oc801Ola00Go<@05oc801OlQ00008005oc801Ola00Go<@05oc80
1OlQ00008005oc801Ola00Go<@05oc801OlQ00008005oc801Ola00Go<@05oc801OlQ00008005oc80
1Ola00Go<@05oc801OlQ00008005oc801Ola00Go<@05oc801OlQ00008005oc801Ola00Go<@05oc80
1OlQ00008005oc801Ola00Go<@05oc801OlQ00008005oc801Ola00Go<@05oc801OlQ00008005oc80
1Ola00Go<@05oc801OlQ00008005oc801Ola00Go<@05oc801OlQ00008005oc801Ola00Go<@05oc80
1OlQ00008005oc801Ola00Go<@05oc801OlQ00008005oc801Ola00Go<@05oc801OlQ00008005oc80
1Ola00Go<@05oc801OlQ00008005oc801Ola00Go<@05oc801OlQ00008005oc801Ola00Go<@05oc80
1OlQ00008005oc801Ola00Go<@05oc801OlQ00008005oc801Ola00Go<@05oc801OlQ00008005oc80
1Ola00Go<@05oc801OlQ00008005oc801Ola00Go<@05oc801OlQ00008005oc801Ola00Go<@05oc80
1OlQ00008005oc801Ola00Go<@05oc801OlQ00008005oc801Ola00Go<@05oc801OlQ00008005oc80
1Ola00Go<@05oc801OlQ00008005oc801Ola00Go<@05oc801OlQ00008005oc801Ola00Go<@05oc80
1OlQ00008005oc801Ola00Go<@05oc801OlQ00008005oc801OlO00;o1002o`<00ol400Go<@05oc80
1OlQ00008005oc801OlN0004o`00o`<00_l60004o`0000Go<@05oc801OlQ00008005oc801OlN0004
o`00o`/000Co00001Ola00Go<P05ob40000P00Go<P05oah000Co003o2003o`@01Ola00Go<P05ob40
000P00Go<P05oah000Co003o20000ol0000400Go<@05oc801OlQ00008005oc801OlO00;o2@04o`<0
1Ola00Go<P05ob40000P00Go<P05oc401Ola00Go<P05ob40000P00Go<P05oc401Ola00Go<P05ob40
000P00Go<P05oc401Ola00Go<P05ob40000P00Go<P05oc401Ola00Go<P05ob40000P00Go<P05oc40
1Ola00Go<P05ob40000P00Go<P05oc401Ola00Go<P05ob40000P00Go<P05oc401Ola00Go<P05ob40
000P00Go<P05oc401Ola00Go<P05ob40000P00Go<P05oc401Ola00Go<P05ob40000P00Go<P05oc40
1Ola00Go<P05ob40000P00Go<P05oc401Ola00Go<P05ob40000P00Go<P05oc401Ola00Go<P05ob40
000P00Go<P05oc401Ola00Go<P05ob40000P00Go<P05oc401Ola00Go<P05ob40000P00Go<P05oc40
1Ola00Go<P05ob40000P00Go<P05oc401Ola00Go<P05ob40000P00Go<P05oc401Ola00Go<P05ob40
000P00Go<P05oc401Ola00Go<P05ob40000P00Go<P05oc401Ola00Go<P05ob40000P00Go<P05oc40
1Ola00Go<P05ob40000P00Go<P05oc401Ola00Go<P05ob40000P00Go<P05oc401Ola00Go<P05ob40
000P00Go<P05oc401Ola00Go<P05ob40000P00Go<P05oc401Ola00Go<P05ob40000P00Go<P05oc40
1Ola00Go<P05ob40000P00Go<P05oc401Ola00Go<P05ob40000P00Go<P05oc401Ola00Go<P05ob40
000P00Go<P05oc401Ola00Go<P05ob40000P00Go<P05oc401Ola00Go<P05ob40000P00Go<P05oc40
1Ola00Go<P05ob40000P00Go<P05oc401Ola00Go<P05ob40000P00Go<P05oc401Ola00Go<P05ob40
000P00Go<P05oc401Ola00Go<P05ob40000P00Go<P05oc401Ola00Go<P05ob40000P00Go<P05oc40
1Ola00Go<P05ob40000P00Go<P05oc401Ola00Go<P05ob400005023o<P0koc40??lQ00001@0Poc80
>ola03co8@0000D08?lb03_o<@0lob400005023o<P0koc40??lQ00001@0Poc80>ola03co8@0008H0
0_l70003o`0008h0002?0003o`0008h00000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-2.64051, -1.05358, 
  0.0184008, 0.0119092}}]
}, Closed]],

Cell[TextData[{
  "We define compound predicate functions by using the logical functions ",
  StyleBox["And", "Input"],
  " (",
  StyleBox["&&", "Input"],
  ") and ",
  StyleBox["Or", "Input"],
  " (",
  StyleBox["||", "Input"],
  "). The following is one rule in a user-defined integration function (the \
power rule). Following the body of the definition is the compound condition \
that the exponent ",
  StyleBox["n", "Input"],
  " must be free of the variable of integration ",
  StyleBox["v", "Input"],
  ", and the exponent ",
  StyleBox["n", "Input"],
  " must not equal ",
  Cell[BoxData[
      \(TraditionalForm\`\(-1\)\)]],
  "."
}], "Text"],

Cell[BoxData[
    \(myIntegrate[v_\^n_, v_] := 
      v\^\(n + 1\)\/\(n + 1\) /; FreeQ[n, v] && n != \(-1\)\)], "Input"],

Cell[TextData[{
  "Here is a list of two results from ",
  StyleBox["myIntegrate", "Input"],
  ", the first with an argument that satisfies the compound condition, and \
the second with an argument that does not."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \({myIntegrate[x\^13, x], myIntegrate[1\/x, x]}\)], "Input"],

Cell[BoxData[
    \({x\^14\/14, myIntegrate[1\/x, x]}\)], "Output"]
}, Closed]],

Cell[TextData[{
  "See also ",
  StyleBox["SameQ", "Input"],
  ", ",
  StyleBox["UnsameQ", "Input"],
  ", ",
  StyleBox["Not", "Input"],
  ", ",
  StyleBox["Which", "Input"],
  ", ",
  StyleBox["Switch", "Input"],
  " "
}], "SeeAlso"],

Cell["Exercises: Conditions", "Exercises",
  PageBreakAbove->True],

Cell[TextData[{
  "Define a function ",
  StyleBox["uniform",
    FontFamily->"Courier"],
  " that accepts a single real argument and returns the value 1 if its \
argument is between 0 and 1, and returns 0 otherwise."
}], "Question"],

Cell[TextData[{
  "Here is the first case, when ",
  Cell[BoxData[
      \(TraditionalForm\`0 < x < 1\)]],
  "."
}], "Text"],

Cell[BoxData[
    \(uniform[x_Real] := 1 /; 0 < x < 1\)], "Input"],

Cell[TextData[{
  "Here is the second case, applicable everywhere else. It is not necessary \
to put a condition testing if ",
  StyleBox["x",
    FontSlant->"Italic"],
  " is outside the interval (0, 1) because ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " will first attempt to apply the more specific rule defined above."
}], "Text"],

Cell[BoxData[
    \(uniform[x_Real] := 0\)], "Input"],

Cell[TextData[{
  "Here is a plot of ",
  StyleBox["uniform", "Input"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(Plot[uniform[t], {t, \(-0.5\), 1.5}, 
      PlotStyle \[Rule] Thickness[0.03], AspectRatio \[Rule] Automatic]; 
    \)\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .5 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.261905 0.476191 0.0119048 0.476191 [
[.02381 -0.0006 -12 -9 ]
[.02381 -0.0006 12 0 ]
[.5 -0.0006 -9 -9 ]
[.5 -0.0006 9 0 ]
[.7381 -0.0006 -3 -9 ]
[.7381 -0.0006 3 0 ]
[.97619 -0.0006 -9 -9 ]
[.97619 -0.0006 9 0 ]
[.2494 .10714 -18 -4.5 ]
[.2494 .10714 0 4.5 ]
[.2494 .20238 -18 -4.5 ]
[.2494 .20238 0 4.5 ]
[.2494 .29762 -18 -4.5 ]
[.2494 .29762 0 4.5 ]
[.2494 .39286 -18 -4.5 ]
[.2494 .39286 0 4.5 ]
[.2494 .4881 -6 -4.5 ]
[.2494 .4881 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .5 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .0119 m
.02381 .01815 L
s
[(-0.5)] .02381 -0.0006 0 1 Mshowa
.5 .0119 m
.5 .01815 L
s
[(0.5)] .5 -0.0006 0 1 Mshowa
.7381 .0119 m
.7381 .01815 L
s
[(1)] .7381 -0.0006 0 1 Mshowa
.97619 .0119 m
.97619 .01815 L
s
[(1.5)] .97619 -0.0006 0 1 Mshowa
.125 Mabswid
.07143 .0119 m
.07143 .01565 L
s
.11905 .0119 m
.11905 .01565 L
s
.16667 .0119 m
.16667 .01565 L
s
.21429 .0119 m
.21429 .01565 L
s
.30952 .0119 m
.30952 .01565 L
s
.35714 .0119 m
.35714 .01565 L
s
.40476 .0119 m
.40476 .01565 L
s
.45238 .0119 m
.45238 .01565 L
s
.54762 .0119 m
.54762 .01565 L
s
.59524 .0119 m
.59524 .01565 L
s
.64286 .0119 m
.64286 .01565 L
s
.69048 .0119 m
.69048 .01565 L
s
.78571 .0119 m
.78571 .01565 L
s
.83333 .0119 m
.83333 .01565 L
s
.88095 .0119 m
.88095 .01565 L
s
.92857 .0119 m
.92857 .01565 L
s
.25 Mabswid
0 .0119 m
1 .0119 L
s
.2619 .10714 m
.26815 .10714 L
s
[(0.2)] .2494 .10714 1 0 Mshowa
.2619 .20238 m
.26815 .20238 L
s
[(0.4)] .2494 .20238 1 0 Mshowa
.2619 .29762 m
.26815 .29762 L
s
[(0.6)] .2494 .29762 1 0 Mshowa
.2619 .39286 m
.26815 .39286 L
s
[(0.8)] .2494 .39286 1 0 Mshowa
.2619 .4881 m
.26815 .4881 L
s
[(1)] .2494 .4881 1 0 Mshowa
.125 Mabswid
.2619 .03571 m
.26565 .03571 L
s
.2619 .05952 m
.26565 .05952 L
s
.2619 .08333 m
.26565 .08333 L
s
.2619 .13095 m
.26565 .13095 L
s
.2619 .15476 m
.26565 .15476 L
s
.2619 .17857 m
.26565 .17857 L
s
.2619 .22619 m
.26565 .22619 L
s
.2619 .25 m
.26565 .25 L
s
.2619 .27381 m
.26565 .27381 L
s
.2619 .32143 m
.26565 .32143 L
s
.2619 .34524 m
.26565 .34524 L
s
.2619 .36905 m
.26565 .36905 L
s
.2619 .41667 m
.26565 .41667 L
s
.2619 .44048 m
.26565 .44048 L
s
.2619 .46429 m
.26565 .46429 L
s
.25 Mabswid
.2619 0 m
.2619 .5 L
s
0 0 m
1 0 L
1 .5 L
0 .5 L
closepath
clip
newpath
.03 w
.02381 .0119 m
.06244 .0119 L
.10458 .0119 L
.14415 .0119 L
.18221 .0119 L
.22272 .0119 L
.24141 .0119 L
.25127 .0119 L
.25666 .0119 L
.2593 .0119 L
.26045 .0119 L
.26171 .0119 L
.26301 .4881 L
.26425 .4881 L
.26698 .4881 L
.27279 .4881 L
.28302 .4881 L
.30316 .4881 L
.3438 .4881 L
.38293 .4881 L
.42451 .4881 L
.46458 .4881 L
.50313 .4881 L
.54413 .4881 L
.58362 .4881 L
.62159 .4881 L
.66202 .4881 L
.70093 .4881 L
.7111 .4881 L
.72217 .4881 L
.72723 .4881 L
.73262 .4881 L
.73483 .4881 L
.73599 .4881 L
.73721 .4881 L
.73786 .4881 L
.73858 .0119 L
.73983 .0119 L
.74229 .0119 L
.78285 .0119 L
.82189 .0119 L
.86339 .0119 L
.90337 .0119 L
.94184 .0119 L
.97619 .0119 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 144},
  ImageMargins->{{35, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000T0P10`4000010?ooobl_;oooZZVYZNSX
j?oo05FZZZZZZ_W0RS/k>gYjN[Vi^OShn03ooeGooj[ooonI<c<c<fi^KZf][Nc/k02ZoeFZojZZoonZ
oclo?ginO[fm_Oclo5D00:X00?l00?l0VCLg=g9bL[6a/O3`l03o05Go0:[o00<30d92@X61PL30`000
EED0EJX0EOl0ELbIoc/k>gIfM[Fe]OCdm03oEEGoEJ[oE@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0Z/`c
<clo?gYjN[Vi^OShn03oZUGoZZ[oZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`<30d92@WinO[fm_Ocl
o03ooeGooj[oo`l?3di>CXf=SLc<c01E05EE0:YE0?mE00L71dI6AX61PL30`000EED00:X00?l001<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@/;2dY:BXF5QLC4a000ZUD0EJX0EOl0EALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZPl?3di>CXV9RLS8b000oeD0ZZX0Z_l0ZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEoa<C
4e9BDXf=SLc<c01E05D0ojX0ool0oalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ01LG5eIFEY6ATM3@d01E
EEEE0:YE0?mE02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZEA/K6eYJFYFEUMCDe01EZUEEEJYEEOmEEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZQlO7eiNGYVIVMSHf01EoeEEZZYEZ_mEZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZob<S8f9RHYfMWMcLg02Z05EEojYEoomEobl_;fi^KZf][Nc/k03o05Go0:[o0=gW1RLW
9fIVIZ6QXN3Ph02ZEEFZ0:ZZ0?nZ03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooEB/[:fYZJZFUYNCTi02Z
ZUFZEJZZEOnZECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l08@000?l08@0000h00_l400;o0`03ofh0
0_l400;o0`03ocH00olf00?o1002o`<00ol:00003@001?l00?l300;o1P000ol0001Z0004o`00o`<0
0_l60003o`0003@000?o0000=P000ol0000300;o1P000ol0000700001`05o`050?l00?l02`000ol0
001Z0004o`00o`/000?o0000=0000ol0000f0003o`0000/000?o00001`0000d000Co003o2003ofd0
00Co003o2003ocL000?o0000=P000ol0000800?o2P0000d000Co003o20000ol0001]0004o`00o`P0
00?o0000=`000ol0000f0003o`0000P000?o00002P0000h00_l900CoK@02o`T01?le00;o=`02o`X0
1?l90000o`0Q0000o`0Q00003`16ogP0A_l=00003`16ogP0A_l=00003`16ogP0A_l=0000303oo`_o
2P0000l0A_l90003o`0000X000?o00002@000ol0000:0003o`0000X000?o00002@000ol0000:0003
o`0000T000?o00002P000ol0000704Ko3@0000l0A_mh04Ko3@0000l0A_mh04Ko3@0004h01omh00Oo
C00004h01omh00OoC00004h01omh00OoC00004h01omh00OoC00004h01omh00OoC00004h01omh00Oo
C00004h01omh00OoC00004h01omh00OoC00004h01omh00OoC00004h01omh00OoC00004h01omh00Oo
C00004h01omh00OoC00004h01omh00OoC00004h01omh00OoC00004h01omh00OoC00004h01omh00Oo
C00004h01omh00OoC00004h01omh00OoC00004h01omh00OoC00003h00_l400;o0`04o`030?oo00Go
N007od`0000m0004o`00o`<00_l40004o`0000OoN007od`0000m0004o`00o`X000?o00001omh00Oo
C00003d000Co003o2`000ol0o`06ogP01om<0000?@001?l00?l80005o`00o`001omh00OoC00003h0
0_l:00;o0P07ogP01om<0000CP07ogP01om<0000CP07ogP01om<0000CP07ogP01om<0000CP07ogP0
1om<0000CP07ogP01om<0000CP07ogP01om<0000CP07ogP01om<0000CP07ogP01om<0000CP07ogP0
1om<0000CP07ogP01om<0000CP07ogP01om<0000CP07ogP01om<0000CP07ogP01om<0000CP07ogP0
1om<0000CP07ogP01om<0000CP07ogP01om<0000CP07ogP01om<0000CP07ogP01om<0000CP07ogP0
1om<0000?P02o`@00_l400?o00<0ool01Omh00OoC00003d000Co003o0`02o`D000?o00001omh00Oo
C00003d000Co003o2004o`030?oo00GoN007od`0000m0004o`00o`P000?o0?l00P07ogP01om<0000
?@001?l00?l80003o`3o00801omh00OoC00003h00_l:00;o0P07ogP01om<0000CP07ogP01om<0000
CP07ogP01om<0000CP07ogP01om<0000CP07ogP01om<0000CP07ogP01om<0000CP07ogP01om<0000
CP07ogP01om<0000CP08ogL01om<0000CP08ogL01om<0000CP08ogL01om<0000CP08ogL01om<0000
CP08ogL01om<0000CP08ogL01om<0000C`07ogL01om<0000C`07ogL01om<0000C`07ogL01om<0000
C`07ogL01om<0000C`07ogL01om<0000C`07ogL01om<0000C`07ogL01om<0000?P02o`@00_l400;o
0`07ogL01om<0000?@001?l00?l300;o0`001?l00?l200OoM`07od`0000m0004o`00o`P000Co003o
0P07ogL01om<0000?@001?l00?l800?o0`07ogL01om<0000?@001?l00?l80003o`0000<01omg00Oo
C00003h00_l:00?o0P07ogL01om<0000C`07ogL01om<0000C`07ogL01om<0000C`07ogL01om<0000
C`07ogL01om<0000C`07ogL01om<0000C`07ogL01om<0000C`07ogL01om<0000C`07ogL01om<0000
C`07ogL01om<0000C`07ogL01om<0000C`07ogL01om<0000C`07ogL01om<0000C`07ogL01om<0000
C`07ogL01om<0000C`07ogL01om<0000C`07ogL01om<0000C`07ogL01om<0000C`07ogL01om<0000
C`07ogL01om<0000?P02o`@00_l400;o0`07ogL01om<0000?@001?l00?l300;o0`001?l00?l200Oo
M`07od`0000m0004o`00o`P000Co003o0P07ogL01om<0000?@001?l00?l900;o0`07ogL01om<0000
?@001?l00?l80004o`00o`801omg00OoC00003h00_l:00;o0`07ogL01om<0000C`07ogL01om<0000
C`07ogL01om<0000C`07ogL01om<0000C`07ogL01om<0000C`07ogL01om<0000C`07ogL01om<0000
C`07ogL01om<0000C`07ogL01om<0000C`07ogL01om<0000C`07ogL01om<0000C`07ogL01om<0000
C`07ogL01om<0000C`07ogL01om<0000C`07ogL01om<0000C`07ogL01om<0000C`07ogL01om<0000
C`07ogL01om<0000C`07ogL01om<0000C`25od`0001900?o0`25od`0001:0003o`000080QOm<0000
BP000ol0000208GoC00004X000?o00000P25od`0001:0003o`000080QOm<0000B@02o`@0QOm<0000
o`0Q0000\
\>"],
  ImageRangeCache->{{{0, 287}, {143, 0}} -> {-0.649117, -0.0975896, 
  0.00792493, 0.00792493}}]
}, Closed]],

Cell[TextData[{
  "Note that the pattern ",
  StyleBox["x_Real", "Input"],
  " prevents ",
  StyleBox["uniform", "Input"],
  " from returning a value when given an integer or rational argument."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(uniform[1\/2]\)], "Input"],

Cell[BoxData[
    \(uniform[1\/2]\)], "Output"]
}, Closed]],

Cell[TextData[{
  "Create a piecewise function of two variables that acts differently inside \
the unit circle in the ",
  StyleBox["x",
    FontSlant->"Italic"],
  "-",
  StyleBox["y",
    FontSlant->"Italic"],
  " plane than outside."
}], "Question"],

Cell[TextData[{
  "Here is one such function, first defining the case where ",
  StyleBox["x",
    FontSlant->"Italic"],
  " and ",
  StyleBox["y",
    FontSlant->"Italic"],
  " fall inside the unit circle with the condition ",
  Cell[BoxData[
      \(Sqrt[x^2\  + \ y^2]\  < \ 1.0\)], "Input"],
  "."
}], "Text"],

Cell[BoxData[
    \(pw[x_, y_] := 1 - \((x\^2 + y\^2)\) /; Sqrt[x\^2 + y\^2] < 1.0\)], 
  "Input"],

Cell["Here is the second case.", "Text"],

Cell[BoxData[
    \(pw[x_, y_] := 0\)], "Input"],

Cell["Here is a graph of our function.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(Plot3D[pw[t, u], {t, \(-2\), 2}, {u, \(-2\), 2}, 
      PlotPoints \[Rule] 35, Mesh \[Rule] False, PlotRange \[Rule] All]; 
    \)\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .81114 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% SurfaceGraphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-1.11022e-16 1.04977 -0.0679587 1.04977 [
[.02757 .24618 -12 -8.70276 ]
[.02757 .24618 0 .29724 ]
[.17646 .18758 -11.7989 -9 ]
[.17646 .18758 .20112 0 ]
[.3345 .12542 -5.5867 -9 ]
[.3345 .12542 .4133 0 ]
[.50253 .05935 -5.27396 -9 ]
[.50253 .05935 .72604 0 ]
[.68156 -0.01098 -4.96123 -9 ]
[.68156 -0.01098 1.03877 0 ]
[.70096 -0.00478 0 -6.26206 ]
[.70096 -0.00478 12 2.73794 ]
[.78313 .12104 0 -6.13858 ]
[.78313 .12104 12 2.86142 ]
[.8565 .23339 0 -6.03127 ]
[.8565 .23339 6 2.96873 ]
[.9224 .33431 0 -5.93715 ]
[.9224 .33431 6 3.06285 ]
[.98191 .42546 0 -5.85393 ]
[.98191 .42546 6 3.14607 ]
[.02411 .26511 -6 -2.74232 ]
[.02411 .26511 0 6.25768 ]
[.01568 .31795 -24 -2.78699 ]
[.01568 .31795 0 6.21301 ]
[.00696 .37264 -18 -2.83339 ]
[.00696 .37264 0 6.16661 ]
[-0.00208 .42927 -24 -2.88161 ]
[-0.00208 .42927 0 6.11839 ]
[-0.01144 .48795 -6 -2.93176 ]
[-0.01144 .48795 0 6.06824 ]
[ 0 0 0 0 ]
[ 1 .81114 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.03716 .25514 m
.68874 0 L
s
.03716 .25514 m
.04196 .25962 L
s
[(-2)] .02757 .24618 1 .93395 Mshowa
.18558 .19702 m
.19014 .20174 L
s
[(-1)] .17646 .18758 .96648 1 Mshowa
.34306 .13535 m
.34735 .14032 L
s
[(0)] .3345 .12542 .86223 1 Mshowa
.51046 .06981 m
.51442 .07504 L
s
[(1)] .50253 .05935 .75799 1 Mshowa
.68874 0 m
.69233 .00549 L
s
[(2)] .68156 -0.01098 .65374 1 Mshowa
.125 Mabswid
.06616 .24378 m
.06901 .2465 L
s
.09549 .2323 m
.09832 .23504 L
s
.12517 .22067 m
.12797 .22345 L
s
.1552 .20892 m
.15797 .21172 L
s
.21633 .18498 m
.21903 .18784 L
s
.24744 .1728 m
.25012 .17569 L
s
.27893 .16047 m
.28157 .16339 L
s
.3108 .14799 m
.31341 .15094 L
s
.37572 .12257 m
.37826 .12558 L
s
.40878 .10962 m
.41128 .11266 L
s
.44225 .09652 m
.44471 .09959 L
s
.47614 .08324 m
.47856 .08635 L
s
.54521 .0562 m
.54755 .05937 L
s
.58041 .04242 m
.5827 .04562 L
s
.61605 .02846 m
.6183 .03169 L
s
.65216 .01432 m
.65436 .01759 L
s
.25 Mabswid
.68874 0 m
.96935 .42924 L
s
.68874 0 m
.68263 .00239 L
s
[(-2)] .70096 -0.00478 -1 .39157 Mshowa
.7708 .12553 m
.76464 .12778 L
s
[(-1)] .78313 .12104 -1 .36413 Mshowa
.84407 .23761 m
.83786 .23973 L
s
[(0)] .8565 .23339 -1 .34028 Mshowa
.9099 .3383 m
.90365 .34029 L
s
[(1)] .9224 .33431 -1 .31937 Mshowa
.96935 .42924 m
.96306 .43113 L
s
[(2)] .98191 .42546 -1 .30087 Mshowa
.125 Mabswid
.70593 .0263 m
.70226 .02771 L
s
.72272 .05198 m
.71904 .05338 L
s
.73912 .07706 m
.73543 .07845 L
s
.75514 .10158 m
.75145 .10294 L
s
.78611 .14895 m
.78241 .15028 L
s
.80108 .17185 m
.79737 .17317 L
s
.81573 .19425 m
.81201 .19555 L
s
.83006 .21617 m
.82633 .21745 L
s
.8578 .2586 m
.85407 .25986 L
s
.87123 .27915 m
.8675 .28039 L
s
.88439 .29928 m
.88065 .3005 L
s
.89727 .31899 m
.89353 .3202 L
s
.92227 .35722 m
.91851 .3584 L
s
.93439 .37576 m
.93063 .37693 L
s
.94627 .39394 m
.94251 .3951 L
s
.95792 .41176 m
.95416 .41291 L
s
.25 Mabswid
.03716 .25514 m
0 .48963 L
s
.03634 .26033 m
.04245 .25795 L
s
[(0)] .02411 .26511 1 -0.3906 Mshowa
.02795 .31328 m
.03408 .31095 L
s
[(0.25)] .01568 .31795 1 -0.38067 Mshowa
.01926 .36808 m
.02541 .3658 L
s
[(0.5)] .00696 .37264 1 -0.37036 Mshowa
.01027 .42483 m
.01644 .42261 L
s
[(0.75)] -0.00208 .42927 1 -0.35964 Mshowa
.00095 .48363 m
.00715 .48147 L
s
[(1)] -0.01144 .48795 1 -0.3485 Mshowa
.125 Mabswid
.03468 .27078 m
.03835 .26935 L
s
.03301 .2813 m
.03669 .27988 L
s
.03134 .29189 m
.03501 .29047 L
s
.02965 .30255 m
.03332 .30114 L
s
.02623 .32409 m
.02991 .3227 L
s
.02451 .33497 m
.02819 .33359 L
s
.02277 .34593 m
.02646 .34455 L
s
.02102 .35697 m
.02471 .35559 L
s
.01749 .37927 m
.02118 .37791 L
s
.0157 .39054 m
.0194 .38919 L
s
.0139 .40189 m
.0176 .40054 L
s
.01209 .41332 m
.01579 .41198 L
s
.00843 .43642 m
.01214 .4351 L
s
.00658 .4481 m
.01029 .44678 L
s
.00472 .45986 m
.00843 .45855 L
s
.00284 .4717 m
.00656 .4704 L
s
.25 Mabswid
.03716 .25514 m
0 .48963 L
s
0 .48963 m
.39787 .81114 L
s
.39787 .81114 m
.40529 .59895 L
s
.40529 .59895 m
.03716 .25514 L
s
.68874 0 m
.96935 .42924 L
s
.96935 .42924 m
1 .6535 L
s
1 .6535 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.03716 .25514 m
0 .48963 L
s
0 .48963 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.68874 0 m
.03716 .25514 L
s
.40529 .59895 m
.96935 .42924 L
s
.96935 .42924 m
1 .6535 L
s
1 .6535 m
.39787 .81114 L
s
.39787 .81114 m
.40529 .59895 L
s
0 0 m
1 0 L
1 .81114 L
0 .81114 L
closepath
clip
newpath
.664 .741 .908 r
.39613 .59534 .40512 .60371 .4202 .59919 .41126 .59077 Mtetra
.41126 .59077 .4202 .59919 .43536 .59464 .42648 .58617 Mtetra
.42648 .58617 .43536 .59464 .45061 .59007 .44178 .58155 Mtetra
.44178 .58155 .45061 .59007 .46595 .58547 .45717 .5769 Mtetra
.45717 .5769 .46595 .58547 .48137 .58084 .47265 .57223 Mtetra
.47265 .57223 .48137 .58084 .49688 .57619 .48822 .56753 Mtetra
.48822 .56753 .49688 .57619 .51248 .57151 .50387 .5628 Mtetra
.50387 .5628 .51248 .57151 .52816 .5668 .51962 .55804 Mtetra
.51962 .55804 .52816 .5668 .54394 .56207 .53545 .55326 Mtetra
.53545 .55326 .54394 .56207 .55981 .55731 .55138 .54845 Mtetra
.55138 .54845 .55981 .55731 .57577 .55252 .5674 .54361 Mtetra
.5674 .54361 .57577 .55252 .59182 .5477 .58352 .53874 Mtetra
.58352 .53874 .59182 .5477 .60796 .54286 .59972 .53385 Mtetra
.59972 .53385 .60796 .54286 .6242 .53799 .61602 .52892 Mtetra
.61602 .52892 .6242 .53799 .64053 .53309 .63242 .52397 Mtetra
.63242 .52397 .64053 .53309 .65696 .52816 .64892 .51899 Mtetra
.64892 .51899 .65696 .52816 .67349 .5232 .66551 .51397 Mtetra
.66551 .51397 .67349 .5232 .69011 .51822 .6822 .50893 Mtetra
.6822 .50893 .69011 .51822 .70683 .5132 .69899 .50386 Mtetra
.69899 .50386 .70683 .5132 .72365 .50815 .71587 .49876 Mtetra
.71587 .49876 .72365 .50815 .74057 .50308 .73286 .49363 Mtetra
.73286 .49363 .74057 .50308 .75759 .49797 .74996 .48847 Mtetra
.74996 .48847 .75759 .49797 .77471 .49284 .76715 .48327 Mtetra
.76715 .48327 .77471 .49284 .79194 .48767 .78445 .47805 Mtetra
.78445 .47805 .79194 .48767 .80926 .48247 .80185 .47279 Mtetra
.80185 .47279 .80926 .48247 .8267 .47724 .81936 .4675 Mtetra
.81936 .4675 .8267 .47724 .84423 .47198 .83697 .46218 Mtetra
.83697 .46218 .84423 .47198 .86188 .46669 .85469 .45683 Mtetra
.85469 .45683 .86188 .46669 .87963 .46136 .87252 .45144 Mtetra
.87252 .45144 .87963 .46136 .89749 .456 .89046 .44603 Mtetra
.89046 .44603 .89749 .456 .91546 .45061 .90851 .44057 Mtetra
.90851 .44057 .91546 .45061 .93354 .44519 .92667 .43509 Mtetra
.92667 .43509 .93354 .44519 .95173 .43973 .94494 .42957 Mtetra
.94494 .42957 .95173 .43973 .97003 .43424 .96333 .42401 Mtetra
.38705 .58688 .39613 .59534 .41126 .59077 .40223 .58227 Mtetra
.40223 .58227 .41126 .59077 .42648 .58617 .4175 .57762 Mtetra
.4175 .57762 .42648 .58617 .44178 .58155 .43286 .57295 Mtetra
.43286 .57295 .44178 .58155 .45717 .5769 .44831 .56825 Mtetra
.44831 .56825 .45717 .5769 .47265 .57223 .46384 .56353 Mtetra
.46384 .56353 .47265 .57223 .48822 .56753 .47947 .55878 Mtetra
.47947 .55878 .48822 .56753 .50387 .5628 .49518 .554 Mtetra
.49518 .554 .50387 .5628 .51962 .55804 .51098 .54919 Mtetra
.51098 .54919 .51962 .55804 .53545 .55326 .52688 .54435 Mtetra
.52688 .54435 .53545 .55326 .55138 .54845 .54287 .53949 Mtetra
.54287 .53949 .55138 .54845 .5674 .54361 .55895 .5346 Mtetra
.55895 .5346 .5674 .54361 .58352 .53874 .57512 .52968 Mtetra
.57512 .52968 .58352 .53874 .59972 .53385 .59139 .52473 Mtetra
.59139 .52473 .59972 .53385 .61602 .52892 .60776 .51975 Mtetra
.60776 .51975 .61602 .52892 .63242 .52397 .62422 .51475 Mtetra
.62422 .51475 .63242 .52397 .64892 .51899 .64078 .50971 Mtetra
.64078 .50971 .64892 .51899 .66551 .51397 .65744 .50464 Mtetra
.65744 .50464 .66551 .51397 .6822 .50893 .6742 .49955 Mtetra
.6742 .49955 .6822 .50893 .69899 .50386 .69106 .49442 Mtetra
.69106 .49442 .69899 .50386 .71587 .49876 .70801 .48926 Mtetra
.70801 .48926 .71587 .49876 .73286 .49363 .72507 .48407 Mtetra
.72507 .48407 .73286 .49363 .74996 .48847 .74224 .47885 Mtetra
.74224 .47885 .74996 .48847 .76715 .48327 .7595 .4736 Mtetra
.7595 .4736 .76715 .48327 .78445 .47805 .77687 .46832 Mtetra
.77687 .46832 .78445 .47805 .80185 .47279 .79435 .463 Mtetra
.79435 .463 .80185 .47279 .81936 .4675 .81193 .45766 Mtetra
.81193 .45766 .81936 .4675 .83697 .46218 .82962 .45227 Mtetra
.82962 .45227 .83697 .46218 .85469 .45683 .84742 .44686 Mtetra
.84742 .44686 .85469 .45683 .87252 .45144 .86533 .44141 Mtetra
.86533 .44141 .87252 .45144 .89046 .44603 .88335 .43593 Mtetra
.88335 .43593 .89046 .44603 .90851 .44057 .90148 .43042 Mtetra
.90148 .43042 .90851 .44057 .92667 .43509 .91972 .42487 Mtetra
.91972 .42487 .92667 .43509 .94494 .42957 .93808 .41929 Mtetra
.93808 .41929 .94494 .42957 .96333 .42401 .95655 .41367 Mtetra
.37787 .57834 .38705 .58688 .40223 .58227 .39311 .57367 Mtetra
.39311 .57367 .40223 .58227 .4175 .57762 .40843 .56898 Mtetra
.40843 .56898 .4175 .57762 .43286 .57295 .42385 .56426 Mtetra
.42385 .56426 .43286 .57295 .44831 .56825 .43935 .55951 Mtetra
.43935 .55951 .44831 .56825 .46384 .56353 .45494 .55473 Mtetra
.45494 .55473 .46384 .56353 .47947 .55878 .47062 .54993 Mtetra
.47062 .54993 .47947 .55878 .49518 .554 .48639 .5451 Mtetra
.48639 .5451 .49518 .554 .51098 .54919 .50226 .54024 Mtetra
.50226 .54024 .51098 .54919 .52688 .54435 .51821 .53535 Mtetra
.51821 .53535 .52688 .54435 .54287 .53949 .53426 .53044 Mtetra
.53426 .53044 .54287 .53949 .55895 .5346 .5504 .5255 Mtetra
.5504 .5255 .55895 .5346 .57512 .52968 .56664 .52052 Mtetra
.56664 .52052 .57512 .52968 .59139 .52473 .58298 .51552 Mtetra
.58298 .51552 .59139 .52473 .60776 .51975 .59941 .51049 Mtetra
.59941 .51049 .60776 .51975 .62422 .51475 .61593 .50543 Mtetra
.61593 .50543 .62422 .51475 .64078 .50971 .63256 .50033 Mtetra
.63256 .50033 .64078 .50971 .65744 .50464 .64929 .49521 Mtetra
.64929 .49521 .65744 .50464 .6742 .49955 .66611 .49006 Mtetra
.66611 .49006 .6742 .49955 .69106 .49442 .68304 .48487 Mtetra
.68304 .48487 .69106 .49442 .70801 .48926 .70007 .47966 Mtetra
.70007 .47966 .70801 .48926 .72507 .48407 .7172 .47441 Mtetra
.7172 .47441 .72507 .48407 .74224 .47885 .73443 .46913 Mtetra
.73443 .46913 .74224 .47885 .7595 .4736 .75177 .46382 Mtetra
.75177 .46382 .7595 .4736 .77687 .46832 .76922 .45848 Mtetra
.76922 .45848 .77687 .46832 .79435 .463 .78677 .4531 Mtetra
.78677 .4531 .79435 .463 .81193 .45766 .80443 .4477 Mtetra
.80443 .4477 .81193 .45766 .82962 .45227 .8222 .44225 Mtetra
.8222 .44225 .82962 .45227 .84742 .44686 .84007 .43678 Mtetra
.84007 .43678 .84742 .44686 .86533 .44141 .85806 .43127 Mtetra
.85806 .43127 .86533 .44141 .88335 .43593 .87616 .42573 Mtetra
.87616 .42573 .88335 .43593 .90148 .43042 .89437 .42015 Mtetra
.89437 .42015 .90148 .43042 .91972 .42487 .9127 .41454 Mtetra
.9127 .41454 .91972 .42487 .93808 .41929 .93114 .40889 Mtetra
.93114 .40889 .93808 .41929 .95655 .41367 .9497 .40321 Mtetra
.36859 .5697 .37787 .57834 .39311 .57367 .38389 .56498 Mtetra
.38389 .56498 .39311 .57367 .40843 .56898 .39927 .56024 Mtetra
.39927 .56024 .40843 .56898 .42385 .56426 .41473 .55547 Mtetra
.41473 .55547 .42385 .56426 .43935 .55951 .43029 .55067 Mtetra
.43029 .55067 .43935 .55951 .45494 .55473 .44594 .54584 Mtetra
.44594 .54584 .45494 .55473 .47062 .54993 .46168 .54099 Mtetra
.46168 .54099 .47062 .54993 .48639 .5451 .47751 .53611 Mtetra
.47751 .53611 .48639 .5451 .50226 .54024 .49343 .5312 Mtetra
.49343 .5312 .50226 .54024 .51821 .53535 .50945 .52626 Mtetra
.50945 .52626 .51821 .53535 .53426 .53044 .52556 .52129 Mtetra
.52556 .52129 .53426 .53044 .5504 .5255 .54177 .51629 Mtetra
.54177 .51629 .5504 .5255 .56664 .52052 .55807 .51126 Mtetra
.55807 .51126 .56664 .52052 .58298 .51552 .57446 .50621 Mtetra
.57446 .50621 .58298 .51552 .59941 .51049 .59096 .50112 Mtetra
.59096 .50112 .59941 .51049 .61593 .50543 .60755 .496 Mtetra
.60755 .496 .61593 .50543 .63256 .50033 .62425 .49085 Mtetra
.62425 .49085 .63256 .50033 .64929 .49521 .64104 .48567 Mtetra
.64104 .48567 .64929 .49521 .66611 .49006 .65793 .48046 Mtetra
.65793 .48046 .66611 .49006 .68304 .48487 .67493 .47522 Mtetra
.67493 .47522 .68304 .48487 .70007 .47966 .69203 .46995 Mtetra
.69203 .46995 .70007 .47966 .7172 .47441 .70923 .46464 Mtetra
.70923 .46464 .7172 .47441 .73443 .46913 .72654 .4593 Mtetra
.72654 .4593 .73443 .46913 .75177 .46382 .74395 .45393 Mtetra
.74395 .45393 .75177 .46382 .76922 .45848 .76147 .44853 Mtetra
.76147 .44853 .76922 .45848 .78677 .4531 .7791 .44309 Mtetra
.7791 .44309 .78677 .4531 .80443 .4477 .79684 .43762 Mtetra
.79684 .43762 .80443 .4477 .8222 .44225 .81468 .43212 Mtetra
.81468 .43212 .8222 .44225 .84007 .43678 .83264 .42658 Mtetra
.83264 .42658 .84007 .43678 .85806 .43127 .85071 .42101 Mtetra
.85071 .42101 .85806 .43127 .87616 .42573 .86889 .4154 Mtetra
.86889 .4154 .87616 .42573 .89437 .42015 .88718 .40976 Mtetra
.88718 .40976 .89437 .42015 .9127 .41454 .90559 .40408 Mtetra
.90559 .40408 .9127 .41454 .93114 .40889 .92412 .39837 Mtetra
.92412 .39837 .93114 .40889 .9497 .40321 .94276 .39262 Mtetra
.35922 .56097 .36859 .5697 .38389 .56498 .37457 .55621 Mtetra
.37457 .55621 .38389 .56498 .39927 .56024 .39 .55141 Mtetra
.39 .55141 .39927 .56024 .41473 .55547 .40553 .54659 Mtetra
.40553 .54659 .41473 .55547 .43029 .55067 .42114 .54174 Mtetra
.42114 .54174 .43029 .55067 .44594 .54584 .43685 .53686 Mtetra
.43685 .53686 .44594 .54584 .46168 .54099 .45264 .53195 Mtetra
.45264 .53195 .46168 .54099 .47751 .53611 .46853 .52702 Mtetra
.46853 .52702 .47751 .53611 .49343 .5312 .48452 .52206 Mtetra
.48452 .52206 .49343 .5312 .50945 .52626 .50059 .51706 Mtetra
.50059 .51706 .50945 .52626 .52556 .52129 .51676 .51204 Mtetra
.51676 .51204 .52556 .52129 .54177 .51629 .53303 .50699 Mtetra
.53303 .50699 .54177 .51629 .55807 .51126 .5494 .5019 Mtetra
.5494 .5019 .55807 .51126 .57446 .50621 .56586 .49679 Mtetra
.56586 .49679 .57446 .50621 .59096 .50112 .58242 .49165 Mtetra
.58242 .49165 .59096 .50112 .60755 .496 .59908 .48647 Mtetra
.59908 .48647 .60755 .496 .62425 .49085 .61584 .48127 Mtetra
.61584 .48127 .62425 .49085 .64104 .48567 .6327 .47603 Mtetra
.6327 .47603 .64104 .48567 .65793 .48046 .64966 .47076 Mtetra
.64966 .47076 .65793 .48046 .67493 .47522 .66673 .46546 Mtetra
.66673 .46546 .67493 .47522 .69203 .46995 .6839 .46013 Mtetra
.6839 .46013 .69203 .46995 .70923 .46464 .70118 .45476 Mtetra
.70118 .45476 .70923 .46464 .72654 .4593 .71856 .44936 Mtetra
.71856 .44936 .72654 .4593 .74395 .45393 .73604 .44393 Mtetra
.73604 .44393 .74395 .45393 .76147 .44853 .75364 .43847 Mtetra
.75364 .43847 .76147 .44853 .7791 .44309 .77134 .43297 Mtetra
.77134 .43297 .7791 .44309 .79684 .43762 .78916 .42744 Mtetra
.78916 .42744 .79684 .43762 .81468 .43212 .80708 .42187 Mtetra
.80708 .42187 .81468 .43212 .83264 .42658 .82512 .41627 Mtetra
.82512 .41627 .83264 .42658 .85071 .42101 .84327 .41063 Mtetra
.84327 .41063 .85071 .42101 .86889 .4154 .86153 .40496 Mtetra
.86153 .40496 .86889 .4154 .88718 .40976 .87991 .39925 Mtetra
.87991 .39925 .88718 .40976 .90559 .40408 .8984 .39351 Mtetra
.8984 .39351 .90559 .40408 .92412 .39837 .91701 .38772 Mtetra
.91701 .38772 .92412 .39837 .94276 .39262 .93574 .38191 Mtetra
.34974 .55215 .35922 .56097 .37457 .55621 .36515 .54733 Mtetra
.36515 .54733 .37457 .55621 .39 .55141 .38064 .54249 Mtetra
.38064 .54249 .39 .55141 .40553 .54659 .39622 .53761 Mtetra
.39622 .53761 .40553 .54659 .42114 .54174 .41189 .53271 Mtetra
.41189 .53271 .42114 .54174 .43685 .53686 .42765 .52778 Mtetra
.42765 .52778 .43685 .53686 .45264 .53195 .44351 .52282 Mtetra
.44351 .52282 .45264 .53195 .46853 .52702 .45946 .51783 Mtetra
.45946 .51783 .46853 .52702 .48452 .52206 .4755 .51281 Mtetra
.4755 .51281 .48452 .52206 .50059 .51706 .49164 .50777 Mtetra
.49164 .50777 .50059 .51706 .51676 .51204 .50787 .50269 Mtetra
.50787 .50269 .51676 .51204 .53303 .50699 .5242 .49758 Mtetra
.5242 .49758 .53303 .50699 .5494 .5019 .54063 .49244 Mtetra
.54063 .49244 .5494 .5019 .56586 .49679 .55716 .48727 Mtetra
.55716 .48727 .56586 .49679 .58242 .49165 .57379 .48207 Mtetra
.57379 .48207 .58242 .49165 .59908 .48647 .59051 .47684 Mtetra
.59051 .47684 .59908 .48647 .61584 .48127 .60734 .47157 Mtetra
.60734 .47157 .61584 .48127 .6327 .47603 .62427 .46628 Mtetra
.62427 .46628 .6327 .47603 .64966 .47076 .6413 .46095 Mtetra
.6413 .46095 .64966 .47076 .66673 .46546 .65844 .45559 Mtetra
.65844 .45559 .66673 .46546 .6839 .46013 .67568 .4502 Mtetra
.67568 .4502 .6839 .46013 .70118 .45476 .69303 .44477 Mtetra
.69303 .44477 .70118 .45476 .71856 .44936 .71048 .43931 Mtetra
.71048 .43931 .71856 .44936 .73604 .44393 .72805 .43382 Mtetra
.72805 .43382 .73604 .44393 .75364 .43847 .74572 .42829 Mtetra
.74572 .42829 .75364 .43847 .77134 .43297 .7635 .42273 Mtetra
.7635 .42273 .77134 .43297 .78916 .42744 .78139 .41713 Mtetra
.78139 .41713 .78916 .42744 .80708 .42187 .79939 .4115 Mtetra
.79939 .4115 .80708 .42187 .82512 .41627 .81751 .40583 Mtetra
.81751 .40583 .82512 .41627 .84327 .41063 .83574 .40013 Mtetra
.83574 .40013 .84327 .41063 .86153 .40496 .85409 .39439 Mtetra
.85409 .39439 .86153 .40496 .87991 .39925 .87255 .38862 Mtetra
.87255 .38862 .87991 .39925 .8984 .39351 .89113 .3828 Mtetra
.89113 .3828 .8984 .39351 .91701 .38772 .90982 .37696 Mtetra
.90982 .37696 .91701 .38772 .93574 .38191 .92864 .37107 Mtetra
.34017 .54323 .34974 .55215 .36515 .54733 .35563 .53837 Mtetra
.35563 .53837 .36515 .54733 .38064 .54249 .37117 .53347 Mtetra
.37117 .53347 .38064 .54249 .39622 .53761 .38681 .52854 Mtetra
.38681 .52854 .39622 .53761 .41189 .53271 .40254 .52359 Mtetra
.40254 .52359 .41189 .53271 .42765 .52778 .41836 .5186 Mtetra
.41836 .5186 .42765 .52778 .44351 .52282 .43427 .51359 Mtetra
.43427 .51359 .44351 .52282 .45946 .51783 .45028 .50854 Mtetra
.45028 .50854 .45946 .51783 .4755 .51281 .46639 .50347 Mtetra
.46639 .50347 .4755 .51281 .49164 .50777 .48259 .49837 Mtetra
.48259 .49837 .49164 .50777 .50787 .50269 .49888 .49323 Mtetra
.49888 .49323 .50787 .50269 .5242 .49758 .51528 .48807 Mtetra
.51528 .48807 .5242 .49758 .54063 .49244 .53177 .48287 Mtetra
.53177 .48287 .54063 .49244 .55716 .48727 .54836 .47764 Mtetra
.54836 .47764 .55716 .48727 .57379 .48207 .56506 .47239 Mtetra
.56506 .47239 .57379 .48207 .59051 .47684 .58185 .46709 Mtetra
.58185 .46709 .59051 .47684 .60734 .47157 .59875 .46177 Mtetra
.59875 .46177 .60734 .47157 .62427 .46628 .61574 .45642 Mtetra
.61574 .45642 .62427 .46628 .6413 .46095 .63285 .45103 Mtetra
.63285 .45103 .6413 .46095 .65844 .45559 .65005 .44561 Mtetra
.65005 .44561 .65844 .45559 .67568 .4502 .66737 .44015 Mtetra
.66737 .44015 .67568 .4502 .69303 .44477 .68479 .43466 Mtetra
.68479 .43466 .69303 .44477 .71048 .43931 .70232 .42914 Mtetra
.70232 .42914 .71048 .43931 .72805 .43382 .71996 .42359 Mtetra
.71996 .42359 .72805 .43382 .74572 .42829 .7377 .41799 Mtetra
.7377 .41799 .74572 .42829 .7635 .42273 .75556 .41237 Mtetra
.75556 .41237 .7635 .42273 .78139 .41713 .77353 .40671 Mtetra
.77353 .40671 .78139 .41713 .79939 .4115 .79162 .40101 Mtetra
.79162 .40101 .79939 .4115 .81751 .40583 .80981 .39528 Mtetra
.80981 .39528 .81751 .40583 .83574 .40013 .82813 .38951 Mtetra
.82813 .38951 .83574 .40013 .85409 .39439 .84656 .3837 Mtetra
.84656 .3837 .85409 .39439 .87255 .38862 .8651 .37786 Mtetra
.8651 .37786 .87255 .38862 .89113 .3828 .88377 .37198 Mtetra
.88377 .37198 .89113 .3828 .90982 .37696 .90255 .36606 Mtetra
.90255 .36606 .90982 .37696 .92864 .37107 .92146 .3601 Mtetra
.33049 .53422 .34017 .54323 .35563 .53837 .346 .5293 Mtetra
.346 .5293 .35563 .53837 .37117 .53347 .3616 .52435 Mtetra
.3616 .52435 .37117 .53347 .38681 .52854 .3773 .51937 Mtetra
.3773 .51937 .38681 .52854 .40254 .52359 .39308 .51436 Mtetra
.39308 .51436 .40254 .52359 .41836 .5186 .40896 .50932 Mtetra
.40896 .50932 .41836 .5186 .43427 .51359 .42494 .50425 Mtetra
.42494 .50425 .43427 .51359 .45028 .50854 .44101 .49915 Mtetra
.44101 .49915 .45028 .50854 .46639 .50347 .45717 .49402 Mtetra
.45717 .49402 .46639 .50347 .48259 .49837 .47343 .48886 Mtetra
.47343 .48886 .48259 .49837 .49888 .49323 .48979 .48367 Mtetra
.48979 .48367 .49888 .49323 .51528 .48807 .50625 .47845 Mtetra
.50625 .47845 .51528 .48807 .53177 .48287 .52281 .4732 Mtetra
.52281 .4732 .53177 .48287 .54836 .47764 .53947 .46791 Mtetra
.53947 .46791 .54836 .47764 .56506 .47239 .55623 .46259 Mtetra
.55623 .46259 .56506 .47239 .58185 .46709 .57309 .45724 Mtetra
.57309 .45724 .58185 .46709 .59875 .46177 .59005 .45186 Mtetra
.59005 .45186 .59875 .46177 .61574 .45642 .60712 .44644 Mtetra
.60712 .44644 .61574 .45642 .63285 .45103 .62429 .44099 Mtetra
.62429 .44099 .63285 .45103 .65005 .44561 .64157 .43551 Mtetra
.64157 .43551 .65005 .44561 .66737 .44015 .65896 .42999 Mtetra
.65896 .42999 .66737 .44015 .68479 .43466 .67646 .42444 Mtetra
.67646 .42444 .68479 .43466 .70232 .42914 .69406 .41886 Mtetra
.69406 .41886 .70232 .42914 .71996 .42359 .71177 .41324 Mtetra
.71177 .41324 .71996 .42359 .7377 .41799 .7296 .40758 Mtetra
.7296 .40758 .7377 .41799 .75556 .41237 .74753 .40189 Mtetra
.74753 .40189 .75556 .41237 .77353 .40671 .76558 .39616 Mtetra
.76558 .39616 .77353 .40671 .79162 .40101 .78375 .3904 Mtetra
.78375 .3904 .79162 .40101 .80981 .39528 .80203 .3846 Mtetra
.80203 .3846 .80981 .39528 .82813 .38951 .82042 .37876 Mtetra
.82042 .37876 .82813 .38951 .84656 .3837 .83894 .37289 Mtetra
.83894 .37289 .84656 .3837 .8651 .37786 .85757 .36697 Mtetra
.85757 .36697 .8651 .37786 .88377 .37198 .87632 .36102 Mtetra
.87632 .36102 .88377 .37198 .90255 .36606 .89519 .35503 Mtetra
.89519 .35503 .90255 .36606 .92146 .3601 .91419 .34901 Mtetra
.32071 .52511 .33049 .53422 .346 .5293 .33627 .52014 Mtetra
.33627 .52014 .346 .5293 .3616 .52435 .35193 .51513 Mtetra
.35193 .51513 .3616 .52435 .3773 .51937 .36768 .5101 Mtetra
.36768 .5101 .3773 .51937 .39308 .51436 .38353 .50503 Mtetra
.38353 .50503 .39308 .51436 .40896 .50932 .39947 .49994 Mtetra
.39947 .49994 .40896 .50932 .42494 .50425 .4155 .49482 Mtetra
.4155 .49482 .42494 .50425 .44101 .49915 .43163 .48966 Mtetra
.43163 .48966 .44101 .49915 .45717 .49402 .44786 .48447 Mtetra
.44786 .48447 .45717 .49402 .47343 .48886 .46418 .47926 Mtetra
.46418 .47926 .47343 .48886 .48979 .48367 .4806 .47401 Mtetra
.4806 .47401 .48979 .48367 .50625 .47845 .49713 .46873 Mtetra
.49713 .46873 .50625 .47845 .52281 .4732 .51375 .46341 Mtetra
.51375 .46341 .52281 .4732 .53947 .46791 .53047 .45807 Mtetra
.53047 .45807 .53947 .46791 .55623 .46259 .5473 .45269 Mtetra
.196 .514 .914 r
.5473 .45269 .55623 .46259 .57309 .45724 .56437 .45907 Mtetra
.327 0 0 r
.56437 .45907 .57309 .45724 .59005 .45186 .58161 .46203 Mtetra
.337 0 0 r
.58161 .46203 .59005 .45186 .60712 .44644 .59892 .45939 Mtetra
.2 0 0 r
.59892 .45939 .60712 .44644 .62429 .44099 .61621 .4511 Mtetra
0 0 0 r
.61621 .4511 .62429 .44099 .64157 .43551 .63339 .43716 Mtetra
.837 .999 .819 r
.63339 .43716 .64157 .43551 .65896 .42999 .65046 .41972 Mtetra
.664 .741 .908 r
.65046 .41972 .65896 .42999 .67646 .42444 .66803 .4141 Mtetra
.66803 .4141 .67646 .42444 .69406 .41886 .6857 .40845 Mtetra
.6857 .40845 .69406 .41886 .71177 .41324 .70349 .40277 Mtetra
.70349 .40277 .71177 .41324 .7296 .40758 .7214 .39704 Mtetra
.7214 .39704 .7296 .40758 .74753 .40189 .73941 .39129 Mtetra
.73941 .39129 .74753 .40189 .76558 .39616 .75754 .38549 Mtetra
.75754 .38549 .76558 .39616 .78375 .3904 .77579 .37966 Mtetra
.77579 .37966 .78375 .3904 .80203 .3846 .79415 .37379 Mtetra
.79415 .37379 .80203 .3846 .82042 .37876 .81263 .36789 Mtetra
.81263 .36789 .82042 .37876 .83894 .37289 .83123 .36194 Mtetra
.83123 .36194 .83894 .37289 .85757 .36697 .84994 .35596 Mtetra
.84994 .35596 .85757 .36697 .87632 .36102 .86878 .34994 Mtetra
.86878 .34994 .87632 .36102 .89519 .35503 .88774 .34388 Mtetra
.88774 .34388 .89519 .35503 .91419 .34901 .90683 .33778 Mtetra
.31082 .51591 .32071 .52511 .33627 .52014 .32644 .51088 Mtetra
.32644 .51088 .33627 .52014 .35193 .51513 .34216 .50582 Mtetra
.34216 .50582 .35193 .51513 .36768 .5101 .35796 .50073 Mtetra
.35796 .50073 .36768 .5101 .38353 .50503 .37387 .49561 Mtetra
.37387 .49561 .38353 .50503 .39947 .49994 .38986 .49046 Mtetra
.38986 .49046 .39947 .49994 .4155 .49482 .40596 .48527 Mtetra
.40596 .48527 .4155 .49482 .43163 .48966 .42215 .48006 Mtetra
.42215 .48006 .43163 .48966 .44786 .48447 .43844 .47482 Mtetra
.43844 .47482 .44786 .48447 .46418 .47926 .45482 .46954 Mtetra
.45482 .46954 .46418 .47926 .4806 .47401 .47131 .46423 Mtetra
.47131 .46423 .4806 .47401 .49713 .46873 .4879 .45889 Mtetra
.4879 .45889 .49713 .46873 .51375 .46341 .50459 .45352 Mtetra
0 .118 .629 r
.50459 .45352 .51375 .46341 .53047 .45807 .52135 .46828 Mtetra
.694 .27 .234 r
.52135 .46828 .53047 .45807 .5473 .45269 .53843 .4826 Mtetra
.604 .273 .383 r
.53843 .4826 .5473 .45269 .56437 .45907 .55577 .49145 Mtetra
.555 .232 .377 r
.55577 .49145 .56437 .45907 .58161 .46203 .57329 .49465 Mtetra
.498 .18 .359 r
.57329 .49465 .58161 .46203 .59892 .45939 .59089 .49209 Mtetra
.43 .12 .336 r
.59089 .49209 .59892 .45939 .61621 .4511 .60849 .48372 Mtetra
.351 .051 .309 r
.60849 .48372 .61621 .4511 .63339 .43716 .626 .46953 Mtetra
.259 0 .276 r
.626 .46953 .63339 .43716 .65046 .41972 .64331 .44959 Mtetra
.118 0 .209 r
.64331 .44959 .65046 .41972 .66803 .4141 .66035 .42404 Mtetra
.693 .871 .476 r
.66035 .42404 .66803 .4141 .6857 .40845 .67725 .39793 Mtetra
.664 .741 .908 r
.67725 .39793 .6857 .40845 .70349 .40277 .69512 .39217 Mtetra
.69512 .39217 .70349 .40277 .7214 .39704 .7131 .38639 Mtetra
.7131 .38639 .7214 .39704 .73941 .39129 .73119 .38056 Mtetra
.73119 .38056 .73941 .39129 .75754 .38549 .74941 .3747 Mtetra
.74941 .3747 .75754 .38549 .77579 .37966 .76773 .3688 Mtetra
.76773 .3688 .77579 .37966 .79415 .37379 .78618 .36286 Mtetra
.78618 .36286 .79415 .37379 .81263 .36789 .80474 .35688 Mtetra
.80474 .35688 .81263 .36789 .83123 .36194 .82342 .35087 Mtetra
.82342 .35087 .83123 .36194 .84994 .35596 .84223 .34481 Mtetra
.84223 .34481 .84994 .35596 .86878 .34994 .86116 .33872 Mtetra
.86116 .33872 .86878 .34994 .88774 .34388 .88021 .33258 Mtetra
.88021 .33258 .88774 .34388 .90683 .33778 .89938 .32641 Mtetra
.30082 .5066 .31082 .51591 .32644 .51088 .3165 .50151 Mtetra
.3165 .50151 .32644 .51088 .34216 .50582 .33227 .4964 Mtetra
.33227 .4964 .34216 .50582 .35796 .50073 .34814 .49125 Mtetra
.34814 .49125 .35796 .50073 .37387 .49561 .3641 .48607 Mtetra
.3641 .48607 .37387 .49561 .38986 .49046 .38015 .48087 Mtetra
.38015 .48087 .38986 .49046 .40596 .48527 .39631 .47563 Mtetra
.39631 .47563 .40596 .48527 .42215 .48006 .41256 .47035 Mtetra
.41256 .47035 .42215 .48006 .43844 .47482 .42891 .46505 Mtetra
.42891 .46505 .43844 .47482 .45482 .46954 .44536 .45972 Mtetra
.44536 .45972 .45482 .46954 .47131 .46423 .46191 .45435 Mtetra
.647 .736 .914 r
.46191 .45435 .47131 .46423 .4879 .45889 .47855 .44964 Mtetra
.765 .286 0 r
.47855 .44964 .4879 .45889 .50459 .45352 .49503 .47495 Mtetra
.703 .348 .371 r
.49503 .47495 .50459 .45352 .52135 .46828 .51195 .49515 Mtetra
.652 .311 .381 r
.51195 .49515 .52135 .46828 .53843 .4826 .52924 .50997 Mtetra
.607 .265 .365 r
.52924 .50997 .53843 .4826 .55577 .49145 .54681 .51917 Mtetra
.551 .211 .344 r
.54681 .51917 .55577 .49145 .57329 .49465 .56458 .5226 Mtetra
.483 .146 .319 r
.56458 .5226 .57329 .49465 .59089 .49209 .58245 .52011 Mtetra
.399 .07 .287 r
.58245 .52011 .59089 .49209 .60849 .48372 .60034 .51165 Mtetra
.297 0 .249 r
.60034 .51165 .60849 .48372 .626 .46953 .61815 .49723 Mtetra
.178 0 .202 r
.61815 .49723 .626 .46953 .64331 .44959 .63578 .47691 Mtetra
.043 0 .148 r
.63578 .47691 .64331 .44959 .66035 .42404 .65313 .45082 Mtetra
0 0 .089 r
.65313 .45082 .66035 .42404 .67725 .39793 .67013 .41916 Mtetra
0 0 0 r
.67013 .41916 .67725 .39793 .69512 .39217 .68668 .38216 Mtetra
.679 .761 .914 r
.68668 .38216 .69512 .39217 .7131 .38639 .70471 .3756 Mtetra
.664 .741 .908 r
.70471 .3756 .7131 .38639 .73119 .38056 .72288 .36971 Mtetra
.72288 .36971 .73119 .38056 .74941 .3747 .74117 .36377 Mtetra
.74117 .36377 .74941 .3747 .76773 .3688 .75958 .3578 Mtetra
.75958 .3578 .76773 .3688 .78618 .36286 .77811 .35179 Mtetra
.77811 .35179 .78618 .36286 .80474 .35688 .79676 .34575 Mtetra
.79676 .34575 .80474 .35688 .82342 .35087 .81553 .33966 Mtetra
.81553 .33966 .82342 .35087 .84223 .34481 .83442 .33353 Mtetra
.83442 .33353 .84223 .34481 .86116 .33872 .85344 .32736 Mtetra
.85344 .32736 .86116 .33872 .88021 .33258 .87258 .32115 Mtetra
.87258 .32115 .88021 .33258 .89938 .32641 .89184 .31491 Mtetra
.29071 .49718 .30082 .5066 .3165 .50151 .30645 .49204 Mtetra
.30645 .49204 .3165 .50151 .33227 .4964 .32228 .48687 Mtetra
.32228 .48687 .33227 .4964 .34814 .49125 .3382 .48167 Mtetra
.3382 .48167 .34814 .49125 .3641 .48607 .35422 .47643 Mtetra
.35422 .47643 .3641 .48607 .38015 .48087 .37034 .47117 Mtetra
.37034 .47117 .38015 .48087 .39631 .47563 .38655 .46587 Mtetra
.38655 .46587 .39631 .47563 .41256 .47035 .40287 .46054 Mtetra
.40287 .46054 .41256 .47035 .42891 .46505 .41928 .45518 Mtetra
.41928 .45518 .42891 .46505 .44536 .45972 .43579 .44978 Mtetra
.43579 .44978 .44536 .45972 .46191 .45435 .45241 .44435 Mtetra
.773 .3 0 r
.45241 .44435 .46191 .45435 .47855 .44964 .46859 .47036 Mtetra
.738 .384 .382 r
.46859 .47036 .47855 .44964 .49503 .47495 .48519 .49632 Mtetra
.705 .348 .367 r
.48519 .49632 .49503 .47495 .51195 .49515 .50227 .51707 Mtetra
.665 .303 .349 r
.50227 .51707 .51195 .49515 .52924 .50997 .51973 .53233 Mtetra
.613 .248 .326 r
.51973 .53233 .52924 .50997 .54681 .51917 .53751 .54186 Mtetra
.546 .18 .297 r
.53751 .54186 .54681 .51917 .56458 .5226 .5555 .54547 Mtetra
.46 .097 .26 r
.5555 .54547 .56458 .5226 .58245 .52011 .57362 .54303 Mtetra
.35 0 .214 r
.57362 .54303 .58245 .52011 .60034 .51165 .59178 .5345 Mtetra
.214 0 .155 r
.59178 .5345 .60034 .51165 .61815 .49723 .60987 .51986 Mtetra
.051 0 .086 r
.60987 .51986 .61815 .49723 .63578 .47691 .62779 .49919 Mtetra
0 0 .008 r
.62779 .49919 .63578 .47691 .65313 .45082 .64544 .47262 Mtetra
0 0 0 r
.64544 .47262 .65313 .45082 .67013 .41916 .66275 .44034 Mtetra
.66275 .44034 .67013 .41916 .68668 .38216 .67961 .40262 Mtetra
.67961 .40262 .68668 .38216 .70471 .3756 .69621 .36469 Mtetra
.664 .741 .908 r
.69621 .36469 .70471 .3756 .72288 .36971 .71447 .35872 Mtetra
.71447 .35872 .72288 .36971 .74117 .36377 .73284 .35272 Mtetra
.73284 .35272 .74117 .36377 .75958 .3578 .75133 .34668 Mtetra
.75133 .34668 .75958 .3578 .77811 .35179 .76995 .3406 Mtetra
.76995 .3406 .77811 .35179 .79676 .34575 .78868 .33448 Mtetra
.78868 .33448 .79676 .34575 .81553 .33966 .80754 .32831 Mtetra
.80754 .32831 .81553 .33966 .83442 .33353 .82652 .32211 Mtetra
.82652 .32211 .83442 .33353 .85344 .32736 .84562 .31587 Mtetra
.84562 .31587 .85344 .32736 .87258 .32115 .86485 .30959 Mtetra
.86485 .30959 .87258 .32115 .89184 .31491 .88421 .30326 Mtetra
.28049 .48767 .29071 .49718 .30645 .49204 .29628 .48247 Mtetra
.29628 .48247 .30645 .49204 .32228 .48687 .31217 .47724 Mtetra
.31217 .47724 .32228 .48687 .3382 .48167 .32815 .47198 Mtetra
.32815 .47198 .3382 .48167 .35422 .47643 .34423 .46669 Mtetra
.34423 .46669 .35422 .47643 .37034 .47117 .36041 .46136 Mtetra
.36041 .46136 .37034 .47117 .38655 .46587 .37668 .456 Mtetra
.37668 .456 .38655 .46587 .40287 .46054 .39306 .45061 Mtetra
.39306 .45061 .40287 .46054 .41928 .45518 .40954 .44519 Mtetra
.40954 .44519 .41928 .45518 .43579 .44978 .42611 .43973 Mtetra
0 .079 .586 r
.42611 .43973 .43579 .44978 .45241 .44435 .44228 .45448 Mtetra
.809 .427 .333 r
.44228 .45448 .45241 .44435 .46859 .47036 .45843 .48596 Mtetra
.76 .387 .349 r
.45843 .48596 .46859 .47036 .48519 .49632 .47513 .51248 Mtetra
.726 .345 .328 r
.47513 .51248 .48519 .49632 .50227 .51707 .49233 .5337 Mtetra
.68 .291 .302 r
.49233 .5337 .50227 .51707 .51973 .53233 .50995 .54933 Mtetra
.62 .222 .269 r
.50995 .54933 .51973 .53233 .53751 .54186 .5279 .55913 Mtetra
.536 .133 .225 r
.5279 .55913 .53751 .54186 .5555 .54547 .54609 .56289 Mtetra
.422 .018 .166 r
.54609 .56289 .5555 .54547 .57362 .54303 .56444 .5605 Mtetra
.267 0 .09 r
.56444 .5605 .57362 .54303 .59178 .5345 .58283 .55188 Mtetra
.069 0 0 r
.58283 .55188 .59178 .5345 .60987 .51986 .60117 .53704 Mtetra
0 0 0 r
.60117 .53704 .60987 .51986 .62779 .49919 .61936 .51605 Mtetra
.61936 .51605 .62779 .49919 .64544 .47262 .6373 .48905 Mtetra
.6373 .48905 .64544 .47262 .66275 .44034 .65489 .45623 Mtetra
.707 .807 .343 r
.65489 .45623 .66275 .44034 .67961 .40262 .67204 .41787 Mtetra
.801 .841 .377 r
.67204 .41787 .67961 .40262 .69621 .36469 .68867 .37428 Mtetra
.693 .871 .476 r
.68867 .37428 .69621 .36469 .71447 .35872 .70595 .34761 Mtetra
.664 .741 .908 r
.70595 .34761 .71447 .35872 .73284 .35272 .72441 .34153 Mtetra
.72441 .34153 .73284 .35272 .75133 .34668 .74299 .33542 Mtetra
.74299 .33542 .75133 .34668 .76995 .3406 .76168 .32926 Mtetra
.76168 .32926 .76995 .3406 .78868 .33448 .7805 .32307 Mtetra
.7805 .32307 .78868 .33448 .80754 .32831 .79945 .31683 Mtetra
.79945 .31683 .80754 .32831 .82652 .32211 .81852 .31055 Mtetra
.81852 .31055 .82652 .32211 .84562 .31587 .83771 .30424 Mtetra
.83771 .30424 .84562 .31587 .86485 .30959 .85704 .29787 Mtetra
.85704 .29787 .86485 .30959 .88421 .30326 .87649 .29147 Mtetra
.27016 .47805 .28049 .48767 .29628 .48247 .28601 .47279 Mtetra
.28601 .47279 .29628 .48247 .31217 .47724 .30195 .4675 Mtetra
.30195 .4675 .31217 .47724 .32815 .47198 .31799 .46218 Mtetra
.31799 .46218 .32815 .47198 .34423 .46669 .33413 .45683 Mtetra
.33413 .45683 .34423 .46669 .36041 .46136 .35037 .45144 Mtetra
.35037 .45144 .36041 .46136 .37668 .456 .36671 .44603 Mtetra
.36671 .44603 .37668 .456 .39306 .45061 .38314 .44057 Mtetra
.38314 .44057 .39306 .45061 .40954 .44519 .39968 .43509 Mtetra
.39968 .43509 .40954 .44519 .42611 .43973 .41632 .42957 Mtetra
.873 .44 .045 r
.41632 .42957 .42611 .43973 .44228 .45448 .43194 .46413 Mtetra
.812 .428 .327 r
.43194 .46413 .44228 .45448 .45843 .48596 .44812 .49614 Mtetra
.786 .39 .303 r
.44812 .49614 .45843 .48596 .47513 .51248 .4649 .52311 Mtetra
.75 .339 .272 r
.4649 .52311 .47513 .51248 .49233 .5337 .48219 .54472 Mtetra
.699 .272 .231 r
.48219 .54472 .49233 .5337 .50995 .54933 .49993 .56065 Mtetra
.624 .181 .177 r
.49993 .56065 .50995 .54933 .5279 .55913 .51803 .57066 Mtetra
.513 .054 .101 r
.51803 .57066 .5279 .55913 .54609 .56289 .53639 .57454 Mtetra
.345 0 0 r
.53639 .57454 .54609 .56289 .56444 .5605 .55493 .57217 Mtetra
.103 0 0 r
.55493 .57217 .56444 .5605 .58283 .55188 .57353 .56347 Mtetra
0 0 0 r
.57353 .56347 .58283 .55188 .60117 .53704 .5921 .54845 Mtetra
.5921 .54845 .60117 .53704 .61936 .51605 .61053 .52718 Mtetra
.691 .875 .485 r
.61053 .52718 .61936 .51605 .6373 .48905 .62873 .4998 Mtetra
.819 .914 .517 r
.62873 .4998 .6373 .48905 .65489 .45623 .64658 .46651 Mtetra
.893 .919 .526 r
.64658 .46651 .65489 .45623 .67204 .41787 .664 .4276 Mtetra
.935 .91 .524 r
.664 .4276 .67204 .41787 .68867 .37428 .68091 .38339 Mtetra
.952 .902 .52 r
.68091 .38339 .68867 .37428 .70595 .34761 .69734 .33636 Mtetra
.664 .741 .908 r
.69734 .33636 .70595 .34761 .72441 .34153 .71588 .33021 Mtetra
.71588 .33021 .72441 .34153 .74299 .33542 .73454 .32402 Mtetra
.73454 .32402 .74299 .33542 .76168 .32926 .75332 .31779 Mtetra
.75332 .31779 .76168 .32926 .7805 .32307 .77223 .31152 Mtetra
.77223 .31152 .7805 .32307 .79945 .31683 .79126 .30521 Mtetra
.79126 .30521 .79945 .31683 .81852 .31055 .81042 .29886 Mtetra
.81042 .29886 .81852 .31055 .83771 .30424 .82971 .29246 Mtetra
.82971 .29246 .83771 .30424 .85704 .29787 .84912 .28602 Mtetra
.84912 .28602 .85704 .29787 .87649 .29147 .86867 .27954 Mtetra
.25971 .46832 .27016 .47805 .28601 .47279 .27562 .463 Mtetra
.27562 .463 .28601 .47279 .30195 .4675 .29162 .45766 Mtetra
.29162 .45766 .30195 .4675 .31799 .46218 .30772 .45227 Mtetra
.30772 .45227 .31799 .46218 .33413 .45683 .32392 .44686 Mtetra
.32392 .44686 .33413 .45683 .35037 .45144 .34021 .44141 Mtetra
.34021 .44141 .35037 .45144 .36671 .44603 .35661 .43593 Mtetra
.35661 .43593 .36671 .44603 .38314 .44057 .37311 .43042 Mtetra
.37311 .43042 .38314 .44057 .39968 .43509 .38972 .42487 Mtetra
.147 .494 .905 r
.38972 .42487 .39968 .43509 .41632 .42957 .40599 .43116 Mtetra
.869 .471 .279 r
.40599 .43116 .41632 .42957 .43194 .46413 .42152 .46825 Mtetra
.84 .434 .272 r
.42152 .46825 .43194 .46413 .44812 .49614 .43772 .50064 Mtetra
.814 .389 .234 r
.43772 .50064 .44812 .49614 .4649 .52311 .45453 .52796 Mtetra
.775 .327 .185 r
.45453 .52796 .4649 .52311 .48219 .54472 .47189 .54986 Mtetra
.714 .238 .115 r
.47189 .54986 .48219 .54472 .49993 .56065 .48972 .56601 Mtetra
.616 .106 .014 r
.48972 .56601 .49993 .56065 .51803 .57066 .50793 .57617 Mtetra
.446 0 0 r
.50793 .57617 .51803 .57066 .53639 .57454 .52644 .58013 Mtetra
.161 0 0 r
.52644 .58013 .53639 .57454 .55493 .57217 .54513 .57775 Mtetra
0 0 0 r
.54513 .57775 .55493 .57217 .57353 .56347 .56392 .56897 Mtetra
.584 .916 .69 r
.56392 .56897 .57353 .56347 .5921 .54845 .58269 .55379 Mtetra
.794 .983 .716 r
.58269 .55379 .5921 .54845 .61053 .52718 .60133 .53228 Mtetra
.897 .979 .696 r
.60133 .53228 .61053 .52718 .62873 .4998 .61975 .50458 Mtetra
.947 .956 .666 r
.61975 .50458 .62873 .4998 .64658 .46651 .63785 .47091 Mtetra
.972 .929 .637 r
.63785 .47091 .64658 .46651 .664 .4276 .65552 .43155 Mtetra
.985 .905 .612 r
.65552 .43155 .664 .4276 .68091 .38339 .67268 .38683 Mtetra
.992 .884 .59 r
.67268 .38683 .68091 .38339 .69734 .33636 .68925 .33712 Mtetra
.837 .999 .819 r
.68925 .33712 .69734 .33636 .71588 .33021 .70724 .31876 Mtetra
.664 .741 .908 r
.70724 .31876 .71588 .33021 .73454 .32402 .72599 .31249 Mtetra
.72599 .31249 .73454 .32402 .75332 .31779 .74486 .30618 Mtetra
.74486 .30618 .75332 .31779 .77223 .31152 .76385 .29984 Mtetra
.76385 .29984 .77223 .31152 .79126 .30521 .78297 .29345 Mtetra
.78297 .29345 .79126 .30521 .81042 .29886 .80222 .28701 Mtetra
.80222 .28701 .81042 .29886 .82971 .29246 .8216 .28054 Mtetra
.8216 .28054 .82971 .29246 .84912 .28602 .84111 .27402 Mtetra
.84111 .27402 .84912 .28602 .86867 .27954 .86075 .26745 Mtetra
.24914 .45848 .25971 .46832 .27562 .463 .26511 .4531 Mtetra
.26511 .4531 .27562 .463 .29162 .45766 .28117 .4477 Mtetra
.28117 .4477 .29162 .45766 .30772 .45227 .29733 .44225 Mtetra
.29733 .44225 .30772 .45227 .32392 .44686 .31359 .43678 Mtetra
.31359 .43678 .32392 .44686 .34021 .44141 .32994 .43127 Mtetra
.32994 .43127 .34021 .44141 .35661 .43593 .34641 .42573 Mtetra
.34641 .42573 .35661 .43593 .37311 .43042 .36297 .42015 Mtetra
.36297 .42015 .37311 .43042 .38972 .42487 .37964 .41454 Mtetra
0 .065 .571 r
.37964 .41454 .38972 .42487 .40599 .43116 .3956 .42925 Mtetra
.883 .475 .236 r
.3956 .42925 .40599 .43116 .42152 .46825 .41109 .46662 Mtetra
.864 .435 .191 r
.41109 .46662 .42152 .46825 .43772 .50064 .42728 .49928 Mtetra
.835 .379 .129 r
.42728 .49928 .43772 .50064 .45453 .52796 .4441 .52682 Mtetra
.787 .296 .043 r
.4441 .52682 .45453 .52796 .47189 .54986 .46149 .54889 Mtetra
.702 .167 0 r
.46149 .54889 .47189 .54986 .48972 .56601 .47938 .56518 Mtetra
.541 0 0 r
.47938 .56518 .48972 .56601 .50793 .57617 .49767 .57543 Mtetra
.232 0 0 r
.49767 .57543 .50793 .57617 .52644 .58013 .51628 .57942 Mtetra
.225 .743 .851 r
.51628 .57942 .52644 .58013 .54513 .57775 .5351 .57702 Mtetra
.61 .944 .938 r
.5351 .57702 .54513 .57775 .56392 .56897 .55403 .56816 Mtetra
.808 .98 .895 r
.55403 .56816 .56392 .56897 .58269 .55379 .57297 .55283 Mtetra
.897 .96 .827 r
.57297 .55283 .58269 .55379 .60133 .53228 .5918 .53112 Mtetra
.939 .93 .768 r
.5918 .53112 .60133 .53228 .61975 .50458 .61042 .50318 Mtetra
.96 .903 .72 r
.61042 .50318 .61975 .50458 .63785 .47091 .62873 .46921 Mtetra
.972 .879 .683 r
.62873 .46921 .63785 .47091 .65552 .43155 .64662 .4295 Mtetra
.979 .86 .652 r
.64662 .4295 .65552 .43155 .67268 .38683 .66401 .38439 Mtetra
.983 .844 .627 r
.66401 .38439 .67268 .38683 .68925 .33712 .68082 .33427 Mtetra
.94 .92 .764 r
.68082 .33427 .68925 .33712 .70724 .31876 .6985 .30716 Mtetra
.664 .741 .908 r
.6985 .30716 .70724 .31876 .72599 .31249 .71733 .30082 Mtetra
.71733 .30082 .72599 .31249 .74486 .30618 .73629 .29443 Mtetra
.73629 .29443 .74486 .30618 .76385 .29984 .75537 .28801 Mtetra
.75537 .28801 .76385 .29984 .78297 .29345 .77458 .28154 Mtetra
.77458 .28154 .78297 .29345 .80222 .28701 .79392 .27502 Mtetra
.79392 .27502 .80222 .28701 .8216 .28054 .8134 .26847 Mtetra
.8134 .26847 .8216 .28054 .84111 .27402 .833 .26186 Mtetra
.833 .26186 .84111 .27402 .86075 .26745 .85274 .25522 Mtetra
.23846 .44853 .24914 .45848 .26511 .4531 .25448 .44309 Mtetra
.25448 .44309 .26511 .4531 .28117 .4477 .2706 .43762 Mtetra
.2706 .43762 .28117 .4477 .29733 .44225 .28682 .43212 Mtetra
.28682 .43212 .29733 .44225 .31359 .43678 .30314 .42658 Mtetra
.30314 .42658 .31359 .43678 .32994 .43127 .31956 .42101 Mtetra
.31956 .42101 .32994 .43127 .34641 .42573 .33608 .4154 Mtetra
.33608 .4154 .34641 .42573 .36297 .42015 .35271 .40976 Mtetra
.35271 .40976 .36297 .42015 .37964 .41454 .36944 .40408 Mtetra
.563 .065 0 r
.36944 .40408 .37964 .41454 .3956 .42925 .38527 .42162 Mtetra
.894 .472 .144 r
.38527 .42162 .3956 .42925 .41109 .46662 .4007 .45912 Mtetra
.867 .421 .071 r
.4007 .45912 .41109 .46662 .42728 .49928 .41684 .49189 Mtetra
.821 .344 0 r
.41684 .49189 .42728 .49928 .4441 .52682 .43365 .51953 Mtetra
.736 .224 0 r
.43365 .51953 .4441 .52682 .46149 .54889 .45104 .54167 Mtetra
.573 .028 0 r
.45104 .54167 .46149 .54889 .47938 .56518 .46895 .55801 Mtetra
0 .268 .693 r
.46895 .55801 .47938 .56518 .49767 .57543 .48729 .56827 Mtetra
.153 .59 .932 r
.48729 .56827 .49767 .57543 .51628 .57942 .50597 .57224 Mtetra
.509 .784 .994 r
.50597 .57224 .51628 .57942 .5351 .57702 .52489 .5698 Mtetra
.714 .849 .947 r
.52489 .5698 .5351 .57702 .55403 .56816 .54393 .56085 Mtetra
.818 .859 .878 r
.54393 .56085 .55403 .56816 .57297 .55283 .563 .54541 Mtetra
.875 .851 .816 r
.563 .54541 .57297 .55283 .5918 .53112 .58198 .52355 Mtetra
.907 .838 .766 r
.58198 .52355 .5918 .53112 .61042 .50318 .60077 .49542 Mtetra
.927 .826 .726 r
.60077 .49542 .61042 .50318 .62873 .46921 .61926 .46125 Mtetra
.94 .815 .693 r
.61926 .46125 .62873 .46921 .64662 .4295 .63735 .42131 Mtetra
.95 .805 .666 r
.63735 .42131 .64662 .4295 .66401 .38439 .65495 .37595 Mtetra
.957 .797 .643 r
.65495 .37595 .66401 .38439 .68082 .33427 .67197 .32556 Mtetra
.918 .827 .741 r
.67197 .32556 .68082 .33427 .6985 .30716 .68965 .29542 Mtetra
.664 .741 .908 r
.68965 .29542 .6985 .30716 .71733 .30082 .70857 .289 Mtetra
.70857 .289 .71733 .30082 .73629 .29443 .72761 .28253 Mtetra
.72761 .28253 .73629 .29443 .75537 .28801 .74679 .27603 Mtetra
.74679 .27603 .75537 .28801 .77458 .28154 .76609 .26948 Mtetra
.76609 .26948 .77458 .28154 .79392 .27502 .78552 .26288 Mtetra
.78552 .26288 .79392 .27502 .8134 .26847 .80509 .25624 Mtetra
.80509 .25624 .8134 .26847 .833 .26186 .82479 .24956 Mtetra
.82479 .24956 .833 .26186 .85274 .25522 .84462 .24283 Mtetra
.22765 .43847 .23846 .44853 .25448 .44309 .24373 .43297 Mtetra
.24373 .43297 .25448 .44309 .2706 .43762 .25991 .42744 Mtetra
.25991 .42744 .2706 .43762 .28682 .43212 .27619 .42187 Mtetra
.27619 .42187 .28682 .43212 .30314 .42658 .29257 .41627 Mtetra
.29257 .41627 .30314 .42658 .31956 .42101 .30905 .41063 Mtetra
.30905 .41063 .31956 .42101 .33608 .4154 .32563 .40496 Mtetra
.32563 .40496 .33608 .4154 .35271 .40976 .34233 .39925 Mtetra
.34233 .39925 .35271 .40976 .36944 .40408 .35912 .39351 Mtetra
0 .065 .571 r
.35912 .39351 .36944 .40408 .38527 .42162 .37507 .4082 Mtetra
.87 .449 .018 r
.37507 .4082 .38527 .42162 .4007 .45912 .39041 .44566 Mtetra
.815 .376 0 r
.39041 .44566 .4007 .45912 .41684 .49189 .40648 .47839 Mtetra
.717 .263 0 r
.40648 .47839 .41684 .49189 .43365 .51953 .42323 .50599 Mtetra
0 0 .447 r
.42323 .50599 .43365 .51953 .45104 .54167 .4406 .5281 Mtetra
0 .145 .675 r
.4406 .5281 .45104 .54167 .46895 .55801 .4585 .54439 Mtetra
.072 .393 .851 r
.4585 .54439 .46895 .55801 .48729 .56827 .47685 .55459 Mtetra
.373 .575 .918 r
.47685 .55459 .48729 .56827 .50597 .57224 .49557 .5585 Mtetra
.577 .675 .907 r
.49557 .5585 .50597 .57224 .52489 .5698 .51454 .55598 Mtetra
.703 .723 .866 r
.51454 .55598 .52489 .5698 .54393 .56085 .53366 .54695 Mtetra
.78 .745 .821 r
.53366 .54695 .54393 .56085 .563 .54541 .55283 .53141 Mtetra
.829 .754 .78 r
.55283 .53141 .563 .54541 .58198 .52355 .57193 .50946 Mtetra
.862 .756 .745 r
.57193 .50946 .58198 .52355 .60077 .49542 .59085 .48122 Mtetra
.885 .757 .715 r
.59085 .48122 .60077 .49542 .61926 .46125 .60949 .44693 Mtetra
.902 .755 .689 r
.60949 .44693 .61926 .46125 .63735 .42131 .62775 .40688 Mtetra
.915 .753 .666 r
.62775 .40688 .63735 .42131 .65495 .37595 .64552 .3614 Mtetra
.925 .751 .647 r
.64552 .3614 .65495 .37595 .67197 .32556 .66273 .3109 Mtetra
.862 .753 .74 r
.66273 .3109 .67197 .32556 .68965 .29542 .68069 .28353 Mtetra
.664 .741 .908 r
.68069 .28353 .68965 .29542 .70857 .289 .6997 .27703 Mtetra
.6997 .27703 .70857 .289 .72761 .28253 .71883 .27049 Mtetra
.71883 .27049 .72761 .28253 .74679 .27603 .73809 .2639 Mtetra
.73809 .2639 .74679 .27603 .76609 .26948 .75749 .25727 Mtetra
.75749 .25727 .76609 .26948 .78552 .26288 .77701 .25059 Mtetra
.77701 .25059 .78552 .26288 .80509 .25624 .79667 .24387 Mtetra
.79667 .24387 .80509 .25624 .82479 .24956 .81647 .2371 Mtetra
.81647 .2371 .82479 .24956 .84462 .24283 .8364 .23028 Mtetra
.21672 .42829 .22765 .43847 .24373 .43297 .23286 .42273 Mtetra
.23286 .42273 .24373 .43297 .25991 .42744 .24909 .41713 Mtetra
.24909 .41713 .25991 .42744 .27619 .42187 .26543 .4115 Mtetra
.26543 .4115 .27619 .42187 .29257 .41627 .28187 .40583 Mtetra
.28187 .40583 .29257 .41627 .30905 .41063 .29842 .40013 Mtetra
.29842 .40013 .30905 .41063 .32563 .40496 .31507 .39439 Mtetra
.31507 .39439 .32563 .40496 .34233 .39925 .33182 .38862 Mtetra
.33182 .38862 .34233 .39925 .35912 .39351 .34868 .3828 Mtetra
.147 .494 .905 r
.34868 .3828 .35912 .39351 .37507 .4082 .36506 .38895 Mtetra
.783 .392 0 r
.36506 .38895 .37507 .4082 .39041 .44566 .38027 .42622 Mtetra
.672 .285 0 r
.38027 .42622 .39041 .44566 .40648 .47839 .39625 .45877 Mtetra
0 0 .447 r
.39625 .45877 .40648 .47839 .42323 .50599 .41292 .4862 Mtetra
0 .052 .619 r
.41292 .4862 .42323 .50599 .4406 .5281 .43022 .50815 Mtetra
.012 .247 .753 r
.43022 .50815 .4406 .5281 .4585 .54439 .44808 .52429 Mtetra
.261 .409 .822 r
.44808 .52429 .4585 .54439 .47685 .55459 .46641 .53437 Mtetra
.452 .521 .838 r
.46641 .53437 .47685 .55459 .49557 .5585 .48513 .53817 Mtetra
.587 .592 .825 r
.48513 .53817 .49557 .5585 .51454 .55598 .50412 .53554 Mtetra
.679 .636 .8 r
.50412 .53554 .51454 .55598 .53366 .54695 .52329 .52643 Mtetra
.743 .664 .772 r
.52329 .52643 .53366 .54695 .55283 .53141 .54251 .51083 Mtetra
.788 .681 .746 r
.54251 .51083 .55283 .53141 .57193 .50946 .56169 .48882 Mtetra
.822 .692 .721 r
.56169 .48882 .57193 .50946 .59085 .48122 .58072 .46055 Mtetra
.847 .7 .699 r
.58072 .46055 .59085 .48122 .60949 .44693 .59947 .42625 Mtetra
.866 .705 .679 r
.59947 .42625 .60949 .44693 .62775 .40688 .61786 .3862 Mtetra
.882 .708 .662 r
.61786 .3862 .62775 .40688 .64552 .3614 .63579 .34075 Mtetra
.895 .71 .646 r
.63579 .34075 .64552 .3614 .66273 .3109 .65316 .29029 Mtetra
.77 .671 .754 r
.65316 .29029 .66273 .3109 .68069 .28353 .67162 .2715 Mtetra
.664 .741 .908 r
.67162 .2715 .68069 .28353 .6997 .27703 .69071 .26492 Mtetra
.69071 .26492 .6997 .27703 .71883 .27049 .70994 .25829 Mtetra
.70994 .25829 .71883 .27049 .73809 .2639 .72929 .25162 Mtetra
.72929 .25162 .73809 .2639 .75749 .25727 .74878 .2449 Mtetra
.74878 .2449 .75749 .25727 .77701 .25059 .7684 .23814 Mtetra
.7684 .23814 .77701 .25059 .79667 .24387 .78815 .23133 Mtetra
.78815 .23133 .79667 .24387 .81647 .2371 .80804 .22448 Mtetra
.80804 .22448 .81647 .2371 .8364 .23028 .82807 .21757 Mtetra
.20566 .41799 .21672 .42829 .23286 .42273 .22186 .41237 Mtetra
.22186 .41237 .23286 .42273 .24909 .41713 .23815 .40671 Mtetra
.23815 .40671 .24909 .41713 .26543 .4115 .25455 .40101 Mtetra
.25455 .40101 .26543 .4115 .28187 .40583 .27106 .39528 Mtetra
.27106 .39528 .28187 .40583 .29842 .40013 .28766 .38951 Mtetra
.28766 .38951 .29842 .40013 .31507 .39439 .30438 .3837 Mtetra
.30438 .3837 .31507 .39439 .33182 .38862 .3212 .37786 Mtetra
.3212 .37786 .33182 .38862 .34868 .3828 .33812 .37198 Mtetra
.33812 .37198 .34868 .3828 .36506 .38895 .35516 .36606 Mtetra
0 0 .288 r
.35516 .36606 .36506 .38895 .38027 .42622 .37035 .40085 Mtetra
0 0 .43 r
.37035 .40085 .38027 .42622 .39625 .45877 .38619 .43307 Mtetra
0 0 .565 r
.38619 .43307 .39625 .45877 .41292 .4862 .40275 .46019 Mtetra
0 .147 .673 r
.40275 .46019 .41292 .4862 .43022 .50815 .41997 .48187 Mtetra
.178 .289 .741 r
.41997 .48187 .43022 .50815 .44808 .52429 .43775 .49778 Mtetra
.352 .4 .771 r
.43775 .49778 .44808 .52429 .46641 .53437 .45603 .50765 Mtetra
.485 .48 .777 r
.45603 .50765 .46641 .53437 .48513 .53817 .47471 .51128 Mtetra
.585 .538 .768 r
.47471 .51128 .48513 .53817 .50412 .53554 .49369 .50853 Mtetra
.658 .578 .753 r
.49369 .50853 .50412 .53554 .52329 .52643 .51286 .49934 Mtetra
.714 .606 .735 r
.51286 .49934 .52329 .52643 .54251 .51083 .53211 .48369 Mtetra
.756 .627 .718 r
.53211 .48369 .54251 .51083 .56169 .48882 .55134 .46168 Mtetra
.788 .642 .7 r
.55134 .46168 .56169 .48882 .58072 .46055 .57042 .43346 Mtetra
.814 .654 .684 r
.57042 .43346 .58072 .46055 .59947 .42625 .58926 .39924 Mtetra
.835 .663 .669 r
.58926 .39924 .59947 .42625 .61786 .3862 .60775 .35931 Mtetra
.852 .67 .655 r
.60775 .35931 .61786 .3862 .63579 .34075 .6258 .31403 Mtetra
.861 .673 .646 r
.6258 .31403 .63579 .34075 .65316 .29029 .64338 .26593 Mtetra
.636 .579 .773 r
.64338 .26593 .65316 .29029 .67162 .2715 .66244 .25931 Mtetra
.664 .741 .908 r
.66244 .25931 .67162 .2715 .69071 .26492 .68162 .25265 Mtetra
.68162 .25265 .69071 .26492 .70994 .25829 .70093 .24594 Mtetra
.70093 .24594 .70994 .25829 .72929 .25162 .72038 .23918 Mtetra
.72038 .23918 .72929 .25162 .74878 .2449 .73996 .23238 Mtetra
.73996 .23238 .74878 .2449 .7684 .23814 .75967 .22553 Mtetra
.75967 .22553 .7684 .23814 .78815 .23133 .77952 .21864 Mtetra
.77952 .21864 .78815 .23133 .80804 .22448 .79951 .21169 Mtetra
.79951 .21169 .80804 .22448 .82807 .21757 .81964 .2047 Mtetra
.19448 .40758 .20566 .41799 .22186 .41237 .21073 .40189 Mtetra
.21073 .40189 .22186 .41237 .23815 .40671 .22709 .39616 Mtetra
.22709 .39616 .23815 .40671 .25455 .40101 .24355 .3904 Mtetra
.24355 .3904 .25455 .40101 .27106 .39528 .26011 .3846 Mtetra
.26011 .3846 .27106 .39528 .28766 .38951 .27678 .37876 Mtetra
.27678 .37876 .28766 .38951 .30438 .3837 .29356 .37289 Mtetra
.29356 .37289 .30438 .3837 .3212 .37786 .31044 .36697 Mtetra
.31044 .36697 .3212 .37786 .33812 .37198 .32744 .36102 Mtetra
.32744 .36102 .33812 .37198 .35516 .36606 .34454 .35503 Mtetra
0 .079 .586 r
.34454 .35503 .35516 .36606 .37035 .40085 .36069 .36966 Mtetra
0 0 .52 r
.36069 .36966 .37035 .40085 .38619 .43307 .37638 .40139 Mtetra
0 .075 .611 r
.37638 .40139 .38619 .43307 .40275 .46019 .39281 .42808 Mtetra
.115 .2 .676 r
.39281 .42808 .40275 .46019 .41997 .48187 .40989 .44937 Mtetra
.272 .305 .713 r
.40989 .44937 .41997 .48187 .43775 .49778 .42757 .46495 Mtetra
.4 .388 .73 r
.42757 .46495 .43775 .49778 .45603 .50765 .44576 .47455 Mtetra
.501 .452 .733 r
.44576 .47455 .45603 .50765 .47471 .51128 .46437 .47797 Mtetra
.58 .5 .728 r
.46437 .47797 .47471 .51128 .49369 .50853 .4833 .47508 Mtetra
.642 .536 .719 r
.4833 .47508 .49369 .50853 .51286 .49934 .50244 .4658 Mtetra
.691 .564 .707 r
.50244 .4658 .51286 .49934 .53211 .48369 .52168 .45014 Mtetra
.729 .586 .695 r
.52168 .45014 .53211 .48369 .55134 .46168 .54091 .42818 Mtetra
.761 .603 .682 r
.54091 .42818 .55134 .46168 .57042 .43346 .56003 .40007 Mtetra
.787 .617 .67 r
.56003 .40007 .57042 .43346 .58926 .39924 .57892 .36603 Mtetra
.808 .628 .658 r
.57892 .36603 .58926 .39924 .60775 .35931 .59747 .32635 Mtetra
.826 .637 .647 r
.59747 .32635 .60775 .35931 .6258 .31403 .6156 .28137 Mtetra
.764 .605 .681 r
.6156 .28137 .6258 .31403 .64338 .26593 .634 .25368 Mtetra
.664 .741 .908 r
.634 .25368 .64338 .26593 .66244 .25931 .65314 .24697 Mtetra
.65314 .24697 .66244 .25931 .68162 .25265 .67241 .24023 Mtetra
.67241 .24023 .68162 .25265 .70093 .24594 .69181 .23343 Mtetra
.69181 .23343 .70093 .24594 .72038 .23918 .71135 .22659 Mtetra
.71135 .22659 .72038 .23918 .73996 .23238 .73102 .2197 Mtetra
.73102 .2197 .73996 .23238 .75967 .22553 .75083 .21276 Mtetra
.75083 .21276 .75967 .22553 .77952 .21864 .77078 .20578 Mtetra
.77078 .20578 .77952 .21864 .79951 .21169 .79087 .19875 Mtetra
.79087 .19875 .79951 .21169 .81964 .2047 .8111 .19166 Mtetra
.18316 .39704 .19448 .40758 .21073 .40189 .19948 .39129 Mtetra
.19948 .39129 .21073 .40189 .22709 .39616 .21589 .38549 Mtetra
.21589 .38549 .22709 .39616 .24355 .3904 .23241 .37966 Mtetra
.23241 .37966 .24355 .3904 .26011 .3846 .24904 .37379 Mtetra
.24904 .37379 .26011 .3846 .27678 .37876 .26577 .36789 Mtetra
.26577 .36789 .27678 .37876 .29356 .37289 .28261 .36194 Mtetra
.28261 .36194 .29356 .37289 .31044 .36697 .29956 .35596 Mtetra
.29956 .35596 .31044 .36697 .32744 .36102 .31662 .34994 Mtetra
.31662 .34994 .32744 .36102 .34454 .35503 .33379 .34388 Mtetra
.33379 .34388 .34454 .35503 .36069 .36966 .35107 .33778 Mtetra
0 .069 .605 r
.35107 .33778 .36069 .36966 .37638 .40139 .36687 .36393 Mtetra
.065 .132 .623 r
.36687 .36393 .37638 .40139 .39281 .42808 .38313 .39005 Mtetra
.207 .23 .664 r
.38313 .39005 .39281 .42808 .40989 .44937 .40006 .41085 Mtetra
.329 .311 .688 r
.40006 .41085 .40989 .44937 .42757 .46495 .41761 .42601 Mtetra
.429 .378 .699 r
.41761 .42601 .42757 .46495 .44576 .47455 .43567 .43527 Mtetra
.51 .43 .702 r
.43567 .43527 .44576 .47455 .46437 .47797 .45418 .43843 Mtetra
.576 .472 .699 r
.45418 .43843 .46437 .47797 .4833 .47508 .47302 .43537 Mtetra
.629 .506 .693 r
.47302 .43537 .4833 .47508 .50244 .4658 .49209 .42601 Mtetra
.673 .532 .685 r
.49209 .42601 .50244 .4658 .52168 .45014 .51128 .41036 Mtetra
.709 .554 .677 r
.51128 .41036 .52168 .45014 .54091 .42818 .53048 .3885 Mtetra
.738 .572 .667 r
.53048 .3885 .54091 .42818 .56003 .40007 .54959 .36058 Mtetra
.763 .587 .658 r
.54959 .36058 .56003 .40007 .57892 .36603 .56849 .32682 Mtetra
.785 .599 .649 r
.56849 .32682 .57892 .36603 .59747 .32635 .58708 .2875 Mtetra
.787 .6 .647 r
.58708 .2875 .59747 .32635 .6156 .28137 .60539 .24801 Mtetra
.617 .518 .72 r
.60539 .24801 .6156 .28137 .634 .25368 .62449 .24127 Mtetra
.664 .741 .908 r
.62449 .24127 .634 .25368 .65314 .24697 .64372 .23448 Mtetra
.64372 .23448 .65314 .24697 .67241 .24023 .66308 .22765 Mtetra
.66308 .22765 .67241 .24023 .69181 .23343 .68258 .22076 Mtetra
.68258 .22076 .69181 .23343 .71135 .22659 .70221 .21384 Mtetra
.70221 .21384 .71135 .22659 .73102 .2197 .72198 .20686 Mtetra
.72198 .20686 .73102 .2197 .75083 .21276 .74188 .19983 Mtetra
.74188 .19983 .75083 .21276 .77078 .20578 .76193 .19276 Mtetra
.76193 .19276 .77078 .20578 .79087 .19875 .78211 .18563 Mtetra
.78211 .18563 .79087 .19875 .8111 .19166 .80244 .17845 Mtetra
.17171 .38639 .18316 .39704 .19948 .39129 .18809 .38056 Mtetra
.18809 .38056 .19948 .39129 .21589 .38549 .20456 .3747 Mtetra
.20456 .3747 .21589 .38549 .23241 .37966 .22115 .3688 Mtetra
.22115 .3688 .23241 .37966 .24904 .37379 .23784 .36286 Mtetra
.23784 .36286 .24904 .37379 .26577 .36789 .25463 .35688 Mtetra
.25463 .35688 .26577 .36789 .28261 .36194 .27154 .35087 Mtetra
.27154 .35087 .28261 .36194 .29956 .35596 .28855 .34481 Mtetra
.28855 .34481 .29956 .35596 .31662 .34994 .30568 .33872 Mtetra
.30568 .33872 .31662 .34994 .33379 .34388 .32292 .33258 Mtetra
.32292 .33258 .33379 .34388 .35107 .33778 .34027 .32641 Mtetra
.647 .736 .914 r
.34027 .32641 .35107 .33778 .36687 .36393 .35769 .32091 Mtetra
.154 .168 .622 r
.35769 .32091 .36687 .36393 .38313 .39005 .37376 .34635 Mtetra
.268 .247 .65 r
.37376 .34635 .38313 .39005 .40006 .41085 .39052 .36655 Mtetra
.366 .314 .667 r
.39052 .36655 .40006 .41085 .41761 .42601 .4079 .38121 Mtetra
.447 .369 .675 r
.4079 .38121 .41761 .42601 .43567 .43527 .42582 .39006 Mtetra
.515 .414 .678 r
.42582 .39006 .43567 .43527 .45418 .43843 .44418 .39293 Mtetra
.572 .451 .677 r
.44418 .39293 .45418 .43843 .47302 .43537 .4629 .38968 Mtetra
.619 .482 .673 r
.4629 .38968 .47302 .43537 .49209 .42601 .48186 .38024 Mtetra
.658 .507 .668 r
.48186 .38024 .49209 .42601 .51128 .41036 .50097 .36463 Mtetra
.691 .528 .661 r
.50097 .36463 .51128 .41036 .53048 .3885 .52011 .34292 Mtetra
.72 .546 .654 r
.52011 .34292 .53048 .3885 .54959 .36058 .53917 .31527 Mtetra
.744 .561 .647 r
.53917 .31527 .54959 .36058 .56849 .32682 .55805 .28188 Mtetra
.765 .574 .64 r
.55805 .28188 .56849 .32682 .58708 .2875 .57663 .24303 Mtetra
.605 .474 .676 r
.57663 .24303 .58708 .2875 .60539 .24801 .59568 .23553 Mtetra
.664 .741 .908 r
.59568 .23553 .60539 .24801 .62449 .24127 .61486 .2287 Mtetra
.61486 .2287 .62449 .24127 .64372 .23448 .63418 .22183 Mtetra
.63418 .22183 .64372 .23448 .66308 .22765 .65363 .2149 Mtetra
.65363 .2149 .66308 .22765 .68258 .22076 .67322 .20793 Mtetra
.67322 .20793 .68258 .22076 .70221 .21384 .69295 .20092 Mtetra
.69295 .20092 .70221 .21384 .72198 .20686 .71281 .19385 Mtetra
.71281 .19385 .72198 .20686 .74188 .19983 .73281 .18673 Mtetra
.73281 .18673 .74188 .19983 .76193 .19276 .75296 .17956 Mtetra
.75296 .17956 .76193 .19276 .78211 .18563 .77324 .17234 Mtetra
.77324 .17234 .78211 .18563 .80244 .17845 .79367 .16507 Mtetra
.16013 .3756 .17171 .38639 .18809 .38056 .17656 .36971 Mtetra
.17656 .36971 .18809 .38056 .20456 .3747 .1931 .36377 Mtetra
.1931 .36377 .20456 .3747 .22115 .3688 .20975 .3578 Mtetra
.20975 .3578 .22115 .3688 .23784 .36286 .2265 .35179 Mtetra
.2265 .35179 .23784 .36286 .25463 .35688 .24336 .34575 Mtetra
.24336 .34575 .25463 .35688 .27154 .35087 .26033 .33966 Mtetra
.26033 .33966 .27154 .35087 .28855 .34481 .27741 .33353 Mtetra
.27741 .33353 .28855 .34481 .30568 .33872 .2946 .32736 Mtetra
.2946 .32736 .30568 .33872 .32292 .33258 .31191 .32115 Mtetra
.31191 .32115 .32292 .33258 .34027 .32641 .32933 .31491 Mtetra
.32933 .31491 .34027 .32641 .35769 .32091 .34686 .30862 Mtetra
.663 .728 .898 r
.34686 .30862 .35769 .32091 .37376 .34635 .36451 .30228 Mtetra
.359 .307 .663 r
.36451 .30228 .37376 .34635 .39052 .36655 .38133 .3168 Mtetra
.391 .314 .65 r
.38133 .3168 .39052 .36655 .4079 .38121 .39851 .33087 Mtetra
.46 .362 .657 r
.39851 .33087 .4079 .38121 .42582 .39006 .41624 .33927 Mtetra
.518 .401 .66 r
.41624 .33927 .42582 .39006 .44418 .39293 .43444 .3418 Mtetra
.568 .435 .659 r
.43444 .3418 .44418 .39293 .4629 .38968 .453 .33834 Mtetra
.61 .463 .657 r
.453 .33834 .4629 .38968 .48186 .38024 .47183 .32884 Mtetra
.646 .487 .653 r
.47183 .32884 .48186 .38024 .50097 .36463 .49081 .31329 Mtetra
.677 .507 .649 r
.49081 .31329 .50097 .36463 .52011 .34292 .50985 .29178 Mtetra
.704 .525 .643 r
.50985 .29178 .52011 .34292 .53917 .31527 .52883 .26445 Mtetra
.707 .527 .643 r
.52883 .26445 .53917 .31527 .55805 .28188 .54768 .23657 Mtetra
.598 .467 .674 r
.54768 .23657 .55805 .28188 .57663 .24303 .5667 .22975 Mtetra
.663 .728 .898 r
.5667 .22975 .57663 .24303 .59568 .23553 .58584 .22289 Mtetra
.664 .741 .908 r
.58584 .22289 .59568 .23553 .61486 .2287 .60511 .21597 Mtetra
.60511 .21597 .61486 .2287 .63418 .22183 .62452 .20901 Mtetra
.62452 .20901 .63418 .22183 .65363 .2149 .64407 .202 Mtetra
.64407 .202 .65363 .2149 .67322 .20793 .66375 .19494 Mtetra
.66375 .19494 .67322 .20793 .69295 .20092 .68357 .18783 Mtetra
.68357 .18783 .69295 .20092 .71281 .19385 .70353 .18067 Mtetra
.70353 .18067 .71281 .19385 .73281 .18673 .72363 .17346 Mtetra
.72363 .17346 .73281 .18673 .75296 .17956 .74387 .1662 Mtetra
.74387 .1662 .75296 .17956 .77324 .17234 .76426 .15888 Mtetra
.76426 .15888 .77324 .17234 .79367 .16507 .78479 .15152 Mtetra
.14841 .36469 .16013 .3756 .17656 .36971 .16491 .35872 Mtetra
.16491 .35872 .17656 .36971 .1931 .36377 .1815 .35272 Mtetra
.1815 .35272 .1931 .36377 .20975 .3578 .19821 .34668 Mtetra
.19821 .34668 .20975 .3578 .2265 .35179 .21502 .3406 Mtetra
.21502 .3406 .2265 .35179 .24336 .34575 .23195 .33448 Mtetra
.23195 .33448 .24336 .34575 .26033 .33966 .24898 .32831 Mtetra
.24898 .32831 .26033 .33966 .27741 .33353 .26613 .32211 Mtetra
.26613 .32211 .27741 .33353 .2946 .32736 .28339 .31587 Mtetra
.28339 .31587 .2946 .32736 .31191 .32115 .30077 .30959 Mtetra
.30077 .30959 .31191 .32115 .32933 .31491 .31825 .30326 Mtetra
.31825 .30326 .32933 .31491 .34686 .30862 .33586 .29689 Mtetra
.33586 .29689 .34686 .30862 .36451 .30228 .35358 .29048 Mtetra
.35358 .29048 .36451 .30228 .38133 .3168 .37143 .28403 Mtetra
.615 .517 .72 r
.37143 .28403 .38133 .3168 .39851 .33087 .38939 .27753 Mtetra
.487 .372 .648 r
.38939 .27753 .39851 .33087 .41624 .33927 .407 .28326 Mtetra
.52 .391 .645 r
.407 .28326 .41624 .33927 .43444 .3418 .425 .28543 Mtetra
.565 .421 .645 r
.425 .28543 .43444 .3418 .453 .33834 .44337 .28175 Mtetra
.603 .448 .644 r
.44337 .28175 .453 .33834 .47183 .32884 .46203 .27218 Mtetra
.636 .47 .641 r
.46203 .27218 .47183 .32884 .49081 .31329 .48086 .25672 Mtetra
.655 .483 .639 r
.48086 .25672 .49081 .31329 .50985 .29178 .49974 .23762 Mtetra
.587 .441 .65 r
.49974 .23762 .50985 .29178 .52883 .26445 .51858 .23081 Mtetra
.615 .517 .72 r
.51858 .23081 .52883 .26445 .54768 .23657 .53755 .22395 Mtetra
.664 .741 .908 r
.53755 .22395 .54768 .23657 .5667 .22975 .55664 .21704 Mtetra
.55664 .21704 .5667 .22975 .58584 .22289 .57587 .21008 Mtetra
.57587 .21008 .58584 .22289 .60511 .21597 .59524 .20308 Mtetra
.59524 .20308 .60511 .21597 .62452 .20901 .61474 .19603 Mtetra
.61474 .19603 .62452 .20901 .64407 .202 .63437 .18893 Mtetra
.63437 .18893 .64407 .202 .66375 .19494 .65415 .18177 Mtetra
.65415 .18177 .66375 .19494 .68357 .18783 .67406 .17457 Mtetra
.67406 .17457 .68357 .18783 .70353 .18067 .69412 .16732 Mtetra
.69412 .16732 .70353 .18067 .72363 .17346 .71432 .16001 Mtetra
.71432 .16001 .72363 .17346 .74387 .1662 .73466 .15265 Mtetra
.73466 .15265 .74387 .1662 .76426 .15888 .75515 .14524 Mtetra
.75515 .14524 .76426 .15888 .78479 .15152 .77579 .13778 Mtetra
.13655 .35365 .14841 .36469 .16491 .35872 .15311 .34761 Mtetra
.15311 .34761 .16491 .35872 .1815 .35272 .16977 .34153 Mtetra
.16977 .34153 .1815 .35272 .19821 .34668 .18653 .33542 Mtetra
.18653 .33542 .19821 .34668 .21502 .3406 .20341 .32926 Mtetra
.20341 .32926 .21502 .3406 .23195 .33448 .2204 .32307 Mtetra
.2204 .32307 .23195 .33448 .24898 .32831 .2375 .31683 Mtetra
.2375 .31683 .24898 .32831 .26613 .32211 .25472 .31055 Mtetra
.25472 .31055 .26613 .32211 .28339 .31587 .27204 .30424 Mtetra
.27204 .30424 .28339 .31587 .30077 .30959 .28949 .29787 Mtetra
.28949 .29787 .30077 .30959 .31825 .30326 .30705 .29147 Mtetra
.30705 .29147 .31825 .30326 .33586 .29689 .32472 .28502 Mtetra
.32472 .28502 .33586 .29689 .35358 .29048 .34252 .27853 Mtetra
.34252 .27853 .35358 .29048 .37143 .28403 .36043 .272 Mtetra
.36043 .272 .37143 .28403 .38939 .27753 .37847 .26542 Mtetra
.37847 .26542 .38939 .27753 .407 .28326 .39663 .2588 Mtetra
.633 .579 .775 r
.39663 .2588 .407 .28326 .425 .28543 .41491 .25213 Mtetra
.614 .516 .72 r
.41491 .25213 .425 .28543 .44337 .28175 .43332 .24542 Mtetra
.609 .501 .706 r
.43332 .24542 .44337 .28175 .46203 .27218 .45185 .23866 Mtetra
.614 .516 .72 r
.45185 .23866 .46203 .27218 .48086 .25672 .47051 .23186 Mtetra
.633 .579 .775 r
.47051 .23186 .48086 .25672 .49974 .23762 .4893 .225 Mtetra
.664 .741 .908 r
.4893 .225 .49974 .23762 .51858 .23081 .50822 .2181 Mtetra
.50822 .2181 .51858 .23081 .53755 .22395 .52728 .21116 Mtetra
.52728 .21116 .53755 .22395 .55664 .21704 .54646 .20416 Mtetra
.54646 .20416 .55664 .21704 .57587 .21008 .56578 .19712 Mtetra
.56578 .19712 .57587 .21008 .59524 .20308 .58523 .19002 Mtetra
.58523 .19002 .59524 .20308 .61474 .19603 .60482 .18288 Mtetra
.60482 .18288 .61474 .19603 .63437 .18893 .62455 .17568 Mtetra
.62455 .17568 .63437 .18893 .65415 .18177 .64442 .16844 Mtetra
.64442 .16844 .65415 .18177 .67406 .17457 .66444 .16114 Mtetra
.66444 .16114 .67406 .17457 .69412 .16732 .68459 .15379 Mtetra
.68459 .15379 .69412 .16732 .71432 .16001 .70489 .14638 Mtetra
.70489 .14638 .71432 .16001 .73466 .15265 .72533 .13893 Mtetra
.72533 .13893 .73466 .15265 .75515 .14524 .74593 .13142 Mtetra
.74593 .13142 .75515 .14524 .77579 .13778 .76667 .12385 Mtetra
.12455 .34247 .13655 .35365 .15311 .34761 .14117 .33636 Mtetra
.14117 .33636 .15311 .34761 .16977 .34153 .15789 .33021 Mtetra
.15789 .33021 .16977 .34153 .18653 .33542 .17472 .32402 Mtetra
.17472 .32402 .18653 .33542 .20341 .32926 .19166 .31779 Mtetra
.19166 .31779 .20341 .32926 .2204 .32307 .20871 .31152 Mtetra
.20871 .31152 .2204 .32307 .2375 .31683 .22588 .30521 Mtetra
.22588 .30521 .2375 .31683 .25472 .31055 .24316 .29886 Mtetra
.24316 .29886 .25472 .31055 .27204 .30424 .26056 .29246 Mtetra
.26056 .29246 .27204 .30424 .28949 .29787 .27807 .28602 Mtetra
.27807 .28602 .28949 .29787 .30705 .29147 .2957 .27954 Mtetra
.2957 .27954 .30705 .29147 .32472 .28502 .31345 .27301 Mtetra
.31345 .27301 .32472 .28502 .34252 .27853 .33132 .26644 Mtetra
.33132 .26644 .34252 .27853 .36043 .272 .3493 .25982 Mtetra
.3493 .25982 .36043 .272 .37847 .26542 .36742 .25316 Mtetra
.36742 .25316 .37847 .26542 .39663 .2588 .38565 .24646 Mtetra
.38565 .24646 .39663 .2588 .41491 .25213 .40401 .23971 Mtetra
.40401 .23971 .41491 .25213 .43332 .24542 .4225 .23291 Mtetra
.4225 .23291 .43332 .24542 .45185 .23866 .44111 .22606 Mtetra
.44111 .22606 .45185 .23866 .47051 .23186 .45986 .21917 Mtetra
.45986 .21917 .47051 .23186 .4893 .225 .47873 .21223 Mtetra
.47873 .21223 .4893 .225 .50822 .2181 .49774 .20524 Mtetra
.49774 .20524 .50822 .2181 .52728 .21116 .51687 .1982 Mtetra
.51687 .1982 .52728 .21116 .54646 .20416 .53615 .19112 Mtetra
.53615 .19112 .54646 .20416 .56578 .19712 .55555 .18398 Mtetra
.55555 .18398 .56578 .19712 .58523 .19002 .5751 .17679 Mtetra
.5751 .17679 .58523 .19002 .60482 .18288 .59478 .16955 Mtetra
.59478 .16955 .60482 .18288 .62455 .17568 .61461 .16226 Mtetra
.61461 .16226 .62455 .17568 .64442 .16844 .63457 .15492 Mtetra
.63457 .15492 .64442 .16844 .66444 .16114 .65468 .14753 Mtetra
.65468 .14753 .66444 .16114 .68459 .15379 .67493 .14008 Mtetra
.67493 .14008 .68459 .15379 .70489 .14638 .69533 .13258 Mtetra
.69533 .13258 .70489 .14638 .72533 .13893 .71588 .12502 Mtetra
.71588 .12502 .72533 .13893 .74593 .13142 .73658 .11741 Mtetra
.73658 .11741 .74593 .13142 .76667 .12385 .75742 .10974 Mtetra
.11241 .33116 .12455 .34247 .14117 .33636 .12908 .32498 Mtetra
.12908 .32498 .14117 .33636 .15789 .33021 .14586 .31876 Mtetra
.14586 .31876 .15789 .33021 .17472 .32402 .16276 .31249 Mtetra
.16276 .31249 .17472 .32402 .19166 .31779 .17976 .30618 Mtetra
.17976 .30618 .19166 .31779 .20871 .31152 .19688 .29984 Mtetra
.19688 .29984 .20871 .31152 .22588 .30521 .21411 .29345 Mtetra
.21411 .29345 .22588 .30521 .24316 .29886 .23146 .28701 Mtetra
.23146 .28701 .24316 .29886 .26056 .29246 .24893 .28054 Mtetra
.24893 .28054 .26056 .29246 .27807 .28602 .26651 .27402 Mtetra
.26651 .27402 .27807 .28602 .2957 .27954 .28421 .26745 Mtetra
.28421 .26745 .2957 .27954 .31345 .27301 .30203 .26084 Mtetra
.30203 .26084 .31345 .27301 .33132 .26644 .31997 .25419 Mtetra
.31997 .25419 .33132 .26644 .3493 .25982 .33804 .24749 Mtetra
.33804 .24749 .3493 .25982 .36742 .25316 .35622 .24075 Mtetra
.35622 .24075 .36742 .25316 .38565 .24646 .37454 .23396 Mtetra
.37454 .23396 .38565 .24646 .40401 .23971 .39298 .22712 Mtetra
.39298 .22712 .40401 .23971 .4225 .23291 .41154 .22023 Mtetra
.41154 .22023 .4225 .23291 .44111 .22606 .43024 .2133 Mtetra
.43024 .2133 .44111 .22606 .45986 .21917 .44906 .20632 Mtetra
.44906 .20632 .45986 .21917 .47873 .21223 .46802 .19929 Mtetra
.46802 .19929 .47873 .21223 .49774 .20524 .48711 .19221 Mtetra
.48711 .19221 .49774 .20524 .51687 .1982 .50634 .18508 Mtetra
.50634 .18508 .51687 .1982 .53615 .19112 .5257 .1779 Mtetra
.5257 .1779 .53615 .19112 .55555 .18398 .54519 .17067 Mtetra
.54519 .17067 .55555 .18398 .5751 .17679 .56483 .16339 Mtetra
.56483 .16339 .5751 .17679 .59478 .16955 .58461 .15605 Mtetra
.58461 .15605 .59478 .16955 .61461 .16226 .60453 .14867 Mtetra
.60453 .14867 .61461 .16226 .63457 .15492 .62459 .14123 Mtetra
.62459 .14123 .63457 .15492 .65468 .14753 .64479 .13374 Mtetra
.64479 .13374 .65468 .14753 .67493 .14008 .66515 .12619 Mtetra
.66515 .12619 .67493 .14008 .69533 .13258 .68565 .11859 Mtetra
.68565 .11859 .69533 .13258 .71588 .12502 .7063 .11093 Mtetra
.7063 .11093 .71588 .12502 .73658 .11741 .7271 .10321 Mtetra
.7271 .10321 .73658 .11741 .75742 .10974 .74805 .09544 Mtetra
.10011 .31972 .11241 .33116 .12908 .32498 .11685 .31346 Mtetra
.11685 .31346 .12908 .32498 .14586 .31876 .13369 .30716 Mtetra
.13369 .30716 .14586 .31876 .16276 .31249 .15065 .30082 Mtetra
.15065 .30082 .16276 .31249 .17976 .30618 .16772 .29443 Mtetra
.16772 .29443 .17976 .30618 .19688 .29984 .1849 .28801 Mtetra
.1849 .28801 .19688 .29984 .21411 .29345 .2022 .28154 Mtetra
.2022 .28154 .21411 .29345 .23146 .28701 .21962 .27502 Mtetra
.21962 .27502 .23146 .28701 .24893 .28054 .23715 .26847 Mtetra
.23715 .26847 .24893 .28054 .26651 .27402 .2548 .26186 Mtetra
.2548 .26186 .26651 .27402 .28421 .26745 .27258 .25522 Mtetra
.27258 .25522 .28421 .26745 .30203 .26084 .29047 .24853 Mtetra
.29047 .24853 .30203 .26084 .31997 .25419 .30848 .24179 Mtetra
.30848 .24179 .31997 .25419 .33804 .24749 .32662 .235 Mtetra
.32662 .235 .33804 .24749 .35622 .24075 .34489 .22817 Mtetra
.34489 .22817 .35622 .24075 .37454 .23396 .36328 .2213 Mtetra
.36328 .2213 .37454 .23396 .39298 .22712 .3818 .21437 Mtetra
.3818 .21437 .39298 .22712 .41154 .22023 .40044 .2074 Mtetra
.40044 .2074 .41154 .22023 .43024 .2133 .41922 .20037 Mtetra
.41922 .20037 .43024 .2133 .44906 .20632 .43813 .1933 Mtetra
.43813 .1933 .44906 .20632 .46802 .19929 .45717 .18618 Mtetra
.45717 .18618 .46802 .19929 .48711 .19221 .47635 .17901 Mtetra
.47635 .17901 .48711 .19221 .50634 .18508 .49566 .17179 Mtetra
.49566 .17179 .50634 .18508 .5257 .1779 .51511 .16451 Mtetra
.51511 .16451 .5257 .1779 .54519 .17067 .5347 .15719 Mtetra
.5347 .15719 .54519 .17067 .56483 .16339 .55443 .14981 Mtetra
.55443 .14981 .56483 .16339 .58461 .15605 .5743 .14238 Mtetra
.5743 .14238 .58461 .15605 .60453 .14867 .59431 .13489 Mtetra
.59431 .13489 .60453 .14867 .62459 .14123 .61447 .12735 Mtetra
.61447 .12735 .62459 .14123 .64479 .13374 .63478 .11976 Mtetra
.63478 .11976 .64479 .13374 .66515 .12619 .65523 .11211 Mtetra
.65523 .11211 .66515 .12619 .68565 .11859 .67583 .1044 Mtetra
.67583 .1044 .68565 .11859 .7063 .11093 .69659 .09664 Mtetra
.69659 .09664 .7063 .11093 .7271 .10321 .71749 .08882 Mtetra
.71749 .08882 .7271 .10321 .74805 .09544 .73856 .08095 Mtetra
.08767 .30813 .10011 .31972 .11685 .31346 .10446 .30179 Mtetra
.10446 .30179 .11685 .31346 .13369 .30716 .12137 .29542 Mtetra
.12137 .29542 .13369 .30716 .15065 .30082 .13839 .289 Mtetra
.13839 .289 .15065 .30082 .16772 .29443 .15553 .28253 Mtetra
.15553 .28253 .16772 .29443 .1849 .28801 .17278 .27603 Mtetra
.17278 .27603 .1849 .28801 .2022 .28154 .19014 .26948 Mtetra
.19014 .26948 .2022 .28154 .21962 .27502 .20763 .26288 Mtetra
.20763 .26288 .21962 .27502 .23715 .26847 .22523 .25624 Mtetra
.22523 .25624 .23715 .26847 .2548 .26186 .24295 .24956 Mtetra
.24295 .24956 .2548 .26186 .27258 .25522 .26079 .24283 Mtetra
.26079 .24283 .27258 .25522 .29047 .24853 .27876 .23605 Mtetra
.27876 .23605 .29047 .24853 .30848 .24179 .29685 .22923 Mtetra
.29685 .22923 .30848 .24179 .32662 .235 .31507 .22236 Mtetra
.31507 .22236 .32662 .235 .34489 .22817 .33341 .21544 Mtetra
.33341 .21544 .34489 .22817 .36328 .2213 .35188 .20847 Mtetra
.35188 .20847 .36328 .2213 .3818 .21437 .37047 .20146 Mtetra
.37047 .20146 .3818 .21437 .40044 .2074 .3892 .19439 Mtetra
.3892 .19439 .40044 .2074 .41922 .20037 .40806 .18728 Mtetra
.40806 .18728 .41922 .20037 .43813 .1933 .42705 .18012 Mtetra
.42705 .18012 .43813 .1933 .45717 .18618 .44618 .1729 Mtetra
.44618 .1729 .45717 .18618 .47635 .17901 .46544 .16563 Mtetra
.46544 .16563 .47635 .17901 .49566 .17179 .48484 .15832 Mtetra
.48484 .15832 .49566 .17179 .51511 .16451 .50438 .15095 Mtetra
.50438 .15095 .51511 .16451 .5347 .15719 .52406 .14352 Mtetra
.52406 .14352 .5347 .15719 .55443 .14981 .54389 .13605 Mtetra
.54389 .13605 .55443 .14981 .5743 .14238 .56385 .12852 Mtetra
.56385 .12852 .5743 .14238 .59431 .13489 .58396 .12093 Mtetra
.58396 .12093 .59431 .13489 .61447 .12735 .60422 .11329 Mtetra
.60422 .11329 .61447 .12735 .63478 .11976 .62462 .10559 Mtetra
.62462 .10559 .63478 .11976 .65523 .11211 .64518 .09784 Mtetra
.64518 .09784 .65523 .11211 .67583 .1044 .66588 .09003 Mtetra
.66588 .09003 .67583 .1044 .69659 .09664 .68674 .08216 Mtetra
.68674 .08216 .69659 .09664 .71749 .08882 .70776 .07424 Mtetra
.70776 .07424 .71749 .08882 .73856 .08095 .72893 .06625 Mtetra
.07507 .2964 .08767 .30813 .10446 .30179 .09193 .28999 Mtetra
.09193 .28999 .10446 .30179 .12137 .29542 .1089 .28353 Mtetra
.1089 .28353 .12137 .29542 .13839 .289 .12598 .27703 Mtetra
.12598 .27703 .13839 .289 .15553 .28253 .14318 .27049 Mtetra
.14318 .27049 .15553 .28253 .17278 .27603 .1605 .2639 Mtetra
.1605 .2639 .17278 .27603 .19014 .26948 .17793 .25727 Mtetra
.17793 .25727 .19014 .26948 .20763 .26288 .19548 .25059 Mtetra
.19548 .25059 .20763 .26288 .22523 .25624 .21316 .24387 Mtetra
.21316 .24387 .22523 .25624 .24295 .24956 .23095 .2371 Mtetra
.23095 .2371 .24295 .24956 .26079 .24283 .24886 .23028 Mtetra
.24886 .23028 .26079 .24283 .27876 .23605 .2669 .22342 Mtetra
.2669 .22342 .27876 .23605 .29685 .22923 .28507 .21651 Mtetra
.28507 .21651 .29685 .22923 .31507 .22236 .30336 .20955 Mtetra
.30336 .20955 .31507 .22236 .33341 .21544 .32178 .20254 Mtetra
.32178 .20254 .33341 .21544 .35188 .20847 .34033 .19548 Mtetra
.34033 .19548 .35188 .20847 .37047 .20146 .359 .18838 Mtetra
.359 .18838 .37047 .20146 .3892 .19439 .37781 .18122 Mtetra
.37781 .18122 .3892 .19439 .40806 .18728 .39675 .17401 Mtetra
.39675 .17401 .40806 .18728 .42705 .18012 .41583 .16676 Mtetra
.41583 .16676 .42705 .18012 .44618 .1729 .43505 .15945 Mtetra
.43505 .15945 .44618 .1729 .46544 .16563 .4544 .15208 Mtetra
.4544 .15208 .46544 .16563 .48484 .15832 .47389 .14467 Mtetra
.47389 .14467 .48484 .15832 .50438 .15095 .49352 .1372 Mtetra
.49352 .1372 .50438 .15095 .52406 .14352 .51329 .12968 Mtetra
.51329 .12968 .52406 .14352 .54389 .13605 .5332 .1221 Mtetra
.5332 .1221 .54389 .13605 .56385 .12852 .55326 .11447 Mtetra
.55326 .11447 .56385 .12852 .58396 .12093 .57347 .10678 Mtetra
.57347 .10678 .58396 .12093 .60422 .11329 .59383 .09904 Mtetra
.59383 .09904 .60422 .11329 .62462 .10559 .61433 .09124 Mtetra
.61433 .09124 .62462 .10559 .64518 .09784 .63499 .08338 Mtetra
.63499 .08338 .64518 .09784 .66588 .09003 .6558 .07546 Mtetra
.6558 .07546 .66588 .09003 .68674 .08216 .67676 .06748 Mtetra
.67676 .06748 .68674 .08216 .70776 .07424 .69788 .05945 Mtetra
.69788 .05945 .70776 .07424 .72893 .06625 .71916 .05135 Mtetra
.06232 .28453 .07507 .2964 .09193 .28999 .07924 .27803 Mtetra
.07924 .27803 .09193 .28999 .1089 .28353 .09627 .2715 Mtetra
.09627 .2715 .1089 .28353 .12598 .27703 .11342 .26492 Mtetra
.11342 .26492 .12598 .27703 .14318 .27049 .13068 .25829 Mtetra
.13068 .25829 .14318 .27049 .1605 .2639 .14807 .25162 Mtetra
.14807 .25162 .1605 .2639 .17793 .25727 .16557 .2449 Mtetra
.16557 .2449 .17793 .25727 .19548 .25059 .18319 .23814 Mtetra
.18319 .23814 .19548 .25059 .21316 .24387 .20093 .23133 Mtetra
.20093 .23133 .21316 .24387 .23095 .2371 .21879 .22448 Mtetra
.21879 .22448 .23095 .2371 .24886 .23028 .23678 .21757 Mtetra
.23678 .21757 .24886 .23028 .2669 .22342 .2549 .21062 Mtetra
.2549 .21062 .2669 .22342 .28507 .21651 .27313 .20362 Mtetra
.27313 .20362 .28507 .21651 .30336 .20955 .2915 .19657 Mtetra
.2915 .19657 .30336 .20955 .32178 .20254 .31 .18947 Mtetra
.31 .18947 .32178 .20254 .34033 .19548 .32862 .18232 Mtetra
.32862 .18232 .34033 .19548 .359 .18838 .34738 .17513 Mtetra
.34738 .17513 .359 .18838 .37781 .18122 .36627 .16788 Mtetra
.36627 .16788 .37781 .18122 .39675 .17401 .3853 .16057 Mtetra
.3853 .16057 .39675 .17401 .41583 .16676 .40446 .15322 Mtetra
.40446 .15322 .41583 .16676 .43505 .15945 .42376 .14581 Mtetra
.42376 .14581 .43505 .15945 .4544 .15208 .4432 .13835 Mtetra
.4432 .13835 .4544 .15208 .47389 .14467 .46278 .13084 Mtetra
.46278 .13084 .47389 .14467 .49352 .1372 .4825 .12327 Mtetra
.4825 .12327 .49352 .1372 .51329 .12968 .50237 .11565 Mtetra
.50237 .11565 .51329 .12968 .5332 .1221 .52238 .10797 Mtetra
.52238 .10797 .5332 .1221 .55326 .11447 .54253 .10023 Mtetra
.54253 .10023 .55326 .11447 .57347 .10678 .56284 .09244 Mtetra
.56284 .09244 .57347 .10678 .59383 .09904 .58329 .08459 Mtetra
.58329 .08459 .59383 .09904 .61433 .09124 .6039 .07668 Mtetra
.6039 .07668 .61433 .09124 .63499 .08338 .62466 .06871 Mtetra
.62466 .06871 .63499 .08338 .6558 .07546 .64557 .06069 Mtetra
.64557 .06069 .6558 .07546 .67676 .06748 .66664 .0526 Mtetra
.66664 .0526 .67676 .06748 .69788 .05945 .68788 .04445 Mtetra
.68788 .04445 .69788 .05945 .71916 .05135 .70927 .03624 Mtetra
.04941 .27251 .06232 .28453 .07924 .27803 .06639 .26593 Mtetra
.06639 .26593 .07924 .27803 .09627 .2715 .08349 .25931 Mtetra
.08349 .25931 .09627 .2715 .11342 .26492 .1007 .25265 Mtetra
.1007 .25265 .11342 .26492 .13068 .25829 .11803 .24594 Mtetra
.11803 .24594 .13068 .25829 .14807 .25162 .13548 .23918 Mtetra
.13548 .23918 .14807 .25162 .16557 .2449 .15304 .23238 Mtetra
.15304 .23238 .16557 .2449 .18319 .23814 .17073 .22553 Mtetra
.17073 .22553 .18319 .23814 .20093 .23133 .18855 .21864 Mtetra
.18855 .21864 .20093 .23133 .21879 .22448 .20648 .21169 Mtetra
.20648 .21169 .21879 .22448 .23678 .21757 .22454 .2047 Mtetra
.22454 .2047 .23678 .21757 .2549 .21062 .24273 .19766 Mtetra
.24273 .19766 .2549 .21062 .27313 .20362 .26105 .19057 Mtetra
.26105 .19057 .27313 .20362 .2915 .19657 .27949 .18343 Mtetra
.27949 .18343 .2915 .19657 .31 .18947 .29806 .17624 Mtetra
.29806 .17624 .31 .18947 .32862 .18232 .31677 .16899 Mtetra
.31677 .16899 .32862 .18232 .34738 .17513 .33561 .1617 Mtetra
.33561 .1617 .34738 .17513 .36627 .16788 .35458 .15435 Mtetra
.35458 .15435 .36627 .16788 .3853 .16057 .37369 .14696 Mtetra
.37369 .14696 .3853 .16057 .40446 .15322 .39294 .1395 Mtetra
.39294 .1395 .40446 .15322 .42376 .14581 .41233 .132 Mtetra
.41233 .132 .42376 .14581 .4432 .13835 .43186 .12444 Mtetra
.43186 .12444 .4432 .13835 .46278 .13084 .45153 .11682 Mtetra
.45153 .11682 .46278 .13084 .4825 .12327 .47134 .10915 Mtetra
.47134 .10915 .4825 .12327 .50237 .11565 .4913 .10143 Mtetra
.4913 .10143 .50237 .11565 .52238 .10797 .5114 .09364 Mtetra
.5114 .09364 .52238 .10797 .54253 .10023 .53165 .0858 Mtetra
.53165 .0858 .54253 .10023 .56284 .09244 .55206 .0779 Mtetra
.55206 .0779 .56284 .09244 .58329 .08459 .57261 .06994 Mtetra
.57261 .06994 .58329 .08459 .6039 .07668 .59332 .06193 Mtetra
.59332 .06193 .6039 .07668 .62466 .06871 .61419 .05385 Mtetra
.61419 .05385 .62466 .06871 .64557 .06069 .63521 .04571 Mtetra
.63521 .04571 .64557 .06069 .66664 .0526 .65639 .03751 Mtetra
.65639 .03751 .66664 .0526 .68788 .04445 .67773 .02925 Mtetra
.67773 .02925 .68788 .04445 .70927 .03624 .69923 .02092 Mtetra
.03634 .26033 .04941 .27251 .06639 .26593 .05338 .25368 Mtetra
.05338 .25368 .06639 .26593 .08349 .25931 .07054 .24697 Mtetra
.07054 .24697 .08349 .25931 .1007 .25265 .08782 .24023 Mtetra
.08782 .24023 .1007 .25265 .11803 .24594 .10521 .23343 Mtetra
.10521 .23343 .11803 .24594 .13548 .23918 .12273 .22659 Mtetra
.12273 .22659 .13548 .23918 .15304 .23238 .14036 .2197 Mtetra
.14036 .2197 .15304 .23238 .17073 .22553 .15812 .21276 Mtetra
.15812 .21276 .17073 .22553 .18855 .21864 .176 .20578 Mtetra
.176 .20578 .18855 .21864 .20648 .21169 .19401 .19875 Mtetra
.19401 .19875 .20648 .21169 .22454 .2047 .21215 .19166 Mtetra
.21215 .19166 .22454 .2047 .24273 .19766 .23041 .18453 Mtetra
.23041 .18453 .24273 .19766 .26105 .19057 .2488 .17735 Mtetra
.2488 .17735 .26105 .19057 .27949 .18343 .26732 .17011 Mtetra
.26732 .17011 .27949 .18343 .29806 .17624 .28597 .16283 Mtetra
.28597 .16283 .29806 .17624 .31677 .16899 .30476 .15549 Mtetra
.30476 .15549 .31677 .16899 .33561 .1617 .32368 .1481 Mtetra
.32368 .1481 .33561 .1617 .35458 .15435 .34274 .14065 Mtetra
.34274 .14065 .35458 .15435 .37369 .14696 .36193 .13316 Mtetra
.36193 .13316 .37369 .14696 .39294 .1395 .38127 .12561 Mtetra
.38127 .12561 .39294 .1395 .41233 .132 .40074 .118 Mtetra
.40074 .118 .41233 .132 .43186 .12444 .42036 .11034 Mtetra
.42036 .11034 .43186 .12444 .45153 .11682 .44012 .10262 Mtetra
.44012 .10262 .45153 .11682 .47134 .10915 .46002 .09484 Mtetra
.46002 .09484 .47134 .10915 .4913 .10143 .48008 .08701 Mtetra
.48008 .08701 .4913 .10143 .5114 .09364 .50028 .07912 Mtetra
.50028 .07912 .5114 .09364 .53165 .0858 .52063 .07117 Mtetra
.52063 .07117 .53165 .0858 .55206 .0779 .54113 .06316 Mtetra
.54113 .06316 .55206 .0779 .57261 .06994 .56179 .05509 Mtetra
.56179 .05509 .57261 .06994 .59332 .06193 .5826 .04697 Mtetra
.5826 .04697 .59332 .06193 .61419 .05385 .60357 .03878 Mtetra
.60357 .03878 .61419 .05385 .63521 .04571 .6247 .03052 Mtetra
.6247 .03052 .63521 .04571 .65639 .03751 .64598 .02221 Mtetra
.64598 .02221 .65639 .03751 .67773 .02925 .66743 .01383 Mtetra
.66743 .01383 .67773 .02925 .69923 .02092 .68905 .00539 Mtetra
0 g
.68874 0 m
.96935 .42924 L
s
.96935 .42924 m
1 .6535 L
s
1 .6535 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.03716 .25514 m
0 .48963 L
s
0 .48963 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.68874 0 m
.03716 .25514 L
s
.03716 .25514 m
.68874 0 L
s
.03716 .25514 m
.04196 .25962 L
s
[(-2)] .02757 .24618 1 .93395 Mshowa
.18558 .19702 m
.19014 .20174 L
s
[(-1)] .17646 .18758 .96648 1 Mshowa
.34306 .13535 m
.34735 .14032 L
s
[(0)] .3345 .12542 .86223 1 Mshowa
.51046 .06981 m
.51442 .07504 L
s
[(1)] .50253 .05935 .75799 1 Mshowa
.68874 0 m
.69233 .00549 L
s
[(2)] .68156 -0.01098 .65374 1 Mshowa
.125 Mabswid
.06616 .24378 m
.06901 .2465 L
s
.09549 .2323 m
.09832 .23504 L
s
.12517 .22067 m
.12797 .22345 L
s
.1552 .20892 m
.15797 .21172 L
s
.21633 .18498 m
.21903 .18784 L
s
.24744 .1728 m
.25012 .17569 L
s
.27893 .16047 m
.28157 .16339 L
s
.3108 .14799 m
.31341 .15094 L
s
.37572 .12257 m
.37826 .12558 L
s
.40878 .10962 m
.41128 .11266 L
s
.44225 .09652 m
.44471 .09959 L
s
.47614 .08324 m
.47856 .08635 L
s
.54521 .0562 m
.54755 .05937 L
s
.58041 .04242 m
.5827 .04562 L
s
.61605 .02846 m
.6183 .03169 L
s
.65216 .01432 m
.65436 .01759 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 233.562},
  ImageMargins->{{35, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000j@P10`4000010?ooobl_;oooZZVYZNSX
j?oo05FZZZZZZ_nZZS/k>gYjN[Vi^OShn03ooeGooj[ooonI<c<c<fi^KZf][Nc/k02ZoeFZojZZoonZ
oclo?ginO[fm_Oclo5D00:X00?l00?l0VCLg=g9bL[6a/O3`l03o05Go0:[o00<30d92@X61PL30`000
EED0EJX0EOl0ELbIoc/k>gIfM[Fe]OCdm03oEEGoEJ[oE@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0Z/`c
<clo?gYjN[Vi^OShn03oZUGoZZ[oZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`<30d92@WinO[fm_Ocl
o03ooeGooj[oo`l?3di>CXf=SLc<c01E05EE0:YE0?mE00L71dI6AX61PL30`000EED00:X00?l001<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@/;2dY:BXF5QLC4a000ZUD0EJX0EOl0EALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZPl?3di>CXV9RLS8b000oeD0ZZX0Z_l0ZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEoa<C
4e9BDXf=SLc<c01E05D0ojX0ool0oalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ01LG5eIFEY6ATM3@d01E
EEEE0:YE0?mE02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZEA/K6eYJFYFEUMCDe01EZUEEEJYEEOmEEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZQlO7eiNGYVIVMSHf01EoeEEZZYEZ_mEZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZob<S8f9RHYfMWMcLg02Z05EEojYEoomEobl_;fi^KZf][Nc/k03o05Go0:[o0=gW1RLW
9fIVIZ6QXN3Ph02ZEEFZ0:ZZ0?nZ03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooEB/[:fYZJZFUYNCTi02Z
ZUFZEJZZEOnZECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l08@000?l08@000?l08@000?l08@000?l0
8@000<H01?mF0000aP000ol0001G0000a`000ol0001F0000b0000ol0001E0000b@000ol0001D0000
aP001?l00?l<00CoAP000<L00_l=0003o`0004L0003G0003o`0004H0003@00Co10000ol000150000
f@000ol000140000eP001?l00?m60000b`02o`X00_m70000b003o`030?l00580003600;o1002oe80
003300?o1@0011Oo0?mA0000`@02o`D000LGJaM[o`3o0540002n00?o0P003Ol05f/GJaM[5olG0?l0
D0000;`00_l4000?5f/GJaM[5f/GJom[5`3o04l0002i00?o10003f/GJaM[5f/GJaM[5olGJ`02odl0
002G00Co6`04o`<001E[5f/GJaM[5f/GJaM[5f_oJaM[0?l0CP0009T000?o00006002o`@001Ko5f/G
JaM[5f/GJaM[5f/GJaM[of/G0P000ol0001;0000V@000ol0000E00?o0`0076/GJaM[5f/GJaM[5f/G
JaM[5f/GJaOo5f/G0?m=0000V@000ol0000C00;o100071M[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJom[
5f/20003o`0004X0002I0003o`0001000ol09@3o01M[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5olG
JaM[0?l0C00009L00ol@00;o0`009QM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJom[5f/GJ`3o
B`0009T000?o00002`03o`<002M[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5olGJaM[5f/0
0_m:0000Y@02o`D002Y[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f_oJaM[5f/G0?m:0000
XP03o`80033o000GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5olGJaM[5f/G0?m90000
X002o`D002hGJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJom[5f/GJaM[0P000ol0
00160000W@03o`@003@GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5olGJaM[
5f/GJ`3oB00009/00ol3000h5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[
5f_oJaM[5f/GJaM[0?m70000V003o`<003coJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[
5f/GJaM[5f/GJaM[5olGJaM[5f/GJaM[0?m60000U@03o`@003i[5f/GJaM[5f/GJaM[5f/GJaM[5f/G
JaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[of/GJaM[5f/GJaM[odH0002C00;o1@00@AM[5f/GJaM[
5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5olGJaM[5f/GJaM[5`3o04D0
002@00?o0P00Aol05f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[
5f/GJaM[of/GJaM[5f/GJaM[5`3o04@0002>00;o1000B1M[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[
5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5olGJaM[5f/GJaM[5f/0od@0001/00;o7@03o`<0
04`GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[
5f/GoaM[5f/GJaM[5f/GJ`3o@`0006/000Co003o6P02o`1@0?l006/GJaM[5f/GJaM[5f/GJaM[5f/G
JaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJom[5f/GJaM[5f/GJaL20003
o`000400001[0004o`00oaL00ol3001@JaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/G
JaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GoaM[5f/GJaM[5f/GJaL2o`h01?l`0000J`001?l0
0?lE00;o1000EAM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[
5f/GJaM[5f/GJaM[5f/GJaM[of/GJaM[5f/GJaM[5f/G0?l03`000ol0000_0000J`001?l00?lB00?o
0`00FAM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[
5f/GJaM[5f/GJaM[5f/GoaM[5f/GJaM[5f/GJaM[5`3o00h000?o0000;`0006/000Co003o4002o`80
05go06/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/G
JaM[5f/GJaM[5f/GJaM[5f_oJaM[5f/GJaM[5f/GJaM[0?l01P04o`@000?o0000;`0006`00_l>00?o
0`00Gf/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/G
JaM[5f/GJaM[5f/GJaM[5f/GJaOo5f/GJaM[5f/GJaM[5f/GJ`3o00d000?o0000;`0007X00_l4001O
5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[
5f/GJaM[5f/GJaM[5f/GJaM[of/GJaM[5f/GJaM[5f/GJaL00P000ol0000800?o<@0007L00ol0J03o
01M[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/G
JaM[5f/GJaM[5f/GJaM[5f/GJaM[5olGJaM[5f/GJaM[5f/GJaM[5`3o30000ol0000_0000M003o`@0
06Q[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/G
JaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJom[5f/GJaM[5f/GJaM[5f/GJaL0ocd0001b00;o1000Jf/G
JaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/G
JaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GoaM[5f/GJaM[5f/GJaM[5f/GJaOo03d0001_00Co0`00KQM[
5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[
5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f_oJaM[5f/GJaM[5f/GJaM[5f/GJaOo?00006d00_l4001b
of/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[
5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5olGJaM[5f/GJaM[5f/GJaM[5f/GJ`3o>`0006X0
0ol4001dJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/G
JaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[of/GJaM[5f/GJaM[5f/GJaM[5f/G
Jolk0000J002o`@007I[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/G
JaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaOo5f/GJaM[5f/G
JaM[5f/GJaM[5f/G0_lj0000I@03o`8007go01M[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[
5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[
5f/GJaM[of/GJaM[5f/GJaM[5f/GJaM[5f/GJaL0o`0i0000@@04oah00_l4001n5f/GJaM[5f/GJaM[
5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[
5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[of/GJaM[5f/GJaM[5f/GJaM[5f/GJ`3o>@0004<0
00?o00006P03o`@0085[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/G
JaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5olG
JaM[5f/GJaM[5f/GJaM[5f/GJaM[0?l0>00004<000?o00006002o`8008Oo06/GJaM[5f/GJaM[5f/G
JaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/G
JaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[of/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[0?l0
=`0003/01?l40003o`0001D00ol400275f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[
5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[
5f/GJaM[5f/GJaM[5olGJaM[5f/GJaM[5f/GJaM[5f/GJaM[5`3o03L000130003o`0001<00_l40029
5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[
5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJom[5f/GJaM[
5f/GJaM[5f/GJaM[5f/GJaL00_lf0000@@03oa801?l3002>JaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/G
JaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/G
JaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GoaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaL0ocD0
00130003o`0000d00ol4002AJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/G
JaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/G
JaM[5f/GJaM[5f/GJaM[of/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/Go`0e0000D@02o`@009E[5f/G
JaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/G
JaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaOo5f/G
JaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/0o`0d0000CP04o`2K01M[5f/GJaM[5f/GJaM[5f/GJaM[5f/G
JaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/G
JaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f_oJaM[5f/GJaM[5f/GJaM[5f/G
JaM[5f/GJaM[0?l0<`0004`00_l2002M5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[
5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[
5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5olGJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[
o`0c0000B@03o`8009i[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/G
JaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/G
JaM[5f/GJaM[5f/GJaM[5f/GJaM[5f_oJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5`;o<P0004L0
0ol2002S5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[
5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[
5f/GJaM[5f/GJaM[5f/GJaOo5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaL0o`0a0000A003o`<0
0:Go5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/G
JaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/G
JaM[5f/GJaM[5f/GJaM[of/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[0?l0<@0004800_l3002Y
JaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/G
JaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/G
JaM[5f/GJaM[5f/GJaM[5olGJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/0o`0`0000?`03o`<0
0:TGJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[
5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[
5f/GJaM[5f/GJaM[5f/GJaM[5f_oJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/G008000?o0000
;@0003d00_l2002`oaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/G
JaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/G
JaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5olGJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/G
JaM[5f/G0?l_00006P04oa`00ol3002`JaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/G
JaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/G
JaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GoaM[5f/GJaM[5f/G
JaM[5f/GJaM[5f/GJaM[5f/GJaL2o`P00_lT00006P000ol0000K00;o1000]1M[5f/GJaM[5f/GJaM[
5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[
5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[
5f/GJaM[5f/GJaM[of/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/0o`L000Co003o8`0001/0
00?o00005`03o`2k0?l05f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/G
JaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/G
JaM[5f/GJaM[5f/GTaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaOo5f/GJaM[5f/GJaM[5f/G
JaM[5f/GJaM[5f/GJaM[5f/0o`060004o`00ob<0000D00Co10000ol0000C00?o0P00Gf/GJaM[5f/G
JaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/G
JaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[008G05cRJaM[5f/GJaM[5hkBJaM[5f/GJaN35h<GPaM[
5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJom[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[
5f/0o`D000Co003o8`0001d000?o00004002o`<00;lGJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[
5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[
5f/GJaM[5hk2S/:>`V/GJaM[5m9ZdV[BJV/GJaM[LY<GTaNC5i<GJaM[5f/GJaM[5f/GJaM[5f/GJaM[
5f/GJaM[5olGJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaL0o`050004o`00ob<0000J0004
o`00o`l00ol20033of/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[
5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[dQOR5n8GhQORJaMn
/XkBS]:>dXkBJl9n`Wk2PaN35h<GPaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f_oJaM[5f/GJaM[
5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5`3o00@000Co003o8`0001/00_l>00;o0`00aV/GJaM[5f/G
JaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/G
JaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[T]:BdY:>`Xk2S/:>OPIn1WkBJ]9ZdV[BLXibSW:>LY<G
TaNCTV/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaOo5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/G
JaM[5f/GJaL0o`@00_lT0000:003o`<006`GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[
5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[
dWkBS]:>dXkR5n8GhQL2OP0c/WjbO]:>dXkBS]9n`Wk2O/9n`X?2O/9n`V/GJaM[dXhGJaM[5f/GJaM[
5f/GJaM[5f/G00;o02E[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaOo02X0000V00;o
0P00L?lGJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/G
JaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaOBTQNB5i8GT]:BdY;B`Xk2S]82OP0`
1Wh6O]9ZdV[BJPSBSW:>LXibSY:>TXjBSY9[J]9ZdV[B5f/GJaM[5f/GJaM[5f/G0ol0:1Oo5f/GJaM[
5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[0?lY00008`03o`800:4GJaM[5f/GJaM[5f/GJaM[
5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[
5f/GJaM[5f/GJaM[5f/GJaN>dXkBO]9ndWkBS]:>dXkB5n8GO^9nh[9n/WjbS]:>dWkbO/9n`Wk2O/9n
`Wk2O/9ndXkBS]:>dXhGJaM[5f/GJaM[5`03o`0/5f/GJaOo5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[
5f/GJaM[5f/GJaM[0?lX00008P02o`2R01M[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/G
JaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f_2
dY;BT]:B5i8GTQNBdY;BT]:BS]9ndWkB1Wh6OPIZdVX8dPSBSW:>LXiblY:>TXjBSY8[J]9ZdV[BJV/G
JaM[5f/G0ol0;aM[5f/GJaM[5olGJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f_o02P0
000R00;o05`GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[
5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJ`8G01;R5n:>dXkBS]9ndWkBO]:>
dXh2dP0]O^9nhWkR/WjbO[:>dXkbO_9n`Wk2O/9nlPS2O/9n`PSbS]:>dXkBS]Y[5f/G00?o034GJaM[
5f/GJaM[5f/GoaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/G00;o9`0001X00_l6001c
oaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/G
JaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5hk2S/:>T]:BdY8GTQNB5i;BT]:B`P02OP0;
dWkBO]86OPIn1Wh00]8060SB2=88LXibSWkbOXjBSY:>OR]ZdV[BJP;B00<[5ol00_l0=aN>5f/GJaM[
5f/GJaM[5f_oJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/G0?l09P0001T000Co003o
1@00G_l05f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[
5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/25`0@hQORS]:>dXkBO]9ndWkBSP;B
02UndWkRO^9nh[9n/WjbO_9nlWkbO_9n`Wk22?88`Wk2O_88lPSBS]:>fP03o`8G00?R5n800QL0<f/G
JaM[5f/GJaM[5f_oJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/Go`0V00006@001?l0
0?l400;o0P00L1M[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[
5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[`Xk2S/;BT]:BdY8GTQNB5i;2
O/82OP0SdWkBO]86OPIn1Wh8dPSB2=88LXiblWkbOXjBSY8[OR]ndVX00ol0?]8[dXkBS]:>dXhGJaM[
5f/GJaM[5f/GJom[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJ`3o9@0001T000Co003o
1000Gol0001[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/G
JaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[008G03KR5n8GdXkBS]9ndWkBO/;B
O]9ndWkRO^9nh[9n/WjbO_9nlWkbO_9n`Wkb2?88`Wk22?88lPP2o`05dPSJ2=X00PP0>aOR5n8GhR/G
JaM[5f/GJaM[5f/GoaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJ`3o02@0000I0004
o`00o`@00_l3001fJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/G
JaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaN>`Xk2dY;BT]:B5i9bOW9n
`Wk2O/;BO]9ndP9n01L6OPSB2=88dPSB2=:>O_9nlWkbTXin:`03o`13:f[BdR_B:`SJdXkBS]:>:glG
JaM[5f/GJaM[5f/GoaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJ`02ob<0000I0004
o`00o`@000?o00000`00MF/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/G
JaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f_BSWenOF_R5n8GhXkBS]:>dWk2
O/;BO]9ndWkRO^9nhP02OP0D/WkbO_9nlWkbO_9n`PSb2?88lWh3o`092?88lXkJ2=X800;J00H8f^8G
hQL4:`0c5f/GJaM[5f/GJaM[5olGJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5`3o02<0
000J00;o1@000ol00004001dJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/G
JaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[J]9ZdVYmnGgiOY9nTXjBdY86OW9n
LWibO/9n`Wk2dWkBO]82OP0A1]88dPSB2=88dPSBlWkbO_800ol0C2]n:gh[OR_B:m8[dR/8fPR>dXh[
Ob]o:f/GJaM[5f/GJaM[5f/GoaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/G0?lR0000
8002o`P005LGJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[
5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJm:>dXimOWd00Wh03WenOGhZORYn:/9n`Wk20Wh02M9n
dWkRO^9nhP02OP0>lWkbO_9nlWkbO_9nlPP3o`0>2?88lPSb2?88lPSJ2=X22005fPSJ21L01b/0<f/G
JaM[5f/GJaM[5f_oJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/Go`0R000080000ol0
0008001K5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[
5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5m9ZdV[BnGgiOI9nTP02OP0Q1Wh6OW9nLWibO/9n`Wk2dWkB
O]9ndPSB2=88dPSB2=8800?o05?bO_9nlWh[OR]n:gkB22_B:m;J2=X8fR]o:gl[Ok<[/f/GJaM[5f/G
JaM[5f_oJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/0o`0Q000080000ol00009001F
5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[
5f/GJaM[5f/GJaM[5f/GJaM[dXkBS]9nOGh2O@0=OWenOGhZOR[2O/9n`P02OP09dWkBO^9nhWkR009n
00SbO_9nlWkbOP?o00iolPSb2?88lPSb2?88lP8800?RfPP00]X01@SJ2=X800H[03L8:`PGJaM[5f/G
JaM[5f/GJom[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJ`3o0200000P00;o2`00JQM[
5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[
5f/GJaM[5f/GJaM[5f/GJf[BJ];iOOUmTWjBOY86OPIn1WibOW9n`Wk2O/82OP0:dWkBO^88dPSB20?o
05X8d_;RlWkbO_9n27h[OR]n:`SB22_B:`SJ2=X8:`Qo:gnc:k<[/i<GJaM[5f/GJaM[5f/GoaM[5f/G
JaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJolP000080000ol0000;00195f/GJaM[5f/GJaM[
5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[
5`02O@09JaN>dXkBOWen009m00QnOGimORYn:P9n00?2O/800Wh01m9ndWkBO^800Wh01O9nlWkb00;o
01QnlWkbOo9olPSb2?88lPSb2?88l^88h]X22006fPSJ2=X812/0>PP[22/2/`8GJaM[5f/GJaM[5f/G
oaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/G0?lO00008002o`d004PGJaM[5f/GJaM[
5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaNC
5i<3O@0MJf[BJ];iOOUmTWjBOY86OPIn1WibOW9n`Wk2O/800Wh01M9nhWkR00?o01WB2=88dPSRl^;b
h_9nlWh8OPQn:gkB2=8800;B00SJ2=X8fPP[20<[03Zc:k<[29<8daM[5f/GJaM[5f/GJaOo5f/GJaM[
5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaOo7`0001l00_l?00185f/GJaM[5f/GJaM[5f/GJaM[
5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5h<GPaN30gd026_B
S]9nOGim0Wh01genOGhZORX00Wh00l9n`P02OP05dWkBO]800Wh06o;oooobO_9nlWkbO_9olWobOo88
lPSb2?88lP022003hPSR00<800OJ2=X8:`P[008800L[22/8/`:c008203?C5f/GJaM[5f/GJaM[5olG
JaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5ol07P0000H00_l40003o`0000801?l200?o
1@000ol0000?00175f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[
5f/GJaM[5f/GJaM[5f/GJaM[5i<GTaL017d03=9Zd_UmnGgiOY9nTP9n00h6OPInLWibOW9n`Wk2OP?o
06SRO^88dPSB2=88d_;Rl^;bh_9nlWh8OPQn:gkB2=88dPSJ2=X8fPP[22^_:k<[/i<8T`;C0]<GJaM[
5f/GJaM[5f_oJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/0o`L01?lB00001@001?l0
0?l80003o`0000H000?o00000P000ol0000@00165f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[
5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5h<GP`Em00J>dXimOWd2OP07OGimORYn
:P02OP07`Wk2O/;BOP03o`0^lWkbO_9nlWkbO_9nlWobOo9olWob2?88lPSb2?;R2>88hPSJ2=X8fPP[
22/8/`8803/[0[<2/m<2d`9[5f/GJaM[5f/GJaM[of/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[
5f/GJaM[o`090003o`00014000050004o`00o`T000?o00001@000ol0000200;o4P00AAM[5f/GJaM[
5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/FTaNC
5`05O@0;O]9ZOOUmnGjBOY800Wh020In1WibOW9n0ol0KgkbO_;RO^9nhWkB2=88dPSRl^;bh_;RlWh8
OPQn27h[2=88dPRn2=X8fPP[22/8`jo3[b/8T`SC0]<2`k=[5f/GJaM[5f/GJaM[of/GJaM[5f/GJaM[
5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[o`080003o`00014000050004o`00o`X000Co00000ol50003
o`00018004DGJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[
5f/GJaM[5f/GJaNC5gdGPaL01Wd018imOWd2OP0:OGimORYn:WhZ`P?o00K2dWkRO^82OP0IlWkbO_9n
lWkbOP=nlWobOo9olPSb2?88lP02200BhPSR2>88fPSJ2=X8:`P[2;<80[<0?0:c0P;C0/>c`k=[5f/G
JaM[5f/GJaOo5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaL0o`L000?o00004@0000D0
00Co003o2`001?l00?l70003o`0001<004@GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[
5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaJC5T`GT`Am00]nOGimnGgiOI9nTP02OP031Wko00;o
00=nLWh00Wh03_9nlWkbhWkRO^9ndPSB0PP04988l^;bh_;RlWh8OPQn27h2201?dPSB2;h8_PSJ22/8
:`S3[l>_/`RC0]<2`k?3/f/GJaM[5f/GJaM[5f/GoaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/G
JaM[5f/Go`070003o`00014000050004o`00o`P000Co003o0P000ol0000400;o5`00@V/GJaM[5f/G
JaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GTcam5`Qm
00=nOGh00Wd017imOWd2o`0<OR[2O]9nd^9nhWkR0Wh0K?9nlWkbO_9n0gh3O_9olWobOo88lPSb2?88
0n88hPSJ2=X8fPP[22/8/`Rc20880[?C0/>cJaM[5f/GJaM[5f/GJaM[5f/GoaM[5f/GJaM[5f/GJaM[
5f/GJaM[5f/GJaM[5f/GJaM[5f/Go`@00olC00001P02o`X00_l300Co0`000ol0000G0011JaM[5f/G
JaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GTaI<l9<0
17d02WimORYm:WdZTWh3o`0?1Wh6OW:BOY9nT_9nlWkb009n01WRO^9nhPSBTPRB29;Rl^;bh]Yn27h8
OPSb008801?B2=88_PRn2=X8:`P[[l>_``Rc00880P80>>m[5f/GJaM[5f/GJaM[5f/GJaM[5olGJaM[
5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[0_l50003o`000140000N00;o6@00@F/GJaM[5f/G
JaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[?9<GOCb300Mm
00=nOGh00ol037enOGj2OX;BO]9ndP9n023RO^9nh_9nlWkbO_9n0gh3OP=olWob20<8lPSb20<80`88
01;R2=X8fPSJ22/8:`Rc2;<80PP20P0l20880V/GJaM[5f/GJaM[5f/GJaM[5f_oJaM[5f/GJaM[5f/G
JaM[5f/GJaM[5f/GJaM[5f/GJaM[5f_o6@0001h000?o00006@00@6/GJaM[5f/GJaM[5f/GJaM[5f/G
JaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5Y?`C?03O@04OWenO@?o01DZTWjB
OY9COE=mOY9nTWjBlWkbO_800Wh0<>9nhWkRTPRB2988T^;bh_9nfWh8OPQn2?88l]88_PRn2;h8:`P[
22^_`jnc2;<220<203Xg0V/GJaM[5f/GJaM[5f/GJaM[5f_oJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/G
JaM[5f/GJaM[5f_o600001h000?o00006P00?V/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/G
JaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaLl5gdl1Gd3o`03OWen009m00QnOGimOX9nPP9n00?BO]80
0Wh08>9nhWkRlWkbO_9n0gh3OP=n0gobO`<80`Sb2?880`P30PP04N88fPSJ25<8:`P[2;<8/`P20088
03l220:_0ZlgJaM[5f/GJaM[5f/GJaM[5f/GJom[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[
5f/G0?l05`0001h00_lL000oJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/G
JaM[5f/GJaM[5f/GJaM[K3c`C?1m00?o01]mOWem:WdZOGjBOY9nOE=mDi9nTWjBlWkbO_800Wh06n9n
hWh3OPRB2988TPSbh]YnfWh8OPSb2?88lP02200D_PRn2;h8:`P[2<>_``Rc2;<22>l20P0k=`8;=f/G
JaM[5f/GJaM[5f/GJaM[5f_oJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5ol05`0001h0
00?o00007@00=aM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[
5f/GJaL00S`01I?ooolm00Mm00]nOGinOGimOX9nPP02OP0:dWkBO];RO^9nhP9n02_bOP=n0gh3OP=n
0gkb20<80`P32?880`P320?J2=X8fPQC25<8:`Rc2088008204480PP2[`8;=`/gJaM[5f/GJaM[5f/G
JaM[5f/GoaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/Go`0F00007@000ol0000O000f
5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[0ol014c`
C7`3O@0EOWen:WdZOGjBOY9nOE=mDi9nTWjB009n023bO_9nl^9n0gh3OPRB2988TPSJO]YnfWkJOPSb
2?88lP8800nn2;h8:`P[22^_`jo32;<00PP20P03kcL2008g03/;5f/GJaM[5f/GJaM[5f/GJaM[5f/G
oaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/0o`0E00007@03ob0003<GJaM[5f/GJaM[
5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaL00_l02F/l?3am?3em?@05O@0G
OWenOWenOGj2OX9nP]9ndWkBhWkRO^800Wh0:P=n0gh3OP=n0gh3OP<80`P320<80`P320<80mX8fPSJ
25<8D`Rc2;<80P8804<220880ZlGJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GoaM[5f/GJaM[5f/GJaM[
5f/GJaM[5f/GJaM[5f/GJaM[5f_o01D0000:00;o10000ol0000200?o1@000ol0000Q000_5f/GJaM[
5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaL00ol011M[K3`2K005l4alOG`0
0gd04ghZOBYmOY9nTWimDgeCOGjBOY800Wh00o9nlP02OP0^0gh3OP=n0i88TPRB2=YnfWkJO][b2?88
lPSbfPRn2;h8:`P[22/8`jnc2;<220<20SL0?_lGJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f_oJaM[5f/G
JaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f_o500000T000Co003o2`000ol000020003o`000280
02/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/G00?o00HGJaM[5f/3?005
OC`mOCd01Gd05GimOWimOWenPWj2OX;BO]9nd^9nhP02OP0K0gh3OP=n0gh3OP=n_Wjn20<80`P320<8
0`P3008800nn2=X8D`QC25<8/`Rc20800PP01@880Zl200?o03dGJaM[5f/GJaM[5f/GJaM[5f/GJaM[
5f_oJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5`3o01<000090004o`00o`/000?o0000
0P02ob@002LGJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaL00ol04AM[5f/GJaM[
5ca/?3e<O7el00Im01<ZOGjBOY9nOE=mDgenTWjBOY;b009n01CbO_9n0gh3OP>B2988dPSBO]YnfP9n
00GJ2?88lP02200?fPRn22/8:`P[2;<8/`Rc008800<22>l00P80@@SooaM[5f/GJaM[5f/GJaM[5f/G
JaM[5f/GJaM[of/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaOo01<000090004o`00o`P0
0ol50003o`0002@002<GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5`03o`0=5f/GJaM[
5f/GJaM[;002?005O3amOCd01Gd00gimOP02O@0=OWenOGj2OX;BO]9ndP03OP0]0gh3OP=n0gh3OP=n
0gjnO[h80`P32;h80`P320>n2;h8fPQC25<8/`Rc2088008204L80PP2kcNc5k<GJaM[5f/GJaM[5f/G
JaM[5f/GJaM[5f/GJom[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/0o`0B00002@001?l0
0?l80003o`0000D000?o00009@007aM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaL00ol041M[
5f/GJaM[5f/GJaLF5f/2?005?Fc`OG`01Wd0:0Ym:Y9nTWjBDgeCOE>BOY9nJWkbO_9nlWh3OP=n0gh8
TPSB2=9nfWh2fP0GO]YnlPSbfPSJ2=X8:`P[22/8/`Q724L00PP30P12kcL?5`lG3aM[5f/GJaM[5f/G
JaM[5f/GJaM[5f/GJaOo5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/G0P000ol0000?0000
2@001?l00?l80003o`0000@00_lX000K5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/G00?o01<GJaM[
5f/GJaM[5f/GJaM[5`J<008l00El?7am?@05O@03OWen009m00QnOGimOX9nPP9n027BO]9n0gh3OP=n
0gh3OP=n0gjnO[in_PP32;h8_PRn20<00PP03kh8_PQC25<8D`Rc2;<80P0220190PP220:_ok<G/aM[
5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5olGJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaL0
o`0A00002P02o`T01?l30003o`0002P001LGJaM[5f/GJaM[5f/GJaM[5f/GJaM[5`03o`0F5f/GJaM[
5f/GJaM[5f/GJaM[5f/G5P8/0V`01CemO7el00Am02L:O@YZOFYmTU=mD`Z>JXiZSVZ>lWkbO_9n0gh3
OP=n2=88dPSB2=X00Wh01MYnfWkb008801OJ2=X8fPP[22/8/`Rc24L8A`880^l;k`03o`103aM[5f/G
JaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GoaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5`;o
400001`000?o0000:@0051M[5f/GJaM[5f/GJaM[5f/GJaM[0_l06QM[5f/GJaM[5f/GJaM[5f/GJaM[
5f/GJaL60c`01Gam?Gdm00Em03inOGenOGimJWiZOVYndWkBO]9n0gh3OP=n0gh3O]Yn_WjnO[in0`Rn
2;h8_PP3_PRn2;h8D`QC25<8/`P2208204/80PP2kcOo5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/G
JaM[5f_oJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[0?l0400001`00_l[000@5f/GJaM[
5f/GJaM[5f/GJ`?o025[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/Goca/?F`00Wd00gamO@02O@03
2Wd:009m025ZOFZ>2Xh:SPZ>JXiZS_9nlWkbOP=n0gkJ2=[B2=88dPP00]X01GkJO]Yn00;J0108fPSJ
20/82`P[2;<8/`Q70PP0C0880^l;21M[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f_oJaM[
5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[0?l?000070000ol0000[000<5f/GJaM[5f/GJaM[
0ol07f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/00R`01Sal?3am?@Em00MnOGinOGim009n
02=ZOVYndWkBO]9n0gh3OP=n0gkJO]Yn_WjnO[in_PRn2;h8_P02200@_PRn2;h8D`QC2;<8/`P22082
04d80PP2kaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJom[5f/GJaM[5f/GJaM[5f/G
JaM[5f/GJaM[5f/GJaM[5f/0o`0>000070000ol0000/00085f/GJaM[5f/3o`0SJaM[5f/GJaM[5f/G
JaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/00R`013e/OG`5O@032Wd:009m02UZOFYm2Xh:SPZ>JXiZSVYn
lWkbO_9nfPSJ2=[B2=88dPQcfWkJO]YnD`02201NfPSJ20/82`Rc2;<8A`Q70PP2k`;_=`/GJaM[5f/G
JaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f_oJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/G
JaM[o`P01?l200006`02oc0000=[5f/00ol09f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/G
JaM[5f/G;003?003O7dl00Em00MnOGinOGim009n03AZOVYndWkBO]9n0gh3OP=nfWkJO]Yn_WjnO[h8
fPRn2;h8__88_PRn25<8D`QC:k<8/`P20PP0C`880^l2JaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[
5f/GJaM[5f/GJaOo5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJol01`000ol000030000
6`000ol0000_00?o035[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaL/K3`m
O7el00Em08h:O@YZOFYm2Xh:SPZ>JXiZSVYnlWkbO]X8fPSJ2=[B2=88Ll9cfWkJO]X8D`QCfPSJ20/8
2`880[<8A`Q70PP2k`__5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GoaM[5f/G
JaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5`3o1`000ol0000200006`000ol0000/00?o0P00:f/G
JaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/00R`013alOC`5O@03OWen009m
031nOGimJWiZOVYndWkBO]9n0gkJO]YnfWkJO]Yn_PSJ2=X8_PRnlPSb2?88_PQC25<22005:`P[0PP0
0P80D@P220;_5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaOo5f/GJaM[5f/G
JaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/Go`080003o`000040000K00;o:P03o`H002e[5f/GJaM[5f/G
JaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaOo;3`00V`00gelO@04O@0N2Wd:JWeZOFZ>2Xh:
SVZ>JXiZS_9nfWkJO]X8fPSJ0PP04m;2Ll9c`WkJOU<8D`QCfPP;20/00PP01P880PR3A`880582k`;_
26/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[of/GJaM[5f/GJaM[5f/GJaM[
5f/GJaM[5f/GJaM[5f/GJaOo2001o`400@0000800_l40003o`0000<000?o00000P03o`D000?o0000
9`02o`X002Y[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaL5?003OCam009m
00=nOGh00Wd08gimOWeZOVYnJWkBO]9nhWkJO]YnfWkJO]YnfWkJ2=X8fPRn0088017b2?88lPRn25<8
Db/8:`P[20030P1A20880V/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f_o
JaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[00;o10001?l00?l2000000D0o`00o`090003
o`0000D000?o00000P000ol0000T00?o3@00:F/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/G
JaM[5f/GJaM[008/00A/?7el1Gd00`Im1P02O@0YJWeZSPZ>2Xh:SVZ>/XkJO]YnfWkJ2=X8fPS2Ll9c
`W?2LmX8D`QC25<00PP03@/82`880PP228<80/<00P80D@S_5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[
5f/GJaM[5f/GJaM[5f/GJaM[5f_oJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[o`0500;o
0`0000050?l00?l02P000ol000040004o`0000;o8`03oa4002Y[5f/GJaM[5f/GJaM[5f/GJaM[5f/G
JaM[5f/GJaM[5f/GJaM[5f/GJb`2?003?Gdl00Em00MnOGinOGim009n02AZOVYndWkRO^9nfWkJO]Yn
fWkJO][ZfPSJ2=X8f_88lPSb2?83200;D`P8:`P[20880PP00`80DCLGJaM[5f/GJaM[5f/GJaM[5f/G
JaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[of/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/G
o`0:000000D0o`00o`0:0004o`0000?o10000ol0000O00?o5@00;F/GJaM[5f/GJaM[5f/GJaM[5f/G
JaM[5f/GJaM[5f/GJaM[5f/GJaM[;3a/?005O@031Wd6009m02YnOGim2Xh:TRZ>/XjbS[9nfWkJO]X8
fPSJ27ic`W?2Ll9c0`QC25<8D`P22`1L20/22088P`R3``;32>l8JaM[5f/GJaM[5f/GJaM[5f/GJaM[
5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5olGJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/20003
o`0000P000001@3o003o00/000Co003o1P000ol0000L00?o6@00:6/GJaM[5f/GJaM[5f/GJaM[5f/G
JaM[5f/GJaM[5f/GJaM[5f/GJaL3?003O3am00Am01anOGin1Wh6OXiZSVZ>hWkRO^9nfWkJO]YnfWkJ
0nX01mX8fPSJ2?X00PP01_88lPSbnP8800]C:`P[22/80PP220030P1:JaM[5f/GJaM[5f/GJaM[5f/G
JaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GoaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaL60003
o`0000P000001@3o003o00P000Co003o0P000ol0000400;o6P03oad002][5f/GJaM[5f/GJaM[5f/G
JaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/G;6`l009l1Gd0;PIm1WimOWdZTRZB:Y:bS[:>/WkJO]YnfPSJ
27h8OPS2Ll9c0g<325<8D`P;20/320080PP228<80/<20P182>lGJaM[5f/GJaM[5f/GJaM[5f/GJaM[
5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GoaM[5f/GJaM[5f/GJaM[5f/GJaM[2`000ol000070000
0P02o`T01?l200Co0`000ol0000F00?o8@009f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/G
JaM[5f/GJ`02;003O3el00Am01YnOGim1Wh6OPIZSVZ>JWkRO^9nfWkJO]YnfPKZ0648fPSJ2?X8n_88
l_X8nPSj22/8:`P220880PP2=aM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/G
JaM[5f/GJaM[5olGJaM[5f/GJaM[5f/GJaM[00h000?o00001`0001X000?o00004`03obD002M[5f/G
JaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/00S`017`lO8d3O@1m1Wd6OWenOGjB:Y8Z
T[:>/XjbO]YnfWkj27h8OPQn2<9c`W<3L`=cD`QC20/82`S320880PR3``;32088JaM[5f/GJaM[5f/G
JaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[of/GJaM[5f/GJaM[5f/04@000ol0
000700006@02oa<00_lY000[JaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaMN?3el
?@03O@0IOWenO@In1Wh6JXiZSVYnhWkRO^9nfWkZOP08jP08fPSj2?X8n_82200>nPSj22/8:`P[2088
0PP30P0nJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f_o
JaM[5f/GJaLE0003o`0000L0000I0003o`0000l00ol/001UJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/G
JaM[5f/GJaM[5f/GJaLlO3alSGb=O@Im1WimOWenTRZB:Y:bS[:>/XkJO_[Zn^Yn27h8OPQnL`=c0g<3
L`<82`P;20/8``S328<8Pl<00P80?PS_5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[
5f/GJaM[5f/GJaM[5f/GJaM[of/GJaM[5`000ol0000700006@000ol0000<00?o<000:F/GJaM[5f/G
JaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f]N;7`m00Em01MnOGin1Wh6JXiZSVZ>hWkRO^9njWkZ
OP08jP0HnPSj2?X8nPSj2?X8nPP[22/8/`P220880P80>_m[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[
5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaOo5f/J0003o`0000L0000I00;o2P03oc@002I[5f/G
JaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[?09l00LlO8elOHd6009m02inOGim:Y8ZTRZ>
/XjbJ_[Zn^[jj_X8OPQn27iC0g<3L`=c0b/;20/8``S32<>C0PP0>P;30^mCJaM[5f/GJaM[5f/GJaM[
5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/30003o`0001T000?o00001`0001T0
00?o00001P03ocT002<GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5`02?09l17d06OUm
nGh6OPInSVZ>JXkRO_9nlWkZO^YnjWh01NX05?X;2?X8nPSj20/8nPP[22/8:`:c0P80=i<20P;o5f/G
JaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/01`000ol0000I0003
o`0000H0000I0003o`0000<00olm000U5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaL/
?002O00bSGb=SGf=OP=n0gdZTRYB/VXGJQMZ5n[jj_[ZnPQn27iCOe=oL`=c0b]C:`/8``S32<<2200g
T`P80PS3oaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJ`0;0003
o`0001P000?o00001P0001P00ol0103ooom0000WJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/G
JaM[5f//O3al00=m01WiOOUmSBZ=:XjbS[:>/WkbO_9njWkZO^Yn00?Z00Cj2oX;0_X04`Sj20/82`Sj
22/8:`Rc0[>C0Y<00P80;_m[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[
5f/>0003o`0001P000?o00001P0001001?l400CoA000:6/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/G
JaM[5f/GJaM[;7`lS7`2S@0/OHem0gh3OP=B/U:bDQMZ5fXGJ_[Zn^[jjWiCOe=oDgmc0g=C:e<[D`S3
2<<2200bT`RC0PP2kom[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaLC0003
o`0001L000?o00001P00018000?o00000`02odL002A[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/G
JaM[5f/GJc`2O00KSGgiOOUmSBZ=:XfbS[:>/WkbO_9nlWkZO^Yn00;j01D;nP_j2oX;20/82`P;22/8
:`P[0[<00P80;I<20P9[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJ`0F0003
o`0001H000?o00001P00018000?o00001@000ol0001600175f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[
5f/GJaM[5f/GJcalj8alOHemSGh3OP=B/U:bD[9Z5fXGJ_[Zn^Yn:giCOe=oDgl00U<0>B]C:e<[/g>c
2<>C29<220;_`f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJ`0I0003o`0001H0
00?o00001P00018000?o00001P000ol00016000Q5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[
5f/G008l01b=O8emnGgi:XdZSBZ>/XjbS_9nlWkbO^YnnP_j0P/0>oX;nP_j2b/;20/8:`P[22/8/`:c
T`:C0SLGJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[01l000?o00005@000ol000060000
4P000ol000070003o`0004H0058GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaMlj8cXO@Im
SGh3OP=n/U:bD[9Z5fXGJQOZOR]n:gh[Oe=oDglG22]C:k=c/g>cL`RC0PP09088`nlGJaM[5f/GJaM[
5f/GJaM[5f/GJaM[5f/GJaM[5f/GJb<000?o00005@000ol0000500004003o`X00_m7000Q5f/GJaM[
5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f]N009l01^=O8emSGf=:XdZS[:>/XjbO_9nlXkj2oX;nP/0
0_X04@_j2b]C:`/82`P[22/8:`:c0082026C0TLgJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/0
9`000ol0000D0003o`0000D0000B0003o`0000X000?o0000A@00L1M[5f/GJaM[5f/GJaM[5f/GJaM[
5f/GJaM[5f/GJaM[?8cXS0Im1Wd3OP=n0e:bD[9B5kkb__:nOR]n:gh[Oe=o5`PG21MCLk=c/g>cd`SC
0^<2109[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/Z0003o`0001@000?o00001@00020000?o0000
A@00?AM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[O4alSGf=OHeBSE:=/XjbS[:>0hh3SP<;
nP_j2oX00P/0;2]C:e<[D`P[22/8:`:c0[?C0]<2JaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/G;`000ol0
000C0003o`0000D0000Q0003o`0004D0020GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/G;09l
04GXO@Im1^TGjAL6jPKZ1^Znl[kb__8[OR]n:c0G21L85`PGPg>cLk?C2=<8h`;S0P@GJaM[5f/GJaM[
5f/GJaM[5f/GJaL0<`000ol0000B0003o`0000D0000R00;oA`00>F/GJaM[5f/GJaM[5f/GJaM[5f/G
JaM[5f/GJaM[5calC7f=OHeBSE:=DXjbS[:>0hh3SP>>nP_j2`03D`0>:e<[Db^3Lh<8:`Rc0[<20P0F
d`975f/GJaM[5f/GJaM[5f/GJaM[5cH000?o00004P000ol00005000090000ol00015000NJaM[5f/G
JaM[5f/GJaM[5f/GJaM[5f/GJaM[5f//0g`0?@Im1WdGjAOYjPKZ1^X6l[kb__8[OR/`dS3B21L85h<8
P`R3L`SC2=<2h`84=f/GJaM[5f/GJaM[5f/GJaL0>P000ol0000A0003o`0000D0000U0003o`0004@0
028GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f//C7am0Xd04Wf=DXeBSK:>/XjbSP>>0hh32`EC
00`[Db^3Lh=cPg?3dk<20P0Ad`970V/GJaM[5f/GJaM[5f/0?`000ol0000@0003o`0000D0000V0003
o`0004@001lGJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/l009l03B=_8dGjAOY5`KZ1^X6l[kb
__8G<=8`dS3B<1N328<8P`R30/<22><210m[5f/GJaM[5f/GA0000ol0000@0003o`0000@0000W0003
o`0004@001lGJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/l009l01=mSGeBSE:=/XjbS[:>0aOJ
5mXG00EC01McPg>3Lh=cPm?3dl<2l`97JaM[5f/GJ`180003o`00010000?o0000100002P00_m6000[
JaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/lO;b=_7dFOAKYjPKZ:P025`0OjQOZ5n[B<=8`Lc1c
P`R328<2``;30]^c3f/GJaM[5`1;0003o`0000l000?o0000100002X000?o0000A000:f/GJaM[5f/G
JaM[5f/GJaM[5f/GJaM[5f/GJaM[?7b=OHen5WhFLQMb5g800QL01=XGfQL3D`0DLh=cPg>3Lh?C`m?3
do<2Af/GJaM?0003o`0000h000?o0000100002/000?o0000A000@f/GJaM[5f/GJaM[5f/GJaM[5f/G
JaM[5f/GJaM[5g`FSKam5WdF:QLZ5b[Z5nXGjQL`Lc1c<7<`Lh<2``;30]^c3f/0D`000ol0000>0003
o`0000@0000/0003o`0004@002U[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaMlS7`FOQIn5g8G
LP025`0<fQOJ5`]cPg>3Lh=c1=<01<?Cl`9G0003o`0000d000?o0000100002d00_m5000YJaM[5f/G
JaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GO1Il5WdF:QLZ5bX00QL04X<GPaN3Lc1c<7?C3m<?d`;K/eT0
00?o000030000ol000040000;`000ol00013000cJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/G
O8b=5XdFLQMb5aH;5`/G2aL;Lh=c00GC00<?loX0F`000ol0000<0003o`0000<0000`0003o`0004<0
01m[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaMl008F01P65P/G2aL;5h<GPaN35h=cd`oC3m>c
ddML0003o`0000`000?o00000`00034000?o0000@`00<F/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/G
JaM[5g`FSAJ=5aHG5QLF2aL;5`/[3b/00m<00`oc001N0003o`0000/000?o00000`0003800_m4000d
JaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJ`HF1QH;5`/G2aN33aL?5`lG3m>cdf4000?o0000
2P000ol000030000=0000ol00013000^5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5aHESALF
5`hG3QL[3b/?:`8?I0000ol000090003o`0000<0000e0003o`0004<002dGJaM[5f/GJaM[5f/GJaM[
5f/GJaM[5f/GJaM[5f/G5W`FO1HG5QLF5`l>Lol0IP000ol000090003o`0000<0000f0003o`000480
01e[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5f/GJ`0600065@hG3QI5J`000ol000080003o`0000<0
000g00;o@`0066/GJaM[5f/GJaM[5f/GJaM[5f/GJaM[5g`000?o00001`000ol000030000>@000ol0
0011000CJaM[5f/GJaM[5f/GJaM[5f/GJ`200003o`0000P000?o00000P0003X000?o0000@P003QM[
5f/GJaM[5f/GJaM[Q0000ol000070003o`000080000k0003o`00048000/GJaM[5f/GJaM[5`270003
o`0000H000?o00000P0003`00_m300075f/GJaM[5`2;0003o`0000D000?o00000P0003h000?o0000
@@000aM[002>0003o`0000D000?o00000P0003l000?o0000@0000ol0002?0003o`0000@000?o0000
0P00040000?o0000?`000ol0002@0003o`0000<000?o00000P00044000?o0000?P000ol0002@0003
o`0000@000?o00000@0004800_ln0003o`00094000?o00000`000ol000010000A0000ol0000k0003
o`00098000?o00000P000ol000010000A@000ol0000j0003o`0009<000Go0000o`030000AP000ol0
000i0003o`0009<000Go0000o`030000A`02ocT000?o0000U0001?l00?l30000B@000ol0000f0003
o`0009D000?o0?l00`0004X000?o0000=@000ol0002E0004o`00o`80001;0003o`0003@000?o0000
UP000ol0o`020000C002oc@000?o0000U`02o`80001>0003o`00034000?o0000UP03o`80001?0003
o`0002l000?o0000T`04o`D0001@0003o`0002h000?o0000S`04o`T0001A00;o;P000ol0002<00?o
3@0005<000?o0000:`000ol0002800Co400005@000?o0000:P000ol0002400Co500005D000?o0000
:@000ol0002000Co600005H00_lY0003o`0007`01?lL0000F0000ol0000V0003o`0007P01?lP0000
F@000ol0000U0003o`0007D00olT0000FP000ol0000T0003o`0007401?lW0000F`000ol0000S0003
o`0006d01?l[0000G002ob<000?o0000J@04obl0001N0003o`00020000?o0000I@04oc<0001O0003
o`0001l000?o0000H@04ocL0001P0003o`0001h000?o0000GP03oc/0001Q00;o7P000ol0001J00Co
?P0006<000?o00006`000ol0001F00Co@P0006@000?o00006P000ol0001B00CoAP0006D000?o0000
6@000ol0001>00CoBP0006H00_lI0003o`0004X01?m>0000J0000ol0000F0003o`0004L00omB0000
J@000ol0000E0003o`0004<01?mE0000JP000ol0000D0003o`0003l01?mI0000J`02oa@000?o0000
>`04oed0001]0003o`00014000?o0000=`04of40001^0003o`00010000?o0000=003ofD0001_0003
o`0000l000?o0000<004ofP0001`00;o3P000ol0000]00CoK000078000?o00002`000ol0000Y00Co
L00007<000?o00002P000ol0000U00CoM00007@000?o00002@000ol0000Q00CoN00007D000?o0000
20000ol0000N00?oO00007H00_l80003o`0001X01?mo0000N0000ol000050003o`0001H01?n30000
N@000ol000040003o`0001801?n70000NP000ol000030003o`0000h01?n;0000N`02o`<000?o0000
2P04ohl0001m0004o`00o`T00onC0000OP000ol0o`0500CoUP0007l00_l00`3oo`02oiX0002000;o
WP000?l08@000?l08@000?l08@000?l08@000001
\>"],
  ImageRangeCache->{{{0, 287}, {232.562, 0}} -> {-0.0895205, 0.00532714, 
  0.00364727, 0.00364727}}]
}, Closed]],

Cell[TextData[{
  "Define the power rule for differentiation by defining a function that \
accepts two arguments, an expression of the form ",
  Cell[BoxData[
      \(TraditionalForm\`v\^n\)]],
  " and a variable ",
  Cell[BoxData[
      \(TraditionalForm\`v\)]],
  ", and returns ",
  Cell[BoxData[
      \(TraditionalForm\`n\ v\^\(n - 1\)\)]],
  ", provided that the exponent ",
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  " is free of the variable ",
  Cell[BoxData[
      \(TraditionalForm\`v\)]],
  "."
}], "Question"],

Cell[TextData[{
  "To test that the exponent is free of the variable of differentiation, we \
use ",
  StyleBox["FreeQ", "Input"],
  "."
}], "Text"],

Cell[BoxData[
    \(deriv[v_\^n_, v_] := n\ v\^\(n - 1\) /; FreeQ[n, v]\)], "Input"],

Cell["The following case satisfies the condition.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(deriv[x\^7, x]\)], "Input"],

Cell[BoxData[
    \(7\ x\^6\)], "Output"]
}, Closed]],

Cell["The following case does not.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(deriv[w\^w, w]\)], "Input"],

Cell[BoxData[
    \(deriv[w\^w, w]\)], "Output"]
}, Closed]],

Cell[" ", "EndExercises"]
}, Closed]],

Cell[CellGroupData[{

Cell["Conditional Patterns", "Subsection"],

Cell[TextData[{
  "In the previous section we tested conditions after the patterns in a \
function were matched; using conditional patterns, we make a condition part \
of a pattern. A conditional pattern has the form ",
  Cell[TextData[{
    StyleBox["patname",
      FontSlant->"Italic"],
    StyleBox["_?", "Input"],
    StyleBox["condition",
      FontSlant->"Italic"]
  }], "Text"],
  " (or ",
  Cell[TextData[{
    StyleBox["patname",
      FontSlant->"Italic"],
    StyleBox["_", "Input"],
    StyleBox["head\[NoBreak]",
      FontSlant->"Italic"],
    StyleBox["?", "Input"],
    StyleBox["condition",
      FontSlant->"Italic"]
  }], "Text"],
  "), and an argument matches a conditional pattern only if ",
  StyleBox["condition",
    FontSlant->"Italic"],
  " returns the value ",
  StyleBox["True", "Input"],
  "."
}], "Text"],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " has a function called ",
  StyleBox["Positive", "Input"],
  " that returns ",
  StyleBox["True", "Input"],
  " if its argument is positive."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \({Positive[\(-15\)], Positive[0], Positive[15]}\)], "Input"],

Cell[BoxData[
    \({False, False, True}\)], "Output"]
}, Closed]],

Cell[TextData[{
  "To include the condition ",
  StyleBox["Positive", "Input"],
  " in the pattern of the function ",
  StyleBox["mersenne", "Input"],
  ", we make the following definition (after first clearing the previous \
definition)."
}], "Text"],

Cell["Clear[mersenne]", "Input"],

Cell[BoxData[
    \(mersenne[n_Integer?Positive] := 2\^Prime[n] - 1\)], "Input"],

Cell[TextData[{
  "The argument ",
  StyleBox["20", "Input"],
  " matches the pattern ",
  StyleBox["n_Integer?Positive", "Input"],
  ", and the function evaluates to a value."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(mersenne[20]\)], "Input"],

Cell[BoxData[
    \(2361183241434822606847\)], "Output"]
}, Closed]],

Cell["Nonpositive arguments now return unevaluated.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \({mersenne[0], mersenne[\(-20\)]}\)], "Input"],

Cell[BoxData[
    \({mersenne[0], mersenne[\(-20\)]}\)], "Output"]
}, Closed]],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " has many built-in ",
  StyleBox["predicate functions",
    FontSlant->"Italic"],
  ", functions that return ",
  StyleBox["True", "Input"],
  " if their condition is met, and ",
  StyleBox["False", "Input"],
  " otherwise. By convention, predicate functions end with the letter ",
  StyleBox["Q", "Input"],
  ". Here are examples of some built-in predicate functions. (A complete \
listing of functions that end with ",
  StyleBox["Q", "Input"],
  " can be found by entering ",
  Cell["?*Q", "Input"],
  " or ",
  Cell["Names[\"*Q\"]", "Input"],
  ".)"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(EvenQ[12]\)], "Input"],

Cell[BoxData[
    \(True\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(PrimeQ[2\^\(2\^4\) + 1]\)], "Input"],

Cell[BoxData[
    \(True\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(VectorQ[{1, 2, 3, 4}]\)], "Input"],

Cell[BoxData[
    \(True\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(MatrixQ[{{1, 2, 3}, {4, 5}}]\)], "Input"],

Cell[BoxData[
    \(False\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(IntervalMemberQ[Interval[{3, 4}], \[Pi]]\)], "Input"],

Cell[BoxData[
    \(True\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(StringQ["Is this a string?"]\)], "Input"],

Cell[BoxData[
    \(True\)], "Output"]
}, Closed]],

Cell[TextData[{
  "Any predicate function can be included in a pattern. Here is a custom \
predicate function that returns ",
  StyleBox["True", "Input"],
  " if its argument is inside the unit circle in the complex plane."
}], "Text"],

Cell[BoxData[
    \(pred[z_] := True /; Abs[z] <= 1.0\)], "Input"],

Cell[TextData[{
  "We can now use ",
  StyleBox["pred", "Input"],
  " as part of a conditional pattern."
}], "Text"],

Cell[BoxData[
    \(invert[x_?pred] := 1/x\)], "Input"],

Cell[TextData[{
  "The following argument satisfies ",
  StyleBox["pred", "Input"],
  ", so the function returns a value."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(invert[0.02 - 0.03\ I]\)], "Input"],

Cell[BoxData[
    \(\(15.3846153846153876`\ \) + 23.0769230769230748`\ I\)], "Output"]
}, Closed]],

Cell[TextData[{
  "The following argument does not satisfy ",
  StyleBox["pred", "Input"],
  ", so the function returns unevaluated."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(invert[3 + 4\ I]\)], "Input"],

Cell[BoxData[
    \(invert[3 + 4\ I]\)], "Output"]
}, Closed]],

Cell[TextData[{
  "See also ",
  StyleBox["NumericQ", "Input"],
  ", ",
  StyleBox["NumberQ", "Input"],
  ", ",
  StyleBox["PolynomialQ", "Input"],
  ", ",
  StyleBox["AtomQ", "Input"],
  " "
}], "SeeAlso"],

Cell["Exercises: Conditional Patterns", "Exercises",
  PageBreakAbove->True],

Cell[TextData[{
  "Using a conditional pattern, create a function that returns the symbol ",
  StyleBox["Yes", "Input"],
  " if its argument is a prime number and ",
  StyleBox["No", "Input"],
  " otherwise."
}], "Question"],

Cell["\<\
The following conditional pattern tests if its argument is prime.\
\
\>", "Text"],

Cell[BoxData[
    \(isItPrime[n_?PrimeQ] := Yes\)], "Input"],

Cell["\<\
This pattern matches any argument that is not a prime number.\
\>", 
  "Text"],

Cell[BoxData[
    \(isItPrime[n_] := No\)], "Input"],

Cell["Here is a test of the function.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \({isItPrime[17], isItPrime[28]}\)], "Input"],

Cell[BoxData[
    \({Yes, No}\)], "Output"]
}, Closed]],

Cell[TextData[{
  "Define a function called ",
  StyleBox["vectorLength", "Input"],
  " that returns the length of a vector."
}], "Question"],

Cell[TextData[{
  "Here is a definition of ",
  StyleBox["vectorLength", "Input"],
  " that accepts only vectors by using the conditional pattern ",
  Cell["v_?VectorQ", "Input"],
  ". It computes the length using the formula ",
  Cell[BoxData[
      \(TraditionalForm\`\@\(v.v\)\)]],
  "."
}], "Text"],

Cell[BoxData[
    \(vectorLength[v_?VectorQ] := \@\(v.v\)\)], "Input"],

Cell["Here is the length of a vector.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(vectorLength[{1, 2, n, 4}]\)], "Input"],

Cell[BoxData[
    \(\@\(21 + n\^2\)\)], "Output"]
}, Closed]],

Cell[TextData[{
  "Here the argument to ",
  StyleBox["vectorLength", "Input"],
  " is not a vector, so the function returns unevaluated."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(vectorLength[1 + n]\)], "Input"],

Cell[BoxData[
    \(vectorLength[1 + n]\)], "Output"]
}, Closed]],

Cell[TextData[{
  "Define a function called ",
  StyleBox["collatz", "Input"],
  " that has the following recursive definition."
}], "Question"],

Cell[TextData[Cell[BoxData[
    FormBox[
      RowBox[{\(collatz(n)\), "=", 
        StyleBox[
          RowBox[{"{", GridBox[{
                {
                  RowBox[{
                    RowBox[{"collatz", "(", 
                      StyleBox[\(n/2\),
                        SpanMaxSize->Infinity], 
                      StyleBox[")",
                        SpanMaxSize->Infinity]}], ",", \(n\ even\)}]},
                {\(collatz(3n + 1), n\ odd, \ n \[NotEqual] 1\)},
                {\(1, \ n = 1\)}
                },
              ColumnAlignments->{","}]}],
          SpanMaxSize->Infinity]}], TraditionalForm]]]], "Text",
  TextAlignment->-0.5],

Cell[TextData[{
  "Here we use the predicate functions ",
  StyleBox["EvenQ", "Input"],
  " and ",
  StyleBox["OddQ", "Input"],
  " as part of a conditional pattern."
}], "Text"],

Cell[BoxData[
    \(collatz[n_?EvenQ] := collatz[n/2]\)], "Input"],

Cell[BoxData[
    \(collatz[n_?OddQ] := collatz[3 n + 1]\)], "Input"],

Cell[BoxData[
    \(\(collatz[1] = 1; \)\)], "Input"],

Cell[TextData[{
  "The specific case ",
  StyleBox["collatz[1]", "Input"],
  " gets matched before the general case ",
  Cell["collatz[n_?OddQ]", "Input"],
  ", so it is not necessary to add a test ",
  Cell[BoxData[
      \(TraditionalForm\`n \[NotEqual] 1\)]],
  " to the latter rule."
}], "Text"],

Cell[TextData[{
  "It is conjectured that for any positive integer argument, ",
  StyleBox["collatz", "Input"],
  " as defined here will return 1 (as opposed to going into an endless loop). \
Here is some sample input."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(collatz[10]\)], "Input"],

Cell[BoxData[
    \(1\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(collatz[100]\)], "Input"],

Cell[BoxData[
    \(1\)], "Output"]
}, Closed]],

Cell[TextData[{
  "Here is a modification that prints all of the numbers that are encountered \
during the evaluation of ",
  StyleBox["collatz", "Input"],
  "."
}], "Text"],

Cell[BoxData[
    \(Clear[collatz]\)], "Input"],

Cell[BoxData[
    \(collatz[n_?EvenQ] := \((Print[n]; collatz[n/2])\)\)], "Input"],

Cell[BoxData[
    \(collatz[n_?OddQ] := \((Print[n]; collatz[3 n + 1])\)\)], "Input"],

Cell[BoxData[
    \(\(collatz[1] = 1; \)\)], "Input"],

Cell[TextData[{
  "Here are the numbers encountered during the evaluation of ",
  StyleBox["collatz[10]", "Input"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(collatz[10]\)], "Input"],

Cell[BoxData[
    \(10\)], "Print"],

Cell[BoxData[
    \(5\)], "Print"],

Cell[BoxData[
    \(16\)], "Print"],

Cell[BoxData[
    \(8\)], "Print"],

Cell[BoxData[
    \(4\)], "Print"],

Cell[BoxData[
    \(2\)], "Print"],

Cell[BoxData[
    \(1\)], "Output"]
}, Closed]],

Cell[TextData[{
  "The function ",
  StyleBox["Count", "Input"],
  " returns the number of elements in an expression (typically a list) that \
match a given pattern. Use ",
  StyleBox["Count", "Input"],
  ", ",
  StyleBox["CoefficientList", "Input"],
  ", and a conditional pattern to count the number of odd coefficients in the \
expansion of ",
  Cell[BoxData[
      \(TraditionalForm\`\((1 + x)\)\^11\)]],
  "."
}], "Question"],

Cell["Here is the list of coefficients.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(CoefficientList[\((1 + x)\)\^11, x]\)], "Input"],

Cell[BoxData[
    \({1, 11, 55, 165, 330, 462, 462, 330, 165, 55, 11, 1}\)], "Output"]
}, Closed]],

Cell["Here is the number of odd coefficients.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Count[%, _?OddQ]\)], "Input"],

Cell[BoxData[
    \(8\)], "Output"]
}, Closed]],

Cell[" ", "EndExercises"]
}, Closed]],

Cell[CellGroupData[{

Cell["Default and Optional Patterns", "Subsection"],

Cell[TextData[{
  "Here is a function ",
  StyleBox["pow", "Input"],
  " that accepts two arguments, and returns the first argument raised to the \
power of the second."
}], "Text"],

Cell[BoxData[
    \(pow[a_, b_] := a\^b\)], "Input"],

Cell[TextData[{
  "The first argument matches ",
  StyleBox["a_", "Input"],
  " and the second argument matches ",
  StyleBox["b_", "Input"],
  "; and ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " makes the appropriate substitutions on the right-hand side of the \
definition."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(pow[\(-6\), 3]\)], "Input"],

Cell[BoxData[
    \(\(-216\)\)], "Output"]
}, Closed]],

Cell[TextData[{
  "One way to assign a default value for the exponent (say, 2) is to give ",
  StyleBox["pow", "Input"],
  " a second definition for the cases in which it is called with one \
argument."
}], "Text"],

Cell[BoxData[
    \(pow[a_] := a\^2\)], "Input"],

Cell[TextData[{
  "The newer rule is applied when ",
  StyleBox["pow", "Input"],
  " is called with one argument, effectively defining a default value of 2 \
for the exponent."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(pow[256]\)], "Input"],

Cell[BoxData[
    \(65536\)], "Output"]
}, Closed]],

Cell[TextData[{
  "The on-line help displays the two definitions for ",
  StyleBox["pow", "Input"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(?pow\)\)], "Input"],

Cell[BoxData[
    \("Global`"\[InvisibleSpace]"pow"\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      StyleBox[
        "\(pow[a_, \\ b_]\\  := \\ a^b\\n\\ \\n         pow[a_]\\  := \\ \
a^2\)",
        ShowStringCharacters->True,
        NumberMarks->True],
      InputForm[ 
        Definition[ pow]],
      Editable->True,
      AutoDelete->True]], "Print"]
}, Closed]],

Cell[TextData[{
  "A more concise way to do the same thing involves using default patterns. A \
default pattern looks like ",
  Cell[TextData[{
    StyleBox["patname",
      FontSlant->"Italic"],
    StyleBox["_:", "Input"],
    StyleBox["defaultvalue",
      FontSlant->"Italic"]
  }], "Text"],
  ", and ",
  StyleBox["defaultvalue",
    FontSlant->"Italic"],
  " is returned as the value of ",
  StyleBox["patname",
    FontSlant->"Italic"],
  " if the corresponding argument is omitted. Here is a function ",
  StyleBox["powtwo", "Input"],
  " that combines the two previous definitions into one statement."
}], "Text"],

Cell[BoxData[
    \(powtwo[a_, b_: 2] := a\^b\)], "Input"],

Cell[TextData[{
  "If we give ",
  StyleBox["powtwo", "Input"],
  " two arguments, both are used when computing the function."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(powtwo[\(-6\), 3]\)], "Input"],

Cell[BoxData[
    \(\(-216\)\)], "Output"]
}, Closed]],

Cell[TextData[{
  "If only one argument is given, ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " uses the default value 2 for the exponent\[CloseCurlyQuote]s pattern ",
  StyleBox["b_", "Input"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(powtwo[256]\)], "Input"],

Cell[BoxData[
    \(65536\)], "Output"]
}, Closed]],

Cell["\<\
Some operators such as addition and exponentiation have built-in \
default values. Here is a definition of the power rule for a differentiation \
function. (For this definition, we ignore the possibility that the exponent \
depends on the variable of differentiation.)\
\>", "Text"],

Cell[BoxData[
    \(deriv[var_\^n_, var_] := n\ var\^\(n - 1\)\)], "Input"],

Cell[TextData[{
  "The pattern inside the ",
  StyleBox["deriv", "Input"],
  " function matches expressions of the form ",
  Cell[BoxData[
      \(TraditionalForm\`x\^n\)]],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(deriv[z\^5, z]\)], "Input"],

Cell[BoxData[
    \(5\ z\^4\)], "Output"]
}, Closed]],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " matches patterns according to form, and not necessarily mathematical \
equality. For this reason, ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " does not recognize ",
  StyleBox["x",
    FontSlant->"Italic"],
  " as ",
  Cell[BoxData[
      \(TraditionalForm\`x\^1\)]],
  ", and the following case returns unevaluated."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(deriv[x, x]\)], "Input"],

Cell[BoxData[
    \(deriv[x, x]\)], "Output"]
}, Closed]],

Cell[TextData[{
  "One way to define ",
  StyleBox["deriv", "Input"],
  " for this case is to give the exponent pattern a default value of 1, using \
the pattern ",
  StyleBox["n_:1", "Input"],
  "."
}], "Text"],

Cell[BoxData[
    \(Clear[deriv]\)], "Input"],

Cell[BoxData[
    \(deriv[var_\^\(n_: 1\), var_] := n\ var\^\(n - 1\)\)], "Input"],

Cell["The function now handles this case correctly.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(deriv[x, x]\)], "Input"],

Cell[BoxData[
    \(1\)], "Output"]
}, Closed]],

Cell[TextData[{
  "To use exponentiation\[CloseCurlyQuote]s default (or identity) value in a \
pattern, we include a period (",
  StyleBox[".", "Input"],
  ") directly after the underscore. The default value of an exponent is 1, \
and we tell ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " to allow the case ",
  Cell[BoxData[
      \(TraditionalForm\`x\^1\)]],
  " as follows."
}], "Text"],

Cell[BoxData[
    \(deriv2[var_\^n_., var_] := n\ var\^\(n - 1\)\)], "Input"],

Cell[TextData[{
  "The case ",
  Cell[BoxData[
      \(TraditionalForm\`x\^1\)]],
  " now works as intended."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(deriv2[x, x]\)], "Input"],

Cell[BoxData[
    \(1\)], "Output"]
}, Closed]],

Cell[TextData[{
  "Other defaults are ",
  Cell[BoxData[
      \(x_ + y_.\)], "Input"],
  ", in which ",
  StyleBox["y", "Input"],
  " defaults to 0; and ",
  Cell[BoxData[
      \(x_*y_.\)], "Input"],
  ", in which ",
  StyleBox["y", "Input"],
  " defaults to 1."
}], "Text"],

Cell[TextData[{
  "See also ",
  StyleBox["Default", "Input"],
  ", ",
  StyleBox["DefaultValues", "Input"],
  " "
}], "SeeAlso"],

Cell["Exercises: Default and Optional Patterns", "Exercises",
  PageBreakAbove->True],

Cell[TextData[{
  "Define a function ",
  StyleBox["ann", "Input"],
  " that computes the net present value of an annuity-immediate using the \
formula ",
  Cell[BoxData[
      \(\[Sum]\+\(k = 1\)\%n\((1 + i)\)\^\(-k\)\)]],
  ", where ",
  StyleBox["n", "Input"],
  " (the term of the annuity) and ",
  StyleBox["i", "Input"],
  " (the interest rate) are arguments to ",
  StyleBox["ann", "Input"],
  ", and ",
  StyleBox["i", "Input"],
  " has a default value of 5%."
}], "Question"],

Cell[TextData[{
  "We assign a default value to the argument ",
  StyleBox["i", "Input"],
  " by including the pattern ",
  StyleBox["i_:0.05", "Input"],
  "."
}], "Text"],

Cell["ann[n_, i_:0.05] := Sum[(1 + i)^-k, {k, 1, n}]", "Input"],

Cell[TextData[{
  "We can include the interest rate as a second argument to ",
  StyleBox["ann", "Input"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ann[10, 0.04]\)], "Input"],

Cell[BoxData[
    \(8.11089577935502781`\)], "Output"]
}, Closed]],

Cell["If we omit the second argument, the default value is used.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ann[10]\)], "Input"],

Cell[BoxData[
    \(7.7217349291848123`\)], "Output"]
}, Closed]],

Cell[" ", "EndExercises"]
}, Closed]],

Cell[CellGroupData[{

Cell["Variable Numbers of Arguments", "Subsection"],

Cell[TextData[{
  "In some cases we will define functions that should accept any number of \
arguments. For example, the built-in operator ",
  StyleBox["Plus", "Input"],
  " accepts a variable number of arguments."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \({Plus[a, b], Plus[a, b, c, d]} // ColumnForm\)], "Input"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {"\(a + b\)"},
          {"\(a + b + c + d\)"}
          },
        GridBaseline->{Baseline, {1, 1}},
        ColumnAlignments->{Left}],
      ColumnForm[ {
        Plus[ a, b], 
        Plus[ a, b, c, d]}],
      Editable->False]], "Output"]
}, Closed]],

Cell[TextData[{
  "To handle the possibility of any number of arguments, the pattern ",
  StyleBox["__", "Input"],
  " (two underscores) matches one or more arguments, and ",
  StyleBox["___", "Input"],
  " (three underscores) matches zero or more arguments."
}], "Text"],

Cell[TextData[{
  "We can define a function called ",
  StyleBox["HasConsecutivePairQ", "Input"],
  " that turns ",
  StyleBox["True", "Input"],
  " if it contains the same argument twice in a row. One way to detect such \
pairs is to use the same pattern name twice in a row on the left side of the \
function definition, as in the following simplified example."
}], "Text"],

Cell[BoxData[
    \(PairOnlyQ[z_, z_] := True\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(PairOnlyQ[3, 3]\)], "Input"],

Cell[OutputFormData["\<\
True\
\>", "\<\
True\
\>"], "Output"]
}, Closed]],

Cell[TextData[{
  "To allow a matching consecutive pair anywhere among the function\
\[CloseCurlyQuote]s arguments, we insert triple-underscore patterns before \
and after the matching-pair patterns, which tells ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " to allow any number (including zero) of arbitrary arguments before and \
after the matching pair. Any sequence of arguments before or after the \
matching pair is ignored, so we do not name the corresponding patterns."
}], "Text"],

Cell[BoxData[
    \(HasConsecutivePairQ[___, z_, z_, ___] := True\)], "Input"],

Cell[TextData[{
  "We insert a second rule that matches every other case and returns ",
  StyleBox["False", "Input"],
  "."
}], "Text"],

Cell[BoxData[
    \(HasConsecutivePairQ[___] := False\)], "Input"],

Cell[TextData[{
  "The following use of ",
  StyleBox["HasConsecutivePairQ", "Input"],
  " has a pair of consecutive 3s, and returns the value ",
  StyleBox["True", "Input"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(HasConsecutivePairQ[0, 1, 2, 3, 3, 4, 5]\)], "Input"],

Cell[BoxData[
    \(True\)], "Output"]
}, Closed]],

Cell[TextData[{
  "The following has no consecutive matching pairs, so it returns ",
  StyleBox["False", "Input"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(HasConsecutivePairQ[0, 1, 2, 0, 1, 2]\)], "Input"],

Cell[BoxData[
    \(False\)], "Output"]
}, Closed]],

Cell[TextData[{
  "To define a ",
  StyleBox["HasPairAnywhereQ", "Input"],
  " function that returns ",
  StyleBox["True", "Input"],
  " if any two of its arguments match, we create the following definition \
(followed by a definition that matches anything else and returns ",
  StyleBox["False", "Input"],
  ")."
}], "Text"],

Cell[BoxData[{
    \(\(HasPairAnywhereQ[___, z_, ___, z_, ___] := True; \)\), 
    \(HasPairAnywhereQ[___] := False\)}], "Input"],

Cell["\<\
There can now be any number of elements between the matching pair \
of elements.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(HasPairAnywhereQ[0, 1, 2, 1, 3]\)], "Input"],

Cell[BoxData[
    \(True\)], "Output"]
}, Closed]],

Cell["Here there are no elements between the matching items.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(HasPairAnywhereQ[0, 1, 1, 2]\)], "Input"],

Cell[BoxData[
    \(True\)], "Output"]
}, Closed]],

Cell[TextData[{
  "To define a function ",
  StyleBox["HasPairAtLeastOneSpaceApartQ", "Input"],
  ", we use a double-underscore between the patterns with the same name. The \
double-underscore matches any number of elements except zero."
}], "Text"],

Cell[BoxData[
    \(HasPairAtLeastOneSpaceApartQ[___, z_, __, z_, ___] := True\)], "Input"],

Cell[BoxData[
    \(HasPairAtLeastOneSpaceApartQ[___] := False\)], "Input"],

Cell["\<\
Now the function matches pairs with at least one element between \
the matching items.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(HasPairAtLeastOneSpaceApartQ[0, 1, 2, 3, 1, 4]\)], "Input"],

Cell[BoxData[
    \(True\)], "Output"]
}, Closed]],

Cell["\<\
However, the function no longer recognizes consecutive pairs.\
\>", 
  "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(HasPairAtLeastOneSpaceApartQ[0, 1, 1, 2]\)], "Input"],

Cell[BoxData[
    \(False\)], "Output"]
}, Closed]],

Cell[TextData[
"Double- and triple-blank patterns are often used to create error-catching \
definitions, or \[OpenCurlyDoubleQuote]fall-through\[CloseCurlyDoubleQuote] \
cases, the idea being that they catch input that does not match any of the \
\[OpenCurlyDoubleQuote]correct\[CloseCurlyDoubleQuote] forms of a function."],
   "Text"],

Cell[TextData[{
  "See also ",
  StyleBox["ReplaceList", "Input"],
  ", ",
  StyleBox["Message", "Input"]
}], "SeeAlso"],

Cell["Exercises: Variable Numbers of Arguments", "Exercises",
  PageBreakAbove->True],

Cell[TextData[{
  "Define a function ",
  StyleBox["HasTwoConsecutivePairsQ", "Input"],
  " that returns ",
  StyleBox["True", "Input"],
  " if given two consecutive matching pairs of arguments (with any number of \
arguments between the pairs)."
}], "Question"],

Cell[TextData[{
  "Each consecutive pair will match a pattern of the form ",
  Cell[BoxData[
      \(\((x_, \ x_)\)\)], "Input"],
  "; that is, two consecutive patterns with the same name. Because there can \
be any number of arguments before and after each pair, we surround the \
matching patterns with triple-blank patterns that match zero or more \
arguments."
}], "Text"],

Cell[BoxData[
    \(HasTwoConsecutivePairsQ[___, x_, x_, ___, y_, y_, ___] := True\)], 
  "Input"],

Cell["\<\
In the following test, there are two consecutive 3s and two \
consecutive 7s.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(HasTwoConsecutivePairsQ[1, 2, 3, 3, 4, 5, 6, 7, 7, 8]\)], "Input"],

Cell[BoxData[
    \(True\)], "Output"]
}, Closed]],

Cell["\<\
In the following test, there is only one matching consecutive pair, \
so the arguments do not match the pattern and the function returns \
unevaluated.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(HasTwoConsecutivePairsQ[1, 2, 3, 3, 4, 5, 6, 7, 8]\)], "Input"],

Cell[BoxData[
    \(HasTwoConsecutivePairsQ[1, 2, 3, 3, 4, 5, 6, 7, 8]\)], "Output"]
}, Closed]],

Cell[TextData[{
  "Define a function called ",
  StyleBox["SortList", "Input"],
  " that sorts a list of numbers into descending order, using double- or \
triple-blank patterns."
}], "Question"],

Cell[TextData[{
  "A simpler function ",
  StyleBox["SortTwo", "Input"],
  " that sorts a list of two elements into descending order might have the \
following definition: ",
  StyleBox["SortTwo", "Input"],
  " of a list ",
  Cell[BoxData[
      \({x, y}\)], "Input"],
  " returns ",
  Cell[BoxData[
      \({y, x}\)], "Input"],
  " provided that ",
  Cell[BoxData[
      \(TraditionalForm\`y > x\)]],
  "."
}], "Text"],

Cell[BoxData[
    \(SortTwo[{x_, y_}] := {y, x} /; y > x\)], "Input"],

Cell[TextData[{
  "A recursive definition of ",
  StyleBox["SortList", "Input"],
  " switches any two consecutive elements of the list for which the first \
element is greater than the second element. To allow any number of elements \
before and after the pair under consideration, we use triple-blank patterns \
(",
  StyleBox["bef___", "Input"],
  " and ",
  StyleBox["aft___", "Input"],
  ") before and after the pair."
}], "Text"],

Cell[BoxData[
    \(Clear[SortList]\)], "Input"],

Cell[BoxData[
    \(SortList[{bef___, x_, y_, aft___}] := 
      SortList[{bef, y, x, aft}] /; y > x\)], "Input"],

Cell[TextData[{
  "When we give ",
  StyleBox["SortList", "Input"],
  " a list of numbers, the definition calls itself until no consecutive pairs \
of arguments have the property that the second is greater than the first."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SortList[Table[Random[Integer, {1, 10}], {15}]]\)], "Input"],

Cell[BoxData[
    \(SortList[{8, 6, 5, 4, 4, 4, 4, 3, 3, 3, 3, 2, 2, 2, 1}]\)], "Output"]
}, Closed]],

Cell[TextData[{
  "To define ",
  StyleBox["SortList", "Input"],
  " to return a list of sorted values, we define a second \
\[OpenCurlyDoubleQuote]fall-through\[CloseCurlyDoubleQuote] case that applies \
to any case that does not match the first pattern, and simply returns the \
argument."
}], "Text"],

Cell[BoxData[
    \(SortList[L_] := L\)], "Input"],

Cell[TextData[{
  "Now ",
  StyleBox["SortList", "Input"],
  " returns a sorted list."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SortList[Table[Random[Integer, {1, 10}], {15}]]\)], "Input"],

Cell[BoxData[
    \({10, 10, 8, 7, 7, 5, 4, 3, 3, 3, 3, 2, 1, 1, 1}\)], "Output"]
}, Closed]],

Cell[TextData[{
  "Define a function ",
  StyleBox["RemoveDuplicates", "Input"],
  " that removes duplicates from a list of elements."
}], "Question"],

Cell["\<\
To recognize duplicates we use the same pattern name twice in a \
function definition.\
\>", "Text"],

Cell[BoxData[
    \(AreTheseTheSame[x_, x_] := True\)], "Input"],

Cell["\<\
Here is a fall-through case that applies to nonmatching pairs.\
\>",
   "Text"],

Cell[BoxData[
    \(AreTheseTheSame[x_, y_] := False\)], "Input"],

Cell["Here is a test of our function.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \({AreTheseTheSame[1, 1], AreTheseTheSame[1, 2]}\)], "Input"],

Cell[BoxData[
    \({True, False}\)], "Output"]
}, Closed]],

Cell["\<\
Here is a recursive definition that recognizes duplicate elements \
in a list, with any number of elements (including zero) before, between, and \
after the duplicate items, using triple-blank patterns. (The function is \
defined so that for any duplicate pair, it discards the element that occurs \
later in the list.)\
\>", "Text"],

Cell[BoxData[
    \(RemoveDuplicates[{bef___, x_, betw___, x_, aft___}] := 
      RemoveDuplicates[{bef, x, betw, aft}]\)], "Input"],

Cell["Here is a list that contains some duplicate elements.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(listWithDuplicates = Table[Random[Integer, {1, 10}], {15}]\)], "Input"],

Cell[BoxData[
    \({1, 2, 3, 2, 3, 7, 8, 2, 4, 1, 8, 2, 1, 3, 4}\)], "Output"]
}, Closed]],

Cell["Here is a test of the function.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(RemoveDuplicates[listWithDuplicates]\)], "Input"],

Cell[BoxData[
    \(RemoveDuplicates[{1, 2, 3, 7, 8, 4}]\)], "Output"]
}, Closed]],

Cell[TextData[{
  "For ",
  StyleBox["RemoveDuplicates", "Input"],
  " to return a list, we define a fall-through case that matches any list \
that does not match the first case we defined, and returns just the list."
}], "Text"],

Cell[BoxData[
    \(RemoveDuplicates[L_] := L\)], "Input"],

Cell["The function now works as intended.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(RemoveDuplicates[listWithDuplicates]\)], "Input"],

Cell[BoxData[
    \({1, 2, 3, 7, 8, 4}\)], "Output"]
}, Closed]],

Cell[" ", "EndExercises"]
}, Closed]],

Cell[CellGroupData[{

Cell["Repeated Patterns", "Subsection"],

Cell[TextData[{
  "If we give the same name to more than one pattern inside a function, the \
arguments corresponding to the patterns must be the same. For example, the \
function ",
  StyleBox["deriv", "Input"],
  ", defined previously, requires the same symbol for both the base of the \
expression we wish to differentiate and the variable of differentiation; this \
is because the pattern for the base and the pattern for the variable of \
differentiation have the same name ",
  StyleBox["var", "Input"],
  "."
}], "Text"],

Cell[BoxData[
    \(deriv[var_\^n_, var_] := n\ var\^\(n - 1\)\)], "Input"],

Cell[TextData[{
  "Here is a function called ",
  StyleBox["merge", "Input"],
  " that accepts a pair of matching arguments, and returns one copy of the \
argument."
}], "Text"],

Cell[BoxData[
    \(merge[x_, x_] := x\)], "Input"],

Cell["Here is a case that matches the given patterns.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(merge[1, 1]\)], "Input"],

Cell[BoxData[
    \(1\)], "Output"]
}, Closed]],

Cell["This case does not match the patterns.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(merge[0, 1]\)], "Input"],

Cell[BoxData[
    \(merge[0, 1]\)], "Output"]
}, Closed]],

Cell[TextData[{
  "Unlike ",
  StyleBox["merge", "Input"],
  ", which was defined only for a sequence of two identical arguments, there \
are cases in which we do not know beforehand how many arguments will be \
given, and we require that the arguments be the same. For example, the \
following function requires a list of pairs as its argument."
}], "Text"],

Cell[BoxData[
    \(NPV[args : {{_, _}..}] := 
      \[Sum]\+\(i = 1\)\%\(Length[args]\)args[\([i, 1]\)]\ 
          1.05\^\(-args[\([i, 2]\)]\)\)], "Input"],

Cell[TextData[{
  "The double period ",
  StyleBox["..", "Input"],
  " in the pattern ",
  Cell[BoxData[
      \(args : {{_, _}..}\)], "Input"],
  " tells ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " that the pattern ",
  Cell[BoxData[
      \({_, _}\)], "Input"],
  " will be repeated one or more times; the entire structure is called ",
  StyleBox["args", "Input"],
  ". ",
  StyleBox["NPV", "Input"],
  " returns the net present value of payments whose amounts are defined by \
the first element in each pair in ",
  StyleBox["args", "Input"],
  ", to be paid at times defined by the second argument in each pair \
(assuming 5% interest compounded each period)."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NPV[{{p1, 1}, {p2, 4}, {p3, 10}}]\)], "Input"],

Cell[BoxData[
    \(0.952380952380952372`\ p1 + 0.822702474791882032`\ p2 + 
      0.613913253540759296`\ p3\)], "Output"]
}, Closed]],

Cell[TextData[{
  "If we give ",
  StyleBox["NPV", "Input"],
  " an argument that is not a list of pairs, it returns unevaluated."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NPV[{{1, 2}, {3, 4, 5}}]\)], "Input"],

Cell[BoxData[
    \(NPV[{{1, 2}, {3, 4, 5}}]\)], "Output"]
}, Closed]],

Cell[TextData[{
  "See also ",
  StyleBox["RepeatedNull", "Input"],
  " (",
  StyleBox["...", "Input"],
  ") "
}], "SeeAlso"],

Cell["Exercises: Repeated Patterns", "Exercises",
  PageBreakAbove->True],

Cell["\<\
Create a pattern that matches a list containing one or more lists \
of length 3.\
\>", "Question"],

Cell[TextData[{
  "The pattern ",
  Cell[BoxData[
      \({_, _, _}\)], "Input"],
  " matches a single list of length 3."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(MatchQ[{1, 2, 3}, {_, _, _}]\)], "Input"],

Cell[BoxData[
    \(True\)], "Output"]
}, Closed]],

Cell[TextData[{
  "To match a list containing one or more sublists of length 3, we use the \
repeated pattern ",
  Cell[BoxData[
      \({{_, _, _}..}\)], "Input"],
  ". Here are two tests of the pattern."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(MatchQ[{{1, 2, 3}, {2, 3, 4}, {3, 4, 5}}, {{_, _, _}..}]\)], "Input"],

Cell[BoxData[
    \(True\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(MatchQ[{{1, 2, 3, 4}, {2, 3}, {3, 4, 5}}, {{_, _, _}..}]\)], "Input"],

Cell[BoxData[
    \(False\)], "Output"]
}, Closed]],

Cell["\<\
Here is a simple function definition using the repeated \
pattern.\
\>", "Text"],

Cell[BoxData[
    \(ScatterPlot3D[L : {{_, _, _}..}] := 
      Show[Graphics3D[{PointSize[0.03], Map[Point, L]}]]\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(ScatterPlot3D[{{1, 1, 0}, {1, 0, 1}, {0, 1, 1}, {0, 0, 0}}]; \)\)], 
  "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.0855 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0567234 1.16608 2.22045e-16 1.16608 [
[ 0 0 0 0 ]
[ 1 1.0855 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.08846 .24555 m
0 .80374 L
s
0 .80374 m
.40037 1.0855 L
s
.40037 1.0855 m
.41799 .58158 L
s
.41799 .58158 m
.08846 .24555 L
s
.67245 0 m
.92713 .41497 L
s
.92713 .41497 m
1 .94814 L
s
1 .94814 m
.70644 .58546 L
s
.70644 .58546 m
.67245 0 L
s
.08846 .24555 m
0 .80374 L
s
0 .80374 m
.70644 .58546 L
s
.70644 .58546 m
.67245 0 L
s
.67245 0 m
.08846 .24555 L
s
.41799 .58158 m
.92713 .41497 L
s
.92713 .41497 m
1 .94814 L
s
1 .94814 m
.40037 1.0855 L
s
.40037 1.0855 m
.41799 .58158 L
s
0 0 m
1 0 L
1 1.0855 L
0 1.0855 L
closepath
clip
newpath
.03 w
.91022 .42206 Mdot
.40598 1.06315 Mdot
.10855 .26104 Mdot
.6952 .58531 Mdot
.25 Mabswid
.67245 0 m
.92713 .41497 L
s
.92713 .41497 m
1 .94814 L
s
1 .94814 m
.70644 .58546 L
s
.70644 .58546 m
.67245 0 L
s
.08846 .24555 m
0 .80374 L
s
0 .80374 m
.70644 .58546 L
s
.70644 .58546 m
.67245 0 L
s
.67245 0 m
.08846 .24555 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{265.25, 287.875},
  ImageMargins->{{35, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004900017`P10`4000010?ooobl_;oooZZVYZNSX
j?oo05FZZZZZZ_nZZS/k>gYjN[Vi^OShn03ooeGooj[ooonI<c<c<fi^KZf][Nc/k02ZoeFZojZZoonZ
oclo?ginO[fm_Oclo5D00:X00?l00?l0VCLg=g9bL[6a/O3`l03o05Go0:[o00<30d92@X61PL30`000
EED0EJX0EOl0ELbIoc/k>gIfM[Fe]OCdm03oEEGoEJ[oE@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0Z/`c
<clo?gYjN[Vi^OShn03oZUGoZZ[oZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`<30d92@WinO[fm_Ocl
o03ooeGooj[oo`l?3di>CXf=SLc<c01E05EE0:YE0?mE00L71dI6AX61PL30`000EED00:X00?l001<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@/;2dY:BXF5QLC4a000ZUD0EJX0EOl0EALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZPl?3di>CXV9RLS8b000oeD0ZZX0Z_l0ZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEoa<C
4e9BDXf=SLc<c01E05D0ojX0ool0oalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ01LG5eIFEY6ATM3@d01E
EEEE0:YE0?mE02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZEA/K6eYJFYFEUMCDe01EZUEEEJYEEOmEEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZQlO7eiNGYVIVMSHf01EoeEEZZYEZ_mEZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZob<S8f9RHYfMWMcLg02Z05EEojYEoomEobl_;fi^KZf][Nc/k03o05Go0:[o0=gW1RLW
9fIVIZ6QXN3Ph02ZEEFZ0:ZZ0?nZ03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooEB/[:fYZJZFUYNCTi02Z
ZUFZEJZZEOnZECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000;000_mG0000[@03o`030?l005H0002[00;o
1002oeH0002Y00;o1P000ol0o`1E0000YP03o`P000?o0?l0E@000:@00_l;0004o`00oe@0002R00;o
3@001?l00?mD0000W`03o`l000Go0000o`1C0000W@02oa8000?o00000P000ol0001@0000VP03oa@0
00?o00000P000ol0001@0000V002oaP000?o00000P000ol0001?0000UP02oaX000?o00000P000ol0
001?0000T`03oa`000?o00000`000ol0001>0000T@02oal000?o000010000ol0001=0000S`02ob40
00?o000010000ol0001=0000S003ob<000?o00001@000ol0001<0000RP02obH000?o00001P000ol0
001;0000R002obP000?o00001P000ol0001;0000Q@03obX000?o00001`000ol0001:0000P`02obd0
00?o00001`000ol0001:0000P003obl000?o000020000ol000190000OP02oc8000?o00002@000ol0
00180000O002oc@000?o00002@000ol000180000N@03ocH000?o00002P000ol000170000M`02ocT0
00?o00002P000ol000170000M@02oc/000?o00002`000ol000160000LP03ocd000?o000030000ol0
00150000L002od4000?o00002`000ol000150000K@03od<000?o000030000ol000140000J`02odH0
00?o00003@000ol000130000J@02odP000?o00003@000ol000130000IP03odX000?o00003P000ol0
00120000I002odd000?o00003P000ol000120000HP02odl000?o00003`000ol000110000G`03oe40
00?o000040000ol000100000G@02oe@000?o000040000ol000100000F`02oeH000?o00004@000ol0
000o0000F003oeP000?o00004@000ol0000o0000EP02oe/000?o00004P000ol0000n0000D`03oed0
00?o00004`000ol0000m0000D@02of0000?o00004`000ol0000m0000C`02of8000?o000050000ol0
000l0000C003of@000?o00005@000ol0000k0000BP02ofL000?o00005@000ol0000k0000B002ofX0
00?o00005@000ol0000j0000A@03of`000?o00005@000ol0000j0000@`02ofl000?o00005P000ol0
000i0000@003og4000?o00005`000ol0000h0000?P02og@000?o00005`000ol0000h0000?002ogH0
00?o000060000ol0000g0000>@03ogP000?o000060000ol0000g0000=`02og/000?o00006@000ol0
000f0000=@02ogd000?o00006P000ol0000e0000<P03ogl000?o00006P000ol0000e0000<002oh80
00?o00006`000ol0000d0000;P02oh@000?o000070000ol0000c0000:`03ohH000?o000070000ol0
000c0000:@02ohT000?o00007@000ol0000b00009P03oh/000?o00007@000ol0000b00009002ohh0
00?o00007P000ol0000a00008P02oi0000?o00007`000ol0000`00007`03oi<000?o00007P000ol0
000`00007@02oiH000?o00007`000ol0000_00006`02oiP000?o00007`000ol0000_00006003oiX0
00?o000080000ol0000^00005`000ol0002K0003o`00024000?o0000;@0001L000Co00000onG0003
o`00024000?o0000;@0001L00_l00`3oo`03oiH000?o00008P000ol0000/00005`000ol0o`06oiD0
00?o00008P000ol0000/00005P000ol00007oiD000?o00008`000ol0000[00005P000ol00007oiD0
00?o000090000ol0000Z00005P001?l00005oiH000?o000090000ol0000Z00005P000ol0000200?o
U`000ol0000U0003o`0002T0000F0003o`0000D000?o0000U0000ol0000V0003o`0002P0000F0003
o`0000H000?o0000T`000ol0000V0003o`0002P0000F0003o`0000L000?o0000TP000ol0000W0003
o`0002L0000E0003o`0000T000?o0000T@000ol0000W0003o`0002L0000E0003o`0000X000?o0000
T0000ol0000X0003o`0002H0000E0003o`0000/000?o0000T0000ol0000X0003o`0002D0000E0003
o`0000`000?o0000S`000ol0000X0003o`0002D0000E0003o`0000d000?o0000SP000ol0000Y0003
o`0002@0000E0003o`0000h000?o0000S@000ol0000Y0003o`0002@0000D0003o`00010000?o0000
S0000ol0000Z0003o`0002<0000D0003o`00014000?o0000R`000ol0000[0003o`000280000D0003
o`00018000?o0000RP000ol0000[0003o`000280000D0003o`0001<000?o0000R@000ol0000/0003
o`000240000D0003o`0001@000?o0000R0000ol0000]0003o`000200000D0003o`0001D000?o0000
Q`000ol0000]0003o`000200000C0003o`0001L000?o0000QP000ol0000^0003o`0001l0000C0003
o`0001P000?o0000Q@000ol0000^0003o`0001l0000C0003o`0001T000?o0000Q0000ol0000_0003
o`0001h0000C0003o`0001X000?o0000P`000ol0000`0003o`0001d0000C0003o`0001/000?o0000
PP000ol0000`0003o`0001d0000C0003o`0001`000?o0000P@000ol0000a0003o`0001`0000C0003
o`0001d000?o0000P0000ol0000a0003o`0001`0000B0003o`0001l000?o0000P0000ol0000a0003
o`0001/0000B0003o`00020000?o0000O`000ol0000b0003o`0001X0000B0003o`00024000?o0000
OP000ol0000b0003o`0001X0000B0003o`00028000?o0000O@000ol0000c0003o`0001T0000B0003
o`0002<000?o0000O0000ol0000d0003o`0001P0000B0003o`0002@000?o0000N`000ol0000d0003
o`0001P0000A0003o`0002H000?o0000NP000ol0000e0003o`0001L0000A0003o`0002L000?o0000
N@000ol0000e0003o`0001L0000A0003o`0002P000?o0000N0000ol0000f0003o`0001H0000A0003
o`0002T000?o0000M`000ol0000g0003o`0001D0000A0003o`0002X000?o0000MP000ol0000g0003
o`0001D0000A0003o`0002/000?o0000M@000ol0000h0003o`0001@0000A0003o`0002`000?o0000
M0000ol0000h0003o`0001@0000@0003o`0002h000?o0000L`000ol0000i0003o`0001<0000@0003
o`0002l000?o0000LP000ol0000e00Ko5000010000?o0000<0000ol0001a0003o`0003@01Ol00`3o
000C000040000ol0000a0003o`00070000?o0000<P09oa@0000@0003o`00038000?o0000L0000ol0
000^00?o00<0ool01_lD000040000ol0000c0003o`0006l000?o0000:`03o`@02?lD00003`000ol0
000e0003o`0006h000?o0000:003o`P01Ol20003o`000140000?0003o`0003H000?o0000K@000ol0
000U00?o3003o`<000?o00004@0000l000?o0000=`000ol0001/0003o`0002800olE0003o`000140
000?0003o`0003P000?o0000J`000ol0000O00?o60000ol0000A00003`000ol0000i0003o`0006X0
00?o00007003oa/000?o00004@0000l000?o0000>P000ol0001Y0003o`0001T00olN0003o`000140
000>0003o`0003`000?o0000J0000ol0000F00?o8@000ol0000A00003P000ol0000m0003o`0006L0
00?o00004`03obD000?o0000400000h000?o0000?P000ol0001V0003o`0001000olX0003o`000100
000>0003o`0003l000?o0000I@000ol0000=00?o:`000ol0000@00003P000ol000100003o`0006@0
00?o00002P03obh000?o0000400000h000?o0000@@000ol0001S0003o`0000L00ola0003o`000100
000>0003o`00048000?o0000HP000ol0000400?o=0000ol0000@00003@000ol000140003o`000640
00Co00000olg0003o`000100000=0003o`0004D000?o0000H004oc/000?o00003`0000d000?o0000
AP000ol0001M00Co?@000ol0000?00003@000ol000170003o`0005T00ol30003o`0003/000?o0000
3`0000d000?o0000B0000ol0001D00Co1P000ol0000k0003o`0000l0000=0003o`0004T000?o0000
D003o`X000?o0000>`000ol0000?000030000ol0001;0003o`0004`00ol=0003o`0003/000?o0000
3`0000`000?o0000C0000ol0001800?o40000ol0000k0003o`0000l0000<0003o`0004d000?o0000
A003oa<000?o0000?0000ol0000>000030000ol0001>0003o`0004000olF0003o`0003`000?o0000
3P0000`000?o0000C`000ol0000l00?o6@000ol0000l0003o`0000h0000<0003o`00050000?o0000
>003oa`000?o0000?0000ol0000>00002`000ol0001B0003o`0003@00olO0003o`0003`000?o0000
3P0000/000?o0000D`000ol0000`00?o8P000ol0000l0003o`0000h0000;0003o`0005@000?o0000
;003obD000?o0000?0000ol0000>00002`000ol0001E0003o`0002P00olX0003o`0003d000?o0000
3@0000/000?o0000EP000ol0000T00?o:`000ol0000m0003o`0000d0000;0003o`0005L000?o0000
8003obh000?o0000?@000ol0000=00002`000ol0001H0003o`0001`00ola0003o`0003d000?o0000
3@0000X000?o0000FP000ol0000H00?o=@000ol0000l0003o`0000d0000:0003o`0005/000?o0000
5003ocP000?o0000?0000ol0000=00002P000ol0001L0003o`0001000olk0003o`0003`000?o0000
3@0000X000?o0000G@000ol0000<00?o?P000ol0000m0003o`0000`0000:0003o`0005h000?o0000
2003od4000?o0000?@000ol0000<00002P000ol0001O0003o`0000@00om40003o`0003d000?o0000
300000T000?o0000H@000ol00003od<00ol00`3o000n0003o`0000`000090003o`0006800_m500Ko
?`000ol0000<00002@000ol0001R0003o`0004<01olo0003o`0000`000090003o`00068000?o0000
@`07ocl000?o0000300000T000?o0000HP000ol0001100[o?`000ol0000;00002@000ol0001R0003
o`0003h00ol300Go0P000ol0000l0003o`0000/000090003o`00068000?o0000>`03o`L00ol40003
o`0003/000?o00002`0000P000?o0000H`000ol0000g00Co4P000ol0000j0003o`0000/000080003
o`0006<000?o0000=003oaH000?o0000>P000ol0000;000020000ol0001S0003o`0003400olJ0003
o`0003T000?o00002`0000P000?o0000H`000ol0000^00?o7P000ol0000h0003o`0000/000080003
o`0006<000?o0000:`03ob8000?o0000>0000ol0000:000020000ol0001S0003o`0002L01?lV0003
o`0003L000?o00002P0000L000?o0000I0000ol0000T00?o:`000ol0000f0003o`0000X000070003
o`0006@000?o00008@03obh000?o0000=P000ol0000:00001`000ol0001S0003o`0001l00olb0003
o`0003D000?o00002P0000L000?o0000H`000ol0000K00Co=P000ol0000d0003o`0000X000070003
o`0006<000?o00006003oc/000?o0000<`000ol0000:00001`000ol0001S0003o`0001D00olo0003
o`0003<000?o00002@0000H000?o0000I0000ol0000B00?o@P000ol0000c0003o`0000T000060003
o`0006@000?o00003`03odH000?o0000<P000ol0000900001P000ol0001T0003o`0000/01?m:0003
o`00034000?o00002@0000H000?o0000I0000ol0000800?oC`000ol0000`0003o`0000T000060003
o`0006@000?o00001@03oe<000?o0000;`000ol0000900001P000ol0001T0003o`0000800omF0003
o`0002l000?o00002@0000H000?o0000I0000ol0o`02oeX000?o0000;`000ol0000800001@000ol0
001S00CoGP000ol0000^0003o`0000P000050003o`0006000ol20003o`0005h000?o0000;@000ol0
000800001@000ol0001M00?o1@000ol0001O0003o`0002`000?o0000200000D000?o0000FP03o`P0
00?o0000H0000ol0000[0003o`0000P000050003o`0005L00ol;0003o`00060000?o0000:`000ol0
000800001@000ol0001C00Co3P000ol0001Q0003o`0002X000?o0000200000@000?o0000D@03oa80
00?o0000HP000ol0000Z0003o`0000L000040003o`0004h00olE0003o`0006<000?o0000:@000ol0
0007000010000ol0001;00?o60000ol0001T0003o`0002P000?o00001`0000@000?o0000B003oa/0
00?o0000I0000ol0000X0003o`0000L000040003o`0004@01?lN0003o`0006D000?o00009`000ol0
0007000010000ol0001100?o8P000ol0001V0003o`0002H000?o00001`0000@000?o0000?P03obD0
00?o0000I`000ol0000U0003o`0000L000030003o`0003`00olX0003o`0006P000?o00009@000ol0
000600000`000ol0000i00?o:`000ol0001X0003o`0002D000?o00001P0000<000?o0000=@04obh0
00?o0000J@000ol0000T0003o`0000H000030003o`0003800ola0003o`0006/000?o00008`000ol0
000600000`000ol0000_00?o=0000ol0001/0003o`00028000?o00001P0000<000?o0000;003ocL0
00?o0000K@000ol0000Q0003o`0000H000020003o`0002T01?lj0003o`0006h000?o000080000ol0
000600000P000ol0000V00?o?P000ol0001^0003o`00024000?o00001@00008000?o00008`03od40
00?o0000K`000ol0000P0003o`0000D000020003o`0002000om40003o`00070000?o00007`000ol0
000500000P000ol0000M00?oA`000ol0001a0003o`0001h000?o00001@00008000?o00006@04odX0
00?o0000LP000ol0000M0003o`0000D000000`3o000H00?oCP000ol0001b0003o`0001d000?o0000
1@0000030?l001D00omA0003o`0007<000?o000070000ol00005000000<0o`004P03oe@000?o0000
M0000ol0000L0003o`0000@000000`3o000?00?oE`000ol0001e0003o`0001/000?o000010000003
0?l000/01?mJ0003o`0007H000?o00006P000ol00004000000<0o`002003oeh000?o0000MP000ol0
000J0003o`0000@000000`3o000500?oH@000ol0001g0003o`0001T000?o000010000003o`000080
0omT0003o`0007P000?o000060000ol00004000000?o0?l00_mW0003o`0007T000?o00005`000ol0
000400000_mZ0003o`0007X000?o00005`000ol0000300000P000ol0001W0003o`0007/000?o0000
5P000ol0000300000`02ofL000?o0000N`000ol0000F0003o`0000<000050003o`0006@000?o0000
O0000ol0000E0003o`0000<000060003o`0006<000?o0000O@000ol0000D0003o`0000<0000700;o
H`000ol0001n0003o`0001<000?o00000`0000T000?o0000H0000ol0001o0003o`00018000?o0000
0`0000X00_mP0003o`0007l000?o00004`000ol00002000030000ol0001L0003o`00084000?o0000
4P000ol0000200003@000ol0001K0003o`00088000?o00004@000ol0000200003P02oe/000?o0000
P`000ol0000@0003o`000080000@0003o`0005P000?o0000Q0000ol0000?0003o`000080000A00;o
F0000ol000240003o`0000l000?o00000P0001<000?o0000E@000ol000250003o`0000h000?o0000
0P0001@00_mE0003o`0008H000?o00003P000ol0000100005P000ol0001B0003o`0008L000?o0000
3@000ol0000100005`000ol0001A0003o`0008P000?o000030000ol0000100006002oe4000?o0000
R@000ol0000;0003o`000040000J0003o`0004h000?o0000R@000ol0000;0003o`000040000K00;o
CP000ol0002:0003o`0000X000?o00000@0001d000?o0000B`000ol0002;0003o`0000T000?o0000
0@0001h00_m;0003o`0008`000?o00002@01o`400@00020000?o0000B0000ol0002=0003o`0000P0
0Ol10040000Q0003o`0004L000?o0000S@000ol00008007o0@0100008P02odL000?o0000SP000ol0
0007007o0@01000090000ol000140003o`0008l000?o00001P01o`400@0002D00_m40003o`000900
00?o00001@01o`400@0002L000?o0000@@000ol0002A0003o`0000@00Ol10040000X0003o`000400
00?o0000T@000ol00005007o0@0002T00_m00003o`00098000?o00001001o`40000[0003o`0003d0
00?o0000T`000ol00003007o0@0002`00_lm0003o`0009@000?o00000P01o`40000^0003o`0003X0
00?o0000U@001Ol0003o0040000_00;o>P000ol0002F0004o`00o`40000a0003o`0003L000?o0000
UP001?l00?l10000<P000ol0000e0003o`0009P000?o00000Ol003<00_le0003o`0009T00Ol1007o
000e0003o`00038000?o0000VP02o`00=P02oc8000?o0000V@03o`00>0000ol0000_0003o`0009@0
1Ol30000>@000ol0000^0003o`0009001?l80000>P02obh000?o0000S004o``0000l0003o`0002/0
00?o0000Q`05oa00000m00;o:`000ol0002300Co5@0003l000?o0000:0000ol0001n00Go6@000400
0_lX0003o`0007X01?lN0000@P000ol0000U0003o`0007D01OlR0000@`000ol0000T0003o`000740
1?lW0000A002ob@000?o0000K@04ob/000160003o`00024000?o0000J005obl0001700;o8@000ol0
001T00Co=00004T000?o00007P000ol0001O00Go>00004X000?o00007@000ol0001K00Co?@0004/0
0_lM0003o`0005L01?m10000C@000ol0000J0003o`0005801Om50000CP02oaX000?o0000CP04odX0
001@0003o`0001L000?o0000B@05odh0001A00;o5`000ol0001500CoD`0005<000?o000050000ol0
001000GoE`0005@000?o00004`000ol0000l00CoG00005D00_lC0003o`0003P01?mP0000E`000ol0
000@0003o`0003<01OmT0000F002o`l000?o0000<004ofT0001J0003o`0000`000?o0000:`05ofd0
001K00;o30000ol0000W00CoLP0005d000?o00002@000ol0000S00CoMP0005h000?o00002003oah0
1Omj0000G`02o`L01OlI00CoO`00064000?o00000`07oa<01On30000HP02o`<01ol?00CoR00006@0
00?o00001ol:00GoS00006D000?o00001Ol700CoT@0006H00_l0103oool400CoU@0006P00_l00`3o
o`03oiT0001Y00;oWP000001
\>"],
  ImageRangeCache->{{{0, 264.25}, {286.875, 0}} -> {0.0486402, -5.59716, 
  0.00324535, 0.00324535}}]
}, Closed]],

Cell[" ", "EndExercises"]
}, Closed]],

Cell[CellGroupData[{

Cell["Upvalues", "Subsection"],

Cell[TextData[{
  "The typical function definitions we have seen have the following form. The \
left side of the definition has the head ",
  StyleBox["mylog", "Input"],
  ", and consequently ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " attaches the definition to the symbol ",
  StyleBox["mylog", "Input"],
  "."
}], "Text"],

Cell[BoxData[
    \(mylog[x_\ y_] := mylog[x] + mylog[y]\)], "Input"],

Cell[TextData[{
  "In some cases, however, we want to associate a function definition with a \
symbol that is not the head of the left side of the definition. For example, \
if we want a product of ",
  StyleBox["myexp", "Input"],
  " functions to simplify to ",
  StyleBox["myexp", "Input"],
  " of the sum of the arguments, we might enter the following definition."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(myexp[x_]\ myexp[y_] := myexp[x + y]\)], "Input"],

Cell[BoxData[
    \(SetDelayed::"write" \( : \ \) 
      "Tag \!\(Times\) in \!\(\(myexp[x_]\)\\ \(myexp[y_]\)\) is \
Protected."\)], "Message"],

Cell[BoxData[
    \($Failed\)], "Output"]
}, Closed]],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " is unable to create this rule because a product of ",
  StyleBox["myexp", "Input"],
  " functions has the head ",
  StyleBox["Times", "Input"],
  ", and ",
  StyleBox["Times", "Input"],
  " is protected against accidental modification, meaning we cannot by \
default attach new definitions to it. Here we see that the head of the left \
side of the previous definition is ",
  StyleBox["Times", "Input"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Head[myexp[x_] myexp[y_]]\)], "Input"],

Cell[BoxData[
    \(Times\)], "Output"]
}, Closed]],

Cell[TextData[{
  "One way to teach ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " this definition is to define an ",
  StyleBox["upvalue",
    FontSlant->"Italic"],
  " for ",
  StyleBox["myexp", "Input"],
  "; that is, a definition whose left side has the head ",
  StyleBox["Times", "Input"],
  ", but which should be attached to the symbol ",
  StyleBox["myexp", "Input"],
  "."
}], "Text"],

Cell[BoxData[
    \(myexp /: myexp[x_]\ myexp[y_] := myexp[x + y]\)], "Input"],

Cell[TextData[{
  "Now ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " attaches the simplification rule to ",
  StyleBox["myexp", "Input"],
  " and not ",
  StyleBox["Times", "Input"],
  ", and carries out the desired simplification."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(myexp[a\ b] myexp[c] myexp[d]\)], "Input"],

Cell[BoxData[
    \(myexp[a\ b + c + d]\)], "Output"]
}, Closed]],

Cell[TextData[{
  "The on-line help displays the upvalue for ",
  StyleBox["myexp", "Input"],
  " using the abbreviation ",
  StyleBox["^:=", "Input"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(?myexp\)\)], "Input"],

Cell[BoxData[
    \("Global`"\[InvisibleSpace]"myexp"\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      StyleBox["\(myexp[x_]*myexp[y_]\\  ^:= \\ myexp[x\\  + \\ y]\)",
        ShowStringCharacters->True,
        NumberMarks->True],
      InputForm[ 
        Definition[ myexp]],
      Editable->True,
      AutoDelete->True]], "Print"]
}, Closed]],

Cell[TextData[{
  "See also ",
  StyleBox["DownValues", "Input"],
  ", ",
  StyleBox["OwnValues", "Input"],
  ", ",
  StyleBox["NValues", "Input"],
  ", ",
  StyleBox["UpSetDelayed", "Input"],
  ", ",
  StyleBox["UpSet", "Input"],
  ", ",
  StyleBox["TagSetDelayed", "Input"],
  ", ",
  StyleBox["TagSet", "Input"],
  ", ",
  StyleBox["Unprotect", "Input"]
}], "SeeAlso"],

Cell["Exercises: Upvalues", "Exercises",
  PageBreakAbove->True],

Cell[TextData[{
  "Create a symbol ",
  StyleBox["Undefined", "Input",
    FontFamily->"Courier"],
  " that has the property that if it is used in a sum or product, the result \
is the symbol ",
  StyleBox["Undefined", "Input",
    FontFamily->"Courier"],
  "."
}], "Question"],

Cell[TextData[{
  "Because we cannot attach new rules to the operators ",
  StyleBox["Plus", "Input"],
  " and ",
  StyleBox["Times", "Input"],
  ", we must define upvalues for the symbol ",
  StyleBox["Undefined", "Input"],
  ". The following two rules state that if ",
  StyleBox["Undefined", "Input"],
  " is used in a sum or product, the result is the symbol ",
  StyleBox["Undefined", "Input"],
  "."
}], "Text"],

Cell[BoxData[
    \(Undefined /: Undefined + _ := Undefined\)], "Input"],

Cell[BoxData[
    \(Undefined /: Undefined*_ := Undefined\)], "Input"],

Cell[CellGroupData[{

Cell["2 Undefined + 1/2", "Input"],

Cell[BoxData[
    \(Undefined\)], "Output"]
}, Closed]],

Cell[" ", "EndExercises"]
}, Closed]],

Cell[CellGroupData[{

Cell["The Ordering of Definitions", "Subsection"],

Cell[TextData[{
  "The principle ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " uses to order multiple definitions for a function is to apply specific \
rules before applying more general rules, in order to keep specific rules \
from being shadowed by general rules. For example, here are two definitions \
for the factorial function ",
  StyleBox["fac", "Input"],
  " (after clearing any previous definitions)."
}], "Text"],

Cell[BoxData[{
    \(\(Clear[fac]; \)\), 
    \(\(fac[n_] := n\ fac[n - 1]; \)\), 
    \(\(fac[0] = 1; \)\)}], "Input"],

Cell[TextData[{
  "Asking for information about ",
  StyleBox["fac", "Input"],
  " reveals the rules ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " uses when computing values of ",
  StyleBox["fac", "Input"],
  ", and the order in which the rules are applied. We see in the following \
listing that the specific definition ",
  Cell[BoxData[
      \(fac[0] = 1\)], "Input"],
  " is tried before the more general definition ",
  Cell[BoxData[
      \(fac[n_] := n\ fac[n - 1]\)], "Input"],
  "; if this were not the case, the definition attached to ",
  Cell[BoxData[
      \(fac[0]\)], "Input"],
  " would never be applied."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(?fac\)\)], "Input"],

Cell[BoxData[
    \("Global`"\[InvisibleSpace]"fac"\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      StyleBox[
        "\(fac[0]\\  = \\ 1\\n\\ \\n         fac[n_]\\  := \\ n*fac[n\\  - \\ \
1]\)",
        ShowStringCharacters->True,
        NumberMarks->True],
      InputForm[ 
        Definition[ fac]],
      Editable->True,
      AutoDelete->True]], "Print"]
}, Closed]],

Cell[TextData[{
  "The rules attached to a function are called its ",
  StyleBox["downvalues",
    FontSlant->"Italic"],
  ", and we can get a list of a function\[CloseCurlyQuote]s downvalues by \
entering ",
  StyleBox["DownValues[", "Input"],
  StyleBox["FunctionName",
    FontSlant->"Italic"],
  StyleBox["]", "Input"],
  ". Items found earlier in the list of downvalues are applied before items \
found later in the list."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(DownValues[fac]\)], "Input"],

Cell[BoxData[
    \({HoldPattern[fac[0]] \[RuleDelayed] 1, 
      HoldPattern[fac[n_]] \[RuleDelayed] n\ fac[n - 1]}\)], "Output"]
}, Closed]],

Cell[TextData[{
  "In some cases ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " cannot determine which rule among a set of rules is more general. In this \
case, ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " evaluates the rules according to the order in which they were entered. \
Here are two equally general definitions."
}], "Text"],

Cell[BoxData[
    \(ambig[x_Integer, y_] := "rule one"\)], "Input"],

Cell[BoxData[
    \(ambig[x_, y_Integer] := "rule two"\)], "Input"],

Cell[TextData[{
  "In this case, ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " applies the first definition to arguments that match both definitions."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ambig[1, 2]\)], "Input"],

Cell[BoxData[
    \("rule one"\)], "Output"]
}, Closed]],

Cell["\<\
To change the order in which definitions are applied, we manipulate \
the list of downvalues. Here is the current ordering.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(DownValues[ambig]\)], "Input"],

Cell[BoxData[
    \({HoldPattern[ambig[x_Integer, y_]] \[RuleDelayed] "rule one", 
      HoldPattern[ambig[x_, y_Integer]] \[RuleDelayed] "rule two"}\)], 
  "Output"]
}, Closed]],

Cell["\<\
Here we reverse the order in which the definitions are \
applied.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(DownValues[ambig] = Reverse[DownValues[ambig]]\)], "Input"],

Cell[BoxData[
    \({HoldPattern[ambig[x_, y_Integer]] \[RuleDelayed] "rule two", 
      HoldPattern[ambig[x_Integer, y_]] \[RuleDelayed] "rule one"}\)], 
  "Output"]
}, Closed]],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " now applies the second definition."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ambig[1, 2]\)], "Input"],

Cell[BoxData[
    \("rule two"\)], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Transformation Rules", "Subsection"],

Cell["\<\
Functions work by replacing the dummy variables in the right-hand \
side of a definition with specific values, which are entered as arguments to \
the function. Another general method for substituting particular values into \
an expression is to use transformation rules.\
\>", "Text"],

Cell[TextData[{
  "One way to substitute particular values for the variables ",
  StyleBox["x", "Input"],
  " and ",
  StyleBox["y", "Input"],
  " in the formula ",
  Cell[BoxData[
      \(Sqrt[x^2\  + \ y^2]\)], "Input"],
  " is to assign particular values to ",
  StyleBox["x", "Input"],
  " and ",
  StyleBox["y", "Input"],
  ", then evaluate the formula. Here we set ",
  StyleBox["y", "Input"],
  " equal to 7."
}], "Text"],

Cell[BoxData[
    \(\(y = 7; \)\)], "Input"],

Cell[TextData[{
  "Evaluating ",
  Cell[BoxData[
      \(Sqrt[x^2\  + \ y^2]\)], "Input"],
  " now reflects the new value of ",
  StyleBox["y", "Input"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Sqrt[x\^2 + y\^2]\)], "Input"],

Cell[BoxData[
    \(\@\(49 + x\^2\)\)], "Output"]
}, Closed]],

Cell[TextData[{
  "One problem with this approach is that the value 7 is substituted wherever \
",
  StyleBox["y", "Input"],
  " appears in an expression evaluated after the assignment, at least until ",
  
  StyleBox["y", "Input"],
  " is cleared of its value. For instance, if we try to solve an equation \
with respect to ",
  StyleBox["y", "Input"],
  ", ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " substitutes the value 7 into ",
  StyleBox["y", "Input"],
  ", in effect assuming we want to solve the equation with respect to 7."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Solve[y\^10 + x\^10 == 1, y]\)], "Input"],

Cell[BoxData[
    \(General::"ivar"\(:\ \)"\!\(7\) is not a valid variable."\)], "Message"],

Cell[BoxData[
    \(Solve[282475249 + x\^10 == 1, 7]\)], "Output"]
}, Closed]],

Cell[TextData[{
  "To clear the value of ",
  StyleBox["y", "Input"],
  ", we use ",
  StyleBox["Clear", "Input"],
  "."
}], "Text"],

Cell[BoxData[
    \(Clear[y]\)], "Input"],

Cell[TextData[{
  "A better method for replacing variables (or any subpart of an expression) \
with particular values is to use transformation rules, or simply ",
  StyleBox["rules",
    FontSlant->"Italic"],
  ". A rule is an object of the form ",
  Cell[TextData[{
    StyleBox["before",
      FontSlant->"Italic"],
    " ",
    StyleBox["->", "Input"],
    " ",
    StyleBox["after",
      FontSlant->"Italic"]
  }], "Text"],
  " (with internal form ",
  Cell[TextData[{
    StyleBox["Rule[", "Input"],
    StyleBox["before",
      FontSlant->"Italic"],
    StyleBox[",", "Input"],
    " ",
    StyleBox["after",
      FontSlant->"Italic"],
    StyleBox["]", "Input"]
  }], "Text"],
  "), and we carry out a substitution by using the slash-period ",
  StyleBox["/.", "Input"],
  " operator in the form ",
  Cell[TextData[{
    StyleBox["expr",
      FontSlant->"Italic"],
    " ",
    StyleBox["/.", "Input"],
    " ",
    StyleBox["rules",
      FontSlant->"Italic"]
  }], "Text"],
  ", where ",
  StyleBox["expr",
    FontSlant->"Italic"],
  " is the expression to which the rules apply, and ",
  StyleBox["rules",
    FontSlant->"Italic"],
  " is a single rule or list of rules. (The internal form of ",
  Cell[TextData[{
    StyleBox["expr",
      FontSlant->"Italic"],
    " ",
    StyleBox["/.", "Input"],
    " ",
    StyleBox["rules",
      FontSlant->"Italic"]
  }], "Text"],
  " is ",
  Cell[TextData[{
    StyleBox["ReplaceAll[", "Input"],
    StyleBox["expr",
      FontSlant->"Italic"],
    StyleBox[",", "Input"],
    " ",
    StyleBox["rules",
      FontSlant->"Italic"],
    StyleBox["]", "Input"]
  }], "Text"],
  ".)"
}], "Text"],

Cell[TextData[{
  "For example, to replace ",
  StyleBox["y", "Input"],
  " in the expression ",
  Cell[BoxData[
      \(Sqrt[x^2\  + \ y^2]\)], "Input"],
  " with 7, we type the following."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Sqrt[x\^2 + y\^2] /. y -> 7\)], "Input"],

Cell[BoxData[
    \(\@\(49 + x\^2\)\)], "Output"]
}, Closed]],

Cell[TextData[{
  "Although we replaced ",
  StyleBox["y", "Input"],
  " with 7 in the expression, the global value for ",
  StyleBox["y", "Input"],
  " remains undefined."
}], "Text"],

Cell[CellGroupData[{

Cell["y", "Input"],

Cell[BoxData[
    \(y\)], "Output"]
}, Closed]],

Cell[TextData[{
  "We are not limited to numerical replacements. Here we replace ",
  StyleBox["y", "Input"],
  " with ",
  Cell[BoxData[
      \(1 + a\)], "Input"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Sqrt[x\^2 + y\^2] /. y -> 1 + a\)], "Input"],

Cell[BoxData[
    \(\@\(\((1 + a)\)\^2 + x\^2\)\)], "Output"]
}, Closed]],

Cell["\<\
We can replace any number of variables in an expression with other \
values by giving a list of replacement rules.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Sqrt[x\^2 + y\^2] /. {x -> 12, y -> 5}\)], "Input"],

Cell[BoxData[
    \(13\)], "Output"]
}, Closed]],

Cell[TextData[{
  "We can also create a list of expressions corresponding to different sets \
of replacement rules by telling ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " to substitute more than one set of values for an expression. In the \
following we compute three values for ",
  Cell[BoxData[
      \(Sqrt[x^2 + y^2]\)], "Input"],
  " by substituting into it a list containing three lists of replacement \
rules."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Sqrt[x\^2 + y\^2]
         /. {{x \[Rule] 3, y \[Rule] 4}, {x \[Rule] 12, y \[Rule] 5}, {
          x \[Rule] 1, y \[Rule] 1}}\)], "Input"],

Cell[BoxData[
    \({5, 13, \@2}\)], "Output"]
}, Closed]],

Cell[TextData[{
  "A subtle case arises when we perform more than one substitution on an \
expression with only one variable. For instance, to substitute two values for \
",
  StyleBox["x", "Input"],
  " into an expression we might try the following."
}], "Text"],

Cell[BoxData[
    \(\(ex = Log[x\ \((1 - x)\)]; \)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(ex /. {x \[Rule] 0.35, x \[Rule] 0.55}\ 
     (*this\ is\ incorrect*) \)\)], "Input"],

Cell[BoxData[
    \(\(-1.48060504059113196`\)\)], "Output"]
}, Closed]],

Cell[TextData[{
  "While we may have expected two values in return, we see that ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " returned only one value. The reason is that ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " performs the substitutions from left to right: First the rule ",
  Cell[BoxData[
      \(x -> 0.35\)], "Input"],
  " was applied to ",
  StyleBox["ex", "Input"],
  ", replacing all occurrences of ",
  StyleBox["x", "Input"],
  " with 0.35; then the rule ",
  Cell[BoxData[
      \(x -> 0.55\)], "Input"],
  " was applied to ",
  StyleBox["that",
    FontSlant->"Italic"],
  " result, which was free of any occurrences of ",
  StyleBox["x", "Input"],
  "."
}], "Text"],

Cell[TextData[{
  "To avoid this difficulty, we must put each set of replacement rules inside \
its own list, even if each set contains only one rule: this indicates to ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " that each replacement rule should be considered a separate solution set."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(ex /. {{x \[Rule] 0.35}, {x \[Rule] 0.55}}\ 
     (*this\ is\ correct*) \)\)], "Input"],

Cell[BoxData[
    \({\(-1.48060504059113196`\), \(-1.39634469697339213`\)}\)], "Output"]
}, Closed]],

Cell[TextData[{
  "In general, ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " will return as many values from a substitution as there are sets of \
replacement rules."
}], "Text"],

Cell[TextData[{
  "Replacement rules are important because functions such as ",
  StyleBox["Solve", "Input"],
  " return results in the form of a list of lists of replacement rules."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Solve[x\^2 - 1 == 0, x]\)], "Input"],

Cell[BoxData[
    \({{x \[Rule] \(-1\)}, {x \[Rule] 1}}\)], "Output"]
}, Closed]],

Cell["\<\
Here we verify the solutions by substituting each one into the \
original equation.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(x\^2 - 1 == 0 /. x \[Rule] \(-1\)\)], "Input"],

Cell[BoxData[
    \(True\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(x\^2 - 1 == 0 /. x \[Rule] 1\)], "Input"],

Cell[BoxData[
    \(True\)], "Output"]
}, Closed]],

Cell["\<\
Instead of testing the solutions separately, we can test both \
solutions at the same time by substituting a list of solution sets into the \
equation.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(x\^2 - 1 == 0 /. {{x \[Rule] \(-1\)}, {x \[Rule] 1}}\)], "Input"],

Cell[BoxData[
    \({True, True}\)], "Output"]
}, Closed]],

Cell[TextData[{
  "A more efficient way to do the same thing is to name the list of \
replacement rules. Here we solve the same equation, this time naming the \
solution set of replacement rules ",
  StyleBox["solset", "Input"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(solset = Solve[x\^2 - 1 == 0, x]\)], "Input"],

Cell[BoxData[
    \({{x \[Rule] \(-1\)}, {x \[Rule] 1}}\)], "Output"]
}, Closed]],

Cell[TextData[{
  "Instead of retyping the solutions, we can directly substitute ",
  StyleBox["solset", "Input"],
  " into the equation (note that the entire rule is contained in ",
  StyleBox["solset", "Input"],
  ", so it is important not to type ",
  Cell[BoxData[
      \(x -> solset\)], "Input"],
  ")."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(x\^2 - 1 == 0 /. solset\)], "Input"],

Cell[BoxData[
    \({True, True}\)], "Output"]
}, Closed]],

Cell["\<\
Similarly, we can generate a list containing only the solutions by \
substituting the rules containing the solutions into the variable(s) of the \
equation.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(x /. solset\)], "Input"],

Cell[BoxData[
    \({\(-1\), 1}\)], "Output"]
}, Closed]],

Cell["\<\
Any part of an expression can be replaced with another symbol or \
expression.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Sin[x] /. Sin \[Rule] Cos\)], "Input"],

Cell[BoxData[
    \(Cos[x]\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Sin[x] /. {Sin \[Rule] Cos, x \[Rule] 1 + y\^2}\)], "Input"],

Cell[BoxData[
    \(Cos[1 + y\^2]\)], "Output"]
}, Closed]],

Cell["Here are rules that perform unit conversion.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(24\ inch /. inch \[Rule] 2.54\ cm\)], "Input"],

Cell[BoxData[
    \(60.9600000000000008`\ cm\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(10000.0\ feet /. feet \[Rule] \(1\/5280\)miles\)], "Input"],

Cell[BoxData[
    \(1.89393939393939412`\ miles\)], "Output"]
}, Closed]],

Cell[TextData[{
  "Even the head of an expression can be replaced. Below we replace the head \
",
  StyleBox["List", "Input"],
  " with the head ",
  StyleBox["Plus", "Input"],
  ", which adds the elements of the list."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \({a, b, c} /. List \[Rule] Plus\)], "Input"],

Cell[BoxData[
    \(a + b + c\)], "Output"]
}, Closed]],

Cell[TextData[{
  "In addition to using rules to replace literal symbols, we can use patterns \
with rules. Here we replace every occurrence of ",
  StyleBox["x",
    FontSlant->"Italic"],
  " raised to an even power ",
  StyleBox["n",
    FontSlant->"Italic"],
  " with zero."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(1 + x + x\^2 + x\^3 + x\^4 /. x^n_?EvenQ \[Rule] 0\)], "Input"],

Cell[BoxData[
    \(1 + x + x\^3\)], "Output"]
}, Closed]],

Cell[TextData[{
  "Here we replace every occurrence of ",
  Cell[BoxData[
      \(TraditionalForm\`\@z\^2\)]],
  " in an expression with ",
  StyleBox["z",
    FontSlant->"Italic"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Sqrt[\((1 + x)\)\^2] - y\^2 /. Sqrt[z_^2] \[Rule] z\)], "Input"],

Cell[BoxData[
    \(1 + x - y\^2\)], "Output"]
}, Closed]],

Cell["\<\
By using a pattern on the left side of a rule, we can use functions \
without making explicit definitions.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(funct[10] /. funct[x_] \[Rule] 1 + x\^2\)], "Input"],

Cell[BoxData[
    \(101\)], "Output"]
}, Closed]],

Cell[TextData[{
  "We can combine function definitions and rules. The following function ",
  StyleBox["rootPlot", "Input"],
  " plots the roots of an equation in the complex plane, using the ideas \
developed earlier."
}], "Text"],

Cell[TextData[{
  StyleBox["Solve", "Input"],
  " and ",
  StyleBox["NSolve", "Input"],
  " return solutions to systems of equations as lists of replacement rules."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NSolve[x\^5 == 1 + I, x]\)], "Input"],

Cell[BoxData[
    \({{x \[Rule] \(-0.954957147571794529`\) + 0.486574969864436113`\ I}, {
        x \[Rule] \(-0.757858283255198994`\) - 0.757858283255198905`\ I}, {
        x \[Rule] 
          \(0.167662308256180958`\[InvisibleSpace]\) + 
            1.05857815270637645`\ I}, {
        x \[Rule] 
          \(0.486574969864436024`\[InvisibleSpace]\) - 
            0.954957147571794529`\ I}, {
        x \[Rule] 
          \(1.05857815270637622`\[InvisibleSpace]\) + 
            0.167662308256180896`\ I}}\)], "Output"]
}, Closed]],

Cell[TextData[{
  "To isolate the solutions, we substitute the values in the replacement \
rules for the variable ",
  StyleBox["x", "Input"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(x /. %\)], "Input"],

Cell[BoxData[
    \({\(-0.954957147571794529`\) + 0.486574969864436113`\ I, 
      \(-0.757858283255198994`\) - 0.757858283255198905`\ I, 
      \(0.167662308256180958`\[InvisibleSpace]\) + 1.05857815270637645`\ I, 
      \(0.486574969864436024`\[InvisibleSpace]\) - 0.954957147571794529`\ I, 
      \(1.05857815270637622`\[InvisibleSpace]\) + 0.167662308256180896`\ I}
      \)], "Output"]
}, Closed]],

Cell[TextData[{
  "Here is one way to convert a list of complex and real numbers into a list \
of ordered pairs to be plotted with ",
  StyleBox["ListPlot", "Input"],
  ", using rules and a conditional pattern that matches any numeric quantity: \
the rule converts a numeric quantity ",
  StyleBox["x", "Input"],
  " into an ordered pair of the form ",
  Cell[BoxData[
      \({Re[x], Im[x]}\)], "Input"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(% /. x_?NumericQ \[Rule] {Re[x], Im[x]}\)], "Input"],

Cell[BoxData[
    \({{\(-0.954957147571794529`\), 0.486574969864436113`}, {
        \(-0.757858283255198994`\), \(-0.757858283255198905`\)}, {
        0.167662308256180958`, 1.05857815270637645`}, {0.486574969864436024`, 
        \(-0.954957147571794529`\)}, {1.05857815270637622`, 
        0.167662308256180896`}}\)], "Output"]
}, Closed]],

Cell[TextData[{
  "The pairs can now be plotted using ",
  StyleBox["ListPlot", "Input"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(ListPlot[%, PlotStyle \[Rule] PointSize[0.03]]; \)\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.475494 0.472989 0.293872 0.292324 [
[.0025 .28137 -6 -9 ]
[.0025 .28137 6 0 ]
[.239 .28137 -12 -9 ]
[.239 .28137 12 0 ]
[.71199 .28137 -9 -9 ]
[.71199 .28137 9 0 ]
[.94848 .28137 -3 -9 ]
[.94848 .28137 3 0 ]
[.46299 .00155 -12 -4.5 ]
[.46299 .00155 0 4.5 ]
[.46299 .14771 -24 -4.5 ]
[.46299 .14771 0 4.5 ]
[.46299 .44003 -18 -4.5 ]
[.46299 .44003 0 4.5 ]
[.46299 .5862 -6 -4.5 ]
[.46299 .5862 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.0025 .29387 m
.0025 .30012 L
s
[(-1)] .0025 .28137 0 1 Mshowa
.239 .29387 m
.239 .30012 L
s
[(-0.5)] .239 .28137 0 1 Mshowa
.71199 .29387 m
.71199 .30012 L
s
[(0.5)] .71199 .28137 0 1 Mshowa
.94848 .29387 m
.94848 .30012 L
s
[(1)] .94848 .28137 0 1 Mshowa
.125 Mabswid
.0498 .29387 m
.0498 .29762 L
s
.0971 .29387 m
.0971 .29762 L
s
.1444 .29387 m
.1444 .29762 L
s
.1917 .29387 m
.1917 .29762 L
s
.2863 .29387 m
.2863 .29762 L
s
.3336 .29387 m
.3336 .29762 L
s
.3809 .29387 m
.3809 .29762 L
s
.4282 .29387 m
.4282 .29762 L
s
.52279 .29387 m
.52279 .29762 L
s
.57009 .29387 m
.57009 .29762 L
s
.61739 .29387 m
.61739 .29762 L
s
.66469 .29387 m
.66469 .29762 L
s
.75929 .29387 m
.75929 .29762 L
s
.80659 .29387 m
.80659 .29762 L
s
.85389 .29387 m
.85389 .29762 L
s
.90118 .29387 m
.90118 .29762 L
s
.99578 .29387 m
.99578 .29762 L
s
.25 Mabswid
0 .29387 m
1 .29387 L
s
.47549 .00155 m
.48174 .00155 L
s
[(-1)] .46299 .00155 1 0 Mshowa
.47549 .14771 m
.48174 .14771 L
s
[(-0.5)] .46299 .14771 1 0 Mshowa
.47549 .44003 m
.48174 .44003 L
s
[(0.5)] .46299 .44003 1 0 Mshowa
.47549 .5862 m
.48174 .5862 L
s
[(1)] .46299 .5862 1 0 Mshowa
.125 Mabswid
.47549 .03078 m
.47924 .03078 L
s
.47549 .06001 m
.47924 .06001 L
s
.47549 .08925 m
.47924 .08925 L
s
.47549 .11848 m
.47924 .11848 L
s
.47549 .17694 m
.47924 .17694 L
s
.47549 .20617 m
.47924 .20617 L
s
.47549 .23541 m
.47924 .23541 L
s
.47549 .26464 m
.47924 .26464 L
s
.47549 .3231 m
.47924 .3231 L
s
.47549 .35234 m
.47924 .35234 L
s
.47549 .38157 m
.47924 .38157 L
s
.47549 .4108 m
.47924 .4108 L
s
.47549 .46927 m
.47924 .46927 L
s
.47549 .4985 m
.47924 .4985 L
s
.47549 .52773 m
.47924 .52773 L
s
.47549 .55696 m
.47924 .55696 L
s
.47549 .61543 m
.47924 .61543 L
s
.25 Mabswid
.47549 0 m
.47549 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.03 w
.02381 .43611 Mdot
.11704 .07233 Mdot
.5548 .60332 Mdot
.70564 .01472 Mdot
.97619 .34288 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{35, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/@P10`4000010?ooobl_;oooZZVYZNSX
j?oo05FZZZZZZ_W0RS/k>gYjN[Vi^OShn03ooeGooj[ooonI<c<c<fi^KZf][Nc/k02ZoeFZojZZoonZ
oclo?ginO[fm_Oclo5D00:X00?l00?l0VCLg=g9bL[6a/O3`l03o05Go0:[o00<30d92@X61PL30`000
EED0EJX0EOl0ELbIoc/k>gIfM[Fe]OCdm03oEEGoEJ[oE@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0Z/`c
<clo?gYjN[Vi^OShn03oZUGoZZ[oZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`<30d92@WinO[fm_Ocl
o03ooeGooj[oo`l?3di>CXf=SLc<c01E05EE0:YE0?mE00L71dI6AX61PL30`000EED00:X00?l001<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@/;2dY:BXF5QLC4a000ZUD0EJX0EOl0EALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZPl?3di>CXV9RLS8b000oeD0ZZX0Z_l0ZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEoa<C
4e9BDXf=SLc<c01E05D0ojX0ool0oalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ01LG5eIFEY6ATM3@d01E
EEEE0:YE0?mE02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZEA/K6eYJFYFEUMCDe01EZUEEEJYEEOmEEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZQlO7eiNGYVIVMSHf01EoeEEZZYEZ_mEZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZob<S8f9RHYfMWMcLg02Z05EEojYEoomEobl_;fi^KZf][Nc/k03o05Go0:[o0=gW1RLW
9fIVIZ6QXN3Ph02ZEEFZ0:ZZ0?nZ03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooEB/[:fYZJZFUYNCTi02Z
ZUFZEJZZEOnZECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l08@000?l08@0008800onK0000P`000ol0
002J0000O005o`8000?o00001@03oc/01?mC0000P`000ol000050003o`0003X01_mB0000P`000ol0
00050003o`0003T02?mA0000PP02o`L000?o0000>@08oe40002;0003o`0003T02?mA0000R`000ol0
000i00SoD@0008/000?o0000>P06oe80002;0003o`0003/01?mC0000R`02oi<0002;0003o`000980
002;0003o`000980002;0003o`000980002;0003o`000980002;0003o`000980002;0003o`000980
002;0003o`000980002;00;oT`0002D01?mR0003o`000980000T00KoH@000ol0002B00008`08of00
00?o0000TP0002<02?mP0003o`000980000S00SoH0000ol0002B00008`08of0000?o0000TP0002@0
1_mQ0003o`000980000U00CoHP000ol0002B0000R`02oi<0002;0003o`000980002;0003o`000980
002;0003o`000980002;0003o`000980002;0003o`000980002;0003o`000980002;0003o`000980
002;00;oT`0008/000?o0000TP0008/000?o0000TP0008/000?o0000TP0008/000?o0000TP0008/0
00?o0000TP0007L00_l400;o0`03o`H000?o0000TP0007H000Co003o0`02o`H000?o00000`000ol0
002B0000L005o`050?l00?l02`000ol0000300?oTP0007H000Co003o2003o`H000?o0000TP0007H0
00Co003o20000ol000060003o`000980001g00;o2@04o`D000?o0000TP0008/000?o0000TP0008/0
00?o0000TP0008/000?o0000TP0008/000?o0000TP0008/00_nC0000R`000ol0002B0000R`000ol0
002B0000R`000ol0002B0000R`000ol0002B0000R`000ol0002B0000R`000ol0002B0000R`000ol0
002B0000R`02oi<0002;0003o`000980002;0003o`000980002;0003o`000980002;0003o`000980
002;0003o`000980002;0003o`000980002;0003o`000980002;00;oT`0008/000?o0000TP0008/0
00?o0000TP0008/000?o0000TP0008/000?o0000TP0008/000?o0000TP0000L00olk00;o1002o`<0
0olh0003o`0003P00_l400;o0`03ocT00ol@000020000ol0000i0004o`00o`<00_l60003o`0003D0
00?o0000=`001?l00?l300;o1P000ol0000g0003o`0000l000000`3oo`03o`8000?o0000<`05o`05
0?l00?l02`000ol0000e0003o`0003L000Co003o2`000ol0000g0003o`0000l000080003o`0003T0
00Co003o2003ocP00_lh0004o`00o`P00olj0003o`0000l000080003o`0003T000Co003o20000ol0
000h0003o`0003L000Co003o20000ol0000j0003o`0000l0000700;o?002o`T01?lg0003o`0003P0
0_l900Co>002oa40002;0003o`000980002;0003o`000980002;0003o`000980002;0003o`000980
002;0003o`00098000060?oo6_l100001P000ol0000;0003o`0000X000?o00002P000ol0000:0003
o`0000/000?o00002P000ol0000:0003o`0000X000?o00002`000ol0000:0003o`0000X000?o0000
2P000ol0000:0003o`0000/000?o00002P000ol0000:0003o`0000X000?o00002`000ol0000:0003
o`0000X000?o00002P000ol0000100001P000ol000100003o`0003l000?o0000?`000ol0000o0003
o`0000h0002;0003o`000980002;0003o`000980002;0003o`000980002;0003o`000980002;0003
o`000980002;00;oT`0008/000?o0000TP0008/000?o0000Q`04o`L0002;0003o`0008H01_l60000
R`000ol0002500So1@0008/000?o0000Q@08o`D0002;0003o`0008D02?l50000R`000ol0002500So
1@0008/00_n700Ko1P0008/000?o0000Q`04o`L0002;0003o`000980002;0003o`000980002;0003
o`000980002;0003o`000980002;0003o`000980002;0003o`000980002;00;oT`0008/000?o0000
TP0008/000?o0000TP0008/000?o0000TP0008/000?o0000TP0008/000?o0000TP0008/000?o0000
TP0008/000?o0000TP0008/000?o0000TP0008/00_nC0000R`000ol0002B0000R`000ol0002B0000
2`04og`000?o0000TP0000X01_mk0003o`000980000900SoNP000ol0002B00002@08ofH00_l400;o
0`03o`H000?o0000TP0000T02?mU0004o`00o`<00_l60003o`0000<000?o0000TP0000T02?mU0004
o`00o`/000?o00000`03oi80000:00KoIP001?l00?l800?o1P000ol0002B00002`04ofL000Co003o
20000ol000060003o`000980001g00;o2@04o`D000?o0000TP0008/000?o0000TP0008/000?o0000
TP0008/000?o0000TP0008/000?o0000TP0008/00_nC0000R`000ol0002B0000R`000ol0002B0000
R`000ol0002B0000R`000ol0002B0000R`000ol0002B0000R`000ol0002B0000R`000ol0002B0000
R`02oi<0002;0003o`000980002;0003o`000980002;0003o`000980002;0003o`000980002;0003
o`000980002;0003o`000980002;0003o`000980002;00;oT`0008/000?o0000TP0008/000?o0000
TP0008/000?o0000TP0008/000?o0000TP0008/000?o0000TP0008/000?o0000TP0008/000?o0000
TP0008/00_nC0000R`000ol0002B0000R`000ol0002B0000R`000ol0002B0000R`000ol0002B0000
R`000ol0002B0000R`000ol0002B0000PP03o`H000?o0000TP0008<000?o00001@000ol0002B0000
P`000ol0000500?oTP0008<000?o00001@000ol0002B0000P`000ol000050003o`0001401?mm0000
PP02o`L000?o00004006og`0002;0003o`0000l02?mk0000R`000ol0000?00SoN`0008/000?o0000
3`08og/0002;0003o`0000l02?mk0000R`02oa401_ml0000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-1.05288, -1.05504, 
  0.00755859, 0.01223}}]
}, Closed]],

Cell[TextData[{
  "We combine the previous steps into one function called ",
  StyleBox["rootPlot", "Input"],
  "."
}], "Text"],

Cell[BoxData[
    \(\(rootPlot[eqn_Equal, var_] := \n\t
      ListPlot[\(var /. NSolve[eqn, var]\) /. 
          x_?NumericQ \[Rule] {Re[x], Im[x]}, 
        PlotStyle \[Rule] PointSize[0.03], PlotRange \[Rule] All, 
        AspectRatio \[Rule] Automatic]; \)\)], "Input"],

Cell[TextData[{
  "Here is a plot of the seven roots of ",
  Cell[BoxData[
      \(TraditionalForm
      \`\(w\^7\)\[ImaginaryI] = 
        w\^5 - \(w\^3\)\[ImaginaryI] + w\^2 - w + 1\)]],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(rootPlot[I\ w\^7 == w\^5 - I\ w\^3 + w\^2 - w + 1, w]; \)\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.00392 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.539954 0.490957 0.472193 0.490957 [
[.049 .45969 -6 -9 ]
[.049 .45969 6 0 ]
[.29448 .45969 -12 -9 ]
[.29448 .45969 12 0 ]
[.78543 .45969 -9 -9 ]
[.78543 .45969 9 0 ]
[.52745 .22671 -24 -4.5 ]
[.52745 .22671 0 4.5 ]
[.52745 .71767 -18 -4.5 ]
[.52745 .71767 0 4.5 ]
[.52745 .96315 -6 -4.5 ]
[.52745 .96315 0 4.5 ]
[ 0 0 0 0 ]
[ 1 1.00392 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.049 .47219 m
.049 .47844 L
s
[(-1)] .049 .45969 0 1 Mshowa
.29448 .47219 m
.29448 .47844 L
s
[(-0.5)] .29448 .45969 0 1 Mshowa
.78543 .47219 m
.78543 .47844 L
s
[(0.5)] .78543 .45969 0 1 Mshowa
.125 Mabswid
.09809 .47219 m
.09809 .47594 L
s
.14719 .47219 m
.14719 .47594 L
s
.19628 .47219 m
.19628 .47594 L
s
.24538 .47219 m
.24538 .47594 L
s
.34357 .47219 m
.34357 .47594 L
s
.39267 .47219 m
.39267 .47594 L
s
.44176 .47219 m
.44176 .47594 L
s
.49086 .47219 m
.49086 .47594 L
s
.58905 .47219 m
.58905 .47594 L
s
.63815 .47219 m
.63815 .47594 L
s
.68724 .47219 m
.68724 .47594 L
s
.73634 .47219 m
.73634 .47594 L
s
.83453 .47219 m
.83453 .47594 L
s
.88362 .47219 m
.88362 .47594 L
s
.93272 .47219 m
.93272 .47594 L
s
.98182 .47219 m
.98182 .47594 L
s
.25 Mabswid
0 .47219 m
1 .47219 L
s
.53995 .22671 m
.5462 .22671 L
s
[(-0.5)] .52745 .22671 1 0 Mshowa
.53995 .71767 m
.5462 .71767 L
s
[(0.5)] .52745 .71767 1 0 Mshowa
.53995 .96315 m
.5462 .96315 L
s
[(1)] .52745 .96315 1 0 Mshowa
.125 Mabswid
.53995 .27581 m
.5437 .27581 L
s
.53995 .32491 m
.5437 .32491 L
s
.53995 .374 m
.5437 .374 L
s
.53995 .4231 m
.5437 .4231 L
s
.53995 .52129 m
.5437 .52129 L
s
.53995 .57038 m
.5437 .57038 L
s
.53995 .61948 m
.5437 .61948 L
s
.53995 .66858 m
.5437 .66858 L
s
.53995 .76677 m
.5437 .76677 L
s
.53995 .81586 m
.5437 .81586 L
s
.53995 .86496 m
.5437 .86496 L
s
.53995 .91405 m
.5437 .91405 L
s
.53995 .17762 m
.5437 .17762 L
s
.53995 .12852 m
.5437 .12852 L
s
.53995 .07943 m
.5437 .07943 L
s
.53995 .03033 m
.5437 .03033 L
s
.25 Mabswid
.53995 0 m
.53995 1.00392 L
s
.03 w
.02381 .33951 Mdot
.04889 .98002 Mdot
.408 .0239 Mdot
.60037 .851 Mdot
.85599 .26227 Mdot
.86643 .78264 Mdot
.97619 .066 Mdot
0 0 m
1 0 L
1 1.00392 L
0 1.00392 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{286.875, 288},
  ImageMargins->{{35, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004N000180P10`4000010?ooobl_;oooZZVYZNSX
j?oo05FZZZZZZ_W0RS/k>gYjN[Vi^OShn03ooeGooj[ooonI<c<c<fi^KZf][Nc/k02ZoeFZojZZoonZ
oclo?ginO[fm_Oclo5D00:X00?l00?l0VCLg=g9bL[6a/O3`l03o05Go0:[o00<30d92@X61PL30`000
EED0EJX0EOl0ELbIoc/k>gIfM[Fe]OCdm03oEEGoEJ[oE@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0Z/`c
<clo?gYjN[Vi^OShn03oZUGoZZ[oZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`<30d92@WinO[fm_Ocl
o03ooeGooj[oo`l?3di>CXf=SLc<c01E05EE0:YE0?mE00L71dI6AX61PL30`000EED00:X00?l001<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@/;2dY:BXF5QLC4a000ZUD0EJX0EOl0EALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZPl?3di>CXV9RLS8b000oeD0ZZX0Z_l0ZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEoa<C
4e9BDXf=SLc<c01E05D0ojX0ool0oalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ01LG5eIFEY6ATM3@d01E
EEEE0:YE0?mE02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZEA/K6eYJFYFEUMCDe01EZUEEEJYEEOmEEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZQlO7eiNGYVIVMSHf01EoeEEZZYEZ_mEZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZob<S8f9RHYfMWMcLg02Z05EEojYEoomEobl_;fi^KZf][Nc/k03o05Go0:[o0=gW1RLW
9fIVIZ6QXN3Ph02ZEEFZ0:ZZ0?nZ03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooEB/[:fYZJZFUYNCTi02Z
ZUFZEJZZEOnZECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l07`0009X000?o0000P@0009X000?o0000
P@0009X000?o0000P@0007801?lT0003o`000840001a00Ko8`000ol000210000L008ob8000?o0000
P@0007002?lR0003o`000840001`00So8P000ol000210000L008ob800_n20000L@06ob<000?o0000
P@0007801?lT0003o`000840002J0003o`000840002J0003o`000840002J0003o`000840002J0003
o`000840002J0003o`0007P01?l50000VP000ol0001g00Ko100009X000?o0000MP08o`<0002J0003
o`0007H02?l30000VP000ol0001f00So0`0009X000?o0000MP08o`<0002J0003o`0007L01_l40000
VP02ogT01?l50000VP000ol000210000VP000ol000210000VP000ol000210000VP000ol000210000
VP000ol000210000VP000ol000210000VP000ol000210000VP000ol000210000VP000ol000210000
VP000ol000210000VP000ol000210000VP000ol000210000VP000ol000210000VP02oh80002J0003
o`000840002J0003o`000840002J0003o`000840002J0003o`000840002J0003o`000840002J0003
o`000840002J0003o`000840002J0003o`000840002J0003o`000840002J0003o`000840002J0003
o`000840002J0003o`000840002J0003o`000840002J00;oPP0009X000?o0000P@0009X000?o0000
P@0009X000?o0000P@0009X000?o0000P@0009X000?o0000P@0009X000?o0000P@0009X000?o0000
P@0009X000?o0000P@0009X000?o0000P@0009X000?o0000P@0009X000?o0000P@0008H00_l400;o
0`03o`H000?o0000P@0008D000Co003o0`02o`H000?o00000`000ol000210000O`05o`050?l00?l0
2`000ol0000300?oP@0008D000Co003o2003o`H000?o0000P@0008D000Co003o20000ol000060003
o`000840002600;o2@04o`D000?o0000P@0009X000?o0000P@0009X000?o0000P@0009X000?o0000
P@0009X000?o0000E@04obP0002J0003o`0005@01_lW0000VP000ol0001C00So9P0009X000?o0000
D`08obH0002J0003o`0005<02?lV0000VP000ol0001C00So9P0009X000?o0000E006obL0002J00;o
EP04obP0002J0003o`000840002J0003o`000840002J0003o`000840002J0003o`000840002J0003
o`000840002J0003o`000840002J0003o`000840002J0003o`000840002J0003o`000840002J0003
o`000840002J0003o`000840002J0003o`000840002J0003o`000840002J00;oPP0000D01?nA0003
o`000840000400KoT0000ol0002100000`08ohl000?o0000P@0000<02?n?0003o`000840000300So
S`000ol0002100000`08ohl000?o0000P@0000@01_n@0003o`000840000500CoT@000ol000210000
VP000ol000210000VP000ol000210000VP000ol000210000VP000ol000210000VP000ol000210000
VP02oh80002J0003o`000840002J0003o`000840002J0003o`000840002J0003o`000840002J0003
o`000840002J0003o`000840002J0003o`000840002J0003o`000840002J0003o`000840002J0003
o`000840002J0003o`000840002J0003o`000840002J0003o`000840002J00;oPP0009X000?o0000
P@0009X000?o0000P@0009X000?o0000P@0000l00oln00;o1002o`<00oll0003o`0003`00_l400;o
0`03ocL0000@0003o`0003`000Co003o0`02o`H000?o0000>@000ol0000k0004o`00o`<00_l60003
o`0003@0000900Go0P000ol0000f00Go00D0o`00o`0;0003o`0003T000?o0000>`001?l00?l;0003
o`0003@0000@0003o`0003`000Co003o2003oc`000?o0000>`001?l00?l800?o=`00010000?o0000
?0001?l00?l80003o`0003`000?o0000>`001?l00?l80003o`0003L0000?00;o?`02o`T01?lk0003
o`0003`00_l900Co=P0009X000?o0000P@0009X000?o0000P@0009X000?o0000P@0009X000?o0000
P@000?oo7ol000h000?o00002`000ol0000;0003o`0000/000?o00002`000ol0000;0003o`0000/0
00?o00002`000ol0000;0003o`0000/000?o00002`000ol0000;0003o`0000/000?o00002`000ol0
000;0003o`0000/000?o00002`000ol0000;0003o`0000/000?o00002`000ol0000300003P000ol0
000;0003o`0000/000?o00002`000ol0000;0003o`0000/000?o00002`000ol0000;0003o`0000/0
00?o00002`000ol0000;0003o`0000/000?o00002`000ol0000;0003o`0000/000?o00002`000ol0
000;0003o`0000/000?o00002`000ol0000;0003o`0000<0002J0003o`000840002J0003o`000840
002J0003o`000840002J0003o`000840002J0003o`000840002J0003o`000840002J0003o`000840
002J0003o`000840002J0003o`000840002J0003o`000840002J0003o`000840002J0003o`000840
002J00;oPP0009X000?o0000P@0009X000?o0000P@0009X000?o0000P@0009X000?o0000P@0009X0
00?o0000P@0009X000?o0000P@0009X000?o0000P@0009X000?o0000P@0009X000?o0000P@0009X0
00?o0000P@0009X000?o0000P@0009X000?o0000P@0009X000?o0000P@0009X00_n20000VP000ol0
00210000VP000ol000210000VP000ol000210000VP000ol000210000VP000ol000210000VP000ol0
00210000VP000ol000210000VP000ol000210000VP000ol000210000VP000ol000210000VP000ol0
00210000VP000ol000210000VP000ol000210000VP02oh80002J0003o`000840002J0003o`000840
002J0003o`000840002J0003o`000840002J0003o`000840002J0003o`000840002J0003o`000840
002J0003o`000840002J0003o`000840002J0003o`000840002J0003o`000840002J0003o`000840
002J0003o`000840002J00;oPP0009X000?o0000P@0009X000?o0000P@0009X000?o0000P@0009X0
00?o0000P@0009X000?o0000P@0009X000?o0000P@0009X000?o0000P@0009X000?o0000P@0009X0
00?o0000P@0009X000?o0000P@0009X000?o0000P@0008H00_l400;o0`03o`H000?o0000P@0008D0
00Co003o0`02o`H000?o00000`000ol000210000Q@001?l00?l;0003o`0000<00on10000Q@001?l0
0?l800?o1P000ol000210000Q@001?l00?l80003o`0000H000?o0000P@0008H00_l900Co1@000ol0
00210000VP000ol000210000VP000ol000210000VP000ol000210000VP000ol000210000VP000ol0
00210000VP000ol000210000VP000ol000210000VP000ol000210000VP000ol000210000VP000ol0
00210000VP02oh80002J0003o`0005P01?lU0000VP000ol0001G00Ko900009X000?o0000EP08ob<0
002J0003o`0005H02?lS0000VP000ol0001F00So8`0009X000?o0000EP08ob<0002J0003o`0005L0
1_lT0000VP000ol0001H00Co9@0009X000?o0000P@0009X000?o0000P@0009X000?o0000P@0009X0
00?o0000P@0009X000?o0000P@0009X00_n20000VP000ol000210000VP000ol000210000VP000ol0
00210000VP000ol000210000VP000ol000210000VP000ol000210000VP000ol0000<00CoL@0009X0
00?o00002`06og00002J0003o`0000X02?m_0000VP000ol0000:00SoK`0009X000?o00002P08ofl0
002J0003o`0000X02?m_0000VP000ol0000;00KoL00009X00_l=00CoL@0009X000?o0000P@0009X0
00?o0000P@0009X000?o0000P@0009X000?o0000P@0009X000?o0000P@0009X000?o0000P@0009X0
00?o0000P@0009X000?o0000P@0009X000?o0000P@0009X000?o0000P@0009X000?o0000P@0009X0
00?o0000P@0009X000?o0000P@0009X00_n20000VP000ol000210000VP000ol000210000VP000ol0
00210000VP000ol000210000VP000ol000210000VP000ol000210000VP000ol000210000VP000ol0
00210000VP000ol000210000VP000ol000210000VP000ol000210000T@03o`H000?o0000P@000980
00?o00001@000ol000210000TP000ol0000500?oP@0000`01?n20003o`0000D000?o0000P@0000/0
1_n10003o`0000D000?o0000P@0000X02?mo00;o1`000ol0002100002P08ohP000?o0000P@0000X0
2?n80003o`000840000:00SoR0000ol0002100002`06ohT000?o0000P@0000`01?n:0003o`000840
002J0003o`000840002J0003o`000840002J0003o`0008400000\
\>"],
  ImageRangeCache->{{{0, 285.875}, {287, 0}} -> {-1.09981, -0.961807, 
  0.007125, 0.007125}}]
}, Closed]],

Cell[TextData[{
  "See also ",
  StyleBox["RuleDelayed", "Input"],
  ", ",
  StyleBox["ReplaceList", "Input"],
  ", ",
  StyleBox["Dispatch", "Input"],
  " "
}], "SeeAlso"]
}, Closed]],

Cell[CellGroupData[{

Cell["Variable Scoping", "Subsection"],

Cell[TextData[{
  "Many function definitions can be simplified by the use of auxiliary \
functions and variables. The following function returns a list containing the \
minimum and maximum ",
  StyleBox["x", "Input"],
  "  values from a list of ",
  Cell[BoxData[
      \({x, y}\)], "Input"],
  " pairs."
}], "Text"],

Cell[BoxData[
    \(findminmax[data : {{_, _}..}] := {Min[First[Transpose[data]]], 
        Max[First[Transpose[data]]]}\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(findminmax[{{2, 5}, {7, 1}, {1, 3}}]\)], "Input"],

Cell[BoxData[
    \({1, 7}\)], "Output"]
}, Closed]],

Cell[TextData[{
  "Changing the right side of the definition into a compound expression in \
which we assign the auxiliary variable ",
  StyleBox["tdata", "Input"],
  " the value ",
  Cell["First[Transpose[data]]", "Input"],
  " will simplify the function somewhat."
}], "Text"],

Cell[BoxData[
    \(Clear[findminmax]\)], "Input"],

Cell[BoxData[
    \(findminmax[data : {{_, _}..}] := 
      \((tdata = First[Transpose[data]]; {Min[tdata], Max[tdata]})\)\)], 
  "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(findminmax[{{2, 5}, {7, 1}, {1, 3}}]\)], "Input"],

Cell[BoxData[
    \({1, 7}\)], "Output"]
}, Closed]],

Cell[TextData[{
  "A problem with this approach is that the value of ",
  StyleBox["tdata", "Input"],
  " remains in memory until we explicitly clear it."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(tdata\)], "Input"],

Cell[BoxData[
    \({2, 7, 1}\)], "Output"]
}, Closed]],

Cell[BoxData[
    \(Clear[tdata]\)], "Input"],

Cell[TextData[{
  "A better approach is to use temporary, or local, variables on the \
right-hand side of a definition, which is done by enclosing the body of the \
definition in a ",
  StyleBox["Module", "Input"],
  ", and listing the variables that are local to the routine. In the \
following definition of ",
  StyleBox["findminmax", "Input"],
  ", we put the right side of the definition inside ",
  StyleBox["Module", "Input"],
  ", declaring ",
  StyleBox["tdata", "Input"],
  " to be a local variable."
}], "Text"],

Cell[BoxData[
    \(Clear[findminmax]\)], "Input"],

Cell[BoxData[
    \(findminmax[data : {{_, _}..}] := \n\t
      Module[{tdata}, \n\t\t
        tdata = First[Transpose[data]]; {Min[tdata], Max[tdata]}]\)], "Input"],

Cell["The function works as before.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(findminmax[{{2, 5}, {7, 1}, {1, 3}}]\)], "Input"],

Cell[BoxData[
    \({1, 7}\)], "Output"]
}, Closed]],

Cell[TextData[{
  "However, ",
  StyleBox["tdata", "Input"],
  " has not been assigned a permanent value."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(tdata\)], "Input"],

Cell[BoxData[
    \(tdata\)], "Output"]
}, Closed]],

Cell["\<\
The following function accepts a list of ordered pairs that lie in \
the unit square, then creates a graph of the ordered pairs, along with a red \
rectangle that highlights the middle third of the vertical range of the data. \
In order to compute the corners of the rectangle, it is necessary to use \
several local variables.\
\>", "Text"],

Cell[BoxData[
    \(Clear[bandplot]\)], "Input"],

Cell[BoxData[
    \(bandplot[data : {{_, _}..}] := 
      Module[{tdata, ymin, ymax, ymed, yrange}, tdata = Transpose[data]; \n
        \t\t{ymin, ymax} = {
            Min[tdata\[LeftDoubleBracket]2\[RightDoubleBracket]], 
            Max[tdata\[LeftDoubleBracket]2\[RightDoubleBracket]]}; 
        ymed = \(1\/2\) \((ymin + ymax)\); yrange = ymax - ymin; \n\t\t
        ListPlot[data, 
          Prolog \[Rule] {Hue[0], 
              Rectangle[{0, ymed - yrange/6}, {1, ymed + yrange/6}], 
              GrayLevel[0]}, PlotRange \[Rule] All, 
          PlotStyle \[Rule] PointSize[0.02], AxesOrigin \[Rule] {0, 0}]]\)], 
  "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(bandplot[Table[{Random[], Random[]}, {30}]]; \)\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0182244 0.963236 0.00537004 0.610833 [
[.21087 -0.00713 -9 -9 ]
[.21087 -0.00713 9 0 ]
[.40352 -0.00713 -9 -9 ]
[.40352 -0.00713 9 0 ]
[.59617 -0.00713 -9 -9 ]
[.59617 -0.00713 9 0 ]
[.78881 -0.00713 -9 -9 ]
[.78881 -0.00713 9 0 ]
[.98146 -0.00713 -3 -9 ]
[.98146 -0.00713 3 0 ]
[.00572 .12754 -18 -4.5 ]
[.00572 .12754 0 4.5 ]
[.00572 .2497 -18 -4.5 ]
[.00572 .2497 0 4.5 ]
[.00572 .37187 -18 -4.5 ]
[.00572 .37187 0 4.5 ]
[.00572 .49404 -18 -4.5 ]
[.00572 .49404 0 4.5 ]
[.00572 .6162 -6 -4.5 ]
[.00572 .6162 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.21087 .00537 m
.21087 .01162 L
s
[(0.2)] .21087 -0.00713 0 1 Mshowa
.40352 .00537 m
.40352 .01162 L
s
[(0.4)] .40352 -0.00713 0 1 Mshowa
.59617 .00537 m
.59617 .01162 L
s
[(0.6)] .59617 -0.00713 0 1 Mshowa
.78881 .00537 m
.78881 .01162 L
s
[(0.8)] .78881 -0.00713 0 1 Mshowa
.98146 .00537 m
.98146 .01162 L
s
[(1)] .98146 -0.00713 0 1 Mshowa
.125 Mabswid
.06639 .00537 m
.06639 .00912 L
s
.11455 .00537 m
.11455 .00912 L
s
.16271 .00537 m
.16271 .00912 L
s
.25903 .00537 m
.25903 .00912 L
s
.3072 .00537 m
.3072 .00912 L
s
.35536 .00537 m
.35536 .00912 L
s
.45168 .00537 m
.45168 .00912 L
s
.49984 .00537 m
.49984 .00912 L
s
.548 .00537 m
.548 .00912 L
s
.64433 .00537 m
.64433 .00912 L
s
.69249 .00537 m
.69249 .00912 L
s
.74065 .00537 m
.74065 .00912 L
s
.83697 .00537 m
.83697 .00912 L
s
.88514 .00537 m
.88514 .00912 L
s
.9333 .00537 m
.9333 .00912 L
s
.25 Mabswid
0 .00537 m
1 .00537 L
s
.01822 .12754 m
.02447 .12754 L
s
[(0.2)] .00572 .12754 1 0 Mshowa
.01822 .2497 m
.02447 .2497 L
s
[(0.4)] .00572 .2497 1 0 Mshowa
.01822 .37187 m
.02447 .37187 L
s
[(0.6)] .00572 .37187 1 0 Mshowa
.01822 .49404 m
.02447 .49404 L
s
[(0.8)] .00572 .49404 1 0 Mshowa
.01822 .6162 m
.02447 .6162 L
s
[(1)] .00572 .6162 1 0 Mshowa
.125 Mabswid
.01822 .03591 m
.02197 .03591 L
s
.01822 .06645 m
.02197 .06645 L
s
.01822 .09699 m
.02197 .09699 L
s
.01822 .15808 m
.02197 .15808 L
s
.01822 .18862 m
.02197 .18862 L
s
.01822 .21916 m
.02197 .21916 L
s
.01822 .28024 m
.02197 .28024 L
s
.01822 .31079 m
.02197 .31079 L
s
.01822 .34133 m
.02197 .34133 L
s
.01822 .40241 m
.02197 .40241 L
s
.01822 .43295 m
.02197 .43295 L
s
.01822 .46349 m
.02197 .46349 L
s
.01822 .52458 m
.02197 .52458 L
s
.01822 .55512 m
.02197 .55512 L
s
.01822 .58566 m
.02197 .58566 L
s
.25 Mabswid
.01822 0 m
.01822 .61803 L
s
1 0 0 r
.01822 .21092 m
.01822 .40712 L
.98146 .40712 L
.98146 .21092 L
F
0 g
.02 w
.16283 .40979 Mdot
.76524 .08885 Mdot
.14227 .1061 Mdot
.90475 .24033 Mdot
.72624 .22494 Mdot
.93543 .56613 Mdot
.54683 .54589 Mdot
.32482 .24474 Mdot
.50281 .02225 Mdot
.97619 .38761 Mdot
.19037 .07518 Mdot
.6727 .07597 Mdot
.04576 .28159 Mdot
.88891 .60332 Mdot
.88495 .18086 Mdot
.96562 .36836 Mdot
.17693 .57212 Mdot
.04842 .41844 Mdot
.61156 .0316 Mdot
.70506 .17907 Mdot
.12697 .01472 Mdot
.71033 .40767 Mdot
.91807 .55574 Mdot
.05586 .33707 Mdot
.89053 .27952 Mdot
.14841 .34995 Mdot
.02381 .10404 Mdot
.16424 .59779 Mdot
.82834 .14812 Mdot
.13405 .18472 Mdot
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{35, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/@P10`4000010?ooobl_;oooZZVYZNSX
j?oo05FZZZZZZ_W0RS/k>gYjN[Vi^OShn03ooeGooj[ooonI<c<c<fi^KZf][Nc/k02ZoeFZojZZoonZ
oclo?ginO[fm_Oclo5D00:X00?l00?l0VCLg=g9bL[6a/O3`l03o05Go0:[o00<30d92@X61PL30`000
EED0EJX0EOl0ELbIoc/k>gIfM[Fe]OCdm03oEEGoEJ[oE@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0Z/`c
<clo?gYjN[Vi^OShn03oZUGoZZ[oZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`<30d92@WinO[fm_Ocl
o03ooeGooj[oo`l?3di>CXf=SLc<c01E05EE0:YE0?mE00L71dI6AX61PL30`000EED00:X00?l001<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@/;2dY:BXF5QLC4a000ZUD0EJX0EOl0EALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZPl?3di>CXV9RLS8b000oeD0ZZX0Z_l0ZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEoa<C
4e9BDXf=SLc<c01E05D0ojX0ool0oalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ01LG5eIFEY6ATM3@d01E
EEEE0:YE0?mE02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZEA/K6eYJFYFEUMCDe01EZUEEEJYEEOmEEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZQlO7eiNGYVIVMSHf01EoeEEZZYEZ_mEZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZob<S8f9RHYfMWMcLg02Z05EEojYEoomEobl_;fi^KZf][Nc/k03o05Go0:[o0=gW1RLW
9fIVIZ6QXN3Ph02ZEEFZ0:ZZ0?nZ03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooEB/[:fYZJZFUYNCTi02Z
ZUFZEJZZEOnZECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l08@000?l08@0004@00_l400;o0`04ob@0
0_l400;o1003ob<00_l400;o1002obD00_l400;o1002obT00ol:0000@`001?l00?l300;o10000ol0
000S0004o`00o`<00_l50003o`00024000Co003o0`02o`<000Co003o8`001?l00?l300;o0`001?l0
0?lY0003o`0000T000130004o`00o`X000?o00008P001?l00?l800Co8P001?l00?l80004o`00ob<0
00Co003o20001?l00?lY0003o`0000T000130004o`00o`/000?o00008@001?l00?l80003o`3o02<0
00Co003o2003ob@000Co003o2@02obX000?o00002@0004<000Co003o20001?l00?lS0004o`00o`P0
00?o0?l08`001?l00?l80003o`0002@000Co003o20001?l00?lY0003o`0000T0001400;o2P02obD0
0_l:00;o9002o`X00olT00;o2P02obT00_l;0000o`0Q0000o`0Q00006@000ol0003o00D0000I0003
o`000?l01@0001@0ool8o`D0000I0003o`0000X000?o00002@06o`L000?o00002@000ol0000:0003
o`0000X000?o00002@000ol0000:0003o`0000X000?o00002@000ol0000:0003o`0000T000?o0000
2P000ol0000:0003o`0000T000?o00002P000ol0000:0003o`0000T000?o00002P000ol000090003
o`0000P0000I0003o`0001L01OmO00?oQP0001T000?o00005`05oeh01On500006@000ol0000H00?o
G`05ohD0000I0003o`0007X01OlH00?oJP0001T000?o0000N`03oaP01OmY00006@000ol0002F00Go
J@0001T00_nG00GoJ@0001T000?o0000U`03ofX0000I0003o`000?l01@0001T000?o0000o`050000
6@000ol0003o00D0000I0003o`000?l01@0001T000?o0000o`0500006@000ol0003o00D0000I00;o
:P03og/00omJ00006@000ol0000X00GoN@05oeT0000I0003o`0002P01Omi00GoF@0001T000?o0000
:005ogT01OmI00006@000ol0000Y00?oN`03oaH00om100006@000ol0002o00Go@00001T000?o0000
_`05od00000I0003o`000;l01Om000006@03oa`00onQ00?o@@0001P01OlJ00Goi00001P01OlJ00Go
i00001P01OlJ00Goi00001T00olL00?oi@0001T000?o0000o`0500001P02o`@00_l300Co10000ol0
003o00D000050004o`00o`<00_l40003o`0000@000?o0000o`0500001@001?l00?l:0003o`0000<0
0ooo00D000050004o`00o`/000?o00000P000ol0003o00D000050004o`00o`P000Co003o10000ol0
003o00D0000600;o2P02o`D000?o0000d003oc40000I0003o`000<l01Ol`00006@000ol0003?00Go
<00001T000?o0000c`05oc00000I0003o`000=000ola00006@02ool01P0001T000?o0000o`050000
6@000ol0003o00D0000I0003o`000;000omA00006@000ol0002_00Go:`03ob80000I0003o`0001X0
0onB00Go:P05ob40000I0003o`0001T01OnA00Go:P05ob40000I0003o`0001T01OnB00?o:`05ob40
000I00;o6P05ol400olR00006@000ol0000J00?oi`0001T000?o0000o`0500006@000ol0003o00D0
000I0003o`000?l01@0001T000?o0000o`0500006@000ol0003o00D0000I0;TO0om07`/0000I0;PO
1Olo7`/0000I0;PO1Olo7`/0000I0;PO1Olo7`/0000I0;TO0om07`/0000I0>LO0olB7`/0000I04lO
0onD7`Go4Al;00001P02o`@00_l400?o101>7`GoTal5oa4O2`0000D000Co003o0`02o`D000?o0000
0`1>7`GoTal5oa4O2`0000D000Co003o2004o`@0CQl5oi@O0olB7`/000050004o`00o`P000?o0?l0
1@1?7`?oZQl;00001@001?l00?l80003o`3o00D0o1l;00001P02o`X00_l50?`O2`0001T0o1l;0000
6@3l7`/0000I00HO0ooK7`?o5Al;00006@057`GofAl5oa@O2`0001T01Al5omTO1OlD7`/0000I00DO
1OoI7`Go51l;00006@067`?ofal3oaDO2`0001T0o1l;00006@3l7`/0000I0?`O2`0001T0o1l;0000
6@3l7`/0000I0?`O2`0001T0o1l;00006@3l7`/0000I0?`O2`0001T0o1l;00006@097`?ol1l;0000
6@087`Gokal;00006@087`Gokal;00006@087`Go51l3omPO2`0001T02Al3oa@O1OoG7`/0000I020O
1OoG7`/0000I020O1OoG7`/0000I024O0ooH7`/0000I0?LO0ol27`/0000600;o1002o`@00_l50?HO
1Ol00al0000900001@001?l00?l300;o0`001?l00?l40?HO1Ol00al0000900001@001?l00?l80004
o`00o`@0mQl5o`037`0000T000050004o`00o`P00ol50?LO0ol27`/000050004o`00o`P000?o0000
1@3j7`?o2P0000H00_l:00?o103i7`Go2@0001T0nAl5o`T0000I0?TO1Ol900006@3j7`?o2P0001T0
]1l3odDO2`0001T09Al3oh/O1Om47`/0000I02@O1On:7`GoA1l;00006@000ol0000400?o6P05ohX0
1Om?00006@000ol0000300Go6@05oh/00om@00006@000ol0000300Go6P03oml0000I0003o`0000<0
1Ool00006@000ol0000400?oo@0001T000?o0000o`0500006@02ool01P0001T000?o0000o`050000
6@000ol0003o00D0000I0003o`000?l01@0001T000?o0000o`0500006@000ol0003o00D0000I0003
o`000?l01@0001T000?o0000o`0500006@02ool01P0001T000?o0000o`0500006@000ol0003o00D0
000I0003o`000?l01@0001T000?o0000o`0500006@000ol0003o00D0000600;o1002o`@00_l50003
o`000?l01@0000D000Co003o0`02o`<000Co003o10000ol0003o00D000050004o`00o`P000Co003o
1003ool01@0000D000Co003o2@02o`D000?o0000o`0500001@001?l00?l80004o`00o`@000?o0000
o`0500001P02o`X00_l50003o`000?l01@0001T000?o0000o`0500006@000ol0003o00D0000I0003
o`000?l01@0001T000?o0000o`0500006@02ool01P0001T000?o0000o`0500006@000ol0003o00D0
000I0003o`000?l01@0001T000?o0000QP03og/0000I0003o`0008D01Omj00006@000ol0002500Go
GP03oaT0000I0003o`0008D01OmM00Go600001T00_n700?oGP05oaP0000I0003o`000>L02?lE0000
6@000ol0003X00So500001T000?o00009@03ol<01OlD00006@000ol0000T00Go`P05oa@0000I0003
o`0002@01Oo300?o5@0001T000?o00009005om/0000I0003o`0002D00ooL00006@02ool01P0001T0
00?o00008P03oml0000I0003o`0002401OoN00006@000ol0000Q00Go^P03ob40000I0003o`000240
1Oni00Go800001T000?o00008P03okX01OlP00004@03o`D000?o0000g`05ob00000B0003o`0000@0
00?o0000h003ob40000B0003o`0000@00ooo00D0000B0003o`000?l03000018000?o0000o`0<0000
4@02ool03P000?l08@000001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.100688, -0.0766631, 
  0.00395948, 0.00624379}}]
}, Closed]],

Cell[TextData[{
  StyleBox["Module", "Input"],
  " performs lexical scoping; that is, it renames local variables so that \
they do not conflict with global variable names. Other scoping functions are \
",
  StyleBox["Block", "Input"],
  ", which performs dynamic scoping, and ",
  StyleBox["With", "Input"],
  ", which creates local constants."
}], "Text"],

Cell[TextData[{
  "See also ",
  StyleBox["Block", "Input"],
  ", ",
  StyleBox["With", "Input"],
  ", ",
  StyleBox["Context", "Input"],
  " "
}], "SeeAlso"]
}, Closed]],

Cell[CellGroupData[{

Cell["Side Effects and Dynamic Programming", "Subsection"],

Cell[TextData[{
  "In addition to returning a value, many functions have side effects such as \
printing intermediate results or showing a graph. The result of a ",
  StyleBox["Plot", "Input"],
  " command is a collection of the graphics primitives and directives \
necessary to reproduce the graph (the collection has the abbreviated output \
form \[OpenCurlyDoubleQuote]",
  StyleBox["\[SkeletonIndicator]Graphics\[SkeletonIndicator]",
    FontFamily->"Courier"],
  "\[CloseCurlyDoubleQuote]); the graph itself is merely a ",
  StyleBox["side effect",
    FontSlant->"Italic"],
  " of the computation."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plot[1/Abs[t\^2 - 3\ t - \[Pi]], {t, \(-2\), 5}]\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.295918 0.136054 0.0147151 0.0606371 [
[.02381 .00222 -6 -9 ]
[.02381 .00222 6 0 ]
[.15986 .00222 -6 -9 ]
[.15986 .00222 6 0 ]
[.43197 .00222 -3 -9 ]
[.43197 .00222 3 0 ]
[.56803 .00222 -3 -9 ]
[.56803 .00222 3 0 ]
[.70408 .00222 -3 -9 ]
[.70408 .00222 3 0 ]
[.84014 .00222 -3 -9 ]
[.84014 .00222 3 0 ]
[.97619 .00222 -3 -9 ]
[.97619 .00222 3 0 ]
[.28342 .13599 -6 -4.5 ]
[.28342 .13599 0 4.5 ]
[.28342 .25726 -6 -4.5 ]
[.28342 .25726 0 4.5 ]
[.28342 .37854 -6 -4.5 ]
[.28342 .37854 0 4.5 ]
[.28342 .49981 -6 -4.5 ]
[.28342 .49981 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .01472 m
.02381 .02097 L
s
[(-2)] .02381 .00222 0 1 Mshowa
.15986 .01472 m
.15986 .02097 L
s
[(-1)] .15986 .00222 0 1 Mshowa
.43197 .01472 m
.43197 .02097 L
s
[(1)] .43197 .00222 0 1 Mshowa
.56803 .01472 m
.56803 .02097 L
s
[(2)] .56803 .00222 0 1 Mshowa
.70408 .01472 m
.70408 .02097 L
s
[(3)] .70408 .00222 0 1 Mshowa
.84014 .01472 m
.84014 .02097 L
s
[(4)] .84014 .00222 0 1 Mshowa
.97619 .01472 m
.97619 .02097 L
s
[(5)] .97619 .00222 0 1 Mshowa
.125 Mabswid
.05102 .01472 m
.05102 .01847 L
s
.07823 .01472 m
.07823 .01847 L
s
.10544 .01472 m
.10544 .01847 L
s
.13265 .01472 m
.13265 .01847 L
s
.18707 .01472 m
.18707 .01847 L
s
.21429 .01472 m
.21429 .01847 L
s
.2415 .01472 m
.2415 .01847 L
s
.26871 .01472 m
.26871 .01847 L
s
.32313 .01472 m
.32313 .01847 L
s
.35034 .01472 m
.35034 .01847 L
s
.37755 .01472 m
.37755 .01847 L
s
.40476 .01472 m
.40476 .01847 L
s
.45918 .01472 m
.45918 .01847 L
s
.48639 .01472 m
.48639 .01847 L
s
.51361 .01472 m
.51361 .01847 L
s
.54082 .01472 m
.54082 .01847 L
s
.59524 .01472 m
.59524 .01847 L
s
.62245 .01472 m
.62245 .01847 L
s
.64966 .01472 m
.64966 .01847 L
s
.67687 .01472 m
.67687 .01847 L
s
.73129 .01472 m
.73129 .01847 L
s
.7585 .01472 m
.7585 .01847 L
s
.78571 .01472 m
.78571 .01847 L
s
.81293 .01472 m
.81293 .01847 L
s
.86735 .01472 m
.86735 .01847 L
s
.89456 .01472 m
.89456 .01847 L
s
.92177 .01472 m
.92177 .01847 L
s
.94898 .01472 m
.94898 .01847 L
s
.25 Mabswid
0 .01472 m
1 .01472 L
s
.29592 .13599 m
.30217 .13599 L
s
[(2)] .28342 .13599 1 0 Mshowa
.29592 .25726 m
.30217 .25726 L
s
[(4)] .28342 .25726 1 0 Mshowa
.29592 .37854 m
.30217 .37854 L
s
[(6)] .28342 .37854 1 0 Mshowa
.29592 .49981 m
.30217 .49981 L
s
[(8)] .28342 .49981 1 0 Mshowa
.125 Mabswid
.29592 .04503 m
.29967 .04503 L
s
.29592 .07535 m
.29967 .07535 L
s
.29592 .10567 m
.29967 .10567 L
s
.29592 .16631 m
.29967 .16631 L
s
.29592 .19663 m
.29967 .19663 L
s
.29592 .22694 m
.29967 .22694 L
s
.29592 .28758 m
.29967 .28758 L
s
.29592 .3179 m
.29967 .3179 L
s
.29592 .34822 m
.29967 .34822 L
s
.29592 .40886 m
.29967 .40886 L
s
.29592 .43917 m
.29967 .43917 L
s
.29592 .46949 m
.29967 .46949 L
s
.29592 .53013 m
.29967 .53013 L
s
.29592 .56045 m
.29967 .56045 L
s
.29592 .59077 m
.29967 .59077 L
s
.25 Mabswid
.29592 0 m
.29592 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .02356 m
.04262 .02498 L
.06244 .02696 L
.08255 .02979 L
.09396 .03197 L
.10458 .03456 L
.11508 .03792 L
.125 .04221 L
.1339 .04751 L
.13893 .05143 L
.14357 .05592 L
.14823 .0616 L
.15324 .06963 L
.15797 .08004 L
.1623 .09354 L
.16492 .10468 L
.16735 .11816 L
.17002 .13832 L
.17152 .15333 L
.17287 .1704 L
.17417 .19108 L
.17536 .21553 L
.17667 .25142 L
.17732 .27475 L
.17805 .30622 L
.17926 .38053 L
.18057 .51735 L
s
.18057 .51735 m
.18102 .61803 L
s
.18719 .61803 m
.18773 .50478 L
.18903 .37689 L
.18968 .33499 L
.19039 .29909 L
.19166 .25207 L
.19284 .22053 L
.19403 .19616 L
.19516 .17797 L
.19727 .1523 L
.19954 .13251 L
.20201 .11672 L
.20451 .10461 L
.20726 .0943 L
.20993 .08637 L
.21281 .0795 L
.21796 .07013 L
.22277 .06363 L
.22803 .05817 L
.2329 .05415 L
.2387 .05032 L
.24394 .0475 L
.25368 .0434 L
.26405 .04015 L
.2741 .03773 L
.28333 .03595 L
.29411 .03427 L
.30416 .03298 L
.32303 .03111 L
.3437 .02961 L
.3641 .02852 L
.38266 .02776 L
.40179 .02716 L
.42256 .02668 L
.44238 .02635 L
.45237 .02622 L
.4634 .02611 L
.46833 .02608 L
.47352 .02604 L
.478 .02602 L
.48278 .026 L
.48549 .02599 L
.48795 .02598 L
.49045 .02597 L
.49276 .02597 L
.49406 .02597 L
.49545 .02596 L
.49684 .02596 L
.49763 .02596 L
.49836 .02596 L
Mistroke
.49905 .02596 L
.4997 .02596 L
.50092 .02596 L
.50223 .02596 L
.50297 .02596 L
.50365 .02596 L
.50483 .02596 L
.50606 .02597 L
.50827 .02597 L
.51066 .02597 L
.51326 .02598 L
.51794 .026 L
.52229 .02602 L
.53225 .02608 L
.54289 .02617 L
.55311 .02629 L
.56421 .02645 L
.58435 .02683 L
.6042 .02733 L
.62524 .02806 L
.64479 .02895 L
.66309 .03005 L
.68336 .03167 L
.70188 .03372 L
.71174 .03513 L
.72088 .03672 L
.73156 .03902 L
.74161 .04181 L
.75148 .04542 L
.75667 .0478 L
.76215 .05083 L
.76677 .05391 L
.77185 .05805 L
.77612 .06235 L
.78076 .06823 L
.78601 .07707 L
.78842 .08226 L
.79098 .08888 L
.79328 .09611 L
.79581 .106 L
.79812 .11745 L
.80029 .13127 L
.80285 .15353 L
.80413 .16837 L
.80554 .18882 L
.80675 .21136 L
.80804 .24304 L
.80925 .28419 L
.81036 .33715 L
.81103 .38151 L
Mistroke
.81175 .44416 L
Mfstroke
.81175 .44416 m
.81293 .61803 L
s
.8189 .61803 m
.81991 .45658 L
.82121 .34766 L
.82246 .28352 L
.82317 .25697 L
.82383 .23652 L
.82516 .20411 L
.82659 .17841 L
.82792 .15998 L
.82917 .14594 L
.83153 .12575 L
.83431 .10858 L
.83687 .09676 L
.83969 .08673 L
.84267 .07841 L
.84763 .06805 L
.85228 .06091 L
.85738 .05492 L
.86286 .04994 L
.87296 .04328 L
.87868 .04046 L
.88399 .03827 L
.89363 .03507 L
.90407 .0324 L
.91463 .03028 L
.92459 .02866 L
.94319 .02633 L
.95924 .02482 L
.97619 .02356 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{35, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/@P10`4000010?ooobl_;oooZZVYZNSX
j?oo05FZZZZZZ_W0RS/k>gYjN[Vi^OShn03ooeGooj[ooonI<c<c<fi^KZf][Nc/k02ZoeFZojZZoonZ
oclo?ginO[fm_Oclo5D00:X00?l00?l0VCLg=g9bL[6a/O3`l03o05Go0:[o00<30d92@X61PL30`000
EED0EJX0EOl0ELbIoc/k>gIfM[Fe]OCdm03oEEGoEJ[oE@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0Z/`c
<clo?gYjN[Vi^OShn03oZUGoZZ[oZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`<30d92@WinO[fm_Ocl
o03ooeGooj[oo`l?3di>CXf=SLc<c01E05EE0:YE0?mE00L71dI6AX61PL30`000EED00:X00?l001<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@/;2dY:BXF5QLC4a000ZUD0EJX0EOl0EALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZPl?3di>CXV9RLS8b000oeD0ZZX0Z_l0ZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEoa<C
4e9BDXf=SLc<c01E05D0ojX0ool0oalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ01LG5eIFEY6ATM3@d01E
EEEE0:YE0?mE02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZEA/K6eYJFYFEUMCDe01EZUEEEJYEEOmEEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZQlO7eiNGYVIVMSHf01EoeEEZZYEZ_mEZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZob<S8f9RHYfMWMcLg02Z05EEojYEoomEobl_;fi^KZf][Nc/k03o05Go0:[o0=gW1RLW
9fIVIZ6QXN3Ph02ZEEFZ0:ZZ0?nZ03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooEB/[:fYZJZFUYNCTi02Z
ZUFZEJZZEOnZECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l08@000?l08@0000h01?lQ00?oA003ob<0
1?lQ00?o8`03ob400ol>00003`000ol0000R0003o`0004@000?o00008`000ol0000T0003o`000240
00?o00008`000ol0000;00002005o`<000?o00006P05o`8000?o0000A0000ol0000T0003o`0002<0
00?o00007`04ob@000?o00002`00014000?o000080000ol000140003o`0002D000?o00008002ob80
00?o0?l08P03o`h0000>0004o`00ob8000?o0000A0000ol0000R0004o`00ob@000?o00007`000ol0
o`0R0003o`0000h0000?00;o8P02odD00_lU00;o8P03ob<00_lR00Co3@0005L000?o0000aP0005L0
00?o0000aP0005L000?o0000aP0005L000?o0000aP0000L0oolBo`P0000=0003o`0000D000?o0000
10000ol000040003o`0000D000?o000010000ol000050003o`0000@000?o00001@000ol000040003
o`0000@000?o00001@000ol000040003o`0000D000?o000010000ol000040003o`0000D000?o0000
10000ol000050003o`0000@000?o00001@000ol000040003o`0000@000?o00001@000ol000040003
o`0000D000?o000010000ol000040003o`0000D000?o000010000ol000050003o`0000@000?o0000
1@000ol000040003o`0000@000?o00001@000ol0000<00003@04ob4000?o00008P000ol0000R0003
o`0002<000?o00008P000ol0000R0003o`0002000ol>00004@0;oc/000?o0000600moeL02OlA0000
7004ocL000?o00000`0Eocd04?m000Oo6P0002001_l`00OoHP0:oc<00olQ00009P03obL01_l00`3o
001`00Go:@05ob@0000Y0003o`0002800_l70003o`0007@01_lR0003o`0002L0000Z0003o`0001h0
0ol900;oN`000ol0000M00;o:P0002/00_lL00;o30000ol0001k0003o`0001/000?o0000:P0002d0
00?o00005`02o`h000?o0000O002oaT00_l]0000;P000ol0000E0003o`0000h000?o0000OP000ol0
000E0003o`0002d0000^0003o`0001<00_lA0003o`0007l000?o000050000ol0000]0000;`000ol0
000A0003o`00014000?o0000P0000ol0000B0003o`0002h0000_0003o`00014000?o00004@000ol0
00210003o`00014000?o0000;P00030000?o00003`000ol0000B0003o`00088000?o00003`000ol0
000_0000<0000ol0000?0003o`00018000?o0000PP000ol0000>0003o`000300000a0003o`0000d0
00?o00004`02oh@000?o000030000ol0000a0000<P000ol0000<0003o`0001<000?o0000Q0000ol0
000;0003o`000340000b0003o`0000`000?o00004`000ol000240003o`0000/000?o0000<@0003<0
00?o00002P000ol0000D0003o`0008@000?o00002`000ol0000a0000<`000ol0000:0003o`0001@0
00?o0000Q0000ol0000;0003o`000340000c0003o`0000T000?o00005@000ol000250003o`0000T0
00?o0000<P0003<000?o00002@000ol0000E0003o`0008D000?o00002@000ol0000b0000=0000ol0
00070003o`0001H000?o0000QP000ol000080003o`000380000d0003o`0000L000?o00005P02ohL0
00?o00001`000ol0000c0000=0000ol000070003o`0001H000?o0000QP000ol000070003o`0003<0
000d0003o`0000L000?o00005P000ol000260003o`0000L000?o0000<`0003@000?o00001`000ol0
000F0003o`0008H000?o00001`000ol0000c0000=0000ol000070003o`0001H000?o0000QP000ol0
00060003o`0003@0000d0003o`0000L000?o00005P000ol000260003o`0000H000?o0000=00003@0
00?o00001P000ol0000?00Co10000ol000270003o`0000D000?o0000=00003D000?o00001@000ol0
000@0003o`0000@000?o0000Q`000ol000050003o`0003@0000e0003o`0000D000?o00004@000ol0
000300?oQ`000ol000050003o`0003@0000e0003o`0000D000?o00004P000ol000020003o`0008L0
00?o00001@000ol0000d0000=@000ol000040003o`00010000Co003o10000ol000270003o`0000D0
00?o0000=00003D000?o000010000ol0000A00;o1@000ol000280003o`0000@000?o0000=00003D0
00?o000010000ol0000H0003o`0008P000?o000010000ol0000d0000=@000ol000040003o`0001P0
00?o0000R0000ol000040003o`0003@0000e0003o`0000@000?o000060000ol000280003o`0000<0
00?o0000=@0003D000?o000010000ol0000H0003o`0008P000?o00000`000ol0000e0000=P000ol0
00030003o`0001P00_n90003o`0000<000?o0000=@0003H000?o00000`000ol0000H0003o`0008P0
00?o00000`000ol0000e0000=P000ol000030003o`0001P000?o0000R0000ol000030003o`0003D0
000f0003o`0000<000?o000060000ol000280003o`0000<000?o0000=@0003H000?o00000`000ol0
000H0003o`0008P000?o00000`000ol0000e0000=P000ol000030003o`0001P000?o0000R0000ol0
00030003o`0003D0000f0003o`0000<000?o000060000ol000280003o`0000<000?o0000=@0003H0
00?o00000`000ol0000H0003o`0008P000?o00000`000ol0000e0000=P000ol000030003o`0001P0
00?o0000R0000ol000030003o`0003D0000f0003o`0000<000?o00006002ohT000?o00000`000ol0
000e0000=P000ol000030003o`0001P000?o0000R@000ol000020003o`0003D0000f0003o`0000<0
00?o000060000ol000290003o`00008000?o0000=@0003H000?o00000P000ol0000I0003o`0008T0
00?o00000P000ol0000e0000=P000ol000020003o`0001T000?o0000R@000ol000020003o`0003D0
000f0003o`00008000?o00006@000ol000290003o`00008000?o0000=@0003H000?o00000P000ol0
000I0003o`0008T000?o00000P000ol0000e0000=P000ol000020003o`0001T000?o0000R@001Ol0
003o03P0000f0003o`00008000?o00006@02ohX000Go0000o`0h0000=P000ol000020003o`0001T0
00?o0000R@001Ol0003o03P0000f0003o`00008000?o00006@000ol000290005o`000?l0>00003L0
00Go0000o`0K0003o`0008T000Go0000o`0h0000=`001Ol0003o01/000?o0000R@001Ol0003o03P0
000g0005o`000?l06`000ol000290005o`000?l0>00003L000Go0000o`0D00?o10000ol000290005
o`000?l0>00003L000Go0000o`0E0003o`0000<000?o0000R@001Ol0003o03P0000g0005o`000?l0
4`04o`@00on90005o`000?l0>00003L000Go0000o`0C0003o`3o00D000?o0000R@001Ol0003o03P0
000g0005o`000?l04`000ol0o`050003o`0008T000Go0000o`0h0000=`001Ol0003o01@00_l50003
o`0008T000Go0000o`0h0000=`001Ol0003o01/000?o0000R@001Ol0003o03P0000g0005o`000?l0
6`000ol000290005o`000?l0>00003L000Go0000o`0K0003o`0008T000Go0000o`0h0000=`001Ol0
003o01/000?o0000R@001Ol0003o03P0000g0005o`000?l06`02ohX000Go0000o`0h0000=`001Ol0
003o01/000?o0000R@001Ol0003o03P0000g0005o`000?l06`000ol000290005o`000?l0>00003L0
00Go0000o`0K0003o`0008T000Go0000o`0h0000=`001Ol0003o01/000?o0000R@001Ol0003o03P0
000g0005o`000?l06`000ol000290005o`000?l0>00003L000Go0000o`0K0003o`0008T000Go0000
o`0h0000=`001Ol0003o01/000?o0000RP001?l00?lh0000=`001Ol0003o01/000?o0000RP001?l0
0?lh0000=`001?l00?lL00;oR`001?l00?lh0000=`001?l00?lL0003o`0008X000Co003o>00003L0
00Co003o70000ol0002:0004o`00ocP0000g0004o`00oa`000?o0000RP001?l00?lh0000=`001?l0
0?lL0003o`0008X000Co003o>00003L000Co003o70000ol0002:0004o`00ocP0000g0004o`00oa`0
00?o0000RP001?l00?lh0000>0000ol0o`0L0003o`0008X000Co003o>00003P000?o0?l07002oh/0
00Co003o>00003P000?o0?l070000ol0002:0004o`00ocP0000h0003o`3o01`000?o0000RP001?l0
0?lh0000>0000ol0o`0L0003o`0008X000Co003o>00003P000?o0?l070000ol0002:0004o`00ocP0
000h0003o`3o01`000?o0000RP001?l00?lh0000>0000ol0o`0E00;o1@000ol0002:0004o`00ocP0
000h0003o`3o01@000Co003o10000ol0002:0004o`00ocP0000h0003o`3o01@000Co003o1003ohX0
00Co003o>00003P000?o0?l05003o`D000?o0000RP001?l00?lh0000>0000ol0o`0D0003o`0000D0
00?o0000RP001?l00?lh0000>0000ol0o`0E00?o10000ol0002:0004o`00ocP0000h0003o`3o01`0
00?o0000RP001?l00?lh0000>0000ol0o`0L0003o`0008X000Co003o>00003P000?o0?l070000ol0
002:0004o`00ocP0000h0003o`3o01`000?o0000RP000ol0o`0i0000>0000ol0o`0L00;oR`000ol0
o`0i0000>0000ol0o`0L0003o`0008X000?o0?l0>@0003P000?o0?l070000ol0002:0003o`3o03T0
000h0003o`3o01`000?o0000RP000ol0o`0i0000>0000ol0o`0L0003o`0008X000?o0?l0>@0003P0
00?o0?l070000ol0002:0003o`3o03T0000h0003o`3o01`000?o0000RP000ol0o`0i0000>0000ol0
o`0L0003o`0008X000?o0?l0>@0003P000?o0?l070000ol0002:0003o`3o03T0000h0003o`3o01`0
0_n;0003o`3o03T0000h0003o`3o01`000?o0000RP000ol0o`0i0000>0000ol0o`0L0003o`0008X0
00?o0?l0>@0003P000?o0?l070000ol0002:0003o`3o03T0000h0003o`3o01`000?o0000RP000ol0
o`0i0000>0000ol0o`0L0003o`0008X000?o0?l0>@0003P000?o0?l070000ol0002:0003o`3o03T0
000h0003o`3o01`000?o0000RP000ol0o`0i0000>0000ol0o`0L00;oR`000ol0o`0i0000>0000ol0
o`0L0003o`0008X000?o0?l0>@0003P000?o0?l070000ol0002:0003o`3o03T0000h0003o`3o01`0
00?o0000RP000ol0o`0i0000>0000ol0o`0L0003o`0008X000?o0?l0>@0003P000?o0?l070000ol0
002:0003o`3o03T0000h0003o`3o01D00_l50003o`0008X000?o0?l0>@0003P000?o0?l050001?l0
0?l40003o`0008X000?o0?l0>@0003P000?o0?l050001?l00?l400?oRP000ol0o`0i0000>0000ol0
o`0E00;o1@000ol0002:0003o`3o03T0000h0003o`3o01@000Co003o10000ol0002:0003o`3o03T0
000h0003o`3o01D00_l50003o`0008X000?o0?l0>@0003P000?o0?l070000ol0002:0003o`3o03T0
000h0003o`3o01`000?o0000RP000ol0o`0i0000>0000ol0o`0L0003o`0008X000?o0?l0>@0003P0
00?o0?l070000ol0002:0003o`3o03T0000h0003o`3o01`000?o0000RP000ol0o`0i0000>0000ol0
o`0L00;oR`000ol0o`0i0000>0000ol0o`0L0003o`0008X000?o0?l0>@0003P000?o0?l070000ol0
002:0003o`3o03T0000h0003o`3o01`000?o0000RP000ol0o`0i0000>0000ol0o`0L0003o`0008X0
00?o0?l0>@0003P000?o0?l070000ol0002:0003o`3o03T0000h0003o`3o01`000?o0000RP000ol0
o`0i0000>0000ol0o`0L0003o`0008X000?o0?l0>@0003P000?o0?l07002oh/000?o0?l0>@0003P0
00?o0?l070000ol0002:0003o`3o03T0000h0003o`3o01`000?o0000RP000ol0o`0i0000>0000ol0
o`0L0003o`0008X000?o0?l0>@0003P000?o0?l070000ol0002:0003o`3o03T0000h0003o`3o01`0
00?o0000RP000ol0o`0i0000>0000ol0o`0L0003o`0008X000?o0?l0>@0003P000?o0?l070000ol0
002:0003o`3o03T0000h0003o`3o01`00_n;0003o`3o03T0000h0003o`3o01`000?o0000RP000ol0
o`0i0000>0000ol0o`0L0003o`0008X000?o0?l0>@0003P000?o0?l070000ol0002:0003o`3o03T0
000h0003o`3o01`000?o0000RP000ol0o`0i0000>0000ol0o`0L0003o`0008X000?o0?l0>@0003P0
00?o0?l070000ol0002:0003o`3o03T0000h0003o`3o01`000?o0000RP000ol0o`0i0000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-2.36761, -0.750376, 
  0.0269521, 0.0604735}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Closed]],

Cell[TextData[{
  "Other possible side effects are ",
  StyleBox["Print", "Input"],
  " statements, and functions that change values of global symbols. The \
following function ",
  StyleBox["fib", "Input"],
  " computes Fibonacci numbers recursively, using the formula ",
  Cell[BoxData[
      \(TraditionalForm\`F\_n = F\_\(n - 1\) + F\_\(n - 2\)\)]],
  ", with the starting values ",
  Cell[BoxData[
      \(TraditionalForm\`F\_1 = \(F\_2 = 1\)\)]],
  ". First, we define the starting values."
}], "Text"],

Cell[BoxData[
    \(Clear[fib]; fib[1] = \(fib[2] = 1\); \)], "Input"],

Cell[TextData[{
  "The right-hand side of the following definition stores, or caches, \
intermediate values of ",
  StyleBox["fib", "Input"],
  " by immediately setting each intermediate value ",
  StyleBox["fib[", "Input"],
  StyleBox["n",
    FontSlant->"Italic"],
  StyleBox["]", "Input"],
  " equal to its value."
}], "Text"],

Cell[BoxData[
    \(fib[n_] := \((fib[n] = fib[n - 1] + fib[n - 2])\)\)], "Input"],

Cell["Here is the seventh Fibonacci number.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(fib[7]\)], "Input"],

Cell[BoxData[
    \(13\)], "Output"]
}, Closed]],

Cell[TextData[{
  "We see that the definition of ",
  StyleBox["fib", "Input"],
  " has the side effect of storing intermediate results."
}], "Text"],

Cell[CellGroupData[{

Cell["? fib", "Input"],

Cell[BoxData[
    \("Global`"\[InvisibleSpace]"fib"\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      StyleBox[
        "\(fib[1]\\  = \\ 1\\n\\ \\n         fib[2]\\  = \\ 1\\n\\ \\n        \
 fib[3]\\  = \\ 2\\n\\ \\n         fib[4]\\  = \\ 3\\n\\ \\n         fib[5]\\ \
 = \\ 5\\n\\ \\n         fib[6]\\  = \\ 8\\n\\ \\n         fib[7]\\  = \\ \
13\\n\\ \\n         fib[n_]\\  := \\ \(fib[n]\\  = \\ fib[n\\  - \\ 1]\\  + \
\\ fib[n\\  - \\ 2]\)\)",
        ShowStringCharacters->True,
        NumberMarks->True],
      InputForm[ 
        Definition[ fib]],
      Editable->True,
      AutoDelete->True]], "Print"]
}, Closed]],

Cell[TextData[{
  "The style of programming that involves a function modifying its own \
definition is called ",
  StyleBox["dynamic programming",
    FontSlant->"Italic"],
  "."
}], "Text"],

Cell[TextData[{
  "See also ",
  StyleBox["Scan", "Input"],
  ", ",
  StyleBox["Do", "Input"],
  " "
}], "SeeAlso"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Lists", "Section"],

Cell[CellGroupData[{

Cell["Creating and Interpreting Lists", "Subsection"],

Cell[TextData[{
  "The basic data structure in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " is the ",
  StyleBox["list",
    FontSlant->"Italic"],
  ". The elements of a list can be any combination of numbers, variables, \
strings, functions, and other lists; enclosed within curly brackets ",
  StyleBox["{ }", "Input"],
  " and separated by commas."
}], "Text"],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " lists often have natural interpretations as vectors, matrices, or \
tensors, depending on how deeply they are nested. A one-dimensional list acts \
as a vector, a two-dimensional list as a matrix, and higher-dimensional lists \
as tensors."
}], "Text"],

Cell[TextData[{
  "One way to enter an arbitrary list is to type a sequence of elements \
inside curly brackets and separated by commas. The following one-dimensional \
list ",
  StyleBox["vec", "Input"],
  " can be considered a vector with the three components ",
  StyleBox["a", "Input"],
  ", ",
  StyleBox["b", "Input"],
  ", and ",
  StyleBox["c", "Input"],
  "."
}], "Text"],

Cell[BoxData[
    \(\(vec = {a, b, c}; \)\)], "Input"],

Cell[TextData[{
  "An easier way to create a vector of evenly spaced numbers is to use ",
  StyleBox["Range", "Input"],
  ". ",
  StyleBox["Range[", "Input"],
  StyleBox["max",
    FontSlant->"Italic"],
  StyleBox["]", "Input"],
  " creates a list of integers from 1 through ",
  StyleBox["max",
    FontSlant->"Italic"],
  "; ",
  StyleBox["Range[", "Input"],
  StyleBox["min",
    FontSlant->"Italic"],
  StyleBox[",", "Input"],
  " ",
  StyleBox["max",
    FontSlant->"Italic"],
  StyleBox["]", "Input"],
  " creates a list of numbers from ",
  StyleBox["min",
    FontSlant->"Italic"],
  " through ",
  StyleBox["max",
    FontSlant->"Italic"],
  " in increments of 1; and ",
  StyleBox["Range[", "Input"],
  StyleBox["min",
    FontSlant->"Italic"],
  StyleBox[",", "Input"],
  " ",
  StyleBox["max",
    FontSlant->"Italic"],
  StyleBox[",", "Input"],
  " ",
  StyleBox["inc",
    FontSlant->"Italic"],
  StyleBox["]", "Input"],
  " returns a list of numbers ranging from ",
  StyleBox["min",
    FontSlant->"Italic"],
  " through ",
  StyleBox["max",
    FontSlant->"Italic"],
  " with increment ",
  StyleBox["inc",
    FontSlant->"Italic"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(vec2 = Range[2, 5, 1/2]\)], "Input"],

Cell[BoxData[
    \({2, 5\/2, 3, 7\/2, 4, 9\/2, 5}\)], "Output"]
}, Closed]],

Cell[TextData[{
  "A more general function for creating lists is ",
  StyleBox["Table", "Input"],
  ", which generates lists (nested to any depth) of elements that may depend \
on the given iterators. For example, to generate a list of values of ",
  Cell[BoxData[
      \(TraditionalForm\`k\^2\)]],
  " as ",
  StyleBox["k",
    FontSlant->"Italic"],
  " takes on values from 1 to 10, we evaluate the following."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Table[k\^2, {k, 1, 10}]\)], "Input"],

Cell[BoxData[
    \({1, 4, 9, 16, 25, 36, 49, 64, 81, 100}\)], "Output"]
}, Closed]],

Cell["\<\
We create tables of more complicated functions in a similar \
way.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(vec3 = 
      Table[N[Exp[\[Pi]\ \[ImaginaryI]\ t]], {t, 0, 2\ \[Pi], \[Pi]/4}]\)], 
  "Input"],

Cell[BoxData[
    \({1.`, \(-0.781211892110488115`\) + 0.624265952639699062`\ I, 
      \(0.220584040749697951`\[InvisibleSpace]\) - 0.975367972083631507`\ I, 
      \(0.436566140423590987`\[InvisibleSpace]\) + 0.899672165311147864`\ I, 
      \(-0.902685361933071206`\) - 0.430301217000092073`\ I, 
      \(0.9738109387287599`\[InvisibleSpace]\) - 0.227359309490971694`\ I, 
      \(-0.618820010071298831`\) + 0.785532809712845558`\ I, 
      \(-0.00695183684149917446`\) - 0.99997583569030759`\ I, 
      \(0.629681725296479388`\[InvisibleSpace]\) + 0.77685321961593825`\ I}
      \)], "Output"]
}, Closed]],

Cell[TextData[{
  "Many mathematical and plotting functions are designed to operate on lists. \
Here is a plot of the real parts of the elements of ",
  StyleBox["vec3", "Input"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(ListPlot[Re[vec3], PlotStyle \[Rule] PointSize[0.03]]; \)\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0952381 0.119048 0.293965 0.309354 [
[.38095 .28146 -3 -9 ]
[.38095 .28146 3 0 ]
[.61905 .28146 -3 -9 ]
[.61905 .28146 3 0 ]
[.85714 .28146 -3 -9 ]
[.85714 .28146 3 0 ]
[.13036 .06195 -30 -4.5 ]
[.13036 .06195 0 4.5 ]
[.13036 .13929 -24 -4.5 ]
[.13036 .13929 0 4.5 ]
[.13036 .21663 -30 -4.5 ]
[.13036 .21663 0 4.5 ]
[.13036 .3713 -24 -4.5 ]
[.13036 .3713 0 4.5 ]
[.13036 .44864 -18 -4.5 ]
[.13036 .44864 0 4.5 ]
[.13036 .52598 -24 -4.5 ]
[.13036 .52598 0 4.5 ]
[.13036 .60332 -6 -4.5 ]
[.13036 .60332 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.38095 .29396 m
.38095 .30021 L
s
[(4)] .38095 .28146 0 1 Mshowa
.61905 .29396 m
.61905 .30021 L
s
[(6)] .61905 .28146 0 1 Mshowa
.85714 .29396 m
.85714 .30021 L
s
[(8)] .85714 .28146 0 1 Mshowa
.125 Mabswid
.20238 .29396 m
.20238 .29771 L
s
.2619 .29396 m
.2619 .29771 L
s
.32143 .29396 m
.32143 .29771 L
s
.44048 .29396 m
.44048 .29771 L
s
.5 .29396 m
.5 .29771 L
s
.55952 .29396 m
.55952 .29771 L
s
.67857 .29396 m
.67857 .29771 L
s
.7381 .29396 m
.7381 .29771 L
s
.79762 .29396 m
.79762 .29771 L
s
.08333 .29396 m
.08333 .29771 L
s
.02381 .29396 m
.02381 .29771 L
s
.91667 .29396 m
.91667 .29771 L
s
.97619 .29396 m
.97619 .29771 L
s
.25 Mabswid
0 .29396 m
1 .29396 L
s
.14286 .06195 m
.14911 .06195 L
s
[(-0.75)] .13036 .06195 1 0 Mshowa
.14286 .13929 m
.14911 .13929 L
s
[(-0.5)] .13036 .13929 1 0 Mshowa
.14286 .21663 m
.14911 .21663 L
s
[(-0.25)] .13036 .21663 1 0 Mshowa
.14286 .3713 m
.14911 .3713 L
s
[(0.25)] .13036 .3713 1 0 Mshowa
.14286 .44864 m
.14911 .44864 L
s
[(0.5)] .13036 .44864 1 0 Mshowa
.14286 .52598 m
.14911 .52598 L
s
[(0.75)] .13036 .52598 1 0 Mshowa
.14286 .60332 m
.14911 .60332 L
s
[(1)] .13036 .60332 1 0 Mshowa
.125 Mabswid
.14286 .07742 m
.14661 .07742 L
s
.14286 .09288 m
.14661 .09288 L
s
.14286 .10835 m
.14661 .10835 L
s
.14286 .12382 m
.14661 .12382 L
s
.14286 .15476 m
.14661 .15476 L
s
.14286 .17022 m
.14661 .17022 L
s
.14286 .18569 m
.14661 .18569 L
s
.14286 .20116 m
.14661 .20116 L
s
.14286 .23209 m
.14661 .23209 L
s
.14286 .24756 m
.14661 .24756 L
s
.14286 .26303 m
.14661 .26303 L
s
.14286 .2785 m
.14661 .2785 L
s
.14286 .30943 m
.14661 .30943 L
s
.14286 .3249 m
.14661 .3249 L
s
.14286 .34037 m
.14661 .34037 L
s
.14286 .35584 m
.14661 .35584 L
s
.14286 .38677 m
.14661 .38677 L
s
.14286 .40224 m
.14661 .40224 L
s
.14286 .41771 m
.14661 .41771 L
s
.14286 .43317 m
.14661 .43317 L
s
.14286 .46411 m
.14661 .46411 L
s
.14286 .47958 m
.14661 .47958 L
s
.14286 .49504 m
.14661 .49504 L
s
.14286 .51051 m
.14661 .51051 L
s
.14286 .54145 m
.14661 .54145 L
s
.14286 .55692 m
.14661 .55692 L
s
.14286 .57238 m
.14661 .57238 L
s
.14286 .58785 m
.14661 .58785 L
s
.14286 .04648 m
.14661 .04648 L
s
.14286 .03101 m
.14661 .03101 L
s
.14286 .01555 m
.14661 .01555 L
s
.14286 8e-05 m
.14661 8e-05 L
s
.25 Mabswid
.14286 0 m
.14286 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.03 w
.02381 .60332 Mdot
.14286 .05229 Mdot
.2619 .3622 Mdot
.38095 .42902 Mdot
.5 .01472 Mdot
.61905 .59522 Mdot
.7381 .10253 Mdot
.85714 .29181 Mdot
.97619 .48876 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{35, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/@P10`4000010?ooobl_;oooZZVYZNSX
j?oo05FZZZZZZ_nZZS/k>gYjN[Vi^OShn03ooeGooj[ooonI<c<c<fi^KZf][Nc/k02ZoeFZojZZoonZ
oclo?ginO[fm_Oclo5D00:X00?l00?l0VCLg=g9bL[6a/O3`l03o05Go0:[o00<30d92@X61PL30`000
EED0EJX0EOl0ELbIoc/k>gIfM[Fe]OCdm03oEEGoEJ[oE@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0Z/`c
<clo?gYjN[Vi^OShn03oZUGoZZ[oZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`<30d92@WinO[fm_Ocl
o03ooeGooj[oo`l?3di>CXf=SLc<c01E05EE0:YE0?mE00L71dI6AX61PL30`000EED00:X00?l001<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@/;2dY:BXF5QLC4a000ZUD0EJX0EOl0EALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZPl?3di>CXV9RLS8b000oeD0ZZX0Z_l0ZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEoa<C
4e9BDXf=SLc<c01E05D0ojX0ool0oalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ01LG5eIFEY6ATM3@d01E
EEEE0:YE0?mE02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZEA/K6eYJFYFEUMCDe01EZUEEEJYEEOmEEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZQlO7eiNGYVIVMSHf01EoeEEZZYEZ_mEZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZob<S8f9RHYfMWMcLg02Z05EEojYEoomEobl_;fi^KZf][Nc/k03o05Go0:[o0=gW1RLW
9fIVIZ6QXN3Ph02ZEEFZ0:ZZ0?nZ03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooEB/[:fYZJZFUYNCTi02Z
ZUFZEJZZEOnZECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP0002T00_oe0000:@000ol0001Q00CoS`0002T0
00?o0000H006ohh0000Y0003o`0005l02?n=0000:@02of002?n=0000:@000ol0001O00SoS@0002T0
00?o0000G`08ohd0000Y0003o`0006001_n>0000:@02of801?n?0000:@000ol0003d0000:@000ol0
003d00009`04ooD0000V00Kom00002D02?oc00009@08oo<0000?00;o1002o`@000?o00000P03o`80
2?oc00003P001?l00?l300;o10000ol000050003o`3o00Ool`0000P01Ol01@3o003o00X000?o0000
10000ol00006oo@0000>0004o`00o`X000Co00000ol400Com@0000h000Co003o2`001?l00?l80003
o`000?@0000?00;o2@04o`801?l50003o`000?@0000Y0003o`000?@0000Y00;om@0002T000?o0000
m00002T000?o0000m00002T000?o0000m00002T00_nV00CoB`0002T000?o0000Y006odX0000Y0003
o`000:<02?m90000:@000ol0002S00SoB@0002T000?o0000X`08odT0000Y00;oY008odT0000Y0003
o`000:@01_m:0000:@000ol0002U00CoB`0002T000?o0000m00002T00_oe0000:@000ol0003d0000
5@02o`@00_l300?o1P000ol0003d000050001?l00?l300;o1P000ol000030003o`000?@0000>00Go
00D0o`00o`0;0003o`0000<00ood000050001?l00?l800?o1P000ol0003d000050001?l00?l80003
o`0000H000?o0000m00001D00_l900Co1@000ol0003d0000:@000ol0003d0000:@02ooD0000Y0003
o`000?@0000Y0003o`000?@0000Y0003o`000?@0000Y00;om@0002T000?o0000m00002T000?o0000
m00002T000?o0000m00002T000?o0000m00002T00_oe0000:@000ol0003d0000:@000ol0003d0000
:@000ol0003d0000:@02ooD0000Y0003o`000?@0000?00;o1002o`<01?l200?o1P000ol0003d0000
3P001?l00?l300;o10000ol000050003o`0000<000?o0000m00000P01Ol01@3o003o00X000?o0000
10000ol0000300?om00000h000Co003o2`000ol00003o`H000?o0000m00000h000Co003o20001?l0
0?l20003o`0000H000?o0000m00000l00_l:00;o0`04o`D000?o0000m00002T000?o0000m00002T0
0_oe0000:@000ol0003d0000:@000ol0003d0000:@000ol0003d0000:@02ooD0000Y0003o`000?@0
000Y0003o`000?@0000Y0003o`0004000om100;o@P02obX0000Y0003o`00044000?o0000?`001?l0
0?m00004o`00obT0000Y00;o@004od0000Co003o@0001?l00?lY0000:@000ol0000o0003o`3o0440
0om200;o:P0002T000?o0000?`000ol0o`110003o`00044000Co003o:@0002T000?o0000@002od80
0om100;o:P0002T00_oe0000:@000ol0003700Co:@0002T000?o0000aP06obP0000Y0003o`000<D0
2?lW0000:@000ol0003500So9`000?oo8?l100001`000ol0000>0003o`0000h000?o00003P000ol0
000>0003o`0000h000?o00003P000ol0000>0003o`0000h000?o00003P000ol0000>0003o`0000h0
00?o00003P000ol0000>0003o`0000X02?l=0003o`0000h000?o00001P0002T000?o0000aP06obP0
000Y0003o`000<L01?lY0000:@02ooD0000Y0003o`000?@0000Y0003o`000?@0000Y0003o`000?@0
000Y00;om@0002T000?o0000m00002T000?o0000m00002T000?o0000m00002T000?o0000m00002T0
0_oe0000:@000ol0003d0000:@000ol0003d0000:@000ol0000M00Cod`0002T00_lM00KodP0002T0
00?o00006`08om40000Y0003o`0001/02?oA00003`02o`@00_l300Co0P03o`H000?o00006`08om40
000>0004o`00o`<00_l40003o`0000D000?o00000`000ol0000K00Sod@0000h000Co003o2P000ol0
00040003o`0000<00olL00KodP0000h000Co003o2`000ol00003o`H000?o00007@04om<0000>0004
o`00o`P000Co003o0P000ol000060003o`000?@0000?00;o2P02o`<01?l50003o`000?@0000Y00;o
m@0002T000?o0000m00002T000?o0000m00002T000?o0000m00002T000?o0000m00002T00_oe0000
:@000ol0003d0000:@000ol0003d0000:@000ol0003d0000:@02od001?na0000:@000ol0000n00Ko
/00002T000?o0000?@08ojl0000Y0003o`0003d02?n_0000:@02och02?n_0000:@000ol0000m00So
[`0002T000?o0000?P06ok00000E00;o1002o`<00ol60003o`0003l01?na000050001?l00?l300;o
1P000ol000030003o`000?@0000D0004o`00o`/000?o00000`03oo@0000D0004o`00o`P00ol60003
o`000?@0000D0004o`00o`P000?o00001P000ol0003d00005@02o`T01?l50003o`000?@0000Y00;o
m@0002T000?o0000m00002T000?o0000m00002T000?o0000m00002T000?o0000j@04o`L0000Y00;o
j@06o`H0000Y0003o`000>L02?l50000:@000ol0003W00So1@0002T000?o0000i`08o`D0000Y00;o
j008o`D0000Y0003o`000>P01_l60000:@000ol0003Y00Co1`0002T000?o0000m00002T00_oe0000
:@000ol0003d0000:@000ol0003d00003`02o`@00_l40003o`0000800ol60003o`000?@0000>0004
o`00o`<00_l40003o`0000D000?o00000`000ol0003d00003P001?l00?l:0003o`0000@000?o0000
0`03oo@0000>0004o`00o`X000Co00000ol60003o`000?@0000>0004o`00o`/000Co003o20000ol0
003d00003`02o`T01?l200Co1@000ol0003d0000:@02ooD0000Y0003o`000?@0000Y0003o`000?@0
000Y0003o`000?@0000Y0003o`000?@0000Y00;om@0002T000?o0000m00002T000?o0000m00002T0
00?o0000m00002T00_oe0000:@000ol0003d0000:@000ol0003d0000:@000ol0002300CoK@0002T0
00?o0000PP06of`0000Y00;oPP08of/0000500Co80000ol0002100SoJ`0000@01_lF00?o1P000ol0
002100SoJ`0000<02?lF0003o`0000D000?o0000P@08of/0000300So5P000ol0000500?oPP06of`0
000300So5P000ol000050003o`0008<01?m]00000`08oaH000?o00001@000ol0003d00001006oaH0
0_l70003o`000?@0000500Co80000ol0003d0000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {0.782532, -0.950264, 
  0.0293899, 0.0113101}}]
}, Closed]],

Cell[TextData[{
  StyleBox["Fourier", "Input"],
  " expects a list of values."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Fourier[vec3]\)], "Input"],

Cell[BoxData[
    \({\(0.316991248080723675`\[InvisibleSpace]\) + 0.151106604338209322`\ I, 
      \(0.329906194774448291`\[InvisibleSpace]\) + 0.0316889345652492115`\ I, 
      \(0.342934173722130619`\[InvisibleSpace]\) - 0.0887738845758725503`\ I, 
      \(0.360113551771476014`\[InvisibleSpace]\) - 0.247622491810036882`\ I, 
      \(0.392940169059660604`\[InvisibleSpace]\) - 0.551152830420623995`\ I, 
      \(0.546740700191440609`\[InvisibleSpace]\) - 1.97326485868979908`\ I, 
      \(0.140641330500092553`\[InvisibleSpace]\) + 1.78172086249582068`\ I, 
      \(0.269432989470029626`\[InvisibleSpace]\) + 0.590852625474219372`\ I, 
      \(0.300299642429998048`\[InvisibleSpace]\) + 0.305445038622834008`\ I}
      \)], "Output"]
}, Closed]],

Cell["\<\
We generate two-dimensional tables by including two iterators.\
\>",
   "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(rect = Table[i\/j, {i, 1, 5}, {j, 1, 2}]\)], "Input"],

Cell[BoxData[
    \({{1, 1\/2}, {2, 1}, {3, 3\/2}, {4, 2}, {5, 5\/2}}\)], "Output"]
}, Closed]],

Cell[TextData[{
  "It may be useful to use ",
  StyleBox["TableForm", "Input"],
  " to display lists of two or more dimensions."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(TableForm[rect]\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {"1", \(1\/2\)},
          {"2", "1"},
          {"3", \(3\/2\)},
          {"4", "2"},
          {"5", \(5\/2\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Closed]],

Cell[TextData[{
  "The options ",
  StyleBox["TableAlignments", "Input"],
  ", ",
  StyleBox["TableSpacing", "Input"],
  ", and ",
  StyleBox["TableHeadings", "Input"],
  " allow us to customize the appearance of a table."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(TableForm[rect, \n\tTableAlignments \[Rule] {Center, Center}, \n\t
      TableSpacing \[Rule] {1, 10}, 
      TableHeadings \[Rule] {None, {"\<Before\>", "\<After\>"}}]\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {\("Before"\), \("After"\)},
          {"1", \(1\/2\)},
          {"2", "1"},
          {"3", \(3\/2\)},
          {"4", "2"},
          {"5", \(5\/2\)}
          },
        RowSpacings->1,
        ColumnSpacings->10,
        RowAlignments->Center,
        ColumnAlignments->{Center}],
      (TableForm[
       #, TableAlignments -> {Center, Center}, TableSpacing -> {1, 10}, 
        TableHeadings -> {None, {"Before", "After"}}]&)]], "Output"]
}, Closed]],

Cell[TextData[{
  "How we interpret an array such as ",
  StyleBox["rect", "Input"],
  " depends on the context in which it arises. In some cases, it may be \
considered a 5 \[Times] 2 matrix, in others a list of five ordered pairs. \
Here we interpret ",
  StyleBox["rect", "Input"],
  " as a matrix, and matrix-multiply it by its transpose using ",
  StyleBox["Dot", "Input"],
  " (",
  StyleBox[".", "Input"],
  ")."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(rect.Transpose[rect] // MatrixForm\)], "Input"],

Cell[BoxData[
    TagBox[
      RowBox[{"(", GridBox[{
            {\(5\/4\), \(5\/2\), \(15\/4\), "5", \(25\/4\)},
            {\(5\/2\), "5", \(15\/2\), "10", \(25\/2\)},
            {\(15\/4\), \(15\/2\), \(45\/4\), "15", \(75\/4\)},
            {"5", "10", "15", "20", "25"},
            {\(25\/4\), \(25\/2\), \(75\/4\), "25", \(125\/4\)}
            }], ")"}],
      (MatrixForm[ #]&)]], "Output"]
}, Closed]],

Cell[TextData[{
  "Here we interpret ",
  StyleBox["rect", "Input"],
  " as a list of ordered pairs to be plotted."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(ListPlot[rect, PlotStyle \[Rule] PointSize[0.02]]; \)\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.214286 0.238095 -0.132436 0.294302 [
[.2619 .14937 -3 -9 ]
[.2619 .14937 3 0 ]
[.5 .14937 -3 -9 ]
[.5 .14937 3 0 ]
[.7381 .14937 -3 -9 ]
[.7381 .14937 3 0 ]
[.97619 .14937 -3 -9 ]
[.97619 .14937 3 0 ]
[.01131 .01472 -18 -4.5 ]
[.01131 .01472 0 4.5 ]
[.01131 .30902 -18 -4.5 ]
[.01131 .30902 0 4.5 ]
[.01131 .45617 -6 -4.5 ]
[.01131 .45617 0 4.5 ]
[.01131 .60332 -18 -4.5 ]
[.01131 .60332 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.2619 .16187 m
.2619 .16812 L
s
[(2)] .2619 .14937 0 1 Mshowa
.5 .16187 m
.5 .16812 L
s
[(3)] .5 .14937 0 1 Mshowa
.7381 .16187 m
.7381 .16812 L
s
[(4)] .7381 .14937 0 1 Mshowa
.97619 .16187 m
.97619 .16812 L
s
[(5)] .97619 .14937 0 1 Mshowa
.125 Mabswid
.07143 .16187 m
.07143 .16562 L
s
.11905 .16187 m
.11905 .16562 L
s
.16667 .16187 m
.16667 .16562 L
s
.21429 .16187 m
.21429 .16562 L
s
.30952 .16187 m
.30952 .16562 L
s
.35714 .16187 m
.35714 .16562 L
s
.40476 .16187 m
.40476 .16562 L
s
.45238 .16187 m
.45238 .16562 L
s
.54762 .16187 m
.54762 .16562 L
s
.59524 .16187 m
.59524 .16562 L
s
.64286 .16187 m
.64286 .16562 L
s
.69048 .16187 m
.69048 .16562 L
s
.78571 .16187 m
.78571 .16562 L
s
.83333 .16187 m
.83333 .16562 L
s
.88095 .16187 m
.88095 .16562 L
s
.92857 .16187 m
.92857 .16562 L
s
.25 Mabswid
0 .16187 m
1 .16187 L
s
.02381 .01472 m
.03006 .01472 L
s
[(0.5)] .01131 .01472 1 0 Mshowa
.02381 .30902 m
.03006 .30902 L
s
[(1.5)] .01131 .30902 1 0 Mshowa
.02381 .45617 m
.03006 .45617 L
s
[(2)] .01131 .45617 1 0 Mshowa
.02381 .60332 m
.03006 .60332 L
s
[(2.5)] .01131 .60332 1 0 Mshowa
.125 Mabswid
.02381 .04415 m
.02756 .04415 L
s
.02381 .07358 m
.02756 .07358 L
s
.02381 .10301 m
.02756 .10301 L
s
.02381 .13244 m
.02756 .13244 L
s
.02381 .1913 m
.02756 .1913 L
s
.02381 .22073 m
.02756 .22073 L
s
.02381 .25016 m
.02756 .25016 L
s
.02381 .27959 m
.02756 .27959 L
s
.02381 .33845 m
.02756 .33845 L
s
.02381 .36788 m
.02756 .36788 L
s
.02381 .39731 m
.02756 .39731 L
s
.02381 .42674 m
.02756 .42674 L
s
.02381 .4856 m
.02756 .4856 L
s
.02381 .51503 m
.02756 .51503 L
s
.02381 .54446 m
.02756 .54446 L
s
.02381 .57389 m
.02756 .57389 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.02 w
.02381 .01472 Mdot
.2619 .16187 Mdot
.5 .30902 Mdot
.7381 .45617 Mdot
.97619 .60332 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{35, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/@P10`4000010?ooobl_;oooZZVYZNSX
j?oo05FZZZZZZ_nZZS/k>gYjN[Vi^OShn03ooeGooj[ooonI<c<c<fi^KZf][Nc/k02ZoeFZojZZoonZ
oclo?ginO[fm_Oclo5D00:X00?l00?l0VCLg=g9bL[6a/O3`l03o05Go0:[o00<30d92@X61PL30`000
EED0EJX0EOl0ELbIoc/k>gIfM[Fe]OCdm03oEEGoEJ[oE@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0Z/`c
<clo?gYjN[Vi^OShn03oZUGoZZ[oZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`<30d92@WinO[fm_Ocl
o03ooeGooj[oo`l?3di>CXf=SLc<c01E05EE0:YE0?mE00L71dI6AX61PL30`000EED00:X00?l001<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@/;2dY:BXF5QLC4a000ZUD0EJX0EOl0EALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZPl?3di>CXV9RLS8b000oeD0ZZX0Z_l0ZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEoa<C
4e9BDXf=SLc<c01E05D0ojX0ool0oalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ01LG5eIFEY6ATM3@d01E
EEEE0:YE0?mE02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZEA/K6eYJFYFEUMCDe01EZUEEEJYEEOmEEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZQlO7eiNGYVIVMSHf01EoeEEZZYEZ_mEZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZob<S8f9RHYfMWMcLg02Z05EEojYEoomEobl_;fi^KZf][Nc/k03o05Go0:[o0=gW1RLW
9fIVIZ6QXN3Ph02ZEEFZ0:ZZ0?nZ03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooEB/[:fYZJZFUYNCTi02Z
ZUFZEJZZEOnZECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l08@000?l08@000?l08@000?l08@0001D0
00?o0000o`0900005@000ol0003o00T0000200;o1002o`<00ol400?oo`0:000000D0o`00o`0300;o
1P000ol00005ool02@0000050?l00?l02`000ol00005ool02@0000050?l00?l02003o`<01Ooo00T0
00001@3o003o00P000?o00001003ool02P0000800_l900Co10000ol0003o00T0000E0003o`000?l0
2@0001D000?o0000o`0900005@000ol0003o00T0000E0003o`000?l02@0001D00_oo00X0000E0003
o`000?l02@0001D000?o0000o`0900005@000ol0003o00T0000E0003o`000?l02@0001D000?o0000
o`0900005@000ol0003o00T0000E0003o`000?l02@0001D00_oo00X0000E0003o`000?l02@0001D0
00?o0000o`0900005@000ol0003o00T0000E0003o`000?l02@0001D000?o0000o`0900005@000ol0
003o00T0000E0003o`000?l02@0001D00_oo00X0000E0003o`000?l02@0001D000?o0000o`090000
5@000ol0003o00T0000E0003o`000?l02@0001D000?o0000o`0900005@000ol0000l00Co?003ocl0
0olm00?o1`0001D000?o0000?@000ol0000o0003o`0003d000?o0000?`000ol0000400005@02ocl0
00?o0000?P000ol0000k00Co@0000ol0000400005@000ol0000o0003o`0003/00_ln0003o`3o03h0
0ol700005@000ol0000l0004o`00ocl000?o0000>`000ol0o`0n0003o`0000L0000E0003o`0003d0
0_lm00?o?`02och01?l600005@000ol0003o00T0000E0003o`000?l02@0001D000?o0000?003olT0
000E0003o`0003/01Oo800003P3ooa?o000E0003o`0000X000?o00002P000ol0000:0003o`0000X0
00?o00001`05o`/000?o00002P000ol0000:0003o`0000X000?o00002@000ol0000:0003o`0000X0
00?o00002P000ol0000:0003o`0000X000?o00002P000ol0000:0003o`0000X000?o00002P000ol0
000:0003o`0000D0000E0003o`0003`00olo0003o`0003h000?o0000?P000ol0000500005@000ol0
003o00T0000E0003o`000?l02@0001D000?o0000o`0900005@000ol0003o00T0000E0003o`000?l0
2@0001D00_oo00X0000E0003o`000?l02@0001D000?o0000o`0900005@000ol0003o00T0000E0003
o`000?l02@0001D000?o0000o`0900005@000ol0003o00T0000E0003o`000?l02@0001D00_oo00X0
000E0003o`000?l02@0001D000?o0000o`0900005@000ol0003o00T0000E0003o`000?l02@0001D0
00?o0000o`0900005@000ol0003o00T0000E0003o`000?l02@0001D00_oo00X0000E0003o`000?l0
2@0001D000?o0000o`0900005@000ol0003o00T0000E0003o`000?l02@0001D000?o0000o`090000
5@000ol0003o00T0000E0003o`000?l02@0001D00_oo00X0000E0003o`000?l02@0001D000?o0000
o`0900005@000ol0003o00T0000E0003o`000?l02@0001D000?o0000o`09000000@0oooo1002o`<0
0ol50003o`0007d00on800000P000ol0000300;o1P000ol000020003o`0007`01On700000P000ol0
000;0003o`0000800oml00GoQ`00008000?o00002003o`D000?o0000O005ohL000020003o`0000P0
00?o00001@000ol0001m00?oR00000030?oo00X01?l40003o`000?l02@0001D000?o0000o`090000
5@000ol0003o00T0000E0003o`000?l02@0001D000?o0000o`0900005@02ool02P0001D000?o0000
o`0900005@000ol0003o00T0000E0003o`000?l02@0001D000?o0000o`0900005@000ol0003o00T0
000E0003o`000?l02@0001D000?o0000o`0900005@02ool02P0001D000?o0000o`0900005@000ol0
003o00T0000E0003o`000?l02@0001D000?o0000o`0900005@000ol0003o00T0000E0003o`000?l0
2@0001D000?o0000o`0900005@02ool02P0001D000?o0000o`0900005@000ol0003o00T0000E0003
o`000?l02@0001D000?o0000o`0900005@000ol0003o00T0000E0003o`000?l02@0001D000?o0000
o`0900005@02ool02P0001D000?o0000o`0900005@000ol0003o00T0000E0003o`000?l02@0001D0
00?o0000o`0900005@000ol0003o00T0000=00Co10000ol0002n00?oA`0000h000?o000010000ol0
002m00GoAP0000l000?o00000`03okd01Om6000040000ol000020003o`000;d01Om600003@001?l0
0?l40003o`000;h00om700003P02o`D000?o0000o`0900005@000ol0003o00T0000E0003o`000?l0
2@0001D000?o0000o`0900005@000ol0003o00T0000E00;oo`0:00005@000ol0003o00T0000E0003
o`000?l02@0001D000?o0000o`0900005@000ol0003o00T0000E0003o`000?l02@0001D000?o0000
o`0900005@000ol0003o00T0000E00;oo`0:00005@000ol0003o00T0000E0003o`000?l02@0001D0
00?o0000o`0900005@000ol0003o00T0000E0003o`000?l02@0001D000?o0000o`0900005@000ol0
003o00T0000E00;oo`0:00005@000ol0003o00T0000E0003o`000?l02@0001D000?o0000o`090000
5@000ol0003o00T0000E0003o`000?l02@0001D000?o0000o`0900005@000ol0003o00T0000E00;o
o`0:00005@000ol0003o00T0000E0003o`000?l02@0001D000?o0000o`0900005@000ol0003o00T0
000E0003o`000?l02@0000030?oo00;o0`02o`<00ol50003o`000?l00ol600000P000ol0000300;o
1P000ol000020003o`000?h01Ol500000`000ol0000:0003o`0000800oon00Go1@0000@000?o0000
1P03o`D000?o0000oP05o`D000001@3o003o00P000?o00001@000ol0003o00?o1P0000800_l900Co
10000ol0003o00T0000E0003o`000?l02@000?l08@000?l08@000?l08@000?l08@000001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {0.669618, 0.395146, 0.015437,
   0.0124888}}]
}, Closed]],

Cell[TextData[{
  "The first argument to ",
  StyleBox["Table", "Input"],
  " can be a conditional statement such as ",
  StyleBox["If", "Input"],
  " or ",
  StyleBox["Which", "Input"],
  ". An element of the following matrix is 1 if its indices ",
  StyleBox["i",
    FontSlant->"Italic"],
  " and ",
  StyleBox["j",
    FontSlant->"Italic"],
  " satisfy ",
  Cell[BoxData[
      \(TraditionalForm
      \`\[LeftBracketingBar]i - j\[RightBracketingBar] \[LessEqual] 2\)]],
  ", and is otherwise 0."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(TableForm[Table[If[Abs[i - j] \[LessEqual] 2, 1, 0], {i, 7}, {j, 7}]]
      \)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {"1", "1", "1", "0", "0", "0", "0"},
          {"1", "1", "1", "1", "0", "0", "0"},
          {"1", "1", "1", "1", "1", "0", "0"},
          {"0", "1", "1", "1", "1", "1", "0"},
          {"0", "0", "1", "1", "1", "1", "1"},
          {"0", "0", "0", "1", "1", "1", "1"},
          {"0", "0", "0", "0", "1", "1", "1"}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Closed]],

Cell[TextData[{
  "There is no need for ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " arrays to be rectangular. Here the upper limit of the inner loop ",
  StyleBox["j", "Input"],
  " depends on the value of the outer loop ",
  StyleBox["i", "Input"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(trimat = Table[i + j, {i, 1, 4}, {j, 1, i}]\)], "Input"],

Cell[BoxData[
    \({{2}, {3, 4}, {4, 5, 6}, {5, 6, 7, 8}}\)], "Output"]
}, Closed]],

Cell["The result is a triangular array.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(TableForm[trimat]\)], "Input"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {"2", "\(\"\"\)", "\(\"\"\)", "\(\"\"\)"},
          {"3", "4", "\(\"\"\)", "\(\"\"\)"},
          {"4", "5", "6", "\(\"\"\)"},
          {"5", "6", "7", "8"}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      TableForm[ {{2}, {3, 4}, {4, 5, 6}, {5, 6, 7, 8}}]]], "Output"]
}, Closed]],

Cell[TextData[{
  "There is no limit to the number of dimensions that can be contained in a ",
  
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " list. Here we generate a four-dimensional tensor (alternatively, a list \
of lists of lists of lists, or a matrix of matrices) by including four \
iterators in the ",
  StyleBox["Table", "Input"],
  " command."
}], "Text"],

Cell[BoxData[
    \(\(tensor = Table[i + j + k - l, {i, 2}, {j, 3}, {k, 4}, {l, 5}]; \)\)], 
  "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(TableForm[tensor]\)], "Input"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {GridBox[{
                {"2", "1", "0", "\(-1\)", "\(-2\)"},
                {"3", "2", "1", "0", "\(-1\)"},
                {"4", "3", "2", "1", "0"},
                {"5", "4", "3", "2", "1"}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], GridBox[{
                {"3", "2", "1", "0", "\(-1\)"},
                {"4", "3", "2", "1", "0"},
                {"5", "4", "3", "2", "1"},
                {"6", "5", "4", "3", "2"}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], GridBox[{
                {"4", "3", "2", "1", "0"},
                {"5", "4", "3", "2", "1"},
                {"6", "5", "4", "3", "2"},
                {"7", "6", "5", "4", "3"}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}]},
          {GridBox[{
                {"3", "2", "1", "0", "\(-1\)"},
                {"4", "3", "2", "1", "0"},
                {"5", "4", "3", "2", "1"},
                {"6", "5", "4", "3", "2"}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], GridBox[{
                {"4", "3", "2", "1", "0"},
                {"5", "4", "3", "2", "1"},
                {"6", "5", "4", "3", "2"},
                {"7", "6", "5", "4", "3"}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], GridBox[{
                {"5", "4", "3", "2", "1"},
                {"6", "5", "4", "3", "2"},
                {"7", "6", "5", "4", "3"},
                {"8", "7", "6", "5", "4"}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}]}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      TableForm[
       {{{{2, 1, 0, -1, -2}, {3, 2, 1, 0, -1}, {4, 3, 2, 1, 0}, {5, 4, 3, 2, 
        1}}, {{3, 2, 1, 0, -1}, {4, 3, 2, 1, 0}, {5, 4, 3, 2, 1}, {6, 5, 4, 3,
         2}}, {{4, 3, 2, 1, 0}, {5, 4, 3, 2, 1}, {6, 5, 4, 3, 2}, {7, 6, 5, 4,
         3}}}, {{{3, 2, 1, 0, -1}, {4, 3, 2, 1, 0}, {5, 4, 3, 2, 1}, {6, 5, 4,
         3, 2}}, {{4, 3, 2, 1, 0}, {5, 4, 3, 2, 1}, {6, 5, 4, 3, 2}, {7, 6, 5,
         4, 3}}, {{5, 4, 3, 2, 1}, {6, 5, 4, 3, 2}, {7, 6, 5, 4, 3}, {8, 7, 6,
         5, 4}}}}]]], "Output"]
}, Closed]],

Cell[TextData[{
  "It is important to make a distinction between list operations and matrix \
operations, particularly with respect to matrix multiplication. The function \
",
  StyleBox["Dot", "Input"],
  " (which we enter as a period ",
  StyleBox[".", "Input"],
  ") is used for matrix and vector multiplication. Here is the product of a \
matrix and a vector."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \({{a, b}, {c, d}}.{x, y}\)], "Input"],

Cell[BoxData[
    \({a\ x + b\ y, c\ x + d\ y}\)], "Output"]
}, Closed]],

Cell[TextData[{
  "There is no difference in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " between a row vector and a column vector, as matrix and vector functions \
automatically interpret vectors in the appropriate way. Here we multiply a \
matrix by a vector on both the left- and right-hand sides. Notice that the \
vector is typed the same way in each case."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \({x, y}.{{a, b}, {c, d}}.{x, y} // Simplify\)], "Input"],

Cell[BoxData[
    \(a\ x\^2 + y\ \((b\ x + c\ x + d\ y)\)\)], "Output"]
}, Closed]],

Cell["Here is the matrix product of two matrices.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \({{1, 2}, {3, 4}}.{{a, b}, {c, d}} // MatrixForm\)], "Input"],

Cell[BoxData[
    TagBox[
      RowBox[{"(", GridBox[{
            {"\(a + 2\\ c\)", "\(b + 2\\ d\)"},
            {"\(3\\ a + 4\\ c\)", "\(3\\ b + 4\\ d\)"}
            }], ")"}],
      (MatrixForm[ #]&)]], "Output"]
}, Closed]],

Cell[TextData[{
  "Here we use ordinary multiplication ",
  StyleBox["*", "Input"],
  ", and ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " performs termwise multiplication."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \({{1, 2}, {3, 4}}*{{a, b}, {c, d}} // MatrixForm\)], "Input"],

Cell[BoxData[
    TagBox[
      RowBox[{"(", GridBox[{
            {"a", "\(2\\ b\)"},
            {"\(3\\ c\)", "\(4\\ d\)"}
            }], ")"}],
      (MatrixForm[ #]&)]], "Output"]
}, Closed]],

Cell[TextData[{
  "As a general rule, if two lists have the same shape, ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " will perform termwise arithmetic, and return a list with the same shape. \
For instance, the difference of two vectors of equal length returns a vector \
of the differences of the elements."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \({1, 2, 3} - {a, b, c}\)], "Input"],

Cell[BoxData[
    \({1 - a, 2 - b, 3 - c}\)], "Output"]
}, Closed]],

Cell[TextData[{
  "Notice also that ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " will combine all elements of a list with a single expression. If we add a \
constant to a vector, ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " returns a vector where the constant has been added to each element."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \({a, b, c} + 2\)], "Input"],

Cell[BoxData[
    \({2 + a, 2 + b, 2 + c}\)], "Output"]
}, Closed]],

Cell["\<\
Similarly, multiplying or adding a single expression (a scalar) to \
a matrix results in the expression being multiplied or added to each element \
of the matrix.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \({{1, 2}, {3, 4}} \[ScriptCapitalC] // \ MatrixForm\)], "Input"],

Cell[BoxData[
    TagBox[
      RowBox[{"(", GridBox[{
            {"\[ScriptCapitalC]", \(2\ \[ScriptCapitalC]\)},
            {\(3\ \[ScriptCapitalC]\), \(4\ \[ScriptCapitalC]\)}
            }], ")"}],
      (MatrixForm[ #]&)]], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \({{1, 2}, {3, 4}}\  + \[ScriptK] // \ MatrixForm\)], "Input"],

Cell[BoxData[
    TagBox[
      RowBox[{"(", GridBox[{
            {\(1 + \[ScriptK]\), \(2 + \[ScriptK]\)},
            {\(3 + \[ScriptK]\), \(4 + \[ScriptK]\)}
            }], ")"}],
      (MatrixForm[ #]&)]], "Output"]
}, Closed]],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " produces a warning if two lists cannot be combined because they have \
different lengths."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \({1, 2, 3} + {a, b, c, d}\)], "Input"],

Cell[BoxData[
    \(Thread::"tdlen"\(:\ 
      \)"Objects of unequal length in \!\(\({1, 2, 3}\) + \({a, b, c, d}\)\) \
cannot be combined."\)], "Message"],

Cell[BoxData[
    \({1, 2, 3} + {a, b, c, d}\)], "Output"]
}, Closed]],

Cell[TextData[{
  "See also ",
  StyleBox["Cross", "Input"],
  ", ",
  StyleBox["Permutations", "Input"],
  ", ",
  StyleBox["ReadList", "Input"],
  ", ",
  StyleBox["Read", "Input"],
  ", ",
  StyleBox["RecordLists", "Input"],
  ", ",
  StyleBox["OpenRead", "Input"],
  ", ",
  StyleBox["Close", "Input"],
  StyleBox[", ", "Text"],
  StyleBox["Calculus`VectorAnalysis", "Input"],
  ", ",
  StyleBox["Thread", "Input"]
}], "SeeAlso"]
}, Closed]],

Cell[CellGroupData[{

Cell["Exercises: Creating and Interpreting Lists", "Subsection",
  PageBreakAbove->True],

Cell[TextData[{
  "Create a list of the first ten prime numbers. (",
  StyleBox["Prime[", "Input"],
  StyleBox["n",
    FontSlant->"Italic"],
  StyleBox["]", "Input"],
  " returns the ",
  Cell[BoxData[
      \(TraditionalForm\`n\^th\)]],
  " prime number.)"
}], "Question"],

Cell[TextData[{
  "We use ",
  StyleBox["Table",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " to generate a list of the ",
  Cell[BoxData[
      \(TraditionalForm\`k\^th\)]],
  " prime numbers as ",
  StyleBox["k",
    FontSlant->"Italic"],
  " goes from 1 to 10. When we omit a starting value for the iterator ",
  StyleBox["k",
    FontSlant->"Italic"],
  ", it is assumed to be 1."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Table[Prime[k], {k, 10}]\)], "Input"],

Cell[BoxData[
    \({2, 3, 5, 7, 11, 13, 17, 19, 23, 29}\)], "Output"]
}, Closed]],

Cell[TextData[{
  "Alternatively, we can avoid using the ",
  StyleBox["Table",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " command by recognizing that the mathematical function ",
  StyleBox["Prime",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " automatically maps itself over lists."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Prime[Range[10]]\)], "Input"],

Cell[BoxData[
    \({2, 3, 5, 7, 11, 13, 17, 19, 23, 29}\)], "Output"]
}, Closed]],

Cell[TextData[{
  "Define a function called ",
  StyleBox["zeroVector", "Input"],
  " that creates a vector containing ",
  StyleBox["n",
    FontSlant->"Italic"],
  " zeros, where ",
  StyleBox["n",
    FontSlant->"Italic"],
  " is an argument to ",
  StyleBox["zeroVector", "Input"],
  "."
}], "Question"],

Cell[TextData[{
  "Here is one definition using ",
  StyleBox["Table", "Input"],
  ". We can omit the name of the iterator if it does not occur in the \
expression given to ",
  StyleBox["Table", "Input"],
  "."
}], "Text"],

Cell[BoxData[
    \(zeroVector[n_Integer?Positive] := Table[0, {n}]\)], "Input"],

Cell["Here is a vector of ten zeros.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(zeroVector[10]\)], "Input"],

Cell[BoxData[
    \({0, 0, 0, 0, 0, 0, 0, 0, 0, 0}\)], "Output"]
}, Closed]],

Cell[TextData[{
  "We can define a ",
  StyleBox["zeroMatrix", "Input"],
  " function in a similar way."
}], "Text"],

Cell[BoxData[
    \(zeroMatrix[m_, n_] := Table[0, {m}, {n}]\)], "Input"],

Cell["Here is a 3 \[Times] 5 matrix of zeros.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(zeroMatrix[3, 5] // MatrixForm\)], "Input"],

Cell[BoxData[
    TagBox[
      RowBox[{"(", GridBox[{
            {"0", "0", "0", "0", "0"},
            {"0", "0", "0", "0", "0"},
            {"0", "0", "0", "0", "0"}
            }], ")"}],
      (MatrixForm[ #]&)]], "Output"]
}, Closed]],

Cell["\<\
Generate a 5 \[Times] 5 matrix, in which each element is the row \
number plus the column number, or the number 5, whichever is greater.\
\>", 
  "Question"],

Cell[TextData[{
  "We use ",
  StyleBox["Max", "Input"],
  " to determine if 5 or ",
  Cell[BoxData[
      \(TraditionalForm\`i + j\)]],
  " (the row number plus the column number) is greater."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Table[Max[{5, i + j}], {i, 5}, {j, 5}] // MatrixForm\)], "Input"],

Cell[BoxData[
    TagBox[
      RowBox[{"(", GridBox[{
            {"5", "5", "5", "5", "6"},
            {"5", "5", "5", "6", "7"},
            {"5", "5", "6", "7", "8"},
            {"5", "6", "7", "8", "9"},
            {"6", "7", "8", "9", "10"}
            }], ")"}],
      (MatrixForm[ #]&)]], "Output"]
}, Closed]],

Cell[TextData[{
  "Beginning with the matrix ",
  StyleBox["{{a,",
    FontFamily->"Courier"],
  StyleBox[" ",
    FontWeight->"Plain"],
  StyleBox["b},",
    FontFamily->"Courier"],
  StyleBox[" ",
    FontWeight->"Plain"],
  StyleBox["{c,",
    FontFamily->"Courier"],
  StyleBox[" ",
    FontWeight->"Plain"],
  StyleBox["d}}",
    FontFamily->"Courier"],
  " and the vector ",
  StyleBox["{x,",
    FontFamily->"Courier"],
  StyleBox[" ",
    FontWeight->"Plain"],
  StyleBox["y}",
    FontFamily->"Courier"],
  ", create the vector ",
  StyleBox["{a",
    FontFamily->"Courier"],
  StyleBox[" ",
    FontWeight->"Plain"],
  StyleBox["x",
    FontFamily->"Courier"],
  StyleBox[" ",
    FontWeight->"Plain"],
  StyleBox["+",
    FontFamily->"Courier"],
  StyleBox[" ",
    FontWeight->"Plain"],
  StyleBox["b",
    FontFamily->"Courier"],
  StyleBox[" ",
    FontWeight->"Plain"],
  StyleBox["y, c",
    FontFamily->"Courier"],
  StyleBox[" ",
    FontWeight->"Plain"],
  StyleBox["x",
    FontFamily->"Courier"],
  StyleBox[" ",
    FontWeight->"Plain"],
  StyleBox["+",
    FontFamily->"Courier"],
  StyleBox[" ",
    FontWeight->"Plain"],
  StyleBox["d",
    FontFamily->"Courier"],
  StyleBox[" ",
    FontWeight->"Plain"],
  StyleBox["y}",
    FontFamily->"Courier"],
  ". Beginning with the same matrix and vector, create the matrix ",
  StyleBox["{{a",
    FontFamily->"Courier"],
  StyleBox[" ",
    FontWeight->"Plain"],
  StyleBox["x,",
    FontFamily->"Courier"],
  StyleBox[" ",
    FontWeight->"Plain"],
  StyleBox["b",
    FontFamily->"Courier"],
  StyleBox[" ",
    FontWeight->"Plain"],
  StyleBox["x},",
    FontFamily->"Courier"],
  StyleBox[" ",
    FontWeight->"Plain"],
  StyleBox["{c",
    FontFamily->"Courier"],
  StyleBox[" ",
    FontWeight->"Plain"],
  StyleBox["y,",
    FontFamily->"Courier"],
  StyleBox[" ",
    FontWeight->"Plain"],
  StyleBox["d",
    FontFamily->"Courier"],
  StyleBox[" ",
    FontWeight->"Plain"],
  StyleBox["y}}",
    FontFamily->"Courier"],
  "."
}], "Question"],

Cell["\<\
This exercise illustrates the difference between list and matrix \
operations. Here are definitions of the matrix and vector.\
\>", "Text"],

Cell[BoxData[{
    \(\(exermat = {{a, b}, {c, d}}; \)\), 
    \(\(exervec = {x, y}; \)\)}], "Input"],

Cell[TextData[{
  "For matrix-vector multiplication we use ",
  StyleBox["Dot",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(exermat.exervec\)], "Input"],

Cell[BoxData[
    \({a\ x + b\ y, c\ x + d\ y}\)], "Output"]
}, Closed]],

Cell[TextData[{
  "To perform termwise multiplication we use ",
  StyleBox["Times",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(exermat*exervec // MatrixForm\)], "Input"],

Cell[BoxData[
    TagBox[
      RowBox[{"(", GridBox[{
            {\(a\ x\), \(b\ x\)},
            {\(c\ y\), \(d\ y\)}
            }], ")"}],
      (MatrixForm[ #]&)]], "Output"]
}, Closed]],

Cell["\<\
Compute the eigenvectors of a numeric approximation to the matrix\
\
\>", "Question"],

Cell[BoxData[
    FormBox[
      RowBox[{"(", GridBox[{
            {"1", "2", "3"},
            {"3", "2", "2"},
            {"7", "1", "2"}
            }], ")"}], TraditionalForm]], "Output",
  TextAlignment->Left,
  TextJustification->0],

Cell["\<\
and see if they are normalized (that is, see if each eigenvector \
has unit length).\
\>", "Text",
  FontWeight->"Bold"],

Cell["Here are the eigenvectors of the approximate matrix.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      RowBox[{"evecs", "=", 
        RowBox[{"Eigenvectors", "[", 
          RowBox[{"N", "[", 
            RowBox[{"(", GridBox[{
                  {"1", "2", "3"},
                  {"3", "2", "2"},
                  {"7", "1", "2"}
                  }], ")"}], "]"}], "]"}]}], ";", \(TableForm[evecs]\)}]], 
  "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {"0.483239084229278859`", "0.517864430334557823`", 
            "0.705901139868403681`"},
          {"0.596049601707503207`", \(-0.0356482181341619686`\), 
            \(-0.80215589310818256`\)},
          {"0.0106728369565719227`", \(-0.832607703968846912`\), 
            "0.55376032888156903`"}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Closed]],

Cell["The following function determines the length of a vector.", "Text"],

Cell[BoxData[
    \(veclength[z_] := \@\(z.z\)\)], "Input"],

Cell[TextData[{
  "Here we use ",
  StyleBox["Table", "Input"],
  " to test if each eigenvector has unit length."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Table[veclength[evecs[\([i]\)]], {i, 3}]\)], "Input"],

Cell[BoxData[
    \({0.999999999999999822`, 1.`, 1.`}\)], "Output"]
}, Closed]],

Cell[TextData[{
  "Alternatively, we use the high-level programming function ",
  StyleBox["Map", "Input"],
  " to map ",
  StyleBox["veclength", "Input"],
  " over each vector in ",
  StyleBox["evecs", "Input"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Map[veclength, evecs]\)], "Input"],

Cell[BoxData[
    \({0.999999999999999822`, 1.`, 1.`}\)], "Output"]
}, Closed]],

Cell[" ", "EndExercises"]
}, Closed]],

Cell[CellGroupData[{

Cell["Extracting Parts of Lists", "Subsection"],

Cell[TextData[{
  "Given a one-dimensional list, we extract elements according to their \
position by using ",
  StyleBox["Part", "Input"],
  ". In ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " the first element of a list is at position 1, not 0. (Part 0 of a list is \
the head ",
  StyleBox["List", "Input"],
  ".)"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Part[{a, b, c}, 1]\)], "Input"],

Cell[BoxData[
    \(a\)], "Output"]
}, Closed]],

Cell[TextData[{
  "A compact, equivalent way to express the same command is to enclosed the \
desired position between double brackets ",
  StyleBox["[[", "Input"],
  " and ",
  StyleBox["]]", "Input"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \({a, b, c}[\([1]\)]\)], "Input"],

Cell[BoxData[
    \(a\)], "Output"]
}, Closed]],

Cell["\<\
In a multidimensional array, an element of a list can be another \
list. For example, here is a table of hurricane names, wind speeds (in \
knots), and pressures (in millibars),where each triple is collected in a \
sublist.\
\>", "Text"],

Cell["\<\
hurr =
\t{{\"Allison\",   65,  987},
\t {\"Barry\",     50,  995},
\t {\"Chantal\",   60,  992},
\t {\"Dean\",      40,  999},
\t {\"Erin\",      75,  975},
\t {\"Felix\",    115,  950},
\t {\"Gabrielle\", 60,  998},
\t {\"Humberto\",  90,  970},
\t {\"Iris\",      75,  970},
\t {\"Jerry\",     35, 1003}};\
\>", "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(TableForm[hurr, TableSpacing \[Rule] {0, 3}]\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {"\(\"Allison\"\)", "65", "987"},
          {"\(\"Barry\"\)", "50", "995"},
          {"\(\"Chantal\"\)", "60", "992"},
          {"\(\"Dean\"\)", "40", "999"},
          {"\(\"Erin\"\)", "75", "975"},
          {"\(\"Felix\"\)", "115", "950"},
          {"\(\"Gabrielle\"\)", "60", "998"},
          {"\(\"Humberto\"\)", "90", "970"},
          {"\(\"Iris\"\)", "75", "970"},
          {"\(\"Jerry\"\)", "35", "1003"}
          },
        RowSpacings->0,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #, TableSpacing -> {0, 3}]&)]], "Output"]
}, Closed]],

Cell[TextData[{
  "To extract an entire sublist, we specify its position using ",
  StyleBox["Part", "Input"],
  " (or the part-specification brackets ",
  StyleBox["[[", "Input"],
  "\[NonBreakingSpace]",
  StyleBox["]]", "Input"],
  ")."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Part[hurr, 2]\)], "Input"],

Cell[BoxData[
    \({"Barry", 50, 995}\)], "Output"]
}, Closed]],

Cell[TextData[
"To extract a single element of a two-dimensional list, we refer to its \
coordinate, its row and column. For instance, to extract the wind speed of \
hurricane Erin, we first select Erin\[CloseCurlyQuote]s whole record, which \
is at position 5, and then select the second part of the record."], "Text"],

Cell[CellGroupData[{

Cell["Part[hurr, 5, 2]", "Input"],

Cell[BoxData[
    \(75\)], "Output"]
}, Closed]],

Cell["Here are two more ways to enter the same expression.", "Text"],

Cell[CellGroupData[{

Cell["{hurr[[5, 2]], hurr[[5]][[2]]}", "Input"],

Cell[BoxData[
    \({75, 75}\)], "Output"]
}, Closed]],

Cell[TextData[
"Similarly, we extract the pressure of the storm Gabrielle by extracting the \
sublist at position 7, then extracting the third part of Gabrielle\
\[CloseCurlyQuote]s record."], "Text"],

Cell[CellGroupData[{

Cell["hurr[[7, 3]]", "Input"],

Cell[OutputFormData["\<\
998\
\>", "\<\
998\
\>"], "Output"]
}, Closed]],

Cell["\<\
To extract elements from deeply nested lists, it may be necessary \
to specify many coordinates.\
\>", "Text"],

Cell[TextData[{
  "In general, specifying one position in an ",
  StyleBox["n",
    FontSlant->"Italic"],
  "-dimensional (\[OpenCurlyDoubleQuote]rectangular\[CloseCurlyDoubleQuote]) \
list results in a list with ",
  Cell[BoxData[
      \(TraditionalForm\`n - 1\)]],
  " dimensions. Extracting the first element of the 4-dimensional list called \
",
  StyleBox["tensor", "Input"],
  " results in a 3-dimensional list."
}], "Text"],

Cell[CellGroupData[{

Cell["tensor[[1]] // TableForm", "Input"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {GridBox[{
                {"2"},
                {"1"},
                {"0"},
                {"\(-1\)"},
                {"\(-2\)"}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], GridBox[{
                {"3"},
                {"2"},
                {"1"},
                {"0"},
                {"\(-1\)"}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], GridBox[{
                {"4"},
                {"3"},
                {"2"},
                {"1"},
                {"0"}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], GridBox[{
                {"5"},
                {"4"},
                {"3"},
                {"2"},
                {"1"}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}]},
          {GridBox[{
                {"3"},
                {"2"},
                {"1"},
                {"0"},
                {"\(-1\)"}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], GridBox[{
                {"4"},
                {"3"},
                {"2"},
                {"1"},
                {"0"}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], GridBox[{
                {"5"},
                {"4"},
                {"3"},
                {"2"},
                {"1"}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], GridBox[{
                {"6"},
                {"5"},
                {"4"},
                {"3"},
                {"2"}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}]},
          {GridBox[{
                {"4"},
                {"3"},
                {"2"},
                {"1"},
                {"0"}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], GridBox[{
                {"5"},
                {"4"},
                {"3"},
                {"2"},
                {"1"}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], GridBox[{
                {"6"},
                {"5"},
                {"4"},
                {"3"},
                {"2"}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], GridBox[{
                {"7"},
                {"6"},
                {"5"},
                {"4"},
                {"3"}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}]}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      TableForm[
       {{{2, 1, 0, -1, -2}, {3, 2, 1, 0, -1}, {4, 3, 2, 1, 0}, {5, 4, 3, 2, 
        1}}, {{3, 2, 1, 0, -1}, {4, 3, 2, 1, 0}, {5, 4, 3, 2, 1}, {6, 5, 4, 3,
         2}}, {{4, 3, 2, 1, 0}, {5, 4, 3, 2, 1}, {6, 5, 4, 3, 2}, {7, 6, 5, 4,
         3}}}]]], "Output"]
}, Closed]],

Cell[TextData[{
  "Similarly, extracting an expression specified by two coordinates from an ",
  
  StyleBox["n",
    FontSlant->"Italic"],
  "-dimensional list returns a list with ",
  Cell[BoxData[
      \(TraditionalForm\`n - 2\)]],
  " dimensions. Part ",
  Cell[BoxData[
      \(TraditionalForm\`\((1, 1)\)\)]],
  " of ",
  StyleBox["tensor", "Input"],
  " is a two-dimensional matrix."
}], "Text"],

Cell[CellGroupData[{

Cell["tensor[[1,1]] // MatrixForm", "Input"],

Cell[BoxData[
    TagBox[
      RowBox[{"(", GridBox[{
            {"2", "1", "0", "\(-1\)", "\(-2\)"},
            {"3", "2", "1", "0", "\(-1\)"},
            {"4", "3", "2", "1", "0"},
            {"5", "4", "3", "2", "1"}
            }], ")"}],
      (MatrixForm[ #]&)]], "Output"]
}, Closed]],

Cell[TextData[{
  "Specifying a part of ",
  StyleBox["tensor", "Input"],
  " with three coordinates returns a vector."
}], "Text"],

Cell[CellGroupData[{

Cell["tensor[[1,1,1]]", "Input"],

Cell[BoxData[
    \({2, 1, 0, \(-1\), \(-2\)}\)], "Output"]
}, Closed]],

Cell[TextData[{
  "To extract an atomic element from ",
  StyleBox["tensor", "Input"],
  ", we specify four coordinates."
}], "Text"],

Cell[CellGroupData[{

Cell["tensor[[1,1,1,1]]", "Input"],

Cell[BoxData[
    \(2\)], "Output"]
}, Closed]],

Cell[TextData[{
  "It is important to be aware that there is a difference between the part \
specification ",
  StyleBox["hurr[[1,2]]", "Input"],
  " and ",
  Cell["hurr[[{1,2}]]", "Input"],
  " (the latter has curly brackets inside the double square brackets). The \
former returns the element at position ",
  Cell[BoxData[
      \(TraditionalForm\`\((1, 2)\)\)]],
  " of the list ",
  StyleBox["hurr", "Input"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell["hurr[[1,2]]", "Input"],

Cell[OutputFormData["\<\
65\
\>", "\<\
65\
\>"], "Output"]
}, Closed]],

Cell[TextData[{
  "The latter is equivalent to ",
  StyleBox["{hurr[[1]], hurr[[2]]}", "Input"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell["hurr[[{1,2}]]", "Input"],

Cell[OutputFormData["\<\
{{\"Allison\", 65, 987}, {\"Barry\", 50, 995}}\
\>", 
"\<\
{{Allison, 65, 987}, {Barry, 50, 995}}\
\>"], "Output"]
}, Closed]],

Cell[TextData[{
  "Note that ",
  StyleBox["[[{ }]]", "Input"],
  " notation provides a quick way to manipulate the elements of a list. Here \
is an example of using this notation to rearrange the elements of a list."
}], "Text"],

Cell[BoxData[
    \(\(plist = {a, b, c, d, e, f}; \)\)], "Input"],

Cell[CellGroupData[{

Cell["plist[[{1, 4, 2, 5, 3, 6}]]", "Input"],

Cell[OutputFormData["\<\
{a, d, b, e, c, f}\
\>", 
"\<\
{a, d, b, e, c, f}\
\>"], "Output"]
}, Closed]],

Cell[TextData[{
  "Using ",
  StyleBox["Table", "Input"],
  " and ",
  StyleBox["Part", "Input"],
  ", we can define a function called ",
  StyleBox["sampleWithReplacement", "Input"],
  " that takes a sample of a given size from a list of data."
}], "Text"],

Cell[BoxData[
    \(sampleWithReplacement[L_List, n_Integer?Positive] := 
      Module[{\[ScriptL] = Length[L]}, 
        Table[L[\([Random[Integer, {1, \[ScriptL]}]]\)], {n}]]\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(sampleWithReplacement[{a, b, c, d, e}, 10]\)], "Input"],

Cell[BoxData[
    \({c, d, b, e, e, a, b, a, b, c}\)], "Output"]
}, Closed]],

Cell[TextData[{
  "We can extract a range of elements using ",
  StyleBox["Take", "Input"],
  ". Here we extract the first five elements of a list."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Take[{a, b, c, d, e, f, g}, 5]\)], "Input"],

Cell[OutputFormData["\<\
{a, b, c, d, e}\
\>", 
"\<\
{a, b, c, d, e}\
\>"], "Output"]
}, Closed]],

Cell["Here we extract the last five elements.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Take[{a, b, c, d, e, f, g}, \(-5\)]\)], "Input"],

Cell[OutputFormData["\<\
{c, d, e, f, g}\
\>", 
"\<\
{c, d, e, f, g}\
\>"], "Output"]
}, Closed]],

Cell["\<\
We can extract a sublist from the middle of the list, as well. Here \
we extract the third through sixth elements of a list.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Take[{a, b, c, d, e, f, g}, {3, 6}]\)], "Input"],

Cell[OutputFormData["\<\
{c, d, e, f}\
\>", "\<\
{c, d, e, f}\
\>"], "Output"]
}, Closed]],

Cell[TextData[{
  StyleBox["Drop", "Input"],
  " works similarly, removing elements from a list. Here we drop the first \
three elements from a list."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Drop[{a, b, c, d, e, f, g}, 3]\)], "Input"],

Cell[OutputFormData["\<\
{d, e, f, g}\
\>", "\<\
{d, e, f, g}\
\>"], "Output"]
}, Closed]],

Cell[TextData[{
  "Note that ",
  StyleBox["Take",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " and ",
  StyleBox["Drop",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " do not alter the value of a list. Here is a vector of values."
}], "Text"],

Cell[BoxData[
    \(\(alpha
       = {\[ScriptA], \[ScriptB], \[ScriptC], \[ScriptD], \[ScriptE], 
        \[ScriptF]}; \)\)], "Input"],

Cell[TextData[{
  "If we drop some elements from ",
  StyleBox["alpha",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  ", ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " returns the remaining elements."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Drop[alpha, {3, 5}]\)], "Input"],

Cell[BoxData[
    \({\[ScriptA], \[ScriptB], \[ScriptF]}\)], "Output"]
}, Closed]],

Cell["However, the original list remains unchanged.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(alpha\)], "Input"],

Cell[BoxData[
    \({\[ScriptA], \[ScriptB], \[ScriptC], \[ScriptD], \[ScriptE], \[ScriptF]}
      \)], "Output"]
}, Closed]],

Cell[TextData[{
  "To alter the value of ",
  StyleBox["alpha",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  ", we must set the value of ",
  StyleBox["alpha",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " to the desired subset."
}], "Text"],

Cell[BoxData[
    \(\(alpha = Drop[alpha, {3, 5}]; \)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(alpha\)], "Input"],

Cell[BoxData[
    \({\[ScriptA], \[ScriptB], \[ScriptF]}\)], "Output"]
}, Closed]],

Cell[TextData[{
  "Here is a function called ",
  StyleBox["sampleWithoutReplacement", "Input"],
  " that takes a given number of samples from a list, without choosing the \
same element more than once."
}], "Text"],

Cell[BoxData[
    \(sampleWithoutReplacement[L_List, n_Integer?Positive] := 
      Module[{\[ScriptCapitalL] = L, \[ScriptL] = Length[L], pos}, 
        Table[pos = Random[Integer, {1, \[ScriptL]}]; 
          \[ScriptCapitalL] = Drop[\[ScriptCapitalL], {pos}]; 
          \[ScriptL] = \[ScriptL] - 1; L[\([pos]\)], {n}]]\)], "Input"],

Cell["\<\
Here is a sample of fifteen data points from a list of integers \
from 1 to 50.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(sampleWithoutReplacement[Range[50], 15]\)], "Input"],

Cell[BoxData[
    \({35, 30, 33, 27, 20, 17, 29, 24, 8, 25, 4, 39, 37, 3, 19}\)], "Output"]
}, Closed]],

Cell[TextData[{
  "See also ",
  StyleBox["Extract", "Input"],
  ", ",
  StyleBox["Append", "Input"],
  ", ",
  StyleBox["AppendTo", "Input"],
  ", ",
  StyleBox["Prepend", "Input"],
  ", ",
  StyleBox["PrependTo", "Input"],
  ", ",
  StyleBox["Insert", "Input"],
  ", ",
  StyleBox["Delete", "Input"],
  ", ",
  StyleBox["ReplacePart", "Input"],
  ", ",
  StyleBox["DeleteCases", "Input"],
  ", ",
  StyleBox["Select", "Input"],
  ", ",
  StyleBox["Join", "Input"],
  ", ",
  StyleBox["Split", "Input"],
  ", ",
  StyleBox["LinearAlgebra`MatrixManipulation`", "Input"]
}], "SeeAlso"]
}, Closed]],

Cell[CellGroupData[{

Cell["Exercises: Extracting Parts of Lists", "Subsection",
  PageBreakAbove->True],

Cell[TextData[{
  "Using ",
  StyleBox["Part", "Input"],
  ", extract the ",
  StyleBox["b", "Input"],
  " from ",
  Cell[BoxData[
      \({{a, b, c}, {d, e, f}}\)], "Input"],
  "."
}], "Question"],

Cell[TextData[{
  "The ",
  StyleBox["b", "Input"],
  " is in the first row and second column of the matrix, so we use ",
  StyleBox["Part", "Input"],
  " as follows."
}], "Text"],

Cell[CellGroupData[{

Cell["Part[{{a, b, c}, {d, e, f}}, 1, 2]", "Input"],

Cell[OutputFormData["\<\
b\
\>", "\<\
b\
\>"], "Output"]
}, Closed]],

Cell[TextData[{
  "We can use the double-bracket shorthand for ",
  StyleBox["Part", "Input"],
  " as follows."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \({{a, b, c}, {d, e, f}}[\([1, 2]\)]\)], "Input"],

Cell[OutputFormData["\<\
b\
\>", "\<\
b\
\>"], "Output"]
}, Closed]],

Cell[TextData[{
  "Switch the third and fourth elements of the list ",
  Cell[BoxData[
      \({a, b, c, d, e}\)], "Input"],
  "."
}], "Question"],

Cell[TextData[{
  "We can use the part-selection notation ",
  StyleBox["[[{ }]]", "Input"],
  " to switch the elements."
}], "Text"],

Cell[CellGroupData[{

Cell["{a, b, c, d, e}[[{1, 2, 4, 3, 5}]]", "Input"],

Cell[OutputFormData["\<\
{a, b, d, c, e}\
\>", 
"\<\
{a, b, d, c, e}\
\>"], "Output"]
}, Closed]],

Cell[TextData[{
  "Use ",
  StyleBox["Table", "Input"],
  " and ",
  StyleBox["Part", "Input"],
  " to define a function called ",
  StyleBox["EveryOtherElement", "Input"],
  " that extracts every other element of a list."
}], "Question"],

Cell[TextData[{
  "The key is to set up an iterator inside ",
  StyleBox["Table", "Input"],
  " that extracts every second element from a list."
}], "Text"],

Cell[BoxData[
    \(EveryOtherElement[L_List] := Table[Part[L, n], {n, 1, Length[L], 2}]\)],
   "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(EveryOtherElement[{a, b, c, d, e, f, g, h, i, j, k, l}]\)], "Input"],

Cell[BoxData[
    \({a, c, e, g, i, k}\)], "Output"]
}, Closed]],

Cell[TextData[{
  "Define a function ",
  StyleBox["MatrixTrace", "Input"],
  " that computes the sum of each of the elements along the diagonal of a \
matrix."
}], "Question"],

Cell["Here is a matrix.", "Text"],

Cell[BoxData[
    RowBox[{
      RowBox[{"testmat", "=", 
        RowBox[{"(", GridBox[{
              {"a", "b", "c"},
              {"d", "e", "f"},
              {"g", "h", "i"}
              }], ")"}]}], ";"}]], "Input"],

Cell["\<\
The elements along the diagonal have equal coordinates in the \
horizontal and vertical directions.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Table[testmat[\([n, n]\)], {n, 1, 3}]\)], "Input"],

Cell[BoxData[
    \({a, e, i}\)], "Output"]
}, Closed]],

Cell[TextData[{
  "To add the elements we use ",
  StyleBox["Sum", "Input"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Sum[testmat[\([n, n]\)], {n, 1, 3}]\)], "Input"],

Cell[BoxData[
    \(a + e + i\)], "Output"]
}, Closed]],

Cell[TextData[{
  "Here is a general definition of ",
  StyleBox["MatrixTrace", "Input"],
  "."
}], "Text"],

Cell[BoxData[
    \(MatrixTrace[m_] := Sum[m[\([n, n]\)], {n, Length[m]}]\)], "Input"],

Cell["Here is a square matrix.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(primemat = Partition[Prime[Range[16]], 4]; \nMatrixForm[primemat]\)], 
  "Input"],

Cell[BoxData[
    TagBox[
      RowBox[{"(", GridBox[{
            {"2", "3", "5", "7"},
            {"11", "13", "17", "19"},
            {"23", "29", "31", "37"},
            {"41", "43", "47", "53"}
            }], ")"}],
      (MatrixForm[ #]&)]], "Output"]
}, Closed]],

Cell["The function works as expected.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(MatrixTrace[primemat]\)], "Input"],

Cell[BoxData[
    \(99\)], "Output"]
}, Closed]],

Cell["A hand calculation shows that the answer is correct.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(2 + 13 + 31 + 53\)], "Input"],

Cell[BoxData[
    \(99\)], "Output"]
}, Closed]],

Cell["Here is a modification to allow only square matrices.", "Text"],

Cell[BoxData[
    \(Clear[MatrixTrace]\)], "Input"],

Cell[BoxData[
    \(MatrixTrace[m_] := 
      Sum[m[\([n, n]\)], {n, Length[m]}] /; 
        MatrixQ[m] && First[Dimensions[m]] == Last[Dimensions[m]]\)], "Input"],

Cell[" ", "EndExercises"]
}, Closed]],

Cell[CellGroupData[{

Cell["Characteristics of Elements", "Subsection"],

Cell[TextData[{
  "Often it is necessary to select elements from a list according to certain \
criteria, rather than according to position. The ",
  StyleBox["Select", "Input"],
  " function returns the elements of a given list that meet a specified \
criterion."
}], "Text"],

Cell[TextData[{
  "For example, one way to extract all of the prime numbers less than 100 is \
first to generate a list of integers from 1 to 100, then select from that \
list all the elements that satisfy the predicate function ",
  StyleBox["PrimeQ", "Input"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Select[Range[100], PrimeQ]\)], "Input"],

Cell[OutputFormData["\<\
{2, 3, 5, 7, 11, 13, 17, 19, 23, 29, 31, 37, 41, 
 
  43, 47, 53, 59, 61, 67, 71, 73, 79, 83, 89, 97}\
\>", 
"\<\
{2, 3, 5, 7, 11, 13, 17, 19, 23, 29, 31, 37, 41, 
 
  43, 47, 53, 59, 61, 67, 71, 73, 79, 83, 89, 97}\
\>"], "Output"]
}, Closed]],

Cell["\<\
Similarly, we can choose all pairs that satisfy some specified \
criteria from a list of ordered pairs. Here is a list of points along a \
spiral.\
\>", "Text"],

Cell[BoxData[
    \(\(pts = Table[{r\ Cos[r], r\ Sin[r]}, {r, 0, 25, 0.25}]; \)\)], "Input"],

Cell[TextData[{
  "Here is a predicate function that acts on pairs of numbers and returns ",
  StyleBox["True", "Input"],
  " if its first element times its second element is greater than zero."
}], "Text"],

Cell[BoxData[
    \(quad1or3[{x_, y_}] := \((x\ y > 0)\)\)], "Input"],

Cell[TextData[{
  "Here is a second predicate that returns ",
  StyleBox["True", "Input"],
  " if its second element is greater than or equal to its first element."
}], "Text"],

Cell[BoxData[
    \(ygex[{x_, y_}] := \((y >= x)\)\)], "Input"],

Cell[TextData[{
  "We want each of the following graphs to use the same options, and ",
  StyleBox["SetOptions", "Input"],
  " allows us to change a function\[CloseCurlyQuote]s default option \
settings. (We will change the option settings back to their default values \
after this example.)"
}], "Text"],

Cell[BoxData[
    \(\(SetOptions[ListPlot, AspectRatio \[Rule] 1, \n\t
      PlotRange \[Rule] {{\(-25\), 25}, {\(-25\), 25}}, 
      PlotStyle \[Rule] PointSize[0.02], DisplayFunction \[Rule] Identity, \n
      \tTicks \[Rule] None]; \)\)], "Input"],

Cell[TextData[{
  "The first plot is of all the points in the list ",
  StyleBox["pts", "Input"],
  "."
}], "Text"],

Cell[BoxData[
    \(\(ptsplot = ListPlot[pts, PlotLabel \[Rule] "\<All points\>"]; \)\)], 
  "Input"],

Cell[TextData[{
  "The second plot is of the points in the first or third quadrant (those \
that satisfy the predicate function ",
  StyleBox["quad1or3", "Input"],
  ")."
}], "Text"],

Cell[BoxData[
    \(\(q1or3pts = Select[pts, quad1or3]; \)\)], "Input"],

Cell[BoxData[
    \(\(q1or3plot = ListPlot[q1or3pts, PlotLabel \[Rule] "\<Quad. 1 or 3\>"]; 
    \)\)], "Input"],

Cell[TextData[{
  "The last plot is of the points for which the ",
  StyleBox["y ",
    FontSlant->"Italic"],
  "value is greater than or equal to the ",
  StyleBox["x",
    FontSlant->"Italic"],
  " value."
}], "Text"],

Cell[BoxData[
    \(\(ygexpts = Select[pts, ygex]; \)\)], "Input"],

Cell[BoxData[
    \(\(ygexplot = 
      ListPlot[ygexpts, PlotLabel \[Rule] "\<y \[GreaterEqual] x\>"]; \)\)], 
  "Input"],

Cell["Here are the three plots.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(Show[GraphicsArray[{ptsplot, q1or3plot, ygexplot}]]; \)\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .3125 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.31746 0.00744048 0.31746 [
[ 0 0 0 0 ]
[ 1 .3125 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .3125 L
0 .3125 L
closepath
clip
newpath
% Start of sub-graphic
p
0.0238095 0.00744048 0.321429 0.30506 MathSubStart
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.02 0.5 0.02 [
[.5 1.0125 -32 0 ]
[.5 1.0125 32 15 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
0 .5 m
1 .5 L
s
.5 0 m
.5 1 L
s
gsave
.5 1.0125 -93 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 15.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 15.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(All) show
87.000000 15.000000 moveto
(points) show
123.000000 15.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
.02 w
.5 .5 Mdot
.50484 .50124 Mdot
.50878 .50479 Mdot
.51098 .51022 Mdot
.51081 .51683 Mdot
.50788 .52372 Mdot
.50212 .52992 Mdot
.49376 .53444 Mdot
.48335 .53637 Mdot
.47173 .53501 Mdot
.45994 .52992 Mdot
.44916 .52099 Mdot
.4406 .50847 Mdot
.43538 .49297 Mdot
.43445 .47545 Mdot
.43846 .45713 Mdot
.44771 .43946 Mdot
.46208 .42393 Mdot
.48103 .41202 Mdot
.50357 .40507 Mdot
.52837 .40411 Mdot
.55377 .40981 Mdot
.57795 .42239 Mdot
.59904 .44155 Mdot
.61522 .46647 Mdot
.62493 .49585 Mdot
.62696 .52797 Mdot
.62056 .56076 Mdot
.60555 .59198 Mdot
.58235 .61935 Mdot
.552 .6407 Mdot
.51609 .65416 Mdot
.47672 .6583 Mdot
.43635 .65223 Mdot
.39766 .63574 Mdot
.36335 .60933 Mdot
.336 .57418 Mdot
.31782 .53217 Mdot
.31054 .48572 Mdot
.31522 .43769 Mdot
.33219 .3912 Mdot
.36093 .34939 Mdot
.40014 .31526 Mdot
.44773 .29145 Mdot
.50097 .28 Mdot
.55663 .28224 Mdot
.61116 .29865 Mdot
.66094 .32876 Mdot
.70252 .37122 Mdot
.73284 .42378 Mdot
.74945 .48342 Mdot
.75071 .54656 Mdot
.73594 .60924 Mdot
.70545 .66738 Mdot
.66063 .71702 Mdot
.60383 .75465 Mdot
.53829 .77737 Mdot
.46791 .78319 Mdot
.39707 .77112 Mdot
.33032 .74132 Mdot
.27209 .69509 Mdot
.22643 .63485 Mdot
.19668 .564 Mdot
.18528 .48676 Mdot
.19355 .40787 Mdot
.22159 .33234 Mdot
.26821 .26511 Mdot
.331 .21075 Mdot
.40644 .17312 Mdot
.49008 .15514 Mdot
.5768 .15853 Mdot
.66117 .18369 Mdot
.73771 .22964 Mdot
.80134 .29404 Mdot
.84762 .37328 Mdot
.87314 .46273 Mdot
.87571 .55695 Mdot
.85454 .65008 Mdot
.81037 .73616 Mdot
.7454 .80952 Mdot
.66323 .86518 Mdot
.56866 .89914 Mdot
.46738 .9087 Mdot
.36566 .89265 Mdot
.26995 .8514 Mdot
.18648 .78693 Mdot
.12083 .7028 Mdot
.07759 .60389 Mdot
.06002 .49611 Mdot
.06983 .38609 Mdot
.10701 .28077 Mdot
.16984 .18692 Mdot
.2549 .11074 Mdot
.35729 .05744 Mdot
.4709 .0309 Mdot
.5888 .03337 Mdot
.70361 .06532 Mdot
.80799 .12535 Mdot
.89514 .21023 Mdot
.95918 .31513 Mdot
.9956 .43382 Mdot
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.35119 0.00744048 0.64881 0.30506 MathSubStart
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.02 0.5 0.02 [
[.5 1.0125 -38 0 ]
[.5 1.0125 38 15 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
0 .5 m
1 .5 L
s
.5 0 m
.5 1 L
s
gsave
.5 1.0125 -99 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 15.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 15.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(Quad) show
87.000000 15.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(.) show
99.000000 15.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(1) show
111.000000 15.000000 moveto
(or) show
129.000000 15.000000 moveto
(3) show
135.000000 15.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
.02 w
.50484 .50124 Mdot
.50878 .50479 Mdot
.51098 .51022 Mdot
.51081 .51683 Mdot
.50788 .52372 Mdot
.50212 .52992 Mdot
.43538 .49297 Mdot
.43445 .47545 Mdot
.43846 .45713 Mdot
.44771 .43946 Mdot
.46208 .42393 Mdot
.48103 .41202 Mdot
.62696 .52797 Mdot
.62056 .56076 Mdot
.60555 .59198 Mdot
.58235 .61935 Mdot
.552 .6407 Mdot
.51609 .65416 Mdot
.31054 .48572 Mdot
.31522 .43769 Mdot
.33219 .3912 Mdot
.36093 .34939 Mdot
.40014 .31526 Mdot
.44773 .29145 Mdot
.75071 .54656 Mdot
.73594 .60924 Mdot
.70545 .66738 Mdot
.66063 .71702 Mdot
.60383 .75465 Mdot
.53829 .77737 Mdot
.18528 .48676 Mdot
.19355 .40787 Mdot
.22159 .33234 Mdot
.26821 .26511 Mdot
.331 .21075 Mdot
.40644 .17312 Mdot
.49008 .15514 Mdot
.87571 .55695 Mdot
.85454 .65008 Mdot
.81037 .73616 Mdot
.7454 .80952 Mdot
.66323 .86518 Mdot
.56866 .89914 Mdot
.06002 .49611 Mdot
.06983 .38609 Mdot
.10701 .28077 Mdot
.16984 .18692 Mdot
.2549 .11074 Mdot
.35729 .05744 Mdot
.4709 .0309 Mdot
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.678571 0.00744048 0.97619 0.30506 MathSubStart
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.02 0.5 0.02 [
[.5 1.0125 -17 0 ]
[.5 1.0125 17 15 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
0 .5 m
1 .5 L
s
.5 0 m
.5 1 L
s
gsave
.5 1.0125 -78 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 15.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 15.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(y) show
75.000000 15.000000 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(\\263) show
87.000000 15.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
93.000000 15.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Math1Mono
%%DocumentNeededResources: + font Courier
%%DocumentNeededFonts: Math1Mono
%%DocumentNeededFont: + Courier
%%DocumentFonts: font Math1Mono
%%DocumentFonts: + font Courier
grestore
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
.02 w
.5 .5 Mdot
.51081 .51683 Mdot
.50788 .52372 Mdot
.50212 .52992 Mdot
.49376 .53444 Mdot
.48335 .53637 Mdot
.47173 .53501 Mdot
.45994 .52992 Mdot
.44916 .52099 Mdot
.4406 .50847 Mdot
.43538 .49297 Mdot
.43445 .47545 Mdot
.43846 .45713 Mdot
.58235 .61935 Mdot
.552 .6407 Mdot
.51609 .65416 Mdot
.47672 .6583 Mdot
.43635 .65223 Mdot
.39766 .63574 Mdot
.36335 .60933 Mdot
.336 .57418 Mdot
.31782 .53217 Mdot
.31054 .48572 Mdot
.31522 .43769 Mdot
.33219 .3912 Mdot
.66063 .71702 Mdot
.60383 .75465 Mdot
.53829 .77737 Mdot
.46791 .78319 Mdot
.39707 .77112 Mdot
.33032 .74132 Mdot
.27209 .69509 Mdot
.22643 .63485 Mdot
.19668 .564 Mdot
.18528 .48676 Mdot
.19355 .40787 Mdot
.22159 .33234 Mdot
.7454 .80952 Mdot
.66323 .86518 Mdot
.56866 .89914 Mdot
.46738 .9087 Mdot
.36566 .89265 Mdot
.26995 .8514 Mdot
.18648 .78693 Mdot
.12083 .7028 Mdot
.07759 .60389 Mdot
.06002 .49611 Mdot
.06983 .38609 Mdot
.10701 .28077 Mdot
.16984 .18692 Mdot
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 90},
  ImageMargins->{{35, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000FPP10`4000010?ooobl_;oooZZVYZNSX
j?oo05FZZZZZZ_nZZS/k>gYjN[Vi^OShn03ooeGooj[ooonI<c<c<fi^KZf][Nc/k02ZoeFZojZZoonZ
oclo?ginO[fm_Oclo5D00:X00?l00?l0VCLg=g9bL[6a/O3`l03o05Go0:[o00<30d92@X61PL30`000
EED0EJX0EOl0ELbIoc/k>gIfM[Fe]OCdm03oEEGoEJ[oE@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0Z/`c
<clo?gYjN[Vi^OShn03oZUGoZZ[oZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`<30d92@WinO[fm_Ocl
o03ooeGooj[oo`l?3di>CXf=SLc<c01E05EE0:YE0?mE00L71dI6AX61PL30`000EED00:X00?l001<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@/;2dY:BXF5QLC4a000ZUD0EJX0EOl0EALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZPl?3di>CXV9RLS8b000oeD0ZZX0Z_l0ZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEoa<C
4e9BDXf=SLc<c01E05D0ojX0ool0oalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ01LG5eIFEY6ATM3@d01E
EEEE0:YE0?mE02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZEA/K6eYJFYFEUMCDe01EZUEEEJYEEOmEEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZQlO7eiNGYVIVMSHf01EoeEEZZYEZ_mEZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZob<S8f9RHYfMWMcLg02Z05EEojYEoomEobl_;fi^KZf][Nc/k03o05Go0:[o0=gW1RLW
9fIVIZ6QXN3Ph02ZEEFZ0:ZZ0?nZ03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooEB/[:fYZJZFUYNCTi02Z
ZUFZEJZZEOnZECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l08@000?l08@000?l08@00038000?o0000
FP000ol0001J0003o`000340000b0003o`0005X000?o0000FP000ol0000a0000<0000ol0o`050003
o`00058000?o0?l0G0000ol0000a0000<P000ol0001J0003o`0005X000?o0000<@0002P000?o0000
1`000ol0000;0003o`00048000?o00001`000ol0001J0003o`000340000b0003o`0005X000?o0000
FP000ol0000a0000<P000ol0001J0003o`0005X000?o0000<@00024000?o00003P000ol000190003
o`0000h000?o0000FP000ol0000a0000<P000ol0000B0003o`0004D000?o0000FP000ol0000a0000
<P000ol0001J0003o`0005X000?o0000<@00038000?o0000FP000ol0001J0003o`000340000a00;o
10000ol0001D00;oG0000ol0000a0000:`000ol000040003o`0000P000?o0000B0000ol000040003
o`0005X000?o0000<@0001/000?o000050000ol000130003o`0001@000?o0000@`000ol0000D0003
o`000340000V0003o`0000T000?o000060000ol0000c0003o`0000T000?o0000FP000ol0000a0000
<P000ol0001J0003o`0005X000?o0000<@00038000?o00003@000ol0001:0003o`0005X000?o0000
<@00038000?o0000FP000ol0001J0003o`000340000R0003o`0000d000?o0000BP000ol0000=0003
o`0005X000?o0000<@0001H000?o00006@001?l00?ln0003o`0001P000?o0000?`000ol0000H0003
o`000340000^0005o`000?l01P000ol0000:0003o`00048000Go0000o`1L0003o`000340000b0003
o`0005X000?o0000FP000ol0000a0000:`000ol000040003o`0000P000?o00004@000ol0000d0003
o`0000@000?o0000FP000ol0000a00007P000ol0000A0003o`0004L000?o000040000ol000170003
o`00010000?o0000<@0002P000?o00001`000ol0001@0003o`0000L000?o0000FP000ol0000a0000
<P000ol0000;0003o`0004`000?o0000FP000ol0000a000050000ol0000K0003o`0001D000?o0000
90000ol0000K0003o`0003`000?o00006`000ol0000a00009P000ol000090003o`0004h000?o0000
2@000ol0001>0003o`0000T000?o0000<@0001`000?o00004@001?l0o`02od@000?o000040000ol0
o`170003o`00018000?o0000<@0002l000Co003o10000ol000080003o`0004L000Co003oG0000ol0
000a00009@000ol000060005o`000?l01@000ol0000I0003o`0002/000?o00001P001Ol0003o04l0
00?o00002P000ol0000a0000;@000ol000020003o`0005H000Go0000o`1H0005o`000?l0<`000380
00?o00001@000ol0000>0003o`00044000?o0000FP000ol0000a000070000ol000060003o`0000D0
00?o00000P000ol0000>0003o`0003<000?o00001P000ol000050003o`00008000?o0000A0000ol0
00060003o`0000D000?o00000P000ol0000a00003`16oaL0A_lH04Ko400002d000?o00000P000ol0
001J00;oE`001?l00002oc80000^00;o0P000ol000050003o`00058000?o00001P000ol0001=00;o
0P02oc80000U0003o`0000P00ol@0003o`0004T000?o00003P000ol0000l0003o`0000P00olc0000
<P000ol000050003o`0000h000?o0000@@000ol000050003o`0000l000?o0000@0000ol0000a0000
7@000ol000060003o`0000T000?o0000FP000ol000150003o`0000L000?o000020000ol0000a0000
<P000ol0001J0003o`0005X000?o0000<@0001@000?o00006`000ol000040003o`0005<000?o0000
10000ol0000f0003o`0001X000?o0000<@0002P000?o00001`000ol0000=0003o`0004X000?o0000
3@000ol000110003o`0000H000?o0000<@00038000?o00000P000ol0001E0003o`00008000?o0000
E@000ol000030003o`0002/0000O0003o`0000T000?o000010001?l00?mI0004o`00odH000?o0000
2@000ol000040005o`000?l0;`0002d000Go003o0002oaH000?o0000@P02oaH000?o0000?P001?l0
o`02oc80000b0003o`0000/000?o0000C0000ol0000;0003o`0004`000?o0000<@00038000?o0000
FP000ol0001J0003o`000340000G0003o`0000P000?o00003@000ol0001J0003o`00040000?o0000
1`000ol0000=0003o`000340000b0003o`0000P000?o0000C`000ol000080003o`0004l000?o0000
20000ol0000V0000<P000ol0001J0003o`0005X000?o0000<@0002H000?o00002@000ol0000B0003
o`0004D000?o00004P000ol0000i0003o`0000T000?o0000<@00038000?o000010000ol0001C0003
o`0000@000?o0000D`000ol000040003o`0002X0000Z0003o`0000D000?o0?l0FP000ol0o`1C0003
o`0000@000Co003o<00001`000?o000040001?l00?mL0003o`0004@000?o00004@000ol0o`0c0000
<P000ol0001J0003o`0005X000?o0000<@00038000?o00003@000ol0001:0003o`0000h000?o0000
B@000ol0000>0003o`000200000b0003o`0005X000?o0000FP000ol0000a0000<P000ol0001J0003
o`0005X000?o0000<@00028000?o00003@000ol000080003o`0004l000?o000020000ol0000o0003
o`0000d000?o000020000ol0000V0000<P000ol0001J0003o`0005X000?o0000<@0002P000?o0000
1`000ol0001J0003o`00054000?o00001P000ol0000a0000;`001?l00?l30003o`0005H000?o0000
0P000ol0001C0003o`3o00@000?o0000;000038000?o0000FP000ol0001J0003o`000340000b0003
o`0005X000?o0000FP000ol0000a0000<P000ol0001J0003o`0005X000?o0000<@00038000?o0000
FP000ol0001J0003o`000340000b0003o`0005X000?o0000FP000ol0000a0000<P000ol0001J0003
o`0005X000?o0000<@00038000?o0000FP000ol0001J0003o`000340003o0240003o0240000/00Co
?004ofd00om00000;@000ol0000l0003o`0006l000?o0000?`0001@00_l00`3oo`0200Go00<0ool0
0ol700Co0`03o`801Ol0103oo`02o`800ol200Co7@03o`<01Ol00`3oo`03o`801Ol00`3oo`0900?o
2P03o`801?l800?o;P000ol0000800Co1`02o`030?oo02H0000E0003o`3o00D000?o00000`000ol0
00070007o`000?l0o`030005o`000?l00`001?l00?l30004o`00o`@000?o00006P001Ol0003o0080
00Co003o0P001?l00?l20005o`000?l00P02o`X000?o000020001Ol0003o008000?o00002`000ol0
000[0003o`0000P000?o00002@000ol0o`0W00005@03o`D000?o00000`000ol000070007o`000?l0
o`030005o`000?l00`001?l00?l30003o`0000801?lL0005o`000?l00P001?l00?l200Co0P001Ol0
003o00h000?o000020001Ol0003o008000?o00002`000ol0000Z0003o`3o00X00ol90003o`0002H0
000E0003o`3o00D000?o00000`000ol000070007o`000?l0o`030005o`000?l00`001?l00?l30003
o`00008000?o00007@001Ol0003o008000Co003o1@001?l00?l30003o`0000`000?o000020001Ol0
003o00800_l:00;o;@000ol0o`090003o`0000T000?o0?l09`0001H000?o000010000ol000030003
o`0000H01Ol300?o0`02o`801Ol200Co0P04oa`000Ko0000o`02o`030?oo00<00ol300Co3P000ol0
000900?o0P02o`030?oo00X000?o0000:@02o`030?oo01<00_l00`3oo`0V00005@02o`H000?o0000
0`000ol0000P0003o`0002<00olC0003o`0000/00_lL00?oK`0001/00ol300?o5`000ol000080003
o`0003P00_nM0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000\
\>"],
  ImageRangeCache->{{{0, 287}, {89, 0}} -> {-0.0871823, -0.0234425, 0.0110605,
   0.0110605}, {{7.875, 92.625}, {86.875, 2.0625}} -> {-36.4395, -26.5412, 
  0.725164, 0.725164}, {{101.062, 185.875}, {86.875, 2.0625}} -> {-104.038,
   -26.5412, 0.725164, 0.725164}, {{194.312, 279.062}, {86.875, 2.0625}} ->
   {-171.637, -26.5412, 0.725164, 0.725164}}]
}, Closed]],

Cell[TextData[{
  "Here we set the options to ",
  StyleBox["ListPlot", "Input"],
  " back to the default settings."
}], "Text"],

Cell[BoxData[
    \(\(SetOptions[ListPlot, \n\tAspectRatio \[Rule] 1/GoldenRatio, \n\t
      PlotRange \[Rule] Automatic, \n\tPlotStyle \[Rule] Automatic, 
      DisplayFunction \[RuleDelayed] $DisplayFunction, 
      Ticks \[Rule] Automatic]; \)\)], "Input"],

Cell[TextData[{
  "We can test whether an element is present in a list by using ",
  StyleBox["MemberQ", "Input"],
  " and ",
  StyleBox["FreeQ", "Input"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(MemberQ[{a, b, c, d, e}, c]\)], "Input"],

Cell[BoxData[
    \(True\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(FreeQ[{a, a\^b, a\^\(b\^c\)}, c]\)], "Input"],

Cell[BoxData[
    \(False\)], "Output"]
}, Closed]],

Cell[TextData[{
  "See also ",
  StyleBox["Cases", "Input"],
  ", ",
  StyleBox["Position", "Input"]
}], "SeeAlso"]
}, Closed]],

Cell[CellGroupData[{

Cell["Exercises: Characteristics of Elements", "Subsection",
  PageBreakAbove->True],

Cell[TextData[{
  "Use ",
  StyleBox["Select", "Input"],
  " to extract all the numbers from ",
  StyleBox["{a, 1, b, 2, c, 3}", "Input"],
  "."
}], "Question"],

Cell[TextData[{
  "We use the built-in predicate function ",
  StyleBox["NumberQ", "Input"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Select[{a, 1, b, 2, c, 3}, NumberQ]\)], "Input"],

Cell[OutputFormData["\<\
{1, 2, 3}\
\>", "\<\
{1, 2, 3}\
\>"], "Output"]
}, Closed]],

Cell[TextData[{
  "Create the following list of ",
  StyleBox["x",
    FontSlant->"Italic"],
  ", ",
  StyleBox["y",
    FontSlant->"Italic"],
  " pairs."
}], "Question"],

Cell[BoxData[
    \(\(pts = 
      Flatten[Table[{x, y}, {x, \(-3\), 3, 0.3}, {y, \(-3\), 3, 0.3}], 1]; 
    \)\)], "Input"],

Cell[TextData[{
  "Select from it all points whose coordinates satisfy ",
  Cell[BoxData[
      \(TraditionalForm\`sin(x) < sin(y)\)]],
  "."
}], "Text",
  FontWeight->"Bold"],

Cell["Here is a plot of all the points.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(ListPlot[pts, AspectRatio -> 1, PlotStyle -> PointSize[0.02]]; \)\)], 
  "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.5 0.15873 [
[.02381 .4875 -6 -9 ]
[.02381 .4875 6 0 ]
[.18254 .4875 -6 -9 ]
[.18254 .4875 6 0 ]
[.34127 .4875 -6 -9 ]
[.34127 .4875 6 0 ]
[.65873 .4875 -3 -9 ]
[.65873 .4875 3 0 ]
[.81746 .4875 -3 -9 ]
[.81746 .4875 3 0 ]
[.97619 .4875 -3 -9 ]
[.97619 .4875 3 0 ]
[.4875 .02381 -12 -4.5 ]
[.4875 .02381 0 4.5 ]
[.4875 .18254 -12 -4.5 ]
[.4875 .18254 0 4.5 ]
[.4875 .34127 -12 -4.5 ]
[.4875 .34127 0 4.5 ]
[.4875 .65873 -6 -4.5 ]
[.4875 .65873 0 4.5 ]
[.4875 .81746 -6 -4.5 ]
[.4875 .81746 0 4.5 ]
[.4875 .97619 -6 -4.5 ]
[.4875 .97619 0 4.5 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .5 m
.02381 .50625 L
s
[(-3)] .02381 .4875 0 1 Mshowa
.18254 .5 m
.18254 .50625 L
s
[(-2)] .18254 .4875 0 1 Mshowa
.34127 .5 m
.34127 .50625 L
s
[(-1)] .34127 .4875 0 1 Mshowa
.65873 .5 m
.65873 .50625 L
s
[(1)] .65873 .4875 0 1 Mshowa
.81746 .5 m
.81746 .50625 L
s
[(2)] .81746 .4875 0 1 Mshowa
.97619 .5 m
.97619 .50625 L
s
[(3)] .97619 .4875 0 1 Mshowa
.125 Mabswid
.05556 .5 m
.05556 .50375 L
s
.0873 .5 m
.0873 .50375 L
s
.11905 .5 m
.11905 .50375 L
s
.15079 .5 m
.15079 .50375 L
s
.21429 .5 m
.21429 .50375 L
s
.24603 .5 m
.24603 .50375 L
s
.27778 .5 m
.27778 .50375 L
s
.30952 .5 m
.30952 .50375 L
s
.37302 .5 m
.37302 .50375 L
s
.40476 .5 m
.40476 .50375 L
s
.43651 .5 m
.43651 .50375 L
s
.46825 .5 m
.46825 .50375 L
s
.53175 .5 m
.53175 .50375 L
s
.56349 .5 m
.56349 .50375 L
s
.59524 .5 m
.59524 .50375 L
s
.62698 .5 m
.62698 .50375 L
s
.69048 .5 m
.69048 .50375 L
s
.72222 .5 m
.72222 .50375 L
s
.75397 .5 m
.75397 .50375 L
s
.78571 .5 m
.78571 .50375 L
s
.84921 .5 m
.84921 .50375 L
s
.88095 .5 m
.88095 .50375 L
s
.9127 .5 m
.9127 .50375 L
s
.94444 .5 m
.94444 .50375 L
s
.25 Mabswid
0 .5 m
1 .5 L
s
.5 .02381 m
.50625 .02381 L
s
[(-3)] .4875 .02381 1 0 Mshowa
.5 .18254 m
.50625 .18254 L
s
[(-2)] .4875 .18254 1 0 Mshowa
.5 .34127 m
.50625 .34127 L
s
[(-1)] .4875 .34127 1 0 Mshowa
.5 .65873 m
.50625 .65873 L
s
[(1)] .4875 .65873 1 0 Mshowa
.5 .81746 m
.50625 .81746 L
s
[(2)] .4875 .81746 1 0 Mshowa
.5 .97619 m
.50625 .97619 L
s
[(3)] .4875 .97619 1 0 Mshowa
.125 Mabswid
.5 .05556 m
.50375 .05556 L
s
.5 .0873 m
.50375 .0873 L
s
.5 .11905 m
.50375 .11905 L
s
.5 .15079 m
.50375 .15079 L
s
.5 .21429 m
.50375 .21429 L
s
.5 .24603 m
.50375 .24603 L
s
.5 .27778 m
.50375 .27778 L
s
.5 .30952 m
.50375 .30952 L
s
.5 .37302 m
.50375 .37302 L
s
.5 .40476 m
.50375 .40476 L
s
.5 .43651 m
.50375 .43651 L
s
.5 .46825 m
.50375 .46825 L
s
.5 .53175 m
.50375 .53175 L
s
.5 .56349 m
.50375 .56349 L
s
.5 .59524 m
.50375 .59524 L
s
.5 .62698 m
.50375 .62698 L
s
.5 .69048 m
.50375 .69048 L
s
.5 .72222 m
.50375 .72222 L
s
.5 .75397 m
.50375 .75397 L
s
.5 .78571 m
.50375 .78571 L
s
.5 .84921 m
.50375 .84921 L
s
.5 .88095 m
.50375 .88095 L
s
.5 .9127 m
.50375 .9127 L
s
.5 .94444 m
.50375 .94444 L
s
.25 Mabswid
.5 0 m
.5 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
.02 w
.02381 .02381 Mdot
.02381 .07143 Mdot
.02381 .11905 Mdot
.02381 .16667 Mdot
.02381 .21429 Mdot
.02381 .2619 Mdot
.02381 .30952 Mdot
.02381 .35714 Mdot
.02381 .40476 Mdot
.02381 .45238 Mdot
.02381 .5 Mdot
.02381 .54762 Mdot
.02381 .59524 Mdot
.02381 .64286 Mdot
.02381 .69048 Mdot
.02381 .7381 Mdot
.02381 .78571 Mdot
.02381 .83333 Mdot
.02381 .88095 Mdot
.02381 .92857 Mdot
.02381 .97619 Mdot
.07143 .02381 Mdot
.07143 .07143 Mdot
.07143 .11905 Mdot
.07143 .16667 Mdot
.07143 .21429 Mdot
.07143 .2619 Mdot
.07143 .30952 Mdot
.07143 .35714 Mdot
.07143 .40476 Mdot
.07143 .45238 Mdot
.07143 .5 Mdot
.07143 .54762 Mdot
.07143 .59524 Mdot
.07143 .64286 Mdot
.07143 .69048 Mdot
.07143 .7381 Mdot
.07143 .78571 Mdot
.07143 .83333 Mdot
.07143 .88095 Mdot
.07143 .92857 Mdot
.07143 .97619 Mdot
.11905 .02381 Mdot
.11905 .07143 Mdot
.11905 .11905 Mdot
.11905 .16667 Mdot
.11905 .21429 Mdot
.11905 .2619 Mdot
.11905 .30952 Mdot
.11905 .35714 Mdot
.11905 .40476 Mdot
.11905 .45238 Mdot
.11905 .5 Mdot
.11905 .54762 Mdot
.11905 .59524 Mdot
.11905 .64286 Mdot
.11905 .69048 Mdot
.11905 .7381 Mdot
.11905 .78571 Mdot
.11905 .83333 Mdot
.11905 .88095 Mdot
.11905 .92857 Mdot
.11905 .97619 Mdot
.16667 .02381 Mdot
.16667 .07143 Mdot
.16667 .11905 Mdot
.16667 .16667 Mdot
.16667 .21429 Mdot
.16667 .2619 Mdot
.16667 .30952 Mdot
.16667 .35714 Mdot
.16667 .40476 Mdot
.16667 .45238 Mdot
.16667 .5 Mdot
.16667 .54762 Mdot
.16667 .59524 Mdot
.16667 .64286 Mdot
.16667 .69048 Mdot
.16667 .7381 Mdot
.16667 .78571 Mdot
.16667 .83333 Mdot
.16667 .88095 Mdot
.16667 .92857 Mdot
.16667 .97619 Mdot
.21429 .02381 Mdot
.21429 .07143 Mdot
.21429 .11905 Mdot
.21429 .16667 Mdot
.21429 .21429 Mdot
.21429 .2619 Mdot
.21429 .30952 Mdot
.21429 .35714 Mdot
.21429 .40476 Mdot
.21429 .45238 Mdot
.21429 .5 Mdot
.21429 .54762 Mdot
.21429 .59524 Mdot
.21429 .64286 Mdot
.21429 .69048 Mdot
.21429 .7381 Mdot
.21429 .78571 Mdot
.21429 .83333 Mdot
.21429 .88095 Mdot
.21429 .92857 Mdot
.21429 .97619 Mdot
.2619 .02381 Mdot
.2619 .07143 Mdot
.2619 .11905 Mdot
.2619 .16667 Mdot
.2619 .21429 Mdot
.2619 .2619 Mdot
.2619 .30952 Mdot
.2619 .35714 Mdot
.2619 .40476 Mdot
.2619 .45238 Mdot
.2619 .5 Mdot
.2619 .54762 Mdot
.2619 .59524 Mdot
.2619 .64286 Mdot
.2619 .69048 Mdot
.2619 .7381 Mdot
.2619 .78571 Mdot
.2619 .83333 Mdot
.2619 .88095 Mdot
.2619 .92857 Mdot
.2619 .97619 Mdot
.30952 .02381 Mdot
.30952 .07143 Mdot
.30952 .11905 Mdot
.30952 .16667 Mdot
.30952 .21429 Mdot
.30952 .2619 Mdot
.30952 .30952 Mdot
.30952 .35714 Mdot
.30952 .40476 Mdot
.30952 .45238 Mdot
.30952 .5 Mdot
.30952 .54762 Mdot
.30952 .59524 Mdot
.30952 .64286 Mdot
.30952 .69048 Mdot
.30952 .7381 Mdot
.30952 .78571 Mdot
.30952 .83333 Mdot
.30952 .88095 Mdot
.30952 .92857 Mdot
.30952 .97619 Mdot
.35714 .02381 Mdot
.35714 .07143 Mdot
.35714 .11905 Mdot
.35714 .16667 Mdot
.35714 .21429 Mdot
.35714 .2619 Mdot
.35714 .30952 Mdot
.35714 .35714 Mdot
.35714 .40476 Mdot
.35714 .45238 Mdot
.35714 .5 Mdot
.35714 .54762 Mdot
.35714 .59524 Mdot
.35714 .64286 Mdot
.35714 .69048 Mdot
.35714 .7381 Mdot
.35714 .78571 Mdot
.35714 .83333 Mdot
.35714 .88095 Mdot
.35714 .92857 Mdot
.35714 .97619 Mdot
.40476 .02381 Mdot
.40476 .07143 Mdot
.40476 .11905 Mdot
.40476 .16667 Mdot
.40476 .21429 Mdot
.40476 .2619 Mdot
.40476 .30952 Mdot
.40476 .35714 Mdot
.40476 .40476 Mdot
.40476 .45238 Mdot
.40476 .5 Mdot
.40476 .54762 Mdot
.40476 .59524 Mdot
.40476 .64286 Mdot
.40476 .69048 Mdot
.40476 .7381 Mdot
.40476 .78571 Mdot
.40476 .83333 Mdot
.40476 .88095 Mdot
.40476 .92857 Mdot
.40476 .97619 Mdot
.45238 .02381 Mdot
.45238 .07143 Mdot
.45238 .11905 Mdot
.45238 .16667 Mdot
.45238 .21429 Mdot
.45238 .2619 Mdot
.45238 .30952 Mdot
.45238 .35714 Mdot
.45238 .40476 Mdot
.45238 .45238 Mdot
.45238 .5 Mdot
.45238 .54762 Mdot
.45238 .59524 Mdot
.45238 .64286 Mdot
.45238 .69048 Mdot
.45238 .7381 Mdot
.45238 .78571 Mdot
.45238 .83333 Mdot
.45238 .88095 Mdot
.45238 .92857 Mdot
.45238 .97619 Mdot
.5 .02381 Mdot
.5 .07143 Mdot
.5 .11905 Mdot
.5 .16667 Mdot
.5 .21429 Mdot
.5 .2619 Mdot
.5 .30952 Mdot
.5 .35714 Mdot
.5 .40476 Mdot
.5 .45238 Mdot
.5 .5 Mdot
.5 .54762 Mdot
.5 .59524 Mdot
.5 .64286 Mdot
.5 .69048 Mdot
.5 .7381 Mdot
.5 .78571 Mdot
.5 .83333 Mdot
.5 .88095 Mdot
.5 .92857 Mdot
.5 .97619 Mdot
.54762 .02381 Mdot
.54762 .07143 Mdot
.54762 .11905 Mdot
.54762 .16667 Mdot
.54762 .21429 Mdot
.54762 .2619 Mdot
.54762 .30952 Mdot
.54762 .35714 Mdot
.54762 .40476 Mdot
.54762 .45238 Mdot
.54762 .5 Mdot
.54762 .54762 Mdot
.54762 .59524 Mdot
.54762 .64286 Mdot
.54762 .69048 Mdot
.54762 .7381 Mdot
.54762 .78571 Mdot
.54762 .83333 Mdot
.54762 .88095 Mdot
.54762 .92857 Mdot
.54762 .97619 Mdot
.59524 .02381 Mdot
.59524 .07143 Mdot
.59524 .11905 Mdot
.59524 .16667 Mdot
.59524 .21429 Mdot
.59524 .2619 Mdot
.59524 .30952 Mdot
.59524 .35714 Mdot
.59524 .40476 Mdot
.59524 .45238 Mdot
.59524 .5 Mdot
.59524 .54762 Mdot
.59524 .59524 Mdot
.59524 .64286 Mdot
.59524 .69048 Mdot
.59524 .7381 Mdot
.59524 .78571 Mdot
.59524 .83333 Mdot
.59524 .88095 Mdot
.59524 .92857 Mdot
.59524 .97619 Mdot
.64286 .02381 Mdot
.64286 .07143 Mdot
.64286 .11905 Mdot
.64286 .16667 Mdot
.64286 .21429 Mdot
.64286 .2619 Mdot
.64286 .30952 Mdot
.64286 .35714 Mdot
.64286 .40476 Mdot
.64286 .45238 Mdot
.64286 .5 Mdot
.64286 .54762 Mdot
.64286 .59524 Mdot
.64286 .64286 Mdot
.64286 .69048 Mdot
.64286 .7381 Mdot
.64286 .78571 Mdot
.64286 .83333 Mdot
.64286 .88095 Mdot
.64286 .92857 Mdot
.64286 .97619 Mdot
.69048 .02381 Mdot
.69048 .07143 Mdot
.69048 .11905 Mdot
.69048 .16667 Mdot
.69048 .21429 Mdot
.69048 .2619 Mdot
.69048 .30952 Mdot
.69048 .35714 Mdot
.69048 .40476 Mdot
.69048 .45238 Mdot
.69048 .5 Mdot
.69048 .54762 Mdot
.69048 .59524 Mdot
.69048 .64286 Mdot
.69048 .69048 Mdot
.69048 .7381 Mdot
.69048 .78571 Mdot
.69048 .83333 Mdot
.69048 .88095 Mdot
.69048 .92857 Mdot
.69048 .97619 Mdot
.7381 .02381 Mdot
.7381 .07143 Mdot
.7381 .11905 Mdot
.7381 .16667 Mdot
.7381 .21429 Mdot
.7381 .2619 Mdot
.7381 .30952 Mdot
.7381 .35714 Mdot
.7381 .40476 Mdot
.7381 .45238 Mdot
.7381 .5 Mdot
.7381 .54762 Mdot
.7381 .59524 Mdot
.7381 .64286 Mdot
.7381 .69048 Mdot
.7381 .7381 Mdot
.7381 .78571 Mdot
.7381 .83333 Mdot
.7381 .88095 Mdot
.7381 .92857 Mdot
.7381 .97619 Mdot
.78571 .02381 Mdot
.78571 .07143 Mdot
.78571 .11905 Mdot
.78571 .16667 Mdot
.78571 .21429 Mdot
.78571 .2619 Mdot
.78571 .30952 Mdot
.78571 .35714 Mdot
.78571 .40476 Mdot
.78571 .45238 Mdot
.78571 .5 Mdot
.78571 .54762 Mdot
.78571 .59524 Mdot
.78571 .64286 Mdot
.78571 .69048 Mdot
.78571 .7381 Mdot
.78571 .78571 Mdot
.78571 .83333 Mdot
.78571 .88095 Mdot
.78571 .92857 Mdot
.78571 .97619 Mdot
.83333 .02381 Mdot
.83333 .07143 Mdot
.83333 .11905 Mdot
.83333 .16667 Mdot
.83333 .21429 Mdot
.83333 .2619 Mdot
.83333 .30952 Mdot
.83333 .35714 Mdot
.83333 .40476 Mdot
.83333 .45238 Mdot
.83333 .5 Mdot
.83333 .54762 Mdot
.83333 .59524 Mdot
.83333 .64286 Mdot
.83333 .69048 Mdot
.83333 .7381 Mdot
.83333 .78571 Mdot
.83333 .83333 Mdot
.83333 .88095 Mdot
.83333 .92857 Mdot
.83333 .97619 Mdot
.88095 .02381 Mdot
.88095 .07143 Mdot
.88095 .11905 Mdot
.88095 .16667 Mdot
.88095 .21429 Mdot
.88095 .2619 Mdot
.88095 .30952 Mdot
.88095 .35714 Mdot
.88095 .40476 Mdot
.88095 .45238 Mdot
.88095 .5 Mdot
.88095 .54762 Mdot
.88095 .59524 Mdot
.88095 .64286 Mdot
.88095 .69048 Mdot
.88095 .7381 Mdot
.88095 .78571 Mdot
.88095 .83333 Mdot
.88095 .88095 Mdot
.88095 .92857 Mdot
.88095 .97619 Mdot
.92857 .02381 Mdot
.92857 .07143 Mdot
.92857 .11905 Mdot
.92857 .16667 Mdot
.92857 .21429 Mdot
.92857 .2619 Mdot
.92857 .30952 Mdot
.92857 .35714 Mdot
.92857 .40476 Mdot
.92857 .45238 Mdot
.92857 .5 Mdot
.92857 .54762 Mdot
.92857 .59524 Mdot
.92857 .64286 Mdot
.92857 .69048 Mdot
.92857 .7381 Mdot
.92857 .78571 Mdot
.92857 .83333 Mdot
.92857 .88095 Mdot
.92857 .92857 Mdot
.92857 .97619 Mdot
.97619 .02381 Mdot
.97619 .07143 Mdot
.97619 .11905 Mdot
.97619 .16667 Mdot
.97619 .21429 Mdot
.97619 .2619 Mdot
.97619 .30952 Mdot
.97619 .35714 Mdot
.97619 .40476 Mdot
.97619 .45238 Mdot
.97619 .5 Mdot
.97619 .54762 Mdot
.97619 .59524 Mdot
.97619 .64286 Mdot
.97619 .69048 Mdot
.97619 .7381 Mdot
.97619 .78571 Mdot
.97619 .83333 Mdot
.97619 .88095 Mdot
.97619 .92857 Mdot
.97619 .97619 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{144, 144},
  ImageMargins->{{35, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40002@0000T0P10`4000010?ooobl_;oooZZVYZNSX
j?oo05FZZZZZZ_W0RS/k>gYjN[Vi^OShn03ooeGooj[ooonI<c<c<fi^KZf][Nc/k02ZoeFZojZZoonZ
oclo?ginO[fm_Oclo5D00:X00?l00?l0VCLg=g9bL[6a/O3`l03o05Go0:[o00<30d92@X61PL30`000
EED0EJX0EOl0ELbIoc/k>gIfM[Fe]OCdm03oEEGoEJ[oE@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0Z/`c
<clo?gYjN[Vi^OShn03oZUGoZZ[oZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`<30d92@WinO[fm_Ocl
o03ooeGooj[oo`l?3di>CXf=SLc<c01E05EE0:YE0?mE00L71dI6AX61PL30`000EED00:X00?l001<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@/;2dY:BXF5QLC4a000ZUD0EJX0EOl0EALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZPl?3di>CXV9RLS8b000oeD0ZZX0Z_l0ZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEoa<C
4e9BDXf=SLc<c01E05D0ojX0ool0oalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ01LG5eIFEY6ATM3@d01E
EEEE0:YE0?mE02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZEA/K6eYJFYFEUMCDe01EZUEEEJYEEOmEEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZQlO7eiNGYVIVMSHf01EoeEEZZYEZ_mEZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZob<S8f9RHYfMWMcLg02Z05EEojYEoomEobl_;fi^KZf][Nc/k03o05Go0:[o0=gW1RLW
9fIVIZ6QXN3Ph02ZEEFZ0:ZZ0?nZ03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooEB/[:fYZJZFUYNCTi02Z
ZUFZEJZZEOnZECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000900002@0000B0000ol000150000@P03o`<0
00?o0000A@0004D000Co003oA`0000D00_l400;o1@02o`D00_l400;o1@02o`D00_l400;o1@09o`80
00?o0?l00_l400;o1@02o`D00_l400;o1@02o`D00_l400;o1@02o`D00_l400;o100000D00_l400;o
1@02o`D00_l400;o1@02o`D00_l400;o1@02o`D01?l200;o1@02o`D00_l500;o1002o`D00_l500;o
1002o`D00_l500;o1002o`@000150004o`00odL0001200?o0`000ol000150000B0000ol000150000
B002odH000180003o`0004D0000500;o1002o`D00_l500;o1002o`D00_l500;o1002o`D00_l500;o
1002o`D00_l500;o1@02o`@00_l500;o1@02o`@00_l500;o1@02o`@00_l400001@02o`@00_l500;o
1@02o`@00_l500;o1@02o`@00_l500;o1@02o`@00_l500;o1@02o`D00_l400;o1@02o`D00_l400;o
1@02o`D00_l400;o100004P00_m60000B0000ol000150000B0000ol000150000B0000ol000150000
1@02o`@00_l500;o1@02o`@00_l500;o1@02o`@00_l500;o1@02o`@00_l500;o1@02o`D00_l400;o
1@02o`D00_l400;o1@02o`D00_l400;o100000D00_l400;o1@02o`D00_l400;o1@02o`D00_l400;o
1@02o`D00_l400?o1002o`D00_l500;o1002o`D00_l500;o1002o`D00_l500;o1002o`@000180003
o`0004D000180003o`0004D000180003o`0004D0001800;oAP0004P000?o0000A@0000D00_l400;o
1@02o`D00_l400;o1@02o`D00_l400;o1@02o`D01Ol00`3oo`0500;o1@02o`D00_l400;o1@02o`D0
0_l400;o1@02o`D00_l400;o100000D00_l400;o1@02o`D00_l400;o1@02o`D00_l400;o1@02o`D0
0ol300;o1@02o`D00_l500;o1002o`D00_l500;o1002o`D00_l500;o1002o`@0000l00Go0`001?l0
0002odH000150004o`00odL000120004o`00o`8000?o0000A@0004<00_l30003o`0004D000180003
o`0004D0000500;o1002o`D00_l500;o1002o`D00_l500;o1002o`D00_l500;o1003o`@00_l500;o
1@02o`@00_l500;o1@02o`@00_l500;o1@02o`@00_l400001@02o`@00_l500;o1@02o`@00_l500;o
1@02o`@00_l500;o1@02o`@00_l500;o1@02o`D00_l400;o1@02o`D00_l400;o1@02o`D00_l400;o
100004P000?o0000A@0004P000?o0000A@0004P00_m60000B0000ol0001500001@02o`@00_l500;o
1@02o`@00_l500;o1@02o`@00_l500;o1@02o`@00_l500;o1@02o`D00_l400;o1@02o`D00_l400;o
1@02o`D00_l400;o100000D00_l400;o1@02o`D00_l400;o1@02o`D00_l400;o1@02o`D00_l400;o
1@02o`D00_l500;o1002o`D00_l500;o1002o`D00_l500;o1002o`@000180003o`0004D0001800;o
AP0004P000?o0000A@0004P000?o0000A@0004P000?o0000A@0000D00_l400;o1@02o`D00_l400;o
1@02o`D00_l400;o1@02o`D00_l400?o1002o`D00_l500;o1002o`D00_l500;o1002o`D00_l500;o
1002o`@0000500;o1002o`D00_l500;o1002o`D00_l500;o1002o`D00_l500;o1002o`D00_l500;o
1@02o`@00_l500;o1@02o`@00_l500;o1@02o`@00_l40000B0000ol000150000@P03o`<000?o0000
A@0004<000?o00000P000ol000150000?005o`8000?o00000P02odH000130003o`00008000?o0000
A@0000D00_l400;o1@02o`D00_l400;o1@02o`D00_l400;o1@02o`D00ol300;o1@02o`D00_l500;o
1002o`D00_l500;o1002o`D00_l500;o1002o`@0000500;o1002o`D00_l500;o1002o`D00_l500;o
1002o`D00_l500?o0`02o`D00_l500;o1@02o`@00_l500;o1@02o`@00_l500;o1@02o`@00_l40000
B002odH000180003o`0004D000180003o`0004D000180003o`0004D000180003o`0004D0000500;o
1002o`D00_l500;o1002o`D00_l500;o1002o`D00_l500;o1003o`@00_l500;o1@02o`@00_l500;o
1@02o`@00_l500;o1@02o`@00_l400001@02o`@00_l500;o1@02o`@00_l500;o1@02o`@00_l500;o
1@02o`@00_l500;o1@02o`D00_l400;o1@02o`D00_l400;o1@02o`D00_l400;o100004P000?o0000
A@0004P000?o0000A@0000L00olC00Co4P03oa800_lC00?o4`04oa800ol400002P000ol0000A0003
o`0001<000?o00004@000ol0000C0003o`0001<000?o00005@000ol00001000000<0ool01?l300?o
1@02o`<01Ol300;o1@02o`D01Ol00`3oo`0500;o1@02o`@00_l500;o1@02o`D00ol300;o1@02o`D0
0_l300?o1@02o`D00_l400?o0`0000D00_l0103oo`02o`D00_l500;o1002o`D00_l500;o1002o`D0
0_l500;o1002o`D00_l500;o1@03o`<00_l500;o1@02o`@00_l500;o1@02o`@00_l400002P000ol0
000@0004o`00oa<000?o00004@000ol0000C0003o`00018000Co003o5@000ol0000100001`03oa@0
0_lC00;o4`02oa<00_lE00;o4`03o`@000180003o`0004D000180003o`0004D000180003o`0004D0
000208ko000500;o0`03o`030?l000800_l30006o`3oo`3o0P02o`@00ol00`3o000200;o0`03o`80
00?o00000_l30006o`3oo`3o0P02o`@00ol00`3o000200;o0`001_l0ool0o`800_l400?o00<0o`00
0P02o`<00ol00`3o000200;o0`001_l0ool0o`800_l40000B0000ol000150000B0000ol000150000
B002odH000180003o`0004D000180003o`0004D0000500;o1002o`D00_l500;o1002o`D00_l500;o
1002o`D00_l500;o1002o`D00_l500;o1@02o`@00_l500;o1@02o`@00_l500;o1@02o`@00_l40000
1@02o`@00_l500;o1@02o`@00_l500;o1@02o`@00_l500;o1@02o`@00_l500;o1@02o`D00_l400;o
1@02o`D00_l400;o1@02o`D00_l400;o100004P00_m60000B0000ol000150000B0000ol000150000
B0000ol0001500001@02o`@00_l500;o1@02o`@00_l500;o1@02o`@00_l500;o1@02o`@00ol400;o
1@02o`D00_l400;o1@02o`D00_l400;o1@02o`D00_l400;o100000D00_l400;o1@02o`D00_l400;o
1@02o`D00_l400;o1@02o`D00_l400;o1@02o`D00_l500;o1002o`D00_l500;o1002o`D00_l500;o
1002o`@000180003o`0004D000180003o`0004D000180003o`0004D0001800;oAP0004P000?o0000
A@0000D00_l400;o1@02o`D00_l400;o1@02o`D00_l400;o1@02o`D01?l200;o1@02o`D00_l500;o
1002o`D00_l500;o1002o`D00_l500;o1002o`@0000500;o1002o`D00_l500;o1002o`D00_l500;o
1002o`D00_l500?o0`02o`D00_l500;o1@02o`@00_l500;o1@02o`@00_l500;o1@02o`@00_l40000
@`000ol0000200;oAP0004<000?o00000P000ol000150000@`000ol000020003o`0004D0001200;o
10000ol000150000B0000ol0001500001@02o`@00_l500;o1@02o`@00_l500;o1@02o`@00_l500;o
1@02o`@00ol400;o1@02o`D00_l400;o1@02o`D00_l400;o1@02o`D00_l400;o100000D00_l400;o
1@02o`D00_l400;o1@02o`D00_l400;o1@02o`D00_l400;o1@02o`D00_l500;o1002o`D00_l500;o
1002o`D00_l500;o1002o`@000180003o`0004D000180003o`0004D0001800;oAP0004P000?o0000
A@0000D00_l400;o1@02o`D00_l400;o1@02o`D00_l400;o1@02o`D00_l400;o1@02o`D00_l500;o
1002o`D00_l500;o1002o`D00_l500;o1002o`@0000500;o1002o`D00_l500;o1002o`D00_l500;o
1002o`D00_l500;o1002o`D00_l500;o1@02o`@00_l500;o1@02o`@00_l500;o1@02o`@00_l40000
B0000ol000150000B002odH000180003o`0004D000180003o`0004D000180003o`0004D0000500;o
1002o`D00_l500;o1002o`D00_l500;o1002o`D00_l500;o1003o`@00_l500;o1@02o`@00_l500;o
1@02o`@00_l500;o1@02o`@00_l400001@02o`@00_l500;o1@02o`@00_l500;o1@02o`@00_l500;o
1@02o`@00_l500;o1@02o`D00_l400;o1@02o`D00_l400;o1@02o`D00_l400;o100004P000?o0000
A@0004801?l20003o`0004D000130003o`00008000?o0000A@0004@000Co00000_m60000A@001?l0
0?m700001@02o`@00_l500;o1@02o`@00_l500;o1@02o`@00_l500;o1@02o`8000Co0?oo1@02o`D0
0_l500;o1002o`D00_l500;o1002o`D00_l500;o1002o`@0000500;o1002o`D00_l500;o1002o`D0
0_l500;o1002o`D00_l500Co0P02o`D00_l500;o1@02o`@00_l500;o1@02o`@00_l500;o1@02o`@0
0_l40000B002odH000180003o`0004D000180003o`0004D000180003o`0004D0000500;o1002o`D0
0_l500;o1002o`D00_l500;o1002o`D00_l500;o1003o`@00_l500;o1@02o`@00_l500;o1@02o`@0
0_l500;o1@02o`@00_l400001@02o`@00_l500;o1@02o`@00_l500;o1@02o`@00_l500;o1@02o`@0
0_l500;o1@02o`D00_l400;o1@02o`D00_l400;o1@02o`D00_l400;o100004P000?o0000A@0004P0
00?o0000A@0004P000?o0000A@0004P00_m60000B0000ol0001500001@02o`@00_l500;o1@02o`@0
0_l500;o1@02o`@00_l500;o1@02o`@00_l500;o1@02o`D00_l400;o1@02o`D00_l400;o1@02o`D0
0_l400;o100000D00_l400;o1@02o`D00_l400;o1@02o`D00_l400;o1@02o`D00_l400;o1@02o`D0
0_l500;o1002o`D00_l500;o1002o`D00_l500;o1002o`@0001800;oAP0004P000?o0000A@0004P0
00?o0000A@0004800ol30003o`0004D000150004o`00odL0000500;o1002o`D00_l500;o1002o`D0
0_l500;o1002o`D00_l500;o0P000ol0o`02o`@00_l500;o1@02o`@00_l500;o1@02o`@00_l500;o
1@02o`@00_l400001@02o`@00_l500;o1@02o`@00_l500;o1@02o`@00_l500;o1@04o`800_l500;o
1@02o`D00_l400;o1@02o`D00_l400;o1@02o`D00_l400;o100004D000Co003oA`0004800ol30003
o`0004D0002@0000\
\>"],
  ImageRangeCache->{{{0, 143}, {143, 0}} -> {-3.26938, -3.20971, 0.044891, 
  0.044891}}]
}, Closed]],

Cell[TextData[{
  "Here is a predicate function that accepts an ordered pair and returns ",
  StyleBox["True", "Input"],
  " if the sine of the horizontal coordinate is less than the sine of the \
vertical coordinate."
}], "Text"],

Cell[BoxData[
    \(inRegionsQ[{x_, y_}] := Sin[x] < Sin[y]\)], "Input"],

Cell[TextData[{
  "We use ",
  StyleBox["Select", "Input"],
  " to extract the points that satisfy ",
  StyleBox["inRegionsQ", "Input"],
  ". The following is a shortened version of the output."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Short[Select[pts, inRegionsQ], 3]\)], "Input"],

Cell[BoxData[
    TagBox[
      \({{\(-3\), 0.`}, {\(-3\), 0.299999999999999822`}, {\(-3\), 
          0.599999999999999644`}, 
        \[LeftSkeleton]205\[RightSkeleton], {3.`, 2.39999999999999946`}, {
          3.`, 2.70000000000000017`}}\),
      (Short[ #, 3]&)]], "Output"]
}, Closed]],

Cell[TextData[{
  "Here is a plot of the points that satisfy ",
  StyleBox["inRegionsQ", "Input"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(ListPlot[Select[pts, inRegionsQ], AspectRatio \[Rule] 1, 
      PlotStyle \[Rule] PointSize[0.02]]; \)\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.5 0.15873 [
[.02381 .4875 -6 -9 ]
[.02381 .4875 6 0 ]
[.18254 .4875 -6 -9 ]
[.18254 .4875 6 0 ]
[.34127 .4875 -6 -9 ]
[.34127 .4875 6 0 ]
[.65873 .4875 -3 -9 ]
[.65873 .4875 3 0 ]
[.81746 .4875 -3 -9 ]
[.81746 .4875 3 0 ]
[.97619 .4875 -3 -9 ]
[.97619 .4875 3 0 ]
[.4875 .02381 -12 -4.5 ]
[.4875 .02381 0 4.5 ]
[.4875 .18254 -12 -4.5 ]
[.4875 .18254 0 4.5 ]
[.4875 .34127 -12 -4.5 ]
[.4875 .34127 0 4.5 ]
[.4875 .65873 -6 -4.5 ]
[.4875 .65873 0 4.5 ]
[.4875 .81746 -6 -4.5 ]
[.4875 .81746 0 4.5 ]
[.4875 .97619 -6 -4.5 ]
[.4875 .97619 0 4.5 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .5 m
.02381 .50625 L
s
[(-3)] .02381 .4875 0 1 Mshowa
.18254 .5 m
.18254 .50625 L
s
[(-2)] .18254 .4875 0 1 Mshowa
.34127 .5 m
.34127 .50625 L
s
[(-1)] .34127 .4875 0 1 Mshowa
.65873 .5 m
.65873 .50625 L
s
[(1)] .65873 .4875 0 1 Mshowa
.81746 .5 m
.81746 .50625 L
s
[(2)] .81746 .4875 0 1 Mshowa
.97619 .5 m
.97619 .50625 L
s
[(3)] .97619 .4875 0 1 Mshowa
.125 Mabswid
.05556 .5 m
.05556 .50375 L
s
.0873 .5 m
.0873 .50375 L
s
.11905 .5 m
.11905 .50375 L
s
.15079 .5 m
.15079 .50375 L
s
.21429 .5 m
.21429 .50375 L
s
.24603 .5 m
.24603 .50375 L
s
.27778 .5 m
.27778 .50375 L
s
.30952 .5 m
.30952 .50375 L
s
.37302 .5 m
.37302 .50375 L
s
.40476 .5 m
.40476 .50375 L
s
.43651 .5 m
.43651 .50375 L
s
.46825 .5 m
.46825 .50375 L
s
.53175 .5 m
.53175 .50375 L
s
.56349 .5 m
.56349 .50375 L
s
.59524 .5 m
.59524 .50375 L
s
.62698 .5 m
.62698 .50375 L
s
.69048 .5 m
.69048 .50375 L
s
.72222 .5 m
.72222 .50375 L
s
.75397 .5 m
.75397 .50375 L
s
.78571 .5 m
.78571 .50375 L
s
.84921 .5 m
.84921 .50375 L
s
.88095 .5 m
.88095 .50375 L
s
.9127 .5 m
.9127 .50375 L
s
.94444 .5 m
.94444 .50375 L
s
.25 Mabswid
0 .5 m
1 .5 L
s
.5 .02381 m
.50625 .02381 L
s
[(-3)] .4875 .02381 1 0 Mshowa
.5 .18254 m
.50625 .18254 L
s
[(-2)] .4875 .18254 1 0 Mshowa
.5 .34127 m
.50625 .34127 L
s
[(-1)] .4875 .34127 1 0 Mshowa
.5 .65873 m
.50625 .65873 L
s
[(1)] .4875 .65873 1 0 Mshowa
.5 .81746 m
.50625 .81746 L
s
[(2)] .4875 .81746 1 0 Mshowa
.5 .97619 m
.50625 .97619 L
s
[(3)] .4875 .97619 1 0 Mshowa
.125 Mabswid
.5 .05556 m
.50375 .05556 L
s
.5 .0873 m
.50375 .0873 L
s
.5 .11905 m
.50375 .11905 L
s
.5 .15079 m
.50375 .15079 L
s
.5 .21429 m
.50375 .21429 L
s
.5 .24603 m
.50375 .24603 L
s
.5 .27778 m
.50375 .27778 L
s
.5 .30952 m
.50375 .30952 L
s
.5 .37302 m
.50375 .37302 L
s
.5 .40476 m
.50375 .40476 L
s
.5 .43651 m
.50375 .43651 L
s
.5 .46825 m
.50375 .46825 L
s
.5 .53175 m
.50375 .53175 L
s
.5 .56349 m
.50375 .56349 L
s
.5 .59524 m
.50375 .59524 L
s
.5 .62698 m
.50375 .62698 L
s
.5 .69048 m
.50375 .69048 L
s
.5 .72222 m
.50375 .72222 L
s
.5 .75397 m
.50375 .75397 L
s
.5 .78571 m
.50375 .78571 L
s
.5 .84921 m
.50375 .84921 L
s
.5 .88095 m
.50375 .88095 L
s
.5 .9127 m
.50375 .9127 L
s
.5 .94444 m
.50375 .94444 L
s
.25 Mabswid
.5 0 m
.5 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
.02 w
.02381 .5 Mdot
.02381 .54762 Mdot
.02381 .59524 Mdot
.02381 .64286 Mdot
.02381 .69048 Mdot
.02381 .7381 Mdot
.02381 .78571 Mdot
.02381 .83333 Mdot
.02381 .88095 Mdot
.02381 .92857 Mdot
.02381 .97619 Mdot
.07143 .02381 Mdot
.07143 .45238 Mdot
.07143 .5 Mdot
.07143 .54762 Mdot
.07143 .59524 Mdot
.07143 .64286 Mdot
.07143 .69048 Mdot
.07143 .7381 Mdot
.07143 .78571 Mdot
.07143 .83333 Mdot
.07143 .88095 Mdot
.07143 .92857 Mdot
.07143 .97619 Mdot
.11905 .02381 Mdot
.11905 .07143 Mdot
.11905 .40476 Mdot
.11905 .45238 Mdot
.11905 .5 Mdot
.11905 .54762 Mdot
.11905 .59524 Mdot
.11905 .64286 Mdot
.11905 .69048 Mdot
.11905 .7381 Mdot
.11905 .78571 Mdot
.11905 .83333 Mdot
.11905 .88095 Mdot
.11905 .92857 Mdot
.11905 .97619 Mdot
.16667 .02381 Mdot
.16667 .07143 Mdot
.16667 .11905 Mdot
.16667 .35714 Mdot
.16667 .40476 Mdot
.16667 .45238 Mdot
.16667 .5 Mdot
.16667 .54762 Mdot
.16667 .59524 Mdot
.16667 .64286 Mdot
.16667 .69048 Mdot
.16667 .7381 Mdot
.16667 .78571 Mdot
.16667 .83333 Mdot
.16667 .88095 Mdot
.16667 .92857 Mdot
.16667 .97619 Mdot
.21429 .02381 Mdot
.21429 .07143 Mdot
.21429 .11905 Mdot
.21429 .16667 Mdot
.21429 .30952 Mdot
.21429 .35714 Mdot
.21429 .40476 Mdot
.21429 .45238 Mdot
.21429 .5 Mdot
.21429 .54762 Mdot
.21429 .59524 Mdot
.21429 .64286 Mdot
.21429 .69048 Mdot
.21429 .7381 Mdot
.21429 .78571 Mdot
.21429 .83333 Mdot
.21429 .88095 Mdot
.21429 .92857 Mdot
.21429 .97619 Mdot
.2619 .02381 Mdot
.2619 .07143 Mdot
.2619 .11905 Mdot
.2619 .16667 Mdot
.2619 .21429 Mdot
.2619 .30952 Mdot
.2619 .35714 Mdot
.2619 .40476 Mdot
.2619 .45238 Mdot
.2619 .5 Mdot
.2619 .54762 Mdot
.2619 .59524 Mdot
.2619 .64286 Mdot
.2619 .69048 Mdot
.2619 .7381 Mdot
.2619 .78571 Mdot
.2619 .83333 Mdot
.2619 .88095 Mdot
.2619 .92857 Mdot
.2619 .97619 Mdot
.30952 .02381 Mdot
.30952 .07143 Mdot
.30952 .11905 Mdot
.30952 .16667 Mdot
.30952 .35714 Mdot
.30952 .40476 Mdot
.30952 .45238 Mdot
.30952 .5 Mdot
.30952 .54762 Mdot
.30952 .59524 Mdot
.30952 .64286 Mdot
.30952 .69048 Mdot
.30952 .7381 Mdot
.30952 .78571 Mdot
.30952 .83333 Mdot
.30952 .88095 Mdot
.30952 .92857 Mdot
.30952 .97619 Mdot
.35714 .02381 Mdot
.35714 .07143 Mdot
.35714 .11905 Mdot
.35714 .40476 Mdot
.35714 .45238 Mdot
.35714 .5 Mdot
.35714 .54762 Mdot
.35714 .59524 Mdot
.35714 .64286 Mdot
.35714 .69048 Mdot
.35714 .7381 Mdot
.35714 .78571 Mdot
.35714 .83333 Mdot
.35714 .88095 Mdot
.35714 .92857 Mdot
.35714 .97619 Mdot
.40476 .02381 Mdot
.40476 .07143 Mdot
.40476 .45238 Mdot
.40476 .5 Mdot
.40476 .54762 Mdot
.40476 .59524 Mdot
.40476 .64286 Mdot
.40476 .69048 Mdot
.40476 .7381 Mdot
.40476 .78571 Mdot
.40476 .83333 Mdot
.40476 .88095 Mdot
.40476 .92857 Mdot
.40476 .97619 Mdot
.45238 .02381 Mdot
.45238 .5 Mdot
.45238 .54762 Mdot
.45238 .59524 Mdot
.45238 .64286 Mdot
.45238 .69048 Mdot
.45238 .7381 Mdot
.45238 .78571 Mdot
.45238 .83333 Mdot
.45238 .88095 Mdot
.45238 .92857 Mdot
.45238 .97619 Mdot
.5 .54762 Mdot
.5 .59524 Mdot
.5 .64286 Mdot
.5 .69048 Mdot
.5 .7381 Mdot
.5 .78571 Mdot
.5 .83333 Mdot
.5 .88095 Mdot
.5 .92857 Mdot
.5 .97619 Mdot
.54762 .59524 Mdot
.54762 .64286 Mdot
.54762 .69048 Mdot
.54762 .7381 Mdot
.54762 .78571 Mdot
.54762 .83333 Mdot
.54762 .88095 Mdot
.54762 .92857 Mdot
.59524 .64286 Mdot
.59524 .69048 Mdot
.59524 .7381 Mdot
.59524 .78571 Mdot
.59524 .83333 Mdot
.59524 .88095 Mdot
.64286 .69048 Mdot
.64286 .7381 Mdot
.64286 .78571 Mdot
.64286 .83333 Mdot
.69048 .7381 Mdot
.69048 .78571 Mdot
.78571 .7381 Mdot
.83333 .69048 Mdot
.83333 .7381 Mdot
.83333 .78571 Mdot
.88095 .64286 Mdot
.88095 .69048 Mdot
.88095 .7381 Mdot
.88095 .78571 Mdot
.88095 .83333 Mdot
.92857 .59524 Mdot
.92857 .64286 Mdot
.92857 .69048 Mdot
.92857 .7381 Mdot
.92857 .78571 Mdot
.92857 .83333 Mdot
.92857 .88095 Mdot
.97619 .54762 Mdot
.97619 .59524 Mdot
.97619 .64286 Mdot
.97619 .69048 Mdot
.97619 .7381 Mdot
.97619 .78571 Mdot
.97619 .83333 Mdot
.97619 .88095 Mdot
.97619 .92857 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{139.75, 139.75},
  ImageMargins->{{35, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40002;0000R`P10`4000010?ooobl_;oooZZVYZNSX
j?oo05FZZZZZZ_W0RS/k>gYjN[Vi^OShn03ooeGooj[ooonI<c<c<fi^KZf][Nc/k02ZoeFZojZZoonZ
oclo?ginO[fm_Oclo5D00:X00?l00?l0VCLg=g9bL[6a/O3`l03o05Go0:[o00<30d92@X61PL30`000
EED0EJX0EOl0ELbIoc/k>gIfM[Fe]OCdm03oEEGoEJ[oE@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0Z/`c
<clo?gYjN[Vi^OShn03oZUGoZZ[oZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`<30d92@WinO[fm_Ocl
o03ooeGooj[oo`l?3di>CXf=SLc<c01E05EE0:YE0?mE00L71dI6AX61PL30`000EED00:X00?l001<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@/;2dY:BXF5QLC4a000ZUD0EJX0EOl0EALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZPl?3di>CXV9RLS8b000oeD0ZZX0Z_l0ZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEoa<C
4e9BDXf=SLc<c01E05D0ojX0ool0oalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ01LG5eIFEY6ATM3@d01E
EEEE0:YE0?mE02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZEA/K6eYJFYFEUMCDe01EZUEEEJYEEOmEEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZQlO7eiNGYVIVMSHf01EoeEEZZYEZ_mEZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZob<S8f9RHYfMWMcLg02Z05EEojYEoomEobl_;fi^KZf][Nc/k03o05Go0:[o0=gW1RLW
9fIVIZ6QXN3Ph02ZEEFZ0:ZZ0?nZ03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooEB/[:fYZJZFUYNCTi02Z
ZUFZEJZZEOnZECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP0008/000160003o`000480001000?o0`000ol0
00120000@`001?l00?m400002`02o`D00_l400;o1@02o`@00_l500;o1002o`@02Ol20003o`0000;o
@`0000/00_l500;o1002o`D00_l400;o1@02o`@00_l400;o1@04o`<000?o0000@P0004<000Co003o
A00004000ol30003o`00048000160003o`000480001600;o@`0004H000?o0000@P0001800_l400;o
1@02o`@00_l500;o1002o`@00_l<0003o`000480000B00;o1002o`D00_l400;o1@02o`@00_l400;o
30000ol000120000AP02od<000160003o`00048000160003o`00048000160003o`000480000H00;o
1@02o`@00_l500;o1002oa800_m300006002o`D00_l400;o1@02o`@00_lB0003o`00048000160003
o`00048000160003o`00048000160003o`000480001600;o@`0004H000?o0000@P0001l00_l400;o
1@02oa801?l20003o`000480000O00;o1002o`D00_lC0003o`00008000?o0000@P0003X01Ol30004
o`0000;o@`0004<000Co003oA000040000Co003o0P000ol000120000@@02o`<000?o0000@P0002D0
0_lO00;o@`0002D00_lO0003o`00048000160003o`00048000160003o`00048000160003o`000480
001600;o@`0004H000?o0000@P0004H000?o0000@P0004H000?o0000@P0004H00_m30000AP000ol0
00120000AP000ol000120000AP000ol0001200007`02o`@00_lO00;o@`0001l00_l400;o7`000ol0
00120000AP000ol000120000@003o`<000?o0000@P00044000?o00000P000ol000120000>P05o`80
00?o00000P02od<000110003o`00008000?o0000@P0001P00_l500;o1002o`D00_lC0003o`000080
00?o0000@P0001P00_l500;o1002o`D00_lB00;o10000ol000120000AP02od<000160003o`000480
00160003o`00048000160003o`000480000B00;o1002o`D00_l400;o1@02o`@00_lB00;o@`000180
0_l400;o1@02o`@00_l500;o1002oa8000?o0000@P0004H000?o0000@P0004H000?o0000@P0000L0
0olB00Co4P03oa400_lB00?o4P04oa800ol300002P000ol0000@0003o`0001<000?o000040000ol0
000B0003o`00018000?o00005@01o`400@0000030?oo00?o1003o`D00_l200Go0`03o`@00_l500Go
00<0ool01002o``000?o00004P000ol0000C0003o`0001@00Ol10040000800;o00<0ool01@02o`@0
0_l500;o1002o`D00_l400;o1002o``000?o00004P000ol0000D0003o`0001400_l300002P000ol0
000?0004o`00oa<000?o000040000ol0000B0003o`00014000Co003o5@01o`400@0000L00olC00;o
4`02oa800_lB00;o5002oa<00ol30000AP000ol000120000AP000ol000120000AP000ol000120000
0P29o`001@02o`<00ol00`3o000200;o0`03o`030?l000800_l300?o00<0o`000P02o`<00ol0103o
0002o`@00ol00`3o00020003o`00008000Go0000o`030003o`00008000Go0000o`030005o`000?l0
10001Ol0003o00<000?o00000P001Ol0003o00<000?o00000P001Ol0003o00<000160003o`000480
00160003o`000480001600;o@`0004H000?o0000@P0000D00_l400;o1@02o`@00_l500;o1002o`D0
0_l400;o1002o`D00_l400;o?`02o`<0000500;o1002o`D00_l400;o1@02o`@00_l500;o1002o`@0
0_l500;o1002ocl00_l30000AP000ol000120000AP02od<000160003o`00048000160003o`000480
00160003o`000480000500;o1002o`D00_l400;o1@02o`@00_l500;o1002o`@00_l500;o1003o`@0
0_lb00;o1002o`<0000500;o1002o`D00_l400;o1@02o`@00_l500;o1002o`@00_l500;o1002o`D0
0_lb00;o1002o`<000160003o`00048000160003o`000480001600;o@`0004H000?o0000@P0000D0
0_l400;o1@02o`@00_l500;o1002o`D00_l400;o1002o`D00_l400;o1@02o`@00_lU00;o1@02o`@0
0_l300001@02o`@00_l500;o1002o`D00_l400;o1@02o`@00_l400;o1@04o`800_l500;o1002obD0
0_l500;o1002o`<000110003o`00008000?o0000@P00044000?o00000P02od<000110003o`000080
00?o0000@P00044000?o00000P000ol000120000@002o`@000?o0000@P0000D00_l400;o1@02o`@0
0_l500;o1002o`D00_l400;o1002o`D00_l400?o1002o`@00_l500;o6002o`@00_l500;o1002o`<0
000500;o1002o`D00_l400;o1@02o`@00_l500;o1002o`@00_l500;o1002o`D00_l400;o1@02oaP0
0_l400;o1@02o`@00_l30000AP000ol000120000AP000ol000120000AP02od<000160003o`000480
000500;o1002o`D00_l400;o1@02o`@00_l500;o1002o`@00_l500;o1002o`D00_l400;o1@02o`@0
0_l;00;o1@02o`@00_l500;o1002o`<0000500;o1002o`D00_l400;o1@02o`@00_l500;o1002o`@0
0_l500;o1002o`D00_l400;o1@02o`@00_l;00;o1@02o`@00_l500;o1002o`<000160003o`000480
001600;o@`0004H000?o0000@P0004H000?o0000@P0004H000?o0000@P0000D00_l400;o1@02o`@0
0_l500;o1002o`D00_l400;o1002o`D00_l400?o1002o`@00_l500;o1002oa800_l400;o1@02o`@0
0_l300001@02o`@00_l500;o1002o`D00_l400;o1@02o`@00_l400;o1@02o`@00_l500;o1002o`D0
0_l400;o4P02o`@00_l500;o1002o`<0001000Co0P000ol000120000@@000ol000020003o`000480
00120004o`0000;o@`0004<000Co003oA00000D00_l400;o1@02o`@00_l500;o1002o`D00_l400;o
1002o`D00_l20004o`3oo`D00_l400;o1@02oah00_l500;o1002o`<0000500;o1002o`D00_l400;o
1@02o`@00_l500;o1002o`@00_l500Co0P02o`D00_l400;o1@02oah00_l500;o1002o`<000160003
o`000480001600;o@`0004H000?o0000@P0004H000?o0000@P0004H000?o0000@P0000D00_l400;o
1@02o`@00_l500;o1002o`D00_l400;o1002o`D00_l400?o1002o`@00_l/00;o1002o`<0000500;o
1002o`D00_l400;o1@02o`@00_l500;o1002o`@00_l500;o1002o`D00_l400;o;002o`@00_l30000
AP000ol000120000AP000ol000120000AP02od<000160003o`000480000500;o1002o`D00_l400;o
1@02o`@00_l500;o1002o`@00_l500;o1002o`D00_lh00;o0`0000D00_l400;o1@02o`@00_l500;o
1002o`D00_l400;o1002o`D00_l400;o1@02ocP00_l30000AP000ol000120000AP02od<000160003
o`000480001000?o0`000ol000120000@`001?l00?m400001@02o`@00_l500;o1002o`D00_l400;o
1@02o`@00_l400;o1@02o`8000?o0?l00_m300001@02o`@00_l500;o1002o`D00_l400;o1@02o`@0
0_l400;o1@04o`800_m40000@`001?l00?m40000@003o`<000?o0000@P0008/00000\
\>"],
  ImageRangeCache->{{{0, 138.75}, {138.75, 0}} -> {-3.278, -3.21402, 
  0.0463282, 0.0463282}}]
}, Closed]],

Cell[BoxData[
    \(Clear[pts, inRegionsQ]\)], "Input"],

Cell[TextData[{
  "Using ",
  StyleBox["Names", "Input",
    FontFamily->"Courier"],
  " and ",
  StyleBox["StringLength", "Input",
    FontFamily->"Courier"],
  ", find all ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " function names that contain more than twenty-five letters. Find all \
function names that contain fewer than three letters."
}], "Question"],

Cell[TextData[{
  "Here is a shortened list of all built-in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " function names."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Short[Names["\<System`*\>"], 3]\)], "Input"],

Cell[BoxData[
    TagBox[
      \({"Abort", "AbortProtect", "Above", "Abs", "AbsoluteDashing", 
        \[LeftSkeleton]1557\[RightSkeleton], "$TracePreAction", "$Urgent", 
        "$UserName", "$Version", "$VersionNumber"}\),
      (Short[ #, 3]&)]], "Output"]
}, Closed]],

Cell[TextData[{
  "Here is a predicate function that returns ",
  StyleBox["True", "Input",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " if its argument is a function whose name contains more than twenty-five \
letters."
}], "Text"],

Cell[BoxData[
    \(longNameQ[s_String] := StringLength[s] > 25\)], "Input"],

Cell[TextData[{
  "We use ",
  StyleBox["Select",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " to extract the desired function names."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Select[Names["\<System`*\>"], longNameQ]\)], "Input"],

Cell[BoxData[
    \({"ConversionStyleEnvironment", "DegreeReverseLexicographic", 
      "EllipticReducedHalfPeriods", "FEDisableConsolePrintPacket", 
      "FEEnableConsolePrintPacket", "GetLinebreakInformationPacket", 
      "Hypergeometric0F1Regularized", "Hypergeometric1F1Regularized", 
      "Hypergeometric2F1Regularized", "HypergeometricPFQRegularized", 
      "MathieuCharacteristicExponent", "NeedCurrentFrontEndPackagePacket", 
      "SelectionEvaluateCreateCell"}\)], "Output"]
}, Closed]],

Cell[TextData[{
  "The following function returns ",
  StyleBox["True",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " if its argument contains fewer than three letters."
}], "Text"],

Cell[BoxData[
    \(shortNameQ[s_String] := StringLength[s] < 3\)], "Input"],

Cell["Here are all the names with one or two letters.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Select[Names["\<System`*\>"], shortNameQ]\)], "Input"],

Cell[BoxData[
    \({"C", "D", "Do", "Dt", "E", "I", "If", "Im", "In", "K", "N", "O", "On", 
      "Or", "Pi", "Re"}\)], "Output"]
}, Closed]],

Cell[" ", "EndExercises"]
}, Closed]],

Cell[CellGroupData[{

Cell["List Structure", "Subsection"],

Cell[CellGroupData[{

Cell["Characteristics of Structure", "Subsubsection"],

Cell["\<\
There are many functions to determine characteristics of a list, \
such as its length, depth, or dimensions; further, we can test if a list is a \
vector or matrix.\
\>", "Text"],

Cell["\<\
The length of a vector is the number of elements it contains.\
\>", 
  "Text"],

Cell[BoxData[
    \(\(vec = {a, b, c}; \)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Length[vec]\)], "Input"],

Cell[BoxData[
    \(3\)], "Output"]
}, Closed]],

Cell[TextData[{
  "Because the vector ",
  StyleBox["vec", "Input"],
  " is one-dimensional, ",
  StyleBox["Dimensions[vec]", "Input"],
  " returns a list containing the size of ",
  StyleBox["vec", "Input"],
  " in its one dimension."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Dimensions[vec]\)], "Input"],

Cell[BoxData[
    \({3}\)], "Output"]
}, Closed]],

Cell["\<\
The length of a matrix is the number of rows it contains; that is, \
the number of sublists it contains.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Length[rect]\)], "Input"],

Cell[BoxData[
    \(5\)], "Output"]
}, Closed]],

Cell["\<\
The dimensions of a matrix are its number of rows and columns.\
\>",
   "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Dimensions[rect]\)], "Input"],

Cell[BoxData[
    \({5, 2}\)], "Output"]
}, Closed]],

Cell[TextData[{
  "In general, the length of an ",
  StyleBox["n",
    FontSlant->"Italic"],
  "-dimensional list is the number of sublists it contains that have ",
  Cell[BoxData[
      \(TraditionalForm\`n - 1\)]],
  " dimensions. The list ",
  StyleBox["tensor", "Input"],
  " contains two three-dimensional sublists, so its length is 2."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Length[tensor]\)], "Input"],

Cell[OutputFormData["\<\
2\
\>", "\<\
2\
\>"], "Output"]
}, Closed]],

Cell[TextData[{
  StyleBox["Dimensions", "Input"],
  " returns the length in each \[OpenCurlyDoubleQuote]direction\
\[CloseCurlyDoubleQuote] of a nested list."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Dimensions[tensor]\)], "Input"],

Cell[OutputFormData["\<\
{2, 3, 4, 5}\
\>", "\<\
{2, 3, 4, 5}\
\>"], "Output"]
}, Closed]],

Cell[TextData[{
  "If we have an irregularly shaped array of data, we can find the length of \
each sublist by mapping the function ",
  StyleBox["Length", "Input"],
  " over the array."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(irreg = {{1, 2, 3, 4}, {2, 4, 6}, {3, 6, 9, 12, 15, 18}, {4, 8}}; 
    TableForm[irreg]\)], "Input"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {"1", "2", "3", "4", \(""\), \(""\)},
          {"2", "4", "6", \(""\), \(""\), \(""\)},
          {"3", "6", "9", "12", "15", "18"},
          {"4", "8", \(""\), \(""\), \(""\), \(""\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      TableForm[ {{1, 2, 3, 4}, {2, 4, 6}, {3, 6, 9, 12, 15, 18}, {4, 8}}]]], 
  "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Map[Length, irreg]\)], "Input"],

Cell[BoxData[
    \({4, 3, 6, 2}\)], "Output"]
}, Closed]],

Cell["\<\
Here is a function that pads (with zeros) an irregularly shaped \
array, so that each sublist has the same length.\
\>", "Text"],

Cell[BoxData[
    \(padArray[\[ScriptCapitalA]_List] := 
      Module[{\[ScriptM]\[ScriptA]\[ScriptX] = 
            Max[Map[Length, \[ScriptCapitalA]]]}, 
        Map[Take[Join[#, Table[0, {\[ScriptM]\[ScriptA]\[ScriptX]}]], 
              \[ScriptM]\[ScriptA]\[ScriptX]]&, \[ScriptCapitalA]]]\)], 
  "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(padArray[irreg] // TableForm\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {"1", "2", "3", "4", "0", "0"},
          {"2", "4", "6", "0", "0", "0"},
          {"3", "6", "9", "12", "15", "18"},
          {"4", "8", "0", "0", "0", "0"}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Closed]],

Cell[TextData[{
  "See also ",
  StyleBox["TensorRank", "Input"],
  ", ",
  StyleBox["TreeForm", "Input"],
  ", ",
  StyleBox["Depth", "Input"],
  ", ",
  StyleBox["Level", "Input"],
  ", ",
  StyleBox["VectorQ", "Input"],
  ", ",
  StyleBox["MatrixQ", "Input"]
}], "SeeAlso"]
}, Closed]],

Cell[CellGroupData[{

Cell["Changing List Structure", "Subsubsection"],

Cell[TextData[{
  StyleBox["Flatten", "Input"],
  " is used to remove all but the outermost list brackets in a nested list of \
lists."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Flatten[hurr]\)], "Input"],

Cell[BoxData[
    \({"Allison", 65, 987, "Barry", 50, 995, "Chantal", 60, 992, "Dean", 40, 
      999, "Erin", 75, 975, "Felix", 115, 950, "Gabrielle", 60, 998, 
      "Humberto", 90, 970, "Iris", 75, 970, "Jerry", 35, 1003}\)], "Output"]
}, Closed]],

Cell[TextData[{
  "Here is a nested list called ",
  StyleBox["prods", "Input"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(prods = Table[m\ n, {m, 2, 5}, {n, 1, 5}]\)], "Input"],

Cell[BoxData[
    \({{2, 4, 6, 8, 10}, {3, 6, 9, 12, 15}, {4, 8, 12, 16, 20}, {5, 10, 15, 
        20, 25}}\)], "Output"]
}, Closed]],

Cell[TextData[{
  StyleBox["Flatten", "Input"],
  " removes all of the inner list brackets from ",
  StyleBox["prods", "Input"],
  ", returning a one-dimensional list of values."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Flatten[prods]\)], "Input"],

Cell[BoxData[
    \({2, 4, 6, 8, 10, 3, 6, 9, 12, 15, 4, 8, 12, 16, 20, 5, 10, 15, 20, 25}
      \)], "Output"]
}, Closed]],

Cell["\<\
The flattened list can now be sorted, have its duplicates removed, \
and so forth.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Sort[Flatten[prods]]\)], "Input"],

Cell[BoxData[
    \({2, 3, 4, 4, 5, 6, 6, 8, 8, 9, 10, 10, 12, 12, 15, 15, 16, 20, 20, 25}
      \)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Union[Flatten[prods]]\)], "Input"],

Cell[BoxData[
    \({2, 3, 4, 5, 6, 8, 9, 10, 12, 15, 16, 20, 25}\)], "Output"]
}, Closed]],

Cell["\<\
Lists can also be partitioned into sublists with a given length. \
Here a list of integers from 1 through 12 is partitioned into sublists of \
length 2, 3, and 4.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Partition[Range[12], 2]\)], "Input"],

Cell[BoxData[
    \({{1, 2}, {3, 4}, {5, 6}, {7, 8}, {9, 10}, {11, 12}}\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Partition[Range[12], 3]\)], "Input"],

Cell[BoxData[
    \({{1, 2, 3}, {4, 5, 6}, {7, 8, 9}, {10, 11, 12}}\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Partition[Range[12], 4]\)], "Input"],

Cell[BoxData[
    \({{1, 2, 3, 4}, {5, 6, 7, 8}, {9, 10, 11, 12}}\)], "Output"]
}, Closed]],

Cell[TextData[{
  "Notice that all sublists created by ",
  StyleBox["Partition", "Input"],
  " must be of the same length: if we partition a length-12 list into \
sublists of length 5, the two final elements are dropped."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Partition[Range[12], 5]\)], "Input"],

Cell[BoxData[
    \({{1, 2, 3, 4, 5}, {6, 7, 8, 9, 10}}\)], "Output"]
}, Closed]],

Cell[TextData[{
  "It is also possible to partition a list into \
\[OpenCurlyDoubleQuote]overlapping\[CloseCurlyDoubleQuote] sublists by giving \
the offset between subsequent lists as a third argument to ",
  StyleBox["Partition", "Input"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Partition[{a, b, c, d, e}, 3, 1]\)], "Input"],

Cell[BoxData[
    \({{a, b, c}, {b, c, d}, {c, d, e}}\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Partition[{a, b, c, d, e}, 3, 2]\)], "Input"],

Cell[BoxData[
    \({{a, b, c}, {c, d, e}}\)], "Output"]
}, Closed]],

Cell[TextData[
"Often we have lists of data to be manipulated. Manipulating vectors \
(one-dimensional lists) is straightforward, but to manipulate \
multidimensional lists may require manipulation of the \
list\[CloseCurlyQuote]s structure."], "Text"],

Cell[TextData[{
  "For example, say we have a list of ordered pairs called ",
  StyleBox["mydata", "Input"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(mydata = Table[{n, Sin[n + 0.1\ Random[]]}, {n, 0, 9, 0.3}]\)], "Input"],

Cell[BoxData[
    \({{0, 0.00844513988309739893`}, {0.3`, 0.306362461526602913`}, {0.6`, 
        0.607310661167293286`}, {0.9`, 0.788009572749263398`}, {
        1.19999999999999996`, 0.96066222875598406`}, {1.5`, 
        0.999999458951623232`}, {1.79999999999999982`, 
        0.952388420938955171`}, {2.10000000000000008`, 
        0.834715812354962949`}, {2.39999999999999991`, 
        0.621589739975351207`}, {2.69999999999999973`, 
        0.357996759733610758`}, {3.`, 0.0819647303442957486`}, {
        3.29999999999999982`, \(-0.230249881967099767`\)}, {
        3.59999999999999964`, \(-0.491278794242442984`\)}, {3.9`, 
        \(-0.743845156621557368`\)}, {4.20000000000000017`, 
        \(-0.875572815621597122`\)}, {4.5`, \(-0.981390804950580353`\)}, {
        4.79999999999999982`, \(-0.992070419493135702`\)}, {
        5.09999999999999964`, \(-0.918970501104014658`\)}, {
        5.39999999999999946`, \(-0.753412219870961319`\)}, {
        5.70000000000000017`, \(-0.504441927965866199`\)}, {6.`, 
        \(-0.207717381875106266`\)}, {6.29999999999999982`, 
        0.0793337137872103781`}, {6.59999999999999964`, 
        0.371952258167021998`}, {6.89999999999999946`, 
        0.62157348218313615`}, {7.19999999999999928`, 
        0.831784037861858749`}, {7.5`, 0.954520631698938792`}, {
        7.79999999999999982`, 0.999103113177188895`}, {8.09999999999999964`, 
        0.957559405664176921`}, {8.40000000000000035`, 
        0.812632841838091124`}, {8.69999999999999928`, 
        0.599839866922566322`}, {9.`, 0.383671623459636457`}}\)], "Output"]
}, Closed]],

Cell[TextData[{
  "Transposing ",
  StyleBox["mydata", "Input"],
  " results in a list containing two lists: the first being a list of ",
  StyleBox["x",
    FontSlant->"Italic"],
  "-coordinates and the second a list of ",
  StyleBox["y",
    FontSlant->"Italic"],
  "-coordinates."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Transpose[mydata]\)], "Input"],

Cell[BoxData[
    \({{0, 0.3`, 0.6`, 0.9`, 1.19999999999999996`, 1.5`, 
        1.79999999999999982`, 2.10000000000000008`, 2.39999999999999991`, 
        2.69999999999999973`, 3.`, 3.29999999999999982`, 
        3.59999999999999964`, 3.9`, 4.20000000000000017`, 4.5`, 
        4.79999999999999982`, 5.09999999999999964`, 5.39999999999999946`, 
        5.70000000000000017`, 6.`, 6.29999999999999982`, 
        6.59999999999999964`, 6.89999999999999946`, 7.19999999999999928`, 
        7.5`, 7.79999999999999982`, 8.09999999999999964`, 
        8.40000000000000035`, 8.69999999999999928`, 9.`}, {
        0.00844513988309739893`, 0.306362461526602913`, 
        0.607310661167293286`, 0.788009572749263398`, 0.96066222875598406`, 
        0.999999458951623232`, 0.952388420938955171`, 0.834715812354962949`, 
        0.621589739975351207`, 0.357996759733610758`, 0.0819647303442957486`, 
        \(-0.230249881967099767`\), \(-0.491278794242442984`\), 
        \(-0.743845156621557368`\), \(-0.875572815621597122`\), 
        \(-0.981390804950580353`\), \(-0.992070419493135702`\), 
        \(-0.918970501104014658`\), \(-0.753412219870961319`\), 
        \(-0.504441927965866199`\), \(-0.207717381875106266`\), 
        0.0793337137872103781`, 0.371952258167021998`, 0.62157348218313615`, 
        0.831784037861858749`, 0.954520631698938792`, 0.999103113177188895`, 
        0.957559405664176921`, 0.812632841838091124`, 0.599839866922566322`, 
        0.383671623459636457`}}\)], "Output"]
}, Closed]],

Cell[TextData[{
  "With ",
  StyleBox["mydata", "Input"],
  " in its transposed form, we can select the first sublist (the list of all \
",
  StyleBox["x",
    FontSlant->"Italic"],
  "-coordinates) and manipulate it separately, and so forth. For example, \
here are the original points."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(ListPlot[mydata, PlotJoined -> True]; \)\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.10582 0.307846 0.295473 [
[.23545 .29535 -3 -9 ]
[.23545 .29535 3 0 ]
[.44709 .29535 -3 -9 ]
[.44709 .29535 3 0 ]
[.65873 .29535 -3 -9 ]
[.65873 .29535 3 0 ]
[.87037 .29535 -3 -9 ]
[.87037 .29535 3 0 ]
[.01131 .01237 -12 -4.5 ]
[.01131 .01237 0 4.5 ]
[.01131 .16011 -24 -4.5 ]
[.01131 .16011 0 4.5 ]
[.01131 .45558 -18 -4.5 ]
[.01131 .45558 0 4.5 ]
[.01131 .60332 -6 -4.5 ]
[.01131 .60332 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.23545 .30785 m
.23545 .3141 L
s
[(2)] .23545 .29535 0 1 Mshowa
.44709 .30785 m
.44709 .3141 L
s
[(4)] .44709 .29535 0 1 Mshowa
.65873 .30785 m
.65873 .3141 L
s
[(6)] .65873 .29535 0 1 Mshowa
.87037 .30785 m
.87037 .3141 L
s
[(8)] .87037 .29535 0 1 Mshowa
.125 Mabswid
.07672 .30785 m
.07672 .3116 L
s
.12963 .30785 m
.12963 .3116 L
s
.18254 .30785 m
.18254 .3116 L
s
.28836 .30785 m
.28836 .3116 L
s
.34127 .30785 m
.34127 .3116 L
s
.39418 .30785 m
.39418 .3116 L
s
.5 .30785 m
.5 .3116 L
s
.55291 .30785 m
.55291 .3116 L
s
.60582 .30785 m
.60582 .3116 L
s
.71164 .30785 m
.71164 .3116 L
s
.76455 .30785 m
.76455 .3116 L
s
.81746 .30785 m
.81746 .3116 L
s
.92328 .30785 m
.92328 .3116 L
s
.97619 .30785 m
.97619 .3116 L
s
.25 Mabswid
0 .30785 m
1 .30785 L
s
.02381 .01237 m
.03006 .01237 L
s
[(-1)] .01131 .01237 1 0 Mshowa
.02381 .16011 m
.03006 .16011 L
s
[(-0.5)] .01131 .16011 1 0 Mshowa
.02381 .45558 m
.03006 .45558 L
s
[(0.5)] .01131 .45558 1 0 Mshowa
.02381 .60332 m
.03006 .60332 L
s
[(1)] .01131 .60332 1 0 Mshowa
.125 Mabswid
.02381 .04192 m
.02756 .04192 L
s
.02381 .07147 m
.02756 .07147 L
s
.02381 .10101 m
.02756 .10101 L
s
.02381 .13056 m
.02756 .13056 L
s
.02381 .18966 m
.02756 .18966 L
s
.02381 .2192 m
.02756 .2192 L
s
.02381 .24875 m
.02756 .24875 L
s
.02381 .2783 m
.02756 .2783 L
s
.02381 .33739 m
.02756 .33739 L
s
.02381 .36694 m
.02756 .36694 L
s
.02381 .39649 m
.02756 .39649 L
s
.02381 .42603 m
.02756 .42603 L
s
.02381 .48513 m
.02756 .48513 L
s
.02381 .51468 m
.02756 .51468 L
s
.02381 .54422 m
.02756 .54422 L
s
.02381 .57377 m
.02756 .57377 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .31034 m
.05556 .39837 L
.0873 .48729 L
.11905 .54068 L
.15079 .5917 L
.18254 .60332 L
.21429 .58925 L
.24603 .55448 L
.27778 .49151 L
.30952 .41362 L
.34127 .33206 L
.37302 .23981 L
.40476 .16269 L
.43651 .08806 L
.46825 .04914 L
.5 .01787 L
.53175 .01472 L
.56349 .03631 L
.59524 .08523 L
.62698 .1588 L
.65873 .24647 L
.69048 .33129 L
.72222 .41775 L
.75397 .4915 L
.78571 .55362 L
.81746 .58988 L
.84921 .60305 L
.88095 .59078 L
.9127 .54796 L
.94444 .48508 L
.97619 .42121 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{35, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/@P10`4000010?ooobl_;oooZZVYZNSX
j?oo05FZZZZZZ_W0RS/k>gYjN[Vi^OShn03ooeGooj[ooonI<c<c<fi^KZf][Nc/k02ZoeFZojZZoonZ
oclo?ginO[fm_Oclo5D00:X00?l00?l0VCLg=g9bL[6a/O3`l03o05Go0:[o00<30d92@X61PL30`000
EED0EJX0EOl0ELbIoc/k>gIfM[Fe]OCdm03oEEGoEJ[oE@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0Z/`c
<clo?gYjN[Vi^OShn03oZUGoZZ[oZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`<30d92@WinO[fm_Ocl
o03ooeGooj[oo`l?3di>CXf=SLc<c01E05EE0:YE0?mE00L71dI6AX61PL30`000EED00:X00?l001<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@/;2dY:BXF5QLC4a000ZUD0EJX0EOl0EALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZPl?3di>CXV9RLS8b000oeD0ZZX0Z_l0ZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEoa<C
4e9BDXf=SLc<c01E05D0ojX0ool0oalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ01LG5eIFEY6ATM3@d01E
EEEE0:YE0?mE02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZEA/K6eYJFYFEUMCDe01EZUEEEJYEEOmEEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZQlO7eiNGYVIVMSHf01EoeEEZZYEZ_mEZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZob<S8f9RHYfMWMcLg02Z05EEojYEoomEobl_;fi^KZf][Nc/k03o05Go0:[o0=gW1RLW
9fIVIZ6QXN3Ph02ZEEFZ0:ZZ0?nZ03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooEB/[:fYZJZFUYNCTi02Z
ZUFZEJZZEOnZECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l08@000?l08@000?l08@000?l08@000?l0
8@000?l08@0001/000?o0000o`0300004`03o`D000?o0000o`03000050000ol000040003o`000?l0
0`0000d01Ol20003o`0000@00_oo00@0000D0003o`0000@000?o0000P006og`0000D0003o`0000@0
00?o0000N`05o`H000?o0000N@0001<00_l60003o`0007X000?o00002P000ol0001h00006`000ol0
001i0003o`0000`00_mh00006`000ol0001h0003o`0000l000?o0000M@0001/000?o0000M`000ol0
000A0003o`0007@0000K0003o`0007H000?o00004`000ol0001c00006`02ogH000?o000050000ol0
001c00006`000ol0001d0003o`0001H000?o0000LP0001/000?o0000L`000ol0000H0003o`000740
000K0003o`0007<000?o000060000ol0001a00006`000ol0001b0003o`0001X000?o0000L00001/0
00?o0000L@000ol0000L0003o`0006l0000K0003o`00070000?o00007P000ol0001^00006`000ol0
001`0003o`0001h000?o0000KP0001/00_m`0003o`00020000?o0000K@0001/000?o0000KP000ol0
000R0003o`0006`0000K0003o`0006h000?o00008P000ol0001/00006`000ol0001]0003o`0002@0
00?o0000J`0001/000?o0000K0000ol0000V0003o`0006X0000K0003o`0006/000?o00009`000ol0
001Z00006`000ol0001[0003o`0002P000?o0000J@0001/000?o0000JP000ol0000Y0003o`0006T0
000K00;oJ`000ol0000Y0003o`0006T0000K0003o`0006T000?o0000:`000ol0001X00006`000ol0
001Y0003o`0002/000?o0000J00001/000?o0000J0000ol0000]0003o`0006L0000K0003o`0006P0
00?o0000;@000ol0001W00006`000ol0001W0003o`0002l000?o0000IP0001/000?o0000I`000ol0
000_0003o`0006H0000K0003o`0006H000?o0000<0000ol0001V00006`02ofL000?o0000<@000ol0
001U00006`000ol0001V0003o`00034000?o0000I@0001/000?o0000I@000ol0000c0003o`0006@0
000K0003o`0006D000?o0000<`000ol0001T00006`000ol0001T0003o`0003D000?o0000H`0001/0
00?o0000I0000ol0000e0003o`0006<0000800;o1002o`<00ol50003o`0006<000?o0000=P000ol0
001S00001`001?l00?l300;o1P000ol000020003o`0006<000?o0000=`000ol0001R000000<0ool0
0ol01@3o003o00/000?o00000P02of<000?o0000>0000ol0001R00001`001?l00?l800?o1@000ol0
001R0003o`0003T000?o0000H@0000L000Co003o20000ol000050003o`00064000?o0000>P000ol0
001Q00002002o`T01?l40003o`00064000?o0000>P000ol0001Q00006`000ol0001Q0003o`0003/0
00?o0000H00001/000?o0000H0000ol0000l0003o`000600000K0003o`00060000?o0000?0000ol0
001P00006`000ol0001P0003o`0003d000?o0000G`0001/00_mP0003o`0003h000?o0000G`0001/0
00?o0000G`000ol0000o0003o`0005h0000K0003o`0005h000?o0000@0000ol0001N00006`000ol0
001N0003o`00040000?o0000GP0001/000?o0000GP000ol000110003o`0005d0000K0003o`0005d0
00?o0000@P000ol0001M00006`000ol0001M0003o`00048000?o0000G@0001/00_mM0003o`0004@0
00?o0000G00001/000?o0000G0000ol000140003o`0005`0000K0003o`0005`000?o0000A@000ol0
001K00006`000ol0001K0003o`0004H000?o0000F`0001/000?o0000F`000ol000160003o`0005/0
000K0003o`0005/000?o0000A`000ol0001J00006`000ol0001J0003o`0004P000?o0000FP0001/0
00?o0000FP000ol000180003o`0005X0000K00;oFP000ol0001:0003o`0005T0000K0003o`0005T0
00?o0000BP000ol0001I00006`000ol0001I0003o`0004/000?o0000F00001/000?o0000F0000ol0
001<0003o`0005P0000K0003o`0005P000?o0000C0000ol0001H00006`000ol0001H0003o`0004d0
00?o0000E`0001/000?o0000<`04ob0000?o00004P03ocH00_l00`3o000c00;o8`0001/000?o0000
=0000ol0000P0003o`0001<000?o0000=0000ol00002oc<000Co003o8P0001/00_lf0003o`0001h0
00?o00004P04ocD000Ko003o0?lb0004o`00ob80000K0003o`0003H000?o00007@000ol0000B0003
o`3o03H00ol20003o`0003400_lS00006`000ol0000c0004o`00oal000?o00004P000ol0o`0f0003
o`00008000?o0000<0001?l00?lR00006`000ol0000d00;o7`000ol0000D00;o=`03o`8000?o0000
<002ob<0000K0003o`0005D000?o0000DP000ol0001E00006`000ol0001E0003o`0005<000?o0000
E00001/000?o0000E0000ol0001D0003o`0005@0000K0003o`0005@000?o0000E0000ol0001D0000
503oo`go000K0003o`0000/000?o00002`000ol0000;0003o`0000/000?o00002`000ol0000;0003
o`3o00/000?o00002`000ol0000;0003o`0000`000?o00002`000ol0000;0003o`0000<000?o0000
1@000ol0000;0003o`0000/000?o00002`000ol0000;0003o`0000/000?o00001@0001/000?o0000
=@000ol0000K0003o`0001L000?o0000=P000ol000030003o`0002l000?o00008@0001/00_mC0003
o`0005P000?o0000DP0001/00_mC0003o`0005P000?o0000DP0001/00_mC0003o`0005P000?o0000
DP0001/000?o0?l0D@000ol0001J0003o`000540000K0003o`3o054000?o0000FP000ol0001A0000
6`03oe0000?o0000G0000ol0001@00006`001?l00?m?0003o`0005`000?o0000D00001/000Co003o
C`000ol0001L0003o`000500000K0004o`00odh000?o0000GP000ol0001?00006`001Ol0003o04d0
00?o0000GP000ol0001?00006`001Ol0003o04d000?o0000G`000ol0001>00006`001Ol0003o04`0
00?o0000H0000ol0001>00006`000ol000020003o`0004T000?o0000H0000ol0001>00006`02o`<0
00?o0000B@000ol0001Q0003o`0004d0000K0003o`00008000?o0000B0000ol0001R0003o`0004d0
000K0003o`0000<000?o0000A`000ol0001S0003o`0004`0000K0003o`0000<000?o0000AP000ol0
001T0003o`0004`0000K0003o`0000<000?o0000AP000ol0001T0003o`0004`0000K0003o`0000@0
00?o0000A@000ol0001U0003o`0004/0000K0003o`0000@000?o0000A0000ol0001V0003o`0004/0
000K0003o`0000@000?o0000A0000ol0001V0003o`0004/0000K00;o1P000ol000130003o`0006L0
00?o0000BP0001/000?o00001@000ol000120003o`0006P000?o0000BP0001/000?o00001P000ol0
00110003o`0006T000?o0000B@0001/000?o00001P000ol000110003o`0006T000?o0000B@0001/0
00?o00001P000ol000100003o`0006X000?o0000B@0001/000?o00001`000ol0000o0003o`0006/0
00?o0000B00001/000?o00001`000ol0000n0003o`0006`000?o0000@0000ol0000500006`02o`P0
00?o0000?P000ol0001]0003o`0003l000?o00001@0001/000?o000020000ol0000l0003o`0006h0
00?o0000?P000ol0000600006`000ol000080003o`0003`000?o0000KP000ol0000n0003o`0000H0
000K0003o`0000T000?o0000>`000ol0001_0003o`0003`000?o00001`0001/000?o00002@000ol0
000j0003o`00070000?o0000?0000ol0000700006`000ol000090003o`0003X000?o0000L@000ol0
000j0003o`0000P0000800;o1002o`<00ol50003o`0000X000?o0000>0000ol0001b0003o`0003X0
00?o0000200000L000Co003o0`02o`H000?o00000P000ol0000:0003o`0003P000?o0000LP000ol0
000i0003o`0000T000070004o`00o`/000?o00000P02o`/000?o0000=`000ol0001d0003o`0003P0
00?o00002@0000L000Co003o2003o`D000?o00002`000ol0000f0003o`0007@000?o0000>0000ol0
000900001`001?l00?l80003o`0000D000?o00002`000ol0000f0003o`0007D000?o0000=P000ol0
000:00002002o`T01?l40003o`0000`000?o0000=0000ol0001f0003o`0003H000?o00002P0001/0
00?o000030000ol0000d0003o`0007H000?o0000=@000ol0000;00006`000ol0000<0003o`0003<0
00?o0000N0000ol0000d0003o`0000/0000K0003o`0000d000?o0000<P000ol0001h0003o`0003<0
00?o0000300001/000?o00003@000ol0000a0003o`0007X000?o0000<P000ol0000<00006`02o`h0
00?o0000<@000ol0001j0003o`00034000?o00003@0001/000?o00003P000ol0000`0003o`0007X0
00?o0000<@000ol0000=00006`000ol0000>0003o`0002l000?o0000O0000ol0000_0003o`0000h0
000K0003o`0000l000?o0000;P000ol0001l0003o`0002l000?o00003P0001/000?o00003`000ol0
000]0003o`0007h000?o0000;@000ol0000?00006`000ol0000@0003o`0002`000?o0000OP000ol0
000]0003o`0000l0000K0003o`00014000?o0000:P000ol000200003o`0002/000?o0000400001/0
00?o00004@000ol0000Z0003o`00080000?o0000:`000ol0000@00006`02oa<000?o0000:0000ol0
00220003o`0002T000?o00004@0001/000?o00004P000ol0000X0003o`00088000?o0000:0000ol0
000B00006`000ol0000C0003o`0002H000?o0000Q0000ol0000W0003o`000180000K0003o`0001<0
00?o00009P000ol000240003o`0002H000?o00004`0001/000?o000050000ol0000U0003o`0008D0
00?o00009@000ol0000C00006`000ol0000E0003o`0002<000?o0000QP000ol0000T0003o`0001@0
000K0003o`0001D000?o00008`000ol000270003o`0002<000?o0000500001/000?o00005P000ol0
000Q0003o`0008P000?o00008P000ol0000E00006`02oaL000?o00008@000ol000290003o`000240
00?o00005@0001/000?o00005`000ol0000O0003o`0008X000?o000080000ol0000F00006`000ol0
000H0003o`0001h000?o0000R`000ol0000O0003o`0001H0000K0003o`0001P000?o00007@000ol0
002<0003o`0001h000?o00005`0001/000?o00006@000ol0000K0003o`0008h000?o000070000ol0
000H00006`000ol0000J0003o`0001T000?o0000T0000ol0000J0003o`0001T0000K0003o`0001X0
00?o000060000ol0002B0003o`0001T000?o00006@0001/000?o00006`000ol0000F0003o`0009@0
00?o00005`000ol0000J00006`02oa`000?o00005@000ol0002F0003o`0001D000?o00006`0001/0
00?o000070000ol0000C0003o`0009P000?o000050000ol0000K00006`000ol0000M0003o`000140
00?o0000VP000ol0000B0003o`0001`0000K0003o`0001d000?o000040000ol0002L0003o`000100
00?o00007@0001/000?o00007P000ol0000=00;oX002o`h00_lP00006`000ol0000O00;o2`02oj@0
0_l:00;o8P0001<00ol50003o`0002400ol600;oZ002o`D00olT000050000ol000040003o`0002@0
0ol00`3oo`2/00;o00<0ool09`0001@000?o00001002obP000?o0000[P000ol0000W000050000ol0
00040003o`000?l00`0001@000?o000010000ol0003o00<0000C00;o1P000ol0003o00<0000K0003
o`000?l00`000?l08@000?l08@000?l08@000?l08@000?l08@000001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.970781, -1.12559, 
  0.0355256, 0.012723}}]
}, Closed]],

Cell[TextData[{
  "Here we give the name ",
  StyleBox["tdata", "Input"],
  " to the transpose of ",
  StyleBox["mydata", "Input"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(tdata = Transpose[mydata]\)], "Input"],

Cell[BoxData[
    \({{0, 0.3`, 0.6`, 0.9`, 1.19999999999999996`, 1.5`, 
        1.79999999999999982`, 2.10000000000000008`, 2.39999999999999991`, 
        2.69999999999999973`, 3.`, 3.29999999999999982`, 
        3.59999999999999964`, 3.9`, 4.20000000000000017`, 4.5`, 
        4.79999999999999982`, 5.09999999999999964`, 5.39999999999999946`, 
        5.70000000000000017`, 6.`, 6.29999999999999982`, 
        6.59999999999999964`, 6.89999999999999946`, 7.19999999999999928`, 
        7.5`, 7.79999999999999982`, 8.09999999999999964`, 
        8.40000000000000035`, 8.69999999999999928`, 9.`}, {
        0.00844513988309739893`, 0.306362461526602913`, 
        0.607310661167293286`, 0.788009572749263398`, 0.96066222875598406`, 
        0.999999458951623232`, 0.952388420938955171`, 0.834715812354962949`, 
        0.621589739975351207`, 0.357996759733610758`, 0.0819647303442957486`, 
        \(-0.230249881967099767`\), \(-0.491278794242442984`\), 
        \(-0.743845156621557368`\), \(-0.875572815621597122`\), 
        \(-0.981390804950580353`\), \(-0.992070419493135702`\), 
        \(-0.918970501104014658`\), \(-0.753412219870961319`\), 
        \(-0.504441927965866199`\), \(-0.207717381875106266`\), 
        0.0793337137872103781`, 0.371952258167021998`, 0.62157348218313615`, 
        0.831784037861858749`, 0.954520631698938792`, 0.999103113177188895`, 
        0.957559405664176921`, 0.812632841838091124`, 0.599839866922566322`, 
        0.383671623459636457`}}\)], "Output"]
}, Closed]],

Cell[TextData[{
  "Extracting the first part of the transpose of ",
  StyleBox["mydata", "Input"],
  " returns a list containing all the ",
  StyleBox["x",
    FontSlant->"Italic"],
  "-values in ",
  StyleBox["mydata", "Input"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell["tdata[[1]]", "Input"],

Cell[BoxData[
    \({0, 0.3`, 0.6`, 0.9`, 1.19999999999999996`, 1.5`, 1.79999999999999982`, 
      2.10000000000000008`, 2.39999999999999991`, 2.69999999999999973`, 3.`, 
      3.29999999999999982`, 3.59999999999999964`, 3.9`, 4.20000000000000017`, 
      4.5`, 4.79999999999999982`, 5.09999999999999964`, 5.39999999999999946`, 
      5.70000000000000017`, 6.`, 6.29999999999999982`, 6.59999999999999964`, 
      6.89999999999999946`, 7.19999999999999928`, 7.5`, 7.79999999999999982`, 
      8.09999999999999964`, 8.40000000000000035`, 8.69999999999999928`, 9.`}
      \)], "Output"]
}, Closed]],

Cell[TextData[{
  "Once the ",
  StyleBox["x",
    FontSlant->"Italic"],
  "-values have been extracted, we can manipulate them. Here we take the \
natural logarithm of one plus each of the elements."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Log[1 + %]\)], "Input"],

Cell[BoxData[
    \({0, 0.262364264467491059`, 0.470003629245735599`, 
      0.641853886172394716`, 0.788457360364270254`, 0.916290731874155106`, 
      1.02961941718115812`, 1.13140211149110059`, 1.22377543162211566`, 
      1.30833281965017866`, 1.38629436111989058`, 1.45861502269951675`, 
      1.52605630349504917`, 1.589235205116581`, 1.64865862558738163`, 
      1.70474809223842527`, 1.75785791755237363`, 1.80828877117926545`, 
      1.85629799036562594`, 1.90210752639692053`, 1.94591014905531327`, 
      1.98787434815434558`, 2.02814824729228515`, 2.06686275947297559`, 
      2.10413415427020744`, 2.14006616349627076`, 2.17475172148416096`, 
      2.20827441352280429`, 2.24070968927595837`, 2.27212588550933691`, 
      2.3025850929940459`}\)], "Output"]
}, Closed]],

Cell[TextData[{
  "To get the transformed data back into the form of ordered pairs, we create \
a list containing a list of the transformed ",
  StyleBox["x",
    FontSlant->"Italic"],
  "-values, then a list of the original ",
  StyleBox["y",
    FontSlant->"Italic"],
  "-values."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(transdata = {%, tdata\[LeftDoubleBracket]2\[RightDoubleBracket]}\)], 
  "Input"],

Cell[BoxData[
    \({{0, 0.262364264467491059`, 0.470003629245735599`, 
        0.641853886172394716`, 0.788457360364270254`, 0.916290731874155106`, 
        1.02961941718115812`, 1.13140211149110059`, 1.22377543162211566`, 
        1.30833281965017866`, 1.38629436111989058`, 1.45861502269951675`, 
        1.52605630349504917`, 1.589235205116581`, 1.64865862558738163`, 
        1.70474809223842527`, 1.75785791755237363`, 1.80828877117926545`, 
        1.85629799036562594`, 1.90210752639692053`, 1.94591014905531327`, 
        1.98787434815434558`, 2.02814824729228515`, 2.06686275947297559`, 
        2.10413415427020744`, 2.14006616349627076`, 2.17475172148416096`, 
        2.20827441352280429`, 2.24070968927595837`, 2.27212588550933691`, 
        2.3025850929940459`}, {0.00844513988309739893`, 
        0.306362461526602913`, 0.607310661167293286`, 0.788009572749263398`, 
        0.96066222875598406`, 0.999999458951623232`, 0.952388420938955171`, 
        0.834715812354962949`, 0.621589739975351207`, 0.357996759733610758`, 
        0.0819647303442957486`, \(-0.230249881967099767`\), 
        \(-0.491278794242442984`\), \(-0.743845156621557368`\), 
        \(-0.875572815621597122`\), \(-0.981390804950580353`\), 
        \(-0.992070419493135702`\), \(-0.918970501104014658`\), 
        \(-0.753412219870961319`\), \(-0.504441927965866199`\), 
        \(-0.207717381875106266`\), 0.0793337137872103781`, 
        0.371952258167021998`, 0.62157348218313615`, 0.831784037861858749`, 
        0.954520631698938792`, 0.999103113177188895`, 0.957559405664176921`, 
        0.812632841838091124`, 0.599839866922566322`, 0.383671623459636457`}}
      \)], "Output"]
}, Closed]],

Cell["\<\
Transposing the previous list returns a list of ordered pairs.\
\>",
   "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(final = Transpose[transdata]\)], "Input"],

Cell[BoxData[
    \({{0, 0.00844513988309739893`}, {0.262364264467491059`, 
        0.306362461526602913`}, {0.470003629245735599`, 
        0.607310661167293286`}, {0.641853886172394716`, 
        0.788009572749263398`}, {0.788457360364270254`, 
        0.96066222875598406`}, {0.916290731874155106`, 
        0.999999458951623232`}, {1.02961941718115812`, 
        0.952388420938955171`}, {1.13140211149110059`, 
        0.834715812354962949`}, {1.22377543162211566`, 
        0.621589739975351207`}, {1.30833281965017866`, 
        0.357996759733610758`}, {1.38629436111989058`, 
        0.0819647303442957486`}, {1.45861502269951675`, 
        \(-0.230249881967099767`\)}, {1.52605630349504917`, 
        \(-0.491278794242442984`\)}, {1.589235205116581`, 
        \(-0.743845156621557368`\)}, {1.64865862558738163`, 
        \(-0.875572815621597122`\)}, {1.70474809223842527`, 
        \(-0.981390804950580353`\)}, {1.75785791755237363`, 
        \(-0.992070419493135702`\)}, {1.80828877117926545`, 
        \(-0.918970501104014658`\)}, {1.85629799036562594`, 
        \(-0.753412219870961319`\)}, {1.90210752639692053`, 
        \(-0.504441927965866199`\)}, {1.94591014905531327`, 
        \(-0.207717381875106266`\)}, {1.98787434815434558`, 
        0.0793337137872103781`}, {2.02814824729228515`, 
        0.371952258167021998`}, {2.06686275947297559`, 
        0.62157348218313615`}, {2.10413415427020744`, 
        0.831784037861858749`}, {2.14006616349627076`, 
        0.954520631698938792`}, {2.17475172148416096`, 
        0.999103113177188895`}, {2.20827441352280429`, 
        0.957559405664176921`}, {2.24070968927595837`, 
        0.812632841838091124`}, {2.27212588550933691`, 
        0.599839866922566322`}, {2.3025850929940459`, 0.383671623459636457`}}
      \)], "Output"]
}, Closed]],

Cell["Here is a graph of the transformed data.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(ListPlot[final, PlotJoined -> True]; \)\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.413614 0.307846 0.295473 [
[.23062 .29535 -9 -9 ]
[.23062 .29535 9 0 ]
[.43742 .29535 -3 -9 ]
[.43742 .29535 3 0 ]
[.64423 .29535 -9 -9 ]
[.64423 .29535 9 0 ]
[.85104 .29535 -3 -9 ]
[.85104 .29535 3 0 ]
[.01131 .01237 -12 -4.5 ]
[.01131 .01237 0 4.5 ]
[.01131 .16011 -24 -4.5 ]
[.01131 .16011 0 4.5 ]
[.01131 .45558 -18 -4.5 ]
[.01131 .45558 0 4.5 ]
[.01131 .60332 -6 -4.5 ]
[.01131 .60332 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.23062 .30785 m
.23062 .3141 L
s
[(0.5)] .23062 .29535 0 1 Mshowa
.43742 .30785 m
.43742 .3141 L
s
[(1)] .43742 .29535 0 1 Mshowa
.64423 .30785 m
.64423 .3141 L
s
[(1.5)] .64423 .29535 0 1 Mshowa
.85104 .30785 m
.85104 .3141 L
s
[(2)] .85104 .29535 0 1 Mshowa
.125 Mabswid
.06517 .30785 m
.06517 .3116 L
s
.10653 .30785 m
.10653 .3116 L
s
.14789 .30785 m
.14789 .3116 L
s
.18926 .30785 m
.18926 .3116 L
s
.27198 .30785 m
.27198 .3116 L
s
.31334 .30785 m
.31334 .3116 L
s
.3547 .30785 m
.3547 .3116 L
s
.39606 .30785 m
.39606 .3116 L
s
.47878 .30785 m
.47878 .3116 L
s
.52015 .30785 m
.52015 .3116 L
s
.56151 .30785 m
.56151 .3116 L
s
.60287 .30785 m
.60287 .3116 L
s
.68559 .30785 m
.68559 .3116 L
s
.72695 .30785 m
.72695 .3116 L
s
.76831 .30785 m
.76831 .3116 L
s
.80968 .30785 m
.80968 .3116 L
s
.8924 .30785 m
.8924 .3116 L
s
.93376 .30785 m
.93376 .3116 L
s
.97512 .30785 m
.97512 .3116 L
s
.25 Mabswid
0 .30785 m
1 .30785 L
s
.02381 .01237 m
.03006 .01237 L
s
[(-1)] .01131 .01237 1 0 Mshowa
.02381 .16011 m
.03006 .16011 L
s
[(-0.5)] .01131 .16011 1 0 Mshowa
.02381 .45558 m
.03006 .45558 L
s
[(0.5)] .01131 .45558 1 0 Mshowa
.02381 .60332 m
.03006 .60332 L
s
[(1)] .01131 .60332 1 0 Mshowa
.125 Mabswid
.02381 .04192 m
.02756 .04192 L
s
.02381 .07147 m
.02756 .07147 L
s
.02381 .10101 m
.02756 .10101 L
s
.02381 .13056 m
.02756 .13056 L
s
.02381 .18966 m
.02756 .18966 L
s
.02381 .2192 m
.02756 .2192 L
s
.02381 .24875 m
.02756 .24875 L
s
.02381 .2783 m
.02756 .2783 L
s
.02381 .33739 m
.02756 .33739 L
s
.02381 .36694 m
.02756 .36694 L
s
.02381 .39649 m
.02756 .39649 L
s
.02381 .42603 m
.02756 .42603 L
s
.02381 .48513 m
.02756 .48513 L
s
.02381 .51468 m
.02756 .51468 L
s
.02381 .54422 m
.02756 .54422 L
s
.02381 .57377 m
.02756 .57377 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .31034 m
.13233 .39837 L
.21821 .48729 L
.28929 .54068 L
.34993 .5917 L
.4028 .60332 L
.44967 .58925 L
.49177 .55448 L
.52998 .49151 L
.56495 .41362 L
.5972 .33206 L
.62711 .23981 L
.65501 .16269 L
.68114 .08806 L
.70572 .04914 L
.72892 .01787 L
.75088 .01472 L
.77174 .03631 L
.7916 .08523 L
.81055 .1588 L
.82866 .24647 L
.84602 .33129 L
.86268 .41775 L
.87869 .4915 L
.89411 .55362 L
.90897 .58988 L
.92332 .60305 L
.93718 .59078 L
.9506 .54796 L
.96359 .48508 L
.97619 .42121 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{287, 177.312},
  ImageMargins->{{35, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004O0000/@P10`4000010?ooobl_;oooZZVYZNSX
j?oo05FZZZZZZ_W0RS/k>gYjN[Vi^OShn03ooeGooj[ooonI<c<c<fi^KZf][Nc/k02ZoeFZojZZoonZ
oclo?ginO[fm_Oclo5D00:X00?l00?l0VCLg=g9bL[6a/O3`l03o05Go0:[o00<30d92@X61PL30`000
EED0EJX0EOl0ELbIoc/k>gIfM[Fe]OCdm03oEEGoEJ[oE@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0Z/`c
<clo?gYjN[Vi^OShn03oZUGoZZ[oZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`<30d92@WinO[fm_Ocl
o03ooeGooj[oo`l?3di>CXf=SLc<c01E05EE0:YE0?mE00L71dI6AX61PL30`000EED00:X00?l001<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@/;2dY:BXF5QLC4a000ZUD0EJX0EOl0EALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZPl?3di>CXV9RLS8b000oeD0ZZX0Z_l0ZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEoa<C
4e9BDXf=SLc<c01E05D0ojX0ool0oalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ01LG5eIFEY6ATM3@d01E
EEEE0:YE0?mE02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZEA/K6eYJFYFEUMCDe01EZUEEEJYEEOmEEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZQlO7eiNGYVIVMSHf01EoeEEZZYEZ_mEZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZob<S8f9RHYfMWMcLg02Z05EEojYEoomEobl_;fi^KZf][Nc/k03o05Go0:[o0=gW1RLW
9fIVIZ6QXN3Ph02ZEEFZ0:ZZ0?nZ03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooEB/[:fYZJZFUYNCTi02Z
ZUFZEJZZEOnZECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l080000?l080000?l080000?l080000?l0
80000?l080000?l0800001/000?o0000o`0200004`03o`D000?o0000o`02000050000ol000040003
o`000?l00P0000d01Ol20003o`0000@00_oo00<0000D0003o`0000@000?o0000^`04od80000D0003
o`0000@000?o0000^003o`@000?o0000?`0001<00_l60003o`000;P000?o00001@000ol0000n0000
6`000ol0002g0003o`0000L000?o0000?@0001/000?o0000]P000ol000090003o`0003`0000K0003
o`000;D000?o00002`000ol0000k00006`000ol0002e0003o`0000/000?o0000>`0001/00_ne0003
o`0000d000?o0000>P0001/000?o0000/`000ol0000>0003o`0003X0000K0003o`000;8000?o0000
3`000ol0000j00006`000ol0002b0003o`00010000?o0000>@0001/000?o0000/@000ol0000A0003
o`0003T0000K0003o`000;0000?o00004`000ol0000h00006`000ol0002`0003o`0001<000?o0000
>00001/000?o0000[`000ol0000D0003o`0003P0000K00;o[`000ol0000F0003o`0003L0000K0003
o`000:d000?o00005`000ol0000g00006`000ol0002]0003o`0001L000?o0000=`0001/000?o0000
[0000ol0000I0003o`0003H0000K0003o`000:/000?o00006P000ol0000f00006`000ol0002[0003
o`0001X000?o0000=P0001/000?o0000ZP000ol0000L0003o`0003D0000K0003o`000:X000?o0000
70000ol0000e00006`02oj/000?o000070000ol0000e00006`000ol0002Y0003o`0001d000?o0000
=@0001/000?o0000Z@000ol0000N0003o`0003@0000K0003o`000:T000?o00007P000ol0000d0000
6`000ol0002X0003o`0001l000?o0000=00001/000?o0000Z0000ol0000O0003o`0003@0000K0003
o`000:P000?o000080000ol0000c00006`02ojP000?o00008@000ol0000c00006`000ol0002W0003
o`00024000?o0000<`0001/000?o0000Y`000ol0000Q0003o`0003<0000K0003o`000:H000?o0000
8`000ol0000b00006`000ol0002V0003o`0002<000?o0000<P0001/000?o0000YP000ol0000S0003
o`000380000800;o1002o`<00ol50003o`000:D000?o000090000ol0000b00001`001?l00?l300;o
1P000ol000020003o`000:D000?o00009@000ol0000a000000<0ool00ol01@3o003o00/000?o0000
0P02ojH000?o00009@000ol0000a00001`001?l00?l800?o1@000ol0002T0003o`0002H000?o0000
<@0000L000Co003o20000ol000050003o`000:@000?o00009P000ol0000a00002002o`T01?l40003
o`000:<000?o0000:0000ol0000`00006`000ol0002S0003o`0002P000?o0000<00001/000?o0000
X`000ol0000X0003o`000300000K0003o`000:8000?o0000:@000ol0000`00006`000ol0002R0003
o`0002T000?o0000<00001/00_nS0003o`0002X000?o0000;`0001/000?o0000X@000ol0000[0003
o`0002l0000K0003o`000:4000?o0000:`000ol0000_00006`000ol0002Q0003o`0002/000?o0000
;`0001/000?o0000X0000ol0000]0003o`0002h0000K0003o`000:0000?o0000;@000ol0000^0000
6`000ol0002P0003o`0002d000?o0000;P0001/000?o0000W`000ol0000^0003o`0002h0000K00;o
X0000ol0000^0003o`0002h0000K0003o`0009l000?o0000;`000ol0000]00006`000ol0002N0003
o`00030000?o0000;@0001/000?o0000WP000ol0000`0003o`0002d0000K0003o`0009h000?o0000
<0000ol0000]00006`000ol0002M0003o`00034000?o0000;@0001/000?o0000W@000ol0000b0003
o`0002`0000K0003o`0009d000?o0000<P000ol0000/00006`02oid000?o0000<`000ol0000/0000
6`000ol0002L0003o`0003<000?o0000;00001/000?o0000W0000ol0000d0003o`0002/0000K0003
o`0009/000?o0000=@000ol0000[00006`000ol0002K0003o`0003D000?o0000:`0001/000?o0000
;@02o`@00_l300?o;@03obh00ol400;o0`03ob/000?o00001?lW00006`000ol0000/0004o`00o`<0
0_l60003o`0002/000?o0000;P000ol0000300;o1P000ol0000X0005o`000?l0:@0001/000?o0000
;0001?l00?l;0003o`0002/000?o0000;P000ol0000;0003o`0002T000Go0000o`0X00006`02obd0
00Co003o2003obh000?o0000;P000ol0000800?o;0000ol000020003o`0002D0000K0003o`0002`0
00Co003o20000ol0000^0003o`0002d00_l:0003o`0002`000?o0?l00P000ol0000U00006`000ol0
000]00;o2@04ob`00_l_00;o2P04ob/000?o00000_lX00006`000ol0002I0003o`0003T000?o0000
:@0001/000?o0000V0000ol0000j0003o`0002T0000K0003o`0009P000?o0000>P000ol0000Y0000
6`000ol0002H0003o`0003X000?o0000:@0001D0ool;o`006`02o`T000?o000020000ol000080003
o`0000P000?o000020000ol000080003o`0000P000?o00001`000ol000080003o`0000P000?o0000
20000ol000080003o`0000P000?o00002002o`T000?o000020000ol000080003o`0000P000?o0000
20000ol000060003o`3o00X000?o000020000ol000080003o`0000D0000K0003o`3o03@000?o0000
<`000ol0000Z0003o`0000L000?o0000<P000ol0o`0X00006`001?l00?nE0003o`0003d000?o0000
:00001/000Go0000o`2D0003o`0003d000?o0000:00001/000?o00000P02oi8000?o0000?@000ol0
000X00006`000ol000040003o`0008h000?o0000?`000ol0000W00006`000ol000050003o`0008d0
00?o0000?`000ol0000W00006`02o`L000?o0000S0000ol0000o0003o`0002L0000K0003o`0000L0
0_n;0003o`00040000?o00009`0001/000?o00002@000ol000280003o`00040000?o00009`0001/0
00?o00002P000ol000260003o`00048000?o00009P0001/000?o00002`02ohH000?o0000@P000ol0
000V00006`000ol0000=0003o`0008<000?o0000@P000ol0000V00006`000ol0000>0003o`000840
00?o0000@`000ol0000V00006`000ol0000?0003o`00080000?o0000@`000ol0000V00006`02oa40
0_mo0003o`0004D000?o00009@0001/000?o00004P000ol0001l0003o`0004D000?o00009@0001/0
00?o00004`000ol0001j0003o`0004H000?o00009@0001/000?o000050000ol0001i0003o`0004H0
00?o00009@0001/000?o00005@02ogT000?o0000AP000ol0000U00006`000ol0000G0003o`0007D0
00?o0000A`000ol0000U00006`000ol0000H0003o`0007@000?o0000B0000ol0000T00006`000ol0
000I0003o`00078000?o0000B@000ol0000T00006`02oa/000?o0000L@000ol000190003o`0002@0
000K0003o`0001X000?o0000L0000ol0001:0003o`0002@0000K0003o`0001/000?o0000K`000ol0
001:0003o`0002@0000K0003o`0001`000?o0000KP000ol0001;0003o`0002<0000K0003o`0001d0
00?o0000K0000ol0001<0003o`0002<0000K0003o`0001h000?o0000J`000ol0001<0003o`0002<0
000K0003o`0001l000?o0000J@000ol0001=0003o`0001/000?o00001@0001/000?o000080000ol0
001X0003o`0004d000?o00006`000ol0000500006`02ob8000?o0000IP000ol0001?0003o`0001X0
00?o00001@0001/000?o00008P000ol0001U0003o`0004l000?o00006P000ol0000500006`000ol0
000S0003o`0006@000?o0000C`000ol0000I0003o`0000H0000K0003o`0002@000?o0000HP000ol0
001@0003o`0001T000?o00001P0001/000?o00009@000ol0001Q0003o`00050000?o00006@000ol0
000600002002o`@00_l300?o1@000ol0000U0003o`00060000?o0000DP000ol0000H0003o`0000H0
00070004o`00o`<00_l60003o`00008000?o00009P000ol0001O0003o`00058000?o000060000ol0
000600001`001?l00?l;0003o`0000800_lX0003o`0005d000?o0000D`000ol0000G0003o`0000L0
00070004o`00o`P00ol50003o`0002P000?o0000G0000ol0001C0003o`0001L000?o00001`0000L0
00Co003o20000ol000050003o`0002T000?o0000F`000ol0001C0003o`0001L000?o00001`0000P0
0_l900Co10000ol0000Z0003o`0005T000?o0000E@000ol0000F0003o`0000L0000K0003o`0002/0
00?o0000F0000ol0001E0003o`0001H000?o00001`0001/000?o0000;0000ol0001F0003o`0005H0
00?o00005P000ol0000700006`000ol0000]0003o`0005D000?o0000EP000ol0000E0003o`0000P0
000K0003o`0002h000?o0000D`000ol0001G0003o`0001D000?o0000200001/00_l`0003o`000580
00?o0000F0000ol0000D0003o`0000P0000K0003o`0003000_mB0003o`0005P000?o000050000ol0
000800006`000ol0000b0003o`0004h000?o0000F@000ol0000D0003o`0000P0000K0003o`0003<0
00?o0000C@000ol0001I0003o`0001<000?o00002@0001/000?o0000=002od`000?o0000FP000ol0
000C0003o`0000T0000K0003o`0003H000?o0000B@000ol0001K0003o`00018000?o00002@0001/0
00?o0000=`000ol000170003o`0005`000?o00004P000ol0000900006`000ol0000h00;oAP000ol0
001M0003o`00014000?o00002P0001/00_lk0003o`0004<000?o0000G@000ol0000A0003o`0000X0
000K0003o`0003/00_m20003o`0005l000?o000040000ol0000:00006`000ol0000m0003o`0003l0
00?o0000G`000ol0000@0003o`0000X0000K0003o`0003h000?o0000?@000ol0001P0003o`000100
00?o00002P0001/000?o0000?`02oc`000?o0000H@000ol0000?0003o`0000/0000K0003o`000440
00?o0000>@000ol0001R0003o`0000h000?o00002`0001/000?o0000@P000ol0000g0003o`0006<0
00?o00003P000ol0000;00006`000ol0001300;o=`000ol0001S0003o`0000h000?o00002`0001/0
0_m60003o`0003<000?o0000I0000ol0000=0003o`0000`0000K0003o`0004H000?o0000<@000ol0
001V0003o`0000`000?o0000300001/000?o0000A`000ol0000`0003o`0006H000?o000030000ol0
000<00006`000ol000180003o`0002d00_mY0003o`0000`000?o0000300001/000?o0000B@000ol0
000[0003o`0006X000?o00002P000ol0000=00006`000ol0001:0003o`0002T000?o0000J`000ol0
000:0003o`0000d0000K0003o`0004/00_lX0003o`0006`000?o00002P000ol0000=00006`000ol0
001=0003o`0002<00_m`0003o`0000P000?o00003P0001/00_m?0003o`00024000?o0000L0000ol0
00080003o`0000h0000K0003o`0004l000?o00007`000ol0001b0003o`0000L000?o00003P0001/0
00?o0000D0000ol0000M0003o`0007<000?o00001`000ol0000>00006`000ol0001A0003o`0001/0
00?o0000M0000ol000060003o`0000l0000K0003o`00058000?o00005`03ogP000?o00001@000ol0
000?00006`000ol0001C00?o4`03og`000?o00000`000ol0000@00004`03o`D000?o0000EP05o`/0
0on00005o`000?l04`0001@000?o000010000ol0001K00Go0`03oh@000?o0?l0500001@000?o0000
1002of400on80003o`0001<0000D0003o`0000@000?o0000o`02000050000ol000040003o`000?l0
0P0001<00_l60003o`000?l00P0001/000?o0000o`020000o`0P0000o`0P0000o`0P0000o`0P0000
o`0P0000\
\>"],
  ImageRangeCache->{{{0, 286}, {176.312, 0}} -> {-0.249199, -1.1259, 
  0.00912364, 0.0127716}}]
}, Closed]],

Cell[TextData[{
  "Note that one effect of ",
  StyleBox["Transpose", "Input"],
  " is to reverse the dimensions of a matrix."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Dimensions[mydata]\)], "Input"],

Cell[BoxData[
    \({31, 2}\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Dimensions[Transpose[mydata]]\)], "Input"],

Cell[BoxData[
    \({2, 31}\)], "Output"]
}, Closed]],

Cell["Here are the dimensions of our array of hurricane data.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Dimensions[hurr]\)], "Input"],

Cell[BoxData[
    \({10, 3}\)], "Output"]
}, Closed]],

Cell["\<\
Transposing the array returns a list containing a list of all the \
hurricane names, a list of all the wind speeds, and a list of all the \
pressures.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(transhurr = Transpose[hurr]\)], "Input"],

Cell[BoxData[
    \({{"Allison", "Barry", "Chantal", "Dean", "Erin", "Felix", "Gabrielle", 
        "Humberto", "Iris", "Jerry"}, {65, 50, 60, 40, 75, 115, 60, 90, 75, 
        35}, {987, 995, 992, 999, 975, 950, 998, 970, 970, 1003}}\)], "Output"]
}, Closed]],

Cell["\<\
Given the transformed list, we can obtain ordered pairs of wind \
speeds and pressures by first extracting the respective lists.\
\>", "Text"],

Cell[CellGroupData[{

Cell["transhurr[[{2, 3}]]", "Input"],

Cell[BoxData[
    \({{65, 50, 60, 40, 75, 115, 60, 90, 75, 35}, {987, 995, 992, 999, 975, 
        950, 998, 970, 970, 1003}}\)], "Output"]
}, Closed]],

Cell["\<\
Next we transpose the previous list to obtain the desired \
pairs.\
\>", "Text"],

Cell[CellGroupData[{

Cell["hurrpairs = Transpose[ transhurr[[{2, 3}]] ]", "Input"],

Cell[BoxData[
    \({{65, 987}, {50, 995}, {60, 992}, {40, 999}, {75, 975}, {115, 950}, {
        60, 998}, {90, 970}, {75, 970}, {35, 1003}}\)], "Output"]
}, Closed]],

Cell[TextData[{
  "The data are now in a form to be plotted using ",
  StyleBox["ListPlot", "Input"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell["\<\
ListPlot[ hurrpairs,

\tFrameLabel->{\"Wind Speed\", \"Pressure\"},
\tPlotLabel->
\t\tStyleForm[\"1995 Tropical Storm Data\",
\t\t\tFontFamily->\"Helvetica\", FontSize-> 10],
\tPlotStyle->PointSize[0.02],
\tFrame->True, RotateLabel->True,
\tTextStyle->{FontSize->9} ];\
\>", "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.392857 0.0119048 -10.5357 0.0111057 [
[.08333 -0.0125 -7 -14 ]
[.08333 -0.0125 7 0 ]
[.32143 -0.0125 -7 -14 ]
[.32143 -0.0125 7 0 ]
[.55952 -0.0125 -7 -14 ]
[.55952 -0.0125 7 0 ]
[.79762 -0.0125 -9.5 -14 ]
[.79762 -0.0125 9.5 0 ]
[ 0 0 -0.125 0 ]
[.5 -0.0125 -27.1875 -28 ]
[.5 -0.0125 27.1875 -14 ]
[-0.0125 .01472 -19 -7 ]
[-0.0125 .01472 0 7 ]
[-0.0125 .12577 -19 -7 ]
[-0.0125 .12577 0 7 ]
[-0.0125 .23683 -19 -7 ]
[-0.0125 .23683 0 7 ]
[-0.0125 .34789 -19 -7 ]
[-0.0125 .34789 0 7 ]
[-0.0125 .45894 -19 -7 ]
[-0.0125 .45894 0 7 ]
[-0.0125 .57 -24 -7 ]
[-0.0125 .57 0 7 ]
[ 0 0 -0.125 0 ]
[-0.01875 .30902 -38 -22 ]
[-0.01875 .30902 -24 22 ]
[ 0 .61803 .125 0 ]
[ 1 0 .125 0 ]
[.5 .63053 -57.2188 0 ]
[.5 .63053 57.2188 14 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.08333 0 m
.08333 .00625 L
s
gsave
.08333 -0.0125 -52 -18 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 22 translate 1 -1 scale
47.000000 14.000000 moveto
/Courier findfont 9.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(40) show
1.000000 setlinewidth
grestore
.32143 0 m
.32143 .00625 L
s
gsave
.32143 -0.0125 -52 -18 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 22 translate 1 -1 scale
47.000000 14.000000 moveto
/Courier findfont 9.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(60) show
1.000000 setlinewidth
grestore
.55952 0 m
.55952 .00625 L
s
gsave
.55952 -0.0125 -52 -18 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 22 translate 1 -1 scale
47.000000 14.000000 moveto
/Courier findfont 9.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(80) show
1.000000 setlinewidth
grestore
.79762 0 m
.79762 .00625 L
s
gsave
.79762 -0.0125 -54.5 -18 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 22 translate 1 -1 scale
47.000000 14.000000 moveto
/Courier findfont 9.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(100) show
1.000000 setlinewidth
grestore
.125 Mabswid
.14286 0 m
.14286 .00375 L
s
.20238 0 m
.20238 .00375 L
s
.2619 0 m
.2619 .00375 L
s
.38095 0 m
.38095 .00375 L
s
.44048 0 m
.44048 .00375 L
s
.5 0 m
.5 .00375 L
s
.61905 0 m
.61905 .00375 L
s
.67857 0 m
.67857 .00375 L
s
.7381 0 m
.7381 .00375 L
s
.02381 0 m
.02381 .00375 L
s
.85714 0 m
.85714 .00375 L
s
.91667 0 m
.91667 .00375 L
s
.97619 0 m
.97619 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
gsave
.5 -0.0125 -72.1875 -32 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 22 translate 1 -1 scale
47.000000 14.000000 moveto
/Courier findfont 9.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(Wind) show
72.187500 14.000000 moveto
(Speed) show
1.000000 setlinewidth
grestore
0 .01472 m
.00625 .01472 L
s
gsave
-0.0125 .01472 -64 -11 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 22 translate 1 -1 scale
47.000000 14.000000 moveto
/Courier findfont 9.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(950) show
1.000000 setlinewidth
grestore
0 .12577 m
.00625 .12577 L
s
gsave
-0.0125 .12577 -64 -11 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 22 translate 1 -1 scale
47.000000 14.000000 moveto
/Courier findfont 9.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(960) show
1.000000 setlinewidth
grestore
0 .23683 m
.00625 .23683 L
s
gsave
-0.0125 .23683 -64 -11 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 22 translate 1 -1 scale
47.000000 14.000000 moveto
/Courier findfont 9.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(970) show
1.000000 setlinewidth
grestore
0 .34789 m
.00625 .34789 L
s
gsave
-0.0125 .34789 -64 -11 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 22 translate 1 -1 scale
47.000000 14.000000 moveto
/Courier findfont 9.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(980) show
1.000000 setlinewidth
grestore
0 .45894 m
.00625 .45894 L
s
gsave
-0.0125 .45894 -64 -11 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 22 translate 1 -1 scale
47.000000 14.000000 moveto
/Courier findfont 9.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(990) show
1.000000 setlinewidth
grestore
0 .57 m
.00625 .57 L
s
gsave
-0.0125 .57 -69 -11 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 22 translate 1 -1 scale
47.000000 14.000000 moveto
/Courier findfont 9.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(1000) show
1.000000 setlinewidth
grestore
.125 Mabswid
0 .03693 m
.00375 .03693 L
s
0 .05914 m
.00375 .05914 L
s
0 .08135 m
.00375 .08135 L
s
0 .10356 m
.00375 .10356 L
s
0 .14798 m
.00375 .14798 L
s
0 .1702 m
.00375 .1702 L
s
0 .19241 m
.00375 .19241 L
s
0 .21462 m
.00375 .21462 L
s
0 .25904 m
.00375 .25904 L
s
0 .28125 m
.00375 .28125 L
s
0 .30346 m
.00375 .30346 L
s
0 .32568 m
.00375 .32568 L
s
0 .3701 m
.00375 .3701 L
s
0 .39231 m
.00375 .39231 L
s
0 .41452 m
.00375 .41452 L
s
0 .43673 m
.00375 .43673 L
s
0 .48116 m
.00375 .48116 L
s
0 .50337 m
.00375 .50337 L
s
0 .52558 m
.00375 .52558 L
s
0 .54779 m
.00375 .54779 L
s
0 .59221 m
.00375 .59221 L
s
0 .61442 m
.00375 .61442 L
s
.25 Mabswid
0 0 m
0 .61803 L
s
gsave
-0.01875 .30902 -98 -11 Mabsadd m
1 1 Mabs scale
currentpoint translate
67 11 translate
90 rotate
-67 -11 translate
0 22 translate 1 -1 scale
47.000000 14.000000 moveto
/Courier findfont 9.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(Pressure) show
1.000000 setlinewidth
grestore
.08333 .61178 m
.08333 .61803 L
s
.32143 .61178 m
.32143 .61803 L
s
.55952 .61178 m
.55952 .61803 L
s
.79762 .61178 m
.79762 .61803 L
s
.125 Mabswid
.14286 .61428 m
.14286 .61803 L
s
.20238 .61428 m
.20238 .61803 L
s
.2619 .61428 m
.2619 .61803 L
s
.38095 .61428 m
.38095 .61803 L
s
.44048 .61428 m
.44048 .61803 L
s
.5 .61428 m
.5 .61803 L
s
.61905 .61428 m
.61905 .61803 L
s
.67857 .61428 m
.67857 .61803 L
s
.7381 .61428 m
.7381 .61803 L
s
.02381 .61428 m
.02381 .61803 L
s
.85714 .61428 m
.85714 .61803 L
s
.91667 .61428 m
.91667 .61803 L
s
.97619 .61428 m
.97619 .61803 L
s
.25 Mabswid
0 .61803 m
1 .61803 L
s
.99375 .01472 m
1 .01472 L
s
.99375 .12577 m
1 .12577 L
s
.99375 .23683 m
1 .23683 L
s
.99375 .34789 m
1 .34789 L
s
.99375 .45894 m
1 .45894 L
s
.99375 .57 m
1 .57 L
s
.125 Mabswid
.99625 .03693 m
1 .03693 L
s
.99625 .05914 m
1 .05914 L
s
.99625 .08135 m
1 .08135 L
s
.99625 .10356 m
1 .10356 L
s
.99625 .14798 m
1 .14798 L
s
.99625 .1702 m
1 .1702 L
s
.99625 .19241 m
1 .19241 L
s
.99625 .21462 m
1 .21462 L
s
.99625 .25904 m
1 .25904 L
s
.99625 .28125 m
1 .28125 L
s
.99625 .30346 m
1 .30346 L
s
.99625 .32568 m
1 .32568 L
s
.99625 .3701 m
1 .3701 L
s
.99625 .39231 m
1 .39231 L
s
.99625 .41452 m
1 .41452 L
s
.99625 .43673 m
1 .43673 L
s
.99625 .48116 m
1 .48116 L
s
.99625 .50337 m
1 .50337 L
s
.99625 .52558 m
1 .52558 L
s
.99625 .54779 m
1 .54779 L
s
.99625 .59221 m
1 .59221 L
s
.99625 .61442 m
1 .61442 L
s
.25 Mabswid
1 0 m
1 .61803 L
s
gsave
.5 .63053 -102.219 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 22 translate 1 -1 scale
47.000000 14.000000 moveto
/Helvetica findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(1995) show
70.125000 14.000000 moveto
(Tropical) show
107.125000 14.000000 moveto
(Storm) show
137.125000 14.000000 moveto
(Data) show
1.000000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.02 w
.38095 .42563 Mdot
.20238 .51447 Mdot
.32143 .48116 Mdot
.08333 .5589 Mdot
.5 .29236 Mdot
.97619 .01472 Mdot
.32143 .54779 Mdot
.67857 .23683 Mdot
.5 .23683 Mdot
.02381 .60332 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{35, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/@P10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[oooclo5H/1EGooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00000EED0EJX00=d81Slo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0ZP00
oeD0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l08@000?l08@000?l08@000:T00_me0000
Z@000ol0001d0000S0000ol0o`0200?o00D0o`00o`0200Co1@03o`800ol300?o0P03o`801?mS0000
S0000ol0o`030004o`00o`8000?o0?l00P000ol000040006o`00o`3o0P001?l0ool300;o0`001?l0
0?mT0000S0000ol0o`030004o`00o`8000?o0?l00P000ol000070003o`3o008000Co0?l00_l00`3o
0002o`050?l00?l0I00008/000Ko0?l0o`02o`800ol300?o1`02o`800ol300;o0`02o`<00omT0000
R`001Ol0o`3o00d000?o000010001?l00?lC0003o`000680002;0005o`3o0?l00P000ol0000700;o
1`03oa800_mT0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000
BP000ol00002ob/00_l300;o:`02o`<00_lY00?o0P02o`<00_lh0000BP000ol0o`020003o`0002L0
00Ko003o0?l20003o`0002L000Ko003o0?l20003o`0002L000Co003o0P000ol0o`020003o`0003D0
001700Co00D0o`00o`0Y0006o`00o`3o0P000ol0000W0006o`00o`3o0P000ol0000W0004o`00o`80
00?o0?l00P000ol0000e0000B0001Ol0o`3o008000?o00009`03o`8000Co003o:P02o`8000Co003o
:@001?l00?l20003o`3o008000?o0000=@0004T00_l01@3o003o02X000Go0000o`020003o`0002L0
00Ko003o0?l20003o`0002L000Co003o0P000ol0o`020003o`0003D0001:0003o`0000;o;0001?l0
0002ob/00_l300;o:@02o`<00_l300;o>0000?l08@000?l08@000?l08@000?l08@000?l08@0003/0
dolB0000:0000ol0000200;o0`02o`L000?o00000P000ol000090003o`0000X000?o00002@000ol0
000:0003o`0000T000?o00002P000ol000090003o`0000X000?o00002@000ol0000:0003o`0000T0
00?o00002P000ol000090003o`0000X000?o00002@000ol0000:0003o`00008000?o0000400002T0
00Co003o0P000ol0o`020003o`0000@000?o0000b@02o`@000?o0000400002P00ol40003o`3o0080
00?o00001002olT01?l200;o4P0002L000Go003o0003o`8000Co003o1P000ol0003800Co0`000ol0
000@00009`001_l00?l0o`@000Co003o1P000ol0003900;o10000ol0000@0000:002o`801?l200;o
1`000ol0003?0003o`000100000k0003o`000<l000?o0000400003/00_o?00;o4P0003/000?o0000
c`000ol0000@0000>`000ol0003?0003o`000100000k0003o`000<l000?o0000400003/000?o0000
c`000ol0000@0000>`02oll00_lB0000>`000ol0003?0003o`000100000k0003o`000<l000?o0000
400003/000?o0000c`000ol0000@0000>`02oll00_lB0000>`000ol0003?0003o`000100000k0003
o`000<l000?o0000400003/000?o0000c`000ol0000@0000>`000ol0003?0003o`000100000k00;o
c`02oa80000k0003o`000<l000?o0000400003/000?o0000c`000ol0000@0000:0000ol0000200;o
0`02o`L000?o0000c`000ol0000@0000:@001?l00?l20003o`3o008000?o000010000ol0003?0003
o`000100000X00?o00L0o`00o`3o008000?o00001002oll00_lB00009`001Ol00?l000?o0P001?l0
0?l60003o`000<l000?o0000400002L000Co003o0P001Ol0003o008000?o000010000ol0003?0003
o`000100000X00;o10001?l00002o`L000?o0000c`000ol0000@0000>`02oll00_lB0000>`000ol0
003?0003o`000100000k0003o`000<l000?o0000400003/000?o0000c`000ol0000@0000>`000ol0
003?0003o`000100000k00;oc`02oa80000k0003o`000<l000?o0000400003/000?o0000c`000ol0
000@0000>`000ol0003?0003o`000100000k0003o`000<l000?o0000400003/00_o?00;o4P0003/0
00?o0000c`000ol0000@0000>`000ol0003?0003o`000100000k0003o`000<l000?o0000400003/0
0_o?00;o4P0001/00ol200?o0`03o`040?ooo`800ol300?o00@0oooo0`03ol/000?o0000400001`0
00?o00000P001?l00002o`D00_l300;o00D0o`00o`0200;o0P02old000?o0000400001`00_l30006
o`000?l00_l01P3oo`3o00;o00@0oooo0P000ol00002o`8000Co0?ooH@02ob@00_m20003o`000100
000L0006o`3o0?l00_l200;o00<0o`000ol200?o00P0o`00o`3o00;o0P02of401?lR00Co@@000ol0
000@000070000ol0o`0900?o0`001?l00?l20003o`0000@00_mU00Co8P04od000_lB00006`03o`T0
00Co003o0`001?l00?l20003o`0000@000?o0000I@02ob@00_m20003o`000100000W0006o`00o`3o
0P000ol0o`020003o`0000@000?o0000c`000ol0000@0000:002o`801?l200;o1`000ol0003?0003
o`000100000k0003o`000<l000?o0000400003/00_o?00;o4P0003/000?o0000c`000ol0000@0000
>`000ol0003?0003o`000100000k0003o`000<l000?o0000400003/00_o?00;o4P0003/000?o0000
I@02ofP000?o0000400003/000?o0000I004ofL000?o0000400003/000?o0000I004ofL000?o0000
400003/000?o0000I@02ofP000?o0000400003/00_o?00;o4P0003/000?o0000c`000ol0000@0000
>`000ol0003?0003o`000100000k0003o`000<l000?o0000400003/000?o0000c`000ol0000@0000
>`02oll00_lB0000>`000ol0003?0003o`000100000X0003o`0000800_l300;o1`000ol0003?0003
o`000100000Y0004o`00o`8000?o0?l00P000ol000040003o`000<l000?o0000400002P00ol01`3o
003o0?l00P000ol0000400;oc`02oa80000W0004o`00o`800_l20004o`00o`H000?o0000c`000ol0
000@00009`001_l00?l0o`8000?o0?l00P000ol000040003o`000<l000?o0000400002P00_l300;o
0`02o`L000?o0000c`000ol0000@0000>`000ol0003?0003o`000100000k00;oc`02oa80000k0003
o`000<l000?o0000400003/000?o0000c`000ol0000@0000>`000ol0003?0003o`000100000k0003
o`000<l000?o0000400003/00_o?00;o4P0003/000?o0000c`000ol0000@0000>`000ol0003?0003
o`000100000k0003o`000<l000?o0000400003/00_o?00;o4P0003/000?o0000C002oh4000?o0000
400003/000?o0000B`04oh0000?o0000400003/000?o0000B`04oh0000?o0000400003/000?o0000
C002oh4000?o0000400003/00_o?00;o4P0003/000?o0000c`000ol0000@0000:0000ol000020003
o`0000800_l70003o`000<l000?o0000400002T000?o00000P001?l00?l20003o`0000@000?o0000
c`000ol0000@0000:003o`800ol01@3o003o00H00_o?00;o4P0002L000Ko003o0?l20003o`3o0080
00?o000010000ol0003?0003o`000100000W0006o`00o`3o0P000ol0o`020003o`0000@000?o0000
c`000ol0000@0000:002o`<00_l300;o1`000ol0003?0003o`000100000k0003o`0004000_n=0003
o`000100000k00;o@004oh/00_lB0000>`000ol0000o00CoS0000ol0000@0000>`000ol0001000;o
S@000ol0000@0000>`000ol0003?0003o`000100000k0003o`000<l000?o0000400003/00_o?00;o
4P0003/000?o00009`02ojH000?o0000400003/000?o00009P04ojD000?o0000400003/000?o0000
9P04ojD000?o0000400003/00_lX00;oY@02oa80000k0003o`000<l000?o0000400003/000?o0000
c`000ol0000@0000>`000ol0003?0003o`000100000k0003o`0004000_n=0003o`000100000k00;o
@004oh/00_lB0000>`000ol0000>00;o;`04oh`000?o0000400003/000?o00003@04obl00_n=0003
o`000100000S00?o0P02o`<00_l300;o1`000ol0000=00Co_P000ol0000@000090001?l00?l20003
o`3o008000?o0?l00P000ol000040003o`0000h00_no0003o`000100000T0004o`00o`8000?o0?l0
0P000ol0o`020003o`0000@00_o?00;o4P0002@000Co003o0P000ol0o`020003o`3o008000?o0000
10000ol0003?0003o`000100000T0004o`00o`8000?o0?l00P000ol0o`020003o`0000@000?o0000
c`000ol0000@00008`02o`<00_l300;o0`02o`L000?o0000c`000ol0000@0000>`02oll00_lB0000
>`001?l00002ol`000?o0000400003/000?o00001?o;0003o`000100000k0003o`0000Cob`000ol0
000@0000>`001?l00002ol`000?o0000400003/00_l30003o`0000T000?o00002P000ol000090003
o`0000X000?o00002@000ol0000:0003o`0000T000?o00002P000ol000090003o`0000X000?o0000
2@000ol0000:0003o`0000T000?o00002P000ol000090003o`0000X000Co00000_lB0000>`3Coa80
003o0240003o0240003o0240003o0240002D0003o`0008T0002D0003o`0008T0001`0003o`000080
0ol300?o0`03o`<000Go0000o`0300?o0P001?l0ool20003o`0000;o0`02o`040?l0o`<01?l30003
o`0000?o0P001Ol0003o008000Co003o0`04o`@00_l01@3o003o00800_l00`3o00120000L0001Ol0
003o00<000?o0?l00`000ol0o`030004o`00o`<000Co003o0`001?l0ool20005o`3o0?l00P000ol0
o`020004o`00o`8000?o00000P000ol0o`020007o`000?l0o`030004o`00o`8000Go0000o`030004
o`00o`8000Co003o0P001?l00?m40000L0000ol000050003o`0000<000?o00000`001?l00?l30004
o`00o`<000?o0?l00`001Ol0o`3o00@000Co003o0P001?l00?l40003o`3o008000Oo0000o`3o00<0
00Co003o0P001Ol0003o00@000?o0?l00P001?l00?l20004o`00od@0001`0003o`0000801?l200Co
1@001?l00?l30004o`00o`<000?o0?l00`001Ol0o`3o00D00ol20003o`0000D000?o0?l00P001ol0
003o0?l00`001?l00?l20005o`000?l010000ol00003o`8000Co00000om40000L0001Ol0003o00<0
00?o0?l00`000ol0o`03o`<000Co00000_l00`3o00020004o`3oo`8000Go0?l0o`020003o`3o0080
00Co003o0`04o`8000Co003o0`001?l0ool20004o`00o`8000Go0000o`040003o`3o008000Co003o
0P001?l00?m40000K`02o`<000Oo0000o`3o00<000?o0?l01P002?l0003o0?l00ol20004o`3oo`80
00?o00000_l300;o0`001?l00?l500?o0P03o`8000Co0?l00ol00`3oo`040003o`00008000?o0000
0_l200?o0P02odD0001`0003o`0000800ol300?o0P05o`8000?o00007@001?l00?l40003o`3o01H0
00Go0000o`080003o`0004P0002500Go40000ol0000:0004o`0000Co0P000ol0000D00Co2@000ol0
00180000o`0Q0000o`0Q0000
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {9.18923, 935.534, 0.400296, 
  0.429098}}]
}, Closed]],

Cell[TextData[{
  "See also ",
  StyleBox["Split", "Input"],
  ", ",
  StyleBox["FlattenAt", "Input"],
  ", ",
  StyleBox["Inner", "Input"],
  ", ",
  StyleBox["Outer", "Input"],
  ", ",
  StyleBox["Thread", "Input"]
}], "SeeAlso"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Exercises: List Structure", "Subsection",
  PageBreakAbove->True],

Cell[TextData[{
  "Define a function ",
  StyleBox["percentageOfPrimes", "Input"],
  " that returns the percentage of prime numbers in a list."
}], "Question"],

Cell[TextData[{
  "To determine the percentage of primes in a list, we divide the number of \
primes by the length of the list. One way to determine the number of primes \
in a list is to use ",
  StyleBox["Length", "Input"],
  " and ",
  StyleBox["Select", "Input"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Length[Select[Range[100], PrimeQ]]\)], "Input"],

Cell[BoxData[
    \(25\)], "Output"]
}, Closed]],

Cell[TextData[{
  "A more straightforward method is to use ",
  StyleBox["Count", "Input"],
  " and the conditional pattern ",
  StyleBox["_?PrimeQ", "Input"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Count[Range[100], _?PrimeQ]\)], "Input"],

Cell[BoxData[
    \(25\)], "Output"]
}, Closed]],

Cell[TextData[{
  "Here is a definition of ",
  StyleBox["percentageOfPrimes", "Input"],
  "."
}], "Text"],

Cell[BoxData[
    \(percentageOfPrimes[\[ScriptCapitalP]_List] := 
      Length[Select[\[ScriptCapitalP], PrimeQ]]/Length[\[ScriptCapitalP]]\)], 
  "Input"],

Cell["\<\
Here is the percentage of primes in a list of integers from 1 to \
100.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(percentageOfPrimes[Range[100]]\)], "Input"],

Cell[BoxData[
    \(1\/4\)], "Output"]
}, Closed]],

Cell["\<\
Here is the percentage of primes in a list of odd numbers from 1 to \
100.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(percentageOfPrimes[Range[1, 100, 2]]\)], "Input"],

Cell[BoxData[
    \(12\/25\)], "Output"]
}, Closed]],

Cell["Generate the following list.", "Question"],

Cell[BoxData[
    \(\(pts = Table[{r\ Cos[r], r\ Sin[r]}, {r, 0.0, 25.0, 0.25}]; \)\)], 
  "Input"],

Cell[TextData[{
  "Find the maximum ",
  StyleBox["x",
    FontSlant->"Italic"],
  "-value. Find the minimum ",
  StyleBox["y",
    FontSlant->"Italic"],
  "-value."
}], "Text",
  FontWeight->"Bold"],

Cell[TextData[{
  "To extract the list of ",
  StyleBox["x",
    FontSlant->"Italic"],
  "-values, we take the first part of the transpose of ",
  StyleBox["pts", "Input"],
  ". Once the list of ",
  StyleBox["x",
    FontSlant->"Italic"],
  "-values has been extracted, we use ",
  StyleBox["Max", "Input"],
  " to determine the maximum."
}], "Text"],

Cell[CellGroupData[{

Cell["Max[ Transpose[pts][[1]] ]", "Input"],

Cell[OutputFormData["\<\
24.78007029658683995\
\>", 
"\<\
24.7801\
\>"], "Output"]
}, Closed]],

Cell[TextData[{
  "We follow a similar process to determine the minimum of the ",
  StyleBox["y",
    FontSlant->"Italic"],
  "-values."
}], "Text"],

Cell[CellGroupData[{

Cell["Min[ Transpose[pts][[2]] ]", "Input"],

Cell[OutputFormData["\<\
-23.45492765751581235\
\>", 
"\<\
-23.4549\
\>"], "Output"]
}, Closed]],

Cell[" ", "EndExercises"]
}, Closed]],

Cell[CellGroupData[{

Cell["Sorting and Grouping Data", "Subsection",
  CellTags->"Rearranging List Elements"],

Cell[TextData[{
  StyleBox["Sort", "Input"],
  " sorts a list of numbers into increasing order."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Sort[{1, 3, 5, 7, 9, 2, 4, 6, 8}]\)], "Input"],

Cell[BoxData[
    \({1, 2, 3, 4, 5, 6, 7, 8, 9}\)], "Output"]
}, Closed]],

Cell[TextData[{
  "We can specify a function that determines if two adjacent elements are \
sorted. Here we tell ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " to sort a list of numbers in decreasing order, by specifying that two \
elements are sorted if they satisfy the function ",
  StyleBox["Greater", "Input"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Sort[{1, 3, 5, 7, 9, 2, 4, 6, 8}, Greater]\)], "Input"],

Cell[BoxData[
    \({9, 8, 7, 6, 5, 4, 3, 3, 2, 1}\)], "Output"]
}, Closed]],

Cell["\<\
When working with multidimensional data, it is often necessary to \
explicitly define a sorting function. Here is our list of hurricane \
data.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(hurr\)], "Input"],

Cell[BoxData[
    \({{"Allison", 65, 987}, {"Barry", 50, 995}, {"Chantal", 60, 992}, {
        "Dean", 40, 999}, {"Erin", 75, 975}, {"Felix", 115, 950}, {
        "Gabrielle", 60, 998}, {"Humberto", 90, 970}, {"Iris", 75, 970}, {
        "Jerry", 35, 1003}}\)], "Output"]
}, Closed]],

Cell[TextData[{
  "To sort the list in ascending order of wind speed, we first define a \
sorting function as follows. The function returns ",
  StyleBox["True", "Input"],
  " if the second element (the wind speed) of one record is greater than the \
second element of another."
}], "Text"],

Cell[BoxData[
    \(hurrSort[rec1_, rec2_] := rec1[\([2]\)] < rec2[\([2]\)]\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Sort[hurr, hurrSort] // TableForm\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {\("Jerry"\), "35", "1003"},
          {\("Dean"\), "40", "999"},
          {\("Barry"\), "50", "995"},
          {\("Gabrielle"\), "60", "998"},
          {\("Chantal"\), "60", "992"},
          {\("Allison"\), "65", "987"},
          {\("Iris"\), "75", "970"},
          {\("Erin"\), "75", "975"},
          {\("Humberto"\), "90", "970"},
          {\("Felix"\), "115", "950"}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Closed]],

Cell[TextData[{
  "Here is a pure sorting function equivalent to ",
  StyleBox["hurrSort", "Input"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Sort[hurr, #1[\([2]\)] < #2[\([2]\)]&] // TableForm\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {\("Jerry"\), "35", "1003"},
          {\("Dean"\), "40", "999"},
          {\("Barry"\), "50", "995"},
          {\("Gabrielle"\), "60", "998"},
          {\("Chantal"\), "60", "992"},
          {\("Allison"\), "65", "987"},
          {\("Iris"\), "75", "970"},
          {\("Erin"\), "75", "975"},
          {\("Humberto"\), "90", "970"},
          {\("Felix"\), "115", "950"}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Closed]],

Cell[TextData[{
  StyleBox["Split", "Input"],
  " partitions a list into sublists that have identical elements. Here is a \
list of results from tossing a coin twenty times."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(tosses = Table[If[Random[] < 0.5, "\<H\>", "\<T\>"], {20}]\)], "Input"],

Cell[BoxData[
    \({"H", "T", "T", "H", "T", "T", "T", "H", "H", "H", "H", "T", "T", "H", 
      "H", "H", "H", "H", "T", "T"}\)], "Output"]
}, Closed]],

Cell[TextData[{
  StyleBox["Split", "Input"],
  " divides the list into lists of runs."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(runs = Split[tosses]\)], "Input"],

Cell[BoxData[
    \({{"H"}, {"T", "T"}, {"H"}, {"T", "T", "T"}, {"H", "H", "H", "H"}, {"T", 
        "T"}, {"H", "H", "H", "H", "H"}, {"T", "T"}}\)], "Output"]
}, Closed]],

Cell[TextData[{
  "By mapping the function ",
  StyleBox["Length", "Input"],
  " over the results of ",
  StyleBox["Split", "Input"],
  ", we can compute the length of each run of heads or tails."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Map[Length, runs]\)], "Input"],

Cell[BoxData[
    \({1, 2, 1, 3, 4, 2, 5, 2}\)], "Output"]
}, Closed]],

Cell[TextData[{
  "As an extension of the previous example, we generate a list containing \
pairs of the form (",
  StyleBox["result",
    FontSlant->"Italic"],
  ",\[NonBreakingSpace]",
  StyleBox["length\[NonBreakingSpace]of run",
    FontSlant->"Italic"],
  ")."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Map[{First[#], Length[#]}&, runs]\)], "Input"],

Cell[BoxData[
    \({{"H", 1}, {"T", 2}, {"H", 1}, {"T", 3}, {"H", 4}, {"T", 2}, {"H", 5}, {
        "T", 2}}\)], "Output"]
}, Closed]],

Cell[TextData[{
  "This is called ",
  StyleBox["run length encoding",
    FontSlant->"Italic"],
  "."
}], "Text"],

Cell[TextData[{
  "See also ",
  StyleBox["Partition", "Input"],
  ", ",
  StyleBox["Permutations",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  ", ",
  StyleBox["Reverse", "Input"],
  ", ",
  StyleBox["OrderedQ", "Input"],
  ", ",
  StyleBox["Order", "Input"],
  ", ",
  StyleBox["RotateLeft", "Input"],
  ", ",
  StyleBox["RotateRight", "Input"],
  ", ",
  StyleBox["DiscreteMath`Combinatorica`", "Input"],
  " "
}], "SeeAlso"]
}, Closed]],

Cell[CellGroupData[{

Cell["Exercises: Sorting and Grouping Data", "Subsection",
  PageBreakAbove->True],

Cell[TextData[{
  "Using ",
  StyleBox["RotateRight", "Input"],
  ", compute the first differences of a list of data."
}], "Question"],

Cell["Here is a list of data generated from a quadratic curve.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(quaddata = Table[n\^2 - 5\ n + 1, {n, 0, 10}]\)], "Input"],

Cell[BoxData[
    \({1, \(-3\), \(-5\), \(-5\), \(-3\), 1, 7, 15, 25, 37, 51}\)], "Output"]
}, Closed]],

Cell["\<\
We compute the first difference by rotating each element of the \
list of data one position to the right, and subtracting the rotated list from \
the original list. Here is the list of first differences.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(quaddata - RotateRight[quaddata]\)], "Input"],

Cell[BoxData[
    \({\(-50\), \(-4\), \(-2\), 0, 2, 4, 6, 8, 10, 12, 14}\)], "Output"]
}, Closed]],

Cell[TextData[{
  "The first element of the subtracted list is meaningless (the first element \
of the original list minus the last element of the original list), so we use \
",
  StyleBox["Drop",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " to remove it."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Drop[%, 1]\)], "Input"],

Cell[BoxData[
    \({\(-4\), \(-2\), 0, 2, 4, 6, 8, 10, 12, 14}\)], "Output"]
}, Closed]],

Cell["\<\
Extract the five largest elements from a list of random \
numbers.\
\>", "Question"],

Cell["Here is a list of random numbers.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(randomdata = Table[Random[], {15}]\)], "Input"],

Cell[BoxData[
    \({0.666687236805076555`, 0.313322232136227896`, 0.0327653398314601762`, 
      0.791487042709144184`, 0.603896896336227673`, 0.966622450296981661`, 
      0.389777670511362117`, 0.0754428647336257274`, 0.514743728755546303`, 
      0.13704234739816099`, 0.242962016543816838`, 0.215764756077152508`, 
      0.714666535719097772`, 0.339252255385974166`, 0.706117091494693926`}\)],
   "Output"]
}, Closed]],

Cell[TextData[{
  StyleBox["Sort", "Input"],
  " arranges a list into ascending order."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Sort[randomdata]\)], "Input"],

Cell[BoxData[
    \({0.0327653398314601762`, 0.0754428647336257274`, 0.13704234739816099`, 
      0.215764756077152508`, 0.242962016543816838`, 0.313322232136227896`, 
      0.339252255385974166`, 0.389777670511362117`, 0.514743728755546303`, 
      0.603896896336227673`, 0.666687236805076555`, 0.706117091494693926`, 
      0.714666535719097772`, 0.791487042709144184`, 0.966622450296981661`}\)],
   "Output"]
}, Closed]],

Cell["\<\
To extract the five largest elements in the original list, we \
extract the last five elements from the sorted list.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Take[%, \(-5\)]\)], "Input"],

Cell[BoxData[
    \({0.666687236805076555`, 0.706117091494693926`, 0.714666535719097772`, 
      0.791487042709144184`, 0.966622450296981661`}\)], "Output"]
}, Closed]],

Cell[TextData[{
  "Define a function called ",
  StyleBox["runEncode", "Input"],
  " that takes a list of discrete random data and converts it into lists of \
the form (",
  StyleBox["element",
    FontSlant->"Italic"],
  ", ",
  StyleBox["length of run",
    FontSlant->"Italic"],
  "). Define a function called ",
  StyleBox["runDecode", "Input"],
  " that reconstructs a list resulting from ",
  StyleBox["runEncode", "Input"],
  "."
}], "Question"],

Cell["Here is some coin-tossing data taken from the discussion.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(tosses = Table[If[Random[] < 0.5, "\<H\>", "\<T\>"], {20}]\)], "Input"],

Cell[BoxData[
    \({"H", "H", "H", "H", "H", "H", "H", "T", "T", "T", "H", "T", "H", "H", 
      "T", "T", "T", "H", "T", "T"}\)], "Output"]
}, Closed]],

Cell[BoxData[
    \(runEncode[\[ScriptCapitalL]_List] := 
      Map[{First[#], Length[#]}&, Split[\[ScriptCapitalL]]]\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(td = runEncode[tosses]\)], "Input"],

Cell[BoxData[
    \({{"H", 7}, {"T", 3}, {"H", 1}, {"T", 1}, {"H", 2}, {"T", 3}, {"H", 1}, {
        "T", 2}}\)], "Output"]
}, Closed]],

Cell[TextData[{
  "This definition of ",
  StyleBox["runDecode", "Input"],
  " reverses the encoding of ",
  StyleBox["runEncode", "Input"],
  "."
}], "Text"],

Cell[BoxData[
    \(runDecode[\[ScriptCapitalL]_List] := 
      Flatten[Map[Table[First[#], {Last[#]}]&, \[ScriptCapitalL]]]\)], "Input"],

Cell["Here are the original data.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(runDecode[td]\)], "Input"],

Cell[BoxData[
    \({"H", "H", "H", "H", "H", "H", "H", "T", "T", "T", "H", "T", "H", "H", 
      "T", "T", "T", "H", "T", "T"}\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(% == tosses\)], "Input"],

Cell[BoxData[
    \(True\)], "Output"]
}, Closed]],

Cell[" ", "EndExercises"]
}, Closed]],

Cell[CellGroupData[{

Cell["Expressions", "Subsection"],

Cell[TextData[{
  "Lists are just a special case of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " expressions, and it is the uniformity among ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " expressions that gives us great freedom in manipulating them."
}], "Text"],

Cell[TextData[{
  "Recall that the most general ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " expression has the following form."
}], "Text"],

Cell[TextData[{
  "\t",
  Cell[BoxData[
      \(TraditionalForm\`e\_0[e\_1, e\_2, \[Ellipsis], e\_n]\)]]
}], "Text"],

Cell[TextData[{
  "Recall that the first element ",
  Cell[BoxData[
      \(TraditionalForm\`e\_0\)]],
  " is what we have called the head of the expression, and can be determined \
by evaluating ",
  StyleBox["Head[", "Input"],
  StyleBox["expression",
    FontSlant->"Italic"],
  StyleBox["]", "Input"],
  ". In the list ",
  StyleBox["{a, b, c}", "Input"],
  ", the value of ",
  Cell[BoxData[
      \(TraditionalForm\`e\_0\)]],
  " is ",
  StyleBox["List", "Input"],
  ", the value of ",
  Cell[BoxData[
      \(TraditionalForm\`e\_1\)]],
  " is ",
  StyleBox["a", "Input"],
  ", the value of ",
  Cell[BoxData[
      \(TraditionalForm\`e\_2\)]],
  " is ",
  StyleBox["b", "Input"],
  ", and the value of ",
  Cell[BoxData[
      \(TraditionalForm\`e\_3\)]],
  " is ",
  StyleBox["c", "Input"],
  ". ",
  StyleBox["FullForm", "Input"],
  " displays the internal form of an expression."
}], "Text"],

Cell[CellGroupData[{

Cell["FullForm[{a, b, c}]", "Input"],

Cell[OutputFormData["\<\
FullForm[{a, b, c}]\
\>", 
"\<\
List[a, b, c]\
\>"], "Output"]
}, Closed]],

Cell["\<\
Just as we extract sublists from lists, we extract subexpressions \
from expressions.\
\>", "Text"],

Cell[TextData[{
  "Compare the ",
  StyleBox["FullForm", "Input"],
  " of ",
  StyleBox["{a, b, c}", "Input"],
  " and ",
  StyleBox["a + b + c", "Input"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell["FullForm[a + b + c]", "Input"],

Cell[OutputFormData["\<\
FullForm[a + b + c]\
\>", 
"\<\
Plus[a, b, c]\
\>"], "Output"]
}, Closed]],

Cell[TextData[{
  "We use ",
  StyleBox["Part", "Input"],
  " to extract an element from a list."
}], "Text"],

Cell[CellGroupData[{

Cell["Part[{a, b, c}, 1]", "Input"],

Cell[OutputFormData["\<\
a\
\>", "\<\
a\
\>"], "Output"]
}, Closed]],

Cell[TextData[{
  "In the same way, we use ",
  StyleBox["Part", "Input"],
  " to extract an element from a sum."
}], "Text"],

Cell[CellGroupData[{

Cell["Part[a + b + c, 1]", "Input"],

Cell[OutputFormData["\<\
a\
\>", "\<\
a\
\>"], "Output"]
}, Closed]],

Cell["Recall that part 0 of an expression is its head.", "Text"],

Cell[CellGroupData[{

Cell["Part[a + b + c, 0]", "Input"],

Cell[OutputFormData["\<\
Plus\
\>", "\<\
Plus\
\>"], "Output"]
}, Closed]],

Cell["Similarly, here is part of a more complicated sum.", "Text"],

Cell[CellGroupData[{

Cell["Part[1 + x + x^2 + x^3, 3]", "Input"],

Cell[OutputFormData["\<\
x^2\
\>", "\<\
 2
x\
\>"], "Output"]
}, Closed]],

Cell[TextData[{
  "To extract the exponent in the third term of the sum, we refer to its \
coordinate. The internal representation of exponentiation is ",
  StyleBox["Power", "Input"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell["FullForm[x^2]", "Input"],

Cell[OutputFormData["\<\
FullForm[x^2]\
\>", "\<\
Power[x, 2]\
\>"], "Output"]
}, Closed]],

Cell[TextData[{
  "The exponent is the second part of the expression ",
  Cell[BoxData[
      \(TraditionalForm\`x\^2\)]],
  ", so we can extract the 2 as follows."
}], "Text"],

Cell[CellGroupData[{

Cell["Part[1 + x + x^2 + x^3, 3, 2]", "Input"],

Cell[OutputFormData["\<\
2\
\>", "\<\
2\
\>"], "Output"]
}, Closed]],

Cell[TextData[{
  "Alternatively, we can use ",
  StyleBox["[[ ]]", "Input"],
  " notation."
}], "Text"],

Cell[CellGroupData[{

Cell["(1 + x + x^2 + x^3)[[3, 2]]", "Input"],

Cell[OutputFormData["\<\
2\
\>", "\<\
2\
\>"], "Output"]
}, Closed]],

Cell[TextData[{
  "We can use replacement rules with expressions. In this case we convert a \
list of rules of the form ",
  StyleBox["OptionName",
    FontSlant->"Italic"],
  " ",
  StyleBox["->", "Input"],
  " ",
  StyleBox["Value",
    FontSlant->"Italic"],
  " to a list of option names."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Options[TableForm]\)], "Input"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{"\(TableAlignments \[Rule] Automatic\)", ",", 
        RowBox[{"TableDepth", "\[Rule]", 
          InterpretationBox["\[Infinity]",
            DirectedInfinity[ 1]]}], ",", 
        "\(TableDirections \[Rule] Column\)", ",", 
        "\(TableHeadings \[Rule] None\)", ",", 
        "\(TableSpacing \[Rule] Automatic\)"}], "}"}]], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell["% /. Rule[name_, value_] -> name", "Input"],

Cell[BoxData[
    \({TableAlignments, TableDepth, TableDirections, TableHeadings, 
      TableSpacing}\)], "Output"]
}, Closed]],

Cell[TextData[{
  "Complicated expressions have complicated internal forms, and we can always \
examine the internal form of an expression by using ",
  StyleBox["FullForm", "Input"],
  ". In some cases we must tell ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " not to evaluate an expression by wrapping it inside ",
  StyleBox["Hold", "Input"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(FullForm[Hold[f[x_] := Sin[1/x] /; x \[NotEqual] 0 && \(-3\) < x < 3]]
      \)], "Input"],

Cell[BoxData[
    TagBox[
      StyleBox[
        "\(Hold[SetDelayed[f[Pattern[x, Blank[]]],              \
Condition[Sin[Times[1, Power[x, \(-1\)]]],                And[Unequal[x, 0], \
Less[\(-3\), x, 3]]]]]\)",
        ShowStringCharacters->True,
        NumberMarks->True],
      FullForm]], "Output"]
}, Closed]],

Cell[TextData[{
  "See also ",
  StyleBox["InputForm", "Input"],
  ", ",
  StyleBox["OutputForm", "Input"],
  ", ",
  StyleBox["HoldForm", "Input"]
}], "SeeAlso"]
}, Closed]],

Cell[CellGroupData[{

Cell["Exercises: Expressions", "Subsection"],

Cell[TextData[{
  "How many terms are in the expansion of ",
  Cell[BoxData[
      \(TraditionalForm\`\((x + y + z)\)\^10\)]],
  "?"
}], "Question"],

Cell[TextData[{
  StyleBox["Length", "Input"],
  " gives the number of elements in any expression."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Length[Expand[\((x + y + z)\)\^10]]\)], "Input"],

Cell[BoxData[
    \(66\)], "Output"]
}, Closed]],

Cell[TextData[{
  "Extract the right-hand side of the rule ",
  Cell[BoxData[
      \(TraditionalForm\`x \[Rule] 1 + a\)]],
  "."
}], "Question"],

Cell["Here is the internal form of the rule.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(FullForm[x \[Rule] 1 + a]\)], "Input"],

Cell[BoxData[
    TagBox[
      StyleBox[\(Rule[x, Plus[1, a]]\),
        ShowSpecialCharacters->False,
        ShowStringCharacters->True,
        NumberMarks->True],
      FullForm]], "Output"]
}, Closed]],

Cell["\<\
This internal form is similar to a list containing the left- and \
right-hand sides of the rule.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(FullForm[{x, 1 + a}]\)], "Input"],

Cell[BoxData[
    TagBox[
      StyleBox[\(List[x, Plus[1, a]]\),
        ShowSpecialCharacters->False,
        ShowStringCharacters->True,
        NumberMarks->True],
      FullForm]], "Output"]
}, Closed]],

Cell[TextData[{
  "We extract the second element of a list using ",
  StyleBox["Part", "Input"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Part[{x, 1 + a}, 2]\)], "Input"],

Cell[BoxData[
    \(1 + a\)], "Output"]
}, Closed]],

Cell[TextData[{
  "In the same way we extract the right-hand side of the rule by using ",
  StyleBox["Part", "Input"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Part[x \[Rule] 1 + a, 2]\)], "Input"],

Cell[BoxData[
    \(1 + a\)], "Output"]
}, Closed]],

Cell[" ", "EndExercises"]
}, Closed]],

Cell[CellGroupData[{

Cell["Strings", "Subsection"],

Cell[TextData[{
  "In many cases it is convenient to keep data in the form of a string, and \
then manipulate the string directly. ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " contains many string manipulation functions that work similarly to list \
manipulation commands."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Reverse[{b, a, c, k, w, a, r, d, s}]\)], "Input"],

Cell[BoxData[
    \({s, d, r, a, w, k, c, a, b}\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(StringReverse["backwards"]\)], "Input"],

Cell[OutputFormData["\<\
\"sdrawkcab\"\
\>", "\<\
sdrawkcab\
\>"], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Join[{a, b, c}, {x, y, z}]\)], "Input"],

Cell[BoxData[
    \({a, b, c, x, y, z}\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(StringJoin["abc", "xyz"]\)], "Input"],

Cell[BoxData[
    \("abcxyz"\)], "Output"]
}, Closed]],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " does not simplify an expression inside quotation marks."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \("1 + 1"\)], "Input"],

Cell[BoxData[
    \("1 + 1"\)], "Output"]
}, Closed]],

Cell[TextData[{
  StyleBox["ToExpression", "Input"],
  " changes a string into a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " expression, which is then evaluated."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ToExpression[%]\)], "Input"],

Cell[BoxData[
    \(2\)], "Output"]
}, Closed]],

Cell["Here is a data set in the form of a list of strings.", "Text"],

Cell["\<\
register = {
\"123456789012345678901234\",
\"Alabama 2785103100413816\",
\"Alaska  0306017700110483\",
\"Arizona 2039083900782878\",
\"Arkansas0940051700141457\"};\
\>", "Input"],

Cell["\<\
The first eight columns of each line contain the name of a state, \
the ninth through twelfth columns contain the number of automobiles \
registered (in thousands), the thirteen through sixteenth columns contain the \
number of thousands of trucks and buses registered, the seventeenth through \
twentieth columns contain the number of thousands of motorcycles registered, \
and the remaining columns contain the total for each state. (The first line \
of data is used to number the columns.)\
\>", "Text"],

Cell["Here we drop the first element of the list of data.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(register = Rest[register]\)], "Input"],

Cell[BoxData[
    \({"Alabama 2785103100413816", "Alaska  0306017700110483", 
      "Arizona 2039083900782878", "Arkansas0940051700141457"}\)], "Output"]
}, Closed]],

Cell["\<\
The following function dissects each string into its respective \
list of data.\
\>", "Text"],

Cell[BoxData[
    \(dissect[\[ScriptCapitalS]_String] := {StringTake[\[ScriptCapitalS], 8], 
        StringTake[\[ScriptCapitalS], {9, 12}], 
        StringTake[\[ScriptCapitalS], {13, 16}], 
        StringTake[\[ScriptCapitalS], {17, 20}], 
        StringTake[\[ScriptCapitalS], {21, 24}]}\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Map[dissect, register] // TableForm\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {\("Alabama "\), \("2785"\), \("1031"\), \("0041"\), \("3816"\)},
          {\("Alaska  "\), \("0306"\), \("0177"\), \("0011"\), \("0483"\)},
          {\("Arizona "\), \("2039"\), \("0839"\), \("0078"\), \("2878"\)},
          {\("Arkansas"\), \("0940"\), \("0517"\), \("0014"\), \("1457"\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Closed]],

Cell[TextData[{
  "As defined above, ",
  StyleBox["dissect", "Input"],
  " leaves each number in the data set in the form of a string. The following \
addition to the definition of ",
  StyleBox["dissect", "Input"],
  " changes the numerical strings into numbers."
}], "Text"],

Cell[BoxData[
    \(dissect[\[ScriptCapitalS]_String] := 
      Flatten[{StringTake[\[ScriptCapitalS], 8], 
          ToExpression[{StringTake[\[ScriptCapitalS], {9, 12}], 
              StringTake[\[ScriptCapitalS], {13, 16}], 
              StringTake[\[ScriptCapitalS], {17, 20}], 
              StringTake[\[ScriptCapitalS], {21, 24}]}]}]\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Map[dissect, register] // TableForm\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {\("Alabama "\), "2785", "1031", "41", "3816"},
          {\("Alaska  "\), "306", "177", "11", "483"},
          {\("Arizona "\), "2039", "839", "78", "2878"},
          {\("Arkansas"\), "940", "517", "14", "1457"}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Closed]],

Cell[TextData[{
  "Just as parts of lists and expressions can be replaced using ",
  StyleBox["ReplaceAll", "Input"],
  " (",
  StyleBox["/.", "Input"],
  "), parts of strings can be replaced using ",
  StyleBox["StringReplace", "Input"],
  ". In the following string we replace every occurrence of the word \
\[OpenCurlyDoubleQuote]Cos\[CloseCurlyDoubleQuote] with \
\[OpenCurlyDoubleQuote]cos\[CloseCurlyDoubleQuote] and replace every square \
bracket with a matching parenthesis."
}], "Text"],

Cell[CellGroupData[{

Cell[TextData[
"StringReplace[ \"Cos[Cos[x]]\",\n\t{\"Cos\" \[Rule] \"cos\", \"[\" \[Rule] \
\"(\", \"]\" \[Rule] \")\"} ]"], "Input"],

Cell[BoxData[
    \("cos(cos(x))"\)], "Output"]
}, Closed]],

Cell[TextData[{
  "See also ",
  StyleBox["StringMatchQ", "Input"],
  ", ",
  StyleBox["StringToStream", "Input"],
  ", ",
  StyleBox["Characters", "Input"],
  ", ",
  StyleBox["CharacterRange", "Input"],
  ", ",
  StyleBox["ToString", "Input"],
  ", ",
  StyleBox["StringForm", "Input"],
  ", ",
  StyleBox["SyntaxQ", "Input"],
  ", ",
  StyleBox["Names", "Input"],
  ", ",
  StyleBox["NameQ", "Input"],
  ", ",
  StyleBox["InputString", "Input"],
  ", ",
  StyleBox["ToLowerCase", "Input"],
  ", ",
  StyleBox["IgnoreCase", "Input"],
  ", ",
  StyleBox["ShowStringCharacters", "Input"],
  " "
}], "SeeAlso"]
}, Closed]],

Cell[CellGroupData[{

Cell["Exercises: Strings", "Subsection"],

Cell[TextData[{
  "How many characters are in the word ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "?"
}], "Question"],

Cell[TextData[{
  StyleBox["StringLength", "Input"],
  " returns the number of characters in a string."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(StringLength["\<Mathematica\>"]\)], "Input"],

Cell[BoxData[
    \(11\)], "Output"]
}, Closed]],

Cell[TextData[{
  "Use ",
  StyleBox["Characters", "Input"],
  " and ",
  StyleBox["Permutations", "Input"],
  " to find all anagrams (rearrangements of letters) of the word ",
  StyleBox["math",
    FontSlant->"Italic"],
  "."
}], "Question"],

Cell[TextData[
"Here are the characters in the string \[OpenCurlyDoubleQuote]math\
\[CloseCurlyDoubleQuote]."], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Characters["math"]\)], "Input"],

Cell[BoxData[
    \({"m", "a", "t", "h"}\)], "Output"]
}, Closed]],

Cell[TextData[{
  StyleBox["Permutations", "Input"],
  " returns all possible permutations of the elements in a list."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(anagrams = Permutations[Characters["math"]]\)], "Input"],

Cell[BoxData[
    \({{"m", "a", "t", "h"}, {"m", "a", "h", "t"}, {"m", "t", "a", "h"}, {
        "m", "t", "h", "a"}, {"m", "h", "a", "t"}, {"m", "h", "t", "a"}, {
        "a", "m", "t", "h"}, {"a", "m", "h", "t"}, {"a", "t", "m", "h"}, {
        "a", "t", "h", "m"}, {"a", "h", "m", "t"}, {"a", "h", "t", "m"}, {
        "t", "m", "a", "h"}, {"t", "m", "h", "a"}, {"t", "a", "m", "h"}, {
        "t", "a", "h", "m"}, {"t", "h", "m", "a"}, {"t", "h", "a", "m"}, {
        "h", "m", "a", "t"}, {"h", "m", "t", "a"}, {"h", "a", "m", "t"}, {
        "h", "a", "t", "m"}, {"h", "t", "m", "a"}, {"h", "t", "a", "m"}}\)], 
  "Output"]
}, Closed]],

Cell["There are 24 (4!) permutations.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Length[%]\)], "Input"],

Cell[BoxData[
    \(24\)], "Output"]
}, Closed]],

Cell[TextData[{
  "To combine each list of characters into a string, we use ",
  StyleBox["StringJoin", "Input"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Table[StringJoin[anagrams[\([i]\)]], {i, 24}]\)], "Input"],

Cell[BoxData[
    \({"math", "maht", "mtah", "mtha", "mhat", "mhta", "amth", "amht", 
      "atmh", "athm", "ahmt", "ahtm", "tmah", "tmha", "tamh", "tahm", "thma", 
      "tham", "hmat", "hmta", "hamt", "hatm", "htma", "htam"}\)], "Output"]
}, Closed]],

Cell[TextData[{
  "Alternatively, we can use the high-level programming function ",
  StyleBox["Map", "Input"],
  " to map ",
  StyleBox["StringJoin", "Input"],
  " over each list of characters."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Map[StringJoin, anagrams]\)], "Input"],

Cell[BoxData[
    \({"math", "maht", "mtah", "mtha", "mhat", "mhta", "amth", "amht", 
      "atmh", "athm", "ahmt", "ahtm", "tmah", "tmha", "tamh", "tahm", "thma", 
      "tham", "hmat", "hmta", "hamt", "hatm", "htma", "htam"}\)], "Output"]
}, Closed]],

Cell[" ", "EndExercises"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["High-Level Programming", "Section"],

Cell[CellGroupData[{

Cell["Introduction to High-Level Programming", "Subsection"],

Cell[TextData[{
  "Traditional (procedural) programming involves setting up loops and \
branching structures, such as ",
  StyleBox["Do", "Input"],
  ", ",
  StyleBox["If", "Input"],
  ", and ",
  StyleBox["While", "Input"],
  ", typically repeating a calculation (such as incrementing a variable) for \
a series of values.  High-level programming allows us to work on lists and \
other expressions as a whole, rather than looping over their elements."
}], "Text"],

Cell[TextData[{
  "In traditional programming, we might add the numbers from 1 to 100 by \
initializing a partial-sums variable, then looping over each value of the sum \
and adding it to the partial-sums variable. Following is one such procedural \
way to add the numbers from 1 to 100 using ",
  StyleBox["Do", "Input"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(psum = 0; \)\), 
    \(\(Do[psum = psum + i, {i, 1, 100}]; \)\), 
    \(psum\)}], "Input"],

Cell[BoxData[
    \(5050\)], "Output"]
}, Closed]],

Cell[TextData[{
  "High-level programming allows us to add the numbers by creating a list of \
integers from 1 to 100, then directly changing the list into a sum, using ",
  StyleBox["Apply", "Input"],
  ", defined below."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Apply[Plus, Range[100]]\)], "Input"],

Cell[BoxData[
    \(5050\)], "Output"]
}, Closed]],

Cell[TextData[{
  "High-level programs allow us to take advantage of knowing ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "\[CloseCurlyQuote]s internal representation of an expression, and \
consequently create programs that execute much more efficiently."
}], "Text"]
}, Closed]],

Cell[CellGroupData[{

Cell["Apply", "Subsection"],

Cell[TextData[{
  "We often collect lists of elements to be given as arguments to some \
operator, and the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " function that allows us to do this is ",
  StyleBox["Apply", "Input"],
  ". If we collect arguments to be given to a function ",
  StyleBox["f", "Input"],
  " in a list called ",
  StyleBox["args", "Input"],
  ", we might use ",
  StyleBox["Apply", "Input"],
  " as follows. ",
  StyleBox["Apply", "Input"],
  " effectively replaces the head of an expression, in this case replacing \
the head of ",
  StyleBox["args", "Input"],
  " (",
  StyleBox["List", "Input"],
  ") with the head ",
  StyleBox["f", "Input"],
  "."
}], "Text"],

Cell[BoxData[
    \(\(args = {a, b, c, d}; \)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Apply[f, args]\)], "Input"],

Cell[OutputFormData["\<\
f[a, b, c, d]\
\>", 
"\<\
f[a, b, c, d]\
\>"], "Output"]
}, Closed]],

Cell[TextData[{
  "Notice that we give ",
  StyleBox["Apply", "Input"],
  " (and the other functions in this chapter) only the function name (",
  StyleBox["f", "Input"],
  "), not the name and argument (",
  StyleBox["f[x]", "Input"],
  ")."
}], "Text"],

Cell[TextData[{
  "Recall that the internal form of ",
  Cell["a + b", "Input"],
  " is ",
  Cell["Plus[a, b]", "Input"],
  ", the internal form of ",
  Cell["a+b+c", "Input"],
  " is ",
  Cell["Plus[a, b, c]", "Input"],
  ", and so forth. Considering this fact, we can give the list of numbers \
from 1 to 100 directly as an argument to the ",
  Cell["Plus", "Input"],
  " function, by using ",
  Cell["Apply", "Input"],
  " to change the head of a list of numbers to ",
  Cell["Plus", "Input"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Apply[Plus, Range[100]]\)], "Input"],

Cell[BoxData[
    \(5050\)], "Output"]
}, Closed]],

Cell["\<\
In this way we can create an elegant function for computing the \
mean of a list of numbers by adding all the elements of the list, then \
dividing by the length of the list.\
\>", "Text"],

Cell[BoxData[
    \(mean[L_List] := Apply[Plus, L]/Length[L]\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(mean[{0.2, 2.0, 20.0, 200.0}]\)], "Input"],

Cell[OutputFormData["\<\
55.55\
\>", "\<\
55.55\
\>"], "Output"]
}, Closed]],

Cell[TextData[{
  "Similarly, the following method of computing 10 factorial ",
  Cell[BoxData[
      \(TraditionalForm\`\((\(10!\))\)\)]],
  " is much faster than a recursive definition. Rather than having to call ",
  StyleBox["Times", "Input"],
  " ten times, this definition uses it only once."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Apply[Times, Range[10]]\)], "Input"],

Cell[OutputFormData["\<\
3628800\
\>", "\<\
3628800\
\>"], "Output"]
}, Closed]],

Cell[TextData[{
  StyleBox["Apply", "Input"],
  " is useful when giving a list of arguments to a function that expects a \
sequence of arguments. For example the function ",
  StyleBox["ArcTan", "Input"],
  " expects a sequence of two arguments, while a point in the plane (such as \
",
  Cell["{3.0,4.0}", "Input"],
  ") is represented by a list of two arguments. To compute the arc tangent of \
a point in the plane, we apply ",
  StyleBox["ArcTan", "Input"],
  " to the list of coordinates."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Apply[ArcTan, {3.0, 4.0}]\)], "Input"],

Cell[BoxData[
    \(0.92729521800161212`\)], "Output"]
}, Closed]],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "\[CloseCurlyQuote]s high-level programming constructs operate not only on \
lists, but on general expressions. For instance, ",
  StyleBox["Apply", "Input"],
  " replaces the head of any expression with another expression."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Apply[List, a + b + c]\)], "Input"],

Cell[BoxData[
    \({a, b, c}\)], "Output"]
}, Closed]],

Cell[TextData[{
  "See also ",
  StyleBox["Head", "Input"],
  ", ",
  StyleBox["FullForm", "Input"]
}], "SeeAlso"]
}, Closed]],

Cell[CellGroupData[{

Cell["Map", "Subsection"],

Cell[TextData[{
  StyleBox["Map", "Input"],
  " accepts a function and a list of arguments, and returns a list of \
function values. Here is a function that adds one to the reciprocal of its \
integer argument."
}], "Text"],

Cell[BoxData[
    \(fun[t_Integer] := 1 + 1\/t\)], "Input"],

Cell[TextData[{
  "By mapping ",
  StyleBox["fun", "Input"],
  " over ",
  StyleBox["{1, 2, 3}", "Input"],
  " we obtain the list of values ",
  Cell["{fun[1], fun[2], fun[3]}", "Input"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Map[fun, Range[3]]\)], "Input"],

Cell[BoxData[
    \({2, 3\/2, 4\/3}\)], "Output"]
}, Closed]],

Cell[TextData[{
  "Given a list of ordered triples, for instance, we can use ",
  StyleBox["Map", "Input"],
  " to map the graphics primitive ",
  StyleBox["Cuboid", "Input"],
  " over the list, obtaining a list of cubes at the specified coordinates. \
Here is a list of ordered triples."
}], "Text"],

Cell[BoxData[
    \(\(mydata = 
      5.0\ Table[{Sin[j], Cos[j], Cos[j]}, {j, 0, 2\ \[Pi], \[Pi]\/12}]; 
    \)\)], "Input"],

Cell[TextData[{
  "Here we map ",
  StyleBox["Cuboid", "Input"],
  " over the list of triples."
}], "Text"],

Cell[BoxData[
    \(\(cubes = Map[Cuboid, mydata]; \)\)], "Input"],

Cell[TextData[{
  "Here are the first five cuboids in the list ",
  StyleBox["cubes", "Input"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Take[cubes, 5]\)], "Input"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{"Cuboid", "[", 
          RowBox[{"{", 
            RowBox[{"0", ",", 
              StyleBox["5.`",
                StyleBoxAutoDelete->True,
                PrintPrecision->2], ",", 
              StyleBox["5.`",
                StyleBoxAutoDelete->True,
                PrintPrecision->2]}], "}"}], "]"}], ",", 
        "\(Cuboid[{1.29409522551260302`, 4.82962913144533967`,              \
4.82962913144533967`}]\)", ",", 
        "\(Cuboid[{2.5`, 4.33012701892219276`, 4.33012701892219276`}]\)", ",",
         "\(Cuboid[{3.5355339059327373`, 3.5355339059327373`,              \
3.5355339059327373`}]\)", ",", 
        "\(Cuboid[{4.33012701892219276`, 2.5`, 2.5`}]\)"}], "}"}]], "Output"]
}, Closed]],

Cell["\<\
The resulting list of graphics primitives can then be \
displayed.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(Show[Graphics3D[cubes]]; \)\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.0855 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0567234 1.16608 1.11022e-16 1.16608 [
[ 0 0 0 0 ]
[ 1 1.0855 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.08846 .24555 m
0 .80374 L
s
0 .80374 m
.40037 1.0855 L
s
.40037 1.0855 m
.41799 .58158 L
s
.41799 .58158 m
.08846 .24555 L
s
.67245 0 m
.92713 .41497 L
s
.92713 .41497 m
1 .94814 L
s
1 .94814 m
.70644 .58546 L
s
.70644 .58546 m
.67245 0 L
s
.08846 .24555 m
0 .80374 L
s
0 .80374 m
.70644 .58546 L
s
.70644 .58546 m
.67245 0 L
s
.67245 0 m
.08846 .24555 L
s
.41799 .58158 m
.92713 .41497 L
s
.92713 .41497 m
1 .94814 L
s
1 .94814 m
.40037 1.0855 L
s
.40037 1.0855 m
.41799 .58158 L
s
0 0 m
1 0 L
1 1.0855 L
0 1.0855 L
closepath
clip
newpath
.5 Mabswid
.36487 .73569 m .31872 .74954 L .2889 .72377 L p .652 .755 .925 r
F P
0 g
s
.36255 .78264 m .36487 .73569 L .31872 .74954 L p .555 .34 .543 r
F P
0 g
s
.31872 .74954 m .31575 .79625 L .36255 .78264 L p .555 .34 .543 r
F P
0 g
s
.2889 .72377 m .31872 .74954 L .31575 .79625 L p .939 .685 .526 r
F P
0 g
s
.42017 .81574 m .37345 .82887 L .34454 .80443 L p .647 .761 .932 r
F P
0 g
s
.41864 .86389 m .42017 .81574 L .37345 .82887 L p .561 .349 .55 r
F P
0 g
s
.37345 .82887 m .37126 .87677 L .41864 .86389 L p .561 .349 .55 r
F P
0 g
s
.34454 .80443 m .37345 .82887 L .37126 .87677 L p .942 .686 .521 r
F P
0 g
s
.32255 .64459 m .27669 .65931 L .24608 .63192 L p .658 .749 .917 r
F P
0 g
s
.31961 .69032 m .32255 .64459 L .27669 .65931 L p .547 .329 .535 r
F P
0 g
s
.27669 .65931 m .27311 .70482 L .31961 .69032 L p .547 .329 .535 r
F P
0 g
s
.24608 .63192 m .27669 .65931 L .27311 .70482 L p .938 .685 .528 r
F P
0 g
s
.48524 .87999 m .43771 .89259 L .40978 .86914 L p .641 .767 .939 r
F P
0 g
s
.55634 .92442 m .5078 .9367 L .48649 .91861 L p .637 .771 .944 r
F P
0 g
s
.48477 .91905 m .48524 .87999 L p .47482 .92161 L .566 .357 .555 r
F P
0 g
s
.48524 .87999 m .43771 .89259 L p .47482 .92161 L .566 .357 .555 r
F P
0 g
s
.48464 .9293 m .48477 .91905 L p .47482 .92161 L .566 .357 .555 r
F P
0 g
s
.40978 .86914 m .45787 .8561 L .48524 .87999 L p .641 .767 .939 r
F P
0 g
s
.45787 .8561 m .48524 .87999 L .48464 .9293 L p .951 .687 .499 r
F P
0 g
s
.48649 .91861 m .48088 .91385 L p .49648 .91603 L .637 .771 .944 r
F P
0 g
s
.49648 .91603 m .55634 .92442 L .48649 .91861 L .637 .771 .944 r
F
.43771 .89259 m .43644 .94162 L .48464 .9293 L p .566 .357 .555 r
F P
0 g
s
.40978 .86914 m .43771 .89259 L .43644 .94162 L p .946 .686 .512 r
F P
0 g
s
.29577 .54773 m .24991 .56342 L .21868 .53422 L p .662 .743 .91 r
F P
0 g
s
.29242 .59229 m .29577 .54773 L .24991 .56342 L p .539 .317 .526 r
F P
0 g
s
.24991 .56342 m .24593 .60779 L .29242 .59229 L p .539 .317 .526 r
F P
0 g
s
.21868 .53422 m .24991 .56342 L .24593 .60779 L p .939 .685 .526 r
F P
0 g
s
.2889 .72377 m .33558 .70943 L .36487 .73569 L p .652 .755 .925 r
F P
0 g
s
.33558 .70943 m .36487 .73569 L .36255 .78264 L p .944 .686 .515 r
F P
0 g
s
.34454 .80443 m .3918 .79084 L .42017 .81574 L p .647 .761 .932 r
F P
0 g
s
.3918 .79084 m .42017 .81574 L .41864 .86389 L p .947 .687 .509 r
F P
0 g
s
.24608 .63192 m .29245 .61669 L .32255 .64459 L p .658 .749 .917 r
F P
0 g
s
.29245 .61669 m .32255 .64459 L .31961 .69032 L p .943 .686 .517 r
F P
0 g
s
.62926 .94589 m .57957 .95809 L .56673 .94685 L p .633 .774 .948 r
F P
0 g
s
.55655 .94938 m .55634 .92442 L p .53197 .95548 L .57 .362 .559 r
F P
0 g
s
.55634 .92442 m .5078 .9367 L p .53197 .95548 L .57 .362 .559 r
F P
0 g
s
.55677 .97475 m .55655 .94938 L p .53197 .95548 L .57 .362 .559 r
F P
0 g
s
.48088 .91385 m .53002 .90113 L .55634 .92442 L p .637 .771 .944 r
F P
0 g
s
.53002 .90113 m .55634 .92442 L .55677 .97475 L p .957 .688 .485 r
F P
0 g
s
.56673 .94685 m .55365 .93539 L p .59164 .94066 L .633 .774 .948 r
F P
0 g
s
.59164 .94066 m .62926 .94589 L .56673 .94685 L .633 .774 .948 r
F
.5078 .9367 m .50753 .98673 L .55677 .97475 L p .57 .362 .559 r
F P
0 g
s
.48088 .91385 m .5078 .9367 L .50753 .98673 L p .952 .687 .499 r
F P
0 g
s
.31575 .79625 m .28544 .77092 L .2889 .72377 L p .939 .685 .526 r
F P
0 g
s
.36255 .78264 m .31575 .79625 L .28544 .77092 L p .648 .76 .931 r
F P
0 g
s
.28638 .4508 m .24024 .46752 L .20858 .43641 L p .666 .738 .904 r
F P
0 g
s
.28287 .49432 m .28638 .4508 L .24024 .46752 L p .53 .304 .517 r
F P
0 g
s
.24024 .46752 m .23608 .51087 L .28287 .49432 L p .53 .304 .517 r
F P
0 g
s
.20858 .43641 m .24024 .46752 L .23608 .51087 L p .942 .686 .521 r
F P
0 g
s
.37126 .87677 m .34189 .85281 L .34454 .80443 L p .942 .686 .521 r
F P
0 g
s
.41864 .86389 m .37126 .87677 L .34189 .85281 L p .642 .767 .939 r
F P
0 g
s
.27311 .70482 m .24199 .67783 L .24608 .63192 L p .938 .685 .528 r
F P
0 g
s
.31961 .69032 m .27311 .70482 L .24199 .67783 L p .654 .754 .923 r
F P
0 g
s
.21868 .53422 m .26504 .51798 L .29577 .54773 L p .662 .743 .91 r
F P
0 g
s
.26504 .51798 m .29577 .54773 L .29242 .59229 L p .944 .686 .515 r
F P
0 g
s
.33277 .75682 m .33558 .70943 L .2889 .72377 L p .549 .331 .537 r
F P
0 g
s
.2889 .72377 m .28544 .77092 L .33277 .75682 L p .549 .331 .537 r
F P
0 g
s
.38982 .83948 m .3918 .79084 L .34454 .80443 L p .556 .341 .544 r
F P
0 g
s
.34454 .80443 m .34189 .85281 L .38982 .83948 L p .556 .341 .544 r
F P
0 g
s
.28901 .66282 m .29245 .61669 L .24608 .63192 L p .541 .319 .528 r
F P
0 g
s
.24608 .63192 m .24199 .67783 L .28901 .66282 L p .541 .319 .528 r
F P
0 g
s
.43644 .94162 m .40808 .91869 L .40978 .86914 L p .946 .686 .512 r
F P
0 g
s
.48464 .9293 m .43644 .94162 L .43069 .93697 L p .635 .772 .946 r
F P
0 g
s
.46901 .92713 m .48464 .9293 L .43069 .93697 L .635 .772 .946 r
F
.40808 .91869 m .45686 .90593 L .48464 .9293 L p F P
0 g
s
.48464 .9293 m .45686 .90593 L .45787 .8561 L p .951 .687 .499 r
F P
0 g
s
.50753 .98673 m .48021 .96443 L .48088 .91385 L p .952 .687 .499 r
F P
0 g
s
.48021 .96443 m .53007 .95201 L p .49079 .92154 L .565 .355 .554 r
F P
0 g
s
.48088 .91385 m .48075 .92412 L p .49079 .92154 L .565 .355 .554 r
F P
0 g
s
.48075 .92412 m .48021 .96443 L p .49079 .92154 L .565 .355 .554 r
F P
0 g
s
.43069 .93697 m .40808 .91869 L p .46901 .92713 L .635 .772 .946 r
F P
0 g
s
.24593 .60779 m .21417 .57895 L .21868 .53422 L p .939 .685 .526 r
F P
0 g
s
.29242 .59229 m .24593 .60779 L .21417 .57895 L p .659 .748 .916 r
F P
0 g
s
.63079 .99704 m .62926 .94589 L .57957 .95809 L p .572 .365 .562 r
F P
0 g
s
.57957 .95809 m .58035 1.00894 L .63079 .99704 L p .572 .365 .562 r
F P
0 g
s
.55365 .93539 m .57957 .95809 L .58035 1.00894 L p .958 .688 .482 r
F P
0 g
s
.45686 .90593 m .45787 .8561 L .40978 .86914 L p .561 .349 .55 r
F P
0 g
s
.40978 .86914 m .40808 .91869 L .45686 .90593 L p .561 .349 .55 r
F P
0 g
s
.28544 .77092 m .33277 .75682 L .36255 .78264 L p .648 .76 .931 r
F P
0 g
s
.36255 .78264 m .33277 .75682 L .33558 .70943 L p .944 .686 .515 r
F P
0 g
s
.26118 .5629 m .26504 .51798 L .21868 .53422 L p .531 .306 .518 r
F P
0 g
s
.21868 .53422 m .21417 .57895 L .26118 .5629 L p .531 .306 .518 r
F P
0 g
s
.20858 .43641 m .25523 .4191 L .28638 .4508 L p .666 .738 .904 r
F P
0 g
s
.25523 .4191 m .28638 .4508 L .28287 .49432 L p .947 .687 .509 r
F P
0 g
s
.34189 .85281 m .38982 .83948 L .41864 .86389 L p .642 .767 .939 r
F P
0 g
s
.41864 .86389 m .38982 .83948 L .3918 .79084 L p .947 .687 .509 r
F P
0 g
s
.24199 .67783 m .28901 .66282 L .31961 .69032 L p .654 .754 .923 r
F P
0 g
s
.31961 .69032 m .28901 .66282 L .29245 .61669 L p .943 .686 .517 r
F P
0 g
s
.29538 .35977 m .24867 .37752 L .21682 .34449 L p .669 .734 .898 r
F P
0 g
s
.29196 .4024 m .29538 .35977 L .24867 .37752 L p .522 .293 .508 r
F P
0 g
s
.24867 .37752 m .24459 .42001 L .29196 .4024 L p .522 .293 .508 r
F P
0 g
s
.21682 .34449 m .24867 .37752 L .24459 .42001 L p .946 .686 .512 r
F P
0 g
s
.55677 .97475 m .50753 .98673 L .49398 .97567 L p .63 .777 .951 r
F P
0 g
s
.51861 .9696 m .55677 .97475 L .49398 .97567 L .63 .777 .951 r
F
.48021 .96443 m .53007 .95201 L .55677 .97475 L p F P
0 g
s
.55677 .97475 m .53007 .95201 L .53002 .90113 L p .957 .688 .485 r
F P
0 g
s
.58035 1.00894 m .55405 .9868 L .55365 .93539 L p .958 .688 .482 r
F P
0 g
s
.55405 .9868 m .60514 .97448 L p .5791 .95471 L .568 .359 .557 r
F P
0 g
s
.55365 .93539 m .55385 .96093 L p .5791 .95471 L .568 .359 .557 r
F P
0 g
s
.55385 .96093 m .55405 .9868 L p .5791 .95471 L .568 .359 .557 r
F P
0 g
s
.49398 .97567 m .48021 .96443 L p .51861 .9696 L .63 .777 .951 r
F P
0 g
s
.23608 .51087 m .20388 .48007 L .20858 .43641 L p .942 .686 .521 r
F P
0 g
s
.28287 .49432 m .23608 .51087 L .20388 .48007 L p .663 .742 .909 r
F P
0 g
s
.53007 .95201 m .53002 .90113 L .48088 .91385 L p .565 .355 .554 r
F P
0 g
s
.21417 .57895 m .26118 .5629 L .29242 .59229 L p .659 .748 .916 r
F P
0 g
s
.29242 .59229 m .26118 .5629 L .26504 .51798 L p .944 .686 .515 r
F P
0 g
s
.55365 .93539 m .60398 .92275 L .62926 .94589 L p .633 .774 .948 r
F P
0 g
s
.60398 .92275 m .62926 .94589 L .63079 .99704 L p .963 .688 .466 r
F P
0 g
s
.25119 .46292 m .25523 .4191 L .20858 .43641 L p .522 .293 .509 r
F P
0 g
s
.20858 .43641 m .20388 .48007 L .25119 .46292 L p .522 .293 .509 r
F P
0 g
s
.6995 .94237 m .64855 .95475 L .62355 .93171 L p .632 .775 .949 r
F P
0 g
s
.70209 .99409 m .6995 .94237 L .64855 .95475 L p .573 .367 .563 r
F P
0 g
s
.64855 .95475 m .65036 1.00615 L .70209 .99409 L p .573 .367 .563 r
F P
0 g
s
.62355 .93171 m .64855 .95475 L .65036 1.00615 L p .964 .688 .461 r
F P
0 g
s
.6995 .94237 m .64855 .95475 L .62355 .93171 L p .632 .775 .949 r
F P
0 g
s
.70209 .99409 m .6995 .94237 L .64855 .95475 L p .573 .367 .563 r
F P
0 g
s
.64855 .95475 m .65036 1.00615 L .70209 .99409 L p .573 .367 .563 r
F P
0 g
s
.62355 .93171 m .64855 .95475 L .65036 1.00615 L p .964 .688 .461 r
F P
0 g
s
.27058 .33312 m .29538 .35977 L p .23306 .34765 L .669 .734 .898 r
F P
0 g
s
.21682 .34449 m .26406 .3261 L .27058 .33312 L p .669 .734 .898 r
F P
0 g
s
.21682 .34449 m .27058 .33312 L .23306 .34765 L .669 .734 .898 r
F
.26406 .3261 m .29538 .35977 L .29196 .4024 L p .951 .687 .499 r
F P
0 g
s
.2715 .34116 m .31972 .32257 L p .3104 .3177 L .515 .283 .501 r
F P
0 g
s
.27523 .29931 m .27227 .33246 L p .3104 .3177 L .515 .283 .501 r
F P
0 g
s
.27227 .33246 m .2715 .34116 L p .3104 .3177 L .515 .283 .501 r
F P
0 g
s
.63079 .99704 m .58035 1.00894 L .55405 .9868 L p .626 .779 .955 r
F P
0 g
s
.28331 .27257 m .32277 .28059 L .2595 .28206 L .671 .73 .895 r
F
.24346 .26447 m .29155 .24507 L .32277 .28059 L p F P
0 g
s
.32277 .28059 m .27523 .29931 L .2595 .28206 L p .671 .73 .895 r
F P
0 g
s
.31972 .32257 m .32277 .28059 L .27523 .29931 L p .515 .283 .501 r
F P
0 g
s
.29155 .24507 m .32277 .28059 L .31972 .32257 L p .957 .688 .485 r
F P
0 g
s
.3157 .27996 m .365 .26051 L p .3416 .24934 L .511 .277 .496 r
F P
0 g
s
.31882 .23847 m .31727 .25904 L p .3416 .24934 L .511 .277 .496 r
F P
0 g
s
.31727 .25904 m .3157 .27996 L p .3416 .24934 L .511 .277 .496 r
F P
0 g
s
.2595 .28206 m .24346 .26447 L p .28331 .27257 L .671 .73 .895 r
F P
0 g
s
.24346 .26447 m .27523 .29931 L .2715 .34116 L p .952 .687 .499 r
F P
0 g
s
.20388 .48007 m .25119 .46292 L .28287 .49432 L p .663 .742 .909 r
F P
0 g
s
.28287 .49432 m .25119 .46292 L .25523 .4191 L p .947 .687 .509 r
F P
0 g
s
.60514 .97448 m .60398 .92275 L .55365 .93539 L p .568 .359 .557 r
F P
0 g
s
.24459 .42001 m .21219 .38724 L .21682 .34449 L p .946 .686 .512 r
F P
0 g
s
.29196 .4024 m .24459 .42001 L .21219 .38724 L p .666 .738 .903 r
F P
0 g
s
.29196 .4024 m .2601 .369 L .26406 .3261 L p .951 .687 .499 r
F P
0 g
s
.26406 .3261 m .21682 .34449 L p .22554 .34943 L .513 .281 .499 r
F P
0 g
s
.26325 .33481 m .26406 .3261 L p .22554 .34943 L .513 .281 .499 r
F P
0 g
s
.2715 .34116 m .23918 .30655 L .24346 .26447 L p .952 .687 .499 r
F P
0 g
s
.31972 .32257 m .2715 .34116 L .26495 .33415 L p .668 .734 .899 r
F P
0 g
s
.26495 .33415 m .23918 .30655 L p .30328 .3193 L .668 .734 .899 r
F P
0 g
s
.30328 .3193 m .31972 .32257 L .26495 .33415 L .668 .734 .899 r
F
.2601 .369 m .26325 .33481 L p .22554 .34943 L .513 .281 .499 r
F P
0 g
s
.21682 .34449 m .21219 .38724 L .2601 .369 L p .513 .281 .499 r
F P
0 g
s
.62355 .93171 m .67517 .91889 L .6995 .94237 L p .632 .775 .949 r
F P
0 g
s
.62355 .93171 m .67517 .91889 L .6995 .94237 L p .632 .775 .949 r
F P
0 g
s
.67517 .91889 m .6995 .94237 L .70209 .99409 L p .969 .687 .442 r
F P
0 g
s
.67517 .91889 m .6995 .94237 L .70209 .99409 L p .969 .687 .442 r
F P
0 g
s
.55405 .9868 m .60514 .97448 L .63079 .99704 L p .626 .779 .955 r
F P
0 g
s
.63079 .99704 m .60514 .97448 L .60398 .92275 L p .963 .688 .466 r
F P
0 g
s
.76236 .91321 m .71015 .92603 L .68593 .90217 L p .633 .774 .948 r
F P
0 g
s
.76594 .96518 m .76236 .91321 L .71015 .92603 L p .572 .365 .562 r
F P
0 g
s
.71015 .92603 m .71291 .97768 L .76594 .96518 L p .572 .365 .562 r
F P
0 g
s
.68593 .90217 m .71015 .92603 L .71291 .97768 L p .97 .686 .436 r
F P
0 g
s
.65036 1.00615 m .62501 .9837 L .62355 .93171 L p .964 .688 .461 r
F P
0 g
s
.65036 1.00615 m .62501 .9837 L .62355 .93171 L p .964 .688 .461 r
F P
0 g
s
.70209 .99409 m .65036 1.00615 L .62501 .9837 L p .625 .78 .956 r
F P
0 g
s
.70209 .99409 m .65036 1.00615 L .62501 .9837 L p .625 .78 .956 r
F P
0 g
s
.21219 .38724 m .2601 .369 L .29196 .4024 L p .666 .738 .903 r
F P
0 g
s
.36742 .21891 m .31882 .23847 L .28742 .20206 L p .672 .728 .892 r
F P
0 g
s
.365 .26051 m .36742 .21891 L .31882 .23847 L p .511 .277 .496 r
F P
0 g
s
.28742 .20206 m .31882 .23847 L .3157 .27996 L p .958 .688 .482 r
F P
0 g
s
.67743 .97119 m .67517 .91889 L .62355 .93171 L p .569 .36 .558 r
F P
0 g
s
.62355 .93171 m .62501 .9837 L .67743 .97119 L p .569 .36 .558 r
F P
0 g
s
.67743 .97119 m .67517 .91889 L .62355 .93171 L p .569 .36 .558 r
F P
0 g
s
.62355 .93171 m .62501 .9837 L .67743 .97119 L p .569 .36 .558 r
F P
0 g
s
.29155 .24507 m .24346 .26447 L p .26545 .27574 L .506 .271 .492 r
F P
0 g
s
.28976 .26603 m .29155 .24507 L p .26545 .27574 L .506 .271 .492 r
F P
0 g
s
.31972 .32257 m .28796 .28727 L .29155 .24507 L p .957 .688 .485 r
F P
0 g
s
.3157 .27996 m .28376 .24376 L .28742 .20206 L p .958 .688 .482 r
F P
0 g
s
.365 .26051 m .3157 .27996 L .29986 .262 L p .67 .732 .897 r
F P
0 g
s
.29986 .262 m .28376 .24376 L p .32451 .25216 L .67 .732 .897 r
F P
0 g
s
.32451 .25216 m .365 .26051 L .29986 .262 L .67 .732 .897 r
F
.28796 .28727 m .28976 .26603 L p .26545 .27574 L .506 .271 .492 r
F P
0 g
s
.24346 .26447 m .23918 .30655 L .28796 .28727 L p .506 .271 .492 r
F P
0 g
s
.68593 .90217 m .73885 .88888 L .76236 .91321 L p .633 .774 .948 r
F P
0 g
s
.73885 .88888 m .76236 .91321 L .76594 .96518 L p .973 .684 .415 r
F P
0 g
s
.62501 .9837 m .67743 .97119 L .70209 .99409 L p .625 .78 .956 r
F P
0 g
s
.70209 .99409 m .67743 .97119 L .67517 .91889 L p .969 .687 .442 r
F P
0 g
s
.62501 .9837 m .67743 .97119 L .70209 .99409 L p .625 .78 .956 r
F P
0 g
s
.70209 .99409 m .67743 .97119 L .67517 .91889 L p .969 .687 .442 r
F P
0 g
s
.81331 .85939 m .75992 .87291 L .73628 .84775 L p .637 .771 .944 r
F P
0 g
s
.81772 .91123 m .81331 .85939 L .75992 .87291 L p .57 .362 .559 r
F P
0 g
s
.75992 .87291 m .76347 .92444 L .81772 .91123 L p .57 .362 .559 r
F P
0 g
s
.73628 .84775 m .75992 .87291 L .76347 .92444 L p .974 .684 .41 r
F P
0 g
s
.28742 .20206 m .33659 .18178 L .36742 .21891 L p .672 .728 .892 r
F P
0 g
s
.33659 .18178 m .36742 .21891 L .365 .26051 L p .963 .688 .466 r
F P
0 g
s
.71291 .97768 m .68837 .9544 L .68593 .90217 L p .97 .686 .436 r
F P
0 g
s
.76594 .96518 m .71291 .97768 L .68837 .9544 L p .626 .779 .955 r
F P
0 g
s
.23918 .30655 m .28796 .28727 L .31972 .32257 L p .668 .734 .899 r
F P
0 g
s
.42695 .17964 m .37713 .19984 L .34638 .16224 L p .672 .728 .891 r
F P
0 g
s
.42541 .2212 m .42695 .17964 L .37713 .19984 L p .509 .275 .495 r
F P
0 g
s
.37713 .19984 m .37485 .2413 L .42541 .2212 L p .509 .275 .495 r
F P
0 g
s
.34638 .16224 m .37713 .19984 L .37485 .2413 L p .964 .688 .461 r
F P
0 g
s
.73885 .88888 m .68593 .90217 L p .71371 .92158 L .568 .359 .557 r
F P
0 g
s
.74048 .91498 m .73885 .88888 L p .71371 .92158 L .568 .359 .557 r
F P
0 g
s
.76594 .96518 m .74213 .94143 L .73885 .88888 L p .973 .684 .415 r
F P
0 g
s
.76347 .92444 m .73953 .89985 L .73628 .84775 L p .974 .684 .41 r
F P
0 g
s
.81772 .91123 m .76347 .92444 L .7516 .91225 L p .63 .777 .951 r
F P
0 g
s
.7516 .91225 m .73953 .89985 L p .77875 .90556 L .63 .777 .951 r
F P
0 g
s
.77875 .90556 m .81772 .91123 L .7516 .91225 L .63 .777 .951 r
F
.74213 .94143 m .74048 .91498 L p .71371 .92158 L .568 .359 .557 r
F P
0 g
s
.68593 .90217 m .68837 .9544 L .74213 .94143 L p .568 .359 .557 r
F P
0 g
s
.33365 .22358 m .33659 .18178 L .28742 .20206 L p .501 .264 .486 r
F P
0 g
s
.28742 .20206 m .28376 .24376 L .33365 .22358 L p .501 .264 .486 r
F P
0 g
s
.7952 .83909 m .81331 .85939 L p .75221 .85016 L .637 .771 .944 r
F P
0 g
s
.73628 .84775 m .79043 .83374 L .7952 .83909 L p .637 .771 .944 r
F P
0 g
s
.73628 .84775 m .7952 .83909 L .75221 .85016 L .637 .771 .944 r
F
.79043 .83374 m .81331 .85939 L .81772 .91123 L p .976 .68 .386 r
F P
0 g
s
.79799 .8492 m .85329 .83506 L p .84084 .82733 L .566 .357 .555 r
F P
0 g
s
.79387 .79816 m .79714 .83859 L p .84084 .82733 L .566 .357 .555 r
F P
0 g
s
.79714 .83859 m .79799 .8492 L p .84084 .82733 L .566 .357 .555 r
F P
0 g
s
.68837 .9544 m .74213 .94143 L .76594 .96518 L p .626 .779 .955 r
F P
0 g
s
.84829 .78373 m .79387 .79816 L .77056 .77129 L p .641 .767 .939 r
F P
0 g
s
.85329 .83506 m .84829 .78373 L .79387 .79816 L p .566 .357 .555 r
F P
0 g
s
.77056 .77129 m .79387 .79816 L .79799 .8492 L p .976 .68 .385 r
F P
0 g
s
.34638 .16224 m .39681 .14129 L .42695 .17964 L p .672 .728 .891 r
F P
0 g
s
.39681 .14129 m .42695 .17964 L .42541 .2212 L p .969 .687 .442 r
F P
0 g
s
.28376 .24376 m .33365 .22358 L .365 .26051 L p .67 .732 .897 r
F P
0 g
s
.365 .26051 m .33365 .22358 L .33659 .18178 L p .963 .688 .466 r
F P
0 g
s
.4977 .16647 m .44657 .18705 L .41672 .14874 L p .672 .728 .892 r
F P
0 g
s
.57487 .18133 m .52244 .20197 L .50821 .18295 L p .671 .73 .895 r
F P
0 g
s
.4977 .16647 m .44657 .18705 L p .47157 .19755 L .511 .277 .496 r
F P
0 g
s
.49748 .18723 m .4977 .16647 L p .47157 .19755 L .511 .277 .496 r
F P
0 g
s
.41672 .14874 m .46851 .12738 L .4977 .16647 L p .672 .728 .892 r
F P
0 g
s
.49725 .20835 m .49748 .18723 L p .47157 .19755 L .511 .277 .496 r
F P
0 g
s
.46851 .12738 m .4977 .16647 L .49725 .20835 L p .973 .684 .415 r
F P
0 g
s
.50821 .18295 m .4937 .16353 L p .5345 .17248 L .671 .73 .895 r
F P
0 g
s
.5345 .17248 m .57487 .18133 L .50821 .18295 L .671 .73 .895 r
F
.44657 .18705 m .44534 .22883 L .49725 .20835 L p .511 .277 .496 r
F P
0 g
s
.41672 .14874 m .44657 .18705 L .44534 .22883 L p .97 .686 .436 r
F P
0 g
s
.81772 .91123 m .79456 .88615 L .79043 .83374 L p .976 .68 .386 r
F P
0 g
s
.79043 .83374 m .73628 .84775 L p .74801 .85548 L .565 .355 .554 r
F P
0 g
s
.79126 .84437 m .79043 .83374 L p .74801 .85548 L .565 .355 .554 r
F P
0 g
s
.79799 .8492 m .77439 .82288 L .77056 .77129 L p .976 .68 .385 r
F P
0 g
s
.85329 .83506 m .79799 .8492 L .79322 .84387 L p .635 .772 .946 r
F P
0 g
s
.79322 .84387 m .77439 .82288 L p .8372 .83258 L .635 .772 .946 r
F P
0 g
s
.8372 .83258 m .85329 .83506 L .79322 .84387 L .635 .772 .946 r
F
.79456 .88615 m .79126 .84437 L p .74801 .85548 L .565 .355 .554 r
F P
0 g
s
.73628 .84775 m .73953 .89985 L .79456 .88615 L p .565 .355 .554 r
F P
0 g
s
.37485 .2413 m .34358 .20388 L .34638 .16224 L p .964 .688 .461 r
F P
0 g
s
.42541 .2212 m .37485 .2413 L .34358 .20388 L p .67 .732 .896 r
F P
0 g
s
.39477 .18303 m .39681 .14129 L .34638 .16224 L p .5 .261 .485 r
F P
0 g
s
.34638 .16224 m .34358 .20388 L .39477 .18303 L p .5 .261 .485 r
F P
0 g
s
.77056 .77129 m .82576 .75632 L .84829 .78373 L p .641 .767 .939 r
F P
0 g
s
.82576 .75632 m .84829 .78373 L .85329 .83506 L p .976 .675 .357 r
F P
0 g
s
.86412 .69092 m .80895 .70643 L .78565 .67755 L p .647 .761 .932 r
F P
0 g
s
.86944 .74138 m .86412 .69092 L .80895 .70643 L p .561 .349 .55 r
F P
0 g
s
.80895 .70643 m .81335 .75662 L .86944 .74138 L p .561 .349 .55 r
F P
0 g
s
.78565 .67755 m .80895 .70643 L .81335 .75662 L p .976 .676 .363 r
F P
0 g
s
.73953 .89985 m .79456 .88615 L .81772 .91123 L p .63 .777 .951 r
F P
0 g
s
.65281 .22396 m .59917 .24434 L .57739 .2143 L p .669 .734 .898 r
F P
0 g
s
.57548 .21504 m .57487 .18133 L p .56449 .2193 L .515 .283 .501 r
F P
0 g
s
.57487 .18133 m .52244 .20197 L p .56449 .2193 L .515 .283 .501 r
F P
0 g
s
.57564 .22389 m .57548 .21504 L p .56449 .2193 L .515 .283 .501 r
F P
0 g
s
.4937 .16353 m .54683 .1421 L .57487 .18133 L p .671 .73 .895 r
F P
0 g
s
.54683 .1421 m .57487 .18133 L .57564 .22389 L p .976 .68 .386 r
F P
0 g
s
.57739 .2143 m .57165 .20639 L p .58843 .21002 L .669 .734 .898 r
F P
0 g
s
.58843 .21002 m .65281 .22396 L .57739 .2143 L .669 .734 .898 r
F
.52244 .20197 m .52238 .24443 L .57564 .22389 L p .515 .283 .501 r
F P
0 g
s
.4937 .16353 m .52244 .20197 L .52238 .24443 L p .974 .684 .41 r
F P
0 g
s
.34358 .20388 m .39477 .18303 L .42541 .2212 L p .67 .732 .896 r
F P
0 g
s
.42541 .2212 m .39477 .18303 L .39681 .14129 L p .969 .687 .442 r
F P
0 g
s
.8305 .8082 m .82576 .75632 L .77056 .77129 L p .561 .349 .55 r
F P
0 g
s
.77056 .77129 m .77439 .82288 L .8305 .8082 L p .561 .349 .55 r
F P
0 g
s
.44534 .22883 m .415 .1907 L .41672 .14874 L p .97 .686 .436 r
F P
0 g
s
.49725 .20835 m .44534 .22883 L .415 .1907 L p .67 .732 .897 r
F P
0 g
s
.859 .5874 m .80339 .60409 L .77978 .57301 L p .652 .755 .925 r
F P
0 g
s
.86427 .63667 m .859 .5874 L .80339 .60409 L p .555 .34 .543 r
F P
0 g
s
.80339 .60409 m .80774 .65312 L .86427 .63667 L p .555 .34 .543 r
F P
0 g
s
.77978 .57301 m .80339 .60409 L .80774 .65312 L p .976 .673 .348 r
F P
0 g
s
.78565 .67755 m .84164 .66145 L .86412 .69092 L p .647 .761 .932 r
F P
0 g
s
.84164 .66145 m .86412 .69092 L .86944 .74138 L p .975 .669 .332 r
F P
0 g
s
.65482 .26755 m .65281 .22396 L .59917 .24434 L p .522 .293 .508 r
F P
0 g
s
.59917 .24434 m .60032 .2878 L .65482 .26755 L p .522 .293 .508 r
F P
0 g
s
.57165 .20639 m .59917 .24434 L .60032 .2878 L p .976 .68 .385 r
F P
0 g
s
.46759 .16944 m .46851 .12738 L .41672 .14874 L p .501 .264 .486 r
F P
0 g
s
.41672 .14874 m .415 .1907 L .46759 .16944 L p .501 .264 .486 r
F P
0 g
s
.77439 .82288 m .8305 .8082 L .85329 .83506 L p .635 .772 .946 r
F P
0 g
s
.85329 .83506 m .8305 .8082 L .82576 .75632 L p .976 .675 .357 r
F P
0 g
s
.83275 .48087 m .77709 .49873 L .75285 .46547 L p .658 .749 .917 r
F P
0 g
s
.83764 .52873 m .83275 .48087 L .77709 .49873 L p .547 .329 .535 r
F P
0 g
s
.77709 .49873 m .78105 .54638 L .83764 .52873 L p .547 .329 .535 r
F P
0 g
s
.75285 .46547 m .77709 .49873 L .78105 .54638 L p .976 .672 .343 r
F P
0 g
s
.72548 .29172 m .67084 .31151 L .64455 .27465 L p .666 .738 .904 r
F P
0 g
s
.72866 .33661 m .72548 .29172 L .67084 .31151 L p .53 .304 .517 r
F P
0 g
s
.67084 .31151 m .67313 .35625 L .72866 .33661 L p .53 .304 .517 r
F P
0 g
s
.64455 .27465 m .67084 .31151 L .67313 .35625 L p .976 .676 .363 r
F P
0 g
s
.81335 .75662 m .78977 .72824 L .78565 .67755 L p .976 .676 .363 r
F P
0 g
s
.86944 .74138 m .81335 .75662 L .78977 .72824 L p .642 .767 .939 r
F P
0 g
s
.78709 .37964 m .73176 .39857 L .7066 .36332 L p .662 .743 .91 r
F P
0 g
s
.79126 .42599 m .78709 .37964 L .73176 .39857 L p .539 .317 .526 r
F P
0 g
s
.73176 .39857 m .73502 .44475 L .79126 .42599 L p .539 .317 .526 r
F P
0 g
s
.7066 .36332 m .73176 .39857 L .73502 .44475 L p .976 .673 .348 r
F P
0 g
s
.48255 .18906 m .49725 .20835 L p .45626 .19955 L .67 .732 .897 r
F P
0 g
s
.49725 .20835 m .46759 .16944 L .46851 .12738 L p .973 .684 .415 r
F P
0 g
s
.52238 .24443 m .49318 .20618 L .4937 .16353 L p .974 .684 .41 r
F P
0 g
s
.49318 .20618 m .54716 .18485 L p .52011 .17406 L .506 .271 .492 r
F P
0 g
s
.4937 .16353 m .49344 .18471 L p .52011 .17406 L .506 .271 .492 r
F P
0 g
s
.49344 .18471 m .49318 .20618 L p .52011 .17406 L .506 .271 .492 r
F P
0 g
s
.415 .1907 m .46759 .16944 L .48255 .18906 L p .67 .732 .897 r
F P
0 g
s
.415 .1907 m .48255 .18906 L .45626 .19955 L .67 .732 .897 r
F
.57564 .22389 m .52238 .24443 L .51647 .23669 L p .668 .734 .899 r
F P
0 g
s
.55882 .22028 m .57564 .22389 L .51647 .23669 L .668 .734 .899 r
F
.49318 .20618 m .54716 .18485 L .57564 .22389 L p F P
0 g
s
.57564 .22389 m .54716 .18485 L .54683 .1421 L p .976 .68 .386 r
F P
0 g
s
.60032 .2878 m .57238 .25008 L .57165 .20639 L p .976 .68 .385 r
F P
0 g
s
.57238 .25008 m .62764 .22903 L p .58291 .21094 L .513 .281 .499 r
F P
0 g
s
.57165 .20639 m .5718 .21525 L p .58291 .21094 L .513 .281 .499 r
F P
0 g
s
.5718 .21525 m .57238 .25008 L p .58291 .21094 L .513 .281 .499 r
F P
0 g
s
.51647 .23669 m .49318 .20618 L p .55882 .22028 L .668 .734 .899 r
F P
0 g
s
.84669 .7124 m .84164 .66145 L .78565 .67755 L p .556 .341 .544 r
F P
0 g
s
.78565 .67755 m .78977 .72824 L .84669 .7124 L p .556 .341 .544 r
F P
0 g
s
.77978 .57301 m .83621 .55568 L .859 .5874 L p .652 .755 .925 r
F P
0 g
s
.83621 .55568 m .859 .5874 L .86427 .63667 L p .974 .665 .316 r
F P
0 g
s
.57165 .20639 m .62603 .18522 L .65281 .22396 L p .669 .734 .898 r
F P
0 g
s
.62603 .18522 m .65281 .22396 L .65482 .26755 L p .976 .675 .357 r
F P
0 g
s
.54716 .18485 m .54683 .1421 L .4937 .16353 L p .506 .271 .492 r
F P
0 g
s
.80774 .65312 m .78384 .62248 L .77978 .57301 L p .976 .673 .348 r
F P
0 g
s
.86427 .63667 m .80774 .65312 L .78384 .62248 L p .648 .76 .931 r
F P
0 g
s
.75285 .46547 m .80932 .44692 L .83275 .48087 L p .658 .749 .917 r
F P
0 g
s
.80932 .44692 m .83275 .48087 L .83764 .52873 L p .973 .663 .31 r
F P
0 g
s
.64455 .27465 m .69996 .25409 L .72548 .29172 L p .666 .738 .904 r
F P
0 g
s
.69996 .25409 m .72548 .29172 L .72866 .33661 L p .975 .669 .332 r
F P
0 g
s
.78977 .72824 m .84669 .7124 L .86944 .74138 L p .642 .767 .939 r
F P
0 g
s
.86944 .74138 m .84669 .7124 L .84164 .66145 L p .975 .669 .332 r
F P
0 g
s
.65482 .26755 m .60032 .2878 L .57238 .25008 L p .666 .738 .903 r
F P
0 g
s
.7066 .36332 m .76273 .34366 L .78709 .37964 L p .662 .743 .91 r
F P
0 g
s
.76273 .34366 m .78709 .37964 L .79126 .42599 L p .974 .665 .316 r
F P
0 g
s
.84122 .60539 m .83621 .55568 L .77978 .57301 L p .549 .331 .537 r
F P
0 g
s
.77978 .57301 m .78384 .62248 L .84122 .60539 L p .549 .331 .537 r
F P
0 g
s
.62764 .22903 m .62603 .18522 L .57165 .20639 L p .513 .281 .499 r
F P
0 g
s
.78105 .54638 m .75649 .51351 L .75285 .46547 L p .976 .672 .343 r
F P
0 g
s
.83764 .52873 m .78105 .54638 L .75649 .51351 L p .654 .754 .923 r
F P
0 g
s
.67313 .35625 m .64646 .31966 L .64455 .27465 L p .976 .676 .363 r
F P
0 g
s
.72866 .33661 m .67313 .35625 L .64646 .31966 L p .663 .742 .909 r
F P
0 g
s
.73502 .44475 m .70951 .40982 L .7066 .36332 L p .976 .673 .348 r
F P
0 g
s
.79126 .42599 m .73502 .44475 L .70951 .40982 L p .659 .748 .916 r
F P
0 g
s
.81393 .49516 m .80932 .44692 L .75285 .46547 L p .541 .319 .528 r
F P
0 g
s
.75285 .46547 m .75649 .51351 L .81393 .49516 L p .541 .319 .528 r
F P
0 g
s
.70279 .29925 m .69996 .25409 L .64455 .27465 L p .522 .293 .509 r
F P
0 g
s
.64455 .27465 m .64646 .31966 L .70279 .29925 L p .522 .293 .509 r
F P
0 g
s
.78384 .62248 m .84122 .60539 L .86427 .63667 L p .648 .76 .931 r
F P
0 g
s
.86427 .63667 m .84122 .60539 L .83621 .55568 L p .974 .665 .316 r
F P
0 g
s
.76658 .39033 m .76273 .34366 L .7066 .36332 L p .531 .306 .518 r
F P
0 g
s
.7066 .36332 m .70951 .40982 L .76658 .39033 L p .531 .306 .518 r
F P
0 g
s
.57238 .25008 m .62764 .22903 L .65482 .26755 L p .666 .738 .903 r
F P
0 g
s
.65482 .26755 m .62764 .22903 L .62603 .18522 L p .976 .675 .357 r
F P
0 g
s
.75649 .51351 m .81393 .49516 L .83764 .52873 L p .654 .754 .923 r
F P
0 g
s
.83764 .52873 m .81393 .49516 L .80932 .44692 L p .973 .663 .31 r
F P
0 g
s
.64646 .31966 m .70279 .29925 L .72866 .33661 L p .663 .742 .909 r
F P
0 g
s
.72866 .33661 m .70279 .29925 L .69996 .25409 L p .975 .669 .332 r
F P
0 g
s
.70951 .40982 m .76658 .39033 L .79126 .42599 L p .659 .748 .916 r
F P
0 g
s
.79126 .42599 m .76658 .39033 L .76273 .34366 L p .974 .665 .316 r
F P
0 g
s
.25 Mabswid
.67245 0 m
.92713 .41497 L
s
.92713 .41497 m
1 .94814 L
s
1 .94814 m
.70644 .58546 L
s
.70644 .58546 m
.67245 0 L
s
.08846 .24555 m
0 .80374 L
s
0 .80374 m
.70644 .58546 L
s
.70644 .58546 m
.67245 0 L
s
.67245 0 m
.08846 .24555 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  Evaluatable->False,
  AspectRatioFixed->True,
  ImageSize->{265.312, 288},
  ImageMargins->{{35, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`400049000180P10`4000010?ooobl_;oooZZVYZNSX
j?oo05FZZZZZZ_W0RS/k>gYjN[Vi^OShn03ooeGooj[ooonI<c<c<fi^KZf][Nc/k02ZoeFZojZZoonZ
oclo?ginO[fm_Oclo5D00:X00?l00?l0VCLg=g9bL[6a/O3`l03o05Go0:[o00<30d92@X61PL30`000
EED0EJX0EOl0ELbIoc/k>gIfM[Fe]OCdm03oEEGoEJ[oE@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0Z/`c
<clo?gYjN[Vi^OShn03oZUGoZZ[oZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`<30d92@WinO[fm_Ocl
o03ooeGooj[oo`l?3di>CXf=SLc<c01E05EE0:YE0?mE00L71dI6AX61PL30`000EED00:X00?l001<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@/;2dY:BXF5QLC4a000ZUD0EJX0EOl0EALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZPl?3di>CXV9RLS8b000oeD0ZZX0Z_l0ZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEoa<C
4e9BDXf=SLc<c01E05D0ojX0ool0oalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ01LG5eIFEY6ATM3@d01E
EEEE0:YE0?mE02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZEA/K6eYJFYFEUMCDe01EZUEEEJYEEOmEEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZQlO7eiNGYVIVMSHf01EoeEEZZYEZ_mEZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZob<S8f9RHYfMWMcLg02Z05EEojYEoomEobl_;fi^KZf][Nc/k03o05Go0:[o0=gW1RLW
9fIVIZ6QXN3Ph02ZEEFZ0:ZZ0?nZ03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooEB/[:fYZJZFUYNCTi02Z
ZUFZEJZZEOnZECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l02P000;000_mG0000[@03o`030?l005H0
002[00;o1002oeH0002Y00;o1P000ol0o`1E0000YP03o`P000?o0?l0E@000:@00_l;0004o`00oe@0
002Q00?o3@001?l00?mD0000W`02oa0000Go0000o`1C0000W@02oa8000?o00000P000ol0001@0000
VP03oa@000?o00000P000ol0001@0000V002oaP000?o00000P000ol0001?0000U@03oaX000?o0000
0`000ol0001>0000T`02oad000?o00000`000ol0001>0000T@02oal000?o000010000ol0001=0000
SP03ob4000?o000010000ol0001=0000S002ob@000?o00001@000ol0001<0000R@03obH000?o0000
1P000ol0001;0000Q`02obT000?o00001P000ol0001;0000Q003ob/000?o00001`000ol0001:0000
PP02obh000?o000020000ol000190000P002oc0000?o000020000ol000190000O@03oc8000?o0000
2@000ol000180000N`02ocD000?o00002@000ol000180000N003ocL000?o00002P000ol000170000
MP02ocX000?o00002`000ol000160000M002oc`000?o00002`000ol000160000L@03och000?o0000
30000ol000150000K`02od8000?o000030000ol000140000K003od@000?o000030000ol000140000
JP02odL000?o00003@000ol000130000J002odT000?o00003@000ol000130000I@03od/000?o0000
3P000ol000120000H`02odh000?o00003`000ol000110000H003oaL00_lg0003o`0000l000?o0000
@@0005h00_lH00;o00=Bo`00=P000ol0000@0003o`000400001L00;o6002o`03jGgY00;o=P000ol0
000A0003o`0003l0001I00?o5`03o`08DRiB;U;o[ole0003o`00014000?o0000?`0005L00_l>00;o
2002o`09ONUmjGgYONWo00:_00?o00003P02ob8000?o00004P000ol0000n0000E003o`d00ol00bko
000500;o00h^DRiB;U8^DRiBojl8o`d00ol00bko000Q0003o`00018000?o0000?P0005800_l=00?o
00CYONUm0_l4000>oggYONUmjGgYONUmjOl3[`03o`0000P00_l010Ym2Wd2ob4000?o00004`000ol0
000m0000D002o`d00_l02RiB;U8^DRko2?l3000CobiB;U8^DRiB;U8^D_n_2:l8o`0700;o00UB;U8^
DRko2?l080000ol0000D0003o`0003`0001=00?o3003o`0=ONUmjGgYONUmojl8o`02000>oggYONUm
jGgYONUmjOl4[`03o`0000800ol02`Ym2Wd:O@Ymoa3o020000?o000050000ol0000l0000B`02o`h0
02SoDRiB;U8^DRiB;U8^o`R_2?l0obiB;U8^DRiB;U8^D_n_2:l8[ol00_l03biB;U8^DRiB;U8^o`R_
o`0O0003o`0001D000?o0000>`0004P00ol@000QonUmjGgYONUmjGgYOOn_2:oo0?mmjGgYONUmjGgY
ONWo00J_01?oO@Ym2Wd:O@Ym2Wd:OOl@213o01h000?o00005P000ol0000j0000AP02oa<001;oDRiB
;U8^DRiB;U8^o`R_2:l2o`0;;U8^DRiB;U8^DRh00_l06Zl8[`R_2?l^DRiB;U8^DRiB;U8^o`R_2:oo
7P000ol0000E0003o`0003X0001400;o5@007?oYONUmjGgYONUmjGgo[`R_2?oYONUmjGgYONT3o`03
Ton_00F_01CoO@Ym2Wd:O@Ym2Wd:OOl@2108oah000?o00005P000ol0000i0000@@03oaL001[oDRiB
;U8^DRiB;U8^o`R_2:ooDRiB;U8^DP;o02235h<GPol8[`R_2?l^DRiB;U:3DRiB;U8^o`R_2:l8oad0
00?o00005P000ol0000i0000?`02oaX001SojGgYONUmjGgYONUmojl8[`SojGgYONT2o`095i<GTaNC
5i?o00B_01KoO@Ym2Wd:O@YmTgd:OOl@210840So70000ol0000G0003o`0003P0000l00?o6002o`0>
0?l^DRiB;U8^DRiB;U82o`072:l8[omB;P03o`0:PaN35h<GPaN35`;o0108[`So;U8^DRiB;U8^DRiB
0_l01`R_2:l8[ol03002o`h000?o000060000ol0000g0000>P02oaP00ol03GgooommjGgYONUmjGd0
0ol01QOo[`R_20?o00nC5i<GTaNC5i<GTaNC5ol00jl02_mm2Wd:O@Ym2Wd3o`095ol@210840So00T0
0ol00`[o000=0003o`0001P000?o0000=`0003L00olG00?o00eB;U8^ojoo;U8^DRiB00?o02HGPaN3
5on_2:oo5h<GPaN35h<GPaN35h<GPaOo[`So;U8^DRiB;P;o00`GTaNC5on_2:l8[ol700;o00@nDSiB
0_l=0003o`0001T000?o0000=P0003D00_lH00;o00emjGgYONUmo`SoONUm00?o01hGTaNC5i<GTaOo
[`SoTaL85i<GTaNC5i<GTaNC5i<2o`07[omm2Wd:O@02o`0>TaNC5i<GTaOo40P@2?l500;o00Va2[4:
/@[o[ol030000ol0000J0003o`0003D0000c00;o5`03o`0;;U8^DRiB;U8^ojl01?l09aN35h<GPaN3
5h<GPaOo[`SoPaN35h<G21N35h<GPaN35h?o2?l^DP03o`0?5i<GTaNC5i<GTaOo[`R_00;o00l0oooo
?U8nDSiB?U;o[ol030000ol0000J0003o`0003D0000`00?o6000=_oYONUmjGgYONUmjGgo2?lGTaNC
5i<GTaNC5i<GTaNC5on_2?nC5i<GTaNC5i=mDQNC5i<GT`Co018GTaNC5i<GTaNC5i<GTol840P3o`0<
2[4:/@Za2[4:/@[o0Zl00ol000090003o`0001/000?o0000=00002h00_lK001Koe8^DRiB;U8^DRiB
;_n_oh<GPaN35h<GPaN35h<GPaN3o`R_2?n35h<GPaN35h<GPaL^DX<GPonC5i<GTaNC5i<GTaNC5i<G
Tol8[omB?U8nDSiB?U8nDSiBo`03[`03o`0000P000?o00006`000ol0000d0000:`03oad002GojGgY
ONUmjGgYONUmo`R_oi<GTaNC5i<GTaNC5i<GTaNCo`R_00;o03BC5i<GTaNC5i<GTaNC5i<GoaNC5i<G
TaNC5i<GTaNC5i<GTol8o`Za2[4:/@Za2[4:/@[o0jl00ol000080003o`0001`000?o0000<`0002T0
0_lP000Uoe8^DRiB;U8^DRiB;_n_2:ooPaN35h<GPaN35h<GPaN35h?o2002o`0=5h<GPaN35h<GPaN3
5`03o`0T0?lGTaNC5`PGTaNC5i<GTaNC5on_oe8nDSiB?U8nDSiB?U;o1:l00ol000070003o`0001d0
00?o0000<P0002L00_lR000TonUmjGgYONUmjGgYOOl8[`R_oi<GTaNC5i<GTaNC5i<GTaNC0_l02`3o
5i<GTaNC5i<G00?o1@004_lGTaNC5i<GTaNC5i<GTaNC5`;o00h:/@Za2[4:/@Za2[4:o`B_00?o0000
1`000ol0000M0003o`000380000T00?o90009_mB;U8^DRiB;U8^DRko[`R_2:ooPaN35h<GPaN35h<G
PaN35h?o0P001_lGPaN35`?o2@008OlGTaNC5i<GTaNC5i<GTaNC5omB?U8nDSiB?U8nDSiBo`05[`03
o`0000H000?o00007P000ol0000a00008P02obL000cojGgYONUmjGgYONT2o`0C2:l8[`R_oi<GTaNC
5i<GTaNC5`03o`D000?o5ol00_l<000Qoi<GTaNC5i<GTaNC5i<GTaNCo`Za2[4:/@Za2[4:/@[o00J_
00?o00001@000ol0000N0003o`000340000O00?o:@002OmB;U8^DRiB;P03o`0BPon_2:l8[`R_oh<G
PaN35h<G0ol90003o`0000h000ooTaNC5i<GTaNC5i<GTaL00ol0358nDSiB?U8nDSiB?P;o1Zl00ol0
00050003o`0001l000?o0000<00001d00_l/0006onUmjGgY0ol04i<GTaNCojl8[`R_2:ooTaNC5i<0
0_lN000:oi<GTaNC5i<GT`?o0`002_l:/@Za2[4:/@X3o`03Ton_00F_00?o00001P000ol0000O0003
o`0002l0000K00;o;P001?mB;U82o`0@PaN35h<GPaN3ojl8[`R_20;o00B3oooo8@001_nC5i<GT`?o
1P002?mB?U8nDSiB0_l01Y<GTaNCo`F_00?o00001P000ol0000O0003o`0002l0000H00?o<004o`0B
5i<GTaNC5i<GTaNCojl8[`So0P000ol0000S0003oi?o00;o2@001_l:/@Za2P;o00TGTaNC5i<GTol0
1:l00ol000060003o`00020000?o0000;P0001L000?o0000<@005_lGPaN35h<GPaN35h<GPaN3ojl8
[olY0003o`0000X000?oDSh00ol039<GTaNC5i<GTaNCo`>_00?o00001P000ol0000Q0003o`0002d0
000G0003o`0002l00ol05I<GTaNC5i<GTaNC5i<GTaNCojl8o`0f00?o012C5i<GTaNC5i<GTaNC5i?o
0jl00ol000050003o`00024000?o0000;@0001L00_l]00?o01P^DRkoPaN35h<GPaN35h<GPaN35h?o
[olf000CoaNC5i<GTaNC5i<GTaNC5i<Go`03[`03o`0000D000?o00008P000ol0000/00005`000ol0
o`0Z00;o01T:O@Ym2Wd:oi<GTaNC5i<GTaNC5i<GTaNC00;o=P005?nC5i<GTaNC5i<GTaNC5i<GTaOo
0Zl00ol000050003o`0000;o80000ol0000/00005P001Ol0003o02H00ol0258^DRiB;U8^0ol04X<G
PaN35h<GPaN35h<GPaN3ocL001KoTaNC5i<GTaNC5i<GTaNC5i<Gojoo1`03o`03:_l0020000?o0000
:`0001H000?o00000P000ol0000R000<ogd:O@Ym2Wd:O@Ym0_l03jooTaNC5i<GTaNC5i<GT`02ocX0
01?oTaNC5i<GTaNC5i<GTaNC5i<G00;o1004o`03D/5B00;o8@000ol0000Z00005P000ol000030003
o`00024001_o;U8^DRiB;U8^DRko[`So5h<GPaN35h<GPaL00_ll000FoaNC5i<GTaNC5i<GTaNC5i<G
TaOo00?o00XZ?R[o:ShZojoo80000ol0000Z00005P000ol000040003o`00020001SoO@Ym2Wd:O@Ym
2Wgo_jnooaNC5i<GTaL3ocl000oo5i<GTaNC5i<GTaNC5i<01_l03L5B`E;1D_mB`E;o[ol08@000ol0
000Y00005P000ol000050003o`0001l001Ko;U8^DRiB;U8^DRko[`R_2?lGPaN30_m3000<oaNC5i<G
TaNC5i<G0_l04@3oobXn:ShZ?RXn:_lZ?R[o00:_00?o00007`000ol0000X00005P000ol000060003
o`0001h001CoO@Ym2Wd:O@Ym2Wgo_jno[koo5`;oAP002?lGTaNC5i<G0ol3000@ol5B`E;1D/5B`E;o
D/5Bo`:_00?o00007`000ol0000X00005P000ol000070003o`0001d001Ko;U8^DRiB;U8^DRko[`R_
2:l8o`SoAP001_nC5i<GT`;o1P004?ln:ShZ?RXn:ShZobXn:_l3[`03o`0001l000?o00009`0001D0
00?o00002@000ol0000L000;ogd:O@Ym2Wd:O@X00_l02Kn__jno[kn_o`170003oi?o00;o20004?o1
D/5B`E;1D/5Boe;1D_l4[`03o`0001h000?o00009`0001D000?o00002P000ol0000J000:oe8^DRiB
;U8^DP;o00^Cojl8[`R_2:l8o`180003o`0000T0013o?RXn:ShZ?RXn:_lZ?R[o1:l00ol0000O0003
o`0002H0000E0003o`0000/000?o00006@002?l:O@Ym2Wd:0_l03ANC5i?o[kn__jno[ol0E0004?o1
D/5B`E;1D/5Boe;1D_l5[`03o`0001l000?o00009@0001D000?o000030000ol0000H0005oe8^DRh0
0ol03i<GTaNC5i?o[`R_2:l8o`1D000@ochZ?RXn:ShZ?RXnochZo`F_00?o00007`000ol0000U0000
5@000ol0000=0003o`0001L000?o2Wd00_l04Y<GTaNC5i<GTaNCojno[kn_oe@000ko`E;1D/5B`E;1
D/7o`@;o1Jl00ol0000P0003o`0002@0000E0003o`0000h000?o00005P03o`0C5i<GTaNC5i<GTaNC
5i?o[`R_o`1E000;ochZ?RXn:ShZ?RX00ol00aOo[`04[`03o`00024000?o00008`0001@000?o0000
40000ol0000E000Foi<GTaNC5i<GTaNC5i<GTaOo_jnooeD000So`E;1D/5B`@?o00HGoaM[5ol4[`03
o`00024000?o00008`0001@000?o00004@000ol0000D00;o01BC5i<GTaNC5i<GTaNC5i<Go`R_oeD0
00Go?RXn:P03o`0:5f/GJom[5f/Go`>_00?o00008P000ol0000R000050000ol0000B0003o`0001@0
0_l04i<GTaNC5i<GTaNC5i<GTaOo_ol0E@000oo1o`02o`0=5f/GJaM[5olGJaM[o`03[`03o`000280
00?o00008P0001@000?o00004`000ol0000D00;o012C5i<GTaNC5i<GTaNC5i<G0_mE00;o014GJaM[
5f/GJaM[of/GJaM[o`03[`03o`00028000?o00008@0001@000?o000050000ol0000D00;o016C5i<G
TaNC5i<GTaNC5i<Go`1E000DoaM[5f/GJaM[5f/GoaM[5f/GJol2[`03o`0002<000?o0000800001@0
00?o00005@000ol0000D00;o00jC5i<GTaNC5i<GTaNCoeP001Ko5f/GJaM[5f/GJom[5f/GJaM[ojoo
9@000ol0000P000050000ol0000F0003o`0001401Ol01i<GTaNC5i<00omL000EoaM[5f/GJaM[5olG
JaM[5f/Gojoo02H000?o00007`0001<000?o000060000ol0000>00;o00@nDSiB0_l019<GTaL2oel0
01?oJaM[5f/GJaM[of/GJaM[5f/G00;o9`000ol0000N00004`000ol0000I0003o`0000/00_l01[4:
/@Za2P;o00@GooooHP005?m[5f/GJaM[5olGJaM[5f/GJaOo9`000ol0000N00004`000ol0000J0003
o`0000L00ol03CiB?U8nDSiBojoo[ol0I0003_m[5f/GJaM[of/GJaM[0ol900;o7`000ol0000M0000
4`000ol0000K0003o`0000D001;o2[4:/@Za2[4:/@[o[`R_2?mT000:of/GJaM[5olGJ`?o2@03o`03
2_l001h000?o00007@0001<000?o000070000ol00004000Coe8nDSiB?U8nDSiBojno[kn_o`1S0007
oaM[5f/GJ`03o`X00_l013ib?W82oal000?o0000700001<000?o00007@000ol00003000Do`Za2[4:
/@Za2[7o2:l8[`R_2?mS0003oaM[00Co2@03o`09h@[Q2^4:ojoo01l000?o00006`00018000?o0000
7`000ol00002000Eoe8nDSiB?U8nDSko_jno[kn__joo06<00_l30003o`0000D00_l0378nLSib?W8n
L_n_oal000?o00006`00018000?o000080006_l0003o2[4:/@ZaPk4:/Ol8[`R_2:l8[`SoJ0001?l0
0003o`0<2^4:h@[Q2^4:h@[o0Zl00ol0000M0003o`0001X0000B0003o`00024001Wo003oDSiB?U8n
DSiB?_no[kn__jno[koo06P001?o003o?W8nLSib?W8nLSib?W;o00>_00?o00007@000ol0000I0000
4P000ol0000R00;o00Za2[4:/@Za2[4:0_l02PR_2:l8[`R_2?mX000Do`00on4:h@[Q2^4:h@[Q2^4:
hOl3[`03o`0001`000?o00006@00018000?o00008`002?lnDSiB?U8n0ol039<Gojno[kn__jnoofP0
01Co003o?W8nLSib?W8nLSib?W8no`>_00?o00007@000ol0000H00004P000ol0000S0006ok4:/@Za
0_l03i<GTaNC5ol8[`R_2:l8o`1X000Do`00on4:h@[Q2^4:h@[Q2^4:hOl4[`03o`0001`000?o0000
6000014000?o000090001?lnDSh2o`0A5i<GTaNC5i<Gojno[kn__ol0J0005?l00?lnLSib?W8nLSib
?W8nLSko1Jl00ol0000L0003o`0001L0000A0003o`0002@01?l04Y<GTaNC5i<GTaNC5ol8[`R_ofT0
01Co003oh@[Q2^4:h@[Q2^4:h@[Qo`F_00?o00007@000ol0000F00004@000ol0000T000Foi<GTaNC
5i<GTaNC5i<GTaOo[kn_ofT001Co003o?W8nLSib?W8nLSib?W8no`F_00?o00007@000ol0000F0000
4@000ol0000T000FoaNC5i<GTaNC5i<GTaNC5i<Go`R_ofT001;o0000o`[Q2^4:h@[Q2^4:h@X2o`F_
00?o00007P000ol0000E00004@000ol0000U000EoaNC5i<GTaNC5i<GTaNC5i<Gojoo06T000oo0000
og8nLSib?W8nLSh00ol00k?o[`04[`03o`0001l000?o00005000014000?o00009P004_lGTaNC5i<G
TaNC5i<GTaNC5`;oJ@003?l0003o2^4:h@[Q2P?o00Jc5[<F/ol4[`03o`0001l000?o000050000140
00?o00009`004olGTaNC5i<GTaNC5i<GTaNC5ol0J@002Ol0003oLSib?P03o`0:/aNc5k<G/aNco`>_
00?o000080000ol0000C000040000ol0000Y000=oaNC5i<GTaNC5i<GT`03of/000Ko0000o`X3o`0>
/aJc5[<F/aJc5[<F/ol3[`03o`0001l000?o00004`00010000?o0000:P002OlGTaNC5i<GT`03ofh0
00Co00000_l04[<G/aNc5k<G/aNc5k<G/aNco`:_00?o000080000ol0000B000040000ol0000[0006
oaNC5i<G0_ma000Ho`000?nc5[<F/aJc5[<F/aJc5[<F/aKo0Zl00ol0000O00?o4`00010000?o0000
;0000olGo`02og<000?o00000P005_nc5k<G/aNc5k<G/aNc5k<G/aOo[olN00?o0P000ol0000A0000
40000ol0000/00?o00=Bool0LP000ol00003000Cok<F/aJc5[<F/aJc5[<F/aJc5P02oa/00ol50003
o`000140000@0003o`0002X00_l013hZ?RX3og8000?o00000`005?nc5k<G/aNc5k<G/aNc5k<G/aOo
6003o`P000?o00004@0000l000?o0000:@02o`08`E;1D/5Bojl2og4000?o000010003_nc5[<F/aJc
5[<F/aJc0olG00?o2`000ol0000A00003`000ol0000V00?o00/n:ShZ?RXn:_l8[`02og0000?o0000
10002olG/aNc5k<G/aNc00?o5`03o`l000?o0000400000l000?o00009@004?mB`E;1D/5B`E;1D_n_
_jl2ofl000?o00001@001olF/aJc5[<00olG00?o4P000ol0000@00003`000ol0000U000AobXn:ShZ
?RXn:ShZo`R_2:l00_m^0003o`0000H000?o5k<00olG00?o5@000ol0000@00003`000ol0000U000B
oe;1D/5B`E;1D/7o_jno[kn_0_m]0003o`0000L00_lG00?o60000ol0000@00003`000ol0000U000C
obXn:ShZ?RXn:Sko[`R_2:l8[`02of`000?o00006@02o`800olK0003o`000100000?0003o`0002@0
01Go`E;1D/5B`E;1D/7o_jno[kn__jl00_m[0003o`0001H00ol015;ooolN0003o`000100000>0003
o`0002D001So?RXn:ShZ?RXn:Sko[`R_2:l8[`So0?mZ0003o`0001<00ol013ib?W82oal000?o0000
400000h000?o00009@005_o1D/5B`E;1D/5B`Ono[kn__jno[ol20003o`0006L000?o00004003o`0:
DQ9B4U8BD_l@oal000?o00003`0000h000?o00009@002_ln:ShZ?RXn:Sh3o`09[`R_2:l8[`So00<0
00?o0000IP000ol0000=00?o00hnLSib?W8nLSib?_n_oah000?o00003`0000h000?o00009@001oo1
D/5B`E800ol036/GJon__jno[kn_o`@000?o0000I@000ol0000;00;o019B4U8BDQ9B4U8BDQ9B4_n_
4?lM0003o`0000l0000>0003o`0002@000Go:ShZ?P03o`0?JaM[5f/GJon_2:l8[`So00D000?o0000
I0000ol0000:00;o010nLSib?W8nLSib?W8nLSko0Zl00ol0000K0003o`0000l0000>0003o`0002@0
00?oD_l00_l04F/GJaM[5f/GJaM[ojno[koo00L000?o0000H`000ol0000700?o01H0oa9B4U8BDQ9B
4U8BDQ9B4_n_4:oo70000ol0000?00003@000ol0000U00;o01A[5f/GJaM[5f/GJaM[5f_o[`R_o`P0
00?o0000HP000ol0000400?o10004OlnLSib?W8nLSib?W8nLSko00B_00?o00006@000ol0000?0000
3@000ol0000V000EoaM[5f/GJaM[5f/GJaM[5f_o[koo00T000?o0000H@001?l00003o`L001Oo4U8B
DQ9B4U8BDQ9B4U8Bojl@[a2_o`0J0003o`0000l0000=0003o`0002L001Co5f/GJaM[5f/GJaM[5f/G
Jon_o`X000?o0000H004o`X001;o?W8nLSib?W8nLSib?W8nL_l4[`03o`0001P000?o00003`0000d0
00?o0000:0004OlGJaM[5f/GJaM[5f/GJaM[00;o2`000ol0001M00Co30005olBDQ9B4U8BDQ9B4U8B
DQ9Boa2_4:oo01/000?o00003P0000d000?o0000:@004_lGJaM[5f/GJaM[5f/GJaM[o``000?o0000
F@03o`<000?o00002`003_mb?W8nLSib?W8nLSib0ol4[`03o`0001T000?o00003P0000d000?o0000
:P003?lGJaM[5f/GJaM[5`?o3`000ol0001E00?o1P000ol0000;000;oe8BDQ9B4U8BDQ800ol021Jc
oa2_4:oo6`000ol0000>00003@000ol0000[0009oaM[5f/GJaM[00;o4`000ol0001A00?o2@000ol0
000;0008og8nLSib?W83o`075l<G`aO3o`03[`03o`0001T000?o00003P0000`000?o0000;@001_lG
JaM[5`;o5P000ol0001=00?o30000ol0000;0005oe8BDQ800ol03QJc5[<F/aJc5[?o4:oo6`000ol0
000>000030000ol0000^0003oaOo00;o6@000ol0001900?o3`000ol0000;0003og;o00;o00hG`aO3
5l<G`aO35l<Go`>_00?o000060000ol0000>000030000ol0000_0003o`0001/000?o0000A@03oa80
00?o00002`02o`0E5[<F/aJc5[<F/aJc5[<F/aKo[a3o01X000?o00003P0000`000?o0000=P02oaH0
00?o0000@@03oaD000?o00002`005olG`aO35l<G`aO35l<G`aO35l<Gojoo01/000?o00003@0000`0
00?o0000<`03o`03hOoo01H000?o0000?@03oaP000?o000030005_lF/aJc5[<F/aJc5[<F/aJc5[?o
4?lK0003o`0000d0000<0003o`0003000ol01g8nLSko[ol05P000ol0000h00Co6`000ol0000=000C
oaO35l<G`aO35l<G`aO35l<G``02oa/000?o00003@0000/000?o0000;`02o`0;h@[Q2^4:hOno0ol0
5P000ol0000d00?o7`000ol0000>000DoaJc5[<F/aJc5[<F/aJc5[<F/olK0003o`0000d0000;0003
o`0002`00ol03Sib?W8nLSib?_n_2:oo5P000ol0000`00?o8P000ol0000?000>oaO35l<G`aO35l<G
`aL3oad000?o00003@0000/000?o0000:`004ol:h@[Q2^4:h@[Q2^7o_`>o0ol05P000ol0000/00?o
9@000ol0000?000;ok<F/aJc5[<F/aH00olP0003o`0000d0000;0003o`0002/001CoLSib?W8nLSib
?W8nojl8[`R_oaH000?o0000:003obP000?o000040001oo35l<G`aL00olS0003o`0000d0000;0003
o`0002/001Go2^4:h@[Q2^4:h@[o0kl3_`>o0ol05P000ol0000T00?o:`000ol0000A0003ok<F00?o
9`000ol0000<00002`000ol0000[000Fog8nLSib?W8nLSibo`R_2:l8[`R_oaH000?o00008003obh0
00?o00004P02obX000?o0000300000X000?o0000;0005_l:h@[Q2^4:h@[Q2_l3_`>o0kl3_olG0003
o`0001`00ola0003o`0003h000?o0000300000X000?o0000;0005_mb?W8nLSib?W8nL_l8[`R_2:l8
[olH0003o`0001P00ole0003o`0001l00_lL0003o`0000`0000:0003o`0002`001Ko2^4:h@[Q2^4:
h@[o0kl3_`>o0koo6@000ol0000D00?o>0000ol0000L00?o00=Bo`006`000ol0000<00002P000ol0
000[000<ocib?W8nLSib?W8n0_l02@R_2:l8[`R_o`0J0003o`0001000olk0003o`0001T00ol013j2
?X82oa/000?o0000300000X000?o0000:`002OoQ2^4:h@[Q2P03o`0;/aKo_`>o0kl3_ol06`000ol0
000<00?o?P000ol0000F00?o00YBjE;YD^UBojoo6P000ol0000<00002P000ol0000[0006ocib?W8n
0ol03[<G/aNc5ol8[`R_2:oo70000ol0000800?o@@000ol0000C00?o00dnPSj2?X8nPSj2ojoo01X0
00?o0000300000X000?o0000:`001?oQ2^42o`0@/aJc5[<F/aJc5_no0kl3oah000?o00001003od@0
00?o00004@02o`0>D^UBjE;YD^UBjE;YD_l2[`03o`0001P000?o00002`0000T000?o0000;004o`0B
5k<G/aNc5k<G/aNc5ol8[`So7`000ol00003odL000?o00004@004?lnPSj2?X8nPSj2?X8nP_l3[`03
o`0001L000?o00002`0000T000?o0000;0005_lF/aJc5[<F/aJc5[<F/aJc5_no0olP00;oBP000ol0
000A000@onUBjE;YD^UBjE;YD^UBo`>_00?o00005`000ol0000;00002@000ol0000^000Dok<G/aNc
5k<G/aNc5k<G/aOo2?lP0003o`0004L00olC000Aocj2?X8nPSj2?X8nPSj2?_l00jl00ol0000F0003
o`0000/000090003o`0002l0017o/aJc5[<F/aJc5[<F/aJc5P02ob0000?o0000A003o`8000?o0000
4@004OoYD^UBjE;YD^UBjE;YD^Wo00B_00?o00005@000ol0000;00002@000ol0000`00;o010G/aNc
5k<G/aNc5k<G/aOo80000ol0001100?o1P000ol0000@000Aocj2?X8nPSj2?X8nPSj2?_l01:l00ol0
000E0003o`0000/000090003o`00038000_o5[<F/aJc5[<F/`03ob8000?o0000?P03o`X000?o0000
3`004OoYD^UBjE;YD^UBjE;YD^Wo00B_00?o00005@000ol0000;000020000ol0000d0007oaNc5k<G
/`03obD000?o0000>`03o`h000?o00003`004?n2?X8nPSj2?X8nPSj2?_l4[`03o`0001H000?o0000
2P0000P000?o0000=@000olF/`03obP000?o0000=`04oa8000?o00003P004?mBjE;YD^UBjE;YD^UB
jOl4[`03o`0001H000?o00002P0000P000?o0000=P02ob/000?o0000=003oaH000?o00003P003On2
?X8nPSj2?X8nPSh00ol4[`03o`0001H000?o00002P0000P000?o0000H`000ol0000a00?o6P000ol0
000=0009oe;YD^UBjE;Y00Co00?C5_l01:l00ol0000F0003o`0000X000080003o`0006<000?o0000
;P03oah000?o000030001_n2?X8nPP?o00PG`aO35l<Go`B_00?o00005@000ol0000:000020000ol0
001100?o7`000ol0000[00?o8P000ol0000;0003oe;o00?o00`FdaKC5]<FdaKC5_l3[`03o`0001D0
00?o00002P0000P000?o0000?P03o`04L_l8oah000?o00009`04obH000?o00002P02o`0A`aO35l<G
`aO35l<G`aO35ol00Zl00ol0000E0003o`0000X000070003o`0003`00ol0219B4U;o0koo7@000ol0
000T00?o:`000ol00009000Com<FdaKC5]<FdaKC5]<FdaKCo`02[`03o`0001D000?o00002P0000L0
00?o0000>@03o`0<LSib?W8nL_l8[`So70000ol0000Q00?o;P000ol0000:000Eol<G`aO35l<G`aO3
5l<G`aO3ojoo01P000?o00002@0000L000?o0000=`02o`0@4U8BDQ9B4U8BD_l3_`>ooaX000?o0000
7`03oc8000?o00002P004_oC5]<FdaKC5]<FdaKC5]<Fd`;o60000ol0000900001`000ol0000g000C
og8nLSib?W8nLSibo`R_2:l8o`0I0003o`0001/01?lf0003o`0000X001?o`aO35l<G`aO35l<G`aO3
5l?o01P000?o00002@0000L000?o0000=`005?mB4U8BDQ9B4U8BD_l3_`>o0koo60000ol0000H00?o
>`000ol00009000<oaKC5]<FdaKC5]<F1?lK0003o`0000T000070003o`0003L001GoLSib?W8nLSib
?_n_2:l8[`R_2?l05`000ol0000E00?o?`000ol000090008oaO35l<G`aL3oal000?o00002@0000H0
00?o0000=`005_lBDQ9B4U8BDQ9B4_no0kl3_`>o0olG0003o`0001800om20003o`0000X000?o5]<0
1?lR0003o`0000T000060003o`0003L001Ko?W8nLSib?W8nLSko[`R_2:l8[`So5`000ol0000?00?o
AP000ol0000:00;o9P000ol0000900001P000ol0000g000Foa9B4U8BDQ9B4U8Bokl3_`>o0kl3oaL0
00?o00002`04odX000?o0000<P000ol0000800001P000ol0000g000Focib?W8nLSib?W8nojl8[`R_
2:l8oaL000?o00002003odl000?o00004002oal000?o0000200000H000?o0000=`002_lBDQ9B4U8B
DQ84o`080kl3_`>o0olG0003o`0000D00omC0003o`0000`00ol00oWo000N0003o`0000P000060003
o`0003L000Oo?W8nLSib00?o00`G`aO3ojl8[`R_2?lG0003o`0000800omF0003o`0000T00ol0188n
PSh2oah000?o0000200000H000?o0000=P001OmB4U8B00?o00hF/aJc5[<F/ol3_`>ooaP000?o0?l0
0_mJ0003o`0000D00ol02_TZnB[i:_Wo[olM0003o`0000P000050003o`0003L000?oL_l00_l04AO3
5l<G`aO35l<G`on_2:oo01H01?mN0004o`0000?o00^2?X8nPSj2?X8no`02[`03o`0001X000?o0000
200000D000?o0000=`02o`0D5[<F/aJc5[<F/aJc5[<F/ol3_olC00?o0P000ol0001N00?o00ki:_TZ
nB[i:_TZnB[io`:_00?o00006P000ol0000800001@000ol0000i000DoaO35l<G`aO35l<G`aO35l?o
[ol@00?o1@000ol0001O000@oh8nPSj2?X8nPSj2?X8no`>_00?o00006P000ol0000700001@000ol0
000j000AoaJc5[<F/aJc5[<F/aJc5[<00_l=00?o20000ol0001O00;o00ki:_TZnB[i:_TZnB[io`B_
00?o00006@000ol0000700001@000ol0000k00;o01335l<G`aO35l<G`aO35l?o2P03o`/000?o0000
G`02o`0??X8nPSj2?X8nPSj2?X;o00B_00?o000060000ol0000700001@000ol0000m000;ok<F/aJc
5[<F/aH00ol800Co3P000ol0001O000Aob[o:_TZnB[i:_TZnB[i:_l01:l00ol0000H0003o`0000L0
00040003o`0003l000Oo`aO35l<G00?o2003oa8000?o0000G`004On2?_lnPSj2?X8nPSj2?X;o00B_
00?o000060000ol00007000010000ol000100003ok<F00?o2003oaD000?o0000G`004OlZnB[o:_TZ
nB[i:_TZnB[o00B_00?o000060000ol00007000010000ol0001100;o2003oaP000?o0000H0004?ln
PSko?X8nPSj2?X8nP_l4[`03o`0001P000?o00001`0000@000?o0000B003o`D00olC0003o`000600
013onB[iooTZnB[i:_TZnB[o1:l00ol0000H0003o`0000L000040003o`0004@01?l500?o00@nojoo
4P000ol0001P000=ocj2?X;oPSj2?X8nPP03o`B_00?o00006@000ol00006000010000ol0001100?o
1P03o`08D^UBjOno0olA0003o`00060000WonB[i:_WonBX01?l00aMCo`05[`03o`0001P000?o0000
1P0000<000?o0000?`03o`H00ol033j2?X8nPSko[`R_oa0000?o0000H0001_lnPSj2?P?o00P?5`lG
3aL?o`B_00?o000060000ol0000600000`000ol0000l00?o1`02o`0@D^UBjE;YD^UBjOno0kl3o`l0
00?o0000H0000ooio`03o`0<DaOo5e<GDaMC5e?o0jl00ol0000H0003o`0000H000030003o`0003T0
0ol:000Cocj2?X8nPSj2?X8nojl8[`R_o`0>0003o`0006000_l04AL?5`lG3ol?5`lG3aL?5`oo00:_
00?o000060000ol0000600000`000ol0000e00Co3@005?oYD^UBjE;YD^UBjOno0kl3_`?o3@000ol0
001P000FoaMC5e<GDaMCoe<GDaMC5e<GDon_oaX000?o00001P0000<000?o0000<P03oa4001Go?X8n
PSj2?X8nP_l8[`R_2:l8[ol02`000ol0001R000CoaL?5`lG3aL?o`lG3aL?5`lG3`02oaX000?o0000
1P0000<000?o0000;`03oa@001GojE;YD^UBjE;YD_l3_`>o0kl3_ol02`000ol0001S000DoaMC5e<G
DaMCoe<GDaMC5e<GDolK0003o`0000D000030003o`0002`00olG000Eocj2?X8nPSj2?X;o2:l8[`R_
2:oo00/000?o0000I0003_lG3aL?5`lG3ol?5`lG0olM0003o`0000D000020003o`0002T01?lJ000E
onUBjE;YD^UBjE;o0kl3_`>o0koo00/000?o0000I0002_mC5e<GDaMC5e<4ob0000?o00001@000080
00?o00009P03oad001KoPSj2?X8nPSj2?X;o2:l8[`R_2:oo2`000ol0001U0007o`lG3aL?5`03ob<0
00?o00001@00008000?o00008`03ob0001KoD^UBjE;YD^UBjE;o0kl3_`>o0koo2`000ol0001V0003
oe<G00?o0`000ol0000P0003o`0000D000020003o`0002000olS000:oh8nPSj2?X8nPPCo00R_2:l8
[`R_o`/000?o0000I@04o`03TSko00@000?o00007`000ol0000500000P000ol0000M00?o9P001_mB
jE;YDPCo00/FdaKCo`>o0kl3o`0<0003o`0006800ol01W;iL_Ubn@;o10000ol0000N0003o`0000D0
00020003o`0001T01?lY0003oh;o00?o00o35l<G`aO35l?o[`R_2?l030000ol0001N00Co00`nTSjB
?Y8nTSko[ol40003o`0001d000?o00001@0000030?l001P00ol]00;o00hFdaKC5]<FdaKC5]<Fd`;o
00>o0ol030000ol0001L00;o00kiL_UbnG;iL_UbnG;io`:_00Go0000o`0P0003o`0000@000000`3o
000E00?o<P004olG`aO35l<G`aO35l<G`aOo2?l030000ol0001L000@oi8nTSjB?Y8nTSjB?Y8no`:_
00?o00000P000ol0000M0003o`0000@000000`3o000B00?o=P004?lFdaKC5]<FdaKC5]<FdaH2o``0
00?o0000G0004?mbnG;iL_UbnG;iL_UbnOl3[`03o`00008000?o000070000ol00004000000<0o`00
3`03ocX0017o5l<G`aO35l<G`aO35l<Go`0<0003o`0005`0013oTSjB?Y8nTSjB?Y8nTSko1:l00ol0
00020003o`0001/000?o0000100000030?l000/01?ln000;oaKC5]<FdaKC5]<00ol>0003o`0005`0
017oL_UbnG;iL_UbnG;iL_Ubo`04[`03o`00008000?o00006P000ol00004000000<0o`002003od<0
00Oo5l<G`aO300?o4@000ol0001L000Aoi8nTSjB?Y8nTSjB?Y8nT_l01:l00ol000020003o`0001X0
00?o0000100000030?l000D00om70003oaKC00?o3@04o`<000?o0000G0004OmbnG;iL_UbnG;iL_Ub
nG;o00B_00?o00000`000ol0000I0003o`0000@000000ol0000200?oB`02o``01?l01Cj2o`So0080
00?o0000G0004OnB?Y8nTSjB?Y8nTSjB?Y;o00B_00?o000010000ol0000I0003o`0000<000000ol0
o`02oeP01?l03?TZnB[i:_n__ol0oel0013onG;iL_UbnG;iL_UbnG;o1:l00ol000050003o`0001P0
00?o00000`0000;oF@02o`0>?X8nPSj2?X8nP_l8[`P2oel0013o?Y8nTSjB?Y8nTSjB?Y;o1:l00ol0
00060003o`0001L000?o00000`00008000?o0000EP004olZnB[i:_TZnB[i:_n__jno[ol0GP003Ooi
L_UbnG;iL_UbnG800ol4[`03o`0000L000?o00005P000ol0000300000`02oeH001CoPSj2?X8nPSj2
?X;o2:l8[`R_oed000Wo?Y8nTSjB?Y801?l00`lGo`05[`03o`0000H000?o00005P000ol000030000
1@000ol0001C000Eob[i:_TZnB[i:_TZojno[kn__joo05`000KonG;iL_T3o`085b/G:aL[5ol4[`03
o`0000L000?o00005@000ol0000300001P000ol0001B000Eoh8nPSj2?X8nPSj2o`R_2:l8[`So05`0
00?o?_l00ol031L?5`lG3aL?5`lGo`>_00?o000020000ol0000D0003o`0000<0000700;oDP005OlZ
nB[i:_TZnB[i:_n__jno[kn_o`1L00;o014[5b/G:aL[5b/G:aL[5b/Go`02[`03o`0000T000?o0000
4`000ol0000300002@000ol0001?000Eoh8nPSj2?X8nPSj2o`R_2:l8[`So05`001Ko3aL?[`lG3aL?
5`lG3aL?5`lGojoo30000ol0000C0003o`000080000:00;oCP005_oi:_TZnB[i:_TZnB[o[kn__jno
[omM000Cob/G:aL[5b/GjGh[5b/G:aL[5`02o``000?o00004`000ol00002000030000ol0001;000F
ocj2?X8nPSj2?X8nP_l8[`R_2:l8oeh001Co3aL?5`lG3aL?5`lGjGkYOPlGo`d000?o00004P000ol0
000200003@000ol0001:000;ooTZnB[i:_TZnBX00ol02:no[kn__jooF`03o`0A4_l[5b/G:aL[5b/G
:aL[5ol04@000ol0000A0003o`000080000>00;oBP002?lnPSj2?X8n0ol02PlG3on_2:l8[omH00Co
00kYO^UnjOl?5`lG3aL?5`;o5P000ol0000@0003o`000080000@0003o`0004L000GonB[i:P03o`0=
DaMC5e<GDon__jnoo`1E00?o00en4WhBOQ9n4WhBob/G00Co6P000ol0000?0003o`000080000A00;o
A`000olno`02o`0@3aL?5`lG3aL?5`oo[`R_oe<00_l03GkYO^UnjGkYO^UnjGh01?lM0003o`0000l0
00?o00000P0001<000?o0000A002o`0CDaMC5e<GDaMC5e<GDaMCojnoo`1C000CoghBOQ9n4WhBOQ9n
4WhBo`P@o`0N0003o`0000l000?o00000@0001@00_m6000Co`lG3aL?5`lG3aL?5`lG3on_o`0800Co
A`005?oYO^UnjGkYO^UnjGkYO_n_2:oo7P000ol0000>0003o`000040000F0003o`0004@0013oDaMC
5e<GDaMC5e<GDaMC0_l300Go00GiL_n_o`16000EoghBOQ9n4WhBOQ9n4WhBo`P@213o01h000?o0000
3@000ol0000100005`000ol0001400;o00hG3aL?5`lG3aL?5`lG3`Co00^B?Y8nTSjBojnoo`15000E
onUnjGkYO^UnjGkYO^Unojl8[`So01l000?o000030000ol0000100006002odH000So5e<GDaMC5`Ko
011bnG;iL_UbnG;iL_n_2:ooA0005Omn4WhBOQ9n4WhBOQ9n4Wko40P@o`0P0003o`0000/000?o0000
0@0001X000?o0000A0000olG3`04o`<00_l04SjB?Y8nTSjB?Y8nT_n__jnood<001GojGkYO^UnjGkY
O^UnjGkYo`R_2?l080000ol0000;0003o`000040000K00;oA@02o`L00_l04oUbnG;iL_UbnG;iL_n_
2:l8[ol0@`005OlBOQ9n4WhBOQ9n4WhBO_l@2108o`0P0003o`0000X000?o00000@0001d000?o0000
B`02o`0D?Y8nTSjB?Y8nTSjBojno[kn__om2000EogkYO^UnjGkYO^UnjGkYo`R_2:oo024000?o0000
2P01o`400@0001h00_m;00;o01CiL_UbnG;iL_UbnOl8[`R_2:l8od8001Go4WhBOQ9n4WhBOQ9n4Wko
40P@2?l08P000ol00009007o0@01000080000ol0001800;o01@nTSjB?Y8nTSjB?_no[kn__jnood00
0ol037kYO^UnjGkYO^Unj@?o00D8[`R_o`0S0003o`0000P00Ol10040000Q0003o`0004L00_l05?Ub
nG;iL_UbnG;io`R_2:l8[`So?@03o`0:O^Wo4WhBOQ9n4PGo00Qc5g?o2108ob<000?o00002001o`40
0@0002800_m7000Foi8nTSjB?Y8nTSjB?_no[kn__jnoocT01?l027kYO^UnogkY1Ol03@lG3aL?5`lG
3ol8[ol090000ol00007007o0@01000090000ol00014000Fog;iL_UbnG;iL_UbnOl8[`R_2:l8ocH0
0ol02NUnjGkYO^Unj@03o`0BLaMc5g<GLaMc5g<GLaMco`So9@000ol00006007o0@0100009@02od@0
01KoTSjB?Y8nTSjB?Y8nokn__jno[koo2@04obL00_l08^UnjGkYO^UnjGkYO_lG3aL85`lG3aL?5`lG
3aL?5`oo2?lU0003o`0000D00Ol10040000W0003o`00044000_oL_UbnG;iL_Ubn@04o`07[`R_2:l8
o`0400Go00DBO_noo`0V000>onUnjGkYO^UnjGkYO^T2o`0B5g<GLaMc5oUnnAMc5g<GLaMc0_lV0003
o`0000@00Ol10040000X0003o`00040000KoTSjB?Y85o`0:5`lG3ono[kn__`Go00_YO^UnjGkYojl8
o`0U000TogkYO^UnjGkYO^UnjGko[olG3aL?5`lG3aL?5`lG3gkY5`oo9P000ol00005007o0@0002T0
0_m00003og;o00?o00hG:aL[5b/G:aL[ojl8[`;o011n4WhBOQ9n4WhBO_no[koo90003ooYO^UnjGkY
O^UnjGkYo`02[`0<oaMc5g<GLaMc5g<G1?lZ0003o`0000@00Ol10000:`000ol0000m00;o00l?5`lG
3aL?5`lG3aL?5`l00_l05:oo[nUnjGkYO^UnjGkYojl8[`So7P03o`8000koO^UnjGkYO^UnjGkYOP;o
00X8[olG3aL?5`lG0ol_0003o`0000<00Ol10000;002ocd001?o0?l[_b/G:aL[5b/G:aL[5b/G00;o
01<B219n4WhBOQ9n4Wko_jno[koo00X00ol=00?o00?YO_l00P003_oYO^UnjGkYO^UnjGkY0_l3[`03
oaMc00Co<`000ol00002007o0@0002h000?o0000>P00:Ol00?l?5`lG3gkYOPlG3aL?5`lGogkYO^Un
jGkYO^UnjOn_2:l8[`So00H00ol01>Unool800Co00GYO^Unj@02o`0?0?mnjGkYO^UnjGkYO^Un00;o
00@8[`R_0_lh0005o`000?l00@0002l00_lj000Yo`000?l[5b/G:aL[5b]njGkYOR_o4WhBO_mn4WhB
OQ9nokn__jno[ol00`03o`08jGkYO^Wo[ol400?o00]njGkYO^UnjGko[`02o`0?jGkYO^UnjGkYO^Un
jGko00B_00?o0000>0001?l00?l10000<@000ol0000g0003o`00008000co3aL?5`lG3aL?5`l2o`0E
0?mnjGkYO_mnjGkYO^Wo[`R_2:l800Co00gYO^UnjGkYO_l8[ol000;o02AnjGkYO^UnjGkYO^Wo2:oo
O^UnjGkYO^UnjGkYO^Wo2:l8[olj0004o`00o`40000b0003o`0003D000?o000010001?l[5b/4o`H0
01?o4WhBOQ9n4WhBOQ9nokn__jno00;o00oYO^UnjGkYO^UnjOn_2:l00_l087kYO^UnjGkYO^UnjGko
[`SojGkYO^UnjGkYO^UnjGko1:l00ol0000i0003o`00007o000c00;o=@000ol0000600;o2@02o`12
O^UnjGkYO^UnjGkYojl8[`R_onUnjGkYO^UnjGkYO_l8[`R_onUnjGkYO^UnjGkYO^Wo2:ooO^UnjGkY
O^UnjGkY0ol01@R_2:oo03`00Ol1007o000e0003o`00038000?o00004@02o`0n4WhBOQ9n4WhBOQ9n
okn__jnoogkYO^UnjGkYO^UnjOn_2:l8ogkYO^UnjGkYO^UnjGko[`SojGkYO^UnjGh4o`03PaOo00F_
00?o0000>P02o`00=P02oc8000?o00004@00?OoYO^UnjGkYO^UnjGkYojl8[`R_onUnjGkYO^UnjGkY
O_l8[`R_onUnjGkYO^UnjGkYO^UnojooO^UnjGh00ol03AL?5`lG3aOo[`R_2?l0>`03o`00>0000ol0
000_0003o`00014000coOQ9n4WhBOQ9n4Wh4o`0Y[kn__omnjGkYO^UnjGkYO^Wo[`R_2?mnjGkYO^Un
jGkYO^UnjOl8onT01?l031N35h<GPaN35h<Go`>_00?o0000=005o`<0000i0003o`0002h000?o0000
4@001ooYO^UnjGh01Ol0:aL?5`oo[`R_onUnjGkYO^UnjGkYO_l8[`R_onUnjGkYO^UnjGkYO^Unojl0
0_l050lG3aL?5`lG3aL?5`lG3aOo[`So<P04o`P0000j00;o;P000ol0000A0003ogko00Co04HGLaMc
5g<GLaMcojnoogkYO^UnjGkYO^UnjOn_2:l8ogkYO^UnjGkYO^UnjGkYo`R_2?n35h<GPaN35h<GPaN3
5h<Gojoo;P04o``0000l0003o`0002/000?o00004@02o`195`lG3aL?5`lG3aL?5`lG3on_onUnjGkY
O^UnjGkYO_l8[`R_2?mnjGkYO^UnjGkYO^Unojl8[`So3aL?5`lG3aL?5`lG3aL?5`02obT01Ol@0000
?@02ob/000?o00004`004OlG[aMc5g<GLaMc5g<GLaMc00;o02EnjGkYO^UnjGkYO^Wo[`R_2:oojGkY
O^UnjGkYO^UnjOl8[`R_00;o01635h<GPaN35h<GPaN35h<Go`0U00Co5@0003l000?o0000:0000ol0
000D000`oaL?5`lGjGkY5`lG3aL?5`oojGkYO^UnjGkYO^Uno`R_2:l8ogkYO^UnjGkYO^Un0ol01Jl8
[`R_00;o00P?5`lG3aL?5`Go8`05oaT0001000;o:0000ol0000E000KoaMc5g<GLaMc5g<GLgki5omn
jGkYO^UnjGkY00Co00d8[`R_onUnjGkYO^Un00?o00dGPaOo[`R_2?l0oh<G00Go9004oah000120003
o`0002D000?o00005`002?l?5`lG3aL?1Ol01`3ojGkYO^T01Ol03@lG3aOo2:l8ogkYO^T01?l031L?
5`lG3aOo[`R_o`800_lT00Go8P0004<000?o000090000ol0000H0003og<G00Co1P000omno`03o`0?
PaN35h<GPaN35ol8[ooY00?o01235h<GPaN35h<GPaOo[`So9004obL0001400;o90000ol0000I00;o
2P02o`0A5`lG3aL?5`lG3aL?5`lGo`P00_l04`lG3aL?5`lG3aL?5`lG3aOo[ol08004ob/000160003
o`00024000?o00009`004_lGPaN35h<GPaN35h<GPaOo20;o01235h<GPaN35h<GPaN35h<G0_lK00Go
;`0004L00_lQ0003o`0002P0013o5`lG3aL?5`lG3aL?5`lG0_l04`3o3aL?5`lG3aL?5`lG3aL?5ol0
5`04oc@000190003o`0001h000?o0000:@004OlGPaN35h<GPaN35h<GPaOo008000WoPaN35h<GPaL0
1OlE00Go>00004X000?o00007@000ol0000Z0008oaL?5`lG3aL5o`H000?o3aL01OlF00Co?@0004/0
0_lM0003o`0002/000?o5h<01?l<00;o5`04od40001=0003o`0001X000?o0000;002ob@01Om50000
CP02oaX000?o0000CP04odX0001@0003o`0001L000?o0000B@05odh0001A00;o5`000ol0001500Co
D`0005<000?o000050000ol0001000GoE`0005@000?o00004`000ol0000l00CoG00005D00_lC0003
o`0003P01?mP0000E`000ol0000@0003o`0003<01OmT0000F002o`l000?o0000<004ofT0001J0003
o`0000`000?o0000:`05ofd0001K00;o30000ol0000W00CoLP0005d000?o00002@000ol0000S00Co
MP0005h000?o000020000ol0000N00GoNP0005l00_l80003o`0001X01?mo0000H@000ol000050003
o`0001D01On30000HP02o`D000?o00004@04ohP0001T0003o`00008000?o00003005oh`0001U0005
o`000?l02P04oi40001V00;o00<0o`001@04oiD0001X00;o00<0ool00onI0000J@02oih00000\
\>"],
  ImageRangeCache->{{{0, 264.312}, {287, 0}} -> {0.0486402, -0.000148683, 
  0.00324458, 0.00324458}}]
}, Closed]],

Cell[TextData[{
  "Here is a list called ",
  StyleBox["elts", "Input"],
  " that contains several records, where each record contains the name of a \
chemical element, its abbreviation, its heat of fusion (in kilojoules per \
mole), and its atomic number."
}], "Text"],

Cell["\<\
elts =

{{Hydrogen, \"H\", 0.12, 1},
 {Lithium, \"Li\", 4.6, 3}, 
 {Sodium, \"Na\", 2.64, 11},
 {Potassium, \"K\", 2.4, 19}, 
 {Rubidium, \"Rb\", 2.2, 37},
 {Cesium, \"Cs\", 2.09, 55}, 
 {Lanthanum, \"La\", 10.04, 57}, 
 {Terbium, \"Tb\", 16.3, 65}};\
\>", "Input"],

Cell[TextData[{
  "Here we define a function ",
  StyleBox["placeabbr", "Input"],
  " that accepts a list of four items, then returns a graphics primitive of \
the abbreviation placed at the {",
  StyleBox["atomic number",
    FontSlant->"Italic"],
  ", ",
  StyleBox["heat of fusion",
    FontSlant->"Italic"],
  "} coordinate. (The element name is discarded.)"
}], "Text"],

Cell[BoxData[
    \(placeabbr[{_, ab_String, hof_, atno_}] := Text[ab, {atno, hof}]\)], 
  "Input"],

Cell[TextData[{
  "Mapping ",
  StyleBox["placeabbr", "Input"],
  " over the list ",
  StyleBox["elts", "Input"],
  " generates a list of the text graphics primitives corresponding to each \
record in ",
  StyleBox["elts", "Input"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(graphelts = Map[placeabbr, elts]\)], "Input"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{"Text", "[", 
          RowBox[{"\(\"H\"\)", ",", 
            RowBox[{"{", 
              RowBox[{"1", ",", 
                StyleBox["0.119999999999999996`",
                  StyleBoxAutoDelete->True,
                  PrintPrecision->2]}], "}"}]}], "]"}], ",", 
        RowBox[{"Text", "[", 
          RowBox[{"\(\"Li\"\)", ",", 
            RowBox[{"{", 
              RowBox[{"3", ",", 
                StyleBox["4.59999999999999964`",
                  StyleBoxAutoDelete->True,
                  PrintPrecision->2]}], "}"}]}], "]"}], ",", 
        RowBox[{"Text", "[", 
          RowBox[{"\(\"Na\"\)", ",", 
            RowBox[{"{", 
              RowBox[{"11", ",", 
                StyleBox["2.64000000000000012`",
                  StyleBoxAutoDelete->True,
                  PrintPrecision->3]}], "}"}]}], "]"}], ",", 
        RowBox[{"Text", "[", 
          RowBox[{"\(\"K\"\)", ",", 
            RowBox[{"{", 
              RowBox[{"19", ",", 
                StyleBox["2.39999999999999991`",
                  StyleBoxAutoDelete->True,
                  PrintPrecision->2]}], "}"}]}], "]"}], ",", 
        RowBox[{"Text", "[", 
          RowBox[{"\(\"Rb\"\)", ",", 
            RowBox[{"{", 
              RowBox[{"37", ",", 
                StyleBox["2.20000000000000017`",
                  StyleBoxAutoDelete->True,
                  PrintPrecision->2]}], "}"}]}], "]"}], ",", 
        RowBox[{"Text", "[", 
          RowBox[{"\(\"Cs\"\)", ",", 
            RowBox[{"{", 
              RowBox[{"55", ",", 
                StyleBox["2.08999999999999985`",
                  StyleBoxAutoDelete->True,
                  PrintPrecision->3]}], "}"}]}], "]"}], ",", 
        RowBox[{"Text", "[", 
          RowBox[{"\(\"La\"\)", ",", 
            RowBox[{"{", 
              RowBox[{"57", ",", 
                StyleBox["10.04`",
                  StyleBoxAutoDelete->True,
                  PrintPrecision->4]}], "}"}]}], "]"}], ",", 
        RowBox[{"Text", "[", 
          RowBox[{"\(\"Tb\"\)", ",", 
            RowBox[{"{", 
              RowBox[{"65", ",", 
                StyleBox["16.3000000000000007`",
                  StyleBoxAutoDelete->True,
                  PrintPrecision->3]}], "}"}]}], "]"}]}], "}"}]], "Output"]
}, Closed]],

Cell["Here is a plot of the resulting graphics primitives.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(Show[Graphics[graphelts], Frame \[Rule] True, 
      PlotRange \[Rule] {{\(-1\), 67}, {\(-1\), 18}}, 
      TextStyle \[Rule] {FontFamily \[Rule] "Times", FontSize \[Rule] 9}, 
      FrameLabel \[Rule] {"Atomic number", "Heat of fusion"}]; \)\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0147059 0.0147059 0.0325281 0.0325281 [
[.01471 -0.0125 -4.5 -15 ]
[.01471 -0.0125 4.5 0 ]
[.16176 -0.0125 -7 -15 ]
[.16176 -0.0125 7 0 ]
[.30882 -0.0125 -7 -15 ]
[.30882 -0.0125 7 0 ]
[.45588 -0.0125 -7 -15 ]
[.45588 -0.0125 7 0 ]
[.60294 -0.0125 -7 -15 ]
[.60294 -0.0125 7 0 ]
[.75 -0.0125 -7 -15 ]
[.75 -0.0125 7 0 ]
[.89706 -0.0125 -7 -15 ]
[.89706 -0.0125 7 0 ]
[ 0 0 -0.125 0 ]
[.5 -0.0125 -32 -30 ]
[.5 -0.0125 32 -15 ]
[-0.0125 .03253 -9 -7.5 ]
[-0.0125 .03253 0 7.5 ]
[-0.0125 .11385 -16 -7.5 ]
[-0.0125 .11385 0 7.5 ]
[-0.0125 .19517 -9 -7.5 ]
[-0.0125 .19517 0 7.5 ]
[-0.0125 .27649 -16 -7.5 ]
[-0.0125 .27649 0 7.5 ]
[-0.0125 .35781 -14 -7.5 ]
[-0.0125 .35781 0 7.5 ]
[-0.0125 .43913 -21 -7.5 ]
[-0.0125 .43913 0 7.5 ]
[-0.0125 .52045 -14 -7.5 ]
[-0.0125 .52045 0 7.5 ]
[-0.0125 .60177 -21 -7.5 ]
[-0.0125 .60177 0 7.5 ]
[ 0 0 -0.125 0 ]
[-0.01875 .30902 -36 -29.5 ]
[-0.01875 .30902 -21 29.5 ]
[ 0 .61803 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.01471 0 m
.01471 .00625 L
s
gsave
.01471 -0.0125 -65.5 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 15.000000 moveto
/Times-Roman findfont 9.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0) show
1.000000 setlinewidth
grestore
.16176 0 m
.16176 .00625 L
s
gsave
.16176 -0.0125 -68 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 15.000000 moveto
/Times-Roman findfont 9.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(10) show
1.000000 setlinewidth
grestore
.30882 0 m
.30882 .00625 L
s
gsave
.30882 -0.0125 -68 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 15.000000 moveto
/Times-Roman findfont 9.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(20) show
1.000000 setlinewidth
grestore
.45588 0 m
.45588 .00625 L
s
gsave
.45588 -0.0125 -68 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 15.000000 moveto
/Times-Roman findfont 9.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(30) show
1.000000 setlinewidth
grestore
.60294 0 m
.60294 .00625 L
s
gsave
.60294 -0.0125 -68 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 15.000000 moveto
/Times-Roman findfont 9.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(40) show
1.000000 setlinewidth
grestore
.75 0 m
.75 .00625 L
s
gsave
.75 -0.0125 -68 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 15.000000 moveto
/Times-Roman findfont 9.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(50) show
1.000000 setlinewidth
grestore
.89706 0 m
.89706 .00625 L
s
gsave
.89706 -0.0125 -68 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 15.000000 moveto
/Times-Roman findfont 9.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(60) show
1.000000 setlinewidth
grestore
.125 Mabswid
.04412 0 m
.04412 .00375 L
s
.07353 0 m
.07353 .00375 L
s
.10294 0 m
.10294 .00375 L
s
.13235 0 m
.13235 .00375 L
s
.19118 0 m
.19118 .00375 L
s
.22059 0 m
.22059 .00375 L
s
.25 0 m
.25 .00375 L
s
.27941 0 m
.27941 .00375 L
s
.33824 0 m
.33824 .00375 L
s
.36765 0 m
.36765 .00375 L
s
.39706 0 m
.39706 .00375 L
s
.42647 0 m
.42647 .00375 L
s
.48529 0 m
.48529 .00375 L
s
.51471 0 m
.51471 .00375 L
s
.54412 0 m
.54412 .00375 L
s
.57353 0 m
.57353 .00375 L
s
.63235 0 m
.63235 .00375 L
s
.66176 0 m
.66176 .00375 L
s
.69118 0 m
.69118 .00375 L
s
.72059 0 m
.72059 .00375 L
s
.77941 0 m
.77941 .00375 L
s
.80882 0 m
.80882 .00375 L
s
.83824 0 m
.83824 .00375 L
s
.86765 0 m
.86765 .00375 L
s
.92647 0 m
.92647 .00375 L
s
.95588 0 m
.95588 .00375 L
s
.98529 0 m
.98529 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
gsave
.5 -0.0125 -93 -34 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 15.000000 moveto
/Times-Roman findfont 9.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
64.000000 15.000000 moveto
/Times-Roman findfont 9.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(Atomic) show
94.000000 15.000000 moveto
(number) show
123.000000 15.000000 moveto
/Times-Roman findfont 9.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
0 .03253 m
.00625 .03253 L
s
gsave
-0.0125 .03253 -70 -11.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 15.000000 moveto
/Times-Roman findfont 9.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(0) show
1.000000 setlinewidth
grestore
0 .11385 m
.00625 .11385 L
s
gsave
-0.0125 .11385 -77 -11.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 15.000000 moveto
/Times-Roman findfont 9.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(2.5) show
1.000000 setlinewidth
grestore
0 .19517 m
.00625 .19517 L
s
gsave
-0.0125 .19517 -70 -11.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 15.000000 moveto
/Times-Roman findfont 9.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(5) show
1.000000 setlinewidth
grestore
0 .27649 m
.00625 .27649 L
s
gsave
-0.0125 .27649 -77 -11.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 15.000000 moveto
/Times-Roman findfont 9.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(7.5) show
1.000000 setlinewidth
grestore
0 .35781 m
.00625 .35781 L
s
gsave
-0.0125 .35781 -75 -11.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 15.000000 moveto
/Times-Roman findfont 9.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(10) show
1.000000 setlinewidth
grestore
0 .43913 m
.00625 .43913 L
s
gsave
-0.0125 .43913 -82 -11.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 15.000000 moveto
/Times-Roman findfont 9.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(12.5) show
1.000000 setlinewidth
grestore
0 .52045 m
.00625 .52045 L
s
gsave
-0.0125 .52045 -75 -11.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 15.000000 moveto
/Times-Roman findfont 9.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(15) show
1.000000 setlinewidth
grestore
0 .60177 m
.00625 .60177 L
s
gsave
-0.0125 .60177 -82 -11.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 15.000000 moveto
/Times-Roman findfont 9.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(17.5) show
1.000000 setlinewidth
grestore
.125 Mabswid
0 .04879 m
.00375 .04879 L
s
0 .06506 m
.00375 .06506 L
s
0 .08132 m
.00375 .08132 L
s
0 .09758 m
.00375 .09758 L
s
0 .13011 m
.00375 .13011 L
s
0 .14638 m
.00375 .14638 L
s
0 .16264 m
.00375 .16264 L
s
0 .1789 m
.00375 .1789 L
s
0 .21143 m
.00375 .21143 L
s
0 .2277 m
.00375 .2277 L
s
0 .24396 m
.00375 .24396 L
s
0 .26022 m
.00375 .26022 L
s
0 .29275 m
.00375 .29275 L
s
0 .30902 m
.00375 .30902 L
s
0 .32528 m
.00375 .32528 L
s
0 .34155 m
.00375 .34155 L
s
0 .37407 m
.00375 .37407 L
s
0 .39034 m
.00375 .39034 L
s
0 .4066 m
.00375 .4066 L
s
0 .42287 m
.00375 .42287 L
s
0 .45539 m
.00375 .45539 L
s
0 .47166 m
.00375 .47166 L
s
0 .48792 m
.00375 .48792 L
s
0 .50419 m
.00375 .50419 L
s
0 .53671 m
.00375 .53671 L
s
0 .55298 m
.00375 .55298 L
s
0 .56924 m
.00375 .56924 L
s
0 .58551 m
.00375 .58551 L
s
0 .01626 m
.00375 .01626 L
s
.25 Mabswid
0 0 m
0 .61803 L
s
gsave
-0.01875 .30902 -119 -11.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
90.5 11.5 translate
90 rotate
-90.5 -11.5 translate
0 23 translate 1 -1 scale
63.000000 15.000000 moveto
/Times-Roman findfont 9.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 15.000000 moveto
/Times-Roman findfont 9.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(Heat) show
83.000000 15.000000 moveto
(of) show
94.000000 15.000000 moveto
(fusion) show
118.000000 15.000000 moveto
/Times-Roman findfont 9.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
.01471 .61178 m
.01471 .61803 L
s
.16176 .61178 m
.16176 .61803 L
s
.30882 .61178 m
.30882 .61803 L
s
.45588 .61178 m
.45588 .61803 L
s
.60294 .61178 m
.60294 .61803 L
s
.75 .61178 m
.75 .61803 L
s
.89706 .61178 m
.89706 .61803 L
s
.125 Mabswid
.04412 .61428 m
.04412 .61803 L
s
.07353 .61428 m
.07353 .61803 L
s
.10294 .61428 m
.10294 .61803 L
s
.13235 .61428 m
.13235 .61803 L
s
.19118 .61428 m
.19118 .61803 L
s
.22059 .61428 m
.22059 .61803 L
s
.25 .61428 m
.25 .61803 L
s
.27941 .61428 m
.27941 .61803 L
s
.33824 .61428 m
.33824 .61803 L
s
.36765 .61428 m
.36765 .61803 L
s
.39706 .61428 m
.39706 .61803 L
s
.42647 .61428 m
.42647 .61803 L
s
.48529 .61428 m
.48529 .61803 L
s
.51471 .61428 m
.51471 .61803 L
s
.54412 .61428 m
.54412 .61803 L
s
.57353 .61428 m
.57353 .61803 L
s
.63235 .61428 m
.63235 .61803 L
s
.66176 .61428 m
.66176 .61803 L
s
.69118 .61428 m
.69118 .61803 L
s
.72059 .61428 m
.72059 .61803 L
s
.77941 .61428 m
.77941 .61803 L
s
.80882 .61428 m
.80882 .61803 L
s
.83824 .61428 m
.83824 .61803 L
s
.86765 .61428 m
.86765 .61803 L
s
.92647 .61428 m
.92647 .61803 L
s
.95588 .61428 m
.95588 .61803 L
s
.98529 .61428 m
.98529 .61803 L
s
.25 Mabswid
0 .61803 m
1 .61803 L
s
.99375 .03253 m
1 .03253 L
s
.99375 .11385 m
1 .11385 L
s
.99375 .19517 m
1 .19517 L
s
.99375 .27649 m
1 .27649 L
s
.99375 .35781 m
1 .35781 L
s
.99375 .43913 m
1 .43913 L
s
.99375 .52045 m
1 .52045 L
s
.99375 .60177 m
1 .60177 L
s
.125 Mabswid
.99625 .04879 m
1 .04879 L
s
.99625 .06506 m
1 .06506 L
s
.99625 .08132 m
1 .08132 L
s
.99625 .09758 m
1 .09758 L
s
.99625 .13011 m
1 .13011 L
s
.99625 .14638 m
1 .14638 L
s
.99625 .16264 m
1 .16264 L
s
.99625 .1789 m
1 .1789 L
s
.99625 .21143 m
1 .21143 L
s
.99625 .2277 m
1 .2277 L
s
.99625 .24396 m
1 .24396 L
s
.99625 .26022 m
1 .26022 L
s
.99625 .29275 m
1 .29275 L
s
.99625 .30902 m
1 .30902 L
s
.99625 .32528 m
1 .32528 L
s
.99625 .34155 m
1 .34155 L
s
.99625 .37407 m
1 .37407 L
s
.99625 .39034 m
1 .39034 L
s
.99625 .4066 m
1 .4066 L
s
.99625 .42287 m
1 .42287 L
s
.99625 .45539 m
1 .45539 L
s
.99625 .47166 m
1 .47166 L
s
.99625 .48792 m
1 .48792 L
s
.99625 .50419 m
1 .50419 L
s
.99625 .53671 m
1 .53671 L
s
.99625 .55298 m
1 .55298 L
s
.99625 .56924 m
1 .56924 L
s
.99625 .58551 m
1 .58551 L
s
.99625 .01626 m
1 .01626 L
s
.25 Mabswid
1 0 m
1 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
gsave
.02941 .03643 -66.5 -11.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 15.000000 moveto
/Times-Roman findfont 9.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 15.000000 moveto
/Times-Roman findfont 9.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(H) show
70.000000 15.000000 moveto
/Times-Roman findfont 9.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
gsave
.05882 .18216 -67.5 -11.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 15.000000 moveto
/Times-Roman findfont 9.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 15.000000 moveto
/Times-Roman findfont 9.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(Li) show
72.000000 15.000000 moveto
/Times-Roman findfont 9.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
gsave
.17647 .1184 -68.5 -11.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 15.000000 moveto
/Times-Roman findfont 9.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 15.000000 moveto
/Times-Roman findfont 9.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(Na) show
74.000000 15.000000 moveto
/Times-Roman findfont 9.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
gsave
.29412 .1106 -66.5 -11.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 15.000000 moveto
/Times-Roman findfont 9.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 15.000000 moveto
/Times-Roman findfont 9.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(K) show
70.000000 15.000000 moveto
/Times-Roman findfont 9.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
gsave
.55882 .10409 -68.5 -11.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 15.000000 moveto
/Times-Roman findfont 9.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 15.000000 moveto
/Times-Roman findfont 9.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(Rb) show
74.000000 15.000000 moveto
/Times-Roman findfont 9.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
gsave
.82353 .10051 -67.5 -11.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 15.000000 moveto
/Times-Roman findfont 9.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 15.000000 moveto
/Times-Roman findfont 9.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(Cs) show
72.000000 15.000000 moveto
/Times-Roman findfont 9.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
gsave
.85294 .35911 -68 -11.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 15.000000 moveto
/Times-Roman findfont 9.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 15.000000 moveto
/Times-Roman findfont 9.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(La) show
73.000000 15.000000 moveto
/Times-Roman findfont 9.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
gsave
.97059 .56274 -68 -11.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 15.000000 moveto
/Times-Roman findfont 9.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 15.000000 moveto
/Times-Roman findfont 9.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(Tb) show
73.000000 15.000000 moveto
/Times-Roman findfont 9.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
grestore
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  Evaluatable->False,
  AspectRatioFixed->True,
  ImageSize->{288, 177.938},
  ImageMargins->{{35, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/@P10`4000010?ooobl_;oooZZVYZNSX
j?oo05FZZZZZZ_W0RS/k>gYjN[Vi^OShn03ooeGooj[ooonI<c<c<fi^KZf][Nc/k02ZoeFZojZZoonZ
oclo?ginO[fm_Oclo5D00:X00?l00?l0VCLg=g9bL[6a/O3`l03o05Go0:[o00<30d92@X61PL30`000
EED0EJX0EOl0ELbIoc/k>gIfM[Fe]OCdm03oEEGoEJ[oE@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0Z/`c
<clo?gYjN[Vi^OShn03oZUGoZZ[oZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`<30d92@WinO[fm_Ocl
o03ooeGooj[oo`l?3di>CXf=SLc<c01E05EE0:YE0?mE00L71dI6AX61PL30`000EED00:X00?l001<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@/;2dY:BXF5QLC4a000ZUD0EJX0EOl0EALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZPl?3di>CXV9RLS8b000oeD0ZZX0Z_l0ZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEoa<C
4e9BDXf=SLc<c01E05D0ojX0ool0oalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ01LG5eIFEY6ATM3@d01E
EEEE0:YE0?mE02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZEA/K6eYJFYFEUMCDe01EZUEEEJYEEOmEEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZQlO7eiNGYVIVMSHf01EoeEEZZYEZ_mEZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZob<S8f9RHYfMWMcLg02Z05EEojYEoomEobl_;fi^KZf][Nc/k03o05Go0:[o0=gW1RLW
9fIVIZ6QXN3Ph02ZEEFZ0:ZZ0?nZ03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooEB/[:fYZJZFUYNCTi02Z
ZUFZEJZZEOnZECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l08@000?l08@000?l08@000?l08@000?l0
8@0008D00ol0103oool20003o`0000;o0P001Ol0o`3o008000Co0?oo1@000ol0o`0300;o00H0o`3o
0?l200?o0P02o`030?l0064000260005o`000?l00P001?l00?l20007o`3o0?l0o`0200;o1`000ol0
o`020009o`3o0?l0o`3o008000?o00000_l30003o`000600002700Co0P001?l00?l20007o`3o0?l0
o`0200;o0P000ol000020003o`3o008000Wo0?l0o`3o0?l00P000ol00006of8000270003o`3o0080
0ol200;o0P05o`8000?o0?l00_l400;o0`001?l0o`05o`800ol200;o00<0ool0H@0008L000?o0?l0
0`000ol0000U0003o`0006P000280003o`00014000?o00005@02ofX0003o0240003o0240003o0240
003o0240003o0240003o0240003o0240003o0240003o0240000c00?o7003o`800olI00Go00@0oooo
6003o`<00olK0003o`0000?o6@04o`800olI00;o0`03oal0000b0005o`000?l070001?l00?l30003
o`0001L000Go0000o`030003o`0001P000?o0?l00`000ol0000H0003o`3o00<000?o00006P02o`<0
00?o00005@001_l00?l0o`<000?o00007000038000Go0000o`0L0004o`00o`<000?o000060001?l0
0?l30003o`0001P000?o0?l00`000ol0000E00Ko0`000ol0000J00;o0`000ol0000E0006o`00o`3o
0`000ol0000L0000<P001Ol0003o01`000Co003o0`000ol0000I0003o`3o00<000?o00005P02o`80
00Go0000o`0H0005o`3o0?l00`000ol0000F00Co00<0o`000P000ol0000E00?o0P001Ol0003o01h0
000b0005o`000?l070001?l00?l30003o`0001H000Co00000_l30003o`0001D000Ko003o0?l30003
o`0001L00_l00`3o00020003o`0001L000Go0000o`030003o`0001H000Go0000o`030003o`0001`0
000c00?o7002o`<00olJ00?o0P03oaT00ol200?o6`000ol00003oaX01?l0103ooolJ00;o0P03oal0
003o0240003o0240003o0240003o0240003o0240003o0240000b0>Co2P00038000Co003o1P000ol0
00030003o`0000@000?o000010000ol000030003o`0000@000?o000010000ol000030003o`0000@0
00?o000010000ol000030003o`0000@000?o000010000ol000030003o`0000@000?o000010000ol0
00030003o`0000@000?o000010000ol000030003o`0000@000?o000010000ol000030003o`0000@0
00?o000010000ol000030003o`0000@000?o000010000ol000040003o`0000<000?o000010000ol0
00040003o`0000<000Go0000o`0:0000<P001?l00?lP0003o`0001l000?o00007P000ol0000N0003
o`0001l000?o00007P000ol0000E0003o`0000P0000b0003o`000>0000?o00002000038000?o0000
g`02o`X0000Y00?o1P000ol0003P0003o`0000P0000X0005o`000?l01@000ol00003o`040?ooomT0
00?o0000200002P000Go0000o`050005o`000?l00`000ol0003H0003o`0000P0000X0005o`000?l0
1@02o`8000Go0000o`3H00?o2P0002P000Go0000o`050004o`0000GofP000ol000080000:@03o`H0
00Go0000o`030003o`000=P000?o00002000038000?o00000ol0103ooooH00;o2P00038000?o0000
h0000ol000080000<P000ol0003P0003o`0000P0000b0003o`000>0000?o00002000038000?o0000
g`02o`X0000b0003o`000>0000?o00002000038000?o0000h0000ol000080000<P000ol0003P0003
o`0000P0000b0003o`000=l00_l:0000<P000ol0003P0003o`0000P0000b0003o`000;@00ol200;o
9@000ol000080000<P000ol0001f00?o00@0ool00olc0005o`000?l00P02ob@000?o000020000380
00?o0000?003o`040?oooc@000Co003o0P001?l00?lb0003o`0000<000?o00008`02o`X0000Q00Ko
00<0ool00_l60003o`0003d000Co003o=P000ol0o`030004o`00oc8000?o00001002ob@000?o0000
2000028000?o00001`000ol000030003o`0001l00ol20003o`3o00;o50000ol0o`0g00?o0`03oc<0
00Go0000o`0X0003o`0000P0000S0003o`0000H000?o00000`02ob4000?o00000ol00`3o000D00?o
=`001?l00?l20003o`0003@01?lV00?o2P0002@000Co00001?l60003o`00020000?o00000_l00`3o
o`0E0004o`00ocD01?l200;oHP000ol0000800008@001Ol0003o00<000?o00001P000ol0000P0004
o`3o00?o5@03o`040?oooid000?o0000200002800ol400Co1@000ol0000P00;o0P000ol0002i0003
o`0000P0000b0003o`0001l00_l200?o^@02o`X0000b0003o`000>0000?o00002000038000?o0000
h0000ol000080000<P000ol0003P0003o`0000P0000b0003o`000=l00_l:0000<P000ol0003P0003
o`0000P0000b0003o`000>0000?o00002000038000?o0000g`02o`X0000b0003o`000>0000?o0000
2000038000?o00001@05o`030?l00=<000?o00002000038000?o00001P001_l00?l0om@000?o0000
2000038000?o00001P000ol000020003o`000=400_l:0000:004o`H000?o00001P000ol000020003
o`000=8000?o0000200002`000?o00000`000ol000060003o`000=L000?o0000200001@00ol0103o
oolA0003o`0000<000?o00001@03o`<000?o0000dP000ol0000800005@001Ol0003o00h01?l600;o
g`03o`X0000E0005o`000?l03`000ol000060003o`000>0000?o0000200001D01Ol?00Co1@000ol0
003P0003o`0000P0000E0005o`000?l060000ol0003O00;o2P0001@00ol0103ooolG0003o`000>00
00?o0000200001D00_lK0003o`000>0000?o0000200001@000?o00006`000ol0003P0003o`0000P0
000D00Co6P000ol0003O00;o2P0001D00_lK0003o`000>0000?o0000200001D00olJ0003o`000>00
00?o0000200001@000?o0?l06`000ol0003P0003o`0000P0000E00;o6`000ol0003O00;o2P0001@0
0_lL0003o`000>0000?o0000200001H000?o00006@000ol0003P0003o`0000P0000E0003o`0001X0
00?o0000g`02o`X0000E0003o`0001X000?o0000h0000ol0000800005003o``000Go003o0004o`H0
00?o0000h0000ol0000800005@000ol0000;0003o`0000H000?o00000`000ol0003P0003o`0000P0
000T0003o`0000D000?o00000`02oml00ol:00005P02o``000Co00001?l60003o`000>0000?o0000
200001D000Co003o20001?l00?l40003o`0000H000?o0000h0000ol0000800005@001?l00?l800Go
0`04o`D000?o0000h0000ol0000800005P02oaX000?o0000g`02o`X0000b0003o`000>0000?o0000
200001@00olK0003o`000>0000?o0000200001D000?o00006P000ol0003P0003o`0000P0000E0003
o`0001X000?o0000g`02o`X0000D00?o6`000ol0003P0003o`0000P0000E0003o`0001X000?o0000
h0000ol0000800005P02oaX000?o0000g`02o`X0000D00?o6`000ol0003P0003o`0000P0000E0003
o`0001X000?o0000h0000ol0000800005@000ol0000J0003o`000>0000?o0000200001@01?lJ0003
o`000=l00_l:00005@000ol0o`0<00?o0P03o`H000?o0000^@05o`040?oooah000?o0000200001D0
0ol=0004o`00o`<000?o00000`000ol0002j0003o`0000;o00<0o`007P000ol0000800005@000ol0
o`0=0004o`00o`<000?o00000`000ol0002j0003o`0000800_lO0003o`0000P0000D00;o3`001?l0
0?l30003o`0000<00_nk0004o`0000;o7P03o`X0000E00;o3P001?l00?l30003o`0000<000?o0000
^P000ol0000S0003o`0000P0000D0003o`0000d00_l300?o1P000ol0002i00?o90000ol000080000
5@02oa/000?o0000g`02o`X0000E0003o`0001X000?o0000h0000ol0000800005@000ol0000J0003
o`000>0000?o0000200001D000?o00006P000ol0003P0003o`0000P0000E00?o6P000ol0003O00;o
2P0001D000Co003o6@000ol0003P0003o`0000P0000E0004o`00oaT000?o0000h0000ol000080000
5P02oaX000?o0000h0000ol0000800005@000ol0o`0J0003o`000=l00_l:00005@000ol0o`0J0003
o`000>0000?o0000200001D000?o0?l06P000ol0003P0003o`0000P0000E00;o6`000ol0003O00;o
2P00038000?o0000h0000ol0000800007@03o`030?oo00?o00<0ool00_l70003o`000>0000?o0000
200001h000Go0000o`080003o`0000@000?o0000h0000ol0000800007P000ol000020003o`0000D0
00?o00001002oml00ol:00007P000ol000030003o`0000Co1`000ol0003P0003o`0000P0000N0004
o`00o`<000Co003o2@000ol0003P0003o`0000P0000M00;o0`03o`<01?l60003o`000>0000?o0000
2000038000?o0000g`02o`X0000b0003o`000>0000?o00002000038000?o0000h0000ol000080000
<P000ol0003O00;o2P00038000?o0000h0000ol000080000<P000ol0003P0003o`0000P0000b0003
o`000>0000?o00002000038000?o0000g`02o`X0000b0003o`000>0000?o00002000038000?o0000
h0000ol000080000<P000ol0003P0003o`0000P0000b0003o`000=l00_l:00009003o`030?oo00;o
1P000ol0003P0003o`0000P0000U0003o`0000@000?o00000`000ol0003P0003o`0000P0000U0003
o`0000@000?o00000`000ol0003P0003o`0000P0000U0003o`0000Co1P02oml00ol:00009@001Ol0
003o00P000?o0000h0000ol0000800009002o`<01?l50003o`000>0000?o00002000038000?o0000
g`02o`X0000b0003o`000>0000?o00002000038000?o0000h0000ol000080000<P000ol0003P0003
o`0000P0000b0003o`000=D00ol200?o0P02o`X0000b0003o`000=H000Go0000o`020004o`00o`X0
000b0003o`000=H000Go0000o`020004o`00o`X0000b0003o`000=H000Co00000ol30003o`0000P0
000b0003o`000=@000Oo0?l0o`3o00@00_l:0000<P000ol0003D00Oo1@000ol000080000<P000ol0
003P0003o`0000P0000b0003o`000=l00_l:00007@03o`<000Co0?l01?l70003o`000>0000?o0000
200001h000?o00000P000ol000050003o`0000@000?o0000h0000ol0000800007P000ol000030003
o`0000@000?o000010000ol0003P0003o`0000P0000N0003o`0000<000?o00001?l700;og`03o`X0
000N0004o`00o`8000Go0000o`090003o`000>0000?o0000200001d00_l200Go0P04o`H000Co003o
80000ol0000O0003o`0001h000?o00007P000ol0000O0003o`0001h000?o00005@000ol000080000
<P001?l00?l60003o`0000<000?o000010000ol000040003o`0000<000?o000010000ol000040003
o`0000<000?o000010000ol000040003o`0000<000?o000010000ol000040003o`0000<000?o0000
10000ol000040003o`0000<000?o000010000ol000040003o`0000<000?o000010000ol000040003
o`0000<000?o000010000ol000040003o`0000<000?o000010000ol000040003o`0000@000?o0000
0`000ol000040003o`0000@000?o00000`001Ol0003o00X0000b0>Co2P000?l08@000?l08@000?l0
8@000001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-15.9987, -5.44738, 0.299566,
   0.135433}}]
}, Closed]],

Cell[TextData[{
  "If we map a function onto an array, ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " maps the function onto each row of the array."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Map[f, {{1, 2}, {3, 4}}]\)], "Input"],

Cell[BoxData[
    \({f[{1, 2}], f[{3, 4}]}\)], "Output"]
}, Closed]],

Cell["\<\
To map a function to the elements of an array, we specify a level \
at which the function should be mapped. The elements of a matrix are at the \
second level of the matrix, so we enter the following.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Map[f, {{1, 2}, {3, 4}}, {2}]\)], "Input"],

Cell[BoxData[
    \({{f[1], f[2]}, {f[3], f[4]}}\)], "Output"]
}, Closed]],

Cell[TextData[{
  "Like ",
  StyleBox["Apply", "Input"],
  ", ",
  StyleBox["Map", "Input"],
  " operates over general expressions."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Map[Sqrt, a + b + c]\)], "Input"],

Cell[BoxData[
    \(\@a + \@b + \@c\)], "Output"]
}, Closed]],

Cell[TextData[{
  "See also ",
  StyleBox["MapIndexed", "Input"],
  ", ",
  StyleBox["MapThread", "Input"],
  ", ",
  StyleBox["Scan", "Input"],
  ", ",
  StyleBox["Listable", "Input"],
  " "
}], "SeeAlso"]
}, Closed]],

Cell[CellGroupData[{

Cell["Iteration", "Subsection"],

Cell[TextData[{
  "Whereas recursion involves explicitly defining a function in terms of \
itself (as with the factorial definition ",
  Cell[BoxData[
      \(fac[n_] := n\ fac[n - 1]\)], "Input"],
  ", in which the function name appears on both the left- and right-hand \
sides of the definition), iteration uses high-level functions defined \
specially for having a function call itself."
}], "Text"],

Cell[TextData[{
  StyleBox["NestList", "Input"],
  " accepts a function to iterate, a starting value, and a number of \
iterations, and returns a list of nested values of the function. (",
  StyleBox["Nest", "Input"],
  " returns the last value of ",
  StyleBox["NestList", "Input"],
  ".)"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NestList[f, x, 4] // ColumnForm\)], "Input"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {"x"},
          {"\(f[x]\)"},
          {"\(f[f[x]]\)"},
          {"\(f[f[f[x]]]\)"},
          {"\(f[f[f[f[x]]]]\)"}
          },
        GridBaseline->{Baseline, {1, 1}},
        ColumnAlignments->{Left}],
      ColumnForm[ {x, 
        f[ x], 
        f[ 
          f[ x]], 
        f[ 
          f[ 
            f[ x]]], 
        f[ 
          f[ 
            f[ 
              f[ x]]]]}],
      Editable->False]], "Output"]
}, Closed]],

Cell[TextData[{
  "Here are the first ten iterates of ",
  Cell[BoxData[
      \(TraditionalForm\`x \[RightArrow] 1 + 1\/x\)]],
  ", starting with ",
  StyleBox["x",
    FontSlant->"Italic"],
  " = 1.0."
}], "Text"],

Cell[BoxData[
    \(flip[x_] := 1 + 1\/x\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NestList[flip, 1.0, 10] // ColumnForm\)], "Input"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {
            StyleBox["1.`",
              StyleBoxAutoDelete->True,
              PrintPrecision->2]},
          {"2.`"},
          {"1.5`"},
          {"1.66666666666666651`"},
          {"1.60000000000000008`"},
          {"1.625`"},
          {"1.61538461538461541`"},
          {"1.61904761904761906`"},
          {"1.61764705882352943`"},
          {"1.61818181818181816`"},
          {"1.61797752808988759`"}
          },
        GridBaseline->{Baseline, {1, 1}},
        ColumnAlignments->{Left}],
      ColumnForm[
       {1.0, 2.0, 1.5, 1.66666666666667, 1.6, 1.625, 1.61538461538462, 
        1.61904761904762, 1.61764705882353, 1.61818181818182, 
        1.61797752808989}],
      Editable->False]], "Output"]
}, Closed]],

Cell[TextData[{
  "Here is one way to generate a two-dimensional random walk. We start with \
the ordered pair ",
  Cell["{0, 0}", "Input"],
  ", and iterate a function that adds a random integer from ",
  Cell[BoxData[
      \(TraditionalForm\`\(-1\)\)]],
  " to 1 to each coordinate. The result is a list of ordered pairs."
}], "Text"],

Cell[BoxData[
    \(onestep[{x_, y_}] := \n
      \t{x + Random[Integer, {\(-1\), 1}], y + Random[Integer, {\(-1\), 1}]}
        \)], "Input"],

Cell[CellGroupData[{

Cell["onestep[{0,0}]", "Input"],

Cell[BoxData[
    \({\(-1\), 0}\)], "Output"]
}, Closed]],

Cell[TextData[{
  "The following command generates a list of iterates of ",
  StyleBox["onestep", "Input"],
  ". The output is suppressed by ending the line with a semicolon."
}], "Text"],

Cell[BoxData[
    \(\(walkdata = NestList[onestep, {0, 0}, 999]; \)\)], "Input"],

Cell["Here is an abbreviated version of the list of points.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Short[walkdata]\)], "Input"],

Cell[BoxData[
    TagBox[
      "\({{0, 0}, {1, 0},          \[LeftSkeleton]996\[RightSkeleton], {\(-38\
\), 2}, {\(-38\), 1}}\)",
      Short]], "Output"]
}, Closed]],

Cell[TextData[{
  "To convert ",
  StyleBox["walkdata", "Input"],
  " into a graph, we connect and plot the ordered pairs using ",
  StyleBox["ListPlot", "Input"],
  " with the option ",
  StyleBox["PlotJoined", "Input"],
  " set to ",
  StyleBox["True", "Input"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(ListPlot[walkdata, PlotJoined \[Rule] True, Axes \[Rule] False, 
      AspectRatio \[Rule] Automatic]; \)\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .64 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.766667 0.0190476 0.0914286 0.0190476 [
[ 0 0 0 0 ]
[ 1 .64 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .64 L
0 .64 L
closepath
clip
newpath
0 g
.5 Mabswid
[ ] 0 setdash
.76667 .09143 m
.78571 .09143 L
.78571 .07238 L
.80476 .05333 L
.80476 .07238 L
.78571 .09143 L
.80476 .11048 L
.80476 .12952 L
.80476 .11048 L
.82381 .11048 L
.84286 .11048 L
.82381 .09143 L
.80476 .11048 L
.82381 .11048 L
.82381 .12952 L
.84286 .12952 L
.8619 .12952 L
.84286 .12952 L
.8619 .14857 L
.8619 .14857 L
.88095 .12952 L
.8619 .11048 L
.8619 .11048 L
.88095 .12952 L
.88095 .12952 L
.88095 .14857 L
.8619 .12952 L
.8619 .11048 L
.88095 .09143 L
.9 .09143 L
.91905 .07238 L
.9 .09143 L
.91905 .09143 L
.9381 .11048 L
.95714 .09143 L
.95714 .11048 L
.95714 .11048 L
.95714 .09143 L
.97619 .09143 L
.95714 .11048 L
.9381 .09143 L
.95714 .11048 L
.9381 .12952 L
.91905 .14857 L
.9 .16762 L
.9 .16762 L
.88095 .18667 L
.8619 .20571 L
.84286 .18667 L
.82381 .18667 L
Mistroke
.84286 .18667 L
.84286 .20571 L
.84286 .22476 L
.84286 .22476 L
.84286 .20571 L
.84286 .22476 L
.84286 .24381 L
.8619 .26286 L
.84286 .26286 L
.82381 .26286 L
.82381 .24381 L
.80476 .26286 L
.78571 .24381 L
.78571 .24381 L
.80476 .22476 L
.82381 .20571 L
.80476 .20571 L
.78571 .22476 L
.78571 .20571 L
.78571 .22476 L
.78571 .20571 L
.76667 .20571 L
.74762 .20571 L
.76667 .18667 L
.78571 .20571 L
.76667 .18667 L
.74762 .18667 L
.74762 .18667 L
.74762 .20571 L
.76667 .20571 L
.74762 .20571 L
.74762 .22476 L
.76667 .20571 L
.74762 .18667 L
.76667 .16762 L
.74762 .14857 L
.74762 .14857 L
.74762 .12952 L
.74762 .12952 L
.74762 .14857 L
.74762 .16762 L
.72857 .16762 L
.70952 .16762 L
.69048 .18667 L
.67143 .18667 L
.67143 .20571 L
.67143 .20571 L
.69048 .22476 L
.67143 .20571 L
.69048 .18667 L
Mistroke
.70952 .18667 L
.72857 .20571 L
.72857 .22476 L
.70952 .20571 L
.72857 .22476 L
.72857 .24381 L
.74762 .22476 L
.76667 .24381 L
.76667 .26286 L
.78571 .2819 L
.80476 .26286 L
.82381 .24381 L
.80476 .24381 L
.78571 .22476 L
.76667 .24381 L
.74762 .22476 L
.74762 .22476 L
.72857 .24381 L
.72857 .24381 L
.70952 .24381 L
.72857 .24381 L
.72857 .24381 L
.74762 .22476 L
.72857 .24381 L
.70952 .22476 L
.69048 .20571 L
.70952 .22476 L
.70952 .22476 L
.72857 .20571 L
.74762 .18667 L
.74762 .18667 L
.74762 .18667 L
.74762 .18667 L
.72857 .20571 L
.70952 .20571 L
.70952 .20571 L
.72857 .22476 L
.72857 .20571 L
.72857 .22476 L
.72857 .24381 L
.70952 .24381 L
.72857 .24381 L
.72857 .22476 L
.72857 .20571 L
.72857 .22476 L
.70952 .22476 L
.70952 .20571 L
.69048 .20571 L
.70952 .22476 L
.69048 .22476 L
Mistroke
.69048 .24381 L
.69048 .24381 L
.67143 .22476 L
.65238 .24381 L
.65238 .26286 L
.63333 .26286 L
.63333 .26286 L
.61429 .2819 L
.63333 .30095 L
.61429 .2819 L
.61429 .26286 L
.59524 .2819 L
.61429 .30095 L
.61429 .30095 L
.63333 .2819 L
.63333 .30095 L
.61429 .32 L
.59524 .32 L
.61429 .32 L
.61429 .32 L
.63333 .30095 L
.63333 .30095 L
.63333 .30095 L
.63333 .30095 L
.63333 .32 L
.61429 .33905 L
.59524 .33905 L
.59524 .3581 L
.61429 .33905 L
.63333 .33905 L
.63333 .32 L
.63333 .32 L
.65238 .30095 L
.67143 .2819 L
.65238 .26286 L
.65238 .24381 L
.63333 .22476 L
.61429 .20571 L
.61429 .18667 L
.59524 .20571 L
.59524 .22476 L
.57619 .22476 L
.55714 .20571 L
.55714 .20571 L
.57619 .22476 L
.59524 .22476 L
.61429 .20571 L
.61429 .22476 L
.63333 .24381 L
.63333 .26286 L
Mistroke
.65238 .26286 L
.63333 .2819 L
.65238 .2819 L
.65238 .26286 L
.63333 .2819 L
.61429 .2819 L
.63333 .26286 L
.65238 .26286 L
.65238 .2819 L
.63333 .2819 L
.65238 .26286 L
.63333 .24381 L
.65238 .22476 L
.67143 .20571 L
.69048 .18667 L
.70952 .20571 L
.69048 .20571 L
.69048 .18667 L
.67143 .18667 L
.69048 .18667 L
.70952 .16762 L
.69048 .14857 L
.70952 .16762 L
.69048 .18667 L
.69048 .20571 L
.70952 .18667 L
.69048 .16762 L
.70952 .18667 L
.69048 .16762 L
.70952 .16762 L
.70952 .14857 L
.72857 .16762 L
.72857 .14857 L
.70952 .14857 L
.70952 .12952 L
.70952 .14857 L
.70952 .14857 L
.72857 .16762 L
.74762 .18667 L
.76667 .18667 L
.76667 .16762 L
.78571 .16762 L
.78571 .16762 L
.76667 .18667 L
.74762 .18667 L
.74762 .16762 L
.74762 .16762 L
.74762 .18667 L
.72857 .20571 L
.70952 .20571 L
Mistroke
.70952 .18667 L
.72857 .20571 L
.72857 .18667 L
.72857 .16762 L
.70952 .16762 L
.70952 .16762 L
.69048 .18667 L
.70952 .18667 L
.70952 .16762 L
.69048 .16762 L
.70952 .18667 L
.69048 .16762 L
.69048 .18667 L
.69048 .18667 L
.70952 .16762 L
.70952 .16762 L
.72857 .18667 L
.74762 .20571 L
.76667 .22476 L
.74762 .22476 L
.72857 .24381 L
.72857 .22476 L
.74762 .22476 L
.74762 .20571 L
.76667 .22476 L
.74762 .20571 L
.76667 .18667 L
.74762 .16762 L
.74762 .16762 L
.76667 .18667 L
.74762 .18667 L
.72857 .16762 L
.72857 .18667 L
.74762 .16762 L
.72857 .18667 L
.74762 .16762 L
.72857 .16762 L
.72857 .16762 L
.70952 .16762 L
.69048 .16762 L
.70952 .14857 L
.69048 .12952 L
.67143 .12952 L
.69048 .14857 L
.67143 .16762 L
.65238 .14857 L
.65238 .16762 L
.67143 .16762 L
.67143 .14857 L
.65238 .12952 L
Mistroke
.63333 .11048 L
.63333 .09143 L
.63333 .07238 L
.65238 .09143 L
.65238 .11048 L
.63333 .09143 L
.61429 .07238 L
.61429 .09143 L
.63333 .11048 L
.61429 .09143 L
.61429 .11048 L
.63333 .12952 L
.61429 .14857 L
.63333 .12952 L
.63333 .14857 L
.63333 .16762 L
.61429 .16762 L
.59524 .18667 L
.61429 .16762 L
.63333 .14857 L
.63333 .16762 L
.63333 .14857 L
.65238 .14857 L
.67143 .16762 L
.69048 .16762 L
.67143 .16762 L
.65238 .18667 L
.63333 .18667 L
.61429 .16762 L
.59524 .16762 L
.61429 .16762 L
.63333 .16762 L
.65238 .16762 L
.65238 .18667 L
.65238 .16762 L
.63333 .14857 L
.65238 .14857 L
.63333 .12952 L
.65238 .14857 L
.67143 .16762 L
.65238 .14857 L
.63333 .16762 L
.63333 .16762 L
.61429 .18667 L
.61429 .20571 L
.61429 .22476 L
.63333 .22476 L
.65238 .20571 L
.63333 .22476 L
.61429 .24381 L
Mistroke
.61429 .24381 L
.61429 .26286 L
.59524 .2819 L
.57619 .26286 L
.57619 .26286 L
.59524 .2819 L
.61429 .26286 L
.61429 .24381 L
.61429 .22476 L
.59524 .22476 L
.59524 .24381 L
.61429 .26286 L
.63333 .24381 L
.63333 .24381 L
.63333 .26286 L
.63333 .24381 L
.63333 .22476 L
.61429 .22476 L
.61429 .22476 L
.63333 .22476 L
.65238 .24381 L
.63333 .22476 L
.61429 .24381 L
.63333 .22476 L
.65238 .24381 L
.67143 .24381 L
.69048 .24381 L
.70952 .26286 L
.69048 .2819 L
.69048 .2819 L
.69048 .26286 L
.69048 .26286 L
.70952 .2819 L
.72857 .30095 L
.70952 .30095 L
.72857 .32 L
.72857 .32 L
.74762 .32 L
.74762 .33905 L
.72857 .32 L
.74762 .32 L
.72857 .32 L
.74762 .33905 L
.76667 .3581 L
.78571 .37714 L
.78571 .37714 L
.78571 .3581 L
.76667 .33905 L
.76667 .32 L
.78571 .30095 L
Mistroke
.76667 .2819 L
.76667 .30095 L
.76667 .30095 L
.76667 .32 L
.78571 .32 L
.80476 .32 L
.78571 .30095 L
.76667 .32 L
.78571 .33905 L
.78571 .32 L
.76667 .33905 L
.74762 .3581 L
.72857 .37714 L
.70952 .37714 L
.69048 .39619 L
.70952 .37714 L
.70952 .37714 L
.70952 .39619 L
.72857 .39619 L
.72857 .37714 L
.74762 .39619 L
.72857 .41524 L
.70952 .43429 L
.70952 .41524 L
.70952 .43429 L
.69048 .45333 L
.70952 .45333 L
.70952 .45333 L
.69048 .45333 L
.67143 .43429 L
.65238 .43429 L
.63333 .41524 L
.61429 .41524 L
.63333 .43429 L
.61429 .45333 L
.61429 .47238 L
.63333 .49143 L
.61429 .47238 L
.59524 .47238 L
.59524 .47238 L
.59524 .49143 L
.57619 .51048 L
.59524 .49143 L
.61429 .47238 L
.59524 .47238 L
.61429 .45333 L
.63333 .43429 L
.65238 .45333 L
.67143 .43429 L
.65238 .41524 L
Mistroke
.63333 .39619 L
.65238 .39619 L
.65238 .41524 L
.63333 .43429 L
.65238 .45333 L
.63333 .45333 L
.63333 .43429 L
.61429 .43429 L
.61429 .43429 L
.61429 .43429 L
.59524 .43429 L
.59524 .43429 L
.57619 .45333 L
.57619 .47238 L
.59524 .45333 L
.59524 .43429 L
.57619 .43429 L
.59524 .43429 L
.57619 .45333 L
.57619 .47238 L
.59524 .49143 L
.59524 .49143 L
.59524 .49143 L
.57619 .51048 L
.59524 .49143 L
.59524 .51048 L
.61429 .52952 L
.59524 .51048 L
.59524 .52952 L
.59524 .52952 L
.59524 .51048 L
.59524 .52952 L
.57619 .51048 L
.57619 .52952 L
.59524 .54857 L
.61429 .56762 L
.59524 .56762 L
.59524 .54857 L
.61429 .52952 L
.63333 .54857 L
.61429 .56762 L
.59524 .56762 L
.59524 .56762 L
.57619 .58667 L
.55714 .56762 L
.55714 .56762 L
.5381 .54857 L
.5381 .52952 L
.5381 .52952 L
.51905 .52952 L
Mistroke
.5 .51048 L
.51905 .52952 L
.5381 .51048 L
.51905 .49143 L
.5381 .47238 L
.5381 .45333 L
.5381 .45333 L
.5381 .45333 L
.5381 .43429 L
.51905 .45333 L
.51905 .43429 L
.5381 .43429 L
.55714 .41524 L
.55714 .43429 L
.55714 .45333 L
.55714 .43429 L
.5381 .45333 L
.51905 .45333 L
.51905 .45333 L
.5 .43429 L
.48095 .43429 L
.4619 .41524 L
.44286 .43429 L
.42381 .43429 L
.42381 .41524 L
.42381 .43429 L
.40476 .41524 L
.38571 .39619 L
.36667 .41524 L
.34762 .41524 L
.36667 .39619 L
.36667 .39619 L
.38571 .41524 L
.40476 .43429 L
.40476 .45333 L
.40476 .47238 L
.42381 .49143 L
.40476 .49143 L
.42381 .51048 L
.44286 .52952 L
.4619 .54857 L
.44286 .52952 L
.4619 .52952 L
.4619 .52952 L
.44286 .51048 L
.4619 .49143 L
.4619 .51048 L
.44286 .51048 L
.42381 .49143 L
.40476 .51048 L
Mistroke
.40476 .51048 L
.40476 .52952 L
.38571 .54857 L
.40476 .56762 L
.38571 .56762 L
.40476 .58667 L
.38571 .56762 L
.38571 .58667 L
.40476 .60571 L
.40476 .62476 L
.38571 .60571 L
.40476 .60571 L
.40476 .60571 L
.38571 .60571 L
.38571 .58667 L
.38571 .56762 L
.36667 .58667 L
.34762 .56762 L
.36667 .54857 L
.38571 .52952 L
.40476 .54857 L
.38571 .56762 L
.40476 .54857 L
.40476 .56762 L
.38571 .56762 L
.38571 .54857 L
.40476 .52952 L
.42381 .51048 L
.40476 .52952 L
.40476 .51048 L
.40476 .52952 L
.42381 .51048 L
.44286 .49143 L
.42381 .49143 L
.44286 .51048 L
.42381 .49143 L
.44286 .51048 L
.44286 .52952 L
.42381 .54857 L
.40476 .52952 L
.38571 .52952 L
.40476 .52952 L
.40476 .52952 L
.42381 .51048 L
.44286 .51048 L
.4619 .52952 L
.48095 .51048 L
.5 .51048 L
.48095 .49143 L
.48095 .49143 L
Mistroke
.48095 .49143 L
.5 .47238 L
.5 .49143 L
.5 .47238 L
.5 .49143 L
.48095 .47238 L
.48095 .47238 L
.5 .49143 L
.5 .49143 L
.51905 .47238 L
.5 .45333 L
.51905 .47238 L
.5 .45333 L
.5 .47238 L
.48095 .47238 L
.4619 .47238 L
.44286 .45333 L
.44286 .47238 L
.4619 .49143 L
.44286 .47238 L
.42381 .49143 L
.42381 .51048 L
.44286 .51048 L
.42381 .49143 L
.42381 .49143 L
.40476 .51048 L
.40476 .52952 L
.40476 .54857 L
.42381 .54857 L
.40476 .54857 L
.42381 .52952 L
.40476 .51048 L
.42381 .51048 L
.44286 .51048 L
.4619 .51048 L
.4619 .51048 L
.44286 .51048 L
.44286 .52952 L
.42381 .54857 L
.40476 .54857 L
.42381 .52952 L
.44286 .54857 L
.42381 .54857 L
.40476 .54857 L
.38571 .54857 L
.40476 .52952 L
.40476 .51048 L
.38571 .52952 L
.36667 .51048 L
.36667 .51048 L
Mistroke
.34762 .51048 L
.36667 .52952 L
.34762 .51048 L
.32857 .49143 L
.32857 .47238 L
.34762 .45333 L
.32857 .47238 L
.34762 .47238 L
.34762 .47238 L
.34762 .45333 L
.36667 .45333 L
.38571 .43429 L
.38571 .43429 L
.36667 .45333 L
.38571 .45333 L
.38571 .45333 L
.38571 .43429 L
.38571 .43429 L
.36667 .41524 L
.36667 .43429 L
.34762 .43429 L
.34762 .43429 L
.36667 .41524 L
.36667 .39619 L
.34762 .37714 L
.32857 .37714 L
.30952 .37714 L
.32857 .39619 L
.30952 .37714 L
.32857 .3581 L
.32857 .37714 L
.32857 .39619 L
.32857 .39619 L
.30952 .39619 L
.32857 .41524 L
.30952 .43429 L
.30952 .45333 L
.29048 .45333 L
.29048 .43429 L
.30952 .43429 L
.29048 .41524 L
.27143 .41524 L
.25238 .41524 L
.23333 .39619 L
.25238 .39619 L
.27143 .37714 L
.27143 .37714 L
.27143 .3581 L
.29048 .3581 L
.29048 .33905 L
Mistroke
.30952 .32 L
.29048 .32 L
.27143 .32 L
.29048 .33905 L
.29048 .3581 L
.27143 .37714 L
.25238 .37714 L
.27143 .3581 L
.29048 .37714 L
.29048 .37714 L
.30952 .39619 L
.29048 .41524 L
.27143 .39619 L
.27143 .41524 L
.29048 .39619 L
.27143 .39619 L
.25238 .37714 L
.23333 .37714 L
.23333 .39619 L
.25238 .41524 L
.27143 .41524 L
.25238 .43429 L
.27143 .45333 L
.29048 .45333 L
.27143 .47238 L
.29048 .47238 L
.29048 .45333 L
.27143 .47238 L
.29048 .49143 L
.29048 .51048 L
.30952 .51048 L
.29048 .52952 L
.27143 .52952 L
.25238 .52952 L
.27143 .54857 L
.29048 .52952 L
.30952 .52952 L
.32857 .51048 L
.34762 .51048 L
.36667 .49143 L
.34762 .51048 L
.36667 .51048 L
.36667 .52952 L
.34762 .51048 L
.32857 .49143 L
.34762 .47238 L
.36667 .49143 L
.38571 .47238 L
.40476 .49143 L
.38571 .47238 L
Mistroke
.40476 .45333 L
.38571 .47238 L
.40476 .45333 L
.42381 .43429 L
.40476 .43429 L
.42381 .41524 L
.40476 .41524 L
.38571 .43429 L
.40476 .41524 L
.38571 .41524 L
.40476 .43429 L
.40476 .43429 L
.42381 .41524 L
.42381 .39619 L
.44286 .37714 L
.42381 .39619 L
.40476 .37714 L
.38571 .3581 L
.36667 .37714 L
.34762 .37714 L
.34762 .3581 L
.36667 .37714 L
.34762 .3581 L
.34762 .33905 L
.32857 .32 L
.34762 .33905 L
.34762 .3581 L
.36667 .33905 L
.34762 .32 L
.34762 .33905 L
.36667 .33905 L
.38571 .32 L
.40476 .33905 L
.38571 .32 L
.36667 .30095 L
.36667 .30095 L
.36667 .2819 L
.38571 .30095 L
.36667 .32 L
.36667 .30095 L
.38571 .30095 L
.36667 .30095 L
.34762 .30095 L
.32857 .2819 L
.30952 .26286 L
.32857 .24381 L
.32857 .22476 L
.32857 .24381 L
.30952 .24381 L
.30952 .22476 L
Mistroke
.32857 .24381 L
.34762 .26286 L
.34762 .24381 L
.34762 .22476 L
.34762 .24381 L
.34762 .24381 L
.36667 .22476 L
.34762 .24381 L
.32857 .24381 L
.34762 .26286 L
.36667 .2819 L
.34762 .2819 L
.32857 .2819 L
.30952 .30095 L
.30952 .30095 L
.29048 .2819 L
.29048 .26286 L
.29048 .2819 L
.30952 .26286 L
.29048 .24381 L
.30952 .24381 L
.32857 .22476 L
.30952 .20571 L
.30952 .18667 L
.30952 .16762 L
.29048 .16762 L
.30952 .16762 L
.32857 .14857 L
.32857 .16762 L
.30952 .16762 L
.29048 .14857 L
.29048 .12952 L
.30952 .14857 L
.32857 .12952 L
.34762 .14857 L
.36667 .14857 L
.38571 .16762 L
.36667 .14857 L
.38571 .12952 L
.38571 .11048 L
.38571 .11048 L
.38571 .11048 L
.40476 .09143 L
.40476 .11048 L
.40476 .12952 L
.38571 .14857 L
.36667 .16762 L
.38571 .16762 L
.36667 .18667 L
.34762 .20571 L
Mistroke
.32857 .18667 L
.34762 .16762 L
.36667 .16762 L
.34762 .18667 L
.34762 .20571 L
.32857 .22476 L
.32857 .20571 L
.32857 .18667 L
.30952 .18667 L
.32857 .16762 L
.30952 .16762 L
.32857 .16762 L
.34762 .14857 L
.32857 .14857 L
.30952 .12952 L
.29048 .11048 L
.30952 .11048 L
.32857 .11048 L
.30952 .09143 L
.29048 .09143 L
.30952 .09143 L
.29048 .11048 L
.27143 .11048 L
.27143 .11048 L
.29048 .11048 L
.30952 .12952 L
.32857 .12952 L
.34762 .12952 L
.32857 .14857 L
.32857 .16762 L
.32857 .16762 L
.30952 .18667 L
.29048 .16762 L
.30952 .18667 L
.30952 .20571 L
.29048 .22476 L
.30952 .22476 L
.32857 .20571 L
.32857 .20571 L
.34762 .18667 L
.34762 .18667 L
.32857 .18667 L
.30952 .16762 L
.32857 .16762 L
.32857 .14857 L
.32857 .14857 L
.30952 .16762 L
.29048 .18667 L
.29048 .16762 L
.30952 .18667 L
Mistroke
.30952 .16762 L
.30952 .16762 L
.29048 .18667 L
.30952 .18667 L
.30952 .18667 L
.30952 .20571 L
.30952 .20571 L
.30952 .20571 L
.32857 .20571 L
.30952 .20571 L
.30952 .20571 L
.30952 .18667 L
.32857 .16762 L
.34762 .14857 L
.34762 .12952 L
.36667 .14857 L
.38571 .12952 L
.38571 .11048 L
.38571 .11048 L
.40476 .11048 L
.42381 .12952 L
.42381 .11048 L
.44286 .12952 L
.4619 .11048 L
.44286 .11048 L
.4619 .12952 L
.4619 .12952 L
.44286 .11048 L
.42381 .11048 L
.42381 .12952 L
.42381 .12952 L
.40476 .14857 L
.38571 .14857 L
.36667 .12952 L
.34762 .12952 L
.32857 .14857 L
.34762 .12952 L
.32857 .11048 L
.30952 .11048 L
.29048 .11048 L
.29048 .11048 L
.27143 .11048 L
.25238 .09143 L
.27143 .07238 L
.25238 .07238 L
.25238 .07238 L
.25238 .05333 L
.27143 .07238 L
.29048 .09143 L
.27143 .07238 L
Mistroke
.29048 .05333 L
.27143 .03429 L
.25238 .01524 L
.25238 .03429 L
.23333 .03429 L
.23333 .01524 L
.25238 .01524 L
.23333 .01524 L
.21429 .03429 L
.23333 .05333 L
.25238 .07238 L
.23333 .05333 L
.23333 .03429 L
.23333 .03429 L
.21429 .05333 L
.21429 .03429 L
.19524 .01524 L
.19524 .03429 L
.17619 .05333 L
.15714 .05333 L
.17619 .03429 L
.17619 .05333 L
.19524 .07238 L
.17619 .05333 L
.15714 .07238 L
.1381 .07238 L
.11905 .07238 L
.11905 .09143 L
.1381 .09143 L
.11905 .11048 L
.11905 .09143 L
.1 .09143 L
.08095 .11048 L
.1 .09143 L
.08095 .09143 L
.08095 .07238 L
.0619 .07238 L
.04286 .09143 L
.04286 .09143 L
.04286 .11048 L
.02381 .12952 L
.02381 .12952 L
.04286 .14857 L
.0619 .14857 L
.0619 .14857 L
.04286 .12952 L
.0619 .11048 L
.0619 .11048 L
.04286 .12952 L
.04286 .11048 L
Mistroke
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{284, 181.75},
  ImageMargins->{{35, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004L0000]@P10`4000010?ooobl_;oooZZVYZNSX
j?oo05FZZZZZZ_W0RS/k>gYjN[Vi^OShn03ooeGooj[ooonI<c<c<fi^KZf][Nc/k02ZoeFZojZZoonZ
oclo?ginO[fm_Oclo5D00:X00?l00?l0VCLg=g9bL[6a/O3`l03o05Go0:[o00<30d92@X61PL30`000
EED0EJX0EOl0ELbIoc/k>gIfM[Fe]OCdm03oEEGoEJ[oE@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0Z/`c
<clo?gYjN[Vi^OShn03oZUGoZZ[oZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`<30d92@WinO[fm_Ocl
o03ooeGooj[oo`l?3di>CXf=SLc<c01E05EE0:YE0?mE00L71dI6AX61PL30`000EED00:X00?l001<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@/;2dY:BXF5QLC4a000ZUD0EJX0EOl0EALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZPl?3di>CXV9RLS8b000oeD0ZZX0Z_l0ZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEoa<C
4e9BDXf=SLc<c01E05D0ojX0ool0oalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ01LG5eIFEY6ATM3@d01E
EEEE0:YE0?mE02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZEA/K6eYJFYFEUMCDe01EZUEEEJYEEOmEEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZQlO7eiNGYVIVMSHf01EoeEEZZYEZ_mEZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZob<S8f9RHYfMWMcLg02Z05EEojYEoomEobl_;fi^KZf][Nc/k03o05Go0:[o0=gW1RLW
9fIVIZ6QXN3Ph02ZEEFZ0:ZZ0?nZ03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooEB/[:fYZJZFUYNCTi02Z
ZUFZEJZZEOnZECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l07@000?l07@000?l07@000?l07@0003L0
00?o00001`07om@0000g00;o1`000ol0o`0400;od`0003L000?o0?l01@001?l00?l40003o`3o0=80
000g0004o`00o`<000Go0000o`040004o`00om40000g0007o`000?l0o`040003o`00008000Go0000
o`3@0000<P000ol000020003o`00008000?o00000`06o`@000?o0000c@0003400_l40003o`000080
0_l300;o2P000ol0003<0000<0000ol0o`030003o`0000<000Oo0?l0o`3o00/000?o0000b`0002l0
00Co003o0P000ol000040004o`00o`8000?o00002P000ol0003:0000;P001ol0003o0?l01`001ol0
o`3o0?l03@000ol000390000;@000ol0000200;o2002o`<00_l>0003o`000<P0000/00Oo2@000ol0
00030003o`00008000?o00001`02oi0000?o0000=P00030000Co003o3`001?l00002o`L000?o0000
S`02ocP0000_0003o`00008000?o00003@001_l00?l0o`D000?o0000S`000ol0o`0h0000;P000ol0
00040003o`0000d000?o0?l00P001Ol0003o094000Co003o>00002d000?o00001P000ol0000=00;o
0`000ol0o`2A0005o`000?l0>00001401ol900co2P000ol0000=00KoH0000ol000030003o`0002P0
00?o00000P000ol0000M0003o`0001H0000A0003o`0000<000?o00001`000ol0000X00;oG`02o`@0
00?o0000:0000ol000020003o`0001d000?o00005P00010000?o000010000ol000070003o`0002L0
00Co003oGP000ol0o`0300;o:@001Ol0003o01l000?o00005`0000l000?o00001@000ol000070003
o`0002H000?o00000P000ol0001K0004o`00o`8000?o0?l0:0001?l00?lO0003o`0001P0000>0003
o`0000H000?o00001`000ol0000U0003o`0000@000?o0000FP001ol0003o0?l00P000ol0000U0003
o`3o01l000?o00006@0000`00_l90003o`0000L000?o000090000ol000060003o`0005T000?o0000
0P02o`<000?o00009002oal000?o00006P0000`000?o0000200Aoal000?o00002007oaT000?o0000
>002o`@000?o00000P000ol0000M00Oo2@02o`h03Ol40003o`0000801_l8000030000ol0000<0003
o`0000<000Go0000o`0R0003o`0000/000Co003o5`02ocX000?o0?l00`02o`<000?o000090000ol0
00050004o`00o``000?o00002`000ol000020003o`0000;o0`000ol00007000030000ol0000;0003
o`0000@000Co003o90000ol000090003o`00008000?o00004`000ol0o`0j0004o`00o`8000?o0?l0
0P000ol0000U0003o`0000<000?o00000P000ol000080003o`0000d000?o00000P02o`050?l00?l0
2P0000`000?o00002P000ol000050003o`3o02H000?o00001`000ol000040003o`00014000Co003o
>P001ol0003o0?l00P000ol0o`0X0005o`000?l01P000ol000060003o`0000l000Co00000_l0103o
0?l;000030000ol000090003o`0000H00_lX0003o`0000D000?o00001P000ol0000?0005o`000?l0
>P000ol0000200;o0`02obT000?o0?l020000ol000040003o`00014000?o0?l00P03o``0000<0003
o`0000800_l40003o`0000L000?o0000:00Bo`l01_l400co:P02o`@000?o00000P000ol0000X00co
1002oa@000?o00000P000ol0000;00002`02o`<000?o0000@0000ol000080003o`0000`000?o0000
0P02o`<000?o0?l010001?l00?l]0003o`00008000?o0000;0000ol000020003o`0000P000?o0?l0
5`000ol0000<00002P000ol0o`020003o`00048000?o000020000ol0000;0003o`00008000?o0?l0
0P001?l00?l400;o;`000ol000020003o`0002/000?o00000P000ol000080004o`00oaD000?o0000
3@0000T000Ko003o0?m60003o`0000P000?o00002P000ol000020006o`00o`3o0`001?l00002oc00
00?o00000P000ol0000Z0003o`00008000?o000020001Ol0003o01<000?o00003P0000P000Co0000
0_m80003o`0000P000?o00002@000ol000020004o`0000;o10000ol0o`020003o`0002h000?o0000
0P000ol0000Y0003o`00008000?o000020000ol000020003o`0000l000?o00003`0000L000?o0000
0P000ol000130003o`0000804Ol50003o`00008000?o00000P02o`@000?o00000P000ol0000^0003
o`00008000?o00000P07o`@000?o000020000ol0000=0003o`0000803?l50003o`0000d000?o0000
400000L000?o00000P000ol000130003o`0000<000Co00000_l40003o`0000<000Go0000o`050003
o`00008000?o0000>002o`@000?o00000`000ol000020003o`00008000?o000020000ol0000H0003
o`0000<000Co00000_l>0003o`00014000080003o`00008000?o0000@P02o`D000?o0?l00P000ol0
0003o`D000?o0?l01@000ol000020003o`0003P000Co0?oo10000ol000030003o`00008000Go0000
o`0:0003o`0001T000?o00000`001Ol0o`3o00d000?o00004P0000T000?o00000P000ol000110003
o`3o00D000?o00000P02o`040?l0o`D000?o00000`000ol000020003o`0003P000Ko003o0?l40003
o`0000<000?o00000P001?l00?l:0003o`0001X000?o00000`001?l00?l<0003o`0001<0000:0003
o`00008000?o0000@0001?l00?l30003o`3o00<00_l01@3o003o00<000?o0?l00`000ol000020003
o`0003P000Go0000o`020003o`00008000?o00000`000ol000020003o`3o00X000?o00006`002Ol0
003o0?l0o`0;0003o`0001@0000;0003o`00008000?o0?l0?`001ol0003o0?l00`03o`800_l30003
o`3o00<000?o0?l010000ol0000h0003o`00008000Go0000o`040003o`0000<000?o00000P02o`X0
00?o00007003o`<00_l:0003o`0001D0000<00Ko@0000ol000020003o`0000803Ol300Oo>P000ol0
000200Oo10000ol0000200;o1007o`@000?o00007@000ol000030003o`0000L000?o00005P0005<0
00?o00001@000ol0o`030003o`0000D000?o0?l0A@001?l0ool200?o0`001Ol0003o008000?o0000
0_l00`3o00020003o`0000800_l]0003o`0001L0001D0003o`0000<000Co003o0P000ol000070003
o`0004<000Go003o0002o`040?l0o`8000Co003o1002o`050?l00?l00P000ol000020003o`3o02/0
00?o0000600005D000Go0000o`030003o`3o00T000?o0?l0@`001_l0003o00;o00T0o`00o`3o0?l0
1@02o`030?l0008000?o0?l010001?l00?lY0003o`0001T0001F0003o`3o00@00_l90005o`000?l0
@@000ol0000200;o0P02o`<00ol50003o`0000;o1002o`@000Go0000o`0W0003o`0001X0001B00co
100<ocX0;?l400Oo7`000ol0000K0000DP02o`800_l0103o0?l50003o`00008000?o00000P000ol0
000n0006o`00o`3o1P001Ol0003o00H00_l200;o00<0o`000P02o`800ol200;o0`000ol0000N0003
o`0001`0001B0006o`3oo`3o0P000ol000030003o`00008000?o00000P000ol0000n0003o`000080
00?o00001@001?l00?l70006o`3oo`3o0P001Ol00?l000;o00<0o`000_l01@3o003o020000?o0000
7@00058000[o0?oo0?l0o`3o0`000ol000020003o`00008000?o0000?P000ol000020003o`3o00H0
00?o0?l020001_l0ool0o`<000Co0?l00_l00`3o0002o`040?l0ob0000?o00007P0005800_l200?o
0`000ol0o`040003o`00008000?o0000?P000ol000020005o`000?l01@02o`T00_l200;o1003o`80
0ol200?o80000ol0000O0000DP0Ao`@000?o0000?P000ol000020003o`0000<01_l400co1@000ol0
000200Ko3`07o`X000?o0000800005L000?o00000`000ol000020003o`00008000?o0000@`000ol0
000=0003o`0000800_l400;o10000ol000020003o`0000800_lD0003o`0000L000?o00008@0005L0
00?o00000`02o`800_l30003o`0004<00_l?0006o`000?l00_l200;o00<0o`000P02o`800ol20004
o`00oa<00_l70003o`000280001G0003o`0000<000Ko0?oo0?l20003o`0004<000?o0?l03`001?l0
0?l20006o`3oo`3o0P001Ol00?l000;o00<0o`000_l40003o`00010000?o0?l01@000ol0000S0000
E`000ol000030008o`3oo`3o0?m50004o`00o`l000?o0?l00`001_l0ool0o`<000Co0?l00_l00`3o
0002o`D000?o00003`001?l00?l30003o`0002@0001G0003o`0000<00_l200?oA@001Ol0003o00l0
0_l400;o0P02o`@00ol200?o0P000ol000030003o`0000h000Oo0000o`3o02L0001G00Oo10000ol0
000h00;o2@000ol0000200;o2@000ol0000200;o100<o`@03?l400Ko1@000ol000020003o`0002H0
001F0008o`00o`3o0?l30003o`0003/000?o00001P001?l00002o`030?l000H000?o00000P001?l0
0?l4000;o`000?l0o`3o0?l01002o`8000?o000010001Ol0003o00@000?o000010000ol0000[0000
E@000ol000020004o`00o`8000?o0000?@000ol000050006o`00o`3o0P000ol000030003o`000080
00?o00000P000ol000020004o`00o`8000Co003o10001?l0ool70004o`00o`@000?o00001@000ol0
000[0000E0000ol000020007o`3o0?l0o`110003o`0000@000?o0?l00P001Ol0003o00<000?o0000
0P000ol000040003o`00008000Wo0?l0o`3o0?l010001?l0ool70003o`3o00@000?o00001P000ol0
000[0000D`000ol000020004o`0000?o@`000ol0000300;o0`000ol000020003o`3o00@000?o0000
1P000ol0000200?o0`02o`@00_l20003o`0000@00_l40003o`0000L000?o0000:`0005801_l50003
o`00008000?o00000P000ol0000i017o10000ol000020003o`0000<05_l50003o`00008000?o0000
20000ol0000[0000E`02o`<00_l40003o`00008000?o0000?P000ol0000200;o0`02o`@000?o0000
0P02o`@000?o00000`000ol000020003o`00008000?o00001`02o`@000?o000020000ol0000[0000
E`001ol0o`3o0?l010001Ol0003o044000?o00000P001_l0o`3o00;o0P000ol000020004o`00o`<0
00?o000010001Ol0003o00<000?o0?l01`001?l00?l20003o`0000T000?o0000:`0005L000Co003o
0P000ol000020004o`00od8000?o00000P001?l00?l20004o`3oo`@000?o00000P001?l00?l70004
o`00o`8000Go0000o`050003o`0000800_l<0003o`0002/0001G0007o`3o0?l0o`040003o`3o04<0
00?o00000P002?l0o`3o0?l00_l30003o`0000@000?o0?l020001Ol0o`3o00D000Go0000o`0500;o
30000ol0000[0000E`02o`<00_l400;oA0000ol0000200;o0`03o`8000?o0?l02002o`T00ol70003
o`3o00@00_l20003o`0000T000?o0000:`0005804Om50003o`00008000?o00000P02o`@03?l400Oo
2@000ol000030003o`0000801_l50003o`0002/0001C0003o`0000D000Co003o0`000ol000140005
o`000?l00`001?l0ool30003o`0000T000?o00004@000ol000040003o`0000D00_l60003o`0002X0
001D0003o`0000<000?o00000P001?l00?m70004o`00o`8000Ko003o0?l20003o`0000X000?o0000
40000ol000050003o`0000<000?o0?l01`000ol0000Y0000E@001Ol0003o00H000?o0?l0B0001Ol0
o`3o00<000Ko003o0?l=0003o`0000l000?o00001P001Ol0003o008000?o00001P000ol0000X0000
EP000ol0o`0800;oB@03o`@000Co00000_l>0003o`0000h000?o00001`000ol0o`030003o`0000L0
00?o00009`00058000?o00000P02o`T000?o0000?P000ol000070003o`0000801ol:0003o`000080
00?o00003@02o`T000?o00000P0<obP0001B0005o`000?l00P000ol000070003o`0003h000?o0000
1@02o`<000?o00000`03o`T00_l20003o`00010000?o00001@000ol0000g0000DP001?l00?l40003
o`0000L000?o0000?P000ol000030003o`3o008000?o00000`001Ol0o`3o00P000Co0?oo50000ol0
00030003o`0003P0001B0003o`3o00H000?o00001`000ol0000n0005o`000?l00P000ol0o`050004
o`00o`8000?o00001@001?l0oolE0005o`000?l0>`0005800_l80003o`0000L000?o0000?P000ol0
o`0300;o1@001Ol0003o00<000?o00001002o`8000?o00004`000ol0o`0l0000DP000ol0000800_o
@0000ol0000200co10000ol000030003o`00008000?o00003@000ol000030003o`0003/0001B0003
o`0000L00_l900;o?`000ol000030004o`0000;o2@000ol000090003o`0000`00_m20000D`000ol0
00050004o`00o`P000?o0?l0?`000ol000030005o`3o0?l020000ol0000;0003o`0000/000?o0?l0
@@0005@000?o00000`000ol000020003o`0000D000Co003o?`000ol000030004o`00o`L000?o0000
3@000ol0000:0004o`00od00001E0005o`000?l01P000ol000040005o`000?l0?`002Ol0003o0?l0
o`060003o`0000l000?o00002@001Ol0003o03l0001F00?o20000ol0000300;o0`000ol0000m0003
o`3o00<00_l50003o`00014000?o00002002o`<000?o0000?00005L000?o0000200<ocl000?o0000
0P02o`@000?o00003@07o`T000?o00000P02ocd0001W0005o`3o0?l0A@000ol0o`030003o`000100
00?o00002`001Ol0003o008000?o0000>P0006L000Co003oA@001?l00?l20003o`00018000?o0000
2P001?l00?l40003o`0003T0001W0005o`3o0?l0@`001ol0003o0?l05P000ol000090003o`3o00H0
00?o0000>00006L00_l30003o`0003l000?o00000P02oaP000?o00002002o`P000?o0000=`0004`0
3?l50003o`00008000?o00000P000ol000030003o`0003P01ol40003o`0001P01_l400co>00004d0
00?o00001`000ol000030003o`00008000?o00001`02od@00_lJ0003o`00008000?o00000P02o`<0
0_lm0000CP000ol000050003o`0000D000Co00000_l70004o`00od8000?o0?l06`001Ol0003o00@0
00Oo0?l0o`3o03d0001?0003o`0000<000?o00001`001_l00?l0o`D000?o00000P000ol0000n0004
o`00oa`000Co003o10001?l00?l20003o`0003/0001@0005o`000?l02`000ol0o`020005o`000?l0
1P000ol0000l0005o`000?l07@000ol0o`040007o`3o0?l0o`0m0000D@000ol0o`0=00;o0`000ol0
o`080003o`0003X000?o00000P000ol0000L00;o1002o`<00_lm0000DP000ol0000=00Ko2P000ol0
000c00co7`000ol0000200;o10000ol0000k0000DP000ol0000=0005o`000?l0@@001Ol0003o02L0
00Co003o0P000ol0000o0000DP000ol0000=0004o`00od8000Co003o:@02o`@000?o0000?P000580
00?o00003@000ol0o`130003o`3o02X00_l50003o`0003d0001B0003o`0000d00_m400;o:P001?l0
0?l50003o`0003`0001<00Oo2@02o`@000?o00001`02ocX000?o0000:0000ol0000200;o10000ol0
000k0000B`02o`040?l0o`X000?o0?l01002o`L000Co003oH`000ol000050005o`000?l0?@0004X0
00?o0?l00P000ol000080004o`00o`@000?o0?l01@000ol000020003o`0005l000?o00001`001?l0
0?lm0000B@002?l00?l0o`3o20001Ol0003o00@000Co003o0`000ol000040003o`0005d000?o0000
2@000ol0o`0m0000B0001?l00002o`<000?o000010000ol000020003o`00008000Oo0000o`3o00P0
00?o0000F`000ol0000;00;o?@0004803?l40003o`0000804Ol:0003o`0000P000?o0000B007o`l0
00?o0000>`00048000?o00000P000ol000020003o`0000<000?o00000`000ol000020003o`000080
00?o00003@000ol000070003o`0004T000?o00000`000ol0001;0000@P000ol000030004o`00o`L0
00?o00000`001Ol0003o00D000?o00003@000ol000050003o`0004T00_l500;oC000048000?o0000
1002o`T000?o00000`001?l00?l60003o`0000d000?o00000`000ol000190003o`3o00D000?o0?l0
B`00048000?o00001002o`X000?o00000`000ol0o`070003o`0000d000Go0000o`1;0004o`00o`D0
00Co003oBP00048000?o00000`001?l00?l:0003o`0000<00_l80003o`3o00d000?o0?l0B`001Ol0
003o00D000Go0000o`190000@P06o`@01ol400Oo2@02o`<00_l90003o`0003T01_l:0003o`000080
1ol40003o`0004H000130003o`0000H000Go0?l0o`050004o`00o``00_l0103o0?l20003o`0000H0
00?o0000>P001Ol0003o01T000?o0000A`0004@000?o00001@001?l00?l50003o`00008000?o0000
20000ol0o`020003o`00008000?o00001@000ol0000k0004o`00oaP000?o0000B00004D000?o0000
10001Ol0o`3o00<000?o000010000ol000060008o`00o`3o0?l40003o`0000@000?o0000?0000ol0
o`0G0003o`0004T000160003o`0000<00_l30003o`3o00P000?o000010001?l00002o`<000?o0000
0P000ol000030003o`0003d00_lF0003o`0004X0001700co2@02o`@01ol400_o2P02oaT000?o0000
3@07o`@000?o00003@000ol0000200;oC@0004/000?o00001@000ol000050003o`0000P00_l00`3o
00030006o`00o`3o0P02o`T000Co003o5`02oa4000?o00000P001_l00?l0o`h000Go0000o`1?0000
BP000ol000070003o`0000<000?o000020000ol0o`020003o`0000800_l300;o00<0o`001`000ol0
00020003o`0001<000?o0?l04P000ol0000200;o0`000ol0000;0004o`00oe0000190003o`0000T0
00Go0000o`0:0004o`00o`<000Co00000_l300;o00<0o`001P000ol000040003o`00014000Co003o
4`001?l00002o`@000?o00002P000ol0o`1A0000B0000ol0000;0003o`3o00X000Go0000o`040003
o`3o008000?o0?l00P02o`H000?o00001P000ol0000?0005o`000?l050000ol0o`020003o`000080
00?o00002@02oe8000170003o`0000P01_l:00Ko1@000ol0000200co2P06o`@01ol40003o`0000<0
4Ol400Ko2P000ol0001A0000A`000ol000080003o`00008000?o00004P02o`@000?o00000P000ol0
000C0003o`00008000?o00000P02o`@000?o000020000ol0000700;o2@02o`T000?o0000D@0004P0
00?o00001`000ol000020003o`00014000?o0?l010001Ol0003o01L000Go0000o`030003o`3o00<0
0_l900;o20001?l0ool70004o`00o`L000?o0000DP0004T000?o00001P000ol000020003o`000100
00Co003o10001?l00?lI0004o`00o`8000Co003o0P000ol0o`080003o`3o00L000Ko003o0?l50003
o`00008000?o00000`000ol0001C0000BP000ol000050003o`00008000?o00003`001Ol0003o00@0
00?o0?l06`001Ol0o`3o00<000?o0?l00P000ol000050004o`00o`H000Go0000o`020005o`000?l0
1P001Ol0003o05H0001;0003o`0000@000?o00000P000ol0000>0003o`00008000?o00000P02oad0
0ol400;o0`000ol000040005o`000?l01@000ol000020007o`000?l0o`080003o`3o05L0001<00co
2P0<o`@000?o000020000ol0000=0003o`0000801ol40003o`0000<000?o00000P000ol000020003
o`0000<01_l:00KoD`00050000?o0?l03P02o`h00_l:00;o3P02o`T000?o000020001Ol0003o00@0
0_m^0000C`001?l00?l=0003o`3o00d000?o0?l02P000ol0o`0=0003o`3o00P000?o000020001?l0
0?l40003o`3o06h0001>0005o`000?l030001?l00?l<0004o`00o`X000Co003o30001?l00?l70003
o`0000P000?o0?l010001?l00?m^0000C@000ol000020003o`0000T000Go0000o`0;0005o`000?l0
2P001Ol0003o00/000Go0000o`060003o`0000P00_l40005o`000?l0KP0004`01ol:00Ko2P000ol0
00020003o`0000P000?o00000P0<o`@000?o00000`000ol000080003o`0000801_m^0000C@000ol0
000=0003o`00008000?o00001`02o`@000?o00001`02o`X000?o00000P000ol000020003o`000080
00?o00002@000ol000020003o`0000800_m]0000CP000ol0000<0007o`000?l0o`070004o`00o`@0
00?o00001@001?l00?l:0003o`0000;o0`000ol000020003o`0000/000Go0000o`030004o`00of`0
001?0003o`0000/000Co003o0`000ol000030003o`00008000?o00000P000ol000030003o`000080
00?o00002002o`050?l00?l010000ol0000=0004o`00o`8000?o00000P000ol0001Y0000D0000ol0
000:0003o`3o00D000Go0000o`060003o`00008000Go0000o`060003o`0000L00_l0103o0?l40003
o`0000l000Go0?l0o`060003o`0006P0001A0003o`0000T00_l70003o`3o00P000?o00000P000ol0
o`080003o`0000@00_l200?o10000ol0000A00?o20000ol0001W0000DP000ol000080003o`0000L0
00?o0000200<o`@000?o00000`000ol000020003o`0000800_lD0003o`0000P000?o0000IP000580
00?o00002@000ol000050003o`0000X000?o00000_l0103o0?l500;o1P000ol000080003o`000100
0_mc0000DP000ol0000:0003o`0000<000?o00003002o`050?l00?l01@000ol0o`070003o`0000P0
00?o00003P000ol0o`1c0000DP000ol0000;0005o`000?l03`02o`060?l0o`3o0`001?l00?l80003
o`0000P000?o000030001?l00?mc0000DP000ol0000<0003o`3o00l000?o00000ol30003o`3o00<0
00?o00001`000ol000080003o`0000X000Go0000o`1c0000DP06o`@03Ol9017o1007o`T00_l:0003
o`00008000?o0000L@0005H000?o00000P000ol000050007o`000?l0o`0700?o0P001?l00?l300;o
1`000ol000050003o`0000D000?o00002P02o`<00_mb0000E@000ol000020003o`0000L000Co003o
0P000ol000030004o`3o00;o10001_l00?l0o`D000?o00001`000ol000030003o`0000/000?o0?l0
0P000ol0o`1a0000E0000ol000020003o`0000T000?o0?l00`001Ol0003o008000Co0?oo1@000ol0
o`020005o`000?l02`001Ol0003o00h000Ko003o0?l20003o`0006h0001C0003o`00008000?o0000
2`02o`@000?o0?l00`02o`8000?o00000`02o`<000?o0?l03@000ol0o`0?0004o`0000;o0`000ol0
001]0000A`0Ao`l000?o00000`06o`@000?o00000`06o`l01ol:0003o`00008000?o00000P000ol0
001/0000A`000ol000070003o`0001P00_l40003o`0000800_l300;o6P000ol000080003o`0000L0
0_m]0000B0000ol000050003o`0001P000Co003o0P03o`8000Ko003o0?l20003o`0001L000?o0000
2@000ol000050004o`00of`000190003o`0000<000?o000060000ol0000200;o00<0o`000_l40003
o`00008000?o00005P000ol0000:0003o`0000<000?o00000P000ol0001Y0000BP001Ol0003o01X0
00?o00000`02o`030?l000;o0`000ol0o`040003o`0001D000?o00002`001Ol0003o00H000?o0000
J00004/000?o0?l06P000ol000030003o`0000?o0P000ol0o`030003o`00008000?o000050000ol0
000<0003o`3o00P000?o0000I`0004`000?o000060000ol00003017o10000ol0000C0003o`0000d0
00?o00001`02ofP0001V0003o`0000@00_l200;o9P000ol0000<00;o1`000ol0001X0000I@000ol0
00050006o`3oo`3o9`000ol0000;0003o`3o00D000?o0000J@0006@000?o00001P001_l0ool0obP0
00?o00002P001?l00?l30003o`0006X0001S0003o`0000L00_l200;o:@000ol000090007o`000?l0
o`1]0000HP000ol0000700Oo:P02o`T01_m^0000H`000ol000050004o`3ooc0000?o00001@000ol0
001b0000I0000ol000030006o`00o`3o<0000ol000030003o`0007<0001U0005o`000?l00`001?l0
0?l`0005o`000?l0MP0006H000?o0?l010001Ol0003o030000?o0?l0M`0006L000?o00000`000ol0
00020003o`0002h000?o0000MP0006d000?o0000[00006d00_n]0000K@000ol0o`2/0000K@001?l0
0?n[0000K@001Ol0003o0:X0001]00KoZ@0006h000Go0000o`2Y0000K`001?l00?nY0000L0000ol0
o`2Y0000L@02ojT0001b0003o`000:L0003o01d0003o01d0003o01d0003o01d00000\
\>"],
  ImageRangeCache->{{{0, 283}, {180.75, 0}} -> {-40.3041, -4.80017, 0.185894, 
  0.185894}}]
}, Closed]],

Cell[TextData[{
  StyleBox["FoldList", "Input"],
  " and ",
  StyleBox["Fold", "Input"],
  " are used to iterate functions of two variables. Here we use ",
  StyleBox["FoldList", "Input"],
  " with symbolic arguments."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(FoldList[f, x1, {x2, x3, x4}] // TableForm\)], "Input"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {"x1"},
          {\(f[x1, x2]\)},
          {\(f[f[x1, x2], x3]\)},
          {\(f[f[f[x1, x2], x3], x4]\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      TableForm[ {x1, 
        f[ x1, x2], 
        f[ 
          f[ x1, x2], x3], 
        f[ 
          f[ 
            f[ x1, x2], x3], x4]}]]], "Output"]
}, Closed]],

Cell[TextData[{
  "Here we generate a list of partial products of elements in a list using ",
  StyleBox["FoldList", "Input"],
  " with the operator ",
  StyleBox["Times", "Input"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(FoldList[Times, 1, {2, a, 3, b, 5, c}]\)], "Input"],

Cell[BoxData[
    \({1, 2, 2\ a, 6\ a, 6\ a\ b, 30\ a\ b, 30\ a\ b\ c}\)], "Output"]
}, Closed]],

Cell["Here are two ways to get the final result.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Apply[Times, {2, a, 3, b, 5, c}]\)], "Input"],

Cell[BoxData[
    \(30\ a\ b\ c\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Fold[Times, 1, {2, a, 3, b, 5, c}]\)], "Input"],

Cell[BoxData[
    \(30\ a\ b\ c\)], "Output"]
}, Closed]],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " contains a function called ",
  StyleBox["IntegerDigits", "Input"],
  " that returns a list of digits of a given number in a given base. Here are \
the base-2 digits of the decimal number 714."
}], "Text"],

Cell[CellGroupData[{

Cell["IntegerDigits[714, 2]", "Input"],

Cell[BoxData[
    \({1, 0, 1, 1, 0, 0, 1, 0, 1, 0}\)], "Output"]
}, Closed]],

Cell[TextData[{
  "To reverse the process, here is one way to convert a list of binary digits \
into a decimal number using ",
  StyleBox["Fold", "Input"],
  "."
}], "Text"],

Cell[BoxData[
    \(\(bitlist = {1, 0, 1, 1, 0, 0, 1, 0, 1, 0}; \)\)], "Input"],

Cell[TextData[{
  "Using ",
  StyleBox["Fold", "Input"],
  ", we iterate a function that multiplies its first argument by 2, then adds \
the second argument."
}], "Text"],

Cell[BoxData[
    \(shiftbits[x_, y_] := 2\ x + y\)], "Input"],

Cell[TextData[{
  "Folding ",
  StyleBox["shiftbits", "Input"],
  " over the list of bits returns the decimal value."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Fold[shiftbits, 0, bitlist]\)], "Input"],

Cell[BoxData[
    \(714\)], "Output"]
}, Closed]],

Cell[TextData[{
  "Our function reproduces the built-in function ",
  StyleBox["FromDigits", "Input"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(FromDigits[bitlist, \ 2]\)], "Input"],

Cell[BoxData[
    \(714\)], "Output"]
}, Closed]],

Cell[TextData[{
  StyleBox["FixedPoint", "Input"],
  " iterates a function until two successive iterates are equal, or the \
maximum number of iterations are met. Here we iterate ",
  Cell[BoxData[
      \(TraditionalForm\`x \[RightArrow] 1 + 1\/x\)]],
  ", starting with 1.0, until a fixed point is reached."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(FixedPoint[flip, 1.0]\)], "Input"],

Cell[BoxData[
    \(1.6180339887498949`\)], "Output"]
}, Closed]],

Cell["The final value is the golden ratio.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(N[GoldenRatio]\)], "Input"],

Cell[BoxData[
    \(1.6180339887498949`\)], "Output"]
}, Closed]],

Cell[TextData[{
  "Here is part of a fractal Julia set calculation, one that follows the \
iterations of ",
  Cell[BoxData[
      \(TraditionalForm\`z \[RightArrow] z\^2 + \[ImaginaryI]\)]],
  ", starting with the value ",
  Cell[BoxData[
      \(TraditionalForm\`0.1 + 0.1  \[ImaginaryI]\)]],
  ". In this case we specify that a maximum of 35 iterations should be \
carried out, and that the iteration should stop when an iterate reaches a \
distance greater than two units from the origin."
}], "Text"],

Cell[BoxData[
    \(iter[z_] := z\^2 + I\)], "Input"],

Cell[BoxData[
    \(stop[z1_, z2_] := Abs[z2] > 2.0\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(FixedPointList[iter, 0.1 + 0.1\ I, 35, SameTest \[Rule] stop]\)], 
  "Input"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{
          RowBox[{
            StyleBox["0.1`",
              StyleBoxAutoDelete->True,
              PrintPrecision->1], "\[InvisibleSpace]"}], "+", 
          RowBox[{
            StyleBox["0.1`",
              StyleBoxAutoDelete->True,
              PrintPrecision->1], " ", "I"}]}], ",", 
        \(\(0.`\[InvisibleSpace]\) + 1.02000000000000001`\ I\), ",", 
        \(\(-1.04039999999999999`\) + 1.`\ I\), ",", 
        \(\(0.0824321599999999676`\[InvisibleSpace]\) - 
          1.08079999999999998`\ I\), ",", 
        \(\(-1.16133357899773437`\) + 0.821814642944000084`\ I\), ",", 
        \(\(0.673316374350512614`\[InvisibleSpace]\) - 
          0.908801881125801713`\ I\), ",", 
        \(\(-0.372565919169276016`\) - 0.223822375205100732`\ I\), ",", 
        \(\(0.0887089084839946195`\[InvisibleSpace]\) + 
          1.16677717789787793`\ I\), ",", 
        \(\(-1.35349971241891475`\) + 1.20700705979071276`\ I\), ",", 
        \(\(0.375095429133463609`\[InvisibleSpace]\) - 
          2.26736741662865926`\ I\)}], "}"}]], "Output"]
}, Closed]],

Cell[TextData[{
  "To plot the path of the iteration, we again convert the complex numbers \
into ordered pairs, then use ",
  StyleBox["ListPlot", "Input"],
  " to plot the ordered pairs."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(ListPlot[% /. Complex[a_, b_] \[Rule] {a, b}, 
      PlotJoined \[Rule] True, AspectRatio \[Rule] Automatic]; \)\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.7142 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.659806 0.46989 1.10623 0.46989 [
[.18992 1.09373 -6 -9 ]
[.18992 1.09373 6 0 ]
[.42486 1.09373 -12 -9 ]
[.42486 1.09373 12 0 ]
[.89475 1.09373 -9 -9 ]
[.89475 1.09373 9 0 ]
[.64731 .16645 -12 -4.5 ]
[.64731 .16645 0 4.5 ]
[.64731 .40139 -24 -4.5 ]
[.64731 .40139 0 4.5 ]
[.64731 .63634 -12 -4.5 ]
[.64731 .63634 0 4.5 ]
[.64731 .87128 -24 -4.5 ]
[.64731 .87128 0 4.5 ]
[.64731 1.34117 -18 -4.5 ]
[.64731 1.34117 0 4.5 ]
[.64731 1.57612 -6 -4.5 ]
[.64731 1.57612 0 4.5 ]
[ 0 0 0 0 ]
[ 1 1.7142 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.18992 1.10623 m
.18992 1.11248 L
s
[(-1)] .18992 1.09373 0 1 Mshowa
.42486 1.10623 m
.42486 1.11248 L
s
[(-0.5)] .42486 1.09373 0 1 Mshowa
.89475 1.10623 m
.89475 1.11248 L
s
[(0.5)] .89475 1.09373 0 1 Mshowa
.125 Mabswid
.2369 1.10623 m
.2369 1.10998 L
s
.28389 1.10623 m
.28389 1.10998 L
s
.33088 1.10623 m
.33088 1.10998 L
s
.37787 1.10623 m
.37787 1.10998 L
s
.47185 1.10623 m
.47185 1.10998 L
s
.51884 1.10623 m
.51884 1.10998 L
s
.56583 1.10623 m
.56583 1.10998 L
s
.61282 1.10623 m
.61282 1.10998 L
s
.70679 1.10623 m
.70679 1.10998 L
s
.75378 1.10623 m
.75378 1.10998 L
s
.80077 1.10623 m
.80077 1.10998 L
s
.84776 1.10623 m
.84776 1.10998 L
s
.14293 1.10623 m
.14293 1.10998 L
s
.09594 1.10623 m
.09594 1.10998 L
s
.04895 1.10623 m
.04895 1.10998 L
s
.00196 1.10623 m
.00196 1.10998 L
s
.94174 1.10623 m
.94174 1.10998 L
s
.98873 1.10623 m
.98873 1.10998 L
s
.25 Mabswid
0 1.10623 m
1 1.10623 L
s
.65981 .16645 m
.66606 .16645 L
s
[(-2)] .64731 .16645 1 0 Mshowa
.65981 .40139 m
.66606 .40139 L
s
[(-1.5)] .64731 .40139 1 0 Mshowa
.65981 .63634 m
.66606 .63634 L
s
[(-1)] .64731 .63634 1 0 Mshowa
.65981 .87128 m
.66606 .87128 L
s
[(-0.5)] .64731 .87128 1 0 Mshowa
.65981 1.34117 m
.66606 1.34117 L
s
[(0.5)] .64731 1.34117 1 0 Mshowa
.65981 1.57612 m
.66606 1.57612 L
s
[(1)] .64731 1.57612 1 0 Mshowa
.125 Mabswid
.65981 .21344 m
.66356 .21344 L
s
.65981 .26043 m
.66356 .26043 L
s
.65981 .30741 m
.66356 .30741 L
s
.65981 .3544 m
.66356 .3544 L
s
.65981 .44838 m
.66356 .44838 L
s
.65981 .49537 m
.66356 .49537 L
s
.65981 .54236 m
.66356 .54236 L
s
.65981 .58935 m
.66356 .58935 L
s
.65981 .68333 m
.66356 .68333 L
s
.65981 .73032 m
.66356 .73032 L
s
.65981 .7773 m
.66356 .7773 L
s
.65981 .82429 m
.66356 .82429 L
s
.65981 .91827 m
.66356 .91827 L
s
.65981 .96526 m
.66356 .96526 L
s
.65981 1.01225 m
.66356 1.01225 L
s
.65981 1.05924 m
.66356 1.05924 L
s
.65981 1.15322 m
.66356 1.15322 L
s
.65981 1.20021 m
.66356 1.20021 L
s
.65981 1.2472 m
.66356 1.2472 L
s
.65981 1.29418 m
.66356 1.29418 L
s
.65981 1.38816 m
.66356 1.38816 L
s
.65981 1.43515 m
.66356 1.43515 L
s
.65981 1.48214 m
.66356 1.48214 L
s
.65981 1.52913 m
.66356 1.52913 L
s
.65981 .11946 m
.66356 .11946 L
s
.65981 .07247 m
.66356 .07247 L
s
.65981 .02548 m
.66356 .02548 L
s
.65981 1.62311 m
.66356 1.62311 L
s
.65981 1.6701 m
.66356 1.6701 L
s
.25 Mabswid
.65981 0 m
.65981 1.7142 L
s
0 0 m
1 0 L
1 1.7142 L
0 1.7142 L
closepath
clip
newpath
.5 Mabswid
.70679 1.15322 m
.65981 1.58552 L
.17093 1.57612 L
.69854 .59837 L
.11411 1.49239 L
.97619 .67919 L
.48474 1.00106 L
.70149 1.65449 L
.02381 1.67339 L
.83606 .04081 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{168, 288},
  ImageMargins->{{35, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40002X000180P10`4000010?ooobl_;oooZZVYZNSX
j?oo05FZZZZZZ_W0RS/k>gYjN[Vi^OShn03ooeGooj[ooonI<c<c<fi^KZf][Nc/k02ZoeFZojZZoonZ
oclo?ginO[fm_Oclo5D00:X00?l00?l0VCLg=g9bL[6a/O3`l03o05Go0:[o00<30d92@X61PL30`000
EED0EJX0EOl0ELbIoc/k>gIfM[Fe]OCdm03oEEGoEJ[oE@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0Z/`c
<clo?gYjN[Vi^OShn03oZUGoZZ[oZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`<30d92@WinO[fm_Ocl
o03ooeGooj[oo`l?3di>CXf=SLc<c01E05EE0:YE0?mE00L71dI6AX61PL30`000EED00:X00?l001<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@/;2dY:BXF5QLC4a000ZUD0EJX0EOl0EALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZPl?3di>CXV9RLS8b000oeD0ZZX0Z_l0ZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEoa<C
4e9BDXf=SLc<c01E05D0ojX0ool0oalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ01LG5eIFEY6ATM3@d01E
EEEE0:YE0?mE02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZEA/K6eYJFYFEUMCDe01EZUEEEJYEEOmEEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZQlO7eiNGYVIVMSHf01EoeEEZZYEZ_mEZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZob<S8f9RHYfMWMcLg02Z05EEojYEoomEobl_;fi^KZf][Nc/k03o05Go0:[o0=gW1RLW
9fIVIZ6QXN3Ph02ZEEFZ0:ZZ0?nZ03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooEB/[:fYZJZFUYNCTi02Z
ZUFZEJZZEOnZECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000:P0001^0003o`0003L0001^0003o`0003L0
001^0003o`0003L0001^0003o`0003L0001^0003o`0003L0001^0003o`0003L0001^0003o`0003L0
001^0003o`0001X000?o00006P0006h000?o00006P000ol0000J0000KP000ol0000I0003o`0001/0
001^0003o`0001T000?o00006`0006h000?o000060000ol0000L0000KP000ol0000H0003o`0001`0
001^0003o`0001L000?o00007@0006h000?o00005`000ol0000M0000KP000ol0000F0003o`0001h0
001^0003o`0001H000?o00007P0006h000?o00005@000ol0000O0000KP000ol0000E0003o`0001l0
001^0003o`0001@000?o0000800006h000?o000050000ol0000P0000KP000ol0000C0003o`000240
001^0003o`0001<000?o00008@0006h000?o00004P000ol0000R0000KP000ol0000B0003o`000280
001^0003o`00014000?o00008`0006L01?l30003o`00014000?o00008`0006P000?o00000`000ol0
000@0003o`0002@0001Q00Go0`000ol0000200;o4@000ol0000T0000JP001Ol0003o014000?o0000
9@0006L000Co003o0`000ol0000?0003o`0002D0001X00;o10000ol0000>0003o`0002H0001^0003
o`0000h000?o00009P0006h000?o00003@000ol0000W0000KP000ol0000=0003o`0002L0001^0003
o`0000`000?o0000:00006h000?o000030000ol0000X0000KP000ol0000;0003o`0002T0001^0003
o`0000/000?o0000:@0006h000?o00002P000ol0000Z0000KP000ol0000:0003o`0002X0001^0003
o`0000T000?o0000:`0006h000?o00002@000ol0000[0000KP000ol000080003o`0002`0001^0003
o`0000P000?o0000;00006h000?o00001`000ol0000]0000KP000ol000070003o`0002d0001^0003
o`0000H000?o0000;P0006h000?o00001P000ol0000^0000KP000ol000050003o`0002l0001^0003
o`0000D000?o0000;`0006h000?o000010000ol0000`0000KP000ol000040003o`000300001^0003
o`0000<000?o0000<@0006h000?o00000`000ol0000a0000KP000ol000020003o`000380001^0003
o`00008000?o0000<P0006h000Go0000o`0e0000KP001Ol0003o03D0001^0004o`00ocH0001^0004
o`00ocH0001^0003o`3o03L0001^0003o`3o03L0001^00;o>00006h00_lh0000F`03o`@00_l300?o
10000ol0000g0000G0000ol0000300;o1P001Ol0003o03T0001E00Go0P000ol0000;0003o`0000?o
>00005`000?o00002003o`<00_li0000G0000ol000080003o`00008000?o0?l0>@0005/00_l:00Co
00@0o`3o>@0006/000Co003o>@0006/000Co003o>@0006X000Go0000o`0i0000JP001Ol0003o03T0
001Y0003o`00008000?o0000=`0006T000?o00000P000ol0000g0000J0000ol000030003o`0003L0
001X0003o`0000<000?o0000=`0006L000?o000010000ol0000g0000I`000ol000040003o`0003L0
001V0003o`0000D000?o0000=`0006H000?o00001@000ol0000g0000I@000ol000060003o`0003L0
001U0003o`0000H000?o0000=`0006@000?o00001`000ol0000g0000I0000ol000070003o`0003L0
001S0003o`0000P000?o0000=`0006<000?o000020000ol0000g0000HP000ol000090003o`0003L0
001R0003o`0000T000?o0000=`00064000?o00002P000ol0000g0000H@000ol0000:0003o`0003L0
001P0003o`0000/000?o0000=`00060000?o00002`000ol0000g0000G`000ol0000<0003o`0003L0
001O0003o`0000`000?o0000=`0005h000?o00003@000ol0000g0000GP000ol0000=0003o`0003L0
001M0003o`0000h000?o0000=`0005d000?o00003P000ol000030003o`000340001L0003o`0000l0
00?o00000`000ol0000a0000G0000ol0000?0003o`00008000?o0000<P0005/000?o000040001?l0
0002oc@0001K0003o`0000T00ol40005o`000?l0=@0005X000?o00002`000ol000030003o`0000;o
=@0005X000?o00001005o`8000?o00000`04ocH0001I0003o`0000`000?o00000`000ol0o`0g0000
F@000ol0000<0003o`0000<00olg0000F0000ol0000<00;o1@02ocP0001H0003o`0001<00_lh0000
E`000ol0000C00;o>@0005L000?o00004`02ocT0001F0003o`0001<00olc00;o100005H000?o0000
4P001?l0oolb0003o`0000@0001E0003o`0001<00_l00`3o000_00;o1`0005D000?o00004P001Ol0
o`3o02l00_l80000E0000ol0000B0003o`3o008000?o0000:`03o`T0001D0003o`00018000?o0?l0
0P000ol0000Z0003o`3o00X0001C0003o`00018000?o0?l00`000ol0000X00;o00<0o`002P0005<0
00?o00004@000ol0o`040003o`0002H00_l20003o`0000X0001B0003o`00018000?o0?l010000ol0
000U0005o`000?l03@00058000?o00004@000ol0o`050003o`0002<00_l30003o`0000`0001A0003
o`00014000Co003o1@000ol0000R0003o`00008000?o00003@00054000?o00004@000ol0o`060003
o`0002000_l40003o`0000h0001@0003o`00014000Co003o1P000ol0000O0003o`0000<000?o0000
3`00050000?o000040001?l00?l70003o`0001d00_l50003o`000100001?0003o`00014000Co003o
1`000ol0000L0003o`0000@000?o00004@0004l000?o000040001?l00?l80003o`0001X00_l60003
o`000180001>0003o`00010000Go0000o`080003o`0001T000?o00001@000ol0000C0000CP000ol0
000@0004o`00o`T000?o00005`02o`H00_lF0000C@000ol0000@0005o`000?l02@000ol0000F0003
o`0000D000?o00005P0004d000?o00003`001Ol0003o00X000?o00005002o`L000?o00005`0004`0
00?o000040001?l00?l;0003o`0001800_l80003o`0001P0001<0003o`0000l000Go0000o`0;0003
o`00014000?o00001`000ol0000I0000B`000ol0000@0004o`00o``000?o00003`02o`T000?o0000
6P0004/000?o00003`001Ol0003o00`000?o00003P000ol000080003o`0001/0001:0003o`0000l0
00Go0000o`0=0003o`0000`00_l:0003o`0001`0001:0003o`0000l000Go0000o`0=0003o`0000/0
00?o00002@000ol0000M0000B@000ol0000?0005o`000?l03P000ol0000900;o2`000ol0000N0000
B@000ol0000>0003o`00008000?o000030000ol000080003o`0000X000?o00007`0004P000?o0000
3`001Ol0003o00l000?o00001P02o``000?o0000800004P000?o00003P000ol000020003o`0000d0
00?o00001@000ol0000;0003o`00024000170003o`0000h000Co00000_l400;o0`03o`@000?o0000
0`02o`d000?o00008P0004L000?o00003P001Ol00?l000;o0`02o`H000Go0000o`040003o`0000`0
00?o00008`0004H000?o00003005o`050?oo0?l02`001?l00002o`030?oo00h000?o0000900004H0
00?o00003@000ol000020004o`00o`P00ol40003o`3o00l000?o00009@0004D000?o00003P000ol0
00020004o`00o`P000?o00001002o`h00_lX0000A@000ol0000=0003o`00008000Co0?oo2@04o`04
0?ooo`h000?o0000:00004@000?o00003@000ol000030003o`0000h000Co003o3@000ol0000Y0000
A0000ol0000=0003o`00008000?o00003@02o`<000?o00002P000ol0000Z0000@`000ol0000=0003
o`0000<000?o000030000ol000030003o`0000T000?o0000:`0004<000?o000030000ol000030003
o`0000/00_l60003o`0000P000?o0000;000048000?o00003@000ol000030003o`0000X000?o0000
1P000ol000070003o`0002d000120003o`0000`000?o00000`000ol0000900;o2@000ol000060003
o`0002h000110003o`0000d000?o00000`000ol000080003o`0000T000?o00001@000ol0000_0000
@@000ol0000<0003o`0000<000?o00001`02o``000?o000010000ol0000`0000@0000ol0000<0003
o`0000<000?o00001`000ol0000<0003o`0000<000?o0000<@00040000?o000030000ol000030003
o`0000D00_l?0003o`00008000?o0000<P0003l000?o000030000ol000030003o`0000D000?o0000
3`001Ol0003o03D0000o0003o`0000/000?o000010000ol0000300;o4P001?l00?lf0000?P000ol0
000<0003o`0000<000?o00000P02oa@000?o0?l0=`0003h000?o00002`000ol000040005o`000?l0
5P02ocP0000m0003o`0000/000?o000010000ol00002oaL000?o0000=`0003d000?o00002`000ol0
00040003o`3o01L00oli0000?0000ol0000;0003o`0000@00olG0004o`00ocT0000l0003o`0000X0
00?o00001@000ol0000F0005o`000?l0>@0003/000?o00002`000ol000040003o`0001H000?o0000
0P000ol0000g0000>`000ol0000:0003o`0000D000?o00005@000ol000030003o`0003L0000j0003
o`0000X000?o00001@000ol0o`0E0003o`0000@000?o0000=`0003X000?o00002P000ol000040004
o`00oa@000?o00001@000ol0000g0000>@000ol0000:0003o`0000D000Co003o4`000ol000060003
o`0003L0000i0003o`0000T000?o00001@000ol000020003o`0000l000?o00001`000ol0000g0000
>0000ol0000:0003o`0000D000?o00000P000ol0000>0003o`0000P000?o0000=`0003P000?o0000
2@000ol000050003o`0000<000?o00003@000ol000090003o`0003L0000g0003o`0000T000?o0000
1P000ol000040003o`0000/000?o00002P000ol0000g00008003oa@000?o00002002o`@00_l00`3o
0003o`<000?o00002P000ol0000;0003o`0001d00_l400;o0`03o``0000Q0003o`00018000?o0000
2002o`030?l000800_l00`3o00030004o`00o`/000?o000030000ol0000L0004o`00o`<00_l60003
o`0000T0000J00Go0P000ol0000B0003o`0000801Ol01@3oo`3o00D000?o00000`001Ol0003o00T0
00?o00003@000ol0000L0004o`00o`/000?o00002@00024000?o00004@000ol000090004o`00o`D0
00?o00000ol40003o`0000H000?o00003P000ol0000L0004o`00o`P00ol<00008@000ol0000A0003
o`0000P00_l20003o`00008000Go0000o`060003o`0000D000?o00003`000ol0000L0004o`00o`P0
00?o0000300002000_lB0003o`0000T000Co0?oo1@001?l00004o`@000?o00000P02oa8000?o0000
7@02o`T01?l;0000=0000ol000080003o`0000H000?o00002P001Ol0003o01@000?o0000=`0003<0
00?o000020000ol000060003o`0000/000Co003o5@000ol0000g0000<`000ol000080003o`0000H0
00?o00003002oaH000?o0000=`000:So000O0003o`00010000?o00001`000ol000070003o`0000`0
0_lG0003o`0002@000?o00004000034000?o000020000ol000060003o`0000`000Co003o5P000ol0
000g0000<@000ol000070003o`0000L000?o00002`001Ol0003o01H000?o0000=`00030000?o0000
1`000ol000070003o`0000/000?o00000P000ol0000D0003o`0003L0000`0003o`0000L000?o0000
1`000ol0000:0003o`0000@000?o00004`000ol0000g0000;`000ol000070003o`0000L000?o0000
2P000ol000050003o`0001<000?o0000=`0002l000?o00001P000ol000080003o`0000T000?o0000
1P000ol0000C0003o`0000D000?o0000;`0002h000?o00001`000ol000070003o`0000T000?o0000
20000ol0000B0003o`0000D000?o0000;`0002h000?o00001P000ol000080003o`0000P000?o0000
2@000ol0000B0003o`0000D000?o0000;`0002d000?o00001P000ol000080003o`0000P000?o0000
2P000ol0000B0003o`0000D000?o0000;`0002d000?o00001P000ol000070003o`0000P000?o0000
30000ol0000A0003o`0000D000?o0000;`0002`000?o00001P000ol000080003o`0000L000?o0000
3@000ol0000A0003o`0000D000?o0000;`0002`000?o00001P000ol000070003o`0000H00_l@0003
o`00014000?o000010000ol0000`0000:`000ol000060003o`0000P000?o00001@000ol0000A0003
o`00010000?o000010000ol0000`0000:`000ol000050003o`0000P000?o00001@000ol0000B0003
o`00010000?o000010000ol0000`0000:P000ol000060003o`0000P000?o000010000ol0000C0003
o`00010000?o000010000ol0000`0000:P000ol000050003o`0000P000?o000010000ol0000E0003
o`0000l000?o000010000ol0000`0000:@000ol000050003o`0000T000?o00000`000ol0000F0003
o`0000l000?o000010000ol0000`0000:@000ol000050003o`0000P000?o00000`000ol0000G0003
o`0000l000?o000010000ol0000`0000:0000ol000050003o`0000T000?o00000P000ol0000I0003
o`0000h000?o000010000ol0000`0000:0000ol000040003o`0000T000?o00000P000ol0000J0003
o`0000h000?o000010000ol0000`00009`000ol000050003o`0000T000Go0000o`0M0003o`0000h0
00?o00000`000ol0000a00009`000ol000040003o`0000T000Go0000o`0O0003o`0000d000?o0000
0`000ol0000a00009P000ol000040003o`0000T000Go0000o`0P0003o`0000d000?o00000`000ol0
000a00009P000ol000040003o`0000T000Co003o8@000ol0000=0003o`0000<000?o0000<@0002D0
00?o000010000ol000090004o`00ob<000?o000030000ol000030003o`000340000U0003o`0000<0
00?o00002P000ol0o`0T0003o`0000`000?o00000`000ol0000a000090000ol000040003o`0000T0
00?o0?l09@000ol0000<0003o`0000<000?o0000<@0002@000?o00000`000ol0000:00;o9`000ol0
000;0003o`0000<000?o0000<@0002<000?o00000`000ol0000:00;o:0000ol0000;0003o`0000<0
00?o0000<@0002<000?o00000`000ol0000900;o:@000ol0000;0003o`00008000?o0000<P000280
00?o00000`000ol0000900;o:`000ol0000:0003o`00008000?o0000<P00028000?o00000`000ol0
00080003o`3o02/000?o00002P000ol000020003o`000380000Q0003o`0000<000?o000020000ol0
o`0/0003o`0000X000?o00000P000ol0000b00008@000ol000020003o`0000P000?o0?l0;P000ol0
00090003o`00008000?o0000<P00020000?o00000`000ol000070004o`00obh000?o00002@000ol0
00020003o`000380000P0003o`00008000?o00001`001?l00?lY00;o1002o`<00ol40003o`000080
00?o0000<P0001l000?o00000P000ol000070005o`000?l0:0001?l00?l300;o1P001Ol0003o00@0
00?o0000<P0001l000?o00000P000ol000060005o`000?l0:@001?l00?l40003o`0000@000Co0000
0_l30003o`000380000N0003o`00008000?o00001P000ol000020003o`0002L000Co003o1@000ol0
0003o`@000Go0000o`0e00007P001Ol0003o00P000?o00000P000ol0000X0004o`00o`D000Co003o
1P001Ol0003o03D0000M0003o`00008000?o00001@000ol000030003o`0002T00_l60003o`0000Co
0`001Ol0003o03D0000M0005o`000?l01`000ol000030003o`0003<000?o00001P001Ol0003o03D0
000L0005o`000?l01`000ol000040003o`0003<000?o00001P001Ol0003o03D0000L0005o`000?l0
1P000ol000040003o`0003@000?o00001P001Ol0003o03D0000K0005o`000?l01P000ol000050003
o`0003D000?o00001@001Ol0003o03D0000K0004o`00o`D00_l70003o`0003H000?o00001@001Ol0
003o03D0000J0005o`000?l010000ol000060003o`0003L000?o00001@001Ol0003o03D0000J0004
o`00o`@000?o00001`000ol0000h0003o`0000@000Co003o=P0001T000Co003o10000ol000070003
o`0003T000?o000010001?l00?lf00006@001?l00?l30003o`0000P000?o0000>@000ol000040004
o`00ocH0000H0004o`00o`<000?o000020000ol0000k0003o`0000<000Co003o=P0001P000?o0?l0
0`000ol000090003o`0003/000?o00000`001?l00?lf00005`001?l00?l20003o`0000T000?o0000
?0000ol000030004o`00ocH0000G0003o`3o008000?o00002P000ol0000m0003o`00008000Co003o
=P0001H000Ko003o0?l<0003o`0003h000?o00000P001?l00?lf00005P001Ol0o`3o00d000?o0000
?P000ol000020004o`00ocH0000E0005o`3o0?l03@000ol000100007o`000?l0o`0g00005@001?l0
ool>0003o`00040000Oo0000o`3o03L0000D0004o`3oo`h000?o0000@@001ol0003o0?l0=`0001@0
0ol>0003o`0004<000Ko003o0?lg00004`000ol0o`0?0003o`0004<000Ko003o0?lg00004`02o`l0
00?o0000A0001_l00?l0ocL0000B00;o40000ol000150005o`3o0?l0=`00018000?o00003P000ol0
00160005o`3o0?l0=`00014000?o00003`000ol000160005o`3o0?l0=`00014000?o00003P000ol0
001800?o>000010000?o00003`000ol0001800?o>000010000?o00003P000ol0001900?o>00000l0
00?o00003`000ol0001:00;o>00000l000?o00003P000ol0001;00;o>00000h000?o00003`000ol0
001;00;o>00000h000?o00003P000ol0001<00;o>00000d000?o00003P000ol0001=00;o>00000d0
00?o00003P000ol0001=00;o>00000`000?o00003P000ol0001700?o10000ol0o`0g000030000ol0
000>0003o`0004P000?o00000`000ol0o`0g00002`000ol0000>01Ko=P000ol0000300?o=`0000/0
00?o0000900Yo`d000?o00000`001?l00?lf00002P000ol0001>01Co0P000ol0000d00002P000ol0
001J00;o1@001?l00?lf00002@000ol0001R0005o`000?l0=@0000T000?o0000HP001Ol0003o03D0
00080003o`0006<000Go0000o`0e000020000ol0001S0003o`00008000?o0000<P0000L000?o0000
I0000ol000020003o`00038000070003o`0006@000?o00000P000ol0000b00001P000ol0001U0003
o`0000<000?o0000<@0000H000?o0000I@000ol000030003o`00034000050003o`0006H000?o0000
0`000ol0000a00001@000ol0001J01Co<P0000@000?o0000=@0Vo``000?o0000=`0000@000?o0000
3`0Voc8000?o0000=`0000<04omH0003o`0003L0001^0003o`0003L0001^0003o`0003L0001^0003
o`0003L0001^0003o`0003L0001^0003o`0003L0001^0003o`0003L0001^0003o`0003L00000\
\>"],
  ImageRangeCache->{{{0, 167}, {287, 0}} -> {-1.40418, -2.35889, 0.0127436, 
  0.0127436}}]
}, Closed]],

Cell["\<\
Using this technique, we create an elegant program to generate the \
fractal Mandelbrot set.\
\>", "Text"],

Cell[BoxData[
    \(iter2[z_] := z\^2 + a + b\ I\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(DensityPlot[
      \(-Length[FixedPointList[iter2, a + b\ I, 35, SameTest \[Rule] stop]]
          \), {a, \(-2\), 1/2}, {b, \(-1\), 1}, Mesh \[Rule] False, 
      AspectRatio \[Rule] Automatic, PlotPoints \[Rule] 75]; \)\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .8 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% DensityGraphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.788462 0.384615 0.4 0.384615 [
[.01923 -0.0125 -6 -9 ]
[.01923 -0.0125 6 0 ]
[.21154 -0.0125 -12 -9 ]
[.21154 -0.0125 12 0 ]
[.40385 -0.0125 -6 -9 ]
[.40385 -0.0125 6 0 ]
[.59615 -0.0125 -12 -9 ]
[.59615 -0.0125 12 0 ]
[.78846 -0.0125 -3 -9 ]
[.78846 -0.0125 3 0 ]
[.98077 -0.0125 -9 -9 ]
[.98077 -0.0125 9 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .01538 -12 -4.5 ]
[-0.0125 .01538 0 4.5 ]
[-0.0125 .20769 -24 -4.5 ]
[-0.0125 .20769 0 4.5 ]
[-0.0125 .4 -6 -4.5 ]
[-0.0125 .4 0 4.5 ]
[-0.0125 .59231 -18 -4.5 ]
[-0.0125 .59231 0 4.5 ]
[-0.0125 .78462 -6 -4.5 ]
[-0.0125 .78462 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 .8 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 .8 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.01923 0 m
.01923 .00625 L
s
[(-2)] .01923 -0.0125 0 1 Mshowa
.21154 0 m
.21154 .00625 L
s
[(-1.5)] .21154 -0.0125 0 1 Mshowa
.40385 0 m
.40385 .00625 L
s
[(-1)] .40385 -0.0125 0 1 Mshowa
.59615 0 m
.59615 .00625 L
s
[(-0.5)] .59615 -0.0125 0 1 Mshowa
.78846 0 m
.78846 .00625 L
s
[(0)] .78846 -0.0125 0 1 Mshowa
.98077 0 m
.98077 .00625 L
s
[(0.5)] .98077 -0.0125 0 1 Mshowa
.125 Mabswid
.05769 0 m
.05769 .00375 L
s
.09615 0 m
.09615 .00375 L
s
.13462 0 m
.13462 .00375 L
s
.17308 0 m
.17308 .00375 L
s
.25 0 m
.25 .00375 L
s
.28846 0 m
.28846 .00375 L
s
.32692 0 m
.32692 .00375 L
s
.36538 0 m
.36538 .00375 L
s
.44231 0 m
.44231 .00375 L
s
.48077 0 m
.48077 .00375 L
s
.51923 0 m
.51923 .00375 L
s
.55769 0 m
.55769 .00375 L
s
.63462 0 m
.63462 .00375 L
s
.67308 0 m
.67308 .00375 L
s
.71154 0 m
.71154 .00375 L
s
.75 0 m
.75 .00375 L
s
.82692 0 m
.82692 .00375 L
s
.86538 0 m
.86538 .00375 L
s
.90385 0 m
.90385 .00375 L
s
.94231 0 m
.94231 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .01538 m
.00625 .01538 L
s
[(-1)] -0.0125 .01538 1 0 Mshowa
0 .20769 m
.00625 .20769 L
s
[(-0.5)] -0.0125 .20769 1 0 Mshowa
0 .4 m
.00625 .4 L
s
[(0)] -0.0125 .4 1 0 Mshowa
0 .59231 m
.00625 .59231 L
s
[(0.5)] -0.0125 .59231 1 0 Mshowa
0 .78462 m
.00625 .78462 L
s
[(1)] -0.0125 .78462 1 0 Mshowa
.125 Mabswid
0 .05385 m
.00375 .05385 L
s
0 .09231 m
.00375 .09231 L
s
0 .13077 m
.00375 .13077 L
s
0 .16923 m
.00375 .16923 L
s
0 .24615 m
.00375 .24615 L
s
0 .28462 m
.00375 .28462 L
s
0 .32308 m
.00375 .32308 L
s
0 .36154 m
.00375 .36154 L
s
0 .43846 m
.00375 .43846 L
s
0 .47692 m
.00375 .47692 L
s
0 .51538 m
.00375 .51538 L
s
0 .55385 m
.00375 .55385 L
s
0 .63077 m
.00375 .63077 L
s
0 .66923 m
.00375 .66923 L
s
0 .70769 m
.00375 .70769 L
s
0 .74615 m
.00375 .74615 L
s
.25 Mabswid
0 0 m
0 .8 L
s
.01923 .79375 m
.01923 .8 L
s
.21154 .79375 m
.21154 .8 L
s
.40385 .79375 m
.40385 .8 L
s
.59615 .79375 m
.59615 .8 L
s
.78846 .79375 m
.78846 .8 L
s
.98077 .79375 m
.98077 .8 L
s
.125 Mabswid
.05769 .79625 m
.05769 .8 L
s
.09615 .79625 m
.09615 .8 L
s
.13462 .79625 m
.13462 .8 L
s
.17308 .79625 m
.17308 .8 L
s
.25 .79625 m
.25 .8 L
s
.28846 .79625 m
.28846 .8 L
s
.32692 .79625 m
.32692 .8 L
s
.36538 .79625 m
.36538 .8 L
s
.44231 .79625 m
.44231 .8 L
s
.48077 .79625 m
.48077 .8 L
s
.51923 .79625 m
.51923 .8 L
s
.55769 .79625 m
.55769 .8 L
s
.63462 .79625 m
.63462 .8 L
s
.67308 .79625 m
.67308 .8 L
s
.71154 .79625 m
.71154 .8 L
s
.75 .79625 m
.75 .8 L
s
.82692 .79625 m
.82692 .8 L
s
.86538 .79625 m
.86538 .8 L
s
.90385 .79625 m
.90385 .8 L
s
.94231 .79625 m
.94231 .8 L
s
.25 Mabswid
0 .8 m
1 .8 L
s
.99375 .01538 m
1 .01538 L
s
.99375 .20769 m
1 .20769 L
s
.99375 .4 m
1 .4 L
s
.99375 .59231 m
1 .59231 L
s
.99375 .78462 m
1 .78462 L
s
.125 Mabswid
.99625 .05385 m
1 .05385 L
s
.99625 .09231 m
1 .09231 L
s
.99625 .13077 m
1 .13077 L
s
.99625 .16923 m
1 .16923 L
s
.99625 .24615 m
1 .24615 L
s
.99625 .28462 m
1 .28462 L
s
.99625 .32308 m
1 .32308 L
s
.99625 .36154 m
1 .36154 L
s
.99625 .43846 m
1 .43846 L
s
.99625 .47692 m
1 .47692 L
s
.99625 .51538 m
1 .51538 L
s
.99625 .55385 m
1 .55385 L
s
.99625 .63077 m
1 .63077 L
s
.99625 .66923 m
1 .66923 L
s
.99625 .70769 m
1 .70769 L
s
.99625 .74615 m
1 .74615 L
s
.25 Mabswid
1 0 m
1 .8 L
s
0 0 m
1 0 L
1 .8 L
0 .8 L
closepath
clip
newpath
% Start of gray image
p
.01923 .01538 translate
.96154 .76924 scale
75 string
75 75 8 [75 0 0 75 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  Mimage
F8F8F8F8F8F8F8F8F1F1F1F1F1F1F1F1EAEAEAEAEAEAEAEA
EAEAEAEAEAEAEAEAEAEAEAEAEAEAEAEAE3E3E3E3E3E3E3E3
DCDCDCDCD5CEC0A3C0B8B1B1D5E3E3E3E3E3E3E3EAEAEAEA
EAEAF1
F8F8F8F8F8F8F8F8F1F1F1F1F1F1F1EAEAEAEAEAEAEAEAEA
EAEAEAEAEAEAEAEAEAEAEAEAEAEAE3E3E3E3E3E3E3E3E3E3
DCDCDCDCD5CEC7A395316ACED5DCE3E3E3E3E3E3E3EAEAEA
EAEAEA
F8F8F8F8F8F8F8F8F1F1F1F1F1F1EAEAEAEAEAEAEAEAEAEA
EAEAEAEAEAEAEAEAEAEAEAEAEAE3E3E3E3E3E3E3E3E3E3DC
DCDCDCD5CECEC7B180AAC0CED5DCDCE3E3E3E3E3E3E3EAEA
EAEAEA
F8F8F8F8F8F8F8F1F1F1F1F1F1EAEAEAEAEAEAEAEAEAEAEA
EAEAEAEAEAEAEAEAEAEAEAEAE3E3E3E3E3E3E3E3E3E3DCDC
DCDCDCD5CEC7C0A340AAC0CED5DCDCDCE3E3E3E3E3E3EAEA
EAEAEA
F8F8F8F8F8F8F8F1F1F1F1F1EAEAEAEAEAEAEAEAEAEAEAEA
EAEAEAEAEAEAEAEAEAEAEAE3E3E3E3E3E3E3E3E3E3E3DCDC
DCDCD5CEC0B89C4E0080B8C7CED5DCDCDCE3E3E3E3E3E3EA
EAEAEA
F8F8F8F8F8F8F1F1F1F1F1EAEAEAEAEAEAEAEAEAEAEAEAEA
EAEAEAEAEAEAEAEAEAEAE3E3E3E3E3E3E3E3E3E3E3DCDCDC
DCD5CEC080AA9C00004EB1B88ED5DCDCDCDCE3E3E3E3E3EA
EAEAEA
F8F8F8F8F8F8F1F1F1F1EAEAEAEAEAEAEAEAEAEAEAEAEAEA
EAEAEAEAEAEAEAEAEAE3E3E3E3E3E3E3E3E3E3E3DCDCDCDC
D5D5C70E008000000031236AB8CED5DCDCDCDCE3E3E3E3E3
EAEAEA
F8F8F8F8F8F8F1F1F1F1EAEAEAEAEAEAEAEAEAEAEAEAEAEA
EAEAEAEAEAEAEAEAE3E3E3E3E3E3E3E3E3E3E3DCDCDCD5D5
D5CEC7B80000000000004E2355CED5DCDCDCDCDCE3E3E3E3
E3EAEA
F8F8F8F8F8F1F1F1F1EAEAEAEAEAEAEAEAEAEAEAEAEAEAEA
EAEAEAEAEAEAEAEAE3E3E3E3E3E3E3E3E3E3DCDCD5D5D5D5
CECEC7B88E0000000000006AB8CECED5DCDCDCDCDCE3E3E3
E3EAEA
F8F8F8F8F8F1F1F1EAEAEAEAEAEAEAEAEAEAEAEAEAEAEAEA
EAEAEAEAEAEAEAE3E3E3E3E3E3E3E3E3DCDCDCD5D5D5D5CE
CECEC7A3000000000000006AB8C7CED5D5D5DCDCDCDCDCE3
E3E3EA
F8F8F8F8F8F1F1F1EAEAEAEAEAEAEAEAEAEAEAEAEAEAEAEA
EAEAEAEAEAEAE3E3E3E3E3E3E3E3E3DCDCD5D5D5D5CECECE
CEC7C0B10000000000000087B8C7C7CED5D5D5D5D5DCDCE3
E3E3EA
F8F8F8F8F1F1F1EAEAEAEAEAEAEAEAEAEAEAEAEAEAEAEAEA
EAEAEAEAEAE3E3E3E3E3E3E3E3DCDCDCD5CECEC7C0C7C7C7
C7C0B8B1950000000000009CB1C0C7C7CED5D5D5D5CECEDC
E3E3EA
F8F8F8F8F1F1F1EAEAEAEAEAEAEAEAEAEAEAEAEAEAEAEAEA
EAEAEAEAE3E3E3E3E3E3E3E3DCDCDCD5CE23B8AA9CC0C0B8
63AAAAA39563000000006A9CAAAAB89CC0CECECECEC795D5
DCE3E3
F8F8F8F8F1F1EAEAEAEAEAEAEAEAEAEAEAEAEAEAEAEAEAEA
EAEAEAE3E3E3E3E3E3E3DCDCDCDCDCD5CEB85C47A3AAB8AA
1C80006A00000000000000000000A3559CC0C7C7C7C063CE
DCE3E3
F8F8F8F1F1F1EAEAEAEAEAEAEAEAEAEAEAEAEAEAEAEAEAEA
EAEAE3E3E3E3E3E3DCDCDCDCDCDCD5D5CE9C78006300A39C
00000000000000000000000000005C009CB8B895B8B18EC0
D5DCE3
F8F8F8F1F1EAEAEAEAEAEAEAEAEAEAEAEAEAEAEAEAEAEAEA
EAE3E3E3E3E3DCDCDCDCDCDCDCD5D5D5CEB8A30000008E00
0000000000000000000000000000000087A3AA008E6A15B1
D5DCE3
F8F8F8F1F1EAEAEAEAEAEAEAEAEAEAEAEAEAEAEAEAEAEAEA
E3E3E3E3DCDCDCDCDCDCDCDCD5D5D5CEC7C0780000000000
00000000000000000000000000000000006A870000009C95
D5DCDC
F8F8F8F1EAEAEAEAEAEAEAEAEAEAEAEAEAEAEAEAEAEAE3E3
E3E3DCDCDCDCDCDCDCDCDCD5D5D5D5CEC7C0A30700000000
00000000000000000000000000000000000040000000B1C7
D5DCDC
F8F8F1F1EAEAEAEAEAEAEAEAEAEAEAEAEAEAEAEAEAE3E3E3
DCDCDCDCDCDCDCDCDCDCD5D5D5D5CEC7C0B8A38000000000
00000000000000000000000000000000000000000000AACE
D5DCDC
F8F8F1F1EAEAEAEAEAEAEAEAEAEAEAEAEAEAEAE3E3E3DCDC
DCDCDCDCDCDCDCDCDCD5D5D5D5CEC7B800A3000000000000
0000000000000000000000000000000000000000008EC0CE
D5DCDC
F8F8F1EAEAEAEAEAEAEAEAEAEAEAEAEAEAEAE3E3E3DCD5D5
D5DCDCDCDCDCDCDCD5D5D5D5CECEC0404E0E000000000000
000000000000000000000000000000000000000000AAC0CE
D5D5DC
F8F8F1EAEAEAEAEAEAEAEAEAEAEAEAE3E3E3E3E3DCB8CED5
D5D5D5D5D5D5D5D5D5D5CECECEC7C02A0000000000000000
00000000000000000000000000000000000000000080B1C7
CED5DC
F8F8F1EAEAEAEAEAEAEAEAEAEAE3E3E3E3E3DCDCD5C79CC7
CECECECECECECECECECECECEC7C7B8AA4E00000000000000
00000000000000000000000000000000000000000000AAC0
C0CEDC
F8F8EAEAEAEAEAEAEAEAEAE3E3E3E3E3E3DCDCDCD5C715C7
C7CECECEC79CC7CECECECECEC7C7B1800000000000000000
000000000000000000000000000000000000000000009515
8EC7DC
F8F1EAEAEAEAEAEAEAE3E3E3E3E3E3E3DCDCDCD5D5AA87B8
C0C0C7C0B1AAC0C7C7C7C7C7C7B831000000000000000000
000000000000000000000000000000000000000000000000
6A78DC
F8F1EAEAEAEAEAE3E3E3E3E3E3E3E3DCDCDCDCD5D5C700A3
A371B8B8AA4E5CB831C0C0C0C0B89C000000000000000000
000000000000000000000000000000000000000000000000
87C7D5
F8F1EAEAEAEAE3E3E3E3E3E3E3E3DCDCDCDCDCD5CEC7C0AA
382A5CAAA37823A395B8C0C0B8B100000000000000000000
0000000000000000000000000000000000000000000000A3
C0CED5
F8EAEAEAEAE3E3E3E3E3E3E3E3DCDCDCDCDCDCD5CECEC0B1
950000876A0000782A9CAAB1B1AA63000000000000000000
00000000000000000000000000000000000000000000000E
C0CEDC
F8EAEAEAE3E3E3E3E3E3E3E3DCDCDCDCDCDCD5CECECEC000
0700001C00000000006395AAAA9C00000000000000000000
000000000000000000000000000000000000000000000078
AACEDC
F8EAEAE3E3E3E3E3E3E3E3E3DCDCDCDCDCDCD5CECEC7B8AA
870000000000000000004795A39500000000000000000000
000000000000000000000000000000000000000000000000
87D5DC
F8EAE3E3E3E3E3E3E3E3E3DCDCDCDCDCDCD5CECEC7B1A387
000000000000000000000000958700000000000000000000
00000000000000000000000000000000000000000000009C
C0D5DC
F8EAE3E3E3E3E3E3E3E3DCDCDCDCDCDCD5B8C7C7C0B89500
000000000000000000000000716A00000000000000000000
0000000000000000000000000000000000000000000000A3
C7D5DC
F8E3E3E3E3E3E3E3E3DCDCDCD5D5D5D5CEB8B1C0C0B19531
000000000000000000000000004E00000000000000000000
000000000000000000000000000000000000000000000000
CED5DC
F8E3E3E3E3E3E3E3E3DCD5D5D5D5CECEC7C071B140A38000
000000000000000000000000002A00000000000000000000
0000000000000000000000000000000000000000000000C0
D5DCDC
F8E3E3DCDCE3E3DCD5D5D5D5D5CECECEC7C09C8700716A00
000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000A3CE
D5DCDC
F8DCDCDCD5D5CEC0CECED5D5CECECEC7C0409C0000003800
000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000C0CE
D5DCDC
F8DCDCD5D5CECE87C7C7C74EC0C7C0AAAAA36A0000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000B8C7CE
D5DCDC
950000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000004EA3C0C7CE
D5DCDC
F8DCDCD5D5CECE87C7C7C74EC0C7C0AAAAA36A0000000000
000000000000000000000000000000000000000000000000
000000000000000000000000000000000000000000B8C7CE
D5DCDC
F8DCDCDCD5D5CEC0CECED5D5CECECEC7C0409C0000003800
000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000C0CE
D5DCDC
F8E3E3DCDCE3E3DCD5D5D5D5D5CECECEC7C09C8700716A00
000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000A3CE
D5DCDC
F8E3E3E3E3E3E3E3E3DCD5D5D5D5CECEC7C071B140A38000
000000000000000000000000002A00000000000000000000
0000000000000000000000000000000000000000000000C0
D5DCDC
F8E3E3E3E3E3E3E3E3DCDCDCD5D5D5D5CEB8B1C0C0B19531
000000000000000000000000004E00000000000000000000
000000000000000000000000000000000000000000000000
CED5DC
F8EAE3E3E3E3E3E3E3E3DCDCDCDCDCDCD5B8C7C7C0B89500
000000000000000000000000716A00000000000000000000
0000000000000000000000000000000000000000000000A3
C7D5DC
F8EAE3E3E3E3E3E3E3E3E3DCDCDCDCDCDCD5CECEC7B1A387
000000000000000000000000958700000000000000000000
00000000000000000000000000000000000000000000009C
C0D5DC
F8EAEAE3E3E3E3E3E3E3E3E3DCDCDCDCDCDCD5CECEC7B8AA
870000000000000000004795A39500000000000000000000
000000000000000000000000000000000000000000000000
87D5DC
F8EAEAEAE3E3E3E3E3E3E3E3DCDCDCDCDCDCD5CECECEC000
0700001C00000000006395AAAA9C00000000000000000000
000000000000000000000000000000000000000000000078
AACEDC
F8EAEAEAEAE3E3E3E3E3E3E3E3DCDCDCDCDCDCD5CECEC0B1
950000876A0000782A9CAAB1B1AA63000000000000000000
00000000000000000000000000000000000000000000000E
C0CEDC
F8F1EAEAEAEAE3E3E3E3E3E3E3E3DCDCDCDCDCD5CEC7C0AA
382A5CAAA37823A395B8C0C0B8B100000000000000000000
0000000000000000000000000000000000000000000000A3
C0CED5
F8F1EAEAEAEAEAE3E3E3E3E3E3E3E3DCDCDCDCD5D5C700A3
A371B8B8AA4E5CB831C0C0C0C0B89C000000000000000000
000000000000000000000000000000000000000000000000
87C7D5
F8F1EAEAEAEAEAEAEAE3E3E3E3E3E3E3DCDCDCD5D5AA87B8
C0C0C7C0B1AAC0C7C7C7C7C7C7B831000000000000000000
000000000000000000000000000000000000000000000000
6A78DC
F8F8EAEAEAEAEAEAEAEAEAE3E3E3E3E3E3DCDCDCD5C715C7
C7CECECEC79CC7CECECECECEC7C7B1800000000000000000
000000000000000000000000000000000000000000009515
8EC7DC
F8F8F1EAEAEAEAEAEAEAEAEAEAE3E3E3E3E3DCDCD5C79CC7
CECECECECECECECECECECECEC7C7B8AA4E00000000000000
00000000000000000000000000000000000000000000AAC0
C0CEDC
F8F8F1EAEAEAEAEAEAEAEAEAEAEAEAE3E3E3E3E3DCB8CED5
D5D5D5D5D5D5D5D5D5D5CECECEC7C02A0000000000000000
00000000000000000000000000000000000000000080B1C7
CED5DC
F8F8F1EAEAEAEAEAEAEAEAEAEAEAEAEAEAEAE3E3E3DCD5D5
D5DCDCDCDCDCDCDCD5D5D5D5CECEC0404E0E000000000000
000000000000000000000000000000000000000000AAC0CE
D5D5DC
F8F8F1F1EAEAEAEAEAEAEAEAEAEAEAEAEAEAEAE3E3E3DCDC
DCDCDCDCDCDCDCDCDCD5D5D5D5CEC7B800A3000000000000
0000000000000000000000000000000000000000008EC0CE
D5DCDC
F8F8F1F1EAEAEAEAEAEAEAEAEAEAEAEAEAEAEAEAEAE3E3E3
DCDCDCDCDCDCDCDCDCDCD5D5D5D5CEC7C0B8A38000000000
00000000000000000000000000000000000000000000AACE
D5DCDC
F8F8F8F1EAEAEAEAEAEAEAEAEAEAEAEAEAEAEAEAEAEAE3E3
E3E3DCDCDCDCDCDCDCDCDCD5D5D5D5CEC7C0A30700000000
00000000000000000000000000000000000040000000B1C7
D5DCDC
F8F8F8F1F1EAEAEAEAEAEAEAEAEAEAEAEAEAEAEAEAEAEAEA
E3E3E3E3DCDCDCDCDCDCDCDCD5D5D5CEC7C0780000000000
00000000000000000000000000000000006A870000009C95
D5DCDC
F8F8F8F1F1EAEAEAEAEAEAEAEAEAEAEAEAEAEAEAEAEAEAEA
EAE3E3E3E3E3DCDCDCDCDCDCDCD5D5D5CEB8A30000008E00
0000000000000000000000000000000087A3AA008E6A15B1
D5DCE3
F8F8F8F1F1F1EAEAEAEAEAEAEAEAEAEAEAEAEAEAEAEAEAEA
EAEAE3E3E3E3E3E3DCDCDCDCDCDCD5D5CE9C78006300A39C
00000000000000000000000000005C009CB8B895B8B18EC0
D5DCE3
F8F8F8F8F1F1EAEAEAEAEAEAEAEAEAEAEAEAEAEAEAEAEAEA
EAEAEAE3E3E3E3E3E3E3DCDCDCDCDCD5CEB85C47A3AAB8AA
1C80006A00000000000000000000A3559CC0C7C7C7C063CE
DCE3E3
F8F8F8F8F1F1F1EAEAEAEAEAEAEAEAEAEAEAEAEAEAEAEAEA
EAEAEAEAE3E3E3E3E3E3E3E3DCDCDCD5CE23B8AA9CC0C0B8
63AAAAA39563000000006A9CAAAAB89CC0CECECECEC795D5
DCE3E3
F8F8F8F8F1F1F1EAEAEAEAEAEAEAEAEAEAEAEAEAEAEAEAEA
EAEAEAEAEAE3E3E3E3E3E3E3E3DCDCDCD5CECEC7C0C7C7C7
C7C0B8B1950000000000009CB1C0C7C7CED5D5D5D5CECEDC
E3E3EA
F8F8F8F8F8F1F1F1EAEAEAEAEAEAEAEAEAEAEAEAEAEAEAEA
EAEAEAEAEAEAE3E3E3E3E3E3E3E3E3DCDCD5D5D5D5CECECE
CEC7C0B10000000000000087B8C7C7CED5D5D5D5D5DCDCE3
E3E3EA
F8F8F8F8F8F1F1F1EAEAEAEAEAEAEAEAEAEAEAEAEAEAEAEA
EAEAEAEAEAEAEAE3E3E3E3E3E3E3E3E3DCDCDCD5D5D5D5CE
CECEC7A3000000000000006AB8C7CED5D5D5DCDCDCDCDCE3
E3E3EA
F8F8F8F8F8F1F1F1F1EAEAEAEAEAEAEAEAEAEAEAEAEAEAEA
EAEAEAEAEAEAEAEAE3E3E3E3E3E3E3E3E3E3DCDCD5D5D5D5
CECEC7B88E0000000000006AB8CECED5DCDCDCDCDCE3E3E3
E3EAEA
F8F8F8F8F8F8F1F1F1F1EAEAEAEAEAEAEAEAEAEAEAEAEAEA
EAEAEAEAEAEAEAEAE3E3E3E3E3E3E3E3E3E3E3DCDCDCD5D5
D5CEC7B80000000000004E2355CED5DCDCDCDCDCE3E3E3E3
E3EAEA
F8F8F8F8F8F8F1F1F1F1EAEAEAEAEAEAEAEAEAEAEAEAEAEA
EAEAEAEAEAEAEAEAEAE3E3E3E3E3E3E3E3E3E3E3DCDCDCDC
D5D5C70E008000000031236AB8CED5DCDCDCDCE3E3E3E3E3
EAEAEA
F8F8F8F8F8F8F1F1F1F1F1EAEAEAEAEAEAEAEAEAEAEAEAEA
EAEAEAEAEAEAEAEAEAEAE3E3E3E3E3E3E3E3E3E3E3DCDCDC
DCD5CEC080AA9C00004EB1B88ED5DCDCDCDCE3E3E3E3E3EA
EAEAEA
F8F8F8F8F8F8F8F1F1F1F1F1EAEAEAEAEAEAEAEAEAEAEAEA
EAEAEAEAEAEAEAEAEAEAEAE3E3E3E3E3E3E3E3E3E3E3DCDC
DCDCD5CEC0B89C4E0080B8C7CED5DCDCDCE3E3E3E3E3E3EA
EAEAEA
F8F8F8F8F8F8F8F1F1F1F1F1F1EAEAEAEAEAEAEAEAEAEAEA
EAEAEAEAEAEAEAEAEAEAEAEAE3E3E3E3E3E3E3E3E3E3DCDC
DCDCDCD5CEC7C0A340AAC0CED5DCDCDCE3E3E3E3E3E3EAEA
EAEAEA
F8F8F8F8F8F8F8F8F1F1F1F1F1F1EAEAEAEAEAEAEAEAEAEA
EAEAEAEAEAEAEAEAEAEAEAEAEAE3E3E3E3E3E3E3E3E3E3DC
DCDCDCD5CECEC7B180AAC0CED5DCDCE3E3E3E3E3E3E3EAEA
EAEAEA
F8F8F8F8F8F8F8F8F1F1F1F1F1F1F1EAEAEAEAEAEAEAEAEA
EAEAEAEAEAEAEAEAEAEAEAEAEAEAE3E3E3E3E3E3E3E3E3E3
DCDCDCDCD5CEC7A395316ACED5DCE3E3E3E3E3E3E3EAEAEA
EAEAEA
F8F8F8F8F8F8F8F8F1F1F1F1F1F1F1F1EAEAEAEAEAEAEAEA
EAEAEAEAEAEAEAEAEAEAEAEAEAEAEAEAE3E3E3E3E3E3E3E3
DCDCDCDCD5CEC0A3C0B8B1B1D5E3E3E3E3E3E3E3EAEAEAEA
EAEAF1
pop
P
% End of image
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{287, 229.562},
  ImageMargins->{{35, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004O0000i@P10`4000010?ooobl_;oooZZVYZNSX
j?oo05FZZZZZZ_W0RS/k>gYjN[Vi^OShn03ooeGooj[ooonI<c<c<fi^KZf][Nc/k02ZoeFZojZZoonZ
oclo?ginO[fm_Oclo5D00:X00?l00?l0VCLg=g9bL[6a/O3`l03o05Go0:[o00<30d92@X61PL30`000
EED0EJX0EOl0ELbIoc/k>gIfM[Fe]OCdm03oEEGoEJ[oE@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0Z/`c
<clo?gYjN[Vi^OShn03oZUGoZZ[oZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`<30d92@WinO[fm_Ocl
o03ooeGooj[oo`l?3di>CXf=SLc<c01E05EE0:YE0?mE00L71dI6AX61PL30`000EED00:X00?l001<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@/;2dY:BXF5QLC4a000ZUD0EJX0EOl0EALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZPl?3di>CXV9RLS8b000oeD0ZZX0Z_l0ZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEoa<C
4e9BDXf=SLc<c01E05D0ojX0ool0oalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ01LG5eIFEY6ATM3@d01E
EEEE0:YE0?mE02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZEA/K6eYJFYFEUMCDe01EZUEEEJYEEOmEEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZQlO7eiNGYVIVMSHf01EoeEEZZYEZ_mEZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZob<S8f9RHYfMWMcLg02Z05EEojYEoomEobl_;fi^KZf][Nc/k03o05Go0:[o0=gW1RLW
9fIVIZ6QXN3Ph02ZEEFZ0:ZZ0?nZ03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooEB/[:fYZJZFUYNCTi02Z
ZUFZEJZZEOnZECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l080000?l080000?l080000?l080000?l0
80000?l080000?l080000?l0800002401?lW00?o1002o`<00olX00?o:@02o`@00_l300?o9P02obT0
0_l400;o0`03o`<0000R0003o`0002P000?o00000`02o`H000?o00009P000ol0000W0004o`00o`<0
0_l60003o`00028000Co003o9`001?l00?l300;o1P01o`400@0001/01Ol30003o`0002001Ol20003
o`0000/000?o00007`05o`8000?o00008@05o`050?l00?l02`000ol0000R0004o`00obL000Co003o
2`01o`400@0002@000?o00009P000ol0000800?o:@000ol0000W0004o`00o`P00olU0004o`00obL0
00Co003o2003o`<0000Q0004o`00obP000?o000020000ol0000Y0003o`0002L000Co003o20000ol0
000U0004o`00obL000Co003o20000ol0000300008P02obP00_l:00Co9`02obX00_l900Co9@02obT0
0_l900Co0P000?l080000?l080000?l080000?l0800001/0ool500006`000ol000020003o`0000H0
00?o00001`000ol000070003o`0000L000?o00001`000ol000060003o`0000L000?o00001`000ol0
00070003o`0000L000?o00001P000ol000070003o`0000L000?o00001`000ol000070003o`0000H0
00?o00001`000ol000070003o`0000L000?o00001`000ol000060003o`0000L000?o00001`000ol0
00070003o`0000L000Go0000o`0500004`03o`D000?o00000P000ol0000^0003o`0002h000?o0000
;P000ol0000^0003o`0002h000Go0000o`05000050000ol000040003o`000?/000?o00000`0000d0
1Ol20003o`0000@00_ok00;o1@0001@000?o000010000ol0000201Y46^]?11[c3M<3/`>C12/3hP<[
0`/7jP>c5o<D10?[10000ol00003000050000ol000040003o`0000806T@Jjdl46_<=d`>c0i<4:`?R
0b/32`OZ0k<Gla@40n/40003o`0000<0000C00;o1P000ol0000201Y46^]?11[c3M<3/`>C12/3hP<[
0`/7jP>c5o<D10?[10000ol0000300006`000ol0000201Y45n];127c3M<3/`>C18<3hP>b0nP4l@>C
0k<4daKc50@40003o`0000<0000K0003o`0000806T@Gjd/48O<=d`>c0i<4P`?R0k83j0Ca0i<3/`CC
5_<D10@000?o00000`0001/000?o00000P0JA1C[B`@Ql`gC0k<6T`B30nX3:P<312/3T`>c1m<Gla04
10000ol0000300006`000ol0000201Y45>];127c3M<3/`JC18<3jP<Z0`<4:`>C0k<7daOc40@40003
o`0000<0000K0003o`0000806T@Djd/48O<=d`>c1Y<4P`?Z0bX30`@[0i<3/`OC5o<@10@000?o0000
0`0001/000?o00000P0GA1?[C0@Pla7C0k<3T`>312/3hP<Y0`<4:`>C0k<:daCc40@40003o`0000<0
000K00;o0`0GA1?[C0@Pla7C0k<3T`>312/3hP<Y0`<4:`>C0k<:daCc40@300;o1@0001/000?o0000
0P0GA13[B`@Tl`gC1;<3T`<[0`/4dP>10ol3:P@;0h<3T`Bc2M<Dl`d410000ol0000300006`000ol0
000201M44>];12Cc3M<4/`>C0b/32`CB0h43o`<Z10/3P`>C1;<9daCc3@@40003o`0000<0000K0003
o`0000805d@@jd/49?<=d`Bc0i<3:`<;1=83P@?o0bX42`>30i<4/`WC5?<=10@000?o00000`0001/0
00?o00000P0DA13[B`@Tl`gC0k<4T`<[0bX30`CB1_l3P@CZ0`/3TPBc3M<@l`d410000ol000030000
6`000ol0000201A44>];12Cc3M<3/`BC0b/3:P<31=86o`>11>X32`>B1;<=da3c3@@40003o`0000<0
000K0003o`00008054@@jd/49?<=d`>c19<3:`<Z0`<4dPKo0h44jP<;0i84/`gC4?<=10@000?o0000
0`0001/000?o00000P0DA0g[B`@Tl`gC1[<4P`>00ol3:P[o0nP4d0?a0`/4T`>c3M<@l`X410000ol0
000300006`000ol0000201A43N];12Cc3M<6/`B30h03o`<Z2_l3j0C@0o432`BC0k<=da3c2P@40003
o`0000<0000K0003o`00008054@=jdP48o<:d`Zc0i<4P`<;4ol4P@?@0kD4T`>c4=<@l`L410000ol0
000300006`02o`<054@=jdP48o<:d`Zc0i<4P`<;4ol4P@?@0kD4T`>c4=<@l`L40`02o`D0000K0003
o`00008054@=jdP48o<:d`Zc0i<4P`<;4ol4P@?@0kD4T`>c4=<@l`L410000ol0000300006`000ol0
000201143N]<123c1m<=/`JC18<32`>B5?l3l@<;1i<3/a3C3O<710@000?o00000`0001/000?o0000
0P0@A0g[C0@Pl`OC3K<6T`B30`/3TQCo0o432`NC0k<@d`gc1`@40003o`0000<0000K0003o`000080
44@=jd`48?<7d`fc1Y<4P`<;0i8Do`?a0`/7T`>c4=<=l`L410000ol0000300006`000ol000020114
2^];11kc2M<>/`VC18<3hQOo0o432`B30i<:/a3C2_<310@000?o00000`0001/000?o00000P0@A0[[
B`@Nl`WC3[<9T`B30n8Go`?a0`/4P`>C2[<@d`[c0`@40003o`0000<0000K0003o`00008044@:jdP4
7O<7d`fc3I<3P`@[0nXGo`=b0`/7P`>C4;<7d`[c0`@40003o`0000<0000K0003o`00008044@:jdP4
7O<7d`fc3I<3P`@[0nXGo`=b0`/7P`>C4;<7d`[c0`@40003o`0000<0000K00;o0`0@A0[[B0@Ml`OC
3K<=T`>312/3jQOo0g832`N30i<@/`OC2_<310<00_l500006`000ol0000200e42^]811[c2]<3/`JC
18<3:`f30b/42`?Z0k8Do`?B0nX4:`J30i<=/`NC0m<7l`<410000ol0000300006`000ol0000200e4
2^]811[c2]<3/`JC18<3:`f30b/42`?Z0k8Do`?B0nX4:`J30i<=/`NC0m<7l`<410000ol000030000
6`000ol0000200e42^]411_c2M<4/`>C0m032`@30m87:`<;0m470`?R0k83d@go1?43dPL30`/3dP<[
3I<4P`>b0k<3d`Oc10000ol0000300006`000ol0000200e42^]411_c2M<4/`>C0m032`@30m87:`<;
0m470`?R0k83d@go1?43dPL30`/3dP<[3I<4P`>b0k<3d`Oc10000ol0000300006`000ol0000200e4
2^]411_c2M<4/`>C0m032`@30m87:`<;0m470`?R0k83d@go1?43dPL30`/3dP<[3I<4P`>b0k<3d`Oc
10000ol0000300006`000ol0000200e41n]411Oc4=<4/`>C0`/3/@AQ0n830`@;0`<3/0<Z1?l3lB7o
0n83]@?B12/9P`@[0m43T`?C1o<40003o`0000<0000K0003o`0000803D@7jd@45o<@d`Bc0i<32`>a
1643hP<310/30`>`0bX4o`?a8Ol3hP>e0m84:`V312/3d@>C0m<7l`@000?o00000`0001/000?o0000
0P0=A0O[A0@Gla3C1;<3T`<;0k44H@?R0`<42`<30k03:PCo0o4Qo`?R0kD3dP@[2H<4:`?A0i<3d`Oc
10000ol0000300006`000ol0000200Y42^]111Cc4m<7/`>C0m83n@Co0m43o`CR0m8^o`>a0ol3dPL;
0k832`CZ0i83:`>c1=<3l`@000?o00000`0001/00_l300Y42^]111Cc4m<7/`>C0m83n@Co0m43o`CR
0m8^o`>a0ol3dPL;0k832`CZ0i83:`>c1=<3l`<00_l500006`000ol0000200Y41^]2113c5m<:/`>C
0`/3hP[o198go`=b1>830`?o0i84l@=X0nX3/`CC0o<40003o`0000<0000K0003o`0000802T@6jd84
4?<Gd`Zc0i<32`?R2_l4TSOo0g84hP<30ol3TPCa0fP3jP>c1=<3l`@000?o00000`0001/000?o0000
0P0:A0K[@P@@laOC2[<3T`<;0n8:o`BB=ol3LPCR0`<3o`>B1?43J0?Z0k<4d`?c10000ol000030000
6`000ol0000200Y41^/n10gc6m<9/`BC0h<3:`?iB?l4l@=b2_l3dP>b0k<7d`@000?o00000`0001/0
00?o00000P0:A0K[?P@=la_C2K<4T`>30b/3nDSo1?43LP[o0m83/P>c1m<40003o`0000<0000K0003
o`0000802T@3jc/43O<Md`fc19<3P`<[0n84H4So0bT:o`?Z0h<3/`OC10000ol0000300006`000ol0
000200Y40n/k10gc7M<=/`BC0h<3:`?R1618o`<Y2_l3jP>30k<7d`@000?o00000`0000P00_l400;o
0`03o`D000?o00000P0:A0?[>`@=lagC3K<4T`>30b/3hPAPB?l3:@[o0nX3P`>c1m<40003o`0000<0
00070004o`00o`<00_l60003o`00008000?o00000P07A0K[>0@9lb7C3K<3T`B30b/32`?R12YEo`<3
0i<3/`OC10000ol00003000000<0ool00ol01@3o003o00/000?o00000P02o`<01d@6jcP42O<Qd`fc
0i<4P`<[0`/3hP@ZEOl30`>C0k<7d`<00_l500001`001?l00?l800?o1@000ol0000200M41^/h10Wc
8M<=/`>C18<3:`<;0n84:UGo0`<3T`>c1m<40003o`0000<000070004o`00o`P000?o00001@000ol0
000200M41^/a10[c9=<=/`>C0h<42`?o0n9Ho`BB0b/3T`>c1m<40003o`0000<0000800;o2@04o`@0
00?o00000P07A0K[<@@:lbCC3K<3T`>310/3o`?RF?l4TP<[0i<3/`OC10000ol0000300006`000ol0
000200M40n/a10[c0m<:/aOC3K<6T`<[12T3P@>0F?l40`<[0i<7/`?C10000ol0000300006`000ol0
000200M40n/a10[c0m<:/aOC3K<6T`<[12T3P@>0F?l40`<[0i<7/`?C10000ol0000300006`000ol0
000200M40n/a10[c0m<:/aOC3K<6T`<[12T3P@>0F?l40`<[0i<7/`?C10000ol0000300006`000ol0
000200M40n/W113c1=<32`>C9;<:T`>30b/4l5ko12X3jP>30i<4/`?C10000ol0000300006`000ol0
000200M40n/W113c1=<32`>C9;<:T`>30b/4l5ko12X3jP>30i<4/`?C10000ol0000300006`000ol0
000200M40n/P117c1]<4/`>30m83PbRC1X<32`@30h5Oo`<31R/4T`?C10000ol0000300006`02o`<0
1d@3jb044O<6d`Bc0h<3dP>3:9<6P`<;10<3PEoo0`<6:`BC0m<300;o1@0001/000?o00000P07A0?[
80@Al`KC1;<3P`?B0h<XT`J30`/40`>1Gol30`H[19<3d`@000?o00000`0001/000?o00000P07A1d4
5?<9d`Bc0h<3J0N32I<4P`?B0h<AT`J30nX4:V;o0k83J0>B18<3d`@000?o00000`0001/000?o0000
0P07A1d45?<9d`Bc0h<3J0N32I<4P`?B0h<AT`J30nX4:V;o0k83J0>B18<3d`@000?o00000`0001/0
00?o00000P07A1d45?<9d`Bc0h<3J0N32I<4P`?B0h<AT`J30nX4:V;o0k83J0>B18<3d`@000?o0000
0`0001/000?o00000P03A0C[5P@Gl`[C1k<30`=b0`/7:`>30b/4jP<30b/DP`<;0nQ/o`?a1?T3d`@0
00?o00000`0001/000?o00000P03A0C[5P@Gl`[C1k<30`=b0`/7:`>30b/4jP<30b/DP`<;0nQ/o`?a
1?T3d`@000?o00000`0001/000?o00000P03A0C[40@Jl`gC1k<3P`?o1n83j@H;10<3P@>a10/3j0d[
0`/3dVco0g84P`>c10000ol0000300006`000ol0000200=41>/@11[c3M<7/`>30ol7hP?Y1P/40`>1
0k442`?X3B/32`?BK?l3LPB30k<40003o`0000<0000K0003o`0000800d@4ja046_<=d`Nc0h<3o`OR
0nT62`@30h43/@@;0nP=:`<;0m9/o`=b18<3/`@000?o00000`0001/00_l300=41>/=11[c4=<3/`BC
0h<3:`<31?P3l0>a0`<4hP?i0m04hP>b0`/7:`<;0nY/o`?R0b/4T`>c0`02o`D0000K0003o`000080
0d@4j`d46_<@d`>c19<3P`<[0`<4n0?`0k430`CR0oT3d0CR0k832`L[0`/3jVco0n83:`BC0k<40003
o`0000<0000K0003o`0000800d@4j`d46_<@d`>c19<3P`<[0`<4n0?`0k430`CR0oT3d0CR0k832`L[
0`/3jVco0n83:`BC0k<40003o`0000<0000K0003o`0000800d@=11[c5=<3/`NC0b/3jPBb1_l3LPCa
1_l4n@?`0m830`OZ0`<3dFWo0h03:`BC0m<40003o`0000<0000K0003o`0000800d@=11[c5=<3/`NC
0b/3jPBb1_l3LPCa1_l4n@?`0m830`OZ0`<3dFWo0h03:`BC0m<40003o`0000<0000K0003o`000080
0d@:11[c5=<3/`ZC0b/3o`AP1_l3/17o0m43/PL30m9/o`?i0`<4T`?C10000ol0000300006`000ol0
000200=42P@JlaCC0k<:T`<[0ol4H0Ko0k0Ao`?A0k870`?BK?l3n@<319<3d`@000?o00000`0001/0
00?o00000P03A0X46_<Dd`>c2Y<3:`?o1606o`>`4Ol3d@>b1`<3dVco0oT30`BC0m<40003o`0000<0
000K0003o`0000800d@711gc5=<3/`NC0h<32`<3178Mo`=Q1;83hP>bKol3LPBc0m<40003o`0000<0
000K00;o0`03A0L47O<Dd`>c1i<3P`<;0`<4LQgo0f44/P?R0k9_o`=b1;<3d`<00_l500006`000ol0
000200=410@MlaCC0k<6T`B30nX3hP=b:?l3/P=bK?l3dP<[1;<3d`@000?o00000`0001/000?o0000
0P03A0@47O<Dd`>c1Y<4P`?Z0n83LRSo0k83LVco0m83:`Bc0m<40003o`0000<0000K0003o`000080
0d@411gc5=<3/`JC18<3jP?R0g8Xo`>b0g9/o`?B0b/4/`?C10000ol0000300006`000ol0000200=4
10@Jla?C1;<32`J312/32`>b:ol3j@?aK?l3hP>31;<3d`@000?o00000`0001/000?o00000P03A0@4
6_<Cd`Bc0`/6P`@[0`/3/R_o0nT3lFco0n83P`Bc0m<40003o`0000<0000K0003o`0000800d@411[c
4m<4/`<;1X<4:`<;0k8[o`?Y0o5/o`?R0h<4/`?C10000ol0000300006`000ol0000200=46_<:d`fc
19<32`?Z1b/3jP>b0nP[o`>1Kol3T`Bc0m<40003o`0000<0000K0003o`0000800d@Jl`[C3K<4T`<;
0nX7:`?Z0k83j2_o0h5_o`>C1;<3d`@000?o00000`0001/000?o00000P03A1[c1=<=/`JC18<3:`?Y
0nX4:@?R0bX^o`?`K?l3:`>c1m<40003o`0000<0000K00;o0`03A1[c1=<=/`JC18<3:`?Y0nX4:@?R
0bX^o`?`K?l3:`>c1m<300;o1@0001/000?o00000P03A1[c1=<=/`JC18<3:`?Y0nX4:@?R0bX^o`?`
K?l3:`>c1m<40003o`0000<0000K0003o`0000800d@7l`KC1o<3da2c2Y<4P`<[0m83LPCo0nT3lI[o
0n83T`>c1m<40003o`0000<0000K0003o`0000800d@7l`KC1o<3da2c2Y<4P`<[0m83LPCo0nT3lI[o
0n83T`>c1m<40003o`0000<0000K0003o`0000800d@:d`Nc0i<3:`NC1[<:T`>312/3:@?B2_l3n9[o
0b/3T`>c1m<40003o`0000<0000K0003o`0000800d@:d`Nc0i<3:`NC1[<:T`>312/3:@?B2_l3n9[o
0b/3T`>c1m<40003o`0000<0000K0003o`0000800d@:d`Nc0i<3:`NC1[<:T`>312/3:@?B2_l3n9[o
0b/3T`>c1m<40003o`0000<0000K0003o`0000800d@7d`Jc1i<3LPZ30h43:`B30b/70`?R0o6So`@;
0h<3T`>c1m<40003o`0000<0000D00;o1@000ol0000200=41m<6/`NC0g8:P`>10b/4P`<[1`<3hP?a
Xol42`>30i<3/`OC10000ol0000300004`001?l00?l40003o`0000800d@7d`Jc1i<3LPZ30h43:`B3
0b/70`?R0o6So`@;0h<3T`>c1m<40003o`0000<0000C0004o`00o`@00_l300>bf?l3P@?R12/3P`>C
0k<7d`<00_l500004`001?l00?l40003o`0000800k;Ho`>10n84:`>30i<3/`OC10000ol000030000
4`001?l00?l40003o`0000800d@7d`Jc1i<3LPZ30h43:`B30b/70`?R0o6So`@;0h<3T`>c1m<40003
o`0000<0000D00;o1@000ol0000200=41m<6/`NC0g8:P`>10b/4P`<[1`<3hP?aXol42`>30i<3/`OC
10000ol0000300006`000ol0000200=41m<6/`NC0g8:P`>10b/4P`<[1`<3hP?aXol42`>30i<3/`OC
10000ol0000300006`000ol0000200=42]<7/`>C0b/7T`Jc2Y<3P`@[0bT3dP[o0oRJo`<[0i<3/`OC
10000ol0000300006`000ol0000200=42]<7/`>C0b/7T`Jc2Y<3P`@[0bT3dP[o0oRJo`<[0i<3/`OC
10000ol0000300006`000ol0000200=42]<7/`>C0b/7T`Jc2Y<3P`@[0bT3dP[o0oRJo`<[0i<3/`OC
10000ol0000300006`000ol0000200=41o<6d`Oc0m<@/`ZC18<3:`?B0g84o`?Y0o6Jo`?R0i<3/`OC
10000ol0000300006`000ol0000200=41o<6d`Oc0m<@/`ZC18<3:`?B0g84o`?Y0o6Jo`?R0i<3/`OC
10000ol0000300006`02o`<00d@Jl`CC3K<6T`B30b/3j@?Z12T3hP<Z;_l3l6co0b/3/`OC0`02o`D0
000K0003o`0000800d@Jl`CC3K<6T`B30b/3j@?Z12T3hP<Z;_l3l6co0b/3/`OC10000ol000030000
6`000ol0000200=46_<4d`fc1Y<4P`<[0nT3jP@Y0n83:Rko0o1/o`<[0k<7d`@000?o00000`0001/0
00?o00000P03A1[c2]<=/`BC0`/3jPL[0nX3/P?X:ol3PFoo0i<4/`?C10000ol0000300006`000ol0
000200=46_<:d`fc19<32`?Z1b/3jP>b0nP[o`>1Kol3T`Bc0m<40003o`0000<0000K0003o`000080
0d@411[c4m<4/`<;1X<4:`<;0k8[o`?Y0o5/o`?R0h<4/`?C10000ol0000300006`000ol0000200=4
10@Jla?C1;<32`J312/32`>b:ol3j@?aK?l3hP>31;<3d`@000?o00000`0001/000?o00000P03A0@4
6_<Cd`Bc0`/6P`@[0`/3/R_o0nT3lFco0n83P`Bc0m<40003o`0000<0000K0003o`0000800d@411gc
5=<3/`JC18<3jP?R0g8Xo`>b0g9/o`?B0b/4/`?C10000ol0000300006`000ol0000200=410@MlaCC
0k<6T`B30nX3hP=b:?l3/P=bK?l3dP<[1;<3d`@000?o00000`0001/00_l300=410@MlaCC0k<6T`B3
0nX3hP=b:?l3/P=bK?l3dP<[1;<3d`<00_l500006`000ol0000200=41`@MlaCC0k<7T`>30`/30`Ab
7Ol3H@Bb0n83/Voo0g84/`?C10000ol0000300006`000ol0000200=41`@MlaCC0k<7T`>30`/30`Ab
7Ol3H@Bb0n83/Voo0g84/`?C10000ol0000300006`000ol0000200=42P@JlaCC0k<:T`<[0ol4H0Ko
0k0Ao`?A0k870`?BK?l3n@<319<3d`@000?o00000`0001/000?o00000P03A0X46_<Dd`>c2Y<3:`?o
1606o`>`4Ol3d@>b1`<3dVco0oT30`BC0m<40003o`0000<0000K0003o`0000800d@:11[c5=<3/`ZC
0b/3o`AP1_l3/17o0m43/PL30m9/o`?i0`<4T`?C10000ol0000300006`000ol0000200=43@@JlaCC
0k<7T`<[0nX4/PKo0g84l@Ko1?T3l0?B0`<7jP<30m5Yo`>00b/4T`?C10000ol0000300006`000ol0
000200=43@@JlaCC0k<7T`<[0nX4/PKo0g84l@Ko1?T3l0?B0`<7jP<30m5Yo`>00b/4T`?C10000ol0
000300006`000ol0000200=41>/=11[c4=<3/`BC0h<3:`<31?P3l0>a0`<4hP?i0m04hP>b0`/7:`<;
0nY/o`?R0b/4T`>c10000ol0000300006`02o`<00d@4j`d46_<@d`>c19<3P`<[0`<4n0?`0k430`CR
0oT3d0CR0k832`L[0`/3jVco0n83:`BC0k<300;o1@0001/000?o00000P03A0C[3@@Jla3C0k<4T`>3
0b/30`Ch0o03/@<31>83n@?@1>83/P<;1b/32`?ZK?l3hP<[19<3/`@000?o00000`0001/000?o0000
0P03A0C[40@Jl`gC1k<3P`?o1n83j@H;10<3P@>a10/3j0d[0`/3dVco0g84P`>c10000ol000030000
6`000ol0000200=41>/@11[c3M<7/`>30ol7hP?Y1P/40`>10k442`?X3B/32`?BK?l3LPB30k<40003
o`0000<0000K0003o`0000800d@4ja046_<=d`Nc0h<3o`OR0nT62`@30h43/@@;0nP=:`<;0m9/o`=b
18<3/`@000?o00000`0001/000?o00000P03A0C[5P@Gl`[C1k<30`=b0`/7:`>30b/4jP<30b/DP`<;
0nQ/o`?a1?T3d`@000?o00000`0001/000?o00000P03A0C[5P@Gl`[C1k<30`=b0`/7:`>30b/4jP<3
0b/DP`<;0nQ/o`?a1?T3d`@000?o00000`0001/000?o00000P07A1d45?<9d`Bc0h<3J0N32I<4P`?B
0h<AT`J30nX4:V;o0k83J0>B18<3d`@000?o00000`0001/000?o00000P07A1d45?<9d`Bc0h<3J0N3
2I<4P`?B0h<AT`J30nX4:V;o0k83J0>B18<3d`@000?o00000`0001/000?o00000P07A1d45?<9d`Bc
0h<3J0N32I<4P`?B0h<AT`J30nX4:V;o0k83J0>B18<3d`@000?o00000`0001/00_l300M40n/P117c
1]<4/`>30m83PbRC1X<32`@30h5Oo`<31R/4T`?C0`02o`D0000K0003o`0000801d@3jb044O<6d`Bc
0h<3dP>3:9<6P`<;10<3PEoo0`<6:`BC0m<40003o`0000<0000K0003o`0000801d@3jb044O<6d`Bc
0h<3dP>3:9<6P`<;10<3PEoo0`<6:`BC0m<40003o`0000<0000K0003o`0000801d@3jbL44?<4d`<;
0i<T/`ZC0h<3:`C`G_l4:P?Z0h<3T`Bc0m<40003o`0000<0000K0003o`0000801d@3jbL44?<4d`<;
0i<T/`ZC0h<3:`C`G_l4:P?Z0h<3T`Bc0m<40003o`0000<0000K0003o`0000801d@3jc442_<3d`Zc
5m<=/`JC0b/4:@>10h1Ho`@30b/3T`Nc0m<40003o`0000<0000K0003o`0000801d@3jc442_<3d`Zc
5m<=/`JC0b/4:@>10h1Ho`@30b/3T`Nc0m<40003o`0000<0000K0003o`0000801d@3jc442_<3d`Zc
5m<=/`JC0b/4:@>10h1Ho`@30b/3T`Nc0m<40003o`0000<0000800;o1002o`<00ol50003o`000080
1d@6jc442_<Td`fc0i<3P`@;0ol3hUSo1983:`>C0k<7d`@000?o00000`0000L000Co003o0`02o`H0
00?o00000P000ol0000200M41^/a10[c9=<=/`>C0h<42`?o0n9Ho`BB0b/3T`>c1m<40003o`0000<0
00070004o`00o`/000?o00000P02o`<01d@6jcP42O<Qd`fc0i<4P`<[0`/3hP@ZEOl30`>C0k<7d`<0
0_l500001`001?l00?l800?o1@000ol0000200M41^/h10Wc8M<=/`>C18<3:`<;0n84:UGo0`<3T`>c
1m<40003o`0000<000070004o`00o`P000?o00001@000ol0000200M41^/h10Wc8M<=/`>C18<3:`<;
0n84:UGo0`<3T`>c1m<40003o`0000<0000800;o2@04o`@000?o00000P0:A0?[>`@=lagC3K<4T`>3
0b/3hPAPB?l3:@[o0nX3P`>c1m<40003o`0000<0000K0003o`0000802T@3jc/43O<Md`fc19<3P`<[
0n84H4So0bT:o`?Z0h<3/`OC10000ol0000300006`000ol0000200Y40n/k10gc7M<=/`BC0h<3:`?R
1618o`<Y2_l3jP>30k<7d`@000?o00000`0001/000?o00000P0:A0K[?P@=la_C2K<4T`>30b/3nDSo
1?43LP[o0m83/P>c1m<40003o`0000<0000K0003o`0000802T@6jch43O<Kd`Vc19<3P`<[0oU8o`Ca
0g8:o`?B0k83/`OC10000ol0000300006`000ol0000200Y41^]2113c5m<:/`>C0`/3hP[o198go`=b
1>830`?o0i84l@=X0nX3/`CC0o<40003o`0000<0000K0003o`0000802T@6jd844?<Gd`Zc0i<32`?R
2_l4TSOo0g84hP<30ol3TPCa0fP3jP>c1=<3l`@000?o00000`0001/00_l300Y41^]2113c5m<:/`>C
0`/3hP[o198go`=b1>830`?o0i84l@=X0nX3/`CC0o<300;o1@0001/000?o00000P0:A0[[@@@Dla?C
1k<3T`?B0oT4o`?A0ol4hP?B;_l3/@?o0m872`>b0`/4jP>B0b/3/`CC0o<40003o`0000<0000K0003
o`0000802T@:jd445?<Cd`Nc0i<3dP?i1?l3d@?o1>83dRko0k43o`?B1`/3/P<;1>X3TP<[0k<4d`?c
10000ol0000300006`000ol0000200e41n]411Oc4=<4/`>C0`/3/@AQ0n830`@;0`<3/0<Z1?l3lB7o
0n83]@?B12/9P`@[0m43T`?C1o<40003o`0000<0000K0003o`0000803D@7jd@45o<@d`Bc0i<32`>a
1643hP<310/30`>`0bX4o`?a8Ol3hP>e0m84:`V312/3d@>C0m<7l`@000?o00000`0001/000?o0000
0P0=A0O[A0@Gla3C1;<3T`<;0k44H@?R0`<42`<30k03:PCo0o4Qo`?R0kD3dP@[2H<4:`?A0i<3d`Oc
10000ol0000300006`000ol0000200e42^]411_c2M<4/`>C0m032`@30m87:`<;0m470`?R0k83d@go
1?43dPL30`/3dP<[3I<4P`>b0k<3d`Oc10000ol0000300006`000ol0000200e42^]411_c2M<4/`>C
0m032`@30m87:`<;0m470`?R0k83d@go1?43dPL30`/3dP<[3I<4P`>b0k<3d`Oc10000ol000030000
6`000ol0000200e42^]411_c2M<4/`>C0m032`@30m87:`<;0m470`?R0k83d@go1?43dPL30`/3dP<[
3I<4P`>b0k<3d`Oc10000ol0000300006`000ol0000200e42^]811[c2]<3/`JC18<3:`f30b/42`?Z
0k8Do`?B0nX4:`J30i<=/`NC0m<7l`<410000ol0000300006`02o`<03D@:jdP46_<:d`>c1Y<4P`<[
3H<3:`@;0nX3/QCo0m83jP@[1X<3T`fc1i<3d`Oc0`@300;o1@0001/000?o00000P0@A0[[B0@Ml`OC
3K<=T`>312/3jQOo0g832`N30i<@/`OC2_<310@000?o00000`0001/000?o00000P0@A0[[B0@Ml`OC
3K<=T`>312/3jQOo0g832`N30i<@/`OC2_<310@000?o00000`0001/000?o00000P0@A0[[B0@Ml`OC
3K<=T`>312/3jQOo0g832`N30i<@/`OC2_<310@000?o00000`0001/000?o00000P0@A0[[B`@Nl`WC
3[<9T`B30n8Go`?a0`/4P`>C2[<@d`[c0`@40003o`0000<0000K0003o`00008044@:jd/47_<9d`jc
2I<4P`?R5ol3l@<;18<3T`Zc4=<:l`<410000ol0000300006`000ol0000201143N]<123c1m<=/`JC
18<32`>B5?l3l@<;1i<3/a3C3O<710@000?o00000`0001/000?o00000P0@A0g[C0@Pl`OC3K<6T`B3
0`/3TQCo0o432`NC0k<@d`gc1`@40003o`0000<0000K0003o`00008044@=jd`48?<7d`fc1Y<4P`<;
0i8Do`?a0`/7T`>c4=<=l`L410000ol0000300006`02o`<054@=jdP48o<:d`Zc0i<4P`<;4ol4P@?@
0kD4T`>c4=<@l`L40`02o`D0000K0003o`00008054@=jdP48o<:d`Zc0i<4P`<;4ol4P@?@0kD4T`>c
4=<@l`L410000ol0000300006`000ol0000201A43N]812?c2]<:/`>C18<32a?o1843d0>e19<3/a3C
4?<710@000?o00000`0001/000?o00000P0DA0g[B`@Tl`gC1[<4P`>00ol3:P[o0nP4d0?a0`/4T`>c
3M<@l`X410000ol0000300006`000ol0000201A43N];12Cc3M<6/`B30h03o`<Z2_l3j0C@0o432`BC
0k<=da3c2P@40003o`0000<0000K0003o`00008054@@jd/49?<=d`>c19<3:`<Z0`<4dPKo0h44jP<;
0i84/`gC4?<=10@000?o00000`0001/000?o00000P0DA13[B`@Tl`gC0k<4T`<[0bX30`CB1_l3P@CZ
0`/3TPBc3M<@l`d410000ol0000300006`000ol0000201A44>];12Cc3M<3/`BC0b/3:P<31=86o`>1
1>X32`>B1;<=da3c3@@40003o`0000<0000K0003o`0000805d@@jd/49?<=d`Bc0i<3:`<;1=83P@?o
0bX42`>30i<4/`WC5?<=10@000?o00000`0001/000?o00000P0GA13[B`@Tl`gC1;<3T`<[0`/4dP>1
0ol3:P@;0h<3T`Bc2M<Dl`d410000ol0000300006`02o`<05d@@jd/49?<=d`Bc0i<3:`<;1=83P@?o
0bX42`>30i<4/`WC5?<=10<00_l500006`000ol0000201M44n]<123c4M<3/`>C0h<4:`?R0bT30`@[
0i<3/`[C5?<@10@000?o00000`0001/000?o00000P0GA1?[C0@Pla7C0k<3T`>312/3hP<Y0`<4:`>C
0k<:daCc40@40003o`0000<0000K0003o`0000806T@Djd/48O<=d`>c1Y<4P`?Z0bX30`@[0i<3/`OC
5o<@10@000?o00000`0001/000?o00000P0JA1C[B`@Ql`gC0k<6T`B30nX3:P<312/3T`>c1m<Gla04
10000ol0000300006`000ol0000201Y45>];127c3M<3/`JC18<3jP<Z0`<4:`>C0k<7daOc40@40003
o`0000<0000K0003o`0000806T@Gjd/48O<=d`>c0i<4P`?R0k83j0Ca0i<3/`CC5_<D10@000?o0000
0`0001/000?o00000P0JA1O[B`@Ql`gC0k<3T`B30n83/P?X1?43T`>c1=<Fla@410000ol000030000
4`03o`D000?o00000P0JA1[[C`@Jl`gC0k<3T`@[0n83:`<;1nX3/aOc50@3j`@000?o00000`0001@0
00?o000010000ol0000201Y46^]?11[c3M<3/`>C12/3hP<[0`/7jP>c5o<D10?[10000ol000030000
50000ol0000400;o0`0JA1[[C`@Jl`gC0k<3T`@[0n83:`<;1nX3/aOc50@3j`<00_l5000050000ol0
00040003o`000?/000?o00000`0001@000?o000010000ol000020003o`0002h000?o0000;P000ol0
000^0003o`0002h000?o0000;P001Ol0003o00D0000C00;o1P000ol000020003o`0000H000?o0000
1`000ol000070003o`0000L000?o00001`000ol000060003o`0000L000?o00001`000ol000070003
o`0000L000?o00001P000ol000070003o`0000L000?o00001`000ol000070003o`0000H000?o0000
1`000ol000070003o`0000L000?o00001`000ol000060003o`0000L000?o00001`000ol000070003
o`0000L000Go0000o`0500006`3oo`D0003o0200003o0200003o0200003o0200003o0200003o0200
0000\
\>"],
  ImageRangeCache->{{{0, 286}, {228.562, 0}} -> {-2.3275, -1.22575, 0.0102076,
   0.0102076}}]
}, Closed]],

Cell[TextData[{
  "See also ",
  StyleBox["ComposeList", "Input"],
  " "
}], "SeeAlso"]
}, Closed]],

Cell[CellGroupData[{

Cell["Other High-Level Programming Functions", "Subsection"],

Cell[CellGroupData[{

Cell["Thread", "Subsubsection"],

Cell[TextData[{
  StyleBox["Thread", "Input"],
  " constructs lists by collecting \[OpenCurlyDoubleQuote]parallel\
\[CloseCurlyDoubleQuote] elements from a series of lists, then giving each \
group of elements a specified head."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Thread[f[{a, b}, {1, 2}, {A, B}]]\)], "Input"],

Cell[OutputFormData["\<\
{f[a, 1, A], f[b, 2, B]}\
\>", 
"\<\
{f[a, 1, A], f[b, 2, B]}\
\>"], "Output"]
}, Closed]],

Cell[TextData[{
  "If one of the elements in the series of lists is an atom, the atom appears \
in each expression created by ",
  StyleBox["Thread", "Input"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Thread[f[{a, b}, 1, {A, B}]]\)], "Input"],

Cell[OutputFormData["\<\
{f[a, 1, A], f[b, 1, B]}\
\>", 
"\<\
{f[a, 1, A], f[b, 1, B]}\
\>"], "Output"]
}, Closed]],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " effectively uses ",
  StyleBox["Thread", "Input"],
  " when performing list arithmetic, such as adding two lists or adding a \
scalar to each element of a list."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \({a, b, c} + E + {1, 2, 3}\)], "Input"],

Cell[BoxData[
    \({1 + a + E, 2 + b + E, 3 + c + E}\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Thread[Plus[{a, b, c}, E, {1, 2, 3}]]\)], "Input"],

Cell[BoxData[
    \({1 + a + E, 2 + b + E, 3 + c + E}\)], "Output"]
}, Closed]],

Cell[TextData[{
  StyleBox["Thread", "Input"],
  " is useful in constructing tables of rules or equations, given a list of \
names and a list of values."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Thread[{a, b, c} \[Rule] {1, 2, 3}]\)], "Input"],

Cell[BoxData[
    \({a \[Rule] 1, b \[Rule] 2, c \[Rule] 3}\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Thread[{a, b, c} == {1, 2, 3}]\)], "Input"],

Cell[BoxData[
    \({a == 1, b == 2, c == 3}\)], "Output"]
}, Closed]],

Cell[TextData[{
  StyleBox["Thread", "Input"],
  " duplicates ",
  StyleBox["Transpose", "Input"],
  " if given a list of lists with equal lengths."
}], "Text"],

Cell[CellGroupData[{

Cell["Thread[{{a, b, c}, {1, 2, 3}}]", "Input"],

Cell[BoxData[
    \({{a, 1}, {b, 2}, {c, 3}}\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell["Transpose[{{a, b, c}, {1, 2, 3}}]", "Input"],

Cell[BoxData[
    \({{a, 1}, {b, 2}, {c, 3}}\)], "Output"]
}, Closed]],

Cell[TextData[{
  "See also ",
  StyleBox["MapThread", "Input"],
  ", ",
  StyleBox["Inner", "Input"],
  ", ",
  StyleBox["Listable", "Input"],
  " "
}], "SeeAlso"]
}, Closed]],

Cell[CellGroupData[{

Cell["Through", "Subsubsection"],

Cell[TextData[{
  "Where ",
  StyleBox["Map", "Input"],
  " applies a function to a list of arguments, ",
  StyleBox["Through", "Input"],
  " applies a list of functions to an argument."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Through[{Sin, Cos, Log, Exp}[x]]\)], "Input"],

Cell[BoxData[
    \({Sin[x], Cos[x], Log[x], E\^x}\)], "Output"]
}, Closed]],

Cell["Here is a list of complex numbers.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(fdata = Fourier[Table[Random[], {10}]]\)], "Input"],

Cell[BoxData[
    \({\(1.42357436591955437`\ \) + 0.`\ I, 
      \(0.0633061744301583484`\ \) - 0.284124925215172474`\ I, 
      \(0.239571683848042393`\ \) + 0.0673160947059901992`\ I, 
      \(-0.47187232001212056`\) + 0.126597788914961562`\ I, 
      \(0.0515298024393331477`\ \) + 0.344632280354961251`\ I, 
      \(-0.176977263405816875`\) + 0.`\ I, 
      \(0.0515298024393331477`\ \) - 0.344632280354961251`\ I, 
      \(-0.47187232001212056`\) - 0.126597788914961562`\ I, 
      \(0.239571683848042393`\ \) - 0.0673160947059901992`\ I, 
      \(0.0633061744301583484`\ \) + 0.284124925215172474`\ I}\)], "Output"]
}, Closed]],

Cell[TextData[{
  "In order to plot the real parts of the data against the imaginary parts, \
we need to convert the complex numbers into a list of real-imaginary pairs. \
Using ",
  StyleBox["Through", "Input"],
  ", we can create a list containing a list of all the real parts followed by \
a list of all the imaginary parts."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(fpairs = Through[{Re, Im}[fdata]]\)], "Input"],

Cell[BoxData[
    \({{1.42357436591955437`, 0.0633061744301583484`, 0.239571683848042393`, 
        \(-0.47187232001212056`\), 0.0515298024393331477`, 
        \(-0.176977263405816875`\), 0.0515298024393331477`, 
        \(-0.47187232001212056`\), 0.239571683848042393`, 
        0.0633061744301583484`}, {0.`, \(-0.284124925215172474`\), 
        0.0673160947059901992`, 0.126597788914961562`, 0.344632280354961251`, 
        0.`, \(-0.344632280354961251`\), \(-0.126597788914961562`\), 
        \(-0.0673160947059901992`\), 0.284124925215172474`}}\)], "Output"]
}, Closed]],

Cell[TextData[{
  "To convert the previous list into a list of real-imaginary pairs, we use ",
  
  StyleBox["Transpose", "Input"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(fpairs = Transpose[fpairs]\)], "Input"],

Cell[BoxData[
    \({{1.42357436591955437`, 0.`}, {0.0633061744301583484`, 
        \(-0.284124925215172474`\)}, {0.239571683848042393`, 
        0.0673160947059901992`}, {\(-0.47187232001212056`\), 
        0.126597788914961562`}, {0.0515298024393331477`, 
        0.344632280354961251`}, {\(-0.176977263405816875`\), 0.`}, {
        0.0515298024393331477`, \(-0.344632280354961251`\)}, {
        \(-0.47187232001212056`\), \(-0.126597788914961562`\)}, {
        0.239571683848042393`, \(-0.0673160947059901992`\)}, {
        0.0633061744301583484`, 0.284124925215172474`}}\)], "Output"]
}, Closed]],

Cell["\<\
Here is a plot of the real parts versus the imaginary parts of the \
transformed data.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(ListPlot[fpairs, PlotStyle \[Rule] PointSize[0.02]]; \)\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.260905 0.502457 0.309017 0.853959 [
[.00968 .29652 -12 -9 ]
[.00968 .29652 12 0 ]
[.13529 .29652 -15 -9 ]
[.13529 .29652 15 0 ]
[.38652 .29652 -12 -9 ]
[.38652 .29652 12 0 ]
[.51213 .29652 -9 -9 ]
[.51213 .29652 9 0 ]
[.63775 .29652 -12 -9 ]
[.63775 .29652 12 0 ]
[.76336 .29652 -3 -9 ]
[.76336 .29652 3 0 ]
[.88898 .29652 -12 -9 ]
[.88898 .29652 12 0 ]
[.24841 .05283 -24 -4.5 ]
[.24841 .05283 0 4.5 ]
[.24841 .13823 -24 -4.5 ]
[.24841 .13823 0 4.5 ]
[.24841 .22362 -24 -4.5 ]
[.24841 .22362 0 4.5 ]
[.24841 .39441 -18 -4.5 ]
[.24841 .39441 0 4.5 ]
[.24841 .47981 -18 -4.5 ]
[.24841 .47981 0 4.5 ]
[.24841 .5652 -18 -4.5 ]
[.24841 .5652 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.00968 .30902 m
.00968 .31527 L
s
[(-0.5)] .00968 .29652 0 1 Mshowa
.13529 .30902 m
.13529 .31527 L
s
[(-0.25)] .13529 .29652 0 1 Mshowa
.38652 .30902 m
.38652 .31527 L
s
[(0.25)] .38652 .29652 0 1 Mshowa
.51213 .30902 m
.51213 .31527 L
s
[(0.5)] .51213 .29652 0 1 Mshowa
.63775 .30902 m
.63775 .31527 L
s
[(0.75)] .63775 .29652 0 1 Mshowa
.76336 .30902 m
.76336 .31527 L
s
[(1)] .76336 .29652 0 1 Mshowa
.88898 .30902 m
.88898 .31527 L
s
[(1.25)] .88898 .29652 0 1 Mshowa
.125 Mabswid
.0348 .30902 m
.0348 .31277 L
s
.05992 .30902 m
.05992 .31277 L
s
.08505 .30902 m
.08505 .31277 L
s
.11017 .30902 m
.11017 .31277 L
s
.16041 .30902 m
.16041 .31277 L
s
.18554 .30902 m
.18554 .31277 L
s
.21066 .30902 m
.21066 .31277 L
s
.23578 .30902 m
.23578 .31277 L
s
.28603 .30902 m
.28603 .31277 L
s
.31115 .30902 m
.31115 .31277 L
s
.33627 .30902 m
.33627 .31277 L
s
.3614 .30902 m
.3614 .31277 L
s
.41164 .30902 m
.41164 .31277 L
s
.43677 .30902 m
.43677 .31277 L
s
.46189 .30902 m
.46189 .31277 L
s
.48701 .30902 m
.48701 .31277 L
s
.53726 .30902 m
.53726 .31277 L
s
.56238 .30902 m
.56238 .31277 L
s
.5875 .30902 m
.5875 .31277 L
s
.61263 .30902 m
.61263 .31277 L
s
.66287 .30902 m
.66287 .31277 L
s
.68799 .30902 m
.68799 .31277 L
s
.71312 .30902 m
.71312 .31277 L
s
.73824 .30902 m
.73824 .31277 L
s
.78849 .30902 m
.78849 .31277 L
s
.81361 .30902 m
.81361 .31277 L
s
.83873 .30902 m
.83873 .31277 L
s
.86385 .30902 m
.86385 .31277 L
s
.9141 .30902 m
.9141 .31277 L
s
.93922 .30902 m
.93922 .31277 L
s
.96435 .30902 m
.96435 .31277 L
s
.98947 .30902 m
.98947 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.26091 .05283 m
.26716 .05283 L
s
[(-0.3)] .24841 .05283 1 0 Mshowa
.26091 .13823 m
.26716 .13823 L
s
[(-0.2)] .24841 .13823 1 0 Mshowa
.26091 .22362 m
.26716 .22362 L
s
[(-0.1)] .24841 .22362 1 0 Mshowa
.26091 .39441 m
.26716 .39441 L
s
[(0.1)] .24841 .39441 1 0 Mshowa
.26091 .47981 m
.26716 .47981 L
s
[(0.2)] .24841 .47981 1 0 Mshowa
.26091 .5652 m
.26716 .5652 L
s
[(0.3)] .24841 .5652 1 0 Mshowa
.125 Mabswid
.26091 .06991 m
.26466 .06991 L
s
.26091 .08699 m
.26466 .08699 L
s
.26091 .10407 m
.26466 .10407 L
s
.26091 .12115 m
.26466 .12115 L
s
.26091 .1553 m
.26466 .1553 L
s
.26091 .17238 m
.26466 .17238 L
s
.26091 .18946 m
.26466 .18946 L
s
.26091 .20654 m
.26466 .20654 L
s
.26091 .2407 m
.26466 .2407 L
s
.26091 .25778 m
.26466 .25778 L
s
.26091 .27486 m
.26466 .27486 L
s
.26091 .29194 m
.26466 .29194 L
s
.26091 .3261 m
.26466 .3261 L
s
.26091 .34318 m
.26466 .34318 L
s
.26091 .36025 m
.26466 .36025 L
s
.26091 .37733 m
.26466 .37733 L
s
.26091 .41149 m
.26466 .41149 L
s
.26091 .42857 m
.26466 .42857 L
s
.26091 .44565 m
.26466 .44565 L
s
.26091 .46273 m
.26466 .46273 L
s
.26091 .49689 m
.26466 .49689 L
s
.26091 .51397 m
.26466 .51397 L
s
.26091 .53105 m
.26466 .53105 L
s
.26091 .54813 m
.26466 .54813 L
s
.26091 .03575 m
.26466 .03575 L
s
.26091 .01867 m
.26466 .01867 L
s
.26091 .00159 m
.26466 .00159 L
s
.26091 .58228 m
.26466 .58228 L
s
.26091 .59936 m
.26466 .59936 L
s
.26091 .61644 m
.26466 .61644 L
s
.25 Mabswid
.26091 0 m
.26091 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.02 w
.97619 .30902 Mdot
.29271 .06639 Mdot
.38128 .3665 Mdot
.02381 .41713 Mdot
.2868 .60332 Mdot
.17198 .30902 Mdot
.2868 .01472 Mdot
.02381 .20091 Mdot
.38128 .25153 Mdot
.29271 .55165 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{286, 176.688},
  ImageMargins->{{35, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004N0000/0P10`4000010?ooobl_;oooZZVYZNSX
j?oo05FZZZZZZ_W0RS/k>gYjN[Vi^OShn03ooeGooj[ooonI<c<c<fi^KZf][Nc/k02ZoeFZojZZoonZ
oclo?ginO[fm_Oclo5D00:X00?l00?l0VCLg=g9bL[6a/O3`l03o05Go0:[o00<30d92@X61PL30`000
EED0EJX0EOl0ELbIoc/k>gIfM[Fe]OCdm03oEEGoEJ[oE@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0Z/`c
<clo?gYjN[Vi^OShn03oZUGoZZ[oZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`<30d92@WinO[fm_Ocl
o03ooeGooj[oo`l?3di>CXf=SLc<c01E05EE0:YE0?mE00L71dI6AX61PL30`000EED00:X00?l001<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@/;2dY:BXF5QLC4a000ZUD0EJX0EOl0EALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZPl?3di>CXV9RLS8b000oeD0ZZX0Z_l0ZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEoa<C
4e9BDXf=SLc<c01E05D0ojX0ool0oalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ01LG5eIFEY6ATM3@d01E
EEEE0:YE0?mE02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZEA/K6eYJFYFEUMCDe01EZUEEEJYEEOmEEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZQlO7eiNGYVIVMSHf01EoeEEZZYEZ_mEZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZob<S8f9RHYfMWMcLg02Z05EEojYEoomEobl_;fi^KZf][Nc/k03o05Go0:[o0=gW1RLW
9fIVIZ6QXN3Ph02ZEEFZ0:ZZ0?nZ03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooEB/[:fYZJZFUYNCTi02Z
ZUFZEJZZEOnZECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l07`000?l07`00054000?o0000bP000540
0_o;0000D@000ol0003:0000D@000ol0000300?oa000054000?o00000P05ol<0001A0003o`000080
1Oo30000D@02o`<01Oo30000D@000ol0000300?oa000054000?o0000bP00054000?o0000bP000540
0_o;0000D@000ol0003:0000D@000ol0003:0000?@02o`@00_l300?o1P000ol0003:0000?0001?l0
0?l300;o1P000ol000030003o`000<X0000f00Go00D0o`00o`0;0003o`0000<00_o;0000?0001?l0
0?l900;o1P000ol0003:0000?0001?l00?l;0003o`0000<000?o00001003ol<0000m00;o2@03o`H0
00?o00000`05ol80001A0003o`0000<01Oo20000D@02o`@01Oo20000D@000ol0000400?o``000540
00?o0000bP00054000?o0000bP0005400_o;0000D@000ol0003:0000D@000ol0003:0000D@000ol0
003:0000D@000ol0003:0000D@02ol/0001A0003o`000<X0001A0003o`000<X0001A0003o`000<X0
001A0003o`000<X0001A00;ob`00054000?o0000bP00054000?o0000bP0003d00_l400;o0`04o`D0
00?o0000bP0003`000Co003o0`02o`@000?o00001@000ol0003:0000=P05o`050?l00?l02P000ol0
000400;ob`0003`000Co003o2`000ol000030003o`000<X0000l0004o`00o`P000Co003o1@000ol0
003:0000?@02o`X00_l60003o`000<X0001A00;ob`00054000?o0000bP00054000?o0000bP000540
00?o0000bP00054000?o0000bP0005400_o;0000D@000ol0003:0000D@000ol0003:0000D@000ol0
003:0000D@000ol0003:0000D@02ol/0000>00?o@0000ol0003:00003@05ocl000?o0000bP0000d0
1Olo0003o`000<X0000=00Go?`02ol/0000>00?o@0000ol0003:0000D@000ol0003:0000?@02o`@0
0_l300?o1P000ol0003:0000?0001?l00?l300;o10000ol000050003o`000<X0000f00Go00D0o`00
o`090003o`0000D00_o;0000?0001?l00?l90003o`0000D000?o0000bP0003`000Co003o2@000ol0
00050003o`000<X0000m00;o2@02o`L000?o0000bP00054000?o0000bP0005400_o;0000D@000ol0
000M00?oZP00054000?o00007005ojT0001A0003o`0001`01OnY0000D@000ol0000L00GoZ@000540
0_lN00?oZP00054000?o0000bP00054000?o0000bP0000P00_l400;o0`03oa400_l400;o0`04o`80
0olF0003o`0001D00_l400;o0`04o`800olB00;o1002o`<00olB00;o1002o`@000?o00000P03oaH0
0olG00?o1002o`<01?l200?o5P0000L000Co003o0`02o`H000?o00003@001?l00?l300;o10000ol0
00050003o`0001<00_lE0004o`00o`<00_l40003o`0000D000?o00003P001?l00?l300;o1P000ol0
000>0004o`00o`<00_l40003o`0000D000?o000050000ol0000G0003o`0000<00_l40003o`0000D0
00?o00004`0000030?oo00?o00D0o`00o`0;0003o`0000L01Ol01@3o003o00X000?o000010000ol0
000C0003o`0001@000Co003o2P000ol000040003o`0000h000Co003o2`000ol0000>0004o`00o`X0
00?o000010000ol0000D0003o`0001L000?o00002P000ol000040003o`0001<000070004o`00o`P0
0ol@0004o`00o`/000?o00000olF0003o`0001@000Co003o2`000ol00003oa4000Co003o2003oa40
00Co003o2P001?l00003oaL000?o00005`000ol0000;0003o`0000?o5P0000L000Co003o20000ol0
000@0004o`00o`P000Co003o0P000ol0000F0003o`0001@000Co003o20001?l00?l20003o`000140
00Co003o20000ol0000A0004o`00o`/000Co003o6@000ol0000G0003o`0000P000Co003o0P000ol0
000F00002002o`T01?l@00;o2P02o`<01?lE0003o`0001D00_l:00;o0`04oa400_l900Co4@02o`T0
1?l200Co5@02oaP00_l;00;o0`04oaD0001A00;ob`00054000?o0000bP00054000?o0000bP0003L0
0olG0003o`000<400ol60000=P05oaH000?o0000`005o`D000090?oo5_l000`000?o00000`000ol0
00040003o`0000@000?o000010000ol000040003o`0000@01_l00`3o00050003o`0000@000?o0000
10000ol000040003o`0000@000?o000010000ol000030003o`0000@000?o000010000ol000040003
o`0000@000?o000010000ol000040003o`0000@000?o000010000ol000040003o`0000@000?o0000
10000ol000040003o`0000<000?o000010000ol000040003o`0000@000?o000010000ol000040003
o`0000@000?o000010000ol000040003o`0000@000?o000010000ol0000400Ko00<0o`000P0003L0
0olG0003o`000<400ol60000D@000ol0003:0000D@02ol/0001A0003o`000<X0001A0003o`000<X0
001A0003o`000<X0001A0003o`000<X0001A00;ob`00054000?o0000bP00054000?o0000bP000540
00?o0000bP00054000?o0000bP0005400_lN00?oZP00054000?o00007005ojT0001A0003o`0001`0
1OnY0000D@000ol0000L00GoZ@0005400_lN00?oZP00054000?o0000bP00054000?o0000bP0003d0
0_l400;o0`03o`H000?o0000bP0003`000Co003o0`02o`@000?o00001@000ol0003:0000?0001?l0
0?l90003o`0000D00_o;0000?0001?l00?l90003o`0000D000?o0000bP0003`000Co003o2@000ol0
00050003o`000<X0000m00;o2@02o`L000?o0000bP00054000?o0000bP0000h00om000;ob`0000d0
1Olo0003o`000<X0000=00Go?`000ol0003:00003@05ocl000?o0000bP0000h00om00003o`000<X0
001A00;ob`00054000?o0000bP00054000?o0000bP00054000?o0000bP0005400_o;0000D@000ol0
003:0000D@000ol0003:0000D@000ol0003:0000D@000ol0003:0000D@02ol/0001A0003o`000<X0
001A0003o`000<X0000m00;o1002o`<01?l50003o`000<X0000l0004o`00o`<00_l40003o`0000D0
00?o0000bP0003`000Co003o2P000ol0000400;ob`0003`000Co003o2`000ol000030003o`000<X0
000l0004o`00o`P000Co003o1@000ol0003:0000?@02o`X00_l60003o`000<X0001A00;ob`000540
00?o0000bP00054000?o0000bP00054000?o0000bP00054000?o0000bP0005400_o;0000D@000ol0
003:0000D@000ol0003:0000D@000ol0003:0000D@000ol0003:0000D@02ol/0001A0003o`000<X0
001A0003o`000<X0001A0003o`000<X0001A0003o`0000@00oo30000D@02o`@01Oo20000D@000ol0
000300Go`P0003d00_l400;o0`03o`H000?o00000`05ol80000l0004o`00o`<00_l60003o`0000<0
00?o00001003ol<0000l0004o`00o`/000?o00000`02ol/0000l0004o`00o`T00_l60003o`000<X0
000l0004o`00o`/000?o00000`000ol0003:0000?@02o`T00ol60003o`000<X0001A0003o`000<X0
001A00;ob`00054000?o0000bP00054000?o0000bP00054000?o0000bP00054000?o00000`03ol@0
001A00;o0`05ol<0001A0003o`0000801Oo30000D@000ol0000200Go``00054000?o00000`03ol@0
001A00;ob`00054000?o0000bP000?l07`000?l07`000001\
\>"],
  ImageRangeCache->{{{0, 285}, {175.688, 0}} -> {-0.586639, -0.373159, 
  0.00721969, 0.00424796}}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Outer", "Subsubsection"],

Cell[TextData[{
  StyleBox["Outer[", "Input"],
  StyleBox["head",
    FontSlant->"Italic"],
  StyleBox[", ", "Input"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["list",
            FontSlant->"Italic"], "1"], TraditionalForm]]],
  StyleBox[", ", "Input"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["list",
            FontSlant->"Italic"], "2"], TraditionalForm]]],
  StyleBox[",", "Input"],
  " \[Ellipsis]",
  StyleBox["]", "Input"],
  " constructs lists of all possible combinations of elements from more than \
one list, even if they have unequal lengths, then applies the specified head \
to each of the lists."
}], "Text"],

Cell[TextData[{
  "The following diagram illustrates what happens when we enter ",
  StyleBox["Outer[List,", "Input"],
  " ",
  StyleBox["{a,", "Input"],
  " ",
  StyleBox["b},", "Input"],
  " ",
  StyleBox["{c,", "Input"],
  " ",
  StyleBox["d,", "Input"],
  " ",
  StyleBox["e},", "Input"],
  " ",
  StyleBox["{f,", "Input"],
  " ",
  StyleBox["g}]", "Input"],
  ". ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " constructs triples created by following each of the downward paths to the \
bottom of the diagram, then applies the head ",
  StyleBox["List", "Input"],
  " to each of the triples."
}], "Text"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 2 
MathPictureStart
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.952381 1.95238 0.952381 [
[ 0 0 0 0 ]
[ 1 2 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
0 g
p
P
0 0 m
1 0 L
1 2 L
0 2 L
closepath
clip
newpath
% Start of user PostScript
/mathtops {
gsave
MBeginOrig
moveto
MEndOrig
currentpoint
grestore
} bind def
/MAtocoords {
mathtops 4 2 roll mathtops
4 copy pop pop
3 -1 roll sub
/arry exch def
exch sub
/arrx exch def
arrx dup mul
arry dup mul
add sqrt
/arrl exch def
translate
} bind def
/MAarrowhead1 {
gsave
MAtocoords
[ arrx arrl div
arry arrl div
-1 arry mul arrl div
arrx arrl div
0 0 ]
concat
-0.05 0.0125 moveto 0 0 lineto -0.05 -0.0125 lineto stroke
grestore
} def
% End of user PostScript
p
p
/Courier-Bold findfont 12 scalefont setfont
[(a)] .02381 1.95238 0 0 Mshowa
P
p
/Courier-Bold findfont 12 scalefont setfont
[(b)] .97619 1.95238 0 0 Mshowa
P
p
/Courier-Bold findfont 12 scalefont setfont
[(c)] .02381 1 0 0 Mshowa
P
p
/Courier-Bold findfont 12 scalefont setfont
[(d)] .5 1 0 0 Mshowa
P
p
/Courier-Bold findfont 12 scalefont setfont
[(e)] .97619 1 0 0 Mshowa
P
p
/Courier-Bold findfont 12 scalefont setfont
[(f)] .02381 .04762 0 0 Mshowa
P
p
/Courier-Bold findfont 12 scalefont setfont
[(g)] .97619 .04762 0 0 Mshowa
P
p
.004 w
.02381 1.90476 m
.02381 1.04762 L
s
% Start of user PostScript
0 -0.05 0 -0.95 MAarrowhead1
% End of user PostScript
P
p
.004 w
.03333 1.90476 m
.49048 1.04762 L
s
% Start of user PostScript
0.01 -0.05 0.49 -0.95 MAarrowhead1
% End of user PostScript
P
p
.004 w
.04286 1.90476 m
.96667 1.04762 L
s
% Start of user PostScript
0.02 -0.05 0.99 -0.95 MAarrowhead1
% End of user PostScript
P
p
.004 w
.95714 1.90476 m
.04286 1.04762 L
s
% Start of user PostScript
0.98 -0.05 0.02 -0.95 MAarrowhead1
% End of user PostScript
P
p
.004 w
.96667 1.90476 m
.50952 1.04762 L
s
% Start of user PostScript
0.99 -0.05 0.51 -0.95 MAarrowhead1
% End of user PostScript
P
p
.004 w
.97619 1.90476 m
.97619 1.04762 L
s
% Start of user PostScript
1. -0.05 1. -0.95 MAarrowhead1
% End of user PostScript
P
p
.004 w
.02381 .95238 m
.02381 .09524 L
s
% Start of user PostScript
0 -1.05 0 -1.95 MAarrowhead1
% End of user PostScript
P
p
.004 w
.03333 .95238 m
.96667 .09524 L
s
% Start of user PostScript
0.01 -1.05 0.99 -1.95 MAarrowhead1
% End of user PostScript
P
p
.004 w
.49048 .95238 m
.03333 .09524 L
s
% Start of user PostScript
0.49 -1.05 0.01 -1.95 MAarrowhead1
% End of user PostScript
P
p
.004 w
.50952 .95238 m
.96667 .09524 L
s
% Start of user PostScript
0.51 -1.05 0.99 -1.95 MAarrowhead1
% End of user PostScript
P
p
.004 w
.95714 .95238 m
.04286 .09524 L
s
% Start of user PostScript
0.98 -1.05 0.02 -1.95 MAarrowhead1
% End of user PostScript
P
p
.004 w
.97619 .95238 m
.97619 .09524 L
s
% Start of user PostScript
1. -1.05 1. -1.95 MAarrowhead1
% End of user PostScript
P
P
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellMargins->{{54, Inherited}, {Inherited, Inherited}},
  Evaluatable->False,
  AspectRatioFixed->True,
  ImageSize->{157, 314},
  ImageMargins->{{34, Inherited}, {Inherited, Inherited}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40002M0001>PP10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[oooclo5H/1EGooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00000EED0EJX00=d81Slo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0ZP00
oeD0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP0009d0002M0000W@0009H01?l30000V@02o`80
002I00;o0P0000030?oo00CoS`05o`80000300;oT002o`800_l200000`02oi000_l200;o0P0000<0
0_n@00;o0P02o`80000300;oT002o`800_l2000000<0ool01?n?00?o00<0ool00@0000<00_nH0000
1004oiD0002M0000W@0000<000?o0?l00_n=00;o00<0o`000`0000<000Go0?oo0002ohT00_l0103o
0?l400000`000ol0o`02o`030?oo08L00_l01@3oo`3o00@0000200?o00D0oooo0003oh<00ol0103o
o`03o`<0000200?o00<0ool00_l0103o0?n10004o`3o00?o00@0oooo0`0000800ol01@3oo`3o0080
00?o0000P@000ol0o`03o`040?ooo`<0000200?o00H0o`3o0?l20003o`0007l000So0?l0o`3o00?o
0`0000070?l0o`3o0002o`8000Co003oO`001?l00003o`060?l0o`3o0P00000:0?l0o`3o0?l0o`D0
00?o0000N`000ol000020009o`3o0?l0o`3o008000030003o`0000@000?o00000`000ol0001i0003
o`00008000?o000010000ol0000200000`000ol000040003o`0000@000?o0000M`000ol000030003
o`0000@000?o00000P0000<000?o00001@000ol000040003o`0007D000?o00000`000ol000050003
o`00008000030003o`0000D000?o00001@000ol0001b00;o1P000ol000050003o`00008000030003
o`0000H000?o00001@000ol0001`0003o`0000D000?o00001P000ol0000200000`000ol000060003
o`0000H000?o0000KP000ol000060003o`0000H000?o00000P0000<000?o00001`000ol0000600;o
K@000ol000060003o`0000L000?o00000P0000<000?o00001`000ol000080003o`0006T000?o0000
1`000ol000070003o`00008000030003o`0000P000?o000020000ol0001W0003o`0000L000?o0000
20000ol0000200000`000ol000080003o`0000T000?o0000I@000ol000080003o`0000P000?o0000
0P0000<000?o00002@000ol000090003o`0006<000?o000020000ol000090003o`00008000030003
o`0000T000?o00002P000ol0001Q0003o`0000T000?o00002@000ol0000200000`000ol0000:0003
o`0000X000?o0000G`000ol000090003o`0000X000?o00000P0000<000?o00002P000ol0000;0003
o`0005d000?o00002P000ol0000:0003o`00008000030003o`0000/000?o00002`000ol0001K0003
o`0000X000?o00002`000ol0000200000`000ol0000;0003o`0000`000?o0000F002o`d000?o0000
2`000ol0000200000`000ol0000<0003o`0000`000?o0000EP000ol0000<0003o`0000`000?o0000
0P0000<000?o00003@000ol0000<0003o`0005@000?o000030000ol0000=0003o`00008000030003
o`0000d000?o00003@000ol0001B0003o`0000d000?o00003@000ol0000200000`000ol0000>0003
o`0000d000?o0000D0000ol0000=0003o`0000h000?o00000P0000<000?o00003P000ol0000>0003
o`0004h000?o00003P000ol0000>0003o`00008000030003o`0000l000?o00003P02odd000?o0000
3P000ol0000?0003o`00008000030003o`0000l000?o000040000ol000190003o`0000l000?o0000
3`000ol0000200000`000ol0000@0003o`00010000?o0000A`000ol0000?0003o`00010000?o0000
0P0000<000?o000040000ol0000A0003o`0004D000?o000040000ol0000@0003o`00008000030003
o`00014000?o00004@000ol000130003o`00010000?o00004@000ol0000200000`000ol0000A0003
o`00018000?o0000@@000ol0000A0003o`00014000?o00000P0000<000?o00004P000ol0000B0003
o`0003l000?o00004@000ol0000B0003o`00008000030003o`00018000?o00004`000ol0000l00;o
50000ol0000B0003o`00008000030003o`0001<000?o00004`000ol0000j0003o`0001<000?o0000
4`000ol0000200000`000ol0000C0003o`0001@000?o0000>0000ol0000D0003o`0001<000?o0000
0P0000<000?o000050000ol0000D0003o`0003H000?o000050000ol0000D0003o`00008000030003
o`0001@000?o00005@000ol0000d0003o`0001D000?o000050000ol0000200000`000ol0000E0003
o`0001D000?o0000<P000ol0000E0003o`0001D000?o00000P0000<000?o00005P000ol0000E0003
o`00030000?o00005@000ol0000F0003o`00008000030003o`0001H000?o00005P000ol0000^0003
o`0001H000?o00005P000ol0000200000`000ol0000G0003o`0001H00_l]0003o`0001H000?o0000
5`000ol0000200000`000ol0000G0003o`0001P000?o0000:@000ol0000G0003o`0001L000?o0000
0P0000<000?o000060000ol0000H0003o`0002L000?o00005`000ol0000H0003o`00008000030003
o`0001P000?o00006@000ol0000U0003o`0001P000?o000060000ol0000200000`000ol0000I0003
o`0001T000?o00008P02oaX000?o00006@000ol0000200000`000ol0000I0003o`0001X000?o0000
80000ol0000J0003o`0001T000?o00000P0000<000?o00006P000ol0000J0003o`0001h000?o0000
6P000ol0000J0003o`00008000030003o`0001X000?o00006`000ol0000L0003o`0001/000?o0000
6P000ol0000200000`000ol0000K0003o`0001/000?o00006P000ol0000K0003o`0001/000?o0000
0P0000<000?o00006`000ol0000L0003o`0001P000?o000070000ol0000K0003o`00008000030003
o`0001`000?o000070000ol0000F0003o`0001`000?o000070000ol0000200000`000ol0000L0003
o`0001d000?o000050000ol0000M0003o`0001`000?o00000P0000<000?o00007@000ol0000M0003
o`00018000?o00007@000ol0000M0003o`00008000030003o`0001d000?o00007P000ol0000@0003
o`0001h000?o00007@000ol0000200000`000ol0000N0003o`0001h000?o00003P000ol0000N0003
o`0001h000?o00000P0000<000?o00007`000ol0000N00;o3@000ol0000N0003o`0001l000?o0000
0P0000<000?o00007`000ol0000P0003o`0000P00_lQ0003o`0001l000?o00000P0000<000?o0000
80000ol0000P0003o`0000H000?o000080000ol0000P0003o`00008000030003o`00020000?o0000
8@000ol000040003o`00024000?o000080000ol0000200000`000ol0000Q0003o`00024000?o0000
0P000ol0000Q0003o`00024000?o00000P0000<000?o00008@000ol0000R0004o`00ob@000?o0000
8@000ol0000200000`000ol0000R0003o`0002800_lT0003o`00028000?o00000P0000<000?o0000
8P000ol0000R00;o90000ol0000R0003o`00008000030003o`0002<000?o000080001?l00?lR0003
o`0002<000?o00000P0000<000?o00008`000ol0000O0003o`00008000?o00007`000ol0000S0003
o`00008000030003o`0002@000?o00007@000ol000040003o`0001d000?o000090000ol000020000
0`000ol0000T0003o`0001`000?o00001P000ol0000L0003o`0002@000?o00000P0000<000?o0000
9@000ol0000J0003o`0000P000?o00006P000ol0000U0003o`00008000030003o`0002D000?o0000
6002o``000?o00006@000ol0000U0003o`00008000030003o`0002H000?o00005P000ol0000=00;o
60000ol0000V0003o`00008000030003o`0002H000?o00005@000ol0000@0003o`0001D000?o0000
9P000ol0000200000`000ol0000W0003o`0001<000?o00004P000ol0000C0003o`0002L000?o0000
0P0000<000?o0000:0000ol0000A0003o`0001@000?o00004@000ol0000X0003o`00008000030003
o`0002P000?o000040000ol0000F0003o`00010000?o0000:0000ol0000200000`000ol0000Y0003
o`0000h000?o000060000ol0000>0003o`0002T000?o00000P0000<000?o0000:@000ol0000=0003
o`0001X000?o00003@000ol0000Y0003o`00008000030003o`0002X000?o00002`000ol0000L0003
o`0000/000?o0000:P000ol0000200000`000ol0000Z0003o`0000X000?o00007P000ol0000:0003
o`0002X000?o00000P0000<000?o0000:`000ol000080003o`00020000?o000020000ol0000[0003
o`00008000030003o`0002/000?o00001`000ol0000R0003o`0000L000?o0000:`000ol000020000
0`000ol0000/0003o`0000@00_lV0003o`0000D000?o0000;0000ol0000200000`000ol0000/0003
o`0000<000?o00009`000ol000040003o`0002`000?o00000P0000<000?o0000;@001Ol0003o02/0
00?o00000P000ol0000]0003o`00008000030003o`0002d000Co003o;@001Ol0003o02l000?o0000
0P0000<000?o0000;P02obl00ol`0003o`00008000030003o`0002h000?o0000<0000ol0000^0003
o`00008000030003o`0002d000?o0?l0<0000ol0o`0_0003o`00008000030003o`0002`000Co003o
<0001?l00?l^0003o`00008000030003o`0002/000?o00000P000ol0000/0003o`00008000?o0000
:`000ol0000200000`000ol0000Z0003o`0000@000?o0000:P000ol000040003o`0002X000?o0000
0P0000<000?o0000:@000ol000050003o`0002X000?o00001@000ol0000Y0003o`00008000030003
o`0002P000?o00001`000ol0000X0003o`0000L000?o0000:0000ol0000200000`000ol0000V00;o
2P000ol0000X0003o`0000P000?o00009`000ol0000200000`000ol0000U0003o`0000/000?o0000
9P000ol0000:0003o`0002H000?o00000P0000<000?o000090000ol0000<0003o`0002H000?o0000
2`000ol0000U0003o`00008000030003o`0002<000?o00003P000ol0000T0003o`0000d000?o0000
90000ol0000200000`000ol0000R0003o`0000l000?o000090000ol0000>0003o`0002<000?o0000
0P0000<000?o00008@000ol0000A0003o`00028000?o000040000ol0000R0003o`00008000030003
o`00020000?o00004P000ol0000R0003o`00014000?o00008@000ol0000200000`000ol0000O0003
o`0001@000?o000080000ol0000C00;o8@000ol0000200000`000ol0000N0003o`0001D000?o0000
80000ol0000E0003o`0001h000?o00000P0000<000?o00007@000ol0000G0003o`0001h000?o0000
5`000ol0000M0003o`00008000030003o`0001`000?o000060000ol0000N0003o`0001P000?o0000
70000ol0000200000`000ol0000K0003o`0001X000?o000070000ol0000J0003o`0001/000?o0000
0P0000<000?o00006P000ol0000K0003o`0001`000?o00006`000ol0000J0003o`00008000030003
o`0001P00_lO0003o`0001X000?o00007@000ol0000I0003o`00008000030003o`0001L000?o0000
80000ol0000H0003o`0001l000?o000060000ol0000200000`000ol0000F0003o`00024000?o0000
60000ol0000P0003o`0001L000?o00000P0000<000?o00005@000ol0000S0003o`0001H000?o0000
8P000ol0000F0003o`00008000030003o`0001@000?o000090000ol0000F0003o`0002<000?o0000
5@000ol0000200000`000ol0000C0003o`0002H000?o000050000ol0000U0003o`0001@000?o0000
0P0000<000?o00004P000ol0000W0003o`0001@000?o00009P000ol0000C0003o`00008000030003
o`00014000?o0000:@000ol0000B0003o`0002P000?o00004P000ol0000200000`000ol0000@0003
o`0002X000?o00004P000ol0000Y0003o`00014000?o00000P0000<000?o00003`000ol0000/0003
o`00010000?o0000:`02oa4000?o00000P0000<000?o00003P000ol0000]0003o`00010000?o0000
;@000ol0000>0003o`00008000030003o`0000d000?o0000;`000ol0000>0003o`0002l000?o0000
3@000ol0000200000`000ol0000;00;o<P000ol0000>0003o`00030000?o000030000ol000020000
0`000ol0000:0003o`0003<000?o000030000ol0000b0003o`0000/000?o00000P0000<000?o0000
2@000ol0000d0003o`0000`000?o0000<`000ol0000:0003o`00008000030003o`0000P000?o0000
=P000ol0000:0003o`0003D000?o00002@000ol0000200000`000ol000070003o`0003L000?o0000
2P000ol0000f0003o`0000P000?o00000P0000<000?o00001P000ol0000i0003o`0000P000?o0000
>0000ol000070003o`00008000030003o`0000D000?o0000>`000ol000060003o`0003X000?o0000
1P000ol0000200000`000ol000040003o`0003`000?o00001P000ol0000k0003o`0000D000?o0000
0P0000<000?o00000`000ol0000n0003o`0000@000?o0000?@000ol000040003o`00008000030003
o`00008000?o0000?`000ol000040003o`0003h000?o00000`000ol0000200000`001Ol0003o04<0
00?o00000P000ol000100003o`00008000?o00000P0000<000Co003oA0000ol000020003o`000440
00Go0000o`0400000`000ol0o`160004o`00odD000Co003o100009d0002M0000W@0000801?m600Ko
A004o`<000000`3oo`0200;oA002o`800_m400;o0P02o`8000000`3oo`1800;o0P02od@00_l60000
00<0ool0B002o`800_m400Ko0P0000030?oo00800_m400;o0P02od@00_l200;o0P0000801Om500Go
A@04o`<0001?00;oC00004h00om<0000W@0009d000030003o`0000;oA0001?l00?m500;o00<0o`00
0`0000<000Go003o0002od8000Co003o@`02o`040?l0o`@000030006o`000?l00_m000;o0P02od40
0_l01@3o003o00@0000200?o0`000ol0o`02ocd00_l400;o?P03o`8000?o0?l00_l300000P03o`@0
00Go0?l0o`0k00?o1003oc`000?o0?l00P000ol00003o`<0000200?o10001?l00?lk0004o`3oo`@0
0_l00`3o000k0004o`00o`<00ol300000P03o`D000Co003o>@001Ol0o`3o00@000Go0?l0o`0j0005
o`000?l00`03o`<000001P3o0?l0o`D000Co003o>P02o`H00_lk0005o`000?l00`001Ol0o`3o0080
00001P3o0?l0o`T000?o0000=P000ol0o`060003o`3o03T000?o00001P001Ol0o`3o008000030003
o`0000X000?o0000=0000ol0000:0003o`0003D000?o00002@000ol0000200000`000ol0000;0003
o`0003<000?o00002P000ol0000d0003o`0000X000?o00000P0000<000?o000030000ol0000a0003
o`0000`000?o0000<P000ol0000;0003o`00008000030003o`0000d000?o0000<0000ol0000<0003
o`00034000?o000030000ol0000200000`000ol0000>0003o`0002h000?o00003P000ol0000^00;o
3`000ol0000200000`000ol0000?0003o`0002d000?o00003P000ol0000]0003o`0000l000?o0000
0P0000<000?o00004002ob`000?o000040000ol0000[0003o`00010000?o00000P0000<000?o0000
4P000ol0000Y0003o`00010000?o0000:P000ol0000A0003o`00008000030003o`0001<000?o0000
9`000ol0000B0003o`0002P000?o00004P000ol0000200000`000ol0000D0003o`0002H000?o0000
4P000ol0000W0003o`0001<000?o00000P0000<000?o00005@000ol0000T0003o`0001@000?o0000
9@000ol0000D0003o`00008000030003o`0001H000?o00008`000ol0000D0003o`0002@000?o0000
5@000ol0000200000`000ol0000G0003o`00024000?o00005P000ol0000R0003o`0001H000?o0000
0P0000<000?o000060000ol0000P0003o`0001H000?o00008@000ol0000G0003o`00008000030003
o`0001T000?o00007P000ol0000H0003o`0001l000?o000060000ol0000200000`000ol0000J0003
o`0001d000?o000060000ol0000N0003o`0001T000?o00000P0000<000?o00006`000ol0000K0003
o`0001X000?o000070000ol0000J0003o`00008000030003o`0001`000?o00006@000ol0000L0003
o`0001X000?o00006`000ol0000200000`000ol0000M0003o`0001P000?o000070000ol0000H00;o
7P000ol0000200000`000ol0000N0003o`0001H000?o00007P000ol0000F0003o`0001h000?o0000
0P0000<000?o00007`000ol0000E0003o`0001h000?o00005@000ol0000O0003o`00008000030003
o`0002000_lD0003o`00020000?o00004`000ol0000P0003o`00008000030003o`00028000?o0000
4@000ol0000P0003o`00018000?o00008@000ol0000200000`000ol0000S0003o`0000l000?o0000
8P000ol0000@0003o`00028000?o00000P0000<000?o000090000ol0000>0003o`00028000?o0000
3`000ol0000S0003o`00008000030003o`0002D000?o000030000ol0000T0003o`0000d000?o0000
90000ol0000200000`000ol0000V0003o`0000/000?o000090000ol0000<0003o`0002D000?o0000
0P0000<000?o00009`000ol000090003o`0002H000?o00002P000ol0000V0003o`00008000030003
o`0002P000?o000020000ol0000V0003o`0000T000?o00009`000ol0000200000`000ol0000Y0003
o`0000H000?o0000:0000ol000070003o`0002P000?o00000P0000<000?o0000:P000ol000050003
o`0002P000?o00001P000ol0000Y0003o`00008000030003o`0002/000?o00000`000ol0000Z0003
o`0000<00_l/0003o`00008000030003o`0002`000?o00000P000ol0000Z0003o`00008000?o0000
;0000ol0000200000`000ol0000]0004o`00obh000Co003o;`000ol0000200000`000ol0000^00;o
<002oc0000?o00000P0000<000?o0000;`000ol0000^0003o`0002l000?o00000P0000<000?o0000
;P001?l0ool]0003o`3o030000?o00000P0000<000?o0000;P001Ol0003o02/000Co003o<0000ol0
000200000`000ol0000]0003o`0000<000?o00009`000ol000020003o`0002d000?o00000P0000<0
00?o0000;@000ol000040003o`0002D000?o00000`000ol0000]0003o`00008000030003o`0002`0
00?o00001P000ol0000S0003o`0000D000?o0000;0000ol0000200000`000ol0000/0003o`0000L0
00?o00008@000ol000060003o`0002`000?o00000P0000<000?o0000:`000ol000090003o`0001l0
00?o000020000ol0000[0003o`00008000030003o`0002/000?o00002P000ol0000M0003o`0000T0
00?o0000:`000ol0000200000`000ol0000Z0003o`0000`000?o00006`000ol0000;0003o`0002X0
00?o00000P0000<000?o0000:P000ol0000=0003o`0001P00_l>0003o`0002X000?o00000P0000<0
00?o0000:@000ol0000?0003o`0001H000?o00003`000ol0000Y0003o`00008000030003o`0002T0
00?o000040000ol0000D0003o`00010000?o0000:@000ol0000200000`000ol0000X0003o`000180
00?o00004P000ol0000B0003o`0002P000?o00000P0000<000?o0000:0000ol0000C0003o`000100
00?o00004`000ol0000X0003o`00008000030003o`0002L000?o00005@000ol0000>0003o`0001D0
00?o00009`000ol0000200000`000ol0000V0003o`0001L00_l=0003o`0001L000?o00009P000ol0
000200000`000ol0000V0003o`0001T000?o00002@000ol0000H0003o`0002H000?o00000P0000<0
00?o00009@000ol0000K0003o`0000L000?o00006P000ol0000U0003o`00008000030003o`0002D0
00?o000070000ol000050003o`0001/000?o00009@000ol0000200000`000ol0000T0003o`0001h0
00?o00000`000ol0000M0003o`0002@000?o00000P0000<000?o000090000ol0000O0005o`000?l0
80000ol0000T0003o`00008000030003o`0002<000?o00008@000ol0o`0R0003o`0002<000?o0000
0P0000<000?o00008`000ol0000Q00;o8`000ol0000S0003o`00008000030003o`00028000?o0000
8@001?l00?lS0003o`00028000?o00000P0000<000?o00008P000ol0000P0003o`00008000?o0000
80000ol0000R0003o`00008000030003o`00024000?o000080000ol000040003o`00020000?o0000
8@000ol0000200000`000ol0000Q0003o`0001l000?o00001P000ol0000O0003o`00024000?o0000
0P0000<000?o000080000ol0000O0003o`0000P000?o00007`000ol0000P0003o`00008000030003
o`00020000?o00007P000ol0000:0003o`0001h000?o000080000ol0000200000`000ol0000O0003
o`0001h000?o00003002oal000?o00007`000ol0000200000`000ol0000O0003o`0001d000?o0000
3`000ol0000L0003o`0001l000?o00000P0000<000?o00007P000ol0000M0003o`00014000?o0000
70000ol0000N0003o`00008000030003o`0001d000?o00007@000ol0000C0003o`0001`000?o0000
7@000ol0000200000`000ol0000M0003o`0001`000?o00005@000ol0000K0003o`0001d000?o0000
0P0000<000?o000070000ol0000L0003o`0001L000?o00006`000ol0000L0003o`00008000030003
o`0001`000?o00006P02oa/000?o00006P000ol0000L0003o`00008000030003o`0001/000?o0000
6P000ol0000L0003o`0001X000?o00006`000ol0000200000`000ol0000K0003o`0001T000?o0000
7P000ol0000I0003o`0001/000?o00000P0000<000?o00006P000ol0000I0003o`00020000?o0000
6@000ol0000J0003o`00008000030003o`0001X000?o000060000ol0000R0003o`0001P000?o0000
6P000ol0000200000`000ol0000I0003o`0001P000?o000090000ol0000H0003o`0001T000?o0000
0P0000<000?o00006@000ol0000G0003o`0002H000?o00005`000ol0000I0003o`00008000030003
o`0001P000?o00005`000ol0000X0003o`0001L000?o000060000ol0000200000`000ol0000H0003
o`0001H000?o0000:P000ol0000F0003o`0001P000?o00000P0000<000?o00005`000ol0000F0003
o`0002`00_lG0003o`0001L000?o00000P0000<000?o00005`000ol0000E0003o`0002l000?o0000
50000ol0000G0003o`00008000030003o`0001H000?o00005@000ol0000a0003o`0001@000?o0000
5P000ol0000200000`000ol0000F0003o`0001@000?o0000<`000ol0000C0003o`0001H000?o0000
0P0000<000?o00005@000ol0000D0003o`0003D000?o00004`000ol0000E0003o`00008000030003
o`0001@000?o00004`02ocT000?o00004`000ol0000D0003o`00008000030003o`0001@000?o0000
4P000ol0000j0003o`00018000?o000050000ol0000200000`000ol0000C0003o`00018000?o0000
?0000ol0000B0003o`0001<000?o00000P0000<000?o00004`000ol0000A0003o`0003h000?o0000
4@000ol0000C0003o`00008000030003o`00018000?o00004@000ol000100003o`00014000?o0000
4P000ol0000200000`000ol0000B0003o`00010000?o0000@P000ol0000@0003o`00018000?o0000
0P0000<000?o00004@000ol0000@0003o`0004@000?o000040000ol0000A0003o`00008000030003
o`00014000?o00003`000ol000160003o`0000l000?o00004@000ol0000200000`000ol0000@0003
o`0000l000?o0000B0000ol0000?0003o`00010000?o00000P0000<000?o000040000ol0000>0003
o`0004X000?o00003P000ol0000@0003o`00008000030003o`0000l000?o00003P000ol0001<00;o
3`000ol0000?0003o`00008000030003o`0000l000?o00003@000ol0001?0003o`0000`000?o0000
3`000ol0000200000`000ol0000>0003o`0000d000?o0000D@000ol0000<0003o`0000h000?o0000
0P0000<000?o00003P000ol0000;00;oE@000ol0000;0003o`0000h000?o00000P0000<000?o0000
3@000ol0000;0003o`0005H000?o00002`000ol0000=0003o`00008000030003o`0000d000?o0000
2P000ol0001H0003o`0000X000?o00003@000ol0000200000`000ol0000<0003o`0000X000?o0000
FP000ol0000:0003o`0000`000?o00000P0000<000?o00002`000ol0000:0003o`0005`000?o0000
2P000ol0000;0003o`00008000030003o`0000/000?o00002@000ol0001N0003o`0000T000?o0000
2`000ol0000200000`000ol0000:0003o`0000T000?o0000H0000ol000090003o`0000X000?o0000
0P0000<000?o00002P000ol000080003o`00068000?o000020000ol0000:0003o`00008000030003
o`0000T000?o000020000ol0001T0003o`0000P000?o00002@000ol0000200000`000ol000090003
o`0000L000?o0000IP000ol000070003o`0000T000?o00000P0000<000?o000020000ol000070003
o`0006P000?o00001`000ol000080003o`00008000030003o`0000P000?o00001P000ol0001Z0003
o`0000H000?o000020000ol0000200000`000ol000070003o`0000H000?o0000K002o`L000?o0000
1`000ol0000200000`000ol000070003o`0000D000?o0000K`000ol000040003o`0000L000?o0000
0P0000<000?o00001P000ol0000400;oL`000ol000040003o`0000H000?o00000P0000<000?o0000
1P000ol000030003o`0007@000?o00000`000ol000060003o`00008000030003o`0000D000?o0000
0`000ol0001f0003o`0000<000?o00001@000ol0000200000`000ol000050003o`00008000?o0000
N0000ol000020003o`0000D000?o00000P0000<000?o000010000ol000020003o`0007X000?o0000
0P000ol000040003o`00008000030003o`0000@000Go0000o`1n0005o`000?l01P000ol000020000
0`000ol000030005o`000?l0P0001Ol0003o00D000?o00000P0000<000?o00000P001Ol0003o0880
00Go0000o`040003o`00008000030003o`00008000Co003oQ0001?l00?l40003o`00008000030005
o`000?l00P000ol000240004o`00o`<000?o00000P0000<000Oo0000o`3o08P000?o0?l00`000ol0
000200000`001_l00?l0ohX000?o0?l00P000ol0000200000`000ol00002oh`00_l20003o`000080
00030004o`3oohh00_l00`3o00030000W@0009d0002M0000W@0000801_n<00Ko0`0000030?oo0080
0_n>00;o0P02o`8000000`3oo`0200;oSP02o`800_l200000P05ohh00_l200;o0P0000D00_n>00;o
0P02o`80000200CoS`05o`<0002E00;o1P0009@00ol60000W@0009d0002M0000\
\>"],
  ImageRangeCache->{{{0, 156}, {313, 0}} -> {-0.0250052, -2.05337, 0.00673084,
   0.00673084}}],

Cell["Here is the output.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Outer[List, {a, b}, {c, d, e}, {f, g}] // TableForm\)], "Input"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {GridBox[{
                {"a", "c", "f"},
                {"a", "c", "g"}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], GridBox[{
                {"a", "d", "f"},
                {"a", "d", "g"}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], GridBox[{
                {"a", "e", "f"},
                {"a", "e", "g"}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}]},
          {GridBox[{
                {"b", "c", "f"},
                {"b", "c", "g"}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], GridBox[{
                {"b", "d", "f"},
                {"b", "d", "g"}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], GridBox[{
                {"b", "e", "f"},
                {"b", "e", "g"}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}]}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      TableForm[
       {{{{a, c, f}, {a, c, g}}, {{a, d, f}, {a, d, g}}, {{a, e, f}, {a, e, 
        g}}}, {{{b, c, f}, {b, c, g}}, {{b, d, f}, {b, d, g}}, {{b, e, f}, {b,
         e, g}}}}]]], "Output"]
}, Closed]],

Cell[TextData[{
  "Here we compute all possible pairs of elements, one each from ",
  StyleBox["{1, 2, 3}", "Input"],
  " and ",
  StyleBox["{a, b, c, d}", "Input"],
  ", and then give each pair the head ",
  StyleBox["Plus", "Input"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Outer[Plus, {1, 2, 3}, {a, b, c, d}] // TableForm\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {\(1 + a\), \(1 + b\), \(1 + c\), \(1 + d\)},
          {\(2 + a\), \(2 + b\), \(2 + c\), \(2 + d\)},
          {\(3 + a\), \(3 + b\), \(3 + c\), \(3 + d\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Closed]],

Cell[TextData[{
  "Here is a concise way to construct the Jacobian of two functions ",
  StyleBox["f", "Input"],
  " and ",
  StyleBox["g", "Input"],
  " using ",
  StyleBox["Outer", "Input"],
  ". The following command generates a table of all pairings of one function \
(",
  StyleBox["f", "Input"],
  " or ",
  StyleBox["g", "Input"],
  ") and one variable (",
  StyleBox["x", "Input"],
  " or ",
  StyleBox["y", "Input"],
  "), and then for each pair takes the derivative ",
  StyleBox["D", "Input"],
  " of the function with respect to the variable."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Outer[D, {f[x, y], g[x, y]}, {x, y}] // MatrixForm\)], "Input"],

Cell[BoxData[
    TagBox[
      RowBox[{"(", GridBox[{
            {
              RowBox[{
                SuperscriptBox["f", 
                  TagBox[\((1, 0)\),
                    Derivative],
                  MultilineFunction->None], "[", \(x, y\), "]"}], 
              RowBox[{
                SuperscriptBox["f", 
                  TagBox[\((0, 1)\),
                    Derivative],
                  MultilineFunction->None], "[", \(x, y\), "]"}]},
            {
              RowBox[{
                SuperscriptBox["g", 
                  TagBox[\((1, 0)\),
                    Derivative],
                  MultilineFunction->None], "[", \(x, y\), "]"}], 
              RowBox[{
                SuperscriptBox["g", 
                  TagBox[\((0, 1)\),
                    Derivative],
                  MultilineFunction->None], "[", \(x, y\), "]"}]}
            }], ")"}],
      (MatrixForm[ #]&)]], "Output"]
}, Closed]],

Cell[TextData[{
  "Here is a similar method of constructing the Wronskian matrix for a list \
of functions (used to verify fundamental solution sets of differential \
equations). The function ",
  StyleBox["WD", "Input"],
  " sets up the differentiation function ",
  StyleBox["D", "Input"],
  " for use with pairs consisting of a function of ",
  StyleBox["x", "Input"],
  " and the number of times it is to be differentiated."
}], "Text"],

Cell[BoxData[
    \(WD[fn_, n_] := D[fn, {x, n}]\)], "Input"],

Cell[TextData[{
  "Here is some sample output of ",
  StyleBox["WD", "Input"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \({WD[f[x], 1], WD[g[x], 3]}\)], "Input"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{
          SuperscriptBox["f", "\[Prime]",
            MultilineFunction->None], "[", "x", "]"}], ",", 
        RowBox[{
          SuperscriptBox["g", 
            TagBox[\((3)\),
              Derivative],
            MultilineFunction->None], "[", "x", "]"}]}], "}"}]], "Output"]
}, Closed]],

Cell[TextData[{
  "Here are the lists of the functions ",
  StyleBox["f", "Input"],
  ", ",
  StyleBox["g", "Input"],
  ", and ",
  StyleBox["h", "Input"],
  " each differentiated 0, 1, and 2 times."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Outer[WD, {f[x], g[x], h[x]}, {0, 1, 2}]\)], "Input"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{"{", 
          RowBox[{\(f[x]\), ",", 
            RowBox[{
              SuperscriptBox["f", "\[Prime]",
                MultilineFunction->None], "[", "x", "]"}], ",", 
            RowBox[{
              SuperscriptBox["f", "\[DoublePrime]",
                MultilineFunction->None], "[", "x", "]"}]}], "}"}], ",", 
        RowBox[{"{", 
          RowBox[{\(g[x]\), ",", 
            RowBox[{
              SuperscriptBox["g", "\[Prime]",
                MultilineFunction->None], "[", "x", "]"}], ",", 
            RowBox[{
              SuperscriptBox["g", "\[DoublePrime]",
                MultilineFunction->None], "[", "x", "]"}]}], "}"}], ",", 
        RowBox[{"{", 
          RowBox[{\(h[x]\), ",", 
            RowBox[{
              SuperscriptBox["h", "\[Prime]",
                MultilineFunction->None], "[", "x", "]"}], ",", 
            RowBox[{
              SuperscriptBox["h", "\[DoublePrime]",
                MultilineFunction->None], "[", "x", "]"}]}], "}"}]}], "}"}]], 
  "Output"]
}, Closed]],

Cell[TextData[{
  "In order to generate the Wronskian matrix of ",
  StyleBox["f", "Input"],
  ", ",
  StyleBox["g", "Input"],
  ", and ",
  StyleBox["h", "Input"],
  ", we need to group the same-order derivatives, which we do by transposing \
the previous matrix."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Transpose[%] // MatrixForm\)], "Input"],

Cell[BoxData[
    TagBox[
      RowBox[{"(", GridBox[{
            {\(f[x]\), \(g[x]\), \(h[x]\)},
            {
              RowBox[{
                SuperscriptBox["f", "\[Prime]",
                  MultilineFunction->None], "[", "x", "]"}], 
              RowBox[{
                SuperscriptBox["g", "\[Prime]",
                  MultilineFunction->None], "[", "x", "]"}], 
              RowBox[{
                SuperscriptBox["h", "\[Prime]",
                  MultilineFunction->None], "[", "x", "]"}]},
            {
              RowBox[{
                SuperscriptBox["f", "\[DoublePrime]",
                  MultilineFunction->None], "[", "x", "]"}], 
              RowBox[{
                SuperscriptBox["g", "\[DoublePrime]",
                  MultilineFunction->None], "[", "x", "]"}], 
              RowBox[{
                SuperscriptBox["h", "\[DoublePrime]",
                  MultilineFunction->None], "[", "x", "]"}]}
            }], ")"}],
      (MatrixForm[ #]&)]], "Output"]
}, Closed]],

Cell[TextData[{
  "See also",
  StyleBox[" ",
    FontWeight->"Bold"],
  StyleBox["Operate", "Input"],
  ",",
  StyleBox[" ",
    FontWeight->"Bold"],
  StyleBox["Distribute", "Input"],
  ", ",
  StyleBox["Inner", "Input"]
}], "SeeAlso"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Exercises: High-level Programming", "Subsection",
  PageBreakAbove->True],

Cell[TextData[{
  "Define a function ",
  StyleBox["scatterPlot3D", "Input"],
  " that accepts a list of ordered triples, and generates a three-dimensional \
plot of the triples."
}], "Question"],

Cell[TextData[{
  "To generate a scatter plot of three-dimensional points, we map the \
three-dimensional graphics primitive ",
  StyleBox["Point", "Input"],
  " over each ordered triple."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Map[Point, {{1, 2, 3}, {2, 3, 4}, {3, 4, 5}}]\)], "Input"],

Cell[BoxData[
    \({Point[{1, 2, 3}], Point[{2, 3, 4}], Point[{3, 4, 5}]}\)], "Output"]
}, Closed]],

Cell["\<\
To turn this procedure into a function, we must define a function \
that accepts a list of triples.\
\>", "Text"],

Cell[BoxData[
    \(scatterPlot3D[triples : {{_, _, _}..}] := 
      Show[Graphics3D[Map[Point, triples]], Axes \[Rule] True]\)], "Input"],

Cell["Here is a list of 100 random ordered triples.", "Text"],

Cell[BoxData[
    \(\(data3D = Table[Random[], {100}, {3}]; \)\)], "Input"],

Cell["We see that the data are of the desired shape.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Short[data3D, 3]\)], "Input"],

Cell[BoxData[
    TagBox[
      "\({{0.299643292525791693`, 0.723637436509539178`,            \
0.115754155335899966`},          \[LeftSkeleton]98\[RightSkeleton], {\
\[LeftSkeleton]1\[RightSkeleton]}}         \)",
      (Short[ #, 3]&)]], "Output"]
}, Closed]],

Cell["Here is a test of the function.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(scatterPlot3D[data3D]; \)\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.10098 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0631968 1.17911 1.11022e-16 1.17911 [
[.09061 .22765 -5.9003 -9 ]
[.09061 .22765 .0997 0 ]
[.2225 .17206 -22.5524 -9 ]
[.2225 .17206 1.44762 0 ]
[.36169 .11342 -16.1277 -9 ]
[.36169 .11342 1.87232 0 ]
[.50881 .05148 -20.4548 -9 ]
[.50881 .05148 3.54524 0 ]
[.00962 .8386 -3.45231 0 ]
[.00962 .8386 2.54769 9 ]
[.12299 .9186 -13.3801 0 ]
[.12299 .9186 10.6199 9 ]
[.22468 .99034 -9.75862 0 ]
[.22468 .99034 8.24138 9 ]
[.31639 1.05504 -12.6915 0 ]
[.31639 1.05504 11.3085 9 ]
[.39952 1.1137 -3.10277 0 ]
[.39952 1.1137 2.89723 9 ]
[.07311 .2605 -6 -2.62178 ]
[.07311 .2605 0 6.37822 ]
[.05459 .37932 -24 -2.72467 ]
[.05459 .37932 0 6.27533 ]
[.03445 .50851 -18 -2.83745 ]
[.03445 .50851 0 6.16255 ]
[.01248 .6495 -24 -2.96159 ]
[.01248 .6495 0 6.03841 ]
[-0.01159 .80398 -6 -3.09893 ]
[-0.01159 .80398 0 5.90107 ]
[ 0 0 0 0 ]
[ 1 1.10098 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.08847 .24345 m
.66871 0 L
s
.10085 .23825 m
.10597 .24355 L
s
[(0)] .09061 .22765 .96677 1 Mshowa
.23223 .18313 m
.2371 .18866 L
s
[(0.25)] .2225 .17206 .87937 1 Mshowa
.37084 .12497 m
.37542 .13075 L
s
[(0.5)] .36169 .11342 .79196 1 Mshowa
.5173 .06353 m
.52154 .06955 L
s
[(0.75)] .50881 .05148 .70456 1 Mshowa
.125 Mabswid
.12658 .22746 m
.12962 .23066 L
s
.15257 .21655 m
.15559 .21979 L
s
.17884 .20553 m
.18183 .20879 L
s
.2054 .19439 m
.20835 .19768 L
s
.25936 .17175 m
.26224 .1751 L
s
.28678 .16025 m
.28963 .16362 L
s
.31449 .14862 m
.31731 .15202 L
s
.34251 .13686 m
.3453 .1403 L
s
.39949 .11296 m
.40219 .11645 L
s
.42845 .10081 m
.43112 .10433 L
s
.45773 .08852 m
.46036 .09207 L
s
.48735 .07609 m
.48994 .07968 L
s
.54759 .05082 m
.5501 .05446 L
s
.57823 .03796 m
.58069 .04164 L
s
.60922 .02496 m
.61164 .02866 L
s
.64057 .01181 m
.64294 .01554 L
s
.25 Mabswid
0 .81565 m
.40287 1.10098 L
s
.01182 .82402 m
.01291 .81674 L
s
[(0)] .00962 .8386 .15077 -1 Mshowa
.12468 .90396 m
.12552 .89663 L
s
[(0.25)] .12299 .9186 .11501 -1 Mshowa
.22592 .97565 m
.22653 .96831 L
s
[(0.5)] .22468 .99034 .08429 -1 Mshowa
.31723 1.04033 m
.31766 1.03297 L
s
[(0.75)] .31639 1.05504 .05763 -1 Mshowa
.40003 1.09896 m
.40028 1.0916 L
s
[(1)] .39952 1.1137 .03426 -1 Mshowa
.125 Mabswid
.03541 .84074 m
.03604 .83636 L
s
.05848 .85707 m
.05908 .85269 L
s
.08104 .87305 m
.0816 .86866 L
s
.1031 .88867 m
.10363 .88428 L
s
.1458 .91891 m
.14627 .91452 L
s
.16646 .93355 m
.16691 .92915 L
s
.1867 .94788 m
.18712 .94348 L
s
.20651 .96191 m
.20691 .95751 L
s
.24492 .98912 m
.24527 .98471 L
s
.26355 1.00231 m
.26387 .9979 L
s
.2818 1.01524 m
.2821 1.01082 L
s
.29969 1.02791 m
.29997 1.02349 L
s
.33444 1.05251 m
.33467 1.0481 L
s
.35131 1.06446 m
.35152 1.06004 L
s
.36785 1.07618 m
.36805 1.07176 L
s
.38409 1.08768 m
.38426 1.08326 L
s
.25 Mabswid
.08847 .24345 m
0 .81565 L
s
.08671 .25483 m
.09351 .25199 L
s
[(0)] .07311 .2605 1 -0.41738 Mshowa
.0683 .37391 m
.07515 .3712 L
s
[(0.25)] .05459 .37932 1 -0.39452 Mshowa
.04828 .5034 m
.05519 .50085 L
s
[(0.5)] .03445 .50851 1 -0.36946 Mshowa
.02643 .64473 m
.0334 .64235 L
s
[(0.75)] .01248 .6495 1 -0.34187 Mshowa
.00248 .7996 m
.00952 .79741 L
s
[(1)] -0.01159 .80398 1 -0.31135 Mshowa
.125 Mabswid
.08315 .27787 m
.08724 .27618 L
s
.07953 .30129 m
.08362 .29962 L
s
.07585 .3251 m
.07995 .32344 L
s
.0721 .3493 m
.07621 .34766 L
s
.06443 .39893 m
.06855 .39733 L
s
.0605 .42438 m
.06462 .42279 L
s
.05649 .45027 m
.06063 .4487 L
s
.05242 .4766 m
.05656 .47505 L
s
.04406 .53067 m
.04822 .52916 L
s
.03977 .55842 m
.04393 .55693 L
s
.0354 .58668 m
.03957 .5852 L
s
.03096 .61544 m
.03513 .61399 L
s
.02181 .67456 m
.02601 .67315 L
s
.01712 .70495 m
.02132 .70356 L
s
.01233 .73591 m
.01654 .73454 L
s
.00745 .76745 m
.01167 .76611 L
s
.25 Mabswid
.08847 .24345 m
0 .81565 L
s
0 .81565 m
.40287 1.10098 L
s
.40287 1.10098 m
.42019 .58358 L
s
.42019 .58358 m
.08847 .24345 L
s
.66871 0 m
.92714 .4174 L
s
.92714 .4174 m
1 .96393 L
s
1 .96393 m
.70168 .59942 L
s
.70168 .59942 m
.66871 0 L
s
.08847 .24345 m
0 .81565 L
s
0 .81565 m
.70168 .59942 L
s
.70168 .59942 m
.66871 0 L
s
.66871 0 m
.08847 .24345 L
s
.42019 .58358 m
.92714 .4174 L
s
.92714 .4174 m
1 .96393 L
s
1 .96393 m
.40287 1.10098 L
s
.40287 1.10098 m
.42019 .58358 L
s
0 0 m
1 0 L
1 1.10098 L
0 1.10098 L
closepath
clip
newpath
.01 w
.3987 .62085 Mdot
.50494 .64254 Mdot
.49175 .47653 Mdot
.68207 .58643 Mdot
.46904 .78122 Mdot
.54307 .46348 Mdot
.34871 .52354 Mdot
.35733 .58611 Mdot
.49572 .50989 Mdot
.63643 .61162 Mdot
.5783 .51126 Mdot
.35927 .69206 Mdot
.70988 .46012 Mdot
.89911 .49087 Mdot
.33641 .54635 Mdot
.37093 .63634 Mdot
.89624 .52461 Mdot
.69152 .41582 Mdot
.55 .62801 Mdot
.8803 .49008 Mdot
.43836 .95344 Mdot
.3807 .68743 Mdot
.31244 .5208 Mdot
.45634 .54337 Mdot
.30827 .71733 Mdot
.40039 .79645 Mdot
.58336 .87117 Mdot
.3736 .67533 Mdot
.7932 .6009 Mdot
.32481 .32329 Mdot
.74032 .60929 Mdot
.23071 .51554 Mdot
.36117 .75323 Mdot
.38289 1.00851 Mdot
.85871 .58871 Mdot
.2235 .5772 Mdot
.12944 .29295 Mdot
.72605 .55427 Mdot
.33019 .82434 Mdot
.45923 .88836 Mdot
.78654 .63724 Mdot
.70594 .7593 Mdot
.63478 .91344 Mdot
.36937 .36846 Mdot
.71016 .54045 Mdot
.32689 .39831 Mdot
.64509 .26845 Mdot
.25464 .44293 Mdot
.76464 .59006 Mdot
.68167 .34078 Mdot
.33316 .74924 Mdot
.34531 .9809 Mdot
.60493 .29427 Mdot
.94064 .83293 Mdot
.23759 .58714 Mdot
.41799 .84836 Mdot
.48983 .27787 Mdot
.85336 .7783 Mdot
.69633 .81259 Mdot
.62075 .23845 Mdot
.37432 .37056 Mdot
.62759 .42385 Mdot
.40189 .23401 Mdot
.72223 .18862 Mdot
.42121 .73513 Mdot
.60534 .47527 Mdot
.95092 .88081 Mdot
.59918 .20267 Mdot
.62773 .73525 Mdot
.86475 .707 Mdot
.71887 .81043 Mdot
.62856 .06191 Mdot
.43807 .37442 Mdot
.28425 .70555 Mdot
.82365 .83807 Mdot
.65414 .7496 Mdot
.34365 .65396 Mdot
.26691 .63939 Mdot
.72814 .85192 Mdot
.33824 .43553 Mdot
.30179 .8263 Mdot
.53735 .34444 Mdot
.87033 .81273 Mdot
.76213 .41076 Mdot
.13204 .81631 Mdot
.2305 .53944 Mdot
.23645 .74193 Mdot
.33821 .83964 Mdot
.59724 .2874 Mdot
.26519 .82378 Mdot
.35283 .67726 Mdot
.17039 .82471 Mdot
.4736 .82066 Mdot
.46423 .76501 Mdot
.40223 .74208 Mdot
.41929 .61052 Mdot
.73579 .65492 Mdot
.64392 .66707 Mdot
.67171 .67264 Mdot
.51039 .69974 Mdot
.25 Mabswid
.66871 0 m
.92714 .4174 L
s
.92714 .4174 m
1 .96393 L
s
1 .96393 m
.70168 .59942 L
s
.70168 .59942 m
.66871 0 L
s
.08847 .24345 m
0 .81565 L
s
0 .81565 m
.70168 .59942 L
s
.70168 .59942 m
.66871 0 L
s
.66871 0 m
.08847 .24345 L
s
.08847 .24345 m
.66871 0 L
s
.10085 .23825 m
.10597 .24355 L
s
[(0)] .09061 .22765 .96677 1 Mshowa
.23223 .18313 m
.2371 .18866 L
s
[(0.25)] .2225 .17206 .87937 1 Mshowa
.37084 .12497 m
.37542 .13075 L
s
[(0.5)] .36169 .11342 .79196 1 Mshowa
.5173 .06353 m
.52154 .06955 L
s
[(0.75)] .50881 .05148 .70456 1 Mshowa
.125 Mabswid
.12658 .22746 m
.12962 .23066 L
s
.15257 .21655 m
.15559 .21979 L
s
.17884 .20553 m
.18183 .20879 L
s
.2054 .19439 m
.20835 .19768 L
s
.25936 .17175 m
.26224 .1751 L
s
.28678 .16025 m
.28963 .16362 L
s
.31449 .14862 m
.31731 .15202 L
s
.34251 .13686 m
.3453 .1403 L
s
.39949 .11296 m
.40219 .11645 L
s
.42845 .10081 m
.43112 .10433 L
s
.45773 .08852 m
.46036 .09207 L
s
.48735 .07609 m
.48994 .07968 L
s
.54759 .05082 m
.5501 .05446 L
s
.57823 .03796 m
.58069 .04164 L
s
.60922 .02496 m
.61164 .02866 L
s
.64057 .01181 m
.64294 .01554 L
s
.25 Mabswid
0 .81565 m
.40287 1.10098 L
s
.01182 .82402 m
.01291 .81674 L
s
[(0)] .00962 .8386 .15077 -1 Mshowa
.12468 .90396 m
.12552 .89663 L
s
[(0.25)] .12299 .9186 .11501 -1 Mshowa
.22592 .97565 m
.22653 .96831 L
s
[(0.5)] .22468 .99034 .08429 -1 Mshowa
.31723 1.04033 m
.31766 1.03297 L
s
[(0.75)] .31639 1.05504 .05763 -1 Mshowa
.40003 1.09896 m
.40028 1.0916 L
s
[(1)] .39952 1.1137 .03426 -1 Mshowa
.125 Mabswid
.03541 .84074 m
.03604 .83636 L
s
.05848 .85707 m
.05908 .85269 L
s
.08104 .87305 m
.0816 .86866 L
s
.1031 .88867 m
.10363 .88428 L
s
.1458 .91891 m
.14627 .91452 L
s
.16646 .93355 m
.16691 .92915 L
s
.1867 .94788 m
.18712 .94348 L
s
.20651 .96191 m
.20691 .95751 L
s
.24492 .98912 m
.24527 .98471 L
s
.26355 1.00231 m
.26387 .9979 L
s
.2818 1.01524 m
.2821 1.01082 L
s
.29969 1.02791 m
.29997 1.02349 L
s
.33444 1.05251 m
.33467 1.0481 L
s
.35131 1.06446 m
.35152 1.06004 L
s
.36785 1.07618 m
.36805 1.07176 L
s
.38409 1.08768 m
.38426 1.08326 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{261.562, 288},
  ImageMargins->{{35, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004600017`P10`4000010?ooooooc?ooZ_ooI_oo
<ooo0?o<ooo<c?o<VC/k>gYjN[Vi^OShn03ooeGooj[ooonI<onI0?mVoomVc?mVVOmVI_mV<omV0?lc
oclo?ginO[fm_Oclo5D00:X00?l00?l0VOl0I_l0<ol00<coolcoc<coVLcoIP<30d92@X61PL30`000
EED0EJX0EOl0ELbIolbIc<bIVLbII/bI<lbI0<aVolaVc0L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0Z/`c
<l`c0<`0ol`0c<`0VL`0I/`0<l`000/;2dY:BXV9RLS8b000oeD0ojX0ool0oiW<VIW<IYW<<iW<09VI
oiVIc9VIVIVIIPl?3di>CXf=SLc<c01E05EE0:YE0?mE09TcoiTcc9TcVITcIYTc<iTc09T0oiT0c1<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEEFKo<fKo06K<ofK<c6K<VFK<IVK<<fK<01LG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZVIVVFIVIVIV<fIV06HcofHcc6HcVFHcIQ/K6eYJFYVIVMSHf01EoeEEojYEoomEoc?o
oc?oc3?oVC?oIS?o<c?o03?<oc?<c1lO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ03>I<c>I03=Voc=Vc3=V
VC=VIS=V<c=V02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZEC<0VC<0IS<0<c<0003oo`3oc03oV@3oIRLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2Io`2Ic02IV@2IIP2I<`2I001Vo`1Vc2/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`0c<`0c0000o`00c000V@00IP00<nh002l_;fi^KZf][Nc/k03o05Go0:[o0?oo0140
003^003M002k002Z0028001g001E03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@00M`00E@00A0008P00
4Nk^k]gMgK^k^cLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l01`000?l01`000?l01`000?l01`000?l0
1`000;@00_m@0000/@03o`030?l004l0002_00;o1002odl0002]00;o1P000ol0o`1>0000ZP03o`80
00?o00000`000ol0o`1>0000O002o`@000?o00000`000ol0000200?o6002o`/000Co003oC@0007/0
00Co003o2@000ol000050003o`0001<00_l=0004o`00odd0001k0004o`00o`X000?o000010000ol0
000@00?o00<0o`0030001Ol0003o04`0001k0004o`00o`X000Co00000olA00;o4P000ol000020003
o`0004T0001k0004o`00o`/000Co003o4@02oa@000?o00000P000ol000190000N`001?l00?l80004
o`00o`8000?o00003003o`030?l001@000?o00000P000ol000180000O002o`T01?l200Co2@02oaX0
00?o00000P000ol000180000V002oa`000?o00000`000ol000170000U@05oa`000?o000010000ol0
00160000T`02ob4000?o000010000ol000160000T003oaP00_l90003o`0000D000?o0000A@0008h0
0_l00`3o000H00;o2@000ol000060003o`0004@0002<00;o10000ol0000Q0003o`0000H000?o0000
A00008T00olZ0003o`0000L000?o0000@`0008L01?l[0003o`0000L000?o0000@`0005d00_l40003
o`0000800olJ00;o;`000ol000080003o`000480001L0004o`00o`/000?o00005003oc4000?o0000
2@000ol000110000G0001?l00?l;0003o`0001801?lb0003o`0000T000?o0000@@0005`000Co003o
2003oa<00_lf0003o`0000X000?o0000@00005`000Co003o20000ol0000@00?o>0000ol0000:0003
o`000400001L0004o`00o`P000?o00003P04ocT000?o00002`000ol0000o0000G@02o`T01?l;00;o
?@000ol0000<0003o`0003h0001d00?o?`000ol0000<0003o`0003h0001b00;o00<0o`00@0000ol0
000<0003o`0003d0001_00?oA@000ol0000<0003o`0003d0001]00;oB0000ol0000=0003o`0003`0
001[00;o00<0o`00A`000ol0000>0003o`0003/0001X00?o10000ol000150003o`0000h000?o0000
>`0006H00_m?0003o`0000l000?o0000>P0003D00_l40003o`0000801?l200?o6`02o`030?l004h0
00?o000040000ol0000i0000=0001?l00?l80004o`00o`D000?o00005@03oe<000?o000040000ol0
000i0000=0001?l00?l90003o`0000D000?o00004`02oeH000?o00004@000ol0000h0000=0001?l0
0?l:0004o`0000?o5002o`8000?o0000D`000ol0000A0003o`0003P0000d0004o`00o`/000Co003o
4`03oeX000?o00004P000ol0000g0000=0001?l00?l80004o`00o`8000?o00003`02oed000?o0000
4`000ol0000f0000=@02o`X00_l300Co3002o`8000?o0000FP000ol0000C0003o`0003H0001C00?o
H@000ol0000D0003o`0003D0001A00?oH`000ol0000D0003o`0003D0001?00;oIP000ol0000E0003
o`0003@0001<00?oJ0000ol0000F0003o`0003<0001:00?oJP000ol0000700;o3@000ol0000c0000
A`03o`<000?o0000J0000ol0000600;o3P000ol0000b00009P02oad00_ma0003o`0001L000?o0000
<@0002D000Co003o6P02o`8000?o0000KP000ol0000G0003o`000340000U0004o`00oaL00omQ00;o
4P000ol0000H0003o`000300000U0004o`00oaD00omS00;o4P000ol0000H0003o`000300000U0004
o`00oa<00_mj0003o`0001T000?o0000;`0002D000Co003o4003og`000?o00006P000ol0000^0000
9P02o`l00_l00`3o001l0003o`0001X000?o0000;P0003D00_n10003o`0001/000?o0000;@000380
0on30003o`0001/000?o0000;@0003000_l20003o`0003d00_m20003o`0001`000?o0000;00002h0
0_m400;o<`02o`d000?o00007@000ol0000[0000:`03og/00_l=0003o`0001d000?o0000:`0002X0
00Go0000o`290003o`0001h000?o0000:P0002X000?o0000R`000ol0000O0003o`0002T0000Z00;o
S0000ol0000O0003o`0002T0000Y00;o00<0o`00RP000ol0000P0003o`0002P0000R00;o1@001Ol0
003o08X000?o000080000ol0000X00008@001?l00?l40003o`00008000?o0000OP02o`P000?o0000
80000ol0000W00008@001?l00?l40003o`0000<000?o0000O@02o`P000?o00008@000ol0000V0000
8@001?l00?l40003o`0000@000?o0000QP000ol0000Q0003o`0002H0000Q0004o`00o`<00_l70003
o`0005D00_l^0003o`00028000?o00009@00024000Co003o10000ol000060003o`0005@00_l^0003
o`00028000?o00009@0002800_l50003o`0000L000?o0000K@02oa@000?o00008`000ol0000T0000
:0000ol0000800;oKP02oa@000?o000090000ol0000S0000:0000ol0000800?oK`02oa8000?o0000
90000ol0000S0000:002o``000?o0000K002oa8000?o00009@000ol0000R0000:0000ol0000<0003
o`0007l000?o00009P000ol0000Q0000:0000ol0000=0003o`0007h000?o00009P000ol0000Q0000
:0000ol0000>0003o`0007d000?o00009`000ol0000P00009`000ol0000@0003o`0007`000?o0000
9`000ol0000P00009`000ol0000A0003o`0007/000?o0000:0000ol0000O00009`02oa<000?o0000
8`02oeD000?o0000:@000ol0000N00009`000ol0000C0003o`0002800_mE0003o`0002T000?o0000
7P0002L000?o000050000ol0001h0003o`0002X000?o00007@0002L000?o00005@000ol0001g0003
o`0002X000?o00007@0002L000?o00005P000ol0001d00;o00<0o`00:`000ol0000L00009P000ol0
000H0003o`0005400_lP00;o00<0o`00;0000ol0000K00009P02oaX000?o0000D002ob<000?o0000
:`000ol0000K00009P000ol0000J0003o`0007@000?o0000;0000ol0000J00009P000ol0000K0003
o`0007<000?o0000;0000ol0000J00009P000ol0000L0003o`00078000?o0000;@000ol0000I0000
9P000ol0000M0003o`0002<00_m<0003o`0002h000?o0000600002D00olO0003o`0002801?m:0003
o`0002h000?o0000600002D000?o000080000ol0000S00;o3@02oc/000?o0000;`000ol0000G0000
3002o`@000?o00000P04o`800ol50003o`00024000?o0000<@02oc/000?o0000<0000ol0000F0000
2`001?l00?l80004o`00o`D000?o00000P000ol0000R0003o`0006d000?o0000<0000ol0000F0000
2`001?l00?l90003o`0000D000?o00000P000ol0000S0003o`0006`000?o0000<@000ol0000E0000
2`001?l00?l:0004o`0000?o1@000ol0000T0003o`0006/000?o0000<@000ol0000E00002`001?l0
0?l;0004o`00o`L000?o00009@000ol0001Z0003o`00038000?o0000500000/000Co003o20001?l0
0?l20003o`0000@00_lX0003o`0001400_mF0003o`0003<000?o00004`0000`00_l:00;o0`04o`<0
00?o0000:0000ol0000@00;oEP000ol0000c0003o`0001<0000T0003o`0002T000?o0000I`000ol0
000d0003o`000180000T0003o`0002X000?o0000IP000ol0000>00;o90000ol0000B000090000ol0
000[0003o`0006D00_l?00;o9@000ol0000A000090000ol0000[0003o`0006D00_le00?o4P0002<0
0_l^0003o`0005@00_l?0003o`0003000ol20003o`000100000S0003o`0002h000?o0000D`02o`l0
00?o0000;@03o`D000?o0000400002<000?o0000;`000ol0001S0003o`0002X00ol80003o`000100
000S0003o`00030000?o00003002oe@000?o00009`03o`/000?o0000400002<000?o0000:`02o`@0
00?o00002`02oe@000?o00009003o`l000?o00003`0002<000?o0000:`02o`D000?o0000H0000ol0
000Q00?o4P000ol0000?00008P02ocD000?o0000G`000ol0000N00?o5@000ol0000?00008P000ol0
000e0003o`0005h000?o00006P04oaP000?o00003`00028000?o0000=P000ol0001M0003o`0000;o
5@03oa`000?o00003`00028000?o0000=`000ol0000g00;o8`000ol00002oa800olO0003o`0000l0
000R0003o`0003P000?o0000=P02ob<000?o00004@03ob8000?o00003`00028000?o0000>@000ol0
001J0003o`0000h00olV0003o`0000h0000R0003o`0003X000?o0000:002oaT00_lD0003o`0000/0
0olY0003o`0000h0000Q0003o`0003`000?o00009`02oaT00_lD0003o`0000P00ol/0003o`0000h0
000Q0003o`0003d000?o0000E`000ol0000500?o;`000ol0000>00008@000ol0000n0003o`0005H0
00Co00001?lb0003o`0000h0000Q0003o`0003l000?o0000EP03obP00_l300;o1`000ol0000>0000
8@000ol000100003o`0005801?lZ00;o0`02o`L000?o00003P00024000?o0000@@000ol0001>00?o
0`000ol0000g0003o`0000d0000P00?o@`000ol0001:00?o1P000ol0000g0003o`0000d0000=00;o
10000ol0000200?o1@000ol000140003o`0002400_lS00?o2@000ol0000g0003o`0000d0000<0004
o`00o`/000?o00000P000ol000150003o`0002000_lB00;o3003o``000?o0000=`000ol0000=0000
30001?l00?l;0003o`00008000?o0000:002oa`000?o0000<`02o`P01?l?0003o`0003L000?o0000
3@0000`000Co003o2003o`D000?o0000:002oa800_l90003o`0003T00olC0003o`0003L000?o0000
3@0000`000Co003o20000ol000050003o`0003`00_l700;o00<0o`00=P03oaH000?o0000;002o`T0
00?o00003@0000`000Co003o20000ol000050003o`0004D00_l20003o`0003400olI0003o`0002`0
0_l:0003o`0000`0000=00;o2@04o`<000?o0000B`000ol0000]00?o70000ol0000h0003o`0000`0
000O0003o`0004`000?o0000:@03oal000?o0000>0000ol0000<00007`000ol0000Y00;o8P000ol0
000?00;o5003ob8000Co0?oo=`000ol0000<00007`000ol0000Y00;o6002o`T000?o00003P02oa40
0olU0004o`3oocL000?o0000300001l000?o0000@`02o`X000?o00007004obP000?o0000>0000ol0
000<00007`000ol0001@0003o`0001P00ol/0003o`0000<00_lc0003o`0000`0000N00;oD`000ol0
000D00?o;`000ol0000300;o<`000ol0000<00007P000ol0001C0003o`0001000olb0003o`0003T0
00?o00002`0001h000?o0000E0000ol0000<00?o=P000ol0000h0003o`0000/0000N0003o`0005D0
00?o00002003ocT000?o0000>0000ol0000;00007P000ol0001F0003o`0000@00oll0003o`0003P0
00?o00002`0001h000?o0000:002obd000?o00000olo0003o`0003P000?o00002`0001h000?o0000
:002obh00_m20003o`0003P000?o00002`0001d00_l^00;o6`02o`d000?o0000?002o`<000?o0000
8P02oa@000?o00002`0001d000?o0000;@02oa/00_l=0003o`0003`00_l30003o`0000/00_lE00;o
5@000ol0000:00007@000ol0001I0003o`00044000?o00002`02ob`000?o00002P0001d000?o0000
F@000ol0000o00?o5002obD000?o00002P0001d000?o0000F@000ol0000l00?o0P000ol0000B00;o
9@000ol0000:00007@000ol0001I0003o`0003T00ol60003o`0000@00_lb0003o`0000X0000M0003
o`0005P00_lc00;o0`03o`X000?o00000`02oc8000?o00002P0001`00_mJ00;o<`05o`h000?o0000
=P000ol0000:000070000ol0001E00;o0`000ol0000_00?o4`000ol0000f0003o`0000T0000L0003
o`0005D00_l30003o`0002`00olG0003o`0003D000?o00002@0001`000?o0000FP000ol0000L00;o
2`03oaX000?o0000=@000ol00009000070000ol0001J0003o`0001`00_l800?o7P000ol0000d0003
o`0000T0000L0003o`0003D00_lG00;o2P000ol0000R00Co8P000ol0000:00;o9`000ol000090000
70000ol0000e00;o5`02o`X000?o00004@02o``00olW0003o`0000T00_lW0003o`0000T0000K00?o
F`000ol0000A00;o2@03ob/000?o0000<@000ol0000900000P02o`@000?o00000`000ol0000200?o
1@000ol0001K0003o`0001T00ol^0003o`00034000?o00002@0000050?l00?l02@000ol000050003
o`00008000?o0000B002oa0000?o00005P04obl00_l00`3o000b0003o`0000P000001@3o003o00X0
00?o000010000ol000020003o`0004P00_l@0003o`0001<00olc00;o0P000ol0000`0003o`0000P0
00001@3o003o00X000Co00000ol50003o`0005X000?o00004003oc/000?o0000;`000ol000080000
00D0o`00o`0;0004o`00o`L000?o0000FP000ol0000=00?o8`02oaX000?o0000;P000ol000080000
00D0o`00o`080004o`00o`8000?o000010000ol0001K0003o`0000T01?lV00;o1@02oa@000?o0000
;@000ol0000800000P02o`T01?l200Co0`02oe400_l90003o`0000H00ola00;o50000ol0000]0003
o`0000P0000J0003o`0004/00_l300;o2@000ol0000300?oB`000ol0000/0003o`0000P0000J0003
o`0004/00_l>0003o`0000?oC`000ol0000/0003o`0000L0000J0003o`0005800_l700?oD`000ol0
000[0003o`0000L0000J0003o`0004d00_l300;o0`05oeH000?o0000:P000ol0000700006P000ol0
001=00;o1@03o`@000?o0000E0000ol0000Z0003o`0000L0000I0003o`0005800ol70003o`0001<0
0_m00003o`0002T000?o00001`0001T00_lm00;o4@03o`X000?o00004`02od4000?o0000:0000ol0
000700006@000ol0000l00;o3@04o`d000?o0000E`000ol0000>00;o5`000ol0000700006@000ol0
001800?o4@000ol0001H0003o`0000d00_lH0003o`0000H0000I0003o`0004800_l0103ooolD0003
o`0005T000?o00009P000ol0000600006@000ol0001200?o5`000ol0001I0003o`0002H000?o0000
1P0001P000?o0000?`04oaX000?o0000FP000ol0000U0003o`0000H0000H0003o`0003`00olN0003
o`0005/000?o000090000ol00006000060000ol0000i00?o8@03oe`000?o00008`000ol000060000
5`02ocP00olT00?o;`02ob`000?o00008P000ol00006000060000ol0000b00Co8`02o`8000?o0000
;`02ob`000?o00008`000ol00005000060000ol0000_00Go9@02o`8000?o0000GP000ol0000R0003
o`0000D0000H0003o`0002`00olJ00;o4P000ol0000f00;o9`000ol0000Q0003o`0000D0000G0003
o`0002X00olM00;o1002o``000?o0000=P02obP000?o000080000ol0000500005`000ol0000W00?o
9P02o``000?o0000@P02oad000?o00007`000ol0000500005`000ol0000S00Co=`000ol0001200;o
7P000ol0000N0003o`0000D0000G0003o`0002000olk0003o`0000P00_mH0003o`0001h000?o0000
1@0001H00_lO00?o?P000ol0000800;oF@000ol0000M0003o`0000D0000G0003o`0001X00om10003
o`0006@000?o00007@000ol0000400005P000ol0000G00CoA0000ol0001U00?o70000ol000040000
5P000ol0000D00?oA`000ol0000:00;oF`02oa`000?o0000100001H000?o00004@03odX000?o0000
2P02oe/000?o00006`000ol0000400005P000ol0000>00?oC@000ol0001X0003o`0001X000?o0000
100001H000?o00002`03odd00_l00`3o001Z0003o`0001T000?o0000100001D00ol800CoD002o`03
0?l006/000?o000060000ol0000400003@05o`@000?o00001003oeL000?o0000J`000ol0000H0003
o`0000<0000?0003o`0000<000?o00000P03oeX000?o0000K0000ol0000G0003o`0000<0000?0003
o`0000<000?o0?l00_mM0003o`0004400_l300;o8`02oaT000?o00000`0000l000?o00000`02o`03
0?l001X00_m10003o`0004400_l300;o8`03oaP000?o00000`0000l000?o00001@02oa/00_m10003
o`0000/00_mQ0003o`0001D000?o00000`0000d00ol700;o9002oa@00_l700;o1@02oa8000?o0000
2`02of8000?o000050000ol0000300003`000ol0000700;o8P02oa@00_l700;o1@02oa8000?o0000
L0000ol0000C0003o`0000<0000K0003o`0005T000?o0000L0000ol0000900;o2@000ol000020000
7002oeT000?o0000G`02oa0000?o00002002o`T000?o00000P0001d00_m600;o40000ol0001O00;o
4@000ol0000B0003o`000080000O0003o`0004<00_l@0003o`0007<000?o00004@000ol000020000
8002oeD00omd0003o`00010000?o00000P0001D00_l;00;oD`03odT00_lZ0003o`0000l000?o0000
0P0001@000Co003o2`02oe8000?o0000B@02obX000?o00003`000ol00002000050001?l00?l=0003
o`0004l000?o0000MP000ol0000>0003o`000080000D0004o`00o`h000?o0000CP000ol0001g0003
o`0000h000?o00000@0001@000Co003o3`02odh000?o00009P02oe0000?o00003@000ol000010000
50001?l00?l@00;oC@000ol0000V00;oD@000ol0000<0003o`000040000E00;o4`02od/000?o0000
N@000ol0000200;o20000ol000010000;0000ol000180003o`0007X000Co00000_l80003o`000040
000]0003o`0004L000?o00002002og4000?o00002P000ol000010000;@03odL000?o00002002og80
00?o00002@000ol000010000<0000ol000140003o`0007d000?o00002@01o`400@0003400om30003
o`0007h000?o00002001o`400@0003800_m30003o`0007h000?o00002001o`400@0003@000?o0000
@0000ol0001o0003o`0000L00Ol10040000e00;o?`000ol0000c00;oC0000ol00006007o0@010000
=`02ocd000?o0000<`02odd000?o00001@01o`400@0003L00_lm0003o`0008<000?o00001001o`40
0@0003T00_lk0003o`0008<000?o00001@01o`40000k0003o`3o03P000?o0000Q0000ol00004007o
0@0002L00_l40003o`0000801?l200?o00<0ool0>0000ol000250003o`0000<00Ol100009P001?l0
0?l80004o`00o`D000Co003o=`000ol000260003o`0000800Ol100009P001?l00?l90003o`0000D0
00Go0000o`0f0003o`0008L000Go0000o`0100009P001?l00?l:0004o`0000?o1@02oc@000?o0000
R0001?l00?l100009P001?l00?l;0004o`00o`P00_lc0003o`0008P000Co003o0@0002H000Co003o
20001?l00?l20003o`0000P00_la0003o`0000@00_n30003o`00007o000W00;o2P02o`<01?l900;o
;`000ol0000400;oQ001o`400Ol004H000?o0000;@000ol0002;00;o001700;o;@000ol0002:00?o
00190003o`3o02X000?o0000Q@05o`<0001:00;o:P000ol0002100Co200004/00_lJ00;o3@000ol0
001m00Co300004d000?o00005`02o`d000?o0000N005oa00001>00;o9P000ol0001d00Co5@0004l0
0_lU0003o`0007001?lI0000D@02ob<000?o0000J`05oad0001C00;o8@000ol0001W00Co8P0004<0
0_l40003o`0000800ol30003o`0001l000?o0000H`04obH000120004o`00o`/000Co00000_lI00;o
10000ol0001N00Go:P00048000Co003o2`000ol0000300;o5`02o`@000?o0000FP04obl000120004
o`00o`P00ol70003o`0001/000?o0000E@05oc<000120004o`00o`P000?o00002002oa/000?o0000
D@04ocP000120004o`00o`P000?o00002P02oaT000?o0000C@04oc`0001300;o2@04o`X00_lH0003
o`0004P01Om00000GP001?l00?lD0003o`0004@01?m50000G`000ol0o`0D0003o`0004001?m90000
H002oa<000?o0000?005odd0001R0003o`00010000?o0000>004oe80001S00?o3`000ol0000d00Co
EP0006D000?o00003@000ol0000_00GoFP0006H000?o000030000ol0000[00CoG`0006L00ol;0003
o`0002H01OmS0000J@000ol000090003o`0002801?mX0000EP02o`@000?o00000`000ol0000200Go
2@000ol0000N00CoK00005D000Co003o2@000ol000050004o`3oo`L000?o00006@05og00001E0004
o`00o`X000?o000010001?l00?l70003o`0001D01?me0000E@001?l00?l:0004o`0000?o1002o`03
0?l0008000?o00004@04ogT0001E0004o`00o`/000Co003o2002o`<000?o00003005ogd0001E0004
o`00o`P000Co003o0P000ol0000700;o0P000ol0000800CoPP0005H00_l900Co0P04o`P000?o0?l0
1P04ohH0001d00;o00<0ool00on:0000M@02ohl0003o00L0003o00L0003o00L0003o00L0003o00L0
001b00GoS`0007@000?o0000S`0007@000?o0000S`0007@000?o0000S`0007@000?o0000S`000780
0onA0000M0000ol0002?0000o`070000o`070000o`070000o`070000\
\>"],
  ImageRangeCache->{{{0, 261}, {286, 0}} -> {-0.0206352, -0.0171746, 
  0.00353385, 0.00353385}}]
}, Closed]],

Cell[BoxData[
    \(Clear[data3D]\)], "Input"],

Cell[TextData[{
  "Define a function ",
  StyleBox["grayScatterPlot3D", "Input",
    FontFamily->"Courier"],
  " that accepts a list of 4-tuples (a 4-tuple is an ordered list of four \
numbers), where the fourth argument is a number between 0 and 1 that \
describes the gray level of an ordered triple."
}], "Question"],

Cell["\<\
Here is a function that accepts a 4-tuple and returns a list of \
graphics primitives, the gray level followed by the point at the proper \
location.\
\>", "Text"],

Cell[BoxData[
    \(makePoint[{x_, y_, z_, g_}] := {GrayLevel[g], Point[{x, y, z}]}\)], 
  "Input"],

Cell["Here is a test of the function.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(makePoint[{1, 2, 3, 0.5}]\)], "Input"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{"GrayLevel", "[", 
          StyleBox["0.5`",
            StyleBoxAutoDelete->True,
            PrintPrecision->1], "]"}], ",", "\(Point[{1, 2, 3}]\)"}], "}"}]], 
  "Output"]
}, Closed]],

Cell[TextData[{
  "Here is the function definition. Notice that we include the ",
  StyleBox["PointSize[0.02]", "Input"],
  " directive inside the list given to ",
  StyleBox["Graphics3D", "Input"],
  " to change the size of all points in the graph."
}], "Text"],

Cell[BoxData[
    \(\(grayScatterPlot3D[tuples : {{_, _, _, _}..}] := \n\t
      Show[Graphics3D[{PointSize[0.02], Map[makePoint, tuples]}], 
        Axes \[Rule] True]; \)\)], "Input"],

Cell["Here is a list of 4-tuples.", "Text"],

Cell[BoxData[
    \(\(data4D = Table[Random[], {100}, {4}]; \)\)], "Input"],

Cell["Here is the first element in the list of data.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(First[data4D]\)], "Input"],

Cell[BoxData[
    \({0.897518493825537433`, 0.485120677402118793`, 0.230517014352202975`, 
      0.374460676305849293`}\)], "Output"]
}, Closed]],

Cell["Here is a test of the function.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(grayScatterPlot3D[data4D]; \)\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.08619 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0570368 1.16595 0 1.16595 [
[.09062 .23005 -5.91523 -9 ]
[.09062 .23005 .08477 0 ]
[.21972 .17556 -22.6094 -9 ]
[.21972 .17556 1.39059 0 ]
[.35599 .11808 -16.1684 -9 ]
[.35599 .11808 1.83159 0 ]
[.50003 .05736 -20.5064 -9 ]
[.50003 .05736 3.49365 0 ]
[.65253 -0.00687 -4.86371 -9 ]
[.65253 -0.00687 1.13629 0 ]
[.00949 .82819 -3.46169 0 ]
[.00949 .82819 2.53831 9 ]
[.12121 .90654 -13.4142 0 ]
[.12121 .90654 10.5858 9 ]
[.2214 .97679 -9.78213 0 ]
[.2214 .97679 8.21787 9 ]
[.31174 1.04014 -12.7205 0 ]
[.31174 1.04014 11.2795 9 ]
[.39362 1.09755 -3.1095 0 ]
[.39362 1.09755 2.8905 9 ]
[.07313 .26248 -6 -2.61961 ]
[.07313 .26248 0 6.38039 ]
[.05459 .37905 -24 -2.72281 ]
[.05459 .37905 0 6.27719 ]
[.03442 .50581 -18 -2.83595 ]
[.03442 .50581 0 6.16405 ]
[.01242 .64418 -24 -2.96056 ]
[.01242 .64418 0 6.03944 ]
[-0.0117 .79582 -6 -3.09847 ]
[-0.0117 .79582 0 5.90153 ]
[ 0 0 0 0 ]
[ 1 1.08619 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.08833 .24572 m
.67334 0 L
s
.10078 .2405 m
.10585 .24572 L
s
[(0)] .09062 .23005 .97174 1 Mshowa
.22938 .18648 m
.2342 .19194 L
s
[(0.25)] .21972 .17556 .88412 1 Mshowa
.36507 .12948 m
.36961 .13518 L
s
[(0.5)] .35599 .11808 .79649 1 Mshowa
.50846 .06925 m
.51267 .0752 L
s
[(0.75)] .50003 .05736 .70886 1 Mshowa
.66022 .00551 m
.66407 .0117 L
s
[(1)] .65253 -0.00687 .62124 1 Mshowa
.125 Mabswid
.12596 .22992 m
.12897 .23309 L
s
.1514 .21923 m
.15439 .22242 L
s
.17712 .20843 m
.18008 .21165 L
s
.20311 .19752 m
.20603 .20076 L
s
.25593 .17533 m
.25879 .17863 L
s
.28277 .16405 m
.2856 .16739 L
s
.3099 .15266 m
.3127 .15602 L
s
.33734 .14113 m
.3401 .14452 L
s
.39311 .11771 m
.3958 .12116 L
s
.42147 .1058 m
.42411 .10927 L
s
.45014 .09375 m
.45275 .09726 L
s
.47913 .08157 m
.4817 .08511 L
s
.53812 .0568 m
.54061 .06039 L
s
.56812 .0442 m
.57056 .04782 L
s
.59847 .03145 m
.60087 .0351 L
s
.62916 .01855 m
.63152 .02224 L
s
.25 Mabswid
0 .80555 m
.39871 1.08619 L
s
.01171 .81379 m
.01282 .80658 L
s
[(0)] .00949 .82819 .1539 -1 Mshowa
.12292 .89207 m
.12377 .88483 L
s
[(0.25)] .12121 .90654 .11785 -1 Mshowa
.22266 .96227 m
.22329 .95501 L
s
[(0.5)] .2214 .97679 .0869 -1 Mshowa
.31261 1.02559 m
.31305 1.01831 L
s
[(0.75)] .31174 1.04014 .06004 -1 Mshowa
.39415 1.08298 m
.39442 1.0757 L
s
[(1)] .39362 1.09755 .0365 -1 Mshowa
.125 Mabswid
.03496 .83016 m
.0356 .82583 L
s
.05769 .84616 m
.0583 .84182 L
s
.07992 .8618 m
.08049 .85746 L
s
.10166 .8771 m
.1022 .87276 L
s
.14373 .90671 m
.14421 .90237 L
s
.16409 .92105 m
.16455 .9167 L
s
.18402 .93508 m
.18445 .93073 L
s
.20354 .94882 m
.20395 .94446 L
s
.24138 .97545 m
.24174 .97109 L
s
.25973 .98837 m
.26006 .98401 L
s
.27771 1.00102 m
.27802 .99666 L
s
.29533 1.01343 m
.29562 1.00906 L
s
.32955 1.03751 m
.32979 1.03315 L
s
.34617 1.04921 m
.34639 1.04484 L
s
.36247 1.06068 m
.36267 1.05631 L
s
.37846 1.07194 m
.37864 1.06757 L
s
.25 Mabswid
.08833 .24572 m
0 .80555 L
s
.08658 .25686 m
.0933 .25405 L
s
[(0)] .07313 .26248 1 -0.41786 Mshowa
.06814 .37369 m
.07492 .37102 L
s
[(0.25)] .05459 .37905 1 -0.39493 Mshowa
.04809 .50076 m
.05493 .49823 L
s
[(0.5)] .03442 .50581 1 -0.36979 Mshowa
.02621 .63946 m
.0331 .63711 L
s
[(0.75)] .01242 .64418 1 -0.3421 Mshowa
.00222 .79149 m
.00918 .78932 L
s
[(1)] -0.0117 .79582 1 -0.31145 Mshowa
.125 Mabswid
.08301 .27947 m
.08705 .2778 L
s
.07938 .30244 m
.08343 .30079 L
s
.0757 .3258 m
.07975 .32416 L
s
.07195 .34955 m
.07601 .34792 L
s
.06427 .39824 m
.06834 .39666 L
s
.06033 .42322 m
.06441 .42165 L
s
.05632 .44862 m
.06041 .44707 L
s
.05224 .47446 m
.05634 .47293 L
s
.04387 .52752 m
.04798 .52602 L
s
.03957 .55476 m
.04369 .55328 L
s
.0352 .58248 m
.03932 .58103 L
s
.03074 .61072 m
.03487 .60928 L
s
.02159 .66874 m
.02573 .66735 L
s
.01688 .69857 m
.02103 .6972 L
s
.01208 .72896 m
.01624 .72761 L
s
.0072 .75993 m
.01137 .7586 L
s
.25 Mabswid
.08833 .24572 m
0 .80555 L
s
0 .80555 m
.39871 1.08619 L
s
.39871 1.08619 m
.41651 .58044 L
s
.41651 .58044 m
.08833 .24572 L
s
.67334 0 m
.92702 .41324 L
s
.92702 .41324 m
1 .94832 L
s
1 .94832 m
.70758 .58719 L
s
.70758 .58719 m
.67334 0 L
s
.08833 .24572 m
0 .80555 L
s
0 .80555 m
.70758 .58719 L
s
.70758 .58719 m
.67334 0 L
s
.67334 0 m
.08833 .24572 L
s
.41651 .58044 m
.92702 .41324 L
s
.92702 .41324 m
1 .94832 L
s
1 .94832 m
.39871 1.08619 L
s
.39871 1.08619 m
.41651 .58044 L
s
0 0 m
1 0 L
1 1.08619 L
0 1.08619 L
closepath
clip
newpath
.986 g
.02 w
.53967 .53379 Mdot
.475 g
.52568 .54317 Mdot
.051 g
.40601 .61854 Mdot
.027 g
.70212 .49241 Mdot
.549 g
.69421 .55991 Mdot
.045 g
.65798 .46045 Mdot
.251 g
.459 .43872 Mdot
.832 g
.68488 .5745 Mdot
.304 g
.59149 .56932 Mdot
.911 g
.60249 .72902 Mdot
.338 g
.66263 .43082 Mdot
.633 g
.54051 .7985 Mdot
.897 g
.59178 .74055 Mdot
.069 g
.69096 .48095 Mdot
.575 g
.86881 .50702 Mdot
.743 g
.44848 .75871 Mdot
.324 g
.84565 .45968 Mdot
.268 g
.28704 .54086 Mdot
.484 g
.69929 .55744 Mdot
.767 g
.47713 .86469 Mdot
.746 g
.56171 .44929 Mdot
.283 g
.47699 .8916 Mdot
.875 g
.55814 .38138 Mdot
.789 g
.36347 .71 Mdot
.587 g
.35704 .8088 Mdot
.306 g
.61941 .77484 Mdot
.218 g
.43968 .42572 Mdot
.717 g
.63368 .75466 Mdot
.863 g
.42171 .36897 Mdot
.025 g
.28914 .62216 Mdot
.235 g
.88401 .45427 Mdot
.548 g
.78182 .38604 Mdot
.302 g
.74135 .63399 Mdot
.828 g
.52563 .74927 Mdot
.43 g
.75581 .51962 Mdot
.818 g
.69253 .32741 Mdot
.459 g
.4496 .71046 Mdot
.619 g
.67776 .75565 Mdot
.424 g
.39853 .71827 Mdot
.231 g
.74716 .58841 Mdot
.142 g
.72771 .66775 Mdot
.169 g
.85003 .66485 Mdot
.667 g
.55907 .43622 Mdot
.499 g
.30827 .60178 Mdot
.564 g
.36166 .68362 Mdot
.825 g
.41006 .54755 Mdot
.856 g
.29679 .56989 Mdot
.982 g
.84642 .71356 Mdot
.54 g
.1341 .39585 Mdot
.615 g
.55114 .26761 Mdot
.838 g
.40971 .73698 Mdot
.587 g
.9181 .72017 Mdot
.767 g
.9153 .75232 Mdot
.684 g
.29665 .32855 Mdot
.431 g
.23231 .66604 Mdot
.131 g
.67196 .24363 Mdot
.335 g
.70484 .72151 Mdot
.308 g
.56599 .28285 Mdot
.601 g
.3608 .16968 Mdot
.519 g
.40774 .8287 Mdot
.97 g
.16582 .56067 Mdot
.079 g
.55606 .51121 Mdot
.657 g
.31832 .54083 Mdot
.778 g
.37658 .51725 Mdot
.294 g
.37634 .54691 Mdot
.848 g
.59945 .42417 Mdot
.492 g
.61332 .79274 Mdot
.369 g
.58366 .55634 Mdot
.97 g
.65826 .67445 Mdot
.011 g
.29683 .73648 Mdot
.211 g
.70588 .1956 Mdot
.687 g
.37865 .48146 Mdot
.875 g
.48556 .90889 Mdot
.295 g
.57081 .72455 Mdot
.398 g
.34278 .6446 Mdot
.76 g
.61969 .52495 Mdot
.712 g
.53306 .57477 Mdot
.66 g
.62749 .39711 Mdot
.956 g
.29614 .49647 Mdot
.712 g
.43408 .5262 Mdot
.224 g
.91356 .86855 Mdot
.072 g
.67808 .83688 Mdot
.882 g
.52632 .43812 Mdot
.314 g
.49606 .55359 Mdot
.711 g
.63517 .19073 Mdot
.989 g
.17998 .80681 Mdot
.387 g
.70863 .77895 Mdot
.738 g
.74417 .78834 Mdot
.163 g
.70252 .35536 Mdot
.931 g
.56293 .31746 Mdot
.171 g
.56221 .578 Mdot
.497 g
.67512 .42322 Mdot
.142 g
.61803 .73966 Mdot
.701 g
.60988 .37811 Mdot
.158 g
.69434 .32305 Mdot
.843 g
.38535 .70199 Mdot
.814 g
.5866 .41819 Mdot
.9 g
.65443 .66517 Mdot
.263 g
.72945 .47189 Mdot
.958 g
.7149 .59856 Mdot
0 g
.25 Mabswid
.67334 0 m
.92702 .41324 L
s
.92702 .41324 m
1 .94832 L
s
1 .94832 m
.70758 .58719 L
s
.70758 .58719 m
.67334 0 L
s
.08833 .24572 m
0 .80555 L
s
0 .80555 m
.70758 .58719 L
s
.70758 .58719 m
.67334 0 L
s
.67334 0 m
.08833 .24572 L
s
.08833 .24572 m
.67334 0 L
s
.10078 .2405 m
.10585 .24572 L
s
[(0)] .09062 .23005 .97174 1 Mshowa
.22938 .18648 m
.2342 .19194 L
s
[(0.25)] .21972 .17556 .88412 1 Mshowa
.36507 .12948 m
.36961 .13518 L
s
[(0.5)] .35599 .11808 .79649 1 Mshowa
.50846 .06925 m
.51267 .0752 L
s
[(0.75)] .50003 .05736 .70886 1 Mshowa
.66022 .00551 m
.66407 .0117 L
s
[(1)] .65253 -0.00687 .62124 1 Mshowa
.125 Mabswid
.12596 .22992 m
.12897 .23309 L
s
.1514 .21923 m
.15439 .22242 L
s
.17712 .20843 m
.18008 .21165 L
s
.20311 .19752 m
.20603 .20076 L
s
.25593 .17533 m
.25879 .17863 L
s
.28277 .16405 m
.2856 .16739 L
s
.3099 .15266 m
.3127 .15602 L
s
.33734 .14113 m
.3401 .14452 L
s
.39311 .11771 m
.3958 .12116 L
s
.42147 .1058 m
.42411 .10927 L
s
.45014 .09375 m
.45275 .09726 L
s
.47913 .08157 m
.4817 .08511 L
s
.53812 .0568 m
.54061 .06039 L
s
.56812 .0442 m
.57056 .04782 L
s
.59847 .03145 m
.60087 .0351 L
s
.62916 .01855 m
.63152 .02224 L
s
.25 Mabswid
0 .80555 m
.39871 1.08619 L
s
.01171 .81379 m
.01282 .80658 L
s
[(0)] .00949 .82819 .1539 -1 Mshowa
.12292 .89207 m
.12377 .88483 L
s
[(0.25)] .12121 .90654 .11785 -1 Mshowa
.22266 .96227 m
.22329 .95501 L
s
[(0.5)] .2214 .97679 .0869 -1 Mshowa
.31261 1.02559 m
.31305 1.01831 L
s
[(0.75)] .31174 1.04014 .06004 -1 Mshowa
.39415 1.08298 m
.39442 1.0757 L
s
[(1)] .39362 1.09755 .0365 -1 Mshowa
.125 Mabswid
.03496 .83016 m
.0356 .82583 L
s
.05769 .84616 m
.0583 .84182 L
s
.07992 .8618 m
.08049 .85746 L
s
.10166 .8771 m
.1022 .87276 L
s
.14373 .90671 m
.14421 .90237 L
s
.16409 .92105 m
.16455 .9167 L
s
.18402 .93508 m
.18445 .93073 L
s
.20354 .94882 m
.20395 .94446 L
s
.24138 .97545 m
.24174 .97109 L
s
.25973 .98837 m
.26006 .98401 L
s
.27771 1.00102 m
.27802 .99666 L
s
.29533 1.01343 m
.29562 1.00906 L
s
.32955 1.03751 m
.32979 1.03315 L
s
.34617 1.04921 m
.34639 1.04484 L
s
.36247 1.06068 m
.36267 1.05631 L
s
.37846 1.07194 m
.37864 1.06757 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{265.125, 288},
  ImageMargins->{{35, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004800017`P10`4000010?ooooooc?ooZ_ooI_oo
<ooo0?o<ooo<c?o<VC/k>gYjN[Vi^OShn03ooeGooj[ooonI<onI0?mVoomVc?mVVOmVI_mV<omV0?lc
oclo?ginO[fm_Oclo5D00:X00?l00?l0VOl0I_l0<ol00<coolcoc<coVLcoIP<30d92@X61PL30`000
EED0EJX0EOl0ELbIolbIc<bIVLbII/bI<lbI0<aVolaVc0L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0Z/`c
<l`c0<`0ol`0c<`0VL`0I/`0<l`000/;2dY:BXV9RLS8b000oeD0ojX0ool0oiW<VIW<IYW<<iW<09VI
oiVIc9VIVIVIIPl?3di>CXf=SLc<c01E05EE0:YE0?mE09TcoiTcc9TcVITcIYTc<iTc09T0oiT0c1<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEEFKo<fKo06K<ofK<c6K<VFK<IVK<<fK<01LG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZVIVVFIVIVIV<fIV06HcofHcc6HcVFHcIQ/K6eYJFYVIVMSHf01EoeEEojYEoomEoc?o
oc?oc3?oVC?oIS?o<c?o03?<oc?<c1lO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ03>I<c>I03=Voc=Vc3=V
VC=VIS=V<c=V02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZEC<0VC<0IS<0<c<0003oo`3oc03oV@3oIRLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2Io`2Ic02IV@2IIP2I<`2I001Vo`1Vc2/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`0c<`0c0000o`00c000V@00IP00<nh002l_;fi^KZf][Nc/k03o05Go0:[o0?oo0140
003^003M002k002Z0028001g001E03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@00M`00E@00A0008P00
4Nk^k]gMgK^k^cLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l02@000?l02@000:l01OmD0000/@000ol0
001D0000/@000ol0001D0000/@000ol0001D0000/@000ol0001D0000[`03oeH0002a0003o`0005@0
003o00T0003o00T0003o00T0002f00;oD0000;<00ol00`3o001?0000/@02o`8000Co0?ooC`000:l0
0_l60003o`3o04h0002/00?o20000ol0o`1>0000N`02o`@000?o00000`000ol0000200?o6`02o`03
0?l000P000Co003oC@0007X000Co003o2@000ol000050003o`0001D00ol=0004o`00odd0001j0004
o`00o`X000?o000010000ol0000C00;o40001Ol0003o04`0001j0004o`00o`X000Co00000olD00;o
00<0o`003`000ol000020003o`0004T0001j0004o`00o`/000Co003o4`03oaD000Go0000o`1;0000
NP001?l00?l80004o`00o`8000?o00003`02oaP000?o00000P000ol000180000N`02o`T01?l200Co
3002o`030?l001L000?o00000`000ol000170000V@03oa`000?o00000`000ol000170000U`02oal0
00?o000010000ol000160000U004ob0000?o000010000ol000160000TP02ob@000?o00001@000ol0
00150000T002obH000?o00001P000ol000140000S@04obL000?o00001P000ol000140000R`02o`@0
00?o000090000ol000070003o`0004<0002800?o;@000ol000070003o`0004<0001L00;o10000ol0
000200?o7002o`030?l002d000?o000020000ol000120000F`001?l00?l;0003o`0001L00_lb0003
o`0000T000?o0000@@0005/000Co003o2`000ol0000D00?o=0000ol000090003o`000440001K0004
o`00o`P00olE00;o00<0o`00=0000ol0000:0003o`000400001K0004o`00o`P000?o00004P03ocT0
00?o00002`000ol0000o0000F`001?l00?l80003o`0001000_lm0003o`0000X000?o0000?`0005`0
0_l900Co3@02o`030?l003`000?o00002`000ol0000n0000M@03od4000?o00002`000ol0000n0000
L`02od@000?o000030000ol0000m0000L003o`030?l004<000?o00003@000ol0000l0000KP02odT0
00?o00003@000ol0000l0000K002od/000?o00003P000ol0000k0000J@03o`8000?o0000B0000ol0
000?0003o`0003X0001W00;oD0000ol0000?0003o`0003X0000e00;o10000ol0000200Co0P03oa`0
0omA0003o`00010000?o0000>@0003@000Co003o20001?l00?l50003o`0001H00omD0003o`000100
00?o0000>@0003@000Co003o2@000ol000050003o`0001<00omG0003o`00014000?o0000>00003@0
00Co003o2P001?l00003oa@01?mH0003o`00018000?o0000=`0003@000Co003o2`001?l00?lD00;o
G0000ol0000B0003o`0003L0000d0004o`00o`P000Co003o0P000ol0000@00;o4002ET`000?o0000
4`000ol0000f0000=@02o`X00_l300Co3003o`030?l000h015I<0003o`00018000?o0000=P0005@0
0_lD00AFC0000ol0000C0003o`0003D0001A00?o5`02ETd000?o000050000ol0000d0000C`02o`80
00?o0000I0000ol0000D0003o`0003@0001=00;oJ`000ol0000E0003o`0003<0001:00?oH002nP/0
00?o00005P000ol0000b0000B002o`<000?o0000G004nPX000Co00000_PC0003o`000380000V00;o
7@03of@01?X:0003o`0000Ch4`000ol0000a00009@001?l00?lJ00;o00<0o`00I@02nP/000?o0000
1?PC0003o`000340000U0004o`00oaP00_mg0004o`0000;h5@000ol0000`00009@001?l00?lE00?o
N@000ol0000I0003o`0002l0000U0004o`00oa<00_l20003o`0007L000?o00006@000ol0000_0000
9@001?l00?lA00;oOP000ol0000J0003o`0002h0000V00;o3`04ogl000?o00006`000ol0000]0000
=@02oh<000?o00006`000ol0000]0000<P03ohD000?o000070000ol0000/0000<002o`8000?o0000
Q0000ol0000K0003o`0002`0000^00;oQP02Z0<000?o000070000ol0000[0000:`03ohL01:P20003
o`0001d000?o0000:P0002X000Go0000o`2600BX0P000ol0000M0003o`0002X0000Z0003o`0008T0
0ZP30003o`0001h000?o0000:@0002X00_n?0003o`0001l000?o0000:00002T00_l00`3o002=0003
o`0001l000?o0000:00002800_l50005o`000?l0J`02VR0000?o000080000ol0000W00008@001?l0
0?l40003o`00008000?o0000I`04VQl000?o000080000ol0000W00008@001?l00?l40003o`0000<0
00?o0000IP04VQl000?o00008@000ol0000V00008@001?l00?l40003o`0000@000?o0000IP02VR00
00?o00008P000ol0000U00008@001?l00?l400;o1P000ol0001Y009I70000ol0000R0003o`0002D0
000Q0004o`00o`@000?o00001P000ol0001W00AI6`000ol0000S0003o`0002@0000R00;o10000ol0
00080003o`0006H015TK0003o`0002<000?o0000900002P000?o00002@000ol0001V009I70000ol0
000T0003o`0002<0000X0003o`0000X000?o0000P`000ol0000U0003o`000280000X00;o30000ol0
00230003o`0002@000?o00008P0002P000?o000030000ol000220003o`0002D000?o00008@0002P0
00?o00003@000ol000210003o`0002H000?o0000800002L000?o00003`000ol0001P00;e7P000ol0
000V0003o`000200000W0003o`00010000?o0000GP04mAd000?o00009`000ol0000O00009`000ol0
000A0003o`0005d01?DM0003okP002L000?o00007`0002L00_lC0003o`0001`00]Xo00;e7@001;So
^;PX0003o`0001h0000W0003o`0001<000?o00006P04fU`000=[^?l00[PY0003o`0001d0000W0003
o`0001@000?o00006@04fU`00V/00onh000Y0003o`0001d0000V0003o`0001H000?o00006@02fUh0
00=[o`00:`000ol0000L00009P000ol0000G0003o`0007T000?o0000:`000ol0000K00009P000ol0
000H0003o`0007P000?o0000:`000ol0000K00009P02oaX000?o0000M`001?l0b<P[0003o`0001X0
000V0003o`0001X000?o0000MP000oo8b002b2X000?o00006P0002H000?o00006`000ol0001e0003
olS800;8:`000ol0000I00009P000ol0000L0003o`0007@000Co0<S8;@000ol0000H00009@000ol0
000N0003o`0003400Y]10003o`0002d000?o0000600002D00olO0003o`0002l019]00003o`0002h0
00?o00005`0002D000?o000080000ol0000^00BK:P02nQ@000?o0000;P000ol0000G00003002o`@0
00?o00000P04o`800ol50003o`00024000?o0000;P02Val00_H900Cj4`000ol0000_0003o`0001H0
000;0004o`00o`P000Co003o1@000ol000020003o`00028000?o0000C@04mPP01?XC0003o`000140
0UXM0003o`0001D0000;0004o`00o`T000?o00001@000ol000020003o`0002<000?o0000C004mPT0
0_XD0003o`00010015XL0003o`0001D0000;0004o`00o`X000Co00000ol40003o`0000d00TXF0003
o`0004`00_HP0003o`00010015XM0003o`0001@0000;0004o`00o`/000Co003o1P000ol0000<00A:
5P000ol0001K00;:40000ol0000A009J7`000ol0000C00002`001?l00?l80004o`00o`8000?o0000
1002o`d014XG0003o`0005T01<X?0003o`00038000?o00004`0000`00_l:00;o0`04o`<000?o0000
3@02BQT000?o0000F004bPl000?o0000<`000ol0000B000090000ol0000Y0003o`0005P00/X@0003
o`0003<000?o00004P0002@000?o0000:P000ol0001Y0003o`0003@000?o00004@0002<000?o0000
;0000ol0001=009[6@000ol0000c00?o4P0002<000?o0000;0000ol0000Y00;h8@04J`:;40026P@0
00?o0000<003o`8000?o0000400002<00_l^0003o`0002L01?PP00A[0h/>00@J0`000ol0000]00?o
1@000ol0000@00008`000ol0000^0003o`0002H01?PQ009[18/<009i11X30003o`0002X00ol80003
o`000100000S0003o`0002l000?o00009P02n1<00Z/600:n2002R``017T26PD000?o00009P03o`/0
00?o0000400002<000?o0000<0000ol0000Z008Y3@04Z`@01;hE00Ai1`000ol0000S00?o3`000ol0
000?00008P000ol0000b0003o`0002P012T<00B[1004_QH00WT80003o`0002000olB0003o`0000l0
000R0003o`0003<000?o00009`04:@d00Z/600:n00<K00007P000ol0000M00?o5@000ol0000?0000
8P02ocD000?o00009`02:AH011/O0003o`0001X00ol<00892P000ol0000?00008P000ol0000e0003
o`0003h011/O0003o`0001L00ol>00@92@000ol0000?00008P000ol0000f0003o`0003h00Q/E0098
2@000ol0000C00Co2002J@L010T90003o`0000l0000R0003o`0003L000?o0000D`04B0P000?o0000
4003o`/016T700892P000ol0000?00008@000ol0000i0003o`00058014P80003o`0000d00ol>00AY
50000ol0000>00008@000ol0000j0003o`0005800TP90003o`0000<00RT500?o4P02JAD000?o0000
3P0002400_ll0003o`0005`000?o00000P04:@040?ooob`000?o00003P00024000?o0000?0000ol0
000<00;JBP02J0030?l000<012T00ol0000]0003o`0000h0000Q0003o`0003d000?o00002P04fTP0
16P01?l00002o`8Y<@000ol0000>00008@000ol0000n0003o`0000T01=Y800AX1?le0003o`0000h0
000P0003o`00040000?o00002@02fTX00VP2o`03>00003D000?o00003P00020000?o0000>002n`L0
00?o0000DP03o`0503PhocP0=`000ol0000=00008003ocL01?/70003o`0004d01?l4008h00?o>000
=P000ol0000=00003@02o`@000?o00000P03o`D000?o0000=`04n`P000?o0000B@03o`T000<ho`00
9@02JQ0000?o00003@0000`000Co003o2`000ol000020003o`0003P00_/:0003o`0003000VPC00?o
3@000ol0000S00AZ3`000ol0000=000030001?l00?l;0003o`00008000?o0000A@000ol0000^00AX
3`03oa0000?o00008`04JPl000?o00003@0000`000Co003o2003o`@000?o0000A`000ol00003009;
:004J0`00olC0003o`0000T00]TI009Z40000ol0000=000030001?l00?l80003o`0000@000?o0000
B0001?l00004BbP00VP:00?o00<0:b/04`000ol0000800CI:P000ol0000=000030001?l00?l80003
o`0000@000?o0000B@000ol00004B`/00_XT00?o0`04:a8000?o00002004fB/000?o0000300000d0
0_l900Co0`02od/000?o00000T/;00Cj8003o`H012/B0003o`0000T00]T/0003o`0000`0000O0003
o`0004/000?o00003004nQH00Q`500?o2P02:a<000?o0000=`000ol0000<00007`000ol0000g008Y
1P02bP/000?o00003002nQH011`0103ooolR0003o`0003L000?o0000300001l000?o0000=P04:@@0
1<X;0003o`0002400PX47003o`0002<000?o0000=`000ol0000<00007P000ol0000g00@Y1004bP/0
0TT6009k6@042P8L9`000ol0000g0003o`0000`0000N0003o`0003P00RT600;:2`04B@@017/B009Y
0P02o`@::@000ol0000g0003o`0000`0000N00;oCP04B@04o`0000Ak4@04J@04o`00008:3002VAX0
0PX00ol0000h0003o`0000/0000N0003o`0001/00P`a00990P001?l00002Na4000?oJFT00VTA00BI
60032P03o`0003P000?o00002`0001h000?o00006P0433D000?o00004003o`800VTB00BI5`000eX:
2P022P03o`0003L000?o00002`0001h000?o00006P0431`00Y/H0003o`0000`00olJ00:I0UTF009J
0PX00`3o000h0003o`0000/0000M0003o`0001`00P`L00BK60000ol0000800?o4@02nP/015TC009k
00<0FUX00P000ol0000g0003o`0000/0000M0003o`0003X019/I0003o`0000@00olC00Cj1002b0@0
15TB00Ak10000ol0000g0003o`0000/0000M0003o`0003/00Y/K0003o`0000?o5P04nP<01<P4009I
4`04N`@000?o0000=`000ol0000;00007@02oeX00_lJ00;j1004b1X00W/50003o`0003P000?o0000
2P0001d000?o0000F@000ol0000P00;88P000ol000050089<@000ol0000:00007@000ol0001I0003
o`0004800ol600@9<0000ol0000:000070000ol0001J0003o`0003l00ol20003oo_k00@010T`0003
o`0000X0000L0003o`0003l00QXI0003o`0003`00ol50004nookn`@00PTa0003o`0000X0000L0003
o`0003h011XH0003o`0003P01?l800;k00?on`00=P000ol0000:000070000ol0000n00@J60000ol0
000e00?o3@02n`03o`0003D000?o00002P0001`00_m0008J6@000ol0000b00?o4`000ol0000d0003
o`0000X0000L0003o`0005L00TP00`3o000_00Co5P000ol0000e0003o`0000T0000K0003o`0003`0
0SPI00A800?o0000:`03oa/000?o0000=0000ol0000900006`000ol0000k00@h6004B003o`0002P0
0olO0003o`0003<000?o00002@0001/000?o0000>`04>1T00TP00`3o000V00?o8`000ol0000b0003
o`0000T0000K0003o`0003`00SPM0003o`0002401?lV0003FOl0038000?o00002@0001/000?o0000
F`000ol0000N00?o:@03F@03o`00030000?o00002@0001/00om900:140000ol0000K00?o;003F@03
o`00030000?o00002@0000800_l40003o`0000<000?o00000P03o`@000?o0000B@04P@l000?o0000
5`04oc000UT00`3o000a0003o`0000P000001@3o003o00T000?o00001@001Ol0003o04/0184>0003
o`0001D00olh0003o`0002l000?o0000200000050?l00?l02P000ol000040005o`000?l0C002P@l0
00?o00004P03oc`000?o0000;P000ol00008000000D0o`00o`0:0004o`0000?o10000ol0001K0003
o`0000h01?m00003o`0002d000?o0000200000050?l00?l02`001?l00?l60003o`0005/000?o0000
2`03obT00//I0003o`0001400/PJ0003o`0000P000001@3o003o00P000Co003o0P000ol000040003
o`0002l00]TZ0003o`0000P00ol[00C;3`02Z0P000?o00003`04b1T000?o0000200000800_l900Co
0P04o`800ol_00CI:@000ol0000400Co;P04b`h01:P80003o`0000h01<PI0003o`0000P0000I0003
o`0002l01=TY0004o`0000?o<`02b`03300000`01:P90003o`0000h00/PK0003o`0000L0000I0003
o`0003000]TZ00Co=P0430h00ZP;0003o`0002X000?o00001`0001T000?o0000C`02JPT00oli00@<
70000ol0000Y0003o`0000L0000I0003o`0004h016X400Co0P000ol0000h008<7@000ol0000Y0003
o`0000L0000I0003o`0004h016X0103oool60003o`0005P000?o0000:0000ol00007000060000ol0
001@0004J_ooo`T000?o0000F@000ol0000W0003o`0000L0000H0003o`3o04d01?l500:;1@000ol0
001J0003o`0002H000?o00001`0001P00_m;00?o2004R`@000?o0000F`000ol0000V0003o`0000H0
000H0003o`0004L00ol7009;0P04R`@000?o00001@02nE@000?o00009P000ol00006000060000ol0
001300Co2@04B`800X/50003o`0000@01?UD0003o`0000H00Q`M0003o`0000H0000H0003o`000400
0ol=00A;1@02f@8000?o00001004nED000?o0000100471`000?o00001P0001P000?o0000?@03oa40
0T/500CI00<0o`001P02nC`00VdI0003o`0000<011`?009j2`000ol0000600005`000ol0000j00Co
6`04f@030?l002@00TTM00A]6@000ol00003008L3`04NPX000?o00001P0001L000?o0000=`03ob00
0]T20003o`00028014T400;;5P04KAX000?o00004`04NPX000?o00001P0001L00_le00?o9`000ol0
000R00A90`04baH00VdK0003o`0001@00WX<0003o`0000D0000G0003o`0003400ol=008X6P02NbD0
0TT400C;00<0Z:P0<@000ol0000Q0003o`0000D0000G0003o`0002d01?l?00@X6004NbT00[/2b`03
0:RX00:X<@000ol0000P0003o`0000D0000G0003o`0002X00olC00@X6004NbP01;/200BX<P000ol0
000O0003o`0000D0000F0003o`0002P00olG008X6P02NaX00W/=00Bk0`02Z3@000?o00003`02>`d0
00?o00001@0001H000?o00009004ocL000?o00005`04N`d00[/8008;2@02VRD000?o00003P04>``0
00?o00001@0001H000?o00008@03oc/000?o00001@026a0017/F00@;1`04VRD000?o00003@04>``0
00?o00001@0001H00_lO00?o?P000ol0000400@K4002NaL010/700BJ9P000ol0000=008k3P000ol0
000400005P000ol0000J00Co@@000ol0000400@K:P022`T00YXX0003o`0001`000?o0000100001H0
00?o00005`03odD000?o00001@026f4000?o00006`000ol0000400005@000ol0000E00?oB0000ol0
000_009I>0000ol0000J0003o`0000@0000E0003o`0001401?m:0003o`0002l015TB00:Y8`000ol0
000J0003o`0000@0000E0003o`0000h00om>0003o`0002l015TA00BY8`000ol0000I0003o`0000@0
000E0003o`0000/00omA0003o`0003000UTB00BY1P026a`000?o000060000ol0000400005@000ol0
000800?oE0000ol0000^008J5@02Z@H011/L0003o`0001L000?o0000100000d01Ol300?o1004oeL0
00?o0000;@046Q`011/M0003o`0001L000?o00000`0000l000?o00000P000ol0000200?oF`000ol0
000L00:Z3`046Qd00Q/N0003o`0001L000?o00000`0000l000?o00000P000ol0o`02oeh000?o0000
6`04ZPl00QXo0003o`0001H000?o00000`0000l000?o00000P02obT00Q`Y009j2`000ol0000K00BZ
D@000ol0000E0003o`0000<0000?0003o`0000@000?o0?l09@0472L017X:0003o`0001`00ZYC0003
o`0001@000?o00000`0000d00ol700;o9@0472L017X:0003o`00078000?o00004`000ol000030000
3`000ol000070003o`0002<00Q`Y009j2`000ol0001b0003o`0001<000?o00000`0001X000?o0000
FP000ol0001c0003o`0001<000?o00000P0001/00omH008jMP000ol0000B0003o`000080000M0003
o`0005D013Yf0003o`00014000?o00000P0001h00_mE00@j?`02J3H000?o000040000ol000020000
80000ol0001C008j?`04J3H000?o00003`000ol0000200005@02o`X00omC0003o`0003d016Pf0003
o`0000l000?o00000P0001@000Co003o2P02oe<000?o0000?P02J3P000?o00003P000ol000020000
50001?l00?l<0003o`00050000?o0000N@000ol0000>0003o`000040000D0004o`00o`d00_m@0003
o`0007X000?o00003@000ol00001000050001?l00?l?00;oCP000ol0001k0003o`0000`000?o0000
0@0001@000Co003o4002odd000?o00003@02>f`000?o000030000ol0000100005@02oa<000?o0000
BP000ol0000<00@kI`022@<000?o00002`000ol000010000:`02odX000?o00003004>fH010T30003
o`0000X000?o00000@0002d000?o0000A`000ol0000=008kI`042@@000?o00002@000ol000010000
;@02odP000?o0000M`022@H000?o00002@01o`400@0002l00_m60003o`00080000?o00002001o`40
0@0003400_m40003o`0000d00SUa0003o`0000P00Ol10040000b00;o@`000ol0000<00@iL@000ol0
0007007o0@010000=0000ol000100003o`0000`013Ub0003o`0000H00Ol10040000e00;o?`000ol0
000>008iM0000ol00005007o0@010000=`000ol0000l0003o`0001000_Ic0003o`0000@00Ol10040
000g00;o?@000ol0000?00CfLP000ol00005007o0@0003T00_lk0003o`0000l01?Ic0003o`0000@0
0Ol10000>`02ocT000?o00004002mWD000?o00000`01o`40000V00;o10000ol0000200Co0P03o`80
0_lh0003o`0008P000?o00000P01o`40000U0004o`00o`P000Co003o1@001Ol0003o03L000?o0000
R@001Ol0003o0040000U0004o`00o`T000?o00001@000ol0000200;o=@000ol0002:0004o`00o`40
000U0004o`00o`X000Co00000ol70003o`00038000?o0000RP001?l00?l100009@001?l00?l;0004
o`00o`T00_lc0003o`0008/000?o00000Ol002D000Co003o20001?l00?l20003o`0000T00_la0003
o`0008`00Ol1007o000V00;o2P02o`<01?l:00;o;`000ol0002=00;o001600;o;P000ol0002<00?o
00180003o`0002/000?o0000Q`05o`<000190003o`3o02X000?o0000P`04o`P0001:00;o:P000ol0
001o00Co300004`000?o00009`000ol0001j00Go400004d00_lW0003o`0007H01?lE0000C`000ol0
000T0003o`0007401OlI0000C`03ob@000?o0000K@04oah0001B0003o`00024000?o0000J005ob80
001C0003o`00020000?o0000I004obL0001200;o10000ol0000200?o0`03ob0000?o0000H004ob/0
00110004o`00o`/000?o00000`000ol0000M0003o`0005/01Ol_0000@@001?l00?l;0003o`0000@0
0_lM0003o`0005L01?ld0000@@001?l00?l800?o2002oa`000?o0000DP05ocP000110004o`00o`P0
00?o00002P02oaX000?o0000CP04ocd000110004o`00o`P000?o000030000ol0000G0003o`0004T0
1Om10000@P02o`T01?l;00;o60000ol0001500CoAP0005h00olE0003o`0004401?m:0000H0000ol0
000C0003o`0003`01Om>0000H003oa8000?o0000>@04oe<0001S0003o`0000l000?o0000=005oeL0
001T00;o3`000ol0000`00CoG00006@000?o0?l03P000ol0000[00GoH00006L00_l<0003o`0002L0
1?mU0000J002o`/000?o00008`04ofT0001E00;o10000ol000030003o`0000800ol00`3o00090003
o`0001h01Om]0000E0001?l00?l90003o`0000D000Co0?oo20000ol0000J00CoLP0005@000Co003o
2P000ol000040003o`0000;o1`000ol0000E00GoMP0005@000Co003o2P001?l00003o`D00_l50003
o`0001401?mk0000E0001?l00?l;0004o`00o`T000?o00000P000ol0000<00GoO`0005@000Co003o
20001?l00?l20003o`0000L00_l30003o`0000P01?n40000E@02o`T01?l200Co2004o`H01?n80000
M002o`030?oo00?oS00007@00onA0000o`090000o`090000o`090000o`090000o`090000LP05oi40
001d0003o`000940001d0003o`000940001d0003o`000940001d0003o`000940001b00?oT`0007@0
00?o0000T@000001\
\>"],
  ImageRangeCache->{{{0, 263}, {286, 0}} -> {-0.0254902, -0.0390763, 
  0.00354404, 0.00354404}}]
}, Closed]],

Cell[BoxData[
    \(Clear[data4D]\)], "Input"],

Cell["\<\
Define a function that accepts a list of lists, and returns a list \
of the averages of each of the sublists.\
\>", "Question"],

Cell[TextData[{
  "To compute the average of one list, we use ",
  StyleBox["Apply", "Input"],
  "."
}], "Text"],

Cell[BoxData[
    \(\(thelist = {a, b, c}; \)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Apply[Plus, thelist]/Length[thelist]\)], "Input"],

Cell[BoxData[
    \(1\/3\ \((a + b + c)\)\)], "Output"]
}, Closed]],

Cell["\<\
To compute the average of each sublist in a list, we map the \
previous procedure over a list of lists.\
\>", "Text"],

Cell[BoxData[
    \(avgone[onelist_] := Apply[Plus, onelist]/Length[onelist]\)], "Input"],

Cell[TextData[{
  "The repeated pattern ",
  StyleBox["L:{_List..}", "Input"],
  " matches a list containing one or more lists."
}], "Text"],

Cell[BoxData[
    \(averages[L : {_List..}] := Map[avgone, L]\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(averages[{{1, 1, 2, 3, 5, 8, 13, 21}, {a, b, c}, {1, a, 2, b, 3}}]\)], 
  "Input"],

Cell[BoxData[
    \({27\/4, 1\/3\ \((a + b + c)\), 1\/5\ \((6 + a + b)\)}\)], "Output"]
}, Closed]],

Cell[TextData[{
  "Use ",
  StyleBox["Outer", "Input"],
  " to generate every possible pair of elements (for simplicity, allowing \
repeated pairs) from the list ",
  StyleBox["{a,b,c,d,e}", "Input"],
  "."
}], "Question"],

Cell[TextData[{
  "The following command takes one element from each copy of the list, giving \
each pair the head ",
  StyleBox["List", "Input"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(allpairs = Outer[List, {a, b, c, d, e}, {a, b, c, d, e}]\)], "Input"],

Cell[BoxData[
    \({{{a, a}, {a, b}, {a, c}, {a, d}, {a, e}}, {{b, a}, {b, b}, {b, c}, {b, 
          d}, {b, e}}, {{c, a}, {c, b}, {c, c}, {c, d}, {c, e}}, {{d, a}, {d, 
          b}, {d, c}, {d, d}, {d, e}}, {{e, a}, {e, b}, {e, c}, {e, d}, {e, 
          e}}}\)], "Output"]
}, Closed]],

Cell[TextData[{
  "One way to remove duplicates is to use ",
  StyleBox["Flatten", "Input"],
  " and ",
  StyleBox["DeleteCases", "Input"],
  ". If we flatten the list (remove all the inner brackets) and then \
partition the result into lists of length two, we get a list of all the \
pairs."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Partition[Flatten[allpairs], 2]\)], "Input"],

Cell[BoxData[
    \({{a, a}, {a, b}, {a, c}, {a, d}, {a, e}, {b, a}, {b, b}, {b, c}, {b, 
        d}, {b, e}, {c, a}, {c, b}, {c, c}, {c, d}, {c, e}, {d, a}, {d, b}, {
        d, c}, {d, d}, {d, e}, {e, a}, {e, b}, {e, c}, {e, d}, {e, e}}\)], 
  "Output"]
}, Closed]],

Cell[TextData[{
  StyleBox["Flatten[allpairs, 1]", "Input"],
  " also removes the brackets from the first level of ",
  StyleBox["allpairs", "Input"],
  ", leaving the deeper list brackets intact."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Flatten[allpairs, 1]\)], "Input"],

Cell[BoxData[
    \({{a, a}, {a, b}, {a, c}, {a, d}, {a, e}, {b, a}, {b, b}, {b, c}, {b, 
        d}, {b, e}, {c, a}, {c, b}, {c, c}, {c, d}, {c, e}, {d, a}, {d, b}, {
        d, c}, {d, d}, {d, e}, {e, a}, {e, b}, {e, c}, {e, d}, {e, e}}\)], 
  "Output"]
}, Closed]],

Cell[TextData[{
  "Once we have a list containing just the collection of pairs (with no extra \
list brackets), we can remove duplicates using ",
  StyleBox["DeleteCases", "Input"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(nonmatchingpairs = DeleteCases[%, {x_, x_}]\)], "Input"],

Cell[BoxData[
    \({{a, b}, {a, c}, {a, d}, {a, e}, {b, a}, {b, c}, {b, d}, {b, e}, {c, 
        a}, {c, b}, {c, d}, {c, e}, {d, a}, {d, b}, {d, c}, {d, e}, {e, a}, {
        e, b}, {e, c}, {e, d}}\)], "Output"]
}, Closed]],

Cell[TextData[{
  "If the order of elements in a pair is unimportant, we can remove pairs \
that contain the same elements regardless of order by first sorting each \
pair, then removing duplicates with ",
  StyleBox["Union", "Input"],
  ". Here we map ",
  StyleBox["Sort", "Input"],
  " over the list of pairs, which sorts each pair."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Map[Sort, nonmatchingpairs]\)], "Input"],

Cell[BoxData[
    \({{a, b}, {a, c}, {a, d}, {a, e}, {a, b}, {b, c}, {b, d}, {b, e}, {a, 
        c}, {b, c}, {c, d}, {c, e}, {a, d}, {b, d}, {c, d}, {d, e}, {a, e}, {
        b, e}, {c, e}, {d, e}}\)], "Output"]
}, Closed]],

Cell["\<\
Taking the union of the resulting list with itself removes matching \
pairs.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Union[%]\)], "Input"],

Cell[BoxData[
    \({{a, b}, {a, c}, {a, d}, {a, e}, {b, c}, {b, d}, {b, e}, {c, d}, {c, 
        e}, {d, e}}\)], "Output"]
}, Closed]],

Cell[TextData[{
  "As expected, there are ",
  Cell[BoxData[
      FormBox[
        StyleBox[
          RowBox[{"(", GridBox[{
                {"5"},
                {"2"}
                }], ")"}],
          SpanMaxSize->Infinity], TraditionalForm]]],
  " distinct pairs."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Length[%] == Binomial[5, 2]\)], "Input"],

Cell[BoxData[
    \(True\)], "Output"]
}, Closed]],

Cell[TextData[{
  "Use ",
  StyleBox["Outer", "Input"],
  " to create a list of strings that look like the binary numbers 000, 001, \
010, 011, ..., 111."
}], "Question"],

Cell[TextData[{
  "We first consider the easier problem of creating the four pairs 00, 01, \
10, and 11. We want to create a list of all pairs formed by choosing one \
element from a list ",
  StyleBox["{0, 1}", "Input"],
  " followed by one element from a second list ",
  StyleBox["{0, 1}", "Input"],
  ". To begin, we give each pair the generic head ",
  StyleBox["f", "Input"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Outer[f, {0, 1}, {0, 1}]\)], "Input"],

Cell[BoxData[
    \({{f[0, 0], f[0, 1]}, {f[1, 0], f[1, 1]}}\)], "Output"]
}, Closed]],

Cell[TextData[
"Because we want to create strings, we replace the digits 0 and 1 with the \
strings \[OpenCurlyDoubleQuote]0\[CloseCurlyDoubleQuote] and \
\[OpenCurlyDoubleQuote]1\[CloseCurlyDoubleQuote]."], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Outer[f, {"0", "1"}, {"0", "1"}]\)], "Input"],

Cell[BoxData[
    \({{f["0", "0"], f["0", "1"]}, {f["1", "0"], f["1", "1"]}}\)], "Output"]
}, Closed]],

Cell[TextData[{
  "To concatenate each pair of strings, we replace the head ",
  StyleBox["f", "Input"],
  " with the function ",
  StyleBox["StringJoin", "Input"],
  ", which returns the desired list of strings."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Outer[StringJoin, {"0", "1"}, {"0", "1"}]\)], "Input"],

Cell[BoxData[
    \({{"00", "01"}, {"10", "11"}}\)], "Output"]
}, Closed]],

Cell[TextData[{
  "To generate the list of three-digit binary numbers, we include in ",
  StyleBox["Outer", "Input"],
  " a third copy of the list ",
  StyleBox["{\"0\",", "Input"],
  " ",
  StyleBox["\"1\"}", "Input"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Outer[StringJoin, {"0", "1"}, {"0", "1"}, {"0", "1"}]\)], "Input"],

Cell[BoxData[
    \({{{"000", "001"}, {"010", "011"}}, {{"100", "101"}, {"110", "111"}}}\)],
   "Output"]
}, Closed]],

Cell["\<\
Removing the inner braces from the previous list will give us a \
flat list of the desired strings.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Flatten[%]\)], "Input"],

Cell[BoxData[
    \({"000", "001", "010", "011", "100", "101", "110", "111"}\)], "Output"]
}, Closed]],

Cell[TextData[{
  "Beginning with the string \"",
  StyleBox["F",
    FontFamily->"Courier"],
  "\", use ",
  StyleBox["Nest", "Input",
    FontFamily->"Courier"],
  " and ",
  StyleBox["StringReplace", "Input",
    FontFamily->"Courier"],
  " to iterate the rule that replaces every occurrence of \"",
  StyleBox["F",
    FontFamily->"Courier"],
  "\" in a string with \"",
  StyleBox["F+F--F+F",
    FontFamily->"Courier"],
  "\", three times."
}], "Question"],

Cell[TextData[{
  "Here is one call to the function ",
  StyleBox["StringReplace", "Input"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(StringReplace["F", "F" \[Rule] "F+F--F+F"]\)], "Input"],

Cell[BoxData[
    \("F+F--F+F"\)], "Output"]
}, Closed]],

Cell["\<\
Here is a function that carries out the replacement for any string.\
\
\>", "Text"],

Cell[BoxData[
    \(srep[s_String] := StringReplace[s, "F" \[Rule] "F+F--F+F"]\)], "Input"],

Cell[TextData[{
  "To iterate the replacement we use ",
  StyleBox["Nest", "Input"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Nest[srep, "F", 3]\)], "Input"],

Cell[BoxData[
    \("F+F--F+F+F+F--F+F--F+F--F+F+F+F--F+F+F+F--F+F+F+F--F+F--F+F--F+F+F+F--\
F+F--F+F--F+F+F+F--F+F--F+F--F+F+F+F--F+F+F+F--F+F+F+F--F+F--F+F--F+F+F+F--F+\
F"\)], "Output"]
}, Closed]],

Cell[TextData[{
  "Create a one-dimensional random walk using ",
  StyleBox["NestList", "Input",
    FontFamily->"Courier"],
  "."
}], "Question"],

Cell["We begin with a height value of zero.", "Text"],

Cell[BoxData[
    \(\(height = 0.0; \)\)], "Input"],

Cell[TextData[{
  "Here is a function that adds a random number between ",
  Cell[BoxData[
      \(TraditionalForm\`\(-1\)\)]],
  " and 1 to its argument."
}], "Text"],

Cell[BoxData[
    \(step1d[x_] := x + Random[Real, {\(-1\), 1}]\)], "Input"],

Cell[TextData[{
  "If we use ",
  StyleBox["Nest", "Input"],
  " to iterate this function, we find the final position of the random walk."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Nest[step1d, 0.0, 500]\)], "Input"],

Cell[BoxData[
    \(\(-16.2775350784223249`\)\)], "Output"]
}, Closed]],

Cell[TextData[{
  "By using ",
  StyleBox["NestList", "Input"],
  ", we collect all of the intermediate iterations."
}], "Text"],

Cell[BoxData[
    \(\(randomwalk = NestList[step1d, 0.0, 500]; \)\)], "Input"],

Cell["\<\
Here is a shortened version of the list of points on the random \
walk.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Short[randomwalk]\)], "Input"],

Cell[BoxData[
    TagBox[
      "\({0.`, \[LeftSkeleton]499\[RightSkeleton], \(-14.8537156362193538`\)} \
        \)",
      Short]], "Output"]
}, Closed]],

Cell[TextData[{
  "To plot the random walk, we use ",
  StyleBox["ListPlot", "Input"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(ListPlot[randomwalk, PlotJoined \[Rule] True]; \)\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.00190096 0.530895 0.0278765 [
[.21391 .5184 -9 -9 ]
[.21391 .5184 9 0 ]
[.404 .5184 -9 -9 ]
[.404 .5184 9 0 ]
[.5941 .5184 -9 -9 ]
[.5941 .5184 9 0 ]
[.78419 .5184 -9 -9 ]
[.78419 .5184 9 0 ]
[.97429 .5184 -9 -9 ]
[.97429 .5184 9 0 ]
[.01131 .11275 -18 -4.5 ]
[.01131 .11275 0 4.5 ]
[.01131 .25213 -18 -4.5 ]
[.01131 .25213 0 4.5 ]
[.01131 .39151 -12 -4.5 ]
[.01131 .39151 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.21391 .5309 m
.21391 .53715 L
s
[(100)] .21391 .5184 0 1 Mshowa
.404 .5309 m
.404 .53715 L
s
[(200)] .404 .5184 0 1 Mshowa
.5941 .5309 m
.5941 .53715 L
s
[(300)] .5941 .5184 0 1 Mshowa
.78419 .5309 m
.78419 .53715 L
s
[(400)] .78419 .5184 0 1 Mshowa
.97429 .5309 m
.97429 .53715 L
s
[(500)] .97429 .5184 0 1 Mshowa
.125 Mabswid
.06183 .5309 m
.06183 .53465 L
s
.09985 .5309 m
.09985 .53465 L
s
.13787 .5309 m
.13787 .53465 L
s
.17589 .5309 m
.17589 .53465 L
s
.25192 .5309 m
.25192 .53465 L
s
.28994 .5309 m
.28994 .53465 L
s
.32796 .5309 m
.32796 .53465 L
s
.36598 .5309 m
.36598 .53465 L
s
.44202 .5309 m
.44202 .53465 L
s
.48004 .5309 m
.48004 .53465 L
s
.51806 .5309 m
.51806 .53465 L
s
.55608 .5309 m
.55608 .53465 L
s
.63212 .5309 m
.63212 .53465 L
s
.67014 .5309 m
.67014 .53465 L
s
.70816 .5309 m
.70816 .53465 L
s
.74617 .5309 m
.74617 .53465 L
s
.82221 .5309 m
.82221 .53465 L
s
.86023 .5309 m
.86023 .53465 L
s
.89825 .5309 m
.89825 .53465 L
s
.93627 .5309 m
.93627 .53465 L
s
.25 Mabswid
0 .5309 m
1 .5309 L
s
.02381 .11275 m
.03006 .11275 L
s
[(-15)] .01131 .11275 1 0 Mshowa
.02381 .25213 m
.03006 .25213 L
s
[(-10)] .01131 .25213 1 0 Mshowa
.02381 .39151 m
.03006 .39151 L
s
[(-5)] .01131 .39151 1 0 Mshowa
.125 Mabswid
.02381 .14062 m
.02756 .14062 L
s
.02381 .1685 m
.02756 .1685 L
s
.02381 .19638 m
.02756 .19638 L
s
.02381 .22425 m
.02756 .22425 L
s
.02381 .28001 m
.02756 .28001 L
s
.02381 .30788 m
.02756 .30788 L
s
.02381 .33576 m
.02756 .33576 L
s
.02381 .36364 m
.02756 .36364 L
s
.02381 .41939 m
.02756 .41939 L
s
.02381 .44727 m
.02756 .44727 L
s
.02381 .47514 m
.02756 .47514 L
s
.02381 .50302 m
.02756 .50302 L
s
.02381 .08487 m
.02756 .08487 L
s
.02381 .05699 m
.02756 .05699 L
s
.02381 .02912 m
.02756 .02912 L
s
.02381 .00124 m
.02756 .00124 L
s
.02381 .55877 m
.02756 .55877 L
s
.02381 .58665 m
.02756 .58665 L
s
.02381 .61452 m
.02756 .61452 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02571 .5309 m
.02761 .54845 L
.02951 .54989 L
.03141 .52371 L
.03331 .50407 L
.03522 .53154 L
.03712 .55766 L
.03902 .58018 L
.04092 .56203 L
.04282 .55107 L
.04472 .53707 L
.04662 .51045 L
.04852 .50846 L
.05042 .50726 L
.05232 .50175 L
.05422 .49399 L
.05613 .50988 L
.05803 .48603 L
.05993 .465 L
.06183 .45204 L
.06373 .45923 L
.06563 .46227 L
.06753 .46445 L
.06943 .49178 L
.07133 .49514 L
.07323 .50851 L
.07514 .48137 L
.07704 .507 L
.07894 .50212 L
.08084 .51591 L
.08274 .49052 L
.08464 .46575 L
.08654 .45115 L
.08844 .44802 L
.09034 .46451 L
.09224 .43848 L
.09415 .45374 L
.09605 .47969 L
.09795 .47381 L
.09985 .48342 L
.10175 .51067 L
.10365 .53259 L
.10555 .51987 L
.10745 .51455 L
.10935 .50674 L
.11125 .49775 L
.11315 .51072 L
.11506 .50595 L
.11696 .52266 L
.11886 .52816 L
Mistroke
.12076 .54041 L
.12266 .53789 L
.12456 .53159 L
.12646 .55119 L
.12836 .56095 L
.13026 .55532 L
.13216 .53575 L
.13407 .5306 L
.13597 .55174 L
.13787 .54427 L
.13977 .53731 L
.14167 .53409 L
.14357 .53323 L
.14547 .54403 L
.14737 .5377 L
.14927 .54043 L
.15117 .52441 L
.15307 .51265 L
.15498 .48626 L
.15688 .47011 L
.15878 .46899 L
.16068 .48988 L
.16258 .47466 L
.16448 .48088 L
.16638 .49539 L
.16828 .49092 L
.17018 .50987 L
.17208 .52437 L
.17399 .50125 L
.17589 .47453 L
.17779 .48518 L
.17969 .47695 L
.18159 .46057 L
.18349 .4692 L
.18539 .45892 L
.18729 .48179 L
.18919 .49415 L
.19109 .51985 L
.19299 .54378 L
.1949 .53605 L
.1968 .53654 L
.1987 .54613 L
.2006 .56857 L
.2025 .54912 L
.2044 .52285 L
.2063 .53943 L
.2082 .54921 L
.2101 .55142 L
.212 .53852 L
.21391 .53169 L
Mistroke
.21581 .55039 L
.21771 .56598 L
.21961 .54832 L
.22151 .54033 L
.22341 .52052 L
.22531 .51645 L
.22721 .54305 L
.22911 .55432 L
.23101 .57265 L
.23292 .57359 L
.23482 .55996 L
.23672 .57339 L
.23862 .59569 L
.24052 .57648 L
.24242 .59023 L
.24432 .5662 L
.24622 .59393 L
.24812 .56629 L
.25002 .57843 L
.25192 .5657 L
.25383 .55577 L
.25573 .55381 L
.25763 .55097 L
.25953 .57294 L
.26143 .57219 L
.26333 .58251 L
.26523 .56946 L
.26713 .57154 L
.26903 .56272 L
.27093 .54924 L
.27284 .53746 L
.27474 .55616 L
.27664 .55688 L
.27854 .57034 L
.28044 .54431 L
.28234 .52169 L
.28424 .528 L
.28614 .53279 L
.28804 .52089 L
.28994 .49443 L
.29184 .50088 L
.29375 .50543 L
.29565 .50927 L
.29755 .52342 L
.29945 .51192 L
.30135 .49056 L
.30325 .46935 L
.30515 .4894 L
.30705 .50654 L
.30895 .50273 L
Mistroke
.31085 .52245 L
.31276 .51255 L
.31466 .51062 L
.31656 .49242 L
.31846 .49605 L
.32036 .49532 L
.32226 .52055 L
.32416 .51677 L
.32606 .51855 L
.32796 .51256 L
.32986 .50361 L
.33177 .52291 L
.33367 .50871 L
.33557 .50131 L
.33747 .51378 L
.33937 .50065 L
.34127 .5105 L
.34317 .51683 L
.34507 .51292 L
.34697 .49328 L
.34887 .49645 L
.35077 .5106 L
.35268 .51744 L
.35458 .52948 L
.35648 .54081 L
.35838 .53698 L
.36028 .51787 L
.36218 .52024 L
.36408 .50006 L
.36598 .52484 L
.36788 .50837 L
.36978 .48665 L
.37169 .49257 L
.37359 .49546 L
.37549 .51582 L
.37739 .50268 L
.37929 .49492 L
.38119 .47733 L
.38309 .45734 L
.38499 .4852 L
.38689 .49547 L
.38879 .49944 L
.39069 .51123 L
.3926 .53086 L
.3945 .51007 L
.3964 .52777 L
.3983 .50484 L
.4002 .48455 L
.4021 .48032 L
.404 .47396 L
Mistroke
.4059 .49803 L
.4078 .50324 L
.4097 .49131 L
.41161 .48805 L
.41351 .50071 L
.41541 .49977 L
.41731 .50979 L
.41921 .53153 L
.42111 .5517 L
.42301 .53602 L
.42491 .52593 L
.42681 .53738 L
.42871 .54966 L
.43061 .534 L
.43252 .54152 L
.43442 .52112 L
.43632 .49374 L
.43822 .48632 L
.44012 .48675 L
.44202 .47653 L
.44392 .49995 L
.44582 .48494 L
.44772 .46173 L
.44962 .48575 L
.45153 .51298 L
.45343 .52063 L
.45533 .53723 L
.45723 .53663 L
.45913 .52333 L
.46103 .50404 L
.46293 .48274 L
.46483 .48828 L
.46673 .48268 L
.46863 .50695 L
.47054 .52361 L
.47244 .54558 L
.47434 .55558 L
.47624 .56764 L
.47814 .5489 L
.48004 .56339 L
.48194 .57289 L
.48384 .5645 L
.48574 .57321 L
.48764 .57004 L
.48954 .58399 L
.49145 .56274 L
.49335 .56678 L
.49525 .56747 L
.49715 .58207 L
.49905 .58103 L
Mistroke
.50095 .59636 L
.50285 .56978 L
.50475 .5698 L
.50665 .56017 L
.50855 .56892 L
.51046 .56468 L
.51236 .54242 L
.51426 .5364 L
.51616 .55636 L
.51806 .55803 L
.51996 .55365 L
.52186 .56344 L
.52376 .57427 L
.52566 .58932 L
.52756 .60332 L
.52946 .59362 L
.53137 .56786 L
.53327 .55821 L
.53517 .53038 L
.53707 .51407 L
.53897 .51214 L
.54087 .52967 L
.54277 .51512 L
.54467 .52772 L
.54657 .53835 L
.54847 .55457 L
.55038 .56788 L
.55228 .56223 L
.55418 .53624 L
.55608 .52883 L
.55798 .53651 L
.55988 .50902 L
.56178 .49093 L
.56368 .50973 L
.56558 .49392 L
.56748 .48451 L
.56939 .48347 L
.57129 .45935 L
.57319 .45741 L
.57509 .42981 L
.57699 .42666 L
.57889 .44007 L
.58079 .43808 L
.58269 .45468 L
.58459 .48133 L
.58649 .50509 L
.58839 .48978 L
.5903 .46589 L
.5922 .45404 L
.5941 .43369 L
Mistroke
.596 .43295 L
.5979 .44259 L
.5998 .42886 L
.6017 .4438 L
.6036 .46324 L
.6055 .47251 L
.6074 .44898 L
.60931 .473 L
.61121 .48038 L
.61311 .47118 L
.61501 .47657 L
.61691 .49683 L
.61881 .47827 L
.62071 .46879 L
.62261 .44945 L
.62451 .42843 L
.62641 .43974 L
.62831 .44154 L
.63022 .42342 L
.63212 .40652 L
.63402 .40527 L
.63592 .40307 L
.63782 .42469 L
.63972 .40025 L
.64162 .42762 L
.64352 .44366 L
.64542 .45113 L
.64732 .43964 L
.64923 .41968 L
.65113 .39858 L
.65303 .4017 L
.65493 .39407 L
.65683 .3946 L
.65873 .41058 L
.66063 .43619 L
.66253 .43617 L
.66443 .42738 L
.66633 .42497 L
.66823 .44204 L
.67014 .43517 L
.67204 .44294 L
.67394 .46661 L
.67584 .47392 L
.67774 .45607 L
.67964 .43723 L
.68154 .43522 L
.68344 .44878 L
.68534 .42749 L
.68724 .40916 L
.68915 .41898 L
Mistroke
.69105 .3972 L
.69295 .41528 L
.69485 .38903 L
.69675 .39207 L
.69865 .39505 L
.70055 .39289 L
.70245 .39399 L
.70435 .40892 L
.70625 .41417 L
.70816 .4399 L
.71006 .42191 L
.71196 .41137 L
.71386 .42743 L
.71576 .43216 L
.71766 .43427 L
.71956 .42794 L
.72146 .40882 L
.72336 .40351 L
.72526 .39659 L
.72716 .42015 L
.72907 .41534 L
.73097 .40345 L
.73287 .38698 L
.73477 .37284 L
.73667 .36194 L
.73857 .35984 L
.74047 .34174 L
.74237 .35243 L
.74427 .36644 L
.74617 .33863 L
.74808 .3473 L
.74998 .37094 L
.75188 .35182 L
.75378 .32616 L
.75568 .32494 L
.75758 .33124 L
.75948 .32394 L
.76138 .32143 L
.76328 .34598 L
.76518 .33073 L
.76708 .31467 L
.76899 .28959 L
.77089 .29319 L
.77279 .28226 L
.77469 .29887 L
.77659 .31357 L
.77849 .30576 L
.78039 .2811 L
.78229 .28073 L
.78419 .26965 L
Mistroke
.78609 .25206 L
.788 .24458 L
.7899 .25808 L
.7918 .24694 L
.7937 .24856 L
.7956 .24531 L
.7975 .25006 L
.7994 .2367 L
.8013 .21165 L
.8032 .22999 L
.8051 .21417 L
.80701 .23119 L
.80891 .20947 L
.81081 .21518 L
.81271 .18754 L
.81461 .20176 L
.81651 .20433 L
.81841 .19308 L
.82031 .17672 L
.82221 .20412 L
.82411 .18661 L
.82601 .17215 L
.82792 .18403 L
.82982 .19464 L
.83172 .16684 L
.83362 .18774 L
.83552 .21399 L
.83742 .20787 L
.83932 .20633 L
.84122 .20259 L
.84312 .19622 L
.84502 .17558 L
.84693 .17121 L
.84883 .17701 L
.85073 .15859 L
.85263 .14881 L
.85453 .13827 L
.85643 .1105 L
.85833 .09183 L
.86023 .09571 L
.86213 .11048 L
.86403 .12183 L
.86593 .14741 L
.86784 .15176 L
.86974 .15616 L
.87164 .15409 L
.87354 .13991 L
.87544 .16153 L
.87734 .16586 L
.87924 .17077 L
Mistroke
.88114 .15821 L
.88304 .15808 L
.88494 .13607 L
.88685 .11684 L
.88875 .13852 L
.89065 .13116 L
.89255 .1414 L
.89445 .14424 L
.89635 .15647 L
.89825 .13101 L
.90015 .12391 L
.90205 .12665 L
.90395 .12966 L
.90585 .12821 L
.90776 .13421 L
.90966 .15348 L
.91156 .15879 L
.91346 .18086 L
.91536 .15459 L
.91726 .14805 L
.91916 .13967 L
.92106 .11224 L
.92296 .10951 L
.92486 .12594 L
.92677 .10224 L
.92867 .10282 L
.93057 .09422 L
.93247 .10201 L
.93437 .08451 L
.93627 .06457 L
.93817 .0736 L
.94007 .05069 L
.94197 .04883 L
.94387 .02647 L
.94578 .01472 L
.94768 .01695 L
.94958 .03995 L
.95148 .04692 L
.95338 .05704 L
.95528 .06788 L
.95718 .05769 L
.95908 .07047 L
.96098 .07899 L
.96288 .06849 L
.96478 .09456 L
.96669 .1069 L
.96859 .09026 L
.97049 .09121 L
.97239 .1131 L
.97429 .09699 L
Mistroke
.97619 .11683 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{35, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/@P10`4000010?ooobl_;oooZZVYZNSX
j?oo05FZZZZZZ_W0RS/k>gYjN[Vi^OShn03ooeGooj[ooonI<c<c<fi^KZf][Nc/k02ZoeFZojZZoonZ
oclo?ginO[fm_Oclo5D00:X00?l00?l0VCLg=g9bL[6a/O3`l03o05Go0:[o00<30d92@X61PL30`000
EED0EJX0EOl0ELbIoc/k>gIfM[Fe]OCdm03oEEGoEJ[oE@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0Z/`c
<clo?gYjN[Vi^OShn03oZUGoZZ[oZP/;2dY:BXV9RLS8b000oeD0ojX0ool0o`<30d92@WinO[fm_Ocl
o03ooeGooj[oo`l?3di>CXf=SLc<c01E05EE0:YE0?mE00L71dI6AX61PL30`000EED00:X00?l001<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEE@/;2dY:BXF5QLC4a000ZUD0EJX0EOl0EALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZPl?3di>CXV9RLS8b000oeD0ZZX0Z_l0ZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEoa<C
4e9BDXf=SLc<c01E05D0ojX0ool0oalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ01LG5eIFEY6ATM3@d01E
EEEE0:YE0?mE02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZEA/K6eYJFYFEUMCDe01EZUEEEJYEEOmEEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZQlO7eiNGYVIVMSHf01EoeEEZZYEZ_mEZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZob<S8f9RHYfMWMcLg02Z05EEojYEoomEobl_;fi^KZf][Nc/k03o05Go0:[o0=gW1RLW
9fIVIZ6QXN3Ph02ZEEFZ0:ZZ0?nZ03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooEB/[:fYZJZFUYNCTi02Z
ZUFZEJZZEOnZECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l08@000?l08@000?l08@000?l08@000?l0
8@0001D00_oo00X0000E0003o`000?l02@0001D000?o0000o`0900005@000ol0003o00T0000E0003
o`000?H000?o00003`0001D000?o0000mP000ol0000?00005@000ol0003e00;o4@0001D00_of00;o
4@0001D000?o0000m@000ol0o`0@00005@000ol0003e0003o`3o0100000E0003o`000?D000?o0?l0
400001D000?o0000m@000ol0o`0@00005@000ol0003e0003o`3o0100000E0003o`000?@00_l00`3o
000?00005@000ol0003d0005o`000?l03`0001D00_oe0004o`0000;o3P0001D000?o0000m0001?l0
0002o`h0000E0003o`000?<00_l300;o3P0001D000?o0000l`02o`<00ol=00005@000ol0003c00;o
1002o`d0000E0003o`000?<000?o00000`02o`d0000E0003o`000?<000?o000010000ol0000;0000
5@000ol0003c0003o`0000D000?o00002P0001D00_od0003o`0000D000?o00002P0001D000?o0000
gP000ol0000B0003o`0000D00_l;00005@000ol0003N00;o4P000ol0000600;o2`0001D000?o0000
gP02oa8000?o00001P02o`030?l000P0000E0003o`000=h00_lA00;o2002o`030?l000P0000700?o
0`03o`D000?o0000gP02oa4000?o00001`001?l0ool9000020000ol000050003o`00008000?o0000
gP02oa000_l;00;o2@0000030?oo00?o0P000ol000050003o`0000800ooN00;o3`03o`/00_l90000
20000ol0000200?o1@000ol0003N0003o`3o00D000?o00001P02o`d000?o00001`0000P000?o0000
0P000ol000050003o`000=h000?o0?l01@000ol0000600;o5`0000L00_l400Co10000ol0003N0003
o`3o00D000Co003o1@02oaL0000E0003o`000=d000Co003o1002o`800ol300;o5`0001D000?o0000
g@001?l00?l400?o00@0o`3o0`000ol0000F00005@000ol0003M0004o`00o`@00ol01@3o003o0080
00?o00005P0001D000?o0000g@001_l00?l0o`800ol01@3o003o008000?o00005P0001D00_oN0006
o`00o`3o0P001Ol0o`3o008000Co003o600001D000?o0000g@001_l00?l0o`8000Co003o0`000ol0
o`0I00005@000ol0003M0006o`00o`3o0P001?l00?l30003o`3o01T0000E0003o`000=d000Co0000
0ol01@3o003o00<000?o0?l06@0001D000?o0000g0000ol000020003o`3o00;o0P000ol0000200;o
6@0001D000?o0000g0000ol0000400;o2002oaT0000E0003o`000=`000?o00001002o`P00_lI0000
5@02omP000?o00000P000ol0000400;o20000ol0000H00005@000ol0003E0003o`3o00<00_l70003
o`0000H000?o0000600001D000?o0000e002o`030?l000800_l@0003o`0001P0000E0003o`000=@0
1Ol20003o`0000l000?o0000600001D000?o0000e003o`050?l00?l0;00001D000?o0000dP05o`05
0?l00?l0;00001D000?o0000dP05o`040?l0obd0000E0003o`000=801Ol0103o0?l]00005@02om<0
0ol30003o`3o02d0000E0003o`000=800ol30003o`3o02d0000E0003o`000=4000Co0?oo0`02obh0
000E0003o`000=4000?o00001002obh0000E0003o`000<l00ol60003o`0002d0000E0003o`000<l0
0olf00005@000ol0003?00?o=P0001D00_o@00;o=`0001D000?o0000cP03ocL0000E0003o`000<h0
0olg00005@000ol0003>0003o`0003L0000E0003o`000<h000?o0000=`0001D000?o0000cP000ol0
000g00001`03o`@00_l50003o`000</01?li000020000ol000020004o`00o`@000?o0000b`04ocT0
00000`3oo`03o`8000?o00000P001?l00?l400?ob`02oc/000080003o`00008000Co003o10000ol0
003;00;o>`0000P000?o00000P001?l00?l40003o`000</000?o0000>P0000L00_l500;o1@000ol0
003:0003o`0003/0000E0003o`000<X000?o0000>`0001D000?o0000bP000ol0000k00005@000ol0
003:0003o`0003/0000E00;obP02ocd0000E0003o`000<L000?o0?l0?P0001D000?o0000a`000ol0
o`0n00005@000ol0003600;o00<0o`00?@0001D000?o0000aP04och0000E0003o`000<H000Co0?oo
?P0001D000?o0000aP001?l0ooln00005@000ol000360004o`3ooch0000E00;oa`001?l0ooln0000
5@000ol000360003o`3o03l0000E0003o`000<H000?o0000?`0001D000?o0000a0000ol0o`110000
5@000ol000320005o`3o0?l0@@0001D000?o0000`P001?l0oom200005@000ol0003200Co@P0001D0
0_o30004o`00od80000E0003o`000<0000?o0?l00P000ol0001000005@000ol0002n0004o`3oo`<0
00?o0000@00001D000?o0000_P001?l0ool30003o`000400000E0003o`000;h01?m600005@000ol0
002n00CoAP0001D000?o0000_P04odH0000E0003o`000;d00ol00`3o001500005@02okh000Go0?l0
o`1600005@000ol0002m0005o`3o0?l0AP0001D000?o0000_@001Ol0003o04H0000E0003o`000;d0
00?o0000B00001D000?o0000_@000ol0001800003@03o`D000?o0000_0000ol00019000040000ol0
00020003o`000;`000?o0000B@0000L01Ol40003o`0000800onb00;o20000ol0001900003@03o`D0
00?o0000Y`02o`T00ol70003o`0004T0000=0003o`0000D000?o0000YP03o`P00_l00`3o00040003
o`3o04/0000=00Co10000ol0002R00;o0P03o`P00_l00`3o00040003o`3o04/0000E0003o`000:40
0ol20003o`3o00P00_l20003o`00008000?o0?l0B`0001D000?o0000X@03o`8000?o0?l01`03o`80
00Co00000_l00`3o001:00005@000ol0002Q00?o0P000ol0o`0700?o0P001ol0o`3o0?l0C00001D0
00?o0000X@002?l0ool0o`3o1`03o`8000Oo0?l0o`3o04`0000E00;oXP002?l0ool0o`3o1P000ol0
o`0300?o00@0o`3oC00001D000?o0000X@001_l0ool0o`800_l40003o`0000<00ol00`3o001=0000
5@000ol0002B0003o`0000<000?o000010000ol0o`020003o`3o00800_l40003o`0000@00_l00`3o
001=00005@000ol0002B0003o`0000800_l60003o`3o00800_l300;o10000ol000040004o`3oodh0
000E0003o`0009800_l300;o1P02o`<00_l30003o`3o00800_l60003o`3o04l0000E0003o`0000l0
00?o0000P002o`<00ol500;o0`02o`D000?o00000_l60003o`0004l0000E0003o`0000l000?o0000
P002o`<00ol500;o0`02o`D00_l00`3oo`1H00005@02oa0000?o0000O`000ol0o`020004o`00o`D0
00?o00000P02o`H000Co0?ooF00001D000?o00003P03oh0000Ko003o0?l200;o10000ol000030003
o`0000@00_l00`3o001G00005@000ol000070003o`0000@00on00006o`00o`3o0P02o`@000?o0000
2P02oeX0000E0003o`0000L000?o00001003odd000?o0000<0001_l00?l0o`800_l40003o`0000X0
0_mJ00005@000ol0000700;o10001?l0oolF0003o`3o03@000?o00003P000ol0000O0006o`00o`3o
0P02o`<000?o00002`02oeX0000E0003o`0000L000?o0?l00`001?l0oolF0003o`3o03@000?o0000
3P000ol0000O0006o`00o`3o0P03o`8000?o00002`02oeX0000E0003o`0000L000?o0?l00`001?l0
0?l@0003o`0000<00olN0003o`0001800_l@0003o`0001l000Ko003o0?l200?o0P000ol0000;00;o
FP0001D000?o00001`000ol0o`030004o`00oa0000?o00000`000ol0o`0N0003o`0001800_l@0003
o`0001l000Ko003o0?l300?o00<0o`003002oeX0000E00;o20000ol0o`030003o`0000;o3`02o`<0
0_l00`3o000M0003o`0001800_l50003o`0000L00olO0007o`000?l0o`0400;o00<0o`003@000ol0
001H00005@000ol000060004o`00o`<000?o00000_l?00?o0P02o`030?l001d000?o00004P02o`@0
0_l900?o7`001?l00002o`D00_l00`3o001X00005@000ol000060008o`00o`3o0?l30003o`0000`0
00Co0?oo0P001?l00?lN00;o4`02o`@00_l800Co0P02oa/000Co00000_l60003o`3o06T0000E0003
o`0000H000So003o0?l0o`<000?o000030001?l0ool20004o`00oah00_l@0003o`0000;o1002o`03
0?l000D01?l200;o6`001?l00002o`H000?o0?l0J@0001D000?o00001P002?l00?l0o`3o0`000ol0
000<0003o`3o00?o10000ol0000K00;o40000ol00002o`@01?l600Co0P02oaT00_l400;o1`000ol0
001X00005@000ol0000500;o0`02o`030?l0008000?o000030000ol00003o`800ol400;o1002o`h0
00?o00000_l200;o1P000ol0000300Ko0`04o`800_l00`3o0003o`800_lI00Co0P04o`@00_lU00?o
0`02o`@00_lU00?o1002o`@00_l300005@000ol0000500;o0`02o`030?l000<000?o0?l02`001?l0
0002o`<00_l30004o`00o`8000Co003o3@000ol00002o`800_l600;o1002o`040?l0o`8000?o0?l0
0_l0103o0002o`040?l0o`8000?o0?l06002o`8000Co003o0P001Ol00?l000;o9@001Ol0003o0080
00Co003o0P000ol0000U0004o`00o`8000Co003o0P01o`400@0001D00_l600;o0`04o`@000?o0?l0
2`001?l00002o`<00_l30004o`00o`8000Co003o3@000ol00003o`030?oo00<00_l00`3oo`0300Co
00<0ool00P000ol00004o`800_l0103o0?l20003o`3o01P00_l20004o`00o`8000Co003o0P000ol0
000Q00Co0P001?l00?l20004o`00obL000Co003o0P001?l00?l2007o0@0100005@000ol0o`0500;o
0`03o`D000?o0?l00_l90004o`0000;o0`02o`<000Co003o0P001?l00?l=00?o00H0oooo0?l200?o
00<0ool00`04o`8000Co003o0P001?l0ool200;o0`001_l00?l0oaP01?l30004o`00o`8000Co003o
8`000ol0o`030004o`00o`8000Co003o9003o`<000Co003o0P001?l00?l200005@000ol0o`0300;o
00<0o`000P000ol0o`050003o`3o00;o2@001?l00002o`<00_l30004o`00o`8000Co003o30001?l0
ool200;o00@0o`001_l300;o00@0o`001?l20004o`3oo`800_l30006o`00o`3o6002o`8000Co003o
0P001?l00?l20003o`00024000?o0?l00`001?l00?l20004o`00ob@000?o00000`001?l00?l20004
o`00o`80000E0003o`3o00<000?o00001P000ol0000300;o0P000ol000070004o`0000;o0P03o`@0
0_l400;o3@001?l0ool200;o00<0o`001ol200?o00D0oooo0005o`8000Ko0?oo0?l30006o`00o`3o
4@02o`D01?l400;o1002obD00_l400;o1002obD01?l300;o1002o`<0000E0003o`3o00<000?o0000
1P000ol0000300;o0P000ol000070004o`0000;o10000ol000060003o`0000h000Co0?oo0P02o`03
0?oo00?o00H0o`00o`03o`030?l000800ol40003o`00008000Oo0000o`3o008000?o00003`03o`@0
00?o0000M`0001D000Co0?oo0P000ol0000<00;o0P000ol000060003o`0000<000?o00000P000ol0
00060003o`0000d00_l20004o`00o`800_l00`3o00040004o`3oo`H00_l50003o`00008000?o0000
0P02o`8000?o00003`03o`@000?o0000M`0001D000Co0?oo0P000ol0000<00;o0P000ol000060003
o`0000<000?o00000P001Ol0003o00@000?o00003@02o`8000Co003o1@000ol000030004o`3oo`H0
0_l60005o`000?l01002o`8000?o00003`04o`8000?o0000N00001D000Co0?oo0P000ol0000<0003
o`00008000?o00001@000ol000080005o`000?l010000ol0000=00;o4@000ol0o`0700;o1P02o`80
00?o00000P02o`8000?o00003`02o`050?l00?l0NP0000h0ool@o`<0000E0004o`3oo`8000Go0000
o`090003o`0000<00_l00`3oo`02o`030?l000D000?o00000P02o`080?l0o`3o0?l50003o`0000D0
00Co003o2@000ol0000400;o00<0o`002@001?l00004o`8000?o00000_l20004o`00o`P00_l40005
o`00o`000_l90003o`0000L000?o00001`000ol000080003o`0000L000?o00001`000ol000070003
o`0000P000?o00001`000ol000070003o`0000P000?o00001`0001D00_l01@3o003o01<00_l00`3o
o`04o`/01?l01P3o0?l0o`/000?o0?l050000ol0000:0004o`0000Co1@000ol000020003o`0000P0
00?o00000`001_l00?l0o`X000?o0000<0000ol0000a0003o`0000L0000E00;o00D0o`00o`0C0003
o`3o00?o00<0ool02`04o`060?ooo`3o2`000ol0o`0D0003o`0000h01?l:0003o`0000P000?o0000
0`001_l00?l0og/0000E00;o00@0o`3o5P04o`l00_l00`3o0002o`030?l000X000?o0?l09@000ol0
o`0;0003o`0000P000?o00000P001ol0003o0?l0N`0001D00_l0103o0?lF00Co3`02o`030?l000;o
00<0o`001P001?l00003obD000?o0?l02`000ol0o`0800;o0`000ol0000200;oN`0001D000Ko003o
0?lF00?o4002o`<00_l00`3o000500;o0`03obD000?o00003002o`P00ol20003o`0000800_mk0000
5@02o`030?oo01L00_lA00;o0`02o`030?l000D00_l300?o=002o`L000Co0?oo0P000ol0000200;o
N`0001D000?o00000_lG0003o`00014000Go0000o`020003o`3o00@00_l20004o`3ooc@00_l600;o
0P001?l00?l400;oN`0001D000?o00000_l[0005o`000?l00`02o`040?ooo`8000Co0?l00_ld00?o
00<0o`000P02o`8000Co003o1002og/0000E0003o`0000;o:`000ol0000500;o00@0oooo0P03o`80
00?o0000<P03o`040?oo00?o0P001?l00?l40003o`0007X0000E0005o`000?l0<`02o`040?ooo`80
0ol20003o`0003@01?l00`3o00040003o`3o0840000E0005o`000?l0=005o`800_lk00?o00<0o`00
10000ol0o`2100005@001Ol0003o03@01Ol30003o`0003X000Co0?oo1@000ol0o`2100005@000ol0
000f00Co10000ol0000j0004o`3oo`D00_n200005@02ocP00om300;o1@02oh80000E0003o`0003L0
0om40003o`0000<00_n200005@000ol0000g0003o`3o04@000?o00000`02oh80000E0003o`0007h0
00?o000010000ol0002000005@000ol000250003o`000800000E0003o`000?l02@0001D000?o0000
o`0900005@000ol0003o00T0000E00;oo`0:0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000
\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-41.6489, -19.7138, 1.94839, 
  0.132865}}]
}, Closed]],

Cell[BoxData[
    \(Clear[randomwalk]\)], "Input"],

Cell[TextData[{
  "The expected value of a discrete random variable ",
  StyleBox["Y",
    FontSlant->"Italic"],
  " is defined to be the sum (over all possible values of ",
  StyleBox["Y",
    FontSlant->"Italic"],
  ") of the product of the value of an event  ",
  StyleBox["y",
    FontSlant->"Italic"],
  " and the probability of ",
  StyleBox["y",
    FontSlant->"Italic"],
  " occurring (",
  Cell[BoxData[
      \(TraditionalForm\`\[Sum]\+y y\ \(p(y)\)\)]],
  "). Compute the expected value corresponding to the list ",
  Cell[BoxData[
      \({{1, 0.5}, {2, 0.25}, {3, 0.2}, {4, 0.05}}\)], "Input"],
  ", where each sublist is a {",
  StyleBox["y",
    FontSlant->"Italic"],
  ", ",
  Cell[TextData[{
    StyleBox["p",
      FontSlant->"Italic"],
    "(",
    StyleBox["y",
      FontSlant->"Italic"],
    ")"
  }], "Question"],
  "} pair."
}], "Question"],

Cell[TextData[{
  "To multiply two elements of a list, we use ",
  StyleBox["Apply", "Input"],
  " and ",
  StyleBox["Times", "Input"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Apply[Times, {2, 0.25}]\)], "Input"],

Cell[BoxData[
    \(0.5`\)], "Output"]
}, Closed]],

Cell["\<\
Here is an auxiliary function that multiplies the two elements of \
its argument.\
\>", "Text"],

Cell[BoxData[
    \(multPairs[L_] := Apply[Times, L]\)], "Input"],

Cell["An identical definition is the following.", "Text"],

Cell[BoxData[
    \(multPairs[{x_, y_}] := x\ y\)], "Input"],

Cell[TextData[{
  "To multiply each pair in the list, we map either definition of ",
  StyleBox["multPairs", "Input"],
  " over the list."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Map[multPairs, {{1, 0.5}, {2, 0.5}, {3, 0.2}, {4, 0.05}}]\)], "Input"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        StyleBox["0.5`",
          StyleBoxAutoDelete->True,
          PrintPrecision->1], ",", "1.`", ",", "0.600000000000000088`", ",", 
        "0.2`"}], "}"}]], "Output"]
}, Closed]],

Cell[TextData[{
  "To add the elements in the resulting list, we use ",
  StyleBox["Apply", "Input"],
  " and ",
  StyleBox["Plus", "Input"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Apply[Plus, Map[multPairs, {{1, 0.5}, {2, 0.5}, {3, 0.2}, {4, 0.05}}]]
      \)], "Input"],

Cell[BoxData[
    \(2.30000000000000026`\)], "Output"]
}, Closed]],

Cell[TextData[{
  "The expected value of ",
  StyleBox["Y",
    FontSlant->"Italic"],
  " is 2.3."
}], "Text"],

Cell[" ", "EndExercises"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Pure Functions", "Section"],

Cell[CellGroupData[{

Cell["Motivation", "Subsection"],

Cell["\<\
The functions we have so far examined have had the following \
form.\
\>", "Text"],

Cell["sqrtPlusOne[x_] := 1 + Sqrt[x]", "Input"],

Cell[TextData[{
  "Once such a function is defined, the symbol name ",
  StyleBox["sqrtPlusOne", "Input"],
  " remains in memory until we remove it with ",
  StyleBox["Remove", "Input"],
  ", which deletes both the value and the name of a symbol. (",
  StyleBox["Clear", "Input"],
  " deletes only the value of a symbol.)"
}], "Text"],

Cell["\<\
Pure, or anonymous, functions are functions that do not have names; \
by using pure functions in appropriate places, we decrease the number of \
symbol names in memory, and consequently decrease the possibility of a name \
conflict.\
\>", "Text"],

Cell[TextData[{
  "Pure functions are useful inside operators that take a function as an \
argument, as with the high-level programming constructs like ",
  StyleBox["Map", "Input"],
  " and ",
  StyleBox["Apply", "Input"],
  ", particularly when the argument function will not be used again."
}], "Text"]
}, Closed]],

Cell[CellGroupData[{

Cell["Defining Pure Functions", "Subsection"],

Cell[TextData[{
  "Here is a simple definition of a function named ",
  StyleBox["func", "Input"],
  " with a single dummy variable called ",
  StyleBox["x", "Input"],
  "."
}], "Text"],

Cell[BoxData[
    \(func[x_] := 1 + x\^2\)], "Input"],

Cell[TextData[{
  "We rewrite the definition of ",
  StyleBox["func[x_]", "Input"],
  " as the following anonymous function. The symbol ",
  StyleBox["Function", "Input"],
  " is a container for an anonymous function, and in this case it contains a \
dummy variable name ",
  StyleBox["x", "Input"],
  " (and not a pattern such as ",
  StyleBox["x_", "Input"],
  ") and a function body that describes what to do with the variable."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Function[x, 1 + x\^2]\)], "Input"],

Cell[BoxData[
    \(Function[x, 1 + x\^2]\)], "Output"]
}, Closed]],

Cell["\<\
We give a pure function an argument inside square brackets, just as \
with a named function.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(Function[x, 1 + x\^2]\)[10]\)], "Input"],

Cell[BoxData[
    \(101\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(func[10]\)], "Input"],

Cell[BoxData[
    \(101\)], "Output"]
}, Closed]],

Cell[TextData[{
  "One advantage to using a pure function is that there is no symbol name (",
  StyleBox["func", "Input"],
  " in the case of the named function) consuming memory."
}], "Text"],

Cell["We define a pure function of two arguments similarly.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Function[{x, y}, 1 + x\^y]\)], "Input"],

Cell[BoxData[
    \(Function[{x, y}, 1 + x\^y]\)], "Output"]
}, Closed]],

Cell["\<\
Here we give the pure function two arguments, again inside square \
brackets.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(Function[{x, y}, 1 + x\^y]\)[10, 3]\)], "Input"],

Cell[BoxData[
    \(1001\)], "Output"]
}, Closed]],

Cell[TextData[{
  "A shorter form of a pure function equivalent to ",
  StyleBox["func", "Input"],
  " is the following. Each occurrence of the hash mark ",
  StyleBox["#", "Input"],
  " represents a slot into which the function\[CloseCurlyQuote]s argument \
will be substituted. This format does not require that we name the dummy \
variables used in the definition."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(Function[1 + #\^2]\)[10]\)], "Input"],

Cell[BoxData[
    \(101\)], "Output"]
}, Closed]],

Cell[TextData[{
  "We define pure functions that accept more than one argument by numbering \
the slots ",
  StyleBox["#1", "Input"],
  ", ",
  StyleBox["#2", "Input"],
  ", and so forth."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(Function[1 + #1\^#2]\)[10, 3]\)], "Input"],

Cell[BoxData[
    \(1001\)], "Output"]
}, Closed]],

Cell[TextData[{
  "The shortest form for a pure function that is equivalent to ",
  StyleBox["func", "Input"],
  " is the following. Notice that the pure function definition looks like the \
right-hand side of the definition for ",
  StyleBox["func", "Input"],
  ", but with ",
  StyleBox["#", "Input"],
  " taking the place of the dummy variable ",
  StyleBox["x", "Input"],
  ". The ampersand ",
  StyleBox["&", "Input"],
  " marks the end of the pure function definition, and it is important not to \
omit it."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\((1 + #\^2)\)&\)], "Input"],

Cell[BoxData[
    \(1 + #1\^2&\)], "Output"]
}, Closed]],

Cell["\<\
We give this pure function an argument inside square brackets, just \
as with the other forms.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(\((1 + #\^2)\)&\)[10]\)], "Input"],

Cell[BoxData[
    \(101\)], "Output"]
}, Closed]],

Cell["\<\
Again we number the slots if the function accepts more than one \
argument. The following function raises the first argument to the power of \
the second argument.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\((#1\^#2&)\)[E, \(-\[Pi]\)]\)], "Input"],

Cell[BoxData[
    \(E\^\(-\[Pi]\)\)], "Output"]
}, Closed]],

Cell["\<\
A pure function may have as many arguments as desired. Here is a \
pure function that accepts four arguments.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\((#1\^#2 < #3\^#4&)\)[2, 3, 3, 2]\)], "Input"],

Cell[BoxData[
    \(True\)], "Output"]
}, Closed]],

Cell[TextData[{
  "Here is a pure predicate function. The following function returns ",
  StyleBox["True", "Input"],
  " if its argument is between 3 and 10. (Note that ",
  StyleBox["#", "Input"],
  " is an abbreviation for ",
  StyleBox["#1", "Input"],
  ", representing the first argument of a function.)"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\((3 < # < 10)\)&\)], "Input"],

Cell[BoxData[
    \(3 < #1 < 10&\)], "Output"]
}, Closed]],

Cell["This is the equivalent long form of the pure function.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Function[x, 3 < x < 10]\)], "Input"],

Cell[BoxData[
    \(Function[x, 3 < x < 10]\)], "Output"]
}, Closed]],

Cell["Here are two tests of the function.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(\((3 < # < 10)\)&\)[7]\)], "Input"],

Cell[BoxData[
    \(True\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(Function[x, \ 3 < x < 10]\)[\(-7\)]\)], "Input"],

Cell[BoxData[
    \(False\)], "Output"]
}, Closed]],

Cell[TextData[{
  "Interpolating functions in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " behave as pure functions. Here is an interpolating function that goes \
through a list of the first ten prime numbers."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ip = Interpolation[Prime[Range[10]]]\)], "Input"],

Cell[BoxData[
    TagBox["\(InterpolatingFunction[{{1, 10}}, \"<>\"]\)",
      False,
      Editable->False]], "Output"]
}, Closed]],

Cell[TextData[{
  "We give the resulting ",
  StyleBox["InterpolatingFunction", "Input"],
  " object an argument inside square brackets, just as with a pure function."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ip[5.25]\)], "Input"],

Cell[BoxData[
    \(11.5312499999999995`\)], "Output"]
}, Closed]],

Cell[TextData[{
  "Here is a plot of the interpolating function. (Note the use of a pure \
function in the value given to ",
  StyleBox["Epilog", "Input"],
  ".)"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(Plot[ip[x], {x, 1, 10}, 
      Epilog \[Rule] {PointSize[0.02], 
          Map[Point[{#, Prime[#]}]&, Range[10]]}]; \)\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.0952381 0.0147151 0.0202967 [
[.21429 .00222 -3 -9 ]
[.21429 .00222 3 0 ]
[.40476 .00222 -3 -9 ]
[.40476 .00222 3 0 ]
[.59524 .00222 -3 -9 ]
[.59524 .00222 3 0 ]
[.78571 .00222 -3 -9 ]
[.78571 .00222 3 0 ]
[.97619 .00222 -6 -9 ]
[.97619 .00222 6 0 ]
[.01131 .1162 -6 -4.5 ]
[.01131 .1162 0 4.5 ]
[.01131 .21768 -12 -4.5 ]
[.01131 .21768 0 4.5 ]
[.01131 .31917 -12 -4.5 ]
[.01131 .31917 0 4.5 ]
[.01131 .42065 -12 -4.5 ]
[.01131 .42065 0 4.5 ]
[.01131 .52213 -12 -4.5 ]
[.01131 .52213 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.21429 .01472 m
.21429 .02097 L
s
[(2)] .21429 .00222 0 1 Mshowa
.40476 .01472 m
.40476 .02097 L
s
[(4)] .40476 .00222 0 1 Mshowa
.59524 .01472 m
.59524 .02097 L
s
[(6)] .59524 .00222 0 1 Mshowa
.78571 .01472 m
.78571 .02097 L
s
[(8)] .78571 .00222 0 1 Mshowa
.97619 .01472 m
.97619 .02097 L
s
[(10)] .97619 .00222 0 1 Mshowa
.125 Mabswid
.07143 .01472 m
.07143 .01847 L
s
.11905 .01472 m
.11905 .01847 L
s
.16667 .01472 m
.16667 .01847 L
s
.2619 .01472 m
.2619 .01847 L
s
.30952 .01472 m
.30952 .01847 L
s
.35714 .01472 m
.35714 .01847 L
s
.45238 .01472 m
.45238 .01847 L
s
.5 .01472 m
.5 .01847 L
s
.54762 .01472 m
.54762 .01847 L
s
.64286 .01472 m
.64286 .01847 L
s
.69048 .01472 m
.69048 .01847 L
s
.7381 .01472 m
.7381 .01847 L
s
.83333 .01472 m
.83333 .01847 L
s
.88095 .01472 m
.88095 .01847 L
s
.92857 .01472 m
.92857 .01847 L
s
.25 Mabswid
0 .01472 m
1 .01472 L
s
.02381 .1162 m
.03006 .1162 L
s
[(5)] .01131 .1162 1 0 Mshowa
.02381 .21768 m
.03006 .21768 L
s
[(10)] .01131 .21768 1 0 Mshowa
.02381 .31917 m
.03006 .31917 L
s
[(15)] .01131 .31917 1 0 Mshowa
.02381 .42065 m
.03006 .42065 L
s
[(20)] .01131 .42065 1 0 Mshowa
.02381 .52213 m
.03006 .52213 L
s
[(25)] .01131 .52213 1 0 Mshowa
.125 Mabswid
.02381 .03501 m
.02756 .03501 L
s
.02381 .05531 m
.02756 .05531 L
s
.02381 .07561 m
.02756 .07561 L
s
.02381 .0959 m
.02756 .0959 L
s
.02381 .1365 m
.02756 .1365 L
s
.02381 .15679 m
.02756 .15679 L
s
.02381 .17709 m
.02756 .17709 L
s
.02381 .19739 m
.02756 .19739 L
s
.02381 .23798 m
.02756 .23798 L
s
.02381 .25828 m
.02756 .25828 L
s
.02381 .27857 m
.02756 .27857 L
s
.02381 .29887 m
.02756 .29887 L
s
.02381 .33946 m
.02756 .33946 L
s
.02381 .35976 m
.02756 .35976 L
s
.02381 .38006 m
.02756 .38006 L
s
.02381 .40035 m
.02756 .40035 L
s
.02381 .44095 m
.02756 .44095 L
s
.02381 .46124 m
.02756 .46124 L
s
.02381 .48154 m
.02756 .48154 L
s
.02381 .50184 m
.02756 .50184 L
s
.02381 .54243 m
.02756 .54243 L
s
.02381 .56273 m
.02756 .56273 L
s
.02381 .58302 m
.02756 .58302 L
s
.02381 .60332 m
.02756 .60332 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.11905 .05531 m
.12323 .0555 L
.12713 .05574 L
.1314 .05608 L
.13597 .05653 L
.14532 .05771 L
.15382 .05908 L
.17331 .0632 L
.19174 .06821 L
.22631 .08003 L
.26309 .09515 L
.29851 .11112 L
.33256 .12448 L
.36882 .13889 L
.3855 .14662 L
.39432 .15109 L
.40371 .1562 L
.40889 .16005 L
.41358 .16384 L
.42274 .17147 L
.44082 .18714 L
.47688 .21891 L
.49342 .23274 L
.51157 .24346 L
.52952 .25111 L
.54847 .25861 L
.56751 .26617 L
.58486 .27363 L
.58903 .27557 L
.59347 .2777 L
.59834 .28101 L
.60284 .28463 L
.61987 .29895 L
.65385 .32891 L
.67273 .34527 L
.68099 .35216 L
.68536 .35571 L
.68776 .35762 L
.68894 .35856 L
.69003 .35941 L
.69111 .36007 L
.69224 .36063 L
.69464 .36179 L
.69882 .36376 L
.70699 .36743 L
.72485 .37484 L
.75895 .38835 L
.77792 .39661 L
.79526 .40666 L
.8302 .43322 L
Mistroke
.86598 .46609 L
.9004 .50311 L
.93703 .54833 L
.97229 .59754 L
.97619 .60332 L
Mfstroke
.02 w
.11905 .05531 Mdot
.21429 .07561 Mdot
.30952 .1162 Mdot
.40476 .15679 Mdot
.5 .23798 Mdot
.59524 .27857 Mdot
.69048 .35976 Mdot
.78571 .40035 Mdot
.88095 .48154 Mdot
.97619 .60332 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{35, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/@P10`4000010?ooo`3oooooZZ[oZSLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^CLg=gIfM[Fe]OCdm?clo5D005Gooj[ooc/k>gYjN[Vi^OShn03o
oclo?ginO[fm_C/k>gYjN[Vi^OShn000EED0EJX00?l003lo?ginO[fm_Oclo0<30d92@X61PL30`3lo
?ginO[fm_Ol0E@00ZUD0ZZX0E@<30d92@X61PL30`000E@L71dI6AXF5Q@<30d92@X61PL30`?l0ZP00
oeD0ojX0ZPL71dI6AXF5QLC4a000ZP/;2dY:BXV9R@L71dI6AXF5QLC4a?l0o`1E05EE0:X0o`/;2dY:
BXV9RLS8b000o`l?3di>CXf=S@/;2dY:BXV9RLS8b?mE001EEEEEEJYE00l?3di>CXf=SLc<c01E01<C
4e9BDY6AT@l?3di>CXf=SLc<c?mEE@1EZUEEZZYEEA<C4e9BDY6ATM3@d01EEALG5eIFEYFEUA<C4e9B
DY6ATM3@d?mEZP1EoeEEojYEZQLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVALG5eIFEYFEUMCDe?mEo`2Z
05FZ0:YEoa/K6eYJFYVIVMSHf01EoalO7eiNGYfMWA/K6eYJFYVIVMSHf?nZ002ZEEFZEJZZ01lO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXAlO7eiNGYfMWMcLg?nZE@2ZZUFZZZZZEB<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYB<S8f9RHZ6QXN3Ph?nZZP2ZoeFZojZZZRLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZBLW9fIV
IZFUYNCTi?nZo`3o05Go0:ZZob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][B/[:fYZJZVYZNSXj?oo003o
EEGoEJ[o02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/Bl_;fi^KZf][Nc/k?ooE@3oZUGoZZ[oEC<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]C<c<g9bL[6a/O3`l0000?l08@0004@01?la0003o`0003000_lb00;o
;P04o`<00_l70000A0000ol0000b0003o`0002l000Co003o<0001?l00?l_0005o`000?l00P000ol0
00040000A@000ol0000^00Go<0001?l00?l`0004o`00obl000Go0000o`020003o`0000@000160003
o`0002d000Co003o<@03oc800_l`0005o`000?l00P000ol000040000A`000ol0000]0003o`3o0340
00?o0000<@001?l00?l_0005o`000?l00P000ol000040000A0001?l00?l`00;o<@000ol0000a0004
o`00obd00ol30004o`00o`H0001500;o<P000ol0000`00?o<@02oc0000?o00000P02o`L0000B0003
o`000?l03000018000?o0000o`0<00004P000ol0003o00`0000B0003o`000?l0300000/0oolCo`<0
000B0003o`0000X000?o00002P000ol0000:0003o`0000X000?o00002P000ol0000:0003o`0000X0
00?o00002@000ol0000:0003o`0000X000?o00002P000ol0000:0003o`0000X000?o00002P000ol0
000:0003o`0000X000?o00002P000ol0000:0003o`0000X000?o00002P000ol0000800004P000ol0
000a0003o`00030000?o0000<@000ol0000a0003o`00034000?o00002000018000?o0000o`0<0000
4P000ol0003o00`0000B0003o`000?l0300001800_oo00d0000B0003o`000?l03000018000?o0000
o`0<00004P000ol0000E00?ol`00018000?o00005005oo80000B00;o5@0:ond0000B0003o`0001@0
1Ol500Koi`00018000?o00005@03o``00ooT00004P000ol0000W00?oh@00018000?o0000:P03o`80
0ooI00004P000ol0000]00Kof00001800_l_00Gof000018000?o0000;P08omD0000B0003o`0002l0
0ol400?odP00018000?o0000>@02om00000B0003o`0003/00oo=00004P02ocl00_o;00004P000ol0
001000?ob000018000?o0000@`02olH0000900?o1P000ol0001500?o``0000`000?o00000`000ol0
001800Co_`0000`000?o00000`000ol0001800Go_P0000T00ol600;oB@07ok`000090003o`0000H0
00?o0000B005o`800_nj00002@000ol000060003o`0004T00ol500;o^00000T01?l50003o`0005<0
0one00004P000ol0001F00;o/`0001800_mI00?o/000018000?o0000F`02ojh0000B0003o`0005d0
0_n/00004P000ol0001O00?oZ@00018000?o0000HP04ojD0000B0003o`0006801OnT00004P02of<0
1OnT00004P000ol0001R00GoY000018000?o0000H`03o`030?l00:80000B0003o`0006P000?o0000
X000018000?o0000J@02oj00000B00;oK0000ol0002M00004P000ol0001/0003o`0009`0000B0003
o`0006d000?o0000V`00018000?o0000KP02oi/0000B0003o`00070000?o0000V000018000?o0000
L@000ol0002G00004P02og<000?o0000UP00018000?o0000L`000ol0002E00004P000ol0001d0003
o`0009@0000300Co0`02o`H000?o0000M@000ol0002C00001@001Ol0003o008000?o00000`000ol0
001f0003o`00098000050005o`000?l00P000ol0000300;oN0000ol0002A00001@001Ol0003o0080
00?o00000`000ol0001h00;oT@0000D000Go0000o`020003o`0000<000?o0000NP02ohl0000300?o
0`001?l00?l50003o`0007`000?o0000S00000D000?o00000P02o`H000?o0000O@03oh/0000B0003
o`0007`01On:00004P02ogd01_n900004P000ol0001l00Go00<0ool0Q`00018000?o0000O@03o`@0
0on400004P000ol0002700;oPP00018000?o0000R@03ogl0000B00;oS@02ogd0000B0003o`0008h0
0_mk00004P000ol0002@0003o`0007P0000B0003o`0009400_mh00004P000ol0002C00?o00@0oooo
L@00018000?o0000UP05og00000B00;oU`05og00000B0003o`0009H01Om`00004P000ol0002G00?o
00<0ool0KP00018000?o0000W@000ol0001[00004P000ol0002N0003o`0006X0000B00;oX0000ol0
001Y00004P000ol0002P0003o`0006P0000B0003o`000:4000?o0000I`0000<01?l200?o1P000ol0
002R0003o`0006H000050003o`0000@000?o00000`000ol0002S0003o`0006D000050003o`0000@0
00?o00000`000ol0002T0003o`0006@000050004o`0000?o1P02ojH000?o0000H`0000D000Go0000
o`080003o`000:H000?o0000HP0000<00ol30003o`0000H000?o0000Y`000ol0001Q00001@001?l0
0004o`D000?o0000Z002of40000B0003o`000:X000?o0000GP00018000?o0000Z`02oeh0000B00;o
[P000ol0001K00004P000ol0002^0003o`0005X0000B0003o`000:l000?o0000F@00018000?o0000
/004oeL0000B0003o`000;001OmF00004P02ok401OmF00004P000ol0002`00OoE000018000?o0000
/@03o`<00_mB00004P000ol0002i00?oC`00018000?o0000_002odd0000B0003o`000;h00_m;0000
4P02ol400om800004P000ol0003300;oAP00018000?o0000a@02od@0000B0003o`000<L00ol0103o
oolm00004P000ol0003:00Go?00001800_o;00Go?000018000?o0000bP05oc`0000B0003o`000</0
0ol00`3oo`0j00000`04o`<00_l60003o`000=4000?o0000=`0000<000?o00000`001?l00?l50003
o`000=800_lg000010000ol000020004o`00o`D000?o0000e0000ol0000d00001@001Ol0003o0080
00?o00000`02omH000?o0000<`0000H000Co003o0P000ol000030003o`000=H00_lc00000`001?l0
0?l20004o`00o`D000?o0000f0000ol0000`00001002o`@00_l60003o`000=T000?o0000;`000180
00?o0000fP000ol0000^00004P02om`000?o0000;@00018000?o0000g0000ol0000/00004P000ol0
003M0003o`0002/0000B0003o`000=h000?o0000:P00018000?o0000g`000ol0000Y00004P000ol0
003P0003o`0002P0000B00;ohP000ol0000W00004P000ol0003R0003o`0002H0000B0003o`000><0
00?o00009@00018000?o0000i004ob<0000B0003o`000>@01OlR00004P02onD01OlR00004P000ol0
003T00Go8P00018000?o0000i@04ob80000B0003o`000>T000?o00007`00018000?o0000jP000ol0
000N00004P000ol0003[0003o`0001d0000B00;ok@000ol0000L00004P000ol0003/0003o`0001`0
000B0003o`000>d000?o00006`0000<01?l200?o1P000ol0003^0003o`0001X000030003o`0000H0
00?o00000`000ol0003_0003o`0001T000040003o`0000D000?o00000`02oo4000?o0000600000D0
00Co00000ol60003o`000?4000?o00005`0000H000Co003o20000ol0003a0003o`0001L000030004
o`00o`8000?o00001P000ol0003b0003o`0001H0000400;o0`04o`D000?o0000l`000ol0000E0000
4P000ol0003d0003o`0001@0000B00;omP000ol0000C00004P000ol0003f0003o`000180000B0003
o`000?H000?o00004P00018000?o0000m`000ol0000A00004P000ol0003h0003o`000100000B00;o
n@000ol0000@00004P000ol0003i0003o`0000l0000B0003o`000?X000?o00003P00018000?o0000
nP000ol0000>00004P000ol0003k0003o`0000d0000B0003o`000?/000?o00003@0001800_om0003
o`0000`0000B0003o`000?d000?o00002`00018000?o0000o@000ol0000;00004P000ol0003n0003
o`0000X0000B0003o`000?l00ol900004P02ool01Ol800004P000ol0003n00Go2000018000?o0000
oP05o`P0000B0003o`000?l00ol900004P000ol0003o00`00000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.696796, -2.24177, 
  0.0385028, 0.180667}}]
}, Closed]],

Cell[TextData[{
  "Similarly, the derivative of a built-in function without any arguments is \
returned in the form of a pure function. Here is the derivative of the ",
  StyleBox["Sin", "Input"],
  " function."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Sin'\)], "Input"],

Cell[BoxData[
    \(Cos[#1]&\)], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Using Pure Functions as Arguments", "Subsection"],

Cell[TextData[{
  "Pure functions are useful as criteria inside functions like ",
  StyleBox["Select", "Input"],
  ". Here we select from the list of integers from 1 to 100 all the elements \
whose square root is an integer (that is, all the perfect squares) using the \
pure predicate function ",
  StyleBox["IntegerQ[Sqrt[#]]&", "Input"],
  ", which returns ",
  StyleBox["True", "Input"],
  " if the square root of its argument is an integer."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Select[Range[100], IntegerQ[Sqrt[#]]&]\)], "Input"],

Cell[BoxData[
    \({1, 4, 9, 16, 25, 36, 49, 64, 81, 100}\)], "Output"]
}, Closed]],

Cell["\<\
Here we select integers between 3 and 10 from the integers from 1 \
to 15.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Select[Range[15], 3 < # < 10\ &]\)], "Input"],

Cell[BoxData[
    \({4, 5, 6, 7, 8, 9}\)], "Output"]
}, Closed]],

Cell[TextData[{
  "Pure predicate functions are often used in conditional patterns. The \
following function returns ",
  StyleBox["True", "Input"],
  " if its argument is between 3 and 10, and otherwise returns ",
  StyleBox["False", "Input"],
  "."
}], "Text"],

Cell[BoxData[
    \(between3and10[x_?\((3 < #1 < 10&)\)] := True\)], "Input"],

Cell[BoxData[
    \(between3and10[x_] := False\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \({between3and10[7], between3and10[17]}\)], "Input"],

Cell[BoxData[
    \({True, False}\)], "Output"]
}, Closed]],

Cell[TextData[{
  StyleBox["Sort", "Input"],
  " accepts an optional second argument, a function that determines if one \
element should be listed before another. Here we use a pure function as the \
ordering function inside ",
  StyleBox["Sort", "Input"],
  ", sorting our array of hurricane data in order of descending wind speed."
}], "Text"],

Cell["\<\
hurr =
\t{{\"Allison\",   65,  987},
\t {\"Barry\",     50,  995},
\t {\"Chantal\",   60,  992},
\t {\"Dean\",      40,  999},
\t {\"Erin\",      75,  975},
\t {\"Felix\",    115,  950},
\t {\"Gabrielle\", 60,  998},
\t {\"Humberto\",  90,  970},
\t {\"Iris\",      75,  970},
\t {\"Jerry\",     35, 1003}};\
\>", "Input"],

Cell[TextData[{
  "The pure sorting function expects two arguments, which we label ",
  StyleBox["#1", "Input"],
  " and ",
  StyleBox["#2", "Input"],
  "; and we arrange the sublists of ",
  StyleBox["hurr", "Input"],
  " so that the second part of the first argument is greater than the second \
part of the second argument."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(TableForm[Sort[hurr, #1[\([2]\)] > #2[\([2]\)]&]]\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {"\(\"Felix\"\)", "115", "950"},
          {"\(\"Humberto\"\)", "90", "970"},
          {"\(\"Iris\"\)", "75", "970"},
          {"\(\"Erin\"\)", "75", "975"},
          {"\(\"Allison\"\)", "65", "987"},
          {"\(\"Gabrielle\"\)", "60", "998"},
          {"\(\"Chantal\"\)", "60", "992"},
          {"\(\"Barry\"\)", "50", "995"},
          {"\(\"Dean\"\)", "40", "999"},
          {"\(\"Jerry\"\)", "35", "1003"}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Closed]],

Cell[TextData[{
  "Pure functions are useful inside high-level functions such as ",
  StyleBox["Map", "Input"],
  " and ",
  StyleBox["Apply", "Input"],
  ". Here we map a pure function that computes a numeric approximation to the \
base-2 logarithm of its argument over a list of numbers."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Map[Function[N[Log[2, #]]], Range[2, 10]]\)], "Input"],

Cell[BoxData[
    \({1.`, 1.58496250072115625`, 2.`, 2.32192809488736218`, 
      2.58496250072115607`, 2.80735492205760408`, 3.`, 3.16992500144231259`, 
      3.32192809488736262`}\)], "Output"]
}, Closed]],

Cell["\<\
Here is the same calculation with the pure function written more \
compactly.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Map[N[Log[2, #1]]&, Range[2, 10]]\)], "Input"],

Cell[BoxData[
    \({1.`, 1.58496250072115625`, 2.`, 2.32192809488736218`, 
      2.58496250072115607`, 2.80735492205760408`, 3.`, 3.16992500144231259`, 
      3.32192809488736262`}\)], "Output"]
}, Closed]],

Cell[TextData[{
  "See also ",
  StyleBox["Slot", "Input"],
  ", ",
  StyleBox["SlotSequence", "Input"],
  StyleBox[" (", "Text"],
  StyleBox["##", "Input"],
  StyleBox[")", "Text"]
}], "SeeAlso"]
}, Closed]],

Cell[CellGroupData[{

Cell["Exercises: Pure Functions", "Subsection",
  PageBreakAbove->True],

Cell["\<\
Map a pure function that squares its argument over a list of \
numbers ranging from 1 to 10.\
\>", "Question"],

Cell["Here is a pure function that squares its argument.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Function[x, x\^2]\)], "Input"],

Cell[BoxData[
    \(Function[x, x\^2]\)], "Output"]
}, Closed]],

Cell["Here is the function applied to a single argument.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(Function[x, x\^2]\)[16]\)], "Input"],

Cell[BoxData[
    \(256\)], "Output"]
}, Closed]],

Cell[TextData[{
  "We give the pure function as the first argument to ",
  StyleBox["Map", "Input"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Map[Function[x, x\^2], Range[10]]\)], "Input"],

Cell[BoxData[
    \({1, 4, 9, 16, 25, 36, 49, 64, 81, 100}\)], "Output"]
}, Closed]],

Cell["Here is a more compact form.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Map[#\^2&, Range[10]]\)], "Input"],

Cell[BoxData[
    \({1, 4, 9, 16, 25, 36, 49, 64, 81, 100}\)], "Output"]
}, Closed]],

Cell[TextData[{
  "The function ",
  StyleBox["Power", "Input"],
  " automatically maps itself over a list, so using ",
  StyleBox["Map", "Input"],
  " is unnecessary."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(#\^2&\)[Range[10]]\)], "Input"],

Cell[BoxData[
    \({1, 4, 9, 16, 25, 36, 49, 64, 81, 100}\)], "Output"]
}, Closed]],

Cell[TextData[{
  "Using a pure function as an argument to ",
  StyleBox["FixedPoint", "Input"],
  ", find the fixed point of the iteration ",
  Cell[BoxData[
      \(TraditionalForm\`x \[RightArrow] 1 + 1\/x\)]],
  ", where ",
  StyleBox["x",
    FontSlant->"Italic"],
  " has a starting value of 1.0. Find the fixed point of ",
  Cell[BoxData[
      \(TraditionalForm\`x \[RightArrow] \@\(1 + x\)\)]],
  ", again with ",
  StyleBox["x",
    FontSlant->"Italic"],
  " starting at 1.0."
}], "Question"],

Cell["Here is a pure function that adds 1 to its reciprocal.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Function[x, 1 + 1/x]\)], "Input"],

Cell[BoxData[
    \(Function[x, 1 + 1\/x]\)], "Output"]
}, Closed]],

Cell[TextData[{
  "Here is the same function given as an argument to ",
  StyleBox["FixedPoint", "Input"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(FixedPoint[Function[x, 1 + 1/x], 1.0]\)], "Input"],

Cell[BoxData[
    \(1.6180339887498949`\)], "Output"]
}, Closed]],

Cell["Here is a more compact version of the same expression.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(FixedPoint[1 + 1/#&, 1.0]\)], "Input"],

Cell[BoxData[
    \(1.6180339887498949`\)], "Output"]
}, Closed]],

Cell[TextData[{
  "Here is the fixed point of ",
  Cell[BoxData[
      \(TraditionalForm\`x \[RightArrow] \@\(1 + x\)\)]],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(FixedPoint[\@\(1 + #\)&, 1.0]\)], "Input"],

Cell[BoxData[
    \(1.6180339887498949`\)], "Output"]
}, Closed]],

Cell["Both iterations converge to the golden ratio.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(N[GoldenRatio]\)], "Input"],

Cell[BoxData[
    \(1.6180339887498949`\)], "Output"]
}, Closed]],

Cell[TextData[{
  "Create a one-dimensional random walk using ",
  StyleBox["NestList", "Input"],
  " and a pure function."
}], "Question"],

Cell[TextData[{
  "Inside ",
  StyleBox["NestList", "Input"],
  " we use a pure function that adds a random number (in this case an integer \
between ",
  Cell[BoxData[
      \(TraditionalForm\`\(-1\)\)]],
  " and 1) to its argument."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NestList[# + Random[Integer, {\(-1\), 1}]&, 0, 10]\)], "Input"],

Cell[BoxData[
    \({0, 1, 0, 1, 1, 2, 3, 4, 3, 2, 2}\)], "Output"]
}, Closed]],

Cell["Here is a longer list of points on the random walk.", "Text"],

Cell[BoxData[
    \(\(NestList[# + Random[Integer, {\(-1\), 1}]&, 0, 200]; \)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(ListPlot[%, PlotJoined \[Rule] True]; \)\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.00473821 0.150547 0.0452772 [
[.26072 .13805 -6 -9 ]
[.26072 .13805 6 0 ]
[.49763 .13805 -9 -9 ]
[.49763 .13805 9 0 ]
[.73454 .13805 -9 -9 ]
[.73454 .13805 9 0 ]
[.97145 .13805 -9 -9 ]
[.97145 .13805 9 0 ]
[.01131 .05999 -12 -4.5 ]
[.01131 .05999 0 4.5 ]
[.01131 .2411 -6 -4.5 ]
[.01131 .2411 0 4.5 ]
[.01131 .33166 -6 -4.5 ]
[.01131 .33166 0 4.5 ]
[.01131 .42221 -6 -4.5 ]
[.01131 .42221 0 4.5 ]
[.01131 .51276 -6 -4.5 ]
[.01131 .51276 0 4.5 ]
[.01131 .60332 -12 -4.5 ]
[.01131 .60332 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.26072 .15055 m
.26072 .1568 L
s
[(50)] .26072 .13805 0 1 Mshowa
.49763 .15055 m
.49763 .1568 L
s
[(100)] .49763 .13805 0 1 Mshowa
.73454 .15055 m
.73454 .1568 L
s
[(150)] .73454 .13805 0 1 Mshowa
.97145 .15055 m
.97145 .1568 L
s
[(200)] .97145 .13805 0 1 Mshowa
.125 Mabswid
.07119 .15055 m
.07119 .1543 L
s
.11857 .15055 m
.11857 .1543 L
s
.16596 .15055 m
.16596 .1543 L
s
.21334 .15055 m
.21334 .1543 L
s
.3081 .15055 m
.3081 .1543 L
s
.35548 .15055 m
.35548 .1543 L
s
.40287 .15055 m
.40287 .1543 L
s
.45025 .15055 m
.45025 .1543 L
s
.54501 .15055 m
.54501 .1543 L
s
.5924 .15055 m
.5924 .1543 L
s
.63978 .15055 m
.63978 .1543 L
s
.68716 .15055 m
.68716 .1543 L
s
.78192 .15055 m
.78192 .1543 L
s
.82931 .15055 m
.82931 .1543 L
s
.87669 .15055 m
.87669 .1543 L
s
.92407 .15055 m
.92407 .1543 L
s
.25 Mabswid
0 .15055 m
1 .15055 L
s
.02381 .05999 m
.03006 .05999 L
s
[(-2)] .01131 .05999 1 0 Mshowa
.02381 .2411 m
.03006 .2411 L
s
[(2)] .01131 .2411 1 0 Mshowa
.02381 .33166 m
.03006 .33166 L
s
[(4)] .01131 .33166 1 0 Mshowa
.02381 .42221 m
.03006 .42221 L
s
[(6)] .01131 .42221 1 0 Mshowa
.02381 .51276 m
.03006 .51276 L
s
[(8)] .01131 .51276 1 0 Mshowa
.02381 .60332 m
.03006 .60332 L
s
[(10)] .01131 .60332 1 0 Mshowa
.125 Mabswid
.02381 .08263 m
.02756 .08263 L
s
.02381 .10527 m
.02756 .10527 L
s
.02381 .12791 m
.02756 .12791 L
s
.02381 .17319 m
.02756 .17319 L
s
.02381 .19582 m
.02756 .19582 L
s
.02381 .21846 m
.02756 .21846 L
s
.02381 .26374 m
.02756 .26374 L
s
.02381 .28638 m
.02756 .28638 L
s
.02381 .30902 m
.02756 .30902 L
s
.02381 .35429 m
.02756 .35429 L
s
.02381 .37693 m
.02756 .37693 L
s
.02381 .39957 m
.02756 .39957 L
s
.02381 .44485 m
.02756 .44485 L
s
.02381 .46749 m
.02756 .46749 L
s
.02381 .49013 m
.02756 .49013 L
s
.02381 .5354 m
.02756 .5354 L
s
.02381 .55804 m
.02756 .55804 L
s
.02381 .58068 m
.02756 .58068 L
s
.02381 .03735 m
.02756 .03735 L
s
.02381 .01472 m
.02756 .01472 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02855 .15055 m
.03329 .19582 L
.03802 .15055 L
.04276 .10527 L
.0475 .05999 L
.05224 .01472 L
.05698 .05999 L
.06172 .10527 L
.06645 .15055 L
.07119 .19582 L
.07593 .15055 L
.08067 .19582 L
.08541 .19582 L
.09014 .15055 L
.09488 .19582 L
.09962 .2411 L
.10436 .28638 L
.1091 .28638 L
.11384 .33166 L
.11857 .37693 L
.12331 .33166 L
.12805 .33166 L
.13279 .33166 L
.13753 .37693 L
.14226 .37693 L
.147 .42221 L
.15174 .37693 L
.15648 .37693 L
.16122 .37693 L
.16596 .37693 L
.17069 .42221 L
.17543 .37693 L
.18017 .33166 L
.18491 .28638 L
.18965 .28638 L
.19439 .28638 L
.19912 .33166 L
.20386 .37693 L
.2086 .37693 L
.21334 .33166 L
.21808 .37693 L
.22281 .42221 L
.22755 .46749 L
.23229 .46749 L
.23703 .46749 L
.24177 .46749 L
.24651 .42221 L
.25124 .42221 L
.25598 .46749 L
.26072 .42221 L
Mistroke
.26546 .37693 L
.2702 .42221 L
.27493 .37693 L
.27967 .37693 L
.28441 .33166 L
.28915 .33166 L
.29389 .28638 L
.29863 .33166 L
.30336 .28638 L
.3081 .2411 L
.31284 .28638 L
.31758 .2411 L
.32232 .28638 L
.32706 .28638 L
.33179 .33166 L
.33653 .37693 L
.34127 .37693 L
.34601 .33166 L
.35075 .28638 L
.35548 .33166 L
.36022 .28638 L
.36496 .28638 L
.3697 .2411 L
.37444 .19582 L
.37918 .15055 L
.38391 .10527 L
.38865 .05999 L
.39339 .10527 L
.39813 .10527 L
.40287 .15055 L
.4076 .15055 L
.41234 .10527 L
.41708 .10527 L
.42182 .15055 L
.42656 .15055 L
.4313 .19582 L
.43603 .19582 L
.44077 .19582 L
.44551 .2411 L
.45025 .19582 L
.45499 .2411 L
.45973 .19582 L
.46446 .2411 L
.4692 .2411 L
.47394 .2411 L
.47868 .19582 L
.48342 .2411 L
.48815 .19582 L
.49289 .19582 L
.49763 .2411 L
Mistroke
.50237 .2411 L
.50711 .28638 L
.51185 .33166 L
.51658 .37693 L
.52132 .33166 L
.52606 .28638 L
.5308 .28638 L
.53554 .28638 L
.54027 .2411 L
.54501 .28638 L
.54975 .33166 L
.55449 .37693 L
.55923 .42221 L
.56397 .46749 L
.5687 .51276 L
.57344 .51276 L
.57818 .51276 L
.58292 .46749 L
.58766 .51276 L
.5924 .55804 L
.59713 .55804 L
.60187 .60332 L
.60661 .55804 L
.61135 .55804 L
.61609 .51276 L
.62082 .51276 L
.62556 .51276 L
.6303 .51276 L
.63504 .46749 L
.63978 .46749 L
.64452 .46749 L
.64925 .51276 L
.65399 .55804 L
.65873 .55804 L
.66347 .51276 L
.66821 .55804 L
.67294 .51276 L
.67768 .46749 L
.68242 .42221 L
.68716 .37693 L
.6919 .33166 L
.69664 .37693 L
.70137 .37693 L
.70611 .37693 L
.71085 .33166 L
.71559 .33166 L
.72033 .28638 L
.72507 .33166 L
.7298 .37693 L
.73454 .33166 L
Mistroke
.73928 .33166 L
.74402 .33166 L
.74876 .33166 L
.75349 .33166 L
.75823 .28638 L
.76297 .33166 L
.76771 .37693 L
.77245 .33166 L
.77719 .28638 L
.78192 .33166 L
.78666 .33166 L
.7914 .37693 L
.79614 .42221 L
.80088 .42221 L
.80561 .46749 L
.81035 .46749 L
.81509 .42221 L
.81983 .37693 L
.82457 .42221 L
.82931 .46749 L
.83404 .46749 L
.83878 .46749 L
.84352 .51276 L
.84826 .46749 L
.853 .42221 L
.85774 .42221 L
.86247 .46749 L
.86721 .46749 L
.87195 .42221 L
.87669 .46749 L
.88143 .46749 L
.88616 .51276 L
.8909 .46749 L
.89564 .46749 L
.90038 .42221 L
.90512 .42221 L
.90986 .46749 L
.91459 .51276 L
.91933 .46749 L
.92407 .42221 L
.92881 .42221 L
.93355 .37693 L
.93828 .37693 L
.94302 .42221 L
.94776 .37693 L
.9525 .33166 L
.95724 .33166 L
.96198 .37693 L
.96671 .37693 L
.97145 .33166 L
Mistroke
.97619 .33166 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{35, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/@P10`4000010?ooooooc?ooZ_ooISLg
=gIfM[Fe]OCdm03oZS/k>gYjN[Vi^OShn03ooeGooj[ooonI<onI0?mVoomVc3/k>gYjN[Vi^OShn03o
oclo?ginO[fm_Oclo5D00:X00?l00?l0VOl0I_l0<ol003lo?ginO[fm_Oclo0<30d92@X61PL30`000
EED0EJX0EOl0ELbIolbIc<bIV@<30d92@X61PL30`000E@L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0Z/`c
<l`c0<`0o`L71dI6AXF5QLC4a000ZP/;2dY:BXV9RLS8b000oeD0ojX0ool0oiW<VIW<IYW<<`/;2dY:
BXV9RLS8b000o`l?3di>CXf=SLc<c01E05EE0:YE0?mE09TcoiTcc9TcV@l?3di>CXf=SLc<c01E01<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEEFKo<fKo06K<oa<C4e9BDY6ATM3@d01EEALG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZVIVVFIVIVIV<aLG5eIFEYFEUMCDe01EZQ/K6eYJFYVIVMSHf01EoeEEojYEoomEoc?o
oc?oc3?oVA/K6eYJFYVIVMSHf01EoalO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ03>I<c>I03=VoalO7eiN
GYfMWMcLg02Z02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZEC<0VC<0IS<0<b<S8f9RHZ6QXN3Ph02ZEBLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2Io`2Ic02IVBLW9fIVIZFUYNCTi02ZZR/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`0c<`0c0000ob/[:fYZJZVYZNSXj02Zobl_;fi^KZf][Nc/k03o05Go0:[o0?oo0140
003^003M02l_;fi^KZf][Nc/k03o03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@00M`00E@00A3<c<g9b
L[6a/O3`l03oECLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l08@000?l08@0000l000?o0000o`0?0000
3`000ol0003o00l0000?0003o`000?l03`0000l000?o0000o`0?00003`02o`H000?o0000o`070000
3`000ol000050003o`000?l01`0000l000?o00001@000ol0003o00L0000?0003o`0000D000?o0000
o`0700003`000ol000050003o`000?l01`0000l000?o00001@000ol0003o00L0000?0003o`0000D0
00?o0000o`0700003`02o`D000?o0?l0o`0800003`000ol000040003o`3o0?l0200000l000?o0000
10000ol0o`3o00P0000700Co10000ol000040003o`3o0?l0200000L000?o00001@000ol000040003
o`3o0?l0200000P000?o000010000ol000040003o`3o0?l0200000030?oo00;o10000ol0000300?o
10000ol0o`1K0003o`000:T0000:0003o`00008000?o000010000ol0o`1K0003o`000:T000070004
o`00o`@000?o000010000ol0o`1K0003o`000:T0000800;o1@000ol000040003o`3o05/000?o0000
Z@0000l000?o00000`001?l00?mK0003o`000:T0000?0003o`0000<000Co003oF`000ol0002Y0000
3`02o`@000Co003oF`000ol0002Y00003`000ol000030005o`000?l0F@000ol0o`2Z00003`000ol0
00030005o`000?l0F@000ol0o`2Z00003`000ol000030005o`000?l0F@000ol0o`2Z00003`000ol0
00020003o`00008000?o0000E`000ol0o`2Z00003`000ol000020003o`00008000?o0000E`000ol0
o`2Z00003`02o`<000?o00000P000ol0001G0003o`3o00;o0`02oj<0000?0003o`00008000?o0000
0P000ol0000`00?o1002oah000Go0000o`0300;o3@04o`<00_l400;o<`04o`800ol400;o<`04o`<0
0_l400;o0`0000l000?o00000P000ol000020003o`0003<000Co003o0P000ol0000K0005o`000?l0
0`02o`l000Go0000o`020004o`00o`8000?o0000<P000ol000040004o`00o`8000?o0000<0000ol0
00030004o`00o`8000Co003o0P0000l000?o00000P000ol000020003o`0003<000Co003o0P000ol0
000K0005o`000?l00`02o`l000Go0000o`020004o`00o`8000?o0000<P000ol000040004o`00o`80
00?o0000<@000ol000020004o`00o`8000Co003o0P0000l000?o00000P000ol000030003o`0002l0
0ol30004o`00oa`000?o00000P001_l00?l0o`l000Go0000o`020004o`00o`8000?o0000<P001?l0
0003o`<000Co003o=0001Ol0003o008000Co003o0P01o`400@0000l000?o00000P000ol000030003
o`0002l000?o00000`001?l00?lL0003o`00008000Ko003o0?l?0005o`000?l00P001?l00?l20003
o`00038000Go0000o`050004o`00ocD000Co003o0P001?l00?l2007o0@0100003`000ol000020003
o`0000<000?o0000;`000ol000030004o`00oa`000?o00000P001_l00?l0o`d00ol30004o`00o`80
00Co003o<P03o`<000?o00000`001?l00?lb0004o`00o`8000Co003o0P001?l00?l200003`02o`80
00?o000010000ol0000_00Co0`02oad000?o00000`000ol0o`020003o`0000`000?o00000P02o`@0
0_le0004o`0000Co0`02oc@00_l400;o1002o`<0000?0005o`000?l01P000ol0001E0003o`0000<0
00?o0?l00P000ol0002P00003`001Ol0003o00H000?o0000E@000ol000030003o`3o008000?o0000
X00000l000Go0000o`060003o`0005D000?o00000`000ol0o`020003o`000:00000?0005o`000?l0
1`000ol0001C0003o`0000@00_l30003o`000:00000?0005o`000?l01`000ol0001C0003o`0000@0
0_l30003o`000:0000080?oo5ol200003`02o`8000?o00001@03o`<000?o00001@000ol0000:0003
o`0000X000?o00002`000ol0000:0003o`0000X000?o00000`000ol000040003o`0000@000?o0000
0`000ol0000:0003o`0000X000?o00002P000ol0000;0003o`0000X000?o00002P000ol0000:0003
o`0000X000?o00002P000ol0000:0003o`0000/000?o00001`0000l00_l20003o`0000D000?o0?l0
0`000ol0000]0003o`0001d000?o00002`000ol0000@0003o`0003l000?o0000?`000ol000070000
3`02o`8000?o00001@000ol0o`030003o`0004d000?o00002`000ol0002N00003`001Ol0o`3o00L0
00Co0?oo0P02odh000?o00002`000ol0002N00003`001Ol0o`3o00L000Co0?oo0P02odh000?o0000
2`000ol0002N00003`03o`030?l000H000Co0?oo0P02odh000?o00002`000ol0002N00003`001?l0
ool90007o`3o0?l0o`1=0003o`0000d000?o0000W@0000l000Co0?oo2@001ol0o`3o0?l0C@000ol0
000=0003o`0009d0000?0004o`3oo`T000Oo0?l0o`3o04d000?o00003@000ol0002M00003`001?l0
0?l90003o`0000;o0P000ol0001:0003o`0000d000?o0000W@0000l000Co003o2@000ol00002o`80
00?o0000BP000ol0000=0003o`0009d0000?00;o00<0o`0020000ol00002o`8000?o0000BP000ol0
000=00?o0P001?l00?l40003o`0000;oSP0000l000?o00004@000ol0001:0003o`0000l000Co003o
0P000ol000020003o`0000;oSP0000l000?o00004@000ol0001:0003o`0000l000Co003o0P000ol0
00020003o`0000;oSP0000l000?o00004@000ol0001:0003o`0000l000Co003o0P000ol000020003
o`0000;oSP0000l000?o00004@000ol0001:0003o`00010000Co0?l00_l40005o`3o0?l0SP0000l0
00?o00004@000ol0001:0003o`00010000Co0?l00_l40005o`3o0?l0SP0000l000?o00004@000ol0
001:0003o`00010000Co0?l00_l40005o`3o0?l0SP0000l00_lC0003o`0004P000?o00004@02o`05
0?oo0?l00P001?l0ool20003o`0008/0000?0003o`00018000?o0000B0000ol0000A00;o00D0ool0
o`020004o`3oo`8000?o0000R`0000l000?o00004P000ol000180003o`0001400_l01@3oo`3o0080
00Co0?oo0P000ol0002;00003`000ol0000B0003o`0004P000?o00004@02o`050?oo0?l00P001?l0
ool20003o`0008/0000700Co10000ol0000B0003o`0004P000?o00004P000ol0o`020006o`00o`3o
0`000ol0002;00001`000ol000050003o`00018000?o0000B0000ol0000B0003o`3o008000Ko003o
0?l30003o`0008/000080003o`0000@00olB0003o`0003L000?o0?l03P000ol0000B0003o`3o0080
1?l00`3o000200?o2@000ol0001o00002@000ol000030003o`00018000?o0000=`000ol0o`0>0003
o`00028000?o00001`000ol0001o00002P000ol000020003o`00018000?o0000=`000ol0o`0>0003
o`00028000?o00001`000ol0001o00001`001?l00?l40003o`00018000?o0000=`000ol0o`0>0003
o`00028000?o00001`000ol0001o00002002o`D000?o00004P000ol0000f00;o00<0ool030000ol0
000S0003o`0000L000?o0000O`0000l000?o00004P000ol0000f00;o00<0ool030000ol0000S0003
o`0000L000?o0000O`0000l00_lC0003o`0003H00_l00`3oo`0<0003o`0002<000?o00001`000ol0
001o00003`000ol0000C0003o`0003D000Go0?l0o`0<0003o`0002@000?o00001@000ol0o`200000
3`000ol0000C0003o`0003D000Go0?l0o`0<0003o`0002@000?o00001@000ol0o`2000003`000ol0
000C0003o`0003D000Go0?l0o`0<0003o`0002@000?o00001@000ol0o`2000003`000ol0000C0003
o`0003D000Go0?l0o`0<0003o`0002@000?o00001@000ol0o`2000003`000ol0000C0003o`0003@0
00Co003o0P000ol000080003o`0002D000?o00001@000ol0o`2000003`000ol0000C0003o`0003@0
00Co003o0P000ol000080003o`0002D000?o00001@000ol0o`2000003`02oa@00olD00?o6`000ol0
o`020003o`0000;o1P001?l0oolW0003o`0000801?l00`3o000_0003o`0000L000?o00000`000ol0
000m00003`000ol0000E0003o`00018000?o0?l06`000ol0o`060003o`0000@000?o0?l0:0000ol0
00020003o`00008000?o0000;P000ol000070003o`0000<000?o0000?@0000l000?o00005@000ol0
000B0003o`3o01/000?o0?l01P000ol000040003o`3o02P000?o00000P000ol000020003o`0002h0
00?o00001`000ol000030003o`0003d0000?0003o`0001D000?o00004P000ol0o`0K0003o`3o00H0
00?o000010000ol0o`0X0003o`00008000?o00000P000ol0000^0003o`0000L000?o00000`000ol0
000m00003`000ol0000E0003o`00014000Go0000o`0I00;o00<0o`001@000ol0000300;o00<0o`00
9`000ol000020003o`0000<000?o0000;@000ol0000700;o0`02ocl0000?0003o`0001D000?o0000
4@001Ol0003o01T00_l00`3o00050003o`0000<00_l00`3o000W0003o`00008000?o00000`000ol0
000]0003o`0000L00_l300;o?`0000l00_lF0003o`00014000Go0000o`0I00;o00<0o`001@000ol0
000300;o00<0o`009`000ol000020003o`0000<000?o0000;@000ol0000700;o0`02ocl0000?0003
o`0001H000?o000040001Ol0003o01T000?o0?l020000ol000020003o`3o02X000Co003o1P000ol0
000/0003o`3o00L000?o0?l00`000ol0o`0n00003`000ol0000F0003o`00010000Go0000o`0I0003
o`3o00P000?o00000P000ol0o`0Z0004o`00o`H000?o0000;0000ol0o`070003o`3o00<000?o0?l0
?P0000l000?o00005P000ol0000@0005o`000?l06@000ol0o`080003o`00008000?o0?l0:P001?l0
0?l60003o`0002`000?o0?l01`000ol0o`030003o`3o03h000090003o`0000<000?o00005P000ol0
000?0003o`0000<000?o00005@001?l00?l80005o`000?l00P000ol0000X0004o`00o`L000?o0000
:`000ol0o`070006o`00o`3o0P000ol0000l00002@000ol000030003o`0001H000?o00003`000ol0
00030003o`0001D000Co003o20001Ol0003o008000?o0000:0001?l00?l70003o`0002/000?o0?l0
1`001_l00?l0o`8000?o0000?00000H01Ol400?o5P000ol00003o``000?o00000`001?l00?lC00;o
0P000ol000060005o`000?l00P000ol0000X0004o`00o`L000?o000090000ol0000200?o00@0o`00
1_l20003o`3o00800_l]00?o0`02o`P000060004o`00o`D000?o00005P001_l00?l0o``000?o0000
0`001?l00?lC0003o`0000X000Go0000o`0]0004o`00o`L000?o000090000ol000020005o`000?l0
0P000ol000050003o`3o00<000?o0000:`000ol0o`030003o`0000L000070003o`3o00D000?o0000
5P001_l00?l0o``000?o00000`001?l00?lC0003o`0000X000Go0000o`0]0004o`00o`L000?o0000
90000ol000020005o`000?l00P000ol000050003o`3o00<000?o0000:`000ol0o`030003o`0000L0
000800;o1@000ol0000F0006o`00o`3o30000ol000030004o`00oa<000?o00002P001Ol0003o02d0
00Co003o1`000ol0000T0003o`00008000Go0000o`020003o`0000D000?o0?l00`000ol0000[0003
o`3o00<000?o00001`0000T000?o00000`000ol0000F0003o`3o008000?o00002P000ol000030003
o`0000;o4P000ol0000;0004o`00obd000?o0?l020000ol0000T0003o`00008000?o00000P000ol0
o`070003o`3o00@000?o0000:P000ol0o`020003o`0000P0000?0003o`0001H000?o0?l00P000ol0
000:0003o`0000<000?o00000_lB0003o`0000/000Co003o;@000ol0o`080003o`0002@000?o0000
0P000ol000020003o`3o00L000?o0?l010000ol0000Z0003o`3o008000?o0000200000l00_lG0003
o`3o008000?o00002P000ol000030003o`0000;o4P000ol0000;0004o`00obd000?o0?l020000ol0
000T0003o`00008000?o00000P000ol0o`070003o`3o00@000?o0000:P000ol0o`020003o`0000P0
000?0003o`0001L00_l30003o`0000P000?o00001@02o`030?l0010000?o000030000ol0o`0_00;o
2@000ol0000R0003o`3o008000?o00000`02o`T000?o00000`000ol0000Y0007o`000?l0o`0:0000
3`000ol0000G00;o0`000ol000080003o`0000D00_l00`3o000@0003o`0000`000?o0?l0;`02o`T0
00?o00008P000ol0o`020003o`0000<00_l90003o`0000<000?o0000:@001ol0003o0?l02P0000l0
00?o00005`02o`<000?o000020000ol0000500;o00<0o`0040000ol0000<0003o`3o02l00_l90003
o`00028000?o0?l00P000ol0000300;o2@000ol000030003o`0002T000Oo0000o`3o00X0000?0003
o`0001L00_l30003o`0000P000?o00001@02o`030?l0010000?o000030000ol0o`0_00;o2@000ol0
000R0003o`3o008000?o00000`02o`T000?o00000`000ol0000Y0007o`000?l0o`0:00003`000ol0
000G0003o`00008000?o000020000ol0000500;o0P000ol0000>0003o`0000d00_l_0003o`0000P0
00?o00008P000ol0o`020003o`0000@000?o00001`000ol000040003o`0002P000Co00000_l;0000
3`000ol0000G0003o`00008000?o000020000ol0000500;o0P000ol0000>0003o`0000d00_l_0003
o`0000P000?o00008P000ol0o`020003o`0000@000?o00001`000ol000040003o`0002P000Co0000
0_l;00003`02oaP000?o00000P03o`030?oo00?o0P000ol0000500;o0P000ol0000:0003o`0000;o
3`02obl000?o000020000ol0000R0003o`3o00?o1P000ol000070003o`0000@000?o000010000ol0
000M00;o0P001?l00002o`/0000?0003o`0001h000?o0?l00`001?l00?l;0003o`0000X000Co003o
C0000ol0000R0003o`0001X000?o000010000ol0000M00;o0P000ol0000>00003`000ol0000N0003
o`3o00<000Co003o2`000ol0000:0004o`00od`000?o00008P000ol0000J0003o`0000@000?o0000
7@02o`8000?o00003P0000l000?o00007P000ol0o`030004o`00o`/000?o00002P001?l00?m<0003
o`00028000?o00006P000ol000040003o`0001d00_l20003o`0000h0000?0003o`0001h000?o0?l0
10000ol0o`0;0003o`0000X000?o0?l0C@000ol0000Q0003o`0001/000?o00001002oah000Go0?l0
o`0@00003`000ol0000N0003o`3o00@000?o0?l02`000ol0000:0003o`3o04d000?o00008@000ol0
000K0003o`0000@00_lN0005o`3o0?l0400000l00_lO0003o`3o00@000?o0?l02`000ol0000:0003
o`3o04d000?o00008@000ol0000K0003o`0000@00_lN0005o`3o0?l0400000l000?o00007`000ol0
000300;o3@000ol000080004o`3oodh000?o000080000ol0000L0003o`00008000?o0?l07@000ol0
0002oa40000?0003o`0001l000?o00000`02o`d000?o000020001?l0oom>0003o`00020000?o0000
70000ol000020003o`3o01d000?o00000_lA00003`000ol0000O0003o`0000<00_l=0003o`0000P0
00Co0?ooCP000ol0000P0003o`0001`000?o00000P000ol0o`0M0003o`0000;o4@0000P00_l50003
o`0001l000?o000010000ol0000;0003o`0000P000?o0?l0C`000ol0000O0003o`0001d000?o0000
0P001?l00?lL0005o`000?l04@0000L000Co003o10000ol0000O0003o`0000@000?o00002`000ol0
00080003o`3o04l000?o00007`000ol0000M0003o`00008000Co003o70001Ol0003o014000070004
o`00o`@00olO0003o`0000@000?o00002`000ol0000400;o0P000ol0o`1?0003o`0001l000?o0000
7@02o`<000Co003o1`02o`<000?o00001@02o`@00ol30003o`0000l0000700?o1@000ol0000d0003
o`0000@00_l20003o`0004l000?o00007`000ol0000N0005o`000?l00P000ol0000500;o0`000ol0
000500;o10000ol0000E00001`000ol000050003o`0003@000?o00001002o`8000?o0000C`000ol0
000O0003o`0001h000Go0000o`020003o`0000D00_l30003o`0000D00_l40003o`0001D000070003
o`0000D000?o0000=0000ol0000400;o0P000ol0001?0003o`0001l000?o00007P001Ol0003o0080
00?o00001@02o`<000?o00001@02o`@000?o00005@0000P00ol40003o`0003@000?o00000`001Ol0
o`3o05<000?o00007P000ol0000O0004o`00o`8000?o000010000ol0o`030003o`0000@000?o0?l0
10000ol0000E00003`000ol0000d0003o`0000<000Go0?l0o`1C0003o`0001h000?o00007`001?l0
0?l20003o`0000@000?o0?l00`000ol000040003o`3o00@000?o00005@0000l00_le0003o`0000<0
00Go0?l0o`1C0003o`0001h000?o00007`001?l00?l20003o`0000@000?o0?l00`000ol000040003
o`3o00@000?o00005@0000l000?o0000=@000ol000020003o`0000;oD`000ol0000M0003o`000200
00?o0?l010000ol000030008o`00o`3o0?l50004o`00o`8000?o00005P0000l000?o0000=@000ol0
00020003o`0000;oD`000ol0000M0003o`00020000?o0?l010000ol000030008o`00o`3o0?l50004
o`00o`8000?o00005P0000l000?o0000=@000ol000020003o`0000;oD`000ol0000M0003o`000200
00?o0?l010000ol000030008o`00o`3o0?l50004o`00o`8000?o00005P0000l000?o0000=@000ol0
00020003o`0000;oD`000ol0000M0003o`00020000?o0?l010000ol000030008o`00o`3o0?l50004
o`00o`8000?o00005P0000l000?o0000=@001Ol0003o00<000?o0000D`000ol0000L0003o`000240
0_l40003o`00008000Wo0000o`3o0?l010001Ol0003o008000?o00005P0000l000?o0000=@001Ol0
003o00<000?o0000D`000ol0000L0003o`0002400_l40003o`00008000Wo0000o`3o0?l010001Ol0
003o008000?o00005P0000l00_lf00Go0`000ol0001C0003o`00008000?o00002`04o`P000?o0000
8@02o`@01?l00`3o000200?o00D0oooo0002o`<000Co003o600000l000?o0000T`000ol000020003
o`0000/000Co003o20000ol0000Z0003o`3o00T000?o0?l010001?l00?lH00003`000ol0002C0003
o`00008000?o00002`001?l00?l80003o`0002X000?o0?l02@000ol0o`040004o`00oaP0000?0003
o`0009<000?o00000P000ol0000;0004o`00o`P000?o0000:P000ol0o`090003o`3o00@000Co003o
600000l000?o0000T`000ol000020003o`0000/000Co003o20000ol0000Z0003o`3o00T000?o0?l0
1@000ol0o`0H00003`000ol0002C0003o`00008000?o00002`001?l00?l80003o`0002X000?o0?l0
2@000ol0o`050003o`3o01P0000?00;oU0000ol000020003o`0000/000Co003o20000ol0000Z0003
o`3o00T000?o0?l01@000ol0o`0H00003`000ol0002D0006o`00o`3o2`000ol000020003o`0000@0
00?o0000;0000ol000090003o`0000@00_lI00003`000ol0002D0006o`00o`3o2`000ol000020003
o`0000@000?o0000;0000ol000090003o`0000@00_lI00003`000ol0002D0006o`00o`3o2`000ol0
00020003o`0000@000?o0000;0000ol000090003o`0000@00_lI00002002o`D000?o0000U0001_l0
0?l0o`/000?o00000P000ol000040003o`0002`000?o00002@000ol000050003o`0001L000070004
o`00o`@000?o0000U0001_l00?l0o`/000?o00000P000ol000040003o`0002`000?o00002@000ol0
00050003o`0001L000070004o`00o`@00onD00Co00<0o`001P05o`@000Go0000o`020003o`0002`0
00?o00002@000ol000050003o`0001L0000800;o1@000ol0002I0003o`0000D000?o00001P001Ol0
003o008000?o0000FP0000L000Co003o10000ol0002I0003o`0000D000?o00001P001Ol0003o0080
00?o0000FP0000L000Co003o10000ol0002I0003o`0000D000?o00001P001Ol0003o008000?o0000
FP0000P00_l50003o`0009T000?o00001@000ol000070006o`00o`3oG@0000l000?o0000V@000ol0
00050003o`0000L000Ko003o0?mM00003`000ol0002I0003o`0000D000?o00001`001_l00?l0oed0
000?00;oV`000ol000030003o`0000P000Co0?l00_mM00003`000ol0002J0003o`0000<000?o0000
20001?l0o`02oed0000?0003o`0009X000?o00000`000ol000080004o`3o00;oG@0000l000?o0000
VP000ol000030003o`0000P000Co0?l00_mM00003`000ol0002J0003o`0000<000?o00002@02o`03
0?l005d0000?0003o`0009X000?o00000`000ol0000900;o00<0o`00G@0000l00_nK00?o00@0oooo
2`02o`030?l005d0000?0003o`0009`000?o0?l0K`0000l000?o0000W0000ol0o`1_00003`000ol0
002L0003o`3o06l0000?0003o`0009`000?o0?l0K`0000l000?o0000W0000ol0o`1_00003`02oid0
00?o0?l0K`0000l000?o0000W@000ol0001^00003`000ol0002M0003o`0006h0000?0003o`0009d0
00?o0000KP0000030?oo00;o0`02o`D000?o0000W@000ol0001^00000`001Ol0003o008000?o0000
0P000ol0002M0003o`0006h000030005o`000?l00P000ol0000200?oW@000ol0001^00000`001Ol0
003o008000?o00000P000ol0003o00l000030005o`000?l00P000ol000020003o`000?l03`000004
0?ooo`<000Co003o10000ol0003o00l000030003o`0000800_l50003o`000?l03`000?l08@000?l0
8@000?l08@000001
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-11.7807, -3.53602, 0.761804,
   0.0797219}}]
}, Closed]],

Cell[TextData[{
  "Use ",
  StyleBox["Table", "Input",
    FontFamily->"Courier"],
  " and ",
  StyleBox["FindRoot", "Input",
    FontFamily->"Courier"],
  " to generate a list of roots of the equation ",
  Cell[BoxData[
      \(TraditionalForm\`sin(x\^3) = cos(3\ x\^2)\)]],
  ", with starting values for ",
  StyleBox["FindRoot", "Input",
    FontFamily->"Courier"],
  " ranging from ",
  Cell[BoxData[
      \(TraditionalForm\`\(-3.1\)\)]],
  " to 3.1 in increments of 0.25. Remove duplicates in the list of roots \
using ",
  StyleBox["Union", "Input",
    FontFamily->"Courier"],
  " by creating a pure function as the value of the option ",
  StyleBox["SameTest", "Input",
    FontFamily->"Courier"],
  ", considering two roots duplicates if they differ by less than ",
  Cell[BoxData[
      \(TraditionalForm\`1\/10\)]],
  "."
}], "Question"],

Cell["Here is a list of the roots.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Table[
      FindRoot[Sin[x\^3] == Cos[3\ x\^2], {x, st}], {st, \(-3.1\), 3.1, 0.25}]
      \)], "Input"],

Cell[BoxData[
    \({{x \[Rule] \(-2.35974322113053025`\)}, {
        x \[Rule] \(-2.87818742162649154`\)}, {
        x \[Rule] \(-2.55113271022457066`\)}, {
        x \[Rule] \(-2.35974322067422148`\)}, {
        x \[Rule] \(-2.14085759978379375`\)}, {
        x \[Rule] \(-1.88141068938637818`\)}, {
        x \[Rule] \(-1.55388213680590574`\)}, {
        x \[Rule] \(-1.0753243417919851`\)}, {
        x \[Rule] \(-1.07532434492606587`\)}, {
        x \[Rule] \(-0.855935424800987654`\)}, {
        x \[Rule] \(-0.855935441473415892`\)}, {
        x \[Rule] \(-2.87818742676022907`\)}, {
        x \[Rule] 10.0994544209207881`}, {x \[Rule] 4.03677494682184523`}, {
        x \[Rule] 0.655519182813424805`}, {x \[Rule] 0.6555191846798464`}, {
        x \[Rule] 0.655519182365773467`}, {x \[Rule] 1.34453815977552859`}, {
        x \[Rule] 1.34453815965875844`}, {x \[Rule] 1.72900518514319978`}, {
        x \[Rule] 2.25436520084021418`}, {x \[Rule] 4.28198019795632411`}, {
        x \[Rule] 2.45832776143120756`}, {x \[Rule] 2.63894832360571873`}, {
        x \[Rule] 2.95128708643978434`}}\)], "Output"]
}, Closed]],

Cell[TextData[{
  "To extract only the roots, we substitute the list of rules into the \
variable ",
  StyleBox["x", "Input"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(theroots = x /. %\)], "Input"],

Cell[BoxData[
    \({\(-2.35974322113053025`\), \(-2.87818742162649154`\), 
      \(-2.55113271022457066`\), \(-2.35974322067422148`\), 
      \(-2.14085759978379375`\), \(-1.88141068938637818`\), 
      \(-1.55388213680590574`\), \(-1.0753243417919851`\), 
      \(-1.07532434492606587`\), \(-0.855935424800987654`\), 
      \(-0.855935441473415892`\), \(-2.87818742676022907`\), 
      10.0994544209207881`, 4.03677494682184523`, 0.655519182813424805`, 
      0.6555191846798464`, 0.655519182365773467`, 1.34453815977552859`, 
      1.34453815965875844`, 1.72900518514319978`, 2.25436520084021418`, 
      4.28198019795632411`, 2.45832776143120756`, 2.63894832360571873`, 
      2.95128708643978434`}\)], "Output"]
}, Closed]],

Cell[TextData[{
  StyleBox["Union", "Input"],
  " removes duplicates of a single list."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Union[theroots]\)], "Input"],

Cell[BoxData[
    \({\(-2.87818742676022907`\), \(-2.87818742162649154`\), 
      \(-2.55113271022457066`\), \(-2.35974322113053025`\), 
      \(-2.35974322067422148`\), \(-2.14085759978379375`\), 
      \(-1.88141068938637818`\), \(-1.55388213680590574`\), 
      \(-1.07532434492606587`\), \(-1.0753243417919851`\), 
      \(-0.855935441473415892`\), \(-0.855935424800987654`\), 
      0.655519182365773467`, 0.655519182813424805`, 0.6555191846798464`, 
      1.34453815965875844`, 1.34453815977552859`, 1.72900518514319978`, 
      2.25436520084021418`, 2.45832776143120756`, 2.63894832360571873`, 
      2.95128708643978434`, 4.03677494682184523`, 4.28198019795632411`, 
      10.0994544209207881`}\)], "Output"]
}, Closed]],

Cell[TextData[{
  "By default, ",
  StyleBox["Union", "Input"],
  " considers two elements duplicates if they are equal. However, because ",
  StyleBox["FindRoot", "Input"],
  " uses numerical methods, uncertainty can appear in the roots it finds, and \
the uncertainty can cause ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " not to recognize that different approximations to the same root are the \
same number."
}], "Text"],

Cell[TextData[{
  "To change the default criterion that determines which elements are \
duplicates, we change the value of the option ",
  StyleBox["SameTest", "Input"],
  ". ",
  StyleBox["SameTest", "Input"],
  " expects a function of two variables that returns ",
  StyleBox["True", "Input"],
  " if its two arguments are \[OpenCurlyDoubleQuote]the same\
\[CloseCurlyDoubleQuote]. Here is a named function that returns ",
  StyleBox["True", "Input"],
  " if the distance between its two arguments is less than ",
  Cell[BoxData[
      \(TraditionalForm\`1\/10\)]],
  "."
}], "Text"],

Cell[BoxData[
    \(theSameQ[x_, y_] := Abs[x - y] < 1\/10\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(theSameQ[9.75, 9.82]\)], "Input"],

Cell[BoxData[
    \(True\)], "Output"]
}, Closed]],

Cell[TextData[{
  "Here we use ",
  StyleBox["Union", "Input"],
  " with a pure function equivalent to ",
  StyleBox["theSameQ", "Input"],
  " as the value of ",
  StyleBox["SameTest", "Input"],
  ". Here is the list of the roots with the duplicates (as we have defined \
them) removed."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Union[theroots, SameTest \[Rule] \((Abs[#1 - #2] < 1\/10&)\)]\)], 
  "Input"],

Cell[BoxData[
    \({\(-2.87818742676022907`\), \(-2.55113271022457066`\), 
      \(-2.35974322113053025`\), \(-2.14085759978379375`\), 
      \(-1.88141068938637818`\), \(-1.55388213680590574`\), 
      \(-1.07532434492606587`\), \(-0.855935441473415892`\), 
      0.655519182365773467`, 1.34453815965875844`, 1.72900518514319978`, 
      2.25436520084021418`, 2.45832776143120756`, 2.63894832360571873`, 
      2.95128708643978434`, 4.03677494682184523`, 4.28198019795632411`, 
      10.0994544209207881`}\)], "Output"]
}, Closed]],

Cell[" ", "EndExercises"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Packages", "Section"],

Cell[CellGroupData[{

Cell["Contexts", "Subsection"],

Cell[TextData[{
  "In addition to the notion of variables and constants that are local to a \
routine (as created by ",
  StyleBox["Module", "Input"],
  ", ",
  StyleBox["Block", "Input"],
  ", and ",
  StyleBox["With", "Input"],
  "), ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " supports the organization of symbols with the notion of ",
  StyleBox["contexts",
    FontSlant->"Italic"],
  "."
}], "Text"],

Cell[TextData[{
  "The idea of contexts is similar to the idea of different directories in a \
file system. Just as there is no conflict between two files with the name ",
  StyleBox["ReadMe.txt", "Output",
    FontFamily->"Courier"],
  " if the two files are contained in different directories, there is no \
conflict between two symbols called ",
  StyleBox["newvar", "Input"],
  " if they are defined within different contexts."
}], "Text"],

Cell[TextData[{
  "Every symbol defined in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " is defined within a context, and the ",
  StyleBox["full name",
    FontSlant->"Italic"],
  " of a symbol ",
  StyleBox["x",
    FontSlant->"Italic"],
  " is ",
  StyleBox["context",
    FontSlant->"Italic"],
  StyleBox["`", "Input"],
  StyleBox["x",
    FontSlant->"Italic"],
  ", where ",
  StyleBox["context",
    FontSlant->"Italic"],
  " is the name of the context in which the symbol is defined and ",
  StyleBox["x",
    FontSlant->"Italic"],
  " is called the ",
  StyleBox["short name",
    FontSlant->"Italic"],
  " of the variable. We call the backquote character ",
  StyleBox["`", "Input"],
  " a context mark, similar to the directory separator character for full \
file pathnames (\[OpenCurlyDoubleQuote]",
  StyleBox[":", "Output",
    FontFamily->"Courier"],
  "\[CloseCurlyDoubleQuote] on a Macintosh file system,  \
\[OpenCurlyDoubleQuote]",
  StyleBox["/", "Output",
    FontFamily->"Courier"],
  "\[CloseCurlyDoubleQuote]on a Unix file system, and \
\[OpenCurlyDoubleQuote]",
  StyleBox["\\", "Output",
    FontFamily->"Courier"],
  "\[CloseCurlyDoubleQuote] on a Microsoft Windows file system). The default \
context for new symbols is ",
  StyleBox["Global`", "Input"],
  ", and we create symbols in other contexts at any time by simply specifying \
the full name of the variable, in particular including the context name."
}], "Text"],

Cell[TextData[{
  "Here we define a new variable called ",
  StyleBox["newvar", "Input"],
  ". ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " places the symbol in the context ",
  StyleBox["Global`", "Input"],
  ", as revealed by entering ",
  StyleBox["?newvar", "Input"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(newvar = 13; \(?newvar\)\)], "Input"],

Cell[BoxData[
    \("Global`"\[InvisibleSpace]"newvar"\)], "Print"],

Cell[BoxData[
    InterpretationBox[
      StyleBox["\(newvar\\  = \\ 13\)",
        ShowStringCharacters->True,
        NumberMarks->True],
      InputForm[ 
        Definition[ newvar]],
      Editable->True,
      AutoDelete->True]], "Print"]
}, Closed]],

Cell[TextData[{
  "In every ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " session the system variable ",
  StyleBox["$Context", "Input"],
  " stores the current context. When referring to a symbol within this \
context we may use its short name. "
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \($Context\)], "Input"],

Cell[BoxData[
    \("Global`"\)], "Output"]
}, Closed]],

Cell[TextData[{
  "To create another symbol with the short name ",
  StyleBox["newvar", "Input"],
  ", we specify a new context in which to place it, in this case ",
  StyleBox["mycontext`", "Input"],
  "."
}], "Text"],

Cell[BoxData[
    \(\(mycontext`newvar = A\^2 + B\^2; \)\)], "Input"],

Cell[TextData[{
  "When we refer to the short name ",
  StyleBox["newvar", "Input"],
  ", ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " looks first in the current context, ",
  StyleBox["Global`", "Input"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(newvar\)], "Input"],

Cell[BoxData[
    \(13\)], "Output"]
}, Closed]],

Cell["\<\
We can always refer to a symbol in another context by using its \
full name.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(mycontext`newvar\)], "Input"],

Cell[BoxData[
    \(A\^2 + B\^2\)], "Output"]
}, Closed]],

Cell[TextData[{
  "We can tell ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " to look first in the context ",
  StyleBox["mycontext`", "Input"],
  " by changing the value of ",
  StyleBox["$Context", "Input"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \($Context = "mycontext`"\)], "Input"],

Cell[BoxData[
    \("mycontext`"\)], "Output"]
}, Closed]],

Cell[TextData[{
  "When we type the short name ",
  StyleBox["newvar", "Input"],
  ", ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " now looks first in the context ",
  StyleBox["mycontext`", "Input"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(newvar\)], "Input"],

Cell[BoxData[
    \(A\^2 + B\^2\)], "Output"]
}, Closed]],

Cell[TextData[{
  "However, we can refer to the variable ",
  StyleBox["newvar", "Input"],
  " in the context ",
  StyleBox["Global`", "Input"],
  " by using its full name."
}], "Text"],

Cell[CellGroupData[{

Cell["Global`newvar", "Input"],

Cell[BoxData[
    \(13\)], "Output"]
}, Closed]],

Cell[TextData[{
  "We can make ",
  StyleBox["Global`", "Input"],
  " the current context again by resetting the value of ",
  StyleBox["$Context", "Input"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \($Context = "Global`"\)], "Input"],

Cell[BoxData[
    \("Global`"\)], "Output"]
}, Closed]],

Cell[TextData[{
  "The global variable ",
  StyleBox["$ContextPath", "Input"],
  " contains a context search path, which is similar to the directory search \
path used when working with the local file system. When we use the short name \
of a symbol that is not defined in the current context, ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " will search this list of contexts for a symbol with the given short \
name."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \($ContextPath\)], "Input"],

Cell[BoxData[
    \({"Global`", "System`"}\)], "Output"]
}, Closed]],

Cell[TextData[{
  "Contexts may be hierarchical, so the full name of a s