(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[   2598999,      86535]*)
(*NotebookOutlinePosition[   2605259,      86705]*)
(*  CellTagsIndexPosition[   2603990,      86672]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
  "Introduction to Data Analysis with ",
  StyleBox["Mathematica",
    FontSlant->"Italic"]
}], "Title"],

Cell[CellGroupData[{

Cell["1. Importing and Exporting Data", "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"Importing and Exporting Data"],

Cell[CellGroupData[{

Cell["Preliminaries", "Subsection",
  CellTags->"Working with the Local File System"],

Cell[CellGroupData[{

Cell["Strings", "Subsubsection"],

Cell[TextData[{
  "A ",
  StyleBox["string",
    FontSlant->"Italic"],
  " is a sequence of characters inside quotation marks. Because ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " does not normally interpret the contents of a string as ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " commands, a string is a useful way to represent many kinds of data. For \
example, file and directory names are represented as strings."
}], "Text"],

Cell[TextData[{
  "There are several special characters that cannot be directly entered in a \
string, except by using ",
  StyleBox["escape sequences",
    FontSlant->"Italic"],
  ". String escape sequences consist of a backslash followed by a single \
letter."
}], "Text"],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " treats a newline between quotation marks as a space."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \("\<Sentence one.
	Sentence two.\>"\)], "Input"],

Cell[BoxData[
    \("Sentence one. Sentence two."\)], "Output"]
}, Closed]],

Cell[TextData[{
  "To put a proper newline character in a string, we use the escape sequence \
",
  StyleBox["\\n", "Input"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \("\<This is line one.\nAnd this is line two.\>"\)], "Input"],

Cell[BoxData[
    \("This is line one.\nAnd this is line two."\)], "Output"]
}, Closed]],

Cell["\<\
The input form of the string displays the escape sequence used to \
enter the newline character.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(InputForm[%]\)], "Input"],

Cell["\"This is line one.\\nAnd this is line two.\"", "Output"]
}, Closed]],

Cell[TextData[{
  "To put a quotation mark into a string (instead of using it to denote the \
beginning or end of a string), we use the escape sequence ",
  StyleBox["\\\"", "Input"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \("\<We enter quotation marks using an \"escape sequence\".\>"\)], "Input",\

  TabSpacings->Automatic],

Cell[BoxData[
    \("We enter quotation marks using an \"escape sequence\"."\)], "Output"]
}, Closed]],

Cell["\<\
Again the input form reveals any escape sequences contained in a \
string.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(InputForm[%]\)], "Input"],

Cell["\"We enter quotation marks using an \\\"escape sequence\\\".\"", 
  "Output"]
}, Closed]],

Cell[TextData[{
  "Because the backslash character is used to mark the beginning of an escape \
sequence, to enter a literal backslash character into a string we must use \
the escape sequence ",
  StyleBox["\\\\", "Input"],
  ". This is important when using a file system such as Microsoft Windows \
that uses a backslash as a directory separator. A typical directory name on \
such a system looks like the following. The output form of the string \
displays a single backslash for each double backslash contained in the \
input."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \("\<C:\\data\>"\)], "Input"],

Cell[BoxData[
    \("C:\\data"\)], "Output"]
}, Closed]],

Cell["Here is the input form of the string.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(InputForm[%]\)], "Input"],

Cell["\"C:\\\\data\"", "Output"]
}, Closed]],

Cell[TextData[{
  "Many strings can be converted into valid ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " input. ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " does not evaluate the contents of the following string."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \("\<1 + 1\>"\)], "Input"],

Cell[BoxData[
    \("1 + 1"\)], "Output"]
}, Closed]],

Cell[TextData[{
  "The function ",
  StyleBox["ToExpression", "Input"],
  " converts a string into ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " input, then evaluates it, if possible."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ToExpression[%]\)], "Input"],

Cell[BoxData[
    \(2\)], "Output"]
}, Closed]],

Cell[TextData[{
  "We will see in a later chapter that it is occasionally useful to import \
numerical data into ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " as a list of strings, then convert the strings into numbers using ",
  StyleBox["ToExpression", "Input"],
  "."
}], "Text"]
}, Closed]],

Cell[CellGroupData[{

Cell["Numbers", "Subsubsection"],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " has different rules for working with exact and approximate quantities."
}], "Text"],

Cell[TextData[{
  "An approximate quantity can be identified by the presence of a decimal \
point; therefore 17.0 and 0.71 are approximate numbers. The integer 17 and \
the ratio 71/100, on the other hand, do not contain a decimal point and are \
considered exact numbers. In the following discussion, we refer to an \
approximate (non-complex) number containing a decimal point as a ",
  StyleBox["real",
    FontSlant->"Italic"],
  " number, an integer without a decimal point as an ",
  StyleBox["integer",
    FontSlant->"Italic"],
  ", and a ratio of two exact integers as a ",
  StyleBox["rational",
    FontSlant->"Italic"],
  " number. To ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " 7.0 is an approximate real number, and 7 is an exact integer."
}], "Text"],

Cell[TextData[{
  "When doing arithmetic with exact numbers, ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " returns an exact number. For example, the following input contains only \
exact integers and rational numbers, so the result is an exact number."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(2 + \((3\[Times]5\/12)\)\^7\)], "Input"],

Cell[BoxData[
    \(110893\/16384\)], "Output"]
}, Closed]],

Cell["This occurs even when there is a precise decimal equivalent.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(2\/3 + 7\/12\)], "Input"],

Cell[BoxData[
    \(5\/4\)], "Output"]
}, Closed]],

Cell["\<\
If a calculation involves even one approximate number (a number \
that contains a decimal point), however, the result will be an approximate \
number because the uncertainty associated with the approximate number \
propagates through the whole calculation.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(2\/3 + 7.0\/12\)], "Input"],

Cell[BoxData[
    \(1.25`\)], "Output"]
}, Closed]],

Cell[TextData[{
  StyleBox["I", "Input"],
  " denotes the imaginary unit ",
  Cell[BoxData[
      \(TraditionalForm\`\@\(-1\)\)]],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Sqrt[\(-256\)]\)], "Input"],

Cell[BoxData[
    \(16\ I\)], "Output"]
}, Closed]],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " knows the standard functions for describing and manipulating complex \
numbers. ",
  StyleBox["Re[", "Input"],
  StyleBox["z",
    FontSlant->"Italic"],
  StyleBox["]", "Input"],
  " returns the real part of ",
  Cell[BoxData[
      \(TraditionalForm\`z\)]],
  ", ",
  StyleBox["Im[", "Input"],
  StyleBox["z",
    FontSlant->"Italic"],
  StyleBox["]", "Input"],
  " returns the imaginary part, and so forth."
}], "Text"],

Cell[TextData[{
  "Here is a complex number called ",
  StyleBox["num", "Input"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(num = 1.23 + 4.56\ I\)], "Input"],

Cell[BoxData[
    RowBox[{
      StyleBox["1.22999999999999998`",
        StyleBoxAutoDelete->True,
        PrintPrecision->3], "+", 
      RowBox[{
        StyleBox["4.5599999999999996`",
          StyleBoxAutoDelete->True,
          PrintPrecision->3], " ", "I"}]}]], "Output"]
}, Closed]],

Cell[TextData[{
  "Here is a list of the real and imaginary parts of ",
  StyleBox["num", "Input"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \({Re[num], \ Im[num]}\)], "Input"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        StyleBox["1.22999999999999998`",
          StyleBoxAutoDelete->True,
          PrintPrecision->3], ",", 
        StyleBox["4.5599999999999996`",
          StyleBoxAutoDelete->True,
          PrintPrecision->3]}], "}"}]], "Output"]
}, Closed]],

Cell[TextData[{
  "Here are the absolute value and approximate argument (or phase), in \
radians, of ",
  StyleBox["num", "Input"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \({Abs[num], \ Arg[num]}\)], "Input"],

Cell[BoxData[
    \({4.72297575687193127`, 1.30732978575997904`}\)], "Output"]
}, Closed]],

Cell[TextData[{
  "To convert from an exact number to an approximate number, we use the \
function ",
  StyleBox["N", "Input"],
  ". ",
  StyleBox["N[", "Input"],
  StyleBox["expr",
    FontSlant->"Italic"],
  StyleBox["]", "Input"],
  " returns a numerical approximation to ",
  StyleBox["expr",
    FontSlant->"Italic"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(N[\@27 - \@13]\)], "Input"],

Cell[BoxData[
    \(1.59060114724264201`\)], "Output"]
}, Closed]],

Cell[TextData[{
  StyleBox["N[", "Input"],
  StyleBox["expr",
    FontSlant->"Italic"],
  StyleBox[",", "Input"],
  " ",
  StyleBox["n",
    FontSlant->"Italic"],
  StyleBox["]", "Input"],
  " does computations to at most ",
  StyleBox["n",
    FontSlant->"Italic"],
  " significant digits. Here is a 50-digit approximation to the difference \
between ",
  Cell[BoxData[
      \(TraditionalForm\`22\/7\)]],
  " and \[Pi]."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(N[22/7 - \[Pi], 50]\)], "Input"],

Cell[BoxData[
    \(0.0012644892673496186802137595776399729456877434820370361679125505`50
    \)], "Output"]
}, Closed]],

Cell["\<\
The presence of the decimal point in the following result indicates \
the change from exact integer to approximate real number.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(N[2]\)], "Input"],

Cell[BoxData[
    \(2.`\)], "Output"]
}, Closed]],

Cell[TextData[{
  "There are many functions that convert an approximate number into an exact \
integer. ",
  StyleBox["Round[", "Input"],
  StyleBox["x",
    FontSlant->"Italic"],
  StyleBox["]", "Input"],
  " returns the integer closest to ",
  StyleBox["x,",
    FontSlant->"Italic"],
  " ",
  StyleBox["Floor[", "Input"],
  StyleBox["x",
    FontSlant->"Italic"],
  StyleBox["]", "Input"],
  " returns the greatest integer less than ",
  StyleBox["x",
    FontSlant->"Italic"],
  ", and ",
  StyleBox["Ceiling[", "Input"],
  StyleBox["x",
    FontSlant->"Italic"],
  StyleBox["]", "Input"],
  " returns the least integer greater than ",
  StyleBox["x",
    FontSlant->"Italic"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell["{Round[3.3], Floor[3.3], Ceiling[3.3]}", "Input"],

Cell[BoxData[
    \({3, 3, 4}\)], "Output"]
}, Closed]],

Cell[TextData[{
  "The function ",
  StyleBox["Rationalize", "Input"],
  " converts numbers into exact rational numbers. ",
  StyleBox["Rationalize[", "Input"],
  StyleBox["x",
    FontSlant->"Italic"],
  StyleBox[",", "Input"],
  StyleBox["dx",
    FontSlant->"Italic"],
  StyleBox["]", "Input"],
  " returns a rational number equal to ",
  StyleBox["x",
    FontSlant->"Italic"],
  " within a tolerance of ",
  StyleBox["dx",
    FontSlant->"Italic"],
  "."
}], "Text"],

Cell[TextData[
"Here are some successively better rational approximations to \[Pi]."], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Table[Rationalize[\[Pi], 10\^\(-2\^n\)], {n, 1, 4}]\)], "Input"],

Cell[BoxData[
    \({22\/7, 355\/113, 104348\/33215, 245850922\/78256779}\)], "Output"]
}, Closed]],

Cell[TextData[{
  "We can find the type of a number using the function ",
  StyleBox["Head", "Input"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \({Head[2], \ Head[3.2], Head[3 + 4  I], Head[2/3]}\)], "Input"],

Cell[BoxData[
    \({Integer, Real, Complex, Rational}\)], "Output"]
}, Closed]],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " can work with numbers with any number of digits, and in the case of \
approximate numbers it maintains information about how many of the digits are \
significant. The number of significant digits in a number ",
  StyleBox["x",
    FontSlant->"Italic"],
  " is called the ",
  StyleBox["precision",
    FontSlant->"Italic"],
  " of ",
  StyleBox["x",
    FontSlant->"Italic"],
  ", and ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " knows the rules of numerical analysis for dealing with numbers with \
different amounts of precision."
}], "Text"],

Cell[TextData[{
  StyleBox["Precision[", "Input"],
  StyleBox["x",
    FontSlant->"Italic"],
  StyleBox["]", "Input"],
  " returns the number of significant digits in the number ",
  StyleBox["x",
    FontSlant->"Italic"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Precision[N[\[Pi], 40]]\)], "Input"],

Cell[BoxData[
    \(40\)], "Output"]
}, Closed]],

Cell[TextData[{
  StyleBox["Accuracy", "Input"],
  " returns the number of digits to the right of the decimal point. Precision \
is a measure of the relative error of a number, and accuracy is a measure of \
the absolute error."
}], "Text"],

Cell["The following number has 24 significant digits.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Precision[1234567890.123456789012345]\)], "Input"],

Cell[BoxData[
    \(24\)], "Output"]
}, Closed]],

Cell["It has 15 digits to the right of the decimal point.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Accuracy[1234567890.123456789012345]\)], "Input"],

Cell[BoxData[
    \(15\)], "Output"]
}, Closed]],

Cell[TextData[{
  StyleBox["Machine-precision numbers",
    FontSlant->"Italic"],
  " are numbers that can be calculated using a computer\[CloseCurlyQuote]s \
hardware: most computers can directly handle numbers with up to 16 \
significant digits. (The number of digits that the hardware can handle is \
stored in the parameter ",
  StyleBox["$MachinePrecision", "Input"],
  ".) For efficiency reasons, ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " does any calculation that contains even one machine-precision number to \
machine precision."
}], "Text"],

Cell["\<\
The number 2.3 in the following calculation is a machine-precision \
number (while the other number is not), so the answer is a machine-precision \
number.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(2.3 + 1.234567890123456789012345\)], "Input"],

Cell[BoxData[
    \(3.53456789012345673`\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Precision[%]\)], "Input"],

Cell[BoxData[
    \(16\)], "Output"]
}, Closed]],

Cell[TextData[{
  "By default, ",
  StyleBox["N", "Input"],
  " returns a machine-precision number."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(N[\@19]\)], "Input"],

Cell[BoxData[
    \(4.35889894354067397`\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell["Precision[%]", "Input"],

Cell[BoxData[
    \(16\)], "Output"]
}, Closed]],

Cell[TextData[{
  "If a number has more than 16 (or the value of ",
  StyleBox["$MachinePrecision", "Input"],
  ", if different) significant digits, it is called an ",
  StyleBox["arbitrary-precision",
    FontSlant->"Italic"],
  " number."
}], "Text"],

Cell[TextData[{
  "Here we ask for an approximation to ",
  Cell[BoxData[
      \(TraditionalForm\`\@19\)]],
  " with 50 significant digits."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(N[\@19, \ 50]\)], "Input"],

Cell[BoxData[
    \(4.3588989435406735522369819838596156591370039252324449368903441`50\)], 
  "Output"]
}, Closed]],

Cell["\<\
The precision of the result is 50, making the approximation an \
arbitrary-precision number.\
\>", "Text"],

Cell[CellGroupData[{

Cell["Precision[%]", "Input"],

Cell[BoxData[
    \(50\)], "Output"]
}, Closed]],

Cell[TextData[{
  "Using ",
  StyleBox["SetPrecision", "Input"],
  " we can artificially set the precision of a number to an arbitrary number \
of digits."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SetPrecision[\ N[\@19, 4], \ 5]\)], "Input"],

Cell[BoxData[
    \(4.358898943540674`5\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Precision[%]\)], "Input"],

Cell[BoxData[
    \(5\)], "Output"]
}, Closed]],

Cell[TextData[{
  "When using arbitrary-precision numbers, ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " does not generate more precision in an answer than is justified by the \
calculation. For example, adding two values with different numbers of \
significant digits returns a number as precise as the less precise value."
}], "Text"],

Cell[BoxData[
    \(x\_1 = 54.23232323232312312624874590149643; \n
    x\_2 = 34323.98129712872939137913; \)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Precision[x\_1]\)], "Input"],

Cell[BoxData[
    \(34\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Precision[x\_2]\)], "Input"],

Cell[BoxData[
    \(25\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Precision[x\_1 + x\_2]\)], "Input"],

Cell[BoxData[
    \(25\)], "Output"]
}, Closed]],

Cell[TextData[{
  "The precision of an exact number is ",
  StyleBox["Infinity", "Input"],
  "."
}], "Text"],

Cell["\<\
We can approximate an exact number to as many digits as \
desired.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(N[Sin[1], 250]\)], "Input"],

Cell[BoxData[
    \(0.8414709848078965066525023216302989996225630607983710656727517099919104\
043912396689486397435430526958543490379079206742932591189209918988811934103277\
292124094807919558267666069999077640119784087827325663474848028702986561570179\
62455394893572924670127086486281053`250\)], "Output"]
}, Closed]],

Cell["\<\
However, we cannot approximate the following machine-precision \
number to more than machine precision.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(N[Sin[1.0], 250]\)], "Input"],

Cell[BoxData[
    StyleBox["0.841470984807896549`",
      StyleBoxAutoDelete->True,
      PrintPrecision->16]], "Output"]
}, Closed]],

Cell[TextData[{
  "An additional way to enter a number with a known precision is in the form \
",
  StyleBox["nnnn",
    FontSlant->"Italic"],
  StyleBox["`", "Input"],
  StyleBox["p",
    FontSlant->"Italic"],
  ", where ",
  StyleBox["nnnn",
    FontSlant->"Italic"],
  " is the number and ",
  StyleBox["p",
    FontSlant->"Italic"],
  " is the number of digits of precision. For example, here is an \
approximation to \[Pi] with four digits of precision."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(3.1416`4\)], "Input"],

Cell[BoxData[
    \(3.1416`4\)], "Output"]
}, Closed]],

Cell[TextData[{
  "By default ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " prints only the correct digits, without the ",
  StyleBox["`", "Input"],
  StyleBox["p",
    FontSlant->"Italic"],
  ". To explicitly see all of the information ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " has for a number, we look at the number\[CloseCurlyQuote]s input form."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(InputForm[%]\)], "Input"],

Cell["3.1416`4", "Output"]
}, Closed]],

Cell[TextData[{
  "As with arbitrary-precision arithmetic, ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " keeps track of the number of significant digits in a result. Here we use \
several imprecise numbers in the calculation of the volume of a cylinder, and \
",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " returns an answer with the correct number of significant digits."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(3.1416`4*\(\((11.1111`5)\)\^2\) \((15.253545`6)\)\)], "Input"],

Cell[BoxData[
    \(5916.10384332976`3.9172\)], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "Where ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " Looks for Files"
}], "Subsubsection"],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " maintains a current working directory, which is the first directory in \
which ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " looks for files. We can find the current working directory by entering \
the command ",
  Cell["Directory[]", "Input"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Directory[]\)], "Input"],

Cell[BoxData[
    \("HardDisk:Mathematica 3.0 Files"\)], "Output"]
}, Closed]],

Cell[TextData[{
  "The current directory will appear somewhat different on different \
computers because the delimiters used to separate directories differ from \
system to system. This notebook was created on a Macintosh, which uses \
\[OpenCurlyDoubleQuote]",
  StyleBox[":", "Input"],
  "\[CloseCurlyDoubleQuote] to separate directories in a pathname. The \
delimiter is \[OpenCurlyDoubleQuote]",
  StyleBox["/", "Input"],
  "\[CloseCurlyDoubleQuote]  in Unix and \[OpenCurlyDoubleQuote]",
  StyleBox["\\", "Input"],
  "\[CloseCurlyDoubleQuote] in Microsoft Windows; the pathname separator for \
a particular computer can be found by looking at the value of the global \
parameter ",
  StyleBox["$PathnameSeparator", "Input"],
  "."
}], "Text"],

Cell[TextData[{
  "If we refer to a file is that not in the current working directory, ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " looks for the file in the directories listed in the variable ",
  StyleBox["$Path", "Input"],
  ". This list typically includes the ",
  StyleBox["Mathematica ",
    FontSlant->"Italic"],
  "application directory and the ",
  StyleBox["StandardPackages", "Output"],
  " subdirectory within it. Note that the value of ",
  StyleBox["$Path", "Input"],
  " may be different on different computers."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \($Path\)], "Input",
  Evaluatable->False],

Cell[BoxData[
    \({"HardDisk:System Folder:Preferences:Mathematica:3.0:Kernel", ":", 
      "HardDisk:Mathematica 3.0 Files:AddOns:StandardPackages", 
      "HardDisk:Mathematica 3.0 Files:AddOns:StandardPackages:StartUp", 
      "HardDisk:Mathematica 3.0 Files:AddOns:Applications", 
      "HardDisk:Mathematica 3.0 Files:AddOns:ExtraPackages", 
      "HardDisk:Mathematica 3.0 Files:SystemFiles:Graphics:Packages"}\)], 
  "Output",
  AutoItalicWords->{}]
}, Closed]],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " searches the directories listed in ",
  StyleBox["$Path", "Input"],
  " in the order they are listed."
}], "Text"],

Cell[TextData[{
  "The value of ",
  StyleBox["$Path", "Input"],
  " is a list. For this training course, we assume the data files are in a \
directory called ",
  StyleBox["data", "Output"],
  ", located at the top level of the file system. The following line of code \
adds this directory to the path on a Macintosh system."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(AppendTo[$Path, "\<HardDisk:data\>"]\)], "Input",
  Evaluatable->False],

Cell[BoxData[
    \({"HardDisk:System Folder:Preferences:Mathematica:3.0:Kernel", ":", 
      "HardDisk:Mathematica 3.0 Files:AddOns:StandardPackages", 
      "HardDisk:Mathematica 3.0 Files:AddOns:StandardPackages:StartUp", 
      "HardDisk:Mathematica 3.0 Files:AddOns:Applications", 
      "HardDisk:Mathematica 3.0 Files:AddOns:ExtraPackages", 
      "HardDisk:Mathematica 3.0 Files:SystemFiles:Graphics:Packages", 
      "HardDisk:data"}\)], "Output",
  AutoItalicWords->{}]
}, Closed]],

Cell[TextData[{
  "On a Unix system, we enter ",
  StyleBox["AppendTo[$Path,\"/data\"]", "Input"],
  "; and on a Microsoft Windows system, we enter ",
  StyleBox["AppendTo[$Path,\"c:\\\\data\"]", "Input"],
  ". (The double backslash is explained earlier in the section \
\[OpenCurlyDoubleQuote]Strings\[CloseCurlyDoubleQuote].)"
}], "Text"],

Cell[TextData[{
  "Because ",
  StyleBox["$Path", "Input"],
  " is a list, we treat it just like any other list in ",
  StyleBox["Mathematica,",
    FontSlant->"Italic"],
  " using list commands (such as ",
  StyleBox["AppendTo", "Input"],
  ") to change its contents."
}], "Text"],

Cell[TextData[{
  "Here we use ",
  StyleBox["SetDirectory", "Input"],
  " to set the current directory to be the directory in which our data files \
are stored."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SetDirectory[Last[$Path]]\)], "Input",
  Evaluatable->False],

Cell[BoxData[
    \("HardDisk:data"\)], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Referring to Directories and Files", "Subsubsection"],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " contains many commands that enable us to interact with the local file \
system. We can view the contents of directories and files, create new \
directories and files, read the contents of files into ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " data structures, and much more."
}], "Text"],

Cell[TextData[{
  StyleBox["FileNames[", "Input"],
  " ",
  StyleBox["]", "Input"],
  " lists all the files in the current working directory. Here is a list of \
every file in the current directory (",
  StyleBox["HardDisk:data", "Output"],
  ")."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(FileNames[]\)], "Input"],

Cell[BoxData[
    \({"array1.txt", "array2.txt", "array.txt", "circle.dat", "commas.dat", 
      "execute", "export", "eye.dat", "hurr.dat", "icondata.dat", 
      "lifedata.dat", "lowtemps.dat", "newfile", "periods.dat", 
      "planets.dat", "primes.dat", "rand5.dat", "rankbypop.dat", 
      "register.dat", "sample.dat", "tabs.dat", "weights.txt"}\)], "Output"]
}, Closed]],

Cell[TextData[{
  Cell[TextData[{
    "FileNames[\"",
    StyleBox["form", "Text",
      FontFamily->"Times",
      FontWeight->"Plain",
      FontSlant->"Italic"],
    "\"]"
  }], "Input"],
  " lists all files in the current working directory whose names match the \
string pattern ",
  StyleBox["form",
    FontSlant->"Italic"],
  ". Here we use the string pattern \[OpenCurlyDoubleQuote]",
  StyleBox["*m*", "Input"],
  "\[CloseCurlyDoubleQuote] to find all file names in the current directory \
that contain the letter ",
  StyleBox["m",
    FontSlant->"Italic"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(FileNames["\<*m*\>"]\)], "Input"],

Cell[BoxData[
    \({"commas.dat", "lowtemps.dat", "primes.dat", "sample.dat"}\)], "Output"]
}, Closed]],

Cell[TextData[{
  "Here we set the current directory to the ",
  StyleBox["NumericalMath", "Output"],
  " add-on package directory. (When using a notebook interface to ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ", we can pull down the Input menu and choose ",
  StyleBox["Get File Path", "MenuItem"],
  ", which presents a standard file dialog box. Using the dialog box, we can \
navigate directories until we find a file in the desired directory. ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " pastes the complete pathname to the file at the current text insertion \
point. To change the file pathname to a directory name, we simply delete the \
file name from the complete pathname.)"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SetDirectory[
      "\<HardDisk:Mathematica 3.0 Files:AddOns:StandardPackages:NumericalMath\
\>"]\)], "Input",
  Evaluatable->False,
  AutoItalicWords->{}],

Cell[BoxData[
    \("HardDisk:Mathematica 3.0 \
Files:AddOns:StandardPackages:NumericalMath"\)], "Output",
  AutoItalicWords->{}]
}, Closed]],

Cell[TextData[{
  "Here is a list of all the filenames in the ",
  StyleBox["NumericalMath", "Output"],
  " directory."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(FileNames[]\)], "Input"],

Cell[BoxData[
    \({"Approximations.m", "BesselZeros.m", "Butcher.m", 
      "CauchyPrincipalValue.m", "ComputerArithmetic.m", 
      "GaussianQuadrature.m", "Horner.m", "InterpolateRoot.m", 
      "IntervalRoots.m", "Kernel", "ListIntegrate.m", "Master.m", 
      "Microscope.m", "NewtonCotes.m", "NIntegrateInterpolatingFunct.m", 
      "NLimit.m", "NResidue.m", "NSeries.m", "OrderStar.m", 
      "PolynomialFit.m", "SplineFit.m", "TrigFit.m"}\)], "Output"]
}, Closed]],

Cell[TextData[{
  StyleBox["FindList[\"", "Input"],
  StyleBox["file",
    FontSlant->"Italic"],
  StyleBox["\",", "Input"],
  " ",
  StyleBox["\"", "Input"],
  StyleBox["string",
    FontSlant->"Italic"],
  StyleBox["\"]", "Input"],
  " gives a list of all records in ",
  StyleBox["file",
    FontSlant->"Italic"],
  " that contain ",
  StyleBox["string",
    FontSlant->"Italic"],
  ". Here we find every line in the file ",
  StyleBox["TrigFit.m", "Output"],
  " that contains the word \[OpenCurlyDoubleQuote]Author\
\[CloseCurlyDoubleQuote]."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(FindList["\<TrigFit.m\>", "\<Author\>"]\)], "Input"],

Cell[BoxData[
    \({"(* :Author: Jerry B. Keiper *)"}\)], "Output"]
}, Closed]],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " keeps a list of current directories. ",
  StyleBox["ResetDirectory", "Input"],
  " steps backward through this list."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ResetDirectory[]\)], "Input",
  Evaluatable->False],

Cell[BoxData[
    \("HardDisk:data"\)], "Output"]
}, Closed]],

Cell[TextData[{
  "See also ",
  StyleBox["CopyFile", "Input"],
  ", ",
  StyleBox["RenameFile", "Input"],
  ", ",
  StyleBox["DeleteFile", "Input"],
  ", ",
  StyleBox["FileByteCount", "Input"],
  ", ",
  StyleBox["FileDate", "Input"],
  ", ",
  StyleBox["FileType", "Input"],
  " "
}], "SeeAlso"]
}, Closed]],

Cell[CellGroupData[{

Cell["Exercises: Preliminaries", "Subsubsection",
  PageBreakAbove->True],

Cell[TextData[{
  "Make sure that the data file directory is on the file search path ",
  StyleBox["$Path", "Input"],
  ". (The directory is called ",
  StyleBox["data", "Output"],
  ", located on the root level of the file system.)"
}], "Question"],

Cell[TextData[{
  "If the data directory is not listed in ",
  StyleBox["$Path", "Input"],
  ", we append it to the list by using ",
  StyleBox["AppendTo", "Input"],
  "."
}], "Text"],

Cell[BoxData[
    \(AppendTo[$Path, "\<HardDisk:data\>"]\)], "Input",
  Evaluatable->False],

Cell["The data directory is now at the end of the search path.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \($Path\)], "Input"],

Cell[BoxData[
    \({"HardDisk:System Folder:Preferences:Mathematica:3.0:Kernel", ":", 
      "HardDisk:Mathematica 3.0 Files:AddOns:StandardPackages", 
      "HardDisk:Mathematica 3.0 Files:AddOns:StandardPackages:StartUp", 
      "HardDisk:Mathematica 3.0 Files:AddOns:Applications", 
      "HardDisk:Mathematica 3.0 Files:AddOns:ExtraPackages", 
      "HardDisk:Mathematica 3.0 Files:SystemFiles:Graphics:Packages", 
      "HardDisk:data"}\)], "Output",
  AutoItalicWords->{"MathLink", "MathSource", "MathReader"}]
}, Closed]],

Cell["Set the current directory to the data directory.", "Question"],

Cell[TextData[{
  "Here we set the directory using ",
  StyleBox["SetDirectory", "Input"],
  " and the full pathname to the data directory."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SetDirectory["\<HardDisk:data\>"]\)], "Input",
  Evaluatable->False],

Cell[BoxData[
    \(HardDisk : data\)], "Output"]
}, Closed]],

Cell[TextData[{
  "Alternatively, if the data directory is the last directory listed in ",
  StyleBox["$Path", "Input"],
  ", we can enter the following."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SetDirectory[Last[$Path]]\)], "Input",
  Evaluatable->False],

Cell[BoxData[
    \(HardDisk : data\)], "Output"]
}, Closed]],

Cell["List all the files in the data directory.", "Question"],

Cell[TextData[{
  StyleBox["FileNames[]", "Input"],
  " returns a list of all the files in the current directory."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(FileNames[]\)], "Input"],

Cell[BoxData[
    \({"array1.txt", "array2.txt", "array.txt", "circle.dat", "commas.dat", 
      "execute", "export", "eye.dat", "hurr.dat", "icondata.dat", 
      "lifedata.dat", "lowtemps.dat", "newfile", "periods.dat", 
      "planets.dat", "primes.dat", "rand5.dat", "rankbypop.dat", 
      "register.dat", "sample.dat", "tabs.dat", "weights.txt"}\)], "Output"]
}, Closed]],

Cell[" ", "EndExercises"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Importing Data", "Subsection",
  CellTags->"Importing Data"],

Cell[CellGroupData[{

Cell["Viewing Files", "Subsubsection"],

Cell[TextData[{
  "The command ",
  StyleBox["!!", "Input"],
  StyleBox["file",
    FontSlant->"Italic"],
  " prints the contents of a file into the current notebook. Here are the \
contents of the file called ",
  StyleBox["sample.dat", "Output"],
  " inside the ",
  StyleBox["data", "Output"],
  " directory."
}], "Text"],

Cell[CellGroupData[{

Cell["!!sample.dat", "Input"],

Cell["\<\
100
50
25
12.5\
\>", "Print"]
}, Closed]],

Cell[TextData[{
  "To access a file without adding its path to ",
  StyleBox["$Path", "Input"],
  ", we use the full pathname. Here is the full pathname for the file ",
  StyleBox["sample.dat", "Output"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell["!!HardDisk:data:sample.dat", "Input"],

Cell["\<\
100
50
25
12.5\
\>", "Print"]
}, Closed]],

Cell[TextData[{
  "Recall that pathname directory separators are different for different \
filesystems. We enter the equivalent pathname on a Microsoft Windows system \
as \[OpenCurlyDoubleQuote]",
  StyleBox["C:\\\\data\\\\sample.dat", "Input"],
  "\[CloseCurlyDoubleQuote], and on a Unix system as \[OpenCurlyDoubleQuote]",
  
  StyleBox["/data/sample.dat", "Input"],
  "\[CloseCurlyDoubleQuote]."
}], "Text"],

Cell[TextData[{
  "See also ",
  StyleBox["NotebookOpen", "Input"],
  " "
}], "SeeAlso"]
}, Closed]],

Cell[CellGroupData[{

Cell["Reading Lists of Data", "Subsubsection"],

Cell[TextData[{
  "The basic command used to import data from a file is ",
  StyleBox["ReadList", "Input"],
  ". By giving suitable values to the options that ",
  StyleBox["ReadList", "Input"],
  " accepts, we can read data stored in almost any format."
}], "Text"],

Cell[TextData[{
  StyleBox["ReadList[\"", "Input"],
  StyleBox["file",
    FontSlant->"Italic"],
  StyleBox["\"]", "Input"],
  " returns a list of all the expressions in ",
  StyleBox["file",
    FontSlant->"Italic"],
  ". Here we use ",
  StyleBox["ReadList", "Input"],
  " to read the contents of the file ",
  StyleBox["sample.dat", "Output"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ReadList["\<sample.dat\>"]\)], "Input"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{"100", ",", "50", ",", "25", ",", 
        StyleBox["12.5`",
          StyleBoxAutoDelete->True,
          PrintPrecision->3]}], "}"}]], "Output"]
}, Closed]],

Cell[TextData[{
  "We tell ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " what type of data to import by specifying a second argument to ",
  StyleBox["ReadList", "Input",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  ". ",
  StyleBox["ReadList[\"", "Input"],
  StyleBox["file",
    FontSlant->"Italic"],
  StyleBox["\",", "Input"],
  " ",
  StyleBox["type",
    FontSlant->"Italic"],
  StyleBox["]", "Input"],
  " reads objects of the specified ",
  StyleBox["type",
    FontSlant->"Italic"],
  " from ",
  StyleBox["file",
    FontSlant->"Italic"],
  ", until the end of ",
  StyleBox["file",
    FontSlant->"Italic"],
  " is reached. ",
  StyleBox["ReadList[\"", "Input"],
  StyleBox["file",
    FontSlant->"Italic"],
  StyleBox["\",{", "Input"],
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox[
            StyleBox["type",
              FontSlant->"Italic"], "1"], 
          StyleBox[",",
            "Input"], 
          SubscriptBox[
            StyleBox["type",
              FontSlant->"Italic"], "2"], 
          StyleBox[",",
            "Input"], "\[Ellipsis]"}], TraditionalForm]]],
  StyleBox["}]", "Input"],
  " reads objects of the given sequence of types, until the end of ",
  StyleBox["file",
    FontSlant->"Italic"],
  " is reached."
}], "Text"],

Cell[TextData[{
  StyleBox["Number", "Input",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  ", ",
  StyleBox["Word", "Input",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  ", and ",
  StyleBox["String", "Input",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " are the most common types of data to read; other types include ",
  StyleBox["Byte", "Input"],
  ", ",
  StyleBox["Character", "Input",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  ", ",
  StyleBox["Real", "Input",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  ", ",
  StyleBox["Record", "Input",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  ", and ",
  StyleBox["Expression", "Input",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  ". The important thing to remember is that once the data are read into a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " list, we manipulate the list using the same functions as any other ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " data structure."
}], "Text"],

Cell[TextData[{
  "Here we read the contents of the file ",
  StyleBox["sample.dat", "Output"],
  " as a list of numbers."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(data = ReadList["\<sample.dat\>", Number]\)], "Input"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{"100", ",", "50", ",", "25", ",", 
        StyleBox["12.5`",
          StyleBoxAutoDelete->True,
          PrintPrecision->3]}], "}"}]], "Output"]
}, Closed]],

Cell["The first element of the list is an integer.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Head[First[data]]\)], "Input"],

Cell[BoxData[
    \(Integer\)], "Output"]
}, Closed]],

Cell["The last element is a real number.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Head[Last[data]]\)], "Input"],

Cell[BoxData[
    \(Real\)], "Output"]
}, Closed]],

Cell["Here we read the same file as a list of words.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(data = ReadList["\<sample.dat\>", Word]\)], "Input"],

Cell[BoxData[
    \({"100", "50", "25", "12.5"}\)], "Output"]
}, Closed]],

Cell["Each element of the new list is a string.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Head[First[data]]\)], "Input"],

Cell[BoxData[
    \(String\)], "Output"]
}, Closed]],

Cell["\<\
It is good practice to clear the value of a variable when it is no \
longer needed.\
\>", "Text"],

Cell[BoxData[
    \(Clear[data]\)], "Input"],

Cell[TextData[{
  "A third argument to ",
  StyleBox["ReadList",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " specifies how many objects to read. Here we read the first three elements \
of the file ",
  StyleBox["sample.dat", "Output"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ReadList["\<sample.dat\>", Number, 3]\)], "Input"],

Cell[BoxData[
    \({100, 50, 25}\)], "Output"]
}, Closed]],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " also reads data files in which expressions are separated by tab \
characters."
}], "Text"],

Cell[CellGroupData[{

Cell["!!tabs.dat", "Input"],

Cell["\<\
21.1\t46.6
71.4\t50.5\t34.8\t55.1
78.8\t123E-2\
\>", "Print"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(ReadList["\<tabs.dat\>", Number]\)], "Input"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        StyleBox["21.1000000000000031`",
          StyleBoxAutoDelete->True,
          PrintPrecision->3], ",", 
        StyleBox["46.6000000000000014`",
          StyleBoxAutoDelete->True,
          PrintPrecision->3], ",", 
        StyleBox["71.4000000000000056`",
          StyleBoxAutoDelete->True,
          PrintPrecision->3], ",", 
        StyleBox["50.4999999999999982`",
          StyleBoxAutoDelete->True,
          PrintPrecision->3], ",", 
        StyleBox["34.7999999999999953`",
          StyleBoxAutoDelete->True,
          PrintPrecision->3], ",", 
        StyleBox["55.0999999999999978`",
          StyleBoxAutoDelete->True,
          PrintPrecision->3], ",", 
        StyleBox["78.7999999999999989`",
          StyleBoxAutoDelete->True,
          PrintPrecision->3], ",", \(123\/100\)}], "}"}]], "Output"]
}, Closed]],

Cell[TextData[{
  StyleBox["ReadList", "Input"],
  " interprets numbers of the form 123E-2 as ",
  Cell[BoxData[
      \(TraditionalForm\`123\[Times]10\^\(-2\)\)]],
  ", using Fortran notation."
}], "Text"],

Cell[TextData[{
  "(Note that the form ",
  StyleBox["ReadList[\"", "Input"],
  StyleBox["file",
    FontSlant->"Italic"],
  StyleBox["\"]", "Input"],
  ", in which the type of data to be read is unspecified, treats each line in \
the file as a separate expression. Here we read the file ",
  StyleBox["tabs.dat", "Output"],
  " without specifying that the elements are numbers."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ReadList["\<tabs.dat\>"]\)], "Input"],

Cell[BoxData[
    \({983.260000000000111`, 6.91385763600000036`*^6, 26344.6747941564485`}
      \)], "Output"]
}, Closed]],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " reads in each line as a separate expression, and returns the product of \
the numbers on each line.)"
}], "Text"],

Cell[TextData[{
  "If a data file has a particular structure, it may be lost when using ",
  StyleBox["ReadList", "Input",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  ", since by default ",
  StyleBox["ReadList", "Input",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " returns a simple list of the data points. The file ",
  StyleBox["lowtemps.dat", "Output"],
  " contains two columns of data."
}], "Text"],

Cell[CellGroupData[{

Cell["!!lowtemps.dat", "Input"],

Cell["\<\
-33   760
-62   1100
-40   8180
-34   1250
-43   5532
-51   5920\
\>", "Print"]
}, Closed]],

Cell[TextData[{
  "When we read the data using ",
  StyleBox["ReadList", "Input"],
  ", the column format is lost."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ReadList["\<lowtemps.dat\>", Number]\)], "Input"],

Cell[BoxData[
    \({\(-33\), 760, \(-62\), 1100, \(-40\), 8180, \(-34\), 1250, \(-43\), 
      5532, \(-51\), 5920}\)], "Output"]
}, Closed]],

Cell[TextData[{
  "To preserve the structure, we alter the second argument to ",
  StyleBox["ReadList", "Input",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  ", in this case telling ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " to read in pairs of numbers."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ReadList["\<lowtemps.dat\>", {Number, Number}]\)], "Input"],

Cell[BoxData[
    \({{\(-33\), 760}, {\(-62\), 1100}, {\(-40\), 8180}, {\(-34\), 1250}, {
        \(-43\), 5532}, {\(-51\), 5920}}\)], "Output"]
}, Closed]],

Cell[TextData[{
  "Here are the options that ",
  StyleBox["ReadList", "Input"],
  " accepts."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Options[ReadList]\)], "Input"],

Cell[BoxData[
    \({NullRecords \[Rule] False, NullWords \[Rule] False, 
      RecordLists \[Rule] False, RecordSeparators \[Rule] "\n", 
      TokenWords \[Rule] {}, WordSeparators \[Rule] {" ", "\t"}}\)], "Output"]
}, Closed]],

Cell[TextData[{
  "We use ",
  StyleBox["InputForm", "Input"],
  " to reveal the input forms of the nonprinting characters in the option \
values. The valid record separator character is a newline character, whose \
input form is the escape sequence ",
  StyleBox["\\n", "Input"],
  ", and one of the valid word separators is a tab character, entered ",
  StyleBox["\\t", "Input"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(InputForm[%]\)], "Input"],

Cell["\<\
{NullRecords -> False, 
  NullWords -> False, 
  RecordLists -> False, 
  RecordSeparators -> \"\\n\", 
  TokenWords -> {}, 
  WordSeparators -> {\" \", \"\\t\"}}\
\>", "Output"]
}, Closed]],

Cell[TextData[{
  "Alternatively, ",
  StyleBox["ReadList", "Input"],
  " can be configured to create a sublist for each record. By default, ",
  StyleBox["ReadList", "Input"],
  " considers a record to end with each newline character, and a word to end \
with each space. By setting the option ",
  StyleBox["RecordLists", "Input"],
  " to ",
  StyleBox["True", "Input"],
  ", we tell ",
  StyleBox["ReadList", "Input"],
  " to create a new sublist each time a new record is encountered."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ReadList["\<lowtemps.dat\>", Number, RecordLists \[Rule] True]\)], 
  "Input"],

Cell[BoxData[
    \({{\(-33\), 760}, {\(-62\), 1100}, {\(-40\), 8180}, {\(-34\), 1250}, {
        \(-43\), 5532}, {\(-51\), 5920}}\)], "Output"]
}, Closed]],

Cell[TextData[{
  "Irregular arrays can also be read into ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " using ",
  StyleBox["ReadList", "Input"],
  ", setting the option ",
  StyleBox["RecordLists", "Input"],
  " to ",
  StyleBox["True", "Input"],
  ". Again ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " collects data elements on the same line in a file into the same list."
}], "Text"],

Cell[CellGroupData[{

Cell["!!primes.dat", "Input"],

Cell["\<\
2 3 5 7
11 13 17 19
23 29
31 37
41 43 47
53 59\
\>", "Print"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(ReadList["\<primes.dat\>", Number, RecordLists \[Rule] True] // 
      TableForm\)], "Input"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {"2", "3", "5", "7"},
          {"11", "13", "17", "19"},
          {"23", "29", \(""\), \(""\)},
          {"31", "37", \(""\), \(""\)},
          {"41", "43", "47", \(""\)},
          {"53", "59", \(""\), \(""\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      TableForm[
       {{2, 3, 5, 7}, {11, 13, 17, 19}, {23, 29}, {31, 37}, {41, 43, 47}, {53,
         59}}]]], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Comma-Separated Data", "Subsubsection"],

Cell[TextData[{
  "By default, ",
  StyleBox["ReadList", "Input"],
  " assumes that data are separated by spaces or tab characters, which is not \
always the case. In the file ",
  StyleBox["commas.dat", "Output"],
  ", entries on the same line are separated by commas."
}], "Text"],

Cell[CellGroupData[{

Cell["!!commas.dat", "Input"],

Cell["\<\
1800, 5308483, 864746, 6.1
1900, 75994575, 2969834, 25.6
1990, 248709873, 3536278, 70.3\
\>", "Print"]
}, Closed]],

Cell[TextData[{
  "There are many techniques to read this data set into ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ". To read it as one flat list, we use the option ",
  StyleBox["WordSeparators", "Input"],
  " to specify that words are separated by spaces or commas. ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " now treats commas in the data file as delimiters between words."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ReadList["\<commas.dat\>", Word, 
      WordSeparators \[Rule] {"\< \>", "\<,\>"}]\)], "Input"],

Cell[BoxData[
    \({"1800", "5308483", "864746", "6.1", "1900", "75994575", "2969834", 
      "25.6", "1990", "248709873", "3536278", "70.3"}\)], "Output"]
}, Closed]],

Cell[TextData[{
  "Now we can use ",
  StyleBox["Partition", "Input"],
  " to recapture the lost structure. Here we recover the original structure \
of the data by partitioning the previous list into sublists of length four."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Partition[%, 4] // TableForm\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {\("1800"\), \("5308483"\), \("864746"\), \("6.1"\)},
          {\("1900"\), \("75994575"\), \("2969834"\), \("25.6"\)},
          {\("1990"\), \("248709873"\), \("3536278"\), \("70.3"\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Closed]],

Cell[TextData[{
  "Alternatively, we can collect elements on the same line into the same \
sublist by setting the option ",
  StyleBox["RecordLists", "Input"],
  " to ",
  StyleBox["True", "Input"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(commadata = 
      ReadList["\<commas.dat\>", Word, 
          WordSeparators \[Rule] {"\< \>", "\<,\>"}, RecordLists \[Rule] True]
           // TableForm\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {\("1800"\), \("5308483"\), \("864746"\), \("6.1"\)},
          {\("1900"\), \("75994575"\), \("2969834"\), \("25.6"\)},
          {\("1990"\), \("248709873"\), \("3536278"\), \("70.3"\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Closed]],

Cell["\<\
Because we read in the data as words, the numbers contained in the \
data file are represented as strings.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(InputForm[First[commadata]]\)], "Input"],

Cell["{\"1800\", \"5308483\", \"864746\", \"6.1\"}", "Output"]
}, Closed]],

Cell[TextData[{
  "Here we use ",
  StyleBox["ToExpression", "Input"],
  " to convert the strings containing numeric data into numbers."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(commadata = ToExpression[commadata]\)], "Input"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{"{", 
          RowBox[{"1800", ",", "5308483", ",", "864746", ",", 
            StyleBox["6.09999999999999964`",
              StyleBoxAutoDelete->True,
              PrintPrecision->2]}], "}"}], ",", 
        RowBox[{"{", 
          RowBox[{"1900", ",", "75994575", ",", "2969834", ",", 
            StyleBox["25.6000000000000005`",
              StyleBoxAutoDelete->True,
              PrintPrecision->3]}], "}"}], ",", 
        RowBox[{"{", 
          RowBox[{"1990", ",", "248709873", ",", "3536278", ",", 
            StyleBox["70.2999999999999936`",
              StyleBoxAutoDelete->True,
              PrintPrecision->3]}], "}"}]}], "}"}]], "Output"]
}, Closed]],

Cell["The numbers in the data file are now represented as numbers.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(InputForm[First[commadata]]\)], "Input"],

Cell["{1800, 5308483, 864746, 6.1}", "Output"]
}, Closed]],

Cell[TextData[{
  "Here we clear the value of ",
  StyleBox["commadata", "Input"],
  "."
}], "Text"],

Cell[BoxData[
    RowBox[{"Clear", "[", 
      StyleBox["commadata",
        "Input\.05"], 
      StyleBox["]",
        "Input\.05"]}]], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Files Containing Numerical and Textual Data", "Subsubsection"],

Cell["\<\
Many data files contain both numerical and textual data. The \
following file contains a list of geological periods and their respective \
durations.\
\>", "Text"],

Cell[CellGroupData[{

Cell["!!periods.dat", "Input"],

Cell["\<\
Cambrian 70
Ordovician 85
Silurian 40
Devonian 50
Carboniferous 85
Permian 25
Triassic 35
Jurassic 35
Cretaceous 65
Tertiary 60
Pleistocene 1
Holocene 0.01\
\>", "Print"]
}, Closed]],

Cell[TextData[{
  "The file contains a list of records, each containing a word and a number. \
We must supply ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " with this information in order to read in the data correctly. In this \
case, we simply tell ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " to read the data into the appropriate list structure."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ReadList["\<periods.dat\>", {Word, Number}]\)], "Input"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
      \({"Cambrian", 70}\), ",", \({"Ordovician", 85}\), ",", 
        \({"Silurian", 40}\), ",", \({"Devonian", 50}\), ",", 
        \({"Carboniferous", 85}\), ",", \({"Permian", 25}\), ",", 
        \({"Triassic", 35}\), ",", \({"Jurassic", 35}\), ",", 
        \({"Cretaceous", 65}\), ",", \({"Tertiary", 60}\), ",", 
        \({"Pleistocene", 1}\), ",", 
        RowBox[{"{", 
          RowBox[{\("Holocene"\), ",", 
            StyleBox["0.01`",
              StyleBoxAutoDelete->True,
              PrintPrecision->1]}], "}"}]}], "}"}]], "Output"]
}, Closed]],

Cell[TextData[{
  "Each pair of elements is now contained in a list containing a word and a \
number. We see that ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " internally stores data read in as words in the form of strings."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(InputForm[%]\)], "Input"],

Cell["\<\
{{\"Cambrian\", 70}, {\"Ordovician\", 85}, {\"Silurian\", 40}, 
  {\"Devonian\", 50}, {\"Carboniferous\", 85}, {\"Permian\", 25}, 
  {\"Triassic\", 35}, {\"Jurassic\", 35}, {\"Cretaceous\", 65}, 
  {\"Tertiary\", 60}, {\"Pleistocene\", 1}, {\"Holocene\", 0.01}}\
\>", 
  "Output"]
}, Closed]],

Cell["Here is a similar data file.", "Text"],

Cell[CellGroupData[{

Cell["!!rankbypop.dat", "Input"],

Cell["\<\
California    1
New York      2
Texas         3
Florida       4
Pennsylvania  5\
\>", "Print"]
}, Closed]],

Cell[TextData[{
  "Just as before, we want to read in the file as a list of records of the \
form ",
  StyleBox["{", "Input"],
  StyleBox["state",
    FontSlant->"Italic"],
  StyleBox[",", "Input"],
  " ",
  StyleBox["population-rank",
    FontSlant->"Italic"],
  StyleBox["}", "Input"],
  ". However, if we use the same command as for the previous data file, ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " prints an error message."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ReadList["\<rankbypop.dat\>", {Word, Number}]\)], "Input"],

Cell[BoxData[
    \(Read::"readn" \( : \ \) 
      "Syntax error reading a real number from \!\(\"rankbypop.dat\"\)."\)], 
  "Message"],

Cell[BoxData[
    \({{"California", 1}, {"New", $Failed}}\)], "Output"]
}, Closed]],

Cell[TextData[{
  "The problem is caused by the space between the words \
\[OpenCurlyDoubleQuote]New\[CloseCurlyDoubleQuote] and \
\[OpenCurlyDoubleQuote]York\[CloseCurlyDoubleQuote]. ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " reads the string \[OpenCurlyDoubleQuote]New York\[CloseCurlyDoubleQuote] \
as two data items, and prints a message that \[OpenCurlyDoubleQuote]York\
\[CloseCurlyDoubleQuote] cannot be interpreted as a number."
}], "Text"],

Cell[TextData[{
  "In this case, we can avoid this problem by specifying that words are \
separated by ",
  StyleBox["two",
    FontSlant->"Italic"],
  " spaces, using the option ",
  StyleBox["WordSeparators", "Input"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ReadList["\<rankbypop.dat\>", {Word, Number}, \n\t
      WordSeparators \[Rule] "\<  \>"\  (*two\ spaces*) ]\)], "Input"],

Cell[BoxData[
    \({{"California", 1}, {"New York", 2}, {"Texas", 3}, {"Florida", 4}, {
        "Pennsylvania", 5}}\)], "Output"]
}, Closed]],

Cell["\<\
In other cases, more sophisticated file-reading techniques may be \
required.\
\>", "Text"]
}, Closed]],

Cell[CellGroupData[{

Cell["Streams", "Subsubsection"],

Cell[TextData[{
  "Intstead of reading an entire file at once, we can open a channel to a \
file, called a ",
  StyleBox["stream",
    FontSlant->"Italic"],
  ". When we open a stream to a file, ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " holds open a connection to the file, and allows us more flexibility in \
reading from and writing to the file. ",
  StyleBox["OpenRead[\"", "Input"],
  StyleBox["file",
    FontSlant->"Italic"],
  StyleBox["\"]", "Input"],
  " opens a stream to read data from the file named ",
  StyleBox["file",
    FontSlant->"Italic"],
  ", and returns an ",
  StyleBox["InputStream", "Input"],
  " object. We name the stream in order to make it easier to refer to the \
stream."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(practicestream = OpenRead["\<sample.dat\>"]\)], "Input"],

Cell[BoxData[
    \(InputStream["sample.dat", 4]\)], "Output"]
}, Closed]],

Cell[TextData[{
  "(The number inside the ",
  StyleBox["InputStream", "Input"],
  " object is a unique index that ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " generates to distinguish streams.)"
}], "Text"],

Cell["\<\
Rather than reading the entire file into a list, here we read only \
one number from the file.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Read[practicestream, Number]\)], "Input"],

Cell[BoxData[
    \(100\)], "Output"]
}, Closed]],

Cell[TextData[{
  "Here we create a table of values read separately from the file. ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " returns the symbol ",
  StyleBox["EndOfFile", "Input"],
  " if we try to read past the end of a data file."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Table[Read[practicestream, Number], {4}]\)], "Input"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{"50", ",", "25", ",", 
        StyleBox["12.5`",
          StyleBoxAutoDelete->True,
          PrintPrecision->3], ",", "EndOfFile"}], "}"}]], "Output"]
}, Closed]],

Cell[TextData[{
  "Since ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " is holding the named file open, it is important to close the file when we \
are finished reading from it using ",
  StyleBox["Close", "Input"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Close[practicestream]\)], "Input"],

Cell[BoxData[
    \("sample.dat"\)], "Output"]
}, Closed]],

Cell[TextData[{
  "Streams allow a great degree of control when dealing with files. For \
example, we can move within the file without reading the entire file into ",
  StyleBox["Mathematica.",
    FontSlant->"Italic"],
  " ",
  StyleBox["Read[", "Input"],
  StyleBox["stream",
    FontSlant->"Italic"],
  StyleBox[",", "Input"],
  StyleBox[" type",
    FontSlant->"Italic"],
  StyleBox["]", "Input"],
  " reads one expression of the specified type from a stream, and ",
  StyleBox["Read[", "Input"],
  StyleBox["stream",
    FontSlant->"Italic"],
  StyleBox[",", "Input"],
  StyleBox[" ",
    FontSlant->"Italic"],
  StyleBox["{", "Input"],
  StyleBox["type1",
    FontSlant->"Italic"],
  StyleBox[",", "Input"],
  StyleBox[" type2",
    FontSlant->"Italic"],
  StyleBox[",", "Input"],
  " \[Ellipsis]",
  StyleBox["}]", "Input"],
  " reads a sequence of objects of the specified types. ",
  StyleBox["Skip[", "Input"],
  StyleBox["stream",
    FontSlant->"Italic"],
  StyleBox[",", "Input"],
  StyleBox[" type",
    FontSlant->"Italic"],
  StyleBox[",", "Input"],
  StyleBox[" n",
    FontSlant->"Italic"],
  StyleBox["]", "Input"],
  " skips ",
  StyleBox["n",
    FontSlant->"Italic"],
  " objects of the specified type."
}], "Text"],

Cell[TextData[{
  "When used with a stream, ",
  StyleBox["ReadList", "Input"],
  " reads in the remaining contents of a file, from the current position in \
the file to the end of the file."
}], "Text"],

Cell["\<\
Here is a file with some lines of header information before the \
data.\
\>", "Text"],

Cell[CellGroupData[{

Cell["!!planets.dat", "Input"],

Cell["\<\
                   Mean dist. from Sun
Planet             (in millions of km)
--------------------------------------
Mercury              57.9
Venus               108.2
Earth               149.6
Mars                227.9
Jupiter             778.3
Saturn             1427
Uranus             2870
Neptune            4497
Pluto              5900\
\>", "Print"]
}, Closed]],

Cell[TextData[{
  "We cannot use ",
  StyleBox["ReadList", "Input"],
  " alone to read this information in because the structure of the data is \
not uniform. What we need to do is skip the first three lines, and then apply \
",
  StyleBox["ReadList", "Input"],
  " to the remaining lines of the file. Here we open a stream to the file \
containing the planetary data."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(planetstr = OpenRead["\<planets.dat\>"]\)], "Input"],

Cell[BoxData[
    \(InputStream["planets.dat", 5]\)], "Output"]
}, Closed]],

Cell[TextData[{
  "Then we use the ",
  StyleBox["Skip", "Input"],
  " command to skip past three objects of type ",
  StyleBox["String", "Input"],
  ". In a file or stream, an object of type ",
  StyleBox["String", "Input"],
  " is an entire line of text."
}], "Text"],

Cell[BoxData[
    \(Skip[planetstr, String, 3]\)], "Input"],

Cell[TextData[{
  StyleBox["StreamPosition", "Input"],
  " returns the current position in a stream, typically the number of bytes \
from the beginning of the stream. (We can move the current position using ",
  StyleBox["SetStreamPosition", "Input"],
  ". To move the current position to the beginning of a stream, for example, \
we type ",
  Cell[TextData[{
    "SetStreamPosition[",
    StyleBox["stream",
      FontFamily->"Times",
      FontWeight->"Plain",
      FontSlant->"Italic"],
    ",0]"
  }], "Input"],
  ".)"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(StreamPosition[planetstr]\)], "Input"],

Cell[BoxData[
    \(117\)], "Output"]
}, Closed]],

Cell[TextData[{
  "Once we have skipped the first three lines, the data follow a structured \
pattern which can be handled by ",
  StyleBox["ReadList", "Input"],
  ". When we apply ",
  StyleBox["ReadList", "Input"],
  " to an open stream, ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " reads only the contents of the file after the current position in the \
stream."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ReadList[planetstr, {Word, Number}]\)], "Input"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{"{", 
          RowBox[{\("Mercury"\), ",", 
            StyleBox["57.9000000000000003`",
              StyleBoxAutoDelete->True,
              PrintPrecision->3]}], "}"}], ",", 
        RowBox[{"{", 
          RowBox[{\("Venus"\), ",", 
            StyleBox["108.200000000000006`",
              StyleBoxAutoDelete->True,
              PrintPrecision->4]}], "}"}], ",", 
        RowBox[{"{", 
          RowBox[{\("Earth"\), ",", 
            StyleBox["149.599999999999999`",
              StyleBoxAutoDelete->True,
              PrintPrecision->4]}], "}"}], ",", 
        RowBox[{"{", 
          RowBox[{\("Mars"\), ",", 
            StyleBox["227.899999999999991`",
              StyleBoxAutoDelete->True,
              PrintPrecision->4]}], "}"}], ",", 
        RowBox[{"{", 
          RowBox[{\("Jupiter"\), ",", 
            StyleBox["778.299999999999947`",
              StyleBoxAutoDelete->True,
              PrintPrecision->4]}], "}"}], ",", \({"Saturn", 1427}\), ",", 
        \({"Uranus", 2870}\), ",", \({"Neptune", 4497}\), ",", 
        \({"Pluto", 5900}\)}], "}"}]], "Output"]
}, Closed]],

Cell["\<\
Note that the file remains open until we close the stream, \
preventing other applications from accessing it.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Close[planetstr]\)], "Input"],

Cell[BoxData[
    \("planets.dat"\)], "Output"]
}, Closed]],

Cell[TextData[{
  "See also ",
  StyleBox["Streams", "Input"],
  ", ",
  StyleBox["StreamPosition", "Input"],
  ", ",
  StyleBox["SetStreamPosition", "Input"],
  ", ",
  StyleBox["StringToStream", "Input"],
  ", ",
  StyleBox["$Input", "Input"],
  ", ",
  StyleBox["Utilities`BinaryFiles`", "Input"],
  ", ",
  StyleBox["Miscellaneous`Audio`", "Input"],
  " "
}], "SeeAlso"]
}, Closed]],

Cell[CellGroupData[{

Cell["Exercises: Importing Data", "Subsubsection",
  PageBreakAbove->True],

Cell[TextData[{
  "Read in the file ",
  StyleBox["primes.dat", "Input"],
  " first as a simple list of numbers, then as a list of pairs of numbers."
}], "Question"],

Cell["Here is the data as a simple list of numbers.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ReadList["\<primes.dat\>", Number]\)], "Input"],

Cell[BoxData[
    \({2, 3, 5, 7, 11, 13, 17, 19, 23, 29, 31, 37, 41, 43, 47, 53, 59}\)], 
  "Output"]
}, Closed]],

Cell["Here we read in the data as a list of pairs of numbers.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ReadList["\<primes.dat\>", {Number, Number}]\)], "Input"],

Cell[BoxData[
    \({{2, 3}, {5, 7}, {11, 13}, {17, 19}, {23, 29}, {31, 37}, {41, 43}, {47, 
        53}, {59, EndOfFile}}\)], "Output"]
}, Closed]],

Cell[TextData[{
  "Notice that there is an odd number of data points in the file, so the last \
list of pairs contains the symbol ",
  StyleBox["EndOfFile", "Input"],
  ", which indicates that the end of the file was reached, so a second number \
in the pair could not be read."
}], "Text"],

Cell[" ", "EndExercises"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Exporting Data", "Subsection",
  CellTags->"Exporting Data"],

Cell[CellGroupData[{

Cell["Writing to Files", "Subsubsection"],

Cell[TextData[{
  "When writing data to files using the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " programming language, we use similar structures to those used for reading \
data from files."
}], "Text"],

Cell[TextData[{
  StyleBox["Put", "Input"],
  " and ",
  StyleBox["PutAppend", "Input"],
  " write expressions or sequences of expressions to a file."
}], "Text"],

Cell[BoxData[
    \(Put[Table[Random[], {5}], "\<rand5.dat\>"]\)], "Input"],

Cell[TextData[{
  "Here are the contents of the file ",
  StyleBox["rand5.dat", "Output"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(!! rand5.dat\)\)], "Input"],

Cell["\<\
{0.8223517732653981, 0.9694477836004878, 0.102788585760415, 
  0.05283440551207505, 0.6428556068199554}\
\>", "Print"]
}, Closed]],

Cell[TextData[{
  "The following is an abbreviation for ",
  StyleBox["Put", "Input"],
  "."
}], "Text"],

Cell[BoxData[
    \(Table[Random[], {5}] >> rand5.dat\)], "Input"],

Cell[TextData[{
  "We can write data incrementally to an output stream, instead of writing an \
entire data structure to a file at once. ",
  StyleBox["Write[", "Input"],
  StyleBox["stream",
    FontSlant->"Italic"],
  StyleBox[",", "Input"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["expr",
            FontSlant->"Italic"], "1"], TraditionalForm]]],
  StyleBox[",", "Input"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["expr",
            FontSlant->"Italic"], "2"], TraditionalForm]]],
  StyleBox[",", "Input"],
  " \[Ellipsis]",
  StyleBox["]", "Input"],
  " writes the expressions ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["expr",
            FontSlant->"Italic"], "i"], TraditionalForm]]],
  " in sequence, followed by a newline character, to the specified stream; ",
  StyleBox["WriteString[", "Input"],
  StyleBox["stream",
    FontSlant->"Italic"],
  StyleBox[",", "Input"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["expr",
            FontSlant->"Italic"], "1"], TraditionalForm]]],
  StyleBox[",", "Input"],
  " ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["expr",
            FontSlant->"Italic"], "2"], TraditionalForm]]],
  StyleBox[",", "Input"],
  " \[Ellipsis]",
  StyleBox["]", "Input"],
  " converts the ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["expr",
            FontSlant->"Italic"], "i"], TraditionalForm]]],
  " into strings, but does not append the newline character."
}], "Text"],

Cell[TextData[{
  StyleBox["OpenWrite[\"", "Input"],
  StyleBox["file",
    FontSlant->"Italic"],
  StyleBox["\"]", "Input"],
  " creates and opens a file for writing, returning an ",
  StyleBox["OutputStream", "Input"],
  " object. This will destroy any data in an existing file. To append data to \
the end of an existing file, we use ",
  StyleBox["OpenAppend[\"", "Input"],
  StyleBox["file",
    FontSlant->"Italic"],
  StyleBox["\"]", "Input"],
  "."
}], "Text"],

Cell[TextData[{
  "Here we use ",
  StyleBox["OpenWrite", "Input"],
  " to create a file called ",
  StyleBox["newfile", "Output"],
  ". (",
  StyleBox["OpenWrite", "Input"],
  " deletes the contents of an existing file.)"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(newstream = OpenWrite["\<newfile\>"]\)], "Input"],

Cell[BoxData[
    \(OutputStream["newfile", 10]\)], "Output"]
}, Closed]],

Cell["Here we write a list to the stream.", "Text"],

Cell[BoxData[
    \(Write[newstream, {{2, 1, 2}, {1, 2, 1}}]\)], "Input"],

Cell["Here we close the stream.", "Text"],

Cell[BoxData[
    \(\(Close[newstream]; \)\)], "Input"],

Cell[TextData[{
  "Here are the current contents of ",
  StyleBox["newfile", "Output"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(!! newfile\)\)], "Input"],

Cell["{{2, 1, 2}, {1, 2, 1}}", "Print"]
}, Closed]],

Cell[TextData[{
  "To append to the contents of a file, we use ",
  StyleBox["OpenAppend", "Input"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(addtofile = OpenAppend["\<newfile\>"]\)], "Input"],

Cell[BoxData[
    \(OutputStream["newfile", 11]\)], "Output"]
}, Closed]],

Cell[TextData[{
  "Here we write another expression to ",
  StyleBox["newfile", "Output"],
  "."
}], "Text"],

Cell[BoxData[
    \(Write[addtofile, a\ x^2 + b\ x + c == 0]\)], "Input"],

Cell["Here we write some text to the file.", "Text"],

Cell["\<\
WriteString[addtofile, 
\t\"\\n\\nThe preceding lines were written\\n\", 
\t\"using Write, but these were added\\n\",
\t\"with WriteString.\"]\
\>", "Input"],

Cell[TextData[{
  "When finished writing to ",
  StyleBox["newfile", "Output"],
  ", we close the stream."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Close[addtofile]\)], "Input"],

Cell[BoxData[
    \("newfile"\)], "Output"]
}, Closed]],

Cell[TextData[{
  "These are now the contents of ",
  StyleBox["newfile", "Output"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell["!!newfile", "Input"],

Cell["\<\
{{2, 1, 2}, {1, 2, 1}}
c + b*x + a*x^2 == 0


The preceding lines were written
using Write, but these were added
with WriteString.\
\>", "Print"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Writing Arrays to Files", "Subsubsection"],

Cell[TextData[{
  "Passing an array structure though ",
  StyleBox["Write", "Input",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " or ",
  StyleBox["WriteString", "Input",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " produces formatted output, including the curly brackets that ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " uses to denote lists, as the following example demonstrates. Here is a \
data set."
}], "Text"],

Cell[BoxData[
    \(\(somedata
       = {{3.50, 77, 83, 90, 98}, {3.75, 82, 89, 97}, {4.00, 88, 95}, {4.25, 
          93, 100}, {4.50, 99}}; \)\)], "Input"],

Cell["Here we write the data set directly to a file.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(arraytest = OpenWrite["\<array.txt\>"]\)], "Input"],

Cell[BoxData[
    \(OutputStream["array.txt", 15]\)], "Output"]
}, Closed]],

Cell[BoxData[
    \(Write[arraytest, somedata]\)], "Input"],

Cell[BoxData[
    \(\(Close[arraytest]; \)\)], "Input"],

Cell[TextData[{
  "The contents of the file follow ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " syntax conventions."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(!! array.txt\)\)], "Input"],

Cell["\<\
{{3.5, 77, 83, 90, 98}, {3.75, 82, 89, 97}, {4., 88, 95}, {4.25, \
93, 100}, 
  {4.5, 99}}\
\>", "Print"]
}, Closed]],

Cell[TextData[{
  "To write a formatted array, one possibility is to format the array using ",
  
  StyleBox["TableForm", "Input"],
  ", then write the formatted array to a file."
}], "Text"],

Cell[BoxData[
    \(WriteString["\<array1.txt\>", 
      OutputForm[TableForm[somedata, TableSpacing \[Rule] {0, 3}]]]\)], 
  "Input"],

Cell["Here are the contents of our file.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(!! array1.txt\)\)], "Input"],

Cell["\<\
3.5    77   83    90   98
3.75   82   89    97
4.     88   95
4.25   93   100
4.5    99\
\>", "Print"]
}, Closed]],

Cell[TextData[{
  "Here we read the data back into ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ReadList["\<array1.txt\>", Number, RecordLists -> True]\)], "Input"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{"{", 
          RowBox[{
            StyleBox["3.5`",
              StyleBoxAutoDelete->True,
              PrintPrecision->2], ",", "77", ",", "83", ",", "90", ",", 
            "98"}], "}"}], ",", 
        RowBox[{"{", 
          RowBox[{
            StyleBox["3.75`",
              StyleBoxAutoDelete->True,
              PrintPrecision->3], ",", "82", ",", "89", ",", "97"}], "}"}], 
        ",", 
        RowBox[{"{", 
          RowBox[{
            StyleBox["4.`",
              StyleBoxAutoDelete->True,
              PrintPrecision->1], ",", "88", ",", "95"}], "}"}], ",", 
        RowBox[{"{", 
          RowBox[{
            StyleBox["4.25`",
              StyleBoxAutoDelete->True,
              PrintPrecision->3], ",", "93", ",", "100"}], "}"}], ",", 
        RowBox[{"{", 
          RowBox[{
            StyleBox["4.5`",
              StyleBoxAutoDelete->True,
              PrintPrecision->2], ",", "99"}], "}"}]}], "}"}]], "Output"]
}, Closed]],

Cell[TextData[{
  "Similarly, we can use the following function definition. (We begin the \
name ",
  StyleBox["writeArray", "Input"],
  " with a lower case letter to distinguish it from built-in functions.) The \
nested ",
  StyleBox["Do", "Input",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " loops step through the array row by row, then column by column. Each \
element of a row is written followed by a space. Using ",
  StyleBox["WriteString", "Input",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " ensures that there are no newline characters inserted. Between rows ",
  StyleBox["Write", "Input",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " is used to insert a newline character."
}], "Text"],

Cell[BoxData[
    \(\(writeArray[streamname_, data_List] := \n\t
      Do[\n\t\tDo[\n\t\t\t
          WriteString[streamname, data[\([i, j]\)], "\< \>"], {j, 1, 
            Length[data[\([i]\)]]}]; 
        Write[streamname], {i, 1, Length[data]}]; \)\)], "Input"],

Cell[TextData[{
  "(An equivalent function can be written using pure functions and the ",
  StyleBox["Scan", "Input"],
  " command.)"
}], "Text"],

Cell["Here is a test of the function.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(arraytest2 = OpenWrite["\<array2.txt\>"]\)], "Input"],

Cell[BoxData[
    \(OutputStream["array2.txt", 94]\)], "Output"]
}, Closed]],

Cell[BoxData[
    \(writeArray[arraytest2, somedata]\)], "Input"],

Cell[BoxData[
    \(\(Close[arraytest2]; \)\)], "Input"],

Cell[TextData[{
  "Here are the contents of the file written by ",
  StyleBox["writeArray", "Input"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(!! array2.txt\)\)], "Input"],

Cell["\<\
3.5 77 83 90 98 
3.75 82 89 97 
4. 88 95 
4.25 93 100 
4.5 99 \
\>", "Print"]
}, Closed]],

Cell[TextData[{
  "See also ",
  StyleBox["NotebookSave", "Input"],
  ", ",
  StyleBox["NotebookWrite", "Input"],
  " "
}], "SeeAlso"]
}, Closed]],

Cell[CellGroupData[{

Cell["Exercises: Exporting Data", "Subsubsection",
  PageBreakAbove->True],

Cell["Create a new file and write a few lines of text to it.", "Question"],

Cell[TextData[{
  "Here we create a file called ",
  StyleBox["export", "Output"],
  ", and open it for writing. ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " returns an open stream to the file."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(myfile = OpenWrite["\<export\>"]\)], "Input"],

Cell[BoxData[
    \(OutputStream["export", 17]\)], "Output"]
}, Closed]],

Cell["Here we write some text to the file.", "Text"],

Cell[BoxData[
    \(WriteString[myfile, "\<Here are the first ten prime numbers:\n\>"]\)], 
  "Input"],

Cell[TextData[{
  "Note that ",
  StyleBox["WriteString", "Input"],
  " converts any expression into string form before writing it to a file. \
Here we write the first ten prime numbers, with a space after each number, to \
a file using a ",
  StyleBox["Do", "Input"],
  " loop."
}], "Text"],

Cell[BoxData[
    \(Do[WriteString[myfile, Prime[i], "\< \>"], {i, 1, 10}]\)], "Input"],

Cell["Here we add two newline characters to the end of the file.", "Text"],

Cell[BoxData[
    \(WriteString[myfile, "\<\n\n\>"]\)], "Input"],

Cell["When we are finished writing to the file, we close it.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Close[myfile]\)], "Input"],

Cell[BoxData[
    \("export"\)], "Output"]
}, Closed]],

Cell["Here are the contents of the file.", "Text"],

Cell[CellGroupData[{

Cell["!!export", "Input"],

Cell["\<\
Here are the first ten prime numbers:
2 3 5 7 11 13 17 19 23 29 
\
\>", "Print"]
}, Closed]],

Cell[TextData[{
  "Create a 10 \[Times] 10 array of random numbers of any type or size. Using \
the ",
  StyleBox["writeArray", "Input",
    FontFamily->"Courier"],
  " function defined in the text, append the array to the file ",
  StyleBox["export", "Output"],
  "."
}], "Question"],

Cell[TextData[
"Here is a 10 \[Times] 10 array of random integers between one and ten."], 
  "Text"],

Cell[BoxData[
    \(\(ran = Table[Random[Integer, {1, 10}], {10}, {10}]; \)\)], "Input"],

Cell[TextData[{
  "Here is the definition of ",
  StyleBox["writeArray", "Input"],
  " from the discussion."
}], "Text"],

Cell[BoxData[
    \(Clear[writeArray]; \n
    writeArray[streamname_, data_List] := 
      Do[Do[WriteString[streamname, data[\([i, j]\)], "\< \>"], {j, 1, 
            Length[data[\([i]\)]]}]; 
        Write[streamname], {i, 1, Length[data]}]; \)], "Input"],

Cell[TextData[{
  StyleBox["OpenAppend", "Input"],
  " open an output stream to a file."
}], "Text"],

Cell[BoxData[
    \(\(myfile = OpenAppend["\<export\>"]; \)\)], "Input"],

Cell["Here we write the random array to the stream.", "Text"],

Cell[BoxData[
    \(writeArray[myfile, ran]\)], "Input"],

Cell["Here we close the stream.", "Text"],

Cell[BoxData[
    \(\(Close[myfile]; \)\)], "Input"],

Cell["These are now the contents of the file.", "Text"],

Cell[CellGroupData[{

Cell["!!export", "Input"],

Cell["\<\
Here are the first ten prime numbers:
2 3 5 7 11 13 17 19 23 29 

8 7 5 2 10 1 5 2 7 6 
9 8 4 7 4 7 8 7 6 9 
7 10 3 7 7 7 3 5 1 3 
6 9 1 10 4 7 1 3 1 10 
10 8 6 1 9 4 5 10 2 3 
1 10 6 1 10 3 7 1 5 10 
2 6 8 7 2 1 5 3 5 4 
10 10 1 2 6 6 2 2 4 10 
9 8 5 8 8 8 8 1 4 4 
6 3 8 8 9 2 3 6 10 6 \
\>", "Print"]
}, Closed]],

Cell[BoxData[
    \(Clear[ran]\)], "Input"],

Cell[" ", "EndExercises"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Executing Files", "Subsection",
  CellTags->"Executing Files"],

Cell[TextData[{
  "If a file contains ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " commands, we often wish to execute the contents of the file. When we have \
valid ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " expressions in a file, ",
  StyleBox["Get[\"", "Input",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  StyleBox["file",
    FontSlant->"Italic"],
  StyleBox["\"]", "Input",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " reads in the file, evaluates each expression in it, and returns the \
result of the last expression. ",
  Cell[TextData["<<\[NoBreak]"], "Input"],
  "\[NoBreak]",
  StyleBox["file",
    FontSlant->"Italic"],
  " is an abbreviation for ",
  StyleBox["Get[\"", "Input",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  StyleBox["file",
    FontSlant->"Italic"],
  StyleBox["\"]", "Input",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  ". ",
  StyleBox["Needs[\"", "Input",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  StyleBox["context",
    FontSlant->"Italic"],
  StyleBox["`\"]", "Input",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " is used to read in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " packages, and loads a package only if the context defined in the package \
does not already exist."
}], "Text"],

Cell[TextData[{
  "An example is the file ",
  StyleBox["execute", "Output",
    FontFamily->"Courier"],
  ", which contains a matrix definition. Here are the contents of ",
  StyleBox["execute", "Output"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell["!!execute", "Input"],

Cell["\<\
newdata = \
{{1.000,1.2928,0.08071},{0.92,1.1620,0.07254},{0.597,0.7706,0.04811}}\
\>", 
  "Print"]
}, Closed]],

Cell[TextData[{
  StyleBox["Get", "Input"],
  " evaluates the contents of ",
  StyleBox["execute", "Output"],
  ", and returns the result of the evaluation."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Get["\<execute\>"]\)], "Input"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{"{", 
          RowBox[{
            StyleBox["1.`",
              StyleBoxAutoDelete->True,
              PrintPrecision->4], ",", 
            StyleBox["1.29279999999999994`",
              StyleBoxAutoDelete->True,
              PrintPrecision->5], ",", 
            StyleBox["0.0807099999999999972`",
              StyleBoxAutoDelete->True,
              PrintPrecision->4]}], "}"}], ",", 
        RowBox[{"{", 
          RowBox[{
            StyleBox["0.920000000000000106`",
              StyleBoxAutoDelete->True,
              PrintPrecision->2], ",", 
            StyleBox["1.16199999999999992`",
              StyleBoxAutoDelete->True,
              PrintPrecision->5], ",", 
            StyleBox["0.0725399999999999955`",
              StyleBoxAutoDelete->True,
              PrintPrecision->4]}], "}"}], ",", 
        RowBox[{"{", 
          RowBox[{
            StyleBox["0.596999999999999975`",
              StyleBoxAutoDelete->True,
              PrintPrecision->3], ",", 
            StyleBox["0.770599999999999951`",
              StyleBoxAutoDelete->True,
              PrintPrecision->4], ",", 
            StyleBox["0.0481099999999999994`",
              StyleBoxAutoDelete->True,
              PrintPrecision->4]}], "}"}]}], "}"}]], "Output"]
}, Closed]],

Cell[TextData[{
  "Here we see the value of ",
  StyleBox["newdata", "Input"],
  " has been assigned."
}], "Text"],

Cell[CellGroupData[{

Cell["newdata", "Input"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{"{", 
          RowBox[{
            StyleBox["1.`",
              StyleBoxAutoDelete->True,
              PrintPrecision->4], ",", 
            StyleBox["1.29279999999999994`",
              StyleBoxAutoDelete->True,
              PrintPrecision->5], ",", 
            StyleBox["0.0807099999999999972`",
              StyleBoxAutoDelete->True,
              PrintPrecision->4]}], "}"}], ",", 
        RowBox[{"{", 
          RowBox[{
            StyleBox["0.920000000000000106`",
              StyleBoxAutoDelete->True,
              PrintPrecision->2], ",", 
            StyleBox["1.16199999999999992`",
              StyleBoxAutoDelete->True,
              PrintPrecision->5], ",", 
            StyleBox["0.0725399999999999955`",
              StyleBoxAutoDelete->True,
              PrintPrecision->4]}], "}"}], ",", 
        RowBox[{"{", 
          RowBox[{
            StyleBox["0.596999999999999975`",
              StyleBoxAutoDelete->True,
              PrintPrecision->3], ",", 
            StyleBox["0.770599999999999951`",
              StyleBoxAutoDelete->True,
              PrintPrecision->4], ",", 
            StyleBox["0.0481099999999999994`",
              StyleBoxAutoDelete->True,
              PrintPrecision->4]}], "}"}]}], "}"}]], "Output"]
}, Closed]],

Cell[TextData[{
  "Here we calculate the maximum value contained in ",
  StyleBox["newdata", "Input"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Max[newdata]\)], "Input"],

Cell[BoxData[
    StyleBox["1.29279999999999994`",
      StyleBoxAutoDelete->True,
      PrintPrecision->5]], "Output"]
}, Closed]],

Cell[TextData[{
  "Here we execute the contents of a larger file called ",
  StyleBox["eye.dat", "Output"],
  ", which defines a list called ",
  StyleBox["eye", "Input"],
  " to be a list of gray values taken from a digitized photograph."
}], "Text"],

Cell[BoxData[
    \(\(Get["\<eye.dat\>"]; \)\)], "Input"],

Cell["Here is a density plot of the data.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(ListDensityPlot[eye, Mesh \[Rule] False, 
      AspectRatio \[Rule] Automatic]; \)\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .48837 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% DensityGraphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.00745379 0.00939177 0.00745379 [
[.01923 -0.0125 -3 -9 ]
[.01923 -0.0125 3 0 ]
[.16831 -0.0125 -6 -9 ]
[.16831 -0.0125 6 0 ]
[.31738 -0.0125 -6 -9 ]
[.31738 -0.0125 6 0 ]
[.46646 -0.0125 -6 -9 ]
[.46646 -0.0125 6 0 ]
[.61553 -0.0125 -6 -9 ]
[.61553 -0.0125 6 0 ]
[.76461 -0.0125 -9 -9 ]
[.76461 -0.0125 9 0 ]
[.91369 -0.0125 -9 -9 ]
[.91369 -0.0125 9 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .00939 -6 -4.5 ]
[-0.0125 .00939 0 4.5 ]
[-0.0125 .08393 -12 -4.5 ]
[-0.0125 .08393 0 4.5 ]
[-0.0125 .15847 -12 -4.5 ]
[-0.0125 .15847 0 4.5 ]
[-0.0125 .23301 -12 -4.5 ]
[-0.0125 .23301 0 4.5 ]
[-0.0125 .30754 -12 -4.5 ]
[-0.0125 .30754 0 4.5 ]
[-0.0125 .38208 -12 -4.5 ]
[-0.0125 .38208 0 4.5 ]
[-0.0125 .45662 -12 -4.5 ]
[-0.0125 .45662 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 .48837 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 .48837 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.01923 0 m
.01923 .00625 L
s
[(0)] .01923 -0.0125 0 1 Mshowa
.16831 0 m
.16831 .00625 L
s
[(20)] .16831 -0.0125 0 1 Mshowa
.31738 0 m
.31738 .00625 L
s
[(40)] .31738 -0.0125 0 1 Mshowa
.46646 0 m
.46646 .00625 L
s
[(60)] .46646 -0.0125 0 1 Mshowa
.61553 0 m
.61553 .00625 L
s
[(80)] .61553 -0.0125 0 1 Mshowa
.76461 0 m
.76461 .00625 L
s
[(100)] .76461 -0.0125 0 1 Mshowa
.91369 0 m
.91369 .00625 L
s
[(120)] .91369 -0.0125 0 1 Mshowa
.125 Mabswid
.0565 0 m
.0565 .00375 L
s
.09377 0 m
.09377 .00375 L
s
.13104 0 m
.13104 .00375 L
s
.20558 0 m
.20558 .00375 L
s
.24284 0 m
.24284 .00375 L
s
.28011 0 m
.28011 .00375 L
s
.35465 0 m
.35465 .00375 L
s
.39192 0 m
.39192 .00375 L
s
.42919 0 m
.42919 .00375 L
s
.50373 0 m
.50373 .00375 L
s
.541 0 m
.541 .00375 L
s
.57826 0 m
.57826 .00375 L
s
.6528 0 m
.6528 .00375 L
s
.69007 0 m
.69007 .00375 L
s
.72734 0 m
.72734 .00375 L
s
.80188 0 m
.80188 .00375 L
s
.83915 0 m
.83915 .00375 L
s
.87642 0 m
.87642 .00375 L
s
.95095 0 m
.95095 .00375 L
s
.98822 0 m
.98822 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .00939 m
.00625 .00939 L
s
[(0)] -0.0125 .00939 1 0 Mshowa
0 .08393 m
.00625 .08393 L
s
[(10)] -0.0125 .08393 1 0 Mshowa
0 .15847 m
.00625 .15847 L
s
[(20)] -0.0125 .15847 1 0 Mshowa
0 .23301 m
.00625 .23301 L
s
[(30)] -0.0125 .23301 1 0 Mshowa
0 .30754 m
.00625 .30754 L
s
[(40)] -0.0125 .30754 1 0 Mshowa
0 .38208 m
.00625 .38208 L
s
[(50)] -0.0125 .38208 1 0 Mshowa
0 .45662 m
.00625 .45662 L
s
[(60)] -0.0125 .45662 1 0 Mshowa
.125 Mabswid
0 .0243 m
.00375 .0243 L
s
0 .03921 m
.00375 .03921 L
s
0 .05411 m
.00375 .05411 L
s
0 .06902 m
.00375 .06902 L
s
0 .09884 m
.00375 .09884 L
s
0 .11374 m
.00375 .11374 L
s
0 .12865 m
.00375 .12865 L
s
0 .14356 m
.00375 .14356 L
s
0 .17338 m
.00375 .17338 L
s
0 .18828 m
.00375 .18828 L
s
0 .20319 m
.00375 .20319 L
s
0 .2181 m
.00375 .2181 L
s
0 .24791 m
.00375 .24791 L
s
0 .26282 m
.00375 .26282 L
s
0 .27773 m
.00375 .27773 L
s
0 .29264 m
.00375 .29264 L
s
0 .32245 m
.00375 .32245 L
s
0 .33736 m
.00375 .33736 L
s
0 .35227 m
.00375 .35227 L
s
0 .36717 m
.00375 .36717 L
s
0 .39699 m
.00375 .39699 L
s
0 .4119 m
.00375 .4119 L
s
0 .4268 m
.00375 .4268 L
s
0 .44171 m
.00375 .44171 L
s
0 .47153 m
.00375 .47153 L
s
0 .48643 m
.00375 .48643 L
s
.25 Mabswid
0 0 m
0 .48837 L
s
.01923 .48212 m
.01923 .48837 L
s
.16831 .48212 m
.16831 .48837 L
s
.31738 .48212 m
.31738 .48837 L
s
.46646 .48212 m
.46646 .48837 L
s
.61553 .48212 m
.61553 .48837 L
s
.76461 .48212 m
.76461 .48837 L
s
.91369 .48212 m
.91369 .48837 L
s
.125 Mabswid
.0565 .48462 m
.0565 .48837 L
s
.09377 .48462 m
.09377 .48837 L
s
.13104 .48462 m
.13104 .48837 L
s
.20558 .48462 m
.20558 .48837 L
s
.24284 .48462 m
.24284 .48837 L
s
.28011 .48462 m
.28011 .48837 L
s
.35465 .48462 m
.35465 .48837 L
s
.39192 .48462 m
.39192 .48837 L
s
.42919 .48462 m
.42919 .48837 L
s
.50373 .48462 m
.50373 .48837 L
s
.541 .48462 m
.541 .48837 L
s
.57826 .48462 m
.57826 .48837 L
s
.6528 .48462 m
.6528 .48837 L
s
.69007 .48462 m
.69007 .48837 L
s
.72734 .48462 m
.72734 .48837 L
s
.80188 .48462 m
.80188 .48837 L
s
.83915 .48462 m
.83915 .48837 L
s
.87642 .48462 m
.87642 .48837 L
s
.95095 .48462 m
.95095 .48837 L
s
.98822 .48462 m
.98822 .48837 L
s
.25 Mabswid
0 .48837 m
1 .48837 L
s
.99375 .00939 m
1 .00939 L
s
.99375 .08393 m
1 .08393 L
s
.99375 .15847 m
1 .15847 L
s
.99375 .23301 m
1 .23301 L
s
.99375 .30754 m
1 .30754 L
s
.99375 .38208 m
1 .38208 L
s
.99375 .45662 m
1 .45662 L
s
.125 Mabswid
.99625 .0243 m
1 .0243 L
s
.99625 .03921 m
1 .03921 L
s
.99625 .05411 m
1 .05411 L
s
.99625 .06902 m
1 .06902 L
s
.99625 .09884 m
1 .09884 L
s
.99625 .11374 m
1 .11374 L
s
.99625 .12865 m
1 .12865 L
s
.99625 .14356 m
1 .14356 L
s
.99625 .17338 m
1 .17338 L
s
.99625 .18828 m
1 .18828 L
s
.99625 .20319 m
1 .20319 L
s
.99625 .2181 m
1 .2181 L
s
.99625 .24791 m
1 .24791 L
s
.99625 .26282 m
1 .26282 L
s
.99625 .27773 m
1 .27773 L
s
.99625 .29264 m
1 .29264 L
s
.99625 .32245 m
1 .32245 L
s
.99625 .33736 m
1 .33736 L
s
.99625 .35227 m
1 .35227 L
s
.99625 .36717 m
1 .36717 L
s
.99625 .39699 m
1 .39699 L
s
.99625 .4119 m
1 .4119 L
s
.99625 .4268 m
1 .4268 L
s
.99625 .44171 m
1 .44171 L
s
.99625 .47153 m
1 .47153 L
s
.99625 .48643 m
1 .48643 L
s
.25 Mabswid
1 0 m
1 .48837 L
s
0 0 m
1 0 L
1 .48837 L
0 .48837 L
closepath
clip
newpath
% Start of gray image
p
.01923 .00939 translate
.96154 .46959 scale
129 string
129 63 8 [129 0 0 63 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  Mimage
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFEEFFEEFFEEFFEEFFEEFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFEEEEEEEEEEEEDDEEDDEEEEFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFF
FFFFFFFFEEFFEEFFFFFFEEEEEEFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEEFF
EEEEDDDDDDDDDDDDDDDDDDEEEEFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFF
FFFFFFEEEEDDEEDDEEDDEEEEEEEEFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFEEEEEEEEDDEEDDEEDDEEDD
DDCCDDCCDDCCCCCCDDDDEEDDEEEEFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFF
FFFFEEDDDDDDCCCCCCDDDDDDDDEEEEEEEEEEEEFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFEEEEDDDDDDCCCCDDCCCCCCCC
CCCCCCCCCCCCCCDDDDDDDDEEEEEEFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFF
FFEEEEDDDDCCCCCCCCCCCCCCDDDDDDDDEEEEEEEEEEEEFFFF
FFFFFFFFFFFFFFFFFFEEEEDDDDCCCCCCCCBBCCBBCCBBCCCC
CCCCCCCCDDDDDDDDEEDDEEDDEEEEFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFF
FFFFEEDDCCCCBBBBBBBBBBBBBBCCCCDDCCCCCCDDDDEEDDEE
EEFFEEFFEEEEEEEEEEDDCCCCBBCCBBBBAABBAABBBBBBBBCC
CCCCCCDDDDEEDDEEDDEEDDEEDDEEEEFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFF
FFFFEEDDCCBBBBAAAAAAAAAABBBBCCCCCCCCCCCCCCCCDDDD
EEEEEEDDEEDDDDDDDDCCCCBBBBAABBAAAAAABBBBBBBBCCCC
CCCCDDDDDDDDDDCCDDCCCCCCCCCCDDDDEEEEFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFF
FFFFEEDDCCBBAAAAAAAA99AA99AAAABBBBBBBBBBBBCCCCDD
CCDDDDDDCCDDCCCCBBCCBBBBAAAA99AAAABBAABBBBCCCCCC
CCDDCCCCCCCCBBCCBBBBAAAAAABBBBBBBBCCCCDDDDEEEEFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFF
FFFFFFDDCCBBBBAAAA99999999999999AAAAAAAABBBBBBBB
CCCCCCCCCCBBCCBBBBAABBAAAAAAAAAABBBBBBBBCCCCCCCC
CCBBBBAAAAAAAA999988998888889999AAAAAAAABBBBBBBB
CCCCDDCCDDDDEEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFEEEEEEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFF
FFFFFFEECCCCBBAA99998888888888888899999999AAAABB
BBBBBBBBBBBBAABBBBBBAAAAAAAAAABBBBCCCCCCCCCCBBBB
AAAA99998888887777776666666666777788888888888899
99AAAABBAABBCCDDEEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
EEEEEEEEDDEEEEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFF
FFFFFFFFDDCCBBAAAA999988887777777777888888889999
AAAAAAAAAAAAAAAABBAABBAABBBBBBBBCCCCDDCCCCBBBBAA
998888777766665566555544555555556666666677667777
777788889999AABBEEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFEEEEEEEEEEEEEEEEDDDDDDDDDDDDDDDDDDDDDDEEEEFFFF
FFFFFFFFFFFFFFFFFF
FFFFFFFFDDDDBBBBAA998888777766666666667777888888
8899999999AAAAAAAABBAABBBBBBCCDDDDEEEEEECCCCAA99
777766665555555544444444444444554455555555555566
66666677778899BBCCFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFDDDDBBBBBBBBBBBBAABBBBBBBBCCDDFF
FFFFFFFFFFFFFFFFFF
FFFFFFFFFFDDDDBBBBAA9988887777666655555566667777
8888888899999999AAAABBBBCCDDEEEEFFFFFFEEDDBBAA77
665555555544444444444444444444445544554455445555
5555666666668899CCFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFEECCAA999988998888888888AABBCCDD
FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFDDDDBBBBAA99888877776655555555555566
6677777788888899AABBCCDDDDEEFFFFFFFFFFFFDDBB8877
555544444444444444443344444444444444444444554455
5555556655667799BBFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFEECC9999777766666677667788AABBDD
EEFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFEEDDBBBBAAAA8888777755554455445544
5555666677778888AABBCCEEFFFFFFFFFFFFFFFFDDBB8866
554444444444444444444433443344334444444444445544
5555555555666688BBEEFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFEEBB997777555544555555668899BBDD
FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFEEDDBBBBAAAA88887777555544444444
445555555566778899CCDDEEFFFFFFFFFFFFFFFFDDBB8866
555544444444444444444444334433333333334444444455
555555555555557799DDFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFDDBB8877555544443344556677AABBDD
FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFEEDDBBBBAA99998877775555444444
444444445555777799BBDDEEFFFFFFFFFFFFFFFFDDAA8866
555555444433443344334433333333333333333344445555
555566555555556699CCFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFEECC997755554444334444556688AACCEE
FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFDDCCBBBBAA999988777755554444
334433444455667799BBCCFFFFFFFFFFFFFFFFFFDDAA8866
555544554444334433443333333322332233334444555555
556655555555556688BBFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFDDCC99886655444433444455668899BBDDFF
FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFEEDDCCBBBBAAAA99887777555533
443333334444556688AACCEEFFFFFFFFFFFFFFFFDDAA8877
665555444433443344333322332222223322333344556666
666666555555556688AAFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFEECCBB99776655554444444455668888BBCCFFFF
FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFEECCBBAAAA99AA998877775555
44443333334444667799BBDDFFFFFFFFFFFFFFFFDDBB9988
666655665555444444443333223322222233334444666666
666666665555556677BBFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFEEBBAA88775555555544555566778899AACCEEFFFF
FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFEECCBBAAAA99AA9999777755
44444433444444556677AABBEEFFFFFFFFFFFFFFFFCCAA88
776666444433333333333322222222222233444455556666
776666666655666688AAFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFDDBB9977775555555544555566778899BBCCEEFFFFFF
FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFEEDDBBBBAAAAAAAA99997777
5555444433444455557788AACCEEFFFFFFFFFFFFEEDDAA99
777755553333333333332233222222222233335555666677
667766666666667788BBFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFDDAA9977665555445555666677778899BBCCEEFFFFFFFF
FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFEEDDBBBBAAAAAAAAAA9988
776655444444444455557788AABBEEFFFFFFFFFFEECCBB99
887766444433333333223322222222223344555566667777
777777777777888899CCFFFFFFFFFFFFFFFFFFFFFFFFFFEE
CC9988666655554455556666778899AABBDDFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFDDCCBBBBAABBBBBBAAAA
88886666555544444455557788AABBDDEEEEEEEEDDCCBBAA
998866553333333333332233222222444466667777888888
8888888888888899AACCFFFFFFFFFFFFFFFFFFFFFFFFFFCC
9977665555555555556677888899AABBCCEEFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFDDCCBBBBBBBBBBBBBB
AA9988776655554444445555777799AABBCCCCBBBBBBBB99
9988775544333333332233223333445577889999AAAABBAA
BBAAAA9999999999BBDDFFFFFFFFFFFFFFFFFFFFFFFFCC88
775555555555666677778899AABBCCDDFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFDDCCBBBBBBCCCCDD
CCBBAA9977775555444444555566778888AAAAAAAAAA9999
8888665533332233223322333344557799BBCCDDDDDDDDDD
CCCCBBAA999999AABBEEFFFFFFFFFFFFFFFFFFFFFFDD9977
5555555555666677779999AABBCCDDFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFEE
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFDDCCBBBBCCDDDD
DDDDCCAA9988775555445544555566777788888888888877
77665544443333223322332233447788BBDDEEEEFFEEFFEE
EECCCCBBAAAA9999BBEEFFFFFFFFFFFFFFFFFFFFDD997755
555555667777888899AABBCCDDDDFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFEE
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFDDDDBBCCCCDD
DDEEDDCCBBAA887766554455445555666677667766776666
55554444333322332233223333556699BBDDEEFFEEFFEEEE
DDDDBBBBAA9999AACCFFFFFFFFFFFFFFFFFFFFDD99776666
55666677779999AAAABBCCEEEEFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFEE
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFDDCCCCCCDD
EEEEFFEEDDBBAA8877666655555555556666666666556655
55444433332233223322333344557788AABBCCCCDDCCCCCC
CCAAAA99998899AADDFFFFFFFFFFFFFFFFFFCC9988666666
7777888899AABBBBDDDDEEFFFFFFFFFFFFEEFFFFFFFFFFFF
FFFFFFFFFFFFFFFFEE
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFDDDDCCDD
DDEEEEFFEEDDBBAA88886666555544554455555555554444
44443333222222222222223333445577889999AA99AA9999
88888888778888AADDFFFFFFFFFFFFFFDDBB997766666677
889999AABBCCCCDDEEFFFFFFFFFFFFEEDDEEEEFFFFFFFFFF
FFFFFFFFFFFFFFFFEE
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFDDDDCC
DDEEFFEEFFEEDDCCBB998877665555445544554444445544
443333223322222222222222333344556666776677667766
66666666667799AAEEFFFFFFFFFFFFCCAA88777777778888
99AABBCCDDDDEEFFFFFFFFFFFFFFEEDDDDDDFFFFFFFFFFFF
FFFFFFFFFFFFFFEEEE
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFDDDD
DDDDDDFFFFFFEEEECCBB9999777755554455445544554444
444433333333222222222222223333444455555555554455
44554455556688AABBDDEEEEEEDDBB9988777777778899AA
BBCCCCDDEEFFFFFFFFFFFFFFFFEECCCCCCEEFFFFFFFFFFFF
FFFFFFFFFFFFFFFFEE
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEE
DDDDDDEEFFFFFFFFEEDDCCAA997777555555554455445555
554444444433333333223322222233334433444444444444
4433444455668888AABBCCBBBB999988887788889999AABB
CCCCEEEEFFFFFFFFFFFFFFFFEECCCCCCDDEEFFFFFFFFFFFF
FFFFFFFFFFFFFFEEEE
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
EEEEDDEEEEFFEEFFEEEEDDCCAAAA88776666555544555555
555555554455444433443333333333333344334433443344
334444555566668888999999998888888888889999BBBBDD
DDEEEEFFFFFFFFFFFFFFFFEEDDCCCCDDEEFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFEE
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFEEDDDDDDDDEEEEFFEEEEDDDDBBAA998877776666556655
555555555555555555444444444444444444554444445544
554455556666777788888888998888889999AAAABBCCDDEE
FFFFFFFFFFFFFFFFFFFFFFDDCCCCDDEEFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFEEEE
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFEEDDDDDDDDDDEEFFEEFFEEDDCCBBAA99887766665555
556655665566556655555555555555555555556655665566
556655665566667777888899889999AAAAAAAABBCCEEEEFF
FFFFFFFFFFFFFFFFFFEEDDCCBBDDDDFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFEE
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFEEEEDDDDDDEEEEEEEEEEEEEECCCCAAAA8888776666
666666666666666666556666665566666666776677667766
776666667766777788889999AAAABBAABBBBCCDDEEFFFFFF
FFFFFFFFFFFFFFFFEECCCCBBCCDDFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFEEEE
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFEEEEDDDDDDDDDDEEEEEEEEEEDDCCBBAA88887777
777777777777777766776666666666777788778877777777
778877887788778899AAAABBBBCCCCCCCCDDDDEEFFFFFFFF
FFFFFFFFFFFFFFDDCCBBBBCCDDFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFEEEE
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFEEDDDDDDDDDDEEEEEEEEEEDDCCBBAA999988
998888778877777777667777777788888888888888888888
88889988999999AABBBBCCDDEEEEEEEEEEEEFFFFFFFFFFFF
FFFFFFFFFFEEDDBBBBBBBBCCEEFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFEEEE
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFDDEEDDDDDDDDDDEEDDDDCCCCBBBBAAAA
99AAAAAA99998888777777887788888888999999889999AA
99AAAAAAAABBBBDDDDEEFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFEECCBBAAAABBCCEEFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFEEEEEE
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFEEEEDDDDDDDDDDDDCCDDCCCCCCCCBB
CCBBBBAAAA99999999999999999999999999AA99AAAAAAAA
BBBBCCCCCCDDEEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFEECCBBAAAAAABBCCEEEEFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFEEEE
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFEEEEDDDDCCDDCCCCCCCCCCDDCCDD
CCDDCCCCBBBBAABBBBBBBBBBAABBAAAAAAAAAAAAAABBBBCC
CCDDDDEEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
DDCCBBBBAAAAAABBCCEEEEFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFEEDDDDCCDDCCCCCCDDDD
DDDDDDDDCCCCCCCCDDDDDDDDDDCCCCBBBBBBBBCCCCCCEEEE
EEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEECC
BBAAAAAAAABBCCDDEEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFEEFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFEEEEDDDDCCCCCCCCCCDD
CCDDCCDDCCDDCCDDDDEEEEEEDDDDCCDDCCDDDDEEEEFFEEFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFDDCCBBBB
99AAAABBBBDDDDFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEEDDDDDDCCCCCC
DDCCDDCCCCCCDDDDEEEEFFEEFFDDDDDDEEEEFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEECCCCBBAAAA
BBAABBCCEEEEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEEEEDDDDDDDD
CCDDCCDDCCDDCCEEEEFFEEFFEEEEEEEEEEFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFDDDDCCCCBBBBBBBB
BBDDDDFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEEEEEE
EEEEDDDDDDCCDDDDEEEEEEDDEEDDEEDDEEEEFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFEEEEDDDDCCCCCCCCCCDDDD
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFEEEEEEEEDDEEDDEEDDEEDDDDDDEEEEEEEEFFEEFFFFFF
EEFFFFFFEEFFFFFFFFFFEEEEDDEEDDDDDDDDDDEEEEFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFEEFFEEEEEEEEDDEEEEEEEEFFFFFFFFFFEE
FFEEFFFFFFEEFFEEFFFFFFEEFFEEEEEEFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF
FFFFFFFFFFFFFFFFFF
pop
P
% End of image
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  Evaluatable->False,
  ImageSize->{299.062, 146},
  ImageMargins->{{48, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004[0000TPP10`4000010?ooooooc?ooZ_ooI_oo
<ooo0?o<ooo<c?o<VC/k>gYjN[Vi^OShn03ooeGooj[ooonI<onI0?mVoomVc?mVVOmVI_mV<omV0?lc
oclo?ginO[fm_Oclo5D00:X00?l00?l0VOl0I_l0<ol00<coolcoc<coVLcoIP<30d92@X61PL30`000
EED0EJX0EOl0ELbIolbIc<bIVLbII/bI<lbI0<aVolaVc0L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0Z/`c
<l`c0<`0ol`0c<`0VL`0I/`0<l`000/;2dY:BXV9RLS8b000oeD0ojX0ool0oiW<VIW<IYW<<iW<09VI
oiVIc9VIVIVIIPl?3di>CXf=SLc<c01E05EE0:YE0?mE09TcoiTcc9TcVITcIYTc<iTc09T0oiT0c1<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEEFKo<fKo06K<ofK<c6K<VFK<IVK<<fK<01LG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZVIVVFIVIVIV<fIV06HcofHcc6HcVFHcIQ/K6eYJFYVIVMSHf01EoeEEojYEoomEoc?o
oc?oc3?oVC?oIS?o<c?o03?<oc?<c1lO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ03>I<c>I03=Voc=Vc3=V
VC=VIS=V<c=V02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZEC<0VC<0IS<0<c<0003oo`3oc03oV@3oIRLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2Io`2Ic02IV@2IIP2I<`2I001Vo`1Vc2/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`0c<`0c0000o`00c000V@00IP00<nh002l_;fi^KZf][Nc/k03o05Go0:[o0?oo0140
003^003M002k002Z0028001g001E03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@00M`00E@00A0008P00
4Nk^k]gMgK^k^cLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l0;0000?l0;00001T00_lR00Co0`02ob40
0ol300;o8002o`@00_lQ00;o1002oa`00ol400;o1002oaT00ol300Co0`02oaP0000H0004o`00ob80
00?o00000P001?l00?lQ0005o`000?l00P000ol0000L0004o`00o`8000Co003o7`001?l00?l20004
o`00oa`000?o00000P001?l00?l20004o`00oaT000?o00000`000ol000020004o`00oaL0000H0004
o`00ob<000Go0000o`020003o`0001d01?l20004o`00oah000Co003o0P001?l00?lO0004o`00o`80
00Co003o70000ol000020004o`00o`8000Co003o6@000ol000040005o`000?l00P000ol0000E0000
60001?l00?lT0004o`00o`8000?o00007@000ol0o`030004o`00oah00ol30004o`00ob000_l30004
o`00oa`000?o00000P001?l00?l20004o`00oaT000?o00001@001?l00?l20003o`0001D0000H0004
o`00ob4000Co003o0P001?l00?lO0003o`3o00<000Co003o7P000ol000030004o`00oal000Co003o
0P001?l00?lL0003o`00008000Co003o0P001?l00?lI0003o`00008000Co003o0P001?l00?lG0000
6@02ob<00_l400;o8@02o`@00_lP00?o0`02ob400_l400;o7002o`D00_l400;o6@02o`D00_l400;o
60000?l0;0000?l0;0000?l0;0000?l0;0000?l0;00000d00_l50?oo4_l6000030001?l00?l40003
o`0000<000?o00001`000ol000070003o`0000L000?o00001`000ol000070003o`0000L000?o0000
1`000ol000080003o`0000L000?o00001`000ol000070003o`0000L000?o00001`000ol000070003
o`0000L000?o000020000ol000070003o`0000L000?o00001`000ol000070003o`0000L000?o0000
1`000ol000070003o`0000L000?o000020000ol000070004o`00o`H0000<0004o`00o`@00ol30003
o`0002D000?o00009P000ol0000U0003o`0002H000?o00009@000ol0000U0003o`0001<00ol60000
30001?l00?l40003o`000?l03P000ol00004000030001?l00?l40003o`000?l03P000ol000040000
3@02o`D000?o0000o`0>0003o`0000@0000D00;oo`0>00;o1P0001@000?o0000o`0>0003o`0000@0
000D0003o`000?l03P000ol00004000050000ol0003o00h000?o0000100001@000?o0000o`0>0003
o`0000@0000D00;oo`0>00;o1P0001@000?o0000o`0>0003o`0000@0000D0003o`000?l03P000ol0
0004000050000ol0003o00h000?o0000100001@00_oo00h00_l6000050000ol0003o00h000?o0000
100001@000?o0000o`0>0003o`0000@0000D0003o`000?l03P000ol0000400005002ool03P02o`H0
000D0003o`000?l03P000ol0000400001P03o`@00_l50003o`0006P00_D200;e0P02m@800_D200;e
T`000ol0000400001`000ol000020004o`00o`@000?o0000J002m@800_D200;e0P02m@800_FC0003
o`0000@000070003o`00008000Co003o1003ofH03?D2V`;e0Y/4mHl00ol600001`000ol000020004
o`00o`@000?o0000IP0<m@:K0_D2V`CeT@000ol0000400001`000ol000020004o`00o`@000?o0000
2`02m@800_D600Ke@`02m@801?DBV`CeS`000ol0000400001P02o`D00_l50003o`0000/00_D200;e
1P06mD<00_D200Ce4Y/4mHl000?o0000100001@00_l:00Ce0Y/2m@:K0_D2V`Se;`08m@:K0_D2V`;e
0Y/2m@BK0U/2V`9K0Y/6F`BK0_D2V`CeS002o`H0000D0003o`0000T01?D2V`;e0Y/2m@:K2?D_00Se
0Y/2m@:K0_D2V`;e19/2F`:K0U/2V`IK19/2m@:K1?F=0003o`0000@0000D0003o`0000L00_D6V`IK
29/<mB<01?D6V`AK0Y/FF`RK1_F=0003o`0000@0000D0003o`0000L00_D6V`IK29/<mB<01?D6V`AK
0Y/FF`RK1_F=0003o`0000@0000D00;o1P04m@BK3U/8V`ge5P04m@BK25/2m`9K0_L2F`;g35/8V`;e
0Y/2m@:K1?F<00;o1P0001@000?o00001@04m@BK3U/8V`ge5P04m@BK25/2m`9K0_L2F`;g35/8V`;e
0Y/2m@:K1?F=0003o`0000@0000D0003o`0000L00_D2V`AK3_L4F`:K1U/4V`?e0Y/4m@800_D200[e
0Y/4F`;g0U/4m`;:0_L2bPSg25/4V`;e0Y/2m@:K0_D2V`;e0Y/4mH/000?o0000100001@000?o0000
1`02m@:K15/>m`AK0Y/6F`BK0oD2V`Ce0P02m@802_D2V`AK0_L2F`Cg0/X2m`;:2?L8F`BK0_D2V`;e
0Y/2m@:K0_D2V`CeR`000ol0000400005002o`P00_D2V`AK3_L4F`:K1U/4V`?e0Y/4m@800_D200[e
0Y/4F`;g0U/4m`;:0_L2bPSg25/4V`;e0Y/2m@:K0_D2V`;e0Y/4mHX00_l6000050000ol0000700;e
0Y/2F`Cg2/X4ma5K19/6m@:K0_D8V`AK1?L2bP;g1/X8m`QK2Y/2F`:K2U/4V`GeQ0000ol000040000
50000ol0000700;e0Y/2F`Cg2/X4ma5K19/6m@:K0_D8V`AK1?L2bP;g1/X8m`QK2Y/2F`:K2U/4V`Ge
Q0000ol00004000050000ol0000700;e0Y/2F`;g2<X2EP;:0UH4bPcg1E/2V`9K1Y/2F`:K15/2m`9K
1?L4bP9F1<X2m`;:1?L8F`:K25/2m`9K1?L6bPWg15/4V`CeNP000ol0000400005002o`P00_D2V`9K
0_L8bP9F0/X2EPC:3?L5F`:K0U/6V`9K0Y/4F`;g0U/4m`C:0UH4bP;g0/X4m`QK0Y/8F`;g0U/4m`K:
2OL4F`BK1?Ei00;o1P0001@000?o00002@02V`9K1?L4bPiF2<X9m`YK0_L2F`Cg0/X2m`[:2?L:F`Cg
2<X4EP9:0UH6BPAF2LX8m`AK0Y/2F`BK0_DT00Ke@0000ol0000400001P04o`<00_l50003o`0000T0
0Y/2F`Cg1<X>EPS:2OL:F`;g0U/4m`;:0_L:bPSg2U/4m`S:15H2BP9F1TX4EPW:2?L4F`:K0U/4V`;e
9006mD0000?o0000100000L000?o00000P001?l00?l40003o`0000T00_D4F`;g0/X4EPi:25H5bPkg
0/X6m`[:1?L:F`Cg1<X4EPI:1_T:P@Gi34X4EPC:0_L2bP;g0U/2V`;e7P08m@:K1?Dj0003o`0000@0
00080005o`000?l00P000ol0000200?o2@02m@AK0_L2bPAF3TX8EPG:3_L2bPKg2/X4m`YK1?L4bPAF
1TX6n@Z11OT<BPAF1<X2m`;:0_L2F`:K0_DN00Se0Y/4mCP00ol600002@001?l00?l20003o`000080
00?o00002`02V`9K0_L4bPAF14X:n@U:15H@bP;g0/X2m`;:2?L4F`:K15/4m`;:0UH4BPCi1842K@:1
16d2:@Q]2H42n@:12?T4BPAF0/X2m`;e800@mANK1?DK0003o`0000@000060004o`00o`8000Co003o
10000ol0000;00:K0U/2m`C:15H4BP[i2DX4EQ3:0_L2bP;g0/X8m`AK0Y/4F`Cg0/X2EPA:1?T4P@9]
0X44K@8Y26d9P@;i0X48n@A:15H2bP;g0_DP013e5i/4mA/000?o0000100000L00_l400;o1@000ol0
000;00BK1?L2bP9F14X4n@Z11?T9BPQF2<X2m`;:1_L2F`BK1_D4F`;:0UH4n@B126d>:@9]0bT<K@R1
1?T2BP9F0_L2Fbh019/=m`;:2?L2F`:K6@000ol0000400005002o``019/4m`;:0UH4BPCi2X44n@U:
25H8bP;g0/X6m`9K19/6m@AK0/X2EPCi1848K@hY0Vd3:@a]2844n@9:0UH2m`9K;P04V`gg0/X8m`9K
0Y/H00;o1P0001@000?o00003@04V`Cg0/X2EPA:1?T4P@I]1H44n@Q:25H4bPCg0U/2V`Ce1P02m@:K
0_L2bP;i0X48KAHY0fd2:@9]0RT2K@8Y26d8P@9:0UH2Fbh00_D2F`;:1EH2BP9F2TX2bP;g0U/2VaL0
00?o0000100001@000?o00003@04V`Cg0/X2EPA:1?T4P@I]1H44n@Q:25H4bPCg0U/2V`Ce1P02m@:K
0_L2bP;i0X48KAHY0fd2:@9]0RT2K@8Y26d8P@9:0UH2Fbh00_D2F`;:1EH2BP9F2TX2bP;g0U/2VaL0
00?o0000100001@000?o00003`04V`Cg0/X2EPA:1?T2P@e]1846n@I:0UH2bP;g0U/4V`;e3002V`;g
0TX2n@A]42T2j1DY0Vd2:@Q]0X42K@:10_T2EP;g;P02m@9K1EH4n@J10_T2P@;i0TX2bP;g0Y/2mAD0
00?o0000100001@00_l@00BK1?L2bP9F14X4n@:13Fd4P@Ki1TX2EP;:0_L2F`BK0_D<00:K0_L2BP;i
16d@:@;X5BT2K@8Y26d2P@9]0X42n@9F0_L^00;e0U/5EPCi1X42n@:10_T2BP;:0_L2V`;e5002o`H0
000D0003o`0001400_D2V`Cg1<X4BPCi16d2:@9]0bT2K@8Y16d4P@Ci14X2bP;g0U/2mA000Y/2m`9:
0X42KA@Y0^P2:@;X0RT2j0dY0Vd2:@Y]1842BP;g0_D/00;e0_L2EPGi16d2:@I]0X42BP9F0_L2VaL0
00?o0000100001@000?o00004@02m@:K1?L4bPA:1?T4K@8Y0Vd3:@9]0RT4K@B11?T4BP;:0_L2F`;e
4002V`;g0TX2P@9]52T2j08Y0^P2:@;X3BT2K@8Y2Vd4P@9:0_L2mB`00_D2m`9F1OT4K@8Y1Vd2P@9:
0UH2m`:K5`000ol00004000050000ol0000C00;e0Y/4m`C:14X4n@A]2bT8K@:10_T2BP9F0U/2V`;e
4002V`;g0TX2P@A]52T2j08Y2nP8:A1]0_T2EP:K;002V`;g0TX3n@A]12T2j08Y0Vd2P@;i0/X2m`:K
5`000ol0000400005002oa@00_D2V`Cg1<X4BPCi16d;:@Q]0X42n@9:0UH2F`:K0_D@00:K0_L2BP:1
16dD:@;X0RT;j0PY46d2n@9F0Y//00:K0_L2BP?i16d4:@;X0RT2K@:10_T2bP;g0Y/F00;o1P0001@0
00?o00005@02m@:K1?L2bPAF0TX4n@A]3bT4K@Ci0UH2m`:K0_D@00:K0/X2BP:11Vd4:@;X0RT2j08Y
0^P2:A?X12T8K@:126d2P@9F0U/Z00;e0U/2EP;i1Fd4:@;X12T2K@:10TX2bP9K0_DG0003o`0000@0
000D0003o`0001D00_D2V`Cg0/X4EP9:1?T4K@lY16d4n@9F0_L2V`;e4002V`;:0TX2P@I]12T2j08Y
0^P2:@;X0RTCj0@Y26d2P@Q]0X42EP9K:P02m@9K0UH2n@E]12T2j0@Y0Vd2P@9:0/X2F`;e5`000ol0
0004000050000ol0000G00:K0U/4m`;:15H2BPCi1Fd4:@;X0RT2j0@Y0Vd2P@;i0UH2m`9K4P02V`;:
0TX2P@A]0RT2K@@Y0^P2:@;X0RT8j0:X0^P3Z0CX12T8K@:12Vd2P@9:0_LX00:K0U/2EP9:0X43K@@Y
0^P4:@9]0X42BP9F0_L2VaT000?o0000100001@00_lH00:K0U/4m`;:15H2BPCi1Fd4:@;X0RT2j0@Y
0Vd2P@;i0UH2m`9K4P02V`;:0TX2P@A]0RT2K@@Y0^P2:@;X0RT8j0:X0^P3Z0CX12T8K@:12Vd2P@9:
0_LX00:K0U/2EP9:0X43K@@Y0^P4:@9]0X42BP9F0_L2VaP00_l6000050000ol0000G00;e0Y/2F`Cg
1<X2EP9:1?T5K@;X0RT6j0@Y0Vd2P@9:0/X2F`;e4002V`;:0TX2n@:116d4:@;X0RT2j08Y1>P2Z0;X
1ZP3j0:X1>P2:@9]2X48K@:10TX2bR@00_D2F`;g0UH2n@:11Fd8:@9]0X44BP;g0U/K0003o`0000@0
000600?o1002o`D000?o00005`02m@:K0U/4m`C:0UH2BPCi1Fd2j08Y1^P4:@9]0X42BP;:0U/2mA00
0Y/2bP9:0_T2P@A]12T2j08Y0^P2:@CX0ZP2j0JX0nP2Z0CX0RT2K@Z126d2P@9:0/XT00;e0U/2m`9F
0_T2P@E]22T2K@:114X2m`9K6`000ol0000400002@001?l00?l20003o`00008000?o00006@02m@9K
0_L4bP9F0/X2EP9:1OT4K@@Y1^P4:@:10_T2EP;g0Y/@00:K0_L2EP9:1842K@:116d8:@CX0ZP2j0NX
1>P4:@j11Vd2P@;i0_LR00;e0_L2bP9:0_T9K@8Y16d2P@;i0TX2EP;:0U/2mA/000?o0000100000T0
00Co003o0P000ol0000200?o6@02m@9K0_L4bP9F0/X2EP9:1OT4K@@Y1^P4:@:10_T2EP;g0Y/@00:K
0_L2EP9:1842K@:116d8:@CX0ZP2j0NX1>P4:@j11Vd2P@;i0_LR00;e0_L2bP9:0_T9K@8Y16d2P@;i
0TX2EP;:0U/2mAT00ol600001`02o`<000Co003o10000ol0000K00;e0U/2m`C:0UH2bPAF1OT2K@HY
0^P6:@9]0X42n@;:0_L2mA000U/2bP9:0_T4P@@Y3>P=Z0;X12T4K@B10_T8P@9]1842BP;:8002V`;g
0UH4n@Q]0bT4K@:10_T2BP9F0_L2F`;e7@000ol0000400002@001?l00?l20003o`00008000?o0000
6`02m@9K0_L4bP9F0/X4EPGi0Vd6:@;X1RT2K@:10_T2bP;g0_D@009K0/X2BP;i1844:@cX3JP2j0@Y
16d4P@;i2842K@B10TX2bR000Y/2m`9F1?T8K@<Y16d2P@;i0TX2EP;g0U/2mAd000?o0000100000H0
0ol400;o1@000ol0000K00;e0Y/4m`S:1EH4n@A]12T2j0@Y16d2n@9:0/X2F`;e3002m@:K0/X2EPCi
16d<j0:X0^P;Z0CX16d4P@;i0X42n@Z10_T2BP;g7P02V`;:0UH2n@:116d2:@A]1H44n@9:0UH2m`9K
0_DO0003o`0000@0000D00;o7002m@:K1?L8bPEF1?T4K@@Y0^P4:@A]0_T2BP;:0U/2m@`00_D2V`;:
0UH4n@A]3>P2Z0;X2jP4j0A]1842n@:10_T:P@;i0TX2mah00Y/2bP9F0_T2P@A]0RT4K@F11?T2BP9F
0_L2F`;e7P02o`H0000D0003o`0001d00_D2V`Cg2lX2EP9:0_T2P@9]2RT4K@;i0TX2bP;g0_D:00;e
0U/2m`9F0TX2n@:112T8j0:X0^P:Z0?X0RT4K@B14?T4BP9F0U/J00;e0U/2EP9:1844K@8Y16d5P@;i
0TX2EP;:0_L2Vb<000?o0000100001@000?o00007@02m@:K1?L;bP9F0TX2n@:10Vd::@A]0_T2BP;:
0_L2m@X00_D2F`;g0UH2BP;i0X44:@SX0ZP2j0ZX0nP2:@A]184@n@A:0UH2FaX00_D2F`9F0TX4P@A]
0RT4K@F10_T2BP9F0/X2m`:K8`000ol00004000050000ol0000O00:K0U/4m`;:1oL4bPA:1844K@HY
16d2n@9:0/X2m`:K2?D2V`9K0_L2bP9F0TX2P@9]3>P2Z0;X1ZP5:@B11?TDBP9F0/X2FaX00U/2EP;i
0X4<K@:10_T5BP9F0/X2m`9K0_DS0003o`0000@0000D00;o8002V`9K1?L2bPOg1<X4BPB116d6:@A]
0_T2BP;:0_L2V`Se0Y/2F`;g0/X2EP9:0X42K@cX0ZP2j0JX1BT4P@Ci54X2EP;:0U/J009K0UH2n@:1
36d2P@;i1DX2EP;:0_L2F`;e8P02o`H0000D0003o`0002400Y/2F`og0/X2EP9:0_T2P@A]1RT4K@Ci
0UH2bP;g15/8m`AF0TX2n@9]0RT8j0:X0^P2Z0CX0RT2K@?i0TX4EPC:0_L2bP;g1<X:EP;g0Y/H009K
0TX2n@Y]1844n@9:0eH2bP;g0U/2VbL000?o0000100001@000?o00008@02V`9K3oL2bP9F0TX2n@:1
16d6:@A]1?T2EP;:0_L4F`Sg15H2BP;i0Vd2:@SX0ZP2j0:X1>P2:@9]0oT2BPAF1<X2m`;:0_L4bPYF
0_L2VaP00U/2BP;i2Vd4P@Ci0TX3EP;:0_L2F`:K9`000ol00004000050000ol0000S00:K0U/6m`EK
0Y/2F`;g0/X2EPCi16d6:@A]0X42n@A:2/X4EPA:0X42K@CX0ZP2j0:X0^P2Z0CX0RT2K@;i0eH2m`9K
2Y/4F`;g0/X6EP;:0_L2mAH00Y/2EP;i2Vd4P@Ci15H3bP;g0U/2Vb800_D50003o`0000@0000D00;o
9002V`9K1_L5F`:K0U/2m`;:0UH4n@A]1RT4K@:10_T4BP[:15H4BP:10Vd4j0:X0^P2Z0;X0ZP4j08Y
0Vd2n@=F0_L2F`ZK15/2m`;:1UH2bP;g0_DF00:K0UH2n@Y]1844n@AF0lX2m`9K0Y/R00;e1002o`H0
000D0003o`0002D00Y/2F`Cg0e/8V`9K0/X2EP9:0_T4K@8Y0Vd2:@A]0X44n@a:1?T2P@9]12T4j0:X
0^P2Z0;X0ZP2j08Y0_T2BP?g0Y/4m@800_D200Ce15/2m`C:15H2m`;e5002V`9F0_T8K@:11?T4BP9F
0/X2m`=K19/T00;e1@000ol00004000050000ol0000U00:K0U/4m`=K29/2F`;:0UH2BP;i16d2:@9]
0RT4K@:11?T<BPCi0X42K@@Y1>P2Z0;X0ZP2j0:X0^P2:@;i0TX3m`:K1?D200;e0P04m@AK0_L4bPAF
0_L2mA@00Y/2EP;i26d2P@Ci14X2EP;:0_L3F`BK9002m@D000?o0000100001@000?o00009`04V`;g
1E/4V`;e0Y/2F`;g0/X2BP;i0X42K@8Y0Vd2:@A]1842n@:10_T2P@;i1844K@@Y1>P2Z0;X0ZP2j0:X
1>P2K@:10UH3m`:K0_D200;e0P04m@BK1?L2bPAF0/X2Fa@00Y/2EP;i1842K@B11?T4EPC:0_L2F`Ge
9P02m@D000?o0000100001@00_lX00BK0_L5F`BK0_D2V`9K0_L2bP9:0_T2P@9]0RT2K@8Y16d4P@;i
0X42n@:10_T4P@A]12T4j0:X0^P2Z0;X0ZP4j09]0X42EP?g0Y/2m@800_D200Ce19/4m`;:15H2bP9K
5002V`9F0_T4P@9]1844n@AF1<X2m`9K1ODV00;e1002o`H0000D0003o`0002T00Y/7F`:K1?D200;e
0Y/2m`;:0TX2n@B12Vd:P@9]0X44K@@Y1>P2Z0;X0ZP2j0:X1>P2:@9]0_T2BP?:0_L4F`:K25/4bPAF
0TX2EP;:0Y/B009K0UH2BPJ11?T4BP9F0/X4m`BK0_D=00;e7002m@D000?o0000100000L00ol300;o
1@000ol0000Y00:K1e/2V`Ce0P02m@:K0_L2bP9:0_T4P@Y]2X42K@:116d4:@CX0ZP2j0:X0^P2Z0CX
0RT2K@;i0TX3bP;g15/2V`QK1<X4EP9:0UH2bP:K4P02F`9F0TX6P@Ci14X2EP;:1?L4V`;e3@02mA`0
0_D50003o`0000@000080005o`000?l00P000ol000020003o`0002/01I/2F`BK1?D200;e0Y/2m`;:
14X4P@A]0RT2K@8Y2Vd8:@CX3ZP4j08Y0Vd2n@=:15H2bP9F0/X4EPQ:0_T4BP;:0Y/>00:K0_L2EP;i
1X42n@9:15H2bP;g15/2V`;e3@02m@:K1?DJ00;e1@000ol0000400001P04o`8000Co003o1003ob/0
1I/2F`BK1?D200;e0Y/2m`;:14X4P@A]0RT2K@8Y2Vd8:@CX3ZP4j08Y0Vd2n@=:15H2bP9F0/X4EPQ:
0_T4BP;:0Y/>00:K0_L2EP;i1X42n@9:15H2bP;g15/2V`;e3@02m@:K1?DJ00;e0`03o`H000060003
o`3o00<000Co003o10000ol0000]00FK0U/2V`;e0P02m@800_D2V`9K0_L2EP9:0_T2P@A]0RT2K@8Y
0Vd6:@9]12T4j0:X0^P>Z0CX0RT2K@F10_T2P@;i0X42n@b10_T2EP;:0_D<009K0/X2BPSi14X2EP;:
0_L2F`BK0_D?00;e1Y/J00Ce1@000ol0000400001P000ol0o`030004o`00o`@000?o0000;@05V`9K
0Y/2m@800_D200;e0Y/2F`;g0UH2BP;i0X44K@8Y0Vd2:@9]1RT2K@@Y1>P2Z0;X3ZP4j08Y0Vd5P@;i
0X42n@:10_T<P@;i0UH2bP;e3002F`;:0TX8n@A:0UH2bP;g0U/4V`;e3`02m@JK6P04m@D000?o0000
100000L00_l400;o1@000ol0000`00ZK1P04m@9K0_L4EPCi16d2:@9]0RT2K@8Y0Vd8:@SX3ZP4j0DY
2Vd2:@9]0RT2K@8Y16d2P@9:0/X2m`:K1_D2V`;g0UH2BPSi0TX2EP;:0_L4F`:K0_DA00;e1U/2mA`0
0_D50003o`0000@0000D00;o<@0:V`H01?D2F`;g15H4n@A]0RT2K@8Y0Vd2:@9]22T8j0jX1>P5:@Y]
0RT2K@8Y0Vd2:@A]0X42BP;:0_L2V`Ke0Y/2m`9F0TX8n@9:0UH2bP;g15/2V`;e4@02m@IK0_DL00;e
1002o`H0000D0003o`0003800_D6V`;e2002m@:K0U/2bP9F1?T8K@8Y0Vd2:@I]22T8j0:X0^P6Z0CX
0bT2j0hY0^P4:@9]0X44BP;:0_L2F`Cg15H4BP;i14X4EP;:0_L4F`Ce4@02m@IK0Y/2mAX01?D50003
o`0000@0000D0003o`0003800_D6V`;e2002m@:K0U/2bP9F1?T8K@8Y0Vd2:@I]22T8j0:X0^P6Z0CX
0bT2j0hY0^P4:@9]0X44BP;:0_L2F`Cg15H4BP;i14X4EP;:0_L4F`Ce4@02m@IK0Y/2mAX01?D50003
o`0000@0000D0003o`0003@01?D2V`Ce0P02m@801?D2V`9K1<X2BP;i1844K@8Y3Vd2:@9]12T2j08Y
3nP2:@;X0RT2j08Y0^P2:@;X12T4K@B114X8EPa:15H4m`BK1?D@00?e0Y/4F`:K0_DN00;e1@000ol0
000400005002ocD01?D2V`Ce0P02m@801?D2V`9K1<X2BP;i1844K@8Y3Vd2:@9]12T2j08Y3nP2:@;X
0RT2j08Y0^P2:@;X12T4K@B114X8EPa:15H4m`BK1?D@00?e0Y/4F`:K0_DN00;e1002o`H0000D0003
o`0003H00_D8V`Ce0P04m@BK0_L2bP9F0TX4n@B10Vd2PAA]4bT2K@HY0Vd2:@9]0RT4K@B11?T8BP9F
1TX4EPC:0_L2F`:K0_DF00>K15/2V`;e7P04m@D000?o0000100001@000?o0000=P02m@RK1?D200Ce
19/2m`;:0UH2BPCi1842K@:156dC:@9]1RT2K@8Y0Vd2:@A]1844n@Q:0UH6BPAF1<X2m`9K0Y/2mAH0
0i/4F`:K0_DN00Ce1@000ol00004000050000ol0000h00;e2Y/2m@800_D200;e0Y/2F`;g0/X2EP9:
0_T4P@I]0X42K@:10Vd2P@9]0X4GK@:10Vd2P@9]0X42K@:10Vd2P@9]1844n@A:0UH2BPAF2<X2m`9K
1?DD00;e0Y/3F`;g19/R00;e1@000ol00004000050000ol0000h00;e2Y/2m@800_D200;e0Y/2F`;g
0/X2EP9:0_T4P@I]0X42K@:10Vd2P@9]0X4GK@:10Vd2P@9]0X42K@:10Vd2P@9]1844n@A:0UH2BPAF
2<X2m`9K1?DD00;e0Y/3F`;g19/R00;e1@000ol0000400005002oc/01?D6V`ke15/4bPA:0_TFP@9]
1X42K@V10_T2P@;i0X42n@:10_T6P@;i0X44n@A:15H4bP;g0/X4m`9K0Y/2mAH00_D4F`?g0U/2Vb80
1?D400;o1P0001@000?o0000>P04m@JK3_D4F`C:14X2nAJ10Vd6P@9]2H42n@:10_T2P@;i0X42n@J1
0_T2P@Ci14X4EPC:0_L2bPCg0U/2V`;e5P02m@AK0oL2F`:K8P04m@D000?o0000100001@000?o0000
?004m@ZK2_D2V`9K0_L2bPA:5?T2P@;i2X45n@9:0_T2BP[i0TX2n@9:0_T2BP;i0TX2EPC:1?L8F`BK
0_DF00:K0U/4m`=K0Y/T00Ce1@000ol00004000050000ol0000l00Ce2Y/:m@:K0U/2m`;:14XDn@:1
0_T:P@Gi0TX2n@9:2_T2BP;i0TX2n@9:0_T2BP9F1<X4m`QK19/2mAH00Y/2F`Cg0e/2Vb@01?D50003
o`0000@0000D00;o?@04m@ZK2_D2V`9K0_L2bPA:5?T2P@;i2X45n@9:0_T2BP[i0TX2n@9:0_T2BP;i
0TX2EPC:1?L8F`BK0_DF00:K0U/4m`=K0Y/T00Ce1002o`H0000D0003o`0004000_D:V`[e0Y/2F`;g
0/X4EP9:0UH4BP;i0TX8n@:12?TIBP9F0TX6EP;:1?L2F`:K3?DF00;e0Y/8m`=K0_DT00Ce1@000ol0
000400001P03o`@00_l50003o`0004000_D:V`[e0Y/2F`;g0/X4EP9:0UH4BP;i0TX8n@:12?TIBP9F
0TX6EP;:1?L2F`:K3?DF00;e0Y/8m`=K0_DT00Ce1@000ol0000400002@001?l00?l20003o`000080
00?o0000A002V`;e2Y/2m@BK15/4m`C:0UH6bPAF14X6n@9:0_T9BPIF0TX4EP;:0UH8bPCg19/2mB@0
0_D2F`;g1<X2m`9K0oDT00Ke1@000ol0000400002@001?l00?l20003o`0000800om400:K0_D:V`;e
19/4F`Cg1<X2EPK:15H4BPKi0TX2n@U:1UH2BPAF0/X2EPS:1?L4V`;e9002m@9K0_L4bP;g0U/3mB@0
1_D300?o1P0000H00ol30004o`00o`@000?o0000AP04m@bK0U/2V`QK0_L2F`Cg1<XKEP;:0UH8bPCg
1U/2V`;e9P02m@9K0_L6bP;g0U/5mBH01?D50003o`0000@000060003o`0000<000Co003o10000ol0
001600Ce39/2F`:K25/2m`9K1?L4bQ]F0/X2EPS:1?L6F`:K0_DV00;e0U/2m`K:0_L2F`Ge9P04m@D0
00?o0000100000H01?l300;o1@000ol0001800Ce19/2F`:K2U/2V`9K0Y/2F`:K15/4m`;:2_L2bP;g
3lX4m`AK19/2mBP00Y/2F`Cg1/X2m`9K1?Db0003o`0000@0000D00;oB@04m@BK0U/2V`YK0Y/2F`:K
0U/2V`AK1?L2bP[g0/X2m`o:1?L4F`BK0_DX00:K0U/4m`K:0_L2F`Ce<@02o`H0000D0003o`000500
0_D4V`9K0Y/6F`bK25/:V`AK2OL6F`Ke:P02m@9K0_L8bP;g0U/2V`;e;@02m@L000?o0000100001@0
00?o0000D002m@BK0U/2V`IK39/8F`ZK15/9m`IK1_DZ00;e0U/2m`S:0_L2F`:K0_D]00;e1`000ol0
0004000050000ol0001@00Ce19/:F`:K0U/2V`9K0Y/2F`:K0U/4V`Ke19/2F`:K0e/4V`Ce0P02mBX0
0Y/2F`Cg0UH4bPCg19/j0003o`0000@0000D00;oD@04m@BK2U/2V`9K0Y/2F`:K0U/2V`9K19/6m@BK
0U/2V`=K19/4m@800_DZ00:K0U/4m`9F1<X4m`BK>@02o`H0000D0003o`0005H00_D6V`IK0Y/2F`:K
1U/4V`Ce0P02m@801Y/5mC000_D4F`;g1<X2m`;:0_L2F`Ce?0000ol00004000050000ol0001F00;e
1Y/6F`:K0U/2V`IK19/4m@800_D200JK1OD`00;e15/2m`C:0_L2bP;g0U/4mC`000?o0000100001@0
00?o0000F004m@RK0U/2V`9K0Y/2F`:K0U/4m@800_D200_e;P04V`AK2_L4Vd8000?o0000100001@0
0_mI00Ce29/2F`:K0U/2V`9K0Y/2F`Ce0P02m@802oD^00BK15/:m`BK@@02o`H0000D0003o`0005h0
2_D6V`9K19/6m@:K0_D2V`;e0Y/5mBH01?D4V`YK19]80003o`0000@0000D0003o`0005h02_D6V`9K
19/6m@:K0_D2V`;e0Y/5mBH01?D4V`YK19]80003o`0000@0000D0003o`0006P02?D2V`;e0Y/2m@:K
0_D6V`We0P02m@H00_D600;e2P04m@:K0_D:V`CeCP000ol0000400005002ofT02?D2V`;e0Y/2m@:K
0_D6V`We0P02m@H00_D600;e2P04m@:K0_D:V`CeC@02o`H0000D0003o`0007800_D200Se0Y/9m@X0
0_D200;e1P02m@800_D600;e0P06mEP000?o0000100000L00_l400;o1@000ol0001b00;e0P08m@:K
2OD:00;e0P02m@H00_D200;e1P02m@801_EH0003o`0000@000060004o`00o`8000Co003o10000ol0
003o00h000?o0000100000H000Co003o0P001?l00?l400?oo`0<00?o1P0000H00ol30004o`00o`@0
00?o0000o`0>0003o`0000@000060003o`0000<000Co003o10000ol0003o00h000?o0000100000L0
0ol300;o1@000ol0003o00h000?o0000100001@00_oo00h00_l6000050000ol0003o00h000?o0000
100001@000?o0000o`0>0003o`0000@0000D0003o`0000<000?o00001`000ol000070003o`0000L0
00?o00001`000ol000070003o`0000L000?o00001`000ol000080003o`0000L000?o00001`000ol0
00070003o`0000L000?o00001`000ol000070003o`0000L000?o000020000ol000070003o`0000L0
00?o00001`000ol000070003o`0000L000?o00001`000ol000070003o`0000L000?o000020000ol0
00070004o`00o`H0000D0?oo4_l60000\
\>"],
  ImageRangeCache->{{{0, 298.062}, {145, 0}} -> {-12.9083, -7.38422, 0.494098,
   0.494098}}]
}, Closed]],

Cell[TextData[{
  "To save the definition of a symbol into a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "-executable file, we use ",
  StyleBox["Save", "Input"],
  ". Here is a list of data points."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(circledata = Table[{Cos[t], Sin[t]}, {t, 0, 1.99  \[Pi], 0.5}]\)], 
  "Input"],

Cell[BoxData[
    \({{1, 0}, {0.877582561890372758`, 0.479425538604203005`}, {
        0.540302305868139676`, 0.841470984807896549`}, {
        0.0707372016677028536`, 0.997494986604054467`}, {
        \(-0.416146836547142484`\), 0.909297426825681753`}, {
        \(-0.801143615546933851`\), 0.598472144103956438`}, {
        \(-0.989992496600445548`\), 0.141120008059867103`}, {
        \(-0.936456687290796274`\), \(-0.350783227689619936`\)}, {
        \(-0.653643620863611829`\), \(-0.756802495307928424`\)}, {
        \(-0.210795799430779506`\), \(-0.977530117665097186`\)}, {
        0.283662185463226421`, \(-0.958924274663138476`\)}, {
        0.708669774291260168`, \(-0.705540325570391679`\)}, {
        0.960170286650366122`, \(-0.279415498198925638`\)}}\)], "Output"]
}, Closed]],

Cell[TextData[{
  "Here we save the definition of ",
  StyleBox["circledata", "Input"],
  " into a file."
}], "Text"],

Cell[BoxData[
    \(Save["\<circle.dat\>", circledata]\)], "Input"],

Cell[TextData[{
  "Here are the contents of the file ",
  StyleBox["circle.dat", "Output"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(! \(! circle.dat\)\)\)], "Input"],

Cell["\<\
circledata = {{1, 0}, {0.8775825618903727, 0.479425538604203}, 
   {0.5403023058681396, 0.8414709848078965}, 
   {0.07073720166770285, 0.9974949866040544}, 
   {-0.4161468365471424, 0.9092974268256817}, 
   {-0.8011436155469338, 0.5984721441039564}, 
   {-0.9899924966004455, 0.1411200080598671}, 
   {-0.9364566872907962, -0.3507832276896199}, 
   {-0.6536436208636118, -0.7568024953079284}, 
   {-0.2107957994307795, -0.9775301176650971}, 
   {0.2836621854632264, -0.9589242746631384}, 
   {0.7086697742912601, -0.7055403255703916}, 
   {0.9601702866503661, -0.2794154981989256}}\
\>", "Print"]
}, Closed]],

Cell[TextData[{
  "The contents of the file ",
  StyleBox["circle.dat", "Output"],
  " are now executable using ",
  StyleBox["Get", "Input"],
  ". First we clear the value of the variable ",
  StyleBox["circledata", "Input"],
  "."
}], "Text"],

Cell[BoxData[
    \(Clear[circledata]\)], "Input"],

Cell[TextData[{
  "We now execute the contents of ",
  StyleBox["circle.dat", "Output"],
  ", which restores the definition of ",
  StyleBox["circledata", "Input"],
  "."
}], "Text"],

Cell[BoxData[
    \(\(Get["\<circle.dat\>"]; \)\)], "Input"],

Cell["The results are now usable in further calculations.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(ListPlot[circledata, PlotStyle -> PointSize[0.03], AspectRatio -> 1]; 
    \)\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.497605 0.478585 0.495186 0.482212 [
[.01902 .48269 -6 -9 ]
[.01902 .48269 6 0 ]
[.25831 .48269 -12 -9 ]
[.25831 .48269 12 0 ]
[.7369 .48269 -9 -9 ]
[.7369 .48269 9 0 ]
[.97619 .48269 -3 -9 ]
[.97619 .48269 3 0 ]
[.48511 .01297 -12 -4.5 ]
[.48511 .01297 0 4.5 ]
[.48511 .25408 -24 -4.5 ]
[.48511 .25408 0 4.5 ]
[.48511 .73629 -18 -4.5 ]
[.48511 .73629 0 4.5 ]
[.48511 .9774 -6 -4.5 ]
[.48511 .9774 0 4.5 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.01902 .49519 m
.01902 .50144 L
s
[(-1)] .01902 .48269 0 1 Mshowa
.25831 .49519 m
.25831 .50144 L
s
[(-0.5)] .25831 .48269 0 1 Mshowa
.7369 .49519 m
.7369 .50144 L
s
[(0.5)] .7369 .48269 0 1 Mshowa
.97619 .49519 m
.97619 .50144 L
s
[(1)] .97619 .48269 0 1 Mshowa
.125 Mabswid
.06688 .49519 m
.06688 .49894 L
s
.11474 .49519 m
.11474 .49894 L
s
.1626 .49519 m
.1626 .49894 L
s
.21045 .49519 m
.21045 .49894 L
s
.30617 .49519 m
.30617 .49894 L
s
.35403 .49519 m
.35403 .49894 L
s
.40189 .49519 m
.40189 .49894 L
s
.44975 .49519 m
.44975 .49894 L
s
.54546 .49519 m
.54546 .49894 L
s
.59332 .49519 m
.59332 .49894 L
s
.64118 .49519 m
.64118 .49894 L
s
.68904 .49519 m
.68904 .49894 L
s
.78476 .49519 m
.78476 .49894 L
s
.83261 .49519 m
.83261 .49894 L
s
.88047 .49519 m
.88047 .49894 L
s
.92833 .49519 m
.92833 .49894 L
s
.25 Mabswid
0 .49519 m
1 .49519 L
s
.49761 .01297 m
.50386 .01297 L
s
[(-1)] .48511 .01297 1 0 Mshowa
.49761 .25408 m
.50386 .25408 L
s
[(-0.5)] .48511 .25408 1 0 Mshowa
.49761 .73629 m
.50386 .73629 L
s
[(0.5)] .48511 .73629 1 0 Mshowa
.49761 .9774 m
.50386 .9774 L
s
[(1)] .48511 .9774 1 0 Mshowa
.125 Mabswid
.49761 .0612 m
.50136 .0612 L
s
.49761 .10942 m
.50136 .10942 L
s
.49761 .15764 m
.50136 .15764 L
s
.49761 .20586 m
.50136 .20586 L
s
.49761 .3023 m
.50136 .3023 L
s
.49761 .35052 m
.50136 .35052 L
s
.49761 .39874 m
.50136 .39874 L
s
.49761 .44697 m
.50136 .44697 L
s
.49761 .54341 m
.50136 .54341 L
s
.49761 .59163 m
.50136 .59163 L
s
.49761 .63985 m
.50136 .63985 L
s
.49761 .68807 m
.50136 .68807 L
s
.49761 .78451 m
.50136 .78451 L
s
.49761 .83273 m
.50136 .83273 L
s
.49761 .88096 m
.50136 .88096 L
s
.49761 .92918 m
.50136 .92918 L
s
.25 Mabswid
.49761 0 m
.49761 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
.03 w
.97619 .49519 Mdot
.9176 .72637 Mdot
.75619 .90095 Mdot
.53146 .97619 Mdot
.29844 .93366 Mdot
.11419 .78378 Mdot
.02381 .56324 Mdot
.04943 .32603 Mdot
.18478 .13025 Mdot
.39672 .02381 Mdot
.63336 .03278 Mdot
.83676 .15497 Mdot
.95713 .36045 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{299.062, 299.062},
  ImageMargins->{{48, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004[0001:`P10`4000010?ooooooc?ooZ_ooI_oo
<ooo0?o<ooo<c?o<VC/k>gYjN[Vi^OShn03ooeGooj[ooonI<onI0?mVoomVc?mVVOmVI_mV<omV0?lc
oclo?ginO[fm_Oclo5D00:X00?l00?l0VOl0I_l0<ol00<coolcoc<coVLcoIP<30d92@X61PL30`000
EED0EJX0EOl0ELbIolbIc<bIVLbII/bI<lbI0<aVolaVc0L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0Z/`c
<l`c0<`0ol`0c<`0VL`0I/`0<l`000/;2dY:BXV9RLS8b000oeD0ojX0ool0oiW<VIW<IYW<<iW<09VI
oiVIc9VIVIVIIPl?3di>CXf=SLc<c01E05EE0:YE0?mE09TcoiTcc9TcVITcIYTc<iTc09T0oiT0c1<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEEFKo<fKo06K<ofK<c6K<VFK<IVK<<fK<01LG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZVIVVFIVIVIV<fIV06HcofHcc6HcVFHcIQ/K6eYJFYVIVMSHf01EoeEEojYEoomEoc?o
oc?oc3?oVC?oIS?o<c?o03?<oc?<c1lO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ03>I<c>I03=Voc=Vc3=V
VC=VIS=V<c=V02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZEC<0VC<0IS<0<c<0003oo`3oc03oV@3oIRLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2Io`2Ic02IV@2IIP2I<`2I001Vo`1Vc2/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`0c<`0c0000o`00c000V@00IP00<nh002l_;fi^KZf][Nc/k03o05Go0:[o0?oo0140
003^003M002k002Z0028001g001E03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@00M`00E@00A0008P00
4Nk^k]gMgK^k^cLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l0;00009@000?o0000U00009@000?o0000
U00008/00ol60003o`0009@0002<0003o`0000D000?o0000U00007@01?l=00Go0P000ol0000500?o
U00007<01_lC0003o`0000D000?o0000U00007802?lB0003o`0000D000?o0000U00007802?lA00;o
1`000ol0000S00CoK@0007802?lJ0003o`0002801_m/0000LP08oaX000?o00008@08of/0001c00Ko
6`000ol0000Q00SoJ`0007@01?lL0003o`0002402?m[0000U0000ol0000Q00SoJ`0009@000?o0000
8P06of`0002D0003o`0002<01?m]0000U0000ol0002D0000U0000ol0002D0000U0000ol0002D0000
U002oiD0002D0003o`0009@0002D0003o`0009@0002D0003o`0009@0002D0003o`0009@0002D0003
o`0009@0002D0003o`0009@0002D0003o`0009@0002D0003o`0009@0002D0003o`0009@0002D0003
o`0009@0002D0003o`0009@0002D0003o`0009@0002D0003o`0009@0002D0003o`0009@0002D00;o
U@0009@000?o0000U00009@000?o0000U00003D01?mK0003o`0009@0000d00KoFP000ol0002D0000
<`08oeT000?o0000U00003<02?mI0003o`0009@0000c00SoF@000ol0002D0000<`08oeT000?o0000
U00003@01_mJ0003o`0009@0000e00CoF`000ol0001P00Co<00009@000?o0000G`06obl0002D0003
o`0005h02?l^0000U0000ol0001N00So;P0009@00_mO00So;P0009@000?o0000GP08obh0002D0003
o`0005l01_l_0000U0000ol0001P00Co<00009@000?o0000U00009@000?o0000U00009@000?o0000
U00009@000?o0000U00009@000?o0000U00009@000?o0000U00009@000?o0000U00009@000?o0000
U00009@000?o0000U00009@000?o0000U00009@00_nE0000U0000ol0002D0000U0000ol0002D0000
U0000ol0002D0000U0000ol0002D0000U0000ol0002D0000U0000ol0002D0000U0000ol0002D0000
U0000ol0002D0000U0000ol0002D0000U0000ol0002D0000U0000ol0002D0000U0000ol0002D0000
P002o`@00_l300?o1P000ol0002D0000O`001?l00?l300;o1P000ol000030003o`0009@0001i00Go
00D0o`00o`0;0003o`0000<00onD0000O`001?l00?l800?o1P000ol0002D0000O`001?l00?l80003
o`0000H000?o0000U00008000_l900Co1@000ol0002D0000U0000ol0002D0000U0000ol0002D0000
U0000ol0002D0000U0000ol0002D0000U0000ol0002D0000U0000ol0002D0000U0000ol0002D0000
U0000ol0002D0000U0000ol0002D0000U0000ol0002D0000U002oiD0002D0003o`0009@0002D0003
o`0009@0002D0003o`0009@0000=00CoP`000ol0002D00003006oh8000?o0000U00000/02?n10003
o`0009@0000;00SoP@000ol0002D00002`08oh4000?o0000U00000/02?n10003o`0009@0000<00Ko
PP000ol0002D00003@04oh<000?o0000U00009@000?o0000U00009@000?o0000U00009@00_n500Co
300009@000?o0000P`06o`/0002D0003o`0008802?l:0000U0000ol0002200So2P0009@000?o0000
PP08o`X0002D0003o`0008802?l:0000U0000ol0002300Ko2`0009@000?o0000Q004o``0002D0003
o`0009@0002D0003o`0009@0002D0003o`0009@0002D0003o`0009@0002D0003o`0009@0002D0003
o`0009@0002D0003o`0009@0002D00;oU@0009@000?o0000U00009@000?o0000U00009@000?o0000
U00009@000?o0000U00009@000?o0000U00009@000?o0000U00009@000?o0000U00009@000?o0000
U00009@000?o0000U00009@000?o0000U00009@000?o0000U00009@000?o0000U00009@000?o0000
U00009@00_nE0000U0000ol0002D0000U0000ol0002D0000U0000ol0002D00001`03ocl00_l400;o
0`03ocd000?o0000?@02o`@00_l300?o?P03o`P000080003o`0003d000Co003o0`02o`H000?o0000
>P000ol0000l0004o`00o`<00_l60003o`0003`000?o00001`0000030?oo00?o0P000ol0000g00Go
00D0o`00o`0;0003o`0003X000?o0000?0001?l00?l;0003o`0003`000?o00001`0000P000?o0000
?@001?l00?l800?o?@000ol0000l0004o`00o`P00olo0003o`0000L000080003o`0003d000Co003o
20000ol0000m0003o`0003`000Co003o20000ol0000o0003o`0000L0000700;o@002o`T01?ll0003
o`0003d00_l900Co?@02o`T0002D0003o`0009@0002D0003o`0008T01?l70000U0000ol0002800Ko
1P0009@000?o0000Q`08o`D0003oob_o0@0000H000?o00002`000ol0000;0003o`0000/000?o0000
30000ol0000;0003o`0000/000?o00002`000ol0000<0003o`0000/000?o00002`000ol0000;0003
o`0000/000?o000030000ol0000;0003o`0000/000?o00002`000ol0000<0003o`0000/000?o0000
2`000ol0000700So1@0000H000?o0000A0000ol000140003o`0004@000?o0000@008o`D0002D0003
o`0008P01_l60000U0000ol0002900Co1`0009@000?o0000U00009@000?o0000U00009@000?o0000
U00009@000?o0000U00009@000?o0000U00009@000?o0000U00009@000?o0000U00009@000?o0000
U00009@000?o0000U00009@000?o0000U00009@00_nE0000U0000ol0002D0000U0000ol0002D0000
1@04oh/000?o0000U00000@01_n:0003o`0009@0000300SoR@000ol0002D00000`08ohT000?o0000
U00000<02?n90003o`0009@0000300SoR@000ol0002D00001006ohX000?o0000U00000D01?n;0003
o`0009@0002D0003o`0009@0002D0003o`0009@0002D0003o`0009@0002D00;oU@0009@000?o0000
U00009@000?o0000U00009@000?o0000U00009@000?o0000U00009@000?o0000U00009@000?o0000
U00009@000?o0000U00009@000?o0000U00009@000?o0000U00009@000?o0000U00009@000?o0000
U00009@000?o0000U00009@000?o0000U00009@00_nE0000U0000ol0002D0000U0000ol0002D0000
U0000ol0002D0000U0000ol0002D0000U0000ol0002D0000U0000ol0002D0000U0000ol0002D0000
U0000ol0002D0000U0000ol0002D0000U0000ol0002D0000U0000ol0002D0000U0000ol0002D0000
U0000ol0002D0000U0000ol0002D0000U002oiD0002D0003o`0009@0002D0003o`0009@0002D0003
o`0009@0002D0003o`0009@0002D0003o`0009@0002D0003o`0009@0002D0003o`0009@0002D0003
o`0007P01?lH0000U0000ol0001g00Ko5`0009@000?o0000MP08oaH0002D0003o`0007H02?lF0000
P002o`@00_l300?o1P000ol0001f00So5P0007l000Co003o0`02o`H000?o00000`000ol0001f00So
5P0007l000Co003o2`000ol0000300?oM`06oaL0001o0004o`00o`P00ol60003o`0007P01?lH0000
O`001?l00?l80003o`0000H000?o0000U00008000_l900Co1@000ol0002D0000U0000ol0002D0000
U0000ol0002D0000U0000ol0002D0000U0000ol0002D0000U0000ol0002D0000U0000ol0002D0000
U0000ol0002D00008004og0000?o0000U00001l01_m_0003o`0009@0000N00SoKP000ol0002D0000
7P08ofh00_nE00007P08ofh000?o0000U00001h02?m^0003o`0009@0000O00KoK`000ol0002D0000
8004og0000?o0000U00009@000?o0000U00009@000?o0000U00009@000?o0000U00009@000?o0000
U00009@000?o0000U00009@000?o0000U00009@000?o0000U00009@000?o0000U00009@000?o0000
U00009@000?o0000U00009@00_nE0000U0000ol0002D0000U0000ol0002D0000U0000ol0002D0000
U0000ol0002D0000U0000ol0002D0000U0000ol0002D0000U0000ol0002D0000U0000ol0002D0000
U0000ol0002D0000U0000ol0002D0000U0000ol0002D0000U0000ol0002D0000U0000ol0002D0000
U002oiD0002D0003o`0009@0002D0003o`0009@0002D0003o`0004P01?m80000U0000ol0001700Ko
A`0009@000?o0000AP08odH0002D0003o`0004H02?m60000U0000ol0001600SoAP0009@000?o0000
AP08odH0002D0003o`0004L01_m70000U0000ol0001800CoB00009@000?o0000U00009@000?o0000
U00005L01?li0003o`0009@0001F00Ko>002oiD0001E00So=`000ol0002D0000E@08ocL000?o0000
U00005D02?lg0003o`0009@0001E00So=`000ol0002D0000EP06ocP000?o0000U00005L01?li0003
o`0009@0002D0003o`0009@0002D0003o`0009@0002D0003o`0009@0002D0003o`0009@0002D0003
o`0000D01?n;0000U0000ol0000400KoRP0008/00ol60003o`0000<02?n90000S0000ol000050003
o`0000<02?n90000S0000ol0000500?o0`08ohT0002<0003o`0000D000?o00000`08ohT0002<0003
o`0000D000?o00001006ohX0002;00;o1`000ol0000500CoR`0009@000?o0000U00009@000?o0000
U00009@000?o0000U0000001\
\>"],
  ImageRangeCache->{{{0, 298.062}, {298.062, 0}} -> {-1.04321, -1.0314, 
  0.00702546, 0.00697262}}]
}, Closed]],

Cell[TextData[{
  "The function ",
  StyleBox["DumpSave", "Input"],
  " works indentically to ",
  StyleBox["Save", "Input"],
  ", except that the files are saved in a machine-specific binary format \
which loads faster than files created by ",
  StyleBox["Save", "Input"],
  ". Here we save the data contained in the variable ",
  StyleBox["eye", "Input"],
  " in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "\[CloseCurlyQuote]s binary format. (By convention, files created by ",
  StyleBox["DumpSave", "Input"],
  " have the filename extension ",
  StyleBox[".mx", "Output"],
  ".)"
}], "Text"],

Cell[BoxData[
    \(\(DumpSave["\<eye.mx\>", eye]; \)\)], "Input"],

Cell[TextData[{
  "To load the definition of ",
  StyleBox["eye", "Input"],
  " contained in the binary file, we use ",
  StyleBox["Get", "Input"],
  ". Note that files created by ",
  StyleBox["DumpSave", "Input"],
  " are not compatible among different types of computers."
}], "Text"],

Cell[BoxData[
    \(Clear[eye]\)], "Input"],

Cell[TextData[{
  "See also ",
  StyleBox["Splice", "Input"],
  ", ",
  StyleBox["Encode", "Input"],
  ", ",
  StyleBox["Display", "Input"],
  " "
}], "SeeAlso"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["2. Lists", "Section",
  Evaluatable->False,
  CellTags->"Lists"],

Cell[CellGroupData[{

Cell["Creating and Interpreting Lists", "Subsection",
  CellTags->"Creating and Interpreting Lists"],

Cell[TextData[{
  "The basic data structure in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " is the ",
  StyleBox["list",
    FontSlant->"Italic"],
  ". The elements of a list can be any combination of numbers, variables, \
strings, functions, and other lists; enclosed within curly brackets ",
  Cell[BoxData[
      \({}\)], "Input"],
  " and separated by commas."
}], "Text"],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " lists often have natural interpretations as vectors, matrices, or \
tensors, depending on how deeply they are nested. A one-dimensional list acts \
as a vector, a two-dimensional list as a matrix, and higher-dimensional lists \
as tensors."
}], "Text"],

Cell[TextData[{
  "One way to enter an arbitrary list is to type a sequence of elements \
inside curly brackets and separated by commas. The following one-dimensional \
list ",
  StyleBox["vec",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " can be considered a vector with the three components ",
  StyleBox["a",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  ", ",
  StyleBox["b",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  ", and ",
  StyleBox["c",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  "."
}], "Text"],

Cell[BoxData[
    \(\(vec = {a, b, c}; \)\)], "Input"],

Cell[TextData[{
  "An easier way to create a vector of evenly spaced numbers is to use ",
  StyleBox["Range",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  ". ",
  StyleBox["Range[",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  StyleBox["max",
    FontSlant->"Italic"],
  StyleBox["]",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " creates a list of integers from 1 through ",
  StyleBox["max",
    FontSlant->"Italic"],
  "; ",
  StyleBox["Range[",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  StyleBox["min",
    FontSlant->"Italic"],
  StyleBox[",",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " ",
  StyleBox["max",
    FontSlant->"Italic"],
  StyleBox["]",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " creates a list of numbers from ",
  StyleBox["min",
    FontSlant->"Italic"],
  " through ",
  StyleBox["max",
    FontSlant->"Italic"],
  " in increments of 1; and ",
  StyleBox["Range[",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  StyleBox["min",
    FontSlant->"Italic"],
  StyleBox[",",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " ",
  StyleBox["max",
    FontSlant->"Italic"],
  StyleBox[",",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " ",
  StyleBox["inc",
    FontSlant->"Italic"],
  StyleBox["]",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " returns a list of numbers ranging from ",
  StyleBox["min",
    FontSlant->"Italic"],
  " through ",
  StyleBox["max",
    FontSlant->"Italic"],
  " with increment ",
  StyleBox["inc",
    FontSlant->"Italic"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(vec2 = Range[2, 5, 1/2]\)], "Input"],

Cell[BoxData[
    \({2, 5\/2, 3, 7\/2, 4, 9\/2, 5}\)], "Output"]
}, Closed]],

Cell[TextData[{
  "A more general function for creating lists is ",
  StyleBox["Table",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  ", which generates lists (nested to any depth) of elements that may depend \
on the given iterators. For example, to generate a list of values of ",
  Cell[BoxData[
      \(TraditionalForm\`k\^2\)]],
  " as ",
  StyleBox["k",
    FontSlant->"Italic"],
  " takes on values from 1 to 10, we evaluate the following."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Table[k\^2, {k, 1, 10}]\)], "Input"],

Cell[BoxData[
    \({1, 4, 9, 16, 25, 36, 49, 64, 81, 100}\)], "Output"]
}, Closed]],

Cell["\<\
We create tables of more complicated functions in a similar \
way.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(vec3 = 
      Table[N[Exp[\[Pi]\ \[ImaginaryI]\ t]], {t, 0, 2\ \[Pi], \[Pi]/4}]\)], 
  "Input"],

Cell[BoxData[
    \({1.`, \(-0.781211892110488115`\) + 0.624265952639699062`\ I, 
      \(0.220584040749697951`\ \) - 0.975367972083631507`\ I, 
      \(0.436566140423590987`\ \) + 0.899672165311147864`\ I, 
      \(-0.902685361933071206`\) - 0.430301217000092073`\ I, 
      \(0.9738109387287599`\ \) - 0.227359309490971694`\ I, 
      \(-0.618820010071298831`\) + 0.785532809712845558`\ I, 
      \(-0.00695183684149917446`\) - 0.99997583569030759`\ I, 
      \(0.629681725296479388`\ \) + 0.77685321961593825`\ I}\)], "Output"]
}, Closed]],

Cell[TextData[{
  "Many mathematical and plotting functions are designed to operate on lists. \
Here is a plot of the real part of each element of ",
  StyleBox["vec3",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(ListPlot[Re[vec3], PlotStyle \[Rule] PointSize[0.03]]; \)\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0952381 0.119048 0.293965 0.309354 [
[.38095 .28146 -3 -9 ]
[.38095 .28146 3 0 ]
[.61905 .28146 -3 -9 ]
[.61905 .28146 3 0 ]
[.85714 .28146 -3 -9 ]
[.85714 .28146 3 0 ]
[.13036 .06195 -30 -4.5 ]
[.13036 .06195 0 4.5 ]
[.13036 .13929 -24 -4.5 ]
[.13036 .13929 0 4.5 ]
[.13036 .21663 -30 -4.5 ]
[.13036 .21663 0 4.5 ]
[.13036 .3713 -24 -4.5 ]
[.13036 .3713 0 4.5 ]
[.13036 .44864 -18 -4.5 ]
[.13036 .44864 0 4.5 ]
[.13036 .52598 -24 -4.5 ]
[.13036 .52598 0 4.5 ]
[.13036 .60332 -6 -4.5 ]
[.13036 .60332 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.38095 .29396 m
.38095 .30021 L
s
[(4)] .38095 .28146 0 1 Mshowa
.61905 .29396 m
.61905 .30021 L
s
[(6)] .61905 .28146 0 1 Mshowa
.85714 .29396 m
.85714 .30021 L
s
[(8)] .85714 .28146 0 1 Mshowa
.125 Mabswid
.20238 .29396 m
.20238 .29771 L
s
.2619 .29396 m
.2619 .29771 L
s
.32143 .29396 m
.32143 .29771 L
s
.44048 .29396 m
.44048 .29771 L
s
.5 .29396 m
.5 .29771 L
s
.55952 .29396 m
.55952 .29771 L
s
.67857 .29396 m
.67857 .29771 L
s
.7381 .29396 m
.7381 .29771 L
s
.79762 .29396 m
.79762 .29771 L
s
.08333 .29396 m
.08333 .29771 L
s
.02381 .29396 m
.02381 .29771 L
s
.91667 .29396 m
.91667 .29771 L
s
.97619 .29396 m
.97619 .29771 L
s
.25 Mabswid
0 .29396 m
1 .29396 L
s
.14286 .06195 m
.14911 .06195 L
s
[(-0.75)] .13036 .06195 1 0 Mshowa
.14286 .13929 m
.14911 .13929 L
s
[(-0.5)] .13036 .13929 1 0 Mshowa
.14286 .21663 m
.14911 .21663 L
s
[(-0.25)] .13036 .21663 1 0 Mshowa
.14286 .3713 m
.14911 .3713 L
s
[(0.25)] .13036 .3713 1 0 Mshowa
.14286 .44864 m
.14911 .44864 L
s
[(0.5)] .13036 .44864 1 0 Mshowa
.14286 .52598 m
.14911 .52598 L
s
[(0.75)] .13036 .52598 1 0 Mshowa
.14286 .60332 m
.14911 .60332 L
s
[(1)] .13036 .60332 1 0 Mshowa
.125 Mabswid
.14286 .07742 m
.14661 .07742 L
s
.14286 .09288 m
.14661 .09288 L
s
.14286 .10835 m
.14661 .10835 L
s
.14286 .12382 m
.14661 .12382 L
s
.14286 .15476 m
.14661 .15476 L
s
.14286 .17022 m
.14661 .17022 L
s
.14286 .18569 m
.14661 .18569 L
s
.14286 .20116 m
.14661 .20116 L
s
.14286 .23209 m
.14661 .23209 L
s
.14286 .24756 m
.14661 .24756 L
s
.14286 .26303 m
.14661 .26303 L
s
.14286 .2785 m
.14661 .2785 L
s
.14286 .30943 m
.14661 .30943 L
s
.14286 .3249 m
.14661 .3249 L
s
.14286 .34037 m
.14661 .34037 L
s
.14286 .35584 m
.14661 .35584 L
s
.14286 .38677 m
.14661 .38677 L
s
.14286 .40224 m
.14661 .40224 L
s
.14286 .41771 m
.14661 .41771 L
s
.14286 .43317 m
.14661 .43317 L
s
.14286 .46411 m
.14661 .46411 L
s
.14286 .47958 m
.14661 .47958 L
s
.14286 .49504 m
.14661 .49504 L
s
.14286 .51051 m
.14661 .51051 L
s
.14286 .54145 m
.14661 .54145 L
s
.14286 .55692 m
.14661 .55692 L
s
.14286 .57238 m
.14661 .57238 L
s
.14286 .58785 m
.14661 .58785 L
s
.14286 .04648 m
.14661 .04648 L
s
.14286 .03101 m
.14661 .03101 L
s
.14286 .01555 m
.14661 .01555 L
s
.14286 8e-05 m
.14661 8e-05 L
s
.25 Mabswid
.14286 0 m
.14286 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.03 w
.02381 .60332 Mdot
.14286 .05229 Mdot
.2619 .3622 Mdot
.38095 .42902 Mdot
.5 .01472 Mdot
.61905 .59522 Mdot
.7381 .10253 Mdot
.85714 .29181 Mdot
.97619 .48876 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  Evaluatable->False,
  AspectRatioFixed->True,
  ImageSize->{299.062, 184.5},
  ImageMargins->{{48, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004[0000^0P10`4000010?ooooooc?ooZ_ooI_oo
<ooo0?o<ooo<c?o<VC/k>gYjN[Vi^OShn03ooeGooj[ooonI<onI0?mVoomVc?mVVOmVI_mV<omV0?lc
oclo?ginO[fm_Oclo5D00:X00?l00?l0VOl0I_l0<ol00<coolcoc<coVLcoIP<30d92@X61PL30`000
EED0EJX0EOl0ELbIolbIc<bIVLbII/bI<lbI0<aVolaVc0L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0Z/`c
<l`c0<`0ol`0c<`0VL`0I/`0<l`000/;2dY:BXV9RLS8b000oeD0ojX0ool0oiW<VIW<IYW<<iW<09VI
oiVIc9VIVIVIIPl?3di>CXf=SLc<c01E05EE0:YE0?mE09TcoiTcc9TcVITcIYTc<iTc09T0oiT0c1<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEEFKo<fKo06K<ofK<c6K<VFK<IVK<<fK<01LG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZVIVVFIVIVIV<fIV06HcofHcc6HcVFHcIQ/K6eYJFYVIVMSHf01EoeEEojYEoomEoc?o
oc?oc3?oVC?oIS?o<c?o03?<oc?<c1lO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ03>I<c>I03=Voc=Vc3=V
VC=VIS=V<c=V02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZEC<0VC<0IS<0<c<0003oo`3oc03oV@3oIRLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2Io`2Ic02IV@2IIP2I<`2I001Vo`1Vc2/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`0c<`0c0000o`00c000V@00IP00<nh002l_;fi^KZf][Nc/k03o05Go0:[o0?oo0140
003^003M002k002Z0028001g001E03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@00M`00E@00A0008P00
4Nk^k]gMgK^k^cLg=gIfM[Fe]OCdm03oZUGoZZ[oZP0002/00_on0000:`000ol0001U00CoU00002/0
00?o0000I006oi<0000[0003o`0006<02?nB0000:`000ol0001S00SoTP0002/00_mT00SoTP0002/0
00?o0000H`08oi80000[0003o`0006@01_nC0000:`000ol0001U00CoU00002/00_on0000:`000ol0
003m0000:`000ol0003m0000:@04ooh0000X00Koo@0002L02?ol00009`08oo`0000A00;o1002o`@0
00?o00000P03o`802?ol000040001?l00?l300;o10000ol000050003o`3o00Ooo00000X01Ol01@3o
003o00X000?o000010000ol00006ood0000@0004o`00o`X000Co00000ol400CooP00010000Co003o
2`001?l00?l80003o`000?d0000A00;o2@04o`801?l50003o`000?d0000[0003o`000?d0000[00;o
oP0002/000?o0000o@0002/000?o0000o@0002/000?o0000o@0002/000?o0000Z`04odh0000[00;o
Z`06odd0000[0003o`000:T02?m<0000:`000ol0002Y00SoC00002/000?o0000Z@08od`0000[00;o
ZP08od`0000[0003o`000:X01_m=0000:`000ol0002[00CoCP0002/000?o0000o@0002/000?o0000
o@0002/00_on0000:`000ol0003m00005`02o`@00_l300?o1P000ol0003m00005P001?l00?l300;o
1P000ol000030003o`000?d0000@00Go00D0o`00o`0;0003o`0000<00_on00005P001?l00?l800?o
1P000ol0003m00005P001?l00?l80003o`0000H000?o0000o@0001L00_l900Co1@000ol0003m0000
:`000ol0003m0000:`02ooh0000[0003o`000?d0000[0003o`000?d0000[0003o`000?d0000[0003
o`000?d0000[00;ooP0002/000?o0000o@0002/000?o0000o@0002/000?o0000o@0002/00_on0000
:`000ol0003m0000:`000ol0003m0000:`000ol0003m0000:`000ol0003m0000:`02ooh0000[0003
o`000?d0000A00;o1002o`<01?l200?o1P000ol0003m000040001?l00?l300;o10000ol000050003
o`0000<000?o0000o@0000X01Ol01@3o003o00X000?o000010000ol0000300;ooP00010000Co003o
2`000ol00003o`H000?o0000o@00010000Co003o20001?l00?l20003o`0000H000?o0000o@000140
0_l:00;o0`04o`D000?o0000o@0002/000?o0000o@0002/00_on0000:`000ol0003m0000:`000ol0
003m0000:`000ol0003m0000:`02ooh0000[0003o`000?d0000[0003o`000?d0000[0003o`000?d0
000[0003o`0004800om400;oA002ob`0000[00;oA0000ol000120004o`00od8000Co003o:`0002/0
00?o0000@@04od<000Co003o@P001?l00?l[0000:`000ol000110003o`3o04@00om400;o;00002/0
00?o0000@@000ol0o`140003o`0004<000Co003o:`0002/000?o0000@P02odD00om300;o;00002/0
0_on0000:`000ol0003?00Co:P0002/000?o0000cP06obT0000[0003o`000<d02?lX0000ool[o`40
00070003o`0000l000?o00003`000ol0000>0003o`0000l000?o00003`000ol0000>0003o`0000l0
00?o00003`000ol0000>0003o`0000l000?o00003`000ol0000>0003o`0000l000?o00002`08o`d0
00?o00003`000ol000060000:`000ol000130003o`0004@000?o0000@008obP0000[0003o`000<h0
1_lY0000:`000ol0003?00Co:P0002/00_on0000:`000ol0003m0000:`000ol0003m0000:`000ol0
003m0000:`02ooh0000[0003o`000?d0000[0003o`000?d0000[0003o`000?d0000[0003o`000?d0
000[00;ooP0002/000?o0000o@0002/000?o0000o@0002/000?o00007P04om/0000[0003o`0001d0
1_oJ0000:`02oad02?oI0000:`000ol0000L00Sof@0001400_l400;o0`04o`800ol60003o`0001`0
2?oI000040001?l00?l300;o10000ol000050003o`0000<000?o00007008omT0000@0004o`00o`X0
00?o000010000ol0000300;o7P06omX0000@0004o`00o`/000?o00000ol60003o`0001h01?oK0000
40001?l00?l80004o`00o`8000?o00001P000ol0003m00004@02o`X00_l300Co1@000ol0003m0000
:`000ol0003m0000:`02ooh0000[0003o`000?d0000[0003o`000?d0000[0003o`000?d0000[00;o
oP0002/000?o0000o@0002/000?o0000o@0002/000?o0000o@0002/000?o0000o@0002/00_m200Co
^00002/000?o0000@006okL0000[0003o`0003l02?nf0000:`000ol0000o00So]P0002/000?o0000
?`08okH0000[00;o@008okH0000[0003o`0004001_ng00005`02o`@00_l300?o1P000ol0001100Co
^00001H000Co003o0`02o`H000?o00000`000ol0003m00005P001?l00?l;0003o`0000<00_on0000
5P001?l00?l800?o1P000ol0003m00005P001?l00?l80003o`0000H000?o0000o@0001L00_l900Co
1@000ol0003m0000:`000ol0003m0000:`02ooh0000[0003o`000?d0000[0003o`000?d0000[0003
o`000?d0000[00;ol`04o`L0000[0003o`000?401_l60000:`000ol0003`00So1@0002/000?o0000
l008o`D0000[0003o`000?002?l50000:`02oo402?l50000:`000ol0003a00Ko1P0002/000?o0000
lP04o`L0000[0003o`000?d0000[00;ooP0002/000?o0000o@0002/000?o0000o@0001400_l400;o
10000ol0000200?o1P000ol0003m000040001?l00?l300;o10000ol000050003o`0000<000?o0000
o@00010000Co003o2P000ol000040003o`0000<00_on000040001?l00?l:0004o`0000?o1P000ol0
003m000040001?l00?l;0004o`00o`P000?o0000o@0001400_l900Co0P04o`D000?o0000o@0002/0
00?o0000o@0002/00_on0000:`000ol0003m0000:`000ol0003m0000:`000ol0003m0000:`02ooh0
000[0003o`000?d0000[0003o`000?d0000[0003o`000?d0000[0003o`000?d0000[00;ooP0002/0
00?o0000o@0002/000?o0000o@0002/000?o0000o@0002/00_n900CoL@0002/000?o0000Q`06og00
000500Co8P000ol0002600SoK`0000@01_lH00?o1P000ol0002600SoK`0000<02?lH0003o`0000D0
00?o0000QP08ofl0000300So60000ol0000500;oQ`08ofl0000300So60000ol000050003o`0008L0
1_m`00000`08oaP000?o00001@000ol0002800CoL@0000@01_lH00;o1`000ol0003m00001@04ob80
00?o0000o@000001\
\>"],
  ImageRangeCache->{{{0, 298.062}, {183.5, 0}} -> {0.780549, -0.950264, 
  0.0283124, 0.0108954}}]
}, Closed]],

Cell[TextData[{
  StyleBox["Fourier", "Input"],
  " expects a list of values."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Fourier[vec3]\)], "Input"],

Cell[BoxData[
    \({\(0.316991248080723675`\ \) + 0.151106604338209322`\ I, 
      \(0.329906194774448291`\ \) + 0.0316889345652492115`\ I, 
      \(0.342934173722130619`\ \) - 0.0887738845758725503`\ I, 
      \(0.360113551771476014`\ \) - 0.247622491810036882`\ I, 
      \(0.392940169059660604`\ \) - 0.551152830420623995`\ I, 
      \(0.546740700191440609`\ \) - 1.97326485868979908`\ I, 
      \(0.140641330500092553`\ \) + 1.78172086249582068`\ I, 
      \(0.269432989470029626`\ \) + 0.590852625474219372`\ I, 
      \(0.300299642429998048`\ \) + 0.305445038622834008`\ I}\)], "Output"]
}, Closed]],

Cell["\<\
We generate two-dimensional tables by including two iterators.\
\>",
   "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(rect = Table[i\/j, {i, 1, 5}, {j, 1, 2}]\)], "Input"],

Cell[BoxData[
    \({{1, 1\/2}, {2, 1}, {3, 3\/2}, {4, 2}, {5, 5\/2}}\)], "Output"]
}, Closed]],

Cell[TextData[{
  "It may be useful to use ",
  StyleBox["TableForm",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " to display multidimensional lists."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(TableForm[rect]\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {"1", \(1\/2\)},
          {"2", "1"},
          {"3", \(3\/2\)},
          {"4", "2"},
          {"5", \(5\/2\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Closed]],

Cell[TextData[{
  "The options ",
  StyleBox["TableAlignments", "Input",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  ", ",
  StyleBox["TableSpacing", "Input",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  ", and ",
  StyleBox["TableHeadings", "Input",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " allow us to customize the appearance of a table."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(TableForm[rect, TableAlignments \[Rule] {Center, Center}, 
      TableSpacing \[Rule] {1, 10}, 
      TableHeadings 
        \[Rule] {
          None, {StyleForm["\<before\>", FontSize \[Rule] 9], 
            StyleForm["\<after\>", FontSize \[Rule] 9]}}]\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {
            TagBox[
              StyleBox[\("before"\),
                FontSize->9],
              (StyleForm[ #, FontSize -> 9]&)], 
            TagBox[
              StyleBox[\("after"\),
                FontSize->9],
              (StyleForm[ #, FontSize -> 9]&)]},
          {"1", \(1\/2\)},
          {"2", "1"},
          {"3", \(3\/2\)},
          {"4", "2"},
          {"5", \(5\/2\)}
          },
        RowSpacings->1,
        ColumnSpacings->10,
        RowAlignments->Center,
        ColumnAlignments->{Center}],
      (TableForm[
       #, TableAlignments -> {Center, Center}, TableSpacing -> {1, 10}, 
        TableHeadings -> {None, {
        StyleForm[ "before", FontSize -> 9], 
        StyleForm[ "after", FontSize -> 9]}}]&)]], "Output"]
}, Closed]],

Cell[TextData[{
  "How we interpret an array such as ",
  StyleBox["rect", "Input",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " depends on the context in which it arises: in some cases it may be \
considered a 5 \[Times] 2 matrix, in others a list of five ordered pairs. \
Here we interpret ",
  StyleBox["rect", "Input",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " as a matrix, and matrix-multiply it by its transpose using ",
  StyleBox["Dot", "Input",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " (",
  StyleBox[".", "Input",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  ")."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(rect.Transpose[rect] // MatrixForm\)], "Input"],

Cell[BoxData[
    TagBox[
      RowBox[{"(", GridBox[{
            {\(5\/4\), \(5\/2\), \(15\/4\), "5", \(25\/4\)},
            {\(5\/2\), "5", \(15\/2\), "10", \(25\/2\)},
            {\(15\/4\), \(15\/2\), \(45\/4\), "15", \(75\/4\)},
            {"5", "10", "15", "20", "25"},
            {\(25\/4\), \(25\/2\), \(75\/4\), "25", \(125\/4\)}
            }], ")"}],
      (MatrixForm[ #]&)]], "Output"]
}, Closed]],

Cell[TextData[{
  "Here we interpret ",
  StyleBox["rect",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " as a list of ordered pairs to be plotted."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(ListPlot[rect, PlotStyle \[Rule] PointSize[0.02]]; \)\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.214286 0.238095 -0.132436 0.294302 [
[.2619 .14937 -3 -9 ]
[.2619 .14937 3 0 ]
[.5 .14937 -3 -9 ]
[.5 .14937 3 0 ]
[.7381 .14937 -3 -9 ]
[.7381 .14937 3 0 ]
[.97619 .14937 -3 -9 ]
[.97619 .14937 3 0 ]
[.01131 .01472 -18 -4.5 ]
[.01131 .01472 0 4.5 ]
[.01131 .30902 -18 -4.5 ]
[.01131 .30902 0 4.5 ]
[.01131 .45617 -6 -4.5 ]
[.01131 .45617 0 4.5 ]
[.01131 .60332 -18 -4.5 ]
[.01131 .60332 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.2619 .16187 m
.2619 .16812 L
s
[(2)] .2619 .14937 0 1 Mshowa
.5 .16187 m
.5 .16812 L
s
[(3)] .5 .14937 0 1 Mshowa
.7381 .16187 m
.7381 .16812 L
s
[(4)] .7381 .14937 0 1 Mshowa
.97619 .16187 m
.97619 .16812 L
s
[(5)] .97619 .14937 0 1 Mshowa
.125 Mabswid
.07143 .16187 m
.07143 .16562 L
s
.11905 .16187 m
.11905 .16562 L
s
.16667 .16187 m
.16667 .16562 L
s
.21429 .16187 m
.21429 .16562 L
s
.30952 .16187 m
.30952 .16562 L
s
.35714 .16187 m
.35714 .16562 L
s
.40476 .16187 m
.40476 .16562 L
s
.45238 .16187 m
.45238 .16562 L
s
.54762 .16187 m
.54762 .16562 L
s
.59524 .16187 m
.59524 .16562 L
s
.64286 .16187 m
.64286 .16562 L
s
.69048 .16187 m
.69048 .16562 L
s
.78571 .16187 m
.78571 .16562 L
s
.83333 .16187 m
.83333 .16562 L
s
.88095 .16187 m
.88095 .16562 L
s
.92857 .16187 m
.92857 .16562 L
s
.25 Mabswid
0 .16187 m
1 .16187 L
s
.02381 .01472 m
.03006 .01472 L
s
[(0.5)] .01131 .01472 1 0 Mshowa
.02381 .30902 m
.03006 .30902 L
s
[(1.5)] .01131 .30902 1 0 Mshowa
.02381 .45617 m
.03006 .45617 L
s
[(2)] .01131 .45617 1 0 Mshowa
.02381 .60332 m
.03006 .60332 L
s
[(2.5)] .01131 .60332 1 0 Mshowa
.125 Mabswid
.02381 .04415 m
.02756 .04415 L
s
.02381 .07358 m
.02756 .07358 L
s
.02381 .10301 m
.02756 .10301 L
s
.02381 .13244 m
.02756 .13244 L
s
.02381 .1913 m
.02756 .1913 L
s
.02381 .22073 m
.02756 .22073 L
s
.02381 .25016 m
.02756 .25016 L
s
.02381 .27959 m
.02756 .27959 L
s
.02381 .33845 m
.02756 .33845 L
s
.02381 .36788 m
.02756 .36788 L
s
.02381 .39731 m
.02756 .39731 L
s
.02381 .42674 m
.02756 .42674 L
s
.02381 .4856 m
.02756 .4856 L
s
.02381 .51503 m
.02756 .51503 L
s
.02381 .54446 m
.02756 .54446 L
s
.02381 .57389 m
.02756 .57389 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.02 w
.02381 .01472 Mdot
.2619 .16187 Mdot
.5 .30902 Mdot
.7381 .45617 Mdot
.97619 .60332 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  Evaluatable->False,
  AspectRatioFixed->True,
  ImageSize->{299.062, 184.5},
  ImageMargins->{{48, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004[0000^0P10`4000010?ooooooc?ooZ_ooI_oo
<ooo0?o<ooo<c?o<VC/k>gYjN[Vi^OShn03ooeGooj[ooonI<onI0?mVoomVc?mVVOmVI_mV<omV0?lc
oclo?ginO[fm_Oclo5D00:X00?l00?l0VOl0I_l0<ol00<coolcoc<coVLcoIP<30d92@X61PL30`000
EED0EJX0EOl0ELbIolbIc<bIVLbII/bI<lbI0<aVolaVc0L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0Z/`c
<l`c0<`0ol`0c<`0VL`0I/`0<l`000/;2dY:BXV9RLS8b000oeD0ojX0ool0oiW<VIW<IYW<<iW<09VI
oiVIc9VIVIVIIPl?3di>CXf=SLc<c01E05EE0:YE0?mE09TcoiTcc9TcVITcIYTc<iTc09T0oiT0c1<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEEFKo<fKo06K<ofK<c6K<VFK<IVK<<fK<01LG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZVIVVFIVIVIV<fIV06HcofHcc6HcVFHcIQ/K6eYJFYVIVMSHf01EoeEEojYEoomEoc?o
oc?oc3?oVC?oIS?o<c?o03?<oc?<c1lO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ03>I<c>I03=Voc=Vc3=V
VC=VIS=V<c=V02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZEC<0VC<0IS<0<c<0003oo`3oc03oV@3oIRLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2Io`2Ic02IV@2IIP2I<`2I001Vo`1Vc2/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`0c<`0c0000o`00c000V@00IP00<nh002l_;fi^KZf][Nc/k03o05Go0:[o0?oo0140
003^003M002k002Z0028001g001E03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@00M`00E@00A0008P00
4Nk^k]gMgK^k^cLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l0;0000?l0;0000?l0;0000?l0;00001D0
00?o0000o`0D00005@000ol0003o01@0000200;o1002o`<00ol50003o`000?l0500000050?l00?l0
0`02o`H000Co00000ooo01D000001@3o003o00/000?o00001Ooo01@000001@3o003o00P00ol300Go
o`0D000000D0o`00o`080003o`0000<01Ooo01@0000200;o2@04o`<00ooo01D0000E0003o`000?l0
500001D000?o0000o`0D00005@000ol0003o01@0000E0003o`000?l0500001D000?o0000o`0D0000
5@02ool05@0001D000?o0000o`0D00005@000ol0003o01@0000E0003o`000?l0500001D000?o0000
o`0D00005@000ol0003o01@0000E0003o`000?l0500001D000?o0000o`0D00005@02ool05@0001D0
00?o0000o`0D00005@000ol0003o01@0000E0003o`000?l0500001D000?o0000o`0D00005@000ol0
003o01@0000E0003o`000?l0500001D000?o0000o`0D00005@02ool05@0001D000?o0000o`0D0000
5@000ol0003o01@0000E0003o`000?l0500001D000?o0000o`0D00005@000ol0003o01@0000E0003
o`000?l0500001D000?o0000?P04od000om100?o@003o`L0000E0003o`0003l000?o0000@`000ol0
000o0003o`00048000?o0000100001D00_m10003o`00048000?o0000?@04od<000?o0000100001D0
00?o0000@@000ol0000o00;o@0000ol0o`1100?o1`0001D000?o0000?P001?l00?m30003o`0003d0
00?o0?l0@@000ol0000700005@000ol0000o00;o@@03od400_m100Co1P0001D000?o0000o`0D0000
5@000ol0003o01@0000E0003o`0003l00ooA00005@000ol0000n00God00000h0oolNo`005@000ol0
000;0003o`0000X000?o00002`000ol0000:0003o`0000P01Ol;0003o`0000X000?o00002`000ol0
000:0003o`0000/000?o00002P000ol0000;0003o`0000X000?o00002`000ol0000:0003o`0000/0
00?o00002P000ol0000;0003o`0000X000?o00002`000ol0000500005@000ol0000o00?o@P000ol0
00100003o`00044000?o00001@0001D000?o0000o`0D00005@000ol0003o01@0000E0003o`000?l0
500001D000?o0000o`0D00005@000ol0003o01@0000E00;oo`0E00005@000ol0003o01@0000E0003
o`000?l0500001D000?o0000o`0D00005@000ol0003o01@0000E0003o`000?l0500001D000?o0000
o`0D00005@000ol0003o01@0000E0003o`000?l0500001D00_oo01D0000E0003o`000?l0500001D0
00?o0000o`0D00005@000ol0003o01@0000E0003o`000?l0500001D000?o0000o`0D00005@000ol0
003o01@0000E0003o`000?l0500001D00_oo01D0000E0003o`000?l0500001D000?o0000o`0D0000
5@000ol0003o01@0000E0003o`000?l0500001D000?o0000o`0D00005@000ol0003o01@0000E0003
o`000?l0500001D00_oo01D0000E0003o`000?l0500001D000?o0000o`0D00005@000ol0003o01@0
000E0003o`000?l0500001D000?o0000o`0D00005@000ol0003o01@00000103oool400;o0`03o`D0
00?o0000P`03ohd000020003o`0000<00_l60003o`00008000?o0000PP05oh`000020003o`0000/0
00?o00000P03oh801On<00000P000ol0000800?o1@000ol0002200GoS000008000?o000020000ol0
00050003o`0008<00on=000000<0ool02P04o`@000?o0000o`0D00005@000ol0003o01@0000E0003
o`000?l0500001D000?o0000o`0D00005@000ol0003o01@0000E00;oo`0E00005@000ol0003o01@0
000E0003o`000?l0500001D000?o0000o`0D00005@000ol0003o01@0000E0003o`000?l0500001D0
00?o0000o`0D00005@000ol0003o01@0000E00;oo`0E00005@000ol0003o01@0000E0003o`000?l0
500001D000?o0000o`0D00005@000ol0003o01@0000E0003o`000?l0500001D000?o0000o`0D0000
5@000ol0003o01@0000E0003o`000?l0500001D00_oo01D0000E0003o`000?l0500001D000?o0000
o`0D00005@000ol0003o01@0000E0003o`000?l0500001D000?o0000o`0D00005@000ol0003o01@0
000E0003o`000?l0500001D00_oo01D0000E0003o`000?l0500001D000?o0000o`0D00005@000ol0
003o01@0000E0003o`000?l0500001D000?o0000o`0D00003@04o`@000?o0000o`0D00003P000ol0
00040003o`000<H00om:00003`000ol0000300?oa@05odT0000@0003o`00008000?o0000a@05odT0
000=0004o`00o`@000?o0000a@05odT0000>00;o1@000ol0003600?oBP0001D000?o0000o`0D0000
5@000ol0003o01@0000E0003o`000?l0500001D000?o0000o`0D00005@000ol0003o01@0000E00;o
o`0E00005@000ol0003o01@0000E0003o`000?l0500001D000?o0000o`0D00005@000ol0003o01@0
000E0003o`000?l0500001D000?o0000o`0D00005@000ol0003o01@0000E00;oo`0E00005@000ol0
003o01@0000E0003o`000?l0500001D000?o0000o`0D00005@000ol0003o01@0000E0003o`000?l0
500001D000?o0000o`0D00005@000ol0003o01@0000E00;oo`0E00005@000ol0003o01@0000E0003
o`000?l0500001D000?o0000o`0D00005@000ol0003o01@0000E0003o`000?l0500001D000?o0000
o`0D00005@000ol0003o01@0000E0003o`000?l0500001D00_oo01D0000E0003o`000?l0500001D0
00?o0000o`0D00005@000ol0003o01@0000E0003o`000?l0500001D000?o0000o`0D000000<0ool0
0_l300;o0`03o`D000?o0000o`0;00?o1P00008000?o00000`02o`H000?o00000P000ol0003o00X0
1Ol500000`000ol0000:0003o`0000800ooo00X01Ol5000010000ol0000600?o1@000ol0003o00X0
1Ol5000000D0o`00o`080003o`0000D000?o0000o`0;00?o1P0000800_l900Co10000ol0003o01@0
000E0003o`000?l050000?l0;0000?l0;0000?l0;0000?l0;0000001\
\>"],
  ImageRangeCache->{{{0, 298.062}, {183.5, 0}} -> {0.680594, 0.399428, 
  0.0148272, 0.0119954}}]
}, Closed]],

Cell[TextData[{
  "The first argument to ",
  StyleBox["Table", "Input",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " can be a conditional statement such as ",
  StyleBox["If", "Input",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " or ",
  StyleBox["Which", "Input",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  ". An element of the following matrix is 1 if its indices ",
  StyleBox["i",
    FontSlant->"Italic"],
  " and ",
  StyleBox["j",
    FontSlant->"Italic"],
  " satisfy ",
  Cell[BoxData[
      \(TraditionalForm
      \`\[LeftBracketingBar]i - j\[RightBracketingBar] \[LessEqual] 2\)]],
  ", and is 0 otherwise."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(MatrixForm[Table[If[Abs[i - j] \[LessEqual] 2, 1, 0], {i, 7}, {j, 7}]]
      \)], "Input"],

Cell[BoxData[
    TagBox[
      RowBox[{"(", GridBox[{
            {"1", "1", "1", "0", "0", "0", "0"},
            {"1", "1", "1", "1", "0", "0", "0"},
            {"1", "1", "1", "1", "1", "0", "0"},
            {"0", "1", "1", "1", "1", "1", "0"},
            {"0", "0", "1", "1", "1", "1", "1"},
            {"0", "0", "0", "1", "1", "1", "1"},
            {"0", "0", "0", "0", "1", "1", "1"}
            }], ")"}],
      (MatrixForm[ #]&)]], "Output"]
}, Closed]],

Cell[TextData[{
  "There is no need for ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " arrays to be rectangular. Here the upper limit of the inner loop ",
  StyleBox["j",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " depends on the value of the outer loop ",
  StyleBox["i",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Table[i + j, {i, 1, 4}, {j, 1, i}]\)], "Input"],

Cell[BoxData[
    \({{2}, {3, 4}, {4, 5, 6}, {5, 6, 7, 8}}\)], "Output"]
}, Closed]],

Cell["The result is a triangular array.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(TableForm[%]\)], "Input"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {"2", \(""\), \(""\), \(""\)},
          {"3", "4", \(""\), \(""\)},
          {"4", "5", "6", \(""\)},
          {"5", "6", "7", "8"}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      TableForm[ {{2}, {3, 4}, {4, 5, 6}, {5, 6, 7, 8}}]]], "Output"]
}, Closed]],

Cell[TextData[{
  "There is no limit to the number of dimensions that can be contained in a \
list. Here we generate a rank-4 (four-dimensional) tensor by including four \
iterators in the ",
  StyleBox["Table", "Input",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " command."
}], "Text"],

Cell[BoxData[
    \(\(tensor = Table[i + j + k - l, {i, 2}, {j, 3}, {k, 4}, {l, 5}]; \)\)], 
  "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(TableForm[tensor]\)], "Input"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {GridBox[{
                {"2", "1", "0", \(-1\), \(-2\)},
                {"3", "2", "1", "0", \(-1\)},
                {"4", "3", "2", "1", "0"},
                {"5", "4", "3", "2", "1"}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], GridBox[{
                {"3", "2", "1", "0", \(-1\)},
                {"4", "3", "2", "1", "0"},
                {"5", "4", "3", "2", "1"},
                {"6", "5", "4", "3", "2"}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], GridBox[{
                {"4", "3", "2", "1", "0"},
                {"5", "4", "3", "2", "1"},
                {"6", "5", "4", "3", "2"},
                {"7", "6", "5", "4", "3"}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}]},
          {GridBox[{
                {"3", "2", "1", "0", \(-1\)},
                {"4", "3", "2", "1", "0"},
                {"5", "4", "3", "2", "1"},
                {"6", "5", "4", "3", "2"}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], GridBox[{
                {"4", "3", "2", "1", "0"},
                {"5", "4", "3", "2", "1"},
                {"6", "5", "4", "3", "2"},
                {"7", "6", "5", "4", "3"}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}], GridBox[{
                {"5", "4", "3", "2", "1"},
                {"6", "5", "4", "3", "2"},
                {"7", "6", "5", "4", "3"},
                {"8", "7", "6", "5", "4"}
                },
              RowSpacings->0.25,
              ColumnSpacings->1,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}]}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      TableForm[
       {{{{2, 1, 0, -1, -2}, {3, 2, 1, 0, -1}, {4, 3, 2, 1, 0}, {5, 4, 3, 2, 
        1}}, {{3, 2, 1, 0, -1}, {4, 3, 2, 1, 0}, {5, 4, 3, 2, 1}, {6, 5, 4, 3,
         2}}, {{4, 3, 2, 1, 0}, {5, 4, 3, 2, 1}, {6, 5, 4, 3, 2}, {7, 6, 5, 4,
         3}}}, {{{3, 2, 1, 0, -1}, {4, 3, 2, 1, 0}, {5, 4, 3, 2, 1}, {6, 5, 4,
         3, 2}}, {{4, 3, 2, 1, 0}, {5, 4, 3, 2, 1}, {6, 5, 4, 3, 2}, {7, 6, 5,
         4, 3}}, {{5, 4, 3, 2, 1}, {6, 5, 4, 3, 2}, {7, 6, 5, 4, 3}, {8, 7, 6,
         5, 4}}}}]]], "Output"]
}, Closed]],

Cell[TextData[{
  "It is important to make a distinction between list operations and matrix \
operations, particularly with respect to matrix multiplication. The function \
",
  StyleBox["Dot",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " (which we enter as a period ",
  StyleBox[".",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  ") is used for matrix and vector multiplication. Here is the product of a \
matrix and a vector."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \({{a, b}, {c, d}}.{x, y}\)], "Input"],

Cell[BoxData[
    \({a\ x + b\ y, c\ x + d\ y}\)], "Output"]
}, Closed]],

Cell[TextData[{
  "There is no difference in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " between a row vector and a column vector, as matrix and vector functions \
automatically interpret vectors in the appropriate way. Here we multiply a \
matrix by a vector on both the left and the right; in both cases, we type the \
vector the same way."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \({x, y}.{{a, b}, {c, d}}.{x, y} // Simplify\)], "Input"],

Cell[BoxData[
    \(a\ x\^2 + y\ \((b\ x + c\ x + d\ y)\)\)], "Output"]
}, Closed]],

Cell["Here is the matrix product of two matrices.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \({{1, 2}, {3, 4}}.{{a, b}, {c, d}}\  // MatrixForm\)], "Input"],

Cell[BoxData[
    TagBox[
      RowBox[{"(", GridBox[{
            {\(a + 2\ c\), \(b + 2\ d\)},
            {\(3\ a + 4\ c\), \(3\ b + 4\ d\)}
            }], ")"}],
      (MatrixForm[ #]&)]], "Output"]
}, Closed]],

Cell[TextData[{
  "Here we use ordinary multiplication ",
  StyleBox["*",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  ", and ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " performs termwise multiplication."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \({{1, 2}, {3, 4}}*{{a, b}, {c, d}} // MatrixForm\)], "Input"],

Cell[BoxData[
    TagBox[
      RowBox[{"(", GridBox[{
            {"a", \(2\ b\)},
            {\(3\ c\), \(4\ d\)}
            }], ")"}],
      (MatrixForm[ #]&)]], "Output"]
}, Closed]],

Cell[TextData[{
  "As a general rule, if two lists have the same shape, ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " will perform termwise arithmetic, and return a list with the same shape. \
For example, the difference of two vectors of equal length is a vector of the \
differences of the elements."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \({1, 2, 3} - {a, b, c}\)], "Input"],

Cell[BoxData[
    \({1 - a, 2 - b, 3 - c}\)], "Output"]
}, Closed]],

Cell[TextData[{
  "Notice also that ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " will combine a list with a single (scalar) expression. If we add a \
constant to a vector, ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " returns a vector where the constant has been added to each element."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \({a, b, c} + 2\)], "Input"],

Cell[BoxData[
    \({2 + a, 2 + b, 2 + c}\)], "Output"]
}, Closed]],

Cell["\<\
Similarly, multiplying or adding a scalar to a matrix results in \
the expression being multiplied or added to each element of the matrix.\
\>", 
  "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \({{1, 2}, {3, 4}} \[ScriptCapitalC] // \ MatrixForm\)], "Input"],

Cell[BoxData[
    TagBox[
      RowBox[{"(", GridBox[{
            {"\[ScriptCapitalC]", \(2\ \[ScriptCapitalC]\)},
            {\(3\ \[ScriptCapitalC]\), \(4\ \[ScriptCapitalC]\)}
            }], ")"}],
      (MatrixForm[ #]&)]], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \({{1, 2}, {3, 4}}\  + \[ScriptK] // \ MatrixForm\)], "Input"],

Cell[BoxData[
    TagBox[
      RowBox[{"(", GridBox[{
            {\(1 + \[ScriptK]\), \(2 + \[ScriptK]\)},
            {\(3 + \[ScriptK]\), \(4 + \[ScriptK]\)}
            }], ")"}],
      (MatrixForm[ #]&)]], "Output"]
}, Closed]],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " produces a warning message if two lists cannot be combined because they \
have different lengths."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \({1, 2, 3} + {a, b, c, d}\)], "Input"],

Cell[BoxData[
    \(Thread::"tdlen" \( : \ \) 
      "Objects of unequal length in \!\(\({1, 2, 3}\) + \({a, b, c, d}\)\) \
cannot be combined."\)], "Message"],

Cell[BoxData[
    \({1, 2, 3} + {a, b, c, d}\)], "Output"]
}, Closed]],

Cell[TextData[{
  "See also ",
  StyleBox["Cross", "Input"],
  ", ",
  StyleBox["Thread", "Input",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  ", ",
  StyleBox["Permutations", "Input",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  StyleBox[", ", "Text"],
  StyleBox["Calculus`VectorAnalysis`", "Input",
    FontFamily->"Courier",
    FontWeight->"Bold"]
}], "SeeAlso"]
}, Closed]],

Cell[CellGroupData[{

Cell["Exercises: Creating and Interpreting Lists", "Subsection",
  PageBreakAbove->True],

Cell[TextData[{
  "Create a list of the first ten prime numbers. (",
  StyleBox["Prime[", "Input"],
  StyleBox["n",
    FontSlant->"Italic"],
  StyleBox["]", "Input"],
  " returns the ",
  Cell[BoxData[
      \(TraditionalForm\`n\^th\)]],
  " prime number.)"
}], "Question"],

Cell[TextData[{
  "We use ",
  StyleBox["Table",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " to generate a list of the ",
  Cell[BoxData[
      \(TraditionalForm\`k\^th\)]],
  " prime numbers as ",
  StyleBox["k",
    FontSlant->"Italic"],
  " goes from 1 to 10. When we omit a starting value for the iterator ",
  StyleBox["k",
    FontSlant->"Italic"],
  ", it is assumed to be 1."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Table[Prime[k], {k, 10}]\)], "Input"],

Cell[BoxData[
    \({2, 3, 5, 7, 11, 13, 17, 19, 23, 29}\)], "Output"]
}, Closed]],

Cell[TextData[{
  "An alternative is to avoid the ",
  StyleBox["Table",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " command by recognizing that the mathematical function ",
  StyleBox["Prime",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " automatically maps itself over lists."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Prime[Range[10]]\)], "Input"],

Cell[BoxData[
    \({2, 3, 5, 7, 11, 13, 17, 19, 23, 29}\)], "Output"]
}, Closed]],

Cell[TextData[{
  "Define a function called ",
  StyleBox["zeroVector", "Input"],
  " that creates a vector containing ",
  StyleBox["n",
    FontSlant->"Italic"],
  " zeros, where ",
  StyleBox["n",
    FontSlant->"Italic"],
  " is an argument to ",
  StyleBox["zeroVector", "Input"],
  "."
}], "Question"],

Cell[TextData[{
  "Here is one definition using ",
  StyleBox["Table", "Input"],
  ". We can omit the name of the iterator if it does not occur in the \
expression given to ",
  StyleBox["Table", "Input"],
  "."
}], "Text"],

Cell[BoxData[
    \(zeroVector[n_Integer?Positive] := Table[0, {n}]\)], "Input"],

Cell["Here is a vector of ten zeros.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(zeroVector[10]\)], "Input"],

Cell[BoxData[
    \({0, 0, 0, 0, 0, 0, 0, 0, 0, 0}\)], "Output"]
}, Closed]],

Cell[TextData[{
  "We can define a ",
  StyleBox["zeroMatrix", "Input"],
  " function in a similar way."
}], "Text"],

Cell[BoxData[
    \(zeroMatrix[m_, n_] := Table[0, {m}, {n}]\)], "Input"],

Cell["Here is a 3 \[Times] 5 matrix of zeros.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(zeroMatrix[3, 5] // MatrixForm\)], "Input"],

Cell[BoxData[
    TagBox[
      RowBox[{"(", GridBox[{
            {"0", "0", "0", "0", "0"},
            {"0", "0", "0", "0", "0"},
            {"0", "0", "0", "0", "0"}
            }], ")"}],
      (MatrixForm[ #]&)]], "Output"]
}, Closed]],

Cell["\<\
Generate a 5 \[Times] 5 matrix, in which each element is the row \
number plus the column number, or the number 5, whichever is greater.\
\>", 
  "Question"],

Cell[TextData[{
  "We use ",
  StyleBox["Max", "Input"],
  " to determine if 5 or ",
  Cell[BoxData[
      \(TraditionalForm\`i + j\)]],
  " (the row number plus the column number) is greater."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Table[Max[{5, i + j}], {i, 5}, {j, 5}] // MatrixForm\)], "Input"],

Cell[BoxData[
    TagBox[
      RowBox[{"(", GridBox[{
            {"5", "5", "5", "5", "6"},
            {"5", "5", "5", "6", "7"},
            {"5", "5", "6", "7", "8"},
            {"5", "6", "7", "8", "9"},
            {"6", "7", "8", "9", "10"}
            }], ")"}],
      (MatrixForm[ #]&)]], "Output"]
}, Closed]],

Cell[TextData[{
  "Beginning with the matrix ",
  Cell[BoxData[
      \({{a, b}, {c, d}}\)], "Input"],
  " and the vector ",
  Cell[BoxData[
      \({x, y}\)], "Input"],
  ", create the vector ",
  Cell[BoxData[
      \({a\ x + b\ y, c\ x + d\ y}\)], "Input"],
  ". Beginning with the same matrix and vector, create the matrix ",
  Cell[BoxData[
      \({{a\ x, b\ x}, {c\ y, d\ y}}\)], "Input"],
  "."
}], "Question"],

Cell["\<\
This exercise illustrates the difference between list and matrix \
operations. Here are definitions of the matrix and vector.\
\>", "Text"],

Cell[BoxData[{
    \(\(exermat = {{a, b}, {c, d}}; \)\), 
    \(\(exervec = {x, y}; \)\)}], "Input"],

Cell[TextData[{
  "For matrix-vector multiplication we use ",
  StyleBox["Dot",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(exermat.exervec\)], "Input"],

Cell[BoxData[
    \({a\ x + b\ y, c\ x + d\ y}\)], "Output"]
}, Closed]],

Cell[TextData[{
  "To perform termwise multiplication we use ",
  StyleBox["Times",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(exermat*exervec // MatrixForm\)], "Input"],

Cell[BoxData[
    TagBox[
      RowBox[{"(", GridBox[{
            {\(a\ x\), \(b\ x\)},
            {\(c\ y\), \(d\ y\)}
            }], ")"}],
      (MatrixForm[ #]&)]], "Output"]
}, Closed]],

Cell["\<\
Compute the eigenvectors of a numeric approximation to the matrix\
\
\>", "Question"],

Cell[BoxData[
    FormBox[
      RowBox[{"(", GridBox[{
            {"1", "2", "3"},
            {"3", "2", "2"},
            {"7", "1", "2"}
            }], ")"}], TraditionalForm]], "Output",
  CellDingbat->None,
  TextAlignment->Left,
  TextJustification->0],

Cell["\<\
and see if they are normalized (that is, see if each eigenvector \
has unit length).\
\>", "Text",
  CellDingbat->None,
  FontWeight->"Bold"],

Cell["Here are the eigenvectors of the approximate matrix.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      RowBox[{"evecs", "=", 
        RowBox[{"Eigenvectors", "[", 
          RowBox[{"N", "[", 
            RowBox[{"(", GridBox[{
                  {"1", "2", "3"},
                  {"3", "2", "2"},
                  {"7", "1", "2"}
                  }], ")"}], "]"}], "]"}]}], ";", \(TableForm[evecs]\)}]], 
  "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {"0.483239084229278859`", "0.517864430334557823`", 
            "0.705901139868403681`"},
          {"0.596049601707503207`", \(-0.0356482181341619686`\), 
            \(-0.80215589310818256`\)},
          {"0.0106728369565719227`", \(-0.832607703968846912`\), 
            "0.55376032888156903`"}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Closed]],

Cell["The following function determines the length of a vector.", "Text"],

Cell[BoxData[
    \(veclength[z_?VectorQ] := \@\(z.z\)\)], "Input"],

Cell[TextData[{
  "Here we use ",
  StyleBox["Table", "Input"],
  " to test if each eigenvector has unit length."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Table[veclength[evecs[\([i]\)]], {i, 3}]\)], "Input"],

Cell[BoxData[
    \({0.999999999999999822`, 1.`, 1.`}\)], "Output"]
}, Closed]],

Cell[TextData[{
  "Alternatively, we use the high-level programming function ",
  StyleBox["Map", "Input"],
  " to map ",
  StyleBox["veclength", "Input"],
  " over each vector in ",
  StyleBox["evecs", "Input"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Map[veclength, evecs]\)], "Input"],

Cell[BoxData[
    \({0.999999999999999822`, 1.`, 1.`}\)], "Output"]
}, Closed]],

Cell[" ", "EndExercises"]
}, Closed]],

Cell[CellGroupData[{

Cell["Extracting Parts of Lists", "Subsection",
  CellTags->"Extracting Parts of Lists"],

Cell[TextData[{
  "Given a one-dimensional list, we can extract an element according to its \
position by using ",
  StyleBox["Part",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  ". In ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ", the first element of a list is at position 1, not 0."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Part[{a, b, c}, 1]\)], "Input"],

Cell[BoxData[
    \(a\)], "Output"]
}, Closed]],

Cell[TextData[{
  "A compact, equivalent way to express the same command is to enclose the \
desired position between ",
  StyleBox["[[", "Input"],
  " and ",
  StyleBox["]]", "Input"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \({a, b, c}[\([1]\)]\)], "Input"],

Cell[BoxData[
    \(a\)], "Output"]
}, Closed]],

Cell["\<\
In a multidimensional array, an element of a list can be another \
list. For example, here is a table of hurricane names, wind speeds (in \
knots), and pressures (in millibars), with each triple collected in a \
sublist.\
\>", "Text"],

Cell["\<\
hurr =
\t{{\"Allison\",   65,  987},
\t {\"Barry\",     50,  995},
\t {\"Chantal\",   60,  992},
\t {\"Dean\",      40,  999},
\t {\"Erin\",      75,  975},
\t {\"Felix\",    115,  950},
\t {\"Gabrielle\", 60,  998},
\t {\"Humberto\",  90,  970},
\t {\"Iris\",      75,  970},
\t {\"Jerry\",     35, 1003}};\
\>", "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(TableForm[hurr, TableSpacing \[Rule] {0, 3}]\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {\("Allison"\), "65", "987"},
          {\("Barry"\), "50", "995"},
          {\("Chantal"\), "60", "992"},
          {\("Dean"\), "40", "999"},
          {\("Erin"\), "75", "975"},
          {\("Felix"\), "115", "950"},
          {\("Gabrielle"\), "60", "998"},
          {\("Humberto"\), "90", "970"},
          {\("Iris"\), "75", "970"},
          {\("Jerry"\), "35", "1003"}
          },
        RowSpacings->0,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #, TableSpacing -> {0, 3}]&)]], "Output"]
}, Closed]],

Cell[TextData[{
  "To extract an entire sublist, or record, we specify the position of the \
record using ",
  StyleBox["Part",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " (or the part-specification brackets ",
  StyleBox["[[",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " ",
  StyleBox["]]",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  ")."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Part[hurr, 2]\)], "Input"],

Cell[BoxData[
    \({"Barry", 50, 995}\)], "Output"]
}, Closed]],

Cell[TextData[
"To extract a single element of a two-dimensional list, we refer to its \
coordinate, its row and column. For instance, to extract the wind speed of \
hurricane Erin, we first select Erin\[CloseCurlyQuote]s whole record, which \
is at position 5, and then select the second part of the record."], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Part[hurr, 5, 2]\)], "Input"],

Cell[BoxData[
    \(75\)], "Output"]
}, Closed]],

Cell["Here are two more ways to enter the same expression.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \({hurr[\([5, 2]\)], \(hurr[\([5]\)]\)[\([2]\)]}\)], "Input"],

Cell[BoxData[
    \({75, 75}\)], "Output"]
}, Closed]],

Cell[TextData[
"Similarly, we extract the pressure of the storm Gabrielle by extracting the \
sublist at position 7, then extracting the third part of Gabrielle\
\[CloseCurlyQuote]s record."], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(hurr[\([7, 3]\)]\)], "Input"],

Cell[BoxData[
    \(998\)], "Output"]
}, Closed]],

Cell["\<\
To extract elements from deeply nested lists, it may be necessary \
to specify several coordinates.\
\>", "Text"],

Cell[TextData[{
  "It is important to be aware that there is a difference between the part \
specification ",
  StyleBox["hurr[[1,2]]",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " and ",
  StyleBox["hurr[[{1,2}]]",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " (the latter has curly brackets inside the double square brackets). The \
former returns the element at position ",
  Cell[BoxData[
      \(TraditionalForm\`\((1, 2)\)\)]],
  " of the list ",
  StyleBox["hurr",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell["hurr[[1,2]]", "Input"],

Cell[OutputFormData["\<\
65\
\>", "\<\
65\
\>"], "Output"]
}, Closed]],

Cell[TextData[{
  "The latter is equivalent to ",
  StyleBox["{hurr[[1]], hurr[[2]]}",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell["hurr[[{1, 2}]]", "Input"],

Cell[OutputFormData["\<\
{{\"Allison\", 65, 987}, {\"Barry\", 50, 995}}\
\>", 
"\<\
{{Allison, 65, 987}, {Barry, 50, 995}}\
\>"], "Output"]
}, Closed]],

Cell[TextData[{
  "Note that ",
  StyleBox["[[{ }]]",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " notation provides a quick way to manipulate the elements of a list. Here \
is an example of using this notation to rearrange the elements of a list."
}], "Text"],

Cell[BoxData[
    \(\(plist = {a, b, c, d, e, f}; \)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(plist[\([{1, 4, 2, 5, 3, 6}]\)]\)], "Input"],

Cell[OutputFormData["\<\
{a, d, b, e, c, f}\
\>", 
"\<\
{a, d, b, e, c, f}\
\>"], "Output"]
}, Closed]],

Cell[TextData[{
  "Using ",
  StyleBox["Table", "Input"],
  " and ",
  StyleBox["Part", "Input"],
  ", we can define a function called ",
  StyleBox["sampleWithReplacement", "Input"],
  " that takes a sample of a given size from a list of data."
}], "Text"],

Cell[BoxData[
    \(sampleWithReplacement[L_List, n_Integer?Positive] := 
      Module[{\[ScriptL] = Length[L]}, 
        Table[L[\([Random[Integer, {1, \[ScriptL]}]]\)], {n}]]\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(sampleWithReplacement[{a, b, c, d, e}, 10]\)], "Input"],

Cell[BoxData[
    \({c, d, b, e, e, a, b, a, b, c}\)], "Output"]
}, Closed]],

Cell[TextData[{
  "We can extract a range of elements using ",
  StyleBox["Take",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  ". Here we extract the first five elements of a list."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Take[{a, b, c, d, e, f, g}, 5]\)], "Input"],

Cell[OutputFormData["\<\
{a, b, c, d, e}\
\>", 
"\<\
{a, b, c, d, e}\
\>"], "Output"]
}, Closed]],

Cell["Here we extract the last five elements.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Take[{a, b, c, d, e, f, g}, \(-5\)]\)], "Input"],

Cell[OutputFormData["\<\
{c, d, e, f, g}\
\>", 
"\<\
{c, d, e, f, g}\
\>"], "Output"]
}, Closed]],

Cell["\<\
We can extract a sublist from the middle of the list, as well. Here \
we extract the third through sixth elements of a list.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Take[{a, b, c, d, e, f, g}, {3, 6}]\)], "Input"],

Cell[OutputFormData["\<\
{c, d, e, f}\
\>", "\<\
{c, d, e, f}\
\>"], "Output"]
}, Closed]],

Cell[TextData[{
  StyleBox["Drop",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " works similarly, removing elements from a list. Here we drop the first \
three elements from a list."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Drop[{a, b, c, d, e, f, g}, 3]\)], "Input"],

Cell[OutputFormData["\<\
{d, e, f, g}\
\>", "\<\
{d, e, f, g}\
\>"], "Output"]
}, Closed]],

Cell[TextData[{
  "Note that ",
  StyleBox["Take",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " and ",
  StyleBox["Drop",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " do not alter the value of a list. Here is a vector of values."
}], "Text"],

Cell[BoxData[
    \(\(alpha
       = {\[ScriptA], \[ScriptB], \[ScriptC], \[ScriptD], \[ScriptE], 
        \[ScriptF]}; \)\)], "Input"],

Cell[TextData[{
  "If we drop some elements from ",
  StyleBox["alpha",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  ", ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " returns the remaining elements."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Drop[alpha, {3, 5}]\)], "Input"],

Cell[BoxData[
    \({\[ScriptA], \[ScriptB], \[ScriptF]}\)], "Output"]
}, Closed]],

Cell["However, the original list remains unchanged.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(alpha\)], "Input"],

Cell[BoxData[
    \({\[ScriptA], \[ScriptB], \[ScriptC], \[ScriptD], \[ScriptE], \[ScriptF]}
      \)], "Output"]
}, Closed]],

Cell[TextData[{
  "To alter the value of ",
  StyleBox["alpha",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  ", we must set the value of ",
  StyleBox["alpha",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " to the desired subset."
}], "Text"],

Cell[BoxData[
    \(\(alpha = Drop[alpha, {3, 5}]; \)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(alpha\)], "Input"],

Cell[BoxData[
    \({\[ScriptA], \[ScriptB], \[ScriptF]}\)], "Output"]
}, Closed]],

Cell[TextData[{
  "Here is a function called ",
  StyleBox["sampleWithoutReplacement", "Input"],
  " that takes a given number of samples from a list, without choosing the \
same element more than once."
}], "Text"],

Cell[BoxData[
    \(sampleWithoutReplacement[L_List, n_Integer?Positive] := 
      Module[{\[ScriptCapitalL] = L, \[ScriptL] = Length[L], pos}, 
        Table[pos = Random[Integer, {1, \[ScriptL]}]; 
          \[ScriptCapitalL] = Drop[\[ScriptCapitalL], {pos}]; 
          \[ScriptL] = \[ScriptL] - 1; L[\([pos]\)], {n}]]\)], "Input"],

Cell["\<\
Here is a sample of fifteen data points from a list of integers \
from 1 to 50.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(sampleWithoutReplacement[Range[50], 15]\)], "Input"],

Cell[BoxData[
    \({35, 30, 33, 27, 20, 17, 29, 24, 8, 25, 4, 39, 37, 3, 19}\)], "Output"]
}, Closed]],

Cell[TextData[{
  "See also ",
  StyleBox["Extract", "Input"],
  ", ",
  StyleBox["Append",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  ", ",
  StyleBox["AppendTo",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  ", ",
  StyleBox["Prepend",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  ", ",
  StyleBox["PrependTo",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  ", ",
  StyleBox["Insert",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  ", ",
  StyleBox["Delete",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  ", ",
  StyleBox["ReplacePart",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  ", ",
  StyleBox["DeleteCases",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  ", ",
  StyleBox["Select",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  ", ",
  StyleBox["Join",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  ", ",
  StyleBox["Split", "Input"],
  ", ",
  StyleBox["LinearAlgebra`MatrixManipulation`",
    FontFamily->"Courier",
    FontWeight->"Bold"]
}], "SeeAlso"]
}, Closed]],

Cell[CellGroupData[{

Cell["Exercises: Extracting Parts of Lists", "Subsection",
  PageBreakAbove->True],

Cell[TextData[{
  "Using ",
  StyleBox["Part", "Input"],
  ", extract the ",
  StyleBox["b", "Input"],
  " from ",
  Cell[BoxData[
      \({{a, b, c}, {d, e, f}}\)], "Input"],
  "."
}], "Question"],

Cell[TextData[{
  "The ",
  StyleBox["b",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " is in the first row and second column of the matrix, so we use ",
  StyleBox["Part", "Input",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " as follows."
}], "Text"],

Cell[CellGroupData[{

Cell["Part[{{a, b, c}, {d, e, f}}, 1, 2]", "Input"],

Cell[OutputFormData["\<\
b\
\>", "\<\
b\
\>"], "Output"]
}, Closed]],

Cell[TextData[{
  "We can use the double-bracket shorthand for ",
  StyleBox["Part",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " as follows."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \({{a, b, c}, {d, e, f}}[\([1, 2]\)]\)], "Input"],

Cell[OutputFormData["\<\
b\
\>", "\<\
b\
\>"], "Output"]
}, Closed]],

Cell[TextData[{
  "Switch the third and fourth elements of the list ",
  Cell[BoxData[
      \({a, b, c, d, e}\)], "Input"],
  "."
}], "Question"],

Cell[TextData[{
  "We can use the part-selection notation ",
  Cell[BoxData[
      \(\([\([{\ }]\)]\)\)], "Input"],
  " to switch the elements."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \({a, b, c, d, e}[\([{1, 2, 4, 3, 5}]\)]\)], "Input"],

Cell[OutputFormData["\<\
{a, b, d, c, e}\
\>", 
"\<\
{a, b, d, c, e}\
\>"], "Output"]
}, Closed]],

Cell[TextData[{
  "Use ",
  StyleBox["Table", "Input"],
  " and ",
  StyleBox["Part", "Input"],
  " to define a function called ",
  StyleBox["everyOtherElement", "Input"],
  " that extracts every other element of a list."
}], "Question"],

Cell[TextData[{
  "The key is to set up an iterator inside ",
  StyleBox["Table", "Input"],
  " that extracts every second element from a list."
}], "Text"],

Cell[BoxData[
    \(everyOtherElement[L_List] := Table[Part[L, n], {n, 1, Length[L], 2}]\)],
   "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(everyOtherElement[{a, b, c, d, e, f, g, h, i, j, k, l}]\)], "Input"],

Cell[BoxData[
    \({a, c, e, g, i, k}\)], "Output"]
}, Closed]],

Cell[TextData[{
  "Define a function ",
  StyleBox["matrixTrace", "Input"],
  " that computes the sum of all the elements along the diagonal of a \
matrix."
}], "Question"],

Cell["Here is a matrix.", "Text"],

Cell[BoxData[
    RowBox[{
      RowBox[{"testmat", "=", 
        RowBox[{"(", GridBox[{
              {"a", "b", "c"},
              {"d", "e", "f"},
              {"g", "h", "i"}
              }], ")"}]}], ";"}]], "Input"],

Cell["\<\
The elements along the diagonal have equal coordinates in the \
horizontal and vertical directions.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Table[testmat[\([n, n]\)], {n, 1, 3}]\)], "Input"],

Cell[BoxData[
    \({a, e, i}\)], "Output"]
}, Closed]],

Cell[TextData[{
  "To add the elements, we use ",
  StyleBox["Sum", "Input"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Sum[testmat[\([n, n]\)], {n, 1, 3}]\)], "Input"],

Cell[BoxData[
    \(a + e + i\)], "Output"]
}, Closed]],

Cell[TextData[{
  "Here is a general definition of ",
  StyleBox["matrixTrace", "Input"],
  "."
}], "Text"],

Cell[BoxData[
    \(matrixTrace[m_] := Sum[m[\([n, n]\)], {n, Length[m]}]\)], "Input"],

Cell["Here is a square matrix.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(primemat = Partition[Prime[Range[16]], 4]; MatrixForm[primemat]\)], 
  "Input"],

Cell[BoxData[
    TagBox[
      RowBox[{"(", GridBox[{
            {"2", "3", "5", "7"},
            {"11", "13", "17", "19"},
            {"23", "29", "31", "37"},
            {"41", "43", "47", "53"}
            }], ")"}],
      (MatrixForm[ #]&)]], "Output"]
}, Closed]],

Cell["The function works as expected.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(matrixTrace[primemat]\)], "Input"],

Cell[BoxData[
    \(99\)], "Output"]
}, Closed]],

Cell["A hand calculation shows that the answer is correct.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(2 + 13 + 31 + 53\)], "Input"],

Cell[BoxData[
    \(99\)], "Output"]
}, Closed]],

Cell["Here is a modification to allow only square matrices.", "Text"],

Cell[BoxData[
    \(Clear[matrixTrace]\)], "Input"],

Cell[BoxData[
    \(matrixTrace[m_] := 
      Sum[m[\([n, n]\)], {n, Length[m]}] /; 
        MatrixQ[m] && First[Dimensions[m]] == Last[Dimensions[m]]\)], "Input"],

Cell[" ", "EndExercises"]
}, Closed]],

Cell[CellGroupData[{

Cell["Characteristics of Elements", "Subsection",
  CellTags->"Characteristics of Elements"],

Cell[TextData[{
  "Often it is necessary to select elements from a list according to certain \
criteria, rather than according to position. The ",
  StyleBox["Select", "Input"],
  " function returns the elements of a given list that meet a specified \
criterion."
}], "Text"],

Cell[TextData[{
  "For example, one way to extract all of the prime numbers less than 100 is \
first to generate a list of integers from 1 to 100, then select from that \
list all the elements that satisfy the predicate function ",
  StyleBox["PrimeQ", "Input"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Select[Range[100], PrimeQ]\)], "Input"],

Cell[OutputFormData["\<\
{2, 3, 5, 7, 11, 13, 17, 19, 23, 29, 31, 37, 41, 
 
  43, 47, 53, 59, 61, 67, 71, 73, 79, 83, 89, 97}\
\>", 
"\<\
{2, 3, 5, 7, 11, 13, 17, 19, 23, 29, 31, 37, 41, 
 
  43, 47, 53, 59, 61, 67, 71, 73, 79, 83, 89, 97}\
\>"], "Output"]
}, Closed]],

Cell["\<\
Similarly we can choose from a list of ordered pairs all pairs that \
satisfy some specified criteria. Here is a list of points along a \
spiral.\
\>", "Text"],

Cell[BoxData[
    \(\(pts = Table[{r\ Cos[r], r\ Sin[r]}, {r, 0, 25, 0.25}]; \)\)], "Input"],

Cell[TextData[{
  "Here is a predicate function that acts on pairs of numbers that returns ",
  StyleBox["True", "Input"],
  " if its first element times its second element is greater than zero."
}], "Text"],

Cell[BoxData[
    \(quad1or3[{x_, y_}] := \((x\ y > 0)\)\)], "Input"],

Cell[TextData[{
  "Here is a second predicate that returns ",
  StyleBox["True", "Input"],
  " if its second element is greater than or equal to its first element."
}], "Text"],

Cell[BoxData[
    \(ygex[{x_, y_}] := \((y >= x)\)\)], "Input"],

Cell[TextData[{
  "(We want each of the following graphs to use the same option settings, and \
",
  StyleBox["SetOptions", "Input"],
  " allows us to change the default settings. We will change the settings \
back to their original values after this example.)"
}], "Text"],

Cell[BoxData[
    \(\(SetOptions[ListPlot, AspectRatio \[Rule] 1, 
      PlotRange \[Rule] {{\(-25\), 25}, {\(-25\), 25}}, 
      PlotStyle \[Rule] PointSize[0.02], DisplayFunction \[Rule] Identity, 
      Ticks \[Rule] None]; \)\)], "Input"],

Cell[TextData[{
  "The first plot is of all the points in the list ",
  StyleBox["pts", "Input"],
  "."
}], "Text"],

Cell[BoxData[
    \(\(ptsplot = ListPlot[pts, PlotLabel \[Rule] "\<All points\>"]; \)\)], 
  "Input"],

Cell[TextData[{
  "The second plot is of the points in the first or third quadrant (those \
that satisfy the predicate function ",
  StyleBox["quad1or3", "Input"],
  ")."
}], "Text"],

Cell[BoxData[
    \(\(q1or3pts = Select[pts, quad1or3]; \)\)], "Input"],

Cell[BoxData[
    \(\(q1or3plot = ListPlot[q1or3pts, PlotLabel \[Rule] "\<Quad. 1 or 3\>"]; 
    \)\)], "Input"],

Cell[TextData[{
  "The last plot is of the points for which the ",
  StyleBox["y ",
    FontSlant->"Italic"],
  "value is greater than or equal to the ",
  StyleBox["x",
    FontSlant->"Italic"],
  " value."
}], "Text"],

Cell[BoxData[
    \(\(ygexpts = Select[pts, ygex]; \)\)], "Input"],

Cell[BoxData[
    \(\(ygexplot = 
      ListPlot[ygexpts, PlotLabel \[Rule] "\<y \[GreaterEqual] x\>"]; \)\)], 
  "Input"],

Cell["Here are the three plots.", "Text"],

Cell[CellGroupData[{

Cell["\<\
Show[
  GraphicsArray[{ptsplot, q1or3plot, ygexplot}]
    ];\
\>", "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .3125 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.31746 0.00744048 0.31746 [
[ 0 0 0 0 ]
[ 1 .3125 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .3125 L
0 .3125 L
closepath
clip
newpath
% Start of sub-graphic
p
0.0238095 0.00744048 0.321429 0.30506 MathSubStart
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.02 0.5 0.02 [
[.5 1.0125 -32 0 ]
[.5 1.0125 32 14 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
0 .5 m
1 .5 L
s
.5 0 m
.5 1 L
s
gsave
.5 1.0125 -77 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 22 translate 1 -1 scale
47.000000 14.000000 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(All) show
71.000000 14.000000 moveto
(points) show
1.000000 setlinewidth
grestore
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
.02 w
.5 .5 Mdot
.50484 .50124 Mdot
.50878 .50479 Mdot
.51098 .51022 Mdot
.51081 .51683 Mdot
.50788 .52372 Mdot
.50212 .52992 Mdot
.49376 .53444 Mdot
.48335 .53637 Mdot
.47173 .53501 Mdot
.45994 .52992 Mdot
.44916 .52099 Mdot
.4406 .50847 Mdot
.43538 .49297 Mdot
.43445 .47545 Mdot
.43846 .45713 Mdot
.44771 .43946 Mdot
.46208 .42393 Mdot
.48103 .41202 Mdot
.50357 .40507 Mdot
.52837 .40411 Mdot
.55377 .40981 Mdot
.57795 .42239 Mdot
.59904 .44155 Mdot
.61522 .46647 Mdot
.62493 .49585 Mdot
.62696 .52797 Mdot
.62056 .56076 Mdot
.60555 .59198 Mdot
.58235 .61935 Mdot
.552 .6407 Mdot
.51609 .65416 Mdot
.47672 .6583 Mdot
.43635 .65223 Mdot
.39766 .63574 Mdot
.36335 .60933 Mdot
.336 .57418 Mdot
.31782 .53217 Mdot
.31054 .48572 Mdot
.31522 .43769 Mdot
.33219 .3912 Mdot
.36093 .34939 Mdot
.40014 .31526 Mdot
.44773 .29145 Mdot
.50097 .28 Mdot
.55663 .28224 Mdot
.61116 .29865 Mdot
.66094 .32876 Mdot
.70252 .37122 Mdot
.73284 .42378 Mdot
.74945 .48342 Mdot
.75071 .54656 Mdot
.73594 .60924 Mdot
.70545 .66738 Mdot
.66063 .71702 Mdot
.60383 .75465 Mdot
.53829 .77737 Mdot
.46791 .78319 Mdot
.39707 .77112 Mdot
.33032 .74132 Mdot
.27209 .69509 Mdot
.22643 .63485 Mdot
.19668 .564 Mdot
.18528 .48676 Mdot
.19355 .40787 Mdot
.22159 .33234 Mdot
.26821 .26511 Mdot
.331 .21075 Mdot
.40644 .17312 Mdot
.49008 .15514 Mdot
.5768 .15853 Mdot
.66117 .18369 Mdot
.73771 .22964 Mdot
.80134 .29404 Mdot
.84762 .37328 Mdot
.87314 .46273 Mdot
.87571 .55695 Mdot
.85454 .65008 Mdot
.81037 .73616 Mdot
.7454 .80952 Mdot
.66323 .86518 Mdot
.56866 .89914 Mdot
.46738 .9087 Mdot
.36566 .89265 Mdot
.26995 .8514 Mdot
.18648 .78693 Mdot
.12083 .7028 Mdot
.07759 .60389 Mdot
.06002 .49611 Mdot
.06983 .38609 Mdot
.10701 .28077 Mdot
.16984 .18692 Mdot
.2549 .11074 Mdot
.35729 .05744 Mdot
.4709 .0309 Mdot
.5888 .03337 Mdot
.70361 .06532 Mdot
.80799 .12535 Mdot
.89514 .21023 Mdot
.95918 .31513 Mdot
.9956 .43382 Mdot
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.35119 0.00744048 0.64881 0.30506 MathSubStart
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.02 0.5 0.02 [
[.5 1.0125 -38 0 ]
[.5 1.0125 38 14 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
0 .5 m
1 .5 L
s
.5 0 m
.5 1 L
s
gsave
.5 1.0125 -83 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 22 translate 1 -1 scale
47.000000 14.000000 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(Quad) show
71.000000 14.000000 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(.) show
83.000000 14.000000 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(1) show
95.000000 14.000000 moveto
(or) show
113.000000 14.000000 moveto
(3) show
1.000000 setlinewidth
grestore
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
.02 w
.50484 .50124 Mdot
.50878 .50479 Mdot
.51098 .51022 Mdot
.51081 .51683 Mdot
.50788 .52372 Mdot
.50212 .52992 Mdot
.43538 .49297 Mdot
.43445 .47545 Mdot
.43846 .45713 Mdot
.44771 .43946 Mdot
.46208 .42393 Mdot
.48103 .41202 Mdot
.62696 .52797 Mdot
.62056 .56076 Mdot
.60555 .59198 Mdot
.58235 .61935 Mdot
.552 .6407 Mdot
.51609 .65416 Mdot
.31054 .48572 Mdot
.31522 .43769 Mdot
.33219 .3912 Mdot
.36093 .34939 Mdot
.40014 .31526 Mdot
.44773 .29145 Mdot
.75071 .54656 Mdot
.73594 .60924 Mdot
.70545 .66738 Mdot
.66063 .71702 Mdot
.60383 .75465 Mdot
.53829 .77737 Mdot
.18528 .48676 Mdot
.19355 .40787 Mdot
.22159 .33234 Mdot
.26821 .26511 Mdot
.331 .21075 Mdot
.40644 .17312 Mdot
.49008 .15514 Mdot
.87571 .55695 Mdot
.85454 .65008 Mdot
.81037 .73616 Mdot
.7454 .80952 Mdot
.66323 .86518 Mdot
.56866 .89914 Mdot
.06002 .49611 Mdot
.06983 .38609 Mdot
.10701 .28077 Mdot
.16984 .18692 Mdot
.2549 .11074 Mdot
.35729 .05744 Mdot
.4709 .0309 Mdot
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.678571 0.00744048 0.97619 0.30506 MathSubStart
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.02 0.5 0.02 [
[.5 1.0125 -17 0 ]
[.5 1.0125 17 14 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
0 .5 m
1 .5 L
s
.5 0 m
.5 1 L
s
gsave
.5 1.0125 -62 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 22 translate 1 -1 scale
47.000000 14.000000 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(y) show
59.000000 14.000000 moveto
/Math1Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(\\263) show
71.000000 14.000000 moveto
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(x) show
1.000000 setlinewidth
grestore
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
.02 w
.5 .5 Mdot
.51081 .51683 Mdot
.50788 .52372 Mdot
.50212 .52992 Mdot
.49376 .53444 Mdot
.48335 .53637 Mdot
.47173 .53501 Mdot
.45994 .52992 Mdot
.44916 .52099 Mdot
.4406 .50847 Mdot
.43538 .49297 Mdot
.43445 .47545 Mdot
.43846 .45713 Mdot
.58235 .61935 Mdot
.552 .6407 Mdot
.51609 .65416 Mdot
.47672 .6583 Mdot
.43635 .65223 Mdot
.39766 .63574 Mdot
.36335 .60933 Mdot
.336 .57418 Mdot
.31782 .53217 Mdot
.31054 .48572 Mdot
.31522 .43769 Mdot
.33219 .3912 Mdot
.66063 .71702 Mdot
.60383 .75465 Mdot
.53829 .77737 Mdot
.46791 .78319 Mdot
.39707 .77112 Mdot
.33032 .74132 Mdot
.27209 .69509 Mdot
.22643 .63485 Mdot
.19668 .564 Mdot
.18528 .48676 Mdot
.19355 .40787 Mdot
.22159 .33234 Mdot
.7454 .80952 Mdot
.66323 .86518 Mdot
.56866 .89914 Mdot
.46738 .9087 Mdot
.36566 .89265 Mdot
.26995 .8514 Mdot
.18648 .78693 Mdot
.12083 .7028 Mdot
.07759 .60389 Mdot
.06002 .49611 Mdot
.06983 .38609 Mdot
.10701 .28077 Mdot
.16984 .18692 Mdot
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  Evaluatable->False,
  AspectRatioFixed->True,
  ImageSize->{299.062, 93.4375},
  ImageMargins->{{48, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004[0000G@P10`4000010?ooooooc?ooZ_ooI_oo
<ooo0?o<ooo<c?o<VC/k>gYjN[Vi^OShn03ooeGooj[ooonI<onI0?mVoomVc?mVVOmVI_mV<omV0?lc
oclo?ginO[fm_Oclo5D00:X00?l00?l0VOl0I_l0<ol00<coolcoc<coVLcoIP<30d92@X61PL30`000
EED0EJX0EOl0ELbIolbIc<bIVLbII/bI<lbI0<aVolaVc0L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0Z/`c
<l`c0<`0ol`0c<`0VL`0I/`0<l`000/;2dY:BXV9RLS8b000oeD0ojX0ool0oiW<VIW<IYW<<iW<09VI
oiVIc9VIVIVIIPl?3di>CXf=SLc<c01E05EE0:YE0?mE09TcoiTcc9TcVITcIYTc<iTc09T0oiT0c1<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEEFKo<fKo06K<ofK<c6K<VFK<IVK<<fK<01LG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZVIVVFIVIVIV<fIV06HcofHcc6HcVFHcIQ/K6eYJFYVIVMSHf01EoeEEojYEoomEoc?o
oc?oc3?oVC?oIS?o<c?o03?<oc?<c1lO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ03>I<c>I03=Voc=Vc3=V
VC=VIS=V<c=V02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZEC<0VC<0IS<0<c<0003oo`3oc03oV@3oIRLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2Io`2Ic02IV@2IIP2I<`2I001Vo`1Vc2/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`0c<`0c0000o`00c000V@00IP00<nh002l_;fi^KZf][Nc/k03o05Go0:[o0?oo0140
003^003M002k002Z0028001g001E03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@00M`00E@00A0008P00
4Nk^k]gMgK^k^cLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l0;0000?l0;00003@000?o0000GP000ol0
001M0003o`0003<0000d0003o`0005h000?o0000G@000ol0000c0000=0000ol0001N0003o`0005d0
00?o0000<`00034000Co003o1@000ol0001E0004o`00oel000?o0000<`0003@000?o0000GP000ol0
001M0003o`0003<0000Y0003o`0000P000?o00002`000ol000150003o`0000P000?o0000G@000ol0
000c0000=0000ol0001N0003o`0005d000?o0000<`0003@000?o0000GP000ol0001M0003o`0003<0
000d0003o`0005h000?o0000G@000ol0000c00008P000ol0000?0003o`0004/000?o000040000ol0
001M0003o`0003<0000d0003o`0001<000?o0000B0000ol0001M0003o`0003<0000d0003o`0005h0
00?o0000G@000ol0000c0000<`02o`@000?o0000F002oel000?o0000<`0002d000?o000010000ol0
001F0003o`0000D000?o0000G@000ol0000c00006`000ol0000F0003o`0000P000?o0000>P000ol0
000F0003o`0004D000?o00005@000ol0000c0000=0000ol0001N0003o`0005d000?o0000<`0002L0
00?o00002P000ol0000I0003o`0003D000?o00002P000ol0001M0003o`0003<0000d0003o`0000h0
00?o0000C@000ol0001M0003o`0003<0000d0003o`0005h000?o0000G@000ol0000c0000=0000ol0
001N0003o`0005d000?o0000<`0002<000?o00003P000ol0001<0003o`0000l000?o0000G@000ol0
000c00005`000ol0000J0005o`000?l0?`000ol0000J0003o`00040000?o00006P000ol0000c0000
<0001Ol0003o00L000?o00002P000ol000140003o`00008000?o0000G@000ol0000c0000=0000ol0
001N0003o`0005d000?o0000<`0002`000?o00001@000ol0000N0003o`0003D000?o00001@000ol0
001M0003o`0003<0000O0003o`00018000?o000020000ol0000n0003o`00018000?o0000B@000ol0
000A0003o`0003<0000Y0003o`0000P000?o0000D`000ol000080003o`0005d000?o0000<`0003@0
00?o0000GP000ol0001M0003o`0003<0000d0003o`0000/000?o000020000ol000150003o`0005d0
00?o0000<`0001@000?o000040000ol0000:0003o`0003h000?o000040000ol0000:0003o`0003h0
00?o000040000ol000090003o`0003<0000M0003o`0001@000Co0?ooAP000ol0000D0003o`0004L0
00?o00004`000ol0000c0000<@02o`030?l000<000?o000020000ol0001;00;o00<0o`00GP000ol0
000c00009P000ol0000;0003o`00024000?o0000;0000ol0000;0003o`00050000?o00002P000ol0
000c0000<0001Ol0003o00H000?o0000DP000ol000020003o`0005d000?o0000<`0002l000?o0000
0P000ol0000H0003o`0003h000?o00000P000ol0001I0005o`000?l0=@0002l000?o00000P000ol0
00050003o`00054000?o00000P000ol0001H0003o`00008000?o0000<`0001`000?o00001`000ol0
000;0003o`0000l000?o0000=0000ol000060003o`0000`000?o0000AP000ol000060003o`0000/0
00?o0000<`0000l0B_lG04[o5`1:oa00000_0003o`00008000?o0000GP000ol0001I0004o`0000;o
=00002H000?o00001`02o`8000?o00001P000ol0001D00;o20000ol000170003o`0000H00_l200;o
=00003401?lA0003o`0004`000?o00003`000ol0001900?o=@0003@000?o00001@000ol0000@0003
o`0004<000?o00001@000ol0000@0003o`00048000?o0000<`0001d000?o00001`000ol0000:0003
o`0005h000?o0000A`000ol000070003o`0000T000?o0000<`0003@000?o0000GP000ol0001M0003
o`0003<0000d0003o`0000@000?o0000E`000ol000040003o`0005H000?o0000<`0001D000?o0000
4@000ol000080003o`0000h000?o0000C@000ol0000>0003o`0002d000?o00004P000ol000070003
o`0003<0000d0003o`00008000?o0000F@000ol000020003o`0005P000?o00000`000ol0000]0000
7`000ol0000:0003o`0000D000Co003oG@001?l00?m80003o`0000X000?o000010001Ol0003o0340
000_0003o`0000800_lG0003o`0004D000?o00005P000ol000100004o`0000;o=000038000?o0?l0
3@000ol0001@0003o`0000/000?o0000C@000ol0o`0e0000=0000ol0001N0003o`0005d000?o0000
<`0002<000?o00003P000ol0001N0003o`0004d000?o00003@000ol0000c000060000ol0000I0003
o`0005h000?o0000@@000ol0000I0003o`0003<0000d0003o`0000P000?o0000D`000ol000080003
o`00058000?o00002@000ol0000W0000=0000ol0000C0003o`0004P000?o00004`000ol000170003
o`0003<0000W0003o`0000X000?o0000GP000ol0001A0003o`0000T000?o0000<`0003@000?o0000
10000ol0001G0003o`0000@000?o0000EP000ol000050003o`0002/0000/0003o`0000D000?o0?l0
GP000ol0o`1F0003o`0000@000Co003o<P0001d000?o00004@001?l00?mP0003o`0004H000?o0000
4P000ol0o`0e0000=0000ol0001N0003o`0005d000?o0000<`0003@000?o00003P000ol0001=0003
o`0000h000?o0000C0000ol0000?0003o`000240000d0003o`0005h000?o0000G@000ol0000c0000
=0000ol0001N0003o`0005d000?o0000<`0002<000?o00003P000ol0001N0003o`0004`000?o0000
3P000ol0000c0000=0000ol000080003o`0005<000?o000020000ol0001B0003o`0000T000?o0000
9`0003@000?o0000GP000ol0001M0003o`0003<0000Z0003o`0000L000Go0000o`1L0005o`000?l0
D@000ol000070003o`00008000?o0000;P00034000Co003oH0000ol0001K0003o`3o03D0000d0003
o`0005h000?o0000G@000ol0000c0000=0000ol0001N0003o`0005d000?o0000<`0003@000?o0000
GP000ol0001M0003o`0003<0000d0003o`0005h000?o0000G@000ol0000c0000=0000ol0001N0003
o`0005d000?o0000<`0003@000?o0000GP000ol0001M0003o`0003<0003o02`0003o02`0003o02`0
000^00Co@004og000om20000;`000ol000100003o`00078000?o0000@@0001H00_l00`3oo`0200Go
00<0ool00ol700Co0`03o`801Ol0103oo`02o`800ol200Co8@03o`<01Ol00`3oo`03o`801Ol00`3o
o`0900?o2P03o`801?l800?o<@000ol0000800Co1`02o`030?oo02P0000G0003o`3o00D000?o0000
0`000ol000070007o`000?l0o`030005o`000?l00`001?l00?l30004o`00o`@000?o00007P001Ol0
003o008000Co003o0P001?l00?l20005o`000?l00P02o`X000?o000020001Ol0003o008000?o0000
2`000ol0000^0003o`0000P000?o00002@000ol0o`0Y00005`03o`D000?o00000`000ol000070007
o`000?l0o`030005o`000?l00`001?l00?l30003o`0000801?lP0005o`000?l00P001?l00?l200Co
0P001Ol0003o00h000?o000020001Ol0003o008000?o00002`000ol0000]0003o`3o00X00ol90003
o`0002P0000G0003o`3o00D000?o00000`000ol000070007o`000?l0o`030005o`000?l00`001?l0
0?l30003o`00008000?o00008@001Ol0003o008000Co003o1@001?l00?l30003o`0000`000?o0000
20001Ol0003o00800_l:00;o<0000ol0o`090003o`0000T000?o0?l0:@0001P000?o000010000ol0
00030003o`0000H01Ol300?o0`02o`801Ol200Co0P04ob0000Ko0000o`02o`030?oo00<00ol300Co
3P000ol0000900?o0P02o`030?oo00X000?o0000;002o`030?oo01<00_l00`3oo`0X00005`02o`H0
00?o00000`000ol0000P0003o`0002L00olC0003o`0000/00_lL00?oM00001d00ol300?o5`000ol0
00080003o`0003`00_nR0000o`0/0000o`0/0000o`0/0000o`0/0000o`0/0000\
\>"],
  ImageRangeCache->{{{0, 298.062}, {92.4375, 0}} -> {-0.0870627, -0.0234425, 
  0.0106492, 0.0106492}, {{8.125, 96.1875}, {90.1875, 2.1875}} -> {-35.6816,
   -26.5395, 0.684128, 0.684128}, {{105, 193}, {90.1875, 2.1875}} ->
   {-101.935, -26.5395, 0.684128, 0.684128}, {{201.812, 289.875}, {90.1875, 
  2.1875}} -> {-168.189, -26.5395, 0.684128, 0.684128}}]
}, Closed]],

Cell[TextData[{
  "Here we set the options to ",
  StyleBox["ListPlot", "Input"],
  " back to the default settings."
}], "Text"],

Cell[BoxData[
    \(\(SetOptions[ListPlot, AspectRatio \[Rule] GoldenRatio\^\(-1\), 
      PlotRange \[Rule] Automatic, PlotStyle \[Rule] Automatic, 
      DisplayFunction :> $DisplayFunction, Ticks \[Rule] Automatic]; \)\)], 
  "Input"],

Cell[TextData[{
  "We can test whether an element is present in a list by using ",
  StyleBox["MemberQ", "Input"],
  " and ",
  StyleBox["FreeQ", "Input"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(MemberQ[{a, b, c, d, e}, c]\)], "Input"],

Cell[BoxData[
    \(True\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(FreeQ[{a, a\^b, a\^\(b\^c\)}, c]\)], "Input"],

Cell[BoxData[
    \(False\)], "Output"]
}, Closed]],

Cell[TextData[{
  "See also ",
  StyleBox["Cases",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  ", ",
  StyleBox["Position",
    FontFamily->"Courier",
    FontWeight->"Bold"]
}], "SeeAlso"]
}, Closed]],

Cell[CellGroupData[{

Cell["Exercises: Characteristics of Elements", "Subsection",
  PageBreakAbove->True],

Cell[TextData[{
  "Use ",
  StyleBox["Select", "Input"],
  " to extract all the numbers from ",
  Cell[BoxData[
      \({a, 1, b, 2, c, 3}\)], "Input"],
  "."
}], "Question"],

Cell[TextData[{
  "We use the built-in predicate function ",
  StyleBox["NumberQ", "Input"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Select[{a, 1, b, 2, c, 3}, NumberQ]\)], "Input"],

Cell[OutputFormData["\<\
{1, 2, 3}\
\>", "\<\
{1, 2, 3}\
\>"], "Output"]
}, Closed]],

Cell[TextData[{
  "Create the following list of ",
  StyleBox["x",
    FontSlant->"Italic"],
  ", ",
  StyleBox["y",
    FontSlant->"Italic"],
  " pairs."
}], "Question"],

Cell[BoxData[
    \(\(pts = 
      Flatten[Table[{x, y}, {x, \(-3\), 3, 0.3}, {y, \(-3\), 3, 0.3}], 1]; 
    \)\)], "Input"],

Cell[TextData[{
  "Select from it all points whose coordinates satisfy ",
  Cell[BoxData[
      \(TraditionalForm\`sin(x) < sin(y)\)]],
  "."
}], "Text",
  FontWeight->"Bold"],

Cell["Here is a plot of all the points.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(ListPlot[pts, AspectRatio -> 1, PlotStyle -> PointSize[0.02]]; \)\)], 
  "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.5 0.15873 [
[.02381 .4875 -6 -9 ]
[.02381 .4875 6 0 ]
[.18254 .4875 -6 -9 ]
[.18254 .4875 6 0 ]
[.34127 .4875 -6 -9 ]
[.34127 .4875 6 0 ]
[.65873 .4875 -3 -9 ]
[.65873 .4875 3 0 ]
[.81746 .4875 -3 -9 ]
[.81746 .4875 3 0 ]
[.97619 .4875 -3 -9 ]
[.97619 .4875 3 0 ]
[.4875 .02381 -12 -4.5 ]
[.4875 .02381 0 4.5 ]
[.4875 .18254 -12 -4.5 ]
[.4875 .18254 0 4.5 ]
[.4875 .34127 -12 -4.5 ]
[.4875 .34127 0 4.5 ]
[.4875 .65873 -6 -4.5 ]
[.4875 .65873 0 4.5 ]
[.4875 .81746 -6 -4.5 ]
[.4875 .81746 0 4.5 ]
[.4875 .97619 -6 -4.5 ]
[.4875 .97619 0 4.5 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .5 m
.02381 .50625 L
s
[(-3)] .02381 .4875 0 1 Mshowa
.18254 .5 m
.18254 .50625 L
s
[(-2)] .18254 .4875 0 1 Mshowa
.34127 .5 m
.34127 .50625 L
s
[(-1)] .34127 .4875 0 1 Mshowa
.65873 .5 m
.65873 .50625 L
s
[(1)] .65873 .4875 0 1 Mshowa
.81746 .5 m
.81746 .50625 L
s
[(2)] .81746 .4875 0 1 Mshowa
.97619 .5 m
.97619 .50625 L
s
[(3)] .97619 .4875 0 1 Mshowa
.125 Mabswid
.05556 .5 m
.05556 .50375 L
s
.0873 .5 m
.0873 .50375 L
s
.11905 .5 m
.11905 .50375 L
s
.15079 .5 m
.15079 .50375 L
s
.21429 .5 m
.21429 .50375 L
s
.24603 .5 m
.24603 .50375 L
s
.27778 .5 m
.27778 .50375 L
s
.30952 .5 m
.30952 .50375 L
s
.37302 .5 m
.37302 .50375 L
s
.40476 .5 m
.40476 .50375 L
s
.43651 .5 m
.43651 .50375 L
s
.46825 .5 m
.46825 .50375 L
s
.53175 .5 m
.53175 .50375 L
s
.56349 .5 m
.56349 .50375 L
s
.59524 .5 m
.59524 .50375 L
s
.62698 .5 m
.62698 .50375 L
s
.69048 .5 m
.69048 .50375 L
s
.72222 .5 m
.72222 .50375 L
s
.75397 .5 m
.75397 .50375 L
s
.78571 .5 m
.78571 .50375 L
s
.84921 .5 m
.84921 .50375 L
s
.88095 .5 m
.88095 .50375 L
s
.9127 .5 m
.9127 .50375 L
s
.94444 .5 m
.94444 .50375 L
s
.25 Mabswid
0 .5 m
1 .5 L
s
.5 .02381 m
.50625 .02381 L
s
[(-3)] .4875 .02381 1 0 Mshowa
.5 .18254 m
.50625 .18254 L
s
[(-2)] .4875 .18254 1 0 Mshowa
.5 .34127 m
.50625 .34127 L
s
[(-1)] .4875 .34127 1 0 Mshowa
.5 .65873 m
.50625 .65873 L
s
[(1)] .4875 .65873 1 0 Mshowa
.5 .81746 m
.50625 .81746 L
s
[(2)] .4875 .81746 1 0 Mshowa
.5 .97619 m
.50625 .97619 L
s
[(3)] .4875 .97619 1 0 Mshowa
.125 Mabswid
.5 .05556 m
.50375 .05556 L
s
.5 .0873 m
.50375 .0873 L
s
.5 .11905 m
.50375 .11905 L
s
.5 .15079 m
.50375 .15079 L
s
.5 .21429 m
.50375 .21429 L
s
.5 .24603 m
.50375 .24603 L
s
.5 .27778 m
.50375 .27778 L
s
.5 .30952 m
.50375 .30952 L
s
.5 .37302 m
.50375 .37302 L
s
.5 .40476 m
.50375 .40476 L
s
.5 .43651 m
.50375 .43651 L
s
.5 .46825 m
.50375 .46825 L
s
.5 .53175 m
.50375 .53175 L
s
.5 .56349 m
.50375 .56349 L
s
.5 .59524 m
.50375 .59524 L
s
.5 .62698 m
.50375 .62698 L
s
.5 .69048 m
.50375 .69048 L
s
.5 .72222 m
.50375 .72222 L
s
.5 .75397 m
.50375 .75397 L
s
.5 .78571 m
.50375 .78571 L
s
.5 .84921 m
.50375 .84921 L
s
.5 .88095 m
.50375 .88095 L
s
.5 .9127 m
.50375 .9127 L
s
.5 .94444 m
.50375 .94444 L
s
.25 Mabswid
.5 0 m
.5 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
.02 w
.02381 .02381 Mdot
.02381 .07143 Mdot
.02381 .11905 Mdot
.02381 .16667 Mdot
.02381 .21429 Mdot
.02381 .2619 Mdot
.02381 .30952 Mdot
.02381 .35714 Mdot
.02381 .40476 Mdot
.02381 .45238 Mdot
.02381 .5 Mdot
.02381 .54762 Mdot
.02381 .59524 Mdot
.02381 .64286 Mdot
.02381 .69048 Mdot
.02381 .7381 Mdot
.02381 .78571 Mdot
.02381 .83333 Mdot
.02381 .88095 Mdot
.02381 .92857 Mdot
.02381 .97619 Mdot
.07143 .02381 Mdot
.07143 .07143 Mdot
.07143 .11905 Mdot
.07143 .16667 Mdot
.07143 .21429 Mdot
.07143 .2619 Mdot
.07143 .30952 Mdot
.07143 .35714 Mdot
.07143 .40476 Mdot
.07143 .45238 Mdot
.07143 .5 Mdot
.07143 .54762 Mdot
.07143 .59524 Mdot
.07143 .64286 Mdot
.07143 .69048 Mdot
.07143 .7381 Mdot
.07143 .78571 Mdot
.07143 .83333 Mdot
.07143 .88095 Mdot
.07143 .92857 Mdot
.07143 .97619 Mdot
.11905 .02381 Mdot
.11905 .07143 Mdot
.11905 .11905 Mdot
.11905 .16667 Mdot
.11905 .21429 Mdot
.11905 .2619 Mdot
.11905 .30952 Mdot
.11905 .35714 Mdot
.11905 .40476 Mdot
.11905 .45238 Mdot
.11905 .5 Mdot
.11905 .54762 Mdot
.11905 .59524 Mdot
.11905 .64286 Mdot
.11905 .69048 Mdot
.11905 .7381 Mdot
.11905 .78571 Mdot
.11905 .83333 Mdot
.11905 .88095 Mdot
.11905 .92857 Mdot
.11905 .97619 Mdot
.16667 .02381 Mdot
.16667 .07143 Mdot
.16667 .11905 Mdot
.16667 .16667 Mdot
.16667 .21429 Mdot
.16667 .2619 Mdot
.16667 .30952 Mdot
.16667 .35714 Mdot
.16667 .40476 Mdot
.16667 .45238 Mdot
.16667 .5 Mdot
.16667 .54762 Mdot
.16667 .59524 Mdot
.16667 .64286 Mdot
.16667 .69048 Mdot
.16667 .7381 Mdot
.16667 .78571 Mdot
.16667 .83333 Mdot
.16667 .88095 Mdot
.16667 .92857 Mdot
.16667 .97619 Mdot
.21429 .02381 Mdot
.21429 .07143 Mdot
.21429 .11905 Mdot
.21429 .16667 Mdot
.21429 .21429 Mdot
.21429 .2619 Mdot
.21429 .30952 Mdot
.21429 .35714 Mdot
.21429 .40476 Mdot
.21429 .45238 Mdot
.21429 .5 Mdot
.21429 .54762 Mdot
.21429 .59524 Mdot
.21429 .64286 Mdot
.21429 .69048 Mdot
.21429 .7381 Mdot
.21429 .78571 Mdot
.21429 .83333 Mdot
.21429 .88095 Mdot
.21429 .92857 Mdot
.21429 .97619 Mdot
.2619 .02381 Mdot
.2619 .07143 Mdot
.2619 .11905 Mdot
.2619 .16667 Mdot
.2619 .21429 Mdot
.2619 .2619 Mdot
.2619 .30952 Mdot
.2619 .35714 Mdot
.2619 .40476 Mdot
.2619 .45238 Mdot
.2619 .5 Mdot
.2619 .54762 Mdot
.2619 .59524 Mdot
.2619 .64286 Mdot
.2619 .69048 Mdot
.2619 .7381 Mdot
.2619 .78571 Mdot
.2619 .83333 Mdot
.2619 .88095 Mdot
.2619 .92857 Mdot
.2619 .97619 Mdot
.30952 .02381 Mdot
.30952 .07143 Mdot
.30952 .11905 Mdot
.30952 .16667 Mdot
.30952 .21429 Mdot
.30952 .2619 Mdot
.30952 .30952 Mdot
.30952 .35714 Mdot
.30952 .40476 Mdot
.30952 .45238 Mdot
.30952 .5 Mdot
.30952 .54762 Mdot
.30952 .59524 Mdot
.30952 .64286 Mdot
.30952 .69048 Mdot
.30952 .7381 Mdot
.30952 .78571 Mdot
.30952 .83333 Mdot
.30952 .88095 Mdot
.30952 .92857 Mdot
.30952 .97619 Mdot
.35714 .02381 Mdot
.35714 .07143 Mdot
.35714 .11905 Mdot
.35714 .16667 Mdot
.35714 .21429 Mdot
.35714 .2619 Mdot
.35714 .30952 Mdot
.35714 .35714 Mdot
.35714 .40476 Mdot
.35714 .45238 Mdot
.35714 .5 Mdot
.35714 .54762 Mdot
.35714 .59524 Mdot
.35714 .64286 Mdot
.35714 .69048 Mdot
.35714 .7381 Mdot
.35714 .78571 Mdot
.35714 .83333 Mdot
.35714 .88095 Mdot
.35714 .92857 Mdot
.35714 .97619 Mdot
.40476 .02381 Mdot
.40476 .07143 Mdot
.40476 .11905 Mdot
.40476 .16667 Mdot
.40476 .21429 Mdot
.40476 .2619 Mdot
.40476 .30952 Mdot
.40476 .35714 Mdot
.40476 .40476 Mdot
.40476 .45238 Mdot
.40476 .5 Mdot
.40476 .54762 Mdot
.40476 .59524 Mdot
.40476 .64286 Mdot
.40476 .69048 Mdot
.40476 .7381 Mdot
.40476 .78571 Mdot
.40476 .83333 Mdot
.40476 .88095 Mdot
.40476 .92857 Mdot
.40476 .97619 Mdot
.45238 .02381 Mdot
.45238 .07143 Mdot
.45238 .11905 Mdot
.45238 .16667 Mdot
.45238 .21429 Mdot
.45238 .2619 Mdot
.45238 .30952 Mdot
.45238 .35714 Mdot
.45238 .40476 Mdot
.45238 .45238 Mdot
.45238 .5 Mdot
.45238 .54762 Mdot
.45238 .59524 Mdot
.45238 .64286 Mdot
.45238 .69048 Mdot
.45238 .7381 Mdot
.45238 .78571 Mdot
.45238 .83333 Mdot
.45238 .88095 Mdot
.45238 .92857 Mdot
.45238 .97619 Mdot
.5 .02381 Mdot
.5 .07143 Mdot
.5 .11905 Mdot
.5 .16667 Mdot
.5 .21429 Mdot
.5 .2619 Mdot
.5 .30952 Mdot
.5 .35714 Mdot
.5 .40476 Mdot
.5 .45238 Mdot
.5 .5 Mdot
.5 .54762 Mdot
.5 .59524 Mdot
.5 .64286 Mdot
.5 .69048 Mdot
.5 .7381 Mdot
.5 .78571 Mdot
.5 .83333 Mdot
.5 .88095 Mdot
.5 .92857 Mdot
.5 .97619 Mdot
.54762 .02381 Mdot
.54762 .07143 Mdot
.54762 .11905 Mdot
.54762 .16667 Mdot
.54762 .21429 Mdot
.54762 .2619 Mdot
.54762 .30952 Mdot
.54762 .35714 Mdot
.54762 .40476 Mdot
.54762 .45238 Mdot
.54762 .5 Mdot
.54762 .54762 Mdot
.54762 .59524 Mdot
.54762 .64286 Mdot
.54762 .69048 Mdot
.54762 .7381 Mdot
.54762 .78571 Mdot
.54762 .83333 Mdot
.54762 .88095 Mdot
.54762 .92857 Mdot
.54762 .97619 Mdot
.59524 .02381 Mdot
.59524 .07143 Mdot
.59524 .11905 Mdot
.59524 .16667 Mdot
.59524 .21429 Mdot
.59524 .2619 Mdot
.59524 .30952 Mdot
.59524 .35714 Mdot
.59524 .40476 Mdot
.59524 .45238 Mdot
.59524 .5 Mdot
.59524 .54762 Mdot
.59524 .59524 Mdot
.59524 .64286 Mdot
.59524 .69048 Mdot
.59524 .7381 Mdot
.59524 .78571 Mdot
.59524 .83333 Mdot
.59524 .88095 Mdot
.59524 .92857 Mdot
.59524 .97619 Mdot
.64286 .02381 Mdot
.64286 .07143 Mdot
.64286 .11905 Mdot
.64286 .16667 Mdot
.64286 .21429 Mdot
.64286 .2619 Mdot
.64286 .30952 Mdot
.64286 .35714 Mdot
.64286 .40476 Mdot
.64286 .45238 Mdot
.64286 .5 Mdot
.64286 .54762 Mdot
.64286 .59524 Mdot
.64286 .64286 Mdot
.64286 .69048 Mdot
.64286 .7381 Mdot
.64286 .78571 Mdot
.64286 .83333 Mdot
.64286 .88095 Mdot
.64286 .92857 Mdot
.64286 .97619 Mdot
.69048 .02381 Mdot
.69048 .07143 Mdot
.69048 .11905 Mdot
.69048 .16667 Mdot
.69048 .21429 Mdot
.69048 .2619 Mdot
.69048 .30952 Mdot
.69048 .35714 Mdot
.69048 .40476 Mdot
.69048 .45238 Mdot
.69048 .5 Mdot
.69048 .54762 Mdot
.69048 .59524 Mdot
.69048 .64286 Mdot
.69048 .69048 Mdot
.69048 .7381 Mdot
.69048 .78571 Mdot
.69048 .83333 Mdot
.69048 .88095 Mdot
.69048 .92857 Mdot
.69048 .97619 Mdot
.7381 .02381 Mdot
.7381 .07143 Mdot
.7381 .11905 Mdot
.7381 .16667 Mdot
.7381 .21429 Mdot
.7381 .2619 Mdot
.7381 .30952 Mdot
.7381 .35714 Mdot
.7381 .40476 Mdot
.7381 .45238 Mdot
.7381 .5 Mdot
.7381 .54762 Mdot
.7381 .59524 Mdot
.7381 .64286 Mdot
.7381 .69048 Mdot
.7381 .7381 Mdot
.7381 .78571 Mdot
.7381 .83333 Mdot
.7381 .88095 Mdot
.7381 .92857 Mdot
.7381 .97619 Mdot
.78571 .02381 Mdot
.78571 .07143 Mdot
.78571 .11905 Mdot
.78571 .16667 Mdot
.78571 .21429 Mdot
.78571 .2619 Mdot
.78571 .30952 Mdot
.78571 .35714 Mdot
.78571 .40476 Mdot
.78571 .45238 Mdot
.78571 .5 Mdot
.78571 .54762 Mdot
.78571 .59524 Mdot
.78571 .64286 Mdot
.78571 .69048 Mdot
.78571 .7381 Mdot
.78571 .78571 Mdot
.78571 .83333 Mdot
.78571 .88095 Mdot
.78571 .92857 Mdot
.78571 .97619 Mdot
.83333 .02381 Mdot
.83333 .07143 Mdot
.83333 .11905 Mdot
.83333 .16667 Mdot
.83333 .21429 Mdot
.83333 .2619 Mdot
.83333 .30952 Mdot
.83333 .35714 Mdot
.83333 .40476 Mdot
.83333 .45238 Mdot
.83333 .5 Mdot
.83333 .54762 Mdot
.83333 .59524 Mdot
.83333 .64286 Mdot
.83333 .69048 Mdot
.83333 .7381 Mdot
.83333 .78571 Mdot
.83333 .83333 Mdot
.83333 .88095 Mdot
.83333 .92857 Mdot
.83333 .97619 Mdot
.88095 .02381 Mdot
.88095 .07143 Mdot
.88095 .11905 Mdot
.88095 .16667 Mdot
.88095 .21429 Mdot
.88095 .2619 Mdot
.88095 .30952 Mdot
.88095 .35714 Mdot
.88095 .40476 Mdot
.88095 .45238 Mdot
.88095 .5 Mdot
.88095 .54762 Mdot
.88095 .59524 Mdot
.88095 .64286 Mdot
.88095 .69048 Mdot
.88095 .7381 Mdot
.88095 .78571 Mdot
.88095 .83333 Mdot
.88095 .88095 Mdot
.88095 .92857 Mdot
.88095 .97619 Mdot
.92857 .02381 Mdot
.92857 .07143 Mdot
.92857 .11905 Mdot
.92857 .16667 Mdot
.92857 .21429 Mdot
.92857 .2619 Mdot
.92857 .30952 Mdot
.92857 .35714 Mdot
.92857 .40476 Mdot
.92857 .45238 Mdot
.92857 .5 Mdot
.92857 .54762 Mdot
.92857 .59524 Mdot
.92857 .64286 Mdot
.92857 .69048 Mdot
.92857 .7381 Mdot
.92857 .78571 Mdot
.92857 .83333 Mdot
.92857 .88095 Mdot
.92857 .92857 Mdot
.92857 .97619 Mdot
.97619 .02381 Mdot
.97619 .07143 Mdot
.97619 .11905 Mdot
.97619 .16667 Mdot
.97619 .21429 Mdot
.97619 .2619 Mdot
.97619 .30952 Mdot
.97619 .35714 Mdot
.97619 .40476 Mdot
.97619 .45238 Mdot
.97619 .5 Mdot
.97619 .54762 Mdot
.97619 .59524 Mdot
.97619 .64286 Mdot
.97619 .69048 Mdot
.97619 .7381 Mdot
.97619 .78571 Mdot
.97619 .83333 Mdot
.97619 .88095 Mdot
.97619 .92857 Mdot
.97619 .97619 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{299.062, 299.062},
  ImageMargins->{{48, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004[0001:`P10`4000010?ooooooc?ooZ_ooI_oo
<ooo0?o<ooo<c?o<VC/k>gYjN[Vi^OShn03ooeGooj[ooonI<onI0?mVoomVc?mVVOmVI_mV<omV0?lc
oclo?ginO[fm_Oclo5D00:X00?l00?l0VOl0I_l0<ol00<coolcoc<coVLcoIP<30d92@X61PL30`000
EED0EJX0EOl0ELbIolbIc<bIVLbII/bI<lbI0<aVolaVc0L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0Z/`c
<l`c0<`0ol`0c<`0VL`0I/`0<l`000/;2dY:BXV9RLS8b000oeD0ojX0ool0oiW<VIW<IYW<<iW<09VI
oiVIc9VIVIVIIPl?3di>CXf=SLc<c01E05EE0:YE0?mE09TcoiTcc9TcVITcIYTc<iTc09T0oiT0c1<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEEFKo<fKo06K<ofK<c6K<VFK<IVK<<fK<01LG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZVIVVFIVIVIV<fIV06HcofHcc6HcVFHcIQ/K6eYJFYVIVMSHf01EoeEEojYEoomEoc?o
oc?oc3?oVC?oIS?o<c?o03?<oc?<c1lO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ03>I<c>I03=Voc=Vc3=V
VC=VIS=V<c=V02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZEC<0VC<0IS<0<c<0003oo`3oc03oV@3oIRLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2Io`2Ic02IV@2IIP2I<`2I001Vo`1Vc2/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`0c<`0c0000o`00c000V@00IP00<nh002l_;fi^KZf][Nc/k03o05Go0:[o0?oo0140
003^003M002k002Z0028001g001E03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@00M`00E@00A0008P00
4Nk^k]gMgK^k^cLg=gIfM[Fe]OCdm03oZUGoZZ[oZP0009D000?o0000T`0009D000?o0000T`0009D0
00?o0000T`0009D000?o0000T`0009D000?o0000T`0009D000?o0000T`0000D00ol;00?o3003o`/0
0ol;00?o2`03o`/00ol<00?o2`03o`/00ol400?o1003o`/00ol;00?o3003o`/00ol;00?o2`03o`/0
0ol<00?o2`03o`/00ol700001005o`T01Ol:00Go2@05o`T01Ol900Go2@05o`X01Ol900Go2@05o`H0
00?o00001Ol900Go2@05o`X01Ol900Go2@05o`T01Ol900Go2P05o`T01Ol900Go1P0000@01Ol900Go
2P05o`T01Ol900Go2@05o`T01Ol:00Go2@05o`T01ol40003o`0000Go2@05o`T01Ol:00Go2@05o`T0
1Ol900Go2@05o`X01Ol900Go2@05o`H0000400Go2@05o`X01Ol900Go2@05o`T01Ol900Go2P05o`T0
1Ol900Go1002o`<01Ol900Go2@05o`X01Ol900Go2@05o`T01Ol900Go2P05o`T01Ol900Go1P0000D0
0ol;00?o3003o`/00ol;00?o2`03o`/00ol<00?o2`03o`/00ol70004o`0000?o2`03o`/00ol<00?o
2`03o`/00ol;00?o2`03o``00ol;00?o2`03o`L0002<00?o1P000ol0002C0000U@000ol0002C0000
U@000ol0002C0000U@000ol0002C0000U@000ol0002C0000U@000ol0002C0000U@02oi@0002E0003
o`0009<0002E0003o`0009<0000500?o2`03o``00ol;00?o2`03o`/00ol;00?o3003o`/00ol;00?o
2`03o`/00ol;00?o3003o`/00ol;00?o2`03o`/00ol<00?o2`03o`/00ol700001005o`T01Ol:00Go
2@05o`T01Ol900Go2@05o`X01Ol900Go2@05o`T01Ol900Go2@05o`X01Ol900Go2@05o`T01Ol900Go
2P05o`T01Ol900Go1P0000@01Ol900Go2P05o`T01Ol900Go2@05o`T01Ol:00Go2@05o`T01Ol900Go
2@05o`T01Ol:00Go2@05o`T01Ol900Go2@05o`X01Ol900Go2@05o`H0000400Go2@05o`X01Ol900Go
2@05o`T01Ol900Go2P05o`T01Ol900Go2@05o`T01Ol900Go2P05o`T01Ol900Go2@05o`T01Ol:00Go
2@05o`T01Ol600001@03o`/00ol<00?o2`03o`/00ol;00?o2`03o``00ol;00?o2`03o`/00ol;00?o
2`03o``00ol;00?o2`03o`/00ol;00?o3003o`/00ol;00?o1`0009D000?o0000T`0009D00_nD0000
U@000ol0002C0000U@000ol0002C0000U@000ol0002C0000U@000ol0002C0000U@000ol0002C0000
U@000ol0002C0000U@000ol0002C00001@03o`/00ol<00?o2`03o`/00ol;00?o2`03o``00ol;00?o
2`03o`/00ol;00?o2`03o``00ol;00?o2`03o`/00ol;00?o3003o`/00ol;00?o1`0000@01Ol900Go
2P05o`T01Ol900Go2@05o`T01Ol:00Go2@05o`T01Ol900Go2@05o`T01Ol:00Go2@05o`T01Ol900Go
2@05o`X01Ol900Go2@05o`H0000400Go2@05o`X01Ol900Go2@05o`T01Ol900Go2P05o`T01Ol900Go
2@05o`T01Ol900Go2P05o`T01Ol900Go2@05o`T01Ol:00Go2@05o`T01Ol600001005o`T01Ol:00Go
2@05o`T01Ol900Go2@05o`X01Ol900Go2@05o`T01Ol900Go2@05o`X01Ol900Go2@05o`T01Ol900Go
2P05o`T01Ol900Go1P0000D00ol;00?o3003o`/00ol;00?o2`03o`/00ol<00?o2`03o`/00ol;00?o
2`03o`/00ol<00?o2`03o`/00ol;00?o2`03o``00ol;00?o2`03o`L0002E0003o`0009<0002E0003
o`0009<0002E0003o`0009<0002E0003o`0009<0002E0003o`0009<0002E0003o`0009<0002E00;o
U00009D000?o0000T`0009D000?o0000T`0009D000?o0000T`0000D00ol;00?o3003o`/00ol;00?o
2`03o`/00ol<00?o2`03o`/00ol;00?o2`03o`/00ol<00?o2`03o`/00ol;00?o2`03o``00ol;00?o
2`03o`L0000400Go2@05o`X01Ol900Go2@05o`T01Ol900Go2P05o`T01Ol900Go2@05o`T01Ol900Go
2P05o`T01Ol900Go2@05o`T01Ol:00Go2@05o`T01Ol600001005o`T01Ol:00Go2@05o`T01Ol900Go
2@05o`X01Ol900Go2@05o`T01Ol900Go2@05o`X01Ol900Go2@05o`T01Ol900Go2P05o`T01Ol900Go
1P0000@01Ol900Go2P05o`T01Ol900Go2@05o`T01Ol:00Go2@05o`T01Ol900Go2@05o`T01Ol:00Go
2@05o`T01Ol900Go2@05o`X01Ol900Go2@05o`H0000500?o2`03o``00ol;00?o2`03o`/00ol;00?o
3003o`/00ol;00?o1004o`<00ol;00?o2`03o``00ol;00?o2`03o`/00ol;00?o3003o`/00ol;00?o
1`0008d000?o00001@000ol0002C0000QP05o`<000?o00001002oi@0002?0003o`0000<000?o0000
T`0008`000Co003o1@000ol0002C0000S@02o`H000?o0000T`0009D000?o0000T`0009D000?o0000
T`0009D000?o0000T`0009D000?o0000T`0000D00ol;00?o3003o`/00ol;00?o2`03o`/00ol<00?o
2`03o`/00ol;00?o2`03o`/00ol<00?o2`03o`/00ol;00?o2`03o``00ol;00?o2`03o`L0000400Go
2@05o`X01Ol900Go2@05o`T01Ol900Go2P05o`T01Ol900Go2@05o`T01Ol900Go2P05o`T01Ol900Go
2@05o`T01Ol:00Go2@05o`T01Ol600001005o`T01Ol:00Go2@05o`T01Ol900Go2@05o`X01Ol900Go
2@05o`T01Ol900Go2@05o`X01Ol900Go2@05o`T01Ol900Go2P05o`T01Ol900Go1P0000@01Ol900Go
2P05o`T01Ol900Go2@05o`T01Ol:00Go2@05o`T01Ol900Go2@05o`T01Ol:00Go2@05o`T01Ol900Go
2@05o`X01Ol900Go2@05o`H0000500?o2`03o``00ol;00?o2`03o`/00ol;00?o3003o`/00ol;00?o
2`03o`/00ol;00?o3003o`/00ol;00?o2`03o`/00ol<00?o2`03o`/00ol70000U@000ol0002C0000
U@000ol0002C0000U@000ol0002C0000U@000ol0002C0000U@000ol0002C0000U@000ol0002C0000
U@02oi@0002E0003o`0009<0002E0003o`0009<0000500?o2`03o``00ol;00?o2`03o`/00ol;00?o
3003o`/00ol;00?o2`03o`/00ol;00?o3003o`/00ol;00?o2`03o`/00ol<00?o2`03o`/00ol70000
1005o`T01Ol:00Go2@05o`T01Ol900Go2@05o`X01Ol900Go2@05o`T01Ol900Go2@05o`X01Ol900Go
2@05o`T01Ol900Go2P05o`T01Ol900Go1P0000@01Ol900Go2P05o`T01Ol900Go2@05o`T01Ol:00Go
2@05o`T01Ol900Go2@05o`T01Ol:00Go2@05o`T01Ol900Go2@05o`X01Ol900Go2@05o`H0000400Go
2@05o`X01Ol900Go2@05o`T01Ol900Go2P05o`T01Ol900Go2@05o`T01Ol900Go2P05o`T01Ol900Go
2@05o`T01Ol:00Go2@05o`T01Ol600001@03o`/00ol<00?o2`03o`/00ol;00?o2`03o``00ol;00?o
2`03o`/00ol;00?o2`03o``00ol;00?o2`03o`/00ol;00?o3003o`/00ol;00?o1`0009D000?o0000
T`0009D00_nD0000U@000ol0002C0000U@000ol0002C0000U@000ol0002C0000U@000ol0002C0000
U@000ol0002C0000U@000ol0002C0000U@000ol0002C00001@03o`/00ol<00?o2`03o`/00ol;00?o
2`03o``00ol;00?o2`03o`/00ol;00?o2`03o``00ol;00?o2`03o`/00ol;00?o3003o`/00ol;00?o
1`0000@01Ol900Go2P05o`T01Ol900Go2@05o`T01Ol:00Go2@05o`T01Ol900Go2@05o`T01Ol:00Go
2@05o`T01Ol900Go2@05o`X01Ol900Go2@05o`H0000400Go2@05o`X01Ol900Go2@05o`T01Ol900Go
2P05o`T01Ol900Go2@05o`T01Ol900Go2P05o`T01Ol900Go2@05o`T01Ol:00Go2@05o`T01Ol60000
1005o`T01Ol:00Go2@05o`T01Ol900Go2@05o`X01Ol900Go2@05o`T01Ol900Go2@05o`X01Ol900Go
2@05o`T01Ol900Go2P05o`T01Ol900Go1P0000D00ol;00?o3003o`/00ol;00?o2`03o`/00ol<00?o
2`03o`/00ol;00?o2`03o`/00ol<00?o2`03o`/00ol;00?o2`03o``00ol;00?o2`03o`L0002E0003
o`0009<0002E0003o`0009<0002E0003o`0009<0002E0003o`0009<0002<00?o1P000ol0002C0000
S@000ol000050003o`0009<0002600Go0P000ol0000500;oU00008d000?o00001@000ol0002C0000
S@000ol000050003o`0009<0000500?o2`03o``00ol;00?o2`03o`/00ol;00?o3003o`/00ol;00?o
1002o`D00ol;00?o2`03o``00ol;00?o2`03o`/00ol;00?o3003o`/00ol;00?o1`0000@01Ol900Go
2P05o`T01Ol900Go2@05o`T01Ol:00Go2@05o`T01Ol900Go2@05o`T01Ol:00Go2@05o`T01Ol900Go
2@05o`X01Ol900Go2@05o`H0000400Go2@05o`X01Ol900Go2@05o`T01Ol900Go2P05o`T01Ol900Go
2@05o`T01Ol900Go2P05o`T01Ol900Go2@05o`T01Ol:00Go2@05o`T01Ol600001005o`T01Ol:00Go
2@05o`T01Ol900Go2@05o`X01Ol900Go2@05o`T01Ol900Go2@05o`X01Ol900Go2@05o`T01Ol900Go
2P05o`T01Ol900Go1P0000D00ol;00?o3003o`/00ol;00?o2`03o`/00ol<00?o2`03o`/00ol;00?o
2`03o`/00ol<00?o2`03o`/00ol;00?o2`03o``00ol;00?o2`03o`L0002E0003o`0009<0002E0003
o`0009<0002E00;oU00009D000?o0000T`0009D000?o0000T`0009D000?o0000T`0009D000?o0000
T`0009D000?o0000T`0009D000?o0000T`0009D000?o0000T`0000D00ol;00?o3003o`/00ol;00?o
2`03o`/00ol<00?o2`03o`/00ol;00?o2`03o`/00ol<00?o2`03o`/00ol;00?o2`03o``00ol;00?o
2`03o`L0000400Go2@05o`X01Ol900Go2@05o`T01Ol900Go2P05o`T01Ol900Go2@05o`T01Ol900Go
2P05o`T01Ol900Go2@05o`T01Ol:00Go2@05o`T01Ol600001005o`T01Ol:00Go2@05o`T01Ol900Go
2@05o`X01Ol900Go2@05o`T01Ol900Go2@05o`X01Ol900Go2@05o`T01Ol900Go2P05o`T01Ol900Go
1P0000@01Ol900Go2P05o`T01Ol900Go2@05o`T01Ol:00Go2@05o`T01Ol900Go2@05o`T01Ol:00Go
2@05o`T01Ol900Go2@05o`X01Ol900Go2@05o`H0000500?o2`03o``00ol;00?o2`03o`/00ol;00?o
3003o`/00ol;00?o2`03o`/00ol;00?o3003o`/00ol;00?o2`03o`/00ol<00?o2`03o`/00ol70000
U@000ol0002C0000U@000ol0002C0000U@000ol0002C0000U@000ol0002C0000U@000ol0002C0000
U@000ol0002C0000U@02oi@0002E0003o`0009<0002E0003o`0009<0000500?o2`03o``00ol;00?o
2`03o`/00ol;00?o3003o`/00ol;00?o2`03o`/00ol;00?o3003o`/00ol;00?o2`03o`/00ol<00?o
2`03o`/00ol700001005o`T01Ol:00Go2@05o`T01Ol900Go2@05o`X01Ol900Go2@05o`T01Ol900Go
2@05o`X01Ol900Go2@05o`T01Ol900Go2P05o`T01Ol900Go1P0000@01Ol900Go2P05o`T01Ol900Go
2@05o`T01Ol:00Go2@05o`T01Ol900Go2@05o`T01Ol:00Go2@05o`T01Ol900Go2@05o`X01Ol900Go
2@05o`H0000400Go2@05o`X01Ol900Go2@05o`T01Ol900Go2P05o`T01Ol900Go2@05o`T01Ol900Go
2P05o`T01Ol900Go2@05o`T01Ol:00Go2@05o`T01Ol600001@03o`/00ol<00?o2`03o`/00ol;00?o
2`03o``00ol;00?o2`03o`/00ol;00?o2`03o``00ol;00?o2`03o`/00ol;00?o3003o`/00ol;00?o
1`0000P00ol/00Co:`03ob`000?o0000:P03ob`01?l[00?o200000/000?o0000:P000ol0000/0003
o`0002/00_l/0003o`0002`000?o0000;P000ol0000500000P05o`@000?o00008`05o`<000?o0000
9005o`8000?o0000:`000ol0000[0003o`0002d000?o0000;@000ol0000500002@02obl000?o0000
:P000ol0000[0003o`0002/000?o0000;P000ol0000Z00;o200000/000?o0000:@001?l00?l/0003
o`0002/000?o0000:`000ol0000[0004o`00obh000?o00001@0000P00ol]00;o;002obd000?o0000
:P02obh00_l/00?o200009D000?o0000T`0009D000?o0000T`0009D000?o0000T`0000D00ol;00?o
3003o`/00ol;00?o2`03o`/00ol<00?o2`03o`/00ol;00?o2`03o`/00ol<00?o2`03o`/00ol;00?o
2`03o``00ol;00?o2`03o`L0003oobco000400Go1`000ol0o`04o`<000?o00001005o`H000?o0000
1Ol20003o`0000@01Ol70003o`3o00Co0P000ol0000400Go1`000ol00005o`8000?o00001005o`L0
00?o0?l01?l20003o`0000@01Ol70003o`3o00Co0P000ol0000400Go1`000ol00005o`8000?o0000
1005o`L000?o0?l01?l20003o`0000@01Ol70003o`3o00Co0`000ol0000400Go1`000ol0o`04o`80
00?o00001005o`H0000400Go1`000ol0o`04o`<000?o00001005o`H000?o00001Ol20003o`0000@0
1Ol70003o`3o00Co0P000ol0000400Go1`000ol00005o`8000?o00001005o`L000?o0?l01?l20003
o`0000@01Ol70003o`3o00Co0P000ol0000400Go1`000ol00005o`8000?o00001005o`L000?o0?l0
1?l20003o`0000@01Ol70003o`3o00Co0`000ol0000400Go1`000ol0o`04o`8000?o00001005o`H0
000500?o2`03o``00ol;00?o2`03o`/00ol;00?o3003o`/00ol;00?o2`03o`/00ol;00?o3003o`/0
0ol;00?o2`03o`/00ol<00?o2`03o`/00ol70000U@000ol0002C0000U@000ol0002C0000U@000ol0
002C0000U@000ol0002C0000U@000ol0002C0000U@000ol0002C0000U@02oi@0002E0003o`0009<0
002E0003o`0009<0000500?o2`03o``00ol;00?o2`03o`/00ol;00?o3003o`/00ol;00?o2`03o`/0
0ol;00?o3003o`/00ol;00?o2`03o`/00ol<00?o2`03o`/00ol700001005o`T01Ol:00Go2@05o`T0
1Ol900Go2@05o`X01Ol900Go2@05o`T01Ol900Go2@05o`X01Ol900Go2@05o`T01Ol900Go2P05o`T0
1Ol900Go1P0000@01Ol900Go2P05o`T01Ol900Go2@05o`T01Ol:00Go2@05o`T01Ol900Go2@05o`T0
1Ol:00Go2@05o`T01Ol900Go2@05o`X01Ol900Go2@05o`H0000400Go2@05o`X01Ol900Go2@05o`T0
1Ol900Go2P05o`T01Ol900Go2@05o`T01Ol900Go2P05o`T01Ol900Go2@05o`T01Ol:00Go2@05o`T0
1Ol600001@03o`/00ol<00?o2`03o`/00ol;00?o2`03o``00ol;00?o2`03o`/00ol;00?o2`03o``0
0ol;00?o2`03o`/00ol;00?o3003o`/00ol;00?o1`0009D000?o0000T`0009D00_nD0000U@000ol0
002C0000U@000ol0002C0000U@000ol0002C0000U@000ol0002C0000U@000ol0002C0000U@000ol0
002C0000U@000ol0002C00001@03o`/00ol<00?o2`03o`/00ol;00?o2`03o``00ol;00?o2`03o`/0
0ol;00?o2`03o``00ol;00?o2`03o`/00ol;00?o3003o`/00ol;00?o1`0000@01Ol900Go2P05o`T0
1Ol900Go2@05o`T01Ol:00Go2@05o`T01Ol900Go2@05o`T01Ol:00Go2@05o`T01Ol900Go2@05o`X0
1Ol900Go2@05o`H0000400Go2@05o`X01Ol900Go2@05o`T01Ol900Go2P05o`T01Ol900Go2@05o`T0
1Ol900Go2P05o`T01Ol900Go2@05o`T01Ol:00Go2@05o`T01Ol600001005o`T01Ol:00Go2@05o`T0
1Ol900Go2@05o`X01Ol900Go2@05o`T01Ol900Go2@05o`X01Ol900Go2@05o`T01Ol900Go2P05o`T0
1Ol900Go1P0000D00ol;00?o3003o`/00ol;00?o2`03o`/00ol<00?o2`03o`/00ol;00?o2`03o`/0
0ol<00?o2`03o`/00ol;00?o2`03o``00ol;00?o2`03o`L0002E0003o`0009<0002E0003o`0009<0
002E0003o`0009<0002E0003o`0009<0002E0003o`0009<0002E0003o`0009<0002E00;oU00009D0
00?o0000T`0009D000?o0000T`0000D00ol;00?o3003o`/00ol;00?o2`03o`/00ol<00?o2`03o`/0
0ol;00?o2`03o`/00ol<00?o2`03o`/00ol;00?o2`03o``00ol;00?o2`03o`L0000400Go2@05o`X0
1Ol900Go2@05o`T01Ol900Go2P05o`T01Ol900Go2@05o`T01Ol900Go2P05o`T01Ol900Go2@05o`T0
1Ol:00Go2@05o`T01Ol600001005o`T01Ol:00Go2@05o`T01Ol900Go2@05o`X01Ol900Go2@05o`T0
1Ol900Go2@05o`X01Ol900Go2@05o`T01Ol900Go2P05o`T01Ol900Go1P0000@01Ol900Go2P05o`T0
1Ol900Go2@05o`T01Ol:00Go2@05o`T01Ol900Go2@05o`T01Ol:00Go2@05o`T01Ol900Go2@05o`X0
1Ol900Go2@05o`H0000500?o2`03o``00ol;00?o2`03o`/00ol;00?o3003o`/00ol;00?o2`03o`/0
0ol;00?o3003o`/00ol;00?o2`03o`/00ol<00?o2`03o`/00ol70000S003o`H000?o0000T`0008d0
00?o00001@000ol0002C0000S@000ol0000500;oU00008d000?o00001@000ol0002C0000S@000ol0
00050003o`0009<0002<00;o1`000ol0002C0000U@000ol0002C0000U@000ol0002C0000U@000ol0
002C0000U@000ol0002C00001@03o`/00ol<00?o2`03o`/00ol;00?o2`03o``00ol;00?o2`03o`/0
0ol;00?o2`03o``00ol;00?o2`03o`/00ol;00?o3003o`/00ol;00?o1`0000@01Ol900Go2P05o`T0
1Ol900Go2@05o`T01Ol:00Go2@05o`T01Ol900Go2@05o`T01Ol:00Go2@05o`T01Ol900Go2@05o`X0
1Ol900Go2@05o`H0000400Go2@05o`X01Ol900Go2@05o`T01Ol900Go2P05o`T01Ol900Go2@05o`T0
1Ol900Go2P05o`T01Ol900Go2@05o`T01Ol:00Go2@05o`T01Ol600001005o`T01Ol:00Go2@05o`T0
1Ol900Go2@05o`X01Ol900Go2@05o`T01Ol900Go2@05o`X01Ol900Go2@05o`T01Ol900Go2P05o`T0
1Ol900Go1P0000D00ol;00?o3003o`/00ol;00?o2`03o`/00ol<00?o2`03o`/00ol;00?o2`03o`/0
0ol<00?o2`03o`/00ol;00?o2`03o``00ol;00?o2`03o`L0002E0003o`0009<0002E0003o`0009<0
002E0003o`0009<0002E0003o`0009<0002E0003o`0009<0002E0003o`0009<0002E00;oU00009D0
00?o0000T`0009D000?o0000T`0000D00ol;00?o3003o`/00ol;00?o2`03o`/00ol<00?o2`03o`/0
0ol;00?o2`03o`/00ol<00?o2`03o`/00ol;00?o2`03o``00ol;00?o2`03o`L0000400Go2@05o`X0
1Ol900Go2@05o`T01Ol900Go2P05o`T01Ol900Go2@05o`T01Ol900Go2P05o`T01Ol900Go2@05o`T0
1Ol:00Go2@05o`T01Ol600001005o`T01Ol:00Go2@05o`T01Ol900Go2@05o`X01Ol900Go2@05o`T0
1Ol900Go2@05o`X01Ol900Go2@05o`T01Ol900Go2P05o`T01Ol900Go1P0000@01Ol900Go2P05o`T0
1Ol900Go2@05o`T01Ol:00Go2@05o`T01Ol900Go2@05o`T01Ol:00Go2@05o`T01Ol900Go2@05o`X0
1Ol900Go2@05o`H0000500?o2`03o``00ol;00?o2`03o`/00ol;00?o3003o`/00ol;00?o2`03o`/0
0ol;00?o3003o`/00ol;00?o2`03o`/00ol<00?o2`03o`/00ol70000U@000ol0002C0000U@02oi@0
002E0003o`0009<0002E0003o`0009<0002E0003o`0009<0002E0003o`0009<0002E0003o`0009<0
002E0003o`0009<0002E0003o`0009<0000500?o2`03o``00ol;00?o2`03o`/00ol;00?o3003o`/0
0ol;00?o2`03o`/00ol;00?o3003o`/00ol;00?o2`03o`/00ol<00?o2`03o`/00ol700001005o`T0
1Ol:00Go2@05o`T01Ol900Go2@05o`X01Ol900Go2@05o`T01Ol900Go2@05o`X01Ol900Go2@05o`T0
1Ol900Go2P05o`T01Ol900Go1P0000@01Ol900Go2P05o`T01Ol900Go2@05o`T01Ol:00Go2@05o`T0
1Ol900Go2@05o`T01Ol:00Go2@05o`T01Ol900Go2@05o`X01Ol900Go2@05o`H0000400Go2@05o`X0
1Ol900Go2@05o`T01Ol900Go2P05o`T01Ol900Go2@05o`T01Ol900Go2P05o`T01Ol900Go2@05o`T0
1Ol:00Go2@05o`T01Ol600001@03o`/00ol<00?o2`03o`/00ol;00?o2`03o``00ol;00?o2`03o`/0
0ol;00?o2`03o``00ol;00?o2`03o`/00ol;00?o3003o`/00ol;00?o1`0009D000?o0000T`0009D0
00?o0000T`0009D000?o0000T`0009D000?o0000T`0008`01?l50003o`0009<0002=0003o`0000D0
00?o0000T`0008h000?o00001002oi@0002?0003o`0000<000?o0000T`0008`000Co003o1@000ol0
002C00001@03o`/00ol<00?o2`03o`/00ol;00?o2`03o``00ol;00?o2`03o`D00_l400?o2`03o`/0
0ol<00?o2`03o`/00ol;00?o2`03o``00ol;00?o2`03o`L0000400Go2@05o`X01Ol900Go2@05o`T0
1Ol900Go2P05o`T01Ol900Go2@05o`T01Ol900Go2P05o`T01Ol900Go2@05o`T01Ol:00Go2@05o`T0
1Ol600001005o`T01Ol:00Go2@05o`T01Ol900Go2@05o`X01Ol900Go2@05o`T01Ol900Go2@05o`X0
1Ol900Go2@05o`T01Ol900Go2P05o`T01Ol900Go1P0000@01Ol900Go2P05o`T01Ol900Go2@05o`T0
1Ol:00Go2@05o`T01Ol900Go2@05o`T01Ol:00Go2@05o`T01Ol900Go2@05o`X01Ol900Go2@05o`H0
000500?o2`03o``00ol;00?o2`03o`/00ol;00?o3003o`/00ol;00?o2`03o`/00ol;00?o3003o`/0
0ol;00?o2`03o`/00ol<00?o2`03o`/00ol70000U@000ol0002C0000U@000ol0002C0000U@02oi@0
002E0003o`0009<0002E0003o`0009<0002E0003o`0009<0002E0003o`0009<0002E0003o`0009<0
002E0003o`0009<0000500?o2`03o``00ol;00?o2`03o`/00ol;00?o3003o`/00ol;00?o2`03o`/0
0ol;00?o3003o`/00ol;00?o2`03o`/00ol<00?o2`03o`/00ol700001005o`T01Ol:00Go2@05o`T0
1Ol900Go2@05o`X01Ol900Go2@05o`T01Ol900Go2@05o`X01Ol900Go2@05o`T01Ol900Go2P05o`T0
1Ol900Go1P0000@01Ol900Go2P05o`T01Ol900Go2@05o`T01Ol:00Go2@05o`T01Ol900Go2@05o`T0
1Ol:00Go2@05o`T01Ol900Go2@05o`X01Ol900Go2@05o`H0000400Go2@05o`X01Ol900Go2@05o`T0
1Ol900Go2P05o`T01Ol900Go2@05o`T01Ol900Go2P05o`T01Ol900Go2@05o`T01Ol:00Go2@05o`T0
1Ol600001@03o`/00ol<00?o2`03o`/00ol;00?o2`03o``00ol;00?o2`03o`/00ol;00?o2`03o``0
0ol;00?o2`03o`/00ol;00?o3003o`/00ol;00?o1`0009D000?o0000T`0009D000?o0000T`0009D0
00?o0000T`0009D000?o0000T`0009D000?o0000T`0009D000?o0000T`0009D00_nD0000U@000ol0
002C0000U@000ol0002C0000U@000ol0002C00001@03o`/00ol<00?o2`03o`/00ol;00?o2`03o``0
0ol;00?o2`03o`/00ol;00?o2`03o``00ol;00?o2`03o`/00ol;00?o3003o`/00ol;00?o1`0000@0
1Ol900Go2P05o`T01Ol900Go2@05o`T01Ol:00Go2@05o`T01Ol900Go2@05o`T01Ol:00Go2@05o`T0
1Ol900Go2@05o`X01Ol900Go2@05o`H0000400Go2@05o`X01Ol900Go2@05o`T01Ol900Go2P05o`T0
1Ol900Go2@05o`T01Ol900Go2P05o`T01Ol900Go2@05o`T01Ol:00Go2@05o`T01Ol600001005o`T0
1Ol:00Go2@05o`T01Ol900Go2@05o`X01Ol900Go2@05o`T01Ol900Go2@05o`X01Ol900Go2@05o`T0
1Ol900Go2P05o`T01Ol900Go1P0000D00ol;00?o3003o`/00ol;00?o2`03o`/00ol<00?o2`03o`/0
0ol;00?o2`03o`/00ol<00?o2`03o`/00ol;00?o2`03o``00ol;00?o2`03o`L0002E0003o`0009<0
002E00;oU00009D000?o0000T`0009D000?o0000T`0009D000?o0000T`0009D000?o0000T`0009D0
00?o0000T`0009D000?o0000T`0008`00ol60003o`0009<0000500?o2`03o``00ol;00?o2`03o`/0
0ol;00?o3003o`/00ol;00?o1`001?l00003o`/00ol;00?o3003o`/00ol;00?o2`03o`/00ol<00?o
2`03o`/00ol700001005o`T01Ol:00Go2@05o`T01Ol900Go2@05o`X01Ol900Go2@05o`H000?o0000
1Ol900Go2@05o`X01Ol900Go2@05o`T01Ol900Go2P05o`T01Ol900Go1P0000@01Ol900Go2P05o`T0
1Ol900Go2@05o`T01Ol:00Go2@05o`T01Ol400;o0`05o`T01Ol900Go2P05o`T01Ol900Go2@05o`T0
1Ol:00Go2@05o`T01Ol600001005o`T01Ol:00Go2@05o`T01Ol900Go2@05o`X01Ol900Go2@05o`H0
00?o00001Ol900Go2@05o`X01Ol900Go2@05o`T01Ol900Go2P05o`T01Ol900Go1P0000D00ol;00?o
3003o`/00ol;00?o2`03o`/00ol<00?o2`03o`/00ol400?o1003o`/00ol;00?o3003o`/00ol;00?o
2`03o`/00ol<00?o2`03o`/00ol70000U@000ol0002C0000U@000ol0002C0000U@000ol0002C0000
U@000ol0002C0000\
\>"],
  ImageRangeCache->{{{0, 298.062}, {298.062, 0}} -> {-3.15003, -3.15003, 
  0.0211367, 0.0211367}}]
}, Closed]],

Cell[TextData[{
  "Here is a predicate function that accepts an ordered pair and returns ",
  StyleBox["True", "Input"],
  " if the sine of the horizontal coordinate is less than the sine of the \
vertical coordinate."
}], "Text"],

Cell[BoxData[
    \(inRegionsQ[{x_, y_}] := Sin[x] < Sin[y]\)], "Input"],

Cell[TextData[{
  "We use ",
  StyleBox["Select", "Input"],
  " to extract the points that satisfy ",
  StyleBox["inRegionsQ", "Input"],
  ". The following is a shortened version of the output."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Short[Select[pts, inRegionsQ], 3]\)], "Input"],

Cell[BoxData[
    TagBox[
      \({{\(-3\), 0.`}, {\(-3\), 0.299999999999999822`}, {\(-3\), 
          0.599999999999999644`}, 
        \[LeftSkeleton]205\[RightSkeleton], {3.`, 2.39999999999999946`}, {
          3.`, 2.70000000000000017`}}\),
      (Short[ #, 3]&)]], "Output"]
}, Closed]],

Cell[TextData[{
  "Here is a plot of the points that satisfy ",
  StyleBox["inRegionsQ", "Input"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(ListPlot[Select[pts, inRegionsQ], AspectRatio \[Rule] 1, 
      PlotStyle \[Rule] PointSize[0.02]]; \)\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.5 0.15873 [
[.02381 .4875 -6 -9 ]
[.02381 .4875 6 0 ]
[.18254 .4875 -6 -9 ]
[.18254 .4875 6 0 ]
[.34127 .4875 -6 -9 ]
[.34127 .4875 6 0 ]
[.65873 .4875 -3 -9 ]
[.65873 .4875 3 0 ]
[.81746 .4875 -3 -9 ]
[.81746 .4875 3 0 ]
[.97619 .4875 -3 -9 ]
[.97619 .4875 3 0 ]
[.4875 .02381 -12 -4.5 ]
[.4875 .02381 0 4.5 ]
[.4875 .18254 -12 -4.5 ]
[.4875 .18254 0 4.5 ]
[.4875 .34127 -12 -4.5 ]
[.4875 .34127 0 4.5 ]
[.4875 .65873 -6 -4.5 ]
[.4875 .65873 0 4.5 ]
[.4875 .81746 -6 -4.5 ]
[.4875 .81746 0 4.5 ]
[.4875 .97619 -6 -4.5 ]
[.4875 .97619 0 4.5 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .5 m
.02381 .50625 L
s
[(-3)] .02381 .4875 0 1 Mshowa
.18254 .5 m
.18254 .50625 L
s
[(-2)] .18254 .4875 0 1 Mshowa
.34127 .5 m
.34127 .50625 L
s
[(-1)] .34127 .4875 0 1 Mshowa
.65873 .5 m
.65873 .50625 L
s
[(1)] .65873 .4875 0 1 Mshowa
.81746 .5 m
.81746 .50625 L
s
[(2)] .81746 .4875 0 1 Mshowa
.97619 .5 m
.97619 .50625 L
s
[(3)] .97619 .4875 0 1 Mshowa
.125 Mabswid
.05556 .5 m
.05556 .50375 L
s
.0873 .5 m
.0873 .50375 L
s
.11905 .5 m
.11905 .50375 L
s
.15079 .5 m
.15079 .50375 L
s
.21429 .5 m
.21429 .50375 L
s
.24603 .5 m
.24603 .50375 L
s
.27778 .5 m
.27778 .50375 L
s
.30952 .5 m
.30952 .50375 L
s
.37302 .5 m
.37302 .50375 L
s
.40476 .5 m
.40476 .50375 L
s
.43651 .5 m
.43651 .50375 L
s
.46825 .5 m
.46825 .50375 L
s
.53175 .5 m
.53175 .50375 L
s
.56349 .5 m
.56349 .50375 L
s
.59524 .5 m
.59524 .50375 L
s
.62698 .5 m
.62698 .50375 L
s
.69048 .5 m
.69048 .50375 L
s
.72222 .5 m
.72222 .50375 L
s
.75397 .5 m
.75397 .50375 L
s
.78571 .5 m
.78571 .50375 L
s
.84921 .5 m
.84921 .50375 L
s
.88095 .5 m
.88095 .50375 L
s
.9127 .5 m
.9127 .50375 L
s
.94444 .5 m
.94444 .50375 L
s
.25 Mabswid
0 .5 m
1 .5 L
s
.5 .02381 m
.50625 .02381 L
s
[(-3)] .4875 .02381 1 0 Mshowa
.5 .18254 m
.50625 .18254 L
s
[(-2)] .4875 .18254 1 0 Mshowa
.5 .34127 m
.50625 .34127 L
s
[(-1)] .4875 .34127 1 0 Mshowa
.5 .65873 m
.50625 .65873 L
s
[(1)] .4875 .65873 1 0 Mshowa
.5 .81746 m
.50625 .81746 L
s
[(2)] .4875 .81746 1 0 Mshowa
.5 .97619 m
.50625 .97619 L
s
[(3)] .4875 .97619 1 0 Mshowa
.125 Mabswid
.5 .05556 m
.50375 .05556 L
s
.5 .0873 m
.50375 .0873 L
s
.5 .11905 m
.50375 .11905 L
s
.5 .15079 m
.50375 .15079 L
s
.5 .21429 m
.50375 .21429 L
s
.5 .24603 m
.50375 .24603 L
s
.5 .27778 m
.50375 .27778 L
s
.5 .30952 m
.50375 .30952 L
s
.5 .37302 m
.50375 .37302 L
s
.5 .40476 m
.50375 .40476 L
s
.5 .43651 m
.50375 .43651 L
s
.5 .46825 m
.50375 .46825 L
s
.5 .53175 m
.50375 .53175 L
s
.5 .56349 m
.50375 .56349 L
s
.5 .59524 m
.50375 .59524 L
s
.5 .62698 m
.50375 .62698 L
s
.5 .69048 m
.50375 .69048 L
s
.5 .72222 m
.50375 .72222 L
s
.5 .75397 m
.50375 .75397 L
s
.5 .78571 m
.50375 .78571 L
s
.5 .84921 m
.50375 .84921 L
s
.5 .88095 m
.50375 .88095 L
s
.5 .9127 m
.50375 .9127 L
s
.5 .94444 m
.50375 .94444 L
s
.25 Mabswid
.5 0 m
.5 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
.02 w
.02381 .5 Mdot
.02381 .54762 Mdot
.02381 .59524 Mdot
.02381 .64286 Mdot
.02381 .69048 Mdot
.02381 .7381 Mdot
.02381 .78571 Mdot
.02381 .83333 Mdot
.02381 .88095 Mdot
.02381 .92857 Mdot
.02381 .97619 Mdot
.07143 .02381 Mdot
.07143 .45238 Mdot
.07143 .5 Mdot
.07143 .54762 Mdot
.07143 .59524 Mdot
.07143 .64286 Mdot
.07143 .69048 Mdot
.07143 .7381 Mdot
.07143 .78571 Mdot
.07143 .83333 Mdot
.07143 .88095 Mdot
.07143 .92857 Mdot
.07143 .97619 Mdot
.11905 .02381 Mdot
.11905 .07143 Mdot
.11905 .40476 Mdot
.11905 .45238 Mdot
.11905 .5 Mdot
.11905 .54762 Mdot
.11905 .59524 Mdot
.11905 .64286 Mdot
.11905 .69048 Mdot
.11905 .7381 Mdot
.11905 .78571 Mdot
.11905 .83333 Mdot
.11905 .88095 Mdot
.11905 .92857 Mdot
.11905 .97619 Mdot
.16667 .02381 Mdot
.16667 .07143 Mdot
.16667 .11905 Mdot
.16667 .35714 Mdot
.16667 .40476 Mdot
.16667 .45238 Mdot
.16667 .5 Mdot
.16667 .54762 Mdot
.16667 .59524 Mdot
.16667 .64286 Mdot
.16667 .69048 Mdot
.16667 .7381 Mdot
.16667 .78571 Mdot
.16667 .83333 Mdot
.16667 .88095 Mdot
.16667 .92857 Mdot
.16667 .97619 Mdot
.21429 .02381 Mdot
.21429 .07143 Mdot
.21429 .11905 Mdot
.21429 .16667 Mdot
.21429 .30952 Mdot
.21429 .35714 Mdot
.21429 .40476 Mdot
.21429 .45238 Mdot
.21429 .5 Mdot
.21429 .54762 Mdot
.21429 .59524 Mdot
.21429 .64286 Mdot
.21429 .69048 Mdot
.21429 .7381 Mdot
.21429 .78571 Mdot
.21429 .83333 Mdot
.21429 .88095 Mdot
.21429 .92857 Mdot
.21429 .97619 Mdot
.2619 .02381 Mdot
.2619 .07143 Mdot
.2619 .11905 Mdot
.2619 .16667 Mdot
.2619 .21429 Mdot
.2619 .30952 Mdot
.2619 .35714 Mdot
.2619 .40476 Mdot
.2619 .45238 Mdot
.2619 .5 Mdot
.2619 .54762 Mdot
.2619 .59524 Mdot
.2619 .64286 Mdot
.2619 .69048 Mdot
.2619 .7381 Mdot
.2619 .78571 Mdot
.2619 .83333 Mdot
.2619 .88095 Mdot
.2619 .92857 Mdot
.2619 .97619 Mdot
.30952 .02381 Mdot
.30952 .07143 Mdot
.30952 .11905 Mdot
.30952 .16667 Mdot
.30952 .35714 Mdot
.30952 .40476 Mdot
.30952 .45238 Mdot
.30952 .5 Mdot
.30952 .54762 Mdot
.30952 .59524 Mdot
.30952 .64286 Mdot
.30952 .69048 Mdot
.30952 .7381 Mdot
.30952 .78571 Mdot
.30952 .83333 Mdot
.30952 .88095 Mdot
.30952 .92857 Mdot
.30952 .97619 Mdot
.35714 .02381 Mdot
.35714 .07143 Mdot
.35714 .11905 Mdot
.35714 .40476 Mdot
.35714 .45238 Mdot
.35714 .5 Mdot
.35714 .54762 Mdot
.35714 .59524 Mdot
.35714 .64286 Mdot
.35714 .69048 Mdot
.35714 .7381 Mdot
.35714 .78571 Mdot
.35714 .83333 Mdot
.35714 .88095 Mdot
.35714 .92857 Mdot
.35714 .97619 Mdot
.40476 .02381 Mdot
.40476 .07143 Mdot
.40476 .45238 Mdot
.40476 .5 Mdot
.40476 .54762 Mdot
.40476 .59524 Mdot
.40476 .64286 Mdot
.40476 .69048 Mdot
.40476 .7381 Mdot
.40476 .78571 Mdot
.40476 .83333 Mdot
.40476 .88095 Mdot
.40476 .92857 Mdot
.40476 .97619 Mdot
.45238 .02381 Mdot
.45238 .5 Mdot
.45238 .54762 Mdot
.45238 .59524 Mdot
.45238 .64286 Mdot
.45238 .69048 Mdot
.45238 .7381 Mdot
.45238 .78571 Mdot
.45238 .83333 Mdot
.45238 .88095 Mdot
.45238 .92857 Mdot
.45238 .97619 Mdot
.5 .54762 Mdot
.5 .59524 Mdot
.5 .64286 Mdot
.5 .69048 Mdot
.5 .7381 Mdot
.5 .78571 Mdot
.5 .83333 Mdot
.5 .88095 Mdot
.5 .92857 Mdot
.5 .97619 Mdot
.54762 .59524 Mdot
.54762 .64286 Mdot
.54762 .69048 Mdot
.54762 .7381 Mdot
.54762 .78571 Mdot
.54762 .83333 Mdot
.54762 .88095 Mdot
.54762 .92857 Mdot
.59524 .64286 Mdot
.59524 .69048 Mdot
.59524 .7381 Mdot
.59524 .78571 Mdot
.59524 .83333 Mdot
.59524 .88095 Mdot
.64286 .69048 Mdot
.64286 .7381 Mdot
.64286 .78571 Mdot
.64286 .83333 Mdot
.69048 .7381 Mdot
.69048 .78571 Mdot
.78571 .7381 Mdot
.83333 .69048 Mdot
.83333 .7381 Mdot
.83333 .78571 Mdot
.88095 .64286 Mdot
.88095 .69048 Mdot
.88095 .7381 Mdot
.88095 .78571 Mdot
.88095 .83333 Mdot
.92857 .59524 Mdot
.92857 .64286 Mdot
.92857 .69048 Mdot
.92857 .7381 Mdot
.92857 .78571 Mdot
.92857 .83333 Mdot
.92857 .88095 Mdot
.97619 .54762 Mdot
.97619 .59524 Mdot
.97619 .64286 Mdot
.97619 .69048 Mdot
.97619 .7381 Mdot
.97619 .78571 Mdot
.97619 .83333 Mdot
.97619 .88095 Mdot
.97619 .92857 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{299.062, 299.062},
  ImageMargins->{{48, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004[0001:`P10`4000010?ooooooc?ooZ_ooI_oo
<ooo0?o<ooo<c?o<VC/k>gYjN[Vi^OShn03ooeGooj[ooonI<onI0?mVoomVc?mVVOmVI_mV<omV0?lc
oclo?ginO[fm_Oclo5D00:X00?l00?l0VOl0I_l0<ol00<coolcoc<coVLcoIP<30d92@X61PL30`000
EED0EJX0EOl0ELbIolbIc<bIVLbII/bI<lbI0<aVolaVc0L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0Z/`c
<l`c0<`0ol`0c<`0VL`0I/`0<l`000/;2dY:BXV9RLS8b000oeD0ojX0ool0oiW<VIW<IYW<<iW<09VI
oiVIc9VIVIVIIPl?3di>CXf=SLc<c01E05EE0:YE0?mE09TcoiTcc9TcVITcIYTc<iTc09T0oiT0c1<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEEFKo<fKo06K<ofK<c6K<VFK<IVK<<fK<01LG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZVIVVFIVIVIV<fIV06HcofHcc6HcVFHcIQ/K6eYJFYVIVMSHf01EoeEEojYEoomEoc?o
oc?oc3?oVC?oIS?o<c?o03?<oc?<c1lO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ03>I<c>I03=Voc=Vc3=V
VC=VIS=V<c=V02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZEC<0VC<0IS<0<c<0003oo`3oc03oV@3oIRLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2Io`2Ic02IV@2IIP2I<`2I001Vo`1Vc2/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`0c<`0c0000o`00c000V@00IP00<nh002l_;fi^KZf][Nc/k03o05Go0:[o0?oo0140
003^003M002k002Z0028001g001E03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@00M`00E@00A0008P00
4Nk^k]gMgK^k^cLg=gIfM[Fe]OCdm03oZUGoZZ[oZP0009D000?o0000T`0009D000?o0000T`0009D0
00?o0000T`0009D000?o0000T`0009D000?o0000T`0009D000?o0000T`0001<00ol<00?o2`03o`/0
0ol;00?o2`03o``00ol;00?o2`03o`@00ol60003o`0009<0000B00Go2P05o`T01Ol900Go2@05o`T0
1Ol:00Go2@05o`T01Ol60003o`0000<000?o0000T`0001801Ol:00Go2@05o`T01Ol900Go2@05o`X0
1Ol900Go2@07o`@000?o00000`02oi@0000B00Go2P05o`T01Ol900Go2@05o`T01Ol:00Go2@05o`T0
1Ol400;o1P000ol0002C00004`03o``00ol;00?o2`03o`/00ol;00?o3003o`/00ol;00?o1`000ol0
00030003o`0009<0002<00?o1P000ol0002C0000U@000ol0002C0000U@000ol0002C0000U@000ol0
002C0000U@000ol0002C0000U@000ol0002C0000U@02oi@0002E0003o`0009<0002E0003o`0009<0
000R00?o2`03o`/00ol;00?o2`03o``00ol;00?o6`000ol0002C00008@05o`T01Ol900Go2@05o`T0
1Ol:00Go2@05oaX000?o0000T`0002401Ol900Go2@05o`T01Ol900Go2P05o`T01OlJ0003o`0009<0
000Q00Go2@05o`T01Ol900Go2@05o`X01Ol900Go6P000ol0002C00008P03o`/00ol;00?o2`03o`/0
0ol<00?o2`03oa/000?o0000T`0009D000?o0000T`0009D00_nD0000U@000ol0002C0000U@000ol0
002C0000U@000ol0002C0000U@000ol0002C0000U@000ol0002C0000U@000ol0002C0000U@000ol0
002C0000<003o`/00ol;00?o2`03o``00olY0003o`0009<0000_00Go2@05o`T01Ol900Go2P05obP0
00?o0000T`0002l01Ol900Go2@05o`T01Ol:00Go:002oi@0000_00Go2@05o`T01Ol900Go2P05obP0
00?o0000T`0003000ol;00?o2`03o`/00ol<00?o:@000ol0002C0000U@000ol0002C0000U@000ol0
002C0000U@000ol0002C0000U@000ol0002C0000U@000ol0002C0000U@000ol0002C0000U@02oi@0
002E0003o`0009<0002E0003o`0009<0002E0003o`0009<0000n00?o2`03o`/00olh0003o`0009<0
000m00Go2@05o`T01Olg0003o`0009<0000m00Go2@05o`T01Olg0003o`0009<0000m00Go2@05o`T0
1Olg0003o`0009<0000n00?o2`03o`/00ol_00Co1@000ol0002C0000S@000ol000050003o`0009<0
002600Go0`000ol0000400;oU00008l000?o00000`000ol0002C0000S0001?l00?l50003o`0009<0
002=00;o1P000ol0002C0000U@000ol0002C0000U@000ol0002C0000U@000ol0002C0000U@000ol0
002C0000C003odH000?o0000T`0004/01Om500;oU00004/01Om50003o`0009<0001;00GoA@000ol0
002C0000C003odH000?o0000T`0009D000?o0000T`0009D000?o0000T`0009D000?o0000T`0009D0
00?o0000T`0009D000?o0000T`0009D000?o0000T`0009D00_nD0000U@000ol0002C0000U@000ol0
002C0000U@000ol0002C0000U@000ol0002C0000U@000ol0002C0000U@000ol0002C0000U@000ol0
002C0000U@000ol0002C0000U@02oi@0002E0003o`0009<0002E0003o`0009<0002E0003o`0009<0
002E0003o`0009<0002E0003o`0009<0002E0003o`0009<0002E0003o`0009<0000n00?o2`03odH0
00?o0000T`0003d01Ol900GoA@000ol0002C0000?@05o`T01Om500;oU00003d01Ol900GoA@000ol0
002C0000?P03o`/00om60003o`0009<0002E0003o`0009<0002E0003o`0009<0002E0003o`0009<0
002E0003o`0009<0002<00?o1P000ol0002C0000S@000ol000050003o`0009<0002600Go0P000ol0
000500;oU00008d000?o00001@000ol0002C0000S@000ol000050003o`0009<0000`00?o2`03o`/0
0ol;00?o;`02o`L000?o0000T`0002l01Ol900Go2@05o`T01Olg0003o`0009<0000_00Go2@05o`T0
1Ol900Go=`000ol0002C0000;`05o`T01Ol900Go2@05ocL000?o0000T`0003000ol;00?o2`03o`/0
0olh0003o`0009<0002E0003o`0009<0002E0003o`0009<0002E00;oU00009D000?o0000T`0009D0
00?o0000T`0009D000?o0000T`0009D000?o0000T`0009D000?o0000T`0009D000?o0000T`0009D0
00?o0000T`0002800ol;00?o2`03o`/00ol;00?o3003obT000?o0000T`0002401Ol900Go2@05o`T0
1Ol900Go2P05obP00_nD00008@05o`T01Ol900Go2@05o`T01Ol:00Go:0000ol0002C00008@05o`T0
1Ol900Go2@05o`T01Ol:00Go:0000ol0002C00008P03o`/00ol;00?o2`03o`/00ol<00?o:@000ol0
002C0000U@000ol0002C0000U@000ol0002C0000U@000ol0002C0000U@000ol0002C0000U@000ol0
002C0000U@000ol0002C0000U@02oi@0002E0003o`0009<0002E0003o`0009<0000C00?o3003o`/0
0ol;00?o2`03o`/00ol<00?o2`03oa/000?o0000T`0001801Ol:00Go2@05o`T01Ol900Go2@05o`X0
1Ol900Go6P000ol0002C00004P05o`X01Ol900Go2@05o`T01Ol900Go2P05o`T01OlJ0003o`0009<0
000B00Go2P05o`T01Ol900Go2@05o`T01Ol:00Go2@05oaX000?o0000T`0001<00ol<00?o2`03o`/0
0ol;00?o2`03o``00ol;00?o6`000ol0002C00002003ob`01?l[00?o;0000ol0000Z00?o;004ob/0
0ol800002`000ol0000Z0003o`0002`000?o0000:`02ob`000?o0000;0000ol0000^0003o`0000D0
000200Go10000ol0000S00Go0`000ol0000T00Go0P000ol0000[0003o`0002/000?o0000;@000ol0
000]0003o`0000D0000900;o;`000ol0000Z0003o`0002/000?o0000:`000ol0000^0003o`0002X0
0_l800002`000ol0000Y0004o`00ob`000?o0000:`000ol0000[0003o`0002/000Co003o;P000ol0
000500002003obd00_l/00;o;@000ol0000Z00;o;P02ob`00ol80000U@000ol0002C0000U@000ol0
002C0000U@000ol0002C00001@03o`/00ol<00?o2`03o`/00ol;00?o2`03o``00ol;00?o2`03o`d0
00?o0000T`000?oo;?l000@01Ol70003o`3o00Co0`000ol0000400Go1P000ol00005o`8000?o0000
1005o`L000?o0?l01?l20003o`0000@01Ol70003o`0000Go0P000ol0000400Go1`000ol0o`04o`80
00?o00001`000ol000060003o`0000H000?o00001`000ol000060003o`0000L000?o00001P000ol0
00070003o`0000H000?o00001`000ol000060003o`0000L000?o00001P000ol000070003o`0000H0
00?o00001P000ol0000600001005o`L000?o0?l01?l30003o`0000@01Ol60003o`0000Go0P000ol0
000400Go1`000ol0o`04o`8000?o00001005o`L000?o00001Ol20003o`0000@01Ol70003o`3o00Co
0P000ol000070003o`0000H000?o00001P000ol000070003o`0000H000?o00001`000ol000060003
o`0000L000?o00001P000ol000070003o`0000H000?o00001`000ol000060003o`0000L000?o0000
1P000ol000060003o`0000H0000500?o2`03o``00ol;00?o2`03o`/00ol;00?o3003o`/00ol;00?o
3@000ol0002C0000U@000ol0002C0000U@000ol0002C0000U@000ol0002C0000U@000ol0002C0000
U@000ol0002C0000U@000ol0002C0000U@02oi@0002E0003o`0009<0002E0003o`0009<0000500?o
2`03o``00ol;00?o2`03o`/00ol;00?o3003o`/00ol;00?o2`03oh/00ol700001005o`T01Ol:00Go
2@05o`T01Ol900Go2@05o`X01Ol900Go2@05o`T01On900Go1P0000@01Ol900Go2P05o`T01Ol900Go
2@05o`T01Ol:00Go2@05o`T01Ol900GoR@05o`H0000400Go2@05o`X01Ol900Go2@05o`T01Ol900Go
2P05o`T01Ol900Go2@05ohT01Ol600001@03o`/00ol<00?o2`03o`/00ol;00?o2`03o``00ol;00?o
2`03o`/00on;00?o1`0009D000?o0000T`0009D00_nD0000U@000ol0002C0000U@000ol0002C0000
U@000ol0002C0000U@000ol0002C0000U@000ol0002C0000U@000ol0002C0000U@000ol0002C0000
1@03o`/00ol<00?o2`03o`/00ol;00?o2`03o``00ol;00?o2`03o`/00ol;00?oK`03o`/00ol70000
1005o`T01Ol:00Go2@05o`T01Ol900Go2@05o`X01Ol900Go2@05o`T01Ol900GoK@05o`T01Ol60000
1005o`T01Ol:00Go2@05o`T01Ol900Go2@05o`X01Ol900Go2@05o`T01Ol900GoK@05o`T01Ol60000
1005o`T01Ol:00Go2@05o`T01Ol900Go2@05o`X01Ol900Go2@05o`T01Ol900GoK@05o`T01Ol60000
1@03o`/00ol<00?o2`03o`/00ol;00?o2`03o``00ol;00?o2`03o`/00ol;00?oK`03o`/00ol70000
U@000ol0002C0000U@000ol0002C0000U@000ol0002C0000U@000ol0002C0000U@000ol0002C0000
U@000ol0002C0000U@02oi@0002E0003o`0009<0002E0003o`0009<0000500?o2`03o``00ol;00?o
2`03o`/00ol;00?o3003o`/00ol;00?o2`03o`/00ol;00?oD`03o`/00ol;00?o1`0000@01Ol900Go
2P05o`T01Ol900Go2@05o`T01Ol:00Go2@05o`T01Ol900Go2@05o`T01OmA00Go2@05o`T01Ol60000
1005o`T01Ol:00Go2@05o`T01Ol900Go2@05o`X01Ol900Go2@05o`T01Ol900Go2@05oe401Ol900Go
2@05o`H0000400Go2@05o`X01Ol900Go2@05o`T01Ol900Go2P05o`T01Ol900Go2@05o`T01Ol900Go
D@05o`T01Ol900Go1P0000D00ol;00?o3003o`/00ol;00?o2`03o`/00ol<00?o2`03o`/00ol;00?o
2`03o`/00omC00?o2`03o`/00ol70000S003o`H000?o0000T`0008d000?o00001@000ol0002C0000
S@000ol0000500;oU00008d000?o00001@000ol0002C0000S@000ol000050003o`0009<0002<00;o
1`000ol0002C0000U@000ol0002C0000U@000ol0002C0000U@000ol0002C0000U@000ol0002C0000
1@03o`/00ol<00?o2`03o`/00ol;00?o2`03o``00ol;00?o2`03o`/00ol;00?o2`03o``00ole00?o
3003o`/00ol;00?o1`0000@01Ol900Go2P05o`T01Ol900Go2@05o`T01Ol:00Go2@05o`T01Ol900Go
2@05o`T01Ol:00Go<`05o`X01Ol900Go2@05o`H0000400Go2@05o`X01Ol900Go2@05o`T01Ol900Go
2P05o`T01Ol900Go2@05o`T01Ol900Go2P05oc<01Ol:00Go2@05o`T01Ol600001005o`T01Ol:00Go
2@05o`T01Ol900Go2@05o`X01Ol900Go2@05o`T01Ol900Go2@05o`X01Olc00Go2P05o`T01Ol900Go
1P0000D00ol;00?o3003o`/00ol;00?o2`03o`/00ol<00?o2`03o`/00ol;00?o2`03o`/00ol<00?o
=@03o``00ol;00?o2`03o`L0002E0003o`0009<0002E0003o`0009<0002E0003o`0009<0002E0003
o`0009<0002E0003o`0009<0002E0003o`0009<0002E00;oU00009D000?o0000T`0009D000?o0000
T`0000D00ol;00?o3003o`/00ol;00?o2`03o`/00ol<00?o2`03o`/00ol;00?o2`03o`/00ol<00?o
2`03oaT00ol;00?o3003o`/00ol;00?o1`0000@01Ol900Go2P05o`T01Ol900Go2@05o`T01Ol:00Go
2@05o`T01Ol900Go2@05o`T01Ol:00Go2@05oaL01Ol900Go2P05o`T01Ol900Go1P0000@01Ol900Go
2P05o`T01Ol900Go2@05o`T01Ol:00Go2@05o`T01Ol900Go2@05o`T01Ol:00Go2@05oaL01Ol900Go
2P05o`T01Ol900Go1P0000@01Ol900Go2P05o`T01Ol900Go2@05o`T01Ol:00Go2@05o`T01Ol900Go
2@05o`T01Ol:00Go2@05oaL01Ol900Go2P05o`T01Ol900Go1P0000D00ol;00?o3003o`/00ol;00?o
2`03o`/00ol<00?o2`03o`/00ol;00?o2`03o`/00ol<00?o2`03oaT00ol;00?o3003o`/00ol;00?o
1`0009D000?o0000T`0009D00_nD0000U@000ol0002C0000U@000ol0002C0000U@000ol0002C0000
U@000ol0002C0000U@000ol0002C0000U@000ol0002C0000U@000ol0002C00001@03o`/00ol<00?o
2`03o`/00ol;00?o2`03o``00ol;00?o2`03o`/00ol;00?o2`03o``00ol;00?o9`03o``00ol;00?o
2`03o`L0000400Go2@05o`X01Ol900Go2@05o`T01Ol900Go2P05o`T01Ol900Go2@05o`T01Ol900Go
2P05o`T01OlU00Go2P05o`T01Ol900Go1P0000@01Ol900Go2P05o`T01Ol900Go2@05o`T01Ol:00Go
2@05o`T01Ol900Go2@05o`T01Ol:00Go2@05obD01Ol:00Go2@05o`T01Ol600001005o`T01Ol:00Go
2@05o`T01Ol900Go2@05o`X01Ol900Go2@05o`T01Ol900Go2@05o`X01Ol900Go9@05o`X01Ol900Go
2@05o`H0000500?o2`03o``00ol;00?o2`03o`/00ol;00?o3003o`/00ol;00?o2`03o`/00ol;00?o
3003o`/00olW00?o3003o`/00ol;00?o1`0009D000?o0000T`0009D000?o0000T`0009D000?o0000
T`0009D000?o0000T`0008`01?l50003o`0009<0002=0003o`0000D000?o0000T`0008h000?o0000
1002oi@0002?0003o`0000<000?o0000T`0008`000Co003o1@000ol0002C00001@03o`/00ol<00?o
2`03o`/00ol;00?o2`03o``00ol;00?o2`03o`D00_l400?o2`03o`/00ol<00?oA003o`/00ol;00?o
1`0000@01Ol900Go2P05o`T01Ol900Go2@05o`T01Ol:00Go2@05o`T01Ol900Go2@05o`T01Ol:00Go
@P05o`T01Ol900Go1P0000@01Ol900Go2P05o`T01Ol900Go2@05o`T01Ol:00Go2@05o`T01Ol900Go
2@05o`T01Ol:00Go@P05o`T01Ol900Go1P0000@01Ol900Go2P05o`T01Ol900Go2@05o`T01Ol:00Go
2@05o`T01Ol900Go2@05o`T01Ol:00Go@P05o`T01Ol900Go1P0000D00ol;00?o3003o`/00ol;00?o
2`03o`/00ol<00?o2`03o`/00ol;00?o2`03o`/00ol<00?oA003o`/00ol;00?o1`0009D000?o0000
T`0009D000?o0000T`0009D00_nD0000U@000ol0002C0000U@000ol0002C0000U@000ol0002C0000
U@000ol0002C0000U@000ol0002C0000U@000ol0002C00001@03o`/00ol<00?o2`03o`/00ol;00?o
2`03o``00ol;00?o2`03o`/00ol;00?o2`03of400ol;00?o1`0000@01Ol900Go2P05o`T01Ol900Go
2@05o`T01Ol:00Go2@05o`T01Ol900Go2@05o`T01OmO00Go2@05o`H0000400Go2@05o`X01Ol900Go
2@05o`T01Ol900Go2P05o`T01Ol900Go2@05o`T01Ol900GoG`05o`T01Ol600001005o`T01Ol:00Go
2@05o`T01Ol900Go2@05o`X01Ol900Go2@05o`T01Ol900Go2@05oel01Ol900Go1P0000D00ol;00?o
3003o`/00ol;00?o2`03o`/00ol<00?o2`03o`/00ol;00?o2`03o`/00omQ00?o2`03o`L0002E0003
o`0009<0002E0003o`0009<0002E0003o`0009<0002E0003o`0009<0002E0003o`0009<0002E0003
o`0009<0002E00;oU00009D000?o0000T`0009D000?o0000T`0009D000?o0000T`0000D00ol;00?o
3003o`/00ol;00?o2`03o`/00ol<00?o2`03o`/00ol;00?o2`03ogd00ol700001005o`T01Ol:00Go
2@05o`T01Ol900Go2@05o`X01Ol900Go2@05o`T01Ol900GoN`05o`H0000400Go2@05o`X01Ol900Go
2@05o`T01Ol900Go2P05o`T01Ol900Go2@05o`T01Omk00Go1P0000@01Ol900Go2P05o`T01Ol900Go
2@05o`T01Ol:00Go2@05o`T01Ol900Go2@05og/01Ol600001@03o`/00ol<00?o2`03o`/00ol;00?o
2`03o``00ol;00?o2`03o`/00ol;00?oO@03o`L0002E0003o`0009<0002E00;oU00009D000?o0000
T`0009D000?o0000T`0009D000?o0000T`0009D000?o0000T`0009D000?o0000T`0009D000?o0000
T`0008`00ol60003o`0009<0000500?o2`03o``00ol;00?o2`03o`/00ol;00?o3003o`/00ol;00?o
1`001?l00003oiD0000400Go2@05o`X01Ol900Go2@05o`T01Ol900Go2P05o`T01Ol900Go1P000ol0
0005oi@0000400Go2@05o`X01Ol900Go2@05o`T01Ol900Go2P05o`T01Ol900Go1002o`<01OnD0000
1005o`T01Ol:00Go2@05o`T01Ol900Go2@05o`X01Ol900Go2@05o`H000?o00001OnD00001@03o`/0
0ol<00?o2`03o`/00ol;00?o2`03o``00ol;00?o2`03o`@00ol400?oU@0009D000?o0000T`0009D0
00?o0000T`0009D000?o0000T`0009D000?o0000T`000001\
\>"],
  ImageRangeCache->{{{0, 298.062}, {298.062, 0}} -> {-3.15003, -3.15003, 
  0.0211367, 0.0211367}}]
}, Closed]],

Cell[BoxData[
    \(Clear[pts, inRegionsQ]\)], "Input"],

Cell[TextData[{
  "Using ",
  StyleBox["Names", "Input",
    FontFamily->"Courier"],
  " and ",
  StyleBox["StringLength", "Input",
    FontFamily->"Courier"],
  ", find all ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " function names that contain more than twenty-five letters. Find all \
function names that contain fewer than three letters."
}], "Question"],

Cell[TextData[{
  "Here is a shortened list of all built-in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " function names."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Short[Names["\<System`*\>"], 3]\)], "Input"],

Cell[BoxData[
    TagBox[
      \({"Abort", "AbortProtect", "Above", "Abs", "AbsoluteDashing", 
        \[LeftSkeleton]1557\[RightSkeleton], "$TracePreAction", "$Urgent", 
        "$UserName", "$Version", "$VersionNumber"}\),
      (Short[ #, 3]&)]], "Output"]
}, Closed]],

Cell[TextData[{
  "Here is a predicate function that returns ",
  StyleBox["True", "Input",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " if its argument is a function whose name contains more than twenty-five \
letters."
}], "Text"],

Cell[BoxData[
    \(longNameQ[s_String] := StringLength[s] > 25\)], "Input"],

Cell[TextData[{
  "We use ",
  StyleBox["Select",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " to extract the desired function names."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Select[Names["\<System`*\>"], longNameQ]\)], "Input"],

Cell[BoxData[
    \({"ConversionStyleEnvironment", "DegreeReverseLexicographic", 
      "EllipticReducedHalfPeriods", "FEDisableConsolePrintPacket", 
      "FEEnableConsolePrintPacket", "GetLinebreakInformationPacket", 
      "Hypergeometric0F1Regularized", "Hypergeometric1F1Regularized", 
      "Hypergeometric2F1Regularized", "HypergeometricPFQRegularized", 
      "MathieuCharacteristicExponent", "NeedCurrentFrontEndPackagePacket", 
      "SelectionEvaluateCreateCell"}\)], "Output"]
}, Closed]],

Cell[TextData[{
  "The following function returns ",
  StyleBox["True",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " if its argument contains fewer than three letters."
}], "Text"],

Cell[BoxData[
    \(shortNameQ[s_String] := StringLength[s] < 3\)], "Input"],

Cell["Here are all the names with one or two letters.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Select[Names["\<System`*\>"], shortNameQ]\)], "Input"],

Cell[BoxData[
    \({"C", "D", "Do", "Dt", "E", "I", "If", "Im", "In", "K", "N", "O", "On", 
      "Or", "Pi", "Re"}\)], "Output"]
}, Closed]],

Cell[" ", "EndExercises"]
}, Closed]],

Cell[CellGroupData[{

Cell["List Structure", "Subsection",
  CellTags->"Structure Manipulation"],

Cell[CellGroupData[{

Cell["Characteristics of Structure", "Subsubsection"],

Cell["\<\
There are many functions to determine characteristics of a list, \
such as its length, depth, or dimensions; further, we can test if a list is a \
vector or matrix.\
\>", "Text"],

Cell["\<\
The length of a vector is the number of elements it contains.\
\>", 
  "Text"],

Cell[BoxData[
    \(\(vec = {a, b, c}; \)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Length[vec]\)], "Input"],

Cell[OutputFormData["\<\
3\
\>", "\<\
3\
\>"], "Output"]
}, Closed]],

Cell[TextData[{
  "Because the vector ",
  StyleBox["vec",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " is one-dimensional, ",
  StyleBox["Dimensions[vec]",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " returns a list containing the size of ",
  StyleBox["vec",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " in its one dimension."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Dimensions[vec]\)], "Input"],

Cell[OutputFormData["\<\
{3}\
\>", "\<\
{3}\
\>"], "Output"]
}, Closed]],

Cell["\<\
The length of a matrix is the number of rows it contains; that is, \
the number of sublists it contains.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Length[rect]\)], "Input"],

Cell[BoxData[
    \(5\)], "Output"]
}, Closed]],

Cell["\<\
The dimensions of a matrix are its number of rows and columns.\
\>",
   "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Dimensions[rect]\)], "Input"],

Cell[OutputFormData["\<\
{5, 2}\
\>", "\<\
{5, 2}\
\>"], "Output"]
}, Closed]],

Cell[TextData[{
  "In general, the length of an ",
  StyleBox["n",
    FontSlant->"Italic"],
  "-dimensional list is the number of ",
  StyleBox["n",
    FontSlant->"Italic"],
  "\[Dash]1-dimensional sublists it contains. The list ",
  StyleBox["tensor",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " contains two three-dimensional sublists, so its length is 2."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Length[tensor]\)], "Input"],

Cell[BoxData[
    \(2\)], "Output"]
}, Closed]],

Cell[TextData[{
  StyleBox["Dimensions",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " returns the length in each \[OpenCurlyDoubleQuote]direction\
\[CloseCurlyDoubleQuote] of a nested list."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Dimensions[tensor]\)], "Input"],

Cell[OutputFormData["\<\
{2, 3, 4, 5}\
\>", "\<\
{2, 3, 4, 5}\
\>"], "Output"]
}, Closed]],

Cell[TextData[{
  "If we have an irregularly shaped array of data, we can find the length of \
each sublist by mapping the function ",
  StyleBox["Length", "Input"],
  " over the array."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(irreg = {{1, 2, 3, 4}, {2, 4, 6}, {3, 6, 9, 12, 15, 18}, {4, 8}}; 
    TableForm[irreg]\)], "Input"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {"1", "2", "3", "4", \(""\), \(""\)},
          {"2", "4", "6", \(""\), \(""\), \(""\)},
          {"3", "6", "9", "12", "15", "18"},
          {"4", "8", \(""\), \(""\), \(""\), \(""\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      TableForm[ {{1, 2, 3, 4}, {2, 4, 6}, {3, 6, 9, 12, 15, 18}, {4, 8}}]]], 
  "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Map[Length, irreg]\)], "Input"],

Cell[BoxData[
    \({4, 3, 6, 2}\)], "Output"]
}, Closed]],

Cell["\<\
Here is a function that pads (with zeros) an irregularly shaped \
array, so that each sublist has the same length.\
\>", "Text"],

Cell[BoxData[
    \(padArray[\[ScriptCapitalA]_List] := 
      Module[{\[ScriptM]\[ScriptA]\[ScriptX] = 
            Max[Map[Length, \[ScriptCapitalA]]]}, 
        Map[Take[Join[#, Table[0, {\[ScriptM]\[ScriptA]\[ScriptX]}]], 
              \[ScriptM]\[ScriptA]\[ScriptX]]&, \[ScriptCapitalA]]]\)], 
  "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(padArray[irreg] // TableForm\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {"1", "2", "3", "4", "0", "0"},
          {"2", "4", "6", "0", "0", "0"},
          {"3", "6", "9", "12", "15", "18"},
          {"4", "8", "0", "0", "0", "0"}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Closed]],

Cell[TextData[{
  "See also ",
  StyleBox["TensorRank",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  ", ",
  StyleBox["TreeForm",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  ", ",
  StyleBox["Depth",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  ", ",
  StyleBox["Level",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  ", ",
  StyleBox["VectorQ",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  ", ",
  StyleBox["MatrixQ",
    FontFamily->"Courier",
    FontWeight->"Bold"]
}], "SeeAlso"]
}, Closed]],

Cell[CellGroupData[{

Cell["Changing List Structure", "Subsubsection"],

Cell[TextData[{
  StyleBox["Flatten",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " is used to remove all but the outermost list brackets in a nested list of \
lists."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Flatten[hurr]\)], "Input"],

Cell[BoxData[
    \({"Allison", 65, 987, "Barry", 50, 995, "Chantal", 60, 992, "Dean", 40, 
      999, "Erin", 75, 975, "Felix", 115, 950, "Gabrielle", 60, 998, 
      "Humberto", 90, 970, "Iris", 75, 970, "Jerry", 35, 1003}\)], "Output"]
}, Closed]],

Cell[TextData[{
  "Here is a nested list called ",
  StyleBox["prods",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(prods = Table[m\[Times]n, {m, 2, 5}, {n, 1, 5}]\)], "Input"],

Cell[BoxData[
    \({{2, 4, 6, 8, 10}, {3, 6, 9, 12, 15}, {4, 8, 12, 16, 20}, {5, 10, 15, 
        20, 25}}\)], "Output"]
}, Closed]],

Cell[TextData[{
  StyleBox["Flatten",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " removes all of the inner list brackets from ",
  StyleBox["prods",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  ", returning a one-dimensional list of values."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Flatten[prods]\)], "Input"],

Cell[BoxData[
    \({2, 4, 6, 8, 10, 3, 6, 9, 12, 15, 4, 8, 12, 16, 20, 5, 10, 15, 20, 25}
      \)], "Output"]
}, Closed]],

Cell["\<\
The flattened list can now be sorted, have duplicates removed, and \
so forth.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Sort[Flatten[prods]]\)], "Input"],

Cell[BoxData[
    \({2, 3, 4, 4, 5, 6, 6, 8, 8, 9, 10, 10, 12, 12, 15, 15, 16, 20, 20, 25}
      \)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Union[Flatten[prods]]\)], "Input"],

Cell[BoxData[
    \({2, 3, 4, 5, 6, 8, 9, 10, 12, 15, 16, 20, 25}\)], "Output"]
}, Closed]],

Cell["\<\
Lists can also be partitioned into sublists with a given length. \
Below a list of integers from 1 through 12 is partitioned into sublists of \
length 2, 3, and 4.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Partition[Range[12], 2]\)], "Input"],

Cell[BoxData[
    \({{1, 2}, {3, 4}, {5, 6}, {7, 8}, {9, 10}, {11, 12}}\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Partition[Range[12], 3]\)], "Input"],

Cell[BoxData[
    \({{1, 2, 3}, {4, 5, 6}, {7, 8, 9}, {10, 11, 12}}\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Partition[Range[12], 4]\)], "Input"],

Cell[BoxData[
    \({{1, 2, 3, 4}, {5, 6, 7, 8}, {9, 10, 11, 12}}\)], "Output"]
}, Closed]],

Cell[TextData[{
  "Notice that all sublists created by ",
  StyleBox["Partition",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " must be of the same length: if we partition a length-12 list into \
sublists of length 5, the two final elements are dropped."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Partition[Range[12], 5]\)], "Input"],

Cell[BoxData[
    \({{1, 2, 3, 4, 5}, {6, 7, 8, 9, 10}}\)], "Output"]
}, Closed]],

Cell[TextData[{
  "It is also possible to partition a list into \
\[OpenCurlyDoubleQuote]overlapping\[CloseCurlyDoubleQuote] sublists by giving \
the offset between subsequent lists as a third argument to ",
  StyleBox["Partition",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Partition[{a, b, c, d, e}, 3, 1]\)], "Input"],

Cell[BoxData[
    \({{a, b, c}, {b, c, d}, {c, d, e}}\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Partition[{a, b, c, d, e}, 3, 2]\)], "Input"],

Cell[BoxData[
    \({{a, b, c}, {c, d, e}}\)], "Output"]
}, Closed]],

Cell[TextData[
"Often we have lists of data to be manipulated. Manipulating vectors \
(one-dimensional lists) is straightforward, but to manipulate \
multidimensional lists may require manipulation of the \
list\[CloseCurlyQuote]s structure."], "Text"],

Cell[TextData[{
  "For example, say we have a list of ordered pairs called ",
  StyleBox["mydata",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(mydata = Table[{n, Sin[n + 0.1\ Random[]]}, {n, 0, 9, 0.3}]\)], "Input"],

Cell[BoxData[
    \({{0, 0.00844513988309739893`}, {0.3`, 0.306362461526602913`}, {0.6`, 
        0.607310661167293286`}, {0.9`, 0.788009572749263398`}, {
        1.19999999999999996`, 0.96066222875598406`}, {1.5`, 
        0.999999458951623232`}, {1.79999999999999982`, 
        0.952388420938955171`}, {2.10000000000000008`, 
        0.834715812354962949`}, {2.39999999999999991`, 
        0.621589739975351207`}, {2.69999999999999973`, 
        0.357996759733610758`}, {3.`, 0.0819647303442957486`}, {
        3.29999999999999982`, \(-0.230249881967099767`\)}, {
        3.59999999999999964`, \(-0.491278794242442984`\)}, {3.9`, 
        \(-0.743845156621557368`\)}, {4.20000000000000017`, 
        \(-0.875572815621597122`\)}, {4.5`, \(-0.981390804950580353`\)}, {
        4.79999999999999982`, \(-0.992070419493135702`\)}, {
        5.09999999999999964`, \(-0.918970501104014658`\)}, {
        5.39999999999999946`, \(-0.753412219870961319`\)}, {
        5.70000000000000017`, \(-0.504441927965866199`\)}, {6.`, 
        \(-0.207717381875106266`\)}, {6.29999999999999982`, 
        0.0793337137872103781`}, {6.59999999999999964`, 
        0.371952258167021998`}, {6.89999999999999946`, 
        0.62157348218313615`}, {7.19999999999999928`, 
        0.831784037861858749`}, {7.5`, 0.954520631698938792`}, {
        7.79999999999999982`, 0.999103113177188895`}, {8.09999999999999964`, 
        0.957559405664176921`}, {8.40000000000000035`, 
        0.812632841838091124`}, {8.69999999999999928`, 
        0.599839866922566322`}, {9.`, 0.383671623459636457`}}\)], "Output"]
}, Closed]],

Cell[TextData[{
  "Transposing ",
  StyleBox["mydata",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " results in a list containing two lists, the first being a list of ",
  StyleBox["x",
    FontSlant->"Italic"],
  "-coordinates, and the second being a list of ",
  StyleBox["y",
    FontSlant->"Italic"],
  "-coordinates."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Transpose[mydata]\)], "Input"],

Cell[BoxData[
    \({{0, 0.3`, 0.6`, 0.9`, 1.19999999999999996`, 1.5`, 
        1.79999999999999982`, 2.10000000000000008`, 2.39999999999999991`, 
        2.69999999999999973`, 3.`, 3.29999999999999982`, 
        3.59999999999999964`, 3.9`, 4.20000000000000017`, 4.5`, 
        4.79999999999999982`, 5.09999999999999964`, 5.39999999999999946`, 
        5.70000000000000017`, 6.`, 6.29999999999999982`, 
        6.59999999999999964`, 6.89999999999999946`, 7.19999999999999928`, 
        7.5`, 7.79999999999999982`, 8.09999999999999964`, 
        8.40000000000000035`, 8.69999999999999928`, 9.`}, {
        0.00844513988309739893`, 0.306362461526602913`, 
        0.607310661167293286`, 0.788009572749263398`, 0.96066222875598406`, 
        0.999999458951623232`, 0.952388420938955171`, 0.834715812354962949`, 
        0.621589739975351207`, 0.357996759733610758`, 0.0819647303442957486`, 
        \(-0.230249881967099767`\), \(-0.491278794242442984`\), 
        \(-0.743845156621557368`\), \(-0.875572815621597122`\), 
        \(-0.981390804950580353`\), \(-0.992070419493135702`\), 
        \(-0.918970501104014658`\), \(-0.753412219870961319`\), 
        \(-0.504441927965866199`\), \(-0.207717381875106266`\), 
        0.0793337137872103781`, 0.371952258167021998`, 0.62157348218313615`, 
        0.831784037861858749`, 0.954520631698938792`, 0.999103113177188895`, 
        0.957559405664176921`, 0.812632841838091124`, 0.599839866922566322`, 
        0.383671623459636457`}}\)], "Output"]
}, Closed]],

Cell[TextData[{
  "With ",
  StyleBox["mydata",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " in its transposed form, we can select the first sublist (the list of all \
",
  StyleBox["x",
    FontSlant->"Italic"],
  "-coordinates) and manipulate it separately, and so forth. For example, \
here are the original points."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(ListPlot[mydata, PlotJoined \[Rule] True]; \)\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.10582 0.307846 0.295473 [
[.23545 .29535 -3 -9 ]
[.23545 .29535 3 0 ]
[.44709 .29535 -3 -9 ]
[.44709 .29535 3 0 ]
[.65873 .29535 -3 -9 ]
[.65873 .29535 3 0 ]
[.87037 .29535 -3 -9 ]
[.87037 .29535 3 0 ]
[.01131 .01237 -12 -4.5 ]
[.01131 .01237 0 4.5 ]
[.01131 .16011 -24 -4.5 ]
[.01131 .16011 0 4.5 ]
[.01131 .45558 -18 -4.5 ]
[.01131 .45558 0 4.5 ]
[.01131 .60332 -6 -4.5 ]
[.01131 .60332 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.23545 .30785 m
.23545 .3141 L
s
[(2)] .23545 .29535 0 1 Mshowa
.44709 .30785 m
.44709 .3141 L
s
[(4)] .44709 .29535 0 1 Mshowa
.65873 .30785 m
.65873 .3141 L
s
[(6)] .65873 .29535 0 1 Mshowa
.87037 .30785 m
.87037 .3141 L
s
[(8)] .87037 .29535 0 1 Mshowa
.125 Mabswid
.07672 .30785 m
.07672 .3116 L
s
.12963 .30785 m
.12963 .3116 L
s
.18254 .30785 m
.18254 .3116 L
s
.28836 .30785 m
.28836 .3116 L
s
.34127 .30785 m
.34127 .3116 L
s
.39418 .30785 m
.39418 .3116 L
s
.5 .30785 m
.5 .3116 L
s
.55291 .30785 m
.55291 .3116 L
s
.60582 .30785 m
.60582 .3116 L
s
.71164 .30785 m
.71164 .3116 L
s
.76455 .30785 m
.76455 .3116 L
s
.81746 .30785 m
.81746 .3116 L
s
.92328 .30785 m
.92328 .3116 L
s
.97619 .30785 m
.97619 .3116 L
s
.25 Mabswid
0 .30785 m
1 .30785 L
s
.02381 .01237 m
.03006 .01237 L
s
[(-1)] .01131 .01237 1 0 Mshowa
.02381 .16011 m
.03006 .16011 L
s
[(-0.5)] .01131 .16011 1 0 Mshowa
.02381 .45558 m
.03006 .45558 L
s
[(0.5)] .01131 .45558 1 0 Mshowa
.02381 .60332 m
.03006 .60332 L
s
[(1)] .01131 .60332 1 0 Mshowa
.125 Mabswid
.02381 .04192 m
.02756 .04192 L
s
.02381 .07147 m
.02756 .07147 L
s
.02381 .10101 m
.02756 .10101 L
s
.02381 .13056 m
.02756 .13056 L
s
.02381 .18966 m
.02756 .18966 L
s
.02381 .2192 m
.02756 .2192 L
s
.02381 .24875 m
.02756 .24875 L
s
.02381 .2783 m
.02756 .2783 L
s
.02381 .33739 m
.02756 .33739 L
s
.02381 .36694 m
.02756 .36694 L
s
.02381 .39649 m
.02756 .39649 L
s
.02381 .42603 m
.02756 .42603 L
s
.02381 .48513 m
.02756 .48513 L
s
.02381 .51468 m
.02756 .51468 L
s
.02381 .54422 m
.02756 .54422 L
s
.02381 .57377 m
.02756 .57377 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .31034 m
.05556 .39837 L
.0873 .48729 L
.11905 .54068 L
.15079 .5917 L
.18254 .60332 L
.21429 .58925 L
.24603 .55448 L
.27778 .49151 L
.30952 .41362 L
.34127 .33206 L
.37302 .23981 L
.40476 .16269 L
.43651 .08806 L
.46825 .04914 L
.5 .01787 L
.53175 .01472 L
.56349 .03631 L
.59524 .08523 L
.62698 .1588 L
.65873 .24647 L
.69048 .33129 L
.72222 .41775 L
.75397 .4915 L
.78571 .55362 L
.81746 .58988 L
.84921 .60305 L
.88095 .59078 L
.9127 .54796 L
.94444 .48508 L
.97619 .42121 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  Evaluatable->False,
  AspectRatioFixed->True,
  ImageSize->{299.062, 184.5},
  ImageMargins->{{48, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004[0000^0P10`4000010?ooooooc?ooZ_ooI_oo
<ooo0?o<ooo<c?o<VC/k>gYjN[Vi^OShn03ooeGooj[ooonI<onI0?mVoomVc?mVVOmVI_mV<omV0?lc
oclo?ginO[fm_Oclo5D00:X00?l00?l0VOl0I_l0<ol00<coolcoc<coVLcoIP<30d92@X61PL30`000
EED0EJX0EOl0ELbIolbIc<bIVLbII/bI<lbI0<aVolaVc0L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0Z/`c
<l`c0<`0ol`0c<`0VL`0I/`0<l`000/;2dY:BXV9RLS8b000oeD0ojX0ool0oiW<VIW<IYW<<iW<09VI
oiVIc9VIVIVIIPl?3di>CXf=SLc<c01E05EE0:YE0?mE09TcoiTcc9TcVITcIYTc<iTc09T0oiT0c1<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEEFKo<fKo06K<ofK<c6K<VFK<IVK<<fK<01LG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZVIVVFIVIVIV<fIV06HcofHcc6HcVFHcIQ/K6eYJFYVIVMSHf01EoeEEojYEoomEoc?o
oc?oc3?oVC?oIS?o<c?o03?<oc?<c1lO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ03>I<c>I03=Voc=Vc3=V
VC=VIS=V<c=V02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZEC<0VC<0IS<0<c<0003oo`3oc03oV@3oIRLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2Io`2Ic02IV@2IIP2I<`2I001Vo`1Vc2/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`0c<`0c0000o`00c000V@00IP00<nh002l_;fi^KZf][Nc/k03o05Go0:[o0?oo0140
003^003M002k002Z0028001g001E03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@00M`00E@00A0008P00
4Nk^k]gMgK^k^cLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l0;0000?l0;0000?l0;0000?l0;0000?l0
;0000?l0;00001/000?o0000o`0>00006`000ol0003o00h0000C00?o1@000ol0003o00h0000D0003
o`0000@000?o0000o`0>00003@05o`8000?o00001003ohH01_n1000050000ol000040003o`000840
1Ol60003o`0007h0000D0003o`0000@000?o0000P0000ol0000:00;oOP0001<00_l60003o`0007l0
00?o00003@000ol0001k00006`000ol0001n0003o`0000l00_mk00006`000ol0001m0003o`000180
00?o0000N00001/000?o0000O0000ol0000D0003o`0007L0000K0003o`0007/000?o00005@000ol0
001g00006`02og/000?o00005`000ol0001f00006`000ol0001i0003o`0001P000?o0000MP0001/0
00?o0000N0000ol0000J0003o`0007D0000K0003o`0007P000?o00006`000ol0001d00006`000ol0
001g0003o`0001`000?o0000M00001/000?o0000MP000ol0000N0003o`0007<0000K0003o`0007D0
00?o00007`000ol0001c00006`000ol0001d0003o`00024000?o0000LP0001/00_md0003o`000280
00?o0000LP0001/000?o0000L`000ol0000S0003o`000740000K0003o`00078000?o00009@000ol0
001`00006`000ol0001a0003o`0002H000?o0000L00001/000?o0000L0000ol0000X0003o`0006l0
000K0003o`0006l000?o0000:@000ol0001_00006`000ol0001_0003o`0002X000?o0000KP0001/0
00?o0000KP000ol0000[0003o`0006h0000K00;oK`000ol0000/0003o`0006d0000K0003o`0006h0
00?o0000;0000ol0001]00006`000ol0001]0003o`0002d000?o0000K@0001/000?o0000K@000ol0
000^0003o`0006`0000K0003o`0006d000?o0000;P000ol0001/00006`000ol0001/0003o`000300
00?o0000J`0001/000?o0000K0000ol0000`0003o`0006/0000K0003o`0006/000?o0000<P000ol0
001Z00006`000ol0001[0003o`00038000?o0000JP0001/00_m/0003o`0003<000?o0000J@0001/0
00?o0000JP000ol0000d0003o`0006T0000K0003o`0006X000?o0000=@000ol0001X00006`000ol0
001Y0003o`0003H000?o0000J00001/000?o0000J@000ol0000f0003o`0006P0000K0003o`0006T0
00?o0000=`000ol0001W00002002o`@00_l300?o1@000ol0001X0003o`0003P000?o0000I`0000L0
00Co003o0`02o`H000?o00000P000ol0001X0003o`0003T000?o0000IP0000030?oo00?o00D0o`00
o`0;0003o`0000800omX0003o`0003T000?o0000IP0000L000Co003o2003o`D000?o0000I`000ol0
000k0003o`0006D000070004o`00o`P000?o00001@000ol0001W0003o`0003/000?o0000I@0000P0
0_l900Co10000ol0001V0003o`0003`000?o0000I@0001/000?o0000IP000ol0000m0003o`0006@0
000K0003o`0006D000?o0000?P000ol0001T00006`000ol0001U0003o`0003h000?o0000I00001/0
00?o0000I@000ol0000o0003o`0006<0000K00;oI@000ol000100003o`0006<0000K0003o`0006@0
00?o0000@0000ol0001S00006`000ol0001S0003o`00048000?o0000HP0001/000?o0000H`000ol0
00120003o`000680000K0003o`00068000?o0000A0000ol0001Q00006`000ol0001R0003o`0004@0
00?o0000H@0001/000?o0000HP000ol000140003o`000640000K0003o`00064000?o0000AP000ol0
001P00006`02of8000?o0000AP000ol0001P00006`000ol0001P0003o`0004L000?o0000H00001/0
00?o0000H0000ol000180003o`0005l0000K0003o`0005l000?o0000B@000ol0001O00006`000ol0
001O0003o`0004T000?o0000G`0001/000?o0000G`000ol0001:0003o`0005h0000K0003o`0005h0
00?o0000B`000ol0001N00006`000ol0001N0003o`0004/000?o0000GP0001/00_mN0003o`0004d0
00?o0000G@0001/000?o0000G@000ol0001=0003o`0005d0000K0003o`0005d000?o0000CP000ol0
001L00006`000ol0001L0003o`0004l000?o0000G00001/000?o0000G0000ol0001?0003o`0005`0
000K0003o`0005`000?o0000D0000ol0001K00006`000ol0000f00Co8@000ol0000C00?o>002o`03
0?l003H00_lT00006`000ol0000g0003o`00024000?o000050000ol0000f0006o`00o`3o=@001?l0
0?lS00006`000ol0000h0003o`00020000?o00004P04ocL000Ko003o0?le0004o`00ob<0000K00;o
>P000ol0000N0003o`0001<000?o0?l0>003o`8000?o0000=002ob@0000K0003o`0003H000Co003o
80000ol0000C0003o`3o03P000?o00000`000ol0000b0004o`00ob<0000K0003o`0003L00_lP0003
o`0001D00_li00?o0P000ol0000c00;o900001/000?o0000F@000ol0001F0003o`0005P0000K0003
o`0005T000?o0000EP000ol0001H00006`000ol0001H0003o`0005L000?o0000F00001/000?o0000
F0000ol0001H0003o`0005L0000K0003o`0005P000?o0000F0000ol0001G0000503ooaSo000K0003
o`0000`000?o00002`000ol0000<0003o`0000`000?o00002`000ol0000<0003o`3o00`000?o0000
2`000ol0000<0003o`0000`000?o00002`000ol0000<0003o`0000@000?o00001@000ol0000;0003
o`0000`000?o000030000ol0000;0003o`0000`000?o00001@0001/00_mH0003o`0005X000?o0000
EP0001/00_mG0003o`0005`000?o0000E@0001/00_mG0003o`0005`000?o0000E@0001/000?o0?l0
EP000ol0001L0003o`0005D0000K0003o`3o05D000?o0000GP000ol0001D00006`000ol0o`1E0003
o`0005h000?o0000E00001/00_l00`3o001B0003o`00060000?o0000D`0001/000Co003oD`000ol0
001P0003o`0005<0000K0004o`00oe<000?o0000H0000ol0001C00006`001Ol0003o054000?o0000
HP000ol0001B00006`001Ol0003o054000?o0000HP000ol0001B00006`000ol000020003o`0004d0
00?o0000H`000ol0001B00006`000ol000020003o`0004d000?o0000I0000ol0001A00006`000ol0
00020003o`0004d000?o0000I0000ol0001A00006`02o`@000?o0000B`000ol0001V0003o`000500
000K0003o`0000<000?o0000B`000ol0001V0003o`000500000K0003o`0000<000?o0000BP000ol0
001W0003o`000500000K0003o`0000@000?o0000B@000ol0001X0003o`0004l0000K0003o`0000@0
00?o0000B@000ol0001X0003o`0004l0000K0003o`0000@000?o0000B0000ol0001Y0003o`0004l0
000K0003o`0000D000?o0000A`000ol0001Z0003o`0004h0000K0003o`0000D000?o0000A`000ol0
001Z0003o`0004h0000K00;o1P000ol000160003o`0006`000?o0000C@0001/000?o00001P000ol0
00150003o`0006`000?o0000C@0001/000?o00001P000ol000140003o`0006d000?o0000C@0001/0
00?o00001`000ol000130003o`0006h000?o0000C00001/000?o00001`000ol000130003o`0006h0
00?o0000C00001/000?o00001`000ol000120003o`0006l000?o0000C00001/000?o000020000ol0
00110003o`00070000?o0000B`0001/000?o000020000ol000100003o`00074000?o0000@`000ol0
000500006`000ol000080003o`00040000?o0000LP000ol000120003o`0000D0000K00;o2P000ol0
000o0003o`00078000?o0000@@000ol0000600006`000ol000090003o`0003h000?o0000L`000ol0
00110003o`0000H0000K0003o`0000X000?o0000?@000ol0001d0003o`0003l000?o00001`0001/0
00?o00002P000ol0000l0003o`0007D000?o0000?`000ol0000700006`000ol0000:0003o`0003`0
00?o0000M@000ol0000n0003o`0000P0000K0003o`0000/000?o0000>`000ol0001f0003o`0003d0
00?o0000200000P00_l400;o0`03o`D000?o00002`000ol0000j0003o`0007L000?o0000?0000ol0
000900001`001?l00?l300;o1P000ol000020003o`0000/000?o0000>P000ol0001h0003o`0003/0
00?o00002@0000L000Co003o2`000ol0000200?o30000ol0000h0003o`0007T000?o0000>P000ol0
000:00001`001?l00?l800?o1@000ol0000<0003o`0003P000?o0000N@000ol0000j0003o`0000X0
00070004o`00o`P000?o00001@000ol0000=0003o`0003H000?o0000N`000ol0000h0003o`0000/0
000800;o2@04o`@000?o00003@000ol0000f0003o`0007/000?o0000>0000ol0000;00006`000ol0
000=0003o`0003H000?o0000O0000ol0000f0003o`0000`0000K0003o`0000h000?o0000=0000ol0
001m0003o`0003H000?o0000300001/000?o00003P000ol0000d0003o`0007d000?o0000=@000ol0
000=00006`000ol0000>0003o`0003<000?o0000O`000ol0000d0003o`0000d0000K00;o40000ol0
000b0003o`0007l000?o0000<`000ol0000>00006`000ol0000?0003o`00038000?o0000O`000ol0
000c0003o`0000h0000K0003o`00010000?o0000<0000ol000210003o`00034000?o00003`0001/0
00?o000040000ol0000`0003o`00084000?o0000<@000ol0000?00006`000ol0000A0003o`0002h0
00?o0000P`000ol0000_0003o`000100000K0003o`00014000?o0000;P000ol000230003o`0002l0
00?o0000400001/000?o00004P000ol0000/0003o`0008D000?o0000;@000ol0000A00006`000ol0
000B0003o`0002`000?o0000Q@000ol0000]0003o`000140000K00;o50000ol0000Z0003o`0008L0
00?o0000:`000ol0000B00006`000ol0000D0003o`0002T000?o0000Q`000ol0000Z0003o`0001<0
000K0003o`0001@000?o0000:0000ol000290003o`0002T000?o00004`0001/000?o00005@000ol0
000W0003o`0008X000?o00009`000ol0000D00006`000ol0000E0003o`0002L000?o0000RP000ol0
000W0003o`0001@0000K0003o`0001H000?o00009@000ol0002<0003o`0002D000?o00005@0001/0
00?o00005P000ol0000U0003o`0008`000?o00009@000ol0000E00006`000ol0000G0003o`0002<0
00?o0000SP000ol0000S0003o`0001H0000K00;o60000ol0000S0003o`0008h000?o00008`000ol0
000F00006`000ol0000H0003o`00024000?o0000T0000ol0000Q0003o`0001L0000K0003o`0001T0
00?o000080000ol0002@0003o`00024000?o00005`0001/000?o00006@000ol0000O0003o`000980
00?o00007`000ol0000H00006`000ol0000J0003o`0001h000?o0000TP000ol0000N0003o`0001T0
000K0003o`0001/000?o000070000ol0002D0003o`0001d000?o00006@0001/000?o00006`000ol0
000K0003o`0009H000?o00006`000ol0000J00006`000ol0000L0003o`0001T000?o0000V0000ol0
000I0003o`0001/0000K00;o7@000ol0000H0003o`0009X000?o000060000ol0000K00006`000ol0
000M0003o`0001H000?o0000W0000ol0000F0003o`0001`0000K0003o`0001h000?o000050000ol0
002N0003o`0001@000?o00007@0001/000?o00007P000ol0000C0003o`000:0000?o00004`000ol0
000M00006`000ol0000O0003o`00014000?o0000XP000ol0000A0003o`0001h0000K0003o`000200
0_l?00;oYP02o`l00_lQ00006`000ol0000R00;o2`02ojX00_l;00;o8`0001<00ol50003o`0002@0
0ol500?o[P03o`D00olU000050000ol000040003o`0002L00_l00`3oo`2d00;o00<0ool0:00001@0
00?o00001003obT000?o0000]P000ol0000X000050000ol000040003o`000?l03P0001@000?o0000
10000ol0003o00h0000C00;o1P000ol0003o00h0000K0003o`000?l03P000?l0;0000?l0;0000?l0
;0000?l0;0000?l0;0000001\
\>"],
  ImageRangeCache->{{{0, 298.062}, {183.5, 0}} -> {-0.936365, -1.12022, 
  0.0340916, 0.0122095}}]
}, Closed]],

Cell[TextData[{
  "Here we give the name ",
  StyleBox["tdata", "Input"],
  " to the transpose of ",
  StyleBox["mydata", "Input",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(tdata = Transpose[mydata]\)], "Input"],

Cell[BoxData[
    \({{0, 0.3`, 0.6`, 0.9`, 1.19999999999999996`, 1.5`, 
        1.79999999999999982`, 2.10000000000000008`, 2.39999999999999991`, 
        2.69999999999999973`, 3.`, 3.29999999999999982`, 
        3.59999999999999964`, 3.9`, 4.20000000000000017`, 4.5`, 
        4.79999999999999982`, 5.09999999999999964`, 5.39999999999999946`, 
        5.70000000000000017`, 6.`, 6.29999999999999982`, 
        6.59999999999999964`, 6.89999999999999946`, 7.19999999999999928`, 
        7.5`, 7.79999999999999982`, 8.09999999999999964`, 
        8.40000000000000035`, 8.69999999999999928`, 9.`}, {
        0.00844513988309739893`, 0.306362461526602913`, 
        0.607310661167293286`, 0.788009572749263398`, 0.96066222875598406`, 
        0.999999458951623232`, 0.952388420938955171`, 0.834715812354962949`, 
        0.621589739975351207`, 0.357996759733610758`, 0.0819647303442957486`, 
        \(-0.230249881967099767`\), \(-0.491278794242442984`\), 
        \(-0.743845156621557368`\), \(-0.875572815621597122`\), 
        \(-0.981390804950580353`\), \(-0.992070419493135702`\), 
        \(-0.918970501104014658`\), \(-0.753412219870961319`\), 
        \(-0.504441927965866199`\), \(-0.207717381875106266`\), 
        0.0793337137872103781`, 0.371952258167021998`, 0.62157348218313615`, 
        0.831784037861858749`, 0.954520631698938792`, 0.999103113177188895`, 
        0.957559405664176921`, 0.812632841838091124`, 0.599839866922566322`, 
        0.383671623459636457`}}\)], "Output"]
}, Closed]],

Cell[TextData[{
  "Extracting the first part of the transpose of ",
  StyleBox["mydata",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " returns a list containing all the ",
  StyleBox["x",
    FontSlant->"Italic"],
  "-values in ",
  StyleBox["mydata",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(tdata[\([1]\)]\)], "Input"],

Cell[BoxData[
    \({0, 0.3`, 0.6`, 0.9`, 1.19999999999999996`, 1.5`, 1.79999999999999982`, 
      2.10000000000000008`, 2.39999999999999991`, 2.69999999999999973`, 3.`, 
      3.29999999999999982`, 3.59999999999999964`, 3.9`, 4.20000000000000017`, 
      4.5`, 4.79999999999999982`, 5.09999999999999964`, 5.39999999999999946`, 
      5.70000000000000017`, 6.`, 6.29999999999999982`, 6.59999999999999964`, 
      6.89999999999999946`, 7.19999999999999928`, 7.5`, 7.79999999999999982`, 
      8.09999999999999964`, 8.40000000000000035`, 8.69999999999999928`, 9.`}
      \)], "Output"]
}, Closed]],

Cell[TextData[{
  "Once the ",
  StyleBox["x",
    FontSlant->"Italic"],
  "-values have been extracted, we can manipulate them. Here we take the \
natural logarithm of 1 plus each of the elements."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Log[1 + %]\)], "Input"],

Cell[BoxData[
    \({0, 0.262364264467491059`, 0.470003629245735599`, 
      0.641853886172394716`, 0.788457360364270254`, 0.916290731874155106`, 
      1.02961941718115812`, 1.13140211149110059`, 1.22377543162211566`, 
      1.30833281965017866`, 1.38629436111989058`, 1.45861502269951675`, 
      1.52605630349504917`, 1.589235205116581`, 1.64865862558738163`, 
      1.70474809223842527`, 1.75785791755237363`, 1.80828877117926545`, 
      1.85629799036562594`, 1.90210752639692053`, 1.94591014905531327`, 
      1.98787434815434558`, 2.02814824729228515`, 2.06686275947297559`, 
      2.10413415427020744`, 2.14006616349627076`, 2.17475172148416096`, 
      2.20827441352280429`, 2.24070968927595837`, 2.27212588550933691`, 
      2.3025850929940459`}\)], "Output"]
}, Closed]],

Cell[TextData[{
  "To get the transformed data back into the form of ordered pairs, we create \
a list containing a list of the transformed ",
  StyleBox["x",
    FontSlant->"Italic"],
  "-values, then a list of the original ",
  StyleBox["y",
    FontSlant->"Italic"],
  "-values."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(transdata = {%, tdata[\([2]\)]}\)], "Input"],

Cell[BoxData[
    \({{0, 0.262364264467491059`, 0.470003629245735599`, 
        0.641853886172394716`, 0.788457360364270254`, 0.916290731874155106`, 
        1.02961941718115812`, 1.13140211149110059`, 1.22377543162211566`, 
        1.30833281965017866`, 1.38629436111989058`, 1.45861502269951675`, 
        1.52605630349504917`, 1.589235205116581`, 1.64865862558738163`, 
        1.70474809223842527`, 1.75785791755237363`, 1.80828877117926545`, 
        1.85629799036562594`, 1.90210752639692053`, 1.94591014905531327`, 
        1.98787434815434558`, 2.02814824729228515`, 2.06686275947297559`, 
        2.10413415427020744`, 2.14006616349627076`, 2.17475172148416096`, 
        2.20827441352280429`, 2.24070968927595837`, 2.27212588550933691`, 
        2.3025850929940459`}, {0.00844513988309739893`, 
        0.306362461526602913`, 0.607310661167293286`, 0.788009572749263398`, 
        0.96066222875598406`, 0.999999458951623232`, 0.952388420938955171`, 
        0.834715812354962949`, 0.621589739975351207`, 0.357996759733610758`, 
        0.0819647303442957486`, \(-0.230249881967099767`\), 
        \(-0.491278794242442984`\), \(-0.743845156621557368`\), 
        \(-0.875572815621597122`\), \(-0.981390804950580353`\), 
        \(-0.992070419493135702`\), \(-0.918970501104014658`\), 
        \(-0.753412219870961319`\), \(-0.504441927965866199`\), 
        \(-0.207717381875106266`\), 0.0793337137872103781`, 
        0.371952258167021998`, 0.62157348218313615`, 0.831784037861858749`, 
        0.954520631698938792`, 0.999103113177188895`, 0.957559405664176921`, 
        0.812632841838091124`, 0.599839866922566322`, 0.383671623459636457`}}
      \)], "Output"]
}, Closed]],

Cell["\<\
Transposing the previous list returns a list of ordered pairs.\
\>",
   "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(final = Transpose[transdata]\)], "Input"],

Cell[BoxData[
    \({{0, 0.00844513988309739893`}, {0.262364264467491059`, 
        0.306362461526602913`}, {0.470003629245735599`, 
        0.607310661167293286`}, {0.641853886172394716`, 
        0.788009572749263398`}, {0.788457360364270254`, 
        0.96066222875598406`}, {0.916290731874155106`, 
        0.999999458951623232`}, {1.02961941718115812`, 
        0.952388420938955171`}, {1.13140211149110059`, 
        0.834715812354962949`}, {1.22377543162211566`, 
        0.621589739975351207`}, {1.30833281965017866`, 
        0.357996759733610758`}, {1.38629436111989058`, 
        0.0819647303442957486`}, {1.45861502269951675`, 
        \(-0.230249881967099767`\)}, {1.52605630349504917`, 
        \(-0.491278794242442984`\)}, {1.589235205116581`, 
        \(-0.743845156621557368`\)}, {1.64865862558738163`, 
        \(-0.875572815621597122`\)}, {1.70474809223842527`, 
        \(-0.981390804950580353`\)}, {1.75785791755237363`, 
        \(-0.992070419493135702`\)}, {1.80828877117926545`, 
        \(-0.918970501104014658`\)}, {1.85629799036562594`, 
        \(-0.753412219870961319`\)}, {1.90210752639692053`, 
        \(-0.504441927965866199`\)}, {1.94591014905531327`, 
        \(-0.207717381875106266`\)}, {1.98787434815434558`, 
        0.0793337137872103781`}, {2.02814824729228515`, 
        0.371952258167021998`}, {2.06686275947297559`, 
        0.62157348218313615`}, {2.10413415427020744`, 
        0.831784037861858749`}, {2.14006616349627076`, 
        0.954520631698938792`}, {2.17475172148416096`, 
        0.999103113177188895`}, {2.20827441352280429`, 
        0.957559405664176921`}, {2.24070968927595837`, 
        0.812632841838091124`}, {2.27212588550933691`, 
        0.599839866922566322`}, {2.3025850929940459`, 0.383671623459636457`}}
      \)], "Output"]
}, Closed]],

Cell["Here is a graph of the transformed data.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(ListPlot[final, PlotJoined \[Rule] True]; \)\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.413614 0.307846 0.295473 [
[.23062 .29535 -9 -9 ]
[.23062 .29535 9 0 ]
[.43742 .29535 -3 -9 ]
[.43742 .29535 3 0 ]
[.64423 .29535 -9 -9 ]
[.64423 .29535 9 0 ]
[.85104 .29535 -3 -9 ]
[.85104 .29535 3 0 ]
[.01131 .01237 -12 -4.5 ]
[.01131 .01237 0 4.5 ]
[.01131 .16011 -24 -4.5 ]
[.01131 .16011 0 4.5 ]
[.01131 .45558 -18 -4.5 ]
[.01131 .45558 0 4.5 ]
[.01131 .60332 -6 -4.5 ]
[.01131 .60332 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.23062 .30785 m
.23062 .3141 L
s
[(0.5)] .23062 .29535 0 1 Mshowa
.43742 .30785 m
.43742 .3141 L
s
[(1)] .43742 .29535 0 1 Mshowa
.64423 .30785 m
.64423 .3141 L
s
[(1.5)] .64423 .29535 0 1 Mshowa
.85104 .30785 m
.85104 .3141 L
s
[(2)] .85104 .29535 0 1 Mshowa
.125 Mabswid
.06517 .30785 m
.06517 .3116 L
s
.10653 .30785 m
.10653 .3116 L
s
.14789 .30785 m
.14789 .3116 L
s
.18926 .30785 m
.18926 .3116 L
s
.27198 .30785 m
.27198 .3116 L
s
.31334 .30785 m
.31334 .3116 L
s
.3547 .30785 m
.3547 .3116 L
s
.39606 .30785 m
.39606 .3116 L
s
.47878 .30785 m
.47878 .3116 L
s
.52015 .30785 m
.52015 .3116 L
s
.56151 .30785 m
.56151 .3116 L
s
.60287 .30785 m
.60287 .3116 L
s
.68559 .30785 m
.68559 .3116 L
s
.72695 .30785 m
.72695 .3116 L
s
.76831 .30785 m
.76831 .3116 L
s
.80968 .30785 m
.80968 .3116 L
s
.8924 .30785 m
.8924 .3116 L
s
.93376 .30785 m
.93376 .3116 L
s
.97512 .30785 m
.97512 .3116 L
s
.25 Mabswid
0 .30785 m
1 .30785 L
s
.02381 .01237 m
.03006 .01237 L
s
[(-1)] .01131 .01237 1 0 Mshowa
.02381 .16011 m
.03006 .16011 L
s
[(-0.5)] .01131 .16011 1 0 Mshowa
.02381 .45558 m
.03006 .45558 L
s
[(0.5)] .01131 .45558 1 0 Mshowa
.02381 .60332 m
.03006 .60332 L
s
[(1)] .01131 .60332 1 0 Mshowa
.125 Mabswid
.02381 .04192 m
.02756 .04192 L
s
.02381 .07147 m
.02756 .07147 L
s
.02381 .10101 m
.02756 .10101 L
s
.02381 .13056 m
.02756 .13056 L
s
.02381 .18966 m
.02756 .18966 L
s
.02381 .2192 m
.02756 .2192 L
s
.02381 .24875 m
.02756 .24875 L
s
.02381 .2783 m
.02756 .2783 L
s
.02381 .33739 m
.02756 .33739 L
s
.02381 .36694 m
.02756 .36694 L
s
.02381 .39649 m
.02756 .39649 L
s
.02381 .42603 m
.02756 .42603 L
s
.02381 .48513 m
.02756 .48513 L
s
.02381 .51468 m
.02756 .51468 L
s
.02381 .54422 m
.02756 .54422 L
s
.02381 .57377 m
.02756 .57377 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .31034 m
.13233 .39837 L
.21821 .48729 L
.28929 .54068 L
.34993 .5917 L
.4028 .60332 L
.44967 .58925 L
.49177 .55448 L
.52998 .49151 L
.56495 .41362 L
.5972 .33206 L
.62711 .23981 L
.65501 .16269 L
.68114 .08806 L
.70572 .04914 L
.72892 .01787 L
.75088 .01472 L
.77174 .03631 L
.7916 .08523 L
.81055 .1588 L
.82866 .24647 L
.84602 .33129 L
.86268 .41775 L
.87869 .4915 L
.89411 .55362 L
.90897 .58988 L
.92332 .60305 L
.93718 .59078 L
.9506 .54796 L
.96359 .48508 L
.97619 .42121 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  Evaluatable->False,
  AspectRatioFixed->True,
  ImageSize->{299.062, 184.5},
  ImageMargins->{{48, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004[0000^0P10`4000010?ooooooc?ooZ_ooI_oo
<ooo0?o<ooo<c?o<VC/k>gYjN[Vi^OShn03ooeGooj[ooonI<onI0?mVoomVc?mVVOmVI_mV<omV0?lc
oclo?ginO[fm_Oclo5D00:X00?l00?l0VOl0I_l0<ol00<coolcoc<coVLcoIP<30d92@X61PL30`000
EED0EJX0EOl0ELbIolbIc<bIVLbII/bI<lbI0<aVolaVc0L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0Z/`c
<l`c0<`0ol`0c<`0VL`0I/`0<l`000/;2dY:BXV9RLS8b000oeD0ojX0ool0oiW<VIW<IYW<<iW<09VI
oiVIc9VIVIVIIPl?3di>CXf=SLc<c01E05EE0:YE0?mE09TcoiTcc9TcVITcIYTc<iTc09T0oiT0c1<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEEFKo<fKo06K<ofK<c6K<VFK<IVK<<fK<01LG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZVIVVFIVIVIV<fIV06HcofHcc6HcVFHcIQ/K6eYJFYVIVMSHf01EoeEEojYEoomEoc?o
oc?oc3?oVC?oIS?o<c?o03?<oc?<c1lO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ03>I<c>I03=Voc=Vc3=V
VC=VIS=V<c=V02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZEC<0VC<0IS<0<c<0003oo`3oc03oV@3oIRLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2Io`2Ic02IV@2IIP2I<`2I001Vo`1Vc2/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`0c<`0c0000o`00c000V@00IP00<nh002l_;fi^KZf][Nc/k03o05Go0:[o0?oo0140
003^003M002k002Z0028001g001E03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@00M`00E@00A0008P00
4Nk^k]gMgK^k^cLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l0;0000?l0;0000?l0;0000?l0;0000?l0
;0000?l0;00001/000?o0000o`0>00006`000ol0003o00h0000C00?o1@000ol0003o00h0000D0003
o`0000@000?o0000o`0>00003@05o`8000?o00001003ol@01?m5000050000ol000040003o`000<00
1?l30003o`0004<0000D0003o`0000@000?o0000`0000ol000050003o`000480000C00;o1P000ol0
002o0003o`0000L000?o0000@@0001/000?o0000_P000ol000090003o`000400000K0003o`000;h0
00?o00002P000ol0000o00006`000ol0002m0003o`0000`000?o0000?P0001/000?o0000_0000ol0
000=0003o`0003h0000K00;o_@000ol0000>0003o`0003d0000K0003o`000;/000?o00003`000ol0
000m00006`000ol0002j0003o`00014000?o0000?00001/000?o0000^P000ol0000A0003o`0003`0
000K0003o`000;T000?o00004P000ol0000l00006`000ol0002h0003o`0001@000?o0000>`0001/0
00?o0000^0000ol0000D0003o`0003/0000K0003o`000;L000?o00005P000ol0000j00006`02okL0
00?o00005`000ol0000j00006`000ol0002f0003o`0001P000?o0000>@0001/000?o0000]@000ol0
000I0003o`0003T0000K0003o`000;D000?o00006@000ol0000i00006`000ol0002d0003o`0001/0
00?o0000>00001/000?o0000/`000ol0000L0003o`0003P0000K0003o`000;<000?o000070000ol0
000h00006`000ol0002b0003o`0001h000?o0000=`0001/00_nc0003o`0001h000?o0000=`0001/0
00?o0000/P000ol0000N0003o`0003L0000K0003o`000;4000?o00007`000ol0000g00006`000ol0
002a0003o`00020000?o0000=P0001/000?o0000/@000ol0000P0003o`0003H0000K0003o`000;00
00?o00008@000ol0000f00006`000ol0002`0003o`00024000?o0000=P0001/000?o0000/0000ol0
000R0003o`0003D0000K0003o`000:l000?o00008`000ol0000e00006`02ok0000?o00008`000ol0
000e00006`000ol0002_0003o`0002<000?o0000=@0001/000?o0000[P000ol0000U0003o`0003@0
000K0003o`000:h000?o00009@000ol0000d00006`000ol0002^0003o`0002D000?o0000=00001/0
00?o0000[@000ol0000V0003o`0003@0000800;o1002o`<00ol50003o`000:d000?o00009`000ol0
000c00001`001?l00?l300;o1P000ol000020003o`000:d000?o00009`000ol0000c000000<0ool0
0ol01@3o003o00/000?o00000P03oj`000?o0000:0000ol0000c00001`001?l00?l800?o1@000ol0
002/0003o`0002P000?o0000<`0000L000Co003o20000ol000050003o`000:`000?o0000:@000ol0
000b00002002o`T01?l40003o`000:/000?o0000:P000ol0000b00006`000ol0002[0003o`0002X0
00?o0000<P0001/000?o0000Z`000ol0000Z0003o`000380000K0003o`000:X000?o0000:`000ol0
000b00006`000ol0002Z0003o`0002`000?o0000<@0001/00_n[0003o`0002`000?o0000<@0001/0
00?o0000Z@000ol0000]0003o`000340000K0003o`000:T000?o0000;@000ol0000a00006`000ol0
002X0003o`0002h000?o0000<@0001/000?o0000Z0000ol0000_0003o`000300000K0003o`000:P0
00?o0000;`000ol0000`00006`000ol0002W0003o`00030000?o0000<00001/000?o0000Y`000ol0
000`0003o`000300000K00;oY`000ol0000a0003o`000300000K0003o`000:H000?o0000<P000ol0
000_00006`000ol0002V0003o`00038000?o0000;`0001/000?o0000Y@000ol0000c0003o`0002l0
000K0003o`000:D000?o0000<`000ol0000_00006`000ol0002U0003o`0003<000?o0000;`0001/0
00?o0000Y0000ol0000e0003o`0002h0000K0003o`000:@000?o0000=@000ol0000^00006`02ojD0
00?o0000=@000ol0000^00006`000ol0002S0003o`0003H000?o0000;P0001/000?o0000X`000ol0
000f0003o`0002h0000K0003o`000:<000?o0000=`000ol0000]00006`000ol0002R0003o`0003P0
00?o0000;@0001/000?o0000XP000ol0000h0003o`0002d0000K0003o`0002l00_l400;o0`03oc40
0ol`00?o1002o`<00ol]0003o`0000Co:@0001/000?o0000;P001?l00?l300;o1P000ol0000_0003
o`0002l00_l500;o1P000ol0000Z0005o`000?l0:`0001/000?o0000;P001?l00?l;0003o`0002l0
00?o0000;`02o`d000?o0000:`001Ol0003o02X0000K00;o;`001?l00?l800?o<P000ol0000_00;o
2P03obh000?o00000P000ol0000W00006`000ol0000^0004o`00o`P000?o0000<P000ol0000^0003
o`3o00X000?o0000;P000ol0o`020003o`0002L0000K0003o`0002l00_l900Co<002oc000ol:00Co
;@000ol00002obX0000K0003o`000:0000?o0000?0000ol0000[00006`000ol0002O0003o`0003d0
00?o0000:`0001/000?o0000W`000ol0000m0003o`0002/0000K0003o`0009l000?o0000?@000ol0
000[00006`000ol0002N0003o`0003h000?o0000:`0001@0oolHo`006`000ol0o`080003o`0000T0
00?o000020000ol000090003o`0000P000?o00002@000ol000080003o`0000T000?o000020000ol0
00090003o`0000P000?o00002@000ol000080003o`0000P00_l:0003o`0000P000?o00002@000ol0
00080003o`0000T000?o00001P000ol0o`0;0003o`0000P000?o00002@000ol0000500006`001?l0
0?nL0003o`00040000?o0000:P0001/000Go0000o`2K0003o`00040000?o0000:P0001/000?o0000
0P000ol0002H0003o`00040000?o0000:P0001/000?o00000`02oiL000?o0000@P000ol0000Y0000
6`000ol000050003o`0009@000?o0000@P000ol0000Y00006`000ol000060003o`0009<000?o0000
@P000ol0000Y00006`02o`P000?o0000T@000ol000130003o`0002T0000K0003o`0000P000?o0000
T0000ol000130003o`0002T0000K0003o`0000T00_n@0003o`0004@000?o0000:00001/000?o0000
2`000ol0002<0003o`0004D000?o0000:00001/000?o000030000ol0002;0003o`0004D000?o0000
:00001/000?o00003@000ol000290003o`0004H000?o0000:00001/000?o00003P000ol000280003
o`0004H000?o0000:00001/000?o00003`02ohP000?o0000AP000ol0000X00006`02oa8000?o0000
Q0000ol000180003o`0002L0000K0003o`00018000?o0000P`000ol000180003o`0002L0000K0003
o`0001<000?o0000P@000ol000190003o`0002L0000K0003o`0001@000?o0000P0000ol000190003
o`0002L0000K0003o`0001D00_n00003o`0004T000?o00009`0001/000?o00005`000ol0001l0003
o`0004X000?o00009`0001/000?o000060000ol0001k0003o`0004/000?o00009P0001/000?o0000
6@000ol0001j0003o`0004/000?o00009P0001/00_lK0003o`0007P000?o0000C0000ol0000V0000
6`000ol0000K0003o`0007L000?o0000C0000ol0000V00006`000ol0000L0003o`0007D000?o0000
C@000ol0000V00006`000ol0000M0003o`0007@000?o0000C@000ol0000V00006`000ol0000N0003
o`0007<000?o0000CP000ol0000U00006`000ol0000O0003o`00074000?o0000C`000ol0000U0000
6`000ol0000P0003o`00070000?o0000C`000ol0000U00006`000ol0000Q0003o`0006h000?o0000
D0000ol0000M0003o`0000D0000K0003o`00028000?o0000K@000ol0001@0003o`0001d000?o0000
1@0001/00_lT0003o`0006/000?o0000DP000ol0000L0003o`0000D0000K0003o`0002@000?o0000
JP000ol0001B0003o`0001/000?o00001P0001/000?o00009@000ol0001X0003o`0005<000?o0000
6`000ol0000600006`000ol0000V0003o`0006L000?o0000D`000ol0000K0003o`0000H0000K0003
o`0002L000?o0000IP000ol0001D0003o`0001X000?o00001P0001/000?o0000:0000ol0001T0003
o`0005D000?o00006P000ol0000600002002o`@00_l300?o1@000ol0000Y0003o`0006<000?o0000
E@000ol0000I0003o`0000L000070004o`00o`<00_l60003o`00008000?o0000:P000ol0001Q0003
o`0005H000?o00006@000ol0000700001`001?l00?l;0003o`0000800ol[0003o`00060000?o0000
E`000ol0000H0003o`0000L000070004o`00o`P00ol50003o`0002`000?o0000GP000ol0001H0003
o`0001P000?o00001`0000L000Co003o20000ol000050003o`0002d000?o0000G@000ol0001H0003
o`0001L000?o0000200000P00_l900Co10000ol0000^0003o`0005/000?o0000F@000ol0000G0003
o`0000P0000K0003o`0002l000?o0000FP000ol0001I0003o`0001L000?o0000200001/000?o0000
<0000ol0001H0003o`0005/000?o00005P000ol0000800006`000ol0000a0003o`0005L000?o0000
F`000ol0000F0003o`0000P0000K0003o`00038000?o0000EP000ol0001K0003o`0001D000?o0000
2@0001/00_ld00;oE@000ol0001L0003o`0001D000?o00002@0001/000?o0000=@000ol0001B0003
o`0005d000?o000050000ol0000900006`000ol0000f0003o`00050000?o0000GP000ol0000D0003
o`0000T0000K0003o`0003L00_m@0003o`0005h000?o000050000ol0000900006`000ol0000i0003
o`0004`000?o0000G`000ol0000C0003o`0000X0000K0003o`0003X000?o0000B`000ol0001P0003
o`00018000?o00002P0001/000?o0000>`02odX000?o0000H@000ol0000B0003o`0000X0000K0003
o`0003d000?o0000AP000ol0001R0003o`00018000?o00002P0001/00_lo0003o`0004D000?o0000
HP000ol0000B0003o`0000X0000K0003o`0003l00_m40003o`0006@000?o000040000ol0000;0000
6`000ol000110003o`00044000?o0000I0000ol0000@0003o`0000/0000K0003o`00048000?o0000
?`000ol0001U0003o`00010000?o00002`0001/000?o0000@`02och000?o0000IP000ol0000@0003
o`0000/0000K0003o`0004D000?o0000>`000ol0001V0003o`00010000?o00002`0001/000?o0000
AP000ol0000i0003o`0006P000?o00003`000ol0000;00006`000ol0001700;o>@000ol0001X0003
o`0000h000?o0000300001/00_m:0003o`0003D000?o0000J@000ol0000>0003o`0000`0000K0003
o`0004X000?o0000<`000ol0001Z0003o`0000h000?o0000300001/000?o0000B`000ol0000b0003
o`0006/000?o00003@000ol0000<00006`000ol0001<0003o`0002l00_m^0003o`0000`000?o0000
3@0001/000?o0000C@000ol0000]0003o`0006h000?o000030000ol0000=00006`000ol0001>0003
o`0002/000?o0000L0000ol0000;0003o`0000d0000K0003o`0004l00_lZ0003o`00074000?o0000
2P000ol0000>00006`000ol0001A0003o`0002H000?o0000LP000ol0000:0003o`0000h0000K00;o
D`000ol0000S00;oMP000ol000090003o`0000h0000K0003o`0005<000?o00008@000ol0001f0003
o`0000P000?o00003`0001/000?o0000E0000ol0000O0003o`0007P000?o00001`000ol0000?0000
6`000ol0001E0003o`0001d000?o0000N@000ol000070003o`0000l0000K0003o`0005H000?o0000
6`000ol0001j0003o`0000H000?o0000400001/000?o0000E`03oaL00omn0003o`0000D000?o0000
400001/000?o0000FP04oa000on20003o`0000<000?o00004@0001<00ol50003o`0005h00ol:00?o
QP001Ol0003o01@0000D0003o`0000@000?o0000H@04o`<00on:0003o`3o01D0000D0003o`0000@0
0omU00?oSP000ol0000D000050000ol000040003o`000?l03P0001@000?o000010000ol0003o00h0
000C00;o1P000ol0003o00h0000K0003o`000?l03P000?l0;0000?l0;0000?l0;0000?l0;0000?l0
;0000001\
\>"],
  ImageRangeCache->{{{0, 298.062}, {183.5, 0}} -> {-0.239562, -1.12022, 
  0.00872207, 0.0122095}}]
}, Closed]],

Cell[TextData[{
  "Notice that one effect of ",
  StyleBox["Transpose",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " is to reverse the dimensions of a matrix."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Dimensions[mydata]\)], "Input"],

Cell[BoxData[
    \({31, 2}\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Dimensions[Transpose[mydata]]\)], "Input"],

Cell[BoxData[
    \({2, 31}\)], "Output"]
}, Closed]],

Cell["Here are the dimensions of our array of hurricane data.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Dimensions[hurr]\)], "Input"],

Cell[BoxData[
    \({10, 3}\)], "Output"]
}, Closed]],

Cell["\<\
Transposing the array returns a list containing a list of all the \
hurricane names, a list of all the wind speeds, and a list of all the \
pressures.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(transhurr = Transpose[hurr]\)], "Input"],

Cell[BoxData[
    \({{"Allison", "Barry", "Chantal", "Dean", "Erin", "Felix", "Gabrielle", 
        "Humberto", "Iris", "Jerry"}, {65, 50, 60, 40, 75, 115, 60, 90, 75, 
        35}, {987, 995, 992, 999, 975, 950, 998, 970, 970, 1003}}\)], "Output"]
}, Closed]],

Cell["\<\
Given the transformed list, we can obtain ordered pairs of wind \
speeds and pressures by first extracting the respective lists.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(transhurr[\([{2, 3}]\)]\)], "Input"],

Cell[BoxData[
    \({{65, 50, 60, 40, 75, 115, 60, 90, 75, 35}, {987, 995, 992, 999, 975, 
        950, 998, 970, 970, 1003}}\)], "Output"]
}, Closed]],

Cell["\<\
Next we transpose the previous list to obtain the desired \
pairs.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(hurrpairs = Transpose[transhurr[\([{2, 3}]\)]]\)], "Input"],

Cell[BoxData[
    \({{65, 987}, {50, 995}, {60, 992}, {40, 999}, {75, 975}, {115, 950}, {
        60, 998}, {90, 970}, {75, 970}, {35, 1003}}\)], "Output"]
}, Closed]],

Cell[TextData[{
  "The data are now in a form to be plotted using ",
  StyleBox["ListPlot",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(ListPlot[hurrpairs, 
      FrameLabel \[Rule] {"\<Wind Speed\>", "\<Pressure\>"}, 
      PlotLabel \[Rule] 
        StyleForm["\<1995 Tropical Storm Data\>", 
          FontFamily \[Rule] "\<Helvetica\>", FontSize \[Rule] 10], 
      PlotStyle \[Rule] PointSize[0.02], Frame \[Rule] True, 
      RotateLabel \[Rule] True, TextStyle \[Rule] {FontSize \[Rule] 9}]; 
    \)\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.392857 0.0119048 -10.5357 0.0111057 [
[.08333 -0.0125 -7 -14 ]
[.08333 -0.0125 7 0 ]
[.32143 -0.0125 -7 -14 ]
[.32143 -0.0125 7 0 ]
[.55952 -0.0125 -7 -14 ]
[.55952 -0.0125 7 0 ]
[.79762 -0.0125 -9.5 -14 ]
[.79762 -0.0125 9.5 0 ]
[ 0 0 -0.125 0 ]
[.5 -0.0125 -27.1875 -28 ]
[.5 -0.0125 27.1875 -14 ]
[-0.0125 .01472 -19 -7 ]
[-0.0125 .01472 0 7 ]
[-0.0125 .12577 -19 -7 ]
[-0.0125 .12577 0 7 ]
[-0.0125 .23683 -19 -7 ]
[-0.0125 .23683 0 7 ]
[-0.0125 .34789 -19 -7 ]
[-0.0125 .34789 0 7 ]
[-0.0125 .45894 -19 -7 ]
[-0.0125 .45894 0 7 ]
[-0.0125 .57 -24 -7 ]
[-0.0125 .57 0 7 ]
[ 0 0 -0.125 0 ]
[-0.01875 .30902 -38 -22 ]
[-0.01875 .30902 -24 22 ]
[ 0 .61803 .125 0 ]
[ 1 0 .125 0 ]
[.5 .63053 -57.2188 0 ]
[.5 .63053 57.2188 14 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.08333 0 m
.08333 .00625 L
s
gsave
.08333 -0.0125 -52 -18 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 22 translate 1 -1 scale
47.000000 14.000000 moveto
/Courier findfont 9.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(40) show
1.000000 setlinewidth
grestore
.32143 0 m
.32143 .00625 L
s
gsave
.32143 -0.0125 -52 -18 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 22 translate 1 -1 scale
47.000000 14.000000 moveto
/Courier findfont 9.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(60) show
1.000000 setlinewidth
grestore
.55952 0 m
.55952 .00625 L
s
gsave
.55952 -0.0125 -52 -18 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 22 translate 1 -1 scale
47.000000 14.000000 moveto
/Courier findfont 9.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(80) show
1.000000 setlinewidth
grestore
.79762 0 m
.79762 .00625 L
s
gsave
.79762 -0.0125 -54.5 -18 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 22 translate 1 -1 scale
47.000000 14.000000 moveto
/Courier findfont 9.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(100) show
1.000000 setlinewidth
grestore
.125 Mabswid
.14286 0 m
.14286 .00375 L
s
.20238 0 m
.20238 .00375 L
s
.2619 0 m
.2619 .00375 L
s
.38095 0 m
.38095 .00375 L
s
.44048 0 m
.44048 .00375 L
s
.5 0 m
.5 .00375 L
s
.61905 0 m
.61905 .00375 L
s
.67857 0 m
.67857 .00375 L
s
.7381 0 m
.7381 .00375 L
s
.02381 0 m
.02381 .00375 L
s
.85714 0 m
.85714 .00375 L
s
.91667 0 m
.91667 .00375 L
s
.97619 0 m
.97619 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
gsave
.5 -0.0125 -72.1875 -32 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 22 translate 1 -1 scale
47.000000 14.000000 moveto
/Courier findfont 9.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(Wind) show
72.187500 14.000000 moveto
(Speed) show
1.000000 setlinewidth
grestore
0 .01472 m
.00625 .01472 L
s
gsave
-0.0125 .01472 -64 -11 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 22 translate 1 -1 scale
47.000000 14.000000 moveto
/Courier findfont 9.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(950) show
1.000000 setlinewidth
grestore
0 .12577 m
.00625 .12577 L
s
gsave
-0.0125 .12577 -64 -11 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 22 translate 1 -1 scale
47.000000 14.000000 moveto
/Courier findfont 9.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(960) show
1.000000 setlinewidth
grestore
0 .23683 m
.00625 .23683 L
s
gsave
-0.0125 .23683 -64 -11 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 22 translate 1 -1 scale
47.000000 14.000000 moveto
/Courier findfont 9.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(970) show
1.000000 setlinewidth
grestore
0 .34789 m
.00625 .34789 L
s
gsave
-0.0125 .34789 -64 -11 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 22 translate 1 -1 scale
47.000000 14.000000 moveto
/Courier findfont 9.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(980) show
1.000000 setlinewidth
grestore
0 .45894 m
.00625 .45894 L
s
gsave
-0.0125 .45894 -64 -11 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 22 translate 1 -1 scale
47.000000 14.000000 moveto
/Courier findfont 9.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(990) show
1.000000 setlinewidth
grestore
0 .57 m
.00625 .57 L
s
gsave
-0.0125 .57 -69 -11 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 22 translate 1 -1 scale
47.000000 14.000000 moveto
/Courier findfont 9.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(1000) show
1.000000 setlinewidth
grestore
.125 Mabswid
0 .03693 m
.00375 .03693 L
s
0 .05914 m
.00375 .05914 L
s
0 .08135 m
.00375 .08135 L
s
0 .10356 m
.00375 .10356 L
s
0 .14798 m
.00375 .14798 L
s
0 .1702 m
.00375 .1702 L
s
0 .19241 m
.00375 .19241 L
s
0 .21462 m
.00375 .21462 L
s
0 .25904 m
.00375 .25904 L
s
0 .28125 m
.00375 .28125 L
s
0 .30346 m
.00375 .30346 L
s
0 .32568 m
.00375 .32568 L
s
0 .3701 m
.00375 .3701 L
s
0 .39231 m
.00375 .39231 L
s
0 .41452 m
.00375 .41452 L
s
0 .43673 m
.00375 .43673 L
s
0 .48116 m
.00375 .48116 L
s
0 .50337 m
.00375 .50337 L
s
0 .52558 m
.00375 .52558 L
s
0 .54779 m
.00375 .54779 L
s
0 .59221 m
.00375 .59221 L
s
0 .61442 m
.00375 .61442 L
s
.25 Mabswid
0 0 m
0 .61803 L
s
gsave
-0.01875 .30902 -98 -11 Mabsadd m
1 1 Mabs scale
currentpoint translate
67 11 translate
90 rotate
-67 -11 translate
0 22 translate 1 -1 scale
47.000000 14.000000 moveto
/Courier findfont 9.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(Pressure) show
1.000000 setlinewidth
grestore
.08333 .61178 m
.08333 .61803 L
s
.32143 .61178 m
.32143 .61803 L
s
.55952 .61178 m
.55952 .61803 L
s
.79762 .61178 m
.79762 .61803 L
s
.125 Mabswid
.14286 .61428 m
.14286 .61803 L
s
.20238 .61428 m
.20238 .61803 L
s
.2619 .61428 m
.2619 .61803 L
s
.38095 .61428 m
.38095 .61803 L
s
.44048 .61428 m
.44048 .61803 L
s
.5 .61428 m
.5 .61803 L
s
.61905 .61428 m
.61905 .61803 L
s
.67857 .61428 m
.67857 .61803 L
s
.7381 .61428 m
.7381 .61803 L
s
.02381 .61428 m
.02381 .61803 L
s
.85714 .61428 m
.85714 .61803 L
s
.91667 .61428 m
.91667 .61803 L
s
.97619 .61428 m
.97619 .61803 L
s
.25 Mabswid
0 .61803 m
1 .61803 L
s
.99375 .01472 m
1 .01472 L
s
.99375 .12577 m
1 .12577 L
s
.99375 .23683 m
1 .23683 L
s
.99375 .34789 m
1 .34789 L
s
.99375 .45894 m
1 .45894 L
s
.99375 .57 m
1 .57 L
s
.125 Mabswid
.99625 .03693 m
1 .03693 L
s
.99625 .05914 m
1 .05914 L
s
.99625 .08135 m
1 .08135 L
s
.99625 .10356 m
1 .10356 L
s
.99625 .14798 m
1 .14798 L
s
.99625 .1702 m
1 .1702 L
s
.99625 .19241 m
1 .19241 L
s
.99625 .21462 m
1 .21462 L
s
.99625 .25904 m
1 .25904 L
s
.99625 .28125 m
1 .28125 L
s
.99625 .30346 m
1 .30346 L
s
.99625 .32568 m
1 .32568 L
s
.99625 .3701 m
1 .3701 L
s
.99625 .39231 m
1 .39231 L
s
.99625 .41452 m
1 .41452 L
s
.99625 .43673 m
1 .43673 L
s
.99625 .48116 m
1 .48116 L
s
.99625 .50337 m
1 .50337 L
s
.99625 .52558 m
1 .52558 L
s
.99625 .54779 m
1 .54779 L
s
.99625 .59221 m
1 .59221 L
s
.99625 .61442 m
1 .61442 L
s
.25 Mabswid
1 0 m
1 .61803 L
s
gsave
.5 .63053 -102.219 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 22 translate 1 -1 scale
47.000000 14.000000 moveto
/Helvetica findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(1995) show
70.125000 14.000000 moveto
(Tropical) show
107.125000 14.000000 moveto
(Storm) show
137.125000 14.000000 moveto
(Data) show
1.000000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.02 w
.38095 .42563 Mdot
.20238 .51447 Mdot
.32143 .48116 Mdot
.08333 .5589 Mdot
.5 .29236 Mdot
.97619 .01472 Mdot
.32143 .54779 Mdot
.67857 .23683 Mdot
.5 .23683 Mdot
.02381 .60332 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{299.062, 184.75},
  ImageMargins->{{48, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004[0000^0P10`4000010?ooooooc?ooZ_ooI_oo
<ooo0?o<ooo<c?o<VC/k>gYjN[Vi^OShn03ooeGooj[ooonI<onI0?mVoomVc?mVVOmVI_mV<omV0?lc
oclo?ginO[fm_Oclo5D00:X00?l00?l0VOl0I_l0<ol00<coolcoc<coVLcoIP<30d92@X61PL30`000
EED0EJX0EOl0ELbIolbIc<bIVLbII/bI<lbI0<aVolaVc0L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0Z/`c
<l`c0<`0ol`0c<`0VL`0I/`0<l`000/;2dY:BXV9RLS8b000oeD0ojX0ool0oiW<VIW<IYW<<iW<09VI
oiVIc9VIVIVIIPl?3di>CXf=SLc<c01E05EE0:YE0?mE09TcoiTcc9TcVITcIYTc<iTc09T0oiT0c1<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEEFKo<fKo06K<ofK<c6K<VFK<IVK<<fK<01LG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZVIVVFIVIVIV<fIV06HcofHcc6HcVFHcIQ/K6eYJFYVIVMSHf01EoeEEojYEoomEoc?o
oc?oc3?oVC?oIS?o<c?o03?<oc?<c1lO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ03>I<c>I03=Voc=Vc3=V
VC=VIS=V<c=V02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZEC<0VC<0IS<0<c<0003oo`3oc03oV@3oIRLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2Io`2Ic02IV@2IIP2I<`2I001Vo`1Vc2/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`0c<`0c0000o`00c000V@00IP00<nh002l_;fi^KZf][Nc/k03o05Go0:[o0?oo0140
003^003M002k002Z0028001g001E03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@00M`00E@00A0008P00
4Nk^k]gMgK^k^cLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l0;0000?l0;0000?l0;0000:l00omi0000
/0000ol0001h0000T@001?l0o`05o`8000Co003o0P03o`H00ol200?o1003o`800ol300?oIP000940
00?o0?l00`000ol000020006o`00o`3o0P000ol000040006o`00o`3o0P001?l00?l40003o`0000<0
00Co003oIP00094000?o0?l00`000ol000020006o`00o`3o0P000ol0000600;o00D0o`00o`0200Co
00<0ool00_l20004o`00ofH0002A00?o0`000ol000020006o`00o`3o0P000ol0000400;o0`001?l0
0?l20006o`00o`3o0P001?l00?l20003o`0006@0002@0006o`000?l00_l300Go0P03o`H000?o0000
1Ol400;o0`02o`@00omV0000T002o`030?oo00l000?o00001@03oaD000?o0000I00009L000?o0000
2@02oah00_mV0000o`0/0000o`0/0000o`0/0000o`0/0000o`0/0000o`0/0000o`0/0000C0001?l0
0002obd00_l300;o;P02o`<00_l[00?o0P02o`@00_lh0000BP04o`050?l00?l0:`001_l00?l0o`80
00?o0000:P001_l00?l0o`8000?o0000:@001?l00?l20004o`00o`8000?o0000=@0004X000?o0?l0
0P001?l00?l[0006o`00o`3o0P000ol0000Z0006o`00o`3o0P000ol0000Y0004o`00o`8000Co003o
0P000ol0000e0000BP000ol0o`020004o`00ob/00ol20004o`00obd00_l20004o`00ob/000Co003o
0P001?l00?l20003o`0003D0001;00;o0P001?l00?l[0003o`00008000Co003o;0001_l00?l0o`80
00?o0000:@001?l00?l20004o`00o`8000?o0000=@0004`000Co00000_l]00?o0P02obh00_l300;o
:`02o`<00_l400;o>0000?l0;0000?l0;0000?l0;0000?l0;0000?l0;0000?l0;00003/0g_lB0000
:@03o`800ol400;o10000ol0000@0003o`00034000?o0000<P000ol0000a0003o`0002@00_l40003
o`000100000/0003o`00008000Co003o0P001Ol0003o0=D01?l30003o`000100000Z00?o10001?l0
0?l20004o`0000?od`04o`040?oooa80000Y0005o`00o`000ol30004o`00o`<000?o0000e002o`@0
00?o0000400002T000Ko003o0?l50004o`00o`<000?o0000fP000ol0000@0000:P02o`801?l300;o
10000ol0003J0003o`000100000k0003o`000=X000?o0000400003/00_oJ00;o4P0003/000?o0000
fP000ol0000@0000>`000ol0003J0003o`000100000k0003o`000=X000?o0000400003/000?o0000
fP000ol0000@0000>`02omX00_lB0000>`000ol0003J0003o`000100000k0003o`000=X000?o0000
400003/000?o0000fP000ol0000@0000>`02omX00_lB0000>`000ol0003J0003o`000100000k0003
o`000=X000?o0000400003/000?o0000fP000ol0000@0000>`000ol0003J0003o`000100000k00;o
fP02oa80000k0003o`000=X000?o0000400003/000?o0000fP000ol0000@0000:@03o`<00_l400;o
10000ol0003J0003o`000100000/0003o`3o008000Co003o0P001Ol0003o0=`000?o0000400002X0
0ol01@3o003o008000Co003o0`03omP00olB0000:@001Ol00?l000?o0`001?l00?l30003o`000=X0
00?o0000400002T000Ko003o0?l50004o`00o`<000?o0000fP000ol0000@0000:P02o`<00ol300;o
10000ol0003J0003o`000100000k0003o`000=X000?o0000400003/00_oJ00;o4P0003/000?o0000
fP000ol0000@0000>`000ol0003J0003o`000100000k0003o`000=X000?o0000400003/000?o0000
fP000ol0000@0000>`02omX00_lB0000>`000ol0003J0003o`000100000k0003o`000=X000?o0000
400003/000?o0000fP000ol0000@0000>`000ol0003J0003o`000100000k00;ofP02oa80000k0003
o`000=X000?o0000400003/000?o0000fP000ol0000@0000>`000ol0003J0003o`000100000k0003
o`000=X000?o0000400003/00_oJ00;o4P0003/000?o0000fP000ol0000@00006`03oad000?o0000
fP000ol0000@000070000ol0000:00?o0`000ol0000300;o10000ol0001[00;o9@02odH000?o0000
400001`00ol=0004o`00o`@000Co003o0`000ol0001Z00Co8`04odD000?o0000400001`000Co003o
2P03o`<000Go0000o`020004o`0000?oJP04ob<01?m300?o4P0001`000Co003o2@001?l00?l30005
o`000?l00P001Ol0003o06d00_lU00;oAP000ol0000@00006`05o`T000Co003o10001?l00?l20005
o`000?l0g0000ol0000@00007@000ol0000:00;o0P04o`<00_l40003o`000=X000?o0000400001d0
00?o00006`000ol0003J0003o`000100000M0003o`0001/00_oJ00;o4P0001`01?lK0003o`000=X0
00?o0000400001d00olK0003o`000=X000?o0000400001`000?o000070000ol0003J0003o`000100
000L00Co6`000ol0003J0003o`000100000L0004o`00oa/00_oJ00;o4P0001d00_lL0003o`0006/0
0_m]0003o`000100000k0003o`0006X01?m/0003o`000100000L00Co6`000ol0001Z00CoK0000ol0
000@00007`000ol0000I00;oK002of`00_lB00007004oa/000?o0000fP000ol0000@000070000ol0
000L0003o`000=X000?o0000400001`01?lK0003o`000=X000?o0000400001`01?lK0003o`000=X0
00?o0000400001l000?o00006@02omX00_lB00007004oa/000?o0000fP000ol0000@000070000ol0
000L0003o`000=X000?o0000400001`01?l900?o0`02o`@00_l40003o`000=X000?o0000400002`0
00?o0?l00P001?l00?l20005o`000?l0g0000ol0000@00007004o`X00ol01@3o003o008000Co003o
0`03omP00olB000070001?l00?l90004o`00o`800_l30004o`00o`<000?o0000fP000ol0000@0000
70001?l00?l90006o`00o`3o0P001?l00?l20005o`000?l0g0000ol0000@000070001?l00?l:00;o
0`02o`@00_l40003o`000=X000?o0000400001/00_l20003o`0001T000?o0000fP000ol0000@0000
7004oa/00_oJ00;o4P0001d000?o00006`000ol0003J0003o`000100000M0003o`0001/000?o0000
fP000ol0000@00007@000ol0000K0003o`000=X000?o0000400001`01?lK0003o`000=X000?o0000
400001d00olK00;ofP02oa80000L0003o`0001`000?o0000fP000ol0000@00007004oa/000?o0000
fP000ol0000@000070001?l00?lK0003o`000=X000?o0000400001d00_lL0003o`000=X000?o0000
400003/00_oJ00;o4P0003/000?o0000D@02ohL000?o0000400003/000?o0000D004ohH000?o0000
400003/000?o0000D004ohH000?o0000400003/000?o0000D@02ohL000?o0000400003/00_oJ00;o
4P0003/000?o0000fP000ol0000@0000>`000ol0003J0003o`000100000Y00?o0P03o`@00_l40003
o`000=X000?o0000400002`000?o00000P001?l00?l20005o`000?l0g0000ol0000@0000:P03o`80
0ol20004o`00o`<00ooH00?o4P0002T000Ko003o0?l20004o`00o`8000Go0000o`3L0003o`000100
000Y0006o`00o`3o0P001?l00?l20005o`000?l0g0000ol0000@0000:P02o`<00_l400;o10000ol0
001300;oU@000ol0000@0000>`000ol0001200CoU0000ol0000@0000>`02od<01?nC00;o4P0003/0
00?o0000@`02oiD000?o0000400003/000?o0000fP000ol0000@0000>`000ol0003J0003o`000100
000k00;ofP02oa80000k0003o`000=X000?o0000400003/000?o0000:@02ojl000?o0000400003/0
00?o0000:004ojh000?o0000400003/000?o0000:004ojh000?o0000400003/00_lZ00;o[P02oa80
000k0003o`000=X000?o0000400003/000?o0000fP000ol0000@0000>`000ol0003J0003o`000100
000k0003o`0004<00_nE0003o`000100000k00;o@`04oi<00_lB0000>`000ol0000?00;o<@04oi@0
00?o0000400003/000?o00003P04oc400_nE0003o`000100000U00?o0P02o`@00_l300;o10000ol0
000>00Cob0000ol0000@00009P001?l00?l20004o`00o`8000?o0?l00P001Ol0003o01400_o90003
o`000100000V0004o`00o`8000Co003o0P000ol0o`020004o`0000?of003oa80000V0004o`00o`80
00Co003o0P000ol0o`020005o`000?l0g0000ol0000@00009P001?l00?l20004o`00o`8000?o0?l0
0P001Ol0003o0=`000?o0000400002D00_l300;o1002o`<00_l40003o`000=X000?o0000400003/0
00?o0000fP000ol0000@0000>`02omX00_lB0000>`000ol0000200;oeP000ol0000@0000>`001?l0
0004omD000?o0000400003/000Co00001?oE0003o`000100000k0003o`0000800_l<0003o`000340
00?o0000<P000ol0000a0003o`0002X000?o0000400003/00_l40003o`0000X000?o00002P000ol0
000:0003o`0000X000?o00002P000ol0000:0003o`0000X000?o00002`000ol0000:0003o`0000X0
00?o00002P000ol0000:0003o`0000X000?o00002P000ol0000:0003o`0000/000Co00000_lB0000
>`3Noa80003o02`0003o02`0003o02`0003o02`0002I0003o`0008l0002I0003o`0008l0001e0004
o`0000?o0P03o`<00ol40005o`000?l00`03o`<01?l0103o0002o`<01Ol500Co0P05o`8000Co003o
0P001?l00?l600Co0`04o`800_l00`3oo`02odX0001e0004o`00o`<00_l30003o`3o00<000Go0000
o`030004o`00o`<000Co003o0`02o`070?l00?l0o`020003o`3o00@000?o00000P001?l0ool30003
o`3o008000Co003o0P000ol000040007o`000?l0o`020007o`000?l0o`020003o`0004T0001e0004
o`0000Co00<0ool00_l50005o`000?l00`001?l00?l30004o`00o`<00_l00`3o000400?o00<0o`00
20001?l0ool30003o`3o008000Co003o0P000ol000040003o`00008000?o0?l00_l30003o`0000?o
B`0007D000Co003o0`02o`<000?o0?l00`001Ol0003o00<000Co003o0`001?l00?l300;o00L0o`00
o`3o008000?o0?l01@04o`800_l30003o`3o008000Co003o0P000ol000040003o`0000800_l20007
o`000?l0o`020003o`0004T0001e0004o`00o`<00_l30003o`3o00?o10001?l00003o`040?ooo`<0
1?l0103o0002o`<00_l20003o`00008000?o00000`06o`801_l00`3oo`070003o`00008000Co0?oo
0`03o`030?oo04`0001c00?o0P001?l00002o`<000?o0?l01`000ol0000L0003o`00008000?o0000
0P000ol0o`0F0005o`000?l020000ol0001>0000M@001?l00003o`800ol300Co00<0ool00ol@0003
o`0000T000?o00000`04oaT01?mJ0000o`0/0000o`0/0000o`0/0000\
\>"],
  ImageRangeCache->{{{0, 298.062}, {183.75, 0}} -> {10.2065, 936.112, 
  0.381057, 0.408476}}]
}, Closed]],

Cell[TextData[{
  "See also ",
  StyleBox["Split", "Input"],
  ", ",
  StyleBox["FlattenAt",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  ", ",
  StyleBox["Inner",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  ", ",
  StyleBox["Outer",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  ", ",
  StyleBox["Thread",
    FontFamily->"Courier",
    FontWeight->"Bold"]
}], "SeeAlso"]
}, Closed]],

Cell[CellGroupData[{

Cell["Exercises: List Structure", "Subsubsection",
  PageBreakAbove->True],

Cell[TextData[{
  "Define a function ",
  StyleBox["percentageOfPrimes", "Input"],
  " that returns the percentage of prime numbers in a list."
}], "Question"],

Cell[TextData[{
  "To determine the percentage of primes in a list, we divide the number of \
primes by the length of the list. One way to determine the number of primes \
in a list is to use ",
  StyleBox["Length", "Input"],
  " and ",
  StyleBox["Select", "Input"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Length[Select[Range[100], PrimeQ]]\)], "Input"],

Cell[BoxData[
    \(25\)], "Output"]
}, Closed]],

Cell[TextData[{
  "A more straightforward method is to use ",
  StyleBox["Count", "Input"],
  " and the conditional pattern ",
  StyleBox["_?PrimeQ", "Input"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Count[Range[100], _?PrimeQ]\)], "Input"],

Cell[BoxData[
    \(25\)], "Output"]
}, Closed]],

Cell[TextData[{
  "Here is a definition of ",
  StyleBox["percentageOfPrimes", "Input"],
  "."
}], "Text"],

Cell[BoxData[
    \(percentageOfPrimes[\[ScriptCapitalP]_List] := 
      Length[Select[\[ScriptCapitalP], PrimeQ]]/Length[\[ScriptCapitalP]]\)], 
  "Input"],

Cell["\<\
Here is the percentage of primes in a list of integers from 1 to \
100.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(percentageOfPrimes[Range[100]]\)], "Input"],

Cell[BoxData[
    \(1\/4\)], "Output"]
}, Closed]],

Cell["\<\
Here is the percentage of primes in a list of odd numbers from 1 to \
100.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(percentageOfPrimes[Range[1, 100, 2]]\)], "Input"],

Cell[BoxData[
    \(12\/25\)], "Output"]
}, Closed]],

Cell["Generate the following list.", "Question"],

Cell[BoxData[
    \(\(pts = Table[{r\ Cos[r], r\ Sin[r]}, {r, 0.0, 25.0, 0.25}]; \)\)], 
  "Input"],

Cell[TextData[{
  "Find the maximum ",
  StyleBox["x",
    FontSlant->"Italic"],
  "-value. Find the minimum ",
  StyleBox["y",
    FontSlant->"Italic"],
  "-value."
}], "Text",
  FontWeight->"Bold"],

Cell[TextData[{
  "To extract the list of ",
  StyleBox["x",
    FontSlant->"Italic"],
  "-values, we take the first part of the transpose of ",
  StyleBox["pts",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  ". Once the list of ",
  StyleBox["x",
    FontSlant->"Italic"],
  "-values has been extracted, we use ",
  StyleBox["Max",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " to determine the maximum."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Max[\(Transpose[pts]\)[\([1]\)]]\)], "Input"],

Cell[OutputFormData["\<\
24.78007029658683995\
\>", 
"\<\
24.7801\
\>"], "Output"]
}, Closed]],

Cell[TextData[{
  "We follow a similar process to determine the minimum of the ",
  StyleBox["y",
    FontSlant->"Italic"],
  "-values."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Min[\(Transpose[pts]\)[\([2]\)]]\)], "Input"],

Cell[OutputFormData["\<\
-23.45492765751581235\
\>", 
"\<\
-23.4549\
\>"], "Output"]
}, Closed]],

Cell[" ", "EndExercises"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Sorting and Grouping Data", "Subsection",
  CellTags->"Rearranging List Elements"],

Cell[TextData[{
  StyleBox["Sort", "Input"],
  " sorts a list of numbers into increasing order."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Sort[{1, 3, 5, 7, 9, 2, 4, 6, 8}]\)], "Input"],

Cell[BoxData[
    \({1, 2, 3, 4, 5, 6, 7, 8, 9}\)], "Output"]
}, Closed]],

Cell[TextData[{
  "We can specify a function that determines if two adjacent elements are \
sorted. Here we tell ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " to sort a list of numbers in decreasing order, by specifying that two \
elements are sorted if they satisfy the function ",
  StyleBox["Greater", "Input"],
  " (that is, the first element is greater than the second element)."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Sort[{1, 3, 5, 7, 9, 2, 4, 6, 8}, Greater]\)], "Input"],

Cell[BoxData[
    \({9, 8, 7, 6, 5, 4, 3, 3, 2, 1}\)], "Output"]
}, Closed]],

Cell["\<\
When working with multidimensional data, it is often necessary to \
explicitly define a sorting function. Here we read in the list of hurricane \
data.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Get["\<hurr.dat\>"]\)], "Input"],

Cell[BoxData[
    \({{"Allison", 65, 987}, {"Barry", 50, 995}, {"Chantal", 60, 992}, {
        "Dean", 40, 999}, {"Erin", 75, 975}, {"Felix", 115, 950}, {
        "Gabrielle", 60, 998}, {"Humberto", 90, 970}, {"Iris", 75, 970}, {
        "Jerry", 35, 1003}}\)], "Output"]
}, Closed]],

Cell[TextData[{
  "To sort the list in ascending order of wind speed, we first define a \
sorting function as follows. The function returns ",
  StyleBox["True", "Input"],
  " if the second element (the wind speed) of one record is less than the \
second element of another."
}], "Text"],

Cell[BoxData[
    \(hurrSort[rec1_, rec2_] := rec1[\([2]\)] < rec2[\([2]\)]\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Sort[hurr, hurrSort] // TableForm\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {\("Jerry"\), "35", "1003"},
          {\("Dean"\), "40", "999"},
          {\("Barry"\), "50", "995"},
          {\("Gabrielle"\), "60", "998"},
          {\("Chantal"\), "60", "992"},
          {\("Allison"\), "65", "987"},
          {\("Iris"\), "75", "970"},
          {\("Erin"\), "75", "975"},
          {\("Humberto"\), "90", "970"},
          {\("Felix"\), "115", "950"}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Closed]],

Cell[TextData[{
  "Here is a pure sorting function equivalent to ",
  StyleBox["hurrSort", "Input"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Sort[hurr, #1[\([2]\)] < #2[\([2]\)]&] // TableForm\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {\("Jerry"\), "35", "1003"},
          {\("Dean"\), "40", "999"},
          {\("Barry"\), "50", "995"},
          {\("Gabrielle"\), "60", "998"},
          {\("Chantal"\), "60", "992"},
          {\("Allison"\), "65", "987"},
          {\("Iris"\), "75", "970"},
          {\("Erin"\), "75", "975"},
          {\("Humberto"\), "90", "970"},
          {\("Felix"\), "115", "950"}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Closed]],

Cell[TextData[{
  StyleBox["Split", "Input"],
  " partitions a list into sublists that have identical elements. Here is a \
list of results from tossing a coin twenty times."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(tosses = Table[If[Random[] < 0.5, "\<H\>", "\<T\>"], {20}]\)], "Input"],

Cell[BoxData[
    \({"H", "T", "T", "H", "T", "T", "T", "H", "H", "H", "H", "T", "T", "H", 
      "H", "H", "H", "H", "T", "T"}\)], "Output"]
}, Closed]],

Cell[TextData[{
  StyleBox["Split", "Input"],
  " divides the list into lists of runs."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(runs = Split[tosses]\)], "Input"],

Cell[BoxData[
    \({{"H"}, {"T", "T"}, {"H"}, {"T", "T", "T"}, {"H", "H", "H", "H"}, {"T", 
        "T"}, {"H", "H", "H", "H", "H"}, {"T", "T"}}\)], "Output"]
}, Closed]],

Cell[TextData[{
  "By mapping the function ",
  StyleBox["Length", "Input"],
  " over the results of ",
  StyleBox["Split", "Input"],
  ", we can compute the length of each run of heads or tails."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Map[Length, runs]\)], "Input"],

Cell[BoxData[
    \({1, 2, 1, 3, 4, 2, 5, 2}\)], "Output"]
}, Closed]],

Cell[TextData[{
  "As an extension of the previous example, we generate a list containing \
pairs of the form (",
  StyleBox["result",
    FontSlant->"Italic"],
  ",\[NonBreakingSpace]",
  StyleBox["length\[NonBreakingSpace]of run",
    FontSlant->"Italic"],
  ")."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Map[{First[#], Length[#]}&, runs]\)], "Input"],

Cell[BoxData[
    \({{"H", 1}, {"T", 2}, {"H", 1}, {"T", 3}, {"H", 4}, {"T", 2}, {"H", 5}, {
        "T", 2}}\)], "Output"]
}, Closed]],

Cell[TextData[{
  "This is called ",
  StyleBox["run length encoding",
    FontSlant->"Italic"],
  "."
}], "Text"],

Cell[TextData[{
  "See also ",
  StyleBox["Partition", "Input"],
  ", ",
  StyleBox["Permutations",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  ", ",
  StyleBox["Reverse", "Input"],
  ", ",
  StyleBox["OrderedQ", "Input"],
  ", ",
  StyleBox["Order", "Input"],
  ", ",
  StyleBox["RotateLeft", "Input"],
  ", ",
  StyleBox["RotateRight", "Input"],
  ", ",
  StyleBox["DiscreteMath`Combinatorica`", "Input"],
  " "
}], "SeeAlso"]
}, Closed]],

Cell[CellGroupData[{

Cell["Exercises: Sorting and Grouping Data", "Subsection",
  PageBreakAbove->True],

Cell[TextData[{
  "Using ",
  StyleBox["RotateRight", "Input"],
  ", compute the first differences of a list of data."
}], "Question"],

Cell["Here is a list of data generated from a quadratic curve.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(quaddata = Table[n\^2 - 5\ n + 1, {n, 0, 10}]\)], "Input"],

Cell[BoxData[
    \({1, \(-3\), \(-5\), \(-5\), \(-3\), 1, 7, 15, 25, 37, 51}\)], "Output"]
}, Closed]],

Cell["\<\
We compute the first difference by rotating each element of the \
list of data one position to the right, and subtracting the rotated list from \
the original list. Here is the list of first differences.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(quaddata - RotateRight[quaddata]\)], "Input"],

Cell[BoxData[
    \({\(-50\), \(-4\), \(-2\), 0, 2, 4, 6, 8, 10, 12, 14}\)], "Output"]
}, Closed]],

Cell[TextData[{
  "The first element of the subtracted list is meaningless (the first element \
of the original list minus the last element of the original list), so we use \
",
  StyleBox["Drop",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " to remove it."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Drop[%, 1]\)], "Input"],

Cell[BoxData[
    \({\(-4\), \(-2\), 0, 2, 4, 6, 8, 10, 12, 14}\)], "Output"]
}, Closed]],

Cell["\<\
Extract the five largest elements from a list of random \
numbers.\
\>", "Question"],

Cell["Here is a list of random numbers.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(randomdata = Table[Random[], {15}]\)], "Input"],

Cell[BoxData[
    \({0.666687236805076555`, 0.313322232136227896`, 0.0327653398314601762`, 
      0.791487042709144184`, 0.603896896336227673`, 0.966622450296981661`, 
      0.389777670511362117`, 0.0754428647336257274`, 0.514743728755546303`, 
      0.13704234739816099`, 0.242962016543816838`, 0.215764756077152508`, 
      0.714666535719097772`, 0.339252255385974166`, 0.706117091494693926`}\)],
   "Output"]
}, Closed]],

Cell[TextData[{
  StyleBox["Sort", "Input"],
  " arranges the list into ascending order."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Sort[randomdata]\)], "Input"],

Cell[BoxData[
    \({0.0327653398314601762`, 0.0754428647336257274`, 0.13704234739816099`, 
      0.215764756077152508`, 0.242962016543816838`, 0.313322232136227896`, 
      0.339252255385974166`, 0.389777670511362117`, 0.514743728755546303`, 
      0.603896896336227673`, 0.666687236805076555`, 0.706117091494693926`, 
      0.714666535719097772`, 0.791487042709144184`, 0.966622450296981661`}\)],
   "Output"]
}, Closed]],

Cell["\<\
To extract the five largest elements in the original list, we \
extract the last five elements from the sorted list.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Take[%, \(-5\)]\)], "Input"],

Cell[BoxData[
    \({0.666687236805076555`, 0.706117091494693926`, 0.714666535719097772`, 
      0.791487042709144184`, 0.966622450296981661`}\)], "Output"]
}, Closed]],

Cell[TextData[{
  "Define a function called ",
  StyleBox["runEncode", "Input"],
  " that takes a list of discrete random data and converts it into lists of \
the form (",
  StyleBox["element",
    FontSlant->"Italic"],
  ", ",
  StyleBox["length of run",
    FontSlant->"Italic"],
  "). Define a function called ",
  StyleBox["runDecode", "Input"],
  " that reconstructs a list resulting from ",
  StyleBox["runEncode", "Input"],
  "."
}], "Question"],

Cell["Here is some coin-tossing data taken from the discussion.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(tosses = Table[If[Random[] < 0.5, "\<H\>", "\<T\>"], {20}]\)], "Input"],

Cell[BoxData[
    \({"H", "H", "H", "H", "H", "H", "H", "T", "T", "T", "H", "T", "H", "H", 
      "T", "T", "T", "H", "T", "T"}\)], "Output"]
}, Closed]],

Cell[BoxData[
    \(runEncode[\[ScriptCapitalL]_List] := 
      Map[{First[#], Length[#]}&, Split[\[ScriptCapitalL]]]\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(td = runEncode[tosses]\)], "Input"],

Cell[BoxData[
    \({{"H", 7}, {"T", 3}, {"H", 1}, {"T", 1}, {"H", 2}, {"T", 3}, {"H", 1}, {
        "T", 2}}\)], "Output"]
}, Closed]],

Cell[TextData[{
  "This definition of ",
  StyleBox["runDecode", "Input"],
  " reverses the encoding of ",
  StyleBox["runEncode", "Input"],
  "."
}], "Text"],

Cell[BoxData[
    \(runDecode[\[ScriptCapitalL]_List] := 
      Flatten[Map[Table[First[#], {Last[#]}]&, \[ScriptCapitalL]]]\)], "Input"],

Cell["Here are the original data.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(runDecode[td]\)], "Input"],

Cell[BoxData[
    \({"H", "H", "H", "H", "H", "H", "H", "T", "T", "T", "H", "T", "H", "H", 
      "T", "T", "T", "H", "T", "T"}\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(% == tosses\)], "Input"],

Cell[BoxData[
    \(True\)], "Output"]
}, Closed]],

Cell[" ", "EndExercises"]
}, Closed]],

Cell[CellGroupData[{

Cell["Graphing Lists of Data", "Subsection"],

Cell[CellGroupData[{

Cell["Built-In Functions", "Subsubsection"],

Cell[TextData[{
  "There are many built-in functions for plotting lists of data. ",
  StyleBox["ListPlot", "Input"],
  " accepts a list of ordered pairs, and generates a two-dimensional scatter \
plot of the points."
}], "Text"],

Cell[TextData[{
  "The file ",
  StyleBox["circle.dat", "Output"],
  " defines a variable ",
  StyleBox["circledata", "Input"],
  " to be a list of ordered pairs that fall on a circle."
}], "Text"],

Cell[BoxData[
    \(\(<< circle.dat; \)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(ListPlot[circledata]; \)\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.497605 0.478585 0.306042 0.298023 [
[.01902 .29354 -6 -9 ]
[.01902 .29354 6 0 ]
[.25831 .29354 -12 -9 ]
[.25831 .29354 12 0 ]
[.7369 .29354 -9 -9 ]
[.7369 .29354 9 0 ]
[.97619 .29354 -3 -9 ]
[.97619 .29354 3 0 ]
[.48511 .00802 -12 -4.5 ]
[.48511 .00802 0 4.5 ]
[.48511 .15703 -24 -4.5 ]
[.48511 .15703 0 4.5 ]
[.48511 .45505 -18 -4.5 ]
[.48511 .45505 0 4.5 ]
[.48511 .60407 -6 -4.5 ]
[.48511 .60407 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.01902 .30604 m
.01902 .31229 L
s
[(-1)] .01902 .29354 0 1 Mshowa
.25831 .30604 m
.25831 .31229 L
s
[(-0.5)] .25831 .29354 0 1 Mshowa
.7369 .30604 m
.7369 .31229 L
s
[(0.5)] .7369 .29354 0 1 Mshowa
.97619 .30604 m
.97619 .31229 L
s
[(1)] .97619 .29354 0 1 Mshowa
.125 Mabswid
.06688 .30604 m
.06688 .30979 L
s
.11474 .30604 m
.11474 .30979 L
s
.1626 .30604 m
.1626 .30979 L
s
.21045 .30604 m
.21045 .30979 L
s
.30617 .30604 m
.30617 .30979 L
s
.35403 .30604 m
.35403 .30979 L
s
.40189 .30604 m
.40189 .30979 L
s
.44975 .30604 m
.44975 .30979 L
s
.54546 .30604 m
.54546 .30979 L
s
.59332 .30604 m
.59332 .30979 L
s
.64118 .30604 m
.64118 .30979 L
s
.68904 .30604 m
.68904 .30979 L
s
.78476 .30604 m
.78476 .30979 L
s
.83261 .30604 m
.83261 .30979 L
s
.88047 .30604 m
.88047 .30979 L
s
.92833 .30604 m
.92833 .30979 L
s
.25 Mabswid
0 .30604 m
1 .30604 L
s
.49761 .00802 m
.50386 .00802 L
s
[(-1)] .48511 .00802 1 0 Mshowa
.49761 .15703 m
.50386 .15703 L
s
[(-0.5)] .48511 .15703 1 0 Mshowa
.49761 .45505 m
.50386 .45505 L
s
[(0.5)] .48511 .45505 1 0 Mshowa
.49761 .60407 m
.50386 .60407 L
s
[(1)] .48511 .60407 1 0 Mshowa
.125 Mabswid
.49761 .03782 m
.50136 .03782 L
s
.49761 .06762 m
.50136 .06762 L
s
.49761 .09743 m
.50136 .09743 L
s
.49761 .12723 m
.50136 .12723 L
s
.49761 .18683 m
.50136 .18683 L
s
.49761 .21663 m
.50136 .21663 L
s
.49761 .24644 m
.50136 .24644 L
s
.49761 .27624 m
.50136 .27624 L
s
.49761 .33584 m
.50136 .33584 L
s
.49761 .36565 m
.50136 .36565 L
s
.49761 .39545 m
.50136 .39545 L
s
.49761 .42525 m
.50136 .42525 L
s
.49761 .48486 m
.50136 .48486 L
s
.49761 .51466 m
.50136 .51466 L
s
.49761 .54446 m
.50136 .54446 L
s
.49761 .57426 m
.50136 .57426 L
s
.25 Mabswid
.49761 0 m
.49761 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.008 w
.97619 .30604 Mdot
.9176 .44892 Mdot
.75619 .55682 Mdot
.53146 .60332 Mdot
.29844 .57703 Mdot
.11419 .4844 Mdot
.02381 .3481 Mdot
.04943 .2015 Mdot
.18478 .0805 Mdot
.39672 .01472 Mdot
.63336 .02026 Mdot
.83676 .09577 Mdot
.95713 .22277 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{299.062, 184.75},
  ImageMargins->{{48, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004[0000^0P10`4000010?ooooooc?ooZ_ooI_oo
<ooo0?o<ooo<c?o<VC/k>gYjN[Vi^OShn03ooeGooj[ooonI<onI0?mVoomVc?mVVOmVI_mV<omV0?lc
oclo?ginO[fm_Oclo5D00:X00?l00?l0VOl0I_l0<ol00<coolcoc<coVLcoIP<30d92@X61PL30`000
EED0EJX0EOl0ELbIolbIc<bIVLbII/bI<lbI0<aVolaVc0L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0Z/`c
<l`c0<`0ol`0c<`0VL`0I/`0<l`000/;2dY:BXV9RLS8b000oeD0ojX0ool0oiW<VIW<IYW<<iW<09VI
oiVIc9VIVIVIIPl?3di>CXf=SLc<c01E05EE0:YE0?mE09TcoiTcc9TcVITcIYTc<iTc09T0oiT0c1<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEEFKo<fKo06K<ofK<c6K<VFK<IVK<<fK<01LG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZVIVVFIVIVIV<fIV06HcofHcc6HcVFHcIQ/K6eYJFYVIVMSHf01EoeEEojYEoomEoc?o
oc?oc3?oVC?oIS?o<c?o03?<oc?<c1lO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ03>I<c>I03=Voc=Vc3=V
VC=VIS=V<c=V02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZEC<0VC<0IS<0<c<0003oo`3oc03oV@3oIRLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2Io`2Ic02IV@2IIP2I<`2I001Vo`1Vc2/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`0c<`0c0000o`00c000V@00IP00<nh002l_;fi^KZf][Nc/k03o05Go0:[o0?oo0140
003^003M002k002Z0028001g001E03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@00M`00E@00A0008P00
4Nk^k]gMgK^k^cLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l0;0000?l0;00008/00ol60003o`0009@0
002<0003o`0000D000?o0000U00008D01Ol20003o`0000D00onD0000S0000ol000050003o`0009@0
001f00;o50000ol000050003o`0009@0001f00;o4`02o`L000?o00009002ofh0002D0003o`0002@0
0_m^0000U0000ol0002D0000U0000ol0002D0000U0000ol0002D0000U0000ol0002D0000U002oiD0
002D0003o`0009@0002D0003o`0009@0002D0003o`0009@0002D0003o`0009@0002D0003o`0009@0
002D0003o`0009@0002D0003o`0009@0002D0003o`0009@0002D00;oU@0009@000?o0000U00009@0
00?o0000U00003P00_mJ0003o`0009@0000h00;oFP000ol0002D0000U0000ol0002D0000U0000ol0
002D0000U0000ol0002D0000U002of400_lb0000U0000ol0001P00;o<P0009@000?o0000U00009@0
00?o0000U00009@000?o0000U00009@000?o0000U00009@000?o0000U00009@000?o0000U00009@0
00?o0000U00009@00_nE0000U0000ol0002D0000U0000ol0002D0000U0000ol0002D0000U0000ol0
002D0000U0000ol0002D0000U0000ol0002D0000P002o`@00_l300?o1P000ol0002D0000O`001?l0
0?l300;o1P000ol000030003o`0009@0001i00Go00D0o`00o`0;0003o`0000<00onD0000O`001?l0
0?l800?o1P000ol0002D0000O`001?l00?l80003o`0000H000?o0000U00008000_l900Co1@000ol0
002D0000U0000ol0002D0000U0000ol0002D0000U0000ol0002D0000U0000ol0002D0000U0000ol0
002D0000U002oiD0002D0003o`0009@0002D0003o`0009@0002D0003o`0009@0000@00;oPP000ol0
002D00004002oh8000?o0000U00009@000?o0000U00009@000?o0000U00009@00_nE0000U0000ol0
002D0000U0000ol0002300;o3`0009@000?o0000P`02o`l0002D0003o`0009@0002D0003o`0009@0
002D0003o`0009@0002D0003o`0009@0002D0003o`0009@0002D00;oU@0009@000?o0000U00009@0
00?o0000U00009@000?o0000U00009@000?o0000U00009@000?o0000U00009@000?o0000U00000T0
0oln00;o1002o`<00oll0003o`0003`00_l400;o0`03ocd00ol:00002P000ol0000l0004o`00o`<0
0_l60003o`0003T000?o0000>`001?l00?l300;o1P000ol0000k0003o`0000T0000300Go0P000ol0
000f00Go00D0o`00o`0;0003o`0003T00_ll0004o`00o`/000?o0000>`000ol0000900002P000ol0
000l0004o`00o`P00oll0003o`0003/000Co003o2003och000?o00002@0000X000?o0000?0001?l0
0?l80003o`0003`000?o0000>`001?l00?l80003o`0003h000?o00002@0000T00_lo00;o2@04oc/0
00?o0000?002o`T01?ll00;o2`0009@000?o0000U00009@000?o0000U00009@000?o0000U00009@0
00?o0000U00009@000?o0000R@02o`T000020?oo9ol3000020000ol0000;0003o`0000/000?o0000
2`000ol0000;0003o`0000/000?o00002`000ol0000;0003o`0000/000?o00002`000ol0000;0003
o`0000/000?o00002`000ol0000;0003o`0000/000?o00002`000ol0000;0003o`0000/000?o0000
2`000ol0000;0003o`0000/000?o0000200009@000?o0000U00009@000?o0000U00009@000?o0000
U00009@000?o0000U00009@000?o0000U00009@000?o0000U00009@00_nE0000U0000ol0002D0000
U0000ol0002D0000U0000ol0002D00002@02ohT000?o0000U00000T00_n90003o`0009@0002D0003
o`0009@0002D0003o`0009@0002D0003o`0009@0002D00;oU@0009@000?o0000U00009@000?o0000
U00009@000?o0000U00009@000?o0000U00009@000?o0000U00009@000?o0000U00009@000?o0000
U00009@000?o0000U00009@00_nE0000U0000ol0002D0000U0000ol0002D0000U0000ol0002D0000
U0000ol0002D0000U0000ol0002D0000U0000ol0002D0000U0000ol0002D0000U0000ol0002D0000
U002oiD0002D0003o`0009@0002D0003o`0009@0002D0003o`0009@0002D0003o`0009@0002D0003
o`0009@0002000;o1002o`<00ol60003o`0007P00_lJ0000O`001?l00?l300;o1P000ol000030003
o`0007P00_lJ0000O`001?l00?l;0003o`0000<00onD0000O`001?l00?l800?o1P000ol0002D0000
O`001?l00?l80003o`0000H000?o0000U00008000_l900Co1@000ol0002D0000U0000ol0002D0000
U0000ol0002D0000U0000ol0002D0000U0000ol0002D0000U0000ol0002D00008`02ofl00_nE0000
8`02ofl000?o0000U00009@000?o0000U00009@000?o0000U00009@000?o0000U00009@000?o0000
U00009@000?o0000U00009@000?o0000U00009@000?o0000U00009@00_nE0000U0000ol0002D0000
U0000ol0002D0000U0000ol0002D0000U0000ol0002D0000U0000ol0002D0000U0000ol0002D0000
U0000ol0002D0000U0000ol0002D0000U002oiD0002D0003o`0009@0002D0003o`0009@0002D0003
o`0004P00_m:0000U0000ol0001800;oBP0009@000?o0000U00009@000?o0000U00009@000?o0000
U00009@00_nE0000F@02ocT000?o0000U00005T00_li0003o`0009@0002D0003o`0009@0002D0003
o`0009@0002D0003o`0009@0002D0003o`0009@0002;00?o1P000ol0002D0000S0000ol000050003
o`0000H00_n<0000S0000ol0000500?o1P02oh`0002<0003o`0000D000?o0000U00008`000?o0000
1@000ol0002D0000R`02o`L000?o0000U00009@000?o0000U0000001\
\>"],
  ImageRangeCache->{{{0, 298.062}, {183.75, 0}} -> {-1.05866, -1.05151, 
  0.00712707, 0.0114451}}]
}, Closed]],

Cell["\<\
Graphing functions take many options, which control how a graph is \
rendered. Here is the same graph with several options changed.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(ListPlot[circledata, PlotJoined \[Rule] True, 
      GridLines \[Rule] Automatic, AspectRatio \[Rule] 1, 
      PlotLabel \[Rule] "\<circledata\>", AxesStyle \[Rule] Thickness[0.02]]; 
    \)\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.497605 0.478585 0.495186 0.482212 [
[.01902 .48269 -6 -9 ]
[.01902 .48269 6 0 ]
[.25831 .48269 -12 -9 ]
[.25831 .48269 12 0 ]
[.7369 .48269 -9 -9 ]
[.7369 .48269 9 0 ]
[.97619 .48269 -3 -9 ]
[.97619 .48269 3 0 ]
[.48511 .01297 -12 -4.5 ]
[.48511 .01297 0 4.5 ]
[.48511 .25408 -24 -4.5 ]
[.48511 .25408 0 4.5 ]
[.48511 .73629 -18 -4.5 ]
[.48511 .73629 0 4.5 ]
[.48511 .9774 -6 -4.5 ]
[.48511 .9774 0 4.5 ]
[.5 1.0125 -32 0 ]
[.5 1.0125 32 15 ]
[ -0.01 -0.01 0 0 ]
[ 1.01 1.01 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 .5 r
.25 Mabswid
[ ] 0 setdash
.01902 0 m
.01902 1 L
s
.25831 0 m
.25831 1 L
s
.49761 0 m
.49761 1 L
s
.7369 0 m
.7369 1 L
s
.97619 0 m
.97619 1 L
s
0 .01297 m
1 .01297 L
s
0 .25408 m
1 .25408 L
s
0 .49519 m
1 .49519 L
s
0 .73629 m
1 .73629 L
s
0 .9774 m
1 .9774 L
s
0 g
.01902 .49519 m
.01902 .50144 L
s
[(-1)] .01902 .48269 0 1 Mshowa
.25831 .49519 m
.25831 .50144 L
s
[(-0.5)] .25831 .48269 0 1 Mshowa
.7369 .49519 m
.7369 .50144 L
s
[(0.5)] .7369 .48269 0 1 Mshowa
.97619 .49519 m
.97619 .50144 L
s
[(1)] .97619 .48269 0 1 Mshowa
.125 Mabswid
.06688 .49519 m
.06688 .49894 L
s
.11474 .49519 m
.11474 .49894 L
s
.1626 .49519 m
.1626 .49894 L
s
.21045 .49519 m
.21045 .49894 L
s
.30617 .49519 m
.30617 .49894 L
s
.35403 .49519 m
.35403 .49894 L
s
.40189 .49519 m
.40189 .49894 L
s
.44975 .49519 m
.44975 .49894 L
s
.54546 .49519 m
.54546 .49894 L
s
.59332 .49519 m
.59332 .49894 L
s
.64118 .49519 m
.64118 .49894 L
s
.68904 .49519 m
.68904 .49894 L
s
.78476 .49519 m
.78476 .49894 L
s
.83261 .49519 m
.83261 .49894 L
s
.88047 .49519 m
.88047 .49894 L
s
.92833 .49519 m
.92833 .49894 L
s
.02 w
0 .49519 m
1 .49519 L
s
.25 Mabswid
.49761 .01297 m
.50386 .01297 L
s
[(-1)] .48511 .01297 1 0 Mshowa
.49761 .25408 m
.50386 .25408 L
s
[(-0.5)] .48511 .25408 1 0 Mshowa
.49761 .73629 m
.50386 .73629 L
s
[(0.5)] .48511 .73629 1 0 Mshowa
.49761 .9774 m
.50386 .9774 L
s
[(1)] .48511 .9774 1 0 Mshowa
.125 Mabswid
.49761 .0612 m
.50136 .0612 L
s
.49761 .10942 m
.50136 .10942 L
s
.49761 .15764 m
.50136 .15764 L
s
.49761 .20586 m
.50136 .20586 L
s
.49761 .3023 m
.50136 .3023 L
s
.49761 .35052 m
.50136 .35052 L
s
.49761 .39874 m
.50136 .39874 L
s
.49761 .44697 m
.50136 .44697 L
s
.49761 .54341 m
.50136 .54341 L
s
.49761 .59163 m
.50136 .59163 L
s
.49761 .63985 m
.50136 .63985 L
s
.49761 .68807 m
.50136 .68807 L
s
.49761 .78451 m
.50136 .78451 L
s
.49761 .83273 m
.50136 .83273 L
s
.49761 .88096 m
.50136 .88096 L
s
.49761 .92918 m
.50136 .92918 L
s
.02 w
.49761 0 m
.49761 1 L
s
gsave
.5 1.0125 -93 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 15.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 15.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(circledata) show
123.000000 15.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
.5 Mabswid
.97619 .49519 m
.9176 .72637 L
.75619 .90095 L
.53146 .97619 L
.29844 .93366 L
.11419 .78378 L
.02381 .56324 L
.04943 .32603 L
.18478 .13025 L
.39672 .02381 L
.63336 .03278 L
.83676 .15497 L
.95713 .36045 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{299.062, 299.062},
  ImageMargins->{{48, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004[0001:`P10`4000010?ooooooc?ooZ_ooI_oo
<ooo0?o<ooo<c?o<VC/k>gYjN[Vi^OShn03ooeGooj[ooonI<onI0?mVoomVc?mVVOmVI_mV<omV0?lc
oclo?ginO[fm_Oclo5D00:X00?l00?l0VOl0I_l0<ol00<coolcoc<coVLcoIP<30d92@X61PL30`000
EED0EJX0EOl0ELbIolbIc<bIVLbII/bI<lbI0<aVolaVc0L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0Z/`c
<l`c0<`0ol`0c<`0VL`0I/`0<l`000/;2dY:BXV9RLS8b000oeD0ojX0ool0oiW<VIW<IYW<<iW<09VI
oiVIc9VIVIVIIPl?3di>CXf=SLc<c01E05EE0:YE0?mE09TcoiTcc9TcVITcIYTc<iTc09T0oiT0c1<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEEFKo<fKo06K<ofK<c6K<VFK<IVK<<fK<01LG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZVIVVFIVIVIV<fIV06HcofHcc6HcVFHcIQ/K6eYJFYVIVMSHf01EoeEEojYEoomEoc?o
oc?oc3?oVC?oIS?o<c?o03?<oc?<c1lO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ03>I<c>I03=Voc=Vc3=V
VC=VIS=V<c=V02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZEC<0VC<0IS<0<c<0003oo`3oc03oV@3oIRLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2Io`2Ic02IV@2IIP2I<`2I001Vo`1Vc2/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`0c<`0c0000o`00c000V@00IP00<nh002l_;fi^KZf][Nc/k03o05Go0:[o0?oo0140
003^003M002k002Z0028001g001E03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@00M`00E@00A0008P00
4Nk^k]gMgK^k^cLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l0;00009801OnD0000TP05oi@0000?0003
e@00040000?D0000?@05ocl000?D0000?`000m@0000@00003`000m@000100003l00003d01Olo0003
l00003l000?`0000400000l000?E0000@0000m@0000f00?o1005ocl000?D0000?`000m@0000@0000
3`000m@000100003l00003L000?o00000`05ocl000?`0000?`000o00000@00002P00NmCEe=GDeMCE
e=GDeMCEe=GDeMCEe=GDeMCEe=GDeMCEe=GDeMCEe=GDeMCEe=GDeMCEe=GDeMCEe=GDeMCEe=GDeMCE
e=GDeMCEe=GDeMCEe=GDeMCEe=GDeMCEe=GDeMCEe=GDeMCEe=GDeMCEe=GDeMCEe=GDeMCEe005o`08
e=GoeMCEe=D5o`29eMCEe=GDeMCEe=GDeMCEe=GDeMCEe=GDeMCEe=GDeMCEe=GDeMCEe=GDeMCEe=GD
eMCEe=GDeMCEe=GDeMCEe=GDeMCEe=GDeMCEe=GDeMCEe=GDeMCEe=GDeMCEe=GDeMCEe=GDeMCEe=GD
eMCEe=GDeMCEe=GDeMCEe=GDeMCEe=GDeMCEe=D02`0000l000?D0000@0000o00000g0003o`0000<0
1Olo0003l00003l000?`0000400000l000?E0000@0000m@0000g0003o`0000<01Olo0003e00003l0
00?D0000400000l000?D0000@0000o00000R01;o0P02o`D01Olo0003l00003l000?`0000400000l0
00?E0000@0000m@0000P00;o4P0Qob`000?D0000?`000m@0000@00003`000m@000100003l00001h0
0_lM00Go4`0Aoa/000?`0000?`000o00000@00003`000mD000100003e00001`00_lO00Go9002oaT0
00?D0000?`000m@0000@00003`000m@000100003l00001X00_lQ00Go9P000ol0000F0003l00003l0
00?`0000400000l000?E0000@0000m@0000H00;o8`05obL00_lF0003e00003l000?D0000400000l0
00?D0000@0000o00000F00;o9@05obT00_lD0003l00003l000?`0000400000l000?E0000@0000m@0
000D00;o9`05ob/000?o00004@000m@0000o0003e0000100000?0003e000040000?`00004P02obT0
1Ol/00;o4@000o00000o0003l0000100000?0003e@00040000?D00004002ob/01Ol^00;o3`000m@0
000o0003e0000100000?0003e000040000?`00003P02obd01Ol`0003o`0000`000?`0000?`000o00
000@00003`000mD000100003e00000`00_l_00Go<@02o``000?D0000?`000m@0000@00003`000m@0
00100003l00000X00_la00Go<`02o`X000?`0000?`000o00000@00003`000mD000100003e00000P0
0_lc00Go=@000ol000070003e00003l000?D0000400000l000?D0000@0000o00000500?o=@05ocH0
0_l70003l00003l000?`0000400000l000?E0000@0000m@0000300;o>005ocP00_l50003e00003l0
00?D0000400000l000?D0000@0001?000002ocX01Olj0003o`00008000?`0000?`000o00000@0000
3`000mD000100004e03ooc`01Olk00;o0P000m@0000o0003e0000100000?0003e00004000_ln00Go
?@02o`03l00003l000?`0000400000l000?E0000?P02o`03e00003d01Olo0003o`0003l000?D0000
400000l000?D0000?002o`8000?`0000?@05ocl000?`ool0?`000o00000@00003`000mD0000j00;o
10000m@0000m00Go?`000m@00002ocd000?D0000400000l000?D0000>002o`H000?`0000?@05ocl0
00?`00000P000ol0000j0003l0000100000?0003e@0003H00_l80003e00003d01Olo0003e00000<0
0_lj0003e0000100000?0003e00003@00_l:0003l00003d01Olo0003l00000D00_lh0003l0000100
000?0003e@0003800_l<0003e00003d01Olo0003e00000L000?o0000=@000m@0000@00003`000m@0
000`00;o3P000o00000m00Go?`000o00000800;o=@000o00000@00003`000mD0000^00;o40000m@0
000m00Go?`000m@0000:00;o<`000m@0000@00003`000m@0000/00;o4P000o00000m00Go?`000o00
000<0003o`00030000?`0000400000l000?E0000:`000ol0000B0003e00003d01Olo0003e00000d0
0_l`0003e0000100000?0003e00002/000?o00004P000o00000m00Go?`000o00000?00;o;P000o00
000@00003`000mD0000Z0003o`0001<000?D0000?@05ocl000?D00004@000ol0000[0003e0000100
000?0003e00002T000?o000050000o00000m00Go?`000o00000B00;o:`000o00000@00003`000mD0
000Y0003o`0001@000?D0000?@05ocl000?D00005002obT000?D0000400000l000?D0000:0000ol0
000E0003l00003d01Olo0003l00001H000?o00009P000o00000@00003`000mD0000W0003o`0001H0
00?D0000?@05ocl000?D00005`02obH000?D0000400000l000?D00009`000ol0000F0003l00003d0
1Olo0003l00001T000?o00008`000o00000@00003`000mD0000V0003o`0001L000?D0000?@05ocl0
00?D00006@000ol0000S0003e0000100000?0003e00002D000?o000060000o00000m00Go?`000o00
000J0003o`00028000?`0000400000l000?E000090000ol0000I0003e00003d01Olo0003e00001X0
00?o00008P000m@0000@00003`000m@0000T0003o`0001T000?`0000?@05ocl000?`00006`000ol0
000Q0003l0000100000?0003e@0002<000?o00006P000m@0000m00Go?`000m@0000L0003o`000200
00?D0000400000l000?D00008P000ol0000K0003l00003d01Olo0003l00001`000?o000080000o00
000@00003`000mD0000R0003o`0001/000?D0000?@05ocl000?D00007@000ol0000O0003e0000100
000?0003e000024000?o000070000o00000m00Go?`000o00000M0003o`0001l000?`0000400000l0
00?E000080000ol0000M0003e00003d01Olo0003e00001h000?o00007P000m@0000@00003`000m@0
000P0003o`0001d000?`0000?@05ocl000?`00007`000ol0000M0003l0000100000?0003e@0001l0
00?o00007P000m@0000m00Go?`000m@0000O0003o`0001d000?D0000400000l000?D00007P000ol0
000O0003l00003d01Olo0003l000020000?o000070000o00000@00003`000mD0000N0003o`0001l0
00?D0000?@05ocl000?D000080000ol0000L0003e0000100000?0003e00001d000?o000080000o00
000m00Go?`000o00000Q0003o`0001/000?`0000400000l000?E000070000ol0000Q0003e00003d0
1Olo0003e000024000?o00006`000m@0000@00003`000m@0000L0003o`00024000?`0000?@05ocl0
00?`00008P000ol0000J0003l0000100000?0003e@0001/000?o00008P000m@0000m00Go?`000m@0
000S0003o`0001T000?D0000400000l000?D00006P000ol0000S0003l00003d01Olo0003l00002<0
00?o00006@000o00000@00003`000mD0000J0003o`0002<000?D0000?@05ocl000?D000090000ol0
000H0003e0000100000?0003e00001T000?o000090000o00000m00Go?`000o00000T0003o`0001P0
00?`0000400000l000?E000060000ol0000U0003e00003d01Olo0003e00002D000?o00005`000m@0
000@00003`000m@0000G0003o`0002H000?`0000?@05ocl000?`00009@000ol0000G0003l0000100
000?0003e@0001L000?o00009P000m@0000m00Go?`000m@0000V0003o`0001H000?D0000400000l0
00?D00005P000ol0000W0003l00003d01Olo0003l00002L000?o00005@000o00000@00003`000mD0
000E0003o`0002P000?D0000?@05ocl000?D00009`000ol0000E0003e0000100000?0003e00001D0
00?o0000:0000o00000[00;o1002o`<00ol400Go?`000o00000X0003o`0001@000?`0000400000l0
00?E000050000ol0000Y0003e00002X000Co003o0`02o`H000Co00001Olo0003e00002P000?o0000
50000m@0000@00002P00Ko3Dl=C`e?3Dl=C`e?3Dl=C`e?3Dl=C`e?3Dl?o`e?3Dl=C`e?3Dl=C`e?3D
l=C`e?3Dl=C`e?3Dl=C`e?3Dl=C`e?3Dl=C`e?3Dl=C`e?3Dl=C`e?3Dl=C`e?3Dl=C`e?3Dl=C`e?3D
l=C`e?3Dl005o`0Dl?o`e?oDl=C`e?3Dl=C`e?oDl=@5o`29e?3Dl=C`e?3Dl=C`e?3Dl=C`e?3Dl=C`
e?3Dl=C`e?3Dl=C`e?3Dl=C`e?3Dl=C`e?3Dl=C`e?3Dl=C`e?3Dl=C`e?3Dl=C`e?3Dl=C`e?3Dl=C`
e?3Dl=C`e?3Dl=C`e?3Dl=C`e?3Dl=Coe?3Dl=C`e?3Dl=C`e?3Dl=C`e?3Dl=C`e?3Dl=@02`0000l0
00?E00004`000ol0000Z0003e00002X000Co003o2003o`@01Olo0003e00002X000?o00004P000m@0
000@00003`000m@0000B0003o`0002/000?`0000:P001?l00?l80003o`0000@01Olo0003l00002X0
00?o00004P000o00000@00003`000mD0000A0003o`0002`000?D0000:`02o`T01?l300Go?`000m@0
000[0003o`00014000?D0000400000l000?D00004@000ol0000/0003l00003d01Olo0003l00002/0
00?o00004@000o00000@00003`000mD0000@0003o`0002d000?D0000?@05ocl000?D0000;0000ol0
000@0003e0000100000?0003e00000l000?o0000;P000o00000m00Go?`000o00000/0003o`000100
00?`0000400000l000?E00003`000ol0000^0003e00003d01Olo0003e00002d000?o00003`000m@0
000@00003`000m@0000>0003o`0002l000?`0000?@05ocl000?`0000;P000ol0000>0003l0000100
000?0003e@0000d000?o0000<0000m@0000m00Go?`000m@0000^0003o`0000h000?D0000400000l0
00?D00003@000ol0000`0003l00003d01Olo0003l00002l000?o00003@000o00000@00003`000mD0
000<0003o`00034000?D0000?@05ocl000?D0000;`000ol0000=0003e0000100000?0003e00000/0
00?o0000<P000o00000m00Go?`000o00000`0003o`0000`000?`0000400000l000?E00002P000ol0
000c0003e00003d01Olo0003e000030000?o000030000m@0000@00003`000m@0000:0003o`0003<0
00?`0000?@05ocl000?`0000<@000ol0000;0003l0000100000?0003e@0000T000?o0000=0000m@0
000m00Go?`000m@0000b0003o`0000X000?D0000400000l000?D000020000ol0000e0003l00003d0
1Olo0003l000038000?o00002P000o00000@00003`000mD000080003o`0003D000?D0000?@05ocl0
00?D0000<`000ol000090003e0000100000?0003e00000L000?o0000=P000o00000m00Go?`000o00
000c0003o`0000T000?`0000400000l000?E00001P000ol0000g0003e00003d01Olo0003e00003@0
00?o000020000m@0000@00003`000m@000060003o`0003L000?`0000?@05ocl000?`0000=@000ol0
00070003l0000100000?0003e@0000H000?o0000=`000m@0000m00Go?`000m@0000e0003o`0000L0
00?D0000400000l000?D00001P000ol0000g0003l00003d01Olo0003l00003H000?o00001P000o00
000@00003`000mD000060003o`0003L000?D0000?@05ocl000?D0000=P000ol000060003e0000100
000?0003e00000H000?o0000=`000o00000m00Go?`000o00000g0003o`0000D000?`0000400000l0
00?E00001@000ol0000h0003e00003d01Olo0003e00003L000?o00001@000m@0000@00003`000m@0
00050003o`0003P000?`0000?@05ocl000?`0000>0000ol000040003l0000100000?0003e@0000D0
00?o0000>0000m@0000m00Go?`000m@0000i0003o`0000<000?D0000400000l000?D00001@000ol0
000h0003l00003d01Olo0003l00003T000?o00000`000o00000@00003`000mD000050003o`0003P0
00?D0000?@05ocl000?D0000>P000ol000020003e0000100000?0003e00000D000?o0000>0000o00
000m00Go?`000o00000o0003l0000100000?0003e@0000D000?o0000>0000m@0000m00Go?`000m@0
000o0003e0000100000?0003e00000D000?o0000>0000o00000m00Go?`000o00000o0003l0000100
000?0003e@0000D000?o0000>0000m@0000m00Go?`000m@0000o0003e0000100000?0003e00000@0
00?o0000>@000o00000m00Go?`000o00000o0003l0000100000?0003e@0000@000?o0000>@000m@0
000m00Go?`000m@0000o0003e0000100000?0003e00000@000?o0000>@000o00000m00Go?`000o00
000o0003l0000100000?0003e@0000@000?o0000>@000m@0000m00Go?`000m@0000o0003e0000100
000?0003e00000@000?o0000>@000o00000m00Go?`000o00000o0003l0000100000?0003e@0000@0
00?o0000>@000m@0000m00Go?`000m@0000o0003e0000100000?0003e00000@000?o0000>@000o00
000m00Go?`000o00000o0003l0000100000?0003e@0000@000?o0000>@000m@0000m00Go?`000m@0
000o0003e0000100000?0003e00000@000?o0000>@000o00000m00Go?`000o00000o0003l0000100
000?0003e@0000@000?o0000>@000m@0000m00Go?`000m@0000o0003e0000100000?0003e00000<0
00?o0000>P000o00000m00Go?`000o00000o0003l0000100000?0003e@0000<000?o0000>P000m@0
000m00Go?`000m@0000o0003e0000100000?0003e00000<000?o0000>P000o00000m00Go?`000o00
000o0003l0000100000?0003e@0000<000?o0000>P000m@0000m00Go?`000m@0000o0003e0000100
000?0003e00000<000?o0000>P000o00000m00Go?`000o00000o0003l0000100000?0003e@0000<0
00?o0000>P000m@0000m00Go?`000m@0000o0003e0000100000?0003e00000<000?o0000>P000o00
000m00Go?`000o00000o0003l0000100000?0003e@0000<000?o0000>P000m@0000m00Go?`000m@0
000o0003e0000100000?0003e00000<000?o0000>P000o00000m00Go?`000o00000o0003l0000100
000?0003e@00008000?o0000>`000m@0000m00Go?`000m@0000o0003e0000100000?0003e0000080
00?o0000>`000o00000m00Go?`000o00000o0003l0000100000?0003e@00008000?o0000>`000m@0
000m00Go?`000m@0000o0003e0000100000?0006e?ooo`3o>@02o`8000C`0?oo0`03ocH01Olh00;o
1002o`<00oli00?o4P0000l000?E0?l00P000ol0000f0007o`00o`3D0002o`H000?o0000<`05ocL0
00Co003o0`02o`H000?o0000=`000ooD000A00002P05o`03e03o008000?o0000<005o`070?l00?l0
l0090003o`0003<01Olg0004o`00o`@000?`000010000ol0000g0003oo000140000?0003e@3o0080
00?o0000=P001_l00?l0e0H00olf00Go=`001?l00?l40004e00000?o>P000ooD000A00003`000m@0
o`020003o`0003H000Ko003o0?060003o`0003H01Olg0004o`00o`@000G`0000o`0l0003oo000140
000?0003eOoo008000?o0000=`02o`8000?D00001004ocD01Olh00;o1@001=@00004ocP00_l00m@0
000@00003`001M@0003o03h000?`0000?@05ocl000?`0000?`000o00000@00003`001MD0003o03h0
00?D0000?@05ocl000?D0000?`000m@0000@0000203ooa_o2@0000P0oolKo`T000080?oo6ol90000
203ooa_o2@0000P0oolKo`T0000?0005e@000?l0?P000m@0000m00Go?`000m@0000n0003om@00140
000?0005e0000?l0?P000o00000m00Go?`000o00000n0003oo000140000?0005e@000?l0?P000m@0
000m00Go?`000m@0000n0003om@00140000?0004e000ocl000?`0000?@05ocl000?`0000?P000oo`
000A00003`001=D00?lo0003e00003d01Olo0003e00003d000?o0=@04P0000l000CD003o?`000o00
000m00Go?`000o00000m0003o`3`0180000?0004e@00ocl000?D0000?@05ocl000?D0000?@000ol0
e00B00003`001=@00?lo0003l00003d01Olo0003l00003d000?o0?004P0000l000CE003o?`000m@0
000m00Go?`000m@0000l0004o`00e180000?0004e000ocl000?`0000?@05ocl000?`0000?0001?l0
0?0B00003`001=D00?lo0003e00003d01Olo0003e00003`000Co003D4P0000l000CD003o?`000o00
000m00Go?`000o00000l0004o`00l180000?0003e@3o040000?D0000?@05ocl000?D0000>`001Ol0
003D0180000?0003e03o040000?`0000?@05ocl000?`0000>`001Ol0003`0180000?0003e@3o0400
00?D0000?@05ocl000?D0000>`001Ol0003D0180000?0003e03o040000?`0000?@05ocl000?`0000
>`001Ol0003`0180000?0003e@3o040000?D0000?@05ocl000?D0000>P000ol000020003e0000100
000?0003e03o040000?`0000?@05ocl000?`0000>P000ol000020003l0000100000?0004e@00ocl0
00?D0000?@05ocl000?D0000>P000ol000020003e0000100000?0004e000ocl000?`0000?@05ocl0
00?`0000>P000ol000020003l0000100000?0004e@00ocl000?D0000?@05ocl000?D0000>@000ol0
00030003e0000100000?0005e0000?l0?P000o00000m00Go?`000o00000i0003o`0000<000?`0000
400000l000GE0000o`0n0003e00003d01Olo0003e00003T000?o00000`000m@0000@00003`000m@0
00020003o`0003/000?`0000?@05ocl000?`0000>@000ol000030003l0000100000?0003e@000080
00?o0000>`000m@0000m00Go?`000m@0000h0003o`0000@000?D0000400000l000?D00000P000ol0
000k0003l00003d01Olo0003l00003P000?o000010000o00000@00003`000mD000030003o`0003X0
00?D0000?@05ocl000?D0000>0000ol000040003e0000100000?0003e00000<000?o0000>P000o00
000m00Go?`000o00000h0003o`0000@000?`0000400000l000?E000010000ol0000i0003e00003d0
1Olo0003e00003L000?o00001@000m@0000@00003`000m@000040003o`0003T000?`0000?@05ocl0
00?`0000=`000ol000050003l0000100000?0003e@0000D000?o0000>0000m@0000m00Go?`000m@0
000g0003o`0000D000?D0000400000l000?D00001@000ol0000h0003l00003d01Olo0003l00003L0
00?o00001@000o00000@00003`000mD000050003o`0003P000?D0000?@05ocl000?D0000=P000ol0
00060003e0000100000?0003e00000H000?o0000=`000o00000m00Go?`000o00000f0003o`0000H0
00?`0000400000l000?E00001P000ol0000g0003e00003d01Olo0003e00003H000?o00001P000m@0
000@00003`000m@000070003o`0003H000?`0000?@05ocl000?`0000=P000ol000060003l0000100
000?0003e@0000L000?o0000=P000m@0000m00Go?`000m@0000e0003o`0000L000?D0000400000l0
00?D00001`000ol0000f0003l00003d01Olo0003l00003D000?o00001`000o00000@00003`000mD0
00080003o`0003D000?D0000?@05ocl000?D0000=@000ol000070003e0000100000?0003e00000P0
00?o0000=@000o00000m00Go?`000o00000e0003o`0000L000?`0000400000l000?E00002@000ol0
000d0003e00003d01Olo0003e00003@000?o000020000m@0000@00003`000m@000090003o`0003@0
00?`0000?@05ocl000?`0000=0000ol000080003l0000100000?0003e@0000T000?o0000=0000m@0
000m00Go?`000m@0000d0003o`0000P000?D0000400000l000?D00002P000ol0000c0003l00003d0
1Olo0003l00003@000?o000020000o00000@00003`000mD0000:0003o`0003<000?D0000?@05ocl0
00?D0000<`000ol000090003e0000100000?0003e00000/000?o0000<P000o00000m00Go?`000o00
000c0003o`0000T000?`0000400000l000?E00002`000ol0000b0003e00003d01Olo0003e00003<0
00?o00002@000m@0000@00003`000m@0000<0003o`00034000?`0000?@05ocl000?`0000<`000ol0
00090003l0000100000?0003e@0000`000?o0000<@000m@0000m00Go?`000m@0000b0003o`0000X0
00?D0000400000l000?D000030000ol0000a0003l00003d01Olo0003l000038000?o00002P000o00
000@00003`000mD0000=0003o`00030000?D0000?@05ocl000?D0000<P000ol0000:0003e0000100
000?0003e00000d000?o0000<0000o00000m00Go?`000o00000b0003o`0000X000?`0000400000l0
00?E00003P000ol0000_0003e00003d01Olo0003e000034000?o00002`000m@0000@00003`000m@0
000>0003o`0002l000?`0000?@05ocl000?`0000<@000ol0000;0003l0000100000?0003e@0000h0
00?o0000;`000m@0000m00Go?`000m@0000a0003o`0000/000?D0000400000l000?D00003`000ol0
000^0003l00003d01Olo0003l000034000?o00002`000o00000@00003`000mD0000?0003o`0002h0
00?D0000?@05ocl000?D0000<0000ol0000<0003e0000100000?0003e000010000?o0000;@000o00
000m00Go?`000o00000`0003o`0000`000?`0000400000l000?E000040000ol0000]0003e00003d0
1Olo0003e000030000?o000030000m@0000@00003`000m@0000@0003o`0002d000?`0000?@05ocl0
00?`0000<0000ol0000<0003l0000100000?0003e@00014000?o0000;0000m@0000m00Go?`000m@0
000_0003o`0000d000?D0000400000l000?D00004@000ol0000/0003l00003d01Olo0003l00002l0
00?o00003@000o00000@00003`000mD0000B0003o`0002/000?D0000:`02o`@00_l300?o1005ocl0
00?D0000;`000ol0000=0003e0000100000?0003e000018000?o0000:`000o00000Z0004o`00o`<0
0_l60004o`0000Go?`000o00000^0003o`0000h000?`0000400000X008SDeMCEe=GDeMCEe=GDeMCE
e=GDeMCEe=GDeOoEe=GDeMCEe=GDeMCEe=GDeMCEe=GDeMCEe=GDeMCEe=GDeMCEe=GDeMCEe=GDeMCE
e=GDeMCEe=GDeMCEe=GDeMCEe=GDeMCEe=GDeMCEe=GDeMCEe=GDeMCoe=GoeMCEe=GDeMCEe=GoeMCE
1Ol0RMGDeMCEe=GDeMCEe=GDeMCEe=GDeMCEe=GDeMCEe=GDeMCEe=GDeMCEe=GDeMCEe=GDeMCEe=GD
eMCEe=GDeMCEe=GDeMCEe=GDeMCEe=GDeMCEe=GDeMCEe=GDeMCEe=GDeMCEe=GDeMCEe=GDeOoEe=GD
eMCEe=GDeMCEe=GDeMCEe=GDeMCE00/0000?0003e00001<000?o0000:P000o00000Z0004o`00o`P0
0ol400Go?`000o00000/0003o`00010000?`0000400000l000?E00004`000ol0000Z0003e00002X0
00Co003o20000ol0000400Go?`000m@0000[0003o`00014000?D0000400000l000?D000050000ol0
000Y0003l00002/00_l900Co0`05ocl000?`0000:P000ol0000B0003l0000100000?0003e@0001@0
00?o0000:@000m@0000m00Go?`000m@0000Y0003o`0001<000?D0000400000l000?D00005@000ol0
000X0003l00003d01Olo0003l00002P000?o000050000o00000@00003`000mD0000E0003o`0002P0
00?D0000?@05ocl000?D00009`000ol0000E0003e0000100000?0003e00001D000?o0000:0000o00
000m00Go?`000o00000V0003o`0001H000?`0000400000l000?E00005P000ol0000W0003e00003d0
1Olo0003e00002D000?o00005`000m@0000@00003`000m@0000F0003o`0002L000?`0000?@05ocl0
00?`000090000ol0000H0003l0000100000?0003e@0001L000?o00009P000m@0000m00Go?`000m@0
000T0003o`0001P000?D0000400000l000?D00005`000ol0000V0003l00003d01Olo0003l00002<0
00?o00006@000o00000@00003`000mD0000G0003o`0002H000?D0000?@05ocl000?D00008P000ol0
000J0003e0000100000?0003e00001P00_lV0003l00003d01Olo0003l000024000?o00006`000o00
000@00003`000mD0000J0003o`0002<000?D0000?@05ocl000?D000080000ol0000L0003e0000100
000?0003e00001/000?o00008P000o00000m00Go?`000o00000O0003o`0001d000?`0000400000l0
00?E000070000ol0000Q0003e00003d01Olo0003e00001h000?o00007P000m@0000@00003`000m@0
000M0003o`00020000?`0000?@05ocl000?`00007@000ol0000O0003l0000100000?0003e@0001h0
0_lP0003e00003d01Olo0003e00001`000?o000080000m@0000@00003`000m@0000P0003o`0001d0
00?`0000?@05ocl000?`00006`000ol0000Q0003l0000100000?0003e@00024000?o000070000m@0
000m00Go?`000m@0000J0003o`00028000?D0000400000l000?D00008P000ol0000K0003l00003d0
1Olo0003l00001T000?o00008`000o00000@00003`000mD0000S00;o6`000m@0000m00Go?`000m@0
000H0003o`0002@000?D0000400000l000?D00009@000ol0000H0003l00003d01Olo0003l00001P0
00?o000090000o00000@00003`000mD0000V0003o`0001L000?D0000?@05ocl000?D00005`000ol0
000U0003e0000100000?0003e00002L000?o00005P000o00000m00Go?`000o00000F0003o`0002H0
00?`0000400000l000?E0000:0000ol0000E0003e00003d01Olo0003e00001D000?o00009`000m@0
000@00003`000m@0000Y00;o5@000o00000m00Go?`000o00000D0003o`0002P000?`0000400000l0
00?E0000:`000ol0000B0003e00003d01Olo0003e00001<000?o0000:@000m@0000@00003`000m@0
000/0003o`00014000?`0000?@05ocl000?`00004P000ol0000Z0003l0000100000?0003e@0002d0
00?o000040000m@0000m00Go?`000m@0000A0003o`0002/000?D0000400000l000?D0000;P000ol0
000?0003l00003d01Olo0003l000010000?o0000;0000o00000@00003`000mD0000_00;o3`000m@0
000m00Go?`000m@0000?0003o`0002d000?D0000400000l000?D0000<@000ol0000<0003l00003d0
1Olo0003l00000h000?o0000;P000o00000@00003`000mD0000b0003o`0000/000?D0000?@05ocl0
00?D00003@000ol0000_0003e0000100000?0003e00003<000?o00002P000o00000m00Go?`000o00
000=0003o`0002l000?`0000400000l000?E0000=002o`X000?D0000?@05ocl000?D000030000ol0
000`0003e0000100000?0003e00003H000?o00001`000o00000m00Go?`000o00000;0003o`000340
00?`0000400000l000?E0000=`000ol000060003e00003d01Olo0003e00000X000?o0000<P000m@0
000@00003`000m@0000h0003o`0000D000?`0000?@05ocl000?`00002@000ol0000c0003l0000100
000?0003e@0003T000?o000010000m@0000m00Go?`000m@000080003o`0003@000?D0000400000l0
00?D0000>P02o`@000?`0000?@05ocl000?`00001`000ol0000e0003l0000100000?0003e@0003`0
00Go0000e00o00Go?`000m@000060003o`0003H000?D0000400000l000?D0000?@001?l00?0o00Go
?`000o0000050003o`0003L000?`0000400000l000?E0000?P000ol0e00o00Go?`000m@000040003
o`0003P000?D0000400000l000?D0000?`000oo`000n00Go?`000o0000030003o`0003T000?`0000
400000l000?E0000@002och01Olo0003e00000?o?0000m@0000@00003`000m@000100003l03o03d0
1Olo00?o?`000o00000@00003`000mD000100004e000oc`01Oll00?o00?D0000?`000m@0000@0000
3`000m@000100005l0000?l0>`05ocT00ol30003l00003l000?`0000400000l000?E0000@0000m@0
000200;o>@05ocH00ol60003e00003l000?D0000400000l000?D0000@0000o0000040003o`0003H0
1Olc00?o2@000o00000o0003l0000100000?0003e@00040000?D00001@000ol0000e00Go<003o``0
00?D0000?`000m@0000@00003`000m@000100003l00000H000?o0000=005obd00ol?0003l00003l0
00?`0000400000l000?E0000@0000m@000070003o`0003<01OlZ00?o4P000m@0000o0003e0000100
000?0003e000040000?`00002004oc401OlW00?o5@000o00000o0003l0000100000?0003e@000400
00?D00003006ob/01OlS00Co60000m@0000o0003e0000100000?0003e000040000?`00004P06obD0
1OlP00?o70000o00000o0003l0000100000?0003e@00040000?D00006005ob001OlM00?o7`000m@0
000o0003e0000100000?0003e000040000?`00007@06oaX01OlJ00?o8P000o00000o0003l0000100
000?0003e@00040000?D00008`06oa@01OlG00?o9@000m@0000o0003e0000100000?0003e0000400
00?`0000:@06o`h01OlD00?o:0000o00000o0003l0000100000?0003e@00040000?D0000;`06o`P0
1OlA00?o:`000m@0000o0003e0000100000?0003e000040000?`0000=@05o`<01Ol>00?o;P000o00
000o0003l0000100000?0003e@00040000?D0000>P08o`/00ola0003e00003l000?D0000400000l0
00?D0000@0000o00000f00?o1009o`@00old0003l00003l000?`0000400000l000?E0000@0000m@0
000g0003o`0000<01Ol400Co=`000m@0000o0003e0000100000:0028l=C`e?3Dl=C`e?3Dl=C`e?3D
l=C`e?3Dl=C`e?3Dl=C`e?3Dl=C`e?3Dl=C`e?3Dl=C`e?3Dl=C`e?3Dl=C`e?3Dl=C`e?3Dl=C`e?3D
l=C`e?3Dl=C`e?3Dl=C`e?3Dl=C`e?3Dl=C`e?3Dl=C`e?3Dl=C`e?3Dl=C`e?3Dl=C`e?oDl=C`e0Go
08WDl=C`e?3Dl=C`e?3Dl=C`e?3Dl=C`e?3Dl=C`e?3Dl=C`e?3Dl=C`e?3Dl=C`e?3Dl=C`e?3Dl=C`
e?3Dl=C`e?3Dl=C`e?3Dl=C`e?3Dl=C`e?3Dl=C`e?3Dl=C`e?3Dl=C`e?3Dl=C`e?3Dl=C`e?3Dl=C`
e?3Dl=C`e?3Dl=C`e?3Dl=C`e00;00003`000mD000100003e00003L000?o00000`05ocl000?D0000
?`000m@0000@00003`000m@000100003l00003L000?o00000`05ocl000?`0000?`000o00000@0000
3`000mD000100003e00003H00_l500Go?`000m@0000o0003e0000100000?0003e000040000?`0000
?@05ocl000?`0000?`000o00000@00003`000mD000100003e00003d01Olo0003e00003l000?D0000
400000l000?D0000@0000o00000m00Go?`000o00000o0003l0000100002B00GoU00009801OnD0000
o`0/0000o`0/0000o`0/0000o`0/0000o`0/0000N@03o`801Ol00`3oo`02o`<00ol200Go0P04o`80
2_l200?o0P05ogP0001h0005o`000?l00`000ol000020003o`00008000Go0000o`030005o`000?l0
1@001ol0003o0?l00P001Ol0003o008000?o0?l00P000ol0001g0000N0000ol000050003o`000080
00?o00000P000ol000050004o`0000Go00<0o`000P000ol0o`03o`<000?o00000P04ogT0001h0005
o`000?l00`000ol0000200;o0`001Ol0003o00<000Go0000o`030003o`3o00<000?o00000P001Ol0
003o00L000?o0000M`0007T01?l200;o0`02o`030?oo00801?l30003o`0000800ol300Co0P03o`80
1?l300?oN@00098000?o00002`000ol000060003o`0007l000200003o`0000d00ol<00;o20000ol0
001o0000o`0/0000o`0/0000o`0/0000o`0/0000\
\>"],
  ImageRangeCache->{{{0, 298.062}, {298.062, 0}} -> {-1.11987, -1.04765, 
  0.0075479, 0.00749113}}]
}, Closed]],

Cell[TextData[{
  StyleBox["Options[", "Input"],
  StyleBox["graphing function",
    FontSlant->"Italic"],
  StyleBox["]", "Input"],
  " returns a list of options that a particular graphing function accepts, \
along with their default values."
}], "Text"],

Cell[TextData[{
  StyleBox["ListPlot", "Input"],
  " also accepts a flat list of data, and generates a scatter plot in which \
each data point is assumed to have horizontal coordinate 1, 2, 3, \
\[Ellipsis]. Here we create a scatter plot of the second coordinate of each \
ordered pair in ",
  StyleBox["circledata", "Input"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(ListPlot[Last[Transpose[circledata]], PlotStyle -> PointSize[0.03]]; 
    \)\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.0732601 0.306042 0.298023 [
[.17033 .29354 -3 -9 ]
[.17033 .29354 3 0 ]
[.31685 .29354 -3 -9 ]
[.31685 .29354 3 0 ]
[.46337 .29354 -3 -9 ]
[.46337 .29354 3 0 ]
[.60989 .29354 -3 -9 ]
[.60989 .29354 3 0 ]
[.75641 .29354 -6 -9 ]
[.75641 .29354 6 0 ]
[.90293 .29354 -6 -9 ]
[.90293 .29354 6 0 ]
[.01131 .00802 -12 -4.5 ]
[.01131 .00802 0 4.5 ]
[.01131 .15703 -24 -4.5 ]
[.01131 .15703 0 4.5 ]
[.01131 .45505 -18 -4.5 ]
[.01131 .45505 0 4.5 ]
[.01131 .60407 -6 -4.5 ]
[.01131 .60407 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.17033 .30604 m
.17033 .31229 L
s
[(2)] .17033 .29354 0 1 Mshowa
.31685 .30604 m
.31685 .31229 L
s
[(4)] .31685 .29354 0 1 Mshowa
.46337 .30604 m
.46337 .31229 L
s
[(6)] .46337 .29354 0 1 Mshowa
.60989 .30604 m
.60989 .31229 L
s
[(8)] .60989 .29354 0 1 Mshowa
.75641 .30604 m
.75641 .31229 L
s
[(10)] .75641 .29354 0 1 Mshowa
.90293 .30604 m
.90293 .31229 L
s
[(12)] .90293 .29354 0 1 Mshowa
.125 Mabswid
.06044 .30604 m
.06044 .30979 L
s
.09707 .30604 m
.09707 .30979 L
s
.1337 .30604 m
.1337 .30979 L
s
.20696 .30604 m
.20696 .30979 L
s
.24359 .30604 m
.24359 .30979 L
s
.28022 .30604 m
.28022 .30979 L
s
.35348 .30604 m
.35348 .30979 L
s
.39011 .30604 m
.39011 .30979 L
s
.42674 .30604 m
.42674 .30979 L
s
.5 .30604 m
.5 .30979 L
s
.53663 .30604 m
.53663 .30979 L
s
.57326 .30604 m
.57326 .30979 L
s
.64652 .30604 m
.64652 .30979 L
s
.68315 .30604 m
.68315 .30979 L
s
.71978 .30604 m
.71978 .30979 L
s
.79304 .30604 m
.79304 .30979 L
s
.82967 .30604 m
.82967 .30979 L
s
.8663 .30604 m
.8663 .30979 L
s
.93956 .30604 m
.93956 .30979 L
s
.97619 .30604 m
.97619 .30979 L
s
.25 Mabswid
0 .30604 m
1 .30604 L
s
.02381 .00802 m
.03006 .00802 L
s
[(-1)] .01131 .00802 1 0 Mshowa
.02381 .15703 m
.03006 .15703 L
s
[(-0.5)] .01131 .15703 1 0 Mshowa
.02381 .45505 m
.03006 .45505 L
s
[(0.5)] .01131 .45505 1 0 Mshowa
.02381 .60407 m
.03006 .60407 L
s
[(1)] .01131 .60407 1 0 Mshowa
.125 Mabswid
.02381 .03782 m
.02756 .03782 L
s
.02381 .06762 m
.02756 .06762 L
s
.02381 .09743 m
.02756 .09743 L
s
.02381 .12723 m
.02756 .12723 L
s
.02381 .18683 m
.02756 .18683 L
s
.02381 .21663 m
.02756 .21663 L
s
.02381 .24644 m
.02756 .24644 L
s
.02381 .27624 m
.02756 .27624 L
s
.02381 .33584 m
.02756 .33584 L
s
.02381 .36565 m
.02756 .36565 L
s
.02381 .39545 m
.02756 .39545 L
s
.02381 .42525 m
.02756 .42525 L
s
.02381 .48486 m
.02756 .48486 L
s
.02381 .51466 m
.02756 .51466 L
s
.02381 .54446 m
.02756 .54446 L
s
.02381 .57426 m
.02756 .57426 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.03 w
.09707 .30604 Mdot
.17033 .44892 Mdot
.24359 .55682 Mdot
.31685 .60332 Mdot
.39011 .57703 Mdot
.46337 .4844 Mdot
.53663 .3481 Mdot
.60989 .2015 Mdot
.68315 .0805 Mdot
.75641 .01472 Mdot
.82967 .02026 Mdot
.90293 .09577 Mdot
.97619 .22277 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{299.062, 184.75},
  ImageMargins->{{48, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004[0000^0P10`4000010?ooooooc?ooZ_ooI_oo
<ooo0?o<ooo<c?o<VC/k>gYjN[Vi^OShn03ooeGooj[ooonI<onI0?mVoomVc?mVVOmVI_mV<omV0?lc
oclo?ginO[fm_Oclo5D00:X00?l00?l0VOl0I_l0<ol00<coolcoc<coVLcoIP<30d92@X61PL30`000
EED0EJX0EOl0ELbIolbIc<bIVLbII/bI<lbI0<aVolaVc0L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0Z/`c
<l`c0<`0ol`0c<`0VL`0I/`0<l`000/;2dY:BXV9RLS8b000oeD0ojX0ool0oiW<VIW<IYW<<iW<09VI
oiVIc9VIVIVIIPl?3di>CXf=SLc<c01E05EE0:YE0?mE09TcoiTcc9TcVITcIYTc<iTc09T0oiT0c1<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEEFKo<fKo06K<ofK<c6K<VFK<IVK<<fK<01LG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZVIVVFIVIVIV<fIV06HcofHcc6HcVFHcIQ/K6eYJFYVIVMSHf01EoeEEojYEoomEoc?o
oc?oc3?oVC?oIS?o<c?o03?<oc?<c1lO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ03>I<c>I03=Voc=Vc3=V
VC=VIS=V<c=V02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZEC<0VC<0IS<0<c<0003oo`3oc03oV@3oIRLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2Io`2Ic02IV@2IIP2I<`2I001Vo`1Vc2/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`0c<`0c0000o`00c000V@00IP00<nh002l_;fi^KZf][Nc/k03o05Go0:[o0?oo0140
003^003M002k002Z0028001g001E03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@00M`00E@00A0008P00
4Nk^k]gMgK^k^cLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l0;0000?l0;0000?l0;0000?l0;0000?l0
;0000?l0;0000?l0;00001<00ol50003o`000<H01?m3000050000ol000040003o`000<D01_m20000
3@05o`8000?o00001003ol@02?l?00Co;P0001@000?o000010000ol0003400So3P06obd0000D0003
o`0000@000?o0000a008o`d02?l/00004`02o`H000?o0000a008o`d02?l/00006`000ol0003500Ko
3P08ob`0000K0003o`000<H01?l?00So;00001/000?o0000fP06obd0000K0003o`000=/01?l^0000
6`02ool03`0001/000?o0000o`0>00006`000ol0003o00h0000K0003o`000?l03P0001/000?o0000
o`0>00006`000ol0003o00h0000K0003o`000?l03P0001/000?o0000o`0>00006`000ol0003o00h0
000K00;o/`04oeL0000K0003o`000;401_mF00006`000ol0002`00SoE@0001/000?o0000/008oeD0
000K0003o`000;002?lg00Co6P0001/000?o0000/008ocH01_lI00006`000ol0002a00Ko=P08oaP0
000K0003o`000;801?lg00So600001/00_o^00So600001/000?o0000k@08oaP0000K0003o`000>h0
1_lI00006`000ol0003_00Co6P0001/000?o0000o`0>00006`000ol0003o00h0000K0003o`000?l0
3P0001/000?o0000o`0>00006`02ool03`0001/000?o0000o`0>00006`000ol0003o00h0000K0003
o`000?l03P0001/000?o0000o`0>00006`000ol0003o00h0000800;o1002o`<00ol50003o`000?l0
3P0000L000Co003o0`02o`H000?o00000P000ol0003o00h000000`3oo`03o`050?l00?l02`000ol0
000200?oo`0>00001`001?l00?l800?o1@000ol0003o00h000070004o`00o`P000?o00001@000ol0
003o00h0000800;o2@04o`@000?o0000o`0>00006`000ol0003o00h0000K0003o`000?l03P0001/0
00?o0000o`0>00006`000ol0003o00h0000K0003o`000?l03P0001/00_nO00CoJ`0001/000?o0000
W@06ofX0000K0003o`0009`02?mY00006`000ol0002L00SoJ@0001/000?o0000W008ofT0000K0003
o`0009`02?mY00006`000ol0002M00KoH004o`H0000K0003o`0009h01?mP00Ko1@0001/00_oo00<0
2?l400006`000ol0003o00802?l400006`000ol0003o00802?l400006`000ol0003o00802?l40000
6`000ol0003o00<01_l500006`000ol0003o00@01?l600006`000ol0003o00h0000K0003o`000?l0
3P0001/00_oo00l0000K0003o`000?l03P0001/000?o0000o`0>00006`000ol0003o00h0000K0003
o`000?l03P0001/000?o0000o`0>00006`000ol0000T00Co9@03obH00_lV00;o8`03o`@00_lP00?o
0`04oaL0000K0003o`0002D000?o00009P000ol0000T0004o`00ob@000Co003o8`000ol000020004
o`00ob0000?o00000`000ol0000G00006`02obL000?o00008`04obD000Co003o90001?l00?lS0003
o`00008000Co003o80000ol000040003o`0001H0000K0003o`0002L000?o00008P000ol0o`0V00?o
9P02ob@000?o00000P001?l00?lP0003o`0000D000?o00005@0001/000?o000090001?l00?lT0003
o`3o02H000?o00009@001?l00?lS0003o`00008000Co003o80000ol000020004o`00oaL0000K0003
o`0002D00_lV00;o9`03obD00_lS00;o1@02ob000_l500;o600001/000?o0000o`0>00006`000ol0
000@00Con@0001/000?o00003`06ooP0000K0003o`0000h02?og00006`000ol0000>00Som`0001@0
oolHo`006`000ol000070003o`0000@02?l50003o`0000P000?o00001`000ol000070003o`0000L0
00?o00001`000ol000070003o`0000P000?o00001`000ol000070003o`0000L000?o00001`000ol0
00070003o`0000L000?o000020000ol000070003o`0000L000?o00001`000ol000070003o`0000L0
00?o000020000ol000070003o`0000L000?o00001`000ol0000500006`000ol0000?00Kon00001/0
00?o00004004ooT0000K0003o`000?l03P0001/000?o0000o`0>00006`000ol0003o00h0000K0003
o`000?l03P0001/00_n:00CoP00001/000?o0000R006ogl0000K0003o`0008L02?mn00006`000ol0
002700SoOP0001/000?o0000Q`08ogh0000K0003o`0008L02?mn00006`000ol0002800KoO`0001/0
00?o0000R@04oh00000K00;oo`0?00006`000ol0003o00h0000K0003o`000?l03P0001/000?o0000
o`0>00006`000ol0003o00h0000K0003o`000?l03P0001/000?o0000o`0>00006`000ol0003o00h0
000K00;oo`0?00006`000ol0003o00h0000K0003o`000?l03P0001/000?o0000o`0>00006`000ol0
003o00h0000K0003o`000?l03P0001/000?o0000o`0>00006`000ol0003o00h0000K0003o`000?l0
3P0001/00_oo00l0000K0003o`000?l03P0001/000?o0000o`0>00006`000ol0000T00Coi@0001/0
00?o00008`06on@0000K0003o`0002802?oS00002002o`@00_l300?o1@000ol0000R00Soh`0000L0
00Co003o0`02o`H000?o00000P000ol0000R00Soh`0000L000Co003o2`000ol0000200?o8P08on<0
00070004o`00o`P00ol50003o`0002<01_oT00001`001?l00?l80003o`0000D000?o00009004onD0
000800;o2@04o`@000?o0000o`0>00006`000ol0003o00h0000K0003o`0007D01?nD00006`000ol0
001d00KoT`0001/000?o0000L`08oi80000K00;oM008oi80000K0003o`0007<02?nB00006`000ol0
001c00SoTP0001/000?o0000M006oi<0000K0003o`0007D01?nD00006`000ol0003o00h0000K0003
o`000?l03P0001/000?o0000o`0>00006`02ool03`0001/000?o0000o`0>00006`000ol0003o00h0
000K0003o`000?l03P0001/000?o0000o`0>00006`000ol0003o00h0000K0003o`000?l03P0001/0
00?o0000o`0>00006`000ol0003o00h0000K00;o>@04om40000K0003o`0003L01_o@00006`000ol0
000f00Soc`0001/000?o0000=P08oll0000K0003o`0003H02?o?00006`000ol0000f00So8`04ojP0
000K0003o`0003L01_lS00KoY`0001/000?o0000>004ob<02?nV00006`02of002?nV00006`000ol0
001O00SoYP0001/000?o0000G`08ojH0000K0003o`0006001_nW00006`000ol0001Q00CoZ00001/0
00?o0000C@04ok`0000C00?o1@000ol0001<00Ko^`0001@000?o000010000ol0001;00So^P0001@0
00?o00001003od/02?nj000050000ol000040003o`0004/02?nj000050000ol000040003o`0004/0
2?nj00004`02o`H000?o0000C006ok/0000K0003o`0004d01?nl0000o`0/0000o`0/0000o`0/0000
o`0/0000o`0/0000\
\>"],
  ImageRangeCache->{{{0, 298.062}, {183.75, 0}} -> {-1.35253, -1.11214, 
  0.0492433, 0.012105}}]
}, Closed]],

Cell[BoxData[
    \(Clear[circledata]\)], "Input"],

Cell[TextData[{
  "The function ",
  StyleBox["ListPlot3D", "Input"],
  " accepts a rectangular grid of height values, and generates a surface plot \
of the data. Here is a rectangular array of numbers."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(newdata = Table[Binomial[n, m], {n, 1, 10}, {m, 1, 5}]; 
    TableForm[newdata]\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {"1", "0", "0", "0", "0"},
          {"2", "1", "0", "0", "0"},
          {"3", "3", "1", "0", "0"},
          {"4", "6", "4", "1", "0"},
          {"5", "10", "10", "5", "1"},
          {"6", "15", "20", "15", "6"},
          {"7", "21", "35", "35", "21"},
          {"8", "28", "56", "70", "56"},
          {"9", "36", "84", "126", "126"},
          {"10", "45", "120", "210", "252"}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Closed]],

Cell["Here is a surface plot of the array.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(ListPlot3D[newdata]; \)\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .81114 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% SurfaceGraphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-1.11022e-16 1.04977 -0.0679587 1.04977 [
[.02757 .24618 -6 -8.70276 ]
[.02757 .24618 0 .29724 ]
[.17646 .18758 -5.89944 -9 ]
[.17646 .18758 .10056 0 ]
[.3345 .12542 -5.5867 -9 ]
[.3345 .12542 .4133 0 ]
[.50253 .05935 -5.27396 -9 ]
[.50253 .05935 .72604 0 ]
[.68156 -0.01098 -4.96123 -9 ]
[.68156 -0.01098 1.03877 0 ]
[.73867 .05295 0 -6.20496 ]
[.73867 .05295 6 2.79504 ]
[.80849 .15988 0 -6.10118 ]
[.80849 .15988 6 2.89882 ]
[.87175 .25674 0 -6.0093 ]
[.87175 .25674 6 2.9907 ]
[.92931 .34489 0 -5.9274 ]
[.92931 .34489 6 3.0726 ]
[.98191 .42546 0 -5.85393 ]
[.98191 .42546 12 3.14607 ]
[.02411 .26511 -6 -2.74232 ]
[.02411 .26511 0 6.25768 ]
[.01198 .34116 -12 -2.80666 ]
[.01198 .34116 0 6.19334 ]
[-0.00077 .42106 -18 -2.87461 ]
[-0.00077 .42106 0 6.12539 ]
[ 0 0 0 0 ]
[ 1 .81114 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.03716 .25514 m
.68874 0 L
s
.03716 .25514 m
.04196 .25962 L
s
[(1)] .02757 .24618 1 .93395 Mshowa
.18558 .19702 m
.19014 .20174 L
s
[(2)] .17646 .18758 .96648 1 Mshowa
.34306 .13535 m
.34735 .14032 L
s
[(3)] .3345 .12542 .86223 1 Mshowa
.51046 .06981 m
.51442 .07504 L
s
[(4)] .50253 .05935 .75799 1 Mshowa
.68874 0 m
.69233 .00549 L
s
[(5)] .68156 -0.01098 .65374 1 Mshowa
.125 Mabswid
.06616 .24378 m
.06901 .2465 L
s
.09549 .2323 m
.09832 .23504 L
s
.12517 .22067 m
.12797 .22345 L
s
.1552 .20892 m
.15797 .21172 L
s
.21633 .18498 m
.21903 .18784 L
s
.24744 .1728 m
.25012 .17569 L
s
.27893 .16047 m
.28157 .16339 L
s
.3108 .14799 m
.31341 .15094 L
s
.37572 .12257 m
.37826 .12558 L
s
.40878 .10962 m
.41128 .11266 L
s
.44225 .09652 m
.44471 .09959 L
s
.47614 .08324 m
.47856 .08635 L
s
.54521 .0562 m
.54755 .05937 L
s
.58041 .04242 m
.5827 .04562 L
s
.61605 .02846 m
.6183 .03169 L
s
.65216 .01432 m
.65436 .01759 L
s
.25 Mabswid
.68874 0 m
.96935 .42924 L
s
.72639 .0576 m
.72026 .05993 L
s
[(2)] .73867 .05295 -1 .37888 Mshowa
.79613 .16428 m
.78995 .16648 L
s
[(4)] .80849 .15988 -1 .35582 Mshowa
.8593 .26091 m
.85308 .263 L
s
[(6)] .87175 .25674 -1 .3354 Mshowa
.9168 .34886 m
.91054 .35084 L
s
[(8)] .92931 .34489 -1 .3172 Mshowa
.96935 .42924 m
.96306 .43113 L
s
[(10)] .98191 .42546 -1 .30087 Mshowa
.125 Mabswid
.7445 .0853 m
.74081 .08667 L
s
.76215 .11229 m
.75845 .11365 L
s
.77935 .13861 m
.77565 .13995 L
s
.8125 .18932 m
.80879 .19062 L
s
.82848 .21376 m
.82476 .21504 L
s
.84407 .23761 m
.84035 .23888 L
s
.87418 .28366 m
.87044 .2849 L
s
.88871 .30589 m
.88497 .30711 L
s
.90292 .32762 m
.89917 .32882 L
s
.93037 .36962 m
.92662 .3708 L
s
.94365 .38993 m
.93989 .39109 L
s
.95664 .4098 m
.95287 .41095 L
s
.70781 .02918 m
.70414 .0306 L
s
.25 Mabswid
.03716 .25514 m
0 .48963 L
s
.03634 .26033 m
.04245 .25795 L
s
[(0)] .02411 .26511 1 -0.3906 Mshowa
.02426 .33653 m
.0304 .33422 L
s
[(50)] .01198 .34116 1 -0.3763 Mshowa
.01157 .4166 m
.01774 .41437 L
s
[(100)] -0.00077 .42106 1 -0.3612 Mshowa
.125 Mabswid
.03397 .27528 m
.03764 .27386 L
s
.03158 .29037 m
.03525 .28895 L
s
.02916 .30561 m
.03284 .3042 L
s
.02672 .32099 m
.0304 .3196 L
s
.02177 .35223 m
.02546 .35085 L
s
.01926 .36808 m
.02295 .36671 L
s
.01672 .38409 m
.02042 .38273 L
s
.01416 .40026 m
.01786 .39891 L
s
.00896 .4331 m
.01266 .43177 L
s
.00632 .44977 m
.01003 .44845 L
s
.00365 .46661 m
.00736 .46531 L
s
.00095 .48363 m
.00467 .48234 L
s
.25 Mabswid
.03716 .25514 m
0 .48963 L
s
0 .48963 m
.39787 .81114 L
s
.39787 .81114 m
.40529 .59895 L
s
.40529 .59895 m
.03716 .25514 L
s
.68874 0 m
.96935 .42924 L
s
.96935 .42924 m
1 .6535 L
s
1 .6535 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.03716 .25514 m
0 .48963 L
s
0 .48963 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.68874 0 m
.03716 .25514 L
s
.40529 .59895 m
.96935 .42924 L
s
.96935 .42924 m
1 .6535 L
s
1 .6535 m
.39787 .81114 L
s
.39787 .81114 m
.40529 .59895 L
s
0 0 m
1 0 L
1 .81114 L
0 .81114 L
closepath
clip
newpath
.5 Mabswid
.524 .689 .943 r
.3701 .58407 .40464 .6174 .53625 .6277 .50306 .58171 Metetra
.438 .583 .9 r
.50306 .58171 .53625 .6277 .68133 .69973 .64726 .61076 Metetra
.539 .51 .772 r
.64726 .61076 .68133 .69973 .83716 .69613 .8051 .6331 Metetra
.646 .636 .826 r
.8051 .6331 .83716 .69613 1 .6535 .96947 .58803 Metetra
.568 .706 .934 r
.33417 .54941 .3701 .58407 .50306 .58171 .46872 .53558 Metetra
.547 .642 .896 r
.46872 .53558 .50306 .58171 .64726 .61076 .61312 .53271 Metetra
.608 .573 .789 r
.61312 .53271 .64726 .61076 .8051 .6331 .76771 .50795 Metetra
.642 .529 .71 r
.76771 .50795 .8051 .6331 .96947 .58803 .92779 .43782 Metetra
.601 .717 .926 r
.29679 .51334 .33417 .54941 .46872 .53558 .4331 .48924 Metetra
.608 .674 .888 r
.4331 .48924 .46872 .53558 .61312 .53271 .5785 .46354 Metetra
.647 .618 .807 r
.5785 .46354 .61312 .53271 .76771 .50795 .73255 .41488 Metetra
.661 .58 .754 r
.73255 .41488 .76771 .50795 .92779 .43782 .89294 .34227 Metetra
.625 .724 .918 r
.25785 .47577 .29679 .51334 .4331 .48924 .39609 .44263 Metetra
.642 .694 .883 r
.39609 .44263 .4331 .48924 .5785 .46354 .54304 .40146 Metetra
.665 .653 .828 r
.54304 .40146 .5785 .46354 .73255 .41488 .69816 .3428 Metetra
.669 .633 .805 r
.69816 .3428 .73255 .41488 .89294 .34227 .86084 .27504 Metetra
.643 .729 .911 r
.21726 .43661 .25785 .47577 .39609 .44263 .35756 .39565 Metetra
.66 .707 .882 r
.35756 .39565 .39609 .44263 .54304 .40146 .50641 .34479 Metetra
.671 .681 .851 r
.50641 .34479 .54304 .40146 .69816 .3428 .66347 .28354 Metetra
.668 .68 .852 r
.66347 .28354 .69816 .3428 .86084 .27504 .82915 .22049 Metetra
.655 .732 .906 r
.17492 .39575 .21726 .43661 .35756 .39565 .31736 .34823 Metetra
.668 .716 .884 r
.31736 .34823 .35756 .39565 .50641 .34479 .46831 .29195 Metetra
.669 .704 .873 r
.46831 .29195 .50641 .34479 .66347 .28354 .62776 .23099 Metetra
.665 .714 .885 r
.62776 .23099 .66347 .28354 .82915 .22049 .79661 .16955 Metetra
.663 .734 .903 r
.13069 .35309 .17492 .39575 .31736 .34823 .27532 .30026 Metetra
.669 .723 .89 r
.27532 .30026 .31736 .34823 .46831 .29195 .42848 .24137 Metetra
.665 .721 .891 r
.42848 .24137 .46831 .29195 .62776 .23099 .59054 .18058 Metetra
.663 .734 .903 r
.59054 .18058 .62776 .23099 .79661 .16955 .76258 .11761 Metetra
.667 .735 .901 r
.08447 .30849 .13069 .35309 .27532 .30026 .23127 .25165 Metetra
.666 .728 .896 r
.23127 .25165 .27532 .30026 .42848 .24137 .38668 .19148 Metetra
.663 .734 .903 r
.38668 .19148 .42848 .24137 .59054 .18058 .5515 .12919 Metetra
.664 .741 .908 r
.5515 .12919 .59054 .18058 .76258 .11761 .72677 .06296 Metetra
.667 .735 .901 r
.0361 .26182 .08447 .30849 .23127 .25165 .18499 .20227 Metetra
.663 .734 .903 r
.18499 .20227 .23127 .25165 .38668 .19148 .34274 .14065 Metetra
.664 .741 .908 r
.34274 .14065 .38668 .19148 .5515 .12919 .51043 .07515 Metetra
.664 .741 .908 r
.51043 .07515 .5515 .12919 .72677 .06296 .68905 .00539 Metetra
0 g
.25 Mabswid
.68874 0 m
.96935 .42924 L
s
.96935 .42924 m
1 .6535 L
s
1 .6535 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.03716 .25514 m
0 .48963 L
s
0 .48963 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.68874 0 m
.03716 .25514 L
s
.03716 .25514 m
.68874 0 L
s
.03716 .25514 m
.04196 .25962 L
s
[(1)] .02757 .24618 1 .93395 Mshowa
.18558 .19702 m
.19014 .20174 L
s
[(2)] .17646 .18758 .96648 1 Mshowa
.34306 .13535 m
.34735 .14032 L
s
[(3)] .3345 .12542 .86223 1 Mshowa
.51046 .06981 m
.51442 .07504 L
s
[(4)] .50253 .05935 .75799 1 Mshowa
.68874 0 m
.69233 .00549 L
s
[(5)] .68156 -0.01098 .65374 1 Mshowa
.125 Mabswid
.06616 .24378 m
.06901 .2465 L
s
.09549 .2323 m
.09832 .23504 L
s
.12517 .22067 m
.12797 .22345 L
s
.1552 .20892 m
.15797 .21172 L
s
.21633 .18498 m
.21903 .18784 L
s
.24744 .1728 m
.25012 .17569 L
s
.27893 .16047 m
.28157 .16339 L
s
.3108 .14799 m
.31341 .15094 L
s
.37572 .12257 m
.37826 .12558 L
s
.40878 .10962 m
.41128 .11266 L
s
.44225 .09652 m
.44471 .09959 L
s
.47614 .08324 m
.47856 .08635 L
s
.54521 .0562 m
.54755 .05937 L
s
.58041 .04242 m
.5827 .04562 L
s
.61605 .02846 m
.6183 .03169 L
s
.65216 .01432 m
.65436 .01759 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{299.062, 242.375},
  ImageMargins->{{48, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004[0000lPP10`4000010?ooooooc?ooZ_ooI_oo
<ooo0?o<ooo<c?o<VC/k>gYjN[Vi^OShn03ooeGooj[ooonI<onI0?mVoomVc?mVVOmVI_mV<omV0?lc
oclo?ginO[fm_Oclo5D00:X00?l00?l0VOl0I_l0<ol00<coolcoc<coVLcoIP<30d92@X61PL30`000
EED0EJX0EOl0ELbIolbIc<bIVLbII/bI<lbI0<aVolaVc0L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0Z/`c
<l`c0<`0ol`0c<`0VL`0I/`0<l`000/;2dY:BXV9RLS8b000oeD0ojX0ool0oiW<VIW<IYW<<iW<09VI
oiVIc9VIVIVIIPl?3di>CXf=SLc<c01E05EE0:YE0?mE09TcoiTcc9TcVITcIYTc<iTc09T0oiT0c1<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEEFKo<fKo06K<ofK<c6K<VFK<IVK<<fK<01LG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZVIVVFIVIVIV<fIV06HcofHcc6HcVFHcIQ/K6eYJFYVIVMSHf01EoeEEojYEoomEoc?o
oc?oc3?oVC?oIS?o<c?o03?<oc?<c1lO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ03>I<c>I03=Voc=Vc3=V
VC=VIS=V<c=V02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZEC<0VC<0IS<0<c<0003oo`3oc03oV@3oIRLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2Io`2Ic02IV@2IIP2I<`2I001Vo`1Vc2/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`0c<`0c0000o`00c000V@00IP00<nh002l_;fi^KZf][Nc/k03o05Go0:[o0?oo0140
003^003M002k002Z0028001g001E03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@00M`00E@00A0008P00
4Nk^k]gMgK^k^cLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l0;0000?l0;0000?l0;0000?l0;0000?l0
;0000?l0;0000<P00omP0000b`000ol0001M0000b`000ol0001M0000b003of0000380003o`000600
003800CoG`000?l0;0000?l0;0000?l0;0000?l0;0000<d00_mL0000bP03o`030?l005/0003800;o
0`03oe/0003500?o0P03o`04Jol0oeX0003300;o0`02o`043e@?E0?oFP000<000ol00`3oo`02o`08
cV_>Jli[of/2oeT0002m00?o0P03o`0>E0mD3e@?E0mDoeCo0?mH0000^`02o`<00_l03li[cV_>Jli[
cV_>Jom[cP02oeP0002h00?o0P03o`0B3e@?E0mD3e@?E0mD3eCoE0mD0_mG0000U`03oa`00_l200?o
01Q[cV_>Jli[cV_>Jli[cV_>Jom[cV_o0?mF0000V0000ol0000H00?o0P03o`0HE0mD3e@?E0mD3e@?
E0mD3e@?E?mD3e@?0_mF0000UP04oaL00_l200?o01c>Jli[cV_>Jli[cV_>Jli[cV_>Jli[of_>Jli[
0_l600CoB`0009H000?o0?l05@03o`800_l07e@?E0mD3e@?E0mD3e@?E0mD3e@?E0mD3e@?o`mD3e@0
0_l70003o`0004/0002F0003o`3o01<00_l200?o029[cV_>Jli[cV_>Jli[cV_>Jli[cV_>Jli[cV_>
oli[cV_>0_l70003o`0004X0002G00;o4003o`800_l09PmD3e@?E0mD3e@?E0mD3e@?E0mD3e@?E0mD
3e@?E0oo3e@?E0mD0_l70003o`0004T0002W00;o0P03o`0XcV_>Jli[cV_>Jli[cV_>Jli[cV_>Jli[
cV_>Jli[cV_>oli[cV_>J`;o10001?l00?m;0000Y004o`0_0?ooE0mD3e@?E0mD3e@?E0mD3e@?E0mD
3e@?E0mD3e@?E0mD3e@?o`mD3e@?E0l00_l400;oC0000:400ol200?o02i[cV_>Jli[cV_>Jli[cV_>
Jli[cV_>Jli[cV_>Jli[cV_>Jli[c_o>Jli[cV_>0omA0000W`02o`800ol0;PmD3e@?E0mD3e@?E0mD
3e@?E0mD3e@?E0mD3e@?E0mD3e@?E0mD3e@?o`mD3e@3o`03E?oo0540002L00?o0P02o`0^Jli[cV_>
Jli[cV_>Jli[cV_>Jli[cV_>Jli[cV_>Jli[cV_>Jli[cV_>JlkocP?o00G>Jli[cP02oe00002J00;o
00<0ool00_l0;U@?E0mD3e@?E0mD3e@?E0mD3e@?E0mD3e@?E0mD3e@?E0mD3e@?E0mD3e@?E0l2o`09
E0mD3e@?E0mD00;oC`0009L00ol200?o02e[cV_>Jli[cV_>Jli[cV_>Jli[cV_>Jli[cV_>Jli[cV_>
Jli[cV_>Jli[cV/01?l02/i[cV_>Jli[cV/2odl0002E00;o0P03o`0]3ol?E0mD3e@?E0mD3e@?E0mD
3e@?E0mD3e@?E0mD3e@?E0mD3e@?E0mD3e@?00?o00l?E0oo3e@?E0mD3e@?E0l00_m>0000TP03o`80
0_l0;V_>Jli[of_>Jli[cV_>Jli[cV_>Jli[cV_>Jli[cV_>Jli[cV_>Jli[cV_>Jlh2o`0CJli[cV_>
oli[cV_>Jli[cV_>J`02odd0002@00;o0P03o`0]E0mD3e@?E0oo3e@?E0mD3e@?E0mD3e@?E0mD3e@?
E0mD3e@?E0mD3e@?E0mD00?o01ED3e@?E0mD3ol?E0mD3e@?E0mD3e@00_m=0000S@03o`0a0?oooli[
cV_>Jli[cV_>Jom[cV_>Jli[cV_>Jli[cV_>Jli[cV_>Jli[cV_>Jli[cP03o`0IcV_>Jli[cV_>Jlko
cV_>Jli[cV_>Jli[cP02od`0002;00;o0P02o`0^E0mD3e@?E0mD3e@?E0mD3ol?E0mD3e@?E0mD3e@?
E0mD3e@?E0mD3e@?E0mD3`;o01eD3e@?E0mD3e@?E0mD3ol?E0mD3e@?E0mD3e@?E002od/0001X00?o
7@07o`0]Jli[cV_>Jli[cV_>Jli[cV_>oli[cV_>Jli[cV_>Jli[cV_>Jli[cV_>Jli[00?o01m[cV_>
Jli[cV_>Jli[cV_>oli[cV_>Jli[cV_>Jli[00;oB`0006/000?o00006002o`800_l0;@mD3e@?E0mD
3e@?E0mD3e@?E0mD3eCoE0mD3e@?E0mD3e@?E0mD3e@?E0mD3`03o`0S3e@?E0mD3e@?E0mD3e@?E0mD
3ol?E0mD3e@?E0mD3e@?E0l00_m:0000J`000ol0000E00?o0340oooocV_>Jli[cV_>Jli[cV_>Jli[
cV_>Jli[c_o>Jli[cV_>Jli[cV_>Jli[cV_>00;o02M[cV_>Jli[cV_>Jli[cV_>Jli[cV_>oli[cV_>
Jli[cV_>Jli[cV/00_m90000J@02oaD00ol200;o02eD3e@?E0mD3e@?E0mD3e@?E0mD3e@?E0mD3e@?
E?mD3e@?E0mD3e@?E0mD3e@00ol0:E@?E0mD3e@?E0mD3e@?E0mD3e@?E0mD3ol?E0mD3e@?E0mD3e@?
E0mD00;oB@0006/000?o00004002o`800ol0;6_>Jli[cV_>Jli[cV_>Jli[cV_>Jli[cV_>Jli[cV_o
Jli[cV_>Jli[cV_>0ol0;Li[cV_>Jli[cV_>Jli[cV_>Jli[cV_>Jli[c_o>Jli[cV_>Jli[cV_>Jli[
cP02odP0001X00?o4003o`800_l0;@mD3e@?E0mD3e@?E0mD3e@?E0mD3e@?E0mD3e@?E0mD3e@?o`mD
3e@?E0mD3`02o`0`E0mD3e@?E0mD3e@?E0mD3e@?E0mD3e@?E0mD3e@?o`mD3e@?E0mD3e@?E0mD3e@?
0_m80000N@02o`800ol0;<i[cV_>Jli[cV_>Jli[cV_>Jli[cV_>Jli[cV_>Jli[cV_>Jli[of_>Jli[
0ol0;f_>Jli[cV_>Jli[cV_>Jli[cV_>Jli[cV_>Jli[cV_>oli[cV_>Jli[cV_>Jli[00?o00=Kool0
A`0007H01ol0;5@?E0mD3e@?E0mD3e@?E0mD3e@?E0mD3e@?E0mD3e@?E0mD3e@?E0mD3ol?0ol0;`mD
3e@?E0mD3e@?E0mD3e@?E0mD3e@?E0mD3e@?E0mD3e@?E?mD3e@?E0mD3e@?00?o00EKE5]DF`02odH0
001d00;o0P02o`0]cV_>Jli[cV_>Jli[cV_>Jli[cV_>Jli[cV_>Jli[cV_>Jli[cV_>Jli[cV_>00;o
02m[cV_>Jli[cV_>Jli[cV_>Jli[cV_>Jli[cV_>Jli[cV_>Jli[cV_oJli[cV_>J`03o`0:FliKcU_>
FliKodH0001a00?o0300oooo3e@?E0mD3e@?E0mD3e@?E0mD3e@?E0mD3e@?E0mD3e@?E0mD3e@?E0mD
3e@3o`0_E?mD3e@?E0mD3e@?E0mD3e@?E0mD3e@?E0mD3e@?E0mD3e@?E0mD3eCoE0mD3e@00_l035]D
FeAKE5]DFeAKE0;oA@0006l00_l200;o02a[cV_>Jli[cV_>Jli[cV_>Jli[cV_>Jli[cV_>Jli[cV_>
Jli[cV_>Jli[cP?o02o>FliKc_o>Jli[cV_>Jli[cV_>Jli[cV_>Jli[cV_>Jli[cV_>Jli[cV_>Jom[
cP03o`0?cU_>FliKcU_>FliKcU_>00;oA00006`00ol0<03ooomD3e@?E0mD3e@?E0mD3e@?E0mD3e@?
E0mD3e@?E0mD3e@?E0mD3e@?E0mD3`;o02mDFeAKE5]DFeCoE0mD3e@?E0mD3e@?E0mD3e@?E0mD3e@?
E0mD3e@?E0mD3e@?E003o`0DE5]DFeAKE5]DFeAKE5]DFeAKE?m40000JP02o`800_l0;<i[cV_>Jli[
cV_>Jli[cV_>Jli[cV_>Jli[cV_>Jli[cV_>Jli[cV_>Jli[0ol0;U_>FliKcU_>FliKc_o>Jli[cV_>
Jli[cV_>Jli[cV_>Jli[cV_>Jli[cV_>Jlh4o`0EFliKcU_>FliKcU_>FliKcU_>FliK00;o@`0006L0
0ol0;`3ooomKo`mD3e@?E0mD3e@?E0mD3e@?E0mD3e@?E0mD3e@?E0mD3e@?E0mD3e@?00?o02iKE5]D
FeAKE5]DFeAKE5]Doe@?E0mD3e@?E0mD3e@?E0mD3e@?E0mD3e@?E0mD0ol06UAKE?mDFeAKE5]DFeAK
E5]DFeAKE5]DFeAK0_l700?o>00006@01ol0;5_>FliKof_>Jli[cV_>Jli[cV_>Jli[cV_>Jli[cV_>
Jli[cV_>Jli[cV_>0_l0;e_>FliKcU_>FliKcU_>FliKcU_oJli[cV_>Jli[cV_>Jli[cV_>Jli[cV_>
Jli[00;o01g>FliKcU_oFliKcU_>FliKcU_>FliKcU_>FliKcP02o`P000?o0000=`0006800_l200;o
02aKE5]DFeAKE5_o3e@?E0mD3e@?E0mD3e@?E0mD3e@?E0mD3e@?E0mD3e@?E0?o02iDFeAKE5]DFeAK
E5]DFeAKE5]DFeAKo`mD3e@?E0mD3e@?E0mD3e@?E0mD3e@?0ol085]DFeAKE5]DoeAKE5]DFeAKE5]D
FeAKE5]DFeAKE5]D0_l500Co>00005l00ol0;`3oooo>FliKcU_>FliKcU_oJli[cV_>Jli[cV_>Jli[
cV_>Jli[cV_>Jli[cV_>00?o02k>FliKcU_>FliKcU_>FliKcU_>FliKcU_>Fom[cV_>Jli[cV_>Jli[
cV_>Jli[0ol095_>FliKcU_>FliKoe_>FliKcU_>FliKcU_>FliKcU_>FliKcP;o10000ol0o`0i0000
?@04oa`00_l0<03ooomDFeAKE5]DFeAKE5]DFeAKo`mD3e@?E0mD3e@?E0mD3e@?E0mD3e@?E0mD3`;o
02iDFeAKE5]DFeAKE5]DFeAKE5]DFeAKE5]DFeAKE5_o3e@?E0mD3e@?E0mD3e@?0ol09e]DFeAKE5]D
FeAKE5]DoeAKE5]DFeAKE5]DFeAKE5]DFeAKE5]DF`02o`@000?o0?l0>@0003h000?o00006@03o`0_
0?oocU_>FliKcU_>FliKcU_>FliKcU_oJli[cV_>Jli[cV_>Jli[cV_>Jli[cV/00ol0;U_>FliKcU_>
FliKcU_>FliKcU_>FliKcU_>FliKcU_>oli[cV_>Jli[cV_>Jlh2o`0[FliKcU_>FliKcU_>FliKcU_o
FliKcU_>FliKcU_>FliKcU_>FliKcU_>F`02o`@00_li0000?`000ol0000F00;o0300ooooFeAKE5]D
FeAKE5]DFeAKE5]DFeAKE5_o3e@?E0mD3e@?E0mD3e@?E0mD3e@2o`0^FeAKE5]DFeAKE5]DFeAKE5]D
FeAKE5]DFeAKE5]DFeAKE5]Doe@?E0mD3e@?E0?o02eDFeAKE5]DFeAKE5]DFeAKE5]DoeAKE5]DFeAK
E5]DFeAKE5]DFeAKE5]DFe@00oln0000@0000ol0000B00Ko02aKcU_>FliKcU_>FliKcU_>FliKcU_>
FliKcU_oJli[cV_>Jli[cV_>Jli[cP?o02g>FliKcU_>FliKcU_>FliKcU_>FliKcU_>FliKcU_>FliK
cU_>FlkocV_>Jlh00ol0;LiKcU_>FliKcU_>FliKcU_>FliKcU_oFliKcU_>FliKcU_>FliKcU_>FliK
cP03o`03c_oo03h0000m0004o`00oa801Ol0;5]DFeAKE5]DFeAKE5]DFeAKE5]DFeAKE5]DFeAKE5_o
3e@?E0mD3e@?E0mD0ol0;EAKE5]DFeAKE5]DFeAKE5]DFeAKE5]DFeAKE5]DFeAKE5]DFeAKE5]DFeCo
E003o`0]E5]DFeAKE5]DFeAKE5]DFeAKE5]DFeAKE?mDFeAKE5]DFeAKE5]DFeAKE5]D00?o00EDBeA;
E002ocd0000n00;o4005o`0]FliKcU_>FliKcU_>FliKcU_>FliKcU_>FliKcU_>FliKcU_oJli[cV_>
Jli[00;o02k>FliKcU_>FliKcU_>FliKcU_>FliKcU_>FliKcU_>FliKcU_>FliKcU_>FliK0_l0;/iK
cU_>FliKcU_>FliKcU_>FliKcU_>FliKcU_oFliKcU_>FliKcU_>FliKcU/2o`09cR_>:lh[cR_>00;o
?00004h01Ol0;5AKE5]DFeAKE5]DFeAKE5]DFeAKE5]DFeAKE5]DFeAKE5]DFeAKo`mD3e@?0ol0;E]D
FeAKE5]DFeAKE5]DFeAKE5]DFeAKE5]DFeAKE5]DFeAKE5]DFeAKE5]DF`03o`0]FomKE5]DFeAKE5]D
FeAKE5]DFeAKE5]DFeAKE5]DoeAKE5]DFeAKE5]DFeAK00?o00];E4]DBeA;E4]DB`02oc`0001;00Go
02c>FliKcU_>FliKcU_>FliKcU_>FliKcU_>FliKcU_>FliKcU_>FliKcU_oJ`?o02iKcU_>FliKcU_>
FliKcU_>FliKcU_>FliKcU_>FliKcU_>FliKcU_>FliKcU_>0_l0;C_>>lhkoe_>FliKcU_>FliKcU_>
FliKcU_>FliKcU_>FomKcU_>FliKcU_>F`03o`0?:lh[cR_>:lh[cR_>:lh[00;o>`0004P01Ol0;EAK
E5]DFeAKE5]DFeAKE5]DFeAKE5]DFeAKE5]DFeAKE5]DFeAKE5]DFeAKE002o`0^FeAKE5]DFeAKE5]D
FeAKE5]DFeAKE5]DFeAKE5]DFeAKE5]DFeAKE5]DFeAKE0?o02aDFeAKE5]DFomKE5]DFeAKE5]DFeAK
E5]DFeAKE5]DFeAKE?mDFeAKE5]DF`?o01A;E4]DBeA;E4]DBeA;E4]DBeA;oc/0001600Go02aKcU_>
FliKcU_>FliKcU_>FliKcU_>FliKcU_>FliKcU_>FliKcU_>FliKcP?o02g>oliKcU_>FliKcU_>FliK
cU_>FliKcU_>FliKcU_>FliKcU_>FliKcU_>Flh00ol0;LhkcS_>>lhkcS_>>omKcU_>FliKcU_>FliK
cU_>FliKcU_>FliKoe_>FliKcP02o`0F:lh[cR_>:lh[cR_>:lh[cR_>:lh[cP;o>P0004<01Ol0;E]D
FeAKE5]DFeAKE5]DFeAKE5]DFeAKE5]DFeAKE5]DFeAKE5]DFeAKE5]DF`02o`0^E5]DFeCoE5]DFeAK
E5]DFeAKE5]DFeAKE5]DFeAKE5]DFeAKE5]DFeAKE5]DF`;o02eDFeAKE5]DFeAKE5]DFeCoE5]DFeAK
E5]DFeAKE5]DFeAKE5]DFeAKE?mDFe@00ol06EA;E4]DBeA;E4]DBeA;E4]DBeA;E4]DBe@00_li0000
@@04o`0]FomKcU_>FliKcU_>FliKcU_>FliKcU_>FliKcU_>FliKcU_>FliKcU_>FliK00?o02e;cT_>
Bli;c_o>FliKcU_>FliKcU_>FliKcU_>FliKcU_>FliKcU_>FliKcU/00ol0:c_>>lhkcS_>>lhkcS_>
>lhkc_o>FliKcU_>FliKcU_>FliKcU_>FliKcU/01?l07<h[cR_>:lh[cR_>:lh[cR_>:lh[cR_>:lh[
cR/2ocT0000n00Go02eDoeAKE5]DFeAKE5]DFeAKE5]DFeAKE5]DFeAKE5]DFeAKE5]DFeAKE5]DFe@0
0_l0;U]DFeAKE5]DFeAKE?mDFeAKE5]DFeAKE5]DFeAKE5]DFeAKE5]DFeAKE5]DFe@2o`0]FeAKE5]D
FeAKE5]DFeAKE5]DFeAKE?mDFeAKE5]DFeAKE5]DFeAKE5]DFeAK00;o021DBeA;E4]DBeA;E4]DBeA;
E4]DBeA;E4]DBeA;E4]DB`;o>00003`01?l0;LiKcU_>oliKcU_>FliKcU_>FliKcU_>FliKcU_>FliK
cU_>FliKcU_>FliKcP03o`0]cT_>Bli;cT_>Bli;cT_>oliKcU_>FliKcU_>FliKcU_>FliKcU_>FliK
cU_>00?o02c>>lhkcS_>>lhkcS_>>lhkcS_>>lhkcS_oFliKcU_>FliKcU_>FliKcU_>F`?o02<[c_o>
:lh[cR_>:lh[cR_>:lh[cR_>:lh[cR_>:lh[cR_>:`02ocL0000i00Go02eKE5]DFeAKE?mDFeAKE5]D
FeAKE5]DFeAKE5]DFeAKE5]DFeAKE5]DFeAKE5/00_l0;EAKE5]DFeAKE5]DFeAKE5]DFeCoE5]DFeAK
E5]DFeAKE5]DFeAKE5]DFeAKE003o`0/E5]DFeAKE5]DFeAKE5]DFeAKE5]DFeAKE5]DFomKE5]DFeAK
E5]DFeAKE5/3o`0VBeA;E4_oBeA;E4]DBeA;E4]DBeA;E4]DBeA;E4]DBeA;E4]DBe@3ocH0000g00Go
02c>FliKcU_>FliKc_o>FliKcU_>FliKcU_>FliKcU_>FliKcU_>FliKcU_>F`?o02e;cT_>Bli;cT_>
Bli;cT_>Bli;cT_>oliKcU_>FliKcU_>FliKcU_>FliKcU/00_l0;<hkcS_>>lhkcS_>>lhkcS_>>lhk
cS_>>lhkcS_>>lhkoe_>FliKcU_>FliK0ol0:R_>:lh[cR_>olh[cR_>:lh[cR_>:lh[cR_>:lh[cR_>
:lh[cR_>:lh[cP;o=P0003@01Ol0;EAKE5]DFeAKE5]DFeAKE?mDFeAKE5]DFeAKE5]DFeAKE5]DFeAK
E5]DFeAKE002o`0]FeAKE5]DFeAKE5]DFeAKE5]DFeAKE5]DFomKE5]DFeAKE5]DFeAKE5]DFeAK00?o
02aKE5]DFeAKE5]DFeAKE5]DFeAKE5]DFeAKE5]DFeAKE5]DFomKE5]DFeAKE0;o02e;E4]DBeA;E4]D
Bom;E4]DBeA;E4]DBeA;E4]DBeA;E4]DBeA;E4]DBeA;E4/00ole00005003oa/00_l0<03ooe_>FliK
cU_>FliKcU_>FliKc_o>FliKcU_>FliKcU_>FliKcU_>FliKcU_>F`;o02g>Bli;cT_>Bli;cT_>Bli;
cT_>Bli;cT_>Bli;oe_>FliKcU_>FliKcU_>Flh00_l0;3_>>lhkcS_>>lhkcS_>>lhkcS_>>lhkcS_>
>lhkcS_>>lhkcS_>oliKcU_>0ol0;<h[cR_>:lh[cR_>:lkocR_>:lh[cR_>:lh[cR_>:lh[cR_>:lh[
cR_>:lh[0ol00n[oo`0e00005@000ol0000G00Ko02aDFeAKE5]DFeAKE5]DFeAKE5]DFeCoE5]DFeAK
E5]DFeAKE5]DFeAKE5]DF`?o02aKE5]DFeAKE5]DFeAKE5]DFeAKE5]DFeAKE5]DFeAKoe]DFeAKE5]D
FeAKE0?o02]DFeAKE5]DFeAKE5]DFeAKE5]DFeAKE5]DFeAKE5]DFeAKE5]DFeAKE?mD00?o02eDBeA;
E4]DBeA;E4]DBeA;od]DBeA;E4]DBeA;E4]DBeA;E4]DBeA;E4]DBe@00_l01N[>j/kZ00;o=00001D0
00?o00005@02o`0`0?oocU_>FliKcU_>FliKcU_>FliKcU_>FliKc_o>FliKcU_>FliKcU_>FliKcU_>
0_l0;4_>Bli;cT_>Bli;cT_>Bli;cT_>Bli;cT_>Bli;cT_>Bli;oe_>FliKcU_>0ol0;<hkcS_>>lhk
cS_>>lhkcS_>>lhkcS_>>lhkcS_>>lhkcS_>>lhkcS_>>lhk0_l0;Lh[cR_>:lh[cR_>:lh[cR_>:lko
cR_>:lh[cR_>:lh[cR_>:lh[cR_>:lh[cP03o`08c^[>j/kZc^X2oc<0000E0003o`0001801_l0;5]D
FeAKE5]DFeAKE5]DFeAKE5]DFeAKE5]DFeCoE5]DFeAKE5]DFeAKE5]D0ol0;5AKE5]DFeAKE5]DFeAK
E5]DFeAKE5]DFeAKE5]DFeAKE5]DFeAKoe]DFeAK0_l0;5AKE5]DFeAKE5]DFeAKE5]DFeAKE5]DFeAK
E5]DFeAKE5]DFeAKE5]DFeAK0ol0;C_oBeA;E4]DBeA;E4]DBeA;E4]DBom;E4]DBeA;E4]DBeA;E4]D
BeA;E4]DB`02o`0;c^[>j/kZc^[>j/h00_lc00005@000ol0000?00?o0300oooocU_>FliKcU_>FliK
cU_>FliKcU_>FliKcU_>FliKc_o>FliKcU_>FliKcU/2o`0/cT_>Bli;cT_>Bli;cT_>Bli;cT_>Bli;
cT_>Bli;cT_>Bli;cT_>Bli;oe/3o`0/>lhkcS_>>lhkcS_>>lhkcS_>>lhkcS_>>lhkcS_>>lhkcS_>
>lhkcS_>>lh2o`0]c_[>n/ko:lh[cR_>:lh[cR_>:lh[cR_>olh[cR_>:lh[cR_>:lh[cR_>:lh[00?o
00kZc^[>j/kZc^[>j/kZcP;o<P0001@00_l?00;o0P02o`0/E5]DFeAKE5]DFeAKE5]DFeAKE5]DFeAK
E5]DFeAKE5]DFeCoE5]DFeAKE5/3o`0/FeAKE5]DFeAKE5]DFeAKE5]DFeAKE5]DFeAKE5]DFeAKE5]D
FeAKE5]DFe@2o`0/FeAKE5]DFeAKE5]DFeAKE5]DFeAKE5]DFeAKE5]DFeAKE5]DFeAKE5]DFe@3o`0]
cS_>>lhkcS_oBeA;E4]DBeA;E4]DBeA;E4_oBeA;E4]DBeA;E4]DBeA;E4]D00;o01CZc^[>j/kZc^[>
j/kZc^[>j_l0oc40000R00Co02l0oomKcU_>FliKcU_>FliKcU_>FliKcU_>FliKcU_>FliKcU_>FliK
c_o>FliKcP02o`0/Bli;cT_>Bli;cT_>Bli;cT_>Bli;cT_>Bli;cT_>Bli;cT_>Bli;cT_>Blh3o`0[
c_o>>lhkcS_>>lhkcS_>>lhkcS_>>lhkcS_>>lhkcS_>>lhkcS_>>lhkcP03o`0Ln/kjc_[>n/kjc_[o
cR_>:lh[cR_>:lh[cR_>:`;o00o>:lh[cR_>:lh[cR_>:lh00ol05<kZc^[>j/kZc^[>j/kZc^[>j/kZ
0_l800;o9`0002000_l200?o02]DFeAKE5]DFeAKE5]DFeAKE5]DFeAKE5]DFeAKE5]DFeAKE5]DFeAK
E?mD00?o02]DFeAKE5]DFeAKE5]DFeAKE5]DFeAKE5]DFeAKE5]DFeAKE5]DFeAKE5]D00?o02aDBeA;
E?mDFeAKE5]DFeAKE5]DFeAKE5]DFeAKE5]DFeAKE5]DFeAKE5]DF`;o01c>>lhkcS_>>lhkcS_>>lko
E4]DBeA;E4]DBeA;0ol03d_oBeA;E4]DBeA;E4]DB`02o`0Hc^[>j/kZc^[>j/kZc^[>j/kZc^[>j/kZ
0_l60004o`00obH0000M00?o0P02o`0/cU_>FliKcU_>FliKcU_>FliKcU_>FliKcU_>FliKcU_>FliK
cU_>FliKcU/2o`0/cT_>Bli;cT_>Bli;cT_>Bli;cT_>Bli;cT_>Bli;cT_>Bli;cT_>Bli;cT/2o`0/
cS_>>lhkcS_>olhkcS_>>lhkcS_>>lhkcS_>>lhkcS_>>lhkcS_>>lhkcS/3o`0Kc_[>n/kjc_[>n/kj
c_[>n/kjolh[cR_>:lh[00?o00l[cR_>:ol[cR_>:lh[cR/00ol06^[>j/kZc^[>j/kZc^[>j/kZc^[>
j/kZc^[>0_l60004o`00obH0000L00;o0P02o`0[FeAKE5]DFeAKE5]DFeAKE5]DFeAKE5]DFeAKE5]D
FeAKE5]DFeAKE5]DF`03o`0[FomKE5]DFeAKE5]DFeAKE5]DFeAKE5]DFeAKE5]DFeAKE5]DFeAKE5]D
F`03o`0/BeA;E4]DBeA;E4]DoeAKE5]DFeAKE5]DFeAKE5]DFeAKE5]DFeAKE5]DFe@2o`0K>lhkcS_>
>lhkcS_>>lhkcS_>>lhkod]DBeA;00?o011;E4]DBeA;E4_oBeA;E4]D0_l07^[>j/kZc^[>j/kZc^[>
j/kZc^[>j/kZc^[>j/kZcP;o1@03obL0000L00Co02[>FliKcU_>FliKcU_>FliKcU_>FliKcU_>FliK
cU_>FliKcU_>FliKcU/3o`0/FliKcU_oBli;cT_>Bli;cT_>Bli;cT_>Bli;cT_>Bli;cT_>Bli;cT_>
Blh2o`0/>lhkcS_>>lhkcS_>>lhkoc_>>lhkcS_>>lhkcS_>>lhkcS_>>lhkcS_>>lh3o`0Jn/kjc_[>
n/kjc_[>n/kjc_[>n/kjc_[>ob/3o`0@:lh[cR_>:lh[cR_>:ol[cP?o023>j/kZc^[>j/kZc^[>j/kZ
c^[>j/kZc^[>j/kZc^[>jP?o10000ol0000W00005002o`H00_l0:U]DFeAKE5]DFeAKE5]DFeAKE5]D
FeAKE5]DFeAKE5]DFeAKE5]DFeAKE0;o02aKE5]DFeAKE5_oFeAKE5]DFeAKE5]DFeAKE5]DFeAKE5]D
FeAKE5]DFeAKE0?o02]DBeA;E4]DBeA;E4]DBeA;E4_oFeAKE5]DFeAKE5]DFeAKE5]DFeAKE5]D00?o
01[>>lhkcS_>>lhkcS_>>lhkcS_>>lhkcS_>>`?o011;E4]DBeA;E4]DBeA;E4]D0ol09<kZc^[>j/kZ
c^[>j/kZc^[>j/kZc^[>j/kZc^[>j/kZc^[>jP;o1@03obH0000C0004o`00o`D002Wo0?mKcU_>FliK
cU_>FliKcU_>FliKcU_>FliKcU_>FliKcU_>FliKcP03o`0[cU_>FliKcU_>FliKod_>Bli;cT_>Bli;
cT_>Bli;cT_>Bli;cT_>Bli;cP03o`0/cS_>>lhkcS_>>lhkcS_>>lhkcS_>>olkcS_>>lhkcS_>>lhk
cS_>>lhkcS/2o`0Jn/kjc_[>n/kjc_[>n/kjc_[>n/kjc_[>n/h3o`0Ac_[ocR_>:lh[cR_>:lh[cR/0
1?l09/kZc^[>j/kZc^[>j/kZc^[>j/kZc^[>j/kZc^[>j/kZc^[>j/kZ0_l]00004`001?l00?l4000W
o`000?mKE5]DFeAKE5]DFeAKE5]DFeAKE5]DFeAKE5]DFeAKE5]D00?o02aDFeAKE5]DFeAKE5]DFeAK
oe]DFeAKE5]DFeAKE5]DFeAKE5]DFeAKE5]DF`;o02aDBeA;E4]DBeA;E4]DBeA;E4]DBeA;E4]DoeAK
E5]DFeAKE5]DFeAKE5]DF`?o01XkcS_>>lhkcS_>>lhkcS_>>lhkcS_>>lhkcP;o018kcS_>>lkoE4]D
BeA;E4]DBe@2o`0]j/kZc_o>j/kZc^[>j/kZc^[>j/kZc^[>j/kZc^[>j/kZc^[>j/kZc^[>o`3o02`0
000C0004o`00o`@00_l3000Poe_>FliKcU_>FliKcU_>FliKcU_>FliKcU_>FliKcU/2o`0/cU_>FliK
cU_>FliKcU_>FliKcU_oBli;cT_>Bli;cT_>Bli;cT_>Bli;cT/3o`0/>lhkcS_>>lhkcS_>>lhkcS_>
>lhkcS_>>lhkc_o>>lhkcS_>>lhkcS_>>lh2o`0Jc_[>n/kjc_[>n/kjc_[>n/kjc_[>n/kjc_X3o`0A
n/kjc_[>n/kjolh[cR_>:lh00ol0;<kZc^[>j_oZc^[>j/kZc^[>j/kZc^[>j/kZc^[>j/kZc^[>j/kZ
c^[>j/kZ0ol/00004`001?l00?l40003o`0000<001coFeAKE5]DFeAKE5]DFeAKE5]DFeAKE5]DFeAK
0ol0:e]DFeAKE5]DFeAKE5]DFeAKE5]DFeAKoe]DFeAKE5]DFeAKE5]DFeAKE5/00ol0;4]DBeA;E4]D
BeA;E4]DBeA;E4]DBeA;E4]DBeA;E4]DoeAKE5]DFeAKE5]D0ol06LhkcS_>>lhkcS_>>lhkcS_>>lhk
cS_>>lh00ol04/hkcS_>>lhkcS_>>om;E4]DB`;o02c>j/kZc^[>j/kZon[>j/kZc^[>j/kZc^[>j/kZ
c^[>j/kZc^[>j/kZc^[>jP?o00@bo`3o:`0001@00_l50003o`0000@001SoFliKcU_>FliKcU_>FliK
cU_>FliKcU/3o`0/FliKcU_>FliKcU_>FliKcU_>FliKcU_>FliKod_>Bli;cT_>Bli;cT_>Blh2o`0/
>lhkcS_>>lhkcS_>>lhkcS_>>lhkcS_>>lhkcS_>>lhkcS_>olhkcS_>>lh3o`0In/kjc_[>n/kjc_[>
n/kjc_[>n/kjc_[>nP03o`0Bn/kjc_[>n/kjc_[>n/kjc_l[0ol0;>[>j/kZc^[>j/kZc^[oj/kZc^[>
j/kZc^[>j/kZc^[>j/kZc^[>j/kZc^[>0_l021]E6eDKo`3o:P0001/000?o00001@005OmKE5]DFeAK
E5]DFeAKE5]DFeAKE002o`0/FeAKE5]DFeAKE5]DFeAKE5]DFeAKE5]DFeAKE5]DFomKE5]DFeAKE5]D
Fe@3o`0/E4]DBeA;E4]DBeA;E4]DBeA;E4]DBeA;E4]DBeA;E4]DBeA;E4_oFeAKE5/2o`0IcS_>>lhk
cS_>>lhkcS_>>lhkcS_>>lhkcP03o`0CcS_>>lhkcS_>>lhkcS_>>lhkcP02o`0]j/kZc^[>j/kZc^[>
j/kZc^[oj/kZc^[>j/kZc^[>j/kZc^[>j/kZc^[>j/kZ00;o00MD<U@bE39D00?o:P0001X00_l8000A
oe_>FliKcU_>FliKcU_>Flh00ol0;<iKcU_>FliKcU_>FliKcU_>FliKcU_>FliKcU_>FliKcU_oBli;
cT_>Bli;0_l0;<hkcS_>>lhkcS_>>lhkcS_>>lhkcS_>>lhkcS_>>lhkcS_>>lhkcS_>>olk0ol06<kj
c_[>n/kjc_[>n/kjc_[>n/kjc_[>nP?o01?jc_[>n/kjc_[>n/kjc_[>n/kj00?o02c>olkZc^[>j/kZ
c^[>j/kZc^[>olkZc^[>j/kZc^[>j/kZc^[>j/kZc^[>jP?o00XKEA]E6eDKEA_o0P000ol0000W0000
6`000ol00007000=oe]DFeAKE5]DFeAKE003o`0/E5]DFeAKE5]DFeAKE5]DFeAKE5]DFeAKE5]DFeAK
E5]DFeAKE5_oFeAKE5/3o`0/BeA;E4]DBeA;E4]DBeA;E4]DBeA;E4]DBeA;E4]DBeA;E4]DBeA;E4]D
Be@2o`0I>lhkcS_>>lhkcS_>>lhkcS_>>lhkcS_>>`02o`0CcS_>>lhkcS_>>lhkcS_>>lhkcP03o`0]
c^[>j/koc^[>j/kZc^[>j/kZc^[>j/koc^[>j/kZc^[>j/kZc^[>j/kZc^[>00;o00hbE39D<U@bE39D
<U@bo`8000?o00009P0001X000?o00002@002_mKcU_>FliKcU/2o`0/cU_>FliKcU_>FliKcU_>FliK
cU_>FliKcU_>FliKcU_>FliKcU_>FliKod/3o`0/>lhkcS_>>lhkcS_>>lhkcS_>>lhkcS_>>lhkcS_>
>lhkcS_>>lhkcS_>>lh3o`0Hc_ojc_[>n/kjc_[>n/kjc_[>n/kjc_[>0ol04lkjc_[>n/kjc_[>n/kj
c_[>n/h00_l0;/kZc^[>j/kZon[>j/kZc^[>j/kZc^[>j/kZc_o>j/kZc^[>j/kZc^[>j/kZc^X2o`0@
EA]E6eDKEA]E6eDKEA]Eo`8000?o00009P0001X000?o00002P001_mKE5]DF`?o02aKE5]DFeAKE5]D
FeAKE5]DFeAKE5]DFeAKE5]DFeAKE5]DFeAKE5]DFeAKE0;o02a;E4]DBeA;E4]DBeA;E4]DBeA;E4]D
BeA;E4]DBeA;E4]DBeA;E4]DBeA;E0?o01QD>e@kE?o>>lhkcS_>>lhkcS_>>lhkcS/3o`0C>lhkcS_>
>lhkcS_>>lhkcS_>>`03o`0]j/kZc^[>j/kZc^[oj/kZc^[>j/kZc^[>j/kZc^[>olkZc^[>j/kZc^[>
j/kZ00?o01<bE39D<U@bE39D<U@bE39D<UCo008000?o00009@0001X00_l<0003oe_o00;o02aKcU_>
FliKcU_>FliKcU_>FliKcU_>FliKcU_>FliKcU_>FliKcU_>FliKcP?o02_>olhkcS_>>lhkcS_>>lhk
cS_>>lhkcS_>>lhkcS_>>lhkcS_>>lhkcS_>00?o01S>>lhkcS_>>lkon/kjc_[>n/kjc_[>n/h3o`0C
c_[>n/kjc_[>n/kjc_[>n/kjcP03o`0^j/kZc^[>j/kZc^[>j/kZon[>j/kZc^[>j/kZc^[>j/kZon[>
j/kZc^[>j/kZcP;o01HKEA]E6eDKEA]E6eDKEA]E6eDKEA_o0`000ol0000T00006P000ol0000<000]
oe]DFeAKE5]DFeAKE5]DFeAKE5]DFeAKE5]DFeAKE5]DFeAKE5]DFeAKE5]D00?o02aDFeAKE?mDBeA;
E4]DBeA;E4]DBeA;E4]DBeA;E4]DBeA;E4]DBeA;E4]DB`;o01QD>e@kE3]D>e@kE3]DolhkcS_>>lhk
cS/3o`0D>lhkcS_>>lhkcS_>>lhkcS_>>lh2o`0^j/kZc^[>j/kZc^[>j/kZc^[>olkZc^[>j/kZc^[>
j/kZc^[>j_oZc^[>j/kZcP?o01YD<U@bE39D<U@bE39D<U@bE39D<U@bE3;o00;o9P0001X000?o0000
3@00:OmKcU_>FliKcU_>FliKcU_>FliKcU_>FliKcU_>FliKcU_>FliKcU_>00?o02c>FliKcU_>Flko
cS_>>lhkcS_>>lhkcS_>>lhkcS_>>lhkcS_>>lhkcS_>>`?o01LkcS_>>lhkcS_>>lhkcS_>oo[>n/kj
cP03o`0Dc_[>n/kjc_[>n/kjc_[>n/kjc_X3o`0^c^[>j/kZc^[>j/kZc^[>j/kZc^[>olkZc^[>j/kZ
c^[>j/kZc^[>j_oZc^[>jP;o01aE6eDKEA]E6eDKEA]E6eDKEA]E6eDKEA]E6eGo0`000ol0000S0000
6P000ol0000>000Uoe]DFeAKE5]DFeAKE5]DFeAKE5]DFeAKE5]DFeAKE5]DFeAKE003o`0/E5]DFeAK
E5]DFeAKE?mDBeA;E4]DBeA;E4]DBeA;E4]DBeA;E4]DBeA;E4/3o`0G>e@kE3]D>e@kE3]D>e@kE3]D
>olkcS/00ol053_>>lhkcS_>>lhkcS_>>lhkcS_>0ol0;lkZc^[>j/kZc^[>j/kZc^[>j/kZc^[>j_oZ
c^[>j/kZc^[>j/kZc^[>j/kZon[>00;o01hbE39D<U@bE39D<U@bE39D<U@bE39D<U@bE39D<_l40003
o`000280000I00;o4@008OmKcU_>FliKcU_>FliKcU_>FliKcU_>FliKcU_>FliKcP03o`0/cU_>FliK
cU_>FliKcU_>FlkocS_>>lhkcS_>>lhkcS_>>lhkcS_>>lhkcS/3o`0G>lhkcS_>>lhkcS_>>lhkcS_>
>lhkcS/00ol05<kjc_[>n/kjc_[>n/kjc_[>n/kj0ol0;lkZc^[>j/kZc^[>j/kZc^[>j/kZc^[>j/kZ
c^[oj/kZc^[>j/kZc^[>j/kZc^[>00?o025E6eDKEA]E6eDKEA]E6eDKEA]E6eDKEA]E6eDKEA]E6ol0
0`000ol0000R00006@000ol0000A000Moe]DFeAKE5]DFeAKE5]DFeAKE5]DFeAKE5]DFe@00ol0;EAK
E5]DFeAKE5]DFeAKE5]DFeAKE?mDBeA;E4]DBeA;E4]DBeA;E4]DBeA;E002o`0H>e@kE3]D>e@kE3]D
>e@kE3]D>e@kE3]D1?l04c_>>lhkcS_>>lhkcS_>>lhkcS/00_l0<<kZc^[>j/kZc^[>j/kZc^[>j/kZ
c^[>j/kZc^[>j/koc^[>j/kZc^[>j/kZc^[>jP;o02ADoe@bE39D<U@bE39D<U@bE39D<U@bE39D<U@b
E39D<U@bE?l40003o`000240000I0003o`00018001[oFliKcU_>FliKcU_>FliKcU_>FliKcU_>F`;o
02g>FliKcU_>FliKcU_>FliKcU_>FliKcU_>olhkcS_>>lhkcS_>>lhkcS_>>lh00ol05lhkcS_>>lhk
cS_>>lhkcS_>>lhkcS_>00?o01C>>lhkolkjc_[>n/kjc_[>n/kjcP?o033Zc^[>j/kZc^[>j/kZc^[>
j/kZc^[>j/kZc^[>j/kZc^[>olkZc^[>j/kZc^[>j/h2o`0W6eDKEOmE6eDKEA]E6eDKEA]E6eDKEA]E
6eDKEA]E6eDKEA]E6eGo00<000?o00008@0001T000?o00004`005_mKE5]DFeAKE5]DFeAKE5]DFeAK
E5/3o`0/FeAKE5]DFeAKE5]DFeAKE5]DFeAKE5]DFeAKod]DBeA;E4]DBeA;E4]DBe@3o`0GE3]D>e@k
E3]D>e@kE3]D>e@kE3]D>e@00ol055@kE3]D>eCocS_>>lhkcS_>>lhk0ol0<>[>j/kZc^[>j/kZc^[>
j/kZc^[>j/kZc^[>j/kZc^[>j/kZc^[oj/kZc^[>j/kZcP?o02UD<U@bE3;o<U@bE39D<U@bE39D<U@b
E39D<U@bE39D<U@bE39D<U@bo`0300;o8P0001T00_lE000Boe_>FliKcU_>FliKcU_>FliK0ol0;E_>
FliKcU_>FliKcU_>FliKcU_>FliKcU_>FliKcU_o>lhkcS_>>lhkcS_>>`02o`0GcS_>>lhkcS_>>lhk
cS_>>lhkcS_>>lh00ol05LhkcS_>>lhkcS_>oo[>n/kjc_[>nP02o`0aj/kZc^[>j/kZc^[>j/kZc^[>
j/kZc^[>j/kZc^[>j/kZc^[>j/kZc^[oj/kZc^[>jP02o`0]EA]E6eDKEA]E6olKEA]E6eDKEA]E6eDK
EA]E6eDKEA]E6eDKEA]E6eDKEA_o00@000?o00001@02oaP0000H00;o5`003_mKE5]DFeAKE5]DFeAK
0ol0;E]DFeAKE5]DFeAKE5]DFeAKE5]DFeAKE5]DFeAKE5]DFeAKod]DBeA;E4]DB`03o`0F>e@kE3]D
>e@kE3]D>e@kE3]D>e@kE0?o01ED>e@kE3]D>e@kE3]D>eCocS_>>lh00ol0<LkZc^[>j/kZc^[>j/kZ
c^[>j/kZc^[>j/kZc^[>j/kZc^[>j/kZc^[>j/kZon[>j/h00_l0;c9D<U@bE39D<U@bE3;o<U@bE39D
<U@bE39D<U@bE39D<U@bE39D<U@bE39D<UCo00@000?o000010001?l00?lG00002P03o`@00_l50003
o`0001L000[oFliKcU_>FliK0ol0;E_>FliKcU_>FliKcU_>FliKcU_>FliKcU_>FliKcU_>FliKcU_>
FolkcS_>>`03o`0F>lhkcS_>>lhkcS_>>lhkcS_>>lhkcP?o01G>>lhkcS_>>lhkcS_>>lhkcS_>ooX0
0ol0<LkZc^[>j/kZc^[>j/kZc^[>j/kZc^[>j/kZc^[>j/kZc^[>j/kZc^[>j/kZc^[>olh00ol0<EDK
EA]E6eDKEA]E6eDKEA_o6eDKEA]E6eDKEA]E6eDKEA]E6eDKEA]E6eDKEA]E6ol01@000ol000030004
o`00oaL0000=0004o`00o`8000?o00000P000ol0000H0006oe]DFeAK0ol0;E]DFeAKE5]DFeAKE5]D
FeAKE5]DFeAKE5]DFeAKE5]DFeAKE5]DFeAKE5_oB`03o`0G>e@kE3]D>e@kE3]D>e@kE3]D>e@kE3/0
0_l05U@kE3]D>e@kE3]D>e@kE3]D>e@kE3/2o`0bc^[>j/kZc^[>j/kZc^[>j/kZc^[>j/kZc^[>j/kZ
c^[>j/kZc^[>j/kZc^[>j/kZc^X2o`0cE39D<U@bE39D<U@bE39D<U@bE?mD<U@bE39D<U@bE39D<U@b
E39D<U@bE39D<U@bE39D00;o1@000ol0000300;o600000d000Co003o0P000ol000020003o`0001T0
00?oFol00_l0;U_>FliKcU_>FliKcU_>FliKcU_>FliKcU_>FliKcU_>FliKcU_>FliKcU_>Flh2o`0G
>lhkcS_>>lhkcS_>>lhkcS_>>lhkcS/00ol05C_>>lhkcS_>>lhkcS_>>lhkcS_>>`03o`0a6ooZc^[>
j/kZc^[>j/kZc^[>j/kZc^[>j/kZc^[>j/kZc^[>j/kZc^[>j/kZc^[>jP03o`0cb_lKEA]E6eDKEA]E
6eDKEA]E6eDKEOmE6eDKEA]E6eDKEA]E6eDKEA]E6eDKEA]E6eDK00;o00=Eo`001002o`<000Co003o
5`0000X00ol30004o`00o`@00_lK000_oe]DFeAKE5]DFeAKE5]DFeAKE5]DFeAKE5]DFeAKE5]DFeAK
E5]DFeAKE5]DFe@00ol05W;oE3]D>e@kE3]D>e@kE3]D>e@kE3/3o`0E>e@kE3]D>e@kE3]D>e@kE3]D
>e@k00?o035;E4]DBooZc^[>j/kZc^[>j/kZc^[>j/kZc^[>j/kZc^[>j/kZc^[>j/kZc^[>j/kZ00?o
03>jc[[>^_lbE39D<U@bE39D<U@bE39D<U@bE?mD<U@bE39D<U@bE39D<U@bE39D<U@bE3800ol01EDg
ECOo00<000?o0?l01002oaP0000:0003o`0000<000Co003o10000ol0000K000[oe_>FliKcU_>FliK
cU_>FliKcU_>FliKcU_>FliKcU_>FliKcU_>FliKcP03o`0FcU_>FlkocS_>>lhkcS_>>lhkcS_>>`?o
01DkcS_>>lhkcS_>>lhkcS_>>lhkcS/00ol0<Q_>6lhKcQ_>6ooZc^[>j/kZc^[>j/kZc^[>j/kZc^[>
j/kZc^[>j/kZc^[>j/kZc^[>0_l0=<[>b/k:c/[>oeDKEA]E6eDKEA]E6eDKEA]E6eDKEOmE6eDKEA]E
6eDKEA]E6eDKEA]E6eD2o`08nUGjEOYEn_l60003o`0001/0000:00Co0`02o`D000?o000070009omK
E5]DFeAKE5]DFeAKE5]DFeAKE5]DFeAKE5]DFeAKE5]DFeAKE003o`0FLS5b<G8aLS5boe@kE3]D>e@k
E3]D>`?o01DkE3]D>e@kE3]D>e@kE3]D>e@kE3/00ol0<T]DBeA;E4]DBeA;E?o>j/kZc^[>j/kZc^[>
j/kZc^[>j/kZc^[>j/kZc^[>j/kZc^[>0ol0=<jjc[[>^/jjc[[>oe@bE39D<U@bE39D<U@bE39D<U@b
oc9D<U@bE39D<U@bE39D<U@bE382o`0:=eDgECME=eDgo`H000?o00006`0001P000?o00007@008omK
cU_>FliKcU_>FliKcU_>FliKcU_>FliKcU_>FliKcU_>00?o01K>FliKcU_>FliKcU_>olhkcS_>>lhk
0ol05C_>>lhkcS_>>lhkcS_>>lhkcS_>>`03o`0c6lhKcQ_>6lhKcQ_>6lhKc_o>j/kZc^[>j/kZc^[>
j/kZc^[>j/kZc^[>j/kZc^[>j/kZ00;o03G>b/k:c/[>b/k:c/[>b_lKEA]E6eDKEA]E6eDKEA]E6eDK
EA_o6eDKEA]E6eDKEA]E6eDKE@02o`0=nUGjEOYEnUGjEOYEo`060003o`0001X0000G00;o80007omK
E5]DFeAKE5]DFeAKE5]DFeAKE5]DFeAKE5]DFe@00ol05W8aLS5b<G8aLS5b<G8aLS5boe@kE3/3o`0E
>e@kE3]D>e@kE3]D>e@kE3]D>e@k00?o03=;E4]DBeA;E4]DBeA;E4]DBeA;on[>j/kZc^[>j/kZc^[>
j/kZc^[>j/kZc^[>j/kZc^X00ol0=;[>^/jjc[[>^/jjc[[>^/jjoc9D<U@bE39D<U@bE39D<U@bE39D
<_lbE39D<U@bE39D<U@3o`0?=eDgECME=eDgECME=eGo00L000?o00006@0001L000?o000080006omK
cU_>FliKcU_>FliKcU_>FliKcU_>FliKcP03o`0GcU_>FliKcU_>FliKcU_>FliKcU_>olh00_l05C_>
>lhkcS_>>lhkcS_>>lhkcS_>>`03o`0c6lhKcQ_>6lhKcQ_>6lhKcQ_>6lhKcQ_oj/kZc^[>j/kZc^[>
j/kZc^[>j/kZc^[>j/kZ00?o03G:c/[>b/k:c/[>b/k:c/[>b/k:c_mE6eDKEA]E6eDKEA]E6eDKEA]E
6eGoEA]E6eDKEA]E6`02o`0CEOYEnUGjEOYEnUGjEOYEnUGjo`0500?o6P0001L000?o00008@005omK
E5]DFeAKE5]DFeAKE5]DFeAKE5]D00?o01Mb<G8aLS5b<G8aLS5b<G8aLS5b<G8aLP03o`0DE3]D>e@k
E3]D>e@kE3]D>e@kE3/3o`0dBeA;E4]DBeA;E4]DBeA;E4]DBeA;E4]DBeA;on[>j/kZc^[>j/kZc^[>
j/kZc^[>j/kZcP;o03Jjc[[>^/jjc[[>^/jjc[[>^/jjc[[>^/koE39D<U@bE39D<U@bE39D<U@bE39D
oe@bE39D<U@2o`0EECME=eDgECME=eDgECME=eDgECOo00L000?o0000600001L000?o00008P004omK
cU_>FliKcU_>FliKcU_>Flh00ol05liKcU_>FliKcU_>FliKcU_>FliKcU_>00?o01C>FolkcS_>>lhk
cS_>>lhkcS_>>`?o03@KcQ_>6lhKcQ_>6lhKcQ_>6lhKcQ_>6lhKcQ_>6lkoc^[>j/kZc^[>j/kZc^[>
j/kZc^[>0ol0=Lk:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:oa]E6eDKEA]E6eDKEA]E6eDKEA]E6eGo
EA]E00?o01MEnUGjEOYEnUGjEOYEnUGjEOYEnUGjo`080003o`0001L0000G0003o`0002<000ooFeAK
E5]DFeAKE5]DFe@00ol05g8aLS5b<G8aLS5b<G8aLS5b<G8aLS5b00?o01Ab<G8aLS7o>e@kE3]D>e@k
E3]D>`?o03A;E4]DBeA;E4]DBeA;E4]DBeA;E4]DBeA;E4]DBeA;E4]DolkZc^[>j/kZc^[>j/kZc^[>
0ol0=Ljjc[[>^/jjc[[>^/jjc[[>^/jjc[[>^/jjc[[>^_lbE39D<U@bE39D<U@bE39D<U@bE39D00?o
01/gECME=eDgECME=eDgECME=eDgECME=eDgEOl01`000ol0000G00005P02obH000_oFliKcU_>FliK
cP03o`0GcU_>FliKcU_>FliKcU_>FliKcU_>Flh00ol05<iKcU_>FliKcU_o>lhkcS_>>lhk0ol0=A_>
6lhKcQ_>6lhKcQ_>6lhKcQ_>6lhKcQ_>6lhKcQ_>6lhKcQ_>olkZc^[>j/kZc^[>j/kZ00;o03O>b/k:
c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:oa]E6eDKEA]E6eDKEA]E6eDKEA]E00;o01gjEOYE
nUGjEOYEnUGjEOYEnUGjEOYEnUGjEOYEo`080003o`0001H0000F0003o`0002H000OoFeAKE5]D00?o
01Mb<G8aLS5b<G8aLS5b<G8aLS5b<G8aLP03o`0DLS5b<G8aLS5b<G8aLS7o>e@kE3/3o`0eBeA;E4]D
BeA;E4]DBeA;E4]DBeA;E4]DBeA;E4]DBeA;E4]DBeA;E4_oj/kZc^[>j/kZc^X00ol0=k[>^/jjc[[>
^/jjc[[>^/jjc[[>^/jjc[[>^/jjc[[>^/jjc_mD<U@bE39D<U@bE39D<U@bE3800_l07cMEoeDgECME
=eDgECME=eDgECME=eDgECME=eDgEOl02@000ol0000E00005P000ol0000W0003oe_>00?o01S>FliK
cU_>FliKcU_>FliKcU_>FliKcU/2o`0DcU_>FliKcU_>FliKcU_>FliKoc/3o`0f6lhKcQ_>6lhKcQ_>
6lhKcQ_>6lhKcQ_>6lhKcQ_>6lhKcQ_>6lhKcQ_>6lhKon[>j/kZc^[>0_l0=l[>b/k:c/[>b/k:c/[>
b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/koEA]E6eDKEA]E6eDKEA/00ol08_YEnUGjooYEnUGjEOYE
nUGjEOYEnUGjEOYEnUGjEOYEn_l700;o5`0001H000?o0000:002o`0HLS5b<G8aLS5b<G8aLS5b<G8a
LS5b<G8a0ol04c5b<G8aLS5b<G8aLS5b<G8aLS400ol0=T]DBeA;E4]DBeA;E4]DBeA;E4]DBeA;E4]D
BeA;E4]DBeA;E4]DBeA;E4]DBeA;E?o>j/kZcP?o03O>^/jjc[[>^/jjc[[>^/jjc[[>^/jjc[[>^/jj
c[[>^/jjc[[>^/jjc[[o<U@bE39D<U@bE39D00;o02EE=eDgECME=eGoECME=eDgECME=eDgECME=eDg
ECME=eDgECOo00T000?o0000500001H00_l[000EoliKcU_>FliKcU_>FliKcU_>FliK00?o01=KcU_>
FliKcU_>FliKcU_>FliK00?o03I;c_o>6lhKcQ_>6lhKcQ_>6lhKcQ_>6lhKcQ_>6lhKcQ_>6lhKcQ_>
6lhKcQ_>6lhKcQ_>olh3o`0hc/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:
c/[>b_lKEA]E6eDKEA/2o`0XEOYEnUGjEOYEnUGoEOYEnUGjEOYEnUGjEOYEnUGjEOYEnUGjEOYEo`P0
00?o0000500001H000?o0000:`004Omb<G8aLS5b<G8aLS5b<G8a00?o018aLS5b<G8aLS5b<G8aLS5b
<G84o`0f2g8;LP]boeA;E4]DBeA;E4]DBeA;E4]DBeA;E4]DBeA;E4]DBeA;E4]DBeA;E4]DBeA;E4]D
0ol0>Ljjc[[>^/jjc[[>^/jjc[[>^/jjc[[>^/jjc[[>^/jjc[[>^/jjc[[>^/jjc[[>^/koE39D<U@b
E002o`0ZECME=eDgECME=eDgECOo=eDgECME=eDgECME=eDgECME=eDgECME=eGo2@000ol0000C0000
5P000ol0000/000=oliKcU_>FliKcU_>F`03o`0BFliKcU_>FliKcU_>FliKcU_>0ol0=li;cT_>Bli;
cT_>olhKcQ_>6lhKcQ_>6lhKcQ_>6lhKcQ_>6lhKcQ_>6lhKcQ_>6lhKcQ_>6lh00ol0>LiEol[>b/k:
c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>oeDKE@03o`0/EOYEnUGj
EOYEnUGjEOYEnUGoEOYEnUGjEOYEnUGjEOYEnUGjEOYEnUGjEOl:0003o`000180000F0003o`0002d0
00WoLS5b<G8aLS400ol04C5b<G8aLS5b<G8aLS5b<G8a00Co03Ib2g8;LP]b2g8;LP]b2g;oE4]DBeA;
E4]DBeA;E4]DBeA;E4]DBeA;E4]DBeA;E4]DBeA;E4/4o`0jJg9[LV]bok[>^/jjc[[>^/jjc[[>^/jj
c[[>^/jjc[[>^/jjc[[>^/jjc[[>^/jjc[[>^/jjc[[o<P;o030gECME=eDgECME=eDgECME=eDgEOmE
=eDgECME=eDgECME=eDgECME=eDgECME=ol900;o4`0001D00ol_0005oliKcU/00ol04E_>FliKcU_>
FliKcU_>FliK00?o03I;cT_>Bli;cT_>Bli;cT_>Bli;c_o>6lhKcQ_>6lhKcQ_>6lhKcQ_>6lhKcQ_>
6lhKcQ_>6lh4o`0lELiEcUG>ELiEc_o>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>
b/k:c/[>b/k:c/[>0_l0<_YEnUGjEOYEnUGjEOYEnUGjEOYEnUGjooYEnUGjEOYEnUGjEOYEnUGjEOYE
nUGjEO[o2P000ol0000500?o1002o`<0000E0003o`00030001GoL_oo<G8aLS5b<G8aLS5b<G8aLS40
0ol0=P]b2g8;LP]b2g8;LP]b2g8;LP]b2g8;L_mDBeA;E4]DBeA;E4]DBeA;E4]DBeA;E4]DBeA;E0?o
03e[LV]bJg9[LV]bJg9[LV_oc[[>^/jjc[[>^/jjc[[>^/jjc[[>^/jjc[[>^/jjc[[>^/jjc[[>^/jj
c[[>00?o03EDocME=eDgECME=eDgECME=eDgECME=eDgEOmE=eDgECME=eDgECME=eDgECME=eDgECME
o`0:0003o`0000D000?o00000P001?l00?l2000000@0oooo1002o`@00_l50003o`0002l00ol03liK
cU_>FliKcU_>FliKcP04o`0eBli;cT_>Bli;cT_>Bli;cT_>Bli;cT_>Bli;c_o>6lhKcQ_>6lhKcQ_>
6lhKcQ_>6lhKcQ/01?l0?LiEcUG>ELiEcUG>ELiEcUG>ELkoc/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:
c/[>b/k:c/[>b/k:c/[>b/h00ol0>5GZENYEoeGjEOYEnUGjEOYEnUGjEOYEnUGjEOYEn_ojEOYEnUGj
EOYEnUGjEOYEnUGjEOYEnUGo2P000ol000050003o`00008000Co003o0P00008000?o00000P001?l0
0?l20004o`00o`@000?o0000;003o`<000coLS5b<G8aLS5b<G83o`0eLP]b2g8;LP]b2g8;LP]b2g8;
LP]b2g8;LP]b2g8;LP_oBeA;E4]DBeA;E4]DBeA;E4]DBe@01?l0?W9[LV]bJg9[LV]bJg9[LV]bJg9[
LV]bok[>^/jjc[[>^/jjc[[>^/jjc[[>^/jjc[[>^/jjc[[>^/jjc[[>0ol0>eCZE>YDjUCZoeDgECME
=eDgECME=eDgECME=eDgECME=olgECME=eDgECME=eDgECME=eDgECME=eGo00/000?o000010000ol0
00020004o`00o`8000020003o`00008000Co003o0P001?l00?l40003o`0002T00ol70007oliKcU_>
F`04o`0ecT_>Bli;cT_>Bli;cT_>Bli;cT_>Bli;cT_>Bli;cT_>Bli;oa_>6lhKcQ_>6lhKcQ_>6lh0
0ol0?liEcUG>ELiEcUG>ELiEcUG>ELiEcUG>ELiEcUGob/k:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:
c/[>b/k:cP03o`0oENYEjUGZENYEjUGoEOYEnUGjEOYEnUGjEOYEnUGjEOYEnUGjEOmEnUGjEOYEnUGj
EOYEnUGjEOYEnUGjEO[o00T00ol50003o`00008000Co003o0P00008000?o00000P001?l00?l20004
o`00o`<00_lX00?o2`000omb<@03o`0e2g8;LP]b2g8;LP]b2g8;LP]b2g8;LP]b2g8;LP]b2g8;LP]b
2g8;LP_oBeA;E4]DBeA;E4/01?l0?f]bJg9[LV]bJg9[LV]bJg9[LV]bJg9[LV]bJg9[LV_oc[[>^/jj
c[[>^/jjc[[>^/jjc[[>^/jjc[[>^/jjcP03o`12E>YDjUCZE>YDjUCZE>YDocME=eDgECME=eDgECME
=eDgECME=eDgECOo=eDgECME=eDgECME=eDgECME=eDgECOo1P04o`030?l000<00_l500;o0`000080
00?o00000P001?l00?l20004o`00o`<000?o00009003o`l00_l0=4_>Bli;cT_>Bli;cT_>Bli;cT_>
Bli;cT_>Bli;cT_>Bli;cT_>Bli;cT_>BolKcQ_>6lh4o`10ELiEcUG>ELiEcUG>ELiEcUG>ELiEcUG>
ELiEcUG>ELiEcUG>olk:c/[>b/k:c/[>b/k:c/[>b/k:c/[>b/k:cP?o04EEjUGZENYEjUGZENYEjUGZ
EN[onUGjEOYEnUGjEOYEnUGjEOYEnUGjEOYEnUGoEOYEnUGjEOYEnUGjEOYEnUGjEOYEn_l00`03o`D0
00?o00003P0000030?oo00D00_l400;o10000ol0000Q00?o4`00<_mb2g8;LP]b2g8;LP]b2g8;LP]b
2g8;LP]b2g8;LP]b2g8;LP]b2g8;LP]b2g8;od]D0ol0@F]bJg9[LV]bJg9[LV]bJg9[LV]bJg9[LV]b
Jg9[LV]bJg9[LV]bJg9[oljjc[[>^/jjc[[>^/jjc[[>^/jjc[[>00?o04MDjUCZE>YDjUCZE>YDjUCZ
E>YDjUCo=eDgECME=eDgECME=eDgECME=eDgECME=eGoECME=eDgECME=eDgECME=eDgECME=`04o`P0
00?o00003P0001@000?o00007`02oaL002gocT_>Bli;cT_>Bli;cT_>Bli;cT_>Bli;cT_>Bli;cT_>
Bli;cT_>Bli;cT/01?l0@LiEcUG>ELiEcUG>ELiEcUG>ELiEcUG>ELiEcUG>ELiEcUG>ELiEcUG>ELiE
ol[>b/k:c/[>b/k:c/[>b/k:c/[>00?o04QEjUGZENYEjUGZENYEjUGZENYEjUGZENYEoeGjEOYEnUGj
EOYEnUGjEOYEnUGjEOYEnUGjooYEnUGjEOYEnUGjEOYEnUGjEOX2o`03EOl000T000?o00003P0001@0
00?o00007003oaX002SoLP]b2g8;LP]b2g8;LP]b2g8;LP]b2g8;LP]b2g8;LP]b2g8;LP]b1?l0@/ib
of]bJg9[LV]bJg9[LV]bJg9[LV]bJg9[LV]bJg9[LV]bJg9[LV]bJg9[LV]bJg;o^/jjc[[>^/jjc[[>
^/jjcP?o04QDjUCZE>YDjUCZE>YDjUCZE>YDjUCZE>YDjUCZoeDgECME=eDgECME=eDgECME=eDgECME
=eDgEOmE=eDgECME=eDgECME=eD3o`04EGiEo`/000?o00003@0001<00_lK00?o7P008_o>Bli;cT_>
Bli;cT_>Bli;cT_>Bli;cT_>Bli;cT_>Blh5o`13E7]DNeAkE?o>ELiEcUG>ELiEcUG>ELiEcUG>ELiE
cUG>ELiEcUG>ELiEcUG>ELiEcUG>ELkoc/[>b/k:c/[>b/k:cP03o`19ENYEjUGZENYEjUGZENYEjUGZ
ENYEjUGZENYEjUGZEOmEnUGjEOYEnUGjEOYEnUGjEOYEnUGjEOYEnUGjooYEnUGjEOYEnUGjE@02o`08
VUFJEIYEV_l:0003o`0000d0000D0003o`0001H00olR000Mog8;LP]b2g8;LP]b2g8;LP]b2g8;LP]b
2g8;LP/01?l0AG;>L/ibcW;>L/ibcW;oJg9[LV]bJg9[LV]bJg9[LV]bJg9[LV]bJg9[LV]bJg9[LV]b
Jg9[LV]bJg9[oljjc[[>^/jjcP03o`1:E>YDjUCZE>YDjUCZE>YDjUCZE>YDjUCZE>YDjUCZE>YDjUCo
=eDgECME=eDgECME=eDgECME=eDgECME=eDgocME=eDgECME=eD2o`0:OUEnEGiEOUEno`X000?o0000
3@0001<000?o00005003obH001SocT_>Bli;cT_>Bli;cT_>Bli;cT_>Blh4o`16NeAkE7]DNeAkE7]D
NeAkE7]DoliEcUG>ELiEcUG>ELiEcUG>ELiEcUG>ELiEcUG>ELiEcUG>ELiEcUG>ELiEc_o>b/k:cP?o
04YEjUGZENYEjUGZENYEjUGZENYEjUGZENYEjUGZENYEjUGZENYEj_ojEOYEnUGjEOYEnUGjEOYEnUGj
EOYEnUGjEOYEoeGjEOYEnP?o00bJEIYEVUFJEIYEV_l:0003o`0000d0000C0003o`0001400olZ000C
og8;LP]b2g8;LP]b2g8;LP]b2`04o`17L/ibcW;>L/ibcW;>L/ibcW;>L/ibc_mbJg9[LV]bJg9[LV]b
Jg9[LV]bJg9[LV]bJg9[LV]bJg9[LV]bJg9[LV]bJg;o^/h00ol0BeCZE>YDjUCZE>YDjUCZE>YDjUCZ
E>YDjUCZE>YDjUCZE>YDjUCZE>YDocME=eDgECME=eDgECME=eDgECME=eDgECME=eDgocME=`02o`0?
EGiEOUEnEGiEOUEnEGko00X000?o00003@0001<00_l@00;o;P003_o>Bli;cT_>Bli;cT_>1?l0AW]D
NeAkE7]DNeAkE7]DNeAkE7]DNeAkE7]DNomEcUG>ELiEcUG>ELiEcUG>ELiEcUG>ELiEcUG>ELiEcUG>
ELiEcUG>ELh5o`1<ENYEjUGZENYEjUGZENYEjUGZENYEjUGZENYEjUGZENYEjUGZENYEjUGZENYEoeGj
EOYEnUGjEOYEnUGjEOYEnUGjEOYEnUGjEO[onP;o019EVUFJEIYEVUFJEIYEVUFJEOl90003o`0000d0
000C0003o`0000`00ola0008og8;LP]b2g85o`14L/ibcW;>L/ibcW;>L/ibcW;>L/ibcW;>L/ibcW;>
L/koLV]bJg9[LV]bJg9[LV]bJg9[LV]bJg9[LV]bJg9[LV]bJg86o`1>Jle[oeCZE>YDjUCZE>YDjUCZ
E>YDjUCZE>YDjUCZE>YDjUCZE>YDjUCZE>YDjUCZE>[oECME=eDgECME=eDgECME=eDgECME=eDgECME
0ol055EnEGiEOUEnEGiEOUEnEGiEOUGo2@000ol0000=00004`000ol0000900?o=@000oo>B`04o`14
E7]DNeAkE7]DNeAkE7]DNeAkE7]DNeAkE7]DNeAkE7]DNeAkE7_oELiEcUG>ELiEcUG>ELiEcUG>ELiE
cUG>ELiEcUD5o`1BEEAEE5EDEEAEE?mEjUGZENYEjUGZENYEjUGZENYEjUGZENYEjUGZENYEjUGZENYE
jUGZENYEjUGoEOYEnUGjEOYEnUGjEOYEnUGjEOYEnUGjE@;o01NJEI[oVUFJEIYEVUFJEIYEVUFJEIYE
o`0:0003o`0000`0000C0003o`0000H00oli00;o04;>L/ibcW;>L/ibcW;>L/ibcW;>L/ibcW;>L/ib
cW;>L/ibcW;>L/ibcW;>og9[LV]bJg9[LV]bJg9[LV]bJg9[LV/6o`1EcF_=Jle[cF_=Jle[cF_=onYD
jUCZE>YDjUCZE>YDjUCZE>YDjUCZE>YDjUCZE>YDjUCZE>YDjUCZE>YDjUCo=eDgECME=eDgECME=eDg
ECME=eDgE@02o`0JOUEnEGiEoeEnEGiEOUEnEGiEOUEnEGiEO_l90003o`0000`0000C0003o`0000<0
0oln000log]DNeAkE7]DNeAkE7]DNeAkE7]DNeAkE7]DNeAkE7]DNeAkE7]DNeAkE?o>ELiEcUG>ELiE
cUG>ELiE1_l0F5AEE5EDEEAEE5EDEEAEE5EDEEAEE5GojUGZENYEjUGZENYEjUGZENYEjUGZENYEjUGZ
ENYEjUGZENYEjUGZENYEjUGZooYEnUGjEOYEnUGjEOYEnUGjEOX3o`0LVUFJEIYEVUGoEIYEVUFJEIYE
VUFJEIYEVUFJo`T000?o0000300001800_l200?o@P00=_o>L/ibcW;>L/ibcW;>L/ibcW;>L/ibcW;>
L/ibcW;>L/ibcW;>L/ibcW;oJg9[LV]bJg9[LPGo05c=Jle[cF_=Jle[cF_=Jle[cF_=Jle[cF_=Jle[
oeCZE>YDjUCZE>YDjUCZE>YDjUCZE>YDjUCZE>YDjUCZE>YDjUCZE>YDjUCZE?lgECME=eDgECME=eDg
ECME=`;o01mEOUEnEGiEOUEnEGkoOUEnEGiEOUEnEGiEOUEnEGko00T000?o0000300001801?m6000_
og]DNeAkE7]DNeAkE7]DNeAkE7]DNeAkE7]DNeAkE7]DNeAkE7]DNeAkE?o>ELh01_l0GeEDEEAEE5ED
EEAEE5EDEEAEE5EDEEAEE5EDEEAEE5EDEECoENYEjUGZENYEjUGZENYEjUGZENYEjUGZENYEjUGZENYE
jUGZENYEjUGZENYEoeGjEOYEnUGjEOYEnUGj00;o025EVUFJEIYEVUFJEIYEVUGoEIYEVUFJEIYEVUFJ
EIYEV_l02@000ol0000<00004P02odT002SocW;>L/ibcW;>L/ibcW;>L/ibcW;>L/ibcW;>L/ibcW;>
L/ibcW;>1_l0HV_=Jle[cF_=Jle[cF_=Jle[cF_=Jle[cF_=Jle[cF_=Jle[cF_=JlgojUCZE>YDjUCZ
E>YDjUCZE>YDjUCZE>YDjUCZE>YDjUCZE>YDjUCZE>YDjUCZoeDgECME=eDgECME0ol095EnEGiEOUEn
EGiEOUEnEGiEO_mnEGiEOUEnEGiEOUEnEGiEo`P000?o0000300001@000?o0000A`008OmkE7]DNeAk
E7]DNeAkE7]DNeAkE7]DNeAkE7]DNeAkE006o`1VNeAkoeEDEEAEE5EDEEAEE5EDEEAEE5EDEEAEE5ED
EEAEE5EDEEAEE5EDEEAEE5GojUGZENYEjUGZENYEjUGZENYEjUGZENYEjUGZENYEjUGZENYEjUGZENYE
jUGoEOYEnUGjEOYE0_l09iYEVUFJEIYEVUFJEIYEVUFJEIYEV_nJEIYEVUFJEIYEVUFJEIYEo`080003
o`0000`0000E0003o`0004L001[ocW;>L/ibcW;>L/ibcW;>L/ibcW;>L/ibcPKo06[=>ldkcC_=>ldk
ole[cF_=Jle[cF_=Jle[cF_=Jle[cF_=Jle[cF_=Jle[cF_=Jle[cF_=JomDjUCZE>YDjUCZE>YDjUCZ
E>YDjUCZE>YDjUCZE>YDjUCZE>YDjUCZE>YDjUCo=eDgECME0_l0:GiEOUEnEGiEOUEnEGiEOUEnEGiE
OUEnEOmEOUEnEGiEOUEnEGiEOUGo00P000?o0000300001H000?o0000A`004_mkE7]DNeAkE7]DNeAk
E7]DN`Oo06ekE7]DNeAkE7]DNeAkE7]DNomEE5EDEEAEE5EDEEAEE5EDEEAEE5EDEEAEE5EDEEAEE5ED
EEAEE5EDEECoENYEjUGZENYEjUGZENYEjUGZENYEjUGZENYEjUGZENYEjUGZENYEjUGZEN[onUGj00?o
02^JEIYEVUFJEIYEVUFJEIYEVUFJEIYEVUFJEI[oVUFJEIYEVUFJEIYEVUGo00T000?o00002`0001L0
0_m8000;olibcW;>L/ibcW801_l0LS_=>ldkcC_=>ldkcC_=>ldkcC_=>ldkcC_ocF_=Jle[cF_=Jle[
cF_=Jle[cF_=Jle[cF_=Jle[cF_=Jle[cF_=JlgojUCZE>YDjUCZE>YDjUCZE>YDjUCZE>YDjUCZE>YD
jUCZE>YDjUCZE>YDjUCo=`;o02mEOUEnEGiEOUEnEGiEOUEnEGiEOUEnEGiEOUEnEGkoOUEnEGiEOUEn
EGiEOUEno`080003o`0000/0000I0003o`0004H000CoNeAk1_l0M5AkE7]DNeAkE7]DNeAkE7]DNeAk
E7]DNeAkE7]DNeAkoeEDEEAEE5EDEEAEE5EDEEAEE5EDEEAEE5EDEEAEE5EDEEAEE5EDEEAEonYEjUGZ
ENYEjUGZENYEjUGZENYEjUGZENYEjUGZENYEjUGZENYEjUGZ1?l0<EFJEIYEVUFJEIYEVUFJEIYEVUFJ
EIYEVUFJEIYEVUFJEOmEVUFJEIYEVUFJEIYEV_l020000ol0000;00006P000ol0001600?o07<kcC_=
>ldkcC_=>ldkcC_=>ldkcC_=>ldkcC_=>ldkcC_=>ldkcC_ocF_=Jle[cF_=Jle[cF_=Jle[cF_=Jle[
cF_=Jle[cF_=Jle[cF_=JomDjUCZE>YDjUCZE>YDjUCZE>YDjUCZE>YDjUCZE>YDjUCZ00Oo03DgECOo
EGiEOUEnEGiEOUEnEGiEOUEnEGiEOUEnEGiEOUEnEGiEO_mnEGiEOUEnEGiEOUEno`080003o`0000/0
000K0003o`0004H006koNeAkE7]DNeAkE7]DNeAkE7]DNeAkE7]DNeAkE7]DNeAkE7]DNeAkE?mDEEAE
E5EDEEAEE5EDEEAEE5EDEEAEE5EDEEAEE5EDEEAEE5EDEEAEE?mEjUGZENYEjUGZENYEjUGZENYEjUGZ
ENYEjPOo2UD0<omEVUFJEIYEVUFJEIYEVUFJEIYEVUFJEIYEVUFJEIYEVUFJEOmEVUFJEIYEVUFJEIYE
o`070003o`0000/0000L00;oA`00I_lkcC_=>ldkcC_=>ldkcC_=>ldkcC_=>ldkcC_=>ldkcC_=>ldk
cC_=of_=Jle[cF_=Jle[cF_=Jle[cF_=Jle[cF_=Jle[cF_=Jle[cF_=JlgojUCZE>YDjUCZE>YDjUCZ
E>YDjPOo04@gECME=eDgECME=eDgECME=eGoOUEnEGiEOUEnEGiEOUEnEGiEOUEnEGiEOUEnEGiEOUEn
EOmEOUEnEGiEOUEnEGiEo`L000?o00002`0001h000?o0000A@00G_mkE7]DNeAkE7]DNeAkE7]DNeAk
E7]DNeAkE7]DNeAkE7]DNeAkE7]DoeAEE5EDEEAEE5EDEEAEE5EDEEAEE5EDEEAEE5EDEEAEE5EDEEAE
E5GojUGZENYEjUGZENX7oaUE03;oVUFJEIYEVUFJEIYEVUFJEIYEVUFJEIYEVUFJEIYEVUFJEI[oVUFJ
EIYEVUFJEIYEo`L000?o00002`0001l000?o0000A@00E_lkcC_=>ldkcC_=>ldkcC_=>ldkcC_=>ldk
cC_=>ldkcC_=>ldkcC_=of_=Jle[cF_=Jle[cF_=Jle[cF_=Jle[cF_=Jle[cF_=Jle[cF_=JomDjUCZ
1ol0DSME=eDgECME=eDgECME=eDgECME=eDgECME=eDgECMEogiEOUEnEGiEOUEnEGiEOUEnEGiEOUEn
EGiEOUEnEGiEOUEnEOmEOUEnEGiEOUEnEOl70003o`0000/0000P0003o`0004D003koNeAkE7]DNeAk
E7]DNeAkE7]DNeAkE7]DNeAkE7]DNeAkE7]DNeAkE?mDEEAEE5EDEEAEE5EDEEAEE5EDEAOo:5D0<_mE
VUFJEIYEVUFJEIYEVUFJEIYEVUFJEIYEVUFJEIYEVUFJEI[oVUFJEIYEVUFJEI[o1`000ol0000:0000
8@02odH002Co>ldkcC_=>ldkcC_=>ldkcC_=>ldkcC_=>ldkcC_=>ldkcC/Io`1aEG9ELUEbEG9ELUEb
EG9ELUEbEOlgECME=eDgECME=eDgECME=eDgECME=eDgECME=eDgECME=eDgECME=eDgoeEnEGiEOUEn
EGiEOUEnEGiEOUEnEGiEOUEnEGiEOUEnEGiEO_mnEGiEOUEnEGiEO_l01`000ol0000:00008`000ol0
0014000Jog]DNeAkE7]DNeAkE7]DNeAkE7]DNeAkE7/9o`0^LeAcE7?oEEAEE5EDEEAEE5EDEEAEE5ED
EEAEE5EDEEAEE5EDEEAEE5EDEEAEobYE03;oEIYEVUFJEIYEVUFJEIYEVUFJEIYEVUFJEIYEVUFJEIYE
VUFJEOmEVUFJEIYEVUFJo`L000?o00002P0002@000?o0000A0004?lkcC_=>ldkcC_=>ldkcC/9o`2C
E<iDcUC>E<iDcUC>E<iDoeEbEG9ELUEbEG9ELUEbEG9ELUEbEG9ELUEbEG9ELUEbEG9ELUEboeDgECME
=eDgECME=eDgECME=eDgECME=eDgECME=eDgECME=eDgECME=eGoOUEnEGiEOUEnEGiEOUEnEGiEOUEn
EGiEOUEnEGiEOUEnEGiEO_mnEGiEOUEnEGko00L000?o00002P0002D000?o0000A0001_mkE7]DN`Wo
041cE7=DLeAcE7=DLeAcE7=DLeAcE7=DLeAcoeEDEEAEE5EDEEAEE5EDEEAEE5EDEEAEE5EDEEAEE5ED
EEAEE5Go:eD0<_nJEIYEVUFJEIYEVUFJEIYEVUFJEIYEVUFJEIYEVUFJEIYEVUFJoiYEVUFJEIYEVUGo
1P000ol0000:00009P000ol0001400Go0:IDcUC>E<iDcUC>E<iDcUC>E<iDcUC>E<iDcUC>E<iDcUC>
og9ELUEbEG9ELUEbEG9ELUEbEG9ELUEbEG9ELUEbEG9ELUEbEG9EocME=eDgECME=eDgECME=eDgECME
=eDgECME=eDgECME=eDgECME=eDgEOmnEGiEOUEnEGiEOUEnEGiEOUEnEGiEOUEnEGiEOUEnEGiEOUEn
EOmEOUEnEGiEOUGo1P000ol0000:00009`02odD004koLeAcE7=DLeAcE7=DLeAcE7=DLeAcE7=DLeAc
E7=DLeAcE7=DLeCoE5EDEEAEE5EDEEAEE5EDEEAEE5EDEEAEE5EDEEAEE5EDEEAEE?lZE@0boiYEVUFJ
EIYEVUFJEIYEVUFJEIYEVUFJEIYEVUFJEIYEVUFJEIYEV_nJEIYEVUFJEOl60003o`0000X0000Y0003
o`0004<00:WoE<iDcUC>E<iDcUC>E<iDcUC>E<iDcUC>E<iDcUC>E<iDcUC>E<koLUEbEG9ELUEbEG9E
LUEbEG9ELUEbEG9ELUEbEG9ELUEbEG9EL_mE=eDgECME=eDgECME=eDgECME=eDgECME=eDgECME=eDg
ECME=eDgECOoEGiEOUEnEGiEOUEnEGiEOUEnEGiEOUEnEGiEOUEnEGiEOUEnEGiEoeEnEGiEOUGo00L0
00?o00002@0002X000?o0000@`00COmcE7=DLeAcE7=DLeAcE7=DLeAcE7=DLeAcE7=DLeAcE7=DLeAc
E?mDEEAEE5EDEEAEE5EDEEAEE5EDEEAEE5EDEEAEE5EDEEAEE5Go02YE03;oEIYEVUFJEIYEVUFJEIYE
VUFJEIYEVUFJEIYEVUFJEIYEVUFJEIYEoeFJEIYEVUFJo`H000?o00002@0002/000?o0000@`00Z?mD
cUC>E<iDcUC>E<iDcUC>E<iDcUC>E<iDcUC>E<iDcUC>E<iDoeEbEG9ELUEbEG9ELUEbEG9ELUEbEG9E
LUEbEG9ELUEbEG9EL_mE=eDgECME=eDgECME=eDgECME=eDgECME=eDgECME=eDgECME=eDgECOoEGiE
OUEnEGiEOUEnEGiEOUEnEGiEOUEnEGiEOUEnEGiEOUEnEGiEO_mnEGiEOUEno`H000?o00002@0002`0
0_m4001<og=DLeAcE7=DLeAcE7=DLeAcE7=DLeAcE7=DLeAcE7=DLeAcE7?oEEAEE5EDEEAEE5EDEEAE
E5EDEEAEE5EDEEAEE5EDEEAEE5EDobYE037oVUFJEIYEVUFJEIYEVUFJEIYEVUFJEIYEVUFJEIYEVUFJ
EIYEVUFJEOmEVUFJEI[o00H000?o00002@0002h000?o0000@P00YomDcUC>E<iDcUC>E<iDcUC>E<iD
cUC>E<iDcUC>E<iDcUC>E<iDoeEbEG9ELUEbEG9ELUEbEG9ELUEbEG9ELUEbEG9ELUEbEG9EocME=eDg
ECME=eDgECME=eDgECME=eDgECME=eDgECME=eDgECME=eDgEOmnEGiEOUEnEGiEOUEnEGiEOUEnEGiE
OUEnEGiEOUEnEGiEOUEnEGiEO_mnEGiEOUGo00D000?o00002@0002l000?o0000@P00BomcE7=DLeAc
E7=DLeAcE7=DLeAcE7=DLeAcE7=DLeAcE7=DLeCoE5EDEEAEE5EDEEAEE5EDEEAEE5EDEEAEE5EDEEAE
E5EDEEAEo`0YE@0boiYEVUFJEIYEVUFJEIYEVUFJEIYEVUFJEIYEVUFJEIYEVUFJEIYEVUFJoiYEVUFJ
EOl50003o`0000T0000`0003o`0004800:GoE<iDcUC>E<iDcUC>E<iDcUC>E<iDcUC>E<iDcUC>E<iD
cUC>og9ELUEbEG9ELUEbEG9ELUEbEG9ELUEbEG9ELUEbEG9ELUEboeDgECME=eDgECME=eDgECME=eDg
ECME=eDgECME=eDgECME=eDgECMEogiEOUEnEGiEOUEnEGiEOUEnEGiEOUEnEGiEOUEnEGiEOUEnEGiE
OUEnEOmEOUEnEOl01@000ol000090000<@02od<001?oLeAcE7=DLeAcE7=DLeAcE7=D01Go029DEEAE
E5EDEEAEE5EDEEAEE5EDEEAEE5EDEEAEE5EDEECo:ED0<OmEVUFJEIYEVUFJEIYEVUFJEIYEVUFJEIYE
VUFJEIYEVUFJEIYEVUFJEI[oVUFJEOl01@000ol000090000<`000ol0001101;o01EELUEbEG9ELUEb
EG9ELUEbEG;oUhh01Ol0N79ELUEbEG9ELUEbEG9ELUEbEG9ELUEbEG9ELUGo=eDgECME=eDgECME=eDg
ECME=eDgECME=eDgECME=eDgECME=eDgECOoEGiEOUEnEGiEOUEnEGiEOUEnEGiEOUEnEGiEOUEnEGiE
OUEnEGiEOUEnEOmEOUEno`D000?o0000200003@000?o0000@@00:ombE79DLUAbE79DLUAbE79DLUAb
E79DLUAbE79DLUAbE79DL_nGE9MDUe@01Ol065AEE5EDEEAEE5EDEEAEE5EDEEAEE5EDobUE02ooEIYE
VUFJEIYEVUFJEIYEVUFJEIYEVUFJEIYEVUFJEIYEVUFJEIYEVUFJEOmEVP03o`D000?o0000200003D0
00?o0000@@00;ombEG9ELUEbEG9ELUEbEG9ELUEbEG9ELUEbEG9ELUEbEG9EL_nGSYN>UhjGSYN>00Go
06MbEG9ELUEbEG9ELUEbEG9ELUEboeDgECME=eDgECME=eDgECME=eDgECME=eDgECME=eDgECME=eDg
ECMEogiEOUEnEGiEOUEnEGiEOUEnEGiEOUEnEGiEOUEnEGiEOUEnEGiEOUEn00Co00?>EOl01@000ol0
00080000=P02od8003?oLUAbE79DLUAbE79DLUAbE79DLUAbE79DLUAbE79DLUAbE7;oUeBGE9MDUeBG
E9MDUe@01Ol03eAEE5EDEEAEE5EDEEAEo`0YE@0WoiYEVUFJEIYEVUFJEIYEVUFJEIYEVUFJEIYEVUFJ
EIYEVUFJEIYE00?o00S>Z/kocZ[>o`@000?o0000200003P000?o0000@000=ombEG9ELUEbEG9ELUEb
EG9ELUEbEG9ELUEbEG9ELUEbEG9EohjGSYN>UhjGSYN>UhjGSYN>Uhh01Ol0EW9ELUEbEG9ELUGo=eDg
ECME=eDgECME=eDgECME=eDgECME=eDgECME=eDgECME=eDgEOmnEGiEOUEnEGiEOUEnEGiEOUEnEGiE
OUEnEGiEOUEnEGiE1?l02eG>ELiEc_o>ELko00@000?o0000200003T000?o0000@000>ombE79DLUAb
E79DLUAbE79DLUAbE79DLUAbE79DLUAbE79DoeBGE9MDUeBGE9MDUeBGE9MDUeBGE9MD00Go00IDEEAE
E?lYE@0NoeFJEIYEVUFJEIYEVUFJEIYEVUFJEIYEVUFJEIYE1?l04:[>Z/jZcZ[>Z/jZoj[>Z_l30003
o`0000P0000j0003o`00040003ooLUEbEG9ELUEbEG9ELUEbEG9ELUEbEG9ELUEbEG9ELUEbEOn>UhjG
SYN>UhjGSYN>UhjGSYN>UhjGSYN>Uhh01_l0@cME=eDgECME=eDgECME=eDgECME=eDgECME=eDgECME
=eDgECME=eDgoeEnEGiEOUEnEGiEOUEnEGiEOUEnEGiEOUD01?l055G>ELiEcUG>ELiEcUG>ELkocUGo
0`000ol000080000>`02od4004?oLUAbE79DLUAbE79DLUAbE79DLUAbE79DLUAbE79DLUAbE?mDUeBG
E9MDUeBGE9MDUeBGE9MDUeBGE9MDUeBGE9MD00Ko95D05omEVUFJEIYEVUFJEIYEVUFJEIYEVUFJ00?o
01VZcZ[>Z/jZcZ[>Z/jZcZ[>Z/jZcZ[oZ/ko008000?o0000200003d000?o0000?`00B?mbEG9ELUEb
EG9ELUEbEG9ELUEbEG9ELUEbEG9ELUEbEG;oUhjGSYN>UhjGSYN>UhjGSYN>UhjGSYN>UhjGSYN>Uhko
E5YDFPOo030gECME=eDgECME=eDgECME=eDgECME=eDgECME=omEOUEnEGiEOUEnEGiEOUEnEGh4o`0L
cUG>ELiEcUG>ELiEcUG>ELiEcUG>ELiEoeG>o`<000?o00001`0003h000?o0000?`0:o`14E79DLUAb
E79DLUAbE79DLUAbE79DLUAboiMDUeBGE9MDUeBGE9MDUeBGE9MDUeBGE9MDUeBGE9MDoeF0EH1EP5F0
EH07oaME00koVUFJEIYEVUFJEIYEVPCo027>Z/jZcZ[>Z/jZcZ[>Z/jZcZ[>Z/jZcZ[>Z/jZc_o>Z_l0
0P000ol000070000?`000ol0000n0003o`0000L04_l0>G9ELUEbEG;oUhjGSYN>UhjGSYN>UhjGSYN>
UhjGSYN>UhjGSYN>UomJE5YDFUAJE5YDFUAJE5YDFP07o`0J=eDgECME=eDgECME=eDgEOmnEGiEOUEn
EGh4o`0UcUG>ELiEcUG>ELiEcUG>ELiEcUG>ELiEcUG>ELiEcUG>EOmEo`020003o`0000L0001000;o
?P000ol0000I00[o03IDUeBGE9MDUeBGE9MDUeBGE9MDUeBGE9MDUeBGE?mEP5F0EH1EP5F0EH1EP5F0
EH1EP5F0EH07o`UE00OoVUFJEIYE00?o02O>Z/jZcZ[>Z/jZcZ[>Z/jZcZ[>Z/jZcZ[>Z/jZcZ[>Z/jZ
cZ[>Z/h00_l20003o`0000L000120003o`0003/000?o00008`02o`0kUhjGSYN>UhjGSYN>UhjGSYN>
UhjGSYN>UhjGS_mDFUAJE5YDFUAJE5YDFUAJE5YDFUAJE5YDFUAJE5X01ol01CME=omE00Co02mEcUG>
ELiEcUG>ELiEcUG>ELiEcUG>ELiEcUG>ELiEcUG>ELiEcUG>ELkoc_l0o`090000@`000ol0000j0003
o`0002D00_l0@5BGE9MDUeBGE9MDUeBGE9MDUeBGE9MDUeBGoh1EP5F0EH1EP5F0EH1EP5F0EH1EP5F0
EH1EP5F0EH1EP5F0EH05o`0_Z/jZcZ[>Z/jZcZ[>Z/jZcZ[>Z/jZcZ[>Z/jZcZ[>Z/jZcZ[>Z/jZcZ[>
Z/jZcZX00_l00`3o00080000A0000ol0000i0003o`0002L00_l0LiN>UhjGSYN>UhjGSYN>UhjGSYN>
UhjGSYOoFUAJE5YDFUAJE5YDFUAJE5YDFUAJE5YDFUAJE5YDFUAJE5YDFUAJoliEcUG>ELiEcUG>ELiE
cUG>ELiEcUG>ELiEcUG>ELiEcUG>ELiEcUG>ELiEcUG>ELh00ol90000A@02ocT000?o0000:@02o`1a
E9MDUeBGE9MDUeBGE9MDUeBGE9MDUeCoEH1EP5F0EH1EP5F0EH1EP5F0EH1EP5F0EH1EP5F0EH1EP5F0
EH1EP?nZcZ[>Z/jZcZ[>Z/jZcZ[>Z/jZcZ[>Z/jZcZ[>Z/jZcZ[>Z/jZcZ[>Z/jZcZ[>Z/h00_l00`3o
00070000A`000ol0000f0003o`0002/00_l0L9N>UhjGSYN>UhjGSYN>UhjGSYN>UhkoE5YDFUAJE5YD
FUAJE5YDFUAJE5YDFUAJE5YDFUAJE5YDFUAJE5YDoeG>ELiEcUG>ELiEcUG>ELiEcUG>ELiEcUG>ELiE
cUG>ELiEcUG>ELiEcUG>ELiEcUD3o`P000180003o`0003D000?o0000;@02o`1_E9MDUeBGE9MDUeBG
E9MDUeBGE9OoP5F0EH1EP5F0EH1EP5F0EH1EP5F0EH1EP5F0EH1EP5F0EH1EP5F0EOo>Z/jZcZ[>Z/jZ
cZ[>Z/jZcZ[>Z/jZcZ[>Z/jZcZ[>Z/jZcZ[>Z/jZcZ[>Z/jZcZ[>00;o200004T000?o0000=0000ol0
000_00;o06bGSYN>UhjGSYN>UhjGSYN>UhkoE5YDFUAJE5YDFUAJE5YDFUAJE5YDFUAJE5YDFUAJE5YD
FUAJE5YDF_o>ELiEcUG>ELiEcUG>ELiEcUG>ELiEcUG>ELiEcUG>ELiEcUG>ELiEcUG>ELiEcUD3o`P0
001:0003o`00038000?o0000<P02o`1VE9MDUeBGE9MDUeBGE9MDUeCoEH1EP5F0EH1EP5F0EH1EP5F0
EH1EP5F0EH1EP5F0EH1EP5F0EH1EP?nZcZ[>Z/jZcZ[>Z/jZcZ[>Z/jZcZ[>Z/jZcZ[>Z/jZcZ[>Z/jZ
cZ[>Z/jZ1?l;0000B`02oc8000?o0000=002o`1QUhjGSYN>UhjGSYN>UhjGoeYDFUAJE5YDFUAJE5YD
FUAJE5YDFUAJE5YDFUAJE5YDFUAJE5YDFUCoELiEcUG>ELiEcUG>ELiEcUG>ELiEcUG>ELiEcUG>ELiE
cUG>ELiEcP03o`l0001=0003o`0002l000?o0000=P02o`1KE9MDUeBGE9MDUeBGE9OoP5F0EH1EP5F0
EH1EP5F0EH1EP5F0EH1EP5F0EH1EP5F0EH1EP5F0EOo>Z/jZcZ[>Z/jZcZ[>Z/jZcZ[>Z/jZcZ[>Z/jZ
cZ[>Z/jZcP04oa80001>0003o`0002h000?o0000>002o`1EUhjGSYN>UhjGSYN>oeAJE5YDFUAJE5YD
FUAJE5YDFUAJE5YDFUAJE5YDFUAJE5YDFUAJE5YDoeG>ELiEcUG>ELiEcUG>ELiEcUG>ELiEcUG>ELiE
cP04oaH0001?0003o`0002d000?o0000>P02o`1@E9MDUeBGE9MDUon0EH1EP5F0EH1EP5F0EH1EP5F0
EH1EP5F0EH1EP5F0EH1EP5F0EH1EP?nZcZ[>Z/jZcZ[>Z/jZcZ[>Z/jZcZ[>Z/jZcZX3oaX0001@00;o
;@000ol0000l00;o04ZGSYN>UhjGSYOoFUAJE5YDFUAJE5YDFUAJE5YDFUAJE5YDFUAJE5YDFUAJE5YD
FUAJE5[ocUG>ELiEcUG>ELiEcUG>ELiEcUG>E@Co7@00058000?o0000:P000ol0000n00;o04ADUeBG
E9MDoeF0EH1EP5F0EH1EP5F0EH1EP5F0EH1EP5F0EH1EP5F0EH1EP5F0EH1EoljZcZ[>Z/jZcZ[>Z/jZ
cZ[>ZPCo8@0005<000?o0000:@000ol0001000;o03nGSYN>UhkoE5YDFUAJE5YDFUAJE5YDFUAJE5YD
FUAJE5YDFUAJE5YDFUAJE5YDFUCoELiEcUG>ELiEcUG>ELh00olU0000E0000ol0000X0003o`000480
0_l0>EBGE9OoP5F0EH1EP5F0EH1EP5F0EH1EP5F0EH1EP5F0EH1EP5F0EH1EP5F0EH3oZ/jZcZ[>Z/jZ
cP04obP0001E00;o:0000ol0001400;o03>GSYOoFUAJE5YDFUAJE5YDFUAJE5YDFUAJE5YDFUAJE5YD
FUAJE5YDFUAJE5[ocUG>ELh01?l/0000E`000ol0000U0003o`0004H00_l0;UCoEH1EP5F0EH1EP5F0
EH1EP5F0EH1EP5F0EH1EP5F0EH1EP5F0EH1EP5GocZX3oc00001H0003o`0002@000?o0000B002o`0E
FUAJE5YDFUAJE5YDFUAJE5YDFUAJ01Oo<`0005T000?o00008`000ol0001:01Go3P03ocT0001J00;o
8`000ol0001Y00Co?00005`000?o000080000ol0001U00Co@00005d000?o00007`000ol0001Q00Co
A00005h000?o00007P000ol0001M00CoB00005l00_lN0003o`0005T01?m<0000H@000ol0000K0003
o`0005H00om@0000HP000ol0000J0003o`0005801?mC0000H`000ol0000I0003o`0004h01?mG0000
I002oaT000?o0000BP04oe/0001V0003o`0001H000?o0000AP04oel0001W0003o`0001D000?o0000
@`03of<0001X0003o`0001@000?o0000?`04ofH0001Y00;o50000ol0000k00CoJP0006/000?o0000
4@000ol0000g00CoKP0006`000?o000040000ol0000c00CoLP0006d000?o00003`000ol0000_00Co
MP0006h000?o00003@000ol0000]00?oNP0006l00_l=0003o`0002T01?mm0000L@000ol0000:0003
o`0002D01?n10000LP000ol000090003o`0002401?n50000L`000ol000080003o`0001d01?n90000
M002o`P000?o00006P03ohd0001f0003o`0000D000?o00005P04oi00001g0003o`0000@000?o0000
4P04oi@0001h0003o`0000<000?o00003P04oiP0001i00;o0`000ol0000:00CoW00007/000Co003o
2@03oj00001l0003o`3o00D01?nS0000O@02o`030?oo00;oY`0007h00_n[0000o`0/0000o`0/0000
o`0/0000o`0/0000\
\>"],
  ImageRangeCache->{{{0, 298.062}, {241.375, 0}} -> {-0.0635959, 0.00868197, 
  0.0034921, 0.0034921}}]
}, Closed]],

Cell["Three-dimensional plotting commands accept options, as well.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(ListPlot3D[newdata, ColorFunction \[Rule] Hue, 
      BoxRatios \[Rule] {1, 2, 0.5}, 
      ViewPoint \[Rule] {\(-2.5\), \ \(-1.5\), \ 1.5}, 
      AxesLabel \[Rule] {n, m, Binomial[n, m]}, 
      PlotLabel \[Rule] "\<binomial data\>", Mesh \[Rule] False, 
      FormatType \[Rule] TraditionalForm]; \)\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .58334 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% SurfaceGraphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0118343 1.01183 -0.182028 1.01183 [
[.5 .59584 -41 0 ]
[.5 .59584 41 15 ]
[-0.00109 .45241 -3.25858 0 ]
[-0.00109 .45241 2.74142 9 ]
[.0685 .49136 -3.22075 0 ]
[.0685 .49136 2.77925 9 ]
[.13424 .52816 -3.18547 0 ]
[.13424 .52816 2.81453 9 ]
[.19644 .56298 -3.1525 0 ]
[.19644 .56298 2.8475 9 ]
[.25538 .59598 -3.12161 0 ]
[.25538 .59598 2.87839 9 ]
[.13033 .59128 -5.30912 0 ]
[.13033 .59128 4.69088 15 ]
[.69308 .01838 -3.11241 -9 ]
[.69308 .01838 2.88759 0 ]
[.50751 .07732 -3.0075 -9 ]
[.50751 .07732 2.9925 0 ]
[.33382 .13249 -2.91138 -9 ]
[.33382 .13249 3.08862 0 ]
[.17093 .18425 -2.82298 -9 ]
[.17093 .18425 3.17702 0 ]
[.01783 .2329 -5.48283 -9 ]
[.01783 .2329 6.51717 0 ]
[.37757 .05581 -4.89107 -15 ]
[.37757 .05581 5.10893 0 ]
[.99507 .21056 0 -5.71684 ]
[.99507 .21056 6 3.28316 ]
[1.00094 .27647 0 -5.66556 ]
[1.00094 .27647 12 3.33444 ]
[1.00696 .34398 0 -5.61313 ]
[1.00696 .34398 18 3.38687 ]
[1.06462 .28769 0 -15.6798 ]
[1.06462 .28769 27 9.32021 ]
[ 0 0 0 0 ]
[ 1 .58334 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
gsave
.5 .59584 -102 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 15.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 15.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(binomial) show
117.000000 15.000000 moveto
(data) show
141.000000 15.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
.25 Mabswid
[ ] 0 setdash
0 .43981 m
.2559 .58334 L
s
0 .43981 m
.00054 .43351 L
s
[(1)] -0.00109 .45241 .08619 -1 Mshowa
.06943 .47875 m
.06989 .47244 L
s
[(2)] .0685 .49136 .07358 -1 Mshowa
.13502 .51554 m
.13541 .50923 L
s
[(3)] .13424 .52816 .06182 -1 Mshowa
.19708 .55035 m
.1974 .54404 L
s
[(4)] .19644 .56298 .05083 -1 Mshowa
.2559 .58334 m
.25615 .57702 L
s
[(5)] .25538 .59598 .04054 -1 Mshowa
.125 Mabswid
.01421 .44778 m
.01452 .444 L
s
.02825 .45565 m
.02856 .45187 L
s
.04213 .46344 m
.04243 .45966 L
s
.05586 .47114 m
.05615 .46736 L
s
.08284 .48627 m
.08311 .48249 L
s
.0961 .49371 m
.09637 .48993 L
s
.10922 .50107 m
.10947 .49728 L
s
.12219 .50834 m
.12243 .50456 L
s
.1477 .52265 m
.14793 .51887 L
s
.16025 .52969 m
.16047 .5259 L
s
.17266 .53665 m
.17287 .53286 L
s
.18494 .54354 m
.18514 .53975 L
s
.2091 .55709 m
.20928 .5533 L
s
.22098 .56376 m
.22116 .55997 L
s
.23274 .57035 m
.23291 .56656 L
s
.24438 .57688 m
.24454 .57309 L
s
gsave
.13033 .59128 -66.3091 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 15.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(n) show
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
.25 Mabswid
.79143 0 m
.01675 .2455 L
s
.69356 .03102 m
.69379 .03734 L
s
[(2)] .69308 .01838 .03747 1 Mshowa
.50754 .08996 m
.50755 .09629 L
s
[(4)] .50751 .07732 .0025 1 Mshowa
.33345 .14513 m
.33326 .15145 L
s
[(6)] .33382 .13249 -0.02954 1 Mshowa
.17018 .19687 m
.16981 .20319 L
s
[(8)] .17093 .18425 -0.05901 1 Mshowa
.01675 .2455 m
.01621 .2518 L
s
[(10)] .01783 .2329 -0.08619 1 Mshowa
.125 Mabswid
.64587 .04613 m
.64597 .04992 L
s
.59898 .06099 m
.59905 .06478 L
s
.55288 .0756 m
.55292 .07939 L
s
.46294 .1041 m
.46292 .10789 L
s
.41908 .118 m
.41902 .12179 L
s
.37592 .13168 m
.37583 .13547 L
s
.29166 .15838 m
.29152 .16217 L
s
.25053 .17141 m
.25036 .1752 L
s
.21004 .18424 m
.20984 .18803 L
s
.13094 .20931 m
.13069 .2131 L
s
.09229 .22156 m
.09202 .22534 L
s
.05423 .23362 m
.05393 .2374 L
s
.74207 .01564 m
.74225 .01943 L
s
gsave
.37757 .05581 -65.8911 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 15.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(m) show
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
.25 Mabswid
.98245 .20931 m
1 .40698 L
s
.98286 .21386 m
.97675 .21551 L
s
[(0)] .99507 .21056 -1 .27041 Mshowa
.9887 .27964 m
.98258 .28123 L
s
[(50)] 1.00094 .27647 -1 .25901 Mshowa
.99468 .34702 m
.98854 .34854 L
s
[(100)] 1.00696 .34398 -1 .24736 Mshowa
.125 Mabswid
.98401 .22689 m
.98035 .22787 L
s
.98518 .23998 m
.98151 .24096 L
s
.98634 .25314 m
.98268 .25411 L
s
.98752 .26636 m
.98385 .26732 L
s
.98988 .29299 m
.98621 .29393 L
s
.99107 .3064 m
.98739 .30733 L
s
.99227 .31987 m
.98859 .3208 L
s
.99347 .33341 m
.98979 .33433 L
s
.99589 .36069 m
.99221 .36159 L
s
.99711 .37443 m
.99342 .37532 L
s
.99834 .38823 m
.99465 .38912 L
s
.99957 .4021 m
.99588 .40298 L
s
gsave
1.06462 .28769 -61 -19.6798 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 33 translate 1 -1 scale
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
63.000000 18.000000 moveto
(J) show
71.375000 12.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(n) show
71.375000 26.000000 moveto
(m) show
0.000000 0.000000 0.000000 setrgbcolor
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
79.750000 18.000000 moveto
(N) show
1.000000 setlinewidth
%%DocumentNeededResources: font Math2Mono
%%DocumentNeededResources: + font Courier
%%DocumentNeededFonts: Math2Mono
%%DocumentNeededFont: + Courier
%%DocumentFonts: font Math2Mono
%%DocumentFonts: + font Courier
grestore
.25 Mabswid
.79143 0 m
.80356 .21601 L
s
.80356 .21601 m
0 .43981 L
s
0 .43981 m
.01675 .2455 L
s
.01675 .2455 m
.79143 0 L
s
.98245 .20931 m
.26315 .40439 L
s
.26315 .40439 m
.2559 .58334 L
s
.2559 .58334 m
1 .40698 L
s
1 .40698 m
.98245 .20931 L
s
.79143 0 m
.80356 .21601 L
s
.80356 .21601 m
1 .40698 L
s
1 .40698 m
.98245 .20931 L
s
.98245 .20931 m
.79143 0 L
s
.01675 .2455 m
.26315 .40439 L
s
.26315 .40439 m
.2559 .58334 L
s
.2559 .58334 m
0 .43981 L
s
0 .43981 m
.01675 .2455 L
s
0 0 m
1 0 L
1 .58334 L
0 .58334 L
closepath
clip
newpath
1 0 .357 r
.2724 .50942 .19708 .55035 .2559 .58334 .32983 .54383 Mtetra
.974 0 1 r
.21444 .4184 .13691 .48492 .19708 .55035 .2724 .50942 Mtetra
0 .949 1 r
.1548 .31628 .07891 .34986 .13691 .48492 .21444 .4184 Mtetra
.837 1 0 r
.09111 .23774 .01526 .26279 .07891 .34986 .1548 .31628 Mtetra
0 0 1 r
.35058 .41832 .2724 .50942 .32983 .54383 .40632 .43786 Mtetra
0 .429 1 r
.29264 .36128 .21444 .4184 .2724 .50942 .35058 .41832 Mtetra
0 1 .224 r
.23263 .28312 .1548 .31628 .21444 .4184 .29264 .36128 Mtetra
1 .969 0 r
.16929 .21192 .09111 .23774 .1548 .31628 .23263 .28312 Mtetra
0 1 0 r
.42877 .35325 .35058 .41832 .40632 .43786 .48256 .37485 Mtetra
0 1 .143 r
.37199 .31219 .29264 .36128 .35058 .41832 .42877 .35325 Mtetra
.429 1 0 r
.31251 .25037 .23263 .28312 .29264 .36128 .37199 .31219 Mtetra
1 .796 0 r
.24991 .1853 .16929 .21192 .23263 .28312 .31251 .25037 Mtetra
1 .929 0 r
.50808 .30621 .42877 .35325 .48256 .37485 .5601 .3356 Mtetra
.786 1 0 r
.45291 .26984 .37199 .31219 .42877 .35325 .50808 .30621 Mtetra
.929 1 0 r
.3946 .21802 .31251 .25037 .37199 .31219 .45291 .26984 Mtetra
1 .643 0 r
.33308 .15784 .24991 .1853 .31251 .25037 .3946 .21802 Mtetra
1 .418 0 r
.58925 .2709 .50808 .30621 .5601 .3356 .6397 .30791 Mtetra
1 .653 0 r
.5358 .23299 .45291 .26984 .50808 .30621 .58925 .2709 Mtetra
1 .704 0 r
.47905 .18607 .3946 .21802 .45291 .26984 .5358 .23299 Mtetra
1 .51 0 r
.41892 .12949 .33308 .15784 .3946 .21802 .47905 .18607 Mtetra
1 .214 0 r
.67275 .24238 .58925 .2709 .6397 .30791 .72167 .28449 Mtetra
1 .347 0 r
.621 .20042 .5358 .23299 .58925 .2709 .67275 .24238 Mtetra
1 .449 0 r
.56603 .15451 .47905 .18607 .5358 .23299 .621 .20042 Mtetra
1 .398 0 r
.50756 .10022 .41892 .12949 .47905 .18607 .56603 .15451 Mtetra
1 .153 0 r
.75885 .21693 .67275 .24238 .72167 .28449 .80613 .26165 Mtetra
1 .204 0 r
.70881 .17088 .621 .20042 .67275 .24238 .75885 .21693 Mtetra
1 .286 0 r
.65572 .12334 .56603 .15451 .621 .20042 .70881 .17088 Mtetra
1 .306 0 r
.59916 .06997 .50756 .10022 .56603 .15451 .65572 .12334 Mtetra
1 .143 0 r
.84768 .19201 .75885 .21693 .80613 .26165 .89315 .23812 Mtetra
1 .153 0 r
.79947 .14312 .70881 .17088 .75885 .21693 .84768 .19201 Mtetra
1 .194 0 r
.74831 .09255 .65572 .12334 .70881 .17088 .79947 .14312 Mtetra
1 .235 0 r
.69384 .0387 .59916 .06997 .65572 .12334 .74831 .09255 Mtetra
1 .143 0 r
.93934 .1663 .84768 .19201 .89315 .23812 .98286 .21386 Mtetra
.89315 .11582 .79947 .14312 .84768 .19201 .93934 .1663 Mtetra
1 .153 0 r
.84403 .06214 .74831 .09255 .79947 .14312 .89315 .11582 Mtetra
1 .184 0 r
.79178 .00636 .69384 .0387 .74831 .09255 .84403 .06214 Mtetra
0 g
.79143 0 m
.80356 .21601 L
s
.80356 .21601 m
0 .43981 L
s
0 .43981 m
.01675 .2455 L
s
.01675 .2455 m
.79143 0 L
s
.79143 0 m
.80356 .21601 L
s
.80356 .21601 m
1 .40698 L
s
1 .40698 m
.98245 .20931 L
s
.98245 .20931 m
.79143 0 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{299.062, 174.375},
  ImageMargins->{{48, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004[0000[PP10`4000010?ooooooc?ooZ_ooI_oo
<ooo0?o<ooo<c?o<VC/k>gYjN[Vi^OShn03ooeGooj[ooonI<onI0?mVoomVc?mVVOmVI_mV<omV0?lc
oclo?ginO[fm_Oclo5D00:X00?l00?l0VOl0I_l0<ol00<coolcoc<coVLcoIP<30d92@X61PL30`000
EED0EJX0EOl0ELbIolbIc<bIVLbII/bI<lbI0<aVolaVc0L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0Z/`c
<l`c0<`0ol`0c<`0VL`0I/`0<l`000/;2dY:BXV9RLS8b000oeD0ojX0ool0oiW<VIW<IYW<<iW<09VI
oiVIc9VIVIVIIPl?3di>CXf=SLc<c01E05EE0:YE0?mE09TcoiTcc9TcVITcIYTc<iTc09T0oiT0c1<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEEFKo<fKo06K<ofK<c6K<VFK<IVK<<fK<01LG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZVIVVFIVIVIV<fIV06HcofHcc6HcVFHcIQ/K6eYJFYVIVMSHf01EoeEEojYEoomEoc?o
oc?oc3?oVC?oIS?o<c?o03?<oc?<c1lO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ03>I<c>I03=Voc=Vc3=V
VC=VIS=V<c=V02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZEC<0VC<0IS<0<c<0003oo`3oc03oV@3oIRLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2Io`2Ic02IV@2IIP2I<`2I001Vo`1Vc2/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`0c<`0c0000o`00c000V@00IP00<nh002l_;fi^KZf][Nc/k03o05Go0:[o0?oo0140
003^003M002k002Z0028001g001E03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@00M`00E@00A0008P00
4Nk^k]gMgK^k^cLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l0;0000?l0;0000?l0;0000?l0;0000:l0
1?mh0000/0000ol0001h0000/@000ol0001g0000/P000ol0000C00?oH0000:l000Co003o4P03o`80
00?o0000GP000;000_l@00?o0`0012=OoomO0000_`03o`<000QO8elSGol0oeh0001P0005o`3o0?l0
E`03o`<000`SGb=O8elSGomO0?mM0000H0001Ol0o`3o05<01?l2000AoelSGb=O8elSGb=OoelS0?l0
G000060000Go0?l0o`1@00?o100052=O8elSGb=O8elSGb=OoelSG`3oF`00060000Go0?l0o`1<00Co
100065lSGb=O8elSGb=O8elSGb=OoelSGb<0oeX0001O00KoBP03o`@001`SGb=O8elSGb=O8elSGb=O
8elSGomO8elSG`3oF@000:`00ol2000Ro`1O8elSGb=O8elSGb=O8elSGb=O8elSGomO8elSGb<0oeP0
002X00Co100095lS8elSGb=O8elSGb=O8elSGb=O8elSGb=O8olSGb=O8el0oeL0002U00?o1@07G`0Q
8elSGb=O8elSGb=O8elSGb=O8elSGb?o8elSGb=O8`3o05H0002200?o7@04o`@000UO8elSGb=O8el0
0R<08ElSGb=O8elSGb=O8elSGb=O8elSGb?o8elSGb=O8el0o`1E0000P`000ol0000I00?o1@0?G`0Q
8elSGb=O8elSGb=O8elSGb=O8elSob=O8elSGb=O8`3o05@0002100Co5`03o`D0015O8elSGb=O8elS
Gb=O8elSG`028`0PGb=O8elSGb=O8elSGb=O8elSGb?o8elSGb=O8elSGomD0000P@000ol0o`0D00Co
1@0GG`0P8elSGb=O8elSGb=O8elSGb=O8olSGb=O8elSGb=O8omC0000P@000ol0o`0A00?o0P007Ol0
001O8elSGb=O8elSGb=O8elSGb=O8elSGb=O008S021O8elSGb=O8elSGb=O8elSGb?o8elSGb=O8elS
Gb<0oe80002200;o3P03o`H07el062=O8elSGb=O8elSGb=O8elSob=O8elSG`8S00IO8elS0?mA0000
S`03o`L00Ul07R=O8elSGb=O8elSGb=O8elSGb=O8elSGb=O8elSG`8S021O8elSGb=O8elSGb=O8elS
ob=O8elSGb=O8elSGb<0oe00002<00?o1`0VG`0@8elSGb=O8elSGb=O8elSo`8S00iO8elSGb=O8elS
Gb<0odl0002800Co0P000ol0000200YO01hSGb=O8elSGb=O8elSGb=O8elSGb=O8elSGb=O8el28`0P
Gb=O8elSGb=O8elSGb?o8elSGb=O8elSGb=O8elS0?m>0000Q@03o`P0;Ul022=O8elSGb=O0R<05UlS
GomO8elSGb=O8elSGb=O8elS0?m=0000PP03o`P04Ul07R=O8elSGb=O8elSGb=O8elSGb=O8elSGb=O
8elSG`8S021O8elSGb=O8elSGb?o8elSGb=O8elSGb=O8elSGb<0od`0001o00?o00<0o`001@0fG`8S
01]O8elSGb=O8eooGb=O8elSGb=O8elSGb=O8el00P000ol000190000O003o`@000Co00006Ul07R=O
8elSGb=O8elSGb=O8elSGb=O8elSGb=O8elSG`8S01eO8elSGb=O8elSob=O8elSGb=O8elSGb=O8elS
G`020003o`0004P0001h00Co200hG`048elSG`8S01eO8elSGb=O8eooGb=O8elSGb=O8elSGb=O8elS
G`020003o`0004L0001F00;o7@03o`T011LNG`0N8elSGb=O8elSGb=O8elSGb=O8elSGb=O8elSGb=O
0R<07ElSGb=O8elSob=O8elSGb=O8elSGb=O8elSGb=O008000?o0000AP0005D000Co003o6@03o`80
00?o000010085c1O00`SGb=O8elSGb=O8el28`0OGb=O8elSGomO8elSGb=O8elSGb=O8elSGb=O8el0
o`180000E@001?l00?lF00?o2@0<5aiO01hSGb=O8elSGb=O8elSGb=O8elSGb=O8elSGb=O8el28`0O
Gb=O8elSGomO8elSGb=O8elSGb=O8elSGb=O8el0o`170000E@03oa@00ol8014G:5l052=O8elSGb=O
8elSGb=O8elSGb=O0R<07elSGb=O8olSGb=O8elSGb=O8elSGb=O8elSGb=O0?l0AP0005D000?o0000
4005o`L05ALNG`0N8elSGb=O8elSGb=O8elSGb=O8elSGb=O8elSGb=O0R<07elSGb=OoelSGb=O8elS
Gb=O8elSGb=O8elSGb=O0?l0A@0005H00ol<00?o2@0I5b1O01`SGb=O8elSGb=O8elSGb=O8elSGb=O
8elSGb=O0R<07elSGb?o8elSGb=O8elSGb=O8elSGb=O8elSGb=O0?l0A00006800ol901dG85l072=O
8elSGb=O8elSGb=O8elSGb=O8elSGb=O8el28`0OGb=OoelSGb=O8elSGb=O8elSGb=O8elSGb=O8el0
o`130000G`04o`P000<A5a407QLHG`0T8elSGb=O8elSGb=O8elSGb=O8elSGb=O8elSGb=O8elSGb=O
0R<07elSob=O8elSGb=O8elSGb=O8elSGb=O8elSGb=O0?l0@P0005`00ol20003o`0000@000LA5a4G
4ALA01hG85l072=O8elSGb=O8elSGb=O8elSGb=O8elSGb=O8el28`0OGomO8elSGb=O8elSGb=O8elS
Gb=O8elSGb=O8el0o`110000F@03o`T000/A5a4G4ALA5a4G4@0N5`iO02hSGb=O8elSGb=O8elSGb=O
8elSGb=O8elSGb=O8elSGb=O8elSGb=O8elSGb=O0R<07olSGb=O8elSGb=O8elSGb=O8elSGb=O8elS
Gb=O0?l0@00005D01?l9000?4ALA5a4G4ALA5a4G4ALA01hG85l0?B=O8elSGb=O8elSGb=O8elSGb=O
8elSGb=O8elSoelSGb=O8elSGb=O8elSGb=O8elSGb=O8elSGb=O0?l0?`0005800ol20003o`0000D0
01<A5a4G4ALA5a4G4ALA5a4G4ALA01hG1Ul0<b=O8elSGb=O8elSGb=O8elSGb=O8elSGb=O8elSGb=O
8elSGb=O8elSGb=O8elSGb=O8`02G`0R8olSGb=O8elSGb=O8elSGb=O8elSGb=O8elSGb=O8el0och0
001?00?o1@000ol00002000G4ALA5a4G4ALA5a4G4ALA5a4G4ALA5a407QLPG`0E8elSGb=O8elSGb=O
8elSGb=O8elS009O02HSGb=OoelSGb=O8elSGb=O8elSGb=O8elSGb=O8elSGb=O8el0ocd0000]00;o
7@03o`X001/A5a4G4ALA5a4G4ALA5a4G4ALA5a4G4ALA5a407AL0<Q4GGb=O8elSGb=O8elSGb=O8elS
Gb=O8elSGb=O8elSGb=O8elSGb=O8elSGb=O8elS0Ul0:R=O8elSGb?o8elSGb=O8elSGb=O8elSGb=O
8elSGb=O8elSGb=O8el0oc`0000/0004o`00oaT01?l9000OWa4A5a4G4ALA5a4G4ALA5a4G4ALA5a4G
4ALA5a4G4@0O5amO00`SGb=O8elSGb=O8el28`0^Gb=O8elSGb=O8eooGb=O8elSGb=O8elSGb=O8elS
Gb=O8elSGb=O8elSGb=Ooc`0000/0004o`00oaD01?l:00JO01dA5a4G4ALA5a4G4ALA5a4G4ALA5a4G
4ALA5a4G4@0E5`0a4ALA5a4G4ALA5elSGb=O8elSGb=O8elSGb=O8elSGb=O8elSGb=O8elSGb=O8elS
G`028`0bGb=O8elSGb=O8elSGb?o8elSGb=O8elSGb=O8elSGb=O8elSGb=O8elSGb=O8elSGolk0000
;@02oa<00ol;0009Wa6O4IlAWa6O008A01`G4ALA5a4G4ALA5a4G4ALA5a4G4ALA5a4G4ALA7aLOG`04
8elSG`8S03IO8elSGb=O8elSGb=O8elSGomO8elSGb=O8elSGb=O8elSGb=O8elSGb=O8elSGb=O8elS
0?lj0000;0001?l00?l?00Co2P0>W`0M4ALA5a4G4ALA5a4G4ALA5a4G4ALA5a4G4ALA5a403AL0<A4G
4ALA5a4G4ALA5a4G4ALA5elSGb=O8elSGb=O8elSGb=O8elSGb=O8elSGb=O8el00R<0>UlSGb=O8elS
Gb=O8elSGb=O8elSob=O8elSGb=O8elSGb=O8elSGb=O8elSGb=O8elSGb=O8elS0?li0000;@02o`d0
0ol30003o`0000D0016O4IlAWa6O4IlAWa6O4IlAW`024@0L5a4G4ALA5a4G4ALA5a4G4ALA5a4G4ALA
5a4G4AlG6el00b=O8`02G`0k8elSGb=O8elSGb=O8elSGb=O8eooGb=O8elSGb=O8elSGb=O8elSGb=O
8elSGb=O8elSGb=O8elS0?l0>00003T00ol;01JO01dA5a4G4ALA5a4G4ALA5a4G4ALA5a4G4ALA5a4G
4@055`0h4ALA5a4G4ALA5a4G4ALA5a4G4ALA5a4G4ALA8elSGb=O8elSGb=O8elSGb=O8elSGb=O8elS
Gb<2G`0k8elSGb=O8elSGb=O8elSGb=O8olSGb=O8elSGb=O8elSGb=O8elSGb=O8elSGb=O8elSGb=O
8elS0?l0=`0003D01?l;000IWa6O4IlAWa6O4IlAWa6O4IlAWa6O4IlAW`024@0L5a4G4ALA5a4G4ALA
5a4G4ALA5a4G4ALA5a4G4B0G4Ul02b=O8elSGb=O8elS009O03/SGb=O8elSGb=O8elSGb=O8elSob=O
8elSGb=O8elSGb=O8elSGb=O8elSGb=O8elSGb=O8elSGb<0o`0f0000<P03o`<000?o00001P0NW`1J
4ALA5a4G4ALA5a4G4ALA5a4G4ALA5a4G4ALA1Il54ALA5a4G4ALA5a4G4ALA5a4G4ALA5a4G4ALA5a4G
4B=O8elSGb=O8elSGb=O8elSGb=O8elSGb=O8elS0Ul0>b=O8elSGb=O8elSGb=O8elSGomO8elSGb=O
8elSGb=O8elSGb=O8elSGb=O8elSGb=O8elSGb=O8`3o03D0000_00?o30008Il5W`FO4IlAWa6O4IlA
Wa6O4IlAWa6O4IlAWa6O4IlAW`024@0F5a4G4ALA5a4G4ALA5a4G4ALA5a4G4@NO7aL:G`0C8elSGb=O
8elSGb=O8elSGb=O8`02G`0k8elSGb=O8elSGb=O8elSGb?o8elSGb=O8elSGb=O8elSGb=O8elSGb=O
8elSGb=O8elSGb=O8elS0?l0=00002`00ol<0008W`FO1Il5W`DNW`1K4ALA5a4G4ALA5a4G4ALA5a4G
4@FO1Il5W`FO1Il54ALA5a4G4ALA5a4G4ALA5a4G4ALA5a4G4ALA5a4G4B=O8elSGb=O8elSGb=O8elS
Gb=O8elSGb=O8elSG`028`0jGb=O8elSGb=O8elSGb=OoelSGb=O8elSGb=O8elSGb=O8elSGb=O8elS
Gb=O8elSGb=O8elSGb<0o`L00_lZ0000:@03o`8000?o00001`00:Il5W`FO1Il5W`FO1IlAWa6O4IlA
Wa6O4IlAWa6O4IlAWa6O4IlAWa6O008A00lG4ALA5a4G4ALA5a4G4AL03YlO5`9O01`SGb=O8elSGb=O
8elSGb=O8elSGb=O8elSGb=O0R<0>UlSGb=O8elSGb=O8elSob=O8elSGb=O8elSGb=O8elSGb=O8elS
Gb=O8elSGb=O8elSGb=O8elS0?l50004o`00obT0000300?o1002oaT01?l50003o`0000@0012O1Il5
W`FO1Il5W`FO1Il57Yl0Fa4G4ALA5a4G4ALA5il5W`FO1Il5W`FO1Il5W`FO1IlG4ALA5a4G4ALA5a4G
4ALA5a4G4ALA5a4G4ALA5elGGb=O8elSGb=O8elSGb=O8elSGb=O8elSGb=O8el00R<0>UlSGb=O8elS
Gb=O8eooGb=O8elSGb=O8elSGb=O8elSGb=O8elSGb=O8elSGb=O8elSGb=O8elS0?l40004o`00obT0
00040003o`00008000Co003o5@03o`d0036O1Il5W`FO1Il5W`FO1Il5W`FO1IlAWa6O4IlAWa6O4IlA
Wa6O4IlAWa6O4IlAWa6O008A00PG4ALA5a4G4AJO61L8G`0L8elSGb=O8elSGb=O8elSGb=O8elSGb=O
8elSG`8S03QO8elSGb=O8elSGb?o8elSGb=O8elSGb=O8elSGb=O8elSGb=O8elSGb=O8elSGb=O8elS
Gb=O8`;o0`001?l00?lY000010000ol000020004o`00oa800ol20003o`0000P001RO1Il5W`FO1Il5
W`FO1Il5W`FO1Il5W`DNW`1K4ALA5a45W`FO1Il5W`FO1Il5W`FO1Il5W`FO1Il5WaLA5a4G4ALA5a4G
4ALA5a4G4ALA5elGGaMO5elGGaMO8elSGb=O8elSGb=O8elSGb=O8elSGb=O8elSG`028`0iGb=O8elS
Gb=O8eooGb=O8elSGb=O8elSGb=O8elSGb=O8elSGb=O8elSGb=O8elSGb=O8elSGb?o00<000Co003o
:@0000@000?o00000P001?l00?l?00?o3@021@0gW`FO1Il5W`FO1Il5W`FO1Il5W`FO1Il5W`FO4IlA
Wa6O4IlAWa6O4IlAWa6O4IlAWa6O4IlAW`024AjO4AL?G`0L8elSGb=O8elSGb=O8elSGb=O8elSGb=O
8elSG`8S00QO8elSGb=O8`Co02aO8elSGb=O8elSGb=O8elSGb=O8elSGb=O8elSGb=O8elSGb=O8elS
Gol0o`@00_lZ000010000ol000020004o`00o``00ol=00H501ZO1Il5W`FO1Il5W`FO1Il5W`FO1Il5
W`FO1AbO05[N1Mh5W`FO1Il5W`FO1Il5W`FO1Il5W`FO1Il5W`FO1Il54ALA5a4G4ALA5a4GGaMO5elG
GaMO5elGGaMO5elGGb=O8elSGb=O8elSGb=O8elSGb=O8elSGb<2G`078elSGb=O8`03o`0Y8elSGomO
8elSGb=O8elSGb=O8elSGb=O8elSGb=O8elSGb=O8elSGb<01P000ol0000^00000`02o`D00_l900Co
00<0o`002P0:1@0cW`FO1Il5W`FO1Il5W`FO1Il5W`FO1Il5W`FO4IlAWa6O4IlAWa6O4IlAWa6O4IlA
Wa6O00H57il95aIO01DSGb=O8elSGb=O8elSGb=O8elSGb<00Ul01R=O8elSG`Co02PSGb=O8elSGomO
8elSGb=O8elSGb=O8elSGb=O8elSGb=O8elSGb=O2P000ol0000^00004P03o`d03`D06Yl5W`FO1Il5
W`FO1Il5W`FO1Il5W`FO1Il55Il0F@GN1Mh5gPGN1Mh5W`FO1Il5W`FO1Il5W`FO1Il5W`FO1Il5W`FO
1Il54ALA5a4GGaMO5elGGaMO5elGGaMO5elGGaMO5elGGb=O8elSGb=O8elSGb=O8elS009O00DSGb=O
8`04o`0YGb=O8elSGb=O8elSGomO8elSGb=O8elSGb=O8elSGb=O8elSGb=O8el03002oc00000?00?o
3@0C1@0/W`FO1Il5W`FO1Il5W`FO1Il5W`FO1Il5W`FO4IlAWa6O4IlAWa6O4IlAWa4=1AnO00<GGel0
75l03B=O8elSGb=O8elSGb<00Ul01B=O8elS00?o02TSGb=O8elSGb=O8elSGb=O8eooGb=O8elSGb=O
8elSGb=O8elSGb=O8`0A0003o`0002h0000<00?o0P000ol0000801L501ZO1Il5W`FO1Il5W`FO1Il5
W`FO1Il5W`FO1@nO05L5gPGN1Mh5gPGN1Mh5gPGN1Il5W`FO1Il5W`FO1Il5W`FO1Il5W`FO1Il5W`FO
4IlGGaMO5elGGaMO5elGGaMO5elGGaMO5elGGaMO5elSGb=O8elSGb<00Ul012=O8el4o`0X8elSGb=O
8elSGb=O8elSGb=O8elSGomO8elSGb=O8elSGb=O8elSGaH000?o0000;@0000T00ol=0003gPD501P5
02JO1Il5W`FO1Il5W`FO1Il5W`FO1Il5W`FO1IlAWa6O4IlAWa6O4A<589lNG`058elSGb<00Ul012=O
8el3o`0XGb=O8elSGb=O8elSGb=O8elSGb=O8elSGb=OoelSGb=O8elSGb=O8aT00_lN0005o`3o0?l0
300000L00_l=0005gPGN1Mh06PD06Yl5W`FO1Il5W`FO1Il5W`FO1Il5W`FO1Il52Il0E@GN1Mh5gPGN
1Mh5gPGN1Mh5gPGN1Mh5W`FO1Il5W`FO1Il5W`FO1Il5W`FO4IlAWa6O4IlAWaMO5elGGaMO5elGGaMO
5elGGaMO5elGGaMO5elGGb<00Ul00b=O8`04o`0XGb=O8elSGb=O8elSGb=O8elSGb=O8elSGb=O8elS
GomO8elSGb=O8ad000?o000070001Ol0o`3o00`000070003o`3o00T000WN1Mh5gPGN1Mh06PD07il5
W`FO1Il5W`FO1Il5W`FO1Il5W`FO1Il5Wa6O4Il06`DPWa]O00<SGb<01?l0:2=O8elSGb=O8elSGb=O
8elSGb=O8elSGb=O8elSGb=O8elSGomO8elQ0003o`0001L000?o00000P001Ol0o`3o00<000?o0000
1P0000L000?o00000_l4000=gPGN1Mh5gPGN1Mh5gP0J1@0JW`FO1Il5W`FO1Il5W`FO1Il5W`FO1Il5
W`D2W`1DgPGN1Mh5gPGN1Mh5gPGN1Mh5gPGN1Mh5gPGN1Mh5W`FO1Il5W`FO1Il5W`FO4IlAWa6O4IlA
Wa6O4IlAWa5O5elGGaMO5elGGaMO5elGGaMO5elG15l3o`0ZGb=O8elSGb=O8elSGb=O8elSGb=O8elS
Gb=O8elSGb=O8elSGb=O8eoo8P02oaP000?o00000`001Ol0o`3o00@000?o00001@0000L000?o0000
0P004_l01Mh5gPGN1Mh5gPGN1Mh5gQX501VO1Il5W`FO1Il5W`FO1Il5W`FO1Il5W`FO009a7`DPWa=O
00<SGol00ol012=O8el28`0RGb=O8elSGb=O8elSGb=O8elSGb=O8elSGb=O8elSGb=O8`D000?o0000
80000ol0000F0003o`0000801_l40003o`0000D00007000Fo`0000GN1Mh5gPGN1Mh5gPGN1Mh5gQ`5
01FO1Il5W`FO1Il5W`FO1Il5W`FO1Il01W40C@GN1Mh5gPGN1Mh5gPGN1Mh5gPGN1Mh5gPGN1Mh5gPFO
1Il5W`FO1IlAWa6O4IlAWa6O4IlAWa6O4IlAWa6O4ElGGaMO5elGGaMO5elG00=O0ol:G`0O8elSGb=O
8elSGb=O8elSGb=O8elSGb=O8elSGb=O8`090003o`0001l000?o00005P000ol0000<0003o`0000D0
0007000Go`GN1Mh5gPGN1Mh5gPGN1Mh5gPGN1Mh06PD04il5W`FO1Il5W`FO1Il5W`FO1Il02W4O1B6O
2Ul00b?oo`02o`0=Gb=O8elSGb=O8elSG`028`0IGb=O8elSGb=O8elSGb=O8elSGb=O8elSG`0>0003
o`0001h000?o00000P03o`@00_l:0003o`0000h000?o0000100000L001SogPGN1Mh5gPGN1Mh5gPGN
1Mh5gPGN1MhJ1@0@W`FO1Il5W`FO1Il5W`FO1@ea04H5gPGN1Mh5gPGN1Mh5gPGN1Mh5gPGN1Mh5gPGN
1Mh5Wa6O4IlAWa6O4IlAWa6O4IlAWa6O4IlAWa6O4IlAWa6O5elGGaMO1?lEG`0C8elSGb=O8elSGb=O
8elSGb=O8`0C0003o`0001`00_l70004o`00o`8000?o00001`000ol0000>0003o`0000@00006000J
o`05gPGN1Mh5gPGN1Mh5gPGN1Mh5gPGN1MhJ1@0<W`FO1Il5W`FO1Il54G4M1@03gPGN022O0Ul3o`0H
Gb=O8elSGb=O8elSGb=O8elSGb=O8elS0Ul03b=O8elSGb=O8elSGb=O8`0G0003o`0001`000?o0000
1@001?l00?l20003o`0000L000?o00003P000ol0000400001P006ol000GN1Mh5gPGN1Mh5gPGN1Mh5
gPGN1Mh5gP0J1@09W`FO1Il5W`FO01Aa01T5gPGN1Mh5gPGN1Mh5gPGN1Mh5gPGN1Mh500ON01dAWa6O
4IlAWa6O4IlAWa6O4IlAWa6O4IlAWa6O4@04oaiO00XSGb=O8elSGb=O70000ol0000K0003o`000080
0ol30004o`00o`T000?o00003P000ol0000400001P007?l00005gPGN1Mh5gPGN1Mh5gPGN1Mh5gPGN
1MhJ1@05W`FO1Il0674G1@0:gPGN1Mh5gPGN1ANO1?l55`0LGb=O8elSGb=O8elSGb=O8elSGb=O8elS
Gb=O8`9O00DSGb=O8`0Q0003o`0001T00_l40003o`0000<000Co003o2@000ol0000>0003o`0000@0
0006000Mo`000=h5gPGN1Mh5gPGN1Mh5gPGN1Mh5gPGN1Mh06PD00imaL@0JL@0E1Mh5gPGN1Mh5gPGN
1Mh5gPGN1Mh500cN01>O4IlAWa6O4IlAWa6O4IlAWa6O00?o2aLMG`038`0002<000?o00006@000ol0
000200Co0`02o`X000?o00003P000ol0000400001P000ol00002000IgPGN1Mh5gPGN1Mh5gPGN1Mh5
gPGN1Mh5gP0H1@03k75a01aa4`D03]h5gPGN1Mh5gPGN1Mh53Yl4o`03WaLG00`G01TSGb=O8elSGb=O
8elSGb=O8elSGb=O8elS02X000?o00006@000ol0000D0003o`0000h000?o0000100000H000?o0000
0`006Mh5gPGN1Mh5gPGN1Mh5gPGN1Mh5gPGN1Mh050D5k1ia00l5gPGN1Mh5gPGN1Mh5gPD04mh02A6O
4IlAWa6O4@03o`034IlA018G55l^0003o`0001L00_lF0003o`0000h000?o0000100000H000?o0000
0`006PGN1Mh5gPGN1Mh5gPGN1Mh5gPGN1Mh5gPGN4@D02=c/g>cLk=c/7W4=1@0EgPGN1Mh5gPGN1Mh5
gPGN1Mh5gPGN00BO1?l4WaDG011O8elSGb=O8elSGb=O8elS<P000ol0000G0003o`0001@000?o0000
1002o`030?oo00D000?o0000100000H000?o0000100060GN1Mh5gPGN1Mh5gPGN1Mh5gPGN1Mh5gQ05
2n`NL@091Mh5gPGN1Mh501SN1?l01YlAWa6O4APG2elg0003o`0001H000?o00005@000ol000030004
o`00o`D000?o00001@0000H000?o00001@0060GN1Mh5gPGN1Mh5gPGN1Mh5gPGN1Mh5gP`500o/g>cL
k=c/g>cLk=c/g>`07W471@0FgPGN1Mh5gPGN1Mh5gPGN1Mh5gPGN1@?o00<5gPD019lM5`068elSGb=O
>`000ol0000E0003o`0001D000?o00000`001?l00?l50003o`0000D000060003o`0000H001P5gPGN
1Mh5gPGN1Mh5gPGN1Mh5gPGN1Mh91A;/7W400`GN1@0EgPCo1mh00ilG5`0N5`9O?`000ol0000C00;o
5`000ol000030004o`00o`D000?o00001@0000H000?o00001P006Mh5gPGN1Mh5gPGN1Mh5gPGN1Mh5
gPGN1Mh01PD05>cLk=c/g>cLk=c/g>cLk=c/g>cL7g4050GN1Mh5gPGN1Mh5gPGN1Mh5gPGN0ol02Mh5
gPGN1Mh5gP041AhG@`000ol0000C0003o`0001H000Co00001Ol40003o`0000H000060003o`0000L0
01WN1Mh5gPGN1Mh5gPGN1Mh5gPGN1Mh5gPGN00856>`ML@03k=c/00kN1?l;gP071Il5W`FO1@0I5dL0
00?o00004P000ol0000/00001@000ol00009000cgPGN1Mh5gPGN1Mh5gPGN1Mh5gPGN1Mh53NcLk=c/
g>cLk=c/g>cLk=c/g>cLk=c/g>cL01Ya00oLk=c/g>cN1Mh5gPGN1Mh01?l030GN1Mh5gPGN1Mh5gP`5
51M;0003o`0001000_l^00001@000ol0000:000IgPGN1Mh5gPGN1Mh5gPGN1Mh5gPGN3L`=c00Jk1Qa
00WLk=c/g>cLk=`01=h3oa3N00jO1Il5W`FO1Il5W`FO1@lGC`000ol0000@0003o`0002`000050003
o`0000X001<5gPGN1Mh5gPGN1Mh5gPGN1Mh500H=01_Lk=c/g>cLk=c/g>cLk=c/g>cLk=c/g>cLk=`0
5G402ncLk=c/g>cLk=c/00Co017N1Mh5gPGN1Mh5gPGN1Mh5gP0A1@/GD`000ol0000?0003o`0002`0
00050003o`0000/001T5gPGN1Mh5gPGN1Mh5gPGN3L`=c0g<3L`=01_/4W402]c/g>cLk=c/g>`3o`03
k=cN013N01FO1Il5W`FO1Il5W`FO1Il5W`FO1Il01QMG0003o`0000h00_l300?o1002o`@00_lK0000
1@000ol0000<000<1Mh5gPGN1Mh5gPGN3@d06mc/g>cLk=c/g>cLk=c/g>cLk=c/g>cLk=c/g00@L@07
g>cLk=c/g004o`0Dk=c/g>cLk=h5gPGN1Mh5gPGN1MhI1@035`0005T000?o00003@02o`@000?o0000
0P001?l00?l20004o`00oaX000050003o`0000`001WN1Mh5gPGN1Mh5c0g<3L`=c0g<3L`=c0g<01_/
3W401NcLk=c/00Co00cLk=c/g>cLk=c/g>`:gP0JW`FO1Il5W`FO1Il5W`FO1Il5W`FO1Il5W`EN0003
o`0000d000?o00000P000ol000020004o`00o`8000Co003o6P0000D000?o00003@001mh5gPGN1Mh0
4Pd06ncLk=c/g>cLk=c/g>cLk=c/g>cLk=c/g>cLk00;L@04g>cLk0?o01S/g>cLk=c/g>cLk=c/g>cL
k=`5gPGN1MhJ1F4000?o000030000ol000020003o`00008000Co003o0P001?l00?lJ00001@000ol0
000>000HgPGN1L`=c0g<3L`=c0g<3L`=c0g<3L`=7>`9L@03g?oo00;o01K/g>cLk=c/g>cLk=c/g>cL
k=c/g>cL1=h06@FO1Il5W`FO1Il5W`FO1Il5W`FO1Il5W`D0I0000ol0000900?o10000ol000020004
o`00o`8000Co003o6P0000D000?o00003`000mh=3@0E3@0Lg>cLk=c/g>cLk=c/g>cLk=c/g>cLk=c/
g>cLk0Ia0ol06mc/g>cLk=c/g>cLk=c/g>cLk=c/g>cLk=c/g00J1FL000?o00002P001?l00002o`D0
0_l400;o6`0000D000?o00003`0060g<3L`=c0g<3L`=c0g<3L`=c0g<3L`=c1g/00=aool00_l07=c/
g>cLk=c/g>cLk=c/g>cLk=c/g>cLk=c/g>`4g00FW`FO1Il5W`FO1Il5W`FO1Il5W`FO1FX000?o0000
2@000ol0000[00001@000ol0000@01P=01W/g>cLk=c/g>cLk=c/g>cLk=c/g>cLk=c/00Co01mag>cL
k=c/g>cLk=c/g>cLk=c/g>cLk=c/g>cLk=c/00OL4PE]0003o`0000P000?o0000:`0000D000?o0000
40006L`=c0g<3L`=c0g<3L`=c0g<3L`=c0g<3L`05N`3o`?/01o0g>cLk=c/g>cLk=c/g>cLk=c/g>cL
k=c/g>cLk=c/00[L00jO1Il5W`FO1Il5W`FO1G0000?o00001P02obd000050003o`0001006@d04Mc/
g>cLk=c/g>cLk=c/g>cL00Co00G/g>cLk003aP0Lg>cLk=c/g>cLk=c/g>cLk=c/g>cLk=c/g>cLk0kL
2@Ec0003o`0000H000?o0000:`0000@000?o00004P006@g<3L`=c0g<3L`=c0g<3L`=c0g<3L`=c0d0
3N`3o`S/01o0a/36`=c/g>cLk=c/g>cLk=c/g>cLk=c/g>cLk=c/017L00D5W`FO1@1f0003o`0000D0
00?o0000:`0000@000?o00004P0I3@09k=c/g>cLk=c/00Co00WLk=c/g>cLk=`02<H06=c/g>cLk=c/
g>cLk=c/g>cLk=c/g>cLk1CL00<50000M`000ol0000400;o;00000@000?o00004`006L`=c0g<3L`=
c0g<3L`=c0g<3L`=c0g<3L`01>`4o`c/0236`<K0a/36`<K0g>cLk=c/g>cLk=c/g>cLk=c/g>cLk1CL
O0000ol000030003o`0002/000040003o`0001<06Pd3o`0?g>cLk=c/g>cLk=c/g>cL00c601CLk=c/
g>cLk=c/g>cLk=c/g>cLk1CLOP000ol000020003o`0002/000040003o`0001@001D=c0g<3L`=c0g<
3L`=c0g<3L`=c0d01?l@k00Q`<K0a/36`<K0a/36`<K0g>cLk=c/g>cLk=c/g>cLk=c/01CLP0001?l0
0002ob`000040003o`0001@04@d4o`D=00kLk=c/g>cLk=c/g>cLk176013Lk=c/g>cLk=c/g>cLk=c/
5=b20005o`000?l0;00000@000?o000050003Pg<3L`=c0g<3L`=c0g<0ol02L`=c0g<3L`=c00=k00Q
`<K0a/36`<K0a/36`<K0a/36`=c/g>cLk=c/g>cLk=c/01CLQ0001?l00?l/000010000ol0000E00T=
1?l=3@0:k=c/g>cLk=c/g1K600[Lk=c/g>cLk=c/5Mb70003o`3o02`000040003o`0001D000K<3L`=
c0d3o`0A3L`=c0g<3L`=c0g<3L`=c0d02N`08<K0a/36`<K0a/36`<K0a/36`<K0a/36`=c/g>cLk=c/
5Mb900;o;00000@000?o00005P000`goo`02oaD=00OLk=c/g>cL01[600KLk=c/g>`Eg8T00ol/0000
10000ol0000C00Co01[<3L`=c0g<3L`=c0g<3L`=c0g<3L`=c0g<3@C/0270a/36`<K0a/36`<K0a/36
`<K0a/36`<K0a/36`=c/g>`05Mb600Co;`0000@000?o00004003o`@06Pd00ncLk00OaP03g>cL01CL
PP05oc<000030003o`0000d01?l7000mc0g<3L`=c0g<3L`=c0g<3L`=c0g<3L`=c0g<k<36`<K0a/36
`<K0a/36`<K0a/36`<K0a/36`<K0a/36`00Eg7l01?lh00000`000ol0000:00?o2`0J3@03ClK60236
0]8Ag7d01?ll00000`000ol0000600Co3`0060g<3L`=c0g<3L`=c0g<3L`=c0g<3L`=c0=?0270a/36
`<K0a/36`<K0a/36`<K0a/36`<K0a/36`<K0a/001M8=g7X01?m000000`000ol0000200Co4`0G3@E?
7lH9dPWLMP05od@000030003o`3o00;o60005L`=c0g<3L`=c0g<3L`=c0g<3L`=c006C`0Na/36`<K0
a/36`<K0a/36`<K0a/36`<K0a/36`<K03M85g7<01?m900000`02oa/04`d9Cac64M800m`0001^00Co
C@0000D00olI000A3L`=c0g<3L`=c0g<3L`=c0d02Tl06l36`<K0a/36`<K0a/36`<K0a/36`<K0a/36
`00BdVd01?mA00001`000ol0000G010=34lIaQ?BJ005oeD0000800?o5P003`g<3L`=c0g<3L`=c0g<
3@0>C`0G`<K0a/36`<K0a/36`<K0a/36`<K0a/004m9U00CoFP0000X00_lF00`=44lFaQ?BHP04oeh0
000<00?o4`002l`=c0g<3L`=c0g<019?01G6`<K0a/36`<K0a/36`<K0a/36`<H04]9O00CoHP000004
0?ooo`X00_lC00T=4dlDaQ?BFP05ofH000020003o`0000/00_lA00083L`=c0g<3L`EC`0B`<K0a/36
`<K0a/36`<K0a/364m9G00CoJ`00008000?o00003002o`8000?o000030053AQ?4<HCdU@01?m_0000
0P000ol0000>00?o3P001<`=c0dIC`0?a/36`<K0a/36`<K0a/3601CBD004og<000020003o`0000l0
0ol=00<=6dl=aQCBC005ogL000000`3oo`0D00;o30000`e?C`0JC`0<`<K0a/36`<K0a/365=9900Co
O00001P00_l;01i?2lHCdTH01?n000006P02o`X07Tl02L36`<K0a/36`00DdT801?n400006`03o`T0
7Dl8aQCB?P05ohP0000N00;o200MC`06a/36`<K05=8k00CoS@0001801?l80005o`3o0?l01P0LC`G6
5=8h00CoT@0001<000?o00002`02o`L074l00l36`00EdS@01?nE000050000ol0000<00?o1@0LC`03
a];B01?B<005oiT0000E0003o`0000d00_l501Y?0blCdRd01?nN00004P001?l00?lA00;o100GC`07
;b4_8BlQ;`0@dRX01?nR00004`02oa<00_l401A?2bl>dRH01?nV0000:P02o`<04Tl03R4_8BlQ;b4_
8BlQ;b4_2m8R00GoZP0002/00ol200m?4Bl9dQl01?n_0000;P02o`0304m?00Y?01DQ;b4_8BlQ;b4_
8BlQ;b4_8BlQ;b401m8K00Co/`0002<00ol:0003o`1?00Q?6Bl4dQP01?ng00009P000ol0000800;o
1Tl07R4_8BlQ;b4_8BlQ;b4_8BlQ;b4_8BlQ;b4_8BlQdQ@01Onk00009P000ol0000:0003odm?009?
7BlB00Co`00002@00_l?000NCblQ;b4_8BlQ;b4_8BlQ;b4_8BlQ;b4_8BlQ;b4_4004ol@0000V0003
o`0000h06Rl>00Cob00002<00olB000Gob4_8BlQ;b4_8BlQ;b4_8BlQ;b4_8Bl02`05ol`0000j01<_
2@04om40000l000@;b4_8BlQ;b4_8BlQ;b4_8@H01?oE0000?P0<;`@01?oI0000<`03o`X000T_8BlQ
;b4_8@001OoM0000=0000ol000090003obl_00<_0ooR0000<P04o`d000<Qo`00i@00038000?o0?l0
mP00038000?o0?l0mP0003<00_of0000o`0/0000o`0/0000@@03onL0000R00;o00<0ool07@000ol0
003T00008P001?l00?lN0003o`0001@01?l200Go00@0ool00_l200?o0P001_l0o`3o00Go00<0ool0
0ol00`3oo`03o`P02_l200?o0P05oh<0000R0004o`00oa/00olG0005o`000?l00`001Ol0003o0080
00Co003o0`001ol0o`3o0?l00`001Ol0003o008000?o00000P000ol000070007o`000?l0o`020005
o`000?l00P000ol0o`020003o`000880000R0004o`00oa/000?o00005`001Ol0003o00<000Go0000
o`020004o`00o`<000Oo0?l0o`3o00<000Co00001?l40003o`0000L000Ko0000o`04o`<000?o0000
0P04oh@0000Q00Go6`04oaH000Go0000o`030005o`000?l00P001?l00?l30007o`3o0?l0o`030003
o`0000@000?o00000P000ol000070005o`000?l010001Ol0003o00L000?o0000PP0005/01?l300;o
0P05o`<00ol00`3oo`04o`800_l400?o10000ol0000800Co0P03o`801?l300?oQ00005/000?o0000
:@000ol0000;0003o`0000H000?o0000RP0005X00_l70003o`0001D000?o00001`03o``00_l80003
o`0008X0003o02`0003o02`0003o02`0003o02`0003o02`0003o02`00000\
\>"],
  ImageRangeCache->{{{0, 298.062}, {173.375, 0}} -> {-0.00220243, 0.15428, 
  0.00393295, 0.00393295}}]
}, Closed]],

Cell[BoxData[
    \(Clear[newdata]\)], "Input"],

Cell[TextData[{
  "Similarly, we can create density plots and contour plots from lists of \
data, using ",
  StyleBox["ListDensityPlot", "Input"],
  " and ",
  StyleBox["ListContourPlot", "Input"],
  ". ",
  StyleBox["ListDensityPlot", "Input"],
  " is useful for plotting digitized image data."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(ListDensityPlot[
      ReadList["\<icondata.dat\>", Number, RecordLists \[Rule] True]]; \)\)], 
  "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% DensityGraphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0192308 0.0300481 0.0192308 0.0300481 [
[.01923 -0.0125 -3 -9 ]
[.01923 -0.0125 3 0 ]
[.16947 -0.0125 -3 -9 ]
[.16947 -0.0125 3 0 ]
[.31971 -0.0125 -6 -9 ]
[.31971 -0.0125 6 0 ]
[.46995 -0.0125 -6 -9 ]
[.46995 -0.0125 6 0 ]
[.62019 -0.0125 -6 -9 ]
[.62019 -0.0125 6 0 ]
[.77043 -0.0125 -6 -9 ]
[.77043 -0.0125 6 0 ]
[.92067 -0.0125 -6 -9 ]
[.92067 -0.0125 6 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .01923 -6 -4.5 ]
[-0.0125 .01923 0 4.5 ]
[-0.0125 .16947 -6 -4.5 ]
[-0.0125 .16947 0 4.5 ]
[-0.0125 .31971 -12 -4.5 ]
[-0.0125 .31971 0 4.5 ]
[-0.0125 .46995 -12 -4.5 ]
[-0.0125 .46995 0 4.5 ]
[-0.0125 .62019 -12 -4.5 ]
[-0.0125 .62019 0 4.5 ]
[-0.0125 .77043 -12 -4.5 ]
[-0.0125 .77043 0 4.5 ]
[-0.0125 .92067 -12 -4.5 ]
[-0.0125 .92067 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.01923 0 m
.01923 .00625 L
s
[(0)] .01923 -0.0125 0 1 Mshowa
.16947 0 m
.16947 .00625 L
s
[(5)] .16947 -0.0125 0 1 Mshowa
.31971 0 m
.31971 .00625 L
s
[(10)] .31971 -0.0125 0 1 Mshowa
.46995 0 m
.46995 .00625 L
s
[(15)] .46995 -0.0125 0 1 Mshowa
.62019 0 m
.62019 .00625 L
s
[(20)] .62019 -0.0125 0 1 Mshowa
.77043 0 m
.77043 .00625 L
s
[(25)] .77043 -0.0125 0 1 Mshowa
.92067 0 m
.92067 .00625 L
s
[(30)] .92067 -0.0125 0 1 Mshowa
.125 Mabswid
.04928 0 m
.04928 .00375 L
s
.07933 0 m
.07933 .00375 L
s
.10938 0 m
.10938 .00375 L
s
.13942 0 m
.13942 .00375 L
s
.19952 0 m
.19952 .00375 L
s
.22957 0 m
.22957 .00375 L
s
.25962 0 m
.25962 .00375 L
s
.28966 0 m
.28966 .00375 L
s
.34976 0 m
.34976 .00375 L
s
.37981 0 m
.37981 .00375 L
s
.40986 0 m
.40986 .00375 L
s
.4399 0 m
.4399 .00375 L
s
.5 0 m
.5 .00375 L
s
.53005 0 m
.53005 .00375 L
s
.5601 0 m
.5601 .00375 L
s
.59014 0 m
.59014 .00375 L
s
.65024 0 m
.65024 .00375 L
s
.68029 0 m
.68029 .00375 L
s
.71034 0 m
.71034 .00375 L
s
.74038 0 m
.74038 .00375 L
s
.80048 0 m
.80048 .00375 L
s
.83053 0 m
.83053 .00375 L
s
.86058 0 m
.86058 .00375 L
s
.89063 0 m
.89063 .00375 L
s
.95072 0 m
.95072 .00375 L
s
.98077 0 m
.98077 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .01923 m
.00625 .01923 L
s
[(0)] -0.0125 .01923 1 0 Mshowa
0 .16947 m
.00625 .16947 L
s
[(5)] -0.0125 .16947 1 0 Mshowa
0 .31971 m
.00625 .31971 L
s
[(10)] -0.0125 .31971 1 0 Mshowa
0 .46995 m
.00625 .46995 L
s
[(15)] -0.0125 .46995 1 0 Mshowa
0 .62019 m
.00625 .62019 L
s
[(20)] -0.0125 .62019 1 0 Mshowa
0 .77043 m
.00625 .77043 L
s
[(25)] -0.0125 .77043 1 0 Mshowa
0 .92067 m
.00625 .92067 L
s
[(30)] -0.0125 .92067 1 0 Mshowa
.125 Mabswid
0 .04928 m
.00375 .04928 L
s
0 .07933 m
.00375 .07933 L
s
0 .10938 m
.00375 .10938 L
s
0 .13942 m
.00375 .13942 L
s
0 .19952 m
.00375 .19952 L
s
0 .22957 m
.00375 .22957 L
s
0 .25962 m
.00375 .25962 L
s
0 .28966 m
.00375 .28966 L
s
0 .34976 m
.00375 .34976 L
s
0 .37981 m
.00375 .37981 L
s
0 .40986 m
.00375 .40986 L
s
0 .4399 m
.00375 .4399 L
s
0 .5 m
.00375 .5 L
s
0 .53005 m
.00375 .53005 L
s
0 .5601 m
.00375 .5601 L
s
0 .59014 m
.00375 .59014 L
s
0 .65024 m
.00375 .65024 L
s
0 .68029 m
.00375 .68029 L
s
0 .71034 m
.00375 .71034 L
s
0 .74038 m
.00375 .74038 L
s
0 .80048 m
.00375 .80048 L
s
0 .83053 m
.00375 .83053 L
s
0 .86058 m
.00375 .86058 L
s
0 .89063 m
.00375 .89063 L
s
0 .95072 m
.00375 .95072 L
s
0 .98077 m
.00375 .98077 L
s
.25 Mabswid
0 0 m
0 1 L
s
.01923 .99375 m
.01923 1 L
s
.16947 .99375 m
.16947 1 L
s
.31971 .99375 m
.31971 1 L
s
.46995 .99375 m
.46995 1 L
s
.62019 .99375 m
.62019 1 L
s
.77043 .99375 m
.77043 1 L
s
.92067 .99375 m
.92067 1 L
s
.125 Mabswid
.04928 .99625 m
.04928 1 L
s
.07933 .99625 m
.07933 1 L
s
.10938 .99625 m
.10938 1 L
s
.13942 .99625 m
.13942 1 L
s
.19952 .99625 m
.19952 1 L
s
.22957 .99625 m
.22957 1 L
s
.25962 .99625 m
.25962 1 L
s
.28966 .99625 m
.28966 1 L
s
.34976 .99625 m
.34976 1 L
s
.37981 .99625 m
.37981 1 L
s
.40986 .99625 m
.40986 1 L
s
.4399 .99625 m
.4399 1 L
s
.5 .99625 m
.5 1 L
s
.53005 .99625 m
.53005 1 L
s
.5601 .99625 m
.5601 1 L
s
.59014 .99625 m
.59014 1 L
s
.65024 .99625 m
.65024 1 L
s
.68029 .99625 m
.68029 1 L
s
.71034 .99625 m
.71034 1 L
s
.74038 .99625 m
.74038 1 L
s
.80048 .99625 m
.80048 1 L
s
.83053 .99625 m
.83053 1 L
s
.86058 .99625 m
.86058 1 L
s
.89063 .99625 m
.89063 1 L
s
.95072 .99625 m
.95072 1 L
s
.98077 .99625 m
.98077 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .01923 m
1 .01923 L
s
.99375 .16947 m
1 .16947 L
s
.99375 .31971 m
1 .31971 L
s
.99375 .46995 m
1 .46995 L
s
.99375 .62019 m
1 .62019 L
s
.99375 .77043 m
1 .77043 L
s
.99375 .92067 m
1 .92067 L
s
.125 Mabswid
.99625 .04928 m
1 .04928 L
s
.99625 .07933 m
1 .07933 L
s
.99625 .10938 m
1 .10938 L
s
.99625 .13942 m
1 .13942 L
s
.99625 .19952 m
1 .19952 L
s
.99625 .22957 m
1 .22957 L
s
.99625 .25962 m
1 .25962 L
s
.99625 .28966 m
1 .28966 L
s
.99625 .34976 m
1 .34976 L
s
.99625 .37981 m
1 .37981 L
s
.99625 .40986 m
1 .40986 L
s
.99625 .4399 m
1 .4399 L
s
.99625 .5 m
1 .5 L
s
.99625 .53005 m
1 .53005 L
s
.99625 .5601 m
1 .5601 L
s
.99625 .59014 m
1 .59014 L
s
.99625 .65024 m
1 .65024 L
s
.99625 .68029 m
1 .68029 L
s
.99625 .71034 m
1 .71034 L
s
.99625 .74038 m
1 .74038 L
s
.99625 .80048 m
1 .80048 L
s
.99625 .83053 m
1 .83053 L
s
.99625 .86058 m
1 .86058 L
s
.99625 .89063 m
1 .89063 L
s
.99625 .95072 m
1 .95072 L
s
.99625 .98077 m
1 .98077 L
s
.25 Mabswid
1 0 m
1 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of gray image
p
.01923 .01923 translate
.96154 .96154 scale
32 string
32 32 8 [32 0 0 32 0 0] {
\tcurrentfile
\t1 index
\treadhexstring
\tpop
}  Mimage
FFFFFF000000000000000000000000000000000000000000
0000000000000000
FF0000008888888888888888888888888888888888888888
8888888888888800
00FF00000000000000000000000000000000000000000000
0000000000008800
00FF00EEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEE
EEEEEEEEEE008800
FF000000EEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEE
EEEEEEEEEE008800
00FF00EEEEEEEEEEEE0000005577EEEEEEEEEE77000077EE
EEEEEEEEEE008800
00FF00EEEEEEEEEEEE00590000000044EE0000002A000000
00EEEEEEEE008800
FF000000EEEEEEEEEE0059590077C40000002A2A00005454
00EEEEEEEE008800
00FF00EEEEEEEEEEEE005959590000C4002A2A0088550054
00EEEEEEEE008800
00FF00EEEEEEEEEE7700595959595500002A008888882200
55EEEEEEEE008800
FF000000EEEEEEEE77005959595959550000888888885500
EEEEEEEEEE008800
00FF00EEEEEEEE7700005959595959590088888888885500
77EEEEEEEE008800
00FF00EEEEEEEE002A2A0000000000000000000000000000
0077EEEEEE008800
FF000000EE77000000000022445588005955002A2A000000
880000EEEE008800
00FF00EEEE000088888888888888000059595955002A0000
00880000EE008800
00FF00EE0054540088888888880000C40059595959000000
540000EEEE008800
FF0000000054545400888888000000C4C400595959590054
5400EEEEEE008800
00FF00EE5500545454008800002A00C4C4C4005959005454
545400EEEE008800
00FF00EEEE440000000000002A2A00C4C4C4C40000545454
54545400EE008800
FF000000EEEEEE5500000000000000C4C4C4C44400545454
000000EEEE008800
00FF00EEEEEEEEEE44005454550000000000000000000000
77EEEEEEEE008800
00FF00EEEEEEEEEE002A00555454545454545400C4C40077
EEEEEEEEEE008800
FF000000EEEEEE77000088005454545454540000C4C400EE
EEEEEEEEEE008800
00FF00EEEEEEEE0000888800555454545400595900C400EE
EEEEEEEEEE008800
00FF00EEEEEEEE00884400000054545455000059590000EE
EEEEEEEEEE008800
FF000000EEEEEE00000077EE7700545500EE5500005900EE
EEEEEEEEEE008800
00FF00EEEEEEEEEEEEEEEEEEEE005400EEEEEEEE770000EE
EEEEEEEEEE008800
00FF00EEEEEEEEEEEEEEEEEEEEEE00EEEEEEEEEEEEEE55EE
EEEEEEEEEE008800
FF000000EEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEE
EEEEEEEEEE008800
00FF00EEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEE
EEEEEEEEEE008800
00FF00EEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEE
EEEEEEEEEE0000FF
FF0000000000000000000000000000000000000000000000
000000000000FFFF
pop
P
% End of image
.01923 .01923 m
.01923 .98077 L
s
.04928 .01923 m
.04928 .98077 L
s
.07933 .01923 m
.07933 .98077 L
s
.10938 .01923 m
.10938 .98077 L
s
.13942 .01923 m
.13942 .98077 L
s
.16947 .01923 m
.16947 .98077 L
s
.19952 .01923 m
.19952 .98077 L
s
.22957 .01923 m
.22957 .98077 L
s
.25962 .01923 m
.25962 .98077 L
s
.28966 .01923 m
.28966 .98077 L
s
.31971 .01923 m
.31971 .98077 L
s
.34976 .01923 m
.34976 .98077 L
s
.37981 .01923 m
.37981 .98077 L
s
.40986 .01923 m
.40986 .98077 L
s
.4399 .01923 m
.4399 .98077 L
s
.46995 .01923 m
.46995 .98077 L
s
.5 .01923 m
.5 .98077 L
s
.53005 .01923 m
.53005 .98077 L
s
.5601 .01923 m
.5601 .98077 L
s
.59014 .01923 m
.59014 .98077 L
s
.62019 .01923 m
.62019 .98077 L
s
.65024 .01923 m
.65024 .98077 L
s
.68029 .01923 m
.68029 .98077 L
s
.71034 .01923 m
.71034 .98077 L
s
.74038 .01923 m
.74038 .98077 L
s
.77043 .01923 m
.77043 .98077 L
s
.80048 .01923 m
.80048 .98077 L
s
.83053 .01923 m
.83053 .98077 L
s
.86058 .01923 m
.86058 .98077 L
s
.89063 .01923 m
.89063 .98077 L
s
.92067 .01923 m
.92067 .98077 L
s
.95072 .01923 m
.95072 .98077 L
s
.98077 .01923 m
.98077 .98077 L
s
.01923 .01923 m
.98077 .01923 L
s
.01923 .04928 m
.98077 .04928 L
s
.01923 .07933 m
.98077 .07933 L
s
.01923 .10938 m
.98077 .10938 L
s
.01923 .13942 m
.98077 .13942 L
s
.01923 .16947 m
.98077 .16947 L
s
.01923 .19952 m
.98077 .19952 L
s
.01923 .22957 m
.98077 .22957 L
s
.01923 .25962 m
.98077 .25962 L
s
.01923 .28966 m
.98077 .28966 L
s
.01923 .31971 m
.98077 .31971 L
s
.01923 .34976 m
.98077 .34976 L
s
.01923 .37981 m
.98077 .37981 L
s
.01923 .40986 m
.98077 .40986 L
s
.01923 .4399 m
.98077 .4399 L
s
.01923 .46995 m
.98077 .46995 L
s
.01923 .5 m
.98077 .5 L
s
.01923 .53005 m
.98077 .53005 L
s
.01923 .5601 m
.98077 .5601 L
s
.01923 .59014 m
.98077 .59014 L
s
.01923 .62019 m
.98077 .62019 L
s
.01923 .65024 m
.98077 .65024 L
s
.01923 .68029 m
.98077 .68029 L
s
.01923 .71034 m
.98077 .71034 L
s
.01923 .74038 m
.98077 .74038 L
s
.01923 .77043 m
.98077 .77043 L
s
.01923 .80048 m
.98077 .80048 L
s
.01923 .83053 m
.98077 .83053 L
s
.01923 .86058 m
.98077 .86058 L
s
.01923 .89063 m
.98077 .89063 L
s
.01923 .92067 m
.98077 .92067 L
s
.01923 .95072 m
.98077 .95072 L
s
.01923 .98077 m
.98077 .98077 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  Evaluatable->False,
  ImageSize->{299.062, 299.062},
  ImageMargins->{{48, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004[0001:`P10`4000010?ooooooc?ooZ_ooI_oo
<ooo0?o<ooo<c?o<VC/k>gYjN[Vi^OShn03ooeGooj[ooonI<onI0?mVoomVc?mVVOmVI_mV<omV0?lc
oclo?ginO[fm_Oclo5D00:X00?l00?l0VOl0I_l0<ol00<coolcoc<coVLcoIP<30d92@X61PL30`000
EED0EJX0EOl0ELbIolbIc<bIVLbII/bI<lbI0<aVolaVc0L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0Z/`c
<l`c0<`0ol`0c<`0VL`0I/`0<l`000/;2dY:BXV9RLS8b000oeD0ojX0ool0oiW<VIW<IYW<<iW<09VI
oiVIc9VIVIVIIPl?3di>CXf=SLc<c01E05EE0:YE0?mE09TcoiTcc9TcVITcIYTc<iTc09T0oiT0c1<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEEFKo<fKo06K<ofK<c6K<VFK<IVK<<fK<01LG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZVIVVFIVIVIV<fIV06HcofHcc6HcVFHcIQ/K6eYJFYVIVMSHf01EoeEEojYEoomEoc?o
oc?oc3?oVC?oIS?o<c?o03?<oc?<c1lO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ03>I<c>I03=Voc=Vc3=V
VC=VIS=V<c=V02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZEC<0VC<0IS<0<c<0003oo`3oc03oV@3oIRLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2Io`2Ic02IV@2IIP2I<`2I001Vo`1Vc2/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`0c<`0c0000o`00c000V@00IP00<nh002l_;fi^KZf][Nc/k03o05Go0:[o0?oo0140
003^003M002k002Z0028001g001E03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@00M`00E@00A0008P00
4Nk^k]gMgK^k^cLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l0;0000?l0;0000?l0;0000?l0;00001<0
0_lX00?o9003o`@00_lR00?o0`03ob401?l300;o8P04o`800olQ00?o1002oa@0000B0004o`00obX0
00?o00008P000ol000020004o`00ob8000?o00001@000ol0000O0003o`00008000Co003o8P000ol0
00050003o`00024000Co003o0P000ol0000A00004P001?l00?lZ0003o`00028000?o00000P001?l0
0?lR0003o`0000D000?o000080001Ol0003o008000?o00008@000ol000040003o`00024000Co003o
0P000ol0000A00004P001?l00?lW00?o9@000ol000020004o`00ob8000?o00000P03ob@000Co003o
0P000ol0000R0003o`0000?o8P02o`<000Co003o4`00018000Co003o9`000ol0000U0003o`000080
00Co003o8P000ol000020003o`00024000Co003o0P001?l00?lQ0004o`00o`8000?o000090001?l0
0?l20003o`000140000C00;o:004ob<00_l500;o8P02o`@01?lQ00;o1002ob<00_l300Co8003o`@0
0_lD0000o`0/0000o`0/0000o`0/0000o`0/0000o`0/00003`3ooaco0@0000l000?o00000P000ol0
00060003o`0000D000?o00001P000ol000050003o`0000H000?o00001@000ol000060003o`0000D0
00?o00001P000ol000050003o`0000H000?o00001@000ol000060003o`0000D000?o00001P000ol0
00050003o`0000H000?o00001@000ol000060003o`0000D000?o00001P000ol000050003o`0000H0
00?o00001@000ol000060003o`0000D000?o00001P000ol000050003o`0000H000?o00001@000ol0
00060003o`0000D000?o00000P01o`40000?0003o`000?l06001o`40000800;o1@000ol0003o01P0
0Ol100001`001?l00?l40003o`000?l06001o`4000070004o`00o`@00ol20?oo4_l300;o0@0000L0
00Co003o10000ol000020003o`0000H000?o00001@000ol000060?Oo1001o`4000070004o`00o`@0
00?o00000P000ol000060003o`0000D000?o00001P3go`@00Ol100002002o`D000?o00000P000ol0
00060003o`0000D000?o00001P3go`@00Ol100003`000ol000020003o`0000H000?o00001@000ol0
00060?Oo1001o`40000?0003o`00008000?o00001P000ol000050003o`0000H0mol4007o0@0000l0
00?o00000P000ol000060003o`0000D000?o00001P3go`@00Ol100003`000ol000020003o`0000H0
00?o00001@000ol000060?Oo1001o`40000?00;o0`3ooa;o0`02o`40000?0003o`00008000?o0000
1P0Jo`Q:00?oBTX01DX00om:BP06BP03odY:00E:00?oBTX01TX00om:BP05BP03odY:00I:00?oBTX0
1DX00om:BP06BP03odY:00E:00?oBTX01TX00om:BP05BP03odY:00I:00?oBTX01DX00om:BP06BP03
odY:00E:00?oBTX01TX00om:BP05BP03odY:00I:00?oBTX01DX00om:BP06BP03odY:00E:00?oBTX0
1TX00om:BP05BP03odY:00I:00?oBTX01DX00om:BP06BPWo1001o`40000?0003o`00008000?o0000
1P0Jo`Q:00?oBTX01DX00om:BP06BP03odY:00E:00?oBTX01TX00om:BP05BP03odY:00I:00?oBTX0
1DX00om:BP06BP03odY:00E:00?oBTX01TX00om:BP05BP03odY:00I:00?oBTX01DX00om:BP06BP03
odY:00E:00?oBTX01TX00om:BP05BP03odY:00I:00?oBTX01DX00om:BP06BP03odY:00E:00?oBTX0
1TX00om:BP05BP03odY:00I:00?oBTX01DX00om:BP06BPWo1001o`40000?0003o`00008000?o0000
1P0Jo`Q:00?oBTX01DX00om:BP06BP03odY:00E:00?oBTX01TX00om:BP05BP03odY:00I:00?oBTX0
1DX00om:BP06BP03odY:00E:00?oBTX01TX00om:BP05BP03odY:00I:00?oBTX01DX00om:BP06BP03
odY:00E:00?oBTX01TX00om:BP05BP03odY:00I:00?oBTX01DX00om:BP06BP03odY:00E:00?oBTX0
1TX00om:BP05BP03odY:00I:00?oBTX01DX00om:BP06BPWo1001o`40000?0003o`00008000?o0000
1P0Jo`Q:00?oBTX01DX00om:BP06BP03odY:00E:00?oBTX01TX00om:BP05BP03odY:00I:00?oBTX0
1DX00om:BP06BP03odY:00E:00?oBTX01TX00om:BP05BP03odY:00I:00?oBTX01DX00om:BP06BP03
odY:00E:00?oBTX01TX00om:BP05BP03odY:00I:00?oBTX01DX00om:BP06BP03odY:00E:00?oBTX0
1TX00om:BP05BP03odY:00I:00?oBTX01DX00om:BP06BPWo1001o`40000?0003o`00008000?o0000
1P0Jo`Q:00?oBTX01DX00om:BP06BP03odY:00E:00?oBTX01TX00om:BP05BP03odY:00I:00?oBTX0
1DX00om:BP06BP03odY:00E:00?oBTX01TX00om:BP05BP03odY:00I:00?oBTX01DX00om:BP06BP03
odY:00E:00?oBTX01TX00om:BP05BP03odY:00I:00?oBTX01DX00om:BP06BP03odY:00E:00?oBTX0
1TX00om:BP05BP03odY:00I:00?oBTX01DX00om:BP06BPWo1001o`40000?0003o`00008000?o0000
1P0Jo`Q:00?oBTX01DX00om:BP06BP03odY:00E:00?oBTX01TX00om:BP05BP03odY:00I:00?oBTX0
1DX00om:BP06BP03odY:00E:00?oBTX01TX00om:BP05BP03odY:00I:00?oBTX01DX00om:BP06BP03
odY:00E:00?oBTX01TX00om:BP05BP03odY:00I:00?oBTX01DX00om:BP06BP03odY:00E:00?oBTX0
1TX00om:BP05BP03odY:00I:00?oBTX01DX00om:BP06BPWo1001o`40000?0003o`00008000?o0000
1P0Jo`Q:00?oBTX01DX00om:BP06BP03odY:00E:00?oBTX01TX00om:BP05BP03odY:00I:00?oBTX0
1DX00om:BP06BP03odY:00E:00?oBTX01TX00om:BP05BP03odY:00I:00?oBTX01DX00om:BP06BP03
odY:00E:00?oBTX01TX00om:BP05BP03odY:00I:00?oBTX01DX00om:BP06BP03odY:00E:00?oBTX0
1TX00om:BP05BP03odY:00I:00?oBTX01DX00om:BP06BPWo1001o`40000?0003o`00008000?o0000
1P0Jo`Q:00?oBTX01DX00om:BP06BP03odY:00E:00?oBTX01TX00om:BP05BP03odY:00I:00?oBTX0
1DX00om:BP06BP03odY:00E:00?oBTX01TX00om:BP05BP03odY:00I:00?oBTX01DX00om:BP06BP03
odY:00E:00?oBTX01TX00om:BP05BP03odY:00I:00?oBTX01DX00om:BP06BP03odY:00E:00?oBTX0
1TX00om:BP05BP03odY:00I:00?oBTX01DX00om:BP06BPWo1001o`40000?00;o0`3ooa;o0`02o`40
000?0003o`0000802_l70>oo24X9o`@00Ol100003`000ol0000200[o1`3_o`Q:2Ol4007o0@0000l0
00?o00000P0:o`L0kol8BPWo1001o`40000?0003o`0000802_l70>oo24X9o`@00Ol100003`000ol0
000200[o1`3_o`Q:2Ol4007o0@0000l000?o00000P0:o`L0kol8BPWo1001o`40000?0003o`000080
2_l70>oo24X9o`@00Ol100003`02o`<0oolBo`<00_l100003`000ol0000200[o1`0:o`Oe00?omOD0
1_D00ooem@05m@03ooGe00Ke00?omOD01OD00ooem@06m@03ooGe00Ge00?omOD01_D00ooem@05m@03
ooGe00Ke00?omOD01OD00ooem@06m@03ooGe00Ge00?omOD01_D00ooem@05m@03ooGe00Ke00?omOD0
1OD00ooem@06m@03ooGe00Ge00?omOD01_D00ooem@05m@03ooGe00Ke00?omOD01OD00ooem@06m@03
ooGe00Ge00?omOD01_D9o`Q:2Ol4007o0@0000l000?o00000P0:o`L02_l7m@03ooGe00Ke00?omOD0
1OD00ooem@06m@03ooGe00Ge00?omOD01_D00ooem@05m@03ooGe00Ke00?omOD01OD00ooem@06m@03
ooGe00Ge00?omOD01_D00ooem@05m@03ooGe00Ke00?omOD01OD00ooem@06m@03ooGe00Ge00?omOD0
1_D00ooem@05m@03ooGe00Ke00?omOD01OD00ooem@06m@03ooGe00Ge00?omOD01_D00ooem@05m@03
ooGe00Ke2Ol8BPWo1001o`40000?0003o`0000802_l700[o1oD00ooem@06m@03ooGe00Ge00?omOD0
1_D00ooem@05m@03ooGe00Ke00?omOD01OD00ooem@06m@03ooGe00Ge00?omOD01_D00ooem@05m@03
ooGe00Ke00?omOD01OD00ooem@06m@03ooGe00Ge00?omOD01_D00ooem@05m@03ooGe00Ke00?omOD0
1OD00ooem@06m@03ooGe00Ge00?omOD01_D00ooem@05m@03ooGe00Ke00?omOD01OD00ooem@06m@Wo
24X9o`@00Ol100003`000ol0000200[o1`0:o`Oe00?omOD01_D00ooem@05m@03ooGe00Ke00?omOD0
1OD00ooem@06m@03ooGe00Ge00?omOD01_D00ooem@05m@03ooGe00Ke00?omOD01OD00ooem@06m@03
ooGe00Ge00?omOD01_D00ooem@05m@03ooGe00Ke00?omOD01OD00ooem@06m@03ooGe00Ge00?omOD0
1_D00ooem@05m@03ooGe00Ke00?omOD01OD00ooem@06m@03ooGe00Ge00?omOD01_D9o`Q:2Ol4007o
0@0000l000?o00000P0:o`L02_l7m@03ooGe00Ke00?omOD01OD00ooem@06m@03ooGe00Ge00?omOD0
1_D00ooem@05m@03ooGe00Ke00?omOD01OD00ooem@06m@03ooGe00Ge00?omOD01_D00ooem@05m@03
ooGe00Ke00?omOD01OD00ooem@06m@03ooGe00Ge00?omOD01_D00ooem@05m@03ooGe00Ke00?omOD0
1OD00ooem@06m@03ooGe00Ge00?omOD01_D00ooem@05m@03ooGe00Ke2Ol8BPWo1001o`40000?0003
o`0000802_l700[o1oD00ooem@06m@03ooGe00Ge00?omOD01_D00ooem@05m@03ooGe00Ke00?omOD0
1OD00ooem@06m@03ooGe00Ge00?omOD01_D00ooem@05m@03ooGe00Ke00?omOD01OD00ooem@06m@03
ooGe00Ge00?omOD01_D00ooem@05m@03ooGe00Ke00?omOD01OD00ooem@06m@03ooGe00Ge00?omOD0
1_D00ooem@05m@03ooGe00Ke00?omOD01OD00ooem@06m@Wo24X9o`@00Ol100003`000ol0000200[o
1`0:o`Oe00?omOD01_D00ooem@05m@03ooGe00Ke00?omOD01OD00ooem@06m@03ooGe00Ge00?omOD0
1_D00ooem@05m@03ooGe00Ke00?omOD01OD00ooem@06m@03ooGe00Ge00?omOD01_D00ooem@05m@03
ooGe00Ke00?omOD01OD00ooem@06m@03ooGe00Ge00?omOD01_D00ooem@05m@03ooGe00Ke00?omOD0
1OD00ooem@06m@03ooGe00Ge00?omOD01_D9o`Q:2Ol4007o0@0000l000?o00000P0:o`L02_l7m@03
ooGe00Ke00?omOD01OD00ooem@06m@03ooGe00Ge00?omOD01_D00ooem@05m@03ooGe00Ke00?omOD0
1OD00ooem@06m@03ooGe00Ge00?omOD01_D00ooem@05m@03ooGe00Ke00?omOD01OD00ooem@06m@03
ooGe00Ge00?omOD01_D00ooem@05m@03ooGe00Ke00?omOD01OD00ooem@06m@03ooGe00Ge00?omOD0
1_D00ooem@05m@03ooGe00Ke2Ol8BPWo1001o`40000?00;o0`3ooa;o0`02o`40000?0003o`000080
00?o00001P0Jo`Se00?omOD01OD00ooem@06m@03ooGe00Ge00?omOD01_D00ooem@05m@03ooGe00Ke
00?omOD01OD00ooem@06m@03ooGe00Ge00?omOD01_D00ooem@05m@03ooGe00Ke00?omOD01OD00ooe
m@06m@03ooGe00Ge00?omOD01_D00ooem@05m@03ooGe00Ke00?omOD01OD00ooem@06m@03ooGe00Ge
00?omOD01_D00ooem@05m@03ooGe00Ke2Ol8BPWo1001o`40000?0003o`00008000?o00001P0Jo`Se
00?omOD01OD00ooem@06m@03ooGe00Ge00?omOD01_D00ooem@05m@03ooGe00Ke00?omOD01OD00ooe
m@06m@03ooGe00Ge00?omOD01_D00ooem@05m@03ooGe00Ke00?omOD01OD00ooem@06m@03ooGe00Ge
00?omOD01_D00ooem@05m@03ooGe00Ke00?omOD01OD00ooem@06m@03ooGe00Ge00?omOD01_D00ooe
m@05m@03ooGe00Ke2Ol8BPWo1001o`40000?0003o`00008000?o00001P0Jo`Se00?omOD01OD00ooe
m@06m@03ooGe00Ge00?omOD01_D00ooem@05m@03ooGe00Ke00?omOD01OD00ooem@06m@03ooGe00Ge
00?omOD01_D00ooem@05m@03ooGe00Ke00?omOD01OD00ooem@06m@03ooGe00Ge00?omOD01_D00ooe
m@05m@03ooGe00Ke00?omOD01OD00ooem@06m@03ooGe00Ge00?omOD01_D00ooem@05m@03ooGe00Ke
2Ol8BPWo1001o`40000?0003o`00008000?o00001P0Jo`Se00?omOD01OD00ooem@06m@03ooGe00Ge
00?omOD01_D00ooem@05m@03ooGe00Ke00?omOD01OD00ooem@06m@03ooGe00Ge00?omOD01_D00ooe
m@05m@03ooGe00Ke00?omOD01OD00ooem@06m@03ooGe00Ge00?omOD01_D00ooem@05m@03ooGe00Ke
00?omOD01OD00ooem@06m@03ooGe00Ge00?omOD01_D00ooem@05m@03ooGe00Ke2Ol8BPWo1001o`40
000?0003o`00008000?o00001P0Jo`Se00?omOD01OD00ooem@06m@03ooGe00Ge00?omOD01_D00ooe
m@05m@03ooGe00Ke00?omOD01OD00ooem@06m@03ooGe00Ge00?omOD01_D00ooem@05m@03ooGe00Ke
00?omOD01OD00ooem@06m@03ooGe00Ge00?omOD01_D00ooem@05m@03ooGe00Ke00?omOD01OD00ooe
m@06m@03ooGe00Ge00?omOD01_D00ooem@05m@03ooGe00Ke2Ol8BPWo1001o`40000700?o1@000ol0
00020003o`0000H06_l8m@03ooGe00Ge00?omOD01_D00ooem@05m@03ooGe00Ke00?omOD01OD00ooe
m@06m@03ooGe00Ge00?omOD01_D00ooem@05m@03ooGe00Ke00?omOD01OD00ooem@06m@03ooGe00Ge
00?omOD01_D00ooem@05m@03ooGe00Ke00?omOD01OD00ooem@06m@03ooGe00Ge00?omOD01_D00ooe
m@05m@03ooGe00Ke00?omOD01OD00ooem@06m@Wo24X9o`@00Ol100002P000ol000020003o`000080
00?o00001P0Jo`Se00?omOD01OD00ooem@06m@03ooGe00Ge00?omOD01_D00ooem@05m@03ooGe00Ke
00?omOD01OD00ooem@06m@03ooGe00Ge00?omOD01_D00ooem@05m@03ooGe00Ke00?omOD01OD00ooe
m@06m@03ooGe00Ge00?omOD01_D00ooem@05m@03ooGe00Ke00?omOD01OD00ooem@06m@03ooGe00Ge
00?omOD01_D00ooem@05m@03ooGe00Ke2Ol8BPWo1001o`40000:0003o`0000800ol20?oo4_l300;o
0@0000L00ol50003o`0000802_l700[o1oD00ooem@06m@03ooGe00Ge00?omOD01_D00ooem@05m@03
ooGe00Ke6_l8K@03ooWi00Gi00?omOD01_D00ooem@05m@03ooGe00Ke00?omOD01OD00ooem@06m@03
ooWi00Gi4_l8n@03ooGe00Ge00?omOD01_D00ooem@05m@03ooGe00Ke00?omOD01OD00ooem@06m@Wo
24X9o`@00Ol100001`000ol000050003o`0000802_l700[o1oD00ooem@06m@03ooGe00Ge00?omOD0
1_D00ooem@05m@03ooGe00Ke6_l8K@03ooWi00Gi00?omOD01_D00ooem@05m@03ooGe00Ke00?omOD0
1OD00ooem@06m@03ooWi00Gi4_l8n@03ooGe00Ge00?omOD01_D00ooem@05m@03ooGe00Ke00?omOD0
1OD00ooem@06m@Wo24X9o`@00Ol100001`04o`@000?o00000P0:o`L02_l7m@03ooGe00Ke00?omOD0
1OD00ooem@06m@03ooGe00Ge00?omOD01_DJo`Q]00?onOT01OT00ooem@06m@03ooGe00Ge00?omOD0
1_D00ooem@05m@03ooGe00Ke00?onOT01OTBo`Si00?omOD01OD00ooem@06m@03ooGe00Ge00?omOD0
1_D00ooem@05m@03ooGe00Ke2Ol8BPWo1001o`40000?0003o`0000802_l700[o1oD00ooem@06m@03
ooGe00Ge00?omOD01_D00ooem@05m@03ooGe00Ke6_l8K@03ooWi00Gi00?omOD01_D00ooem@05m@03
ooGe00Ke00?omOD01OD00ooem@06m@03ooWi00Gi4_l8n@03ooGe00Ge00?omOD01_D00ooem@05m@03
ooGe00Ke00?omOD01OD00ooem@06m@Wo24X9o`@00Ol100003`000ol0000200[o1`0:o`Oe00?omOD0
1_D00ooem@05m@03ooGe00Ke00?omOD01OD00ooem@06mA[o26d00ooin@05n@03ooGe00Ke00?omOD0
1OD00ooem@06m@03ooGe00Ge00?omOD01_D00ooin@05nA;o2?T00ooem@05m@03ooGe00Ke00?omOD0
1OD00ooem@06m@03ooGe00Ge00?omOD01_D9o`Q:2Ol4007o0@0000l000?o00000P0:o`L02_l7m@03
ooGe00Ke00?omOD01OD00ooem@06m@03ooGe00Ge00?omOD01_DJo`Q]00?onOT01OT00ooem@06m@03
ooGe00Ge00?omOD01_D00ooem@05m@03ooGe00Ke00?onOT01OTBo`Si00?omOD01OD00ooem@06m@03
ooGe00Ge00?omOD01_D00ooem@05m@03ooGe00Ke2Ol8BPWo1001o`40000?0003o`0000802_l700[o
1oD00ooem@06m@03ooGe00Ge00?omOD01_D00ooem@05m@03ooGe00Ke6_l8K@03ooWi00Gi00?omOD0
1_D00ooem@05m@03ooGe00Ke00?omOD01OD00ooem@06m@03ooWi00Gi4_l8n@03ooGe00Ge00?omOD0
1_D00ooem@05m@03ooGe00Ke00?omOD01OD00ooem@06m@Wo24X9o`@00Ol100003`000ol0000200[o
1`0:o`Oe00?omOD01_D00ooem@05m@03ooGe00Ke00?omOD01OD00ooem@06mA[o26d00ooin@05n@03
ooGe00Ke00?omOD01OD00ooem@06m@03ooGe00Ge00?omOD01_D00ooin@05nA;o2?T00ooem@05m@03
ooGe00Ke00?omOD01OD00ooem@06m@03ooGe00Ge00?omOD01_D9o`Q:2Ol4007o0@0000l00_l30?oo
4_l300;o0@0000l000?o00000P0:o`L02_l7m@03ooGe00Ke00?omOD01OD00ooem@06m@03ooGe00Ge
00?omOD01_D9o`R98ol7:@03ooGe00Ke6_l8b2?o1oD00ooem@06m@03ooGe00Ge00?omOD01_D9o`Q:
2Ol4007o0@0000l000?o00000P0:o`L02_l7m@03ooGe00Ke00?omOD01OD00ooem@06m@03ooGe00Ge
00?omOD01_D9o`R98ol7:@03ooGe00Ke6_l8b2?o1oD00ooem@06m@03ooGe00Ge00?omOD01_D9o`Q:
2Ol4007o0@0000l000?o00000P0:o`L02_l7m@03ooGe00Ke00?omOD01OD00ooem@06m@03ooGe00Ge
00?omOD01_D9o`R98ol7:@03ooGe00Ke6_l8b2?o1oD00ooem@06m@03ooGe00Ge00?omOD01_D9o`Q:
2Ol4007o0@0000l000?o00000P0:o`L02_l7m@03ooGe00Ke00?omOD01OD00ooem@06m@03ooGe00Ge
00?omOD01_D9o`R98ol7:@03ooGe00Ke6_l8b2?o1oD00ooem@06m@03ooGe00Ge00?omOD01_D9o`Q:
2Ol4007o0@0000l000?o00000P0:o`L02_l7m@03ooGe00Ke00?omOD01OD00ooem@06m@03ooGe00Ge
00?omOD01_D9o`R98ol7:@03ooGe00Ke6_l8b2?o1oD00ooem@06m@03ooGe00Ge00?omOD01_D9o`Q:
2Ol4007o0@0000l000?o00000P0:o`L02_l7m@03ooGe00Ke00?omOD01OD00ooem@06m@03ooGe00Ge
00?omOD01_D9o`R98ol7:@03ooGe00Ke6_l8b2?o1oD00ooem@06m@03ooGe00Ge00?omOD01_D9o`Q:
2Ol4007o0@0000l000?o00000P0:o`L02_l7m@03ooGe00Ke00?omOD01OD00ooem@06m@03ooGe00Ge
00?omOD01_D9o`R98ol7:@03ooGe00Ke6_l8b2?o1oD00ooem@06m@03ooGe00Ge00?omOD01_D9o`Q:
2Ol4007o0@0000l00_l30?oo4_l300;o0@0000l000?o00000P000ol0000601[o2?D00ooem@05m@03
ooGe00Ke00?omOD01OD00ooem@06m@Wo28T00on9R@05R@[o1oT00olk>`06>a[o2<P00oo8b005b1;o
26T00omYJ@05J@[o1oD00ooem@06m@03ooGe00Ge00?omOD01_D9o`Q:2Ol4007o0@0000l000?o0000
0P000ol0000601[o2?D00ooem@05m@03ooGe00Ke00?omOD01OD00ooem@06m@Wo28T00on9R@05R@[o
1oT00olk>`06>a[o2<P00oo8b005b1;o26T00omYJ@05J@[o1oD00ooem@06m@03ooGe00Ge00?omOD0
1_D9o`Q:2Ol4007o0@0000l000?o00000P000ol0000601[o2?D00ooem@05m@03ooGe00Ke00?omOD0
1OD00ooem@06m@Wo28T00on9R@05R@[o1oT00olk>`06>a[o2<P00oo8b005b1;o26T00omYJ@05J@[o
1oD00ooem@06m@03ooGe00Ge00?omOD01_D9o`Q:2Ol4007o0@0000l000?o00000P000ol0000601[o
2?D00ooem@05m@03ooGe00Ke00?omOD01OD00ooem@06m@Wo28T00on9R@05R@[o1oT00olk>`06>a[o
2<P00oo8b005b1;o26T00omYJ@05J@[o1oD00ooem@06m@03ooGe00Ge00?omOD01_D9o`Q:2Ol4007o
0@0000l000?o00000P000ol0000601[o2?D00ooem@05m@03ooGe00Ke00?omOD01OD00ooem@06m@Wo
28T00on9R@05R@[o1oT00olk>`06>a[o2<P00oo8b005b1;o26T00omYJ@05J@[o1oD00ooem@06m@03
ooGe00Ge00?omOD01_D9o`Q:2Ol4007o0@0000l000?o00000P000ol0000601[o2?D00ooem@05m@03
ooGe00Ke00?omOD01OD00ooem@06m@Wo28T00on9R@05R@[o1oT00olk>`06>a[o2<P00oo8b005b1;o
26T00omYJ@05J@[o1oD00ooem@06m@03ooGe00Ge00?omOD01_D9o`Q:2Ol4007o0@0000l000?o0000
0P000ol0000601[o2?D00ooem@05m@03ooGe00Ke00?omOD01OD00ooem@06m@Wo28T00on9R@05R@[o
1oT00olk>`06>a[o2<P00oo8b005b1;o26T00omYJ@05J@[o1oD00ooem@06m@03ooGe00Ge00?omOD0
1_D9o`Q:2Ol4007o0@0000l000?o00000P000ol0000601[o2?D00ooem@05m@03ooGe00Ke00?omOD0
1OD00ooem@06m@Wo28T00on9R@05R@[o1oT00olk>`06>a[o2<P00oo8b005b1;o26T00omYJ@05J@[o
1oD00ooem@06m@03ooGe00Ge00?omOD01_D9o`Q:2Ol4007o0@0000l00_l30?oo4_l300;o0@0000l0
00?o00000P0:o`L02_l7m@03ooGe00Ke00?omOD01OD00ooem@06m@03ooGe00Ge00?omOD01_D9o`R9
00?oRHT01HT00on9R@06RA;o1c/:o`O800?ob<P01/P9o`Q:00?oKFd01Fd:o`MY2_l7m@03ooGe00Ke
00?omOD01OD00ooem@06m@Wo24X9o`@00Ol100003`000ol0000200[o1`0:o`Oe00?omOD01_D00ooe
m@05m@03ooGe00Ke00?omOD01OD00ooem@06m@Wo28T00on9R@05R@03ohV900J94_l7>`[o1lP00oo8
b006b0Wo24X00om]K@05K@[o1fT:o`Oe00?omOD01_D00ooem@05m@03ooGe00Ke2Ol8BPWo1001o`40
000?0003o`0000802_l700[o1oD00ooem@06m@03ooGe00Ge00?omOD01_D00ooem@05m@03ooGe00Ke
2Ol8R@03ohV900F900?oRHT01XTBo`Lk2_l7b003olS800K82Ol8BP03ofe]00E]2_l7J@[o1oD00ooe
m@06m@03ooGe00Ge00?omOD01_D9o`Q:2Ol4007o0@0000l000?o00000P0:o`L02_l7m@03ooGe00Ke
00?omOD01OD00ooem@06m@03ooGe00Ge00?omOD01_D9o`R900?oRHT01HT00on9R@06RA;o1c/:o`O8
00?ob<P01/P9o`Q:00?oKFd01Fd:o`MY2_l7m@03ooGe00Ke00?omOD01OD00ooem@06m@Wo24X9o`@0
0Ol100003`000ol0000200[o1`0:o`Oe00?omOD01_D00ooem@05m@03ooGe00Ke00?omOD01OD00ooe
m@06m@Wo28T00on9R@05R@03ohV900J94_l7>`[o1lP00oo8b006b0Wo24X00om]K@05K@[o1fT:o`Oe
00?omOD01_D00ooem@05m@03ooGe00Ke2Ol8BPWo1001o`40000?0003o`0000802_l700[o1oD00ooe
m@06m@03ooGe00Ge00?omOD01_D00ooem@05m@03ooGe00Ke2Ol8R@03ohV900F900?oRHT01XTBo`Lk
2_l7b003olS800K82Ol8BP03ofe]00E]2_l7J@[o1oD00ooem@06m@03ooGe00Ge00?omOD01_D9o`Q:
2Ol4007o0@0000l000?o00000P0:o`L02_l7m@03ooGe00Ke00?omOD01OD00ooem@06m@03ooGe00Ge
00?omOD01_D9o`R900?oRHT01HT00on9R@06RA;o1c/:o`O800?ob<P01/P9o`Q:00?oKFd01Fd:o`MY
2_l7m@03ooGe00Ke00?omOD01OD00ooem@06m@Wo24X9o`@00Ol100003`02o`<0oolBo`<00_l10000
3`000ol0000200[o1`0:o`Oe00?omOD01_D00ooem@05m@03ooGe00Ke00?omOD01OD00ooin@06n@Wo
28T00on9R@05R@03ohV900J900?oRHT01HT00om]K@06KA;o1lP:o`M:00?oBTX01TX00om:BP05BP03
ojRX00JX2Ol8K@03ooGe00Ge00?omOD01_D00ooem@05m@03ooGe00Ke2Ol8BPWo1001o`40000?0003
o`0000802_l700[o1oD00ooem@06m@03ooGe00Ge00?omOD01_D00ooem@05m@03ooWi00Ki2Ol8R@03
ohV900F900?oRHT01XT00on9R@05R@03ofe]00I]4_l7b0[o1dX00om:BP06BP03odY:00E:00?oZ:P0
1ZP9o`Q]00?omOD01OD00ooem@06m@03ooGe00Ge00?omOD01_D9o`Q:2Ol4007o0@0000l000?o0000
0P0:o`L02_l7m@03ooGe00Ke00?omOD01OD00ooem@06m@03ooGe00Ge00?onOT01_T9o`R900?oRHT0
1HT00on9R@06R@03ohV900F900?oKFd01VdBo`O82_l7BP03odY:00I:00?oBTX01DX00onXZ006Z0Wo
26d00ooem@05m@03ooGe00Ke00?omOD01OD00ooem@06m@Wo24X9o`@00Ol100003`000ol0000200[o
1`0:o`Oe00?omOD01_D00ooem@05m@03ooGe00Ke00?omOD01OD00ooin@06n@Wo28T00on9R@05R@03
ohV900J900?oRHT01HT00om]K@06KA;o1lP:o`M:00?oBTX01TX00om:BP05BP03ojRX00JX2Ol8K@03
ooGe00Ge00?omOD01_D00ooem@05m@03ooGe00Ke2Ol8BPWo1001o`40000?0003o`0000802_l700[o
1oD00ooem@06m@03ooGe00Ge00?omOD01_D00ooem@05m@03ooWi00Ki2Ol8R@03ohV900F900?oRHT0
1XT00on9R@05R@03ofe]00I]4_l7b0[o1dX00om:BP06BP03odY:00E:00?oZ:P01ZP9o`Q]00?omOD0
1OD00ooem@06m@03ooGe00Ge00?omOD01_D9o`Q:2Ol4007o0@0000l000?o00000P0:o`L02_l7m@03
ooGe00Ke00?omOD01OD00ooem@06m@03ooGe00Ge00?onOT01_T9o`R900?oRHT01HT00on9R@06R@03
ohV900F900?oKFd01VdBo`O82_l7BP03odY:00I:00?oBTX01DX00onXZ006Z0Wo26d00ooem@05m@03
ooGe00Ke00?omOD01OD00ooem@06m@Wo24X9o`@00Ol1000000@0oooo1002o`D000?o00000P0:o`L0
2_l7m@03ooGe00Ke00?omOD01OD00ooem@06m@03ooGe00Ge00?onOT01_T9o`R900?oRHT01HT00on9
R@06R@03ohV900F900?oKFd01VdBo`O82_l7BP03odY:00I:00?oBTX01DX00onXZ006Z0Wo26d00ooe
m@05m@03ooGe00Ke00?omOD01OD00ooem@06m@Wo24X9o`@00Ol100000P000ol000020004o`00o`@0
00?o00000P0:o`L02_l7m@03ooGe00Ke00?omOD01OD00ooem@06m@03ooGe00Ge00?onOT01_T9o`R9
00?oRHT01HT00on9R@06R@03ohV900F900?oKFd01VdBo`O82_l7BP03odY:00I:00?oBTX01DX00onX
Z006Z0Wo26d00ooem@05m@03ooGe00Ke00?omOD01OD00ooem@06m@Wo24X9o`@00Ol100000P000ol0
00020004o`00o`@00ol20?oo4_l300;o0@00008000?o00000P001?l00?l40003o`00008000?o0000
1P0Jo`Se00?omOD01OD00ooem@06m@03ooGe00Ge00?onOT01_T9o`R900?oRHT01HT00on9R@06R@03
ohV900F900?oRHT01XT00om]K@05KA;o24X00om:BP05BP03odY:00I:00?oBTX01DX00om]K@06K@Wo
2?D00ooem@05m@03ooGe00Ke00?omOD01OD00ooem@06m@Wo24X9o`@00Ol100000P000ol000020004
o`00o`@000?o00000P000ol0000601[o2?D00ooem@05m@03ooGe00Ke00?omOD01OD00ooin@06n@Wo
28T00on9R@05R@03ohV900J900?oRHT01HT00on9R@06R@03ofe]00E]4_l8BP03odY:00E:00?oBTX0
1TX00om:BP05BP03ofe]00I]2Ol8m@03ooGe00Ge00?omOD01_D00ooem@05m@03ooGe00Ke2Ol8BPWo
1001o`4000000`3oo`0500;o1@000ol000020003o`0000H06_l8m@03ooGe00Ge00?omOD01_D00ooe
m@05m@03ooWi00Ki2Ol8R@03ohV900F900?oRHT01XT00on9R@05R@03ohV900J900?oKFd01FdBo`Q:
00?oBTX01DX00om:BP06BP03odY:00E:00?oKFd01Vd9o`Se00?omOD01OD00ooem@06m@03ooGe00Ge
00?omOD01_D9o`Q:2Ol4007o0@0000l000?o00000P000ol0000601[o2?D00ooem@05m@03ooGe00Ke
00?omOD01OD00ooin@06n@Wo28T00on9R@05R@03ohV900J900?oRHT01HT00on9R@06R@03ofe]00E]
4_l8BP03odY:00E:00?oBTX01TX00om:BP05BP03ofe]00I]2Ol8m@03ooGe00Ge00?omOD01_D00ooe
m@05m@03ooGe00Ke2Ol8BPWo1001o`40000?0003o`00008000?o00001P0Jo`Se00?omOD01OD00ooe
m@06m@03ooGe00Ge00?onOT01_T9o`R900?oRHT01HT00on9R@06R@03ohV900F900?oRHT01XT00om]
K@05KA;o24X00om:BP05BP03odY:00I:00?oBTX01DX00om]K@06K@Wo2?D00ooem@05m@03ooGe00Ke
00?omOD01OD00ooem@06m@Wo24X9o`@00Ol100003`000ol000020003o`0000H06_l8m@03ooGe00Ge
00?omOD01_D00ooem@05m@03ooWi00Ki2Ol8R@03ohV900F900?oRHT01XT00on9R@05R@03ohV900J9
00?oKFd01FdBo`Q:00?oBTX01DX00om:BP06BP03odY:00E:00?oKFd01Vd9o`Se00?omOD01OD00ooe
m@06m@03ooGe00Ge00?omOD01_D9o`Q:2Ol4007o0@0000l000?o00000P000ol0000601[o2?D00ooe
m@05m@03ooGe00Ke00?omOD01OD00ooin@06n@Wo28T00on9R@05R@03ohV900J900?oRHT01HT00on9
R@06R@03ofe]00E]4_l8BP03odY:00E:00?oBTX01TX00om:BP05BP03ofe]00I]2Ol8m@03ooGe00Ge
00?omOD01_D00ooem@05m@03ooGe00Ke2Ol8BPWo1001o`40000?00;o0`3ooa;o0`02o`40000?0003
o`0000802_l700[o1oD00ooem@06m@03ooGe00Ge00?omOD01_D00ooin@05nA;o28T00on9R@05R@03
ohV900J900?oRHT01HT00on9R@06R@03ohV900F92_l7BP03odY:00I:00?oBTX01DX00om:BP06BP03
odY:00E:00?oKFd01Vd9o`Si00?omOD01OD00ooem@06m@03ooGe00Ge00?omOD01_D9o`Q:2Ol4007o
0@0000l000?o00000P0:o`L02_l7m@03ooGe00Ke00?omOD01OD00ooem@06m@03ooWi00Gi4_l8R@03
ohV900F900?oRHT01XT00on9R@05R@03ohV900J900?oRHT01HT:o`M:00?oBTX01TX00om:BP05BP03
odY:00I:00?oBTX01DX00om]K@06K@Wo2?T00ooem@05m@03ooGe00Ke00?omOD01OD00ooem@06m@Wo
24X9o`@00Ol100003`000ol0000200[o1`0:o`Oe00?omOD01_D00ooem@05m@03ooGe00Ke00?onOT0
1OTBo`R900?oRHT01HT00on9R@06R@03ohV900F900?oRHT01XT00on9R@05R@[o1dX00om:BP06BP03
odY:00E:00?oBTX01TX00om:BP05BP03ofe]00I]2Ol8n@03ooGe00Ge00?omOD01_D00ooem@05m@03
ooGe00Ke2Ol8BPWo1001o`40000?0003o`0000802_l700[o1oD00ooem@06m@03ooGe00Ge00?omOD0
1_D00ooin@05nA;o28T00on9R@05R@03ohV900J900?oRHT01HT00on9R@06R@03ohV900F92_l7BP03
odY:00I:00?oBTX01DX00om:BP06BP03odY:00E:00?oKFd01Vd9o`Si00?omOD01OD00ooem@06m@03
ooGe00Ge00?omOD01_D9o`Q:2Ol4007o0@0000l000?o00000P0:o`L02_l7m@03ooGe00Ke00?omOD0
1OD00ooem@06m@03ooWi00Gi4_l8R@03ohV900F900?oRHT01XT00on9R@05R@03ohV900J900?oRHT0
1HT:o`M:00?oBTX01TX00om:BP05BP03odY:00I:00?oBTX01DX00om]K@06K@Wo2?T00ooem@05m@03
ooGe00Ke00?omOD01OD00ooem@06m@Wo24X9o`@00Ol100003`000ol0000200[o1`0:o`Oe00?omOD0
1_D00ooem@05m@03ooGe00Ke00?onOT01OTBo`R900?oRHT01HT00on9R@06R@03ohV900F900?oRHT0
1XT00on9R@05R@[o1dX00om:BP06BP03odY:00E:00?oBTX01TX00om:BP05BP03ofe]00I]2Ol8n@03
ooGe00Ge00?omOD01_D00ooem@05m@03ooGe00Ke2Ol8BPWo1001o`40000?0003o`0000802_l700[o
1oD00ooem@06m@03ooGe00Ge00?omOD01_D00ooin@05nA;o28T00on9R@05R@03ohV900J900?oRHT0
1HT00on9R@06R@03ohV900F92_l7BP03odY:00I:00?oBTX01DX00om:BP06BP03odY:00E:00?oKFd0
1Vd9o`Si00?omOD01OD00ooem@06m@03ooGe00Ge00?omOD01_D9o`Q:2Ol4007o0@0000l000?o0000
0P0:o`L02_l7m@03ooGe00Ke00?omOD01OD00ooem@06m@03ooWi00Gi4_l8R@03ohV900F900?oRHT0
1XT00on9R@05R@03ohV900J900?oRHT01HT:o`M:00?oBTX01TX00om:BP05BP03odY:00I:00?oBTX0
1DX00om]K@06K@Wo2?T00ooem@05m@03ooGe00Ke00?omOD01OD00ooem@06m@Wo24X9o`@00Ol10000
3`02o`<0oolBo`<00_l100003`000ol0000200[o1`0:o`Oe00?omOD01_D00ooem@05m@03ooGe00Ke
2Ol8b003olS800G8POl7n@03ooGe00Ke00?omOD01OD00ooem@06m@Wo24X9o`@00Ol100003`000ol0
000200[o1`0:o`Oe00?omOD01_D00ooem@05m@03ooGe00Ke2Ol8b003olS800G8POl7n@03ooGe00Ke
00?omOD01OD00ooem@06m@Wo24X9o`@00Ol100003`000ol0000200[o1`0:o`Oe00?omOD01_D00ooe
m@05m@03ooGe00Ke2Ol8b003olS800G8POl7n@03ooGe00Ke00?omOD01OD00ooem@06m@Wo24X9o`@0
0Ol100003`000ol0000200[o1`0:o`Oe00?omOD01_D00ooem@05m@03ooGe00Ke2Ol8b003olS800G8
POl7n@03ooGe00Ke00?omOD01OD00ooem@06m@Wo24X9o`@00Ol100003`000ol0000200[o1`0:o`Oe
00?omOD01_D00ooem@05m@03ooGe00Ke2Ol8b003olS800G8POl7n@03ooGe00Ke00?omOD01OD00ooe
m@06m@Wo24X9o`@00Ol100003`000ol0000200[o1`0:o`Oe00?omOD01_D00ooem@05m@03ooGe00Ke
2Ol8b003olS800G8POl7n@03ooGe00Ke00?omOD01OD00ooem@06m@Wo24X9o`@00Ol100003`000ol0
000200[o1`0:o`Oe00?omOD01_D00ooem@05m@03ooGe00Ke2Ol8b003olS800G8POl7n@03ooGe00Ke
00?omOD01OD00ooem@06m@Wo24X9o`@00Ol100003`02o`<0oolBo`<00_l100003`000ol000020003
o`0000H06_l8m@03ooWi00Gi;?l7Z003obTY00HY00?oKFd01Fd00om:BP06BPWo28T00om]K@05K@[o
1lP00oo8b006b1[o24XBo`Oe00?omOD01_D9o`Q:2Ol4007o0@0000l000?o00000P000ol0000601[o
2?D00ooin@05nBco1jP00olY:@06:@03ofe]00E]00?oBTX01TX9o`R900?oKFd01Fd:o`O800?ob<P0
1/PJo`Q:4_l7m@03ooGe00Ke2Ol8BPWo1001o`40000?0003o`00008000?o00001P0Jo`Se00?onOT0
1OT/o`NX00?o:BT01RT00om]K@05K@03odY:00I:2Ol8R@03ofe]00E]2_l7b003olS800K86_l8BQ;o
1oD00ooem@06m@Wo24X9o`@00Ol100003`000ol000020003o`0000H06_l8m@03ooWi00Gi;?l7Z003
obTY00HY00?oKFd01Fd00om:BP06BPWo28T00om]K@05K@[o1lP00oo8b006b1[o24XBo`Oe00?omOD0
1_D9o`Q:2Ol4007o0@0000l000?o00000P000ol0000601[o2?D00ooin@05nBco1jP00olY:@06:@03
ofe]00E]00?oBTX01TX9o`R900?oKFd01Fd:o`O800?ob<P01/PJo`Q:4_l7m@03ooGe00Ke2Ol8BPWo
1001o`40000?0003o`00008000?o00001P0Jo`Se00?onOT01OT/o`NX00?o:BT01RT00om]K@05K@03
odY:00I:2Ol8R@03ofe]00E]2_l7b003olS800K86_l8BQ;o1oD00ooem@06m@Wo24X9o`@00Ol10000
3`000ol000020003o`0000H06_l8m@03ooWi00Gi;?l7Z003obTY00HY00?oKFd01Fd00om:BP06BPWo
28T00om]K@05K@[o1lP00oo8b006b1[o24XBo`Oe00?omOD01_D9o`Q:2Ol4007o0@0000l000?o0000
0P000ol0000601[o2?D00ooin@05nBco1jP00olY:@06:@03ofe]00E]00?oBTX01TX9o`R900?oKFd0
1Fd:o`O800?ob<P01/PJo`Q:4_l7m@03ooGe00Ke2Ol8BPWo1001o`40000?00;o0`3ooa;o0`02o`40
000?0003o`0000802_l700[o1oD00ooem@06mA;o1dX00om:BP06BP03odY:00E:00?oBTX01TX00om:
BP05BP03odY:00I:00?oBTX01DXBo`R900?oRHT01HT00on9R@06R@03ofe]00E]2_l7b1_o1dXBo`Se
2Ol8BPWo1001o`40000?0003o`0000802_l700[o1oD00ooem@06mA;o1dX00om:BP06BP03odY:00E:
00?oBTX01TX00om:BP05BP03odY:00I:00?oBTX01DXBo`R900?oRHT01HT00on9R@06R@03ofe]00E]
2_l7b1_o1dXBo`Se2Ol8BPWo1001o`40000?0003o`0000802_l700[o1oD00ooem@06mA;o1dX00om:
BP06BP03odY:00E:00?oBTX01TX00om:BP05BP03odY:00I:00?oBTX01DXBo`R900?oRHT01HT00on9
R@06R@03ofe]00E]2_l7b1_o1dXBo`Se2Ol8BPWo1001o`40000?0003o`0000802_l700[o1oD00ooe
m@06mA;o1dX00om:BP06BP03odY:00E:00?oBTX01TX00om:BP05BP03odY:00I:00?oBTX01DXBo`R9
00?oRHT01HT00on9R@06R@03ofe]00E]2_l7b1_o1dXBo`Se2Ol8BPWo1001o`40000?0003o`000080
2_l700[o1oD00ooem@06mA;o1dX00om:BP06BP03odY:00E:00?oBTX01TX00om:BP05BP03odY:00I:
00?oBTX01DXBo`R900?oRHT01HT00on9R@06R@03ofe]00E]2_l7b1_o1dXBo`Se2Ol8BPWo1001o`40
0000103oool300?o1@000ol0000200[o1`0:o`Oe00?omOD01_DBo`M:00?oBTX01TX00om:BP05BP03
odY:00I:00?oBTX01DX00om:BP06BP03odY:00E:4_l8R@03ohV900F900?oRHT01XT00om]K@05K@[o
1lPKo`M:4_l8m@Wo24X9o`@00Ol100000P000ol000050003o`00008000?o00000P0:o`L02_l7m@03
ooGe00Ke4_l7BP03odY:00I:00?oBTX01DX00om:BP06BP03odY:00E:00?oBTX01TX00om:BP05BQ;o
28T00on9R@05R@03ohV900J900?oKFd01Fd:o`O86ol7BQ;o2?D9o`Q:2Ol4007o0@00008000?o0000
1@000ol0000200?o0P3ooa;o0`02o`4000020003o`0000800ol50003o`0000802_l700[o1oD:o`MY
00?oJFT01VT9o`Q:00?oBTX01DX00om:BP06BP03odY:00E:00?oBTX01TXBo`Lk2_l7R@03ohV900J9
00?oRHT01HT00on9R@06RA[o26TBo`Oe00?omOD01_D9o`Q:2Ol4007o0@00008000?o00000P000ol0
00050003o`0000802_l700[o1oD:o`MY00?oJFT01VT9o`Q:00?oBTX01DX00om:BP06BP03odY:00E:
00?oBTX01TXBo`Lk2_l7R@03ohV900J900?oRHT01HT00on9R@06RA[o26TBo`Oe00?omOD01_D9o`Q:
2Ol4007o0@0000030?oo00@01?l40003o`0000802_l700[o1oD:o`MY00?oJFT01VT9o`Q:00?oBTX0
1DX00om:BP06BP03odY:00E:00?oBTX01TXBo`Lk2_l7R@03ohV900J900?oRHT01HT00on9R@06RA[o
26TBo`Oe00?omOD01_D9o`Q:2Ol4007o0@0000l000?o00000P0:o`L02_l7m@[o1fT00omYJ@06J@Wo
24X00om:BP05BP03odY:00I:00?oBTX01DX00om:BP06BQ;o1c/:o`N900?oRHT01XT00on9R@05R@03
ohV900J96_l8JA;o1oD00ooem@06m@Wo24X9o`@00Ol100003`000ol0000200[o1`0:o`Oe2_l7J@03
ofUY00IY2Ol8BP03odY:00E:00?oBTX01TX00om:BP05BP03odY:00I:4_l7>`[o1hT00on9R@06R@03
ohV900F900?oRHT01XTJo`QY4_l7m@03ooGe00Ke2Ol8BPWo1001o`40000?0003o`0000802_l700[o
1oD:o`MY00?oJFT01VT9o`Q:00?oBTX01DX00om:BP06BP03odY:00E:00?oBTX01TXBo`Lk2_l7R@03
ohV900J900?oRHT01HT00on9R@06RA[o26TBo`Oe00?omOD01_D9o`Q:2Ol4007o0@0000l000?o0000
0P0:o`L02_l7m@[o1fT00omYJ@06J@Wo24X00om:BP05BP03odY:00I:00?oBTX01DX00om:BP06BQ;o
1c/:o`N900?oRHT01XT00on9R@05R@03ohV900J96_l8JA;o1oD00ooem@06m@Wo24X9o`@00Ol10000
3`000ol0000200[o1`0:o`Oe2_l7J@03ofUY00IY2Ol8BP03odY:00E:00?oBTX01TX00om:BP05BP03
odY:00I:4_l7>`[o1hT00on9R@06R@03ohV900F900?oRHT01XTJo`QY4_l7m@03ooGe00Ke2Ol8BPWo
1001o`40000?00;o0`3ooa;o0`02o`40000?0003o`00008000?o00001P0So`MY00?oJFT01VT00omY
J@05J@[o1dX00om:BP06BP03odY:00E:6ol7>`03oc/k00Hk2Ol8R@03ohV900F900?oRHT01XT00on9
R@05R@[o1fT00omYJ@06J@Wo2?D00ooem@05m@03ooGe00Ke2Ol8BPWo1001o`40000?0003o`000080
00?o00001P0So`MY00?oJFT01VT00omYJ@05J@[o1dX00om:BP06BP03odY:00E:6ol7>`03oc/k00Hk
2Ol8R@03ohV900F900?oRHT01XT00on9R@05R@[o1fT00omYJ@06J@Wo2?D00ooem@05m@03ooGe00Ke
2Ol8BPWo1001o`40000?0003o`00008000?o00001P0So`MY00?oJFT01VT00omYJ@05J@[o1dX00om:
BP06BP03odY:00E:6ol7>`03oc/k00Hk2Ol8R@03ohV900F900?oRHT01XT00on9R@05R@[o1fT00omY
J@06J@Wo2?D00ooem@05m@03ooGe00Ke2Ol8BPWo1001o`40000?0003o`00008000?o00001P0So`MY
00?oJFT01VT00omYJ@05J@[o1dX00om:BP06BP03odY:00E:6ol7>`03oc/k00Hk2Ol8R@03ohV900F9
00?oRHT01XT00on9R@05R@[o1fT00omYJ@06J@Wo2?D00ooem@05m@03ooGe00Ke2Ol8BPWo1001o`40
000?0003o`00008000?o00001P0So`MY00?oJFT01VT00omYJ@05J@[o1dX00om:BP06BP03odY:00E:
6ol7>`03oc/k00Hk2Ol8R@03ohV900F900?oRHT01XT00on9R@05R@[o1fT00omYJ@06J@Wo2?D00ooe
m@05m@03ooGe00Ke2Ol8BPWo1001o`40000?0003o`00008000?o00001P0So`MY00?oJFT01VT00omY
J@05J@[o1dX00om:BP06BP03odY:00E:6ol7>`03oc/k00Hk2Ol8R@03ohV900F900?oRHT01XT00on9
R@05R@[o1fT00omYJ@06J@Wo2?D00ooem@05m@03ooGe00Ke2Ol8BPWo1001o`40000?0003o`000080
00?o00001P0So`MY00?oJFT01VT00omYJ@05J@[o1dX00om:BP06BP03odY:00E:6ol7>`03oc/k00Hk
2Ol8R@03ohV900F900?oRHT01XT00on9R@05R@[o1fT00omYJ@06J@Wo2?D00ooem@05m@03ooGe00Ke
2Ol8BPWo1001o`40000?00;o0`3ooa;o0`02o`40000?0003o`0000802_l700[o1oD00om]K@06K@Wo
26T00omYJ@05J@03ofUY00IY2Ol8BQ;o1lP:o`Lk00?o>c/01S/00olk>`05>`[o1hT00on9R@06R@Wo
26T00omYJ@05J@03ofUY00IY00?oJFT01FT:o`Oe00?omOD01_D9o`Q:2Ol4007o0@0000l000?o0000
0P0:o`L02_l7m@03ofe]00I]2Ol8J@03ofUY00EY00?oJFT01VT9o`Q:4_l7b0[o1c/00olk>`06>`03
oc/k00Dk2_l7R@03ohV900J92Ol8J@03ofUY00EY00?oJFT01VT00omYJ@05J@[o1oD00ooem@06m@Wo
24X9o`@00Ol100003`000ol0000200[o1`0:o`Oe00?oKFd01Vd9o`QY00?oJFT01FT00omYJ@06J@Wo
24XBo`O82_l7>`03oc/k00Hk00?o>c/01C/:o`N900?oRHT01XT9o`QY00?oJFT01FT00omYJ@06J@03
ofUY00EY2_l7m@03ooGe00Ke2Ol8BPWo1001o`40000?0003o`0000802_l700[o1oD00om]K@06K@Wo
26T00omYJ@05J@03ofUY00IY2Ol8BQ;o1lP:o`Lk00?o>c/01S/00olk>`05>`[o1hT00on9R@06R@Wo
26T00omYJ@05J@03ofUY00IY00?oJFT01FT:o`Oe00?omOD01_D9o`Q:2Ol4007o0@0000l000?o0000
0P0:o`L02_l7m@03ofe]00I]2Ol8J@03ofUY00EY00?oJFT01VT9o`Q:4_l7b0[o1c/00olk>`06>`03
oc/k00Dk2_l7R@03ohV900J92Ol8J@03ofUY00EY00?oJFT01VT00omYJ@05J@[o1oD00ooem@06m@Wo
24X9o`@00Ol100003`000ol0000200[o1`0:o`Oe00?oKFd01Vd9o`QY00?oJFT01FT00omYJ@06J@Wo
24XBo`O82_l7>`03oc/k00Hk00?o>c/01C/:o`N900?oRHT01XT9o`QY00?oJFT01FT00omYJ@06J@03
ofUY00EY2_l7m@03ooGe00Ke2Ol8BPWo1001o`40000?0003o`0000802_l700[o1oD00om]K@06K@Wo
26T00omYJ@05J@03ofUY00IY2Ol8BQ;o1lP:o`Lk00?o>c/01S/00olk>`05>`[o1hT00on9R@06R@Wo
26T00omYJ@05J@03ofUY00IY00?oJFT01FT:o`Oe00?omOD01_D9o`Q:2Ol4007o0@0000l000?o0000
0P0:o`L02_l7m@03ofe]00I]2Ol8J@03ofUY00EY00?oJFT01VT9o`Q:4_l7b0[o1c/00olk>`06>`03
oc/k00Dk2_l7R@03ohV900J92Ol8J@03ofUY00EY00?oJFT01VT00omYJ@05J@[o1oD00ooem@06m@Wo
24X9o`@00Ol100003`02o`<0oolBo`<00_l100003`000ol0000200[o1`0:o`Oe00?omOD01_D00olY
:@05:CCo2<P00oo8b005b0[o1c/00olk>`06>`03oc/k00Dk00?o>c/01S/Bo`MY00?oJFT01VT00omY
J@05J@03ofUY00IY00?oJFT01FT00omYJ@06J@Wo2?D9o`Q:2Ol4007o0@0000l000?o00000P0:o`L0
2_l7m@03ooGe00Ke00?o:BT01BTdo`S800?ob<P01LP:o`Lk00?o>c/01S/00olk>`05>`03oc/k00Hk
4_l7J@03ofUY00IY00?oJFT01FT00omYJ@06J@03ofUY00EY00?oJFT01VT9o`Se2Ol8BPWo1001o`40
000?0003o`0000802_l700[o1oD00ooem@06m@03obTY00DY=?l8b003olS800G82_l7>`03oc/k00Hk
00?o>c/01C/00olk>`06>a;o1fT00omYJ@06J@03ofUY00EY00?oJFT01VT00omYJ@05J@03ofUY00IY
2Ol8m@Wo24X9o`@00Ol100003`000ol0000200[o1`0:o`Oe00?omOD01_D00olY:@05:CCo2<P00oo8
b005b0[o1c/00olk>`06>`03oc/k00Dk00?o>c/01S/Bo`MY00?oJFT01VT00omYJ@05J@03ofUY00IY
00?oJFT01FT00omYJ@06J@Wo2?D9o`Q:2Ol4007o0@0000l000?o00000P0:o`L02_l7m@03ooGe00Ke
00?o:BT01BTdo`S800?ob<P01LP:o`Lk00?o>c/01S/00olk>`05>`03oc/k00Hk4_l7J@03ofUY00IY
00?oJFT01FT00omYJ@06J@03ofUY00EY00?oJFT01VT9o`Se2Ol8BPWo1001o`40000?0003o`000080
2_l700[o1oD00ooem@06m@03obTY00DY=?l8b003olS800G82_l7>`03oc/k00Hk00?o>c/01C/00olk
>`06>a;o1fT00omYJ@06J@03ofUY00EY00?oJFT01VT00omYJ@05J@03ofUY00IY2Ol8m@Wo24X9o`@0
0Ol100003`000ol0000200[o1`0:o`Oe00?omOD01_D00olY:@05:CCo2<P00oo8b005b0[o1c/00olk
>`06>`03oc/k00Dk00?o>c/01S/Bo`MY00?oJFT01VT00omYJ@05J@03ofUY00IY00?oJFT01FT00omY
J@06J@Wo2?D9o`Q:2Ol4007o0@0000l00_l30?oo4_l300;o0@0000l000?o00000P000ol0000601[o
2?D00ooem@05m@03ooGe00Ke00?oKFd01Fdmo`Lk00?o>c/01S/00olk>`05>`03oc/k00Hk00?o:BT0
1BT:o`MY00?oJFT01VT00omYJ@05JA_o1oD00ooem@06m@Wo24X9o`@00Ol100003`000ol000020003
o`0000H06_l8m@03ooGe00Ge00?omOD01_D00om]K@05KCgo1c/00olk>`06>`03oc/k00Dk00?o>c/0
1S/00olY:@05:@[o1fT00omYJ@06J@03ofUY00EY6ol7m@03ooGe00Ke2Ol8BPWo1001o`40000?0003
o`00008000?o00001P0Jo`Se00?omOD01OD00ooem@06m@03ofe]00E]?Ol7>`03oc/k00Hk00?o>c/0
1C/00olk>`06>`03obTY00DY2_l7J@03ofUY00IY00?oJFT01FTKo`Oe00?omOD01_D9o`Q:2Ol4007o
0@0000l000?o00000P000ol0000601[o2?D00ooem@05m@03ooGe00Ke00?oKFd01Fdmo`Lk00?o>c/0
1S/00olk>`05>`03oc/k00Hk00?o:BT01BT:o`MY00?oJFT01VT00omYJ@05JA_o1oD00ooem@06m@Wo
24X9o`@00Ol100003`000ol000020003o`0000H06_l8m@03ooGe00Ge00?omOD01_D00om]K@05KCgo
1c/00olk>`06>`03oc/k00Dk00?o>c/01S/00olY:@05:@[o1fT00omYJ@06J@03ofUY00EY6ol7m@03
ooGe00Ke2Ol8BPWo1001o`40000?0003o`00008000?o00001P0Jo`Se00?omOD01OD00ooem@06m@03
ofe]00E]?Ol7>`03oc/k00Hk00?o>c/01C/00olk>`06>`03obTY00DY2_l7J@03ofUY00IY00?oJFT0
1FTKo`Oe00?omOD01_D9o`Q:2Ol4007o0@0000030?oo00;o0`02o`D000?o00000P000ol0000601[o
2?D00ooem@05m@03ooGe00Ke00?oKFd01Fdmo`Lk00?o>c/01S/00olk>`05>`03oc/k00Hk00?o:BT0
1BT:o`MY00?oJFT01VT00omYJ@05JA_o1oD00ooem@06m@Wo24X9o`@00Ol100000P000ol000020004
o`00o`@000?o00000P000ol0000601[o2?D00ooem@05m@03ooGe00Ke00?oKFd01Fdmo`Lk00?o>c/0
1S/00olk>`05>`03oc/k00Hk00?o:BT01BT:o`MY00?oJFT01VT00omYJ@05JA_o1oD00ooem@06m@Wo
24X9o`@00Ol100000`001Ol0003o008000?o00000P03o`80oolBo`<00_l1000010001?l00?l20003
o`00008000?o00000P0:o`L02_l7m@03ooGe00Ke00?omOD01OD00ooem@06m@03ooGe00Ge00?o:BT0
1RT9o`QY00?oJFT01FT00om]K@06KEko2?T00ooem@05m@03ooGe00Ke00?omOD01OD00ooem@06m@Wo
24X9o`@00Ol1000000D0o`00o`020004o`00o`@000?o00000P0:o`L02_l7m@03ooGe00Ke00?omOD0
1OD00ooem@06m@03ooGe00Ge00?o:BT01RT9o`QY00?oJFT01FT00om]K@06KEko2?T00ooem@05m@03
ooGe00Ke00?omOD01OD00ooem@06m@Wo24X9o`@00Ol100000P02o`@00_l50003o`0000802_l700[o
1oD00ooem@06m@03ooGe00Ge00?omOD01_D00ooem@05m@03obTY00HY2Ol8J@03ofUY00EY00?oKFd0
1VeNo`Si00?omOD01OD00ooem@06m@03ooGe00Ge00?omOD01_D9o`Q:2Ol4007o0@0000l000?o0000
0P0:o`L02_l7m@03ooGe00Ke00?omOD01OD00ooem@06m@03ooGe00Ge00?o:BT01RT9o`QY00?oJFT0
1FT00om]K@06KEko2?T00ooem@05m@03ooGe00Ke00?omOD01OD00ooem@06m@Wo24X9o`@00Ol10000
3`000ol0000200[o1`0:o`Oe00?omOD01_D00ooem@05m@03ooGe00Ke00?omOD01OD00olY:@06:@Wo
26T00omYJ@05J@03ofe]00I]G_l8n@03ooGe00Ge00?omOD01_D00ooem@05m@03ooGe00Ke2Ol8BPWo
1001o`40000?0003o`0000802_l700[o1oD00ooem@06m@03ooGe00Ge00?omOD01_D00ooem@05m@03
obTY00HY2Ol8J@03ofUY00EY00?oKFd01VeNo`Si00?omOD01OD00ooem@06m@03ooGe00Ge00?omOD0
1_D9o`Q:2Ol4007o0@0000l000?o00000P0:o`L02_l7m@03ooGe00Ke00?omOD01OD00ooem@06m@03
ooGe00Ge00?o:BT01RT9o`QY00?oJFT01FT00om]K@06KEko2?T00ooem@05m@03ooGe00Ke00?omOD0
1OD00ooem@06m@Wo24X9o`@00Ol100003`02o`<0oolBo`<00_l100003`000ol0000200[o1`0:o`Oe
00?omOD01_D00ooem@05m@03ooGe00Ke00?omOD01OD:o`O82_l7K@03ofUY00IY00?oJFT01FT00omY
J@06J@03ofUY00EY00?oJFT01VT00omYJ@05J@03ofUY00IY2Ol8>`03oc/k00Dk2_l7n@03ooGe00Ke
00?omOD01OD00ooem@06m@03ooGe00Ge00?omOD01_D9o`Q:2Ol4007o0@0000l000?o00000P0:o`L0
2_l7m@03ooGe00Ke00?omOD01OD00ooem@06m@03ooGe00Ge2_l7b0[o1fd00omYJ@06J@03ofUY00EY
00?oJFT01VT00omYJ@05J@03ofUY00IY00?oJFT01FT00omYJ@06J@Wo23/00olk>`05>`[o1oT00ooe
m@06m@03ooGe00Ge00?omOD01_D00ooem@05m@03ooGe00Ke2Ol8BPWo1001o`40000?0003o`000080
2_l700[o1oD00ooem@06m@03ooGe00Ge00?omOD01_D00ooem@05m@[o1lP:o`M]00?oJFT01VT00omY
J@05J@03ofUY00IY00?oJFT01FT00omYJ@06J@03ofUY00EY00?oJFT01VT9o`Pk00?o>c/01C/:o`Oi
00?omOD01_D00ooem@05m@03ooGe00Ke00?omOD01OD00ooem@06m@Wo24X9o`@00Ol100003`000ol0
000200[o1`0:o`Oe00?omOD01_D00ooem@05m@03ooGe00Ke00?omOD01OD:o`O82_l7K@03ofUY00IY
00?oJFT01FT00omYJ@06J@03ofUY00EY00?oJFT01VT00omYJ@05J@03ofUY00IY2Ol8>`03oc/k00Dk
2_l7n@03ooGe00Ke00?omOD01OD00ooem@06m@03ooGe00Ge00?omOD01_D9o`Q:2Ol4007o0@0000l0
00?o00000P0:o`L02_l7m@03ooGe00Ke00?omOD01OD00ooem@06m@03ooGe00Ge2_l7b0[o1fd00omY
J@06J@03ofUY00EY00?oJFT01VT00omYJ@05J@03ofUY00IY00?oJFT01FT00omYJ@06J@Wo23/00olk
>`05>`[o1oT00ooem@06m@03ooGe00Ge00?omOD01_D00ooem@05m@03ooGe00Ke2Ol8BPWo1001o`40
000?0003o`0000802_l700[o1oD00ooem@06m@03ooGe00Ge00?omOD01_D00ooem@05m@[o1lP:o`M]
00?oJFT01VT00omYJ@05J@03ofUY00IY00?oJFT01FT00omYJ@06J@03ofUY00EY00?oJFT01VT9o`Pk
00?o>c/01C/:o`Oi00?omOD01_D00ooem@05m@03ooGe00Ke00?omOD01OD00ooem@06m@Wo24X9o`@0
0Ol100003`000ol0000200[o1`0:o`Oe00?omOD01_D00ooem@05m@03ooGe00Ke00?omOD01OD:o`O8
2_l7K@03ofUY00IY00?oJFT01FT00omYJ@06J@03ofUY00EY00?oJFT01VT00omYJ@05J@03ofUY00IY
2Ol8>`03oc/k00Dk2_l7n@03ooGe00Ke00?omOD01OD00ooem@06m@03ooGe00Ge00?omOD01_D9o`Q:
2Ol4007o0@0000l000?o00000P0:o`L02_l7m@03ooGe00Ke00?omOD01OD00ooem@06m@03ooGe00Ge
2_l7b0[o1fd00omYJ@06J@03ofUY00EY00?oJFT01VT00omYJ@05J@03ofUY00IY00?oJFT01FT00omY
J@06J@Wo23/00olk>`05>`[o1oT00ooem@06m@03ooGe00Ge00?omOD01_D00ooem@05m@03ooGe00Ke
2Ol8BPWo1001o`40000?00;o0`3ooa;o0`02o`40000?0003o`00008000?o00001P0Jo`Se00?omOD0
1OD00ooem@06m@03ooWi00Gi4_l8BPWo26T00omYJ@05J@03ofUY00IY00?oJFT01FT00omYJ@06J@03
ofUY00EY4_l8>`03oc/k00Dk2_l7m@03ooGe00Ke00?omOD01OD00ooem@06m@03ooGe00Ge00?omOD0
1_D9o`Q:2Ol4007o0@0000l000?o00000P000ol0000601[o2?D00ooem@05m@03ooGe00Ke00?onOT0
1OTBo`Q:2Ol8J@03ofUY00EY00?oJFT01VT00omYJ@05J@03ofUY00IY00?oJFT01FTBo`Pk00?o>c/0
1C/:o`Oe00?omOD01_D00ooem@05m@03ooGe00Ke00?omOD01OD00ooem@06m@Wo24X9o`@00Ol10000
3`000ol000020003o`0000H06_l8m@03ooGe00Ge00?omOD01_D00ooin@05nA;o24X9o`QY00?oJFT0
1FT00omYJ@06J@03ofUY00EY00?oJFT01VT00omYJ@05JA;o23/00olk>`05>`[o1oD00ooem@06m@03
ooGe00Ge00?omOD01_D00ooem@05m@03ooGe00Ke2Ol8BPWo1001o`40000?0003o`00008000?o0000
1P0Jo`Se00?omOD01OD00ooem@06m@03ooWi00Gi4_l8BPWo26T00omYJ@05J@03ofUY00IY00?oJFT0
1FT00omYJ@06J@03ofUY00EY4_l8>`03oc/k00Dk2_l7m@03ooGe00Ke00?omOD01OD00ooem@06m@03
ooGe00Ge00?omOD01_D9o`Q:2Ol4007o0@0000l000?o00000P000ol0000601[o2?D00ooem@05m@03
ooGe00Ke00?onOT01OTBo`Q:2Ol8J@03ofUY00EY00?oJFT01VT00omYJ@05J@03ofUY00IY00?oJFT0
1FTBo`Pk00?o>c/01C/:o`Oe00?omOD01_D00ooem@05m@03ooGe00Ke00?omOD01OD00ooem@06m@Wo
24X9o`@00Ol100003`000ol000020003o`0000H06_l8m@03ooGe00Ge00?omOD01_D00ooin@05nA;o
24X9o`QY00?oJFT01FT00omYJ@06J@03ofUY00EY00?oJFT01VT00omYJ@05JA;o23/00olk>`05>`[o
1oD00ooem@06m@03ooGe00Ge00?omOD01_D00ooem@05m@03ooGe00Ke2Ol8BPWo1001o`40000?0003
o`00008000?o00001P0Jo`Se00?omOD01OD00ooem@06m@03ooWi00Gi4_l8BPWo26T00omYJ@05J@03
ofUY00IY00?oJFT01FT00omYJ@06J@03ofUY00EY4_l8>`03oc/k00Dk2_l7m@03ooGe00Ke00?omOD0
1OD00ooem@06m@03ooGe00Ge00?omOD01_D9o`Q:2Ol4007o0@0000l00_l30?oo4_l300;o0@0000l0
00?o00000P0:o`L02_l7m@03ooGe00Ke00?omOD01OD00ooem@06mA;o1dX00om:BP06BPWo26d00omY
J@05J@03ofUY00IY00?oJFT01FT00omYJ@06J@Wo28T00on9R@05R@[o1c/:o`Oe00?omOD01_D00ooe
m@05m@03ooGe00Ke00?omOD01OD00ooem@06m@Wo24X9o`@00Ol100003`000ol0000200[o1`0:o`Oe
00?omOD01_D00ooem@05m@03ooGe00Ke4_l7BP03odY:00I:2Ol8K@03ofUY00EY00?oJFT01VT00omY
J@05J@03ofUY00IY2Ol8R@03ohV900F92_l7>`[o1oD00ooem@06m@03ooGe00Ge00?omOD01_D00ooe
m@05m@03ooGe00Ke2Ol8BPWo1001o`40000?0003o`0000802_l700[o1oD00ooem@06m@03ooGe00Ge
00?omOD01_DBo`M:00?oBTX01TX9o`Q]00?oJFT01FT00omYJ@06J@03ofUY00EY00?oJFT01VT9o`R9
00?oRHT01HT:o`Lk2_l7m@03ooGe00Ke00?omOD01OD00ooem@06m@03ooGe00Ge00?omOD01_D9o`Q:
2Ol4007o0@0000l000?o00000P0:o`L02_l7m@03ooGe00Ke00?omOD01OD00ooem@06mA;o1dX00om:
BP06BPWo26d00omYJ@05J@03ofUY00IY00?oJFT01FT00omYJ@06J@Wo28T00on9R@05R@[o1c/:o`Oe
00?omOD01_D00ooem@05m@03ooGe00Ke00?omOD01OD00ooem@06m@Wo24X9o`@00Ol100003`000ol0
000200[o1`0:o`Oe00?omOD01_D00ooem@05m@03ooGe00Ke4_l7BP03odY:00I:2Ol8K@03ofUY00EY
00?oJFT01VT00omYJ@05J@03ofUY00IY2Ol8R@03ohV900F92_l7>`[o1oD00ooem@06m@03ooGe00Ge
00?omOD01_D00ooem@05m@03ooGe00Ke2Ol8BPWo1001o`40000?0003o`0000802_l700[o1oD00ooe
m@06m@03ooGe00Ge00?omOD01_DBo`M:00?oBTX01TX9o`Q]00?oJFT01FT00omYJ@06J@03ofUY00EY
00?oJFT01VT9o`R900?oRHT01HT:o`Lk2_l7m@03ooGe00Ke00?omOD01OD00ooem@06m@03ooGe00Ge
00?omOD01_D9o`Q:2Ol4007o0@0000l000?o00000P0:o`L02_l7m@03ooGe00Ke00?omOD01OD00ooe
m@06mA;o1dX00om:BP06BPWo26d00omYJ@05J@03ofUY00IY00?oJFT01FT00omYJ@06J@Wo28T00on9
R@05R@[o1c/:o`Oe00?omOD01_D00ooem@05m@03ooGe00Ke00?omOD01OD00ooem@06m@Wo24X9o`@0
0Ol100003`000ol0000200[o1`0:o`Oe00?omOD01_D00ooem@05m@03ooGe00Ke4_l7BP03odY:00I:
2Ol8K@03ofUY00EY00?oJFT01VT00omYJ@05J@03ofUY00IY2Ol8R@03ohV900F92_l7>`[o1oD00ooe
m@06m@03ooGe00Ge00?omOD01_D00ooem@05m@03ooGe00Ke2Ol8BPWo1001o`40000?00;o0`3ooa;o
0`02o`40000?0003o`0000802_l700[o1oD00ooem@06m@03ooGe00Ge00?omOD01_D9o`Q:00?o:BT0
1BTKo`MY00?oJFT01VT00omYJ@05J@03ofe]00I]4_l7R@03ohV900J94_l7m@03ooGe00Ke00?omOD0
1OD00ooem@06m@03ooGe00Ge00?omOD01_D9o`Q:2Ol4007o0@0000l000?o00000P0:o`L02_l7m@03
ooGe00Ke00?omOD01OD00ooem@06m@Wo24X00olY:@05:A_o1fT00omYJ@06J@03ofUY00EY00?oKFd0
1VdBo`N900?oRHT01XTBo`Oe00?omOD01_D00ooem@05m@03ooGe00Ke00?omOD01OD00ooem@06m@Wo
24X9o`@00Ol100003`000ol0000200[o1`0:o`Oe00?omOD01_D00ooem@05m@03ooGe00Ke2Ol8BP03
obTY00DY6ol7J@03ofUY00IY00?oJFT01FT00om]K@06KA;o1hT00on9R@06RA;o1oD00ooem@06m@03
ooGe00Ge00?omOD01_D00ooem@05m@03ooGe00Ke2Ol8BPWo1001o`40000?0003o`0000802_l700[o
1oD00ooem@06m@03ooGe00Ge00?omOD01_D9o`Q:00?o:BT01BTKo`MY00?oJFT01VT00omYJ@05J@03
ofe]00I]4_l7R@03ohV900J94_l7m@03ooGe00Ke00?omOD01OD00ooem@06m@03ooGe00Ge00?omOD0
1_D9o`Q:2Ol4007o0@0000l000?o00000P0:o`L02_l7m@03ooGe00Ke00?omOD01OD00ooem@06m@Wo
24X00olY:@05:A_o1fT00omYJ@06J@03ofUY00EY00?oKFd01VdBo`N900?oRHT01XTBo`Oe00?omOD0
1_D00ooem@05m@03ooGe00Ke00?omOD01OD00ooem@06m@Wo24X9o`@00Ol1000000<0ool00_l200?o
1@000ol0000200[o1`0:o`Oe00?omOD01_D00ooem@05m@03ooGe00Ke2Ol8BP03obTY00DY6ol7J@03
ofUY00IY00?oJFT01FT00om]K@06KA;o1hT00on9R@06RA;o1oD00ooem@06m@03ooGe00Ge00?omOD0
1_D00ooem@05m@03ooGe00Ke2Ol8BPWo1001o`4000020003o`0000D000?o00000P000ol0000200[o
1`0:o`Oe00?omOD01_D00ooem@05m@03ooGe00Ke2Ol8BP03obTY00DY6ol7J@03ofUY00IY00?oJFT0
1FT00om]K@06KA;o1hT00on9R@06RA;o1oD00ooem@06m@03ooGe00Ge00?omOD01_D00ooem@05m@03
ooGe00Ke2Ol8BPWo1001o`4000030003o`0000@000?o00000P03o`80oolBo`<00_l1000010000ol0
0003o`D000?o00000P000ol0000601[o2?D00ooem@05m@03ooGe00Ke6_l8n@03ooGe00Ge00?onOT0
1_T9o`QY00?oKFd01Fd:o`Oe00?oKFd01VdBo`N92_l7m@03ooGe00Ke00?omOD01OD00ooem@06m@03
ooGe00Ge00?omOD01_D9o`Q:2Ol4007o0@0000050?l00?l00P000ol000050003o`00008000?o0000
1P0Jo`Se00?omOD01OD00ooem@06mA[o2?T00ooem@05m@03ooWi00Ki2Ol8J@03ofe]00E]2_l7m@03
ofe]00I]4_l7R@[o1oD00ooem@06m@03ooGe00Ge00?omOD01_D00ooem@05m@03ooGe00Ke2Ol8BPWo
1001o`40000200;o0`04o`@000?o00000P000ol0000601[o2?D00ooem@05m@03ooGe00Ke6_l8n@03
ooGe00Ge00?onOT01_T9o`QY00?oKFd01Fd:o`Oe00?oKFd01VdBo`N92_l7m@03ooGe00Ke00?omOD0
1OD00ooem@06m@03ooGe00Ge00?omOD01_D9o`Q:2Ol4007o0@0000l000?o00000P000ol0000601[o
2?D00ooem@05m@03ooGe00Ke6_l8n@03ooGe00Ge00?onOT01_T9o`QY00?oKFd01Fd:o`Oe00?oKFd0
1VdBo`N92_l7m@03ooGe00Ke00?omOD01OD00ooem@06m@03ooGe00Ge00?omOD01_D9o`Q:2Ol4007o
0@0000l000?o00000P000ol0000601[o2?D00ooem@05m@03ooGe00Ke6_l8n@03ooGe00Ge00?onOT0
1_T9o`QY00?oKFd01Fd:o`Oe00?oKFd01VdBo`N92_l7m@03ooGe00Ke00?omOD01OD00ooem@06m@03
ooGe00Ge00?omOD01_D9o`Q:2Ol4007o0@0000l000?o00000P000ol0000601[o2?D00ooem@05m@03
ooGe00Ke6_l8n@03ooGe00Ge00?onOT01_T9o`QY00?oKFd01Fd:o`Oe00?oKFd01VdBo`N92_l7m@03
ooGe00Ke00?omOD01OD00ooem@06m@03ooGe00Ge00?omOD01_D9o`Q:2Ol4007o0@0000l000?o0000
0P000ol0000601[o2?D00ooem@05m@03ooGe00Ke6_l8n@03ooGe00Ge00?onOT01_T9o`QY00?oKFd0
1Fd:o`Oe00?oKFd01VdBo`N92_l7m@03ooGe00Ke00?omOD01OD00ooem@06m@03ooGe00Ge00?omOD0
1_D9o`Q:2Ol4007o0@0000l000?o00000P000ol0000601[o2?D00ooem@05m@03ooGe00Ke6_l8n@03
ooGe00Ge00?onOT01_T9o`QY00?oKFd01Fd:o`Oe00?oKFd01VdBo`N92_l7m@03ooGe00Ke00?omOD0
1OD00ooem@06m@03ooGe00Ge00?omOD01_D9o`Q:2Ol4007o0@0000l00_l30?oo4_l300;o0@0000l0
00?o00000P0:o`L02_l7m@03ooGe00Ke00?omOD01OD00ooem@06m@03ooGe00Ge00?omOD01_D00ooe
m@05m@03ooGe00Ke00?omOD01OD00ooem@06m@Wo26T9o`Se00?omOD01OD00ooem@06m@03ooGe00Ge
00?onOT01_TBo`Oe00?omOD01_D00ooem@05m@03ooGe00Ke00?omOD01OD00ooem@06m@Wo24X9o`@0
0Ol100003`000ol0000200[o1`0:o`Oe00?omOD01_D00ooem@05m@03ooGe00Ke00?omOD01OD00ooe
m@06m@03ooGe00Ge00?omOD01_D00ooem@05m@03ooGe00Ke2Ol8J@Wo2?D00ooem@05m@03ooGe00Ke
00?omOD01OD00ooin@06nA;o1oD00ooem@06m@03ooGe00Ge00?omOD01_D00ooem@05m@03ooGe00Ke
2Ol8BPWo1001o`40000?0003o`0000802_l700[o1oD00ooem@06m@03ooGe00Ge00?omOD01_D00ooe
m@05m@03ooGe00Ke00?omOD01OD00ooem@06m@03ooGe00Ge00?omOD01_D9o`QY2Ol8m@03ooGe00Ge
00?omOD01_D00ooem@05m@03ooWi00Ki4_l7m@03ooGe00Ke00?omOD01OD00ooem@06m@03ooGe00Ge
00?omOD01_D9o`Q:2Ol4007o0@0000l000?o00000P0:o`L02_l7m@03ooGe00Ke00?omOD01OD00ooe
m@06m@03ooGe00Ge00?omOD01_D00ooem@05m@03ooGe00Ke00?omOD01OD00ooem@06m@Wo26T9o`Se
00?omOD01OD00ooem@06m@03ooGe00Ge00?onOT01_TBo`Oe00?omOD01_D00ooem@05m@03ooGe00Ke
00?omOD01OD00ooem@06m@Wo24X9o`@00Ol100003`000ol0000200[o1`0:o`Oe00?omOD01_D00ooe
m@05m@03ooGe00Ke00?omOD01OD00ooem@06m@03ooGe00Ge00?omOD01_D00ooem@05m@03ooGe00Ke
2Ol8J@Wo2?D00ooem@05m@03ooGe00Ke00?omOD01OD00ooin@06nA;o1oD00ooem@06m@03ooGe00Ge
00?omOD01_D00ooem@05m@03ooGe00Ke2Ol8BPWo1001o`40000?0003o`0000802_l700[o1oD00ooe
m@06m@03ooGe00Ge00?omOD01_D00ooem@05m@03ooGe00Ke00?omOD01OD00ooem@06m@03ooGe00Ge
00?omOD01_D9o`QY2Ol8m@03ooGe00Ge00?omOD01_D00ooem@05m@03ooWi00Ki4_l7m@03ooGe00Ke
00?omOD01OD00ooem@06m@03ooGe00Ge00?omOD01_D9o`Q:2Ol4007o0@0000l000?o00000P0:o`L0
2_l7m@03ooGe00Ke00?omOD01OD00ooem@06m@03ooGe00Ge00?omOD01_D00ooem@05m@03ooGe00Ke
00?omOD01OD00ooem@06m@Wo26T9o`Se00?omOD01OD00ooem@06m@03ooGe00Ge00?onOT01_TBo`Oe
00?omOD01_D00ooem@05m@03ooGe00Ke00?omOD01OD00ooem@06m@Wo24X9o`@00Ol100003`02o`<0
oolBo`<00_l100003`000ol0000200[o1`0:o`Oe00?omOD01_D00ooem@05m@03ooGe00Ke00?omOD0
1OD00ooem@06m@03ooGe00Ge00?omOD01_D00ooem@05m@03ooGe00Ke00?omOD01OD:o`Oe00?omOD0
1_D00ooem@05m@03ooGe00Ke00?omOD01OD00ooem@06m@03ooGe00Ge00?oKFd01Vd00ooem@05m@03
ooGe00Ke00?omOD01OD00ooem@06m@03ooGe00Ge00?omOD01_D9o`Q:2Ol4007o0@0000l000?o0000
0P0:o`L02_l7m@03ooGe00Ke00?omOD01OD00ooem@06m@03ooGe00Ge00?omOD01_D00ooem@05m@03
ooGe00Ke00?omOD01OD00ooem@06m@03ooGe00Ge2_l7m@03ooGe00Ke00?omOD01OD00ooem@06m@03
ooGe00Ge00?omOD01_D00ooem@05m@03ofe]00I]00?omOD01OD00ooem@06m@03ooGe00Ge00?omOD0
1_D00ooem@05m@03ooGe00Ke2Ol8BPWo1001o`40000?0003o`0000802_l700[o1oD00ooem@06m@03
ooGe00Ge00?omOD01_D00ooem@05m@03ooGe00Ke00?omOD01OD00ooem@06m@03ooGe00Ge00?omOD0
1_D00ooem@05m@[o1oD00ooem@06m@03ooGe00Ge00?omOD01_D00ooem@05m@03ooGe00Ke00?omOD0
1OD00om]K@06K@03ooGe00Ge00?omOD01_D00ooem@05m@03ooGe00Ke00?omOD01OD00ooem@06m@Wo
24X9o`@00Ol100003`000ol0000200[o1`0:o`Oe00?omOD01_D00ooem@05m@03ooGe00Ke00?omOD0
1OD00ooem@06m@03ooGe00Ge00?omOD01_D00ooem@05m@03ooGe00Ke00?omOD01OD:o`Oe00?omOD0
1_D00ooem@05m@03ooGe00Ke00?omOD01OD00ooem@06m@03ooGe00Ge00?oKFd01Vd00ooem@05m@03
ooGe00Ke00?omOD01OD00ooem@06m@03ooGe00Ge00?omOD01_D9o`Q:2Ol4007o0@0000l000?o0000
0P0:o`L02_l7m@03ooGe00Ke00?omOD01OD00ooem@06m@03ooGe00Ge00?omOD01_D00ooem@05m@03
ooGe00Ke00?omOD01OD00ooem@06m@03ooGe00Ge2_l7m@03ooGe00Ke00?omOD01OD00ooem@06m@03
ooGe00Ge00?omOD01_D00ooem@05m@03ofe]00I]00?omOD01OD00ooem@06m@03ooGe00Ge00?omOD0
1_D00ooem@05m@03ooGe00Ke2Ol8BPWo1001o`40000?0003o`0000802_l700[o1oD00ooem@06m@03
ooGe00Ge00?omOD01_D00ooem@05m@03ooGe00Ke00?omOD01OD00ooem@06m@03ooGe00Ge00?omOD0
1_D00ooem@05m@[o1oD00ooem@06m@03ooGe00Ge00?omOD01_D00ooem@05m@03ooGe00Ke00?omOD0
1OD00om]K@06K@03ooGe00Ge00?omOD01_D00ooem@05m@03ooGe00Ke00?omOD01OD00ooem@06m@Wo
24X9o`@00Ol100003`000ol0000200[o1`0:o`Oe00?omOD01_D00ooem@05m@03ooGe00Ke00?omOD0
1OD00ooem@06m@03ooGe00Ge00?omOD01_D00ooem@05m@03ooGe00Ke00?omOD01OD:o`Oe00?omOD0
1_D00ooem@05m@03ooGe00Ke00?omOD01OD00ooem@06m@03ooGe00Ge00?oKFd01Vd00ooem@05m@03
ooGe00Ke00?omOD01OD00ooem@06m@03ooGe00Ge00?omOD01_D9o`Q:2Ol4007o0@0000l000?o0000
0P0:o`L02_l7m@03ooGe00Ke00?omOD01OD00ooem@06m@03ooGe00Ge00?omOD01_D00ooem@05m@03
ooGe00Ke00?omOD01OD00ooem@06m@03ooGe00Ge2_l7m@03ooGe00Ke00?omOD01OD00ooem@06m@03
ooGe00Ge00?omOD01_D00ooem@05m@03ofe]00I]00?omOD01OD00ooem@06m@03ooGe00Ge00?omOD0
1_D00ooem@05m@03ooGe00Ke2Ol8BPWo1001o`40000?00;o0`3ooa;o0`02o`40000?0003o`000080
00?o00001P0Jo`Se00?omOD01OD00ooem@06m@03ooGe00Ge00?omOD01_D00ooem@05m@03ooGe00Ke
00?omOD01OD00ooem@06m@03ooGe00Ge00?omOD01_D00ooem@05m@03ooGe00Ke00?omOD01OD00ooe
m@06m@03ooGe00Ge00?omOD01_D00ooem@05m@03ooGe00Ke00?omOD01OD00ooem@06m@03ooGe00Ge
00?omOD01_D00ooem@05m@03ooGe00Ke2Ol8BPWo1001o`40000?0003o`00008000?o00001P0Jo`Se
00?omOD01OD00ooem@06m@03ooGe00Ge00?omOD01_D00ooem@05m@03ooGe00Ke00?omOD01OD00ooe
m@06m@03ooGe00Ge00?omOD01_D00ooem@05m@03ooGe00Ke00?omOD01OD00ooem@06m@03ooGe00Ge
00?omOD01_D00ooem@05m@03ooGe00Ke00?omOD01OD00ooem@06m@03ooGe00Ge00?omOD01_D00ooe
m@05m@03ooGe00Ke2Ol8BPWo1001o`40000?0003o`00008000?o00001P0Jo`Se00?omOD01OD00ooe
m@06m@03ooGe00Ge00?omOD01_D00ooem@05m@03ooGe00Ke00?omOD01OD00ooem@06m@03ooGe00Ge
00?omOD01_D00ooem@05m@03ooGe00Ke00?omOD01OD00ooem@06m@03ooGe00Ge00?omOD01_D00ooe
m@05m@03ooGe00Ke00?omOD01OD00ooem@06m@03ooGe00Ge00?omOD01_D00ooem@05m@03ooGe00Ke
2Ol8BPWo1001o`40000?0003o`00008000?o00001P0Jo`Se00?omOD01OD00ooem@06m@03ooGe00Ge
00?omOD01_D00ooem@05m@03ooGe00Ke00?omOD01OD00ooem@06m@03ooGe00Ge00?omOD01_D00ooe
m@05m@03ooGe00Ke00?omOD01OD00ooem@06m@03ooGe00Ge00?omOD01_D00ooem@05m@03ooGe00Ke
00?omOD01OD00ooem@06m@03ooGe00Ge00?omOD01_D00ooem@05m@03ooGe00Ke2Ol8BPWo1001o`40
000?0003o`00008000?o00001P0Jo`Se00?omOD01OD00ooem@06m@03ooGe00Ge00?omOD01_D00ooe
m@05m@03ooGe00Ke00?omOD01OD00ooem@06m@03ooGe00Ge00?omOD01_D00ooem@05m@03ooGe00Ke
00?omOD01OD00ooem@06m@03ooGe00Ge00?omOD01_D00ooem@05m@03ooGe00Ke00?omOD01OD00ooe
m@06m@03ooGe00Ge00?omOD01_D00ooem@05m@03ooGe00Ke2Ol8BPWo1001o`40000?0003o`000080
00?o00001P0Jo`Se00?omOD01OD00ooem@06m@03ooGe00Ge00?omOD01_D00ooem@05m@03ooGe00Ke
00?omOD01OD00ooem@06m@03ooGe00Ge00?omOD01_D00ooem@05m@03ooGe00Ke00?omOD01OD00ooe
m@06m@03ooGe00Ge00?omOD01_D00ooem@05m@03ooGe00Ke00?omOD01OD00ooem@06m@03ooGe00Ge
00?omOD01_D00ooem@05m@03ooGe00Ke2Ol8BPWo1001o`40000?0003o`00008000?o00001P0Jo`Se
00?omOD01OD00ooem@06m@03ooGe00Ge00?omOD01_D00ooem@05m@03ooGe00Ke00?omOD01OD00ooe
m@06m@03ooGe00Ge00?omOD01_D00ooem@05m@03ooGe00Ke00?omOD01OD00ooem@06m@03ooGe00Ge
00?omOD01_D00ooem@05m@03ooGe00Ke00?omOD01OD00ooem@06m@03ooGe00Ge00?omOD01_D00ooe
m@05m@03ooGe00Ke2Ol8BPWo1001o`40000?00;o0`3ooa;o0`02o`40000?0003o`0000802_l700[o
1oD00ooem@06m@03ooGe00Ge00?omOD01_D00ooem@05m@03ooGe00Ke00?omOD01OD00ooem@06m@03
ooGe00Ge00?omOD01_D00ooem@05m@03ooGe00Ke00?omOD01OD00ooem@06m@03ooGe00Ge00?omOD0
1_D00ooem@05m@03ooGe00Ke00?omOD01OD00ooem@06m@03ooGe00Ge00?omOD01_D00ooem@05m@03
ooGe00Ke00?omOD01OD00ooem@06m@Wo24X9o`@00Ol100003`000ol0000200[o1`0:o`Oe00?omOD0
1_D00ooem@05m@03ooGe00Ke00?omOD01OD00ooem@06m@03ooGe00Ge00?omOD01_D00ooem@05m@03
ooGe00Ke00?omOD01OD00ooem@06m@03ooGe00Ge00?omOD01_D00ooem@05m@03ooGe00Ke00?omOD0
1OD00ooem@06m@03ooGe00Ge00?omOD01_D00ooem@05m@03ooGe00Ke00?omOD01OD00ooem@06m@03
ooGe00Ge00?omOD01_D9o`Q:2Ol4007o0@0000l000?o00000P0:o`L02_l7m@03ooGe00Ke00?omOD0
1OD00ooem@06m@03ooGe00Ge00?omOD01_D00ooem@05m@03ooGe00Ke00?omOD01OD00ooem@06m@03
ooGe00Ge00?omOD01_D00ooem@05m@03ooGe00Ke00?omOD01OD00ooem@06m@03ooGe00Ge00?omOD0
1_D00ooem@05m@03ooGe00Ke00?omOD01OD00ooem@06m@03ooGe00Ge00?omOD01_D00ooem@05m@03
ooGe00Ke2Ol8BPWo1001o`40000?0003o`0000802_l700[o1oD00ooem@06m@03ooGe00Ge00?omOD0
1_D00ooem@05m@03ooGe00Ke00?omOD01OD00ooem@06m@03ooGe00Ge00?omOD01_D00ooem@05m@03
ooGe00Ke00?omOD01OD00ooem@06m@03ooGe00Ge00?omOD01_D00ooem@05m@03ooGe00Ke00?omOD0
1OD00ooem@06m@03ooGe00Ge00?omOD01_D00ooem@05m@03ooGe00Ke00?omOD01OD00ooem@06m@Wo
24X9o`@00Ol100003`000ol0000200[o1`0:o`Oe00?omOD01_D00ooem@05m@03ooGe00Ke00?omOD0
1OD00ooem@06m@03ooGe00Ge00?omOD01_D00ooem@05m@03ooGe00Ke00?omOD01OD00ooem@06m@03
ooGe00Ge00?omOD01_D00ooem@05m@03ooGe00Ke00?omOD01OD00ooem@06m@03ooGe00Ge00?omOD0
1_D00ooem@05m@03ooGe00Ke00?omOD01OD00ooem@06m@03ooGe00Ge00?omOD01_D9o`Q:2Ol4007o
0@0000l000?o00000P0:o`L02_l7m@03ooGe00Ke00?omOD01OD00ooem@06m@03ooGe00Ge00?omOD0
1_D00ooem@05m@03ooGe00Ke00?omOD01OD00ooem@06m@03ooGe00Ge00?omOD01_D00ooem@05m@03
ooGe00Ke00?omOD01OD00ooem@06m@03ooGe00Ge00?omOD01_D00ooem@05m@03ooGe00Ke00?omOD0
1OD00ooem@06m@03ooGe00Ge00?omOD01_D00ooem@05m@03ooGe00Ke2Ol8BPWo1001o`400000103o
ool400;o1@000ol0000200[o1`0:o`Oe00?omOD01_D00ooem@05m@03ooGe00Ke00?omOD01OD00ooe
m@06m@03ooGe00Ge00?omOD01_D00ooem@05m@03ooGe00Ke00?omOD01OD00ooem@06m@03ooGe00Ge
00?omOD01_D00ooem@05m@03ooGe00Ke00?omOD01OD00ooem@06m@03ooGe00Ge00?omOD01_D00ooe
m@05m@03ooGe00Ke00?omOD01OD00ooem@06m@03ooGe00Ge00?omOD01_D9o`Q:2Ol4007o0@0000@0
00Co003o0P000ol000020003o`0000802_l700[o1oD00ooem@06m@03ooGe00Ge00?omOD01_D00ooe
m@05m@03ooGe00Ke00?omOD01OD00ooem@06m@03ooGe00Ge00?omOD01_D00ooem@05m@03ooGe00Ke
00?omOD01OD00ooem@06m@03ooGe00Ge00?omOD01_D00ooem@05m@03ooGe00Ke00?omOD01OD00ooe
m@06m@03ooGe00Ge00?omOD01_D00ooem@05m@03ooGe00Ke00?omOD01OD00ooem@06m@Wo24X9o`@0
0Ol1000010001?l00?l20003o`0000800ol20?oo4_l300;o0@0000800_l30004o`00o`@000?o0000
0P0:o`L02_l7m@03ooGe00Ke00?omOD01OD00ooem@06m@03ooGe00Ge00?omOD01_D00ooem@05m@03
ooGe00Ke00?omOD01OD00ooem@06m@03ooGe00Ge00?omOD01_D00ooem@05m@03ooGe00Ke00?omOD0
1OD00ooem@06m@03ooGe00Ge00?omOD01_D00ooem@05m@03ooGe00Ke00?omOD01OD00ooem@06m@03
ooGe00Ge00?omOD01_D00ooem@05m@03ooGe00Ke4_l70003o`0000800Ol1000010001?l00?l20003
o`00008000?o00000P0:o`L02_l7m@03ooGe00Ke00?omOD01OD00ooem@06m@03ooGe00Ge00?omOD0
1_D00ooem@05m@03ooGe00Ke00?omOD01OD00ooem@06m@03ooGe00Ge00?omOD01_D00ooem@05m@03
ooGe00Ke00?omOD01OD00ooem@06m@03ooGe00Ge00?omOD01_D00ooem@05m@03ooGe00Ke00?omOD0
1OD00ooem@06m@03ooGe00Ge00?omOD01_D00ooem@05m@03ooGe00Ke4_l70003o`0000800Ol10000
00@0oooo1002o`D000?o00000P0:o`L02_l7m@03ooGe00Ke00?omOD01OD00ooem@06m@03ooGe00Ge
00?omOD01_D00ooem@05m@03ooGe00Ke00?omOD01OD00ooem@06m@03ooGe00Ge00?omOD01_D00ooe
m@05m@03ooGe00Ke00?omOD01OD00ooem@06m@03ooGe00Ge00?omOD01_D00ooem@05m@03ooGe00Ke
00?omOD01OD00ooem@06m@03ooGe00Ge00?omOD01_D00ooem@05m@03ooGe00Ke4_l70003o`000080
0Ol100003`000ol0000200[o1`0:o`Oe00?omOD01_D00ooem@05m@03ooGe00Ke00?omOD01OD00ooe
m@06m@03ooGe00Ge00?omOD01_D00ooem@05m@03ooGe00Ke00?omOD01OD00ooem@06m@03ooGe00Ge
00?omOD01_D00ooem@05m@03ooGe00Ke00?omOD01OD00ooem@06m@03ooGe00Ge00?omOD01_D00ooe
m@05m@03ooGe00Ke00?omOD01OD00ooem@06m@03ooGe00Ge00?omOD01_DBo`L000?o00000P01o`40
000?0003o`0000802_l700[o1oD00ooem@06m@03ooGe00Ge00?omOD01_D00ooem@05m@03ooGe00Ke
00?omOD01OD00ooem@06m@03ooGe00Ge00?omOD01_D00ooem@05m@03ooGe00Ke00?omOD01OD00ooe
m@06m@03ooGe00Ge00?omOD01_D00ooem@05m@03ooGe00Ke00?omOD01OD00ooem@06m@03ooGe00Ge
00?omOD01_D00ooem@05m@03ooGe00Ke00?omOD01OD00ooem@06mA;o1`000ol00002007o0@0000l0
00?o00000P0:o`L02_l7m@03ooGe00Ke00?omOD01OD00ooem@06m@03ooGe00Ge00?omOD01_D00ooe
m@05m@03ooGe00Ke00?omOD01OD00ooem@06m@03ooGe00Ge00?omOD01_D00ooem@05m@03ooGe00Ke
00?omOD01OD00ooem@06m@03ooGe00Ge00?omOD01_D00ooem@05m@03ooGe00Ke00?omOD01OD00ooe
m@06m@03ooGe00Ge00?omOD01_D00ooem@05m@03ooGe00Ke4_l70003o`0000800Ol100003`000ol0
000200[o1`0:o`Oe00?omOD01_D00ooem@05m@03ooGe00Ke00?omOD01OD00ooem@06m@03ooGe00Ge
00?omOD01_D00ooem@05m@03ooGe00Ke00?omOD01OD00ooem@06m@03ooGe00Ge00?omOD01_D00ooe
m@05m@03ooGe00Ke00?omOD01OD00ooem@06m@03ooGe00Ge00?omOD01_D00ooem@05m@03ooGe00Ke
00?omOD01OD00ooem@06m@03ooGe00Ge00?omOD01_DBo`L000?o00000P01o`40000?00;o0`3ooa;o
0`02o`40000?0003o`00008000?o00001P3go`P000?o00001@000ol00002007o0@0000l000?o0000
0P000ol000060?Oo20000ol000050003o`0000800Ol100003`000ol000020003o`0000H0mol80003
o`0000D000?o00000P01o`40000?0003o`00008000?o00001P3go`P000?o00001@000ol00002007o
0@0000l000?o00000P000ol000060?Oo20000ol000050003o`0000800Ol100003`000ol000020003
o`0000H0mol80003o`0000D000?o00000P01o`40000?0003o`00008000?o00001P3go`P000?o0000
1@000ol00002007o0@0000l000?o00000P000ol000060?Oo20000ol000050003o`0000800Ol10000
3`02o`<0oolBo`<00_l100003`000ol0003o01P00Ol100003`000ol0003o01P00Ol100003`000ol0
00020003o`0002P000?o00009`000ol0000X0003o`0002L000?o0000:0000ol0000W0003o`0001<0
0Ol100003`000ol000020003o`0000H000?o00001@000ol000060003o`0000D000?o00001P000ol0
00050003o`0000H000?o00001@000ol000060003o`0000D000?o00001P000ol000050003o`0000H0
00?o00001@000ol000060003o`0000D000?o00001P000ol000050003o`0000H000?o00001@000ol0
00060003o`0000D000?o00001P000ol000050003o`0000H000?o00001@000ol000060003o`0000D0
00?o00001P000ol000050003o`0000H000?o00001@000ol00002007o0@0000l0oolLo`40003o02`0
0000\
\>"],
  ImageRangeCache->{{{0, 298.062}, {298.062, 0}} -> {-2.47031, -2.30091, 
  0.117845, 0.117845}}]
}, Closed]],

Cell[TextData[{
  "Note that the built-in plotting commands expect a list of real numbers, \
and will print an error message if we try to plot a list containing any \
complex numbers, strings, or undefined symbols. For example, the package ",
  StyleBox["Miscellaneous`ChemicalElements`", "Input"],
  " contains data related to the chemical elements."
}], "Text"],

Cell[BoxData[
    \(Needs["\<Miscellaneous`ChemicalElements`\>"]\)], "Input"],

Cell[TextData[{
  "Here we create a scatter plot of the atomic weight divided by the atomic \
number of each element. (",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " warns that several of the elements do not have a stable isotope, which we \
can ignore for this example.)"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(elementdata = AtomicWeight[Elements]/AtomicNumber[Elements]; \)\)], 
  "Input"],

Cell[BoxData[
    \(AtomicWeight::"unstable" \( : \ \) 
      "No stable isotope of \!\(Technetium\) exists."\)], "Message"],

Cell[BoxData[
    \(AtomicWeight::"unstable" \( : \ \) 
      "No stable isotope of \!\(Promethium\) exists."\)], "Message"],

Cell[BoxData[
    \(General::"stop" \( : \ \) 
      "Further output of \!\(AtomicWeight :: \"unstable\"\) will be \
suppressed during this calculation."\)], "Message"]
}, Closed]],

Cell[TextData[{
  "Here are the first ten data points of ",
  StyleBox["elementdata", "Input"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Take[elementdata, 10]\)], "Input"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        StyleBox["1.00794000000000005`",
          StyleBoxAutoDelete->True,
          PrintPrecision->6], ",", "2.00130000000000007`", ",", 
        "2.31366666666666676`", ",", "2.25304500000000018`", ",", 
        "2.16199999999999992`", ",", "2.00183333333333335`", ",", 
        "2.0009571428571431`", ",", "1.99992499999999999`", ",", 
        "2.11093366666666648`", ",", "2.01790000000000002`"}], "}"}]], 
  "Output"]
}, Closed]],

Cell["Here is a scatter plot of the ratios.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(ListPlot[elementdata]; \)\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.00898473 -0.906059 0.581481 [
[.2035 .2444 -6 -9 ]
[.2035 .2444 6 0 ]
[.3832 .2444 -6 -9 ]
[.3832 .2444 6 0 ]
[.56289 .2444 -6 -9 ]
[.56289 .2444 6 0 ]
[.74259 .2444 -6 -9 ]
[.74259 .2444 6 0 ]
[.92228 .2444 -9 -9 ]
[.92228 .2444 9 0 ]
[.01131 .02431 -18 -4.5 ]
[.01131 .02431 0 4.5 ]
[.01131 .14061 -18 -4.5 ]
[.01131 .14061 0 4.5 ]
[.01131 .3732 -18 -4.5 ]
[.01131 .3732 0 4.5 ]
[.01131 .4895 -18 -4.5 ]
[.01131 .4895 0 4.5 ]
[.01131 .60579 -18 -4.5 ]
[.01131 .60579 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.2035 .2569 m
.2035 .26315 L
s
[(20)] .2035 .2444 0 1 Mshowa
.3832 .2569 m
.3832 .26315 L
s
[(40)] .3832 .2444 0 1 Mshowa
.56289 .2569 m
.56289 .26315 L
s
[(60)] .56289 .2444 0 1 Mshowa
.74259 .2569 m
.74259 .26315 L
s
[(80)] .74259 .2444 0 1 Mshowa
.92228 .2569 m
.92228 .26315 L
s
[(100)] .92228 .2444 0 1 Mshowa
.125 Mabswid
.06873 .2569 m
.06873 .26065 L
s
.11366 .2569 m
.11366 .26065 L
s
.15858 .2569 m
.15858 .26065 L
s
.24843 .2569 m
.24843 .26065 L
s
.29335 .2569 m
.29335 .26065 L
s
.33827 .2569 m
.33827 .26065 L
s
.42812 .2569 m
.42812 .26065 L
s
.47305 .2569 m
.47305 .26065 L
s
.51797 .2569 m
.51797 .26065 L
s
.60782 .2569 m
.60782 .26065 L
s
.65274 .2569 m
.65274 .26065 L
s
.69766 .2569 m
.69766 .26065 L
s
.78751 .2569 m
.78751 .26065 L
s
.83243 .2569 m
.83243 .26065 L
s
.87736 .2569 m
.87736 .26065 L
s
.96721 .2569 m
.96721 .26065 L
s
.25 Mabswid
0 .2569 m
1 .2569 L
s
.02381 .02431 m
.03006 .02431 L
s
[(1.6)] .01131 .02431 1 0 Mshowa
.02381 .14061 m
.03006 .14061 L
s
[(1.8)] .01131 .14061 1 0 Mshowa
.02381 .3732 m
.03006 .3732 L
s
[(2.2)] .01131 .3732 1 0 Mshowa
.02381 .4895 m
.03006 .4895 L
s
[(2.4)] .01131 .4895 1 0 Mshowa
.02381 .60579 m
.03006 .60579 L
s
[(2.6)] .01131 .60579 1 0 Mshowa
.125 Mabswid
.02381 .05339 m
.02756 .05339 L
s
.02381 .08246 m
.02756 .08246 L
s
.02381 .11153 m
.02756 .11153 L
s
.02381 .16968 m
.02756 .16968 L
s
.02381 .19876 m
.02756 .19876 L
s
.02381 .22783 m
.02756 .22783 L
s
.02381 .28598 m
.02756 .28598 L
s
.02381 .31505 m
.02756 .31505 L
s
.02381 .34413 m
.02756 .34413 L
s
.02381 .40227 m
.02756 .40227 L
s
.02381 .43135 m
.02756 .43135 L
s
.02381 .46042 m
.02756 .46042 L
s
.02381 .51857 m
.02756 .51857 L
s
.02381 .54765 m
.02756 .54765 L
s
.02381 .57672 m
.02756 .57672 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.008 w
.04178 .25766 Mdot
.05076 .4393 Mdot
.05975 .40405 Mdot
.06873 .3511 Mdot
.07772 .25797 Mdot
.0867 .25746 Mdot
.09569 .25686 Mdot
.10467 .32141 Mdot
.11366 .26731 Mdot
.12264 .30923 Mdot
.13163 .27168 Mdot
.14061 .30081 Mdot
.1496 .26046 Mdot
.15858 .29465 Mdot
.16757 .25908 Mdot
.17655 .3066 Mdot
.18553 .38444 Mdot
.19452 .29052 Mdot
.2035 .25923 Mdot
.21249 .33875 Mdot
.22147 .35946 Mdot
.23046 .38183 Mdot
.23944 .35372 Mdot
.24843 .37176 Mdot
.25741 .34294 Mdot
.2664 .36315 Mdot
.27538 .31277 Mdot
.28437 .36811 Mdot
.29335 .36118 Mdot
.30234 .40171 Mdot
.31132 .413 Mdot
.32031 .41411 Mdot
.32929 .44435 Mdot
.33827 .42145 Mdot
.34726 .4475 Mdot
.35624 .43713 Mdot
.36523 .43472 Mdot
.37421 .41951 Mdot
.3832 .42001 Mdot
.39218 .41158 Mdot
.40117 .42221 Mdot
.41015 .4327 Mdot
.41914 .42963 Mdot
.42812 .42367 Mdot
.43711 .43919 Mdot
.44609 .42848 Mdot
.45508 .4557 Mdot
.46406 .45651 Mdot
.47305 .47426 Mdot
.48203 .48209 Mdot
.49102 .52081 Mdot
.5 .48625 Mdot
.50898 .5077 Mdot
.51797 .49907 Mdot
.52695 .51992 Mdot
.53594 .51098 Mdot
.54492 .49872 Mdot
.55391 .48267 Mdot
.56289 .49182 Mdot
.57188 .47615 Mdot
.58086 .50413 Mdot
.58985 .49651 Mdot
.59883 .52266 Mdot
.60782 .51567 Mdot
.6168 .52562 Mdot
.62579 .52534 Mdot
.63477 .52421 Mdot
.64376 .5176 Mdot
.65274 .53136 Mdot
.66173 .5269 Mdot
.67071 .53545 Mdot
.67969 .53528 Mdot
.68868 .53861 Mdot
.69766 .53762 Mdot
.70665 .54918 Mdot
.71563 .54553 Mdot
.72462 .54824 Mdot
.7336 .54372 Mdot
.74259 .55193 Mdot
.75157 .56116 Mdot
.76056 .56325 Mdot
.76954 .55802 Mdot
.77853 .54072 Mdot
.78751 .53054 Mdot
.7965 .59498 Mdot
.80548 .58441 Mdot
.81447 .58746 Mdot
.82345 .57723 Mdot
.83243 .59312 Mdot
.84142 .57024 Mdot
.8504 .59839 Mdot
.85939 .57608 Mdot
.86837 .60332 Mdot
.87736 .58131 Mdot
.88634 .59004 Mdot
.89533 .57462 Mdot
.90431 .58325 Mdot
.9133 .58582 Mdot
.92228 .58835 Mdot
.93127 .57931 Mdot
.94025 .57045 Mdot
.94924 .56176 Mdot
.95822 .55324 Mdot
.96721 .54488 Mdot
.97619 .53667 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{299.062, 184.75},
  ImageMargins->{{48, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004[0000^0P10`4000010?ooooooc?ooZ_ooI_oo
<ooo0?o<ooo<c?o<VC/k>gYjN[Vi^OShn03ooeGooj[ooonI<onI0?mVoomVc?mVVOmVI_mV<omV0?lc
oclo?ginO[fm_Oclo5D00:X00?l00?l0VOl0I_l0<ol00<coolcoc<coVLcoIP<30d92@X61PL30`000
EED0EJX0EOl0ELbIolbIc<bIVLbII/bI<lbI0<aVolaVc0L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0Z/`c
<l`c0<`0ol`0c<`0VL`0I/`0<l`000/;2dY:BXV9RLS8b000oeD0ojX0ool0oiW<VIW<IYW<<iW<09VI
oiVIc9VIVIVIIPl?3di>CXf=SLc<c01E05EE0:YE0?mE09TcoiTcc9TcVITcIYTc<iTc09T0oiT0c1<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEEFKo<fKo06K<ofK<c6K<VFK<IVK<<fK<01LG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZVIVVFIVIVIV<fIV06HcofHcc6HcVFHcIQ/K6eYJFYVIVMSHf01EoeEEojYEoomEoc?o
oc?oc3?oVC?oIS?o<c?o03?<oc?<c1lO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ03>I<c>I03=Voc=Vc3=V
VC=VIS=V<c=V02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZEC<0VC<0IS<0<c<0003oo`3oc03oV@3oIRLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2Io`2Ic02IV@2IIP2I<`2I001Vo`1Vc2/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`0c<`0c0000o`00c000V@00IP00<nh002l_;fi^KZf][Nc/k03o05Go0:[o0?oo0140
003^003M002k002Z0028001g001E03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@00M`00E@00A0008P00
4Nk^k]gMgK^k^cLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l0;0000?l0;0000?l0;0000?l0;00001D0
00?o0000o`0D00005@000ol0003o01@0000E0003o`000?l0500001D000?o0000o`0D000000@0oooo
1002o`@00_l50003o`000?l05000008000?o00000`02o`<000Co003o10000ol0003o01@000020003
o`0000P000Co003o1003ool05000008000?o00002003o`D000?o0000o`0D00000P000ol000080003
o`0000D000?o0000o`0D000000<0ool02`03o`@000?o0000o`0D00005@000ol0003o01@0000E0003
o`000?l0500001D000?o0000o`0D00005@000ol0003o01@0000E0003o`000?l0500001D00_oo01D0
000E0003o`000?l0500001D000?o0000o`0D00005@000ol0003o01@0000E0003o`000?l0500001D0
00?o0000o`0D00005@000ol0003o01@0000E0003o`000?l0500001D00_oo01D0000E0003o`000?l0
500001D000?o0000o`0D00005@000ol0003o01@0000E0003o`000?l0500001D000?o0000o`0D0000
5@000ol0003o01@0000E0003o`000?l0500001D00_oo01D0000E0003o`000?l0500001D000?o0000
o`0D00005@000ol0003o01@0000E0003o`000?l0500001D000?o0000o`0D000000@0oooo1002o`@0
0_l50003o`000?l05000008000?o00000`02o`<000Co003o10000ol0003o01@000020003o`0000P0
00Co003o1003ool05000008000?o00002@02o`D000?o0000o`0D00000P000ol000080004o`00o`@0
00?o0000o`0D000000<0ool02`02o`D000?o0000o`0D00005@000ol0003o01@0000E0003o`000?l0
500001D000?o0000o`0D00005@000ol0003o01@0000E0003o`000?l0500001D00_oo01D0000E0003
o`000?l0500001D000?o0000o`0D00005@000ol0003o01@0000E0003o`000?l0500001D000?o0000
o`0D00005@000ol0003o01@0000E0003o`000?l0500001D00_oo01D0000E0003o`000?l0500001D0
00?o0000o`0D00005@000ol0003o01@0000E0003o`000?l0500001D000?o0000o`0D00005@000ol0
000[00Co0`02ob/00ol300;o:`02o`@00_l[00;o1002obL00ol400;o1002oa00000E0003o`0002`0
00?o00000P001?l00?l[0005o`000?l00P000ol0000W0004o`00o`8000Co003o:@001?l00?l20004
o`00obL000?o00000P001?l00?l20004o`00o`l0000E00;o;P001Ol0003o008000?o00009`04o`80
00Co003o:@001?l00?l20004o`00obT000Co003o0P001?l00?lW0003o`00008000Co003o0P001?l0
0?l?00005@000ol0000^0004o`00o`8000?o00009`000ol0o`030004o`00obT00ol30004o`00obX0
0_l30004o`00obL000?o00000P001?l00?l20004o`00o`l0000E0003o`0002/000Co003o0P001?l0
0?lY0003o`3o00<000Co003o:@000ol000030004o`00obT000Co003o0P001?l00?lW0003o`000080
00Co003o0P001?l00?l?00005@000ol0000/00;o1002ob/00_l400;o:`03o`<00_l[00;o1002obL0
0_l500;o1002oa00000E0003o`000?l0500001D000?o0000o`0D00005@000ol0003o01@0000E0003
o`000?l0500000h0oolNo`005@000ol0000200;o1P000ol0o`03o`030?oo00<000?o00001`02o`03
0?l000;o2002o``000?o00002@000ol0000:0003o`0000X000?o00002P000ol000090003o`0000X0
00?o00002P000ol000090003o`0000X000?o00002P000ol0000:0003o`0000T000?o00002P000ol0
000:0003o`0000X000?o00002@000ol0000800005@000ol0000P00;o0`02o`P00_lb0003o`000300
00?o0000<0000ol0000`0003o`0001@0000E0003o`0001H00_ok00005@000ol0000F00;o0`02ooH0
000E0003o`0001/00_of00005@000ol0003o01@0000E0003o`000?l0500001D000?o0000o`0D0000
5@02obh00_oT00005@000ol0000]00;oi00001D000?o00008`02onh0000E0003o`0001h00_l300;o
kP0001D000?o00007P02oo<0000E0003o`0002P00_oY00005@000ol0000H00;o3P02onT0000E0003
o`0001P00_lZ00;oc@0001D00_m500;oc@0001D000?o00004`02ooh0000E0003o`0001<00_on0000
5@000ol0003o01@0000E0003o`000?l0500001D000?o0000o`0D00005@000ol0000b00;og`0001D0
00?o0000<P02o`/00_oB00005@02od000_oB00005@000ol0003o01@0000E0003o`0000T00_l^00;o
f00001D000?o00002@02obh00_oH00005@000ol0000d00;og@0001D000?o0000=002o`/00_l600;o
b00000030?oo00;o0`02o`<01?l40003o`0004400_l300;o00<0ool0b000008000?o00000`02o`@0
00?o000010000ol0001600;ob`0000<000?o00002@000ol0000300?o?002omD000040003o`0000T0
00?o00000P000ol0000l00;oe@0000050?l00?l020001?l00?l40003o`0003L00_oJ00000P02o`X0
0_l50003o`0002X00_l;00;ofP0001D000?o0000:P02onL0000E0003o`000?l0500001D000?o0000
o`0D00005@000ol0003o01@0000E0003o`0004/00_o600005@02o`P00_m200;oaP0001D000?o0000
1`02ool02`0001D000?o0000CP02oaD00_n/00005@000ol0001>00Co4`02oj`0000E0003o`000500
0_l>00Co[`0001D000?o0000E@02o`T01?l300;o1P02oj80000E0003o`0005D00_l@00;o1P02oj80
000E0003o`0006`00_l600;oW@0001D00_mN00;o2`04o`H00_nM00005@000ol0001K00Co2`02ojL0
000E0003o`0000@00_mE00;o5002oj00000E0003o`0000@00_m=00;o7002oj00000E0003o`0005<0
0_l300;o^@0001D000?o0000F002okT0000E0003o`0007L00_nJ00005@000ol0001g00CoV00001D0
0_mj00;oV00001D000?o0000o`0D00005@000ol0003o01@0000E0003o`000?l0500001D000?o0000
O002oaX00_mi00005@000ol0001l00;o6P02ogT000000`3oo`02o`<00_l400?o10000ol0001n00;o
4`02ogh000020003o`0000<00_l50003o`0000<000?o0000OP02o`<00_l>00;oOP0000<000?o0000
1`04o`@00on300;oSP0000@000?o00001P000ol0o`050003o`0009D00_ml000000D0o`00o`080003
o`3o00D000?o0000T002o`<00_l600;oM00000800_l:00;o1@000ol0002800;o1P02o`/00_md0000
5@000ol0002800;o4002ogL0000E0003o`0008H00_lB00;oM`0001D000?o0000QP02o`D00_n40000
5@000ol0002=00;o4`02ofl0000E00;oS002oaD00_l800;oI@0001D000?o0000P@02o`P00_lB00;o
2`02ofD0000E0003o`0008400_lL00;o0`02o`030?oo00;o1P02of00000E0003o`000:@00_l00`3o
o`02o`H00_lR00;o?00001D000?o0000[`02ob@00_ll00005@000ol0002_00;o0`04o`<00_m=00;o
1`0001D000?o0000]004o`030?oo00;o5@02ocH00_l700005@000ol0002i00;o2P02o`/00_lo0000
5@000ol0003000;o00<0ool00_m100;o2@0001D00_no00Co00<0ool0@`02o`T0000E0003o`000;h0
0_l800;o>`02o``0000E0003o`000<P00_l600;o<`02o``0000E0003o`000</00_l300;o<@02o`h0
000E0003o`000</01?ld00;o3P0001D000?o0000c@02od@0000E0003o`000>@00_lJ00;o4@0001D0
00?o0000i002o`<00_l800;o2`02oa40000E00;oh002o`P00_l800;o2002oa@0000E0003o`000=l0
0_l=00;o1P02o`D00_lD00005@000ol0003J00;o4P02o`H01?lI00005@000ol0003J00Co4`02o`D0
0_l00`3oo`0F00005@000ol0003L00;o0`02o`h00_l800;o5P0001D000?o0000e`02o`P00_l`0000
00<0ool00_l300;o1002o`D000?o0000e`02o`h00_lZ00000P000ol0000300;o0`001?l00?l40003
o`000>L00_l300;o9@0000<000?o00001`001?l00?l400?ok002obD000040003o`0000H00ol50003
o`000?l0500000050?l00?l020000ol000050003o`000?l0500000800_l:00?o10000ol0003o01@0
000E0003o`000?l050000?l0;0000?l0;0000?l0;0000?l0;0000001\
\>"],
  ImageRangeCache->{{{0, 298.062}, {183.75, 0}} -> {-8.46431, 1.53496, 
  0.39292, 0.00607119}}]
}, Closed]],

Cell[TextData[{
  "However, the melting point of an element is returned with the unit ",
  StyleBox["Kelvin", "Input"],
  ", making the data unusable directly with ",
  StyleBox["ListPlot", "Input"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(MeltingPoint[Hydrogen]\)], "Input"],

Cell[BoxData[
    RowBox[{
      StyleBox["14.0099999999999997`",
        StyleBoxAutoDelete->True,
        PrintPrecision->4], " ", "Kelvin"}]], "Output"]
}, Closed]],

Cell[TextData[{
  "To remove the units from each measurement, we use algebraic division to \
divide out the unit symbols. (Some warning messages have been deleted.) ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " warns that the melting point of some elements is unknown."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(elementdata = MeltingPoint[Elements]/Kelvin; \)\)], "Input"],

Cell[BoxData[
    \(MeltingPoint::"unknown" \( : \ \) 
      "The melting point of \!\(Berkelium\) is not known."\)], "Message"],

Cell[BoxData[
    \(MeltingPoint::"unknown" \( : \ \) 
      "The melting point of \!\(Californium\) is not known."\)], "Message"],

Cell[BoxData[
    \(General::"stop" \( : \ \) 
      "Further output of \!\(MeltingPoint :: \"unknown\"\) will be suppressed \
during this calculation."\)], "Message"]
}, Closed]],

Cell[TextData[{
  "In the unknown cases, ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " returns the symbol ",
  StyleBox["Unknown", "Input"],
  ", instead of a numeric value."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Last[elementdata]\)], "Input"],

Cell[BoxData[
    \(Unknown\/Kelvin\)], "Output"]
}, Closed]],

Cell[TextData[{
  "When we use ",
  StyleBox["ListPlot", "Input"],
  " to graph a list of points that contain the symbol ",
  StyleBox["Unknown", "Input"],
  ", ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " prints a warning message that we are trying to plot nonnumeric data, and \
generates a graph of the remaining points."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(ListPlot[elementdata, PlotJoined -> True]; \)\)], "Input"],

Cell[BoxData[
    \(Graphics::"gptn" \( : \ \) 
      "Coordinate \!\(Unknown\/Kelvin\) in \!\({97, Unknown\/Kelvin}\) is not \
a floating-point number."\)], "Message"],

Cell[BoxData[
    \(Graphics::"gptn" \( : \ \) 
      "Coordinate \!\(Unknown\/Kelvin\) in \!\({98, Unknown\/Kelvin}\) is not \
a floating-point number."\)], "Message"],

Cell[BoxData[
    \(General::"stop" \( : \ \) 
      "Further output of \!\(Graphics :: \"gptn\"\) will be suppressed during \
this calculation."\)], "Message"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.00898473 0.0147151 0.000154085 [
[.2035 .00222 -6 -9 ]
[.2035 .00222 6 0 ]
[.3832 .00222 -6 -9 ]
[.3832 .00222 6 0 ]
[.56289 .00222 -6 -9 ]
[.56289 .00222 6 0 ]
[.74259 .00222 -6 -9 ]
[.74259 .00222 6 0 ]
[.92228 .00222 -9 -9 ]
[.92228 .00222 9 0 ]
[.01131 .1688 -24 -4.5 ]
[.01131 .1688 0 4.5 ]
[.01131 .32288 -24 -4.5 ]
[.01131 .32288 0 4.5 ]
[.01131 .47697 -24 -4.5 ]
[.01131 .47697 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.2035 .01472 m
.2035 .02097 L
s
[(20)] .2035 .00222 0 1 Mshowa
.3832 .01472 m
.3832 .02097 L
s
[(40)] .3832 .00222 0 1 Mshowa
.56289 .01472 m
.56289 .02097 L
s
[(60)] .56289 .00222 0 1 Mshowa
.74259 .01472 m
.74259 .02097 L
s
[(80)] .74259 .00222 0 1 Mshowa
.92228 .01472 m
.92228 .02097 L
s
[(100)] .92228 .00222 0 1 Mshowa
.125 Mabswid
.06873 .01472 m
.06873 .01847 L
s
.11366 .01472 m
.11366 .01847 L
s
.15858 .01472 m
.15858 .01847 L
s
.24843 .01472 m
.24843 .01847 L
s
.29335 .01472 m
.29335 .01847 L
s
.33827 .01472 m
.33827 .01847 L
s
.42812 .01472 m
.42812 .01847 L
s
.47305 .01472 m
.47305 .01847 L
s
.51797 .01472 m
.51797 .01847 L
s
.60782 .01472 m
.60782 .01847 L
s
.65274 .01472 m
.65274 .01847 L
s
.69766 .01472 m
.69766 .01847 L
s
.78751 .01472 m
.78751 .01847 L
s
.83243 .01472 m
.83243 .01847 L
s
.87736 .01472 m
.87736 .01847 L
s
.96721 .01472 m
.96721 .01847 L
s
.25 Mabswid
0 .01472 m
1 .01472 L
s
.02381 .1688 m
.03006 .1688 L
s
[(1000)] .01131 .1688 1 0 Mshowa
.02381 .32288 m
.03006 .32288 L
s
[(2000)] .01131 .32288 1 0 Mshowa
.02381 .47697 m
.03006 .47697 L
s
[(3000)] .01131 .47697 1 0 Mshowa
.125 Mabswid
.02381 .04553 m
.02756 .04553 L
s
.02381 .07635 m
.02756 .07635 L
s
.02381 .10717 m
.02756 .10717 L
s
.02381 .13798 m
.02756 .13798 L
s
.02381 .19962 m
.02756 .19962 L
s
.02381 .23043 m
.02756 .23043 L
s
.02381 .26125 m
.02756 .26125 L
s
.02381 .29207 m
.02756 .29207 L
s
.02381 .3537 m
.02756 .3537 L
s
.02381 .38452 m
.02756 .38452 L
s
.02381 .41534 m
.02756 .41534 L
s
.02381 .44615 m
.02756 .44615 L
s
.02381 .50779 m
.02756 .50779 L
s
.02381 .5386 m
.02756 .5386 L
s
.02381 .56942 m
.02756 .56942 L
s
.02381 .60024 m
.02756 .60024 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.03279 .01687 m
.04178 .01486 L
.05076 .08462 L
.05975 .2537 L
.06873 .41118 L
.07772 .60332 L
.0867 .02447 L
.09569 .02316 L
.10467 .02296 L
.11366 .01849 L
.12264 .07187 L
.13163 .15678 L
.14061 .15855 L
.1496 .27404 L
.15858 .06361 L
.16757 .07419 L
.17655 .04125 L
.18553 .02763 L
.19452 .06661 L
.2035 .18606 L
.21249 .29422 L
.22147 .31256 L
.23046 .34754 L
.23944 .34292 L
.24843 .24846 L
.25741 .2933 L
.2664 .28714 L
.27538 .28067 L
.28437 .22375 L
.29335 .12145 L
.30234 .06139 L
.31132 .20125 L
.32031 .02762 L
.32929 .09022 L
.33827 .05569 L
.34726 .03268 L
.35624 .06282 L
.36523 .17527 L
.37421 .2913 L
.3832 .34215 L
.39218 .43706 L
.40117 .46002 L
.41015 .39145 L
.41914 .41272 L
.42812 .35971 L
.43711 .29592 L
.44609 .20502 L
.45508 .10626 L
.46406 .08087 L
.47305 .09255 L
Mistroke
.48203 .15399 L
.49102 .12607 L
.5 .0743 L
.50898 .03957 L
.51797 .06118 L
.52695 .16911 L
.53594 .19869 L
.54492 .17989 L
.55391 .20023 L
.56289 .2141 L
.57188 .23675 L
.58086 .22273 L
.58985 .18344 L
.59883 .25909 L
.60782 .26572 L
.6168 .27435 L
.62579 .2839 L
.63477 .29238 L
.64376 .29484 L
.65274 .18375 L
.66173 .31302 L
.67071 .40039 L
.67969 .51842 L
.68868 .58175 L
.69766 .54677 L
.70665 .52736 L
.71563 .42812 L
.72462 .32982 L
.7336 .22082 L
.74259 .05081 L
.75157 .10356 L
.76056 .10727 L
.76954 .09861 L
.77853 .09592 L
.78751 .10331 L
.7965 .04584 L
.80548 .06094 L
.81447 .16464 L
.82345 .21811 L
.83243 .32643 L
.84142 .3403 L
.8504 .23128 L
.85939 .15539 L
.86837 .15555 L
.87736 .20994 L
.88634 .26279 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{299.062, 184.75},
  ImageMargins->{{48, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004[0000^0P10`4000010?ooooooc?ooZ_ooI_oo
<ooo0?o<ooo<c?o<VC/k>gYjN[Vi^OShn03ooeGooj[ooonI<onI0?mVoomVc?mVVOmVI_mV<omV0?lc
oclo?ginO[fm_Oclo5D00:X00?l00?l0VOl0I_l0<ol00<coolcoc<coVLcoIP<30d92@X61PL30`000
EED0EJX0EOl0ELbIolbIc<bIVLbII/bI<lbI0<aVolaVc0L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0Z/`c
<l`c0<`0ol`0c<`0VL`0I/`0<l`000/;2dY:BXV9RLS8b000oeD0ojX0ool0oiW<VIW<IYW<<iW<09VI
oiVIc9VIVIVIIPl?3di>CXf=SLc<c01E05EE0:YE0?mE09TcoiTcc9TcVITcIYTc<iTc09T0oiT0c1<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEEFKo<fKo06K<ofK<c6K<VFK<IVK<<fK<01LG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZVIVVFIVIVIV<fIV06HcofHcc6HcVFHcIQ/K6eYJFYVIVMSHf01EoeEEojYEoomEoc?o
oc?oc3?oVC?oIS?o<c?o03?<oc?<c1lO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ03>I<c>I03=Voc=Vc3=V
VC=VIS=V<c=V02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZEC<0VC<0IS<0<c<0003oo`3oc03oV@3oIRLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2Io`2Ic02IV@2IIP2I<`2I001Vo`1Vc2/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`0c<`0c0000o`00c000V@00IP00<nh002l_;fi^KZf][Nc/k03o05Go0:[o0?oo0140
003^003M002k002Z0028001g001E03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@00M`00E@00A0008P00
4Nk^k]gMgK^k^cLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l0;0000?l0;0000?l0;0000?l0;00004P0
1?l300;o:P03o`<00_lY00;o1002obX00_l400;o9P03o`@00_l400;o400004T000?o00000P001?l0
0?lZ0005o`000?l00P000ol0000U0004o`00o`8000Co003o:0001?l00?l20004o`00obH000?o0000
0P001?l00?l20004o`00o`l0001:0005o`000?l00P000ol0000V00Co0P001?l00?lW0004o`00o`80
00Co003o:0001?l00?l20004o`00obH000?o00000P001?l00?l20004o`00o`l0001;0004o`00o`80
00?o00009P000ol0o`030004o`00obL00ol30004o`00obT00_l30004o`00obH000?o00000P001?l0
0?l20004o`00o`l000180004o`00o`8000Co003o:0000ol0o`030004o`00obL000?o00000`001?l0
0?lX0004o`00o`8000Co003o9P000ol000020004o`00o`8000Co003o3`0004T00_l400;o:P02o`@0
0_lY00?o0`02obX00_l400;o9P02o`D00_l400;o400001/000?o0000o`0>00006`000ol0003o00h0
000K0003o`000?l03P0001/000?o0000o`0>0000503ooaSo000K0006o`3oo`3o1P000ol0000900;o
2`000ol0000:0003o`0000T000?o00002P000ol000090003o`0000X000?o00002@000ol000090003
o`0000X000?o00002@000ol0000:0003o`0000T000?o00002P000ol000090003o`0000X000?o0000
2@000ol0000:0003o`0000T000?o00002@000ol0000800006`000ol000020003o`0000l000?o0?l0
60000ol0000_0003o`0002h000?o0000;`000ol0000_0003o`0001@0000K0003o`00008000?o0000
2@06o`8000?o0000m00001/000?o00000P000ol000090003o`0000D000?o00004@000ol0000R0003
o`000;/0000K0003o`00008000?o00002@000ol000050003o`00014000?o00008P000ol000050003
o`000;<0000K0003o`0000<000?o000020000ol000060003o`0000l00_lT0003o`0000D000?o0000
/`0001/000?o00000`000ol000080003o`0000H000?o00003P000ol0o`0T0003o`0000@00_l[0003
o`0008L0000K0003o`0000<000?o000020000ol000060003o`0000d000Go0000o`0S00;o1@000ol0
o`0Z0003o`0008L0000K00;o10000ol000080003o`0000H000?o00003@001Ol0003o02<00_l40004
o`00obX00_m>0003o`0003L0000K0003o`0000<000?o000020000ol000060003o`0000d000Go0000
o`0S00;o10001?l00?lY0003o`3o03l000?o000030000ol0000g00006`000ol000030003o`0000P0
00?o00001P000ol0000<0003o`00008000?o00008@02o`@000Co003o:@001?l00?ln0003o`0000`0
0_lh00006`000ol000030003o`0000P000?o00001P000ol0000<0003o`00008000?o00008@02o`<0
00Go0000o`0Y0004o`00och000?o000030000ol0o`0g00006`000ol000030003o`0000P000?o0000
1`000ol0000;0003o`0000<000?o00006`000ol000020003o`3o008000?o00000P000ol0000V0005
o`000?l0?@02o`d000Co003o=P0001/000?o00000`000ol000080003o`0000L000?o00001`001Ol0
003o00D000?o00006`000ol000020003o`3o008000?o00000P000ol0000V0005o`000?l0?@02o``0
00Go0000o`0f00006`000ol000030003o`0000P000?o00001`000ol0000700;o0P000ol000030003
o`0001/000?o00000P001Ol0o`3o00D000?o00009@000ol000020003o`0003/00_l<0005o`000?l0
=P0001/000?o000010000ol000070003o`0000L000?o00001`001?l0ool60003o`0001/000?o0000
0P001Ol0o`3o00D000?o00009@000ol000020003o`0003/00_l<0005o`000?l0=P0001/00_l50003
o`0000L000?o00001`000ol000070004o`00o`H000?o00006`001Ol0003o008000?o0?l01@000ol0
000U0003o`00008000?o0000>`02o``000Go0000o`0f00006`000ol000040003o`0000L000?o0000
1`000ol000070003o`0000L000?o00006P02o`<000Ko003o0?l50003o`0002D000?o00000P000ol0
000k0003o`3o00/000Go0000o`0f00006`000ol000040003o`0000L000?o00001`000ol000070003
o`0000L000?o00006P02o`<000Co00000_l50003o`0001/000?o00001`000ol000020003o`0003/0
00?o0?l02`001Ol0003o03H0000K0003o`0000@000?o00001`000ol000070003o`0000L000?o0000
1`000ol0000J0003o`3o008000Go0000o`070003o`0001X000?o00001P000ol000030003o`0003/0
00?o0?l02`001Ol0003o03H0000K0003o`0000@000?o00001`000ol000080003o`0000H000?o0000
20000ol0000I0003o`3o008000Go0000o`070003o`0001X00_l70003o`0000@000?o0000>P000ol0
o`0;0003o`00008000?o0000<`0001/000?o000010000ol000070003o`0000P000?o00001P000ol0
00080003o`0001T000?o0?l00P000ol000090003o`0001T000Co003o1P000ol000040003o`0003X0
00?o0?l02P000ol000030003o`0003<0000K0003o`0000@000?o00001`000ol000080003o`0000H0
00?o000020000ol0000I0003o`3o008000?o00002@000ol0000I0004o`00o`H000?o000010000ol0
000i0005o`000?l01004o`030?l000@000?o0000<`0001/000?o000010000ol000070003o`0000P0
00?o00001P000ol000080003o`0001T000?o0?l00P000ol000090003o`0001T000Co003o1P000ol0
00040003o`0003T000Go0000o`030003o`0000800_l50003o`0003<0000K0003o`0000@000?o0000
1`000ol000080003o`0000H000?o000020000ol0000I0003o`3o008000?o00002@000ol0000H0005
o`000?l01@000ol000050003o`0003T000Co00000_l00`3o00050003o`0000<000?o0000<`0001/0
0_l50003o`0000L000?o000020000ol000060003o`0000P000?o00006@000ol0o`020003o`0000T0
00?o000060000ol000020003o`00008000?o00001@000ol0000i0003o`0000<000?o00002`000ol0
000c00006`000ol000040003o`0000L000?o000020000ol000060003o`0000P000?o000060001?l0
0?l20003o`0000T000?o000060000ol000020003o`00008000?o00001@000ol0000i0003o`000140
00?o0000<`0001/000?o000010000ol000070003o`0000P000?o00001P000ol000080003o`0001P0
00Co003o0P000ol000090003o`0001P000?o00000P000ol000020003o`0000D000?o0000>@000ol0
000A0003o`0003<0000K0003o`0000D000?o00001P000ol000090003o`0000@000?o00002@000ol0
000H0004o`00o`8000?o00002@000ol0000H0003o`00008000?o00000P000ol000050003o`0003T0
00?o00004@000ol0000c00006`000ol000050003o`0000H000?o00002@000ol000040003o`0000T0
00?o000060001?l00?l20003o`0000X000?o00005`000ol000020005o`000?l020000ol0000i0003
o`00014000?o0000<`0001/000?o00001@000ol000060003o`0000T000?o000010000ol000090003
o`0001P000Co003o0P000ol0000:0003o`0001H000?o000010001?l00?l80003o`0003T000?o0000
4@000ol0000c00006`000ol000050003o`0000H000?o00002@000ol000040003o`0000X000?o0000
5`001?l00?l20003o`0000X000?o00005P000ol000040004o`00o`P000?o0000>@000ol0000A0003
o`0003<0000K0003o`0000D000?o00001P000ol000090003o`0000@000?o00002P000ol0000G0007
o`000?l0o`0<0003o`0001H000?o000010001?l00?l80003o`0003T000?o00004@000ol0000c0000
6`02o`H000?o00001P000ol000090003o`0000@000?o00002P000ol0000G0007o`000?l0o`0<0003
o`0001H000?o000010000ol0o`090003o`0003T000?o00004@000ol0000c00006`000ol000050003
o`0000H000?o00002@000ol000040003o`0000X000?o00005`001ol0003o0?l030000ol0000F0003
o`0000@000?o0?l02@000ol0000i0003o`00014000?o0000<`0001/000?o00001@000ol000060003
o`0000T000?o000010000ol0000:0003o`0001H000?o00000P000ol0o`0<0003o`0001H000?o0000
10000ol0o`0:0003o`0003P000?o00004P000ol0000b00006`000ol000050003o`0000H000?o0000
2P000ol000030003o`0000X000?o00005P000ol000020003o`3o00`000?o00005P000ol0000500;o
2P000ol0000h0003o`00018000?o0000<P0001/000?o00001@000ol000060003o`0000X000?o0000
0`000ol0000:0003o`0001H000?o00000P000ol0o`0<0003o`0001H000?o00001@000ol000090003
o`0003P000?o00004P000ol0000b00006`000ol000050003o`0000H000?o00002P000ol000030003
o`0000X000?o00005P000ol000020003o`3o00`000?o00005P000ol000050003o`0000T000?o0000
>0000ol0000B0003o`0000X00olU00006`000ol000050003o`0000H000?o00002P03o`<000?o0000
2P000ol0000F0003o`00008000?o0?l030000ol0000E0003o`00018000?o0000>0000ol0000B0003
o`0000X000?o0?l09@0000040?ooo`@00_l400;o1002o`D000?o00001@000ol000060003o`0000`0
00Go0000o`0<0003o`0001H000?o00000P02o`h000?o000050000ol0000B0003o`0003P000?o0000
4P000ol0000:0003o`3o02D000020003o`00008000Co003o0P001?l00?l20004o`00o`@000?o0000
1@000ol000060003o`0000`000Go0000o`0<0003o`0001H000?o00000P02o`h000?o000050000ol0
000B0003o`0003P000?o00004P000ol0000:0004o`00ob@000020003o`00008000Co003o0P001?l0
0?l20004o`00o`@00ol50003o`0000H000?o000030001Ol0003o00d000?o00005@000ol0000200;o
3P000ol0000D0003o`00018000?o0000>0000ol0000B0003o`0000T000Go0000o`0T00000P000ol0
00020004o`00o`8000Co003o0P001?l00?l40003o`0000H000?o000010000ol0000=0005o`000?l0
3@000ol0000E0003o`0000800_l>0003o`0001@000?o00004P000ol0000h0003o`00018000?o0000
2@001Ol0003o02@000020003o`00008000Co003o0P001?l00?l20004o`00o`@000?o00001P000ol0
00040003o`0000d000Go0000o`0=0003o`0001@000?o00000`02o`h000?o000050000ol0000C0003
o`0003L000?o00004`000ol000080005o`000?l0900000030?oo00D00_l400;o1002o`D000?o0000
1P000ol000040003o`0000h000Co003o3@000ol0000D0003o`0000@000?o000030000ol0000D0003
o`0001<000Go0000o`0d0003o`0001@000?o000020001Ol0003o02@0000K0003o`0000H000?o0000
10000ol0000>0004o`00o`d000?o000050000ol000040003o`0000`000?o000050000ol0000C0005
o`000?l030000ol0000>0003o`0001@000?o000050000ol000080003o`00008000?o00008@0001/0
00?o00001P000ol000040003o`0000h000Co003o3@000ol0000D0003o`0000@000?o000030000ol0
000D0003o`0001@000Go0?l0o`0;0003o`0000h000?o000050000ol0000D0003o`0000P000?o0000
0P000ol0000Q00006`000ol000060003o`0000@000?o00003P001?l00?l=0003o`0001@000?o0000
10000ol0000<0003o`0001<000?o00005@001Ol0o`3o00/000?o00003P000ol0000D0003o`0001@0
00?o000020000ol000020003o`000240000K0003o`0000H000?o000010000ol0000>0004o`00o`d0
00?o000050000ol000040003o`0000`000?o00004`000ol0000E0003o`3o008000?o00001`02oa00
00?o000050000ol0000E0003o`0000H000?o00000`000ol0000Q00006`02o`L000?o000010000ol0
000>0004o`00o`d000?o000050000ol000040003o`0000`000?o00004`000ol0000F0005o`000?l0
2@02oa0000?o000050000ol0000E0003o`0000H000?o00000`000ol0000Q00006`000ol000060003
o`0000@000?o00003P001?l00?l=0003o`0001@000?o000010000ol0000<0003o`0001<000?o0000
6`000ol0000600;o40000ol0000D0003o`0001D000?o00001P000ol000040003o`000200000K0003
o`0000H000?o000010000ol0000>0004o`00o`d000?o000050000ol0000C0003o`0001<000?o0000
6`000ol000050004o`00o`l000?o000050000ol0000E0003o`0000H000?o000010000ol0000P0000
6`000ol000060003o`0000@000?o00003P001?l00?l=0003o`0001<000?o00005@000ol0000B0003
o`0001`000?o000010001?l00?l?00;o5@000ol0000E0003o`0000H000?o000010000ol0000P0000
6`000ol000060003o`0000@000?o00003P001?l00?l=0003o`0001<000?o00005@000ol0000B0003
o`0001`000?o000010001?l00?l?00;o5@000ol0000F0003o`0000D000?o000010000ol0000P0000
6`000ol000060003o`0000@000?o00003P001?l00?l>0003o`00018000?o00005@000ol0000B0003
o`0001d000?o00000`001?l00?l>0003o`3o01D000?o00005P000ol000050003o`0000@000?o0000
800001/000?o00001P000ol000040003o`0000l000?o0?l03P000ol0000B0003o`0001D000?o0000
4P000ol0000M0003o`00008000Go0000o`0>0003o`3o01D000?o00005P000ol000040003o`0000D0
00?o0000800001/000?o00001P000ol000040003o`0000l00_l?0003o`00018000?o00005@000ol0
000B0003o`0001h000Go0000o`030003o`0000`000?o0?l05@000ol0000F0003o`0000@000?o0000
1@000ol0000P00006`000ol000070003o`0000<000?o00003`02o`l000?o00004P000ol0000E0003
o`00018000?o00007P001Ol0003o00<000?o000030000ol0o`0E0003o`0001H000?o000010000ol0
00060003o`0001l0000K00;o20000ol000030003o`0000l00_l?0003o`00018000?o00005@000ol0
000A0003o`00020000?o0?l010000ol0000<0003o`3o01D000?o00005P000ol000040003o`0000H0
00?o00007`0001/000?o00001`000ol000030003o`0000l00_l?0003o`00018000?o00005@000ol0
000A0003o`00020000?o0?l010000ol0000<0003o`3o01D000?o00005P000ol000040003o`0000H0
00?o00007`0001/000?o00001`000ol000030003o`0000l00_l?0003o`00018000?o00005@000ol0
000A0003o`00024000?o00000`000ol0000<0003o`3o01D000?o00005P000ol000040003o`0000H0
00?o00007`0001/000?o00001`000ol000030003o`0000l00_l?0003o`00014000?o00005P000ol0
000A0003o`0002L000?o000030000ol0o`0D0003o`0001L000?o000010000ol000060003o`0001l0
000K0003o`0000L000?o00000`000ol0000?00;o3`000ol0000A0003o`0001H000?o00004@000ol0
000X0003o`0000/000?o0?l050000ol0000G0003o`0000@000?o00001P000ol0000O00006`000ol0
00070003o`0000<000?o00003`02o`l000?o000020000ol000060003o`0001H000?o00004@000ol0
000X0003o`0000/000?o0?l050000ol0000H0003o`0000<000?o00001P000ol0000O00006`000ol0
00070003o`0000<000?o00003`02o`l000?o000020000ol000060003o`0001H000?o00004@000ol0
000X0003o`0000/000Co003o4`000ol0000H0003o`0000<000?o00001`000ol0000N00006`000ol0
00070003o`0000<000?o00003`02o`l000?o000020000ol000060003o`0001H000?o00004@000ol0
000X0003o`0000/000Co003o4`000ol0000H0003o`0000<000?o00001`000ol0000N00006`000ol0
00070003o`0000<000?o000040000ol0000=0003o`0000P00_l70003o`0001H000?o00004@000ol0
000X00;o30001?l00?lC0003o`0001P000?o00000P000ol000080003o`0001h0000K00;o20000ol0
00030003o`00010000?o00003@000ol0000800;o1`000ol0000F0003o`00014000?o0000:P000ol0
00090004o`00oa<000?o000060000ol000020003o`0000P000?o00007P0001/000?o00001`000ol0
00030003o`00010000?o00003@000ol0000800;o1`000ol0000G0003o`00010000?o0000:`000ol0
00080004o`00oa<000?o000060000ol000020003o`0002T0000K0003o`0000L000?o00000`000ol0
000@0003o`0000h000?o00001`02o`H000?o000060000ol0000@0003o`0002`000?o00001P001Ol0
003o01<000?o000060000ol000020003o`0002T0000K0003o`0000L000?o00000`000ol0000@0003
o`0000h000?o00001P001?l00?l50003o`0001P000?o000040000ol0000]0003o`0000D000Go0000
o`0C0003o`0001P000?o00000P000ol0000Y00006`000ol000070003o`0000<000?o00008@000ol0
00060004o`00o`D000?o000060000ol0000?0003o`0002l000?o000010001Ol0003o018000?o0000
6@000ol000020003o`0002T0000K0003o`0000L000?o00000`000ol0000Q0003o`0000H000Co003o
1002oaX000?o00003`000ol0000`0003o`0000<000Go0000o`0B0003o`0001T000?o00000P000ol0
000Y00006`000ol000070003o`0000<000?o00008@000ol000060004o`00o`<000?o00006P000ol0
000?0003o`00034000?o00000P001Ol0003o018000?o00006@000ol000020003o`0002T0000K0003
o`0000L000?o00000`000ol0000Q0003o`0000H000Co00000olM0003o`0000l000?o0000<P001Ol0
003o00<000?o000040000ol0000I0003o`00008000?o0000:@0001/00_l80003o`0000<000?o0000
8@000ol000060005o`000?l07`000ol0000?0003o`0003<01?l30003o`00010000?o00006@000ol0
00020003o`0002T0000K0003o`0000P000?o00000P000ol0000Q0003o`0000H000?o00008@000ol0
000?0003o`0003H000?o00000P000ol0000?0003o`0001T000?o00000P000ol0000Y00006`000ol0
00080003o`00008000?o00008@000ol000060003o`00024000?o00003`000ol0000k0003o`0000l0
00?o00006@000ol000020003o`0002T0000K0003o`0000P000?o00000P000ol0000R0003o`0000D0
00?o00008P000ol0000>0003o`0003/000?o00003`000ol0000J0005o`000?l0:`0001/000?o0000
20000ol000020003o`0002<000?o000010000ol0000R0003o`0000h000?o0000>`000ol0000?0003
o`0001X000Go0000o`0[00006`000ol000080003o`00008000?o00008`000ol000040003o`000280
00?o00003@000ol0000l0003o`0000l000?o00006P001Ol0003o02/0000K0003o`0000P000?o0000
0P000ol0000T0003o`0000<000?o00008P000ol0000=0003o`0003`000?o00003`000ol0000J0004
o`00ob`000000`3oo`02o`<00_l400;o1002o`D000?o000020000ol000020003o`0002@000?o0000
0`000ol0000R0003o`0000d000?o0000?0000ol0000>0003o`0001/000Co003o;000008000?o0000
0P001?l00?l20004o`00o`8000Co003o10000ol000080003o`00008000?o000090000ol000020003
o`0002@000?o000030000ol0000l0003o`0000h000?o00006`001?l00?l/00000`001Ol0003o0080
00Co003o0P001?l00?l20003o`0000800ol80003o`00008000?o00009@001Ol0003o02H000?o0000
30000ol0000l0003o`0000h000?o00006`001?l00?l/000010001?l00?l20004o`00o`8000Co003o
0P000ol000020003o`0000P000?o00000P000ol0000U0005o`000?l09P000ol0000<0003o`0003`0
00?o00003P000ol0000K0004o`00ob`000001@3o003o008000Co003o0P001?l00?l20004o`00o`@0
00?o000020000ol000020003o`0002D000Go0000o`0V0003o`0000/000?o0000?@000ol0000>0003
o`0001`000?o0?l0;00000800_l400;o1002o`@00_l50003o`0000P000?o00000P000ol0000U0005
o`000?l09P000ol0000;0003o`0003d000?o00003P000ol0000M00;o;00001/000?o000020000ol0
00020003o`0002D000Go0000o`0W0003o`0000X000?o0000?P000ol0000=0003o`0001h000?o0000
:P0001/000?o000020000ol000020003o`0002H000Co0?oo9`000ol0000:0003o`0003h000?o0000
3@000ol0001;00006`000ol000080003o`00008000?o00009P02obT000?o00002P000ol0000n0003
o`0000d000?o0000B`0001/000?o000020000ol000020003o`00054000?o00002P000ol0000n0003
o`0000d000?o0000B`0001/00_l90003o`00008000?o0000D@000ol000090003o`0003l000?o0000
3@000ol0001;00006`000ol000080003o`00008000?o0000D@000ol000090003o`0003l000?o0000
3@000ol0001;00006`000ol000080003o`00008000?o0000D@000ol000090003o`0003l000?o0000
30000ol0001<00006`000ol000080003o`00008000?o0000D@000ol000090003o`0003l000?o0000
30000ol0001<00006`000ol000080003o`00008000?o0000DP000ol000080003o`0003l000?o0000
30000ol0001<00006`000ol000080003o`00008000?o0000DP000ol000080003o`0003l000?o0000
30000ol0001<00006`000ol000090005o`000?l0E0000ol000080003o`0003l000?o000030000ol0
001<00006`000ol000090005o`000?l0E0000ol000070003o`00040000?o000030000ol0001<0000
6`000ol000090005o`000?l0E0000ol000070003o`00044000?o00002`000ol0001<00006`02o`X0
00Go0000o`1D0003o`0000L000?o0000@@000ol0000;0003o`0004`0000K0003o`0000T000Go0000
o`1D0003o`0000L000?o0000@@000ol0000;0003o`0004`0000K0003o`0000T000Go0000o`1D0003
o`0000<000Go0000o`130003o`0000/000?o0000C00001/000?o00002@001Ol0003o05@000?o0000
0`001Ol0003o04<000?o00002`000ol0001<00006`000ol000090005o`000?l0E0000ol0000300;o
0P000ol000110003o`0000/000?o0000C00001/000?o00002@001Ol0003o05@000?o00000`02o`03
0?l004<000?o00002`000ol0001<00006`000ol000090005o`000?l0E0000ol000030004o`3ood@0
00?o00002P000ol0001=00006`000ol000090005o`000?l0E0000ol000030004o`3ood@000?o0000
2P000ol0001=00006`02o`X000Go0000o`1E0005o`000?l00`000ol000120003o`0000X000?o0000
C@0001/000?o00002@001Ol0003o05D000Go0000o`180003o`0000X000?o0000C@0001/000?o0000
2@001Ol0003o05D000Go0000o`190003o`0000T000?o0000C@0001/000?o00002@001Ol0003o05D0
00Go0000o`190003o`0000T000?o0000C@0001/000?o00002@001Ol0003o05D000Go0000o`190003
o`0000T000?o0000C@0001/000?o00002@001Ol0003o05D000Go0000o`190003o`0000T000?o0000
C@0001/000?o00002@001Ol0003o05D000Go0000o`190003o`0000T000?o0000C@0001/000?o0000
2@001Ol0003o05D000Go0000o`190003o`0000T000?o0000C@0001/000?o00002@001Ol0003o05H0
00Co003oB@000ol000090003o`0004d0000K00;o2`001?l00?mF0003o`3o04X000?o000020000ol0
001>00006`000ol0000:0004o`00oeL00_m:0003o`0000P000?o0000CP0001/000?o00002P001?l0
0?mG00;oBP000ol000080003o`0004h0000K0003o`0000X000Co003oE`02odX000?o000020000ol0
001>00006`000ol0000:0003o`3o05T000?o0000B@000ol000070003o`0004h0000K0003o`0000X0
00?o0?l0Y@000ol000070003o`0004h00000103oool400;o1002o`@00_l50003o`0000X000?o0?l0
Y@000ol000070003o`0004h000040004o`00o`8000Co003o0P001?l00?l20003o`00008000?o0000
2P000ol0o`2U0003o`0000L000?o0000CP0000@000Co003o0P001?l00?l20004o`00o`8000?o0000
0P03o`X000?o0?l0Y@000ol000070003o`0004h0000200;o0`001?l00?l20004o`00o`8000Co003o
10000ol0000:0003o`3o0:D000?o00001P000ol0001?000010001?l00?l20004o`00o`8000Co003o
0P000ol000020003o`0000X000?o0?l0Y@000ol000060003o`0004l00000103oool400;o1002o`@0
0_l50003o`0000X000?o0?l0Y@000ol000060003o`0004l0000K0003o`0000X000?o0?l0Y@000ol0
00060003o`0004l0000K0003o`0000X000?o0?l0Y@000ol000060003o`0004l0000K0003o`0000X0
00?o0?l0Y@000ol000060003o`0004l0000K0003o`0000X000?o0?l0YP000ol000050003o`0004l0
000K0003o`0000X000?o0?l0YP000ol000050003o`0004l0000K00;o3002ojH000?o00001@000ol0
001?00006`000ol0000;00;oYP000ol000040003o`000500000K0003o`0000/00_nV0003o`0000@0
00?o0000D00001/000?o00002`02ojH000?o000010000ol0001@00006`000ol0000;00;oYP000ol0
00040003o`000500000K0003o`0000/00_nV0003o`0000@000?o0000D00001/000?o00002`02ojH0
00?o000010000ol0001@00006`000ol0000;00;oYP000ol000030003o`000540000K00;o3002ojL0
00?o00000P000ol0001A00006`000ol0000;00;oY`000ol000020003o`000540000K0003o`0000/0
0_nW0005o`000?l0E00001/000?o00002`02ojL000Go0000o`1D00006`000ol0000;00;oY`001Ol0
003o05@0000K0003o`0000/00_nW0004o`00oeD0000K0003o`0000/00_nW0004o`00oeD0000K0003
o`0000/00_nW0004o`00oeD0000K0003o`0000/00_nW0003o`3o05H0000K00;o3002ojP00_mF0000
6`000ol0000<0003o`000:H00_mF00006`000ol0000<0003o`000:H000?o0000E@0001/000?o0000
30000ol0002V0003o`0005D0000K0003o`0000`000?o0000oP0001/000?o000030000ol0003n0000
6`000ol0000<0003o`000?h0000K0003o`0000`000?o0000oP0001/000?o000030000ol0003n0000
6`02o`d000?o0000oP0001/000?o0000o`0>00006`000ol0003o00h0000K0003o`000?l03P0001/0
00?o0000o`0>0000o`0/0000o`0/0000\
\>"],
  ImageRangeCache->{{{0, 298.062}, {183.75, 0}} -> {-11.0283, -339.227, 
  0.401522, 23.4129}}]
}, Closed]],

Cell[BoxData[
    \(Clear[elementdata]\)], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Add-On Packages", "Subsubsection"],

Cell[TextData[{
  "The package ",
  StyleBox["Graphics`Graphics`", "Input"],
  " defines several functions useful for plotting data. Here we load the \
package."
}], "Text"],

Cell[BoxData[
    \(Needs["\<Graphics`Graphics`\>"]\)], "Input"],

Cell[TextData[{
  "The functions ",
  StyleBox["LogListPlot", "Input"],
  ", ",
  StyleBox["LogLinearListPlot", "Input"],
  ", and ",
  StyleBox["LogLogListPlot", "Input"],
  " create various logarithmic plots of data."
}], "Text"],

Cell[BoxData[
    \(\(wts = AtomicWeight[Elements]; \)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(LogListPlot[wts]; \)\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.00898473 0.0147151 0.243229 [
[.02381 -0.0125 -3 -9 ]
[.02381 -0.0125 3 0 ]
[.2035 -0.0125 -6 -9 ]
[.2035 -0.0125 6 0 ]
[.3832 -0.0125 -6 -9 ]
[.3832 -0.0125 6 0 ]
[.56289 -0.0125 -6 -9 ]
[.56289 -0.0125 6 0 ]
[.74259 -0.0125 -6 -9 ]
[.74259 -0.0125 6 0 ]
[.92228 -0.0125 -9 -9 ]
[.92228 -0.0125 9 0 ]
[-0.0125 .01472 -10 -7.5 ]
[-0.0125 .01472 0 7.5 ]
[-0.0125 .08793 -10 -7.5 ]
[-0.0125 .08793 0 7.5 ]
[-0.0125 .18472 -10 -7.5 ]
[-0.0125 .18472 0 7.5 ]
[-0.0125 .25794 -16 -7.5 ]
[-0.0125 .25794 0 7.5 ]
[-0.0125 .33116 -16 -7.5 ]
[-0.0125 .33116 0 7.5 ]
[-0.0125 .42795 -16 -7.5 ]
[-0.0125 .42795 0 7.5 ]
[-0.0125 .50117 -22 -7.5 ]
[-0.0125 .50117 0 7.5 ]
[-0.0125 .57439 -22 -7.5 ]
[-0.0125 .57439 0 7.5 ]
[ -0.0005 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 0 m
.02381 .00625 L
s
[(0)] .02381 -0.0125 0 1 Mshowa
.2035 0 m
.2035 .00625 L
s
[(20)] .2035 -0.0125 0 1 Mshowa
.3832 0 m
.3832 .00625 L
s
[(40)] .3832 -0.0125 0 1 Mshowa
.56289 0 m
.56289 .00625 L
s
[(60)] .56289 -0.0125 0 1 Mshowa
.74259 0 m
.74259 .00625 L
s
[(80)] .74259 -0.0125 0 1 Mshowa
.92228 0 m
.92228 .00625 L
s
[(100)] .92228 -0.0125 0 1 Mshowa
.125 Mabswid
.06873 0 m
.06873 .00375 L
s
.11366 0 m
.11366 .00375 L
s
.15858 0 m
.15858 .00375 L
s
.24843 0 m
.24843 .00375 L
s
.29335 0 m
.29335 .00375 L
s
.33827 0 m
.33827 .00375 L
s
.42812 0 m
.42812 .00375 L
s
.47305 0 m
.47305 .00375 L
s
.51797 0 m
.51797 .00375 L
s
.60782 0 m
.60782 .00375 L
s
.65274 0 m
.65274 .00375 L
s
.69766 0 m
.69766 .00375 L
s
.78751 0 m
.78751 .00375 L
s
.83243 0 m
.83243 .00375 L
s
.87736 0 m
.87736 .00375 L
s
.96721 0 m
.96721 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .01472 m
.00625 .01472 L
s
gsave
-0.0125 .01472 -71 -11.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 15.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 15.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(1) show
69.000000 15.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
0 .08793 m
.00625 .08793 L
s
gsave
-0.0125 .08793 -71 -11.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 15.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 15.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(2) show
69.000000 15.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
0 .18472 m
.00625 .18472 L
s
gsave
-0.0125 .18472 -71 -11.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 15.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 15.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(5) show
69.000000 15.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
0 .25794 m
.00625 .25794 L
s
gsave
-0.0125 .25794 -77 -11.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 15.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 15.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(10) show
75.000000 15.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
0 .33116 m
.00625 .33116 L
s
gsave
-0.0125 .33116 -77 -11.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 15.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 15.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(20) show
75.000000 15.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
0 .42795 m
.00625 .42795 L
s
gsave
-0.0125 .42795 -77 -11.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 15.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 15.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(50) show
75.000000 15.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
0 .50117 m
.00625 .50117 L
s
gsave
-0.0125 .50117 -83 -11.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 15.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 15.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(100) show
81.000000 15.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
0 .57439 m
.00625 .57439 L
s
gsave
-0.0125 .57439 -83 -11.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 15.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 15.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(200) show
81.000000 15.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
.001 w
0 .13076 m
.00375 .13076 L
s
0 .16115 m
.00375 .16115 L
s
0 .20398 m
.00375 .20398 L
s
0 .22027 m
.00375 .22027 L
s
0 .23437 m
.00375 .23437 L
s
0 .24681 m
.00375 .24681 L
s
0 .37399 m
.00375 .37399 L
s
0 .40438 m
.00375 .40438 L
s
0 .44721 m
.00375 .44721 L
s
0 .4635 m
.00375 .4635 L
s
0 .4776 m
.00375 .4776 L
s
0 .49004 m
.00375 .49004 L
s
0 .61722 m
.00375 .61722 L
s
.25 Mabswid
0 0 m
0 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.008 w
.03279 .01555 Mdot
.04178 .16122 Mdot
.05076 .21937 Mdot
.05975 .24696 Mdot
.06873 .26617 Mdot
.07772 .2773 Mdot
.0867 .29354 Mdot
.09569 .30759 Mdot
.10467 .32574 Mdot
.11366 .3321 Mdot
.12264 .34588 Mdot
.13163 .35176 Mdot
.14061 .36279 Mdot
.1496 .36703 Mdot
.15858 .37737 Mdot
.16757 .38101 Mdot
.17655 .39164 Mdot
.18553 .40425 Mdot
.19452 .40197 Mdot
.2035 .40459 Mdot
.21249 .41672 Mdot
.22147 .42338 Mdot
.23046 .42992 Mdot
.23944 .43209 Mdot
.24843 .4379 Mdot
.25741 .43964 Mdot
.2664 .44532 Mdot
.27538 .44488 Mdot
.28437 .45328 Mdot
.29335 .45628 Mdot
.30234 .46307 Mdot
.31132 .46733 Mdot
.32031 .47067 Mdot
.32929 .47622 Mdot
.33827 .47748 Mdot
.34726 .4825 Mdot
.35624 .48459 Mdot
.36523 .48721 Mdot
.37421 .48875 Mdot
.3832 .49147 Mdot
.39218 .4934 Mdot
.40117 .4968 Mdot
.41015 .50011 Mdot
.41914 .5023 Mdot
.42812 .5042 Mdot
.43711 .50775 Mdot
.44609 .50917 Mdot
.45508 .51353 Mdot
.46406 .51577 Mdot
.47305 .51927 Mdot
.48203 .52196 Mdot
.49102 .52692 Mdot
.5 .52634 Mdot
.50898 .52993 Mdot
.51797 .53122 Mdot
.52695 .53468 Mdot
.53594 .53589 Mdot
.54492 .53681 Mdot
.55391 .5374 Mdot
.56289 .53987 Mdot
.57188 .54042 Mdot
.58086 .54426 Mdot
.58985 .54538 Mdot
.59883 .54899 Mdot
.60782 .55011 Mdot
.6168 .55246 Mdot
.62579 .55403 Mdot
.63477 .55551 Mdot
.64376 .55656 Mdot
.65274 .5591 Mdot
.66173 .56027 Mdot
.67071 .56237 Mdot
.67969 .56382 Mdot
.68868 .5655 Mdot
.69766 .56684 Mdot
.70665 .56909 Mdot
.71563 .5702 Mdot
.72462 .57176 Mdot
.7336 .57278 Mdot
.74259 .5747 Mdot
.75157 .57668 Mdot
.76056 .57813 Mdot
.76954 .57903 Mdot
.77853 .57904 Mdot
.78751 .57955 Mdot
.7965 .58542 Mdot
.80548 .58589 Mdot
.81447 .58731 Mdot
.82345 .58778 Mdot
.83243 .59009 Mdot
.84142 .58963 Mdot
.8504 .59278 Mdot
.85939 .59234 Mdot
.86837 .5954 Mdot
.87736 .59496 Mdot
.88634 .59669 Mdot
.89533 .59669 Mdot
.90431 .59839 Mdot
.9133 .59964 Mdot
.92228 .60088 Mdot
.93127 .60129 Mdot
.94025 .6017 Mdot
.94924 .60211 Mdot
.95822 .60251 Mdot
.96721 .60292 Mdot
.97619 .60332 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{299.062, 184.688},
  ImageMargins->{{48, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004[0000^0P10`4000010?ooooooc?ooZ_ooI_oo
<ooo0?o<ooo<c?o<VC/k>gYjN[Vi^OShn03ooeGooj[ooonI<onI0?mVoomVc?mVVOmVI_mV<omV0?lc
oclo?ginO[fm_Oclo5D00:X00?l00?l0VOl0I_l0<ol00<coolcoc<coVLcoIP<30d92@X61PL30`000
EED0EJX0EOl0ELbIolbIc<bIVLbII/bI<lbI0<aVolaVc0L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0Z/`c
<l`c0<`0ol`0c<`0VL`0I/`0<l`000/;2dY:BXV9RLS8b000oeD0ojX0ool0oiW<VIW<IYW<<iW<09VI
oiVIc9VIVIVIIPl?3di>CXf=SLc<c01E05EE0:YE0?mE09TcoiTcc9TcVITcIYTc<iTc09T0oiT0c1<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEEFKo<fKo06K<ofK<c6K<VFK<IVK<<fK<01LG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZVIVVFIVIVIV<fIV06HcofHcc6HcVFHcIQ/K6eYJFYVIVMSHf01EoeEEojYEoomEoc?o
oc?oc3?oVC?oIS?o<c?o03?<oc?<c1lO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ03>I<c>I03=Voc=Vc3=V
VC=VIS=V<c=V02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZEC<0VC<0IS<0<c<0003oo`3oc03oV@3oIRLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2Io`2Ic02IV@2IIP2I<`2I001Vo`1Vc2/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`0c<`0c0000o`00c000V@00IP00<nh002l_;fi^KZf][Nc/k03o05Go0:[o0?oo0140
003^003M002k002Z0028001g001E03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@00M`00E@00A0008P00
4Nk^k]gMgK^k^cLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l0;0000?l0;0000?l0;00001h00_l[00Co
0`02obT00ol300;o:@02o`@00_lY00;o1002obD00ol400;o1002oa00000M0004o`00ob/000?o0000
0P001?l00?lY0005o`000?l00P000ol0000U0004o`00o`8000Co003o9`001?l00?l20004o`00obD0
00?o00000P001?l00?l20004o`00o`l0000M0004o`00ob`000Go0000o`020003o`0002D01?l20004
o`00obL000Co003o0P001?l00?lW0004o`00o`8000Co003o9@000ol000020004o`00o`8000Co003o
3`0001d000Co003o;@001?l00?l20003o`0002D000?o0?l00`001?l00?lW00?o0`001?l00?lX00;o
0`001?l00?lU0003o`00008000Co003o0P001?l00?l?00007@001?l00?lZ0004o`00o`8000Co003o
9`000ol0o`030004o`00obL000?o00000`001?l00?lW0004o`00o`8000Co003o9@000ol000020004
o`00o`8000Co003o3`0001h00_l/00;o1002obT00_l400;o:@03o`<00_lY00;o1002obD00_l500;o
1002oa00003o02`0003o02`0003o02`0003o02`0003o02`0000I0?oo4ol000l00ol70003o`0000<0
00?o00002P000ol000090003o`0000T000?o00002@000ol0000:0003o`0000T000?o00002@000ol0
00090003o`0000X000?o00002@000ol000090003o`0000T000?o00002P000ol000090003o`0000T0
00?o00002@000ol0000:0003o`0000T000?o00002@000ol000090003o`0000X000?o00001`000100
00?o00001P000ol0003o0100000@0003o`0000H000?o00001@02ool02@00010000?o00001P03o`D0
0_oo00T0000@0003o`0000H000?o0000o`0@00003`02o`P000?o0000o`0@00006@000ol0003o0100
000I0003o`000?l0400001T000?o0000o`0@00006@000ol0003o0100000I0003o`000?l0400001T0
00?o0000o`0@00006@000ol0003o0100000I0003o`000?l0400001T000?o0000o`0@00006@000ol0
003o0100000I0003o`000?l0400001T000?o0000o`0@00006@000ol0003o0100000I0003o`000?l0
400000l01?l60003o`000?l04000010000?o00001P000ol0003o0100000A0003o`0000D000?o0000
o`0@00004P000ol0000400?oo`0@00003`001?l00?l60003o`000?l0400001000_l70003o`000?l0
400001T000?o0000o`0@00006@000ol0003o0100000I0003o`000?l0400001T000?o0000o`0@0000
6@000ol0003o0100000I0003o`000?l0400001T000?o0000o`0@00006@000ol0003o0100000I00;o
o`0A00006@000ol0003o0100000I0003o`000?l0400001T000?o0000o`0@00006@000ol0003o0100
000I0003o`000?l0400001T000?o0000o`0@00006@000ol0003o0100000I0003o`0000P00_oo00H0
000I00;o2@02ool01P0001T000?o0000o`0@00006@000ol0003o0100000?00?o1`000ol0003o0100
000B0003o`0000@000?o0000o`0@00004P000ol000040003o`000?l0400000l00ol700?oo`0@0000
3`000ol000070003o`000?l0400000l01?l60003o`000?l0400001T000?o0000o`0@00006@000ol0
003o0100000I00;oo`0A00006@000ol0003o0100000I0003o`000?l0400001T000?o0000o`0@0000
6@000ol0000:00;oo`0400006@02o`/00_oo00@0000I0003o`000?l0400001T000?o0000o`0@0000
6@000ol0003o0100000I00;oo`0A00006@000ol0003o0100000I0003o`000?l0400000T00ol400;o
1`02o`h00_oo0040000:0003o`00008000Co003o1P000ol0000=00;oo`0100002P000ol000020004
o`00o`H000?o0000o`0@00002P000ol000020004o`00o`H00ooo0100000:0003o`00008000Co003o
1P000ol0003o0100000900;o1@02o`L000?o00003`02ooh0000I0003o`0000l00_on00006@000ol0
003o0100000I0003o`0001800_ok00006@000ol0000B00;on`0001T000?o0000o`0@00006@000ol0
003o0100000I0003o`0001@00_oi00006@000ol0000D00;on@0001T000?o0000o`0@00006@000ol0
003o0100000I0003o`0001H00_og00006@000ol0000F00;om`0001T000?o0000o`0@00006@000ol0
003o0100000900Co0`02o`L000?o0000o`0@00002P000ol000020004o`00o`H000?o00006@02oo@0
000;0005o`000?l00P000ol000040003o`0001T00_od000030001?l00?l20003o`0000@00olK00;o
lP0000T000Co003o0P001?l00?l60003o`0001/00_ob00002P02o`@00_l70003o`000?l0400001T0
00?o00007P02onl0000I0003o`0001h00_o_00006@000ol0000P00;ok@0001T000?o00008002ond0
000I0003o`000?l0400001T000?o00008`02onX0000I0003o`0002<01?oX00006@000ol0000U00;o
j00001T000?o0000o`0@00006@02obT00_oU00006@000ol0000X00Coh`0001T000?o0000:P02on<0
000I0003o`000?l0400001T000?o0000;002on40000I0003o`0002`00_oQ00006@000ol0003o0100
000I0003o`0002l01?l00`3oo`3I00006@02oc001?l00`3oo`3I00006@000ol0003o0100000I0003
o`000?l0400001T000?o0000=P02omL0000900?o1002o`L000?o0000=P02omL0000<0004o`00o`80
00?o000010000ol0000i00;oe00000`000Co003o0P000ol0000400?o>@04om80000900?o0`001?l0
0?l60003o`0003/00_l00`3oo`3?00002@000ol000030004o`00o`H000?o0000?P02oll0000900Co
0`02o`L000?o0000@002o`030?oo0<X0000I0003o`0004000_l00`3oo`0200;oaP0001T000?o0000
A@04olH0000I00;oAP02olP0000I0003o`0004X00_o300006@000ol0001:00Co`@0001T000?o0000
C002o`030?oo0;h0000I00;oD002okh0000I0003o`0005400_l00`3oo`2i00006@000ol0001A00;o
00<0ool0^@0001T000?o0000EP02o`030?oo0;@0000I00;oE`02o`030?oo0;@0000I0003o`0005/0
1?n`00006@000ol0001K00Co00<0ool00_n[00006@02of401?l00`3oo`2X00000`03o`@00_l400;o
1`000ol0001U00CoYP0000@000?o00000P001?l00?l20004o`00o`H000?o0000I`02o`030?oo0:<0
00040003o`00008000Co003o0P001?l00?l600?oJP04o`030?oo09h000040003o`00008000Co003o
0P001?l00?l60003o`0006`00_l00`3oo`02oi`000040003o`00008000Co003o0P001?l00?l60003
o`0007400_l00`3oo`02oiL0000300;o1@02o`@00_l70003o`0007@01_nE00006@000ol0001h00;o
00<0ool0TP0001T000?o0000N`04o`030?oo08d0000I0003o`0007d00_l00`3oo`2=00006@000ol0
002200;o00<0ool0R00001T000?o0000PP02o`030?oo00;o00<0ool0P`0001T000?o0000Q`02o`03
0?oo00CoO`0001T000?o0000S004o`030?oo00;o00<0ool0M`0001T000?o0000T@04o`030?oo00;o
M@0001T000?o0000V002o`030?oo00;oL00001T000?o0000V`04o`030?oo00;oJ`0001T000?o0000
X004o`030?oo00;oIP0001T000?o0000Y@06o`030?oo0640000I0003o`000:T00_l00`3oo`02o`03
0?oo00;oFP0001T000?o0000[P02o`030?oo00;o00<0ool00_mE00000`04o`<00_l400;o1`000ol0
002f00Co00<0ool00_m@000010000ol000020004o`00o`8000Co003o1P000ol0002k00Ko00<0ool0
0_m900001@001Ol0003o008000Co003o0P000ol0000400?o_`02o`030?oo00;o00<0ool00_m40000
1P001?l00?l20004o`00o`8000?o000010000ol0003700Co00<0ool00_l00`3oo`02ocX000030004
o`00o`8000Co003o0P001?l00?l60003o`000<`01?l00`3oo`02ocX0000400;o1002o`@00_l70003
o`000=H01_l00`3oo`0`00006@000ol0003F00Ko00<0ool00_l00`3oo`0[00006@000ol0003O00;o
00<0ool00_l00`3oo`0300;o8@0001T000?o0000i002o`030?oo00;o00<0ool01?l00`3oo`0J0000
6@000ol0003Y00;o0`04o`030?oo00;o00<0ool00_l00`3oo`02o`030?oo00/0000I0003o`000?D0
0_l00`3oo`02o`030?oo00;o00<0ool00_l00`3oo`0600006@000ol0003o00D00_l00`3oo`060000
6@000ol0003o0100000I0003o`000?l0400001T00_oo0140003o02`00000\
\>"],
  ImageRangeCache->{{{0, 298.062}, {183.688, 0}} -> {-13.0225, -0.268506, 
  0.408213, 0.0150791}}]
}, Closed]],

Cell[TextData[{
  StyleBox["BarChart", "Input"],
  ", ",
  StyleBox["GeneralizedBarChart", "Input"],
  ", ",
  StyleBox["StackedBarChart", "Input"],
  ", and ",
  StyleBox["PercentileBarChart", "Input"],
  " create various bar charts and histograms of data, and ",
  StyleBox["PieChart", "Input"],
  " creates pie charts."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(Show[
      GraphicsArray[{
          BarChart[
            Transpose[{Take[wts, 5], Abbreviation[Take[Elements, 5]]}], 
            DisplayFunction \[Rule] Identity], 
          PieChart[Take[wts, 5], 
            PieLabels \[Rule] Abbreviation[Take[Elements, 5]], 
            DisplayFunction \[Rule] Identity]}]]; \)\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .2943 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.47619 0.00700719 0.47619 [
[ 0 0 0 0 ]
[ 1 .2943 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .2943 L
0 .2943 L
closepath
clip
newpath
% Start of sub-graphic
p
0.0238095 0.00700719 0.477324 0.287295 MathSubStart
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0769231 0.192308 0.0147151 0.0544499 [
[.11538 .00222 -5 -15 ]
[.11538 .00222 5 0 ]
[.30769 .00222 -8 -15 ]
[.30769 .00222 8 0 ]
[.5 .00222 -8 -15 ]
[.5 .00222 8 0 ]
[.69231 .00222 -8 -15 ]
[.69231 .00222 8 0 ]
[.88462 .00222 -5 -15 ]
[.88462 .00222 5 0 ]
[-0.0125 .12361 -6 -4.5 ]
[-0.0125 .12361 0 4.5 ]
[-0.0125 .23251 -6 -4.5 ]
[-0.0125 .23251 0 4.5 ]
[-0.0125 .34141 -6 -4.5 ]
[-0.0125 .34141 0 4.5 ]
[-0.0125 .45031 -6 -4.5 ]
[-0.0125 .45031 0 4.5 ]
[-0.0125 .55921 -12 -4.5 ]
[-0.0125 .55921 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.11538 .01472 m
.11538 .02097 L
s
gsave
.11538 .00222 -66 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 15.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 15.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(H) show
69.000000 15.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
.30769 .01472 m
.30769 .02097 L
s
gsave
.30769 .00222 -69 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 15.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 15.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(He) show
75.000000 15.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
.5 .01472 m
.5 .02097 L
s
gsave
.5 .00222 -69 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 15.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 15.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(Li) show
75.000000 15.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
.69231 .01472 m
.69231 .02097 L
s
gsave
.69231 .00222 -69 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 15.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 15.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(Be) show
75.000000 15.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
.88462 .01472 m
.88462 .02097 L
s
gsave
.88462 .00222 -66 -19 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 15.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 15.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(B) show
69.000000 15.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
0 .01472 m
1 .01472 L
s
0 .12361 m
.00625 .12361 L
s
[(2)] -0.0125 .12361 1 0 Mshowa
0 .23251 m
.00625 .23251 L
s
[(4)] -0.0125 .23251 1 0 Mshowa
0 .34141 m
.00625 .34141 L
s
[(6)] -0.0125 .34141 1 0 Mshowa
0 .45031 m
.00625 .45031 L
s
[(8)] -0.0125 .45031 1 0 Mshowa
0 .55921 m
.00625 .55921 L
s
[(10)] -0.0125 .55921 1 0 Mshowa
.125 Mabswid
0 .04194 m
.00375 .04194 L
s
0 .06917 m
.00375 .06917 L
s
0 .09639 m
.00375 .09639 L
s
0 .15084 m
.00375 .15084 L
s
0 .17806 m
.00375 .17806 L
s
0 .20529 m
.00375 .20529 L
s
0 .25974 m
.00375 .25974 L
s
0 .28696 m
.00375 .28696 L
s
0 .31419 m
.00375 .31419 L
s
0 .36864 m
.00375 .36864 L
s
0 .39586 m
.00375 .39586 L
s
0 .42309 m
.00375 .42309 L
s
0 .47754 m
.00375 .47754 L
s
0 .50476 m
.00375 .50476 L
s
0 .53199 m
.00375 .53199 L
s
0 .58644 m
.00375 .58644 L
s
0 .61366 m
.00375 .61366 L
s
.25 Mabswid
0 0 m
0 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
1 0 0 r
.03846 .01472 m
.03846 .0696 L
.19231 .0696 L
.19231 .01472 L
F
0 g
.5 Mabswid
.03846 .01472 m
.03846 .0696 L
.19231 .0696 L
.19231 .01472 L
.03846 .01472 L
s
1 0 0 r
.23077 .01472 m
.23077 .23266 L
.38462 .23266 L
.38462 .01472 L
F
0 g
.23077 .01472 m
.23077 .23266 L
.38462 .23266 L
.38462 .01472 L
.23077 .01472 L
s
1 0 0 r
.42308 .01472 m
.42308 .39265 L
.57692 .39265 L
.57692 .01472 L
F
0 g
.42308 .01472 m
.42308 .39265 L
.57692 .39265 L
.57692 .01472 L
.42308 .01472 L
s
1 0 0 r
.61538 .01472 m
.61538 .50543 L
.76923 .50543 L
.76923 .01472 L
F
0 g
.61538 .01472 m
.61538 .50543 L
.76923 .50543 L
.76923 .01472 L
.61538 .01472 L
s
1 0 0 r
.80769 .01472 m
.80769 .60332 L
.96154 .60332 L
.96154 .01472 L
F
0 g
.80769 .01472 m
.80769 .60332 L
.96154 .60332 L
.96154 .01472 L
.80769 .01472 L
s
MathSubEnd
P
% End of sub-graphic
% Start of sub-graphic
p
0.522676 0.00700719 0.97619 0.287295 MathSubStart
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.47619 0.5 0.47619 [
[.7843 .52843 -5 -7.5 ]
[.7843 .52843 5 7.5 ]
[.7366 .66016 -8 -7.5 ]
[.7366 .66016 8 7.5 ]
[.46968 .7841 -8 -7.5 ]
[.46968 .7841 8 7.5 ]
[.2161 .46782 -8 -7.5 ]
[.2161 .46782 8 7.5 ]
[.63747 .24953 -5 -7.5 ]
[.63747 .24953 5 7.5 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
1 0 0 r
.5 .5 m
.5 .5 .47619 0 11.4201 arc
F
.95 1 0 r
.5 .5 m
.5 .5 .47619 11.4201 56.77 arc
F
0 1 .1 r
.5 .5 m
.5 .5 .47619 56.77 135.412 arc
F
0 .85 1 r
.5 .5 m
.5 .5 .47619 135.412 237.521 arc
F
.2 0 1 r
.5 .5 m
.5 .5 .47619 237.521 360 arc
F
0 g
.5 Mabswid
[ ] 0 setdash
.5 .5 m
.97619 .5 L
s
.5 .5 m
.96676 .59429 L
s
newpath
.5 .5 .47619 0 11.4201 arc
s
.5 .5 m
.96676 .59429 L
s
.5 .5 m
.76095 .89832 L
s
newpath
.5 .5 .47619 11.4201 56.77 arc
s
.5 .5 m
.76095 .89832 L
s
.5 .5 m
.16087 .83429 L
s
newpath
.5 .5 .47619 56.77 135.412 arc
s
.5 .5 m
.16087 .83429 L
s
.5 .5 m
.24429 .09829 L
s
newpath
.5 .5 .47619 135.412 237.521 arc
s
.5 .5 m
.24429 .09829 L
s
.5 .5 m
.97619 .5 L
s
newpath
.5 .5 .47619 237.521 360 arc
s
gsave
.7843 .52843 -66 -11.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 15.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 15.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(H) show
69.000000 15.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
gsave
.7366 .66016 -69 -11.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 15.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 15.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(He) show
75.000000 15.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
gsave
.46968 .7841 -69 -11.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 15.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 15.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(Li) show
75.000000 15.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
gsave
.2161 .46782 -69 -11.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 15.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 15.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(Be) show
75.000000 15.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
gsave
.63747 .24953 -66 -11.5 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 15.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 15.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(B) show
69.000000 15.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
MathSubEnd
P
% End of sub-graphic
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{299.062, 87.9375},
  ImageMargins->{{48, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004[0000E`P10`4000010?ooooooc?ooZ_ooI_oo
<ooo0?o<ooo<c?o<VC/k>gYjN[Vi^OShn03ooeGooj[ooonI<onI0?mVoomVc?mVVOmVI_mV<omV0?lc
oclo?ginO[fm_Oclo5D00:X00?l00?l0VOl0I_l0<ol00<coolcoc<coVLcoIP<30d92@X61PL30`000
EED0EJX0EOl0ELbIolbIc<bIVLbII/bI<lbI0<aVolaVc0L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0Z/`c
<l`c0<`0ol`0c<`0VL`0I/`0<l`000/;2dY:BXV9RLS8b000oeD0ojX0ool0oiW<VIW<IYW<<iW<09VI
oiVIc9VIVIVIIPl?3di>CXf=SLc<c01E05EE0:YE0?mE09TcoiTcc9TcVITcIYTc<iTc09T0oiT0c1<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEEFKo<fKo06K<ofK<c6K<VFK<IVK<<fK<01LG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZVIVVFIVIVIV<fIV06HcofHcc6HcVFHcIQ/K6eYJFYVIVMSHf01EoeEEojYEoomEoc?o
oc?oc3?oVC?oIS?o<c?o03?<oc?<c1lO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ03>I<c>I03=Voc=Vc3=V
VC=VIS=V<c=V02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZEC<0VC<0IS<0<c<0003oo`3oc03oV@3oIRLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2Io`2Ic02IV@2IIP2I<`2I001Vo`1Vc2/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`0c<`0c0000o`00c000V@00IP00<nh002l_;fi^KZf][Nc/k03o05Go0:[o0?oo0140
003^003M002k002Z0028001g001E03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@00M`00E@00A0008P00
4Nk^k]gMgK^k^cLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l0;0000?l0;0000?l0;0000?l0;0000=L0
4?m40000dP05o`0@CM9=dTgBCM9=dTgBCM9=dPGo?`000<l00ol06TgBCM9=dTgBCM9=dTgBCM9=dTgB
CM9=dTgB0oll00009002o`800_l<00;o0P02o`801?l:00Go0P05o`T01?l400Co3004oe000_l08DgB
CM9=dTgBCM9=dTgBCM9=dTgBCM9=dTgBCM9=dTgBo`0k00009@001?l00?l>0004o`00o`8000?o0000
3@001?l00?l40003o`0000X000Co003o0P000ol0000?0004o`00odd00_l09=9=dTgBCM9=dTgBCM9=
dTgBCM9=dTgBCM9=dTgBCM9=dTgBocX0000U0004o`00o`h000Co003o0P05o`/000Co003o10000ol0
000:0004o`00o`801Ol=0004o`00od`002OoCM9=dTgBCM9=dTgBCM9=dTgBCM9=dTgBCM9=dTgBCM9=
dTgBCM800_lh00009@04o`h01?l20005o`000?l02`000ol000050003o`0000X00ol30005o`000?l0
3@03od/00_l0:DgBCM9=dTgBCM9=dTgBCM9=dTgBCM9=dTgBCM9=dTgBCM9=dTgBCM9=00?o=@0002D0
00Co003o3P001?l00?l300?o30000ol0000400;o30001?l00?l300?o3P001?l00?m800;o02o<om9=
dTgBCM9=dTgBCM9=dTgBCM9=dTgBCM9=dTgBCM9=dTgBCM9=dTgBCM9=o`0d00009002o`800_l<00;o
0P02oa000olB00Co5004odP003?o3L`=c?oBCM9=dTgBCM9=dTgBCM9=dTgBCM9=dTgBCM9=dTgBCM9=
dTgBCM9=dTgBCOl0<`0005D000?o0000K@00=?o<3L`=c?oBCM9=dTgBCM9=dTgBCM9=dTgBCM9=dTgB
CM9=dTgBCM9=dTgBCM9=dTgBCOlb0000``02o`0ec0g<3L`=odgBCM9=dTgBCM9=dTgBCM9=dTgBCM9=
dTgBCM9=dTgBCM9=dTgBCM9=dTgBCOl0<@000<8003Wo3L`=c0g<3L`=odgBCM9=dTgBCM9=dTgBCM9=
dTgBCM9=dTgBCM9=dTgBCM9=dTgBCM9=dTgBCOl0<00001X000?o0000Y@00>Oo<3L`=c0g<3L`=odgB
CM9=dTgBCM9=dTgBCM9=dTgBCM9=dTgBCM9=dTgBCM9=dTgBCM9=dTgBo`0`00006P000ol0002T000k
ol`=c0g<3L`=c0g<om9=dTgBCM9=dTgBCM9=dTgBCM9=dTgBCM9=dTgBCM9=dTgBCM9=dTgBCM9=d_l0
;`0001X0L?lf000mol`=c0g<3L`=c0g<3LcodTgBCM9=dTgBCM9=dTgBCM9=dTgBCM9=dTgBCM9=dTgB
CM9=dTgBCM9=dTgBo`0^00006P000ol000020003ob<S00hS00Go0000o`0@8`05o`000?l042<01Ol0
003o010S00Go0000o`0@8`03o`0003P003ooc0g<3L`=c0g<3L`=c0goCM9=dTgBCM9=dTgBCM9=dTgB
CM9=dTgBCM9=dTgBCM9=dTgBCM9=dTgBCM9=d_l0;@0001X000?o00000P000olS8`0>8`05o`000?l0
42<01Ol0003o010S00Go0000o`0@8`05o`000?l042<00ol0000g000Yol`=c0g<3L`=c0g<3L`=c0go
CM9=dTgBCM9=dTgBCM9=dTgBCM9=dTd01?l05=9=dTgBCM9=dTgBCM9=dTgBCM;o;00001X00_l30003
ob<S00hS00Go0000o`0@8`05o`000?l042<01Ol0003o010S00Go0000o`0@8`03o`0003L004;o3L`=
c0g<3L`=c0g<3L`=c0goCM9=dTgBCM9=dTgBCM9=dTgBCM9=dTgoCM;odTgBCM9=dTgBCM9=dTgBCM9=
d_l[00006P000ol000020003ob<S00hS00Go0000o`0@8`05o`000?l042<01Ol0003o010S00Go0000
o`0@8`03o`0003H004?o3L`=c0g<3L`=c0g<3L`=c0g<om9=dTgBCM9=dTgBCM9=dTgBCM9=dTgBom9=
odgBCM9=dTgBCM9=dTgBCM9=dTgo02/0000J0003o`00008000?o8b<03R<01Ol0003o010S00Go0000
o`0@8`05o`000?l042<01Ol0003o010S00?o0000=P00:oo<3L`=c0g<3L`=c0g<3L`=c0g<om9=dTgB
CM9=dTgBCM9=dTgBCM9=dTd00ol05TgBCM9=dTgBCM9=dTgBCM9=dTgBCOlZ00006P02o`<04_l30003
ob<S00hS00Go0000o`0@8`05o`000?l042<01Ol0003o010S00?o0000=@00AOo<3L`=c0g<3L`=c0g<
3L`=c0g<3LcodTgBCM9=dTgBCM9=dTgBCM9=dTgBom9=odgBCM9=dTgBCM9=dTgBCM9=dTgBo`0Z0000
6P000ol0000G0003ob<S00hS00Go0000o`0@8`05o`000?l042<01Ol0003o010S00?o0000=@00:ol=
c0g<3L`=c0g<3L`=c0g<3L`=c0goCM9=dTgBCM9=dTgBCM9=dTgBCM801?l05dgBCM9=dTgBCM9=dTgB
CM9=dTgBCM;o02T0000J0003o`0001L000?o8b<03R<01Ol0003o010S00Go0000o`0@8`05o`000?l0
42<00ol0000d0017o`g<3L`=c0g<3L`=c0g<3L`=c0g<3L`=odgBCM9=dTgBCM9=dTgBCM9=dTgBCM9=
dTgBCM9=dTgBCM9=dTgBCM9=dTgBCOl0:@0001X00_lH0003ob<S00hS00Go0000o`0@8`05o`000?l0
42<01Ol0003o010S00?o0000=000B?o<3L`=c0g<3L`=c0g<3L`=c0g<3L`=c0goCM9=dTgBCM9=dTgB
CM9=dTgBCM9=dTgBCM9=dTgBCM9=dTgBCM9=dTgBCM9=obP0000D00Co0P000ol0000G0003ob<S00hS
00Go0000o`0@8`05o`000?l042<01Ol0003o010S00?o0000<`00BOo<3L`=c0g<3L`=c0g<3L`=c0g<
3L`=c0g<om9=dTgBCM9=dTgBCM9=dTgBCM9=dTgBCM9=dTgBCM9=dTgBCM9=dTgBCM9=d_l0:00001D0
00?o00000P000ol0000G0003ob<S00hS00Go0000o`0@8`05o`000?l042<01Ol0003o010S00?o0000
<`00BOl=c0g<3L`=c0g<3L`=c0g<3L`=c0g<3L`=c?oBCM9=dTgBCM9=dTgBCM9=dTgBCM9=dTgBCM9=
dTgBCM9=dTgBCM9=dTgBCOl0:00001H000Co00000_lH0003ob<S00hS00Go0000o`0@8`05o`000?l0
42<01Ol0003o010S00?o0000<P00Bol=c0g<3L`=c0g<3L`=c0g<3L`=c0g<3L`=c0goCM9=dTgBCM9=
dTgBCM9=dTgBCM9=dTgBCM9=dTgBCM9=dTgBCM9=dTgBCM9=o`0W00005`001?l00?lI0003ob<S00hS
00Go0000o`0@8`05o`000?l042<01Ol0003o010S00?o0000<P00Boo<3L`=c0g<3L`=c0g<3L`=c0g<
3L`=c0g<3L`=odgBCM9=dTgBCM9=dTgBCM9=dTgBCM9=dTgBCM9=dTgBCM9=dTgBCM9=dTgBo`0W0000
50001?l00?l20003o`0001L000?o8b<03R<01Ol0003o010S00Go0000o`0@8`05o`000?l042<00ol0
000a001=ol`=c0g<3L`=c0g<3L`=c0g<3L`=c0g<3L`=c0g<3Om=dTgBCM9=dTgBCM9=dTgBCM9=dTgB
CM9=dTgBCM9=dTgBCM9=dTgBCM9=d_l09P0001D00_l300;o60000olS8`0>8`05o`000?l042<01Ol0
003o010S00Go0000o`0@8`03o`00034004go3L`=c0g<3L`=c0g<3L`=c0g<3L`=c0g<3L`=c0g<om9=
dTgBCM9=dTgBCM9=dTgBCM9=dTgBCM9=dTgBCM9=dTgBCM9=dTgBCM9=o`0V00006P000ol0000G0003
ob<S00hS00Go0000o`0@8`05o`000?l042<01Ol0003o010S00?o0000<@00COo<3L`=c0g<3L`=c0g<
3L`=c0g<3L`=c0g<3L`=c0g<om9=dTgBCM9=dTgBCM9=dTgBCM9=dTgBCM9=dTgBCM9=dTgBCM9=dTgB
CM;o02H0000J0003o`0001L000?o8b<03R<01Ol0003o010S00Go0000o`0@8`05o`000?l042<00ol0
000a001>o`g<3L`=c0g<3L`=c0g<3L`=c0g<3L`=c0g<3L`=c0g<om9=dTgBCM9=dTgBCM9=dTgBCM9=
dTgBCM9=dTgBCM9=dTgBCM9=dTgBCM;o9@0001X00_lH0003ob<S00hS00Go0000o`0@8`05o`000?l0
42<01Ol0003o010S00?o0000<000Col=c0g<3L`=c0g<3L`=c0g<3L`=c0g<3L`=c0g<3L`=c0goCM9=
dTgBCM9=dTgBCM9=dTgBCM9=dTgBCM9=dTgBCM9=dTgBCM9=dTgBCOl09@0001X000?o00005`000olS
8`0>8`05o`000?l042<01Ol0003o010S00Go0000o`0@8`03o`00030004ooc0g<3L`=c0g<3L`=c0g<
3L`=c0g<3L`=c0g<3L`=c0g<3Om=dTgBCM9=dTgBCM9=dTgBCM9=dTgBCM9=dTgBCM9=dTgBCM9=dTgB
CM;o02D0000J0003o`0001L000?o8b<03R<01Ol0003o010S00Go0000o`0@8`05o`000?l042<00ol0
000`000:o`g<3L`=c0g<3@Co00C<3L`=1?l0>L`=c0g<3L`=c0g<3L`=odgBCM9=dTgBCM9=dTgBCM9=
dTgBCM9=dTgBCM9=dTgBCM9=dTgBCM9=o`0U00006P02oaP000?o8b<03R<01Ol0003o010S00Go0000
o`0@8`05o`000?l042<00ol0000`001?ol`=c0g<3L`=c0go3Lcoc0go3L`=c0g<3L`=c0g<3L`=c0g<
om9=dTgBCM9=dTgBCM9=dTgBCM9=dTgBCM9=dTgBCM9=dTgBCM9=dTgBo`0U00005@03o`8000?o0000
5`000olS8`0>8`05o`000?l042<01Ol0003o010S00Go0000o`0@8`03o`000300017o3L`=c0g<3L`=
c?o<3Ol=c005o`0jc0g<3L`=c0g<3L`=c0g<om9=dTgBCM9=dTgBCM9=dTgBCM9=dTgBCM9=dTgBCM9=
dTgBCM9=dTgBob@0000F0005o`000?l06@000olS8`0>8`05o`000?l042<01Ol0003o010S00Go0000
o`0@8`03o`00030000_oc0g<3L`=c0g<3@03o`123L`=o`g<3Ol=c0g<3L`=c0g<3L`=c0goCM9=dTgB
CM9=dTgBCM9=dTgBCM9=dTgBCM9=dTgBCM9=dTgBCM9=dTgo900001@01?l200;o600Bo`<000?o8b<0
3R<01Ol0003o010S00Go0000o`0@8`03o`00030001;o3L`=c0g<3L`=c?o<3Ol=c0d3o`0k3L`=c0g<
3L`=c0g<3L`=c0goCM9=dTgBCM9=dTgBCM9=dTgBCM9=dTgBCM9=dTgBCM9=dTgBCM9=d_l0900001@0
00?o0?l00`000ol0000/0003ob<S00hS00Go0000o`0@8`05o`000?l042<00ol0000`000:ol`=c0g<
3L`=c0Co01T=c0g<3L`=c0g<3L`=c0g<3L`=c0g<3L`=02Wo900001@000?o0?l00`000ol0000/0003
ob<S00hS00Go0000o`0@8`05o`000?l042<00ol0000`000Vo`g<3L`=c0g<3L`=c0g<3L`=c0g<3L`=
c0g<3L`=c0g<3L`=c0d2o`851Ol>8`04ob<So`hS00?o00008P0001D00_l300;o;@000olS8`0>8`05
o`000?l042<01Ol0003o010S00?o0000<0009_o<3L`=c0g<3L`=c0g<3L`=c0g<3L`=c0g<3L`=c0g<
3L`=c0go0]`01ooN1Mh5gPD01Ol98`04ob<So`hS00?o00008P0001X000?o0000;0000olS8`0>8`05
o`000?l042<01Ol0003o010S00?o0000<000:_l=c0g<3L`=c0g<3L`=c0g<3L`=c0g<3L`=c0g<3L`=
c0g<3OoLk=c/o`X51Ol48`Co3R<00ol0000R00006P000ol0000/0003ob<S00hS00Go0000o`0@8`05
o`000?l042<00ol0000`000Tol`=c0g<3L`=c0g<3L`=c0g<3L`=c0g<3L`=c0g<3L`=c0go1M`04?l5
gPGN1Mh5gPGN1Mh5gPD5o`8S00?o8b<02b<00ol0000S00006P02obd000?o8b<03R<01Ol0003o010S
00Go0000o`0@8`03o`00030002_o3L`=c0g<3L`=c0g<3L`=c0g<3L`=c0g<3L`=c0g<3L`=omc/g>cL
k=co01451ol;8`03o`0002<0000J0003o`0002`000?o8b<03R<01Ol0003o010S00Go0000o`0@8`03
o`00030002;oc0g<3L`=c0g<3L`=c0g<3L`=c0g<3L`=c0g<3L`=c0go2M`06?l5gPGN1Mh5gPGN1Mh5
gPGN1Mh5gPGN1@Go1R<00ol0000S00006P000ol0000/0003ob<S00hS00Go0000o`0@8`05o`000?l0
42<00ol0000`000/o`g<3L`=c0g<3L`=c0g<3L`=c0g<3L`=c0g<3L`=c0gog>cLk=c/g>cLk?lL1@Go
00<So`00900001X00_l]0003ob<S00hS00Go0000o`0@8`05o`000?l042<00ol0000`000Pol`=c0g<
3L`=c0g<3L`=c0g<3L`=c0g<3L`=c0g<3Ol<g00Qomh5gPGN1Mh5gPGN1Mh5gPGN1Mh5gPGN1Mh5gPGN
1Mh500;o9@0001D00_l30003o`0002`000?o8b<03R<01Ol0003o010S00Go0000o`0@8`03o`000340
02goc0g<3L`=c0g<3L`=c0g<3L`=c0g<3L`=c0g<3OoLk=c/g>cLk=c/g>cLk?l080D00ol0000S0000
50001?l00?l20003o`0002`000?o8b<03R<01Ol0003o010S00Go0000o`0@8`03o`00034001go3L`=
c0g<3L`=c0g<3L`=c0g<3L`=c0g<3L`=o`0?g00Qo`GN1Mh5gPGN1Mh5gPGN1Mh5gPGN1Mh5gPGN1Mh5
gPGo02H0000D0004o`00o`800_l]0003ob<S00hS00Go0000o`0@8`05o`000?l042<00ol0000a000^
ol`=c0g<3L`=c0g<3L`=c0g<3L`=c0g<3L`=omc/g>cLk=c/g>cLk=c/g>cLo`H50_l21@;o0PD4o``5
00?o0000900001@00ol30003o`0002`000?o8b<03R<01Ol0003o010S00Go0000o`0@8`03o`000340
01_o3L`=c0g<3L`=c0g<3L`=c0g<3L`=c0g<3Ol04m`07ol5gPGN1MkogPGo1MkogPGN1Mh5gPGN1Mh5
gPGN1Ol09P0001@000?o00000`000ol0000/0003ob<S00hS00Go0000o`0@8`05o`000?l042<00ol0
000b000^o`g<3L`=c0g<3L`=c0g<3L`=c0g<3L`=omc/g>cLk=c/g>cLk=c/g>cLk=c/o`H500Co1@Go
0PD5o`/500?o00009@0001D00ol200;o;@000olS8`0>8`05o`000?l042<01Ol0003o010S00?o0000
<P006?o<3L`=c0g<3L`=c0g<3L`=c0g<3L`=oaKL00KogPGN1Mh4o`0C1MkogPGNomh5gPGN1Mh5gPGN
o`0W00006P000ol0000/0003ob<S00hS00Go0000o`0@8`05o`000?l042<00ol0000c000_ol`=c0g<
3L`=c0g<3L`=c0g<3L`=omc/g>cLk=c/g>cLk=c/g>cLk=c/g>cLk?l010D01?l51Ol31@?o30D00ol0
000U00006P000ol0000/0003ob<S00hS00Go0000o`0@8`05o`000?l042<00ol0000c000Eo`g<3L`=
c0g<3L`=c0g<3L`=c0go01WL00Co1Mh50_l05]h5oooN1Mh5gPGN1Mh5gPGN1Mh5g_lW00006P02obd0
4_l30003ob<S00hS00Go0000o`0@8`03o`0003@002oo3L`=c0g<3L`=c0g<3L`=c0gog>cLk=c/g>cL
k=c/g>cLk=c/g>cLk=c/g>cLo`0H1@03o`0002H0000J0003o`00044000?o8b<03R<01Ol0003o010S
00?o0000=0004_o<3L`=c0g<3L`=c0g<3L`=oagL01Wo1Mh5gPGN1Mh5gPGN1Mh5gPGN1Mh5gPGo02P0
000J0003o`00044000?o8b<03R<01Ol0003o010S00?o0000=@00;oo<3L`=c0g<3L`=c0g<3OoLk=c/
g>cLk=c/g>cLk=c/g>cLk=c/g>cLk=c/g>co01H500?o00009`0001X00_m20003ob<S00hS00Go0000
o`0@8`03o`0003D000oo3L`=c0g<3L`=c0g<3Ol08=`05ooN1Mh5gPGN1Mh5gPGN1Mh5gPGN1Mko02T0
000E00;o0`000ol000110003ob<S00hS00Go0000o`0@8`03o`0003H001Wo3L`=c0g<3L`=c0gog>cL
k=c/g>cLk=c/00Go00?/g?l01?l02mc/g>cLk=c/g>co01<500?o0000:00001@000Co003o0P000ol0
00110003ob<S00hS00Go0000o`0@8`03o`0003H000coc0g<3L`=c0g<3Ol>g004omcLo`CL00?og=`0
2]`05?l5gPGN1Mh5gPGN1Mh5gPGN1Mko:`0001@000Co003o0P02od8000?o8b<03R<01Ol0003o010S
00?o0000=`00<?o<3L`=c0g<3OoLk=c/g>cLk=c/g>cLk=cog>cok=c/g?oLk=c/g>cLk=c/g>cLoa45
00?o0000:@0001D00_l30003o`00044000?o8b<03R<01Ol0003o010S00?o0000>0002?o<3L`=c0go
4=`00ooLg005g003omcL00cL00oo1Mh5gPGN1Mh5gPGN1Mh00_l/000050001?l00?l20003o`000440
00?o8b<03R<01Ol0003o010S00?o0000>@007_o<3L`=omc/g>cLk=c/g>cLk=c/g>cLomc/g>cLk0;o
00oLk=c/g>cLk=c/g>cLk?l03@D00ol0000/00005@02o`<00_m20003ob<S00hS00Go0000o`0@8`03
o`0003X000Coc0go4M`3oaKL00kogPGN1Mh5gPGN1Mh5obh0000J0003o`00044000?o8b<03R<01Ol0
003o010S00?o0000>P00<?l=omc/g>cLk=c/g>cLk=c/g>cLk=c/g>cLk=c/g?oLk=c/g>cLk=c/g>cL
k=c/o`X500?o0000;@0001X000?o0000@@000olS8`0>8`05o`000?l042<00ol0000k00;o;=`02ol5
gPGN1Mh5gPGo0300000J00;o@P0Bo`<000?o8b<03R<00ol0000m000^oncLk=c/g>cLk=c/g>cLk=c/
g>cLk=c/g>cLk=c/g>cLk=c/g>cLk=c/g>cLo`L500?o0000;`0001X000?o0000EP000olS8`0>8`03
o`0003h000?og=`0:]`01ol5gPGN1Ol0<P0001X000?o0000EP000olS8`0>8`03o`0003l002gok=c/
g>cLk=c/g>cLk=c/g>cLk=c/g>cLk=c/g>cLk=c/g>cLk=c/g>cLk?l00`D2oc<0000J00;oE`000olS
8`0>8`03o`0004000_lZg003omko03D0000>00?o1002o`<000?o0000EP000olS8`0>8`03o`000480
02[og>cLk=c/g>cLk=c/g>cLk=c/g>cLk=c/g>cLk=c/g>cLk=c/g>cLk=`2ocH0000?0003o`000080
00Co003o0P000ol0001F0003ob<S00hS00?o0000@`02obKL00?o0000=P0000l000?o00000P001?l0
0?l200;oE`000olS8`0>8`03o`0004D002Cok=c/g>cLk=c/g>cLk=c/g>cLk=c/g>cLk=c/g>cLk=c/
g>`2ocT0000?0003o`00008000Co003o0P000ol0001F0003ob<S00hS00?o0000AP03oagL0olk0000
3`000ol000020004o`00o`8000?o0000EP000olS8`0>8`03o`0004T00ol05ncLk=c/g>cLk=c/g>cL
k=c/g>cLk=c/00?o?P0000h00_l500;o0`02oeL000?o8b<03R<00ol0001<00Co4=`3od40000J0003
o`0005H000?o8b<03R<00ol0001@013oA00001X000?o0000EP0BojH0000J00;oo`0@0000o`0/0000
o`0/0000\
\>"],
  ImageRangeCache->{{{0, 298.062}, {86.9375, 0}} -> {-0.0594483, -0.0147151, 
  0.00710891, 0.00710891}, {{8.3125, 142.312}, {84.8125, 2.0625}} ->
   {-0.875782, -3.08828, 0.0472655, 0.166934}, {{155.688, 289.688}, {84.8125, 
  2.0625}} -> {-5.65135, -1.10394, 0.0253779, 0.0253779}}]
}, Closed]],

Cell[TextData[{
  "The various options to ",
  StyleBox["BarChart", "Input"],
  " and ",
  StyleBox["PieChart", "Input"],
  " provide many ways to customize the appearance of data graphs."
}], "Text"],

Cell[BoxData[
    \(Clear[wts]\)], "Input"],

Cell[TextData[{
  StyleBox["ErrorListPlot", "Input"],
  " allows us to plot data along with error bars. Here are some points along \
a line with some noise added, each with an error bar 0.5 units long in each \
direction."
}], "Text"],

Cell[BoxData[
    \(\(linedata = 
      Table[{x, x + Random[Real, {\(-0.5\), 0.5}], 0.5}, {x, 0.0, 10.0, 
          0.5}]; \)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(ErrorListPlot[linedata, 
      Epilog -> {GrayLevel[0.5], Line[{{0, 0}, {10, 10}}]}]; \)\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.0952381 0.0440612 0.0518572 [
[.21429 .03156 -3 -9 ]
[.21429 .03156 3 0 ]
[.40476 .03156 -3 -9 ]
[.40476 .03156 3 0 ]
[.59524 .03156 -3 -9 ]
[.59524 .03156 3 0 ]
[.78571 .03156 -3 -9 ]
[.78571 .03156 3 0 ]
[.97619 .03156 -6 -9 ]
[.97619 .03156 6 0 ]
[.01131 .14778 -6 -4.5 ]
[.01131 .14778 0 4.5 ]
[.01131 .25149 -6 -4.5 ]
[.01131 .25149 0 4.5 ]
[.01131 .3552 -6 -4.5 ]
[.01131 .3552 0 4.5 ]
[.01131 .45892 -6 -4.5 ]
[.01131 .45892 0 4.5 ]
[.01131 .56263 -12 -4.5 ]
[.01131 .56263 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.21429 .04406 m
.21429 .05031 L
s
[(2)] .21429 .03156 0 1 Mshowa
.40476 .04406 m
.40476 .05031 L
s
[(4)] .40476 .03156 0 1 Mshowa
.59524 .04406 m
.59524 .05031 L
s
[(6)] .59524 .03156 0 1 Mshowa
.78571 .04406 m
.78571 .05031 L
s
[(8)] .78571 .03156 0 1 Mshowa
.97619 .04406 m
.97619 .05031 L
s
[(10)] .97619 .03156 0 1 Mshowa
.125 Mabswid
.07143 .04406 m
.07143 .04781 L
s
.11905 .04406 m
.11905 .04781 L
s
.16667 .04406 m
.16667 .04781 L
s
.2619 .04406 m
.2619 .04781 L
s
.30952 .04406 m
.30952 .04781 L
s
.35714 .04406 m
.35714 .04781 L
s
.45238 .04406 m
.45238 .04781 L
s
.5 .04406 m
.5 .04781 L
s
.54762 .04406 m
.54762 .04781 L
s
.64286 .04406 m
.64286 .04781 L
s
.69048 .04406 m
.69048 .04781 L
s
.7381 .04406 m
.7381 .04781 L
s
.83333 .04406 m
.83333 .04781 L
s
.88095 .04406 m
.88095 .04781 L
s
.92857 .04406 m
.92857 .04781 L
s
.25 Mabswid
0 .04406 m
1 .04406 L
s
.02381 .14778 m
.03006 .14778 L
s
[(2)] .01131 .14778 1 0 Mshowa
.02381 .25149 m
.03006 .25149 L
s
[(4)] .01131 .25149 1 0 Mshowa
.02381 .3552 m
.03006 .3552 L
s
[(6)] .01131 .3552 1 0 Mshowa
.02381 .45892 m
.03006 .45892 L
s
[(8)] .01131 .45892 1 0 Mshowa
.02381 .56263 m
.03006 .56263 L
s
[(10)] .01131 .56263 1 0 Mshowa
.125 Mabswid
.02381 .06999 m
.02756 .06999 L
s
.02381 .09592 m
.02756 .09592 L
s
.02381 .12185 m
.02756 .12185 L
s
.02381 .1737 m
.02756 .1737 L
s
.02381 .19963 m
.02756 .19963 L
s
.02381 .22556 m
.02756 .22556 L
s
.02381 .27742 m
.02756 .27742 L
s
.02381 .30335 m
.02756 .30335 L
s
.02381 .32928 m
.02756 .32928 L
s
.02381 .38113 m
.02756 .38113 L
s
.02381 .40706 m
.02756 .40706 L
s
.02381 .43299 m
.02756 .43299 L
s
.02381 .48485 m
.02756 .48485 L
s
.02381 .51078 m
.02756 .51078 L
s
.02381 .5367 m
.02756 .5367 L
s
.02381 .01813 m
.02756 .01813 L
s
.02381 .58856 m
.02756 .58856 L
s
.02381 .61449 m
.02756 .61449 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.002 w
.02381 .01472 m
.02381 .06657 L
s
.015 w
.02381 .04064 Mdot
.002 w
.07143 .05952 m
.07143 .11137 L
s
.015 w
.07143 .08544 Mdot
.002 w
.11905 .06567 m
.11905 .11753 L
s
.015 w
.11905 .0916 Mdot
.002 w
.16667 .11333 m
.16667 .16519 L
s
.015 w
.16667 .13926 Mdot
.002 w
.21429 .13724 m
.21429 .1891 L
s
.015 w
.21429 .16317 Mdot
.002 w
.2619 .16921 m
.2619 .22107 L
s
.015 w
.2619 .19514 Mdot
.002 w
.30952 .1657 m
.30952 .21756 L
s
.015 w
.30952 .19163 Mdot
.002 w
.35714 .20098 m
.35714 .25284 L
s
.015 w
.35714 .22691 Mdot
.002 w
.40476 .23608 m
.40476 .28794 L
s
.015 w
.40476 .26201 Mdot
.002 w
.45238 .27288 m
.45238 .32474 L
s
.015 w
.45238 .29881 Mdot
.002 w
.5 .26915 m
.5 .321 L
s
.015 w
.5 .29507 Mdot
.002 w
.54762 .30891 m
.54762 .36077 L
s
.015 w
.54762 .33484 Mdot
.002 w
.59524 .31545 m
.59524 .36731 L
s
.015 w
.59524 .34138 Mdot
.002 w
.64286 .35025 m
.64286 .4021 L
s
.015 w
.64286 .37617 Mdot
.002 w
.69048 .35941 m
.69048 .41127 L
s
.015 w
.69048 .38534 Mdot
.002 w
.7381 .40082 m
.7381 .45268 L
s
.015 w
.7381 .42675 Mdot
.002 w
.78571 .42395 m
.78571 .4758 L
s
.015 w
.78571 .44988 Mdot
.002 w
.83333 .45837 m
.83333 .51022 L
s
.015 w
.83333 .4843 Mdot
.002 w
.88095 .46771 m
.88095 .51956 L
s
.015 w
.88095 .49363 Mdot
.002 w
.92857 .5317 m
.92857 .58356 L
s
.015 w
.92857 .55763 Mdot
.002 w
.97619 .55146 m
.97619 .60332 L
s
.015 w
.97619 .57739 Mdot
.5 g
.5 Mabswid
.02381 .04406 m
.97619 .56263 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{299.062, 184.688},
  ImageMargins->{{48, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004[0000^0P10`4000010?ooooooc?ooZ_ooI_oo
<ooo0?o<ooo<c?o<VC/k>gYjN[Vi^OShn03ooeGooj[ooonI<onI0?mVoomVc?mVVOmVI_mV<omV0?lc
oclo?ginO[fm_Oclo5D00:X00?l00?l0VOl0I_l0<ol00<coolcoc<coVLcoIP<30d92@X61PL30`000
EED0EJX0EOl0ELbIolbIc<bIVLbII/bI<lbI0<aVolaVc0L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0Z/`c
<l`c0<`0ol`0c<`0VL`0I/`0<l`000/;2dY:BXV9RLS8b000oeD0ojX0ool0oiW<VIW<IYW<<iW<09VI
oiVIc9VIVIVIIPl?3di>CXf=SLc<c01E05EE0:YE0?mE09TcoiTcc9TcVITcIYTc<iTc09T0oiT0c1<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEEFKo<fKo06K<ofK<c6K<VFK<IVK<<fK<01LG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZVIVVFIVIVIV<fIV06HcofHcc6HcVFHcIQ/K6eYJFYVIVMSHf01EoeEEojYEoomEoc?o
oc?oc3?oVC?oIS?o<c?o03?<oc?<c1lO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ03>I<c>I03=Voc=Vc3=V
VC=VIS=V<c=V02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZEC<0VC<0IS<0<c<0003oo`3oc03oV@3oIRLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2Io`2Ic02IV@2IIP2I<`2I001Vo`1Vc2/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`0c<`0c0000o`00c000V@00IP00<nh002l_;fi^KZf][Nc/k03o05Go0:[o0?oo0140
003^003M002k002Z0028001g001E03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@00M`00E@00A0008P00
4Nk^k]gMgK^k^cLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l0;0000?l0;00000l000?o0000o`0J0000
3`000ol0003o01X0000?0003o`0003801?ld00?o=002ocH00_la00?o1002o`@0000?0003o`0003<0
00?o0000=@000ol0000b0004o`00oc@000Co003o<@000ol000020004o`00o`<0000?0003o`0003@0
00?o0000<P04oc<000Co003o=0001?l00?la0003o`00008000Co003o0`0000l00_lf0003o`000340
00?o0?l0=003ocH00_lb0003o`00008000Co003o0`0000l000?o0000<P001?l00?lc0003o`3o03@0
00?o0000=@001?l00?la0003o`00008000Co003o0`0000l000?o0000<`02ocD00_le00?o=@02oc40
0_l500;o100000l000?o0000o`0J00003`000ol0003o01X0000?0003o`000?l06P0000h00_oo01`0
000=00Coo`0K00002007o`8JoolKo`003P02o`0301XJ00X000?o00002`000ol0000:0003o`0000/0
00?o00002`000ol0000;0003o`0000/000?o00002P000ol0000;0003o`0000/000?o00002`000ol0
000:0003o`0000/000?o00002`000ol0000;0003o`0000/000?o00002P000ol0000;0003o`0000/0
00?o00002`000ol0000500003`001?l000026S4000?o0000=0000ol0000d0003o`0003D000?o0000
=0000ol0000500003`000ol0000300036P000?l0500000l000?o000010026PD000?o0000o`0<0000
3`000ol00006008J0`000ol0003o00`0000?0003o`0000P00QX00`3o000<0003o`000?d0000?00;o
2`026Pd000?o0000o@0000l000?o00002`000olJ6P0;0003o`000?d0000?0003o`0000/000Co000J
2P000ol0003m00003`000ol0000;0004o`00008J20000ol0003m00003`000ol0000:00;o1@026PH0
00?o0000o@0000l000?o00002@04o`H00QX300;oo`0000l000?o00002@04o`P00QX4ooh0000?0003
o`0000X00_l;008J0_on00003`02o``000?o00002P000olJ6P3n00003`000ol0000;0003o`0000/0
00?o01X0o@0000l000?o00002`000ol0000;0003o`00008Jn`0000l000?o00002`000ol0000;0003
o`0000800Q[i00003`000ol0000;0003o`0000/000?o000010026_L0000?0003o`0001T000?o0000
1P026P8000?o0000l00000l000?o00006@000ol00008008J00?o0000l00000l000?o00009P000aX0
003`00003`02obL000?o6QX0l00000l000?o00009P000ol000026^h0000?0003o`0002H000?o0000
0P026^`0000?0003o`0002H00_l5008JjP0000l000?o00009@04o`H00QX30003o`000>80000700Co
10000ol0000U00Co200011X00?oT000020000ol000040003o`0002H00_l:008J00?o0000hP0000T0
00?o00000`03obH000?o00002`026^<0000:0003o`00008000?o00009P000ol0000;0004o`0J6^40
00070004o`00o`@000?o00009P000ol0000;0004o`00008Jg`0000P00_l50003o`0002H000?o0000
2`02o`@00Q[M00003`000ol0000V0003o`0000X01?l500036P000=X0000?0003o`0002H000?o0000
2P04o`H00QXA0003o`000<H0000?0003o`0003@00_l9008J00<0o`0030000ol0003600003`000ol0
000d0003o`0000X00QX=0003o`000<H0000?00;o=@000ol0000;0003oaXJ00/000?o0000aP0000l0
00?o0000=0000ol0000;0003o`00008J2@000ol0003600003`000ol0000d0003o`0000/000?o0000
0P026PL000?o0000aP0000l000?o0000=0000ol0000;0003o`0000@000<J00000`02olP0000?0003
o`0003@000?o00002P02o`L00QX200Coa`0000l000?o0000@004o`P00QX4olL0000?0003o`000400
1?l:008J00?o0000aP0000l00_m200;o3@026P`000?o0000^00000l000?o0000@P000ol0000;0004
o`0J6PX000?o0000^00000l000?o0000@P000ol0000;0005o`0001X02@000ol0002h00003`000ol0
00120003o`0000/000?o00000P026PL000?o0000^00000l000?o0000@P000ol0000;0003o`0000@0
0QX50003o`000;P0000?0003o`00048000?o00002`000ol00006008J0`000ol0002h00003`000ol0
00120003o`0001H00QX00`3o002i00003`000ol0001M008J^P0000l00_mM00?o00<J0000]`0000l0
00?o0000G004o`8J]`0000l000?o0000G@02o`<00QZe00003`000ol0001N0003o`0000<00QX50003
o`000:/0000?0003o`0005h000?o00001@026P<000?o0000Z`0000P00ol40003o`0005h000?o0000
1`026P030?l00:`000090003o`0000<000?o0000GP000ol0000900036_l00:`0000700Co1003oeh0
00?o00002P026Z`000070003o`3o00D000?o0000J`001?l06QZZ00001`000ol0o`050003o`0006/0
0_l2008JZ00000P00_l50003o`0006X01?l3008JYP0000l000?o0000JP04o`D00QZT00003`000ol0
001[00;o20026Q0000?o0000S`0000l000?o0000J`000ol0000900036P3o00d000?o0000S`0000l0
00?o0000J`000ol0000:008J3@000ol0002?00003`02of`000?o00002`000olJ6P0;0003o`0008l0
000?0003o`0006/000?o00002`000ol000026PT000?o0000S`0000l000?o0000J`000ol0000;0003
o`0000800QX70003o`0008l0000?0003o`0006/000?o00002`000ol00004008J1002oi40000?0003
o`0007P00_l800036P0000CoT00000l000?o0000M`04o`P00QX4oi00000?0003o`0007L01?l:008J
00?o0000S`0000l00_mi00;o3@026Y00000?0003o`0007T000?o00002`001?l06QZ>00003`000ol0
001i0003o`0000/000Co00000QX80003o`000840000?0003o`0007T000?o00002`000ol000030003
6P0000D000?o0000P@0000l000?o0000N@000ol0000;0003o`0000@00QX50003o`0000X000?o0000
M00000l000?o0000N@000ol0000;0003o`0000H00QX30003o`0000X000?o0000M00000l000?o0000
N@000ol0000F008J00<0o`002`000ol0001d00003`000ol0002D008J30000ol0001d00003`02oiD0
0_l26PX000?o0000M00000l000?o0000T`04o`0301X000P000?o0000M00000l000?o0000T`04o`80
0QX700;oM@0000l000?o0000U002o`D00QX400CoM00000l000?o0000U@000ol00005008J0P04og@0
000800;o1@000ol0002E0003o`0000L00QX00`3oo`1e00001`001?l00?l40003o`0009D000?o0000
2@026Pd000?o0000IP0000L000Co003o1003oiD000?o00002P000olJ6P0;0003o`0006H0000700?o
1@000ol0002E0003o`0000X000Co000J2P000ol0000;0003o`0005P000070003o`0000D000?o0000
U@000ol0000:0004o`00008J20000ol0000;0003o`0005P0000800?o10000ol0002R0003o`0000<0
0QX60003o`0000/000?o0000F00000l000?o0000XP000ol00005008J10000ol0000;0003o`0005P0
000?0003o`000:`00QX200;o30000ol0001H00003`000ol0002^008J0ol;0003o`0005P0000?0003
o`000:l000Co6_oo2P02oeX0000?00;o/@000olJ6P0900CoF@0000l000?o0000/0000ol000026PL0
1?mI00003`000ol0002`0003o`0000800QX600;oFP0000l000?o0000/0000ol00004008J1@000ol0
001H00003`000ol0002`0003o`0000H00QX30003o`0005P0000?0003o`000;0000?o0000200011X0
0?l=0003o`0004X0000?0003o`000;0000?o00002@026P03o`0000/000?o0000BP0000l00_no008J
30000ol0001:00003`000ol0002n0004o`0J6PX000?o0000BP0000l000?o0000`P026PP000?o0000
BP0000l000?o0000a0026PH000?o0000BP0000l000?o0000aP000aX0000200;oC00000l000?o0000
a`026P030?oo00;o30000ol0000l00003`000ol00039008J0ol<0003o`0003`0000?0003o`000</0
0QX=0003o`0003`0000?00;oc@000olJ6P0;0003o`0003`0000?0003o`000<`000?o00000QX90003
o`0003`0000?0003o`000<`000?o00000P026PL000?o0000?00000l000?o0000c0000ol000040003
6P0000<00_ln00003`000ol0003<0003o`0000D00QX200Co?@0000P00_l50003o`000<`000?o0000
1`026PCo?@0000L000Co003o10000ol0003H008J00?o0000?00000L000Co003o1003omX00QX;0003
o`0002l0000800;o1@000ol0003J0004o`0J6PT000?o0000;`0000L000Co003o10000ol0003J0005
o`0001X020000ol0000_00002002o`D000?o0000fP000ol00002008J1P000ol0000;0003o`000240
000?0003o`000=X000?o000010026P@000?o00002`000ol0000Q00003`000ol0003J0003o`0000H0
0QX20003o`0000/000?o00008@0000l000?o0000i@026P;o30000ol0000Q00003`000ol0003V0004
oaXJo`/000?o00008@0000l00_oW00?o00<J00002@000ol0000Q00003`000ol0003W00;o00<06QX0
2002ob<0000?0003o`000>L000?o00000P026PD01?lR00003`000ol0003W0003o`0000@00QX300Co
8P0000l000?o0000i`000ol00006008J0P02ob<0000?0003o`000>L000?o000020026P030?l00280
000?0003o`000>L000?o00002P000a[o000R00003`02onP000?o00002`026R80000?0003o`000?D0
00Co01XJ800000l000?o0000m@001?l000026Qh0000?0003o`000?D000?o00000`026Q`0000?0003
o`000?d00QXJ00003`000ol0003o008J600000l000?o0000o`0200036P3o01D0000?0003o`000?l0
0`026QD0000?00;oo`050003oaXJ01<0000?0003o`000?l010000ol000026Q40000?0003o`000?l0
10000ol00002008J3`0000l000?o0000o`040003o`0000@00QX=00003`000ol0003o00<00_l80003
6P00008000?o00001@0000040?ooo`@00_l50003o`000?l00P04o`P00QX20003o`0000D000020003
o`00008000Co003o10000ol0003o00801?l:008J00?o00001@00008000?o00000P001?l00?l400?o
o`0300;o3@000aX0000500000P000ol000020004o`00o`@000?o0000o`040003o`0000/000?o0000
1@00008000?o00000P001?l00?l40003o`000?l010000ol0000;0003o`0000D000000`3oo`0500;o
1@000ol0003o00@000?o00002P02o`L0000?0003o`000?l010000ol0000900Co1P0000l000?o0000
o`040003o`0000T01?l600003`000ol0003o00@000?o00002P02o`L0000?0003o`000?l04P000ol0
000500003`02ool04`000ol0000500003`000ol0003o018000?o00001@0000l000?o0000o`0B0003
o`0000D0000?0003o`000?l04P000ol0000500003`000ol0003o018000?o00001@0000l000?o0000
o`0J00003`000ol0003o01X0000?00;oo`0K00003`000ol0003o01X0003o02`0003o02`00000\
\>"],
  ImageRangeCache->{{{0, 298.062}, {183.688, 0}} -> {-0.566783, -1.01201, 
  0.0362905, 0.0666491}}]
}, Closed]],

Cell[BoxData[
    \(Clear[linedata]\)], "Input"],

Cell[TextData[{
  "The package ",
  StyleBox["Graphics`MultipleListPlot`", "Input"],
  " allows us to plot multiple lists of data on the same set of axes."
}], "Text"],

Cell[BoxData[
    \(Needs["\<Graphics`MultipleListPlot`\>"]\)], "Input"],

Cell["Here is a scatter plot two lists of data.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(MultipleListPlot[Log[MeltingPoint[Take[Elements, 10]]/Kelvin], 
      Log[BoilingPoint[Take[Elements, 10]]/Kelvin], PlotJoined -> True]; 
    \)\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.0952381 0.0182305 0.0685356 [
[.21429 .00573 -3 -9 ]
[.21429 .00573 3 0 ]
[.40476 .00573 -3 -9 ]
[.40476 .00573 3 0 ]
[.59524 .00573 -3 -9 ]
[.59524 .00573 3 0 ]
[.78571 .00573 -3 -9 ]
[.78571 .00573 3 0 ]
[.97619 .00573 -6 -9 ]
[.97619 .00573 6 0 ]
[.01131 .1553 -6 -4.5 ]
[.01131 .1553 0 4.5 ]
[.01131 .29237 -6 -4.5 ]
[.01131 .29237 0 4.5 ]
[.01131 .42944 -6 -4.5 ]
[.01131 .42944 0 4.5 ]
[.01131 .56652 -6 -4.5 ]
[.01131 .56652 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.21429 .01823 m
.21429 .02448 L
s
[(2)] .21429 .00573 0 1 Mshowa
.40476 .01823 m
.40476 .02448 L
s
[(4)] .40476 .00573 0 1 Mshowa
.59524 .01823 m
.59524 .02448 L
s
[(6)] .59524 .00573 0 1 Mshowa
.78571 .01823 m
.78571 .02448 L
s
[(8)] .78571 .00573 0 1 Mshowa
.97619 .01823 m
.97619 .02448 L
s
[(10)] .97619 .00573 0 1 Mshowa
.125 Mabswid
.07143 .01823 m
.07143 .02198 L
s
.11905 .01823 m
.11905 .02198 L
s
.16667 .01823 m
.16667 .02198 L
s
.2619 .01823 m
.2619 .02198 L
s
.30952 .01823 m
.30952 .02198 L
s
.35714 .01823 m
.35714 .02198 L
s
.45238 .01823 m
.45238 .02198 L
s
.5 .01823 m
.5 .02198 L
s
.54762 .01823 m
.54762 .02198 L
s
.64286 .01823 m
.64286 .02198 L
s
.69048 .01823 m
.69048 .02198 L
s
.7381 .01823 m
.7381 .02198 L
s
.83333 .01823 m
.83333 .02198 L
s
.88095 .01823 m
.88095 .02198 L
s
.92857 .01823 m
.92857 .02198 L
s
.25 Mabswid
0 .01823 m
1 .01823 L
s
.02381 .1553 m
.03006 .1553 L
s
[(2)] .01131 .1553 1 0 Mshowa
.02381 .29237 m
.03006 .29237 L
s
[(4)] .01131 .29237 1 0 Mshowa
.02381 .42944 m
.03006 .42944 L
s
[(6)] .01131 .42944 1 0 Mshowa
.02381 .56652 m
.03006 .56652 L
s
[(8)] .01131 .56652 1 0 Mshowa
.125 Mabswid
.02381 .0525 m
.02756 .0525 L
s
.02381 .08677 m
.02756 .08677 L
s
.02381 .12103 m
.02756 .12103 L
s
.02381 .18957 m
.02756 .18957 L
s
.02381 .22384 m
.02756 .22384 L
s
.02381 .25811 m
.02756 .25811 L
s
.02381 .32664 m
.02756 .32664 L
s
.02381 .36091 m
.02756 .36091 L
s
.02381 .39518 m
.02756 .39518 L
s
.02381 .46371 m
.02756 .46371 L
s
.02381 .49798 m
.02756 .49798 L
s
.02381 .53225 m
.02756 .53225 L
s
.02381 .60078 m
.02756 .60078 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.001 w
.11905 .19915 m
.21429 .01472 L
.30952 .43749 L
.40476 .52174 L
.5 .55643 L
.59524 .58351 L
.69048 .3025 L
.78571 .29263 L
.88095 .29102 L
.97619 .2374 L
s
.0001 w
.11905 .19915 -1.875 0 Mabsadd m
.11905 .19915 0 2.5 Mabsadd L
.11905 .19915 1.875 0 Mabsadd L
.11905 .19915 0 -2.5 Mabsadd L
.11905 .19915 -1.875 0 Mabsadd L closepath F
.21429 .01472 -1.875 0 Mabsadd m
.21429 .01472 0 2.5 Mabsadd L
.21429 .01472 1.875 0 Mabsadd L
.21429 .01472 0 -2.5 Mabsadd L
.21429 .01472 -1.875 0 Mabsadd L closepath F
.30952 .43749 -1.875 0 Mabsadd m
.30952 .43749 0 2.5 Mabsadd L
.30952 .43749 1.875 0 Mabsadd L
.30952 .43749 0 -2.5 Mabsadd L
.30952 .43749 -1.875 0 Mabsadd L closepath F
.40476 .52174 -1.875 0 Mabsadd m
.40476 .52174 0 2.5 Mabsadd L
.40476 .52174 1.875 0 Mabsadd L
.40476 .52174 0 -2.5 Mabsadd L
.40476 .52174 -1.875 0 Mabsadd L closepath F
.5 .55643 -1.875 0 Mabsadd m
.5 .55643 0 2.5 Mabsadd L
.5 .55643 1.875 0 Mabsadd L
.5 .55643 0 -2.5 Mabsadd L
.5 .55643 -1.875 0 Mabsadd L closepath F
.59524 .58351 -1.875 0 Mabsadd m
.59524 .58351 0 2.5 Mabsadd L
.59524 .58351 1.875 0 Mabsadd L
.59524 .58351 0 -2.5 Mabsadd L
.59524 .58351 -1.875 0 Mabsadd L closepath F
.69048 .3025 -1.875 0 Mabsadd m
.69048 .3025 0 2.5 Mabsadd L
.69048 .3025 1.875 0 Mabsadd L
.69048 .3025 0 -2.5 Mabsadd L
.69048 .3025 -1.875 0 Mabsadd L closepath F
.78571 .29263 -1.875 0 Mabsadd m
.78571 .29263 0 2.5 Mabsadd L
.78571 .29263 1.875 0 Mabsadd L
.78571 .29263 0 -2.5 Mabsadd L
.78571 .29263 -1.875 0 Mabsadd L closepath F
.88095 .29102 -1.875 0 Mabsadd m
.88095 .29102 0 2.5 Mabsadd L
.88095 .29102 1.875 0 Mabsadd L
.88095 .29102 0 -2.5 Mabsadd L
.88095 .29102 -1.875 0 Mabsadd L closepath F
.97619 .2374 -1.875 0 Mabsadd m
.97619 .2374 0 2.5 Mabsadd L
.97619 .2374 1.875 0 Mabsadd L
.97619 .2374 0 -2.5 Mabsadd L
.97619 .2374 -1.875 0 Mabsadd L closepath F
.001 w
[ .5 3 ] 0 Mabsdash
.11905 .2245 m
.21429 .11685 L
.30952 .52472 L
.40476 .57229 L
.5 .58548 L
.59524 .60332 L
.69048 .31629 L
.78571 .32677 L
.88095 .32272 L
.97619 .24437 L
s
.0001 w
[ ] 0 setdash
.11905 .2245 0 2.5 Mabsadd m
.11905 .2245 -0.56518 .7779 Mabsadd L
.11905 .2245 -2.37764 .77254 Mabsadd L
.11905 .2245 -0.91448 -0.29713 Mabsadd L
.11905 .2245 -1.46946 -2.02254 Mabsadd L
.11905 .2245 0 -0.96154 Mabsadd L
.11905 .2245 1.46946 -2.02254 Mabsadd L
.11905 .2245 .91448 -0.29713 Mabsadd L
.11905 .2245 2.37764 .77254 Mabsadd L
.11905 .2245 .56518 .7779 Mabsadd L
.11905 .2245 0 2.5 Mabsadd L closepath F
.21429 .11685 0 2.5 Mabsadd m
.21429 .11685 -0.56518 .7779 Mabsadd L
.21429 .11685 -2.37764 .77254 Mabsadd L
.21429 .11685 -0.91448 -0.29713 Mabsadd L
.21429 .11685 -1.46946 -2.02254 Mabsadd L
.21429 .11685 0 -0.96154 Mabsadd L
.21429 .11685 1.46946 -2.02254 Mabsadd L
.21429 .11685 .91448 -0.29713 Mabsadd L
.21429 .11685 2.37764 .77254 Mabsadd L
.21429 .11685 .56518 .7779 Mabsadd L
.21429 .11685 0 2.5 Mabsadd L closepath F
.30952 .52472 0 2.5 Mabsadd m
.30952 .52472 -0.56518 .7779 Mabsadd L
.30952 .52472 -2.37764 .77254 Mabsadd L
.30952 .52472 -0.91448 -0.29713 Mabsadd L
.30952 .52472 -1.46946 -2.02254 Mabsadd L
.30952 .52472 0 -0.96154 Mabsadd L
.30952 .52472 1.46946 -2.02254 Mabsadd L
.30952 .52472 .91448 -0.29713 Mabsadd L
.30952 .52472 2.37764 .77254 Mabsadd L
.30952 .52472 .56518 .7779 Mabsadd L
.30952 .52472 0 2.5 Mabsadd L closepath F
.40476 .57229 0 2.5 Mabsadd m
.40476 .57229 -0.56518 .7779 Mabsadd L
.40476 .57229 -2.37764 .77254 Mabsadd L
.40476 .57229 -0.91448 -0.29713 Mabsadd L
.40476 .57229 -1.46946 -2.02254 Mabsadd L
.40476 .57229 0 -0.96154 Mabsadd L
.40476 .57229 1.46946 -2.02254 Mabsadd L
.40476 .57229 .91448 -0.29713 Mabsadd L
.40476 .57229 2.37764 .77254 Mabsadd L
.40476 .57229 .56518 .7779 Mabsadd L
.40476 .57229 0 2.5 Mabsadd L closepath F
.5 .58548 0 2.5 Mabsadd m
.5 .58548 -0.56518 .7779 Mabsadd L
.5 .58548 -2.37764 .77254 Mabsadd L
.5 .58548 -0.91448 -0.29713 Mabsadd L
.5 .58548 -1.46946 -2.02254 Mabsadd L
.5 .58548 0 -0.96154 Mabsadd L
.5 .58548 1.46946 -2.02254 Mabsadd L
.5 .58548 .91448 -0.29713 Mabsadd L
.5 .58548 2.37764 .77254 Mabsadd L
.5 .58548 .56518 .7779 Mabsadd L
.5 .58548 0 2.5 Mabsadd L closepath F
.59524 .60332 0 2.5 Mabsadd m
.59524 .60332 -0.56518 .7779 Mabsadd L
.59524 .60332 -2.37764 .77254 Mabsadd L
.59524 .60332 -0.91448 -0.29713 Mabsadd L
.59524 .60332 -1.46946 -2.02254 Mabsadd L
.59524 .60332 0 -0.96154 Mabsadd L
.59524 .60332 1.46946 -2.02254 Mabsadd L
.59524 .60332 .91448 -0.29713 Mabsadd L
.59524 .60332 2.37764 .77254 Mabsadd L
.59524 .60332 .56518 .7779 Mabsadd L
.59524 .60332 0 2.5 Mabsadd L closepath F
.69048 .31629 0 2.5 Mabsadd m
.69048 .31629 -0.56518 .7779 Mabsadd L
.69048 .31629 -2.37764 .77254 Mabsadd L
.69048 .31629 -0.91448 -0.29713 Mabsadd L
.69048 .31629 -1.46946 -2.02254 Mabsadd L
.69048 .31629 0 -0.96154 Mabsadd L
.69048 .31629 1.46946 -2.02254 Mabsadd L
.69048 .31629 .91448 -0.29713 Mabsadd L
.69048 .31629 2.37764 .77254 Mabsadd L
.69048 .31629 .56518 .7779 Mabsadd L
.69048 .31629 0 2.5 Mabsadd L closepath F
.78571 .32677 0 2.5 Mabsadd m
.78571 .32677 -0.56518 .7779 Mabsadd L
.78571 .32677 -2.37764 .77254 Mabsadd L
.78571 .32677 -0.91448 -0.29713 Mabsadd L
.78571 .32677 -1.46946 -2.02254 Mabsadd L
.78571 .32677 0 -0.96154 Mabsadd L
.78571 .32677 1.46946 -2.02254 Mabsadd L
.78571 .32677 .91448 -0.29713 Mabsadd L
.78571 .32677 2.37764 .77254 Mabsadd L
.78571 .32677 .56518 .7779 Mabsadd L
.78571 .32677 0 2.5 Mabsadd L closepath F
.88095 .32272 0 2.5 Mabsadd m
.88095 .32272 -0.56518 .7779 Mabsadd L
.88095 .32272 -2.37764 .77254 Mabsadd L
.88095 .32272 -0.91448 -0.29713 Mabsadd L
.88095 .32272 -1.46946 -2.02254 Mabsadd L
.88095 .32272 0 -0.96154 Mabsadd L
.88095 .32272 1.46946 -2.02254 Mabsadd L
.88095 .32272 .91448 -0.29713 Mabsadd L
.88095 .32272 2.37764 .77254 Mabsadd L
.88095 .32272 .56518 .7779 Mabsadd L
.88095 .32272 0 2.5 Mabsadd L closepath F
.97619 .24437 0 2.5 Mabsadd m
.97619 .24437 -0.56518 .7779 Mabsadd L
.97619 .24437 -2.37764 .77254 Mabsadd L
.97619 .24437 -0.91448 -0.29713 Mabsadd L
.97619 .24437 -1.46946 -2.02254 Mabsadd L
.97619 .24437 0 -0.96154 Mabsadd L
.97619 .24437 1.46946 -2.02254 Mabsadd L
.97619 .24437 .91448 -0.29713 Mabsadd L
.97619 .24437 2.37764 .77254 Mabsadd L
.97619 .24437 .56518 .7779 Mabsadd L
.97619 .24437 0 2.5 Mabsadd L closepath F
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{299.062, 184.688},
  ImageMargins->{{48, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004[0000^0P10`4000010?ooooooc?ooZ_ooI_oo
<ooo0?o<ooo<c?o<VC/k>gYjN[Vi^OShn03ooeGooj[ooonI<onI0?mVoomVc?mVVOmVI_mV<omV0?lc
oclo?ginO[fm_Oclo5D00:X00?l00?l0VOl0I_l0<ol00<coolcoc<coVLcoIP<30d92@X61PL30`000
EED0EJX0EOl0ELbIolbIc<bIVLbII/bI<lbI0<aVolaVc0L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0Z/`c
<l`c0<`0ol`0c<`0VL`0I/`0<l`000/;2dY:BXV9RLS8b000oeD0ojX0ool0oiW<VIW<IYW<<iW<09VI
oiVIc9VIVIVIIPl?3di>CXf=SLc<c01E05EE0:YE0?mE09TcoiTcc9TcVITcIYTc<iTc09T0oiT0c1<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEEFKo<fKo06K<ofK<c6K<VFK<IVK<<fK<01LG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZVIVVFIVIVIV<fIV06HcofHcc6HcVFHcIQ/K6eYJFYVIVMSHf01EoeEEojYEoomEoc?o
oc?oc3?oVC?oIS?o<c?o03?<oc?<c1lO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ03>I<c>I03=Voc=Vc3=V
VC=VIS=V<c=V02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZEC<0VC<0IS<0<c<0003oo`3oc03oV@3oIRLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2Io`2Ic02IV@2IIP2I<`2I001Vo`1Vc2/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`0c<`0c0000o`00c000V@00IP00<nh002l_;fi^KZf][Nc/k03o05Go0:[o0?oo0140
003^003M002k002Z0028001g001E03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@00M`00E@00A0008P00
4Nk^k]gMgK^k^cLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l0;0000?l0;00004801?ld00?o<`02oc@0
0_la00?o1002o`T000130003o`0003D000?o0000<@001?l00?lb0004o`00oc4000?o00000P001?l0
0?l80000A0000ol0000b00Co<P001?l00?lb0004o`00oc4000?o00000P001?l00?l80000A@000ol0
000a0003o`3o03<00old00;o<P000ol000020004o`00o`P000120004o`00oc<000?o0?l0<`000ol0
000c0004o`00oc4000?o00000P001?l00?l800003P000ol0000b00;o=@02oc@00olc00;o<@02o`D0
0_l900003P000ol0003o01/0000>0003o`000?l06`0000h000?o0000<`000ol0003T00003P000ol0
000c00;oi@0000L0oolPo`D0000>0003o`0000/000?o00002P000ol0000;0003o`0000T00ol<0003
o`0000/000?o00002P000ol0000;0003o`0000X000?o00002`000ol0000;0003o`0000X000?o0000
2`000ol0000:0003o`0000/000?o00002P000ol0000;0003o`0000/000?o00002P000ol0000;0003
o`0000X0000>0003o`0003800ole0003o`0003<000?o0000<`000ol0000d0003o`0000X0000>0003
o`00034000Co003oi@0000h000?o0000<@001?l00?oU00003P000ol0000`0005o`000?l0i@0000h0
00?o0000<0000ol000020003o`000>80000>0003o`0002l000?o00000`000ol0003R00003P000ol0
000_0003o`0000<000?o0000hP0000h000?o0000;P000ol000040003o`000>80000>00;o;`000ol0
00040003o`000>80000>0003o`0002d000?o00001P000ol0003Q00003P000ol0000]0003o`0000H0
00?o0000h@0000h000?o0000;0000ol000070003o`000>40000>0003o`0002`000?o00001`000ol0
003Q00003P000ol0000[0003o`0000T000?o0000h00000h000?o0000:`000ol000090003o`000>00
000>0003o`0002X000?o00002P000ol0003P00003P000ol0000Z0003o`0000X000?o0000h00000h0
00?o0000:@000ol0000<0003o`000=l0000>00;o:P000ol0000<0003o`000=l0000>0003o`0002P0
00?o00003@000ol0003O00003P000ol0000X0003o`0000d000?o0000g`0000h000?o00009`000ol0
000>0003o`000=l0000>0003o`0002L000?o00003`000ol0003N00003P000ol0000V0003o`000100
00?o0000gP0000h000?o00009@000ol0000A0003o`000=h0000>0003o`0002D000?o00004@000ol0
003N00003P000ol0000T0003o`0000/000?o0?l01@000ol0003M00003P000ol0000T0003o`0000/0
1?l40003o`000=d0000>00;o90000ol0000<00?o1@000ol0003M00003P000ol0000S0003o`0000d0
00?o000010000ol0003M00003P000ol0000R0003o`0001H000?o0000g00000h000?o00008P000ol0
000:00;o0`02o`D000?o0000g00000h000?o00008@000ol0000G0003o`000=`0000>0003o`000240
00?o00002@000ol0000;0003o`000=`0000>0003o`00020000?o00002P000ol000050003o`0000<0
00?o0000g00000D01?l50003o`00020000?o00004P000ol000040003o`000=/000060003o`0000D0
00?o00007`000ol000090003o`0000h000?o0000f`0000L000?o00001003oal000?o00006P000ol0
003K000020000ol000030003o`0001h000?o00005@000ol000030003o`000=/000050004o`00o`D0
00?o00007P000ol0000700;o4`000ol0003J00001P02o`H000?o00007@000ol0000M0003o`000=X0
000>0003o`0001d000?o00001P000ol0000>0003o`0000<000?o0000fP0000h000?o000070000ol0
00070003o`0000h000?o00000`000ol0003J00003P000ol0000L0003o`0001l000?o0000f@0000h0
00?o00006`000ol000060003o`0001L000?o0000f@0000h000?o00006`000ol0000J0003o`0000<0
00?o0000f@0000h000?o00006P000ol000050003o`0001T000?o0000f@0000h00_lK0003o`0000@0
00?o00006P000ol0003I00003P000ol0000I0003o`0001`000?o000010000ol0003H00003P000ol0
000H00;o1@000ol0000M0003o`000=P0000>0003o`0001L00olU0003o`000=P0000>0003o`0001L0
0olO0003o`0000<000?o0000f00000h000?o000060000ol000020003o`0001T000?o000010000ol0
003G00003P000ol000100003o`000=L0000>0003o`0001/000?o00008P000ol0003G00003P000ol0
000K0003o`0001`000?o00000`000ol0003G00003P000ol0000G0003o`3o02L000?o0000eP0000h0
0_lH00?o9`000ol0003F00003P000ol0000G00Co80000ol000030003o`000=H0000>0003o`0001P0
00?o000080000ol000030003o`000=H0000>0003o`0001P000?o00009P000ol000390003o`0000X0
000>0003o`00048000?o0000a`03o`/0000>0003o`0003`000?o00000`000ol0003500Go2`0000h0
00?o0000@P000ol0003300;o0P02o``0000>0003o`00048000?o0000`P001?l00004o`/0000>0003
o`0003`000?o000010000ol0002o00;o4`0000h000?o0000?0000ol000040003o`000;d00_l40003
o`0000h0000>00;oA0000ol0002k00;o5`0000h000?o0000?@000ol000030003o`000;T00_l50003
o`000140000>0003o`0003d000?o000010000ol0002g0003o`0000D000?o00004@0000h000?o0000
A0000ol0002e00;o1P000ol0000C00003P000ol000140003o`000;<00_l70003o`0001@0000>0003
o`0003h000?o00000`000ol0002a00;o800000h000?o0000A0000ol0002_00;o2002oaP0000>0003
o`0004D000?o0000[@000ol0000R00001P03o`D000?o0000?`000ol000030003o`000:/00_l90003
o`0001T000070003o`0000@000?o0000?`000ol000030003o`0008h000?o00002`0?obL0000500Co
1@03odD000?o0000Q`0Eo``00ol80003o`0001`000050003o`3o00H000?o0000AP000ol0001b0003
o`0000@03Ol600?o6@02obL000050003o`3o00H000?o0000@0000ol000030003o`0007402?lD0003
o`00020000?o00007P0000H00_l60003o`0004H000?o0000L004oc/000?o00007`0000h000?o0000
AP000ol0001a00?oG@0000h000?o0000@0000ol000040003o`0007000oli0003o`000240000>0003
o`00040000?o000010000ol0001`00?oG@0000h000?o0000A`000ol0001_00Go00<0ool00P000ol0
000Z00;o00<0o`009@0000h000?o0000@@000ol000030003o`0006l000?o0?l02P000ol00002o`80
00?o00001@000ol0o`0D00;o0P03obL0000>00;o@P000ol000030003o`0006l00olD00;o0P000ol0
o`02o`8000?o00000_l20003o`0000;o0P000ol0000400Co9P0000h000?o0000B0000ol0001]0003
o`0001X01?lH0003o`0002H0000>0003o`0004P000?o0000K@000ol0000K0003o`000440000>0003
o`00048000?o00000`000ol0001]00;o70000ol0001100003P000ol000180003o`0006`000?o0?l0
H00000h000?o0000B@000ol0001[0003o`000600000>0003o`0004<000?o00000`000ol0001[0003
o`000600000>0003o`0004<000?o00000`000ol0001Z0003o`3o0640000>0003o`0004T000?o0000
JP000ol0001Q00003P000ol0001:0003o`0006T000?o0000H@0000h00_m50003o`0000<000?o0000
J0000ol0o`1R00003P000ol0001:0003o`0006P000?o0000HP0000h000?o0000BP000ol0001X0003
o`000680000>0003o`0004@000?o00000`000ol0001W0003o`3o06<0000>0003o`0004@000?o0000
10000ol0001V0003o`3o06<0000>0003o`0004/000?o0000IP000ol0001S00003P000ol0001;0003
o`0006D000?o0000I00000h000?o0000A@000ol000030003o`0006D000?o0?l0I00000h000?o0000
C0000ol0001T0003o`0006@0000>0003o`0004`000?o0000H`000ol0001U00003P02odL000?o0000
0`000ol0001S0003o`3o06D0000>0003o`0004`000?o0000H`000ol0001U00003P000ol0001=0003
o`00064000?o0000IP0000h000?o0000A`000ol000030003o`00064000?o0?l0IP0000h000?o0000
A`000ol000030003o`00064000?o0?l0IP0000h000?o0000C@000ol0001P0003o`0006L0000>0003
o`0004d000?o0000H0000ol0001W00003P000ol000180003o`0000<000?o0000G`03ofL0000600;o
1P000ol0001>0003o`0005h000?o0000J00000D000Co003o1@000ol0001>0003o`0005h000?o0000
J00000D000Co003o1@03odP000?o00000`000ol0001N00;oJ@0000D00ol60003o`0004P000?o0000
10000ol0001L0003o`0006T000050003o`0000H000?o0000CP03oed000?o0000J@0000H00ol50003
o`0004h00_l00`3o001K00;oJP0000h000?o0000B@000ol000030004o`00oeX000?o0?l0JP0000h0
00?o0000D`000ol0001G0003o`0006X0000>0003o`0005@000?o0000EP000ol0001Z00003P000ol0
001:0003o`0000P000?o0000E0000ol0o`1[00003P000ol0001F0003o`0005<000?o0000J`0000h0
0_mH0003o`00058000?o0000J`0000h000?o0000B`000ol0000:00;oD@000ol0o`1/00003P000ol0
001;0003o`0000`000?o0000CP000ol0001/00003P000ol0001K0003o`0004d000?o0000K00000h0
00?o0000G0000ol0001;0003o`3o06d0000>0003o`0004/00_l@0003o`0004X000?o0?l0K@0000h0
00?o0000GP000ol000190003o`0006d0000>0003o`0005l000?o0000A`000ol0001^00003P000ol0
001<0003o`00014000?o0000AP000ol0o`1^00003P000ol0001<0003o`0001800_m60003o`0006h0
000>00;oI0000ol000120003o`0006l0000>0003o`0006@000?o0000@@000ol0o`1_00003P000ol0
001=0003o`0001D000?o0000@0000ol0001_00003P000ol0001V0003o`0003h000?o0000L00000h0
00?o0000I`000ol0000m0003o`3o0700000>0003o`0004h000?o00005`000ol0000l0003o`3o0700
000>0003o`0006T00_lk0003o`000740000>0003o`0004d00_lJ00?o>P000ol0o`1a00003P000ol0
001>00;o6007ocL00_mb00003P000ol0001=00Co6003o`<00olc0003o`000780000>00;oD`02oaH0
00?o00001@02oc4000?o0000LP0000h000?o0000E@000ol0000L00?o;P03og80000>0003o`0005H0
00?o00007P03obX000?o0000L`0000h000?o0000F002ob000olW0003o`0007<0000>0003o`0005`0
00?o00007P02obD00_md00003P000ol0001L0003o`0002000olQ0003o`3o07@0000>0003o`0005l0
00?o00008004oad000?o0000M00000h000?o0000Q004oa/00_me00001P02o`H000?o0000HP000ol0
000O00?o00@0oooo5`000ol0o`1e00001@001?l00?l50003o`0006D000?o00007@000ol0000300?o
50000ol0001e00001@001?l00?l500?oJ002ob@01?l@0003o`0007D0000600;o1P000ol0001X00?o
9`03o``000?o0?l0MP0000D000Co003o1@000ol0001X00Go0P000ol0000S00Co20000ol0001f0000
1P02o`H000?o0000J@000ol0000600;o0P000ol0000P00?o1@000ol0001f00003P000ol0001i00;o
0P000ol0000300;o5`03o`040?l0ogL0000>0003o`0008000_l200;o6@04ogL0000>0003o`0008@0
1Ol20003o`0001400omh00003P000ol000240003o`0000L000?o00003`02ogP0000>0003o`000940
0_l20003o`0000T000?o0000MP0000h000?o0000V002o`8000Ko003o0?mh00003P02oid000?o0000
0omh00003P000ol0002O00?oN00000h000?o0000X0000ol0001g00003P000ol0002P0003o`0007L0
000>0003o`000?l06`000001\
\>"],
  ImageRangeCache->{{{0, 298.062}, {183.688, 0}} -> {-0.535994, -0.642731, 
  0.0368041, 0.0511435}}]
}, Closed]],

Cell[TextData[{
  "By changing the options to ",
  StyleBox["MultipleListPlot", "Input"],
  ", we can change the symbol used to plot each data set, include error bars \
or ellipses, and much more."
}], "Text"],

Cell[TextData[{
  "See also ",
  StyleBox["Graphics`Graphics3D`", "Input"],
  ", ",
  StyleBox["DiscreteMath`ComputationalGeometry`", "Input"],
  " "
}], "SeeAlso"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Strings", "Subsection",
  CellTags->"Strings"],

Cell[TextData[{
  "In many cases it is convenient to keep data in the form of a string, and \
to manipulate the string directly. ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " contains many string manipulation functions that mirror list manipulation \
commands."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Reverse[{b, a, c, k, w, a, r, d, s}]\)], "Input"],

Cell[BoxData[
    \({s, d, r, a, w, k, c, a, b}\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(StringReverse["\<backwards\>"]\)], "Input"],

Cell[BoxData[
    \("sdrawkcab"\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Join[{a, b, c}, {x, y, z}]\)], "Input"],

Cell[BoxData[
    \({a, b, c, x, y, z}\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(StringJoin["\<abc\>", "\<xyz\>"]\)], "Input"],

Cell[BoxData[
    \("abcxyz"\)], "Output"]
}, Closed]],

Cell[TextData[{
  "The file ",
  StyleBox["register.dat", "Output"],
  " contains the following data."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(!! register.dat\)\)], "Input"],

Cell["\<\
123456789012345678901234
Alabama 2785103100413816
Alaska  0306017700110483
Arizona 2039083900782878
Arkansas0940051700141457\
\>", "Print"]
}, Closed]],

Cell["\<\
The first eight columns of each line contain the name of a state, \
the ninth through twelfth columns contain the number of automobiles \
registered (in thousands), the thirteen through sixteenth columns contain the \
number of thousands of trucks and buses registered, the seventeenth through \
twentieth columns contain the number of thousands of motorcycles registered, \
and the remaining columns contain the total for each state. (The first line \
of data is used to number the columns.)\
\>", "Text"],

Cell["\<\
Here we read in each line as a string, discarding the first line of \
data.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(register = Rest[ReadList["\<register.dat\>", String]]\)], "Input"],

Cell[BoxData[
    \({"Alabama 2785103100413816", "Alaska  0306017700110483", 
      "Arizona 2039083900782878", "Arkansas0940051700141457"}\)], "Output"]
}, Closed]],

Cell["\<\
The following function dissects each string into its respective \
list of data.\
\>", "Text"],

Cell[BoxData[
    \(dissect[\[ScriptCapitalS]_String] := {StringTake[\[ScriptCapitalS], 8], 
        StringTake[\[ScriptCapitalS], {9, 12}], 
        StringTake[\[ScriptCapitalS], {13, 16}], 
        StringTake[\[ScriptCapitalS], {17, 20}], 
        StringTake[\[ScriptCapitalS], {21, 24}]}\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Map[dissect, register] // TableForm\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {\("Alabama "\), \("2785"\), \("1031"\), \("0041"\), \("3816"\)},
          {\("Alaska  "\), \("0306"\), \("0177"\), \("0011"\), \("0483"\)},
          {\("Arizona "\), \("2039"\), \("0839"\), \("0078"\), \("2878"\)},
          {\("Arkansas"\), \("0940"\), \("0517"\), \("0014"\), \("1457"\)}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Closed]],

Cell[TextData[{
  "As defined above, ",
  StyleBox["dissect", "Input"],
  " leaves the numbers in each measurement in the form of a string. The \
following addition to the definition of ",
  StyleBox["dissect", "Input"],
  " changes the numerical strings into numbers."
}], "Text"],

Cell[BoxData[
    \(dissect[\[ScriptCapitalS]_String] := 
      Flatten[{StringTake[\[ScriptCapitalS], 8], 
          ToExpression[{StringTake[\[ScriptCapitalS], {9, 12}], 
              StringTake[\[ScriptCapitalS], {13, 16}], 
              StringTake[\[ScriptCapitalS], {17, 20}], 
              StringTake[\[ScriptCapitalS], {21, 24}]}]}]\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Map[dissect, register] // TableForm\)], "Input"],

Cell[BoxData[
    TagBox[GridBox[{
          {\("Alabama "\), "2785", "1031", "41", "3816"},
          {\("Alaska  "\), "306", "177", "11", "483"},
          {\("Arizona "\), "2039", "839", "78", "2878"},
          {\("Arkansas"\), "940", "517", "14", "1457"}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      (TableForm[ #]&)]], "Output"]
}, Closed]],

Cell[TextData[{
  "Just as parts of lists and expressions can be replaced using ",
  StyleBox["ReplaceAll",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " (",
  StyleBox["/.",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  "), parts of strings can be replaced using ",
  StyleBox["StringReplace",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  ". In the following string we replace every occurrence of the word \
\[OpenCurlyDoubleQuote]Sin\[CloseCurlyDoubleQuote] with \
\[OpenCurlyDoubleQuote]sin\[CloseCurlyDoubleQuote] and replace every square \
bracket with a matching parenthesis."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(StringReplace[
      "\<Sin[Sin[x]]\>", {"\<Sin\>" \[Rule] "\<sin\>", 
        "\<[\>" \[Rule] "\<(\>", "\<]\>" \[Rule] "\<)\>"}]\)], "Input"],

Cell[BoxData[
    \("sin(sin(x))"\)], "Output"]
}, Closed]],

Cell[TextData[{
  "See also ",
  StyleBox["StringMatchQ", "Input"],
  ", ",
  StyleBox["Characters", "Input"],
  ", ",
  StyleBox["CharacterRange", "Input"],
  ", ",
  StyleBox["ToString", "Input"],
  ", ",
  StyleBox["StringForm", "Input"],
  ", ",
  StyleBox["SyntaxQ", "Input"],
  ", ",
  StyleBox["Names", "Input"],
  ", ",
  StyleBox["NameQ", "Input"],
  ", ",
  StyleBox["InputString", "Input"],
  ", ",
  StyleBox["ToLowerCase", "Input"],
  ", ",
  StyleBox["IgnoreCase", "Input"],
  ", ",
  StyleBox["ShowStringCharacters", "Input"],
  " "
}], "SeeAlso"]
}, Closed]],

Cell[CellGroupData[{

Cell["Exercises: Strings", "Subsection"],

Cell[TextData[{
  "How many characters are in the word ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "?"
}], "Question"],

Cell[TextData[{
  StyleBox["StringLength", "Input"],
  " returns the number of characters in a string."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(StringLength["\<Mathematica\>"]\)], "Input"],

Cell[BoxData[
    \(11\)], "Output"]
}, Closed]],

Cell[TextData[{
  "Using ",
  StyleBox["Characters", "Input"],
  " and ",
  StyleBox["Permutations", "Input"],
  ", find all anagrams (rearrangements of letters) of the word ",
  StyleBox["math",
    FontSlant->"Italic"],
  "."
}], "Question"],

Cell[TextData[
"Here are the characters in the string \[OpenCurlyDoubleQuote]math\
\[CloseCurlyDoubleQuote]."], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Characters["\<math\>"]\)], "Input"],

Cell[BoxData[
    \({"m", "a", "t", "h"}\)], "Output"]
}, Closed]],

Cell[TextData[{
  StyleBox["Permutations", "Input"],
  " returns all possible permutations of the elements in a list."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(anagrams = Permutations[Characters["\<math\>"]]\)], "Input"],

Cell[BoxData[
    \({{"m", "a", "t", "h"}, {"m", "a", "h", "t"}, {"m", "t", "a", "h"}, {
        "m", "t", "h", "a"}, {"m", "h", "a", "t"}, {"m", "h", "t", "a"}, {
        "a", "m", "t", "h"}, {"a", "m", "h", "t"}, {"a", "t", "m", "h"}, {
        "a", "t", "h", "m"}, {"a", "h", "m", "t"}, {"a", "h", "t", "m"}, {
        "t", "m", "a", "h"}, {"t", "m", "h", "a"}, {"t", "a", "m", "h"}, {
        "t", "a", "h", "m"}, {"t", "h", "m", "a"}, {"t", "h", "a", "m"}, {
        "h", "m", "a", "t"}, {"h", "m", "t", "a"}, {"h", "a", "m", "t"}, {
        "h", "a", "t", "m"}, {"h", "t", "m", "a"}, {"h", "t", "a", "m"}}\)], 
  "Output"]
}, Closed]],

Cell["There are 24 (4!) permutations.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Length[%]\)], "Input"],

Cell[BoxData[
    \(24\)], "Output"]
}, Closed]],

Cell[TextData[{
  "To combine each list of characters into a string, we use ",
  StyleBox["StringJoin", "Input"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Table[StringJoin[anagrams[\([i]\)]], {i, 24}]\)], "Input"],

Cell[BoxData[
    \({"math", "maht", "mtah", "mtha", "mhat", "mhta", "amth", "amht", 
      "atmh", "athm", "ahmt", "ahtm", "tmah", "tmha", "tamh", "tahm", "thma", 
      "tham", "hmat", "hmta", "hamt", "hatm", "htma", "htam"}\)], "Output"]
}, Closed]],

Cell[TextData[{
  "Alternatively, we can use the high-level programming function ",
  StyleBox["Map", "Input"],
  " to map ",
  StyleBox["StringJoin", "Input"],
  " over each list of characters."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Map[StringJoin, anagrams]\)], "Input"],

Cell[BoxData[
    \({"math", "maht", "mtah", "mtha", "mhat", "mhta", "amth", "amht", 
      "atmh", "athm", "ahmt", "ahtm", "tmah", "tmha", "tamh", "tahm", "thma", 
      "tham", "hmat", "hmta", "hamt", "hatm", "htma", "htam"}\)], "Output"]
}, Closed]],

Cell[" ", "EndExercises"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["3. Curve Fitting and Interpolation", "Section",
  Evaluatable->False,
  AspectRatioFixed->True,
  CellTags->"Modeling and Analysis"],

Cell[CellGroupData[{

Cell["Linear Regression", "Subsection",
  CellTags->"Linear Regression"],

Cell[CellGroupData[{

Cell["Fit", "Subsubsection"],

Cell[TextData[{
  "The ",
  StyleBox["Fit",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " command creates a best-fitting function, using a given list of basis \
functions, for a set of points. Here is a list of ordered pairs."
}], "Text"],

Cell[BoxData[
    \(\(data\  = \ {{1, 4}, {2, 3}, {4, 3}, {7, 6}, {10, 11}}; \)\)], "Input"],

Cell["Here is a plot of the data.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(dataplot = 
      ListPlot[data, PlotStyle \[Rule] {PointSize[0.03], GrayLevel[0.5]}]; 
    \)\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0820106 0.10582 -0.206011 0.0735755 [
[.34127 .07579 -3 -9 ]
[.34127 .07579 3 0 ]
[.55291 .07579 -3 -9 ]
[.55291 .07579 3 0 ]
[.76455 .07579 -3 -9 ]
[.76455 .07579 3 0 ]
[.97619 .07579 -6 -9 ]
[.97619 .07579 6 0 ]
[.11713 .23544 -6 -4.5 ]
[.11713 .23544 0 4.5 ]
[.11713 .38259 -6 -4.5 ]
[.11713 .38259 0 4.5 ]
[.11713 .52974 -12 -4.5 ]
[.11713 .52974 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.34127 .08829 m
.34127 .09454 L
s
[(4)] .34127 .07579 0 1 Mshowa
.55291 .08829 m
.55291 .09454 L
s
[(6)] .55291 .07579 0 1 Mshowa
.76455 .08829 m
.76455 .09454 L
s
[(8)] .76455 .07579 0 1 Mshowa
.97619 .08829 m
.97619 .09454 L
s
[(10)] .97619 .07579 0 1 Mshowa
.125 Mabswid
.18254 .08829 m
.18254 .09204 L
s
.23545 .08829 m
.23545 .09204 L
s
.28836 .08829 m
.28836 .09204 L
s
.39418 .08829 m
.39418 .09204 L
s
.44709 .08829 m
.44709 .09204 L
s
.5 .08829 m
.5 .09204 L
s
.60582 .08829 m
.60582 .09204 L
s
.65873 .08829 m
.65873 .09204 L
s
.71164 .08829 m
.71164 .09204 L
s
.81746 .08829 m
.81746 .09204 L
s
.87037 .08829 m
.87037 .09204 L
s
.92328 .08829 m
.92328 .09204 L
s
.07672 .08829 m
.07672 .09204 L
s
.02381 .08829 m
.02381 .09204 L
s
.25 Mabswid
0 .08829 m
1 .08829 L
s
.12963 .23544 m
.13588 .23544 L
s
[(6)] .11713 .23544 1 0 Mshowa
.12963 .38259 m
.13588 .38259 L
s
[(8)] .11713 .38259 1 0 Mshowa
.12963 .52974 m
.13588 .52974 L
s
[(10)] .11713 .52974 1 0 Mshowa
.125 Mabswid
.12963 .12508 m
.13338 .12508 L
s
.12963 .16187 m
.13338 .16187 L
s
.12963 .19865 m
.13338 .19865 L
s
.12963 .27223 m
.13338 .27223 L
s
.12963 .30902 m
.13338 .30902 L
s
.12963 .3458 m
.13338 .3458 L
s
.12963 .41938 m
.13338 .41938 L
s
.12963 .45617 m
.13338 .45617 L
s
.12963 .49296 m
.13338 .49296 L
s
.12963 .0515 m
.13338 .0515 L
s
.12963 .01472 m
.13338 .01472 L
s
.12963 .56653 m
.13338 .56653 L
s
.12963 .60332 m
.13338 .60332 L
s
.25 Mabswid
.12963 0 m
.12963 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 g
.03 w
.02381 .08829 Mdot
.12963 .01472 Mdot
.34127 .01472 Mdot
.65873 .23544 Mdot
.97619 .60332 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{299.062, 184.75},
  ImageMargins->{{48, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004[0000^0P10`4000010?ooooooc?ooZ_ooI_oo
<ooo0?o<ooo<c?o<VC/k>gYjN[Vi^OShn03ooeGooj[ooonI<onI0?mVoomVc?mVVOmVI_mV<omV0?lc
oclo?ginO[fm_Oclo5D00:X00?l00?l0VOl0I_l0<ol00<coolcoc<coVLcoIP<30d92@X61PL30`000
EED0EJX0EOl0ELbIolbIc<bIVLbII/bI<lbI0<aVolaVc0L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0Z/`c
<l`c0<`0ol`0c<`0VL`0I/`0<l`000/;2dY:BXV9RLS8b000oeD0ojX0ool0oiW<VIW<IYW<<iW<09VI
oiVIc9VIVIVIIPl?3di>CXf=SLc<c01E05EE0:YE0?mE09TcoiTcc9TcVITcIYTc<iTc09T0oiT0c1<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEEFKo<fKo06K<ofK<c6K<VFK<IVK<<fK<01LG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZVIVVFIVIVIV<fIV06HcofHcc6HcVFHcIQ/K6eYJFYVIVMSHf01EoeEEojYEoomEoc?o
oc?oc3?oVC?oIS?o<c?o03?<oc?<c1lO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ03>I<c>I03=Voc=Vc3=V
VC=VIS=V<c=V02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZEC<0VC<0IS<0<c<0003oo`3oc03oV@3oIRLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2Io`2Ic02IV@2IIP2I<`2I001Vo`1Vc2/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`0c<`0c0000o`00c000V@00IP00<nh002l_;fi^KZf][Nc/k03o05Go0:[o0?oo0140
003^003M002k002Z0028001g001E03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@00M`00E@00A0008P00
4Nk^k]gMgK^k^cLg=gIfM[Fe]OCdm03oZUGoZZ[oZP0002H000?o0000o`03000090046S/011[40000
8`066ST01Q[300008P086SL021[200008P086SL021[200008P086SL021[200008P086SL021[20000
8`066ST01Q[3000090046S/011[400009P000ol0003o00<0000V0003o`000?l00`0002H000?o0000
o`0300009P000ol0003o00<0000V0003o`000?l00`0002H000?o0000o`0300009P03oc/00oll00;o
?@02ocT00ol400;o1@0002H000?o0000?0000ol0000j0004o`00oc/000Co003o>@000ol000020004
o`00o`@0000V0003o`0003X01?lk0004o`00oc/000Co003o>@000ol000020004o`00o`@0000V0003
o`0003X000?o0?l0?003ocd00_lj0003o`00008000Co003o100002H000?o0000>P000ol0o`0l0003
o`0003`000Co003o>@000ol000020004o`00o`@0000V0003o`0003/00_lm00?o?002ocT00_l500;o
1@0002H000?o0000o`0300009P000ol0003o00<0000500@J7@000ol0003o00<0000400HJ70000ol0
003o00<0000300PJ6`000ol0003o00<00003o`PJoolPo`40000300PJ30000ol0000<0003o`0000d0
00?o00003@000ol0000=0003o`0000`000?o00003@000ol0000=0003o`0000d000?o000030000ol0
000=0003o`0000d000?o000030000ol0000=0003o`0000d000?o00003@000ol0000<0003o`0000d0
00?o00001P0000<021XK0003o`0003`000?o0000?0000ol0000l0003o`0003`000?o00001P0000@0
1QXL0003o`000?l00`0000D011XM0003o`000?l00`0002H000?o0000o`0300009P000ol0003o00<0
000V0003o`000?l00`0002H000?o0000o`0300009P000ol0003o00<0000V0003o`000?l00`0002H0
0ooo00<0000V0003o`000?l00`0002H000?o0000o`0300009P000ol0003o00<0000V0003o`000?l0
0`0002H000?o0000o`0300009P000ol0003o00<0000V0003o`000?l00`0002H000?o0000o`030000
9P000ol0003o00<0000V0003o`000?l00`0002H00ooo00<0000V0003o`000?l00`0002H000?o0000
o`0300009P000ol0003o00<0000V0003o`000?l00`0002H000?o0000o`0300009P000ol0003o00<0
000V0003o`000?l00`0002H000?o0000o`0300009P000ol0003o00<0000V0003o`000?l00`0002H0
0ooo00<0000V0003o`000?l00`0002H000?o0000o`0300009P000ol0003o00<0000V0003o`000?l0
0`0002H000?o0000o`0300009P000ol0003o00<0000V0003o`000?l00`0002H000?o0000V@046VD0
000O00;o1@000ol0002H00HJI00001h000Co003o10000ol0002G00PJH`0001h000Co003o1003oiL0
21YS00007P03o`D000?o0000U`086V<0000N0003o`0000D000?o0000U`086V<0000O00?o10000ol0
002H00HJI00002H000?o0000V@046VD0000V0003o`000?l00`0002H000?o0000o`0300009P000ol0
003o00<0000V0003o`000?l00`0002H000?o0000o`0300009P000ol0003o00<0000V00?oo`030000
9P000ol0003o00<0000V0003o`000?l00`0002H000?o0000o`0300009P000ol0003o00<0000V0003
o`000?l00`0002H000?o0000o`0300009P000ol0003o00<0000V0003o`000?l00`0002H000?o0000
o`0300009P000ol0003o00<0000V00?oo`0300009P000ol0003o00<0000V0003o`000?l00`0002H0
00?o0000o`0300009P000ol0003o00<0000V0003o`000?l00`0002H000?o0000o`0300009P000ol0
003o00<0000V0003o`000?l00`0002H000?o0000o`0300009P000ol0003o00<0000V00?oo`030000
9P000ol0003o00<0000V0003o`000?l00`0002H000?o0000o`0300009P000ol0003o00<0000V0003
o`000?l00`0002H000?o0000o`0300009P000ol0003o00<0000O00;o1@000ol0003o00<0000N0004
o`00o`@000?o0000o`0300007P001?l00?l400?oo`0300007`02o`D000?o0000o`0300007P001?l0
0?l40003o`000?l00`0001l00_l50003o`000?l00`0002H000?o0000o`0300009P000ol0003o00<0
000V0003o`000?l00`0002H000?o0000o`0300009P000ol0003o00<0000V0003o`000?l00`0002H0
00?o0000o`0300009P03ool00`0002H000?o0000o`0300009P000ol0003o00<0000V0003o`000?l0
0`0002H000?o0000o`0300009P000ol0003o00<0000V0003o`000?l00`0002H000?o0000o`030000
9P000ol0003o00<0000V0003o`000?l00`0002H000?o0000o`0300009P03ool00`0002H000?o0000
o`0300009P000ol0003o00<0000V0003o`000?l00`0002H000?o0000o`0300009P000ol0003o00<0
000V0003o`000?l00`0002H000?o0000o`0300009P000ol0003o00<0000V0003o`000?l00`0002H0
00?o0000o`0300009P03ool00`0002H000?o0000o`0300009P000ol0003o00<0000V0003o`000?l0
0`0002H000?o0000o`0300009P000ol0003o00<0000V0003o`000?l00`0002H000?o0000o`030000
9P000ol0003o00<0000H00?o1002o`D000?o0000o`0300006@000ol000020004o`00o`@000?o0000
o`0300006@000ol000020004o`00o`@00ooo00<0000I0003o`00008000Co003o10000ol0003o00<0
000I0003o`00008000Co003o10000ol0003o00<0000H00;o1@02o`D000?o0000o`0300009P000ol0
003o00<0000V0003o`000?l00`0002H000?o0000o`0300009P000ol0003o00<0000V0003o`000?l0
0`0002H000?o0000o`0300009P000ol0003o00<0000V00?oo`0300009P000ol0003o00<0000V0003
o`000?l00`0002H000?o0000o`0300009P000ol0003o00<0000V0003o`000?l00`0002H000?o0000
o`0300009P000ol0003o00<0000V0003o`000?l00`0002H000?o0000m`046PL0000V0003o`000?H0
1QX600009P03ooD021X500009P000ol0003e00PJ1@0002H000?o0000m@086PD0000V0003o`000?D0
21X500009P000ol0003f00HJ1P000001\
\>"],
  ImageRangeCache->{{{0, 298.062}, {183.75, 0}} -> {0.763085, 2.79995, 
  0.0317848, 0.0457144}}]
}, Closed]],

Cell[TextData[{
  "We can fit a quadratic function of the form ",
  Cell[BoxData[
      \(TraditionalForm\`a + b\ x + c\ x\^2\)]],
  " (that is, find values for the parameters ",
  StyleBox["a",
    FontSlant->"Italic"],
  ", ",
  StyleBox["b",
    FontSlant->"Italic"],
  ", and ",
  StyleBox["c",
    FontSlant->"Italic"],
  " that produce the best-fit curve) to the data set by giving ",
  StyleBox["Fit", "Input"],
  " a list of basis functions to use (",
  StyleBox["{1,", "Input"],
  " ",
  StyleBox["x,", "Input"],
  " ",
  StyleBox["x^2}", "Input"],
  " in this case), and the variable in which to create the polynomial."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(fitcurve = Fit[data, {1, x, x\^2}, x]\)], "Input"],

Cell[BoxData[
    \(\(4.5896398219344352`\[InvisibleSpace]\) - 1.00647511129097289`\ x + 
      0.16592472683124213`\ x\^2\)], "Output"]
}, Closed]],

Cell["Here is a plot of the best-fit curve.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(curveplot = Plot[fitcurve, {x, 1, 10}, PlotStyle \[Rule] Hue[0.05]]; 
    \)\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.0952381 -0.209162 0.0730821 [
[.21429 .07067 -3 -9 ]
[.21429 .07067 3 0 ]
[.40476 .07067 -3 -9 ]
[.40476 .07067 3 0 ]
[.59524 .07067 -3 -9 ]
[.59524 .07067 3 0 ]
[.78571 .07067 -3 -9 ]
[.78571 .07067 3 0 ]
[.97619 .07067 -6 -9 ]
[.97619 .07067 6 0 ]
[.01131 .22933 -6 -4.5 ]
[.01131 .22933 0 4.5 ]
[.01131 .3755 -6 -4.5 ]
[.01131 .3755 0 4.5 ]
[.01131 .52166 -12 -4.5 ]
[.01131 .52166 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.21429 .08317 m
.21429 .08942 L
s
[(2)] .21429 .07067 0 1 Mshowa
.40476 .08317 m
.40476 .08942 L
s
[(4)] .40476 .07067 0 1 Mshowa
.59524 .08317 m
.59524 .08942 L
s
[(6)] .59524 .07067 0 1 Mshowa
.78571 .08317 m
.78571 .08942 L
s
[(8)] .78571 .07067 0 1 Mshowa
.97619 .08317 m
.97619 .08942 L
s
[(10)] .97619 .07067 0 1 Mshowa
.125 Mabswid
.07143 .08317 m
.07143 .08692 L
s
.11905 .08317 m
.11905 .08692 L
s
.16667 .08317 m
.16667 .08692 L
s
.2619 .08317 m
.2619 .08692 L
s
.30952 .08317 m
.30952 .08692 L
s
.35714 .08317 m
.35714 .08692 L
s
.45238 .08317 m
.45238 .08692 L
s
.5 .08317 m
.5 .08692 L
s
.54762 .08317 m
.54762 .08692 L
s
.64286 .08317 m
.64286 .08692 L
s
.69048 .08317 m
.69048 .08692 L
s
.7381 .08317 m
.7381 .08692 L
s
.83333 .08317 m
.83333 .08692 L
s
.88095 .08317 m
.88095 .08692 L
s
.92857 .08317 m
.92857 .08692 L
s
.25 Mabswid
0 .08317 m
1 .08317 L
s
.02381 .22933 m
.03006 .22933 L
s
[(6)] .01131 .22933 1 0 Mshowa
.02381 .3755 m
.03006 .3755 L
s
[(8)] .01131 .3755 1 0 Mshowa
.02381 .52166 m
.03006 .52166 L
s
[(10)] .01131 .52166 1 0 Mshowa
.125 Mabswid
.02381 .11971 m
.02756 .11971 L
s
.02381 .15625 m
.02756 .15625 L
s
.02381 .19279 m
.02756 .19279 L
s
.02381 .26587 m
.02756 .26587 L
s
.02381 .30241 m
.02756 .30241 L
s
.02381 .33895 m
.02756 .33895 L
s
.02381 .41204 m
.02756 .41204 L
s
.02381 .44858 m
.02756 .44858 L
s
.02381 .48512 m
.02756 .48512 L
s
.02381 .04663 m
.02756 .04663 L
s
.02381 .01008 m
.02756 .01008 L
s
.02381 .5582 m
.02756 .5582 L
s
.02381 .59474 m
.02756 .59474 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
1 .3 0 r
.5 Mabswid
.11905 .06483 m
.15382 .04845 L
.19174 .03426 L
.21018 .02876 L
.22736 .02444 L
.24496 .02084 L
.26161 .0182 L
.27042 .0171 L
.27998 .01614 L
.28867 .01548 L
.29287 .01524 L
.2967 .01506 L
.30089 .0149 L
.3032 .01483 L
.3054 .01479 L
.30638 .01477 L
.30742 .01475 L
.30832 .01474 L
.3093 .01473 L
.31045 .01472 L
.31153 .01472 L
.31258 .01472 L
.31355 .01472 L
.31463 .01472 L
.31578 .01473 L
.31687 .01474 L
.31786 .01475 L
.32028 .01479 L
.32258 .01485 L
.32715 .015 L
.33212 .01522 L
.34058 .01576 L
.34991 .01657 L
.35966 .01767 L
.36882 .01893 L
.38698 .0221 L
.40364 .02578 L
.4393 .03616 L
.4736 .04934 L
.5101 .06683 L
.54524 .08704 L
.58259 .11213 L
.61857 .13983 L
.65319 .16975 L
.69002 .20509 L
.72548 .24256 L
.75958 .28175 L
.79589 .3269 L
.83083 .37368 L
.86798 .42699 L
Mistroke
.90376 .48184 L
.93818 .53782 L
.97481 .60088 L
.97619 .60332 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{299.062, 184.75},
  ImageMargins->{{48, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004[0000^0P10`4000010?ooooooc?ooZ_ooI_oo
<ooo0?o<ooo<c?o<VC/k>gYjN[Vi^OShn03ooeGooj[ooonI<onI0?mVoomVc?mVVOmVI_mV<omV0?lc
oclo?ginO[fm_Oclo5D00:X00?l00?l0VOl0I_l0<ol00<coolcoc<coVLcoIP<30d92@X61PL30`000
EED0EJX0EOl0ELbIolbIc<bIVLbII/bI<lbI0<aVolaVc0L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0Z/`c
<l`c0<`0ol`0c<`0VL`0I/`0<l`000/;2dY:BXV9RLS8b000oeD0ojX0ool0oiW<VIW<IYW<<iW<09VI
oiVIc9VIVIVIIPl?3di>CXf=SLc<c01E05EE0:YE0?mE09TcoiTcc9TcVITcIYTc<iTc09T0oiT0c1<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEEFKo<fKo06K<ofK<c6K<VFK<IVK<<fK<01LG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZVIVVFIVIVIV<fIV06HcofHcc6HcVFHcIQ/K6eYJFYVIVMSHf01EoeEEojYEoomEoc?o
oc?oc3?oVC?oIS?o<c?o03?<oc?<c1lO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ03>I<c>I03=Voc=Vc3=V
VC=VIS=V<c=V02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZEC<0VC<0IS<0<c<0003oo`3oc03oV@3oIRLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2Io`2Ic02IV@2IIP2I<`2I001Vo`1Vc2/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`0c<`0c0000o`00c000V@00IP00<nh002l_;fi^KZf][Nc/k03o05Go0:[o0?oo0140
003^003M002k002Z0028001g001E03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@00M`00E@00A0008P00
4Nk^k]gMgK^k^cLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l0;0000?l0;00000l000?o0000o`0J0000
3`000ol0003o01X0000?0003o`000?l06P0000l00_oo01/0000?0003o`0004l01Eo500003`000ol0
001000mO1@0=GkP0000?0003o`0003/01ElQ00AO]00000l000?o0000=`04GbX01En_00003`000ol0
000d00=O<`04Gj/0000?0003o`0003400elj00=OZ00000l000?o0000;@04Gd000enU00003`000ol0
000Z00=OA`04Gj40000?0003o`0002L00em>00=OWP0000l000?o00009003Ge@00enK00003`02ob<0
0Ul>00Co=003oa400elP00;o=P02oc400ol400;o100000l000?o00008002Ga4000?o0000=@000ol0
000C009O7@001?l00?ld0004o`00oc4000?o00000P001?l00?l300003`000ol0000N009O50000ol0
000b00Co5P02Ga/000Co003o=0001?l00?la0003o`00008000Co003o0`0000l000?o00007002GaL0
00?o0000<@000ol0o`0I0003G`0001P00olf00;o<P000ol000020004o`00o`<0000?0003o`0001X0
0UlF0004o`00oc<000?o0?l06P02GaP000?o0000=@001?l00?la0003o`00008000Co003o0`0000l0
00?o00006@000el0000G00;o=@02oa`00UlG00?o=@02oc400_l500;o100000l000?o0000RP02Ghd0
000?0003o`0008`00Un;00003`000ol0002>009OR@0000l000?o0000T002GhL0000809co0Un5o`00
3`000ol0000;0003o`0000/000?o00002P000ol0000;0003o`0000/000?o00002`000ol0000;0003
o`0000X000?o00002`000ol0000;0003o`0000X00Ul<0003o`0000/000?o00002`000ol0000;0003
o`0000/000?o00002P000ol0000;0003o`0000/000?o00002`000ol0000500003`000ol0000d0003
o`0003@000?o0000:0000el000090003o`0003D000?o0000=0000ol0000500003`000ol0002G0003
G`0007l0000?0003o`0009P00Umo00003`000ol0002J0003G`0007`0000?0003o`0009/00Uml0000
3`000ol0002M0003G`0007T0000?0003o`0009h000=O0000N00000l000?o0000W`02GgP0000?0003
o`000:4000=O0000M@0000l00_nS0003G`0007@0000?0003o`000:<000=O0000L`0000l000?o0000
Y002Gg<0000?0003o`000:H000=O0000L00000l000?o0000Y`000el0001_00003`000ol0002X0003
G`0006h0000?0003o`000:T00Um^00003`000ol0002[0003G`0006/0000?0003o`000:`000=O0000
JP0000l000?o0000[@000el0001Y00003`02ojl00UmY00003`000ol0002`0003G`0006H0000?0003
o`000;4000=O0000I@0000l000?o0000/P000el0001T00003`000ol0002c0003G`0006<0000?0003
o`000;@000=O0000HP0000l000?o0000]@000el0001Q00003`000ol0002f0003G`000600000?0003
o`000;L000=O0000G`0000l000?o0000^0000el0001N00003`000ol0002i0003G`0005d0000?00;o
^`000el0001L00003`000ol0002k0003G`0005/0000?0003o`000;`000=O0000FP0000l000?o0000
_@000el0001I00003`000ol0002n0003G`0005P0000?0003o`000;l000=O0000E`0000l000?o0000
`0000el0001F00003`000ol000310003G`0005D0000?0003o`000<8000=O0000E00000P00_l50003
o`000<<000=O0000D`0000L000Co003o10000ol000340003G`00058000070004o`00o`@00oo50003
G`000540000700?o1@000ol000360003G`00050000070003o`0000D000?o0000a`000el0001?0000
2003o`@000?o0000b0000el0001>00003`000ol000380003G`0004h0000?0003o`000<T000=O0000
C@0000l000?o0000bP000el0001<00003`000ol0003;0003G`0004/0000?0003o`000<`000=O0000
BP0000l000?o0000c@000el0001900003`02olh000=O0000B@0000l000?o0000cP000el000180000
3`000ol0003?0003G`0004L0000?0003o`000=0000=O0000AP0000l000?o0000d@000el000150000
3`000ol0003B0003G`0004@0000?0003o`000=8000=O0000A00000l000?o0000d`000el000130000
3`000ol0003D0003G`000480000?0003o`000=D000=O0000@@0000l000?o0000eP000el000100000
3`02omP000=O0000?`0000l000?o0000f0000el0000n00003`000ol0003H0003G`0003h0000?0003
o`000=T000=O0000?@0000l000?o0000fP000el0000l00003`000ol0003K0003G`0003/0000?0003
o`000=`000=O0000>P0000l000?o0000g@000el0000i00003`000ol0003M0003G`0003T0000?0003
o`000=h000=O0000>00000l00_oP0003G`0003L0000?0003o`000>0000=O0000=P0000l000?o0000
h0000el0000f00003`000ol0003Q0003G`0003D0000?0003o`000>8000=O0000=00000l000?o0000
h`000el0000c00003`000ol0003T0003G`000380000?0003o`000>@000=O0000<P0000l000?o0000
i@000el0000a00002002o`D000?o0000iP000el0000`00001`001?l00?l40003o`000>L000=O0000
;`0000L000Co003o1003onL000=O0000;`0000P00_l50003o`000>P000=O0000;P0000L000Co003o
10000ol0003Y0003G`0002d0000800;o1@000ol0003Y0003G`0002d0000?0003o`000>X000=O0000
;00000l000?o0000jP000el0000/00003`000ol0003[0003G`0002/0000?0003o`000>`000=O0000
:P0000l000?o0000k0000el0000Z00003`000ol0003]0003G`0002T0000?00;ok`000el0000X0000
3`000ol0003^0003G`0002P0000?0003o`000>l000=O00009`0000l000?o0000k`000el0000W0000
3`000ol0003`0003G`0002H0000?0003o`000?4000=O00009@0000l000?o0000l@000el0000U0000
3`000ol0003b0003G`0002@0000?0003o`000?<000=O00008`0000l000?o0000l`000el0000S0000
3`000ol0003d0003G`000280000?00;omP000el0000Q00003`000ol0003e0003G`000240000?0003
o`000?H000=O0000800000l000?o0000m`000el0000O00003`000ol0003h0003G`0001h0000?0003
o`000?P000=O00007P0000l000?o0000n@000el0000M00003`000ol0003j0003G`0001`0000?0003
o`000?X000=O0000700000l000?o0000n`000el0000K00003`000ol0003l0003G`0001X0000?00;o
o@000el0000J00003`000ol0003m0003G`0001T0000?0003o`000?h000=O0000600000l000?o0000
oP000el0000H00003`000ol0003o0003G`0001L0000?0003o`000?l000=O00005`0000l000?o0000
o`010003G`0001H0000?0003o`000?l00P000el0000E000000@0oooo1002o`D000?o0000o`020003
G`0001D000020003o`00008000Co003o10000ol0003o00<000=O00005000008000?o00000P001?l0
0?l400?oo`040003G`0001<000020003o`00008000Co003o10000ol0003o00@000=O00004`000080
00?o00000P001?l00?l40003o`000?l01@000el0000B000000<0ool01@02o`D000?o0000o`050003
G`000180000?0003o`000?l01P000el0000A00003`000ol0003o00L000=O0000400000l000?o0000
o`070003G`000100000?0003o`000?l020000el0000?00003`000ol0003o00P000=O00003`0000l0
00?o0000o`090003G`0000h0000?0003o`000?l02P000el0000=00003`02ool02`000el0000=0000
3`000ol0003o00/000=O0000300000l000?o0000o`0;0003G`0000`0000?0003o`000?l030000el0
000;00003`000ol0003o00`000=O00002`0000l000?o0000o`0=0003G`0000X0000?0003o`000?l0
3@000el0000:00003`000ol0003o00h000=O00002@0000l000?o0000o`0?0003G`0000P0000?0003
o`000?l03`000el0000800003`02ool04@000el0000700003`000ol0003o010000=O00001`0000l0
00?o0000o`0A0003G`0000H0000?0003o`000?l04P000el0000500003`000ol0003o01X0000?0003
o`000?l06P0000l000?o0000o`0J00003`000ol0003o01X0003o02`0003o02`00000\
\>"],
  ImageRangeCache->{{{0, 298.062}, {183.75, 0}} -> {-0.566783, 2.74534, 
  0.0362905, 0.0472925}}]
}, Closed]],

Cell["Here the data plot and the best-fit plot are combined.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(Show[{dataplot, curveplot}]; \)\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.0952381 -0.20282 0.0725117 [
[.21429 .07473 -3 -9 ]
[.21429 .07473 3 0 ]
[.40476 .07473 -3 -9 ]
[.40476 .07473 3 0 ]
[.59524 .07473 -3 -9 ]
[.59524 .07473 3 0 ]
[.78571 .07473 -3 -9 ]
[.78571 .07473 3 0 ]
[.97619 .07473 -6 -9 ]
[.97619 .07473 6 0 ]
[.01131 .23225 -6 -4.5 ]
[.01131 .23225 0 4.5 ]
[.01131 .37727 -6 -4.5 ]
[.01131 .37727 0 4.5 ]
[.01131 .5223 -12 -4.5 ]
[.01131 .5223 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.21429 .08723 m
.21429 .09348 L
s
[(2)] .21429 .07473 0 1 Mshowa
.40476 .08723 m
.40476 .09348 L
s
[(4)] .40476 .07473 0 1 Mshowa
.59524 .08723 m
.59524 .09348 L
s
[(6)] .59524 .07473 0 1 Mshowa
.78571 .08723 m
.78571 .09348 L
s
[(8)] .78571 .07473 0 1 Mshowa
.97619 .08723 m
.97619 .09348 L
s
[(10)] .97619 .07473 0 1 Mshowa
.125 Mabswid
.07143 .08723 m
.07143 .09098 L
s
.11905 .08723 m
.11905 .09098 L
s
.16667 .08723 m
.16667 .09098 L
s
.2619 .08723 m
.2619 .09098 L
s
.30952 .08723 m
.30952 .09098 L
s
.35714 .08723 m
.35714 .09098 L
s
.45238 .08723 m
.45238 .09098 L
s
.5 .08723 m
.5 .09098 L
s
.54762 .08723 m
.54762 .09098 L
s
.64286 .08723 m
.64286 .09098 L
s
.69048 .08723 m
.69048 .09098 L
s
.7381 .08723 m
.7381 .09098 L
s
.83333 .08723 m
.83333 .09098 L
s
.88095 .08723 m
.88095 .09098 L
s
.92857 .08723 m
.92857 .09098 L
s
.25 Mabswid
0 .08723 m
1 .08723 L
s
.02381 .23225 m
.03006 .23225 L
s
[(6)] .01131 .23225 1 0 Mshowa
.02381 .37727 m
.03006 .37727 L
s
[(8)] .01131 .37727 1 0 Mshowa
.02381 .5223 m
.03006 .5223 L
s
[(10)] .01131 .5223 1 0 Mshowa
.125 Mabswid
.02381 .12348 m
.02756 .12348 L
s
.02381 .15974 m
.02756 .15974 L
s
.02381 .19599 m
.02756 .19599 L
s
.02381 .26851 m
.02756 .26851 L
s
.02381 .30476 m
.02756 .30476 L
s
.02381 .34102 m
.02756 .34102 L
s
.02381 .41353 m
.02756 .41353 L
s
.02381 .44979 m
.02756 .44979 L
s
.02381 .48604 m
.02756 .48604 L
s
.02381 .05097 m
.02756 .05097 L
s
.02381 .01472 m
.02756 .01472 L
s
.02381 .55855 m
.02756 .55855 L
s
.02381 .59481 m
.02756 .59481 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 g
.03 w
.11905 .08723 Mdot
.21429 .01472 Mdot
.40476 .01472 Mdot
.69048 .23225 Mdot
.97619 .59481 Mdot
1 .3 0 r
.5 Mabswid
.11905 .06903 m
.15382 .05278 L
.19174 .0387 L
.21018 .03324 L
.22736 .02896 L
.24496 .02539 L
.26161 .02277 L
.27042 .02168 L
.27998 .02073 L
.28867 .02007 L
.29287 .01983 L
.2967 .01965 L
.30089 .01949 L
.3032 .01943 L
.3054 .01938 L
.30638 .01936 L
.30742 .01935 L
.30832 .01933 L
.3093 .01932 L
.31045 .01932 L
.31153 .01931 L
.31258 .01931 L
.31355 .01931 L
.31463 .01931 L
.31578 .01932 L
.31687 .01933 L
.31786 .01935 L
.32028 .01939 L
.32258 .01944 L
.32715 .01959 L
.33212 .01981 L
.34058 .02034 L
.34991 .02115 L
.35966 .02224 L
.36882 .02349 L
.38698 .02664 L
.40364 .03029 L
.4393 .04058 L
.4736 .05367 L
.5101 .07102 L
.54524 .09106 L
.58259 .11596 L
.61857 .14345 L
.65319 .17313 L
.69002 .2082 L
.72548 .24537 L
.75958 .28426 L
.79589 .32905 L
.83083 .37547 L
.86798 .42837 L
Mistroke
.90376 .48278 L
.93818 .53833 L
.97481 .6009 L
.97619 .60332 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{299.062, 184.75},
  ImageMargins->{{48, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004[0000^0P10`4000010?ooooooc?ooZ_ooI_oo
<ooo0?o<ooo<c?o<VC/k>gYjN[Vi^OShn03ooeGooj[ooonI<onI0?mVoomVc?mVVOmVI_mV<omV0?lc
oclo?ginO[fm_Oclo5D00:X00?l00?l0VOl0I_l0<ol00<coolcoc<coVLcoIP<30d92@X61PL30`000
EED0EJX0EOl0ELbIolbIc<bIVLbII/bI<lbI0<aVolaVc0L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0Z/`c
<l`c0<`0ol`0c<`0VL`0I/`0<l`000/;2dY:BXV9RLS8b000oeD0ojX0ool0oiW<VIW<IYW<<iW<09VI
oiVIc9VIVIVIIPl?3di>CXf=SLc<c01E05EE0:YE0?mE09TcoiTcc9TcVITcIYTc<iTc09T0oiT0c1<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEEFKo<fKo06K<ofK<c6K<VFK<IVK<<fK<01LG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZVIVVFIVIVIV<fIV06HcofHcc6HcVFHcIQ/K6eYJFYVIVMSHf01EoeEEojYEoomEoc?o
oc?oc3?oVC?oIS?o<c?o03?<oc?<c1lO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ03>I<c>I03=Voc=Vc3=V
VC=VIS=V<c=V02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZEC<0VC<0IS<0<c<0003oo`3oc03oV@3oIRLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2Io`2Ic02IV@2IIP2I<`2I001Vo`1Vc2/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`0c<`0c0000o`00c000V@00IP00<nh002l_;fi^KZf][Nc/k03o05Go0:[o0?oo0140
003^003M002k002Z0028001g001E03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@00M`00E@00A0008P00
4Nk^k]gMgK^k^cLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l0;0000?l0;00000l000?o0000o`0J0000
3`000ol0000b00@J=0046Z/0000?0003o`0003401QXb00HJZP0000l000?o0000<0086S0021ZY0000
3`02oc4021X`00PJZ@0000l000?o0000<0086S0021ZY00003`000ol0000`00PJ2`0KG`X021ZY0000
3`000ol0000a00HJ2@03Ga/01el400HJZP0000l000?o0000<P046PD01ElU00EO11Z[00003`000ol0
000f00EO;`04Gj/0000?0003o`0003401Elh00=OZ00000l000?o0000;@04Gd000enU00003`000ol0
000Z00=OA`03Gj80000?0003o`0002L00em=00=OW`0000l000?o00009003Ge<00UnM00003`02ob<0
0Ul>00Co=003o`l00elR00;o=P02oc400ol400;o100000l000?o00008002Ga4000?o0000=@000ol0
000A009O7`001?l00?ld0004o`00oc4000?o00000P001?l00?l300003`000ol0000N009O50000ol0
000b00Co5002Gad000Co003o=0001?l00?la0003o`00008000Co003o0`0000l000?o00007002GaL0
00?o0000<@000ol0o`0G00=O6P03ocH00_lb0003o`00008000Co003o0`0000l000?o00006P02GaH0
00Co003o<`000ol0o`0J009O60000ol0000e0004o`00oc4000?o00000P001?l00?l300003`000ol0
000I0003G`0001L00_le00;o7002GaL00ole00;o<@02o`D00_l400003`000ol0002:009OS@0000l0
00?o00005`046W400Un;00003`000ol0000F00HJLP000el0002800003`000ol0000E00PJLP02GhP0
000801oo21Ydo`9OQ_l000l000?o00002`000ol0000700PJ2@000ol0000;0003o`0000/000?o0000
2`000ol0000;0003o`0000X000?o00002`000ol0000;0003o`0000T000=O0?l030000ol0000;0003
o`0000/000?o00002`000ol0000;0003o`0000X000?o00002`000ol0000;0003o`0000/000?o0000
1@0000l000?o00002`000ol0000700PJ2@000ol0000;0003o`0000/000?o00002`000ol0000;0003
o`0000X000?o00002`000ol0000;0003o`0000X00Ul<0003o`0000/000?o00002`000ol0000;0003
o`0000/000?o00002P000ol0000;0003o`0000/000?o00002`000ol0000500003`000ol0000F00HJ
NP000el0002000003`000ol0000G00@JO002Gh00000?0003o`0009T00Umn00003`000ol0002K0003
G`0007/0000?0003o`0009`00Umk00003`000ol0002N0003G`0007P0000?0003o`0009l00Umh0000
3`000ol0002Q0003G`0007D0000?00;oX`000el0001d00003`000ol0002S0003G`0007<0000?0003
o`000:@00Umc00003`000ol0002V0003G`000700000?0003o`000:L000=O0000K`0000l000?o0000
Z0000el0001^00003`000ol0002Y009OKP0000l000?o0000Z`000el0001[00003`000ol0002/0003
G`0006X0000?0003o`000:d000=O0000J@0000l00_n_009OJ@0000l000?o0000/0000el0001V0000
3`000ol0002a0003G`0006D0000?0003o`000;8000=O0000I00000l000?o0000/`02Gf@0000?0003
o`000;D000=O0000H@0000l000?o0000]P000el0001P00003`000ol0002g0003G`0005l0000?0003
o`000;P000=O0000GP0000l000?o0000^@000el0001M00003`000ol0002j0003G`0005`0000?00;o
_0000el0001K00003`000ol0002l0003G`0005X0000?0003o`000;d000=O0000F@0000l000?o0000
_P000el0001H00003`000ol0002n0003G`0005P0000?0003o`000;l000=O0000E`0000l000?o0000
`0000el0001F00003`000ol0002l00@J00<0G`00EP0000P00_l50003o`000;/01QX00`1O001E0000
1`001?l00?l40003o`000;X021X00`1O001D00001`001?l00?l400?o^P086P8000=O0000DP0000L0
0ol50003o`000;X021X30003G`00054000070003o`0000D000?o0000^P086P@000=O0000D00000P0
0ol40003o`000;/01QX60003G`0004l0000?0003o`000;`011X80003G`0004h0000?0003o`000<P0
00=O0000CP0000l000?o0000b@000el0001=00003`000ol0003:0003G`0004`0000?0003o`000</0
00=O0000B`0000l000?o0000c0000el0001:00003`000ol0003=0003G`0004T0000?00;oc`000el0
001800003`000ol0003?0003G`0004L0000?0003o`000=0000=O0000AP0000l000?o0000d@000el0
001500003`000ol0003B0003G`0004@0000?0003o`000=8000=O0000A00000l000?o0000d`000el0
001300003`000ol0003D0003G`000480000?0003o`000=D000=O0000@@0000l000?o0000eP000el0
001000003`02omP000=O0000?`0000l000?o0000f0000el0000n00003`000ol0003H0003G`0003h0
000?0003o`000=T000=O0000?@0000l000?o0000fP000el0000l00003`000ol0003K0003G`0003/0
000?0003o`000=`000=O0000>P0000l000?o0000g@000el0000i00003`000ol0003M0003G`0003T0
000?0003o`000=h000=O0000>00000l000?o0000g`000el0000g00003`02on4000=O0000=P0000l0
00?o0000h0000el0000f00003`000ol0003Q0003G`0003D0000?0003o`000>8000=O0000=00000l0
00?o0000hP000el0000d00003`000ol0003S0003G`0003<0000?0003o`000>@000=O0000<P0000l0
00?o0000i@000el0000a00002002o`D000?o0000i@000el0000a00001`001?l00?l40003o`000>H0
00=O0000<00000L000Co003o1003onL000=O0000;`0000P00_l50003o`000>L000=O0000;`0000L0
00Co003o10000ol0003X0003G`0002h0000800;o1@000ol0003Y0003G`0002d0000?0003o`000>T0
00=O0000;@0000l000?o0000jP000el0000/00003`000ol0003[0003G`0002/0000?0003o`000>/0
00=O0000:`0000l000?o0000k0000el0000Z00003`000ol0003]0003G`0002T0000?0003o`000>d0
00=O0000:@0000l00_o_0003G`0002P0000?0003o`000>l000=O00009`0000l000?o0000k`000el0
000W00003`000ol0003`0003G`0002H0000?0003o`000?4000=O00009@0000l000?o0000l@000el0
000U00003`000ol0003b0003G`0002@0000?0003o`000?<000=O00008`0000l000?o0000l`000el0
000S00003`000ol0003d0003G`000280000?00;omP000el0000Q00003`000ol0003e0003G`000240
000?0003o`000?H000=O0000800000l000?o0000m`000el0000O00003`000ol0003h0003G`0001h0
000?0003o`000?P000=O00007P0000l000?o0000n@000el0000M00003`000ol0003j0003G`0001`0
000?0003o`000?X000=O0000700000l000?o0000n`000el0000K00003`000ol0003l0003G`0001X0
000?00;oo@000el0000J00003`000ol0003m0003G`0001T0000?0003o`000?h000=O0000600000l0
00?o0000oP000el0000H00003`000ol0003o0003G`0001L0000?0003o`000?l000=O00005`0000l0
00?o0000o`010003G`0001H0000?0003o`000?l00P000el0000E000000@0oooo1002o`D000?o0000
o`020003G`0001D000020003o`00008000Co003o10000ol0003o00<000=O00005000008000?o0000
0P001?l00?l400?oo`040003G`0001<000020003o`00008000Co003o10000ol0003o00@000=O0000
4`00008000?o00000P001?l00?l40003o`000?l01@000el0000B000000<0ool01@02o`D000?o0000
o`050003G`000180000?0003o`000?l01P000el0000A00003`000ol0003o00L000=O0000400000l0
00?o0000o`070003G`000100000?0003o`000?l020000el0000?00003`000ol0003o00P000=O0000
3`0000l000?o0000o`090003G`0000h0000?0003o`000?l02P000el0000=00003`02ool02`000el0
000=00003`000ol0003o00/000=O0000300000l000?o0000o`0;0003G`0000`0000?0003o`000?l0
30000el0000;00003`000ol0003o00`000=O00002`0000l000?o0000o`0=0003G`0000X0000?0003
o`000?l03@000el0000:00003`000ol0003o00h000=O01X00aX600003`000ol0003o00l000=O6QX0
0aX500003`000ol0003o00h000<JGaX01AX400003`02ool03`026P03GaXJ00<J100000l000?o0000
o`0>008J00=O6QX00aX400003`000ol0003o00h00aX00elJ6P026P@0000?0003o`000?l03`036P03
GaXJ00D0000?0003o`000?l040046PH0000?0003o`000?l06P0000l000?o0000o`0J00003`000ol0
003o01X0003o02`0003o02`00000\
\>"],
  ImageRangeCache->{{{0, 298.062}, {183.75, 0}} -> {-0.566783, 2.67947, 
  0.0362905, 0.0476645}}]
}, Closed]],

Cell[TextData[{
  "To find a value of the fit function at a particular point, we use a \
replacement rule. Here is the value of the fit function at ",
  Cell[BoxData[
      \(TraditionalForm\`x = 6\)]],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(fitcurve /. x -> 6\)], "Input"],

Cell[BoxData[
    \(4.52407932011331403`\)], "Output"]
}, Closed]],

Cell["\<\
We can fit the same data using different sets of basis functions. \
Here is a best-fitting function made up of a linear combination of a \
constant, an exponential, and a logarithm function.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(fit2[x_] = Fit[data, {1, Exp[x], Log[x]}, x]\)], "Input"],

Cell[BoxData[
    \(\(3.22397975410693904`\[InvisibleSpace]\) + 
      0.000284875966677298553`\ E\^x + 0.675489210819278174`\ Log[x]\)], 
  "Output"]
}, Closed]],

Cell[TextData[{
  "Here we use the ",
  StyleBox["Epilog", "Input",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " option of ",
  StyleBox["Plot", "Input"],
  " to have ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " plot the data points on the same axes as the plot."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(Plot[fit2[x], {x, 1, 10}, PlotRange \[Rule] {2, 12}, 
      PlotStyle \[Rule] Hue[0.6], 
      Epilog \[Rule] {PointSize[0.03], GrayLevel[0.5], Map[Point, data]}]; 
    \)\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.0952381 -0.123607 0.0618034 [
[.21429 -0.0125 -3 -9 ]
[.21429 -0.0125 3 0 ]
[.40476 -0.0125 -3 -9 ]
[.40476 -0.0125 3 0 ]
[.59524 -0.0125 -3 -9 ]
[.59524 -0.0125 3 0 ]
[.78571 -0.0125 -3 -9 ]
[.78571 -0.0125 3 0 ]
[.97619 -0.0125 -6 -9 ]
[.97619 -0.0125 6 0 ]
[.01131 .12361 -6 -4.5 ]
[.01131 .12361 0 4.5 ]
[.01131 .24721 -6 -4.5 ]
[.01131 .24721 0 4.5 ]
[.01131 .37082 -6 -4.5 ]
[.01131 .37082 0 4.5 ]
[.01131 .49443 -12 -4.5 ]
[.01131 .49443 0 4.5 ]
[.01131 .61803 -12 -4.5 ]
[.01131 .61803 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.21429 0 m
.21429 .00625 L
s
[(2)] .21429 -0.0125 0 1 Mshowa
.40476 0 m
.40476 .00625 L
s
[(4)] .40476 -0.0125 0 1 Mshowa
.59524 0 m
.59524 .00625 L
s
[(6)] .59524 -0.0125 0 1 Mshowa
.78571 0 m
.78571 .00625 L
s
[(8)] .78571 -0.0125 0 1 Mshowa
.97619 0 m
.97619 .00625 L
s
[(10)] .97619 -0.0125 0 1 Mshowa
.125 Mabswid
.07143 0 m
.07143 .00375 L
s
.11905 0 m
.11905 .00375 L
s
.16667 0 m
.16667 .00375 L
s
.2619 0 m
.2619 .00375 L
s
.30952 0 m
.30952 .00375 L
s
.35714 0 m
.35714 .00375 L
s
.45238 0 m
.45238 .00375 L
s
.5 0 m
.5 .00375 L
s
.54762 0 m
.54762 .00375 L
s
.64286 0 m
.64286 .00375 L
s
.69048 0 m
.69048 .00375 L
s
.7381 0 m
.7381 .00375 L
s
.83333 0 m
.83333 .00375 L
s
.88095 0 m
.88095 .00375 L
s
.92857 0 m
.92857 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
.02381 .12361 m
.03006 .12361 L
s
[(4)] .01131 .12361 1 0 Mshowa
.02381 .24721 m
.03006 .24721 L
s
[(6)] .01131 .24721 1 0 Mshowa
.02381 .37082 m
.03006 .37082 L
s
[(8)] .01131 .37082 1 0 Mshowa
.02381 .49443 m
.03006 .49443 L
s
[(10)] .01131 .49443 1 0 Mshowa
.02381 .61803 m
.03006 .61803 L
s
[(12)] .01131 .61803 1 0 Mshowa
.125 Mabswid
.02381 .0309 m
.02756 .0309 L
s
.02381 .0618 m
.02756 .0618 L
s
.02381 .09271 m
.02756 .09271 L
s
.02381 .15451 m
.02756 .15451 L
s
.02381 .18541 m
.02756 .18541 L
s
.02381 .21631 m
.02756 .21631 L
s
.02381 .27812 m
.02756 .27812 L
s
.02381 .30902 m
.02756 .30902 L
s
.02381 .33992 m
.02756 .33992 L
s
.02381 .40172 m
.02756 .40172 L
s
.02381 .43262 m
.02756 .43262 L
s
.02381 .46353 m
.02756 .46353 L
s
.02381 .52533 m
.02756 .52533 L
s
.02381 .55623 m
.02756 .55623 L
s
.02381 .58713 m
.02756 .58713 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
0 .4 1 r
.5 Mabswid
.11905 .07569 m
.15382 .08871 L
.19174 .09943 L
.22736 .1075 L
.26161 .11406 L
.29806 .12012 L
.33316 .12528 L
.37046 .13025 L
.4064 .13468 L
.44097 .13872 L
.47775 .14291 L
.51316 .14697 L
.54722 .15107 L
.58347 .15586 L
.61837 .16116 L
.65547 .168 L
.69121 .17639 L
.72558 .18694 L
.76216 .20213 L
.79738 .22241 L
.81536 .2357 L
.8348 .25294 L
.87086 .29521 L
.88881 .32269 L
.90777 .35772 L
.94194 .44091 L
.95847 .49295 L
.97619 .55958 L
s
.5 g
.03 w
.11905 .12361 Mdot
.21429 .0618 Mdot
.40476 .0618 Mdot
.69048 .24721 Mdot
.97619 .55623 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{299.062, 184.75},
  ImageMargins->{{48, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004[0000^0P10`4000010?ooooooc?ooZ_ooI_oo
<ooo0?o<ooo<c?o<VC/k>gYjN[Vi^OShn03ooeGooj[ooonI<onI0?mVoomVc?mVVOmVI_mV<omV0?lc
oclo?ginO[fm_Oclo5D00:X00?l00?l0VOl0I_l0<ol00<coolcoc<coVLcoIP<30d92@X61PL30`000
EED0EJX0EOl0ELbIolbIc<bIVLbII/bI<lbI0<aVolaVc0L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0Z/`c
<l`c0<`0ol`0c<`0VL`0I/`0<l`000/;2dY:BXV9RLS8b000oeD0ojX0ool0oiW<VIW<IYW<<iW<09VI
oiVIc9VIVIVIIPl?3di>CXf=SLc<c01E05EE0:YE0?mE09TcoiTcc9TcVITcIYTc<iTc09T0oiT0c1<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEEFKo<fKo06K<ofK<c6K<VFK<IVK<<fK<01LG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZVIVVFIVIVIV<fIV06HcofHcc6HcVFHcIQ/K6eYJFYVIVMSHf01EoeEEojYEoomEoc?o
oc?oc3?oVC?oIS?o<c?o03?<oc?<c1lO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ03>I<c>I03=Voc=Vc3=V
VC=VIS=V<c=V02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZEC<0VC<0IS<0<c<0003oo`3oc03oV@3oIRLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2Io`2Ic02IV@2IIP2I<`2I001Vo`1Vc2/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`0c<`0c0000o`00c000V@00IP00<nh002l_;fi^KZf][Nc/k03o05Go0:[o0?oo0140
003^003M002k002Z0028001g001E03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@00M`00E@00A0008P00
4Nk^k]gMgK^k^cLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l0;0000?l0;00004X01?l`00?o<@02oc40
0_l^00?o1002o`d0001;0003o`00034000?o0000;`001?l00?l_0004o`00obh000?o00000P001?l0
0?l<0000C0000ol0000^00Co<0001?l00?l_0004o`00obh000?o00000P001?l00?l<0000C@000ol0
000]0003o`3o03400ola00;o;`000ol000020004o`00o``0001:0004o`00obl000?o0?l0<@000ol0
000`0004o`00obh000?o00000P001?l00?l<0000B`02oc400_lb00?o<002obh00_l500;o3@000?l0
;0000?l0;0000?l0;0000?l0;0000180ool@o`X0000H0003o`0000X000?o00002P000ol0000:0003
o`0000X000?o00002P000ol0000:0003o`0000T000?o00002P000ol0000:0003o`0000X000?o0000
2P000ol0000:0003o`0000X000?o00002@000ol0000:0003o`0000X000?o00002P000ol0000:0003
o`0000X000?o00002P000ol0000>000060000ol0000a0003o`00030000?o0000<@000ol0000`0003
o`00034000?o00003P0001P000?o0000o`0A000060000ol0003o0140000H0003o`000?l04@0001P0
00?o0000o`0A000060000ol0003o0140000H00;oo`0B000060000ol0003o0140000H0003o`000?l0
4@0001P000?o0000o`0A000060000ol0003o0140000H0003o`0002l011X`00@JZ@0001P000?o0000
;P066Rh01QZX000060000ol0000]00PJ;0086ZL0000H0003o`0002d021X/00PJY`0001P00_l^00PJ
;0086ZL0000H0003o`0002d021X/00PJY`0001P000?o0000;P066Rh01QZX000060000ol0000_00@J
<0046ZT0000H0003o`0001L00lKf000060000ol0000J00?6l`0001P000?o00007@03a_00000H0003
o`0002001<K/00006002obD00lKY000060000ol0000W00?6iP0001P000?o0000:P04a^80000H0003
o`0002h01LKM000060000ol0000c00G6f00001P000?o00005P046Qh01LKC00004@03o`@000?o0000
5@066R801<K?00004P000ol000030003o`0001@021XU00G6bP0001001?l400?o50086RX01lK30000
40000ol0o`050003o`0001@021Xa00[6^@00010000?o0?l01@000ol0000D00PJ>`0:aZl0000A00;o
1@000ol0000E00HJAP07aZP0000H0003o`0001H011Y>00G6X`0001P000?o0000K@07aY`0000H0003
o`0007@02/JB000060000ol0001n00[6R00001P000?o0000R009aWl0000H00;oTP07aWP0000H0003
o`0009P01LIc000060000ol0002M00O6K00001P000?o0000Y007aVD0000H0003o`000:/00lIR0000
60000ol0002^00?6G`0001P000?o0000/@04aU/0000H0003o`000;D00lIH00006002okT00lIE0000
60000ol0002k00;6D`0001P000?o0000_@03aU00000H0003o`000<000/I>000060000ol0003200?6
B`0001P000?o0000a@02aTT0000H0003o`000<L00/I7000060000ol0003900;6A@0001P000?o0000
b`000lH0001200006002old00/I2000060000ol0003>00;6@00001P000?o0000d0000lH0000m0000
60000ol0003A0003aP0003`0000H0003o`000;0011XN0003aP0003/0000H0003o`000:l01QXN00;6
>`0001400_l50003o`000:h021XO0003aP0003P0000@0004o`00o`@000?o0000[P086R0000?60000
=`00010000Co003o1003ojh021XQ0003aP0003H0000@00?o1@000ol0002^00PJ8P000lH0000e0000
40000ol000050003o`000:l01QXS0003aP0003D0000A00?o10000ol0002`00@J9@000lH0000d0000
60000ol0003J0003aP0003<0000H0003o`000=/000?60000<P0001P000?o0000g0000lH0000a0000
60000ol0003M0003aP000300000H00;ogP000lH0000`000060000ol0003N0003aP0002l0000H0003
o`000=l000?60000;P0001P000?o0000h0000lH0000]000060000ol0003Q0003aP0002`0000H0003
o`000>8000?60000:`0001P000?o0000hP000lH0000[000060000ol0003S0003aP0002X0000H0003
o`000>@000?60000:@0001P00_oV0003aP0002P0000H0003o`000>D000?60000:00001P000?o0000
iP000lH0000W000060000ol0003W0003aP0002H0000H0003o`000>L000?600009P0001P000?o0000
j0000lH0000U000060000ol0003X0003aP0002D0000H0003o`000>T000?60000900001P00_oZ0003
aP0002@0000H0003o`000>X000?600008`0001P000?o0000jP000lH0000S000060000ol0003[0003
aP000280000H0003o`000>/000?600008P0001P000?o0000k0000lH0000Q00004@02o`D000?o0000
k0000lH0000Q000040001?l00?l40003o`000>d000?600008000010000Co003o1003ond000?60000
800001400_l50003o`000>d000?600008000010000Co003o10000ol0003^0003aP0001l0000A00;o
1@000ol0003^0003aP0001l0000H0003o`000>l000?600007P0001P000?o0000k`000lH0000N0000
60000ol0003_0003aP0001h0000H0003o`000?0000?600007@0001P000?o0000l0000lH0000M0000
6002oo8000?60000700001P000?o0000l@000lH0000L000060000ol0003b0003aP0001/0000H0003
o`000?8000?600006`0001P000?o0000lP000lH0000K000060000ol0003c0003aP0001X0000H0003
o`000?<000?600006P0001P000?o0000m0000lH0000I00006002ooD000?600006@0001P000?o0000
m0000lH0000I000060000ol0003e0003aP0001P0000H0003o`000?D000?60000600001P000?o0000
mP000lH0000G000060000ol0003f0003aP0001L0000H0003o`000?H000?600005`0001P000?o0000
m`000lH0000F00006002ooP000?600005P0001P000?o0000m`000lH0000F000060000ol0003h0003
aP0001D0000H0003o`000?P000?600005@0001P000?o0000n0000lH0000E000060000ol0003i0003
aP0001@0000H0003o`000?T000?60000500000X00ol400;o1@000ol0003i0003aP0001@0000;0003
o`00008000Co003o10000ol0003j0003aP0001<0000;0003o`00008000Co003o1003ooX000?60000
4`0000/000?o00000P001?l00?l40003o`000?X000?600004`0000/000?o00000P001?l00?l40003
o`000?/000?600004P0000X00_l500;o1@000ol0003k0003aP000180000H0003o`000?/000?60000
4P0001P000?o0000o0000lH0000A000060000ol0003l0003aP000140000H0003o`000?`000?60000
4@0001P00_om0003aP000140000H0003o`000?d000?60000400001P000?o0000o@000lH0000@0000
60000ol0003m0003aP000100000H0003o`000?d000?60000400001P000?o0000o@046Pl0000H0003
o`000?`01QX>000060000ol0003k00PJ3@0001P00_ol00PJ3@0001P000?o0000n`086Pd0000H0003
o`000?/021X=000060000ol0003l00HJ3P0001P000?o0000o@046Pl0000H0003o`000?l04@0001P0
00?o0000o`0A000060000ol0003o0140000H0003o`000?l04@0001P00_oo0180000H0003o`000?l0
4@0001P000?o0000o`0A000060000ol0003o0140000H0003o`000?l04@0001P000?o0000o`0A0000
2P03o`<01?l40003o`000?l04@0000/000?o00000`000ol000040003o`000?l04@0000/000?o0000
10000ol0000300?oo`0A00002`000ol000050003o`000?l05P0000/000?o00000P001?l00?oo01P0
000:00;o1@02ool06@000?l0;0000001\
\>"],
  ImageRangeCache->{{{0, 298.062}, {183.75, 0}} -> {-0.969431, 1.25837, 
  0.0388877, 0.0599254}}]
}, Closed]],

Cell[BoxData[
    \(Clear[data, dataplot, fitcurve, curveplot, fit2]\)], "Input"],

Cell[TextData[{
  "There are two cases when the ",
  StyleBox["Fit", "Input"],
  " command is inappropriate. The first occurs when the function which we \
want to fit to is not linear in the unknown parameters. In such cases, it is \
necessary to use the package ",
  StyleBox["Statistics`NonlinearFit`", "Input"],
  ", described in the next section. The second case occurs when the data set \
contains outlying points which a least-squares fit will weight too heavily. \
In such cases, a more robust fitting process should be used. A more rigorous \
technique is defined in the add-on ",
  StyleBox["Experimental Data Analyst",
    FontSlant->"Italic"],
  "."
}], "Text"],

Cell[TextData[{
  "Note that",
  " ",
  StyleBox["Fit", "Input"],
  " is not limited to two-dimensional data. Here is a list of ordered \
triples."
}], "Text"],

Cell[BoxData[
    \(\(wavydata = 
      Flatten[Table[{i, j, 
            2  i\^2 - Cos[j] + Random[Real, {\(-0.2\), 0.2}]}, {i, \(-3.0\), 
            3.0, 0.2}, {j, \(-6.0\), 6.0, 0.2}], 1]; \)\)], "Input"],

Cell["Here is the first ordered triple.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(First[wavydata]\)], "Input"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{"-", 
          StyleBox["3.`",
            StyleBoxAutoDelete->True,
            PrintPrecision->2]}], ",", 
        RowBox[{"-", 
          StyleBox["6.`",
            StyleBoxAutoDelete->True,
            PrintPrecision->2]}], ",", "17.0627785485452854`"}], "}"}]], 
  "Output"]
}, Closed]],

Cell[TextData[{
  "The function ",
  StyleBox["ScatterPlot3D", "Input"],
  ", defined in the package ",
  StyleBox["Graphics`Graphics3D`", "Input"],
  ", displays a list of points in three dimensions."
}], "Text"],

Cell[BoxData[
    \(Needs["\<Graphics`Graphics3D`\>"]\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(wavydataplot = 
      ScatterPlot3D[wavydata, BoxRatios \[Rule] {1, 1, 0.4}]; \)\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .81114 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1.04977 -0.0679587 1.04977 [
[.13542 .20373 -11.9677 -9 ]
[.13542 .20373 .03234 0 ]
[.3345 .12542 -5.5867 -9 ]
[.3345 .12542 .4133 0 ]
[.54972 .04081 -5.18957 -9 ]
[.54972 .04081 .81043 0 ]
[.73604 .04893 0 -6.20891 ]
[.73604 .04893 12 2.79109 ]
[.8565 .23339 0 -6.03127 ]
[.8565 .23339 6 2.96873 ]
[.95806 .38893 0 -5.88708 ]
[.95806 .38893 6 3.11292 ]
[.02232 .27634 -6 -2.7518 ]
[.02232 .27634 0 6.2482 ]
[.01395 .32882 -6 -2.7962 ]
[.01395 .32882 0 6.2038 ]
[.00529 .38311 -12 -2.84229 ]
[.00529 .38311 0 6.15771 ]
[-0.00368 .4393 -12 -2.89017 ]
[-0.00368 .4393 0 6.10983 ]
[ 0 0 0 0 ]
[ 1 .81114 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.03716 .25514 m
.68874 0 L
s
.14467 .21304 m
.1493 .21769 L
s
[(-2)] .13542 .20373 .99461 1 Mshowa
.34306 .13535 m
.34735 .14032 L
s
[(0)] .3345 .12542 .86223 1 Mshowa
.55745 .05141 m
.56132 .05671 L
s
[(2)] .54972 .04081 .72986 1 Mshowa
.125 Mabswid
.19287 .19417 m
.1956 .197 L
s
.24198 .17493 m
.24466 .17782 L
s
.29204 .15533 m
.29467 .15827 L
s
.39509 .11498 m
.3976 .11801 L
s
.44814 .09421 m
.45059 .09729 L
s
.50225 .07302 m
.50464 .07615 L
s
.09737 .23156 m
.10019 .23431 L
s
.05093 .24975 m
.05379 .25245 L
s
.61378 .02935 m
.61603 .03258 L
s
.67126 .00684 m
.67344 .01012 L
s
.25 Mabswid
.68874 0 m
.96935 .42924 L
s
.72377 .05359 m
.71764 .05592 L
s
[(-5)] .73604 .04893 -1 .37976 Mshowa
.84407 .23761 m
.83786 .23973 L
s
[(0)] .8565 .23339 -1 .34028 Mshowa
.94552 .3928 m
.93925 .39473 L
s
[(5)] .95806 .38893 -1 .30824 Mshowa
.125 Mabswid
.74959 .09308 m
.7459 .09445 L
s
.77448 .13116 m
.77078 .1325 L
s
.79849 .16789 m
.79478 .16921 L
s
.82168 .20336 m
.81796 .20465 L
s
.86572 .27073 m
.86199 .27197 L
s
.88666 .30275 m
.88291 .30397 L
s
.90691 .33374 m
.90316 .33494 L
s
.92653 .36374 m
.92277 .36492 L
s
.69697 .0126 m
.69331 .01403 L
s
.96393 .42096 m
.96017 .4221 L
s
.25 Mabswid
.03716 .25514 m
0 .48963 L
s
.03455 .27159 m
.04067 .26922 L
s
[(0)] .02232 .27634 1 -0.38849 Mshowa
.02622 .32417 m
.03236 .32185 L
s
[(5)] .01395 .32882 1 -0.37862 Mshowa
.0176 .37857 m
.02376 .3763 L
s
[(10)] .00529 .38311 1 -0.36838 Mshowa
.00868 .43488 m
.01485 .43267 L
s
[(15)] -0.00368 .4393 1 -0.35774 Mshowa
.125 Mabswid
.03291 .28197 m
.03658 .28055 L
s
.03125 .29241 m
.03493 .291 L
s
.02959 .30293 m
.03326 .30152 L
s
.02791 .31351 m
.03159 .31211 L
s
.02452 .3349 m
.0282 .33352 L
s
.02281 .34571 m
.02649 .34433 L
s
.02108 .35659 m
.02477 .35521 L
s
.01935 .36754 m
.02304 .36617 L
s
.01584 .38968 m
.01954 .38832 L
s
.01407 .40086 m
.01777 .39951 L
s
.01228 .41212 m
.01598 .41078 L
s
.01049 .42346 m
.01419 .42213 L
s
.03619 .26129 m
.03985 .25985 L
s
.00685 .44638 m
.01056 .44507 L
s
.00502 .45797 m
.00873 .45666 L
s
.00317 .46963 m
.00688 .46833 L
s
.00131 .48138 m
.00502 .48008 L
s
.25 Mabswid
.03716 .25514 m
0 .48963 L
s
0 .48963 m
.39787 .81114 L
s
.39787 .81114 m
.40529 .59895 L
s
.40529 .59895 m
.03716 .25514 L
s
.68874 0 m
.96935 .42924 L
s
.96935 .42924 m
1 .6535 L
s
1 .6535 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.03716 .25514 m
0 .48963 L
s
0 .48963 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.68874 0 m
.03716 .25514 L
s
.40529 .59895 m
.96935 .42924 L
s
.96935 .42924 m
1 .6535 L
s
1 .6535 m
.39787 .81114 L
s
.39787 .81114 m
.40529 .59895 L
s
0 0 m
1 0 L
1 .81114 L
0 .81114 L
closepath
clip
newpath
.01 w
.56166 .57477 Mdot
.52705 .6089 Mdot
.54437 .59332 Mdot
.57903 .56297 Mdot
.50972 .62689 Mdot
.5964 .54918 Mdot
.49235 .6475 Mdot
.53972 .58662 Mdot
.55709 .57249 Mdot
.57448 .55813 Mdot
.61395 .54115 Mdot
.52235 .60633 Mdot
.50497 .62311 Mdot
.47491 .66981 Mdot
.59192 .54542 Mdot
.63153 .5317 Mdot
.48752 .64523 Mdot
.4574 .69196 Mdot
.51763 .59956 Mdot
.53505 .58479 Mdot
.55248 .56939 Mdot
.47005 .66473 Mdot
.60951 .53701 Mdot
.56993 .5549 Mdot
.50017 .62095 Mdot
.64922 .5233 Mdot
.48271 .63829 Mdot
.58744 .5429 Mdot
.43976 .71751 Mdot
.45249 .68687 Mdot
.62713 .52728 Mdot
.53035 .57978 Mdot
.60498 .53052 Mdot
.54783 .56457 Mdot
.56533 .55033 Mdot
.51286 .59929 Mdot
.46512 .6623 Mdot
.49535 .6168 Mdot
.64488 .51911 Mdot
.66715 .51836 Mdot
.47782 .63529 Mdot
.58291 .53973 Mdot
.4475 .68369 Mdot
.43472 .71494 Mdot
.42194 .7459 Mdot
.62273 .52387 Mdot
.54316 .56117 Mdot
.46021 .65673 Mdot
.52562 .57859 Mdot
.60057 .52999 Mdot
.50807 .59563 Mdot
.56072 .54744 Mdot
.66277 .51235 Mdot
.68511 .51173 Mdot
.49049 .61415 Mdot
.64054 .51604 Mdot
.41688 .74129 Mdot
.40405 .77297 Mdot
.57836 .53706 Mdot
.47287 .63395 Mdot
.42964 .71251 Mdot
.61832 .52092 Mdot
.44243 .68289 Mdot
.596 .52346 Mdot
.50325 .59115 Mdot
.6808 .5065 Mdot
.65843 .50781 Mdot
.53846 .56034 Mdot
.52085 .57659 Mdot
.45515 .65704 Mdot
.55609 .54558 Mdot
.70334 .50825 Mdot
.4856 .61159 Mdot
.39892 .76865 Mdot
.57373 .53135 Mdot
.63618 .51304 Mdot
.41171 .73957 Mdot
.61382 .51604 Mdot
.42455 .70906 Mdot
.43741 .67826 Mdot
.4679 .63188 Mdot
.5915 .52222 Mdot
.53372 .55594 Mdot
.65408 .50366 Mdot
.45017 .65199 Mdot
.51605 .57275 Mdot
.67658 .50364 Mdot
.4807 .60631 Mdot
.49837 .59017 Mdot
.5514 .542 Mdot
.40662 .7338 Mdot
.63173 .50822 Mdot
.69915 .50454 Mdot
.41946 .70457 Mdot
.39364 .7674 Mdot
.56914 .5302 Mdot
.46292 .62798 Mdot
.7219 .50781 Mdot
.60937 .51409 Mdot
.43228 .67664 Mdot
.5869 .51713 Mdot
.51122 .56857 Mdot
.4935 .58483 Mdot
.52895 .55237 Mdot
.64975 .5009 Mdot
.44507 .65063 Mdot
.62726 .5035 Mdot
.54669 .53875 Mdot
.67239 .50213 Mdot
.69496 .5013 Mdot
.40138 .73202 Mdot
.41431 .70091 Mdot
.47569 .60641 Mdot
.38839 .76459 Mdot
.60481 .50864 Mdot
.4579 .62474 Mdot
.42718 .67252 Mdot
.56449 .52759 Mdot
.71775 .50411 Mdot
.50636 .56471 Mdot
.74064 .50749 Mdot
.48856 .58289 Mdot
.52415 .55049 Mdot
.58236 .51691 Mdot
.66802 .4972 Mdot
.54195 .53507 Mdot
.6228 .50022 Mdot
.64543 .49922 Mdot
.43995 .64857 Mdot
.69068 .4968 Mdot
.39616 .7282 Mdot
.38315 .76037 Mdot
.40907 .69923 Mdot
.47069 .60385 Mdot
.71347 .49845 Mdot
.422 .66989 Mdot
.55981 .52465 Mdot
.45282 .62277 Mdot
.60032 .50782 Mdot
.57768 .51085 Mdot
.73657 .50422 Mdot
.43485 .64414 Mdot
.50145 .56381 Mdot
.48358 .58043 Mdot
.66369 .49389 Mdot
.5193 .54814 Mdot
.68641 .49299 Mdot
.64102 .49596 Mdot
.37784 .7571 Mdot
.61834 .49798 Mdot
.46569 .5988 Mdot
.53717 .53348 Mdot
.70922 .49372 Mdot
.75961 .50793 Mdot
.40379 .69731 Mdot
.39074 .72919 Mdot
.44773 .61906 Mdot
.41679 .66719 Mdot
.59573 .50434 Mdot
.55509 .52203 Mdot
.49653 .55807 Mdot
.57303 .50832 Mdot
.73242 .50019 Mdot
.51443 .54397 Mdot
.68209 .4888 Mdot
.42967 .6417 Mdot
.46065 .59402 Mdot
.65934 .49071 Mdot
.47857 .57848 Mdot
.53236 .52969 Mdot
.61381 .4945 Mdot
.6366 .4933 Mdot
.37244 .75519 Mdot
.39856 .69291 Mdot
.38547 .7248 Mdot
.70508 .49151 Mdot
.7556 .50486 Mdot
.59108 .49887 Mdot
.55032 .51741 Mdot
.7281 .49362 Mdot
.44255 .61801 Mdot
.41144 .66746 Mdot
.50954 .53836 Mdot
.49155 .55631 Mdot
.65487 .48545 Mdot
.47355 .57373 Mdot
.56835 .50662 Mdot
.52751 .52447 Mdot
.77897 .51085 Mdot
.63207 .48812 Mdot
.42441 .64032 Mdot
.67792 .48836 Mdot
.60928 .49217 Mdot
.75144 .49988 Mdot
.45549 .59437 Mdot
.3932 .69108 Mdot
.38006 .72297 Mdot
.36693 .75479 Mdot
.54552 .51253 Mdot
.58643 .49537 Mdot
.70094 .48987 Mdot
.43738 .6147 Mdot
.40617 .66411 Mdot
.72408 .49261 Mdot
.5636 .50164 Mdot
.50459 .53657 Mdot
.4685 .56985 Mdot
.48654 .5534 Mdot
.62755 .48416 Mdot
.41921 .63602 Mdot
.52263 .52165 Mdot
.77506 .50845 Mdot
.65054 .48447 Mdot
.45036 .59063 Mdot
.36152 .75119 Mdot
.5407 .50806 Mdot
.60469 .48896 Mdot
.38786 .68781 Mdot
.67359 .4854 Mdot
.74741 .4973 Mdot
.69661 .48519 Mdot
.37459 .72193 Mdot
.58178 .49328 Mdot
.48155 .54592 Mdot
.43217 .61151 Mdot
.49963 .53065 Mdot
.55882 .4964 Mdot
.7198 .48751 Mdot
.40085 .6611 Mdot
.46341 .56545 Mdot
.51772 .51576 Mdot
.79884 .51734 Mdot
.44526 .58395 Mdot
.66907 .4786 Mdot
.41391 .6335 Mdot
.62305 .48222 Mdot
.77107 .50545 Mdot
.53584 .50298 Mdot
.60004 .48415 Mdot
.35607 .7477 Mdot
.64612 .48194 Mdot
.74318 .49219 Mdot
.38244 .68534 Mdot
.42701 .60542 Mdot
.69231 .48163 Mdot
.36914 .7192 Mdot
.3956 .65524 Mdot
.49464 .52539 Mdot
.57707 .48991 Mdot
.47648 .5425 Mdot
.55401 .49188 Mdot
.51278 .5106 Mdot
.71557 .48393 Mdot
.45829 .56145 Mdot
.79475 .51217 Mdot
.76681 .49893 Mdot
.4086 .62999 Mdot
.61845 .47751 Mdot
.44003 .58171 Mdot
.6647 .47608 Mdot
.64159 .47737 Mdot
.42181 .59957 Mdot
.57226 .48168 Mdot
.59538 .48063 Mdot
.37708 .68076 Mdot
.73905 .48878 Mdot
.53095 .50065 Mdot
.39027 .65059 Mdot
.36371 .71504 Mdot
.48962 .5201 Mdot
.4532 .55368 Mdot
.35041 .74774 Mdot
.68799 .47834 Mdot
.4714 .5378 Mdot
.54917 .48724 Mdot
.43492 .57317 Mdot
.40339 .62289 Mdot
.5078 .50798 Mdot
.79077 .50849 Mdot
.71141 .48191 Mdot
.81904 .52458 Mdot
.41657 .59417 Mdot
.61383 .47358 Mdot
.56746 .47647 Mdot
.52603 .4947 Mdot
.7629 .49767 Mdot
.63707 .47397 Mdot
.59068 .47658 Mdot
.48458 .51392 Mdot
.66029 .47313 Mdot
.44802 .54934 Mdot
.34486 .74456 Mdot
.46627 .5334 Mdot
.68361 .47422 Mdot
.35817 .71253 Mdot
.37149 .68051 Mdot
.50281 .50019 Mdot
.42973 .56717 Mdot
.38476 .64946 Mdot
.54431 .48325 Mdot
.73507 .48846 Mdot
.39805 .61829 Mdot
.52108 .48661 Mdot
.70703 .47672 Mdot
.6324 .46687 Mdot
.81505 .52005 Mdot
.41125 .59007 Mdot
.5859 .47023 Mdot
.75866 .49226 Mdot
.7869 .50663 Mdot
.60917 .46923 Mdot
.4795 .50835 Mdot
.46118 .5256 Mdot
.65574 .46765 Mdot
.44285 .54324 Mdot
.53939 .47512 Mdot
.49779 .49358 Mdot
.56267 .47431 Mdot
.35274 .70709 Mdot
.73064 .48135 Mdot
.42448 .56182 Mdot
.33932 .74051 Mdot
.37941 .64374 Mdot
.36604 .67612 Mdot
.39276 .61173 Mdot
.67918 .46998 Mdot
.5161 .48009 Mdot
.78257 .49934 Mdot
.5811 .46359 Mdot
.40594 .58459 Mdot
.70274 .47345 Mdot
.83936 .52997 Mdot
.81112 .51653 Mdot
.47437 .50373 Mdot
.7545 .48829 Mdot
.43763 .5375 Mdot
.5578 .46765 Mdot
.49274 .48718 Mdot
.6045 .46542 Mdot
.62785 .4643 Mdot
.45599 .52141 Mdot
.34724 .70215 Mdot
.65123 .46381 Mdot
.53446 .4703 Mdot
.37402 .63795 Mdot
.3606 .67075 Mdot
.41918 .55716 Mdot
.33376 .73609 Mdot
.51109 .4742 Mdot
.38733 .60783 Mdot
.40068 .57716 Mdot
.67479 .46704 Mdot
.72655 .48012 Mdot
.43244 .52972 Mdot
.57629 .4584 Mdot
.55289 .45979 Mdot
.46926 .4962 Mdot
.80688 .50966 Mdot
.59971 .45807 Mdot
.45083 .5139 Mdot
.36869 .63013 Mdot
.62314 .45772 Mdot
.6984 .46995 Mdot
.34177 .69614 Mdot
.48764 .48246 Mdot
.5295 .46475 Mdot
.64663 .45834 Mdot
.35514 .66505 Mdot
.41389 .55085 Mdot
.77877 .49908 Mdot
.382 .60055 Mdot
.32823 .73056 Mdot
.83568 .52842 Mdot
.75045 .48623 Mdot
.50605 .46941 Mdot
.39531 .57166 Mdot
.44568 .50543 Mdot
.46412 .48943 Mdot
.59489 .45052 Mdot
.42718 .52369 Mdot
.57144 .45228 Mdot
.67037 .46417 Mdot
.54798 .45536 Mdot
.61842 .45156 Mdot
.5245 .45712 Mdot
.3632 .6252 Mdot
.72238 .47814 Mdot
.40861 .54356 Mdot
.48253 .4761 Mdot
.34964 .65943 Mdot
.33616 .69204 Mdot
.8315 .52161 Mdot
.37654 .59565 Mdot
.64203 .45379 Mdot
.80314 .50899 Mdot
.44048 .49748 Mdot
.50099 .46268 Mdot
.77468 .4955 Mdot
.69415 .46874 Mdot
.7462 .48181 Mdot
.38993 .56546 Mdot
.47745 .46563 Mdot
.32241 .72935 Mdot
.42191 .51678 Mdot
.45892 .48363 Mdot
.86056 .54153 Mdot
.5901 .44509 Mdot
.56656 .44676 Mdot
.51948 .44939 Mdot
.54302 .44827 Mdot
.66575 .45743 Mdot
.40332 .53597 Mdot
.35773 .61927 Mdot
.71796 .47245 Mdot
.34416 .65303 Mdot
.61371 .44676 Mdot
.49592 .45343 Mdot
.37113 .58897 Mdot
.38464 .55647 Mdot
.45378 .47355 Mdot
.43523 .49058 Mdot
.68952 .46084 Mdot
.33049 .68844 Mdot
.63738 .44857 Mdot
.77041 .48985 Mdot
.53803 .43915 Mdot
.39804 .52713 Mdot
.56163 .43816 Mdot
.4166 .51015 Mdot
.58522 .43716 Mdot
.79912 .50538 Mdot
.82774 .51982 Mdot
.31679 .72412 Mdot
.47227 .46055 Mdot
.35231 .61147 Mdot
.33876 .64437 Mdot
.74198 .47819 Mdot
.51444 .44334 Mdot
.3251 .67915 Mdot
.66118 .45253 Mdot
.36574 .58119 Mdot
.43001 .482 Mdot
.85684 .539 Mdot
.71354 .46716 Mdot
.49079 .44795 Mdot
.41136 .50063 Mdot
.44856 .46659 Mdot
.37918 .55102 Mdot
.60898 .44238 Mdot
.63264 .44163 Mdot
.53303 .43129 Mdot
.46713 .45124 Mdot
.55668 .43048 Mdot
.39266 .52045 Mdot
.50938 .43397 Mdot
.68506 .45658 Mdot
.31116 .71826 Mdot
.82362 .51423 Mdot
.34677 .60557 Mdot
.48569 .43775 Mdot
.36034 .57307 Mdot
.58039 .43266 Mdot
.79506 .50168 Mdot
.76634 .48728 Mdot
.3331 .63992 Mdot
.65654 .44657 Mdot
.85266 .53199 Mdot
.44333 .45861 Mdot
.40603 .49308 Mdot
.37379 .54324 Mdot
.31938 .67508 Mdot
.60415 .43489 Mdot
.42462 .47776 Mdot
.528 .42438 Mdot
.73789 .4771 Mdot
.70913 .46266 Mdot
.38727 .51317 Mdot
.46188 .44596 Mdot
.55172 .42507 Mdot
.88193 .55151 Mdot
.57545 .42392 Mdot
.35492 .5648 Mdot
.30548 .7129 Mdot
.6805 .45099 Mdot
.32764 .63143 Mdot
.34125 .59869 Mdot
.50427 .42896 Mdot
.628 .43841 Mdot
.36845 .53353 Mdot
.59923 .425 Mdot
.4805 .43234 Mdot
.43804 .45174 Mdot
.31378 .66837 Mdot
.40062 .48694 Mdot
.41931 .47024 Mdot
.81985 .51283 Mdot
.45669 .43661 Mdot
.79107 .49905 Mdot
.65194 .44251 Mdot
.49916 .41906 Mdot
.8488 .52862 Mdot
.38183 .5062 Mdot
.54672 .41688 Mdot
.73346 .47111 Mdot
.76232 .48576 Mdot
.52294 .41853 Mdot
.33579 .59016 Mdot
.34943 .55725 Mdot
.29989 .70541 Mdot
.57052 .41727 Mdot
.62322 .43198 Mdot
.87805 .54695 Mdot
.41404 .46028 Mdot
.70482 .46036 Mdot
.32192 .62697 Mdot
.59437 .41847 Mdot
.30819 .66102 Mdot
.4753 .42594 Mdot
.676 .44736 Mdot
.36282 .52968 Mdot
.45146 .42829 Mdot
.54168 .40772 Mdot
.43268 .44653 Mdot
.39517 .48099 Mdot
.37637 .49929 Mdot
.51785 .41115 Mdot
.61832 .42194 Mdot
.64726 .43682 Mdot
.29422 .69879 Mdot
.494 .41358 Mdot
.31646 .61751 Mdot
.81583 .509 Mdot
.84477 .52362 Mdot
.47014 .4153 Mdot
.56556 .41002 Mdot
.75798 .48023 Mdot
.3301 .58521 Mdot
.78695 .49525 Mdot
.30271 .6516 Mdot
.58944 .41001 Mdot
.34372 .55333 Mdot
.72914 .46732 Mdot
.35738 .52092 Mdot
.42743 .43637 Mdot
.40864 .45378 Mdot
.53663 .39929 Mdot
.38979 .47253 Mdot
.51275 .40117 Mdot
.70036 .45602 Mdot
.44614 .42221 Mdot
.67142 .44249 Mdot
.37087 .49227 Mdot
.32459 .57645 Mdot
.87454 .54615 Mdot
.56056 .40214 Mdot
.64251 .43009 Mdot
.28846 .69297 Mdot
.61351 .41601 Mdot
.48881 .407 Mdot
.46489 .40838 Mdot
.31069 .61251 Mdot
.78264 .48932 Mdot
.81169 .50414 Mdot
.35186 .51345 Mdot
.33812 .54671 Mdot
.75364 .4751 Mdot
.69562 .44682 Mdot
.90405 .56522 Mdot
.58455 .40457 Mdot
.29681 .64808 Mdot
.72471 .46217 Mdot
.66661 .43299 Mdot
.40316 .44834 Mdot
.42201 .43112 Mdot
.84104 .52208 Mdot
.31906 .56779 Mdot
.5076 .39501 Mdot
.60856 .40596 Mdot
.53157 .39421 Mdot
.28287 .68411 Mdot
.38423 .4676 Mdot
.36533 .48568 Mdot
.55554 .39393 Mdot
.30516 .60329 Mdot
.63771 .42275 Mdot
.4836 .39977 Mdot
.45961 .4012 Mdot
.44073 .41858 Mdot
.33255 .53895 Mdot
.57956 .39527 Mdot
.87069 .54238 Mdot
.29118 .6399 Mdot
.74927 .46997 Mdot
.77843 .48496 Mdot
.52646 .38588 Mdot
.90021 .56066 Mdot
.37877 .45951 Mdot
.34607 .51034 Mdot
.6911 .44246 Mdot
.47841 .38931 Mdot
.80774 .50168 Mdot
.55049 .3858 Mdot
.63283 .41389 Mdot
.43545 .40859 Mdot
.39763 .44336 Mdot
.662 .42875 Mdot
.72032 .45831 Mdot
.27704 .67841 Mdot
.50242 .38961 Mdot
.31325 .56299 Mdot
.29945 .59643 Mdot
.41649 .42744 Mdot
.83709 .51849 Mdot
.60374 .40144 Mdot
.32693 .53168 Mdot
.57457 .38759 Mdot
.35964 .48127 Mdot
.28546 .63268 Mdot
.86672 .5376 Mdot
.45421 .39812 Mdot
.7156 .44923 Mdot
.34049 .5027 Mdot
.49724 .38005 Mdot
.65719 .42044 Mdot
.52133 .37903 Mdot
.41113 .41814 Mdot
.37321 .45312 Mdot
.68645 .43585 Mdot
.39216 .43599 Mdot
.74493 .46557 Mdot
.27125 .67156 Mdot
.54543 .37894 Mdot
.62801 .40732 Mdot
.59878 .39269 Mdot
.43003 .40285 Mdot
.27984 .62354 Mdot
.80356 .49689 Mdot
.29362 .59091 Mdot
.32128 .52429 Mdot
.77438 .4831 Mdot
.47309 .3857 Mdot
.30739 .55847 Mdot
.56958 .38095 Mdot
.89676 .55986 Mdot
.44892 .38897 Mdot
.62302 .39608 Mdot
.35393 .47649 Mdot
.83318 .51565 Mdot
.59378 .38305 Mdot
.65239 .41301 Mdot
.33481 .49619 Mdot
.26544 .66464 Mdot
.49201 .37414 Mdot
.68177 .42931 Mdot
.38661 .42963 Mdot
.51617 .37339 Mdot
.74048 .45997 Mdot
.54034 .37282 Mdot
.30173 .55033 Mdot
.86303 .53598 Mdot
.56453 .3724 Mdot
.27394 .61795 Mdot
.3675 .44904 Mdot
.28781 .58457 Mdot
.71125 .44697 Mdot
.40551 .41532 Mdot
.34839 .46792 Mdot
.31546 .51905 Mdot
.46777 .37951 Mdot
.92719 .5844 Mdot
.79944 .49314 Mdot
.61814 .38907 Mdot
.89277 .5544 Mdot
.42448 .40002 Mdot
.77017 .47953 Mdot
.25969 .65638 Mdot
.64758 .40573 Mdot
.82905 .51064 Mdot
.53521 .36327 Mdot
.48676 .36644 Mdot
.51098 .36544 Mdot
.44345 .38579 Mdot
.67704 .42213 Mdot
.58885 .37792 Mdot
.32898 .49155 Mdot
.28209 .57639 Mdot
.55947 .36487 Mdot
.26807 .61148 Mdot
.70657 .43933 Mdot
.40005 .40715 Mdot
.36184 .443 Mdot
.29578 .546 Mdot
.38088 .42648 Mdot
.76559 .47144 Mdot
.64266 .39612 Mdot
.85911 .53223 Mdot
.46241 .37371 Mdot
.41904 .39262 Mdot
.92322 .57845 Mdot
.34263 .46274 Mdot
.7362 .45746 Mdot
.58381 .36849 Mdot
.6722 .41305 Mdot
.61328 .38379 Mdot
.30943 .51648 Mdot
.25362 .65189 Mdot
.88898 .55102 Mdot
.79545 .49133 Mdot
.43801 .37994 Mdot
.50576 .35978 Mdot
.53007 .35853 Mdot
.82504 .50727 Mdot
.70187 .43178 Mdot
.55439 .35778 Mdot
.32315 .48639 Mdot
.73144 .44773 Mdot
.60825 .37314 Mdot
.4814 .36415 Mdot
.35611 .43756 Mdot
.27591 .574 Mdot
.45706 .36619 Mdot
.37525 .42035 Mdot
.24796 .64181 Mdot
.26188 .60864 Mdot
.28981 .54119 Mdot
.63785 .39049 Mdot
.39435 .40402 Mdot
.85503 .52712 Mdot
.76123 .46657 Mdot
.5788 .36233 Mdot
.66748 .40735 Mdot
.41344 .38865 Mdot
.30358 .51039 Mdot
.91958 .57546 Mdot
.50051 .3521 Mdot
.79114 .48593 Mdot
.43254 .37375 Mdot
.33658 .46189 Mdot
.69724 .42593 Mdot
.4761 .35584 Mdot
.31731 .48068 Mdot
.54928 .35211 Mdot
.25611 .5998 Mdot
.63288 .38057 Mdot
.60328 .36586 Mdot
.52489 .35411 Mdot
.66251 .3964 Mdot
.88537 .54946 Mdot
.82097 .50357 Mdot
.72699 .44345 Mdot
.28396 .53421 Mdot
.24193 .63595 Mdot
.26988 .5691 Mdot
.36951 .41561 Mdot
.6923 .41475 Mdot
.9503 .59965 Mdot
.57376 .35617 Mdot
.75686 .46199 Mdot
.85104 .5232 Mdot
.38866 .39983 Mdot
.91567 .57038 Mdot
.45153 .36447 Mdot
.35011 .43666 Mdot
.29758 .50608 Mdot
.40782 .38412 Mdot
.54414 .34488 Mdot
.49521 .34763 Mdot
.62799 .37399 Mdot
.51967 .34692 Mdot
.72228 .43529 Mdot
.59831 .35928 Mdot
.42699 .36882 Mdot
.33068 .45746 Mdot
.26405 .56096 Mdot
.88128 .54377 Mdot
.24993 .59579 Mdot
.78703 .48341 Mdot
.31128 .47718 Mdot
.81682 .49935 Mdot
.56866 .34732 Mdot
.65781 .39222 Mdot
.68753 .40721 Mdot
.47066 .35329 Mdot
.27785 .5303 Mdot
.2356 .63304 Mdot
.94643 .59425 Mdot
.38301 .39339 Mdot
.75247 .45752 Mdot
.44608 .35821 Mdot
.65278 .38067 Mdot
.3443 .43107 Mdot
.59326 .35097 Mdot
.62303 .3661 Mdot
.36357 .41412 Mdot
.91189 .56667 Mdot
.84713 .52045 Mdot
.51443 .3397 Mdot
.29152 .50178 Mdot
.32492 .4501 Mdot
.40214 .37995 Mdot
.48987 .34202 Mdot
.71768 .42948 Mdot
.78265 .47789 Mdot
.53898 .34165 Mdot
.42137 .36493 Mdot
.24372 .59153 Mdot
.87737 .53987 Mdot
.22959 .62599 Mdot
.30528 .4727 Mdot
.68287 .40221 Mdot
.74776 .44873 Mdot
.25765 .55953 Mdot
.46523 .34825 Mdot
.27174 .5257 Mdot
.56358 .34296 Mdot
.81275 .49623 Mdot
.71283 .4197 Mdot
.61807 .35889 Mdot
.44057 .3523 Mdot
.94284 .59124 Mdot
.37717 .39063 Mdot
.64799 .37561 Mdot
.58826 .34594 Mdot
.67789 .39133 Mdot
.77802 .46935 Mdot
.31894 .44562 Mdot
.3577 .41028 Mdot
.84313 .51704 Mdot
.50914 .33542 Mdot
.33829 .42837 Mdot
.90828 .5646 Mdot
.53377 .33495 Mdot
.2853 .49923 Mdot
.39639 .37651 Mdot
.55844 .33522 Mdot
.48446 .33953 Mdot
.4598 .3412 Mdot
.7432 .44248 Mdot
.22326 .62208 Mdot
.70807 .41175 Mdot
.23736 .58847 Mdot
.61307 .35145 Mdot
.80849 .49138 Mdot
.41565 .36281 Mdot
.25138 .5559 Mdot
.29912 .46969 Mdot
.64306 .3679 Mdot
.87379 .53948 Mdot
.97429 .61849 Mdot
.9391 .58723 Mdot
.26528 .52505 Mdot
.58322 .34053 Mdot
.35192 .40365 Mdot
.67315 .38593 Mdot
.77367 .46495 Mdot
.90417 .55837 Mdot
.83896 .51212 Mdot
.27928 .49313 Mdot
.50381 .33012 Mdot
.4349 .35086 Mdot
.37123 .38874 Mdot
.70328 .40388 Mdot
.3323 .42454 Mdot
.73856 .43556 Mdot
.52854 .33099 Mdot
.55328 .32966 Mdot
.47904 .33473 Mdot
.63809 .35949 Mdot
.39058 .37348 Mdot
.31266 .445 Mdot
.23109 .58382 Mdot
.21687 .61832 Mdot
.29309 .46418 Mdot
.24518 .55087 Mdot
.86956 .53309 Mdot
.80421 .48651 Mdot
.60812 .34676 Mdot
.57808 .33188 Mdot
.76896 .45598 Mdot
.45422 .33929 Mdot
.66827 .37809 Mdot
.40994 .35896 Mdot
.25919 .51898 Mdot
.93542 .58395 Mdot
.73382 .42734 Mdot
.42934 .34402 Mdot
.69852 .39683 Mdot
.49845 .32445 Mdot
.9711 .61804 Mdot
.34591 .40068 Mdot
.83486 .50823 Mdot
.36542 .38303 Mdot
.38492 .36578 Mdot
.63312 .35209 Mdot
.90047 .55603 Mdot
.52326 .32553 Mdot
.27293 .49092 Mdot
.32625 .42068 Mdot
.66329 .36866 Mdot
.79968 .47909 Mdot
.30659 .44053 Mdot
.47357 .33035 Mdot
.2247 .58 Mdot
.21041 .61476 Mdot
.54811 .32677 Mdot
.76443 .44966 Mdot
.60311 .34094 Mdot
.729 .41816 Mdot
.44869 .33313 Mdot
.40426 .35294 Mdot
.86559 .52955 Mdot
.28688 .46067 Mdot
.23875 .54798 Mdot
.57299 .32774 Mdot
.25297 .51402 Mdot
.69371 .38943 Mdot
.96707 .61128 Mdot
.93165 .58012 Mdot
.83048 .50154 Mdot
.33997 .39549 Mdot
.65838 .36121 Mdot
.42364 .34066 Mdot
.26684 .48466 Mdot
.32032 .41426 Mdot
.35952 .37835 Mdot
.6282 .34692 Mdot
.51794 .3197 Mdot
.79527 .47329 Mdot
.598 .33241 Mdot
.72425 .4105 Mdot
.49302 .32211 Mdot
.75985 .44312 Mdot
.20397 .61051 Mdot
.46806 .32572 Mdot
.30043 .43646 Mdot
.54288 .32168 Mdot
.89695 .55559 Mdot
.68885 .38142 Mdot
.21821 .57674 Mdot
.37889 .3653 Mdot
.56783 .3211 Mdot
.39852 .34751 Mdot
.86155 .52548 Mdot
.23225 .54522 Mdot
.2805 .45852 Mdot
.44301 .33143 Mdot
.92788 .57647 Mdot
.79068 .4656 Mdot
.2464 .51274 Mdot
.65348 .35478 Mdot
.62318 .3396 Mdot
.82634 .49776 Mdot
.71946 .4026 Mdot
.96363 .60932 Mdot
.31421 .41 Mdot
.75526 .43668 Mdot
.68394 .37303 Mdot
.33383 .3929 Mdot
.51259 .31523 Mdot
.3535 .37507 Mdot
.26039 .48239 Mdot
.5376 .31481 Mdot
.41784 .33846 Mdot
.59298 .32917 Mdot
.89284 .55001 Mdot
.48756 .31844 Mdot
.46253 .31995 Mdot
.37304 .3599 Mdot
.21173 .57275 Mdot
.29421 .43272 Mdot
.19733 .6078 Mdot
.56266 .31693 Mdot
.75032 .42563 Mdot
.7146 .39377 Mdot
.61813 .3321 Mdot
.85762 .5228 Mdot
.82191 .49113 Mdot
.22577 .54159 Mdot
.27426 .45401 Mdot
.39256 .34611 Mdot
.95971 .60375 Mdot
.64862 .34997 Mdot
.78634 .46128 Mdot
.67904 .36534 Mdot
.43732 .32785 Mdot
.5878 .32005 Mdot
.92417 .57362 Mdot
.23982 .5107 Mdot
.41215 .33191 Mdot
.30802 .40623 Mdot
.48209 .31166 Mdot
.50719 .31075 Mdot
.88874 .54474 Mdot
.32767 .38974 Mdot
.34743 .37176 Mdot
.70976 .38575 Mdot
.45694 .31526 Mdot
.25388 .48004 Mdot
.74568 .41918 Mdot
.28803 .42755 Mdot
.5323 .31297 Mdot
.19064 .60499 Mdot
.85337 .51719 Mdot
.36703 .35693 Mdot
.81753 .48531 Mdot
.20496 .57126 Mdot
.21938 .53649 Mdot
.64364 .3428 Mdot
.38676 .34009 Mdot
.78179 .45479 Mdot
.67417 .35868 Mdot
.61315 .32826 Mdot
.55747 .31488 Mdot
.43164 .32242 Mdot
.95613 .60104 Mdot
.26777 .45192 Mdot
.23338 .5065 Mdot
.40634 .32736 Mdot
.32166 .38339 Mdot
.77685 .44353 Mdot
.92062 .5723 Mdot
.30182 .40184 Mdot
.24768 .47336 Mdot
.74096 .41197 Mdot
.58273 .31853 Mdot
.47654 .30776 Mdot
.34141 .36667 Mdot
.81294 .47734 Mdot
.70509 .38123 Mdot
.50174 .30723 Mdot
.36114 .35044 Mdot
.66921 .35067 Mdot
.28168 .42409 Mdot
.88515 .54455 Mdot
.8492 .51267 Mdot
.52696 .30853 Mdot
.19838 .56724 Mdot
.63869 .33764 Mdot
.45122 .31387 Mdot
.73599 .40143 Mdot
.18373 .60386 Mdot
.60811 .32389 Mdot
.38078 .33676 Mdot
.2615 .44636 Mdot
.55222 .31086 Mdot
.21253 .53578 Mdot
.95243 .59759 Mdot
.42586 .3191 Mdot
.22695 .50158 Mdot
.70021 .37339 Mdot
.9166 .56721 Mdot
.77236 .43823 Mdot
.31554 .3781 Mdot
.57755 .31295 Mdot
.84462 .50423 Mdot
.24122 .46928 Mdot
.80857 .4723 Mdot
.40045 .32376 Mdot
.47095 .30353 Mdot
.88091 .53844 Mdot
.33525 .36302 Mdot
.63361 .32951 Mdot
.29537 .40017 Mdot
.35513 .34555 Mdot
.44559 .3071 Mdot
.27535 .41967 Mdot
.6644 .34685 Mdot
.49624 .30477 Mdot
.52156 .30396 Mdot
.19179 .56264 Mdot
.60299 .31761 Mdot
.25525 .44004 Mdot
.73139 .39679 Mdot
.37488 .33095 Mdot
.76758 .42968 Mdot
.17699 .60041 Mdot
.54692 .30515 Mdot
.20606 .53037 Mdot
.42012 .31269 Mdot
.22049 .49643 Mdot
.69538 .36698 Mdot
.91262 .5627 Mdot
.84024 .49796 Mdot
.80406 .46575 Mdot
.9489 .59577 Mdot
.30934 .37336 Mdot
.39461 .31788 Mdot
.65934 .33792 Mdot
.87664 .53237 Mdot
.3292 .35681 Mdot
.57235 .30911 Mdot
.28921 .39376 Mdot
.72644 .38706 Mdot
.62859 .32389 Mdot
.23461 .46627 Mdot
.46533 .29887 Mdot
.269 .41493 Mdot
.34901 .34165 Mdot
.76288 .42228 Mdot
.49071 .29996 Mdot
.69038 .35791 Mdot
.41438 .30535 Mdot
.4398 .30458 Mdot
.51613 .30038 Mdot
.19954 .52494 Mdot
.24876 .43603 Mdot
.18487 .56091 Mdot
.79941 .45801 Mdot
.36882 .32723 Mdot
.59791 .31468 Mdot
.83578 .49125 Mdot
.54158 .30062 Mdot
.17017 .59722 Mdot
.94497 .59087 Mdot
.30312 .36816 Mdot
.32315 .34997 Mdot
.2137 .49435 Mdot
.72164 .38009 Mdot
.87247 .52743 Mdot
.75802 .41309 Mdot
.34313 .33285 Mdot
.22816 .46076 Mdot
.28288 .38897 Mdot
.90901 .56158 Mdot
.3886 .31465 Mdot
.48517 .2923 Mdot
.6545 .33484 Mdot
.56712 .30522 Mdot
.68548 .35121 Mdot
.79464 .44891 Mdot
.2626 .41005 Mdot
.45963 .29561 Mdot
.62363 .32168 Mdot
.51066 .29421 Mdot
.16366 .59053 Mdot
.36289 .32017 Mdot
.59271 .30782 Mdot
.19288 .52044 Mdot
.43404 .29947 Mdot
.24225 .4316 Mdot
.40846 .30195 Mdot
.71672 .37164 Mdot
.83149 .48654 Mdot
.17802 .55789 Mdot
.75321 .40503 Mdot
.5362 .2964 Mdot
.38283 .30519 Mdot
.20721 .48841 Mdot
.86813 .52104 Mdot
.31698 .34432 Mdot
.29686 .36277 Mdot
.90474 .55497 Mdot
.33703 .32712 Mdot
.94131 .58838 Mdot
.22169 .45504 Mdot
.78994 .44105 Mdot
.25647 .40145 Mdot
.64946 .32784 Mdot
.27658 .38329 Mdot
.56182 .29976 Mdot
.82672 .47692 Mdot
.35695 .31239 Mdot
.68065 .34667 Mdot
.61852 .31543 Mdot
.7483 .39564 Mdot
.50515 .28783 Mdot
.40266 .29382 Mdot
.17158 .55039 Mdot
.45389 .29169 Mdot
.47951 .29043 Mdot
.42825 .29345 Mdot
.18622 .51544 Mdot
.29084 .35348 Mdot
.23577 .42624 Mdot
.71192 .36566 Mdot
.27059 .37297 Mdot
.15658 .58867 Mdot
.78517 .43252 Mdot
.58755 .30489 Mdot
.86388 .51582 Mdot
.31081 .33795 Mdot
.2502 .394 Mdot
.20047 .48454 Mdot
.53078 .29254 Mdot
.37675 .30143 Mdot
.21506 .45041 Mdot
.6756 .338 Mdot
.33077 .32316 Mdot
.90096 .55297 Mdot
.74349 .38811 Mdot
.44823 .2828 Mdot
.93768 .58645 Mdot
.64452 .32424 Mdot
.47391 .28227 Mdot
.82237 .47213 Mdot
.61338 .30994 Mdot
.5565 .2963 Mdot
.39675 .28787 Mdot
.22937 .41952 Mdot
.17961 .50946 Mdot
.35077 .30843 Mdot
.3048 .32857 Mdot
.78041 .42446 Mdot
.42241 .2878 Mdot
.70709 .3597 Mdot
.14991 .58252 Mdot
.28446 .34853 Mdot
.37092 .29169 Mdot
.85941 .50868 Mdot
.26415 .36781 Mdot
.19409 .47657 Mdot
.32487 .31262 Mdot
.49957 .28578 Mdot
.16444 .54904 Mdot
.5823 .29995 Mdot
.20856 .44397 Mdot
.89664 .54636 Mdot
.9334 .57929 Mdot
.81765 .46353 Mdot
.73865 .38065 Mdot
.52531 .2881 Mdot
.24348 .39118 Mdot
.34487 .29849 Mdot
.39083 .28085 Mdot
.85474 .49982 Mdot
.63949 .31956 Mdot
.67082 .336 Mdot
.60822 .3047 Mdot
.55112 .29055 Mdot
.44239 .27938 Mdot
.41658 .28089 Mdot
.77578 .41835 Mdot
.22278 .41429 Mdot
.18761 .46913 Mdot
.7022 .35321 Mdot
.29847 .32322 Mdot
.17275 .50537 Mdot
.2781 .34257 Mdot
.49398 .27829 Mdot
.25776 .3615 Mdot
.46816 .27991 Mdot
.14301 .57806 Mdot
.23736 .38103 Mdot
.36478 .28715 Mdot
.81291 .45489 Mdot
.3186 .30746 Mdot
.20211 .43653 Mdot
.15763 .54405 Mdot
.5198 .2794 Mdot
.89225 .53929 Mdot
.77069 .40659 Mdot
.57702 .295 Mdot
.734 .37627 Mdot
.27208 .33185 Mdot
.41078 .2716 Mdot
.33867 .29319 Mdot
.66572 .32769 Mdot
.29238 .31398 Mdot
.21641 .4062 Mdot
.2516 .35191 Mdot
.38484 .27457 Mdot
.80796 .44416 Mdot
.9298 .57797 Mdot
.31266 .29667 Mdot
.69722 .34552 Mdot
.18107 .4619 Mdot
.16617 .49818 Mdot
.85052 .49563 Mdot
.46248 .27154 Mdot
.43658 .27298 Mdot
.54569 .28512 Mdot
.63448 .31625 Mdot
.2309 .37416 Mdot
.19563 .42888 Mdot
.35872 .28028 Mdot
.48834 .27325 Mdot
.6031 .30243 Mdot
.15083 .5384 Mdot
.21028 .39517 Mdot
.88798 .53351 Mdot
.13572 .57645 Mdot
.76609 .40145 Mdot
.24538 .34262 Mdot
.51425 .27505 Mdot
.33257 .28543 Mdot
.37893 .26577 Mdot
.43084 .26305 Mdot
.72919 .3701 Mdot
.57171 .29121 Mdot
.28603 .30772 Mdot
.92554 .57143 Mdot
.84593 .48793 Mdot
.26558 .32662 Mdot
.80336 .43761 Mdot
.40481 .26626 Mdot
.30637 .29033 Mdot
.35274 .27132 Mdot
.14437 .52945 Mdot
.18911 .42133 Mdot
.45671 .26562 Mdot
.15925 .49363 Mdot
.6293 .30943 Mdot
.2244 .36732 Mdot
.54023 .27969 Mdot
.17406 .45862 Mdot
.66087 .32602 Mdot
.32658 .27535 Mdot
.25958 .31479 Mdot
.69252 .34376 Mdot
.20369 .38862 Mdot
.88364 .5273 Mdot
.48265 .26804 Mdot
.76134 .39484 Mdot
.12878 .57121 Mdot
.84117 .47878 Mdot
.2389 .33584 Mdot
.59789 .29868 Mdot
.27983 .29892 Mdot
.30029 .28058 Mdot
.37288 .25894 Mdot
.50866 .26915 Mdot
.72431 .36332 Mdot
.56632 .28437 Mdot
.39888 .25854 Mdot
.42492 .25754 Mdot
.79877 .43153 Mdot
.18263 .41288 Mdot
.34668 .263 Mdot
.16759 .44977 Mdot
.218 .35892 Mdot
.15258 .48643 Mdot
.92159 .56767 Mdot
.65572 .31798 Mdot
.87892 .51784 Mdot
.13749 .52369 Mdot
.32047 .26666 Mdot
.45089 .25984 Mdot
.12237 .56116 Mdot
.53473 .27353 Mdot
.62414 .30411 Mdot
.19715 .38099 Mdot
.25315 .30771 Mdot
.47695 .26022 Mdot
.27366 .28931 Mdot
.39305 .24768 Mdot
.75647 .38687 Mdot
.83654 .47114 Mdot
.59254 .29059 Mdot
.68759 .3384 Mdot
.23243 .3285 Mdot
.34076 .25175 Mdot
.29406 .27241 Mdot
.4191 .24792 Mdot
.79387 .42213 Mdot
.21178 .34824 Mdot
.16116 .44031 Mdot
.71939 .35626 Mdot
.17613 .40432 Mdot
.36678 .2523 Mdot
.50303 .26295 Mdot
.14603 .4777 Mdot
.13085 .51546 Mdot
.31435 .25735 Mdot
.56091 .27994 Mdot
.83158 .46022 Mdot
.91744 .56244 Mdot
.44508 .2521 Mdot
.19061 .37299 Mdot
.26741 .28017 Mdot
.11546 .55489 Mdot
.2467 .30028 Mdot
.20544 .3385 Mdot
.87483 .51445 Mdot
.22604 .31978 Mdot
.28785 .2634 Mdot
.33463 .24337 Mdot
.65072 .31459 Mdot
.387 .24108 Mdot
.75173 .38113 Mdot
.15451 .43243 Mdot
.36075 .24343 Mdot
.52918 .26971 Mdot
.13945 .46894 Mdot
.47117 .25524 Mdot
.41316 .24094 Mdot
.78919 .41558 Mdot
.68261 .33271 Mdot
.30827 .24724 Mdot
.16938 .39755 Mdot
.12421 .50693 Mdot
.18437 .36172 Mdot
.61905 .30212 Mdot
.49737 .25591 Mdot
.71453 .35068 Mdot
.9128 .55319 Mdot
.58725 .28712 Mdot
.21989 .30818 Mdot
.26116 .27056 Mdot
.43924 .24411 Mdot
.82703 .45392 Mdot
.24038 .291 Mdot
.10861 .5478 Mdot
.55545 .27405 Mdot
.19896 .32981 Mdot
.35481 .23236 Mdot
.87024 .50658 Mdot
.38102 .23205 Mdot
.28146 .25606 Mdot
.46542 .24625 Mdot
.78429 .40669 Mdot
.16285 .3885 Mdot
.32833 .23715 Mdot
.13262 .46185 Mdot
.11743 .49923 Mdot
.40716 .23404 Mdot
.14753 .42691 Mdot
.747 .37598 Mdot
.64565 .31047 Mdot
.67757 .32659 Mdot
.3019 .24051 Mdot
.8652 .49454 Mdot
.61374 .29466 Mdot
.52359 .26424 Mdot
.23413 .28046 Mdot
.82214 .44422 Mdot
.49167 .24862 Mdot
.25479 .26207 Mdot
.17747 .35629 Mdot
.43337 .23591 Mdot
.58187 .28138 Mdot
.1018 .53998 Mdot
.90869 .54875 Mdot
.21318 .30187 Mdot
.70968 .34595 Mdot
.27525 .24605 Mdot
.34864 .22472 Mdot
.40133 .22201 Mdot
.15637 .3786 Mdot
.32225 .2268 Mdot
.37495 .22407 Mdot
.45964 .23753 Mdot
.14107 .41663 Mdot
.77949 .39932 Mdot
.19201 .32514 Mdot
.29575 .2302 Mdot
.12579 .45448 Mdot
.54997 .27026 Mdot
.74197 .36695 Mdot
.8605 .48597 Mdot
.11055 .49185 Mdot
.51797 .2548 Mdot
.81742 .43656 Mdot
.24834 .25385 Mdot
.42751 .22616 Mdot
.48593 .24123 Mdot
.34264 .21369 Mdot
.17073 .34886 Mdot
.36902 .21271 Mdot
.6405 .3052 Mdot
.90421 .54122 Mdot
.09488 .53261 Mdot
.67255 .32163 Mdot
.22738 .27481 Mdot
.20656 .29416 Mdot
.26889 .23748 Mdot
.11938 .44322 Mdot
.13454 .40663 Mdot
.7047 .33957 Mdot
.60852 .29157 Mdot
.57646 .27567 Mdot
.45381 .22897 Mdot
.31597 .21888 Mdot
.18547 .31601 Mdot
.39522 .21619 Mdot
.1493 .37337 Mdot
.28932 .22304 Mdot
.42162 .21623 Mdot
.22114 .26344 Mdot
.85598 .47933 Mdot
.1034 .48628 Mdot
.54442 .26467 Mdot
.77493 .39545 Mdot
.16413 .33979 Mdot
.51229 .24962 Mdot
.48015 .23375 Mdot
.08798 .52481 Mdot
.73727 .36326 Mdot
.33639 .20606 Mdot
.81287 .43118 Mdot
.24167 .24755 Mdot
.30985 .20819 Mdot
.36284 .20535 Mdot
.1278 .398 Mdot
.89982 .5348 Mdot
.1999 .2865 Mdot
.26244 .22944 Mdot
.14293 .36189 Mdot
.3893 .20477 Mdot
.17887 .30715 Mdot
.44792 .22146 Mdot
.11222 .43776 Mdot
.28309 .21286 Mdot
.85108 .46919 Mdot
.66756 .31813 Mdot
.09678 .4762 Mdot
.63539 .30251 Mdot
.76987 .38547 Mdot
.41566 .20746 Mdot
.60324 .28774 Mdot
.21452 .25555 Mdot
.5066 .23946 Mdot
.57103 .27188 Mdot
.15746 .33099 Mdot
.23538 .23674 Mdot
.53882 .25676 Mdot
.89506 .52512 Mdot
.35677 .19534 Mdot
.3302 .19686 Mdot
.69998 .33837 Mdot
.808 .42248 Mdot
.081 .51716 Mdot
.19334 .27739 Mdot
.47434 .226 Mdot
.25602 .22054 Mdot
.38324 .19595 Mdot
.17226 .298 Mdot
.44205 .21168 Mdot
.12067 .39218 Mdot
.10539 .42917 Mdot
.30336 .20203 Mdot
.1359 .35557 Mdot
.09006 .46659 Mdot
.73252 .35937 Mdot
.8464 .46152 Mdot
.1509 .32086 Mdot
.40966 .19873 Mdot
.27648 .20696 Mdot
.89036 .51625 Mdot
.32402 .18691 Mdot
.22881 .22845 Mdot
.66246 .313 Mdot
.50086 .23224 Mdot
.35059 .18662 Mdot
.53319 .2488 Mdot
.18675 .26815 Mdot
.56552 .26528 Mdot
.59785 .28166 Mdot
.2077 .24914 Mdot
.6302 .29853 Mdot
.09878 .41862 Mdot
.37716 .18665 Mdot
.4685 .21794 Mdot
.11397 .38248 Mdot
.80335 .4165 Mdot
.07375 .51119 Mdot
.76534 .38287 Mdot
.69497 .33281 Mdot
.43612 .20306 Mdot
.29703 .19309 Mdot
.08315 .4581 Mdot
.16534 .29118 Mdot
.12899 .34773 Mdot
.24925 .21494 Mdot
.40364 .18976 Mdot
.84196 .45657 Mdot
.0672 .49975 Mdot
.72767 .35453 Mdot
.88585 .50933 Mdot
.26991 .19982 Mdot
.46267 .20758 Mdot
.52752 .2403 Mdot
.34435 .17819 Mdot
.14364 .31617 Mdot
.43023 .19168 Mdot
.79835 .40692 Mdot
.49508 .22464 Mdot
.37104 .17748 Mdot
.55996 .25787 Mdot
.5924 .27429 Mdot
.65731 .30776 Mdot
.31747 .18185 Mdot
.7604 .37519 Mdot
.29066 .18412 Mdot
.62491 .29293 Mdot
.68987 .3263 Mdot
.12206 .33974 Mdot
.09128 .4145 Mdot
.10663 .37741 Mdot
.07578 .4526 Mdot
.88098 .49923 Mdot
.39753 .18186 Mdot
.06017 .49151 Mdot
.83729 .44951 Mdot
.52181 .23095 Mdot
.31132 .17027 Mdot
.33807 .16965 Mdot
.45675 .19947 Mdot
.55435 .24929 Mdot
.48926 .21733 Mdot
.72279 .34978 Mdot
.36474 .17086 Mdot
.09987 .36752 Mdot
.58693 .2679 Mdot
.42412 .18627 Mdot
.06897 .44273 Mdot
.08424 .40645 Mdot
.87619 .49006 Mdot
.79387 .40371 Mdot
.39149 .17149 Mdot
.61957 .28712 Mdot
.75566 .3707 Mdot
.83231 .43936 Mdot
.05307 .48343 Mdot
.65228 .30641 Mdot
.45083 .19008 Mdot
.3318 .16046 Mdot
.48345 .2069 Mdot
.35865 .15977 Mdot
.68498 .32445 Mdot
.41814 .17562 Mdot
.51606 .22582 Mdot
.07737 .39685 Mdot
.06186 .43458 Mdot
.58139 .26024 Mdot
.54873 .2439 Mdot
.8716 .48295 Mdot
.71792 .34584 Mdot
.82748 .43119 Mdot
.38527 .16412 Mdot
.47761 .19585 Mdot
.78913 .39774 Mdot
.41217 .16411 Mdot
.61418 .28093 Mdot
.64691 .29774 Mdot
.04561 .47743 Mdot
.44484 .18208 Mdot
.75099 .36764 Mdot
.51028 .21651 Mdot
.54303 .23347 Mdot
.35221 .15392 Mdot
.67992 .32012 Mdot
.71275 .33746 Mdot
.37912 .15459 Mdot
.05411 .43056 Mdot
.86715 .47751 Mdot
.40606 .15524 Mdot
.43887 .17186 Mdot
.57588 .256 Mdot
.50449 .20533 Mdot
.47166 .18954 Mdot
.03826 .47037 Mdot
.78447 .39325 Mdot
.82316 .42877 Mdot
.64163 .29223 Mdot
.60878 .2758 Mdot
.53732 .22596 Mdot
.74604 .3612 Mdot
.37287 .14611 Mdot
.46577 .1777 Mdot
.49865 .19536 Mdot
.8624 .46933 Mdot
.67476 .31459 Mdot
.43282 .16288 Mdot
.57027 .24811 Mdot
.03093 .46271 Mdot
.77952 .38559 Mdot
.81828 .42058 Mdot
.70787 .33475 Mdot
.39977 .14976 Mdot
.60326 .26754 Mdot
.53157 .218 Mdot
.85727 .45776 Mdot
.63631 .2868 Mdot
.42677 .15302 Mdot
.74124 .35749 Mdot
.5646 .23876 Mdot
.45975 .17092 Mdot
.49274 .1899 Mdot
.66962 .31051 Mdot
.39355 .14133 Mdot
.59771 .25964 Mdot
.81362 .41508 Mdot
.77477 .38075 Mdot
.52578 .20987 Mdot
.70282 .32967 Mdot
.85263 .45109 Mdot
.55889 .22925 Mdot
.45372 .16204 Mdot
.42058 .14611 Mdot
.48683 .17962 Mdot
.63099 .28268 Mdot
.51996 .19817 Mdot
.73646 .35469 Mdot
.66436 .30474 Mdot
.59217 .25344 Mdot
.80893 .40966 Mdot
.44768 .15269 Mdot
.69774 .32496 Mdot
.84816 .44652 Mdot
.55318 .22191 Mdot
.48088 .17032 Mdot
.51411 .18811 Mdot
.41438 .13801 Mdot
.77021 .37897 Mdot
.62556 .27648 Mdot
.73127 .34622 Mdot
.58649 .24294 Mdot
.65898 .29685 Mdot
.44164 .14166 Mdot
.54739 .21053 Mdot
.47488 .16171 Mdot
.80419 .4041 Mdot
.6925 .3179 Mdot
.8435 .44034 Mdot
.76513 .37076 Mdot
.50821 .18051 Mdot
.62004 .26873 Mdot
.58083 .23505 Mdot
.54158 .20067 Mdot
.46892 .14922 Mdot
.5023 .16842 Mdot
.43542 .13565 Mdot
.65369 .29206 Mdot
.72648 .34466 Mdot
.61439 .25772 Mdot
.83886 .43472 Mdot
.79951 .39963 Mdot
.57515 .22801 Mdot
.68747 .31553 Mdot
.76047 .36876 Mdot
.53576 .19425 Mdot
.46281 .1424 Mdot
.64822 .28396 Mdot
.56934 .21486 Mdot
.4963 .16295 Mdot
.60884 .25128 Mdot
.72141 .33918 Mdot
.79463 .3932 Mdot
.52988 .18345 Mdot
.45671 .1329 Mdot
.8344 .43131 Mdot
.68221 .3096 Mdot
.64271 .27578 Mdot
.75555 .36372 Mdot
.60314 .24072 Mdot
.49031 .1532 Mdot
.56358 .2068 Mdot
.52398 .17259 Mdot
.71641 .33555 Mdot
.48429 .14238 Mdot
.67682 .30177 Mdot
.82973 .42605 Mdot
.79007 .39103 Mdot
.63721 .26876 Mdot
.51804 .16257 Mdot
.55777 .19848 Mdot
.75055 .35813 Mdot
.59753 .23511 Mdot
.55189 .18612 Mdot
.71122 .3296 Mdot
.63157 .25858 Mdot
.67144 .29498 Mdot
.47817 .13563 Mdot
.59178 .225 Mdot
.82499 .42042 Mdot
.7852 .3856 Mdot
.51205 .1554 Mdot
.74551 .35255 Mdot
.58597 .21385 Mdot
.66591 .28589 Mdot
.70591 .32218 Mdot
.626 .2518 Mdot
.50604 .14468 Mdot
.54603 .18049 Mdot
.82018 .41439 Mdot
.78044 .38206 Mdot
.58015 .20335 Mdot
.54009 .16875 Mdot
.6203 .24196 Mdot
.70051 .31377 Mdot
.74062 .34972 Mdot
.66044 .27852 Mdot
.49998 .1363 Mdot
.5743 .19316 Mdot
.81543 .40939 Mdot
.53413 .15889 Mdot
.61455 .2314 Mdot
.77552 .37693 Mdot
.7354 .34257 Mdot
.65494 .27153 Mdot
.69535 .31029 Mdot
.56844 .18404 Mdot
.52813 .15038 Mdot
.60884 .22346 Mdot
.64934 .26306 Mdot
.81095 .40784 Mdot
.77058 .37215 Mdot
.68988 .30192 Mdot
.56254 .17478 Mdot
.73034 .33844 Mdot
.60305 .21375 Mdot
.52209 .14294 Mdot
.64361 .25233 Mdot
.80581 .39925 Mdot
.68422 .29053 Mdot
.59719 .20307 Mdot
.55661 .16683 Mdot
.72504 .33142 Mdot
.76573 .36903 Mdot
.63792 .24331 Mdot
.67878 .28415 Mdot
.59134 .19379 Mdot
.55063 .15816 Mdot
.80109 .3959 Mdot
.63212 .23196 Mdot
.7197 .3241 Mdot
.76047 .36087 Mdot
.67317 .27501 Mdot
.58543 .18336 Mdot
.62635 .22256 Mdot
.54462 .15049 Mdot
.75518 .3529 Mdot
.71433 .31703 Mdot
.79634 .3927 Mdot
.6675 .26527 Mdot
.57954 .1761 Mdot
.62065 .21624 Mdot
.74995 .34627 Mdot
.70894 .31021 Mdot
.79113 .38451 Mdot
.66183 .25607 Mdot
.57358 .16692 Mdot
.61476 .2052 Mdot
.7033 .29969 Mdot
.65621 .24902 Mdot
.7449 .3427 Mdot
.60884 .1944 Mdot
.78625 .38075 Mdot
.5676 .15954 Mdot
.69779 .29201 Mdot
.65034 .23697 Mdot
.73946 .33404 Mdot
.60291 .18434 Mdot
.78122 .37571 Mdot
.69219 .2834 Mdot
.64458 .22825 Mdot
.73396 .325 Mdot
.68632 .27033 Mdot
.59702 .17713 Mdot
.63871 .21788 Mdot
.77619 .3711 Mdot
.68059 .26042 Mdot
.59104 .16811 Mdot
.72865 .31947 Mdot
.63279 .20676 Mdot
.77064 .36043 Mdot
.72285 .30689 Mdot
.67485 .25095 Mdot
.62693 .1984 Mdot
.76541 .35419 Mdot
.71735 .29953 Mdot
.66913 .24257 Mdot
.62097 .18802 Mdot
.71158 .28828 Mdot
.66322 .23109 Mdot
.76009 .34746 Mdot
.61503 .17964 Mdot
.65736 .22127 Mdot
.70594 .27961 Mdot
.75455 .33806 Mdot
.70017 .26952 Mdot
.6515 .21226 Mdot
.74895 .32845 Mdot
.69425 .25714 Mdot
.64557 .20253 Mdot
.74337 .31949 Mdot
.68857 .24977 Mdot
.73768 .30943 Mdot
.63967 .19452 Mdot
.68259 .23755 Mdot
.73208 .30117 Mdot
.72617 .28874 Mdot
.67693 .23226 Mdot
.67083 .21883 Mdot
.72033 .27774 Mdot
.66498 .21132 Mdot
.71471 .27091 Mdot
.70871 .2584 Mdot
.70303 .25191 Mdot
.69695 .23924 Mdot
.6912 .23309 Mdot
.25 Mabswid
.68874 0 m
.96935 .42924 L
s
.96935 .42924 m
1 .6535 L
s
1 .6535 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.03716 .25514 m
0 .48963 L
s
0 .48963 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.68874 0 m
.03716 .25514 L
s
.03716 .25514 m
.68874 0 L
s
.14467 .21304 m
.1493 .21769 L
s
[(-2)] .13542 .20373 .99461 1 Mshowa
.34306 .13535 m
.34735 .14032 L
s
[(0)] .3345 .12542 .86223 1 Mshowa
.55745 .05141 m
.56132 .05671 L
s
[(2)] .54972 .04081 .72986 1 Mshowa
.125 Mabswid
.19287 .19417 m
.1956 .197 L
s
.24198 .17493 m
.24466 .17782 L
s
.29204 .15533 m
.29467 .15827 L
s
.39509 .11498 m
.3976 .11801 L
s
.44814 .09421 m
.45059 .09729 L
s
.50225 .07302 m
.50464 .07615 L
s
.09737 .23156 m
.10019 .23431 L
s
.05093 .24975 m
.05379 .25245 L
s
.61378 .02935 m
.61603 .03258 L
s
.67126 .00684 m
.67344 .01012 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{299.062, 242.375},
  ImageMargins->{{48, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004[0000lPP10`4000010?ooooooc?ooZ_ooI_oo
<ooo0?o<ooo<c?o<VC/k>gYjN[Vi^OShn03ooeGooj[ooonI<onI0?mVoomVc?mVVOmVI_mV<omV0?lc
oclo?ginO[fm_Oclo5D00:X00?l00?l0VOl0I_l0<ol00<coolcoc<coVLcoIP<30d92@X61PL30`000
EED0EJX0EOl0ELbIolbIc<bIVLbII/bI<lbI0<aVolaVc0L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0Z/`c
<l`c0<`0ol`0c<`0VL`0I/`0<l`000/;2dY:BXV9RLS8b000oeD0ojX0ool0oiW<VIW<IYW<<iW<09VI
oiVIc9VIVIVIIPl?3di>CXf=SLc<c01E05EE0:YE0?mE09TcoiTcc9TcVITcIYTc<iTc09T0oiT0c1<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEEFKo<fKo06K<ofK<c6K<VFK<IVK<<fK<01LG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZVIVVFIVIVIV<fIV06HcofHcc6HcVFHcIQ/K6eYJFYVIVMSHf01EoeEEojYEoomEoc?o
oc?oc3?oVC?oIS?o<c?o03?<oc?<c1lO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ03>I<c>I03=Voc=Vc3=V
VC=VIS=V<c=V02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZEC<0VC<0IS<0<c<0003oo`3oc03oV@3oIRLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2Io`2Ic02IV@2IIP2I<`2I001Vo`1Vc2/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`0c<`0c0000o`00c000V@00IP00<nh002l_;fi^KZf][Nc/k03o05Go0:[o0?oo0140
003^003M002k002Z0028001g001E03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@00M`00E@00A0008P00
4Nk^k]gMgK^k^cLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l0;0000?l0;0000?l0;0000?l0;0000?l0
;0000=000_mI0000c@03o`030?l005P0003;00;o1002oeP0003800?o00<0o`000`000ol0o`1G0000
aP02o`T00omG0000Y@04oaX00ol;0004o`00oeH0002V0003o`0001L00ol>0005o`000?l0E@000:L0
00?o00005002oa4000Go0000o`1E0000Z0000ol0000@00?o4`000ol000020003o`000580002U0004
o`00oa000olE0003o`0000<000?o0000D@000:H00_l>00?o0`000ol0000C0003o`00008000?o0000
2`03od<0002d00;o70000ol000030003o`0000d000?o0000@0000;400olN0003o`0000<000?o0000
1005o`@000?o0000@0000:l00_lQ0003o`0000@000?o00002@03od<0002/00?o8`000ol000050003
o`0000P000?o0000@`000:X00olU0003o`0000D00_l900Co@P000:L00ol30003o`00028000?o0000
10000ol0o`1?0000Y003ob/000?o00001`000ol0001<0000XP02obh000?o00001`000ol0001<0000
W`03oc0000?o000020000ol0001;0000W@02oc<000?o00002@000ol0001:0000VP03ocD000?o0000
2@000ol0001:0000V002o`8000?o0000<`000ol0000:0003o`0004T0002E00?o>P000ol0000;0003
o`0004P0002C00;o?@000ol0000;0003o`0004P0002@00?o?`000ol0000<0003o`0004L0002=00?o
@P000ol0000=0003o`0004H0002;00;oAP000ol0000;00;oB00008P00ol20003o`0004<000?o0000
3@000ol000150000J002oa`00_m;0003o`0000h000?o0000A00006L000Co003o6003odd000?o0000
3P000ol000140000I`001?l00?lF00;oD0000ol0000?0003o`0004<0001W0004o`00oa<00omB0003
o`0000l000?o0000@`0006L000Co003o4@02oeD000?o000040000ol000120000J002o`l00ol20003
o`00058000?o00004@000ol000110000M`02oeX000?o00004@000ol000110000M003oe`000?o0000
4P000ol000100000L@03oel000?o00004`000ol0000o0000K`02oad00_m30003o`0001800_m10000
K004oa800_l400;o1002o`@00_l400;o=`000ol0000D0003o`0003h0001Z00;o10000ol0000900;o
1002o`@01?l800;o1002ocL000?o00005@000ol0000m0000I`03oa800_l<00;o1002o`@00_l400;o
0P02oc4000?o00005@000ol0000m0000I@02o`l00_l<00;o2P02o`@00_l400;o0P02oc4000?o0000
5P000ol0000l0000HP03oa400_l600;o1002o`/00_l?00;o0`02obX000?o00005`000ol0000k0000
H002o`h00_l600;o1003o`@00_l400;o1002o`@00_l500;o0P02o`<00_lZ0003o`0001L000?o0000
>`0005d00ol00`3o000=00;o1P02o`D00_l400;o1002o`X00_l500;o1002o`<00_lY0003o`0001L0
00?o0000>P0005/00_l=00;o1P02oaT00_l400;o2P02o`<00_l300;o0P02obD000?o000060000ol0
000i0000F003o`l00_l600;o1@02o`H00_l400;o1002o`@00_l400;o1002o``00_lU0003o`0001P0
00?o0000>@0005D00olD00;o2`02o`H00_l400;o4004o`T00_l200;o0`02o`<00_lN0003o`0001P0
0_lj0000D`02o`l00_l600;o1P02o`D00_l<00;o1002o`@00_l400;o1002o`<00_l200;o0`02o`<0
0_lN0003o`0001X000?o0000=`0005000olA00;o3P02o`D00_l600;o1002o`@00_l400;o2P02o`T0
0_l300;o8@000ol0000J0003o`0003L0000^00Co7002o`8000?o00006@02o`D00_l<00;o2`02o`@0
0_lD00;o0`02o`<00_l300;o5`000ol0000K0003o`0003H0000_0003o`0001T00olH00;o1P02o`D0
0_l600;o2`02o`@00_l400;o1@02o`@00_l200;o2P02o`030?oo00<00_lG0003o`0001/000?o0000
=P0002P01Ol30003o`0001H00_lD00;o1@04o`H00_l500;o1002o`H00_l300;o4@02o`@00_l200Co
0`02o`<00_l300;o6P000ol0000L0003o`0003D0000a0003o`0001800olF00;o1`02o`H00_l500;o
1P02o`@00_l500;o1002o`@00_l400;o2@02o`<00_l800;o0`02oaD000?o00007@000ol0000d0000
;P001?l00?lB00;o6P02oad00_l500;o1002o`@00_l400;o1002o`@00_l900;o0`02o`<00_l200;o
5@000ol0000M0003o`0003@0000_00;o4004oa/00_l800;o1@02o`H00_l;00;o3002o`@00_l800;o
2@02o`<00_l300;o1`02oa0000?o00007P000ol0000c0000?P03oaP00_l?00;o1@02o`H00_l500;o
3002o`@00_l400;o1002o`@00_l300;o4@02o`800_l@0003o`0001l000?o0000<P0003`00_lK00;o
1`02oaL00_l300;o1P02o`@00_l@00;o1002o`<00_l400;o0`02o`H00_l400;o3P000ol0000O00;o
<`0003T00olN00;o1P04o`H00_l500;o1P02o`D00_l400;o1P02o`<00_l400;o3`02o`<00_l300;o
0`02o`<00_l200;o3P000ol0000O00;o<`0003L00_lQ00;o2002o`H00_l500;o3@02o`H00_l400;o
0`02o`@00_l500;o1002o`800_l=00;o0`02o`L00_l90003o`00024000?o0000<00003@00olL00;o
1`02o`l00_l600;o4`02oaH00_l400;o1002o`<00_l300;o2`02o`800_l90003o`00024000?o0000
<00003800_l30003o`0001T00_l700;o2002o`D00_l600;o1@02o`H00_l;00;o1002o`@00_l400;o
2@02o`<00_l300;o0`02o`<00_l00`3oo`0400;o20000ol0000Q0003o`0002l0000_00?o8`02o`l0
0_lD00Co1002o`D00_l400;o1002o`@00_l400;o1002oa800_l300;o0`02o`800_l80003o`000280
00?o00001P02obH0000]00;o9P02o`L00_l?00;o1P02o`D00_l;00;o3002o`@00_l400;o0P02o`T0
0_l300;o0`02o`L00_l<0003o`00028000?o00001@001?l00?lU0000:P03ob000_l700;o1P02o`P0
0_l500;o1P02o`d00_l500;o1002o`@00_l400;o1002o`@00_l300;o0P02o`<00_l300;o0`02oa00
00?o00008`000ol000040004o`00obD0000X00;o8`02o`L00_l800;o1P02o`L00_l500;o3002o`D0
0_l400;o1@02o`@00_l900;o0`02o`T00_l300;o00<0ool01002o`800_l60003o`0002@000?o0000
0`001?l00?lU00009@03o`030?l003D00_l?00;o1@02o`H00_l500;o3002o`<00_l400;o1002o`T0
0_l300;o0`02o`<00_l700;o0P02o`800_l20003o`0002@000?o00000`001?l00?lU00008P03obX0
0_l700;o3`02oaD00_l500;o1P02o`@00_l500;o2002o`D00_l200;o0`02o`d00_l700;o00H0oooo
0?lV00;o1@02obH0000P00;o;@02o`L00_l800;o1@04o`D00_l600;o1@02o``00_l500;o1002o`@0
0_l900;o1002o`<00_l200;o0`02o`800_l300;o0P02o`800_l00`3o000T0004o`00ob`0000M00?o
>P02o`H00_l700;o1@02o`H00_l500;o1P02o`D00_l400;o2P02o`@00_l900;o0`02o`800_l300;o
1`02o`P00_lX0003o`0002X0000K00;o:P02o`P00_l700;o2002oaH00_l500;o1002o`D00_l600;o
1002o`@00_l200Co0P02oaL00_l700Co00<0o`00:0000ol0000Y00006003o`030?l002T00_l800?o
4002o`L00_l500;o1P02o`D00_l600;o2`02o`@00_l400;o1002o`800_l400;o0`02o`<00_l300;o
0P02o`<01_l200?o:@000ol0000X00005`02oc000_l700;o2002o`L00_l600;o1@02o`l00_l400;o
1@02o`D00_l400;o1002o`T00_l200;o0`02o`<00_l300;o0`02o`040?ooo`@01?l00`3o000W0003
o`0002P0000G00?o;`02oa400_l700;o3`02o`D00_l600;o1@02o`@01?l300;o1002o`@00_l400;o
0`03o`<00_l300;o0`02o`H00ol300;o0P02o`800olX0003o`0002L0000G0004o`00oc000_l700;o
2002o`h00_l600;o1@02o`L00_l400;o1P02o`D00_l400;o2002o`@00_l300;o0`02o`<00_l300?o
1P02o`H00olX0003o`0002L0000G0005o`000?l0;`02o`L00_l800;o1`02o`D00_l800;o1@02o`D0
0_l600;o1@02o`@00_l400;o1002o`@00_l400;o0`02o`P01Ol300;o3@000ol0000V0003o`0002H0
000F00?o0`000ol0000R00;o4`02o`l00_l700;o1P02o`D00_l=00?o1002o`H00_l300;o0`03o`<0
0_l400;o0`02o`800_l200?o0`02o`800_l300;o0P02o`800_l00`3o000W0003o`0002D0000F0003
o`0000@000?o00008@02o`T00_l800;o1`02o`l00_l700;o1P02o`D00_l500;o1P02o`@00ol200Co
0P04o`800_l500;o1@04o`030?oo00<00_l400;o00<0ool00P02o`800_l00`3o000V00;o9`0000l0
0_l50003o`0000D000?o00008P02o`L00_lA00;o2002o`h00_l600;o1@02o`d00ol400;o1002o`@0
0_l200Co0`02o`801?l00`3oo`0300;o0`02o`800_l;00?o:0000ol0000T00003P001?l00?l400;o
1`000ol0000Q00;o2@02o`P00_l700;o1P02o`L00_l700;o1@02o`H00_l500;o1@02o`H00_l400;o
1002o`801?l200Oo00<0ool00`02o`<00_l;00;o0P02o`030?l002L000?o00008`0000h000Co003o
10000ol000070003o`0002/00_l800;o1`02o`L00_l600;o1`02o`D00_l600?o1004o`/00_l400?o
0`03o`<01_l300;o0`02o`800_l700;o0P02o`800_l60003o`0002D000?o00008`0000h000Co003o
10000ol000080003o`0002400_lS00;o2002o`L00_l500;o1@02o`H00_l500Co0`02o`@00_l400;o
0P04o`<00_l200;o0P03o`030?oo00<00_l200;o0P02o`<00_l300?o:0000ol0000R00003P001?l0
0?l400;o2P000ol0000F00;o2002o`T00_l800;o1`02o`l00ol600;o1@02o`L00_l500Co0P04o`<0
1?l400;o0`03o`801?l01@3oool000;o0`04o`040?oo00;o1002o`800_l00`3oo`0300;o00<0o`00
9`000ol0000Q00003`02o`@000?o00002`000ol0000E00;o2P02o`L00_l800;o1`02o`L00_l700;o
1`02o`H00_l500Co0`04o`D00_l400;o1002o`040?oo00?o0`02o`801?l00`3oo`0300;o00<0ool0
0`02o`800_l200;o2P000ol0000U0003o`000240000E0003o`0000`000?o00005P02o`P00_lB00;o
2002o`D01?l>00;o1P03o`H00ol;00;o1P02o`800ol400;o1002o`<00_l0103oool300;o00<0ool0
0P02o`/00_l60003o`0002D000?o0000800001D00_l>0003o`0001D00_l900;o2002o`L00_l800;o
1`02o`L00_l700;o1@02o`L00_l600;o1@02o`@01?l00`3oo`02o`@00_l200Co0P02o`030?oo00;o
00@0ool00_l400;o00<0ool00P02o`800_l200;o0P000ol0000V0003o`0001l0000E0003o`0000h0
0_lP00;o2002ob<01?l500Co1@02o`L00_l400?o1003o`030?oo00Go0P03o`<00ol300?o00<0ool0
0_l0103oool200;o00<0ool00P02o`030?oo00800_l600;o0`000ol0000T00;o8@0001D000?o0000
40000ol0000D00;o2@02o`P00_l700;o1`02o`P00_l700;o1`02o`D01?l500?o1004o`<01?l400;o
0`04o`801?l200?o0P03o`030?oo00801Ol300;o2P02o`800_l20003o`0002D000?o00007P0001D0
0_lB0003o`0001<00_l900;o2002o`L00_l700Co1P03oa000_l600;o1P04o`@01Ol200?o1002o`@0
0ol300;o0`02o`<00_l300;o00D0oooo0002o`030?oo00800_l200;o0P02o`800_l30003o`0002D0
00?o00007@0001D000?o00004P000ol0000800;o2P02oa<00_l700;o1`02o`L00_l700;o1`02o`L0
1?l500;o0`06o`<01?l200Go0P02o`@00_l400;o0`02o`050?ooo`000_l0103oool200Go00@0oooo
2P000ol0000U0003o`0001d0000D0003o`0001@000?o00001`02o`X00_l900;o2002o`L00_lB00;o
1@04o`L00_l500Ko1@03o`@00ol400;o1003o`@00ol00`3oo`02o`800_l300?o00<0ool00_l00`3o
o`03o`030?oo00?o0P02o`800_l300;o0P000ol0000U0003o`0001`0000D00?o5@000ol0000800;o
4`02oa<00_l700;o1`02o`L01?l500Co1`02o`<01Ol500;o1@02o`H00_l200?o0`03o`801?l00`3o
o`0300;o00<0ool00ol200;o0P02o`801?l300;o0`000ol0000U0003o`0001/0000D0003o`0001H0
00?o00001`02o`T00_lC00;o2002o`L01?l700;o1`03o`H00_l800Co0`04o`D00_l300Co1002o`T0
0_l200Co0P02o`<02_l00`3oo`02o`800_l200;o1P000ol0000U0003o`0001/0000<00?o1@000ol0
000G0003o`0000P00_l700Co2002o`L00_l:00;o1`02o`L01?l600;o1`02o`D01_l500?o1003o`@0
0ol400;o1002o`<00_l400;o00<0ool00_l0103oool200Go00<0ool00ol500;o0P02o`<000?o0000
9@000ol0000J00003`000ol0000200;o6@000ol0000700;o2@02o`P00_l900;o2002o`P00_l800;o
2002o`D01ol400?o1@02o`D00_l500;o1003o`<00ol200Co0P02o`<00_l700;o0P06o`800_l200;o
00<0ool010000ol0000T00;o6`0000l000?o00000P000ol0000I0003o`0001d00_l700;o2@02o`L0
0_l900;o1`02o`H01Ol600;o1`02o`D00_l500;o0`02o`@00_l400;o1002o`801?l00`3oo`03o`80
0_l00`3oo`05o`800_l300;o0`000ol0000S00;o6`0000`00ol40003o`0001P00_l00`3o000700;o
2P02o`P00_lB00;o2@02o`L01?l700Ko1004o`D00_l500?o1003o`@00_l500;o1002o`<00_l300;o
0P04o`040?ooo`800_l00`3oo`06o`030?oo00D00_l30003o`0002D000?o0000600000`000?o0000
1002oaT00_l20003o`0000D00_l:00;o2P02o`L00_l900;o1`02o`T00_l700Go1@04o`D00ol500;o
1@04o`<00_l400;o1002o`<00_l400;o2`07o`801_l00`3oo`070003o`0002@000?o0000600000`0
1?l30003o`0001X00_l00`3o000C00;o2002o`L01?l700;o2@02o`T00ol200?o0P02o`P00_l500Co
1@02o`D00_l300Co0`02o`@00_l400;o0P02o`@00_l300;o00@0oooo0P04o`030?oo00;o00D0oooo
0002o`@000?o000090000ol0000G00004`000ol0000J00;o0P000ol0000500;o2P02o`T00_l800;o
2@02o`L01?l700Go1`02o`H00_l700?o1002o`H00_l400;o0`04o`800ol300?o0`02o`800ol200?o
00<0ool00P08o`030?oo00;o00<0ool01@000ol0000T0003o`0001H0000C00;o7@02o`030?oo00D0
0_lE00;o2P02o`L00_l900;o1P03o`030?oo00L00ol700;o1P02o`D00_l500;o2`02o`<00_l400;o
0`03o`800_l300;o0`02o`040?oo00?o00<0ool00_l0103oo`02o`<000?o000090000ol0000F0000
4`000ol0000L00;o0`000ol0000400;o2P02oa<00_l900;o2002o`800ol400Co1P04o`D00ol<00Co
1@02o`<00_l500;o1002o`P00_l400;o0P02o`800_l300Co00<0ool01Ol00`3oo`040003o`0002@0
00?o00005@0001<000?o00007P02o`8000?o00000`04o`P00_l900;o2@02o`P00_l800Co2@03o`L0
0_l600;o1`02o`D00_l500;o0`04o`<00_l400;o1002o`<00_l300;o0P02o`<00_l200;o00@0ool0
1ol00`3oo`040003o`0002@000?o00005000018000?o00007`02o`<000?o00001002oa<00_l900;o
2@02o`D00ol00`3oo`03o`L01?l600Co1@02o`D00ol500;o1@02o`@00_l500;o0`02o`<00_l300;o
1002o`H01?l00`3oo`06o`050?ooo`000_l50003o`0002<00_lE00004P02oa@00_l@0003o`0000l0
0_l900;o2@02o`L01?l00`3oo`0600?o2@03o`D01?l500?o1@02o`D00_l500;o1@02o`@00_l300;o
1002o`@00_l200;o0`02o`<00_l00`3oo`0200?o00<0ool01?l60003o`0002@000?o00004`000180
00?o00004`02oa4000?o00001002o`P00_l900Co1`02o`T01?lD00;o3`02o`h00_l500;o0`02o`D0
0_l800;o1002o`@00_l00`3oo`0400;o0P02o`040?oo00Wo10000ol0000T0003o`000180000B00;o
8P02o`@000?o00000`02o`T00_l:00;o2@02o`@00ol200?o2@04o`P00_l600;o1`02o`D00_l500;o
1@02o`X00_l400;o0`02o`T00_l200;o0`02o`800ol200_o10000ol0000S0003o`000180000B0003
o`0001D00_l:00Co0`000ol0000=00;o5@06o`H01?l700Go1`04o`@01?l500?o1003o`D00_l;00;o
2@02o`<00_l400;o1`02o`@00_l200;o0P02o`040?oo00Go10000ol0000T0003o`0000D00ol90000
0`03o`@00_l60003o`0001D01?l:00;o10000ol0000300;o2@02o`X00_l700Go2@04o`P00_l900;o
1P02o`H00_l500;o1@02o`D00_l400?o0`02o`@00_l400;o0P02o`@00_l300;o0P02o`<00_l200;o
0P08o`<000?o000090000ol000070003o`0000H000040003o`00008000Co003o1@000ol0000G00;o
4@000ol0000200;o2@02o`X00_l400?o0`02o`/00_l:00;o2002o`L00_l=00;o1@02o`<00_l500;o
0`02o`@00_l400;o1002o`800_l300?o0`02o`030?oo00800ol00`3oo`07o`<000?o00008`000ol0
00070003o`0000H000040003o`00008000Co003o1002obL00_l40003o`0000<00_lD00Go2002o`X0
1?l700Co1P04o`D00ol500;o1@02o`D00_l400;o2`02o`<00_l900;o0`02o`<00_l300;o0`02o`03
0?oo00800_l00`3oo`03o`@000?o00008`000ol0000300?o2@0000@000?o00000P001?l00?l40003
o`0001X00_l:00;o1@000ol0000200;o2@04o`L01?l900Co2006o`L00ol700;o1P02o`D00_l600;o
1@02o`<00_l500;o1002o`<00_l400;o1002o`800_l400;o1`02o`T01_l20003o`0002<00_l40003
o`0000T000040003o`00008000Co003o10000ol0000>00;o2P02o``00_l40003o`0000<00_l700Co
1003o`800_l;00Co2P02o`P00_lG00;o1@02o`D00_l500;o0`02o`D00_l400;o0P03o`<00_l400;o
0P02o`<00_l300;o0P02o`802Ol20003o`00024000?o0?l01004o`P0000300;o1@02o`D00_l?00;o
3002o`X00_l50003o`0000800_l<00?o1`02o`/00ol:00;o2@02o`H01?l500;o1004o`D00_l:00;o
2P02o`@00_l300;o2@02o`L00_l300;o0P02o`800ol0103oo`03o`8000?o00008`000ol0000=0000
4@000ol0000L00;o3002o`@00_l=00Co2@04o`X01?l800Co1`03o`D01?l500;o1P02o`D00_l400;o
1@02o`@00_lD00;o1002o`<00_l200;o1`02o`800_l200Go0`000ol0000R0003o`0000d0000A0003
o`0001000_l<00;o2P02o`H000?o00000_l500?o0P02o`/00ol;00;o2P04o`H00_l800;o1@02o`d0
0_l300;o1@02o`@00ol400;o0`02o`@00_l200Co0P02o`<00_l200;o0`02o`800ol200;o00<0ool0
1Ol00`3o000T0003o`0000`0000A0003o`0001000_l<00;o4`001?l0ool200?o1`02o`X01?l;00;o
2P02o`P00_l600;o1@02o`H00_l500;o1@02o`D00_l300;o1002o`<00_l400;o1002o`<00_l300;o
1P02o`<00_l200;o0P02o`030?oo00;o00<0o`0090000ol0000;000040000ol0000C00;o6002o`H0
00?o0?l00_l:00?o2`04o`T00ol:00;o1`02o`P00_l400;o1@02o``00_l500;o2P02o`@00_l300;o
1002o`800_l300;o0`02o`<00_l<00Go00<0o`008`000ol0000;000040000ol0000C00Co2P02o`X0
0_l600;o00<0ool02`02o`d00_l:00Co2004o`H00_l700;o1002o`L00_l400;o1@02o`D00_l400;o
0`02o`@00_l300;o1002o`P00_l200;o0`02o`<00_l200;o0P02o`040?ooo`8000?o00008P000ol0
000:000040000ol0000E00;o2P02o``00_l0103oool20003o`0000;o2`02o`d00_l:00Co2002o`H0
1?l=00;o1@02o`@00_l500;o1@02o`@00ol900;o1002o`P00_l200;o0`02o`<00_l200;o0P03o`03
0?oo00801OlU0003o`0000T0000@00;o<003o`H000Co0?oo2`04o`/00ol;00;o4P02o`H00_l500;o
1P02o`D00_l500;o1002o`@00_l300;o1002o`@00_l300;o0`02o`L01?l00`3oo`0300;o0P02o`80
0_l00`3oo`02o`030?l002800_l;000040000ol0000G00;o2P02o`L00ol00`3oo`070003o`0000;o
2`04o`X01?l:00;o2002o`P00_l500;o1P02o`D00_l500;o1@02o`@00_l900;o1@02o`@00_l200;o
2@02o`<00_l600;o1P02o`801?l00`3o000S0003o`0000P0000@0003o`0000P00_l=00;o2P04o`80
0ol400;o20000ol0o`03o`/01?l:00Co2004o`H01?l600;o1`02o`@00_l700;o1002o`D00_l:00;o
1002o`<00_l400;o1002o`800_l300;o1`02o`<00_l200;o0P02o`030?oo00Co8`03o`T0000?00?o
2@04oaT01?lB0003o`0000Co2`03o`/00_l:00?o1`03o`h00_l600;o1@02o`@00_l500;o1@02o`<0
0_l400;o1@02o`<00_l300;o0P04o`800_l600;o0`02o`800_l200;o0`05oal00ol20003o`0000L0
0000103oool300?o1@000ol0000;00;o3@02o`P00ol<00;o20001?l00002o``00_l<00Co2002o`P0
0_l700;o1P02o`D00_l600;o1@02o`@00_l400;o1@02o`<00_l400;o0`02o`@00_l300;o0P02o`<0
0_l300;o1`02o`800_l200Go6`03o`D000?o00001`00008000?o00001@000ol000020003o`0000d0
0_l;00Co1002o`@00_l900;o2@001?l00002o`d00_l:00Ko2002o`l00_l600;o1P02o`D00_l500;o
1002o`D00_l400?o0P03o`@00_l400;o0P02o`@00_l200;o0P03o`800_l300;o0P02o`800_l200;o
00@0oooo5P04o`P000?o00001`00008000?o00001@000ol0000200;o3P02o`d00_l0103oool600;o
2`02o`P000?o00001?l;00Ko2P02o`P00_l800;o1P02o`d00_l=00;o1@02o`<01?l300;o0`04o`80
0_l400?o0P02o`<00_l200;o0`02o`<00_l200;o0`02o`800_l400?o4`03o`d000?o00001P000080
00?o00000P03o`D000?o00007003o`X00_l:00Co1`001?l00002o`d01Ol:00;o2@02o`H00_l600;o
1`02o`H00_l400;o1@02o`D00ol400;o1002o`@00_l300;o1002o`801?l200;o0`02o`<00_l00`3o
o`0300;o0P02o`800_l200;o00@0oooo3`03oa0000?o00001P00008000?o00000P000ol000050003
o`0000l00_l800?o3@02o``00_l800;o0`04o``00_l:00Co1`03o`L00_l600;o1@03o`D00_l400;o
1`02o`@00_l500;o0`04o`<00_l200Co2002o`800_l300;o0`02o`H00_l700;o00<0ool00`02o`X0
1?lC0003o`0000H000000`3oo`0400Co10000ol0000?00;o1@03o`D00_lI00;o20000ol00004o`h0
0_l:00;o2002o`L00_l600;o1P02o`H00_l500;o1@02o`/00_l500;o0`03o`<00ol200;o2@02o`80
0_l300;o00<0ool01`02o`800_l300;o00@0oooo1P03oaL000?o00001P0000h000?o00004P05o`P0
0_l;00;o3004o`L000?o00000`03o`/00_l<00;o2002o`H00_l600;o3@02o`D00ol500;o1@02o`@0
0_l500;o0`02o`@00ol00`3oo`02o`800_l300?o00<0ool00`02o`030?oo00@00_l00`3oo`0400;o
00<0ool00P02o`801?lJ0003o`0000H0000>0003o`0000<00_l<00?o3002o`X01?l<00;o20000ol0
000200Go2`03o`T00_l800;o1P02o`H00_l600;o3@02o`D00ol400;o1004o`<00ol400;o0`02o`<0
0ol0103oool300;o0P02o`L00_l200;o0`02o`800_l200;o00<0ool00_lN0003o`0000H0000>0003
o`0000<00_l:00;o0`02o`X00_l<00;o3P02o`L000?o00001002o`/01Ol800;o4@02o`H00_l400;o
1`02o`H00_l400;o1@02o`D00ol300Co0P03o`P00ol0103oool300;o00<0ool00_l00`3oo`0200?o
0P02o`800_l600Co0P000ol0000L0003o`0000H0000=00?o1`02o`@00ol500;o3002o``00_l<00?o
1`000ol0000500;o3002o`P00_l800;o1`02o`H00_l600;o1@03o`D00_l600;o0`03o`D00_l500;o
0`03o`<00ol200;o0P04o`040?ooo`801_l200;o0P02o`L01_l01@3oo`3o01h000?o00001@0000h0
00?o00001P02o`040?oooaH00_l<00;o3@04o`H000?o00001004oaH00_l600;o2002o`d00ol500;o
1P02o`D00_l400Co1002o`D00_l300Co00<0ool00_l200;o0`02o`800_l300;o00<0ool00`02o`80
0_l200Ko0P02o`050?oo0?l07P000ol0000500003P000ol0000600Co3002o``00_l<00;o3@02o`L0
00?o00001@03o`/00_l800;o2002o`H00_l600;o1P02o`H00_l500?o1@02o`D00ol300Co0`04o`<0
0ol200?o00<0ool00_l200?o00<0ool01`02o`030?oo00801ol:00?o7@000ol0000500003@02o`D0
0ol200;o3002o``00_l<00;o3`02o`H000?o00001@04o`T00ol800;o1`03o`d00_l800;o1002o`H0
1?l300?o1@02o`D00ol300?o1003o`800ol200co00<0ool00P02o`<01Ol200;o0P02o`<00_l01@3o
o`3o01`000?o00001@0000d000Co00000ol700;o:002o`d01_l30003o`0000H00_l:00;o2002o`P0
0_l600;o1`02o`H00_l600;o1P02o`@01?l400Co0`04o`@00_l300?o0P04o`040?ooo`800_l200;o
00<0ool02Ol300;o1002o`<00_l200?o70000ol0000500003@04o`X00_l<00;o3002o``01?l=00Co
10000ol0000700;o2P02o`P00_l>00;o1`03o`H00_l500?o3@03o`<01Ol300?o1004o`800_l400?o
0P03o`803Ol200;o0P02o`800_l200;o0P02o`050?oo0?l06`000ol0000500003@02o`h00_l:00Co
2P02o`h00_l@00;o10000ol0000600?o2@03o`L00_l800;o1P02o`H00_l600;o1P04o`@00_l600?o
1@02o`H00_l300?o0`04o`800ol00`3oo`02o`030?oo00Ko00<0ool00ol0103oool200;o00D0oooo
0002o`800_l200;o00<0o`006@000ol0000500003`000ol0000;00;o3002o``00_l>00;o3P04o`<0
00?o00001P02o`X00_l800;o1`02o`H00_l800;o1P02o`H00_l400Go1004o`@00ol400?o1002o`80
1Ol200?o0P02o`800ol01@3oool000Wo0P02o`800_l200;o0P02o`030?oo008000?o000060000ol0
0004000040000ol0000J00;o2P04o``01?l>00Co0P000ol0000700;o2P02o`H00_l800;o1P02o`L0
0_l600;o1`02o`@01Ol500?o0`05o`<00ol300Co0`03o`800_l300?o0P0:o`030?oo00Co00<0ool0
0P02o`030?oo00800_l300?o6P000ol0000400004@000ol0000;00;o3002o``00_l>00?o3`04o`03
0?oo00L01?l800;o2002o`H00_l600;o2002o`H00ol500?o1P02o`H00ol500?o0`03o`@00ol300;o
0`04o`050?ooo`000ol200Ko00<0ool00ol01@3oool000;o0P02o`H00_l00`3o000H0003o`0000@0
000B00;o2`02oa`00_l=00Co3`03o`8000?o00001P02o`X00_l600;o2002o`H00_l600;o1P03o`H0
1?l500;o1P03o`D00ol300Go0P03o`<02?l200?o0P02o`<01Ol01@3oool000Co0P02o`030?oo00<0
0_l50003o`0001H000?o0000100001@000?o00006002o``01?l=00;o4002o`<000?o00004@02o`L0
0_l700;o1P03o`H00_l800;o1P03o`@01Ol400Co1003o`@00ol300So0`03o`800ol00`3oo`02o`03
0?oo00_o00<0ool00_l300;o00<0ool00P02o`8000?o00005@000ol0000400005@000ol0000900;o
3002o`h00_l?00Co3P02o`8000?o00001@04o`P00_l600;o4002o`H01?l600?o1P03o`D00ol600?o
1004o`@00_l00`3oo`02o`<00_l400;o0`02o`<00ol01@3oool000co00@0ool00_l500;o0P000ol0
000E0003o`0000@0000F0003o`0000P01?l<00;o3P02o`d01_l<00Co00<0o`001@04o`P00_l800;o
1P02o`P00_l600?o1P02o`L01Ol400Co1003o`D00_l400?o6002o`800_l300ko00@0ool00_l200;o
0P000ol0000D0003o`0000@0000G00;o2P02o``00_l>00Co3`04o``01OlC00;o1P02o`H00_l800?o
1P02o`P00_l700?o1004o`D00ol500Go8002o`803_l0103oo`03o`030?oo00<000?o000050000ol0
000300006@000ol0000G00;o3P02oa400_l>00;o00<0o`001`02o`P00_l700;o1`02o`L00_l800;o
1P03o`P01?l400?o1004o`030?oo00;o8`02o`<00_l200[o00@0ool00_l70003o`0001<000?o0000
0`0001X000?o00002002o``00_l@00;o4004o``00_l00`3o000600;o2@02o`H00_l700?o2002o`H0
0ol600Go1@04o`@01?l500?o;@02o`803Ol200;o00<0ool00P000ol0000C0003o`0000<0000K0003
o`0000L00_l>00;o3P03o`l01_l:00;o0P000ol0000500;o2002o`P00_l600;o2003o`H00ol600Go
1`03o`@00_l00`3oo`02oc000_l300?o00<0ool01_l200;o00<0ool00`000ol0000B0003o`0000<0
000L00;o2@02o``00_l?00;o4`04o`X00_l00`3o000500Co4002o`P00_l700;o1`04o`L00ol600?o
1004ocP00ol00`3oo`08o`030?oo00H000?o00004@000ol0000300007P000ol0000600;o7`04oa40
0_l:00;o0P000ol0000500;o2002o`L00_l700?o1`02o`P00ol700Co1P05o`800_lm00Wo00@0ool0
0_l30003o`00014000?o00000`0001l000?o00001`02o``00_l?00Ko4002o`X00_l20003o`0000h0
0_l700;o2002o`L01?l700?o2003o`<01_m300Wo00<0ool00ol30003o`00010000?o00000`000200
00?o00001P02o``01?lA00Co3P02o`X00_l30003o`0000@00_l800;o2002o`L00_l800?o1`04o`L0
1Ol400;o@`03o`030?oo00Ko00<0ool010000ol0000@0003o`000080000Q0003o`0000L00_l<00;o
4`04o`h00_l:00;o0P000ol0000300;o2002o`P00_l700Co1`04o`L01?l400GoCP09o`800_l30003
o`0000l000?o00000P0002800_l700;o3P04oa401?l<00Co2002o`<00_l500;o2002o`L00_l800;o
2@03o`L01ol300CoC@08o`800_l30003o`0000l000?o00000P0002@000?o00001P02o``01?lC00;o
3P02o`X00_l30003o`0000800_l800;o1`04o`L00_l900?o1P06o`H00_m?00_o0`000ol0000>0003
o`000080000U0003o`0000D00_l?00;o4`02o`h00_l900?o0`000ol0000200;o2002o`P00_l700Go
1`04o`040?ooo`@00omI00So10000ol0000=0003o`000080000V0003o`0000H00_l=00Ko3`06o`X0
0_l:00;o10001?l00002o`P01?l700;o2003o`P01Ol700;oFP08o`@000?o000030000ol000020000
9`02o`H00_l?00Co4@04o``00_l:00;o0`000ol0000200;o2002o`L01?l900?o0P03o`801Ol700;o
F008o`@000?o000030000ol000020000:@000ol0000H00;o4`02o`X01?l800;o10001?l00002o`T0
0_l800;o2@05o`P00ol600;oFP07o`@000?o000030000ol000010000:P000ol0000300;o4P06o`l0
0_l<00;o2@02o`@000Co00000_l800Co1`02o`H02?l800?oI005o`@000?o00002`000ol000010000
:`000ol0000200Co4P06o`h01?l:00;o2002o`D000?o00000_l:00;o1`04o`040?ooo`H00ol800Co
H`05o`@000?o00002P000ol000010000;002o`@01?lD00Co3004o`X00_l@0004o`0000;o4P04o`X0
1Ol700;oI006o`8000?o00002P000ol000010000;P000ol0000300Co5004ob@00_l50003o`0000;o
2@02o`@00ol200Go2004ofh01Ol30003o`0000T000?o00000@0002l000?o00001002oaH00_l>00;o
2P02o`P00_l60003o`0000;o2006o`L01?l:00CoK005o`<000?o000020000ol000010000<0000ol0
000500Co4`02o`d00_l:00?o2002o`H000?o0?l00ol500Ko2P04o`P01?m/00Oo00<0o`002@000ol0
00010000<@02o`D01?lC00Co3002o`X00_l800;o1`000ol00003o`040?ooo`@01Ol900?o2P02ofl0
0ol20003o`0000P00Ol10040000c0003o`0000H00_lC00Co2P04oa@00_l60003o`0000?o2004o`X0
0ol900;oK`05o`030?l000P00Ol10040000d0003o`0000D01?lC00Co2P02o`X00_l800Co1@02o`80
0_l:00;o2P05ogT01?l00`3o0007007o0@010000=@000ol0000600Co4`02o``00_l800;o2P02o`D0
00Co00000_l:00Co2P03ogX01Ol8007o0@010000=P02o`P01_lM00;o2P02o`T00_l40003o`000080
0_l;00Go2P02ogX00_l00`3o0006007o0@010000>0000ol0000700Ko3P04oaD00ol800Co0P000ol0
000200Co2P05o`T00omj00Co1P01o`400@0003T000?o00002P04o``01?l:00;o2P02o`X00_l20003
o`0000@00ol<00?o2@02ogX00ol00`3o0004007o0@010000>P000ol0000;00?o3`02o`P01?lE00;o
00<0o`001P04o`/01?n500?o1P01o`40000k00;o3004o`d00_l:00;o2P02o`T00_l00`3o000800?o
3003oh@01?l5007o0@0003d000?o00002`02o`h00_lE00?o2P02o`X01Ol:00CoQP000ol00002007o
0@0003h000?o00003002o``00_l:00;o2P02o`X00_l<00Go2P03ohH000Go0000o`010000?`000ol0
000;00;o3P02o`P01?l:00;o2@02o`h00ol:00;oQP001Ol0003o0040001000;o3@04o`X00_l:00;o
2P02o`T01Ol<00GoT0001?l00?l10000@P000ol0000:00Co3002o`X00_l900;o20000ol0o`02o`d0
1On@0003o`3o004000130003o`0000`00_l;00;o2P02o`T00_l80003o`0000800ol=00;oT0000ol0
0001o`00A0000ol0000;00;o6002o`X00_l60003o`0000801Ol=00;oS`01o`400Ol004D00_lI00;o
2P02o`X00ol50003o`0000D00ol<00?oS`02o`00A`000ol0000:00;o2P04o`X00_l900Co0`000ol0
000600Go2P02ohh00ol004P000?o00002@04o`X00_l:00;o2`03o`030?l000X01_nC00Co0`0004T0
00?o00002P02o``00_l900;o2`02o`030?l000`01?n?00Co1`0004X000?o00005`02o`T00_l=00?o
3`02oh/00ol;0000B`02o`X00_lH00;o2`06o``01?n500Co3P0004d000?o00001`04o`X00_l:00?o
2`000ol0o`04o``00on000Co4P0004h000?o00002002o`X01?l900;o2`000ol0000200?o3002og`0
1?lF0000C`000ol0000900;o2P02o`/00_l90003o`0000<01On300Co6P0005000_l900;o2`02o`X0
1Ol60003o`0000D00on000?o7P00058000?o00001`02o`X00_l<00Go10000ol0000800?oN@04ob40
001C0003o`0000H00_l<00;o3@03o`<000?o00002005og<01?lU0000E0000ol0000C00?o3@04o`03
0?l000`00om^00Co:@0005D00_l700;o2`02o`l01?l>00;oJP04obd0001G0003o`0000@01?l;00;o
3P05og@01?la0000F0000ol0000500;o2`04o`h01Om_00?o=@0005T000?o00001@02o``00_l>0003
o`0000?oJP04ocP0001J00;o1@02o`d00_l=0004o`0000CoI004oc`0001L0003o`0000@00_l;00Co
2`000ol0000300?oG`04od00001M0003o`0000<00_l=00?o2P000ol0000400CoF@04od@0001N0003
o`0000<00_l=00Co20000ol0000600?oE004odP0001O00;o0`04o`d01Ol50003o`0000L00_mA00?o
C000064000?o00000P02o`h01_l30003o`0005H01?m?0000HP000ol0000300?o3`06oe@01?mC0000
H`000ol0000200?o4007odh01?mG0000I002o`D00_lA00CoBP04oe/0001V0003o`0000800olA0003
o`3o00;oA@03oel0001W0003o`0000801?l?0003o`3o00;o@@04of80001X0003o`0000<01Ol<0003
o`0000800_lk00CoIP0006T00_l500Go2P000ol0000200;o=`04ofX0001[0003o`0000D01Ol70003
o`0003L01?m^0000K0000ol0000500Go1P000ol0000c00CoLP0006d000?o00001`04o`<000?o0000
<@03ogH0001^0003o`0000P00ol20003o`0002d01?mi0000K`02o`T01Ol[00CoO@00074000?o0000
2005obD01?n10000LP000ol0000900?o8@04ohD0001c0003o`0000P000?o00007@04ohT0001d00;o
20000ol0000J00?oS@0007H000?o00001@000ol0000F00CoT00007L000?o000010000ol0000B00Co
U00007P000?o00000`000ol0000>00CoV00007T00_l30003o`0000X01?nL0000N`001?l00?l900?o
X00007`000?o0?l01@04oj<0001m00;o00<0ool00_nW0000OP02oj/0003o02`0003o02`0003o02`0
003o02`0003o02`00000\
\>"],
  ImageRangeCache->{{{0, 298.062}, {241.375, 0}} -> {-0.0436178, 0.0477055, 
  0.00334229, 0.00334229}}]
}, Closed]],

Cell[TextData[{
  "Here we give ",
  StyleBox["Fit", "Input"],
  " a list of basis functions in two variables. The result is a linear \
combination of the basis functions."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(wavefit = Fit[wavydata, {1, x\^2, Cos[y]}, {x, y}]\)], "Input"],

Cell[BoxData[
    \(\(0.00524006588881227131`\[InvisibleSpace]\) + 
      1.99860768133503121`\ x\^2 - 0.999493972511808692`\ Cos[y]\)], "Output"]
}, Closed]],

Cell["\<\
Again, we can compute a value of the fit function for particular \
values of its parameters by using replacement rules.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(wavefit /. {x -> 2, y -> \(-3\)}\)], "Input"],

Cell[BoxData[
    \(8.98916232441299989`\)], "Output"]
}, Closed]],

Cell["Here is a plot of the best-fit surface.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(wave = Plot3D[wavefit, {x, \(-3\), 3}, {y, \(-6\), 6}]; \)\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .81114 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% SurfaceGraphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-1.11022e-16 1.04977 -0.0679587 1.04977 [
[.12586 .2075 -12 -8.99448 ]
[.12586 .2075 0 .00552 ]
[.3345 .12542 -5.5867 -9 ]
[.3345 .12542 .4133 0 ]
[.56094 .0364 -5.16972 -9 ]
[.56094 .0364 .83028 0 ]
[.72942 .0388 0 -6.21888 ]
[.72942 .0388 12 2.78112 ]
[.79593 .14064 0 -6.11966 ]
[.79593 .14064 24 2.88034 ]
[.8565 .23339 0 -6.03127 ]
[.8565 .23339 6 2.96873 ]
[.91188 .3182 0 -5.95203 ]
[.91188 .3182 18 3.04797 ]
[.96273 .39607 0 -5.88058 ]
[.96273 .39607 6 3.11942 ]
[.02244 .27561 -6 -2.75118 ]
[.02244 .27561 0 6.24882 ]
[.01393 .32892 -6 -2.79629 ]
[.01393 .32892 0 6.20371 ]
[.00513 .3841 -12 -2.84313 ]
[.00513 .3841 0 6.15687 ]
[-0.00399 .44125 -12 -2.89183 ]
[-0.00399 .44125 0 6.10817 ]
[ 0 0 0 0 ]
[ 1 .81114 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.03716 .25514 m
.68874 0 L
s
.13514 .21677 m
.13978 .22141 L
s
[(-2)] .12586 .2075 1 .99877 Mshowa
.34306 .13535 m
.34735 .14032 L
s
[(0)] .3345 .12542 .86223 1 Mshowa
.56863 .04703 m
.57247 .05235 L
s
[(2)] .56094 .0364 .72324 1 Mshowa
.125 Mabswid
.18558 .19702 m
.18832 .19985 L
s
.23703 .17687 m
.23971 .17975 L
s
.28951 .15632 m
.29214 .15925 L
s
.39772 .11395 m
.40023 .11699 L
s
.4535 .09211 m
.45595 .0952 L
s
.51046 .06981 m
.51284 .07294 L
s
.08568 .23614 m
.08851 .23887 L
s
.62804 .02377 m
.63027 .02701 L
s
.25 Mabswid
.68874 0 m
.96935 .42924 L
s
.71716 .04348 m
.71104 .04583 L
s
[(-5)] .72942 .0388 -1 .38197 Mshowa
.78358 .14509 m
.77741 .14731 L
s
[(-2.5)] .79593 .14064 -1 .35992 Mshowa
.84407 .23761 m
.83786 .23973 L
s
[(0)] .8565 .23339 -1 .34028 Mshowa
.89939 .32223 m
.89315 .32425 L
s
[(2.5)] .91188 .3182 -1 .32267 Mshowa
.95018 .39992 m
.94391 .40184 L
s
[(5)] .96273 .39607 -1 .3068 Mshowa
.125 Mabswid
.73096 .06459 m
.72728 .06598 L
s
.7445 .0853 m
.74081 .08667 L
s
.75778 .10561 m
.75408 .10697 L
s
.7708 .12553 m
.7671 .12688 L
s
.79613 .16428 m
.79242 .1656 L
s
.80845 .18312 m
.80473 .18442 L
s
.82054 .20161 m
.81682 .20291 L
s
.83241 .21978 m
.82869 .22106 L
s
.85553 .25514 m
.8518 .25639 L
s
.86679 .27235 m
.86305 .2736 L
s
.87784 .28927 m
.87411 .2905 L
s
.88871 .30589 m
.88497 .30711 L
s
.9099 .3383 m
.90615 .3395 L
s
.92022 .35409 m
.91647 .35528 L
s
.93037 .36962 m
.92662 .3708 L
s
.94036 .3849 m
.9366 .38606 L
s
.70309 .02196 m
.69942 .02338 L
s
.95984 .4147 m
.95608 .41584 L
s
.25 Mabswid
.03716 .25514 m
0 .48963 L
s
.03467 .27086 m
.04078 .26848 L
s
[(0)] .02244 .27561 1 -0.38863 Mshowa
.0262 .32427 m
.03234 .32195 L
s
[(5)] .01393 .32892 1 -0.3786 Mshowa
.01744 .37956 m
.0236 .3773 L
s
[(10)] .00513 .3841 1 -0.36819 Mshowa
.00837 .43683 m
.01455 .43462 L
s
[(15)] -0.00399 .44125 1 -0.35737 Mshowa
.125 Mabswid
.033 .28139 m
.03667 .27997 L
s
.03132 .292 m
.03499 .29059 L
s
.02963 .30269 m
.0333 .30128 L
s
.02792 .31344 m
.0316 .31204 L
s
.02448 .33518 m
.02816 .33379 L
s
.02274 .34616 m
.02642 .34478 L
s
.02098 .35721 m
.02467 .35584 L
s
.01922 .36835 m
.02291 .36698 L
s
.01565 .39085 m
.01935 .3895 L
s
.01385 .40223 m
.01755 .40088 L
s
.01204 .41368 m
.01574 .41234 L
s
.01021 .42521 m
.01391 .42388 L
s
.03633 .26039 m
.03999 .25896 L
s
.00651 .44853 m
.01022 .44721 L
s
.00465 .46032 m
.00836 .45901 L
s
.00276 .47219 m
.00648 .47088 L
s
.00087 .48414 m
.00459 .48285 L
s
.25 Mabswid
.03716 .25514 m
0 .48963 L
s
0 .48963 m
.39787 .81114 L
s
.39787 .81114 m
.40529 .59895 L
s
.40529 .59895 m
.03716 .25514 L
s
.68874 0 m
.96935 .42924 L
s
.96935 .42924 m
1 .6535 L
s
1 .6535 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.03716 .25514 m
0 .48963 L
s
0 .48963 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.68874 0 m
.03716 .25514 L
s
.40529 .59895 m
.96935 .42924 L
s
.96935 .42924 m
1 .6535 L
s
1 .6535 m
.39787 .81114 L
s
.39787 .81114 m
.40529 .59895 L
s
0 0 m
1 0 L
1 .81114 L
0 .81114 L
closepath
clip
newpath
.5 Mabswid
.881 .796 .761 r
.37527 .77192 .39878 .78524 .43868 .72482 .41593 .71069 Metetra
.869 .803 .782 r
.41593 .71069 .43868 .72482 .47794 .67266 .45588 .65782 Metetra
.853 .81 .807 r
.45588 .65782 .47794 .67266 .51681 .62831 .49539 .61285 Metetra
.831 .815 .835 r
.49539 .61285 .51681 .62831 .55556 .59142 .53472 .57542 Metetra
.8 .818 .866 r
.53472 .57542 .55556 .59142 .59442 .56176 .57412 .5453 Metetra
.756 .816 .899 r
.57412 .5453 .59442 .56176 .63365 .53917 .61385 .52231 Metetra
.696 .805 .933 r
.61385 .52231 .63365 .53917 .6735 .5236 .65418 .50639 Metetra
.612 .78 .961 r
.65418 .50639 .6735 .5236 .71425 .51505 .69538 .49758 Metetra
.5 .734 .978 r
.69538 .49758 .71425 .51505 .75619 .51366 .73776 .49598 Metetra
.359 .662 .972 r
.73776 .49598 .75619 .51366 .79963 .51965 .78162 .50183 Metetra
.195 .563 .936 r
.78162 .50183 .79963 .51965 .84492 .53334 .82735 .51546 Metetra
.024 .445 .871 r
.82735 .51546 .84492 .53334 .89247 .5552 .87534 .53734 Metetra
0 .321 .786 r
.87534 .53734 .89247 .5552 .94273 .58582 .92606 .56808 Metetra
0 .204 .694 r
.92606 .56808 .94273 .58582 .99624 .62598 .98006 .60849 Metetra
.891 .814 .766 r
.3509 .76133 .37527 .77192 .41593 .71069 .39238 .69919 Metetra
.88 .823 .789 r
.39238 .69919 .41593 .71069 .45588 .65782 .43308 .64554 Metetra
.863 .833 .815 r
.43308 .64554 .45588 .65782 .49539 .61285 .47328 .59988 Metetra
.84 .841 .845 r
.47328 .59988 .49539 .61285 .53472 .57542 .51324 .56187 Metetra
.807 .846 .879 r
.51324 .56187 .53472 .57542 .57412 .5453 .55323 .53124 Metetra
.76 .846 .916 r
.55323 .53124 .57412 .5453 .61385 .52231 .59351 .50782 Metetra
.692 .835 .952 r
.59351 .50782 .61385 .52231 .65418 .50639 .63437 .49156 Metetra
.596 .808 .981 r
.63437 .49156 .65418 .50639 .69538 .49758 .67607 .48248 Metetra
.466 .753 .992 r
.67607 .48248 .69538 .49758 .73776 .49598 .71893 .48069 Metetra
.304 .667 .974 r
.71893 .48069 .73776 .49598 .78162 .50183 .76327 .48643 Metetra
.12 .549 .919 r
.76327 .48643 .78162 .50183 .82735 .51546 .80948 .50005 Metetra
0 .414 .833 r
.80948 .50005 .82735 .51546 .87534 .53734 .85796 .52202 Metetra
0 .279 .731 r
.85796 .52202 .87534 .53734 .92606 .56808 .9092 .55297 Metetra
0 .158 .63 r
.9092 .55297 .92606 .56808 .98006 .60849 .96377 .59374 Metetra
.881 .797 .761 r
.3259 .74724 .3509 .76133 .39238 .69919 .3682 .68425 Metetra
.87 .804 .783 r
.3682 .68425 .39238 .69919 .43308 .64554 .40964 .62984 Metetra
.853 .81 .807 r
.40964 .62984 .43308 .64554 .47328 .59988 .45051 .58353 Metetra
.831 .816 .835 r
.45051 .58353 .47328 .59988 .51324 .56187 .49109 .54494 Metetra
.8 .818 .866 r
.49109 .54494 .51324 .56187 .55323 .53124 .53166 .51381 Metetra
.756 .816 .9 r
.53166 .51381 .55323 .53124 .59351 .50782 .57247 .48997 Metetra
.695 .805 .933 r
.57247 .48997 .59351 .50782 .63437 .49156 .61382 .47334 Metetra
.611 .78 .962 r
.61382 .47334 .63437 .49156 .67607 .48248 .656 .46396 Metetra
.499 .734 .978 r
.656 .46396 .67607 .48248 .71893 .48069 .69931 .46194 Metetra
.357 .662 .972 r
.69931 .46194 .71893 .48069 .76327 .48643 .7441 .46752 Metetra
.192 .563 .935 r
.7441 .46752 .76327 .48643 .80948 .50005 .79074 .48105 Metetra
.021 .444 .87 r
.79074 .48105 .80948 .50005 .85796 .52202 .83968 .50302 Metetra
0 .319 .784 r
.83968 .50302 .85796 .52202 .9092 .55297 .89139 .53409 Metetra
0 .202 .692 r
.89139 .53409 .9092 .55297 .96377 .59374 .94646 .5751 Metetra
.86 .759 .75 r
.30058 .72533 .3259 .74724 .3682 .68425 .34364 .66164 Metetra
.848 .762 .768 r
.34364 .66164 .3682 .68425 .40964 .62984 .38576 .60661 Metetra
.831 .764 .789 r
.38576 .60661 .40964 .62984 .45051 .58353 .42724 .55974 Metetra
.81 .765 .811 r
.42724 .55974 .45051 .58353 .49109 .54494 .46838 .52065 Metetra
.781 .762 .836 r
.46838 .52065 .49109 .54494 .53166 .51381 .50945 .48906 Metetra
.743 .756 .863 r
.50945 .48906 .53166 .51381 .57247 .48997 .55072 .46479 Metetra
.693 .743 .89 r
.55072 .46479 .57247 .48997 .61382 .47334 .5925 .44777 Metetra
.627 .72 .914 r
.5925 .44777 .61382 .47334 .656 .46396 .63506 .43803 Metetra
.542 .685 .932 r
.63506 .43803 .656 .46396 .69931 .46194 .67874 .4357 Metetra
.436 .633 .938 r
.67874 .4357 .69931 .46194 .7441 .46752 .72388 .44099 Metetra
.311 .562 .926 r
.72388 .44099 .7441 .46752 .79074 .48105 .77086 .45429 Metetra
.173 .475 .894 r
.77086 .45429 .79074 .48105 .83968 .50302 .82012 .47607 Metetra
.032 .378 .843 r
.82012 .47607 .83968 .50302 .89139 .53409 .87217 .50701 Metetra
0 .279 .779 r
.87217 .50701 .89139 .53409 .94646 .5751 .9276 .54795 Metetra
.843 .731 .74 r
.27502 .69632 .30058 .72533 .34364 .66164 .31878 .63209 Metetra
.829 .731 .756 r
.31878 .63209 .34364 .66164 .38576 .60661 .36152 .57656 Metetra
.813 .73 .773 r
.36152 .57656 .38576 .60661 .42724 .55974 .40356 .52922 Metetra
.792 .727 .792 r
.40356 .52922 .42724 .55974 .46838 .52065 .44519 .48968 Metetra
.765 .722 .812 r
.44519 .48968 .46838 .52065 .50945 .48906 .4867 .45765 Metetra
.73 .712 .834 r
.4867 .45765 .50945 .48906 .55072 .46479 .52837 .43297 Metetra
.686 .698 .855 r
.52837 .43297 .55072 .46479 .5925 .44777 .5705 .41554 Metetra
.63 .676 .875 r
.5705 .41554 .5925 .44777 .63506 .43803 .61338 .4054 Metetra
.56 .645 .891 r
.61338 .4054 .63506 .43803 .67874 .4357 .65734 .40266 Metetra
.475 .602 .899 r
.65734 .40266 .67874 .4357 .72388 .44099 .70274 .40756 Metetra
.374 .547 .896 r
.70274 .40756 .72388 .44099 .77086 .45429 .74996 .42047 Metetra
.262 .479 .88 r
.74996 .42047 .77086 .45429 .82012 .47607 .79945 .44188 Metetra
.143 .401 .849 r
.79945 .44188 .82012 .47607 .87217 .50701 .85172 .47246 Metetra
.024 .319 .806 r
.85172 .47246 .87217 .50701 .9276 .54795 .90737 .51307 Metetra
.84 .726 .739 r
.24893 .6655 .27502 .69632 .31878 .63209 .29339 .60075 Metetra
.827 .726 .754 r
.29339 .60075 .31878 .63209 .36152 .57656 .33676 .54473 Metetra
.81 .725 .77 r
.33676 .54473 .36152 .57656 .40356 .52922 .37936 .49693 Metetra
.789 .721 .789 r
.37936 .49693 .40356 .52922 .44519 .48968 .42148 .45694 Metetra
.762 .715 .809 r
.42148 .45694 .44519 .48968 .4867 .45765 .46343 .42448 Metetra
.728 .706 .829 r
.46343 .42448 .4867 .45765 .52837 .43297 .50549 .39937 Metetra
.685 .691 .85 r
.50549 .39937 .52837 .43297 .5705 .41554 .54796 .38152 Metetra
.63 .669 .869 r
.54796 .38152 .5705 .41554 .61338 .4054 .59115 .37095 Metetra
.562 .639 .885 r
.59115 .37095 .61338 .4054 .65734 .40266 .63538 .36778 Metetra
.479 .597 .893 r
.63538 .36778 .65734 .40266 .70274 .40756 .68102 .37226 Metetra
.382 .544 .891 r
.68102 .37226 .70274 .40756 .74996 .42047 .72846 .38473 Metetra
.273 .478 .876 r
.72846 .38473 .74996 .42047 .79945 .44188 .77816 .40571 Metetra
.158 .403 .848 r
.77816 .40571 .79945 .44188 .85172 .47246 .83062 .43586 Metetra
.042 .324 .808 r
.83062 .43586 .85172 .47246 .90737 .51307 .88646 .47607 Metetra
.853 .747 .746 r
.22178 .63903 .24893 .6655 .29339 .60075 .26703 .57361 Metetra
.84 .749 .763 r
.26703 .57361 .29339 .60075 .33676 .54473 .31111 .51699 Metetra
.823 .75 .782 r
.31111 .51699 .33676 .54473 .37936 .49693 .35434 .46863 Metetra
.802 .749 .803 r
.35434 .46863 .37936 .49693 .42148 .45694 .39703 .42813 Metetra
.774 .745 .826 r
.39703 .42813 .42148 .45694 .46343 .42448 .43949 .39519 Metetra
.738 .737 .85 r
.43949 .39519 .46343 .42448 .50549 .39937 .48201 .36962 Metetra
.691 .724 .875 r
.48201 .36962 .50549 .39937 .54796 .38152 .52489 .35133 Metetra
.63 .702 .897 r
.52489 .35133 .54796 .38152 .59115 .37095 .56845 .34034 Metetra
.552 .668 .914 r
.56845 .34034 .59115 .37095 .63538 .36778 .61302 .33678 Metetra
.456 .621 .922 r
.61302 .33678 .63538 .36778 .68102 .37226 .65897 .34087 Metetra
.342 .558 .915 r
.65897 .34087 .68102 .37226 .72846 .38473 .70671 .35298 Metetra
.216 .48 .891 r
.70671 .35298 .72846 .38473 .77816 .40571 .75668 .37363 Metetra
.084 .392 .85 r
.75668 .37363 .77816 .40571 .83062 .43586 .80942 .40349 Metetra
0 .3 .796 r
.80942 .40349 .83062 .43586 .88646 .47607 .86555 .44346 Metetra
.873 .782 .758 r
.19313 .61966 .22178 .63903 .26703 .57361 .23932 .55336 Metetra
.861 .788 .778 r
.23932 .55336 .26703 .57361 .31111 .51699 .28423 .49596 Metetra
.845 .792 .8 r
.28423 .49596 .31111 .51699 .35434 .46863 .32822 .4469 Metetra
.823 .796 .826 r
.32822 .4469 .35434 .46863 .39703 .42813 .37159 .40577 Metetra
.793 .796 .855 r
.37159 .40577 .39703 .42813 .43949 .39519 .41466 .37227 Metetra
.753 .792 .885 r
.41466 .37227 .43949 .39519 .48201 .36962 .45774 .3462 Metetra
.697 .781 .916 r
.45774 .3462 .48201 .36962 .52489 .35133 .50113 .32746 Metetra
.623 .758 .943 r
.50113 .32746 .52489 .35133 .56845 .34034 .54517 .31608 Metetra
.525 .718 .961 r
.54517 .31608 .56845 .34034 .61302 .33678 .59019 .31217 Metetra
.401 .657 .963 r
.59019 .31217 .61302 .33678 .65897 .34087 .63657 .31597 Metetra
.255 .573 .94 r
.63657 .31597 .65897 .34087 .70671 .35298 .68471 .32786 Metetra
.099 .47 .892 r
.68471 .32786 .70671 .35298 .75668 .37363 .73509 .34835 Metetra
0 .357 .823 r
.73509 .34835 .75668 .37363 .80942 .40349 .78825 .37814 Metetra
0 .247 .742 r
.78825 .37814 .80942 .40349 .86555 .44346 .84481 .41815 Metetra
.886 .807 .765 r
.163 .60487 .19313 .61966 .23932 .55336 .21024 .53752 Metetra
.875 .815 .787 r
.21024 .53752 .23932 .55336 .28423 .49596 .25609 .47919 Metetra
.859 .823 .812 r
.25609 .47919 .28423 .49596 .32822 .4469 .30092 .42933 Metetra
.836 .83 .841 r
.30092 .42933 .32822 .4469 .37159 .40577 .34506 .3875 Metetra
.805 .834 .873 r
.34506 .3875 .37159 .40577 .41466 .37227 .38883 .35337 Metetra
.76 .833 .908 r
.38883 .35337 .41466 .37227 .45774 .3462 .43255 .32676 Metetra
.698 .823 .942 r
.43255 .32676 .45774 .3462 .50113 .32746 .47654 .30756 Metetra
.611 .798 .971 r
.47654 .30756 .50113 .32746 .54517 .31608 .52113 .29578 Metetra
.494 .751 .986 r
.52113 .29578 .54517 .31608 .59019 .31217 .56668 .29156 Metetra
.346 .675 .977 r
.56668 .29156 .59019 .31217 .63657 .31597 .61355 .29513 Metetra
.177 .571 .936 r
.61355 .29513 .63657 .31597 .68471 .32786 .66219 .30687 Metetra
.002 .448 .865 r
.66219 .30687 .68471 .32786 .73509 .34835 .71306 .32732 Metetra
0 .32 .774 r
.71306 .32732 .73509 .34835 .78825 .37814 .76673 .35719 Metetra
0 .201 .679 r
.76673 .35719 .78825 .37814 .84481 .41815 .82384 .39742 Metetra
.883 .801 .764 r
.13193 .58839 .163 .60487 .21024 .53752 .18023 .51998 Metetra
.872 .809 .785 r
.18023 .51998 .21024 .53752 .25609 .47919 .22705 .46074 Metetra
.856 .816 .81 r
.22705 .46074 .25609 .47919 .30092 .42933 .27275 .41006 Metetra
.833 .822 .838 r
.27275 .41006 .30092 .42933 .34506 .3875 .31767 .36751 Metetra
.802 .825 .869 r
.31767 .36751 .34506 .3875 .38883 .35337 .36215 .33275 Metetra
.759 .824 .903 r
.36215 .33275 .38883 .35337 .43255 .32676 .40651 .30558 Metetra
.698 .814 .937 r
.40651 .30558 .43255 .32676 .47654 .30756 .45109 .28589 Metetra
.614 .789 .966 r
.45109 .28589 .47654 .30756 .52113 .29578 .49623 .2737 Metetra
.501 .744 .982 r
.49623 .2737 .52113 .29578 .56668 .29156 .54229 .26913 Metetra
.359 .672 .975 r
.54229 .26913 .56668 .29156 .61355 .29513 .58966 .27243 Metetra
.195 .573 .939 r
.58966 .27243 .61355 .29513 .66219 .30687 .63877 .28398 Metetra
.023 .454 .873 r
.63877 .28398 .66219 .30687 .71306 .32732 .69012 .30434 Metetra
0 .329 .787 r
.69012 .30434 .71306 .32732 .76673 .35719 .74427 .33423 Metetra
0 .211 .694 r
.74427 .33423 .76673 .35719 .82384 .39742 .8019 .37463 Metetra
.867 .771 .754 r
.10059 .56446 .13193 .58839 .18023 .51998 .14991 .49517 Metetra
.855 .776 .773 r
.14991 .49517 .18023 .51998 .22705 .46074 .19763 .43513 Metetra
.838 .779 .795 r
.19763 .43513 .22705 .46074 .27275 .41006 .24413 .38373 Metetra
.817 .781 .819 r
.24413 .38373 .27275 .41006 .31767 .36751 .28977 .34052 Metetra
.788 .78 .846 r
.28977 .34052 .31767 .36751 .36215 .33275 .33489 .30517 Metetra
.748 .775 .875 r
.33489 .30517 .36215 .33275 .40651 .30558 .37983 .27744 Metetra
.695 .763 .904 r
.37983 .27744 .40651 .30558 .45109 .28589 .42493 .25724 Metetra
.625 .74 .93 r
.42493 .25724 .45109 .28589 .49623 .2737 .47054 .24457 Metetra
.532 .702 .948 r
.47054 .24457 .49623 .2737 .54229 .26913 .51703 .23956 Metetra
.417 .645 .952 r
.51703 .23956 .54229 .26913 .58966 .27243 .56479 .24246 Metetra
.281 .567 .935 r
.56479 .24246 .58966 .27243 .63877 .28398 .61427 .25366 Metetra
.132 .471 .894 r
.61427 .25366 .63877 .28398 .69012 .30434 .66598 .27372 Metetra
0 .366 .833 r
.66598 .27372 .69012 .30434 .74427 .33423 .72049 .30339 Metetra
0 .26 .76 r
.72049 .30339 .74427 .33423 .8019 .37463 .77849 .34365 Metetra
.849 .74 .743 r
.0693 .53192 .10059 .56446 .14991 .49517 .11956 .46194 Metetra
.836 .741 .76 r
.11956 .46194 .14991 .49517 .19763 .43513 .1681 .40126 Metetra
.819 .741 .778 r
.1681 .40126 .19763 .43513 .24413 .38373 .21532 .34927 Metetra
.798 .74 .798 r
.21532 .34927 .24413 .38373 .28977 .34052 .26159 .30549 Metetra
.77 .735 .821 r
.26159 .30549 .28977 .34052 .33489 .30517 .30727 .26958 Metetra
.734 .726 .844 r
.30727 .26958 .33489 .30517 .37983 .27744 .3527 .24131 Metetra
.687 .712 .868 r
.3527 .24131 .37983 .27744 .42493 .25724 .39822 .22057 Metetra
.626 .689 .889 r
.39822 .22057 .42493 .25724 .47054 .24457 .4442 .20736 Metetra
.55 .656 .906 r
.4442 .20736 .47054 .24457 .51703 .23956 .49101 .20181 Metetra
.456 .609 .913 r
.49101 .20181 .51703 .23956 .56479 .24246 .53905 .20417 Metetra
.345 .547 .907 r
.53905 .20417 .56479 .24246 .61427 .25366 .58878 .21483 Metetra
.221 .471 .884 r
.58878 .21483 .61427 .25366 .66598 .27372 .64071 .23434 Metetra
.092 .385 .845 r
.64071 .23434 .66598 .27372 .72049 .30339 .69542 .26347 Metetra
0 .295 .792 r
.69542 .26347 .72049 .30339 .77849 .34365 .7536 .30322 Metetra
.842 .728 .739 r
.03763 .49507 .0693 .53192 .11956 .46194 .0888 .4245 Metetra
.828 .728 .754 r
.0888 .4245 .11956 .46194 .1681 .40126 .13813 .36325 Metetra
.811 .727 .771 r
.13813 .36325 .1681 .40126 .21532 .34927 .18605 .31071 Metetra
.79 .723 .79 r
.18605 .31071 .21532 .34927 .26159 .30549 .23292 .2664 Metetra
.763 .718 .81 r
.23292 .2664 .26159 .30549 .30727 .26958 .27913 .22994 Metetra
.727 .708 .832 r
.27913 .22994 .30727 .26958 .3527 .24131 .32501 .20112 Metetra
.682 .693 .853 r
.32501 .20112 .3527 .24131 .39822 .22057 .37092 .17982 Metetra
.625 .67 .873 r
.37092 .17982 .39822 .22057 .4442 .20736 .41723 .16603 Metetra
.554 .638 .888 r
.41723 .16603 .4442 .20736 .49101 .20181 .46431 .15988 Metetra
.467 .594 .896 r
.46431 .15988 .49101 .20181 .53905 .20417 .51258 .16161 Metetra
.364 .536 .892 r
.51258 .16161 .53905 .20417 .58878 .21483 .5625 .17162 Metetra
.25 .467 .874 r
.5625 .17162 .58878 .21483 .64071 .23434 .61457 .19045 Metetra
.129 .388 .842 r
.61457 .19045 .64071 .23434 .69542 .26347 .6694 .21889 Metetra
.009 .304 .797 r
.6694 .21889 .69542 .26347 .7536 .30322 .72769 .25792 Metetra
.849 .74 .743 r
.00459 .46068 .03763 .49507 .0888 .4245 .05675 .3894 Metetra
.836 .741 .76 r
.05675 .3894 .0888 .4245 .13813 .36325 .10696 .3275 Metetra
.819 .741 .778 r
.10696 .3275 .13813 .36325 .18605 .31071 .15564 .27433 Metetra
.798 .739 .798 r
.15564 .27433 .18605 .31071 .23292 .2664 .20319 .22941 Metetra
.77 .735 .821 r
.20319 .22941 .23292 .2664 .27913 .22994 .24997 .19237 Metetra
.734 .726 .844 r
.24997 .19237 .27913 .22994 .32501 .20112 .29636 .16297 Metetra
.687 .712 .867 r
.29636 .16297 .32501 .20112 .37092 .17982 .34271 .14108 Metetra
.627 .689 .889 r
.34271 .14108 .37092 .17982 .41723 .16603 .3894 .1267 Metetra
.55 .656 .905 r
.3894 .1267 .41723 .16603 .46431 .15988 .4368 .11995 Metetra
.456 .609 .913 r
.4368 .11995 .46431 .15988 .51258 .16161 .48534 .12107 Metetra
.346 .547 .907 r
.48534 .12107 .51258 .16161 .5625 .17162 .53549 .13045 Metetra
.222 .471 .884 r
.53549 .13045 .5625 .17162 .61457 .19045 .58776 .14866 Metetra
.093 .386 .845 r
.58776 .14866 .61457 .19045 .6694 .21889 .64276 .17646 Metetra
0 .296 .793 r
.64276 .17646 .6694 .21889 .72769 .25792 .70121 .21488 Metetra
0 g
.25 Mabswid
.68874 0 m
.96935 .42924 L
s
.96935 .42924 m
1 .6535 L
s
1 .6535 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.03716 .25514 m
0 .48963 L
s
0 .48963 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.68874 0 m
.03716 .25514 L
s
.03716 .25514 m
.68874 0 L
s
.13514 .21677 m
.13978 .22141 L
s
[(-2)] .12586 .2075 1 .99877 Mshowa
.34306 .13535 m
.34735 .14032 L
s
[(0)] .3345 .12542 .86223 1 Mshowa
.56863 .04703 m
.57247 .05235 L
s
[(2)] .56094 .0364 .72324 1 Mshowa
.125 Mabswid
.18558 .19702 m
.18832 .19985 L
s
.23703 .17687 m
.23971 .17975 L
s
.28951 .15632 m
.29214 .15925 L
s
.39772 .11395 m
.40023 .11699 L
s
.4535 .09211 m
.45595 .0952 L
s
.51046 .06981 m
.51284 .07294 L
s
.08568 .23614 m
.08851 .23887 L
s
.62804 .02377 m
.63027 .02701 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{299.062, 242.375},
  ImageMargins->{{48, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004[0000lPP10`4000010?ooooooc?ooZ_ooI_oo
<ooo0?o<ooo<c?o<VC/k>gYjN[Vi^OShn03ooeGooj[ooonI<onI0?mVoomVc?mVVOmVI_mV<omV0?lc
oclo?ginO[fm_Oclo5D00:X00?l00?l0VOl0I_l0<ol00<coolcoc<coVLcoIP<30d92@X61PL30`000
EED0EJX0EOl0ELbIolbIc<bIVLbII/bI<lbI0<aVolaVc0L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0Z/`c
<l`c0<`0ol`0c<`0VL`0I/`0<l`000/;2dY:BXV9RLS8b000oeD0ojX0ool0oiW<VIW<IYW<<iW<09VI
oiVIc9VIVIVIIPl?3di>CXf=SLc<c01E05EE0:YE0?mE09TcoiTcc9TcVITcIYTc<iTc09T0oiT0c1<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEEFKo<fKo06K<ofK<c6K<VFK<IVK<<fK<01LG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZVIVVFIVIVIV<fIV06HcofHcc6HcVFHcIQ/K6eYJFYVIVMSHf01EoeEEojYEoomEoc?o
oc?oc3?oVC?oIS?o<c?o03?<oc?<c1lO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ03>I<c>I03=Voc=Vc3=V
VC=VIS=V<c=V02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZEC<0VC<0IS<0<c<0003oo`3oc03oV@3oIRLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2Io`2Ic02IV@2IIP2I<`2I001Vo`1Vc2/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`0c<`0c0000o`00c000V@00IP00<nh002l_;fi^KZf][Nc/k03o05Go0:[o0?oo0140
003^003M002k002Z0028001g001E03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@00M`00E@00A0008P00
4Nk^k]gMgK^k^cLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l0;0000?l0;0000?l0;0000?l0;0000?l0
;0000=000_mI0000c@03o`030?l005P0003;00;o1002oeP0003800?o1P000ol0o`1G0000Z004oaX0
0_l90003o`3o05L0002Y0003o`0001L00ol;0004o`00oeH0002Z0003o`0001<00ol>0005o`000?l0
E@000:/000?o00004003oa0000?o00000_l=00?oA@000:P000Co003o3`03o`8000?o00003P000ol0
00020003o`0000d000?o0000@P000:T00_l>00;o5P000ol000030003o`0000<01Ol40003o`000480
002f00?o6@000ol000020003o`0000T00om50000]002oa`000?o00000`000ol000080003o`0004D0
002a00?o7P000ol000030003o`0000P01?m40000[`02ob4000?o00000P03oe40002/00Co8P000ol0
00050003o`0004h0002Z00;o10000ol0000O0003o`0000D000?o0000CP000:L00olX0003o`0000H0
00?o0000C@000:@00ol[0003o`0000L000?o0000C0000:800_l^0003o`0000L000?o0000C00009l0
0ol`0003o`0000L00_m=0000W@02oc<000?o00002@000ol0001:0000VP03o`8000?o0000<0000ol0
00090003o`0004X0002H00;o>0000ol0000:0003o`0004T0002E00?o>P000ol0000;0003o`0004P0
002C00;o?@000ol0000;0003o`0004P0002@00?o?`000ol0000;00;oB@0008d00om20003o`0000d0
00?o0000AP0008/00_l20003o`00044000?o000030000ol000160000R003odP000?o00003@000ol0
00150000J002oa`00_m;0003o`0000h000?o0000A00006L000Co003o6003odd000?o00003P02odD0
001W0004o`00oaH00_m@0003o`0000d000?o0?l0A@0006L000Co003o4`03oe8000?o00003`000ol0
00130000I`001?l00?lA00?oE0000ol0000@0003o`000480001X00;o3`03o`<000?o0000100;od80
00?o00004@000ol000110000M`02o`H01ol02eEDEOmbP7:0LX1b00_o=`000ol0000A0003o`000440
001d00?o0`05o`0MLeAcE7=DLeAcE7?ocEC=E<eDcEC=E<eDolf=cHd01ol`0003o`0001400_m20000
L@03o`<00ol0:G9KoeAEE5EDEEAEE5EDEEAEog:0LX1bP7:0LX1bP?nmcKg=_LfmcKg=00Co;0000ol0
000C0003o`0000X01?l300;o0`03obH0001_00;o0P04o`0`ELiEcUG>oeAcE7=DLeAcE7=DLeCoE<eD
cEC=E<eDcEC=E?o=SLf=cHg=SLf=cOnR0olY0003o`0001<000?o00002`000ol0000300;o1P000ol0
000S0000K007o`0gFg9KLU]bFg9KLU_oE5EDEEAEE5EDEEAEE?n0LX1bP7:0LX1bP7:0okg=_LfmcKg=
_LfmolfSc@02obL000?o000050000ol0000300Go0`000ol0000:0003o`0002<0001Z00;o00<0ool0
0_l0>eG>ELiEcUG>ELiEcUGoLeAcE7=DLeAcE7=DLeCoE<eDcEC=E<eDcEC=ohg=SLf=cHg=SLf=cOnR
Xj:S00?o90000ol0000E0003o`0000/000?o00001P03obH0001W00?o04D0ooo>oe]bFg9KLU]bFg9K
LU]bFg;oEEAEE5EDEEAEE5EDEOmbP7:0LX1bP7:0LX1bolfmcKg=_LfmcKg=oj?=XlfScJ<00_lR0003
o`0001D000?o000020001?l00?l80003o`0002H0001U00;o0P02o`16c_[>n_o>ELiEcUG>ELiEcUG>
ELiEog=DLeAcE7=DLeAcE7?ocEC=E<eDcEC=E<eDcOn=cHg=SLf=cHg=SOnSXZ>RXj:SXP?o7`000ol0
000D00?o2P02o`T01?lU0000HP03o`800_l0Blh[cR_>:lkoFg9KLU]bFg9KLU]bFg9KoeAEE5EDEEAE
E5EDEEAEog:0LX1bP7:0LX1bP?nmcKg=_LfmcKg=_LgoXlfScJ?=XlfSc@02oad000?o00005`000ol0
000k0000H002o`@0053oc_[>n/kjc_[>n_o>ELiEcUG>ELiEcUG>ELkoE7=DLeAcE7=DLeAcE?mDcEC=
E<eDcEC=E<eDolf=cHg=SLf=cHg=oj:SXZ>RXj:SXZ?oS0;o6`000ol0000G0003o`0003/0001M00?o
1002o`1@:lh[cR_>:lh[cR_oLU]bFg9KLU]bFg9KLU]bFomDEEAEE5EDEEAEE5EDoh1bP7:0LX1bP7:0
LX3o_LfmcKg=_LfmcKgocJ?=XlfScJ?=Xol2X`;o6P000ol0000G0003o`0003X0001K00;o0`00;_l0
ooojc_[>n/kjc_[>n/kjc_mEcUG>ELiEcUG>ELiEcUGoLeAcE7=DLeAcE7<Do`0HcHg=SLf=cHg=oj:S
XZ>RXj:SXZ?oS<N<0_lH0003o`0001P000?o0000>@0005P00ol500;o02D[cR_>:lh[cR_>:lh[cR_>
:ombFg9KLU]bFg9KLU]bFg;oEEAE00Oo01ADLeCocEC=E<eDcEC=E<eDcOn=c@Go012mcKg=oj?=XlfS
cJ?=Xlgo1J<2oaH000?o00005`02oc/0001E00?o1`008oogoo[>n/kjc_[>n/kjc_[>n/kjoliEcUG>
ELiEcUG>ELiE00Go021EE5EDEEAEE5EDEOnmE;eD_EBmE;eD_EBmoh3=P<f0c@Ko016SXZ>RXj:SXZ>R
olN<ahc7S002oa@000?o00006@000ol0000h0000D`02o`P00_l07U/KFoo>:lh[cR_>:lh[cR_>:lh[
c_mKLU]bFg9KLPGo02X?EOmcE7=DLeAcE7=DLeAcE?o=E<eDcEC=E<eDcECocHg=SLf=cHg=SLd3o`0:
cJ?=XlfScJ?=o`NS0_lB0003o`0001X000?o0000=`0005000ol800;o01_>mlkgc_Oon/kjc_[>n/kj
c_[>n/kjc_[ocUD01Ol0</iEcUG>ELiEoeAEE5EDEEAEE5EDEECoE;eD_EBmE;eD_EBmE?o=P<f0cH3=
P<f0cOnS0ol04::SXZ>RXon<ahc7S<N<ah`2oa0000?o00006P000ol0000g0000CP04o`P001_oFa]K
6e/KFa]Kolh[cR_>:lh[cR_>:lh[cR/00ol0>PmE3eD?E@mE3eD?E@mEog=DLeAcE7=DLeAcE7?oE<eD
cEC=E<eDcEC=E?o=SLf=cHg=SLf=cOo=Xld2o`06XlfScJ?o2Z<2o`h000?o00006`000ol0000f0000
;004oa/00ol:00;o01Wgc_O>mlkgc_O>olkjc_[>n/kjc_[>n/kj00;o03o>oliEcUG>ELiEcUG>ELiE
c_mEE5EDEEAEE5EDEEAEE?mD_EBmE;eD_EBmE;goP<f0cH3=P<f0cH3oXZ>RXj800ol04:>RXon<ahc7
S<N<ahcoaol=0003o`0001/00_lg0000;@000ol0000I00;o2`02o`0I6e/KFa]K6e/KFa]K6ol[cR_>
:lh[cR_>:`02o`142lh;c_l?E@mE3eD?E@mE3eD?E@ooE7=DLeAcE7=DLeAcE?o=E<eDcEC=E<eDcEC=
ohg=SLf=cHg=SLf=oj?=XlfScJ<2o`03cOnS00VS00Coaooo2`000ol0000K00;o=`0002H01Ol30003
o`0001D00ol<000JooO>mlkgc_O>mlkgc_O>mlkoc_[>n/kjc_X2o`18c^[>j/kZc_o>ELiEcUG>ELiE
cUG>ELkoEEAEE5EDEEAEE5EDEOnmE;eD_EBmE;eD_ECocH3=P<f0cH3=P<f0oj:SXZ>RXj:S0ol02/N<
ahc7S<N<aol3a`;o2@000ol0000M0003o`0003@0000_0003o`0001800_l=00;o06MK6e/KFa]K6e/K
Fa]K6e/KFoo>:lh[cR_>o`_>2lh;cP_>2omE3eD?E@mE3eD?E@mE3eGoLeAcE7=DLeAcE7=DLeCocEC=
E<eDcEC=E<eDolf=cHg=SLf=cHg=olfScJ?=XlfScJ?=00;o2:<01_oCam?7o`P000?o00007@000ol0
000d0000;0001?l00?lA00?o3P006_lkolkgc_O>mlkgc_O>mlkgc_O>moojc_[>0_l0D>[>j/kZc^[>
j/kZoeG>ELiEcUG>ELiEcUG>EOmDEEAEE5EDEEAEE5EDoeBmE;eD_EBmE;eD_ECocH3=P<f0cH3=P<go
Xj:SXZ>RXj:SX_o60_l02<N<ahc7S<Oo1<L2o`H000?o00007P000ol0000c0000;@02o`l00ol00`3o
000=000Ioa/`6olKFa]K6e/KFa]K6e/KFa]K6e_ocP02o`1DcP_>2lh;cP_>2lh;cP_oE@mE3eD?E@mE
3eD?E@ooE7=DLeAcE7=DLeAcE7?oE<eDcEC=E<eDcEC=ohg=SLf=cHg=SLf=oj?=XlfScJ?=XlfSohel
0_l5X`08olOCam?7dol50003o`0001l000?o0000<P0003`00_lB0003oc/k00<k01;oc_O>mlkgc_O>
mlkgc_O>mlh2o`0Xj/kZc^[>j/kZc^[>j/kZc_o>ELiEcUG>ELiEcUG>ELkoEEAEE5EDEAOo01V0cH3=
P<f0cH3oXZ>RXj:SXZ>RXonSaZ?600;o00G7S<N<o`06a`;o0`000ol0000N00;o=00003T00olC000j
oa/`6c0K<1_o6e/KFa]K6e/KFa]K6e/Koa_ocP_>2lh;cP_>2lh;cP_>2lko3eD?E@mE3eD?E@mE3`Wo
01MEE5EDEEAEog:0LX1bP7:0LX1bP?nmc@05o`0GSLf=cHgoXlfScJ?=XlfScOmlSGb=O?l00j<02OoC
am?7dlOCa`02o`030?l0024000?o0000<@0003L00_lD00;o23/03_ogc_O>mlkgc_O>mlkg0_l07lh;
c_o>j/kZc^[>j/kZc^[>j/kZc_o>ELiEcUG>ELh00ol09EG>oeAcE7=DLeAcE7=DLeAcoleDcEC=E<eD
cEC=E?o=SLf=cHd01_l04J>RXj:SXZ>RXj:Soj?6XlJS00;o00><aol02LL2ob<000?o0000<00003@0
0olE000Goc0K<1/`6c0K<1/`oe/KFa]K6e/KFa/00_l07S/K>a/k6oo>2lh;cP_>2lh;cP_>2lh;oeD?
E@mE3`?o02ebFg9KLU_oE5EDEEAEE5EDEEAEE5GoLX1bP7:0LX1bP7:0okg=_LfmcKg=_Ld00ol04J?=
XlfScJ?=Xon=O8elSGb=00;o00bSom?7dlOCam?7dolS0003o`000300000b00;o5`000olk>`0;>`0W
ooO>mlkgc_O>olh;cP_>2lh;c_o>j/kZc^[>j/kZc^[>j/kZoeG>00?o03=EcUG>ELiEcUG>oeAcE7=D
LeAcE7=DLeCoE<eDcEC=E<eDcEC=E?o=SLf=cHg=SLf=oj<00ol04::SXZ>RXj;oaZ?6XlJSaZ<2o`W7
0_lS0003o`0002l0000_00?o0P000ol0000C000Foc0K<1/`6c0K<1/`6c0Koa]K6e/KF`;o01/K>a/k
6c/K>a/ko`_>2lh;cP_>2lh;cP_>2lh00ol0>G9KLU]bFg9KLU]bFg9KoeAEE5EDEEAEE5EDEECoP7:0
LX1bP7:0LX1bolfmcKg=_LfmcKg=oj?=X`02o`0@cJ?=XlgoO8elSGb=O8elS@;o00WCam?7dlOCaol0
8`02o`P00_lV0000;@02oaX000?o>c/03S/01?o>mlh2o`0K2lh;cP_>2lh;cP_>2ooZc^[>j/kZc^[>
j/kZ00;o03k>oeG>ELiEcUG>ELiEcUG>EOmcE7=DLeAcE7=DLeAcE?mDcEC=E<eDcEC=E<goSLf=cHg=
SLf=cHgoXj:SXP?o012SXZ?oXlJSaZ?6XlJSolOo1lL2ob<000?o00001@001?l00?lU0000:P03oa/0
037o<1/`6c0K<1/`6c0K<1/`6c0Koa_o6c/K>a/k6c/K>a/k6c/K>ol;cP_>2lh;cP_>00;o04?>>lhk
og9KLU]bFg9KLU]bFg9KL_mEE5EDEEAEE5EDEEAEog:0LX1bP7:0LX1bP7;ocKg=_LfmcKg=_Oo=XlfS
cJ?=00;o00jScOmlSGb=O8elSGcod`;o00G7dlOCa`02ob@000?o000010001?l00?lU0000:002oa`0
0_lC>`;o01W>2lh;cP_>2lh;cP_>2lh;c_o>j/kZc^[>00?o04O>n/kjc_[>oeG>ELiEcUG>ELiEcUG>
EOmcE7=DLeAcE7=DLeAcoleDcEC=E<eDcEC=E?o=SLf=cHg=SLf=cOnRXj:SXZ>RX`03o`0;aZ?6XlJS
aZ?6Xol00/L00oo7a`02a`03olOo02@000?o00000`001?l00?lU00009@03oad002ooBolK<1/`6c0K
<1/`6c0K<1/`6c3oBolk6c/K>a/k6c/K>a/k6c/K>a_ocP_>2`02o`1=>lhkcS_>>lhkcS_oLU]bFg9K
LU]bFg9KLU_oE5EDEEAEE5EDEEAEE?n0LX1bP7:0LX1bP7:0okg=_LfmcKg=_LfmolfScJ?=XlfScJ<0
0_l037b=O8elSGb=olOCa`;o00GCaoo7o`0T0003o`0000<000Co003o9@0002801OlM0005oc5K<Ol0
43/06Olk<C_o2lh;cP_>2lh;cP_>2lh;cP_>olh00_l0DO[>n/kjc_[>n/kjc_[ocUG>ELiEcUG>ELiE
cUG>oeAcE7=DLeAcE7=DLeCoE<eDcEC=E<eDcEC=E?o=SLf=cHg=SLf=oj>RXj:SXZ>RXj;oa`02o`08
aZ?6XlJSa_l4a`?o0/L00ol0000Q00;o1@02obH0000P00;o8@005?m;Fd]KBolK<1/`6c0K<1/`6c0K
0_l05d/;B`];oc/K>a/k6c/K>a/k6c/K>a/k00;o02PkcS_>>lhkcS_>>lhkcS_>oe]bFg9KLU]bFg9K
LU]bFomDEEAEE5ED5ol05;g=_LfmcKg=oj?=XlfScJ?=Xlgo0Z<2o`0AO8elSGb=olOCam?7olOCaol0
8@001?l00?l/00007@03ob8000Wo<E/aFc5K<Ol02c/0>ola>c4k<C/a>ol;cP_>2lh;cP_>2lh;cP_o
moojc_[>n/kjc_[>n/kjc_[>n_o>ELiEcUG>ELiEcUG>00Wo01MDLUAbE7;oE<eDcEC=E<eDcEC=E?nS
c@03o`0EcHg=SLf=oj>RXj:SXZ>RXj;oahc700;o00G6XlJSo`04a`Co00?7o`008`000ol0000Z0000
6`02ob@002coBe];Fd]KBe];oa/`6c0K<1/`6ol;B`];2d/;B`_o6c/K>a/k6c/K>a/k6`;o01mK6e_o
cS_>>lhkcS_>>lhkcS_>>ombFg9KLU]bFg9K00?o02=Ec_mbEG9ELUEbEG9ELUEbog?=LleccG?=Llec
cG?oX/fRc@04o`0>cKgocJ?=XlfScJ?=Xol5X`;o00=lSG`01?l01lOoam?odol090000ol0000Y0000
6003ob@00_l02c5K<E/aFc5K<E_o00Pk01Oo<C/a>c4k<C/a>c7ocP_>2lh;cP_>2`02o`0Nc_O>mlkg
oo[>n/kjc_[>n/kjc_[>n/koELiEcUG>0ol0:U@?E0mD3ombE79DLUAbE79DLUAboeC=E<eDcEC=E<eD
cECoXlfScJ?=X`Co016RXj:SXZ>RXj:Sohc7S<N<a`05o`C700?oalL00_lU0003o`0002P0000G00;o
9@005?mKBe];Fd]KBe];Fd]Koc0K<1/`0_l0=0];2d/;B`];2d/;B`_o6c/K>a/k6c_oFa]K6e/KFa]K
olhkcS_>>lhkcS_>>lhkcS_oLU/3o`0`ELiEcUG>ELiEc_mbEG9ELUEbEG9ELUEbog?=LleccG?=Llec
cG?oX/fRcJ;=X/fR0ol02Z?=XlfScJ?=Xol3X`?o00jSooooam?7dlOoam?7ob<00_lZ00005`03ob<0
017oFc5K<E/aFc5K<E/aFc5Ko`03>`0Goc/a>c4k<C/a>c4k<C/a>ol;cP_>2lh00_l06oO>mlkgc_O>
mlkgoo[>n/kjc_[>n/kjc_[>nP03o`0fE0mD3e@?E0mD3e@?E0ooLUAbE79DLUAbE79DL_mDcEC=E<eD
cEC=E<eDoj?=XlfScJ?=Xoo10ol01Z>RXj:SXPCo00J<ahc7S<L2o`G700GoalO7o`0T0003o`0002L0
000G0004o`00ob4002[oFd]KBe];Fd]KBe];Fd]KBe_o<?m;2d/;B`];2d/;B`];2d/;Bolk6c/2o`0J
6e/KFa]K6e/KFa]K6olkcS_>>lhkcS_>>lh3o`0l3omEcUG>ELiEcUG>ELiEcUG>og9ELUEbEG9ELUEb
EG;oLleccG?=LleccG?=olfRcJ;=X/fRcJ;oXj:S0ol00j?oo`02o`ZS0_l02=?7dooCam?o90000ol0
000W00005`001Ol0003o01l004CoFc5K<E/aFc5K<E/aFc5K<E/aFolk<C/a>c4k<C/a>c4k<C/a>c4k
o`_omlkgc_O>mlkgc_O>mlkgc_o>n/kjc_[>nP?o040kE3]D>omD3e@?E0mD3e@?E0mD3e@?og9DLUAb
E79DLUAbE7;oE<eDcEC=E<eDcEC=olfScJ?=XlfScJ?o`J;11Ol03j?oS<N<ahc7S<N<aoo7o`03a`05
olO7aol090000ol0000V00005P03o`<000?o00006`005?mKBe];Fd]KBe];Fd]KBe];Fd]K0_l04`];
2d/;B`];2d/;B`];2d/;B`/00_l065/KFa]K6e/KFa]K6e/KFa]K6olkcS_>>`;o028?6`lK3a/?6`oo
ELiEcUG>ELiEcUG>ELiEc_mbEG9ELUEb3_l04<eccG?=olfRcJ;=X/fRcJ83o`05Xj:SXZ<00ol:X`0:
om?odlOCom?7obD000?o00009@0001H000?o000010000ol0000I0011oe/aFc5K<E/aFc5K<E/aFc5K
<E_oBc7o<C/a>c4k<C/a>c4k<C/a>c7o>oo>mlkgc_O>mlkgc_O>mlkgc_O>olh00ol06e@kE3]D>e@k
E3]D>omD3e@?E0mD3e@?E0mD3`09o`093U@>E0iD3UCo00G=2Ol01LfScJ?=00Co00W1X/6R`J;1X/40
0_l02LN<ahc7S<N<o`02a`;o00?7olL00/L00ol0000R00;o9P0000l00_l50003o`0000D000?o0000
60005?m;Fd]KBe];Fd]KBe];Fd]KBe_o14/09ol;B`];2d/;B`];2d/;B`_o6c0Koa]K6e/KFa]K6e/K
Fa]K6e/KF`02o`0K6`lK3a/?6`lK3a/?6`lK3omEcUG>ELiEcUG>00?o020?E0ooLUAbE79DLUAbE79D
LUCocG;=L/ebcG;=L/goX`Go00o=X/fRoj>RXj:SXZ>RolL00_l7X`0:olOCaoo7olOCobD000?o0000
900000h000Co003o1002o`L000?o00005P009olkoc5K<E/aFc5K<E/aFc5K<E_oBc5;<D/aoc4k<C/a
>c4k<C/a>`02o`Dk02coc_O>mlkgc_O>mlkgc_O>molkoc]D>e@kE3]D>e@kE3]D>e@koe@?E0mD3`?o
01L?E0mD3e@?o`iD3U@>E0iD3U@>E0iDo`0;c@?o00>FXYH01_l05<6R`J;1X/6Rohalohc7S<N<ahco
0lL00oo7o`02a`03o`0002<000?o00008`0000h000Co003o10000ol000070003o`0001@001Co<@La
od]KBe];Fd]KBe];Fd]Ko`M;02?oB`];2d/;B`];2d_o<1/`6c0K<1_o6e/KFa]K6e/KFa]K6`02o`0H
9C0Uo`lK3a/?6`lK3a/?6`lK3a/?oeG>0ol08PmD3e@?E0mD3e@?og9DLUAbE79DLUAbE79DolebcG;=
L/d3o`0;cOnSUZ>FXiJSUZ<00ol02::SXZ>RXj;o0/L2o`FS00GodlOCa`03o`03am?o02@000?o0000
8`0000h000Co003o10000ol000080003o`00018002So>d/kBc_o<E/aFc5K<E/aFc5Kod/aBc5;<D/a
Bolk<C/a>c4k<C_o2S/02oo>mlkgc_O>mlkg00;o01O>>lhkcS_o>e@kE3]D>e@kE3]D>e@kE003o`0O
3e@?E0mD3e@?E0mD3e@?o`iD3U@>E0iD3U@>E0iDo`03c@?o1Ld03?nFXYJRUZ:FXYKoa`?o00VR`J;1
X_n<O8`00_l01Hc7S<Oo00G700CoalOo9@000ol0000R00003P001?l00?l400;o2P000ol0000@000D
oc47<@La1c7oBe];Fd]KBe];Fol;B`0eod/;B`];2d_o<1/`6c0K<1/`6c3oFa]K6e/KFa]KobD`9C0U
<2D`9Ol?6`lK3a/?6`lK3a/00ol07h]DRol?E0mD3e@?E0mD3e@?E0ooLUAbE79DLUAbE7802ol04W;=
L/goXiJSUZ>FXiJSohc7S0;o00FSXZ>Ro`04a`;o0Z<02oo7dlOCam?odlOo02@00_lS00003`02o`@0
00?o00002`000ol0000>000Voc];>d/kBc];>olaFc5K<E/aFom;<D/aBc5;<D/aBc7o<C/a>c42o`dk
00Oomlkgc_O>00;o01@kcS_>>lhkcS_>>olkE3]D>e@kE0?o01/?J`m[3f/?o`mD3e@?E0mD3e@?E0mD
3ol>E0h01ol01UCoog9Do`G=2?l039JRUZ:FXYKoal37`0;o00VR`OmlS7b<O8`00_l00hcoa`05a`?o
9@000ol0000Q00005@000ol0000<0003o`0000`001Co<@La1c47<@La1omKBe];Fd]Ko`i;01Wo2d/;
oa/`6c0K<1/`6c0K<1/`6c3oFa]K00;o01@`9C0U<2D`9C0U<2D`9Ol?6`lK3`;o01V;E8]DReB;E8]D
Rol?E0mD3e@?E0mD3e@?00Go00EDLUAbE003o`0AE79DLUCoL/ebcG;=L/ebcG801?l02j>FXiJSohc7
S<N<00Co1lL02OnSolOCam?7d`03obD000?o0000800001D00_l>0003o`0000X002Oo>d/kBc];>d/k
Bc];oe/aFc5Kod/aBc5;<D/aBc5;<D/aBc7o<Ol04S/05_ogoc_>>lhkcS_>>lhkcS_>>lhkoc/3o`0F
J`m[3f/?J`m[3f/?J`oo3e@?E0mD3`Go00L?E0mDog9D00?o00YDLUAbE79DLUCo2ld00oo=`004o`0:
XYKoal37`<O0a`;o00MlS7b<O8al00;o1/L00oo7o`0V0003o`0001l0000E0003o`0000h00_l:000C
o`La1c47<@La1c47<@OoFd]Ko`0BB`0Doa/`6c0K<1/`6c0K<1/`6c0K<1/2o`0B9C0U<2D`9C0U<2D`
9C0U<2D`0ol058]DReB;E8]DReB;E8]DReB;o`mD1?l02@mD3e@?E0mD3`03o`0OE79DLUAbE79DLUAb
E?mbcG;=L/ebcG;=L_o0Xl2S`004o`08S<N<ahc7S<L2o`O70_l02<OCam?7olOo9@02o`H01?l300;o
0`03o`/0000E0003o`00010000?o00001P009Om;>d/kBc];>d/kBc];>d_oFom;<D/aBc5;<D/aBc5;
<D/aBc400_lB>`0Yod];oc_>>lhkcS_>>lhkcS_>>lko3g/?o`m[3f/?J`m[3f/?J`m[3f/00ol02U@?
E0mD3e@?E0l3o`0B3e@?oeAbE79DLUAbE79DLUCo2ld02?o=`<g0cL3=0ol01l37`<O0al000ol027b<
O8alocco1LL2obD00_l70003o`0000<00_l60003o`0000P0000E00;o4P000ol00004000Co`La1c47
<@La1c47<@La1c47o`0BB`0Wod]Koc0K<1/`6c0K<1/`6c0K<1_o:`H[1_lU<2D`9C0U<2D`9C0U00;o
019;<4/`Bon;E8]DReB;E8]DRe@3o`0:F`mKoe@?E0mD3`?o00l?E0mD3e@?oeAbE79DLU@03_l03/eb
cG;o`:?0Xl2S`:?00ol01lN<ahc7ol400_l4a`08olOoom?7dlL2obH000?o00001@000ol0000:0003
o`0000P0000E0003o`00018000?o00000P00:om;>d/kBc];>d/kBc];>d/kBc_o<D/aBc5;<D/aBc5;
<D/aBc7o<E/aFol03C/2o`I;01Go>lhkcS_>>lhkcS_oN`mk3g/?N`l00_l026/?J`m[3f/?0_l02Po>
3lh?cPooE0l3o`093e@?E0mD3e@?00Wo00MbE79DLUCo00O=2?l02Lg0cL3=`<goaP02o`05al37`?l0
0/L2o`07O8alocc7o`03a`03olOo02D000?o00001P000ol0000600?o2`0001@000?o000050006Ol0
0?l7<@La1c47<@La1c47<@La1c7o6ol03d/09_m;Fd]KBe_o<1/`6c0K<1/`6c3o1R/6:`H[1R/6obD`
9C0U<2D`0_l04C1;<4/`Bc1;<4/`oeB;E8]D00;o00X?F`mK3e/?F`mK0_l02@mD3e@?E0mD3`03o`0O
3eD?og=DLeAcE7=DLeAcE?mDLeAcE7=DLeAcE?nGXP03o`08`:?0Xl3oal43o`06S<Oo`M?10_l2a`03
olO700;o00C7dooo9P000ol000020004o`00o`P000?o00002`0001@00olE00;o02i;>d/kBc];>d/k
Bc];>d/kBc_o<C/aoc5;<D/aBc5;<D/aBc7o<E/aFc5K<E_o2C/00om;B`09B`0Hoc_>>lhkc_l?N`mk
3g/?N`mk3g/?Nom[0ol02@o>3lh?cPo>3`03o`083omD3e@?E0l3o`0E3e@?E0mD3ombE79DLUAbE79D
LUCo00_=00GocJ;=XP04o`07`<goa/O6a`02o`03`?o700?70_l01Wco?<Llo`;70_lU00;o1002o`T0
1?l:000050000ol0000E000Jo`La1c47<@La1c47<@La1c47<OlKFa]K6ol;B`0Uod]KBe];Fd]KBolK
<1/`6c0K<?l6:`H[1R/6:`H[1R/6obD`9@02o`0?Bc1;<4/`Bc1;<4/`Bc1;00?o00P?F`mK3e/?F`?o
00QK3e/?FomD3`?o02`?E@mE3eD?E@mE3omcE7=DLeAcE7=DLeCoE7=DLeAcE7=DLeCoUj:GXYNRU`Co
00G7`LO1a`03o`05`M?1dl400ol3a`05olOoaol08`000ol0o`0M00003003o`D000?o00005000<_m;
>d/kBc];>d/kBc];>d/kBc_o<C/a>c4kod/aBc5;<D/aBc7o<E/aFc5K<E/aFc7o1C/2o`m;01co>omk
3g/?N`mk3g/?N`mk3g/?o`mk3oo>3lh?0ol020o>3lh?cPo>0ol07@mD3e@?E0mD3e@?E0mD3ombE79D
LUAbE79DLUCo00_=00[ocJ;=X/fRcJ;=0ol01/O6alK7aP;o1LL2o`03?<Ll00Co9P000ol0000J0000
3`000ol0000200;o5@007?la1c47<@La1c47<@La1c47<OlKFa]K6e/KFol8B`0Tod]KBe];Fd]KBe];
Fd_o6c0Kob/6:`H[1R/6:`H[1R/6:`H[0ol03T/`Bc1;<4/`Bc1;<4/`0_l01BD`9C0U00Co00QK3e/?
F`mK3`?o03PK3a_o3eD?E@mE3eD?E@mE3eD?og=DLeAcE7=DLeAcE?mDLeAcE7=DLeAcE?nGXYNRUj:G
XYOo`0?o00C1al770ol01L7C`M?100;o0lL3obD000?o00006P0000l000?o00000P000ol0000C000g
o`Oo>d/kBc];>d/kBc];>d/koc4k<C/a>c4k<C_oBc5;<D/aoc5K<E/aFc5K<E/aFc5K<Olko`0AB`0@
of]kJol?N`mk3g/?N`mk3`;o00Ek3g/?N`04o`08cPo>3lh?cPl2o`0NE4]DBeA;E?l?E0mD3e@?E0mD
3e@?E0ooLUAbE79D3_l4c@0>olfRcJ;=X/fRcOo6XlH2o`05a/O6og`00_l3a`06ogcoacc70_lV0003
o`0001T0000<00?o10000ol0000C000Ooc4;<Ola1c47<@La1c47<@Laoa]K6e/KFa]K6e/Ko`05B`0i
od]KBe];Fd]KBe];Fd]KBe];ob/6:`H[1R/6:`H[1R/6:`H[oc4T<B@aod/`Bc1;<4/`BolU<2D`00?o
00X`9C0Uo`mK3e/?0_l060lK3a/?6`lK3a_o3eD?E@mE3eD?E@mE3`So00ibEG9ELUGocEG=ELeEc@So
00bGXYNRUj:Gol2S`:<2o`05`LOoO8`00_l01L7Cogco00?70_lU00;o6P0000`000?o00001002oa<0
03Wo1b/7:`Oo>d/kBc];>d/kBc_o<C/a>c4k<C/a>c4k<OlaBc7o<E/aFc5K<E/aFc5K<E/aFc7oJol0
3T/2o`0>Jg][Nf]kJol?N`mk3g/2o`033g/?00;o00Yk3g/?N`mk3oo>0ol05EA;E4]DBeA;E4]DBeCo
3e@?E0mD3`05o`0NELkoE5EDEEAEE5EDEEAEoleDcEC=E<eDcEC=ohg=0ol02lfRcJ;=olJSaZ?600Co
00Alagco0/L01_mloolla`;o9@000ol0000H00003004o`<000?o00004@00E_la2c4;<@/aoc47<@La
1c47<OlKFa]K6e/KFa]K6e/KFa_oBom;Fd]KBe];Fd]KBe];Fd]KBolaJc7o:`H[1R/6:`H[1R/6ob@a
934T<B@a937oBc1;0_l00c0Uo`02o`0:9C0U<2D`9C0U<0;o01@K3a/?6`lK3a/?6`lK3a/?6ol?E@Co
02IE3eD?E@mE3ombEG9ELUEbEG9ELUGocEG=ELeEcEG=ELgocKg=_@Co00ZRUoo0Xl2S`:?00_l00gb<
O002o`05domldol00/L00ol0000T0003o`0001L0000C0003o`00010003Oo1b/7:`L[1b/7oc];>d/k
Bc_o<C/a>c4k<C/a>c4k<C/a>c7o<E/aFc5K<E/aFc5K<E/aFc7o00E[00?oBd/024/04OmkJg][Nf]k
Jg][Nf_o3ol?00?o00/?N`mk3g/?N`mk3`02o`0CBlkoE4]DBeA;E4]DBeA;E4]DB`03o`0^cUG>ELiE
cUG>ELiEc_mDEEAEE5EDEEAEE5GocEC=E<eDcEC=E<goSLf=cHg=S@Co00S6XlJSaZ?6X`;o00?7O<L0
0ol01W`locc7obH000?o00005P0001<000?o00004000E?l;<@/a2c4;<@/aoc47<@Laoa]K6e/KFa]K
6e/KFa]K6e/KFomKBe];Fd]KBe];Fd]KBe];oc5[<F/aJc7o:`H[1R/6:`Ko934T<B@a934T<B@a90Co
024U<2D`9C0U<2D`9C0Uoc0U<2D`oa/?6`lK3a/?6`lK3a/00_l0=<ko3eD?E@mE3eD?E@mE3eGoEG9E
LUEbEG9ELUEbEOo=ELeEcEG=ELeEcOo=_LfmcKg=_Ld3o`08Xl2S`:?0olL2o`03O8al00;o00=ldol0
0olU00;o5`0001<00_l@000fob/7:`L[1b/7:`L[1olkBc_o<C/a>c4k<C/a>c4k<C/a>c4kod_oFc5K
<E/aFc5K<E/aFc7o2F/00om;B`03B`;o00akJg][Nf]kJg][Nf/3o`9k00coN`mk3g/?N`mk3g/2o`0B
cT_>Bli;c_mDBeA;E4]DBeA;0_l0>Lh;cP_ocUG>ELiEcUG>ELiEcUGoEEAEE5EDEEAEE5EDoeC=E<eD
cEC=E<eDcOn=cHg=SLf=cHgoX`03o`07XlJSa_n<O002o`03agc700;o00<lO?l00_lU0003o`0001D0
000C0003o`0000h0057o2c4;<@/a2c4;<@/a2c7o<OlKFa]K6e/KFa]K6e/KFa]K6e_o1c47oe];Fd]K
Be];Fd]KBolaJc5[<F/aJc5[<Ol[1R_o<B@a934T<B@a93401?l01B@a934T00;o00LU<2D`9C0U00;o
018U<2D`9C0U<2D`oa/?6`lK3a/2o`0ncT_>Bli;c_l?E@mE3eD?E@mE3eD?EOmELUEbEG9ELUEbEG;o
ELeEcEG=ELeEcEGo_LfmcKg=_LfmcOn=Uhd2o`07`:?0olN<a`02o`06O8coom=l0olU0003o`0001@0
000B0003o`0000h003Ko:`L[1b/7:`L[1b/7:`L[1ola>c4k<C/a>c4k<C/a>c4k<C_oBc];>d_oFc5K
<E/aFc5K<Ol=J`0<od_oJg][Nf]kJg][0ol00f]ko`08N`;o01Mk3g/?oli;cT_>Bli;cT_>BlkoE4]D
B`02o`12cP_>2lh;cP_>2oo>ELiEcUG>ELiEcUG>oeAEE5EDEEAEE5EDEECoE<eDcEC=E<eDcECocHg=
SLf=cHg=SOnSXZ>R0_l02Z?6ohalS7coO<L3o`03O?oo02D000?o0000500001800_l>0014o`/a2c4;
<@/a2c4;<@/a2c4;oe/KFa]K6e/KFa]K6e/KFa]Ko`La1c47<@OoFd]KBe];Fd_o<F/aJc5[<F/aJc5[
<F/3o`07934T<B@a9002o`0B<B@a9?lT<B@a934T<B@a9?l`0_l04C0U<2D`9C0U<2D`9C0U<?lK00;o
02?>Bli;cT_>Bli;cT_>o`mE3eD?E@mE3eD?E@ooLUEbEG9ELP0>o`0EcEG=EOnmcKg=_LfmcKgoUhfG
SIN=00Co00C7S<N<0_l01HcoO?ml00;o9@000ol0000C00004P000ol0000=000eo`L[1b/7:`L[1b/7
:`L[1b_o:olk<C/a>c4k<C/a>c4k<C_oBc];>d/kBc_o<E/aFc5K<Ol03V/02?mkNg_oNf]k0ol017][
Nf/2o`ak0_l04D_>Bli;cT_>Bli;cT_>Bli;00;o01c>2lh;cP_>2lh;cP_>2lkoELiEcUG>ELiEcUG>
2Ol03UAEE5EDEOnmE;eD_EBm2?l04<f=cHg=SLgoXZ>RXj:SXZ<2o`05S7b<O8`00ol00gcoo`02ob@0
0_lD00004P000ol0000<0019oc4;<@/a2c4;<@/a2c4;<@_onS7joe/KFa]K6e/KFa]K6e_o1c47<@La
1c47<Om;Fd]KBolaJc5[<F/aJc5[<F/aJomkRg^;N`03o`0V934T<B@aoc4T<B@a934T<B@a937oB`Ko
9C0U<2D`9C0U<2D`9C02o`0JFoo>Bli;cT_>Bli;cT_>Bli;oeD?E@mE3eD4o`0OELkoE7=DLeAcE7=D
LeAcE?o=E<eDcEC=E<eDcOmDc@03o`0?_LfmcKgoUhfGSIN=UhfG00;o00F<ahc7S002o`03O3co00;o
90000ol0000B00004P02o``003Go1b/7:`L[1b/7:`L[1b/7:ol[1b/7:olk<C/a>c4k<C/a>om;>d/k
Bc];>d/kBc_o<E/ao`0>J`04og]kN`?o00Ukoom[Nf]kJol03G/00omKF`02F`0Vod_>Bli;cT_>Bli;
c_o>6lhKo`_>2lh;cP_>2lh;cP_>2lkoELh4o`0VELiEcUG>EOmEE5EDEEAEE5EDEEAEokeD_EBmE;eD
_EBmoh3=P<d3o`0>cHgoXj:SXZ>RXj:Soj82o`05S7b<O8`00_l013co??lT0003o`000140000B0003
o`0000X004Go<@/a2c4;<@/a2c4;<@/a2ooj<OXanS7joe/KFa]K6e/KFa_o<@La1c47<@La1c47<Om;
oc5[<F/aJc5[<F/aJc5[og/00ol0:G^;Nh]kRola937o<B@a934T<B@a934T<Om;1T/6B`Ko9C0U<2D`
9C0U00;o01HKFa]K6e_ocT_>Bli;cT_>Bli;cT_>0ol0;EG>ELiEcUG>ELiEc_mDLeAcE7=DLeAcE7?o
E<eDcEC=E<eDcEC=oeC=E<eDc@04o`0<SIN=UhfGSIN=oj?70_l01hc7S?mloc`00olT0003o`000100
000300?o1002o`H000?o00002@00=?l7:`L[1b/7:`L[1b/7:`L[ob/7:`L[1b/7:olk<C/a>c4k<Olk
Bc];>d/kBc];>d/kBc/2o`e[0ol:N`03of_o00ek00?oFe/01U/01om;cT_>Blh00_l05A_>6lhKcQ_>
6ol;cP_>2lh;cP_>2`03o`0cj_o>ELiEcUG>ELiEcUG>oeAEE5EDEEAEE5EDEECoE;eD_EBmE;eD_ECo
cH3=P<f0cH3=00?o00bRXj:SXZ>RXonRaj82o`04S7cod`Go8P03o`H00ol8000010000ol000020004
o`00o`@00_l:0011oc4;<@/a2c4;<@/a2c4;<@/aoc7j<OXanS7j<OlKFa]K6e/Koc47<@La1c47<@La
1c47<@Oo6om[<F/aJc5[<F/00ol03G^;Nh]kRg^;Nh]kRg/00ol02b@a934T<B@a934T00;o02E;1T/6
B`I;1T/6obD`9C3o6e/KFa]K6e/KFa]Koli;cT_>Bli;00;o03Wjc_[>n_mEcUG>ELiEcUG>ELiEog=D
LeAcE7=DLeAcE?o=E<eDcEC=E<eDcECocEC=E<eDcEC=og<00ol04IN=UhfGolNSaj?7olN<ogc700Co
8`000ol000070003o`0000D000040003o`00008000Co003o10000ol00009000iob/7:`L[1b/7:`L[
1b/7:`Oo1b/7:`L[1b/7:`Oo<C/a>c7o>d/kBc];>d/kBc];>d/kBomK1e_o00I[0_l00f_oN`0<N`05
og^;Nol02G/00omKF`0;F`0Hod_oolhKcQ_>6lhKcQ_>6lhKo`_>2lh;0_l0?/kZc^[>j/kZoliEcUG>
ELiEcUG>EOmEE5EDEEAEE5EDEEAEokeD_EBmE;eD_EBmoh3=P<f0cH3=P<goXZ>R0_l02Z>RXj;oaj;7
X/L2o`04O?oCO0;o00<lo`008P000ol000060003o`0000D000040003o`00008000Co003o10000ol0
0008000mon[o2c4;<@/a2c4;<@/a2c7o<OXanS7j<OXanS7j<OlKFa_o<@La1c47<@La1c47<@La1olK
Ja][6om[<@03o`0A<F_oNh]kRg^;Nh]kRg^;Nol01G/2o`0E<B@a934To`I;1T/6B`I;1T/6B`I;00;o
01=K6e/KFa]K6e/KFa]K6e/KFoo>00?o04;jc_[>n/kjc_[>oliEcUG>ELiEcUG>ELkoE7=DLeAcE7=D
LeAcE?o=E<eDcEC=E<eDcOmDcEC=E<eDcEC=og>=Lhd2o`0:UhfGolNSaj?7X`?o00Ilaooo??lR0003
o`0000<00ol8000010000ol000020004o`00o`@00_l8000koa/76ol[1b/7:`L[1b/7:`Oo1b/7:`L[
1b/7:`L[1b/7oc7o>d/kBc];>d/kBc];>d/kBomK1e/7F`L00ol4J`03og]k00]k00WoNh]kRg^;Nh/0
0_l3N`03oe]K00aK01CoBoo>6lhKcQ_>6lhKcQ_>6lhKcP;o04OZc^[>j/kZc^[>j/kZc_mEcUG>ELiE
cUG>ELiEoeEDEEAEE5EDEEAEE?mD_EBmE;eD_EBmE;goP<f0cH3=P<f0oj>RXj:SXP04o`08X/NRaj;7
X/L2o`06dgcoocco8P000ol000020003o`0000P0000300;o1@02o`D000?o00001P00>OoZ1nX7j_l;
<@/a2c4;<@/aoc7j<OXanS7j<OXanS7j<OXaoc47<@La1c47<@La1c47<@Oo6f/KJ`03o`0EJa_oJc5[
og^;Nh]kRg^;Nh]kRg_o00]k02Co9?l6B`I;1T/6B`I;1T/6Bol[<2_o6e/KFa]K6e/KFa]K6e/2o`0V
Boo>n/kjc_[>n/kjc_[>n_mEcUG>ELiEcUG>ELiEog=DLeAcE7<>o`0HcEC=E?o=E<eDcEC=E<eDohec
SG>=Lhec0_l02J?7XlNSaj?7X`02o`03aooo00;o8002o`@01?l700004@000ol00006000fo`LK1a/7
6ol[1b/7:`L[1b_o:`L[1b/7:`L[1b/7:`L[1b_oBc];>d/kBc];>d/kBc];oe/70ol02@MK1e/7Fom[
o`0=N`0=og^;Nh]kRg^;Nh]kR`03o`aK0_l0<T/kBc];olhKcQ_>6lhKcQ_>6ol;m`_golkZc^[>j/kZ
c^[>j/kZoliEcUG>ELiEcUG>2Ol03UAEE5EDEOnmE;eD_EBm2?l04/f0cH3=P<goXZ>RXj:SXZ>RX`;o
00W7X/NRaj;7olL00_l01==loolQ0003o`0000`0000A0003o`0000D003?o1nX7jPOZ1n[o2c4;<@/a
2ooj<OXanS7j<OXanS7j<OXan_l;o`La1c47<@La1c47<@L01?l02V/KJa][6f/KJa/2o`0=Rg^;Nh]k
Rg^;Nh]ko`0<N`0Rog][Nom;1T/6B`I;1T/6oc0[<2/`:c0[oa]K6e/KFa]K6`;o01c>Bli;cT_oc_[>
n/kjc_[>n/kjc_[oELiEcUG>1?l07b_=oeAcE7=DLeAcE7=DLeCocEC=E<eDcEC=E<goSLd00ol04LeD
cEC=og>=LhecSG>=LonS00;o00RSaj?7XlOod`;o00Alaooo8@000ol0000;00004002o`H003;o1a/7
6`LK1a/76ol[1b/7:ol[1b/7:`L[1b/7:`L[1b/7:ol[1b_oBc];>d/kBc];>`?o0107F`MK1e/7F`MK
1e/7o`Oo2W/05?mkRg^;Nh]kRg^;Nh_oNf]kJg_o25/04_lkBc];>d/kBc];olhKcQ_>6`;o01[g2oL;
m`_g2ooZc^[>j/kZc^[>j/kZc_mEcPCo02IEcUG>ELiEoeEDEEAEE5EDEEAEE5Go_EBmE;eD_EBmE;go
P<f0c@?o013=P<goXZ>RXj:SXZ>Roj?60_l01lNRaj;7olL00_l01==ldolP00;o3000010000?o0000
1@00<?oZ1nX7jPOZ1nX7j_l;<@_onS7j<OXanS7j<OXanS7j<O[o2c4;<@_o1c47<@La1`?o01`KJa][
6f/KJa][6f/KJomKJe_oRg^;Nh]kRg_o37/03_mkJg][Nf]kod/6B`I;0_l0:c0[<2/`:c0[<2/`:olK
Fa]Koli;cT_>Bli;cT_>oo[>n/kjc_[>n/kjc_X00ol0;B_=:ld[cB_=:ld[cOmDLeAcE7=DLeAcE7?o
E<eDcEC=E<eDcEC=ohg=SLf=c@04o`0;SG>=LhecSG>=Lol00j<2o`0<XlNSolOCaomlagco7`02o``0
000@0003o`0000@002ko6`LK1a/76`LK1a/76ol[ob/7:`L[1b/7:`L[1b/7:`L[ob/7:`L[1b_oBc];
0ol05T_oF`MK1e/7F`MK1e/7F`Oo1f/7J`L2o`Ek01SoNh]kRg^;Nh]kRg^;og][Nf]kJg][Nol3F`0B
od/kBc];>d/kBc];>d/kBoo>0_l05`_g2oL;m`_g2oL;moo>j/kZc^[>j/kZ00?o03?ZoliEcUG>ELiE
cUG>ELiEoeEDEEAEE5EDEEAEE?mD_EBmE;eD_EBmE?o=P<f0cH3=P<d00ol04j:SXZ>RXj:SolJSaZ?6
oj;7X_l00/L2o`03dgco024000?o00002@0001000_l4000/onX7jPOZ1nX7jPOZ1nX7j_oj<OXanS7j
<OXanS7j<OXan_l;<@/a2c4;<@/3o`0P1c47oa][6f/KJa][6f/KJa][oe][Ff]KJe][og^;Nol<N`0O
og][Nf]kJg][Nf]kod_o:c0[<2/`:c0[<2/`:c0[<002o`0GBli;cT_>Bli;cT_>Bli;olkjc_[>n/h0
0_l0>OO>mlkgob_=:ld[cB_=:ld[cB_=oeAcE7=DLeAcE7=DLomDcEC=E<eDcEC=E?o=SLf=cHg=SLgo
L`03o`07LhecSG>=o`05X`;o00G7Xoo7d`03o`03aol001l000?o00002@00010000?o00000P00:_lK
1a/76`LK1a/76`LK1a/7o`L[1b/7:`L[1b/7:`L[1b/7o`L[1b/7:`?o06D[od/kBomK1e/7F`MK1e/7
F`MK1ol7J`M[1f/7J`M[og_oNh]kRg^;Nh]kRg^;og][Nf]kJg][Nf]kJg_oBc];>d/kBc];>d/kBc];
>olko`_g2oL;m`_g2oL;m`_g2oOoc^[>jP02o`0nc^[>j/kZc^[ocUG>ELiEcUG>ELiEc_mDEEAEE5ED
EEAEE5Go_EBmE;eD_EBmE;goP<f0cH3=P<f0cOnRXj82o`0<Xj:SX_nSaZ?6XlJS0ol3a`05olOoO?l0
80000ol00008000040000ol00002000Wo`OZ1nX7jPOZ1nX7jPOZ1om[oc7j<OXanS7j<OXanS7j<Ola
2c4;00?o02<;<@/a2ol7oa][6f/KJa][6f/KJa][oe][Ff]KJe][Ff]KJ`02o`]k00koNf]kJg][Nf]k
Jg][N`;o02D`:c0[<2/`:c0[<2/`:c3o>`/koli;cT_>Bli;cT_>Bli;c_oj00?o04;gc_O>mlkgc_O>
old[cB_=:ld[cB_=:ld[og=DLeAcE7=DLeAcE?o=E<eDcEC=E<eDcOn=cHg=SLf=cHg=og>RLj82o`04
Lheco`RS0_l02=?7olOColOo7P03o`T0000?00?o0P009Ol76`LK1a/76`LK1a/76`Oo1a/7o`L[1b/7
:`L[1b/7:`Oo1b/00ol0@B/7:`L[1b/7:omK1e/7F`MK1e/7F`MK1ol7J`M[1f/7J`M[1f/7o`OoRg^;
Nh]kRg^;og][Nf]kJg][Nf]kJg_o009K00go>d/kBc];>d/kBc];00;o01@k<C/a>ol;m`_g2oL;m`_g
2oL;m`;o02CZc^[>j/kZc^[>j/kZc_mEcUG>ELiEcUG>ELiEc_mDEEAEE5D:o`0IE;eD_EBmE;goP<f0
cH3=P<f0oj>RXj:SXP03o`0;X_nSaZ?6XlJSaZ<00_l01<OoalL2oa/00ol20003o`0000L0000?000V
o`000?l7jPOZ1nX7jPOZ1nX7jPOoJc9[<V_o<OXanS7j<OXanS44o`0<2c4;<@/a2c4;<@/a0_l06a][
6f/KJa][6f/KJomKJe][Ff]KJe][Ff]Ko`03J`;o1W/0<omkJg][Nf]kJg][Nf]koe/aFc7o<2/`:c0[
<2/`:ol;>`/k2c/;od_>Bli;cT_>Bli;cP02o`0NFoo>mlkgc_O>mlkgc_O>mlkocB_=:ld[cB_=:ld[
2?l02UC>E<iDc_o=ELd7o`0EE?o=SLf=cHg=SLf=oj9cXW>RLj9c00;o2J<02On<olOoam?7o`0G00?o
1@000ol00007000000@0oooo0`03o`D002Go0000oa/76`LK1a/76`LK1a/76olK1a/76`Oo1b/7:`L[
1b/700;o034[1b/7:`L[1b/7:`L[1ol7BomK1e/7F`MK1e/7Fom[1f/7J`M[1f/7J`Oo1f/7J`M[00;o
01:;Nh_oNf]kJg][Nf]kJg][Nol6F`0joc];>d/kBc];oc4k<C/a>c4k<Oog2oL;m`_g2oL;ooL;m`_o
c^[>j/kZc^[>j/kZc^[ocUG>ELiEcPGo01W>>omcE7=DLeAcE7=DLeCocEC=E<eDcEC=00Go01;=P<f0
cH3=oj:SXZ>RXj:SXZ<2o`0=XlJSaZ?6XlKoS?o7o`03a`03o`0001001?l80003o`0000L000020003
o`0000D000?o00000P008_l00?oZ1nX7jPOZ1nX7jPOZ1n[o<V/bJc9[<V_o<OXanS44o`0[2c4;<@/a
2c4;<@/a2c7o1a/76olKJa][6f/KJa_oJe][Ff]KJe][Ff]Ko`09J`0Oog_oNf]kJg][Nf]kJg][NomK
<E/aFc5K<Ol`:c0[<002o`0C2c/;>`/k2c/;>oo>Bli;cT_>B`02o`0HcU_>FliKolkgc_O>mlkgc_O>
mlkgob_=1?l08g;>L/ibcW;>oeC>E<iDcUC>E<iDc_o=ELeEcEG=ELeEoiJ=00?o017=SLf=cOmcXW>R
Lj9cXW?oX`02o`JS00?oQX`00_l01M?7dlOo00h00ol=0003o`0000H000020003o`0000D000Co0000
1?l071/76`LK1a/76`LK1a/76olK1a/76`LK1a_o:`L3o`0i1b_o:`L[1b/7:`L[1b/7:`Oo1d/7B`M;
oe/7F`MK1e_oJ`M[1f/7J`M[1f/7o`M[1f/7J`M[1f/700;o00e[Nf]kJg][Nf]kJg_o00YK01So>d/k
oc/a>c4k<C/a>c4k<C_o2oL;m`/2o`0G2oL;m`_g2oL;olkZc^[>j/kZc^[>j/h00ol0:S_>>lhkcS_>
>lhkcS_oLeAcE7=DLeAcE7=DoleDcEC=E<eDcECoLj9cXP?o01c=P<goXZ>RXj:SXZ>Roj?6olJSaZ?6
Xoo7S<Oo0lL00ol0000900?o40000ol0000600000P000ol0000200?o1@02o`0JjPOZ1nX7jPOZ1nX7
jPOZoc9[<V/bJc9[<V/3o`0`<OXan_l;<@/a2c4;<@/a2c4;<Ol76`LK1a/76olKJa][6om[Ff]KJe][
Ff]KJe_o36/0B?lkof]kJg][Nf]kJg_oFc5K<E/aFc5K<E/aoc3o>`/k2c/;>`/k2c/;>`/koli;c_o>
FliKcU_>FliKcU_oc_O>mlkgc_O>m`;o030a3ombcW;>L/ibcW;>L/ibc_mDcUC>E<iDcUC>E?mEcEG=
ELeEcEG=EOnFSIJ=UXd4o`0;XW>RLj9cXW>RLol00Z<2o`BS00[oS8J<Q_oCam?o1P04oa<000?o0000
1P00008000?o00000P000ol0000500;o01L76`LK1a/76`LK1a/76`Oo1a/76`LK1`03o`1<1a_o:`L[
ob/7:`L[1b/7:`L[1b/7o`M;1d/7B`M;1d_oF`MKof/7J`M[1f/7J`M[1ol7J`M[1f/7J`M[1f_oF`MK
of]kJg][Nf]ko`iK01?o>c4k<C/a>c4k<C/a>c4k<Oog00;o01Gg2oL;m`_g2oL;m`_gon[>j/kZc^X0
0ol0=A_>6lhKolhkcS_>>lhkcS_>>lhkog=DLeAcE7=DLeAcoeC=E<eDcEC=E<eDog>RLj9cXW>R00?o
00fRXj:SXZ>RXoo6XlJS00;o00S6XlKoS<N<a`;o0/L00ol00003oaL000?o00001P0000030?oo00@0
1?l300;o01D7jPOZ1nX7jPOZ1nX7jPOoJc9[<V/00ol0=F/bJc9[<_ojo`/a2c4;<@/a2c4;<@/a2olK
1a/76`LK1a/76olKof]KJe][Ff]KJe][Ff_o00][00Ko>e/kFc/2o`0DNf]kJg_oFc5K<E/aFc5K<E/a
Fc42o`0@2c/;>`/k2c/;>`/k2c/;>`;o01EKcU_>FliKcU_>FliKcU_>ooO>mlh00_l0>`la3c4?<@la
3ombcW;>L/ibcW;>L/ibc_mDcUC>E<iDcUC>E?mEcEG=ELeEcEG=EOnFSIJ=UXfFSOo000?o00McXW>R
Lj;o00FS00coXj>Sohb6S?n<olL3oaX000?o00001P0000h001Co1a/76`LK1a/76`LK1a/7o`LK1`?o
02P76`LK1a/76`LKob/7:`L[1b/7:`L[1b/7:om;1d/7B`M;1d/7B`M;0_l09PM[1f/7J`M[1f/7Jom[
1f/7J`M[1f/7JomK1e/7F`MK1omkJg_o3U/0:?m;<Ola>c4k<C/a>c4k<C/a>olkooL;m`_g2oL;m`_g
2oL;m`_gonX2o`0IcQ_>6lhKcQ_>6lhKolhkcS_>>lhkcS_>>`0Fo`0AcEC=E?mcXW>RLj9cX_nRXj80
0_l02j>RXj;oXlJSaZ?600;o00^SolN<ahcoS?o7o`0K0003o`0000H0000>00;o0107jPOZ1nX7jPOZ
1nX7of/b0_l0;F/bJc9[<V/bJc9[<V_o<@/a2c4;<@/a2c4;<@_o6`LK1a/76`LK1a/76`OoJ`02o`0:
Je][Ff]KJe][o`][01go>e/kFc]K>e/kFomkoe/aFc5K<E/aFc5K<E/ao`04B`0Ro`/k2c/;>`/k2c/;
>omK2e_ocU_>FliKcU_>FliKcU_>F`;o01L?<@la3c4?<@la3c4?<@ooL/ibcW;>LP04o`0@3eCoLUAb
E79DLUAbE79Do`K=2?l02iJ=UXfFSOo0Xl2S00;o00AcXW?o1j<3o`06QXb6S?n<0olJ0003o`0000H0
000>000?o`3o1a/76`LK1a/76`LK00?o034K1a/76`LK1a/76`LK1ol7o`L[1b/7:`L[1b/7:om;1d/7
B`M;1d/7B`M;1ol7F`MK00;o0207J`M[1f_oJ`M[1f/7J`M[1f_oF`MK1e/7F`MK1e/7o`iK017oBc5;
<D_o>c4k<C/a>c4k<@02o`0C>c4k<C_om`_g2oL;m`_g2oL;m`02o`0Ec_o>6lhKcQ_>6lhKcQ_>6lhK
olhk00Co01ED3e@?E0mDog9DLUAbE79DLUAbE?l02/d00onFX`03o`0:Lj9cX_nRXj:SXP?o01BRoj?6
XlJSaZ?6ohc7S<N<ohc7oa/000?o00001@0000d00_l20009o`OZ1nX7jPOZ00?o02lbJc9[<V/bJc9[
<V/bJc9[o`OZ1ola2c4;<@/a2c4;oa/76`LK1a/76`LK1a/7o`07J`06oe][Ff_o2f/07OlkFc]K>e/k
Fc]K>e/koc5K<E/aFc5K<E/aFc7o00M;03?o>`/k2c/;>`_o2e/;F`]K2e_ocU_>FliKcU_>FlkoNc]k
>ola3c4?<@la3c4?<@la3c400ol06PmD3e@?E0mD3e@?E?mbE79DLUAbE79DLUCo2/d01OnRc:;<00?o
00ZFSOo0Xl2S`:?00_l9X`;o00R6S8KoQXb6oaX000?o00001@0000h000Wo0000o`LK1a/00ol0>Q_o
6`LK1a/76`LK1a/76`LK1ol76`LK1ol7:`L[1b/7:`Oo1d/7B`M;1d/7B`M;1ol7F`MK1e/7F`L2o`0N
Jom[1f/7J`M[1f/7J`Oo1e/7F`MK1e/7F`MKod_o2e/09Om;<D/aBc5;<Ola>c4k<C/aoc4k<C/a>c4k
<C_om`_g2oL;m`/00_l04R_>:lh[c_o>6lhKcQ_>6lhKcP?o01iDFomD3e@?E0mD3e@?E0mDog9DLUAb
E79DLUAbE?l:c@07oiJSUZ>FX`04o`08XZ>RXj:SXZ<2o`0BXlJSaZ?6Xoo7olN<aoo7S<Oo6@000ol0
000500003P000ol0000200Co03?Z1n[o<V/bJc9[<V/bJc9[<V/bJc;ojPOZ1nX7oc4;<@/a2c7o1a/7
6`LK1a/76`LK1ol036/2o`][01coFc]K>e/kFc]K>e/ko`L;1olaFc5K<E/aFc7o2T/01Ol;>`/k00;o
018;F`]K2e/;F`]K2omKcU_>Flh2o`0B>g/kNc]k>g/koc4?<@la3c4?0_l06f/?J`m[3omD3e@?E0mD
3e@?E0mDog9DLUAbE00:o`O=00WoX/bRc:;<X/`00ol02:?0Xl2S`?o70_l6X`0:om?oohb6ohJ<oaT0
00?o00001@0000d00_l200Co05/76`LK1ol76`LK1a/76`LK1a/76`LKoa/76`LK1a/7o`L[1b/7o`M;
1d/7B`M;1d/7B`M;oe/7F`MK1e/7F`MK1ol7o`M[1f/7J`M[1ol7F`MK1e/7F`MK1e_o00E;00?oFe/0
1E/0=om;<D/aBc5;<D/aBc7o<C_o>c4k<C/a>c4k<C/a>c7o2oL;mol[cR_>:lh[cR_>:lkocQ_>6lh0
0_l055]DFeAKE5]DFomD3e@?E0mD3e@?2Ol02UAbE79DLUAbold7o`0<cOnFXiJSUZ>FXoo60_l04::S
XZ>RolN<olJSaZ?6Xol2a`07ohcoS<N<o`0H0003o`0000D0000=00Co1000=?l7jPOoJc9[<V/bJc9[
<V/bJc9[<_oZ1nX7jPOZ1nX7oc4;<Ol76`LK1a/76`LK1a/76ol<J`04o`MK1`;o1V/07?mK>e/kFc]K
>e/kFc_o1`/72`L;1olaFc5K<Ol=B`0Eoc_oF`]K2e/;F`]K2e/;F`]K2omK00;o011k>g/kNc]k>g/k
Nc]k>ola0ol046/?J`m[3f/?J`m[3omD3e@6o`06Ng9kLW_o37802?nFcIK=U/fF1Ol02J;<X/bRc?o6
`@02o`07Xl2S`?o7X`02o`BS00Coam?70ol018b6S?lG0003o`0000D0000=00;o1`00AOl7o`LK1a/7
6`LK1a/76`LK1a_o6`LK1a/76`LK1a/7o`Oo1d/7B`M;1d/7B`M;1d_oF`MK1e/7F`MK1e/7o`M[1f/7
J`02o`0A1f/7o`MK1e/7F`MK1e/7Fol02D/09_mKFe_oBc5;<D/aBc5;<D/aBc5;oc/a>c4k<C/a>c4k
<C/a>c4k0_l04<h[cR_>:lh[cR_>:lh[cR/3o`0>FeAKE5]DFeAKE5]DFe@4o`0<E0mD3e@?E0mD3e@?
0_l0379DLUAbE79DLUAbo`[=1?l029JSUZ?oa/O60_l01j:SX_o7S<L00_l01<JSa_l4a`;o00><aol0
5`000ol0000500003`000ol00005000Pof/bJc9[<V/bJc9[<V/bJc9[o`OZ1nX7jPOZ1nX7jPL2o`0>
6`LK1a/76`LK1a/76ol<J`0Xo`MK1e/7F`MK1om[oe/kFc]K>e/kFc]K>ol72`L;1`/72`L;1olao`m;
0_l08@]K2e/;F`]K2e/;F`]K2e_o<?mk>g/kNc]k>g/kNc]k>`02o`0?<4/`o`m[3f/?J`m[3f/?00;o
01<?N`ooNg9kLW]bNg9kLW]bNg;o00]b00koU/fFcIK=U/fFcOnRc0?o00NRc?o6`LK100;o00RSoj?7
XlNSo`:S00KodlOCam<2o`03S8Ko01L000?o00001000010000?o00001000AolK1a/76`LK1a/76`LK
1a/7o`LK1a/76`LK1a/76`LKoc_oB`M;1d/7B`M;1d_oF`MK1e/7F`MK1e/7o`M[1f/7J`M[1f/700;o
00aK1e/7F`MK1e/7Fol=B`0Sod/aBc5;<D/aBc5;<D/aBom;<Ola>c4k<C/a>c4k<C/a>ol00d/07?l[
cR_>:lh[cR_>:lko3f/?J`m[oe]DFeAKE5/3o`0C3lh?cPo>o`mD3e@?E0mD3e@?E00Eo`C=00GoXl2S
`004o`05a/O6alH00ol01Hc7S<N<00;o00>SolL01<L2o`03S?l001H000?o00001000014000?o0000
1000;OlbJc9[<V/bJc9[<V/bJol7jPOZ1nX7jPOZ1nX7j_lK1a_o6`LK1a/76`LKo`0=J`0Xoe/7F`MK
1e/7F`MKod_o>e/kFc]K>e/ko`L;1`/72`L;1`/72`L;o`i;017oFd]KBol;F`]K2e/;F`]K2`02o`0?
<2D`9C3oNc]k>g/kNc]k00;o00e;<4/`Bc1;<?l?J`m[00;o019k3g/?N`mk3g/?og]bNg9kLW/4o`0@
E0mDog9DLUAbE79DLUAbo`G=2?l01:;<X/`3o`05`LK1a/400_l01Z?7XlNSa`?o00GCam?7d`02o`03
S?l001D000?o0000100001800_l5000Roa/76`LK1a/76`LK1ol76`LK1a/76`LK1a/76olk1c/7>`;o
02d7B`M;1d/7o`MK1e/7F`MK1e/7Fom[1f/7J`M[1f/7Jom;1d_oF`MK1e/7Fol03T/08Olaoc5;<D/a
Bc5;<D/aBom;<D/aBc7o<C/a>c4k<C/ao`08B`07ob_>:lh[cP02o`0=J`m[3f/?J`m[3f_oF`02o`0@
cPo>3lh?cPo>3lh?c_l?E0Co01D?E0mD3e@?E?mbE79DLUAbE79DL_l02/d00onSo`02o`04Xl2S`0?o
00C7a/O60_l01lN<ahc7S?l01/L4oaD000?o0000100001@000?o00000`00:_lbJc9[<V/bJc9[<_oZ
1nX7jPOZ1nX7jPOZ1ol76`LK1a/7o`LK1a/7o`a[00goF`MK1e/7F`MK1e_o00E;01[o>e/kFc_o1`/7
2`L;1`/72`L;1`_ome_go`Y;02ooFd]KBe];Fd_o2e/;F`]K2olU<2D`9C0U<2D`og/kNc_oBc1;<4/`
Bc1;<4/`B`03o`0>3g/?N`mk3g/?N`mk3g/3o`0JE0mD3e@?E0mD3e@?E?mbE79DLUAbE79DL_l:c@04
olbRc0?o00BRc?o60_l00lK1aP03o`05XlNSaj<00_l02=?7dlOCom?o5@000ol0000400005@000ol0
0003001=oa/76`LK1a/76olK1a/76`LK1a/76`LK1ol7>`Lk1c/7>`Oo1d/7o`MK1e/7F`MK1e/7Fom[
1f/7J`M[1f/7Jom;1d/7B`M;oe/7Fol03T/07ola>c4k<OlaBc5;<D/aBom;<D/aBc5;<D_o>c4k<C/0
0_l<B`0@ob_oo`m[3f/?J`m[3f/?J`;o00h?R`oocPo>3lh?cPo>3`?o01iKE5_oE0mD3e@?E0mD3e@?
E?mbE79DLUAbE79DL_l:c@06oj>FXiJS1?l2a`;o00C7a_o70_l01/N<aoo7o`C700CoalOo50000ol0
000400005P000ol00003000Voc9[<V/bJc;ojPOZ1nX7jPOZ1nX7jPOo1a/76`LK1a/76`Oo1ol<J`0=
oe/7F`MK1e/7F`MKo`09B`0Joc_o1`/72`L;1`/72`L;1`_ome_gFoMKmol6B`0Ooe];Fd]KBe];Fd]K
oe/;Fol`9C0U<2D`9C0U<2D`9@03o`0CBc1;<4/`Bc1;<4/`oc/6>`Hk1P02o`05N`mk3g/00ol01`m[
3f/?J`l00_l02@mD3e@?E0mD3`0Fo`C=00Soc:;<X/bRc0?o00?7a_l00ol02<OCoonSaoo70_l01/OC
aoo7oa@000?o0000100001L00_l3000To`LK1a/76olK1a/76`LK1a/76`LK1ol7>`Lk1c/7>`Lk1c/7
0_l08e/7F`MK1e/7F`MKof/7J`M[1f/7J`M[1ol7B`M;1d/7B`M;00;o3D/08?la>c4k<C/a>om;<D/a
Bom;<D/aBc5;<D/aBc5;oc_o3T/03_m[Jf_o3f/?J`m[3f/?0_l02h/?R`n;3h/?Rol?00?o011KE5]D
FeAKE5]DFeCo3e@?1OlF00So00JSUZ>FXiH4o`;70_l3a`07ohc7olOCo`03a`03olOo01@000?o0000
0`0001T002Wo0000of/bJc9[o`OZ1nX7jPOZ1nX7jPOZoa/76`LK1a/76`LK1a_o1`02o`U[00go1e/7
F`MK1e/7F`Oo00];01[o:ol;1`/72`L;1`/72oogFoMKme_gFoMKo`=;00ooFd]KBe];Fd]KBe];Fd/0
0_l06c0U<2D`9C0U<2D`9C0Uoc4T<B@aod/`Bc1;<002o`0;1S/6>`Hk1S/6>`H00_l03`m[3f/?J`m[
3f/?J`m[3`04ob<00ol01lbRc:;o`LH00_l01/K7oooCa`;o00C7olMl0_l01M?7olOo01<000?o0000
0`0001X002[o0000o`LK1ol76`LK1a/76`LK1a/76olk1c/7>`Lk1c/7>`Lko`Lk1c/2o`0SF`MK1e/7
o`M[1f/7J`M[1f/7o`M;1d/7B`M;1d/7o`Lk1ol02D/08_la>c4k<C/a>c4k<C_oBom;<D/aBc5;<D/a
Bc5;<Om[Fol<B`03of][00E[017o3f/?Jon;3h/?R`n;3h/?R`02o`0>3f_oFeAKE5]DFeAKE5/3obX0
0ol01Z>FolO6a`;o0/L2o`;70ol02<OCaoo7olOo4`000ol0000300006`00;?l0003oJol7jPOZ1nX7
jPOZ1nX7j_lK1a/76`LK1a/76`LKo`LV1bH79POo16/03Ol7F`MK1e/7F`MK1ol02d/0>ol[2b/;:ol;
1`/72`L;ooMKme_gFoMKme_gFoMKoe];Fd]KBe];Fd]KBe];og/aNc7o<2D`9C0U<2D`00;o00/a934T
<B@a937oB`02o`0J>`Hk1S/6>`Hk1S_o<4/`Bc3o3f/?J`m[3f/2oc001?l01<76`LH5o`03am?700;o
00S7O<OodooCoa8000?o00000`0001`00_l2000Wo`LK1a/76`LK1a/76`LK1ol7>`Lk1c/7>`Lk1c/7
oc/7>`Lk1c/700;o0287o`M[1f/7J`M[1f/7o`M;1d/7B`M;1d/7o`Lk1c/7>`Oo1D/09_la>c4k<C/a
>c4k<C/a>c7o<D/aBc5;<D/aBc5;<Om[Ff]KJe_o1d/00om[J`09J`?o00Z;3h/?R`n;3h/?0_l03F/?
J`m[3f_oFeAKE5/00_le00?o00G6alK7aP04o`?70_l00m?7o`03oa8000?o00000`0001h002_o003o
1nX7jPOZ1nX7jPOZ1ol76`LK1a/76`LK1a/7obH79PLV1bH79PLV00;o00]K1e/7F`MK1e/7o`0<B`1B
o`/[2b/;:`/[o`/72oogFoMKme_gFoMKme_gFoOo<Om;Fd]KBe];Fd]KBomk<G/aNc5k<Ol`9C0U<?lT
<B@a934T<B@a9?l?N`oo>`Hk1S/6>`;o00a;<4/`Bc1;<4/`o`l3ocX00ol01<K1a/44o`0:aooCogc7
O?o7oa4000?o00000`0001l0063o003o1a/76`LK1a/76`Oo1c/7>`Lk1c/7>`Lk1olk1c/7>`Lk1c/7
>`Oo1om[1f/7J`M[1f_oB`M;1d/7B`M;1d_o>`Lk1c/7>`Lk1om;oc4k<C/a>c4k<C/a>c4k<Ol3>`0F
oc5;<D/aBc5;<Om[Ff]KJe][Ff]Ko`=;00?oJf/02F/00on;R`03R`;o014?R`n;of/?J`m[3f/?J`m[
3`02od000_l00lO6a`02o`09aoo7occodlOC00?o40000ol0000300008000;?l00?l7jPOZ1nX7jPOZ
oa/76`LK1a/76`LK1olV1bH79PLV1bH79POo1c/70_l01`MK1e/7Fol02d/0AOl;:`/[2b/;:`/[2b_o
me_gFoMKme_gFoMKme_goc47<@OoFd]KBe];Fd_oNc5k<G/aNc5k<G/aoc3o934T<B@a934T<@02o`0:
3g/?N`mk3g_o1P;o00/`Bc1;<4/`Bc1;<002od@00_l00lK1o`05o`05domlag`00_lA0003o`000080
000Q000]o`00o`LK1a/76`LKoc/7>`Lk1c/7>`Lk1c_o1c/7>`Lk1c/7>`Oo1c/7>`Lk00;o02e[1f_o
B`M;1d/7B`M;1d_o>`Lk1c/7>`Lk1c/7>olk<C/a>c4k<C/a>c4k<Ol01S/05Om;<D/aBc7oJe][Ff]K
Je][Ff]KJ`03o`U[00?oRh/028/3o`0:J`m[3f/?J`m[3`;oB004o`03aoml00;o00Dlooo7d`02oa00
00?o00000P0002800_l0;`3o1nX7jPOZoa/76`LK1a/76`LK1a_o1bH79PLV1bH79PLVoc/7>`Lk1c/7
oe_o00a;03Wo:`/[2b/;:`/[2b/;oo[oFoMKme_gFoMKme_goc47<@La1c47oe];Fd_oNc5k<G/aNc5k
<G/aNol00g/01ola934T<B@00_l067/?N`mk3g/?N`oo934Toc1;<4/`Bc1;odd00_l02M?oolOodgco
a`02oa0000?o00000P0002@002go0?l76`LKoc/7>`Lk1c/7>`Lk1c_o1c/7>`Lk1c/7>`Lkoc/7>`Lk
1c/7>`L00_l0:0M;1d/7B`M;1d/7o`Lk1c/7>`Lk1c/7>ol[1b_o>c4k<C/a>c4k<Ol9>`0Coc5;<Om[
Ff]KJe][Ff]KJe][o`05N`;o0f/00on;R`09R`03of][00=[0_l010m[3f/2oe000_l00lOoo`02o`03
O?o700;o3`000ol0000200009@00;ol0o`OZ1ol76`LK1a/76`LK1a/7obH79PLV1bH79PLVoc/7>`Lk
1c/7>`Lko`Oo00U;03Wo:`/[2b/;:`/[2b/;ooXanS7ome_gFoMKme_gFol7<@La1c47<@Laod_oNc5k
<G/aNc5k<G/aNol027/03OlTo`mk3g/?N`mk3g/00_l02R@a934T<B@aod/2oe@000?oam<00ol00gco
a`02o`h000?o00000P0002H005Co0?l7o`Lk1c/7>`Lk1c/7>`Oo>`Lk1c/7>`Lk1c_o>`Lk1c/7>`Lk
1c_o1d/7o`M;1d/7B`Oo1c/7>`Lk1c/7>`Lkob/7:`L[1ola>c4k<C/a>ol<>`0?of]KJe][Ff]KJe][
Ff_o00Uk0ol9R`03of][00Q[0_mG00;o00G7ooooO003o`h000?o00000P0002L01?l0:Q/76`LK1a/7
6`LK1olV1bH79PLV1bH79POo1c/7>`Lk1c/7>ol7:`L[1`;o1D/0:_l;:`/[2b/;:`/[2b_o<OXanS7j
<OogFoMKme_o1c47<@La1c47<@La1`;o00ak<G/aNc5k<G/aNol9N`0;oh^;Romk3g/?N`l00_l02c4T
<B@a934T<BCo05/000?odlL00ol00m?oo`0=0003o`000080000Y001?o`3o>`Lk1c/7>`Lk1c_o1c/7
>`Lk1c/7>`Oo1c/7>`Lk1c/7>`OoB`M;1d/7Bom;1d_o>`Lk1c/7>`Lk1c/7o`L[1b/7:`L[1ola>c4k
o`0=>`0>od/7of]KJe][Ff]KJol9N`06og^;Nh]k0_l3R`03of][00U[00?o0000F`02o`06aoooocco
3P000ol000010000:P00J?l0oa/76`LK1a/76ol79PLV1bH79PLV1ol7>`Lk1c/7>`Lk1ol[1b/7:`L[
1b_oBol;:`/[2b/;:`/[2b_o<OXanS7j<OXan_mKme_o1c47<@La1c47<@La1oojNoYkog/aNc5k<G_o
2G/00on;R`06R`0?o`oo934T<B@a934T<BCo06001ol=0003o`000040000[001;o`3oo`Lk1c/7>ol7
>`Lk1c/7>`Lk1c_o>`Lk1c/7>`Lk1om;1d/7B`M;1d/7Bolk1c/7>`Lk1c/7>`Oo1b/7:`L[1b/7:`L[
oc_o00dk00koB`M;1d/7of]KJe][o`Uk00_oNh]kRg^;Nh]kR`02o`U[0_mS00?o00<lool030000ol0
00010000;002o`0[0?l76`LKo`LV1bH79PLV1bH79_lk1c/7>`Lk1c/7>ol7:`L[1b/7:`L[1`02o`0e
2b/;:`/[2b/;:olanS7j<OXanS7j<OXan_l7<@La1c47<@La1c47ooYknW_jNoYkog/aNol02G/00on;
R`08R`0<og]koc4T<B@a937oIP06o`/000?o00000@0002h004Oo0?l7>`Oo>`Lk1c/7>`Lk1c_o>`Lk
1c/7>`Lk1c_o1d/7B`M;1d/7B`Oo1a_o>`Lk1c/7>`Oo1b/7:`L[1b/7:`L[1b/7o`0<>`0>od/7B`M;
1d/7B`OoJol9N`0<og^;Nh]kRg^;Nh_o17/00om[J`03J`03o`0006L000?o??l00_l:0003o`000040
000_001No`3o1olV1bH79PLV1bH79POo1c/7>`Lk1c/7>ol7:`L[1b/7:`L[1ol7nPOjo`/[2b/;:`_o
nS7j<OXanS7j<OXanS7o<Ola1c47<@La1c47ooYknW_jNoYknW_jN`;o27/00on;R`08R`03og]k00Ak
00Go<B@ao`1[00Go2@000ol000010000<000Aol0ool7>`Lk1c/7>`Lk1ol7>`Lk1c/7>`Lko`M;1d/7
B`M;1d/7o`LK1a/76olk1c/7>ol[1b/7:`L[1b/7:`L[1ol7:`Oo00Tk013o1d/7B`M;1d/7B`M;oe_o
1W/03?mkRg^;Nh]kRg^;o`Qk00?oJol0KP04o`P000?o00000@0003400_l0G@3oobH79PLV1bH7o`Lk
1c/7>`Lk1c/7ob/7:`L[1b/7:`L[ooX7nPOj1o[o2b/;ooXanS7j<OXanS7j<OXaoc7j<OXaoc47<@La
1c7oNoYknW_jNoYknW_jo`M[1`02o`=k00?oRh/028/00omkN`07N`;oL004o`P00Ol10040000c0003
o`0000;o0447>`Lk1ol7>`Lk1c/7>`Lk1om;1d/7B`M;1d/7BolK1a/76`LK1a_o>ol[1b/7:`L[1b/7
:`L[1ol7:`L[1b/7o`05>`0Ro`M;1d/7B`M;1d/7BomKJe][Ff_oNomkRg^;Nh]kRg^;o`Uk00?o0000
L@04o`L00Ol10040000d001Oo`000?l79PLVoc/7>`Lk1c/7>`Oo:`L[1b/7:`L[1b_onPOj1oX7nPOj
1o[onS7j<OXanS7j<OXanS7o<OXanS7j<OXaoc47<OmknW_jNoYknW_jNo[o1f/7J`M[1f/00_l9R`03
og]k00Mk00?o0000L`04o`H00Ol10040000e0004o`0000;o05Xkoc/7>`Lk1c/7>`Lko`M;1d/7B`M;
1d/7o`LK1a/76`LK1a/7o`L[1b/7:`L[1b/7:`Oo1b/7:`L[1b/7:`Oo>ol7B`M;1d/7B`M;1d_oFf]K
Je][Ff]Kog/2o`07Nh]kRg^;o`09N`03o`0007D00_l00cco0004007o0@010000=P02o`<00_l0F`Lk
1c/7>`Lk1c_o1b/7:`L[1b/7:`Oo1oX7nPOj1oX7nPOoJolanS7j<OXanS7j<OlanS7j<OXanS7j<OXa
og_jNoYknW_jNoYkn_l7J`M[1f/7J`OoJbE[9Ol018/00omkN`07N`03o`0007L00_l00m?o0003007o
0@010000>0000ol0000200;o05Tk1c/7>`Lko`M;1d/7B`M;1d/7o`LK1a/76`LK1a/7o`LK1ol7:`L[
1b/7:`L[ob/7:`L[1b/7:`L[1b_oB`M;1d/7B`M;1d_oFf]KJe][Ff]Kog/7N`Mk1`02o`03Romk00Qk
00?o0000N@02o`03??l000800Ol10040000i0003o`0000<00ol0F3/7>`Oo:`L[1b/7:`L[1ol7nPOj
1oX7nPOj1o[o<V/bJolanS7j<OXan_oj<OXanS7j<OXanS7jooOonW_jNoYknW_jo`M[1f/7J`M[1om[
9F/UJbE[9F/2o`Qk00?o0000N`03o`<00Ol10040000j0003o`0000D00_l0F@OoB`M;1d/7B`M;1d_o
6`LK1a/76`LK1a_o6`LK1a/7o`L[1b/7:ol[1b/7:`L[1b/7:`L[oc/7>om;1d/7B`M;oe][Ff]KJe][
Fomk1g/7N`Mk1g/7of_o00Ik00?o0000O0001?l00?l3007o0@0003/00_l700;o05L7:`L[1b/7:`L[
ooX7nPOj1oX7nPOj1om[<V/bJc;onS7j<O[onS7j<OXanS7j<OXan_og1oL7moojNoYkn_l7J`M[1f/7
J`OoJbE[9F/UJbE[9Om[1f/00_l3N`03o`0007h000Co003o0P01o`40000m0003o`0000H005co1d/7
B`M;1d_o6`LK1a/76`LK1a/7o`LK1a/76`LKob/7:ol[1b/7:`L[1b/7:`L[1ol7>`Lk1c_oB`M;oe][
Ff]KJe][Fomk1g/7N`Mk1g/7of]KJe][Fomkoh8000Ko003o0?l10000?P000ol0000600;o05P[1b/7
:`Oo1oX7nPOj1oX7nPOoJc9[<V/bJc9[<_ojooXanS7j<OXanS7j<OXao`Og1oL7m`Ogoo[o1f/7J`M[
1f/7JolUJbE[9F/UJbGoJ`M[1f/7J`OoQ0000ol00002o`40000o0003o`0000L00_l0=PM;1ol76`LK
1a/76`LK1a_o6`LK1a/76`LK1a_o:`L[1b/7:`L[1b/7:`Oo1c/7>`Lk1c/7>`;o01i[Ff]KJe][Ff_o
1g/7N`Mk1g/7of]KJe][Ff]KJon40005o`000?l00@0004000_l9000ho`Oo1oX7nPOj1oX7nPOjoc9[
<V/bJc9[<V/bJolanS7j<OXanS7j<OXao`Og1oL7m`Og1oL7o`L2o`0K1f/7J`M[obE[9F/UJbE[9Om[
1f/7J`M[1f_o08H000Co003o0@00048000?o00001`00Dol76`LK1a/76`LK1a_o6`LK1a/76`LK1a/7
o`Oo1b/7:`L[1b/7:`L[oc/7>`Lk1c/7>`Oo1e/7FomKJe][o`Mk1g/7N`Mk1om[Ff]KJe][Ff_o08P0
00?o0?l00@0004<000?o00001`00>Ol7nPOj1oX7nPOj1om[<V/bJc9[<V/bJom[<V_o<OXanS7j<OXa
n_og1oL7m`Og1oL7o`MK1e/7F`02o`0FJolUJbE[9F/UJbE[o`M[1f/7J`M[ohT000?o00000Ol004@0
00?o00001`00>_l76`LK1a/76`Oo1a/76`LK1a/76`LKoa/76`Oo1b/7:`L[1b_o>`Lk1c/7>`Lk1ol7
F`MK1e/7F`L2o`0CN`Mk1g/7N`Mkoe][Ff]KJe][o`2;007o0@01o`00A@02o`P003_o1oX7nPOj1om[
<V/bJc9[<V/bJc;o<V/bJc9[oc7j<OXan_og1oL7m`Og1oL7momK1e/7F`MK1e_o9@02o`0@9F/UJbE[
o`M[1f/7J`M[ohd00_l004L000?o00001P00Bol76`LK1a_o6`LK1a/76`LK1a/7o`LK1a/76`Oo1b/7
:`Oo1c/7>`Lk1c/7>omK1e/7F`MK1e_o1d/7Bol7N`Mkoe][Ff]KJe][o`2=00?o00180003o`0000H0
03co1oX7n_lbJc9[<V/bJc9[<V_oJc9[<V/bJc9[oc7j<Ol7m`Og1oL7m`Ogoe/7F`MK1e/7FolU1bD7
9@L2o`0<Jol7J`M[1f/7J`OoR@04o`<000190003o`0000H003go1a/7o`LK1a/76`LK1a/7o`LK1a/7
6`LK1a/7o`Oo1c/7>`Lk1c/7>omK1e/7F`MK1e_o1d/7B`M;1d/700;o00U[Ff]KJe][Fol0QP04o`L0
001:0003o`0000H001co1om[<V/bJc9[<V/bJc;o<V/bJc9[<V/bJc9[0_l0:?L7m`Og1oL7m`Oo1e/7
F`MK1e_o9@LU1bD79@LU1ol7of/7J`M[1on400?o2`0004/00_l7000no`LK1a/76`LK1a/76olK1a/7
6`LK1a/76`LKob_o>`Lk1c/7>`Oo1e/7F`MK1e/7od/7B`M;1d/7Bol7F`L2o`04Ff]Koh401?l>0000
C@000ol000040013oc9[<V/bJc9[<V/boc9[<V/bJc9[<V/bJc;o2`L;ooL7m`Og1ol7F`MK1e/7F`Oo
1bD79@LU1bD7o`MK1e/7Fol7o`1n00Co4P0004h000?o00001000@OlK1a/76`LK1a/7o`LK1a/76`LK
1a/76ol[1b/7:olk1c/7>omK1e/7F`MK1om;1d/7B`M;1d_o1e/7F`MK1e_o07/01?lF0000C`000ol0
00040010oc9[<V/bJc9[of/bJc9[<V/bJc9[<_l;1`/72`L;ooL7momK1e/7F`MK1ol79@LU1bD79@Oo
1e/7F`MK1e/7ogL01?lJ0000D002o`D003ko6`LK1a/7o`LK1a/76`LK1a/76`Oo1b/7:`L[1b_o>omK
1e/7F`MK1om;1d/7B`M;1d/7oe/7F`MK1e/7ogD00olN0000DP000ol00003000Noc9[<V/boc9[<V/b
Jc9[<V/bJol72`L;1`/72`L;0_l070MK1e/7F`MKobD79@LU1bD79OmK1e/7F`MK1omb00Co8@0005<0
00?o00000P00>ol76`LKoa/76`LK1a/76`LK1ol7:`L[1b/7:`L[1olko`MK1e/7Fol7B`M;1d/7B`Oo
F`MK1e/7F`Oo06l01?lU0000E0000ol00002000Pof/bJom[<V/bJc9[<V/bJc;o2`L;1`/72`L;1ol8
J`P2o`0HF`MKobD79@LU1bD79OmK1e/7F`MK1e_oJ`04obT0001E00;o0`00>?l7o`LK1a/76`LK1a/7
6ol[1b/7:`L[1b/7oc/7>`Lk1omKo`M;1d/7B`M;1omK1e/7F`MK1e_oJ004obd0001G000Uo`000?m[
<V/bJc9[<V/bJc;o2`L;1`/72`L;1ol8J`Q[26/8J`02o`0C1bD79@LU1bD7o`MK1e/7F`MKo`1U00Co
<@0005P002Ko003o6`LK1a/76`LK1a_o:`L[1b/7:`L[1b_o1c/7>`Lk1c_oB`;o0107B`M;1d_o1e/7
F`MK1e_oH`03ocD0001I000go`00oc9[<V/bJc9[<V_o1`/72`L;1`/72om[26/8J`Q[2?lV1bH7obD7
9@Oo1e/7F`MK1e/7o`1O00Co>00005X00_l09@3o6`LK1a/76`Oo1b/7:`L[1b/7:ol7>`Lk1c/7>om;
1d/7B`L00_l034_o1e/7F`MK1e/7oe`01?ll0000G0009ol0oc9[<V/bJol72`L;1`/72`L;1ol8J`Q[
26/8Jol79PLV1bH79P02o`09F`MK1e/7F`Oo05T01?m00000G@00:?l0oa/76`LKob/7:`L[1b/7:`Oo
>`Lk1c/7>`Oo1d/7B`M;1d/7o`L2o`071e/7F`MKo`1E00CoA00005h002oo0?lbJc;o2`L;1`/72`L;
1ol8J`Q[26/8J`So9PLV1bH79POoJ`Q[2?l7F`MKo`1B00CoB00005l00ol09Q_o:`L[1b/7:`L[1olk
1c/7>`Lk1c_oB`M;1d/7B`Oo1c/7>`Lk0_l00e_o001?00?oC00006400ol09`L;1`/72`L;1`_oJ`Q[
26/8J`So9PLV1bH79PLVo`Q[26/8J`Q[o`1=00CoC`00068002Wo0?l7:`L[1b/7:ol7>`Lk1c/7>`Oo
1d/7B`M;1d_o>`Lk1c/7>`Lko`1900CoD`0006<002Oo0?l72`L;1`_oJ`Q[26/8J`Q[o`LV1bH79PLV
o`Q[26/8J`Q[2?l0AP04oeL0001T00?o0287:`L[1olk1c/7>`Lk1c_oB`M;1d/7B`Oo1c/7>`Lk1c_o
@`04oe/0001V00;o02472`Oo26/8J`Q[26/8obH79PLV1bH7of/8J`Q[26/8Jol0@003oel0001W00;o
01l7oc/7>`Lk1c/7>om;1d/7B`M;1ol7>`Lk1c/7>`Oo03d01?mR0000J003o`0LJ`Q[26/8J`Q[o`LV
1bH79PLVo`Q[26/8J`Q[ocX01?mV0000J@04o`0I>`Lk1c/7o`M;1d/7B`M;oc/7>`Lk1c/7o`0g00Co
JP0006/001_o0?ooJ`Q[2?lV1bH79PLV1om[26/8J`Q[2?l0<`04ofh0001/0003o`0000;o01@kod/7
B`M;1d/7o`Lk1c/7>`Lkoc001?mb0000K@001?l00002o`0A1bH79PLV1om[26/8J`Q[2?l0;P03ogH0
001^0003o`0000800ol03PM;1d_o>`Lk1c/7>`Oo:P04ogT0001_00;o1@02o`0;9_l8J`Q[26/8Jol0
9`04ogd0001a0003o`0000@00_l020Lk1c/7>`Oo9004oh40001b0003o`0000D000OoJ`Q[26_o0240
1?n50000L`000ol0000500;o00@k1c_o7@04ohT0001d00;o1`000ol8o`0K00?oS@0007H000?o0000
1@000ol0000F00CoT00007L000?o000010000ol0000B00CoU00007P000?o00000`000ol0000>00Co
V00007T00_l30003o`0000X01?nL0000N`001?l00?l900?oX00007`000?o0?l01@04oj<0001m00;o
00<0ool00_nW0000OP02oj/0003o02`0003o02`0003o02`0003o02`0003o02`00000\
\>"],
  ImageRangeCache->{{{0, 298.062}, {241.375, 0}} -> {-0.0439255, 0.0475809, 
  0.00334333, 0.00334333}}]
}, Closed]],

Cell["Here are the data and best-fit surface combined.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(Show[{wave, wavydataplot}]; \)\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .81114 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1.04977 -0.0679587 1.04977 [
[.13542 .20373 -11.9677 -9 ]
[.13542 .20373 .03234 0 ]
[.3345 .12542 -5.5867 -9 ]
[.3345 .12542 .4133 0 ]
[.54972 .04081 -5.18957 -9 ]
[.54972 .04081 .81043 0 ]
[.73604 .04893 0 -6.20891 ]
[.73604 .04893 12 2.79109 ]
[.8565 .23339 0 -6.03127 ]
[.8565 .23339 6 2.96873 ]
[.95806 .38893 0 -5.88708 ]
[.95806 .38893 6 3.11292 ]
[.02232 .27634 -6 -2.7518 ]
[.02232 .27634 0 6.2482 ]
[.01395 .32882 -6 -2.7962 ]
[.01395 .32882 0 6.2038 ]
[.00529 .38311 -12 -2.84229 ]
[.00529 .38311 0 6.15771 ]
[-0.00368 .4393 -12 -2.89017 ]
[-0.00368 .4393 0 6.10983 ]
[ 0 0 0 0 ]
[ 1 .81114 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.03716 .25514 m
.68874 0 L
s
.14467 .21304 m
.1493 .21769 L
s
[(-2)] .13542 .20373 .99461 1 Mshowa
.34306 .13535 m
.34735 .14032 L
s
[(0)] .3345 .12542 .86223 1 Mshowa
.55745 .05141 m
.56132 .05671 L
s
[(2)] .54972 .04081 .72986 1 Mshowa
.125 Mabswid
.19287 .19417 m
.1956 .197 L
s
.24198 .17493 m
.24466 .17782 L
s
.29204 .15533 m
.29467 .15827 L
s
.39509 .11498 m
.3976 .11801 L
s
.44814 .09421 m
.45059 .09729 L
s
.50225 .07302 m
.50464 .07615 L
s
.09737 .23156 m
.10019 .23431 L
s
.05093 .24975 m
.05379 .25245 L
s
.61378 .02935 m
.61603 .03258 L
s
.67126 .00684 m
.67344 .01012 L
s
.25 Mabswid
.68874 0 m
.96935 .42924 L
s
.72377 .05359 m
.71764 .05592 L
s
[(-5)] .73604 .04893 -1 .37976 Mshowa
.84407 .23761 m
.83786 .23973 L
s
[(0)] .8565 .23339 -1 .34028 Mshowa
.94552 .3928 m
.93925 .39473 L
s
[(5)] .95806 .38893 -1 .30824 Mshowa
.125 Mabswid
.74959 .09308 m
.7459 .09445 L
s
.77448 .13116 m
.77078 .1325 L
s
.79849 .16789 m
.79478 .16921 L
s
.82168 .20336 m
.81796 .20465 L
s
.86572 .27073 m
.86199 .27197 L
s
.88666 .30275 m
.88291 .30397 L
s
.90691 .33374 m
.90316 .33494 L
s
.92653 .36374 m
.92277 .36492 L
s
.69697 .0126 m
.69331 .01403 L
s
.96393 .42096 m
.96017 .4221 L
s
.25 Mabswid
.03716 .25514 m
0 .48963 L
s
.03455 .27159 m
.04067 .26922 L
s
[(0)] .02232 .27634 1 -0.38849 Mshowa
.02622 .32417 m
.03236 .32185 L
s
[(5)] .01395 .32882 1 -0.37862 Mshowa
.0176 .37857 m
.02376 .3763 L
s
[(10)] .00529 .38311 1 -0.36838 Mshowa
.00868 .43488 m
.01485 .43267 L
s
[(15)] -0.00368 .4393 1 -0.35774 Mshowa
.125 Mabswid
.03291 .28197 m
.03658 .28055 L
s
.03125 .29241 m
.03493 .291 L
s
.02959 .30293 m
.03326 .30152 L
s
.02791 .31351 m
.03159 .31211 L
s
.02452 .3349 m
.0282 .33352 L
s
.02281 .34571 m
.02649 .34433 L
s
.02108 .35659 m
.02477 .35521 L
s
.01935 .36754 m
.02304 .36617 L
s
.01584 .38968 m
.01954 .38832 L
s
.01407 .40086 m
.01777 .39951 L
s
.01228 .41212 m
.01598 .41078 L
s
.01049 .42346 m
.01419 .42213 L
s
.03619 .26129 m
.03985 .25985 L
s
.00685 .44638 m
.01056 .44507 L
s
.00502 .45797 m
.00873 .45666 L
s
.00317 .46963 m
.00688 .46833 L
s
.00131 .48138 m
.00502 .48008 L
s
.25 Mabswid
.03716 .25514 m
0 .48963 L
s
0 .48963 m
.39787 .81114 L
s
.39787 .81114 m
.40529 .59895 L
s
.40529 .59895 m
.03716 .25514 L
s
.68874 0 m
.96935 .42924 L
s
.96935 .42924 m
1 .6535 L
s
1 .6535 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.03716 .25514 m
0 .48963 L
s
0 .48963 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.68874 0 m
.03716 .25514 L
s
.40529 .59895 m
.96935 .42924 L
s
.96935 .42924 m
1 .6535 L
s
1 .6535 m
.39787 .81114 L
s
.39787 .81114 m
.40529 .59895 L
s
0 0 m
1 0 L
1 .81114 L
0 .81114 L
closepath
clip
newpath
.5 Mabswid
.57199 .53834 m .59146 .55403 L .55426 .58302 L p .803 .82 .864 r
F P
0 g
s
.55426 .58302 m .53429 .56776 L .57199 .53834 L p .803 .82 .864 r
F P
0 g
s
.53429 .56776 m .55426 .58302 L .51715 .61915 L p .835 .817 .832 r
F P
0 g
s
.01 w
.54437 .59332 Mdot
.5 Mabswid
.51715 .61915 m .49665 .6044 L .53429 .56776 L p .835 .817 .832 r
F P
0 g
s
.49665 .6044 m .51715 .61915 L .47991 .66267 L p .857 .811 .804 r
F P
0 g
s
.60999 .51597 m .62898 .53203 L .59146 .55403 L p .759 .818 .899 r
F P
0 g
s
.59146 .55403 m .57199 .53834 L .60999 .51597 L p .759 .818 .899 r
F P
0 g
s
.47991 .66267 m .45882 .6485 L .49665 .6044 L p .857 .811 .804 r
F P
0 g
s
.45882 .6485 m .47991 .66267 L .44228 .71393 L p .873 .804 .779 r
F P
0 g
s
.01 w
.61395 .54115 Mdot
.52235 .60633 Mdot
.47491 .66981 Mdot
.5 Mabswid
.64852 .5006 m .66709 .51697 L .62898 .53203 L p .697 .807 .933 r
F P
0 g
s
.62898 .53203 m .60999 .51597 L .64852 .5006 L p .697 .807 .933 r
F P
0 g
s
.01 w
.63153 .5317 Mdot
.48752 .64523 Mdot
.5 Mabswid
.44228 .71393 m .42055 .70042 L .45882 .6485 L p .873 .804 .779 r
F P
0 g
s
.42055 .70042 m .44228 .71393 L .40403 .77335 L p .885 .797 .757 r
F P
0 g
s
.01 w
.51286 .59929 Mdot
.5 Mabswid
.68787 .49224 m .70602 .50886 L .66709 .51697 L p .61 .781 .963 r
F P
0 g
s
.66709 .51697 m .64852 .5006 L .68787 .49224 L p .61 .781 .963 r
F P
0 g
s
.01 w
.66715 .51836 Mdot
.43472 .71494 Mdot
.42194 .7459 Mdot
.62273 .52387 Mdot
.52562 .57859 Mdot
.60057 .52999 Mdot
.5 Mabswid
.55199 .52505 m .57199 .53834 L .53429 .56776 L p .811 .849 .878 r
F P
0 g
s
.53429 .56776 m .51374 .55495 L .55199 .52505 L p .811 .849 .878 r
F P
0 g
s
.51374 .55495 m .53429 .56776 L .49665 .6044 L p .844 .843 .843 r
F P
0 g
s
.49665 .6044 m .47551 .59214 L .51374 .55495 L p .844 .843 .843 r
F P
0 g
s
.47551 .59214 m .49665 .6044 L .45882 .6485 L p .867 .834 .812 r
F P
0 g
s
.40403 .77335 m .38159 .7606 L .42055 .70042 L p .885 .797 .757 r
F P
0 g
s
.01 w
.57836 .53706 Mdot
.42964 .71251 Mdot
.5 Mabswid
.59049 .5023 m .60999 .51597 L .57199 .53834 L p .763 .849 .915 r
F P
0 g
s
.57199 .53834 m .55199 .52505 L .59049 .5023 L p .763 .849 .915 r
F P
0 g
s
.01 w
.61832 .52092 Mdot
.53846 .56034 Mdot
.52085 .57659 Mdot
.45515 .65704 Mdot
.5 Mabswid
.45882 .6485 m .43704 .63689 L .47551 .59214 L p .867 .834 .812 r
F P
0 g
s
.43704 .63689 m .45882 .6485 L .42055 .70042 L p .883 .825 .785 r
F P
0 g
s
.01 w
.4856 .61159 Mdot
.63618 .51304 Mdot
.41171 .73957 Mdot
.61382 .51604 Mdot
.5 Mabswid
.7283 .49101 m .74605 .50782 L .70602 .50886 L p .492 .733 .979 r
F P
0 g
s
.70602 .50886 m .68787 .49224 L .7283 .49101 L p .492 .733 .979 r
F P
0 g
s
.01 w
.42455 .70906 Mdot
.4679 .63188 Mdot
.5 Mabswid
.62951 .4866 m .64852 .5006 L .60999 .51597 L p .693 .838 .953 r
F P
0 g
s
.60999 .51597 m .59049 .5023 L .62951 .4866 L p .693 .838 .953 r
F P
0 g
s
.01 w
.51605 .57275 Mdot
.49837 .59017 Mdot
.56914 .5302 Mdot
.5 Mabswid
.42055 .70042 m .39807 .68954 L .43704 .63689 L p .883 .825 .785 r
F P
0 g
s
.39807 .68954 m .42055 .70042 L .38159 .7606 L p .895 .815 .762 r
F P
0 g
s
.01 w
.60937 .51409 Mdot
.67239 .50213 Mdot
.5 Mabswid
.66931 .478 m .68787 .49224 L .64852 .5006 L p .593 .809 .983 r
F P
0 g
s
.64852 .5006 m .62951 .4866 L .66931 .478 L p .593 .809 .983 r
F P
0 g
s
.01 w
.47569 .60641 Mdot
.38839 .76459 Mdot
.56449 .52759 Mdot
.58236 .51691 Mdot
.64543 .49922 Mdot
.43995 .64857 Mdot
.47069 .60385 Mdot
.5 Mabswid
.77012 .49713 m .78748 .51406 L .74605 .50782 L p .342 .655 .97 r
F P
0 g
s
.74605 .50782 m .7283 .49101 L .77012 .49713 L p .342 .655 .97 r
F P
0 g
s
.53136 .50849 m .55199 .52505 L .51374 .55495 L p .803 .82 .864 r
F P
0 g
s
.51374 .55495 m .49259 .53885 L .53136 .50849 L p .803 .82 .864 r
F P
0 g
s
.49259 .53885 m .51374 .55495 L .47551 .59214 L p .835 .817 .832 r
F P
0 g
s
.01 w
.55981 .52465 Mdot
.5 Mabswid
.38159 .7606 m .35835 .75058 L .39807 .68954 L p .895 .815 .762 r
F P
0 g
s
.01 w
.60032 .50782 Mdot
.5 Mabswid
.47551 .59214 m .45378 .57657 L .49259 .53885 L p .835 .817 .832 r
F P
0 g
s
.45378 .57657 m .47551 .59214 L .43704 .63689 L p .857 .811 .804 r
F P
0 g
s
.57035 .48533 m .59049 .5023 L .55199 .52505 L p .759 .818 .899 r
F P
0 g
s
.55199 .52505 m .53136 .50849 L .57035 .48533 L p .759 .818 .899 r
F P
0 g
s
.01 w
.73657 .50422 Mdot
.50145 .56381 Mdot
.5193 .54814 Mdot
.64102 .49596 Mdot
.53717 .53348 Mdot
.39074 .72919 Mdot
.5 Mabswid
.43704 .63689 m .41468 .62193 L .45378 .57657 L p .857 .811 .804 r
F P
0 g
s
.41468 .62193 m .43704 .63689 L .39807 .68954 L p .873 .804 .779 r
F P
0 g
s
.71019 .4766 m .7283 .49101 L .68787 .49224 L p .455 .751 .993 r
F P
0 g
s
.68787 .49224 m .66931 .478 L .71019 .4766 L p .455 .751 .993 r
F P
0 g
s
.01 w
.59573 .50434 Mdot
.55509 .52203 Mdot
.73242 .50019 Mdot
.51443 .54397 Mdot
.5 Mabswid
.60983 .46931 m .62951 .4866 L .59049 .5023 L p .696 .807 .934 r
F P
0 g
s
.59049 .5023 m .57035 .48533 L .60983 .46931 L p .696 .807 .934 r
F P
0 g
s
.01 w
.47857 .57848 Mdot
.53236 .52969 Mdot
.6366 .4933 Mdot
.55032 .51741 Mdot
.44255 .61801 Mdot
.41144 .66746 Mdot
.5 Mabswid
.39807 .68954 m .37502 .67529 L .41468 .62193 L p .873 .804 .779 r
F P
0 g
s
.37502 .67529 m .39807 .68954 L .35835 .75058 L p .885 .797 .758 r
F P
0 g
s
.01 w
.49155 .55631 Mdot
.47355 .57373 Mdot
.56835 .50662 Mdot
.42441 .64032 Mdot
.67792 .48836 Mdot
.45549 .59437 Mdot
.36693 .75479 Mdot
.70094 .48987 Mdot
.43738 .6147 Mdot
.5 Mabswid
.65006 .46043 m .66931 .478 L .62951 .4866 L p .609 .781 .963 r
F P
0 g
s
.62951 .4866 m .60983 .46931 L .65006 .46043 L p .609 .781 .963 r
F P
0 g
s
.01 w
.40617 .66411 Mdot
.72408 .49261 Mdot
.5 Mabswid
.81367 .51093 m .83064 .5279 L .78748 .51406 L p .169 .549 .929 r
F P
0 g
s
.78748 .51406 m .77012 .49713 L .81367 .51093 L p .169 .549 .929 r
F P
0 g
s
.01 w
.50459 .53657 Mdot
.4685 .56985 Mdot
.48654 .5534 Mdot
.41921 .63602 Mdot
.45036 .59063 Mdot
.60469 .48896 Mdot
.67359 .4854 Mdot
.5 Mabswid
.75244 .48264 m .77012 .49713 L .7283 .49101 L p .282 .657 .97 r
F P
0 g
s
.7283 .49101 m .71019 .4766 L .75244 .48264 L p .282 .657 .97 r
F P
0 g
s
.01 w
.37459 .72193 Mdot
.58178 .49328 Mdot
.5 Mabswid
.51014 .48474 m .53136 .50849 L .49259 .53885 L p .784 .763 .834 r
F P
0 g
s
.49259 .53885 m .47091 .51552 L .51014 .48474 L p .784 .763 .834 r
F P
0 g
s
.47091 .51552 m .49259 .53885 L .45378 .57657 L p .812 .765 .809 r
F P
0 g
s
.01 w
.43217 .61151 Mdot
.40085 .6611 Mdot
.5 Mabswid
.45378 .57657 m .43159 .55372 L .47091 .51552 L p .812 .765 .809 r
F P
0 g
s
.43159 .55372 m .45378 .57657 L .41468 .62193 L p .834 .764 .785 r
F P
0 g
s
.35835 .75058 m .33453 .73713 L .37502 .67529 L p .885 .797 .758 r
F P
0 g
s
.54956 .46119 m .57035 .48533 L .53136 .50849 L p .745 .756 .861 r
F P
0 g
s
.53136 .50849 m .51014 .48474 L .54956 .46119 L p .745 .756 .861 r
F P
0 g
s
.01 w
.41391 .6335 Mdot
.62305 .48222 Mdot
.77107 .50545 Mdot
.64612 .48194 Mdot
.36914 .7192 Mdot
.57707 .48991 Mdot
.5 Mabswid
.41468 .62193 m .39192 .59959 L .43159 .55372 L p .834 .764 .785 r
F P
0 g
s
.39192 .59959 m .41468 .62193 L .37502 .67529 L p .85 .762 .765 r
F P
0 g
s
.01 w
.45829 .56145 Mdot
.5 Mabswid
.69134 .45883 m .71019 .4766 L .66931 .478 L p .491 .733 .979 r
F P
0 g
s
.66931 .478 m .65006 .46043 L .69134 .45883 L p .491 .733 .979 r
F P
0 g
s
.01 w
.4086 .62999 Mdot
.61845 .47751 Mdot
.44003 .58171 Mdot
.5 Mabswid
.58942 .44481 m .60983 .46931 L .57035 .48533 L p .694 .743 .889 r
F P
0 g
s
.57035 .48533 m .54956 .46119 L .58942 .44481 L p .694 .743 .889 r
F P
0 g
s
.01 w
.64159 .47737 Mdot
.59538 .48063 Mdot
.53095 .50065 Mdot
.36371 .71504 Mdot
.35041 .74774 Mdot
.4714 .5378 Mdot
.5078 .50798 Mdot
.81904 .52458 Mdot
.5 Mabswid
.37502 .67529 m .35163 .65353 L .39192 .59959 L p .85 .762 .765 r
F P
0 g
s
.35163 .65353 m .37502 .67529 L .33453 .73713 L p .863 .759 .747 r
F P
0 g
s
.01 w
.61383 .47358 Mdot
.52603 .4947 Mdot
.7629 .49767 Mdot
.63707 .47397 Mdot
.59068 .47658 Mdot
.66029 .47313 Mdot
.34486 .74456 Mdot
.46627 .5334 Mdot
.35817 .71253 Mdot
.37149 .68051 Mdot
.38476 .64946 Mdot
.54431 .48325 Mdot
.73507 .48846 Mdot
.39805 .61829 Mdot
.5 Mabswid
.63001 .43561 m .65006 .46043 L .60983 .46931 L p .626 .72 .914 r
F P
0 g
s
.60983 .46931 m .58942 .44481 L .63001 .43561 L p .626 .72 .914 r
F P
0 g
s
.01 w
.7869 .50663 Mdot
.60917 .46923 Mdot
.5 Mabswid
.79642 .49643 m .81367 .51093 L .77012 .49713 L p .088 .53 .906 r
F P
0 g
s
.77012 .49713 m .75244 .48264 L .79642 .49643 L p .088 .53 .906 r
F P
0 g
s
.85932 .53284 m .87591 .54979 L .83064 .5279 L p 0 .422 .855 r
F P
0 g
s
.83064 .5279 m .81367 .51093 L .85932 .53284 L p 0 .422 .855 r
F P
0 g
s
.01 w
.56267 .47431 Mdot
.5 Mabswid
.48844 .45449 m .51014 .48474 L .47091 .51552 L p .767 .721 .81 r
F P
0 g
s
.47091 .51552 m .4488 .48566 L .48844 .45449 L p .767 .721 .81 r
F P
0 g
s
.4488 .48566 m .47091 .51552 L .43159 .55372 L p .794 .726 .789 r
F P
0 g
s
.01 w
.33932 .74051 Mdot
.37941 .64374 Mdot
.36604 .67612 Mdot
.5 Mabswid
.43159 .55372 m .40903 .52426 L .4488 .48566 L p .794 .726 .789 r
F P
0 g
s
.40903 .52426 m .43159 .55372 L .39192 .59959 L p .815 .729 .77 r
F P
0 g
s
.52821 .43056 m .54956 .46119 L .51014 .48474 L p .732 .712 .832 r
F P
0 g
s
.51014 .48474 m .48844 .45449 L .52821 .43056 L p .732 .712 .832 r
F P
0 g
s
.734 .46472 m .75244 .48264 L .71019 .4766 L p .34 .655 .97 r
F P
0 g
s
.71019 .4766 m .69134 .45883 L .734 .46472 L p .34 .655 .97 r
F P
0 g
s
.01 w
.81112 .51653 Mdot
.47437 .50373 Mdot
.5578 .46765 Mdot
.6045 .46542 Mdot
.45599 .52141 Mdot
.5 Mabswid
.33453 .73713 m .31044 .71601 L .35163 .65353 L p .863 .759 .747 r
F P
0 g
s
.01 w
.37402 .63795 Mdot
.3606 .67075 Mdot
.41918 .55716 Mdot
.5 Mabswid
.39192 .59959 m .36885 .57057 L .40903 .52426 L p .815 .729 .77 r
F P
0 g
s
.36885 .57057 m .39192 .59959 L .35163 .65353 L p .832 .73 .753 r
F P
0 g
s
.01 w
.38733 .60783 Mdot
.59971 .45807 Mdot
.45083 .5139 Mdot
.5 Mabswid
.56839 .4138 m .58942 .44481 L .54956 .46119 L p .686 .697 .854 r
F P
0 g
s
.54956 .46119 m .52821 .43056 L .56839 .4138 L p .686 .697 .854 r
F P
0 g
s
.01 w
.48764 .48246 Mdot
.5295 .46475 Mdot
.35514 .66505 Mdot
.41389 .55085 Mdot
.77877 .49908 Mdot
.83568 .52842 Mdot
.5 Mabswid
.67162 .43372 m .69134 .45883 L .65006 .46043 L p .537 .682 .932 r
F P
0 g
s
.65006 .46043 m .63001 .43561 L .67162 .43372 L p .537 .682 .932 r
F P
0 g
s
.01 w
.50605 .46941 Mdot
.67037 .46417 Mdot
.54798 .45536 Mdot
.72238 .47814 Mdot
.5 Mabswid
.35163 .65353 m .32799 .62496 L .36885 .57057 L p .832 .73 .753 r
F P
0 g
s
.32799 .62496 m .35163 .65353 L .31044 .71601 L p .845 .73 .737 r
F P
0 g
s
.01 w
.40861 .54356 Mdot
.48253 .4761 Mdot
.34964 .65943 Mdot
.37654 .59565 Mdot
.80314 .50899 Mdot
.50099 .46268 Mdot
.77468 .4955 Mdot
.69415 .46874 Mdot
.38993 .56546 Mdot
.32241 .72935 Mdot
.45892 .48363 Mdot
.56656 .44676 Mdot
.54302 .44827 Mdot
.5 Mabswid
.46626 .42255 m .48844 .45449 L .4488 .48566 L p .764 .715 .806 r
F P
0 g
s
.4488 .48566 m .42623 .45412 L .46626 .42255 L p .764 .715 .806 r
F P
0 g
s
.42623 .45412 m .4488 .48566 L .40903 .52426 L p .791 .721 .786 r
F P
0 g
s
.60927 .40424 m .63001 .43561 L .58942 .44481 L p .629 .674 .874 r
F P
0 g
s
.58942 .44481 m .56839 .4138 L .60927 .40424 L p .629 .674 .874 r
F P
0 g
s
.01 w
.34416 .65303 Mdot
.5 Mabswid
.40903 .52426 m .386 .49312 L .42623 .45412 L p .791 .721 .786 r
F P
0 g
s
.386 .49312 m .40903 .52426 L .36885 .57057 L p .812 .724 .767 r
F P
0 g
s
.01 w
.37113 .58897 Mdot
.33049 .68844 Mdot
.5 Mabswid
.50639 .39823 m .52821 .43056 L .48844 .45449 L p .729 .705 .827 r
F P
0 g
s
.48844 .45449 m .46626 .42255 L .50639 .39823 L p .729 .705 .827 r
F P
0 g
s
.01 w
.4166 .51015 Mdot
.79912 .50538 Mdot
.31679 .72412 Mdot
.51444 .44334 Mdot
.36574 .58119 Mdot
.5 Mabswid
.84252 .51845 m .85932 .53284 L .81367 .51093 L p 0 .387 .81 r
F P
0 g
s
.81367 .51093 m .79642 .49643 L .84252 .51845 L p 0 .387 .81 r
F P
0 g
s
.36885 .57057 m .34531 .53985 L .386 .49312 L p .812 .724 .767 r
F P
0 g
s
.34531 .53985 m .36885 .57057 L .32799 .62496 L p .829 .725 .75 r
F P
0 g
s
.01 w
.85684 .539 Mdot
.49079 .44795 Mdot
.60898 .44238 Mdot
.5 Mabswid
.77837 .47845 m .79642 .49643 L .75244 .48264 L p .166 .548 .928 r
F P
0 g
s
.75244 .48264 m .734 .46472 L .77837 .47845 L p .166 .548 .928 r
F P
0 g
s
.01 w
.31116 .71826 Mdot
.5 Mabswid
.31044 .71601 m .28615 .68794 L .32799 .62496 L p .845 .73 .737 r
F P
0 g
s
.54688 .38109 m .56839 .4138 L .52821 .43056 L p .685 .69 .849 r
F P
0 g
s
.52821 .43056 m .50639 .39823 L .54688 .38109 L p .685 .69 .849 r
F P
0 g
s
.01 w
.58039 .43266 Mdot
.5 Mabswid
.90752 .56348 m .9237 .58029 L .87591 .54979 L p 0 .291 .761 r
F P
0 g
s
.87591 .54979 m .85932 .53284 L .90752 .56348 L p 0 .291 .761 r
F P
0 g
s
.01 w
.79506 .50168 Mdot
.3331 .63992 Mdot
.5 Mabswid
.71458 .43936 m .734 .46472 L .69134 .45883 L p .426 .627 .937 r
F P
0 g
s
.69134 .45883 m .67162 .43372 L .71458 .43936 L p .426 .627 .937 r
F P
0 g
s
.01 w
.31938 .67508 Mdot
.60415 .43489 Mdot
.42462 .47776 Mdot
.73789 .4771 Mdot
.46188 .44596 Mdot
.55172 .42507 Mdot
.30548 .7129 Mdot
.50427 .42896 Mdot
.628 .43841 Mdot
.4805 .43234 Mdot
.5 Mabswid
.65113 .40198 m .67162 .43372 L .63001 .43561 L p .556 .642 .89 r
F P
0 g
s
.63001 .43561 m .60927 .40424 L .65113 .40198 L p .556 .642 .89 r
F P
0 g
s
.32799 .62496 m .30387 .59468 L .34531 .53985 L p .829 .725 .75 r
F P
0 g
s
.30387 .59468 m .32799 .62496 L .28615 .68794 L p .842 .726 .735 r
F P
0 g
s
.01 w
.31378 .66837 Mdot
.41931 .47024 Mdot
.79107 .49905 Mdot
.65194 .44251 Mdot
.76232 .48576 Mdot
.52294 .41853 Mdot
.29989 .70541 Mdot
.57052 .41727 Mdot
.5 Mabswid
.44348 .39448 m .46626 .42255 L .42623 .45412 L p .777 .745 .824 r
F P
0 g
s
.42623 .45412 m .40297 .4265 L .44348 .39448 L p .777 .745 .824 r
F P
0 g
s
.40297 .4265 m .42623 .45412 L .386 .49312 L p .805 .749 .8 r
F P
0 g
s
.01 w
.62322 .43198 Mdot
.70482 .46036 Mdot
.32192 .62697 Mdot
.5 Mabswid
.58803 .37113 m .60927 .40424 L .56839 .4138 L p .629 .667 .868 r
F P
0 g
s
.56839 .4138 m .54688 .38109 L .58803 .37113 L p .629 .667 .868 r
F P
0 g
s
.386 .49312 m .36223 .46597 L .40297 .4265 L p .805 .749 .8 r
F P
0 g
s
.36223 .46597 m .386 .49312 L .34531 .53985 L p .826 .75 .779 r
F P
0 g
s
.01 w
.4753 .42594 Mdot
.676 .44736 Mdot
.36282 .52968 Mdot
.43268 .44653 Mdot
.39517 .48099 Mdot
.5 Mabswid
.48402 .36975 m .50639 .39823 L .46626 .42255 L p .74 .737 .849 r
F P
0 g
s
.46626 .42255 m .44348 .39448 L .48402 .36975 L p .74 .737 .849 r
F P
0 g
s
.01 w
.51785 .41115 Mdot
.64726 .43682 Mdot
.29422 .69879 Mdot
.494 .41358 Mdot
.56556 .41002 Mdot
.3301 .58521 Mdot
.78695 .49525 Mdot
.34372 .55333 Mdot
.72914 .46732 Mdot
.5 Mabswid
.34531 .53985 m .32095 .5132 L .36223 .46597 L p .826 .75 .779 r
F P
0 g
s
.32095 .5132 m .34531 .53985 L .30387 .59468 L p .843 .749 .76 r
F P
0 g
s
.01 w
.70036 .45602 Mdot
.67142 .44249 Mdot
.87454 .54615 Mdot
.56056 .40214 Mdot
.64251 .43009 Mdot
.28846 .69297 Mdot
.61351 .41601 Mdot
.48881 .407 Mdot
.5 Mabswid
.28615 .68794 m .26138 .65813 L .30387 .59468 L p .842 .726 .735 r
F P
0 g
s
.01 w
.31069 .61251 Mdot
.5 Mabswid
.52489 .35221 m .54688 .38109 L .50639 .39823 L p .691 .723 .874 r
F P
0 g
s
.50639 .39823 m .48402 .36975 L .52489 .35221 L p .691 .723 .874 r
F P
0 g
s
.01 w
.33812 .54671 Mdot
.29681 .64808 Mdot
.28287 .68411 Mdot
.63771 .42275 Mdot
.4836 .39977 Mdot
.44073 .41858 Mdot
.87069 .54238 Mdot
.5 Mabswid
.75925 .45287 m .77837 .47845 L .734 .46472 L p .294 .552 .923 r
F P
0 g
s
.734 .46472 m .71458 .43936 L .75925 .45287 L p .294 .552 .923 r
F P
0 g
s
.82487 .50048 m .84252 .51845 L .79642 .49643 L p 0 .421 .854 r
F P
0 g
s
.79642 .49643 m .77837 .47845 L .82487 .50048 L p 0 .421 .854 r
F P
0 g
s
.69432 .40725 m .71458 .43936 L .67162 .43372 L p .467 .597 .898 r
F P
0 g
s
.67162 .43372 m .65113 .40198 L .69432 .40725 L p .467 .597 .898 r
F P
0 g
s
.30387 .59468 m .27886 .56859 L .32095 .5132 L p .843 .749 .76 r
F P
0 g
s
.27886 .56859 m .30387 .59468 L .26138 .65813 L p .855 .747 .743 r
F P
0 g
s
.63013 .36848 m .65113 .40198 L .60927 .40424 L p .558 .635 .884 r
F P
0 g
s
.60927 .40424 m .58803 .37113 L .63013 .36848 L p .558 .635 .884 r
F P
0 g
s
.01 w
.34607 .51034 Mdot
.6911 .44246 Mdot
.662 .42875 Mdot
.72032 .45831 Mdot
.27704 .67841 Mdot
.50242 .38961 Mdot
.5 Mabswid
.89118 .5493 m .90752 .56348 L .85932 .53284 L p 0 .246 .7 r
F P
0 g
s
.85932 .53284 m .84252 .51845 L .89118 .5493 L p 0 .246 .7 r
F P
0 g
s
.01 w
.41649 .42744 Mdot
.60374 .40144 Mdot
.5 Mabswid
.56637 .34187 m .58803 .37113 L .54688 .38109 L p .628 .7 .897 r
F P
0 g
s
.54688 .38109 m .52489 .35221 L .56637 .34187 L p .628 .7 .897 r
F P
0 g
s
.01 w
.45421 .39812 Mdot
.65719 .42044 Mdot
.27125 .67156 Mdot
.5 Mabswid
.41988 .37276 m .44348 .39448 L .40297 .4265 L p .797 .798 .853 r
F P
0 g
s
.40297 .4265 m .37881 .40528 L .41988 .37276 L p .797 .798 .853 r
F P
0 g
s
.37881 .40528 m .40297 .4265 L .36223 .46597 L p .826 .797 .823 r
F P
0 g
s
.01 w
.62801 .40732 Mdot
.5 Mabswid
.36223 .46597 m .33744 .44534 L .37881 .40528 L p .826 .797 .823 r
F P
0 g
s
.33744 .44534 m .36223 .46597 L .32095 .5132 L p .848 .793 .797 r
F P
0 g
s
.01 w
.77438 .4831 Mdot
.35393 .47649 Mdot
.5 Mabswid
.46094 .34757 m .48402 .36975 L .44348 .39448 L p .755 .794 .884 r
F P
0 g
s
.44348 .39448 m .41988 .37276 L .46094 .34757 L p .755 .794 .884 r
F P
0 g
s
.95877 .60359 m .97451 .62016 L .9237 .58029 L p 0 .17 .663 r
F P
0 g
s
.9237 .58029 m .90752 .56348 L .95877 .60359 L p 0 .17 .663 r
F P
0 g
s
.01 w
.65239 .41301 Mdot
.26544 .66464 Mdot
.68177 .42931 Mdot
.54034 .37282 Mdot
.86303 .53598 Mdot
.71125 .44697 Mdot
.5 Mabswid
.32095 .5132 m .29547 .49321 L .33744 .44534 L p .848 .793 .797 r
F P
0 g
s
.29547 .49321 m .32095 .5132 L .27886 .56859 L p .864 .788 .774 r
F P
0 g
s
.01 w
.40551 .41532 Mdot
.5 Mabswid
.26138 .65813 m .23564 .63265 L .27886 .56859 L p .855 .747 .743 r
F P
0 g
s
.01 w
.92719 .5844 Mdot
.77017 .47953 Mdot
.64758 .40573 Mdot
.67704 .42213 Mdot
.58885 .37792 Mdot
.5 Mabswid
.50228 .32962 m .52489 .35221 L .48402 .36975 L p .699 .783 .916 r
F P
0 g
s
.48402 .36975 m .46094 .34757 L .50228 .32962 L p .699 .783 .916 r
F P
0 g
s
.01 w
.70657 .43933 Mdot
.85911 .53223 Mdot
.7362 .45746 Mdot
.5 Mabswid
.67354 .37337 m .69432 .40725 L .65113 .40198 L p .472 .592 .892 r
F P
0 g
s
.65113 .40198 m .63013 .36848 L .67354 .37337 L p .472 .592 .892 r
F P
0 g
s
.01 w
.61328 .38379 Mdot
.5 Mabswid
.60878 .33886 m .63013 .36848 L .58803 .37113 L p .547 .666 .915 r
F P
0 g
s
.58803 .37113 m .56637 .34187 L .60878 .33886 L p .547 .666 .915 r
F P
0 g
s
.01 w
.30943 .51648 Mdot
.25362 .65189 Mdot
.79545 .49133 Mdot
.5 Mabswid
.27886 .56859 m .2526 .54933 L .29547 .49321 L p .864 .788 .774 r
F P
0 g
s
.2526 .54933 m .27886 .56859 L .23564 .63265 L p .876 .783 .754 r
F P
0 g
s
.7392 .42041 m .75925 .45287 L .71458 .43936 L p .362 .538 .894 r
F P
0 g
s
.71458 .43936 m .69432 .40725 L .7392 .42041 L p .362 .538 .894 r
F P
0 g
s
.01 w
.4814 .36415 Mdot
.27591 .574 Mdot
.63785 .39049 Mdot
.66748 .40735 Mdot
.91958 .57546 Mdot
.5 Mabswid
.80604 .47474 m .82487 .50048 L .77837 .47845 L p .148 .459 .887 r
F P
0 g
s
.77837 .47845 m .75925 .45287 L .80604 .47474 L p .148 .459 .887 r
F P
0 g
s
.54419 .31892 m .56637 .34187 L .52489 .35221 L p .621 .759 .944 r
F P
0 g
s
.52489 .35221 m .50228 .32962 L .54419 .31892 L p .621 .759 .944 r
F P
0 g
s
.01 w
.33658 .46189 Mdot
.69724 .42593 Mdot
.52489 .35411 Mdot
.88537 .54946 Mdot
.26988 .5691 Mdot
.5 Mabswid
.87394 .53145 m .89118 .5493 L .84252 .51845 L p 0 .289 .759 r
F P
0 g
s
.84252 .51845 m .82487 .50048 L .87394 .53145 L p 0 .289 .759 r
F P
0 g
s
.01 w
.45153 .36447 Mdot
.35011 .43666 Mdot
.5 Mabswid
.39538 .35504 m .41988 .37276 L .37881 .40528 L p .809 .836 .872 r
F P
0 g
s
.37881 .40528 m .35366 .38814 L .39538 .35504 L p .809 .836 .872 r
F P
0 g
s
.35366 .38814 m .37881 .40528 L .33744 .44534 L p .84 .832 .838 r
F P
0 g
s
.01 w
.33068 .45746 Mdot
.5 Mabswid
.33744 .44534 m .31158 .42885 L .35366 .38814 L p .84 .832 .838 r
F P
0 g
s
.31158 .42885 m .33744 .44534 L .29547 .49321 L p .863 .824 .809 r
F P
0 g
s
.01 w
.78703 .48341 Mdot
.65781 .39222 Mdot
.47066 .35329 Mdot
.5 Mabswid
.43702 .32936 m .46094 .34757 L .41988 .37276 L p .763 .836 .908 r
F P
0 g
s
.41988 .37276 m .39538 .35504 L .43702 .32936 L p .763 .836 .908 r
F P
0 g
s
.23564 .63265 m .20852 .61421 L .2526 .54933 L p .876 .783 .754 r
F P
0 g
s
.01 w
.2356 .63304 Mdot
.75247 .45752 Mdot
.5 Mabswid
.94292 .58977 m .95877 .60359 L .90752 .56348 L p 0 .123 .594 r
F P
0 g
s
.90752 .56348 m .89118 .5493 L .94292 .58977 L p 0 .123 .594 r
F P
0 g
s
.01 w
.36357 .41412 Mdot
.5 Mabswid
.29547 .49321 m .26883 .47748 L .31158 .42885 L p .863 .824 .809 r
F P
0 g
s
.26883 .47748 m .29547 .49321 L .2526 .54933 L p .879 .816 .783 r
F P
0 g
s
.01 w
.71768 .42948 Mdot
.5 Mabswid
.65245 .3434 m .67354 .37337 L .63013 .36848 L p .447 .615 .922 r
F P
0 g
s
.63013 .36848 m .60878 .33886 L .65245 .3434 L p .447 .615 .922 r
F P
0 g
s
.01 w
.78265 .47789 Mdot
.68287 .40221 Mdot
.25765 .55953 Mdot
.46523 .34825 Mdot
.56358 .34296 Mdot
.5 Mabswid
.4789 .31099 m .50228 .32962 L .46094 .34757 L p .699 .826 .943 r
F P
0 g
s
.46094 .34757 m .43702 .32936 L .4789 .31099 L p .699 .826 .943 r
F P
0 g
s
.587 .31561 m .60878 .33886 L .56637 .34187 L p .518 .717 .963 r
F P
0 g
s
.56637 .34187 m .54419 .31892 L .587 .31561 L p .518 .717 .963 r
F P
0 g
s
.7186 .38613 m .7392 .42041 L .69432 .40725 L p .37 .535 .889 r
F P
0 g
s
.69432 .40725 m .67354 .37337 L .7186 .38613 L p .37 .535 .889 r
F P
0 g
s
.01 w
.3577 .41028 Mdot
.84313 .51704 Mdot
.33829 .42837 Mdot
.90828 .5646 Mdot
.2853 .49923 Mdot
.41565 .36281 Mdot
.25138 .5559 Mdot
.5 Mabswid
.2526 .54933 m .2251 .53445 L .26883 .47748 L p .879 .816 .783 r
F P
0 g
s
.2251 .53445 m .2526 .54933 L .20852 .61421 L p .89 .808 .761 r
F P
0 g
s
.01 w
.87379 .53948 Mdot
.97429 .61849 Mdot
.26528 .52505 Mdot
.5 Mabswid
.78617 .44193 m .80604 .47474 L .75925 .45287 L p .243 .466 .875 r
F P
0 g
s
.75925 .45287 m .7392 .42041 L .78617 .44193 L p .243 .466 .875 r
F P
0 g
s
.01 w
.77367 .46495 Mdot
.4349 .35086 Mdot
.37123 .38874 Mdot
.3323 .42454 Mdot
.73856 .43556 Mdot
.39058 .37348 Mdot
.31266 .445 Mdot
.5 Mabswid
.52132 .29994 m .54419 .31892 L .50228 .32962 L p .608 .8 .973 r
F P
0 g
s
.50228 .32962 m .4789 .31099 L .52132 .29994 L p .608 .8 .973 r
F P
0 g
s
.01 w
.80421 .48651 Mdot
.60812 .34676 Mdot
.45422 .33929 Mdot
.66827 .37809 Mdot
.40994 .35896 Mdot
.9711 .61804 Mdot
.83486 .50823 Mdot
.5 Mabswid
.8554 .50559 m .87394 .53145 L .82487 .50048 L p 0 .356 .83 r
F P
0 g
s
.82487 .50048 m .80604 .47474 L .8554 .50559 L p 0 .356 .83 r
F P
0 g
s
.01 w
.27293 .49092 Mdot
.32625 .42068 Mdot
.54811 .32677 Mdot
.60311 .34094 Mdot
.23875 .54798 Mdot
.5 Mabswid
.37009 .33569 m .39538 .35504 L .35366 .38814 L p .806 .828 .868 r
F P
0 g
s
.35366 .38814 m .32773 .36938 L .37009 .33569 L p .806 .828 .868 r
F P
0 g
s
.32773 .36938 m .35366 .38814 L .31158 .42885 L p .837 .824 .835 r
F P
0 g
s
.63106 .31989 m .65245 .3434 L .60878 .33886 L p .387 .651 .962 r
F P
0 g
s
.60878 .33886 m .587 .31561 L .63106 .31989 L p .387 .651 .962 r
F P
0 g
s
.20852 .61421 m .18004 .60031 L .2251 .53445 L p .89 .808 .761 r
F P
0 g
s
.01 w
.96707 .61128 Mdot
.5 Mabswid
.31158 .42885 m .28493 .41075 L .32773 .36938 L p .837 .824 .835 r
F P
0 g
s
.28493 .41075 m .31158 .42885 L .26883 .47748 L p .86 .818 .806 r
F P
0 g
s
.69777 .35584 m .7186 .38613 L .67354 .37337 L p .327 .549 .913 r
F P
0 g
s
.67354 .37337 m .65245 .3434 L .69777 .35584 L p .327 .549 .913 r
F P
0 g
s
.41233 .3095 m .43702 .32936 L .39538 .35504 L p .762 .827 .903 r
F P
0 g
s
.39538 .35504 m .37009 .33569 L .41233 .3095 L p .762 .827 .903 r
F P
0 g
s
.01 w
.54288 .32168 Mdot
.89695 .55559 Mdot
.5 Mabswid
.92613 .57216 m .94292 .58977 L .89118 .5493 L p 0 .168 .66 r
F P
0 g
s
.89118 .5493 m .87394 .53145 L .92613 .57216 L p 0 .168 .66 r
F P
0 g
s
.01 w
.37889 .3653 Mdot
.5 Mabswid
.26883 .47748 m .24138 .46013 L .28493 .41075 L p .86 .818 .806 r
F P
0 g
s
.24138 .46013 m .26883 .47748 L .2251 .53445 L p .876 .81 .781 r
F P
0 g
s
.01 w
.23225 .54522 Mdot
.44301 .33143 Mdot
.5 Mabswid
.5646 .29635 m .587 .31561 L .54419 .31892 L p .484 .75 .988 r
F P
0 g
s
.54419 .31892 m .52132 .29994 L .5646 .29635 L p .484 .75 .988 r
F P
0 g
s
.01 w
.82634 .49776 Mdot
.96363 .60932 Mdot
.5 Mabswid
.76574 .40725 m .78617 .44193 L .7392 .42041 L p .256 .466 .872 r
F P
0 g
s
.7392 .42041 m .7186 .38613 L .76574 .40725 L p .256 .466 .872 r
F P
0 g
s
.01 w
.75526 .43668 Mdot
.33383 .3929 Mdot
.5 Mabswid
.45475 .29069 m .4789 .31099 L .43702 .32936 L p .699 .816 .938 r
F P
0 g
s
.43702 .32936 m .41233 .3095 L .45475 .29069 L p .699 .816 .938 r
F P
0 g
s
.01 w
.41784 .33846 Mdot
.59298 .32917 Mdot
.48756 .31844 Mdot
.37304 .3599 Mdot
.29421 .43272 Mdot
.85762 .5228 Mdot
.22577 .54159 Mdot
.39256 .34611 Mdot
.95971 .60375 Mdot
.64862 .34997 Mdot
.78634 .46128 Mdot
.43732 .32785 Mdot
.23982 .5107 Mdot
.5 Mabswid
.2251 .53445 m .19676 .51796 L .24138 .46013 L p .876 .81 .781 r
F P
0 g
s
.19676 .51796 m .2251 .53445 L .18004 .60031 L p .887 .802 .76 r
F P
0 g
s
.01 w
.32767 .38974 Mdot
.34743 .37176 Mdot
.25388 .48004 Mdot
.5323 .31297 Mdot
.36703 .35693 Mdot
.64364 .3428 Mdot
.78179 .45479 Mdot
.55747 .31488 Mdot
.43164 .32242 Mdot
.5 Mabswid
.83572 .47246 m .8554 .50559 L .80604 .47474 L p .118 .384 .841 r
F P
0 g
s
.80604 .47474 m .78617 .44193 L .83572 .47246 L p .118 .384 .841 r
F P
0 g
s
.01 w
.95613 .60104 Mdot
.5 Mabswid
.49766 .27927 m .52132 .29994 L .4789 .31099 L p .611 .791 .968 r
F P
0 g
s
.4789 .31099 m .45475 .29069 L .49766 .27927 L p .611 .791 .968 r
F P
0 g
s
.01 w
.26777 .45192 Mdot
.23338 .5065 Mdot
.58273 .31853 Mdot
.34141 .36667 Mdot
.70509 .38123 Mdot
.5 Mabswid
.67674 .33213 m .69777 .35584 L .65245 .3434 L p .233 .561 .936 r
F P
0 g
s
.65245 .3434 m .63106 .31989 L .67674 .33213 L p .233 .561 .936 r
F P
0 g
s
.01 w
.88515 .54455 Mdot
.8492 .51267 Mdot
.52696 .30853 Mdot
.63869 .33764 Mdot
.45122 .31387 Mdot
.18373 .60386 Mdot
.38078 .33676 Mdot
.5 Mabswid
.60911 .30043 m .63106 .31989 L .587 .31561 L p .327 .668 .975 r
F P
0 g
s
.587 .31561 m .5646 .29635 L .60911 .30043 L p .327 .668 .975 r
F P
0 g
s
.01 w
.55222 .31086 Mdot
.21253 .53578 Mdot
.95243 .59759 Mdot
.42586 .3191 Mdot
.5 Mabswid
.3443 .30956 m .37009 .33569 L .32773 .36938 L p .791 .781 .844 r
F P
0 g
s
.32773 .36938 m .30135 .34379 L .3443 .30956 L p .791 .781 .844 r
F P
0 g
s
.30135 .34379 m .32773 .36938 L .28493 .41075 L p .82 .781 .816 r
F P
0 g
s
.01 w
.77236 .43823 Mdot
.57755 .31295 Mdot
.5 Mabswid
.74516 .37667 m .76574 .40725 L .7186 .38613 L p .194 .466 .885 r
F P
0 g
s
.7186 .38613 m .69777 .35584 L .74516 .37667 L p .194 .466 .885 r
F P
0 g
s
.01 w
.80857 .4723 Mdot
.5 Mabswid
.28493 .41075 m .25789 .38576 L .30135 .34379 L p .82 .781 .816 r
F P
0 g
s
.25789 .38576 m .28493 .41075 L .24138 .46013 L p .842 .779 .792 r
F P
0 g
s
.18004 .60031 m .15071 .5848 L .19676 .51796 L p .887 .802 .76 r
F P
0 g
s
.01 w
.88091 .53844 Mdot
.33525 .36302 Mdot
.29537 .40017 Mdot
.5 Mabswid
.38707 .28286 m .41233 .3095 L .37009 .33569 L p .751 .776 .874 r
F P
0 g
s
.37009 .33569 m .3443 .30956 L .38707 .28286 L p .751 .776 .874 r
F P
0 g
s
.01 w
.6644 .34685 Mdot
.49624 .30477 Mdot
.52156 .30396 Mdot
.73139 .39679 Mdot
.5 Mabswid
.90789 .54626 m .92613 .57216 L .87394 .53145 L p 0 .251 .759 r
F P
0 g
s
.87394 .53145 m .8554 .50559 L .90789 .54626 L p 0 .251 .759 r
F P
0 g
s
.01 w
.17699 .60041 Mdot
.20606 .53037 Mdot
.42012 .31269 Mdot
.69538 .36698 Mdot
.80406 .46575 Mdot
.5 Mabswid
.24138 .46013 m .21361 .4358 L .25789 .38576 L p .842 .779 .792 r
F P
0 g
s
.21361 .4358 m .24138 .46013 L .19676 .51796 L p .858 .776 .77 r
F P
0 g
s
.01 w
.9489 .59577 Mdot
.3292 .35681 Mdot
.57235 .30911 Mdot
.28921 .39376 Mdot
.5 Mabswid
.54141 .27537 m .5646 .29635 L .52132 .29994 L p .492 .743 .983 r
F P
0 g
s
.52132 .29994 m .49766 .27927 L .54141 .27537 L p .492 .743 .983 r
F P
0 g
s
.01 w
.269 .41493 Mdot
.34901 .34165 Mdot
.76288 .42228 Mdot
.49071 .29996 Mdot
.5 Mabswid
.42995 .26359 m .45475 .29069 L .41233 .3095 L p .696 .763 .904 r
F P
0 g
s
.41233 .3095 m .38707 .28286 L .42995 .26359 L p .696 .763 .904 r
F P
0 g
s
.01 w
.4398 .30458 Mdot
.51613 .30038 Mdot
.18487 .56091 Mdot
.79941 .45801 Mdot
.36882 .32723 Mdot
.59791 .31468 Mdot
.17017 .59722 Mdot
.94497 .59087 Mdot
.5 Mabswid
.81544 .43739 m .83572 .47246 L .78617 .44193 L p .134 .387 .84 r
F P
0 g
s
.78617 .44193 m .76574 .40725 L .81544 .43739 L p .134 .387 .84 r
F P
0 g
s
.01 w
.30312 .36816 Mdot
.32315 .34997 Mdot
.2137 .49435 Mdot
.87247 .52743 Mdot
.28288 .38897 Mdot
.90901 .56158 Mdot
.3886 .31465 Mdot
.56712 .30522 Mdot
.2626 .41005 Mdot
.45963 .29561 Mdot
.5 Mabswid
.19676 .51796 m .16815 .49436 L .21361 .4358 L p .858 .776 .77 r
F P
0 g
s
.16815 .49436 m .19676 .51796 L .15071 .5848 L p .87 .771 .751 r
F P
0 g
s
.01 w
.62363 .32168 Mdot
.51066 .29421 Mdot
.36289 .32017 Mdot
.43404 .29947 Mdot
.24225 .4316 Mdot
.40846 .30195 Mdot
.17802 .55789 Mdot
.31698 .34432 Mdot
.29686 .36277 Mdot
.94131 .58838 Mdot
.27658 .38329 Mdot
.5 Mabswid
.47329 .25174 m .49766 .27927 L .45475 .29069 L p .623 .74 .93 r
F P
0 g
s
.45475 .29069 m .42995 .26359 L .47329 .25174 L p .623 .74 .93 r
F P
0 g
s
.01 w
.56182 .29976 Mdot
.5 Mabswid
.65523 .31257 m .67674 .33213 L .63106 .31989 L p .147 .555 .927 r
F P
0 g
s
.63106 .31989 m .60911 .30043 L .65523 .31257 L p .147 .555 .927 r
F P
0 g
s
.01 w
.45389 .29169 Mdot
.47951 .29043 Mdot
.42825 .29345 Mdot
.5 Mabswid
.72448 .35284 m .74516 .37667 L .69777 .35584 L p .067 .45 .881 r
F P
0 g
s
.69777 .35584 m .67674 .33213 L .72448 .35284 L p .067 .45 .881 r
F P
0 g
s
.01 w
.23577 .42624 Mdot
.15658 .58867 Mdot
.58755 .30489 Mdot
.86388 .51582 Mdot
.31081 .33795 Mdot
.5 Mabswid
.3182 .27563 m .3443 .30956 L .30135 .34379 L p .772 .734 .818 r
F P
0 g
s
.30135 .34379 m .27474 .31036 L .3182 .27563 L p .772 .734 .818 r
F P
0 g
s
.27474 .31036 m .30135 .34379 L .25789 .38576 L p .8 .739 .796 r
F P
0 g
s
.01 w
.20047 .48454 Mdot
.53078 .29254 Mdot
.37675 .30143 Mdot
.5 Mabswid
.25789 .38576 m .2307 .35285 L .27474 .31036 L p .8 .739 .796 r
F P
0 g
s
.2307 .35285 m .25789 .38576 L .21361 .4358 L p .822 .741 .775 r
F P
0 g
s
.01 w
.21506 .45041 Mdot
.33077 .32316 Mdot
.90096 .55297 Mdot
.93768 .58645 Mdot
.5 Mabswid
.58636 .27922 m .60911 .30043 L .5646 .29635 L p .341 .665 .974 r
F P
0 g
s
.5646 .29635 m .54141 .27537 L .58636 .27922 L p .341 .665 .974 r
F P
0 g
s
.3614 .24844 m .38707 .28286 L .3443 .30956 L p .735 .726 .842 r
F P
0 g
s
.3443 .30956 m .3182 .27563 L .3614 .24844 L p .735 .726 .842 r
F P
0 g
s
.01 w
.82237 .47213 Mdot
.5 Mabswid
.88838 .51283 m .90789 .54626 L .8554 .50559 L p 0 .297 .793 r
F P
0 g
s
.8554 .50559 m .83572 .47246 L .88838 .51283 L p 0 .297 .793 r
F P
0 g
s
.01 w
.5565 .2963 Mdot
.35077 .30843 Mdot
.42241 .2878 Mdot
.5 Mabswid
.15071 .5848 m .12118 .56203 L .16815 .49436 L p .87 .771 .751 r
F P
0 g
s
.01 w
.28446 .34853 Mdot
.49957 .28578 Mdot
.16444 .54904 Mdot
.5 Mabswid
.21361 .4358 m .18576 .40343 L .2307 .35285 L p .822 .741 .775 r
F P
0 g
s
.18576 .40343 m .21361 .4358 L .16815 .49436 L p .839 .741 .756 r
F P
0 g
s
.01 w
.89664 .54636 Mdot
.9334 .57929 Mdot
.81765 .46353 Mdot
.52531 .2881 Mdot
.24348 .39118 Mdot
.5 Mabswid
.79509 .40655 m .81544 .43739 L .76574 .40725 L p .056 .372 .839 r
F P
0 g
s
.76574 .40725 m .74516 .37667 L .79509 .40655 L p .056 .372 .839 r
F P
0 g
s
.01 w
.55112 .29055 Mdot
.44239 .27938 Mdot
.41658 .28089 Mdot
.77578 .41835 Mdot
.22278 .41429 Mdot
.5 Mabswid
.40468 .22868 m .42995 .26359 L .38707 .28286 L p .687 .711 .866 r
F P
0 g
s
.38707 .28286 m .3614 .24844 L .40468 .22868 L p .687 .711 .866 r
F P
0 g
s
.01 w
.29847 .32322 Mdot
.17275 .50537 Mdot
.2781 .34257 Mdot
.25776 .3615 Mdot
.46816 .27991 Mdot
.5 Mabswid
.51743 .24745 m .54141 .27537 L .49766 .27927 L p .527 .7 .949 r
F P
0 g
s
.49766 .27927 m .47329 .25174 L .51743 .24745 L p .527 .7 .949 r
F P
0 g
s
.01 w
.36478 .28715 Mdot
.3186 .30746 Mdot
.15763 .54405 Mdot
.33867 .29319 Mdot
.21641 .4062 Mdot
.9298 .57797 Mdot
.85052 .49563 Mdot
.43658 .27298 Mdot
.54569 .28512 Mdot
.5 Mabswid
.16815 .49436 m .13955 .46256 L .18576 .40343 L p .839 .741 .756 r
F P
0 g
s
.13955 .46256 m .16815 .49436 L .12118 .56203 L p .851 .74 .74 r
F P
0 g
s
.01 w
.63448 .31625 Mdot
.2309 .37416 Mdot
.35872 .28028 Mdot
.48834 .27325 Mdot
.6031 .30243 Mdot
.15083 .5384 Mdot
.13572 .57645 Mdot
.33257 .28543 Mdot
.72919 .3701 Mdot
.57171 .29121 Mdot
.28603 .30772 Mdot
.92554 .57143 Mdot
.84593 .48793 Mdot
.26558 .32662 Mdot
.40481 .26626 Mdot
.5 Mabswid
.44835 .21635 m .47329 .25174 L .42995 .26359 L p .625 .688 .888 r
F P
0 g
s
.42995 .26359 m .40468 .22868 L .44835 .21635 L p .625 .688 .888 r
F P
0 g
s
.29164 .2378 m .3182 .27563 L .27474 .31036 L p .764 .717 .808 r
F P
0 g
s
.27474 .31036 m .24771 .27301 L .29164 .2378 L p .764 .717 .808 r
F P
0 g
s
.24771 .27301 m .27474 .31036 L .2307 .35285 L p .792 .723 .787 r
F P
0 g
s
.01 w
.35274 .27132 Mdot
.45671 .26562 Mdot
.15925 .49363 Mdot
.2244 .36732 Mdot
.17406 .45862 Mdot
.66087 .32602 Mdot
.5 Mabswid
.2307 .35285 m .20312 .31598 L .24771 .27301 L p .792 .723 .787 r
F P
0 g
s
.20312 .31598 m .2307 .35285 L .18576 .40343 L p .814 .726 .768 r
F P
0 g
s
.01 w
.69252 .34376 Mdot
.5 Mabswid
.86825 .47738 m .88838 .51283 L .83572 .47246 L p .013 .302 .795 r
F P
0 g
s
.83572 .47246 m .81544 .43739 L .86825 .47738 L p .013 .302 .795 r
F P
0 g
s
.01 w
.48265 .26804 Mdot
.5 Mabswid
.33526 .21012 m .3614 .24844 L .3182 .27563 L p .729 .707 .83 r
F P
0 g
s
.3182 .27563 m .29164 .2378 L .33526 .21012 L p .729 .707 .83 r
F P
0 g
s
.01 w
.12878 .57121 Mdot
.84117 .47878 Mdot
.59789 .29868 Mdot
.5 Mabswid
.70341 .33326 m .72448 .35284 L .67674 .33213 L p 0 .423 .846 r
F P
0 g
s
.67674 .33213 m .65523 .31257 L .70341 .33326 L p 0 .423 .846 r
F P
0 g
s
.01 w
.27983 .29892 Mdot
.37288 .25894 Mdot
.39888 .25854 Mdot
.42492 .25754 Mdot
.5 Mabswid
.63291 .2912 m .65523 .31257 L .60911 .30043 L p .167 .558 .931 r
F P
0 g
s
.60911 .30043 m .58636 .27922 L .63291 .2912 L p .167 .558 .931 r
F P
0 g
s
.01 w
.79877 .43153 Mdot
.34668 .263 Mdot
.16759 .44977 Mdot
.218 .35892 Mdot
.15258 .48643 Mdot
.92159 .56767 Mdot
.45089 .25984 Mdot
.5 Mabswid
.18576 .40343 m .15754 .36705 L .20312 .31598 L p .814 .726 .768 r
F P
0 g
s
.15754 .36705 m .18576 .40343 L .13955 .46256 L p .831 .727 .75 r
F P
0 g
s
.01 w
.47695 .26022 Mdot
.83654 .47114 Mdot
.68759 .3384 Mdot
.5 Mabswid
.12118 .56203 m .09172 .53085 L .13955 .46256 L p .851 .74 .74 r
F P
0 g
s
.01 w
.23243 .3285 Mdot
.5 Mabswid
.77477 .38267 m .79509 .40655 L .74516 .37667 L p 0 .331 .803 r
F P
0 g
s
.74516 .37667 m .72448 .35284 L .77477 .38267 L p 0 .331 .803 r
F P
0 g
s
.56273 .25096 m .58636 .27922 L .54141 .27537 L p .405 .639 .951 r
F P
0 g
s
.54141 .27537 m .51743 .24745 L .56273 .25096 L p .405 .639 .951 r
F P
0 g
s
.01 w
.36678 .2523 Mdot
.5 Mabswid
.37888 .18985 m .40468 .22868 L .3614 .24844 L p .683 .691 .851 r
F P
0 g
s
.3614 .24844 m .33526 .21012 L .37888 .18985 L p .683 .691 .851 r
F P
0 g
s
.01 w
.91744 .56244 Mdot
.44508 .2521 Mdot
.2467 .30028 Mdot
.87483 .51445 Mdot
.22604 .31978 Mdot
.75173 .38113 Mdot
.36075 .24343 Mdot
.52918 .26971 Mdot
.47117 .25524 Mdot
.41316 .24094 Mdot
.5 Mabswid
.49277 .21158 m .51743 .24745 L .47329 .25174 L p .546 .653 .905 r
F P
0 g
s
.47329 .25174 m .44835 .21635 L .49277 .21158 L p .546 .653 .905 r
F P
0 g
s
.01 w
.61905 .30212 Mdot
.9128 .55319 Mdot
.5 Mabswid
.13955 .46256 m .11061 .42669 L .15754 .36705 L p .831 .727 .75 r
F P
0 g
s
.11061 .42669 m .13955 .46256 L .09172 .53085 L p .844 .727 .735 r
F P
0 g
s
.01 w
.43924 .24411 Mdot
.24038 .291 Mdot
.87024 .50658 Mdot
.28146 .25606 Mdot
.46542 .24625 Mdot
.32833 .23715 Mdot
.5 Mabswid
.26418 .20208 m .29164 .2378 L .24771 .27301 L p .772 .734 .818 r
F P
0 g
s
.24771 .27301 m .21971 .23783 L .26418 .20208 L p .772 .734 .818 r
F P
0 g
s
.21971 .23783 m .24771 .27301 L .20312 .31598 L p .8 .739 .795 r
F P
0 g
s
.01 w
.40716 .23404 Mdot
.14753 .42691 Mdot
.747 .37598 Mdot
.3019 .24051 Mdot
.52359 .26424 Mdot
.5 Mabswid
.20312 .31598 m .17452 .28134 L .21971 .23783 L p .8 .739 .795 r
F P
0 g
s
.17452 .28134 m .20312 .31598 L .15754 .36705 L p .822 .741 .775 r
F P
0 g
s
.42284 .177 m .44835 .21635 L .40468 .22868 L p .624 .668 .872 r
F P
0 g
s
.40468 .22868 m .37888 .18985 L .42284 .177 L p .624 .668 .872 r
F P
0 g
s
.01 w
.17747 .35629 Mdot
.43337 .23591 Mdot
.90869 .54875 Mdot
.5 Mabswid
.84814 .44632 m .86825 .47738 L .81544 .43739 L p 0 .275 .779 r
F P
0 g
s
.81544 .43739 m .79509 .40655 L .84814 .44632 L p 0 .275 .779 r
F P
0 g
s
.30825 .17388 m .33526 .21012 L .29164 .2378 L p .735 .726 .842 r
F P
0 g
s
.29164 .2378 m .26418 .20208 L .30825 .17388 L p .735 .726 .842 r
F P
0 g
s
.01 w
.34864 .22472 Mdot
.37495 .22407 Mdot
.45964 .23753 Mdot
.19201 .32514 Mdot
.12579 .45448 Mdot
.54997 .27026 Mdot
.5 Mabswid
.15754 .36705 m .12824 .33297 L .17452 .28134 L p .822 .741 .775 r
F P
0 g
s
.12824 .33297 m .15754 .36705 L .11061 .42669 L p .838 .741 .756 r
F P
0 g
s
.01 w
.17073 .34886 Mdot
.90421 .54122 Mdot
.22738 .27481 Mdot
.31597 .21888 Mdot
.18547 .31601 Mdot
.39522 .21619 Mdot
.1493 .37337 Mdot
.5 Mabswid
.09172 .53085 m .06195 .49551 L .11061 .42669 L p .844 .727 .735 r
F P
0 g
s
.35226 .15309 m .37888 .18985 L .33526 .21012 L p .688 .711 .866 r
F P
0 g
s
.33526 .21012 m .30825 .17388 L .35226 .15309 L p .688 .711 .866 r
F P
0 g
s
.01 w
.1034 .48628 Mdot
.54442 .26467 Mdot
.77493 .39545 Mdot
.51229 .24962 Mdot
.81287 .43118 Mdot
.24167 .24755 Mdot
.89982 .5348 Mdot
.1999 .2865 Mdot
.5 Mabswid
.6815 .31183 m .70341 .33326 L .65523 .31257 L p 0 .43 .856 r
F P
0 g
s
.65523 .31257 m .63291 .2912 L .6815 .31183 L p 0 .43 .856 r
F P
0 g
s
.6096 .26263 m .63291 .2912 L .58636 .27922 L p .261 .556 .931 r
F P
0 g
s
.58636 .27922 m .56273 .25096 L .6096 .26263 L p .261 .556 .931 r
F P
0 g
s
.01 w
.44792 .22146 Mdot
.11222 .43776 Mdot
.63539 .30251 Mdot
.5 Mabswid
.53831 .2146 m .56273 .25096 L .51743 .24745 L p .447 .603 .912 r
F P
0 g
s
.51743 .24745 m .49277 .21158 L .53831 .2146 L p .447 .603 .912 r
F P
0 g
s
.75415 .36319 m .77477 .38267 L .72448 .35284 L p 0 .288 .746 r
F P
0 g
s
.72448 .35284 m .70341 .33326 L .75415 .36319 L p 0 .288 .746 r
F P
0 g
s
.01 w
.60324 .28774 Mdot
.57103 .27188 Mdot
.5 Mabswid
.11061 .42669 m .08051 .3932 L .12824 .33297 L p .838 .741 .756 r
F P
0 g
s
.08051 .3932 m .11061 .42669 L .06195 .49551 L p .851 .74 .74 r
F P
0 g
s
.01 w
.53882 .25676 Mdot
.89506 .52512 Mdot
.69998 .33837 Mdot
.5 Mabswid
.4675 .17169 m .49277 .21158 L .44835 .21635 L p .55 .634 .887 r
F P
0 g
s
.44835 .21635 m .42284 .177 L .4675 .17169 L p .55 .634 .887 r
F P
0 g
s
.01 w
.10539 .42917 Mdot
.73252 .35937 Mdot
.27648 .20696 Mdot
.89036 .51625 Mdot
.22881 .22845 Mdot
.5 Mabswid
.39656 .13971 m .42284 .177 L .37888 .18985 L p .625 .688 .888 r
F P
0 g
s
.37888 .18985 m .35226 .15309 L .39656 .13971 L p .625 .688 .888 r
F P
0 g
s
.01 w
.18675 .26815 Mdot
.56552 .26528 Mdot
.59785 .28166 Mdot
.2077 .24914 Mdot
.6302 .29853 Mdot
.80335 .4165 Mdot
.07375 .51119 Mdot
.43612 .20306 Mdot
.16534 .29118 Mdot
.24925 .21494 Mdot
.5 Mabswid
.8282 .42251 m .84814 .44632 L .79509 .40655 L p 0 .215 .716 r
F P
0 g
s
.79509 .40655 m .77477 .38267 L .8282 .42251 L p 0 .215 .716 r
F P
0 g
s
.01 w
.84196 .45657 Mdot
.72767 .35453 Mdot
.88585 .50933 Mdot
.26991 .19982 Mdot
.14364 .31617 Mdot
.49508 .22464 Mdot
.55996 .25787 Mdot
.31747 .18185 Mdot
.29066 .18412 Mdot
.62491 .29293 Mdot
.12206 .33974 Mdot
.09128 .4145 Mdot
.10663 .37741 Mdot
.88098 .49923 Mdot
.5 Mabswid
.06195 .49551 m .03094 .46266 L .08051 .3932 L p .851 .74 .74 r
F P
0 g
s
.01 w
.39753 .18186 Mdot
.83729 .44951 Mdot
.31132 .17027 Mdot
.48926 .21733 Mdot
.72279 .34978 Mdot
.36474 .17086 Mdot
.09987 .36752 Mdot
.42412 .18627 Mdot
.08424 .40645 Mdot
.87619 .49006 Mdot
.79387 .40371 Mdot
.61957 .28712 Mdot
.65228 .30641 Mdot
.3318 .16046 Mdot
.5 Mabswid
.51324 .17414 m .53831 .2146 L .49277 .21158 L p .459 .588 .894 r
F P
0 g
s
.49277 .21158 m .4675 .17169 L .51324 .17414 L p .459 .588 .894 r
F P
0 g
s
.44151 .13386 m .4675 .17169 L .42284 .177 L p .546 .653 .905 r
F P
0 g
s
.42284 .177 m .39656 .13971 L .44151 .13386 L p .546 .653 .905 r
F P
0 g
s
.01 w
.68498 .32445 Mdot
.41814 .17562 Mdot
.51606 .22582 Mdot
.07737 .39685 Mdot
.54873 .2439 Mdot
.5 Mabswid
.58539 .22578 m .6096 .26263 L .56273 .25096 L p .331 .538 .904 r
F P
0 g
s
.56273 .25096 m .53831 .2146 L .58539 .22578 L p .331 .538 .904 r
F P
0 g
s
.01 w
.8716 .48295 Mdot
.71792 .34584 Mdot
.61418 .28093 Mdot
.5 Mabswid
.6585 .28301 m .6815 .31183 L .63291 .2912 L p .103 .454 .885 r
F P
0 g
s
.63291 .2912 m .6096 .26263 L .6585 .28301 L p .103 .454 .885 r
F P
0 g
s
.01 w
.44484 .18208 Mdot
.75099 .36764 Mdot
.51028 .21651 Mdot
.35221 .15392 Mdot
.67992 .32012 Mdot
.5 Mabswid
.73267 .34182 m .75415 .36319 L .70341 .33326 L p 0 .298 .761 r
F P
0 g
s
.70341 .33326 m .6815 .31183 L .73267 .34182 L p 0 .298 .761 r
F P
0 g
s
.01 w
.05411 .43056 Mdot
.86715 .47751 Mdot
.57588 .256 Mdot
.47166 .18954 Mdot
.78447 .39325 Mdot
.82316 .42877 Mdot
.60878 .2758 Mdot
.37287 .14611 Mdot
.8624 .46933 Mdot
.67476 .31459 Mdot
.57027 .24811 Mdot
.03093 .46271 Mdot
.5 Mabswid
.80805 .40327 m .8282 .42251 L .77477 .38267 L p 0 .165 .644 r
F P
0 g
s
.77477 .38267 m .75415 .36319 L .80805 .40327 L p 0 .165 .644 r
F P
0 g
s
.01 w
.39977 .14976 Mdot
.60326 .26754 Mdot
.53157 .218 Mdot
.85727 .45776 Mdot
.5646 .23876 Mdot
.45975 .17092 Mdot
.5 Mabswid
.48748 .13577 m .51324 .17414 L .4675 .17169 L p .448 .603 .912 r
F P
0 g
s
.4675 .17169 m .44151 .13386 L .48748 .13577 L p .448 .603 .912 r
F P
0 g
s
.01 w
.49274 .1899 Mdot
.66962 .31051 Mdot
.39355 .14133 Mdot
.52578 .20987 Mdot
.85263 .45109 Mdot
.5 Mabswid
.56047 .18474 m .58539 .22578 L .53831 .2146 L p .352 .528 .889 r
F P
0 g
s
.53831 .2146 m .51324 .17414 L .56047 .18474 L p .352 .528 .889 r
F P
0 g
s
.01 w
.45372 .16204 Mdot
.48683 .17962 Mdot
.63099 .28268 Mdot
.73646 .35469 Mdot
.66436 .30474 Mdot
.59217 .25344 Mdot
.44768 .15269 Mdot
.84816 .44652 Mdot
.55318 .22191 Mdot
.48088 .17032 Mdot
.41438 .13801 Mdot
.5 Mabswid
.63448 .24567 m .6585 .28301 L .6096 .26263 L p .201 .457 .878 r
F P
0 g
s
.6096 .26263 m .58539 .22578 L .63448 .24567 L p .201 .457 .878 r
F P
0 g
s
.01 w
.77021 .37897 Mdot
.62556 .27648 Mdot
.47488 .16171 Mdot
.8435 .44034 Mdot
.50821 .18051 Mdot
.62004 .26873 Mdot
.5 Mabswid
.70997 .31281 m .73267 .34182 L .6815 .31183 L p 0 .341 .817 r
F P
0 g
s
.6815 .31183 m .6585 .28301 L .70997 .31281 L p 0 .341 .817 r
F P
0 g
s
.01 w
.43542 .13565 Mdot
.65369 .29206 Mdot
.72648 .34466 Mdot
.83886 .43472 Mdot
.57515 .22801 Mdot
.68747 .31553 Mdot
.76047 .36876 Mdot
.53576 .19425 Mdot
.5 Mabswid
.53491 .14582 m .56047 .18474 L .51324 .17414 L p .332 .538 .904 r
F P
0 g
s
.51324 .17414 m .48748 .13577 L .53491 .14582 L p .332 .538 .904 r
F P
0 g
s
.78701 .38209 m .80805 .40327 L .75415 .36319 L p 0 .176 .661 r
F P
0 g
s
.75415 .36319 m .73267 .34182 L .78701 .38209 L p 0 .176 .661 r
F P
0 g
s
.01 w
.64822 .28396 Mdot
.4963 .16295 Mdot
.60884 .25128 Mdot
.72141 .33918 Mdot
.45671 .1329 Mdot
.8344 .43131 Mdot
.68221 .3096 Mdot
.75555 .36372 Mdot
.5 Mabswid
.60967 .20403 m .63448 .24567 L .58539 .22578 L p .232 .454 .869 r
F P
0 g
s
.58539 .22578 m .56047 .18474 L .60967 .20403 L p .232 .454 .869 r
F P
0 g
s
.01 w
.71641 .33555 Mdot
.67682 .30177 Mdot
.82973 .42605 Mdot
.55777 .19848 Mdot
.59753 .23511 Mdot
.71122 .3296 Mdot
.67144 .29498 Mdot
.47817 .13563 Mdot
.59178 .225 Mdot
.82499 .42042 Mdot
.5 Mabswid
.6861 .275 m .70997 .31281 L .6585 .28301 L p .065 .366 .834 r
F P
0 g
s
.6585 .28301 m .63448 .24567 L .6861 .275 L p .065 .366 .834 r
F P
0 g
s
.01 w
.70591 .32218 Mdot
.626 .2518 Mdot
.54603 .18049 Mdot
.82018 .41439 Mdot
.74062 .34972 Mdot
.49998 .1363 Mdot
.5 Mabswid
.58427 .16454 m .60967 .20403 L .56047 .18474 L p .202 .458 .878 r
F P
0 g
s
.56047 .18474 m .53491 .14582 L .58427 .16454 L p .202 .458 .878 r
F P
0 g
s
.76463 .35297 m .78701 .38209 L .73267 .34182 L p 0 .23 .736 r
F P
0 g
s
.73267 .34182 m .70997 .31281 L .76463 .35297 L p 0 .23 .736 r
F P
0 g
s
.01 w
.81543 .40939 Mdot
.65494 .27153 Mdot
.69535 .31029 Mdot
.64934 .26306 Mdot
.81095 .40784 Mdot
.68988 .30192 Mdot
.73034 .33844 Mdot
.5 Mabswid
.66139 .23272 m .6861 .275 L .63448 .24567 L p .105 .37 .833 r
F P
0 g
s
.63448 .24567 m .60967 .20403 L .66139 .23272 L p .105 .37 .833 r
F P
0 g
s
.01 w
.52209 .14294 Mdot
.80581 .39925 Mdot
.72504 .33142 Mdot
.76573 .36903 Mdot
.80109 .3959 Mdot
.7197 .3241 Mdot
.5 Mabswid
.74091 .31471 m .76463 .35297 L .70997 .31281 L p 0 .271 .777 r
F P
0 g
s
.70997 .31281 m .6861 .275 L .74091 .31471 L p 0 .271 .777 r
F P
0 g
s
.01 w
.54462 .15049 Mdot
.71433 .31703 Mdot
.79634 .3927 Mdot
.5 Mabswid
.63612 .19268 m .66139 .23272 L .60967 .20403 L p .067 .367 .835 r
F P
0 g
s
.60967 .20403 m .58427 .16454 L .63612 .19268 L p .067 .367 .835 r
F P
0 g
s
.01 w
.62065 .21624 Mdot
.70894 .31021 Mdot
.79113 .38451 Mdot
.61476 .2052 Mdot
.7033 .29969 Mdot
.65621 .24902 Mdot
.7449 .3427 Mdot
.78625 .38075 Mdot
.5676 .15954 Mdot
.69779 .29201 Mdot
.5 Mabswid
.71625 .2718 m .74091 .31471 L .6861 .275 L p 0 .282 .783 r
F P
0 g
s
.6861 .275 m .66139 .23272 L .71625 .2718 L p 0 .282 .783 r
F P
0 g
s
.01 w
.78122 .37571 Mdot
.69219 .2834 Mdot
.64458 .22825 Mdot
.77619 .3711 Mdot
.59104 .16811 Mdot
.72865 .31947 Mdot
.77064 .36043 Mdot
.76541 .35419 Mdot
.66913 .24257 Mdot
.5 Mabswid
.6911 .23121 m .71625 .2718 L .66139 .23272 L p 0 .272 .778 r
F P
0 g
s
.66139 .23272 m .63612 .19268 L .6911 .23121 L p 0 .272 .778 r
F P
0 g
s
.01 w
.76009 .34746 Mdot
.61503 .17964 Mdot
.75455 .33806 Mdot
.74895 .32845 Mdot
.74337 .31949 Mdot
.73768 .30943 Mdot
.63967 .19452 Mdot
.73208 .30117 Mdot
.72617 .28874 Mdot
.67693 .23226 Mdot
.72033 .27774 Mdot
.66498 .21132 Mdot
.71471 .27091 Mdot
.70871 .2584 Mdot
.70303 .25191 Mdot
.69695 .23924 Mdot
.6912 .23309 Mdot
.25 Mabswid
.68874 0 m
.96935 .42924 L
s
.96935 .42924 m
1 .6535 L
s
1 .6535 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.03716 .25514 m
0 .48963 L
s
0 .48963 m
.70298 .24544 L
s
.70298 .24544 m
.68874 0 L
s
.68874 0 m
.03716 .25514 L
s
.03716 .25514 m
.68874 0 L
s
.14467 .21304 m
.1493 .21769 L
s
[(-2)] .13542 .20373 .99461 1 Mshowa
.34306 .13535 m
.34735 .14032 L
s
[(0)] .3345 .12542 .86223 1 Mshowa
.55745 .05141 m
.56132 .05671 L
s
[(2)] .54972 .04081 .72986 1 Mshowa
.125 Mabswid
.19287 .19417 m
.1956 .197 L
s
.24198 .17493 m
.24466 .17782 L
s
.29204 .15533 m
.29467 .15827 L
s
.39509 .11498 m
.3976 .11801 L
s
.44814 .09421 m
.45059 .09729 L
s
.50225 .07302 m
.50464 .07615 L
s
.09737 .23156 m
.10019 .23431 L
s
.05093 .24975 m
.05379 .25245 L
s
.61378 .02935 m
.61603 .03258 L
s
.67126 .00684 m
.67344 .01012 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{299.062, 242.375},
  ImageMargins->{{48, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004[0000lPP10`4000010?ooooooc?ooZ_ooI_oo
<ooo0?o<ooo<c?o<VC/k>gYjN[Vi^OShn03ooeGooj[ooonI<onI0?mVoomVc?mVVOmVI_mV<omV0?lc
oclo?ginO[fm_Oclo5D00:X00?l00?l0VOl0I_l0<ol00<coolcoc<coVLcoIP<30d92@X61PL30`000
EED0EJX0EOl0ELbIolbIc<bIVLbII/bI<lbI0<aVolaVc0L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0Z/`c
<l`c0<`0ol`0c<`0VL`0I/`0<l`000/;2dY:BXV9RLS8b000oeD0ojX0ool0oiW<VIW<IYW<<iW<09VI
oiVIc9VIVIVIIPl?3di>CXf=SLc<c01E05EE0:YE0?mE09TcoiTcc9TcVITcIYTc<iTc09T0oiT0c1<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEEFKo<fKo06K<ofK<c6K<VFK<IVK<<fK<01LG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZVIVVFIVIVIV<fIV06HcofHcc6HcVFHcIQ/K6eYJFYVIVMSHf01EoeEEojYEoomEoc?o
oc?oc3?oVC?oIS?o<c?o03?<oc?<c1lO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ03>I<c>I03=Voc=Vc3=V
VC=VIS=V<c=V02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZEC<0VC<0IS<0<c<0003oo`3oc03oV@3oIRLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2Io`2Ic02IV@2IIP2I<`2I001Vo`1Vc2/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`0c<`0c0000o`00c000V@00IP00<nh002l_;fi^KZf][Nc/k03o05Go0:[o0?oo0140
003^003M002k002Z0028001g001E03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@00M`00E@00A0008P00
4Nk^k]gMgK^k^cLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l0;0000?l0;0000?l0;0000?l0;0000?l0
;0000=000_mI0000c@03o`030?l005P0003;00;o1002oeP0003800?o00<0o`000`000ol0o`1G0000
aP02o`T00omG0000Y@04oaX00ol;0004o`00oeH0002V0003o`0001L00ol>0005o`000?l0E@000:L0
00?o00005002oa4000Go0000o`1E0000Z0000ol0000@00?o4`000ol000020003o`000580002U0004
o`00oa000olE0003o`0000<000?o0000D@000:H00_l>00?o0`000ol0000C0003o`00008000?o0000
2`03od<0002d00;o70000ol000030003o`0000d000?o0000@0000;400olN0003o`0000<000?o0000
1005o`@000?o0000@0000:l00_lQ0003o`0000@000?o00002@03od<0002/00?o8`000ol000050003
o`0000P000?o0000@`000:X00olU0003o`0000D00_l900Co@P000:L00ol30003o`00028000?o0000
10000ol0o`1?0000Y003ob/000?o00001`000ol0001<0000XP02obh000?o00001`000ol0001<0000
W`03oc0000?o000020000ol0001;0000W@02oc<000?o00002@000ol0001:0000VP03ocD000?o0000
2@000ol0001:0000V002o`8000?o0000<`000ol0000:0003o`0004T0002E00?o>P000ol0000;0003
o`0004P0002C00;o?@000ol0000;0003o`0004P0002@00?o?`000ol0000<0003o`0004L0002=00?o
@P000ol0000=0003o`0004H0002;00;oAP000ol0000;00;oB00008P00ol20003o`0004<000?o0000
3@000ol000150000J002oa`00_m;0003o`0000h000?o0000A00006L000Co003o6003odd000?o0000
3P000ol000140000I`001?l00?lF00;oD0000ol0000?0003o`0004<0001W0004o`00oa<00omB0003
o`0000l000?o0000@`0006L000Co003o4@02oeD000?o000040000ol000120000J002o`l00ol20003
o`00058000?o00004@000ol000110000M`02oeX000?o00004@000ol000110000M003oe`000?o0000
4P000ol000100000L@03oel000?o00004`000ol0000o0000K`02oaH02om10003o`0001800_m10000
K004oa401_l01eCooon0LX000_l00g:0o`09ocL000?o000050000ol0000n0000JP02o`@000?o0000
2@05o`07LoooE7=DL`02o`0:E?mDcEC=E<eDc@;o00ADolfS1Old0003o`0001D000?o0000?@0006L0
0ol?00Ko021DEEAEE5EDEEAEE5EDoh1bP7:0LX1bP7:0oeBSE:=DX`Go;`000ol0000E0003o`0003d0
001U00;o3`03o`0W>e@kE3]DoeAcE7=DLeAcE7=DLeCoE<eDcEC=E<eDcECocJ?=XlfS00;o00?=Xol0
0_l/0003o`0001H000?o0000?00006800ol>00Go00IcE7=DLe@3o`0VE5EDEEAEE5EDEEAEog:0LX1b
P7:0LX1bP?mDXeBSE:=DXeBSoh@3obT000?o00005`000ol0000k0000H002o`h00ol02c]D>e@kE3]D
>e@k00?o00YcE7=DLeAcE7=D0_l06G?ocEC=E<eDcEC=E<goXlfScJ?=XlfScJ<00ol01:?ooolV0003
o`0001L000?o0000>`0005d00ol00`3o000;00Co01UcE7=DLeAcE7=DLeAcE7?oEEAEE5EDEEAE00;o
021DEOmbP7:0LX1bP7:0L_nSE:=DXeBSE:=DXon4UhBGQ0?o90000ol0000G0003o`0003X0001K00;o
3@04o`0On/kjc_lkE3]D>e@kE3]D>e@kE3_oLeAcE7=DLeAcE003o`03E<eD00;o01S=E<eDcEC=oj?=
XlfScJ?=XlgoXZ>RXj82o`04Xoooob4000?o000060000ol0000i0000F003o`h00ol08E@[E2]D:eCo
LeAcE7=DLeAcE7=DLeCoE5EDEEAEE5EDE@02o`04E?n0LP;o00B0LX1b0_l04X3oE:=DXeBSE:=DXeCo
UhBGQ0;o00BGQ9N40_lO0003o`0001P000?o0000>@0005D00ol?00;o033>n/kjc_[>n/kjc_lkE3]D
>e@kE3]D>e@kE?mDLeAcE7=DLeAcE7=DoeC=E<eDcE@2o`0HcECocJ?=XlfScJ?=XlgoXZ>RXj:SXZ>R
1?lM0003o`0001P00_lj0000D`02o`l00ol03B]D:e@[E2]D:e@[E2/00_l06G=DLeAcE7=DLeAcE7?o
EEAEE5EDEEAEE5D02ol06W:0LX3oE:=DXeBSE:=DXon4UhBGQ9N4UhBG0_l00lOoo`0K0003o`0001X0
00?o0000=`0005000ol@00?o00kjc_[>n/kjc_[>n/kjcP;o00eD>e@kE3]D>e@kE3]D00;o00=cE7<0
2Ol015Go_E@2o`03_EBm00So01O=XlfScJ?=XonSXZ>RXj:SXZ>RohbTS002oaT000?o00006P000ol0
000g0000;P04oa`00_l20003o`0000d0027oFol[E2]D:e@[E2]D:e@[E2]D:omDLeAcE7=DLeAcE7<0
1Ol03UAcE7=DLeAcE7=Doj9D0_l02Z9DXUBRE:;oXUD5o`0DE:=DoiN4UhBGQ9N4UhCoahc7S<L2oaL0
00?o00006`000ol0000f0000;`000ol0000I00?o4P02o`03mlkg00?o01Gjc_[>n/kjc_[>n/kjc_[o
E3]D>e@01_l01liEoeAEE5D00_l02UAEE5EDEECoE;d2o`05E;eD_E@00_l02;goXlfScJ?=1Ol03j:S
XZ>RXj:SXZ?oY8bTS003oaH000?o00006`000ol0000f0000:005o`<000?o00005P02oa@00_l01E/K
Fa]K00;o01=D:e@[E2]D:e@[E2]D:e@[oeAc00Co00IEcUG>ELh2o`03LeAc00;o015DLeAcE7=DLomD
XUBRE:9DXP02o`08E:;oXUFREJ82o`03EJ;o00;o0124UhBGQ9N4UhCoahc7S<N<0_lD0003o`0001`0
00?o0000=@00034000?o00004P03oa@01?l05lkgc_O>moojc_[>n/kjc_[>n/kjc_[>00?o00[>ELiE
cUG>ELiE0ol02UAEE5EDEEAEE5D2o`04E?mD_@;o01AD_EBmE;eDolfScJ?=XlfScJ?oXP?o00nSXZ>R
Xj;oS:B<Y8bTS:@00_lB0003o`0001d000?o0000=00002h000Co003o4P02oaH001[oFa]K6e/KFa]K
6e_o:e@[E2]D:e@[E2]D:`;o01[>oliEcUG>ELiEcUG>ELkoE7=DLeAcE7=DL`;o00ADoj9D0_l02Z9D
XUBRE:9DoeD2o`0;XUFREJ9EX_o=Xld00ol03XBGQ9OoS<N<ahc7S<N<0_l@0003o`0001d000?o0000
=00002l00_l@00Co5@02o`0Hmlkgc_O>mlkgc_O>olkjc_[>n/kjc_[>0_l0;N[>j/kocUG>ELiEcUG>
ELiEc_mEE5EDEEAEE5EDEEAEokeD_EBmE;eD_EBmE003o`0>cJ?=XlfScOnSXZ>RXj83o`0;XonTS:B<
Y8bTS:@00ol?0003o`0001h000?o0000<`0003h00olH00;o01IK6e/KFa]K6e/KFa]K6omD:e@[E2]D
0ol0=lkjc_[>n/kocUG>ELiEcUG>ELiEc_mDLeAcE7=DLeAcE7?oE:9DXUBRE:9DXUBRoj9EXUFREJ80
0_l02UGoXlfScJ?=Xld3o`08ahc7S<N<ah`2o`03O?oo00d000?o00007`000ol0000b0000?002oaT0
1?l05<kgc_O>mlkgc_O>mlkgc_o>n/kj0_l05lkZc^[>j/kZc^[oELiEcUG>ELiEcUG>00;o025DEEAE
E5EDEEAEE5EDoeBmE;eD_EBmE;eD_OnScJ?=Xld00_l03J?=oj>RXj:SXZ>RXj800_l038bTS:B<Y8co
am?7o``000?o00007`02oc<0000i00?o6P001?l`oe/2o`0A6e/KFa]K6e/KFa]K6e/Koe@00_l06O[>
n/kjc_[>n/kjc_[oELiEcUG>ELiEcUD00ol0;g=DLeAcE7=DLeAcE7?oE:9DXUBRE:9DXUCoEJ9EXUFR
EJ9EX_o=XlfScJ?=XlfS00Co00[7S<N<ahcoagc70_l:0003o`0001l00_lc0000=`02oa`000Co>c/k
0ol03oO>mlkgc_O>mlkgc_O>m`02o`0ec^[>j/kZc^[>j/kZc^[>j_mEcUG>ELiEcUG>ELkoEEAEE5ED
EEAEE5EDEOnmE;eD_EBmE;d00_l05eCocJ?=XlfScJ?=XonRXj:SXZ>RXj:S00;o00bTojB<Y8bTS?o7
dlL2o`T000?o00008@000ol0000`0000=003oa`00_l0?S0K<1/`oe/KFa]K6e/KFa]K6e/KFol[oo[>
n/kjc_[>n/kjc_[>n/kocUG>ELiEcUG>ELiEc_mDLeAcE7=D5_l05UFREJ9EXUGoXlfScJ?=XlfScOnS
aZ<2o`08S<N<aomlag`3o`P000?o00008@000ol0000`0000<P02o`<000?o00006003o`Hk00_omlkg
c_O>mlkgcP04o`0Bmlkgon[>j/kZc^[>j/kZc^[>0ol02liEcUG>ELiEcUG>00Wo00AcE7=D0ol00eC=
E002o`04cEC=E0;o00C=oj?=0ol04<fScJ?=oj>RXj:SXZ>RXj83o`0=Y8coojB<Y?oCam?7d`02o`L0
00?o00008@000ol0000_0000;`03oal001Go6c0K<1/`6c0K<?mK6e/KFa]K6e/00_l0534[<B/a:ooj
c_[>n/kjc_[>n/kj0ol01eG>ELiEcUD01?l03G?ooeAEE5EDEEAEE5D00_l015CoP782o`04P7:0LP;o
00B0L_nS0_l04UCooomEXUGoXlfScJ?=XlfSc@;o0136XlJSolN<olMlagc7O<Oo1P000ol0000R0003
o`0000H00_lV0000;@02ob4000?o>c/02C/02Oo>mlkgc_O>m`02o`08c_O>mlkgc_L2o`06c^[>j/kZ
0_l02LkZc^[>j_mEcP04o`05E3]D>e@00ol02eAcE7=DLeAcE7=D00?o00=DcE@00_l01leDcEC=E<d0
0ol01:?=Xld4o`0AX_ooXj:SXZ>RXon<Y8bTS:@00_l02Hcoam?7dlOCa`02o`@000?o00008P000ol0
00050004o`00obD0000Z00?o8003o`0O6c0K<1/`6c0K<1/`6olKFa]K6e_o:c4[<B/a:c4[<@02o`06
n/kjc_[>0_l01_[>n/kjcP?o01McE7=DLeAcE7=DLeCoE5EDEEAEE5EDE@03o`03LX1b00;o00n0LX1b
P7:0oeBSE:=DXe@01_l03LfScJ?=XlfSolJSaZ<00_l03LKoooo7O<Mlagc7O?l00`000ol0000S0003
o`0000@000Co003o9@0002P00_lS00;o3c/01?o>mlh2o`0Imlkgc_O>mlkgc_O>olkZc^[>j/kZc^[>
jP02o`0ac_lkE3]D>e@kE3]D>e@kog=DLeAcE7=DLeAcE7?ocEC=E<eDcEC=E<eDolfScJ?=X`02o`03
cOnR00?o00^SXZ>RXj;oY8bTS002o`08Y8bTom?7dlL2o`04dlOCo`8000?o000090000ol000030004
o`00obD0000U00?o00<0o`008@00;ol`6c0K<1/`6c0K<1/`6c0K<1_o6ola:c4[<B/a:c4[<B/a:c7o
c_[>n/kjc_[>00;o00?>:lh00_l01G=DLeAc00;o02eDLeAcE7?oEEAEE5EDEEAEE5EDEOmbP7:0LX1b
P7:0LX3oE:=DXeBSE:=DoiL01Ol04Z?=XlgoXlJSaZ?6XlJSogc7O0;o00C7O?oo0P000ol0000T0003
o`0000<000Co003o9@0002800olU00;o4c/2o`08c_O>mlkgc_L2o`0>c_O>mlkgon[>j/kZc^X2o`05
c_[>n/h00ol013]D>e@2o`06>e@kE3]D0_l077=DLeAcE7=DLeAcE7?ocEC=E<eDcEC=E<goXld2o`06
XlfScJ?=0ol00j:SXP03o`0CXj;oY8bTS:B<Y8coaoo7dlOCa`03o`030?l002D00_l500;o9P000200
0_lW000Iod_o6c0K<1/`6c0K<1/`6c0K<1/`od_o:`02o`05<B/a:c400_l01b/a:c4[<B/00_l00lkj
cP02o`08cR_>:lh[cR/2o`0<E7=DLeAcE7=DLeAc0ol06eEDEEAEE5EDEEAEE?n0LX1bP7:0LX1bP7;o
X`02o`0?E:=DXeBSohBGQ9N4UhBG00?o00W6XlJSaZ?6XlH01?l017c7O<L2o`030?l002@000Co003o
;00001d00olX0005oc5K<Ol043/01?lk<C/3o`0>mlkgc_O>mlkgc_O>mlh2o`0=j_ooc_[>n/kjc_[>
nP03o`05E3]D>e@00_l01C]D>e@k00;o01IDLeAcE7=DLeAcE7=DoeC=E<eDcEC=0_l05eCocJ?=XlfS
cJ?=XonSXZ>RXj:SXZ>R00;o00NTS:B<Y8bT00;o00S7dooCam?7d`;o:0000ol0000Z00006`02obX0
0_l025];Fd_o6c0K0_l0230K<1/`6c0K0_l05T_jBoY;ob/a:c4[<B/a:c4[<B/a:c42o`0DcR_>:lh[
cR_>:lh[cR_>oeAcE7<2o`05E7=DLe@00ol01eAEE5EDEE@04?l017:0oe@2o`0CXeBSE:=DXon4UhBG
Q9N4UhCoa`02o`0:aZ?oolJSogc7O0Go00=lo`00:0000ol0000Y00006003o`030?l002P00ol01S5K
<E/ao`8k0_l7>`0Joc4k<C/a>c7oc_O>mlkgc_O>mlkgc_O>olh2o`0En/kjc_[>n/kjc_[>n/kjoe@k
E3]D00;o00@kE3]D2Ol015AbE783o`07E<eDcEC=E008o`04cJ?=X`;o00?=Xol00_l00j>RX`02o`07
XZ?oY8coS002o`05Y8bTom<01?l00lOCo`02obT000?o0000:00001L00_l/000God]KBe];Fd]KBolK
<1/`6c0K<1_onT/00_l04_Y;nT_joc4[<B/a:c4[<B/a:`;o01<KFooo:lh[cR_>:lh[cR_>:lh[00;o
00ADLeAc1_l055Goog9ELUEbEG9ELUEbEG;o_Lfm0_l02LfmcKg=_OnFXP06o`03XeCo00;o00>GQ9L0
0_l01XBGQ?o7S0;o00>SaZ<00ol01Wc7O<Ooa`Co:0000ol0000X00005`03obX000co<E/aFc5K<E/a
Fol8>`04oc4k<@;o010k<C/a>c7oc_O>mlkgc_O>0_l01_O>mlkgcP;o00Gjc_[>nP02o`06c_[>n/kj
0_l00c]Do`04o`04E0mD3`Co00mDLUAbE79DLUAbE7;oE<d00_l015C=E<d2o`03E?mc00;o00>RLj80
1Ol03Z:SXZ>RXj:SX_n<Y8bT0ol02:B<olOCam?70_l01=?ooolX0003o`0002L0000G0004o`00obP0
01?oBe];Fd]KBe];Fd]Koc0K<1/`00;o01GjBoY;nT_jBoY;nT_o:c4[<B/a:c400ol01Q]K6e/KF`;o
00D[cR_>:`02o`07cR_>:lh[cP03o`03ELiE00;o00K>ELiEcUD2o`0;LUEbEG9ELUEbEG800ol01kg=
_LfmcKd00_l03<fmoiJRUZ:FXYJRUP?o00R4UhBGQ9N4U`Co00g7S?o6Xomlagc7O<Ml00Co:0000ol0
000W00005`001Ol0003o02H0013o<E/aFc5K<E/aFc5K<E_o0c/05_lk<C/a>c4k<C/a>c4k<C_omlkg
c_L2o`0Bc_oomlkgc_O>moojc_[>n/kj0_l00lkjcP02o`08>omD3e@?E0l2o`05E0mD3e@00_l02W9D
LUAbE79DLU@2o`04L_mDc@;o00ADcEC=0_l02ECoLj9cXW>RL`03o`07Xooooj>RX`05o`04Y8bTS0;o
00VTom?7dlOCam<01?lX0003o`0002H0000F00?o0`000ol0000R00;o02IKBe];Fd]KBe];Fd]KBe_o
<?m;nT_jBoY;nT_jBoY;nT_joc4[<@;o00EK6e/KF`02o`0=6e/KFa]Kolh[cR_>:`02o`0=c_oo6`lK
3omEcUG>E@02o`05cUG>ELh00ol02W9ELUEbEG9ELUD2o`03L_nm00?o00>mcKd00_l02LfmoiJRUZ:F
XP02o`05U_oooj800ol00hBGQ003o`05ahc7S<L00ol01gc7O<Mlag`00_l00`3o000W0003o`0002D0
000F0003o`0000@000?o00008003o`09<E/aFc5K<E/a00;o00AK<E/a0_l073/a>c4k<C/a>c4k<C/a
>c4k<Oo>olkgc_O>mlh2o`0>mlkgc_O>moojc_[>n/h2o`06>e@kE3]D0_l03E@?E0mD3e@?E0mD3e@0
0_l02G9DLUAbE79DLP02o`04E7;oE0;o00C=E<eD0_l03<eDog>RLj9cXW>RL`Co00K6oonSXZ<2o`0?
S:B<Y8bTS?o7dlOCam?700Co9`02obL0000?00;o1@000ol000050003o`0001h000goBe];Fd]KBe];
Fd]K00;o01Q;Fd_oBoojBoY;nT_jBoY;nT_jBoY;nT/2o`0F6e/KFa]K6e/KFa]K6e/KFa_o:lh[cP;o
00PK3a/?6`lK3`?o00aEcUG>ELiEcUG>ELh3o`07LUEbEG9ELP0?o`09_LfmoiJRUZ:F00Oo00>R`J80
1?l04Xc7S<N<ahc7S?o7O<Mlagc7O0?o:0000ol0000T00003P001?l00?l400;o1`000ol0000L000d
oc5K<E/aFc5K<E/aFc5K<E/aoc5;<Ola>c4k<C/a>c4k<C/a>c4koc_omlkgc_O>mlkgcP;o00Sgc_O>
mlkocP;o00@kE3]D0_l01S]D>e@kE0;o00ED3e@?E002o`053e@?E0l02Ol025AbE79DLUCo1/d>o`09
LoooaZ?6XlJS00;o016<Y8bTS:B<Y?oCom?7dlOCa`02o`030?l002L000?o00008`0000h000Co003o
10000ol000070003o`0001/001;oFd]KBe];Fd]KBe];Fd]KBol5B`0EooY;nT_jBoY;nT_jBoY;oc0K
<?mK00;o00HKFa]K6e/2o`066e/KFa]K0_l01Q/?6`lK3`;o00HK3a/?6`l3o`04ELiEcP;o00=Eool0
0_l03`mD3eCoLUAbE79DLUAbE003o`[=2Ol00j:Fo`02o`0?X/7ooj;1ohc7S<N<ahc700Co00K7O<Ml
aol20003o`0002D000?o00008`0000h000Co003o10000ol000080003o`0001T000So>omK<E/aF`;o
01daFc5K<E/aoc5;<D/aBc7o<C/a>c4k<C/a>c4ko`05>`?o00Sgc_O>mlkgcP;o00kgc_oo>lkoE3]D
>e@kE0;o00XkE3]D>e@koe@?1?l01U@?E0mD3`;o00EDog9DLP02o`04E79DLP;o00=Dold01Ld3o`;=
00KoUoooXYL6o`08aZ?oolJSog`2o`05S:B<Y8`00_l02=?7olOCam?70olX0003o`000280000>0004
o`00o`@00_l:0003o`0001H00_l020Og1omKBe];0_l01e];Fd]KBol00T/2o`A;01koBoY;nT_jBoY;
nT_o<1/`6c0K<?mK6e/KFa]K6e/2o`0>6om[Rf^;JolK3a/?6`l2o`076`lK3a/?6`03o`043e@?E0;o
00@?E0mD0_l01@mDog9D00Co00AbE79D0ol2c@?o1/d3o`06cLKoolg60_l01:;1X/42o`04X_o7a`;o
00C7S<N<0ol01/Ooogc7O0;o00<0o`009`000ol0000Q00003`02o`@000?o00002`000ol0000E00;o
01=;>d/koe/aFc5K<E/aFc7o<D/a00;o00i;<D/aBolk<C/a>c4k<@;o2C/3o`07mlkgc_O>m`02o`0?
cS_>>lhkc_mD>e@kE3]D00;o00<kE?l01_l00`mD3`02o`07E0mD3e@?E003o`03LUAb00;o00ADLUAb
0_l015Coold2o`O=00KoUj:GXYL2o`03XYOo00Go00?6Xol00_l01WcoohbTS0;o00SCam?odlOCo`80
00?o00009@000ol0000Q00005@000ol0000<0003o`0001<001;o1oL7m`Og1omKBe];Fd]KBol<B`03
od_j00;o00m;n_lK<1/`6c0K<1/`6c000_l01A]K6e/K00;o016;Jh][Rf^;Jh][oa/?6`lK3`04o`05
3d/?B`l00ol02`mD3e@?E0mD3e@?00;o00QDog9DLUAbE0ko00W=ooo=olg6cLH00ol01LK=ol7700;o
00>R`J800_l3a`0>ohc7S?o7O<Mlogc7O?l20003o`0002D000?o0000800001D00_l>0003o`000140
01Wo>d/kBc];>d_o<E/aFc5K<OlaBc5;<D/a00;o00M;<D/aoc4k00;o00<aoc/03C/02_ogc_O>olhk
cS/2o`07cS_>>lhkcP02o`04>e@kE0?o00o>3lh?cPo>3lko3e@?E0l00_l01E@?E0mD00[o00=Dool0
0_l00g;oc@04c@Wo00>Rool00_l01IOoa/O600;o00?6Xol00_l01GcooonT00;o00C7dlOC1?l20003
o`0002H000?o00007`0001D000?o00003P02oa0001;o1oL7m`Og1oL7mom;Fd]KBol8B`;o1D/05ooj
Bo[o6c0K<1/`6c0K<1/`6c0K<?mK00;o00E[Rf^;J`02o`07Rf^;Jh][R`02o`076oooo`m;3`02o`0=
B`m;3d/?B`oo3e@?E00:o`04Foooo`Ib0ol017;oold2o`?=0_l2c@Oo00?6cOl00_l00l7oo`04o`04
aoooa`?o00Ilagc7O<L3o`8000?o00009002ob40000E0003o`00010000?o000030009OlkBc];>d/k
Bc];>d_o<E/aoc5;<D/aBc5;<D/aBc5;<D/aoc400ol7>`;o1S/4o`0?>lhkcS_>>lhkcS_>>lhk00?o
00D?cPo>3`02o`0<cPo>3lh?cPo>o`mD1?l01@mD3e@?00Ko00MbE79DLUAb00Co00ADoooo2<d01OnR
Uj:G00Ko00G7ooo6a`03o`05S7b<O8`00_l01]?7dlOCa`?o0P000ol0000U0003o`0001h0000E00;o
4P000ol0000;000AooL7m`Og1oL7m`Og1oOoBol04T/2o`0:6ooo<1/`6c0K<0;o00LK<1/`6omE00?o
015[Rf^;Jh][Rf^;Jh][Rol`9@02o`0?B`m;3d/?B`m;3d/?B`m;00?o00IbFg9KLU/3o`03Fg;o00;o
00Abog9b0_l4LP?o00=bold02Ld02?o6U/JFaYK60_l00l77`@02o`03aooo00;70_l2a`;o00Ilagc7
O<L2o`<000?o00009@000ol0000M00005@000ol0000B0003o`0000P00_l02T/kBc];>d/kBc/2o`0I
Bc];oc5;<D/aBc5;<D/aBc5;<D/aBomKo`0@>`0>oe];Foo>>lhkcS_>>lh2o`07>lkoog/?N`03o`06
3lh?cPo>0_l00`o>3`03o`063lh?oe@?0ol01PmD3e@?E0;o00@?E?mb1?l00eCoo`0;o`C=00WoX_oo
Uj:GXYL01_l00lO6o`03o`03S7co00?o00O7dlOCam?o008000?o00009@000ol0000M000050000ol0
000D0003o`0000L00_l02POg1oL7m`Og1oL2o`041oL7o`E;0_l:B`0Boe];Fol`6c0K<1/`6c0K<1/`
0_l01eD6E@IEof/00_l01H][Rf^;00;o00U[obD`9C0U<2D00_l01D/?B`m;00;o00T?oomK3e/?F`l0
0ol035]bFg9KLU]bFg9KLPSo00C>L/ib0ol01UCooleDc@So00O6U/JFaYKo00;70ol00lOoo`02o`?7
0_l01gcoooo7O<L00_l20003o`0002D000?o0000700001@00olE0003o`0000D001SoBc];>d/kBc];
>d/kBc];>olkod/aBc42o`0@Bc5;<D/aBc5;oe/aFc5Ko`<k0_l6>`?o00I;Fd]KBe/3o`06cS_>>lhk
0_l020mk3g/?N`mk1?l01<h?cPl2o`06cPo>3lh?1?l02Lko3e@?E0mD3`07o`09LUAbE79DLUAb00;o
00=Dold01/d2o`;=00?oX_l00_l01j:GXYOoa/L00ol01<O6og`3o`03O8co00?o00?Cam<00_l30003
o`0002D000?o00006`0001@000?o00005P000ol00003000?ooL7m`Og1oL7m`Og1oL700?o00AK1e_o
3D/3o`08Fd]KBe_o<1/2o`07<1/`6c3o1P02o`09E@IE1UD6EOm[00;o012;Jh_o<2D`9C0U<2D`9C0U
0_l02D_ooomK3e/?F`03o`09F`mK3e/?oe]b00Co00@?E@mE1?l04libcW;>L/ibcW;>L_mDcEC=E<d0
0_l01eC=E?nRcJ801?l00iKoa`02a`Go00?7ool00/L2o`07O?ooO<Mlo`030003o`0002D000?o0000
6`0000`00ol50003o`0001L001Co0000od/kBc];>d/kBc];>d/kB`;o00Xk<C/a>om;<D/a0_l01d/a
Bc5;oe/00_l01c5K<E/aFol01c/03Om;Fd]KBe];Fd]KBe/00ol04Lkoog/?N`mk3g/?N`mk3g/?00?o
00C>3lh?0ol02@o>3lh?cPo>3`03o`0:E0mD3e@?E0mD3`?o00YbE79DLUAbE79D0ol;c@05oj:GXYL0
1Ol01/K7ooo6a`;o00alooooO?oCO=?odlL2o`<000?o00009@000ol0000J00003`000ol0000200;o
6@006ol0ooL7m`Og1oL7m`Og1oL7m`OoF`MK1e/7o`04B`;o14/04OmKBe];Fd]KBe];oa/`6c0K00;o
01l6E@IE1UD6E@IE1UD6EOm[obD`9C0U<2D`9C0U<2D`00Wo00UK3e/?F`mK3e/00ol06PooE@mE3eD?
E@mE3eD?E@oocW;>L/ibcW;>0_l05G;oE<eDcEC=E<eDcECoX/fRcJ;=XP02o`O70ol02LOoooo7O<Oo
O002o`@000?o00009002oa/0000?0003o`00008000?o00006@02o`0_>d/kBc];>d/kBc];>d/koc/a
>c4k<C/aoc5;<D/aBc5;oe/aFc5K<E/aFc5K<Ol00c/2o`0?Be];Fd]KBe];Fd]KBe];00Go00mk3g/?
N`mk3g/?Nomk3g/01Ol020o>3lh?cPo>0_l08T]DBeA;oe@?E0mD3e@?E0mD3e@?og9DLUAbE79DLUAb
E?l8c@;o00_=oj:GXYNRUj;oaP03o`06alK7a_ml1?l01gcCO=?odlL00_l30003o`0002<00_lK0000
3003o`@000?o00006003o`0Kn_l7m`Og1oL7m`Og1oL7oe/7F`MK1e/7F`Oo00I;017oFd]KBe];Fd]K
Be];Fd_o6`03o`09E@IE1UD6E@IE00;o00L6E@Ko934T00;o00TU<2D`9C0U<2D00_l0233oool`9C0U
0_l01E/?F`mK00;o01hK3a/?6`lK3omE3eD?E@mE3eD?E@mE3oo>L/ibcW8@o`0<cECoX/fRcJ;=X_o1
1Ol2a`Co00KCooo7O<L4o`<000?o00009@000ol0000H000030000ol0000400;o6@02o`0[:`L[oc];
>d/kBc];>d/koc/a>c4k<C/a>c4kod/aBc5;oe/aFc5K<E/aF`02o`05<E/aFc400_l02d]Koom;Fd]K
Be];00;o00=KBol01G/2o`063g/?N`mk1Ol01g/?N`mk3g/00ol070oooom;E4]DBeA;E4]DBomD3e@?
E0mD3e@?E0l8o`04E7=DL`?o00O=E<eDcEC=00So00FRUj:GXP07o`03alKo00Go00EldoooO002o`@0
00?o000090000ol0000H00003004o`<000?o000060007ooj1oX7n_l7m`Og1oL7m`Ogo`MK1e/7F`MK
1e/7Fol00d/02omKBe];Fd]KBe];00Co00MKBolaJol600;o00UE1UD6E@IE1UD00_l022@a934T<B@a
0ol00bD`o`03o`0;9C0U<2D`9C0U<2D00ol05Q/?6`lK3a/?6`lK3a/?oeD?E@mE3eD7o`0:E5EDEEAE
E5EDE@?o00O=ELeEcEG=00;o00AEcOnR1?l00j;=XP03o`03`LK100Co00@loooC1?l01<Mlool40003
o`0002@000?o00005`0001<000?o00005`003ol[1b/7:`L[oc];>d/kB`03o`0N<C/a>c4k<C/a>c4k
<C_oBomK<E/aFc5K<E/aFc5K0_l00c7oJ`03J`03od]K00;o00M;Fd]KBe_o00]k1Ol01`mk3g/?N`l0
0_l00g/?N`02o`0Ec_ooBeA;E4]DBeA;E4]DBeA;oe@?00Co017>ELiEcUG>oeAcE7=DLeAcE002o`0:
Loo=E<eDcEC=E0;o00K=ooooSLd3o`08X_o6XlJSaZ<4o`03O?oo00?o00Aldooo1@000ol0000T0003
o`0001H0000C00;o5`004?oj1oX7nPOj1oog1oL7m`L2o`0Z1e/7F`MK1e/7F`MK1e/7FomKBe];Fd]K
Be];Fd]KBe];oc5[<F/aJol60_l04ED6E@IEoc4T<B@a934T<B@a00Co00T`9C0U<2D`9C000_l022D`
obD[9B/U0_l03A/?6`lK3a/?6`lK3a/00ol08ED?E@mE3eD?E@mE3omDEEAEE5EDEEAEE5GocEG=ELeE
c@02o`09ELgoX[fR_J:m00?o00O1a/76`LK100?o00UlooooO?mlag`00_l30003o`0002@000?o0000
5P0001<000?o00005P004_l7:`L[1b/7:`OoBc];>d_o<@;o00Xk<C/a>c4k<C/a0_l04c/aoc5K<E/a
Fc5K<E/aFc5K<Ol026/00om;F`02o`03Booo00Ek0_l2N`Co00EkRg_oN`02o`073g/?N`mk3`02o`06
FliKcU_>0_l02d]DBeA;E4]DBeA;00Co03QEcUG>ELiEcUG>ELiEc_mDLeAcE7=DLeAcE?mDcEC=E<eD
cEC=E?o=SLf=cHg=SLgoaZ?6XlJSaP;o00><ool00_l013coom<2o`@000?o000090000ol0000E0000
4`000ol0000E000Co`Oj1oX7nPOj1oX7ooL7mol7F`02o`0:1e/7F`MK1e/7F`;o00T7ooOoBe];Fd/0
0_l02E];Fd]KBolaJ`02o`08<F/aJc5[o`H3o`07934T<B@a9004o`08<BCo934T<B@4o`049C0U<0;o
018[9B/U:bD[9B/Uo`lK3a/?6`l3o`0fcS_>>omE3eD?E@mE3eD?E@mEoeEDEEAEE5EDEEAEE?mEcEG=
ELeEcEG=EOnmX[fR_J:mX_n=0ol01<K1a/42o`09dollO?ml??o700;o10000ol0000T0003o`0001@0
000B0003o`0001D002_o1b/7:`L[1b/7:`L[1om;oc4k<C/a>c4k<C/a>c4k<C/aod/kBolaFc5K00;o
00HaFc5K<Ol3J`;o1f/01?m;ool5N`?o00=kool00_l027^;Nh]kRg^;0_l027/?NomKcU_>0_l01e_>
FliKcU/00_l00eA;E002o`0l2lh;cP_>2lkoELiEcUG>ELiEcUG>EOmcE7=DLeAcE7=DLeCoE<eDcEC=
E<eDcECocHg=SLf=cHgoXj:S0_l01<JSool2a`;o00Alooml0ol50003o`0002<00_lE00004P02oa@0
0_l08@Oj1oX7nPOj1oX7nPOj1ol7F`MK1e/7F`MK1e/7F`MK1`03o`0Dm`Ogod]KBe];Fd]KBolaJc5[
<F/2o`06<F/aJc5[1Ol02BCooc4T<B@a9002o`0;<B@a934T<B@aobD00_l01BD[9B/U00;o00L[9B/U
:bD[00;o02<?oolkcS_>>lhkcS_>>omE3eD?E@mE3eD?E@mEoeEDEEAEE00:o`0>cEG=ELeEcOnR_J:m
X[d2o`06X_n=`Hg10_l01/K1olOCa`?o00=lool00_l40003o`0002@000?o00004`00018000?o0000
4`02o`0R:`L[1b/7:`L[1b/7:`L[oc/a>c4k<C/a>c4k<C/a>c7oB`;o00dkBc];oc5K<E/aFc7o00M[
0_l5J`03og]k00Go1G/2o`0;Nh]kRg^;Nh]kRg/00_l04LiKcU_>FliKcU_>FliKcU_>00;o00d;cP_>
2lh;cP_>2lh;00?o00[>ELiEcUG>ELiE2?l02UAEE5EDEOnmE;d7o`07cOn=cHg=S@02o`08cHgoXj:S
XZ<4o`;71_l00ccoo`040003o`0002@000?o00004P0001800_lD000>ooX7nPOj1oX7nPOj1oX3o`0D
n_mK1e/7F`MK1e/7F`MK1oog1oL2o`0K1oL7mom;Fd]KBolaJc5[<F/aJc5[<F/aJon;00Co00daoolT
<B@aoc4T<B@a00;o01LT<B@a9?l6Bol[9B/U:bD[9B/U:bD[9@02o`0@:olkcS_>>lhkcS_>>lhkcP;o
00IE3eD?E@l4o`0IFeGoLeAcE7=DLeAcE7=DoleDcEC=E<eDc@05o`0<X[fR_J:mol6=`Hg10_l00hgo
o`02o`03am?700Ko10000ol0000S0003o`000180000B0003o`00018000?o:`L00_l02R/7:`L[1b/7
:`L2o`0E6`LKoc/a>c4k<C/a>c4k<Om;>d/k00;o00Y;>d/kBolaFc7o3V/3o`Ak00?oNg/00g/01on;
Nh]kRg/00_l01H]kRg_o00AK02CocU_>FliKcU_>FliKoa_>6lkocP_>2lh;cP_>2lh;cP_ocUD4o`06
cUG>ELiE0_l055AEE5EDEEAEE5EDEOnmE;eD_EBm0_l015CocH04o`0=cHg=oj:SXZ>RXj:SXP02o`C7
1_l30003o`0002@000?o00001@03o`T0000300?o1002o`H000?o00004@001?oj1oX2o`0_1oX7nPOj
1oX7n_oj1oX7n_mK1e/7F`MK1e/7ooL7m`Og1oL7m`Og1oOoBolaJc400_l01f/aJc5[<F/00ol0:X]k
Rg^;Nh]koc4T<Ola934T<B@a934T<BCo1T/6B`I;ob/U:bD[9B/U:`;o01AK:e/[Fb_o>lhkcS_>>lhk
cS_>>`?o00YKEE]EFeEKEE]E0ol00g=DL`02o`0>E7=DLeAcoeC=E<eDcE@2o`08cECocHg=SLd5o`08
`Hg1SL6=`Hd4o`03am?o00;o00Aloooo0`000ol0000T0003o`0000L000?o00001P0000@000?o0000
0P001?l00?l50003o`000100037o:`L[1b/7:`L[1b/7:`L[1ol76`LK1a_o>c4k<C/a>c7oBc];>d/k
Bc];>d/kBc];00;o0f/2o`A[0ol00f_oN`09N`0@og_oRg^;Nh]kRg^;Nh]ko`QK00OocU_>FliK00;o
01C>6lhKcQ_>6lkocP_>2lh;cP_>2`;o01?>oeG>ELiEcUG>ELiEcUGoEEAE00;o01UDEEAEE5EDoeBm
E;eD_EBmE;goP<f0cH3=00;o00^0oonRXj:SXZ>RX`02o`03S?o700;700?oO7`00ol30003o`0002<0
00?o00001`000ol00006000010000ol000020004o`00o`@00_lA000hooX7nPOj1oX7nPOj1oX7nPOo
1oX7nPOj1ol7F`MK1e/7ooL7m`Og1oL7m`Og1oL7m`Oo:om[<F/5o`08Jc5[oh]kRg/2o`05Rg^;Nh/0
0ol09b@aoolT<B@a934To`I;1T/6B`I;1T_o:bD[9OmK:e/[Fb]K:e/[F`03o`05cS_>>lh00ol07?[>
n/koFeEKEE]EFeEKEE]EFomDLeAcE7=DLe@3o`0GcEC=E<eDcEC=E<goSLf=cHg=SLf=oj<00ol028g1
SL6=olJS0_l01=?7og`4o`<000?o00008`000ol0000300?o2@0000@000?o00000P001?l00?l40003
o`0000l002ko:`L[1b/7:`L[1b/7:`L[1ol76`LK1a/76`Oo<C/a>c7oBc];>d/kBc];>d/k0_l01d/k
od/7Bol00V/4o`=[00?oNg/00g/4o`9k00KoNh]kog/2o`07Rg^;Nh]ko`0<F`0Aolkooa_>6lhKcQ_>
6lhKcQ/00_l00lh;cP02o`0Oj/kZc^[>j/koELiEcUG>ELiEcUG>EOmEE5EDEEAEE002o`04EOnmE0;o
01FmE;eD_EBmoh3=P<f0cH3=P?nRXj800_l02::SXZ?oO8al0_l01LOoooll00;o0P000ol0000S00;o
10000ol00009000010000ol000020004o`00o`@000?o00003P02o`0]1oX7nPOj1oX7nPOj1oX7o`Oj
1oX7nPOj1oX7o`MK1oog1oL7m`Og1oL7m`Og00;o00H7ob]k:g/3o`0?<F_ooc5[oh]kRg^;Nh]k00;o
00N;og^;Nh]k00;o01@a934T<BCo1T/6B`I;1T/6B`I;1P;o018[Fb]K:e/[Fb]K:e/[Fb]Kolh2o`0W
c_[>n/kjc_[>n/koFeEKEE]EFeEKEE]Eog=DLeAcE7=DLeAcE?o=00;o019DcEC=E<eDolf=cHg=SLf=
cHd3o`0;Xlgoohg1oj?6XlH01?l2O0?o0P000ol0000Q0003o`3o00@01?l800000`02o`D00_l500;o
3`03o`0a1b/7:`L[1b/7:`L[1ol76`LK1a/76`LK1a/7oc7oBc];>d/kBc];>d/kBc];>om;1`03o`03
1d_o00A[0_l;N`09og^;Nh]kRg^;00;o00AkRg_o3E/01?m;oa/2o`07cQ_>6lhKcP02o`046lhKcP;o
03gZc^[>j/kZc^[>j/kZc_mEcUG>ELiEcUG>ELkoE5EDEEAEE5EDEECoE;eD_EBmE;eD_ECocH3=P<f0
cH3=00?o00BSXZ>R1?l00halS002o`05O?ooO=<00ol20003o`0002<000?o00003@00014000?o0000
3@00<Ol[_b_o1oX7nPOj1oX7nPOjooX7nPOj1oX7nPOj1oX7ooL7m`Og1oL7m`Og1oL7m`L01?l02W/[
Nb]k:om[<F/2o`0ZNh]kRg^;Nh]kRomkRg^;Nh]kRg^;NolTo`I;1T/6B`I;1T/6B`Ko<2/`0ol01e/[
Fb]K:e/00_l04b]Koolaolkjc_[>n/kjc_[>n/h00_l02eEKEE]EFeEKEE]E01Go01QDooo=ohg=SLf=
cHg=SLgocJ?=XlfScJ<2o`06XlJSaZ?60ol017coool20003o`00028000?o00003@00014000?o0000
3@000olK1`03o`0R1b/7:`L[1b/7:olK1a/76`LK1a/76`LK1a_o>d/kBc];>`;o00E;>d/kB`03o`0=
1d/7B`M;1d/7Bom[o`0;N`0=og^;Nh]kRg^;Nh]kR`02o`aK0_l03d/kBc];oa_>6lhKcQ_>6`03o`0A
mlkgc_o>j/kZc^[>j/kZc^X00ol01/iEcUG>E@Oo00AEE5ED0_l00eEDE@03o`03_EBm00;o00=Dool0
1_l06H3=P<f0cH3oXZ>RXj:SXZ>RXon<O8alS7`00_l00gcCO002o`030?l002@000?o000030000140
00?o000030001?no:kl2o`0S:ol7nPOj1oX7n_oj1oX7nPOj1oX7nPOj1o[on_l7m`Og1oL00_l00`Og
o`03o`06:g/[Nb]k0_l01B]k:g/[00;o019kRg^;Nh]kRg^;og^;Nh]kRg/2o`0SRg^;og][o`I;1T/6
B`I;1T_o:c0[<2/`:c3oFb]K:e/[Fb/00_l01Q/a6c4K<@;o00cjc_[>n/kjc_[>n/h2o`03EE_o00;o
00_=:ld[cB_=oeAcE002o`03LeAc00;o00ADoleD0_l02LeDcEC=E?o=S@03o`0HSLf=cHgoXlfScJ?=
XlfSoj?oaZ?6XlKo0g`3o`030?l002@000?o00002`00010000?o000030001olK1a/76`L00ol08@L[
1b/7:olK1a/76`LK1a/76`LK1a_o:`L[oc];>d/kB`03o`0:Bc_oB`M;1d/7B`?o00M;1d/7o`Oo00Qk
00WoNh]kRg^;Nh/00ol01h_oNf]kJol00e/2o`=K017o>d/kBc];>d/kolhKcQ_>6`02o`08c_oomlkg
c_L2o`0<c^[>j/kZc^[>j/kZ1?l05EG>ELiEcUG>ELiEoeEDEEAEE5EDE@03o`0?_EBmE;eD_EBmE?o=
P<f000?o00n0cH3oXZ>RXj:SXZ>Roh`00_l028alS7codooC0ol00`3o000S0003o`0000/0000@0003
o`0000/000So_b^o:kl[_`;o020[o`Oj1oX7o`Oj1oX7nPOj1oX7nPOjooX7nPOjo`Og1`;o00kgool7
ob]k:g/[Nb]k:`;o00Mk:g_oNe]k00;o012;Nh]kRomkRg^;Nh]kRg^;0ol02G][Nf]kJol6B`02o`08
1_oo:c0[<2/2o`0=<2/`:ol[Fb]Koa/a6`02o`06<A/a6c4K0ol02?[>n/kjc_[>1Ol02ld[cB_=:ld[
cB_=00;o00UcE7=DLeAcE7<00ol04UC=E<eDcEC=E<eDolf=cHg=S@Co00[=XlfScJ?=XlfS0_l01Z?o
XlJSaPOo00<0o`008`000ol0000:000040000ol0000;000Wo`LK1a/76`LK1a/7o`L[1ol76`LK1a/7
6`LK1a/76`Oo1b/7:`L[00?o01`kBc];>om;1d/7B`M;1d/7B`M;1ol7J`M[1f_o0g/05omkoon;Nh]k
Rg^;Nh_oNf]kJg][Nf_o00=K00SoBc];>d/kB`;o00LkBc];>oo>00;o00ggc_O>mlkgc_O>mlkg00;o
00K>j/kZc^X2o`03c^[>00?o00YEcUG>ELiEcUG>0ol02EAEE5EDEEAEE003o`03E;eD00;o00nmE;eD
_On0cH3=P<f0cH000ol01::SXZ<2o`06XZ?oohbS0_l027b<oooCaoml0olU0003o`0000T0000@00;o
2`009Ol[_b^o:kl[_b^o:kl[o`Oo1oX7nPOj1oX7nPOj1oX7o`Oj1oX00ol09?[o1oL7m`Oo:g/[Nb]k
:g/[Nb]k:g_oNe]kFg]KNe_oRomkR`?o02B;Nh]kRg^;og][Nf]kJg][Nf_o1_l`:c0[<2/`:c0[<2/`
:c02o`0E<Ooo6c4K<A/a6c4K<A/aolkjc_[>00Co01Kgc_O>mlkocB_=:ld[cB_=:ld[og=D0_l017=D
Le@2o`04LomDc@;o00=DcE@00_l03LgoSLf=cHg=SLf=oj<00ol01j?oolfScOl01:<2o`05Xoo7O<L0
1OlS00;o2`00010000?o00002@003_l76`LK1a/76`LK1a/70ol02@LK1a/76`LK1`02o`076`LK1ol7
:`03o`0=:`L[1b_o>d/kod/7B`02o`0D1d/7B`M;1d/7o`M[1f/7J`M[1f/2o`03Rg^;00Co01AkRg^;
og][Nf]kJg][Nf]kJom;>`;o00m;>d/kBc];>d/kBolkooL00_l01/kgc_O>m`;o00O>mlkgc_o>00?o
01[>j_ooc^[>j/kZoliEcUG>ELiEcUG>EOmEE0;o00EEE5EDE@03o`03_EBm00;o01AD_OooE;goP<f0
cH3=P<f0oj:SXP;o012SXZ>RohbSS:><Xon<olOC1?l00`3o000S0003o`0000P0000@0003o`0000P0
0_l03Kl[_b^o:kl[_b^o:kl00ol02OX7nPOj1oX7nP02o`031oX700Co013j1oX7nPOj1o[o1ol[Nb]k
1?l03B]k:g/[NomkFg]KNe/00_l02W]KNom[oh]kRg/2o`0@Rg^;og][Nf]kJg][Nf]kJ`;o01D[<?oo
:c0[<2/`:c0[<?lk2c_o6c400_l011/a6c42o`056c4K<A/00_l03Lkgc_O>mlkgc_O>mlh00_l02R_=
:ld[cB_=:ld3o`03E7=D00;o00=cE7<00_l015CocE@2o`08cEC=E<eDold2o`0<SLf=cHg=SOnScJ?=
0_l01:?=Xol3X`;o00FSooooa`06ob<00ol900003`03o`T00_l070LK1a/76`LK1a/76`LKooOo6`LK
1a/76`LK1a/3o`0=:`L[1b/7:`L[1b/7:`02o`061d/7B`M;0_l03@M;1d/7o`M[1f/7J`L00_l01V/7
o`Mk1`;o01AkRg^;Nh_oNf]kJg][Nf]kJg][o`9K01Go>d/kBc];>d/kBc];oc/a>c4kooL00_l06/kg
c_O>mlkgc_OomooZc^[>j/kZc^[>j/kZ0ol01<iEcUD2o`03cUG>01Ko00BmE;eD0ol01<f0cH02o`08
cOnSXZ>RXj83o`04X_n<X`;o00R<XooodlOCa`Co7`03o`8000?o00001`0000040?ooo`<00ol50003
o`0000P001;o_b^o:kl[_b^o:kl[_b^ooc83o`07nPOj1oX7nP03o`0an_oj1oX7nPOj1oX7nPOj1ol7
og/[Nb]k:g/[Nb]kog]KNe]kFg]KNe]kof]KJe][F`02o`03Rg^;00;o01Y[Nf]kJg][Nf]kJolaFc5K
ob/`:c0[<2/`:`;o018k2c/;>`/koa/a6c4K<A/a6c42o`0GcU_>ooO>mlkgc_O>mlkgc_O>old[cB/0
1_l00lkoo`03E0;o1U@00oo=c@04c@So00?=SLd00_l00hg=o`02o`03cJ?=00;o00>Sool02:<01_ml
agc7O0?o6`03o`D000?o00001`00008000?o00001@000ol000020003o`0000P001;o1a/76`LK1a/7
6`LK1a_om`L2o`06molK1a/70_l0>1/76ol[1b/7:`L[1b/7:`L[1ol7>`Oo1d/7B`M;1d/7o`M[1f/7
J`M[1f/7o`Mk1g/7N`Mk1on;0ol02g][Nf]kJg][Nf_o00IK01_o>d/kBc];>ola>c4k<C/a>c4kooO>
mlkgc_L00ol5m`0Bon[>j/kZc^[>j/kZc^[>oeG>1?l013_>>lh3o`03E7?o00;o00AcE7=D0ol00leE
c@02o`08ELgooeGoLj83o`05cH3=P<d00_l00j:SXP02o`0BXj:Soj><XhbSS:?oaoo7dlOC0olF00Co
20000ol0000700000P000ol000050003o`0000800_l8000Gob^o:kl[_b^o:kl[_b^o:omK<U/bFc80
1?l0<@Oj1o[onPOj1oX7nPOj1oX7nPOo1b/7:`OoNb]k:g/[NomkFg]KNe]kFg]KNom[Ff/00_l01U][
Ff]KJ`;o01Q[Nf]kJg][Nf]kJolaFc5K<E/aFol[<2/3o`052c/;>`/00_l03C/;>`_o<A/a6c4Kolh0
0_l03E_>FliKolkgc_O>mlh00_l01OO>mlkg00?o00abc_ooL/ibcW;>L_l2E0;o15@2o`04E?o=c@;o
0ld2o`06cOo=X/fR0ol03lf=oj?=XlfScJ?=XonRo`06X`06om?oagc70olC00?o3@000ol000060000
0P000ol0000200?o1@000ol00006000Fo`LK1a/76`LK1a/76`LK1ol7m`Og1`?o00X76`LK1a_o:`L[
0_l030L[1b/7:`L[1ol7>`;o01X7>`Oo1d/7B`Oo1f/7J`M[1f/7J`Oo1g/7N`;o01<7N`Mk1g_oFom[
Nf]kJg][Nf_o00YK00?o>d/00_l01S4k<C/a>`;o00La>c4k<Oo>00Co2_L2o`05j/kZc^X00_l00lkZ
o`02o`0H6oo>>lhkcS_>>lhkcS_>oeAcE7=DLeAc0_l025CocEG=ELeE0_l02LeEog>RLj9cXP04o`0;
XZ>RXj:SXZ>Roj800_l01j><XhbSolL00ol01<Ooool?00?o40000ol0000600000P000ol000020003
o`0000D000?o00001@005?l[_b^o:kl[_b^o:kl[_b_oFc9K0ol03E/bFol7nPOj1ol7nPL00_l03?X7
nPOj1oX7n_l[1`;o00d[1b/7og/[NomkFg]K00;o03ekFg]KNom[Ff]KJe][Ff]KJe_oBe];of]kJg][
Nf_o<E/aFc5K<E/aFc5Kob_o2c/;>`/k2c/;>`/k2c/;00?o00aKcU_>FliKcU_>Flh2o`07c_O>mlkg
cP02o`0D3c4?<@ooL/ibcW;>L/ibcW;>L_l7E0;o0U@00oo=c@08c@09olfRcJ;=X/fR00?o00c=XlfS
cJ?=ogbRO?l4X`03olOC00;o00=lag`00_l:00Co4`000ol00006000000<0ool01004o`@000?o0000
1@004OlK1a/76`LK1a/76`LK1ol700?o00D7m`Og1`03o`0U1a/7o`L[1b/7:`L[1b/7:`L[oc/7>`Lk
1c/7>`Oo1ol7J`M[1`02o`0NJ`M[1f_oN`Mk1g/7N`Mk1g_oF`MK1e_oJg][Nf_o3U/04Ola>c4k<C/a
>c4k<C/a>c4k00;o3_L3o`03j/kZ00;o02C>6lhKcQ_>6oo>>lhkcS_>>lhkcS_>oeAcE7=DLeAcE7=D
old2o`09ELeEcEG=oj9c00;o00NRLoooX_nR00;o00ZRoonSXZ?oaj;70_l018bSS?l3a`;o00C7oooo
1P03oaL000?o00001P0000h000?o00001@003ono:kl[_b^o:kl[_b^o:`03o`08Fc9K<U/bFc82o`0;
Fol7o`Oj1oX7nPL00_l04_X7nPOjob/7:`L[1b/7:`L[1`;o01MKNe]kFg]KNe]kFomKJe][Ff]KJe][
F`02o`0IFd]KBe];of]kJolaFc5K<E/aFc5K<E/aF`02o`0Q>`/k2c/;>`/k2c/;>`/koe_ocU_>FliK
cU_>FliKcU_>00Go00X?<@la3c4?<@la0_l02g;>L/ibcW;>L/ib01?o0/d2o`03cOnR00;o00W=X_oo
cJ;oXj800ol00j?=X`03o`03XWbR00;o00FSom?7d`03o`03aooo00801?lJ0003o`0000H0000>0003
o`0000<00_l031/76`LK1a/76`LK1`Co01Og1oL7m`Og1oL7m`Og1ol7:`L[1b/7:`02o`0]1b/7:olk
1c/7>`Lk1c/7>`Lko`OoJ`M[1f/7J`M[og/7N`Mk1g/7N`Mkoe/700;o00QK1e/7Fom[o`iK01Go<D_o
>c4k<C/a>c4k<C/a>olk<C/00ol<m`;o00dKcQ_>6lhKcQ_>6lhK00;o00LkcS_>>lhk00Co00MD3eCo
LUAb00;o00QDLUAbE7;oc@Oo00o=oj9cXW>RLj9cX_nR`J800ol01j>Rooo7X/L00ol00j?oa`04a`Go
7P000ol0000600003P000ol0000300?o00Vo:kl[_b^o:kl00_l0<R^ooc9K<U/bFc9K<U/bFc9K<_oj
1oX7nPOj1oX7nPOjob/7:`L[1b/7:`L[1b_oVe^K0_l05W]KNe]kFomKJe][Ff]KJe][Fom;Fd/2o`0U
Fd]KBe];oc5K<E/aFc5K<E/aFc5Koc];>d_o>`/k2c/;>`/k2`02o`05FoYKnU/00_l01e_>FliKcU/0
0_l01/kooc_o<@;o00/?<@la3c4?<@la3`02o`03cW;o00?o00/?E0mD3e@?E?mbE002o`08LUAbE79D
L_l6c@Ko00JRcJ;=X/d3o`06XZ?ooj?=0ol01GbRooml00?o00GCam?7d`04oah000?o00001P0000d0
0ol70006oa/76`LK0ol0=Q/76`Oo1oL7m`Og1oL7m`Og1oOo6ol[1b/7:`L[1b/7:`Oo1c/7>`Lk1c/7
>`Lko`Lk1c/7>`;o01e[1f_oN`Mk1g/7N`Mk1g_oF`MK1e/7F`MK1e/7o`0=F`?o01HaBc7o<C/a>c4k
<C/aoc4k<C/a>c4k0ol5m`?o00@[cR_>0ol02lhKcQ_>6lhKcQ_>00Co01ID3e@?E0mD3e@?E0mDog9D
LUAbE79D0_l00g;oc@04c@;o0/d00onRo`02o`04XW>RL`;o00BR`J;10_l02Z?ooj;7X/NRaj82o`G7
0_l00`3o000M0003o`0000D0000>0003o`0000L000?o_ol00_l0I[l[_b^o:omK<U/bFc9K<U/bFc9K
<_no:koonPOj1oX7nPOj1ol7:`L[1b/7:`L[1b/7oe^KFi]KVe^Koe_oFf]KJe][Ff]KJe][oe];Fd]K
Be];Fd]Koc7oFc5K<E/aFc5K<E_o>`;o01I;>d/ko`/k2c/;>`_onU_jFoYKnU_j0ol03E_>FliKoc]k
>g/kNc/00ol02C4?<@la3c4?<@06o`04E0mD3`;o00ED3e@?E003o`07LUAbE79DLP02o`03E7;o00W=
00Coa/g60ol02J;oXj:SXZ>RX`04o`06XWcooj9l0_l01LOCam?700Co7P000ol0000500003P000ol0
000600?o03lK1a/76`LK1ol7m`Og1oL7m`Og1oL7m`Oo1a/76ol[1b/7:`L[1ol7>`Lk1c/7>`Lk1c/7
oc/7>`Lk1c/7>`L00_l05PMk1g/7N`Mk1g/7o`MK1e/7F`MK1e/2o`04>d/ko`UK00Go<D/aB`02o`08
<D/aoc4k<C/2o`04<C/a>`;o00Ha>c4k<Ol4m`;o00W>:lh[cR_>:lh00_l01Q_>6lhKcP?o00@?F`mK
0ol00e@?E004o`033e@?01Co0/d2o`07cOnRUj:GXP03o`08X_oo`J;1X/42o`0:aj;oolNRaoo7o`G7
0olM0003o`0000D0000=00;o1@03o`<003[o_b^o:kl[oe/bFc9K<U/bFc9K<U/bFol[_b^o:koonPOj
1oX7o`L[1b/7:`L[1b/7:`OoFi]KVe^K0_l06e^KFol7of]KJe][Ff]KJomKBe];Fd]KBe];F`02o`09
1c47<OmK<E/a00;o00MKoc];>d/k00;o00i;>d_o>`/koe_jFoYKnP;o00QKnU_jFo[oF`;o015k>g/k
Nc]k>g/kNc_o<@la3`05o`05E7]DNe@00ol015@?E0l6o`0@LW]bNomD3U@>E0iD3U@>E0So00K=olK=
a/d2o`0;a_oooj>RXj:SolL00_l01J9lXWbR00;o00KCom?7dlL2o`030?l001/000?o00001@0000d0
00Co00000ol7000Zoa/76`LKooL7m`Og1oL7m`Og1oL7o`LK1a/76`LKob/7:`L[oc/7>`Lk0_l03@Lk
1c/7oc/7>`Lk1c/00_l01PLkoc/7>`;o01]k1g/7N`Oo1e/7F`MK1e/7F`Oo>d/kBc];>ol00e/3o`0>
<D/aBc5;<D/aBc5;oc/3o`07>c4k<C/a>`02o`04<C/a>`;o00S>:lh[cR_>:`;o00O>:lh[c_o>00;o
00=K3e/00_l01PmK3e/?F`?o00=D3ol00ol01U@?E0mD3`?o019DLUAbE79DLUAbE?nFcIK=U/d3o`03
XYNR00?o00>RUol00_l03<6R`J;oS7coX/NRa`;o0/L2o`?70olL0003o`0000D0000=00Co2`003Ono
:koo<U/bFc9K<U/00_l0339K<U/bokl[_b^o:`;o00boooX7n_l[1b/7:`L2o`0G:`L[1b_oVe^KFi]K
Ve^KFol79@LU1bD00_l0;V]KJomKBe];Fd]KBe];Fola1c47<@La1c7oFc5Koc];>d/kBc];>d/kBc];
oe/2o`07nU_jFoYKnP02o`0>FoYKod_oNc]k>g/kNc/2o`05Nc]k>g/00ol01eAkE7]DNe@00_l00g]D
N`05o`0:Ng9kLW]bNg9kLPCo00eD3U@>E0iD3U@>E?nR00;o00K=X/fRcJ85o`05cLKoolL01?l01:?o
ah`2o`04O:9lXP;o00GCaoo7d`04oa/000?o00001@0000d00_l>000<oa_om`Og1oL7m`Og0_l030Og
1oOo6`LK1a/76`;o02076ol[oc/7>`Lk1c/7>`Lk1c_o1c/7>`Lk1c/7>`Oo1`;o030k1c/7>ol7o`MK
1e/7F`MK1e/7oc];>d/kBc];>d/koe_o<D/aBc5;<D/aBc5;<D/2o`0?<C/a>c4k<C/a>c4k<C_o00=;
00go:lh[cR_>:lh[cR_>00;o00Y[3oooF`mK3e/?0_l00e/?o`02o`0>cPo>o`mD3e@?E0mD3e@2o`04
3omDLP;o00=DL_l02?l01LfFcIK=00;o00>S`?l00_l01J:Gooo700;o00K1X_n<O8`2o`04X/Ooo`?7
0_l01LOoo`3o01X000?o00001@0000l000?o000030006olbFc9K<U/bFc9K<U/bFc;o_b^o:kl[_b^o
:`02o`0>_ooo1b/7:`L[1b/7:`L2o`0>Ve^KFi]KVe^KFi_o9@L2o`069@LU1bD70_l0:4]KBe];Fd]K
Be_o<@La1c47<@La1c47<OlkBc];>d/kBc];>d/kBol2B`0EooYKnU_jFoYKnU_jFom;<4/`Bomk00;o
00HkNc]k>g/2o`04Bc1;<0Co00EkE7]DN`03o`053h/?R`l00ol02W]bNg9kLW]bNg89o`03LUAb00;o
00ADolg=1_l01Z;ooonS`0Co0lL4o`04ahc7S0;o00Mlooo7dlOC00Co00<0o`006@000ol000040000
40000ol0000;000Ko`Og1oL7m`Og1oL7m`Og1ol76`LK1a/76`LK00;o00h7o`Oo1c/7>`Lk1c/7>`;o
018k1c/7>`Lk1c/7o`Lk1c/7>`L2o`0i>`OoBomK1e/7F`MK1olkBc];>d/kBc];>d/kBom;<D/aBc5;
<D/aBc5;od/aBc7o<C/a>c4k<C/a00;o1d/3o`0=:lh[cR_oJ`m[3f/?J`02o`033ol?00?o00S>3lh?
cPo>3`Go00=D3ol01Ol04E@?E0mDog9DLUAbE79DLUCo00K=3?l01LK7a/O600?o00AlS7b<0ol5a`03
olOo00;o6P000ol0000400004@000ol0000;000noe/bFc9K<U/bFc9K<U_o:kl[_b^o:kl[_b^o:ol7
6`Oo1b/7:`L[1b/7oe^KFi]KVe^KFi_o9@LU1bD79@L2o`059Om;1d/00_l08e];Fd]Koc47<@La1c47
<@La1c47oe_oBc];>d/kBc];>d_o00I;01?onU_jFoYKn_l`Bc1;<4/`Bc1;00?o00mk>ooo<4/`Bc1;
<4/`Bc000ol03H/?R`n;3h/?R`n;3h/01?l00`mD3`02o`0?E0mD3e@?E?mbE79DLUAb00;o00=Dold0
1<d2o`;=1ol01:?oool3a`;o00G7S<N<a`02o`06am?7dlOC0ol00`3o000H0003o`0000@0000B00;o
30007Ol7m`Og1oL7m`Og1oOo6`LK1a/76`LK1a/7o`Lk00;o00l7oolk1c/7>`Oo>`Lk1c/00_l0@`Lk
1c_o>`Lk1c/7>`Lk1om;1d/7B`Oo1e/7oc];>d/kBc];>d/kBc];oc/a>om;<D/aBc5;<D_oBc5;<D/a
Bc7o<C/00_l00c7oB`0;B`Co00L?J`m[3f/?00;o00E[3f_oR`03o`093lh?cPo>3lh?00?o00MK3e_o
E0mD00;o00l?E0mD3e@?E?mbE79DLU@01Ol6c@;o00?=oiL01Ol00j?oS002o`03alK700;o00IlS7b<
O?l3a`;o0/L2o`030?l001L000?o0000100001@000?o00002P007?mK<U/bFc9K<U/bokl[_b^o:kl[
_b^o:koo6`L2o`0?6`LKob/7:`OoFi]KVe^K00;o039KVe_o1bD79@LU1bD79Om;1d/7B`M;1omKoc47
<@La1c47<@La1c47oe/7F`Oo>d/kB`;o00<kBol02T/00oojo`02o`06<4/`Bc1;0_l01C1;<4/`00?o
00Q;<4/`Bc1;<0;o00E;oolk1P04o`05R`n;3h/00ol04eAkE7]DNeCoE0mD3e@?E0mD3e@04Ol2c@;o
0/d3o`03cOoo00?o00?7O?l00_l02lOoooo7S<OoaooC00;o00C7dooo0P000ol0000E0003o`0000@0
000E0003o`0000T00_l0;@Og1oL7m`Ogoa/76`LK1a/76`LK1a_o>`Lk1c/7>`Lkoc/7>ol7>`Lk1c/7
>`03o`0K>`Lk1c/7>`Lk1c_o1d/7B`M;1d/7oc];>d/k00;o019;>d/kBc];oc/a>c4k<OlaBc42o`0A
Bom;<D/aBc5;<D/aBc7o<Ol01d/2o`A;00goNf]ko`m[3f/?J`m[00;o00H?R`n;3h/3o`073lkooe/?
F`02o`0=3e/?F`mKoe@?E0mD3`06o`l01_l01/goUj:GXP;o00JGohc7S<L3o`08aoooohcoaol4a`?o
00<0o`005P000ol0000400005P000ol0000800?o02aK<U/bFc9Kob^o:kl[_b^o:kl[_olK1a/76`LK
1a/76ol[oi]KVe^KFi]KV`?o014U1bD79@LU1bD7o`M;1d/7B`02o`081d_o1c47<@L2o`0E<@La1c47
oe/7F`MK1e/7oc];>d_o00M;0_l5B`0Ooc1;<4/`Bc1;<4/`Bc3o<B@a937oBc1;<4/`oc/6>`02o`05
1S/6>`H01?l015AkE7/2o`0:E7]DNeAkE?mD3`Go6@03o`05cLK=a/d01?l017c7O<L5o`03S<Oo00Co
00CCaooo0P000ol0000D0003o`0000@0000G00;o2P008_og1oL7m`Oo1a/76`LK1a/76`LK1ol7>`Lk
1c/7>`Lk1c/2o`0M>`Lk1c/7>`Lk1ol7>`Lk1c/7>`Lko`M;1d/7B`L00_l09T_o:om;>d/kBc];>d/k
Bolk<C/a>c4k<C_oBc5;od/aBc5;<D/a0_l014/aBc42o`a;00SoNf]kJg][N`?o00L?oon;3h/?00;o
00B;3h/?1Ol03@mK3e/?F`mK3e/?F`l01OlQ00Go00>GolH00_l01/N<ooo7?0Co00?7ool00/L3o`80
00?o000050000ol0000300006@000ol00008001Ooc9K<U_o:kl[_b^o:kl[_b^o:ol76`LK1a/76`LK
1a/7obKoFi]KVe^KFi_o9@LU1bD79@LU1ol7B`M;1d/7B`M;o`/72ol7<@La1c47<@OoF`MK1e/7F`MK
1e_oBol02d/2o`0>Bomk<Om;<4/`Bc1;<4/2o`09<B@a934T<B@a00?o00X6>`Hk1S/6>`Hk0_l014/`
Bc03o`08E7]DNeAkE7/5obL00ol01<goalL3o`03O?o700Co0lL01Oo7dlOo00<000?o00004`000ol0
000300006P000ol00008000SooL7molK1a/76`LK1a/76`Oo1c/7>`Lk1c/7>`Lk1olk1c/00_l03@Lk
1c/7o`Lk1c/7>`L00_l0=C/7od/7B`M;1d/7Bol[1b/7:om;>d/kBc];oc/a>c4k<C/a>c4k<C_oBc5;
<D/aBc5;<D/a00?o00E[Ff]Ko`07B`0<of]kJg][Nf]kJg][1_l03@n;3h/?Rom[3f/?J`l00ol01@mK
3e/?00Co;@04o`04a/O6a`Go00O7ooooacco00;70_l20003o`0001<000?o00000`0001/000?o0000
20008?lbokl[_b^o:kl[_b^o:ol76`LK1a/76`LK1a/7obH70_l03bH7oomKVe_o1bD79@LU1`02o`0I
9Om;1d/7B`M;1d/7o`L;1`/72ol7<@La1`03o`0=F`MK1e/7F`MK1e/7o`0=B`0Dog/aNc5k<Om;<4/`
BolT<B@a9342o`06934To`l71Ol01`Hk1S_o<4/00_l0231;<4/`Bomk1?l`00;o0P03o`?70_l00lOo
a`02o`?700Coaooo0`000ol0000B0003o`0000<0000L00;o2@007olK1a/76`LK1a/76`LKoc/7>`Lk
1c/7>`Lk1c_o1c/00_l0:`Lk1c_o>olk1c/7>`Lk1c/7od/7B`M;1d/7B`Oo1b/7:`L[1b_oBc];oc/0
0_l0734k<C/a>c4k<C/aoc_o<D/aBc5;<D/aBc7oJe/2o`05Je][Fol00d/02?m[Nf]kJg][1Ol5R`?o
00N;3oooJ`m[00;o00H?J`m[3f/3ocP00ol01<K7a/L4o`05??llac`00_l00lOo00020003o`000140
00?o00000`0001h000?o00001`008?no:kl[_b^o:kl[_olK1a/76`LK1a/76`LKo`LV1bH70_l00bH7
9P02o`0e9@LU1bD79@LUod/7B`M;1d/7B`Oo1`/72`L;1`/72ol7oe/7F`MK1e/7F`MK1e/7o`/72ol0
2D/01?mk<G/3o`06Nc5k<Om;0ol022@a934T<B@a0_l02Pl73`L?1`l7o`H2o`0:<4/`Bc1;<4/`B`;o
00<0ool0>`02o`;70ol017coool4a`;o0`000ol0000A0003o`0000<0000O0003o`0000L000ko6`LK
1a/76`LKoc/7>`;o00l7>`Lk1c/7>ol7>`Lk1c/00_l01@Lk1ol700;o02hk1c/7>`Lko`M;1d/7B`M;
1ol7:`L[1b/7:`L[1b_o>c4k<C/a>c4k<C/a>c7o1C/03_laBc5;<D/aof]KJe][0_l01E][Ff]K00Co
00QkJg][Nf]ko`Z;1?l020m[3f/?J`m[0_m200_o00?7??l00_l30003o`00010000?o00000`000200
00?o00001`003Ono:kl[_b^o:ol76`L01?l04A/76`LK1olV1bH79PLV1bH700Co030VoolU1bD7o`M;
1d/7B`M;1d_o2`L;1`/72`L;1`/7o`MK1e/7F`MK1e/7F`Oo2`L2o`042`L;o`E;00koNc5k<G/aNc5k
<G/ao`9k00?o<B@00_l06S4Tool73`L?1`l73`L?ob@a9?l`Bc1;<4/`0om300co00?7ool010000ol0
000@0003o`000080000Q0003o`0000L000ko6`LK1a/7o`Lk1c/7>`;o01<7>`Lk1olk1c/7>`Lk1c/7
o`M;00Co01X7oolko`M;1d/7B`M;1d_o:`L[1b/7:`L[1`?o00h7oc4k<C/a>c4k<C/ao`<k0_l4>`0B
oc5;<Om[Ff]KJe][Ff]KJe_o17/6o`^;00_oJg][Nf_oJ`m[3`02odX02Ol013c7ool30003o`0000l0
00?o00000P0002800_l8000?okl[_b_o1a/76`LK1a/700;o01<K1olV1bH79PLV1bH7o`LV1bH700;o
00<V1bH00_l05D/7B`M;1d/7Bol;1`/72`L;1`/72`02o`0D<OXao`MK1e/7F`MK1ol;1`/72`L2o`0C
2`L;od_oNc5k<G/aNc5k<G/ao`07N`0=obCoo`L?1`l73`L?1`02o`09934T<B@a9?l`00;oC@02o`03
aooo00Oo0`000ol0000?0003o`000080000T0003o`0000H000ko6`LKoc/7>`Lk1c/7>`;o0347oc/7
>`Lk1c/7>`Lkod/7B`M;1d/7B`Oo1om;1d/7B`M;ob/7:`L[1b/7:`L[1ol700;o00`K1ola>c4k<C/a
>ol6>`;o13/03Om[Ff]KJe][Ff]KJe/00ol7N`;o2H/02_mkJg][Nf]kJg/2oe800_l01LOoooll00?o
0`000ol0000>0003o`000080000U0003o`0000H0013o_olK1a/76`LK1a/76`LK0_l062H79PLV1bH7
9_lV1bH79PLV1bH7oe/8F`;o01@7B`M;1ol72`L;1`/72`L;1`_onP;o01<anS7o1e/7F`MKo`L;1`/7
2`L;00;o01472`Oo<G/aNc5k<G/aNc7oN`04o`Ak00[oNh_o1`l73`L?0_l02S4T<B@a934T<OmE0003
olOo00?o00<lool010000ol0000=0003o`000080000V0003o`0000H00_l030Lk1c/7>`Lk1c/7>`Go
0147>`Lk1c_oB`M;1d/7B`M;1`04o`0S:`L[o`M;1ol7:`L[1b/7:`L[1b_o6`LK1a/76olk<C/a>ol0
2C/2o`8k00OoBomKJe][00;o00AKJe_o17/2o`=k00?oRh/00X/2o`0?Roooof]kJg][Nf]kJg_o05P0
00?oac`01Ol40003o`0000`000?o00000P0002L00_l8000?o`LK1a/76`LK1a_o1bH700;o01<V1bH7
9POo1bH79PLV1bH7oe/800;o02AK25/8o`Oo1`/72`L;1`/72`L;ooXanS7j<OXan_mK1e_o1`/2o`0A
1`/72`L;1`/7o`]k2olaNc400_l00g/ao`08N`;o00MkRg^;Nh]k00?o00/T<B@a934T<B@ao`1J00;o
00?7ool00ol30003o`0000`000?o00000P0002T000?o00001P009ol7>`Lk1c/7>`Oo>`Lk1c/7>`Lk
1ol7B`M;1d/7B`M;ob/7:`L[1`02o`0M:ol7:`L[1b/7:`L[1b_o6`LK1a/76`LK1a_o>ol00c/2o`Pk
00goB`M;1d_oFf]KJe_o00Uk0_l7R`?o00QkJg][Nf]kJ`;oG@03o`04O?ooo`<000?o000030000ol0
00010000:P000ol0000300;o02L0oolK1a/76`Oo9PLV1bH79PLV1ol79PLV1bH79PLVo`QK25/8F`P0
0_l0=E_o2`L;1`/72`L;1`/7oc7j<OXanS7j<OXan_l72`L;1`/72`L;1`/7o`]k2g/;N`_o<G/a00?o
1g/01OmkRg^;00;o00=kRol00g/02?la934T<BCoH@06o`<000?o00002`000ol000010000:`000ol0
000200Co02H0oc/7>`Oo>`Lk1c/7>`Lk1ol7B`M;1d/7B`M;ob/7:`L[1b/7:`;o01/Kob/7:`L[1b/7
:`Oo1a/76`LK1a/76`LK1ol033/03_m;1d/7B`M;1d_oFomk1?l4N`03oh^;00>;1?l5N`;o00A[Nf_o
H`05o`@000?o00002P000ol000010000;002o`@00_l2000Toa/76ol79PLV1bH79PLVobH79PLV1bH7
9POoF`QK25/8F`QK0_l0<POjo`/72`L;1`/7oc7j<OXanS7j<OXanS7o<Ol;1`/72`L;1`/7o`]k2g/;
N`]k2g/;0_l3N`?o0W/02?mkRg^;Nh]k0ol7N`03obCo06D00_l017coool20003o`0000X000?o0000
0@0002h000?o00001P00?Olko`Lk1c/7>`Lk1c_oB`M;1d/7B`M;1ol7:`L[1b/7:`L[o`LK1a_o:`L[
1b/7o`LK1a/76`LK1a/76`L00_l00b/7o`08>`08od/7B`M;1d/2o`061d/7o`Oo0g/2o`03Non;00N;
0ol8N`03o`0006H01?l30003o`0000T000?o00000@0002l000?o00001P02o`0`9PLV1bH79PLVobH7
9PLV1bH79POoF`QK25/8F`QK2?l7nPOj1o[o2`L;1`_onS7j0_l01c7j<OXanS400ol04c7j<Ol;1`/7
2`Oo2g/;N`]k2g/00_l01P]kog]KN`;o0g/02_mkRg^;Nh]kRol:N`03o`0006L00_l00gcoo`030003
o`0000P000?o00000@00030000?o00001@04o`0^1c/7>`Lk1ol7B`M;1d/7B`Oo1b/7:`L[1b/7:`Oo
6`LK1a/76ol[1b_o6`LK1`;o00TK1a/76`Oo1b/00_l00`L[o`05>`0=od/7B`M;1d/7B`M;1`02o`08
F`MK1e_oNol4R`;o0X/00omkN`08N`03o`0006P00_l00`3oo`02o`030?l000T000?o00000@000340
0_l500;o0P02o`0g9PLV1ol79PLV1bH79PLVo`QK25/8F`QK25_onPOj1oX7nPOjo`_onS7j<OXanS7j
<OXan_oj<@02o`0DnS7jo`L;1ol;N`]k2g/;N`]k2g/4o`05Fg]KNe/00_l018]kRg/2o`03Romk00Qk
0_m_00Co00<0o`002@01o`400@0003<000?o00001P04o`0g1ol7B`M;1d/7B`M;ob/7:`L[1b/7:`Oo
6`LK1a/76`LK1a_o6`LK1a/76`LK1a/76ol[1b/7:`02o`0D1b_o>om;1d/7B`M;1d/7B`Oo1e/2o`07
1e/7F`Oo1`02o`B;00?oNg/027/2og001?l00`3o0008007o0@010000=0000ol0000500Ko03DV1bH7
9PLV1bKo25/8F`QK25/8F`So1oX7nPOj1oX7nPOo<OXanS7j<OXanS7jooXanS7j<@02o`03nS7j00;o
01Yk2g/;N`]k2g/;NomkFg]KNe]kFg_oNe]kF`;o00B;og]k0_l6N`03o`0007401?l00`3o0007007o
0@010000=@000ol0000600Ko04h7B`M;1d/7o`L[1b/7:`L[1b_o1a/76`LK1a/76`Oo1ol76`LK1a/7
6`LKob/7:`L[1b/7:`L[1ol7o`M;1d/7B`M;1ol7F`MK1e/7F`L2o`06N`Mk1g/70_l2N`;o1G/00ol0
001d00Co2001o`400@0003H00_l800;o0P02o`0d9PLV1omK25/8F`QK25/8o`Oj1oX7nPOj1oX7oe/b
FolanS7j<OXan_oj<OXanS7j<OXanP;o01D72`OoN`]k2g/;NomkFg]KNe]kFg/01?l025]kFg]Koe_o
17/2o`03Nol007L00_l00`3o0006007o0@010000>0000ol0000;00;o0387o`L[1b/7:`L[1b/7oa/7
6`LK1a/76`LKooL7m`Oo1a/76`LK1ol7:`L[1b/7:`L[1`;o00Xk1c/7o`M;1d/70ol02PMK1e/7F`Oo
1g/2o`091oooNomK1e_o00=k0omj00Co1P01o`400@0003T000?o00003002o`0J25/8F`QK25/8Fooj
1oX7nPOj1oX7n_lbFc82o`0QFolanS7j<OlanS7j<OXanS7j<Ol72`L;1`/7og/;Nomk00?o00akFg]K
NomkFg]KNe/3o`06Fg]KNe_o0g/00ol0001i00?o00<0o`001001o`400@0003X000?o00003@006_l[
1b/7:`L[1olK1a/76`LK1a/76oog1oL70_l05oL7o`LK1ol7:`L[1b/7:`L[1b_o>`Lk00;o00T7>`Oo
1ol7F`L01?l05U/7o`Mk1g/7N`Mkoe/7F`MK1e_oNomn00?o1P01o`40000k00;o3P00<_l8F`QK25/8
o`Oj1oX7nPOj1oX7oe/bFc9K<U/bFolaoc7j<OXanS7j<OXan_l;1`/70_l010/72`L2o`05Fg]KNe/0
0_l05G]Koe]kFg]KNe_oFg]KNe]kFg]Ko`1o00Co1@01o`40000m0003o`0000`00_l0D`L[1b_o1a/7
6`LK1a/76`Oo1oL7m`Og1oL7m`Oo1b/7:`L[1b/7:`L[oc/7>`Lk1c/7>`Lkoe_oF`MK1e/7Fomk1g/7
N`Mkoe/7F`MK1e/7F`Oo08<000?o00000P01o`40000n0003o`0000d001WoF`QKooX7nPOj1oX7nPOo
Fc9K<U/bFc9K00;o03LbooXanS7j<OXanS7jo`/72`L;1`/72`L;oe/7FomKNe]kFomKNe]kFg]Koe]k
Fg]KNe]kFg_o08D000Go0000o`010000?`000ol0000=000Ho`Oo6`LK1a/76`LK1a_om`Og1oL7m`Og
0ol05Q_o:`L[1b/7:`L[1ol7>`Lk1c/7>`L2o`0?F`MK1e_oF`MKog/7N`Mk00;o00`7o`MK1e/7F`MK
1on60005o`000?l00@0004000_l=00;o02oj1oX7nPOj1oX7n_lbFc9K<U/bFc9K<_lbFc;onS7j<OXa
nS7o1`/72`L;1`/72`05o`0<F`MKoe_oFg]KNe]k0ol02W]KNe]kFg]KNon80004o`00o`4000120003
o`0000X00ol06A/76`LK1a/76oog1oL7m`Og1oL7m`Oo1a/00ol022/7:`L[1ol70_l02S/7>`Lk1c/7
o`L3o`041e/7F`;o0187N`Mk1g/7o`MK1e/7F`MK1on:0003o`3o004000130003o`0000`001WonPOj
1oX7nPOoFc9K<U/bFc9K<U_oFc9K00;o00TbooXanS7jo`/00_l03@L;1`/72`Oo1e/7F`L00_l015/7
oc/2o`0?Fg]KNomkFg]KNe]kFg_o08/000?o00000Ol004@000?o000030009OlK1a/76`Oo1oL7m`Og
1oL7m`Oo1a/76`LK1a_o:`L[oc/7>`L00_l02c/7>`Oo1e/7F`MK00;o00H7oc/7>`L2o`081ol7F`MK
1e/2o`031ol008`00Ol1007o001500;o3@003?oj1oX7oe/bFc9K<P;o01IK<U/boc9K<U/bFc9K<_oj
o`/72`L;0ol03P/7o`MK1e/7F`MK1olk0_l0104k0C/2o`06Fg]KNe]k0on?00;o00170003o`0000X0
0_l02Q/76oog1oL7m`L2o`0<m`Ogoa/76`LK1a/70_l02A_o>`Lk1c/7>`02o`0>1c_oF`MK1e/7F`Oo
>`L2o`0>>`Lk1omKoe/7F`MK1on?00?o00180003o`0000T00ol05o[o<U/bFc9K<U/bFc;o<U/bFc9K
<U/b00;o029Ko`L;1`/72`L;1`_oF`MK1e/7F`MKo`4k0C/1>`7oF`MK0_l017]KNon<00Co0`0004T0
00?o00002`006?og1oL7m`Og1oL7m`Oo1a/76`LK1a/76`;o01`7o`Lk1c/7>`Lkoe/7F`MK1e/7Fol7
>`Lk1c/70_l020MK1e/7o`OoR@04o`L0001:0003o`0000X001SoFc9K<U/bFc9K<U_oFc9K<U/bFc9K
<U/2o`0=2`Oo1`/72`L;oe/7F`03o`0EF`MKo`4k0C/1>`7oF`MK1e/7F`Oo08L00ol;0000B`02o`X0
0_l060Og1oL7m`Og1ol76`LK1a/76`LK1a_o:`;o00/7o`Lk1c/7o`MK1`06o`0B1c/7>`Lk1c_o1e/7
F`MK1e_oP`04o`h0001=0003o`0000L01?l02S9K<U/bFc;o<U/2o`0:<U/bFc9K<_l;1`?o00d7o`L;
1ol7F`MK1e/700?o00lk0C/1>`4ko`MK1e/7F`L00_n000Co4P0004h000?o00002002o`0:1oL7m`Og
oa/76`Co00T76`LKob/7:`L00_l07b/7o`Oo1e/7F`MK1e/7oc/7>`Lk1c_o1e/7F`MK1e/00_ml00Co
5P0004l000?o00002@02o`0:<U/boc9K<U/bF`;o00/bFc9Ko`L;1`/72`02o`0N1oooF`MK1e/7F`Oo
>`4k0C/1>ol7F`MK1e/7F`OoN@04oaX0001@00;o2@02o`0G1oL7o`LK1a/76`LK1a/7o`L[1b/7:`L0
1?l06`Ooo`MK1e/7Fol7>`Lk1c/7oe/7F`MK1e/7o`1g00?o7P00058000?o00001`02o`0HFomK<U/b
Fc9K<U/bFol72`L;1`/72`L;0_l06RH79_l7F`MKo`4k0C/1>`7oF`MK1e/7F`OoM004ob40001C0003
o`0000H00ol02`LK1a/76`LK1a/700;o010[1b/7:`L[1b_o1c/7>`Lk0_l055_o1c/7>`Lk1omK1e/7
F`MK1e_oL004obD0001D0003o`0000L000co<U/bFc9K<U/bFc82o`0B1`/72`L;1`/7obH79PLV1bH7
0_l04C/1>`4k0C_o1e/7F`MK1e_o06d01?lY0000E@02o`L00_l081/76`LK1a/76ol[1b/7:`L[1b/7
oc/7>`Lk1c/7>om;0_l03PLk1c_o1e/7F`MK1e_oJP04obd0001G0003o`0000@01?l085/bFc9K<U_o
1`/72`L;1`/7obH79PLV1bH79_lV1bH70_l033_o1e/7F`MK1e/7ofH01?la0000F0000ol0000500;o
028K1a/76`Oo1b/7:`L[1b/7:ol7>`Lk1c/7>om;1d/7B`M;0_l02E/7F`MK1e/7o`1T00?o=@0005T0
00?o00001@02o`0S<U/bFol72`L;1`/72`L;o`LV1bH79PLV1ol79PLV1bH7o`L00_l01PMK1e/7of40
1?lh0000FP02o`D00ol08A/76ol[1b/7:`L[1b_o1c/7>`Lk1c/7o`M;1d/7B`Oo1`02o`07>ol7F`MK
o`1M00Co?00005`000?o00001002o`0<<_l;1`/72`L;1`/70ol04BH79PLV1ol79PLV1bH7o`LV00?o
00DVoomKo`1J00Co@00005d000?o00000`04o`0;1b/7:`L[1b/7oc/00ol04C/7>`Lkod/7B`M;1d_o
>`Lk00Co00<7o`00EP04od@0001N0003o`0000<00_l03@3o1`/72`L;1`_o1bH01?l04@LVobH79PLV
1bKo9PLV1bH700;o00<Vo`00DP04odP0001O00;o0`05o`0<1b/7:`L[o`Lk1c/71?l04T/7B`M;1d_o
>`Lk1c/7>`Lkoe400om<0000H@000ol0000200;o00h0o`L;1`_o1bH79PLV1`?o01479PLV1bH7o`LV
1bH79PLVo`1>00CoC`00068000?o00000`03o`0@1b/7oc/7>`Lk1c/7o`M;1`;o00e;1ol7>`Lk1c/7
>`Oo04X01?mC0000H`000ol0000200;o0140o`Oo9PLV1bH79PLVobH79P02o`0<1ol79PLV1bH79POo
A`04oeL0001T00;o1P02o`0J1c/7>`Lk1c_oB`M;1d/7Bolk1c/7>`Lk1om400CoF`0006H000?o0000
0`04o`0A9PLV1bKo9PLV1bH79_lV1bH00_l01@LV1bKo04400omO0000I`000ol0000200Go010k1c/7
o`M;1d/7B`Oo1c/70_l013/7>oln00CoHP0006P000?o00000`05o`0A1ol79PLV1bH7o`LV1bH79PL0
0_lk00CoIP0006T00_l500;o0180oom;1d/7B`Oo1c/7>`Lk1c/2ocL01?mZ0000J`000ol0000600?o
00h79PLVobH79PLV1bH7oc@01?m^0000K0000ol0000500;o00l0oom;oc/7>`Lk1c/7>ol0<004og80
001]0003o`0000T00_l02@LV1bH79PLVo`0^00?oMP0006h000?o00002@03o`06>`Lk1c_o:`04ogT0
001_00;o2@02o`070?lV1bH7o`0W00CoO@00074000?o00002P02o`031ol002<01?n10000LP000ol0
00090003o`3o02401?n50000L`000ol000080003o`0001d01?n90000M002o`P000?o00006P03ohd0
001f0003o`0000D000?o00005P04oi00001g0003o`0000@000?o00004P04oi@0001h0003o`0000<0
00?o00003P04oiP0001i00;o0`000ol0000:00CoW00007/000Co003o2@03oj00001l0003o`3o00D0
1?nS0000O@02o`030?oo00;oY`0007h00_n[0000o`0/0000o`0/0000o`0/0000o`0/0000o`0/0000
\
\>"],
  ImageRangeCache->{{{0, 298.062}, {241.375, 0}} -> {-0.0436178, 0.0477055, 
  0.00334229, 0.00334229}}]
}, Closed]],

Cell[BoxData[
    \(Clear[wavydata, wavydataplot, wavefit, wave]\)], "Input"],

Cell[TextData[{
  "See also ",
  StyleBox["NumericalMath`PolynomalFit`", "Input"],
  ", ",
  StyleBox["NumericalMath`TrigFit`", "Input"],
  " "
}], "SeeAlso"]
}, Closed]],

Cell[CellGroupData[{

Cell["Regress", "Subsubsection"],

Cell[TextData[{
  "The standard package ",
  StyleBox["Statistics`LinearRegression`", "Input",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " defines a function called ",
  StyleBox["Regress", "Input"],
  ", which allows us to extract more information during the fitting process. \
Here we load the package."
}], "Text"],

Cell[BoxData[
    \(Needs["\<Statistics`LinearRegression`\>"]\)], "Input"],

Cell[TextData[{
  StyleBox["Regress[", "Input",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  StyleBox["data",
    FontSlant->"Italic"],
  StyleBox[",", "Input"],
  " ",
  StyleBox["funs",
    FontSlant->"Italic"],
  StyleBox[",", "Input"],
  " ",
  StyleBox["vars",
    FontSlant->"Italic"],
  StyleBox["]", "Input",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " finds a least-squares fit to a list of data as a linear combination of \
the functions ",
  StyleBox["funs",
    FontSlant->"Italic"],
  ", in the variables ",
  StyleBox["vars",
    FontSlant->"Italic"],
  ". The data can have the form ",
  StyleBox["{{", "Input"],
  Cell[BoxData[
      \(TraditionalForm\`x\_1\)]],
  StyleBox[",", "Input"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`y\_1\)]],
  StyleBox[",", "Input"],
  " \[Ellipsis]",
  StyleBox[",", "Input"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`f\_1\)]],
  StyleBox["},", "Input"],
  " ",
  StyleBox["{", "Input"],
  Cell[BoxData[
      \(TraditionalForm\`x\_2\)]],
  StyleBox[",", "Input"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`y\_2\)]],
  StyleBox[",", "Input"],
  " \[Ellipsis]",
  StyleBox[",", "Input"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`f\_2\)]],
  StyleBox["},", "Input"],
  " \[Ellipsis]",
  StyleBox["}", "Input"],
  ", where the number of coordinates ",
  StyleBox["x",
    FontSlant->"Italic"],
  ", ",
  StyleBox["y",
    FontSlant->"Italic"],
  ", \[Ellipsis] is equal to the number of variables in the list ",
  StyleBox["vars",
    FontSlant->"Italic"],
  ". The data can also be of the form ",
  StyleBox["{", "Input"],
  Cell[BoxData[
      \(TraditionalForm\`f\_1\)]],
  StyleBox[",", "Input"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`f\_2\)]],
  StyleBox[",", "Input"],
  " \[Ellipsis]",
  StyleBox["}", "Input"],
  ", with a single coordinate assumed to take values 1, 2, \[Ellipsis]. The \
argument ",
  StyleBox["funs",
    FontSlant->"Italic"],
  " can be any list of functions that depend only on the objects ",
  StyleBox["vars",
    FontSlant->"Italic"],
  "."
}], "Text"],

Cell["Here are some random data points.", "Text"],

Cell[BoxData[
    \(\(cosdata\  = \ 
      Table[{x, Cos[x] + Random[Real, {\(-0.1\), 0.1}]}, {x, \(-2.0\), 2.0, 
          0.1}]; \)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(ListPlot[cosdata, PlotStyle -> {PointSize[0.015], GrayLevel[0.5]}]; 
    \)\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.238095 0.198342 0.375421 [
[.02381 .18584 -6 -9 ]
[.02381 .18584 6 0 ]
[.2619 .18584 -6 -9 ]
[.2619 .18584 6 0 ]
[.7381 .18584 -3 -9 ]
[.7381 .18584 3 0 ]
[.97619 .18584 -3 -9 ]
[.97619 .18584 3 0 ]
[.4875 .01063 -24 -4.5 ]
[.4875 .01063 0 4.5 ]
[.4875 .10449 -30 -4.5 ]
[.4875 .10449 0 4.5 ]
[.4875 .2922 -24 -4.5 ]
[.4875 .2922 0 4.5 ]
[.4875 .38605 -18 -4.5 ]
[.4875 .38605 0 4.5 ]
[.4875 .47991 -24 -4.5 ]
[.4875 .47991 0 4.5 ]
[.4875 .57376 -6 -4.5 ]
[.4875 .57376 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .19834 m
.02381 .20459 L
s
[(-2)] .02381 .18584 0 1 Mshowa
.2619 .19834 m
.2619 .20459 L
s
[(-1)] .2619 .18584 0 1 Mshowa
.7381 .19834 m
.7381 .20459 L
s
[(1)] .7381 .18584 0 1 Mshowa
.97619 .19834 m
.97619 .20459 L
s
[(2)] .97619 .18584 0 1 Mshowa
.125 Mabswid
.07143 .19834 m
.07143 .20209 L
s
.11905 .19834 m
.11905 .20209 L
s
.16667 .19834 m
.16667 .20209 L
s
.21429 .19834 m
.21429 .20209 L
s
.30952 .19834 m
.30952 .20209 L
s
.35714 .19834 m
.35714 .20209 L
s
.40476 .19834 m
.40476 .20209 L
s
.45238 .19834 m
.45238 .20209 L
s
.54762 .19834 m
.54762 .20209 L
s
.59524 .19834 m
.59524 .20209 L
s
.64286 .19834 m
.64286 .20209 L
s
.69048 .19834 m
.69048 .20209 L
s
.78571 .19834 m
.78571 .20209 L
s
.83333 .19834 m
.83333 .20209 L
s
.88095 .19834 m
.88095 .20209 L
s
.92857 .19834 m
.92857 .20209 L
s
.25 Mabswid
0 .19834 m
1 .19834 L
s
.5 .01063 m
.50625 .01063 L
s
[(-0.5)] .4875 .01063 1 0 Mshowa
.5 .10449 m
.50625 .10449 L
s
[(-0.25)] .4875 .10449 1 0 Mshowa
.5 .2922 m
.50625 .2922 L
s
[(0.25)] .4875 .2922 1 0 Mshowa
.5 .38605 m
.50625 .38605 L
s
[(0.5)] .4875 .38605 1 0 Mshowa
.5 .47991 m
.50625 .47991 L
s
[(0.75)] .4875 .47991 1 0 Mshowa
.5 .57376 m
.50625 .57376 L
s
[(1)] .4875 .57376 1 0 Mshowa
.125 Mabswid
.5 .0294 m
.50375 .0294 L
s
.5 .04817 m
.50375 .04817 L
s
.5 .06694 m
.50375 .06694 L
s
.5 .08572 m
.50375 .08572 L
s
.5 .12326 m
.50375 .12326 L
s
.5 .14203 m
.50375 .14203 L
s
.5 .1608 m
.50375 .1608 L
s
.5 .17957 m
.50375 .17957 L
s
.5 .21711 m
.50375 .21711 L
s
.5 .23588 m
.50375 .23588 L
s
.5 .25466 m
.50375 .25466 L
s
.5 .27343 m
.50375 .27343 L
s
.5 .31097 m
.50375 .31097 L
s
.5 .32974 m
.50375 .32974 L
s
.5 .34851 m
.50375 .34851 L
s
.5 .36728 m
.50375 .36728 L
s
.5 .40482 m
.50375 .40482 L
s
.5 .4236 m
.50375 .4236 L
s
.5 .44237 m
.50375 .44237 L
s
.5 .46114 m
.50375 .46114 L
s
.5 .49868 m
.50375 .49868 L
s
.5 .51745 m
.50375 .51745 L
s
.5 .53622 m
.50375 .53622 L
s
.5 .55499 m
.50375 .55499 L
s
.5 .59253 m
.50375 .59253 L
s
.5 .61131 m
.50375 .61131 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 g
.015 w
.02381 .07354 Mdot
.04762 .08082 Mdot
.07143 .10912 Mdot
.09524 .18171 Mdot
.11905 .17114 Mdot
.14286 .19694 Mdot
.16667 .25923 Mdot
.19048 .29495 Mdot
.21429 .36854 Mdot
.2381 .37694 Mdot
.2619 .43592 Mdot
.28571 .45454 Mdot
.30952 .47392 Mdot
.33333 .48796 Mdot
.35714 .47632 Mdot
.38095 .54386 Mdot
.40476 .51703 Mdot
.42857 .56856 Mdot
.45238 .57031 Mdot
.47619 .57537 Mdot
.5 .5451 Mdot
.52381 .5886 Mdot
.54762 .60332 Mdot
.57143 .53488 Mdot
.59524 .52158 Mdot
.61905 .50313 Mdot
.64286 .51161 Mdot
.66667 .46916 Mdot
.69048 .49113 Mdot
.71429 .39745 Mdot
.7381 .36999 Mdot
.7619 .39367 Mdot
.78571 .36899 Mdot
.80952 .29374 Mdot
.83333 .23376 Mdot
.85714 .18957 Mdot
.88095 .17043 Mdot
.90476 .18001 Mdot
.92857 .07899 Mdot
.95238 .06314 Mdot
.97619 .01472 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{299.062, 184.75},
  ImageMargins->{{48, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004[0000^0P10`4000010?ooooooc?ooZ_ooI_oo
<ooo0?o<ooo<c?o<VC/k>gYjN[Vi^OShn03ooeGooj[ooonI<onI0?mVoomVc?mVVOmVI_mV<omV0?lc
oclo?ginO[fm_Oclo5D00:X00?l00?l0VOl0I_l0<ol00<coolcoc<coVLcoIP<30d92@X61PL30`000
EED0EJX0EOl0ELbIolbIc<bIVLbII/bI<lbI0<aVolaVc0L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0Z/`c
<l`c0<`0ol`0c<`0VL`0I/`0<l`000/;2dY:BXV9RLS8b000oeD0ojX0ool0oiW<VIW<IYW<<iW<09VI
oiVIc9VIVIVIIPl?3di>CXf=SLc<c01E05EE0:YE0?mE09TcoiTcc9TcVITcIYTc<iTc09T0oiT0c1<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEEFKo<fKo06K<ofK<c6K<VFK<IVK<<fK<01LG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZVIVVFIVIVIV<fIV06HcofHcc6HcVFHcIQ/K6eYJFYVIVMSHf01EoeEEojYEoomEoc?o
oc?oc3?oVC?oIS?o<c?o03?<oc?<c1lO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ03>I<c>I03=Voc=Vc3=V
VC=VIS=V<c=V02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZEC<0VC<0IS<0<c<0003oo`3oc03oV@3oIRLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2Io`2Ic02IV@2IIP2I<`2I001Vo`1Vc2/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`0c<`0c0000o`00c000V@00IP00<nh002l_;fi^KZf][Nc/k03o05Go0:[o0?oo0140
003^003M002k002Z0028001g001E03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@00M`00E@00A0008P00
4Nk^k]gMgK^k^cLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?l0;00009D000?o0000T`0008400_l400;o
0`03o`H000?o0000T`00080000Co003o0`02o`H000?o00000`000ol0002C0000NP05o`050?l00?l0
2`000ol0000300;oR@026PT000200004o`00o`P00ol60003o`0008L011X80000P0001?l00?l80003
o`0000H000?o0000Q`046PP0002100;o2@04o`D000?o0000R0026PT0002E0003o`0009<0002E0003
o`0009<0002E00;oU00009D000?o0000T`0009D000?o0000T`0009D000?o0000T`0009D000?o0000
T`0009D00_nD0000U@000ol0002C0000U@000ol0002C0000U@000ol00021008J400009D000?o0000
P0046Pl0002E0003o`00080011X?0000U@02oh800QX@00001`026X`000?o0000T`0000H011Z;0003
o`0007X00QXG00001P046P@00QZ50003o`0007T011XF00001`026P@011Z40003o`0007T011XF0000
3@046X@00_mk008J5`0000h00QZ50003o`0009<0002E0003o`0009<0002E0003o`0009<0001k00;o
1002o`<01?l200?o1P000ol0002C0000NP001?l00?l300;o10000ol000050003o`0000<000?o0000
T`0001D00QYM00Go00D0o`00o`0:0003o`0000@000?o00000`02oi@0000D00@JHP001?l00?l;0003
o`0000?o1P000ol0002C000050046V8000Co003o20001?l00?l20003o`0000H000?o0000T`0001D0
0QYT00;o2P02o`<01?l50003o`0009<0002E0003o`0009<0002E00;oU00009D000?o0000T`0009D0
00?o0000T`0009D000?o0000T`0009D000?o0000T`0009D000?o0000T`0009D00_nD0000U@000ol0
002C0000U@000ol0002C0000U@000ol0002C0000U@000ol0002C0000U@000ol0002C00002@04od80
0om300;o@P03od<01?l800002P000ol0000F008J:`000ol000120003o`00048000?o00009`026QX0
00?o0000200000<01Ol30003o`0001@011XS00Go0P000ol000120003o`00048000?o00009P046QX0
00?o00001`0000`000?o00004`046RX000?o0000@P000ol000120003o`0002H011XK0003o`0000H0
00090004o`00o`l00QX5008J:`000ol000120003o`00048000?o00009`026PD00QXB0004o`00o`P0
000:00;o3`046S000_m400;o@P02obl011XB00;o2@0001/011Yf0003o`00078011XM000070026WL0
00?o0000I@026P`00QXN0000U@000ol0001T00@J:`0002X00QYY0003o`0006@011X[0000:@046VP0
00?o0000I@026R`000000`3oo`0Vo`@Jo?l2000020000ol0000;0003o`0000/000?o00000`026PH0
00?o00002`000ol0000;0003o`0000/000?o00002`000ol0000;0003o`0000/000?o000030000ol0
000;0003o`0000/000?o00002`000ol0000;0003o`0000/000?o00002`000ol0000;0003o`0000/0
00?o00002`000ol0000;0003o`0000L0002E0003o`0009<0002E0003o`0009<0002E0003o`0009<0
002E00;oU00009D000?o0000T`0009D000?o0000T`0009D000?o0000T`0009D000?o0000GP026S<0
002E0003o`0005d011Xb0000U@02oeh011Xb0000U@000ol0001N008J<`0009D000?o0000T`0009D0
00?o0000T`0009D000?o0000T`0003400QYR00;oU000030011YQ0003o`0009<0000`00@JH@000ol0
002C0000<@026V8000?o0000T`0009D000?o0000T`0009D000?o0000T`0009D00_nD0000U@000ol0
002C0000U@000ol0002C0000N`02o`@00_l300Co0P03o`H000?o0000T`0007X000Co003o0`02o`@0
00?o00001@000ol000030003o`0005L00QXj0000>@026Sl000Co003o2P000ol000040003o`0000<0
0_mG00@J>@0003P011Xn0004o`00o`/000?o00000ol60003o`0005H011Xi0000>0046Sh000Co003o
20001?l00?l20003o`0000H000?o0000E`026SX0000i008J@002o`X00_l300Co1@000ol0002C0000
U@000ol0002C0000U@000ol0002C0000U@02oi@0002E0003o`0009<0002E0003o`0009<0002E0003
o`0009<0002E0003o`0009<0002E00;oU00009D000?o0000T`0009D000?o0000T`0009D000?o0000
T`0009D000?o0000T`0009D000?o0000T`0009D00_nD0000U@000ol0002C0000U@000ol0002C0000
U@000ol0002C0000U@000ol0002C0000@0026U<00_m3008J30026T40000o00@JDP000ol0001100@J
2P046T00000o00@J10026T`000?o0000@@046PX011Y00000@0026P@011Y;0003o`0004800QX<008J
@@0004H011Xg00;o1002o`<00ol60003o`0009<00017008J=`001?l00?l300;o1P000ol000030003
o`0009<000200004o`00o`/000?o00000`02oi@000200004o`00o`P00ol60003o`0004T00QY80000
P0001?l00?l80003o`0000H000?o0000>`026P/011Y70000P@02o`T01?l50003o`0003X011X:00@J
A`0009D000?o0000>P046P/00QY80000U@000ol0000k008JEP0009D00_nD0000U@000ol0002C0000
U@000ol0002C0000U@000ol0002C0000U@000ol0002C0000U@02oi@0002E0003o`0009<0001>008J
A@000ol0002C0000C@046T@000?o0000T`0004d011Y40003o`0009<0001>008JA@000ol0002C0000
U@02oi@0002E0003o`0009<0001E008J?P000ol0002C0000E0046Sd000?o0000T`0005@011Xm0003
o`0009<0001E008J?P02oi@0002E0003o`0002d00QYT0000U@000ol0000/00@JH`0005`00QX<008J
:@000ol0000/00@JH`0005/011X:00@J3P02o`@00_l40003o`0000800ol60003o`0002d00QYT0000
F`046PX011X=0004o`00o`<00_l40003o`0000D000?o00000`000ol0002C0000G0026P`00QX>0004
o`00o`X000?o000010000ol0000300;oU00006<00QXE0004o`00o`X000Co00000ol60003o`0009<0
001R00@J50001?l00?l;0004o`00o`P000?o0000=0026Ud0001R00@J5@02o`T01?l200Co1@000ol0
000c00@JG00006<00QX`0003o`0003<011YL0000U@02ob000QXC008JG@0009D000?o00007P046W40
002E0003o`0001h011Ya0000U@000ol0000O008J1@026V/0001h008J6`000ol0000U00@JJP0007L0
11XJ0003o`0002D011YZ0000M`046QX00_lI008J30026V/0001h008J6`000ol0000G00@JN00009D0
00?o00005`046WP0002E0003o`0001P00QYi0000U@000ol0000A008JP00009D00_lA00@JO`000740
0QXR0003o`00010011Yo0000L0046R000QXC008JP000070011XO00@JU00007400QXP00@JU00009@0
0QZE0000U@02oi@0002E0003o`0009<0002E0003o`0009<0001o008J1@026P@00ol60003o`0009<0
001n00@J0`046P@000?o00001@000ol0002C0000OP046P<011X4008J1P02oi@0001o008J1@026P@0
11X50003o`0009<0002<00@J1@000ol0002C0000S0000olJ6P060003o`0000<00QZ>0000U@000ol0
000200@JS@0009D000?o00000P046Xd0002E00;o10026Xh0002E0003o`0009<0002E0003o`0000X0
0QZ70000U@000ol0000900@JQP0009D000?o00002@046XH0002E0003o`0000X00QZ70000U@02oi@0
002E0003o`0009<00000\
\>"],
  ImageRangeCache->{{{0, 298.062}, {183.75, 0}} -> {-2.12103, -0.54063, 
  0.0142321, 0.00902613}}]
}, Closed]],

Cell[TextData[{
  StyleBox["Fit", "Input"],
  " returns only the best-fit function."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Fit[cosdata, {1, x, x\^2, x\^3}, x]\)], "Input"],

Cell[BoxData[
    \(\(0.945547411448722741`\[InvisibleSpace]\) - 
      0.0104377940774267052`\ x - 0.368760589339983546`\ x\^2 - 
      0.00239897254026512385`\ x\^3\)], "Output"]
}, Closed]],

Cell[TextData[{
  StyleBox["Regress", "Input"],
  ", defined in the package ",
  StyleBox["Statistics`LinearRegression`", "Input"],
  ", by default returns various test statistics, including the coefficient of \
determination (",
  Cell[BoxData[
      \(TraditionalForm\`R\^2\)]],
  " value), adjusted coefficient of variation (",
  Cell[BoxData[
      \(TraditionalForm\`R\&_\^2\)]],
  " value), and an ANOVA table."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Regress[cosdata, {1, x, x\^2, x\^3}, x]\)], "Input"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{"ParameterTable", "\[Rule]", 
          TagBox[GridBox[{
                {\(""\), \("Estimate"\), \("SE"\), \("TStat"\), \("PValue"\)},
                
               
                 {"1", "0.945547411448722563`", "0.0181958313940204661`", 
                  "51.9650567744571212`", "0.`"},
               
                 {"x", \(-0.0104377940774267741`\), "0.0256713273751234982`", 
                  \(-0.406593470018281877`\), "0.68664897729520451`"},
               
                 {\(x\^2\), \(-0.368760589339983457`\), 
                  "0.00969125504808424054`", \(-38.0508600289990095`\), 
                  "0.`"},
               
                 {\(x\^3\), \(-0.00239897254026511674`\), 
                  "0.00934769749962743823`", \(-0.256637802021378025`\), 
                  "0.798880089272459148`"}
                },
              RowSpacings->1,
              ColumnSpacings->3,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}],
            (TableForm[ #, TableHeadings -> {{1, x, 
              Power[ x, 2], 
              Power[ x, 3]}, {"Estimate", "SE", "TStat", "PValue"}}]&)]}], 
        ",", \(RSquared \[Rule] 0.97512638171776782`\), ",", 
        \(AdjustedRSquared \[Rule] 0.973109601857046335`\), ",", 
        \(EstimatedVariance \[Rule] 0.00602717417955646261`\), ",", 
        RowBox[{"ANOVATable", "\[Rule]", 
          InterpretationBox[GridBox[{
               
                 {\(""\), \("DF"\), \("SumOfSq"\), \("MeanSq"\), \("FRatio"\),
                   \("PValue"\)},
               
                 {\("Model"\), "3", "8.74253556001545995`", 
                  "2.91417852000515331`", "483.506604121337435`", "0.`"},
               
                 {\("Error"\), "37", "0.22300544464358909`", 
                  "0.00602717417955646261`", \(""\), \(""\)},
               
                 {\("Total"\), "40", "8.96554100465904824`", \(""\), \(""\), 
                  \(""\)}
                },
              RowSpacings->1,
              ColumnSpacings->3,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}],
            TableForm[
             {{3, 8.74253556001546, 2.9141785200051533, 483.50660412133743, 
              0.0}, {37, 0.2230054446435891, 0.0060271741795564623}, {40, 
              8.9655410046590482}}, TableHeadings -> {{"Model", "Error", 
              "Total"}, {"DF", "SumOfSq", "MeanSq", "FRatio", 
              "PValue"}}]]}]}], "}"}]], "Output"]
}, Closed]],

Cell[TextData[{
  "In the above parameter table, we see that the ",
  StyleBox["p",
    FontSlant->"Italic"],
  "-values for the coefficients of ",
  StyleBox["x",
    FontSlant->"Italic"],
  " and ",
  Cell[BoxData[
      \(TraditionalForm\`x\^3\)]],
  " are large, which suggests that the \[OpenCurlyDoubleQuote]true\
\[CloseCurlyDoubleQuote] values of the parameters are zero. Here is a report \
based on a model containing only a constant and quadratic term."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Regress[cosdata, {1, x\^2}, x]\)], "Input"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{"ParameterTable", "\[Rule]", 
          TagBox[GridBox[{
                {\(""\), \("Estimate"\), \("SE"\), \("TStat"\), \("PValue"\)},
                
               
                 {"1", "0.945547411448722563`", "0.0183472678483396869`", 
                  "51.5361425616451462`", "0.`"},
               
                 {\(x\^2\), \(-0.368760589339983546`\), 
                  "0.00977191139571710465`", \(-37.7367921593728627`\), "0.`"}
                  
                },
              RowSpacings->1,
              ColumnSpacings->3,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}],
            (TableForm[ #, TableHeadings -> {{1, 
              Power[ x, 2]}, {"Estimate", "SE", "TStat", "PValue"}}]&)]}], 
        ",", \(RSquared \[Rule] 0.97334364013981105`\), ",", 
        \(AdjustedRSquared \[Rule] 0.97266014373313947`\), ",", 
        \(EstimatedVariance \[Rule] 0.00612791506055055101`\), ",", 
        RowBox[{"ANOVATable", "\[Rule]", 
          InterpretationBox[GridBox[{
               
                 {\(""\), \("DF"\), \("SumOfSq"\), \("MeanSq"\), \("FRatio"\),
                   \("PValue"\)},
               
                 {\("Model"\), "1", "8.72655231729757652`", 
                  "8.72655231729757652`", "1424.06548247970583`", "0.`"},
               
                 {\("Error"\), "39", "0.238988687361471496`", 
                  "0.00612791506055055101`", \(""\), \(""\)},
               
                 {\("Total"\), "40", "8.96554100465904824`", \(""\), \(""\), 
                  \(""\)}
                },
              RowSpacings->1,
              ColumnSpacings->3,
              RowAlignments->Baseline,
              ColumnAlignments->{Left}],
            TableForm[
             {{1, 8.7265523172975765, 8.7265523172975765, 1424.0654824797059, 
              0.0}, {39, 0.2389886873614715, 0.006127915060550551}, {40, 
              8.9655410046590482}}, TableHeadings -> {{"Model", "Error", 
              "Total"}, {"DF", "SumOfSq", "MeanSq", "FRatio", 
              "PValue"}}]]}]}], "}"}]], "Output"]
}, Closed]],

Cell[TextData[{
  "We can compute different statistics for a least-squares fit by changing \
the value of the option ",
  StyleBox["RegressionReport", "Input"],
  ". A list of all possible values for ",
  StyleBox["RegressionReport", "Input"],
  " is returned when we enter the following."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(RegressionReportValues[Regress]\)], "Input"],

Cell[BoxData[
    \({AdjustedRSquared, ANOVATable, BestFit, BestFitParameters, 
      BestFitParametersDelta, CatcherMatrix, CoefficientOfVariation, CookD, 
      CorrelationMatrix, CovarianceMatrix, CovarianceMatrixDetRatio, 
      DurbinWatsonD, EigenstructureTable, EstimatedVariance, FitResiduals, 
      HatDiagonal, JackknifedVariance, MeanPredictionCITable, 
      ParameterCITable, ParameterConfidenceRegion, ParameterTable, 
      PartialSumOfSquares, PredictedResponse, PredictedResponseDelta, 
      RSquared, SequentialSumOfSquares, SinglePredictionCITable, 
      StandardizedResiduals, StudentizedResiduals, SummaryReport, 
      VarianceInflation}\)], "Output"]
}, Closed]],

Cell["\<\
Here we create a report that returns only the best-fit function, \
the predicted values, and the residual values.\
\>", "Text"],

Cell[BoxData[
    \(\(report = 
      Regress[cosdata, {1, x\^2}, x, 
        RegressionReport -> {BestFit, PredictedResponse\ , FitResiduals}]; 
    \)\)], "Input"],

Cell["\<\
Here we extract the best-fit function, using a replacement \
rule.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(BestFit /. report\)], "Input"],

Cell[BoxData[
    \(\(0.945547411448722563`\[InvisibleSpace]\) - 
      0.368760589339983546`\ x\^2\)], "Output"]
}, Closed]],

Cell["\<\
Here are abbreviated versions of the lists of predicted responses \
and fit residuals.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Short[PredictedResponse /. report, 2]\)], "Input"],

Cell[BoxData[
    TagBox[
      \({\(-0.529494945911211711`\), \(-0.385678316068618087`\), 
        \[LeftSkeleton]38\[RightSkeleton], \(-0.529494945911211711`\)}\),
      (Short[ #, 2]&)]], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Short[FitResiduals /. report, 3]\)], "Input"],

Cell[BoxData[
    TagBox[
      \({0.197070313058428148`, 0.0726289009961523213`, 
        0.0115774311485773995`, \[LeftSkeleton]36\[RightSkeleton], 
        0.0255327426922797862`, 0.0403715680363021522`}\),
      (Short[ #, 3]&)]], "Output"]
}, Closed]],

Cell["Here is a plot of the residuals.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(residualplot = 
      ListPlot[FitResiduals /. report, FrameTicks \[Rule] None, 
        Frame \[Rule] True, Ticks \[Rule] None, PlotStyle \[Rule] Hue[0], 
        TextStyle \[Rule] {FontSize \[Rule] 9}, 
        PlotLabel \[Rule] "\<residuals\>"]; \)\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.0232288 0.258374 1.75037 [
[ 0 0 -0.125 0 ]
[ 0 0 -0.125 0 ]
[ 0 .61803 .125 0 ]
[ 1 0 .125 0 ]
[.5 .63053 -24.5 0 ]
[.5 .63053 24.5 15 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
0 0 m
1 0 L
s
0 0 m
0 .61803 L
s
0 .61803 m
1 .61803 L
s
1 0 m
1 .61803 L
s
0 .25837 m
1 .25837 L
s
gsave
.5 .63053 -85.5 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 15.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 9.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 15.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 9.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(residuals) show
108.000000 15.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 9.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
1 0 0 r
.008 w
.04704 .60332 Mdot
.07027 .3855 Mdot
.0935 .27864 Mdot
.11672 .39118 Mdot
.13995 .12889 Mdot
.16318 .04908 Mdot
.18641 .1523 Mdot
.20964 .14457 Mdot
.23287 .32632 Mdot
.2561 .21703 Mdot
.27933 .35647 Mdot
.30256 .32063 Mdot
.32578 .30128 Mdot
.34901 .26989 Mdot
.37224 .13172 Mdot
.39547 .37561 Mdot
.4187 .19245 Mdot
.44193 .3875 Mdot
.46516 .36339 Mdot
.48839 .36764 Mdot
.51161 .22005 Mdot
.53484 .42931 Mdot
.55807 .5173 Mdot
.5813 .23047 Mdot
.60453 .21365 Mdot
.62776 .18574 Mdot
.65099 .29628 Mdot
.67422 .18226 Mdot
.69744 .38152 Mdot
.72067 .05446 Mdot
.7439 .04907 Mdot
.76713 .29505 Mdot
.79036 .32842 Mdot
.81359 .13895 Mdot
.83682 .03357 Mdot
.86005 .01472 Mdot
.88328 .12557 Mdot
.9065 .38326 Mdot
.92973 .13815 Mdot
.95296 .30307 Mdot
.97619 .32904 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{299.062, 184.75},
  ImageMargins->{{48, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004[0000^0P10`4000010?ooooooc?ooZ_ooI_oo
<ooo0?o<ooo<c?o<VC/k>gYjN[Vi^OShn03ooeGooj[ooonI<onI0?mVoomVc?mVVOmVI_mV<omV0?lc
oclo?ginO[fm_Oclo5D00:X00?l00?l0VOl0I_l0<ol00<coolcoc<coVLcoIP<30d92@X61PL30`000
EED0EJX0EOl0ELbIolbIc<bIVLbII/bI<lbI0<aVolaVc0L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0Z/`c
<l`c0<`0ol`0c<`0VL`0I/`0<l`000/;2dY:BXV9RLS8b000oeD0ojX0ool0oiW<VIW<IYW<<iW<09VI
oiVIc9VIVIVIIPl?3di>CXf=SLc<c01E05EE0:YE0?mE09TcoiTcc9TcVITcIYTc<iTc09T0oiT0c1<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEEFKo<fKo06K<ofK<c6K<VFK<IVK<<fK<01LG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZVIVVFIVIVIV<fIV06HcofHcc6HcVFHcIQ/K6eYJFYVIVMSHf01EoeEEojYEoomEoc?o
oc?oc3?oVC?oIS?o<c?o03?<oc?<c1lO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ03>I<c>I03=Voc=Vc3=V
VC=VIS=V<c=V02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZEC<0VC<0IS<0<c<0003oo`3oc03oV@3oIRLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2Io`2Ic02IV@2IIP2I<`2I001Vo`1Vc2/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`0c<`0c0000o`00c000V@00IP00<nh002l_;fi^KZf][Nc/k03o05Go0:[o0?oo0140
003^003M002k002Z0028001g001E03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@00M`00E@00A0008P00
4Nk^k]gMgK^k^cLg=gIfM[Fe]OCdm03oZUGoZZ[oZP0000l0ool=oa00000?0003o`000?l02@000ol0
000>00003`000ol0003o00T000?o00003P0000l000?o0000hP028b@000?o00003P0000l000?o0000
hP028b@000?o00003P0000l000?o0000o`090003o`0000h0000?0003o`000?l02@000ol0000>0000
3`000ol0003o00T000?o00003P0000l000?o0000g0028bX000?o00003P0000l000?o0000g0028bX0
00?o00003P0000l000?o0000o`090003o`0000h0000?0003o`000?l02@000ol0000>00003`000ol0
000X008SV@028d<000?o00003P0000l000?o0000:0028iT00R=30003o`0000h0000?0003o`000;d0
0R=90003o`0000h0000?0003o`000;d00R=90003o`0000h0000?0003o`000?l02@000ol0000>0000
3`000ol0003o00T000?o00003P0000l000?o0000o`090003o`0000h0000?0003o`000?l02@000ol0
000>00003`000ol0003o00T000?o00003P0000l000?o0000o`090003o`0000h0000?0003o`000?l0
2@000ol0000>00003`000ol0003o00T000?o00003P0000l000?o0000o`090003o`0000h0000?0003
o`000?l02@000ol0000>00003`000ol0003o00T000?o00003P0000l000?o0000o`090003o`0000h0
000?0003o`000?l02@000ol0000>00003`000ol0003o00T000?o00003P0000l000?o0000o`090003
o`0000h0000?0003o`000?l02@000ol0000>00003`000ol0003o00T000?o00003P0000l000?o0000
j@028ad000?o00003P0000l000?o00008P028lD00R<M0003o`0000h0000?0003o`0002800R<l008S
YP000ol0000>00003`000ol0001P008SM0028ad00R<A0003o`0000h0000?0003o`000=H00R<M008S
4@000ol0000>00003`000ol0000d008SdP000ol0000>00003`000ol0000d008SdP000ol0000>0000
3`000ol0000^008Sf0000ol0000>00003`000ol0000^008Sf0000ol0000>00003`000ol0003o00T0
00?o00003P0000l000?o0000o`090003o`0000h0000?0003o`000?l02@000ol0000>00003`000ol0
003o00T000?o00003P0000l000?o0000o`090003o`0000h0000?0003o`000?l02@000ol0000>0000
3`000ol0002a008SE@000ol0000>00003`000ol0002T008S2`028eD000?o00003P0000l000?o0000
Y0028f8000?o00003P0000l000?o0000K0028iX000?o00003P0000l000?o0000K0028iX000?o0000
3P0000l000?o0000o`090003o`0000h0000?0003o`000?l02@000ol0000>00003`000ol0003o00T0
00?o00003P0000l000?o0000WP028fP000?o00003P0000l000?o0000@@028e/00R=X0003o`0000h0
000?0003o`0004400R=2008SP@000ol0000>00003`000ol00025008SP@000ol0000>00003`000ol0
003o00T000?o00003P0000l000?o0000V0028fh000?o00003P0000l000?o0000V0028fh000?o0000
3P0000l000?o0000o`090003o`0000h0000?0003o`000?l02@000ol0000>00003`000ol0003o00T0
00?o00003P0000l000?o0000o`090003o`0000h0000?0003o`000?l02@000ol0000>00003`000ol0
003o00T000?o00003P0000l0ool=oa00000?0003o`000?l02@000ol0000>00003`000ol0003o00T0
00?o00003P0000l000?o0000FP028j`000?o00003P0000l000?o0000FP028j`000?o00003P0000l0
00?o00005@028o4000?o00003P0000l000?o00005@028o4000?o00003P0000l000?o0000o`090003
o`0000h0000?0003o`000?l02@000ol0000>00003`000ol00039008S?@000ol0000>00003`000ol0
002Z008S7@028cd000?o00003P0000l000?o0000D`028eD00R=?008S2`000ol0000>00003`000ol0
001C008SYP028`/000?o00003P0000l000?o0000o`090003o`0000h0000?0003o`000?l02@000ol0
000>00003`000ol0003o00T000?o00003P0000l000?o0000C@028kT000?o00003P0000l000?o0000
C@028kT000?o00003P0000l000?o0000>P028i@00R<_008S1@000ol0000>00003`000ol0000j008S
U0028bl00R<50003o`0000h0000?0003o`000?l02@000ol0000>00003`000ol0003o00T000?o0000
3P0000l000?o0000o`090003o`0000h0000?0003o`000?l02@000ol0000>00003`000ol0003o00T0
00?o00003P0000l000?o0000o`090003o`0000h0000?0003o`0004L00R>o0003o`0000h0000?0003
o`0004L00R>o0003o`0000h0000?0003o`0007T00R>=0003o`0000h0000?0003o`0007T00R<4008S
Q`000ol0000>00003`000ol0001o008SQ`000ol0000>00003`000ol0001V008SX0000ol0000>0000
3`000ol0001V008SC`028dl000?o00003P0000l000?o00003`028jH00R<f008S5`000ol0000>0000
3`000ol0000?008SH@028g/00R<G0003o`0000h0000?0003o`0001/00R=E008SU0000ol0000>0000
3`000ol0000K008Sj`000ol0000>00003`000ol0003o00T000?o00003P0000l000?o0000o`090003
o`0000h0000?0003o`000?l02@000ol0000>00003`000ol0003o00T000?o00003P0000l000?o0000
o`090003o`0000h0000?0003o`000?l02@000ol0000>00003`000ol0003o00T000?o00003P0000l0
00?o0000o`090003o`0000h0000?0003o`0008/00R=k0003o`0000h0000?0003o`0008/00R=k0003
o`0000h0000?0003o`000?l02@000ol0000>00003`000ol0003o00T000?o00003P0000l000?o0000
o`090003o`0000h0000?0003o`000?l02@000ol0000>00003`000ol0003o00T000?o00003P0000l0
00?o0000o`090003o`0000h0000?0003o`000?l02@000ol0000>00003`000ol0003o00T000?o0000
3P0000l000?o0000o`090003o`0000h0000?0003o`000?l02@000ol0000>00003`000ol0003o00T0
00?o00003P0000l000?o0000o`090003o`0000h0000?0003o`000?l02@000ol0000>00003`000ol0
003o00T000?o00003P0000l000?o0000o`090003o`0000h0000?0003o`000?l02@000ol0000>0000
3`000ol0003o00T000?o00003P0000l000?o0000o`090003o`0000h0000?0003o`000?l02@000ol0
000>00003`000ol0003o00T000?o00003P0000l000?o0000o`090003o`0000h0000?0003o`000?l0
2@000ol0000>00003`000ol0002B008SM0000ol0000>00003`000ol0002B008SM0000ol0000>0000
3`000ol0003o00T000?o00003P0000l000?o0000o`090003o`0000h0000?0003o`000?l02@000ol0
000>00003`000ol0003o00T000?o00003P0000l000?o0000o`090003o`0000h0000?0003o`000?l0
2@000ol0000>00003`000ol0003o00T000?o00003P0000l000?o0000o`090003o`0000h0000?0003
o`000?l02@000ol0000>00003`000ol0003o00T000?o00003P0000l000?o0000o`090003o`0000h0
000?0003o`000?l02@000ol0000>00003`000ol0003o00T000?o00003P0000l000?o0000o`090003
o`0000h0000?0003o`000?l02@000ol0000>00003`000ol0003o00T000?o00003P0000l000?o0000
o`090003o`0000h0000?0003o`000?l02@000ol0000>00003`000ol0003o00T000?o00003P0000l0
00?o0000o`090003o`0000h0000?0003o`000?l02@000ol0000>00003`000ol00009008So@000ol0
000>00003`000ol00009008So@000ol0000>00003`000ol0003o00T000?o00003P0000l000?o0000
o`090003o`0000h0000?0?oo3Ol@0000o`0/0000o`0/0000o`0/0000o`0/0000o`0/0000o`0/0000
o`0/0000O`04o`800ol200Wo0`03o`030?oo00;o00<0ool00_l00`3oo`03o`030?oo00;oO@000800
00Go0000o`080004o`00o`@000Ko003o0?l20003o`3o008000Go0000o`060003o`0007/000200004
o`0000Co0P04o`8000?o00000P001_l00?l0o`8000?o0?l00ol30004o`0000CoO@00080000Go0000
o`020004o`00o`D000?o00000P001_l00?l0o`8000?o00000P001Ol0003o00<000?o0000OP0007l0
1?l200;o0`04o`030?oo00D01Ol20003o`3o00;o10001?l00004ogd0002H0003o`0000/000?o0000
PP00090000?o00001002o``00_n40000o`0/0000o`0/0000o`0/0000o`0/0000\
\>"],
  ImageRangeCache->{{{0, 298.062}, {183.75, 0}} -> {-3.47269, -0.147613, 
  0.160857, 0.0021347}}]
}, Closed]],

Cell["Here we combine several results on the same graph.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(Plot[Evaluate[BestFit /. report], {x, \(-2\), 2}, 
      Epilog \[Rule] {Rectangle[{1, 0.6}, {2.1, 1}, residualplot], 
          PointSize[0.01], GrayLevel[0.5], Map[Point, cosdata]}, 
      PlotLabel -> "\<Quadratic fit\>"]; \)\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.238095 0.226006 0.399042 [
[.02381 .21351 -6 -9 ]
[.02381 .21351 6 0 ]
[.2619 .21351 -6 -9 ]
[.2619 .21351 6 0 ]
[.7381 .21351 -3 -9 ]
[.7381 .21351 3 0 ]
[.97619 .21351 -3 -9 ]
[.97619 .21351 3 0 ]
[.4875 .06639 -24 -4.5 ]
[.4875 .06639 0 4.5 ]
[.4875 .1462 -24 -4.5 ]
[.4875 .1462 0 4.5 ]
[.4875 .30581 -18 -4.5 ]
[.4875 .30581 0 4.5 ]
[.4875 .38562 -18 -4.5 ]
[.4875 .38562 0 4.5 ]
[.4875 .46543 -18 -4.5 ]
[.4875 .46543 0 4.5 ]
[.4875 .54524 -18 -4.5 ]
[.4875 .54524 0 4.5 ]
[.5 .63053 -41 0 ]
[.5 .63053 41 15 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .22601 m
.02381 .23226 L
s
[(-2)] .02381 .21351 0 1 Mshowa
.2619 .22601 m
.2619 .23226 L
s
[(-1)] .2619 .21351 0 1 Mshowa
.7381 .22601 m
.7381 .23226 L
s
[(1)] .7381 .21351 0 1 Mshowa
.97619 .22601 m
.97619 .23226 L
s
[(2)] .97619 .21351 0 1 Mshowa
.125 Mabswid
.07143 .22601 m
.07143 .22976 L
s
.11905 .22601 m
.11905 .22976 L
s
.16667 .22601 m
.16667 .22976 L
s
.21429 .22601 m
.21429 .22976 L
s
.30952 .22601 m
.30952 .22976 L
s
.35714 .22601 m
.35714 .22976 L
s
.40476 .22601 m
.40476 .22976 L
s
.45238 .22601 m
.45238 .22976 L
s
.54762 .22601 m
.54762 .22976 L
s
.59524 .22601 m
.59524 .22976 L
s
.64286 .22601 m
.64286 .22976 L
s
.69048 .22601 m
.69048 .22976 L
s
.78571 .22601 m
.78571 .22976 L
s
.83333 .22601 m
.83333 .22976 L
s
.88095 .22601 m
.88095 .22976 L
s
.92857 .22601 m
.92857 .22976 L
s
.25 Mabswid
0 .22601 m
1 .22601 L
s
.5 .06639 m
.50625 .06639 L
s
[(-0.4)] .4875 .06639 1 0 Mshowa
.5 .1462 m
.50625 .1462 L
s
[(-0.2)] .4875 .1462 1 0 Mshowa
.5 .30581 m
.50625 .30581 L
s
[(0.2)] .4875 .30581 1 0 Mshowa
.5 .38562 m
.50625 .38562 L
s
[(0.4)] .4875 .38562 1 0 Mshowa
.5 .46543 m
.50625 .46543 L
s
[(0.6)] .4875 .46543 1 0 Mshowa
.5 .54524 m
.50625 .54524 L
s
[(0.8)] .4875 .54524 1 0 Mshowa
.125 Mabswid
.5 .08634 m
.50375 .08634 L
s
.5 .10629 m
.50375 .10629 L
s
.5 .12625 m
.50375 .12625 L
s
.5 .16615 m
.50375 .16615 L
s
.5 .1861 m
.50375 .1861 L
s
.5 .20605 m
.50375 .20605 L
s
.5 .24596 m
.50375 .24596 L
s
.5 .26591 m
.50375 .26591 L
s
.5 .28586 m
.50375 .28586 L
s
.5 .32577 m
.50375 .32577 L
s
.5 .34572 m
.50375 .34572 L
s
.5 .36567 m
.50375 .36567 L
s
.5 .40558 m
.50375 .40558 L
s
.5 .42553 m
.50375 .42553 L
s
.5 .44548 m
.50375 .44548 L
s
.5 .48538 m
.50375 .48538 L
s
.5 .50534 m
.50375 .50534 L
s
.5 .52529 m
.50375 .52529 L
s
.5 .04644 m
.50375 .04644 L
s
.5 .02648 m
.50375 .02648 L
s
.5 .00653 m
.50375 .00653 L
s
.5 .56519 m
.50375 .56519 L
s
.5 .58514 m
.50375 .58514 L
s
.5 .6051 m
.50375 .6051 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
gsave
.5 .63053 -102 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 15.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 15.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(Quadratic) show
123.000000 15.000000 moveto
(fit) show
141.000000 15.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .01472 m
.06244 .10635 L
.10458 .19746 L
.14415 .27463 L
.18221 .34117 L
.22272 .40374 L
.26171 .45593 L
.30316 .50274 L
.34309 .53941 L
.3815 .56687 L
.40095 .57785 L
.42237 .58767 L
.44268 .59479 L
.45178 .59728 L
.46172 .59952 L
.4671 .60051 L
.4721 .6013 L
.47727 .60198 L
.48196 .60248 L
.48658 .60285 L
.4887 .60299 L
.49093 .60311 L
.49332 .6032 L
.49438 .60324 L
.49552 .60327 L
.49675 .60329 L
.49789 .60331 L
.49859 .60331 L
.49925 .60332 L
.50049 .60332 L
.50163 .60331 L
.50286 .6033 L
.50401 .60328 L
.50508 .60325 L
.50754 .60317 L
.51014 .60305 L
.51268 .6029 L
.51504 .60273 L
.5204 .60224 L
.5293 .60109 L
.53882 .59941 L
.54906 .59707 L
.56016 .59392 L
.58032 .58658 L
.60019 .57726 L
.62123 .56517 L
.65912 .5376 L
.69946 .50005 L
.73829 .45593 L
.77956 .40045 L
Mistroke
.81932 .33864 L
.85757 .27144 L
.89827 .19159 L
.93745 .1066 L
.97619 .01472 L
Mfstroke
% Start of sub-graphic
p
0.738095 0.465431 1 0.625048 MathSubStart
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.0232288 0.258374 1.75037 [
[ 0 0 -0.125 0 ]
[ 0 0 -0.125 0 ]
[ 0 .61803 .125 0 ]
[ 1 0 .125 0 ]
[.5 .63053 -24.5 0 ]
[.5 .63053 24.5 15 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
0 0 m
1 0 L
s
0 0 m
0 .61803 L
s
0 .61803 m
1 .61803 L
s
1 0 m
1 .61803 L
s
0 .25837 m
1 .25837 L
s
gsave
.5 .63053 -85.5 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23 translate 1 -1 scale
63.000000 15.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 9.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
63.000000 15.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 9.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
(residuals) show
108.000000 15.000000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 9.000000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000000 0.000000 0.000000 setrgbcolor
0.000000 0.000000 rmoveto
1.000000 setlinewidth
%%DocumentNeededResources: font Courier
%%DocumentNeededFonts: Courier
%%DocumentFonts: font Courier
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
1 0 0 r
.008 w
.04704 .60332 Mdot
.07027 .3855 Mdot
.0935 .27864 Mdot
.11672 .39118 Mdot
.13995 .12889 Mdot
.16318 .04908 Mdot
.18641 .1523 Mdot
.20964 .14457 Mdot
.23287 .32632 Mdot
.2561 .21703 Mdot
.27933 .35647 Mdot
.30256 .32063 Mdot
.32578 .30128 Mdot
.34901 .26989 Mdot
.37224 .13172 Mdot
.39547 .37561 Mdot
.4187 .19245 Mdot
.44193 .3875 Mdot
.46516 .36339 Mdot
.48839 .36764 Mdot
.51161 .22005 Mdot
.53484 .42931 Mdot
.55807 .5173 Mdot
.5813 .23047 Mdot
.60453 .21365 Mdot
.62776 .18574 Mdot
.65099 .29628 Mdot
.67422 .18226 Mdot
.69744 .38152 Mdot
.72067 .05446 Mdot
.7439 .04907 Mdot
.76713 .29505 Mdot
.79036 .32842 Mdot
.81359 .13895 Mdot
.83682 .03357 Mdot
.86005 .01472 Mdot
.88328 .12557 Mdot
.9065 .38326 Mdot
.92973 .13815 Mdot
.95296 .30307 Mdot
.97619 .32904 Mdot
MathSubEnd
P
% End of sub-graphic
.5 g
.01 w
.02381 .09335 Mdot
.04762 .10109 Mdot
.07143 .13117 Mdot
.09524 .20833 Mdot
.11905 .19709 Mdot
.14286 .22452 Mdot
.16667 .29072 Mdot
.19048 .32869 Mdot
.21429 .40691 Mdot
.2381 .41584 Mdot
.2619 .47853 Mdot
.28571 .49832 Mdot
.30952 .51892 Mdot
.33333 .53384 Mdot
.35714 .52147 Mdot
.38095 .59326 Mdot
.40476 .56475 Mdot
.5 .59458 Mdot
.57143 .58371 Mdot
.59524 .56958 Mdot
.61905 .54997 Mdot
.64286 .55899 Mdot
.66667 .51386 Mdot
.69048 .53722 Mdot
.71429 .43764 Mdot
.7381 .40845 Mdot
.7619 .43363 Mdot
.78571 .40739 Mdot
.80952 .32741 Mdot
.83333 .26365 Mdot
.85714 .21668 Mdot
.88095 .19634 Mdot
.90476 .20652 Mdot
.92857 .09914 Mdot
.95238 .08229 Mdot
.97619 .03082 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{299.062, 184.75},
  ImageMargins->{{48, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004[0000^0P10`4000010?ooooooc?ooZ_ooI_oo
<ooo0?o<ooo<c?o<VC/k>gYjN[Vi^OShn03ooeGooj[ooonI<onI0?mVoomVc?mVVOmVI_mV<omV0?lc
oclo?ginO[fm_Oclo5D00:X00?l00?l0VOl0I_l0<ol00<coolcoc<coVLcoIP<30d92@X61PL30`000
EED0EJX0EOl0ELbIolbIc<bIVLbII/bI<lbI0<aVolaVc0L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0Z/`c
<l`c0<`0ol`0c<`0VL`0I/`0<l`000/;2dY:BXV9RLS8b000oeD0ojX0ool0oiW<VIW<IYW<<iW<09VI
oiVIc9VIVIVIIPl?3di>CXf=SLc<c01E05EE0:YE0?mE09TcoiTcc9TcVITcIYTc<iTc09T0oiT0c1<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEEFKo<fKo06K<ofK<c6K<VFK<IVK<<fK<01LG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZVIVVFIVIVIV<fIV06HcofHcc6HcVFHcIQ/K6eYJFYVIVMSHf01EoeEEojYEoomEoc?o
oc?oc3?oVC?oIS?o<c?o03?<oc?<c1lO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ03>I<c>I03=Voc=Vc3=V
VC=VIS=V<c=V02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZEC<0VC<0IS<0<c<0003oo`3oc03oV@3oIRLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2Io`2Ic02IV@2IIP2I<`2I001Vo`1Vc2/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`0c<`0c0000o`00c000V@00IP00<nh002l_;fi^KZf][Nc/k03o05Go0:[o0?oo0140
003^003M002k002Z0028001g001E03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@00M`00E@00A0008P00
4Nk^k]gMgK^k^cLg=gIfM[Fe]OCdm03oZUGoZZ[oZP0009D000?o0000T`0009D00_nD0000U@000ol0
002C0000U@000ol0002C00005@000ol0001m0003o`0007`000?o0000500001D000?o0000O@000ol0
001l0003o`0001@0000F0003o`0007`000?o0000N`000ol0000E00005P000ol0001l00;oO0000ol0
000E00005P000ol0001l0003o`0007/00QXF00005`000ol0001k0003o`0007X000?o6QX05P0001L0
00?o0000N`000ol0001j0003o`0001H0000H0003o`0007X000?o0000N@000ol0000G000060000ol0
001j00;oNP000ol0000G00006@000ol0001i0003o`0007P000?o0000600001T000?o0000N@000ol0
001h0003o`0001P0000I0003o`0007T000?o0000N0000ol0000H00006P000ol0001T00;o1002o`@0
0ol50003o`0007L000?o00006@0001X000?o0000H`001?l00?l300;o1@000ol000040003o`0007L0
00?o00006@0001/000?o0000G005o`050?l00?l02004o`D00_mg0003o`0001X0000K0003o`000680
00Co003o20000ol0o`060003o`0007H000?o00006P0001/000?o0000HP001?l00?l80003o`3o00H0
00?o0000MP000ol0000J000070000ol0001R00;o2P02o`H000?o0000M@000ol0000K000070000ol0
001f0003o`0007D00QXL00007@000ol0001e00;oM@000olJ6P0L00007@000ol0001e0003o`0007@0
00?o0000700001@00QX80003o`0007@000?o0000L`000ol0000M000050026PP000?o0000M0000ol0
001^008J0`000ol0000M00006`026P030?l007D000?o0000KP026P<000?o00007@0001/00QX20003
o`0007<00_mc0003o`0001h0000O0003o`0007<000?o0000LP000ol0000N000080000ol0001b0003
o`00074000?o00007`00020000?o0000LP000ol0001a0003o`0001l0000Q0003o`00074000?o0000
L0000ol0000P00008@000ol0001a0003o`00070000?o00008000028000?o0000L002og0000?o0000
8@0002400QYb0003o`0006l000?o00008@0002400QX00ol0001_0003o`0006h000?o00008P0002<0
00?o0000F`02o`@00_l300Co1@000ol0001^0003o`000280000T0003o`0005T000Co003o0`02o`@0
00?o00001@000ol0001]0003o`0002<0000T0003o`0005<01Ol01@3o003o00X000?o00001002ofh0
00?o00008`0002D000?o0000F0001?l00?l;0003o`0000<000?o0000K0000ol0000T00009@000ol0
001H0004o`00o`P000Co003o1@000ol0001/0003o`0002@0000U0003o`0005T00_l:00;o1P000ol0
001/0003o`0002@0000V0003o`0006`000?o0000J`000ol0000U00009P000ol0001/00;oK0000ol0
000U00009`000ol0001[0003o`0006X000?o00009P0002L000?o0000J`000ol0001Z0003o`0002H0
000X0003o`0006X000?o0000J@000ol0000W0000:0000ol0001Z0003o`0006T000?o00009`0002T0
00?o0000J@000ol0001X0003o`0002P0000F00Co3`000ol0000Z00?o?002oc/00ol[0003o`0000l0
1?lE00005`000ol0000@0003o`0002X000?o0000>`000ol0000k0003o`0002T000?o00004@000ol0
000E00004005o`<000?o00003`001?l000026R001Ol20003o`0003/000?o0000>`000ol0000T008J
0`000ol0000B0003o`0001@0000I0003o`0000l000?o00000QXW0003o`0003/000?o0000>`000ol0
000T008J0P000ol0000D0003o`0001<0000F0004o`00oa4000?o0000:@000ol0000k0003o`0003/0
00?o0000:0000ol0000A0004o`00oaD0000G00;o3P026P<000?o00009`02ocd00_lk00;o:@000ol0
00026Q400_lF00009`026P<000?o0000IP000ol0001U0003o`00008J:@0002d000?o0000I@000ol0
001T0003o`0002`0000]0003o`0006D000?o0000F`026PL000?o0000;00002h000?o0000I0000ol0
001K008J1P000ol0000]00003`0Uo`8JiOl@00005@000ol0000:0003o`0000X000?o00000P026PD0
00?o00002P000ol0000:0003o`0000X000?o00002@000ol0000:0003o`0000X000?o00002P000ol0
00090003o`0000X000?o00002P000ol0000:0003o`0000T000?o00002P000ol0000:0003o`0000T0
00?o00002P000ol0000:0003o`0001@0000E0003o`0001L000?o00008`000ol0000m0003o`0003`0
00?o00008P000ol0000H0003o`0001@0000`0003o`00068000?o0000H@000ol0000_0000<0000ol0
001R0003o`00060000?o0000<000034000?o0000H@000ol0001P0003o`000300000a0003o`000640
0_mP0003o`000340000b0003o`00060000?o0000G`000ol0000a0000<P000ol0001P0003o`0005h0
00?o0000<P0003<000?o0000G`000ol0001N0003o`000380000c0003o`0005l000?o0000E@026PH0
00?o0000<`0003@000?o0000GP02oeH00QX60003o`0003<0000d0003o`0005h000?o0000G0000ol0
000d0000=@000ol0001M0003o`0005`000?o0000=00003D000?o0000G@000ol0001K0003o`0003D0
000f0003o`0005`000?o0000F`000ol0000e0000=P000ol0001L00;oF`000ol0000f0000=`001?l0
00026UP000?o0000F@000ol0000g0000>0000ol000026UP000?o0000F@000ol0000g0000>0000ol0
001J0003o`0005P000?o0000>00003T000?o0000A@02o`@00_l300Co1@000ol0001H0003o`0