(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    267308,       4954]
NotebookOptionsPosition[    206690,       3702]
NotebookOutlinePosition[    264807,       4896]
CellTagsIndexPosition[    264728,       4891]
WindowTitle->How to Debug: Elementary Introduction to the Wolfram Language
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[TextData[{
 "Correct the program ",
 Cell[BoxData[
  RowBox[{
   StyleBox["Counts",
    FontFamily->"Source Sans Pro"], "[", 
   RowBox[{
    RowBox[{
     StyleBox["StringTake",
      FontFamily->"Source Sans Pro"], "[", 
     RowBox[{
      StyleBox["#",
       FontFamily->"Source Sans Pro"], ",", "2"}], "]"}], 
    StyleBox["&",
     FontFamily->"Source Sans Pro"], 
    StyleBox["/@",
     FontFamily->"Source Sans Pro"], 
    RowBox[{
     StyleBox["WordList",
      FontFamily->"Source Sans Pro"], "[", "]"}]}], "]"}]], "InlineCode",
  ExpressionUUID->"00784635-9ed6-401a-a558-48eb1c64a8b7"],
 " for counting possible first two letters in words."
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "47.1", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 TaggingRules->{"MultipleSolutions" -> "True"},
 CounterAssignments->{{"SectionNumber", 47}, {"ExerciseNumber", 1}, {
   "WebOnly", 0}},ExpressionUUID->"0cb076d5-2b4c-4f95-94f3-023fc804ddc9"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{
    "SAMPLE", " ", "EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"d4cf01be-25aa-463e-a83e-9c78c15d474d"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJzsvc/L/M6WHtZJNlnmX8g/oHWW0TIrgUN2vbGJZbJxGjsQtBUEo6VW0cZ0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            "], {{0, 
            680}, {501, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{501, 680},
          PlotRange->{{0, 501}, {0, 680}}]], "ExerciseOutput",
         ImageSize->{505, 680},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "64d68ff6-27df-4c56-b512-278ff96821e6"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJzsvc/L/M6WHtZJNlnmX8g/oHWW0TIrgUN2vbGJZbJxGjsQtBUEo6VW0cZ0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              "], {{
              0, 680}, {501, 0}}, {0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {501, 680}, 
            PlotRange -> {{0, 501}, {0, 680}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"dcb21dc3-ad6f-45a6-807c-dc34044e59ac"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["47.1"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"f1501eb1-b18f-49a2-9970-37afda3a6b11"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"51fafb29-a449-46d4-9775-590e44b6e1af"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"3ef1d154-10ad-4840-8b6d-85a44c6b34f7"],

Cell[TextData[{
 "Use ",
 StyleBox["Sow",
  FontFamily->"Source Sans Pro"],
 " and ",
 StyleBox["Reap",
  FontFamily->"Source Sans Pro"],
 " to find intermediate values of ",
 Cell[BoxData[
  RowBox[{
   StyleBox["#",
    FontFamily->"Source Sans Pro"], "1"}]], "InlineCode",ExpressionUUID->
  "e7f447a6-e847-49d6-b90e-8720700bac9d"],
 " in ",
 Cell[BoxData[
  RowBox[{
   StyleBox["Fold",
    FontFamily->"Source Sans Pro"], "[", 
   RowBox[{
    RowBox[{"10", 
     StyleBox["#",
      FontFamily->"Source Sans Pro"], "1", 
     StyleBox["+",
      FontFamily->"Source Sans Pro"], 
     StyleBox["#",
      FontFamily->"Source Sans Pro"], "2", 
     StyleBox["&",
      FontFamily->"Source Sans Pro"]}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5"}], "}"}]}], "]"}]], 
  "InlineCode",ExpressionUUID->"7f62c18d-2871-4bfa-bbd8-3789c96d541e"],
 "."
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "47.2", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 47}, {"ExerciseNumber", 2}, {
   "WebOnly", 0}},ExpressionUUID->"40f1a249-6432-4dd4-a98d-7399107966a7"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"a3eca222-8270-48dc-98de-422a8afb6686"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztVq+P2zAUjjYyOGl/wf6B4FHDoUg3jRXsTrucRm7R3aQpNMzQzCwoKCgo
KCTSpBATkxBriiaFBASYGAR0z05zze3StNcfN9JPahW77315/fx++P3V9wv3
lWVZ92/g6+LyJ7q7u/Q/vYXF59v7bze3118/3v64vrm++3D1GjbfwecLfPTz
8owzzjjjf6JNsWvbHlf9UgrOK9lt8/rXrK14GsdxklXtcXxlzdMkTtJcNOrU
hF0jGCsNgYxchBZB0awcJafQqF2c1N1SxL5lgIt2JpqnZix09dq2zTbK6o0S
7ebbsdAzy37TCvnGeI5BWAXmp0Jqqco0XMACFyt9GLEs0gtaZVHgOWBK2Zw+
T8xUiCyHMv3YFkCOCDvQtwxdh5gIO6H/v5+djpDRhdHMYXK1U4aOZZMVHdf6
yPULS3gZmdXnqVkn2yFlJZnV5/m+EkPsi2i2xvYn7ESspfF9ELUYVOAUWTbt
VyJaPGiloRjaRZ+NZjXkqj2vz46+nWwqkYXmtBNxGsIG29qikdyx0IM+pdEE
Vq3IoCzRUGuz79opJG5qN93cf3b3NYXfwyvnO/S+hMagTxuOLMSHqPukwkmJ
TV/KxsQH6FNnePtZP8+3kzUL4IgRlcvN2IuwrZK+7RBKcKC7t+vjrOpPQlHT
yLu21MbBqPt1XNcynwtn0qwy8bgh3+K4m2+n1hnTpFAR6+Q/FuGv34wSQil8
EYJX+uRGH1WGesYV9VLPR8ixvv8ouEXwXP/kR3nJea30uPNtCwXpKMEnzEQS
9Hmbc85YURRc3zv29lWlznsci6atRQ6tE8ZtszwB4UhhqC821JfpyXSVSQ/z
SzHHegQCA09xPfzs0YCbMPsD/f4xzHEf4Fvl4XobeXmt+liPTDjiQaMUHc8v
07XwTPLqBLNny/80vgApWykf/ZGjE06iBH2GjtfXGnJpNTVz6lQXZrT5+jqD
Q3xfhnAKqjAXgNGtSRURdt1gcoZCuxf1dsEncYjvyxBOQaXY84JQ7J2jZ5wx
4C8AGjuk
            "], {{0, 19}, {96, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{96, 19},
          PlotRange->{{0, 96}, {0, 19}}]], "ExerciseOutput",
         ImageSize->{100, 19},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "1f237575-286d-4038-8b4d-6289b128c448"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztVq+P2zAUjjYyOGl/wf6B4FHDoUg3jRXsTrucRm7R3aQpNMzQzCwoKCgo
KCTSpBATkxBriiaFBASYGAR0z05zze3StNcfN9JPahW77315/fx++P3V9wv3
lWVZ92/g6+LyJ7q7u/Q/vYXF59v7bze3118/3v64vrm++3D1GjbfwecLfPTz
8owzzjjjf6JNsWvbHlf9UgrOK9lt8/rXrK14GsdxklXtcXxlzdMkTtJcNOrU
hF0jGCsNgYxchBZB0awcJafQqF2c1N1SxL5lgIt2JpqnZix09dq2zTbK6o0S
7ebbsdAzy37TCvnGeI5BWAXmp0Jqqco0XMACFyt9GLEs0gtaZVHgOWBK2Zw+
T8xUiCyHMv3YFkCOCDvQtwxdh5gIO6H/v5+djpDRhdHMYXK1U4aOZZMVHdf6
yPULS3gZmdXnqVkn2yFlJZnV5/m+EkPsi2i2xvYn7ESspfF9ELUYVOAUWTbt
VyJaPGiloRjaRZ+NZjXkqj2vz46+nWwqkYXmtBNxGsIG29qikdyx0IM+pdEE
Vq3IoCzRUGuz79opJG5qN93cf3b3NYXfwyvnO/S+hMagTxuOLMSHqPukwkmJ
TV/KxsQH6FNnePtZP8+3kzUL4IgRlcvN2IuwrZK+7RBKcKC7t+vjrOpPQlHT
yLu21MbBqPt1XNcynwtn0qwy8bgh3+K4m2+n1hnTpFAR6+Q/FuGv34wSQil8
EYJX+uRGH1WGesYV9VLPR8ixvv8ouEXwXP/kR3nJea30uPNtCwXpKMEnzEQS
9Hmbc85YURRc3zv29lWlznsci6atRQ6tE8ZtszwB4UhhqC821JfpyXSVSQ/z
SzHHegQCA09xPfzs0YCbMPsD/f4xzHEf4Fvl4XobeXmt+liPTDjiQaMUHc8v
07XwTPLqBLNny/80vgApWykf/ZGjE06iBH2GjtfXGnJpNTVz6lQXZrT5+jqD
Q3xfhnAKqjAXgNGtSRURdt1gcoZCuxf1dsEncYjvyxBOQaXY84JQ7J2jZ5wx
4C8AGjuk
              "], {{0, 19}, {96, 0}}, {0, 255}, ColorFunction -> 
              RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {96, 19}, 
            PlotRange -> {{0, 96}, {0, 19}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"ab36a2ac-441f-4717-a544-1c5ab0fdcfad"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["47.2"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"33fa71c0-27d5-4087-96cf-c69ad1be5132"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"7a81fa54-44c6-4514-b001-970084ded59c"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"c2fba78b-b810-4321-9971-be11ed7e80f1"],

Cell[TextData[{
 "Use ",
 StyleBox["Sow",
  FontFamily->"Source Sans Pro"],
 " and ",
 StyleBox["Reap",
  FontFamily->"Source Sans Pro"],
 " to get a list of all cases where ",
 Cell[BoxData[
  RowBox[{
   StyleBox["#",
    FontFamily->"Source Sans Pro"], "/", "2"}]], "InlineCode",ExpressionUUID->
  "b9d698ac-e5e8-4ee5-b2db-d12bae0300bf"],
 " is used in ",
 Cell[BoxData[
  RowBox[{
   StyleBox["Nest",
    FontFamily->"Source Sans Pro"], "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      StyleBox["If",
       FontFamily->"Source Sans Pro"], "[", 
      RowBox[{
       RowBox[{
        StyleBox["EvenQ",
         FontFamily->"Source Sans Pro"], "[", 
        StyleBox["#",
         FontFamily->"Source Sans Pro"], "]"}], ",", 
       RowBox[{
        StyleBox["#",
         FontFamily->"Source Sans Pro"], "/", "2"}], ",", 
       RowBox[{"3", 
        StyleBox["#",
         FontFamily->"Source Sans Pro"], 
        StyleBox["+",
         FontFamily->"Source Sans Pro"], "1"}]}], "]"}], 
     StyleBox["&",
      FontFamily->"Source Sans Pro"]}], ",", "1000", ",", "20"}], "]"}]], 
  "InlineCode",ExpressionUUID->"705ff8c2-bb4a-4d7f-b539-c30bc99b73ef"],
 "."
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "47.3", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 47}, {"ExerciseNumber", 3}, {
   "WebOnly", 0}},ExpressionUUID->"85e916b1-c80f-4ea8-bbfc-43bfb4166105"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"5ff87293-c271-4686-8639-95d7b6f2db67"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztWz3L7MYVVuImZSC/wH9AtVuVqRYc0m1zja+MmxtxHQhq1RiV6tSpkhuB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            "], {{0, 19}, {353, 0}}, {0, 
            255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{353, 19},
          PlotRange->{{0, 353}, {0, 19}}]], "ExerciseOutput",
         ImageSize->{357, 19},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "02137226-9537-4aaa-a217-66dfd7c6fc11"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztWz3L7MYVVuImZSC/wH9AtVuVqRYc0m1zja+MmxtxHQhq1RiV6tSpkhuB
QRBQpUZgEAYVmRCmEUEJqFGhgBoVKtZzZrRa7eqMNNq917FBB+579z3SPPOc
Z8587/vpF3/53Pytpmnf/I79+PzN34z379/Yf/o9++XP7775+qt3b7/847u/
vv3q7fvPvviEOf/A/r35jabB58thhx122GGHHXbYYYcddthhhx122M9tbeKa
um6RXvzalYRU3XB7PjRZEoVRTOr+GeejDTUlN6NV/yogo1znSRxFcU6byVXO
K6m7fYB9k6dxFCc5rYWjmcNxyEmhhhYJqzst2kGKN1G6F7YtMihaVO2GE0Mr
GMMoWb42NGVR0G4vGaxsWxFGhcVWrceG6C9CqQgpu8Xr2wwX+svIqDK8vk4L
Jti16eVSbzOUhLwsq8oQC/kiz64nWxkLecGwC03DODt5MxbsiK9pmunG9XAp
I1vj5uYTQuUa2tX0uOx3OhHanq7NzCi6lwBbEgk88dOKKHj7wphX4ubqgEOd
nmaAJzcbHjnDw4ynfu6fZ067lDQZImxPuUs/cUpOWkmdCMUxEJ2zspP5a5XD
n+TLnrlCBitbBOatDs1Iazw2XP9LH1tC6yWTDYaY/jgZRYaT5R4A6yIZ1qTe
YCgJ+XkN0ZAva9n1VCtjIWMMB5oE50komI08TfPGPpmGjgVk/WKErVNAjYBc
BZ/MeNjjxKzzDe0UEMaE275aEClCFo3LR142+oEkDWges3gzNgwOG7Vg7ZUY
uiOaI4WuaEBDDBNQ7TI5zQgUq5OpQYc6c/1MlqNLYbnshmg94KV7rcS5tFkg
Q2wzNtaU38WYVKdCnjxLMljZPmDN5BfwoM3ZA8MrUDRUf1Y8DVzb1JdMNhli
+qNkVBkK68tIdBlRZEXqTYaSkJ/XEE85eXY918pYyFKGNDhNmvQEhohZVZTh
eiPsEFusmC+eUlDGpL26E+XeuIw2nXemFwG79rqUanNXyMvVOJG7HqsOeLM2
c8b2mjyArCU8P8qI5ceZbsxdk82FFQwdkVoNNNg0RDw6l1Z4xi2leSIFFCgO
vBecbJs1+8r8siSDlh26aUXeeWsdENF/xKTBdZUorWXdJv1RMsoML+PAbpzP
+viaTGo1hnjIL2iIhCzLrqdbGQ1ZxpCwiVwfOwsMifPZii/Rr7Cdr99K9bAl
YeTVnRjrruCrvbNlmo4XUtjvvAY4M+g7mlNfd0+sEsuy/UiU2wfYNTXJIhis
zXD2FiyBNDvln4fE0nS2XKNp4PtRsjKiiyrnwvKJgzGwwrImbN4w3EzmlITp
jkBtdoVtoBfoXtOR06ZW92S2ytYOPNxO70l/YbwV5kPEDoYS/WVkNhgSWDhr
SVWHp/E1idR7NHwM+VUN70OWZdfzrbyVXXcMKR8WGHxbpjC1XjcdC1joEVO3
ura4uhOjPZSOoZtukCQhrEPZSNi+BjgBVzFXFzaGbFXJxlgviuOAb79gX7AL
kA8F3JZTbVSNpzr+aVy62o7F/w/WThgfe2UXzA5G0mbFuUAqQz4AOr7viD2k
X3S8F4hphbBAyfra5p7Meln+VE+2dvpz/cdg7kXewxDXX0ZmnaEgZvOVH5PX
8AVDROp9Gt6H/LKGDyHj2fVKK69n1wNDkepuTF3xciuD/QiriLm1mQ7HKf/9
AIB8J6Wdw+UrFd9gPMFw6JvEA9R4HBPYBu08myV5m57HYaHbBLxvr4x1bt0t
+6GhiQXzAsCiTjzcMvMc23b8LI8Z7Ld//06kk+d7Ls8o03bTSr6PmpEReS4r
W6eQI3Zcril1wfWfDxHrtaC21B8ls8WwC3hfs1zP85yTOI1Iq6XU/9nLcBby
h9HwLuT/LbPrh3/tZKiQcnKGvc+nn6GlMA856Ywlgf0LEU0Nqx3NCASJEo5m
TDqoO3EZbu4uhxVz0bwGyBZfORwaGd40Lg797dUmFZs7dcD+JvpAjNuZME82
O7mdGnkwJ4mXhyraGCLuhG09XTuF5fUJP0fqUKccUHDlZyPfkx99z/N99sPz
3DF5spXkmZEZmkJWtuKZY8LZ8qot9B+5UT5EcBYrtSxjQvVHySgw7LPQ90S9
nnviC9cg+8dS6h/+rc7wMeSXNURCXmbXPoYXlZSTatjDOZIW5DCKlLD7EWcR
PVz+Z/DIDjNK4LsDYlPvxKQpU1iIOLB/UXdeBmqzudtJpjD4lO7kZd1UBR8v
YW3zCmBfp+J4108LUhR5npfNP5nn7CVV05R5aPCk6JQBYSTR7ZTWbVPFLkw7
4Xg9erdVuVwX/FaYt23J744sfsnwCIgJ28NZlGamZdOziQNqORPciQAOTWad
nYxWZREBP+v+agZyzCiES4kMXraM+cWaZmVE6EpaLDpE/3YYupoQmoUgZZAV
hNbqDFH9UTKKDOcV840G6wsSqdUYoiG/oiEaMp5dz7cyHjLOcDyiHAeo241G
X5y0O/P4GnG8OeULnOuKT9nZEz4M3G5Muiqzb9UYQd68CEj8B9ZsBG5o6t92
XSeHdDsA+7pwztPXIHQvmVZfcFX6cChNR4UBMebXCktAXNi+dG/eU0TGQRpz
PgIObAq7EtRNv3pYC8Hy8rr8UCSDlG1nCo6NBX4l/Vt+eD6zh9vbVYaY/igZ
VYYzmy7cJVKrMURDfkVDWcoh2fVKKyMhSxje32jw1nQ3Tka7tm0fv8ml6IRV
yrWuyQb2XvchATEbOlZJ/7iX2MFwQUZWD0OcT0HKDPFalk4UkMexdWu7h4yi
/TyAO/RXA0RNsZb/Z8iL7HqRoWLIFFbMI6DYdBjLyehDWA1LKC0kayf9B+DH
A/xFkTkAfyWAfc7vAWcL5j4PXdN0Nr9H9ISxPWm5/tcQB+DHBPxFkTkAfyWA
feJalhMgf11z2GGHHXbYYYcdpmw/AS8VRyE=
              "], {{0, 19}, {353, 0}}, {
              0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {353, 19}, 
            PlotRange -> {{0, 353}, {0, 19}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"17f4c4ad-6a13-46e0-b907-d1b6139b98d7"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["47.3"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"126ed83e-971e-486c-9836-930155b506ce"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"4f136e2f-141e-4a68-8110-847b215f4c3d"]
}, Open  ]]
}, Open  ]],

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"c592e3b8-85b8-4927-bd3b-d160fd015f49"]
},
WindowSize->{808, 755},
WindowMargins->{{314, Automatic}, {Automatic, 50}},
WindowTitle->"How to Debug: Elementary Introduction to the Wolfram Language",
DockedCells->{
  Cell[
   BoxData[
    DynamicModuleBox[{}, 
     TagBox[
      GridBox[{{
         TagBox[
          ButtonBox[
           PaneBox[
            GraphicsBox[
             TagBox[
              RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UFAEiEGSIPafvQ3/iQM/qxmAiEjFmOohXKwIouDvuQXEGw4xENM6POaT5Hiq
qP97c+uvfvWfDVy/59j/ahX5Pdfx3/sHuNSDFE/UBpI/G3l+TTP9vS7p7+nZ
QBG4FjT1QJOBin+vCAcpaxcHWgEU/HOk7/ciHzzqgSYD2b/XJQO5UPFueezq
J+sDFf/qVQY64PeSgN8b0n5NMfz34DAu9T+beIFm/upV+jXF4PcC9z87K4C6
fk3SwaUeGBq/18QDDQQ5e2f5rw6pP0f7gd4BCmJVD3QG0HygBxHO61UG6sIV
nhAtwNAAOgCEgOEPMxmXevyAEvV4EidaQiU+P0IAAEIjNUM=
               "], {{0, 
               20}, {16, 0}}, {0, 255}, ColorFunction -> RGBColor], 
              BoxForm`ImageTag[
              "Byte", ColorSpace -> ColorProfileData[CompressedData["
1:eJydlndcFNcWx+/MbC+0XZYiZem9twVEehOQXkVh2V1gKQsuuxTFhogKRBQR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                 "], "RGB", "XYZ"], 
               Interleaving -> True], Selectable -> False], DefaultBaseStyle -> 
             "ImageGraphics", ImageSizeRaw -> {16, 20}, 
             PlotRange -> {{0, 16}, {0, 20}}], Alignment -> {Center, Center}, 
            ImageMargins -> {{15, 10}, {4, 0}}], Appearance -> None, 
           ButtonFunction :> NotebookLocate[{
              URL["http://www.wolfram.com/language/elementary-introduction/"],
               None}], Evaluator -> Automatic, Method -> "Preemptive"], 
          MouseAppearanceTag["LinkHand"]], 
         ItemBox[
          TagBox[
           GridBox[{{
              TagBox[
               ButtonBox[
                StyleBox[
                "STEPHEN WOLFRAM Elementary Introduction to the Wolfram \
Language", "DockedCellAuthorName"], Appearance -> None, ButtonFunction :> 
                NotebookLocate[{
                   URL[
                   "http://www.wolfram.com/language/elementary-introduction/"]\
, None}], Evaluator -> Automatic, Method -> "Preemptive"], 
               MouseAppearanceTag["LinkHand"]]}, {
              TagBox[
               ButtonBox[
                TemplateBox[{
                  StyleBox["Exercises ", "DockedCellSectionTitle"], 
                  StyleBox["|", "DockedCellSectionTitleDivider"], 
                  StyleBox[
                  " 47  Debugging Your Code", "DockedCellSectionTitle"]}, 
                 "RowDefault"], Appearance -> None, ButtonFunction :> 
                NotebookLocate[{
                   URL[
                   "http://www.wolfram.com/language/elementary-introduction/\
47-debugging-your-code.html"], None}], Evaluator -> Automatic, Method -> 
                "Preemptive"], 
               MouseAppearanceTag["LinkHand"]]}}, DefaultBaseStyle -> 
            "Column", GridBoxAlignment -> {"Columns" -> {{Left}}}, 
            GridBoxSpacings -> {"Columns" -> {{0}}, "Rows" -> {{0}}}], 
           "Column"], Alignment -> Left, ItemSize -> 30]}}, AutoDelete -> 
       False, GridBoxSpacings -> {"Columns" -> {{0}}, "Rows" -> {{0}}}, 
       GridBoxAlignment -> {"Columns" -> {Left}, "Rows" -> {Center}}, 
       GridBoxItemSize -> {
        "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], "Grid"], 
     DynamicModuleValues :> {}, 
     Initialization :> (
      Clear[$CellContext`SolutionResponseText]; \
$CellContext`SolutionResponseText[
         Pattern[ElementaryIntroToWLWeb`Private`a, 
          BlankNullSequence[]]] := " "; 
      Map[($CellContext`SolutionResponseText[#] := " ")& , {
        "47.1", "47.2", "47.3"}]; 
      Clear[$CellContext`SolutionResponseDetails]; \
$CellContext`SolutionResponseDetails[
         Pattern[ElementaryIntroToWLWeb`Private`str, 
          Blank[String]], True] := 
       Style[ElementaryIntroToWLWeb`Private`str, 
         "SolutionTrue"]; $CellContext`SolutionResponseDetails[
         Pattern[ElementaryIntroToWLWeb`Private`str, 
          Blank[String]], False] := 
       Style[ElementaryIntroToWLWeb`Private`str, 
         "SolutionFalse"]; $CellContext`SolutionResponseDetails[
         Pattern[ElementaryIntroToWLWeb`Private`str, 
          Blank[String]]] := 
       ElementaryIntroToWLWeb`Private`str; \
$CellContext`SolutionResponseDetails[
         Missing[
          BlankSequence[]]] := " "; $CellContext`SolutionResponseDetails[
         BlankNullSequence[]] := " "; 
      Clear[$CellContext`GetUserSolutions]; $CellContext`GetUserSolutions[] := 
       Flatten[
         Cases[
          Options[
           EvaluationNotebook[], TaggingRules], ("EIWLExercises" -> 
           Pattern[ElementaryIntroToWLWeb`Private`ex, 
             Blank[]]) :> ElementaryIntroToWLWeb`Private`ex, Infinity]]; 
      Clear[$CellContext`GetUserSolutionsTotal]; \
$CellContext`GetUserSolutionsTotal[] := Length[
         Union[
          Flatten[
           Cases[
            Cases[
             Options[
              EvaluationNotebook[], TaggingRules], ("EIWLExercises" -> 
              Pattern[ElementaryIntroToWLWeb`Private`ex, 
                Blank[]]) :> ElementaryIntroToWLWeb`Private`ex, Infinity], (
             "ExercisesTotal" -> Pattern[ElementaryIntroToWLWeb`Private`t, 
               Blank[]]) :> ElementaryIntroToWLWeb`Private`t, Infinity]]]]; 
      Clear[$CellContext`GetUserSolutionsTried]; \
$CellContext`GetUserSolutionsTried[] := Length[
         Union[
          Flatten[
           Cases[
            Cases[
             Options[
              EvaluationNotebook[], TaggingRules], ("EIWLExercises" -> 
              Pattern[ElementaryIntroToWLWeb`Private`ex, 
                Blank[]]) :> ElementaryIntroToWLWeb`Private`ex, Infinity], (
             "ExercisesTried" -> Pattern[ElementaryIntroToWLWeb`Private`t, 
               Blank[]]) :> ElementaryIntroToWLWeb`Private`t, Infinity]]]]; 
      Clear[$CellContext`GetUserSolutionsCorrect]; \
$CellContext`GetUserSolutionsCorrect[] := Length[
         Union[
          Flatten[
           Cases[
            Cases[
             Options[
              EvaluationNotebook[], TaggingRules], ("EIWLExercises" -> 
              Pattern[ElementaryIntroToWLWeb`Private`ex, 
                Blank[]]) :> ElementaryIntroToWLWeb`Private`ex, Infinity], (
             "ExercisesCorrect" -> Pattern[ElementaryIntroToWLWeb`Private`t, 
               Blank[]]) :> ElementaryIntroToWLWeb`Private`t, 
            
            Infinity]]]]; $CellContext`EIWLExerciseSolutionsTotal = \
$CellContext`GetUserSolutionsTotal[]; $CellContext`EIWLExerciseSolutionsTried = \
$CellContext`GetUserSolutionsTried[]; \
$CellContext`EIWLExerciseSolutionsCorrect = \
$CellContext`GetUserSolutionsCorrect[]; 
      Clear[$CellContext`SetUserSolutionsTried]; \
$CellContext`SetUserSolutionsTried[
         Pattern[ElementaryIntroToWLWeb`Private`value, 
          Blank[]]] := 
       Module[{ElementaryIntroToWLWeb`Private`data, 
          ElementaryIntroToWLWeb`Private`tr}, 
         ElementaryIntroToWLWeb`Private`data = Flatten[
            Cases[
             Options[
              EvaluationNotebook[], TaggingRules], ("EIWLExercises" -> 
              Pattern[ElementaryIntroToWLWeb`Private`ex, 
                Blank[]]) :> ElementaryIntroToWLWeb`Private`ex, Infinity]]; 
         ElementaryIntroToWLWeb`Private`tr = ReplaceAll[TaggingRules, 
            Options[
             EvaluationNotebook[], TaggingRules]]; 
         ElementaryIntroToWLWeb`Private`tr = 
          DeleteCases[
           ElementaryIntroToWLWeb`Private`tr, "EIWLExercises" -> Blank[], 
            Infinity]; 
         AppendTo[
          ElementaryIntroToWLWeb`Private`tr, 
           "EIWLExercises" -> {
            "ExercisesTotal" -> 
             ReplaceAll[
              "ExercisesTotal", ElementaryIntroToWLWeb`Private`data], 
             "ExercisesTried" -> Append[
               Flatten[
                Cases[
                ElementaryIntroToWLWeb`Private`data, ("ExercisesTried" -> 
                  Pattern[ElementaryIntroToWLWeb`Private`t, 
                    Blank[]]) :> ElementaryIntroToWLWeb`Private`t, Infinity]],
                ElementaryIntroToWLWeb`Private`value], "ExercisesCorrect" -> 
             ReplaceAll[
              "ExercisesCorrect", ElementaryIntroToWLWeb`Private`data]}]; 
         SetOptions[
           EvaluationNotebook[], TaggingRules -> 
           ElementaryIntroToWLWeb`Private`tr]; \
$CellContext`EIWLExerciseSolutionsTried = \
$CellContext`GetUserSolutionsTried[]; Null]; 
      Clear[$CellContext`SetUserSolutionsCorrect]; \
$CellContext`SetUserSolutionsCorrect[
         Pattern[ElementaryIntroToWLWeb`Private`value, 
          Blank[]]] := 
       Module[{ElementaryIntroToWLWeb`Private`data, 
          ElementaryIntroToWLWeb`Private`tr}, 
         ElementaryIntroToWLWeb`Private`data = Flatten[
            Cases[
             Options[
              EvaluationNotebook[], TaggingRules], ("EIWLExercises" -> 
              Pattern[ElementaryIntroToWLWeb`Private`ex, 
                Blank[]]) :> ElementaryIntroToWLWeb`Private`ex, Infinity]]; 
         ElementaryIntroToWLWeb`Private`tr = ReplaceAll[TaggingRules, 
            Options[
             EvaluationNotebook[], TaggingRules]]; 
         ElementaryIntroToWLWeb`Private`tr = 
          DeleteCases[
           ElementaryIntroToWLWeb`Private`tr, "EIWLExercises" -> Blank[], 
            Infinity]; 
         AppendTo[
          ElementaryIntroToWLWeb`Private`tr, 
           "EIWLExercises" -> {
            "ExercisesTotal" -> 
             ReplaceAll[
              "ExercisesTotal", ElementaryIntroToWLWeb`Private`data], 
             "ExercisesTried" -> 
             ReplaceAll[
              "ExercisesTried", ElementaryIntroToWLWeb`Private`data], 
             "ExercisesCorrect" -> Append[
               Flatten[
                Cases[
                ElementaryIntroToWLWeb`Private`data, ("ExercisesCorrect" -> 
                  Pattern[ElementaryIntroToWLWeb`Private`t, 
                    Blank[]]) :> ElementaryIntroToWLWeb`Private`t, Infinity]],
                ElementaryIntroToWLWeb`Private`value]}]; SetOptions[
           EvaluationNotebook[], TaggingRules -> 
           ElementaryIntroToWLWeb`Private`tr]; \
$CellContext`EIWLExerciseSolutionsCorrect = \
$CellContext`GetUserSolutionsCorrect[]; Null]; 
      Clear[ElementaryIntroToWLWeb`Private`GetCurrentTallyCell]; \
$CellContext`GetCurrentTallyCell[] := Module[{}, 
         With[{
          ElementaryIntroToWLWeb`Private`solutionsTried = \
$CellContext`GetUserSolutionsTried[], 
           ElementaryIntroToWLWeb`Private`solutionsTotal = \
$CellContext`GetUserSolutionsTotal[], 
           ElementaryIntroToWLWeb`Private`solutionsCorrect = \
$CellContext`GetUserSolutionsCorrect[]}, 
          Cell[
           BoxData[
            PaneBox[
             TemplateBox[{
               StyleBox[
               "COMPLETED\[ThickSpace]\[ThickSpace]", 
                "DockedCellCompletedExerciseText"], 
               StyleBox[
               ElementaryIntroToWLWeb`Private`solutionsTried, 
                "DockedCellCompletedExerciseText"], 
               StyleBox["/", "DockedCellSolutionDivider"], 
               StyleBox[
               ElementaryIntroToWLWeb`Private`solutionsTotal, 
                "DockedCellCompletedExerciseText"], 
               StyleBox[
               "\[ThinSpace]|\[ThinSpace]", "DockedCellSolutionDivider"], 
               StyleBox[
               ElementaryIntroToWLWeb`Private`solutionsCorrect, 
                "DockedCellCorrectExerciseText"], 
               StyleBox[
               "\[ThickSpace]\[ThickSpace]CORRECT", 
                "DockedCellCorrectExerciseText"]}, "RowDefault"], Alignment -> 
             Right, ImageSize -> Full]], "Output", TextAlignment -> Right, 
           CellFrame -> 1, CellMargins -> {{0, 0}, {10, 0}}, 
           CellFrameMargins -> {{14, 24}, {4, 7}}, CellFrameColor -> 
           RGBColor[1, 0.956862, 0.878431], MenuSortingValue -> 10000, 
           Background -> RGBColor[1, 0.956862, 0.878431], CellTags -> 
           "SolutionTallyCell"]]])]], "Output", CellMargins -> 0, 
   CellFrameMargins -> {{0, 24}, {3, 6}}, Background -> 
   RGBColor[0.97647, 0.482352, 0], CellFrame -> 1, CellFrameColor -> 
   RGBColor[0.97647, 0.482352, 0]], 
  Cell["SECOND EDITION", "Text", FontFamily -> "Source Sans Pro", 
   CellFrame -> {{0, 0}, {3, 0}}, ShowCellBracket -> False, 
   CellMargins -> {{0, 0}, {-1, -1}}, CellFrameMargins -> {{44, 0}, {2, 4}}, 
   CellFrameColor -> RGBColor[0.952941, 0.509804, 0], FontSize -> 10, 
   FontTracking -> "Extended", FontColor -> RGBColor[1, 0.929412, 0.721569], 
   Background -> RGBColor[0.862745, 0.309804, 0], CellTags -> 
   "DockedCellLogoCell"]},
TaggingRules->{
 "EIWLExercises" -> {
   "ExercisesTotal" -> {"47.1", "47.2", "47.3"}, "ExercisesTried" -> {}, 
    "ExercisesCorrect" -> {}}},
FrontEndVersion->"11.1 for Mac OS X x86 (32-bit, 64-bit Kernel) (April 18, \
2017)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[StyleDefinitions -> "Default.nb"]], 
   Cell[
    CellGroupData[{
      Cell[
      "Style Environments", "Section", 
       CellChangeTimes -> {{3.64661165091824*^9, 3.646611654013329*^9}, 
         3.6485723794335403`*^9, 3.651347081728628*^9, 3.651347179462186*^9, 
         3.651347384135805*^9, 3.651348171662589*^9, {3.662385415502224*^9, 
         3.662385415587447*^9}, {3.662385986094821*^9, 
         3.662385986340312*^9}, {3.662386515144682*^9, 
         3.662386515438078*^9}, {3.662386561676188*^9, 
         3.662386561889332*^9}, {3.668356126688795*^9, 
         3.6683561270120687`*^9}, {3.670169943059537*^9, 
         3.670169943254141*^9}}], 
      Cell[
       StyleData[All, "Working"]], 
      Cell[
       StyleData[All, "Printout"], 
       PrintingOptions -> {
        "PageSize" -> {504, 720}, "PrintRegistrationMarks" -> True}, 
       Magnification -> 0.6]}, Closed]], 
   Cell[
    CellGroupData[{
      Cell[
      "Custom Styles", "Section", 
       CellChangeTimes -> {{3.646611660445352*^9, 3.646611669493331*^9}}], 
      Cell[
       StyleData["Notebook"], CreateCellID -> True, CellContext -> Notebook, 
       CellLabelAutoDelete -> False, DefaultNewCellStyle -> "Input", 
       ShowSyntaxStyles -> True, MenuSortingValue -> None], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Title"], CellMargins -> {{64, Inherited}, {50, 72}}, 
          MenuCommandKey -> None, FontFamily -> "Verdana", FontSize -> 42, 
          FontWeight -> "Bold", FontColor -> GrayLevel[0.4]], 
         Cell[
          StyleData["Title", "Printout"], 
          CellMargins -> {{64, Inherited}, {50, 72}}]}, Closed]], 
      Cell[
       StyleData["Chapter"], MenuCommandKey -> None], 
      Cell[
       StyleData["Subchapter"], MenuCommandKey -> None], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Section"], CellFrame -> {{0, 0}, {0, 0}}, CellDingbat -> 
          Cell[
            TextData[
             CounterBox["Section"], 
             StyleBox[
             "|\[NegativeThinSpace]", FontColor -> 
              RGBColor[
               0.9019607843137255, 0.4117647058823529, 0.027450980392156862`],
               FontFamily -> "Courier", FontSize -> 36, FontWeight -> Plain]],
             "SectionNumber"], CellMargins -> {{96, Inherited}, {12, 64}}, 
          Evaluatable -> True, CellGroupingRules -> {"SectionGrouping", 60}, 
          PageBreakAbove -> True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["Section", "Printout"], 
          CellMargins -> {{96, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionDoubleDigit"], CellFrame -> {{0, 0}, {0, 0}}, 
          CellDingbat -> Cell[
            TextData[
             CounterBox["Section"], 
             StyleBox[
             "|\[NegativeThinSpace]", FontColor -> 
              RGBColor[
               0.9019607843137255, 0.4117647058823529, 0.027450980392156862`],
               FontFamily -> "Courier", FontSize -> 36, FontWeight -> Plain]],
             "SectionNumber"], CellMargins -> {{112, Inherited}, {12, 64}}, 
          Evaluatable -> True, CellGroupingRules -> {"SectionGrouping", 60}, 
          PageBreakAbove -> True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["SectionDoubleDigit", "Printout"], 
          CellMargins -> {{112, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionNumber"], CellBaseline -> Baseline, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 26, FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SectionNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionInline"], FontFamily -> 
          "Source Sans Pro Semibold", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SectionInline", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionNoDingbat"], 
          CellMargins -> {{64, Inherited}, {12, 64}}, Evaluatable -> True, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakAbove -> 
          True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["SectionNoDingbat", "Printout"], 
          CellMargins -> {{64, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Exercise"], CellDingbat -> Cell[
            TextData[{"  ", 
              CounterBox["Section"], ".", 
              CounterBox["Exercise"]}], "ExerciseNumber", FontColor -> 
            RGBColor[
             0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
          ShowGroupOpener -> True, CellMargins -> {{90, 40}, {4, 18}}, 
          CellGroupingRules -> "InputGrouping", CounterIncrements -> 
          "Exercise", MenuSortingValue -> 10020, MenuCommandKey -> "2", 
          FontFamily -> "Source Sans Pro", FontSize -> 16, FontWeight -> 
          "Plain", FontSlant -> "Plain", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["Exercise", "Printout"], ShowGroupOpener -> False, 
          CellMargins -> {{110, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseNumber"], FontFamily -> "Source Sans Pro", 
          FontSize -> 16, FontWeight -> "Bold", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["ExerciseNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseInput", StyleDefinitions -> StyleData["Input"]], 
          CellMargins -> {{70, 30}, {4, 7}}, ShowCellLabel -> False, 
          CellFrameLabels -> {{None, None}, {None, None}}, SpanMaxSize -> 1, 
          FontSize -> 
          14, $CellContext`GeneratedCellStyles -> {
           "Output" -> "ExerciseOutput"}], 
         Cell[
          StyleData["ExerciseInput", "Printout"], 
          CellMargins -> {{88, 10}, {4, 7}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "ExerciseOutput", StyleDefinitions -> StyleData["Output"]], 
          CellMargins -> {{90, 40}, {0, 6}}, CellGroupingRules -> 
          "OutputGrouping", ShowCellLabel -> False, FontSize -> 14], 
         Cell[
          StyleData["ExerciseOutput", "Printout"], 
          CellMargins -> {{88, 10}, {10, 4}}]}, Closed]], 
      Cell[
       StyleData["ExerciseExpectedResult"], ShowCellBracket -> False, 
       ShowGroupOpener -> False, CellMargins -> {{90, 40}, {3, 9}}, 
       CellGroupingRules -> "InputGrouping", CounterIncrements -> "Exercise", 
       MenuSortingValue -> 10000, FontFamily -> "Source Sans Pro", FontSize -> 
       12, FontWeight -> "Plain", FontSlant -> "Plain"], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Picture"], CellMargins -> {{66, 10}, {10, 10}}, 
          CellGroupingRules -> "GraphicsGrouping", StyleMenuListing -> None], 
         
         Cell[
          StyleData["Picture", "Printout"], 
          CellMargins -> {{66, 10}, {8, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Tentative"], 
          CellBracketOptions -> {
           "Color" -> RGBColor[
             0.30000000000000016`, 0.6000000000000003, 0.7000000000000003], 
            "Thickness" -> 5}, Evaluatable -> False, CellFrameMargins -> 4, 
          StyleMenuListing -> None, Background -> 
          RGBColor[0.8500000000000003, 0.9500000000000003, 1]], 
         Cell[
          StyleData["Tentative", "Printout"], 
          CellElementSpacings -> {"CellMinHeight" -> 0.1}, CellOpen -> False, 
          CellFrameMargins -> 0, FontSize -> 0.1, Magnification -> 0.01]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["WebOnly"], 
          CellBracketOptions -> {
           "Color" -> RGBColor[0.91, 0.92, 0.9], "Thickness" -> 5}, 
          CellFrameMargins -> 4, StyleMenuListing -> None, Background -> 
          RGBColor[0.91, 0.92, 0.86]], 
         Cell[
          StyleData["WebOnly", "Printout"], 
          CellElementSpacings -> {"CellMinHeight" -> 0.1}, CellOpen -> False, 
          CellFrameMargins -> 0, FontSize -> 0.1, Magnification -> 0.01]}, 
        Closed]], 
      Cell[
       StyleData["Lockdown"], 
       CellBracketOptions -> {
        "Color" -> RGBColor[0.8, 0.5, 0.4], "Thickness" -> 3}, Evaluatable -> 
       False, StyleMenuListing -> None], 
      Cell[
       StyleData["InlineCode"], SpanMaxSize -> 0, FontColor -> GrayLevel[0]], 
      
      Cell[
       StyleData["ExpectedOutputNote"], Selectable -> False, FontFamily -> 
       "Source Sans Pro", FontColor -> GrayLevel[0.3]], 
      Cell[
       StyleData["EIWLTextLink"], LineBreakWithin -> False, 
       TemplateBoxOptions -> {DisplayFunction :> (TagBox[
           
           ButtonBox[#, Appearance -> None, ButtonData -> #2, 
            BaseStyle -> {
             "Hyperlink", FontWeight -> Bold, FontSize -> 16, FontFamily -> 
              "Source Sans Pro"}], 
           MouseAppearanceTag["LinkHand"]]& )}, 
       ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
      Cell[
       StyleData["CheckAnswerDividerCloud"], ShowCellBracket -> False, 
       CellMargins -> {{40, 40}, {3, 6}}, 
       CellBracketOptions -> {"OverlapContent" -> True}, 
       CellGroupingRules -> {"SectionGrouping", 40}, 
       CellFrameMargins -> {{20, 20}, {2, 2}}, TextAlignment -> Right], 
      Cell[
       StyleData["CodeSectionDividerCloud"], Editable -> False, Selectable -> 
       False, ShowCellBracket -> False, CellMargins -> {{0, 0}, {0, 35}}, 
       CellBracketOptions -> {"OverlapContent" -> True}, 
       CellElementSpacings -> {"CellMinHeight" -> 6}, 
       CellGroupingRules -> {"SectionGrouping", -5}, 
       CellFrameMargins -> {{20, 20}, {2, 2}}, DefaultNewCellStyle -> "Input",
        FontSize -> 6, Background -> GrayLevel[0.95]], 
      Cell[
       StyleData["InlineCode"], SpanMaxSize -> 0, FontColor -> GrayLevel[0]], 
      
      Cell[
       StyleData["InlineCodeText"], SpanMaxSize -> 0, FontFamily -> 
       "Source Sans Pro"], 
      Cell[
       StyleData["Input"], CellMargins -> {{92, 20}, {5, 8}}, 
       CellFrameLabels -> {{None, 
          
          DynamicModuleBox[{$CellContext`EIWLExerciseCheck = 
            Automatic, $CellContext`buttonLabel = " CHECK MY SOLUTION "}, 
           DynamicBox[
            ToBoxes[
             If[
              TrueQ[$CellContext`EIWLExerciseCheck == Automatic], 
              MouseAppearance[
               Tooltip[
                Button[
                 Framed[
                  Panel[
                   
                   Style[$CellContext`buttonLabel, FontFamily -> 
                    "Source Sans Pro", FontSize -> 10, FontColor -> 
                    RGBColor[0.953948, 0.305638, 0.0285344]], Appearance -> 
                   None, Background -> GrayLevel[1], 
                   FrameMargins -> {{2, 2}, {0, 0}}, ImageMargins -> 0], 
                  FrameStyle -> {
                    Thickness[Tiny], 
                    RGBColor[0.953948, 0.305638, 0.0285344]}, RoundingRadius -> 
                  3], 
                 
                 Block[{$CellContext`usersCell, $CellContext`solutionResult, \
$CellContext`exerciseNumber, $CellContext`exerciseSwitchResult}, \
$CellContext`exerciseNumber = StringJoin[
                    If[
                    TrueQ[CurrentValue[{"CounterValue", "WebOnly"}] == 1], 
                    "x", ""], 
                    ToString[
                    CurrentValue[{"CounterValue", "SectionNumber"}]], ".", 
                    ToString[
                    
                    CurrentValue[{
                    "CounterValue", 
                    "ExerciseNumber"}]]]; $CellContext`buttonLabel = 
                   Row[{" CHECKING ", 
                    ProgressIndicator[Appearance -> "Percolate"]}]; 
                  SelectionMove[
                    ButtonNotebook[], All, ButtonCell, AutoScroll -> 
                    False]; $CellContext`usersCell = NotebookRead[
                    InputNotebook[]]; If[
                    TrueQ[Length[
                    Flatten[{$CellContext`usersCell}]] == 
                    1], $CellContext`solutionResult = ToExpression[
                    URLFetch[
                    "https://www.wolframcloud.com/objects/user-9b23d046-b2a9-\
4a5c-8723-08465cce25ed/EIWLGradingAPI", "Method" -> "POST", 
                    "Parameters" -> {
                    "exNum" -> $CellContext`exerciseNumber, "answer" -> 
                    ToString[$CellContext`usersCell, InputForm, 
                    CharacterEncoding -> "ASCII"], "user" -> 
                    ToString[$WolframID], "referer" -> "eiwl-nb", "uuid" -> 
                    ToString[$WolframUUID]}]]; \
$CellContext`SolutionResponseText[$CellContext`exerciseNumber] = \
$CellContext`SolutionResponseDetails[
                    $CellContext`solutionResult["Text"], 
                    $CellContext`solutionResult[
                    "CorrectQ"]]; $CellContext`exerciseSwitchResult = Switch[
                    $CellContext`solutionResult["CorrectQ"], 
                    True, $CellContext`EIWLExerciseCheck = 
                    True; $CellContext`SetUserSolutionsCorrect[$CellContext`\
exerciseNumber]; \
$CellContext`SetUserSolutionsTried[$CellContext`exerciseNumber]; Null, 
                    
                    Blank[], $CellContext`EIWLExerciseCheck = 
                    False; $CellContext`SetUserSolutionsTried[$CellContext`\
exerciseNumber]], 
                    CloudSystem`CreateCloudDialog[
                    StyleBox[
                    "Select a cell to be checked.", Selectable -> False], 
                    WindowTitle -> " "]]], Appearance -> None, Evaluator -> 
                 Automatic, Method -> "Queued"], 
                "Click to check your solution.", TooltipDelay -> 0.15], 
               "LinkHand"], 
              If[
               TrueQ[$CellContext`EIWLExerciseCheck], 
               MouseAppearance[
                Button[
                 Framed[
                  Row[{
                    Panel[
                    Style[
                    ToExpression[
                    "\!\(\* GraphicsBox[ TagBox[RasterBox[CompressedData[\" \
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBLECOU2VJahIzkCECxFJADGKrbtYa \
RUMUpZzMcNnnQRWjMk5lf/vzDWggtYwCkgNiFDBAsPqCPFcBjcLURYkH0fRS \
HlZwE6gV7EATfvz98f3Pd6rEIBClncpMPZlJFaNGEd0QANRpOvM= \"], {{0, 20}, { 26, \
0}}, {0, 255}, ColorFunction->RGBColor], BoxForm`ImageTag[ \"Byte\", \
Interleaving -> True, Magnification -> 1], Selectable->False], \
BaseStyle->\"ImageGraphics\", ImageSize->Magnification[1], ImageSizeRaw->{26, \
20}, PlotRange->{{0, 26}, {0, 20}}]\)"], Selectable -> False], Background -> 
                    RGBColor[0.146944, 0.70164, 0.16466], 
                    FrameMargins -> {{5, 5}, {0, 0}}, ImageMargins -> 0, 
                    Appearance -> None], 
                    Panel[
                    Style[
                    " CORRECT ", FontSize -> 10, FontColor -> 
                    RGBColor[0.146944, 0.70164, 0.16466], FontFamily -> 
                    "Source Sans Pro"], Background -> White, 
                    FrameMargins -> {{5, 5}, {0, 0}}, Appearance -> None]}], 
                  FrameStyle -> {
                    Thickness[Tiny], 
                    RGBColor[0.146944, 0.70164, 0.16466]}, FrameMargins -> 0, 
                  RoundingRadius -> 3], $CellContext`buttonLabel = 
                  " CHECK MY SOLUTION "; $CellContext`EIWLExerciseCheck = 
                  Automatic, Appearance -> None], "LinkHand"], 
               MouseAppearance[
                Button[
                 Framed[
                  Row[{
                    Panel[
                    Style[
                    ToExpression[
                    "\!\(\* GraphicsBox[ TagBox[RasterBox[CompressedData[\" \
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBLECOU2VJahIzkCECxGJADGK/YtAZ \
RTRCb1W8PnhlYooDBYFSxJgAVPnvy7cPfrkogn65IEFsJmM3BKIeZggal1RD \
yNOOMOT7DyAiTzvlJlDoCwpDkvLYpDxFjSLyEAAHORZk \"], {{0, 20}, {22, 0}}, { 0, \
255}, ColorFunction->RGBColor], BoxForm`ImageTag[ \"Byte\", Interleaving -> \
True, Magnification -> 1], Selectable->False], BaseStyle->\"ImageGraphics\", \
ImageSize->Magnification[1], ImageSizeRaw->{22, 20}, PlotRange->{{0, 22}, {0, \
20}}]\)"], Selectable -> False], Background -> 
                    RGBColor[0.918257, 0, 0.172488], 
                    FrameMargins -> {{5, 5}, {0, 0}}, ImageMargins -> 0, 
                    Appearance -> None], 
                    Panel[
                    Style[
                    " TRY AGAIN ", FontSize -> 10, FontColor -> 
                    RGBColor[0.918257, 0, 0.172488], FontFamily -> 
                    "Source Sans Pro"], Background -> White, 
                    FrameMargins -> {{5, 5}, {0, 0}}, Appearance -> None]}], 
                  FrameStyle -> {
                    Thickness[Tiny], 
                    RGBColor[0.918257, 0, 0.172488]}, FrameMargins -> 0, 
                  RoundingRadius -> 3], $CellContext`buttonLabel = 
                  " CHECK MY SOLUTION "; $CellContext`EIWLExerciseCheck = 
                  Automatic, Appearance -> None], "LinkHand"]]], 
             StandardForm], ImageSizeCache -> {109., {9., 16.}}], 
           DynamicModuleValues :> {}]}, {None, None}}, 
       CellChangeTimes -> {{3.6688095471029243`*^9, 3.66880959932793*^9}}, 
       MenuSortingValue -> 10000, FontSize -> 15], 
      Cell[
       StyleData["Output"], Deletable -> True, ShowCellBracket -> True, 
       CellMargins -> {{92, 50}, {10, 5}}, 
       CellBracketOptions -> {"OverlapContent" -> True}, CellEditDuplicate -> 
       True, GeneratedCell -> True, CellAutoOverwrite -> True, 
       LinebreakAdjustments -> {1, 2., 12., 1.25, 1.}, MenuSortingValue -> 
       None, FontSize -> 15], 
      Cell[
       StyleData["Message"], 
       CellMargins -> {{92, Inherited}, {Inherited, Inherited}}], 
      Cell[
       StyleData["EmptyCell"], Editable -> False, Selectable -> False, 
       CellMargins -> {{0, 0}, {-2, 0}}, 
       CellElementSpacings -> {"CellMinHeight" -> 1}, MenuSortingValue -> 
       10000, FontSize -> 1], 
      Cell[
       StyleData["CellLabel"], MenuSortingValue -> 10000, FontColor -> 
       GrayLevel[0.6]], 
      Cell[
       StyleData["Link"], LineBreakWithin -> False, 
       TemplateBoxOptions -> {DisplayFunction :> (TagBox[
           
           ButtonBox[#, Appearance -> None, ButtonData -> #2, 
            BaseStyle -> {
             "Hyperlink", FontSize -> 15, FontFamily -> "Source Sans Pro"}], 
           MouseAppearanceTag["LinkHand"]]& )}, 
       ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
      Cell[
       StyleData["ExpectedOutputText"], FontFamily -> "Arial", FontSize -> 13,
        FontColor -> RGBColor[0.8579079880979629, 0.4263828488593881, 0.]], 
      Cell[
       StyleData["CodeSectionDividerCloud"], Selectable -> False, 
       ShowCellBracket -> False, CellMargins -> {{0, 0}, {0, 35}}, 
       CellBracketOptions -> {"OverlapContent" -> True}, 
       CellElementSpacings -> {"CellMinHeight" -> 6}, 
       CellGroupingRules -> {"SectionGrouping", -5}, 
       CellFrameMargins -> {{20, 20}, {2, 2}}, DefaultNewCellStyle -> 
       "EmptyCell", FontSize -> 6, Background -> GrayLevel[0.95]], 
      Cell[
       StyleData["DockedCellAuthorName"], MenuSortingValue -> 10000, 
       FontFamily -> "Source Sans Pro", FontSize -> 12, FontColor -> 
       RGBColor[1, 0.929411, 0.721568]], 
      Cell[
       StyleData["DockedCellSectionTitle"], MenuSortingValue -> 10000, 
       FontFamily -> "Source Sans Pro", FontSize -> 18, FontColor -> 
       GrayLevel[1]], 
      Cell[
       StyleData["DockedCellSecondCell"], CellFrame -> 1, 
       CellMargins -> {{0, 0}, {0, 0}}, 
       CellFrameMargins -> {{10, 10}, {10, 10}}, CellFrameColor -> 
       RGBColor[1, 0.956862, 0.878431], MenuSortingValue -> 10000, Background -> 
       RGBColor[1, 0.956862, 0.878431]], 
      Cell[
       StyleData["CompletedExerciseHeader"], MenuSortingValue -> 10000, 
       FontFamily -> "Source Sans Pro", FontSize -> 14, FontColor -> 
       GrayLevel[0.5]], 
      Cell[
       StyleData["DockedCellShareButton"], MenuSortingValue -> 10000, 
       FontFamily -> "Source Sans Pro", FontSize -> 13, FontColor -> 
       GrayLevel[1]], 
      Cell[
       StyleData["DockedCellLinksSections"], MenuSortingValue -> 10000, 
       FontFamily -> "Source Sans Pro", FontSize -> 14, FontWeight -> "Plain",
        FontSlant -> "Plain", FontColor -> RGBColor[0.97647, 0.482352, 0]], 
      Cell[
       StyleData["DockedCellLinksDivider"], MenuSortingValue -> 10000, 
       FontFamily -> "Courier", FontSize -> 18, FontWeight -> "Plain", 
       FontSlant -> "Plain", FontColor -> RGBColor[0.97647, 0.482352, 0]], 
      Cell[
       StyleData["DockedCellSectionTitleDivider"], MenuSortingValue -> 10000, 
       FontFamily -> "Courier", FontSize -> 24, FontWeight -> "Plain", 
       FontSlant -> "Plain", FontColor -> GrayLevel[1]], 
      Cell[
       StyleData["SolutionTrue"], MenuSortingValue -> 10000, FontFamily -> 
       "Source Sans Pro", FontSize -> 12, FontWeight -> "Plain", FontSlant -> 
       "Plain", FontColor -> RGBColor[0.12, 0.7, 0.22]], 
      Cell[
       StyleData["SolutionFalse"], MenuSortingValue -> 10000, FontFamily -> 
       "Source Sans Pro", FontSize -> 12, FontWeight -> "Plain", FontSlant -> 
       "Plain", FontColor -> RGBColor[0.94, 0.08, 0.2]], 
      Cell[
       StyleData["SolutionResponseText"], ShowStringCharacters -> False, 
       FontFamily -> "Source Sans Pro", FontSize -> 12, FontWeight -> "Plain",
        FontSlant -> "Plain", FontColor -> GrayLevel[1]], 
      Cell[
       StyleData["SolutionResponse"], ShowCellBracket -> False, 
       CellMargins -> {{24, 25}, {6, 0}}, 
       CellFrameMargins -> {{8, 0}, {0, 12}}, TextAlignment -> Right, 
       ShowStringCharacters -> False, FontFamily -> "Source Sans Pro", 
       FontSize -> 12, FontWeight -> "Plain", FontSlant -> "Plain", 
       Background -> GrayLevel[1]], 
      Cell[
       StyleData["DockedCellCompletedExerciseText"], MenuSortingValue -> 
       10000, FontFamily -> "Source Sans Pro", FontSize -> 12, FontWeight -> 
       "Plain", FontSlant -> "Plain", FontColor -> GrayLevel[0.4]], 
      Cell[
       StyleData["DockedCellSolutionDivider"], MenuSortingValue -> 10000, 
       FontFamily -> "Courier", FontSize -> 16, FontWeight -> "Plain", 
       FontSlant -> "Plain", FontColor -> GrayLevel[0.6]], 
      Cell[
       StyleData["DockedCellCorrectExerciseText"], MenuSortingValue -> 10000, 
       FontFamily -> "Source Sans Pro", FontSize -> 12, FontWeight -> "Plain",
        FontSlant -> "Plain", FontColor -> RGBColor[0.12, 0.7, 0.22]], 
      Cell[
       CellGroupData[{
         Cell[
         "EIWL Cloud Link styles", "Subsubsection", 
          CellChangeTimes -> {{3.663512229965006*^9, 3.66351224118613*^9}}], 
         Cell[
          StyleData["EIWLTextLink"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 16, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkAnswer"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkCodeCaption"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontColor -> GrayLevel[0.6], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkExercise"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkExerciseNote"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkInlineCode"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkMoreExplore"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkQuestion"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontWeight -> Bold, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkTechNote"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkText"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 17, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkInlineCodeLink"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 17, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkVocabularyTable"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
         "EIWL Cloud Link", "Subsubsection", 
          CellChangeTimes -> {{3.664234597774767*^9, 3.664234605661516*^9}}], 
         
         Cell[
          StyleData["CodeLinkAnswer"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkCodeCaption"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontColor -> GrayLevel[0.6], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkExercise"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkQuestion"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontWeight -> Bold, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkTechNote"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkText"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 17, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkVocabularyTable"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkVocabularyTable3Column"], LineBreakWithin -> 
          False, TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkAnswer"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkCodeCaption"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontColor -> GrayLevel[0.6], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkExercise"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkExerciseNote"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkIndex"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkIndexSubentry"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkMoreExplore"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkQuestion"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontWeight -> Bold, FontColor -> 
                 GrayLevel[0], FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkTechNote"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkText"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 16, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkVocabularyTable"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}]}, 
        Closed]]}, Open]]}, Visible -> False, FrontEndVersion -> 
  "11.1 for Mac OS X x86 (32-bit, 64-bit Kernel) (April 18, 2017)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "FirstInputCell"->{
  Cell[184305, 3104, 813, 26, 
  70, "Input", "ExpressionUUID" -> "51fafb29-a449-46d4-9775-590e44b6e1af",
   CellTags->"FirstInputCell"],
  Cell[192859, 3346, 813, 26, 
  70, "Input", "ExpressionUUID" -> "7a81fa54-44c6-4514-b001-970084ded59c",
   CellTags->"FirstInputCell"],
  Cell[205562, 3661, 813, 26, 
  70, "Input", "ExpressionUUID" -> "4f136e2f-141e-4a68-8110-847b215f4c3d",
   CellTags->"FirstInputCell"]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"FirstInputCell", 264290, 4878}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[633, 21, 1088, 32, 70, "Exercise", "ExpressionUUID" -> \
"0cb076d5-2b4c-4f95-94f3-023fc804ddc9",
 CounterAssignments->{{"SectionNumber", 47}, {"ExerciseNumber", 1}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[1746, 57, 656, 20, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"d4cf01be-25aa-463e-a83e-9c78c15d474d"],
Cell[2405, 79, 181293, 3000, 70, "ExerciseOutput", "ExpressionUUID" -> \
"dcb21dc3-ad6f-45a6-807c-dc34044e59ac"]
}, Closed]],
Cell[CellGroupData[{
Cell[183735, 3084, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"f1501eb1-b18f-49a2-9970-37afda3a6b11"],
Cell[184305, 3104, 813, 26, 70, "Input", "ExpressionUUID" -> \
"51fafb29-a449-46d4-9775-590e44b6e1af",
 CellTags->"FirstInputCell"]
}, Open  ]],
Cell[CellGroupData[{
Cell[185155, 3135, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"3ef1d154-10ad-4840-8b6d-85a44c6b34f7"],
Cell[185442, 3146, 1265, 41, 70, "Exercise", "ExpressionUUID" -> \
"40f1a249-6432-4dd4-a98d-7399107966a7",
 CounterAssignments->{{"SectionNumber", 47}, {"ExerciseNumber", 2}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[186732, 3191, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"a3eca222-8270-48dc-98de-422a8afb6686"],
Cell[187371, 3212, 4881, 109, 70, "ExerciseOutput", "ExpressionUUID" -> \
"ab36a2ac-441f-4717-a544-1c5ab0fdcfad"]
}, Closed]],
Cell[CellGroupData[{
Cell[192289, 3326, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"33fa71c0-27d5-4087-96cf-c69ad1be5132"],
Cell[192859, 3346, 813, 26, 70, "Input", "ExpressionUUID" -> \
"7a81fa54-44c6-4514-b001-970084ded59c",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[193721, 3378, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"c2fba78b-b810-4321-9971-be11ed7e80f1"],
Cell[194008, 3389, 1545, 50, 70, "Exercise", "ExpressionUUID" -> \
"85e916b1-c80f-4ea8-bbfc-43bfb4166105",
 CounterAssignments->{{"SectionNumber", 47}, {"ExerciseNumber", 3}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[195578, 3443, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"5ff87293-c271-4686-8639-95d7b6f2db67"],
Cell[196217, 3464, 8738, 172, 70, "ExerciseOutput", "ExpressionUUID" -> \
"17f4c4ad-6a13-46e0-b907-d1b6139b98d7"]
}, Closed]],
Cell[CellGroupData[{
Cell[204992, 3641, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"126ed83e-971e-486c-9836-930155b506ce"],
Cell[205562, 3661, 813, 26, 70, "Input", "ExpressionUUID" -> \
"4f136e2f-141e-4a68-8110-847b215f4c3d",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[206402, 3691, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"c592e3b8-85b8-4927-bd3b-d160fd015f49"]
}
]
*)

(* End of internal cache information *)
(* NotebookSignature nQsv43qYmXxfIleRNmp1z#nu *)
