(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    635821,      13553]
NotebookOptionsPosition[    517392,      11188]
NotebookOutlinePosition[    614535,      13182]
CellTagsIndexPosition[    613624,      13145]
WindowTitle->Expressions and Their Structure: Elementary Introduction to the \
Wolfram Language
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
 InterpretationBox[Cell[
  "Expressions and Their Structure", "SectionInline",ExpressionUUID->
   "1f9d56fc-7f49-4d1c-98b9-20280d1086aa"],
  $Line = 0; Null]], "SectionDoubleDigit",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CounterAssignments->{{"Section", 32}, {"Subsection", 0}, {
   "Subsubsection", 0}, {"Exercise", 0}},
 CellTags->"p:197",
 CellLabel->"In[15]:=",ExpressionUUID->"84d1c18d-ffe2-4994-ac9a-f92126785834"],

Cell[TextData[{
 "We\[CloseCurlyQuote]ve now seen all sorts of things that exist in the \
Wolfram Language: lists, graphics, pure functions and much more. And now we\
\[CloseCurlyQuote]re ready to discuss a very fundamental fact about the \
Wolfram Language: that each of these things\[LongDash]and in fact everything \
the language deals with\[LongDash]is ultimately constructed in the same basic \
kind of way. Everything is what\[CloseCurlyQuote]s called a ",
 StyleBox["symbolic expression",
  FontSlant->"Italic"],
 ". "
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:1",ExpressionUUID->"525c4aa8-dec3-47c5-9bc9-157c841016b1"],

Cell[TextData[{
 "Symbolic expressions are a very general way to represent structure, \
potentially with meaning associated with that structure. ",
 Cell[BoxData[
  RowBox[{"f", "[", 
   RowBox[{"x", ",", "y"}], "]"}]], "InlineCodeText",ExpressionUUID->
  "21c8a667-4d72-4d00-94d5-99237c2dabcf"],
 " is a simple example of a symbolic expression. On its own, this symbolic \
expression doesn\[CloseCurlyQuote]t have any particular meaning attached, and \
if you type it into the Wolfram Language, it\[CloseCurlyQuote]ll just come \
back unchanged. "
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"32b93821-da1f-4ef9-b0ce-ce8fab19bc22"],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"f", "[", 
   RowBox[{"x", ",", "y"}], "]"}]], "InlineCode",ExpressionUUID->
  "37dd16e4-ca24-4377-b49a-1caba9dbbbaa"],
 " is a symbolic expression with no particular meaning attached: "
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"6ae03da0-bdb1-4cd6-84a9-3e1e1fdca51f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"x", ",", "y"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[1]:=",ExpressionUUID->"062107b2-1c5f-4de2-bdae-498afab0f292"],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"x", ",", "y"}], "]"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[1]=",ExpressionUUID->"908e2f5b-4831-4b44-a5bf-f51008a4602d"]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"x", ",", "y", ",", "z"}], "}"}]], "InlineCodeText",ExpressionUUID->
  "1c42d0ec-f410-4ae9-a5c4-6eefa82d2544"],
 " is another symbolic expression. Internally, it\[CloseCurlyQuote]s ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["List",
    BaseStyle->"CodeLink"], "[", 
   RowBox[{"x", ",", "y", ",", "z"}], "]"}]], "InlineCodeText",ExpressionUUID->
  "e572c684-22df-475f-b5df-75352f48f55f"],
 ", but it\[CloseCurlyQuote]s displayed as ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"x", ",", "y", ",", "z"}], "}"}]], "InlineCodeText",ExpressionUUID->
  "2ea3f973-df61-4722-a2d3-a7ada982c6eb"],
 "."
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:2",ExpressionUUID->"bdf5bdd2-a602-46fb-bf01-de8efce95a87"],

Cell[TextData[{
 "The symbolic expression ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["List",
    BaseStyle->"CodeLink"], "[", 
   RowBox[{"x", ",", "y", ",", "z"}], "]"}]], "InlineCode",ExpressionUUID->
  "7adef0b4-ac37-42f7-a798-a884fa3d6b87"],
 " displays as ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"x", ",", "y", ",", "z"}], "}"}]], "InlineCode",ExpressionUUID->
  "74ce8c86-d988-48f3-a57a-c95fed6c9b32"],
 ":"
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"dd1dca88-3847-4b93-8828-521ed96d3096"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"List", "[", 
  RowBox[{"x", ",", "y", ",", "z"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[2]:=",ExpressionUUID->"69cb1efe-2f5a-4af4-92db-698e8b0bc722"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", ",", "y", ",", "z"}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[2]=",ExpressionUUID->"38dcd52e-bdce-49ee-a42f-e27d85dd7f47"]
}, Open  ]],

Cell["Symbolic expressions are often nested:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"a4f3d2db-050c-4f8f-9b2f-3e46d59bd612"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"List", "[", 
  RowBox[{
   RowBox[{"List", "[", 
    RowBox[{"a", ",", "b"}], "]"}], ",", 
   RowBox[{"List", "[", 
    RowBox[{"c", ",", "d"}], "]"}]}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[3]:=",ExpressionUUID->"e5203ce2-d65f-460a-a4c5-ef3fd8ebc1df"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", "d"}], "}"}]}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[3]=",ExpressionUUID->"ad39897c-abc7-40a5-bded-741a5184037f"]
}, Open  ]],

Cell[TextData[{
 ButtonBox["FullForm",
  BaseStyle->"Link"],
 " shows you the internal form of any symbolic expression. "
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"a3b00660-8b76-476b-b618-bda36918a864"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullForm", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a", ",", "b"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"c", ",", "d"}], "}"}]}], "}"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[4]:=",ExpressionUUID->"d1e29688-ccaa-4667-8f48-3e0931d75101"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"List", "[", 
    RowBox[{
     RowBox[{"List", "[", 
      RowBox[{"a", ",", "b"}], "]"}], ",", 
     RowBox[{"List", "[", 
      RowBox[{"c", ",", "d"}], "]"}]}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->
  "Out[4]//FullForm=",ExpressionUUID->"e3f40953-d67b-4c9a-bc73-3f6e95d74048"]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Graphics",
    BaseStyle->"CodeLink"], "[", 
   RowBox[{
    ButtonBox["Circle",
     BaseStyle->"CodeLink"], "[", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0"}], "}"}], "]"}], "]"}]], "InlineCodeText",
  ExpressionUUID->"45faabe4-dd3b-489a-90a1-1c9304734acd"],
 " is another symbolic expression, that just happens to display as a picture \
of a circle. ",
 ButtonBox["FullForm",
  BaseStyle->"Link"],
 " shows its internal structure."
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"2967e795-3095-45d3-a5b5-c62f5c35d47e"],

Cell["This symbolic expression displays as a circle:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"fbff08b4-81eb-40bd-9fe7-f2aaf8466e2c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"Circle", "[", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}], "]"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[5]:=",ExpressionUUID->"e93a371b-915f-4f4b-9cf6-d920d5f838cd"],

Cell[BoxData[
 GraphicsBox[CircleBox[{0, 0}],
  ImageSize->{39.3125, Automatic}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellTags->"LastCellOfAPage",
 CellLabel->"Out[5]=",ExpressionUUID->"982246cf-a0c5-47e0-ae6f-4f2a2cf744e9"]
}, Open  ]],

Cell[TextData[{
 ButtonBox["FullForm",
  BaseStyle->"Link"],
 " shows its underlying symbolic expression structure:"
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->{
  "p:198", "i:3"},ExpressionUUID->"cfa290b8-3aff-4bc2-8073-4b3d34b4dc62"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullForm", "[", 
  GraphicsBox[CircleBox[{0, 0}],
   ImageSize->{37.328125, Automatic}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[6]:=",ExpressionUUID->"40e7a540-9960-40ed-a949-7523c2de1b8c"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"Graphics", "[", 
    RowBox[{"Circle", "[", 
     RowBox[{"List", "[", 
      RowBox[{"0", ",", "0"}], "]"}], "]"}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->
  "Out[6]//FullForm=",ExpressionUUID->"1e39832a-223e-483b-b292-5b8f345e4c9f"]
}, Open  ]],

Cell[TextData[{
 "Symbolic expressions often don\[CloseCurlyQuote]t just display in special \
ways, they actually ",
 StyleBox["evaluate",
  FontSlant->"Italic"],
 " to give results. "
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"63482d6d-6984-46ca-8dfc-5ad5b670f849"],

Cell["A symbolic expression that evaluates to give a result:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:4",ExpressionUUID->"be3a5b54-9319-4117-be63-2825d15e4919"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plus", "[", 
  RowBox[{"2", ",", "2"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[7]:=",ExpressionUUID->"dd9b889c-b888-46f0-a295-846d5b84ec9a"],

Cell[BoxData["4"], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[7]=",ExpressionUUID->"775a5def-9fb1-4f06-8c6c-210f63e1d4eb"]
}, Open  ]],

Cell["\<\
The elements of the list evaluate, but the list itself stays symbolic:\
\>", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"d756dbef-851e-44a9-be54-7a590bb5fed8"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Plus", "[", 
    RowBox[{"3", ",", "3"}], "]"}], ",", 
   RowBox[{"Times", "[", 
    RowBox[{"3", ",", "3"}], "]"}], ",", 
   RowBox[{"Power", "[", 
    RowBox[{"3", ",", "3"}], "]"}]}], "}"}]], "Input",
 Deletable->False,
 CellLabel->"In[8]:=",ExpressionUUID->"ab68e9e9-d663-4d10-9e0a-e739fe9d6c01"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"6", ",", "9", ",", "27"}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[8]=",ExpressionUUID->"5729467e-6916-4379-805c-5004a4103147"]
}, Open  ]],

Cell["Here\[CloseCurlyQuote]s the symbolic expression structure of the \
list:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"309ccb2a-0710-4b17-b710-2e1e90e1d225"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Plus", "[", 
     RowBox[{"3", ",", "3"}], "]"}], ",", 
    RowBox[{"Times", "[", 
     RowBox[{"3", ",", "3"}], "]"}], ",", 
    RowBox[{"Power", "[", 
     RowBox[{"3", ",", "3"}], "]"}]}], "}"}], "//", "FullForm"}]], "Input",
 Deletable->False,
 CellLabel->"In[9]:=",ExpressionUUID->"a80d6853-8eca-4e95-ac8e-52e20b1c47d5"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"List", "[", 
    RowBox[{"6", ",", "9", ",", "27"}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->
  "Out[9]//FullForm=",ExpressionUUID->"359ca278-56c4-4763-9463-972e37fa9187"]
}, Open  ]],

Cell["This is just a symbolic expression that happens to evaluate:", \
"CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"f808c3bb-f10b-4098-a84e-9036fbf17742"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Blur", "[", 
  RowBox[{
   GraphicsBox[
    {GrayLevel[0], CircleBox[{0, 0}]},
    ImagePadding->4,
    ImageSize->{56.08984375, 55.}], ",", "5"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[10]:=",ExpressionUUID->"19686d9b-6c38-41eb-91d9-3d45f2f23cef"],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztXcuOJNd1JOyNl/4F/4W3Wnorwx8gwbTgDQ1QBgx/6Dxa5mPY8yBnhiPS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   "], {{0, 0}, {240, 240}}, {0, 255},
   ColorFunction->RGBColor],
  ImageSize->{52, Automatic},
  ImageSizeRaw->{60, 60},
  PlotRange->{{0, 240}, {0, 240}}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[10]=",ExpressionUUID->"141b528a-e8eb-467c-88d0-d0fe7507c08a"]
}, Open  ]],

Cell["You could write it like this:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"ebbea364-b540-4abb-b706-f08258486ec6"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Blur", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{"Circle", "[", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}], "]"}], "]"}], ",", "5"}], 
  "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[11]:=",ExpressionUUID->"b89f52a0-2952-41bc-9fae-3107d404f953"],

Cell[BoxData[
 GraphicsBox[
  TagBox[RasterBox[CompressedData["
1:eJztXduy3NZ1VDkvefQv5C/ymke/2pUPsCuKyy9KleyqVD6Ul0NK9BEpXkQd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    "], {{0, 240}, {240, 0}}, {0, 255},
    ColorFunction->RGBColor],
   BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> False],
   Selectable->False],
  BaseStyle->"ImageGraphics",
  ImageSize->{52, Automatic},
  ImageSizeRaw->{240, 240},
  PlotRange->{{0, 240}, {0, 240}}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[11]=",ExpressionUUID->"daf03767-c90e-4f2c-ba1f-74683ec92cc5"]
}, Open  ]],

Cell[TextData[{
 "What are the ultimate building blocks of symbolic expressions? They\
\[CloseCurlyQuote]re called ",
 StyleBox["atoms",
  FontSlant->"Italic"],
 " (after the building blocks of physical materials). The main kinds of atoms \
are numbers, ",
 "strings",
 " and ",
 StyleBox["symbols",
  FontSlant->"Italic"],
 ". "
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:5",ExpressionUUID->"25108d93-7583-48f1-b734-b59aa01a78e7"],

Cell[TextData[{
 "Things like ",
 Cell[BoxData[
 "x"], "InlineCodeText",ExpressionUUID->
  "da9a7ad2-03f5-4d76-b605-1e5918442a3b"],
 ", ",
 Cell[BoxData[
 "y"], "InlineCodeText",ExpressionUUID->
  "94f3edd8-f62a-40e8-9cf6-e954032c26fc"],
 ", ",
 Cell[BoxData[
 "f"], "InlineCodeText",ExpressionUUID->
  "53bd585f-354a-4eaa-b491-f9559802fc60"],
 ", ",
 ButtonBox["Plus",
  BaseStyle->"Link"],
 ", ",
 ButtonBox["Graphics",
  BaseStyle->"Link"],
 " and ",
 ButtonBox["Table",
  BaseStyle->"Link"],
 " are all symbols. Every symbol has a unique name. Sometimes it\
\[CloseCurlyQuote]ll also have a meaning attached. Sometimes it\
\[CloseCurlyQuote]ll be associated with evaluation. Sometimes it\
\[CloseCurlyQuote]ll just be part of defining a structure that other \
functions can use. But it ",
 "doesn\[CloseCurlyQuote]t have to have",
 " any of those things; it just has to have a name."
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->
  "LastCellOfAPage",ExpressionUUID->"1d71e91b-b1e7-4f6e-bfa0-b7b56ad066fd"],

Cell["\<\
A crucial defining feature of the Wolfram Language is that it can handle \
symbols purely as symbols\[LongDash]\[OpenCurlyDoubleQuote]symbolically\
\[CloseCurlyDoubleQuote]\[LongDash]without them having to evaluate, say to \
numbers. \
\>", "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->{
  "p:199", "i:6"},ExpressionUUID->"90b145cd-7aad-4dc0-b184-f929a82e7bff"],

Cell[TextData[{
 "In the Wolfram Language, ",
 Cell[BoxData[
 "x"], "InlineCode",ExpressionUUID->"16c874c3-39c0-4b71-be4c-2fe244e536a8"],
 " can just be ",
 Cell[BoxData[
 "x"], "InlineCode",ExpressionUUID->"4e0d4ff5-2ae4-489c-a177-118efdcb11e2"],
 ", without having to evaluate to anything:"
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"0c176065-3c89-4209-adc9-2c7ec43b9f36"],

Cell[CellGroupData[{

Cell[BoxData["x"], "Input",
 Deletable->False,
 CellLabel->"In[12]:=",ExpressionUUID->"30c3d20c-7347-450c-9e89-cad7cf8fc217"],

Cell[BoxData["x"], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[12]=",ExpressionUUID->"6770b077-5d5d-47c9-bb9b-f9736b1e6293"]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
 "x"], "InlineCode",ExpressionUUID->"9a9639c7-816c-4227-a48c-d9f460241ef4"],
 " does not evaluate, but the addition is still done, here according to the \
laws of algebra: "
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"71435462-a7e2-4608-8630-07991cb6170e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"x", "+", "x", "+", "x", "+", 
  RowBox[{"2", "y"}], "+", "y", "+", "x"}]], "Input",
 Deletable->False,
 CellLabel->"In[13]:=",ExpressionUUID->"f1cff8e0-b4ba-4a6e-8c34-d15976cdc113"],

Cell[BoxData[
 RowBox[{
  RowBox[{"4", " ", "x"}], "+", 
  RowBox[{"3", " ", "y"}]}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[13]=",ExpressionUUID->"a0af2b94-837e-4a17-be79-57b8ed3e1a5a"]
}, Open  ]],

Cell[TextData[{
 "Given symbols like ",
 Cell[BoxData[
 "x"], "InlineCodeText",ExpressionUUID->
  "58160c91-5d02-42c0-8121-a6ea078e44a5"],
 ", ",
 Cell[BoxData[
 "y"], "InlineCodeText",ExpressionUUID->
  "34039237-8b59-49d9-bb57-d254a0d37298"],
 " and ",
 Cell[BoxData[
 "f"], "InlineCodeText",ExpressionUUID->
  "4cd83a34-5522-42f9-8050-c5b9ca1c564b"],
 ", one can build up an infinite number of expressions from them. There\
\[CloseCurlyQuote]s ",
 Cell[BoxData[
  RowBox[{"f", "[", "x", "]"}]], "InlineCodeText",ExpressionUUID->
  "92ca65cb-bd0b-439c-8bff-831da656f58f"],
 ", and ",
 Cell[BoxData[
  RowBox[{"f", "[", "y", "]"}]], "InlineCodeText",ExpressionUUID->
  "d6103fef-0c44-4c1c-adeb-bd66b910ae29"],
 ", and ",
 Cell[BoxData[
  RowBox[{"f", "[", 
   RowBox[{"x", ",", "y"}], "]"}]], "InlineCodeText",ExpressionUUID->
  "aac877d2-37f1-4e0f-a00f-cbf54342c6a8"],
 ". Then there\[CloseCurlyQuote]s ",
 Cell[BoxData[
  RowBox[{"f", "[", 
   RowBox[{"f", "[", "x", "]"}], "]"}]], "InlineCodeText",ExpressionUUID->
  "9d3e8973-dff4-4c6e-8224-726fd2f58999"],
 " or ",
 Cell[BoxData[
  RowBox[{"f", "[", 
   RowBox[{"x", ",", 
    RowBox[{"f", "[", 
     RowBox[{"x", ",", "y"}], "]"}]}], "]"}]], "InlineCodeText",
  ExpressionUUID->"2a4df3e0-e37c-47af-9ace-340910e086b7"],
 ", or, for that matter, ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"x", "[", "x", "]"}], "[", 
   RowBox[{"y", ",", 
    RowBox[{"f", "[", "x", "]"}]}], "]"}]], "InlineCodeText",ExpressionUUID->
  "1d914c3d-06c7-490c-9533-b215ed8ba3d6"],
 " or whatever. "
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"c4ddc57b-1ade-4136-8e2d-7ac4bb73e29e"],

Cell[TextData[{
 "In general, ",
 "each expression corresponds to a tree",
 ", whose ultimate \[OpenCurlyDoubleQuote]leaves\[CloseCurlyDoubleQuote] are \
atoms. You can display an expression as a tree using ",
 ButtonBox["TreeForm",
  BaseStyle->"Link"],
 "."
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:7",ExpressionUUID->"0a28f48c-690e-44d3-aa5b-8a1705d88f92"],

Cell["An expression shown in tree form:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"8213234e-f916-42f2-bf89-d89d53565674"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TreeForm", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"f", "[", 
     RowBox[{"x", ",", 
      RowBox[{"f", "[", 
       RowBox[{"x", ",", "y"}], "]"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y", ",", 
      RowBox[{"f", "[", "1", "]"}]}], "}"}]}], "}"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[14]:=",ExpressionUUID->"08362707-ffc2-4561-a39c-7bdf9b09d196"],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{1.378123654176776, 2.362497692874473}, {
    0.3937496154790789, 1.5749984619163153`}, {0., 0.7874992309581577}, {
    0.7874992309581578, 0.7874992309581577}, {0.3937496154790789, 0.}, {
    1.1812488464372366`, 0.}, {2.362497692874473, 1.5749984619163153`}, {
    1.5749984619163155`, 0.7874992309581577}, {2.362497692874473, 
    0.7874992309581577}, {3.149996923832631, 0.7874992309581577}, {
    3.149996923832631, 0.}}, {
     {RGBColor[0.55, 0.45, 0.45], 
      LineBox[{{1, 2}, {1, 7}, {2, 3}, {2, 4}, {4, 5}, {4, 6}, {7, 8}, {7, 
       9}, {7, 10}, {10, 11}}]}, {
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["List", "StandardForm", "Output",
           StripOnInput->False,
           FontSize->Scaled[0.05],
           FontColor->GrayLevel[0],
           $CellContext`LineColor -> GrayLevel[0],
           $CellContext`FrontFaceColor -> GrayLevel[0],
           $CellContext`GraphicsColor -> GrayLevel[0],
           $CellContext`BackFaceColor -> GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 1],
        TagBox[
         RowBox[{"{", 
           RowBox[{
             RowBox[{"f", "[", 
               RowBox[{"x", ",", 
                 RowBox[{"f", "[", 
                   RowBox[{"x", ",", "y"}], "]"}]}], "]"}], ",", 
             RowBox[{"{", 
               RowBox[{"x", ",", "y", ",", 
                 RowBox[{"f", "[", "1", "]"}]}], "}"}]}], "}"}], HoldForm]],
       Annotation[#, 
        HoldForm[{
          $CellContext`f[$CellContext`x, 
           $CellContext`f[$CellContext`x, $CellContext`y]], {$CellContext`x, \
$CellContext`y, 
           $CellContext`f[1]}}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["f", "StandardForm", "Output",
           StripOnInput->False,
           FontSize->Scaled[0.05],
           FontColor->GrayLevel[0],
           $CellContext`LineColor -> GrayLevel[0],
           $CellContext`FrontFaceColor -> GrayLevel[0],
           $CellContext`GraphicsColor -> GrayLevel[0],
           $CellContext`BackFaceColor -> GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 2],
        TagBox[
         RowBox[{"f", "[", 
           RowBox[{"x", ",", 
             RowBox[{"f", "[", 
               RowBox[{"x", ",", "y"}], "]"}]}], "]"}], HoldForm]],
       Annotation[#, 
        HoldForm[
         $CellContext`f[$CellContext`x, 
          $CellContext`f[$CellContext`x, $CellContext`y]]], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["x",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FontSize->Scaled[0.05],
           FontColor->GrayLevel[0],
           $CellContext`LineColor -> GrayLevel[0],
           $CellContext`FrontFaceColor -> GrayLevel[0],
           $CellContext`GraphicsColor -> GrayLevel[0],
           $CellContext`BackFaceColor -> GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 3],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["f", "StandardForm", "Output",
           StripOnInput->False,
           FontSize->Scaled[0.05],
           FontColor->GrayLevel[0],
           $CellContext`LineColor -> GrayLevel[0],
           $CellContext`FrontFaceColor -> GrayLevel[0],
           $CellContext`GraphicsColor -> GrayLevel[0],
           $CellContext`BackFaceColor -> GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 4],
        TagBox[
         RowBox[{"f", "[", 
           RowBox[{"x", ",", "y"}], "]"}], HoldForm]],
       Annotation[#, 
        HoldForm[
         $CellContext`f[$CellContext`x, $CellContext`y]], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["x",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FontSize->Scaled[0.05],
           FontColor->GrayLevel[0],
           $CellContext`LineColor -> GrayLevel[0],
           $CellContext`FrontFaceColor -> GrayLevel[0],
           $CellContext`GraphicsColor -> GrayLevel[0],
           $CellContext`BackFaceColor -> GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 5],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["y",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FontSize->Scaled[0.05],
           FontColor->GrayLevel[0],
           $CellContext`LineColor -> GrayLevel[0],
           $CellContext`FrontFaceColor -> GrayLevel[0],
           $CellContext`GraphicsColor -> GrayLevel[0],
           $CellContext`BackFaceColor -> GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 6],
        TagBox["y", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`y], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["List", "StandardForm", "Output",
           StripOnInput->False,
           FontSize->Scaled[0.05],
           FontColor->GrayLevel[0],
           $CellContext`LineColor -> GrayLevel[0],
           $CellContext`FrontFaceColor -> GrayLevel[0],
           $CellContext`GraphicsColor -> GrayLevel[0],
           $CellContext`BackFaceColor -> GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 7],
        TagBox[
         RowBox[{"{", 
           RowBox[{"x", ",", "y", ",", 
             RowBox[{"f", "[", "1", "]"}]}], "}"}], HoldForm]],
       Annotation[#, 
        HoldForm[{$CellContext`x, $CellContext`y, 
          $CellContext`f[1]}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["x",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FontSize->Scaled[0.05],
           FontColor->GrayLevel[0],
           $CellContext`LineColor -> GrayLevel[0],
           $CellContext`FrontFaceColor -> GrayLevel[0],
           $CellContext`GraphicsColor -> GrayLevel[0],
           $CellContext`BackFaceColor -> GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 8],
        TagBox["x", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`x], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["y",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FontSize->Scaled[0.05],
           FontColor->GrayLevel[0],
           $CellContext`LineColor -> GrayLevel[0],
           $CellContext`FrontFaceColor -> GrayLevel[0],
           $CellContext`GraphicsColor -> GrayLevel[0],
           $CellContext`BackFaceColor -> GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 9],
        TagBox["y", HoldForm]],
       Annotation[#, 
        HoldForm[$CellContext`y], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["f", "StandardForm", "Output",
           StripOnInput->False,
           FontSize->Scaled[0.05],
           FontColor->GrayLevel[0],
           $CellContext`LineColor -> GrayLevel[0],
           $CellContext`FrontFaceColor -> GrayLevel[0],
           $CellContext`GraphicsColor -> GrayLevel[0],
           $CellContext`BackFaceColor -> GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 10],
        TagBox[
         RowBox[{"f", "[", "1", "]"}], HoldForm]],
       Annotation[#, 
        HoldForm[
         $CellContext`f[1]], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["1",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FontSize->Scaled[0.05],
           FontColor->GrayLevel[0],
           $CellContext`LineColor -> GrayLevel[0],
           $CellContext`FrontFaceColor -> GrayLevel[0],
           $CellContext`GraphicsColor -> GrayLevel[0],
           $CellContext`BackFaceColor -> GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 11],
        TagBox["1", HoldForm]],
       Annotation[#, 
        HoldForm[1], "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{1.378123654176776, 2.362497692874473}, {
     0.3937496154790789, 1.5749984619163153`}, {0., 0.7874992309581577}, {
     0.7874992309581578, 0.7874992309581577}, {0.3937496154790789, 0.}, {
     1.1812488464372366`, 0.}, {2.362497692874473, 1.5749984619163153`}, {
     1.5749984619163155`, 0.7874992309581577}, {2.362497692874473, 
     0.7874992309581577}, {3.149996923832631, 0.7874992309581577}, {
     3.149996923832631, 0.}}]& ],
  AspectRatio->NCache[2 Rational[2, 5]^Rational[1, 2], 1.2649110640673518`],
  FrameTicks->Automatic,
  ImageSize->{145.86825321019046`, Automatic},
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->
  "Out[14]//TreeForm=",ExpressionUUID->"390c74f3-1b1a-4c34-8e39-7233bee70865"]
}, Open  ]],

Cell["Here\[CloseCurlyQuote]s a graphics expression shown in tree form:", \
"CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"baf9818c-074f-4e13-94de-911209a494a7"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TreeForm", "[", 
  RowBox[{"Graphics", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Circle", "[", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}], "]"}], ",", 
     RowBox[{"Hue", "[", "0.5", "]"}], ",", 
     RowBox[{"Disk", "[", 
      RowBox[{"{", 
       RowBox[{"1", ",", "1"}], "}"}], "]"}]}], "}"}], "]"}], "]"}]], "Input",\

 Deletable->False,
 CellLabel->"In[15]:=",ExpressionUUID->"0e910aac-ab84-4fe2-ab3c-510c8dd90580"],

Cell[BoxData[
 GraphicsBox[
  TagBox[GraphicsComplexBox[{{1.3296078906418773`, 3.5456210417116734`}, {
    1.3296078906418773`, 2.659215781283755}, {0.44320263021395917`, 
    1.7728105208558367`}, {0.44320263021395917`, 0.8864052604279187}, {0., 
    0.}, {0.8864052604279183, 0.}, {1.3296078906418773`, 
    1.7728105208558367`}, {1.3296078906418773`, 0.8864052604279187}, {
    2.2160131510697956`, 1.7728105208558367`}, {2.2160131510697956`, 
    0.8864052604279187}, {1.7728105208558367`, 0.}, {2.6592157812837547`, 
    0.}}, {
     {RGBColor[0.55, 0.45, 0.45], 
      LineBox[{{1, 2}, {2, 3}, {2, 7}, {2, 9}, {3, 4}, {4, 5}, {4, 6}, {7, 
       8}, {9, 10}, {10, 11}, {10, 12}}]}, {
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["Graphics", "StandardForm", "Output",
           StripOnInput->False,
           FontSize->Scaled[0.05],
           FontColor->GrayLevel[0],
           $CellContext`LineColor -> GrayLevel[0],
           $CellContext`FrontFaceColor -> GrayLevel[0],
           $CellContext`GraphicsColor -> GrayLevel[0],
           $CellContext`BackFaceColor -> GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 1],
        TagBox[
         GraphicsBox[{
           CircleBox[{0, 0}], 
           Hue[0.5], 
           DiskBox[{1, 1}]}], HoldForm]],
       Annotation[#, 
        HoldForm[
         Graphics[{
           Circle[{0, 0}], 
           Hue[0.5], 
           Disk[{1, 1}]}]], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["List", "StandardForm", "Output",
           StripOnInput->False,
           FontSize->Scaled[0.05],
           FontColor->GrayLevel[0],
           $CellContext`LineColor -> GrayLevel[0],
           $CellContext`FrontFaceColor -> GrayLevel[0],
           $CellContext`GraphicsColor -> GrayLevel[0],
           $CellContext`BackFaceColor -> GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 2],
        TagBox[
         RowBox[{"{", 
           RowBox[{
             RowBox[{"Circle", "[", 
               RowBox[{"{", 
                 RowBox[{"0", ",", "0"}], "}"}], "]"}], ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{
                   GrayLevel[0], 
                   RectangleBox[{0, 0}]}, {
                   GrayLevel[0], 
                   RectangleBox[{1, -1}]}, {
                   Hue[0.5], 
                   RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                 True, FrameStyle -> Hue[0.5, 1., 0.6666666666666667], 
                 FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], "Hue[0.5]"], Appearance -> None, 
               BaseStyle -> {}, BaselinePosition -> Baseline, 
               DefaultBaseStyle -> {}, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   Hue[0.5, 0.5, 0.5]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["HueColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              Hue[0.5], Editable -> False, Selectable -> False], ",", 
             RowBox[{"Disk", "[", 
               RowBox[{"{", 
                 RowBox[{"1", ",", "1"}], "}"}], "]"}]}], "}"}], HoldForm]],
       Annotation[#, 
        HoldForm[{
          Circle[{0, 0}], 
          Hue[0.5], 
          Disk[{1, 1}]}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["Circle", "StandardForm", "Output",
           StripOnInput->False,
           FontSize->Scaled[0.05],
           FontColor->GrayLevel[0],
           $CellContext`LineColor -> GrayLevel[0],
           $CellContext`FrontFaceColor -> GrayLevel[0],
           $CellContext`GraphicsColor -> GrayLevel[0],
           $CellContext`BackFaceColor -> GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 3],
        TagBox[
         RowBox[{"Circle", "[", 
           RowBox[{"{", 
             RowBox[{"0", ",", "0"}], "}"}], "]"}], HoldForm]],
       Annotation[#, 
        HoldForm[
         Circle[{0, 0}]], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["List", "StandardForm", "Output",
           StripOnInput->False,
           FontSize->Scaled[0.05],
           FontColor->GrayLevel[0],
           $CellContext`LineColor -> GrayLevel[0],
           $CellContext`FrontFaceColor -> GrayLevel[0],
           $CellContext`GraphicsColor -> GrayLevel[0],
           $CellContext`BackFaceColor -> GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 4],
        TagBox[
         RowBox[{"{", 
           RowBox[{"0", ",", "0"}], "}"}], HoldForm]],
       Annotation[#, 
        HoldForm[{0, 0}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["0",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FontSize->Scaled[0.05],
           FontColor->GrayLevel[0],
           $CellContext`LineColor -> GrayLevel[0],
           $CellContext`FrontFaceColor -> GrayLevel[0],
           $CellContext`GraphicsColor -> GrayLevel[0],
           $CellContext`BackFaceColor -> GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 5],
        TagBox["0", HoldForm]],
       Annotation[#, 
        HoldForm[0], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["0",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FontSize->Scaled[0.05],
           FontColor->GrayLevel[0],
           $CellContext`LineColor -> GrayLevel[0],
           $CellContext`FrontFaceColor -> GrayLevel[0],
           $CellContext`GraphicsColor -> GrayLevel[0],
           $CellContext`BackFaceColor -> GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 6],
        TagBox["0", HoldForm]],
       Annotation[#, 
        HoldForm[0], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["Hue", "StandardForm", "Output",
           StripOnInput->False,
           FontSize->Scaled[0.05],
           FontColor->GrayLevel[0],
           $CellContext`LineColor -> GrayLevel[0],
           $CellContext`FrontFaceColor -> GrayLevel[0],
           $CellContext`GraphicsColor -> GrayLevel[0],
           $CellContext`BackFaceColor -> GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 7],
        TagBox[
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{{
               GrayLevel[0], 
               RectangleBox[{0, 0}]}, {
               GrayLevel[0], 
               RectangleBox[{1, -1}]}, {
               Hue[0.5], 
               RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
             True, FrameStyle -> Hue[0.5, 1., 0.6666666666666667], FrameTicks -> 
             None, PlotRangePadding -> None, ImageSize -> 
             Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}]], "Hue[0.5]"], Appearance -> None, 
           BaseStyle -> {}, BaselinePosition -> Baseline, 
           DefaultBaseStyle -> {}, ButtonFunction :> 
           With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = 
               Hue[0.5, 0.5, 0.5]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["HueColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
            BaseStyle -> Inherited, Evaluator -> Automatic, Method -> 
           "Preemptive"], 
          Hue[0.5], Editable -> False, Selectable -> False], HoldForm]],
       Annotation[#, 
        HoldForm[
         Hue[0.5]], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["0.5`",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FontSize->Scaled[0.05],
           FontColor->GrayLevel[0],
           $CellContext`LineColor -> GrayLevel[0],
           $CellContext`FrontFaceColor -> GrayLevel[0],
           $CellContext`GraphicsColor -> GrayLevel[0],
           $CellContext`BackFaceColor -> GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 8],
        TagBox["0.5`", HoldForm]],
       Annotation[#, 
        HoldForm[0.5], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["Disk", "StandardForm", "Output",
           StripOnInput->False,
           FontSize->Scaled[0.05],
           FontColor->GrayLevel[0],
           $CellContext`LineColor -> GrayLevel[0],
           $CellContext`FrontFaceColor -> GrayLevel[0],
           $CellContext`GraphicsColor -> GrayLevel[0],
           $CellContext`BackFaceColor -> GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 9],
        TagBox[
         RowBox[{"Disk", "[", 
           RowBox[{"{", 
             RowBox[{"1", ",", "1"}], "}"}], "]"}], HoldForm]],
       Annotation[#, 
        HoldForm[
         Disk[{1, 1}]], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox["List", "StandardForm", "Output",
           StripOnInput->False,
           FontSize->Scaled[0.05],
           FontColor->GrayLevel[0],
           $CellContext`LineColor -> GrayLevel[0],
           $CellContext`FrontFaceColor -> GrayLevel[0],
           $CellContext`GraphicsColor -> GrayLevel[0],
           $CellContext`BackFaceColor -> GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 10],
        TagBox[
         RowBox[{"{", 
           RowBox[{"1", ",", "1"}], "}"}], HoldForm]],
       Annotation[#, 
        HoldForm[{1, 1}], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["1",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FontSize->Scaled[0.05],
           FontColor->GrayLevel[0],
           $CellContext`LineColor -> GrayLevel[0],
           $CellContext`FrontFaceColor -> GrayLevel[0],
           $CellContext`GraphicsColor -> GrayLevel[0],
           $CellContext`BackFaceColor -> GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 11],
        TagBox["1", HoldForm]],
       Annotation[#, 
        HoldForm[1], "Tooltip"]& ], 
      TagBox[
       TooltipBox[InsetBox[
         FrameBox[
          StyleBox[
           TagBox["1",
            HoldForm], "StandardForm", "Output",
           StripOnInput->False,
           FontSize->Scaled[0.05],
           FontColor->GrayLevel[0],
           $CellContext`LineColor -> GrayLevel[0],
           $CellContext`FrontFaceColor -> GrayLevel[0],
           $CellContext`GraphicsColor -> GrayLevel[0],
           $CellContext`BackFaceColor -> GrayLevel[0]],
          Background->RGBColor[1., 1., 0.871],
          FrameStyle->GrayLevel[0.5],
          StripOnInput->False], 12],
        TagBox["1", HoldForm]],
       Annotation[#, 
        HoldForm[1], "Tooltip"]& ]}}],
   Annotation[#, 
    VertexCoordinateRules -> {{1.3296078906418773`, 3.5456210417116734`}, {
     1.3296078906418773`, 2.659215781283755}, {0.44320263021395917`, 
     1.7728105208558367`}, {0.44320263021395917`, 0.8864052604279187}, {0., 
     0.}, {0.8864052604279183, 0.}, {1.3296078906418773`, 
     1.7728105208558367`}, {1.3296078906418773`, 0.8864052604279187}, {
     2.2160131510697956`, 1.7728105208558367`}, {2.2160131510697956`, 
     0.8864052604279187}, {1.7728105208558367`, 0.}, {2.6592157812837547`, 
     0.}}]& ],
  AspectRatio->NCache[Rational[10, 13]^Rational[1, 2], 0.8770580193070292],
  FrameTicks->Automatic,
  ImageSize->{167.546875, Automatic},
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->
  "Out[15]//TreeForm=",ExpressionUUID->"ae684ee1-dcbd-4e9c-aec9-a4d31a497849"]
}, Open  ]],

Cell["\<\
Because expressions ultimately have a very uniform structure, operations in \
the Wolfram Language operate in a very uniform way on them.\
\>", "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->
  "LastCellOfAPage",ExpressionUUID->"a6c34c1a-de4f-4bf1-9604-d6ceff71c2ac"],

Cell[TextData[{
 "For example, any expression has parts, just like a list, and you can \
extract them using ",
 StyleBox[ButtonBox["[[",
  BaseStyle->"Link",
  ButtonData->"Part"], "InlineCodeText"],
 StyleBox[ButtonBox["...",
  BaseStyle->"Link",
  ButtonData->"Part"], "InlineCodeText",
  FontColor->GrayLevel[0.6]],
 StyleBox[ButtonBox["]]",
  BaseStyle->"Link",
  ButtonData->"Part"], "InlineCodeText"],
 "."
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->{
  "p:200", "i:8"},ExpressionUUID->"45562985-db84-4d8c-bacb-99dc16da4d67"],

Cell[TextData[{
 "This is equivalent to ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}], "[", 
   RowBox[{"[", "2", "]"}], "]"}]], "InlineCode",ExpressionUUID->
  "2cf84f20-fb50-490a-90f4-b5e739aa65ee"],
 ", which extracts the second element in a list:"
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"4d2d6cda-5774-4dc8-ab4b-92bb289dc878"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"List", "[", 
   RowBox[{"x", ",", "y", ",", "z"}], "]"}], "[", 
  RowBox[{"[", "2", "]"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[16]:=",ExpressionUUID->"8d14652b-818e-4331-9354-0e306f0d86c9"],

Cell[BoxData["y"], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[16]=",ExpressionUUID->"05d1c7f4-fdf4-4cc5-8d10-4dd9f97dbf60"]
}, Open  ]],

Cell["\<\
Extracting parts works exactly the same way for this expression:\
\>", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"e8d382bb-c761-4b0f-bd27-5854e1257d9d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", 
   RowBox[{"x", ",", "y", ",", "z"}], "]"}], "[", 
  RowBox[{"[", "2", "]"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[17]:=",ExpressionUUID->"803ecb92-ab93-4262-98c8-9c3dbaf1dba9"],

Cell[BoxData["y"], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[17]=",ExpressionUUID->"3a8d7f77-8fa5-4128-8632-ec0ab0f9bf19"]
}, Open  ]],

Cell["This extracts the circle from the graphics:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"0aacd68a-9c83-4788-82dc-e6350d838659"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Graphics", "[", 
   RowBox[{"Circle", "[", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0"}], "}"}], "]"}], "]"}], "[", 
  RowBox[{"[", "1", "]"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[18]:=",ExpressionUUID->"1457a7d8-1720-41fa-92b1-12f1981723f5"],

Cell[BoxData[
 RowBox[{"Circle", "[", 
  RowBox[{"{", 
   RowBox[{"0", ",", "0"}], "}"}], "]"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[18]=",ExpressionUUID->"8bfa2289-4b48-4221-a67c-86b830b5c2b7"]
}, Open  ]],

Cell["This goes on and extracts the coordinates of its center:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"55566c5b-f669-4c15-9fc3-b7141b25d19b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Graphics", "[", 
   RowBox[{"Circle", "[", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0"}], "}"}], "]"}], "]"}], "[", 
  RowBox[{"[", 
   RowBox[{"1", ",", "1"}], "]"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[19]:=",ExpressionUUID->"e3dec8e8-c42e-4c5b-b17f-f44b333e70a5"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "0"}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[19]=",ExpressionUUID->"695172bf-194a-4517-99fe-372350c6b780"]
}, Open  ]],

Cell["This works exactly the same:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"6f2197e2-aaae-4f1f-9fa6-76a4e3ec3e5f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  GraphicsBox[CircleBox[{0, 0}],
   ImageSize->{37.67578125, Automatic}], "[", 
  RowBox[{"[", 
   RowBox[{"1", ",", "1"}], "]"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[20]:=",ExpressionUUID->"bd321e08-32da-4325-8a1f-fbddf9e58b79"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "0"}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[20]=",ExpressionUUID->"e6ff5f53-2167-4ee5-9a20-498c71b7029d"]
}, Open  ]],

Cell[TextData[{
 "In ",
 Cell[BoxData[
  RowBox[{"f", "[", 
   RowBox[{"x", ",", "y"}], "]"}]], "InlineCodeText",ExpressionUUID->
  "b77d03b5-6f8e-4ce3-966a-750ce89a8b45"],
 ", ",
 Cell[BoxData[
 "f"], "InlineCodeText",ExpressionUUID->
  "ee801525-234a-4186-8772-e93ead39c4fb"],
 " is called the ",
 StyleBox["head",
  FontSlant->"Italic"],
 " of the expression. ",
 Cell[BoxData[
 "x"], "InlineCodeText",ExpressionUUID->
  "f4c76149-dac8-4b64-bd31-5296d8d23901"],
 " and ",
 Cell[BoxData[
 "y"], "InlineCodeText",ExpressionUUID->
  "eedf95c8-0439-46de-ba1e-40f6483539d5"],
 " are called ",
 StyleBox["arguments",
  FontSlant->"Italic"],
 ". The function ",
 ButtonBox["Head",
  BaseStyle->"Link"],
 " extracts the head of an expression."
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:9",ExpressionUUID->"ba786b0c-64b3-4c4c-8a08-10bd89e19e79"],

Cell[TextData[{
 "The head of a list is ",
 ButtonBox["List",
  BaseStyle->"Link"],
 ":"
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"c8ad02be-a6ac-483f-ae55-f76f2f66568f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Head", "[", 
  RowBox[{"{", 
   RowBox[{"x", ",", "y", ",", "z"}], "}"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[21]:=",ExpressionUUID->"2c0991c1-55d7-4f45-94e8-d37bd079973c"],

Cell[BoxData["List"], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[21]=",ExpressionUUID->"88683c3d-5442-483d-8a5e-ec392d1e4480"]
}, Open  ]],

Cell["Every part of an expression has a head, even its atoms.", "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"10c70bbc-7d28-4ca8-b2ed-0b099a316bb2"],

Cell[TextData[{
 "The head of an integer is ",
 ButtonBox["Integer",
  BaseStyle->"Link"],
 ":"
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"68f2cce6-f852-49a7-86cd-510141b92b3b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Head", "[", "1234", "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[22]:=",ExpressionUUID->"4b716e61-f334-4a16-a542-83b74ee9af30"],

Cell[BoxData["Integer"], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[22]=",ExpressionUUID->"8e665b1f-6a8d-411a-980d-7d38d36aaa93"]
}, Open  ]],

Cell[TextData[{
 "The head of an approximate real number is ",
 ButtonBox["Real",
  BaseStyle->"Link"],
 ":"
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"5f3888cf-ad97-42b9-a920-d89e4eb00634"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Head", "[", "12.45", "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[23]:=",ExpressionUUID->"a459053a-d415-466c-a551-e706b3debc0a"],

Cell[BoxData["Real"], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellTags->"LastCellOfAPage",
 CellLabel->"Out[23]=",ExpressionUUID->"acbdc865-8b37-4952-b9ea-d55a06430b2d"]
}, Open  ]],

Cell[TextData[{
 "The head of a string is ",
 ButtonBox["String",
  BaseStyle->"Link"],
 ":"
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"dd90d3ed-8727-4fbf-a502-ad12295509be"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Head", "[", "\"\<hello\>\"", "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[24]:=",ExpressionUUID->"add76fbc-49d2-409d-b072-f8ff65d1d41a"],

Cell[BoxData["String"], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[24]=",ExpressionUUID->"1584635d-75b5-4b12-ae3b-9c22aa3642c0"]
}, Open  ]],

Cell[TextData[{
 "Even symbols have a head: ",
 ButtonBox["Symbol",
  BaseStyle->"Link"],
 "."
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"p:201",ExpressionUUID->"5403745f-b65a-4400-994c-7cdac8944869"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Head", "[", "x", "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[25]:=",ExpressionUUID->"e5fcd9da-ec0e-429e-855c-cd3273b977db"],

Cell[BoxData["Symbol"], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[25]=",ExpressionUUID->"a577a0cf-3f64-4e6c-a2e5-f922aba02d0b"]
}, Open  ]],

Cell[TextData[{
 "In patterns, you can ask to match expressions with particular heads. ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["_",
    BaseStyle->"Link",
    ButtonData->"Blank"], 
   ButtonBox["Integer",
    BaseStyle->"CodeLink"]}]], "InlineCodeText",ExpressionUUID->
  "162cccac-7e59-43e4-b5ce-942be27cb8d1"],
 " represents any integer, ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["_",
    BaseStyle->"Link",
    ButtonData->"Blank"], 
   ButtonBox["String",
    BaseStyle->"CodeLink"]}]], "InlineCodeText",ExpressionUUID->
  "fb72057d-e7b8-441b-8cbd-7087a7163278"],
 " any string and so on."
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"63f33c94-9e86-4451-8b06-47366a130a17"],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["_",
    BaseStyle->"Link",
    ButtonData->"Blank"], 
   ButtonBox["Integer",
    BaseStyle->"CodeLink"]}]], "InlineCode",ExpressionUUID->
  "f1a4e9da-34c5-4113-bf81-74c55451ba38"],
 " is a pattern that matches only objects with head ",
 ButtonBox["Integer",
  BaseStyle->"Link"],
 ":"
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:10",ExpressionUUID->"f0b587a8-bc5a-413d-b876-b9acdfe2f9c2"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Cases", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "3", ",", "4", ",", "z", ",", "6", ",", "7"}],
     "}"}], ",", "_Integer"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[26]:=",ExpressionUUID->"af10535c-5646-4ae1-bf90-3299ba43b792"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3", ",", "4", ",", "6", ",", "7"}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[26]=",ExpressionUUID->"90787327-9a6b-4d02-8250-69d749fc944d"]
}, Open  ]],

Cell["Named patterns can have specified heads too:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"ec721d79-9d90-4bf3-992a-8b11eb7ff2e0"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Cases", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"99", ",", "x", ",", "y", ",", "z", ",", "101", ",", "102"}], 
    "}"}], ",", 
   RowBox[{"n_Integer", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"n", ",", "n"}], "}"}]}]}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[27]:=",ExpressionUUID->"f81287ab-02b5-49ec-a253-a82a1c540b86"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"99", ",", "99"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"101", ",", "101"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"102", ",", "102"}], "}"}]}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[27]=",ExpressionUUID->"2b73a922-1a2f-499a-bd09-bd978042e8b4"]
}, Open  ]],

Cell["\<\
In using the Wolfram Language, most of the heads you\[CloseCurlyQuote]ll see \
are symbols. But there are important cases where there are more complicated \
heads. One such case is pure functions\[LongDash]where when you apply a pure \
function, the pure function appears as the head.\
\>", "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:11",ExpressionUUID->"ef980fdc-7213-4ea8-a697-181fd008b8c5"],

Cell[TextData[{
 "Here is the full form of a pure function (",
 Cell[BoxData[
  ButtonBox["#",
   BaseStyle->"Link",
   ButtonData->"Slot"]], "InlineCode",ExpressionUUID->
  "f0482f92-eb9a-455d-a127-9765ccd1670d"],
 " is ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Slot",
    BaseStyle->"CodeLink"], "[", "1", "]"}]], "InlineCode",ExpressionUUID->
  "92696322-5e80-4430-b7d0-15bb1b9f173f"],
 "):"
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"45034f1b-347c-407a-a80e-5d3a42c3f84f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullForm", "[", 
  RowBox[{
   RowBox[{"#", "^", "2"}], "&"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[28]:=",ExpressionUUID->"1a9475d9-1d4f-4218-b05f-04e6c0512699"],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"Function", "[", 
    RowBox[{"Power", "[", 
     RowBox[{
      RowBox[{"Slot", "[", "1", "]"}], ",", "2"}], "]"}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->
  "Out[28]//FullForm=",ExpressionUUID->"734c043f-667f-4e60-b0f0-89a2b96f45a2"]
}, Open  ]],

Cell["When you apply the pure function, it appears as a head:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"3b4dedf7-8544-473c-815b-1e14b8fc39e7"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Function", "[", 
   RowBox[{"Power", "[", 
    RowBox[{
     RowBox[{"Slot", "[", "1", "]"}], ",", "2"}], "]"}], "]"}], " ", "[", 
  "1000", "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[29]:=",ExpressionUUID->"757508af-66b2-4125-96ab-607c624ce9f8"],

Cell[BoxData["1000000"], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[29]=",ExpressionUUID->"26644c3f-e27f-4625-bdb1-8384ef808dab"]
}, Open  ]],

Cell[TextData[{
 "As you become more sophisticated in Wolfram Language programming, you\
\[CloseCurlyQuote]ll encounter more and more examples of complicated heads. \
In fact, many functions that we\[CloseCurlyQuote]ve already discussed have ",
 StyleBox["operator forms",
  FontSlant->"Italic"],
 " where they appear as heads\[LongDash]and using them in this way leads to \
very powerful and elegant styles of programming. "
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:12",ExpressionUUID->"fcf5a5e4-d273-4b60-8115-41f56e27dc2e"],

Cell[TextData[{
 ButtonBox["Select",
  BaseStyle->"Link"],
 " appears as a head here:"
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:13",ExpressionUUID->"c37f5ea5-cb1f-4c6d-8283-ac50d9fb38eb"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Select", "[", 
   RowBox[{
    RowBox[{"#", ">", "4"}], "&"}], "]"}], "[", 
  RowBox[{"{", 
   RowBox[{
   "1", ",", "2.2", ",", "3", ",", "4.5", ",", "5", ",", "6", ",", "7.5", ",",
     "8"}], "}"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[30]:=",ExpressionUUID->"b3c3d045-08f3-4013-9ee4-de833a7b5e2e"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"4.5`", ",", "5", ",", "6", ",", "7.5`", ",", "8"}], 
  "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellTags->"LastCellOfAPage",
 CellLabel->"Out[30]=",ExpressionUUID->"cdf106fd-52ca-4467-a117-3cbef0e41485"]
}, Open  ]],

Cell[TextData[{
 "Both ",
 ButtonBox["Cases",
  BaseStyle->"Link"],
 " and ",
 ButtonBox["Select",
  BaseStyle->"Link"],
 " ",
 "appear as",
 " heads here:"
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:14",ExpressionUUID->"df61b02e-1c8f-422d-890b-50c3c6755712"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Cases", "[", "_Integer", "]"}], "@", 
  RowBox[{
   RowBox[{"Select", "[", 
    RowBox[{
     RowBox[{"#", ">", "4"}], "&"}], "]"}], "@", 
   RowBox[{"{", 
    RowBox[{
    "1", ",", "2.2", ",", "3", ",", "4.5", ",", "5", ",", "6", ",", "7.5", 
     ",", "8"}], "}"}]}]}]], "Input",
 Deletable->False,
 CellLabel->"In[31]:=",ExpressionUUID->"7c17e69d-f763-4faa-8fad-8808a21f6613"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"5", ",", "6", ",", "8"}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[31]=",ExpressionUUID->"00c79339-8922-4d08-b467-fb8347dfb9e6"]
}, Open  ]],

Cell["\<\
All the basic structural operations that we have seen for lists work exactly \
the same for arbitrary expressions.\
\>", "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->{
  "p:202", "i:15"},ExpressionUUID->"10f7fb48-8154-4724-a497-c3fe419eb856"],

Cell[TextData[{
 ButtonBox["Length",
  BaseStyle->"Link"],
 " does not care what the head of an expression is; it just counts \
arguments:"
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"4ab27f76-032a-4832-8de9-a46f57e5a02d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "[", 
  RowBox[{"f", "[", 
   RowBox[{"x", ",", "y", ",", "z"}], "]"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[32]:=",ExpressionUUID->"62ca714e-d17f-407d-8c62-f441f66b2fcc"],

Cell[BoxData["3"], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[32]=",ExpressionUUID->"23098f24-3c73-4669-a9e4-6bd0820459bb"]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["/@",
   BaseStyle->"Link",
   ButtonData->"Map"]], "InlineCode",ExpressionUUID->
  "ba19321a-d988-4aa7-9aa5-ae1769793074"],
 " does not care about the head of an expression either; it just applies a \
function to the arguments:"
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"c61d2799-bd44-43d5-b82b-d7b32cafd26c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "/@", 
  RowBox[{"g", "[", 
   RowBox[{"x", ",", "y", ",", "z"}], "]"}]}]], "Input",
 Deletable->False,
 CellLabel->"In[33]:=",ExpressionUUID->"c729c2a2-2f88-4e44-ac4d-ffa944779c05"],

Cell[BoxData[
 RowBox[{"g", "[", 
  RowBox[{
   RowBox[{"f", "[", "x", "]"}], ",", 
   RowBox[{"f", "[", "y", "]"}], ",", 
   RowBox[{"f", "[", "z", "]"}]}], "]"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[33]=",ExpressionUUID->"f27b6390-3b1d-47b8-a5d7-8eaded6298e7"]
}, Open  ]],

Cell["\<\
Since there are lots of functions that generate lists, it\[CloseCurlyQuote]s \
often convenient to build up structures as lists even if eventually one needs \
to replace the lists with other functions. \
\>", "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"7eb06f79-c17b-44b5-bf9f-80ea532e697b"],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["@@",
   BaseStyle->"Link",
   ButtonData->"Apply"]], "InlineCode",ExpressionUUID->
  "598becb8-d259-4e66-a797-e3825359aad6"],
 " effectively replaces the head of the list with ",
 Cell[BoxData[
 "f"], "InlineCode",ExpressionUUID->"6e7d41f1-5e37-4b7f-b960-25228c50d081"],
 ":"
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"b50dad31-7846-4a4b-a352-278fb81a43b9"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "@@", 
  RowBox[{"{", 
   RowBox[{"x", ",", "y", ",", "z"}], "}"}]}]], "Input",
 Deletable->False,
 CellLabel->"In[34]:=",ExpressionUUID->"8176e7a2-a194-4c1e-98e5-b9a76c63a86a"],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"x", ",", "y", ",", "z"}], "]"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[34]=",ExpressionUUID->"b1c9843f-f9ed-479d-a8bd-48273d9e5137"]
}, Open  ]],

Cell[TextData[{
 "This yields ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Plus",
    BaseStyle->"CodeLink"], "[", 
   RowBox[{"1", ",", "1", ",", "1", ",", "1"}], "]"}]], "InlineCode",
  ExpressionUUID->"9c925ad0-ce08-4979-a6d3-c4feb79908b7"],
 ", which then evaluates:"
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"4b4b4b79-dcb1-4f73-a526-cf4adf81c185"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plus", "@@", 
  RowBox[{"{", 
   RowBox[{"1", ",", "1", ",", "1", ",", "1"}], "}"}]}]], "Input",
 Deletable->False,
 CellLabel->"In[35]:=",ExpressionUUID->"e82ac7f7-706c-493e-8a00-468ae8025ad5"],

Cell[BoxData["4"], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[35]=",ExpressionUUID->"94ae40cd-f5ec-4e17-aca4-3f74a96c8b33"]
}, Open  ]],

Cell["This turns a list into a rule:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"7f1c8f2f-1b1e-4a5c-9648-a541f7339d47"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"#1", "\[Rule]", "#2"}], "&"}], "@@", 
  RowBox[{"{", 
   RowBox[{"x", ",", "y"}], "}"}]}]], "Input",
 Deletable->False,
 CellLabel->"In[36]:=",ExpressionUUID->"5b78afc7-4270-42fa-84db-8549f723f4ed"],

Cell[BoxData[
 RowBox[{"x", "\[Rule]", "y"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[36]=",ExpressionUUID->"b6837c94-a31e-461f-a2af-aaf2f73c7b2e"]
}, Open  ]],

Cell["\<\
Here\[CloseCurlyQuote]s a simpler alternative, without the explicit pure \
function:\
\>", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"7b5440ca-243a-4336-a0ff-3c87a70774fa"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Rule", "@@", 
  RowBox[{"{", 
   RowBox[{"x", ",", "y"}], "}"}]}]], "Input",
 Deletable->False,
 CellLabel->"In[37]:=",ExpressionUUID->"57e5c492-48e0-44b1-b5be-066dce703884"],

Cell[BoxData[
 RowBox[{"x", "\[Rule]", "y"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[37]=",ExpressionUUID->"f9a65819-3b63-40a1-a85f-1ce56ad9e084"]
}, Open  ]],

Cell[TextData[{
 "A surprisingly common situation is to have a list of lists, and to want to \
replace the inner lists with some function. It\[CloseCurlyQuote]s possible to \
do this with ",
 Cell[BoxData[
  ButtonBox["@@",
   BaseStyle->"Link",
   ButtonData->"Apply"]], "InlineCodeText",ExpressionUUID->
  "48da5289-8c04-49c3-9772-c55bda92b9bc"],
 " and ",
 Cell[BoxData[
  ButtonBox["/@",
   BaseStyle->"Link",
   ButtonData->"Map"]], "InlineCodeText",ExpressionUUID->
  "6d252959-9fc2-4c1d-aa6a-0164201f9bc4"],
 ". But ",
 Cell[BoxData[
  ButtonBox["@@@",
   BaseStyle->"Link",
   ButtonData->"Apply"]], "InlineCodeText",ExpressionUUID->
  "57d2b016-568b-4338-b3ed-31bbbfe1fa97"],
 " provides a convenient direct way to do it."
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"5d50ab3d-ed84-48cc-adba-7484754725b0"],

Cell[TextData[{
 "Replace the inner lists with ",
 Cell[BoxData[
 "f"], "InlineCode",ExpressionUUID->"9bdb7b16-240a-4540-972e-e46a7da2cf8b"],
 ":"
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"8bd196d3-9c3b-4d71-9a5e-405684c22f8d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "@@@", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"4", ",", "5", ",", "6"}], "}"}]}], "}"}]}]], "Input",
 Deletable->False,
 CellLabel->"In[38]:=",ExpressionUUID->"0c7d7912-fc02-48cc-8b96-1d697b525085"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"1", ",", "2", ",", "3"}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"4", ",", "5", ",", "6"}], "]"}]}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellTags->"LastCellOfAPage",
 CellLabel->"Out[38]=",ExpressionUUID->"52945471-3ef7-4bc5-b360-2dff21e886b9"]
}, Open  ]],

Cell["Turn the inner lists into rules:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"p:203",ExpressionUUID->"e908163f-e091-4206-ad67-247ead30abaa"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Rule", "@@@", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "10"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"2", ",", "20"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"3", ",", "30"}], "}"}]}], "}"}]}]], "Input",
 Deletable->False,
 CellLabel->"In[39]:=",ExpressionUUID->"ce0afa80-5621-4846-915d-d98ef4dc95b2"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"1", "\[Rule]", "10"}], ",", 
   RowBox[{"2", "\[Rule]", "20"}], ",", 
   RowBox[{"3", "\[Rule]", "30"}]}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[39]=",ExpressionUUID->"25d106bc-cb40-407b-a4d9-b7c3b0cc452b"]
}, Open  ]],

Cell[TextData[{
 "Here\[CloseCurlyQuote]s an example of how ",
 Cell[BoxData[
  ButtonBox["@@@",
   BaseStyle->"Link",
   ButtonData->"Apply"]], "InlineCodeText",ExpressionUUID->
  "6cb688cd-39b5-4df1-911d-83185825247b"],
 " can help construct a graph from a list of pairs."
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:16",ExpressionUUID->"9670afe8-8465-434c-85a5-be314e138421"],

Cell["This generates a list of pairs of characters:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"43347c9c-88d7-464b-8a3f-71713643d128"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Partition", "[", 
  RowBox[{
   RowBox[{"Characters", "[", "\"\<antidisestablishmentarianism\>\"", "]"}], 
   ",", "2", ",", "1"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[40]:=",ExpressionUUID->"fe3a3389-aeca-4fa0-9323-ddea630f7c8d"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"a\"\>", ",", "\<\"n\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"n\"\>", ",", "\<\"t\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"t\"\>", ",", "\<\"i\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"i\"\>", ",", "\<\"d\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"d\"\>", ",", "\<\"i\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"i\"\>", ",", "\<\"s\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"s\"\>", ",", "\<\"e\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"e\"\>", ",", "\<\"s\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"s\"\>", ",", "\<\"t\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"t\"\>", ",", "\<\"a\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"a\"\>", ",", "\<\"b\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"b\"\>", ",", "\<\"l\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"l\"\>", ",", "\<\"i\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"i\"\>", ",", "\<\"s\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"s\"\>", ",", "\<\"h\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"h\"\>", ",", "\<\"m\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"m\"\>", ",", "\<\"e\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"e\"\>", ",", "\<\"n\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"n\"\>", ",", "\<\"t\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"t\"\>", ",", "\<\"a\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"a\"\>", ",", "\<\"r\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"r\"\>", ",", "\<\"i\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"i\"\>", ",", "\<\"a\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"a\"\>", ",", "\<\"n\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"n\"\>", ",", "\<\"i\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"i\"\>", ",", "\<\"s\"\>"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"s\"\>", ",", "\<\"m\"\>"}], "}"}]}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[40]=",ExpressionUUID->"df7b4b43-f864-4be2-9e69-7382733237c4"]
}, Open  ]],

Cell["Turn this into a list of rules:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:17",ExpressionUUID->"c8d653fb-43ad-4189-b469-21ad40fd2591"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Rule", "@@@", 
  RowBox[{"Partition", "[", 
   RowBox[{
    RowBox[{"Characters", "[", "\"\<antidisestablishmentarianism\>\"", "]"}], 
    ",", "2", ",", "1"}], "]"}]}]], "Input",
 Deletable->False,
 CellLabel->"In[41]:=",ExpressionUUID->"994431fd-7060-456e-a1f9-24236f8674e3"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"\<\"a\"\>", "\[Rule]", "\<\"n\"\>"}], ",", 
   RowBox[{"\<\"n\"\>", "\[Rule]", "\<\"t\"\>"}], ",", 
   RowBox[{"\<\"t\"\>", "\[Rule]", "\<\"i\"\>"}], ",", 
   RowBox[{"\<\"i\"\>", "\[Rule]", "\<\"d\"\>"}], ",", 
   RowBox[{"\<\"d\"\>", "\[Rule]", "\<\"i\"\>"}], ",", 
   RowBox[{"\<\"i\"\>", "\[Rule]", "\<\"s\"\>"}], ",", 
   RowBox[{"\<\"s\"\>", "\[Rule]", "\<\"e\"\>"}], ",", 
   RowBox[{"\<\"e\"\>", "\[Rule]", "\<\"s\"\>"}], ",", 
   RowBox[{"\<\"s\"\>", "\[Rule]", "\<\"t\"\>"}], ",", 
   RowBox[{"\<\"t\"\>", "\[Rule]", "\<\"a\"\>"}], ",", 
   RowBox[{"\<\"a\"\>", "\[Rule]", "\<\"b\"\>"}], ",", 
   RowBox[{"\<\"b\"\>", "\[Rule]", "\<\"l\"\>"}], ",", 
   RowBox[{"\<\"l\"\>", "\[Rule]", "\<\"i\"\>"}], ",", 
   RowBox[{"\<\"i\"\>", "\[Rule]", "\<\"s\"\>"}], ",", 
   RowBox[{"\<\"s\"\>", "\[Rule]", "\<\"h\"\>"}], ",", 
   RowBox[{"\<\"h\"\>", "\[Rule]", "\<\"m\"\>"}], ",", 
   RowBox[{"\<\"m\"\>", "\[Rule]", "\<\"e\"\>"}], ",", 
   RowBox[{"\<\"e\"\>", "\[Rule]", "\<\"n\"\>"}], ",", 
   RowBox[{"\<\"n\"\>", "\[Rule]", "\<\"t\"\>"}], ",", 
   RowBox[{"\<\"t\"\>", "\[Rule]", "\<\"a\"\>"}], ",", 
   RowBox[{"\<\"a\"\>", "\[Rule]", "\<\"r\"\>"}], ",", 
   RowBox[{"\<\"r\"\>", "\[Rule]", "\<\"i\"\>"}], ",", 
   RowBox[{"\<\"i\"\>", "\[Rule]", "\<\"a\"\>"}], ",", 
   RowBox[{"\<\"a\"\>", "\[Rule]", "\<\"n\"\>"}], ",", 
   RowBox[{"\<\"n\"\>", "\[Rule]", "\<\"i\"\>"}], ",", 
   RowBox[{"\<\"i\"\>", "\[Rule]", "\<\"s\"\>"}], ",", 
   RowBox[{"\<\"s\"\>", "\[Rule]", "\<\"m\"\>"}]}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[41]=",ExpressionUUID->"1b5fae82-b6c0-47d2-a755-eb815ee84f70"]
}, Open  ]],

Cell[TextData[{
 "Form a ",
 StyleBox["transition graph",
  FontSlant->"Italic"],
 " showing how letters follow each other:"
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:18",ExpressionUUID->"df89672c-3169-4f73-a150-7a24ef977bf0"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graph", "[", 
  RowBox[{
   RowBox[{"Rule", "@@@", 
    RowBox[{"Partition", "[", 
     RowBox[{
      RowBox[{
      "Characters", "[", "\"\<antidisestablishmentarianism\>\"", "]"}], ",", 
      "2", ",", "1"}], "]"}]}], ",", 
   RowBox[{"VertexLabels", "\[Rule]", "All"}]}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[42]:=",ExpressionUUID->"1ba1d10a-e1a7-45c5-a582-d7aefc40eb52"],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{
      "a", "n", "t", "i", "d", "s", "e", "b", "l", "h", "m", "r"}, {{{1, 2}, {
       2, 3}, {3, 4}, {4, 5}, {5, 4}, {4, 6}, {6, 7}, {7, 6}, {6, 3}, {3, 
       1}, {1, 8}, {8, 9}, {9, 4}, {4, 6}, {6, 10}, {10, 11}, {11, 7}, {7, 
       2}, {2, 3}, {3, 1}, {1, 12}, {12, 4}, {4, 1}, {1, 2}, {2, 4}, {4, 6}, {
       6, 11}}, Null}, {VertexLabels -> {All}}]]}, 
    TagBox[GraphicsGroupBox[{
       {Hue[0.6, 0.7, 0.5], Opacity[0.7], Arrowheads[Medium], 
        ArrowBox[BezierCurveBox[{{2.9885651651611287`, 1.871198195975713}, {
         2.476947672934284, 1.8427055726349661`}, {2.048291629199657, 
         2.1234515149168427`}}], 0.037111594667210424`], 
        ArrowBox[BezierCurveBox[{{2.9885651651611287`, 1.871198195975713}, {
         2.5599091214264953`, 2.151944138253546}, {2.048291629199657, 
         2.1234515149168427`}}], 0.037111594667210424`], 
        ArrowBox[{{2.9885651651611287`, 1.871198195975713}, {
         4.016611321633045, 2.353533984982435}}, 0.037111594667210424`], 
        ArrowBox[{{2.9885651651611287`, 1.871198195975713}, {
         3.401612309872764, 1.0060397467263793`}}, 0.037111594667210424`], 
        ArrowBox[BezierCurveBox[{{2.048291629199657, 2.1234515149168427`}, {
         2.1318742268007855`, 1.8358458601777203`}, {2.028428884192558, 
         1.554772694693877}}], 0.037111594667210424`], 
        ArrowBox[BezierCurveBox[{{2.048291629199657, 2.1234515149168427`}, {
         1.9448462865914338`, 1.8423783494245265`}, {2.028428884192558, 
         1.554772694693877}}], 0.037111594667210424`], 
        ArrowBox[{{2.048291629199657, 2.1234515149168427`}, {
         2.578947233115036, 1.2123903488018222`}}, 0.037111594667210424`], 
        ArrowBox[BezierCurveBox[{{2.028428884192558, 1.554772694693877}, {
         2.4564637788182657`, 1.870870972780675}, {2.9885651651611287`, 
         1.871198195975713}}], 0.037111594667210424`], 
        ArrowBox[BezierCurveBox[{{2.028428884192558, 1.554772694693877}, {
         2.5605302705354265`, 1.5550999178925338`}, {2.9885651651611287`, 
         1.871198195975713}}], 0.037111594667210424`], 
        ArrowBox[{{2.028428884192558, 1.554772694693877}, {2.578947233115036, 
         1.2123903488018222`}}, 0.037111594667210424`], 
        ArrowBox[{{2.578947233115036, 1.2123903488018222`}, {
         2.9885651651611287`, 1.871198195975713}}, 0.037111594667210424`], 
        ArrowBox[BezierCurveBox[{{2.578947233115036, 1.2123903488018222`}, {
         2.869268685523592, 0.6361086162337887}, {2.760857388262999, 0.}}], 
         0.037111594667210424`], 
        ArrowBox[BezierCurveBox[{{2.578947233115036, 1.2123903488018222`}, {
         1.8109088122352357`, 1.0590128729763972`}, {1.1017612834765285`, 
         1.3914545197263153`}}], 0.037111594667210424`], 
        ArrowBox[{{2.578947233115036, 1.2123903488018222`}, {
         1.1017612834765285`, 1.3914545197263153`}}, 0.037111594667210424`], 
        ArrowBox[BezierCurveBox[{{2.578947233115036, 1.2123903488018222`}, {
         1.8697997043563348`, 1.5448319955510428`}, {1.1017612834765285`, 
         1.3914545197263153`}}], 0.037111594667210424`], 
        ArrowBox[BezierCurveBox[{{2.760857388262999, 0.}, {
         2.4705359358544454`, 0.5762817325682235}, {2.578947233115036, 
         1.2123903488018222`}}], 0.037111594667210424`], 
        ArrowBox[{{1.1017612834765285`, 1.3914545197263153`}, {
         2.028428884192558, 1.554772694693877}}, 0.037111594667210424`], 
        ArrowBox[BezierCurveBox[{{1.1017612834765285`, 1.3914545197263153`}, {
         0.8753129955679791, 1.7673281265518261`}, {0.9161741253778872, 
         2.2042379152578073`}}], 0.037111594667210424`], 
        ArrowBox[{{1.1017612834765285`, 1.3914545197263153`}, {0., 
         1.0871201056005553`}}, 0.037111594667210424`], 
        ArrowBox[{{1.1017612834765285`, 1.3914545197263153`}, {
         0.1771080921377448, 1.7613344937463582`}}, 0.037111594667210424`], 
        ArrowBox[{{0.9161741253778872, 2.2042379152578073`}, {
         2.048291629199657, 2.1234515149168427`}}, 0.037111594667210424`], 
        ArrowBox[BezierCurveBox[{{0.9161741253778872, 2.2042379152578073`}, {
         1.1426224132864367`, 1.8283643084369232`}, {1.1017612834765285`, 
         1.3914545197263153`}}], 0.037111594667210424`], 
        ArrowBox[{{4.016611321633045, 2.353533984982435}, {3.84469369287132, 
         1.6224333748113187`}}, 0.037111594667210424`], 
        ArrowBox[{{3.84469369287132, 1.6224333748113187`}, {2.578947233115036,
          1.2123903488018222`}}, 0.037111594667210424`], 
        ArrowBox[{{0., 1.0871201056005553`}, {0.1771080921377448, 
         1.7613344937463582`}}, 0.037111594667210424`], 
        ArrowBox[{{0.1771080921377448, 1.7613344937463582`}, {
         0.9161741253778872, 2.2042379152578073`}}, 0.037111594667210424`], 
        ArrowBox[{{3.401612309872764, 1.0060397467263793`}, {
         2.578947233115036, 1.2123903488018222`}}, 0.037111594667210424`]}, 
       {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[
        0.7]}], {
         DiskBox[{2.9885651651611287, 1.871198195975713}, 
          0.037111594667210424], 
         InsetBox["\<\"a\"\>", 
          Offset[{2, 2}, {3.025676759828339, 1.9083097906429234}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{2.048291629199657, 2.1234515149168427}, 
          0.037111594667210424], 
         InsetBox["\<\"n\"\>", 
          Offset[{2, 2}, {2.0854032238668676, 2.160563109584053}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{2.028428884192558, 1.554772694693877}, 
          0.037111594667210424], 
         InsetBox["\<\"t\"\>", 
          Offset[{2, 2}, {2.0655404788597687, 1.5918842893610874}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{2.578947233115036, 1.2123903488018222}, 
          0.037111594667210424], 
         InsetBox["\<\"i\"\>", 
          Offset[{2, 2}, {2.6160588277822465, 1.2495019434690326}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{2.760857388262999, 0.}, 0.037111594667210424], 
         InsetBox["\<\"d\"\>", 
          Offset[{2, 2}, {2.7979689829302097, 0.037111594667210424}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.1017612834765285, 1.3914545197263153}, 
          0.037111594667210424], 
         InsetBox["\<\"s\"\>", 
          Offset[{2, 2}, {1.138872878143739, 1.4285661143935258}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.9161741253778872, 2.2042379152578073}, 
          0.037111594667210424], 
         InsetBox["\<\"e\"\>", 
          Offset[{2, 2}, {0.9532857200450977, 2.241349509925018}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{4.016611321633045, 2.353533984982435}, 
          0.037111594667210424], 
         InsetBox["\<\"b\"\>", 
          Offset[{2, 2}, {4.053722916300255, 2.3906455796496453}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{3.84469369287132, 1.6224333748113187}, 
          0.037111594667210424], 
         InsetBox["\<\"l\"\>", 
          Offset[{2, 2}, {3.8818052875385303, 1.6595449694785291}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0., 1.0871201056005553}, 0.037111594667210424], 
         InsetBox["\<\"h\"\>", 
          Offset[{2, 2}, {0.037111594667210424, 1.1242317002677658}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.1771080921377448, 1.7613344937463582}, 
          0.037111594667210424], 
         InsetBox["\<\"m\"\>", 
          Offset[{2, 2}, {0.21421968680495523, 1.7984460884135687}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{3.401612309872764, 1.0060397467263793}, 
          0.037111594667210424], 
         InsetBox["\<\"r\"\>", 
          Offset[{2, 2}, {3.4387239045399745, 1.0431513413935898}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}}}],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->{
   "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
  FormatType->TraditionalForm,
  FrameTicks->None,
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImageSize->{264.875, Automatic}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[42]=",ExpressionUUID->"90b6cd40-6f9c-49d1-99e1-a6d54a34b990"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Vocabulary", "VocabularySection",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"bf81c073-c644-4f2f-aa0d-2918ef05eef3"],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["FullForm",
      BaseStyle->"CodeLink"], "[", 
     StyleBox["expr", "CodeVariableLrg"], "]"}], " ", Cell[
    "show full internal form ", "VocabularyText",ExpressionUUID->
     "5e0279a4-bd28-4584-9b22-0f76e87a45e4"]},
   {
    RowBox[{
     ButtonBox["TreeForm",
      BaseStyle->"CodeLink"], "[", 
     StyleBox["expr", "CodeVariableLrg"], "]"}], " ", Cell[
    "show tree structure ", "VocabularyText",ExpressionUUID->
     "1480efce-fced-405a-8fdf-94d58e0a50e6"]},
   {
    RowBox[{
     ButtonBox["Head",
      BaseStyle->"CodeLink"], "[", 
     StyleBox["expr", "CodeVariableLrg"], "]"}], " ", Cell[
    "extract the head of an expression ", "VocabularyText",ExpressionUUID->
     "a9f21878-69cc-4bb9-ac4b-681dc3cdd8fd"]},
   {
    RowBox[{
     ButtonBox["_",
      BaseStyle->"CodeLink",
      ButtonData->"Blank"], 
     StyleBox["head", "CodeVariableLrg"]}], " ", Cell[
    "match any expression with a particular head", "VocabularyText",
     ExpressionUUID->"d73087a3-0ffb-427f-b537-0a3257a25c91"]},
   {
    RowBox[{
     StyleBox["f", "CodeVariableLrg"], 
     ButtonBox["@@",
      BaseStyle->"CodeLink",
      ButtonData->"Apply"], 
     StyleBox["list", "CodeVariableLrg"]}], " ", Cell[TextData[{
     "replace the head of ",
     Cell[BoxData[
      StyleBox["list", "CodeVariable"]], "InlineCode",ExpressionUUID->
      "850e4eda-1c70-4f46-8e6b-c52f2c7dc7ba"],
     " with ",
     Cell[BoxData[
      StyleBox["f", "CodeVariable"]], "InlineCode",ExpressionUUID->
      "feda3da2-0ee0-4328-a87a-6ff4c39b30d1"]
    }], "VocabularyText",ExpressionUUID->
     "a6ba10d5-19d9-4a2f-b1bd-0ad263d44d0e"]},
   {
    RowBox[{
     StyleBox["f", "CodeVariableLrg"], 
     ButtonBox["@@@",
      BaseStyle->"CodeLink",
      ButtonData->"Apply"], 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["list", "CodeVariableLrg"], "1"], ",", 
       SubscriptBox[
        StyleBox["list", "CodeVariableLrg"], "2"], ",", " ", 
       StyleBox["...", "GrayPointSix"]}], "}"}]}], " ", Cell[TextData[{
     "replace heads of ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["list", "CodeVariable"], "1"]], "InlineCode",ExpressionUUID->
      "14875909-d5e2-4e3d-8aeb-83b16cf88379"],
     ", ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["list", "CodeVariable"], "2"]], "InlineCode",ExpressionUUID->
      "8c7e632a-11f2-48b9-aade-6f4192baa9d8"],
     ", ",
     StyleBox["...", "GrayPointSix"],
     " with ",
     Cell[BoxData[
      StyleBox["f", "CodeVariable"]], "InlineCode",ExpressionUUID->
      "d1263ac2-09a9-44ad-abf3-b02e0ce43266"]
    }], "VocabularyText",ExpressionUUID->
     "c15a9083-b984-4f49-a07f-64c08198f0fc"]}
  }]], "VocabularyTable",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 GridBoxOptions->{
 GridBoxDividers->{"Columns" -> {{False}}, "Rows" -> {False, {True, True, 
      Directive[
       Thickness[1.5], "VocabDivColor"], True, True, True, True}, False}}},
 CellTags->
  "LastCellOfAPage",ExpressionUUID->"6b93372a-950d-4130-92b8-8511bcde08b0"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 DynamicModuleBox[{$CellContext`open$$ = False}, 
  TagBox[GridBox[{
     {
      StyleBox["\<\"Exercises\"\>",
       StripOnInput->False,
       FontSlant->"Italic"], 
      PaneBox[
       TagBox[
        ButtonBox[
         DynamicBox[ToBoxes[
           If[$CellContext`open$$, 
            Row[{
              Style["-", "ExercisePreviewButtonTextHighlight"], 
              Style[" Preview Exercises", "ExercisePreviewButtonText"]}], 
            Row[{
              Style["+", "ExercisePreviewButtonTextHighlight"], 
              Style[" Preview Exercises", "ExercisePreviewButtonText"]}]], 
           StandardForm],
          ImageSizeCache->{115., {1., 10.}}],
         Appearance->None,
         ButtonFunction:>(
          If[$CellContext`open$$, $CellContext`open$$ = 
            False, $CellContext`open$$ = True]; NotebookFind[
            EvaluationNotebook[], "ExerciseSummaryCell", Next, CellStyle, 
            WrapAround -> True, AutoScroll -> False]; FrontEndTokenExecute[
            EvaluationNotebook[], "ExpandSelection"]; FrontEndExecute[
            FrontEndToken[
             EvaluationNotebook[], "OpenCloseGroup"]]),
         Evaluator->Automatic,
         Method->"Preemptive"],
        MouseAppearanceTag["LinkHand"]],
       Alignment->Right,
       ImageSize->Full]}
    },
    AutoDelete->False,
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  DynamicModuleValues:>{}]], "ExerciseSection",
 Editable->False,
 ShowCellBracket->False,
 GeneratedCell->True,
 CellAutoOverwrite->True,
 CellChangeTimes->{3.669991951589675*^9},
 ShowStringCharacters->
  False,ExpressionUUID->"46d73543-c226-4e83-90ad-7e4b874fb6ab"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[GridBox[{
    {
     TagBox[GridBox[{
        {
         PaneBox[
          StyleBox["\<\"8 Exercises Available\"\>", "ExerciseSummaryHeading",
           StripOnInput->False],
          ImageMargins->{{20, 0}, {0, 10}}]}
       },
       DefaultBaseStyle->"Column",
       GridBoxAlignment->{"Columns" -> {{Left}}},
       GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
       
       GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{0}}}],
      "Column"], 
     PaneBox[
      ButtonBox[
       StyleBox["\<\"Get Started \[RightGuillemet]\"\>", 
        "ExerciseSummaryHeading",
        StripOnInput->False],
       Appearance->None,
       ButtonFunction:>
        NotebookLocate[{
         "EIWL2-33-expressions-and-their-structure-exercises.nb", ""}],
       Evaluator->Automatic,
       Method->"Preemptive"],
      FrameMargins->{{10, 0}, {10, 10}},
      ImageSize->Full]}
   },
   AutoDelete->False,
   GridBoxAlignment->{"Columns" -> {{Left}}},
   GridBoxItemSize->{"Columns" -> {
       Scaled[0.7], 
       Scaled[0.3]}, "Rows" -> {{Automatic}}}],
  "Grid"]], "ExerciseSummaryCell",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"ed59bf01-db93-455a-a0e1-4fec745ecd9a"],

Cell[CellGroupData[{

Cell[TextData[{
 "Find the head of the output from ",
 ButtonBox["ListPlot",
  BaseStyle->"Link"],
 ".",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "33.1", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"a20c3419-96c3-4b54-b874-1e4e21958360"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
      "Graphics"], "ExerciseOutput",ExpressionUUID->
       "0157b8e7-645c-493a-b214-d3a648aaa0cb"],
      Apply[TextCell, 
       Cell[
        BoxData["Graphics"], "ExerciseOutput", Selectable -> False, Copyable -> 
        False, Editable -> False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"a527a1b7-0d59-4b6a-8ddb-283f2d91d7a6"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["@@",
   BaseStyle->"Link",
   ButtonData->"Apply"]], "InlineCode",ExpressionUUID->
  "a5b34383-3e72-48b1-abbf-4bc35a993d61"],
 " to compute the result of multiplying together integers up to 100.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "33.2", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"813e9c20-c3e9-4a66-81a1-e40eea009596"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
      "93326215443944152681699238856266700490715968264381621468592963895217599\
993229915608941463976156518286253697920827223758251185210916864000000000000000\
000000000"], "ExerciseOutput",ExpressionUUID->
       "f0919411-baec-4b83-98ac-a090e764ea26"],
      Apply[TextCell, 
       Cell[
        BoxData[
        "933262154439441526816992388562667004907159682643816214685929638952175\
999932299156089414639761565182862536979208272237582511852109168640000000000000\
00000000000"], "ExerciseOutput", Selectable -> False, Copyable -> False, 
        Editable -> False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"7a87690d-fcae-4426-a515-44d746e91ff0"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["@@@",
   BaseStyle->"Link",
   ButtonData->"Apply"]], "InlineCode",ExpressionUUID->
  "bcb5ef0d-d3b0-488d-bae3-b515f0e4a6ad"],
 " and ",
 ButtonBox["Tuples",
  BaseStyle->"Link"],
 " to generate ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"f", "[", 
     RowBox[{"a", ",", "a"}], "]"}], ",", 
    RowBox[{"f", "[", 
     RowBox[{"a", ",", "b"}], "]"}], ",", 
    RowBox[{"f", "[", 
     RowBox[{"b", ",", "a"}], "]"}], ",", 
    RowBox[{"f", "[", 
     RowBox[{"b", ",", "b"}], "]"}]}], "}"}]], "InlineCode",ExpressionUUID->
  "0edcdfc3-e07a-4aeb-a078-ad7827ba06b0"],
 ".",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "33.3", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"39704067-9a32-4496-abf3-1074f8796be9"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       RowBox[{"{", 
        RowBox[{
         RowBox[{"f", "[", 
          RowBox[{"a", ",", "a"}], "]"}], ",", 
         RowBox[{"f", "[", 
          RowBox[{"a", ",", "b"}], "]"}], ",", 
         RowBox[{"f", "[", 
          RowBox[{"b", ",", "a"}], "]"}], ",", 
         RowBox[{"f", "[", 
          RowBox[{"b", ",", "b"}], "]"}]}], "}"}]], "ExerciseOutput",
       ExpressionUUID->"179bfce7-0b1a-46b1-8f89-fcabb6ef02b8"],
      Apply[TextCell, 
       Cell[
        BoxData[
         RowBox[{"{", 
           RowBox[{
             RowBox[{"f", "[", 
               RowBox[{"a", ",", "a"}], "]"}], ",", 
             RowBox[{"f", "[", 
               RowBox[{"a", ",", "b"}], "]"}], ",", 
             RowBox[{"f", "[", 
               RowBox[{"b", ",", "a"}], "]"}], ",", 
             RowBox[{"f", "[", 
               RowBox[{"b", ",", "b"}], "]"}]}], "}"}]], "ExerciseOutput", 
        Selectable -> False, Copyable -> False, Editable -> False, 
        ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"8f8e159c-673f-4b6d-916c-a7aaac4f1698"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Make a list of tree forms for the results of 4 successive applications of \
",
 Cell[BoxData[
  RowBox[{
   ButtonBox["#",
    BaseStyle->"Link",
    ButtonData->"Slot"], 
   ButtonBox["^",
    BaseStyle->"Link",
    ButtonData->"Power"], 
   ButtonBox["#",
    BaseStyle->"Link",
    ButtonData->"Slot"], 
   ButtonBox["&",
    BaseStyle->"Link",
    ButtonData->"Function"]}]], "InlineCode",ExpressionUUID->
  "613ff380-e08e-44f3-96c2-245cab21625f"],
 " starting from ",
 Cell[BoxData[
 "x"], "InlineCode",ExpressionUUID->"14f18500-934a-4116-9627-f5eeb49516d9"],
 ".",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "33.4", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"ffcf5efb-9bdc-406e-a931-9e6ea5d3f59e"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       RowBox[{"{", 
        RowBox[{
         GraphicsBox[
          TagBox[GraphicsComplexBox[{{0., 0.}}, {
             {RGBColor[0.55, 0.45, 0.45]}, 
             TagBox[
              TooltipBox[InsetBox[
                FrameBox[
                 StyleBox[
                  TagBox["x",
                   HoldForm], "StandardForm", "Output",
                  StripOnInput->False,
                  FontSize->Scaled[0.05],
                  FontColor->GrayLevel[0],
                  $CellContext`LineColor -> GrayLevel[0],
                  $CellContext`FrontFaceColor -> GrayLevel[0],
                  $CellContext`GraphicsColor -> GrayLevel[0],
                  $CellContext`BackFaceColor -> GrayLevel[0]],
                 Background->RGBColor[1., 1., 0.871],
                 FrameStyle->GrayLevel[0.5],
                 StripOnInput->False], 1],
               TagBox["x", HoldForm]],
              Annotation[#, 
               HoldForm[$CellContext`x], "Tooltip"]& ]}],
           Annotation[#, VertexCoordinateRules -> {{0., 0.}}]& ],
          AspectRatio->NCache[2^Rational[1, 2], 1.4142135623730951`],
          FormatType:>StandardForm,
          FrameTicks->Automatic,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]], ",", 
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{0.4472135954999579, 
            0.8944271909999159}, {0., 0.}, {0.8944271909999159, 0.}}, {
             {RGBColor[0.55, 0.45, 0.45], LineBox[{{1, 2}, {1, 3}}]}, {
              TagBox[
               TooltipBox[InsetBox[
                 FrameBox[
                  StyleBox["Power", "StandardForm", "Output",
                   StripOnInput->False,
                   FontSize->Scaled[0.05],
                   FontColor->GrayLevel[0],
                   $CellContext`LineColor -> GrayLevel[0],
                   $CellContext`FrontFaceColor -> GrayLevel[0],
                   $CellContext`GraphicsColor -> GrayLevel[0],
                   $CellContext`BackFaceColor -> GrayLevel[0]],
                  Background->RGBColor[1., 1., 0.871],
                  FrameStyle->GrayLevel[0.5],
                  StripOnInput->False], 1],
                TagBox[
                 SuperscriptBox["x", "x"], HoldForm]],
               Annotation[#, 
                HoldForm[$CellContext`x^$CellContext`x], "Tooltip"]& ], 
              TagBox[
               TooltipBox[InsetBox[
                 FrameBox[
                  StyleBox[
                   TagBox["x",
                    HoldForm], "StandardForm", "Output",
                   StripOnInput->False,
                   FontSize->Scaled[0.05],
                   FontColor->GrayLevel[0],
                   $CellContext`LineColor -> GrayLevel[0],
                   $CellContext`FrontFaceColor -> GrayLevel[0],
                   $CellContext`GraphicsColor -> GrayLevel[0],
                   $CellContext`BackFaceColor -> GrayLevel[0]],
                  Background->RGBColor[1., 1., 0.871],
                  FrameStyle->GrayLevel[0.5],
                  StripOnInput->False], 2],
                TagBox["x", HoldForm]],
               Annotation[#, 
                HoldForm[$CellContext`x], "Tooltip"]& ], 
              TagBox[
               TooltipBox[InsetBox[
                 FrameBox[
                  StyleBox[
                   TagBox["x",
                    HoldForm], "StandardForm", "Output",
                   StripOnInput->False,
                   FontSize->Scaled[0.05],
                   FontColor->GrayLevel[0],
                   $CellContext`LineColor -> GrayLevel[0],
                   $CellContext`FrontFaceColor -> GrayLevel[0],
                   $CellContext`GraphicsColor -> GrayLevel[0],
                   $CellContext`BackFaceColor -> GrayLevel[0]],
                  Background->RGBColor[1., 1., 0.871],
                  FrameStyle->GrayLevel[0.5],
                  StripOnInput->False], 3],
                TagBox["x", HoldForm]],
               Annotation[#, 
                HoldForm[$CellContext`x], "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{0.4472135954999579, 
             0.8944271909999159}, {0., 0.}, {0.8944271909999159, 0.}}]& ],
          AspectRatio->NCache[2 5^Rational[-1, 2], 0.8944271909999159],
          FormatType:>StandardForm,
          FrameTicks->Automatic,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]], ",", 
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{1.2247448713915892`, 
            1.6329931618554523`}, {0.4082482904638631, 0.8164965809277261}, {
            0., 0.}, {0.8164965809277261, 0.}, {2.041241452319315, 
            0.8164965809277261}, {1.6329931618554523`, 0.}, {
            2.4494897427831783`, 0.}}, {
             {RGBColor[0.55, 0.45, 0.45], 
              LineBox[{{1, 2}, {1, 5}, {2, 3}, {2, 4}, {5, 6}, {5, 7}}]}, {
              TagBox[
               TooltipBox[InsetBox[
                 FrameBox[
                  StyleBox["Power", "StandardForm", "Output",
                   StripOnInput->False,
                   FontSize->Scaled[0.05],
                   FontColor->GrayLevel[0],
                   $CellContext`LineColor -> GrayLevel[0],
                   $CellContext`FrontFaceColor -> GrayLevel[0],
                   $CellContext`GraphicsColor -> GrayLevel[0],
                   $CellContext`BackFaceColor -> GrayLevel[0]],
                  Background->RGBColor[1., 1., 0.871],
                  FrameStyle->GrayLevel[0.5],
                  StripOnInput->False], 1],
                TagBox[
                 SuperscriptBox[
                  RowBox[{"(", 
                    SuperscriptBox["x", "x"], ")"}], 
                  SuperscriptBox["x", "x"]], HoldForm]],
               Annotation[#, 
                
                HoldForm[($CellContext`x^$CellContext`x)^($CellContext`x^$\
CellContext`x)], "Tooltip"]& ], 
              TagBox[
               TooltipBox[InsetBox[
                 FrameBox[
                  StyleBox["Power", "StandardForm", "Output",
                   StripOnInput->False,
                   FontSize->Scaled[0.05],
                   FontColor->GrayLevel[0],
                   $CellContext`LineColor -> GrayLevel[0],
                   $CellContext`FrontFaceColor -> GrayLevel[0],
                   $CellContext`GraphicsColor -> GrayLevel[0],
                   $CellContext`BackFaceColor -> GrayLevel[0]],
                  Background->RGBColor[1., 1., 0.871],
                  FrameStyle->GrayLevel[0.5],
                  StripOnInput->False], 2],
                TagBox[
                 SuperscriptBox["x", "x"], HoldForm]],
               Annotation[#, 
                HoldForm[$CellContext`x^$CellContext`x], "Tooltip"]& ], 
              TagBox[
               TooltipBox[InsetBox[
                 FrameBox[
                  StyleBox[
                   TagBox["x",
                    HoldForm], "StandardForm", "Output",
                   StripOnInput->False,
                   FontSize->Scaled[0.05],
                   FontColor->GrayLevel[0],
                   $CellContext`LineColor -> GrayLevel[0],
                   $CellContext`FrontFaceColor -> GrayLevel[0],
                   $CellContext`GraphicsColor -> GrayLevel[0],
                   $CellContext`BackFaceColor -> GrayLevel[0]],
                  Background->RGBColor[1., 1., 0.871],
                  FrameStyle->GrayLevel[0.5],
                  StripOnInput->False], 3],
                TagBox["x", HoldForm]],
               Annotation[#, 
                HoldForm[$CellContext`x], "Tooltip"]& ], 
              TagBox[
               TooltipBox[InsetBox[
                 FrameBox[
                  StyleBox[
                   TagBox["x",
                    HoldForm], "StandardForm", "Output",
                   StripOnInput->False,
                   FontSize->Scaled[0.05],
                   FontColor->GrayLevel[0],
                   $CellContext`LineColor -> GrayLevel[0],
                   $CellContext`FrontFaceColor -> GrayLevel[0],
                   $CellContext`GraphicsColor -> GrayLevel[0],
                   $CellContext`BackFaceColor -> GrayLevel[0]],
                  Background->RGBColor[1., 1., 0.871],
                  FrameStyle->GrayLevel[0.5],
                  StripOnInput->False], 4],
                TagBox["x", HoldForm]],
               Annotation[#, 
                HoldForm[$CellContext`x], "Tooltip"]& ], 
              TagBox[
               TooltipBox[InsetBox[
                 FrameBox[
                  StyleBox["Power", "StandardForm", "Output",
                   StripOnInput->False,
                   FontSize->Scaled[0.05],
                   FontColor->GrayLevel[0],
                   $CellContext`LineColor -> GrayLevel[0],
                   $CellContext`FrontFaceColor -> GrayLevel[0],
                   $CellContext`GraphicsColor -> GrayLevel[0],
                   $CellContext`BackFaceColor -> GrayLevel[0]],
                  Background->RGBColor[1., 1., 0.871],
                  FrameStyle->GrayLevel[0.5],
                  StripOnInput->False], 5],
                TagBox[
                 SuperscriptBox["x", "x"], HoldForm]],
               Annotation[#, 
                HoldForm[$CellContext`x^$CellContext`x], "Tooltip"]& ], 
              TagBox[
               TooltipBox[InsetBox[
                 FrameBox[
                  StyleBox[
                   TagBox["x",
                    HoldForm], "StandardForm", "Output",
                   StripOnInput->False,
                   FontSize->Scaled[0.05],
                   FontColor->GrayLevel[0],
                   $CellContext`LineColor -> GrayLevel[0],
                   $CellContext`FrontFaceColor -> GrayLevel[0],
                   $CellContext`GraphicsColor -> GrayLevel[0],
                   $CellContext`BackFaceColor -> GrayLevel[0]],
                  Background->RGBColor[1., 1., 0.871],
                  FrameStyle->GrayLevel[0.5],
                  StripOnInput->False], 6],
                TagBox["x", HoldForm]],
               Annotation[#, 
                HoldForm[$CellContext`x], "Tooltip"]& ], 
              TagBox[
               TooltipBox[InsetBox[
                 FrameBox[
                  StyleBox[
                   TagBox["x",
                    HoldForm], "StandardForm", "Output",
                   StripOnInput->False,
                   FontSize->Scaled[0.05],
                   FontColor->GrayLevel[0],
                   $CellContext`LineColor -> GrayLevel[0],
                   $CellContext`FrontFaceColor -> GrayLevel[0],
                   $CellContext`GraphicsColor -> GrayLevel[0],
                   $CellContext`BackFaceColor -> GrayLevel[0]],
                  Background->RGBColor[1., 1., 0.871],
                  FrameStyle->GrayLevel[0.5],
                  StripOnInput->False], 7],
                TagBox["x", HoldForm]],
               Annotation[#, 
                HoldForm[$CellContext`x], "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{1.2247448713915892`, 
             1.6329931618554523`}, {0.4082482904638631, 0.8164965809277261}, {
             0., 0.}, {0.8164965809277261, 0.}, {2.041241452319315, 
             0.8164965809277261}, {1.6329931618554523`, 0.}, {
             2.4494897427831783`, 0.}}]& ],
          
          AspectRatio->NCache[
           Rational[3, 5]^Rational[1, 2], 0.7745966692414834],
          FormatType:>StandardForm,
          FrameTicks->Automatic,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]], ",", 
         GraphicsBox[
          
          TagBox[GraphicsComplexBox[{{2.4748737341529163`, 
            2.1213203435596424`}, {1.0606601717798212`, 1.414213562373095}, {
            0.35355339059327373`, 0.7071067811865475}, {0., 0.}, {
            0.7071067811865475, 0.}, {1.7677669529663687`, 
            0.7071067811865475}, {1.414213562373095, 0.}, {
            2.1213203435596424`, 0.}, {3.8890872965260113`, 
            1.414213562373095}, {3.181980515339464, 0.7071067811865475}, {
            2.82842712474619, 0.}, {3.5355339059327373`, 0.}, {
            4.596194077712559, 0.7071067811865475}, {4.242640687119285, 0.}, {
            4.949747468305833, 0.}}, {
             {RGBColor[0.55, 0.45, 0.45], 
              LineBox[{{1, 2}, {1, 9}, {2, 3}, {2, 6}, {3, 4}, {3, 5}, {6, 
               7}, {6, 8}, {9, 10}, {9, 13}, {10, 11}, {10, 12}, {13, 14}, {
               13, 15}}]}, {
              TagBox[
               TooltipBox[InsetBox[
                 FrameBox[
                  StyleBox["Power", "StandardForm", "Output",
                   StripOnInput->False,
                   FontSize->Scaled[0.04000000000000001],
                   FontColor->GrayLevel[0],
                   $CellContext`LineColor -> GrayLevel[0],
                   $CellContext`FrontFaceColor -> GrayLevel[0],
                   $CellContext`GraphicsColor -> GrayLevel[0],
                   $CellContext`BackFaceColor -> GrayLevel[0]],
                  Background->RGBColor[1., 1., 0.871],
                  FrameStyle->GrayLevel[0.5],
                  StripOnInput->False], 1],
                TagBox[
                 SuperscriptBox[
                  RowBox[{"(", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    SuperscriptBox["x", "x"], ")"}], 
                    SuperscriptBox["x", "x"]], ")"}], 
                  SuperscriptBox[
                   RowBox[{"(", 
                    SuperscriptBox["x", "x"], ")"}], 
                   SuperscriptBox["x", "x"]]], HoldForm]],
               Annotation[#, 
                
                HoldForm[(($CellContext`x^$CellContext`x)^($CellContext`x^$\
CellContext`x))^(($CellContext`x^$CellContext`x)^($CellContext`x^$CellContext`\
x))], "Tooltip"]& ], 
              TagBox[
               TooltipBox[InsetBox[
                 FrameBox[
                  StyleBox["Power", "StandardForm", "Output",
                   StripOnInput->False,
                   FontSize->Scaled[0.04000000000000001],
                   FontColor->GrayLevel[0],
                   $CellContext`LineColor -> GrayLevel[0],
                   $CellContext`FrontFaceColor -> GrayLevel[0],
                   $CellContext`GraphicsColor -> GrayLevel[0],
                   $CellContext`BackFaceColor -> GrayLevel[0]],
                  Background->RGBColor[1., 1., 0.871],
                  FrameStyle->GrayLevel[0.5],
                  StripOnInput->False], 2],
                TagBox[
                 SuperscriptBox[
                  RowBox[{"(", 
                    SuperscriptBox["x", "x"], ")"}], 
                  SuperscriptBox["x", "x"]], HoldForm]],
               Annotation[#, 
                
                HoldForm[($CellContext`x^$CellContext`x)^($CellContext`x^$\
CellContext`x)], "Tooltip"]& ], 
              TagBox[
               TooltipBox[InsetBox[
                 FrameBox[
                  StyleBox["Power", "StandardForm", "Output",
                   StripOnInput->False,
                   FontSize->Scaled[0.04000000000000001],
                   FontColor->GrayLevel[0],
                   $CellContext`LineColor -> GrayLevel[0],
                   $CellContext`FrontFaceColor -> GrayLevel[0],
                   $CellContext`GraphicsColor -> GrayLevel[0],
                   $CellContext`BackFaceColor -> GrayLevel[0]],
                  Background->RGBColor[1., 1., 0.871],
                  FrameStyle->GrayLevel[0.5],
                  StripOnInput->False], 3],
                TagBox[
                 SuperscriptBox["x", "x"], HoldForm]],
               Annotation[#, 
                HoldForm[$CellContext`x^$CellContext`x], "Tooltip"]& ], 
              TagBox[
               TooltipBox[InsetBox[
                 FrameBox[
                  StyleBox[
                   TagBox["x",
                    HoldForm], "StandardForm", "Output",
                   StripOnInput->False,
                   FontSize->Scaled[0.04000000000000001],
                   FontColor->GrayLevel[0],
                   $CellContext`LineColor -> GrayLevel[0],
                   $CellContext`FrontFaceColor -> GrayLevel[0],
                   $CellContext`GraphicsColor -> GrayLevel[0],
                   $CellContext`BackFaceColor -> GrayLevel[0]],
                  Background->RGBColor[1., 1., 0.871],
                  FrameStyle->GrayLevel[0.5],
                  StripOnInput->False], 4],
                TagBox["x", HoldForm]],
               Annotation[#, 
                HoldForm[$CellContext`x], "Tooltip"]& ], 
              TagBox[
               TooltipBox[InsetBox[
                 FrameBox[
                  StyleBox[
                   TagBox["x",
                    HoldForm], "StandardForm", "Output",
                   StripOnInput->False,
                   FontSize->Scaled[0.04000000000000001],
                   FontColor->GrayLevel[0],
                   $CellContext`LineColor -> GrayLevel[0],
                   $CellContext`FrontFaceColor -> GrayLevel[0],
                   $CellContext`GraphicsColor -> GrayLevel[0],
                   $CellContext`BackFaceColor -> GrayLevel[0]],
                  Background->RGBColor[1., 1., 0.871],
                  FrameStyle->GrayLevel[0.5],
                  StripOnInput->False], 5],
                TagBox["x", HoldForm]],
               Annotation[#, 
                HoldForm[$CellContext`x], "Tooltip"]& ], 
              TagBox[
               TooltipBox[InsetBox[
                 FrameBox[
                  StyleBox["Power", "StandardForm", "Output",
                   StripOnInput->False,
                   FontSize->Scaled[0.04000000000000001],
                   FontColor->GrayLevel[0],
                   $CellContext`LineColor -> GrayLevel[0],
                   $CellContext`FrontFaceColor -> GrayLevel[0],
                   $CellContext`GraphicsColor -> GrayLevel[0],
                   $CellContext`BackFaceColor -> GrayLevel[0]],
                  Background->RGBColor[1., 1., 0.871],
                  FrameStyle->GrayLevel[0.5],
                  StripOnInput->False], 6],
                TagBox[
                 SuperscriptBox["x", "x"], HoldForm]],
               Annotation[#, 
                HoldForm[$CellContext`x^$CellContext`x], "Tooltip"]& ], 
              TagBox[
               TooltipBox[InsetBox[
                 FrameBox[
                  StyleBox[
                   TagBox["x",
                    HoldForm], "StandardForm", "Output",
                   StripOnInput->False,
                   FontSize->Scaled[0.04000000000000001],
                   FontColor->GrayLevel[0],
                   $CellContext`LineColor -> GrayLevel[0],
                   $CellContext`FrontFaceColor -> GrayLevel[0],
                   $CellContext`GraphicsColor -> GrayLevel[0],
                   $CellContext`BackFaceColor -> GrayLevel[0]],
                  Background->RGBColor[1., 1., 0.871],
                  FrameStyle->GrayLevel[0.5],
                  StripOnInput->False], 7],
                TagBox["x", HoldForm]],
               Annotation[#, 
                HoldForm[$CellContext`x], "Tooltip"]& ], 
              TagBox[
               TooltipBox[InsetBox[
                 FrameBox[
                  StyleBox[
                   TagBox["x",
                    HoldForm], "StandardForm", "Output",
                   StripOnInput->False,
                   FontSize->Scaled[0.04000000000000001],
                   FontColor->GrayLevel[0],
                   $CellContext`LineColor -> GrayLevel[0],
                   $CellContext`FrontFaceColor -> GrayLevel[0],
                   $CellContext`GraphicsColor -> GrayLevel[0],
                   $CellContext`BackFaceColor -> GrayLevel[0]],
                  Background->RGBColor[1., 1., 0.871],
                  FrameStyle->GrayLevel[0.5],
                  StripOnInput->False], 8],
                TagBox["x", HoldForm]],
               Annotation[#, 
                HoldForm[$CellContext`x], "Tooltip"]& ], 
              TagBox[
               TooltipBox[InsetBox[
                 FrameBox[
                  StyleBox["Power", "StandardForm", "Output",
                   StripOnInput->False,
                   FontSize->Scaled[0.04000000000000001],
                   FontColor->GrayLevel[0],
                   $CellContext`LineColor -> GrayLevel[0],
                   $CellContext`FrontFaceColor -> GrayLevel[0],
                   $CellContext`GraphicsColor -> GrayLevel[0],
                   $CellContext`BackFaceColor -> GrayLevel[0]],
                  Background->RGBColor[1., 1., 0.871],
                  FrameStyle->GrayLevel[0.5],
                  StripOnInput->False], 9],
                TagBox[
                 SuperscriptBox[
                  RowBox[{"(", 
                    SuperscriptBox["x", "x"], ")"}], 
                  SuperscriptBox["x", "x"]], HoldForm]],
               Annotation[#, 
                
                HoldForm[($CellContext`x^$CellContext`x)^($CellContext`x^$\
CellContext`x)], "Tooltip"]& ], 
              TagBox[
               TooltipBox[InsetBox[
                 FrameBox[
                  StyleBox["Power", "StandardForm", "Output",
                   StripOnInput->False,
                   FontSize->Scaled[0.04000000000000001],
                   FontColor->GrayLevel[0],
                   $CellContext`LineColor -> GrayLevel[0],
                   $CellContext`FrontFaceColor -> GrayLevel[0],
                   $CellContext`GraphicsColor -> GrayLevel[0],
                   $CellContext`BackFaceColor -> GrayLevel[0]],
                  Background->RGBColor[1., 1., 0.871],
                  FrameStyle->GrayLevel[0.5],
                  StripOnInput->False], 10],
                TagBox[
                 SuperscriptBox["x", "x"], HoldForm]],
               Annotation[#, 
                HoldForm[$CellContext`x^$CellContext`x], "Tooltip"]& ], 
              TagBox[
               TooltipBox[InsetBox[
                 FrameBox[
                  StyleBox[
                   TagBox["x",
                    HoldForm], "StandardForm", "Output",
                   StripOnInput->False,
                   FontSize->Scaled[0.04000000000000001],
                   FontColor->GrayLevel[0],
                   $CellContext`LineColor -> GrayLevel[0],
                   $CellContext`FrontFaceColor -> GrayLevel[0],
                   $CellContext`GraphicsColor -> GrayLevel[0],
                   $CellContext`BackFaceColor -> GrayLevel[0]],
                  Background->RGBColor[1., 1., 0.871],
                  FrameStyle->GrayLevel[0.5],
                  StripOnInput->False], 11],
                TagBox["x", HoldForm]],
               Annotation[#, 
                HoldForm[$CellContext`x], "Tooltip"]& ], 
              TagBox[
               TooltipBox[InsetBox[
                 FrameBox[
                  StyleBox[
                   TagBox["x",
                    HoldForm], "StandardForm", "Output",
                   StripOnInput->False,
                   FontSize->Scaled[0.04000000000000001],
                   FontColor->GrayLevel[0],
                   $CellContext`LineColor -> GrayLevel[0],
                   $CellContext`FrontFaceColor -> GrayLevel[0],
                   $CellContext`GraphicsColor -> GrayLevel[0],
                   $CellContext`BackFaceColor -> GrayLevel[0]],
                  Background->RGBColor[1., 1., 0.871],
                  FrameStyle->GrayLevel[0.5],
                  StripOnInput->False], 12],
                TagBox["x", HoldForm]],
               Annotation[#, 
                HoldForm[$CellContext`x], "Tooltip"]& ], 
              TagBox[
               TooltipBox[InsetBox[
                 FrameBox[
                  StyleBox["Power", "StandardForm", "Output",
                   StripOnInput->False,
                   FontSize->Scaled[0.04000000000000001],
                   FontColor->GrayLevel[0],
                   $CellContext`LineColor -> GrayLevel[0],
                   $CellContext`FrontFaceColor -> GrayLevel[0],
                   $CellContext`GraphicsColor -> GrayLevel[0],
                   $CellContext`BackFaceColor -> GrayLevel[0]],
                  Background->RGBColor[1., 1., 0.871],
                  FrameStyle->GrayLevel[0.5],
                  StripOnInput->False], 13],
                TagBox[
                 SuperscriptBox["x", "x"], HoldForm]],
               Annotation[#, 
                HoldForm[$CellContext`x^$CellContext`x], "Tooltip"]& ], 
              TagBox[
               TooltipBox[InsetBox[
                 FrameBox[
                  StyleBox[
                   TagBox["x",
                    HoldForm], "StandardForm", "Output",
                   StripOnInput->False,
                   FontSize->Scaled[0.04000000000000001],
                   FontColor->GrayLevel[0],
                   $CellContext`LineColor -> GrayLevel[0],
                   $CellContext`FrontFaceColor -> GrayLevel[0],
                   $CellContext`GraphicsColor -> GrayLevel[0],
                   $CellContext`BackFaceColor -> GrayLevel[0]],
                  Background->RGBColor[1., 1., 0.871],
                  FrameStyle->GrayLevel[0.5],
                  StripOnInput->False], 14],
                TagBox["x", HoldForm]],
               Annotation[#, 
                HoldForm[$CellContext`x], "Tooltip"]& ], 
              TagBox[
               TooltipBox[InsetBox[
                 FrameBox[
                  StyleBox[
                   TagBox["x",
                    HoldForm], "StandardForm", "Output",
                   StripOnInput->False,
                   FontSize->Scaled[0.04000000000000001],
                   FontColor->GrayLevel[0],
                   $CellContext`LineColor -> GrayLevel[0],
                   $CellContext`FrontFaceColor -> GrayLevel[0],
                   $CellContext`GraphicsColor -> GrayLevel[0],
                   $CellContext`BackFaceColor -> GrayLevel[0]],
                  Background->RGBColor[1., 1., 0.871],
                  FrameStyle->GrayLevel[0.5],
                  StripOnInput->False], 15],
                TagBox["x", HoldForm]],
               Annotation[#, 
                HoldForm[$CellContext`x], "Tooltip"]& ]}}],
           
           Annotation[#, 
            VertexCoordinateRules -> {{2.4748737341529163`, 
             2.1213203435596424`}, {1.0606601717798212`, 1.414213562373095}, {
             0.35355339059327373`, 0.7071067811865475}, {0., 0.}, {
             0.7071067811865475, 0.}, {1.7677669529663687`, 
             0.7071067811865475}, {1.414213562373095, 0.}, {
             2.1213203435596424`, 0.}, {3.8890872965260113`, 
             1.414213562373095}, {3.181980515339464, 0.7071067811865475}, {
             2.82842712474619, 0.}, {3.5355339059327373`, 0.}, {
             4.596194077712559, 0.7071067811865475}, {4.242640687119285, 
             0.}, {4.949747468305833, 0.}}]& ],
          
          AspectRatio->NCache[
           Rational[2, 5]^Rational[1, 2], 0.6324555320336759],
          FormatType:>StandardForm,
          FrameTicks->Automatic,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]], ",", 
         GraphicsBox[
          TagBox[GraphicsComplexBox[CompressedData["
1:eJxTTMoPSmViYGCQB2IQ/Vrf/CJPkKCDrPEE1+WVTA47de7FFGkxOKzxiXhR
te23/Wow/doeIv8JSl+ylwPTj+wZ0IAsmvgT+y9ighLf4eph5sDkV0PtgfHd
3Zb9d03ndICpa7B00rtzgsUBVT+TA6r57HA+XzDXxfWsfHD1EPO54fIQ/wnA
+ZWe/4sf9EnB/bvJZvaisg+icPv9zF7udFwojGa/EFw/xH0icL6Ys2/3ansJ
uHqI+8Th8hD/ScL5DmHJrl668nD77vpvjBG9J4Pmfmk0/8nB+UHruKbb71OA
q4f4TwEuD4lfRTgfALxPla0=
            "], {
             {RGBColor[0.55, 0.45, 0.45], 
              LineBox[{{1, 2}, {1, 17}, {2, 3}, {2, 10}, {3, 4}, {3, 7}, {4, 
               5}, {4, 6}, {7, 8}, {7, 9}, {10, 11}, {10, 14}, {11, 12}, {11, 
               13}, {14, 15}, {14, 16}, {17, 18}, {17, 25}, {18, 19}, {18, 
               22}, {19, 20}, {19, 21}, {22, 23}, {22, 24}, {25, 26}, {25, 
               29}, {26, 27}, {26, 28}, {29, 30}, {29, 31}}]}, {
              TagBox[
               TooltipBox[InsetBox[
                 FrameBox[
                  StyleBox["Power", "StandardForm", "Output",
                   StripOnInput->False,
                   FontSize->Scaled[0.020000000000000004`],
                   FontColor->GrayLevel[0],
                   $CellContext`LineColor -> GrayLevel[0],
                   $CellContext`FrontFaceColor -> GrayLevel[0],
                   $CellContext`GraphicsColor -> GrayLevel[0],
                   $CellContext`BackFaceColor -> GrayLevel[0]],
                  Background->RGBColor[1., 1., 0.871],
                  FrameStyle->GrayLevel[0.5],
                  StripOnInput->False], 1],
                TagBox[
                 SuperscriptBox[
                  RowBox[{"(", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    SuperscriptBox["x", "x"], ")"}], 
                    SuperscriptBox["x", "x"]], ")"}], 
                    SuperscriptBox[
                    RowBox[{"(", 
                    SuperscriptBox["x", "x"], ")"}], 
                    SuperscriptBox["x", "x"]]], ")"}], 
                  SuperscriptBox[
                   RowBox[{"(", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    SuperscriptBox["x", "x"], ")"}], 
                    SuperscriptBox["x", "x"]], ")"}], 
                   SuperscriptBox[
                    RowBox[{"(", 
                    SuperscriptBox["x", "x"], ")"}], 
                    SuperscriptBox["x", "x"]]]], HoldForm]],
               Annotation[#, 
                
                HoldForm[((($CellContext`x^$CellContext`x)^($CellContext`x^$\
CellContext`x))^(($CellContext`x^$CellContext`x)^($CellContext`x^$CellContext`\
x)))^((($CellContext`x^$CellContext`x)^($CellContext`x^$CellContext`x))^(($\
CellContext`x^$CellContext`x)^($CellContext`x^$CellContext`x)))], 
                "Tooltip"]& ], 
              TagBox[
               TooltipBox[InsetBox[
                 FrameBox[
                  StyleBox["Power", "StandardForm", "Output",
                   StripOnInput->False,
                   FontSize->Scaled[0.020000000000000004`],
                   FontColor->GrayLevel[0],
                   $CellContext`LineColor -> GrayLevel[0],
                   $CellContext`FrontFaceColor -> GrayLevel[0],
                   $CellContext`GraphicsColor -> GrayLevel[0],
                   $CellContext`BackFaceColor -> GrayLevel[0]],
                  Background->RGBColor[1., 1., 0.871],
                  FrameStyle->GrayLevel[0.5],
                  StripOnInput->False], 2],
                TagBox[
                 SuperscriptBox[
                  RowBox[{"(", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    SuperscriptBox["x", "x"], ")"}], 
                    SuperscriptBox["x", "x"]], ")"}], 
                  SuperscriptBox[
                   RowBox[{"(", 
                    SuperscriptBox["x", "x"], ")"}], 
                   SuperscriptBox["x", "x"]]], HoldForm]],
               Annotation[#, 
                
                HoldForm[(($CellContext`x^$CellContext`x)^($CellContext`x^$\
CellContext`x))^(($CellContext`x^$CellContext`x)^($CellContext`x^$CellContext`\
x))], "Tooltip"]& ], 
              TagBox[
               TooltipBox[InsetBox[
                 FrameBox[
                  StyleBox["Power", "StandardForm", "Output",
                   StripOnInput->False,
                   FontSize->Scaled[0.020000000000000004`],
                   FontColor->GrayLevel[0],
                   $CellContext`LineColor -> GrayLevel[0],
                   $CellContext`FrontFaceColor -> GrayLevel[0],
                   $CellContext`GraphicsColor -> GrayLevel[0],
                   $CellContext`BackFaceColor -> GrayLevel[0]],
                  Background->RGBColor[1., 1., 0.871],
                  FrameStyle->GrayLevel[0.5],
                  StripOnInput->False], 3],
                TagBox[
                 SuperscriptBox[
                  RowBox[{"(", 
                    SuperscriptBox["x", "x"], ")"}], 
                  SuperscriptBox["x", "x"]], HoldForm]],
               Annotation[#, 
                
                HoldForm[($CellContext`x^$CellContext`x)^($CellContext`x^$\
CellContext`x)], "Tooltip"]& ], 
              TagBox[
               TooltipBox[InsetBox[
                 FrameBox[
                  StyleBox["Power", "StandardForm", "Output",
                   StripOnInput->False,
                   FontSize->Scaled[0.020000000000000004`],
                   FontColor->GrayLevel[0],
                   $CellContext`LineColor -> GrayLevel[0],
                   $CellContext`FrontFaceColor -> GrayLevel[0],
                   $CellContext`GraphicsColor -> GrayLevel[0],
                   $CellContext`BackFaceColor -> GrayLevel[0]],
                  Background->RGBColor[1., 1., 0.871],
                  FrameStyle->GrayLevel[0.5],
                  StripOnInput->False], 4],
                TagBox[
                 SuperscriptBox["x", "x"], HoldForm]],
               Annotation[#, 
                HoldForm[$CellContext`x^$CellContext`x], "Tooltip"]& ], 
              TagBox[
               TooltipBox[InsetBox[
                 FrameBox[
                  StyleBox[
                   TagBox["x",
                    HoldForm], "StandardForm", "Output",
                   StripOnInput->False,
                   FontSize->Scaled[0.020000000000000004`],
                   FontColor->GrayLevel[0],
                   $CellContext`LineColor -> GrayLevel[0],
                   $CellContext`FrontFaceColor -> GrayLevel[0],
                   $CellContext`GraphicsColor -> GrayLevel[0],
                   $CellContext`BackFaceColor -> GrayLevel[0]],
                  Background->RGBColor[1., 1., 0.871],
                  FrameStyle->GrayLevel[0.5],
                  StripOnInput->False], 5],
                TagBox["x", HoldForm]],
               Annotation[#, 
                HoldForm[$CellContext`x], "Tooltip"]& ], 
              TagBox[
               TooltipBox[InsetBox[
                 FrameBox[
                  StyleBox[
                   TagBox["x",
                    HoldForm], "StandardForm", "Output",
                   StripOnInput->False,
                   FontSize->Scaled[0.020000000000000004`],
                   FontColor->GrayLevel[0],
                   $CellContext`LineColor -> GrayLevel[0],
                   $CellContext`FrontFaceColor -> GrayLevel[0],
                   $CellContext`GraphicsColor -> GrayLevel[0],
                   $CellContext`BackFaceColor -> GrayLevel[0]],
                  Background->RGBColor[1., 1., 0.871],
                  FrameStyle->GrayLevel[0.5],
                  StripOnInput->False], 6],
                TagBox["x", HoldForm]],
               Annotation[#, 
                HoldForm[$CellContext`x], "Tooltip"]& ], 
              TagBox[
               TooltipBox[InsetBox[
                 FrameBox[
                  StyleBox["Power", "StandardForm", "Output",
                   StripOnInput->False,
                   FontSize->Scaled[0.020000000000000004`],
                   FontColor->GrayLevel[0],
                   $CellContext`LineColor -> GrayLevel[0],
                   $CellContext`FrontFaceColor -> GrayLevel[0],
                   $CellContext`GraphicsColor -> GrayLevel[0],
                   $CellContext`BackFaceColor -> GrayLevel[0]],
                  Background->RGBColor[1., 1., 0.871],
                  FrameStyle->GrayLevel[0.5],
                  StripOnInput->False], 7],
                TagBox[
                 SuperscriptBox["x", "x"], HoldForm]],
               Annotation[#, 
                HoldForm[$CellContext`x^$CellContext`x], "Tooltip"]& ], 
              TagBox[
               TooltipBox[InsetBox[
                 FrameBox[
                  StyleBox[
                   TagBox["x",
                    HoldForm], "StandardForm", "Output",
                   StripOnInput->False,
                   FontSize->Scaled[0.020000000000000004`],
                   FontColor->GrayLevel[0],
                   $CellContext`LineColor -> GrayLevel[0],
                   $CellContext`FrontFaceColor -> GrayLevel[0],
                   $CellContext`GraphicsColor -> GrayLevel[0],
                   $CellContext`BackFaceColor -> GrayLevel[0]],
                  Background->RGBColor[1., 1., 0.871],
                  FrameStyle->GrayLevel[0.5],
                  StripOnInput->False], 8],
                TagBox["x", HoldForm]],
               Annotation[#, 
                HoldForm[$CellContext`x], "Tooltip"]& ], 
              TagBox[
               TooltipBox[InsetBox[
                 FrameBox[
                  StyleBox[
                   TagBox["x",
                    HoldForm], "StandardForm", "Output",
                   StripOnInput->False,
                   FontSize->Scaled[0.020000000000000004`],
                   FontColor->GrayLevel[0],
                   $CellContext`LineColor -> GrayLevel[0],
                   $CellContext`FrontFaceColor -> GrayLevel[0],
                   $CellContext`GraphicsColor -> GrayLevel[0],
                   $CellContext`BackFaceColor -> GrayLevel[0]],
                  Background->RGBColor[1., 1., 0.871],
                  FrameStyle->GrayLevel[0.5],
                  StripOnInput->False], 9],
                TagBox["x", HoldForm]],
               Annotation[#, 
                HoldForm[$CellContext`x], "Tooltip"]& ], 
              TagBox[
               TooltipBox[InsetBox[
                 FrameBox[
                  StyleBox["Power", "StandardForm", "Output",
                   StripOnInput->False,
                   FontSize->Scaled[0.020000000000000004`],
                   FontColor->GrayLevel[0],
                   $CellContext`LineColor -> GrayLevel[0],
                   $CellContext`FrontFaceColor -> GrayLevel[0],
                   $CellContext`GraphicsColor -> GrayLevel[0],
                   $CellContext`BackFaceColor -> GrayLevel[0]],
                  Background->RGBColor[1., 1., 0.871],
                  FrameStyle->GrayLevel[0.5],
                  StripOnInput->False], 10],
                TagBox[
                 SuperscriptBox[
                  RowBox[{"(", 
                    SuperscriptBox["x", "x"], ")"}], 
                  SuperscriptBox["x", "x"]], HoldForm]],
               Annotation[#, 
                
                HoldForm[($CellContext`x^$CellContext`x)^($CellContext`x^$\
CellContext`x)], "Tooltip"]& ], 
              TagBox[
               TooltipBox[InsetBox[
                 FrameBox[
                  StyleBox["Power", "StandardForm", "Output",
                   StripOnInput->False,
                   FontSize->Scaled[0.020000000000000004`],
                   FontColor->GrayLevel[0],
                   $CellContext`LineColor -> GrayLevel[0],
                   $CellContext`FrontFaceColor -> GrayLevel[0],
                   $CellContext`GraphicsColor -> GrayLevel[0],
                   $CellContext`BackFaceColor -> GrayLevel[0]],
                  Background->RGBColor[1., 1., 0.871],
                  FrameStyle->GrayLevel[0.5],
                  StripOnInput->False], 11],
                TagBox[
                 SuperscriptBox["x", "x"], HoldForm]],
               Annotation[#, 
                HoldForm[$CellContext`x^$CellContext`x], "Tooltip"]& ], 
              TagBox[
               TooltipBox[InsetBox[
                 FrameBox[
                  StyleBox[
                   TagBox["x",
                    HoldForm], "StandardForm", "Output",
                   StripOnInput->False,
                   FontSize->Scaled[0.020000000000000004`],
                   FontColor->GrayLevel[0],
                   $CellContext`LineColor -> GrayLevel[0],
                   $CellContext`FrontFaceColor -> GrayLevel[0],
                   $CellContext`GraphicsColor -> GrayLevel[0],
                   $CellContext`BackFaceColor -> GrayLevel[0]],
                  Background->RGBColor[1., 1., 0.871],
                  FrameStyle->GrayLevel[0.5],
                  StripOnInput->False], 12],
                TagBox["x", HoldForm]],
               Annotation[#, 
                HoldForm[$CellContext`x], "Tooltip"]& ], 
              TagBox[
               TooltipBox[InsetBox[
                 FrameBox[
                  StyleBox[
                   TagBox["x",
                    HoldForm], "StandardForm", "Output",
                   StripOnInput->False,
                   FontSize->Scaled[0.020000000000000004`],
                   FontColor->GrayLevel[0],
                   $CellContext`LineColor -> GrayLevel[0],
                   $CellContext`FrontFaceColor -> GrayLevel[0],
                   $CellContext`GraphicsColor -> GrayLevel[0],
                   $CellContext`BackFaceColor -> GrayLevel[0]],
                  Background->RGBColor[1., 1., 0.871],
                  FrameStyle->GrayLevel[0.5],
                  StripOnInput->False], 13],
                TagBox["x", HoldForm]],
               Annotation[#, 
                HoldForm[$CellContext`x], "Tooltip"]& ], 
              TagBox[
               TooltipBox[InsetBox[
                 FrameBox[
                  StyleBox["Power", "StandardForm", "Output",
                   StripOnInput->False,
                   FontSize->Scaled[0.020000000000000004`],
                   FontColor->GrayLevel[0],
                   $CellContext`LineColor -> GrayLevel[0],
                   $CellContext`FrontFaceColor -> GrayLevel[0],
                   $CellContext`GraphicsColor -> GrayLevel[0],
                   $CellContext`BackFaceColor -> GrayLevel[0]],
                  Background->RGBColor[1., 1., 0.871],
                  FrameStyle->GrayLevel[0.5],
                  StripOnInput->False], 14],
                TagBox[
                 SuperscriptBox["x", "x"], HoldForm]],
               Annotation[#, 
                HoldForm[$CellContext`x^$CellContext`x], "Tooltip"]& ], 
              TagBox[
               TooltipBox[InsetBox[
                 FrameBox[
                  StyleBox[
                   TagBox["x",
                    HoldForm], "StandardForm", "Output",
                   StripOnInput->False,
                   FontSize->Scaled[0.020000000000000004`],
                   FontColor->GrayLevel[0],
                   $CellContext`LineColor -> GrayLevel[0],
                   $CellContext`FrontFaceColor -> GrayLevel[0],
                   $CellContext`GraphicsColor -> GrayLevel[0],
                   $CellContext`BackFaceColor -> GrayLevel[0]],
                  Background->RGBColor[1., 1., 0.871],
                  FrameStyle->GrayLevel[0.5],
                  StripOnInput->False], 15],
                TagBox["x", HoldForm]],
               Annotation[#, 
                HoldForm[$CellContext`x], "Tooltip"]& ], 
              TagBox[
               TooltipBox[InsetBox[
                 FrameBox[
                  StyleBox[
                   TagBox["x",
                    HoldForm], "StandardForm", "Output",
                   StripOnInput->False,
                   FontSize->Scaled[0.020000000000000004`],
                   FontColor->GrayLevel[0],
                   $CellContext`LineColor -> GrayLevel[0],
                   $CellContext`FrontFaceColor -> GrayLevel[0],
                   $CellContext`GraphicsColor -> GrayLevel[0],
                   $CellContext`BackFaceColor -> GrayLevel[0]],
                  Background->RGBColor[1., 1., 0.871],
                  FrameStyle->GrayLevel[0.5],
                  StripOnInput->False], 16],
                TagBox["x", HoldForm]],
               Annotation[#, 
                HoldForm[$CellContext`x], "Tooltip"]& ], 
              TagBox[
               TooltipBox[InsetBox[
                 FrameBox[
                  StyleBox["Power", "StandardForm", "Output",
                   StripOnInput->False,
                   FontSize->Scaled[0.020000000000000004`],
                   FontColor->GrayLevel[0],
                   $CellContext`LineColor -> GrayLevel[0],
                   $CellContext`FrontFaceColor -> GrayLevel[0],
                   $CellContext`GraphicsColor -> GrayLevel[0],
                   $CellContext`BackFaceColor -> GrayLevel[0]],
                  Background->RGBColor[1., 1., 0.871],
                  FrameStyle->GrayLevel[0.5],
                  StripOnInput->False], 17],
                TagBox[
                 SuperscriptBox[
                  RowBox[{"(", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    SuperscriptBox["x", "x"], ")"}], 
                    SuperscriptBox["x", "x"]], ")"}], 
                  SuperscriptBox[
                   RowBox[{"(", 
                    SuperscriptBox["x", "x"], ")"}], 
                   SuperscriptBox["x", "x"]]], HoldForm]],
               Annotation[#, 
                
                HoldForm[(($CellContext`x^$CellContext`x)^($CellContext`x^$\
CellContext`x))^(($CellContext`x^$CellContext`x)^($CellContext`x^$CellContext`\
x))], "Tooltip"]& ], 
              TagBox[
               TooltipBox[InsetBox[
                 FrameBox[
                  StyleBox["Power", "StandardForm", "Output",
                   StripOnInput->False,
                   FontSize->Scaled[0.020000000000000004`],
                   FontColor->GrayLevel[0],
                   $CellContext`LineColor -> GrayLevel[0],
                   $CellContext`FrontFaceColor -> GrayLevel[0],
                   $CellContext`GraphicsColor -> GrayLevel[0],
                   $CellContext`BackFaceColor -> GrayLevel[0]],
                  Background->RGBColor[1., 1., 0.871],
                  FrameStyle->GrayLevel[0.5],
                  StripOnInput->False], 18],
                TagBox[
                 SuperscriptBox[
                  RowBox[{"(", 
                    SuperscriptBox["x", "x"], ")"}], 
                  SuperscriptBox["x", "x"]], HoldForm]],
               Annotation[#, 
                
                HoldForm[($CellContext`x^$CellContext`x)^($CellContext`x^$\
CellContext`x)], "Tooltip"]& ], 
              TagBox[
               TooltipBox[InsetBox[
                 FrameBox[
                  StyleBox["Power", "StandardForm", "Output",
                   StripOnInput->False,
                   FontSize->Scaled[0.020000000000000004`],
                   FontColor->GrayLevel[0],
                   $CellContext`LineColor -> GrayLevel[0],
                   $CellContext`FrontFaceColor -> GrayLevel[0],
                   $CellContext`GraphicsColor -> GrayLevel[0],
                   $CellContext`BackFaceColor -> GrayLevel[0]],
                  Background->RGBColor[1., 1., 0.871],
                  FrameStyle->GrayLevel[0.5],
                  StripOnInput->False], 19],
                TagBox[
                 SuperscriptBox["x", "x"], HoldForm]],
               Annotation[#, 
                HoldForm[$CellContext`x^$CellContext`x], "Tooltip"]& ], 
              TagBox[
               TooltipBox[InsetBox[
                 FrameBox[
                  StyleBox[
                   TagBox["x",
                    HoldForm], "StandardForm", "Output",
                   StripOnInput->False,
                   FontSize->Scaled[0.020000000000000004`],
                   FontColor->GrayLevel[0],
                   $CellContext`LineColor -> GrayLevel[0],
                   $CellContext`FrontFaceColor -> GrayLevel[0],
                   $CellContext`GraphicsColor -> GrayLevel[0],
                   $CellContext`BackFaceColor -> GrayLevel[0]],
                  Background->RGBColor[1., 1., 0.871],
                  FrameStyle->GrayLevel[0.5],
                  StripOnInput->False], 20],
                TagBox["x", HoldForm]],
               Annotation[#, 
                HoldForm[$CellContext`x], "Tooltip"]& ], 
              TagBox[
               TooltipBox[InsetBox[
                 FrameBox[
                  StyleBox[
                   TagBox["x",
                    HoldForm], "StandardForm", "Output",
                   StripOnInput->False,
                   FontSize->Scaled[0.020000000000000004`],
                   FontColor->GrayLevel[0],
                   $CellContext`LineColor -> GrayLevel[0],
                   $CellContext`FrontFaceColor -> GrayLevel[0],
                   $CellContext`GraphicsColor -> GrayLevel[0],
                   $CellContext`BackFaceColor -> GrayLevel[0]],
                  Background->RGBColor[1., 1., 0.871],
                  FrameStyle->GrayLevel[0.5],
                  StripOnInput->False], 21],
                TagBox["x", HoldForm]],
               Annotation[#, 
                HoldForm[$CellContext`x], "Tooltip"]& ], 
              TagBox[
               TooltipBox[InsetBox[
                 FrameBox[
                  StyleBox["Power", "StandardForm", "Output",
                   StripOnInput->False,
                   FontSize->Scaled[0.020000000000000004`],
                   FontColor->GrayLevel[0],
                   $CellContext`LineColor -> GrayLevel[0],
                   $CellContext`FrontFaceColor -> GrayLevel[0],
                   $CellContext`GraphicsColor -> GrayLevel[0],
                   $CellContext`BackFaceColor -> GrayLevel[0]],
                  Background->RGBColor[1., 1., 0.871],
                  FrameStyle->GrayLevel[0.5],
                  StripOnInput->False], 22],
                TagBox[
                 SuperscriptBox["x", "x"], HoldForm]],
               Annotation[#, 
                HoldForm[$CellContext`x^$CellContext`x], "Tooltip"]& ], 
              TagBox[
               TooltipBox[InsetBox[
                 FrameBox[
                  StyleBox[
                   TagBox["x",
                    HoldForm], "StandardForm", "Output",
                   StripOnInput->False,
                   FontSize->Scaled[0.020000000000000004`],
                   FontColor->GrayLevel[0],
                   $CellContext`LineColor -> GrayLevel[0],
                   $CellContext`FrontFaceColor -> GrayLevel[0],
                   $CellContext`GraphicsColor -> GrayLevel[0],
                   $CellContext`BackFaceColor -> GrayLevel[0]],
                  Background->RGBColor[1., 1., 0.871],
                  FrameStyle->GrayLevel[0.5],
                  StripOnInput->False], 23],
                TagBox["x", HoldForm]],
               Annotation[#, 
                HoldForm[$CellContext`x], "Tooltip"]& ], 
              TagBox[
               TooltipBox[InsetBox[
                 FrameBox[
                  StyleBox[
                   TagBox["x",
                    HoldForm], "StandardForm", "Output",
                   StripOnInput->False,
                   FontSize->Scaled[0.020000000000000004`],
                   FontColor->GrayLevel[0],
                   $CellContext`LineColor -> GrayLevel[0],
                   $CellContext`FrontFaceColor -> GrayLevel[0],
                   $CellContext`GraphicsColor -> GrayLevel[0],
                   $CellContext`BackFaceColor -> GrayLevel[0]],
                  Background->RGBColor[1., 1., 0.871],
                  FrameStyle->GrayLevel[0.5],
                  StripOnInput->False], 24],
                TagBox["x", HoldForm]],
               Annotation[#, 
                HoldForm[$CellContext`x], "Tooltip"]& ], 
              TagBox[
               TooltipBox[InsetBox[
                 FrameBox[
                  StyleBox["Power", "StandardForm", "Output",
                   StripOnInput->False,
                   FontSize->Scaled[0.020000000000000004`],
                   FontColor->GrayLevel[0],
                   $CellContext`LineColor -> GrayLevel[0],
                   $CellContext`FrontFaceColor -> GrayLevel[0],
                   $CellContext`GraphicsColor -> GrayLevel[0],
                   $CellContext`BackFaceColor -> GrayLevel[0]],
                  Background->RGBColor[1., 1., 0.871],
                  FrameStyle->GrayLevel[0.5],
                  StripOnInput->False], 25],
                TagBox[
                 SuperscriptBox[
                  RowBox[{"(", 
                    SuperscriptBox["x", "x"], ")"}], 
                  SuperscriptBox["x", "x"]], HoldForm]],
               Annotation[#, 
                
                HoldForm[($CellContext`x^$CellContext`x)^($CellContext`x^$\
CellContext`x)], "Tooltip"]& ], 
              TagBox[
               TooltipBox[InsetBox[
                 FrameBox[
                  StyleBox["Power", "StandardForm", "Output",
                   StripOnInput->False,
                   FontSize->Scaled[0.020000000000000004`],
                   FontColor->GrayLevel[0],
                   $CellContext`LineColor -> GrayLevel[0],
                   $CellContext`FrontFaceColor -> GrayLevel[0],
                   $CellContext`GraphicsColor -> GrayLevel[0],
                   $CellContext`BackFaceColor -> GrayLevel[0]],
                  Background->RGBColor[1., 1., 0.871],
                  FrameStyle->GrayLevel[0.5],
                  StripOnInput->False], 26],
                TagBox[
                 SuperscriptBox["x", "x"], HoldForm]],
               Annotation[#, 
                HoldForm[$CellContext`x^$CellContext`x], "Tooltip"]& ], 
              TagBox[
               TooltipBox[InsetBox[
                 FrameBox[
                  StyleBox[
                   TagBox["x",
                    HoldForm], "StandardForm", "Output",
                   StripOnInput->False,
                   FontSize->Scaled[0.020000000000000004`],
                   FontColor->GrayLevel[0],
                   $CellContext`LineColor -> GrayLevel[0],
                   $CellContext`FrontFaceColor -> GrayLevel[0],
                   $CellContext`GraphicsColor -> GrayLevel[0],
                   $CellContext`BackFaceColor -> GrayLevel[0]],
                  Background->RGBColor[1., 1., 0.871],
                  FrameStyle->GrayLevel[0.5],
                  StripOnInput->False], 27],
                TagBox["x", HoldForm]],
               Annotation[#, 
                HoldForm[$CellContext`x], "Tooltip"]& ], 
              TagBox[
               TooltipBox[InsetBox[
                 FrameBox[
                  StyleBox[
                   TagBox["x",
                    HoldForm], "StandardForm", "Output",
                   StripOnInput->False,
                   FontSize->Scaled[0.020000000000000004`],
                   FontColor->GrayLevel[0],
                   $CellContext`LineColor -> GrayLevel[0],
                   $CellContext`FrontFaceColor -> GrayLevel[0],
                   $CellContext`GraphicsColor -> GrayLevel[0],
                   $CellContext`BackFaceColor -> GrayLevel[0]],
                  Background->RGBColor[1., 1., 0.871],
                  FrameStyle->GrayLevel[0.5],
                  StripOnInput->False], 28],
                TagBox["x", HoldForm]],
               Annotation[#, 
                HoldForm[$CellContext`x], "Tooltip"]& ], 
              TagBox[
               TooltipBox[InsetBox[
                 FrameBox[
                  StyleBox["Power", "StandardForm", "Output",
                   StripOnInput->False,
                   FontSize->Scaled[0.020000000000000004`],
                   FontColor->GrayLevel[0],
                   $CellContext`LineColor -> GrayLevel[0],
                   $CellContext`FrontFaceColor -> GrayLevel[0],
                   $CellContext`GraphicsColor -> GrayLevel[0],
                   $CellContext`BackFaceColor -> GrayLevel[0]],
                  Background->RGBColor[1., 1., 0.871],
                  FrameStyle->GrayLevel[0.5],
                  StripOnInput->False], 29],
                TagBox[
                 SuperscriptBox["x", "x"], HoldForm]],
               Annotation[#, 
                HoldForm[$CellContext`x^$CellContext`x], "Tooltip"]& ], 
              TagBox[
               TooltipBox[InsetBox[
                 FrameBox[
                  StyleBox[
                   TagBox["x",
                    HoldForm], "StandardForm", "Output",
                   StripOnInput->False,
                   FontSize->Scaled[0.020000000000000004`],
                   FontColor->GrayLevel[0],
                   $CellContext`LineColor -> GrayLevel[0],
                   $CellContext`FrontFaceColor -> GrayLevel[0],
                   $CellContext`GraphicsColor -> GrayLevel[0],
                   $CellContext`BackFaceColor -> GrayLevel[0]],
                  Background->RGBColor[1., 1., 0.871],
                  FrameStyle->GrayLevel[0.5],
                  StripOnInput->False], 30],
                TagBox["x", HoldForm]],
               Annotation[#, 
                HoldForm[$CellContext`x], "Tooltip"]& ], 
              TagBox[
               TooltipBox[InsetBox[
                 FrameBox[
                  StyleBox[
                   TagBox["x",
                    HoldForm], "StandardForm", "Output",
                   StripOnInput->False,
                   FontSize->Scaled[0.020000000000000004`],
                   FontColor->GrayLevel[0],
                   $CellContext`LineColor -> GrayLevel[0],
                   $CellContext`FrontFaceColor -> GrayLevel[0],
                   $CellContext`GraphicsColor -> GrayLevel[0],
                   $CellContext`BackFaceColor -> GrayLevel[0]],
                  Background->RGBColor[1., 1., 0.871],
                  FrameStyle->GrayLevel[0.5],
                  StripOnInput->False], 31],
                TagBox["x", HoldForm]],
               Annotation[#, 
                HoldForm[$CellContext`x], "Tooltip"]& ]}}],
           Annotation[#, VertexCoordinateRules -> CompressedData["
1:eJxTTMoPSmViYGCQB2IQ/Vrf/CJPkKCDrPEE1+WVTA47de7FFGkxOKzxiXhR
te23/Wow/doeIv8JSl+ylwPTj+wZ0IAsmvgT+y9ighLf4eph5sDkV0PtgfHd
3Zb9d03ndICpa7B00rtzgsUBVT+TA6r57HA+XzDXxfWsfHD1EPO54fIQ/wnA
+ZWe/4sf9EnB/bvJZvaisg+icPv9zF7udFwojGa/EFw/xH0icL6Ys2/3ansJ
uHqI+8Th8hD/ScL5DmHJrl668nD77vpvjBG9J4Pmfmk0/8nB+UHruKbb71OA
q4f4TwEuD4lfRTgfALxPla0=
             "]]& ],
          AspectRatio->NCache[
            Rational[1, 2], 0.5],
          FormatType:>StandardForm,
          FrameTicks->Automatic,
          PlotRange->All,
          PlotRangePadding->Scaled[0.1]]}], "}"}]], "ExerciseOutput",
       ExpressionUUID->"3fc0de3e-9062-437c-af6c-99278889a51e"],
      Apply[TextCell, 
       Cell[
        BoxData[
         RowBox[{"{", 
           RowBox[{
             GraphicsBox[
              TagBox[
               GraphicsComplexBox[{{0., 0.}}, {{{{
                    RGBColor[0.55, 0.45, 0.45]}}}, 
                 TagBox[
                  TooltipBox[
                   InsetBox[
                    FrameBox[
                    StyleBox[
                    TagBox["x", HoldForm], "StandardForm", "Output", 
                    StripOnInput -> False, $CellContext`LineColor -> 
                    GrayLevel[0], $CellContext`FrontFaceColor -> 
                    GrayLevel[0], $CellContext`GraphicsColor -> GrayLevel[0], 
                    FontSize -> Scaled[0.05], FontColor -> 
                    GrayLevel[0], $CellContext`BackFaceColor -> GrayLevel[0]],
                     Background -> RGBColor[1., 1., 0.871], FrameStyle -> 
                    GrayLevel[0.5], StripOnInput -> False], 1], 
                   TagBox["x", HoldForm]], Annotation[#, 
                   HoldForm[$CellContext`x], "Tooltip"]& ]}], 
               Annotation[#, VertexCoordinateRules -> {{0., 0.}}]& ], 
              AspectRatio -> NCache[2^Rational[1, 2], 1.4142135623730951`], 
              FormatType :> StandardForm, FrameTicks -> Automatic, PlotRange -> 
              All, PlotRangePadding -> Scaled[0.1]], ",", 
             GraphicsBox[
              TagBox[
               
               GraphicsComplexBox[{{0.4472135954999579, 0.8944271909999159}, {
                0., 0.}, {0.8944271909999159, 0.}}, {{{{
                    RGBColor[0.55, 0.45, 0.45], 
                    LineBox[{{1, 2}, {1, 3}}]}}}, {
                  TagBox[
                   TooltipBox[
                    InsetBox[
                    FrameBox[
                    StyleBox[
                    "Power", "StandardForm", "Output", StripOnInput -> 
                    False, $CellContext`LineColor -> 
                    GrayLevel[0], $CellContext`FrontFaceColor -> 
                    GrayLevel[0], $CellContext`GraphicsColor -> GrayLevel[0], 
                    FontSize -> Scaled[0.05], FontColor -> 
                    GrayLevel[0], $CellContext`BackFaceColor -> GrayLevel[0]],
                     Background -> RGBColor[1., 1., 0.871], FrameStyle -> 
                    GrayLevel[0.5], StripOnInput -> False], 1], 
                    TagBox[
                    SuperscriptBox["x", "x"], HoldForm]], Annotation[#, 
                    HoldForm[$CellContext`x^$CellContext`x], "Tooltip"]& ], 
                  TagBox[
                   TooltipBox[
                    InsetBox[
                    FrameBox[
                    StyleBox[
                    TagBox["x", HoldForm], "StandardForm", "Output", 
                    StripOnInput -> False, $CellContext`LineColor -> 
                    GrayLevel[0], $CellContext`FrontFaceColor -> 
                    GrayLevel[0], $CellContext`GraphicsColor -> GrayLevel[0], 
                    FontSize -> Scaled[0.05], FontColor -> 
                    GrayLevel[0], $CellContext`BackFaceColor -> GrayLevel[0]],
                     Background -> RGBColor[1., 1., 0.871], FrameStyle -> 
                    GrayLevel[0.5], StripOnInput -> False], 2], 
                    TagBox["x", HoldForm]], Annotation[#, 
                    HoldForm[$CellContext`x], "Tooltip"]& ], 
                  TagBox[
                   TooltipBox[
                    InsetBox[
                    FrameBox[
                    StyleBox[
                    TagBox["x", HoldForm], "StandardForm", "Output", 
                    StripOnInput -> False, $CellContext`LineColor -> 
                    GrayLevel[0], $CellContext`FrontFaceColor -> 
                    GrayLevel[0], $CellContext`GraphicsColor -> GrayLevel[0], 
                    FontSize -> Scaled[0.05], FontColor -> 
                    GrayLevel[0], $CellContext`BackFaceColor -> GrayLevel[0]],
                     Background -> RGBColor[1., 1., 0.871], FrameStyle -> 
                    GrayLevel[0.5], StripOnInput -> False], 3], 
                    TagBox["x", HoldForm]], Annotation[#, 
                    HoldForm[$CellContext`x], "Tooltip"]& ]}}], 
               Annotation[#, 
                VertexCoordinateRules -> {{0.4472135954999579, 
                 0.8944271909999159}, {0., 0.}, {0.8944271909999159, 0.}}]& ],
               AspectRatio -> NCache[2 5^Rational[-1, 2], 0.8944271909999159],
               FormatType :> StandardForm, FrameTicks -> Automatic, PlotRange -> 
              All, PlotRangePadding -> Scaled[0.1]], ",", 
             GraphicsBox[
              TagBox[
               
               GraphicsComplexBox[{{1.2247448713915892`, 
                1.6329931618554523`}, {0.4082482904638631, 
                0.8164965809277261}, {0., 0.}, {0.8164965809277261, 0.}, {
                2.041241452319315, 0.8164965809277261}, {1.6329931618554523`, 
                0.}, {2.4494897427831783`, 0.}}, {{{{
                    RGBColor[0.55, 0.45, 0.45], 
                    
                    LineBox[{{1, 2}, {1, 5}, {2, 3}, {2, 4}, {5, 6}, {5, 
                    7}}]}}}, {
                  TagBox[
                   TooltipBox[
                    InsetBox[
                    FrameBox[
                    StyleBox[
                    "Power", "StandardForm", "Output", StripOnInput -> 
                    False, $CellContext`LineColor -> 
                    GrayLevel[0], $CellContext`FrontFaceColor -> 
                    GrayLevel[0], $CellContext`GraphicsColor -> GrayLevel[0], 
                    FontSize -> Scaled[0.05], FontColor -> 
                    GrayLevel[0], $CellContext`BackFaceColor -> GrayLevel[0]],
                     Background -> RGBColor[1., 1., 0.871], FrameStyle -> 
                    GrayLevel[0.5], StripOnInput -> False], 1], 
                    TagBox[
                    SuperscriptBox[
                    RowBox[{"(", 
                    SuperscriptBox["x", "x"], ")"}], 
                    SuperscriptBox["x", "x"]], HoldForm]], Annotation[#, 
                    
                    HoldForm[($CellContext`x^$CellContext`x)^($CellContext`x^$\
CellContext`x)], "Tooltip"]& ], 
                  TagBox[
                   TooltipBox[
                    InsetBox[
                    FrameBox[
                    StyleBox[
                    "Power", "StandardForm", "Output", StripOnInput -> 
                    False, $CellContext`LineColor -> 
                    GrayLevel[0], $CellContext`FrontFaceColor -> 
                    GrayLevel[0], $CellContext`GraphicsColor -> GrayLevel[0], 
                    FontSize -> Scaled[0.05], FontColor -> 
                    GrayLevel[0], $CellContext`BackFaceColor -> GrayLevel[0]],
                     Background -> RGBColor[1., 1., 0.871], FrameStyle -> 
                    GrayLevel[0.5], StripOnInput -> False], 2], 
                    TagBox[
                    SuperscriptBox["x", "x"], HoldForm]], Annotation[#, 
                    HoldForm[$CellContext`x^$CellContext`x], "Tooltip"]& ], 
                  TagBox[
                   TooltipBox[
                    InsetBox[
                    FrameBox[
                    StyleBox[
                    TagBox["x", HoldForm], "StandardForm", "Output", 
                    StripOnInput -> False, $CellContext`LineColor -> 
                    GrayLevel[0], $CellContext`FrontFaceColor -> 
                    GrayLevel[0], $CellContext`GraphicsColor -> GrayLevel[0], 
                    FontSize -> Scaled[0.05], FontColor -> 
                    GrayLevel[0], $CellContext`BackFaceColor -> GrayLevel[0]],
                     Background -> RGBColor[1., 1., 0.871], FrameStyle -> 
                    GrayLevel[0.5], StripOnInput -> False], 3], 
                    TagBox["x", HoldForm]], Annotation[#, 
                    HoldForm[$CellContext`x], "Tooltip"]& ], 
                  TagBox[
                   TooltipBox[
                    InsetBox[
                    FrameBox[
                    StyleBox[
                    TagBox["x", HoldForm], "StandardForm", "Output", 
                    StripOnInput -> False, $CellContext`LineColor -> 
                    GrayLevel[0], $CellContext`FrontFaceColor -> 
                    GrayLevel[0], $CellContext`GraphicsColor -> GrayLevel[0], 
                    FontSize -> Scaled[0.05], FontColor -> 
                    GrayLevel[0], $CellContext`BackFaceColor -> GrayLevel[0]],
                     Background -> RGBColor[1., 1., 0.871], FrameStyle -> 
                    GrayLevel[0.5], StripOnInput -> False], 4], 
                    TagBox["x", HoldForm]], Annotation[#, 
                    HoldForm[$CellContext`x], "Tooltip"]& ], 
                  TagBox[
                   TooltipBox[
                    InsetBox[
                    FrameBox[
                    StyleBox[
                    "Power", "StandardForm", "Output", StripOnInput -> 
                    False, $CellContext`LineColor -> 
                    GrayLevel[0], $CellContext`FrontFaceColor -> 
                    GrayLevel[0], $CellContext`GraphicsColor -> GrayLevel[0], 
                    FontSize -> Scaled[0.05], FontColor -> 
                    GrayLevel[0], $CellContext`BackFaceColor -> GrayLevel[0]],
                     Background -> RGBColor[1., 1., 0.871], FrameStyle -> 
                    GrayLevel[0.5], StripOnInput -> False], 5], 
                    TagBox[
                    SuperscriptBox["x", "x"], HoldForm]], Annotation[#, 
                    HoldForm[$CellContext`x^$CellContext`x], "Tooltip"]& ], 
                  TagBox[
                   TooltipBox[
                    InsetBox[
                    FrameBox[
                    StyleBox[
                    TagBox["x", HoldForm], "StandardForm", "Output", 
                    StripOnInput -> False, $CellContext`LineColor -> 
                    GrayLevel[0], $CellContext`FrontFaceColor -> 
                    GrayLevel[0], $CellContext`GraphicsColor -> GrayLevel[0], 
                    FontSize -> Scaled[0.05], FontColor -> 
                    GrayLevel[0], $CellContext`BackFaceColor -> GrayLevel[0]],
                     Background -> RGBColor[1., 1., 0.871], FrameStyle -> 
                    GrayLevel[0.5], StripOnInput -> False], 6], 
                    TagBox["x", HoldForm]], Annotation[#, 
                    HoldForm[$CellContext`x], "Tooltip"]& ], 
                  TagBox[
                   TooltipBox[
                    InsetBox[
                    FrameBox[
                    StyleBox[
                    TagBox["x", HoldForm], "StandardForm", "Output", 
                    StripOnInput -> False, $CellContext`LineColor -> 
                    GrayLevel[0], $CellContext`FrontFaceColor -> 
                    GrayLevel[0], $CellContext`GraphicsColor -> GrayLevel[0], 
                    FontSize -> Scaled[0.05], FontColor -> 
                    GrayLevel[0], $CellContext`BackFaceColor -> GrayLevel[0]],
                     Background -> RGBColor[1., 1., 0.871], FrameStyle -> 
                    GrayLevel[0.5], StripOnInput -> False], 7], 
                    TagBox["x", HoldForm]], Annotation[#, 
                    HoldForm[$CellContext`x], "Tooltip"]& ]}}], 
               Annotation[#, 
                VertexCoordinateRules -> {{1.2247448713915892`, 
                 1.6329931618554523`}, {0.4082482904638631, 
                 0.8164965809277261}, {0., 0.}, {0.8164965809277261, 0.}, {
                 2.041241452319315, 0.8164965809277261}, {1.6329931618554523`,
                  0.}, {2.4494897427831783`, 0.}}]& ], AspectRatio -> 
              NCache[Rational[3, 5]^Rational[1, 2], 0.7745966692414834], 
              FormatType :> StandardForm, FrameTicks -> Automatic, PlotRange -> 
              All, PlotRangePadding -> Scaled[0.1]], ",", 
             GraphicsBox[
              TagBox[
               
               GraphicsComplexBox[{{2.4748737341529163`, 
                2.1213203435596424`}, {1.0606601717798212`, 
                1.414213562373095}, {0.35355339059327373`, 
                0.7071067811865475}, {0., 0.}, {0.7071067811865475, 0.}, {
                1.7677669529663687`, 0.7071067811865475}, {1.414213562373095, 
                0.}, {2.1213203435596424`, 0.}, {3.8890872965260113`, 
                1.414213562373095}, {3.181980515339464, 0.7071067811865475}, {
                2.82842712474619, 0.}, {3.5355339059327373`, 0.}, {
                4.596194077712559, 0.7071067811865475}, {4.242640687119285, 
                0.}, {4.949747468305833, 0.}}, {{{{
                    RGBColor[0.55, 0.45, 0.45], 
                    
                    LineBox[{{1, 2}, {1, 9}, {2, 3}, {2, 6}, {3, 4}, {3, 5}, {
                    6, 7}, {6, 8}, {9, 10}, {9, 13}, {10, 11}, {10, 12}, {13, 
                    14}, {13, 15}}]}}}, {
                  TagBox[
                   TooltipBox[
                    InsetBox[
                    FrameBox[
                    StyleBox[
                    "Power", "StandardForm", "Output", StripOnInput -> 
                    False, $CellContext`LineColor -> 
                    GrayLevel[0], $CellContext`FrontFaceColor -> 
                    GrayLevel[0], $CellContext`GraphicsColor -> GrayLevel[0], 
                    FontSize -> Scaled[0.04000000000000001], FontColor -> 
                    GrayLevel[0], $CellContext`BackFaceColor -> GrayLevel[0]],
                     Background -> RGBColor[1., 1., 0.871], FrameStyle -> 
                    GrayLevel[0.5], StripOnInput -> False], 1], 
                    TagBox[
                    SuperscriptBox[
                    RowBox[{"(", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    SuperscriptBox["x", "x"], ")"}], 
                    SuperscriptBox["x", "x"]], ")"}], 
                    SuperscriptBox[
                    RowBox[{"(", 
                    SuperscriptBox["x", "x"], ")"}], 
                    SuperscriptBox["x", "x"]]], HoldForm]], Annotation[#, 
                    
                    HoldForm[(($CellContext`x^$CellContext`x)^($CellContext`x^\
$CellContext`x))^(($CellContext`x^$CellContext`x)^($CellContext`x^$\
CellContext`x))], "Tooltip"]& ], 
                  TagBox[
                   TooltipBox[
                    InsetBox[
                    FrameBox[
                    StyleBox[
                    "Power", "StandardForm", "Output", StripOnInput -> 
                    False, $CellContext`LineColor -> 
                    GrayLevel[0], $CellContext`FrontFaceColor -> 
                    GrayLevel[0], $CellContext`GraphicsColor -> GrayLevel[0], 
                    FontSize -> Scaled[0.04000000000000001], FontColor -> 
                    GrayLevel[0], $CellContext`BackFaceColor -> GrayLevel[0]],
                     Background -> RGBColor[1., 1., 0.871], FrameStyle -> 
                    GrayLevel[0.5], StripOnInput -> False], 2], 
                    TagBox[
                    SuperscriptBox[
                    RowBox[{"(", 
                    SuperscriptBox["x", "x"], ")"}], 
                    SuperscriptBox["x", "x"]], HoldForm]], Annotation[#, 
                    
                    HoldForm[($CellContext`x^$CellContext`x)^($CellContext`x^$\
CellContext`x)], "Tooltip"]& ], 
                  TagBox[
                   TooltipBox[
                    InsetBox[
                    FrameBox[
                    StyleBox[
                    "Power", "StandardForm", "Output", StripOnInput -> 
                    False, $CellContext`LineColor -> 
                    GrayLevel[0], $CellContext`FrontFaceColor -> 
                    GrayLevel[0], $CellContext`GraphicsColor -> GrayLevel[0], 
                    FontSize -> Scaled[0.04000000000000001], FontColor -> 
                    GrayLevel[0], $CellContext`BackFaceColor -> GrayLevel[0]],
                     Background -> RGBColor[1., 1., 0.871], FrameStyle -> 
                    GrayLevel[0.5], StripOnInput -> False], 3], 
                    TagBox[
                    SuperscriptBox["x", "x"], HoldForm]], Annotation[#, 
                    HoldForm[$CellContext`x^$CellContext`x], "Tooltip"]& ], 
                  TagBox[
                   TooltipBox[
                    InsetBox[
                    FrameBox[
                    StyleBox[
                    TagBox["x", HoldForm], "StandardForm", "Output", 
                    StripOnInput -> False, $CellContext`LineColor -> 
                    GrayLevel[0], $CellContext`FrontFaceColor -> 
                    GrayLevel[0], $CellContext`GraphicsColor -> GrayLevel[0], 
                    FontSize -> Scaled[0.04000000000000001], FontColor -> 
                    GrayLevel[0], $CellContext`BackFaceColor -> GrayLevel[0]],
                     Background -> RGBColor[1., 1., 0.871], FrameStyle -> 
                    GrayLevel[0.5], StripOnInput -> False], 4], 
                    TagBox["x", HoldForm]], Annotation[#, 
                    HoldForm[$CellContext`x], "Tooltip"]& ], 
                  TagBox[
                   TooltipBox[
                    InsetBox[
                    FrameBox[
                    StyleBox[
                    TagBox["x", HoldForm], "StandardForm", "Output", 
                    StripOnInput -> False, $CellContext`LineColor -> 
                    GrayLevel[0], $CellContext`FrontFaceColor -> 
                    GrayLevel[0], $CellContext`GraphicsColor -> GrayLevel[0], 
                    FontSize -> Scaled[0.04000000000000001], FontColor -> 
                    GrayLevel[0], $CellContext`BackFaceColor -> GrayLevel[0]],
                     Background -> RGBColor[1., 1., 0.871], FrameStyle -> 
                    GrayLevel[0.5], StripOnInput -> False], 5], 
                    TagBox["x", HoldForm]], Annotation[#, 
                    HoldForm[$CellContext`x], "Tooltip"]& ], 
                  TagBox[
                   TooltipBox[
                    InsetBox[
                    FrameBox[
                    StyleBox[
                    "Power", "StandardForm", "Output", StripOnInput -> 
                    False, $CellContext`LineColor -> 
                    GrayLevel[0], $CellContext`FrontFaceColor -> 
                    GrayLevel[0], $CellContext`GraphicsColor -> GrayLevel[0], 
                    FontSize -> Scaled[0.04000000000000001], FontColor -> 
                    GrayLevel[0], $CellContext`BackFaceColor -> GrayLevel[0]],
                     Background -> RGBColor[1., 1., 0.871], FrameStyle -> 
                    GrayLevel[0.5], StripOnInput -> False], 6], 
                    TagBox[
                    SuperscriptBox["x", "x"], HoldForm]], Annotation[#, 
                    HoldForm[$CellContext`x^$CellContext`x], "Tooltip"]& ], 
                  TagBox[
                   TooltipBox[
                    InsetBox[
                    FrameBox[
                    StyleBox[
                    TagBox["x", HoldForm], "StandardForm", "Output", 
                    StripOnInput -> False, $CellContext`LineColor -> 
                    GrayLevel[0], $CellContext`FrontFaceColor -> 
                    GrayLevel[0], $CellContext`GraphicsColor -> GrayLevel[0], 
                    FontSize -> Scaled[0.04000000000000001], FontColor -> 
                    GrayLevel[0], $CellContext`BackFaceColor -> GrayLevel[0]],
                     Background -> RGBColor[1., 1., 0.871], FrameStyle -> 
                    GrayLevel[0.5], StripOnInput -> False], 7], 
                    TagBox["x", HoldForm]], Annotation[#, 
                    HoldForm[$CellContext`x], "Tooltip"]& ], 
                  TagBox[
                   TooltipBox[
                    InsetBox[
                    FrameBox[
                    StyleBox[
                    TagBox["x", HoldForm], "StandardForm", "Output", 
                    StripOnInput -> False, $CellContext`LineColor -> 
                    GrayLevel[0], $CellContext`FrontFaceColor -> 
                    GrayLevel[0], $CellContext`GraphicsColor -> GrayLevel[0], 
                    FontSize -> Scaled[0.04000000000000001], FontColor -> 
                    GrayLevel[0], $CellContext`BackFaceColor -> GrayLevel[0]],
                     Background -> RGBColor[1., 1., 0.871], FrameStyle -> 
                    GrayLevel[0.5], StripOnInput -> False], 8], 
                    TagBox["x", HoldForm]], Annotation[#, 
                    HoldForm[$CellContext`x], "Tooltip"]& ], 
                  TagBox[
                   TooltipBox[
                    InsetBox[
                    FrameBox[
                    StyleBox[
                    "Power", "StandardForm", "Output", StripOnInput -> 
                    False, $CellContext`LineColor -> 
                    GrayLevel[0], $CellContext`FrontFaceColor -> 
                    GrayLevel[0], $CellContext`GraphicsColor -> GrayLevel[0], 
                    FontSize -> Scaled[0.04000000000000001], FontColor -> 
                    GrayLevel[0], $CellContext`BackFaceColor -> GrayLevel[0]],
                     Background -> RGBColor[1., 1., 0.871], FrameStyle -> 
                    GrayLevel[0.5], StripOnInput -> False], 9], 
                    TagBox[
                    SuperscriptBox[
                    RowBox[{"(", 
                    SuperscriptBox["x", "x"], ")"}], 
                    SuperscriptBox["x", "x"]], HoldForm]], Annotation[#, 
                    
                    HoldForm[($CellContext`x^$CellContext`x)^($CellContext`x^$\
CellContext`x)], "Tooltip"]& ], 
                  TagBox[
                   TooltipBox[
                    InsetBox[
                    FrameBox[
                    StyleBox[
                    "Power", "StandardForm", "Output", StripOnInput -> 
                    False, $CellContext`LineColor -> 
                    GrayLevel[0], $CellContext`FrontFaceColor -> 
                    GrayLevel[0], $CellContext`GraphicsColor -> GrayLevel[0], 
                    FontSize -> Scaled[0.04000000000000001], FontColor -> 
                    GrayLevel[0], $CellContext`BackFaceColor -> GrayLevel[0]],
                     Background -> RGBColor[1., 1., 0.871], FrameStyle -> 
                    GrayLevel[0.5], StripOnInput -> False], 10], 
                    TagBox[
                    SuperscriptBox["x", "x"], HoldForm]], Annotation[#, 
                    HoldForm[$CellContext`x^$CellContext`x], "Tooltip"]& ], 
                  TagBox[
                   TooltipBox[
                    InsetBox[
                    FrameBox[
                    StyleBox[
                    TagBox["x", HoldForm], "StandardForm", "Output", 
                    StripOnInput -> False, $CellContext`LineColor -> 
                    GrayLevel[0], $CellContext`FrontFaceColor -> 
                    GrayLevel[0], $CellContext`GraphicsColor -> GrayLevel[0], 
                    FontSize -> Scaled[0.04000000000000001], FontColor -> 
                    GrayLevel[0], $CellContext`BackFaceColor -> GrayLevel[0]],
                     Background -> RGBColor[1., 1., 0.871], FrameStyle -> 
                    GrayLevel[0.5], StripOnInput -> False], 11], 
                    TagBox["x", HoldForm]], Annotation[#, 
                    HoldForm[$CellContext`x], "Tooltip"]& ], 
                  TagBox[
                   TooltipBox[
                    InsetBox[
                    FrameBox[
                    StyleBox[
                    TagBox["x", HoldForm], "StandardForm", "Output", 
                    StripOnInput -> False, $CellContext`LineColor -> 
                    GrayLevel[0], $CellContext`FrontFaceColor -> 
                    GrayLevel[0], $CellContext`GraphicsColor -> GrayLevel[0], 
                    FontSize -> Scaled[0.04000000000000001], FontColor -> 
                    GrayLevel[0], $CellContext`BackFaceColor -> GrayLevel[0]],
                     Background -> RGBColor[1., 1., 0.871], FrameStyle -> 
                    GrayLevel[0.5], StripOnInput -> False], 12], 
                    TagBox["x", HoldForm]], Annotation[#, 
                    HoldForm[$CellContext`x], "Tooltip"]& ], 
                  TagBox[
                   TooltipBox[
                    InsetBox[
                    FrameBox[
                    StyleBox[
                    "Power", "StandardForm", "Output", StripOnInput -> 
                    False, $CellContext`LineColor -> 
                    GrayLevel[0], $CellContext`FrontFaceColor -> 
                    GrayLevel[0], $CellContext`GraphicsColor -> GrayLevel[0], 
                    FontSize -> Scaled[0.04000000000000001], FontColor -> 
                    GrayLevel[0], $CellContext`BackFaceColor -> GrayLevel[0]],
                     Background -> RGBColor[1., 1., 0.871], FrameStyle -> 
                    GrayLevel[0.5], StripOnInput -> False], 13], 
                    TagBox[
                    SuperscriptBox["x", "x"], HoldForm]], Annotation[#, 
                    HoldForm[$CellContext`x^$CellContext`x], "Tooltip"]& ], 
                  TagBox[
                   TooltipBox[
                    InsetBox[
                    FrameBox[
                    StyleBox[
                    TagBox["x", HoldForm], "StandardForm", "Output", 
                    StripOnInput -> False, $CellContext`LineColor -> 
                    GrayLevel[0], $CellContext`FrontFaceColor -> 
                    GrayLevel[0], $CellContext`GraphicsColor -> GrayLevel[0], 
                    FontSize -> Scaled[0.04000000000000001], FontColor -> 
                    GrayLevel[0], $CellContext`BackFaceColor -> GrayLevel[0]],
                     Background -> RGBColor[1., 1., 0.871], FrameStyle -> 
                    GrayLevel[0.5], StripOnInput -> False], 14], 
                    TagBox["x", HoldForm]], Annotation[#, 
                    HoldForm[$CellContext`x], "Tooltip"]& ], 
                  TagBox[
                   TooltipBox[
                    InsetBox[
                    FrameBox[
                    StyleBox[
                    TagBox["x", HoldForm], "StandardForm", "Output", 
                    StripOnInput -> False, $CellContext`LineColor -> 
                    GrayLevel[0], $CellContext`FrontFaceColor -> 
                    GrayLevel[0], $CellContext`GraphicsColor -> GrayLevel[0], 
                    FontSize -> Scaled[0.04000000000000001], FontColor -> 
                    GrayLevel[0], $CellContext`BackFaceColor -> GrayLevel[0]],
                     Background -> RGBColor[1., 1., 0.871], FrameStyle -> 
                    GrayLevel[0.5], StripOnInput -> False], 15], 
                    TagBox["x", HoldForm]], Annotation[#, 
                    HoldForm[$CellContext`x], "Tooltip"]& ]}}], 
               Annotation[#, 
                VertexCoordinateRules -> {{2.4748737341529163`, 
                 2.1213203435596424`}, {1.0606601717798212`, 
                 1.414213562373095}, {0.35355339059327373`, 
                 0.7071067811865475}, {0., 0.}, {0.7071067811865475, 0.}, {
                 1.7677669529663687`, 0.7071067811865475}, {1.414213562373095,
                  0.}, {2.1213203435596424`, 0.}, {3.8890872965260113`, 
                 1.414213562373095}, {3.181980515339464, 
                 0.7071067811865475}, {2.82842712474619, 0.}, {
                 3.5355339059327373`, 0.}, {4.596194077712559, 
                 0.7071067811865475}, {4.242640687119285, 0.}, {
                 4.949747468305833, 0.}}]& ], AspectRatio -> 
              NCache[Rational[2, 5]^Rational[1, 2], 0.6324555320336759], 
              FormatType :> StandardForm, FrameTicks -> Automatic, PlotRange -> 
              All, PlotRangePadding -> Scaled[0.1]], ",", 
             GraphicsBox[
              TagBox[
               GraphicsComplexBox[CompressedData["
1:eJxTTMoPSmViYGCQB2IQ/Vrf/CJPkKCDrPEE1+WVTA47de7FFGkxOKzxiXhR
te23/Wow/doeIv8JSl+ylwPTj+wZ0IAsmvgT+y9ighLf4eph5sDkV0PtgfHd
3Zb9d03ndICpa7B00rtzgsUBVT+TA6r57HA+XzDXxfWsfHD1EPO54fIQ/wnA
+ZWe/4sf9EnB/bvJZvaisg+icPv9zF7udFwojGa/EFw/xH0icL6Ys2/3ansJ
uHqI+8Th8hD/ScL5DmHJrl668nD77vpvjBG9J4Pmfmk0/8nB+UHruKbb71OA
q4f4TwEuD4lfRTgfALxPla0=
                "], {{{{
                    RGBColor[0.55, 0.45, 0.45], 
                    
                    LineBox[{{1, 2}, {1, 17}, {2, 3}, {2, 10}, {3, 4}, {3, 
                    7}, {4, 5}, {4, 6}, {7, 8}, {7, 9}, {10, 11}, {10, 14}, {
                    11, 12}, {11, 13}, {14, 15}, {14, 16}, {17, 18}, {17, 
                    25}, {18, 19}, {18, 22}, {19, 20}, {19, 21}, {22, 23}, {
                    22, 24}, {25, 26}, {25, 29}, {26, 27}, {26, 28}, {29, 
                    30}, {29, 31}}]}}}, {
                  TagBox[
                   TooltipBox[
                    InsetBox[
                    FrameBox[
                    StyleBox[
                    "Power", "StandardForm", "Output", StripOnInput -> 
                    False, $CellContext`LineColor -> 
                    GrayLevel[0], $CellContext`FrontFaceColor -> 
                    GrayLevel[0], $CellContext`GraphicsColor -> GrayLevel[0], 
                    FontSize -> Scaled[0.020000000000000004`], FontColor -> 
                    GrayLevel[0], $CellContext`BackFaceColor -> GrayLevel[0]],
                     Background -> RGBColor[1., 1., 0.871], FrameStyle -> 
                    GrayLevel[0.5], StripOnInput -> False], 1], 
                    TagBox[
                    SuperscriptBox[
                    RowBox[{"(", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    SuperscriptBox["x", "x"], ")"}], 
                    SuperscriptBox["x", "x"]], ")"}], 
                    SuperscriptBox[
                    RowBox[{"(", 
                    SuperscriptBox["x", "x"], ")"}], 
                    SuperscriptBox["x", "x"]]], ")"}], 
                    SuperscriptBox[
                    RowBox[{"(", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    SuperscriptBox["x", "x"], ")"}], 
                    SuperscriptBox["x", "x"]], ")"}], 
                    SuperscriptBox[
                    RowBox[{"(", 
                    SuperscriptBox["x", "x"], ")"}], 
                    SuperscriptBox["x", "x"]]]], HoldForm]], Annotation[#, 
                    
                    HoldForm[((($CellContext`x^$CellContext`x)^($CellContext`\
x^$CellContext`x))^(($CellContext`x^$CellContext`x)^($CellContext`x^$\
CellContext`x)))^((($CellContext`x^$CellContext`x)^($CellContext`x^$\
CellContext`x))^(($CellContext`x^$CellContext`x)^($CellContext`x^$CellContext`\
x)))], "Tooltip"]& ], 
                  TagBox[
                   TooltipBox[
                    InsetBox[
                    FrameBox[
                    StyleBox[
                    "Power", "StandardForm", "Output", StripOnInput -> 
                    False, $CellContext`LineColor -> 
                    GrayLevel[0], $CellContext`FrontFaceColor -> 
                    GrayLevel[0], $CellContext`GraphicsColor -> GrayLevel[0], 
                    FontSize -> Scaled[0.020000000000000004`], FontColor -> 
                    GrayLevel[0], $CellContext`BackFaceColor -> GrayLevel[0]],
                     Background -> RGBColor[1., 1., 0.871], FrameStyle -> 
                    GrayLevel[0.5], StripOnInput -> False], 2], 
                    TagBox[
                    SuperscriptBox[
                    RowBox[{"(", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    SuperscriptBox["x", "x"], ")"}], 
                    SuperscriptBox["x", "x"]], ")"}], 
                    SuperscriptBox[
                    RowBox[{"(", 
                    SuperscriptBox["x", "x"], ")"}], 
                    SuperscriptBox["x", "x"]]], HoldForm]], Annotation[#, 
                    
                    HoldForm[(($CellContext`x^$CellContext`x)^($CellContext`x^\
$CellContext`x))^(($CellContext`x^$CellContext`x)^($CellContext`x^$\
CellContext`x))], "Tooltip"]& ], 
                  TagBox[
                   TooltipBox[
                    InsetBox[
                    FrameBox[
                    StyleBox[
                    "Power", "StandardForm", "Output", StripOnInput -> 
                    False, $CellContext`LineColor -> 
                    GrayLevel[0], $CellContext`FrontFaceColor -> 
                    GrayLevel[0], $CellContext`GraphicsColor -> GrayLevel[0], 
                    FontSize -> Scaled[0.020000000000000004`], FontColor -> 
                    GrayLevel[0], $CellContext`BackFaceColor -> GrayLevel[0]],
                     Background -> RGBColor[1., 1., 0.871], FrameStyle -> 
                    GrayLevel[0.5], StripOnInput -> False], 3], 
                    TagBox[
                    SuperscriptBox[
                    RowBox[{"(", 
                    SuperscriptBox["x", "x"], ")"}], 
                    SuperscriptBox["x", "x"]], HoldForm]], Annotation[#, 
                    
                    HoldForm[($CellContext`x^$CellContext`x)^($CellContext`x^$\
CellContext`x)], "Tooltip"]& ], 
                  TagBox[
                   TooltipBox[
                    InsetBox[
                    FrameBox[
                    StyleBox[
                    "Power", "StandardForm", "Output", StripOnInput -> 
                    False, $CellContext`LineColor -> 
                    GrayLevel[0], $CellContext`FrontFaceColor -> 
                    GrayLevel[0], $CellContext`GraphicsColor -> GrayLevel[0], 
                    FontSize -> Scaled[0.020000000000000004`], FontColor -> 
                    GrayLevel[0], $CellContext`BackFaceColor -> GrayLevel[0]],
                     Background -> RGBColor[1., 1., 0.871], FrameStyle -> 
                    GrayLevel[0.5], StripOnInput -> False], 4], 
                    TagBox[
                    SuperscriptBox["x", "x"], HoldForm]], Annotation[#, 
                    HoldForm[$CellContext`x^$CellContext`x], "Tooltip"]& ], 
                  TagBox[
                   TooltipBox[
                    InsetBox[
                    FrameBox[
                    StyleBox[
                    TagBox["x", HoldForm], "StandardForm", "Output", 
                    StripOnInput -> False, $CellContext`LineColor -> 
                    GrayLevel[0], $CellContext`FrontFaceColor -> 
                    GrayLevel[0], $CellContext`GraphicsColor -> GrayLevel[0], 
                    FontSize -> Scaled[0.020000000000000004`], FontColor -> 
                    GrayLevel[0], $CellContext`BackFaceColor -> GrayLevel[0]],
                     Background -> RGBColor[1., 1., 0.871], FrameStyle -> 
                    GrayLevel[0.5], StripOnInput -> False], 5], 
                    TagBox["x", HoldForm]], Annotation[#, 
                    HoldForm[$CellContext`x], "Tooltip"]& ], 
                  TagBox[
                   TooltipBox[
                    InsetBox[
                    FrameBox[
                    StyleBox[
                    TagBox["x", HoldForm], "StandardForm", "Output", 
                    StripOnInput -> False, $CellContext`LineColor -> 
                    GrayLevel[0], $CellContext`FrontFaceColor -> 
                    GrayLevel[0], $CellContext`GraphicsColor -> GrayLevel[0], 
                    FontSize -> Scaled[0.020000000000000004`], FontColor -> 
                    GrayLevel[0], $CellContext`BackFaceColor -> GrayLevel[0]],
                     Background -> RGBColor[1., 1., 0.871], FrameStyle -> 
                    GrayLevel[0.5], StripOnInput -> False], 6], 
                    TagBox["x", HoldForm]], Annotation[#, 
                    HoldForm[$CellContext`x], "Tooltip"]& ], 
                  TagBox[
                   TooltipBox[
                    InsetBox[
                    FrameBox[
                    StyleBox[
                    "Power", "StandardForm", "Output", StripOnInput -> 
                    False, $CellContext`LineColor -> 
                    GrayLevel[0], $CellContext`FrontFaceColor -> 
                    GrayLevel[0], $CellContext`GraphicsColor -> GrayLevel[0], 
                    FontSize -> Scaled[0.020000000000000004`], FontColor -> 
                    GrayLevel[0], $CellContext`BackFaceColor -> GrayLevel[0]],
                     Background -> RGBColor[1., 1., 0.871], FrameStyle -> 
                    GrayLevel[0.5], StripOnInput -> False], 7], 
                    TagBox[
                    SuperscriptBox["x", "x"], HoldForm]], Annotation[#, 
                    HoldForm[$CellContext`x^$CellContext`x], "Tooltip"]& ], 
                  TagBox[
                   TooltipBox[
                    InsetBox[
                    FrameBox[
                    StyleBox[
                    TagBox["x", HoldForm], "StandardForm", "Output", 
                    StripOnInput -> False, $CellContext`LineColor -> 
                    GrayLevel[0], $CellContext`FrontFaceColor -> 
                    GrayLevel[0], $CellContext`GraphicsColor -> GrayLevel[0], 
                    FontSize -> Scaled[0.020000000000000004`], FontColor -> 
                    GrayLevel[0], $CellContext`BackFaceColor -> GrayLevel[0]],
                     Background -> RGBColor[1., 1., 0.871], FrameStyle -> 
                    GrayLevel[0.5], StripOnInput -> False], 8], 
                    TagBox["x", HoldForm]], Annotation[#, 
                    HoldForm[$CellContext`x], "Tooltip"]& ], 
                  TagBox[
                   TooltipBox[
                    InsetBox[
                    FrameBox[
                    StyleBox[
                    TagBox["x", HoldForm], "StandardForm", "Output", 
                    StripOnInput -> False, $CellContext`LineColor -> 
                    GrayLevel[0], $CellContext`FrontFaceColor -> 
                    GrayLevel[0], $CellContext`GraphicsColor -> GrayLevel[0], 
                    FontSize -> Scaled[0.020000000000000004`], FontColor -> 
                    GrayLevel[0], $CellContext`BackFaceColor -> GrayLevel[0]],
                     Background -> RGBColor[1., 1., 0.871], FrameStyle -> 
                    GrayLevel[0.5], StripOnInput -> False], 9], 
                    TagBox["x", HoldForm]], Annotation[#, 
                    HoldForm[$CellContext`x], "Tooltip"]& ], 
                  TagBox[
                   TooltipBox[
                    InsetBox[
                    FrameBox[
                    StyleBox[
                    "Power", "StandardForm", "Output", StripOnInput -> 
                    False, $CellContext`LineColor -> 
                    GrayLevel[0], $CellContext`FrontFaceColor -> 
                    GrayLevel[0], $CellContext`GraphicsColor -> GrayLevel[0], 
                    FontSize -> Scaled[0.020000000000000004`], FontColor -> 
                    GrayLevel[0], $CellContext`BackFaceColor -> GrayLevel[0]],
                     Background -> RGBColor[1., 1., 0.871], FrameStyle -> 
                    GrayLevel[0.5], StripOnInput -> False], 10], 
                    TagBox[
                    SuperscriptBox[
                    RowBox[{"(", 
                    SuperscriptBox["x", "x"], ")"}], 
                    SuperscriptBox["x", "x"]], HoldForm]], Annotation[#, 
                    
                    HoldForm[($CellContext`x^$CellContext`x)^($CellContext`x^$\
CellContext`x)], "Tooltip"]& ], 
                  TagBox[
                   TooltipBox[
                    InsetBox[
                    FrameBox[
                    StyleBox[
                    "Power", "StandardForm", "Output", StripOnInput -> 
                    False, $CellContext`LineColor -> 
                    GrayLevel[0], $CellContext`FrontFaceColor -> 
                    GrayLevel[0], $CellContext`GraphicsColor -> GrayLevel[0], 
                    FontSize -> Scaled[0.020000000000000004`], FontColor -> 
                    GrayLevel[0], $CellContext`BackFaceColor -> GrayLevel[0]],
                     Background -> RGBColor[1., 1., 0.871], FrameStyle -> 
                    GrayLevel[0.5], StripOnInput -> False], 11], 
                    TagBox[
                    SuperscriptBox["x", "x"], HoldForm]], Annotation[#, 
                    HoldForm[$CellContext`x^$CellContext`x], "Tooltip"]& ], 
                  TagBox[
                   TooltipBox[
                    InsetBox[
                    FrameBox[
                    StyleBox[
                    TagBox["x", HoldForm], "StandardForm", "Output", 
                    StripOnInput -> False, $CellContext`LineColor -> 
                    GrayLevel[0], $CellContext`FrontFaceColor -> 
                    GrayLevel[0], $CellContext`GraphicsColor -> GrayLevel[0], 
                    FontSize -> Scaled[0.020000000000000004`], FontColor -> 
                    GrayLevel[0], $CellContext`BackFaceColor -> GrayLevel[0]],
                     Background -> RGBColor[1., 1., 0.871], FrameStyle -> 
                    GrayLevel[0.5], StripOnInput -> False], 12], 
                    TagBox["x", HoldForm]], Annotation[#, 
                    HoldForm[$CellContext`x], "Tooltip"]& ], 
                  TagBox[
                   TooltipBox[
                    InsetBox[
                    FrameBox[
                    StyleBox[
                    TagBox["x", HoldForm], "StandardForm", "Output", 
                    StripOnInput -> False, $CellContext`LineColor -> 
                    GrayLevel[0], $CellContext`FrontFaceColor -> 
                    GrayLevel[0], $CellContext`GraphicsColor -> GrayLevel[0], 
                    FontSize -> Scaled[0.020000000000000004`], FontColor -> 
                    GrayLevel[0], $CellContext`BackFaceColor -> GrayLevel[0]],
                     Background -> RGBColor[1., 1., 0.871], FrameStyle -> 
                    GrayLevel[0.5], StripOnInput -> False], 13], 
                    TagBox["x", HoldForm]], Annotation[#, 
                    HoldForm[$CellContext`x], "Tooltip"]& ], 
                  TagBox[
                   TooltipBox[
                    InsetBox[
                    FrameBox[
                    StyleBox[
                    "Power", "StandardForm", "Output", StripOnInput -> 
                    False, $CellContext`LineColor -> 
                    GrayLevel[0], $CellContext`FrontFaceColor -> 
                    GrayLevel[0], $CellContext`GraphicsColor -> GrayLevel[0], 
                    FontSize -> Scaled[0.020000000000000004`], FontColor -> 
                    GrayLevel[0], $CellContext`BackFaceColor -> GrayLevel[0]],
                     Background -> RGBColor[1., 1., 0.871], FrameStyle -> 
                    GrayLevel[0.5], StripOnInput -> False], 14], 
                    TagBox[
                    SuperscriptBox["x", "x"], HoldForm]], Annotation[#, 
                    HoldForm[$CellContext`x^$CellContext`x], "Tooltip"]& ], 
                  TagBox[
                   TooltipBox[
                    InsetBox[
                    FrameBox[
                    StyleBox[
                    TagBox["x", HoldForm], "StandardForm", "Output", 
                    StripOnInput -> False, $CellContext`LineColor -> 
                    GrayLevel[0], $CellContext`FrontFaceColor -> 
                    GrayLevel[0], $CellContext`GraphicsColor -> GrayLevel[0], 
                    FontSize -> Scaled[0.020000000000000004`], FontColor -> 
                    GrayLevel[0], $CellContext`BackFaceColor -> GrayLevel[0]],
                     Background -> RGBColor[1., 1., 0.871], FrameStyle -> 
                    GrayLevel[0.5], StripOnInput -> False], 15], 
                    TagBox["x", HoldForm]], Annotation[#, 
                    HoldForm[$CellContext`x], "Tooltip"]& ], 
                  TagBox[
                   TooltipBox[
                    InsetBox[
                    FrameBox[
                    StyleBox[
                    TagBox["x", HoldForm], "StandardForm", "Output", 
                    StripOnInput -> False, $CellContext`LineColor -> 
                    GrayLevel[0], $CellContext`FrontFaceColor -> 
                    GrayLevel[0], $CellContext`GraphicsColor -> GrayLevel[0], 
                    FontSize -> Scaled[0.020000000000000004`], FontColor -> 
                    GrayLevel[0], $CellContext`BackFaceColor -> GrayLevel[0]],
                     Background -> RGBColor[1., 1., 0.871], FrameStyle -> 
                    GrayLevel[0.5], StripOnInput -> False], 16], 
                    TagBox["x", HoldForm]], Annotation[#, 
                    HoldForm[$CellContext`x], "Tooltip"]& ], 
                  TagBox[
                   TooltipBox[
                    InsetBox[
                    FrameBox[
                    StyleBox[
                    "Power", "StandardForm", "Output", StripOnInput -> 
                    False, $CellContext`LineColor -> 
                    GrayLevel[0], $CellContext`FrontFaceColor -> 
                    GrayLevel[0], $CellContext`GraphicsColor -> GrayLevel[0], 
                    FontSize -> Scaled[0.020000000000000004`], FontColor -> 
                    GrayLevel[0], $CellContext`BackFaceColor -> GrayLevel[0]],
                     Background -> RGBColor[1., 1., 0.871], FrameStyle -> 
                    GrayLevel[0.5], StripOnInput -> False], 17], 
                    TagBox[
                    SuperscriptBox[
                    RowBox[{"(", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    SuperscriptBox["x", "x"], ")"}], 
                    SuperscriptBox["x", "x"]], ")"}], 
                    SuperscriptBox[
                    RowBox[{"(", 
                    SuperscriptBox["x", "x"], ")"}], 
                    SuperscriptBox["x", "x"]]], HoldForm]], Annotation[#, 
                    
                    HoldForm[(($CellContext`x^$CellContext`x)^($CellContext`x^\
$CellContext`x))^(($CellContext`x^$CellContext`x)^($CellContext`x^$\
CellContext`x))], "Tooltip"]& ], 
                  TagBox[
                   TooltipBox[
                    InsetBox[
                    FrameBox[
                    StyleBox[
                    "Power", "StandardForm", "Output", StripOnInput -> 
                    False, $CellContext`LineColor -> 
                    GrayLevel[0], $CellContext`FrontFaceColor -> 
                    GrayLevel[0], $CellContext`GraphicsColor -> GrayLevel[0], 
                    FontSize -> Scaled[0.020000000000000004`], FontColor -> 
                    GrayLevel[0], $CellContext`BackFaceColor -> GrayLevel[0]],
                     Background -> RGBColor[1., 1., 0.871], FrameStyle -> 
                    GrayLevel[0.5], StripOnInput -> False], 18], 
                    TagBox[
                    SuperscriptBox[
                    RowBox[{"(", 
                    SuperscriptBox["x", "x"], ")"}], 
                    SuperscriptBox["x", "x"]], HoldForm]], Annotation[#, 
                    
                    HoldForm[($CellContext`x^$CellContext`x)^($CellContext`x^$\
CellContext`x)], "Tooltip"]& ], 
                  TagBox[
                   TooltipBox[
                    InsetBox[
                    FrameBox[
                    StyleBox[
                    "Power", "StandardForm", "Output", StripOnInput -> 
                    False, $CellContext`LineColor -> 
                    GrayLevel[0], $CellContext`FrontFaceColor -> 
                    GrayLevel[0], $CellContext`GraphicsColor -> GrayLevel[0], 
                    FontSize -> Scaled[0.020000000000000004`], FontColor -> 
                    GrayLevel[0], $CellContext`BackFaceColor -> GrayLevel[0]],
                     Background -> RGBColor[1., 1., 0.871], FrameStyle -> 
                    GrayLevel[0.5], StripOnInput -> False], 19], 
                    TagBox[
                    SuperscriptBox["x", "x"], HoldForm]], Annotation[#, 
                    HoldForm[$CellContext`x^$CellContext`x], "Tooltip"]& ], 
                  TagBox[
                   TooltipBox[
                    InsetBox[
                    FrameBox[
                    StyleBox[
                    TagBox["x", HoldForm], "StandardForm", "Output", 
                    StripOnInput -> False, $CellContext`LineColor -> 
                    GrayLevel[0], $CellContext`FrontFaceColor -> 
                    GrayLevel[0], $CellContext`GraphicsColor -> GrayLevel[0], 
                    FontSize -> Scaled[0.020000000000000004`], FontColor -> 
                    GrayLevel[0], $CellContext`BackFaceColor -> GrayLevel[0]],
                     Background -> RGBColor[1., 1., 0.871], FrameStyle -> 
                    GrayLevel[0.5], StripOnInput -> False], 20], 
                    TagBox["x", HoldForm]], Annotation[#, 
                    HoldForm[$CellContext`x], "Tooltip"]& ], 
                  TagBox[
                   TooltipBox[
                    InsetBox[
                    FrameBox[
                    StyleBox[
                    TagBox["x", HoldForm], "StandardForm", "Output", 
                    StripOnInput -> False, $CellContext`LineColor -> 
                    GrayLevel[0], $CellContext`FrontFaceColor -> 
                    GrayLevel[0], $CellContext`GraphicsColor -> GrayLevel[0], 
                    FontSize -> Scaled[0.020000000000000004`], FontColor -> 
                    GrayLevel[0], $CellContext`BackFaceColor -> GrayLevel[0]],
                     Background -> RGBColor[1., 1., 0.871], FrameStyle -> 
                    GrayLevel[0.5], StripOnInput -> False], 21], 
                    TagBox["x", HoldForm]], Annotation[#, 
                    HoldForm[$CellContext`x], "Tooltip"]& ], 
                  TagBox[
                   TooltipBox[
                    InsetBox[
                    FrameBox[
                    StyleBox[
                    "Power", "StandardForm", "Output", StripOnInput -> 
                    False, $CellContext`LineColor -> 
                    GrayLevel[0], $CellContext`FrontFaceColor -> 
                    GrayLevel[0], $CellContext`GraphicsColor -> GrayLevel[0], 
                    FontSize -> Scaled[0.020000000000000004`], FontColor -> 
                    GrayLevel[0], $CellContext`BackFaceColor -> GrayLevel[0]],
                     Background -> RGBColor[1., 1., 0.871], FrameStyle -> 
                    GrayLevel[0.5], StripOnInput -> False], 22], 
                    TagBox[
                    SuperscriptBox["x", "x"], HoldForm]], Annotation[#, 
                    HoldForm[$CellContext`x^$CellContext`x], "Tooltip"]& ], 
                  TagBox[
                   TooltipBox[
                    InsetBox[
                    FrameBox[
                    StyleBox[
                    TagBox["x", HoldForm], "StandardForm", "Output", 
                    StripOnInput -> False, $CellContext`LineColor -> 
                    GrayLevel[0], $CellContext`FrontFaceColor -> 
                    GrayLevel[0], $CellContext`GraphicsColor -> GrayLevel[0], 
                    FontSize -> Scaled[0.020000000000000004`], FontColor -> 
                    GrayLevel[0], $CellContext`BackFaceColor -> GrayLevel[0]],
                     Background -> RGBColor[1., 1., 0.871], FrameStyle -> 
                    GrayLevel[0.5], StripOnInput -> False], 23], 
                    TagBox["x", HoldForm]], Annotation[#, 
                    HoldForm[$CellContext`x], "Tooltip"]& ], 
                  TagBox[
                   TooltipBox[
                    InsetBox[
                    FrameBox[
                    StyleBox[
                    TagBox["x", HoldForm], "StandardForm", "Output", 
                    StripOnInput -> False, $CellContext`LineColor -> 
                    GrayLevel[0], $CellContext`FrontFaceColor -> 
                    GrayLevel[0], $CellContext`GraphicsColor -> GrayLevel[0], 
                    FontSize -> Scaled[0.020000000000000004`], FontColor -> 
                    GrayLevel[0], $CellContext`BackFaceColor -> GrayLevel[0]],
                     Background -> RGBColor[1., 1., 0.871], FrameStyle -> 
                    GrayLevel[0.5], StripOnInput -> False], 24], 
                    TagBox["x", HoldForm]], Annotation[#, 
                    HoldForm[$CellContext`x], "Tooltip"]& ], 
                  TagBox[
                   TooltipBox[
                    InsetBox[
                    FrameBox[
                    StyleBox[
                    "Power", "StandardForm", "Output", StripOnInput -> 
                    False, $CellContext`LineColor -> 
                    GrayLevel[0], $CellContext`FrontFaceColor -> 
                    GrayLevel[0], $CellContext`GraphicsColor -> GrayLevel[0], 
                    FontSize -> Scaled[0.020000000000000004`], FontColor -> 
                    GrayLevel[0], $CellContext`BackFaceColor -> GrayLevel[0]],
                     Background -> RGBColor[1., 1., 0.871], FrameStyle -> 
                    GrayLevel[0.5], StripOnInput -> False], 25], 
                    TagBox[
                    SuperscriptBox[
                    RowBox[{"(", 
                    SuperscriptBox["x", "x"], ")"}], 
                    SuperscriptBox["x", "x"]], HoldForm]], Annotation[#, 
                    
                    HoldForm[($CellContext`x^$CellContext`x)^($CellContext`x^$\
CellContext`x)], "Tooltip"]& ], 
                  TagBox[
                   TooltipBox[
                    InsetBox[
                    FrameBox[
                    StyleBox[
                    "Power", "StandardForm", "Output", StripOnInput -> 
                    False, $CellContext`LineColor -> 
                    GrayLevel[0], $CellContext`FrontFaceColor -> 
                    GrayLevel[0], $CellContext`GraphicsColor -> GrayLevel[0], 
                    FontSize -> Scaled[0.020000000000000004`], FontColor -> 
                    GrayLevel[0], $CellContext`BackFaceColor -> GrayLevel[0]],
                     Background -> RGBColor[1., 1., 0.871], FrameStyle -> 
                    GrayLevel[0.5], StripOnInput -> False], 26], 
                    TagBox[
                    SuperscriptBox["x", "x"], HoldForm]], Annotation[#, 
                    HoldForm[$CellContext`x^$CellContext`x], "Tooltip"]& ], 
                  TagBox[
                   TooltipBox[
                    InsetBox[
                    FrameBox[
                    StyleBox[
                    TagBox["x", HoldForm], "StandardForm", "Output", 
                    StripOnInput -> False, $CellContext`LineColor -> 
                    GrayLevel[0], $CellContext`FrontFaceColor -> 
                    GrayLevel[0], $CellContext`GraphicsColor -> GrayLevel[0], 
                    FontSize -> Scaled[0.020000000000000004`], FontColor -> 
                    GrayLevel[0], $CellContext`BackFaceColor -> GrayLevel[0]],
                     Background -> RGBColor[1., 1., 0.871], FrameStyle -> 
                    GrayLevel[0.5], StripOnInput -> False], 27], 
                    TagBox["x", HoldForm]], Annotation[#, 
                    HoldForm[$CellContext`x], "Tooltip"]& ], 
                  TagBox[
                   TooltipBox[
                    InsetBox[
                    FrameBox[
                    StyleBox[
                    TagBox["x", HoldForm], "StandardForm", "Output", 
                    StripOnInput -> False, $CellContext`LineColor -> 
                    GrayLevel[0], $CellContext`FrontFaceColor -> 
                    GrayLevel[0], $CellContext`GraphicsColor -> GrayLevel[0], 
                    FontSize -> Scaled[0.020000000000000004`], FontColor -> 
                    GrayLevel[0], $CellContext`BackFaceColor -> GrayLevel[0]],
                     Background -> RGBColor[1., 1., 0.871], FrameStyle -> 
                    GrayLevel[0.5], StripOnInput -> False], 28], 
                    TagBox["x", HoldForm]], Annotation[#, 
                    HoldForm[$CellContext`x], "Tooltip"]& ], 
                  TagBox[
                   TooltipBox[
                    InsetBox[
                    FrameBox[
                    StyleBox[
                    "Power", "StandardForm", "Output", StripOnInput -> 
                    False, $CellContext`LineColor -> 
                    GrayLevel[0], $CellContext`FrontFaceColor -> 
                    GrayLevel[0], $CellContext`GraphicsColor -> GrayLevel[0], 
                    FontSize -> Scaled[0.020000000000000004`], FontColor -> 
                    GrayLevel[0], $CellContext`BackFaceColor -> GrayLevel[0]],
                     Background -> RGBColor[1., 1., 0.871], FrameStyle -> 
                    GrayLevel[0.5], StripOnInput -> False], 29], 
                    TagBox[
                    SuperscriptBox["x", "x"], HoldForm]], Annotation[#, 
                    HoldForm[$CellContext`x^$CellContext`x], "Tooltip"]& ], 
                  TagBox[
                   TooltipBox[
                    InsetBox[
                    FrameBox[
                    StyleBox[
                    TagBox["x", HoldForm], "StandardForm", "Output", 
                    StripOnInput -> False, $CellContext`LineColor -> 
                    GrayLevel[0], $CellContext`FrontFaceColor -> 
                    GrayLevel[0], $CellContext`GraphicsColor -> GrayLevel[0], 
                    FontSize -> Scaled[0.020000000000000004`], FontColor -> 
                    GrayLevel[0], $CellContext`BackFaceColor -> GrayLevel[0]],
                     Background -> RGBColor[1., 1., 0.871], FrameStyle -> 
                    GrayLevel[0.5], StripOnInput -> False], 30], 
                    TagBox["x", HoldForm]], Annotation[#, 
                    HoldForm[$CellContext`x], "Tooltip"]& ], 
                  TagBox[
                   TooltipBox[
                    InsetBox[
                    FrameBox[
                    StyleBox[
                    TagBox["x", HoldForm], "StandardForm", "Output", 
                    StripOnInput -> False, $CellContext`LineColor -> 
                    GrayLevel[0], $CellContext`FrontFaceColor -> 
                    GrayLevel[0], $CellContext`GraphicsColor -> GrayLevel[0], 
                    FontSize -> Scaled[0.020000000000000004`], FontColor -> 
                    GrayLevel[0], $CellContext`BackFaceColor -> GrayLevel[0]],
                     Background -> RGBColor[1., 1., 0.871], FrameStyle -> 
                    GrayLevel[0.5], StripOnInput -> False], 31], 
                    TagBox["x", HoldForm]], Annotation[#, 
                    HoldForm[$CellContext`x], "Tooltip"]& ]}}], 
               Annotation[#, VertexCoordinateRules -> CompressedData["
1:eJxTTMoPSmViYGCQB2IQ/Vrf/CJPkKCDrPEE1+WVTA47de7FFGkxOKzxiXhR
te23/Wow/doeIv8JSl+ylwPTj+wZ0IAsmvgT+y9ighLf4eph5sDkV0PtgfHd
3Zb9d03ndICpa7B00rtzgsUBVT+TA6r57HA+XzDXxfWsfHD1EPO54fIQ/wnA
+ZWe/4sf9EnB/bvJZvaisg+icPv9zF7udFwojGa/EFw/xH0icL6Ys2/3ansJ
uHqI+8Th8hD/ScL5DmHJrl668nD77vpvjBG9J4Pmfmk0/8nB+UHruKbb71OA
q4f4TwEuD4lfRTgfALxPla0=
                 "]]& ], AspectRatio -> NCache[
                Rational[1, 2], 0.5], FormatType :> StandardForm, FrameTicks -> 
              Automatic, PlotRange -> All, PlotRangePadding -> Scaled[0.1]]}],
            "}"}]], "ExerciseOutput", Selectable -> False, Copyable -> False, 
        Editable -> False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"84c4d9ca-876d-4456-b148-535608a3d692"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Find the unique cases where ",
 Cell[BoxData[
  RowBox[{"i", 
   ButtonBox["^",
    BaseStyle->"Link",
    ButtonData->"Power"], 
   RowBox[{"2", "/", 
    RowBox[{"(", 
     RowBox[{"j", 
      ButtonBox["^",
       BaseStyle->"Link",
       ButtonData->"Power"], "2", 
      ButtonBox["+",
       BaseStyle->"Link",
       ButtonData->"Plus"], "1"}], ")"}]}]}]], "InlineCode",ExpressionUUID->
  "a2d18005-0060-4424-86f0-ab70f8b60d90"],
 " is an integer, with ",
 Cell[BoxData[
 "i"], "InlineCode",ExpressionUUID->"96c8af8a-98c7-4855-b694-6055341a142e"],
 " and ",
 Cell[BoxData[
 "j"], "InlineCode",ExpressionUUID->"a1e27925-c803-463e-b2e2-ee9e6bd9ca74"],
 " going up to 20.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "33.5", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"51497513-b27f-42d8-9a5c-cbbd8ba65959"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       RowBox[{"{", 
        RowBox[{
        "2", ",", "5", ",", "8", ",", "10", ",", "17", ",", "18", ",", "20", 
         ",", "32", ",", "40", ",", "45", ",", "50", ",", "72", ",", "80", 
         ",", "98", ",", "128", ",", "162", ",", "200"}], "}"}]], 
       "ExerciseOutput",ExpressionUUID->
       "1f6cc042-3ae2-4f76-af5d-cd5150dbb0f5"],
      Apply[TextCell, 
       Cell[
        BoxData[
         RowBox[{"{", 
           
           RowBox[{"2", ",", "5", ",", "8", ",", "10", ",", "17", ",", "18", 
             ",", "20", ",", "32", ",", "40", ",", "45", ",", "50", ",", "72",
              ",", "80", ",", "98", ",", "128", ",", "162", ",", "200"}], 
           "}"}]], "ExerciseOutput", Selectable -> False, Copyable -> False, 
        Editable -> False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"59a869c8-76b9-4c19-a81b-cb92fc224433"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Create a graph that connects successive pairs of numbers in ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Table",
    BaseStyle->"CodeLink"], "[", 
   RowBox[{
    RowBox[{
     ButtonBox["Mod",
      BaseStyle->"CodeLink"], "[", 
     RowBox[{
      RowBox[{"n", 
       ButtonBox["^",
        BaseStyle->"Link",
        ButtonData->"Power"], "2", 
       ButtonBox["+",
        BaseStyle->"Link",
        ButtonData->"Plus"], "n"}], ",", "100"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "100"}], "}"}]}], "]"}]], "InlineCode",ExpressionUUID->
  "d309f387-1462-4fc6-bbfa-7154fef293dc"],
 ".",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "33.6", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"d60900df-6ea0-4d2d-ba29-2c9a78085afc"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       GraphicsBox[
        NamespaceBox["NetworkGraphics",
         DynamicModuleBox[{Typeset`graph = HoldComplete[
           
           Graph[{2, 6, 12, 20, 30, 42, 56, 72, 90, 10, 32, 82, 40, 80, 62, 
            52, 0, 50, 70, 92, 22, 
            60}, {{{1, 2}, {2, 3}, {3, 4}, {4, 5}, {5, 6}, {6, 7}, {7, 8}, {8,
              9}, {9, 10}, {10, 11}, {11, 7}, {7, 12}, {12, 10}, {10, 13}, {
             13, 8}, {8, 2}, {2, 6}, {6, 14}, {14, 4}, {4, 15}, {15, 2}, {2, 
             16}, {16, 17}, {17, 18}, {18, 1}, {1, 7}, {7, 3}, {3, 19}, {19, 
             5}, {5, 20}, {20, 7}, {7, 21}, {21, 9}, {9, 22}, {22, 11}, {11, 
             2}, {2, 12}, {12, 22}, {22, 13}, {13, 21}, {21, 2}, {2, 20}, {20,
              14}, {14, 19}, {19, 15}, {15, 7}, {7, 16}, {16, 18}, {18, 18}, {
             18, 16}, {16, 7}, {7, 15}, {15, 19}, {19, 14}, {14, 20}, {20, 
             2}, {2, 21}, {21, 13}, {13, 22}, {22, 12}, {12, 2}, {2, 11}, {11,
              22}, {22, 9}, {9, 21}, {21, 7}, {7, 20}, {20, 5}, {5, 19}, {19, 
             3}, {3, 7}, {7, 1}, {1, 18}, {18, 17}, {17, 16}, {16, 2}, {2, 
             15}, {15, 4}, {4, 14}, {14, 6}, {6, 2}, {2, 8}, {8, 13}, {13, 
             10}, {10, 12}, {12, 7}, {7, 11}, {11, 10}, {10, 9}, {9, 8}, {8, 
             7}, {7, 6}, {6, 5}, {5, 4}, {4, 3}, {3, 2}, {2, 1}, {1, 17}, {17,
              17}}, Null}]]}, 
          TagBox[GraphicsGroupBox[GraphicsComplexBox[CompressedData["
1:eJw8eHc4lf///7nPtuUdSRKVyEhDSOX1lJnIakiIbNmjSMlIJBVFZYQiEYms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             "], {
              {Hue[0.6, 0.7, 0.5], Opacity[0.7], Arrowheads[
               0.023068688797040122`], 
               ArrowBox[BezierCurveBox[{
                1, {2.091254342236005, 1.4355418406226061`}, 2}], 
                0.0372192882181413], 
               ArrowBox[BezierCurveBox[{
                1, {2.0637070670045974`, 1.5229376354467496`}, 7}], 
                0.0372192882181413], ArrowBox[{1, 17}, 0.0372192882181413], 
               ArrowBox[BezierCurveBox[{
                1, {2.5137162571872125`, 0.4514775810224957}, 18}], 
                0.0372192882181413], 
               ArrowBox[BezierCurveBox[{
                2, {2.4374695071320063`, 1.5653234438338393`}, 1}], 
                0.0372192882181413], 
               ArrowBox[BezierCurveBox[{
                2, {2.249595280557066, 2.66055706643758}, 3}], 
                0.0372192882181413], 
               ArrowBox[BezierCurveBox[{
                2, {2.5432359106165747`, 2.3543836633557937`}, 6}], 
                0.0372192882181413], 
               ArrowBox[BezierCurveBox[{
                2, {1.4948808903089774`, 2.3410028248082346`}, 8}], 
                0.0372192882181413], 
               ArrowBox[BezierCurveBox[{
                2, {1.5370653294048309`, 1.728997258823314}, 11}], 
                0.0372192882181413], 
               ArrowBox[BezierCurveBox[{
                2, {1.5108786711306312`, 1.898883399629145}, 12}], 
                0.0372192882181413], 
               ArrowBox[BezierCurveBox[{
                2, {2.366479201511951, 2.5333090304407717`}, 15}], 
                0.0372192882181413], 
               ArrowBox[BezierCurveBox[{
                2, {2.273145394253702, 1.4749827365923578`}, 16}], 
                0.0372192882181413], 
               ArrowBox[BezierCurveBox[{
                2, {2.637471276893463, 2.212049272734071}, 20}], 
                0.0372192882181413], 
               ArrowBox[BezierCurveBox[{
                2, {1.4805739583665403`, 2.1643152325497197`}, 21}], 
                0.0372192882181413], 
               ArrowBox[BezierCurveBox[{
                3, {2.5901438943554407`, 2.428488278186439}, 2}], 
                0.0372192882181413], 
               ArrowBox[BezierCurveBox[{
                3, {3.1940420364838413`, 3.2131239152510616`}, 4}], 
                0.0372192882181413], 
               ArrowBox[BezierCurveBox[{
                3, {2.562596619124038, 2.5158840730100973`}, 7}], 
                0.0372192882181413], 
               ArrowBox[BezierCurveBox[{
                3, {3.214617686555606, 3.3707854552732726`}, 19}], 
                0.0372192882181413], 
               ArrowBox[BezierCurveBox[{
                4, {3.2013351699184818`, 2.9335721430274395`}, 3}], 
                0.0372192882181413], 
               ArrowBox[BezierCurveBox[{
                4, {3.882510349144721, 2.9865856979798724`}, 5}], 
                0.0372192882181413], 
               ArrowBox[BezierCurveBox[{
                4, {3.898403499905146, 2.823187637404343}, 14}], 
                0.0372192882181413], 
               ArrowBox[BezierCurveBox[{
                4, {3.31821909087337, 2.8063241070384057`}, 15}], 
                0.0372192882181413], 
               ArrowBox[BezierCurveBox[{
                5, {3.7737108537552055`, 2.8514692124532623`}, 4}], 
                0.0372192882181413], 
               ArrowBox[BezierCurveBox[{
                5, {3.6459942466828306`, 2.394432140011242}, 6}], 
                0.0372192882181413], 
               ArrowBox[BezierCurveBox[{
                5, {3.7942865038269673`, 3.0091307524797717`}, 19}], 
                0.0372192882181413], 
               ArrowBox[BezierCurveBox[{
                5, {3.740229612959716, 2.252097749385703}, 20}], 
                0.0372192882181413], 
               ArrowBox[BezierCurveBox[{
                6, {2.6447297566380716`, 2.0077896259251897`}, 2}], 
                0.0372192882181413], 
               ArrowBox[BezierCurveBox[{
                6, {3.5084458408608237`, 2.694575148562666}, 5}], 
                0.0372192882181413], 
               ArrowBox[BezierCurveBox[{
                6, {2.617182481406695, 2.0951854207513834`}, 7}], 
                0.0372192882181413], 
               ArrowBox[BezierCurveBox[{
                6, {3.5243389916212418`, 2.5311770880471633`}, 14}], 
                0.0372192882181413], 
               ArrowBox[BezierCurveBox[{
                7, {2.4671745593888543`, 1.6520095857214967`}, 1}], 
                0.0372192882181413], 
               ArrowBox[BezierCurveBox[{
                7, {2.2793003328139134`, 2.747243208329804}, 3}], 
                0.0372192882181413], 
               ArrowBox[BezierCurveBox[{
                7, {2.572940962873418, 2.4410698052378774`}, 6}], 
                0.0372192882181413], 
               ArrowBox[BezierCurveBox[{
                7, {1.5245859425658355`, 2.4276889666993022`}, 8}], 
                0.0372192882181413], 
               ArrowBox[BezierCurveBox[{
                7, {1.5667703816616767`, 1.8156834007118932`}, 11}], 
                0.0372192882181413], 
               ArrowBox[BezierCurveBox[{
                7, {1.5405837233874913`, 1.9855695415234278`}, 12}], 
                0.0372192882181413], 
               ArrowBox[BezierCurveBox[{
                7, {2.3961842537688023`, 2.6199951723450785`}, 15}], 
                0.0372192882181413], 
               ArrowBox[BezierCurveBox[{
                7, {2.3028504465105537`, 1.5616688784792365`}, 16}], 
                0.0372192882181413], 
               ArrowBox[BezierCurveBox[{
                7, {2.6671763291503057`, 2.2987354146166705`}, 20}], 
                0.0372192882181413], 
               ArrowBox[BezierCurveBox[{
                7, {1.510279010623382, 2.2510013744366377`}, 21}], 
                0.0372192882181413], 
               ArrowBox[BezierCurveBox[{
                8, {1.793083251876251, 2.61928412824451}, 2}], 
                0.0372192882181413], 
               ArrowBox[BezierCurveBox[{
                8, {1.7655359766448562`, 2.7066799230719965`}, 7}], 
                0.0372192882181413], 
               ArrowBox[BezierCurveBox[{
                8, {0.7834345837101422, 2.862244083297792}, 9}], 
                0.0372192882181413], 
               ArrowBox[BezierCurveBox[{
                8, {0.6723917305926278, 2.734406681663987}, 13}], 
                0.0372192882181413], 
               ArrowBox[BezierCurveBox[{
                9, {0.8265388589964683, 3.135822868639334}, 8}], 
                0.0372192882181413], 
               ArrowBox[BezierCurveBox[{
                9, {0.34195654079519655`, 2.5523263121740674`}, 10}], 
                0.0372192882181413], 
               ArrowBox[BezierCurveBox[{
                9, {0.8122319270540389, 2.9591352763761853`}, 21}], 
                0.0372192882181413], 
               ArrowBox[BezierCurveBox[{
                9, {0.39590444001331465`, 2.7043003115524558`}, 22}], 
                0.0372192882181413], 
               ArrowBox[BezierCurveBox[{
                10, {0.047107135286736115`, 2.680282155368704}, 9}], 
                0.0372192882181413], 
               ArrowBox[BezierCurveBox[{
                10, {0.5267667572971251, 2.1395343604419548`}, 11}], 
                0.0372192882181413], 
               ArrowBox[BezierCurveBox[{
                10, {0.5005800990229483, 2.3094205012440736`}, 12}], 
                0.0372192882181413], 
               ArrowBox[BezierCurveBox[{
                10, {-0.06393571783075361, 2.5524447537348176`}, 13}], 
                0.0372192882181413], 
               ArrowBox[BezierCurveBox[{
                11, {1.4637698242717059`, 2.1017099730762694`}, 2}], 
                0.0372192882181413], 
               ArrowBox[BezierCurveBox[{
                11, {1.436222549040304, 2.1891057678993096`}, 7}], 
                0.0372192882181413], 
               ArrowBox[BezierCurveBox[{
                11, {0.4070140208188621, 1.8324311427234783`}, 10}], 
                0.0372192882181413], 
               ArrowBox[BezierCurveBox[{
                11, {0.4609619200369746, 1.98440514210173}, 22}], 
                0.0372192882181413], 
               ArrowBox[BezierCurveBox[{
                12, {1.5435329845323729`, 2.2539757938455054`}, 2}], 
                0.0372192882181413], 
               ArrowBox[BezierCurveBox[{
                12, {1.5159857093009803`, 2.3413715886639097`}, 7}], 
                0.0372192882181413], 
               ArrowBox[BezierCurveBox[{
                12, {0.4867771810795167, 1.9846969634906249`}, 10}], 
                0.0372192882181413], 
               ArrowBox[BezierCurveBox[{
                12, {0.5407250802976511, 2.1366709628651113`}, 22}], 
                0.0372192882181413], 
               ArrowBox[BezierCurveBox[{
                13, {0.6612934699606483, 3.0988515569579884`}, 8}], 
                0.0372192882181413], 
               ArrowBox[BezierCurveBox[{
                13, {0.17671115175935473`, 2.5153550004957537`}, 10}], 
                0.0372192882181413], 
               ArrowBox[BezierCurveBox[{
                13, {0.646986538018201, 2.922163964697282}, 21}], 
                0.0372192882181413], 
               ArrowBox[BezierCurveBox[{
                13, {0.2306590509774735, 2.6673289998728196`}, 22}], 
                0.0372192882181413], 
               ArrowBox[BezierCurveBox[{
                14, {3.689514671259119, 2.710534755109169}, 4}], 
                0.0372192882181413], 
               ArrowBox[BezierCurveBox[{
                14, {3.5617980641867293`, 2.2534976826360924`}, 6}], 
                0.0372192882181413], 
               ArrowBox[BezierCurveBox[{
                14, {3.7100903213308913`, 2.8681962951109905`}, 19}], 
                0.0372192882181413], 
               ArrowBox[BezierCurveBox[{
                14, {3.6560334304636117`, 2.1111632920292926`}, 20}], 
                0.0372192882181413], 
               ArrowBox[BezierCurveBox[{
                15, {2.608681196081168, 2.256702708116224}, 2}], 
                0.0372192882181413], 
               ArrowBox[BezierCurveBox[{
                15, {3.2125793382095673`, 3.0413383451977873`}, 4}], 
                0.0372192882181413], 
               ArrowBox[BezierCurveBox[{
                15, {2.581133920849756, 2.3440985029398997`}, 7}], 
                0.0372192882181413], 
               ArrowBox[BezierCurveBox[{
                15, {3.2331549882813295`, 3.1989998852326638`}, 19}], 
                0.0372192882181413], 
               ArrowBox[BezierCurveBox[{
                16, {1.9053854002282113`, 1.460373148588162}, 2}], 
                0.0372192882181413], 
               ArrowBox[BezierCurveBox[{
                16, {1.8778381249968115`, 1.5477689434092523`}, 7}], 
                0.0372192882181413], 
               ArrowBox[BezierCurveBox[{
                16, {2.5395099150672844`, 0.5985446390935225}, 17}], 
                0.0372192882181413], 
               ArrowBox[BezierCurveBox[{
                16, {2.3278473151794277`, 0.47630888898737883`}, 18}], 
                0.0372192882181413], 
               ArrowBox[BezierCurveBox[{
                17, {2.271933284780601, 0.4050010494176297}, 16}], 
                0.0372192882181413], 
               ArrowBox[BezierCurveBox[{17, 1242, 1245, 1247, 1253, 1255, 
                1258, 17},
                SplineDegree->7], 0.0372192882181413], 
               ArrowBox[BezierCurveBox[{
                17, {2.4883041810386675`, -0.027260848073540848`}, 18}], 
                0.0372192882181413], 
               ArrowBox[BezierCurveBox[{
                18, {2.193359310063258, 0.5226026047334529}, 1}], 
                0.0372192882181413], 
               ArrowBox[BezierCurveBox[{
                18, {2.0290351971849563`, 0.43226189749057187`}, 16}], 
                0.0372192882181413], 
               ArrowBox[BezierCurveBox[{
                18, {2.4570686933308874`, 0.12223575010617535`}, 17}], 
                0.0372192882181413], 
               ArrowBox[BezierCurveBox[{18, 1329, 1332, 1334, 1340, 1342, 
                1345, 18},
                SplineDegree->7], 0.0372192882181413], 
               ArrowBox[BezierCurveBox[{
                19, {3.311476048945039, 3.0482434356418007`}, 3}], 
                0.0372192882181413], 
               ArrowBox[BezierCurveBox[{
                19, {3.992651228171274, 3.101256990526557}, 5}], 
                0.0372192882181413], 
               ArrowBox[BezierCurveBox[{
                19, {4.008544378931688, 2.9378589299983218`}, 14}], 
                0.0372192882181413], 
               ArrowBox[BezierCurveBox[{
                19, {3.4283599698999256`, 2.920995399609956}, 15}], 
                0.0372192882181413], 
               ArrowBox[BezierCurveBox[{
                20, {2.636085079804482, 1.8373060414599882`}, 2}], 
                0.0372192882181413], 
               ArrowBox[BezierCurveBox[{
                20, {3.4998011640272053`, 2.5240915641046753`}, 5}], 
                0.0372192882181413], 
               ArrowBox[BezierCurveBox[{
                20, {2.6085378045730723`, 1.9247018362770847`}, 7}], 
                0.0372192882181413], 
               ArrowBox[BezierCurveBox[{
                20, {3.515694314787633, 2.3606935035951375`}, 14}], 
                0.0372192882181413], 
               ArrowBox[BezierCurveBox[{
                21, {1.6766942322634224`, 2.4855800158400894`}, 2}], 
                0.0372192882181413], 
               ArrowBox[BezierCurveBox[{
                21, {1.6491469570320283`, 2.572975810660972}, 7}], 
                0.0372192882181413], 
               ArrowBox[BezierCurveBox[{
                21, {0.667045564097298, 2.728539970887449}, 9}], 
                0.0372192882181413], 
               ArrowBox[BezierCurveBox[{
                21, {0.5560027109798051, 2.600702569258657}, 13}], 
                0.0372192882181413], 
               ArrowBox[BezierCurveBox[{
                22, {0.18072971394297516`, 2.7705676956827485`}, 9}], 
                0.0372192882181413], 
               ArrowBox[BezierCurveBox[{
                22, {0.6603893359533733, 2.2298199007552992`}, 11}], 
                0.0372192882181413], 
               ArrowBox[BezierCurveBox[{
                22, {0.6342026776791623, 2.399706041559373}, 12}], 
                0.0372192882181413], 
               ArrowBox[BezierCurveBox[{
                22, {0.06968686082548493, 2.642730294048708}, 13}], 
                0.0372192882181413]}, 
              {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[0.7]}], 
               DiskBox[1, 0.0372192882181413], DiskBox[2, 0.0372192882181413],
                DiskBox[3, 0.0372192882181413], 
               DiskBox[4, 0.0372192882181413], DiskBox[5, 0.0372192882181413],
                DiskBox[6, 0.0372192882181413], 
               DiskBox[7, 0.0372192882181413], DiskBox[8, 0.0372192882181413],
                DiskBox[9, 0.0372192882181413], 
               DiskBox[10, 0.0372192882181413], 
               DiskBox[11, 0.0372192882181413], 
               DiskBox[12, 0.0372192882181413], 
               DiskBox[13, 0.0372192882181413], 
               DiskBox[14, 0.0372192882181413], 
               DiskBox[15, 0.0372192882181413], 
               DiskBox[16, 0.0372192882181413], 
               DiskBox[17, 0.0372192882181413], 
               DiskBox[18, 0.0372192882181413], 
               DiskBox[19, 0.0372192882181413], 
               DiskBox[20, 0.0372192882181413], 
               DiskBox[21, 0.0372192882181413], 
               DiskBox[22, 0.0372192882181413]}}]],
           MouseAppearanceTag["NetworkGraphics"]],
          AllowKernelInitialization->False]],
        DefaultBaseStyle->{
         "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> 
          Hue[0.8, 1., 0.6]},
        FormatType->TraditionalForm,
        FrameTicks->None,
        GridLinesStyle->Directive[
          GrayLevel[0.5, 0.4]]]], "ExerciseOutput",ExpressionUUID->
       "39b2ea4b-d39b-44ea-a2e3-855ee55af00d"],
      Apply[TextCell, 
       Cell[
        BoxData[
         GraphicsBox[
          NamespaceBox["NetworkGraphics", 
           DynamicModuleBox[{Typeset`graph = HoldComplete[
               
               Graph[{2, 6, 12, 20, 30, 42, 56, 72, 90, 10, 32, 82, 40, 80, 
                62, 52, 0, 50, 70, 92, 22, 
                60}, {{{1, 2}, {2, 3}, {3, 4}, {4, 5}, {5, 6}, {6, 7}, {7, 
                 8}, {8, 9}, {9, 10}, {10, 11}, {11, 7}, {7, 12}, {12, 10}, {
                 10, 13}, {13, 8}, {8, 2}, {2, 6}, {6, 14}, {14, 4}, {4, 
                 15}, {15, 2}, {2, 16}, {16, 17}, {17, 18}, {18, 1}, {1, 7}, {
                 7, 3}, {3, 19}, {19, 5}, {5, 20}, {20, 7}, {7, 21}, {21, 
                 9}, {9, 22}, {22, 11}, {11, 2}, {2, 12}, {12, 22}, {22, 
                 13}, {13, 21}, {21, 2}, {2, 20}, {20, 14}, {14, 19}, {19, 
                 15}, {15, 7}, {7, 16}, {16, 18}, {18, 18}, {18, 16}, {16, 
                 7}, {7, 15}, {15, 19}, {19, 14}, {14, 20}, {20, 2}, {2, 
                 21}, {21, 13}, {13, 22}, {22, 12}, {12, 2}, {2, 11}, {11, 
                 22}, {22, 9}, {9, 21}, {21, 7}, {7, 20}, {20, 5}, {5, 19}, {
                 19, 3}, {3, 7}, {7, 1}, {1, 18}, {18, 17}, {17, 16}, {16, 
                 2}, {2, 15}, {15, 4}, {4, 14}, {14, 6}, {6, 2}, {2, 8}, {8, 
                 13}, {13, 10}, {10, 12}, {12, 7}, {7, 11}, {11, 10}, {10, 
                 9}, {9, 8}, {8, 7}, {7, 6}, {6, 5}, {5, 4}, {4, 3}, {3, 2}, {
                 2, 1}, {1, 17}, {17, 17}}, Null}]]}, 
            TagBox[
             GraphicsGroupBox[{
               GraphicsComplexBox[CompressedData["
1:eJw8eHc4lf///7nPtuUdSRKVyEhDSOX1lJnIakiIbNmjSMlIJBVFZYQiEYms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                "], {{{{
                    Hue[0.6, 0.7, 0.5], 
                    Opacity[0.7], 
                    Arrowheads[0.023068688797040122`], 
                    ArrowBox[
                    
                    BezierCurveBox[{
                    1, {2.091254342236005, 1.4355418406226061`}, 2}], 
                    0.0372192882181413], 
                    ArrowBox[
                    
                    BezierCurveBox[{
                    1, {2.0637070670045974`, 1.5229376354467496`}, 7}], 
                    0.0372192882181413], 
                    ArrowBox[{1, 17}, 0.0372192882181413], 
                    ArrowBox[
                    
                    BezierCurveBox[{
                    1, {2.5137162571872125`, 0.4514775810224957}, 18}], 
                    0.0372192882181413], 
                    ArrowBox[
                    
                    BezierCurveBox[{
                    2, {2.4374695071320063`, 1.5653234438338393`}, 1}], 
                    0.0372192882181413], 
                    ArrowBox[
                    
                    BezierCurveBox[{
                    2, {2.249595280557066, 2.66055706643758}, 3}], 
                    0.0372192882181413], 
                    ArrowBox[
                    
                    BezierCurveBox[{
                    2, {2.5432359106165747`, 2.3543836633557937`}, 6}], 
                    0.0372192882181413], 
                    ArrowBox[
                    
                    BezierCurveBox[{
                    2, {1.4948808903089774`, 2.3410028248082346`}, 8}], 
                    0.0372192882181413], 
                    ArrowBox[
                    
                    BezierCurveBox[{
                    2, {1.5370653294048309`, 1.728997258823314}, 11}], 
                    0.0372192882181413], 
                    ArrowBox[
                    
                    BezierCurveBox[{
                    2, {1.5108786711306312`, 1.898883399629145}, 12}], 
                    0.0372192882181413], 
                    ArrowBox[
                    
                    BezierCurveBox[{
                    2, {2.366479201511951, 2.5333090304407717`}, 15}], 
                    0.0372192882181413], 
                    ArrowBox[
                    
                    BezierCurveBox[{
                    2, {2.273145394253702, 1.4749827365923578`}, 16}], 
                    0.0372192882181413], 
                    ArrowBox[
                    
                    BezierCurveBox[{
                    2, {2.637471276893463, 2.212049272734071}, 20}], 
                    0.0372192882181413], 
                    ArrowBox[
                    
                    BezierCurveBox[{
                    2, {1.4805739583665403`, 2.1643152325497197`}, 21}], 
                    0.0372192882181413], 
                    ArrowBox[
                    
                    BezierCurveBox[{
                    3, {2.5901438943554407`, 2.428488278186439}, 2}], 
                    0.0372192882181413], 
                    ArrowBox[
                    
                    BezierCurveBox[{
                    3, {3.1940420364838413`, 3.2131239152510616`}, 4}], 
                    0.0372192882181413], 
                    ArrowBox[
                    
                    BezierCurveBox[{
                    3, {2.562596619124038, 2.5158840730100973`}, 7}], 
                    0.0372192882181413], 
                    ArrowBox[
                    
                    BezierCurveBox[{
                    3, {3.214617686555606, 3.3707854552732726`}, 19}], 
                    0.0372192882181413], 
                    ArrowBox[
                    
                    BezierCurveBox[{
                    4, {3.2013351699184818`, 2.9335721430274395`}, 3}], 
                    0.0372192882181413], 
                    ArrowBox[
                    
                    BezierCurveBox[{
                    4, {3.882510349144721, 2.9865856979798724`}, 5}], 
                    0.0372192882181413], 
                    ArrowBox[
                    
                    BezierCurveBox[{
                    4, {3.898403499905146, 2.823187637404343}, 14}], 
                    0.0372192882181413], 
                    ArrowBox[
                    
                    BezierCurveBox[{
                    4, {3.31821909087337, 2.8063241070384057`}, 15}], 
                    0.0372192882181413], 
                    ArrowBox[
                    
                    BezierCurveBox[{
                    5, {3.7737108537552055`, 2.8514692124532623`}, 4}], 
                    0.0372192882181413], 
                    ArrowBox[
                    
                    BezierCurveBox[{
                    5, {3.6459942466828306`, 2.394432140011242}, 6}], 
                    0.0372192882181413], 
                    ArrowBox[
                    
                    BezierCurveBox[{
                    5, {3.7942865038269673`, 3.0091307524797717`}, 19}], 
                    0.0372192882181413], 
                    ArrowBox[
                    
                    BezierCurveBox[{
                    5, {3.740229612959716, 2.252097749385703}, 20}], 
                    0.0372192882181413], 
                    ArrowBox[
                    
                    BezierCurveBox[{
                    6, {2.6447297566380716`, 2.0077896259251897`}, 2}], 
                    0.0372192882181413], 
                    ArrowBox[
                    
                    BezierCurveBox[{
                    6, {3.5084458408608237`, 2.694575148562666}, 5}], 
                    0.0372192882181413], 
                    ArrowBox[
                    
                    BezierCurveBox[{
                    6, {2.617182481406695, 2.0951854207513834`}, 7}], 
                    0.0372192882181413], 
                    ArrowBox[
                    
                    BezierCurveBox[{
                    6, {3.5243389916212418`, 2.5311770880471633`}, 14}], 
                    0.0372192882181413], 
                    ArrowBox[
                    
                    BezierCurveBox[{
                    7, {2.4671745593888543`, 1.6520095857214967`}, 1}], 
                    0.0372192882181413], 
                    ArrowBox[
                    
                    BezierCurveBox[{
                    7, {2.2793003328139134`, 2.747243208329804}, 3}], 
                    0.0372192882181413], 
                    ArrowBox[
                    
                    BezierCurveBox[{
                    7, {2.572940962873418, 2.4410698052378774`}, 6}], 
                    0.0372192882181413], 
                    ArrowBox[
                    
                    BezierCurveBox[{
                    7, {1.5245859425658355`, 2.4276889666993022`}, 8}], 
                    0.0372192882181413], 
                    ArrowBox[
                    
                    BezierCurveBox[{
                    7, {1.5667703816616767`, 1.8156834007118932`}, 11}], 
                    0.0372192882181413], 
                    ArrowBox[
                    
                    BezierCurveBox[{
                    7, {1.5405837233874913`, 1.9855695415234278`}, 12}], 
                    0.0372192882181413], 
                    ArrowBox[
                    
                    BezierCurveBox[{
                    7, {2.3961842537688023`, 2.6199951723450785`}, 15}], 
                    0.0372192882181413], 
                    ArrowBox[
                    
                    BezierCurveBox[{
                    7, {2.3028504465105537`, 1.5616688784792365`}, 16}], 
                    0.0372192882181413], 
                    ArrowBox[
                    
                    BezierCurveBox[{
                    7, {2.6671763291503057`, 2.2987354146166705`}, 20}], 
                    0.0372192882181413], 
                    ArrowBox[
                    
                    BezierCurveBox[{
                    7, {1.510279010623382, 2.2510013744366377`}, 21}], 
                    0.0372192882181413], 
                    ArrowBox[
                    
                    BezierCurveBox[{
                    8, {1.793083251876251, 2.61928412824451}, 2}], 
                    0.0372192882181413], 
                    ArrowBox[
                    
                    BezierCurveBox[{
                    8, {1.7655359766448562`, 2.7066799230719965`}, 7}], 
                    0.0372192882181413], 
                    ArrowBox[
                    
                    BezierCurveBox[{
                    8, {0.7834345837101422, 2.862244083297792}, 9}], 
                    0.0372192882181413], 
                    ArrowBox[
                    
                    BezierCurveBox[{
                    8, {0.6723917305926278, 2.734406681663987}, 13}], 
                    0.0372192882181413], 
                    ArrowBox[
                    
                    BezierCurveBox[{
                    9, {0.8265388589964683, 3.135822868639334}, 8}], 
                    0.0372192882181413], 
                    ArrowBox[
                    
                    BezierCurveBox[{
                    9, {0.34195654079519655`, 2.5523263121740674`}, 10}], 
                    0.0372192882181413], 
                    ArrowBox[
                    
                    BezierCurveBox[{
                    9, {0.8122319270540389, 2.9591352763761853`}, 21}], 
                    0.0372192882181413], 
                    ArrowBox[
                    
                    BezierCurveBox[{
                    9, {0.39590444001331465`, 2.7043003115524558`}, 22}], 
                    0.0372192882181413], 
                    ArrowBox[
                    
                    BezierCurveBox[{
                    10, {0.047107135286736115`, 2.680282155368704}, 9}], 
                    0.0372192882181413], 
                    ArrowBox[
                    
                    BezierCurveBox[{
                    10, {0.5267667572971251, 2.1395343604419548`}, 11}], 
                    0.0372192882181413], 
                    ArrowBox[
                    
                    BezierCurveBox[{
                    10, {0.5005800990229483, 2.3094205012440736`}, 12}], 
                    0.0372192882181413], 
                    ArrowBox[
                    
                    BezierCurveBox[{
                    10, {-0.06393571783075361, 2.5524447537348176`}, 13}], 
                    0.0372192882181413], 
                    ArrowBox[
                    
                    BezierCurveBox[{
                    11, {1.4637698242717059`, 2.1017099730762694`}, 2}], 
                    0.0372192882181413], 
                    ArrowBox[
                    
                    BezierCurveBox[{
                    11, {1.436222549040304, 2.1891057678993096`}, 7}], 
                    0.0372192882181413], 
                    ArrowBox[
                    
                    BezierCurveBox[{
                    11, {0.4070140208188621, 1.8324311427234783`}, 10}], 
                    0.0372192882181413], 
                    ArrowBox[
                    
                    BezierCurveBox[{
                    11, {0.4609619200369746, 1.98440514210173}, 22}], 
                    0.0372192882181413], 
                    ArrowBox[
                    
                    BezierCurveBox[{
                    12, {1.5435329845323729`, 2.2539757938455054`}, 2}], 
                    0.0372192882181413], 
                    ArrowBox[
                    
                    BezierCurveBox[{
                    12, {1.5159857093009803`, 2.3413715886639097`}, 7}], 
                    0.0372192882181413], 
                    ArrowBox[
                    
                    BezierCurveBox[{
                    12, {0.4867771810795167, 1.9846969634906249`}, 10}], 
                    0.0372192882181413], 
                    ArrowBox[
                    
                    BezierCurveBox[{
                    12, {0.5407250802976511, 2.1366709628651113`}, 22}], 
                    0.0372192882181413], 
                    ArrowBox[
                    BezierCurveBox[{
                    13, {0.6612934699606483, 3.0988515569579884`}, 8}], 
                    0.0372192882181413], 
                    ArrowBox[
                    
                    BezierCurveBox[{
                    13, {0.17671115175935473`, 2.5153550004957537`}, 10}], 
                    0.0372192882181413], 
                    ArrowBox[
                    
                    BezierCurveBox[{
                    13, {0.646986538018201, 2.922163964697282}, 21}], 
                    0.0372192882181413], 
                    ArrowBox[
                    
                    BezierCurveBox[{
                    13, {0.2306590509774735, 2.6673289998728196`}, 22}], 
                    0.0372192882181413], 
                    ArrowBox[
                    
                    BezierCurveBox[{
                    14, {3.689514671259119, 2.710534755109169}, 4}], 
                    0.0372192882181413], 
                    ArrowBox[
                    
                    BezierCurveBox[{
                    14, {3.5617980641867293`, 2.2534976826360924`}, 6}], 
                    0.0372192882181413], 
                    ArrowBox[
                    
                    BezierCurveBox[{
                    14, {3.7100903213308913`, 2.8681962951109905`}, 19}], 
                    0.0372192882181413], 
                    ArrowBox[
                    
                    BezierCurveBox[{
                    14, {3.6560334304636117`, 2.1111632920292926`}, 20}], 
                    0.0372192882181413], 
                    ArrowBox[
                    
                    BezierCurveBox[{
                    15, {2.608681196081168, 2.256702708116224}, 2}], 
                    0.0372192882181413], 
                    ArrowBox[
                    
                    BezierCurveBox[{
                    15, {3.2125793382095673`, 3.0413383451977873`}, 4}], 
                    0.0372192882181413], 
                    ArrowBox[
                    
                    BezierCurveBox[{
                    15, {2.581133920849756, 2.3440985029398997`}, 7}], 
                    0.0372192882181413], 
                    ArrowBox[
                    
                    BezierCurveBox[{
                    15, {3.2331549882813295`, 3.1989998852326638`}, 19}], 
                    0.0372192882181413], 
                    ArrowBox[
                    
                    BezierCurveBox[{
                    16, {1.9053854002282113`, 1.460373148588162}, 2}], 
                    0.0372192882181413], 
                    ArrowBox[
                    
                    BezierCurveBox[{
                    16, {1.8778381249968115`, 1.5477689434092523`}, 7}], 
                    0.0372192882181413], 
                    ArrowBox[
                    
                    BezierCurveBox[{
                    16, {2.5395099150672844`, 0.5985446390935225}, 17}], 
                    0.0372192882181413], 
                    ArrowBox[
                    
                    BezierCurveBox[{
                    16, {2.3278473151794277`, 0.47630888898737883`}, 18}], 
                    0.0372192882181413], 
                    ArrowBox[
                    
                    BezierCurveBox[{
                    17, {2.271933284780601, 0.4050010494176297}, 16}], 
                    0.0372192882181413], 
                    ArrowBox[
                    
                    BezierCurveBox[{17, 1242, 1245, 1247, 1253, 1255, 1258, 
                    17}, SplineDegree -> 7], 0.0372192882181413], 
                    ArrowBox[
                    
                    BezierCurveBox[{
                    17, {2.4883041810386675`, -0.027260848073540848`}, 18}], 
                    0.0372192882181413], 
                    ArrowBox[
                    
                    BezierCurveBox[{
                    18, {2.193359310063258, 0.5226026047334529}, 1}], 
                    0.0372192882181413], 
                    ArrowBox[
                    
                    BezierCurveBox[{
                    18, {2.0290351971849563`, 0.43226189749057187`}, 16}], 
                    0.0372192882181413], 
                    ArrowBox[
                    
                    BezierCurveBox[{
                    18, {2.4570686933308874`, 0.12223575010617535`}, 17}], 
                    0.0372192882181413], 
                    ArrowBox[
                    
                    BezierCurveBox[{18, 1329, 1332, 1334, 1340, 1342, 1345, 
                    18}, SplineDegree -> 7], 0.0372192882181413], 
                    ArrowBox[
                    
                    BezierCurveBox[{
                    19, {3.311476048945039, 3.0482434356418007`}, 3}], 
                    0.0372192882181413], 
                    ArrowBox[
                    
                    BezierCurveBox[{
                    19, {3.992651228171274, 3.101256990526557}, 5}], 
                    0.0372192882181413], 
                    ArrowBox[
                    
                    BezierCurveBox[{
                    19, {4.008544378931688, 2.9378589299983218`}, 14}], 
                    0.0372192882181413], 
                    ArrowBox[
                    
                    BezierCurveBox[{
                    19, {3.4283599698999256`, 2.920995399609956}, 15}], 
                    0.0372192882181413], 
                    ArrowBox[
                    
                    BezierCurveBox[{
                    20, {2.636085079804482, 1.8373060414599882`}, 2}], 
                    0.0372192882181413], 
                    ArrowBox[
                    
                    BezierCurveBox[{
                    20, {3.4998011640272053`, 2.5240915641046753`}, 5}], 
                    0.0372192882181413], 
                    ArrowBox[
                    
                    BezierCurveBox[{
                    20, {2.6085378045730723`, 1.9247018362770847`}, 7}], 
                    0.0372192882181413], 
                    ArrowBox[
                    
                    BezierCurveBox[{
                    20, {3.515694314787633, 2.3606935035951375`}, 14}], 
                    0.0372192882181413], 
                    ArrowBox[
                    
                    BezierCurveBox[{
                    21, {1.6766942322634224`, 2.4855800158400894`}, 2}], 
                    0.0372192882181413], 
                    ArrowBox[
                    
                    BezierCurveBox[{
                    21, {1.6491469570320283`, 2.572975810660972}, 7}], 
                    0.0372192882181413], 
                    ArrowBox[
                    
                    BezierCurveBox[{
                    21, {0.667045564097298, 2.728539970887449}, 9}], 
                    0.0372192882181413], 
                    ArrowBox[
                    
                    BezierCurveBox[{
                    21, {0.5560027109798051, 2.600702569258657}, 13}], 
                    0.0372192882181413], 
                    ArrowBox[
                    
                    BezierCurveBox[{
                    22, {0.18072971394297516`, 2.7705676956827485`}, 9}], 
                    0.0372192882181413], 
                    ArrowBox[
                    
                    BezierCurveBox[{
                    22, {0.6603893359533733, 2.2298199007552992`}, 11}], 
                    0.0372192882181413], 
                    ArrowBox[
                    
                    BezierCurveBox[{
                    22, {0.6342026776791623, 2.399706041559373}, 12}], 
                    0.0372192882181413], 
                    ArrowBox[
                    
                    BezierCurveBox[{
                    22, {0.06968686082548493, 2.642730294048708}, 13}], 
                    0.0372192882181413]}}}, {{{
                    Hue[0.6, 0.2, 0.8], 
                    EdgeForm[{
                    GrayLevel[0], 
                    Opacity[0.7]}], 
                    DiskBox[1, 0.0372192882181413], 
                    DiskBox[2, 0.0372192882181413], 
                    DiskBox[3, 0.0372192882181413], 
                    DiskBox[4, 0.0372192882181413], 
                    DiskBox[5, 0.0372192882181413], 
                    DiskBox[6, 0.0372192882181413], 
                    DiskBox[7, 0.0372192882181413], 
                    DiskBox[8, 0.0372192882181413], 
                    DiskBox[9, 0.0372192882181413], 
                    DiskBox[10, 0.0372192882181413], 
                    DiskBox[11, 0.0372192882181413], 
                    DiskBox[12, 0.0372192882181413], 
                    DiskBox[13, 0.0372192882181413], 
                    DiskBox[14, 0.0372192882181413], 
                    DiskBox[15, 0.0372192882181413], 
                    DiskBox[16, 0.0372192882181413], 
                    DiskBox[17, 0.0372192882181413], 
                    DiskBox[18, 0.0372192882181413], 
                    DiskBox[19, 0.0372192882181413], 
                    DiskBox[20, 0.0372192882181413], 
                    DiskBox[21, 0.0372192882181413], 
                    DiskBox[22, 0.0372192882181413]}}}}]}], 
             MouseAppearanceTag["NetworkGraphics"]], 
            AllowKernelInitialization -> False]], 
          DefaultBaseStyle -> {
           "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> 
            Hue[0.8, 1., 0.6]}, FormatType -> TraditionalForm, FrameTicks -> 
          None, GridLinesStyle -> Directive[
            GrayLevel[0.5, 0.4]]]], "ExerciseOutput", Selectable -> False, 
        Copyable -> False, Editable -> False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"c1ab24cc-bc6c-479f-983c-8459a2cdbbfd"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Generate a graph showing which word can follow which in the first 200 words \
of the Wikipedia article on computers.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "33.7", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"4a24a6b2-b086-47ca-9ad2-9872ae315ac9"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Sample", " ", "expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       GraphicsBox[
        NamespaceBox["NetworkGraphics",
         DynamicModuleBox[{Typeset`graph = HoldComplete[
           
           Graph[{"A", "computer", "is", "a", "general-purpose", "device", 
             "that", "can", "be", "programmed", "to", "carry", "out", "set", 
             "of", "arithmetic", "or", "logical", "operations", 
             "automatically", "Since", "sequence", "readily", "changed", 
             "the", "solve", "more", "than", "one", "kind", "problem", 
             "Conventionally", "consists", "at", "least", "processing", 
             "element", "typically", "central", "unit", "CPU", "and", "some", 
             "form", "memory", "The", "carries", "logic", "sequencing", 
             "control", "change", "order", "in", "response", "stored", 
             "information", "Peripheral", "devices", "allow", "retrieved", 
             "from", "an", "external", "source", "result", "saved", 
             "Mechanical", "analog", "computers", "started", "appearing", 
             "first", "century", "were", "later", "used", "medieval", "era", 
             "for", "astronomical", "calculations", "In", "World", "War", 
             "II", "mechanical", "specialized", "military", "applications", 
             "such", "as", "calculating", "torpedo", "aiming", "During", 
             "this", "time", "electronic", "digital", "developed", 
             "Originally", "they", "size", "large", "room", "consuming", 
             "much", "power", "several", "hundred", "modern", "personal", 
             "PCs", "Modern", "based", "on", "integrated", "circuits", "are", 
             "millions", "billions", "times", "capable", "early", "machines", 
             "occupy", "fraction", "space", "Computers"}, {CompressedData["
1:eJwVjXlXAVEAxTWeGk16w6i8UGEsPaVVJC2qsYyxS2lKhRIR2rRSn66vVe+P
e+655/7OvZZyO1umFArF77+ID1GUUgmASjU8PDJC02r16CjDjI1pNACMj0PI
slqtTsdxev3EBACTkxByHKGmpgwGhCiKpqenjUaTyWyemYFwdnZuDgCKslgg
tFptNrOZ5+12hwMAp5PnXa75eYzd7oUFCBcXPR7SLS1pNCyL8fIyx2EMwMoK
xqurLhdNr60htL5O/rzejQ2G8fn8/s3NQGBry+9nGLU6GNze3tnZ3d3bwxih
UIiQ+/sYB4MHB4eHghAORyJeL0LRaCyGsSjG45JEciKRTKZS6XQmk83mcvn8
0VGhQHhRlKRU6vj45KRYPD2V5bOz8/NS6eLi8vLqiqyUy5UKoarV6+ubG1FE
qFaDEIDb23q90ZDlu7tmU5Zbrfv7drvTEYRu9+FBEB4fn56en19eer3XV4Z5
e4Pw/d1o/PgwmRD6/Pz6wrjfB2AwgBCh7++fP2p9VTA=
             "], Null}, {
            VertexLabels -> {All}}]]}, 
          TagBox[GraphicsGroupBox[{
             {Hue[0.6, 0.7, 0.5], Opacity[0.7], Arrowheads[
              0.016091709858418807`], 
              ArrowBox[{{6.341217765333148, 6.886662961688092}, {
               6.767459466344739, 6.0892340568547505`}}, 0.06709388154952858],
               ArrowBox[{{6.767459466344739, 6.0892340568547505`}, {
               7.160794872630211, 6.353686992564913}}, 0.06709388154952858], 
              ArrowBox[{{6.767459466344739, 6.0892340568547505`}, {
               7.420136334138459, 5.305742090973326}}, 0.06709388154952858], 
              ArrowBox[{{6.767459466344739, 6.0892340568547505`}, {
               6.89066939047105, 6.602735114316545}}, 0.06709388154952858], 
              ArrowBox[{{7.160794872630211, 6.353686992564913}, {
               7.51352547870051, 5.854579982965166}}, 0.06709388154952858], 
              ArrowBox[{{7.51352547870051, 5.854579982965166}, {
               6.767459466344739, 6.0892340568547505`}}, 0.06709388154952858],
               ArrowBox[{{7.51352547870051, 5.854579982965166}, {
               8.646330223110617, 5.776805036111114}}, 0.06709388154952858], 
              ArrowBox[{{7.51352547870051, 5.854579982965166}, {
               7.883735126876614, 6.08699485557217}}, 0.06709388154952858], 
              ArrowBox[{{7.51352547870051, 5.854579982965166}, {
               7.80102014074524, 6.286931140395776}}, 0.06709388154952858], 
              ArrowBox[{{7.51352547870051, 5.854579982965166}, {
               8.38029970141519, 6.325975147000563}}, 0.06709388154952858], 
              ArrowBox[{{7.51352547870051, 5.854579982965166}, {
               7.0957432385751735`, 5.196027276963674}}, 0.06709388154952858],
               ArrowBox[{{7.51352547870051, 5.854579982965166}, {
               5.740053171637852, 6.601468329788948}}, 0.06709388154952858], 
              ArrowBox[{{7.51352547870051, 5.854579982965166}, {
               7.626334971332758, 6.419618767595251}}, 0.06709388154952858], 
              ArrowBox[{{8.646330223110617, 5.776805036111114}, {
               9.259068711197596, 5.485305335558021}}, 0.06709388154952858], 
              ArrowBox[{{9.259068711197596, 5.485305335558021}, {
               8.580522147725036, 5.347339183971889}}, 0.06709388154952858], 
              ArrowBox[{{8.580522147725036, 5.347339183971889}, {
               7.420136334138459, 5.305742090973326}}, 0.06709388154952858], 
              ArrowBox[BezierCurveBox[{{7.420136334138459, 
               5.305742090973326}, {7.617304140722688, 4.518797154129285}, {
               7.308882271072699, 3.7684416198461594`}}], 
               0.06709388154952858], 
              ArrowBox[BezierCurveBox[{{7.420136334138459, 
               5.305742090973326}, {7.111714464488472, 4.555386556635822}, {
               7.308882271072699, 3.7684416198461594`}}], 
               0.06709388154952858], 
              ArrowBox[{{7.420136334138459, 5.305742090973326}, {
               7.318061729407752, 6.503945853693873}}, 0.06709388154952858], 
              ArrowBox[{{7.420136334138459, 5.305742090973326}, {
               6.530173853935035, 5.484904487856812}}, 0.06709388154952858], 
              ArrowBox[{{7.308882271072699, 3.7684416198461594`}, {
               7.830781777216217, 3.1011066717555527`}}, 0.06709388154952858],
               ArrowBox[{{7.308882271072699, 3.7684416198461594`}, {
               6.56814703340736, 3.9600994656483186`}}, 0.06709388154952858], 
              ArrowBox[{{7.308882271072699, 3.7684416198461594`}, {
               6.216785652668685, 3.2449336952385734`}}, 0.06709388154952858],
               ArrowBox[{{7.830781777216217, 3.1011066717555527`}, {
               8.163839360665946, 3.076724425443019}}, 0.06709388154952858], 
              ArrowBox[{{8.163839360665946, 3.076724425443019}, {
               7.308882271072699, 3.7684416198461594`}}, 0.06709388154952858],
               ArrowBox[{{8.163839360665946, 3.076724425443019}, {
               8.68657450574927, 3.949273561931784}}, 0.06709388154952858], 
              ArrowBox[{{8.163839360665946, 3.076724425443019}, {
               8.860654470126681, 2.4530282980082876`}}, 0.06709388154952858],
               ArrowBox[{{8.163839360665946, 3.076724425443019}, {
               7.853162015719795, 4.505850126183707}}, 0.06709388154952858], 
              ArrowBox[{{8.68657450574927, 3.949273561931784}, {
               8.512326272919319, 5.082896376383502}}, 0.06709388154952858], 
              ArrowBox[{{8.512326272919319, 5.082896376383502}, {
               7.51352547870051, 5.854579982965166}}, 0.06709388154952858], 
              ArrowBox[{{8.512326272919319, 5.082896376383502}, {
               7.67042109132925, 5.043338154962031}}, 0.06709388154952858], 
              ArrowBox[{{7.883735126876614, 6.08699485557217}, {
               7.2424682828573665`, 6.032569519766121}}, 0.06709388154952858],
               ArrowBox[{{7.2424682828573665`, 6.032569519766121}, {
               7.51352547870051, 5.854579982965166}}, 0.06709388154952858], 
              ArrowBox[{{7.2424682828573665`, 6.032569519766121}, {
               7.67042109132925, 5.043338154962031}}, 0.06709388154952858], 
              ArrowBox[BezierCurveBox[{{7.2424682828573665`, 
               6.032569519766121}, {7.33814490667133, 5.361141595238271}, {
               7.016610550498093, 4.763994099336369}}], 0.06709388154952858], 
              ArrowBox[{{7.2424682828573665`, 6.032569519766121}, {
               7.016610550498093, 4.763994099336369}}, 0.06709388154952858], 
              ArrowBox[BezierCurveBox[{{7.2424682828573665`, 
               6.032569519766121}, {6.920933926684132, 5.435422023859533}, {
               7.016610550498093, 4.763994099336369}}], 0.06709388154952858], 
              ArrowBox[{{7.2424682828573665`, 6.032569519766121}, {
               5.792596146963917, 5.595709513281148}}, 0.06709388154952858], 
              ArrowBox[{{7.2424682828573665`, 6.032569519766121}, {
               7.869719923329276, 6.691211524677881}}, 0.06709388154952858], 
              ArrowBox[{{7.2424682828573665`, 6.032569519766121}, {
               7.76659702933596, 7.157204821153302}}, 0.06709388154952858], 
              ArrowBox[{{7.2424682828573665`, 6.032569519766121}, {
               8.191139548780793, 6.876216100593336}}, 0.06709388154952858], 
              ArrowBox[{{7.2424682828573665`, 6.032569519766121}, {
               7.214220204055934, 7.009597093418636}}, 0.06709388154952858], 
              ArrowBox[{{7.67042109132925, 5.043338154962031}, {
               8.293102583802245, 4.452774155752466}}, 0.06709388154952858], 
              ArrowBox[{{7.67042109132925, 5.043338154962031}, {
               6.52871531338926, 4.680792661869821}}, 0.06709388154952858], 
              ArrowBox[{{8.293102583802245, 4.452774155752466}, {
               7.807793839076568, 4.247404407400158}}, 0.06709388154952858], 
              ArrowBox[{{7.807793839076568, 4.247404407400158}, {
               7.016610550498093, 4.763994099336369}}, 0.06709388154952858], 
              ArrowBox[{{7.016610550498093, 4.763994099336369}, {
               7.420136334138459, 5.305742090973326}}, 0.06709388154952858], 
              ArrowBox[{{7.016610550498093, 4.763994099336369}, {
               7.913620916599047, 4.822218280398296}}, 0.06709388154952858], 
              ArrowBox[{{7.016610550498093, 4.763994099336369}, {
               6.52871531338926, 4.680792661869821}}, 0.06709388154952858], 
              ArrowBox[{{7.016610550498093, 4.763994099336369}, {
               5.733831403287671, 4.270326719634406}}, 0.06709388154952858], 
              ArrowBox[{{7.016610550498093, 4.763994099336369}, {
               6.963981978428761, 4.276001409935179}}, 0.06709388154952858], 
              ArrowBox[{{7.913620916599047, 4.822218280398296}, {
               8.169086999859772, 5.360057131761351}}, 0.06709388154952858], 
              ArrowBox[{{8.169086999859772, 5.360057131761351}, {
               7.51352547870051, 5.854579982965166}}, 0.06709388154952858], 
              ArrowBox[{{7.80102014074524, 6.286931140395776}, {
               7.2424682828573665`, 6.032569519766121}}, 0.06709388154952858],
               ArrowBox[{{6.56814703340736, 3.9600994656483186`}, {
               6.043366407184176, 4.696178292811545}}, 0.06709388154952858], 
              ArrowBox[{{6.043366407184176, 4.696178292811545}, {
               5.792596146963917, 5.595709513281148}}, 0.06709388154952858], 
              ArrowBox[{{5.792596146963917, 5.595709513281148}, {
               6.767459466344739, 6.0892340568547505`}}, 0.06709388154952858],
               ArrowBox[{{5.792596146963917, 5.595709513281148}, {
               6.375249115392858, 5.922043327956353}}, 0.06709388154952858], 
              ArrowBox[{{5.792596146963917, 5.595709513281148}, {
               6.409657409413706, 6.079409219726441}}, 0.06709388154952858], 
              ArrowBox[BezierCurveBox[{{5.792596146963917, 
               5.595709513281148}, {5.596427652880553, 5.042083885053285}, {
               5.109942592811901, 4.712970377883095}}], 0.06709388154952858], 
              ArrowBox[BezierCurveBox[{{5.792596146963917, 
               5.595709513281148}, {5.306111086895266, 5.266596006056129}, {
               5.109942592811901, 4.712970377883095}}], 0.06709388154952858], 
              ArrowBox[{{5.792596146963917, 5.595709513281148}, {
               4.440532520522792, 5.3801622961793}}, 0.06709388154952858], 
              ArrowBox[{{5.792596146963917, 5.595709513281148}, {
               6.301953245558314, 6.19077350973878}}, 0.06709388154952858], 
              ArrowBox[{{5.792596146963917, 5.595709513281148}, {
               5.309603059821833, 5.45976459149585}}, 0.06709388154952858], 
              ArrowBox[{{5.792596146963917, 5.595709513281148}, {
               5.141449097824981, 6.515203355827623}}, 0.06709388154952858], 
              ArrowBox[{{7.318061729407752, 6.503945853693873}, {
               7.025608502028897, 7.374116436287009}}, 0.06709388154952858], 
              ArrowBox[{{7.025608502028897, 7.374116436287009}, {
               6.651705125831321, 6.9668323078873495`}}, 0.06709388154952858],
               ArrowBox[{{7.025608502028897, 7.374116436287009}, {
               6.745727323839757, 7.804562931587747}}, 0.06709388154952858], 
              ArrowBox[{{6.651705125831321, 6.9668323078873495`}, {
               5.792596146963917, 5.595709513281148}}, 0.06709388154952858], 
              ArrowBox[{{6.651705125831321, 6.9668323078873495`}, {
               7.754193904358154, 7.367406508639469}}, 0.06709388154952858], 
              ArrowBox[{{7.754193904358154, 7.367406508639469}, {
               7.558680136610801, 6.975019954842593}}, 0.06709388154952858], 
              ArrowBox[{{7.754193904358154, 7.367406508639469}, {
               8.556967608199079, 6.686731262064674}}, 0.06709388154952858], 
              ArrowBox[{{7.558680136610801, 6.975019954842593}, {
               7.2424682828573665`, 6.032569519766121}}, 0.06709388154952858],
               ArrowBox[{{7.869719923329276, 6.691211524677881}, {
               8.146404866369867, 6.479017202758196}}, 0.06709388154952858], 
              ArrowBox[{{8.146404866369867, 6.479017202758196}, {
               7.51352547870051, 5.854579982965166}}, 0.06709388154952858], 
              ArrowBox[{{6.89066939047105, 6.602735114316545}, {
               7.2424682828573665`, 6.032569519766121}}, 0.06709388154952858],
               ArrowBox[{{7.76659702933596, 7.157204821153302}, {
               8.048602216684408, 7.89118519085174}}, 0.06709388154952858], 
              ArrowBox[{{8.048602216684408, 7.89118519085174}, {
               7.754193904358154, 7.367406508639469}}, 0.06709388154952858], 
              ArrowBox[BezierCurveBox[{{8.556967608199079, 
               6.686731262064674}, {8.972001614930823, 6.648645640497233}, {
               9.28341008461209, 6.371646531468439}}], 0.06709388154952858], 
              ArrowBox[BezierCurveBox[{{8.556967608199079, 
               6.686731262064674}, {8.868376077880347, 6.409732153308934}, {
               9.28341008461209, 6.371646531468439}}], 0.06709388154952858], 
              ArrowBox[{{8.556967608199079, 6.686731262064674}, {
               7.950037121015367, 5.6300531079084}}, 0.06709388154952858], 
              ArrowBox[{{9.28341008461209, 6.371646531468439}, {
               8.647073688100742, 6.191027161907364}}, 0.06709388154952858], 
              ArrowBox[{{9.28341008461209, 6.371646531468439}, {
               9.387133428998192, 5.677794994496508}}, 0.06709388154952858], 
              ArrowBox[{{8.647073688100742, 6.191027161907364}, {
               7.51352547870051, 5.854579982965166}}, 0.06709388154952858], 
              ArrowBox[{{8.38029970141519, 6.325975147000563}, {
               8.556967608199079, 6.686731262064674}}, 0.06709388154952858], 
              ArrowBox[{{7.950037121015367, 5.6300531079084}, {
               7.420136334138459, 5.305742090973326}}, 0.06709388154952858], 
              ArrowBox[{{7.950037121015367, 5.6300531079084}, {
               7.424466836623465, 4.908548004537416}}, 0.06709388154952858], 
              ArrowBox[{{7.424466836623465, 4.908548004537416}, {
               6.52871531338926, 4.680792661869821}}, 0.06709388154952858], 
              ArrowBox[{{6.52871531338926, 4.680792661869821}, {
               7.51352547870051, 5.854579982965166}}, 0.06709388154952858], 
              ArrowBox[{{6.52871531338926, 4.680792661869821}, {
               5.792596146963917, 5.595709513281148}}, 0.06709388154952858], 
              ArrowBox[{{6.52871531338926, 4.680792661869821}, {
               6.416921449899787, 5.19767518719537}}, 0.06709388154952858], 
              ArrowBox[{{6.52871531338926, 4.680792661869821}, {
               6.730464549484481, 4.303569274382708}}, 0.06709388154952858], 
              ArrowBox[{{6.52871531338926, 4.680792661869821}, {
               7.33420760573115, 5.053035435623441}}, 0.06709388154952858], 
              ArrowBox[{{6.52871531338926, 4.680792661869821}, {
               6.216785652668685, 3.2449336952385734`}}, 0.06709388154952858],
               ArrowBox[{{6.52871531338926, 4.680792661869821}, {
               4.8417943224155655`, 4.154880847081267}}, 0.06709388154952858],
               ArrowBox[{{6.52871531338926, 4.680792661869821}, {
               6.966028973571536, 5.3199607575271575`}}, 0.06709388154952858],
               ArrowBox[{{6.416921449899787, 5.19767518719537}, {
               6.7591961101130655`, 5.7313139868657075`}}, 
               0.06709388154952858], 
              ArrowBox[{{6.7591961101130655`, 5.7313139868657075`}, {
               7.2424682828573665`, 6.032569519766121}}, 0.06709388154952858],
               ArrowBox[{{8.191139548780793, 6.876216100593336}, {
               8.867588133317325, 7.262783535810694}}, 0.06709388154952858], 
              ArrowBox[{{8.867588133317325, 7.262783535810694}, {
               8.556967608199079, 6.686731262064674}}, 0.06709388154952858], 
              ArrowBox[{{9.387133428998192, 5.677794994496508}, {
               8.512326272919319, 5.082896376383502}}, 0.06709388154952858], 
              ArrowBox[{{6.730464549484481, 4.303569274382708}, {
               7.016610550498093, 4.763994099336369}}, 0.06709388154952858], 
              ArrowBox[{{7.0957432385751735`, 5.196027276963674}, {
               6.52871531338926, 4.680792661869821}}, 0.06709388154952858], 
              ArrowBox[{{7.33420760573115, 5.053035435623441}, {
               7.950037121015367, 5.6300531079084}}, 0.06709388154952858], 
              ArrowBox[{{6.530173853935035, 5.484904487856812}, {
               5.792596146963917, 5.595709513281148}}, 0.06709388154952858], 
              ArrowBox[{{6.375249115392858, 5.922043327956353}, {
               7.2424682828573665`, 6.032569519766121}}, 0.06709388154952858],
               ArrowBox[BezierCurveBox[{{5.733831403287671, 
               4.270326719634406}, {5.545266838234879, 4.942681434823182}, {
               5.792596146963917, 5.595709513281148}}], 0.06709388154952858], 
              ArrowBox[BezierCurveBox[{{5.733831403287671, 
               4.270326719634406}, {5.9811607120167105`, 4.923354798126046}, {
               5.792596146963917, 5.595709513281148}}], 0.06709388154952858], 
              ArrowBox[{{5.733831403287671, 4.270326719634406}, {
               6.950243254812751, 3.4859847857413895`}}, 0.06709388154952858],
               ArrowBox[{{6.950243254812751, 3.4859847857413895`}, {
               8.163839360665946, 3.076724425443019}}, 0.06709388154952858], 
              ArrowBox[{{8.860654470126681, 2.4530282980082876`}, {
               9.27169173155814, 2.127175568769304}}, 0.06709388154952858], 
              ArrowBox[{{9.27169173155814, 2.127175568769304}, {
               8.163839360665946, 3.076724425443019}}, 0.06709388154952858], 
              ArrowBox[{{9.27169173155814, 2.127175568769304}, {
               10.057066085236883`, 1.6018181609028996`}}, 
               0.06709388154952858], 
              ArrowBox[{{10.057066085236883`, 1.6018181609028996`}, {
               10.42367189997939, 1.160246671100385}}, 0.06709388154952858], 
              ArrowBox[{{10.42367189997939, 1.160246671100385}, {
               9.92643250367165, 1.4456390189991466`}}, 0.06709388154952858], 
              ArrowBox[{{9.92643250367165, 1.4456390189991466`}, {
               9.27169173155814, 2.127175568769304}}, 0.06709388154952858], 
              ArrowBox[{{6.216785652668685, 3.2449336952385734`}, {
               6.364678767806792, 2.307491305809486}}, 0.06709388154952858], 
              ArrowBox[{{6.216785652668685, 3.2449336952385734`}, {
               5.003646987915086, 2.3846962838822976`}}, 0.06709388154952858],
               ArrowBox[{{6.364678767806792, 2.307491305809486}, {
               6.665171563193751, 1.8290257359789885`}}, 0.06709388154952858],
               ArrowBox[{{6.665171563193751, 1.8290257359789885`}, {
               6.749012425099872, 2.447093654591712}}, 0.06709388154952858], 
              ArrowBox[{{6.749012425099872, 2.447093654591712}, {
               6.625893054086672, 3.4297952488389347`}}, 0.06709388154952858],
               ArrowBox[{{6.625893054086672, 3.4297952488389347`}, {
               6.52871531338926, 4.680792661869821}}, 0.06709388154952858], 
              ArrowBox[{{6.409657409413706, 6.079409219726441}, {
               7.2424682828573665`, 6.032569519766121}}, 0.06709388154952858],
               ArrowBox[{{6.963981978428761, 4.276001409935179}, {
               6.52871531338926, 4.680792661869821}}, 0.06709388154952858], 
              ArrowBox[{{5.003646987915086, 2.3846962838822976`}, {
               3.758580085028022, 1.855816382248089}}, 0.06709388154952858], 
              ArrowBox[BezierCurveBox[{{3.758580085028022, 
               1.855816382248089}, {3.623025447219195, 2.2959297101004643`}, {
               3.775166978546306, 2.7305879156551147`}}], 
               0.06709388154952858], 
              ArrowBox[BezierCurveBox[{{3.758580085028022, 
               1.855816382248089}, {3.9107216163551324`, 2.290474587793731}, {
               3.775166978546306, 2.7305879156551147`}}], 
               0.06709388154952858], 
              ArrowBox[{{3.775166978546306, 2.7305879156551147`}, {
               4.395460101070168, 2.795045715905718}}, 0.06709388154952858], 
              ArrowBox[BezierCurveBox[{{3.775166978546306, 
               2.7305879156551147`}, {4.074268856629583, 
               3.6181313787554554`}, {4.8417943224155655`, 
               4.154880847081267}}], 0.06709388154952858], 
              ArrowBox[BezierCurveBox[{{3.775166978546306, 
               2.7305879156551147`}, {4.542692444332272, 
               3.2673373839783992`}, {4.8417943224155655`, 
               4.154880847081267}}], 0.06709388154952858], 
              ArrowBox[{{3.775166978546306, 2.7305879156551147`}, {
               3.3161490341250306`, 2.1013566567852195`}}, 
               0.06709388154952858], 
              ArrowBox[{{3.775166978546306, 2.7305879156551147`}, {
               4.225675714722049, 1.4691650832188197`}}, 0.06709388154952858],
               ArrowBox[{{4.395460101070168, 2.795045715905718}, {
               5.061390269263109, 3.3922770901229757`}}, 0.06709388154952858],
               ArrowBox[{{5.061390269263109, 3.3922770901229757`}, {
               5.733831403287671, 4.270326719634406}}, 0.06709388154952858], 
              ArrowBox[{{5.109942592811901, 4.712970377883095}, {
               5.690493915169704, 4.584438939757817}}, 0.06709388154952858], 
              ArrowBox[{{5.109942592811901, 4.712970377883095}, {
               4.453626787323267, 3.8855798171172}}, 0.06709388154952858], 
              ArrowBox[{{5.690493915169704, 4.584438939757817}, {
               6.52871531338926, 4.680792661869821}}, 0.06709388154952858], 
              ArrowBox[{{4.8417943224155655`, 4.154880847081267}, {
               5.792596146963917, 5.595709513281148}}, 0.06709388154952858], 
              ArrowBox[{{4.8417943224155655`, 4.154880847081267}, {
               4.192762557340956, 4.088626052281825}}, 0.06709388154952858], 
              ArrowBox[{{4.8417943224155655`, 4.154880847081267}, {
               4.125561903777494, 4.3035376935642775`}}, 0.06709388154952858],
               ArrowBox[{{4.8417943224155655`, 4.154880847081267}, {
               4.090259126621749, 3.639616955478291}}, 0.06709388154952858], 
              ArrowBox[{{4.192762557340956, 4.088626052281825}, {
               4.125561903777494, 4.3035376935642775`}}, 0.06709388154952858],
               ArrowBox[{{4.125561903777494, 4.3035376935642775`}, {
               5.733831403287671, 4.270326719634406}}, 0.06709388154952858], 
              ArrowBox[{{4.125561903777494, 4.3035376935642775`}, {
               2.50917794322678, 4.370075860317984}}, 0.06709388154952858], 
              ArrowBox[{{4.440532520522792, 5.3801622961793}, {
               3.3170435421504925`, 4.97663717870283}}, 0.06709388154952858], 
              ArrowBox[{{3.3170435421504925`, 4.97663717870283}, {
               2.50917794322678, 4.370075860317984}}, 0.06709388154952858], 
              ArrowBox[{{2.50917794322678, 4.370075860317984}, {
               1.434638629990979, 3.52059595227331}}, 0.06709388154952858], 
              ArrowBox[{{2.50917794322678, 4.370075860317984}, {
               1.3653224586846058`, 4.900678524486768}}, 0.06709388154952858],
               ArrowBox[{{1.434638629990979, 3.52059595227331}, {
               0.6254698250933011, 2.6711830232713965`}}, 
               0.06709388154952858], 
              ArrowBox[{{0.6254698250933011, 2.6711830232713965`}, {
               0.15237107653347248`, 1.826314263648162}}, 
               0.06709388154952858], 
              ArrowBox[{{0.15237107653347248`, 1.826314263648162}, {
               0.16091742840985912`, 1.0454511064935912`}}, 
               0.06709388154952858], 
              ArrowBox[{{0.16091742840985912`, 1.0454511064935912`}, {
               0.7586502175475411, 0.6337015907455887}}, 0.06709388154952858],
               ArrowBox[{{0.7586502175475411, 0.6337015907455887}, {
               1.6459348074402058`, 0.7089061451214675}}, 
               0.06709388154952858], 
              ArrowBox[{{1.6459348074402058`, 0.7089061451214675}, {
               2.658774408677256, 1.1336054147323709`}}, 0.06709388154952858],
               ArrowBox[{{2.658774408677256, 1.1336054147323709`}, {
               3.758580085028022, 1.855816382248089}}, 0.06709388154952858], 
              ArrowBox[{{1.3653224586846058`, 4.900678524486768}, {
               0.4709752938450915, 5.509024547467219}}, 0.06709388154952858], 
              ArrowBox[{{0.4709752938450915, 5.509024547467219}, {0., 
               6.250941554600795}}, 0.06709388154952858], 
              ArrowBox[{{0., 6.250941554600795}, {0.18399721553772608`, 
               6.997639624083163}}, 0.06709388154952858], 
              ArrowBox[{{0.18399721553772608`, 6.997639624083163}, {
               0.9377246156032744, 7.447261661452538}}, 0.06709388154952858], 
              ArrowBox[{{0.9377246156032744, 7.447261661452538}, {
               0.7914133258034122, 8.337323308210841}}, 0.06709388154952858], 
              ArrowBox[{{0.9377246156032744, 7.447261661452538}, {
               0.354347806107957, 7.918200860512604}}, 0.06709388154952858], 
              ArrowBox[{{0.9377246156032744, 7.447261661452538}, {
               0.7711108831771822, 6.416707493838862}}, 0.06709388154952858], 
              ArrowBox[{{0.7914133258034122, 8.337323308210841}, {
               1.1244370282325686`, 8.953714358372414}}, 0.06709388154952858],
               ArrowBox[{{1.1244370282325686`, 8.953714358372414}, {
               1.8823295141778336`, 8.959969673216353}}, 0.06709388154952858],
               ArrowBox[{{1.8823295141778336`, 8.959969673216353}, {
               2.7402912281441685`, 8.501569388383661}}, 0.06709388154952858],
               ArrowBox[{{2.7402912281441685`, 8.501569388383661}, {
               3.657426930489685, 7.735557513310497}}, 0.06709388154952858], 
              ArrowBox[{{3.657426930489685, 7.735557513310497}, {
               4.655593071009504, 6.734156008913222}}, 0.06709388154952858], 
              ArrowBox[{{4.655593071009504, 6.734156008913222}, {
               5.792596146963917, 5.595709513281148}}, 0.06709388154952858], 
              ArrowBox[{{4.453626787323267, 3.8855798171172}, {
               3.9400604913433535`, 3.1814016294962038`}}, 
               0.06709388154952858], 
              ArrowBox[{{3.9400604913433535`, 3.1814016294962038`}, {
               3.775166978546306, 2.7305879156551147`}}, 0.06709388154952858],
               ArrowBox[{{4.090259126621749, 3.639616955478291}, {
               3.526386567993374, 3.5049464058961384`}}, 0.06709388154952858],
               ArrowBox[{{3.526386567993374, 3.5049464058961384`}, {
               3.959632414685003, 3.830983348322878}}, 0.06709388154952858], 
              ArrowBox[{{3.959632414685003, 3.830983348322878}, {
               4.8417943224155655`, 4.154880847081267}}, 0.06709388154952858],
               ArrowBox[{{6.301953245558314, 6.19077350973878}, {
               7.2424682828573665`, 6.032569519766121}}, 0.06709388154952858],
               ArrowBox[{{5.740053171637852, 6.601468329788948}, {
               4.03915346784052, 7.09264256881027}}, 0.06709388154952858], 
              ArrowBox[{{4.03915346784052, 7.09264256881027}, {
               2.4369263914801294`, 7.360038423573828}}, 0.06709388154952858],
               ArrowBox[{{2.4369263914801294`, 7.360038423573828}, {
               0.9377246156032744, 7.447261661452538}}, 0.06709388154952858], 
              ArrowBox[{{0.354347806107957, 7.918200860512604}, {
               0.24071293518263204`, 7.734578829178509}}, 
               0.06709388154952858], 
              ArrowBox[{{0.24071293518263204`, 7.734578829178509}, {
               0.9377246156032744, 7.447261661452538}}, 0.06709388154952858], 
              ArrowBox[{{0.7711108831771822, 6.416707493838862}, {
               0.9928501447273907, 5.329833321505883}}, 0.06709388154952858], 
              ArrowBox[{{0.9928501447273907, 5.329833321505883}, {
               1.5935259191467486`, 4.294114157577752}}, 0.06709388154952858],
               ArrowBox[{{1.5935259191467486`, 4.294114157577752}, {
               2.535622482436771, 3.4015464614673867`}}, 0.06709388154952858],
               ArrowBox[{{2.535622482436771, 3.4015464614673867`}, {
               3.775166978546306, 2.7305879156551147`}}, 0.06709388154952858],
               ArrowBox[{{3.3161490341250306`, 2.1013566567852195`}, {
               3.1634830896677855`, 2.2562464449840625`}}, 
               0.06709388154952858], 
              ArrowBox[{{3.1634830896677855`, 2.2562464449840625`}, {
               3.775166978546306, 2.7305879156551147`}}, 0.06709388154952858],
               ArrowBox[{{4.225675714722049, 1.4691650832188197`}, {
               4.889021154120004, 0.5177535638605564}}, 0.06709388154952858], 
              ArrowBox[{{4.889021154120004, 0.5177535638605564}, {
               5.754671967053932, 0.}}, 0.06709388154952858], 
              ArrowBox[{{5.754671967053932, 0.}, {6.6916232164290435`, 
               0.06894214896797468}}, 0.06709388154952858], 
              ArrowBox[{{6.6916232164290435`, 0.06894214896797468}, {
               7.46557005847371, 0.7059102227198553}}, 0.06709388154952858], 
              ArrowBox[{{7.46557005847371, 0.7059102227198553}, {
               7.961848666882953, 1.7513799751447756`}}, 0.06709388154952858],
               ArrowBox[{{7.961848666882953, 1.7513799751447756`}, {
               8.163839360665946, 3.076724425443019}}, 0.06709388154952858], 
              ArrowBox[{{7.853162015719795, 4.505850126183707}, {
               7.2424682828573665`, 6.032569519766121}}, 0.06709388154952858],
               ArrowBox[{{7.214220204055934, 7.009597093418636}, {
               7.025608502028897, 7.374116436287009}}, 0.06709388154952858], 
              ArrowBox[{{6.745727323839757, 7.804562931587747}, {
               6.651705125831321, 6.9668323078873495`}}, 0.06709388154952858],
               ArrowBox[{{5.309603059821833, 5.45976459149585}, {
               5.749264030702026, 5.0321625418720615`}}, 0.06709388154952858],
               ArrowBox[{{5.749264030702026, 5.0321625418720615`}, {
               6.52871531338926, 4.680792661869821}}, 0.06709388154952858], 
              ArrowBox[{{6.966028973571536, 5.3199607575271575`}, {
               7.51352547870051, 5.854579982965166}}, 0.06709388154952858], 
              ArrowBox[{{7.626334971332758, 6.419618767595251}, {
               7.2424682828573665`, 6.032569519766121}}, 0.06709388154952858],
               ArrowBox[{{5.141449097824981, 6.515203355827623}, {
               4.763497170502677, 7.248463927995084}}, 
               0.06709388154952858]}, 
             {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[
              0.7]}], {
               DiskBox[{6.341217765333148, 6.886662961688092}, 
                0.06709388154952858], 
               InsetBox["\<\"A\"\>", 
                Offset[{2, 2}, {6.408311646882677, 6.9537568432376204}], 
                ImageScaled[{0, 0}],
                BaseStyle->"Graphics"]}, {
               DiskBox[{6.767459466344739, 6.0892340568547505}, 
                0.06709388154952858], 
               InsetBox["\<\"computer\"\>", 
                Offset[{2, 2}, {6.834553347894268, 6.156327938404279}], 
                ImageScaled[{0, 0}],
                BaseStyle->"Graphics"]}, {
               DiskBox[{7.160794872630211, 6.353686992564913}, 
                0.06709388154952858], 
               InsetBox["\<\"is\"\>", 
                Offset[{2, 2}, {7.227888754179739, 6.420780874114441}], 
                ImageScaled[{0, 0}],
                BaseStyle->"Graphics"]}, {
               DiskBox[{7.51352547870051, 5.854579982965166}, 
                0.06709388154952858], 
               InsetBox["\<\"a\"\>", 
                Offset[{2, 2}, {7.580619360250038, 5.921673864514695}], 
                ImageScaled[{0, 0}],
                BaseStyle->"Graphics"]}, {
               DiskBox[{8.646330223110617, 5.776805036111114}, 
                0.06709388154952858], 
               InsetBox["\<\"general-purpose\"\>", 
                Offset[{2, 2}, {8.713424104660145, 5.843898917660642}], 
                ImageScaled[{0, 0}],
                BaseStyle->"Graphics"]}, {
               DiskBox[{9.259068711197596, 5.485305335558021}, 
                0.06709388154952858], 
               InsetBox["\<\"device\"\>", 
                Offset[{2, 2}, {9.326162592747124, 5.552399217107549}], 
                ImageScaled[{0, 0}],
                BaseStyle->"Graphics"]}, {
               DiskBox[{8.580522147725036, 5.347339183971889}, 
                0.06709388154952858], 
               InsetBox["\<\"that\"\>", 
                Offset[{2, 2}, {8.647616029274564, 5.4144330655214175}], 
                ImageScaled[{0, 0}],
                BaseStyle->"Graphics"]}, {
               DiskBox[{7.420136334138459, 5.305742090973326}, 
                0.06709388154952858], 
               InsetBox["\<\"can\"\>", 
                Offset[{2, 2}, {7.487230215687988, 5.3728359725228545}], 
                ImageScaled[{0, 0}],
                BaseStyle->"Graphics"]}, {
               DiskBox[{7.308882271072699, 3.7684416198461594}, 
                0.06709388154952858], 
               InsetBox["\<\"be\"\>", 
                Offset[{2, 2}, {7.375976152622227, 3.835535501395688}], 
                ImageScaled[{0, 0}],
                BaseStyle->"Graphics"]}, {
               DiskBox[{7.830781777216217, 3.1011066717555527}, 
                0.06709388154952858], 
               InsetBox["\<\"programmed\"\>", 
                Offset[{2, 2}, {7.897875658765745, 3.1682005533050814}], 
                ImageScaled[{0, 0}],
                BaseStyle->"Graphics"]}, {
               DiskBox[{8.163839360665946, 3.076724425443019}, 
                0.06709388154952858], 
               InsetBox["\<\"to\"\>", 
                Offset[{2, 2}, {8.230933242215475, 3.143818306992548}], 
                ImageScaled[{0, 0}],
                BaseStyle->"Graphics"]}, {
               DiskBox[{8.68657450574927, 3.949273561931784}, 
                0.06709388154952858], 
               InsetBox["\<\"carry\"\>", 
                Offset[{2, 2}, {8.753668387298799, 4.016367443481313}], 
                ImageScaled[{0, 0}],
                BaseStyle->"Graphics"]}, {
               DiskBox[{8.512326272919319, 5.082896376383502}, 
                0.06709388154952858], 
               InsetBox["\<\"out\"\>", 
                Offset[{2, 2}, {8.579420154468847, 5.14999025793303}], 
                ImageScaled[{0, 0}],
                BaseStyle->"Graphics"]}, {
               DiskBox[{7.883735126876614, 6.08699485557217}, 
                0.06709388154952858], 
               InsetBox["\<\"set\"\>", 
                Offset[{2, 2}, {7.950829008426142, 6.154088737121699}], 
                ImageScaled[{0, 0}],
                BaseStyle->"Graphics"]}, {
               DiskBox[{7.2424682828573665, 6.032569519766121}, 
                0.06709388154952858], 
               InsetBox["\<\"of\"\>", 
                Offset[{2, 2}, {7.309562164406895, 6.09966340131565}], 
                ImageScaled[{0, 0}],
                BaseStyle->"Graphics"]}, {
               DiskBox[{7.67042109132925, 5.043338154962031}, 
                0.06709388154952858], 
               InsetBox["\<\"arithmetic\"\>", 
                Offset[{2, 2}, {7.737514972878778, 5.110432036511559}], 
                ImageScaled[{0, 0}],
                BaseStyle->"Graphics"]}, {
               DiskBox[{8.293102583802245, 4.452774155752466}, 
                0.06709388154952858], 
               InsetBox["\<\"or\"\>", 
                Offset[{2, 2}, {8.360196465351773, 4.519868037301994}], 
                ImageScaled[{0, 0}],
                BaseStyle->"Graphics"]}, {
               DiskBox[{7.807793839076568, 4.247404407400158}, 
                0.06709388154952858], 
               InsetBox["\<\"logical\"\>", 
                Offset[{2, 2}, {7.874887720626097, 4.314498288949686}], 
                ImageScaled[{0, 0}],
                BaseStyle->"Graphics"]}, {
               DiskBox[{7.016610550498093, 4.763994099336369}, 
                0.06709388154952858], 
               InsetBox["\<\"operations\"\>", 
                Offset[{2, 2}, {7.083704432047622, 4.831087980885897}], 
                ImageScaled[{0, 0}],
                BaseStyle->"Graphics"]}, {
               DiskBox[{7.913620916599047, 4.822218280398296}, 
                0.06709388154952858], 
               InsetBox["\<\"automatically\"\>", 
                Offset[{2, 2}, {7.9807147981485755, 4.889312161947824}], 
                ImageScaled[{0, 0}],
                BaseStyle->"Graphics"]}, {
               DiskBox[{8.169086999859772, 5.360057131761351}, 
                0.06709388154952858], 
               InsetBox["\<\"Since\"\>", 
                Offset[{2, 2}, {8.2361808814093, 5.427151013310879}], 
                ImageScaled[{0, 0}],
                BaseStyle->"Graphics"]}, {
               DiskBox[{7.80102014074524, 6.286931140395776}, 
                0.06709388154952858], 
               InsetBox["\<\"sequence\"\>", 
                Offset[{2, 2}, {7.868114022294768, 6.354025021945304}], 
                ImageScaled[{0, 0}],
                BaseStyle->"Graphics"]}, {
               DiskBox[{6.56814703340736, 3.9600994656483186}, 
                0.06709388154952858], 
               InsetBox["\<\"readily\"\>", 
                Offset[{2, 2}, {6.6352409149568885, 4.027193347197847}], 
                ImageScaled[{0, 0}],
                BaseStyle->"Graphics"]}, {
               DiskBox[{6.043366407184176, 4.696178292811545}, 
                0.06709388154952858], 
               InsetBox["\<\"changed\"\>", 
                Offset[{2, 2}, {6.110460288733704, 4.763272174361074}], 
                ImageScaled[{0, 0}],
                BaseStyle->"Graphics"]}, {
               DiskBox[{5.792596146963917, 5.595709513281148}, 
                0.06709388154952858], 
               InsetBox["\<\"the\"\>", 
                Offset[{2, 2}, {5.8596900285134454, 5.662803394830676}], 
                ImageScaled[{0, 0}],
                BaseStyle->"Graphics"]}, {
               DiskBox[{7.318061729407752, 6.503945853693873}, 
                0.06709388154952858], 
               InsetBox["\<\"solve\"\>", 
                Offset[{2, 2}, {7.3851556109572805, 6.571039735243401}], 
                ImageScaled[{0, 0}],
                BaseStyle->"Graphics"]}, {
               DiskBox[{7.025608502028897, 7.374116436287009}, 
                0.06709388154952858], 
               InsetBox["\<\"more\"\>", 
                Offset[{2, 2}, {7.092702383578425, 7.441210317836537}], 
                ImageScaled[{0, 0}],
                BaseStyle->"Graphics"]}, {
               DiskBox[{6.651705125831321, 6.9668323078873495}, 
                0.06709388154952858], 
               InsetBox["\<\"than\"\>", 
                Offset[{2, 2}, {6.7187990073808495, 7.033926189436878}], 
                ImageScaled[{0, 0}],
                BaseStyle->"Graphics"]}, {
               DiskBox[{7.754193904358154, 7.367406508639469}, 
                0.06709388154952858], 
               InsetBox["\<\"one\"\>", 
                Offset[{2, 2}, {7.821287785907682, 7.434500390188997}], 
                ImageScaled[{0, 0}],
                BaseStyle->"Graphics"]}, {
               DiskBox[{7.558680136610801, 6.975019954842593}, 
                0.06709388154952858], 
               InsetBox["\<\"kind\"\>", 
                Offset[{2, 2}, {7.625774018160329, 7.042113836392121}], 
                ImageScaled[{0, 0}],
                BaseStyle->"Graphics"]}, {
               DiskBox[{7.869719923329276, 6.691211524677881}, 
                0.06709388154952858], 
               InsetBox["\<\"problem\"\>", 
                Offset[{2, 2}, {7.936813804878804, 6.758305406227409}], 
                ImageScaled[{0, 0}],
                BaseStyle->"Graphics"]}, {
               DiskBox[{8.146404866369867, 6.479017202758196}, 
                0.06709388154952858], 
               InsetBox["\<\"Conventionally\"\>", 
                Offset[{2, 2}, {8.213498747919395, 6.546111084307724}], 
                ImageScaled[{0, 0}],
                BaseStyle->"Graphics"]}, {
               DiskBox[{6.89066939047105, 6.602735114316545}, 
                0.06709388154952858], 
               InsetBox["\<\"consists\"\>", 
                Offset[{2, 2}, {6.957763272020578, 6.669828995866073}], 
                ImageScaled[{0, 0}],
                BaseStyle->"Graphics"]}, {
               DiskBox[{7.76659702933596, 7.157204821153302}, 
                0.06709388154952858], 
               InsetBox["\<\"at\"\>", 
                Offset[{2, 2}, {7.833690910885489, 7.22429870270283}], 
                ImageScaled[{0, 0}],
                BaseStyle->"Graphics"]}, {
               DiskBox[{8.048602216684408, 7.89118519085174}, 
                0.06709388154952858], 
               InsetBox["\<\"least\"\>", 
                Offset[{2, 2}, {8.115696098233936, 7.958279072401268}], 
                ImageScaled[{0, 0}],
                BaseStyle->"Graphics"]}, {
               DiskBox[{8.556967608199079, 6.686731262064674}, 
                0.06709388154952858], 
               InsetBox["\<\"processing\"\>", 
                Offset[{2, 2}, {8.624061489748607, 6.753825143614202}], 
                ImageScaled[{0, 0}],
                BaseStyle->"Graphics"]}, {
               DiskBox[{9.28341008461209, 6.371646531468439}, 
                0.06709388154952858], 
               InsetBox["\<\"element\"\>", 
                Offset[{2, 2}, {9.350503966161618, 6.4387404130179675}], 
                ImageScaled[{0, 0}],
                BaseStyle->"Graphics"]}, {
               DiskBox[{8.647073688100742, 6.191027161907364}, 
                0.06709388154952858], 
               InsetBox["\<\"typically\"\>", 
                Offset[{2, 2}, {8.71416756965027, 6.258121043456892}], 
                ImageScaled[{0, 0}],
                BaseStyle->"Graphics"]}, {
               DiskBox[{8.38029970141519, 6.325975147000563}, 
                0.06709388154952858], 
               InsetBox["\<\"central\"\>", 
                Offset[{2, 2}, {8.447393582964718, 6.393069028550092}], 
                ImageScaled[{0, 0}],
                BaseStyle->"Graphics"]}, {
               DiskBox[{7.950037121015367, 5.6300531079084}, 
                0.06709388154952858], 
               InsetBox["\<\"unit\"\>", 
                Offset[{2, 2}, {8.017131002564895, 5.697146989457928}], 
                ImageScaled[{0, 0}],
                BaseStyle->"Graphics"]}, {
               DiskBox[{7.424466836623465, 4.908548004537416}, 
                0.06709388154952858], 
               InsetBox["\<\"CPU\"\>", 
                Offset[{2, 2}, {7.491560718172994, 4.975641886086945}], 
                ImageScaled[{0, 0}],
                BaseStyle->"Graphics"]}, {
               DiskBox[{6.52871531338926, 4.680792661869821}, 
                0.06709388154952858], 
               InsetBox["\<\"and\"\>", 
                Offset[{2, 2}, {6.595809194938789, 4.747886543419349}], 
                ImageScaled[{0, 0}],
                BaseStyle->"Graphics"]}, {
               DiskBox[{6.416921449899787, 5.19767518719537}, 
                0.06709388154952858], 
               InsetBox["\<\"some\"\>", 
                Offset[{2, 2}, {6.484015331449315, 5.264769068744898}], 
                ImageScaled[{0, 0}],
                BaseStyle->"Graphics"]}, {
               DiskBox[{6.7591961101130655, 5.7313139868657075}, 
                0.06709388154952858], 
               InsetBox["\<\"form\"\>", 
                Offset[{2, 2}, {6.826289991662594, 5.798407868415236}], 
                ImageScaled[{0, 0}],
                BaseStyle->"Graphics"]}, {
               DiskBox[{8.191139548780793, 6.876216100593336}, 
                0.06709388154952858], 
               InsetBox["\<\"memory\"\>", 
                Offset[{2, 2}, {8.258233430330321, 6.943309982142864}], 
                ImageScaled[{0, 0}],
                BaseStyle->"Graphics"]}, {
               DiskBox[{8.867588133317325, 7.262783535810694}, 
                0.06709388154952858], 
               InsetBox["\<\"The\"\>", 
                Offset[{2, 2}, {8.934682014866853, 7.329877417360223}], 
                ImageScaled[{0, 0}],
                BaseStyle->"Graphics"]}, {
               DiskBox[{9.387133428998192, 5.677794994496508}, 
                0.06709388154952858], 
               InsetBox["\<\"carries\"\>", 
                Offset[{2, 2}, {9.45422731054772, 5.744888876046036}], 
                ImageScaled[{0, 0}],
                BaseStyle->"Graphics"]}, {
               DiskBox[{6.730464549484481, 4.303569274382708}, 
                0.06709388154952858], 
               InsetBox["\<\"logic\"\>", 
                Offset[{2, 2}, {6.797558431034009, 4.370663155932236}], 
                ImageScaled[{0, 0}],
                BaseStyle->"Graphics"]}, {
               DiskBox[{7.0957432385751735, 5.196027276963674}, 
                0.06709388154952858], 
               InsetBox["\<\"sequencing\"\>", 
                Offset[{2, 2}, {7.162837120124702, 5.2631211585132025}], 
                ImageScaled[{0, 0}],
                BaseStyle->"Graphics"]}, {
               DiskBox[{7.33420760573115, 5.053035435623441}, 
                0.06709388154952858], 
               InsetBox["\<\"control\"\>", 
                Offset[{2, 2}, {7.401301487280678, 5.120129317172969}], 
                ImageScaled[{0, 0}],
                BaseStyle->"Graphics"]}, {
               DiskBox[{6.530173853935035, 5.484904487856812}, 
                0.06709388154952858], 
               InsetBox["\<\"change\"\>", 
                Offset[{2, 2}, {6.5972677354845635, 5.55199836940634}], 
                ImageScaled[{0, 0}],
                BaseStyle->"Graphics"]}, {
               DiskBox[{6.375249115392858, 5.922043327956353}, 
                0.06709388154952858], 
               InsetBox["\<\"order\"\>", 
                Offset[{2, 2}, {6.442342996942386, 5.9891372095058815}], 
                ImageScaled[{0, 0}],
                BaseStyle->"Graphics"]}, {
               DiskBox[{5.733831403287671, 4.270326719634406}, 
                0.06709388154952858], 
               InsetBox["\<\"in\"\>", 
                Offset[{2, 2}, {5.8009252848371995, 4.3374206011839345}], 
                ImageScaled[{0, 0}],
                BaseStyle->"Graphics"]}, {
               DiskBox[{6.950243254812751, 3.4859847857413895}, 
                0.06709388154952858], 
               InsetBox["\<\"response\"\>", 
                Offset[{2, 2}, {7.017337136362279, 3.5530786672909183}], 
                ImageScaled[{0, 0}],
                BaseStyle->"Graphics"]}, {
               DiskBox[{8.860654470126681, 2.4530282980082876}, 
                0.06709388154952858], 
               InsetBox["\<\"stored\"\>", 
                Offset[{2, 2}, {8.92774835167621, 2.5201221795578164}], 
                ImageScaled[{0, 0}],
                BaseStyle->"Graphics"]}, {
               DiskBox[{9.27169173155814, 2.127175568769304}, 
                0.06709388154952858], 
               InsetBox["\<\"information\"\>", 
                Offset[{2, 2}, {9.33878561310767, 2.1942694503188327}], 
                ImageScaled[{0, 0}],
                BaseStyle->"Graphics"]}, {
               DiskBox[{10.057066085236883, 1.6018181609028996}, 
                0.06709388154952858], 
               InsetBox["\<\"Peripheral\"\>", 
                Offset[{2, 2}, {10.124159966786412, 1.6689120424524282}], 
                ImageScaled[{0, 0}],
                BaseStyle->"Graphics"]}, {
               DiskBox[{10.42367189997939, 1.160246671100385}, 
                0.06709388154952858], 
               InsetBox["\<\"devices\"\>", 
                Offset[{2, 2}, {10.490765781528918, 1.2273405526499135}], 
                ImageScaled[{0, 0}],
                BaseStyle->"Graphics"]}, {
               DiskBox[{9.92643250367165, 1.4456390189991466}, 
                0.06709388154952858], 
               InsetBox["\<\"allow\"\>", 
                Offset[{2, 2}, {9.993526385221179, 1.5127329005486752}], 
                ImageScaled[{0, 0}],
                BaseStyle->"Graphics"]}, {
               DiskBox[{6.216785652668685, 3.2449336952385734}, 
                0.06709388154952858], 
               InsetBox["\<\"retrieved\"\>", 
                Offset[{2, 2}, {6.283879534218213, 3.3120275767881022}], 
                ImageScaled[{0, 0}],
                BaseStyle->"Graphics"]}, {
               DiskBox[{6.364678767806792, 2.307491305809486}, 
                0.06709388154952858], 
               InsetBox["\<\"from\"\>", 
                Offset[{2, 2}, {6.43177264935632, 2.3745851873590147}], 
                ImageScaled[{0, 0}],
                BaseStyle->"Graphics"]}, {
               DiskBox[{6.665171563193751, 1.8290257359789885}, 
                0.06709388154952858], 
               InsetBox["\<\"an\"\>", 
                Offset[{2, 2}, {6.7322654447432795, 1.896119617528517}], 
                ImageScaled[{0, 0}],
                BaseStyle->"Graphics"]}, {
               DiskBox[{6.749012425099872, 2.447093654591712}, 
                0.06709388154952858], 
               InsetBox["\<\"external\"\>", 
                Offset[{2, 2}, {6.8161063066494005, 2.514187536141241}], 
                ImageScaled[{0, 0}],
                BaseStyle->"Graphics"]}, {
               DiskBox[{6.625893054086672, 3.4297952488389347}, 
                0.06709388154952858], 
               InsetBox["\<\"source\"\>", 
                Offset[{2, 2}, {6.6929869356362, 3.4968891303884635}], 
                ImageScaled[{0, 0}],
                BaseStyle->"Graphics"]}, {
               DiskBox[{6.409657409413706, 6.079409219726441}, 
                0.06709388154952858], 
               InsetBox["\<\"result\"\>", 
                Offset[{2, 2}, {6.476751290963234, 6.146503101275969}], 
                ImageScaled[{0, 0}],
                BaseStyle->"Graphics"]}, {
               DiskBox[{6.963981978428761, 4.276001409935179}, 
                0.06709388154952858], 
               InsetBox["\<\"saved\"\>", 
                Offset[{2, 2}, {7.031075859978289, 4.343095291484707}], 
                ImageScaled[{0, 0}],
                BaseStyle->"Graphics"]}, {
               DiskBox[{5.003646987915086, 2.3846962838822976}, 
                0.06709388154952858], 
               InsetBox["\<\"Mechanical\"\>", 
                Offset[{2, 2}, {5.070740869464615, 2.4517901654318264}], 
                ImageScaled[{0, 0}],
                BaseStyle->"Graphics"]}, {
               DiskBox[{3.758580085028022, 1.855816382248089}, 
                0.06709388154952858], 
               InsetBox["\<\"analog\"\>", 
                Offset[{2, 2}, {3.825673966577551, 1.9229102637976176}], 
                ImageScaled[{0, 0}],
                BaseStyle->"Graphics"]}, {
               DiskBox[{3.775166978546306, 2.7305879156551147}, 
                0.06709388154952858], 
               InsetBox["\<\"computers\"\>", 
                Offset[{2, 2}, {3.8422608600958346, 2.7976817972046435}], 
                ImageScaled[{0, 0}],
                BaseStyle->"Graphics"]}, {
               DiskBox[{4.395460101070168, 2.795045715905718}, 
                0.06709388154952858], 
               InsetBox["\<\"started\"\>", 
                Offset[{2, 2}, {4.4625539826196965, 2.8621395974552466}], 
                ImageScaled[{0, 0}],
                BaseStyle->"Graphics"]}, {
               DiskBox[{5.061390269263109, 3.3922770901229757}, 
                0.06709388154952858], 
               InsetBox["\<\"appearing\"\>", Offset[{2, 2}, 
                {5.128484150812637, 3.4593709716725045}], ImageScaled[{0, 0}],
                
                BaseStyle->"Graphics"]}, {
               DiskBox[{5.109942592811901, 4.712970377883095}, 
                0.06709388154952858], 
               InsetBox["\<\"first\"\>", 
                Offset[{2, 2}, {5.177036474361429, 4.780064259432623}], 
                ImageScaled[{0, 0}],
                BaseStyle->"Graphics"]}, {
               DiskBox[{5.690493915169704, 4.584438939757817}, 
                0.06709388154952858], 
               InsetBox["\<\"century\"\>", 
                Offset[{2, 2}, {5.757587796719232, 4.651532821307345}], 
                ImageScaled[{0, 0}],
                BaseStyle->"Graphics"]}, {
               DiskBox[{4.8417943224155655, 4.154880847081267}, 
                0.06709388154952858], 
               InsetBox["\<\"were\"\>", 
                Offset[{2, 2}, {4.908888203965094, 4.221974728630795}], 
                ImageScaled[{0, 0}],
                BaseStyle->"Graphics"]}, {
               DiskBox[{4.192762557340956, 4.088626052281825}, 
                0.06709388154952858], 
               InsetBox["\<\"later\"\>", 
                Offset[{2, 2}, {4.259856438890484, 4.155719933831353}], 
                ImageScaled[{0, 0}],
                BaseStyle->"Graphics"]}, {
               DiskBox[{4.125561903777494, 4.3035376935642775}, 
                0.06709388154952858], 
               InsetBox["\<\"used\"\>", 
                Offset[{2, 2}, {4.192655785327022, 4.370631575113806}], 
                ImageScaled[{0, 0}],
                BaseStyle->"Graphics"]}, {
               DiskBox[{4.440532520522792, 5.3801622961793}, 
                0.06709388154952858], 
               InsetBox["\<\"medieval\"\>", 
                Offset[{2, 2}, {4.5076264020723205, 5.447256177728828}], 
                ImageScaled[{0, 0}],
                BaseStyle->"Graphics"]}, {
               DiskBox[{3.3170435421504925, 4.97663717870283}, 
                0.06709388154952858], 
               InsetBox["\<\"era\"\>", 
                Offset[{2, 2}, {3.3841374237000212, 5.043731060252358}], 
                ImageScaled[{0, 0}],
                BaseStyle->"Graphics"]}, {
               DiskBox[{2.50917794322678, 4.370075860317984}, 
                0.06709388154952858], 
               InsetBox["\<\"for\"\>", 
                Offset[{2, 2}, {2.576271824776309, 4.437169741867512}], 
                ImageScaled[{0, 0}],
                BaseStyle->"Graphics"]}, {
               DiskBox[{1.434638629990979, 3.52059595227331}, 
                0.06709388154952858], 
               InsetBox["\<\"astronomical\"\>", 
                Offset[{2, 2}, {1.5017325115405076, 3.587689833822839}], 
                ImageScaled[{0, 0}],
                BaseStyle->"Graphics"]}, {
               DiskBox[{0.6254698250933011, 2.6711830232713965}, 
                0.06709388154952858], 
               InsetBox["\<\"calculations\"\>", 
                Offset[{2, 2}, {0.6925637066428296, 2.7382769048209252}], 
                ImageScaled[{0, 0}],
                BaseStyle->"Graphics"]}, {
               DiskBox[{0.15237107653347248, 1.826314263648162}, 
                0.06709388154952858], 
               InsetBox["\<\"In\"\>", 
                Offset[{2, 2}, {0.21946495808300107, 1.8934081451976905}], 
                ImageScaled[{0, 0}],
                BaseStyle->"Graphics"]}, {
               DiskBox[{0.16091742840985912, 1.0454511064935912}, 
                0.06709388154952858], 
               InsetBox["\<\"World\"\>", 
                Offset[{2, 2}, {0.2280113099593877, 1.1125449880431197}], 
                ImageScaled[{0, 0}],
                BaseStyle->"Graphics"]}, {
               DiskBox[{0.7586502175475411, 0.6337015907455887}, 
                0.06709388154952858], 
               InsetBox["\<\"War\"\>", 
                Offset[{2, 2}, {0.8257440990970697, 0.7007954722951173}], 
                ImageScaled[{0, 0}],
                BaseStyle->"Graphics"]}, {
               DiskBox[{1.6459348074402058, 0.7089061451214675}, 
                0.06709388154952858], 
               InsetBox["\<\"II\"\>", 
                Offset[{2, 2}, {1.7130286889897344, 0.7760000266709961}], 
                ImageScaled[{0, 0}],
                BaseStyle->"Graphics"]}, {
               DiskBox[{2.658774408677256, 1.1336054147323709}, 
                0.06709388154952858], 
               InsetBox["\<\"mechanical\"\>", 
                Offset[{2, 2}, {2.7258682902267846, 1.2006992962818994}], 
                ImageScaled[{0, 0}],
                BaseStyle->"Graphics"]}, {
               DiskBox[{1.3653224586846058, 4.900678524486768}, 
                0.06709388154952858], 
               InsetBox["\<\"specialized\"\>", 
                Offset[{2, 2}, {1.4324163402341343, 4.967772406036296}], 
                ImageScaled[{0, 0}],
                BaseStyle->"Graphics"]}, {
               DiskBox[{0.4709752938450915, 5.509024547467219}, 
                0.06709388154952858], 
               InsetBox["\<\"military\"\>", 
                Offset[{2, 2}, {0.5380691753946201, 5.576118429016748}], 
                ImageScaled[{0, 0}],
                BaseStyle->"Graphics"]}, {
               DiskBox[{0., 6.250941554600795}, 0.06709388154952858], 
               InsetBox["\<\"applications\"\>", 
                Offset[{2, 2}, {0.06709388154952858, 6.318035436150323}], 
                ImageScaled[{0, 0}],
                BaseStyle->"Graphics"]}, {
               DiskBox[{0.18399721553772608, 6.997639624083163}, 
                0.06709388154952858], 
               InsetBox["\<\"such\"\>", 
                Offset[{2, 2}, {0.25109109708725463, 7.064733505632692}], 
                ImageScaled[{0, 0}],
                BaseStyle->"Graphics"]}, {
               DiskBox[{0.9377246156032744, 7.447261661452538}, 
                0.06709388154952858], 
               InsetBox["\<\"as\"\>", 
                Offset[{2, 2}, {1.004818497152803, 7.5143555430020665}], 
                ImageScaled[{0, 0}],
                BaseStyle->"Graphics"]}, {
               DiskBox[{0.7914133258034122, 8.337323308210841}, 
                0.06709388154952858], 
               InsetBox["\<\"calculating\"\>", 
                Offset[{2, 2}, {0.8585072073529407, 8.40441718976037}], 
                ImageScaled[{0, 0}],
                BaseStyle->"Graphics"]}, {
               DiskBox[{1.1244370282325686, 8.953714358372414}, 
                0.06709388154952858], 
               InsetBox["\<\"torpedo\"\>", 
                Offset[{2, 2}, {1.1915309097820972, 9.020808239921942}], 
                ImageScaled[{0, 0}],
                BaseStyle->"Graphics"]}, {
               DiskBox[{1.8823295141778336, 8.959969673216353}, 
                0.06709388154952858], 
               InsetBox["\<\"aiming\"\>", 
                Offset[{2, 2}, {1.9494233957273621, 9.027063554765881}], 
                ImageScaled[{0, 0}],
                BaseStyle->"Graphics"]}, {
               DiskBox[{2.7402912281441685, 8.501569388383661}, 
                0.06709388154952858], 
               InsetBox["\<\"During\"\>", 
                Offset[{2, 2}, {2.8073851096936973, 8.56866326993319}], 
                ImageScaled[{0, 0}],
                BaseStyle->"Graphics"]}, {
               DiskBox[{3.657426930489685, 7.735557513310497}, 
                0.06709388154952858], 
               InsetBox["\<\"this\"\>", 
                Offset[{2, 2}, {3.7245208120392137, 7.802651394860026}], 
                ImageScaled[{0, 0}],
                BaseStyle->"Graphics"]}, {
               DiskBox[{4.655593071009504, 6.734156008913222}, 
                0.06709388154952858], 
               InsetBox["\<\"time\"\>", 
                Offset[{2, 2}, {4.722686952559032, 6.80124989046275}], 
                ImageScaled[{0, 0}],
                BaseStyle->"Graphics"]}, {
               DiskBox[{4.453626787323267, 3.8855798171172}, 
                0.06709388154952858], 
               InsetBox["\<\"electronic\"\>", 
                Offset[{2, 2}, {4.520720668872795, 3.952673698666729}], 
                ImageScaled[{0, 0}],
                BaseStyle->"Graphics"]}, {
               DiskBox[{3.9400604913433535, 3.1814016294962038}, 
                0.06709388154952858], 
               InsetBox["\<\"digital\"\>", 
                Offset[{2, 2}, {4.007154372892882, 3.2484955110457325}], 
                ImageScaled[{0, 0}],
                BaseStyle->"Graphics"]}, {
               DiskBox[{4.090259126621749, 3.639616955478291}, 
                0.06709388154952858], 
               InsetBox["\<\"developed\"\>", 
                Offset[{2, 2}, {4.1573530081712775, 3.7067108370278197}], 
                ImageScaled[{0, 0}],
                BaseStyle->"Graphics"]}, {
               DiskBox[{3.526386567993374, 3.5049464058961384}, 
                0.06709388154952858], 
               InsetBox["\<\"Originally\"\>", 
                Offset[{2, 2}, {3.593480449542903, 3.572040287445667}], 
                ImageScaled[{0, 0}],
                BaseStyle->"Graphics"]}, {
               DiskBox[{3.959632414685003, 3.830983348322878}, 
                0.06709388154952858], 
               InsetBox["\<\"they\"\>", 
                Offset[{2, 2}, {4.026726296234531, 3.8980772298724067}], 
                ImageScaled[{0, 0}],
                BaseStyle->"Graphics"]}, {
               DiskBox[{6.301953245558314, 6.19077350973878}, 
                0.06709388154952858], 
               InsetBox["\<\"size\"\>", 
                Offset[{2, 2}, {6.369047127107843, 6.2578673912883085}], 
                ImageScaled[{0, 0}],
                BaseStyle->"Graphics"]}, {
               DiskBox[{5.740053171637852, 6.601468329788948}, 
                0.06709388154952858], 
               InsetBox["\<\"large\"\>", 
                Offset[{2, 2}, {5.80714705318738, 6.668562211338476}], 
                ImageScaled[{0, 0}],
                BaseStyle->"Graphics"]}, {
               DiskBox[{4.03915346784052, 7.09264256881027}, 
                0.06709388154952858], 
               InsetBox["\<\"room\"\>", 
                Offset[{2, 2}, {4.106247349390048, 7.159736450359798}], 
                ImageScaled[{0, 0}],
                BaseStyle->"Graphics"]}, {
               DiskBox[{2.4369263914801294, 7.360038423573828}, 
                0.06709388154952858], 
               InsetBox["\<\"consuming\"\>", 
                Offset[{2, 2}, {2.504020273029658, 7.427132305123356}], 
                ImageScaled[{0, 0}],
                BaseStyle->"Graphics"]}, {
               DiskBox[{0.354347806107957, 7.918200860512604}, 
                0.06709388154952858], 
               InsetBox["\<\"much\"\>", 
                Offset[{2, 2}, {0.4214416876574856, 7.985294742062132}], 
                ImageScaled[{0, 0}],
                BaseStyle->"Graphics"]}, {
               DiskBox[{0.24071293518263204, 7.734578829178509}, 
                0.06709388154952858], 
               InsetBox["\<\"power\"\>", 
                Offset[{2, 2}, {0.3078068167321606, 7.801672710728037}], 
                ImageScaled[{0, 0}],
                BaseStyle->"Graphics"]}, {
               DiskBox[{0.7711108831771822, 6.416707493838862}, 
                0.06709388154952858], 
               InsetBox["\<\"several\"\>", 
                Offset[{2, 2}, {0.8382047647267108, 6.48380137538839}], 
                ImageScaled[{0, 0}],
                BaseStyle->"Graphics"]}, {
               DiskBox[{0.9928501447273907, 5.329833321505883}, 
                0.06709388154952858], 
               InsetBox["\<\"hundred\"\>", 
                Offset[{2, 2}, {1.0599440262769193, 5.396927203055411}], 
                ImageScaled[{0, 0}],
                BaseStyle->"Graphics"]}, {
               DiskBox[{1.5935259191467486, 4.294114157577752}, 
                0.06709388154952858], 
               InsetBox["\<\"modern\"\>", 
                Offset[{2, 2}, {1.6606198006962771, 4.3612080391272805}], 
                ImageScaled[{0, 0}],
                BaseStyle->"Graphics"]}, {
               DiskBox[{2.535622482436771, 3.4015464614673867}, 
                0.06709388154952858], 
               InsetBox["\<\"personal\"\>", 
                Offset[{2, 2}, {2.6027163639863, 3.4686403430169155}], 
                ImageScaled[{0, 0}],
                BaseStyle->"Graphics"]}, {
               DiskBox[{3.3161490341250306, 2.1013566567852195}, 
                0.06709388154952858], 
               InsetBox["\<\"PCs\"\>", 
                Offset[{2, 2}, {3.3832429156745594, 2.1684505383347483}], 
                ImageScaled[{0, 0}],
                BaseStyle->"Graphics"]}, {
               DiskBox[{3.1634830896677855, 2.2562464449840625}, 
                0.06709388154952858], 
               InsetBox["\<\"Modern\"\>", Offset[{2, 2}, 
                {3.2305769712173142, 2.3233403265335912}], ImageScaled[{0, 0}],
                BaseStyle->"Graphics"]}, {
               DiskBox[{4.225675714722049, 1.4691650832188197}, 
                0.06709388154952858], 
               InsetBox["\<\"based\"\>", 
                Offset[{2, 2}, {4.292769596271578, 1.5362589647683482}], 
                ImageScaled[{0, 0}],
                BaseStyle->"Graphics"]}, {
               DiskBox[{4.889021154120004, 0.5177535638605564}, 
                0.06709388154952858], 
               InsetBox["\<\"on\"\>", 
                Offset[{2, 2}, {4.956115035669533, 0.5848474454100849}], 
                ImageScaled[{0, 0}],
                BaseStyle->"Graphics"]}, {
               DiskBox[{5.754671967053932, 0.}, 0.06709388154952858], 
               InsetBox["\<\"integrated\"\>", 
                Offset[{2, 2}, {5.8217658486034605, 0.06709388154952858}], 
                ImageScaled[{0, 0}],
                BaseStyle->"Graphics"]}, {
               DiskBox[{6.6916232164290435, 0.06894214896797468}, 
                0.06709388154952858], 
               InsetBox["\<\"circuits\"\>", 
                Offset[{2, 2}, {6.758717097978572, 0.13603603051750326}], 
                ImageScaled[{0, 0}],
                BaseStyle->"Graphics"]}, {
               DiskBox[{7.46557005847371, 0.7059102227198553}, 
                0.06709388154952858], 
               InsetBox["\<\"are\"\>", 
                Offset[{2, 2}, {7.532663940023238, 0.7730041042693838}], 
                ImageScaled[{0, 0}],
                BaseStyle->"Graphics"]}, {
               DiskBox[{7.961848666882953, 1.7513799751447756}, 
                0.06709388154952858], 
               InsetBox["\<\"millions\"\>", 
                Offset[{2, 2}, {8.028942548432482, 1.8184738566943042}], 
                ImageScaled[{0, 0}],
                BaseStyle->"Graphics"]}, {
               DiskBox[{7.853162015719795, 4.505850126183707}, 
                0.06709388154952858], 
               InsetBox["\<\"billions\"\>", 
                Offset[{2, 2}, {7.920255897269324, 4.572944007733235}], 
                ImageScaled[{0, 0}],
                BaseStyle->"Graphics"]}, {
               DiskBox[{7.214220204055934, 7.009597093418636}, 
                0.06709388154952858], 
               InsetBox["\<\"times\"\>", 
                Offset[{2, 2}, {7.281314085605462, 7.076690974968164}], 
                ImageScaled[{0, 0}],
                BaseStyle->"Graphics"]}, {
               DiskBox[{6.745727323839757, 7.804562931587747}, 
                0.06709388154952858], 
               InsetBox["\<\"capable\"\>", 
                Offset[{2, 2}, {6.812821205389286, 7.8716568131372755}], 
                ImageScaled[{0, 0}],
                BaseStyle->"Graphics"]}, {
               DiskBox[{5.309603059821833, 5.45976459149585}, 
                0.06709388154952858], 
               InsetBox["\<\"early\"\>", 
                Offset[{2, 2}, {5.376696941371361, 5.526858473045379}], 
                ImageScaled[{0, 0}],
                BaseStyle->"Graphics"]}, {
               DiskBox[{5.749264030702026, 5.0321625418720615}, 
                0.06709388154952858], 
               InsetBox["\<\"machines\"\>", 
                Offset[{2, 2}, {5.816357912251554, 5.09925642342159}], 
                ImageScaled[{0, 0}],
                BaseStyle->"Graphics"]}, {
               DiskBox[{6.966028973571536, 5.3199607575271575}, 
                0.06709388154952858], 
               InsetBox["\<\"occupy\"\>", 
                Offset[{2, 2}, {7.033122855121064, 5.387054639076686}], 
                ImageScaled[{0, 0}],
                BaseStyle->"Graphics"]}, {
               DiskBox[{7.626334971332758, 6.419618767595251}, 
                0.06709388154952858], 
               InsetBox["\<\"fraction\"\>", 
                Offset[{2, 2}, {7.6934288528822865, 6.4867126491447795}], 
                ImageScaled[{0, 0}],
                BaseStyle->"Graphics"]}, {
               DiskBox[{5.141449097824981, 6.515203355827623}, 
                0.06709388154952858], 
               InsetBox["\<\"space\"\>", 
                Offset[{2, 2}, {5.208542979374509, 6.582297237377151}], 
                ImageScaled[{0, 0}],
                BaseStyle->"Graphics"]}, {
               DiskBox[{4.763497170502677, 7.248463927995084}, 
                0.06709388154952858], 
               InsetBox["\<\"Computers\"\>", 
                Offset[{2, 2}, {4.830591052052205, 7.315557809544613}], 
                ImageScaled[{0, 0}],
                BaseStyle->"Graphics"]}}}],
           MouseAppearanceTag["NetworkGraphics"]],
          AllowKernelInitialization->False]],
        DefaultBaseStyle->{
         "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> 
          Hue[0.8, 1., 0.6]},
        FormatType->TraditionalForm,
        FrameTicks->None,
        GridLinesStyle->Directive[
          GrayLevel[0.5, 0.4]],
        ImageSize->{560.48828125, Automatic}]], "ExerciseOutput",
       ExpressionUUID->"3e927a49-6ac2-43f5-950e-166859b2fb5c"],
      Apply[TextCell, 
       Cell[
        BoxData[
         GraphicsBox[
          NamespaceBox["NetworkGraphics", 
           DynamicModuleBox[{Typeset`graph = HoldComplete[
               
               Graph[{"A", "computer", "is", "a", "general-purpose", "device",
                  "that", "can", "be", "programmed", "to", "carry", "out", 
                 "set", "of", "arithmetic", "or", "logical", "operations", 
                 "automatically", "Since", "sequence", "readily", "changed", 
                 "the", "solve", "more", "than", "one", "kind", "problem", 
                 "Conventionally", "consists", "at", "least", "processing", 
                 "element", "typically", "central", "unit", "CPU", "and", 
                 "some", "form", "memory", "The", "carries", "logic", 
                 "sequencing", "control", "change", "order", "in", "response",
                  "stored", "information", "Peripheral", "devices", "allow", 
                 "retrieved", "from", "an", "external", "source", "result", 
                 "saved", "Mechanical", "analog", "computers", "started", 
                 "appearing", "first", "century", "were", "later", "used", 
                 "medieval", "era", "for", "astronomical", "calculations", 
                 "In", "World", "War", "II", "mechanical", "specialized", 
                 "military", "applications", "such", "as", "calculating", 
                 "torpedo", "aiming", "During", "this", "time", "electronic", 
                 "digital", "developed", "Originally", "they", "size", 
                 "large", "room", "consuming", "much", "power", "several", 
                 "hundred", "modern", "personal", "PCs", "Modern", "based", 
                 "on", "integrated", "circuits", "are", "millions", 
                 "billions", "times", "capable", "early", "machines", 
                 "occupy", "fraction", "space", "Computers"}, {CompressedData["
1:eJwVjXlXAVEAxTWeGk16w6i8UGEsPaVVJC2qsYyxS2lKhRIR2rRSn66vVe+P
e+655/7OvZZyO1umFArF77+ID1GUUgmASjU8PDJC02r16CjDjI1pNACMj0PI
slqtTsdxev3EBACTkxByHKGmpgwGhCiKpqenjUaTyWyemYFwdnZuDgCKslgg
tFptNrOZ5+12hwMAp5PnXa75eYzd7oUFCBcXPR7SLS1pNCyL8fIyx2EMwMoK
xqurLhdNr60htL5O/rzejQ2G8fn8/s3NQGBry+9nGLU6GNze3tnZ3d3bwxih
UIiQ+/sYB4MHB4eHghAORyJeL0LRaCyGsSjG45JEciKRTKZS6XQmk83mcvn8
0VGhQHhRlKRU6vj45KRYPD2V5bOz8/NS6eLi8vLqiqyUy5UKoarV6+ubG1FE
qFaDEIDb23q90ZDlu7tmU5Zbrfv7drvTEYRu9+FBEB4fn56en19eer3XV4Z5
e4Pw/d1o/PgwmRD6/Pz6wrjfB2AwgBCh7++fP2p9VTA=
                 "], Null}, {
                VertexLabels -> {All}}]]}, 
            TagBox[
             GraphicsGroupBox[{{{{
                  Hue[0.6, 0.7, 0.5], 
                  Opacity[0.7], 
                  Arrowheads[0.016091709858418807`], 
                  
                  ArrowBox[{{6.341217765333148, 6.886662961688092}, {
                   6.767459466344739, 6.0892340568547505`}}, 
                   0.06709388154952858], 
                  
                  ArrowBox[{{6.767459466344739, 6.0892340568547505`}, {
                   7.160794872630211, 6.353686992564913}}, 
                   0.06709388154952858], 
                  
                  ArrowBox[{{6.767459466344739, 6.0892340568547505`}, {
                   7.420136334138459, 5.305742090973326}}, 
                   0.06709388154952858], 
                  
                  ArrowBox[{{6.767459466344739, 6.0892340568547505`}, {
                   6.89066939047105, 6.602735114316545}}, 
                   0.06709388154952858], 
                  
                  ArrowBox[{{7.160794872630211, 6.353686992564913}, {
                   7.51352547870051, 5.854579982965166}}, 
                   0.06709388154952858], 
                  
                  ArrowBox[{{7.51352547870051, 5.854579982965166}, {
                   6.767459466344739, 6.0892340568547505`}}, 
                   0.06709388154952858], 
                  
                  ArrowBox[{{7.51352547870051, 5.854579982965166}, {
                   8.646330223110617, 5.776805036111114}}, 
                   0.06709388154952858], 
                  
                  ArrowBox[{{7.51352547870051, 5.854579982965166}, {
                   7.883735126876614, 6.08699485557217}}, 
                   0.06709388154952858], 
                  
                  ArrowBox[{{7.51352547870051, 5.854579982965166}, {
                   7.80102014074524, 6.286931140395776}}, 
                   0.06709388154952858], 
                  
                  ArrowBox[{{7.51352547870051, 5.854579982965166}, {
                   8.38029970141519, 6.325975147000563}}, 
                   0.06709388154952858], 
                  
                  ArrowBox[{{7.51352547870051, 5.854579982965166}, {
                   7.0957432385751735`, 5.196027276963674}}, 
                   0.06709388154952858], 
                  
                  ArrowBox[{{7.51352547870051, 5.854579982965166}, {
                   5.740053171637852, 6.601468329788948}}, 
                   0.06709388154952858], 
                  
                  ArrowBox[{{7.51352547870051, 5.854579982965166}, {
                   7.626334971332758, 6.419618767595251}}, 
                   0.06709388154952858], 
                  
                  ArrowBox[{{8.646330223110617, 5.776805036111114}, {
                   9.259068711197596, 5.485305335558021}}, 
                   0.06709388154952858], 
                  
                  ArrowBox[{{9.259068711197596, 5.485305335558021}, {
                   8.580522147725036, 5.347339183971889}}, 
                   0.06709388154952858], 
                  
                  ArrowBox[{{8.580522147725036, 5.347339183971889}, {
                   7.420136334138459, 5.305742090973326}}, 
                   0.06709388154952858], 
                  ArrowBox[
                   
                   BezierCurveBox[{{7.420136334138459, 5.305742090973326}, {
                    7.617304140722688, 4.518797154129285}, {7.308882271072699,
                     3.7684416198461594`}}], 0.06709388154952858], 
                  ArrowBox[
                   
                   BezierCurveBox[{{7.420136334138459, 5.305742090973326}, {
                    7.111714464488472, 4.555386556635822}, {7.308882271072699,
                     3.7684416198461594`}}], 0.06709388154952858], 
                  
                  ArrowBox[{{7.420136334138459, 5.305742090973326}, {
                   7.318061729407752, 6.503945853693873}}, 
                   0.06709388154952858], 
                  
                  ArrowBox[{{7.420136334138459, 5.305742090973326}, {
                   6.530173853935035, 5.484904487856812}}, 
                   0.06709388154952858], 
                  
                  ArrowBox[{{7.308882271072699, 3.7684416198461594`}, {
                   7.830781777216217, 3.1011066717555527`}}, 
                   0.06709388154952858], 
                  
                  ArrowBox[{{7.308882271072699, 3.7684416198461594`}, {
                   6.56814703340736, 3.9600994656483186`}}, 
                   0.06709388154952858], 
                  
                  ArrowBox[{{7.308882271072699, 3.7684416198461594`}, {
                   6.216785652668685, 3.2449336952385734`}}, 
                   0.06709388154952858], 
                  
                  ArrowBox[{{7.830781777216217, 3.1011066717555527`}, {
                   8.163839360665946, 3.076724425443019}}, 
                   0.06709388154952858], 
                  
                  ArrowBox[{{8.163839360665946, 3.076724425443019}, {
                   7.308882271072699, 3.7684416198461594`}}, 
                   0.06709388154952858], 
                  
                  ArrowBox[{{8.163839360665946, 3.076724425443019}, {
                   8.68657450574927, 3.949273561931784}}, 
                   0.06709388154952858], 
                  
                  ArrowBox[{{8.163839360665946, 3.076724425443019}, {
                   8.860654470126681, 2.4530282980082876`}}, 
                   0.06709388154952858], 
                  
                  ArrowBox[{{8.163839360665946, 3.076724425443019}, {
                   7.853162015719795, 4.505850126183707}}, 
                   0.06709388154952858], 
                  
                  ArrowBox[{{8.68657450574927, 3.949273561931784}, {
                   8.512326272919319, 5.082896376383502}}, 
                   0.06709388154952858], 
                  
                  ArrowBox[{{8.512326272919319, 5.082896376383502}, {
                   7.51352547870051, 5.854579982965166}}, 
                   0.06709388154952858], 
                  
                  ArrowBox[{{8.512326272919319, 5.082896376383502}, {
                   7.67042109132925, 5.043338154962031}}, 
                   0.06709388154952858], 
                  
                  ArrowBox[{{7.883735126876614, 6.08699485557217}, {
                   7.2424682828573665`, 6.032569519766121}}, 
                   0.06709388154952858], 
                  
                  ArrowBox[{{7.2424682828573665`, 6.032569519766121}, {
                   7.51352547870051, 5.854579982965166}}, 
                   0.06709388154952858], 
                  
                  ArrowBox[{{7.2424682828573665`, 6.032569519766121}, {
                   7.67042109132925, 5.043338154962031}}, 
                   0.06709388154952858], 
                  ArrowBox[
                   
                   BezierCurveBox[{{7.2424682828573665`, 6.032569519766121}, {
                    7.33814490667133, 5.361141595238271}, {7.016610550498093, 
                    4.763994099336369}}], 0.06709388154952858], 
                  
                  ArrowBox[{{7.2424682828573665`, 6.032569519766121}, {
                   7.016610550498093, 4.763994099336369}}, 
                   0.06709388154952858], 
                  ArrowBox[
                   
                   BezierCurveBox[{{7.2424682828573665`, 6.032569519766121}, {
                    6.920933926684132, 5.435422023859533}, {7.016610550498093,
                     4.763994099336369}}], 0.06709388154952858], 
                  ArrowBox[{{7.2424682828573665`, 6.032569519766121}, {
                   5.792596146963917, 5.595709513281148}}, 
                   0.06709388154952858], 
                  
                  ArrowBox[{{7.2424682828573665`, 6.032569519766121}, {
                   7.869719923329276, 6.691211524677881}}, 
                   0.06709388154952858], 
                  
                  ArrowBox[{{7.2424682828573665`, 6.032569519766121}, {
                   7.76659702933596, 7.157204821153302}}, 
                   0.06709388154952858], 
                  
                  ArrowBox[{{7.2424682828573665`, 6.032569519766121}, {
                   8.191139548780793, 6.876216100593336}}, 
                   0.06709388154952858], 
                  
                  ArrowBox[{{7.2424682828573665`, 6.032569519766121}, {
                   7.214220204055934, 7.009597093418636}}, 
                   0.06709388154952858], 
                  
                  ArrowBox[{{7.67042109132925, 5.043338154962031}, {
                   8.293102583802245, 4.452774155752466}}, 
                   0.06709388154952858], 
                  
                  ArrowBox[{{7.67042109132925, 5.043338154962031}, {
                   6.52871531338926, 4.680792661869821}}, 
                   0.06709388154952858], 
                  
                  ArrowBox[{{8.293102583802245, 4.452774155752466}, {
                   7.807793839076568, 4.247404407400158}}, 
                   0.06709388154952858], 
                  
                  ArrowBox[{{7.807793839076568, 4.247404407400158}, {
                   7.016610550498093, 4.763994099336369}}, 
                   0.06709388154952858], 
                  
                  ArrowBox[{{7.016610550498093, 4.763994099336369}, {
                   7.420136334138459, 5.305742090973326}}, 
                   0.06709388154952858], 
                  
                  ArrowBox[{{7.016610550498093, 4.763994099336369}, {
                   7.913620916599047, 4.822218280398296}}, 
                   0.06709388154952858], 
                  
                  ArrowBox[{{7.016610550498093, 4.763994099336369}, {
                   6.52871531338926, 4.680792661869821}}, 
                   0.06709388154952858], 
                  
                  ArrowBox[{{7.016610550498093, 4.763994099336369}, {
                   5.733831403287671, 4.270326719634406}}, 
                   0.06709388154952858], 
                  
                  ArrowBox[{{7.016610550498093, 4.763994099336369}, {
                   6.963981978428761, 4.276001409935179}}, 
                   0.06709388154952858], 
                  ArrowBox[{{7.913620916599047, 4.822218280398296}, {
                   8.169086999859772, 5.360057131761351}}, 
                   0.06709388154952858], 
                  
                  ArrowBox[{{8.169086999859772, 5.360057131761351}, {
                   7.51352547870051, 5.854579982965166}}, 
                   0.06709388154952858], 
                  
                  ArrowBox[{{7.80102014074524, 6.286931140395776}, {
                   7.2424682828573665`, 6.032569519766121}}, 
                   0.06709388154952858], 
                  
                  ArrowBox[{{6.56814703340736, 3.9600994656483186`}, {
                   6.043366407184176, 4.696178292811545}}, 
                   0.06709388154952858], 
                  
                  ArrowBox[{{6.043366407184176, 4.696178292811545}, {
                   5.792596146963917, 5.595709513281148}}, 
                   0.06709388154952858], 
                  
                  ArrowBox[{{5.792596146963917, 5.595709513281148}, {
                   6.767459466344739, 6.0892340568547505`}}, 
                   0.06709388154952858], 
                  
                  ArrowBox[{{5.792596146963917, 5.595709513281148}, {
                   6.375249115392858, 5.922043327956353}}, 
                   0.06709388154952858], 
                  
                  ArrowBox[{{5.792596146963917, 5.595709513281148}, {
                   6.409657409413706, 6.079409219726441}}, 
                   0.06709388154952858], 
                  ArrowBox[
                   
                   BezierCurveBox[{{5.792596146963917, 5.595709513281148}, {
                    5.596427652880553, 5.042083885053285}, {5.109942592811901,
                     4.712970377883095}}], 0.06709388154952858], 
                  ArrowBox[
                   
                   BezierCurveBox[{{5.792596146963917, 5.595709513281148}, {
                    5.306111086895266, 5.266596006056129}, {5.109942592811901,
                     4.712970377883095}}], 0.06709388154952858], 
                  
                  ArrowBox[{{5.792596146963917, 5.595709513281148}, {
                   4.440532520522792, 5.3801622961793}}, 0.06709388154952858], 
                  
                  ArrowBox[{{5.792596146963917, 5.595709513281148}, {
                   6.301953245558314, 6.19077350973878}}, 
                   0.06709388154952858], 
                  
                  ArrowBox[{{5.792596146963917, 5.595709513281148}, {
                   5.309603059821833, 5.45976459149585}}, 
                   0.06709388154952858], 
                  ArrowBox[{{5.792596146963917, 5.595709513281148}, {
                   5.141449097824981, 6.515203355827623}}, 
                   0.06709388154952858], 
                  
                  ArrowBox[{{7.318061729407752, 6.503945853693873}, {
                   7.025608502028897, 7.374116436287009}}, 
                   0.06709388154952858], 
                  
                  ArrowBox[{{7.025608502028897, 7.374116436287009}, {
                   6.651705125831321, 6.9668323078873495`}}, 
                   0.06709388154952858], 
                  
                  ArrowBox[{{7.025608502028897, 7.374116436287009}, {
                   6.745727323839757, 7.804562931587747}}, 
                   0.06709388154952858], 
                  
                  ArrowBox[{{6.651705125831321, 6.9668323078873495`}, {
                   5.792596146963917, 5.595709513281148}}, 
                   0.06709388154952858], 
                  
                  ArrowBox[{{6.651705125831321, 6.9668323078873495`}, {
                   7.754193904358154, 7.367406508639469}}, 
                   0.06709388154952858], 
                  
                  ArrowBox[{{7.754193904358154, 7.367406508639469}, {
                   7.558680136610801, 6.975019954842593}}, 
                   0.06709388154952858], 
                  
                  ArrowBox[{{7.754193904358154, 7.367406508639469}, {
                   8.556967608199079, 6.686731262064674}}, 
                   0.06709388154952858], 
                  
                  ArrowBox[{{7.558680136610801, 6.975019954842593}, {
                   7.2424682828573665`, 6.032569519766121}}, 
                   0.06709388154952858], 
                  
                  ArrowBox[{{7.869719923329276, 6.691211524677881}, {
                   8.146404866369867, 6.479017202758196}}, 
                   0.06709388154952858], 
                  
                  ArrowBox[{{8.146404866369867, 6.479017202758196}, {
                   7.51352547870051, 5.854579982965166}}, 
                   0.06709388154952858], 
                  
                  ArrowBox[{{6.89066939047105, 6.602735114316545}, {
                   7.2424682828573665`, 6.032569519766121}}, 
                   0.06709388154952858], 
                  
                  ArrowBox[{{7.76659702933596, 7.157204821153302}, {
                   8.048602216684408, 7.89118519085174}}, 
                   0.06709388154952858], 
                  
                  ArrowBox[{{8.048602216684408, 7.89118519085174}, {
                   7.754193904358154, 7.367406508639469}}, 
                   0.06709388154952858], 
                  ArrowBox[
                   
                   BezierCurveBox[{{8.556967608199079, 6.686731262064674}, {
                    8.972001614930823, 6.648645640497233}, {9.28341008461209, 
                    6.371646531468439}}], 0.06709388154952858], 
                  ArrowBox[
                   
                   BezierCurveBox[{{8.556967608199079, 6.686731262064674}, {
                    8.868376077880347, 6.409732153308934}, {9.28341008461209, 
                    6.371646531468439}}], 0.06709388154952858], 
                  
                  ArrowBox[{{8.556967608199079, 6.686731262064674}, {
                   7.950037121015367, 5.6300531079084}}, 0.06709388154952858], 
                  
                  ArrowBox[{{9.28341008461209, 6.371646531468439}, {
                   8.647073688100742, 6.191027161907364}}, 
                   0.06709388154952858], 
                  
                  ArrowBox[{{9.28341008461209, 6.371646531468439}, {
                   9.387133428998192, 5.677794994496508}}, 
                   0.06709388154952858], 
                  
                  ArrowBox[{{8.647073688100742, 6.191027161907364}, {
                   7.51352547870051, 5.854579982965166}}, 
                   0.06709388154952858], 
                  
                  ArrowBox[{{8.38029970141519, 6.325975147000563}, {
                   8.556967608199079, 6.686731262064674}}, 
                   0.06709388154952858], 
                  
                  ArrowBox[{{7.950037121015367, 5.6300531079084}, {
                   7.420136334138459, 5.305742090973326}}, 
                   0.06709388154952858], 
                  
                  ArrowBox[{{7.950037121015367, 5.6300531079084}, {
                   7.424466836623465, 4.908548004537416}}, 
                   0.06709388154952858], 
                  
                  ArrowBox[{{7.424466836623465, 4.908548004537416}, {
                   6.52871531338926, 4.680792661869821}}, 
                   0.06709388154952858], 
                  
                  ArrowBox[{{6.52871531338926, 4.680792661869821}, {
                   7.51352547870051, 5.854579982965166}}, 
                   0.06709388154952858], 
                  
                  ArrowBox[{{6.52871531338926, 4.680792661869821}, {
                   5.792596146963917, 5.595709513281148}}, 
                   0.06709388154952858], 
                  
                  ArrowBox[{{6.52871531338926, 4.680792661869821}, {
                   6.416921449899787, 5.19767518719537}}, 
                   0.06709388154952858], 
                  ArrowBox[{{6.52871531338926, 4.680792661869821}, {
                   6.730464549484481, 4.303569274382708}}, 
                   0.06709388154952858], 
                  
                  ArrowBox[{{6.52871531338926, 4.680792661869821}, {
                   7.33420760573115, 5.053035435623441}}, 
                   0.06709388154952858], 
                  
                  ArrowBox[{{6.52871531338926, 4.680792661869821}, {
                   6.216785652668685, 3.2449336952385734`}}, 
                   0.06709388154952858], 
                  
                  ArrowBox[{{6.52871531338926, 4.680792661869821}, {
                   4.8417943224155655`, 4.154880847081267}}, 
                   0.06709388154952858], 
                  
                  ArrowBox[{{6.52871531338926, 4.680792661869821}, {
                   6.966028973571536, 5.3199607575271575`}}, 
                   0.06709388154952858], 
                  
                  ArrowBox[{{6.416921449899787, 5.19767518719537}, {
                   6.7591961101130655`, 5.7313139868657075`}}, 
                   0.06709388154952858], 
                  
                  ArrowBox[{{6.7591961101130655`, 5.7313139868657075`}, {
                   7.2424682828573665`, 6.032569519766121}}, 
                   0.06709388154952858], 
                  
                  ArrowBox[{{8.191139548780793, 6.876216100593336}, {
                   8.867588133317325, 7.262783535810694}}, 
                   0.06709388154952858], 
                  
                  ArrowBox[{{8.867588133317325, 7.262783535810694}, {
                   8.556967608199079, 6.686731262064674}}, 
                   0.06709388154952858], 
                  
                  ArrowBox[{{9.387133428998192, 5.677794994496508}, {
                   8.512326272919319, 5.082896376383502}}, 
                   0.06709388154952858], 
                  
                  ArrowBox[{{6.730464549484481, 4.303569274382708}, {
                   7.016610550498093, 4.763994099336369}}, 
                   0.06709388154952858], 
                  
                  ArrowBox[{{7.0957432385751735`, 5.196027276963674}, {
                   6.52871531338926, 4.680792661869821}}, 
                   0.06709388154952858], 
                  
                  ArrowBox[{{7.33420760573115, 5.053035435623441}, {
                   7.950037121015367, 5.6300531079084}}, 0.06709388154952858], 
                  
                  ArrowBox[{{6.530173853935035, 5.484904487856812}, {
                   5.792596146963917, 5.595709513281148}}, 
                   0.06709388154952858], 
                  ArrowBox[{{6.375249115392858, 5.922043327956353}, {
                   7.2424682828573665`, 6.032569519766121}}, 
                   0.06709388154952858], 
                  ArrowBox[
                   
                   BezierCurveBox[{{5.733831403287671, 4.270326719634406}, {
                    5.545266838234879, 4.942681434823182}, {5.792596146963917,
                     5.595709513281148}}], 0.06709388154952858], 
                  ArrowBox[
                   
                   BezierCurveBox[{{5.733831403287671, 4.270326719634406}, {
                    5.9811607120167105`, 4.923354798126046}, {
                    5.792596146963917, 5.595709513281148}}], 
                   0.06709388154952858], 
                  
                  ArrowBox[{{5.733831403287671, 4.270326719634406}, {
                   6.950243254812751, 3.4859847857413895`}}, 
                   0.06709388154952858], 
                  
                  ArrowBox[{{6.950243254812751, 3.4859847857413895`}, {
                   8.163839360665946, 3.076724425443019}}, 
                   0.06709388154952858], 
                  
                  ArrowBox[{{8.860654470126681, 2.4530282980082876`}, {
                   9.27169173155814, 2.127175568769304}}, 
                   0.06709388154952858], 
                  
                  ArrowBox[{{9.27169173155814, 2.127175568769304}, {
                   8.163839360665946, 3.076724425443019}}, 
                   0.06709388154952858], 
                  
                  ArrowBox[{{9.27169173155814, 2.127175568769304}, {
                   10.057066085236883`, 1.6018181609028996`}}, 
                   0.06709388154952858], 
                  
                  ArrowBox[{{10.057066085236883`, 1.6018181609028996`}, {
                   10.42367189997939, 1.160246671100385}}, 
                   0.06709388154952858], 
                  
                  ArrowBox[{{10.42367189997939, 1.160246671100385}, {
                   9.92643250367165, 1.4456390189991466`}}, 
                   0.06709388154952858], 
                  
                  ArrowBox[{{9.92643250367165, 1.4456390189991466`}, {
                   9.27169173155814, 2.127175568769304}}, 
                   0.06709388154952858], 
                  
                  ArrowBox[{{6.216785652668685, 3.2449336952385734`}, {
                   6.364678767806792, 2.307491305809486}}, 
                   0.06709388154952858], 
                  
                  ArrowBox[{{6.216785652668685, 3.2449336952385734`}, {
                   5.003646987915086, 2.3846962838822976`}}, 
                   0.06709388154952858], 
                  
                  ArrowBox[{{6.364678767806792, 2.307491305809486}, {
                   6.665171563193751, 1.8290257359789885`}}, 
                   0.06709388154952858], 
                  
                  ArrowBox[{{6.665171563193751, 1.8290257359789885`}, {
                   6.749012425099872, 2.447093654591712}}, 
                   0.06709388154952858], 
                  
                  ArrowBox[{{6.749012425099872, 2.447093654591712}, {
                   6.625893054086672, 3.4297952488389347`}}, 
                   0.06709388154952858], 
                  
                  ArrowBox[{{6.625893054086672, 3.4297952488389347`}, {
                   6.52871531338926, 4.680792661869821}}, 
                   0.06709388154952858], 
                  
                  ArrowBox[{{6.409657409413706, 6.079409219726441}, {
                   7.2424682828573665`, 6.032569519766121}}, 
                   0.06709388154952858], 
                  
                  ArrowBox[{{6.963981978428761, 4.276001409935179}, {
                   6.52871531338926, 4.680792661869821}}, 
                   0.06709388154952858], 
                  
                  ArrowBox[{{5.003646987915086, 2.3846962838822976`}, {
                   3.758580085028022, 1.855816382248089}}, 
                   0.06709388154952858], 
                  ArrowBox[
                   
                   BezierCurveBox[{{3.758580085028022, 1.855816382248089}, {
                    3.623025447219195, 2.2959297101004643`}, {
                    3.775166978546306, 2.7305879156551147`}}], 
                   0.06709388154952858], 
                  ArrowBox[
                   
                   BezierCurveBox[{{3.758580085028022, 1.855816382248089}, {
                    3.9107216163551324`, 2.290474587793731}, {
                    3.775166978546306, 2.7305879156551147`}}], 
                   0.06709388154952858], 
                  
                  ArrowBox[{{3.775166978546306, 2.7305879156551147`}, {
                   4.395460101070168, 2.795045715905718}}, 
                   0.06709388154952858], 
                  ArrowBox[
                   
                   BezierCurveBox[{{3.775166978546306, 2.7305879156551147`}, {
                    4.074268856629583, 3.6181313787554554`}, {
                    4.8417943224155655`, 4.154880847081267}}], 
                   0.06709388154952858], 
                  ArrowBox[
                   
                   BezierCurveBox[{{3.775166978546306, 2.7305879156551147`}, {
                    4.542692444332272, 3.2673373839783992`}, {
                    4.8417943224155655`, 4.154880847081267}}], 
                   0.06709388154952858], 
                  
                  ArrowBox[{{3.775166978546306, 2.7305879156551147`}, {
                   3.3161490341250306`, 2.1013566567852195`}}, 
                   0.06709388154952858], 
                  
                  ArrowBox[{{3.775166978546306, 2.7305879156551147`}, {
                   4.225675714722049, 1.4691650832188197`}}, 
                   0.06709388154952858], 
                  
                  ArrowBox[{{4.395460101070168, 2.795045715905718}, {
                   5.061390269263109, 3.3922770901229757`}}, 
                   0.06709388154952858], 
                  
                  ArrowBox[{{5.061390269263109, 3.3922770901229757`}, {
                   5.733831403287671, 4.270326719634406}}, 
                   0.06709388154952858], 
                  
                  ArrowBox[{{5.109942592811901, 4.712970377883095}, {
                   5.690493915169704, 4.584438939757817}}, 
                   0.06709388154952858], 
                  
                  ArrowBox[{{5.109942592811901, 4.712970377883095}, {
                   4.453626787323267, 3.8855798171172}}, 0.06709388154952858], 
                  
                  ArrowBox[{{5.690493915169704, 4.584438939757817}, {
                   6.52871531338926, 4.680792661869821}}, 
                   0.06709388154952858], 
                  
                  ArrowBox[{{4.8417943224155655`, 4.154880847081267}, {
                   5.792596146963917, 5.595709513281148}}, 
                   0.06709388154952858], 
                  
                  ArrowBox[{{4.8417943224155655`, 4.154880847081267}, {
                   4.192762557340956, 4.088626052281825}}, 
                   0.06709388154952858], 
                  
                  ArrowBox[{{4.8417943224155655`, 4.154880847081267}, {
                   4.125561903777494, 4.3035376935642775`}}, 
                   0.06709388154952858], 
                  
                  ArrowBox[{{4.8417943224155655`, 4.154880847081267}, {
                   4.090259126621749, 3.639616955478291}}, 
                   0.06709388154952858], 
                  
                  ArrowBox[{{4.192762557340956, 4.088626052281825}, {
                   4.125561903777494, 4.3035376935642775`}}, 
                   0.06709388154952858], 
                  
                  ArrowBox[{{4.125561903777494, 4.3035376935642775`}, {
                   5.733831403287671, 4.270326719634406}}, 
                   0.06709388154952858], 
                  
                  ArrowBox[{{4.125561903777494, 4.3035376935642775`}, {
                   2.50917794322678, 4.370075860317984}}, 
                   0.06709388154952858], 
                  
                  ArrowBox[{{4.440532520522792, 5.3801622961793}, {
                   3.3170435421504925`, 4.97663717870283}}, 
                   0.06709388154952858], 
                  
                  ArrowBox[{{3.3170435421504925`, 4.97663717870283}, {
                   2.50917794322678, 4.370075860317984}}, 
                   0.06709388154952858], 
                  
                  ArrowBox[{{2.50917794322678, 4.370075860317984}, {
                   1.434638629990979, 3.52059595227331}}, 
                   0.06709388154952858], 
                  
                  ArrowBox[{{2.50917794322678, 4.370075860317984}, {
                   1.3653224586846058`, 4.900678524486768}}, 
                   0.06709388154952858], 
                  
                  ArrowBox[{{1.434638629990979, 3.52059595227331}, {
                   0.6254698250933011, 2.6711830232713965`}}, 
                   0.06709388154952858], 
                  
                  ArrowBox[{{0.6254698250933011, 2.6711830232713965`}, {
                   0.15237107653347248`, 1.826314263648162}}, 
                   0.06709388154952858], 
                  
                  ArrowBox[{{0.15237107653347248`, 1.826314263648162}, {
                   0.16091742840985912`, 1.0454511064935912`}}, 
                   0.06709388154952858], 
                  
                  ArrowBox[{{0.16091742840985912`, 1.0454511064935912`}, {
                   0.7586502175475411, 0.6337015907455887}}, 
                   0.06709388154952858], 
                  
                  ArrowBox[{{0.7586502175475411, 0.6337015907455887}, {
                   1.6459348074402058`, 0.7089061451214675}}, 
                   0.06709388154952858], 
                  
                  ArrowBox[{{1.6459348074402058`, 0.7089061451214675}, {
                   2.658774408677256, 1.1336054147323709`}}, 
                   0.06709388154952858], 
                  
                  ArrowBox[{{2.658774408677256, 1.1336054147323709`}, {
                   3.758580085028022, 1.855816382248089}}, 
                   0.06709388154952858], 
                  
                  ArrowBox[{{1.3653224586846058`, 4.900678524486768}, {
                   0.4709752938450915, 5.509024547467219}}, 
                   0.06709388154952858], 
                  
                  ArrowBox[{{0.4709752938450915, 5.509024547467219}, {0., 
                   6.250941554600795}}, 0.06709388154952858], 
                  
                  ArrowBox[{{0., 6.250941554600795}, {0.18399721553772608`, 
                   6.997639624083163}}, 0.06709388154952858], 
                  
                  ArrowBox[{{0.18399721553772608`, 6.997639624083163}, {
                   0.9377246156032744, 7.447261661452538}}, 
                   0.06709388154952858], 
                  
                  ArrowBox[{{0.9377246156032744, 7.447261661452538}, {
                   0.7914133258034122, 8.337323308210841}}, 
                   0.06709388154952858], 
                  
                  ArrowBox[{{0.9377246156032744, 7.447261661452538}, {
                   0.354347806107957, 7.918200860512604}}, 
                   0.06709388154952858], 
                  
                  ArrowBox[{{0.9377246156032744, 7.447261661452538}, {
                   0.7711108831771822, 6.416707493838862}}, 
                   0.06709388154952858], 
                  
                  ArrowBox[{{0.7914133258034122, 8.337323308210841}, {
                   1.1244370282325686`, 8.953714358372414}}, 
                   0.06709388154952858], 
                  
                  ArrowBox[{{1.1244370282325686`, 8.953714358372414}, {
                   1.8823295141778336`, 8.959969673216353}}, 
                   0.06709388154952858], 
                  
                  ArrowBox[{{1.8823295141778336`, 8.959969673216353}, {
                   2.7402912281441685`, 8.501569388383661}}, 
                   0.06709388154952858], 
                  
                  ArrowBox[{{2.7402912281441685`, 8.501569388383661}, {
                   3.657426930489685, 7.735557513310497}}, 
                   0.06709388154952858], 
                  
                  ArrowBox[{{3.657426930489685, 7.735557513310497}, {
                   4.655593071009504, 6.734156008913222}}, 
                   0.06709388154952858], 
                  
                  ArrowBox[{{4.655593071009504, 6.734156008913222}, {
                   5.792596146963917, 5.595709513281148}}, 
                   0.06709388154952858], 
                  
                  ArrowBox[{{4.453626787323267, 3.8855798171172}, {
                   3.9400604913433535`, 3.1814016294962038`}}, 
                   0.06709388154952858], 
                  
                  ArrowBox[{{3.9400604913433535`, 3.1814016294962038`}, {
                   3.775166978546306, 2.7305879156551147`}}, 
                   0.06709388154952858], 
                  
                  ArrowBox[{{4.090259126621749, 3.639616955478291}, {
                   3.526386567993374, 3.5049464058961384`}}, 
                   0.06709388154952858], 
                  
                  ArrowBox[{{3.526386567993374, 3.5049464058961384`}, {
                   3.959632414685003, 3.830983348322878}}, 
                   0.06709388154952858], 
                  
                  ArrowBox[{{3.959632414685003, 3.830983348322878}, {
                   4.8417943224155655`, 4.154880847081267}}, 
                   0.06709388154952858], 
                  
                  ArrowBox[{{6.301953245558314, 6.19077350973878}, {
                   7.2424682828573665`, 6.032569519766121}}, 
                   0.06709388154952858], 
                  
                  ArrowBox[{{5.740053171637852, 6.601468329788948}, {
                   4.03915346784052, 7.09264256881027}}, 0.06709388154952858], 
                  
                  ArrowBox[{{4.03915346784052, 7.09264256881027}, {
                   2.4369263914801294`, 7.360038423573828}}, 
                   0.06709388154952858], 
                  
                  ArrowBox[{{2.4369263914801294`, 7.360038423573828}, {
                   0.9377246156032744, 7.447261661452538}}, 
                   0.06709388154952858], 
                  
                  ArrowBox[{{0.354347806107957, 7.918200860512604}, {
                   0.24071293518263204`, 7.734578829178509}}, 
                   0.06709388154952858], 
                  
                  ArrowBox[{{0.24071293518263204`, 7.734578829178509}, {
                   0.9377246156032744, 7.447261661452538}}, 
                   0.06709388154952858], 
                  
                  ArrowBox[{{0.7711108831771822, 6.416707493838862}, {
                   0.9928501447273907, 5.329833321505883}}, 
                   0.06709388154952858], 
                  
                  ArrowBox[{{0.9928501447273907, 5.329833321505883}, {
                   1.5935259191467486`, 4.294114157577752}}, 
                   0.06709388154952858], 
                  
                  ArrowBox[{{1.5935259191467486`, 4.294114157577752}, {
                   2.535622482436771, 3.4015464614673867`}}, 
                   0.06709388154952858], 
                  
                  ArrowBox[{{2.535622482436771, 3.4015464614673867`}, {
                   3.775166978546306, 2.7305879156551147`}}, 
                   0.06709388154952858], 
                  
                  ArrowBox[{{3.3161490341250306`, 2.1013566567852195`}, {
                   3.1634830896677855`, 2.2562464449840625`}}, 
                   0.06709388154952858], 
                  
                  ArrowBox[{{3.1634830896677855`, 2.2562464449840625`}, {
                   3.775166978546306, 2.7305879156551147`}}, 
                   0.06709388154952858], 
                  
                  ArrowBox[{{4.225675714722049, 1.4691650832188197`}, {
                   4.889021154120004, 0.5177535638605564}}, 
                   0.06709388154952858], 
                  
                  ArrowBox[{{4.889021154120004, 0.5177535638605564}, {
                   5.754671967053932, 0.}}, 0.06709388154952858], 
                  
                  ArrowBox[{{5.754671967053932, 0.}, {6.6916232164290435`, 
                   0.06894214896797468}}, 0.06709388154952858], 
                  
                  ArrowBox[{{6.6916232164290435`, 0.06894214896797468}, {
                   7.46557005847371, 0.7059102227198553}}, 
                   0.06709388154952858], 
                  
                  ArrowBox[{{7.46557005847371, 0.7059102227198553}, {
                   7.961848666882953, 1.7513799751447756`}}, 
                   0.06709388154952858], 
                  
                  ArrowBox[{{7.961848666882953, 1.7513799751447756`}, {
                   8.163839360665946, 3.076724425443019}}, 
                   0.06709388154952858], 
                  
                  ArrowBox[{{7.853162015719795, 4.505850126183707}, {
                   7.2424682828573665`, 6.032569519766121}}, 
                   0.06709388154952858], 
                  
                  ArrowBox[{{7.214220204055934, 7.009597093418636}, {
                   7.025608502028897, 7.374116436287009}}, 
                   0.06709388154952858], 
                  
                  ArrowBox[{{6.745727323839757, 7.804562931587747}, {
                   6.651705125831321, 6.9668323078873495`}}, 
                   0.06709388154952858], 
                  
                  ArrowBox[{{5.309603059821833, 5.45976459149585}, {
                   5.749264030702026, 5.0321625418720615`}}, 
                   0.06709388154952858], 
                  
                  ArrowBox[{{5.749264030702026, 5.0321625418720615`}, {
                   6.52871531338926, 4.680792661869821}}, 
                   0.06709388154952858], 
                  
                  ArrowBox[{{6.966028973571536, 5.3199607575271575`}, {
                   7.51352547870051, 5.854579982965166}}, 
                   0.06709388154952858], 
                  
                  ArrowBox[{{7.626334971332758, 6.419618767595251}, {
                   7.2424682828573665`, 6.032569519766121}}, 
                   0.06709388154952858], 
                  
                  ArrowBox[{{5.141449097824981, 6.515203355827623}, {
                   4.763497170502677, 7.248463927995084}}, 
                   0.06709388154952858]}}}, {{{
                  Hue[0.6, 0.2, 0.8], 
                  EdgeForm[{
                    GrayLevel[0], 
                    Opacity[0.7]}], {
                   
                   DiskBox[{6.341217765333148, 6.886662961688092}, 
                    0.06709388154952858], 
                   InsetBox["\"A\"", 
                    Offset[{2, 2}, {6.408311646882677, 6.9537568432376204`}], 
                    
                    ImageScaled[{0, 0}], BaseStyle -> "Graphics"]}, {
                   
                   DiskBox[{6.767459466344739, 6.0892340568547505`}, 
                    0.06709388154952858], 
                   InsetBox["\"computer\"", 
                    Offset[{2, 2}, {6.834553347894268, 6.156327938404279}], 
                    ImageScaled[{0, 0}], BaseStyle -> "Graphics"]}, {
                   
                   DiskBox[{7.160794872630211, 6.353686992564913}, 
                    0.06709388154952858], 
                   InsetBox["\"is\"", 
                    Offset[{2, 2}, {7.227888754179739, 6.420780874114441}], 
                    ImageScaled[{0, 0}], BaseStyle -> "Graphics"]}, {
                   
                   DiskBox[{7.51352547870051, 5.854579982965166}, 
                    0.06709388154952858], 
                   InsetBox["\"a\"", 
                    Offset[{2, 2}, {7.580619360250038, 5.921673864514695}], 
                    ImageScaled[{0, 0}], BaseStyle -> "Graphics"]}, {
                   
                   DiskBox[{8.646330223110617, 5.776805036111114}, 
                    0.06709388154952858], 
                   InsetBox["\"general-purpose\"", 
                    Offset[{2, 2}, {8.713424104660145, 5.843898917660642}], 
                    ImageScaled[{0, 0}], BaseStyle -> "Graphics"]}, {
                   
                   DiskBox[{9.259068711197596, 5.485305335558021}, 
                    0.06709388154952858], 
                   InsetBox["\"device\"", 
                    Offset[{2, 2}, {9.326162592747124, 5.552399217107549}], 
                    ImageScaled[{0, 0}], BaseStyle -> "Graphics"]}, {
                   
                   DiskBox[{8.580522147725036, 5.347339183971889}, 
                    0.06709388154952858], 
                   InsetBox["\"that\"", 
                    Offset[{2, 2}, {8.647616029274564, 5.4144330655214175`}], 
                    
                    ImageScaled[{0, 0}], BaseStyle -> "Graphics"]}, {
                   
                   DiskBox[{7.420136334138459, 5.305742090973326}, 
                    0.06709388154952858], 
                   InsetBox["\"can\"", 
                    Offset[{2, 2}, {7.487230215687988, 5.3728359725228545`}], 
                    
                    ImageScaled[{0, 0}], BaseStyle -> "Graphics"]}, {
                   
                   DiskBox[{7.308882271072699, 3.7684416198461594`}, 
                    0.06709388154952858], 
                   InsetBox["\"be\"", 
                    Offset[{2, 2}, {7.375976152622227, 3.835535501395688}], 
                    ImageScaled[{0, 0}], BaseStyle -> "Graphics"]}, {
                   
                   DiskBox[{7.830781777216217, 3.1011066717555527`}, 
                    0.06709388154952858], 
                   InsetBox["\"programmed\"", 
                    Offset[{2, 2}, {7.897875658765745, 3.1682005533050814`}], 
                    
                    ImageScaled[{0, 0}], BaseStyle -> "Graphics"]}, {
                   
                   DiskBox[{8.163839360665946, 3.076724425443019}, 
                    0.06709388154952858], 
                   InsetBox["\"to\"", 
                    Offset[{2, 2}, {8.230933242215475, 3.143818306992548}], 
                    ImageScaled[{0, 0}], BaseStyle -> "Graphics"]}, {
                   
                   DiskBox[{8.68657450574927, 3.949273561931784}, 
                    0.06709388154952858], 
                   InsetBox["\"carry\"", 
                    Offset[{2, 2}, {8.753668387298799, 4.016367443481313}], 
                    ImageScaled[{0, 0}], BaseStyle -> "Graphics"]}, {
                   
                   DiskBox[{8.512326272919319, 5.082896376383502}, 
                    0.06709388154952858], 
                   InsetBox["\"out\"", 
                    Offset[{2, 2}, {8.579420154468847, 5.14999025793303}], 
                    ImageScaled[{0, 0}], BaseStyle -> "Graphics"]}, {
                   
                   DiskBox[{7.883735126876614, 6.08699485557217}, 
                    0.06709388154952858], 
                   InsetBox["\"set\"", 
                    Offset[{2, 2}, {7.950829008426142, 6.154088737121699}], 
                    ImageScaled[{0, 0}], BaseStyle -> "Graphics"]}, {
                   
                   DiskBox[{7.2424682828573665`, 6.032569519766121}, 
                    0.06709388154952858], 
                   InsetBox["\"of\"", 
                    Offset[{2, 2}, {7.309562164406895, 6.09966340131565}], 
                    ImageScaled[{0, 0}], BaseStyle -> "Graphics"]}, {
                   
                   DiskBox[{7.67042109132925, 5.043338154962031}, 
                    0.06709388154952858], 
                   InsetBox["\"arithmetic\"", 
                    Offset[{2, 2}, {7.737514972878778, 5.110432036511559}], 
                    ImageScaled[{0, 0}], BaseStyle -> "Graphics"]}, {
                   
                   DiskBox[{8.293102583802245, 4.452774155752466}, 
                    0.06709388154952858], 
                   InsetBox["\"or\"", 
                    Offset[{2, 2}, {8.360196465351773, 4.519868037301994}], 
                    ImageScaled[{0, 0}], BaseStyle -> "Graphics"]}, {
                   
                   DiskBox[{7.807793839076568, 4.247404407400158}, 
                    0.06709388154952858], 
                   InsetBox["\"logical\"", 
                    Offset[{2, 2}, {7.874887720626097, 4.314498288949686}], 
                    ImageScaled[{0, 0}], BaseStyle -> "Graphics"]}, {
                   
                   DiskBox[{7.016610550498093, 4.763994099336369}, 
                    0.06709388154952858], 
                   InsetBox["\"operations\"", 
                    Offset[{2, 2}, {7.083704432047622, 4.831087980885897}], 
                    ImageScaled[{0, 0}], BaseStyle -> "Graphics"]}, {
                   
                   DiskBox[{7.913620916599047, 4.822218280398296}, 
                    0.06709388154952858], 
                   InsetBox["\"automatically\"", 
                    Offset[{2, 2}, {7.9807147981485755`, 4.889312161947824}], 
                    
                    ImageScaled[{0, 0}], BaseStyle -> "Graphics"]}, {
                   DiskBox[{8.169086999859772, 5.360057131761351}, 
                    0.06709388154952858], 
                   InsetBox["\"Since\"", 
                    Offset[{2, 2}, {8.2361808814093, 5.427151013310879}], 
                    ImageScaled[{0, 0}], BaseStyle -> "Graphics"]}, {
                   
                   DiskBox[{7.80102014074524, 6.286931140395776}, 
                    0.06709388154952858], 
                   InsetBox["\"sequence\"", 
                    Offset[{2, 2}, {7.868114022294768, 6.354025021945304}], 
                    ImageScaled[{0, 0}], BaseStyle -> "Graphics"]}, {
                   
                   DiskBox[{6.56814703340736, 3.9600994656483186`}, 
                    0.06709388154952858], 
                   InsetBox["\"readily\"", 
                    Offset[{2, 2}, {6.6352409149568885`, 4.027193347197847}], 
                    
                    ImageScaled[{0, 0}], BaseStyle -> "Graphics"]}, {
                   
                   DiskBox[{6.043366407184176, 4.696178292811545}, 
                    0.06709388154952858], 
                   InsetBox["\"changed\"", 
                    Offset[{2, 2}, {6.110460288733704, 4.763272174361074}], 
                    ImageScaled[{0, 0}], BaseStyle -> "Graphics"]}, {
                   
                   DiskBox[{5.792596146963917, 5.595709513281148}, 
                    0.06709388154952858], 
                   InsetBox["\"the\"", 
                    Offset[{2, 2}, {5.8596900285134454`, 5.662803394830676}], 
                    
                    ImageScaled[{0, 0}], BaseStyle -> "Graphics"]}, {
                   
                   DiskBox[{7.318061729407752, 6.503945853693873}, 
                    0.06709388154952858], 
                   InsetBox["\"solve\"", 
                    Offset[{2, 2}, {7.3851556109572805`, 6.571039735243401}], 
                    
                    ImageScaled[{0, 0}], BaseStyle -> "Graphics"]}, {
                   
                   DiskBox[{7.025608502028897, 7.374116436287009}, 
                    0.06709388154952858], 
                   InsetBox["\"more\"", 
                    Offset[{2, 2}, {7.092702383578425, 7.441210317836537}], 
                    ImageScaled[{0, 0}], BaseStyle -> "Graphics"]}, {
                   
                   DiskBox[{6.651705125831321, 6.9668323078873495`}, 
                    0.06709388154952858], 
                   InsetBox["\"than\"", 
                    Offset[{2, 2}, {6.7187990073808495`, 7.033926189436878}], 
                    
                    ImageScaled[{0, 0}], BaseStyle -> "Graphics"]}, {
                   
                   DiskBox[{7.754193904358154, 7.367406508639469}, 
                    0.06709388154952858], 
                   InsetBox["\"one\"", 
                    Offset[{2, 2}, {7.821287785907682, 7.434500390188997}], 
                    ImageScaled[{0, 0}], BaseStyle -> "Graphics"]}, {
                   
                   DiskBox[{7.558680136610801, 6.975019954842593}, 
                    0.06709388154952858], 
                   InsetBox["\"kind\"", 
                    Offset[{2, 2}, {7.625774018160329, 7.042113836392121}], 
                    ImageScaled[{0, 0}], BaseStyle -> "Graphics"]}, {
                   
                   DiskBox[{7.869719923329276, 6.691211524677881}, 
                    0.06709388154952858], 
                   InsetBox["\"problem\"", 
                    Offset[{2, 2}, {7.936813804878804, 6.758305406227409}], 
                    ImageScaled[{0, 0}], BaseStyle -> "Graphics"]}, {
                   
                   DiskBox[{8.146404866369867, 6.479017202758196}, 
                    0.06709388154952858], 
                   InsetBox["\"Conventionally\"", 
                    Offset[{2, 2}, {8.213498747919395, 6.546111084307724}], 
                    ImageScaled[{0, 0}], BaseStyle -> "Graphics"]}, {
                   
                   DiskBox[{6.89066939047105, 6.602735114316545}, 
                    0.06709388154952858], 
                   InsetBox["\"consists\"", 
                    Offset[{2, 2}, {6.957763272020578, 6.669828995866073}], 
                    ImageScaled[{0, 0}], BaseStyle -> "Graphics"]}, {
                   
                   DiskBox[{7.76659702933596, 7.157204821153302}, 
                    0.06709388154952858], 
                   InsetBox["\"at\"", 
                    Offset[{2, 2}, {7.833690910885489, 7.22429870270283}], 
                    ImageScaled[{0, 0}], BaseStyle -> "Graphics"]}, {
                   
                   DiskBox[{8.048602216684408, 7.89118519085174}, 
                    0.06709388154952858], 
                   InsetBox["\"least\"", 
                    Offset[{2, 2}, {8.115696098233936, 7.958279072401268}], 
                    ImageScaled[{0, 0}], BaseStyle -> "Graphics"]}, {
                   
                   DiskBox[{8.556967608199079, 6.686731262064674}, 
                    0.06709388154952858], 
                   InsetBox["\"processing\"", 
                    Offset[{2, 2}, {8.624061489748607, 6.753825143614202}], 
                    ImageScaled[{0, 0}], BaseStyle -> "Graphics"]}, {
                   
                   DiskBox[{9.28341008461209, 6.371646531468439}, 
                    0.06709388154952858], 
                   InsetBox["\"element\"", 
                    Offset[{2, 2}, {9.350503966161618, 6.4387404130179675`}], 
                    
                    ImageScaled[{0, 0}], BaseStyle -> "Graphics"]}, {
                   
                   DiskBox[{8.647073688100742, 6.191027161907364}, 
                    0.06709388154952858], 
                   InsetBox["\"typically\"", 
                    Offset[{2, 2}, {8.71416756965027, 6.258121043456892}], 
                    ImageScaled[{0, 0}], BaseStyle -> "Graphics"]}, {
                   
                   DiskBox[{8.38029970141519, 6.325975147000563}, 
                    0.06709388154952858], 
                   InsetBox["\"central\"", 
                    Offset[{2, 2}, {8.447393582964718, 6.393069028550092}], 
                    ImageScaled[{0, 0}], BaseStyle -> "Graphics"]}, {
                   
                   DiskBox[{7.950037121015367, 5.6300531079084}, 
                    0.06709388154952858], 
                   InsetBox["\"unit\"", 
                    Offset[{2, 2}, {8.017131002564895, 5.697146989457928}], 
                    ImageScaled[{0, 0}], BaseStyle -> "Graphics"]}, {
                   
                   DiskBox[{7.424466836623465, 4.908548004537416}, 
                    0.06709388154952858], 
                   InsetBox["\"CPU\"", 
                    Offset[{2, 2}, {7.491560718172994, 4.975641886086945}], 
                    ImageScaled[{0, 0}], BaseStyle -> "Graphics"]}, {
                   
                   DiskBox[{6.52871531338926, 4.680792661869821}, 
                    0.06709388154952858], 
                   InsetBox["\"and\"", 
                    Offset[{2, 2}, {6.595809194938789, 4.747886543419349}], 
                    ImageScaled[{0, 0}], BaseStyle -> "Graphics"]}, {
                   
                   DiskBox[{6.416921449899787, 5.19767518719537}, 
                    0.06709388154952858], 
                   InsetBox["\"some\"", 
                    Offset[{2, 2}, {6.484015331449315, 5.264769068744898}], 
                    ImageScaled[{0, 0}], BaseStyle -> "Graphics"]}, {
                   
                   DiskBox[{6.7591961101130655`, 5.7313139868657075`}, 
                    0.06709388154952858], 
                   InsetBox["\"form\"", 
                    Offset[{2, 2}, {6.826289991662594, 5.798407868415236}], 
                    ImageScaled[{0, 0}], BaseStyle -> "Graphics"]}, {
                   
                   DiskBox[{8.191139548780793, 6.876216100593336}, 
                    0.06709388154952858], 
                   InsetBox["\"memory\"", 
                    Offset[{2, 2}, {8.258233430330321, 6.943309982142864}], 
                    ImageScaled[{0, 0}], BaseStyle -> "Graphics"]}, {
                   
                   DiskBox[{8.867588133317325, 7.262783535810694}, 
                    0.06709388154952858], 
                   InsetBox["\"The\"", 
                    Offset[{2, 2}, {8.934682014866853, 7.329877417360223}], 
                    ImageScaled[{0, 0}], BaseStyle -> "Graphics"]}, {
                   
                   DiskBox[{9.387133428998192, 5.677794994496508}, 
                    0.06709388154952858], 
                   InsetBox["\"carries\"", 
                    Offset[{2, 2}, {9.45422731054772, 5.744888876046036}], 
                    ImageScaled[{0, 0}], BaseStyle -> "Graphics"]}, {
                   DiskBox[{6.730464549484481, 4.303569274382708}, 
                    0.06709388154952858], 
                   InsetBox["\"logic\"", 
                    Offset[{2, 2}, {6.797558431034009, 4.370663155932236}], 
                    ImageScaled[{0, 0}], BaseStyle -> "Graphics"]}, {
                   
                   DiskBox[{7.0957432385751735`, 5.196027276963674}, 
                    0.06709388154952858], 
                   InsetBox["\"sequencing\"", 
                    Offset[{2, 2}, {7.162837120124702, 5.2631211585132025`}], 
                    
                    ImageScaled[{0, 0}], BaseStyle -> "Graphics"]}, {
                   
                   DiskBox[{7.33420760573115, 5.053035435623441}, 
                    0.06709388154952858], 
                   InsetBox["\"control\"", 
                    Offset[{2, 2}, {7.401301487280678, 5.120129317172969}], 
                    ImageScaled[{0, 0}], BaseStyle -> "Graphics"]}, {
                   
                   DiskBox[{6.530173853935035, 5.484904487856812}, 
                    0.06709388154952858], 
                   InsetBox["\"change\"", 
                    Offset[{2, 2}, {6.5972677354845635`, 5.55199836940634}], 
                    ImageScaled[{0, 0}], BaseStyle -> "Graphics"]}, {
                   
                   DiskBox[{6.375249115392858, 5.922043327956353}, 
                    0.06709388154952858], 
                   InsetBox["\"order\"", 
                    Offset[{2, 2}, {6.442342996942386, 5.9891372095058815`}], 
                    
                    ImageScaled[{0, 0}], BaseStyle -> "Graphics"]}, {
                   
                   DiskBox[{5.733831403287671, 4.270326719634406}, 
                    0.06709388154952858], 
                   InsetBox["\"in\"", 
                    
                    Offset[{2, 2}, {5.8009252848371995`, 
                    4.3374206011839345`}], 
                    ImageScaled[{0, 0}], BaseStyle -> "Graphics"]}, {
                   
                   DiskBox[{6.950243254812751, 3.4859847857413895`}, 
                    0.06709388154952858], 
                   InsetBox["\"response\"", 
                    Offset[{2, 2}, {7.017337136362279, 3.5530786672909183`}], 
                    
                    ImageScaled[{0, 0}], BaseStyle -> "Graphics"]}, {
                   
                   DiskBox[{8.860654470126681, 2.4530282980082876`}, 
                    0.06709388154952858], 
                   InsetBox["\"stored\"", 
                    Offset[{2, 2}, {8.92774835167621, 2.5201221795578164`}], 
                    ImageScaled[{0, 0}], BaseStyle -> "Graphics"]}, {
                   
                   DiskBox[{9.27169173155814, 2.127175568769304}, 
                    0.06709388154952858], 
                   InsetBox["\"information\"", 
                    Offset[{2, 2}, {9.33878561310767, 2.1942694503188327`}], 
                    ImageScaled[{0, 0}], BaseStyle -> "Graphics"]}, {
                   
                   DiskBox[{10.057066085236883`, 1.6018181609028996`}, 
                    0.06709388154952858], 
                   InsetBox["\"Peripheral\"", 
                    
                    Offset[{2, 2}, {10.124159966786412`, 
                    1.6689120424524282`}], 
                    ImageScaled[{0, 0}], BaseStyle -> "Graphics"]}, {
                   
                   DiskBox[{10.42367189997939, 1.160246671100385}, 
                    0.06709388154952858], 
                   InsetBox["\"devices\"", 
                    
                    Offset[{2, 2}, {10.490765781528918`, 
                    1.2273405526499135`}], 
                    ImageScaled[{0, 0}], BaseStyle -> "Graphics"]}, {
                   
                   DiskBox[{9.92643250367165, 1.4456390189991466`}, 
                    0.06709388154952858], 
                   InsetBox["\"allow\"", 
                    Offset[{2, 2}, {9.993526385221179, 1.5127329005486752`}], 
                    
                    ImageScaled[{0, 0}], BaseStyle -> "Graphics"]}, {
                   
                   DiskBox[{6.216785652668685, 3.2449336952385734`}, 
                    0.06709388154952858], 
                   InsetBox["\"retrieved\"", 
                    Offset[{2, 2}, {6.283879534218213, 3.3120275767881022`}], 
                    
                    ImageScaled[{0, 0}], BaseStyle -> "Graphics"]}, {
                   
                   DiskBox[{6.364678767806792, 2.307491305809486}, 
                    0.06709388154952858], 
                   InsetBox["\"from\"", 
                    Offset[{2, 2}, {6.43177264935632, 2.3745851873590147`}], 
                    ImageScaled[{0, 0}], BaseStyle -> "Graphics"]}, {
                   
                   DiskBox[{6.665171563193751, 1.8290257359789885`}, 
                    0.06709388154952858], 
                   InsetBox["\"an\"", 
                    Offset[{2, 2}, {6.7322654447432795`, 1.896119617528517}], 
                    
                    ImageScaled[{0, 0}], BaseStyle -> "Graphics"]}, {
                   
                   DiskBox[{6.749012425099872, 2.447093654591712}, 
                    0.06709388154952858], 
                   InsetBox["\"external\"", 
                    Offset[{2, 2}, {6.8161063066494005`, 2.514187536141241}], 
                    
                    ImageScaled[{0, 0}], BaseStyle -> "Graphics"]}, {
                   
                   DiskBox[{6.625893054086672, 3.4297952488389347`}, 
                    0.06709388154952858], 
                   InsetBox["\"source\"", 
                    Offset[{2, 2}, {6.6929869356362, 3.4968891303884635`}], 
                    ImageScaled[{0, 0}], BaseStyle -> "Graphics"]}, {
                   
                   DiskBox[{6.409657409413706, 6.079409219726441}, 
                    0.06709388154952858], 
                   InsetBox["\"result\"", 
                    Offset[{2, 2}, {6.476751290963234, 6.146503101275969}], 
                    ImageScaled[{0, 0}], BaseStyle -> "Graphics"]}, {
                   
                   DiskBox[{6.963981978428761, 4.276001409935179}, 
                    0.06709388154952858], 
                   InsetBox["\"saved\"", 
                    Offset[{2, 2}, {7.031075859978289, 4.343095291484707}], 
                    ImageScaled[{0, 0}], BaseStyle -> "Graphics"]}, {
                   
                   DiskBox[{5.003646987915086, 2.3846962838822976`}, 
                    0.06709388154952858], 
                   InsetBox["\"Mechanical\"", 
                    Offset[{2, 2}, {5.070740869464615, 2.4517901654318264`}], 
                    
                    ImageScaled[{0, 0}], BaseStyle -> "Graphics"]}, {
                   DiskBox[{3.758580085028022, 1.855816382248089}, 
                    0.06709388154952858], 
                   InsetBox["\"analog\"", 
                    Offset[{2, 2}, {3.825673966577551, 1.9229102637976176`}], 
                    
                    ImageScaled[{0, 0}], BaseStyle -> "Graphics"]}, {
                   
                   DiskBox[{3.775166978546306, 2.7305879156551147`}, 
                    0.06709388154952858], 
                   InsetBox["\"computers\"", 
                    
                    Offset[{2, 2}, {3.8422608600958346`, 
                    2.7976817972046435`}], 
                    ImageScaled[{0, 0}], BaseStyle -> "Graphics"]}, {
                   
                   DiskBox[{4.395460101070168, 2.795045715905718}, 
                    0.06709388154952858], 
                   InsetBox["\"started\"", 
                    
                    Offset[{2, 2}, {4.4625539826196965`, 
                    2.8621395974552466`}], 
                    ImageScaled[{0, 0}], BaseStyle -> "Graphics"]}, {
                   
                   DiskBox[{5.061390269263109, 3.3922770901229757`}, 
                    0.06709388154952858], 
                   InsetBox["\"appearing\"", 
                    Offset[{2, 2}, {5.128484150812637, 3.4593709716725045`}], 
                    
                    ImageScaled[{0, 0}], BaseStyle -> "Graphics"]}, {
                   
                   DiskBox[{5.109942592811901, 4.712970377883095}, 
                    0.06709388154952858], 
                   InsetBox["\"first\"", 
                    Offset[{2, 2}, {5.177036474361429, 4.780064259432623}], 
                    ImageScaled[{0, 0}], BaseStyle -> "Graphics"]}, {
                   
                   DiskBox[{5.690493915169704, 4.584438939757817}, 
                    0.06709388154952858], 
                   InsetBox["\"century\"", 
                    Offset[{2, 2}, {5.757587796719232, 4.651532821307345}], 
                    ImageScaled[{0, 0}], BaseStyle -> "Graphics"]}, {
                   
                   DiskBox[{4.8417943224155655`, 4.154880847081267}, 
                    0.06709388154952858], 
                   InsetBox["\"were\"", 
                    Offset[{2, 2}, {4.908888203965094, 4.221974728630795}], 
                    ImageScaled[{0, 0}], BaseStyle -> "Graphics"]}, {
                   
                   DiskBox[{4.192762557340956, 4.088626052281825}, 
                    0.06709388154952858], 
                   InsetBox["\"later\"", 
                    Offset[{2, 2}, {4.259856438890484, 4.155719933831353}], 
                    ImageScaled[{0, 0}], BaseStyle -> "Graphics"]}, {
                   
                   DiskBox[{4.125561903777494, 4.3035376935642775`}, 
                    0.06709388154952858], 
                   InsetBox["\"used\"", 
                    Offset[{2, 2}, {4.192655785327022, 4.370631575113806}], 
                    ImageScaled[{0, 0}], BaseStyle -> "Graphics"]}, {
                   
                   DiskBox[{4.440532520522792, 5.3801622961793}, 
                    0.06709388154952858], 
                   InsetBox["\"medieval\"", 
                    Offset[{2, 2}, {4.5076264020723205`, 5.447256177728828}], 
                    
                    ImageScaled[{0, 0}], BaseStyle -> "Graphics"]}, {
                   
                   DiskBox[{3.3170435421504925`, 4.97663717870283}, 
                    0.06709388154952858], 
                   InsetBox["\"era\"", 
                    Offset[{2, 2}, {3.3841374237000212`, 5.043731060252358}], 
                    
                    ImageScaled[{0, 0}], BaseStyle -> "Graphics"]}, {
                   
                   DiskBox[{2.50917794322678, 4.370075860317984}, 
                    0.06709388154952858], 
                   InsetBox["\"for\"", 
                    Offset[{2, 2}, {2.576271824776309, 4.437169741867512}], 
                    ImageScaled[{0, 0}], BaseStyle -> "Graphics"]}, {
                   
                   DiskBox[{1.434638629990979, 3.52059595227331}, 
                    0.06709388154952858], 
                   InsetBox["\"astronomical\"", 
                    Offset[{2, 2}, {1.5017325115405076`, 3.587689833822839}], 
                    
                    ImageScaled[{0, 0}], BaseStyle -> "Graphics"]}, {
                   
                   DiskBox[{0.6254698250933011, 2.6711830232713965`}, 
                    0.06709388154952858], 
                   InsetBox["\"calculations\"", 
                    Offset[{2, 2}, {0.6925637066428296, 2.7382769048209252`}], 
                    ImageScaled[{0, 0}], BaseStyle -> "Graphics"]}, {
                   
                   DiskBox[{0.15237107653347248`, 1.826314263648162}, 
                    0.06709388154952858], 
                   InsetBox["\"In\"", 
                    
                    Offset[{2, 2}, {0.21946495808300107`, 
                    1.8934081451976905`}], 
                    ImageScaled[{0, 0}], BaseStyle -> "Graphics"]}, {
                   
                   DiskBox[{0.16091742840985912`, 1.0454511064935912`}, 
                    0.06709388154952858], 
                   InsetBox["\"World\"", 
                    Offset[{2, 2}, {0.2280113099593877, 1.1125449880431197`}], 
                    ImageScaled[{0, 0}], BaseStyle -> "Graphics"]}, {
                   
                   DiskBox[{0.7586502175475411, 0.6337015907455887}, 
                    0.06709388154952858], 
                   InsetBox["\"War\"", 
                    Offset[{2, 2}, {0.8257440990970697, 0.7007954722951173}], 
                    
                    ImageScaled[{0, 0}], BaseStyle -> "Graphics"]}, {
                   
                   DiskBox[{1.6459348074402058`, 0.7089061451214675}, 
                    0.06709388154952858], 
                   InsetBox["\"II\"", 
                    Offset[{2, 2}, {1.7130286889897344`, 0.7760000266709961}], 
                    ImageScaled[{0, 0}], BaseStyle -> "Graphics"]}, {
                   
                   DiskBox[{2.658774408677256, 1.1336054147323709`}, 
                    0.06709388154952858], 
                   InsetBox["\"mechanical\"", 
                    
                    Offset[{2, 2}, {2.7258682902267846`, 
                    1.2006992962818994`}], 
                    ImageScaled[{0, 0}], BaseStyle -> "Graphics"]}, {
                   
                   DiskBox[{1.3653224586846058`, 4.900678524486768}, 
                    0.06709388154952858], 
                   InsetBox["\"specialized\"", 
                    Offset[{2, 2}, {1.4324163402341343`, 4.967772406036296}], 
                    
                    ImageScaled[{0, 0}], BaseStyle -> "Graphics"]}, {
                   DiskBox[{0.4709752938450915, 5.509024547467219}, 
                    0.06709388154952858], 
                   InsetBox["\"military\"", 
                    Offset[{2, 2}, {0.5380691753946201, 5.576118429016748}], 
                    ImageScaled[{0, 0}], BaseStyle -> "Graphics"]}, {
                   DiskBox[{0., 6.250941554600795}, 0.06709388154952858], 
                   InsetBox["\"applications\"", 
                    Offset[{2, 2}, {0.06709388154952858, 6.318035436150323}], 
                    
                    ImageScaled[{0, 0}], BaseStyle -> "Graphics"]}, {
                   
                   DiskBox[{0.18399721553772608`, 6.997639624083163}, 
                    0.06709388154952858], 
                   InsetBox["\"such\"", 
                    Offset[{2, 2}, {0.25109109708725463`, 7.064733505632692}], 
                    ImageScaled[{0, 0}], BaseStyle -> "Graphics"]}, {
                   
                   DiskBox[{0.9377246156032744, 7.447261661452538}, 
                    0.06709388154952858], 
                   InsetBox["\"as\"", 
                    Offset[{2, 2}, {1.004818497152803, 7.5143555430020665`}], 
                    
                    ImageScaled[{0, 0}], BaseStyle -> "Graphics"]}, {
                   
                   DiskBox[{0.7914133258034122, 8.337323308210841}, 
                    0.06709388154952858], 
                   InsetBox["\"calculating\"", 
                    Offset[{2, 2}, {0.8585072073529407, 8.40441718976037}], 
                    ImageScaled[{0, 0}], BaseStyle -> "Graphics"]}, {
                   
                   DiskBox[{1.1244370282325686`, 8.953714358372414}, 
                    0.06709388154952858], 
                   InsetBox["\"torpedo\"", 
                    Offset[{2, 2}, {1.1915309097820972`, 9.020808239921942}], 
                    
                    ImageScaled[{0, 0}], BaseStyle -> "Graphics"]}, {
                   
                   DiskBox[{1.8823295141778336`, 8.959969673216353}, 
                    0.06709388154952858], 
                   InsetBox["\"aiming\"", 
                    Offset[{2, 2}, {1.9494233957273621`, 9.027063554765881}], 
                    
                    ImageScaled[{0, 0}], BaseStyle -> "Graphics"]}, {
                   
                   DiskBox[{2.7402912281441685`, 8.501569388383661}, 
                    0.06709388154952858], 
                   InsetBox["\"During\"", 
                    Offset[{2, 2}, {2.8073851096936973`, 8.56866326993319}], 
                    ImageScaled[{0, 0}], BaseStyle -> "Graphics"]}, {
                   
                   DiskBox[{3.657426930489685, 7.735557513310497}, 
                    0.06709388154952858], 
                   InsetBox["\"this\"", 
                    Offset[{2, 2}, {3.7245208120392137`, 7.802651394860026}], 
                    
                    ImageScaled[{0, 0}], BaseStyle -> "Graphics"]}, {
                   
                   DiskBox[{4.655593071009504, 6.734156008913222}, 
                    0.06709388154952858], 
                   InsetBox["\"time\"", 
                    Offset[{2, 2}, {4.722686952559032, 6.80124989046275}], 
                    ImageScaled[{0, 0}], BaseStyle -> "Graphics"]}, {
                   
                   DiskBox[{4.453626787323267, 3.8855798171172}, 
                    0.06709388154952858], 
                   InsetBox["\"electronic\"", 
                    Offset[{2, 2}, {4.520720668872795, 3.952673698666729}], 
                    ImageScaled[{0, 0}], BaseStyle -> "Graphics"]}, {
                   
                   DiskBox[{3.9400604913433535`, 3.1814016294962038`}, 
                    0.06709388154952858], 
                   InsetBox["\"digital\"", 
                    Offset[{2, 2}, {4.007154372892882, 3.2484955110457325`}], 
                    
                    ImageScaled[{0, 0}], BaseStyle -> "Graphics"]}, {
                   
                   DiskBox[{4.090259126621749, 3.639616955478291}, 
                    0.06709388154952858], 
                   InsetBox["\"developed\"", 
                    
                    Offset[{2, 2}, {4.1573530081712775`, 
                    3.7067108370278197`}], 
                    ImageScaled[{0, 0}], BaseStyle -> "Graphics"]}, {
                   
                   DiskBox[{3.526386567993374, 3.5049464058961384`}, 
                    0.06709388154952858], 
                   InsetBox["\"Originally\"", 
                    Offset[{2, 2}, {3.593480449542903, 3.572040287445667}], 
                    ImageScaled[{0, 0}], BaseStyle -> "Graphics"]}, {
                   
                   DiskBox[{3.959632414685003, 3.830983348322878}, 
                    0.06709388154952858], 
                   InsetBox["\"they\"", 
                    Offset[{2, 2}, {4.026726296234531, 3.8980772298724067`}], 
                    
                    ImageScaled[{0, 0}], BaseStyle -> "Graphics"]}, {
                   
                   DiskBox[{6.301953245558314, 6.19077350973878}, 
                    0.06709388154952858], 
                   InsetBox["\"size\"", 
                    Offset[{2, 2}, {6.369047127107843, 6.2578673912883085`}], 
                    
                    ImageScaled[{0, 0}], BaseStyle -> "Graphics"]}, {
                   
                   DiskBox[{5.740053171637852, 6.601468329788948}, 
                    0.06709388154952858], 
                   InsetBox["\"large\"", 
                    Offset[{2, 2}, {5.80714705318738, 6.668562211338476}], 
                    ImageScaled[{0, 0}], BaseStyle -> "Graphics"]}, {
                   
                   DiskBox[{4.03915346784052, 7.09264256881027}, 
                    0.06709388154952858], 
                   InsetBox["\"room\"", 
                    Offset[{2, 2}, {4.106247349390048, 7.159736450359798}], 
                    ImageScaled[{0, 0}], BaseStyle -> "Graphics"]}, {
                   
                   DiskBox[{2.4369263914801294`, 7.360038423573828}, 
                    0.06709388154952858], 
                   InsetBox["\"consuming\"", 
                    Offset[{2, 2}, {2.504020273029658, 7.427132305123356}], 
                    ImageScaled[{0, 0}], BaseStyle -> "Graphics"]}, {
                   
                   DiskBox[{0.354347806107957, 7.918200860512604}, 
                    0.06709388154952858], 
                   InsetBox["\"much\"", 
                    Offset[{2, 2}, {0.4214416876574856, 7.985294742062132}], 
                    ImageScaled[{0, 0}], BaseStyle -> "Graphics"]}, {
                   DiskBox[{0.24071293518263204`, 7.734578829178509}, 
                    0.06709388154952858], 
                   InsetBox["\"power\"", 
                    Offset[{2, 2}, {0.3078068167321606, 7.801672710728037}], 
                    ImageScaled[{0, 0}], BaseStyle -> "Graphics"]}, {
                   
                   DiskBox[{0.7711108831771822, 6.416707493838862}, 
                    0.06709388154952858], 
                   InsetBox["\"several\"", 
                    Offset[{2, 2}, {0.8382047647267108, 6.48380137538839}], 
                    ImageScaled[{0, 0}], BaseStyle -> "Graphics"]}, {
                   
                   DiskBox[{0.9928501447273907, 5.329833321505883}, 
                    0.06709388154952858], 
                   InsetBox["\"hundred\"", 
                    Offset[{2, 2}, {1.0599440262769193`, 5.396927203055411}], 
                    
                    ImageScaled[{0, 0}], BaseStyle -> "Graphics"]}, {
                   
                   DiskBox[{1.5935259191467486`, 4.294114157577752}, 
                    0.06709388154952858], 
                   InsetBox["\"modern\"", 
                    
                    Offset[{2, 2}, {1.6606198006962771`, 
                    4.3612080391272805`}], 
                    ImageScaled[{0, 0}], BaseStyle -> "Graphics"]}, {
                   
                   DiskBox[{2.535622482436771, 3.4015464614673867`}, 
                    0.06709388154952858], 
                   InsetBox["\"personal\"", 
                    Offset[{2, 2}, {2.6027163639863, 3.4686403430169155`}], 
                    ImageScaled[{0, 0}], BaseStyle -> "Graphics"]}, {
                   
                   DiskBox[{3.3161490341250306`, 2.1013566567852195`}, 
                    0.06709388154952858], 
                   InsetBox["\"PCs\"", 
                    
                    Offset[{2, 2}, {3.3832429156745594`, 
                    2.1684505383347483`}], 
                    ImageScaled[{0, 0}], BaseStyle -> "Graphics"]}, {
                   
                   DiskBox[{3.1634830896677855`, 2.2562464449840625`}, 
                    0.06709388154952858], 
                   InsetBox["\"Modern\"", 
                    
                    Offset[{2, 2}, {3.2305769712173142`, 
                    2.3233403265335912`}], 
                    ImageScaled[{0, 0}], BaseStyle -> "Graphics"]}, {
                   
                   DiskBox[{4.225675714722049, 1.4691650832188197`}, 
                    0.06709388154952858], 
                   InsetBox["\"based\"", 
                    Offset[{2, 2}, {4.292769596271578, 1.5362589647683482`}], 
                    
                    ImageScaled[{0, 0}], BaseStyle -> "Graphics"]}, {
                   
                   DiskBox[{4.889021154120004, 0.5177535638605564}, 
                    0.06709388154952858], 
                   InsetBox["\"on\"", 
                    Offset[{2, 2}, {4.956115035669533, 0.5848474454100849}], 
                    ImageScaled[{0, 0}], BaseStyle -> "Graphics"]}, {
                   DiskBox[{5.754671967053932, 0.}, 0.06709388154952858], 
                   InsetBox["\"integrated\"", 
                    
                    Offset[{2, 2}, {5.8217658486034605`, 
                    0.06709388154952858}], 
                    ImageScaled[{0, 0}], BaseStyle -> "Graphics"]}, {
                   
                   DiskBox[{6.6916232164290435`, 0.06894214896797468}, 
                    0.06709388154952858], 
                   InsetBox["\"circuits\"", 
                    Offset[{2, 2}, {6.758717097978572, 0.13603603051750326`}], 
                    ImageScaled[{0, 0}], BaseStyle -> "Graphics"]}, {
                   
                   DiskBox[{7.46557005847371, 0.7059102227198553}, 
                    0.06709388154952858], 
                   InsetBox["\"are\"", 
                    Offset[{2, 2}, {7.532663940023238, 0.7730041042693838}], 
                    ImageScaled[{0, 0}], BaseStyle -> "Graphics"]}, {
                   
                   DiskBox[{7.961848666882953, 1.7513799751447756`}, 
                    0.06709388154952858], 
                   InsetBox["\"millions\"", 
                    Offset[{2, 2}, {8.028942548432482, 1.8184738566943042`}], 
                    
                    ImageScaled[{0, 0}], BaseStyle -> "Graphics"]}, {
                   
                   DiskBox[{7.853162015719795, 4.505850126183707}, 
                    0.06709388154952858], 
                   InsetBox["\"billions\"", 
                    Offset[{2, 2}, {7.920255897269324, 4.572944007733235}], 
                    ImageScaled[{0, 0}], BaseStyle -> "Graphics"]}, {
                   
                   DiskBox[{7.214220204055934, 7.009597093418636}, 
                    0.06709388154952858], 
                   InsetBox["\"times\"", 
                    Offset[{2, 2}, {7.281314085605462, 7.076690974968164}], 
                    ImageScaled[{0, 0}], BaseStyle -> "Graphics"]}, {
                   
                   DiskBox[{6.745727323839757, 7.804562931587747}, 
                    0.06709388154952858], 
                   InsetBox["\"capable\"", 
                    Offset[{2, 2}, {6.812821205389286, 7.8716568131372755`}], 
                    
                    ImageScaled[{0, 0}], BaseStyle -> "Graphics"]}, {
                   
                   DiskBox[{5.309603059821833, 5.45976459149585}, 
                    0.06709388154952858], 
                   InsetBox["\"early\"", 
                    Offset[{2, 2}, {5.376696941371361, 5.526858473045379}], 
                    ImageScaled[{0, 0}], BaseStyle -> "Graphics"]}, {
                   
                   DiskBox[{5.749264030702026, 5.0321625418720615`}, 
                    0.06709388154952858], 
                   InsetBox["\"machines\"", 
                    Offset[{2, 2}, {5.816357912251554, 5.09925642342159}], 
                    ImageScaled[{0, 0}], BaseStyle -> "Graphics"]}, {
                   
                   DiskBox[{6.966028973571536, 5.3199607575271575`}, 
                    0.06709388154952858], 
                   InsetBox["\"occupy\"", 
                    Offset[{2, 2}, {7.033122855121064, 5.387054639076686}], 
                    ImageScaled[{0, 0}], BaseStyle -> "Graphics"]}, {
                   
                   DiskBox[{7.626334971332758, 6.419618767595251}, 
                    0.06709388154952858], 
                   InsetBox["\"fraction\"", 
                    
                    Offset[{2, 2}, {7.6934288528822865`, 
                    6.4867126491447795`}], 
                    ImageScaled[{0, 0}], BaseStyle -> "Graphics"]}, {
                   DiskBox[{5.141449097824981, 6.515203355827623}, 
                    0.06709388154952858], 
                   InsetBox["\"space\"", 
                    Offset[{2, 2}, {5.208542979374509, 6.582297237377151}], 
                    ImageScaled[{0, 0}], BaseStyle -> "Graphics"]}, {
                   
                   DiskBox[{4.763497170502677, 7.248463927995084}, 
                    0.06709388154952858], 
                   InsetBox["\"Computers\"", 
                    Offset[{2, 2}, {4.830591052052205, 7.315557809544613}], 
                    ImageScaled[{0, 0}], BaseStyle -> "Graphics"]}}}}}], 
             MouseAppearanceTag["NetworkGraphics"]], 
            AllowKernelInitialization -> False]], 
          DefaultBaseStyle -> {
           "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> 
            Hue[0.8, 1., 0.6]}, FormatType -> TraditionalForm, FrameTicks -> 
          None, GridLinesStyle -> Directive[
            GrayLevel[0.5, 0.4]], ImageSize -> {560.48828125, Automatic}]], 
        "ExerciseOutput", Selectable -> False, Copyable -> False, Editable -> 
        False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"1dd05c22-52c1-48b4-92e7-829c3e3d8372"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Find a simpler form for ",
 Cell[BoxData[
  RowBox[{"f", 
   ButtonBox["@@",
    BaseStyle->"Link",
    ButtonData->"Apply"], 
   ButtonBox["#",
    BaseStyle->"Link",
    ButtonData->"Slot"], 
   ButtonBox["&",
    BaseStyle->"Link",
    ButtonData->"Function"], 
   ButtonBox["/@",
    BaseStyle->"Link",
    ButtonData->"Map"], 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"7", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "4"}], "}"}]}], "}"}]}]], "InlineCode",ExpressionUUID->
  "ad9239bd-0521-4b46-b8a3-b302a4a484ed"],
 ".",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "33.8", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"160fb30b-6cbf-4e4d-a29c-0eea1ce4d336"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Sample", " ", "expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       RowBox[{"{", 
        RowBox[{
         RowBox[{"f", "[", 
          RowBox[{"1", ",", "2"}], "]"}], ",", 
         RowBox[{"f", "[", 
          RowBox[{"7", ",", "2"}], "]"}], ",", 
         RowBox[{"f", "[", 
          RowBox[{"5", ",", "4"}], "]"}]}], "}"}]], "ExerciseOutput",
       ExpressionUUID->"2c630548-66c4-4459-9b9b-6976523b4dcd"],
      Apply[TextCell, 
       Cell[
        BoxData[
         RowBox[{"{", 
           RowBox[{
             RowBox[{"f", "[", 
               RowBox[{"1", ",", "2"}], "]"}], ",", 
             RowBox[{"f", "[", 
               RowBox[{"7", ",", "2"}], "]"}], ",", 
             RowBox[{"f", "[", 
               RowBox[{"5", ",", "4"}], "]"}]}], "}"}]], "ExerciseOutput", 
        Selectable -> False, Copyable -> False, Editable -> False, 
        ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"978c1d85-9f9e-40bc-9c2e-0e80f3463670"]
}, Closed]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Q&A", "QASection",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"aa624005-cb96-4a0c-a4bd-c1b42fab81af"],

Cell[TextData[{
 "How are ",
 Cell[BoxData[
  ButtonBox["@@",
   BaseStyle->"Link",
   ButtonData->"Apply"]], "InlineCode",ExpressionUUID->
  "4c3cae97-df2f-47de-8974-29f076f9032c"],
 " and ",
 Cell[BoxData[
  ButtonBox["@@@",
   BaseStyle->"Link",
   ButtonData->"Apply"]], "InlineCode",ExpressionUUID->
  "5a2f85c3-f315-495a-859e-c0acc6177c2e"],
 " interpreted?"
}], "Question",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"f756dcda-a456-4442-9847-a2bbb27f81d4"],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   StyleBox["f", "CodeVariable"], 
   ButtonBox["@@",
    BaseStyle->"Link",
    ButtonData->"Apply"], 
   StyleBox["expr", "CodeVariable"]}]], "InlineCode",ExpressionUUID->
  "8ce163fc-e33d-45b1-a714-5b623a8f5adc"],
 " is ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Apply",
    BaseStyle->"CodeLink"], "[", 
   RowBox[{
    StyleBox["f", "CodeVariable"], ",", 
    StyleBox["expr", "CodeVariable"]}], "]"}]], "InlineCode",ExpressionUUID->
  "d3a473b8-d624-448b-b612-197bf8e8d259"],
 ". ",
 Cell[BoxData[
  RowBox[{
   StyleBox["f", "CodeVariable"], 
   ButtonBox["@@@",
    BaseStyle->"Link",
    ButtonData->"Apply"], 
   StyleBox["expr", "CodeVariable"]}]], "InlineCode",ExpressionUUID->
  "23a23a38-2ee9-448c-93b3-4b321a678c61"],
 " is ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Apply",
    BaseStyle->"CodeLink"], "[", 
   RowBox[{
    StyleBox["f", "CodeVariable"], ",", 
    StyleBox["expr", "CodeVariable"], ",", 
    RowBox[{"{", "1", "}"}]}], "]"}]], "InlineCode",ExpressionUUID->
  "0a67c969-8a33-4b2b-adda-46793ec31e4b"],
 ". They\[CloseCurlyQuote]re usually just read as \
\[OpenCurlyDoubleQuote]double at\[CloseCurlyDoubleQuote] and \
\[OpenCurlyDoubleQuote]triple at\[CloseCurlyDoubleQuote]."
}], "Answer",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:19",ExpressionUUID->"2da8b326-7bf3-4003-a619-d914e176f6bb"],

Cell["Are all expressions in the Wolfram Language trees?", "Question",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:20",ExpressionUUID->"ff718707-7128-48f2-967a-5867c934e0f3"],

Cell[TextData[{
 "At a structural level, yes. When there are variables with values assigned \
(see ",
 ButtonBox["Section 38",
  BaseStyle->"Hyperlink",
  ButtonData->{"EIWL2-38-assigning-names-to-things.nb", None}],
 "), though, they can behave more like directed graphs. And of course one can \
use ",
 ButtonBox["Graph",
  BaseStyle->"Link"],
 " to represent any graph as an expression in the Wolfram Language."
}], "Answer",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"e12412fc-9e3b-45d9-9272-d304c18a28b2"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Tech Notes", "TechNoteSection",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"d60dabd9-770c-4da3-965a-1fcd0256a420"],

Cell["\<\
The basic concept of symbolic languages comes directly from work in \
mathematical logic stretching back to the 1930s and before, but other than in \
the Wolfram Language it\[CloseCurlyQuote]s been very rare for it to be \
implemented in practice.\
\>", "TechNote",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:21",ExpressionUUID->"fca8f384-9e73-4f90-9c26-360e86f4f1f3"],

Cell["\<\
Wolfram Language expressions are a bit like XML expressions (and can be \
converted to and from them). But unlike XML expressions, Wolfram Language \
expressions can evaluate so that they automatically change their structure.\
\>", "TechNote",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:22",ExpressionUUID->"d10592aa-9736-45fc-93d8-9f53d6f069ba"],

Cell[TextData[{
 "Things like ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Select",
    BaseStyle->"CodeLink"], "[", 
   StyleBox["f", "CodeVariable"], "]"}]], "InlineCode",ExpressionUUID->
  "ec4583b5-adaa-4141-8407-e07bf4ed67b0"],
 " that are set up to be applied to expressions are called ",
 StyleBox["operator forms",
  FontSlant->"Italic"],
 ", by analogy with operators in mathematics. Using ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Select",
     BaseStyle->"CodeLink"], "[", 
    StyleBox["f", "CodeVariable"], "]"}], "[", 
   StyleBox["expr", "CodeVariable"], "]"}]], "InlineCode",ExpressionUUID->
  "9e872f83-8b33-42d9-b09c-59ed61cbbafc"],
 " instead of ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Select",
    BaseStyle->"CodeLink"], "[", 
   RowBox[{
    StyleBox["expr", "CodeVariable"], ",", 
    StyleBox["f", "CodeVariable"]}], "]"}]], "InlineCode",ExpressionUUID->
  "39fc24da-87f1-4b60-b590-1ec4a5d7d0cc"],
 " is often called ",
 StyleBox["currying",
  FontSlant->"Italic"],
 ", after a logician named Haskell Curry. "
}], "TechNote",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 LineSpacing->{1.15, 1., 2.},
 CellTags->"i:23",ExpressionUUID->"d402833a-cf95-47d0-8abc-6d7745f30034"],

Cell[TextData[{
 "Symbols like ",
 Cell[BoxData[
 "x"], "InlineCode",ExpressionUUID->"2e0a425b-4ae3-48bb-9637-6fedf205a56e"],
 " can be used to represent algebraic variables or \
\[OpenCurlyDoubleQuote]unknowns\[CloseCurlyDoubleQuote]. This is central to \
doing many kinds of mathematics in the Wolfram Language."
}], "TechNote",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:24",ExpressionUUID->"90e0a523-b5e5-4020-b186-e39af5cb65c0"],

Cell[TextData[{
 ButtonBox["LeafCount",
  BaseStyle->"Link"],
 " gives the total number of atoms at the leaves of an expression tree. ",
 ButtonBox["ByteCount",
  BaseStyle->"Link"],
 " gives the number of bytes needed to store the expression."
}], "TechNote",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:25",ExpressionUUID->"d1fac484-9568-4581-bfa0-eb8de1318298"]
}, Open  ]],

Cell[CellGroupData[{

Cell["More to Explore", "MoreExploreSection",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"7856c5d0-878d-4b78-8e3f-75f7750ad242"],

Cell[TextData[ButtonBox["Guide to Expressions in the Wolfram Language\
\[NonBreakingSpace]\[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Expressions"]], "MoreExplore",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->
  "LastCellOfAPage",ExpressionUUID->"f131d714-f5ce-4e18-80c5-c00601345817"]
}, Open  ]]
},
Saveable->False,
WindowToolbars->{},
BlinkingCellInsertionPoint->False,
CellInsertionPointCell->None,
WindowSize->{830, 800},
WindowMargins->Automatic,
WindowPersistentStyles->{
 WindowFrame, WindowMargins, WindowSize, Magnification},
WindowTitle->"Expressions and Their Structure: Elementary Introduction to the \
Wolfram Language",
DockedCells->{
  Cell[
   BoxData[
    TagBox[
     GridBox[{{
        TemplateBox[{
         "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]", 
          "\"\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\"", 
          GraphicsBox[
           TagBox[
            RasterBox[CompressedData["
1:eJztl01IVFEUxyctMFzUysjIyUDCTauiIJFM6ENpM4NEtJrBUaSYZMYPhCRm
rYuoICgiW0VEBVIUEbTNEMTAIqRsk6JGCVFBHx7//+4JLo/36DqvB4Ie+Mk7
7+t3733nHpzq9NlEW0ksFsuX4U8i1duQy6X6kpuRtGTzHe3ZTOuxbFemPZPb
ny7FyZ2gEqwHInICfJToguOIReywPVHHlYDzcY4hJHZ486giyBOXtfms5Pms
Bs9zUBDTow6DJOgBT8DP/+B5CepAPbgqZm+zT70Bt9VXCx6H8DwE28Gw5ufB
IT2eA1N6PKquC0V4xtUxqfkE6ARD4BHYAx5Y938Gu8GdZXq4VsNWngIfwDzY
Aa6Bm55nOKYq8NXRw29eb+Uz4JSVd4Nn4IbPs2fARUdPQcfLWAQJ8Mq6Tkdd
gGcEHHT0sHYn9Jg1dcnnnhf6vnee8xzXVkcP9wdr97eY7z0NnlrX74qpxffg
iOZ2VDp6kvqOe6AVXAb7xNQB462YNfsCfoBzoE1MzTEqHD096mgE98WsEec4
Jqamvvk8cx2kwWuw19HDXnIAbNAx03ka9IO8mO+3ScyebRZTi01i1rqguHjY
r3aJWaugOA5O6vEC+K6ebWDW0cNgv6oBnwKus87KwKDmv8BRMOBz77/6G/sV
e8lkwHWuTwm4pQ7WzGIRHgb7FXsJ9/mI5z2si42gXMw8/ByuHgb7FXsJ9yX3
IPfHFjF1xTl5v0exnrCx5gnn+fu7JC7h/z/0Y52+P+rfWX9iCXVYErg=
             "], {{0,
              34}, {26, 0}}, {0, 255}, ColorFunction -> RGBColor], 
            BoxForm`ImageTag[
            "Byte", ColorSpace -> "RGB", Interleaving -> True, Magnification -> 
             1], Selectable -> False], DefaultBaseStyle -> "ImageGraphics", 
           ImageSize -> Magnification[1], ImageSizeRaw -> {26, 34}, 
           PlotRange -> {{0, 26}, {0, 34}}], 
          GraphicsBox[
           TagBox[
            RasterBox[CompressedData["
1:eJztXUuS47gRLX8WXtYRaJ+gl17SS+8U4/CeM+H2hDdtRY8jHF6ZR9AReATt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             "], {{0, 34}, {383, 0}}, {0, 255}, 
             ColorFunction -> RGBColor], 
            BoxForm`ImageTag[
            "Byte", ColorSpace -> "RGB", Interleaving -> True, Magnification -> 
             1], Selectable -> False], DefaultBaseStyle -> "ImageGraphics", 
           ImageSize -> Magnification[1], ImageSizeRaw -> {383, 34}, 
           PlotRange -> {{0, 383}, {0, 34}}]}, "RowWithSeparators"], 
        PaneBox[
         StyleBox["\[VeryThinSpace]", ShowStringCharacters -> False], 
         Alignment -> Right, ImageSize -> {174, 47}], 
        PaneBox[
         PaneBox[
          TemplateBox[{"\[ThinSpace]", "\" \"", 
            TagBox[
             TooltipBox[
              PaneSelectorBox[{False -> ButtonBox[
                  PaneBox[
                   GraphicsBox[
                    TagBox[
                    RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UJAPiDmBmIUBO/j//z8jEDcA8W8g3oBFnhmIZ/9HgE9o8mxAvBZJ/hsQuyPJ
8wPxfiT5N0BsjiQvCsTnkOSfALEWkrwSEN9Bkr8OxDJobniAJP8ZZCYWfxCj
RpGQXcS4mVi/ExuGxMYFmlp4nAIAG14fWQ==
                    "], {{0, 14}, {9, 
                    0}}, {0, 255}, ColorFunction -> RGBColor], 
                    BoxForm`ImageTag[
                    "Byte", ColorSpace -> "RGB", Interleaving -> True], 
                    Selectable -> False], DefaultBaseStyle -> "ImageGraphics",
                     ImageSizeRaw -> {9, 14}, PlotRange -> {{0, 9}, {0, 14}}, 
                    ImageSize -> Magnification[1]], ImageSize -> {35, 30}, 
                   Alignment -> Center], 
                  ButtonFunction :> (
                   NotebookLocate[{"EIWL2-32-patterns.nb", ""}, 
                    FrontEnd`HistoryData :> {
                    EvaluationNotebook[]}]& ), Enabled -> True, Appearance -> 
                  None, Evaluator -> Automatic, Method -> "Preemptive"], True -> 
                ButtonBox[
                  PaneBox[
                   GraphicsBox[
                    TagBox[
                    RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UJAPiDmBmIUBO/j//z8jEDcA8W8g3oBFnhmIZ/9HgE9o8mxAvBZJ/hsQuyPJ
8wPxfiT5N0BsjiQvCsTnkOSfALEWkrwSEN9Bkr8OxDJobniAJP8ZZCYWfxCj
RpGQXcS4mVi/ExuGxMYFmlp4nAIAG14fWQ==
                    "], {{0, 14}, {9, 
                    0}}, {0, 255}, ColorFunction -> RGBColor], 
                    BoxForm`ImageTag[
                    "Byte", ColorSpace -> "RGB", Interleaving -> True], 
                    Selectable -> False], DefaultBaseStyle -> "ImageGraphics",
                     ImageSizeRaw -> {9, 14}, PlotRange -> {{0, 9}, {0, 14}}, 
                    ImageSize -> Magnification[1]], ImageSize -> {35, 30}, 
                   Alignment -> Center], 
                  ButtonFunction :> (
                   NotebookLocate[{"EIWL2-32-patterns.nb", ""}, 
                    FrontEnd`HistoryData :> {
                    EvaluationNotebook[]}]& ), Enabled -> True, Appearance -> 
                  None, Background -> RGBColor[0.835294, 0.364706, 0.0196078],
                   Evaluator -> Automatic, Method -> "Preemptive"]}, 
               Dynamic[
                CurrentValue["MouseOver"]], ImageSize -> Automatic, 
               FrameMargins -> 0], "\"Patterns\"", TooltipDelay -> 0.15, 
              LabelStyle -> "TextStyling"], 
             Annotation[#, "Patterns", "Tooltip"]& ], 
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {5, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[5], Selectable -> False], 
            TagBox[
             TooltipBox[
              PaneSelectorBox[{False -> ButtonBox[
                  PaneBox[
                   GraphicsBox[
                    TagBox[
                    RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UJAfiDmBmAWI////vwKIfwFxMQMOAJT7+R8B6nGoSf+PCjpwqMskUl0SEP9F
UtcHxIxY1EWjqZuOQ10Mmr2TcNj7BEnNP1LNIeQeIDsZn78IhQ8x4fwfNb4a
cPgTFu8l2ORBAAC+1hnm
                    "], {{0, 15}, {9, 0}}, {0, 255}, 
                    ColorFunction -> RGBColor], 
                    BoxForm`ImageTag[
                    "Byte", ColorSpace -> "RGB", Interleaving -> True], 
                    Selectable -> False], DefaultBaseStyle -> "ImageGraphics",
                     ImageSizeRaw -> {9, 15}, PlotRange -> {{0, 9}, {0, 15}}, 
                    ImageSize -> Magnification[1]], ImageSize -> {35, 30}, 
                   Alignment -> Center], 
                  ButtonFunction :> (
                   NotebookLocate[{"EIWL2-34-associations.nb", ""}, 
                    FrontEnd`HistoryData :> {
                    EvaluationNotebook[]}]& ), Appearance -> None, Evaluator -> 
                  Automatic, Method -> "Preemptive"], True -> ButtonBox[
                  PaneBox[
                   GraphicsBox[
                    TagBox[
                    RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UJAfiDmBmAWI////vwKIfwFxMQMOAJT7+R8B6nGoSf+PCjpwqMskUl0SEP9F
UtcHxIxY1EWjqZuOQ10Mmr2TcNj7BEnNP1LNIeQeIDsZn78IhQ8x4fwfNb4a
cPgTFu8l2ORBAAC+1hnm
                    "], {{0, 15}, {9, 0}}, {0, 255}, 
                    ColorFunction -> RGBColor], 
                    BoxForm`ImageTag[
                    "Byte", ColorSpace -> "RGB", Interleaving -> True], 
                    Selectable -> False], DefaultBaseStyle -> "ImageGraphics",
                     ImageSizeRaw -> {9, 15}, PlotRange -> {{0, 9}, {0, 15}}, 
                    ImageSize -> Magnification[1]], ImageSize -> {35, 30}, 
                   Alignment -> Center], 
                  ButtonFunction :> (
                   NotebookLocate[{"EIWL2-34-associations.nb", ""}, 
                    FrontEnd`HistoryData :> {
                    EvaluationNotebook[]}]& ), Appearance -> None, Background -> 
                  RGBColor[0.835294, 0.364706, 0.0196078], Evaluator -> 
                  Automatic, Method -> "Preemptive"]}, 
               Dynamic[
                CurrentValue["MouseOver"]], ImageSize -> Automatic, 
               FrameMargins -> 0], "\"Associations\"", TooltipDelay -> 0.15, 
              LabelStyle -> "TextStyling"], 
             Annotation[#, "Associations", "Tooltip"]& ]}, 
           "RowWithSeparators"], Alignment -> Right], ImageSize -> {100, 30}, 
         FrameMargins -> {{0, 6}, {0, 0}}, Alignment -> Right], 
        ActionMenuBox[
         PaneSelectorBox[{True -> PanelBox[
             GraphicsBox[
              TagBox[
               RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UBAkIQ3ELED8////Jf/pA0D2/KWTXSB7ZtPBPrA9DKOAYgAMR1Eg9gPiABpi
P6g912mcLmAAZM9XOtkFsicKiNcD8QYaYpD5UQOdXoYD+E/HMooO9iDbR7c6
BQDxtyEt
                "], {{0, 16}, {27, 0}}, {0, 255}, ColorFunction -> 
                RGBColor], 
               BoxForm`ImageTag[
               "Byte", ColorSpace -> "RGB", Interleaving -> True, 
                Magnification -> 1], Selectable -> False], DefaultBaseStyle -> 
              "ImageGraphics", ImageSize -> Magnification[1], 
              ImageSizeRaw -> {27, 16}, PlotRange -> {{0, 27}, {0, 16}}], 
             Appearance -> None, Background -> 
             RGBColor[0.835294, 0.364706, 0.0196078], ImageSize -> {35, 30}, 
             Alignment -> Center], False -> PanelBox[
             GraphicsBox[
              TagBox[
               RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UBAkIQ3ELED8////Jf/pA0D2/KWTXSB7ZtPBPrA9DKOAYgAMR1Eg9gPiABpi
P6g912mcLmAAZM9XOtkFsicKiNcD8QYaYpD5UQOdXoYD+E/HMooO9iDbR7c6
BQDxtyEt
                "], {{0, 16}, {27, 0}}, {0, 255}, ColorFunction -> 
                RGBColor], 
               BoxForm`ImageTag[
               "Byte", ColorSpace -> "RGB", Interleaving -> True, 
                Magnification -> 1], Selectable -> False], DefaultBaseStyle -> 
              "ImageGraphics", ImageSize -> Magnification[1], 
              ImageSizeRaw -> {27, 16}, PlotRange -> {{0, 27}, {0, 16}}], 
             Appearance -> None, Background -> 
             RGBColor[0.952941, 0.509804, 0], ImageSize -> {35, 30}, 
             Alignment -> Center]}, 
          Dynamic[
           CurrentValue["MouseOver"]]], {
         "Preface" :> 
          NotebookLocate[{"EIWL2-0a-preface.nb", ""}, FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], "What Is the Wolfram Language?" :> 
          NotebookLocate[{"EIWL2-0b-what-is-the-wolfram-language.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "Practicalities of Using the Wolfram Language" :> 
          NotebookLocate[{
            "EIWL2-0c-practicalities-of-using-the-wolfram-language.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], "Other Resources" :> 
          NotebookLocate[{"EIWL2-0d-other-resources.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]1\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]Starting Out: Elementary Arithmetic" :> 
          NotebookLocate[{
            "EIWL2-01-starting-out-elementary-arithmetic.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]2\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]Introducing Functions" :> 
          NotebookLocate[{"EIWL2-02-introducing-functions.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]3\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]First Look at Lists" :> 
          NotebookLocate[{"EIWL2-03-first-look-at-lists.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]4\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]Displaying Lists" :> 
          NotebookLocate[{"EIWL2-04-displaying-lists.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]5\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]Operations on Lists" :> 
          NotebookLocate[{"EIWL2-05-operations-on-lists.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]6\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]Making Tables" :> 
          NotebookLocate[{"EIWL2-06-making-tables.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]7\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]Colors and Styles" :> 
          NotebookLocate[{"EIWL2-07-colors-and-styles.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]8\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]Basic Graphics Objects" :> 
          NotebookLocate[{"EIWL2-08-basic-graphics-objects.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]9\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]Interactive Manipulation" :> 
          NotebookLocate[{"EIWL2-09-interactive-manipulation.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "10\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Images" :> 
          NotebookLocate[{"EIWL2-10-images.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "11\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Strings and \
Text" :> NotebookLocate[{"EIWL2-11-strings-and-text.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "12\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Sound" :> 
          NotebookLocate[{"EIWL2-12-sound.nb", ""}, FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          
          "13\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Arrays, or \
Lists of Lists" :> 
          NotebookLocate[{"EIWL2-13-arrays-or-lists-of-lists.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "14\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Coordinates \
and Graphics" :> 
          NotebookLocate[{"EIWL2-14-coordinates-and-graphics.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "15\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]The Scope \
of the Wolfram Language" :> 
          NotebookLocate[{
            "EIWL2-15-the-scope-of-the-wolfram-language.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "16\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Real\
\[Hyphen]World Data" :> 
          NotebookLocate[{"EIWL2-16-real-world-data.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "17\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Units" :> 
          NotebookLocate[{"EIWL2-17-units.nb", ""}, FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "18\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
Geocomputation" :> 
          NotebookLocate[{"EIWL2-18-geocomputation.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "19\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Dates and \
Times" :> NotebookLocate[{"EIWL2-19-dates-and-times.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "20\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Options" :> 
          NotebookLocate[{"EIWL2-20-options.nb", ""}, FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "21\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Graphs and \
Networks" :> 
          NotebookLocate[{"EIWL2-21-graphs-and-networks.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "22\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Machine \
Learning" :> NotebookLocate[{"EIWL2-22-machine-learning.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "23\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]More about \
Numbers" :> NotebookLocate[{"EIWL2-23-more-about-numbers.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "24\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]More Forms \
of Visualization" :> 
          NotebookLocate[{"EIWL2-24-more-forms-of-visualization.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "25\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Ways to \
Apply Functions" :> 
          NotebookLocate[{"EIWL2-25-ways-to-apply-functions.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "26\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Pure \
Anonymous Functions" :> 
          NotebookLocate[{"EIWL2-26-pure-anonymous-functions.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "27\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Applying \
Functions Repeatedly" :> 
          NotebookLocate[{"EIWL2-27-applying-functions-repeatedly.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "28\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Tests and \
Conditionals" :> 
          NotebookLocate[{"EIWL2-28-tests-and-conditionals.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "29\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]More about \
Pure Functions" :> 
          NotebookLocate[{"EIWL2-29-more-about-pure-functions.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "30\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Rearranging \
Lists" :> NotebookLocate[{"EIWL2-30-rearranging-lists.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "31\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Parts of \
Lists" :> NotebookLocate[{"EIWL2-31-parts-of-lists.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "32\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Patterns" :> 
          NotebookLocate[{"EIWL2-32-patterns.nb", ""}, FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "33\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Expressions \
and Their Structure" :> 
          NotebookLocate[{"EIWL2-33-expressions-and-their-structure.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "34\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
Associations" :> 
          NotebookLocate[{"EIWL2-34-associations.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "35\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Natural \
Language Understanding" :> 
          NotebookLocate[{"EIWL2-35-natural-language-understanding.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "36\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Creating \
Websites and Apps" :> 
          NotebookLocate[{"EIWL2-36-creating-websites-and-apps.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "37\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Layout and \
Display" :> NotebookLocate[{"EIWL2-37-layout-and-display.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "38\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Assigning \
Names to Things" :> 
          NotebookLocate[{"EIWL2-38-assigning-names-to-things.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "39\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Immediate \
and Delayed Values" :> 
          NotebookLocate[{"EIWL2-39-immediate-and-delayed-values.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "40\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Defining \
Your Own Functions" :> 
          NotebookLocate[{"EIWL2-40-defining-your-own-functions.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "41\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]More about \
Patterns" :> 
          NotebookLocate[{"EIWL2-41-more-about-patterns.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "42\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]String \
Patterns and Templates " :> 
          NotebookLocate[{"EIWL2-42-string-patterns-and-templates.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "43\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Storing \
Things" :> NotebookLocate[{"EIWL2-43-storing-things.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "44\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Importing \
and Exporting" :> 
          NotebookLocate[{"EIWL2-44-importing-and-exporting.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "45\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Datasets" :> 
          NotebookLocate[{"EIWL2-45-datasets.nb", ""}, FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "46\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Writing \
Good Code" :> 
          NotebookLocate[{"EIWL2-46-writing-good-code.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "47\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Debugging \
Your Code" :> 
          NotebookLocate[{"EIWL2-47-debugging-your-code.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "What We Haven\[CloseCurlyQuote]t Discussed" :> 
          NotebookLocate[{"EIWL2-what-we-havent-discussed.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], "Afterword: Being a Programmer" :> 
          NotebookLocate[{"EIWL2-being-a-programmer.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], "Answers to Exercises" :> 
          NotebookLocate[{"EIWL2-answers-to-exercises.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], "Index" :> 
          NotebookLocate[{"EIWL2-book-index.nb", ""}, FrontEnd`HistoryData :> {
              EvaluationNotebook[]}]}, Appearance -> None]}}, 
      GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Center}}}, 
      GridBoxItemSize -> {
       "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], "Grid"]], 
   "Text", ShowCellBracket -> False, CellFrame -> {{0, 0}, {3, 0}}, 
   Selectable -> False, CellFrameColor -> 
   RGBColor[0.835294, 0.364706, 0.0196078], CellMargins -> {{0, 0}, {0, -1}}, 
   CellFrameMargins -> {{27, 0}, {1, 7}}, Background -> 
   RGBColor[0.952941, 0.509804, 0], CellTags -> "DockedCellLogoCell"], 
  Cell["SECOND EDITION", "Text", FontFamily -> "Source Sans Pro", 
   CellFrame -> {{0, 0}, {3, 0}}, ShowCellBracket -> False, 
   CellMargins -> {{0, 0}, {-1, -1}}, CellFrameMargins -> {{66, 0}, {2, 4}}, 
   CellFrameColor -> RGBColor[0.952941, 0.509804, 0], FontSize -> 10, 
   FontTracking -> "Extended", FontColor -> RGBColor[1, 0.929412, 0.721569], 
   Background -> RGBColor[0.862745, 0.309804, 0], CellTags -> 
   "DockedCellLogoCell"]},
PrintingStartingPageNumber->278,
PageHeaders->{{
   Cell[
    TextData[{
      StyleBox[
       CounterBox["Page"], "PageNumber"], 
      StyleBox[
      "    An Elementary Introduction to the Wolfram Language", "Header"]}], 
    "Header", CellMargins -> {{37, Inherited}, {Inherited, Inherited}}], None,
    None}, {None, None, 
   Cell[
    TextData[{
      StyleBox[
       CounterBox["Section"], "Header"], 
      StyleBox[
      " | Expressions and Their Structure \[LongDash] wolfr.am/eiwl-", 
       "Header"], 
      StyleBox[
       CounterBox["Section"], "Header"], 
      StyleBox["    ", "Header"], 
      StyleBox[
       CounterBox["Page"], "PageNumber"]}], "Header", 
    CellMargins -> {{Inherited, 17}, {Inherited, Inherited}}]}},
PrintingOptions->{"FirstPageHeader"->True},
PrivateNotebookOptions->{"PluginToolbarEnabled"->False},
ShowCellBracket->Automatic,
ShowAutoSpellCheck->False,
ShowPredictiveInterface->False,
ShowSyntaxStyles->False,
Magnification->1.,
FrontEndVersion->"12.3 for Mac OS X x86 (64-bit) (July 30, 2021)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[StyleDefinitions -> "Default.nb"]], 
   Cell[
    CellGroupData[{
      Cell[
      "Style Environments", "Section", 
       CellChangeTimes -> {{3.64661165091824*^9, 3.646611654013329*^9}, 
         3.6485723794335403`*^9, 3.651347081728628*^9, 3.651347179462186*^9, 
         3.651347384135805*^9, 3.651348171662589*^9}], 
      Cell[
       StyleData[All, "Working"], CellInsertionPointCell -> 
       FEPrivate`FrontEndResource["FEExpressions", "CellInsertionMenu"], 
       CreateCellID -> True, $CellContext`GhostCellInEmptyNotebook -> False], 
      
      Cell[
       StyleData[All, "Printout"], 
       PrintingOptions -> {
        "PageSize" -> {504, 720}, "PrintRegistrationMarks" -> True}, 
       Magnification -> 0.6]}, Closed]], 
   Cell[
    CellGroupData[{
      Cell["Styles for Headers and Footers", "Section"], 
      Cell[
       StyleData["Header"], StyleMenuListing -> None, FontFamily -> "Verdana",
        FontSize -> 7, FontSlant -> "Plain", FontColor -> GrayLevel[0.6]], 
      Cell[
       StyleData["PageNumber"], CellMargins -> {{0, 0}, {4, 1}}, 
       StyleMenuListing -> None, FontFamily -> "Verdana", FontSize -> 7, 
       FontWeight -> "Bold", FontSlant -> "Plain", FontColor -> 
       GrayLevel[0]]}, Closed]], 
   Cell[
    CellGroupData[{
      Cell[
      "WPL Specific", "Section", 
       CellChangeTimes -> {{3.6556608433734913`*^9, 3.6556608489412746`*^9}}], 
      Cell[
       StyleData["Link"], FontFamily -> "Source Sans Pro", FontSize :> 
       If[CurrentValue[
           EvaluationCell[], "FontFamily"] === "Source Sans Pro", Inherited, 
         If[CurrentValue[
            EvaluationCell[], "FontFamily"] === "WolframCodeSans", Inherited, 
          Inherited 0.9]], FontColor -> GrayLevel[0]], 
      Cell[
       StyleData["CodeLink"], 
       ButtonBoxOptions -> {
        Appearance -> None, ButtonFunction :> (FEPrivate`FrontEndExecute[
           FrontEndToken["OpenHelpLink", {
             Part[#, 1], Null}]]& ), ButtonSource -> ButtonContents, 
         Evaluator -> None, Method -> "Preemptive"}]}, Closed]], 
   Cell[
    CellGroupData[{
      Cell[
      "Custom Styles", "Section", 
       CellChangeTimes -> {{3.646611660445352*^9, 3.646611669493331*^9}}], 
      Cell[
       StyleData["Notebook"], PageWidth :> 700, 
       PrintingOptions -> {
        "InnerOuterMargins" -> {35, 16}, "PaperOrientation" -> "Portrait", 
         "PaperSize" -> {504, 720}, 
         "PrintingMargins" -> {{20, 20}, {54, 54}}}, CellLabelAutoDelete -> 
       False, ShowSyntaxStyles -> True, 
       AutoStyleOptions -> {
        "FormattingErrorTooltips" -> False, "HighlightComments" -> False, 
         "HighlightEmphasizedSyntaxErrors" -> False, 
         "HighlightExcessArguments" -> False, "HighlightFormattingErrors" -> 
         False, "HighlightGlobalToLocalScopeConflicts" -> False, 
         "HighlightGraphicsCompatibilityProblems" -> False, 
         "HighlightLocalScopeConflicts" -> False, "HighlightMissingArguments" -> 
         False, "HighlightNoKernelPresent" -> False, 
         "HighlightOrderOfEvaluationConflicts" -> False, "HighlightStrings" -> 
         True, "HighlightSymbolContexts" -> False, "HighlightSymbolShadowing" -> 
         False, "HighlightSyntaxErrors" -> False, "HighlightUndefinedSymbols" -> 
         False, "HighlightUnknownOptions" -> False, 
         "HighlightUnwantedAssignments" -> False}, MenuSortingValue -> None, 
       GraphicsBoxOptions -> {ImageSize -> 240}, 
       Graphics3DBoxOptions -> {ImageSize -> 240}], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Title"], CellMargins -> {{64, Inherited}, {50, 72}}, 
          MenuCommandKey :> None, FontFamily -> "Verdana", FontSize -> 42, 
          FontWeight -> "Bold", FontColor -> GrayLevel[0.4]], 
         Cell[
          StyleData["Title", "Printout"], 
          CellMargins -> {{64, Inherited}, {50, 72}}]}, Closed]], 
      Cell[
       StyleData["Chapter"], MenuCommandKey :> None], 
      Cell[
       StyleData["Subchapter"], MenuCommandKey :> None], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Section"], CellFrame -> {{0, 0}, {0, 0}}, CellDingbat -> 
          Cell[
            TextData[
             CounterBox["Section"], 
             StyleBox[
             "|\[NegativeThinSpace]", FontColor -> 
              RGBColor[
               0.9019607843137255, 0.4117647058823529, 0.027450980392156862`],
               FontFamily -> "Courier", FontSize -> 36, FontWeight -> Plain]],
             "SectionNumber"], CellMargins -> {{96, Inherited}, {12, 44}}, 
          Evaluatable -> True, CellGroupingRules -> {"SectionGrouping", 60}, 
          PageBreakAbove -> True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["Section", "Printout"], 
          CellMargins -> {{96, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionDoubleDigit"], CellFrame -> {{0, 0}, {0, 0}}, 
          CellDingbat -> Cell[
            TextData[
             CounterBox["Section"], 
             StyleBox[
             "|\[NegativeThinSpace]", FontColor -> 
              RGBColor[
               0.9019607843137255, 0.4117647058823529, 0.027450980392156862`],
               FontFamily -> "Courier", FontSize -> 36, FontWeight -> Plain]],
             "SectionNumber"], CellMargins -> {{112, Inherited}, {12, 44}}, 
          Evaluatable -> True, CellGroupingRules -> {"SectionGrouping", 60}, 
          PageBreakAbove -> True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["SectionDoubleDigit", "Printout"], 
          CellMargins -> {{112, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionNumber"], CellBaseline -> Baseline, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 26, FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SectionNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionInline"], FontFamily -> 
          "Source Sans Pro Semibold", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SectionInline", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionNoDingbat"], 
          CellMargins -> {{64, Inherited}, {12, 44}}, Evaluatable -> True, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakAbove -> 
          True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["SectionNoDingbat", "Printout"], 
          CellMargins -> {{64, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       StyleData["AnswerKeyNumberedSection"], 
       CellMargins -> {{64, Inherited}, {8, 28}}, Evaluatable -> True, 
       CellGroupingRules -> {"SectionGrouping", 60}, PageBreakAbove -> True, 
       ShowCellLabel -> False, 
       CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
       CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
       CounterIncrements -> "Section", 
       CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
         "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", FontSize -> 
       18, FontSlant -> "Plain", FontColor -> 
       RGBColor[
        0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
       InterpretationBoxOptions -> {Editable -> True}], 
      Cell[
       StyleData["AnswerKeySectionNumber"], CellBaseline -> Baseline, 
       FontFamily -> "Source Sans Pro Semibold", FontSize -> 18, FontColor -> 
       RGBColor[
        0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
      Cell[
       StyleData["IndexLinkGuide"], 
       CellMargins -> {{64, Inherited}, {48, 28}}, Evaluatable -> True, 
       CellGroupingRules -> {"SectionGrouping", 60}, PageBreakAbove -> True, 
       ShowCellLabel -> False, 
       CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
       CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
       CounterIncrements -> "Section", 
       CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
         "Exercise", 0}}, FontFamily -> "Source Sans Pro", FontSize -> 14, 
       FontSlant -> "Plain", FontColor -> 
       RGBColor[
        0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
       InterpretationBoxOptions -> {Editable -> True}], 
      Cell[
       StyleData["Index"], MenuSortingValue -> 10000, FontFamily -> 
       "Source Sans Pro", FontSize -> 11], 
      Cell[
       StyleData["IndexSubentry"], MenuSortingValue -> 10000, FontFamily -> 
       "Source Sans Pro", FontSize -> 11], 
      Cell[
       StyleData["FunctionName"], MenuSortingValue -> 10000, FontFamily -> 
       "Source Sans Pro Semibold", FontWeight -> "Bold"], 
      Cell[
       StyleData["IndexColumn"], 
       CellMargins -> {{66, 0}, {Inherited, Inherited}}, TabSpacings -> {2.}, 
       MenuSortingValue -> 10000, FontFamily -> "Source Sans Pro", 
       GridBoxOptions -> {
        GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
         GridBoxItemSize -> {"Columns" -> {{25}}}, 
         GridBoxSpacings -> {"Columns" -> {{2}}}}], 
      Cell[
       StyleData["IndexSubsection"], 
       CellMargins -> {{64, Inherited}, {9, 28}}, 
       CellGroupingRules -> {"SectionGrouping", 40}, MenuSortingValue -> 
       10000, FontFamily -> "Source Sans Pro", FontSize -> 24], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Subsection"], CellMargins -> {{64, Inherited}, {12, 32}},
           FontFamily -> "Source Sans Pro Semibold", FontSize -> 18, 
          FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["Subsection", "Printout"], 
          CellMargins -> {{64, Inherited}, {12, 32}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ResourcesSubsection"], 
          CellMargins -> {{64, Inherited}, {4, 16}}, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 15, FontSlant -> "Plain", 
          FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["ResourcesSubsection", "Printout"], 
          CellMargins -> {{64, Inherited}, {4, 16}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Subsubsection"], 
          CellMargins -> {{64, Inherited}, {6, 12}}, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 16, FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["Subsubsection", "Printout"], 
          CellMargins -> {{64, Inherited}, {6, 12}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularySection"], PageWidth :> 700, 
          CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 24}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 18, FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["VocabularySection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 24}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularyTable", StyleDefinitions -> StyleData["Text"]],
           SpanMaxSize -> 1, FontFamily -> "Source Sans Pro Light", FontColor -> 
          GrayLevel[0.8], 
          GridBoxOptions -> {
           GridBoxAlignment -> {"Columns" -> {{Left}}}, 
            GridBoxDividers -> {"Columns" -> {{False}}, "Rows" -> {False, {
                 Directive[
                  Thickness[0.5], "VocabDivColor"]}, False}}, 
            GridBoxItemStyle -> {
             "Columns" -> {"VocabularyCode", Inherited, Inherited}, 
              "Rows" -> {{Automatic}}}, 
            GridBoxSpacings -> {
             "Columns" -> {{0, 1, 2, 1, 2}}, "Rows" -> {{1}}}}], 
         Cell[
          StyleData["VocabularyTable", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "VocabularyTable3Column", StyleDefinitions -> StyleData["Text"]], 
          SpanMaxSize -> 1, FontFamily -> "Source Sans Pro Light", FontColor -> 
          GrayLevel[0.8], 
          GridBoxOptions -> {
           GridBoxAlignment -> {"Columns" -> {{Left}}}, 
            GridBoxDividers -> {"Columns" -> {{False}}, "Rows" -> {False, {
                 Directive[
                  Thickness[0.5], "VocabDivColor"]}, False}}, 
            GridBoxItemStyle -> {
             "Columns" -> {
               "VocabularyCode", Inherited, "VocabularyCode", Inherited, 
                Inherited}, "Rows" -> {{Automatic}}}, 
            GridBoxSpacings -> {
             "Columns" -> {{0, 1, 2, 1, 2}}, "Rows" -> {{1}}}}], 
         Cell[
          StyleData["VocabularyTable3Column", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularyText"], FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["VocabularyText", "Printout"], 
          CellMargins -> {{66, 10}, {7, 7}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularyCode", StyleDefinitions -> StyleData["Text"]], 
          Deletable -> False, FontFamily -> "Source Sans Pro", FontSize -> 14,
           FontWeight -> "Bold", FontColor -> GrayLevel[0.25], 
          GridBoxOptions -> {
           GridBoxAlignment -> {"Columns" -> {{Left}}}, 
            GridBoxDividers -> {
             "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {True, {True}, True}, "RowsIndexed" -> {}}}], 
         Cell[
          StyleData["VocabularyCode", "Printout"], FontColor -> 
          GrayLevel[0.25]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabDivColor"], FontColor -> GrayLevel[0.8]], 
         Cell[
          StyleData["VocabDivColor", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseSection"], PageWidth :> 700, 
          CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, Evaluatable -> True, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, ShowCellLabel -> False, CellFrameMargins -> {{8, 8}, {4, 6}},
           CellFrameColor -> RGBColor[0.901961, 0.411765, 0.027451], 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro", FontSize -> 18, 
          FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["ExerciseSection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 30}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Exercise"], PageWidth :> 700, CellDingbat -> Cell[
            TextData[{"  ", 
              CounterBox["Section"], ".", 
              CounterBox["Exercise"]}], "ExerciseNumber", FontColor -> 
            RGBColor[
             0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
          ShowGroupOpener -> True, CellMargins -> {{108, Inherited}, {4, 8}}, 
          CellGroupingRules -> {"SectionGrouping", 67}, CounterIncrements -> 
          "Exercise", MenuSortingValue -> 10020, MenuCommandKey :> "2", 
          FontFamily -> "Source Sans Pro", FontSize -> 14, FontWeight -> 
          "Plain", FontSlant -> "Plain", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["Exercise", "Printout"], ShowGroupOpener -> False, 
          CellMargins -> {{110, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseNumber"], FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Bold", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["ExerciseNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseSubsection"], PageWidth :> 500, 
          CellFrame -> {{False, False}, {1, False}}, 
          CellMargins -> {{64, Inherited}, {8, 18}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, CellFrameColor -> 
          RGBColor[0.65, 0.6, 0.6], FontFamily -> "Source Sans Pro", FontSize -> 
          18, FontSlant -> "Italic", FontColor -> RGBColor[0.65, 0.6, 0.6]], 
         Cell[
          StyleData["ExerciseSubsection", "Printout"], 
          CellFrame -> {{False, False}, {1, False}}, CellFrameColor -> 
          RGBColor[0.65, 0.6, 0.6]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseNote"], PageWidth :> 700, 
          CellMargins -> {{64, Inherited}, {4, 8}}, PageBreakBelow -> False, 
          MenuSortingValue -> 10050, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0.25], $CellContext`ReturnCreatesNewCell -> 
          True], 
         Cell[
          StyleData["ExerciseNote", "Printout"], 
          CellMargins -> {{64, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["QASection"], PageWidth :> 700, 
          CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Question", 0}}, FontFamily -> "Source Sans Pro", FontSize -> 18, 
          FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["QASection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 30}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Question"], PageWidth :> 700, 
          CellMargins -> {{64, Inherited}, {2, 12}}, PageBreakBelow -> False, 
          CounterIncrements -> "Question", MenuSortingValue -> 10030, 
          MenuCommandKey :> "3", FontFamily -> "Source Sans Pro", FontSize -> 
          14, FontWeight -> "Bold", FontSlant -> 
          "Plain", $CellContext`ReturnCreatesNewCell -> 
          True, $CellContext`DefaultReturnCreatedCellStyle -> "Answer"], 
         Cell[
          StyleData["Question", "Printout"], 
          CellMargins -> {{65, Inherited}, {2, 12}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Answer"], PageWidth :> 700, 
          CellMargins -> {{66, 10}, {4, 1}}, LineSpacing -> {1.125, 1., 2.}, 
          MenuSortingValue -> 10032, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0.25], $CellContext`ReturnCreatesNewCell -> 
          True, $CellContext`DefaultReturnCreatedCellStyle -> "Question"], 
         Cell[
          StyleData["Answer", "Printout"], 
          CellMargins -> {{66, 10}, {4, 1}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["QuestionNumber"], FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Bold", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["QuestionNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TechNoteSection"], PageWidth :> 700, 
          CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 18, FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["TechNoteSection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 30}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TechNote"], PageWidth :> 700, CellDingbat -> Cell[
            TextData[{"\[FilledSmallSquare]"}], FontSize -> 12, FontColor -> 
            GrayLevel[0.5]], CellMargins -> {{78, Inherited}, {4, 8}}, 
          CellChangeTimes -> {{3.651515120816633*^9, 3.651515125814807*^9}, 
            3.6515155174947033`*^9}, LineSpacing -> {1.25, 1., 2.}, 
          MenuSortingValue -> 10040, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0.25], $CellContext`ReturnCreatesNewCell -> 
          True], 
         Cell[
          StyleData["TechNote", "Printout"], 
          CellMargins -> {{82, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["MoreExploreSection"], PageWidth :> 700, 
          CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 18, FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["MoreExploreSection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 30}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["MoreExplore"], PageWidth :> 700, 
          CellMargins -> {{64, Inherited}, {4, 8}}, PageBreakBelow -> False, 
          MenuSortingValue -> 10050, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0], $CellContext`ReturnCreatesNewCell -> 
          True], 
         Cell[
          StyleData["MoreExplore", "Printout"], 
          CellMargins -> {{64, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["MoreExploreShortURL"], 
          CellMargins -> {{64, Inherited}, {4, 8}}, PageBreakBelow -> False, 
          FontFamily -> "Source Sans Pro Light", FontSize -> 14, FontSlant -> 
          "Plain", FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["MoreExploreShortURL", "Printout"], 
          CellMargins -> {{64, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Text"], CellMargins -> {{66, 10}, {4, 14}}, FontFamily -> 
          "Baskerville", FontSize -> 18, FontColor -> 
          GrayLevel[0], $CellContext`ReturnCreatesNewCell -> True], 
         Cell[
          StyleData["Text", "Printout"], CellMargins -> {{66, 10}, {7, 7}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ResourcesText"], CellMargins -> {{66, 10}, {2, 0}}, 
          FontFamily -> "Source Sans Pro", FontSize -> 14, FontWeight -> 
          "Plain", FontSlant -> "Plain", FontColor -> 
          GrayLevel[0], $CellContext`ReturnCreatesNewCell -> True], 
         Cell[
          StyleData["ResourcesText", "Printout"], 
          CellMargins -> {{66, 10}, {2, 0}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ResourcesLink"], CellMargins -> {{66, 10}, {2, 0}}, 
          FontFamily -> "Source Sans Pro", FontSize -> 14, FontWeight -> 
          "Plain", FontSlant -> "Italic", FontColor -> 
          GrayLevel[0], $CellContext`ReturnCreatesNewCell -> True], 
         Cell[
          StyleData["ResourcesLink", "Printout"], 
          CellMargins -> {{66, 10}, {2, 0}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["CodeCaption"], CellFrame -> {{0, 0}, {0, 0}}, 
          CellMargins -> {{66, 10}, {4, 12}}, PageBreakBelow -> False, 
          CellFrameColor -> GrayLevel[0.4], MenuSortingValue -> 10010, 
          MenuCommandKey :> "1", FontFamily -> "Source Sans Pro", FontSize -> 
          16, FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["CodeCaption", "Printout"], 
          CellMargins -> {{66, 10}, {4, 12}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Input"], CellMargins -> {{99, 10}, {3, 7}}, SpanMaxSize -> 
          1, FontSize -> 15], 
         Cell[
          StyleData["Input", "Printout"], CellMargins -> {{99, 10}, {3, 7}}]},
         Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Output"], CellMargins -> {{99, 10}, {14, 7}}, FontSize -> 
          15], 
         Cell[
          StyleData["Output", "Printout"], 
          CellMargins -> {{99, 10}, {14, 7}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["InputOnly"], CellMargins -> {{99, 10}, {25, 10}}, 
          SpanMaxSize -> 1, MenuSortingValue -> 1500, FontSize -> 15], 
         Cell[
          StyleData["InputOnly", "Printout"], 
          CellMargins -> {{99, 10}, {15, 10}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["CellLabel"], 
          CellLabelMargins -> {{12, Inherited}, {Inherited, Inherited}}, 
          LanguageCategory -> None, StyleMenuListing -> None, FontFamily -> 
          "Helvetica Neue", FontSize -> 9, FontWeight -> "Plain", FontSlant -> 
          "Plain", FontColor -> GrayLevel[0.5]], 
         Cell[
          StyleData["CellLabel", "Printout"], FontSize -> 8, FontColor -> 
          GrayLevel[0.5]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Message"], Editable -> False, 
          CellMargins -> {{66, Inherited}, {Inherited, Inherited}}, 
          CellGroupingRules -> "OutputGrouping", TextClipboardType -> 
          "PlainText", PageBreakWithin -> False, GroupPageBreakWithin -> 
          False, GeneratedCell -> True, CellAutoOverwrite -> True, 
          ShowCellLabel -> False, DefaultFormatType -> 
          DefaultOutputFormatType, ContextMenu -> 
          FEPrivate`FrontEndResource["ContextMenus", "Output"], 
          ShowAutoStyles -> False, ShowSyntaxStyles -> False, 
          AutoStyleOptions -> {
           "StringStyle" -> None, "SyntaxErrorStyle" -> None}, 
          HyphenationOptions -> {"HyphenationCharacter" -> "\[Continuation]"},
           AutoItalicWords -> {}, AutoQuoteCharacters -> {}, 
          PasteAutoQuoteCharacters -> {}, LanguageCategory -> None, 
          FormatType -> InputForm, ShowStringCharacters -> False, 
          CounterIncrements -> "Message", MenuSortingValue -> 1600, 
          StyleMenuListing -> None, FontFamily :> 
          CurrentValue["PanelFontFamily"], FontSize -> 11, FontColor -> 
          RGBColor[0.5072, 0.16933, 0.15221], $CellContext`StripStyleOnPaste -> 
          True], 
         Cell[
          StyleData["Message", "Printout"], 
          CellMargins -> {{100, Inherited}, {Inherited, Inherited}}, 
          CellFrameLabels -> {{None, None}, {None, None}}, FontColor -> 
          GrayLevel[0]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseInput", StyleDefinitions -> StyleData["Input"]], 
          CellMargins -> {{88, 10}, {4, 7}}, ShowCellLabel -> False, 
          SpanMaxSize -> 1, FontSize -> 
          14, $CellContext`GeneratedCellStyles -> {
           "Output" -> "ExerciseOutput"}], 
         Cell[
          StyleData["ExerciseInput", "Printout"], 
          CellMargins -> {{88, 10}, {4, 7}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "ExerciseOutput", StyleDefinitions -> StyleData["Output"]], 
          CellMargins -> {{88, 10}, {10, 4}}, ShowCellLabel -> False, 
          FontSize -> 14], 
         Cell[
          StyleData["ExerciseOutput", "Printout"], 
          CellMargins -> {{88, 10}, {10, 4}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Picture"], CellMargins -> {{66, 10}, {10, 10}}, 
          CellGroupingRules -> "GraphicsGrouping", StyleMenuListing -> None], 
         
         Cell[
          StyleData["Picture", "Printout"], 
          CellMargins -> {{66, 10}, {8, 8}}]}, Closed]], 
      Cell[
       StyleData["ExerciseSummaryCell"], PageWidth :> 700, CellFrame -> 0, 
       CellMargins -> {{64, Inherited}, {8, 10}}, 
       CellGroupingRules -> {"SectionGrouping", 64}, PageBreakBelow -> False, 
       ShowCellLabel -> False, CellFrameMargins -> 0, ShowStringCharacters -> 
       False, FontFamily -> "Source Sans Pro", FontSize -> 18, FontColor -> 
       RGBColor[1, 1, 1], 
       GridBoxOptions -> {GridBoxBackground -> {"Columns" -> {{
              RGBColor[0.990997, 0.539528, 0.155779], 
              RGBColor[0.989487, 0.434699, 0.0320439]}}, "Rows" -> {{None}}}, 
         GridBoxItemSize -> {"Columns" -> {
             Scaled[0.7], 
             Scaled[0.3]}, "Rows" -> {{Automatic}}}}], 
      Cell[
       StyleData["ExerciseSummaryHeading"], ShowStringCharacters -> False, 
       FontFamily -> "Source Sans Pro", FontSize -> 18, FontColor -> 
       RGBColor[1, 1, 1]], 
      Cell[
       StyleData["ExerciseSummarySubheading"], ShowStringCharacters -> False, 
       FontFamily -> "Source Sans Pro", FontSize -> 15, FontColor -> 
       RGBColor[1., 0.9294117647058824, 0.7215686274509804]], 
      Cell[
       StyleData["ExercisePreviewButtonText"], ShowStringCharacters -> False, 
       FontFamily -> "Source Sans Pro", FontSize -> 14, FontSlant -> "Plain", 
       FontColor -> RGBColor[0.6, 0.6, 0.6]], 
      Cell[
       StyleData["ExercisePreviewButtonTextHighlight"], ShowStringCharacters -> 
       False, FontFamily -> "Source Sans Pro", FontSize -> 14, FontSlant -> 
       "Plain", FontColor -> 
       RGBColor[
        0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]]}, 
     Open]], 
   Cell[
    CellGroupData[{
      Cell[
      "Inline and special formatting", "Section", 
       CellChangeTimes -> {{3.646681732592888*^9, 3.646681749414035*^9}}], 
      Cell[
       StyleData["Graphics"], MenuSortingValue -> None], 
      Cell[
       StyleData["Graphics3D"], MenuSortingValue -> None], 
      Cell[
       StyleData["StandardForm"], 
       InputAutoReplacements -> {
        "->" -> "\[Rule]", ":>" -> "\[RuleDelayed]", "<=" -> "\[LessEqual]", 
         ">=" -> "\[GreaterEqual]", "!=" -> "\[NotEqual]", "==" -> "\[Equal]",
          "@>" -> "\\[InlinePart]", "<->" -> "\[UndirectedEdge]", ParentList},
        LineSpacing -> {1.25, 0, 2}, SingleLetterItalics -> False, 
       StyleMenuListing -> None, FontFamily -> "Source Sans Pro", 
       PrivateFontOptions -> {"OperatorSubstitution" -> True}], 
      Cell[
       StyleData["OutputForm"], PageWidth :> DirectedInfinity[1], 
       TextAlignment -> Left, LineSpacing -> {0.6, 1}, 
       AutoQuoteCharacters -> {}, PasteAutoQuoteCharacters -> {}, 
       StyleMenuListing -> None, FontFamily -> "Source Sans Pro", 
       PrivateFontOptions -> {"OperatorSubstitution" -> True}], 
      Cell[
       StyleData["InputForm"], PageWidth :> DirectedInfinity[1], 
       InputAutoReplacements -> {}, AllowInlineCells -> False, Hyphenation -> 
       False, AutoQuoteCharacters -> {}, PasteAutoQuoteCharacters -> {}, 
       AutoSpacing -> False, NumberMarks -> True, AutoNumberFormatting -> 
       False, StyleMenuListing -> None, FontFamily -> "Source Sans Pro", 
       PrivateFontOptions -> {"OperatorSubstitution" -> True}], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["DetailsLink"], FontFamily -> "Source Sans Pro", FontSize :> 
          If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.9]], FontColor -> GrayLevel[0], 
          ButtonBoxOptions -> {
           ButtonFunction :> (
             Function[$CellContext`t, 
              NotebookFind[$CellContext`t, "Notes", All, CellStyle]; 
              NotebookFind[$CellContext`t, "NotesSection", All, CellStyle, 
                AutoScroll -> Top]][
              Documentation`HelpLookup[
               StringJoin["ref/", #]]]& ), ButtonSource -> ButtonContents, 
            Evaluator -> Automatic}], 
         Cell[
          StyleData["DetailsLink", "Printout"], FontFamily -> 
          "Source Sans Pro", FontSize :> If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.88]], FontColor -> GrayLevel[0]]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["LinkAlt"], FontFamily -> "Source Sans Pro", FontSize :> 
          If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.9]], FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["LinkAlt", "Printout"], FontFamily -> "Source Sans Pro", 
          FontSize :> If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.88]], FontColor -> GrayLevel[0]]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Hyperlink"], MenuSortingValue -> None, FontColor -> 
          RGBColor[0.3, 0.35, 0.5]], 
         Cell[
          StyleData["Hyperlink", "Printout"]]}, Closed]], 
      Cell[
       StyleData[
       "IndexNavigationLink", StyleDefinitions -> StyleData["Hyperlink"]], 
       MenuSortingValue -> None, FontColor -> 
       RGBColor[
        0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
      Cell[
       StyleData["Crosslink"], 
       ButtonBoxOptions -> {ButtonFunction :> (FrontEndExecute[{
            
            NotebookLocate[#2, "OpenInNewWindow" -> 
             CurrentValue["HyperlinkModifierKey"]]}]& ), Evaluator -> None, 
         Method -> "Queued"}], 
      Cell[
       StyleData["VocabularyLink"], FontColor -> GrayLevel[0], 
       ButtonBoxOptions -> {ButtonFunction :> (FrontEndExecute[{
            
            NotebookLocate[#2, "OpenInNewWindow" -> 
             CurrentValue["HyperlinkModifierKey"]]}]& ), Evaluator -> None, 
         Method -> "Queued"}], 
      Cell[
       StyleData["InlineCode"], SpanMaxSize -> 1, FontColor -> GrayLevel[0]], 
      
      Cell[
       StyleData["InlineCodeText"], SpanMaxSize -> 1, FontFamily -> 
       "Source Sans Pro", FontSize -> 0.95 Inherited], 
      Cell[
       StyleData["NoLabel"], ShowCellLabel -> 
       False, $CellContext`GeneratedCellStyles -> {
        "Output" -> "ExerciseOutput"}], 
      Cell[
       StyleData["MenuName"], FontFamily -> "Verdana", FontWeight -> "Bold", 
       FontColor -> GrayLevel[0.286275]], 
      Cell[
       StyleData["KeyEvent"], CellFrame -> {{0.5, 0.5}, {0.5, 0.5}}, 
       CellFrameMargins -> {{2, 2}, {2, 2}}, CellFrameColor -> GrayLevel[0.7],
        FontFamily -> "Verdana", FontColor -> GrayLevel[0.4]], 
      Cell[
       StyleData["KeyEventDelimiter"], FontColor -> GrayLevel[0.5]], 
      Cell[
       CellGroupData[{
         Cell["Key Styles", "Subsubsection"], 
         Cell[
          StyleData["Key0"], 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              TagBox[
               GridBox[{{
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> GrayLevel[1], StripOnInput -> 
                   False]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Center}}, "Rows" -> {{Baseline}}}, AutoDelete -> 
                False, GridBoxDividers -> {"Rows" -> {{None}}}, 
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{1.45}}},
                 GridBoxSpacings -> {"Columns" -> {{0}}}, 
                BaselinePosition -> {{1, 1}, Baseline}], "Grid"], 
              RoundingRadius -> 4, Background -> 
              GrayLevel[0.9333333333333333], 
              FrameMargins -> {{0, 0}, {-2, -2}}, FrameStyle -> {
                GrayLevel[0.8352941176470589], 
                AbsoluteThickness[1]}, BaselinePosition -> Baseline, 
              StripOnInput -> False]& )}], 
         Cell[
          StyleData["Key1"], 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              TagBox[
               GridBox[{{
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #2, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> GrayLevel[1], StripOnInput -> 
                   False]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Center}}, "Rows" -> {{Baseline}}}, AutoDelete -> 
                False, GridBoxDividers -> {
                 "ColumnsIndexed" -> {2 -> GrayLevel[0.8352941176470589]}, 
                  "Rows" -> {{None}}}, 
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{1.45}}},
                 GridBoxSpacings -> {"Columns" -> {{0}}}, 
                BaselinePosition -> {{1, 1}, Baseline}], "Grid"], 
              RoundingRadius -> 4, Background -> 
              GrayLevel[0.9333333333333333], 
              FrameMargins -> {{0, 0}, {-2, -2}}, FrameStyle -> {
                GrayLevel[0.8352941176470589], 
                AbsoluteThickness[1]}, BaselinePosition -> Baseline, 
              StripOnInput -> False]& )}], 
         Cell[
          StyleData["Key2"], 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              TagBox[
               GridBox[{{
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #2, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #3, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> GrayLevel[1], StripOnInput -> 
                   False]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Center}}, "Rows" -> {{Baseline}}}, AutoDelete -> 
                False, GridBoxDividers -> {
                 "ColumnsIndexed" -> {
                   2 -> GrayLevel[0.8352941176470589], 3 -> 
                    GrayLevel[0.8352941176470589]}, "Rows" -> {{None}}}, 
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{1.45}}},
                 GridBoxSpacings -> {"Columns" -> {{0}}}, 
                BaselinePosition -> {{1, 1}, Baseline}], "Grid"], 
              RoundingRadius -> 4, Background -> 
              GrayLevel[0.9333333333333333], 
              FrameMargins -> {{0, 0}, {-2, -2}}, FrameStyle -> {
                GrayLevel[0.8352941176470589], 
                AbsoluteThickness[1]}, BaselinePosition -> Baseline, 
              StripOnInput -> False]& )}], 
         Cell[
          StyleData["Key3"], 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              TagBox[
               GridBox[{{
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #2, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #3, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #4, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> GrayLevel[1], StripOnInput -> 
                   False]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Center}}, "Rows" -> {{Baseline}}}, AutoDelete -> 
                False, GridBoxDividers -> {
                 "ColumnsIndexed" -> {
                   2 -> GrayLevel[0.8352941176470589], 3 -> 
                    GrayLevel[0.8352941176470589], 4 -> 
                    GrayLevel[0.8352941176470589]}, "Rows" -> {{None}}}, 
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{1.45}}},
                 GridBoxSpacings -> {"Columns" -> {{0}}}, 
                BaselinePosition -> {{1, 1}, Baseline}], "Grid"], 
              RoundingRadius -> 4, Background -> 
              GrayLevel[0.9333333333333333], 
              FrameMargins -> {{0, 0}, {-2, -2}}, FrameStyle -> {
                GrayLevel[0.8352941176470589], 
                AbsoluteThickness[1]}, BaselinePosition -> Baseline, 
              StripOnInput -> False]& )}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell["Entity styles", "Subsubsection"], 
         Cell[
          StyleData["Entity"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              FrameBox[
               PaneSelectorBox[{True -> GridBox[{{
                    
                    StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]], 
                    StyleBox[
                    RowBox[{"(", #4, ")"}], FontFamily -> "Source Sans Pro", 
                    FontWeight -> "Plain", FontColor -> GrayLevel[0.65], 
                    Selectable -> False]}}, 
                   GridBoxItemSize -> {
                    "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                   GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}},
                    BaselinePosition -> {1, 1}], False -> 
                 PaneBox[#, 
                   BaseStyle -> {
                    FontColor -> RGBColor[0.395437, 0.20595, 0.061158]}, 
                   BaselinePosition -> Baseline]}, 
                Dynamic[
                 CurrentValue[Evaluatable]], ImageSize -> Automatic, 
                BaselinePosition -> Baseline, 
                BaseStyle -> {FontFamily -> "Helvetica"}], FrameStyle -> 
               RGBColor[1., 0.504768, 0.], Background -> 
               RGBColor[1., 0.980392, 0.921569], 
               FrameMargins -> {{5, 5}, {1.5, 1.5}}, 
               ImageMargins -> {{2, 2}, {2, 2}}, BaselinePosition -> Baseline,
                RoundingRadius -> 4], #3, 
              BaseStyle -> {
               FontWeight -> "Plain", ShowStringCharacters -> False, 
                LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityFrameless"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              PaneSelectorBox[{True -> GridBox[{{
                    
                    StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]], 
                    StyleBox[
                    RowBox[{"(", #4, ")"}], FontFamily -> "Source Sans Pro", 
                    FontWeight -> "Plain", FontColor -> GrayLevel[0.65], 
                    Selectable -> False]}}, 
                  GridBoxItemSize -> {
                   "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                  BaselinePosition -> {1, 1}], False -> 
                PaneBox[#, 
                  BaseStyle -> {
                   FontColor -> RGBColor[0.395437, 0.20595, 0.061158]}, 
                  BaselinePosition -> Baseline]}, 
               Dynamic[
                CurrentValue[Evaluatable]], ImageSize -> Automatic, 
               BaselinePosition -> Baseline, 
               BaseStyle -> {FontFamily -> "Helvetica"}], #3, 
              BaseStyle -> {
               ShowStringCharacters -> False, LineIndent -> 0, 
                PrivateFontOptions -> {
                 FontWeight -> "Plain", "OperatorSubstitution" -> False}}]& ),
             Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityFramelessHot"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {
           DisplayFunction -> (PaneSelectorBox[{True -> GridBox[{{
                   
                   StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0]], 
                   StyleBox[
                    RowBox[{"(", #4, ")"}], FontWeight -> "Plain", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0], Selectable -> 
                    False]}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                 BaselinePosition -> {1, 1}], False -> 
               PaneBox[#, BaseStyle -> {FontColor -> GrayLevel[0]}, 
                 BaselinePosition -> Baseline]}, 
              Dynamic[
               CurrentValue[Evaluatable]], ImageSize -> Automatic, 
              BaselinePosition -> Baseline, 
              BaseStyle -> {
               FontWeight -> "Plain", FontFamily -> "Helvetica", 
                ShowStringCharacters -> False, LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityClass"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              FrameBox[
               PaneSelectorBox[{True -> GridBox[{{
                    PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                    
                    StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]], 
                    StyleBox[
                    RowBox[{"(", #4, ")"}], FontWeight -> "Plain", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0.65], 
                    Selectable -> False]}}, 
                   GridBoxItemSize -> {
                    "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                   GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}},
                    BaselinePosition -> {1, 2}], False -> GridBox[{{
                    PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                    
                    StyleBox[#, FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]]}}, 
                   GridBoxItemSize -> {
                    "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                   GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}},
                    BaselinePosition -> {1, 2}]}, 
                Dynamic[
                 CurrentValue[Evaluatable]], ImageSize -> Automatic, 
                BaselinePosition -> Baseline, 
                BaseStyle -> {FontFamily -> "Helvetica"}], FrameStyle -> 
               RGBColor[1., 0.504768, 0.], Background -> 
               RGBColor[1., 0.980392, 0.921569], 
               FrameMargins -> {{5, 5}, {1.5, 1.5}}, 
               ImageMargins -> {{2, 2}, {2, 2}}, BaselinePosition -> Baseline,
                RoundingRadius -> 4], #3, 
              BaseStyle -> {
               FontWeight -> "Plain", ShowStringCharacters -> False, 
                LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityClassFrameless"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              PaneSelectorBox[{True -> GridBox[{{
                    PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                    
                    StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]], 
                    StyleBox[
                    RowBox[{"(", #4, ")"}], FontWeight -> "Plain", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0.65], 
                    Selectable -> False]}}, 
                  GridBoxItemSize -> {
                   "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                  BaselinePosition -> {1, 2}], False -> GridBox[{{
                    PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                    
                    StyleBox[#, FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]]}}, 
                  GridBoxItemSize -> {
                   "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                  BaselinePosition -> {1, 2}]}, 
               Dynamic[
                CurrentValue[Evaluatable]], ImageSize -> Automatic, 
               BaselinePosition -> Baseline, 
               BaseStyle -> {FontFamily -> "Helvetica"}], #3, 
              BaseStyle -> {
               FontWeight -> "Plain", ShowStringCharacters -> False, 
                LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityClassFramelessHot"], ShowStringCharacters -> False,
           TemplateBoxOptions -> {
           DisplayFunction -> (PaneSelectorBox[{True -> GridBox[{{
                   PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                   
                   StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0]], 
                   StyleBox[
                    RowBox[{"(", #4, ")"}], FontWeight -> "Plain", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0], Selectable -> 
                    False]}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                 BaselinePosition -> {1, 2}], False -> GridBox[{{
                   PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                   StyleBox[#, FontColor -> GrayLevel[0]]}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                 BaselinePosition -> {1, 2}]}, 
              Dynamic[
               CurrentValue[Evaluatable]], ImageSize -> Automatic, 
              BaselinePosition -> Baseline, 
              BaseStyle -> {
               FontWeight -> "Plain", FontFamily -> "Helvetica", 
                ShowStringCharacters -> False, LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityProperty"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              FrameBox[
               
               PaneBox[#, 
                BaseStyle -> {
                 FontSlant -> Italic, FontWeight -> Plain, FontFamily -> 
                  "Source Sans Pro", FontColor -> 
                  RGBColor[0.395437, 0.20595, 0.061158]}, BaselinePosition -> 
                Baseline], FrameStyle -> 
               RGBColor[0.94227, 0.703639, 0.033387], Background -> 
               RGBColor[1., 0.980392, 0.921569], 
               FrameMargins -> {{5, 5}, {1.5, 1.5}}, 
               ImageMargins -> {{2, 2}, {2, 2}}, BaselinePosition -> Baseline,
                RoundingRadius -> 4], #3, 
              BaseStyle -> {
               FontWeight -> "Plain", ShowStringCharacters -> False, 
                LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityPropertyClass"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              FrameBox[
               PaneBox[
                GridBox[{{
                   PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], #}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                 BaselinePosition -> {1, 2}], 
                BaseStyle -> {
                 FontSlant -> Italic, FontWeight -> Plain, FontFamily -> 
                  "Source Sans Pro", FontColor -> 
                  RGBColor[0.395437, 0.20595, 0.061158]}, BaselinePosition -> 
                Baseline], FrameStyle -> 
               RGBColor[0.94227, 0.703639, 0.033387], Background -> 
               RGBColor[1., 0.980392, 0.921569], 
               FrameMargins -> {{5, 5}, {1.5, 1.5}}, 
               ImageMargins -> {{2, 2}, {2, 2}}, BaselinePosition -> Baseline,
                RoundingRadius -> 4], #3, 
              BaseStyle -> {
               FontWeight -> "Plain", ShowStringCharacters -> False, 
                LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityValue"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              
              GridBox[{{#, #2}}, GridBoxAlignment -> {"Rows" -> {{Baseline}}},
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}}, 
               GridBoxSpacings -> {"Columns" -> {{0}}}, 
               BaselinePosition -> {1, 1}], Background -> 
              RGBColor[{0.9921568627450981, 0.9529411764705882, 
                0.8509803921568627}], BaselinePosition -> Baseline, 
              FrameMargins -> {{1, 1}, {1, 1}}, ImageMargins -> 2, FrameStyle -> 
              RGBColor[{0.9333333333333333, 0.8470588235294118, 
                0.5529411764705883}], RoundingRadius -> 5]& )}]}, Closed]]}, 
     Closed]]}, Visible -> False, FrontEndVersion -> 
  "12.3 for Mac OS X x86 (64-bit) (July 30, 2021)", StyleDefinitions -> 
  "StylesheetFormatting.nb"],
ExpressionUUID->"268b90ed-d5ad-4026-9c4d-40c4cc099fdf"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "p:197"->{
  Cell[676, 24, 458, 11, 93, "SectionDoubleDigit",ExpressionUUID->"84d1c18d-ffe2-4994-ac9a-f92126785834",
   CounterAssignments->{{"Section", 32}, {"Subsection", 0}, {"Subsubsection", 0}, {"Exercise", 0}},
   CellTags->"p:197"]},
 "i:1"->{
  Cell[1137, 37, 672, 14, 140, "Text",ExpressionUUID->"525c4aa8-dec3-47c5-9bc9-157c841016b1",
   CellTags->"i:1"]},
 "i:2"->{
  Cell[3300, 99, 797, 22, 66, "Text",ExpressionUUID->"bdf5bdd2-a602-46fb-bf01-de8efce95a87",
   CellTags->"i:2"]},
 "LastCellOfAPage"->{
  Cell[8115, 272, 266, 7, 70, "Output",ExpressionUUID->"982246cf-a0c5-47e0-ae6f-4f2a2cf744e9",
   Evaluatable->False,
   CellTags->"LastCellOfAPage"],
  Cell[32656, 805, 1049, 34, 70, "Text",ExpressionUUID->"1d71e91b-b1e7-4f6e-bfa0-b7b56ad066fd",
   CellTags->"LastCellOfAPage"],
  Cell[63223, 1634, 311, 8, 70, "Text",ExpressionUUID->"a6c34c1a-de4f-4bf1-9604-d6ceff71c2ac",
   CellTags->"LastCellOfAPage"],
  Cell[70716, 1914, 206, 5, 70, "Output",ExpressionUUID->"acbdc865-8b37-4952-b9ea-d55a06430b2d",
   Evaluatable->False,
   CellTags->"LastCellOfAPage"],
  Cell[78531, 2193, 287, 8, 70, "Output",ExpressionUUID->"cdf106fd-52ca-4467-a117-3cbef0e41485",
   Evaluatable->False,
   CellTags->"LastCellOfAPage"],
  Cell[86784, 2495, 376, 11, 70, "Output",ExpressionUUID->"52945471-3ef7-4bc5-b360-2dff21e886b9",
   Evaluatable->False,
   CellTags->"LastCellOfAPage"],
  Cell[103151, 2888, 3092, 87, 70, "VocabularyTable",ExpressionUUID->"6b93372a-950d-4130-92b8-8511bcde08b0",
   CellTags->"LastCellOfAPage"],
  Cell[517039, 11177, 337, 8, 70, "MoreExplore",ExpressionUUID->"f131d714-f5ce-4e18-80c5-c00601345817",
   CellTags->"LastCellOfAPage"]},
 "p:198"->{
  Cell[8396, 282, 284, 9, 70, "CodeCaption",ExpressionUUID->"cfa290b8-3aff-4bc2-8073-4b3d34b4dc62",
   CellTags->{"p:198", "i:3"}]},
 "i:3"->{
  Cell[8396, 282, 284, 9, 70, "CodeCaption",ExpressionUUID->"cfa290b8-3aff-4bc2-8073-4b3d34b4dc62",
   CellTags->{"p:198", "i:3"}]},
 "i:4"->{
  Cell[9706, 332, 212, 4, 70, "CodeCaption",ExpressionUUID->"be3a5b54-9319-4117-be63-2825d15e4919",
   CellTags->"i:4"]},
 "i:5"->{
  Cell[32177, 787, 476, 16, 70, "Text",ExpressionUUID->"25108d93-7583-48f1-b734-b59aa01a78e7",
   CellTags->"i:5"]},
 "p:199"->{
  Cell[33708, 841, 407, 10, 70, "Text",ExpressionUUID->"90b145cd-7aad-4dc0-b184-f929a82e7bff",
   CellTags->{"p:199", "i:6"}]},
 "i:6"->{
  Cell[33708, 841, 407, 10, 70, "Text",ExpressionUUID->"90b145cd-7aad-4dc0-b184-f929a82e7bff",
   CellTags->{"p:199", "i:6"}]},
 "i:7"->{
  Cell[37386, 962, 406, 12, 70, "Text",ExpressionUUID->"0a28f48c-690e-44d3-aa5b-8a1705d88f92",
   CellTags->"i:7"]},
 "p:200"->{
  Cell[63537, 1644, 573, 19, 70, "Text",ExpressionUUID->"45562985-db84-4d8c-bacb-99dc16da4d67",
   CellTags->{"p:200", "i:8"}]},
 "i:8"->{
  Cell[63537, 1644, 573, 19, 70, "Text",ExpressionUUID->"45562985-db84-4d8c-bacb-99dc16da4d67",
   CellTags->{"p:200", "i:8"}]},
 "i:9"->{
  Cell[67928, 1804, 885, 32, 70, "Text",ExpressionUUID->"ba786b0c-64b3-4c4c-8a08-10bd89e19e79",
   CellTags->"i:9"]},
 "p:201"->{
  Cell[71556, 1947, 250, 9, 70, "CodeCaption",ExpressionUUID->"5403745f-b65a-4400-994c-7cdac8944869",
   CellTags->"p:201"]},
 "i:10"->{
  Cell[72913, 1998, 496, 17, 70, "CodeCaption",ExpressionUUID->"f0b587a8-bc5a-413d-b876-b9acdfe2f9c2",
   CellTags->"i:10"]},
 "i:11"->{
  Cell[74962, 2072, 444, 9, 70, "Text",ExpressionUUID->"ef980fdc-7213-4ea8-a697-181fd008b8c5",
   CellTags->"i:11"]},
 "i:12"->{
  Cell[77335, 2155, 573, 12, 70, "Text",ExpressionUUID->"fcf5a5e4-d273-4b60-8115-41f56e27dc2e",
   CellTags->"i:12"]},
 "i:13"->{
  Cell[77911, 2169, 241, 8, 70, "CodeCaption",ExpressionUUID->"c37f5ea5-cb1f-4c6d-8283-ac50d9fb38eb",
   CellTags->"i:13"]},
 "i:14"->{
  Cell[78833, 2204, 311, 14, 70, "CodeCaption",ExpressionUUID->"df61b02e-1c8f-422d-890b-50c3c6755712",
   CellTags->"i:14"]},
 "p:202"->{
  Cell[79830, 2245, 288, 8, 70, "Text",ExpressionUUID->"10f7fb48-8154-4724-a497-c3fe419eb856",
   CellTags->{"p:202", "i:15"}]},
 "i:15"->{
  Cell[79830, 2245, 288, 8, 70, "Text",ExpressionUUID->"10f7fb48-8154-4724-a497-c3fe419eb856",
   CellTags->{"p:202", "i:15"}]},
 "p:203"->{
  Cell[87175, 2509, 192, 4, 70, "CodeCaption",ExpressionUUID->"e908163f-e091-4206-ad67-247ead30abaa",
   CellTags->"p:203"]},
 "i:16"->{
  Cell[88096, 2542, 422, 12, 70, "Text",ExpressionUUID->"9670afe8-8465-434c-85a5-be314e138421",
   CellTags->"i:16"]},
 "i:17"->{
  Cell[91245, 2635, 190, 4, 70, "CodeCaption",ExpressionUUID->"c8d653fb-43ad-4189-b469-21ad40fd2591",
   CellTags->"i:17"]},
 "i:18"->{
  Cell[93489, 2688, 279, 9, 70, "CodeCaption",ExpressionUUID->"df89672c-3169-4f73-a150-7a24ef977bf0",
   CellTags->"i:18"]},
 "i:19"->{
  Cell[511575, 11003, 1398, 44, 70, "Answer",ExpressionUUID->"2da8b326-7bf3-4003-a619-d914e176f6bb",
   CellTags->"i:19"]},
 "i:20"->{
  Cell[512976, 11049, 206, 4, 70, "Question",ExpressionUUID->"ff718707-7128-48f2-967a-5867c934e0f3",
   CellTags->"i:20"]},
 "i:21"->{
  Cell[513930, 11081, 411, 9, 70, "TechNote",ExpressionUUID->"fca8f384-9e73-4f90-9c26-360e86f4f1f3",
   CellTags->"i:21"]},
 "i:22"->{
  Cell[514344, 11092, 389, 8, 70, "TechNote",ExpressionUUID->"d10592aa-9736-45fc-93d8-9f53d6f069ba",
   CellTags->"i:22"]},
 "i:23"->{
  Cell[514736, 11102, 1230, 38, 70, "TechNote",ExpressionUUID->"d402833a-cf95-47d0-8abc-6d7745f30034",
   CellTags->"i:23"]},
 "i:24"->{
  Cell[515969, 11142, 466, 11, 70, "TechNote",ExpressionUUID->"90e0a523-b5e5-4020-b186-e39af5cb65c0",
   CellTags->"i:24"]},
 "i:25"->{
  Cell[516438, 11155, 396, 11, 70, "TechNote",ExpressionUUID->"d1fac484-9568-4581-bfa0-eb8de1318298",
   CellTags->"i:25"]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"p:197", 608013, 13024},
 {"i:1", 608253, 13028},
 {"i:2", 608379, 13031},
 {"LastCellOfAPage", 608516, 13034},
 {"p:198", 609676, 13055},
 {"i:3", 609819, 13058},
 {"i:4", 609962, 13061},
 {"i:5", 610094, 13064},
 {"p:199", 610223, 13067},
 {"i:6", 610361, 13070},
 {"i:7", 610499, 13073},
 {"p:200", 610628, 13076},
 {"i:8", 610767, 13079},
 {"i:9", 610906, 13082},
 {"p:201", 611036, 13085},
 {"i:10", 611173, 13088},
 {"i:11", 611310, 13091},
 {"i:12", 611439, 13094},
 {"i:13", 611569, 13097},
 {"i:14", 611705, 13100},
 {"p:202", 611843, 13103},
 {"i:15", 611983, 13106},
 {"p:203", 612124, 13109},
 {"i:16", 612261, 13112},
 {"i:17", 612391, 13115},
 {"i:18", 612527, 13118},
 {"i:19", 612663, 13121},
 {"i:20", 612798, 13124},
 {"i:21", 612933, 13127},
 {"i:22", 613068, 13130},
 {"i:23", 613203, 13133},
 {"i:24", 613340, 13136},
 {"i:25", 613476, 13139}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[676, 24, 458, 11, 93, "SectionDoubleDigit",ExpressionUUID->"84d1c18d-ffe2-4994-ac9a-f92126785834",
 CounterAssignments->{{"Section", 32}, {"Subsection", 0}, {"Subsubsection", 0}, {"Exercise", 0}},
 CellTags->"p:197"],
Cell[1137, 37, 672, 14, 140, "Text",ExpressionUUID->"525c4aa8-dec3-47c5-9bc9-157c841016b1",
 CellTags->"i:1"],
Cell[1812, 53, 680, 15, 140, "Text",ExpressionUUID->"32b93821-da1f-4ef9-b0ce-ce8fab19bc22"],
Cell[2495, 70, 366, 10, 37, "CodeCaption",ExpressionUUID->"6ae03da0-bdb1-4cd6-84a9-3e1e1fdca51f"],
Cell[CellGroupData[{
Cell[2886, 84, 174, 4, 29, "Input",ExpressionUUID->"062107b2-1c5f-4de2-bdae-498afab0f292"],
Cell[3063, 90, 222, 6, 40, "Output",ExpressionUUID->"908e2f5b-4831-4b44-a5bf-f51008a4602d",
 Evaluatable->False]
}, Open  ]],
Cell[3300, 99, 797, 22, 66, "Text",ExpressionUUID->"bdf5bdd2-a602-46fb-bf01-de8efce95a87",
 CellTags->"i:2"],
Cell[4100, 123, 556, 18, 39, "CodeCaption",ExpressionUUID->"dd1dca88-3847-4b93-8828-521ed96d3096"],
Cell[CellGroupData[{
Cell[4681, 145, 187, 4, 29, "Input",ExpressionUUID->"69cb1efe-2f5a-4af4-92db-698e8b0bc722"],
Cell[4871, 151, 227, 6, 40, "Output",ExpressionUUID->"38dcd52e-bdce-49ee-a42f-e27d85dd7f47",
 Evaluatable->False]
}, Open  ]],
Cell[5113, 160, 181, 4, 37, "CodeCaption",ExpressionUUID->"a4f3d2db-050c-4f8f-9b2f-3e46d59bd612"],
Cell[CellGroupData[{
Cell[5319, 168, 291, 8, 29, "Input",ExpressionUUID->"e5203ce2-d65f-460a-a4c5-ef3fd8ebc1df"],
Cell[5613, 178, 315, 10, 40, "Output",ExpressionUUID->"ad39897c-abc7-40a5-bded-741a5184037f",
 Evaluatable->False]
}, Open  ]],
Cell[5943, 191, 253, 8, 40, "Text",ExpressionUUID->"a3b00660-8b76-476b-b618-bda36918a864"],
Cell[CellGroupData[{
Cell[6221, 203, 307, 9, 70, "Input",ExpressionUUID->"d1e29688-ccaa-4667-8f48-3e0931d75101"],
Cell[6531, 214, 485, 17, 70, "Output",ExpressionUUID->"e3f40953-d67b-4c9a-bc73-3f6e95d74048",
 Evaluatable->False]
}, Open  ]],
Cell[7031, 234, 624, 20, 70, "Text",ExpressionUUID->"2967e795-3095-45d3-a5b5-c62f5c35d47e"],
Cell[7658, 256, 189, 4, 70, "CodeCaption",ExpressionUUID->"fbff08b4-81eb-40bd-9fe7-f2aaf8466e2c"],
Cell[CellGroupData[{
Cell[7872, 264, 240, 6, 70, "Input",ExpressionUUID->"e93a371b-915f-4f4b-9cf6-d920d5f838cd"],
Cell[8115, 272, 266, 7, 70, "Output",ExpressionUUID->"982246cf-a0c5-47e0-ae6f-4f2a2cf744e9",
 Evaluatable->False,
 CellTags->"LastCellOfAPage"]
}, Open  ]],
Cell[8396, 282, 284, 9, 70, "CodeCaption",ExpressionUUID->"cfa290b8-3aff-4bc2-8073-4b3d34b4dc62",
 CellTags->{"p:198", "i:3"}],
Cell[CellGroupData[{
Cell[8705, 295, 226, 5, 70, "Input",ExpressionUUID->"40e7a540-9960-40ed-a949-7523c2de1b8c"],
Cell[8934, 302, 438, 15, 70, "Output",ExpressionUUID->"1e39832a-223e-483b-b292-5b8f345e4c9f",
 Evaluatable->False]
}, Open  ]],
Cell[9387, 320, 316, 10, 70, "Text",ExpressionUUID->"63482d6d-6984-46ca-8dfc-5ad5b670f849"],
Cell[9706, 332, 212, 4, 70, "CodeCaption",ExpressionUUID->"be3a5b54-9319-4117-be63-2825d15e4919",
 CellTags->"i:4"],
Cell[CellGroupData[{
Cell[9943, 340, 177, 4, 70, "Input",ExpressionUUID->"dd9b889c-b888-46f0-a295-846d5b84ec9a"],
Cell[10123, 346, 172, 4, 70, "Output",ExpressionUUID->"775a5def-9fb1-4f06-8c6c-210f63e1d4eb",
 Evaluatable->False]
}, Open  ]],
Cell[10310, 353, 221, 6, 70, "CodeCaption",ExpressionUUID->"d756dbef-851e-44a9-be54-7a590bb5fed8"],
Cell[CellGroupData[{
Cell[10556, 363, 352, 10, 70, "Input",ExpressionUUID->"ab68e9e9-d663-4d10-9e0a-e739fe9d6c01"],
Cell[10911, 375, 228, 6, 70, "Output",ExpressionUUID->"5729467e-6916-4379-805c-5004a4103147",
 Evaluatable->False]
}, Open  ]],
Cell[11154, 384, 215, 5, 70, "CodeCaption",ExpressionUUID->"309ccb2a-0710-4b17-b710-2e1e90e1d225"],
Cell[CellGroupData[{
Cell[11394, 393, 390, 11, 70, "Input",ExpressionUUID->"a80d6853-8eca-4e95-ac8e-52e20b1c47d5"],
Cell[11787, 406, 374, 13, 70, "Output",ExpressionUUID->"359ca278-56c4-4763-9463-972e37fa9187",
 Evaluatable->False]
}, Open  ]],
Cell[12176, 422, 205, 5, 70, "CodeCaption",ExpressionUUID->"f808c3bb-f10b-4098-a84e-9036fbf17742"],
Cell[CellGroupData[{
Cell[12406, 431, 286, 8, 70, "Input",ExpressionUUID->"19686d9b-6c38-41eb-91d9-3d45f2f23cef"],
Cell[12695, 441, 9371, 158, 70, "Output",ExpressionUUID->"141b528a-e8eb-467c-88d0-d0fe7507c08a",
 Evaluatable->False]
}, Open  ]],
Cell[22081, 602, 172, 4, 70, "CodeCaption",ExpressionUUID->"ebbea364-b540-4abb-b706-f08258486ec6"],
Cell[CellGroupData[{
Cell[22278, 610, 305, 9, 70, "Input",ExpressionUUID->"b89f52a0-2952-41bc-9fae-3107d404f953"],
Cell[22586, 621, 9576, 163, 70, "Output",ExpressionUUID->"daf03767-c90e-4f2c-ba1f-74683ec92cc5",
 Evaluatable->False]
}, Open  ]],
Cell[32177, 787, 476, 16, 70, "Text",ExpressionUUID->"25108d93-7583-48f1-b734-b59aa01a78e7",
 CellTags->"i:5"],
Cell[32656, 805, 1049, 34, 70, "Text",ExpressionUUID->"1d71e91b-b1e7-4f6e-bfa0-b7b56ad066fd",
 CellTags->"LastCellOfAPage"],
Cell[33708, 841, 407, 10, 70, "Text",ExpressionUUID->"90b145cd-7aad-4dc0-b184-f929a82e7bff",
 CellTags->{"p:199", "i:6"}],
Cell[34118, 853, 431, 12, 70, "CodeCaption",ExpressionUUID->"0c176065-3c89-4209-adc9-2c7ec43b9f36"],
Cell[CellGroupData[{
Cell[34574, 869, 125, 2, 70, "Input",ExpressionUUID->"30c3d20c-7347-450c-9e89-cad7cf8fc217"],
Cell[34702, 873, 173, 4, 70, "Output",ExpressionUUID->"6770b077-5d5d-47c9-bb9b-f9736b1e6293",
 Evaluatable->False]
}, Open  ]],
Cell[34890, 880, 343, 9, 70, "CodeCaption",ExpressionUUID->"71435462-a7e2-4608-8630-07991cb6170e"],
Cell[CellGroupData[{
Cell[35258, 893, 205, 4, 70, "Input",ExpressionUUID->"f1cff8e0-b4ba-4a6e-8c34-d15976cdc113"],
Cell[35466, 899, 241, 7, 70, "Output",ExpressionUUID->"a0af2b94-837e-4a17-be79-57b8ed3e1a5a",
 Evaluatable->False]
}, Open  ]],
Cell[35722, 909, 1661, 51, 70, "Text",ExpressionUUID->"c4ddc57b-1ade-4136-8e2d-7ac4bb73e29e"],
Cell[37386, 962, 406, 12, 70, "Text",ExpressionUUID->"0a28f48c-690e-44d3-aa5b-8a1705d88f92",
 CellTags->"i:7"],
Cell[37795, 976, 176, 4, 70, "CodeCaption",ExpressionUUID->"8213234e-f916-42f2-bf89-d89d53565674"],
Cell[CellGroupData[{
Cell[37996, 984, 415, 12, 70, "Input",ExpressionUUID->"08362707-ffc2-4561-a39c-7bdf9b09d196"],
Cell[38414, 998, 10004, 256, 70, "Output",ExpressionUUID->"390c74f3-1b1a-4c34-8e39-7233bee70865",
 Evaluatable->False]
}, Open  ]],
Cell[48433, 1257, 210, 5, 70, "CodeCaption",ExpressionUUID->"baf9818c-074f-4e13-94de-911209a494a7"],
Cell[CellGroupData[{
Cell[48668, 1266, 470, 14, 70, "Input",ExpressionUUID->"0e910aac-ab84-4fe2-ab3c-510c8dd90580"],
Cell[49141, 1282, 14067, 349, 70, "Output",ExpressionUUID->"ae684ee1-dcbd-4e9c-aec9-a4d31a497849",
 Evaluatable->False]
}, Open  ]],
Cell[63223, 1634, 311, 8, 70, "Text",ExpressionUUID->"a6c34c1a-de4f-4bf1-9604-d6ceff71c2ac",
 CellTags->"LastCellOfAPage"],
Cell[63537, 1644, 573, 19, 70, "Text",ExpressionUUID->"45562985-db84-4d8c-bacb-99dc16da4d67",
 CellTags->{"p:200", "i:8"}],
Cell[64113, 1665, 435, 13, 70, "CodeCaption",ExpressionUUID->"4d2d6cda-5774-4dc8-ab4b-92bb289dc878"],
Cell[CellGroupData[{
Cell[64573, 1682, 240, 6, 70, "Input",ExpressionUUID->"8d14652b-818e-4331-9354-0e306f0d86c9"],
Cell[64816, 1690, 173, 4, 70, "Output",ExpressionUUID->"05d1c7f4-fdf4-4cc5-8d10-4dd9f97dbf60",
 Evaluatable->False]
}, Open  ]],
Cell[65004, 1697, 215, 6, 70, "CodeCaption",ExpressionUUID->"e8d382bb-c761-4b0f-bd27-5854e1257d9d"],
Cell[CellGroupData[{
Cell[65244, 1707, 237, 6, 70, "Input",ExpressionUUID->"803ecb92-ab93-4262-98c8-9c3dbaf1dba9"],
Cell[65484, 1715, 173, 4, 70, "Output",ExpressionUUID->"3a8d7f77-8fa5-4128-8632-ec0ab0f9bf19",
 Evaluatable->False]
}, Open  ]],
Cell[65672, 1722, 186, 4, 70, "CodeCaption",ExpressionUUID->"0aacd68a-9c83-4788-82dc-e6350d838659"],
Cell[CellGroupData[{
Cell[65883, 1730, 295, 8, 70, "Input",ExpressionUUID->"1457a7d8-1720-41fa-92b1-12f1981723f5"],
Cell[66181, 1740, 252, 7, 70, "Output",ExpressionUUID->"8bfa2289-4b48-4221-a67c-86b830b5c2b7",
 Evaluatable->False]
}, Open  ]],
Cell[66448, 1750, 199, 4, 70, "CodeCaption",ExpressionUUID->"55566c5b-f669-4c15-9fc3-b7141b25d19b"],
Cell[CellGroupData[{
Cell[66672, 1758, 319, 9, 70, "Input",ExpressionUUID->"e3dec8e8-c42e-4c5b-b17f-f44b333e70a5"],
Cell[66994, 1769, 218, 6, 70, "Output",ExpressionUUID->"695172bf-194a-4517-99fe-372350c6b780",
 Evaluatable->False]
}, Open  ]],
Cell[67227, 1778, 171, 4, 70, "CodeCaption",ExpressionUUID->"6f2197e2-aaae-4f1f-9fa6-76a4e3ec3e5f"],
Cell[CellGroupData[{
Cell[67423, 1786, 269, 7, 70, "Input",ExpressionUUID->"bd321e08-32da-4325-8a1f-fbddf9e58b79"],
Cell[67695, 1795, 218, 6, 70, "Output",ExpressionUUID->"e6ff5f53-2167-4ee5-9a20-498c71b7029d",
 Evaluatable->False]
}, Open  ]],
Cell[67928, 1804, 885, 32, 70, "Text",ExpressionUUID->"ba786b0c-64b3-4c4c-8a08-10bd89e19e79",
 CellTags->"i:9"],
Cell[68816, 1838, 227, 9, 70, "CodeCaption",ExpressionUUID->"c8ad02be-a6ac-483f-ae55-f76f2f66568f"],
Cell[CellGroupData[{
Cell[69068, 1851, 212, 5, 70, "Input",ExpressionUUID->"2c0991c1-55d7-4f45-94e8-d37bd079973c"],
Cell[69283, 1858, 176, 4, 70, "Output",ExpressionUUID->"88683c3d-5442-483d-8a5e-ec392d1e4480",
 Evaluatable->False]
}, Open  ]],
Cell[69474, 1865, 191, 4, 70, "Text",ExpressionUUID->"10c70bbc-7d28-4ca8-b2ed-0b099a316bb2"],
Cell[69668, 1871, 234, 9, 70, "CodeCaption",ExpressionUUID->"68f2cce6-f852-49a7-86cd-510141b92b3b"],
Cell[CellGroupData[{
Cell[69927, 1884, 158, 3, 70, "Input",ExpressionUUID->"4b716e61-f334-4a16-a542-83b74ee9af30"],
Cell[70088, 1889, 179, 4, 70, "Output",ExpressionUUID->"8e665b1f-6a8d-411a-980d-7d38d36aaa93",
 Evaluatable->False]
}, Open  ]],
Cell[70282, 1896, 247, 9, 70, "CodeCaption",ExpressionUUID->"5f3888cf-ad97-42b9-a920-d89e4eb00634"],
Cell[CellGroupData[{
Cell[70554, 1909, 159, 3, 70, "Input",ExpressionUUID->"a459053a-d415-466c-a551-e706b3debc0a"],
Cell[70716, 1914, 206, 5, 70, "Output",ExpressionUUID->"acbdc865-8b37-4952-b9ea-d55a06430b2d",
 Evaluatable->False,
 CellTags->"LastCellOfAPage"]
}, Open  ]],
Cell[70937, 1922, 231, 9, 70, "CodeCaption",ExpressionUUID->"dd90d3ed-8727-4fbf-a502-ad12295509be"],
Cell[CellGroupData[{
Cell[71193, 1935, 167, 3, 70, "Input",ExpressionUUID->"add76fbc-49d2-409d-b072-f8ff65d1d41a"],
Cell[71363, 1940, 178, 4, 70, "Output",ExpressionUUID->"1584635d-75b5-4b12-ae3b-9c22aa3642c0",
 Evaluatable->False]
}, Open  ]],
Cell[71556, 1947, 250, 9, 70, "CodeCaption",ExpressionUUID->"5403745f-b65a-4400-994c-7cdac8944869",
 CellTags->"p:201"],
Cell[CellGroupData[{
Cell[71831, 1960, 155, 3, 70, "Input",ExpressionUUID->"e5fcd9da-ec0e-429e-855c-cd3273b977db"],
Cell[71989, 1965, 178, 4, 70, "Output",ExpressionUUID->"a577a0cf-3f64-4e6c-a2e5-f922aba02d0b",
 Evaluatable->False]
}, Open  ]],
Cell[72182, 1972, 728, 24, 70, "Text",ExpressionUUID->"63f33c94-9e86-4451-8b06-47366a130a17"],
Cell[72913, 1998, 496, 17, 70, "CodeCaption",ExpressionUUID->"f0b587a8-bc5a-413d-b876-b9acdfe2f9c2",
 CellTags->"i:10"],
Cell[CellGroupData[{
Cell[73434, 2019, 290, 7, 70, "Input",ExpressionUUID->"af10535c-5646-4ae1-bf90-3299ba43b792"],
Cell[73727, 2028, 238, 6, 70, "Output",ExpressionUUID->"90787327-9a6b-4d02-8250-69d749fc944d",
 Evaluatable->False]
}, Open  ]],
Cell[73980, 2037, 187, 4, 70, "CodeCaption",ExpressionUUID->"ec721d79-9d90-4bf3-992a-8b11eb7ff2e0"],
Cell[CellGroupData[{
Cell[74192, 2045, 367, 10, 70, "Input",ExpressionUUID->"f81287ab-02b5-49ec-a253-a82a1c540b86"],
Cell[74562, 2057, 385, 12, 70, "Output",ExpressionUUID->"2b73a922-1a2f-499a-bd09-bd978042e8b4",
 Evaluatable->False]
}, Open  ]],
Cell[74962, 2072, 444, 9, 70, "Text",ExpressionUUID->"ef980fdc-7213-4ea8-a697-181fd008b8c5",
 CellTags->"i:11"],
Cell[75409, 2083, 534, 18, 70, "CodeCaption",ExpressionUUID->"45034f1b-347c-407a-a80e-5d3a42c3f84f"],
Cell[CellGroupData[{
Cell[75968, 2105, 201, 5, 70, "Input",ExpressionUUID->"1a9475d9-1d4f-4218-b05f-04e6c0512699"],
Cell[76172, 2112, 438, 15, 70, "Output",ExpressionUUID->"734c043f-667f-4e60-b0f0-89a2b96f45a2",
 Evaluatable->False]
}, Open  ]],
Cell[76625, 2130, 198, 4, 70, "CodeCaption",ExpressionUUID->"3b4dedf7-8544-473c-815b-1e14b8fc39e7"],
Cell[CellGroupData[{
Cell[76848, 2138, 290, 8, 70, "Input",ExpressionUUID->"757508af-66b2-4125-96ab-607c624ce9f8"],
Cell[77141, 2148, 179, 4, 70, "Output",ExpressionUUID->"26644c3f-e27f-4625-bdb1-8384ef808dab",
 Evaluatable->False]
}, Open  ]],
Cell[77335, 2155, 573, 12, 70, "Text",ExpressionUUID->"fcf5a5e4-d273-4b60-8115-41f56e27dc2e",
 CellTags->"i:12"],
Cell[77911, 2169, 241, 8, 70, "CodeCaption",ExpressionUUID->"c37f5ea5-cb1f-4c6d-8283-ac50d9fb38eb",
 CellTags->"i:13"],
Cell[CellGroupData[{
Cell[78177, 2181, 351, 10, 70, "Input",ExpressionUUID->"b3c3d045-08f3-4013-9ee4-de833a7b5e2e"],
Cell[78531, 2193, 287, 8, 70, "Output",ExpressionUUID->"cdf106fd-52ca-4467-a117-3cbef0e41485",
 Evaluatable->False,
 CellTags->"LastCellOfAPage"]
}, Open  ]],
Cell[78833, 2204, 311, 14, 70, "CodeCaption",ExpressionUUID->"df61b02e-1c8f-422d-890b-50c3c6755712",
 CellTags->"i:14"],
Cell[CellGroupData[{
Cell[79169, 2222, 415, 12, 70, "Input",ExpressionUUID->"7c17e69d-f763-4faa-8fad-8808a21f6613"],
Cell[79587, 2236, 228, 6, 70, "Output",ExpressionUUID->"00c79339-8922-4d08-b467-fb8347dfb9e6",
 Evaluatable->False]
}, Open  ]],
Cell[79830, 2245, 288, 8, 70, "Text",ExpressionUUID->"10f7fb48-8154-4724-a497-c3fe419eb856",
 CellTags->{"p:202", "i:15"}],
Cell[80121, 2255, 278, 9, 70, "CodeCaption",ExpressionUUID->"4ab27f76-032a-4832-8de9-a46f57e5a02d"],
Cell[CellGroupData[{
Cell[80424, 2268, 219, 5, 70, "Input",ExpressionUUID->"62ca714e-d17f-407d-8c62-f441f66b2fcc"],
Cell[80646, 2275, 173, 4, 70, "Output",ExpressionUUID->"23098f24-3c73-4669-a9e4-6bd0820459bb",
 Evaluatable->False]
}, Open  ]],
Cell[80834, 2282, 411, 12, 70, "CodeCaption",ExpressionUUID->"c61d2799-bd44-43d5-b82b-d7b32cafd26c"],
Cell[CellGroupData[{
Cell[81270, 2298, 210, 5, 70, "Input",ExpressionUUID->"c729c2a2-2f88-4e44-ac4d-ffa944779c05"],
Cell[81483, 2305, 320, 9, 70, "Output",ExpressionUUID->"f27b6390-3b1d-47b8-a5d7-8eaded6298e7",
 Evaluatable->False]
}, Open  ]],
Cell[81818, 2317, 346, 8, 70, "Text",ExpressionUUID->"7eb06f79-c17b-44b5-bf9f-80ea532e697b"],
Cell[82167, 2327, 458, 14, 70, "CodeCaption",ExpressionUUID->"b50dad31-7846-4a4b-a352-278fb81a43b9"],
Cell[CellGroupData[{
Cell[82650, 2345, 205, 5, 70, "Input",ExpressionUUID->"8176e7a2-a194-4c1e-98e5-b9a76c63a86a"],
Cell[82858, 2352, 233, 6, 70, "Output",ExpressionUUID->"b1c9843f-f9ed-479d-a8bd-48273d9e5137",
 Evaluatable->False]
}, Open  ]],
Cell[83106, 2361, 408, 13, 70, "CodeCaption",ExpressionUUID->"4b4b4b79-dcb1-4f73-a526-cf4adf81c185"],
Cell[CellGroupData[{
Cell[83539, 2378, 218, 5, 70, "Input",ExpressionUUID->"e82ac7f7-706c-493e-8a00-468ae8025ad5"],
Cell[83760, 2385, 173, 4, 70, "Output",ExpressionUUID->"94ae40cd-f5ec-4e17-aca4-3f74a96c8b33",
 Evaluatable->False]
}, Open  ]],
Cell[83948, 2392, 173, 4, 70, "CodeCaption",ExpressionUUID->"7f1c8f2f-1b1e-4a5c-9648-a541f7339d47"],
Cell[CellGroupData[{
Cell[84146, 2400, 245, 7, 70, "Input",ExpressionUUID->"5b78afc7-4270-42fa-84db-8549f723f4ed"],
Cell[84394, 2409, 201, 5, 70, "Output",ExpressionUUID->"b6837c94-a31e-461f-a2af-aaf2f73c7b2e",
 Evaluatable->False]
}, Open  ]],
Cell[84610, 2417, 235, 7, 70, "CodeCaption",ExpressionUUID->"7b5440ca-243a-4336-a0ff-3c87a70774fa"],
Cell[CellGroupData[{
Cell[84870, 2428, 198, 5, 70, "Input",ExpressionUUID->"57e5c492-48e0-44b1-b5be-066dce703884"],
Cell[85071, 2435, 201, 5, 70, "Output",ExpressionUUID->"f9a65819-3b63-40a1-a85f-1ce56ad9e084",
 Evaluatable->False]
}, Open  ]],
Cell[85287, 2443, 863, 26, 70, "Text",ExpressionUUID->"5d50ab3d-ed84-48cc-adba-7484754725b0"],
Cell[86153, 2471, 285, 9, 70, "CodeCaption",ExpressionUUID->"8bd196d3-9c3b-4d71-9a5e-405684c22f8d"],
Cell[CellGroupData[{
Cell[86463, 2484, 318, 9, 70, "Input",ExpressionUUID->"0c7d7912-fc02-48cc-8b96-1d697b525085"],
Cell[86784, 2495, 376, 11, 70, "Output",ExpressionUUID->"52945471-3ef7-4bc5-b360-2dff21e886b9",
 Evaluatable->False,
 CellTags->"LastCellOfAPage"]
}, Open  ]],
Cell[87175, 2509, 192, 4, 70, "CodeCaption",ExpressionUUID->"e908163f-e091-4206-ad67-247ead30abaa",
 CellTags->"p:203"],
Cell[CellGroupData[{
Cell[87392, 2517, 365, 11, 70, "Input",ExpressionUUID->"ce0afa80-5621-4846-915d-d98ef4dc95b2"],
Cell[87760, 2530, 321, 9, 70, "Output",ExpressionUUID->"25d106bc-cb40-407b-a4d9-b7c3b0cc452b",
 Evaluatable->False]
}, Open  ]],
Cell[88096, 2542, 422, 12, 70, "Text",ExpressionUUID->"9670afe8-8465-434c-85a5-be314e138421",
 CellTags->"i:16"],
Cell[88521, 2556, 188, 4, 70, "CodeCaption",ExpressionUUID->"43347c9c-88d7-464b-8a3f-71713643d128"],
Cell[CellGroupData[{
Cell[88734, 2564, 270, 6, 70, "Input",ExpressionUUID->"fe3a3389-aeca-4fa0-9323-ddea630f7c8d"],
Cell[89007, 2572, 2223, 60, 70, "Output",ExpressionUUID->"df7b4b43-f864-4be2-9e69-7382733237c4",
 Evaluatable->False]
}, Open  ]],
Cell[91245, 2635, 190, 4, 70, "CodeCaption",ExpressionUUID->"c8d653fb-43ad-4189-b469-21ad40fd2591",
 CellTags->"i:17"],
Cell[CellGroupData[{
Cell[91460, 2643, 301, 7, 70, "Input",ExpressionUUID->"994431fd-7060-456e-a1f9-24236f8674e3"],
Cell[91764, 2652, 1710, 33, 70, "Output",ExpressionUUID->"1b5fae82-b6c0-47d2-a755-eb815ee84f70",
 Evaluatable->False]
}, Open  ]],
Cell[93489, 2688, 279, 9, 70, "CodeCaption",ExpressionUUID->"df89672c-3169-4f73-a150-7a24ef977bf0",
 CellTags->"i:18"],
Cell[CellGroupData[{
Cell[93793, 2701, 415, 11, 70, "Input",ExpressionUUID->"1ba1d10a-e1a7-45c5-a582-d7aefc40eb52"],
Cell[94211, 2714, 8729, 162, 70, "Output",ExpressionUUID->"90b6cd40-6f9c-49d1-99e1-a6d54a34b990",
 Evaluatable->False]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[102989, 2882, 159, 4, 70, "VocabularySection",ExpressionUUID->"bf81c073-c644-4f2f-aa0d-2918ef05eef3"],
Cell[103151, 2888, 3092, 87, 70, "VocabularyTable",ExpressionUUID->"6b93372a-950d-4130-92b8-8511bcde08b0",
 CellTags->"LastCellOfAPage"]
}, Open  ]],
Cell[CellGroupData[{
Cell[106280, 2980, 1780, 46, 70, "ExerciseSection",ExpressionUUID->"46d73543-c226-4e83-90ad-7e4b874fb6ab"],
Cell[CellGroupData[{
Cell[108085, 3030, 1272, 39, 70, "ExerciseSummaryCell",ExpressionUUID->"ed59bf01-db93-455a-a0e1-4fec745ecd9a"],
Cell[CellGroupData[{
Cell[109382, 3073, 749, 23, 70, "Exercise",ExpressionUUID->"a20c3419-96c3-4b54-b874-1e4e21958360"],
Cell[110134, 3098, 1079, 31, 70, "ExerciseOutput",ExpressionUUID->"a527a1b7-0d59-4b6a-8ddb-283f2d91d7a6"]
}, Closed]],
Cell[CellGroupData[{
Cell[111250, 3134, 894, 26, 70, "Exercise",ExpressionUUID->"813e9c20-c3e9-4a66-81a1-e40eea009596"],
Cell[112147, 3162, 1396, 36, 70, "ExerciseOutput",ExpressionUUID->"7a87690d-fcae-4426-a515-44d746e91ff0"]
}, Closed]],
Cell[CellGroupData[{
Cell[113580, 3203, 1285, 42, 70, "Exercise",ExpressionUUID->"39704067-9a32-4496-abf3-1074f8796be9"],
Cell[114868, 3247, 1790, 51, 70, "ExerciseOutput",ExpressionUUID->"8f8e159c-673f-4b6d-916c-a7aaac4f1698"]
}, Closed]],
Cell[CellGroupData[{
Cell[116695, 3303, 1233, 40, 70, "Exercise",ExpressionUUID->"ffcf5efb-9bdc-406e-a931-9e6ea5d3f59e"],
Cell[117931, 3345, 118759, 2380, 70, "ExerciseOutput",ExpressionUUID->"84c4d9ca-876d-4456-b148-535608a3d692"]
}, Closed]],
Cell[CellGroupData[{
Cell[236727, 5730, 1341, 42, 70, "Exercise",ExpressionUUID->"51497513-b27f-42d8-9a5c-cbbd8ba65959"],
Cell[238071, 5774, 1600, 42, 70, "ExerciseOutput",ExpressionUUID->"59a869c8-76b9-4c19-a81b-cb92fc224433"]
}, Closed]],
Cell[CellGroupData[{
Cell[239708, 5821, 1267, 40, 70, "Exercise",ExpressionUUID->"d60900df-6ea0-4d2d-ba29-2c9a78085afc"],
Cell[240978, 5863, 108201, 2016, 70, "ExerciseOutput",ExpressionUUID->"c1ab24cc-bc6c-479f-983c-8459a2cdbbfd"]
}, Closed]],
Cell[CellGroupData[{
Cell[349216, 7884, 781, 21, 70, "Exercise",ExpressionUUID->"4a24a6b2-b086-47ca-9ad2-9872ae315ac9"],
Cell[350000, 7907, 157882, 2965, 70, "ExerciseOutput",ExpressionUUID->"1dd05c22-52c1-48b4-92e7-829c3e3d8372"]
}, Closed]],
Cell[CellGroupData[{
Cell[507919, 10877, 1298, 44, 70, "Exercise",ExpressionUUID->"160fb30b-6cbf-4e4d-a29c-0eea1ce4d336"],
Cell[509220, 10923, 1644, 47, 70, "ExerciseOutput",ExpressionUUID->"978c1d85-9f9e-40bc-9c2e-0e80f3463670"]
}, Closed]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[510925, 10977, 144, 4, 70, "QASection",ExpressionUUID->"aa624005-cb96-4a0c-a4bd-c1b42fab81af"],
Cell[511072, 10983, 500, 18, 70, "Question",ExpressionUUID->"f756dcda-a456-4442-9847-a2bbb27f81d4"],
Cell[511575, 11003, 1398, 44, 70, "Answer",ExpressionUUID->"2da8b326-7bf3-4003-a619-d914e176f6bb",
 CellTags->"i:19"],
Cell[512976, 11049, 206, 4, 70, "Question",ExpressionUUID->"ff718707-7128-48f2-967a-5867c934e0f3",
 CellTags->"i:20"],
Cell[513185, 11055, 548, 15, 70, "Answer",ExpressionUUID->"e12412fc-9e3b-45d9-9272-d304c18a28b2"]
}, Open  ]],
Cell[CellGroupData[{
Cell[513770, 11075, 157, 4, 70, "TechNoteSection",ExpressionUUID->"d60dabd9-770c-4da3-965a-1fcd0256a420"],
Cell[513930, 11081, 411, 9, 70, "TechNote",ExpressionUUID->"fca8f384-9e73-4f90-9c26-360e86f4f1f3",
 CellTags->"i:21"],
Cell[514344, 11092, 389, 8, 70, "TechNote",ExpressionUUID->"d10592aa-9736-45fc-93d8-9f53d6f069ba",
 CellTags->"i:22"],
Cell[514736, 11102, 1230, 38, 70, "TechNote",ExpressionUUID->"d402833a-cf95-47d0-8abc-6d7745f30034",
 CellTags->"i:23"],
Cell[515969, 11142, 466, 11, 70, "TechNote",ExpressionUUID->"90e0a523-b5e5-4020-b186-e39af5cb65c0",
 CellTags->"i:24"],
Cell[516438, 11155, 396, 11, 70, "TechNote",ExpressionUUID->"d1fac484-9568-4581-bfa0-eb8de1318298",
 CellTags->"i:25"]
}, Open  ]],
Cell[CellGroupData[{
Cell[516871, 11171, 165, 4, 70, "MoreExploreSection",ExpressionUUID->"7856c5d0-878d-4b78-8e3f-75f7750ad242"],
Cell[517039, 11177, 337, 8, 70, "MoreExplore",ExpressionUUID->"f131d714-f5ce-4e18-80c5-c00601345817",
 CellTags->"LastCellOfAPage"]
}, Open  ]]
}
]
*)

(* NotebookSignature cKNCzjmBURNUnIOIPtZvhFXW *)
