(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    518336,       9538]
NotebookOptionsPosition[    452483,       8164]
NotebookOutlinePosition[    511414,       9375]
CellTagsIndexPosition[    511335,       9370]
WindowTitle->Expressions and Their Structure: Elementary Introduction to the \
Wolfram Language
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[TextData[{
 "Find the head of the output from ",
 StyleBox["ListPlot",
  FontFamily->"Source Sans Pro"],
 "."
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "33.1", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 33}, {"ExerciseNumber", 1}, {
   "WebOnly", 0}},ExpressionUUID->"4d14e2a5-9794-4b4d-933d-be1cfb80ed5b"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"618a0e36-ef28-4279-bf0e-4984a2e1935c"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztVSFv3TAQtjYyOGm/YH/AaGA0cChSpzGTVqurkS5qJ02mYYFmYUZBDwUF
hQSFmJhEmqIpJCQgwMQg4O1s56Uv6dPWrpNGelIi53y+++67O+ftxdcz+gIh
dPsKXmfn34Obm3P28TV8fLq+/XJ1ffn5w/W3y6vLm/cXL0H5Bp538Nj1/lme
5WGiOyWb4b5+MmZ6vK9C8IiCsDSX5snYZIIRSsaN1sgQoYDLh/uZ+hKOgJCI
scgto/zR2a1FpQHCqd5G6tKI8qJ7sBuTEUCDd+3MVl+KvFl5NfqOSCiKPlWW
6djogM04+99VEY6tzu1X7ocS2A9P8dxkkGSeMdhHiRxNL3kUOIJRwLJhmm1I
kgnm9ZiX7QEb8E94Qrz9rJ9ahgOhfOK6EszvYsItGbo5mKM4q61Cctistp2x
+EeI8rKqO71vM4pIUjetLOAIYkW/2ABU1cqU2izyzoJWwoWhQjZ1Yk1iOxha
Qg5c2mB1YtOJRKFkyQgth6mKrVfZ9+CfxrnFplKgzXe/WwNShGmm57hs0xx6
6BtZUNvS9aF2fO4A1+phqjZ6l35giTAHbN7SeViqW1gWSS67paSet9KN+6Q7
qaSwgVN9r59HtfMjExLLiW+Dtc3IIa97epdyINfYYJE26/vAdMJPIsJJ3jh/
NZjhuFxMWhF6t+u4Q+Lm139mwQrDHGOsoKgka/6MzRXXW27FDAUnC12+N0Im
ZNu2qopD29Tjpl4OG2b5oIdKREe8Weu0VF0rrUsU+NZd1XTBdtdvZkfdjBQK
ekQwmqkfKQmTHEbOtLa6MzYopsxijBYJRd3NcQOx1FQ6SG6fJRT7K3Tu+Vlw
WvXe+Pjs3NKWN0UOs7A3LadLTFo0P2ECFkeRkOuLx4xWtvflsUx6a2D5cRhg
4/F/I7g5rcO7c5P5Oz8nxdfu1A30/6XJKKa7p/9/n+Ufyi9efru2
            "], {{0, 
            19}, {52, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{52, 19},
          PlotRange->{{0, 52}, {0, 19}}]], "ExerciseOutput",
         ImageSize->{56, 19},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "7af24101-d1e3-4123-86e2-4cee6f20a453"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztVSFv3TAQtjYyOGm/YH/AaGA0cChSpzGTVqurkS5qJ02mYYFmYUZBDwUF
hQSFmJhEmqIpJCQgwMQg4O1s56Uv6dPWrpNGelIi53y+++67O+ftxdcz+gIh
dPsKXmfn34Obm3P28TV8fLq+/XJ1ffn5w/W3y6vLm/cXL0H5Bp538Nj1/lme
5WGiOyWb4b5+MmZ6vK9C8IiCsDSX5snYZIIRSsaN1sgQoYDLh/uZ+hKOgJCI
scgto/zR2a1FpQHCqd5G6tKI8qJ7sBuTEUCDd+3MVl+KvFl5NfqOSCiKPlWW
6djogM04+99VEY6tzu1X7ocS2A9P8dxkkGSeMdhHiRxNL3kUOIJRwLJhmm1I
kgnm9ZiX7QEb8E94Qrz9rJ9ahgOhfOK6EszvYsItGbo5mKM4q61Cctistp2x
+EeI8rKqO71vM4pIUjetLOAIYkW/2ABU1cqU2izyzoJWwoWhQjZ1Yk1iOxha
Qg5c2mB1YtOJRKFkyQgth6mKrVfZ9+CfxrnFplKgzXe/WwNShGmm57hs0xx6
6BtZUNvS9aF2fO4A1+phqjZ6l35giTAHbN7SeViqW1gWSS67paSet9KN+6Q7
qaSwgVN9r59HtfMjExLLiW+Dtc3IIa97epdyINfYYJE26/vAdMJPIsJJ3jh/
NZjhuFxMWhF6t+u4Q+Lm139mwQrDHGOsoKgka/6MzRXXW27FDAUnC12+N0Im
ZNu2qopD29Tjpl4OG2b5oIdKREe8Weu0VF0rrUsU+NZd1XTBdtdvZkfdjBQK
ekQwmqkfKQmTHEbOtLa6MzYopsxijBYJRd3NcQOx1FQ6SG6fJRT7K3Tu+Vlw
WvXe+Pjs3NKWN0UOs7A3LadLTFo0P2ECFkeRkOuLx4xWtvflsUx6a2D5cRhg
4/F/I7g5rcO7c5P5Oz8nxdfu1A30/6XJKKa7p/9/n+Ufyi9efru2
              "], {{0, 
              19}, {52, 0}}, {0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {52, 19}, 
            PlotRange -> {{0, 52}, {0, 19}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"3ac7e39d-ef52-4ea4-bcea-746665ea0870"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["33.1"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"d6d4266c-0d85-47f7-9d83-24c886d1a70d"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"ec57d6b5-2a01-4e55-9b59-6b431c089efb"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"bd5fffc6-2167-485f-9635-0ca400ef21cf"],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  StyleBox["@@",
   FontFamily->"Source Sans Pro"]], "InlineCode",ExpressionUUID->
  "a5b34383-3e72-48b1-abbf-4bc35a993d61"],
 " to compute the result of multiplying together integers up to 100."
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "33.2", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 33}, {"ExerciseNumber", 2}, {
   "WebOnly", 0}},ExpressionUUID->"d6d06ea6-755c-43df-9f06-69bd68d7d8fc"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"51261cfd-49a2-4a57-8b58-131cd7312692"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztXb+r61p2djJNyvwL+QdcTxmXqQwTpjvNDHke0ryYN4Hg1s2gUk1QMeDK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            "], {{0, 64}, {499, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{499, 64},
          PlotRange->{{0, 499}, {0, 64}}]], "ExerciseOutput",
         ImageSize->{503, 64},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "80c62bb5-115d-43a7-b23f-e1a293d3550d"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztXb+r61p2djJNyvwL+QdcTxmXqQwTpjvNDHke0ryYN4Hg1s2gUk1QMeDK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              "], {{0, 64}, {499, 0}}, {0, 255}, 
              ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {499, 64}, 
            PlotRange -> {{0, 499}, {0, 64}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"c9243a7c-94f7-4850-b26c-573d5f3ec4fd"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["33.2"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"3dceb767-40f0-48ba-aaee-9d23d6e317b8"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"dd1ddd38-55db-42a2-a146-a5556f93500a"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"d39a861c-9800-41c2-8d78-f44f89b78d89"],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  StyleBox["@@@",
   FontFamily->"Source Sans Pro"]], "InlineCode",ExpressionUUID->
  "bcb5ef0d-d3b0-488d-bae3-b515f0e4a6ad"],
 " and ",
 StyleBox["Tuples",
  FontFamily->"Source Sans Pro"],
 " to generate ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"f", "[", 
     RowBox[{"a", ",", "a"}], "]"}], ",", 
    RowBox[{"f", "[", 
     RowBox[{"a", ",", "b"}], "]"}], ",", 
    RowBox[{"f", "[", 
     RowBox[{"b", ",", "a"}], "]"}], ",", 
    RowBox[{"f", "[", 
     RowBox[{"b", ",", "b"}], "]"}]}], "}"}]], "InlineCode",ExpressionUUID->
  "0edcdfc3-e07a-4aeb-a078-ad7827ba06b0"],
 "."
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "33.3", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 33}, {"ExerciseNumber", 3}, {
   "WebOnly", 0}},ExpressionUUID->"c98135dd-6f88-47b0-8abd-6b7c4e4b97ed"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"a4860157-4a5e-4fb1-9dfb-0eed1959606b"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztmDGPmzAUx6126Vipn6BfgLmrx06RruqW5U53nLpc0bVSxcrmEamDp7KU
iSkTUxYmpApVYvHCEFViycDA4oEhtQ2XArETF0LvKvGkRI7z/H7+m8fD5vXV
xwvzGQDg0wv2dXH5Bd7fX9rvXrIf7+8+fbi9u7l+e/f55vbm/s3Vc9b5in2+
sQ9v72abbbbZZnuKRtN14PlBlBX/A5FmSbIpqjNBB0f7N9AB0ytCZBqGldId
8ZZA2PXX78i2bctyw83fTb87mdBlUWwHr6nCYxSxjA0AnLiXEkOh8miaNj30
tNjSNyFcOvG2ufplihnORKu8Kr0FAFbIOxOXd9qOF426spGHlmxChquY+jgi
TdhoN+mLHQiVR9OdyuTQ02IrEvLsMVDcIDnIFZlGPQggTnfN5YZp99antKQa
xaDnRpgkA5cK31FEmkAAcMrnzhzb/wyBqqMp+eOV6kP1xIp2k1005VeW9RPf
qssFMKz4B6cnzSwpWfs8MYShMFOxpW4phiq9Y4kijU0XW7UntPeFaAhUHW1C
pfpQPbHtduYv66tcZiG/ly28jpJfP9vrvEUQWDgkGQmcRau/Z3K3I3rHEmlS
P7rcVUySFW8baHtqkZVQdbQJlepD9cQScTVZu8jWLJlgU5lFxXD/VIzuelbb
TRYFCPCaoCg5MrcjescSRRqjh01FETksQv1rCFQdbUKl+lA9sVUW8DKyIkgU
iHXjXmJOT/r0XRV7dTGBprkAyie+3O2o3nFE8ejZ/0WJp7fICqg62oRK9aG6
YikW5boqiMM30+sj9DoIinLhQ1R7OZXbAL2axEZs2mwn8tDmaXyqMJ5YZFm0
6ZTqQzXF1nPzYj63LGA1u95NqdbZ52kZbYpt6ppGk6IVsQ0AnXC/S5O7tbkH
Q0YS2bae3zALJyKbLPYhb3v9jYQ2VBltSqX6UC2xza4J16P2e+P6zCWrjbnb
HLLB0mZAUQRoKh7ibiu/ZG5trmTIOCJNTdaxgI0rtNOHO3sIVBVtUqX6UB2x
3bY4z6JeATg8XZZFUZSdDTm/2Q+Kz6Fb+7QlHTKSyKyizLfTPRgqjTa1Un2o
1LNznuWloVOZoYk37VUV70ngYolW8rNkHvIthJ8ef3lSrpCoVuJUdXzImYhn
hmpzHwXa49LYs3lkURmE0dhHpumQ1lOh2qaei7HrBnEujViVeZaffFHDImMW
BgcxPTXkTMQzQ7W5jwLtcWmILMvxsiNH0tlmm+2p2m8CoGpx
            "], {{0, 19}, {
            158, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{158, 19},
          PlotRange->{{0, 158}, {0, 19}}]], "ExerciseOutput",
         ImageSize->{162, 19},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "1700ccd3-0f0a-49d3-b891-0f996d779d24"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztmDGPmzAUx6126Vipn6BfgLmrx06RruqW5U53nLpc0bVSxcrmEamDp7KU
iSkTUxYmpApVYvHCEFViycDA4oEhtQ2XArETF0LvKvGkRI7z/H7+m8fD5vXV
xwvzGQDg0wv2dXH5Bd7fX9rvXrIf7+8+fbi9u7l+e/f55vbm/s3Vc9b5in2+
sQ9v72abbbbZZnuKRtN14PlBlBX/A5FmSbIpqjNBB0f7N9AB0ytCZBqGldId
8ZZA2PXX78i2bctyw83fTb87mdBlUWwHr6nCYxSxjA0AnLiXEkOh8miaNj30
tNjSNyFcOvG2ufplihnORKu8Kr0FAFbIOxOXd9qOF426spGHlmxChquY+jgi
TdhoN+mLHQiVR9OdyuTQ02IrEvLsMVDcIDnIFZlGPQggTnfN5YZp99antKQa
xaDnRpgkA5cK31FEmkAAcMrnzhzb/wyBqqMp+eOV6kP1xIp2k1005VeW9RPf
qssFMKz4B6cnzSwpWfs8MYShMFOxpW4phiq9Y4kijU0XW7UntPeFaAhUHW1C
pfpQPbHtduYv66tcZiG/ly28jpJfP9vrvEUQWDgkGQmcRau/Z3K3I3rHEmlS
P7rcVUySFW8baHtqkZVQdbQJlepD9cQScTVZu8jWLJlgU5lFxXD/VIzuelbb
TRYFCPCaoCg5MrcjescSRRqjh01FETksQv1rCFQdbUKl+lA9sVUW8DKyIkgU
iHXjXmJOT/r0XRV7dTGBprkAyie+3O2o3nFE8ejZ/0WJp7fICqg62oRK9aG6
YikW5boqiMM30+sj9DoIinLhQ1R7OZXbAL2axEZs2mwn8tDmaXyqMJ5YZFm0
6ZTqQzXF1nPzYj63LGA1u95NqdbZ52kZbYpt6ppGk6IVsQ0AnXC/S5O7tbkH
Q0YS2bae3zALJyKbLPYhb3v9jYQ2VBltSqX6UC2xza4J16P2e+P6zCWrjbnb
HLLB0mZAUQRoKh7ibiu/ZG5trmTIOCJNTdaxgI0rtNOHO3sIVBVtUqX6UB2x
3bY4z6JeATg8XZZFUZSdDTm/2Q+Kz6Fb+7QlHTKSyKyizLfTPRgqjTa1Un2o
1LNznuWloVOZoYk37VUV70ngYolW8rNkHvIthJ8ef3lSrpCoVuJUdXzImYhn
hmpzHwXa49LYs3lkURmE0dhHpumQ1lOh2qaei7HrBnEujViVeZaffFHDImMW
BgcxPTXkTMQzQ7W5jwLtcWmILMvxsiNH0tlmm+2p2m8CoGpx
              "], {{0, 19}, {
              158, 0}}, {0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {158, 19}, 
            PlotRange -> {{0, 158}, {0, 19}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"29ba9b8c-b22c-48f8-af2d-f73afe9eef92"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["33.3"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"322cd2da-acd9-42b8-b8a7-9298df5c5f1b"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"f655a207-1c40-453c-be54-ca8d009e036a"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"af225f84-b9fa-467e-b184-bbe7bbe720ae"],

Cell[TextData[{
 "Make a list of tree forms for the results of 4 successive applications of \
",
 Cell[BoxData[
  StyleBox[
   RowBox[{"#", "^", "#", "&"}],
   FontFamily->"Source Sans Pro"]], "InlineCode",ExpressionUUID->
  "613ff380-e08e-44f3-96c2-245cab21625f"],
 " starting from ",
 Cell[BoxData[
 "x"], "InlineCode",ExpressionUUID->"14f18500-934a-4116-9627-f5eeb49516d9"],
 "."
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "33.4", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 33}, {"ExerciseNumber", 4}, {
   "WebOnly", 0}},ExpressionUUID->"c64c1bae-63b5-41c1-9139-b470142543da"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"0000df81-4247-40b4-9c2f-21461f67ab41"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJzt3c1TE2//L/ieOZtZnZp/YXauWLtl4WJWWGdqFlRlc6zz45Sb3+DvnKoh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            "], {{0, 526}, {382, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{382, 526},
          PlotRange->{{0, 382}, {0, 526}}]], "ExerciseOutput",
         ImageSize->{386, 526},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "01bd3b74-a95e-42ec-8469-ec3bdeab50d6"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJzt3c1TE2//L/ieOZtZnZp/YXauWLtl4WJWWGdqFlRlc6zz45Sb3+DvnKoh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              "], {{0, 526}, {382, 0}}, {0, 255}, ColorFunction -> 
              RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {382, 526}, 
            PlotRange -> {{0, 382}, {0, 526}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"515339d2-9256-403a-8842-4edbb540f30b"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["33.4"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"cd0e9940-8282-41e6-b77e-a8bd457f3ae4"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"1a7fe815-bb22-425c-a9aa-620608579d63"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"12018e37-a834-4799-964e-54607e84b23d"],

Cell[TextData[{
 "Find the unique cases where ",
 Cell[BoxData[
  RowBox[{"i", 
   StyleBox["^",
    FontFamily->"Source Sans Pro"], 
   RowBox[{"2", "/", 
    RowBox[{"(", 
     RowBox[{"j", 
      StyleBox["^",
       FontFamily->"Source Sans Pro"], "2", 
      StyleBox["+",
       FontFamily->"Source Sans Pro"], "1"}], ")"}]}]}]], "InlineCode",
  ExpressionUUID->"a2d18005-0060-4424-86f0-ab70f8b60d90"],
 " is an integer, with ",
 Cell[BoxData[
 "i"], "InlineCode",ExpressionUUID->"96c8af8a-98c7-4855-b694-6055341a142e"],
 " and ",
 Cell[BoxData[
 "j"], "InlineCode",ExpressionUUID->"a1e27925-c803-463e-b2e2-ee9e6bd9ca74"],
 " going up to 20."
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "33.5", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 33}, {"ExerciseNumber", 5}, {
   "WebOnly", 0}},ExpressionUUID->"277af463-1865-4a89-a8b3-9a50f1b34f99"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"4fa6ded1-e5cd-4361-9df6-2b7aa80cccba"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztWr/vpDYWJ7kmZaT8BfcPUKelTDVSTkk1TaJboms2aHNSREtHSUdHRUVF
RUVDhSKhSJZyNC5QJBoKItG4cDHxsxkGBhvMzjZfHU/ar2aZ93m//fxs5p8/
/vyt/blhGL98wf58+8Ov1ocPP7j/+pL957v3v/znp/fv/v3N+/++++ndh69/
/Ad7+BX79/1nhgGfbyeddNJJJ5100kknnXTSSSeddNL/F/WZb5umg8jtNrRl
liZJWtadmp+2NXpQ3RA1a4tKJi4r6w0eTgNGqBnoTElXZEmcpKjdgy6xHUZL
qudSNfT2FVOcpFXTb+qUBUrTZtKVeZqkLCrt9KxvENOapHnTb5k7sdcVM/Cu
5UCsnrDDPFp1Oyggioxr6CVd85SPpiOH/JWUkK6/Q5UDdJFKzfxy+FNtyG1+
QSCjrq4AnFeTSN3I6Ffg88Mhti3r6pXdKH9AoWEYtp/+7/fENIDEXyepVboD
wTGSVckLh+S+BV9fLC4uVWULJ64Q5JdTDBsOFWSmWJnoFfbJNoAXirqW6CU1
f2QKk728kQJ7JA2Uls20zS8z7MUvWBqqyOaPxDMrb3cWRRmADNMvD8VKgiXV
A8oDoQBJM66lFwULDcAaVNr+SktIz186sgklbsZTqZffm6w25Da/IJBRGV5n
gXEx1a2EIxW4fkjrLLo+6oc1ysAwAvYFjtljn29LrEuAsYo5YAgt4xIhJoqT
wuehtCAmIK8vmQqzVKzEJo89B8oyrMbgtDmEK2ERuTXwyU5VStbY0Sgwq/VZ
gOxEtSTWWB4KS6QITDADaVuXBkrTZtpmlulh/h0vb6scSMTiGVY3Hikm2goq
hclABCcinQKiH6s1lrYp01awvYBuplKWcW29lJIRgyIW7Uul76+shDT1ztho
6rI6cBrt/N4ktSG3+QWBzMTMuG8BtC38kH3QjYx+BarCVbNc3K0lCDoAX51D
fx9R+tLnxSnV37HvwnpvWB1gf3ELroQiS90BhEUsOsEYHJo6THko2Gtw1t48
RcyxD+ohO0bWSiFyLE+oJ/peB6FTJXQdqKM2c2zhiSDTYRroh2CnA/C2Zl2v
pmA7pPcJK/y9oP1jxzrjx/2lNWO6xrBb6forKSFdvRWbPab1yNdaVA/a+RW0
qA2pza8IxAlbutenZaRdCZoVqAwXYj3dHJ9DP1n1Lgig4clXz1DxOfLq2LYX
xHWnKqCOjxp2XjclzDZus7U5Qa7vwRlC8+E7gUOKqhetsQ8rQ6ieXA2TYGGD
ZsqcGLeI7c+WX+zAH4E6ZvPQtahIYAS04yVX6/E5WQVEEFMja9r4ItgO6F1h
xwMgy6TjuGGitleS8YM5YjsQFLyNn2tg2991Cenq5Xnxx7z2hcjysfzK62ph
8wsCaeYYJjs21HkUhkm2PknvVMLSU1UFKsNV81XPPvY4hyaxPADSJuW1qbgH
oNizTNuPsiy24RxyKRWNr4EGNNIlxltuPHUA62E2r1LVVcMaO9kI426y1XSk
2CGaHZryjdtQoeURqEM28+7E6clsvkjNTHH6E+pcPtYwO63wgF4ZFg4FbOoM
kjSN+ClVdWKSZPxgjvgIys8RC9r29yYpIV29BMe8aXlh6InDcgh8R/Kr6ABL
mz9a4BBeRrdcj/t4ieaadiMjaK8CleESC8RPa19YPtfNDyBsXNvs6BNzYS4v
Nx7u1hETE6OODjh2wdt0Yz1+6hmghgAqZhg1tmDFYvqY0K7OHOaYuSlhEajD
eyIlXRZc52Fpc8iGm6pa5RDxmnH8IAi8izjN53/o6ZViF9dWfK3t2My9Fhn/
85i/fA6Pl7d2e/5KS+gvfb09LgLPdb2wKFMYCKr+WH5ldfVk8wsC+S5wHVf9
sHRkNzJ3D3crcKMsScg7I+1raJHefVruSrhXsILNZja7MeJ3Nb5kUuJXDYZ3
96n3t4+3FMERCQl2GJAMKxLlguGmw966dVhgR7NAuZvtH3AX2D4wH7MKRcFW
VT8HSt9mMnurhax7/2x40u3VLjkHFnEYhGEA5F/4XhwVWE+vFNtQ8mDtck/t
7zrj3aEcNRkbAa5o1gA0/JWW0G/HaoMT4TdCadsdyO9NUlcrm48UzEogTO9W
KByhTTJhdSIDpFWByrIU3TUqoWNhOI/CPQBpc/FyIswrVFVlWeKe3mjtsjbi
ZVP2+F7hlbjtmopvYnxWWbG1UFFszEADIbiA86Zfdms2mNcQQgXY48ZFjeCl
pTifeinqMJhkevx4pYfltBh+tLEEjqqGneOOsA3av4xFu8JKA6VpM2TEdPO6
7bsmBRWwM+LU4/KcAgl5CF4FS2x++MMneSgS7VitsOJqLsiarsNlbPGuMMiw
0owf0svv5cJpcWj6Ky0hTb20K5yrV9QNrhKIspPSm25+pXUls/klgeKc4sRl
32P+DtDBVDcy+hUoD9d4+zf2n+ldALqfTCaC7YkgnvNgSt/QFO6D0YrKTkh5
YmN2F6E98dnwskPGRqonrQE/qIwvRqEsg3FM1saKU+eiA2hiCfYfTy8J6qVY
eaD0bCZt5V2nl+tmkLEdpA+tJ3l8O5CEdKLp9dxNN1YSLK3zmeaLN+5Omhk/
ohciZk0dQN9fWQnp6aVsi7yH2bTDO5tWfmW18afC5o8WCF/W43oHbFoP+pE5
UIGKh/N3AfyNhr8xvMCQMGvgY4TJ0A+LnzdJ2ThfP5A9NhkBstdQoUf6WGHy
x+nVtHmt4kWbX4gVHVgmycIWzYy/pldCmiWkr5dzPc9Br+RXSi8JpGDj7k85
X6kE6cMapuRRoDgRWFOfXFILY6sRo51fPH5athN7Yt8E9m0KJCV/9TMbkkkZ
+7btSX9ZQYcWa/za/NOyndgT+yawb1MgyXzH8SL80UPPSSeddNJJJ5309ulv
5F3b1w==
            "], {{0, 19}, {342, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{342, 19},
          PlotRange->{{0, 342}, {0, 19}}]], "ExerciseOutput",
         ImageSize->{346, 19},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "33a53d4f-c743-49e5-a9cf-06ceb11bd9fe"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztWr/vpDYWJ7kmZaT8BfcPUKelTDVSTkk1TaJboms2aHNSREtHSUdHRUVF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              "], {{0, 19}, {342, 0}}, {0, 255}, ColorFunction -> 
              RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {342, 19}, 
            PlotRange -> {{0, 342}, {0, 19}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"c3b0229e-eba4-4cd3-9b0a-f7dafd2ec99a"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["33.5"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"5bf33b17-5550-4028-8aa1-4fca1b54664e"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"3ad69a2e-d2a5-4c73-90e3-47a5997d139a"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"3689dae2-0425-4942-95d9-04a1e8d0e647"],

Cell[TextData[{
 "Create a graph that connects successive pairs of numbers in ",
 Cell[BoxData[
  RowBox[{
   StyleBox["Table",
    FontFamily->"Source Sans Pro"], "[", 
   RowBox[{
    RowBox[{
     StyleBox["Mod",
      FontFamily->"Source Sans Pro"], "[", 
     RowBox[{
      RowBox[{"n", 
       StyleBox["^",
        FontFamily->"Source Sans Pro"], "2", 
       StyleBox["+",
        FontFamily->"Source Sans Pro"], "n"}], ",", "100"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "100"}], "}"}]}], "]"}]], "InlineCode",ExpressionUUID->
  "d309f387-1462-4fc6-bbfa-7154fef293dc"],
 "."
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "33.6", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 33}, {"ExerciseNumber", 6}, {
   "WebOnly", 0}},ExpressionUUID->"dc2cf78f-1624-48e7-a08a-c3bda8f7187d"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"c43f68c9-5972-4450-a4f5-119355603f46"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJzsved7VEfW9jvnnC/n4/kXzufnfc/1zMzjmcEB2xhsY+MAtsc2GEzOQWQR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            "], {{0, 335}, {360, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{360, 335},
          PlotRange->{{0, 360}, {0, 335}}]], "ExerciseOutput",
         ImageSize->{364, 335},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "e45da1b3-9150-4c12-b1d4-c7414e330911"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJzsved7VEfW9jvnnC/n4/kXzufnfc/1zMzjmcEB2xhsY+MAtsc2GEzOQWQR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              "], {{0, 335}, {360, 0}}, {0, 255}, ColorFunction -> 
              RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {360, 335}, 
            PlotRange -> {{0, 360}, {0, 335}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"af3da347-b29e-4afe-82c7-6514cd0e78a8"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["33.6"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"97fd6689-84f8-45b4-a76f-ba3934d3674f"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"12b32f9c-8de9-4fca-8d0f-1fbbc5b1b093"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"254dde59-21b7-404f-b6dd-8ab6fdebb41e"],

Cell["\<\
Generate a graph showing which word can follow which in the first 200 words \
of the Wikipedia article on computers.\
\>", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "33.7", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 TaggingRules->{"MultipleSolutions" -> "True"},
 CounterAssignments->{{"SectionNumber", 33}, {"ExerciseNumber", 7}, {
   "WebOnly", 0}},ExpressionUUID->"060d709a-4315-4b17-8a19-fa6de47f9bf3"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{
    "SAMPLE", " ", "EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"5228939d-ff68-4e64-93fd-26143373cffa"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJzsvQlcU2e+/3/+///r9f/f39y5d+69M3dmOkuXaaetnXq6V+ueti7tqOle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            "], {{0, 468}, {560, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{560, 468},
          PlotRange->{{0, 560}, {0, 468}}]], "ExerciseOutput",
         ImageSize->{564, 468},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "1119583c-bef1-43ba-9de7-5f7bdc1b2d19"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJzsvQlcU2e+/3/+///r9f/f39y5d+69M3dmOkuXaaetnXq6V+ueti7tqOle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              "], {{0, 468}, {560, 0}}, {0, 255},
               ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {560, 468}, 
            PlotRange -> {{0, 560}, {0, 468}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"04cefa3f-bc47-4910-b736-6e1373606790"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["33.7"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"26400ae0-3137-4d25-907a-6ede7bc903a5"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"4df08e4a-2ce7-4029-9efc-ee1674a9b441"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"dab246d8-5ea9-4980-a3f0-5ebe1403fac3"],

Cell[TextData[{
 "Find a simpler form for ",
 Cell[BoxData[
  RowBox[{"f", 
   StyleBox["@@",
    FontFamily->"Source Sans Pro"], 
   StyleBox["#",
    FontFamily->"Source Sans Pro"], 
   StyleBox["&",
    FontFamily->"Source Sans Pro"], 
   StyleBox["/@",
    FontFamily->"Source Sans Pro"], 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"7", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "4"}], "}"}]}], "}"}]}]], "InlineCode",
  ExpressionUUID->"ad9239bd-0521-4b46-b8a3-b302a4a484ed"],
 "."
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "33.8", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 TaggingRules->{"MultipleSolutions" -> "True"},
 CounterAssignments->{{"SectionNumber", 33}, {"ExerciseNumber", 8}, {
   "WebOnly", 0}},ExpressionUUID->"d83927eb-ed17-4e08-941e-f903038113a8"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{
    "SAMPLE", " ", "EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"eff4c6db-fff7-4f57-9a89-85417a7881e5"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztV63L3EgYD1dz8qB/Qf+B6LMjTwVa6mJa+qaceS+8LZTYuJEDFeNiLipq
VVRM1MARDsaMiQiFmIiImBER22cmye7sbj6O93ahlP3BLpPZPM9v5vneV+//
eu39YlnWp1/h6/W7L+jp6V3w5jd4ePv46c+Pjw8f/nj8/PDx4en39y9g8yV8
PsNHrfd33HHHHWuQPEuiOMnL9s54DbQp9mzb53IvItfS+PD1bxwEge+TtJpe
60rOq65f09TVLN0lyY6JRj/LlICWIKSZXJCYZZRNxU9RNQsKrsS43/e1MPhE
tSQ+oRVFUbXylLGLPYTckDWjlTpOgcjDu7rvIsey/FRtFkRtBmGUK9uWSTCc
B7NFX7c8sfU7w7efCODNI+zCs00WxOYZOUHWKWxS3JQRnohtEqKiW7MsI47i
xeyUsRep8pze308URLtJRshClE8GR3wK0iqLQ19po8WibcsYtOJaq4w95Ych
kgRcxqYLJ11i7HvZA2DFlS2c2ZtelbGjyHIirqhH5kXIMhkc4NDR4yajXo+e
lVzZFvZF7E9R4rN/6IXvBFySLNsWjtdOFaNlGMSZFudw6IWbbjHCRQWYz43F
7RkbkKdi1aYjagxRilyIVTRlk8lorpX3tZ27MlXx7NMsL779e3FTWaAN2x5R
qKQO6wuuM2wwQr4kEI5e+R9u/H8Zu0Inuet7Xkhi0SxScl2u06qOnWOlMhmF
ties2zIDR6KxPuh8Icd8eZ5t+2qn6tgUbCs33WDcV1DldZ7enrEvQ2R7OErT
2FOF15ltLANRkCof6toyw9jrioF3Auv0yEY9quYMcf5827ZM+dWND6KrN11l
rFPQFJebHft6jKPC3J7v2roPQifEhJDQGSpuVl0wSqrbYt+KEBZhts3bc1Vv
+Wr7bJhqKYg0xt6zb1qlELYuXzft1RiN9tUxiCI8E0UyjymhlChgR4f3MEeZ
jFJE8EPEVGyXCbh96GtLvBImW54rkSDOYQyspeoyARTzMD1cXdbZMDjSrOBF
wRgr2/6E90Jk3baqhJomuiXjTlXGkJV1UxVEKbXTup8TP57mMG/sZ/oXHUQO
c8IQ8zM3lbrOGyDwg+T6CMTIxLO3xrQ68l6ILDIeFCLDtrdk7Ko8OCpDEWtm
GQ0cZrZz25prPd/iM/Gz+XYWKuAXU+8Ic/ZbEfkRGHsJQ93JP89nMAqVGCf1
AXm0MpQO/1mQ4+JdOautTtWgGPP11tbtsO66esZbF/kpGCWLAl3+D/8iJYsx
jHXCKCt9wyNdtRNWz2rsu7qstzq40qyKP02Y3BL5KRhlin0/jMrNQL/jjh8V
3wFs6bCf
            "], {{0, 19}, {116, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{116, 19},
          PlotRange->{{0, 116}, {0, 19}}]], "ExerciseOutput",
         ImageSize->{120, 19},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "b3ff3b0d-ea7f-4ff3-96a0-70013a2955ee"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztV63L3EgYD1dz8qB/Qf+B6LMjTwVa6mJa+qaceS+8LZTYuJEDFeNiLipq
VVRM1MARDsaMiQiFmIiImBER22cmye7sbj6O93ahlP3BLpPZPM9v5vneV+//
eu39YlnWp1/h6/W7L+jp6V3w5jd4ePv46c+Pjw8f/nj8/PDx4en39y9g8yV8
PsNHrfd33HHHHWuQPEuiOMnL9s54DbQp9mzb53IvItfS+PD1bxwEge+TtJpe
60rOq65f09TVLN0lyY6JRj/LlICWIKSZXJCYZZRNxU9RNQsKrsS43/e1MPhE
tSQ+oRVFUbXylLGLPYTckDWjlTpOgcjDu7rvIsey/FRtFkRtBmGUK9uWSTCc
B7NFX7c8sfU7w7efCODNI+zCs00WxOYZOUHWKWxS3JQRnohtEqKiW7MsI47i
xeyUsRep8pze308URLtJRshClE8GR3wK0iqLQ19po8WibcsYtOJaq4w95Ych
kgRcxqYLJ11i7HvZA2DFlS2c2ZtelbGjyHIirqhH5kXIMhkc4NDR4yajXo+e
lVzZFvZF7E9R4rN/6IXvBFySLNsWjtdOFaNlGMSZFudw6IWbbjHCRQWYz43F
7RkbkKdi1aYjagxRilyIVTRlk8lorpX3tZ27MlXx7NMsL779e3FTWaAN2x5R
qKQO6wuuM2wwQr4kEI5e+R9u/H8Zu0Inuet7Xkhi0SxScl2u06qOnWOlMhmF
ties2zIDR6KxPuh8Icd8eZ5t+2qn6tgUbCs33WDcV1DldZ7enrEvQ2R7OErT
2FOF15ltLANRkCof6toyw9jrioF3Auv0yEY9quYMcf5827ZM+dWND6KrN11l
rFPQFJebHft6jKPC3J7v2roPQifEhJDQGSpuVl0wSqrbYt+KEBZhts3bc1Vv
+Wr7bJhqKYg0xt6zb1qlELYuXzft1RiN9tUxiCI8E0UyjymhlChgR4f3MEeZ
jFJE8EPEVGyXCbh96GtLvBImW54rkSDOYQyspeoyARTzMD1cXdbZMDjSrOBF
wRgr2/6E90Jk3baqhJomuiXjTlXGkJV1UxVEKbXTup8TP57mMG/sZ/oXHUQO
c8IQ8zM3lbrOGyDwg+T6CMTIxLO3xrQ68l6ILDIeFCLDtrdk7Ko8OCpDEWtm
GQ0cZrZz25prPd/iM/Gz+XYWKuAXU+8Ic/ZbEfkRGHsJQ93JP89nMAqVGCf1
AXm0MpQO/1mQ4+JdOautTtWgGPP11tbtsO66esZbF/kpGCWLAl3+D/8iJYsx
jHXCKCt9wyNdtRNWz2rsu7qstzq40qyKP02Y3BL5KRhlin0/jMrNQL/jjh8V
3wFs6bCf
              "], {{0, 19}, {116, 0}}, {0, 255}, ColorFunction -> 
              RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {116, 19}, 
            PlotRange -> {{0, 116}, {0, 19}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"c6aa9372-0a52-494b-b7b6-a2a1484afc71"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["33.8"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"f71576f6-6d01-4ea6-8e09-0c1db66c2011"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"7e17c395-2302-4afa-bc85-d9020b7cf5b4"]
}, Open  ]]
}, Open  ]],

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"4b837152-d333-45b8-8f70-13800fe42bb2"]
},
WindowSize->{808, 755},
WindowMargins->{{314, Automatic}, {Automatic, 50}},
WindowTitle->"Expressions and Their Structure: Elementary Introduction to the \
Wolfram Language",
DockedCells->{
  Cell[
   BoxData[
    DynamicModuleBox[{}, 
     TagBox[
      GridBox[{{
         TagBox[
          ButtonBox[
           PaneBox[
            GraphicsBox[
             TagBox[
              RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UFAEiEGSIPafvQ3/iQM/qxmAiEjFmOohXKwIouDvuQXEGw4xENM6POaT5Hiq
qP97c+uvfvWfDVy/59j/ahX5Pdfx3/sHuNSDFE/UBpI/G3l+TTP9vS7p7+nZ
QBG4FjT1QJOBin+vCAcpaxcHWgEU/HOk7/ciHzzqgSYD2b/XJQO5UPFueezq
J+sDFf/qVQY64PeSgN8b0n5NMfz34DAu9T+beIFm/upV+jXF4PcC9z87K4C6
fk3SwaUeGBq/18QDDQQ5e2f5rw6pP0f7gd4BCmJVD3QG0HygBxHO61UG6sIV
nhAtwNAAOgCEgOEPMxmXevyAEvV4EidaQiU+P0IAAEIjNUM=
               "], {{0, 
               20}, {16, 0}}, {0, 255}, ColorFunction -> RGBColor], 
              BoxForm`ImageTag[
              "Byte", ColorSpace -> ColorProfileData[CompressedData["
1:eJydlndcFNcWx+/MbC+0XZYiZem9twVEehOQXkVh2V1gKQsuuxTFhogKRBQR
EWwgQQEDRkORWBHFQkCw14AEASUGo9hQyax8PokvL++9vPz+uJ/vnHvOnXvP
OXc+o5GQEZIIAwCyCOgQws5xFQrZeaEy6EO4IIufJOBxfQUiXhJPyEqAUKMP
BR0AxcefL8iAUa90gUgY4u3GjIqOYeL7AQyIAAcsAGBzsjIDQr3CJN6+nu7M
LNQJ/Ite3wKSBcF1E58gJhP8f5LlZApFAEBBKFtxeVkclAtRTssRZUrs0yjT
E1IlDGMkLEQ3iLKihJPm2fizzzy7SJibLuCiLNlzJjedK+EelDdni3koI/4o
F2XzeTko30BZO02czkf5rSQ2ncfOAgAjyY62iMdJRtlckihhWIg7ygsBIFCS
vuCEL1jEyxVJDuWekZkn5Ccli5j6HAOmhb09i+nDy0njiUQmQWxOKlvIZbpn
pGeyBXkAzJ/5s+QkuWWiSba1sLe1NbE0tfgiUf918m9KUtt5ehn8uWYQo+8P
21/5ZdQBwJpBc7PtD1vCbgA6NgKgeO8Pm/YBAKTRurUPfHEehqRfkkWiTAcz
s5ycHFM+j2MqSejv+p8Of0NfvM9Ustzv6WF68BLZ4jQRU5I3TkZahljIzMpk
c3hMkz838T8O/Ot9GIfwEnlCngCNiEC7jC9IQsst4PJF/AwBky/4T0X8h2F/
0nxfo6LVfwL0OFMgM0AHyM99AEMjAyR2HzoD/V43f2IEkNy8SPXx+b7/LOjf
V4XLJAP6Gfkc5x4SxuSIhdnzc5JrCbCABKQBHSgBNaAF9IEJsAR2wBG4AE+w
GASCMBANlgMOSAbpQAhyQD5YD4pACdgGdoJqsB/Ug0bQAo6BDnASnAMXwVVw
DdwE98EwGAPPwDR4DWYhCMJDVIgGKUHqkA5kBFlCLGgR5An5QyFQNBQPJUEC
SAzlQxugEqgcqoZqoUboW+gEdA66DA1Cd6ERaBL6FXoPIzAFpsOqsC5sBrNg
V9gPDoOXwUnwCnglXAhvhavgOvgI3A6fg6/CN+Fh+Bk8gwCEjDAQDcQEYSHu
SCASgyQiQmQNUoxUInVIC9KF9CLXkWFkCnmHwWFoGCbGBOOI8cGEYziYFZg1
mFJMNeYwph3Tg7mOGcFMYz5hqVgVrBHWAeuLjcImYXOwRdhKbAO2DXsBexM7
hn2Nw+EYOD2cHc4HF41Lwa3CleL24lpxZ3GDuFHcDB6PV8Ib4Z3wgXg2XoQv
wu/GH8GfwQ/hx/BvCWSCOsGS4EWIIQgIBYRKQhPhNGGIME6YJcoQdYgOxEAi
l5hHLCPWE7uIA8Qx4ixJlqRHciKFkVJI60lVpBbSBdID0ksymaxJticHk/nk
deQq8lHyJfII+R1FjmJIcafEUsSUrZRDlLOUu5SXVCpVl+pCjaGKqFupjdTz
1EfUt1I0KVMpXymu1FqpGql2qSGp59JEaR1pV+nl0iulK6WPSw9IT8kQZXRl
3GXYMmtkamROyNyWmZGlyVrIBsqmy5bKNslelp2Qw8vpynnKceUK5Q7KnZcb
pSE0LZo7jUPbQKunXaCN0XF0PbovPYVeQv+G3k+flpeTt5aPkM+Vr5E/JT/M
QBi6DF9GGqOMcYxxi/FeQVXBVYGnsEWhRWFI4Y3iAkUXRZ5isWKr4k3F90pM
JU+lVKXtSh1KD5UxyobKwco5yvuULyhPLaAvcFzAWVC84NiCeyqwiqFKiMoq
lYMqfSozqmqq3qqZqrtVz6tOqTHUXNRS1CrUTqtNqtPUF6nz1SvUz6g/Zcoz
XZlpzCpmD3NaQ0XDR0OsUavRrzGrqacZrlmg2ar5UIukxdJK1KrQ6taa1lbX
DtDO127WvqdD1GHpJOvs0unVeaOrpxupu0m3Q3dCT1HPV2+lXrPeA32qvrP+
Cv06/RsGOAOWQarBXoNrhrChjWGyYY3hgBFsZGvEN9prNGiMNbY3FhjXGd82
oZi4mmSbNJuMmDJM/U0LTDtMn5tpm8WYbTfrNftkbmOeZl5vft9CzmKxRYFF
l8WvloaWHMsayxtWVCsvq7VWnVYvrI2sedb7rO/Y0GwCbDbZdNt8tLWzFdq2
2E7aadvF2+2xu82is4JYpaxL9lh7N/u19ift3znYOogcjjn84mjimOrY5Dix
UG8hb2H9wlEnTSe2U63T8CLmovhFBxYNO2s4s53rnB+7aLlwXRpcxl0NXFNc
j7g+dzN3E7q1ub1xd3Bf7X7WA/Hw9ij26PeU8wz3rPZ85KXpleTV7DXtbeO9
yvusD9bHz2e7z21fVV+Ob6Pv9GK7xasX9/hR/EL9qv0e+xv6C/27AuCAxQE7
Ah4s0VkiWNIRCAJ9A3cEPgzSC1oR9H0wLjgouCb4SYhFSH5IbygtNC60KfR1
mFtYWdj9cP1wcXh3hHREbERjxJtIj8jyyOEos6jVUVejlaP50Z0x+JiImIaY
maWeS3cuHYu1iS2KvbVMb1nussvLlZenLT8VJx3Hjjsej42PjG+K/8AOZNex
ZxJ8E/YkTHPcObs4z7gu3AruJM+JV84bT3RKLE+cSHJK2pE0meycXJk8xXfn
V/NfpPik7E95kxqYeih1Li0yrTWdkB6ffkIgJ0gV9GSoZeRmDGYaZRZlDq9w
WLFzxbTQT9iQBWUty+oU0dGfqT6xvnijeCR7UXZN9tuciJzjubK5gty+PMO8
LXnjK71Wfr0Ks4qzqjtfI399/shq19W1a6A1CWu612qtLVw7ts573eH1pPWp
638oMC8oL3i1IXJDV6Fq4brC0Y3eG5uLpIqERbc3OW7avxmzmb+5f4vVlt1b
PhVzi6+UmJdUlnwo5ZRe+criq6qv5rYmbu0vsy3btw23TbDt1nbn7YfLZctX
lo/uCNjRXsGsKK54tTNu5+VK68r9u0i7xLuGq/yrOndr7962+0N1cvXNGrea
1j0qe7bsebOXu3don8u+lv2q+0v2vz/AP3Cn1ru2vU63rvIg7mD2wSf1EfW9
X7O+bmxQbihp+HhIcGj4cMjhnka7xsYmlaayZrhZ3Dx5JPbItW88vulsMWmp
bWW0lhwFR8VHn34b/+2tY37Huo+zjrd8p/PdnjZaW3E71J7XPt2R3DHcGd05
eGLxie4ux662702/P3RS42TNKflTZadJpwtPz51ZeWbmbObZqXNJ50a747rv
n486f6MnuKf/gt+FSxe9Lp7vde09c8np0snLDpdPXGFd6bhqe7W9z6av7Qeb
H9r6bfvbB+wGOq/ZX+saXDh4esh56Nx1j+sXb/jeuHpzyc3BW+G37tyOvT18
h3tn4m7a3Rf3su/N3l/3APug+KHMw8pHKo/qfjT4sXXYdvjUiMdI3+PQx/dH
OaPPfsr66cNY4RPqk8px9fHGCcuJk5Nek9eeLn069izz2exU0c+yP+95rv/8
u19cfumbjpoeeyF8Mfdr6Uull4deWb/qngmaefQ6/fXsm+K3Sm8Pv2O9630f
+X58NucD/kPVR4OPXZ/8Pj2YS5+b+w0AsgC3
                 "], "RGB", "XYZ"], 
               Interleaving -> True], Selectable -> False], DefaultBaseStyle -> 
             "ImageGraphics", ImageSizeRaw -> {16, 20}, 
             PlotRange -> {{0, 16}, {0, 20}}], Alignment -> {Center, Center}, 
            ImageMargins -> {{15, 10}, {4, 0}}], Appearance -> None, 
           ButtonFunction :> NotebookLocate[{
              URL["http://www.wolfram.com/language/elementary-introduction/"],
               None}], Evaluator -> Automatic, Method -> "Preemptive"], 
          MouseAppearanceTag["LinkHand"]], 
         ItemBox[
          TagBox[
           GridBox[{{
              TagBox[
               ButtonBox[
                StyleBox[
                "STEPHEN WOLFRAM Elementary Introduction to the Wolfram \
Language", "DockedCellAuthorName"], Appearance -> None, ButtonFunction :> 
                NotebookLocate[{
                   URL[
                   "http://www.wolfram.com/language/elementary-introduction/"]\
, None}], Evaluator -> Automatic, Method -> "Preemptive"], 
               MouseAppearanceTag["LinkHand"]]}, {
              TagBox[
               ButtonBox[
                TemplateBox[{
                  StyleBox["Exercises ", "DockedCellSectionTitle"], 
                  StyleBox["|", "DockedCellSectionTitleDivider"], 
                  StyleBox[
                  " 33  Expressions and Their Structure", 
                   "DockedCellSectionTitle"]}, "RowDefault"], Appearance -> 
                None, ButtonFunction :> NotebookLocate[{
                   URL[
                   "http://www.wolfram.com/language/elementary-introduction/\
33-expressions-and-their-structure.html"], None}], Evaluator -> Automatic, 
                Method -> "Preemptive"], 
               MouseAppearanceTag["LinkHand"]]}}, DefaultBaseStyle -> 
            "Column", GridBoxAlignment -> {"Columns" -> {{Left}}}, 
            GridBoxSpacings -> {"Columns" -> {{0}}, "Rows" -> {{0}}}], 
           "Column"], Alignment -> Left, ItemSize -> 30]}}, AutoDelete -> 
       False, GridBoxSpacings -> {"Columns" -> {{0}}, "Rows" -> {{0}}}, 
       GridBoxAlignment -> {"Columns" -> {Left}, "Rows" -> {Center}}, 
       GridBoxItemSize -> {
        "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], "Grid"], 
     DynamicModuleValues :> {}, 
     Initialization :> (
      Clear[$CellContext`SolutionResponseText]; \
$CellContext`SolutionResponseText[
         Pattern[ElementaryIntroToWLWeb`Private`a, 
          BlankNullSequence[]]] := " "; 
      Map[($CellContext`SolutionResponseText[#] := " ")& , {
        "33.1", "33.2", "33.3", "33.4", "33.5", "33.6", "33.7", "33.8"}]; 
      Clear[$CellContext`SolutionResponseDetails]; \
$CellContext`SolutionResponseDetails[
         Pattern[ElementaryIntroToWLWeb`Private`str, 
          Blank[String]], True] := 
       Style[ElementaryIntroToWLWeb`Private`str, 
         "SolutionTrue"]; $CellContext`SolutionResponseDetails[
         Pattern[ElementaryIntroToWLWeb`Private`str, 
          Blank[String]], False] := 
       Style[ElementaryIntroToWLWeb`Private`str, 
         "SolutionFalse"]; $CellContext`SolutionResponseDetails[
         Pattern[ElementaryIntroToWLWeb`Private`str, 
          Blank[String]]] := 
       ElementaryIntroToWLWeb`Private`str; \
$CellContext`SolutionResponseDetails[
         Missing[
          BlankSequence[]]] := " "; $CellContext`SolutionResponseDetails[
         BlankNullSequence[]] := " "; 
      Clear[$CellContext`GetUserSolutions]; $CellContext`GetUserSolutions[] := 
       Flatten[
         Cases[
          Options[
           EvaluationNotebook[], TaggingRules], ("EIWLExercises" -> 
           Pattern[ElementaryIntroToWLWeb`Private`ex, 
             Blank[]]) :> ElementaryIntroToWLWeb`Private`ex, Infinity]]; 
      Clear[$CellContext`GetUserSolutionsTotal]; \
$CellContext`GetUserSolutionsTotal[] := Length[
         Union[
          Flatten[
           Cases[
            Cases[
             Options[
              EvaluationNotebook[], TaggingRules], ("EIWLExercises" -> 
              Pattern[ElementaryIntroToWLWeb`Private`ex, 
                Blank[]]) :> ElementaryIntroToWLWeb`Private`ex, Infinity], (
             "ExercisesTotal" -> Pattern[ElementaryIntroToWLWeb`Private`t, 
               Blank[]]) :> ElementaryIntroToWLWeb`Private`t, Infinity]]]]; 
      Clear[$CellContext`GetUserSolutionsTried]; \
$CellContext`GetUserSolutionsTried[] := Length[
         Union[
          Flatten[
           Cases[
            Cases[
             Options[
              EvaluationNotebook[], TaggingRules], ("EIWLExercises" -> 
              Pattern[ElementaryIntroToWLWeb`Private`ex, 
                Blank[]]) :> ElementaryIntroToWLWeb`Private`ex, Infinity], (
             "ExercisesTried" -> Pattern[ElementaryIntroToWLWeb`Private`t, 
               Blank[]]) :> ElementaryIntroToWLWeb`Private`t, Infinity]]]]; 
      Clear[$CellContext`GetUserSolutionsCorrect]; \
$CellContext`GetUserSolutionsCorrect[] := Length[
         Union[
          Flatten[
           Cases[
            Cases[
             Options[
              EvaluationNotebook[], TaggingRules], ("EIWLExercises" -> 
              Pattern[ElementaryIntroToWLWeb`Private`ex, 
                Blank[]]) :> ElementaryIntroToWLWeb`Private`ex, Infinity], (
             "ExercisesCorrect" -> Pattern[ElementaryIntroToWLWeb`Private`t, 
               Blank[]]) :> ElementaryIntroToWLWeb`Private`t, 
            
            Infinity]]]]; $CellContext`EIWLExerciseSolutionsTotal = \
$CellContext`GetUserSolutionsTotal[]; $CellContext`EIWLExerciseSolutionsTried = \
$CellContext`GetUserSolutionsTried[]; \
$CellContext`EIWLExerciseSolutionsCorrect = \
$CellContext`GetUserSolutionsCorrect[]; 
      Clear[$CellContext`SetUserSolutionsTried]; \
$CellContext`SetUserSolutionsTried[
         Pattern[ElementaryIntroToWLWeb`Private`value, 
          Blank[]]] := 
       Module[{ElementaryIntroToWLWeb`Private`data, 
          ElementaryIntroToWLWeb`Private`tr}, 
         ElementaryIntroToWLWeb`Private`data = Flatten[
            Cases[
             Options[
              EvaluationNotebook[], TaggingRules], ("EIWLExercises" -> 
              Pattern[ElementaryIntroToWLWeb`Private`ex, 
                Blank[]]) :> ElementaryIntroToWLWeb`Private`ex, Infinity]]; 
         ElementaryIntroToWLWeb`Private`tr = ReplaceAll[TaggingRules, 
            Options[
             EvaluationNotebook[], TaggingRules]]; 
         ElementaryIntroToWLWeb`Private`tr = 
          DeleteCases[
           ElementaryIntroToWLWeb`Private`tr, "EIWLExercises" -> Blank[], 
            Infinity]; 
         AppendTo[
          ElementaryIntroToWLWeb`Private`tr, 
           "EIWLExercises" -> {
            "ExercisesTotal" -> 
             ReplaceAll[
              "ExercisesTotal", ElementaryIntroToWLWeb`Private`data], 
             "ExercisesTried" -> Append[
               Flatten[
                Cases[
                ElementaryIntroToWLWeb`Private`data, ("ExercisesTried" -> 
                  Pattern[ElementaryIntroToWLWeb`Private`t, 
                    Blank[]]) :> ElementaryIntroToWLWeb`Private`t, Infinity]],
                ElementaryIntroToWLWeb`Private`value], "ExercisesCorrect" -> 
             ReplaceAll[
              "ExercisesCorrect", ElementaryIntroToWLWeb`Private`data]}]; 
         SetOptions[
           EvaluationNotebook[], TaggingRules -> 
           ElementaryIntroToWLWeb`Private`tr]; \
$CellContext`EIWLExerciseSolutionsTried = \
$CellContext`GetUserSolutionsTried[]; Null]; 
      Clear[$CellContext`SetUserSolutionsCorrect]; \
$CellContext`SetUserSolutionsCorrect[
         Pattern[ElementaryIntroToWLWeb`Private`value, 
          Blank[]]] := 
       Module[{ElementaryIntroToWLWeb`Private`data, 
          ElementaryIntroToWLWeb`Private`tr}, 
         ElementaryIntroToWLWeb`Private`data = Flatten[
            Cases[
             Options[
              EvaluationNotebook[], TaggingRules], ("EIWLExercises" -> 
              Pattern[ElementaryIntroToWLWeb`Private`ex, 
                Blank[]]) :> ElementaryIntroToWLWeb`Private`ex, Infinity]]; 
         ElementaryIntroToWLWeb`Private`tr = ReplaceAll[TaggingRules, 
            Options[
             EvaluationNotebook[], TaggingRules]]; 
         ElementaryIntroToWLWeb`Private`tr = 
          DeleteCases[
           ElementaryIntroToWLWeb`Private`tr, "EIWLExercises" -> Blank[], 
            Infinity]; 
         AppendTo[
          ElementaryIntroToWLWeb`Private`tr, 
           "EIWLExercises" -> {
            "ExercisesTotal" -> 
             ReplaceAll[
              "ExercisesTotal", ElementaryIntroToWLWeb`Private`data], 
             "ExercisesTried" -> 
             ReplaceAll[
              "ExercisesTried", ElementaryIntroToWLWeb`Private`data], 
             "ExercisesCorrect" -> Append[
               Flatten[
                Cases[
                ElementaryIntroToWLWeb`Private`data, ("ExercisesCorrect" -> 
                  Pattern[ElementaryIntroToWLWeb`Private`t, 
                    Blank[]]) :> ElementaryIntroToWLWeb`Private`t, Infinity]],
                ElementaryIntroToWLWeb`Private`value]}]; SetOptions[
           EvaluationNotebook[], TaggingRules -> 
           ElementaryIntroToWLWeb`Private`tr]; \
$CellContext`EIWLExerciseSolutionsCorrect = \
$CellContext`GetUserSolutionsCorrect[]; Null]; 
      Clear[ElementaryIntroToWLWeb`Private`GetCurrentTallyCell]; \
$CellContext`GetCurrentTallyCell[] := Module[{}, 
         With[{
          ElementaryIntroToWLWeb`Private`solutionsTried = \
$CellContext`GetUserSolutionsTried[], 
           ElementaryIntroToWLWeb`Private`solutionsTotal = \
$CellContext`GetUserSolutionsTotal[], 
           ElementaryIntroToWLWeb`Private`solutionsCorrect = \
$CellContext`GetUserSolutionsCorrect[]}, 
          Cell[
           BoxData[
            PaneBox[
             TemplateBox[{
               StyleBox[
               "COMPLETED\[ThickSpace]\[ThickSpace]", 
                "DockedCellCompletedExerciseText"], 
               StyleBox[
               ElementaryIntroToWLWeb`Private`solutionsTried, 
                "DockedCellCompletedExerciseText"], 
               StyleBox["/", "DockedCellSolutionDivider"], 
               StyleBox[
               ElementaryIntroToWLWeb`Private`solutionsTotal, 
                "DockedCellCompletedExerciseText"], 
               StyleBox[
               "\[ThinSpace]|\[ThinSpace]", "DockedCellSolutionDivider"], 
               StyleBox[
               ElementaryIntroToWLWeb`Private`solutionsCorrect, 
                "DockedCellCorrectExerciseText"], 
               StyleBox[
               "\[ThickSpace]\[ThickSpace]CORRECT", 
                "DockedCellCorrectExerciseText"]}, "RowDefault"], Alignment -> 
             Right, ImageSize -> Full]], "Output", TextAlignment -> Right, 
           CellFrame -> 1, CellMargins -> {{0, 0}, {10, 0}}, 
           CellFrameMargins -> {{14, 24}, {4, 7}}, CellFrameColor -> 
           RGBColor[1, 0.956862, 0.878431], MenuSortingValue -> 10000, 
           Background -> RGBColor[1, 0.956862, 0.878431], CellTags -> 
           "SolutionTallyCell"]]])]], "Output", CellMargins -> 0, 
   CellFrameMargins -> {{0, 24}, {3, 6}}, Background -> 
   RGBColor[0.97647, 0.482352, 0], CellFrame -> 1, CellFrameColor -> 
   RGBColor[0.97647, 0.482352, 0]], 
  Cell["SECOND EDITION", "Text", FontFamily -> "Source Sans Pro", 
   CellFrame -> {{0, 0}, {3, 0}}, ShowCellBracket -> False, 
   CellMargins -> {{0, 0}, {-1, -1}}, CellFrameMargins -> {{44, 0}, {2, 4}}, 
   CellFrameColor -> RGBColor[0.952941, 0.509804, 0], FontSize -> 10, 
   FontTracking -> "Extended", FontColor -> RGBColor[1, 0.929412, 0.721569], 
   Background -> RGBColor[0.862745, 0.309804, 0], CellTags -> 
   "DockedCellLogoCell"]},
TaggingRules->{
 "EIWLExercises" -> {
   "ExercisesTotal" -> {
     "33.1", "33.2", "33.3", "33.4", "33.5", "33.6", "33.7", "33.8"}, 
    "ExercisesTried" -> {}, "ExercisesCorrect" -> {}}},
FrontEndVersion->"11.1 for Mac OS X x86 (32-bit, 64-bit Kernel) (April 18, \
2017)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[StyleDefinitions -> "Default.nb"]], 
   Cell[
    CellGroupData[{
      Cell[
      "Style Environments", "Section", 
       CellChangeTimes -> {{3.64661165091824*^9, 3.646611654013329*^9}, 
         3.6485723794335403`*^9, 3.651347081728628*^9, 3.651347179462186*^9, 
         3.651347384135805*^9, 3.651348171662589*^9, {3.662385415502224*^9, 
         3.662385415587447*^9}, {3.662385986094821*^9, 
         3.662385986340312*^9}, {3.662386515144682*^9, 
         3.662386515438078*^9}, {3.662386561676188*^9, 
         3.662386561889332*^9}, {3.668356126688795*^9, 
         3.6683561270120687`*^9}, {3.670169943059537*^9, 
         3.670169943254141*^9}}], 
      Cell[
       StyleData[All, "Working"]], 
      Cell[
       StyleData[All, "Printout"], 
       PrintingOptions -> {
        "PageSize" -> {504, 720}, "PrintRegistrationMarks" -> True}, 
       Magnification -> 0.6]}, Closed]], 
   Cell[
    CellGroupData[{
      Cell[
      "Custom Styles", "Section", 
       CellChangeTimes -> {{3.646611660445352*^9, 3.646611669493331*^9}}], 
      Cell[
       StyleData["Notebook"], CreateCellID -> True, CellContext -> Notebook, 
       CellLabelAutoDelete -> False, DefaultNewCellStyle -> "Input", 
       ShowSyntaxStyles -> True, MenuSortingValue -> None], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Title"], CellMargins -> {{64, Inherited}, {50, 72}}, 
          MenuCommandKey -> None, FontFamily -> "Verdana", FontSize -> 42, 
          FontWeight -> "Bold", FontColor -> GrayLevel[0.4]], 
         Cell[
          StyleData["Title", "Printout"], 
          CellMargins -> {{64, Inherited}, {50, 72}}]}, Closed]], 
      Cell[
       StyleData["Chapter"], MenuCommandKey -> None], 
      Cell[
       StyleData["Subchapter"], MenuCommandKey -> None], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Section"], CellFrame -> {{0, 0}, {0, 0}}, CellDingbat -> 
          Cell[
            TextData[
             CounterBox["Section"], 
             StyleBox[
             "|\[NegativeThinSpace]", FontColor -> 
              RGBColor[
               0.9019607843137255, 0.4117647058823529, 0.027450980392156862`],
               FontFamily -> "Courier", FontSize -> 36, FontWeight -> Plain]],
             "SectionNumber"], CellMargins -> {{96, Inherited}, {12, 64}}, 
          Evaluatable -> True, CellGroupingRules -> {"SectionGrouping", 60}, 
          PageBreakAbove -> True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["Section", "Printout"], 
          CellMargins -> {{96, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionDoubleDigit"], CellFrame -> {{0, 0}, {0, 0}}, 
          CellDingbat -> Cell[
            TextData[
             CounterBox["Section"], 
             StyleBox[
             "|\[NegativeThinSpace]", FontColor -> 
              RGBColor[
               0.9019607843137255, 0.4117647058823529, 0.027450980392156862`],
               FontFamily -> "Courier", FontSize -> 36, FontWeight -> Plain]],
             "SectionNumber"], CellMargins -> {{112, Inherited}, {12, 64}}, 
          Evaluatable -> True, CellGroupingRules -> {"SectionGrouping", 60}, 
          PageBreakAbove -> True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["SectionDoubleDigit", "Printout"], 
          CellMargins -> {{112, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionNumber"], CellBaseline -> Baseline, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 26, FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SectionNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionInline"], FontFamily -> 
          "Source Sans Pro Semibold", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SectionInline", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionNoDingbat"], 
          CellMargins -> {{64, Inherited}, {12, 64}}, Evaluatable -> True, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakAbove -> 
          True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["SectionNoDingbat", "Printout"], 
          CellMargins -> {{64, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Exercise"], CellDingbat -> Cell[
            TextData[{"  ", 
              CounterBox["Section"], ".", 
              CounterBox["Exercise"]}], "ExerciseNumber", FontColor -> 
            RGBColor[
             0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
          ShowGroupOpener -> True, CellMargins -> {{90, 40}, {4, 18}}, 
          CellGroupingRules -> "InputGrouping", CounterIncrements -> 
          "Exercise", MenuSortingValue -> 10020, MenuCommandKey -> "2", 
          FontFamily -> "Source Sans Pro", FontSize -> 16, FontWeight -> 
          "Plain", FontSlant -> "Plain", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["Exercise", "Printout"], ShowGroupOpener -> False, 
          CellMargins -> {{110, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseNumber"], FontFamily -> "Source Sans Pro", 
          FontSize -> 16, FontWeight -> "Bold", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["ExerciseNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseInput", StyleDefinitions -> StyleData["Input"]], 
          CellMargins -> {{70, 30}, {4, 7}}, ShowCellLabel -> False, 
          CellFrameLabels -> {{None, None}, {None, None}}, SpanMaxSize -> 1, 
          FontSize -> 
          14, $CellContext`GeneratedCellStyles -> {
           "Output" -> "ExerciseOutput"}], 
         Cell[
          StyleData["ExerciseInput", "Printout"], 
          CellMargins -> {{88, 10}, {4, 7}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "ExerciseOutput", StyleDefinitions -> StyleData["Output"]], 
          CellMargins -> {{90, 40}, {0, 6}}, CellGroupingRules -> 
          "OutputGrouping", ShowCellLabel -> False, FontSize -> 14], 
         Cell[
          StyleData["ExerciseOutput", "Printout"], 
          CellMargins -> {{88, 10}, {10, 4}}]}, Closed]], 
      Cell[
       StyleData["ExerciseExpectedResult"], ShowCellBracket -> False, 
       ShowGroupOpener -> False, CellMargins -> {{90, 40}, {3, 9}}, 
       CellGroupingRules -> "InputGrouping", CounterIncrements -> "Exercise", 
       MenuSortingValue -> 10000, FontFamily -> "Source Sans Pro", FontSize -> 
       12, FontWeight -> "Plain", FontSlant -> "Plain"], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Picture"], CellMargins -> {{66, 10}, {10, 10}}, 
          CellGroupingRules -> "GraphicsGrouping", StyleMenuListing -> None], 
         
         Cell[
          StyleData["Picture", "Printout"], 
          CellMargins -> {{66, 10}, {8, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Tentative"], 
          CellBracketOptions -> {
           "Color" -> RGBColor[
             0.30000000000000016`, 0.6000000000000003, 0.7000000000000003], 
            "Thickness" -> 5}, Evaluatable -> False, CellFrameMargins -> 4, 
          StyleMenuListing -> None, Background -> 
          RGBColor[0.8500000000000003, 0.9500000000000003, 1]], 
         Cell[
          StyleData["Tentative", "Printout"], 
          CellElementSpacings -> {"CellMinHeight" -> 0.1}, CellOpen -> False, 
          CellFrameMargins -> 0, FontSize -> 0.1, Magnification -> 0.01]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["WebOnly"], 
          CellBracketOptions -> {
           "Color" -> RGBColor[0.91, 0.92, 0.9], "Thickness" -> 5}, 
          CellFrameMargins -> 4, StyleMenuListing -> None, Background -> 
          RGBColor[0.91, 0.92, 0.86]], 
         Cell[
          StyleData["WebOnly", "Printout"], 
          CellElementSpacings -> {"CellMinHeight" -> 0.1}, CellOpen -> False, 
          CellFrameMargins -> 0, FontSize -> 0.1, Magnification -> 0.01]}, 
        Closed]], 
      Cell[
       StyleData["Lockdown"], 
       CellBracketOptions -> {
        "Color" -> RGBColor[0.8, 0.5, 0.4], "Thickness" -> 3}, Evaluatable -> 
       False, StyleMenuListing -> None], 
      Cell[
       StyleData["InlineCode"], SpanMaxSize -> 0, FontColor -> GrayLevel[0]], 
      
      Cell[
       StyleData["ExpectedOutputNote"], Selectable -> False, FontFamily -> 
       "Source Sans Pro", FontColor -> GrayLevel[0.3]], 
      Cell[
       StyleData["EIWLTextLink"], LineBreakWithin -> False, 
       TemplateBoxOptions -> {DisplayFunction :> (TagBox[
           
           ButtonBox[#, Appearance -> None, ButtonData -> #2, 
            BaseStyle -> {
             "Hyperlink", FontWeight -> Bold, FontSize -> 16, FontFamily -> 
              "Source Sans Pro"}], 
           MouseAppearanceTag["LinkHand"]]& )}, 
       ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
      Cell[
       StyleData["CheckAnswerDividerCloud"], ShowCellBracket -> False, 
       CellMargins -> {{40, 40}, {3, 6}}, 
       CellBracketOptions -> {"OverlapContent" -> True}, 
       CellGroupingRules -> {"SectionGrouping", 40}, 
       CellFrameMargins -> {{20, 20}, {2, 2}}, TextAlignment -> Right], 
      Cell[
       StyleData["CodeSectionDividerCloud"], Editable -> False, Selectable -> 
       False, ShowCellBracket -> False, CellMargins -> {{0, 0}, {0, 35}}, 
       CellBracketOptions -> {"OverlapContent" -> True}, 
       CellElementSpacings -> {"CellMinHeight" -> 6}, 
       CellGroupingRules -> {"SectionGrouping", -5}, 
       CellFrameMargins -> {{20, 20}, {2, 2}}, DefaultNewCellStyle -> "Input",
        FontSize -> 6, Background -> GrayLevel[0.95]], 
      Cell[
       StyleData["InlineCode"], SpanMaxSize -> 0, FontColor -> GrayLevel[0]], 
      
      Cell[
       StyleData["InlineCodeText"], SpanMaxSize -> 0, FontFamily -> 
       "Source Sans Pro"], 
      Cell[
       StyleData["Input"], CellMargins -> {{92, 20}, {5, 8}}, 
       CellFrameLabels -> {{None, 
          
          DynamicModuleBox[{$CellContext`EIWLExerciseCheck = 
            Automatic, $CellContext`buttonLabel = " CHECK MY SOLUTION "}, 
           DynamicBox[
            ToBoxes[
             If[
              TrueQ[$CellContext`EIWLExerciseCheck == Automatic], 
              MouseAppearance[
               Tooltip[
                Button[
                 Framed[
                  Panel[
                   
                   Style[$CellContext`buttonLabel, FontFamily -> 
                    "Source Sans Pro", FontSize -> 10, FontColor -> 
                    RGBColor[0.953948, 0.305638, 0.0285344]], Appearance -> 
                   None, Background -> GrayLevel[1], 
                   FrameMargins -> {{2, 2}, {0, 0}}, ImageMargins -> 0], 
                  FrameStyle -> {
                    Thickness[Tiny], 
                    RGBColor[0.953948, 0.305638, 0.0285344]}, RoundingRadius -> 
                  3], 
                 
                 Block[{$CellContext`usersCell, $CellContext`solutionResult, \
$CellContext`exerciseNumber, $CellContext`exerciseSwitchResult}, \
$CellContext`exerciseNumber = StringJoin[
                    If[
                    TrueQ[CurrentValue[{"CounterValue", "WebOnly"}] == 1], 
                    "x", ""], 
                    ToString[
                    CurrentValue[{"CounterValue", "SectionNumber"}]], ".", 
                    ToString[
                    
                    CurrentValue[{
                    "CounterValue", 
                    "ExerciseNumber"}]]]; $CellContext`buttonLabel = 
                   Row[{" CHECKING ", 
                    ProgressIndicator[Appearance -> "Percolate"]}]; 
                  SelectionMove[
                    ButtonNotebook[], All, ButtonCell, AutoScroll -> 
                    False]; $CellContext`usersCell = NotebookRead[
                    InputNotebook[]]; If[
                    TrueQ[Length[
                    Flatten[{$CellContext`usersCell}]] == 
                    1], $CellContext`solutionResult = ToExpression[
                    URLFetch[
                    "https://www.wolframcloud.com/objects/user-9b23d046-b2a9-\
4a5c-8723-08465cce25ed/EIWLGradingAPI", "Method" -> "POST", 
                    "Parameters" -> {
                    "exNum" -> $CellContext`exerciseNumber, "answer" -> 
                    ToString[$CellContext`usersCell, InputForm, 
                    CharacterEncoding -> "ASCII"], "user" -> 
                    ToString[$WolframID], "referer" -> "eiwl-nb", "uuid" -> 
                    ToString[$WolframUUID]}]]; \
$CellContext`SolutionResponseText[$CellContext`exerciseNumber] = \
$CellContext`SolutionResponseDetails[
                    $CellContext`solutionResult["Text"], 
                    $CellContext`solutionResult[
                    "CorrectQ"]]; $CellContext`exerciseSwitchResult = Switch[
                    $CellContext`solutionResult["CorrectQ"], 
                    True, $CellContext`EIWLExerciseCheck = 
                    True; $CellContext`SetUserSolutionsCorrect[$CellContext`\
exerciseNumber]; \
$CellContext`SetUserSolutionsTried[$CellContext`exerciseNumber]; Null, 
                    
                    Blank[], $CellContext`EIWLExerciseCheck = 
                    False; $CellContext`SetUserSolutionsTried[$CellContext`\
exerciseNumber]], 
                    CloudSystem`CreateCloudDialog[
                    StyleBox[
                    "Select a cell to be checked.", Selectable -> False], 
                    WindowTitle -> " "]]], Appearance -> None, Evaluator -> 
                 Automatic, Method -> "Queued"], 
                "Click to check your solution.", TooltipDelay -> 0.15], 
               "LinkHand"], 
              If[
               TrueQ[$CellContext`EIWLExerciseCheck], 
               MouseAppearance[
                Button[
                 Framed[
                  Row[{
                    Panel[
                    Style[
                    ToExpression[
                    "\!\(\* GraphicsBox[ TagBox[RasterBox[CompressedData[\" \
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBLECOU2VJahIzkCECxFJADGKrbtYa \
RUMUpZzMcNnnQRWjMk5lf/vzDWggtYwCkgNiFDBAsPqCPFcBjcLURYkH0fRS \
HlZwE6gV7EATfvz98f3Pd6rEIBClncpMPZlJFaNGEd0QANRpOvM= \"], {{0, 20}, { 26, \
0}}, {0, 255}, ColorFunction->RGBColor], BoxForm`ImageTag[ \"Byte\", \
Interleaving -> True, Magnification -> 1], Selectable->False], \
BaseStyle->\"ImageGraphics\", ImageSize->Magnification[1], ImageSizeRaw->{26, \
20}, PlotRange->{{0, 26}, {0, 20}}]\)"], Selectable -> False], Background -> 
                    RGBColor[0.146944, 0.70164, 0.16466], 
                    FrameMargins -> {{5, 5}, {0, 0}}, ImageMargins -> 0, 
                    Appearance -> None], 
                    Panel[
                    Style[
                    " CORRECT ", FontSize -> 10, FontColor -> 
                    RGBColor[0.146944, 0.70164, 0.16466], FontFamily -> 
                    "Source Sans Pro"], Background -> White, 
                    FrameMargins -> {{5, 5}, {0, 0}}, Appearance -> None]}], 
                  FrameStyle -> {
                    Thickness[Tiny], 
                    RGBColor[0.146944, 0.70164, 0.16466]}, FrameMargins -> 0, 
                  RoundingRadius -> 3], $CellContext`buttonLabel = 
                  " CHECK MY SOLUTION "; $CellContext`EIWLExerciseCheck = 
                  Automatic, Appearance -> None], "LinkHand"], 
               MouseAppearance[
                Button[
                 Framed[
                  Row[{
                    Panel[
                    Style[
                    ToExpression[
                    "\!\(\* GraphicsBox[ TagBox[RasterBox[CompressedData[\" \
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBLECOU2VJahIzkCECxGJADGK/YtAZ \
RTRCb1W8PnhlYooDBYFSxJgAVPnvy7cPfrkogn65IEFsJmM3BKIeZggal1RD \
yNOOMOT7DyAiTzvlJlDoCwpDkvLYpDxFjSLyEAAHORZk \"], {{0, 20}, {22, 0}}, { 0, \
255}, ColorFunction->RGBColor], BoxForm`ImageTag[ \"Byte\", Interleaving -> \
True, Magnification -> 1], Selectable->False], BaseStyle->\"ImageGraphics\", \
ImageSize->Magnification[1], ImageSizeRaw->{22, 20}, PlotRange->{{0, 22}, {0, \
20}}]\)"], Selectable -> False], Background -> 
                    RGBColor[0.918257, 0, 0.172488], 
                    FrameMargins -> {{5, 5}, {0, 0}}, ImageMargins -> 0, 
                    Appearance -> None], 
                    Panel[
                    Style[
                    " TRY AGAIN ", FontSize -> 10, FontColor -> 
                    RGBColor[0.918257, 0, 0.172488], FontFamily -> 
                    "Source Sans Pro"], Background -> White, 
                    FrameMargins -> {{5, 5}, {0, 0}}, Appearance -> None]}], 
                  FrameStyle -> {
                    Thickness[Tiny], 
                    RGBColor[0.918257, 0, 0.172488]}, FrameMargins -> 0, 
                  RoundingRadius -> 3], $CellContext`buttonLabel = 
                  " CHECK MY SOLUTION "; $CellContext`EIWLExerciseCheck = 
                  Automatic, Appearance -> None], "LinkHand"]]], 
             StandardForm], ImageSizeCache -> {109., {9., 16.}}], 
           DynamicModuleValues :> {}]}, {None, None}}, 
       CellChangeTimes -> {{3.6688095471029243`*^9, 3.66880959932793*^9}}, 
       MenuSortingValue -> 10000, FontSize -> 15], 
      Cell[
       StyleData["Output"], Deletable -> True, ShowCellBracket -> True, 
       CellMargins -> {{92, 50}, {10, 5}}, 
       CellBracketOptions -> {"OverlapContent" -> True}, CellEditDuplicate -> 
       True, GeneratedCell -> True, CellAutoOverwrite -> True, 
       LinebreakAdjustments -> {1, 2., 12., 1.25, 1.}, MenuSortingValue -> 
       None, FontSize -> 15], 
      Cell[
       StyleData["Message"], 
       CellMargins -> {{92, Inherited}, {Inherited, Inherited}}], 
      Cell[
       StyleData["EmptyCell"], Editable -> False, Selectable -> False, 
       CellMargins -> {{0, 0}, {-2, 0}}, 
       CellElementSpacings -> {"CellMinHeight" -> 1}, MenuSortingValue -> 
       10000, FontSize -> 1], 
      Cell[
       StyleData["CellLabel"], MenuSortingValue -> 10000, FontColor -> 
       GrayLevel[0.6]], 
      Cell[
       StyleData["Link"], LineBreakWithin -> False, 
       TemplateBoxOptions -> {DisplayFunction :> (TagBox[
           
           ButtonBox[#, Appearance -> None, ButtonData -> #2, 
            BaseStyle -> {
             "Hyperlink", FontSize -> 15, FontFamily -> "Source Sans Pro"}], 
           MouseAppearanceTag["LinkHand"]]& )}, 
       ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
      Cell[
       StyleData["ExpectedOutputText"], FontFamily -> "Arial", FontSize -> 13,
        FontColor -> RGBColor[0.8579079880979629, 0.4263828488593881, 0.]], 
      Cell[
       StyleData["CodeSectionDividerCloud"], Selectable -> False, 
       ShowCellBracket -> False, CellMargins -> {{0, 0}, {0, 35}}, 
       CellBracketOptions -> {"OverlapContent" -> True}, 
       CellElementSpacings -> {"CellMinHeight" -> 6}, 
       CellGroupingRules -> {"SectionGrouping", -5}, 
       CellFrameMargins -> {{20, 20}, {2, 2}}, DefaultNewCellStyle -> 
       "EmptyCell", FontSize -> 6, Background -> GrayLevel[0.95]], 
      Cell[
       StyleData["DockedCellAuthorName"], MenuSortingValue -> 10000, 
       FontFamily -> "Source Sans Pro", FontSize -> 12, FontColor -> 
       RGBColor[1, 0.929411, 0.721568]], 
      Cell[
       StyleData["DockedCellSectionTitle"], MenuSortingValue -> 10000, 
       FontFamily -> "Source Sans Pro", FontSize -> 18, FontColor -> 
       GrayLevel[1]], 
      Cell[
       StyleData["DockedCellSecondCell"], CellFrame -> 1, 
       CellMargins -> {{0, 0}, {0, 0}}, 
       CellFrameMargins -> {{10, 10}, {10, 10}}, CellFrameColor -> 
       RGBColor[1, 0.956862, 0.878431], MenuSortingValue -> 10000, Background -> 
       RGBColor[1, 0.956862, 0.878431]], 
      Cell[
       StyleData["CompletedExerciseHeader"], MenuSortingValue -> 10000, 
       FontFamily -> "Source Sans Pro", FontSize -> 14, FontColor -> 
       GrayLevel[0.5]], 
      Cell[
       StyleData["DockedCellShareButton"], MenuSortingValue -> 10000, 
       FontFamily -> "Source Sans Pro", FontSize -> 13, FontColor -> 
       GrayLevel[1]], 
      Cell[
       StyleData["DockedCellLinksSections"], MenuSortingValue -> 10000, 
       FontFamily -> "Source Sans Pro", FontSize -> 14, FontWeight -> "Plain",
        FontSlant -> "Plain", FontColor -> RGBColor[0.97647, 0.482352, 0]], 
      Cell[
       StyleData["DockedCellLinksDivider"], MenuSortingValue -> 10000, 
       FontFamily -> "Courier", FontSize -> 18, FontWeight -> "Plain", 
       FontSlant -> "Plain", FontColor -> RGBColor[0.97647, 0.482352, 0]], 
      Cell[
       StyleData["DockedCellSectionTitleDivider"], MenuSortingValue -> 10000, 
       FontFamily -> "Courier", FontSize -> 24, FontWeight -> "Plain", 
       FontSlant -> "Plain", FontColor -> GrayLevel[1]], 
      Cell[
       StyleData["SolutionTrue"], MenuSortingValue -> 10000, FontFamily -> 
       "Source Sans Pro", FontSize -> 12, FontWeight -> "Plain", FontSlant -> 
       "Plain", FontColor -> RGBColor[0.12, 0.7, 0.22]], 
      Cell[
       StyleData["SolutionFalse"], MenuSortingValue -> 10000, FontFamily -> 
       "Source Sans Pro", FontSize -> 12, FontWeight -> "Plain", FontSlant -> 
       "Plain", FontColor -> RGBColor[0.94, 0.08, 0.2]], 
      Cell[
       StyleData["SolutionResponseText"], ShowStringCharacters -> False, 
       FontFamily -> "Source Sans Pro", FontSize -> 12, FontWeight -> "Plain",
        FontSlant -> "Plain", FontColor -> GrayLevel[1]], 
      Cell[
       StyleData["SolutionResponse"], ShowCellBracket -> False, 
       CellMargins -> {{24, 25}, {6, 0}}, 
       CellFrameMargins -> {{8, 0}, {0, 12}}, TextAlignment -> Right, 
       ShowStringCharacters -> False, FontFamily -> "Source Sans Pro", 
       FontSize -> 12, FontWeight -> "Plain", FontSlant -> "Plain", 
       Background -> GrayLevel[1]], 
      Cell[
       StyleData["DockedCellCompletedExerciseText"], MenuSortingValue -> 
       10000, FontFamily -> "Source Sans Pro", FontSize -> 12, FontWeight -> 
       "Plain", FontSlant -> "Plain", FontColor -> GrayLevel[0.4]], 
      Cell[
       StyleData["DockedCellSolutionDivider"], MenuSortingValue -> 10000, 
       FontFamily -> "Courier", FontSize -> 16, FontWeight -> "Plain", 
       FontSlant -> "Plain", FontColor -> GrayLevel[0.6]], 
      Cell[
       StyleData["DockedCellCorrectExerciseText"], MenuSortingValue -> 10000, 
       FontFamily -> "Source Sans Pro", FontSize -> 12, FontWeight -> "Plain",
        FontSlant -> "Plain", FontColor -> RGBColor[0.12, 0.7, 0.22]], 
      Cell[
       CellGroupData[{
         Cell[
         "EIWL Cloud Link styles", "Subsubsection", 
          CellChangeTimes -> {{3.663512229965006*^9, 3.66351224118613*^9}}], 
         Cell[
          StyleData["EIWLTextLink"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 16, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkAnswer"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkCodeCaption"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontColor -> GrayLevel[0.6], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkExercise"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkExerciseNote"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkInlineCode"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkMoreExplore"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkQuestion"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontWeight -> Bold, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkTechNote"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkText"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 17, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkInlineCodeLink"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 17, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkVocabularyTable"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
         "EIWL Cloud Link", "Subsubsection", 
          CellChangeTimes -> {{3.664234597774767*^9, 3.664234605661516*^9}}], 
         
         Cell[
          StyleData["CodeLinkAnswer"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkCodeCaption"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontColor -> GrayLevel[0.6], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkExercise"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkQuestion"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontWeight -> Bold, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkTechNote"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkText"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 17, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkVocabularyTable"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkVocabularyTable3Column"], LineBreakWithin -> 
          False, TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkAnswer"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkCodeCaption"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontColor -> GrayLevel[0.6], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkExercise"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkExerciseNote"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkIndex"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkIndexSubentry"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkMoreExplore"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkQuestion"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontWeight -> Bold, FontColor -> 
                 GrayLevel[0], FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkTechNote"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkText"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 16, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkVocabularyTable"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}]}, 
        Closed]]}, Open]]}, Visible -> False, FrontEndVersion -> 
  "11.1 for Mac OS X x86 (32-bit, 64-bit Kernel) (April 18, 2017)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "FirstInputCell"->{
  Cell[7157, 192, 813, 26, 
  70, "Input", "ExpressionUUID" -> "ec57d6b5-2a01-4e55-9b59-6b431c089efb",
   CellTags->"FirstInputCell"],
  Cell[27894, 619, 813, 26, 
  70, "Input", "ExpressionUUID" -> "dd1ddd38-55db-42a2-a146-a5556f93500a",
   CellTags->"FirstInputCell"],
  Cell[36678, 860, 813, 26, 
  70, "Input", "ExpressionUUID" -> "f655a207-1c40-453c-be54-ca8d009e036a",
   CellTags->"FirstInputCell"],
  Cell[84779, 1739, 813, 26, 
  70, "Input", "ExpressionUUID" -> "1a7fe815-bb22-425c-a9aa-620608579d63",
   CellTags->"FirstInputCell"],
  Cell[96897, 2033, 813, 26, 
  70, "Input", "ExpressionUUID" -> "3ad69a2e-d2a5-4c73-90e3-47a5997d139a",
   CellTags->"FirstInputCell"],
  Cell[206200, 3920, 813, 26, 
  70, "Input", "ExpressionUUID" -> "12b32f9c-8de9-4fca-8d0f-1fbbc5b1b093",
   CellTags->"FirstInputCell"],
  Cell[442393, 7878, 813, 26, 
  70, "Input", "ExpressionUUID" -> "4df08e4a-2ce7-4029-9efc-ee1674a9b441",
   CellTags->"FirstInputCell"],
  Cell[451355, 8123, 813, 26, 
  70, "Input", "ExpressionUUID" -> "7e17c395-2302-4afa-bc85-d9020b7cf5b4",
   CellTags->"FirstInputCell"]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"FirstInputCell", 510216, 9342}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[654, 22, 495, 14, 70, "Exercise", "ExpressionUUID" -> \
"4d14e2a5-9794-4b4d-933d-be1cfb80ed5b",
 CounterAssignments->{{"SectionNumber", 33}, {"ExerciseNumber", 1}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[1174, 40, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"618a0e36-ef28-4279-bf0e-4984a2e1935c"],
Cell[1813, 61, 4737, 106, 70, "ExerciseOutput", "ExpressionUUID" -> \
"3ac7e39d-ef52-4ea4-bcea-746665ea0870"]
}, Closed]],
Cell[CellGroupData[{
Cell[6587, 172, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"d6d4266c-0d85-47f7-9d83-24c886d1a70d"],
Cell[7157, 192, 813, 26, 70, "Input", "ExpressionUUID" -> \
"ec57d6b5-2a01-4e55-9b59-6b431c089efb",
 CellTags->"FirstInputCell"]
}, Open  ]],
Cell[CellGroupData[{
Cell[8007, 223, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"bd5fffc6-2167-485f-9635-0ca400ef21cf"],
Cell[8294, 234, 616, 16, 70, "Exercise", "ExpressionUUID" -> \
"d6d06ea6-755c-43df-9f06-69bd68d7d8fc",
 CounterAssignments->{{"SectionNumber", 33}, {"ExerciseNumber", 2}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[8935, 254, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"51261cfd-49a2-4a57-8b58-131cd7312692"],
Cell[9574, 275, 17713, 319, 70, "ExerciseOutput", "ExpressionUUID" -> \
"c9243a7c-94f7-4850-b26c-573d5f3ec4fd"]
}, Closed]],
Cell[CellGroupData[{
Cell[27324, 599, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"3dceb767-40f0-48ba-aaee-9d23d6e317b8"],
Cell[27894, 619, 813, 26, 70, "Input", "ExpressionUUID" -> \
"dd1ddd38-55db-42a2-a146-a5556f93500a",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[28756, 651, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"d39a861c-9800-41c2-8d78-f44f89b78d89"],
Cell[29043, 662, 1018, 32, 70, "Exercise", "ExpressionUUID" -> \
"c98135dd-6f88-47b0-8abd-6b7c4e4b97ed",
 CounterAssignments->{{"SectionNumber", 33}, {"ExerciseNumber", 3}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[30086, 698, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"a4860157-4a5e-4fb1-9dfb-0eed1959606b"],
Cell[30725, 719, 5346, 116, 70, "ExerciseOutput", "ExpressionUUID" -> \
"29ba9b8c-b22c-48f8-af2d-f73afe9eef92"]
}, Closed]],
Cell[CellGroupData[{
Cell[36108, 840, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"322cd2da-acd9-42b8-b8a7-9298df5c5f1b"],
Cell[36678, 860, 813, 26, 70, "Input", "ExpressionUUID" -> \
"f655a207-1c40-453c-be54-ca8d009e036a",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[37540, 892, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"af225f84-b9fa-467e-b184-bbe7bbe720ae"],
Cell[37827, 903, 763, 21, 70, "Exercise", "ExpressionUUID" -> \
"c64c1bae-63b5-41c1-9139-b470142543da",
 CounterAssignments->{{"SectionNumber", 33}, {"ExerciseNumber", 4}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[38615, 928, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"0000df81-4247-40b4-9c2f-21461f67ab41"],
Cell[39254, 949, 44918, 765, 70, "ExerciseOutput", "ExpressionUUID" -> \
"515339d2-9256-403a-8842-4edbb540f30b"]
}, Closed]],
Cell[CellGroupData[{
Cell[84209, 1719, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"cd0e9940-8282-41e6-b77e-a8bd457f3ae4"],
Cell[84779, 1739, 813, 26, 70, "Input", "ExpressionUUID" -> \
"1a7fe815-bb22-425c-a9aa-620608579d63",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[85641, 1771, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"12018e37-a834-4799-964e-54607e84b23d"],
Cell[85928, 1782, 1029, 30, 70, "Exercise", "ExpressionUUID" -> \
"277af463-1865-4a89-a8b3-9a50f1b34f99",
 CounterAssignments->{{"SectionNumber", 33}, {"ExerciseNumber", 5}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[86982, 1816, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"4fa6ded1-e5cd-4361-9df6-2b7aa80cccba"],
Cell[87621, 1837, 8669, 171, 70, "ExerciseOutput", "ExpressionUUID" -> \
"c3b0229e-eba4-4cd3-9b0a-f7dafd2ec99a"]
}, Closed]],
Cell[CellGroupData[{
Cell[96327, 2013, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"5bf33b17-5550-4028-8aa1-4fca1b54664e"],
Cell[96897, 2033, 813, 26, 70, "Input", "ExpressionUUID" -> \
"3ad69a2e-d2a5-4c73-90e3-47a5997d139a",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[97759, 2065, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"3689dae2-0425-4942-95d9-04a1e8d0e647"],
Cell[98046, 2076, 981, 29, 70, "Exercise", "ExpressionUUID" -> \
"dc2cf78f-1624-48e7-a08a-c3bda8f7187d",
 CounterAssignments->{{"SectionNumber", 33}, {"ExerciseNumber", 6}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[99052, 2109, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"c43f68c9-5972-4450-a4f5-119355603f46"],
Cell[99691, 2130, 105902, 1765, 70, "ExerciseOutput", "ExpressionUUID" -> \
"af3da347-b29e-4afe-82c7-6514cd0e78a8"]
}, Closed]],
Cell[CellGroupData[{
Cell[205630, 3900, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"97fd6689-84f8-45b4-a76f-ba3934d3674f"],
Cell[206200, 3920, 813, 26, 70, "Input", "ExpressionUUID" -> \
"12b32f9c-8de9-4fca-8d0f-1fbbc5b1b093",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[207062, 3952, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"254dde59-21b7-404f-b6dd-8ab6fdebb41e"],
Cell[207349, 3963, 557, 13, 70, "Exercise", "ExpressionUUID" -> \
"060d709a-4315-4b17-8a19-fa6de47f9bf3",
 CounterAssignments->{{"SectionNumber", 33}, {"ExerciseNumber", 7}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[207931, 3980, 656, 20, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"5228939d-ff68-4e64-93fd-26143373cffa"],
Cell[208590, 4002, 233196, 3851, 70, "ExerciseOutput", "ExpressionUUID" -> \
"04cefa3f-bc47-4910-b736-6e1373606790"]
}, Closed]],
Cell[CellGroupData[{
Cell[441823, 7858, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"26400ae0-3137-4d25-907a-6ede7bc903a5"],
Cell[442393, 7878, 813, 26, 70, "Input", "ExpressionUUID" -> \
"4df08e4a-2ce7-4029-9efc-ee1674a9b441",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[443255, 7910, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"dab246d8-5ea9-4980-a3f0-5ebe1403fac3"],
Cell[443542, 7921, 1025, 32, 70, "Exercise", "ExpressionUUID" -> \
"d83927eb-ed17-4e08-941e-f903038113a8",
 CounterAssignments->{{"SectionNumber", 33}, {"ExerciseNumber", 8}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[444592, 7957, 656, 20, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"eff4c6db-fff7-4f57-9a89-85417a7881e5"],
Cell[445251, 7979, 5497, 119, 70, "ExerciseOutput", "ExpressionUUID" -> \
"c6aa9372-0a52-494b-b7b6-a2a1484afc71"]
}, Closed]],
Cell[CellGroupData[{
Cell[450785, 8103, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"f71576f6-6d01-4ea6-8e09-0c1db66c2011"],
Cell[451355, 8123, 813, 26, 70, "Input", "ExpressionUUID" -> \
"7e17c395-2302-4afa-bc85-d9020b7cf5b4",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[452195, 8153, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"4b837152-d333-45b8-8f70-13800fe42bb2"]
}
]
*)

(* End of internal cache information *)
(* NotebookSignature FTsAyAu8D0jaajeooKmc3@8y *)
