(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    500156,      11947]
NotebookOptionsPosition[    391452,       9779]
NotebookOutlinePosition[    485760,      11704]
CellTagsIndexPosition[    485242,      11682]
WindowTitle->Patterns: Elementary Introduction to the Wolfram Language
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
 InterpretationBox[Cell[
  "Patterns", "SectionInline",ExpressionUUID->
   "aab04998-2613-4d24-b3ee-405354bd7593"],
  $Line = 0; Null]], "SectionDoubleDigit",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CounterAssignments->{{"Section", 31}, {"Subsection", 0}, {
   "Subsubsection", 0}, {"Exercise", 0}},
 CellTags->"p:193",
 CellLabel->"In[19]:=",ExpressionUUID->"671f896c-c863-4801-81d7-6a48af0d6b9c"],

Cell[TextData[{
 StyleBox["Patterns",
  FontSlant->"Italic"],
 " are a fundamental concept in the Wolfram Language. The pattern ",
 Cell[BoxData[
  ButtonBox["_",
   BaseStyle->"Link",
   ButtonData->"Blank"]], "InlineCodeText",ExpressionUUID->
  "70d0e94b-2331-4d02-bc9b-74b908ffa233"],
 " (read \[OpenCurlyDoubleQuote]blank\[CloseCurlyDoubleQuote]) stands for \
anything."
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:1",ExpressionUUID->"eececbce-3bd7-4418-928a-b39828205f24"],

Cell[TextData[{
 ButtonBox["MatchQ",
  BaseStyle->"Link"],
 " tests whether something matches a pattern."
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:2",ExpressionUUID->"cb58f350-215e-482a-b980-b112a797a806"],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"a", ",", "x", ",", "b"}], "}"}]], "InlineCode",ExpressionUUID->
  "a0cb0659-16bf-43a7-be68-ccdb7c6ddf82"],
 " matches the pattern ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    ButtonBox["_",
     BaseStyle->"Link",
     ButtonData->"Blank"], ",", "x", ",", 
    ButtonBox["_",
     BaseStyle->"Link",
     ButtonData->"Blank"]}], "}"}]], "InlineCode",ExpressionUUID->
  "5737a22f-5acf-47f2-8d1c-b67da716f106"],
 ": "
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"0145feda-f188-450d-95b0-4d64e3db6543"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatchQ", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "x", ",", "b"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"_", ",", "x", ",", "_"}], "}"}]}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[1]:=",ExpressionUUID->"07d0cece-e533-4e20-8cef-0c8fe310efad"],

Cell[BoxData["True"], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[1]=",ExpressionUUID->"81d8cc93-a166-4b91-9412-0acd6ad64695"]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c"}], "}"}]], "InlineCode",ExpressionUUID->
  "4dc36485-ea93-47ab-b41a-4d94bc48f7a0"],
 " doesn\[CloseCurlyQuote]t match, because it has ",
 Cell[BoxData[
 "b"], "InlineCode",ExpressionUUID->"a018f558-a812-465f-bff5-802733927d17"],
 " in the middle, rather than ",
 Cell[BoxData[
 "x"], "InlineCode",ExpressionUUID->"30115470-ba96-4c65-9fe8-b6f9c8ccfc15"],
 ":"
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"498eb548-c7cd-47d4-bde4-c7788c0c0795"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatchQ", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"_", ",", "x", ",", "_"}], "}"}]}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[2]:=",ExpressionUUID->"b9f912d2-6586-4f27-b1f4-33db425de9e8"],

Cell[BoxData["False"], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[2]=",ExpressionUUID->"cec05704-be97-4bc3-8f2a-54ab850e4b78"]
}, Open  ]],

Cell[TextData[{
 "Any list with two elements matches the pattern ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    ButtonBox["_",
     BaseStyle->"Link",
     ButtonData->"Blank"], ",", 
    ButtonBox["_",
     BaseStyle->"Link",
     ButtonData->"Blank"]}], "}"}]], "InlineCode",ExpressionUUID->
  "1e40390b-ff08-453d-8b42-23ddf47837f0"],
 ":"
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"e14e2cb5-b73b-4890-aad9-dfa7e57ca7bd"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatchQ", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "a"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"_", ",", "_"}], "}"}]}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[3]:=",ExpressionUUID->"d83cc40d-e3fc-4343-81ff-e86e24469bec"],

Cell[BoxData["True"], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[3]=",ExpressionUUID->"5e72cda6-18a3-4477-a04f-44d0c5e5baee"]
}, Open  ]],

Cell[TextData[{
 "A list with three elements doesn\[CloseCurlyQuote]t match the pattern ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    ButtonBox["_",
     BaseStyle->"Link",
     ButtonData->"Blank"], ",", 
    ButtonBox["_",
     BaseStyle->"Link",
     ButtonData->"Blank"]}], "}"}]], "InlineCode",ExpressionUUID->
  "a402693a-b20f-4fea-9d0a-70fe5d1aeb20"],
 ":"
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"78e85923-aa9a-4160-97ae-43fe0a9c2bc1"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatchQ", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "a", ",", "a"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"_", ",", "_"}], "}"}]}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[4]:=",ExpressionUUID->"9ca20112-c7c1-424e-9d60-96dfb594297c"],

Cell[BoxData["False"], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[4]=",ExpressionUUID->"b80cfffa-2c53-4992-b505-819a144b48b7"]
}, Open  ]],

Cell[TextData[{
 ButtonBox["MatchQ",
  BaseStyle->"Link"],
 " lets you test one thing at a time against a pattern. ",
 ButtonBox["Cases",
  BaseStyle->"Link"],
 " lets you pick out all the elements (\[OpenCurlyDoubleQuote]cases\
\[CloseCurlyDoubleQuote]) in a list that match a particular pattern. "
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:3",ExpressionUUID->"0cb1a94a-aa14-41f6-a5f6-4087000a3848"],

Cell[TextData[{
 "Find all elements that match the pattern ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    ButtonBox["_",
     BaseStyle->"Link",
     ButtonData->"Blank"], ",", 
    ButtonBox["_",
     BaseStyle->"Link",
     ButtonData->"Blank"]}], "}"}]], "InlineCode",ExpressionUUID->
  "4c7bc853-bd8c-48bc-8942-2069f35b6dc2"],
 ":"
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"2efe5c09-83b8-4625-8d6f-48600a24e3dd"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Cases", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "a"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"b", ",", "a"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"b", ",", "b"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c", ",", "a"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"b", ",", "b", ",", "b"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"_", ",", "_"}], "}"}]}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[5]:=",ExpressionUUID->"e64374bf-97a6-4062-bd14-25c5ea9baf75"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "a"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "a"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "b"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", "a"}], "}"}]}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[5]=",ExpressionUUID->"f5b802a4-67fd-410f-955c-c7a11fc381b1"]
}, Open  ]],

Cell[TextData[{
 "Find all elements that match ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"b", ",", 
    ButtonBox["_",
     BaseStyle->"Link",
     ButtonData->"Blank"]}], "}"}]], "InlineCode",ExpressionUUID->
  "b5d65e28-6306-4b69-a8a3-6e81bf926529"],
 " (i.e. cases of ",
 Cell[BoxData[
 "b"], "InlineCode",ExpressionUUID->"cc6a9188-2cca-4583-96c0-a6e22102f7f2"],
 " followed by something):"
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"26744443-e2da-4094-b630-dcd66221a389"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Cases", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "a"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"b", ",", "a"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"b", ",", "b"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c", ",", "a"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"b", ",", "b", ",", "b"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "_"}], "}"}]}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[6]:=",ExpressionUUID->"316a63c1-bc7a-4914-902c-91520745a5ff"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"b", ",", "a"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "b"}], "}"}]}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[6]=",ExpressionUUID->"46f93da9-c292-499c-936f-3271c0ac3798"]
}, Open  ]],

Cell[TextData[{
 "This is what you get if you test whether each element matches ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"b", ",", 
    ButtonBox["_",
     BaseStyle->"Link",
     ButtonData->"Blank"]}], "}"}]], "InlineCode",ExpressionUUID->
  "1ed22cdd-1b55-4a26-bab5-28697ee185a2"],
 ":"
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"4bedc9ee-cb03-4e5b-a61d-58acbb325a7c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"MatchQ", "[", 
    RowBox[{"#", ",", 
     RowBox[{"{", 
      RowBox[{"b", ",", "_"}], "}"}]}], "]"}], "&"}], "/@", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a", ",", "a"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"b", ",", "a"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"b", ",", "b"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"c", ",", "a"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"b", ",", "b", ",", "b"}], "}"}]}], "}"}]}]], "Input",
 Deletable->False,
 CellLabel->"In[7]:=",ExpressionUUID->"aa06765e-0d58-4403-a8b5-251e5a292f78"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "False", ",", "True", ",", "False", ",", "True", ",", "False", ",", 
   "False"}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[7]=",ExpressionUUID->"2dc899ac-a2ea-47b7-9847-725f29a29731"]
}, Open  ]],

Cell[TextData[{
 "Using ",
 ButtonBox["Select",
  BaseStyle->"Link"],
 " to select what matches gives the same result as ",
 ButtonBox["Cases",
  BaseStyle->"Link"],
 ":"
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:4",ExpressionUUID->"a92eda7d-7986-4003-a373-8b3e1143778d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Select", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "a"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"b", ",", "a"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"b", ",", "b"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c", ",", "a"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"b", ",", "b", ",", "b"}], "}"}]}], "}"}], ",", 
   RowBox[{
    RowBox[{"MatchQ", "[", 
     RowBox[{"#", ",", 
      RowBox[{"{", 
       RowBox[{"b", ",", "_"}], "}"}]}], "]"}], "&"}]}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[8]:=",ExpressionUUID->"db4dc834-673d-478d-997b-a97ebd428d04"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"b", ",", "a"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "b"}], "}"}]}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellTags->"LastCellOfAPage",
 CellLabel->"Out[8]=",ExpressionUUID->"314c49b0-dd8c-4074-87a7-109a8da69387"]
}, Open  ]],

Cell[TextData[{
 "In a pattern, ",
 Cell[BoxData[
  RowBox[{"a", "|", "b"}]], "InlineCodeText",ExpressionUUID->
  "a607483f-70e2-42ef-96d2-4659b0019bba"],
 " indicates \[OpenCurlyDoubleQuote]either a or b\[CloseCurlyDoubleQuote]."
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:5",ExpressionUUID->"f94d36a1-2f2a-4ee7-975f-85a9de4f503c"],

Cell[TextData[{
 "Find all cases of either ",
 Cell[BoxData[
 "a"], "InlineCode",ExpressionUUID->"c6bd0660-5aba-4d27-9455-2cf31ad886fa"],
 " or ",
 Cell[BoxData[
 "b"], "InlineCode",ExpressionUUID->"6b6fc1ea-8f25-4d00-98cf-fa457b115e5a"],
 ", followed by something:"
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"2097a7b4-ab1d-4f94-bc4e-51440354d521"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Cases", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "a"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"b", ",", "a"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"b", ",", "b"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c", ",", "a"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"b", ",", "b", ",", "b"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", "|", "b"}], ",", "_"}], "}"}]}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[9]:=",ExpressionUUID->"b0cbb6af-b88c-44af-b764-1b1e218fb262"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "a"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "a"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "b"}], "}"}]}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[9]=",ExpressionUUID->"e1beb00d-d463-4443-988e-08d5dbc2b061"]
}, Open  ]],

Cell["\<\
Let\[CloseCurlyQuote]s look at another example, based on creating a list, \
then picking out elements that match particular patterns. \
\>", "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"40959899-eb85-4ae5-93ea-b76d65cb2313"],

Cell["Create a list by getting the digits of a range of numbers:", \
"CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"2f4c62ed-4bf6-4e70-b2c9-443e00d1d2c6"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"IntegerDigits", "[", 
  RowBox[{"Range", "[", 
   RowBox[{"100", ",", "500", ",", "55"}], "]"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[10]:=",ExpressionUUID->"013b2dfa-fb8c-4586-94f8-8d559e5b22e4"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "5", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "1", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "6", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "2", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "7", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "3", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "8", ",", "5"}], "}"}]}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[10]=",ExpressionUUID->"cc28f602-bf08-4e87-a490-d40640132326"]
}, Open  ]],

Cell["Find cases that end in 5:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"a4004b8b-8e79-4376-b7f1-49e62ab11b28"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Cases", "[", 
  RowBox[{
   RowBox[{"IntegerDigits", "[", 
    RowBox[{"Range", "[", 
     RowBox[{"100", ",", "500", ",", "55"}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"_", ",", "_", ",", "5"}], "}"}]}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[11]:=",ExpressionUUID->"2e85fa0b-5bb4-4c26-9cf6-c11e567f7c9d"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "5", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "6", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "7", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "8", ",", "5"}], "}"}]}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[11]=",ExpressionUUID->"46d9d134-e2d5-4e34-ae0d-2300f2d97b24"]
}, Open  ]],

Cell["Find cases with 1 or 2 in the middle:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"3477d5d8-4456-4631-99aa-696d6df148b5"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Cases", "[", 
  RowBox[{
   RowBox[{"IntegerDigits", "[", 
    RowBox[{"Range", "[", 
     RowBox[{"100", ",", "500", ",", "55"}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"_", ",", 
     RowBox[{"1", "|", "2"}], ",", "_"}], "}"}]}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[12]:=",ExpressionUUID->"a6a7994e-db3c-43d5-a2d2-d035ed5e064f"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2", ",", "1", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "2", ",", "0"}], "}"}]}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[12]=",ExpressionUUID->"60d6870e-2871-4110-b424-96ce8fd8b1ce"]
}, Open  ]],

Cell[TextData[{
 "The notation ",
 Cell[BoxData[
  ButtonBox["__",
   BaseStyle->"Link",
   ButtonData->"BlankSequence"]], "InlineCodeText",ExpressionUUID->
  "1d0d98e8-7065-4ac4-913c-a8d51634a58e"],
 " (\[OpenCurlyDoubleQuote]double blank\[CloseCurlyDoubleQuote]) in a pattern \
indicates any sequence of things."
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:6",ExpressionUUID->"6d4c4e41-175f-4ef7-8e1c-9b8c71835e6b"],

Cell[TextData[{
 "Find cases consisting of any sequence, ending with ",
 Cell[BoxData[
 "b"], "InlineCode",ExpressionUUID->"04d9366d-0009-43eb-843b-7fd4428b7020"],
 ":"
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"b3c48959-914c-414b-8df4-7b13c1bb274f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Cases", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "a"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"b", ",", "a"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"b", ",", "b"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c", ",", "a"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"b", ",", "b", ",", "b"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"__", ",", "b"}], "}"}]}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[13]:=",ExpressionUUID->"66d9e17a-fadb-4946-9612-de266047bb66"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"b", ",", "b"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "b", ",", "b"}], "}"}]}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[13]=",ExpressionUUID->"2d86d981-68a7-45c3-a443-1697250b54e8"]
}, Open  ]],

Cell[TextData[{
 "Find sequences ending with ",
 Cell[BoxData[
 "a"], "InlineCode",ExpressionUUID->"c38fa6c1-69ed-4b8b-84c8-7181cf96bc88"],
 " or ",
 Cell[BoxData[
 "b"], "InlineCode",ExpressionUUID->"8d8b34d9-ca07-46f1-a73b-4bb783fd372a"],
 ", or beginning with ",
 Cell[BoxData[
 "c"], "InlineCode",ExpressionUUID->"bcabe343-40c9-449e-b152-0ae04a567aa3"],
 ":"
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"bc2fdcf2-acb7-4a81-bbdc-209d2a5fde3a"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Cases", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "a"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"b", ",", "a"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"b", ",", "b"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c", ",", "a"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"b", ",", "b", ",", "b"}], "}"}]}], "}"}], ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"__", ",", 
      RowBox[{"a", "|", "b"}]}], "}"}], "|", 
    RowBox[{"{", 
     RowBox[{"c", ",", "__"}], "}"}]}]}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[14]:=",ExpressionUUID->"c00d2bdb-90fd-4f62-a0c9-2446ee7f66eb"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "a"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "a"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "b"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", "a"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "b", ",", "b"}], "}"}]}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[14]=",ExpressionUUID->"c6ef3a8a-024d-4aae-b698-0d77b8815fd6"]
}, Open  ]],

Cell["\<\
Patterns aren\[CloseCurlyQuote]t just about lists; they can involve anything. \
\>", "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"0a53a32a-6111-4550-b62b-70a6d96ccad4"],

Cell[TextData[{
 "Pick out cases that match the pattern ",
 Cell[BoxData[
  RowBox[{"f", "[", 
   ButtonBox[
    ButtonBox["_",
     BaseStyle->"Link",
     ButtonData->"Blank"],
    BaseStyle->"Link",
    ButtonData->"Blank"], "]"}]], "InlineCode",ExpressionUUID->
  "2d9fab10-8e9d-4a78-8011-c253bfb36882"],
 ":"
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"9edbffb7-7331-40dd-87ea-fdf0db85bb17"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Cases", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"f", "[", "1", "]"}], ",", 
     RowBox[{"g", "[", 
      RowBox[{"2", ",", "3"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
     RowBox[{"f", "[", "x", "]"}], ",", 
     RowBox[{"f", "[", 
      RowBox[{"x", ",", "x"}], "]"}]}], "}"}], ",", 
   RowBox[{"f", "[", "_", "]"}]}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[15]:=",ExpressionUUID->"19caebde-9e3d-45a0-aaa3-7abc7c3b8be1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"f", "[", "1", "]"}], ",", 
   RowBox[{"f", "[", "x", "]"}]}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[15]=",ExpressionUUID->"e02ead1d-fc61-438b-b4e5-2327ae8c33d6"]
}, Open  ]],

Cell[TextData[{
 "One of the many uses of patterns is to define replacements. ",
 Cell[BoxData[
  ButtonBox["/.",
   BaseStyle->"Link",
   ButtonData->"ReplaceAll"]], "InlineCodeText",ExpressionUUID->
  "3cce40d0-153e-49da-85a1-16ba07ca4ba4"],
 " (\[OpenCurlyDoubleQuote]slash dot\[CloseCurlyDoubleQuote]) performs a \
replacement."
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:7",ExpressionUUID->"e4432c45-477b-4ee1-9237-0d20b6961305"],

Cell[TextData[{
 "Replace b ",
 "with",
 " ",
 ButtonBox["Red",
  BaseStyle->"Link"],
 " in a list:"
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"ec9d9071-e1d7-49a3-b79a-82676b393dcf"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
   "a", ",", "b", ",", "a", ",", "a", ",", "b", ",", "b", ",", "a", ",", 
    "b"}], "}"}], " ", "/.", " ", 
  RowBox[{"b", "\[Rule]", "Red"}]}]], "Input",
 Deletable->False,
 CellLabel->"In[16]:=",ExpressionUUID->"28cdfb17-7ba0-4e1b-bfbe-45056ffaffeb"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", 
   InterpretationBox[
    ButtonBox[
     TooltipBox[
      GraphicsBox[{
        {GrayLevel[0], RectangleBox[{0, 0}]}, 
        {GrayLevel[0], RectangleBox[{1, -1}]}, 
        {RGBColor[1, 0, 0], RectangleBox[{0, -1}, {2, 1}]}},
       AspectRatio->1,
       Frame->True,
       FrameStyle->RGBColor[0.6666666666666666, 0., 0.],
       FrameTicks->None,
       ImageSize->
        Dynamic[{
         Automatic, 
          1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
           Magnification])}],
       PlotRangePadding->None],
      "RGBColor[1, 0, 0]"],
     Appearance->None,
     BaseStyle->{},
     BaselinePosition->Baseline,
     ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
       If[
        Not[
         AbsoluteCurrentValue["Deployed"]], 
        SelectionMove[Typeset`box$, All, Expression]; 
        FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
        FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0, 0]; 
        FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
        MathLink`CallFrontEnd[
          FrontEnd`AttachCell[Typeset`box$, 
           FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
           Left, Top}, 
           "ClosingActions" -> {
            "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
     DefaultBaseStyle->{},
     Evaluator->Automatic,
     Method->"Preemptive"],
    RGBColor[1, 0, 0],
    Editable->False,
    Selectable->False], ",", "a", ",", "a", ",", 
   InterpretationBox[
    ButtonBox[
     TooltipBox[
      GraphicsBox[{
        {GrayLevel[0], RectangleBox[{0, 0}]}, 
        {GrayLevel[0], RectangleBox[{1, -1}]}, 
        {RGBColor[1, 0, 0], RectangleBox[{0, -1}, {2, 1}]}},
       AspectRatio->1,
       Frame->True,
       FrameStyle->RGBColor[0.6666666666666666, 0., 0.],
       FrameTicks->None,
       ImageSize->
        Dynamic[{
         Automatic, 
          1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
           Magnification])}],
       PlotRangePadding->None],
      "RGBColor[1, 0, 0]"],
     Appearance->None,
     BaseStyle->{},
     BaselinePosition->Baseline,
     ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
       If[
        Not[
         AbsoluteCurrentValue["Deployed"]], 
        SelectionMove[Typeset`box$, All, Expression]; 
        FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
        FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0, 0]; 
        FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
        MathLink`CallFrontEnd[
          FrontEnd`AttachCell[Typeset`box$, 
           FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
           Left, Top}, 
           "ClosingActions" -> {
            "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
     DefaultBaseStyle->{},
     Evaluator->Automatic,
     Method->"Preemptive"],
    RGBColor[1, 0, 0],
    Editable->False,
    Selectable->False], ",", 
   InterpretationBox[
    ButtonBox[
     TooltipBox[
      GraphicsBox[{
        {GrayLevel[0], RectangleBox[{0, 0}]}, 
        {GrayLevel[0], RectangleBox[{1, -1}]}, 
        {RGBColor[1, 0, 0], RectangleBox[{0, -1}, {2, 1}]}},
       AspectRatio->1,
       Frame->True,
       FrameStyle->RGBColor[0.6666666666666666, 0., 0.],
       FrameTicks->None,
       ImageSize->
        Dynamic[{
         Automatic, 
          1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
           Magnification])}],
       PlotRangePadding->None],
      "RGBColor[1, 0, 0]"],
     Appearance->None,
     BaseStyle->{},
     BaselinePosition->Baseline,
     ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
       If[
        Not[
         AbsoluteCurrentValue["Deployed"]], 
        SelectionMove[Typeset`box$, All, Expression]; 
        FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
        FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0, 0]; 
        FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
        MathLink`CallFrontEnd[
          FrontEnd`AttachCell[Typeset`box$, 
           FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
           Left, Top}, 
           "ClosingActions" -> {
            "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
     DefaultBaseStyle->{},
     Evaluator->Automatic,
     Method->"Preemptive"],
    RGBColor[1, 0, 0],
    Editable->False,
    Selectable->False], ",", "a", ",", 
   InterpretationBox[
    ButtonBox[
     TooltipBox[
      GraphicsBox[{
        {GrayLevel[0], RectangleBox[{0, 0}]}, 
        {GrayLevel[0], RectangleBox[{1, -1}]}, 
        {RGBColor[1, 0, 0], RectangleBox[{0, -1}, {2, 1}]}},
       AspectRatio->1,
       Frame->True,
       FrameStyle->RGBColor[0.6666666666666666, 0., 0.],
       FrameTicks->None,
       ImageSize->
        Dynamic[{
         Automatic, 
          1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
           Magnification])}],
       PlotRangePadding->None],
      "RGBColor[1, 0, 0]"],
     Appearance->None,
     BaseStyle->{},
     BaselinePosition->Baseline,
     ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
       If[
        Not[
         AbsoluteCurrentValue["Deployed"]], 
        SelectionMove[Typeset`box$, All, Expression]; 
        FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
        FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0, 0]; 
        FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
        MathLink`CallFrontEnd[
          FrontEnd`AttachCell[Typeset`box$, 
           FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
           Left, Top}, 
           "ClosingActions" -> {
            "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
     DefaultBaseStyle->{},
     Evaluator->Automatic,
     Method->"Preemptive"],
    RGBColor[1, 0, 0],
    Editable->False,
    Selectable->False]}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 GraphicsBoxOptions->{BaselinePosition->Scaled[0.1]},
 CellTags->"LastCellOfAPage",
 CellLabel->"Out[16]=",ExpressionUUID->"2618d168-12a4-41d8-bc70-a6b49def0a48"]
}, Open  ]],

Cell["\<\
Replace all occurrences of 2-element lists that begin with 1:\
\>", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"p:194",ExpressionUUID->"fd914f9f-396d-477f-af82-bf03a9b1fb0b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "a"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "b"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "a", ",", "b"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"2", ",", "b", ",", "c"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"2", ",", "b"}], "}"}]}], "}"}], "/.", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "_"}], "}"}], "\[Rule]", "Red"}]}]], "Input",
 Deletable->False,
 CellLabel->"In[17]:=",ExpressionUUID->"3ec0849e-2181-490e-bc0a-39a8b99a6885"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   InterpretationBox[
    ButtonBox[
     TooltipBox[
      GraphicsBox[{
        {GrayLevel[0], RectangleBox[{0, 0}]}, 
        {GrayLevel[0], RectangleBox[{1, -1}]}, 
        {RGBColor[1, 0, 0], RectangleBox[{0, -1}, {2, 1}]}},
       AspectRatio->1,
       Frame->True,
       FrameStyle->RGBColor[0.6666666666666666, 0., 0.],
       FrameTicks->None,
       ImageSize->
        Dynamic[{
         Automatic, 
          1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
           Magnification])}],
       PlotRangePadding->None],
      "RGBColor[1, 0, 0]"],
     Appearance->None,
     BaseStyle->{},
     BaselinePosition->Baseline,
     ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
       If[
        Not[
         AbsoluteCurrentValue["Deployed"]], 
        SelectionMove[Typeset`box$, All, Expression]; 
        FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
        FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0, 0]; 
        FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
        MathLink`CallFrontEnd[
          FrontEnd`AttachCell[Typeset`box$, 
           FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
           Left, Top}, 
           "ClosingActions" -> {
            "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
     DefaultBaseStyle->{},
     Evaluator->Automatic,
     Method->"Preemptive"],
    RGBColor[1, 0, 0],
    Editable->False,
    Selectable->False], ",", 
   InterpretationBox[
    ButtonBox[
     TooltipBox[
      GraphicsBox[{
        {GrayLevel[0], RectangleBox[{0, 0}]}, 
        {GrayLevel[0], RectangleBox[{1, -1}]}, 
        {RGBColor[1, 0, 0], RectangleBox[{0, -1}, {2, 1}]}},
       AspectRatio->1,
       Frame->True,
       FrameStyle->RGBColor[0.6666666666666666, 0., 0.],
       FrameTicks->None,
       ImageSize->
        Dynamic[{
         Automatic, 
          1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
           Magnification])}],
       PlotRangePadding->None],
      "RGBColor[1, 0, 0]"],
     Appearance->None,
     BaseStyle->{},
     BaselinePosition->Baseline,
     ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
       If[
        Not[
         AbsoluteCurrentValue["Deployed"]], 
        SelectionMove[Typeset`box$, All, Expression]; 
        FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
        FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0, 0]; 
        FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
        MathLink`CallFrontEnd[
          FrontEnd`AttachCell[Typeset`box$, 
           FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
           Left, Top}, 
           "ClosingActions" -> {
            "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
     DefaultBaseStyle->{},
     Evaluator->Automatic,
     Method->"Preemptive"],
    RGBColor[1, 0, 0],
    Editable->False,
    Selectable->False], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "a", ",", "b"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "b", ",", "c"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "b"}], "}"}]}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[17]=",ExpressionUUID->"3001d04e-5cdb-4ecc-9e2d-d0e9c745db32"]
}, Open  ]],

Cell["You can give a list of replacements to use:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"fa174c01-ebe6-421e-bed2-b68267c3d241"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "a"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "b"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "a", ",", "b"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"2", ",", "b", ",", "c"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"2", ",", "b"}], "}"}]}], "}"}], "/.", " ", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "_"}], "}"}], "\[Rule]", "Red"}], ",", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"__", ",", "b"}], "}"}], "\[Rule]", "Yellow"}]}], 
   "}"}]}]], "Input",
 Deletable->False,
 GraphicsBoxOptions->{BaselinePosition->Scaled[0.1]},
 CellLabel->"In[18]:=",ExpressionUUID->"132a7953-8a34-48f2-8174-a83c9308c28d"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   InterpretationBox[
    ButtonBox[
     TooltipBox[
      GraphicsBox[{
        {GrayLevel[0], RectangleBox[{0, 0}]}, 
        {GrayLevel[0], RectangleBox[{1, -1}]}, 
        {RGBColor[1, 0, 0], RectangleBox[{0, -1}, {2, 1}]}},
       AspectRatio->1,
       Frame->True,
       FrameStyle->RGBColor[0.6666666666666666, 0., 0.],
       FrameTicks->None,
       ImageSize->
        Dynamic[{
         Automatic, 
          1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
           Magnification])}],
       PlotRangePadding->None],
      "RGBColor[1, 0, 0]"],
     Appearance->None,
     BaseStyle->{},
     BaselinePosition->Baseline,
     ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
       If[
        Not[
         AbsoluteCurrentValue["Deployed"]], 
        SelectionMove[Typeset`box$, All, Expression]; 
        FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
        FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0, 0]; 
        FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
        MathLink`CallFrontEnd[
          FrontEnd`AttachCell[Typeset`box$, 
           FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
           Left, Top}, 
           "ClosingActions" -> {
            "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
     DefaultBaseStyle->{},
     Evaluator->Automatic,
     Method->"Preemptive"],
    RGBColor[1, 0, 0],
    Editable->False,
    Selectable->False], ",", 
   InterpretationBox[
    ButtonBox[
     TooltipBox[
      GraphicsBox[{
        {GrayLevel[0], RectangleBox[{0, 0}]}, 
        {GrayLevel[0], RectangleBox[{1, -1}]}, 
        {RGBColor[1, 0, 0], RectangleBox[{0, -1}, {2, 1}]}},
       AspectRatio->1,
       Frame->True,
       FrameStyle->RGBColor[0.6666666666666666, 0., 0.],
       FrameTicks->None,
       ImageSize->
        Dynamic[{
         Automatic, 
          1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
           Magnification])}],
       PlotRangePadding->None],
      "RGBColor[1, 0, 0]"],
     Appearance->None,
     BaseStyle->{},
     BaselinePosition->Baseline,
     ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
       If[
        Not[
         AbsoluteCurrentValue["Deployed"]], 
        SelectionMove[Typeset`box$, All, Expression]; 
        FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
        FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0, 0]; 
        FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
        MathLink`CallFrontEnd[
          FrontEnd`AttachCell[Typeset`box$, 
           FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
           Left, Top}, 
           "ClosingActions" -> {
            "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
     DefaultBaseStyle->{},
     Evaluator->Automatic,
     Method->"Preemptive"],
    RGBColor[1, 0, 0],
    Editable->False,
    Selectable->False], ",", 
   InterpretationBox[
    ButtonBox[
     TooltipBox[
      GraphicsBox[{
        {GrayLevel[0], RectangleBox[{0, 0}]}, 
        {GrayLevel[0], RectangleBox[{1, -1}]}, 
        {RGBColor[1, 1, 0], RectangleBox[{0, -1}, {2, 1}]}},
       AspectRatio->1,
       Frame->True,
       FrameStyle->RGBColor[0.6666666666666666, 0.6666666666666666, 0.],
       FrameTicks->None,
       ImageSize->
        Dynamic[{
         Automatic, 
          1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
           Magnification])}],
       PlotRangePadding->None],
      "RGBColor[1, 1, 0]"],
     Appearance->None,
     BaseStyle->{},
     BaselinePosition->Baseline,
     ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
       If[
        Not[
         AbsoluteCurrentValue["Deployed"]], 
        SelectionMove[Typeset`box$, All, Expression]; 
        FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
        FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 1, 0]; 
        FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
        MathLink`CallFrontEnd[
          FrontEnd`AttachCell[Typeset`box$, 
           FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
           Left, Top}, 
           "ClosingActions" -> {
            "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
     DefaultBaseStyle->{},
     Evaluator->Automatic,
     Method->"Preemptive"],
    RGBColor[1, 1, 0],
    Editable->False,
    Selectable->False], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "b", ",", "c"}], "}"}], ",", 
   InterpretationBox[
    ButtonBox[
     TooltipBox[
      GraphicsBox[{
        {GrayLevel[0], RectangleBox[{0, 0}]}, 
        {GrayLevel[0], RectangleBox[{1, -1}]}, 
        {RGBColor[1, 1, 0], RectangleBox[{0, -1}, {2, 1}]}},
       AspectRatio->1,
       Frame->True,
       FrameStyle->RGBColor[0.6666666666666666, 0.6666666666666666, 0.],
       FrameTicks->None,
       ImageSize->
        Dynamic[{
         Automatic, 
          1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
           Magnification])}],
       PlotRangePadding->None],
      "RGBColor[1, 1, 0]"],
     Appearance->None,
     BaseStyle->{},
     BaselinePosition->Baseline,
     ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
       If[
        Not[
         AbsoluteCurrentValue["Deployed"]], 
        SelectionMove[Typeset`box$, All, Expression]; 
        FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
        FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 1, 0]; 
        FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
        MathLink`CallFrontEnd[
          FrontEnd`AttachCell[Typeset`box$, 
           FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
           Left, Top}, 
           "ClosingActions" -> {
            "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
     DefaultBaseStyle->{},
     Evaluator->Automatic,
     Method->"Preemptive"],
    RGBColor[1, 1, 0],
    Editable->False,
    Selectable->False]}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[18]=",ExpressionUUID->"86d6057d-c5f6-4174-9459-89841a79d6a5"]
}, Open  ]],

Cell[TextData[{
 "The \[OpenCurlyDoubleQuote]blank\[CloseCurlyDoubleQuote] pattern ",
 Cell[BoxData[
  ButtonBox[
   ButtonBox["_",
    BaseStyle->"Link",
    ButtonData->"Blank"],
   BaseStyle->"Link",
   ButtonData->"Blank"]], "InlineCodeText",ExpressionUUID->
  "dfd32be9-d786-4370-a66b-562c3d7761ff"],
 " matches absolutely anything. This means, for example, that ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    ButtonBox["_",
     BaseStyle->"Link",
     ButtonData->"Blank"], ",", 
    ButtonBox["_",
     BaseStyle->"Link",
     ButtonData->"Blank"]}], "}"}]], "InlineCodeText",ExpressionUUID->
  "13d2f974-ebab-4a41-a9c5-817bc3c51d14"],
 " matches any list of two elements. But what if you want to insist that the \
two elements be the same? You can do that using a pattern like ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", 
     ButtonBox["_",
      BaseStyle->"Link",
      ButtonData->"Blank"]}], ",", 
    RowBox[{"x", 
     ButtonBox["_",
      BaseStyle->"Link",
      ButtonData->"Blank"]}]}], "}"}]], "InlineCodeText",ExpressionUUID->
  "7b0c0fb0-89ea-4d47-9e38-b01bdbf57bdb"],
 "."
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"52581c75-554c-4b0e-98ff-493e91bbe951"],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    ButtonBox[
     ButtonBox["_",
      BaseStyle->"Link",
      ButtonData->"Blank"],
     BaseStyle->"Link",
     ButtonData->"Blank"], ",", 
    ButtonBox[
     ButtonBox["_",
      BaseStyle->"Link",
      ButtonData->"Blank"],
     BaseStyle->"Link",
     ButtonData->"Blank"]}], "}"}]], "InlineCode",ExpressionUUID->
  "1db3c407-9bd9-444f-bcbf-429fb59fbe27"],
 " matches ",
 "any list of two elements",
 ", whether the elements are the same or not:"
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"9cc4f931-16ff-4883-8e9f-f4a7856afbb5"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Cases", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "a", ",", "a"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"a", ",", "a"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"a", ",", "c"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"b", ",", "a"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"b", ",", "b"}], "}"}], ",", 
     RowBox[{"{", "c", "}"}], ",", 
     RowBox[{"{", "a", "}"}], ",", 
     RowBox[{"{", "b", "}"}]}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"_", ",", "_"}], "}"}]}], "]"}]], "Input",
 Deletable->False,
 GraphicsBoxOptions->{BaselinePosition->Scaled[0.1]},
 CellLabel->"In[19]:=",ExpressionUUID->"6170cc3b-394b-48a3-9c15-804f10c77e83"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "a"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "c"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "a"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "b"}], "}"}]}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 GraphicsBoxOptions->{BaselinePosition->Scaled[0.1]},
 CellLabel->"Out[19]=",ExpressionUUID->"c27c85a0-07a6-48c6-8999-1baba8098e63"]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", 
     ButtonBox[
      ButtonBox["_",
       BaseStyle->"Link",
       ButtonData->"Blank"],
      BaseStyle->"Link",
      ButtonData->"Blank"]}], ",", 
    RowBox[{"x", 
     ButtonBox[
      ButtonBox["_",
       BaseStyle->"Link",
       ButtonData->"Blank"],
      BaseStyle->"Link",
      ButtonData->"Blank"]}]}], "}"}]], "InlineCode",ExpressionUUID->
  "7149400f-f617-4f6e-a81b-26dd1d0a7567"],
 " matches only lists of two identical elements:"
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"ad78153e-50ca-4a9d-aca0-32404ba03fb4"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Cases", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "a", ",", "a"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"a", ",", "a"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"a", ",", "c"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"b", ",", "a"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"b", ",", "b"}], "}"}], ",", 
     RowBox[{"{", "c", "}"}], ",", 
     RowBox[{"{", "a", "}"}], ",", 
     RowBox[{"{", "b", "}"}]}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"x_", ",", "x_"}], "}"}]}], "]"}]], "Input",
 Deletable->False,
 GraphicsBoxOptions->{BaselinePosition->Scaled[0.1]},
 CellLabel->"In[20]:=",ExpressionUUID->"d99d013a-3628-4b6e-b985-de96037c6b23"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "a"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "b"}], "}"}]}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 GraphicsBoxOptions->{BaselinePosition->Scaled[0.1]},
 CellLabel->"Out[20]=",ExpressionUUID->"681610f4-82e6-45be-b790-ce8c68f8fcd5"]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"x", 
   ButtonBox["_",
    BaseStyle->"Link",
    ButtonData->"Blank"]}]], "InlineCodeText",ExpressionUUID->
  "c23acb49-9a7b-4a53-929f-8576a1346ab3"],
 " is an example of a ",
 StyleBox["named pattern",
  FontSlant->"Italic"],
 ". Named patterns are especially important in replacements, because they \
give one way to make use of parts of what one\[CloseCurlyQuote]s replacing. "
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:8",ExpressionUUID->"156aca3d-75f7-43ed-af4f-5b5ae85dfb89"],

Cell[TextData[{
 "Use the named pattern ",
 Cell[BoxData[
  RowBox[{"x", 
   ButtonBox[
    ButtonBox["_",
     BaseStyle->"Link",
     ButtonData->"Blank"],
    BaseStyle->"Link",
    ButtonData->"Blank"]}]], "InlineCode",ExpressionUUID->
  "d234e14a-8d23-4f1b-86be-4e23503f3db8"],
 " in a replacement:"
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"6f8cceff-7859-4c13-a769-461f792f370e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", 
      InterpretationBox[
       ButtonBox[
        TooltipBox[
         GraphicsBox[{
           {GrayLevel[0], RectangleBox[{0, 0}]}, 
           {GrayLevel[0], RectangleBox[{1, -1}]}, 
           {RGBColor[1, 0, 0], RectangleBox[{0, -1}, {2, 1}]}},
          AspectRatio->1,
          Frame->True,
          FrameStyle->RGBColor[0.6666666666666666, 0., 0.],
          FrameTicks->None,
          
          ImageSize->
           Dynamic[{
            Automatic, 
             1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
              Magnification])}],
          PlotRangePadding->None],
         "RGBColor[1, 0, 0]"],
        Appearance->None,
        BaseStyle->{},
        BaselinePosition->Baseline,
        ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
          If[
           Not[
            AbsoluteCurrentValue["Deployed"]], 
           SelectionMove[Typeset`box$, All, Expression]; 
           FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
           FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0, 0]; 
           FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
           MathLink`CallFrontEnd[
             FrontEnd`AttachCell[Typeset`box$, 
              FrontEndResource["RGBColorValueSelector"], {
              0, {Left, Bottom}}, {Left, Top}, 
              "ClosingActions" -> {
               "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
        DefaultBaseStyle->{},
        Evaluator->Automatic,
        Method->"Preemptive"],
       RGBColor[1, 0, 0],
       Editable->False,
       Selectable->False]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", 
      InterpretationBox[
       ButtonBox[
        TooltipBox[
         GraphicsBox[{
           {GrayLevel[0], RectangleBox[{0, 0}]}, 
           {GrayLevel[0], RectangleBox[{1, -1}]}, 
           {RGBColor[0, 0, 1], RectangleBox[{0, -1}, {2, 1}]}},
          AspectRatio->1,
          Frame->True,
          FrameStyle->RGBColor[0., 0., 0.6666666666666666],
          FrameTicks->None,
          
          ImageSize->
           Dynamic[{
            Automatic, 
             1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
              Magnification])}],
          PlotRangePadding->None],
         "RGBColor[0, 0, 1]"],
        Appearance->None,
        BaseStyle->{},
        BaselinePosition->Baseline,
        ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
          If[
           Not[
            AbsoluteCurrentValue["Deployed"]], 
           SelectionMove[Typeset`box$, All, Expression]; 
           FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
           FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[0, 0, 1]; 
           FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
           MathLink`CallFrontEnd[
             FrontEnd`AttachCell[Typeset`box$, 
              FrontEndResource["RGBColorValueSelector"], {
              0, {Left, Bottom}}, {Left, Top}, 
              "ClosingActions" -> {
               "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
        DefaultBaseStyle->{},
        Evaluator->Automatic,
        Method->"Preemptive"],
       RGBColor[0, 0, 1],
       Editable->False,
       Selectable->False]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", 
      InterpretationBox[
       ButtonBox[
        TooltipBox[
         GraphicsBox[{
           {GrayLevel[0], RectangleBox[{0, 0}]}, 
           {GrayLevel[0], RectangleBox[{1, -1}]}, 
           {RGBColor[1, 0, 0], RectangleBox[{0, -1}, {2, 1}]}},
          AspectRatio->1,
          Frame->True,
          FrameStyle->RGBColor[0.6666666666666666, 0., 0.],
          FrameTicks->None,
          
          ImageSize->
           Dynamic[{
            Automatic, 
             1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
              Magnification])}],
          PlotRangePadding->None],
         "RGBColor[1, 0, 0]"],
        Appearance->None,
        BaseStyle->{},
        BaselinePosition->Baseline,
        ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
          If[
           Not[
            AbsoluteCurrentValue["Deployed"]], 
           SelectionMove[Typeset`box$, All, Expression]; 
           FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
           FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0, 0]; 
           FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
           MathLink`CallFrontEnd[
             FrontEnd`AttachCell[Typeset`box$, 
              FrontEndResource["RGBColorValueSelector"], {
              0, {Left, Bottom}}, {Left, Top}, 
              "ClosingActions" -> {
               "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
        DefaultBaseStyle->{},
        Evaluator->Automatic,
        Method->"Preemptive"],
       RGBColor[1, 0, 0],
       Editable->False,
       Selectable->False], ",", 
      InterpretationBox[
       ButtonBox[
        TooltipBox[
         GraphicsBox[{
           {GrayLevel[0], RectangleBox[{0, 0}]}, 
           {GrayLevel[0], RectangleBox[{1, -1}]}, 
           {RGBColor[0, 0, 1], RectangleBox[{0, -1}, {2, 1}]}},
          AspectRatio->1,
          Frame->True,
          FrameStyle->RGBColor[0., 0., 0.6666666666666666],
          FrameTicks->None,
          
          ImageSize->
           Dynamic[{
            Automatic, 
             1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
              Magnification])}],
          PlotRangePadding->None],
         "RGBColor[0, 0, 1]"],
        Appearance->None,
        BaseStyle->{},
        BaselinePosition->Baseline,
        ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
          If[
           Not[
            AbsoluteCurrentValue["Deployed"]], 
           SelectionMove[Typeset`box$, All, Expression]; 
           FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
           FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[0, 0, 1]; 
           FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
           MathLink`CallFrontEnd[
             FrontEnd`AttachCell[Typeset`box$, 
              FrontEndResource["RGBColorValueSelector"], {
              0, {Left, Bottom}}, {Left, Top}, 
              "ClosingActions" -> {
               "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
        DefaultBaseStyle->{},
        Evaluator->Automatic,
        Method->"Preemptive"],
       RGBColor[0, 0, 1],
       Editable->False,
       Selectable->False]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"2", ",", 
      InterpretationBox[
       ButtonBox[
        TooltipBox[
         GraphicsBox[{
           {GrayLevel[0], RectangleBox[{0, 0}]}, 
           {GrayLevel[0], RectangleBox[{1, -1}]}, 
           {RGBColor[0, 1, 0], RectangleBox[{0, -1}, {2, 1}]}},
          AspectRatio->1,
          Frame->True,
          FrameStyle->RGBColor[0., 0.6666666666666666, 0.],
          FrameTicks->None,
          
          ImageSize->
           Dynamic[{
            Automatic, 
             1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
              Magnification])}],
          PlotRangePadding->None],
         "RGBColor[0, 1, 0]"],
        Appearance->None,
        BaseStyle->{},
        BaselinePosition->Baseline,
        ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
          If[
           Not[
            AbsoluteCurrentValue["Deployed"]], 
           SelectionMove[Typeset`box$, All, Expression]; 
           FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
           FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[0, 1, 0]; 
           FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
           MathLink`CallFrontEnd[
             FrontEnd`AttachCell[Typeset`box$, 
              FrontEndResource["RGBColorValueSelector"], {
              0, {Left, Bottom}}, {Left, Top}, 
              "ClosingActions" -> {
               "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
        DefaultBaseStyle->{},
        Evaluator->Automatic,
        Method->"Preemptive"],
       RGBColor[0, 1, 0],
       Editable->False,
       Selectable->False], ",", 
      InterpretationBox[
       ButtonBox[
        TooltipBox[
         GraphicsBox[{
           {GrayLevel[0], RectangleBox[{0, 0}]}, 
           {GrayLevel[0], RectangleBox[{1, -1}]}, 
           {RGBColor[0, 0, 1], RectangleBox[{0, -1}, {2, 1}]}},
          AspectRatio->1,
          Frame->True,
          FrameStyle->RGBColor[0., 0., 0.6666666666666666],
          FrameTicks->None,
          
          ImageSize->
           Dynamic[{
            Automatic, 
             1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
              Magnification])}],
          PlotRangePadding->None],
         "RGBColor[0, 0, 1]"],
        Appearance->None,
        BaseStyle->{},
        BaselinePosition->Baseline,
        ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
          If[
           Not[
            AbsoluteCurrentValue["Deployed"]], 
           SelectionMove[Typeset`box$, All, Expression]; 
           FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
           FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[0, 0, 1]; 
           FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
           MathLink`CallFrontEnd[
             FrontEnd`AttachCell[Typeset`box$, 
              FrontEndResource["RGBColorValueSelector"], {
              0, {Left, Bottom}}, {Left, Top}, 
              "ClosingActions" -> {
               "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
        DefaultBaseStyle->{},
        Evaluator->Automatic,
        Method->"Preemptive"],
       RGBColor[0, 0, 1],
       Editable->False,
       Selectable->False]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"2", ",", 
      InterpretationBox[
       ButtonBox[
        TooltipBox[
         GraphicsBox[{
           {GrayLevel[0], RectangleBox[{0, 0}]}, 
           {GrayLevel[0], RectangleBox[{1, -1}]}, 
           {RGBColor[0, 0, 1], RectangleBox[{0, -1}, {2, 1}]}},
          AspectRatio->1,
          Frame->True,
          FrameStyle->RGBColor[0., 0., 0.6666666666666666],
          FrameTicks->None,
          
          ImageSize->
           Dynamic[{
            Automatic, 
             1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
              Magnification])}],
          PlotRangePadding->None],
         "RGBColor[0, 0, 1]"],
        Appearance->None,
        BaseStyle->{},
        BaselinePosition->Baseline,
        ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
          If[
           Not[
            AbsoluteCurrentValue["Deployed"]], 
           SelectionMove[Typeset`box$, All, Expression]; 
           FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
           FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[0, 0, 1]; 
           FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
           MathLink`CallFrontEnd[
             FrontEnd`AttachCell[Typeset`box$, 
              FrontEndResource["RGBColorValueSelector"], {
              0, {Left, Bottom}}, {Left, Top}, 
              "ClosingActions" -> {
               "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
        DefaultBaseStyle->{},
        Evaluator->Automatic,
        Method->"Preemptive"],
       RGBColor[0, 0, 1],
       Editable->False,
       Selectable->False]}], "}"}]}], "}"}], " ", "/.", " ", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "x_"}], "}"}], "\[Rule]", 
   RowBox[{"{", 
    RowBox[{"x", ",", "x", ",", "Yellow", ",", "x", ",", "x"}], 
    "}"}]}]}]], "Input",
 Deletable->False,
 GraphicsBoxOptions->{BaselinePosition->Scaled[0.1]},
 CellLabel->"In[21]:=",ExpressionUUID->"2c5267b1-c367-4671-8c38-cc17213b644e"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[1, 0, 0], RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         Frame->True,
         FrameStyle->RGBColor[0.6666666666666666, 0., 0.],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        "RGBColor[1, 0, 0]"],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0, 0]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[1, 0, 0],
      Editable->False,
      Selectable->False], ",", 
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[1, 0, 0], RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         Frame->True,
         FrameStyle->RGBColor[0.6666666666666666, 0., 0.],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        "RGBColor[1, 0, 0]"],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0, 0]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[1, 0, 0],
      Editable->False,
      Selectable->False], ",", 
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[1, 1, 0], RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         Frame->True,
         FrameStyle->RGBColor[0.6666666666666666, 0.6666666666666666, 0.],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        "RGBColor[1, 1, 0]"],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 1, 0]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[1, 1, 0],
      Editable->False,
      Selectable->False], ",", 
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[1, 0, 0], RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         Frame->True,
         FrameStyle->RGBColor[0.6666666666666666, 0., 0.],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        "RGBColor[1, 0, 0]"],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0, 0]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[1, 0, 0],
      Editable->False,
      Selectable->False], ",", 
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[1, 0, 0], RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         Frame->True,
         FrameStyle->RGBColor[0.6666666666666666, 0., 0.],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        "RGBColor[1, 0, 0]"],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0, 0]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[1, 0, 0],
      Editable->False,
      Selectable->False]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[0, 0, 1], RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         Frame->True,
         FrameStyle->RGBColor[0., 0., 0.6666666666666666],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        "RGBColor[0, 0, 1]"],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[0, 0, 1]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[0, 0, 1],
      Editable->False,
      Selectable->False], ",", 
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[0, 0, 1], RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         Frame->True,
         FrameStyle->RGBColor[0., 0., 0.6666666666666666],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        "RGBColor[0, 0, 1]"],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[0, 0, 1]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[0, 0, 1],
      Editable->False,
      Selectable->False], ",", 
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[1, 1, 0], RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         Frame->True,
         FrameStyle->RGBColor[0.6666666666666666, 0.6666666666666666, 0.],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        "RGBColor[1, 1, 0]"],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 1, 0]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[1, 1, 0],
      Editable->False,
      Selectable->False], ",", 
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[0, 0, 1], RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         Frame->True,
         FrameStyle->RGBColor[0., 0., 0.6666666666666666],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        "RGBColor[0, 0, 1]"],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[0, 0, 1]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[0, 0, 1],
      Editable->False,
      Selectable->False], ",", 
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[0, 0, 1], RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         Frame->True,
         FrameStyle->RGBColor[0., 0., 0.6666666666666666],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        "RGBColor[0, 0, 1]"],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[0, 0, 1]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[0, 0, 1],
      Editable->False,
      Selectable->False]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", 
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[1, 0, 0], RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         Frame->True,
         FrameStyle->RGBColor[0.6666666666666666, 0., 0.],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        "RGBColor[1, 0, 0]"],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0, 0]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[1, 0, 0],
      Editable->False,
      Selectable->False], ",", 
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[0, 0, 1], RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         Frame->True,
         FrameStyle->RGBColor[0., 0., 0.6666666666666666],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        "RGBColor[0, 0, 1]"],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[0, 0, 1]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[0, 0, 1],
      Editable->False,
      Selectable->False]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", 
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[0, 1, 0], RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         Frame->True,
         FrameStyle->RGBColor[0., 0.6666666666666666, 0.],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        "RGBColor[0, 1, 0]"],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[0, 1, 0]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[0, 1, 0],
      Editable->False,
      Selectable->False], ",", 
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[0, 0, 1], RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         Frame->True,
         FrameStyle->RGBColor[0., 0., 0.6666666666666666],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        "RGBColor[0, 0, 1]"],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[0, 0, 1]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[0, 0, 1],
      Editable->False,
      Selectable->False]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", 
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[0, 0, 1], RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         Frame->True,
         FrameStyle->RGBColor[0., 0., 0.6666666666666666],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        "RGBColor[0, 0, 1]"],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[0, 0, 1]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[0, 0, 1],
      Editable->False,
      Selectable->False]}], "}"}]}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 GraphicsBoxOptions->{BaselinePosition->Scaled[0.1]},
 CellLabel->"Out[21]=",ExpressionUUID->"bbbd7fbd-9ca2-4200-9a52-467778ecf1ed"]
}, Open  ]],

Cell[TextData[{
 "The form ",
 StyleBox["a",
  FontSlant->"Italic"],
 Cell[BoxData[
  ButtonBox["\[Rule]",
   BaseStyle->"Link",
   ButtonData->"Rule"]], "InlineCodeText",ExpressionUUID->
  "d3189fe7-5fc5-4d41-9040-8da4d49f406c"],
 StyleBox["b",
  FontSlant->"Italic"],
 " is usually called a ",
 StyleBox["rule",
  FontSlant->"Italic"],
 ". If ",
 Cell[BoxData[
  RowBox[{"x", 
   ButtonBox["_",
    BaseStyle->"Link",
    ButtonData->"Blank"]}]], "InlineCodeText",ExpressionUUID->
  "7a25955b-f24f-4df7-9a00-57d28e9eb5dc"],
 " appears on the left-hand side of a rule, then whatever the ",
 Cell[BoxData[
  RowBox[{"x", 
   ButtonBox["_",
    BaseStyle->"Link",
    ButtonData->"Blank"]}]], "InlineCodeText",ExpressionUUID->
  "d1da885e-490c-46de-b01b-b5877f09cbcc"],
 " matches can be referred to on the right-hand side as ",
 Cell[BoxData[
 "x"], "InlineCodeText",ExpressionUUID->
  "8329af6b-aa74-4cde-81ca-ac202115508b"],
 "."
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:9",ExpressionUUID->"fe8e60f5-1608-4b5b-8824-4931bce2b2db"],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
 "x"], "InlineCode",ExpressionUUID->"e898f693-2e87-4eab-bc9c-99a1b91670ab"],
 " in the right-hand side of the rule to refer to what ",
 Cell[BoxData[
  RowBox[{"x", 
   ButtonBox["_",
    BaseStyle->"Link",
    ButtonData->"Blank"]}]], "InlineCode",ExpressionUUID->
  "dbe177bd-0020-4540-8720-c2142c939fbe"],
 " matches:"
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"f73d5c08-b44e-4d7f-8e1c-db058c1f4f3b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{"f", "[", "1", "]"}], ",", 
    RowBox[{"g", "[", "2", "]"}], ",", 
    RowBox[{"f", "[", "2", "]"}], ",", 
    RowBox[{"f", "[", "6", "]"}], ",", 
    RowBox[{"g", "[", "3", "]"}]}], "}"}], "/.", 
  RowBox[{
   RowBox[{"f", "[", "x_", "]"}], "\[Rule]", 
   RowBox[{"x", "+", "10"}]}]}]], "Input",
 Deletable->False,
 CellLabel->"In[22]:=",ExpressionUUID->"3d07e872-7fbb-4cd7-9881-944cbd2ecb6a"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"11", ",", 
   RowBox[{"g", "[", "2", "]"}], ",", "12", ",", "16", ",", 
   RowBox[{"g", "[", "3", "]"}]}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[22]=",ExpressionUUID->"86dd69e2-81af-4d03-8643-e07aa52fad12"]
}, Open  ]],

Cell[TextData[{
 "You can use rules inside ",
 ButtonBox["Cases",
  BaseStyle->"Link"],
 " as well. "
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"c8119a50-0e7f-4cfc-9057-cd63963526fa"],

Cell[TextData[{
 "Pick out elements in the list that match ",
 Cell[BoxData[
  RowBox[{"f", "[", 
   RowBox[{"x", 
    ButtonBox["_",
     BaseStyle->"Link",
     ButtonData->"Blank"]}], "]"}]], "InlineCode",ExpressionUUID->
  "a262981a-2658-4a32-a620-f05706b358b4"],
 ", and give the result of replacing them by ",
 Cell[BoxData[
  RowBox[{"x", "+", "10"}]], "InlineCode",ExpressionUUID->
  "7b8857ce-1f00-4cf5-878d-21f5a1026fee"],
 ":"
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"5b876611-ee47-41dc-9b3e-ea60f21cb634"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Cases", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"f", "[", "1", "]"}], ",", 
     RowBox[{"g", "[", "2", "]"}], ",", 
     RowBox[{"f", "[", "2", "]"}], ",", 
     RowBox[{"f", "[", "6", "]"}], ",", 
     RowBox[{"g", "[", "3", "]"}]}], "}"}], ",", 
   RowBox[{
    RowBox[{"f", "[", "x_", "]"}], "\[Rule]", 
    RowBox[{"x", "+", "10"}]}]}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[23]:=",ExpressionUUID->"9eb9c44a-6c1a-44ff-a46b-86aa646ea263"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"11", ",", "12", ",", "16"}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[23]=",ExpressionUUID->"192caa56-4f5b-4318-877a-329f57da97c5"]
}, Open  ]],

Cell[TextData[{
 ButtonBox["Later on",
  BaseStyle->"Hyperlink",
  ButtonData->{"EIWL2-38-assigning-names-to-things.nb", None}],
 ", we\[CloseCurlyQuote]ll see how named patterns are crucial to defining \
your own functions in the Wolfram Language."
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->
  "LastCellOfAPage",ExpressionUUID->"08f86d97-5a99-455b-8c91-cd4e614e9203"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Vocabulary", "VocabularySection",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"p:195",ExpressionUUID->"19914aa2-4210-4f81-9c5a-79794324d117"],

Cell[BoxData[GridBox[{
   {
    ButtonBox["_",
     BaseStyle->"CodeLink",
     ButtonData->"Blank"], " ", Cell[
    "pattern standing for anything (\[OpenCurlyDoubleQuote]blank\
\[CloseCurlyDoubleQuote]) ", "VocabularyText",ExpressionUUID->
     "a20f9c8e-1214-4d3a-b629-84263cf6d4e8"]},
   {
    ButtonBox[
     RowBox[{"_", "\[ThinSpace]", "_"}],
     BaseStyle->"CodeLink",
     ButtonData->"BlankSequence"], " ", Cell[
    "pattern standing for any sequence (\[OpenCurlyDoubleQuote]double blank\
\[CloseCurlyDoubleQuote]) ", "VocabularyText",ExpressionUUID->
     "78598d7c-5abe-4fbc-a2da-8bcbd77aba08"]},
   {
    StyleBox[
     RowBox[{
      StyleBox["x", "CodeVariableLrg"], "_"}]], " ", Cell[TextData[{
     "pattern named ",
     Cell[BoxData[
      StyleBox["x", "CodeVariable"]], "InlineCode",ExpressionUUID->
      "7b1706a4-9dfc-47d7-a763-fdf7f49e9781"]
    }], "VocabularyText",ExpressionUUID->
     "49c762c9-b1e3-4954-99d4-77f1cda04b3b"]},
   {
    RowBox[{
     StyleBox["a", "CodeVariableLrg"], 
     ButtonBox[
      AdjustmentBox["|",
       BoxBaselineShift->-0.19095140804656105`,
       BoxMargins->{{0., 0.}, {0.29095140804656106`, -0.19095140804656105`}}],
      
      BaseStyle->"CodeLink",
      ButtonData->"Alternatives"], 
     StyleBox["b", "CodeVariableLrg"]}], " ", Cell[TextData[{
     "pattern matching ",
     Cell[BoxData[
      StyleBox["a", "CodeVariable"]], "InlineCode",ExpressionUUID->
      "b09a1e40-78d8-460f-b7ee-b0083487409c"],
     " or ",
     Cell[BoxData[
      StyleBox["b", "CodeVariable"]], "InlineCode",ExpressionUUID->
      "f2787e5b-6c2e-49a3-8463-36bd8b4fe9a1"]
    }], "VocabularyText",ExpressionUUID->
     "cec9bdb2-0cf0-46cf-bb1e-567bc3a3a885"]},
   {
    RowBox[{
     ButtonBox["MatchQ",
      BaseStyle->"CodeLink"], "[", 
     RowBox[{
      StyleBox["expr", "CodeVariableLrg"], ",", 
      StyleBox["pattern", "CodeVariableLrg"]}], "]"}], " ", Cell[TextData[{
     "test whether ",
     Cell[BoxData[
      StyleBox["expr", "CodeVariable"]], "InlineCode",ExpressionUUID->
      "2a6a1d2c-665e-46c7-93a1-750d61dd4d7b"],
     " matches a pattern"
    }], "VocabularyText",ExpressionUUID->
     "f505684a-e844-4fc7-8e43-0ea68280c7f4"]},
   {
    RowBox[{
     ButtonBox["Cases",
      BaseStyle->"CodeLink"], "[", 
     RowBox[{
      StyleBox["list", "CodeVariableLrg"], ",", 
      StyleBox["pattern", "CodeVariableLrg"]}], "]"}], " ", Cell[
    "find cases of a pattern in a list ", "VocabularyText",ExpressionUUID->
     "3e28bcb1-98f8-45df-b68e-8eb493cd81d6"]},
   {
    RowBox[{
     StyleBox["lhs", "CodeVariableLrg"], 
     ButtonBox["\[Rule]",
      BaseStyle->"CodeLink",
      ButtonData->"Rule"], 
     StyleBox["rhs", "CodeVariableLrg"]}], " ", Cell[TextData[{
     "rule for transforming ",
     Cell[BoxData[
      StyleBox["lhs", "CodeVariable"]], "InlineCode",ExpressionUUID->
      "c1f1cb09-8f4a-423e-b4a2-63ba0bbceb6c"],
     " into ",
     Cell[BoxData[
      StyleBox["rhs", "CodeVariable"]], "InlineCode",ExpressionUUID->
      "772f76c2-a6e9-493f-ae38-48cdd81a0dd2"]
    }], "VocabularyText",ExpressionUUID->
     "d5216fa8-7986-482d-a9c8-f119619f2907"]},
   {
    RowBox[{
     StyleBox["expr", "CodeVariableLrg"], 
     ButtonBox["/.",
      BaseStyle->"CodeLink",
      ButtonData->"ReplaceAll"], 
     StyleBox["lhs", "CodeVariableLrg"], 
     ButtonBox["\[Rule]",
      BaseStyle->"CodeLink",
      ButtonData->"Rule"], 
     StyleBox["rhs", "CodeVariableLrg"]}], " ", Cell[TextData[{
     "replace ",
     Cell[BoxData[
      StyleBox["lhs", "CodeVariable"]], "InlineCode",ExpressionUUID->
      "7df1bd92-cc49-4a33-a503-9c674f6f4312"],
     " by ",
     Cell[BoxData[
      StyleBox["rhs", "CodeVariable"]], "InlineCode",ExpressionUUID->
      "1acd5b19-8fae-40da-b0c1-11f16006e914"],
     " in ",
     Cell[BoxData[
      StyleBox["expr", "CodeVariable"]], "InlineCode",ExpressionUUID->
      "eb70da05-5671-4a03-b343-f6cabe1e0676"]
    }], "VocabularyText",ExpressionUUID->
     "f09748b0-1cde-4dbc-b337-53555e897143"]}
  }]], "VocabularyTable",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "Rows" -> {False, {True, True, True, 
      Directive[
       Thickness[1.5], "VocabDivColor"], True, True, True, True}, 
     False}}},ExpressionUUID->"c5940f75-97d1-4081-84f4-f69826240459"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 DynamicModuleBox[{$CellContext`open$$ = False}, 
  TagBox[GridBox[{
     {
      StyleBox["\<\"Exercises\"\>",
       StripOnInput->False,
       FontSlant->"Italic"], 
      PaneBox[
       TagBox[
        ButtonBox[
         DynamicBox[ToBoxes[
           If[$CellContext`open$$, 
            Row[{
              Style["-", "ExercisePreviewButtonTextHighlight"], 
              Style[" Preview Exercises", "ExercisePreviewButtonText"]}], 
            Row[{
              Style["+", "ExercisePreviewButtonTextHighlight"], 
              Style[" Preview Exercises", "ExercisePreviewButtonText"]}]], 
           StandardForm],
          ImageSizeCache->{115., {1., 10.}}],
         Appearance->None,
         ButtonFunction:>(
          If[$CellContext`open$$, $CellContext`open$$ = 
            False, $CellContext`open$$ = True]; NotebookFind[
            EvaluationNotebook[], "ExerciseSummaryCell", Next, CellStyle, 
            WrapAround -> True, AutoScroll -> False]; FrontEndTokenExecute[
            EvaluationNotebook[], "ExpandSelection"]; FrontEndExecute[
            FrontEndToken[
             EvaluationNotebook[], "OpenCloseGroup"]]),
         Evaluator->Automatic,
         Method->"Preemptive"],
        MouseAppearanceTag["LinkHand"]],
       Alignment->Right,
       ImageSize->Full]}
    },
    AutoDelete->False,
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  DynamicModuleValues:>{}]], "ExerciseSection",
 Editable->False,
 ShowCellBracket->False,
 GeneratedCell->True,
 CellAutoOverwrite->True,
 CellChangeTimes->{3.669991951589675*^9},
 ShowStringCharacters->
  False,ExpressionUUID->"4d0098b6-6b7c-470a-83dd-ded0749ad97a"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[GridBox[{
    {
     TagBox[GridBox[{
        {
         PaneBox[
          StyleBox["\<\"8 Exercises Available\"\>", "ExerciseSummaryHeading",
           StripOnInput->False],
          ImageMargins->{{20, 0}, {0, 10}}]}
       },
       DefaultBaseStyle->"Column",
       GridBoxAlignment->{"Columns" -> {{Left}}},
       GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
       
       GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{0}}}],
      "Column"], 
     PaneBox[
      ButtonBox[
       StyleBox["\<\"Get Started \[RightGuillemet]\"\>", 
        "ExerciseSummaryHeading",
        StripOnInput->False],
       Appearance->None,
       ButtonFunction:>NotebookLocate[{"EIWL2-32-patterns-exercises.nb", ""}],
       
       Evaluator->Automatic,
       Method->"Preemptive"],
      FrameMargins->{{10, 0}, {10, 10}},
      ImageSize->Full]}
   },
   AutoDelete->False,
   GridBoxAlignment->{"Columns" -> {{Left}}},
   GridBoxItemSize->{"Columns" -> {
       Scaled[0.7], 
       Scaled[0.3]}, "Rows" -> {{Automatic}}}],
  "Grid"]], "ExerciseSummaryCell",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"a10b3f8c-88fe-4462-acd4-353cb051224c"],

Cell[CellGroupData[{

Cell[TextData[{
 "Find lists of length 3 or more beginning with 1 and ending with 9 in ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["IntegerDigits",
    BaseStyle->"CodeLink"], "[", 
   RowBox[{
    ButtonBox["Range",
     BaseStyle->"CodeLink"], "[", "1000", "]"}], "]"}]], "InlineCode",
  ExpressionUUID->"75e4bede-b5c4-4297-913c-90b88608ba0d"],
 ".",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "32.1", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"f532ec56-e9e7-45ca-a80f-5b76ac53344f"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", "0", ",", "9"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "1", ",", "9"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "2", ",", "9"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "3", ",", "9"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "4", ",", "9"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "5", ",", "9"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "6", ",", "9"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "7", ",", "9"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "8", ",", "9"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "9", ",", "9"}], "}"}]}], "}"}]], 
       "ExerciseOutput",ExpressionUUID->
       "5fc8879a-f537-4bf7-bf5c-4c25a15e39dd"],
      Apply[TextCell, 
       Cell[
        BoxData[
         RowBox[{"{", 
           RowBox[{
             RowBox[{"{", 
               RowBox[{"1", ",", "0", ",", "9"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"1", ",", "1", ",", "9"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"1", ",", "2", ",", "9"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"1", ",", "3", ",", "9"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"1", ",", "4", ",", "9"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"1", ",", "5", ",", "9"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"1", ",", "6", ",", "9"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"1", ",", "7", ",", "9"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"1", ",", "8", ",", "9"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"1", ",", "9", ",", "9"}], "}"}]}], "}"}]], 
        "ExerciseOutput", Selectable -> False, Copyable -> False, Editable -> 
        False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"ad88cbf2-ab9e-4a6b-9f38-88907651e7d3"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Find lists of three identical elements in ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["IntegerDigits",
    BaseStyle->"CodeLink"], "[", 
   RowBox[{
    ButtonBox["Range",
     BaseStyle->"CodeLink"], "[", "1000", "]"}], "]"}]], "InlineCode",
  ExpressionUUID->"be286fba-e2a9-4a08-a958-69eb514c0296"],
 ".",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "32.2", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"615f68ce-2d56-40b4-86ad-6d6d2be355e8"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", "1", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", "2", ",", "2"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"3", ",", "3", ",", "3"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"4", ",", "4", ",", "4"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"5", ",", "5", ",", "5"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"6", ",", "6", ",", "6"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"7", ",", "7", ",", "7"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"8", ",", "8", ",", "8"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"9", ",", "9", ",", "9"}], "}"}]}], "}"}]], 
       "ExerciseOutput",ExpressionUUID->
       "30c0bddc-790a-4cab-851a-9513c83e46a1"],
      Apply[TextCell, 
       Cell[
        BoxData[
         RowBox[{"{", 
           RowBox[{
             RowBox[{"{", 
               RowBox[{"1", ",", "1", ",", "1"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"2", ",", "2", ",", "2"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"3", ",", "3", ",", "3"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"4", ",", "4", ",", "4"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"5", ",", "5", ",", "5"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"6", ",", "6", ",", "6"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"7", ",", "7", ",", "7"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"8", ",", "8", ",", "8"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"9", ",", "9", ",", "9"}], "}"}]}], "}"}]], 
        "ExerciseOutput", Selectable -> False, Copyable -> False, Editable -> 
        False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"82c064cf-3980-4c07-b5b6-7ecb3f553bb3"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "In the digit lists for the first 1000 squares, find those that begin with 9 \
and end with 0 or 1.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "32.3", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"1637e83c-d3bc-4f00-b436-d8fa5bd832c3"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"9", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"9", ",", "6", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"9", ",", "8", ",", "0", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"9", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"9", ",", "0", ",", "6", ",", "0", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"9", ",", "5", ",", "4", ",", "8", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"9", ",", "6", ",", "1", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"9", ",", "6", ",", "7", ",", "2", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"9", ",", "0", ",", "0", ",", "6", ",", "0", ",", "1"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"9", ",", "0", ",", "2", ",", "5", ",", "0", ",", "0"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"9", ",", "0", ",", "4", ",", "4", ",", "0", ",", "1"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"9", ",", "1", ",", "9", ",", "6", ",", "8", ",", "1"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"9", ",", "2", ",", "1", ",", "6", ",", "0", ",", "0"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"9", ",", "2", ",", "3", ",", "5", ",", "2", ",", "1"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"9", ",", "3", ",", "8", ",", "9", ",", "6", ",", "1"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"9", ",", "4", ",", "0", ",", "9", ",", "0", ",", "0"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"9", ",", "4", ",", "2", ",", "8", ",", "4", ",", "1"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"9", ",", "5", ",", "8", ",", "4", ",", "4", ",", "1"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"9", ",", "6", ",", "0", ",", "4", ",", "0", ",", "0"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"9", ",", "6", ",", "2", ",", "3", ",", "6", ",", "1"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"9", ",", "7", ",", "8", ",", "1", ",", "2", ",", "1"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"9", ",", "8", ",", "0", ",", "1", ",", "0", ",", "0"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"9", ",", "8", ",", "2", ",", "0", ",", "8", ",", "1"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"9", ",", "9", ",", "8", ",", "0", ",", "0", ",", "1"}], 
          "}"}]}], "}"}]], "ExerciseOutput",ExpressionUUID->
       "4ce6bd38-3345-47cd-b3ea-16c766f62ce4"],
      Apply[TextCell, 
       Cell[
        BoxData[
         RowBox[{"{", 
           RowBox[{
             RowBox[{"{", 
               RowBox[{"9", ",", "0", ",", "0"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"9", ",", "6", ",", "1"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"9", ",", "8", ",", "0", ",", "1"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"9", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], 
             ",", 
             RowBox[{"{", 
               RowBox[{"9", ",", "0", ",", "6", ",", "0", ",", "1"}], "}"}], 
             ",", 
             RowBox[{"{", 
               RowBox[{"9", ",", "5", ",", "4", ",", "8", ",", "1"}], "}"}], 
             ",", 
             RowBox[{"{", 
               RowBox[{"9", ",", "6", ",", "1", ",", "0", ",", "0"}], "}"}], 
             ",", 
             RowBox[{"{", 
               RowBox[{"9", ",", "6", ",", "7", ",", "2", ",", "1"}], "}"}], 
             ",", 
             RowBox[{"{", 
               
               RowBox[{
                "9", ",", "0", ",", "0", ",", "6", ",", "0", ",", "1"}], 
               "}"}], ",", 
             RowBox[{"{", 
               
               RowBox[{
                "9", ",", "0", ",", "2", ",", "5", ",", "0", ",", "0"}], 
               "}"}], ",", 
             RowBox[{"{", 
               
               RowBox[{
                "9", ",", "0", ",", "4", ",", "4", ",", "0", ",", "1"}], 
               "}"}], ",", 
             RowBox[{"{", 
               
               RowBox[{
                "9", ",", "1", ",", "9", ",", "6", ",", "8", ",", "1"}], 
               "}"}], ",", 
             RowBox[{"{", 
               
               RowBox[{
                "9", ",", "2", ",", "1", ",", "6", ",", "0", ",", "0"}], 
               "}"}], ",", 
             RowBox[{"{", 
               
               RowBox[{
                "9", ",", "2", ",", "3", ",", "5", ",", "2", ",", "1"}], 
               "}"}], ",", 
             RowBox[{"{", 
               
               RowBox[{
                "9", ",", "3", ",", "8", ",", "9", ",", "6", ",", "1"}], 
               "}"}], ",", 
             RowBox[{"{", 
               
               RowBox[{
                "9", ",", "4", ",", "0", ",", "9", ",", "0", ",", "0"}], 
               "}"}], ",", 
             RowBox[{"{", 
               
               RowBox[{
                "9", ",", "4", ",", "2", ",", "8", ",", "4", ",", "1"}], 
               "}"}], ",", 
             RowBox[{"{", 
               
               RowBox[{
                "9", ",", "5", ",", "8", ",", "4", ",", "4", ",", "1"}], 
               "}"}], ",", 
             RowBox[{"{", 
               
               RowBox[{
                "9", ",", "6", ",", "0", ",", "4", ",", "0", ",", "0"}], 
               "}"}], ",", 
             RowBox[{"{", 
               
               RowBox[{
                "9", ",", "6", ",", "2", ",", "3", ",", "6", ",", "1"}], 
               "}"}], ",", 
             RowBox[{"{", 
               
               RowBox[{
                "9", ",", "7", ",", "8", ",", "1", ",", "2", ",", "1"}], 
               "}"}], ",", 
             RowBox[{"{", 
               
               RowBox[{
                "9", ",", "8", ",", "0", ",", "1", ",", "0", ",", "0"}], 
               "}"}], ",", 
             RowBox[{"{", 
               
               RowBox[{
                "9", ",", "8", ",", "2", ",", "0", ",", "8", ",", "1"}], 
               "}"}], ",", 
             RowBox[{"{", 
               
               RowBox[{
                "9", ",", "9", ",", "8", ",", "0", ",", "0", ",", "1"}], 
               "}"}]}], "}"}]], "ExerciseOutput", Selectable -> False, 
        Copyable -> False, Editable -> False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"84f8cba5-99c6-45d3-8151-0131a41dd5d4"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "In ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["IntegerDigits",
    BaseStyle->"CodeLink"], "[", 
   RowBox[{
    ButtonBox["Range",
     BaseStyle->"CodeLink"], "[", "100", "]"}], "]"}]], "InlineCode",
  ExpressionUUID->"276b4fef-8a43-4058-9a59-d2323c40c272"],
 " replace all 0\[CloseCurlyQuote]s by ",
 ButtonBox["Gray",
  BaseStyle->"Link"],
 " and all 9\[CloseCurlyQuote]s by ",
 ButtonBox["Orange",
  BaseStyle->"Link"],
 ".",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "32.4", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"afc1b018-117e-48a8-a598-86486b2ee12d"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", "1", "}"}], ",", 
         RowBox[{"{", "2", "}"}], ",", 
         RowBox[{"{", "3", "}"}], ",", 
         RowBox[{"{", "4", "}"}], ",", 
         RowBox[{"{", "5", "}"}], ",", 
         RowBox[{"{", "6", "}"}], ",", 
         RowBox[{"{", "7", "}"}], ",", 
         RowBox[{"{", "8", "}"}], ",", 
         RowBox[{"{", 
          InterpretationBox[
           ButtonBox[
            TooltipBox[
             GraphicsBox[{
               {GrayLevel[0], RectangleBox[{0, 0}]}, 
               {GrayLevel[0], RectangleBox[{1, -1}]}, 
               {RGBColor[1, 0.5, 0], RectangleBox[{0, -1}, {2, 1}]}},
              AspectRatio->1,
              Frame->True,
              
              FrameStyle->RGBColor[
               0.6666666666666666, 0.33333333333333337`, 0.],
              FrameTicks->None,
              
              ImageSize->
               Dynamic[{
                Automatic, 
                 1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                  Magnification])}],
              PlotRangePadding->None],
             "RGBColor[1, 0.5, 0]"],
            Appearance->None,
            BaseStyle->{},
            BaselinePosition->Baseline,
            ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
              If[
               Not[
                AbsoluteCurrentValue["Deployed"]], 
               SelectionMove[Typeset`box$, All, Expression]; 
               FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
               FrontEnd`Private`$ColorSelectorInitialColor = 
                RGBColor[1, 0.5, 0]; 
               FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
               MathLink`CallFrontEnd[
                 FrontEnd`AttachCell[Typeset`box$, 
                  FrontEndResource["RGBColorValueSelector"], {
                  0, {Left, Bottom}}, {Left, Top}, 
                  "ClosingActions" -> {
                   "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
            DefaultBaseStyle->{},
            Evaluator->Automatic,
            Method->"Preemptive"],
           RGBColor[1, 0.5, 0],
           Editable->False,
           Selectable->False], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           InterpretationBox[
            ButtonBox[
             TooltipBox[
              GraphicsBox[{
                {GrayLevel[0], RectangleBox[{0, 0}]}, 
                {GrayLevel[0], RectangleBox[{1, -1}]}, 
                {GrayLevel[0.5], RectangleBox[{0, -1}, {2, 1}]}},
               AspectRatio->1,
               Frame->True,
               FrameStyle->GrayLevel[0.33333333333333337`],
               FrameTicks->None,
               
               ImageSize->
                Dynamic[{
                 Automatic, 
                  1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                   Magnification])}],
               PlotRangePadding->None],
              "GrayLevel[0.5]"],
             Appearance->None,
             BaseStyle->{},
             BaselinePosition->Baseline,
             ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
               If[
                Not[
                 AbsoluteCurrentValue["Deployed"]], 
                SelectionMove[Typeset`box$, All, Expression]; 
                FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                FrontEnd`Private`$ColorSelectorInitialColor = GrayLevel[0.5]; 
                FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                MathLink`CallFrontEnd[
                  FrontEnd`AttachCell[Typeset`box$, 
                   FrontEndResource["GrayLevelColorValueSelector"], {
                   0, {Left, Bottom}}, {Left, Top}, 
                   "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]],
             DefaultBaseStyle->{},
             Evaluator->Automatic,
             Method->"Preemptive"],
            GrayLevel[0.5],
            Editable->False,
            Selectable->False]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "2"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "3"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "4"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "5"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "6"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "7"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "8"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           InterpretationBox[
            ButtonBox[
             TooltipBox[
              GraphicsBox[{
                {GrayLevel[0], RectangleBox[{0, 0}]}, 
                {GrayLevel[0], RectangleBox[{1, -1}]}, 
                {RGBColor[1, 0.5, 0], RectangleBox[{0, -1}, {2, 1}]}},
               AspectRatio->1,
               Frame->True,
               
               FrameStyle->RGBColor[
                0.6666666666666666, 0.33333333333333337`, 0.],
               FrameTicks->None,
               
               ImageSize->
                Dynamic[{
                 Automatic, 
                  1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                   Magnification])}],
               PlotRangePadding->None],
              "RGBColor[1, 0.5, 0]"],
             Appearance->None,
             BaseStyle->{},
             BaselinePosition->Baseline,
             ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
               If[
                Not[
                 AbsoluteCurrentValue["Deployed"]], 
                SelectionMove[Typeset`box$, All, Expression]; 
                FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                FrontEnd`Private`$ColorSelectorInitialColor = 
                 RGBColor[1, 0.5, 0]; 
                FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                MathLink`CallFrontEnd[
                  FrontEnd`AttachCell[Typeset`box$, 
                   FrontEndResource["RGBColorValueSelector"], {
                   0, {Left, Bottom}}, {Left, Top}, 
                   "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]],
             DefaultBaseStyle->{},
             Evaluator->Automatic,
             Method->"Preemptive"],
            RGBColor[1, 0.5, 0],
            Editable->False,
            Selectable->False]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", 
           InterpretationBox[
            ButtonBox[
             TooltipBox[
              GraphicsBox[{
                {GrayLevel[0], RectangleBox[{0, 0}]}, 
                {GrayLevel[0], RectangleBox[{1, -1}]}, 
                {GrayLevel[0.5], RectangleBox[{0, -1}, {2, 1}]}},
               AspectRatio->1,
               Frame->True,
               FrameStyle->GrayLevel[0.33333333333333337`],
               FrameTicks->None,
               
               ImageSize->
                Dynamic[{
                 Automatic, 
                  1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                   Magnification])}],
               PlotRangePadding->None],
              "GrayLevel[0.5]"],
             Appearance->None,
             BaseStyle->{},
             BaselinePosition->Baseline,
             ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
               If[
                Not[
                 AbsoluteCurrentValue["Deployed"]], 
                SelectionMove[Typeset`box$, All, Expression]; 
                FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                FrontEnd`Private`$ColorSelectorInitialColor = GrayLevel[0.5]; 
                FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                MathLink`CallFrontEnd[
                  FrontEnd`AttachCell[Typeset`box$, 
                   FrontEndResource["GrayLevelColorValueSelector"], {
                   0, {Left, Bottom}}, {Left, Top}, 
                   "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]],
             DefaultBaseStyle->{},
             Evaluator->Automatic,
             Method->"Preemptive"],
            GrayLevel[0.5],
            Editable->False,
            Selectable->False]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", "2"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", "3"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", "4"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", "5"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", "6"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", "7"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", "8"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", 
           InterpretationBox[
            ButtonBox[
             TooltipBox[
              GraphicsBox[{
                {GrayLevel[0], RectangleBox[{0, 0}]}, 
                {GrayLevel[0], RectangleBox[{1, -1}]}, 
                {RGBColor[1, 0.5, 0], RectangleBox[{0, -1}, {2, 1}]}},
               AspectRatio->1,
               Frame->True,
               
               FrameStyle->RGBColor[
                0.6666666666666666, 0.33333333333333337`, 0.],
               FrameTicks->None,
               
               ImageSize->
                Dynamic[{
                 Automatic, 
                  1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                   Magnification])}],
               PlotRangePadding->None],
              "RGBColor[1, 0.5, 0]"],
             Appearance->None,
             BaseStyle->{},
             BaselinePosition->Baseline,
             ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
               If[
                Not[
                 AbsoluteCurrentValue["Deployed"]], 
                SelectionMove[Typeset`box$, All, Expression]; 
                FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                FrontEnd`Private`$ColorSelectorInitialColor = 
                 RGBColor[1, 0.5, 0]; 
                FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                MathLink`CallFrontEnd[
                  FrontEnd`AttachCell[Typeset`box$, 
                   FrontEndResource["RGBColorValueSelector"], {
                   0, {Left, Bottom}}, {Left, Top}, 
                   "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]],
             DefaultBaseStyle->{},
             Evaluator->Automatic,
             Method->"Preemptive"],
            RGBColor[1, 0.5, 0],
            Editable->False,
            Selectable->False]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"3", ",", 
           InterpretationBox[
            ButtonBox[
             TooltipBox[
              GraphicsBox[{
                {GrayLevel[0], RectangleBox[{0, 0}]}, 
                {GrayLevel[0], RectangleBox[{1, -1}]}, 
                {GrayLevel[0.5], RectangleBox[{0, -1}, {2, 1}]}},
               AspectRatio->1,
               Frame->True,
               FrameStyle->GrayLevel[0.33333333333333337`],
               FrameTicks->None,
               
               ImageSize->
                Dynamic[{
                 Automatic, 
                  1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                   Magnification])}],
               PlotRangePadding->None],
              "GrayLevel[0.5]"],
             Appearance->None,
             BaseStyle->{},
             BaselinePosition->Baseline,
             ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
               If[
                Not[
                 AbsoluteCurrentValue["Deployed"]], 
                SelectionMove[Typeset`box$, All, Expression]; 
                FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                FrontEnd`Private`$ColorSelectorInitialColor = GrayLevel[0.5]; 
                FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                MathLink`CallFrontEnd[
                  FrontEnd`AttachCell[Typeset`box$, 
                   FrontEndResource["GrayLevelColorValueSelector"], {
                   0, {Left, Bottom}}, {Left, Top}, 
                   "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]],
             DefaultBaseStyle->{},
             Evaluator->Automatic,
             Method->"Preemptive"],
            GrayLevel[0.5],
            Editable->False,
            Selectable->False]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"3", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"3", ",", "2"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"3", ",", "3"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"3", ",", "4"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"3", ",", "5"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"3", ",", "6"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"3", ",", "7"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"3", ",", "8"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"3", ",", 
           InterpretationBox[
            ButtonBox[
             TooltipBox[
              GraphicsBox[{
                {GrayLevel[0], RectangleBox[{0, 0}]}, 
                {GrayLevel[0], RectangleBox[{1, -1}]}, 
                {RGBColor[1, 0.5, 0], RectangleBox[{0, -1}, {2, 1}]}},
               AspectRatio->1,
               Frame->True,
               
               FrameStyle->RGBColor[
                0.6666666666666666, 0.33333333333333337`, 0.],
               FrameTicks->None,
               
               ImageSize->
                Dynamic[{
                 Automatic, 
                  1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                   Magnification])}],
               PlotRangePadding->None],
              "RGBColor[1, 0.5, 0]"],
             Appearance->None,
             BaseStyle->{},
             BaselinePosition->Baseline,
             ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
               If[
                Not[
                 AbsoluteCurrentValue["Deployed"]], 
                SelectionMove[Typeset`box$, All, Expression]; 
                FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                FrontEnd`Private`$ColorSelectorInitialColor = 
                 RGBColor[1, 0.5, 0]; 
                FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                MathLink`CallFrontEnd[
                  FrontEnd`AttachCell[Typeset`box$, 
                   FrontEndResource["RGBColorValueSelector"], {
                   0, {Left, Bottom}}, {Left, Top}, 
                   "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]],
             DefaultBaseStyle->{},
             Evaluator->Automatic,
             Method->"Preemptive"],
            RGBColor[1, 0.5, 0],
            Editable->False,
            Selectable->False]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"4", ",", 
           InterpretationBox[
            ButtonBox[
             TooltipBox[
              GraphicsBox[{
                {GrayLevel[0], RectangleBox[{0, 0}]}, 
                {GrayLevel[0], RectangleBox[{1, -1}]}, 
                {GrayLevel[0.5], RectangleBox[{0, -1}, {2, 1}]}},
               AspectRatio->1,
               Frame->True,
               FrameStyle->GrayLevel[0.33333333333333337`],
               FrameTicks->None,
               
               ImageSize->
                Dynamic[{
                 Automatic, 
                  1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                   Magnification])}],
               PlotRangePadding->None],
              "GrayLevel[0.5]"],
             Appearance->None,
             BaseStyle->{},
             BaselinePosition->Baseline,
             ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
               If[
                Not[
                 AbsoluteCurrentValue["Deployed"]], 
                SelectionMove[Typeset`box$, All, Expression]; 
                FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                FrontEnd`Private`$ColorSelectorInitialColor = GrayLevel[0.5]; 
                FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                MathLink`CallFrontEnd[
                  FrontEnd`AttachCell[Typeset`box$, 
                   FrontEndResource["GrayLevelColorValueSelector"], {
                   0, {Left, Bottom}}, {Left, Top}, 
                   "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]],
             DefaultBaseStyle->{},
             Evaluator->Automatic,
             Method->"Preemptive"],
            GrayLevel[0.5],
            Editable->False,
            Selectable->False]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"4", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"4", ",", "2"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"4", ",", "3"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"4", ",", "4"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"4", ",", "5"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"4", ",", "6"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"4", ",", "7"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"4", ",", "8"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"4", ",", 
           InterpretationBox[
            ButtonBox[
             TooltipBox[
              GraphicsBox[{
                {GrayLevel[0], RectangleBox[{0, 0}]}, 
                {GrayLevel[0], RectangleBox[{1, -1}]}, 
                {RGBColor[1, 0.5, 0], RectangleBox[{0, -1}, {2, 1}]}},
               AspectRatio->1,
               Frame->True,
               
               FrameStyle->RGBColor[
                0.6666666666666666, 0.33333333333333337`, 0.],
               FrameTicks->None,
               
               ImageSize->
                Dynamic[{
                 Automatic, 
                  1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                   Magnification])}],
               PlotRangePadding->None],
              "RGBColor[1, 0.5, 0]"],
             Appearance->None,
             BaseStyle->{},
             BaselinePosition->Baseline,
             ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
               If[
                Not[
                 AbsoluteCurrentValue["Deployed"]], 
                SelectionMove[Typeset`box$, All, Expression]; 
                FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                FrontEnd`Private`$ColorSelectorInitialColor = 
                 RGBColor[1, 0.5, 0]; 
                FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                MathLink`CallFrontEnd[
                  FrontEnd`AttachCell[Typeset`box$, 
                   FrontEndResource["RGBColorValueSelector"], {
                   0, {Left, Bottom}}, {Left, Top}, 
                   "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]],
             DefaultBaseStyle->{},
             Evaluator->Automatic,
             Method->"Preemptive"],
            RGBColor[1, 0.5, 0],
            Editable->False,
            Selectable->False]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"5", ",", 
           InterpretationBox[
            ButtonBox[
             TooltipBox[
              GraphicsBox[{
                {GrayLevel[0], RectangleBox[{0, 0}]}, 
                {GrayLevel[0], RectangleBox[{1, -1}]}, 
                {GrayLevel[0.5], RectangleBox[{0, -1}, {2, 1}]}},
               AspectRatio->1,
               Frame->True,
               FrameStyle->GrayLevel[0.33333333333333337`],
               FrameTicks->None,
               
               ImageSize->
                Dynamic[{
                 Automatic, 
                  1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                   Magnification])}],
               PlotRangePadding->None],
              "GrayLevel[0.5]"],
             Appearance->None,
             BaseStyle->{},
             BaselinePosition->Baseline,
             ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
               If[
                Not[
                 AbsoluteCurrentValue["Deployed"]], 
                SelectionMove[Typeset`box$, All, Expression]; 
                FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                FrontEnd`Private`$ColorSelectorInitialColor = GrayLevel[0.5]; 
                FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                MathLink`CallFrontEnd[
                  FrontEnd`AttachCell[Typeset`box$, 
                   FrontEndResource["GrayLevelColorValueSelector"], {
                   0, {Left, Bottom}}, {Left, Top}, 
                   "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]],
             DefaultBaseStyle->{},
             Evaluator->Automatic,
             Method->"Preemptive"],
            GrayLevel[0.5],
            Editable->False,
            Selectable->False]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"5", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"5", ",", "2"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"5", ",", "3"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"5", ",", "4"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"5", ",", "5"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"5", ",", "6"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"5", ",", "7"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"5", ",", "8"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"5", ",", 
           InterpretationBox[
            ButtonBox[
             TooltipBox[
              GraphicsBox[{
                {GrayLevel[0], RectangleBox[{0, 0}]}, 
                {GrayLevel[0], RectangleBox[{1, -1}]}, 
                {RGBColor[1, 0.5, 0], RectangleBox[{0, -1}, {2, 1}]}},
               AspectRatio->1,
               Frame->True,
               
               FrameStyle->RGBColor[
                0.6666666666666666, 0.33333333333333337`, 0.],
               FrameTicks->None,
               
               ImageSize->
                Dynamic[{
                 Automatic, 
                  1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                   Magnification])}],
               PlotRangePadding->None],
              "RGBColor[1, 0.5, 0]"],
             Appearance->None,
             BaseStyle->{},
             BaselinePosition->Baseline,
             ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
               If[
                Not[
                 AbsoluteCurrentValue["Deployed"]], 
                SelectionMove[Typeset`box$, All, Expression]; 
                FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                FrontEnd`Private`$ColorSelectorInitialColor = 
                 RGBColor[1, 0.5, 0]; 
                FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                MathLink`CallFrontEnd[
                  FrontEnd`AttachCell[Typeset`box$, 
                   FrontEndResource["RGBColorValueSelector"], {
                   0, {Left, Bottom}}, {Left, Top}, 
                   "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]],
             DefaultBaseStyle->{},
             Evaluator->Automatic,
             Method->"Preemptive"],
            RGBColor[1, 0.5, 0],
            Editable->False,
            Selectable->False]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"6", ",", 
           InterpretationBox[
            ButtonBox[
             TooltipBox[
              GraphicsBox[{
                {GrayLevel[0], RectangleBox[{0, 0}]}, 
                {GrayLevel[0], RectangleBox[{1, -1}]}, 
                {GrayLevel[0.5], RectangleBox[{0, -1}, {2, 1}]}},
               AspectRatio->1,
               Frame->True,
               FrameStyle->GrayLevel[0.33333333333333337`],
               FrameTicks->None,
               
               ImageSize->
                Dynamic[{
                 Automatic, 
                  1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                   Magnification])}],
               PlotRangePadding->None],
              "GrayLevel[0.5]"],
             Appearance->None,
             BaseStyle->{},
             BaselinePosition->Baseline,
             ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
               If[
                Not[
                 AbsoluteCurrentValue["Deployed"]], 
                SelectionMove[Typeset`box$, All, Expression]; 
                FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                FrontEnd`Private`$ColorSelectorInitialColor = GrayLevel[0.5]; 
                FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                MathLink`CallFrontEnd[
                  FrontEnd`AttachCell[Typeset`box$, 
                   FrontEndResource["GrayLevelColorValueSelector"], {
                   0, {Left, Bottom}}, {Left, Top}, 
                   "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]],
             DefaultBaseStyle->{},
             Evaluator->Automatic,
             Method->"Preemptive"],
            GrayLevel[0.5],
            Editable->False,
            Selectable->False]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"6", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"6", ",", "2"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"6", ",", "3"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"6", ",", "4"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"6", ",", "5"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"6", ",", "6"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"6", ",", "7"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"6", ",", "8"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"6", ",", 
           InterpretationBox[
            ButtonBox[
             TooltipBox[
              GraphicsBox[{
                {GrayLevel[0], RectangleBox[{0, 0}]}, 
                {GrayLevel[0], RectangleBox[{1, -1}]}, 
                {RGBColor[1, 0.5, 0], RectangleBox[{0, -1}, {2, 1}]}},
               AspectRatio->1,
               Frame->True,
               
               FrameStyle->RGBColor[
                0.6666666666666666, 0.33333333333333337`, 0.],
               FrameTicks->None,
               
               ImageSize->
                Dynamic[{
                 Automatic, 
                  1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                   Magnification])}],
               PlotRangePadding->None],
              "RGBColor[1, 0.5, 0]"],
             Appearance->None,
             BaseStyle->{},
             BaselinePosition->Baseline,
             ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
               If[
                Not[
                 AbsoluteCurrentValue["Deployed"]], 
                SelectionMove[Typeset`box$, All, Expression]; 
                FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                FrontEnd`Private`$ColorSelectorInitialColor = 
                 RGBColor[1, 0.5, 0]; 
                FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                MathLink`CallFrontEnd[
                  FrontEnd`AttachCell[Typeset`box$, 
                   FrontEndResource["RGBColorValueSelector"], {
                   0, {Left, Bottom}}, {Left, Top}, 
                   "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]],
             DefaultBaseStyle->{},
             Evaluator->Automatic,
             Method->"Preemptive"],
            RGBColor[1, 0.5, 0],
            Editable->False,
            Selectable->False]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"7", ",", 
           InterpretationBox[
            ButtonBox[
             TooltipBox[
              GraphicsBox[{
                {GrayLevel[0], RectangleBox[{0, 0}]}, 
                {GrayLevel[0], RectangleBox[{1, -1}]}, 
                {GrayLevel[0.5], RectangleBox[{0, -1}, {2, 1}]}},
               AspectRatio->1,
               Frame->True,
               FrameStyle->GrayLevel[0.33333333333333337`],
               FrameTicks->None,
               
               ImageSize->
                Dynamic[{
                 Automatic, 
                  1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                   Magnification])}],
               PlotRangePadding->None],
              "GrayLevel[0.5]"],
             Appearance->None,
             BaseStyle->{},
             BaselinePosition->Baseline,
             ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
               If[
                Not[
                 AbsoluteCurrentValue["Deployed"]], 
                SelectionMove[Typeset`box$, All, Expression]; 
                FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                FrontEnd`Private`$ColorSelectorInitialColor = GrayLevel[0.5]; 
                FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                MathLink`CallFrontEnd[
                  FrontEnd`AttachCell[Typeset`box$, 
                   FrontEndResource["GrayLevelColorValueSelector"], {
                   0, {Left, Bottom}}, {Left, Top}, 
                   "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]],
             DefaultBaseStyle->{},
             Evaluator->Automatic,
             Method->"Preemptive"],
            GrayLevel[0.5],
            Editable->False,
            Selectable->False]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"7", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"7", ",", "2"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"7", ",", "3"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"7", ",", "4"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"7", ",", "5"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"7", ",", "6"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"7", ",", "7"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"7", ",", "8"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"7", ",", 
           InterpretationBox[
            ButtonBox[
             TooltipBox[
              GraphicsBox[{
                {GrayLevel[0], RectangleBox[{0, 0}]}, 
                {GrayLevel[0], RectangleBox[{1, -1}]}, 
                {RGBColor[1, 0.5, 0], RectangleBox[{0, -1}, {2, 1}]}},
               AspectRatio->1,
               Frame->True,
               
               FrameStyle->RGBColor[
                0.6666666666666666, 0.33333333333333337`, 0.],
               FrameTicks->None,
               ImageSize->
                Dynamic[{
                 Automatic, 
                  1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                   Magnification])}],
               PlotRangePadding->None],
              "RGBColor[1, 0.5, 0]"],
             Appearance->None,
             BaseStyle->{},
             BaselinePosition->Baseline,
             ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
               If[
                Not[
                 AbsoluteCurrentValue["Deployed"]], 
                SelectionMove[Typeset`box$, All, Expression]; 
                FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                FrontEnd`Private`$ColorSelectorInitialColor = 
                 RGBColor[1, 0.5, 0]; 
                FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                MathLink`CallFrontEnd[
                  FrontEnd`AttachCell[Typeset`box$, 
                   FrontEndResource["RGBColorValueSelector"], {
                   0, {Left, Bottom}}, {Left, Top}, 
                   "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]],
             DefaultBaseStyle->{},
             Evaluator->Automatic,
             Method->"Preemptive"],
            RGBColor[1, 0.5, 0],
            Editable->False,
            Selectable->False]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"8", ",", 
           InterpretationBox[
            ButtonBox[
             TooltipBox[
              GraphicsBox[{
                {GrayLevel[0], RectangleBox[{0, 0}]}, 
                {GrayLevel[0], RectangleBox[{1, -1}]}, 
                {GrayLevel[0.5], RectangleBox[{0, -1}, {2, 1}]}},
               AspectRatio->1,
               Frame->True,
               FrameStyle->GrayLevel[0.33333333333333337`],
               FrameTicks->None,
               
               ImageSize->
                Dynamic[{
                 Automatic, 
                  1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                   Magnification])}],
               PlotRangePadding->None],
              "GrayLevel[0.5]"],
             Appearance->None,
             BaseStyle->{},
             BaselinePosition->Baseline,
             ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
               If[
                Not[
                 AbsoluteCurrentValue["Deployed"]], 
                SelectionMove[Typeset`box$, All, Expression]; 
                FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                FrontEnd`Private`$ColorSelectorInitialColor = GrayLevel[0.5]; 
                FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                MathLink`CallFrontEnd[
                  FrontEnd`AttachCell[Typeset`box$, 
                   FrontEndResource["GrayLevelColorValueSelector"], {
                   0, {Left, Bottom}}, {Left, Top}, 
                   "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]],
             DefaultBaseStyle->{},
             Evaluator->Automatic,
             Method->"Preemptive"],
            GrayLevel[0.5],
            Editable->False,
            Selectable->False]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"8", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"8", ",", "2"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"8", ",", "3"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"8", ",", "4"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"8", ",", "5"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"8", ",", "6"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"8", ",", "7"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"8", ",", "8"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"8", ",", 
           InterpretationBox[
            ButtonBox[
             TooltipBox[
              GraphicsBox[{
                {GrayLevel[0], RectangleBox[{0, 0}]}, 
                {GrayLevel[0], RectangleBox[{1, -1}]}, 
                {RGBColor[1, 0.5, 0], RectangleBox[{0, -1}, {2, 1}]}},
               AspectRatio->1,
               Frame->True,
               FrameStyle->RGBColor[
                0.6666666666666666, 0.33333333333333337`, 0.],
               FrameTicks->None,
               
               ImageSize->
                Dynamic[{
                 Automatic, 
                  1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                   Magnification])}],
               PlotRangePadding->None],
              "RGBColor[1, 0.5, 0]"],
             Appearance->None,
             BaseStyle->{},
             BaselinePosition->Baseline,
             ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
               If[
                Not[
                 AbsoluteCurrentValue["Deployed"]], 
                SelectionMove[Typeset`box$, All, Expression]; 
                FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                FrontEnd`Private`$ColorSelectorInitialColor = 
                 RGBColor[1, 0.5, 0]; 
                FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                MathLink`CallFrontEnd[
                  FrontEnd`AttachCell[Typeset`box$, 
                   FrontEndResource["RGBColorValueSelector"], {
                   0, {Left, Bottom}}, {Left, Top}, 
                   "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]],
             DefaultBaseStyle->{},
             Evaluator->Automatic,
             Method->"Preemptive"],
            RGBColor[1, 0.5, 0],
            Editable->False,
            Selectable->False]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           InterpretationBox[
            ButtonBox[
             TooltipBox[
              GraphicsBox[{
                {GrayLevel[0], RectangleBox[{0, 0}]}, 
                {GrayLevel[0], RectangleBox[{1, -1}]}, 
                {RGBColor[1, 0.5, 0], RectangleBox[{0, -1}, {2, 1}]}},
               AspectRatio->1,
               Frame->True,
               
               FrameStyle->RGBColor[
                0.6666666666666666, 0.33333333333333337`, 0.],
               FrameTicks->None,
               
               ImageSize->
                Dynamic[{
                 Automatic, 
                  1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                   Magnification])}],
               PlotRangePadding->None],
              "RGBColor[1, 0.5, 0]"],
             Appearance->None,
             BaseStyle->{},
             BaselinePosition->Baseline,
             ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
               If[
                Not[
                 AbsoluteCurrentValue["Deployed"]], 
                SelectionMove[Typeset`box$, All, Expression]; 
                FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                FrontEnd`Private`$ColorSelectorInitialColor = 
                 RGBColor[1, 0.5, 0]; 
                FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                MathLink`CallFrontEnd[
                  FrontEnd`AttachCell[Typeset`box$, 
                   FrontEndResource["RGBColorValueSelector"], {
                   0, {Left, Bottom}}, {Left, Top}, 
                   "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]],
             DefaultBaseStyle->{},
             Evaluator->Automatic,
             Method->"Preemptive"],
            RGBColor[1, 0.5, 0],
            Editable->False,
            Selectable->False], ",", 
           InterpretationBox[
            ButtonBox[
             TooltipBox[
              GraphicsBox[{
                {GrayLevel[0], RectangleBox[{0, 0}]}, 
                {GrayLevel[0], RectangleBox[{1, -1}]}, 
                {GrayLevel[0.5], RectangleBox[{0, -1}, {2, 1}]}},
               AspectRatio->1,
               Frame->True,
               FrameStyle->GrayLevel[0.33333333333333337`],
               FrameTicks->None,
               
               ImageSize->
                Dynamic[{
                 Automatic, 
                  1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                   Magnification])}],
               PlotRangePadding->None],
              "GrayLevel[0.5]"],
             Appearance->None,
             BaseStyle->{},
             BaselinePosition->Baseline,
             ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
               If[
                Not[
                 AbsoluteCurrentValue["Deployed"]], 
                SelectionMove[Typeset`box$, All, Expression]; 
                FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                FrontEnd`Private`$ColorSelectorInitialColor = GrayLevel[0.5]; 
                FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                MathLink`CallFrontEnd[
                  FrontEnd`AttachCell[Typeset`box$, 
                   FrontEndResource["GrayLevelColorValueSelector"], {
                   0, {Left, Bottom}}, {Left, Top}, 
                   "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]],
             DefaultBaseStyle->{},
             Evaluator->Automatic,
             Method->"Preemptive"],
            GrayLevel[0.5],
            Editable->False,
            Selectable->False]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           InterpretationBox[
            ButtonBox[
             TooltipBox[
              GraphicsBox[{
                {GrayLevel[0], RectangleBox[{0, 0}]}, 
                {GrayLevel[0], RectangleBox[{1, -1}]}, 
                {RGBColor[1, 0.5, 0], RectangleBox[{0, -1}, {2, 1}]}},
               AspectRatio->1,
               Frame->True,
               
               FrameStyle->RGBColor[
                0.6666666666666666, 0.33333333333333337`, 0.],
               FrameTicks->None,
               
               ImageSize->
                Dynamic[{
                 Automatic, 
                  1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                   Magnification])}],
               PlotRangePadding->None],
              "RGBColor[1, 0.5, 0]"],
             Appearance->None,
             BaseStyle->{},
             BaselinePosition->Baseline,
             ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
               If[
                Not[
                 AbsoluteCurrentValue["Deployed"]], 
                SelectionMove[Typeset`box$, All, Expression]; 
                FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                FrontEnd`Private`$ColorSelectorInitialColor = 
                 RGBColor[1, 0.5, 0]; 
                FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                MathLink`CallFrontEnd[
                  FrontEnd`AttachCell[Typeset`box$, 
                   FrontEndResource["RGBColorValueSelector"], {
                   0, {Left, Bottom}}, {Left, Top}, 
                   "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]],
             DefaultBaseStyle->{},
             Evaluator->Automatic,
             Method->"Preemptive"],
            RGBColor[1, 0.5, 0],
            Editable->False,
            Selectable->False], ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           InterpretationBox[
            ButtonBox[
             TooltipBox[
              GraphicsBox[{
                {GrayLevel[0], RectangleBox[{0, 0}]}, 
                {GrayLevel[0], RectangleBox[{1, -1}]}, 
                {RGBColor[1, 0.5, 0], RectangleBox[{0, -1}, {2, 1}]}},
               AspectRatio->1,
               Frame->True,
               
               FrameStyle->RGBColor[
                0.6666666666666666, 0.33333333333333337`, 0.],
               FrameTicks->None,
               
               ImageSize->
                Dynamic[{
                 Automatic, 
                  1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                   Magnification])}],
               PlotRangePadding->None],
              "RGBColor[1, 0.5, 0]"],
             Appearance->None,
             BaseStyle->{},
             BaselinePosition->Baseline,
             ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
               If[
                Not[
                 AbsoluteCurrentValue["Deployed"]], 
                SelectionMove[Typeset`box$, All, Expression]; 
                FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                FrontEnd`Private`$ColorSelectorInitialColor = 
                 RGBColor[1, 0.5, 0]; 
                FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                MathLink`CallFrontEnd[
                  FrontEnd`AttachCell[Typeset`box$, 
                   FrontEndResource["RGBColorValueSelector"], {
                   0, {Left, Bottom}}, {Left, Top}, 
                   "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]],
             DefaultBaseStyle->{},
             Evaluator->Automatic,
             Method->"Preemptive"],
            RGBColor[1, 0.5, 0],
            Editable->False,
            Selectable->False], ",", "2"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           InterpretationBox[
            ButtonBox[
             TooltipBox[
              GraphicsBox[{
                {GrayLevel[0], RectangleBox[{0, 0}]}, 
                {GrayLevel[0], RectangleBox[{1, -1}]}, 
                {RGBColor[1, 0.5, 0], RectangleBox[{0, -1}, {2, 1}]}},
               AspectRatio->1,
               Frame->True,
               
               FrameStyle->RGBColor[
                0.6666666666666666, 0.33333333333333337`, 0.],
               FrameTicks->None,
               
               ImageSize->
                Dynamic[{
                 Automatic, 
                  1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                   Magnification])}],
               PlotRangePadding->None],
              "RGBColor[1, 0.5, 0]"],
             Appearance->None,
             BaseStyle->{},
             BaselinePosition->Baseline,
             ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
               If[
                Not[
                 AbsoluteCurrentValue["Deployed"]], 
                SelectionMove[Typeset`box$, All, Expression]; 
                FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                FrontEnd`Private`$ColorSelectorInitialColor = 
                 RGBColor[1, 0.5, 0]; 
                FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                MathLink`CallFrontEnd[
                  FrontEnd`AttachCell[Typeset`box$, 
                   FrontEndResource["RGBColorValueSelector"], {
                   0, {Left, Bottom}}, {Left, Top}, 
                   "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]],
             DefaultBaseStyle->{},
             Evaluator->Automatic,
             Method->"Preemptive"],
            RGBColor[1, 0.5, 0],
            Editable->False,
            Selectable->False], ",", "3"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           InterpretationBox[
            ButtonBox[
             TooltipBox[
              GraphicsBox[{
                {GrayLevel[0], RectangleBox[{0, 0}]}, 
                {GrayLevel[0], RectangleBox[{1, -1}]}, 
                {RGBColor[1, 0.5, 0], RectangleBox[{0, -1}, {2, 1}]}},
               AspectRatio->1,
               Frame->True,
               
               FrameStyle->RGBColor[
                0.6666666666666666, 0.33333333333333337`, 0.],
               FrameTicks->None,
               
               ImageSize->
                Dynamic[{
                 Automatic, 
                  1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                   Magnification])}],
               PlotRangePadding->None],
              "RGBColor[1, 0.5, 0]"],
             Appearance->None,
             BaseStyle->{},
             BaselinePosition->Baseline,
             ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
               If[
                Not[
                 AbsoluteCurrentValue["Deployed"]], 
                SelectionMove[Typeset`box$, All, Expression]; 
                FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                FrontEnd`Private`$ColorSelectorInitialColor = 
                 RGBColor[1, 0.5, 0]; 
                FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                MathLink`CallFrontEnd[
                  FrontEnd`AttachCell[Typeset`box$, 
                   FrontEndResource["RGBColorValueSelector"], {
                   0, {Left, Bottom}}, {Left, Top}, 
                   "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]],
             DefaultBaseStyle->{},
             Evaluator->Automatic,
             Method->"Preemptive"],
            RGBColor[1, 0.5, 0],
            Editable->False,
            Selectable->False], ",", "4"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           InterpretationBox[
            ButtonBox[
             TooltipBox[
              GraphicsBox[{
                {GrayLevel[0], RectangleBox[{0, 0}]}, 
                {GrayLevel[0], RectangleBox[{1, -1}]}, 
                {RGBColor[1, 0.5, 0], RectangleBox[{0, -1}, {2, 1}]}},
               AspectRatio->1,
               Frame->True,
               
               FrameStyle->RGBColor[
                0.6666666666666666, 0.33333333333333337`, 0.],
               FrameTicks->None,
               
               ImageSize->
                Dynamic[{
                 Automatic, 
                  1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                   Magnification])}],
               PlotRangePadding->None],
              "RGBColor[1, 0.5, 0]"],
             Appearance->None,
             BaseStyle->{},
             BaselinePosition->Baseline,
             ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
               If[
                Not[
                 AbsoluteCurrentValue["Deployed"]], 
                SelectionMove[Typeset`box$, All, Expression]; 
                FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                FrontEnd`Private`$ColorSelectorInitialColor = 
                 RGBColor[1, 0.5, 0]; 
                FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                MathLink`CallFrontEnd[
                  FrontEnd`AttachCell[Typeset`box$, 
                   FrontEndResource["RGBColorValueSelector"], {
                   0, {Left, Bottom}}, {Left, Top}, 
                   "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]],
             DefaultBaseStyle->{},
             Evaluator->Automatic,
             Method->"Preemptive"],
            RGBColor[1, 0.5, 0],
            Editable->False,
            Selectable->False], ",", "5"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           InterpretationBox[
            ButtonBox[
             TooltipBox[
              GraphicsBox[{
                {GrayLevel[0], RectangleBox[{0, 0}]}, 
                {GrayLevel[0], RectangleBox[{1, -1}]}, 
                {RGBColor[1, 0.5, 0], RectangleBox[{0, -1}, {2, 1}]}},
               AspectRatio->1,
               Frame->True,
               
               FrameStyle->RGBColor[
                0.6666666666666666, 0.33333333333333337`, 0.],
               FrameTicks->None,
               
               ImageSize->
                Dynamic[{
                 Automatic, 
                  1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                   Magnification])}],
               PlotRangePadding->None],
              "RGBColor[1, 0.5, 0]"],
             Appearance->None,
             BaseStyle->{},
             BaselinePosition->Baseline,
             ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
               If[
                Not[
                 AbsoluteCurrentValue["Deployed"]], 
                SelectionMove[Typeset`box$, All, Expression]; 
                FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                FrontEnd`Private`$ColorSelectorInitialColor = 
                 RGBColor[1, 0.5, 0]; 
                FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                MathLink`CallFrontEnd[
                  FrontEnd`AttachCell[Typeset`box$, 
                   FrontEndResource["RGBColorValueSelector"], {
                   0, {Left, Bottom}}, {Left, Top}, 
                   "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]],
             DefaultBaseStyle->{},
             Evaluator->Automatic,
             Method->"Preemptive"],
            RGBColor[1, 0.5, 0],
            Editable->False,
            Selectable->False], ",", "6"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           InterpretationBox[
            ButtonBox[
             TooltipBox[
              GraphicsBox[{
                {GrayLevel[0], RectangleBox[{0, 0}]}, 
                {GrayLevel[0], RectangleBox[{1, -1}]}, 
                {RGBColor[1, 0.5, 0], RectangleBox[{0, -1}, {2, 1}]}},
               AspectRatio->1,
               Frame->True,
               
               FrameStyle->RGBColor[
                0.6666666666666666, 0.33333333333333337`, 0.],
               FrameTicks->None,
               
               ImageSize->
                Dynamic[{
                 Automatic, 
                  1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                   Magnification])}],
               PlotRangePadding->None],
              "RGBColor[1, 0.5, 0]"],
             Appearance->None,
             BaseStyle->{},
             BaselinePosition->Baseline,
             ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
               If[
                Not[
                 AbsoluteCurrentValue["Deployed"]], 
                SelectionMove[Typeset`box$, All, Expression]; 
                FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                FrontEnd`Private`$ColorSelectorInitialColor = 
                 RGBColor[1, 0.5, 0]; 
                FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                MathLink`CallFrontEnd[
                  FrontEnd`AttachCell[Typeset`box$, 
                   FrontEndResource["RGBColorValueSelector"], {
                   0, {Left, Bottom}}, {Left, Top}, 
                   "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]],
             DefaultBaseStyle->{},
             Evaluator->Automatic,
             Method->"Preemptive"],
            RGBColor[1, 0.5, 0],
            Editable->False,
            Selectable->False], ",", "7"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           InterpretationBox[
            ButtonBox[
             TooltipBox[
              GraphicsBox[{
                {GrayLevel[0], RectangleBox[{0, 0}]}, 
                {GrayLevel[0], RectangleBox[{1, -1}]}, 
                {RGBColor[1, 0.5, 0], RectangleBox[{0, -1}, {2, 1}]}},
               AspectRatio->1,
               Frame->True,
               
               FrameStyle->RGBColor[
                0.6666666666666666, 0.33333333333333337`, 0.],
               FrameTicks->None,
               
               ImageSize->
                Dynamic[{
                 Automatic, 
                  1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                   Magnification])}],
               PlotRangePadding->None],
              "RGBColor[1, 0.5, 0]"],
             Appearance->None,
             BaseStyle->{},
             BaselinePosition->Baseline,
             ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
               If[
                Not[
                 AbsoluteCurrentValue["Deployed"]], 
                SelectionMove[Typeset`box$, All, Expression]; 
                FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                FrontEnd`Private`$ColorSelectorInitialColor = 
                 RGBColor[1, 0.5, 0]; 
                FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                MathLink`CallFrontEnd[
                  FrontEnd`AttachCell[Typeset`box$, 
                   FrontEndResource["RGBColorValueSelector"], {
                   0, {Left, Bottom}}, {Left, Top}, 
                   "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]],
             DefaultBaseStyle->{},
             Evaluator->Automatic,
             Method->"Preemptive"],
            RGBColor[1, 0.5, 0],
            Editable->False,
            Selectable->False], ",", "8"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           InterpretationBox[
            ButtonBox[
             TooltipBox[
              GraphicsBox[{
                {GrayLevel[0], RectangleBox[{0, 0}]}, 
                {GrayLevel[0], RectangleBox[{1, -1}]}, 
                {RGBColor[1, 0.5, 0], RectangleBox[{0, -1}, {2, 1}]}},
               AspectRatio->1,
               Frame->True,
               
               FrameStyle->RGBColor[
                0.6666666666666666, 0.33333333333333337`, 0.],
               FrameTicks->None,
               
               ImageSize->
                Dynamic[{
                 Automatic, 
                  1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                   Magnification])}],
               PlotRangePadding->None],
              "RGBColor[1, 0.5, 0]"],
             Appearance->None,
             BaseStyle->{},
             BaselinePosition->Baseline,
             ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
               If[
                Not[
                 AbsoluteCurrentValue["Deployed"]], 
                SelectionMove[Typeset`box$, All, Expression]; 
                FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                FrontEnd`Private`$ColorSelectorInitialColor = 
                 RGBColor[1, 0.5, 0]; 
                FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                MathLink`CallFrontEnd[
                  FrontEnd`AttachCell[Typeset`box$, 
                   FrontEndResource["RGBColorValueSelector"], {
                   0, {Left, Bottom}}, {Left, Top}, 
                   "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]],
             DefaultBaseStyle->{},
             Evaluator->Automatic,
             Method->"Preemptive"],
            RGBColor[1, 0.5, 0],
            Editable->False,
            Selectable->False], ",", 
           InterpretationBox[
            ButtonBox[
             TooltipBox[
              GraphicsBox[{
                {GrayLevel[0], RectangleBox[{0, 0}]}, 
                {GrayLevel[0], RectangleBox[{1, -1}]}, 
                {RGBColor[1, 0.5, 0], RectangleBox[{0, -1}, {2, 1}]}},
               AspectRatio->1,
               Frame->True,
               
               FrameStyle->RGBColor[
                0.6666666666666666, 0.33333333333333337`, 0.],
               FrameTicks->None,
               
               ImageSize->
                Dynamic[{
                 Automatic, 
                  1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                   Magnification])}],
               PlotRangePadding->None],
              "RGBColor[1, 0.5, 0]"],
             Appearance->None,
             BaseStyle->{},
             BaselinePosition->Baseline,
             ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
               If[
                Not[
                 AbsoluteCurrentValue["Deployed"]], 
                SelectionMove[Typeset`box$, All, Expression]; 
                FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                FrontEnd`Private`$ColorSelectorInitialColor = 
                 RGBColor[1, 0.5, 0]; 
                FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                MathLink`CallFrontEnd[
                  FrontEnd`AttachCell[Typeset`box$, 
                   FrontEndResource["RGBColorValueSelector"], {
                   0, {Left, Bottom}}, {Left, Top}, 
                   "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]],
             DefaultBaseStyle->{},
             Evaluator->Automatic,
             Method->"Preemptive"],
            RGBColor[1, 0.5, 0],
            Editable->False,
            Selectable->False]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", 
           InterpretationBox[
            ButtonBox[
             TooltipBox[
              GraphicsBox[{
                {GrayLevel[0], RectangleBox[{0, 0}]}, 
                {GrayLevel[0], RectangleBox[{1, -1}]}, 
                {GrayLevel[0.5], RectangleBox[{0, -1}, {2, 1}]}},
               AspectRatio->1,
               Frame->True,
               FrameStyle->GrayLevel[0.33333333333333337`],
               FrameTicks->None,
               
               ImageSize->
                Dynamic[{
                 Automatic, 
                  1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                   Magnification])}],
               PlotRangePadding->None],
              "GrayLevel[0.5]"],
             Appearance->None,
             BaseStyle->{},
             BaselinePosition->Baseline,
             ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
               If[
                Not[
                 AbsoluteCurrentValue["Deployed"]], 
                SelectionMove[Typeset`box$, All, Expression]; 
                FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                FrontEnd`Private`$ColorSelectorInitialColor = GrayLevel[0.5]; 
                FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                MathLink`CallFrontEnd[
                  FrontEnd`AttachCell[Typeset`box$, 
                   FrontEndResource["GrayLevelColorValueSelector"], {
                   0, {Left, Bottom}}, {Left, Top}, 
                   "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]],
             DefaultBaseStyle->{},
             Evaluator->Automatic,
             Method->"Preemptive"],
            GrayLevel[0.5],
            Editable->False,
            Selectable->False], ",", 
           InterpretationBox[
            ButtonBox[
             TooltipBox[
              GraphicsBox[{
                {GrayLevel[0], RectangleBox[{0, 0}]}, 
                {GrayLevel[0], RectangleBox[{1, -1}]}, 
                {GrayLevel[0.5], RectangleBox[{0, -1}, {2, 1}]}},
               AspectRatio->1,
               Frame->True,
               FrameStyle->GrayLevel[0.33333333333333337`],
               FrameTicks->None,
               
               ImageSize->
                Dynamic[{
                 Automatic, 
                  1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                   Magnification])}],
               PlotRangePadding->None],
              "GrayLevel[0.5]"],
             Appearance->None,
             BaseStyle->{},
             BaselinePosition->Baseline,
             ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
               If[
                Not[
                 AbsoluteCurrentValue["Deployed"]], 
                SelectionMove[Typeset`box$, All, Expression]; 
                FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                FrontEnd`Private`$ColorSelectorInitialColor = GrayLevel[0.5]; 
                FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                MathLink`CallFrontEnd[
                  FrontEnd`AttachCell[Typeset`box$, 
                   FrontEndResource["GrayLevelColorValueSelector"], {
                   0, {Left, Bottom}}, {Left, Top}, 
                   "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]],
             DefaultBaseStyle->{},
             Evaluator->Automatic,
             Method->"Preemptive"],
            GrayLevel[0.5],
            Editable->False,
            Selectable->False]}], "}"}]}], "}"}]], "ExerciseOutput",
       ExpressionUUID->"90beaab9-51dc-48ee-8c7a-5eef5d897de4"],
      Apply[TextCell, 
       Cell[
        BoxData[
         RowBox[{"{", 
           RowBox[{
             RowBox[{"{", "1", "}"}], ",", 
             RowBox[{"{", "2", "}"}], ",", 
             RowBox[{"{", "3", "}"}], ",", 
             RowBox[{"{", "4", "}"}], ",", 
             RowBox[{"{", "5", "}"}], ",", 
             RowBox[{"{", "6", "}"}], ",", 
             RowBox[{"{", "7", "}"}], ",", 
             RowBox[{"{", "8", "}"}], ",", 
             RowBox[{"{", 
               InterpretationBox[
                ButtonBox[
                 TooltipBox[
                  GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[1, 0.5, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                   Frame -> True, FrameStyle -> 
                   RGBColor[0.6666666666666666, 0.33333333333333337`, 0.], 
                   FrameTicks -> None, ImageSize -> 
                   Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                  "RGBColor[1, 0.5, 0]"], Appearance -> None, BaseStyle -> {},
                  BaselinePosition -> Baseline, ButtonFunction :> 
                 With[{Typeset`box$ = EvaluationBox[]}, 
                   If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[1, 0.5, 0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
                 Automatic, Method -> "Preemptive"], 
                RGBColor[1, 0.5, 0], Editable -> False, Selectable -> False], 
               "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"1", ",", 
                 InterpretationBox[
                  ButtonBox[
                   TooltipBox[
                    GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    GrayLevel[0.5], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                    Frame -> True, FrameStyle -> 
                    GrayLevel[0.33333333333333337`], FrameTicks -> None, 
                    ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                    "GrayLevel[0.5]"], Appearance -> None, BaseStyle -> {}, 
                   BaselinePosition -> Baseline, ButtonFunction :> 
                   With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[0.5]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
                   Automatic, Method -> "Preemptive"], 
                  GrayLevel[0.5], Editable -> False, Selectable -> False]}], 
               "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"1", ",", "1"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"1", ",", "2"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"1", ",", "3"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"1", ",", "4"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"1", ",", "5"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"1", ",", "6"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"1", ",", "7"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"1", ",", "8"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"1", ",", 
                 InterpretationBox[
                  ButtonBox[
                   TooltipBox[
                    GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[1, 0.5, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                    Frame -> True, FrameStyle -> 
                    RGBColor[0.6666666666666666, 0.33333333333333337`, 0.], 
                    FrameTicks -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                    "RGBColor[1, 0.5, 0]"], Appearance -> None, 
                   BaseStyle -> {}, BaselinePosition -> Baseline, 
                   ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[1, 0.5, 0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
                   Automatic, Method -> "Preemptive"], 
                  RGBColor[1, 0.5, 0], Editable -> False, Selectable -> 
                  False]}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"2", ",", 
                 InterpretationBox[
                  ButtonBox[
                   TooltipBox[
                    GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    GrayLevel[0.5], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                    Frame -> True, FrameStyle -> 
                    GrayLevel[0.33333333333333337`], FrameTicks -> None, 
                    ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                    "GrayLevel[0.5]"], Appearance -> None, BaseStyle -> {}, 
                   BaselinePosition -> Baseline, ButtonFunction :> 
                   With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[0.5]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
                   Automatic, Method -> "Preemptive"], 
                  GrayLevel[0.5], Editable -> False, Selectable -> False]}], 
               "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"2", ",", "1"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"2", ",", "2"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"2", ",", "3"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"2", ",", "4"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"2", ",", "5"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"2", ",", "6"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"2", ",", "7"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"2", ",", "8"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"2", ",", 
                 InterpretationBox[
                  ButtonBox[
                   TooltipBox[
                    GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[1, 0.5, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                    Frame -> True, FrameStyle -> 
                    RGBColor[0.6666666666666666, 0.33333333333333337`, 0.], 
                    FrameTicks -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                    "RGBColor[1, 0.5, 0]"], Appearance -> None, 
                   BaseStyle -> {}, BaselinePosition -> Baseline, 
                   ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[1, 0.5, 0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
                   Automatic, Method -> "Preemptive"], 
                  RGBColor[1, 0.5, 0], Editable -> False, Selectable -> 
                  False]}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"3", ",", 
                 InterpretationBox[
                  ButtonBox[
                   TooltipBox[
                    GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    GrayLevel[0.5], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                    Frame -> True, FrameStyle -> 
                    GrayLevel[0.33333333333333337`], FrameTicks -> None, 
                    ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                    "GrayLevel[0.5]"], Appearance -> None, BaseStyle -> {}, 
                   BaselinePosition -> Baseline, ButtonFunction :> 
                   With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[0.5]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
                   Automatic, Method -> "Preemptive"], 
                  GrayLevel[0.5], Editable -> False, Selectable -> False]}], 
               "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"3", ",", "1"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"3", ",", "2"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"3", ",", "3"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"3", ",", "4"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"3", ",", "5"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"3", ",", "6"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"3", ",", "7"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"3", ",", "8"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"3", ",", 
                 InterpretationBox[
                  ButtonBox[
                   TooltipBox[
                    GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[1, 0.5, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                    Frame -> True, FrameStyle -> 
                    RGBColor[0.6666666666666666, 0.33333333333333337`, 0.], 
                    FrameTicks -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                    "RGBColor[1, 0.5, 0]"], Appearance -> None, 
                   BaseStyle -> {}, BaselinePosition -> Baseline, 
                   ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[1, 0.5, 0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
                   Automatic, Method -> "Preemptive"], 
                  RGBColor[1, 0.5, 0], Editable -> False, Selectable -> 
                  False]}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"4", ",", 
                 InterpretationBox[
                  ButtonBox[
                   TooltipBox[
                    GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    GrayLevel[0.5], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                    Frame -> True, FrameStyle -> 
                    GrayLevel[0.33333333333333337`], FrameTicks -> None, 
                    ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                    "GrayLevel[0.5]"], Appearance -> None, BaseStyle -> {}, 
                   BaselinePosition -> Baseline, ButtonFunction :> 
                   With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[0.5]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
                   Automatic, Method -> "Preemptive"], 
                  GrayLevel[0.5], Editable -> False, Selectable -> False]}], 
               "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"4", ",", "1"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"4", ",", "2"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"4", ",", "3"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"4", ",", "4"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"4", ",", "5"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"4", ",", "6"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"4", ",", "7"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"4", ",", "8"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"4", ",", 
                 InterpretationBox[
                  ButtonBox[
                   TooltipBox[
                    GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[1, 0.5, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                    Frame -> True, FrameStyle -> 
                    RGBColor[0.6666666666666666, 0.33333333333333337`, 0.], 
                    FrameTicks -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                    "RGBColor[1, 0.5, 0]"], Appearance -> None, 
                   BaseStyle -> {}, BaselinePosition -> Baseline, 
                   ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[1, 0.5, 0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
                   Automatic, Method -> "Preemptive"], 
                  RGBColor[1, 0.5, 0], Editable -> False, Selectable -> 
                  False]}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"5", ",", 
                 InterpretationBox[
                  ButtonBox[
                   TooltipBox[
                    GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    GrayLevel[0.5], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                    Frame -> True, FrameStyle -> 
                    GrayLevel[0.33333333333333337`], FrameTicks -> None, 
                    ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                    "GrayLevel[0.5]"], Appearance -> None, BaseStyle -> {}, 
                   BaselinePosition -> Baseline, ButtonFunction :> 
                   With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[0.5]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
                   Automatic, Method -> "Preemptive"], 
                  GrayLevel[0.5], Editable -> False, Selectable -> False]}], 
               "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"5", ",", "1"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"5", ",", "2"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"5", ",", "3"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"5", ",", "4"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"5", ",", "5"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"5", ",", "6"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"5", ",", "7"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"5", ",", "8"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"5", ",", 
                 InterpretationBox[
                  ButtonBox[
                   TooltipBox[
                    GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[1, 0.5, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                    Frame -> True, FrameStyle -> 
                    RGBColor[0.6666666666666666, 0.33333333333333337`, 0.], 
                    FrameTicks -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                    "RGBColor[1, 0.5, 0]"], Appearance -> None, 
                   BaseStyle -> {}, BaselinePosition -> Baseline, 
                   ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[1, 0.5, 0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
                   Automatic, Method -> "Preemptive"], 
                  RGBColor[1, 0.5, 0], Editable -> False, Selectable -> 
                  False]}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"6", ",", 
                 InterpretationBox[
                  ButtonBox[
                   TooltipBox[
                    GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    GrayLevel[0.5], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                    Frame -> True, FrameStyle -> 
                    GrayLevel[0.33333333333333337`], FrameTicks -> None, 
                    ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                    "GrayLevel[0.5]"], Appearance -> None, BaseStyle -> {}, 
                   BaselinePosition -> Baseline, ButtonFunction :> 
                   With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[0.5]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
                   Automatic, Method -> "Preemptive"], 
                  GrayLevel[0.5], Editable -> False, Selectable -> False]}], 
               "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"6", ",", "1"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"6", ",", "2"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"6", ",", "3"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"6", ",", "4"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"6", ",", "5"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"6", ",", "6"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"6", ",", "7"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"6", ",", "8"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"6", ",", 
                 InterpretationBox[
                  ButtonBox[
                   TooltipBox[
                    GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[1, 0.5, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                    Frame -> True, FrameStyle -> 
                    RGBColor[0.6666666666666666, 0.33333333333333337`, 0.], 
                    FrameTicks -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                    "RGBColor[1, 0.5, 0]"], Appearance -> None, 
                   BaseStyle -> {}, BaselinePosition -> Baseline, 
                   ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[1, 0.5, 0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
                   Automatic, Method -> "Preemptive"], 
                  RGBColor[1, 0.5, 0], Editable -> False, Selectable -> 
                  False]}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"7", ",", 
                 InterpretationBox[
                  ButtonBox[
                   TooltipBox[
                    GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    GrayLevel[0.5], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                    Frame -> True, FrameStyle -> 
                    GrayLevel[0.33333333333333337`], FrameTicks -> None, 
                    ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                    "GrayLevel[0.5]"], Appearance -> None, BaseStyle -> {}, 
                   BaselinePosition -> Baseline, ButtonFunction :> 
                   With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[0.5]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
                   Automatic, Method -> "Preemptive"], 
                  GrayLevel[0.5], Editable -> False, Selectable -> False]}], 
               "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"7", ",", "1"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"7", ",", "2"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"7", ",", "3"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"7", ",", "4"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"7", ",", "5"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"7", ",", "6"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"7", ",", "7"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"7", ",", "8"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"7", ",", 
                 InterpretationBox[
                  ButtonBox[
                   TooltipBox[
                    GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[1, 0.5, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                    Frame -> True, FrameStyle -> 
                    RGBColor[0.6666666666666666, 0.33333333333333337`, 0.], 
                    FrameTicks -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                    "RGBColor[1, 0.5, 0]"], Appearance -> None, 
                   BaseStyle -> {}, BaselinePosition -> Baseline, 
                   ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[1, 0.5, 0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
                   Automatic, Method -> "Preemptive"], 
                  RGBColor[1, 0.5, 0], Editable -> False, Selectable -> 
                  False]}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"8", ",", 
                 InterpretationBox[
                  ButtonBox[
                   TooltipBox[
                    GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    GrayLevel[0.5], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                    Frame -> True, FrameStyle -> 
                    GrayLevel[0.33333333333333337`], FrameTicks -> None, 
                    ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                    "GrayLevel[0.5]"], Appearance -> None, BaseStyle -> {}, 
                   BaselinePosition -> Baseline, ButtonFunction :> 
                   With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[0.5]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
                   Automatic, Method -> "Preemptive"], 
                  GrayLevel[0.5], Editable -> False, Selectable -> False]}], 
               "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"8", ",", "1"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"8", ",", "2"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"8", ",", "3"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"8", ",", "4"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"8", ",", "5"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"8", ",", "6"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"8", ",", "7"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"8", ",", "8"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"8", ",", 
                 InterpretationBox[
                  ButtonBox[
                   TooltipBox[
                    GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[1, 0.5, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                    Frame -> True, FrameStyle -> 
                    RGBColor[0.6666666666666666, 0.33333333333333337`, 0.], 
                    FrameTicks -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                    "RGBColor[1, 0.5, 0]"], Appearance -> None, 
                   BaseStyle -> {}, BaselinePosition -> Baseline, 
                   ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[1, 0.5, 0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
                   Automatic, Method -> "Preemptive"], 
                  RGBColor[1, 0.5, 0], Editable -> False, Selectable -> 
                  False]}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{
                 InterpretationBox[
                  ButtonBox[
                   TooltipBox[
                    GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[1, 0.5, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                    Frame -> True, FrameStyle -> 
                    RGBColor[0.6666666666666666, 0.33333333333333337`, 0.], 
                    FrameTicks -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                    "RGBColor[1, 0.5, 0]"], Appearance -> None, 
                   BaseStyle -> {}, BaselinePosition -> Baseline, 
                   ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[1, 0.5, 0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
                   Automatic, Method -> "Preemptive"], 
                  RGBColor[1, 0.5, 0], Editable -> False, Selectable -> 
                  False], ",", 
                 InterpretationBox[
                  ButtonBox[
                   TooltipBox[
                    GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    GrayLevel[0.5], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                    Frame -> True, FrameStyle -> 
                    GrayLevel[0.33333333333333337`], FrameTicks -> None, 
                    ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                    "GrayLevel[0.5]"], Appearance -> None, BaseStyle -> {}, 
                   BaselinePosition -> Baseline, ButtonFunction :> 
                   With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[0.5]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
                   Automatic, Method -> "Preemptive"], 
                  GrayLevel[0.5], Editable -> False, Selectable -> False]}], 
               "}"}], ",", 
             RowBox[{"{", 
               RowBox[{
                 InterpretationBox[
                  ButtonBox[
                   TooltipBox[
                    GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[1, 0.5, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                    Frame -> True, FrameStyle -> 
                    RGBColor[0.6666666666666666, 0.33333333333333337`, 0.], 
                    FrameTicks -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                    "RGBColor[1, 0.5, 0]"], Appearance -> None, 
                   BaseStyle -> {}, BaselinePosition -> Baseline, 
                   ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[1, 0.5, 0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
                   Automatic, Method -> "Preemptive"], 
                  RGBColor[1, 0.5, 0], Editable -> False, Selectable -> 
                  False], ",", "1"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{
                 InterpretationBox[
                  ButtonBox[
                   TooltipBox[
                    GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[1, 0.5, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                    Frame -> True, FrameStyle -> 
                    RGBColor[0.6666666666666666, 0.33333333333333337`, 0.], 
                    FrameTicks -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                    "RGBColor[1, 0.5, 0]"], Appearance -> None, 
                   BaseStyle -> {}, BaselinePosition -> Baseline, 
                   ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[1, 0.5, 0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
                   Automatic, Method -> "Preemptive"], 
                  RGBColor[1, 0.5, 0], Editable -> False, Selectable -> 
                  False], ",", "2"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{
                 InterpretationBox[
                  ButtonBox[
                   TooltipBox[
                    GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[1, 0.5, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                    Frame -> True, FrameStyle -> 
                    RGBColor[0.6666666666666666, 0.33333333333333337`, 0.], 
                    FrameTicks -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                    "RGBColor[1, 0.5, 0]"], Appearance -> None, 
                   BaseStyle -> {}, BaselinePosition -> Baseline, 
                   ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[1, 0.5, 0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
                   Automatic, Method -> "Preemptive"], 
                  RGBColor[1, 0.5, 0], Editable -> False, Selectable -> 
                  False], ",", "3"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{
                 InterpretationBox[
                  ButtonBox[
                   TooltipBox[
                    GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[1, 0.5, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                    Frame -> True, FrameStyle -> 
                    RGBColor[0.6666666666666666, 0.33333333333333337`, 0.], 
                    FrameTicks -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                    "RGBColor[1, 0.5, 0]"], Appearance -> None, 
                   BaseStyle -> {}, BaselinePosition -> Baseline, 
                   ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[1, 0.5, 0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
                   Automatic, Method -> "Preemptive"], 
                  RGBColor[1, 0.5, 0], Editable -> False, Selectable -> 
                  False], ",", "4"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{
                 InterpretationBox[
                  ButtonBox[
                   TooltipBox[
                    GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[1, 0.5, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                    Frame -> True, FrameStyle -> 
                    RGBColor[0.6666666666666666, 0.33333333333333337`, 0.], 
                    FrameTicks -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                    "RGBColor[1, 0.5, 0]"], Appearance -> None, 
                   BaseStyle -> {}, BaselinePosition -> Baseline, 
                   ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[1, 0.5, 0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
                   Automatic, Method -> "Preemptive"], 
                  RGBColor[1, 0.5, 0], Editable -> False, Selectable -> 
                  False], ",", "5"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{
                 InterpretationBox[
                  ButtonBox[
                   TooltipBox[
                    GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[1, 0.5, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                    Frame -> True, FrameStyle -> 
                    RGBColor[0.6666666666666666, 0.33333333333333337`, 0.], 
                    FrameTicks -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                    "RGBColor[1, 0.5, 0]"], Appearance -> None, 
                   BaseStyle -> {}, BaselinePosition -> Baseline, 
                   ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[1, 0.5, 0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
                   Automatic, Method -> "Preemptive"], 
                  RGBColor[1, 0.5, 0], Editable -> False, Selectable -> 
                  False], ",", "6"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{
                 InterpretationBox[
                  ButtonBox[
                   TooltipBox[
                    GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[1, 0.5, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                    Frame -> True, FrameStyle -> 
                    RGBColor[0.6666666666666666, 0.33333333333333337`, 0.], 
                    FrameTicks -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                    "RGBColor[1, 0.5, 0]"], Appearance -> None, 
                   BaseStyle -> {}, BaselinePosition -> Baseline, 
                   ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[1, 0.5, 0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> A\
utomatic, Method -> "Preemptive"], 
                  RGBColor[1, 0.5, 0], Editable -> False, Selectable -> 
                  False], ",", "7"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{
                 InterpretationBox[
                  ButtonBox[
                   TooltipBox[
                    GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[1, 0.5, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                    Frame -> True, FrameStyle -> 
                    RGBColor[0.6666666666666666, 0.33333333333333337`, 0.], 
                    FrameTicks -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                    "RGBColor[1, 0.5, 0]"], Appearance -> None, 
                   BaseStyle -> {}, BaselinePosition -> Baseline, 
                   ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[1, 0.5, 0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
                   Automatic, Method -> "Preemptive"], 
                  RGBColor[1, 0.5, 0], Editable -> False, Selectable -> 
                  False], ",", "8"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{
                 InterpretationBox[
                  ButtonBox[
                   TooltipBox[
                    GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[1, 0.5, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                    Frame -> True, FrameStyle -> 
                    RGBColor[0.6666666666666666, 0.33333333333333337`, 0.], 
                    FrameTicks -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                    "RGBColor[1, 0.5, 0]"], Appearance -> None, 
                   BaseStyle -> {}, BaselinePosition -> Baseline, 
                   ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[1, 0.5, 0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
                   Automatic, Method -> "Preemptive"], 
                  RGBColor[1, 0.5, 0], Editable -> False, Selectable -> 
                  False], ",", 
                 InterpretationBox[
                  ButtonBox[
                   TooltipBox[
                    GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[1, 0.5, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                    Frame -> True, FrameStyle -> 
                    RGBColor[0.6666666666666666, 0.33333333333333337`, 0.], 
                    FrameTicks -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                    "RGBColor[1, 0.5, 0]"], Appearance -> None, 
                   BaseStyle -> {}, BaselinePosition -> Baseline, 
                   ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[1, 0.5, 0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
                   Automatic, Method -> "Preemptive"], 
                  RGBColor[1, 0.5, 0], Editable -> False, Selectable -> 
                  False]}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"1", ",", 
                 InterpretationBox[
                  ButtonBox[
                   TooltipBox[
                    GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    GrayLevel[0.5], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                    Frame -> True, FrameStyle -> 
                    GrayLevel[0.33333333333333337`], FrameTicks -> None, 
                    ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                    "GrayLevel[0.5]"], Appearance -> None, BaseStyle -> {}, 
                   BaselinePosition -> Baseline, ButtonFunction :> 
                   With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[0.5]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
                   Automatic, Method -> "Preemptive"], 
                  GrayLevel[0.5], Editable -> False, Selectable -> False], 
                 ",", 
                 InterpretationBox[
                  ButtonBox[
                   TooltipBox[
                    GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    GrayLevel[0.5], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                    Frame -> True, FrameStyle -> 
                    GrayLevel[0.33333333333333337`], FrameTicks -> None, 
                    ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                    "GrayLevel[0.5]"], Appearance -> None, BaseStyle -> {}, 
                   BaselinePosition -> Baseline, ButtonFunction :> 
                   With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[0.5]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
                   Automatic, Method -> "Preemptive"], 
                  GrayLevel[0.5], Editable -> False, Selectable -> False]}], 
               "}"}]}], "}"}]], "ExerciseOutput", Selectable -> False, 
        Copyable -> False, Editable -> False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"1fee8797-3a9a-425e-9e44-4774cc529273"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Make a list of the digits of 2^1000, replacing all zeros by ",
 ButtonBox["Red",
  BaseStyle->"Link"],
 ".",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "32.5", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"009a5330-da98-4c31-86e4-6489dffe6beb"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       RowBox[{"{", 
        RowBox[{"1", ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[1, 0, 0], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->RGBColor[0.6666666666666666, 0., 0.],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[1, 0, 0]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0, 0]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[1, 0, 0],
          Editable->False,
          Selectable->False], ",", "7", ",", "1", ",", "5", ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[1, 0, 0], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->RGBColor[0.6666666666666666, 0., 0.],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[1, 0, 0]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0, 0]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[1, 0, 0],
          Editable->False,
          Selectable->False], ",", "8", ",", "6", ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[1, 0, 0], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->RGBColor[0.6666666666666666, 0., 0.],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[1, 0, 0]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0, 0]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[1, 0, 0],
          Editable->False,
          Selectable->False], ",", "7", ",", "1", ",", "8", ",", "6", ",", 
         "2", ",", "6", ",", "7", ",", "3", ",", "2", ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[1, 0, 0], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->RGBColor[0.6666666666666666, 0., 0.],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[1, 0, 0]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0, 0]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[1, 0, 0],
          Editable->False,
          Selectable->False], ",", "9", ",", "4", ",", "8", ",", "4", ",", 
         "2", ",", "5", ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[1, 0, 0], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->RGBColor[0.6666666666666666, 0., 0.],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[1, 0, 0]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0, 0]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[1, 0, 0],
          Editable->False,
          Selectable->False], ",", "4", ",", "9", ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[1, 0, 0], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->RGBColor[0.6666666666666666, 0., 0.],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[1, 0, 0]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0, 0]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[1, 0, 0],
          Editable->False,
          Selectable->False], ",", "6", ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[1, 0, 0], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->RGBColor[0.6666666666666666, 0., 0.],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[1, 0, 0]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0, 0]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[1, 0, 0],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[1, 0, 0], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->RGBColor[0.6666666666666666, 0., 0.],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[1, 0, 0]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0, 0]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[1, 0, 0],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[1, 0, 0], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->RGBColor[0.6666666666666666, 0., 0.],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[1, 0, 0]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0, 0]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[1, 0, 0],
          Editable->False,
          Selectable->False], ",", "1", ",", "8", ",", "1", ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[1, 0, 0], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->RGBColor[0.6666666666666666, 0., 0.],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[1, 0, 0]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0, 0]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[1, 0, 0],
          Editable->False,
          Selectable->False], ",", "5", ",", "6", ",", "1", ",", "4", ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[1, 0, 0], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->RGBColor[0.6666666666666666, 0., 0.],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[1, 0, 0]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0, 0]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[1, 0, 0],
          Editable->False,
          Selectable->False], ",", "4", ",", "8", ",", "1", ",", "1", ",", 
         "7", ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[1, 0, 0], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->RGBColor[0.6666666666666666, 0., 0.],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[1, 0, 0]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0, 0]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[1, 0, 0],
          Editable->False,
          Selectable->False], ",", "5", ",", "5", ",", "3", ",", "3", ",", 
         "6", ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[1, 0, 0], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->RGBColor[0.6666666666666666, 0., 0.],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[1, 0, 0]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0, 0]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[1, 0, 0],
          Editable->False,
          Selectable->False], ",", "7", ",", "4", ",", "4", ",", "3", ",", 
         "7", ",", "5", ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[1, 0, 0], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->RGBColor[0.6666666666666666, 0., 0.],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[1, 0, 0]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0, 0]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[1, 0, 0],
          Editable->False,
          Selectable->False], ",", "3", ",", "8", ",", "8", ",", "3", ",", 
         "7", ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[1, 0, 0], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->RGBColor[0.6666666666666666, 0., 0.],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[1, 0, 0]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0, 0]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[1, 0, 0],
          Editable->False,
          Selectable->False], ",", "3", ",", "5", ",", "1", ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[1, 0, 0], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->RGBColor[0.6666666666666666, 0., 0.],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[1, 0, 0]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0, 0]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[1, 0, 0],
          Editable->False,
          Selectable->False], ",", "5", ",", "1", ",", "1", ",", "2", ",", 
         "4", ",", "9", ",", "3", ",", "6", ",", "1", ",", "2", ",", "2", ",",
          "4", ",", "9", ",", "3", ",", "1", ",", "9", ",", "8", ",", "3", 
         ",", "7", ",", "8", ",", "8", ",", "1", ",", "5", ",", "6", ",", "9",
          ",", "5", ",", "8", ",", "5", ",", "8", ",", "1", ",", "2", ",", 
         "7", ",", "5", ",", "9", ",", "4", ",", "6", ",", "7", ",", "2", ",",
          "9", ",", "1", ",", "7", ",", "5", ",", "5", ",", "3", ",", "1", 
         ",", "4", ",", "6", ",", "8", ",", "2", ",", "5", ",", "1", ",", "8",
          ",", "7", ",", "1", ",", "4", ",", "5", ",", "2", ",", "8", ",", 
         "5", ",", "6", ",", "9", ",", "2", ",", "3", ",", "1", ",", "4", ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[1, 0, 0], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->RGBColor[0.6666666666666666, 0., 0.],
             FrameTicks->None,
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[1, 0, 0]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0, 0]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[1, 0, 0],
          Editable->False,
          Selectable->False], ",", "4", ",", "3", ",", "5", ",", "9", ",", 
         "8", ",", "4", ",", "5", ",", "7", ",", "7", ",", "5", ",", "7", ",",
          "4", ",", "6", ",", "9", ",", "8", ",", "5", ",", "7", ",", "4", 
         ",", "8", ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[1, 0, 0], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->RGBColor[0.6666666666666666, 0., 0.],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[1, 0, 0]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0, 0]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[1, 0, 0],
          Editable->False,
          Selectable->False], ",", "3", ",", "9", ",", "3", ",", "4", ",", 
         "5", ",", "6", ",", "7", ",", "7", ",", "7", ",", "4", ",", "8", ",",
          "2", ",", "4", ",", "2", ",", "3", ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[1, 0, 0], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->RGBColor[0.6666666666666666, 0., 0.],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[1, 0, 0]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0, 0]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[1, 0, 0],
          Editable->False,
          Selectable->False], ",", "9", ",", "8", ",", "5", ",", "4", ",", 
         "2", ",", "1", ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[1, 0, 0], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->RGBColor[0.6666666666666666, 0., 0.],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[1, 0, 0]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0, 0]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[1, 0, 0],
          Editable->False,
          Selectable->False], ",", "7", ",", "4", ",", "6", ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[1, 0, 0], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->RGBColor[0.6666666666666666, 0., 0.],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[1, 0, 0]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0, 0]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[1, 0, 0],
          Editable->False,
          Selectable->False], ",", "5", ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[1, 0, 0], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->RGBColor[0.6666666666666666, 0., 0.],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[1, 0, 0]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0, 0]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[1, 0, 0],
          Editable->False,
          Selectable->False], ",", "6", ",", "2", ",", "3", ",", "7", ",", 
         "1", ",", "1", ",", "4", ",", "1", ",", "8", ",", "7", ",", "7", ",",
          "9", ",", "5", ",", "4", ",", "1", ",", "8", ",", "2", ",", "1", 
         ",", "5", ",", "3", ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[1, 0, 0], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->RGBColor[0.6666666666666666, 0., 0.],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[1, 0, 0]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0, 0]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[1, 0, 0],
          Editable->False,
          Selectable->False], ",", "4", ",", "6", ",", "4", ",", "7", ",", 
         "4", ",", "9", ",", "8", ",", "3", ",", "5", ",", "8", ",", "1", ",",
          "9", ",", "4", ",", "1", ",", "2", ",", "6", ",", "7", ",", "3", 
         ",", "9", ",", "8", ",", "7", ",", "6", ",", "7", ",", "5", ",", "5",
          ",", "9", ",", "1", ",", "6", ",", "5", ",", "5", ",", "4", ",", 
         "3", ",", "9", ",", "4", ",", "6", ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[1, 0, 0], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->RGBColor[0.6666666666666666, 0., 0.],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[1, 0, 0]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0, 0]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[1, 0, 0],
          Editable->False,
          Selectable->False], ",", "7", ",", "7", ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[1, 0, 0], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->RGBColor[0.6666666666666666, 0., 0.],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[1, 0, 0]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0, 0]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[1, 0, 0],
          Editable->False,
          Selectable->False], ",", "6", ",", "2", ",", "9", ",", "1", ",", 
         "4", ",", "5", ",", "7", ",", "1", ",", "1", ",", "9", ",", "6", ",",
          "4", ",", "7", ",", "7", ",", "6", ",", "8", ",", "6", ",", "5", 
         ",", "4", ",", "2", ",", "1", ",", "6", ",", "7", ",", "6", ",", "6",
          ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[1, 0, 0], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->RGBColor[0.6666666666666666, 0., 0.],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[1, 0, 0]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0, 0]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[1, 0, 0],
          Editable->False,
          Selectable->False], ",", "4", ",", "2", ",", "9", ",", "8", ",", 
         "3", ",", "1", ",", "6", ",", "5", ",", "2", ",", "6", ",", "2", ",",
          "4", ",", "3", ",", "8", ",", "6", ",", "8", ",", "3", ",", "7", 
         ",", "2", ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[1, 0, 0], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->RGBColor[0.6666666666666666, 0., 0.],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[1, 0, 0]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0, 0]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[1, 0, 0],
          Editable->False,
          Selectable->False], ",", "5", ",", "6", ",", "6", ",", "8", ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[1, 0, 0], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->RGBColor[0.6666666666666666, 0., 0.],
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[1, 0, 0]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0, 0]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[1, 0, 0],
          Editable->False,
          Selectable->False], ",", "6", ",", "9", ",", "3", ",", "7", ",", 
         "6"}], "}"}]], "ExerciseOutput",ExpressionUUID->
       "c8e22e4a-19fb-4898-b279-dfa2ab941586"],
      Apply[TextCell, 
       Cell[
        BoxData[
         RowBox[{"{", 
           RowBox[{"1", ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[1, 0, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 RGBColor[0.6666666666666666, 0., 0.], FrameTicks -> None, 
                 ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[1, 0, 0]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[1, 0, 0]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[1, 0, 0], Editable -> False, Selectable -> False], ",",
              "7", ",", "1", ",", "5", ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[1, 0, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 RGBColor[0.6666666666666666, 0., 0.], FrameTicks -> None, 
                 ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[1, 0, 0]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[1, 0, 0]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[1, 0, 0], Editable -> False, Selectable -> False], ",",
              "8", ",", "6", ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[1, 0, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 RGBColor[0.6666666666666666, 0., 0.], FrameTicks -> None, 
                 ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[1, 0, 0]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[1, 0, 0]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[1, 0, 0], Editable -> False, Selectable -> False], ",",
              "7", ",", "1", ",", "8", ",", "6", ",", "2", ",", "6", ",", "7",
              ",", "3", ",", "2", ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[1, 0, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 RGBColor[0.6666666666666666, 0., 0.], FrameTicks -> None, 
                 ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[1, 0, 0]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[1, 0, 0]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[1, 0, 0], Editable -> False, Selectable -> False], ",",
              "9", ",", "4", ",", "8", ",", "4", ",", "2", ",", "5", ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[1, 0, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 RGBColor[0.6666666666666666, 0., 0.], FrameTicks -> None, 
                 ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[1, 0, 0]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[1, 0, 0]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[1, 0, 0], Editable -> False, Selectable -> False], ",",
              "4", ",", "9", ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[1, 0, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 RGBColor[0.6666666666666666, 0., 0.], FrameTicks -> None, 
                 ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[1, 0, 0]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[1, 0, 0]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[1, 0, 0], Editable -> False, Selectable -> False], ",",
              "6", ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[1, 0, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 RGBColor[0.6666666666666666, 0., 0.], FrameTicks -> None, 
                 ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[1, 0, 0]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[1, 0, 0]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[1, 0, 0], Editable -> False, Selectable -> False], ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[1, 0, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 RGBColor[0.6666666666666666, 0., 0.], FrameTicks -> None, 
                 ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[1, 0, 0]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[1, 0, 0]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[1, 0, 0], Editable -> False, Selectable -> False], ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[1, 0, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 RGBColor[0.6666666666666666, 0., 0.], FrameTicks -> None, 
                 ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[1, 0, 0]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[1, 0, 0]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[1, 0, 0], Editable -> False, Selectable -> False], ",",
              "1", ",", "8", ",", "1", ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[1, 0, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 RGBColor[0.6666666666666666, 0., 0.], FrameTicks -> None, 
                 ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[1, 0, 0]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[1, 0, 0]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[1, 0, 0], Editable -> False, Selectable -> False], ",",
              "5", ",", "6", ",", "1", ",", "4", ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[1, 0, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 RGBColor[0.6666666666666666, 0., 0.], FrameTicks -> None, 
                 ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[1, 0, 0]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[1, 0, 0]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[1, 0, 0], Editable -> False, Selectable -> False], ",",
              "4", ",", "8", ",", "1", ",", "1", ",", "7", ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[1, 0, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 RGBColor[0.6666666666666666, 0., 0.], FrameTicks -> None, 
                 ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[1, 0, 0]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[1, 0, 0]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[1, 0, 0], Editable -> False, Selectable -> False], ",",
              "5", ",", "5", ",", "3", ",", "3", ",", "6", ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[1, 0, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 RGBColor[0.6666666666666666, 0., 0.], FrameTicks -> None, 
                 ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[1, 0, 0]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[1, 0, 0]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[1, 0, 0], Editable -> False, Selectable -> False], ",",
              "7", ",", "4", ",", "4", ",", "3", ",", "7", ",", "5", ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[1, 0, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 RGBColor[0.6666666666666666, 0., 0.], FrameTicks -> None, 
                 ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[1, 0, 0]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[1, 0, 0]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[1, 0, 0], Editable -> False, Selectable -> False], ",",
              "3", ",", "8", ",", "8", ",", "3", ",", "7", ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[1, 0, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 RGBColor[0.6666666666666666, 0., 0.], FrameTicks -> None, 
                 ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[1, 0, 0]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[1, 0, 0]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[1, 0, 0], Editable -> False, Selectable -> False], ",",
              "3", ",", "5", ",", "1", ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[1, 0, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 RGBColor[0.6666666666666666, 0., 0.], FrameTicks -> None, 
                 ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[1, 0, 0]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[1, 0, 0]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[1, 0, 0], Editable -> False, Selectable -> False], ",",
              "5", ",", "1", ",", "1", ",", "2", ",", "4", ",", "9", ",", "3",
              ",", "6", ",", "1", ",", "2", ",", "2", ",", "4", ",", "9", ",",
              "3", ",", "1", ",", "9", ",", "8", ",", "3", ",", "7", ",", "8",
              ",", "8", ",", "1", ",", "5", ",", "6", ",", "9", ",", "5", ",",
              "8", ",", "5", ",", "8", ",", "1", ",", "2", ",", "7", ",", "5",
              ",", "9", ",", "4", ",", "6", ",", "7", ",", "2", ",", "9", ",",
              "1", ",", "7", ",", "5", ",", "5", ",", "3", ",", "1", ",", "4",
              ",", "6", ",", "8", ",", "2", ",", "5", ",", "1", ",", "8", ",",
              "7", ",", "1", ",", "4", ",", "5", ",", "2", ",", "8", ",", "5",
              ",", "6", ",", "9", ",", "2", ",", "3", ",", "1", ",", "4", ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[1, 0, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 RGBColor[0.6666666666666666, 0., 0.], FrameTicks -> None, 
                 ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[1, 0, 0]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[1, 0, 0]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[1, 0, 0], Editable -> False, Selectable -> False], ",",
              "4", ",", "3", ",", "5", ",", "9", ",", "8", ",", "4", ",", "5",
              ",", "7", ",", "7", ",", "5", ",", "7", ",", "4", ",", "6", ",",
              "9", ",", "8", ",", "5", ",", "7", ",", "4", ",", "8", ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[1, 0, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 RGBColor[0.6666666666666666, 0., 0.], FrameTicks -> None, 
                 ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[1, 0, 0]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[1, 0, 0]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[1, 0, 0], Editable -> False, Selectable -> False], ",",
              "3", ",", "9", ",", "3", ",", "4", ",", "5", ",", "6", ",", "7",
              ",", "7", ",", "7", ",", "4", ",", "8", ",", "2", ",", "4", ",",
              "2", ",", "3", ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[1, 0, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 RGBColor[0.6666666666666666, 0., 0.], FrameTicks -> None, 
                 ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[1, 0, 0]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[1, 0, 0]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[1, 0, 0], Editable -> False, Selectable -> False], ",",
              "9", ",", "8", ",", "5", ",", "4", ",", "2", ",", "1", ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[1, 0, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 RGBColor[0.6666666666666666, 0., 0.], FrameTicks -> None, 
                 ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[1, 0, 0]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[1, 0, 0]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[1, 0, 0], Editable -> False, Selectable -> False], ",",
              "7", ",", "4", ",", "6", ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[1, 0, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 RGBColor[0.6666666666666666, 0., 0.], FrameTicks -> None, 
                 ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[1, 0, 0]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[1, 0, 0]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[1, 0, 0], Editable -> False, Selectable -> False], ",",
              "5", ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[1, 0, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 RGBColor[0.6666666666666666, 0., 0.], FrameTicks -> None, 
                 ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[1, 0, 0]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[1, 0, 0]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[1, 0, 0], Editable -> False, Selectable -> False], ",",
              "6", ",", "2", ",", "3", ",", "7", ",", "1", ",", "1", ",", "4",
              ",", "1", ",", "8", ",", "7", ",", "7", ",", "9", ",", "5", ",",
              "4", ",", "1", ",", "8", ",", "2", ",", "1", ",", "5", ",", "3",
              ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[1, 0, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 RGBColor[0.6666666666666666, 0., 0.], FrameTicks -> None, 
                 ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[1, 0, 0]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[1, 0, 0]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[1, 0, 0], Editable -> False, Selectable -> False], ",",
              "4", ",", "6", ",", "4", ",", "7", ",", "4", ",", "9", ",", "8",
              ",", "3", ",", "5", ",", "8", ",", "1", ",", "9", ",", "4", ",",
              "1", ",", "2", ",", "6", ",", "7", ",", "3", ",", "9", ",", "8",
              ",", "7", ",", "6", ",", "7", ",", "5", ",", "5", ",", "9", ",",
              "1", ",", "6", ",", "5", ",", "5", ",", "4", ",", "3", ",", "9",
              ",", "4", ",", "6", ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[1, 0, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 RGBColor[0.6666666666666666, 0., 0.], FrameTicks -> None, 
                 ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[1, 0, 0]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[1, 0, 0]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[1, 0, 0], Editable -> False, Selectable -> False], ",",
              "7", ",", "7", ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[1, 0, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 RGBColor[0.6666666666666666, 0., 0.], FrameTicks -> None, 
                 ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[1, 0, 0]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[1, 0, 0]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[1, 0, 0], Editable -> False, Selectable -> False], ",",
              "6", ",", "2", ",", "9", ",", "1", ",", "4", ",", "5", ",", "7",
              ",", "1", ",", "1", ",", "9", ",", "6", ",", "4", ",", "7", ",",
              "7", ",", "6", ",", "8", ",", "6", ",", "5", ",", "4", ",", "2",
              ",", "1", ",", "6", ",", "7", ",", "6", ",", "6", ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[1, 0, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 RGBColor[0.6666666666666666, 0., 0.], FrameTicks -> None, 
                 ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[1, 0, 0]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[1, 0, 0]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[1, 0, 0], Editable -> False, Selectable -> False], ",",
              "4", ",", "2", ",", "9", ",", "8", ",", "3", ",", "1", ",", "6",
              ",", "5", ",", "2", ",", "6", ",", "2", ",", "4", ",", "3", ",",
              "8", ",", "6", ",", "8", ",", "3", ",", "7", ",", "2", ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[1, 0, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 RGBColor[0.6666666666666666, 0., 0.], FrameTicks -> None, 
                 ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[1, 0, 0]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[1, 0, 0]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[1, 0, 0], Editable -> False, Selectable -> False], ",",
              "5", ",", "6", ",", "6", ",", "8", ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[1, 0, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 RGBColor[0.6666666666666666, 0., 0.], FrameTicks -> None, 
                 ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[1, 0, 0]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = 
                   RGBColor[1, 0, 0]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[1, 0, 0], Editable -> False, Selectable -> False], ",",
              "6", ",", "9", ",", "3", ",", "7", ",", "6"}], "}"}]], 
        "ExerciseOutput", Selectable -> False, Copyable -> False, Editable -> 
        False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"dd8e7d72-aab7-4283-820f-f52588518b7f"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Remove the vowels a, e, i, o and u from the list of characters in \
\[OpenCurlyDoubleQuote]The Wolfram Language\[CloseCurlyDoubleQuote].",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "32.6", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"b9f8b097-451b-4729-901f-4913b18c6b99"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       RowBox[{"{", 
        RowBox[{"\<\"T\"\>", ",", "\<\"h\"\>", ",", "\<\" \"\>", 
         ",", "\<\"W\"\>", ",", "\<\"l\"\>", ",", "\<\"f\"\>", 
         ",", "\<\"r\"\>", ",", "\<\"m\"\>", ",", "\<\" \"\>", 
         ",", "\<\"L\"\>", ",", "\<\"n\"\>", ",", "\<\"g\"\>", 
         ",", "\<\"g\"\>"}], "}"}]], "ExerciseOutput",ExpressionUUID->
       "9b692245-350d-4f30-989d-dfb6193da07f"],
      Apply[TextCell, 
       Cell[
        BoxData[
         RowBox[{"{", 
           
           RowBox[{"\"T\"", ",", "\"h\"", ",", "\" \"", ",", "\"W\"", ",", 
             "\"l\"", ",", "\"f\"", ",", "\"r\"", ",", "\"m\"", ",", "\" \"", 
             ",", "\"L\"", ",", "\"n\"", ",", "\"g\"", ",", "\"g\""}], "}"}]],
         "ExerciseOutput", Selectable -> False, Copyable -> False, Editable -> 
        False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"050eb235-4a18-4225-96d9-cd393e1005cd"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Find a simpler form for ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Select",
    BaseStyle->"CodeLink"], "[", 
   RowBox[{
    RowBox[{
     ButtonBox["IntegerDigits",
      BaseStyle->"CodeLink"], "[", 
     RowBox[{"2", 
      ButtonBox["^",
       BaseStyle->"Link",
       ButtonData->"Power"], "1000"}], "]"}], ",", 
    RowBox[{
     RowBox[{
      ButtonBox["#",
       BaseStyle->"Link",
       ButtonData->"Slot"], 
      ButtonBox["\[Equal]",
       BaseStyle->"CodeLink"], "0"}], "||", 
     RowBox[{
      ButtonBox["#",
       BaseStyle->"Link",
       ButtonData->"Slot"], 
      ButtonBox["\[Equal]",
       BaseStyle->"CodeLink"], "1", 
      ButtonBox["&",
       BaseStyle->"Link",
       ButtonData->"Function"]}]}]}], "]"}]], "InlineCode",ExpressionUUID->
  "5187428a-a4b2-436c-a77b-b0ce12a05cc5"],
 ".",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "32.7", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"53478c6e-e20c-4627-b462-c65820796e5d"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       RowBox[{"{", 
        RowBox[{
        "1", ",", "0", ",", "1", ",", "0", ",", "0", ",", "1", ",", "0", ",", 
         "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "1", ",", "1", ",",
          "0", ",", "1", ",", "0", ",", "1", ",", "1", ",", "0", ",", "0", 
         ",", "0", ",", "0", ",", "1", ",", "0", ",", "1", ",", "1", ",", "1",
          ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", 
         "1", ",", "1", ",", "0", ",", "0", ",", "0", ",", "1", ",", "0", ",",
          "0", ",", "0", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", 
         ",", "0", ",", "1", ",", "1", ",", "1", ",", "0", ",", "0", ",", "1",
          ",", "1", ",", "1", ",", "1", ",", "0", ",", "1", ",", "0", ",", 
         "0"}], "}"}]], "ExerciseOutput",ExpressionUUID->
       "f324ecbe-f0a1-43c1-a496-92f8120405c2"],
      Apply[TextCell, 
       Cell[
        BoxData[
         RowBox[{"{", 
           
           RowBox[{"1", ",", "0", ",", "1", ",", "0", ",", "0", ",", "1", ",",
              "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "1",
              ",", "1", ",", "0", ",", "1", ",", "0", ",", "1", ",", "1", ",",
              "0", ",", "0", ",", "0", ",", "0", ",", "1", ",", "0", ",", "1",
              ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",",
              "1", ",", "1", ",", "1", ",", "1", ",", "0", ",", "0", ",", "0",
              ",", "1", ",", "0", ",", "0", ",", "0", ",", "1", ",", "1", ",",
              "1", ",", "1", ",", "1", ",", "0", ",", "1", ",", "1", ",", "1",
              ",", "0", ",", "0", ",", "1", ",", "1", ",", "1", ",", "1", ",",
              "0", ",", "1", ",", "0", ",", "0"}], "}"}]], "ExerciseOutput", 
        Selectable -> False, Copyable -> False, Editable -> False, 
        ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"26813c18-c521-45a4-aafc-c98b07cecc04"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Find a simpler form for ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Select",
    BaseStyle->"CodeLink"], "[", 
   RowBox[{
    RowBox[{
     ButtonBox["IntegerDigits",
      BaseStyle->"CodeLink"], "[", 
     RowBox[{
      ButtonBox["Range",
       BaseStyle->"CodeLink"], "[", 
      RowBox[{"100", ",", "999"}], "]"}], "]"}], ",", 
    RowBox[{
     RowBox[{
      ButtonBox["First",
       BaseStyle->"CodeLink"], "[", 
      ButtonBox["#",
       BaseStyle->"Link",
       ButtonData->"Slot"], "]"}], 
     ButtonBox["\[Equal]",
      BaseStyle->"CodeLink"], 
     RowBox[{
      ButtonBox["Last",
       BaseStyle->"CodeLink"], "[", 
      ButtonBox["#",
       BaseStyle->"Link",
       ButtonData->"Slot"], "]"}], 
     ButtonBox["&",
      BaseStyle->"Link",
      ButtonData->"Function"]}]}], "]"}]], "InlineCode",ExpressionUUID->
  "90402482-fcb0-45f4-894b-330d5bf4711e"],
 ".",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "32.8", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"10beeb24-1f43-439a-815f-26f04ce4f37f"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", "0", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "1", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "2", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "3", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "4", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "5", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "6", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "7", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "8", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "9", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", "0", ",", "2"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", "1", ",", "2"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", "2", ",", "2"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", "3", ",", "2"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", "4", ",", "2"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", "5", ",", "2"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", "6", ",", "2"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", "7", ",", "2"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", "8", ",", "2"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", "9", ",", "2"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"3", ",", "0", ",", "3"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"3", ",", "1", ",", "3"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"3", ",", "2", ",", "3"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"3", ",", "3", ",", "3"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"3", ",", "4", ",", "3"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"3", ",", "5", ",", "3"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"3", ",", "6", ",", "3"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"3", ",", "7", ",", "3"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"3", ",", "8", ",", "3"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"3", ",", "9", ",", "3"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"4", ",", "0", ",", "4"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"4", ",", "1", ",", "4"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"4", ",", "2", ",", "4"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"4", ",", "3", ",", "4"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"4", ",", "4", ",", "4"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"4", ",", "5", ",", "4"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"4", ",", "6", ",", "4"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"4", ",", "7", ",", "4"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"4", ",", "8", ",", "4"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"4", ",", "9", ",", "4"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"5", ",", "0", ",", "5"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"5", ",", "1", ",", "5"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"5", ",", "2", ",", "5"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"5", ",", "3", ",", "5"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"5", ",", "4", ",", "5"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"5", ",", "5", ",", "5"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"5", ",", "6", ",", "5"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"5", ",", "7", ",", "5"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"5", ",", "8", ",", "5"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"5", ",", "9", ",", "5"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"6", ",", "0", ",", "6"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"6", ",", "1", ",", "6"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"6", ",", "2", ",", "6"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"6", ",", "3", ",", "6"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"6", ",", "4", ",", "6"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"6", ",", "5", ",", "6"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"6", ",", "6", ",", "6"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"6", ",", "7", ",", "6"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"6", ",", "8", ",", "6"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"6", ",", "9", ",", "6"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"7", ",", "0", ",", "7"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"7", ",", "1", ",", "7"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"7", ",", "2", ",", "7"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"7", ",", "3", ",", "7"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"7", ",", "4", ",", "7"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"7", ",", "5", ",", "7"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"7", ",", "6", ",", "7"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"7", ",", "7", ",", "7"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"7", ",", "8", ",", "7"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"7", ",", "9", ",", "7"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"8", ",", "0", ",", "8"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"8", ",", "1", ",", "8"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"8", ",", "2", ",", "8"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"8", ",", "3", ",", "8"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"8", ",", "4", ",", "8"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"8", ",", "5", ",", "8"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"8", ",", "6", ",", "8"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"8", ",", "7", ",", "8"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"8", ",", "8", ",", "8"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"8", ",", "9", ",", "8"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"9", ",", "0", ",", "9"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"9", ",", "1", ",", "9"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"9", ",", "2", ",", "9"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"9", ",", "3", ",", "9"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"9", ",", "4", ",", "9"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"9", ",", "5", ",", "9"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"9", ",", "6", ",", "9"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"9", ",", "7", ",", "9"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"9", ",", "8", ",", "9"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"9", ",", "9", ",", "9"}], "}"}]}], "}"}]], 
       "ExerciseOutput",ExpressionUUID->
       "e4cba671-2975-45d4-b90a-7ee0c28fd06c"],
      Apply[TextCell, 
       Cell[
        BoxData[
         RowBox[{"{", 
           RowBox[{
             RowBox[{"{", 
               RowBox[{"1", ",", "0", ",", "1"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"1", ",", "1", ",", "1"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"1", ",", "2", ",", "1"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"1", ",", "3", ",", "1"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"1", ",", "4", ",", "1"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"1", ",", "5", ",", "1"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"1", ",", "6", ",", "1"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"1", ",", "7", ",", "1"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"1", ",", "8", ",", "1"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"1", ",", "9", ",", "1"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"2", ",", "0", ",", "2"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"2", ",", "1", ",", "2"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"2", ",", "2", ",", "2"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"2", ",", "3", ",", "2"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"2", ",", "4", ",", "2"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"2", ",", "5", ",", "2"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"2", ",", "6", ",", "2"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"2", ",", "7", ",", "2"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"2", ",", "8", ",", "2"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"2", ",", "9", ",", "2"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"3", ",", "0", ",", "3"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"3", ",", "1", ",", "3"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"3", ",", "2", ",", "3"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"3", ",", "3", ",", "3"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"3", ",", "4", ",", "3"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"3", ",", "5", ",", "3"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"3", ",", "6", ",", "3"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"3", ",", "7", ",", "3"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"3", ",", "8", ",", "3"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"3", ",", "9", ",", "3"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"4", ",", "0", ",", "4"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"4", ",", "1", ",", "4"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"4", ",", "2", ",", "4"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"4", ",", "3", ",", "4"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"4", ",", "4", ",", "4"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"4", ",", "5", ",", "4"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"4", ",", "6", ",", "4"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"4", ",", "7", ",", "4"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"4", ",", "8", ",", "4"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"4", ",", "9", ",", "4"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"5", ",", "0", ",", "5"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"5", ",", "1", ",", "5"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"5", ",", "2", ",", "5"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"5", ",", "3", ",", "5"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"5", ",", "4", ",", "5"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"5", ",", "5", ",", "5"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"5", ",", "6", ",", "5"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"5", ",", "7", ",", "5"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"5", ",", "8", ",", "5"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"5", ",", "9", ",", "5"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"6", ",", "0", ",", "6"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"6", ",", "1", ",", "6"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"6", ",", "2", ",", "6"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"6", ",", "3", ",", "6"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"6", ",", "4", ",", "6"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"6", ",", "5", ",", "6"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"6", ",", "6", ",", "6"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"6", ",", "7", ",", "6"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"6", ",", "8", ",", "6"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"6", ",", "9", ",", "6"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"7", ",", "0", ",", "7"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"7", ",", "1", ",", "7"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"7", ",", "2", ",", "7"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"7", ",", "3", ",", "7"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"7", ",", "4", ",", "7"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"7", ",", "5", ",", "7"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"7", ",", "6", ",", "7"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"7", ",", "7", ",", "7"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"7", ",", "8", ",", "7"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"7", ",", "9", ",", "7"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"8", ",", "0", ",", "8"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"8", ",", "1", ",", "8"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"8", ",", "2", ",", "8"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"8", ",", "3", ",", "8"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"8", ",", "4", ",", "8"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"8", ",", "5", ",", "8"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"8", ",", "6", ",", "8"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"8", ",", "7", ",", "8"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"8", ",", "8", ",", "8"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"8", ",", "9", ",", "8"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"9", ",", "0", ",", "9"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"9", ",", "1", ",", "9"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"9", ",", "2", ",", "9"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"9", ",", "3", ",", "9"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"9", ",", "4", ",", "9"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"9", ",", "5", ",", "9"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"9", ",", "6", ",", "9"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"9", ",", "7", ",", "9"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"9", ",", "8", ",", "9"}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{"9", ",", "9", ",", "9"}], "}"}]}], "}"}]], 
        "ExerciseOutput", Selectable -> False, Copyable -> False, Editable -> 
        False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"bb90b2ff-b1e3-477f-8bc5-dc3af8132727"]
}, Closed]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Q&A", "QASection",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"64c3c492-400a-4260-8122-54238838225b"],

Cell[TextData[{
 "Do the names of pattern variables (",
 Cell[BoxData[
  RowBox[{"x", 
   ButtonBox["_",
    BaseStyle->"Link",
    ButtonData->"Blank"]}]], "InlineCode",ExpressionUUID->
  "a01f76b3-150f-4ee1-84f9-f84e19e76db8"],
 ", etc.) matter?"
}], "Question",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"5e8dc654-ff1c-4288-8563-83b3f05f5b15"],

Cell["\<\
No. They just have to be consistent inside a given pattern. Different \
patterns can reuse the same name for different purposes, and the name can \
also appear outside the pattern.\
\>", "Answer",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"9b346ba6-79a5-47ac-bea4-d080e5e16530"],

Cell["What else can be used to define patterns?", "Question",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"658bb29d-bd03-47b5-8467-f398ec492a5b"],

Cell[TextData[{
 "We\[CloseCurlyQuote]ll discuss several more things in ",
 ButtonBox["Section 41",
  BaseStyle->"Hyperlink",
  ButtonData->{"EIWL2-41-more-about-patterns.nb", None}],
 "."
}], "Answer",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"5e1ce6fc-de16-41de-9249-aea055576728"],

Cell[TextData[{
 "What\[CloseCurlyQuote]s the difference between ",
 Cell[BoxData[
  ButtonBox["|",
   BaseStyle->"Link",
   ButtonData->"Alternatives"]], "InlineCode",ExpressionUUID->
  "8e70d015-bd03-46b2-817d-47b261468b23"],
 " and ",
 Cell[BoxData[
  ButtonBox["||",
   BaseStyle->"Link",
   ButtonData->"Or"]], "InlineCode",ExpressionUUID->
  "ee5516f5-b205-49e6-b3c4-310dbe444ec2"],
 "?"
}], "Question",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"ccac8f22-807f-4860-8b35-4a1b49400ed8"],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"p", 
   ButtonBox["|",
    BaseStyle->"Link",
    ButtonData->"Alternatives"], "q"}]], "InlineCode",ExpressionUUID->
  "fecaf144-0bbd-48b8-87b6-4284911b6634"],
 " is a pattern construct, that matches either ",
 Cell[BoxData[
 "p"], "InlineCode",ExpressionUUID->"fe658fd2-0c46-44e9-91ff-3a18c2100284"],
 " or ",
 Cell[BoxData[
 "q"], "InlineCode",ExpressionUUID->"dcb247c1-5e51-4325-80f7-9f5874576639"],
 ". ",
 Cell[BoxData[
  RowBox[{"p", 
   ButtonBox["||",
    BaseStyle->"Link",
    ButtonData->"Or"], "q"}]], "InlineCode",ExpressionUUID->
  "8825fe51-1d4c-48e4-95ae-9327a2676970"],
 " is a logic construct, that tests whether ",
 Cell[BoxData[
 "p"], "InlineCode",ExpressionUUID->"3e31517d-7eb5-4972-8122-9560e4c934b1"],
 " or ",
 Cell[BoxData[
 "q"], "InlineCode",ExpressionUUID->"19395a53-2e3f-4d0a-a836-c1372078d23a"],
 " is ",
 ButtonBox["True",
  BaseStyle->"Link"],
 "."
}], "Answer",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"36e7040e-aa69-4dfe-bee6-a58c406dc99f"],

Cell[TextData[{
 "How does one say a",
 ButtonBox["|",
  BaseStyle->"Link",
  ButtonData->"Alternatives"],
 "b?"
}], "Question",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:10",ExpressionUUID->"92530b27-0f9f-4c4b-8643-4cb09a6067b3"],

Cell["Either \[OpenCurlyDoubleQuote]a or b\[CloseCurlyDoubleQuote] or \
\[OpenCurlyDoubleQuote]a vertical bar b\[CloseCurlyDoubleQuote].", "Answer",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->
  "LastCellOfAPage",ExpressionUUID->"0551bd74-1576-4501-a5a9-7c99aec00184"],

Cell[TextData[{
 "How is ",
 Cell[BoxData[
  ButtonBox["/.",
   BaseStyle->"Link",
   ButtonData->"ReplaceAll"]], "InlineCode",ExpressionUUID->
  "69f3c40f-a57e-4498-9023-40ef608d65cb"],
 " interpreted?"
}], "Question",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"d6310627-0627-4b03-ae11-fa316a62fa36"],

Cell[TextData[{
 "It\[CloseCurlyQuote]s the function ",
 ButtonBox["ReplaceAll",
  BaseStyle->"Link"],
 ". ",
 ButtonBox["Replace",
  BaseStyle->"Link"],
 " tries to replace a whole expression. ",
 ButtonBox["ReplaceList",
  BaseStyle->"Link"],
 " gives a list of results from all possible ways to match a particular \
pattern."
}], "Answer",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:11",ExpressionUUID->"eeb23720-a325-4862-a2b0-8f9f309add1f"],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  ButtonBox["/.",
   BaseStyle->"Link",
   ButtonData->"ReplaceAll"]], "InlineCode",ExpressionUUID->
  "64885ac2-b7ca-47cc-9aaa-707bbf312165"],
 " has several replacements, which one will it use?"
}], "Question",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"020f4881-cdc1-4615-81ea-c44d6baa37e6"],

Cell[TextData[{
 "It uses the first one that applies. If replacements apply to multiple \
levels of an expression, ",
 Cell[BoxData[
  ButtonBox["/.",
   BaseStyle->"Link",
   ButtonData->"ReplaceAll"]], "InlineCode",ExpressionUUID->
  "e01545b2-cecf-4d1c-ae2b-6af3870ea68c"],
 " will use it on the outermost level."
}], "Answer",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"79e181af-ec8c-4beb-a21b-15869e85e9ef"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Tech Notes", "TechNoteSection",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"p:196",ExpressionUUID->"f2215435-539b-4806-9ace-b1948bc5990c"],

Cell[TextData[{
 "Patterns for strings are discussed in ",
 ButtonBox["Section 42",
  BaseStyle->"Hyperlink",
  ButtonData->{"EIWL2-42-string-patterns-and-templates.nb", None}],
 "."
}], "TechNote",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"8bfa4783-6c2c-4e0f-abfe-d63185096d56"],

Cell[TextData[{
 "Pattern matching in the Wolfram Language takes account of facts such as the \
equivalence of ",
 Cell[BoxData[
  RowBox[{"x", 
   ButtonBox["+",
    BaseStyle->"Link",
    ButtonData->"Plus"], "y"}]], "InlineCode",ExpressionUUID->
  "03155b23-5bfa-4bee-bcad-5f325f63d5da"],
 " and ",
 Cell[BoxData[
  RowBox[{"y", 
   ButtonBox["+",
    BaseStyle->"Link",
    ButtonData->"Plus"], "x"}]], "InlineCode",ExpressionUUID->
  "e9e3e030-5d95-4d28-8f50-434d84b41687"],
 ", or ",
 Cell[BoxData[
  RowBox[{"x", 
   ButtonBox["+",
    BaseStyle->"Link",
    ButtonData->"Plus"], 
   RowBox[{"(", 
    RowBox[{"y", 
     ButtonBox["+",
      BaseStyle->"Link",
      ButtonData->"Plus"], "z"}], ")"}]}]], "InlineCode",ExpressionUUID->
  "e31c5986-9df8-40f9-9e42-93eca1d65b3c"],
 " and ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"(", 
    RowBox[{"x", 
     ButtonBox["+",
      BaseStyle->"Link",
      ButtonData->"Plus"], "y"}], ")"}], 
   ButtonBox["+",
    BaseStyle->"Link",
    ButtonData->"Plus"], "z"}]], "InlineCode",ExpressionUUID->
  "1238bb25-9ba8-497a-bb49-f52addb72653"],
 ". See ",
 ButtonBox["Section 41",
  BaseStyle->"Hyperlink",
  ButtonData->{"EIWL2-41-more-about-patterns.nb", "Orderless"}],
 "."
}], "TechNote",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"bd86ea68-de22-4e2e-96be-86c0670c1c36"],

Cell[TextData[{
 "In writing ",
 Cell[BoxData[
  RowBox[{
   StyleBox["lhs", "CodeVariable"], 
   ButtonBox["\[Rule]",
    BaseStyle->"Link",
    ButtonData->"Rule"], 
   StyleBox["rhs", "CodeVariable"]}]], "InlineCode",ExpressionUUID->
  "845c726e-a34f-47ef-aae7-51816988b5c9"],
 ", the ",
 Cell[BoxData[
  StyleBox["lhs", "CodeVariable"]], "InlineCode",ExpressionUUID->
  "e7d9db51-f6d4-4dcb-8cc2-659e3e68a911"],
 " stands for \[OpenCurlyDoubleQuote]left-hand side\[CloseCurlyDoubleQuote] \
and the ",
 Cell[BoxData[
  StyleBox["rhs", "CodeVariable"]], "InlineCode",ExpressionUUID->
  "93bf53ad-9bde-49e7-bc69-daf244ebd37c"],
 " for \[OpenCurlyDoubleQuote]right-hand side\[CloseCurlyDoubleQuote]."
}], "TechNote",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:12",ExpressionUUID->"3ead5acb-d079-4400-a9c5-08d883e59c25"],

Cell[TextData[{
 "Patterns are ",
 StyleBox["scoping constructs",
  FontSlant->"Italic"],
 ", in the sense that they localize names like the ",
 Cell[BoxData[
 "x"], "InlineCode",ExpressionUUID->"0afd5070-d4d0-4d3d-8a66-960942a44088"],
 " in ",
 Cell[BoxData[
 "x_"], "InlineCode",ExpressionUUID->"609074ca-e7c0-4885-b628-8c1d8c645959"],
 " to just the scope of the pattern."
}], "TechNote",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:13",ExpressionUUID->"58d203a8-0b27-440d-a282-66add19b92a5"],

Cell[TextData[{
 "In the rare case that ",
 Cell[BoxData[
  ButtonBox["/.",
   BaseStyle->"Link",
   ButtonData->"ReplaceAll"]], "InlineCode",ExpressionUUID->
  "b968e392-9d5f-4e51-938e-80edc7d1016e"],
 " is followed by a digit (like ",
 Cell[BoxData[
 "0"], "InlineCode",ExpressionUUID->"ad51384b-153d-4f4a-b8c9-06ede66c2f45"],
 "), you need to leave a space before the digit to avoid confusion with \
division."
}], "TechNote",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"e0b4ba8b-9e0e-42f0-94b1-ed8d987cae0d"]
}, Open  ]],

Cell[CellGroupData[{

Cell["More to Explore", "MoreExploreSection",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"34a7b5a9-35b3-4522-a697-fdc2e44b5afd"],

Cell[TextData[ButtonBox["Guide to Patterns in the Wolfram Language\
\[NonBreakingSpace]\[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Patterns"]], "MoreExplore",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->
  "LastCellOfAPage",ExpressionUUID->"28a35a43-6ea2-40af-bae6-498375d75684"]
}, Open  ]]
},
Saveable->False,
WindowToolbars->{},
BlinkingCellInsertionPoint->False,
CellInsertionPointCell->None,
WindowSize->{830, 800},
WindowMargins->Automatic,
WindowPersistentStyles->{
 WindowFrame, WindowMargins, WindowSize, Magnification},
WindowTitle->"Patterns: Elementary Introduction to the Wolfram Language",
DockedCells->{
  Cell[
   BoxData[
    TagBox[
     GridBox[{{
        TemplateBox[{
         "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]", 
          "\"\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\"", 
          GraphicsBox[
           TagBox[
            RasterBox[CompressedData["
1:eJztl01IVFEUxyctMFzUysjIyUDCTauiIJFM6ENpM4NEtJrBUaSYZMYPhCRm
rYuoICgiW0VEBVIUEbTNEMTAIqRsk6JGCVFBHx7//+4JLo/36DqvB4Ie+Mk7
7+t3733nHpzq9NlEW0ksFsuX4U8i1duQy6X6kpuRtGTzHe3ZTOuxbFemPZPb
ny7FyZ2gEqwHInICfJToguOIReywPVHHlYDzcY4hJHZ486giyBOXtfms5Pms
Bs9zUBDTow6DJOgBT8DP/+B5CepAPbgqZm+zT70Bt9VXCx6H8DwE28Gw5ufB
IT2eA1N6PKquC0V4xtUxqfkE6ARD4BHYAx5Y938Gu8GdZXq4VsNWngIfwDzY
Aa6Bm55nOKYq8NXRw29eb+Uz4JSVd4Nn4IbPs2fARUdPQcfLWAQJ8Mq6Tkdd
gGcEHHT0sHYn9Jg1dcnnnhf6vnee8xzXVkcP9wdr97eY7z0NnlrX74qpxffg
iOZ2VDp6kvqOe6AVXAb7xNQB462YNfsCfoBzoE1MzTEqHD096mgE98WsEec4
Jqamvvk8cx2kwWuw19HDXnIAbNAx03ka9IO8mO+3ScyebRZTi01i1rqguHjY
r3aJWaugOA5O6vEC+K6ebWDW0cNgv6oBnwKus87KwKDmv8BRMOBz77/6G/sV
e8lkwHWuTwm4pQ7WzGIRHgb7FXsJ9/mI5z2si42gXMw8/ByuHgb7FXsJ9yX3
IPfHFjF1xTl5v0exnrCx5gnn+fu7JC7h/z/0Y52+P+rfWX9iCXVYErg=
             "], {{0,
              34}, {26, 0}}, {0, 255}, ColorFunction -> RGBColor], 
            BoxForm`ImageTag[
            "Byte", ColorSpace -> "RGB", Interleaving -> True, Magnification -> 
             1], Selectable -> False], DefaultBaseStyle -> "ImageGraphics", 
           ImageSize -> Magnification[1], ImageSizeRaw -> {26, 34}, 
           PlotRange -> {{0, 26}, {0, 34}}], 
          GraphicsBox[
           TagBox[
            RasterBox[CompressedData["
1:eJztXUuS47gRLX8WXtYRaJ+gl17SS+8U4/CeM+H2hDdtRY8jHF6ZR9AReATt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             "], {{0, 34}, {383, 0}}, {0, 255}, 
             ColorFunction -> RGBColor], 
            BoxForm`ImageTag[
            "Byte", ColorSpace -> "RGB", Interleaving -> True, Magnification -> 
             1], Selectable -> False], DefaultBaseStyle -> "ImageGraphics", 
           ImageSize -> Magnification[1], ImageSizeRaw -> {383, 34}, 
           PlotRange -> {{0, 383}, {0, 34}}]}, "RowWithSeparators"], 
        PaneBox[
         StyleBox["\[VeryThinSpace]", ShowStringCharacters -> False], 
         Alignment -> Right, ImageSize -> {174, 47}], 
        PaneBox[
         PaneBox[
          TemplateBox[{"\[ThinSpace]", "\" \"", 
            TagBox[
             TooltipBox[
              PaneSelectorBox[{False -> ButtonBox[
                  PaneBox[
                   GraphicsBox[
                    TagBox[
                    RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UJAPiDmBmIUBO/j//z8jEDcA8W8g3oBFnhmIZ/9HgE9o8mxAvBZJ/hsQuyPJ
8wPxfiT5N0BsjiQvCsTnkOSfALEWkrwSEN9Bkr8OxDJobniAJP8ZZCYWfxCj
RpGQXcS4mVi/ExuGxMYFmlp4nAIAG14fWQ==
                    "], {{0, 14}, {9, 
                    0}}, {0, 255}, ColorFunction -> RGBColor], 
                    BoxForm`ImageTag[
                    "Byte", ColorSpace -> "RGB", Interleaving -> True], 
                    Selectable -> False], DefaultBaseStyle -> "ImageGraphics",
                     ImageSizeRaw -> {9, 14}, PlotRange -> {{0, 9}, {0, 14}}, 
                    ImageSize -> Magnification[1]], ImageSize -> {35, 30}, 
                   Alignment -> Center], 
                  ButtonFunction :> (
                   NotebookLocate[{"EIWL2-31-parts-of-lists.nb", ""}, 
                    FrontEnd`HistoryData :> {
                    EvaluationNotebook[]}]& ), Enabled -> True, Appearance -> 
                  None, Evaluator -> Automatic, Method -> "Preemptive"], True -> 
                ButtonBox[
                  PaneBox[
                   GraphicsBox[
                    TagBox[
                    RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UJAPiDmBmIUBO/j//z8jEDcA8W8g3oBFnhmIZ/9HgE9o8mxAvBZJ/hsQuyPJ
8wPxfiT5N0BsjiQvCsTnkOSfALEWkrwSEN9Bkr8OxDJobniAJP8ZZCYWfxCj
RpGQXcS4mVi/ExuGxMYFmlp4nAIAG14fWQ==
                    "], {{0, 14}, {9, 
                    0}}, {0, 255}, ColorFunction -> RGBColor], 
                    BoxForm`ImageTag[
                    "Byte", ColorSpace -> "RGB", Interleaving -> True], 
                    Selectable -> False], DefaultBaseStyle -> "ImageGraphics",
                     ImageSizeRaw -> {9, 14}, PlotRange -> {{0, 9}, {0, 14}}, 
                    ImageSize -> Magnification[1]], ImageSize -> {35, 30}, 
                   Alignment -> Center], 
                  ButtonFunction :> (
                   NotebookLocate[{"EIWL2-31-parts-of-lists.nb", ""}, 
                    FrontEnd`HistoryData :> {
                    EvaluationNotebook[]}]& ), Enabled -> True, Appearance -> 
                  None, Background -> RGBColor[0.835294, 0.364706, 0.0196078],
                   Evaluator -> Automatic, Method -> "Preemptive"]}, 
               Dynamic[
                CurrentValue["MouseOver"]], ImageSize -> Automatic, 
               FrameMargins -> 0], "\"Parts of Lists\"", TooltipDelay -> 0.15,
               LabelStyle -> "TextStyling"], 
             Annotation[#, "Parts of Lists", "Tooltip"]& ], 
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {5, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[5], Selectable -> False], 
            TagBox[
             TooltipBox[
              PaneSelectorBox[{False -> ButtonBox[
                  PaneBox[
                   GraphicsBox[
                    TagBox[
                    RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UJAfiDmBmAWI////vwKIfwFxMQMOAJT7+R8B6nGoSf+PCjpwqMskUl0SEP9F
UtcHxIxY1EWjqZuOQ10Mmr2TcNj7BEnNP1LNIeQeIDsZn78IhQ8x4fwfNb4a
cPgTFu8l2ORBAAC+1hnm
                    "], {{0, 15}, {9, 0}}, {0, 255}, 
                    ColorFunction -> RGBColor], 
                    BoxForm`ImageTag[
                    "Byte", ColorSpace -> "RGB", Interleaving -> True], 
                    Selectable -> False], DefaultBaseStyle -> "ImageGraphics",
                     ImageSizeRaw -> {9, 15}, PlotRange -> {{0, 9}, {0, 15}}, 
                    ImageSize -> Magnification[1]], ImageSize -> {35, 30}, 
                   Alignment -> Center], 
                  ButtonFunction :> (
                   NotebookLocate[{
                    "EIWL2-33-expressions-and-their-structure.nb", ""}, 
                    FrontEnd`HistoryData :> {
                    EvaluationNotebook[]}]& ), Appearance -> None, Evaluator -> 
                  Automatic, Method -> "Preemptive"], True -> ButtonBox[
                  PaneBox[
                   GraphicsBox[
                    TagBox[
                    RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UJAfiDmBmAWI////vwKIfwFxMQMOAJT7+R8B6nGoSf+PCjpwqMskUl0SEP9F
UtcHxIxY1EWjqZuOQ10Mmr2TcNj7BEnNP1LNIeQeIDsZn78IhQ8x4fwfNb4a
cPgTFu8l2ORBAAC+1hnm
                    "], {{0, 15}, {9, 0}}, {0, 255}, 
                    ColorFunction -> RGBColor], 
                    BoxForm`ImageTag[
                    "Byte", ColorSpace -> "RGB", Interleaving -> True], 
                    Selectable -> False], DefaultBaseStyle -> "ImageGraphics",
                     ImageSizeRaw -> {9, 15}, PlotRange -> {{0, 9}, {0, 15}}, 
                    ImageSize -> Magnification[1]], ImageSize -> {35, 30}, 
                   Alignment -> Center], 
                  ButtonFunction :> (
                   NotebookLocate[{
                    "EIWL2-33-expressions-and-their-structure.nb", ""}, 
                    FrontEnd`HistoryData :> {
                    EvaluationNotebook[]}]& ), Appearance -> None, Background -> 
                  RGBColor[0.835294, 0.364706, 0.0196078], Evaluator -> 
                  Automatic, Method -> "Preemptive"]}, 
               Dynamic[
                CurrentValue["MouseOver"]], ImageSize -> Automatic, 
               FrameMargins -> 0], "\"Expressions and Their Structure\"", 
              TooltipDelay -> 0.15, LabelStyle -> "TextStyling"], 
             Annotation[#, "Expressions and Their Structure", "Tooltip"]& ]}, 
           "RowWithSeparators"], Alignment -> Right], ImageSize -> {100, 30}, 
         FrameMargins -> {{0, 6}, {0, 0}}, Alignment -> Right], 
        ActionMenuBox[
         PaneSelectorBox[{True -> PanelBox[
             GraphicsBox[
              TagBox[
               RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UBAkIQ3ELED8////Jf/pA0D2/KWTXSB7ZtPBPrA9DKOAYgAMR1Eg9gPiABpi
P6g912mcLmAAZM9XOtkFsicKiNcD8QYaYpD5UQOdXoYD+E/HMooO9iDbR7c6
BQDxtyEt
                "], {{0, 16}, {27, 0}}, {0, 255}, ColorFunction -> 
                RGBColor], 
               BoxForm`ImageTag[
               "Byte", ColorSpace -> "RGB", Interleaving -> True, 
                Magnification -> 1], Selectable -> False], DefaultBaseStyle -> 
              "ImageGraphics", ImageSize -> Magnification[1], 
              ImageSizeRaw -> {27, 16}, PlotRange -> {{0, 27}, {0, 16}}], 
             Appearance -> None, Background -> 
             RGBColor[0.835294, 0.364706, 0.0196078], ImageSize -> {35, 30}, 
             Alignment -> Center], False -> PanelBox[
             GraphicsBox[
              TagBox[
               RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UBAkIQ3ELED8////Jf/pA0D2/KWTXSB7ZtPBPrA9DKOAYgAMR1Eg9gPiABpi
P6g912mcLmAAZM9XOtkFsicKiNcD8QYaYpD5UQOdXoYD+E/HMooO9iDbR7c6
BQDxtyEt
                "], {{0, 16}, {27, 0}}, {0, 255}, ColorFunction -> 
                RGBColor], 
               BoxForm`ImageTag[
               "Byte", ColorSpace -> "RGB", Interleaving -> True, 
                Magnification -> 1], Selectable -> False], DefaultBaseStyle -> 
              "ImageGraphics", ImageSize -> Magnification[1], 
              ImageSizeRaw -> {27, 16}, PlotRange -> {{0, 27}, {0, 16}}], 
             Appearance -> None, Background -> 
             RGBColor[0.952941, 0.509804, 0], ImageSize -> {35, 30}, 
             Alignment -> Center]}, 
          Dynamic[
           CurrentValue["MouseOver"]]], {
         "Preface" :> 
          NotebookLocate[{"EIWL2-0a-preface.nb", ""}, FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], "What Is the Wolfram Language?" :> 
          NotebookLocate[{"EIWL2-0b-what-is-the-wolfram-language.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "Practicalities of Using the Wolfram Language" :> 
          NotebookLocate[{
            "EIWL2-0c-practicalities-of-using-the-wolfram-language.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], "Other Resources" :> 
          NotebookLocate[{"EIWL2-0d-other-resources.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]1\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]Starting Out: Elementary Arithmetic" :> 
          NotebookLocate[{
            "EIWL2-01-starting-out-elementary-arithmetic.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]2\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]Introducing Functions" :> 
          NotebookLocate[{"EIWL2-02-introducing-functions.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]3\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]First Look at Lists" :> 
          NotebookLocate[{"EIWL2-03-first-look-at-lists.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]4\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]Displaying Lists" :> 
          NotebookLocate[{"EIWL2-04-displaying-lists.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]5\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]Operations on Lists" :> 
          NotebookLocate[{"EIWL2-05-operations-on-lists.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]6\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]Making Tables" :> 
          NotebookLocate[{"EIWL2-06-making-tables.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]7\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]Colors and Styles" :> 
          NotebookLocate[{"EIWL2-07-colors-and-styles.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]8\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]Basic Graphics Objects" :> 
          NotebookLocate[{"EIWL2-08-basic-graphics-objects.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]9\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]Interactive Manipulation" :> 
          NotebookLocate[{"EIWL2-09-interactive-manipulation.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "10\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Images" :> 
          NotebookLocate[{"EIWL2-10-images.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "11\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Strings and \
Text" :> NotebookLocate[{"EIWL2-11-strings-and-text.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "12\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Sound" :> 
          NotebookLocate[{"EIWL2-12-sound.nb", ""}, FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "13\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Arrays, or \
Lists of Lists" :> 
          NotebookLocate[{"EIWL2-13-arrays-or-lists-of-lists.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "14\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Coordinates \
and Graphics" :> 
          NotebookLocate[{"EIWL2-14-coordinates-and-graphics.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "15\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]The Scope \
of the Wolfram Language" :> 
          NotebookLocate[{
            "EIWL2-15-the-scope-of-the-wolfram-language.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "16\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Real\
\[Hyphen]World Data" :> 
          NotebookLocate[{"EIWL2-16-real-world-data.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "17\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Units" :> 
          NotebookLocate[{"EIWL2-17-units.nb", ""}, FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "18\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
Geocomputation" :> 
          NotebookLocate[{"EIWL2-18-geocomputation.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "19\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Dates and \
Times" :> NotebookLocate[{"EIWL2-19-dates-and-times.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "20\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Options" :> 
          NotebookLocate[{"EIWL2-20-options.nb", ""}, FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "21\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Graphs and \
Networks" :> 
          NotebookLocate[{"EIWL2-21-graphs-and-networks.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "22\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Machine \
Learning" :> 
          NotebookLocate[{"EIWL2-22-machine-learning.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "23\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]More about \
Numbers" :> NotebookLocate[{"EIWL2-23-more-about-numbers.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "24\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]More Forms \
of Visualization" :> 
          NotebookLocate[{"EIWL2-24-more-forms-of-visualization.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "25\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Ways to \
Apply Functions" :> 
          NotebookLocate[{"EIWL2-25-ways-to-apply-functions.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "26\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Pure \
Anonymous Functions" :> 
          NotebookLocate[{"EIWL2-26-pure-anonymous-functions.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "27\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Applying \
Functions Repeatedly" :> 
          NotebookLocate[{"EIWL2-27-applying-functions-repeatedly.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "28\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Tests and \
Conditionals" :> 
          NotebookLocate[{"EIWL2-28-tests-and-conditionals.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "29\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]More about \
Pure Functions" :> 
          NotebookLocate[{"EIWL2-29-more-about-pure-functions.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "30\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Rearranging \
Lists" :> NotebookLocate[{"EIWL2-30-rearranging-lists.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "31\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Parts of \
Lists" :> NotebookLocate[{"EIWL2-31-parts-of-lists.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "32\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Patterns" :> 
          NotebookLocate[{"EIWL2-32-patterns.nb", ""}, FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "33\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Expressions \
and Their Structure" :> 
          NotebookLocate[{"EIWL2-33-expressions-and-their-structure.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "34\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
Associations" :> 
          NotebookLocate[{"EIWL2-34-associations.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "35\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Natural \
Language Understanding" :> 
          NotebookLocate[{"EIWL2-35-natural-language-understanding.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "36\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Creating \
Websites and Apps" :> 
          NotebookLocate[{"EIWL2-36-creating-websites-and-apps.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "37\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Layout and \
Display" :> NotebookLocate[{"EIWL2-37-layout-and-display.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "38\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Assigning \
Names to Things" :> 
          NotebookLocate[{"EIWL2-38-assigning-names-to-things.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "39\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Immediate \
and Delayed Values" :> 
          NotebookLocate[{"EIWL2-39-immediate-and-delayed-values.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "40\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Defining \
Your Own Functions" :> 
          NotebookLocate[{"EIWL2-40-defining-your-own-functions.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "41\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]More about \
Patterns" :> 
          NotebookLocate[{"EIWL2-41-more-about-patterns.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "42\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]String \
Patterns and Templates " :> 
          NotebookLocate[{"EIWL2-42-string-patterns-and-templates.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "43\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Storing \
Things" :> NotebookLocate[{"EIWL2-43-storing-things.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "44\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Importing \
and Exporting" :> 
          NotebookLocate[{"EIWL2-44-importing-and-exporting.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "45\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Datasets" :> 
          NotebookLocate[{"EIWL2-45-datasets.nb", ""}, FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "46\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Writing \
Good Code" :> 
          NotebookLocate[{"EIWL2-46-writing-good-code.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "47\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Debugging \
Your Code" :> 
          NotebookLocate[{"EIWL2-47-debugging-your-code.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "What We Haven\[CloseCurlyQuote]t Discussed" :> 
          NotebookLocate[{"EIWL2-what-we-havent-discussed.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], "Afterword: Being a Programmer" :> 
          NotebookLocate[{"EIWL2-being-a-programmer.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], "Answers to Exercises" :> 
          NotebookLocate[{"EIWL2-answers-to-exercises.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], "Index" :> 
          NotebookLocate[{"EIWL2-book-index.nb", ""}, FrontEnd`HistoryData :> {
              EvaluationNotebook[]}]}, Appearance -> None]}}, 
      GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Center}}}, 
      GridBoxItemSize -> {
       "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], "Grid"]], 
   "Text", ShowCellBracket -> False, CellFrame -> {{0, 0}, {3, 0}}, 
   Selectable -> False, CellFrameColor -> 
   RGBColor[0.835294, 0.364706, 0.0196078], CellMargins -> {{0, 0}, {0, -1}}, 
   CellFrameMargins -> {{27, 0}, {1, 7}}, Background -> 
   RGBColor[0.952941, 0.509804, 0], CellTags -> "DockedCellLogoCell"], 
  Cell["SECOND EDITION", "Text", FontFamily -> "Source Sans Pro", 
   CellFrame -> {{0, 0}, {3, 0}}, ShowCellBracket -> False, 
   CellMargins -> {{0, 0}, {-1, -1}}, CellFrameMargins -> {{66, 0}, {2, 4}}, 
   CellFrameColor -> RGBColor[0.952941, 0.509804, 0], FontSize -> 10, 
   FontTracking -> "Extended", FontColor -> RGBColor[1, 0.929412, 0.721569], 
   Background -> RGBColor[0.862745, 0.309804, 0], CellTags -> 
   "DockedCellLogoCell"]},
PrintingStartingPageNumber->273,
PageHeaders->{{
   Cell[
    TextData[{
      StyleBox[
       CounterBox["Page"], "PageNumber"], 
      StyleBox[
      "    An Elementary Introduction to the Wolfram Language", "Header"]}], 
    "Header", CellMargins -> {{37, Inherited}, {Inherited, Inherited}}], None,
    None}, {None, None, 
   Cell[
    TextData[{
      StyleBox[
       CounterBox["Section"], "Header"], 
      StyleBox[" | Patterns \[LongDash] wolfr.am/eiwl-", "Header"], 
      StyleBox[
       CounterBox["Section"], "Header"], 
      StyleBox["    ", "Header"], 
      StyleBox[
       CounterBox["Page"], "PageNumber"]}], "Header", 
    CellMargins -> {{Inherited, 17}, {Inherited, Inherited}}]}},
PrintingOptions->{"FirstPageHeader"->True},
PrivateNotebookOptions->{"PluginToolbarEnabled"->False},
ShowCellBracket->Automatic,
ShowAutoSpellCheck->False,
ShowPredictiveInterface->False,
ShowSyntaxStyles->False,
Magnification->1.,
FrontEndVersion->"12.3 for Mac OS X x86 (64-bit) (July 30, 2021)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[StyleDefinitions -> "Default.nb"]], 
   Cell[
    CellGroupData[{
      Cell[
      "Style Environments", "Section", 
       CellChangeTimes -> {{3.64661165091824*^9, 3.646611654013329*^9}, 
         3.6485723794335403`*^9, 3.651347081728628*^9, 3.651347179462186*^9, 
         3.651347384135805*^9, 3.651348171662589*^9}], 
      Cell[
       StyleData[All, "Working"], CellInsertionPointCell -> 
       FEPrivate`FrontEndResource["FEExpressions", "CellInsertionMenu"], 
       CreateCellID -> True, $CellContext`GhostCellInEmptyNotebook -> False], 
      
      Cell[
       StyleData[All, "Printout"], 
       PrintingOptions -> {
        "PageSize" -> {504, 720}, "PrintRegistrationMarks" -> True}, 
       Magnification -> 0.6]}, Closed]], 
   Cell[
    CellGroupData[{
      Cell["Styles for Headers and Footers", "Section"], 
      Cell[
       StyleData["Header"], StyleMenuListing -> None, FontFamily -> "Verdana",
        FontSize -> 7, FontSlant -> "Plain", FontColor -> GrayLevel[0.6]], 
      Cell[
       StyleData["PageNumber"], CellMargins -> {{0, 0}, {4, 1}}, 
       StyleMenuListing -> None, FontFamily -> "Verdana", FontSize -> 7, 
       FontWeight -> "Bold", FontSlant -> "Plain", FontColor -> 
       GrayLevel[0]]}, Closed]], 
   Cell[
    CellGroupData[{
      Cell[
      "WPL Specific", "Section", 
       CellChangeTimes -> {{3.6556608433734913`*^9, 3.6556608489412746`*^9}}], 
      Cell[
       StyleData["Link"], FontFamily -> "Source Sans Pro", FontSize :> 
       If[CurrentValue[
           EvaluationCell[], "FontFamily"] === "Source Sans Pro", Inherited, 
         If[CurrentValue[
            EvaluationCell[], "FontFamily"] === "WolframCodeSans", Inherited, 
          Inherited 0.9]], FontColor -> GrayLevel[0]], 
      Cell[
       StyleData["CodeLink"], 
       ButtonBoxOptions -> {
        Appearance -> None, ButtonFunction :> (FEPrivate`FrontEndExecute[
           FrontEndToken["OpenHelpLink", {
             Part[#, 1], Null}]]& ), ButtonSource -> ButtonContents, 
         Evaluator -> None, Method -> "Preemptive"}]}, Closed]], 
   Cell[
    CellGroupData[{
      Cell[
      "Custom Styles", "Section", 
       CellChangeTimes -> {{3.646611660445352*^9, 3.646611669493331*^9}}], 
      Cell[
       StyleData["Notebook"], PageWidth :> 700, 
       PrintingOptions -> {
        "InnerOuterMargins" -> {35, 16}, "PaperOrientation" -> "Portrait", 
         "PaperSize" -> {504, 720}, 
         "PrintingMargins" -> {{20, 20}, {54, 54}}}, CellLabelAutoDelete -> 
       False, ShowSyntaxStyles -> True, 
       AutoStyleOptions -> {
        "FormattingErrorTooltips" -> False, "HighlightComments" -> False, 
         "HighlightEmphasizedSyntaxErrors" -> False, 
         "HighlightExcessArguments" -> False, "HighlightFormattingErrors" -> 
         False, "HighlightGlobalToLocalScopeConflicts" -> False, 
         "HighlightGraphicsCompatibilityProblems" -> False, 
         "HighlightLocalScopeConflicts" -> False, "HighlightMissingArguments" -> 
         False, "HighlightNoKernelPresent" -> False, 
         "HighlightOrderOfEvaluationConflicts" -> False, "HighlightStrings" -> 
         True, "HighlightSymbolContexts" -> False, "HighlightSymbolShadowing" -> 
         False, "HighlightSyntaxErrors" -> False, "HighlightUndefinedSymbols" -> 
         False, "HighlightUnknownOptions" -> False, 
         "HighlightUnwantedAssignments" -> False}, MenuSortingValue -> None, 
       GraphicsBoxOptions -> {ImageSize -> 240}, 
       Graphics3DBoxOptions -> {ImageSize -> 240}], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Title"], CellMargins -> {{64, Inherited}, {50, 72}}, 
          MenuCommandKey :> None, FontFamily -> "Verdana", FontSize -> 42, 
          FontWeight -> "Bold", FontColor -> GrayLevel[0.4]], 
         Cell[
          StyleData["Title", "Printout"], 
          CellMargins -> {{64, Inherited}, {50, 72}}]}, Closed]], 
      Cell[
       StyleData["Chapter"], MenuCommandKey :> None], 
      Cell[
       StyleData["Subchapter"], MenuCommandKey :> None], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Section"], CellFrame -> {{0, 0}, {0, 0}}, CellDingbat -> 
          Cell[
            TextData[
             CounterBox["Section"], 
             StyleBox[
             "|\[NegativeThinSpace]", FontColor -> 
              RGBColor[
               0.9019607843137255, 0.4117647058823529, 0.027450980392156862`],
               FontFamily -> "Courier", FontSize -> 36, FontWeight -> Plain]],
             "SectionNumber"], CellMargins -> {{96, Inherited}, {12, 44}}, 
          Evaluatable -> True, CellGroupingRules -> {"SectionGrouping", 60}, 
          PageBreakAbove -> True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["Section", "Printout"], 
          CellMargins -> {{96, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionDoubleDigit"], CellFrame -> {{0, 0}, {0, 0}}, 
          CellDingbat -> Cell[
            TextData[
             CounterBox["Section"], 
             StyleBox[
             "|\[NegativeThinSpace]", FontColor -> 
              RGBColor[
               0.9019607843137255, 0.4117647058823529, 0.027450980392156862`],
               FontFamily -> "Courier", FontSize -> 36, FontWeight -> Plain]],
             "SectionNumber"], CellMargins -> {{112, Inherited}, {12, 44}}, 
          Evaluatable -> True, CellGroupingRules -> {"SectionGrouping", 60}, 
          PageBreakAbove -> True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["SectionDoubleDigit", "Printout"], 
          CellMargins -> {{112, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionNumber"], CellBaseline -> Baseline, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 26, FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SectionNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionInline"], FontFamily -> 
          "Source Sans Pro Semibold", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SectionInline", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionNoDingbat"], 
          CellMargins -> {{64, Inherited}, {12, 44}}, Evaluatable -> True, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakAbove -> 
          True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["SectionNoDingbat", "Printout"], 
          CellMargins -> {{64, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       StyleData["AnswerKeyNumberedSection"], 
       CellMargins -> {{64, Inherited}, {8, 28}}, Evaluatable -> True, 
       CellGroupingRules -> {"SectionGrouping", 60}, PageBreakAbove -> True, 
       ShowCellLabel -> False, 
       CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
       CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
       CounterIncrements -> "Section", 
       CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
         "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", FontSize -> 
       18, FontSlant -> "Plain", FontColor -> 
       RGBColor[
        0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
       InterpretationBoxOptions -> {Editable -> True}], 
      Cell[
       StyleData["AnswerKeySectionNumber"], CellBaseline -> Baseline, 
       FontFamily -> "Source Sans Pro Semibold", FontSize -> 18, FontColor -> 
       RGBColor[
        0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
      Cell[
       StyleData["IndexLinkGuide"], 
       CellMargins -> {{64, Inherited}, {48, 28}}, Evaluatable -> True, 
       CellGroupingRules -> {"SectionGrouping", 60}, PageBreakAbove -> True, 
       ShowCellLabel -> False, 
       CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
       CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
       CounterIncrements -> "Section", 
       CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
         "Exercise", 0}}, FontFamily -> "Source Sans Pro", FontSize -> 14, 
       FontSlant -> "Plain", FontColor -> 
       RGBColor[
        0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
       InterpretationBoxOptions -> {Editable -> True}], 
      Cell[
       StyleData["Index"], MenuSortingValue -> 10000, FontFamily -> 
       "Source Sans Pro", FontSize -> 11], 
      Cell[
       StyleData["IndexSubentry"], MenuSortingValue -> 10000, FontFamily -> 
       "Source Sans Pro", FontSize -> 11], 
      Cell[
       StyleData["FunctionName"], MenuSortingValue -> 10000, FontFamily -> 
       "Source Sans Pro Semibold", FontWeight -> "Bold"], 
      Cell[
       StyleData["IndexColumn"], 
       CellMargins -> {{66, 0}, {Inherited, Inherited}}, TabSpacings -> {2.}, 
       MenuSortingValue -> 10000, FontFamily -> "Source Sans Pro", 
       GridBoxOptions -> {
        GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
         GridBoxItemSize -> {"Columns" -> {{25}}}, 
         GridBoxSpacings -> {"Columns" -> {{2}}}}], 
      Cell[
       StyleData["IndexSubsection"], 
       CellMargins -> {{64, Inherited}, {9, 28}}, 
       CellGroupingRules -> {"SectionGrouping", 40}, MenuSortingValue -> 
       10000, FontFamily -> "Source Sans Pro", FontSize -> 24], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Subsection"], CellMargins -> {{64, Inherited}, {12, 32}},
           FontFamily -> "Source Sans Pro Semibold", FontSize -> 18, 
          FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["Subsection", "Printout"], 
          CellMargins -> {{64, Inherited}, {12, 32}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ResourcesSubsection"], 
          CellMargins -> {{64, Inherited}, {4, 16}}, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 15, FontSlant -> "Plain", 
          FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["ResourcesSubsection", "Printout"], 
          CellMargins -> {{64, Inherited}, {4, 16}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Subsubsection"], 
          CellMargins -> {{64, Inherited}, {6, 12}}, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 16, FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["Subsubsection", "Printout"], 
          CellMargins -> {{64, Inherited}, {6, 12}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularySection"], PageWidth :> 700, 
          CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 24}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 18, FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["VocabularySection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 24}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularyTable", StyleDefinitions -> StyleData["Text"]],
           SpanMaxSize -> 1, FontFamily -> "Source Sans Pro Light", FontColor -> 
          GrayLevel[0.8], 
          GridBoxOptions -> {
           GridBoxAlignment -> {"Columns" -> {{Left}}}, 
            GridBoxDividers -> {"Columns" -> {{False}}, "Rows" -> {False, {
                 Directive[
                  Thickness[0.5], "VocabDivColor"]}, False}}, 
            GridBoxItemStyle -> {
             "Columns" -> {"VocabularyCode", Inherited, Inherited}, 
              "Rows" -> {{Automatic}}}, 
            GridBoxSpacings -> {
             "Columns" -> {{0, 1, 2, 1, 2}}, "Rows" -> {{1}}}}], 
         Cell[
          StyleData["VocabularyTable", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "VocabularyTable3Column", StyleDefinitions -> StyleData["Text"]], 
          SpanMaxSize -> 1, FontFamily -> "Source Sans Pro Light", FontColor -> 
          GrayLevel[0.8], 
          GridBoxOptions -> {
           GridBoxAlignment -> {"Columns" -> {{Left}}}, 
            GridBoxDividers -> {"Columns" -> {{False}}, "Rows" -> {False, {
                 Directive[
                  Thickness[0.5], "VocabDivColor"]}, False}}, 
            GridBoxItemStyle -> {
             "Columns" -> {
               "VocabularyCode", Inherited, "VocabularyCode", Inherited, 
                Inherited}, "Rows" -> {{Automatic}}}, 
            GridBoxSpacings -> {
             "Columns" -> {{0, 1, 2, 1, 2}}, "Rows" -> {{1}}}}], 
         Cell[
          StyleData["VocabularyTable3Column", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularyText"], FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["VocabularyText", "Printout"], 
          CellMargins -> {{66, 10}, {7, 7}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularyCode", StyleDefinitions -> StyleData["Text"]], 
          Deletable -> False, FontFamily -> "Source Sans Pro", FontSize -> 14,
           FontWeight -> "Bold", FontColor -> GrayLevel[0.25], 
          GridBoxOptions -> {
           GridBoxAlignment -> {"Columns" -> {{Left}}}, 
            GridBoxDividers -> {
             "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {True, {True}, True}, "RowsIndexed" -> {}}}], 
         Cell[
          StyleData["VocabularyCode", "Printout"], FontColor -> 
          GrayLevel[0.25]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabDivColor"], FontColor -> GrayLevel[0.8]], 
         Cell[
          StyleData["VocabDivColor", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseSection"], PageWidth :> 700, 
          CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, Evaluatable -> True, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, ShowCellLabel -> False, CellFrameMargins -> {{8, 8}, {4, 6}},
           CellFrameColor -> RGBColor[0.901961, 0.411765, 0.027451], 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro", FontSize -> 18, 
          FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["ExerciseSection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 30}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Exercise"], PageWidth :> 700, CellDingbat -> Cell[
            TextData[{"  ", 
              CounterBox["Section"], ".", 
              CounterBox["Exercise"]}], "ExerciseNumber", FontColor -> 
            RGBColor[
             0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
          ShowGroupOpener -> True, CellMargins -> {{108, Inherited}, {4, 8}}, 
          CellGroupingRules -> {"SectionGrouping", 67}, CounterIncrements -> 
          "Exercise", MenuSortingValue -> 10020, MenuCommandKey :> "2", 
          FontFamily -> "Source Sans Pro", FontSize -> 14, FontWeight -> 
          "Plain", FontSlant -> "Plain", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["Exercise", "Printout"], ShowGroupOpener -> False, 
          CellMargins -> {{110, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseNumber"], FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Bold", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["ExerciseNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseSubsection"], PageWidth :> 500, 
          CellFrame -> {{False, False}, {1, False}}, 
          CellMargins -> {{64, Inherited}, {8, 18}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, CellFrameColor -> 
          RGBColor[0.65, 0.6, 0.6], FontFamily -> "Source Sans Pro", FontSize -> 
          18, FontSlant -> "Italic", FontColor -> RGBColor[0.65, 0.6, 0.6]], 
         Cell[
          StyleData["ExerciseSubsection", "Printout"], 
          CellFrame -> {{False, False}, {1, False}}, CellFrameColor -> 
          RGBColor[0.65, 0.6, 0.6]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseNote"], PageWidth :> 700, 
          CellMargins -> {{64, Inherited}, {4, 8}}, PageBreakBelow -> False, 
          MenuSortingValue -> 10050, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0.25], $CellContext`ReturnCreatesNewCell -> 
          True], 
         Cell[
          StyleData["ExerciseNote", "Printout"], 
          CellMargins -> {{64, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["QASection"], PageWidth :> 700, 
          CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Question", 0}}, FontFamily -> "Source Sans Pro", FontSize -> 18, 
          FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["QASection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 30}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Question"], PageWidth :> 700, 
          CellMargins -> {{64, Inherited}, {2, 12}}, PageBreakBelow -> False, 
          CounterIncrements -> "Question", MenuSortingValue -> 10030, 
          MenuCommandKey :> "3", FontFamily -> "Source Sans Pro", FontSize -> 
          14, FontWeight -> "Bold", FontSlant -> 
          "Plain", $CellContext`ReturnCreatesNewCell -> 
          True, $CellContext`DefaultReturnCreatedCellStyle -> "Answer"], 
         Cell[
          StyleData["Question", "Printout"], 
          CellMargins -> {{65, Inherited}, {2, 12}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Answer"], PageWidth :> 700, 
          CellMargins -> {{66, 10}, {4, 1}}, LineSpacing -> {1.125, 1., 2.}, 
          MenuSortingValue -> 10032, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0.25], $CellContext`ReturnCreatesNewCell -> 
          True, $CellContext`DefaultReturnCreatedCellStyle -> "Question"], 
         Cell[
          StyleData["Answer", "Printout"], 
          CellMargins -> {{66, 10}, {4, 1}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["QuestionNumber"], FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Bold", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["QuestionNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TechNoteSection"], PageWidth :> 700, 
          CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 18, FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["TechNoteSection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 30}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TechNote"], PageWidth :> 700, CellDingbat -> Cell[
            TextData[{"\[FilledSmallSquare]"}], FontSize -> 12, FontColor -> 
            GrayLevel[0.5]], CellMargins -> {{78, Inherited}, {4, 8}}, 
          CellChangeTimes -> {{3.651515120816633*^9, 3.651515125814807*^9}, 
            3.6515155174947033`*^9}, LineSpacing -> {1.25, 1., 2.}, 
          MenuSortingValue -> 10040, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0.25], $CellContext`ReturnCreatesNewCell -> 
          True], 
         Cell[
          StyleData["TechNote", "Printout"], 
          CellMargins -> {{82, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["MoreExploreSection"], PageWidth :> 700, 
          CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 18, FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["MoreExploreSection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 30}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["MoreExplore"], PageWidth :> 700, 
          CellMargins -> {{64, Inherited}, {4, 8}}, PageBreakBelow -> False, 
          MenuSortingValue -> 10050, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0], $CellContext`ReturnCreatesNewCell -> 
          True], 
         Cell[
          StyleData["MoreExplore", "Printout"], 
          CellMargins -> {{64, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["MoreExploreShortURL"], 
          CellMargins -> {{64, Inherited}, {4, 8}}, PageBreakBelow -> False, 
          FontFamily -> "Source Sans Pro Light", FontSize -> 14, FontSlant -> 
          "Plain", FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["MoreExploreShortURL", "Printout"], 
          CellMargins -> {{64, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Text"], CellMargins -> {{66, 10}, {4, 14}}, FontFamily -> 
          "Baskerville", FontSize -> 18, FontColor -> 
          GrayLevel[0], $CellContext`ReturnCreatesNewCell -> True], 
         Cell[
          StyleData["Text", "Printout"], CellMargins -> {{66, 10}, {7, 7}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ResourcesText"], CellMargins -> {{66, 10}, {2, 0}}, 
          FontFamily -> "Source Sans Pro", FontSize -> 14, FontWeight -> 
          "Plain", FontSlant -> "Plain", FontColor -> 
          GrayLevel[0], $CellContext`ReturnCreatesNewCell -> True], 
         Cell[
          StyleData["ResourcesText", "Printout"], 
          CellMargins -> {{66, 10}, {2, 0}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ResourcesLink"], CellMargins -> {{66, 10}, {2, 0}}, 
          FontFamily -> "Source Sans Pro", FontSize -> 14, FontWeight -> 
          "Plain", FontSlant -> "Italic", FontColor -> 
          GrayLevel[0], $CellContext`ReturnCreatesNewCell -> True], 
         Cell[
          StyleData["ResourcesLink", "Printout"], 
          CellMargins -> {{66, 10}, {2, 0}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["CodeCaption"], CellFrame -> {{0, 0}, {0, 0}}, 
          CellMargins -> {{66, 10}, {4, 12}}, PageBreakBelow -> False, 
          CellFrameColor -> GrayLevel[0.4], MenuSortingValue -> 10010, 
          MenuCommandKey :> "1", FontFamily -> "Source Sans Pro", FontSize -> 
          16, FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["CodeCaption", "Printout"], 
          CellMargins -> {{66, 10}, {4, 12}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Input"], CellMargins -> {{99, 10}, {3, 7}}, SpanMaxSize -> 
          1, FontSize -> 15], 
         Cell[
          StyleData["Input", "Printout"], CellMargins -> {{99, 10}, {3, 7}}]},
         Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Output"], CellMargins -> {{99, 10}, {14, 7}}, FontSize -> 
          15], 
         Cell[
          StyleData["Output", "Printout"], 
          CellMargins -> {{99, 10}, {14, 7}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["InputOnly"], CellMargins -> {{99, 10}, {25, 10}}, 
          SpanMaxSize -> 1, MenuSortingValue -> 1500, FontSize -> 15], 
         Cell[
          StyleData["InputOnly", "Printout"], 
          CellMargins -> {{99, 10}, {15, 10}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["CellLabel"], 
          CellLabelMargins -> {{12, Inherited}, {Inherited, Inherited}}, 
          LanguageCategory -> None, StyleMenuListing -> None, FontFamily -> 
          "Helvetica Neue", FontSize -> 9, FontWeight -> "Plain", FontSlant -> 
          "Plain", FontColor -> GrayLevel[0.5]], 
         Cell[
          StyleData["CellLabel", "Printout"], FontSize -> 8, FontColor -> 
          GrayLevel[0.5]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Message"], Editable -> False, 
          CellMargins -> {{66, Inherited}, {Inherited, Inherited}}, 
          CellGroupingRules -> "OutputGrouping", TextClipboardType -> 
          "PlainText", PageBreakWithin -> False, GroupPageBreakWithin -> 
          False, GeneratedCell -> True, CellAutoOverwrite -> True, 
          ShowCellLabel -> False, DefaultFormatType -> 
          DefaultOutputFormatType, ContextMenu -> 
          FEPrivate`FrontEndResource["ContextMenus", "Output"], 
          ShowAutoStyles -> False, ShowSyntaxStyles -> False, 
          AutoStyleOptions -> {
           "StringStyle" -> None, "SyntaxErrorStyle" -> None}, 
          HyphenationOptions -> {"HyphenationCharacter" -> "\[Continuation]"},
           AutoItalicWords -> {}, AutoQuoteCharacters -> {}, 
          PasteAutoQuoteCharacters -> {}, LanguageCategory -> None, 
          FormatType -> InputForm, ShowStringCharacters -> False, 
          CounterIncrements -> "Message", MenuSortingValue -> 1600, 
          StyleMenuListing -> None, FontFamily :> 
          CurrentValue["PanelFontFamily"], FontSize -> 11, FontColor -> 
          RGBColor[0.5072, 0.16933, 0.15221], $CellContext`StripStyleOnPaste -> 
          True], 
         Cell[
          StyleData["Message", "Printout"], 
          CellMargins -> {{100, Inherited}, {Inherited, Inherited}}, 
          CellFrameLabels -> {{None, None}, {None, None}}, FontColor -> 
          GrayLevel[0]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseInput", StyleDefinitions -> StyleData["Input"]], 
          CellMargins -> {{88, 10}, {4, 7}}, ShowCellLabel -> False, 
          SpanMaxSize -> 1, FontSize -> 
          14, $CellContext`GeneratedCellStyles -> {
           "Output" -> "ExerciseOutput"}], 
         Cell[
          StyleData["ExerciseInput", "Printout"], 
          CellMargins -> {{88, 10}, {4, 7}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "ExerciseOutput", StyleDefinitions -> StyleData["Output"]], 
          CellMargins -> {{88, 10}, {10, 4}}, ShowCellLabel -> False, 
          FontSize -> 14], 
         Cell[
          StyleData["ExerciseOutput", "Printout"], 
          CellMargins -> {{88, 10}, {10, 4}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Picture"], CellMargins -> {{66, 10}, {10, 10}}, 
          CellGroupingRules -> "GraphicsGrouping", StyleMenuListing -> None], 
         
         Cell[
          StyleData["Picture", "Printout"], 
          CellMargins -> {{66, 10}, {8, 8}}]}, Closed]], 
      Cell[
       StyleData["ExerciseSummaryCell"], PageWidth :> 700, CellFrame -> 0, 
       CellMargins -> {{64, Inherited}, {8, 10}}, 
       CellGroupingRules -> {"SectionGrouping", 64}, PageBreakBelow -> False, 
       ShowCellLabel -> False, CellFrameMargins -> 0, ShowStringCharacters -> 
       False, FontFamily -> "Source Sans Pro", FontSize -> 18, FontColor -> 
       RGBColor[1, 1, 1], 
       GridBoxOptions -> {GridBoxBackground -> {"Columns" -> {{
              RGBColor[0.990997, 0.539528, 0.155779], 
              RGBColor[0.989487, 0.434699, 0.0320439]}}, "Rows" -> {{None}}}, 
         GridBoxItemSize -> {"Columns" -> {
             Scaled[0.7], 
             Scaled[0.3]}, "Rows" -> {{Automatic}}}}], 
      Cell[
       StyleData["ExerciseSummaryHeading"], ShowStringCharacters -> False, 
       FontFamily -> "Source Sans Pro", FontSize -> 18, FontColor -> 
       RGBColor[1, 1, 1]], 
      Cell[
       StyleData["ExerciseSummarySubheading"], ShowStringCharacters -> False, 
       FontFamily -> "Source Sans Pro", FontSize -> 15, FontColor -> 
       RGBColor[1., 0.9294117647058824, 0.7215686274509804]], 
      Cell[
       StyleData["ExercisePreviewButtonText"], ShowStringCharacters -> False, 
       FontFamily -> "Source Sans Pro", FontSize -> 14, FontSlant -> "Plain", 
       FontColor -> RGBColor[0.6, 0.6, 0.6]], 
      Cell[
       StyleData["ExercisePreviewButtonTextHighlight"], ShowStringCharacters -> 
       False, FontFamily -> "Source Sans Pro", FontSize -> 14, FontSlant -> 
       "Plain", FontColor -> 
       RGBColor[
        0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]]}, 
     Open]], 
   Cell[
    CellGroupData[{
      Cell[
      "Inline and special formatting", "Section", 
       CellChangeTimes -> {{3.646681732592888*^9, 3.646681749414035*^9}}], 
      Cell[
       StyleData["Graphics"], MenuSortingValue -> None], 
      Cell[
       StyleData["Graphics3D"], MenuSortingValue -> None], 
      Cell[
       StyleData["StandardForm"], 
       InputAutoReplacements -> {
        "->" -> "\[Rule]", ":>" -> "\[RuleDelayed]", "<=" -> "\[LessEqual]", 
         ">=" -> "\[GreaterEqual]", "!=" -> "\[NotEqual]", "==" -> "\[Equal]",
          "@>" -> "\\[InlinePart]", "<->" -> "\[UndirectedEdge]", ParentList},
        LineSpacing -> {1.25, 0, 2}, SingleLetterItalics -> False, 
       StyleMenuListing -> None, FontFamily -> "Source Sans Pro", 
       PrivateFontOptions -> {"OperatorSubstitution" -> True}], 
      Cell[
       StyleData["OutputForm"], PageWidth :> DirectedInfinity[1], 
       TextAlignment -> Left, LineSpacing -> {0.6, 1}, 
       AutoQuoteCharacters -> {}, PasteAutoQuoteCharacters -> {}, 
       StyleMenuListing -> None, FontFamily -> "Source Sans Pro", 
       PrivateFontOptions -> {"OperatorSubstitution" -> True}], 
      Cell[
       StyleData["InputForm"], PageWidth :> DirectedInfinity[1], 
       InputAutoReplacements -> {}, AllowInlineCells -> False, Hyphenation -> 
       False, AutoQuoteCharacters -> {}, PasteAutoQuoteCharacters -> {}, 
       AutoSpacing -> False, NumberMarks -> True, AutoNumberFormatting -> 
       False, StyleMenuListing -> None, FontFamily -> "Source Sans Pro", 
       PrivateFontOptions -> {"OperatorSubstitution" -> True}], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["DetailsLink"], FontFamily -> "Source Sans Pro", FontSize :> 
          If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.9]], FontColor -> GrayLevel[0], 
          ButtonBoxOptions -> {
           ButtonFunction :> (
             Function[$CellContext`t, 
              NotebookFind[$CellContext`t, "Notes", All, CellStyle]; 
              NotebookFind[$CellContext`t, "NotesSection", All, CellStyle, 
                AutoScroll -> Top]][
              Documentation`HelpLookup[
               StringJoin["ref/", #]]]& ), ButtonSource -> ButtonContents, 
            Evaluator -> Automatic}], 
         Cell[
          StyleData["DetailsLink", "Printout"], FontFamily -> 
          "Source Sans Pro", FontSize :> If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.88]], FontColor -> GrayLevel[0]]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["LinkAlt"], FontFamily -> "Source Sans Pro", FontSize :> 
          If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.9]], FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["LinkAlt", "Printout"], FontFamily -> "Source Sans Pro", 
          FontSize :> If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.88]], FontColor -> GrayLevel[0]]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Hyperlink"], MenuSortingValue -> None, FontColor -> 
          RGBColor[0.3, 0.35, 0.5]], 
         Cell[
          StyleData["Hyperlink", "Printout"]]}, Closed]], 
      Cell[
       StyleData[
       "IndexNavigationLink", StyleDefinitions -> StyleData["Hyperlink"]], 
       MenuSortingValue -> None, FontColor -> 
       RGBColor[
        0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
      Cell[
       StyleData["Crosslink"], 
       ButtonBoxOptions -> {ButtonFunction :> (FrontEndExecute[{
            
            NotebookLocate[#2, "OpenInNewWindow" -> 
             CurrentValue["HyperlinkModifierKey"]]}]& ), Evaluator -> None, 
         Method -> "Queued"}], 
      Cell[
       StyleData["VocabularyLink"], FontColor -> GrayLevel[0], 
       ButtonBoxOptions -> {ButtonFunction :> (FrontEndExecute[{
            
            NotebookLocate[#2, "OpenInNewWindow" -> 
             CurrentValue["HyperlinkModifierKey"]]}]& ), Evaluator -> None, 
         Method -> "Queued"}], 
      Cell[
       StyleData["InlineCode"], SpanMaxSize -> 1, FontColor -> GrayLevel[0]], 
      
      Cell[
       StyleData["InlineCodeText"], SpanMaxSize -> 1, FontFamily -> 
       "Source Sans Pro", FontSize -> 0.95 Inherited], 
      Cell[
       StyleData["NoLabel"], ShowCellLabel -> 
       False, $CellContext`GeneratedCellStyles -> {
        "Output" -> "ExerciseOutput"}], 
      Cell[
       StyleData["MenuName"], FontFamily -> "Verdana", FontWeight -> "Bold", 
       FontColor -> GrayLevel[0.286275]], 
      Cell[
       StyleData["KeyEvent"], CellFrame -> {{0.5, 0.5}, {0.5, 0.5}}, 
       CellFrameMargins -> {{2, 2}, {2, 2}}, CellFrameColor -> GrayLevel[0.7],
        FontFamily -> "Verdana", FontColor -> GrayLevel[0.4]], 
      Cell[
       StyleData["KeyEventDelimiter"], FontColor -> GrayLevel[0.5]], 
      Cell[
       CellGroupData[{
         Cell["Key Styles", "Subsubsection"], 
         Cell[
          StyleData["Key0"], 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              TagBox[
               GridBox[{{
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> GrayLevel[1], StripOnInput -> 
                   False]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Center}}, "Rows" -> {{Baseline}}}, AutoDelete -> 
                False, GridBoxDividers -> {"Rows" -> {{None}}}, 
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{1.45}}},
                 GridBoxSpacings -> {"Columns" -> {{0}}}, 
                BaselinePosition -> {{1, 1}, Baseline}], "Grid"], 
              RoundingRadius -> 4, Background -> 
              GrayLevel[0.9333333333333333], 
              FrameMargins -> {{0, 0}, {-2, -2}}, FrameStyle -> {
                GrayLevel[0.8352941176470589], 
                AbsoluteThickness[1]}, BaselinePosition -> Baseline, 
              StripOnInput -> False]& )}], 
         Cell[
          StyleData["Key1"], 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              TagBox[
               GridBox[{{
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #2, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> GrayLevel[1], StripOnInput -> 
                   False]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Center}}, "Rows" -> {{Baseline}}}, AutoDelete -> 
                False, GridBoxDividers -> {
                 "ColumnsIndexed" -> {2 -> GrayLevel[0.8352941176470589]}, 
                  "Rows" -> {{None}}}, 
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{1.45}}},
                 GridBoxSpacings -> {"Columns" -> {{0}}}, 
                BaselinePosition -> {{1, 1}, Baseline}], "Grid"], 
              RoundingRadius -> 4, Background -> 
              GrayLevel[0.9333333333333333], 
              FrameMargins -> {{0, 0}, {-2, -2}}, FrameStyle -> {
                GrayLevel[0.8352941176470589], 
                AbsoluteThickness[1]}, BaselinePosition -> Baseline, 
              StripOnInput -> False]& )}], 
         Cell[
          StyleData["Key2"], 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              TagBox[
               GridBox[{{
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #2, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #3, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> GrayLevel[1], StripOnInput -> 
                   False]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Center}}, "Rows" -> {{Baseline}}}, AutoDelete -> 
                False, GridBoxDividers -> {
                 "ColumnsIndexed" -> {
                   2 -> GrayLevel[0.8352941176470589], 3 -> 
                    GrayLevel[0.8352941176470589]}, "Rows" -> {{None}}}, 
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{1.45}}},
                 GridBoxSpacings -> {"Columns" -> {{0}}}, 
                BaselinePosition -> {{1, 1}, Baseline}], "Grid"], 
              RoundingRadius -> 4, Background -> 
              GrayLevel[0.9333333333333333], 
              FrameMargins -> {{0, 0}, {-2, -2}}, FrameStyle -> {
                GrayLevel[0.8352941176470589], 
                AbsoluteThickness[1]}, BaselinePosition -> Baseline, 
              StripOnInput -> False]& )}], 
         Cell[
          StyleData["Key3"], 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              TagBox[
               GridBox[{{
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #2, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #3, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #4, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> GrayLevel[1], StripOnInput -> 
                   False]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Center}}, "Rows" -> {{Baseline}}}, AutoDelete -> 
                False, GridBoxDividers -> {
                 "ColumnsIndexed" -> {
                   2 -> GrayLevel[0.8352941176470589], 3 -> 
                    GrayLevel[0.8352941176470589], 4 -> 
                    GrayLevel[0.8352941176470589]}, "Rows" -> {{None}}}, 
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{1.45}}},
                 GridBoxSpacings -> {"Columns" -> {{0}}}, 
                BaselinePosition -> {{1, 1}, Baseline}], "Grid"], 
              RoundingRadius -> 4, Background -> 
              GrayLevel[0.9333333333333333], 
              FrameMargins -> {{0, 0}, {-2, -2}}, FrameStyle -> {
                GrayLevel[0.8352941176470589], 
                AbsoluteThickness[1]}, BaselinePosition -> Baseline, 
              StripOnInput -> False]& )}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell["Entity styles", "Subsubsection"], 
         Cell[
          StyleData["Entity"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              FrameBox[
               PaneSelectorBox[{True -> GridBox[{{
                    
                    StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]], 
                    StyleBox[
                    RowBox[{"(", #4, ")"}], FontFamily -> "Source Sans Pro", 
                    FontWeight -> "Plain", FontColor -> GrayLevel[0.65], 
                    Selectable -> False]}}, 
                   GridBoxItemSize -> {
                    "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                   GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}},
                    BaselinePosition -> {1, 1}], False -> 
                 PaneBox[#, 
                   BaseStyle -> {
                    FontColor -> RGBColor[0.395437, 0.20595, 0.061158]}, 
                   BaselinePosition -> Baseline]}, 
                Dynamic[
                 CurrentValue[Evaluatable]], ImageSize -> Automatic, 
                BaselinePosition -> Baseline, 
                BaseStyle -> {FontFamily -> "Helvetica"}], FrameStyle -> 
               RGBColor[1., 0.504768, 0.], Background -> 
               RGBColor[1., 0.980392, 0.921569], 
               FrameMargins -> {{5, 5}, {1.5, 1.5}}, 
               ImageMargins -> {{2, 2}, {2, 2}}, BaselinePosition -> Baseline,
                RoundingRadius -> 4], #3, 
              BaseStyle -> {
               FontWeight -> "Plain", ShowStringCharacters -> False, 
                LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityFrameless"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              PaneSelectorBox[{True -> GridBox[{{
                    
                    StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]], 
                    StyleBox[
                    RowBox[{"(", #4, ")"}], FontFamily -> "Source Sans Pro", 
                    FontWeight -> "Plain", FontColor -> GrayLevel[0.65], 
                    Selectable -> False]}}, 
                  GridBoxItemSize -> {
                   "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                  BaselinePosition -> {1, 1}], False -> 
                PaneBox[#, 
                  BaseStyle -> {
                   FontColor -> RGBColor[0.395437, 0.20595, 0.061158]}, 
                  BaselinePosition -> Baseline]}, 
               Dynamic[
                CurrentValue[Evaluatable]], ImageSize -> Automatic, 
               BaselinePosition -> Baseline, 
               BaseStyle -> {FontFamily -> "Helvetica"}], #3, 
              BaseStyle -> {
               ShowStringCharacters -> False, LineIndent -> 0, 
                PrivateFontOptions -> {
                 FontWeight -> "Plain", "OperatorSubstitution" -> False}}]& ),
             Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityFramelessHot"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {
           DisplayFunction -> (PaneSelectorBox[{True -> GridBox[{{
                   
                   StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0]], 
                   StyleBox[
                    RowBox[{"(", #4, ")"}], FontWeight -> "Plain", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0], Selectable -> 
                    False]}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                 BaselinePosition -> {1, 1}], False -> 
               PaneBox[#, BaseStyle -> {FontColor -> GrayLevel[0]}, 
                 BaselinePosition -> Baseline]}, 
              Dynamic[
               CurrentValue[Evaluatable]], ImageSize -> Automatic, 
              BaselinePosition -> Baseline, 
              BaseStyle -> {
               FontWeight -> "Plain", FontFamily -> "Helvetica", 
                ShowStringCharacters -> False, LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityClass"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              FrameBox[
               PaneSelectorBox[{True -> GridBox[{{
                    PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                    
                    StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]], 
                    StyleBox[
                    RowBox[{"(", #4, ")"}], FontWeight -> "Plain", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0.65], 
                    Selectable -> False]}}, 
                   GridBoxItemSize -> {
                    "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                   GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}},
                    BaselinePosition -> {1, 2}], False -> GridBox[{{
                    PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                    
                    StyleBox[#, FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]]}}, 
                   GridBoxItemSize -> {
                    "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                   GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}},
                    BaselinePosition -> {1, 2}]}, 
                Dynamic[
                 CurrentValue[Evaluatable]], ImageSize -> Automatic, 
                BaselinePosition -> Baseline, 
                BaseStyle -> {FontFamily -> "Helvetica"}], FrameStyle -> 
               RGBColor[1., 0.504768, 0.], Background -> 
               RGBColor[1., 0.980392, 0.921569], 
               FrameMargins -> {{5, 5}, {1.5, 1.5}}, 
               ImageMargins -> {{2, 2}, {2, 2}}, BaselinePosition -> Baseline,
                RoundingRadius -> 4], #3, 
              BaseStyle -> {
               FontWeight -> "Plain", ShowStringCharacters -> False, 
                LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityClassFrameless"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              PaneSelectorBox[{True -> GridBox[{{
                    PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                    
                    StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]], 
                    StyleBox[
                    RowBox[{"(", #4, ")"}], FontWeight -> "Plain", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0.65], 
                    Selectable -> False]}}, 
                  GridBoxItemSize -> {
                   "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                  BaselinePosition -> {1, 2}], False -> GridBox[{{
                    PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                    
                    StyleBox[#, FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]]}}, 
                  GridBoxItemSize -> {
                   "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                  BaselinePosition -> {1, 2}]}, 
               Dynamic[
                CurrentValue[Evaluatable]], ImageSize -> Automatic, 
               BaselinePosition -> Baseline, 
               BaseStyle -> {FontFamily -> "Helvetica"}], #3, 
              BaseStyle -> {
               FontWeight -> "Plain", ShowStringCharacters -> False, 
                LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityClassFramelessHot"], ShowStringCharacters -> False,
           TemplateBoxOptions -> {
           DisplayFunction -> (PaneSelectorBox[{True -> GridBox[{{
                   PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                   
                   StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0]], 
                   StyleBox[
                    RowBox[{"(", #4, ")"}], FontWeight -> "Plain", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0], Selectable -> 
                    False]}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                 BaselinePosition -> {1, 2}], False -> GridBox[{{
                   PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                   StyleBox[#, FontColor -> GrayLevel[0]]}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                 BaselinePosition -> {1, 2}]}, 
              Dynamic[
               CurrentValue[Evaluatable]], ImageSize -> Automatic, 
              BaselinePosition -> Baseline, 
              BaseStyle -> {
               FontWeight -> "Plain", FontFamily -> "Helvetica", 
                ShowStringCharacters -> False, LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityProperty"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              FrameBox[
               
               PaneBox[#, 
                BaseStyle -> {
                 FontSlant -> Italic, FontWeight -> Plain, FontFamily -> 
                  "Source Sans Pro", FontColor -> 
                  RGBColor[0.395437, 0.20595, 0.061158]}, BaselinePosition -> 
                Baseline], FrameStyle -> 
               RGBColor[0.94227, 0.703639, 0.033387], Background -> 
               RGBColor[1., 0.980392, 0.921569], 
               FrameMargins -> {{5, 5}, {1.5, 1.5}}, 
               ImageMargins -> {{2, 2}, {2, 2}}, BaselinePosition -> Baseline,
                RoundingRadius -> 4], #3, 
              BaseStyle -> {
               FontWeight -> "Plain", ShowStringCharacters -> False, 
                LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityPropertyClass"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              FrameBox[
               PaneBox[
                GridBox[{{
                   PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], #}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                 BaselinePosition -> {1, 2}], 
                BaseStyle -> {
                 FontSlant -> Italic, FontWeight -> Plain, FontFamily -> 
                  "Source Sans Pro", FontColor -> 
                  RGBColor[0.395437, 0.20595, 0.061158]}, BaselinePosition -> 
                Baseline], FrameStyle -> 
               RGBColor[0.94227, 0.703639, 0.033387], Background -> 
               RGBColor[1., 0.980392, 0.921569], 
               FrameMargins -> {{5, 5}, {1.5, 1.5}}, 
               ImageMargins -> {{2, 2}, {2, 2}}, BaselinePosition -> Baseline,
                RoundingRadius -> 4], #3, 
              BaseStyle -> {
               FontWeight -> "Plain", ShowStringCharacters -> False, 
                LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityValue"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              
              GridBox[{{#, #2}}, GridBoxAlignment -> {"Rows" -> {{Baseline}}},
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}}, 
               GridBoxSpacings -> {"Columns" -> {{0}}}, 
               BaselinePosition -> {1, 1}], Background -> 
              RGBColor[{0.9921568627450981, 0.9529411764705882, 
                0.8509803921568627}], BaselinePosition -> Baseline, 
              FrameMargins -> {{1, 1}, {1, 1}}, ImageMargins -> 2, FrameStyle -> 
              RGBColor[{0.9333333333333333, 0.8470588235294118, 
                0.5529411764705883}], RoundingRadius -> 5]& )}]}, Closed]]}, 
     Closed]]}, Visible -> False, FrontEndVersion -> 
  "12.3 for Mac OS X x86 (64-bit) (July 30, 2021)", StyleDefinitions -> 
  "StylesheetFormatting.nb"],
ExpressionUUID->"1079ef9f-937d-47c2-8d5d-41bba56e53f7"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "p:193"->{
  Cell[651, 23, 435, 11, 93, "SectionDoubleDigit",ExpressionUUID->"671f896c-c863-4801-81d7-6a48af0d6b9c",
   CounterAssignments->{{"Section", 31}, {"Subsection", 0}, {"Subsubsection", 0}, {"Exercise", 0}},
   CellTags->"p:193"]},
 "i:1"->{
  Cell[1089, 36, 521, 15, 66, "Text",ExpressionUUID->"eececbce-3bd7-4418-928a-b39828205f24",
   CellTags->"i:1"]},
 "i:2"->{
  Cell[1613, 53, 252, 8, 40, "Text",ExpressionUUID->"cb58f350-215e-482a-b980-b112a797a806",
   CellTags->"i:2"]},
 "i:3"->{
  Cell[6086, 218, 446, 12, 65, "Text",ExpressionUUID->"0cb1a94a-aa14-41f6-a5f6-4087000a3848",
   CellTags->"i:3"]},
 "i:4"->{
  Cell[11140, 401, 324, 12, 70, "CodeCaption",ExpressionUUID->"a92eda7d-7986-4003-a373-8b3e1143778d",
   CellTags->"i:4"]},
 "LastCellOfAPage"->{
  Cell[12233, 442, 345, 11, 70, "Output",ExpressionUUID->"314c49b0-dd8c-4074-87a7-109a8da69387",
   Evaluatable->False,
   CellTags->"LastCellOfAPage"],
  Cell[24147, 864, 6178, 172, 70, "Output",ExpressionUUID->"2618d168-12a4-41d8-bc70-a6b49def0a48",
   Evaluatable->False,
   CellTags->"LastCellOfAPage"],
  Cell[87471, 2694, 411, 11, 70, "Text",ExpressionUUID->"08f86d97-5a99-455b-8c91-cd4e614e9203",
   CellTags->"LastCellOfAPage"],
  Cell[385124, 9557, 298, 6, 70, "Answer",ExpressionUUID->"0551bd74-1576-4501-a5a9-7c99aec00184",
   CellTags->"LastCellOfAPage"],
  Cell[391105, 9768, 331, 8, 70, "MoreExplore",ExpressionUUID->"28a35a43-6ea2-40af-bae6-498375d75684",
   CellTags->"LastCellOfAPage"]},
 "i:5"->{
  Cell[12593, 456, 377, 10, 70, "Text",ExpressionUUID->"f94d36a1-2f2a-4ee7-975f-85a9de4f503c",
   CellTags->"i:5"]},
 "i:6"->{
  Cell[17965, 641, 461, 13, 70, "Text",ExpressionUUID->"6d4c4e41-175f-4ef7-8e1c-9b8c71835e6b",
   CellTags->"i:6"]},
 "i:7"->{
  Cell[23093, 824, 479, 13, 70, "Text",ExpressionUUID->"e4432c45-477b-4ee1-9237-0d20b6961305",
   CellTags->"i:7"]},
 "p:194"->{
  Cell[30340, 1039, 229, 6, 70, "CodeCaption",ExpressionUUID->"fd914f9f-396d-477f-af82-bf03a9b1fb0b",
   CellTags->"p:194"]},
 "i:8"->{
  Cell[46887, 1560, 570, 16, 70, "Text",ExpressionUUID->"156aca3d-75f7-43ed-af4f-5b5ae85dfb89",
   CellTags->"i:8"]},
 "i:9"->{
  Cell[83493, 2551, 1078, 37, 70, "Text",ExpressionUUID->"fe8e60f5-1608-4b5b-8824-4931bce2b2db",
   CellTags->"i:9"]},
 "p:195"->{
  Cell[87919, 2710, 176, 4, 70, "VocabularySection",ExpressionUUID->"19914aa2-4210-4f81-9c5a-79794324d117",
   CellTags->"p:195"]},
 "i:10"->{
  Cell[384857, 9545, 264, 10, 70, "Question",ExpressionUUID->"92530b27-0f9f-4c4b-8643-4cb09a6067b3",
   CellTags->"i:10"]},
 "i:11"->{
  Cell[385767, 9579, 478, 16, 70, "Answer",ExpressionUUID->"eeb23720-a325-4862-a2b0-8f9f309add1f",
   CellTags->"i:11"]},
 "p:196"->{
  Cell[387109, 9629, 174, 4, 70, "TechNoteSection",ExpressionUUID->"f2215435-539b-4806-9ace-b1948bc5990c",
   CellTags->"p:196"]},
 "i:12"->{
  Cell[388967, 9698, 851, 24, 70, "TechNote",ExpressionUUID->"3ead5acb-d079-4400-a9c5-08d883e59c25",
   CellTags->"i:12"]},
 "i:13"->{
  Cell[389821, 9724, 527, 15, 70, "TechNote",ExpressionUUID->"58d203a8-0b27-440d-a282-66add19b92a5",
   CellTags->"i:13"]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"p:193", 482152, 11614},
 {"i:1", 482392, 11618},
 {"i:2", 482517, 11621},
 {"i:3", 482641, 11624},
 {"i:4", 482767, 11627},
 {"LastCellOfAPage", 482913, 11630},
 {"i:5", 483628, 11643},
 {"i:6", 483755, 11646},
 {"i:7", 483882, 11649},
 {"p:194", 484011, 11652},
 {"i:8", 484147, 11655},
 {"i:9", 484275, 11658},
 {"p:195", 484406, 11661},
 {"i:10", 484549, 11664},
 {"i:11", 484684, 11667},
 {"p:196", 484818, 11670},
 {"i:12", 484960, 11673},
 {"i:13", 485095, 11676}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[651, 23, 435, 11, 93, "SectionDoubleDigit",ExpressionUUID->"671f896c-c863-4801-81d7-6a48af0d6b9c",
 CounterAssignments->{{"Section", 31}, {"Subsection", 0}, {"Subsubsection", 0}, {"Exercise", 0}},
 CellTags->"p:193"],
Cell[1089, 36, 521, 15, 66, "Text",ExpressionUUID->"eececbce-3bd7-4418-928a-b39828205f24",
 CellTags->"i:1"],
Cell[1613, 53, 252, 8, 40, "Text",ExpressionUUID->"cb58f350-215e-482a-b980-b112a797a806",
 CellTags->"i:2"],
Cell[1868, 63, 618, 21, 39, "CodeCaption",ExpressionUUID->"0145feda-f188-450d-95b0-4d64e3db6543"],
Cell[CellGroupData[{
Cell[2511, 88, 297, 8, 29, "Input",ExpressionUUID->"07d0cece-e533-4e20-8cef-0c8fe310efad"],
Cell[2811, 98, 175, 4, 40, "Output",ExpressionUUID->"81d8cc93-a166-4b91-9412-0acd6ad64695",
 Evaluatable->False]
}, Open  ]],
Cell[3001, 105, 579, 16, 37, "CodeCaption",ExpressionUUID->"498eb548-c7cd-47d4-bde4-c7788c0c0795"],
Cell[CellGroupData[{
Cell[3605, 125, 297, 8, 29, "Input",ExpressionUUID->"b9f912d2-6586-4f27-b1f4-33db425de9e8"],
Cell[3905, 135, 176, 4, 40, "Output",ExpressionUUID->"cec05704-be97-4bc3-8f2a-54ab850e4b78",
 Evaluatable->False]
}, Open  ]],
Cell[4096, 142, 483, 17, 39, "CodeCaption",ExpressionUUID->"e14e2cb5-b73b-4890-aad9-dfa7e57ca7bd"],
Cell[CellGroupData[{
Cell[4604, 163, 277, 8, 29, "Input",ExpressionUUID->"d83cc40d-e3fc-4343-81ff-e86e24469bec"],
Cell[4884, 173, 175, 4, 40, "Output",ExpressionUUID->"5e72cda6-18a3-4477-a04f-44d0c5e5baee",
 Evaluatable->False]
}, Open  ]],
Cell[5074, 180, 506, 17, 39, "CodeCaption",ExpressionUUID->"78e85923-aa9a-4160-97ae-43fe0a9c2bc1"],
Cell[CellGroupData[{
Cell[5605, 201, 287, 8, 29, "Input",ExpressionUUID->"9ca20112-c7c1-424e-9d60-96dfb594297c"],
Cell[5895, 211, 176, 4, 40, "Output",ExpressionUUID->"b80cfffa-2c53-4992-b505-819a144b48b7",
 Evaluatable->False]
}, Open  ]],
Cell[6086, 218, 446, 12, 65, "Text",ExpressionUUID->"0cb1a94a-aa14-41f6-a5f6-4087000a3848",
 CellTags->"i:3"],
Cell[6535, 232, 477, 17, 39, "CodeCaption",ExpressionUUID->"2efe5c09-83b8-4625-8d6f-48600a24e3dd"],
Cell[CellGroupData[{
Cell[7037, 253, 654, 20, 29, "Input",ExpressionUUID->"e64374bf-97a6-4062-bd14-25c5ea9baf75"],
Cell[7694, 275, 433, 14, 40, "Output",ExpressionUUID->"f5b802a4-67fd-410f-955c-c7a11fc381b1",
 Evaluatable->False]
}, Open  ]],
Cell[8142, 292, 535, 17, 70, "CodeCaption",ExpressionUUID->"26744443-e2da-4094-b630-dcd66221a389"],
Cell[CellGroupData[{
Cell[8702, 313, 654, 20, 70, "Input",ExpressionUUID->"316a63c1-bc7a-4914-902c-91520745a5ff"],
Cell[9359, 335, 315, 10, 70, "Output",ExpressionUUID->"46f93da9-c292-499c-936f-3271c0ac3798",
 Evaluatable->False]
}, Open  ]],
Cell[9689, 348, 432, 14, 70, "CodeCaption",ExpressionUUID->"4bedc9ee-cb03-4e5b-a61d-58acbb325a7c"],
Cell[CellGroupData[{
Cell[10146, 366, 690, 22, 70, "Input",ExpressionUUID->"aa06765e-0d58-4403-a8b5-251e5a292f78"],
Cell[10839, 390, 286, 8, 70, "Output",ExpressionUUID->"2dc899ac-a2ea-47b7-9847-725f29a29731",
 Evaluatable->False]
}, Open  ]],
Cell[11140, 401, 324, 12, 70, "CodeCaption",ExpressionUUID->"a92eda7d-7986-4003-a373-8b3e1143778d",
 CellTags->"i:4"],
Cell[CellGroupData[{
Cell[11489, 417, 741, 23, 70, "Input",ExpressionUUID->"db4dc834-673d-478d-997b-a97ebd428d04"],
Cell[12233, 442, 345, 11, 70, "Output",ExpressionUUID->"314c49b0-dd8c-4074-87a7-109a8da69387",
 Evaluatable->False,
 CellTags->"LastCellOfAPage"]
}, Open  ]],
Cell[12593, 456, 377, 10, 70, "Text",ExpressionUUID->"f94d36a1-2f2a-4ee7-975f-85a9de4f503c",
 CellTags->"i:5"],
Cell[12973, 468, 405, 12, 70, "CodeCaption",ExpressionUUID->"2097a7b4-ab1d-4f94-bc4e-51440354d521"],
Cell[CellGroupData[{
Cell[13403, 484, 680, 21, 70, "Input",ExpressionUUID->"b0cbb6af-b88c-44af-b764-1b1e218fb262"],
Cell[14086, 507, 374, 12, 70, "Output",ExpressionUUID->"e1beb00d-d463-4443-988e-08d5dbc2b061",
 Evaluatable->False]
}, Open  ]],
Cell[14475, 522, 278, 7, 70, "Text",ExpressionUUID->"40959899-eb85-4ae5-93ea-b76d65cb2313"],
Cell[14756, 531, 203, 5, 70, "CodeCaption",ExpressionUUID->"2f4c62ed-4bf6-4e70-b2c9-443e00d1d2c6"],
Cell[CellGroupData[{
Cell[14984, 540, 235, 5, 70, "Input",ExpressionUUID->"013b2dfa-fb8c-4586-94f8-8d559e5b22e4"],
Cell[15222, 547, 750, 22, 70, "Output",ExpressionUUID->"cc28f602-bf08-4e87-a490-d40640132326",
 Evaluatable->False]
}, Open  ]],
Cell[15987, 572, 168, 4, 70, "CodeCaption",ExpressionUUID->"a4004b8b-8e79-4376-b7f1-49e62ab11b28"],
Cell[CellGroupData[{
Cell[16180, 580, 354, 9, 70, "Input",ExpressionUUID->"2e85fa0b-5bb4-4c26-9cf6-c11e567f7c9d"],
Cell[16537, 591, 474, 14, 70, "Output",ExpressionUUID->"46d9d134-e2d5-4e34-ae0d-2300f2d97b24",
 Evaluatable->False]
}, Open  ]],
Cell[17026, 608, 180, 4, 70, "CodeCaption",ExpressionUUID->"3477d5d8-4456-4631-99aa-696d6df148b5"],
Cell[CellGroupData[{
Cell[17231, 616, 380, 10, 70, "Input",ExpressionUUID->"a6a7994e-db3c-43d5-a2d2-d035ed5e064f"],
Cell[17614, 628, 336, 10, 70, "Output",ExpressionUUID->"60d6870e-2871-4110-b424-96ce8fd8b1ce",
 Evaluatable->False]
}, Open  ]],
Cell[17965, 641, 461, 13, 70, "Text",ExpressionUUID->"6d4c4e41-175f-4ef7-8e1c-9b8c71835e6b",
 CellTags->"i:6"],
Cell[18429, 656, 307, 9, 70, "CodeCaption",ExpressionUUID->"b3c48959-914c-414b-8df4-7b13c1bb274f"],
Cell[CellGroupData[{
Cell[18761, 669, 656, 20, 70, "Input",ExpressionUUID->"66d9e17a-fadb-4946-9612-de266047bb66"],
Cell[19420, 691, 326, 10, 70, "Output",ExpressionUUID->"2d86d981-68a7-45c3-a443-1697250b54e8",
 Evaluatable->False]
}, Open  ]],
Cell[19761, 704, 501, 15, 70, "CodeCaption",ExpressionUUID->"bc2fdcf2-acb7-4a81-bbdc-209d2a5fde3a"],
Cell[CellGroupData[{
Cell[20287, 723, 761, 24, 70, "Input",ExpressionUUID->"c00d2bdb-90fd-4f62-a0c9-2446ee7f66eb"],
Cell[21051, 749, 503, 16, 70, "Output",ExpressionUUID->"c6ef3a8a-024d-4aae-b698-0d77b8815fd6",
 Evaluatable->False]
}, Open  ]],
Cell[21569, 768, 222, 6, 70, "Text",ExpressionUUID->"0a53a32a-6111-4550-b62b-70a6d96ccad4"],
Cell[21794, 776, 452, 16, 70, "CodeCaption",ExpressionUUID->"9edbffb7-7331-40dd-87ea-fdf0db85bb17"],
Cell[CellGroupData[{
Cell[22271, 796, 528, 15, 70, "Input",ExpressionUUID->"19caebde-9e3d-45a0-aaa3-7abc7c3b8be1"],
Cell[22802, 813, 276, 8, 70, "Output",ExpressionUUID->"e02ead1d-fc61-438b-b4e5-2327ae8c33d6",
 Evaluatable->False]
}, Open  ]],
Cell[23093, 824, 479, 13, 70, "Text",ExpressionUUID->"e4432c45-477b-4ee1-9237-0d20b6961305",
 CellTags->"i:7"],
Cell[23575, 839, 239, 11, 70, "CodeCaption",ExpressionUUID->"ec9d9071-e1d7-49a3-b79a-82676b393dcf"],
Cell[CellGroupData[{
Cell[23839, 854, 305, 8, 70, "Input",ExpressionUUID->"28cdfb17-7ba0-4e1b-bfbe-45056ffaffeb"],
Cell[24147, 864, 6178, 172, 70, "Output",ExpressionUUID->"2618d168-12a4-41d8-bc70-a6b49def0a48",
 Evaluatable->False,
 CellTags->"LastCellOfAPage"]
}, Open  ]],
Cell[30340, 1039, 229, 6, 70, "CodeCaption",ExpressionUUID->"fd914f9f-396d-477f-af82-bf03a9b1fb0b",
 CellTags->"p:194"],
Cell[CellGroupData[{
Cell[30594, 1049, 580, 18, 70, "Input",ExpressionUUID->"3ec0849e-2181-490e-bc0a-39a8b99a6885"],
Cell[31177, 1069, 3323, 94, 70, "Output",ExpressionUUID->"3001d04e-5cdb-4ecc-9e2d-d0e9c745db32",
 Evaluatable->False]
}, Open  ]],
Cell[34515, 1166, 186, 4, 70, "CodeCaption",ExpressionUUID->"fa174c01-ebe6-421e-bed2-b68267c3d241"],
Cell[CellGroupData[{
Cell[34726, 1174, 786, 25, 70, "Input",ExpressionUUID->"132a7953-8a34-48f2-8174-a83c9308c28d"],
Cell[35515, 1201, 6155, 172, 70, "Output",ExpressionUUID->"86d6057d-c5f6-4174-9459-89841a79d6a5",
 Evaluatable->False]
}, Open  ]],
Cell[41685, 1376, 1250, 40, 70, "Text",ExpressionUUID->"52581c75-554c-4b0e-98ff-493e91bbe951"],
Cell[42938, 1418, 654, 24, 70, "CodeCaption",ExpressionUUID->"9cc4f931-16ff-4883-8e9f-f4a7856afbb5"],
Cell[CellGroupData[{
Cell[43617, 1446, 812, 24, 70, "Input",ExpressionUUID->"6170cc3b-394b-48a3-9c15-804f10c77e83"],
Cell[44432, 1472, 547, 17, 70, "Output",ExpressionUUID->"c27c85a0-07a6-48c6-8999-1baba8098e63",
 Evaluatable->False]
}, Open  ]],
Cell[44994, 1492, 666, 24, 70, "CodeCaption",ExpressionUUID->"ad78153e-50ca-4a9d-aca0-32404ba03fb4"],
Cell[CellGroupData[{
Cell[45685, 1520, 814, 24, 70, "Input",ExpressionUUID->"d99d013a-3628-4b6e-b985-de96037c6b23"],
Cell[46502, 1546, 370, 11, 70, "Output",ExpressionUUID->"681610f4-82e6-45be-b790-ce8c68f8fcd5",
 Evaluatable->False]
}, Open  ]],
Cell[46887, 1560, 570, 16, 70, "Text",ExpressionUUID->"156aca3d-75f7-43ed-af4f-5b5ae85dfb89",
 CellTags->"i:8"],
Cell[47460, 1578, 443, 16, 70, "CodeCaption",ExpressionUUID->"6f8cceff-7859-4c13-a769-461f792f370e"],
Cell[CellGroupData[{
Cell[47928, 1598, 11848, 316, 70, "Input",ExpressionUUID->"2c5267b1-c367-4671-8c38-cc17213b644e"],
Cell[59779, 1916, 23699, 632, 70, "Output",ExpressionUUID->"bbbd7fbd-9ca2-4200-9a52-467778ecf1ed",
 Evaluatable->False]
}, Open  ]],
Cell[83493, 2551, 1078, 37, 70, "Text",ExpressionUUID->"fe8e60f5-1608-4b5b-8824-4931bce2b2db",
 CellTags->"i:9"],
Cell[84574, 2590, 500, 16, 70, "CodeCaption",ExpressionUUID->"f73d5c08-b44e-4d7f-8e1c-db058c1f4f3b"],
Cell[CellGroupData[{
Cell[85099, 2610, 459, 13, 70, "Input",ExpressionUUID->"3d07e872-7fbb-4cd7-9881-944cbd2ecb6a"],
Cell[85561, 2625, 309, 8, 70, "Output",ExpressionUUID->"86dd69e2-81af-4d03-8643-e07aa52fad12",
 Evaluatable->False]
}, Open  ]],
Cell[85885, 2636, 233, 9, 70, "Text",ExpressionUUID->"c8119a50-0e7f-4cfc-9057-cd63963526fa"],
Cell[86121, 2647, 576, 18, 70, "CodeCaption",ExpressionUUID->"5b876611-ee47-41dc-9b3e-ea60f21cb634"],
Cell[CellGroupData[{
Cell[86722, 2669, 500, 14, 70, "Input",ExpressionUUID->"9eb9c44a-6c1a-44ff-a46b-86aa646ea263"],
Cell[87225, 2685, 231, 6, 70, "Output",ExpressionUUID->"192caa56-4f5b-4318-877a-329f57da97c5",
 Evaluatable->False]
}, Open  ]],
Cell[87471, 2694, 411, 11, 70, "Text",ExpressionUUID->"08f86d97-5a99-455b-8c91-cd4e614e9203",
 CellTags->"LastCellOfAPage"]
}, Open  ]],
Cell[CellGroupData[{
Cell[87919, 2710, 176, 4, 70, "VocabularySection",ExpressionUUID->"19914aa2-4210-4f81-9c5a-79794324d117",
 CellTags->"p:195"],
Cell[88098, 2716, 4365, 121, 70, "VocabularyTable",ExpressionUUID->"c5940f75-97d1-4081-84f4-f69826240459"]
}, Open  ]],
Cell[CellGroupData[{
Cell[92500, 2842, 1780, 46, 70, "ExerciseSection",ExpressionUUID->"4d0098b6-6b7c-470a-83dd-ded0749ad97a"],
Cell[CellGroupData[{
Cell[94305, 2892, 1238, 38, 70, "ExerciseSummaryCell",ExpressionUUID->"a10b3f8c-88fe-4462-acd4-353cb051224c"],
Cell[CellGroupData[{
Cell[95568, 2934, 995, 29, 70, "Exercise",ExpressionUUID->"f532ec56-e9e7-45ca-a80f-5b76ac53344f"],
Cell[96566, 2965, 2864, 76, 70, "ExerciseOutput",ExpressionUUID->"ad88cbf2-ab9e-4a6b-9f38-88907651e7d3"]
}, Closed]],
Cell[CellGroupData[{
Cell[99467, 3046, 968, 29, 70, "Exercise",ExpressionUUID->"615f68ce-2d56-40b4-86ad-6d6d2be355e8"],
Cell[100438, 3077, 2693, 72, 70, "ExerciseOutput",ExpressionUUID->"82c064cf-3980-4c07-b5b6-7ecb3f553bb3"]
}, Closed]],
Cell[CellGroupData[{
Cell[103168, 3154, 763, 21, 70, "Exercise",ExpressionUUID->"1637e83c-d3bc-4f00-b436-d8fa5bd832c3"],
Cell[103934, 3177, 7451, 199, 70, "ExerciseOutput",ExpressionUUID->"84f8cba5-99c6-45d3-8151-0131a41dd5d4"]
}, Closed]],
Cell[CellGroupData[{
Cell[111422, 3381, 1092, 35, 70, "Exercise",ExpressionUUID->"afc1b018-117e-48a8-a598-86486b2ee12d"],
Cell[112517, 3418, 134541, 2984, 70, "ExerciseOutput",ExpressionUUID->"1fee8797-3a9a-425e-9e44-4774cc529273"]
}, Closed]],
Cell[CellGroupData[{
Cell[247095, 6407, 771, 23, 70, "Exercise",ExpressionUUID->"009a5330-da98-4c31-86e4-6489dffe6beb"],
Cell[247869, 6432, 109196, 2364, 70, "ExerciseOutput",ExpressionUUID->"dd8e7d72-aab7-4283-820f-f52588518b7f"]
}, Closed]],
Cell[CellGroupData[{
Cell[357102, 8801, 801, 21, 70, "Exercise",ExpressionUUID->"b9f8b097-451b-4729-901f-4913b18c6b99"],
Cell[357906, 8824, 1642, 42, 70, "ExerciseOutput",ExpressionUUID->"050eb235-4a18-4225-96d9-cd393e1005cd"]
}, Closed]],
Cell[CellGroupData[{
Cell[359585, 8871, 1486, 50, 70, "Exercise",ExpressionUUID->"53478c6e-e20c-4627-b462-c65820796e5d"],
Cell[361074, 8923, 2623, 55, 70, "ExerciseOutput",ExpressionUUID->"26813c18-c521-45a4-aafc-c98b07cecc04"]
}, Closed]],
Cell[CellGroupData[{
Cell[363734, 8983, 1551, 52, 70, "Exercise",ExpressionUUID->"10beeb24-1f43-439a-815f-26f04ce4f37f"],
Cell[365288, 9037, 16544, 396, 70, "ExerciseOutput",ExpressionUUID->"bb90b2ff-b1e3-477f-8bc5-dc3af8132727"]
}, Closed]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[381893, 9440, 144, 4, 70, "QASection",ExpressionUUID->"64c3c492-400a-4260-8122-54238838225b"],
Cell[382040, 9446, 384, 13, 70, "Question",ExpressionUUID->"5e8dc654-ff1c-4288-8563-83b3f05f5b15"],
Cell[382427, 9461, 326, 8, 70, "Answer",ExpressionUUID->"9b346ba6-79a5-47ac-bea4-d080e5e16530"],
Cell[382756, 9471, 181, 4, 70, "Question",ExpressionUUID->"658bb29d-bd03-47b5-8467-f398ec492a5b"],
Cell[382940, 9477, 322, 10, 70, "Answer",ExpressionUUID->"5e1ce6fc-de16-41de-9249-aea055576728"],
Cell[383265, 9489, 529, 18, 70, "Question",ExpressionUUID->"ccac8f22-807f-4860-8b35-4a1b49400ed8"],
Cell[383797, 9509, 1057, 34, 70, "Answer",ExpressionUUID->"36e7040e-aa69-4dfe-bee6-a58c406dc99f"],
Cell[384857, 9545, 264, 10, 70, "Question",ExpressionUUID->"92530b27-0f9f-4c4b-8643-4cb09a6067b3",
 CellTags->"i:10"],
Cell[385124, 9557, 298, 6, 70, "Answer",ExpressionUUID->"0551bd74-1576-4501-a5a9-7c99aec00184",
 CellTags->"LastCellOfAPage"],
Cell[385425, 9565, 339, 12, 70, "Question",ExpressionUUID->"d6310627-0627-4b03-ae11-fa316a62fa36"],
Cell[385767, 9579, 478, 16, 70, "Answer",ExpressionUUID->"eeb23720-a325-4862-a2b0-8f9f309add1f",
 CellTags->"i:11"],
Cell[386248, 9597, 371, 12, 70, "Question",ExpressionUUID->"020f4881-cdc1-4615-81ea-c44d6baa37e6"],
Cell[386622, 9611, 450, 13, 70, "Answer",ExpressionUUID->"79e181af-ec8c-4beb-a21b-15869e85e9ef"]
}, Open  ]],
Cell[CellGroupData[{
Cell[387109, 9629, 174, 4, 70, "TechNoteSection",ExpressionUUID->"f2215435-539b-4806-9ace-b1948bc5990c",
 CellTags->"p:196"],
Cell[387286, 9635, 318, 10, 70, "TechNote",ExpressionUUID->"8bfa4783-6c2c-4e0f-abfe-d63185096d56"],
Cell[387607, 9647, 1357, 49, 70, "TechNote",ExpressionUUID->"bd86ea68-de22-4e2e-96be-86c0670c1c36"],
Cell[388967, 9698, 851, 24, 70, "TechNote",ExpressionUUID->"3ead5acb-d079-4400-a9c5-08d883e59c25",
 CellTags->"i:12"],
Cell[389821, 9724, 527, 15, 70, "TechNote",ExpressionUUID->"58d203a8-0b27-440d-a282-66add19b92a5",
 CellTags->"i:13"],
Cell[390351, 9741, 549, 16, 70, "TechNote",ExpressionUUID->"e0b4ba8b-9e0e-42f0-94b1-ed8d987cae0d"]
}, Open  ]],
Cell[CellGroupData[{
Cell[390937, 9762, 165, 4, 70, "MoreExploreSection",ExpressionUUID->"34a7b5a9-35b3-4522-a697-fdc2e44b5afd"],
Cell[391105, 9768, 331, 8, 70, "MoreExplore",ExpressionUUID->"28a35a43-6ea2-40af-bae6-498375d75684",
 CellTags->"LastCellOfAPage"]
}, Open  ]]
}
]
*)

(* NotebookSignature gIzcIbLbFPYZMK56GJ3KwTnn *)
