(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    601143,      11990]
NotebookOptionsPosition[    522709,      10325]
NotebookOutlinePosition[    583501,      11575]
CellTagsIndexPosition[    583421,      11570]
WindowTitle->Tests and Conditionals: Elementary Introduction to the Wolfram \
Language
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell["Test whether 123^321 is greater than 456^123.", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "28.1", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 28}, {"ExerciseNumber", 1}, {
   "WebOnly", 0}},ExpressionUUID->"65244b70-4069-4b74-bdf9-2773d9382d4b"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"a0ccdaa3-fe6a-4e8e-aa51-4cd048b9e653"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztky1vwzAQhq2NDE4aHNofCB41HLLUacyk1epqpKvaSVNoWKGZmVFQUVBQ
SVGISUhIQUgGCgJMDAy6c7qkn1q3lvaVHN35zo/t8+Wh895iVwih0Q18Wu1P
PBy2/edbcF76o7dev/v61P/o9rrDx841TN7BuIfh7OVFZ0tFkgsn6eQMzoVa
2JOBUUAxoQSjlQilGJPJ3Jx7UJsSoIl0P2L0Ubg9kKMVADFXzUQWDhiPQt+D
Y4/VV+RjJn+2yyPfY6Gu7CIJyepueDArNrBmF5iKKpHx6SzJtRYe8uqo4hgc
AJpMQgrl8TzP5ADMoDgC9PP6AgKvoyk4ntBLM2EIyACxdmmKCJxE/wJcrdoA
1hWuQzqkaFtU/RkoIcwiu31CByTy8JvtPUq1ijcburohGmdFNhXVE7i9ymTs
yiymRVnmKhZhsm5fk0I9qEw3gARh2QD1PCJ1q3LOVkCXNgmaC+Mg/l/7Wr1Y
lAeWWFOWpTan/1wX7egbSAMxdg==
            "], {{0, 19}, {27, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{27, 19},
          PlotRange->{{0, 27}, {0, 19}}]], "ExerciseOutput",
         ImageSize->{31, 19},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "c75f3e55-13f3-4c70-8dce-07bba0c6e99c"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztky1vwzAQhq2NDE4aHNofCB41HLLUacyk1epqpKvaSVNoWKGZmVFQUVBQ
SVGISUhIQUgGCgJMDAy6c7qkn1q3lvaVHN35zo/t8+Wh895iVwih0Q18Wu1P
PBy2/edbcF76o7dev/v61P/o9rrDx841TN7BuIfh7OVFZ0tFkgsn6eQMzoVa
2JOBUUAxoQSjlQilGJPJ3Jx7UJsSoIl0P2L0Ubg9kKMVADFXzUQWDhiPQt+D
Y4/VV+RjJn+2yyPfY6Gu7CIJyepueDArNrBmF5iKKpHx6SzJtRYe8uqo4hgc
AJpMQgrl8TzP5ADMoDgC9PP6AgKvoyk4ntBLM2EIyACxdmmKCJxE/wJcrdoA
1hWuQzqkaFtU/RkoIcwiu31CByTy8JvtPUq1ijcburohGmdFNhXVE7i9ymTs
yiymRVnmKhZhsm5fk0I9qEw3gARh2QD1PCJ1q3LOVkCXNgmaC+Mg/l/7Wr1Y
lAeWWFOWpTan/1wX7egbSAMxdg==
              "], {{0, 19}, {27, 0}}, {0, 255}, 
              ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {27, 19}, 
            PlotRange -> {{0, 27}, {0, 19}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"250e1ff0-3730-459d-8774-06ca87d2951e"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["28.1"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"b343dcac-dcb6-4efa-87c2-c087110c5960"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"16137cfb-32b2-47a1-94c5-dadb73d1a79a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"619097d8-19b5-4369-a28a-87c46878e597"],

Cell["\<\
Get a list of numbers up to 100 whose digits add up to less than 5.\
\>", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "28.2", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 28}, {"ExerciseNumber", 2}, {
   "WebOnly", 0}},ExpressionUUID->"444bedab-c87f-4bef-b84d-5127a462b453"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"1fdab0ad-5ec8-4f09-8bcf-5faeb39b4bb9"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztWq+vrEYUpq2pbFJV2X8AXYus2uQ1dWveSy8vNbeb+5o0a3FIHA6FQqFQ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            "], {{0, 
            19}, {281, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{281, 19},
          PlotRange->{{0, 281}, {0, 19}}]], "ExerciseOutput",
         ImageSize->{285, 19},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "f273c90c-91f1-4285-8755-548a6101cff8"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztWq+vrEYUpq2pbFJV2X8AXYus2uQ1dWveSy8vNbeb+5o0a3FIHA6FQqFQ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              "], {{0, 
              19}, {281, 0}}, {0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {281, 19}, 
            PlotRange -> {{0, 281}, {0, 19}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"c43bdeba-1f55-4a03-a9e3-9bfa9c61ef7c"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["28.2"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"827b625d-9660-4c7d-b909-087e7b184926"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"1200dacb-fa01-470f-9b33-7ea9757463f7"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"18ca1bbf-19ee-4e0e-879c-7312fc35fbca"],

Cell["\<\
Make a list of the first 20 integers, with prime numbers styled red.\
\>", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "28.3", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 28}, {"ExerciseNumber", 3}, {
   "WebOnly", 0}},ExpressionUUID->"09f7fda9-62c1-41b5-8c22-1addfbbfdb0a"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"1c4086f1-20e9-4857-a2a0-efaf7c66c7e2"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztWq2vrUgSZ2fNyk3mL9h/AL0WuYpkJuMwb7KPyZi35M0mGywOicOhUCgU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            "], {{0, 19}, {339, 
            0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{339, 19},
          PlotRange->{{0, 339}, {0, 19}}]], "ExerciseOutput",
         ImageSize->{343, 19},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "d7713c42-9dd7-4c6d-977b-a503c39e666a"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztWq2vrUgSZ2fNyk3mL9h/AL0WuYpkJuMwb7KPyZi35M0mGywOicOhUCgU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              "], {{0, 19}, {339, 
              0}}, {0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {339, 19}, 
            PlotRange -> {{0, 339}, {0, 19}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"b6841aac-e8bb-468a-a42e-430732893dca"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["28.3"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"55b5039e-98d5-448d-a4f7-e2e2d2e7bc8e"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"53188117-3b65-40df-a46d-c9f49c596f9b"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"81e483f5-fcea-47c0-a459-29b83489b61a"],

Cell[TextData[{
 "Find words in ",
 Cell[BoxData[
  RowBox[{
   StyleBox["WordList",
    FontFamily->"Source Sans Pro"], "[", " ", "]"}]], "InlineCode",
  ExpressionUUID->"9b09e01b-a2e4-4046-916b-07334c8e3983"],
 " that both begin and end with the letter \[OpenCurlyDoubleQuote]p\
\[CloseCurlyDoubleQuote]."
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "28.4", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 TaggingRules->{"MultipleSolutions" -> "True"},
 CounterAssignments->{{"SectionNumber", 28}, {"ExerciseNumber", 4}, {
   "WebOnly", 0}},ExpressionUUID->"2a6b1147-7880-4605-a6d7-7743dee62170"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{
    "SAMPLE", " ", "EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"adc62553-fa0d-4f55-a4a8-d143b899610f"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztXb3LtM56NkmTMv9C/gHrlLFMJZyQbptzyPGQ5kTOCYRtJc2W29lZCQGr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            "], {{0, 64}, {492, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{492, 64},
          PlotRange->{{0, 492}, {0, 64}}]], "ExerciseOutput",
         ImageSize->{496, 64},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "f63c3323-e16a-4c27-be27-30328e8ad140"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztXb3LtM56NkmTMv9C/gHrlLFMJZyQbptzyPGQ5kTOCYRtJc2W29lZCQGr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              "], {{0, 64}, {492, 0}}, {0, 
              255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {492, 64}, 
            PlotRange -> {{0, 492}, {0, 64}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"36e9b92d-6a5b-42d0-8ed3-34311111d389"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["28.4"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"630b33f2-0c2e-4618-b13f-944f74b05d84"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"a79dc755-fb8e-4906-b4d4-17f4b73d03cc"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"fc14d09d-a0ca-4b52-9050-a542b1fbfbb7"],

Cell["\<\
Make a list of the first 100 primes, keeping only ones whose last digit is \
less than 3.\
\>", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "28.5", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 28}, {"ExerciseNumber", 5}, {
   "WebOnly", 0}},ExpressionUUID->"d95f340d-603c-4897-81c4-eb3b577265cc"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"85a2ad68-757b-4ddc-b9d2-5d9887b72d99"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztXa+v7LgVTltS2H+htCC4NLAo0lZlQ3bVN6uS19FupWpoyCowLCwoJSEN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            "], {{0, 42}, {335, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{335, 42},
          PlotRange->{{0, 335}, {0, 42}}]], "ExerciseOutput",
         ImageSize->{339, 42},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "f988480a-2186-48d6-8969-c1b93b278c5c"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztXa+v7LgVTltS2H+htCC4NLAo0lZlQ3bVN6uS19FupWpoyCowLCwoJSEN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              "], {{0, 42}, {335, 0}}, {0, 255}, 
              ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {335, 42}, 
            PlotRange -> {{0, 335}, {0, 42}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"cf065fb1-e2e7-482f-8fed-ad8ff68f11ae"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["28.5"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"22b4c457-1f66-4cd3-ad89-9ceba8dba3fe"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"22c5e8b9-4f18-42fc-b6ad-c649723eed87"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"297f3a4c-bd04-432e-90ae-76759f75bb81"],

Cell["Find Roman numerals up to 100 that do not contain \
\[OpenCurlyDoubleQuote]I\[CloseCurlyDoubleQuote].", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "28.6", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 28}, {"ExerciseNumber", 6}, {
   "WebOnly", 0}},ExpressionUUID->"5beab3aa-be0d-4df7-8f28-56e718c109c4"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"25e9d69c-d840-4b82-8312-ca1054f091af"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztW73L5EQYH7WxFPwL7CW1bUqrhRMb2ebuvBwWnst7gqRNo0FBAhbhUHJN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            "], {{0, 19}, {486, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{486, 19},
          PlotRange->{{0, 486}, {0, 19}}]], "ExerciseOutput",
         ImageSize->{490, 19},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "aac6901f-1a22-46c0-a3d7-46528cd6fe5a"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztW73L5EQYH7WxFPwL7CW1bUqrhRMb2ebuvBwWnst7gqRNo0FBAhbhUHJN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              "], {{0, 19}, {486, 0}}, {0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {486, 19}, 
            PlotRange -> {{0, 486}, {0, 19}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"d35b53d0-8272-476d-b606-515bab0c50e7"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["28.6"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"d5a289bb-599f-4f98-9c1e-e4f526183992"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"c6a1b460-f394-4170-92b1-1b8bc940a933"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"19e98e2e-0501-4526-ae38-23a4056b8105"],

Cell["\<\
Get a list of Roman numerals up to 1000 that are palindromes.\
\>", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "28.7", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 28}, {"ExerciseNumber", 7}, {
   "WebOnly", 0}},ExpressionUUID->"5ee0bfc7-ca1f-486a-86f3-bb516fbebc3a"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"46277854-f4a4-4b5c-b532-cc969460684c"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztWqHPpEYUp62pbFJR3X8AXYusIrmmpsHctR+Xmiu5a9JgcaQKNw6FQjQo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            "], {{0, 19}, {279, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{279, 19},
          PlotRange->{{0, 279}, {0, 19}}]], "ExerciseOutput",
         ImageSize->{283, 19},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "ebe8f53f-f972-46e9-8f51-be8d46020457"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztWqHPpEYUp62pbFJR3X8AXYusIrmmpsHctR+Xmiu5a9JgcaQKNw6FQjQo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              "], {{0, 19}, {279, 0}}, {0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {279, 19}, 
            PlotRange -> {{0, 279}, {0, 19}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"c60b220f-db57-4627-8adc-34c61c0a8a45"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["28.7"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"5d6e4631-7313-44a2-a4fa-9bc698df4e9e"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"67725e67-b8e7-49a7-8024-089fd19aa075"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"c750df93-8145-44d6-bc7c-bc42d2bca780"],

Cell["\<\
Find names of integers up to 100 that begin and end with the same letter.\
\>", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "28.8", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 28}, {"ExerciseNumber", 8}, {
   "WebOnly", 0}},ExpressionUUID->"89a9da03-480b-4d9c-8e68-215ec55d13ce"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"180cf0c2-02ff-45f3-8123-be4c6c6ebbe3"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztXb/rrMoVN0mTMv9C2hRWKdJaphJeSCeE98j1keZG3gsEWztLOwlcTGMl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            "], {{0, 42}, {308, 
            0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{308, 42},
          PlotRange->{{0, 308}, {0, 42}}]], "ExerciseOutput",
         ImageSize->{312, 42},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "251cf29c-efcd-41ca-a78e-c1b514ac4ff1"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztXb/rrMoVN0mTMv9C2hRWKdJaphJeSCeE98j1keZG3gsEWztLOwlcTGMl
r7CyMhAhICQSYiMBAxIwxRYGTDGFxWbOjO76Y3Td/eq67/vmA/eyO3d2zvnM
zJk5M+5+7o+/+O1n6vcFQfj6h/ivzz7/vfTVV5/rv/gRfvPLj1//5suPH379
84+/+/Dlh69+9sUPcOFP8J+ffk8Q4PWZg4ODg4ODg4OD4zuBBjVHu/BtA1rs
srpIk+z0Vht1mcRpzbCz43g9g9cRtl4VVWCqoqiliPmvyFXwwVTL7x/uZrlz
3wzc/i4WGlS/rdnc03CX2Wk9VyExRUEwK4blG4z6FerExFbisZH58XphXsfa
elnUqY07QTX9kk0IRbamGt60E26gKXDnmsndn1sPGB0j3rzZOrEEQUpmJ8Vt
VImrKHo006EYqS0Joj21cJNRvwIZuKmfs+P1yryOtfWyIENmjfZMVLNypRsV
YF3uvUsl3O5oM25YaxqzcIUPeBREK12ssujhoPha3mRkzrOziFkgdtMXCwOG
dF6hCfWbjPoVaGym8PGB/0znsJVX5vV8W8OW2QkFs3zZyW2BUohNWH+a3JAk
y/cNHFQYopacwLPM1UTNQ/MVMMrYlUmZIGlRic4o00Shg0rW6jq0Nfpevq7q
k8J5E0PUntbWwHY019dE0Y5PlA9+rfs5qXayZNEMS4aHuGLuyooVhXZbrPvY
zczTL36L6qdPqqjYSWuzKQxJtKLJGadKTYWyFa0gJy170uWMgApbbftCVmRR
kNwMRxX2RbFMhZZbYT5m5GU3KHsZiU3Rdi2x539/vFDmyqodegb8s/KrHi/3
b64myGbZNR3bikSH+ABee9n6+AdHFiTcT233pa4oqOMc+WpX0J0IdR2oWoFv
9VtmO7k3cnw+ES2Iizqhs1d3o5TMZMmCaUkWqKUKKHNg8LG7ReZAqBllU8U+
zBnF8qMoxuEVmRJMpDAr0kDtPsgonDExRZn4CsSuHUZhUvwbjOkh8ZHEmuxA
P5cBfulmiOFhl8zjYj9J6RKBTzd1mfnktemFUZL/HSaAmpHlgbYcjLKsJodg
low4L2IS116BaljuJHISRB4mJupJecoCC4w50QmdU4eMu+okWWwCYeM0ZsRI
PUcVmP73x6urILth+Kc//6XPCxUezDp64mhy7KPi5kfx2s3WP2FV0gNqJDRg
rlVTu4Lqx2nowkvZphMemhO1QctMJ2eDagtUeYgHTDJJfo4gLoyQ7guNh0mq
sJZeE3t2Bdp1Fp7tTXNGpY/fQJc2qQyzBV1aVt2MVCHc8eSZL5z6wAJyJBy5
bfaSwUjpJaQ0uBSHvJw051OAyWnFjId034noaBFv6VwluZ+c0hCsIrHzJ9S7
kEd1RVEjciIQfDxMQOJk4s60k95JsLbxKm/TzaJQIcm/hg+dpvQYSCdhn9FN
ytTK1P/LeNHYxEsTrT/gda4d6H2vaR0g/XAQr/1sFb4GMwFmY4Y/qPnFlKNX
tD0SGSKsw4jdMtPJ+ZHaACbZoEM6viiBE2J3WdAGyzA2WRVqVxGGUKBKW7mi
LY+ryE49U8j0gYXalq67apO7sKkVBWZkJ6kJjZQQTRpeNtkeDu5Set4O71ga
iG/Zbcis0ANIA1OrzY6xb/8I9HHTg3mFAh1GPMzy2IVty8vReXiPMZiE0mye
MKU85/8wNuXLAXN0d1TFJqxRqIl02DXRcbyK/WyhVIEpcELkrI1DbMoxvJyv
ujBktsx0cn6kNkBTZQbZGAiRXjT1uE9ic1SBXNrTDaUPWpnm9zW8hlWrD2bh
jA8skFGwL6sxXAsrBh5FBa+wsSGKmqG2Wx7bwxux2dUm+bDkuEZ/nl9QXTad
mZYLH4+pKImCKKteXE55jefVldENyuti8xqMI17YNeyZarvQS5ND9DN57Wor
NkV8snbwvFD90c0FsSsE5aUm7kIlReyWmU7ujRwSx/Y4OYmLy75JtviZCmQF
xqMcllVVJIHtxuTukKSsTlSWRdUgSC7wET7Kq6qMPduDRliFMyZwToJ7VzKC
XnDQTNVIyyIvwbuQ3h+RLaCKLboT085kejgbm2TI3CQvCnoPVVn0gqE7uQxQ
w8qMRz8pTqcydW0XL+qjqYKPMUVVnU4nnEnRe79B1tTbIAaMblFejE2LEZtj
XucM4lKgidyRvPazdYY7B3p9Y8WTuCK7KjlClmkInSOa0WzLLCdZY7Qlrve0
xNVeXMiQZNIXkrNQAV7Ty0CCztUmutx0YW5N6ajSpY4Zku1yWjhngnZj12Pn
tt/c9taMnJdpPGoeudOoY8hd5OvZf+phm/K1c7tnF+XtLTHegsk0OME9Ak6V
2Rt4nQfXlFlUo7Lpt5xYV4K0TTxHrl06dGPA6BblOf8vjQ8qsHjh0zRcxtGs
6VheO9kitCFaZ748U+f+xa6kuTR7mG154iSTy4Ygy6m5QeMNIifsQRfQomsV
chAfLTLMwilgf5/mt3C0v/EYdNnDuargUlczg5xYKxbrs0mQ5MHEowgP5xo8
uPBdlukCPvjIldEGlCd+9nmd4VpMcLKFwX8ir31sQdojXuJ0nuPaHh07OcNl
G9DnC5JqF4+O9xNQwo2M4KbPTffxjplGnkvyYe+h51l1Qh7qJXhBQHUZkETC
X3f3vi9lVIS+C88MJfsRA8/k9bitJo0CW4fUYPzkayPsPy1R7JqqajAOHS+D
pi7z8gD/6EM0zQ4ftd30c2m48I3L2x+in9yTcrsgK+bSnrmEZ/J61BZ9IinK
brLXV+KPmpYc2wEv+PWNr9V9K/FMXu+1Dzk4ODg4ODg4ODg4ODg4ODg4ODg4
ODg4ODiehGfLoM3Kyu2Lp9BEaeg5rhfl1X4CaMfJ1u2t08h1IAd4jgzaClm5
ffEcmpnTfoda/eM3C1IPb8FxsnWP6zTu3f7eOpB3onZVSVKMmC3CcweeI4O2
QlZuXzyFJpEg0MgP0JrCBq2axa/VP4TjZOse1Wncu/39dSDvRJMFsEYvfi1/
Fs+XQbtLVq7vHdPVlQppT6dJZDSWflJ9n4crq+0nW3feRKdx7/aZOpDLYAhC
rvZ5nZhk5iwIfczgABm0O2TlVMt3QbaCLINMMbSVCmlHqL1lrtb9JFBL/5fr
ouSkNRTK1lUHz1IkzUevTWRLnUYmdtOB/ObTTdVBvDurXQN2XjPabMoA+idH
Xf84Xf/cISa5KPTB7pNDZNBWy8qRHlKtMIqLiiWGtlIh7SCa9Be7pHJS/beV
L0CZeyGIkx2F/kjttYlsqdPInIe76UD+5183VAfp3HNwh2ahoeq4Istn0HgR
jYiOAfx6jPz+7i4xyYyIXq6PzaNk0FbLyuGXerHg6jqFtJegeZUWOcHdDBlo
IqgixdVaqbfDiGyr0zjFfjqQN1UHSWzqbly1+xu7TXKnR26lUEquEIoFhUmm
mGSTwyph+tnK+6CjZNCqO2Xl5lxdqZD2EjR7vHIYfhWvObDakmnz6kS21Wmc
Yj8dyFuqg9W5STyDZsGy7p3m2jyFAjnD1tCaTK3cKSaJbGImWrd3HiWDdq+s
3JyrKxXSDqY5iU0qjWsFkFVSCY5XJ7KtTuMU++lAkl5ZUB3s0OSRK0Ee8tcZ
nxHOUEXD8/Tu4v1OMUmaKjurf6h+mAzanbJyc66uVUg7jGYvNgcyg43fXj90
D+9enMi2Oo0MXvvpQEL9BdXB1NVk3c1PdV3GCjmNstvEO2dk0jHrHiXfIybZ
/icL9l0/ID9MBu0eWbk5V9mFL6T2Boedbt8cyAxS5UDZuj7wemki2+o0Tnnt
qgN5XlIdLCJHvvaWRZW1WG3CkgKxKBrXnXK9mOQD97SdjWNk0B6RlVul5/di
am/r8W6IjPwdqyBuLGF3Uwfyhuog9Gc9epq5WrlxpZhkRo4Qm1F+YRm0Bbwb
tbd3Q2SEpyorvlF1cCMnYoc8+9ryG5uvK4O2ZPy9qL29GyJja0+UsHuz6uA2
XgSmphlOvr0P3xEZtHdD890Q4eDg4ODg4OA4/x9oeiFD
              "], {{0, 42}, {308,
               0}}, {0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {308, 42}, 
            PlotRange -> {{0, 308}, {0, 42}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"49b0c68c-b740-4211-bafc-b438d3d8bd4a"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["28.8"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"7e63edfc-c95e-4dd7-8166-10cb8b2dab91"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"bfefa058-cdb2-4261-ae17-d9ad824a8bc9"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"b8aadde8-5d96-4fb9-941d-a6347d277c72"],

Cell["\<\
Get a list of words longer than 15 characters from the Wikipedia article on \
words.\
\>", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "28.9", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 TaggingRules->{"MultipleSolutions" -> "True"},
 CounterAssignments->{{"SectionNumber", 28}, {"ExerciseNumber", 9}, {
   "WebOnly", 0}},ExpressionUUID->"d4cc6bf9-dc82-4a94-a6d0-4db5958559f8"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{
    "SAMPLE", " ", "EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"5e8fe11b-a689-46f3-8474-8c9cb068e2f9"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztW72vpMgRx77EoSX/Bf4HiJ0SOkI6yxnJnbycnKzxri1rUjIuIyMjIiIi
IiIhIukEyUKWCEhwQIAlLuiAYK67uhu6me75eH779uk0pd3VDANVv6quz272
99//7Vv/15Zlff4N+efb7/7lfPr03elPvyVf/vzx819/+PjhL3/8+I8PP3z4
9IfvvyEXf0f+/vNXlkU/n5/0pCc96UlPetKTnvSkJz3pSa9AuEdomNf3Jh3j
ByEtI2raBR5ahhZ102vAu0lXrLfe0EAC/I7ofaJ6N7QuA2q65WvDeFuay8i3
7aDF992+4mVz/aWxLSts5i+G7SoZpPd5YFlW0j6wjAuKyCMNPIEiwjV6C5VU
/OueE3HmEThBb45TGfD7oa+ECjd5mjBKs6JqxocAyP78AtFZnDfjnXf/H/aR
dCQUx1k9vIDLl6cl8x3HC5uJm3RpE6KyHxXjfTZeUGxZDmImwsi1rBh9pfRi
kD6jzPNO9Z36AIERuFJt4lh28hYhIuNfB5ITI64LrpPAD/MrZpUBvx/6SqgW
smJEru/7nks/WZZb391+Kv78uOiY1qLm3rtfbh+mo+16nkvIcYKsfQGXL09r
V6akNtrCJmDeWO5cTOmcXIbnwUTsAYyI0jH0PXi5bIpX9sjFVX21kG/GBgwK
xxvSFYkX3BQtXym9qOh0uivE8PP00m66mHjLOlw6Kr4t7xGoxpp+WD2FD0PV
roylhqd25QmL9dotei+SiIaek4hwGytiSSdGBsxHboo/yzfdVZ1AtCKLPXwB
GNNLa58eVu1BQQ+mFMWYRjNqf9C6kykqD9HXpa5lx7xStjS9cI3nNvJsyP/W
Ka0Z/y4L/LjITvT65x//bgmy/WyB+nvK8pAVDTtAoikam8zl93k5ErUED4nP
+buea1tO1i0y/wj9t6syAcGKyv4sMHhRlp64mLiC6wbpuM+dbdabuyRgP1tB
UlM18Vgmp02HaqD3XaaXeaxcy8nFoLy0mW35+nlr7UPHifI8sBnLtB8Rh+SE
8AguTo6fct8YihM13VlKL7gLhMqkkSQwiL52kGPQxXXDPAu50cJi5nik9LKv
mh0Li+npNlTKu0oCJs7xE24A9mCW+YCi/Yl+DdOUw3ZODfSKgMpOslhcLoTB
dp6u6MrYuovF88puqGKPaZGKcWP3IieoR1OSOcS4+HrAjDU+2eXCE5g/n/Uh
YKZdNO4z14vrKrEudC9jn130qHj3YtXuFpQc0over3CXuX5S5eAz0EVog1Ef
U2etO2FNVIJ546K4jH25QPdkzmepZu3B1n7RtFVGP7oJgpsBmh9XdfPv/3QF
+EmUVzXqV4yYQ5zyugUVmKmXNgULp6htWD7JexorOTGzfULj1JUxtXZaT1jh
PyxT5JA8UHZ9l4euFPIuMMzaHjGGxbCejdJpu0snXK6Rm9WoKWPPTyc6hRQ2
vdL2XUWjw02xvnsZ6fKcSmaxKqRxo59WFsTWLsqbJud5IEgrVKe0jFIbLolN
bMz9H8WEf6ykl3VuChqSXlzUNR1bAQNdFDa6krUrUVezRQF32gEzHZ2w6YcG
giUfzK56G+q5jqi7hNSkOTWvHY7Sg0Fa1E23bnyKpkMF3BZNG1rLK1DL8gnb
AQOedlJ1Q1v6Ypm2NUWo5BXAi5u2pu4K9sFdCtfKfuhSyiw07HGooTfV1BPI
VxXz/3Q+uYyqPxtCwEx7ermqOymCVYtKCGV3X7UHBVl+UjdNXdcEKxwI6P1K
IHGzqmq6yRCMhpjSu5MuKoV5T5kSfWeauDyGZO4rYggHUhxMSYQbT0F1SCT6
HQ//07aRBM2k27K7oH8IK5YPV+qOPqm5kEZ2ZxhOFjMCtYaTdOyiT2eBRah5
Ujeq1mno6zza1oiFGy8HINQl/qOXvoce0yjrdOGG56FvafV1klmfXkg5CIQz
dARtUBg20xgMPu3TYVwMnjh1hOJSed1zuzocuVRZfLiHAds2A8vAktLOrmNB
fGBdqRuwLIGnvutVgtp/Eyrc4ImCiMEzob8Cm8dikwG+RmJTeq5DBpKhqtll
0Gh71s/IulOIdLlBBXlNaTttRQzWWJ6o2TErRvEIj+GxIF8Mm6JLCoHi0b0X
1padqNcomE0+qfizKQSM9jymF1ur+2Y3PogtLxGUsmC2CdG8BJ6i9yuWXoTb
GxXXxpTenTipUWmIPvqlz6H0dBEgrsAmA11WqxIVmm15kQU97EUobTkPkEUo
yDyHmsIOa/HEHEJ2JoBKOgH5Vdc3WSBlUZn/2qSsi3Z837VE9Kn3zLHNY0En
fUdI2kXWFSuE+xhyte1Cu+fsUXzce8EtsVlQTrhTYvxICgx5xbfPSnnVpxf5
80V62aZ1mGqV62zVZPISxE4oVILYvAmV5Y1tt1wKE0eUg0u0rM0gLqfzjXlr
Mndy00VdU/kz5hl1yY6PeYZN0YUWKDJ0FXmeF6QJwTJIjtnkk4qFTSFgtOcx
vWh0B3tuI7ayai8TpCiu8yuQ4ordJKPi2pjSupM+Kg3Rx/RPIM2vc0cTZ1hR
AZC4SpHmGtrUeS02pBd5a/cYFHCuam9nu1ModpIh3m2HKOL623Ge4lrgqFHN
fupcNb1wg801nSNINbwVknMDqVhtqeltlssK73ARrQc8TUQGqSglWdEvjDtw
Cgx9eqGlR3A4phfm/2r8HnThvSIxrH/sXmDVRNHcaMXzgdhG3U2oC73Bz/kY
vg5QhnZf2txn31Q/835j716OIQY8L3s/U3oRTMCLYHS9Rdp9iYOyRp+U/dkU
AkZ73kwvzJ5Cd9zJq/a4oKOOer9SS5JRcW1Mad1JH5WG6NvuZxtoPW1rIO1A
sYaxa2wrqr4d1edDEyUayAz1wzCty6UIyorFNZmah7Ev6LBGStvM50c3GeZ5
miZiObYLLfPHXUZzYz3MU8t6DJFeXBje26FHsP8HHbhB+m7eBeqmfaq7kUz9
gR+TbpSOqJaPxnlAubt1L2DVcthm0pD3rWPJNrTi7e2atSPJxglL6bzkZnph
Qr2yGzu29efs3ZGfItiPhgkirceRvme32YS/NhAXxNwVVJCg6M8y4AVWzY3Q
ME1jmyVZfyUgb0PFdCK07JSYrK9huz2gDJdjeoFNyrDuBtKJOqIh0YcY5+lk
dT/PY5Mn+V4yYlN6aWh1oKXcT6pxJotVJlmzau2vr+xHzAafVP3ZEAJXDHoj
vfChxivaYeL2hHH7RYKILVCLmob8aZqWeqjWrw4dr0lxQ0xp3EkflYboO/Pt
XJ645JOjpS+2htQJsok/6FpOureluOd7xZbX/UTBSCJc5maEULZ3WWHB9luY
NZTOi0Styn+MBQLvRFeD772kcqNsJyyRYr103hwCx6XLXVUj3BcChBOGHo/0
qYKL1A7srTyPV3A2ukpvuDHHkPKtCmNJnW1cXTJX+F5fCBhuHPtcKGEOasGB
1loLzUnDudlEbNMJm0QirCTAS1/u1rH9ay/83AGVtCzb6d52snYwNU8vzmbI
EzisYnnlkXVM/X3po2o4+NU29G1MWGfUiv1nWC3Q/dL+vLJfpJcDZoNPKv68
6kPATLtoo+5Tsx0LBhFxaeGZDwpKNz/mS8OWXuNXChKz4vqY0ruTLioN0Xc+
FAuavSMJy7rQluz6YfxKe4+bB/bAab+LzaEELn0NYSVa2NL2oGLKCwAUMLii
wvBeutQIX/Khbak46l/oR/bzLO1/cqL93gtejFkX0rJdvg8hI8N7M8xpizWq
g2oTGTDX8ZL9SwlfdwKozknHYd3J84UQV2aVHcsL7S+BuHy1RvXne0LgMakH
FV5TkN6v9KJkCFdjSrNW90PtIOfKg5LjJ8MrmlNLCyL5JMjJVL3iZSwhIRZX
TlElkluvt6K1rcuEHiXapdQPjPTwxsraN8JyODl6L3SYld6Q3tj+v2D6MjGF
mxROtvdZFTdZ5Puh9vz2VWmVe116Ln/3f9boMt8Wx15vROwFANvNkNK3rsvY
G9/ven0iY6/NTyHfE1Hj2Okj/6vr1SS/rf1/wfRlYgqXURCEaf/VCiJpXRbN
W9NPetKTnvSkJz3pSXfQzxCdOmA=
            "], {{0, 19}, {373, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{373, 19},
          PlotRange->{{0, 373}, {0, 19}}]], "ExerciseOutput",
         ImageSize->{377, 19},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "f07b2f0a-c110-47a2-8484-89f5511b5401"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztW72vpMgRx77EoSX/Bf4HiJ0SOkI6yxnJnbycnKzxri1rUjIuIyMjIiIi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              "], {{0, 19}, {373, 0}}, {0, 255}, 
              ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {373, 19}, 
            PlotRange -> {{0, 373}, {0, 19}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"c601f8d0-80fa-423a-81e3-33527750ee46"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["28.9"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"831ec32a-ace5-4b13-b52f-cb0de626ea40"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"8f16b2d4-ff35-44a1-a3dd-f639f52685fc"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"a04b9ff4-9770-4bcd-9200-6f2ac51cdb7f"],

Cell[TextData[{
 "Starting from 1000, divide by 2 if the number is even, and compute ",
 Cell[BoxData[
  RowBox[{"3", 
   StyleBox["#",
    FontFamily->"Source Sans Pro"], 
   StyleBox["+",
    FontFamily->"Source Sans Pro"], "1", 
   StyleBox["&",
    FontFamily->"Source Sans Pro"]}]], "InlineCode",ExpressionUUID->
  "a70611c4-f525-4787-a806-461e7fef2b14"],
 " if the number is odd; do this repeatedly 200 times (",
 StyleBox["Collatz problem",
  FontSlant->"Italic"],
 ")."
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "28.10", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 28}, {"ExerciseNumber", 10}, {
   "WebOnly", 0}},ExpressionUUID->"52d1c4c5-e89f-4900-9041-6c7e8fe361d8"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"5250fba6-cfcf-490a-85f4-52ee80115ebe"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztnb+LO8t65se7icP9F/YfULypQkcDXjabxGavzCbX4nphUapkUahkUWBQ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            "], {{0, 196}, {497, 0}}, {0, 
            255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{497, 196},
          PlotRange->{{0, 497}, {0, 196}}]], "ExerciseOutput",
         ImageSize->{501, 196},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "a96e2f88-941a-43f6-81dd-a7e81d2d2696"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztnb+LO8t65se7icP9F/YfULypQkcDXjabxGavzCbX4nphUapkUahkUWBQ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              "], {{0, 196}, {497, 0}}, {0, 
              255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {497, 196}, 
            PlotRange -> {{0, 497}, {0, 196}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"107b33c4-40ad-42c3-aa6e-a41dc35b54c4"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["28.10"], StandardForm],
   ImageSizeCache->{146., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"608ccc95-b432-498a-9ccc-e9125d496128"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"c17f6aa7-20f3-48f9-a135-c5b49af4b5ef"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"737d0517-3300-4b62-a292-c98dfd8ee247"],

Cell["\<\
Make a word cloud of 5-letter words in the Wikipedia article on computers.\
\>", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "28.11", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 TaggingRules->{"MultipleSolutions" -> "True"},
 CounterAssignments->{{"SectionNumber", 28}, {"ExerciseNumber", 11}, {
   "WebOnly", 0}},ExpressionUUID->"201b81ef-53e7-401f-84c9-9863a4fc82aa"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{
    "SAMPLE", " ", "EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"b5ed3e6a-25c6-4968-83cb-12cb00408833"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJzsvVtwE9m98EvOqVTO48nDPKSSl1P1PUylKlQllVSldu3K91GT5Nsne1ec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            "], {{0, 321}, {319, 
            0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{319, 321},
          PlotRange->{{0, 319}, {0, 321}}]], "ExerciseOutput",
         ImageSize->{319, 321},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "e95da1fc-dbd1-42cd-93d5-716225affd28"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJzsvVtwE9m98EvOqVTO48nDPKSSl1P1PUylKlQllVSldu3K91GT5Nsne1ec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              "], {{0, 321}, {319, 
              0}}, {0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {319, 321}, 
            PlotRange -> {{0, 319}, {0, 321}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"d5749863-9893-403b-84c4-05caa580361b"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["28.11"], StandardForm],
   ImageSizeCache->{146., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"6605d444-4ce5-4aba-a08a-e4fc77b2e857"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"5179194e-926c-4a4f-8494-43bc27d3a32b"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"92b117f3-38c5-4b5b-b72c-4ddc87590b8c"],

Cell[TextData[{
 "Find words in ",
 Cell[BoxData[
  RowBox[{
   StyleBox["WordList",
    FontFamily->"Source Sans Pro"], "[", " ", "]"}]], "InlineCode",
  ExpressionUUID->"c3401571-d490-4b52-b210-8ad6562ce942"],
 " whose first 3 letters are the same as their last 3 read backward, but \
where the whole string is not a palindrome."
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "28.12", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 TaggingRules->{"MultipleSolutions" -> "True"},
 CounterAssignments->{{"SectionNumber", 28}, {"ExerciseNumber", 12}, {
   "WebOnly", 0}},ExpressionUUID->"0c0a392a-e772-411a-9f8f-21708a98e9ce"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{
    "SAMPLE", " ", "EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"8982da8a-cae1-4ca8-8b48-508ab7909164"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztXa+zvbgVp62p3H+htgJdi6xiZjt1mN3pslOzZXY707kWh8ThUCgUCoVB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            "], {{0, 42}, {272, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{272, 42},
          PlotRange->{{0, 272}, {0, 42}}]], "ExerciseOutput",
         ImageSize->{276, 42},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "1960244b-d3d0-4b60-baf9-9547c43fc474"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztXa+zvbgVp62p3H+htgJdi6xiZjt1mN3pslOzZXY707kWh8ThUCgUCoVB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              "], {{0, 42}, {272, 0}}, {0, 255}, ColorFunction -> 
              RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {272, 42}, 
            PlotRange -> {{0, 272}, {0, 42}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"44b8f8eb-a158-465d-a052-bc5757c9ffbc"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["28.12"], StandardForm],
   ImageSizeCache->{146., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"c9f78246-51be-41f2-bddd-84514a77b568"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"5595e81d-8103-4a4d-88b2-3f4ddd4133ee"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"3bbce601-415a-4fd9-8a07-3423e6947ce3"],

Cell[TextData[{
 "Find all 10-letter words in ",
 Cell[BoxData[
  RowBox[{
   StyleBox["WordList",
    FontFamily->"Source Sans Pro"], "[", " ", "]"}]], "InlineCode",
  ExpressionUUID->"275dd57f-2bc3-4eb0-8b5e-72ee037534c0"],
 " for which the total of ",
 StyleBox["LetterNumber",
  FontFamily->"Source Sans Pro"],
 " values is 100."
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "28.13", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 TaggingRules->{"MultipleSolutions" -> "True"},
 CounterAssignments->{{"SectionNumber", 28}, {"ExerciseNumber", 13}, {
   "WebOnly", 0}},ExpressionUUID->"a83bd4f3-839d-4b6f-bed4-b294f13be6f4"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{
    "SAMPLE", " ", "EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"417ea06b-7d9b-4587-a222-98ec6ad452c0"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztvb/Ptc7/53XUxtJ/wX+A2pbSimSNHYnRuGw0cSWriaE93Sks6IiFVFRU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            "], {{0, 218}, {499, 0}}, {0,
             255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{499, 218},
          PlotRange->{{0, 499}, {0, 218}}]], "ExerciseOutput",
         ImageSize->{503, 218},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "1e44339c-2ac3-46f8-9ea3-edb089f8066d"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztvb/Ptc7/53XUxtJ/wX+A2pbSimSNHYnRuGw0cSWriaE93Sks6IiFVFRU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              "], {{0, 218}, {499, 0}}, {
              0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {499, 218}, 
            PlotRange -> {{0, 499}, {0, 218}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"9b83bc6b-9b8d-452f-abb1-47d7e5f894cf"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["28.13"], StandardForm],
   ImageSizeCache->{146., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"ccee0413-40bf-423d-b923-48c2d5b8e0de"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"764077b0-76a4-4e60-9a9f-a99a5073c8f0"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"fe2fa5cf-7944-49b1-ab42-cf9d291aab54"],

Cell["\<\
Make a table of integers up to 25 where every integer ending in 3 is replaced \
with 0.\
\>", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+28.1", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 28}, {"ExerciseNumber", 1}, {
   "WebOnly", 1}},ExpressionUUID->"71c4e11a-d01f-4414-ba9d-05ba3fd691fa"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"27335c23-01e7-4d48-b36a-031ee2e664f5"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztW7+vrbgRJkmTMlL+gvwD1GkpUyFtlO40u8pjleYFvY0U0dJR0tFRUURU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            "], {{0, 19}, {425, 
            0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{425, 19},
          PlotRange->{{0, 425}, {0, 19}}]], "ExerciseOutput",
         ImageSize->{429, 19},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "3ed8443a-739b-4575-a522-9bd8f9457ec3"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztW7+vrbgRJkmTMlL+gvwD1GkpUyFtlO40u8pjleYFvY0U0dJR0tFRUURU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              "], {{0, 19}, {425,
               0}}, {0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {425, 19}, 
            PlotRange -> {{0, 425}, {0, 19}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"deecc990-0dec-4ffd-8839-c87dc517a908"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["x28.1"], StandardForm],
   ImageSizeCache->{145., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"4f2c8c02-e8df-4482-bf6b-a3c01e0bd49c"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"18e9c5f8-adbf-4765-b8d4-48c06c383363"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"647fea94-c083-4750-9d93-562a32daf18a"],

Cell[TextData[{
 "Use ",
 StyleBox["Table",
  FontFamily->"Source Sans Pro"],
 " and ",
 StyleBox["If",
  FontFamily->"Source Sans Pro"],
 " to make a 5\[Times]5 array that is 1 on its ",
 "leading diagonal",
 ", and 0 otherwise. "
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+28.2", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 28}, {"ExerciseNumber", 2}, {
   "WebOnly", 1}},ExpressionUUID->"9c2cf2fc-d773-49b5-8359-19fbb2381882"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"c10730ba-91c6-41df-a0c7-9aedce31b4dd"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztmi9v20AYxm8bGZy0T7AvYDxqOFSp01hIq9XVSBu1k6ZQM0MzMyMjo6Ig
kyATkyMmBiYmAQEmBwy6O8dNzv8iq3Z8b7f3qRo9Sd7ze78HWL67fLm+vzTe
E0IeP/KXy6s/+sPD1er7J/7mx93jr9u7m5/f7n7f3N48fL3+wD/8zP/v3xEi
/DMKhUKhUCgUCoVCoVAoFKpbu7VlaNqSsobnyhNK07w4PT6NAt/zgyhVV5Z7
hq4vzHB7Yqo1tIFdACRwLjQACShGO2cCbwPtVQnIaE3MnDqEEMN6yoqaT/wV
KWWFuxNtImchijTxsnAjRWVFvHb5R5oV9sYhoQ3sAiOBs6DBSEAl2pkTeANo
r01ARmti5pFNiM1aPg08c3nBL+JE/THmoU7IhSNmEtrCvjzSKCiL3Qui2X1z
PaIN7AIpgYnRICWgBm2WBECjjUtARpM9owIqb/l9Ib+K3R8jK++uwbZ8k62J
KM5VlVFHJ5rTMaCONrDLi0AkMC0aqASUoM2TAGS0kQnIaLJPvMXhxiL7smWk
n4wx8Q3++LOf0XORGD1TmqcsLiffl8gBbWCXSjASmBYNVAJK0OZJADLayARk
tIPfJcGSEL1c8si+7yINRbZ872WuTnSHqiorEl+s7J7i9p6XjDawy8v3IBKY
Fg1UAkrQ5kkAMtrIBGS0g7fKLZhAVO0k33uRhsT97fgkk/J8rK7iucqYU+4m
bZq32BrawC6VoCQwJRqwBBSgzZUAXLTRCcholS92scmNGfCPZF+poGKtRHuf
f1jMV17aZt9kG4hdmq7iecpY7HLvhll7iIw2sAuoBKZFA5WAErR5EoCMNjIB
GU32ib/ghdWeydGzhFK6EWUrbxNTmjFxELTSiG6uj/u+5WqLGF66TV3hluLE
WklZtQh1WOcQGW1gFzgJTI4GJwFVaDMkABxtTAIyWt13n+awSJwGSRL7M4yK
k+n6nlIe+3pVoj8l+f4qCsrkXeWuITLmoC5wEpgcDU4CqtBmSAA42pgE+k9z
yvNuq+07JW6n7dOuIt/xv0JxWeyIXaS8Z0gTbWCXlv4dNBgJqEQ7cwJvAO21
Cchost8veXTDSYuabytbL/m3Hj31U0BFZSx0xe/0dDvqG4JoM84Z0f4TtBpm
9a1nGYYZs4ZvqsizJOv5nZziMra2lkvT3T+s9QxBtNnmjGj/CVoNE4VCoVAo
FAqO/gKARz9k
            "], {{0, 19}, {367, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{367, 19},
          PlotRange->{{0, 367}, {0, 19}}]], "ExerciseOutput",
         ImageSize->{371, 19},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "9011564c-9d8d-4c34-93d3-dd3d71e75bc0"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztmi9v20AYxm8bGZy0T7AvYDxqOFSp01hIq9XVSBu1k6ZQM0MzMyMjo6Ig
kyATkyMmBiYmAQEmBwy6O8dNzv8iq3Z8b7f3qRo9Sd7ze78HWL67fLm+vzTe
E0IeP/KXy6s/+sPD1er7J/7mx93jr9u7m5/f7n7f3N48fL3+wD/8zP/v3xEi
/DMKhUKhUCgUCoVCoVAoFKpbu7VlaNqSsobnyhNK07w4PT6NAt/zgyhVV5Z7
hq4vzHB7Yqo1tIFdACRwLjQACShGO2cCbwPtVQnIaE3MnDqEEMN6yoqaT/wV
KWWFuxNtImchijTxsnAjRWVFvHb5R5oV9sYhoQ3sAiOBs6DBSEAl2pkTeANo
r01ARmti5pFNiM1aPg08c3nBL+JE/THmoU7IhSNmEtrCvjzSKCiL3Qui2X1z
PaIN7AIpgYnRICWgBm2WBECjjUtARpM9owIqb/l9Ib+K3R8jK++uwbZ8k62J
KM5VlVFHJ5rTMaCONrDLi0AkMC0aqASUoM2TAGS0kQnIaLJPvMXhxiL7smWk
n4wx8Q3++LOf0XORGD1TmqcsLiffl8gBbWCXSjASmBYNVAJK0OZJADLayARk
tIPfJcGSEL1c8si+7yINRbZ872WuTnSHqiorEl+s7J7i9p6XjDawy8v3IBKY
Fg1UAkrQ5kkAMtrIBGS0g7fKLZhAVO0k33uRhsT97fgkk/J8rK7iucqYU+4m
bZq32BrawC6VoCQwJRqwBBSgzZUAXLTRCcholS92scmNGfCPZF+poGKtRHuf
f1jMV17aZt9kG4hdmq7iecpY7HLvhll7iIw2sAuoBKZFA5WAErR5EoCMNjIB
GU32ib/ghdWeydGzhFK6EWUrbxNTmjFxELTSiG6uj/u+5WqLGF66TV3hluLE
WklZtQh1WOcQGW1gFzgJTI4GJwFVaDMkABxtTAIyWt13n+awSJwGSRL7M4yK
k+n6nlIe+3pVoj8l+f4qCsrkXeWuITLmoC5wEpgcDU4CqtBmSAA42pgE+k9z
yvNuq+07JW6n7dOuIt/xv0JxWeyIXaS8Z0gTbWCXlv4dNBgJqEQ7cwJvAO21
Cchost8veXTDSYuabytbL/m3Hj31U0BFZSx0xe/0dDvqG4JoM84Z0f4TtBpm
9a1nGYYZs4ZvqsizJOv5nZziMra2lkvT3T+s9QxBtNnmjGj/CVoNE4VCoVAo
FAqO/gKARz9k
              "], {{0, 19}, {367, 0}}, {0, 255}, ColorFunction -> 
              RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {367, 19}, 
            PlotRange -> {{0, 367}, {0, 19}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"184ce520-d3b6-4ca9-b45e-242f603846ae"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["x28.2"], StandardForm],
   ImageSizeCache->{145., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"4a9987b1-b9f0-4f34-8750-948ae63a1947"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"386913ee-bb20-421f-9626-3c1c7a8dd159"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"b00d5c88-5fda-4d80-a2b3-14d78fc1e3c5"],

Cell["\<\
Get a list of numbers up to 1000 that are equal to 1 mod both 7 and 8.\
\>", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+28.3", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 28}, {"ExerciseNumber", 3}, {
   "WebOnly", 1}},ExpressionUUID->"4b082411-895c-4c8a-83ca-c54e1b7e0114"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"d13de1fc-a1c1-4071-befe-bde4abcf2ad8"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztXLHrvcgRN0mTMpC/IP+AdcpYphIupHvNHfl5pLnIXSDYCiksbYLFgZVp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            "], {{0, 19}, {467, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{467, 19},
          PlotRange->{{0, 467}, {0, 19}}]], "ExerciseOutput",
         ImageSize->{471, 19},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "f9f0c2f7-48e6-4555-8cbd-649469e7643e"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztXLHrvcgRN0mTMpC/IP+AdcpYphIupHvNHfl5pLnIXSDYCiksbYLFgZVp
hARDwMpGCNgIwRSmkCABGwMWXmGxxcvOrk9XndV9+RXhDgd+x3s+57M785mZ
nV393k8++80n1vc1Tfvqh/Q/n3z6O+PLLz91fvEj+uWXX3z168+/+PCrn3/x
2w+ff/jyp5/9gF78Mf33j+9pGnx+3nLLLbfccsstt9xyyy233HLLLbfccsst
t9zy7ZYh9Sxdt6uJfx2bqmpHIr+fdHW1St1Svb6ptlKfAWBDkKGtqmYUb+qq
NImTNG/66coEBLCvyzSOk6wcXpfJ0GQAWHQjAiEOXNCB46So++UanR1Fo3Dt
AscGXQ0+AcUA6WzKHCZYtoN479EPiEx9wS2pO2GQvbveIAUDRN31DilUhrqk
9m3uJH1TlutM1EhBQo5jURdGcVJ1yxCKpEgAsbB5KpLCbsuZd2rBOTvdtzJl
ByjTVSFl6tudcstuxgJbiRQZIBbYypnyfHZVQVOFBuLOkl3YPJVJOQIerXuH
lLHMAO/SugMpY2QZxsMt+hl6rAJN0ywv6ciziR2NiVcMhxHXoX1dE8Qox90V
Knou8Qg2xJTYBtcqZi1Shja/wm8OK+l80DkXwUOYjNOQ51TH+gpo5j3u2aHi
t8332XFNL5ahxS7xa0bWMd2pNESLvUIdkM6GTVo3GYSbtRI/IEK6zBQATS8n
uLtUScEAUXe9QcrMgg/A+sYzrSsYqEgKFnIA5a0E6EkzqZMiAUTCRpEUQKwj
ETGCRD/qvpEpB8D/YLqqpFS+sVf2SzSwFUlBAfHAViVlyhijBle2E6H2bsJG
mRQEELNOmRQyhxx3mJPKrENJIXUaPoR0GEtf03xuY5tFrg3JEpRnhTcwNDOs
KBQTPiXy+tJ5dDQrli292BBTFnqORdXM8mVvHVqmz2ZIGqDSyWSzQQC7VHsV
ENLlXkA/TJEJNkM/N1Y02nQ3R9GaiPqG3QYrFPixf04htTco4dpQ0J8NHz6T
LqEfgTgi+EEJkPvc4AtF5kDIDhI/HIV0qaG7rCY8WVwZNPZwd6mRggHi7lIn
BYxpYh51s+uYlHNl4waqkoKGXAeO02KYdwufrIQok4LHMBI2T0VSaGSwOuSw
8j/EXsAaLExXNVMwQExXmRRCptnUKjTZlNDAViflCIgHtiopY2FAre7YdHyx
qG7DRuJYJUCJdWqkCCFHEofeZ7cS62Sk1NRRc7I/pwoKrzD9mk7NPyu8vUer
XC3pGMHzWtqhP54NQepwaTy2MtLhtEd0urPdADYx9ehjO0FINN2fK0ANK48r
meM4vLYZQ+HxskbGZbc8+q/Cy2LMrM5OVKSATNfl5w49sOkvvpD7AZEhdzmg
ONzRXWqkiICX7rokhQWw8Xjos7vANFaKTceh6c7mrE7KMeRIQnsKI+Cm17C6
WbQ0KZOCxDAWNq/Brkhh2UebHeQOme45KSeAcl2VTIEJPeAu2Hlhga1OCgKI
BrYqKSO0jk7OUoFUxqvwHsJmGfYqUxDAC+vOSSl9YymbfJkO6/HKug0pFQw/
By20ZPqa+LxzPiu8Y8k2kA/bslw/qjc7EbDrvBGSDcFOPLZuJGPfNlnIVoyk
UQYkqU0XsqytszAI4pRDDoG+OrzLjvUKEfDzPuo6V5tx+BENdYNtO0F8CbYB
hCaTzsCOmq6iPabhrU0F4gdMxr6r8hj6ACt6Hc/I3KVEyhZQ7i41UioIaS1t
u8hccHooxbrfj5U5oymTgoTcGAglfWJOgxVNkRQEEA2b1+1XpPDsy2u6mwzD
KK2F81KJ7gUpJ4CIrnqm0O0BrC9Wsy8US2C/nSkiIBrYypnSs624ldVtAWcg
TguYx7B5eeE6U46A59ZdkMLy15vL1pDzmiO1DiOlZsWW3jM0GTQO4qnLZeEl
jWvolhemaQTNPl2GhuUXWJvi9mptUyu8LPa42Puj9jPAMTDnPa7jspMWMxxg
twJXbS/wXb5teZwXN9ImrAjV4kVWT/SUH4U1MV2C/ThJmG9PTlcwwDEUzicz
4ZmbWuFlEcJkcaPMXWqk7AFl7lIhhVvqsL6BmmkEYDJzHe9YaO9h8A5BlRQk
5GDCS+FdnKZKCgqIhc0OX+o+ln0woOM+ANBYOEV1L0k5ATzqvpEp7FiGnbFs
RAzsNzNlB4gEtnqmtIm9KJtR85SEjeCii0w5Ap5Yd0nK1ESsxrpB4PLT26Ac
ZdahpPAhvKT2uH/EEnhZeEUZcl14qqW0MZEMIXEjGbsSjHxtKhUAWQ15zFkz
vnohaIvSyHUcmm1l5sHp0EmIsiMvukEQB+1AC+8oGL+njcEWMKcm6V4zkb5O
bVjQV6cpdrxUyNSnPqAma6gg7lIlZQ944q5zUsaQVTDb833fZR/NP/zxax77
fuB7rKxZjpfBqwTvkMJlDrl/ox2vKNek7ADxsFm/XhbeeO4jG1uoRajuJSkn
gBJdtUxhG+So2Xj5ENjvkLIFPAlsLiekTHB0oEVVT8YmciBw/vS3P0vCZnHR
GSlHwPPAVsmUocl9quwGeZFA+7stYgfrjqRMASvZZKjhuituWyo4L61O2BNO
x9nx9Wt0lnFOen3Ahg0x1cyNy9IwrWT3qXORQVtA2BEYAdcnbXzUhcMnI5RG
U1/AQzDDF/rQZ8uC0xJaBTKthvbnO7I94ODr8/rL5u6Lujs/YCK4Bk6uYOGT
u0uFFARQ/HlxlxopUx4FfhD4IJ7J+smv//JX+j3gF705g/J2Y+QpKceQ61N7
vb+Bx5ZWTdRJQWL4JGwuSWGVX89fmw9xP4vpXpMiB9zrvpUpLdzwqITJHANb
lItM2QPiga1ICjx40tzXLwOd1s9+H52EzSUpR8BlpcasUy5ffHTW0CYdQa2T
kcLXgrCA6t7Awd78VB1eSMvhJyfK64q9HUlqh7YWbroAsaLuFk3XtyXrj+Yd
Cm81N6YddNEh6KpQVXUeUVw9zMuqpsbAcb3pxU0/dE3uGPAgslcG5DsCOyqG
oWHvy9i0cahj1/KSpmvzCHYEXt6jM5y6jO9AgqysyrIoimYgTeLyLUNe8WvV
MLEHCn7a9n1TRAbbmY6qgN/AqZhmZU0/0SbTM3noIn7AAKHg6E5Wd0PfJqCr
Rf/8O+4uNVIQwGZC3PUGKetg7Khhm9RQ242SP/xVIwUNOd4TuknVN+BheDxN
VElBAdGwUSSFn5Fqj6Du+5K93xjWI66rmikIIKL7Jins8dDaEiOBrZwpGOCE
BPY3qqSwE1e6Da/GaWpyINcrxPfe17BRJAUFxK1TI4X0uf1w87ptypgdWCQE
DTkZKfMDtXlxX99qmEpT24gPp2YVC8z1tYexzZ31PiNcnQOnPZuZH3TRIYTD
ECbsSV+bC2dFhp3zN+TVAOnleo4ocERS8yveco8TlbIZVsEOj5L1r8DYXaPr
F6kz4bLpzu22EuBA1wZvvWzG7N1L1A9HwIluXh76elMKDQbuLjVSUEDUXaqk
rLK8tSUInAvNDYAiKbKQm19DBRf6Lc89NVJkgMewUSTlyV6HXl4C5rbgumqk
oICo7lukQDSu294BC2xVUjDAJxbYqqTQO/PAWm605tf5FuQ1bJRJQQBx69RI
IXTr+koU3QpOQk6Wj+JbDcwK72QfDy2xvj84ItM4jKd/nSbXVZcRBtmssW8A
knEYdn80NdEru0l/3AwJzHDaIKoDgg/300FE6v+D7tFdHwWIuQsd5aN8qEwK
GnIw6722Kil4DB/DBhOJyaC8G1pRPhLw/0WKRPsYnMqZwpVV/izyIKqAksBW
BGQRt/+7uqN1T4yUGrrqGZAfOxhzAd9LBxtRLbr6GyVUPkb3BrwBb8Ab8DsE
OBXstQehqZ6KyLMsF30RhYxd0/1Py8/H6d6AN+ANeAN+hwCn1LNtN7z+v0vc
csstt9xyyy233HLLt1/+C3DAT+s=
              "], {{0, 19}, {467, 0}}, {0, 255}, 
              ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {467, 19}, 
            PlotRange -> {{0, 467}, {0, 19}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"9945efbf-1c52-41c8-80ca-05c3ea7fe335"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["x28.3"], StandardForm],
   ImageSizeCache->{145., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"486831f8-ce00-4718-a11a-a8836f74c529"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"a7a5dc82-a0ea-4fb6-8630-c1c188cc1b3a"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"d57301cb-643c-4a8d-b1cc-f0e957b5fddf"],

Cell[TextData[{
 "Make a list of numbers up to 100, where multiples of 3 are replaced by ",
 StyleBox["Black",
  FontFamily->"Source Sans Pro"],
 ", multiples of 5 by ",
 StyleBox["White",
  FontFamily->"Source Sans Pro"],
 " and multiples of 3 and 5 by ",
 StyleBox["Red",
  FontFamily->"Source Sans Pro"],
 "."
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+28.4", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 28}, {"ExerciseNumber", 4}, {
   "WebOnly", 1}},ExpressionUUID->"e8d3cb2e-06fd-4efd-98b9-5fde37ebf4af"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"d5f36b2a-60d7-4792-b2fb-9cf4833f0181"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztncGr+8p1x91202X/hf4B9bpbL7upISVdeZPQ59DNq3kpFG8NJQi6URdF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            "], {{0, 86}, {
            488, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{488, 86},
          PlotRange->{{0, 488}, {0, 86}}]], "ExerciseOutput",
         ImageSize->{492, 86},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "c1891c9b-3814-4721-972f-b85b58e9e83b"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztncGr+8p1x91202X/hf4B9bpbL7upISVdeZPQ59DNq3kpFG8NJQi6URdF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              "], {{0, 86}, {
              488, 0}}, {0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {488, 86}, 
            PlotRange -> {{0, 488}, {0, 86}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"5ed5a75d-f280-49ed-a449-39b234c9d047"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["x28.4"], StandardForm],
   ImageSizeCache->{145., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"f2c20ec8-0199-4b97-bffd-9d62c8fefd06"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"776235d5-6c9b-4bc5-9a77-dbf4bdf32b54"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"b2ab84eb-eb70-42db-93ad-f944acdc5127"],

Cell[TextData[{
 "Use ",
 StyleBox["Select",
  FontFamily->"Source Sans Pro"],
 " to get a list of planets whose mass is larger than Earth."
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+28.5", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 28}, {"ExerciseNumber", 5}, {
   "WebOnly", 1}},ExpressionUUID->"3527e3fc-6a6f-4583-9758-b7fdc99b11ee"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"83434287-2c4f-480a-a18f-862fc1bd5772"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztXN9rKtkdd7cvfbQtfWpp6R+QvGXbJyEPeSg+XLBU+rAiu1TXffBW722o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            "], {{0, 27}, {277, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{277, 27},
          PlotRange->{{0, 277}, {0, 27}}]], "ExerciseOutput",
         ImageSize->{281, 27},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "8e55adb1-6c90-4b1f-9393-497e430e5a82"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztXN9rKtkdd7cvfbQtfWpp6R+QvGXbJyEPeSg+XLBU+rAiu1TXffBW722o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              "], {{0, 27}, {277, 0}}, {0, 255}, ColorFunction -> 
              RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {277, 27}, 
            PlotRange -> {{0, 277}, {0, 27}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"a1ea8e3a-4e7b-42e0-9db7-6858835b6f6a"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["x28.5"], StandardForm],
   ImageSizeCache->{145., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"1ba392c4-30ae-4e2d-b779-583ebebe0e0d"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"bc244e07-9393-4801-a8bf-56f5f704d72d"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"0b041822-c5f7-4390-aab6-b7ddbdb93428"],

Cell[TextData[{
 "Make a 50\[Times]50 array plot in which a square at position ",
 Cell[BoxData[
  RowBox[{"i", ",", "j"}]], "InlineCode",ExpressionUUID->
  "f3c13109-9705-4679-a59d-4c29a8a4b38f"],
 " is black if ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    StyleBox["Mod",
     FontFamily->"Source Sans Pro"], "[", 
    RowBox[{"i", ",", "j"}], "]"}], "==", "0"}]], "InlineCode",
  ExpressionUUID->"f2325d4f-8fdb-4e27-aeae-bd48fe12b357"],
 "."
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+28.6", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 28}, {"ExerciseNumber", 6}, {
   "WebOnly", 1}},ExpressionUUID->"9fd05a2f-80ca-4570-934e-59284794802b"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"aaa178e0-d081-40ea-a104-fe8e012f9987"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJzt3M3KLUcVgOGjThx6C96FU4dOI15AgifRSYREEK8+niBshJYvVbtWda+1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            "], {{0, 
            359}, {360, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{360, 359},
          PlotRange->{{0, 360}, {0, 359}}]], "ExerciseOutput",
         ImageSize->{364, 359},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "6ae03e42-ed93-4aaa-8a21-912496759fd2"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJzt3M3KLUcVgOGjThx6C96FU4dOI15AgifRSYREEK8+niBshJYvVbtWda+1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              "], {{0, 
              359}, {360, 0}}, {0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {360, 359}, 
            PlotRange -> {{0, 360}, {0, 359}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"dfd16b0d-aad1-45db-907d-20b9a3e6719c"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["x28.6"], StandardForm],
   ImageSizeCache->{145., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"0d20c9ad-d7ea-4e47-b52a-281d80a448c1"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"10770c3f-dc00-4251-a4aa-3c7591f99126"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"9ec3b415-4131-4bf3-8a01-029735d022de"],

Cell[TextData[{
 "Make a 100\[Times]100 array plot in which a square is black if the values \
of both its ",
 Cell[BoxData[
 "x"], "InlineCode",ExpressionUUID->"f0687c00-5acf-42ca-b232-bfa61e28aaea"],
 " and ",
 Cell[BoxData[
 "y"], "InlineCode",ExpressionUUID->"8806f182-bec4-41f1-a42f-2020632cbe73"],
 " positions do not contain a 5."
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+28.7", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 28}, {"ExerciseNumber", 7}, {
   "WebOnly", 1}},ExpressionUUID->"b8f13182-09ed-4880-8755-ba24023253e8"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"a05c9a90-cfde-4f1f-94fc-b4af8b702a15"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztnM9qOGYRRUfduPQVfAu3Lt1WfIAW2+qmQiuIT19/RXAzQ8h3h5m5wjmQ
kASGk/nDXXyQ/P6bf3z13a8j4qfffvn01df/+uOPP3797z//7ss3f/nhp79/
/8O3f/3TD//89vtvf/zDN7/58sPvfxXxty8fv3z9HQDACz///PN/PwMAfAZy
AwBeITcA4BVyAwBeITcA4BVyAwBe+Tg34tMIJQLa7+ZpCeOh9e/qk3TaEWoF
y5rI2ZIXR25cWcJ4aOUxTNBpR6gVLGsiZ0teHLlxZQnjoZXHMEGnHaFWsKyJ
nC15ceTGlSWMh1YewwSddoRawbImcrbkxZEbV5YwHlp5DBN02hFqBcuayNmS
F0duXFnCeGjlMUzQaUeoFSxrImdLXhy5cWUJ46GVxzBBpx2hVrCsiZwteXHk
xpUljIdWHsMEnXaEWsGyJnK25MWRG1eWMB5aeQwTdNoRagXLmsjZkhdHblxZ
wnho5TFM0GlHqBUsayJnS14cuXFlCeOhlccwQacdoVawrImcLXlx5MaVJYyH
Vh7DBJ12hFrBsiZytuTFkRtXljAeWnkME3TaEWoFy5rI2ZIXR25cWcJ4aOUx
TNBpR6gVLGsiZ0teHH9HDwCvkBsA8Aq5AQCvkBsA8ArvoleWMB5a/64+Sacd
oVawrImcLXlx5MaVJYyHVh7DBJ12hFrBsiZytuTFkRtXljAeWnkME3TaEWoF
y5rI2ZIXR25cWcJ4aOUxTNBpR6gVLGsiZ0teHLlxZQnjoZXHMEGnHaFWsKyJ
nC15ceTGlSWMh1YewwSddoRawbImcrbkxZEbV5YwHlp5DBN02hFqBcuayNmS
F0duXFnCeGjlMUzQaUeoFSxrImdLXhy5cWUJ46GVxzBBpx2hVrCsiZwteXHk
xpUljIdWHsMEnXaEWsGyJnK25MWRG1eWMB5aeQwTdNoRagXLmsjZkhdHblxZ
wnho5TFM0GlHqBUsayJnS14cuXFlCeOhlccwQacdoVawrImcLXlx5MaVJYyH
Vh7DBJ12hFrBsiZytuTFkRtXljAeWnkME3TaEWoFy5rI2ZIXR25cWcJ4aOUx
TNBpR6gVLGsiZ0teHLlxZQnjoZXHMEGnHaFWsKyJnC15ceTGlSWMh1YewwSd
doRawbImcrbkxZEbV5YwHlp5DBN02hFqBcuayNmSF0duXFnCeGjlMUzQaUeo
FSxrImdLXhy5cWUJ46GVxzBBpx2hVrCsiZwteXHkxpUljIdWHsMEnXaEWsGy
JnK25MWRG1eWMB5aeQwTdNoRagXLmsjZkhdHblxZwnho5TFM0GlHqBUsayJn
S14cuXFlCeOhlccwQacdoVawrImcLXlx5MaVJYyHVh7DBJ12hFrBsiZytuTF
kRtXljAeWnkME3TaEWoFy5rI2ZIXR25cWcJ4aOUxTNBpR6gVLGsiZ0teHLlx
ZQnjoZXHMEGnHaFWsKyJnC15ceTGlSWMh1YewwSddoRawbImcrbkxX2cGwAA
GXIDAF4hNwDgFXIDAF7hXfTKEsZD69/VJ+m0I9QKljWRsyUvjty4soTx0Mpj
mKDTjlArWNZEzpa8OHLjyhLGQyuPYYJOO0KtYFkTOVvy4siNK0sYD608hgk6
7Qi1gmVN5GzJiyM3rixhPLTyGCbotCPUCpY1kbMlL47cuLKE8dDKY5ig045Q
K1jWRM6WvDhy48oSxkMrj2GCTjtCrWBZEzlb8uLIjStLGA+tPIYJOu0ItYJl
TeRsyYsjN64sYTy08hgm6LQj1AqWNZGzJS+O3LiyhPHQymOYoNOOUCtY1kTO
lrw4cuPKEsZDK49hgk47Qq1gWRM5W/LiyI0rSxgPrTyGCTrtCLWCZU3kbMmL
IzeuLGE8tPIYJui0I9QKljWRsyUvjty4soTx0MpjmKDTjlArWNZEzpa8OHLj
yhLGQyuPYYJOO0KtYFkTOVvy4siNK0sYD608hgk67Qi1gmVN5GzJiyM3rixh
PLTyGCbotCPUCpY1kbMlL47cuLKE8dDKY5ig045QK1jWRM6WvDhy48oSxkMr
j2GCTjtCrWBZEzlb8uLIjStLGA+tPIYJOu0ItYJlTeRsyYsjN64sYTy08hgm
6LQj1AqWNZGzJS+O3LiyhPHQymOYoNOOUCtY1kTOlrw4cuPKEsZDK49hgk47
Qq1gWRM5W/LiyI0rSxgPrTyGCTrtCLWCZU3kbMmLIzeuLGE8tPIYJui0I9QK
ljWRsyUvjty4soTx0MpjmKDTjlArWNZEzpa8OHLjyhLGQyuPYYJOO0KtYFkT
OVvy4siNK0sYD608hgk67Qi1gmVN5GzJiyM3rixhPLTyGCbotCPUCpY1kbMl
L47cuLKE8dDKY5ig045QK1jWRM6WvDhy48oSxkMrj2GCTjtCrWBZEzlb8uI+
zg0AgAy5AQCvkBsA8ArvG1eWMB5a/64+SacdoVawrImcLXlx5MaVJYyHVh7D
BJ12hFrBsiZytuTFkRtXljAeWnkME3TaEWoFy5rI2ZIXR25cWcJ4aOUxTNBp
R6gVLGsiZ0teHLlxZQnjoZXHMEGnHaFWsKyJnC15ceTGlSWMh1YewwSddoRa
wbImcrbkxZEbV5YwHlp5DBN02hFqBcuayNmSF0duXFnCeGjlMUzQaUeoFSxr
ImdLXhy5cWUJ46GVxzBBpx2hVrCsiZwteXHkxpUljIdWHsMEnXaEWsGyJnK2
5MWRG1eWMB5aeQwTdNoRagXLmsjZkhdHblxZwnho5TFM0GlHqBUsayJnS14c
uXFlCeOhlccwQacdoVawrImcLXlx5MaVJYyHVh7DBJ12hFrBsiZytuTFkRtX
ljAeWnkME3TaEWoFy5rI2ZIXR25cWcJ4aOUxTNBpR6gVLGsiZ0teHLlxZQnj
oZXHMEGnHaFWsKyJnC15ceTGlSWMh1YewwSddoRawbImcrbkxZEbV5YwHlp5
DBN02hFqBcuayNmSF0duXFnCeGjlMUzQaUeoFSxrImdLXhy5cWUJ46GVxzBB
px2hVrCsiZwteXHkxpUljIdWHsMEnXaEWsGyJnK25MWRG1eWMB5aeQwTdNoR
agXLmsjZkhdHblxZwnho5TFM0GlHqBUsayJnS14cuXFlCeOhlccwQacdoVaw
rImcLXlx5MaVJYyHVh7DBJ12hFrBsiZytuTFkRtXljAeWnkME3TaEWoFy5rI
2ZIXR25cWcJ4aOUxTNBpR6gVLGsiZ0teHLlxZQnjoZXHMEGnHaFWsKyJnC15
ceTGlSWMh1YewwSddoRawbImcrbkxZEbV5YwHlp5DBN02hFqBcuayNmSF/dx
bgAAZMgNAHiF3ACAV8gNAHiFd9ErSxgPrX9Xn6TTjlArWNZEzpa8OHLjyhLG
QyuPYYJOO0KtYFkTOVvy4siNK0sYD608hgk67Qi1gmVN5GzJiyM3rixhPLTy
GCbotCPUCpY1kbMlL47cuLKE8dDKY5ig045QK1jWRM6WvDhy48oSxkMrj2GC
TjtCrWBZEzlb8uLIjStLGA+tPIYJOu0ItYJlTeRsyYsjN64sYTy08hgm6LQj
1AqWNZGzJS+O3LiyhPHQymOYoNOOUCtY1kTOlrw4cuPKEsZDK49hgk47Qq1g
WRM5W/LiyI0rSxgPrTyGCTrtCLWCZU3kbMmLIzeuLGE8tPIYJui0I9QKljWR
syUvjty4soTx0MpjmKDTjlArWNZEzpa8OHLjyhLGQyuPYYJOO0KtYFkTOVvy
4siNK0sYD608hgk67Qi1gmVN5GzJiyM3rixhPLTyGCbotCPUCpY1kbMlL47c
uLKE8dDKY5ig045QK1jWRM6WvDhy48oSxkMrj2GCTjtCrWBZEzlb8uLIjStL
GA+tPIYJOu0ItYJlTeRsyYsjN64sYTy08hgm6LQj1AqWNZGzJS+O3LiyhPHQ
ymOYoNOOUCtY1kTOlrw4cuPKEsZDK49hgk47Qq1gWRM5W/LiyI0rSxgPrTyG
CTrtCLWCZU3kbMmLIzeuLGE8tPIYJui0I9QKljWRsyUvjty4soTx0MpjmKDT
jlArWNZEzpa8OHLjyhLGQyuPYYJOO0KtYFkTOVvy4siNK0sYD608hgk67Qi1
gmVN5GzJiyM3rixhPLTyGCbotCPUCpY1kbMlL47cuLKE8dDKY5ig045QK1jW
RM6WvDhy48oSxkMrj2GCTjtCrWBZEzlb8uLIjStLGA+tPIYJOu0ItYJlTeRs
yYv7ODcAADLkBgC8Qm4AwCu8b1xZwnho/bv6JJ12hFrBsiZytuTFkRtXljAe
WnkME3TaEWoFy5rI2ZIXR25cWcJ4aOUxTNBpR6gVLGsiZ0teHLlxZQnjoZXH
MEGnHaFWsKyJnC15ceTGlSWMh1YewwSddoRawbImcrbkxZEbV5YwHlp5DBN0
2hFqBcuayNmSF0duXFnCeGjlMUzQaUeoFSxrImdLXhy5cWUJ46GVxzBBpx2h
VrCsiZwteXHkxpUljIdWHsMEnXaEWsGyJnK25MWRG1eWMB5aeQwTdNoRagXL
msjZkhdHblxZwnho5TFM0GlHqBUsayJnS14cuXFlCeOhlccwQacdoVawrImc
LXlx5MaVJYyHVh7DBJ12hFrBsiZytuTFkRtXljAeWnkME3TaEWoFy5rI2ZIX
x9/RA8Ar5AYAvEJuAMAr5AYAvEJuAMAr5AYAvEJuAMAr5AYAvEJuAMAr5AYA
vEJuAMAr5AYAvEJuAMAr5AYAvEJuAMAr5AYAvEJuAMAr5AYAvEJuAMAr5AYA
vEJuAMAr5AYAvEJuAMAr5AYAvEJuAMAr5AYAvEJuAMAr5AYAvEJuAMAr5AYA
vEJuAMAr5AYAvEJuAMAr5AYAvPJxbsSnEUoEtN/N0xLGQ+vf1SfptCPUCpY1
kbMlL47cuLKE8dDKY5ig045QK1jWRM6WvDhy48oSxkMrj2GCTjtCrWBZEzlb
8uLIjStLGA+tPIYJOu0ItYJlTeRsyYsjN64sYTy08hgm6LQj1AqWNZGzJS+O
3LiyhPHQymOYoNOOUCtY1kTOlrw4cuPKEsZDK49hgk47Qq1gWRM5W/LiyI0r
SxgPrTyGCTrtCLWCZU3kbMmLIzeuLGE8tPIYJui0I9QKljWRsyUvjty4soTx
0MpjmKDTjlArWNZEzpa8OHLjyhLGQyuPYYJOO0KtYFkTOVvy4siNK0sYD608
hgk67Qi1gmVN5GzJiyM3rixhPLTyGCbotCPUCpY1kbMlL47cuLKE8dDKY5ig
045QK1jWRM6WvDhy48oSxkMrj2GCTjtCrWBZEzlb8uLIjStLGA+tPIYJOu0I
tYJlTeRsyYsjN64sYTy08hgm6LQj1AqWNZGzJS+O//cFAK+QGwDwCrkBAK+Q
GwDwCu+iV5YwHlr/rj5Jpx2hVrCsiZwteXHkxpUljIdWHsMEnXaEWsGyJnK2
5MWRG1eWMB5aeQwTdNoRagXLmsjZkhdHblxZwnho5TFM0GlHqBUsayJnS14c
uXFlCeOhlccwQacdoVawrImcLXlx5MaVJYyHVh7DBJ12hFrBsiZytuTFkRtX
ljAeWnkME3TaEWoFy5rI2ZIXR25cWcJ4aOUxTNBpR6gVLGsiZ0teHLlxZQnj
oZXHMEGnHaFWsKyJnC15ceTGlSWMh1YewwSddoRawbImcrbkxZEbV5YwHlp5
DBN02hFqBcuayNmSF0duXFnCeGjlMUzQaUeoFSxrImdLXhy5cWUJ46GVxzBB
px2hVrCsiZwteXHkxpUljIdWHsMEnXaEWsGyJnK25MWRG1eWMB5aeQwTdNoR
agXLmsjZkhdHblxZwnho5TFM0GlHqBUsayJnS14cuXFlCeOhlccwQacdoVaw
rImcLXlx5MaVJYyHVh7DBJ12hFrBsiZytuTFkRtXljAeWnkME3TaEWoFy5rI
2ZIXR25cWcJ4aOUxTNBpR6gVLGsiZ0teHLlxZQnjoZXHMEGnHaFWsKyJnC15
ceTGlSWMh1YewwSddoRawbImcrbkxZEbV5YwHlp5DBN02hFqBcuayNmSF0du
XFnCeGjlMUzQaUeoFSxrImdLXhy5cWUJ46GVxzBBpx2hVrCsiZwteXHkxpUl
jIdWHsMEnXaEWsGyJnK25MWRG1eWMB5aeQwTdNoRagXLmsjZkhdHblxZwnho
5TFM0GlHqBUsayJnS14cuXFlCeOhlccwQacdoVawrImcLXlx5MaVJYyHVh7D
BJ12hFrBsiZytuTFkRtXljAeWnkME3TaEWoFy5rI2ZIX93FuAABkyA0AeIXc
AIBXeN+4soTx0Pp39Uk67Qi1gmVN5GzJiyM3rixhPLTyGCbotCPUCpY1kbMl
L47cuLKE8dDKY5ig045QK1jWRM6WvDhy48oSxkMrj2GCTjtCrWBZEzlb8uLI
jStLGA+tPIYJOu0ItYJlTeRsyYsjN64sYTy08hgm6LQj1AqWNZGzJS+O3Liy
hPHQymOYoNOOUCtY1kTOlrw4cuPKEsZDK49hgk47Qq1gWRM5W/LiyI0rSxgP
rTyGCTrtCLWCZU3kbMmLIzeuLGE8tPIYJui0I9QKljWRsyUvjty4soTx0Mpj
mKDTjlArWNZEzpa8OHLjyhLGQyuPYYJOO0KtYFkTOVvy4siNK0sYD608hgk6
7Qi1gmVN5GzJiyM3rixhPLTyGCbotCPUCpY1kbMlL47cuLKE8dDKY5ig045Q
K1jWRM6WvDhy48oSxkMrj2GCTjtCrWBZEzlb8uLIjStLGA+tPIYJOu0ItYJl
TeRsyYsjN64sYTy08hgm6LQj1AqWNZGzJS+O3LiyhPHQymOYoNOOUCtY1kTO
lrw4cuPKEsZDK49hgk47Qq1gWRM5W/LiyI0rSxgPrTyGCTrtCLWCZU3kbMmL
IzeuLGE8tPIYJui0I9QKljWRsyUvjty4soTx0MpjmKDTjlArWNZEzpa8OHLj
yhLGQyuPYYJOO0KtYFkTOVvy4siNK0sYD608hgk67Qi1gmVN5GzJiyM3rixh
PLTyGCbotCPUCpY1kbMlL47cuLKE8dDKY5ig045QK1jWRM6WvDhy48oSxkMr
j2GCTjtCrWBZEzlb8uLIjStLGA+tPIYJOu0ItYJlTeRsyYsjN64sYTy08hgm
6LQj1AqWNZGzJS+O3LiyhPHQymOYoNOOUCtY1kTOlry4j3MDACBDbgDAK+QG
ALzC+8aVJYyH1r+rT9JpR6gVLGsiZ0teHLlxZQnjoZXHMEGnHaFWsKyJnC15
ceTGlSWMh1YewwSddoRawbImcrbkxZEbV5YwHlp5DBN02hFqBcuayNmSF0du
XFnCeGjlMUzQaUeoFSxrImdLXhy5cWUJ46GVxzBBpx2hVrCsiZwteXHkxpUl
jIdWHsMEnXaEWsGyJnK25MWRG1eWMB5aeQwTdNoRagXLmsjZkhdHblxZwnho
5TFM0GlHqBUsayJnS14cuXFlCeOhlccwQacdoVawrImcLXlx5MaVJYyHVh7D
BJ12hFrBsiZytuTFkRtXljAeWnkME3TaEWoFy5rI2ZIXR25cWcJ4aOUxTNBp
R6gVLGsiZ0teHLlxZQnjoZXHMEGnHaFWsKyJnC15ceTGlSWMh1YewwSddoRa
wbImcrbkxZEbV5YwHlp5DBN02hFqBcuayNmSF0duXFnCeGjlMUzQaUeoFSxr
ImdLXhy5cWUJ46GVxzBBpx2hVrCsiZwteXHkxpUljIdWHsMEnXaEWsGyJnK2
5MWRG1eWMB5aeQwTdNoRagXLmsjZkhdHblxZwnho5TFM0GlHqBUsayJnS14c
uXFlCeOhlccwQacdoVawrImcLXlx5MaVJYyHVh7DBJ12hFrBsiZytuTFkRtX
ljAeWnkME3TaEWoFy5rI2ZIXR25cWcJ4aOUxTNBpR6gVLGsiZ0teHLlxZQnj
oZXHMEGnHaFWsKyJnC15ceTGlSWMh1YewwSddoRawbImcrbkxZEbV5YwHlp5
DBN02hFqBcuayNmSF0duXFnCeGjlMUzQaUeoFSxrImdLXhy5cWUJ46GVxzBB
px2hVrCsiZwteXHkxpUljIdWHsMEnXaEWsGyJnK25MV9nBsAABlyAwBeITcA
4BVyAwBe4V30yhLGQ+vf1SfptCPUCpY1kbMlL47cuLKE8dDKY5ig045QK1jW
RM6WvDhy48oSxkMrj2GCTjtCrWBZEzlb8uLIjStLGA+tPIYJOu0ItYJlTeRs
yYsjN64sYTy08hgm6LQj1AqWNZGzJS+O3LiyhPHQymOYoNOOUCtY1kTOlrw4
cuPKEsZDK49hgk47Qq1gWRM5W/LiyI0rSxgPrTyGCTrtCLWCZU3kbMmLIzeu
LGE8tPIYJui0I9QKljWRsyUvjty4soTx0MpjmKDTjlArWNZEzpa8OHLjyhLG
QyuPYYJOO0KtYFkTOVvy4siNK0sYD608hgk67Qi1gmVN5GzJiyM3rixhPLTy
GCbotCPUCpY1kbMlL47cuLKE8dDKY5ig045QK1jWRM6WvDhy48oSxkMrj2GC
TjtCrWBZEzlb8uLIjStLGA+tPIYJOu0ItYJlTeRsyYsjN64sYTy08hgm6LQj
1AqWNZGzJS+O//cFAK+QGwDwCrkBAK+QGwDwCrkBAK+QGwDwyv9yAwDg81xH
FwD8X/IfrCCnTg==
            "], {{0, 359}, {360, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{360, 359},
          PlotRange->{{0, 360}, {0, 359}}]], "ExerciseOutput",
         ImageSize->{364, 359},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "41f1d812-2234-4681-9e5c-bf672ba07df0"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztnM9qOGYRRUfduPQVfAu3Lt1WfIAW2+qmQiuIT19/RXAzQ8h3h5m5wjmQ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              "], {{0, 359}, {360, 0}}, {0, 255}, 
              ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {360, 359}, 
            PlotRange -> {{0, 360}, {0, 359}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"8aabb6d9-4602-409c-a84a-e5521e80febe"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["x28.7"], StandardForm],
   ImageSizeCache->{145., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"5f080044-0761-445d-96e6-57e7da658589"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"27a90b57-ec35-4dd0-bd9a-b3b1c7b882a0"]
}, Open  ]]
}, Open  ]],

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"67363b31-92aa-483d-8e90-aba6faf7e546"]
},
WindowSize->{808, 755},
WindowMargins->{{314, Automatic}, {Automatic, 50}},
WindowTitle->"Tests and Conditionals: Elementary Introduction to the Wolfram \
Language",
DockedCells->{
  Cell[
   BoxData[
    DynamicModuleBox[{}, 
     TagBox[
      GridBox[{{
         TagBox[
          ButtonBox[
           PaneBox[
            GraphicsBox[
             TagBox[
              RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UFAEiEGSIPafvQ3/iQM/qxmAiEjFmOohXKwIouDvuQXEGw4xENM6POaT5Hiq
qP97c+uvfvWfDVy/59j/ahX5Pdfx3/sHuNSDFE/UBpI/G3l+TTP9vS7p7+nZ
QBG4FjT1QJOBin+vCAcpaxcHWgEU/HOk7/ciHzzqgSYD2b/XJQO5UPFueezq
J+sDFf/qVQY64PeSgN8b0n5NMfz34DAu9T+beIFm/upV+jXF4PcC9z87K4C6
fk3SwaUeGBq/18QDDQQ5e2f5rw6pP0f7gd4BCmJVD3QG0HygBxHO61UG6sIV
nhAtwNAAOgCEgOEPMxmXevyAEvV4EidaQiU+P0IAAEIjNUM=
               "], {{0, 
               20}, {16, 0}}, {0, 255}, ColorFunction -> RGBColor], 
              BoxForm`ImageTag[
              "Byte", ColorSpace -> ColorProfileData[CompressedData["
1:eJydlndcFNcWx+/MbC+0XZYiZem9twVEehOQXkVh2V1gKQsuuxTFhogKRBQR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                 "], "RGB", "XYZ"], 
               Interleaving -> True], Selectable -> False], DefaultBaseStyle -> 
             "ImageGraphics", ImageSizeRaw -> {16, 20}, 
             PlotRange -> {{0, 16}, {0, 20}}], Alignment -> {Center, Center}, 
            ImageMargins -> {{15, 10}, {4, 0}}], Appearance -> None, 
           ButtonFunction :> NotebookLocate[{
              URL["http://www.wolfram.com/language/elementary-introduction/"],
               None}], Evaluator -> Automatic, Method -> "Preemptive"], 
          MouseAppearanceTag["LinkHand"]], 
         ItemBox[
          TagBox[
           GridBox[{{
              TagBox[
               ButtonBox[
                StyleBox[
                "STEPHEN WOLFRAM Elementary Introduction to the Wolfram \
Language", "DockedCellAuthorName"], Appearance -> None, ButtonFunction :> 
                NotebookLocate[{
                   URL[
                   "http://www.wolfram.com/language/elementary-introduction/"]\
, None}], Evaluator -> Automatic, Method -> "Preemptive"], 
               MouseAppearanceTag["LinkHand"]]}, {
              TagBox[
               ButtonBox[
                TemplateBox[{
                  StyleBox["Exercises ", "DockedCellSectionTitle"], 
                  StyleBox["|", "DockedCellSectionTitleDivider"], 
                  StyleBox[
                  " 28  Tests and Conditionals", "DockedCellSectionTitle"]}, 
                 "RowDefault"], Appearance -> None, ButtonFunction :> 
                NotebookLocate[{
                   URL[
                   "http://www.wolfram.com/language/elementary-introduction/\
28-tests-and-conditionals.html"], None}], Evaluator -> Automatic, Method -> 
                "Preemptive"], 
               MouseAppearanceTag["LinkHand"]]}}, DefaultBaseStyle -> 
            "Column", GridBoxAlignment -> {"Columns" -> {{Left}}}, 
            GridBoxSpacings -> {"Columns" -> {{0}}, "Rows" -> {{0}}}], 
           "Column"], Alignment -> Left, ItemSize -> 30]}}, AutoDelete -> 
       False, GridBoxSpacings -> {"Columns" -> {{0}}, "Rows" -> {{0}}}, 
       GridBoxAlignment -> {"Columns" -> {Left}, "Rows" -> {Center}}, 
       GridBoxItemSize -> {
        "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], "Grid"], 
     DynamicModuleValues :> {}, 
     Initialization :> (
      Clear[$CellContext`SolutionResponseText]; \
$CellContext`SolutionResponseText[
         Pattern[ElementaryIntroToWLWeb`Private`a, 
          BlankNullSequence[]]] := " "; 
      Map[($CellContext`SolutionResponseText[#] := " ")& , {
        "+28.1", "28.1", "28.10", "28.11", "28.12", "28.13", "+28.2", "28.2", 
         "+28.3", "28.3", "+28.4", "28.4", "+28.5", "28.5", "+28.6", "28.6", 
         "+28.7", "28.7", "28.8", "28.9"}]; 
      Clear[$CellContext`SolutionResponseDetails]; \
$CellContext`SolutionResponseDetails[
         Pattern[ElementaryIntroToWLWeb`Private`str, 
          Blank[String]], True] := 
       Style[ElementaryIntroToWLWeb`Private`str, 
         "SolutionTrue"]; $CellContext`SolutionResponseDetails[
         Pattern[ElementaryIntroToWLWeb`Private`str, 
          Blank[String]], False] := 
       Style[ElementaryIntroToWLWeb`Private`str, 
         "SolutionFalse"]; $CellContext`SolutionResponseDetails[
         Pattern[ElementaryIntroToWLWeb`Private`str, 
          Blank[String]]] := 
       ElementaryIntroToWLWeb`Private`str; \
$CellContext`SolutionResponseDetails[
         Missing[
          BlankSequence[]]] := " "; $CellContext`SolutionResponseDetails[
         BlankNullSequence[]] := " "; 
      Clear[$CellContext`GetUserSolutions]; $CellContext`GetUserSolutions[] := 
       Flatten[
         Cases[
          Options[
           EvaluationNotebook[], TaggingRules], ("EIWLExercises" -> 
           Pattern[ElementaryIntroToWLWeb`Private`ex, 
             Blank[]]) :> ElementaryIntroToWLWeb`Private`ex, Infinity]]; 
      Clear[$CellContext`GetUserSolutionsTotal]; \
$CellContext`GetUserSolutionsTotal[] := Length[
         Union[
          Flatten[
           Cases[
            Cases[
             Options[
              EvaluationNotebook[], TaggingRules], ("EIWLExercises" -> 
              Pattern[ElementaryIntroToWLWeb`Private`ex, 
                Blank[]]) :> ElementaryIntroToWLWeb`Private`ex, Infinity], (
             "ExercisesTotal" -> Pattern[ElementaryIntroToWLWeb`Private`t, 
               Blank[]]) :> ElementaryIntroToWLWeb`Private`t, Infinity]]]]; 
      Clear[$CellContext`GetUserSolutionsTried]; \
$CellContext`GetUserSolutionsTried[] := Length[
         Union[
          Flatten[
           Cases[
            Cases[
             Options[
              EvaluationNotebook[], TaggingRules], ("EIWLExercises" -> 
              Pattern[ElementaryIntroToWLWeb`Private`ex, 
                Blank[]]) :> ElementaryIntroToWLWeb`Private`ex, Infinity], (
             "ExercisesTried" -> Pattern[ElementaryIntroToWLWeb`Private`t, 
               Blank[]]) :> ElementaryIntroToWLWeb`Private`t, Infinity]]]]; 
      Clear[$CellContext`GetUserSolutionsCorrect]; \
$CellContext`GetUserSolutionsCorrect[] := Length[
         Union[
          Flatten[
           Cases[
            Cases[
             Options[
              EvaluationNotebook[], TaggingRules], ("EIWLExercises" -> 
              Pattern[ElementaryIntroToWLWeb`Private`ex, 
                Blank[]]) :> ElementaryIntroToWLWeb`Private`ex, Infinity], (
             "ExercisesCorrect" -> Pattern[ElementaryIntroToWLWeb`Private`t, 
               Blank[]]) :> ElementaryIntroToWLWeb`Private`t, 
            Infinity]]]]; $CellContext`EIWLExerciseSolutionsTotal = \
$CellContext`GetUserSolutionsTotal[]; $CellContext`EIWLExerciseSolutionsTried = \
$CellContext`GetUserSolutionsTried[]; \
$CellContext`EIWLExerciseSolutionsCorrect = \
$CellContext`GetUserSolutionsCorrect[]; 
      Clear[$CellContext`SetUserSolutionsTried]; \
$CellContext`SetUserSolutionsTried[
         Pattern[ElementaryIntroToWLWeb`Private`value, 
          Blank[]]] := 
       Module[{ElementaryIntroToWLWeb`Private`data, 
          ElementaryIntroToWLWeb`Private`tr}, 
         ElementaryIntroToWLWeb`Private`data = Flatten[
            Cases[
             Options[
              EvaluationNotebook[], TaggingRules], ("EIWLExercises" -> 
              Pattern[ElementaryIntroToWLWeb`Private`ex, 
                Blank[]]) :> ElementaryIntroToWLWeb`Private`ex, Infinity]]; 
         ElementaryIntroToWLWeb`Private`tr = ReplaceAll[TaggingRules, 
            Options[
             EvaluationNotebook[], TaggingRules]]; 
         ElementaryIntroToWLWeb`Private`tr = 
          DeleteCases[
           ElementaryIntroToWLWeb`Private`tr, "EIWLExercises" -> Blank[], 
            Infinity]; 
         AppendTo[
          ElementaryIntroToWLWeb`Private`tr, 
           "EIWLExercises" -> {
            "ExercisesTotal" -> 
             ReplaceAll[
              "ExercisesTotal", ElementaryIntroToWLWeb`Private`data], 
             "ExercisesTried" -> Append[
               Flatten[
                Cases[
                ElementaryIntroToWLWeb`Private`data, ("ExercisesTried" -> 
                  Pattern[ElementaryIntroToWLWeb`Private`t, 
                    Blank[]]) :> ElementaryIntroToWLWeb`Private`t, Infinity]],
                ElementaryIntroToWLWeb`Private`value], "ExercisesCorrect" -> 
             ReplaceAll[
              "ExercisesCorrect", ElementaryIntroToWLWeb`Private`data]}]; 
         SetOptions[
           EvaluationNotebook[], TaggingRules -> 
           ElementaryIntroToWLWeb`Private`tr]; \
$CellContext`EIWLExerciseSolutionsTried = \
$CellContext`GetUserSolutionsTried[]; Null]; 
      Clear[$CellContext`SetUserSolutionsCorrect]; \
$CellContext`SetUserSolutionsCorrect[
         Pattern[ElementaryIntroToWLWeb`Private`value, 
          Blank[]]] := 
       Module[{ElementaryIntroToWLWeb`Private`data, 
          ElementaryIntroToWLWeb`Private`tr}, 
         ElementaryIntroToWLWeb`Private`data = Flatten[
            Cases[
             Options[
              EvaluationNotebook[], TaggingRules], ("EIWLExercises" -> 
              Pattern[ElementaryIntroToWLWeb`Private`ex, 
                Blank[]]) :> ElementaryIntroToWLWeb`Private`ex, Infinity]]; 
         ElementaryIntroToWLWeb`Private`tr = ReplaceAll[TaggingRules, 
            Options[
             EvaluationNotebook[], TaggingRules]]; 
         ElementaryIntroToWLWeb`Private`tr = 
          DeleteCases[
           ElementaryIntroToWLWeb`Private`tr, "EIWLExercises" -> Blank[], 
            Infinity]; 
         AppendTo[
          ElementaryIntroToWLWeb`Private`tr, 
           "EIWLExercises" -> {
            "ExercisesTotal" -> 
             ReplaceAll[
              "ExercisesTotal", ElementaryIntroToWLWeb`Private`data], 
             "ExercisesTried" -> 
             ReplaceAll[
              "ExercisesTried", ElementaryIntroToWLWeb`Private`data], 
             "ExercisesCorrect" -> Append[
               Flatten[
                Cases[
                ElementaryIntroToWLWeb`Private`data, ("ExercisesCorrect" -> 
                  Pattern[ElementaryIntroToWLWeb`Private`t, 
                    Blank[]]) :> ElementaryIntroToWLWeb`Private`t, Infinity]],
                ElementaryIntroToWLWeb`Private`value]}]; SetOptions[
           EvaluationNotebook[], TaggingRules -> 
           ElementaryIntroToWLWeb`Private`tr]; \
$CellContext`EIWLExerciseSolutionsCorrect = \
$CellContext`GetUserSolutionsCorrect[]; Null]; 
      Clear[ElementaryIntroToWLWeb`Private`GetCurrentTallyCell]; \
$CellContext`GetCurrentTallyCell[] := Module[{}, 
         With[{
          ElementaryIntroToWLWeb`Private`solutionsTried = \
$CellContext`GetUserSolutionsTried[], 
           ElementaryIntroToWLWeb`Private`solutionsTotal = \
$CellContext`GetUserSolutionsTotal[], 
           ElementaryIntroToWLWeb`Private`solutionsCorrect = \
$CellContext`GetUserSolutionsCorrect[]}, 
          Cell[
           BoxData[
            PaneBox[
             TemplateBox[{
               StyleBox[
               "COMPLETED\[ThickSpace]\[ThickSpace]", 
                "DockedCellCompletedExerciseText"], 
               StyleBox[
               ElementaryIntroToWLWeb`Private`solutionsTried, 
                "DockedCellCompletedExerciseText"], 
               StyleBox["/", "DockedCellSolutionDivider"], 
               StyleBox[
               ElementaryIntroToWLWeb`Private`solutionsTotal, 
                "DockedCellCompletedExerciseText"], 
               StyleBox[
               "\[ThinSpace]|\[ThinSpace]", "DockedCellSolutionDivider"], 
               StyleBox[
               ElementaryIntroToWLWeb`Private`solutionsCorrect, 
                "DockedCellCorrectExerciseText"], 
               StyleBox[
               "\[ThickSpace]\[ThickSpace]CORRECT", 
                "DockedCellCorrectExerciseText"]}, "RowDefault"], Alignment -> 
             Right, ImageSize -> Full]], "Output", TextAlignment -> Right, 
           CellFrame -> 1, CellMargins -> {{0, 0}, {10, 0}}, 
           CellFrameMargins -> {{14, 24}, {4, 7}}, CellFrameColor -> 
           RGBColor[1, 0.956862, 0.878431], MenuSortingValue -> 10000, 
           Background -> RGBColor[1, 0.956862, 0.878431], CellTags -> 
           "SolutionTallyCell"]]])]], "Output", CellMargins -> 0, 
   CellFrameMargins -> {{0, 24}, {3, 6}}, Background -> 
   RGBColor[0.97647, 0.482352, 0], CellFrame -> 1, CellFrameColor -> 
   RGBColor[0.97647, 0.482352, 0]], 
  Cell["SECOND EDITION", "Text", FontFamily -> "Source Sans Pro", 
   CellFrame -> {{0, 0}, {3, 0}}, ShowCellBracket -> False, 
   CellMargins -> {{0, 0}, {-1, -1}}, CellFrameMargins -> {{44, 0}, {2, 4}}, 
   CellFrameColor -> RGBColor[0.952941, 0.509804, 0], FontSize -> 10, 
   FontTracking -> "Extended", FontColor -> RGBColor[1, 0.929412, 0.721569], 
   Background -> RGBColor[0.862745, 0.309804, 0], CellTags -> 
   "DockedCellLogoCell"]},
TaggingRules->{
 "EIWLExercises" -> {
   "ExercisesTotal" -> {
     "+28.1", "28.1", "28.10", "28.11", "28.12", "28.13", "+28.2", "28.2", 
      "+28.3", "28.3", "+28.4", "28.4", "+28.5", "28.5", "+28.6", "28.6", 
      "+28.7", "28.7", "28.8", "28.9"}, "ExercisesTried" -> {}, 
    "ExercisesCorrect" -> {}}},
FrontEndVersion->"11.1 for Mac OS X x86 (32-bit, 64-bit Kernel) (April 18, \
2017)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[StyleDefinitions -> "Default.nb"]], 
   Cell[
    CellGroupData[{
      Cell[
      "Style Environments", "Section", 
       CellChangeTimes -> {{3.64661165091824*^9, 3.646611654013329*^9}, 
         3.6485723794335403`*^9, 3.651347081728628*^9, 3.651347179462186*^9, 
         3.651347384135805*^9, 3.651348171662589*^9, {3.662385415502224*^9, 
         3.662385415587447*^9}, {3.662385986094821*^9, 
         3.662385986340312*^9}, {3.662386515144682*^9, 
         3.662386515438078*^9}, {3.662386561676188*^9, 
         3.662386561889332*^9}, {3.668356126688795*^9, 
         3.6683561270120687`*^9}, {3.670169943059537*^9, 
         3.670169943254141*^9}}], 
      Cell[
       StyleData[All, "Working"]], 
      Cell[
       StyleData[All, "Printout"], 
       PrintingOptions -> {
        "PageSize" -> {504, 720}, "PrintRegistrationMarks" -> True}, 
       Magnification -> 0.6]}, Closed]], 
   Cell[
    CellGroupData[{
      Cell[
      "Custom Styles", "Section", 
       CellChangeTimes -> {{3.646611660445352*^9, 3.646611669493331*^9}}], 
      Cell[
       StyleData["Notebook"], CreateCellID -> True, CellContext -> Notebook, 
       CellLabelAutoDelete -> False, DefaultNewCellStyle -> "Input", 
       ShowSyntaxStyles -> True, MenuSortingValue -> None], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Title"], CellMargins -> {{64, Inherited}, {50, 72}}, 
          MenuCommandKey -> None, FontFamily -> "Verdana", FontSize -> 42, 
          FontWeight -> "Bold", FontColor -> GrayLevel[0.4]], 
         Cell[
          StyleData["Title", "Printout"], 
          CellMargins -> {{64, Inherited}, {50, 72}}]}, Closed]], 
      Cell[
       StyleData["Chapter"], MenuCommandKey -> None], 
      Cell[
       StyleData["Subchapter"], MenuCommandKey -> None], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Section"], CellFrame -> {{0, 0}, {0, 0}}, CellDingbat -> 
          Cell[
            TextData[
             CounterBox["Section"], 
             StyleBox[
             "|\[NegativeThinSpace]", FontColor -> 
              RGBColor[
               0.9019607843137255, 0.4117647058823529, 0.027450980392156862`],
               FontFamily -> "Courier", FontSize -> 36, FontWeight -> Plain]],
             "SectionNumber"], CellMargins -> {{96, Inherited}, {12, 64}}, 
          Evaluatable -> True, CellGroupingRules -> {"SectionGrouping", 60}, 
          PageBreakAbove -> True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["Section", "Printout"], 
          CellMargins -> {{96, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionDoubleDigit"], CellFrame -> {{0, 0}, {0, 0}}, 
          CellDingbat -> Cell[
            TextData[
             CounterBox["Section"], 
             StyleBox[
             "|\[NegativeThinSpace]", FontColor -> 
              RGBColor[
               0.9019607843137255, 0.4117647058823529, 0.027450980392156862`],
               FontFamily -> "Courier", FontSize -> 36, FontWeight -> Plain]],
             "SectionNumber"], CellMargins -> {{112, Inherited}, {12, 64}}, 
          Evaluatable -> True, CellGroupingRules -> {"SectionGrouping", 60}, 
          PageBreakAbove -> True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["SectionDoubleDigit", "Printout"], 
          CellMargins -> {{112, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionNumber"], CellBaseline -> Baseline, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 26, FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SectionNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionInline"], FontFamily -> 
          "Source Sans Pro Semibold", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SectionInline", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionNoDingbat"], 
          CellMargins -> {{64, Inherited}, {12, 64}}, Evaluatable -> True, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakAbove -> 
          True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["SectionNoDingbat", "Printout"], 
          CellMargins -> {{64, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Exercise"], CellDingbat -> Cell[
            TextData[{"  ", 
              CounterBox["Section"], ".", 
              CounterBox["Exercise"]}], "ExerciseNumber", FontColor -> 
            RGBColor[
             0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
          ShowGroupOpener -> True, CellMargins -> {{90, 40}, {4, 18}}, 
          CellGroupingRules -> "InputGrouping", CounterIncrements -> 
          "Exercise", MenuSortingValue -> 10020, MenuCommandKey -> "2", 
          FontFamily -> "Source Sans Pro", FontSize -> 16, FontWeight -> 
          "Plain", FontSlant -> "Plain", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["Exercise", "Printout"], ShowGroupOpener -> False, 
          CellMargins -> {{110, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseNumber"], FontFamily -> "Source Sans Pro", 
          FontSize -> 16, FontWeight -> "Bold", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["ExerciseNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseInput", StyleDefinitions -> StyleData["Input"]], 
          CellMargins -> {{70, 30}, {4, 7}}, ShowCellLabel -> False, 
          CellFrameLabels -> {{None, None}, {None, None}}, SpanMaxSize -> 1, 
          FontSize -> 
          14, $CellContext`GeneratedCellStyles -> {
           "Output" -> "ExerciseOutput"}], 
         Cell[
          StyleData["ExerciseInput", "Printout"], 
          CellMargins -> {{88, 10}, {4, 7}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "ExerciseOutput", StyleDefinitions -> StyleData["Output"]], 
          CellMargins -> {{90, 40}, {0, 6}}, CellGroupingRules -> 
          "OutputGrouping", ShowCellLabel -> False, FontSize -> 14], 
         Cell[
          StyleData["ExerciseOutput", "Printout"], 
          CellMargins -> {{88, 10}, {10, 4}}]}, Closed]], 
      Cell[
       StyleData["ExerciseExpectedResult"], ShowCellBracket -> False, 
       ShowGroupOpener -> False, CellMargins -> {{90, 40}, {3, 9}}, 
       CellGroupingRules -> "InputGrouping", CounterIncrements -> "Exercise", 
       MenuSortingValue -> 10000, FontFamily -> "Source Sans Pro", FontSize -> 
       12, FontWeight -> "Plain", FontSlant -> "Plain"], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Picture"], CellMargins -> {{66, 10}, {10, 10}}, 
          CellGroupingRules -> "GraphicsGrouping", StyleMenuListing -> None], 
         
         Cell[
          StyleData["Picture", "Printout"], 
          CellMargins -> {{66, 10}, {8, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Tentative"], 
          CellBracketOptions -> {
           "Color" -> RGBColor[
             0.30000000000000016`, 0.6000000000000003, 0.7000000000000003], 
            "Thickness" -> 5}, Evaluatable -> False, CellFrameMargins -> 4, 
          StyleMenuListing -> None, Background -> 
          RGBColor[0.8500000000000003, 0.9500000000000003, 1]], 
         Cell[
          StyleData["Tentative", "Printout"], 
          CellElementSpacings -> {"CellMinHeight" -> 0.1}, CellOpen -> False, 
          CellFrameMargins -> 0, FontSize -> 0.1, Magnification -> 0.01]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["WebOnly"], 
          CellBracketOptions -> {
           "Color" -> RGBColor[0.91, 0.92, 0.9], "Thickness" -> 5}, 
          CellFrameMargins -> 4, StyleMenuListing -> None, Background -> 
          RGBColor[0.91, 0.92, 0.86]], 
         Cell[
          StyleData["WebOnly", "Printout"], 
          CellElementSpacings -> {"CellMinHeight" -> 0.1}, CellOpen -> False, 
          CellFrameMargins -> 0, FontSize -> 0.1, Magnification -> 0.01]}, 
        Closed]], 
      Cell[
       StyleData["Lockdown"], 
       CellBracketOptions -> {
        "Color" -> RGBColor[0.8, 0.5, 0.4], "Thickness" -> 3}, Evaluatable -> 
       False, StyleMenuListing -> None], 
      Cell[
       StyleData["InlineCode"], SpanMaxSize -> 0, FontColor -> GrayLevel[0]], 
      
      Cell[
       StyleData["ExpectedOutputNote"], Selectable -> False, FontFamily -> 
       "Source Sans Pro", FontColor -> GrayLevel[0.3]], 
      Cell[
       StyleData["EIWLTextLink"], LineBreakWithin -> False, 
       TemplateBoxOptions -> {DisplayFunction :> (TagBox[
           
           ButtonBox[#, Appearance -> None, ButtonData -> #2, 
            BaseStyle -> {
             "Hyperlink", FontWeight -> Bold, FontSize -> 16, FontFamily -> 
              "Source Sans Pro"}], 
           MouseAppearanceTag["LinkHand"]]& )}, 
       ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
      Cell[
       StyleData["CheckAnswerDividerCloud"], ShowCellBracket -> False, 
       CellMargins -> {{40, 40}, {3, 6}}, 
       CellBracketOptions -> {"OverlapContent" -> True}, 
       CellGroupingRules -> {"SectionGrouping", 40}, 
       CellFrameMargins -> {{20, 20}, {2, 2}}, TextAlignment -> Right], 
      Cell[
       StyleData["CodeSectionDividerCloud"], Editable -> False, Selectable -> 
       False, ShowCellBracket -> False, CellMargins -> {{0, 0}, {0, 35}}, 
       CellBracketOptions -> {"OverlapContent" -> True}, 
       CellElementSpacings -> {"CellMinHeight" -> 6}, 
       CellGroupingRules -> {"SectionGrouping", -5}, 
       CellFrameMargins -> {{20, 20}, {2, 2}}, DefaultNewCellStyle -> "Input",
        FontSize -> 6, Background -> GrayLevel[0.95]], 
      Cell[
       StyleData["InlineCode"], SpanMaxSize -> 0, FontColor -> GrayLevel[0]], 
      
      Cell[
       StyleData["InlineCodeText"], SpanMaxSize -> 0, FontFamily -> 
       "Source Sans Pro"], 
      Cell[
       StyleData["Input"], CellMargins -> {{92, 20}, {5, 8}}, 
       CellFrameLabels -> {{None, 
          
          DynamicModuleBox[{$CellContext`EIWLExerciseCheck = 
            Automatic, $CellContext`buttonLabel = " CHECK MY SOLUTION "}, 
           DynamicBox[
            ToBoxes[
             If[
              TrueQ[$CellContext`EIWLExerciseCheck == Automatic], 
              MouseAppearance[
               Tooltip[
                Button[
                 Framed[
                  Panel[
                   
                   Style[$CellContext`buttonLabel, FontFamily -> 
                    "Source Sans Pro", FontSize -> 10, FontColor -> 
                    RGBColor[0.953948, 0.305638, 0.0285344]], Appearance -> 
                   None, Background -> GrayLevel[1], 
                   FrameMargins -> {{2, 2}, {0, 0}}, ImageMargins -> 0], 
                  FrameStyle -> {
                    Thickness[Tiny], 
                    RGBColor[0.953948, 0.305638, 0.0285344]}, RoundingRadius -> 
                  3], 
                 
                 Block[{$CellContext`usersCell, $CellContext`solutionResult, \
$CellContext`exerciseNumber, $CellContext`exerciseSwitchResult}, \
$CellContext`exerciseNumber = StringJoin[
                    If[
                    TrueQ[CurrentValue[{"CounterValue", "WebOnly"}] == 1], 
                    "x", ""], 
                    ToString[
                    CurrentValue[{"CounterValue", "SectionNumber"}]], ".", 
                    ToString[
                    
                    CurrentValue[{
                    "CounterValue", 
                    "ExerciseNumber"}]]]; $CellContext`buttonLabel = 
                   Row[{" CHECKING ", 
                    ProgressIndicator[Appearance -> "Percolate"]}]; 
                  SelectionMove[
                    ButtonNotebook[], All, ButtonCell, AutoScroll -> 
                    False]; $CellContext`usersCell = NotebookRead[
                    InputNotebook[]]; If[
                    TrueQ[Length[
                    Flatten[{$CellContext`usersCell}]] == 
                    1], $CellContext`solutionResult = ToExpression[
                    URLFetch[
                    "https://www.wolframcloud.com/objects/user-9b23d046-b2a9-\
4a5c-8723-08465cce25ed/EIWLGradingAPI", "Method" -> "POST", 
                    "Parameters" -> {
                    "exNum" -> $CellContext`exerciseNumber, "answer" -> 
                    ToString[$CellContext`usersCell, InputForm, 
                    CharacterEncoding -> "ASCII"], "user" -> 
                    ToString[$WolframID], "referer" -> "eiwl-nb", "uuid" -> 
                    ToString[$WolframUUID]}]]; \
$CellContext`SolutionResponseText[$CellContext`exerciseNumber] = \
$CellContext`SolutionResponseDetails[
                    $CellContext`solutionResult["Text"], 
                    $CellContext`solutionResult[
                    "CorrectQ"]]; $CellContext`exerciseSwitchResult = Switch[
                    $CellContext`solutionResult["CorrectQ"], 
                    True, $CellContext`EIWLExerciseCheck = 
                    True; $CellContext`SetUserSolutionsCorrect[$CellContext`\
exerciseNumber]; \
$CellContext`SetUserSolutionsTried[$CellContext`exerciseNumber]; Null, 
                    
                    Blank[], $CellContext`EIWLExerciseCheck = 
                    False; $CellContext`SetUserSolutionsTried[$CellContext`\
exerciseNumber]], 
                    CloudSystem`CreateCloudDialog[
                    StyleBox[
                    "Select a cell to be checked.", Selectable -> False], 
                    WindowTitle -> " "]]], Appearance -> None, Evaluator -> 
                 Automatic, Method -> "Queued"], 
                "Click to check your solution.", TooltipDelay -> 0.15], 
               "LinkHand"], 
              If[
               TrueQ[$CellContext`EIWLExerciseCheck], 
               MouseAppearance[
                Button[
                 Framed[
                  Row[{
                    Panel[
                    Style[
                    ToExpression[
                    "\!\(\* GraphicsBox[ TagBox[RasterBox[CompressedData[\" \
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBLECOU2VJahIzkCECxFJADGKrbtYa \
RUMUpZzMcNnnQRWjMk5lf/vzDWggtYwCkgNiFDBAsPqCPFcBjcLURYkH0fRS \
HlZwE6gV7EATfvz98f3Pd6rEIBClncpMPZlJFaNGEd0QANRpOvM= \"], {{0, 20}, { 26, \
0}}, {0, 255}, ColorFunction->RGBColor], BoxForm`ImageTag[ \"Byte\", \
Interleaving -> True, Magnification -> 1], Selectable->False], \
BaseStyle->\"ImageGraphics\", ImageSize->Magnification[1], ImageSizeRaw->{26, \
20}, PlotRange->{{0, 26}, {0, 20}}]\)"], Selectable -> False], Background -> 
                    RGBColor[0.146944, 0.70164, 0.16466], 
                    FrameMargins -> {{5, 5}, {0, 0}}, ImageMargins -> 0, 
                    Appearance -> None], 
                    Panel[
                    Style[
                    " CORRECT ", FontSize -> 10, FontColor -> 
                    RGBColor[0.146944, 0.70164, 0.16466], FontFamily -> 
                    "Source Sans Pro"], Background -> White, 
                    FrameMargins -> {{5, 5}, {0, 0}}, Appearance -> None]}], 
                  FrameStyle -> {
                    Thickness[Tiny], 
                    RGBColor[0.146944, 0.70164, 0.16466]}, FrameMargins -> 0, 
                  RoundingRadius -> 3], $CellContext`buttonLabel = 
                  " CHECK MY SOLUTION "; $CellContext`EIWLExerciseCheck = 
                  Automatic, Appearance -> None], "LinkHand"], 
               MouseAppearance[
                Button[
                 Framed[
                  Row[{
                    Panel[
                    Style[
                    ToExpression[
                    "\!\(\* GraphicsBox[ TagBox[RasterBox[CompressedData[\" \
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBLECOU2VJahIzkCECxGJADGK/YtAZ \
RTRCb1W8PnhlYooDBYFSxJgAVPnvy7cPfrkogn65IEFsJmM3BKIeZggal1RD \
yNOOMOT7DyAiTzvlJlDoCwpDkvLYpDxFjSLyEAAHORZk \"], {{0, 20}, {22, 0}}, { 0, \
255}, ColorFunction->RGBColor], BoxForm`ImageTag[ \"Byte\", Interleaving -> \
True, Magnification -> 1], Selectable->False], BaseStyle->\"ImageGraphics\", \
ImageSize->Magnification[1], ImageSizeRaw->{22, 20}, PlotRange->{{0, 22}, {0, \
20}}]\)"], Selectable -> False], Background -> 
                    RGBColor[0.918257, 0, 0.172488], 
                    FrameMargins -> {{5, 5}, {0, 0}}, ImageMargins -> 0, 
                    Appearance -> None], 
                    Panel[
                    Style[
                    " TRY AGAIN ", FontSize -> 10, FontColor -> 
                    RGBColor[0.918257, 0, 0.172488], FontFamily -> 
                    "Source Sans Pro"], Background -> White, 
                    FrameMargins -> {{5, 5}, {0, 0}}, Appearance -> None]}], 
                  FrameStyle -> {
                    Thickness[Tiny], 
                    RGBColor[0.918257, 0, 0.172488]}, FrameMargins -> 0, 
                  RoundingRadius -> 3], $CellContext`buttonLabel = 
                  " CHECK MY SOLUTION "; $CellContext`EIWLExerciseCheck = 
                  Automatic, Appearance -> None], "LinkHand"]]], 
             StandardForm], ImageSizeCache -> {109., {9., 16.}}], 
           DynamicModuleValues :> {}]}, {None, None}}, 
       CellChangeTimes -> {{3.6688095471029243`*^9, 3.66880959932793*^9}}, 
       MenuSortingValue -> 10000, FontSize -> 15], 
      Cell[
       StyleData["Output"], Deletable -> True, ShowCellBracket -> True, 
       CellMargins -> {{92, 50}, {10, 5}}, 
       CellBracketOptions -> {"OverlapContent" -> True}, CellEditDuplicate -> 
       True, GeneratedCell -> True, CellAutoOverwrite -> True, 
       LinebreakAdjustments -> {1, 2., 12., 1.25, 1.}, MenuSortingValue -> 
       None, FontSize -> 15], 
      Cell[
       StyleData["Message"], 
       CellMargins -> {{92, Inherited}, {Inherited, Inherited}}], 
      Cell[
       StyleData["EmptyCell"], Editable -> False, Selectable -> False, 
       CellMargins -> {{0, 0}, {-2, 0}}, 
       CellElementSpacings -> {"CellMinHeight" -> 1}, MenuSortingValue -> 
       10000, FontSize -> 1], 
      Cell[
       StyleData["CellLabel"], MenuSortingValue -> 10000, FontColor -> 
       GrayLevel[0.6]], 
      Cell[
       StyleData["Link"], LineBreakWithin -> False, 
       TemplateBoxOptions -> {DisplayFunction :> (TagBox[
           
           ButtonBox[#, Appearance -> None, ButtonData -> #2, 
            BaseStyle -> {
             "Hyperlink", FontSize -> 15, FontFamily -> "Source Sans Pro"}], 
           MouseAppearanceTag["LinkHand"]]& )}, 
       ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
      Cell[
       StyleData["ExpectedOutputText"], FontFamily -> "Arial", FontSize -> 13,
        FontColor -> RGBColor[0.8579079880979629, 0.4263828488593881, 0.]], 
      Cell[
       StyleData["CodeSectionDividerCloud"], Selectable -> False, 
       ShowCellBracket -> False, CellMargins -> {{0, 0}, {0, 35}}, 
       CellBracketOptions -> {"OverlapContent" -> True}, 
       CellElementSpacings -> {"CellMinHeight" -> 6}, 
       CellGroupingRules -> {"SectionGrouping", -5}, 
       CellFrameMargins -> {{20, 20}, {2, 2}}, DefaultNewCellStyle -> 
       "EmptyCell", FontSize -> 6, Background -> GrayLevel[0.95]], 
      Cell[
       StyleData["DockedCellAuthorName"], MenuSortingValue -> 10000, 
       FontFamily -> "Source Sans Pro", FontSize -> 12, FontColor -> 
       RGBColor[1, 0.929411, 0.721568]], 
      Cell[
       StyleData["DockedCellSectionTitle"], MenuSortingValue -> 10000, 
       FontFamily -> "Source Sans Pro", FontSize -> 18, FontColor -> 
       GrayLevel[1]], 
      Cell[
       StyleData["DockedCellSecondCell"], CellFrame -> 1, 
       CellMargins -> {{0, 0}, {0, 0}}, 
       CellFrameMargins -> {{10, 10}, {10, 10}}, CellFrameColor -> 
       RGBColor[1, 0.956862, 0.878431], MenuSortingValue -> 10000, Background -> 
       RGBColor[1, 0.956862, 0.878431]], 
      Cell[
       StyleData["CompletedExerciseHeader"], MenuSortingValue -> 10000, 
       FontFamily -> "Source Sans Pro", FontSize -> 14, FontColor -> 
       GrayLevel[0.5]], 
      Cell[
       StyleData["DockedCellShareButton"], MenuSortingValue -> 10000, 
       FontFamily -> "Source Sans Pro", FontSize -> 13, FontColor -> 
       GrayLevel[1]], 
      Cell[
       StyleData["DockedCellLinksSections"], MenuSortingValue -> 10000, 
       FontFamily -> "Source Sans Pro", FontSize -> 14, FontWeight -> "Plain",
        FontSlant -> "Plain", FontColor -> RGBColor[0.97647, 0.482352, 0]], 
      Cell[
       StyleData["DockedCellLinksDivider"], MenuSortingValue -> 10000, 
       FontFamily -> "Courier", FontSize -> 18, FontWeight -> "Plain", 
       FontSlant -> "Plain", FontColor -> RGBColor[0.97647, 0.482352, 0]], 
      Cell[
       StyleData["DockedCellSectionTitleDivider"], MenuSortingValue -> 10000, 
       FontFamily -> "Courier", FontSize -> 24, FontWeight -> "Plain", 
       FontSlant -> "Plain", FontColor -> GrayLevel[1]], 
      Cell[
       StyleData["SolutionTrue"], MenuSortingValue -> 10000, FontFamily -> 
       "Source Sans Pro", FontSize -> 12, FontWeight -> "Plain", FontSlant -> 
       "Plain", FontColor -> RGBColor[0.12, 0.7, 0.22]], 
      Cell[
       StyleData["SolutionFalse"], MenuSortingValue -> 10000, FontFamily -> 
       "Source Sans Pro", FontSize -> 12, FontWeight -> "Plain", FontSlant -> 
       "Plain", FontColor -> RGBColor[0.94, 0.08, 0.2]], 
      Cell[
       StyleData["SolutionResponseText"], ShowStringCharacters -> False, 
       FontFamily -> "Source Sans Pro", FontSize -> 12, FontWeight -> "Plain",
        FontSlant -> "Plain", FontColor -> GrayLevel[1]], 
      Cell[
       StyleData["SolutionResponse"], ShowCellBracket -> False, 
       CellMargins -> {{24, 25}, {6, 0}}, 
       CellFrameMargins -> {{8, 0}, {0, 12}}, TextAlignment -> Right, 
       ShowStringCharacters -> False, FontFamily -> "Source Sans Pro", 
       FontSize -> 12, FontWeight -> "Plain", FontSlant -> "Plain", 
       Background -> GrayLevel[1]], 
      Cell[
       StyleData["DockedCellCompletedExerciseText"], MenuSortingValue -> 
       10000, FontFamily -> "Source Sans Pro", FontSize -> 12, FontWeight -> 
       "Plain", FontSlant -> "Plain", FontColor -> GrayLevel[0.4]], 
      Cell[
       StyleData["DockedCellSolutionDivider"], MenuSortingValue -> 10000, 
       FontFamily -> "Courier", FontSize -> 16, FontWeight -> "Plain", 
       FontSlant -> "Plain", FontColor -> GrayLevel[0.6]], 
      Cell[
       StyleData["DockedCellCorrectExerciseText"], MenuSortingValue -> 10000, 
       FontFamily -> "Source Sans Pro", FontSize -> 12, FontWeight -> "Plain",
        FontSlant -> "Plain", FontColor -> RGBColor[0.12, 0.7, 0.22]], 
      Cell[
       CellGroupData[{
         Cell[
         "EIWL Cloud Link styles", "Subsubsection", 
          CellChangeTimes -> {{3.663512229965006*^9, 3.66351224118613*^9}}], 
         Cell[
          StyleData["EIWLTextLink"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 16, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkAnswer"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkCodeCaption"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontColor -> GrayLevel[0.6], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkExercise"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkExerciseNote"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkInlineCode"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkMoreExplore"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkQuestion"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontWeight -> Bold, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkTechNote"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkText"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 17, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkInlineCodeLink"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 17, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkVocabularyTable"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
         "EIWL Cloud Link", "Subsubsection", 
          CellChangeTimes -> {{3.664234597774767*^9, 3.664234605661516*^9}}], 
         
         Cell[
          StyleData["CodeLinkAnswer"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkCodeCaption"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontColor -> GrayLevel[0.6], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkExercise"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkQuestion"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontWeight -> Bold, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkTechNote"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkText"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 17, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkVocabularyTable"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkVocabularyTable3Column"], LineBreakWithin -> 
          False, TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkAnswer"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkCodeCaption"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontColor -> GrayLevel[0.6], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkExercise"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkExerciseNote"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkIndex"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkIndexSubentry"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkMoreExplore"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkQuestion"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontWeight -> Bold, FontColor -> 
                 GrayLevel[0], FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkTechNote"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkText"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 16, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkVocabularyTable"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}]}, 
        Closed]]}, Open]]}, Visible -> False, FrontEndVersion -> 
  "11.1 for Mac OS X x86 (32-bit, 64-bit Kernel) (April 18, 2017)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "FirstInputCell"->{
  Cell[6168, 172, 813, 26, 
  70, "Input", "ExpressionUUID" -> "16137cfb-32b2-47a1-94c5-dadb73d1a79a",
   CellTags->"FirstInputCell"],
  Cell[15976, 417, 813, 26, 
  70, "Input", "ExpressionUUID" -> "1200dacb-fa01-470f-9b33-7ea9757463f7",
   CellTags->"FirstInputCell"],
  Cell[28457, 707, 813, 26, 
  70, "Input", "ExpressionUUID" -> "53188117-3b65-40df-a46d-c9f49c596f9b",
   CellTags->"FirstInputCell"],
  Cell[49866, 1147, 813, 26, 
  70, "Input", "ExpressionUUID" -> "a79dc755-fb8e-4906-b4d4-17f4b73d03cc",
   CellTags->"FirstInputCell"],
  Cell[63421, 1455, 813, 26, 
  70, "Input", "ExpressionUUID" -> "22c5e8b9-4f18-42fc-b6ad-c649723eed87",
   CellTags->"FirstInputCell"],
  Cell[74111, 1714, 813, 26, 
  70, "Input", "ExpressionUUID" -> "c6a1b460-f394-4170-92b1-1b8bc940a933",
   CellTags->"FirstInputCell"],
  Cell[84403, 1968, 813, 26, 
  70, "Input", "ExpressionUUID" -> "67725e67-b8e7-49a7-8024-089fd19aa075",
   CellTags->"FirstInputCell"],
  Cell[98239, 2280, 813, 26, 
  70, "Input", "ExpressionUUID" -> "bfefa058-cdb2-4261-ae17-d9ad824a8bc9",
   CellTags->"FirstInputCell"],
  Cell[112231, 2596, 813, 26, 
  70, "Input", "ExpressionUUID" -> "8f16b2d4-ff35-44a1-a3dd-f639f52685fc",
   CellTags->"FirstInputCell"],
  Cell[152309, 3345, 813, 26, 
  70, "Input", "ExpressionUUID" -> "c17f6aa7-20f3-48f9-a135-c5b49af4b5ef",
   CellTags->"FirstInputCell"],
  Cell[323474, 6237, 813, 26, 
  70, "Input", "ExpressionUUID" -> "5179194e-926c-4a4f-8494-43bc27d3a32b",
   CellTags->"FirstInputCell"],
  Cell[339738, 6593, 813, 26, 
  70, "Input", "ExpressionUUID" -> "5595e81d-8103-4a4d-88b2-3f4ddd4133ee",
   CellTags->"FirstInputCell"],
  Cell[415250, 7922, 813, 26, 
  70, "Input", "ExpressionUUID" -> "764077b0-76a4-4e60-9a9f-a99a5073c8f0",
   CellTags->"FirstInputCell"],
  Cell[427882, 8215, 813, 26, 
  70, "Input", "ExpressionUUID" -> "18e9c5f8-adbf-4765-b8d4-48c06c383363",
   CellTags->"FirstInputCell"],
  Cell[436177, 8442, 813, 26, 
  70, "Input", "ExpressionUUID" -> "386913ee-bb20-421f-9626-3c1c7a8dd159",
   CellTags->"FirstInputCell"],
  Cell[449845, 8751, 813, 26, 
  70, "Input", "ExpressionUUID" -> "a7a5dc82-a0ea-4fb6-8630-c1c188cc1b3a",
   CellTags->"FirstInputCell"],
  Cell[471360, 9194, 813, 26, 
  70, "Input", "ExpressionUUID" -> "776235d5-6c9b-4bc5-9a77-dbf4bdf32b54",
   CellTags->"FirstInputCell"],
  Cell[484916, 9504, 813, 26, 
  70, "Input", "ExpressionUUID" -> "bc244e07-9393-4801-a8bf-56f5f704d72d",
   CellTags->"FirstInputCell"],
  Cell[498160, 9812, 813, 26, 
  70, "Input", "ExpressionUUID" -> "10770c3f-dc00-4251-a4aa-3c7591f99126",
   CellTags->"FirstInputCell"],
  Cell[521581, 10284, 813, 26, 
  70, "Input", "ExpressionUUID" -> "27a90b57-ec35-4dd0-bd9a-b3b1c7b882a0",
   CellTags->"FirstInputCell"]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"FirstInputCell", 580648, 11506}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[645, 22, 430, 9, 70, "Exercise", "ExpressionUUID" -> \
"65244b70-4069-4b74-bdf9-2773d9382d4b",
 CounterAssignments->{{"SectionNumber", 28}, {"ExerciseNumber", 1}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[1100, 35, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"a0ccdaa3-fe6a-4e8e-aa51-4cd048b9e653"],
Cell[1739, 56, 3822, 91, 70, "ExerciseOutput", "ExpressionUUID" -> \
"250e1ff0-3730-459d-8774-06ca87d2951e"]
}, Closed]],
Cell[CellGroupData[{
Cell[5598, 152, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"b343dcac-dcb6-4efa-87c2-c087110c5960"],
Cell[6168, 172, 813, 26, 70, "Input", "ExpressionUUID" -> \
"16137cfb-32b2-47a1-94c5-dadb73d1a79a",
 CellTags->"FirstInputCell"]
}, Open  ]],
Cell[CellGroupData[{
Cell[7018, 203, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"619097d8-19b5-4369-a28a-87c46878e597"],
Cell[7305, 214, 460, 11, 70, "Exercise", "ExpressionUUID" -> \
"444bedab-c87f-4bef-b84d-5127a462b453",
 CounterAssignments->{{"SectionNumber", 28}, {"ExerciseNumber", 2}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[7790, 229, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"1fdab0ad-5ec8-4f09-8bcf-5faeb39b4bb9"],
Cell[8429, 250, 6940, 142, 70, "ExerciseOutput", "ExpressionUUID" -> \
"c43bdeba-1f55-4a03-a9e3-9bfa9c61ef7c"]
}, Closed]],
Cell[CellGroupData[{
Cell[15406, 397, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"827b625d-9660-4c7d-b909-087e7b184926"],
Cell[15976, 417, 813, 26, 70, "Input", "ExpressionUUID" -> \
"1200dacb-fa01-470f-9b33-7ea9757463f7",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[16838, 449, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"18ca1bbf-19ee-4e0e-879c-7312fc35fbca"],
Cell[17125, 460, 461, 11, 70, "Exercise", "ExpressionUUID" -> \
"09f7fda9-62c1-41b5-8c22-1addfbbfdb0a",
 CounterAssignments->{{"SectionNumber", 28}, {"ExerciseNumber", 3}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[17611, 475, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"1c4086f1-20e9-4857-a2a0-efaf7c66c7e2"],
Cell[18250, 496, 9600, 186, 70, "ExerciseOutput", "ExpressionUUID" -> \
"b6841aac-e8bb-468a-a42e-430732893dca"]
}, Closed]],
Cell[CellGroupData[{
Cell[27887, 687, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"55b5039e-98d5-448d-a4f7-e2e2d2e7bc8e"],
Cell[28457, 707, 813, 26, 70, "Input", "ExpressionUUID" -> \
"53188117-3b65-40df-a46d-c9f49c596f9b",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[29319, 739, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"81e483f5-fcea-47c0-a459-29b83489b61a"],
Cell[29606, 750, 736, 19, 70, "Exercise", "ExpressionUUID" -> \
"2a6b1147-7880-4605-a6d7-7743dee62170",
 CounterAssignments->{{"SectionNumber", 28}, {"ExerciseNumber", 4}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[30367, 773, 656, 20, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"adc62553-fa0d-4f55-a4a8-d143b899610f"],
Cell[31026, 795, 18233, 327, 70, "ExerciseOutput", "ExpressionUUID" -> \
"36e9b92d-6a5b-42d0-8ed3-34311111d389"]
}, Closed]],
Cell[CellGroupData[{
Cell[49296, 1127, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"630b33f2-0c2e-4618-b13f-944f74b05d84"],
Cell[49866, 1147, 813, 26, 70, "Input", "ExpressionUUID" -> \
"a79dc755-fb8e-4906-b4d4-17f4b73d03cc",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[50728, 1179, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"fc14d09d-a0ca-4b52-9050-a542b1fbfbb7"],
Cell[51015, 1190, 482, 12, 70, "Exercise", "ExpressionUUID" -> \
"d95f340d-603c-4897-81c4-eb3b577265cc",
 CounterAssignments->{{"SectionNumber", 28}, {"ExerciseNumber", 5}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[51522, 1206, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"85a2ad68-757b-4ddc-b9d2-5d9887b72d99"],
Cell[52161, 1227, 10653, 203, 70, "ExerciseOutput", "ExpressionUUID" -> \
"cf065fb1-e2e7-482f-8fed-ad8ff68f11ae"]
}, Closed]],
Cell[CellGroupData[{
Cell[62851, 1435, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"22b4c457-1f66-4cd3-ad89-9ceba8dba3fe"],
Cell[63421, 1455, 813, 26, 70, "Input", "ExpressionUUID" -> \
"22c5e8b9-4f18-42fc-b6ad-c649723eed87",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[64283, 1487, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"297f3a4c-bd04-432e-90ae-76759f75bb81"],
Cell[64570, 1498, 486, 10, 70, "Exercise", "ExpressionUUID" -> \
"5beab3aa-be0d-4df7-8f28-56e718c109c4",
 CounterAssignments->{{"SectionNumber", 28}, {"ExerciseNumber", 6}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[65081, 1512, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"25e9d69c-d840-4b82-8312-ca1054f091af"],
Cell[65720, 1533, 7784, 156, 70, "ExerciseOutput", "ExpressionUUID" -> \
"d35b53d0-8272-476d-b606-515bab0c50e7"]
}, Closed]],
Cell[CellGroupData[{
Cell[73541, 1694, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"d5a289bb-599f-4f98-9c1e-e4f526183992"],
Cell[74111, 1714, 813, 26, 70, "Input", "ExpressionUUID" -> \
"c6a1b460-f394-4170-92b1-1b8bc940a933",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[74973, 1746, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"19e98e2e-0501-4526-ae38-23a4056b8105"],
Cell[75260, 1757, 454, 11, 70, "Exercise", "ExpressionUUID" -> \
"5ee0bfc7-ca1f-486a-86f3-bb516fbebc3a",
 CounterAssignments->{{"SectionNumber", 28}, {"ExerciseNumber", 7}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[75739, 1772, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"46277854-f4a4-4b5c-b532-cc969460684c"],
Cell[76378, 1793, 7418, 150, 70, "ExerciseOutput", "ExpressionUUID" -> \
"c60b220f-db57-4627-8adc-34c61c0a8a45"]
}, Closed]],
Cell[CellGroupData[{
Cell[83833, 1948, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"5d6e4631-7313-44a2-a4fa-9bc698df4e9e"],
Cell[84403, 1968, 813, 26, 70, "Input", "ExpressionUUID" -> \
"67725e67-b8e7-49a7-8024-089fd19aa075",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[85265, 2000, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"c750df93-8145-44d6-bc7c-bc42d2bca780"],
Cell[85552, 2011, 466, 11, 70, "Exercise", "ExpressionUUID" -> \
"89a9da03-480b-4d9c-8e68-215ec55d13ce",
 CounterAssignments->{{"SectionNumber", 28}, {"ExerciseNumber", 8}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[86043, 2026, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"180cf0c2-02ff-45f3-8123-be4c6c6ebbe3"],
Cell[86682, 2047, 10950, 208, 70, "ExerciseOutput", "ExpressionUUID" -> \
"49b0c68c-b740-4211-bafc-b438d3d8bd4a"]
}, Closed]],
Cell[CellGroupData[{
Cell[97669, 2260, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"7e63edfc-c95e-4dd7-8166-10cb8b2dab91"],
Cell[98239, 2280, 813, 26, 70, "Input", "ExpressionUUID" -> \
"bfefa058-cdb2-4261-ae17-d9ad824a8bc9",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[99101, 2312, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"b8aadde8-5d96-4fb9-941d-a6347d277c72"],
Cell[99388, 2323, 525, 13, 70, "Exercise", "ExpressionUUID" -> \
"d4cc6bf9-dc82-4a94-a6d0-4db5958559f8",
 CounterAssignments->{{"SectionNumber", 28}, {"ExerciseNumber", 9}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[99938, 2340, 656, 20, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"5e8fe11b-a689-46f3-8474-8c9cb068e2f9"],
Cell[100597, 2362, 11027, 209, 70, "ExerciseOutput", "ExpressionUUID" -> \
"c601f8d0-80fa-423a-81e3-33527750ee46"]
}, Closed]],
Cell[CellGroupData[{
Cell[111661, 2576, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"831ec32a-ace5-4b13-b52f-cb0de626ea40"],
Cell[112231, 2596, 813, 26, 70, "Input", "ExpressionUUID" -> \
"8f16b2d4-ff35-44a1-a3dd-f639f52685fc",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[113093, 2628, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"a04b9ff4-9770-4bcd-9200-6f2ac51cdb7f"],
Cell[113380, 2639, 860, 24, 70, "Exercise", "ExpressionUUID" -> \
"52d1c4c5-e89f-4900-9041-6c7e8fe361d8",
 CounterAssignments->{{"SectionNumber", 28}, {"ExerciseNumber", 10}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[114265, 2667, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"5250fba6-cfcf-490a-85f4-52ee80115ebe"],
Cell[114904, 2688, 36797, 632, 70, "ExerciseOutput", "ExpressionUUID" -> \
"107b33c4-40ad-42c3-aa6e-a41dc35b54c4"]
}, Closed]],
Cell[CellGroupData[{
Cell[151738, 3325, 568, 18, 70, "Subsection", "ExpressionUUID" -> \
"608ccc95-b432-498a-9ccc-e9125d496128"],
Cell[152309, 3345, 813, 26, 70, "Input", "ExpressionUUID" -> \
"c17f6aa7-20f3-48f9-a135-c5b49af4b5ef",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[153171, 3377, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"737d0517-3300-4b62-a292-c98dfd8ee247"],
Cell[153458, 3388, 517, 12, 70, "Exercise", "ExpressionUUID" -> \
"201b81ef-53e7-401f-84c9-9863a4fc82aa",
 CounterAssignments->{{"SectionNumber", 28}, {"ExerciseNumber", 11}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[154000, 3404, 656, 20, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"b5ed3e6a-25c6-4968-83cb-12cb00408833"],
Cell[154659, 3426, 168207, 2786, 70, "ExerciseOutput", "ExpressionUUID" -> \
"d5749863-9893-403b-84c4-05caa580361b"]
}, Closed]],
Cell[CellGroupData[{
Cell[322903, 6217, 568, 18, 70, "Subsection", "ExpressionUUID" -> \
"6605d444-4ce5-4aba-a08a-e4fc77b2e857"],
Cell[323474, 6237, 813, 26, 70, "Input", "ExpressionUUID" -> \
"5179194e-926c-4a4f-8494-43bc27d3a32b",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[324336, 6269, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"92b117f3-38c5-4b5b-b72c-4ddc87590b8c"],
Cell[324623, 6280, 762, 19, 70, "Exercise", "ExpressionUUID" -> \
"0c0a392a-e772-411a-9f8f-21708a98e9ce",
 CounterAssignments->{{"SectionNumber", 28}, {"ExerciseNumber", 12}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[325410, 6303, 656, 20, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"8982da8a-cae1-4ca8-8b48-508ab7909164"],
Cell[326069, 6325, 13061, 243, 70, "ExerciseOutput", "ExpressionUUID" -> \
"44b8f8eb-a158-465d-a052-bc5757c9ffbc"]
}, Closed]],
Cell[CellGroupData[{
Cell[339167, 6573, 568, 18, 70, "Subsection", "ExpressionUUID" -> \
"c9f78246-51be-41f2-bddd-84514a77b568"],
Cell[339738, 6593, 813, 26, 70, "Input", "ExpressionUUID" -> \
"5595e81d-8103-4a4d-88b2-3f4ddd4133ee",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[340600, 6625, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"3bbce601-415a-4fd9-8a07-3423e6947ce3"],
Cell[340887, 6636, 764, 21, 70, "Exercise", "ExpressionUUID" -> \
"a83bd4f3-839d-4b6f-bed4-b294f13be6f4",
 CounterAssignments->{{"SectionNumber", 28}, {"ExerciseNumber", 13}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[341676, 6661, 656, 20, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"417ea06b-7d9b-4587-a222-98ec6ad452c0"],
Cell[342335, 6683, 72307, 1214, 70, "ExerciseOutput", "ExpressionUUID" -> \
"9b83bc6b-9b8d-452f-abb1-47d7e5f894cf"]
}, Closed]],
Cell[CellGroupData[{
Cell[414679, 7902, 568, 18, 70, "Subsection", "ExpressionUUID" -> \
"ccee0413-40bf-423d-b923-48c2d5b8e0de"],
Cell[415250, 7922, 813, 26, 70, "Input", "ExpressionUUID" -> \
"764077b0-76a4-4e60-9a9f-a99a5073c8f0",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[416112, 7954, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"fe2fa5cf-7944-49b1-ab42-cf9d291aab54"],
Cell[416399, 7965, 481, 12, 70, "Exercise", "ExpressionUUID" -> \
"71c4e11a-d01f-4414-ba9d-05ba3fd691fa",
 CounterAssignments->{{"SectionNumber", 28}, {"ExerciseNumber", 1}, {
   "WebOnly", 1}}],
Cell[CellGroupData[{
Cell[416905, 7981, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"27335c23-01e7-4d48-b36a-031ee2e664f5"],
Cell[417544, 8002, 9730, 188, 70, "ExerciseOutput", "ExpressionUUID" -> \
"deecc990-0dec-4ffd-8839-c87dc517a908"]
}, Closed]],
Cell[CellGroupData[{
Cell[427311, 8195, 568, 18, 70, "Subsection", "ExpressionUUID" -> \
"4f2c8c02-e8df-4482-bf6b-a3c01e0bd49c"],
Cell[427882, 8215, 813, 26, 70, "Input", "ExpressionUUID" -> \
"18e9c5f8-adbf-4765-b8d4-48c06c383363",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[428744, 8247, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"647fea94-c083-4750-9d93-562a32daf18a"],
Cell[429031, 8258, 613, 19, 70, "Exercise", "ExpressionUUID" -> \
"9c2cf2fc-d773-49b5-8359-19fbb2381882",
 CounterAssignments->{{"SectionNumber", 28}, {"ExerciseNumber", 2}, {
   "WebOnly", 1}}],
Cell[CellGroupData[{
Cell[429669, 8281, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"c10730ba-91c6-41df-a0c7-9aedce31b4dd"],
Cell[430308, 8302, 5261, 115, 70, "ExerciseOutput", "ExpressionUUID" -> \
"184ce520-d3b6-4ca9-b45e-242f603846ae"]
}, Closed]],
Cell[CellGroupData[{
Cell[435606, 8422, 568, 18, 70, "Subsection", "ExpressionUUID" -> \
"4a9987b1-b9f0-4f34-8750-948ae63a1947"],
Cell[436177, 8442, 813, 26, 70, "Input", "ExpressionUUID" -> \
"386913ee-bb20-421f-9626-3c1c7a8dd159",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[437039, 8474, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"b00d5c88-5fda-4d80-a2b3-14d78fc1e3c5"],
Cell[437326, 8485, 464, 11, 70, "Exercise", "ExpressionUUID" -> \
"4b082411-895c-4c8a-83ca-c54e1b7e0114",
 CounterAssignments->{{"SectionNumber", 28}, {"ExerciseNumber", 3}, {
   "WebOnly", 1}}],
Cell[CellGroupData[{
Cell[437815, 8500, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"d13de1fc-a1c1-4071-befe-bde4abcf2ad8"],
Cell[438454, 8521, 10783, 205, 70, "ExerciseOutput", "ExpressionUUID" -> \
"9945efbf-1c52-41c8-80ca-05c3ea7fe335"]
}, Closed]],
Cell[CellGroupData[{
Cell[449274, 8731, 568, 18, 70, "Subsection", "ExpressionUUID" -> \
"486831f8-ce00-4718-a11a-a8836f74c529"],
Cell[449845, 8751, 813, 26, 70, "Input", "ExpressionUUID" -> \
"a7a5dc82-a0ea-4fb6-8630-c1c188cc1b3a",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[450707, 8783, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"d57301cb-643c-4a8d-b1cc-f0e957b5fddf"],
Cell[450994, 8794, 694, 20, 70, "Exercise", "ExpressionUUID" -> \
"e8d3cb2e-06fd-4efd-98b9-5fde37ebf4af",
 CounterAssignments->{{"SectionNumber", 28}, {"ExerciseNumber", 4}, {
   "WebOnly", 1}}],
Cell[CellGroupData[{
Cell[451713, 8818, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"d5f36b2a-60d7-4792-b2fb-9cf4833f0181"],
Cell[452352, 8839, 18400, 330, 70, "ExerciseOutput", "ExpressionUUID" -> \
"5ed5a75d-f280-49ed-a449-39b234c9d047"]
}, Closed]],
Cell[CellGroupData[{
Cell[470789, 9174, 568, 18, 70, "Subsection", "ExpressionUUID" -> \
"f2c20ec8-0199-4b97-bffd-9d62c8fefd06"],
Cell[471360, 9194, 813, 26, 70, "Input", "ExpressionUUID" -> \
"776235d5-6c9b-4bc5-9a77-dbf4bdf32b54",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[472222, 9226, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"b2ab84eb-eb70-42db-93ad-f944acdc5127"],
Cell[472509, 9237, 522, 14, 70, "Exercise", "ExpressionUUID" -> \
"3527e3fc-6a6f-4583-9758-b7fdc99b11ee",
 CounterAssignments->{{"SectionNumber", 28}, {"ExerciseNumber", 5}, {
   "WebOnly", 1}}],
Cell[CellGroupData[{
Cell[473056, 9255, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"83434287-2c4f-480a-a18f-862fc1bd5772"],
Cell[473695, 9276, 10613, 203, 70, "ExerciseOutput", "ExpressionUUID" -> \
"a1ea8e3a-4e7b-42e0-9db7-6858835b6f6a"]
}, Closed]],
Cell[CellGroupData[{
Cell[484345, 9484, 568, 18, 70, "Subsection", "ExpressionUUID" -> \
"1ba392c4-30ae-4e2d-b779-583ebebe0e0d"],
Cell[484916, 9504, 813, 26, 70, "Input", "ExpressionUUID" -> \
"bc244e07-9393-4801-a8bf-56f5f704d72d",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[485778, 9536, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"0b041822-c5f7-4390-aab6-b7ddbdb93428"],
Cell[486065, 9547, 826, 23, 70, "Exercise", "ExpressionUUID" -> \
"9fd05a2f-80ca-4570-934e-59284794802b",
 CounterAssignments->{{"SectionNumber", 28}, {"ExerciseNumber", 6}, {
   "WebOnly", 1}}],
Cell[CellGroupData[{
Cell[486916, 9574, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"aaa178e0-d081-40ea-a104-fe8e012f9987"],
Cell[487555, 9595, 9997, 192, 70, "ExerciseOutput", "ExpressionUUID" -> \
"dfd16b0d-aad1-45db-907d-20b9a3e6719c"]
}, Closed]],
Cell[CellGroupData[{
Cell[497589, 9792, 568, 18, 70, "Subsection", "ExpressionUUID" -> \
"0d20c9ad-d7ea-4e47-b52a-281d80a448c1"],
Cell[498160, 9812, 813, 26, 70, "Input", "ExpressionUUID" -> \
"10770c3f-dc00-4251-a4aa-3c7591f99126",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[499022, 9844, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"9ec3b415-4131-4bf3-8a01-029735d022de"],
Cell[499309, 9855, 718, 18, 70, "Exercise", "ExpressionUUID" -> \
"b8f13182-09ed-4880-8755-ba24023253e8",
 CounterAssignments->{{"SectionNumber", 28}, {"ExerciseNumber", 7}, {
   "WebOnly", 1}}],
Cell[CellGroupData[{
Cell[500052, 9877, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"a05c9a90-cfde-4f1f-94fc-b4af8b702a15"],
Cell[500691, 9898, 20282, 361, 70, "ExerciseOutput", "ExpressionUUID" -> \
"8aabb6d9-4602-409c-a84a-e5521e80febe"]
}, Closed]],
Cell[CellGroupData[{
Cell[521010, 10264, 568, 18, 70, "Subsection", "ExpressionUUID" -> \
"5f080044-0761-445d-96e6-57e7da658589"],
Cell[521581, 10284, 813, 26, 70, "Input", "ExpressionUUID" -> \
"27a90b57-ec35-4dd0-bd9a-b3b1c7b882a0",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[522421, 10314, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" \
-> "67363b31-92aa-483d-8e90-aba6faf7e546"]
}
]
*)

(* End of internal cache information *)
(* NotebookSignature OQWCJrD#HObdPlYGkoqTrqZR *)
