(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[   3185721,      57379]
NotebookOptionsPosition[   3074467,      55157]
NotebookOutlinePosition[   3169903,      57107]
CellTagsIndexPosition[   3169230,      57080]
WindowTitle->Pure Anonymous Function: Elementary Introduction to the Wolfram \
Language
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
 InterpretationBox[Cell[
  "Pure Anonymous Functions", "SectionInline",ExpressionUUID->
   "76335301-dd4e-4ec7-adf1-40b2bc061a9a"],
  $Line = 0; Null]], "SectionDoubleDigit",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CounterAssignments->{{"Section", 25}, {"Subsection", 0}, {
   "Subsubsection", 0}, {"Exercise", 0}},
 CellTags->"p:147",ExpressionUUID->"5c39f47b-2431-431b-9ba2-2f33e02cdb9d"],

Cell[TextData[{
 "After all the examples we\[CloseCurlyQuote]ve seen of the Wolfram Language, \
we\[CloseCurlyQuote]re now ready to go to a slightly higher level of \
abstraction, and tackle the very important concept of ",
 StyleBox["pure functions",
  FontSlant->"Italic"],
 " (also known as ",
 StyleBox["pure anonymous functions",
  FontSlant->"Italic"],
 "). "
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:1",ExpressionUUID->"465c0620-ba57-4fcc-8fef-ce9c5765b981"],

Cell["\<\
Using pure functions will let us unlock a new level of power in the Wolfram \
Language, and also let us redo some of the things we\[CloseCurlyQuote]ve done \
before in a simpler and more elegant way.\
\>", "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"6dd00e66-5c1c-4649-9203-12f6d5c03ac2"],

Cell[TextData[{
 "Let\[CloseCurlyQuote]s start with a simple example. Say \
we\[CloseCurlyQuote]ve got a list of images, and we want to apply ",
 ButtonBox["Blur",
  BaseStyle->"Link"],
 " to each of them. That\[CloseCurlyQuote]s easy to do with ",
 Cell[BoxData[
  ButtonBox["/@",
   BaseStyle->"Link",
   ButtonData->"Map"]], "InlineCodeText",ExpressionUUID->
  "8007cb30-90e5-48af-98bd-e69549c88362"],
 "."
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:2",ExpressionUUID->"e6767e77-aee5-401f-aea2-fa92e681b765"],

Cell[TextData[{
 "Apply ",
 ButtonBox["Blur",
  BaseStyle->"Link"],
 " to each image in the list:"
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"2dfe8d4c-f431-4530-ba83-0b580f83c236"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Blur", "/@", 
  RowBox[{"{", 
   RowBox[{
    GraphicsBox[
     {RGBColor[1, 0, 0], CircleBox[{0, 0}]},
     ImageSize->{35, 35}], ",", 
    GraphicsBox[
     {RGBColor[0, 1, 0], CircleBox[{0, 0}]},
     ImageSize->{35, 35}], ",", 
    GraphicsBox[
     {RGBColor[0, 0, 1], CircleBox[{0, 0}]},
     ImageSize->{35, 35}]}], "}"}]}]], "Input",
 Deletable->False,
 CellLabel->"In[1]:=",ExpressionUUID->"80298754-c670-41e8-8726-5bda2c8b4dfc"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    TagBox[RasterBox[CompressedData["
1:eJy9l7lKZFEQhhsnMfQVhnkJ0wknVeYBFHvEpIVWEB9CEFzQxEBcQFBREw0U
DFwyEZdWFBRMNBDccf/nK0ovF9tuermcgr6cPrfOX3X+U6eq7s/m9oZ/NalU
qqOWR0NT1+9stqm7sY4/fzMdba2ZdMufTGe6NZ2tb/7B5K+Pn41VSN7f9fys
21udn+voSFtbWl3V/LwmJzU6ak/GzDDPW3TQRJ9VpQvKLy+6udHZmeEsLWls
TP396ulRb6/6+jQwYE/GzDDPW3TQRJ9VrC3F3NubHh91cWEL5+Y0PKzBQY2P
a3FRGxs2ubOjvT17MmaGed6igyb6TLIWBHCKW7m/18mJlpc1MmJrp6e1uflB
ztWV7u5M4eHBnoyZcWLRQRN9Vq2sGAIKhWy5FVbhmO9ibc2WgIaHr6/fEMIM
87xFB831dU1MmLmFBR0ff2/LrfAWHfifmtL2ti4v9fRUEuHooIn+7q5mZzU0
ZDj4/MUWaniFS7xFZ2ZG+/u6vjZvyxL0CYbDQ0PAW5gBE+TIVeKEE4Rbdo0/
BwcWq8VPs5CwirW5nHEC/5w1yOD7dnCDaOEcYZi987cyK5Et2IB5ThlMkAH0
W0n8eyRzmvBcLmP5AgI4xJLHPPh+9zHqkQylnGkiAg5oHvPge4bhXsMnd4Eo
LSuHFBFwQAMTZPD9upFD4JMBEZKggAYmyOB7tiRfkUkwWv3pxAU0MEEG33My
uZGslSBvLs4eyOB75icPY5HclbiACTL4Xl+4xWRj0kXiAibI4HsVo76Q+cnJ
iQuYIIPvtTLMjoKdUbCoC3aPgmWGYLkuWPaO1yMqSIL1iOoWr0fxCgufVEbq
Y5UVFkAqNfU6XmH12TNQ3+GTWk9nUmXPQNdB78F26EOinkGxLohtcovpYdDE
jQq6INjATxC84/rSBSnWPXrHhT/svYK+DubhBG9L7CHZNQxzmmV1qsSS9+Ew
k9895ts6PTVuK+69OevivXdkK8DXRERIgO+juLlEv/j+A4ISkVM=
      "], {{0, 35}, {35, 
      0}}, {0, 255},
      ColorFunction->RGBColor],
     BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> False],
     Selectable->False],
    BaseStyle->"ImageGraphics",
    ImageSizeRaw->{35, 35},
    PlotRange->{{0, 35}, {0, 35}}], ",", 
   GraphicsBox[
    TagBox[RasterBox[CompressedData["
1:eJy910tLVlEUBmCpScP+QvQnmjZsavQDjCyaGFgQ/QghKKUmDqISBBV1kgOD
Bl5mElYqCgVNciCYpXgp357Y9XHIS14+zobvsL911n7X2u9ee611Lly/03rz
TEtLy91zHq1t9y93drY9uHren2sdd2/f6mi/caXjXvut9s5L188SXvzz+z3P
AWM3u9vZ/pZvX/JlMYszmXmTNyMZ6UvfszzzNCch95YOTfpWHQS4r4md7Kxl
7XM+wxnL2PM8f5zHXel6mIeP8qg73Z7mJOTe0qFJ3yprj2LuZ35uZnM5yxYO
Z/hpnvak50VevMqrqUwRzmb2fd57mpOQe0uHJn1CayHAOdzKetY/5uN4xnvT
a+1ABqYzXchZzer3fKewkQ1Pc5JCLB2a9K16ndcQKBxkq1iximNlFxOZsAQa
D3/kx15CSMi9pUNzMpMv85K50YwuZWlfW8WKt3Tw35/+t3m7kpWtbB2FcDo0
6b/Lu6EMPckTOHz+xxY1XnHJWzqDGfyQD1/zlbf/NVEd9AXDQhYg8BYzMCE3
XBUnThC3ds2f+cyL1cNP86BhlbVzmcMJ/p01ZPhlO9wQLc4Rw/bu78msNGxh
A/NOGSZkgOVWiv8SyU4Tz8dlbO+AAEcslZiHX+4+oyWSUepMT2mlDDjQSszD
LxnGvcanuyBKj5VDDhlwoMGEDL9cNzkEnyYipClWyoAGEzL8ki3lK5mE0dOf
TnVAgwkZfsnJcqOs1UTeyijsQYZfMr88zKLc1UQrZcCEDL/UF7dYNpYumm4I
JmT4pYqpLzK/nNx0QzAhwy+1sp4d1XZGtUVdbfeotsxQW66rLXtX65EK0sR6
pLpV61G1wuJTZVQfT1lhAarU6nW1wuZvz6C+41Ot15mcsmfQdeg9bEcf0ugZ
UumCbNMt1sPQ5MYJuiBs8BNC6bj+6YJS6R5Lx8Ufez9BX4d5nPD2iD2kXWPY
aR6rUxVLpQ/HzN7uca+tT/mE2xP33s768N67YauGr4kGITV8H1XNNfeL7xcd
tZFT
      "], {{0, 35}, {35, 0}}, {0, 255},
      ColorFunction->RGBColor],
     BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> False],
     Selectable->False],
    BaseStyle->"ImageGraphics",
    ImageSizeRaw->{35, 35},
    PlotRange->{{0, 35}, {0, 35}}], ",", 
   GraphicsBox[
    TagBox[RasterBox[CompressedData["
1:eJy9l7lKZFEQhhsnMfQVhnkJ0wknVeYBFHvEpIVWEB9CEFzQxEBcQFBREw0U
DFwyEZdWFBRMNBDccf/nK0ovF9tuermcgr6cPrfOX3X+U6eq7s/m9oZ/NalU
qqOWR0NT1+9stqm7sY4/fzMdba2ZdMufTGe6NZ2tb/7B5K+Pn41VQN7f9fys
21udn+voSFtbWl3V/LwmJzU6ak/GzDDPW3TQRJ9VpQvKLy+6udHZmeEsLWls
TP396ulRb6/6+jQwYE/GzDDPW3TQRJ9VrC3F3NubHh91cWEL5+Y0PKzBQY2P
a3FRGxs2ubOjvT17MmaGed6igyb6TLIWBHCKW7m/18mJlpc1MmJrp6e1uflB
ztWV7u5M4eHBnoyZcWLRQRN9Vq2sGAIKhWy5FVbhmO9ibc2WgIaHr6/fEMIM
87xFB831dU1MmLmFBR0ff2/LrfAWHfifmtL2ti4v9fRUEuHooIn+7q5mZzU0
ZDj4/MUWaniFS7xFZ2ZG+/u6vjZvyxL0CYbDQ0PAW5gBE+TIVeKEE4Rbdo0/
BwcWq8VPs5CwirW5nHEC/5w1yOD7dnCDaOEcYZi987cyK5Et2IB5ThlMkAH0
W0n8eyRzmvBcLmP5AgI4xJLHPPh+9zHqkQylnGkiAg5oHvPge4bhXsMnd4Eo
LSuHFBFwQAMTZPD9upFD4JMBEZKggAYmyOB7tiRfkUkwWv3pxAU0MEEG33My
uZGslSBvLs4eyOB75icPY5HclbiACTL4Xl+4xWRj0kXiAibI4HsVo76Q+cnJ
iQuYIIPvtTLMjoKdUbCoC3aPgmWGYLkuWPaO1yMqSIL1iOoWr0fxCgufVEbq
Y5UVFkAqNfU6XmH12TNQ3+GTWk9nUmXPQNdB78F26EOinkGxLohtcovpYdDE
jQq6INjATxC84/rSBSnWPXrHhT/svYK+DubhBG9L7CHZNQxzmmV1qsSS9+Ew
k9895ts6PTVuK+69OevivXdkK8DXRERIgO+juLlkv/j+A7lJkVM=
      "], {{0, 35}, {35, 
      0}}, {0, 255},
      ColorFunction->RGBColor],
     BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> False],
     Selectable->False],
    BaseStyle->"ImageGraphics",
    ImageSizeRaw->{35, 35},
    PlotRange->{{0, 35}, {0, 35}}]}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[1]=",ExpressionUUID->"6c6b8a60-9728-48b2-b5ee-f49bcf8bb037"]
}, Open  ]],

Cell[TextData[{
 "But now let\[CloseCurlyQuote]s say we want to include the parameter ",
 Cell[BoxData[
 "5"], "InlineCodeText",ExpressionUUID->
  "254e88b8-ec19-49bb-97d7-05fc8ce85354"],
 " in ",
 ButtonBox["Blur",
  BaseStyle->"Link"],
 ". How can we do that? The answer is to use a pure function."
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"a65095a7-1eed-400d-a9ae-94f61b01a5c0"],

Cell["Include a parameter by introducing a pure function: ", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"fc6f14d6-bf9c-43e4-94d4-98dcfc926c9b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Blur", "[", 
    RowBox[{"#", ",", "5"}], "]"}], "&"}], "/@", 
  RowBox[{"{", 
   RowBox[{
    GraphicsBox[
     {RGBColor[1, 0, 0], CircleBox[{0, 0}]},
     ImagePadding->3,
     ImageSize->{40, 40}], ",", 
    GraphicsBox[
     {RGBColor[0, 1, 0], CircleBox[{0, 0}]},
     ImagePadding->3,
     ImageSize->{40, 40}], ",", 
    GraphicsBox[
     {RGBColor[0, 0, 1], CircleBox[{0, 0}]},
     ImagePadding->3,
     ImageSize->{40, 40}]}], "}"}]}]], "Input",
 Deletable->False,
 CellLabel->"In[2]:=",ExpressionUUID->"15d31b7a-0131-4533-b6a0-76b3e0201a2b"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    TagBox[RasterBox[CompressedData["
1:eJzFmMlOHDEQhkfJhWNeIbc8Qq4ccyXKA4CYoFwm0hApynuy7/u+L2Kn8ll/
q2K5e5rGBKZlUOMu/3+tdpmPIz+Hvr9rtVrjA/waGv492O0O//n6gT++dcZ/
jHXao186v9pj7e7nkfdMfip+wrvVP4+P9vBg9/d2e2s3N3Z1ZZeXdnFh5+d2
dlYM3plhnq/IIIk8q1ib8cSMooPi5MQOD+3gwPb2wtjdLV6YYZ6vyEiBDHYk
Gc6ILaKDZWvLNjZsbc1WVmx5uRi8M8M8X5GRAqxydgE2MfPuLngMzU9Pgy3b
27a+HigWFmxuzmZnbWbGpqeLwTszzC8uBhkkkWcVa0EAB7R6w530+jpE7ejI
dnYCztJSgAV/asomJ3sOviKDJPKsYi0I4IBWQ+2k+IcwofDmZtAfHIwCdmKi
AHcbNWS7VJIMf87PB//jeXBAA7OSOiHd3w/xwm9gxmjuzNXVEFMN3plhPtGQ
tUyCA1ovat7lXpHiJUIJCAgMbAFTsVPyIIMhGrwr5ZQDWOrsvIDDvKjlcOdV
9pIAxAIcNEQYLpFKbcWLr8fH/2pWQ7XMPF+VD7GjwAENTL4iCYsynAfbSXhy
jzRAbVbJUhYSPkwg0Cjs1YHa2h80eGfGKw58QFjFWrcaTEDAh4Ul8jYKsIq0
R1uSAVVjUopCadmrHuN6RwHYkWeVqN1p/Ak+LOBoS0EeYfTERURHRSFJluNA
lWH9DuDsKnxWidqtIEPAhwUu6Y8C+Acx6k4elmdwV+KZJx/VhUcN34KjVAET
fFjgkuuQYXNDGVSSsVjtuqH/c7dZ5JWlKg2HlclwyYFkI4XgPkExxQLFiJen
X/NHDmctCOCAJjcqdnCpnPmKS1U75UBkH2dx2shk1RRcMMrJ1Jd/UmRJDCVe
Nq8yBxzVphsFF4xSie1O5SYnyxU4Ko/UqbUBKojaxGCBS3sIB7fKVuXDfks+
aG95Ia9nF5iODxeM6MPvsj4K7gsfD3HiT/FW+uFVeRXHvtjbr/j2K5/7Vb9v
vF/JKBjj/dkPI9+f80xusj9Xnkcy2bMr7zwqn+nxeVR5/soh5c6kIWll15Sc
v0m/IZPdJ/+l3yif6UqbuL/yU5gR91cIE68n+ytwdNHw/sqtoGzj/sqsojNJ
+km1/Q37SbJCF42kn0y6Jqvtn73tz+ifvefv1T9b7X3B7zsN7wtkiPf89fcF
69/9qEyttp9kiO87ze+Duk8R6Pr7YEKdff8V47Puvwl1xn2fr3n3/cp6fJv/
bySGv9r/c/4CwOPz1A==
      "], {{0, 40}, {40, 0}}, {0, 255},
      ColorFunction->RGBColor],
     BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> False],
     Selectable->False],
    BaseStyle->"ImageGraphics",
    ImageSizeRaw->{40, 40},
    PlotRange->{{0, 40}, {0, 40}}], ",", 
   GraphicsBox[
    TagBox[RasterBox[CompressedData["
1:eJzF2MmOFEcQBuARvvjIK3DzI3D1kSuIBwB5QL6MpQHJ8nuyDPu+75vYCX/o
R6FydU/RFIZu5bSqsyL/P9bMyNl39K+Dx/ZsbGyc+NXXwSN//769feSfQ3v9
OLx14s/jW5t/HNg6uXl8c3v/0V9M/vbl7/NzTX4+1aeP9fFDfXhX797W29f1
+lW9elkvX9SL5/U8w7MZ896SIUneKmunwb/KGDoUT+vpo3r0sB7er/vGvbqX
BzPmvSUTBWawkzSakS2hw3K7bt+sm9fr+tW6eqWuZHg2Y95bMlHAqmYP4Cpm
vq/3PEbzZ/WMLXfqzo26geJiXTxf58/VuZ3aOVtnMzybMX+pLpEhSd4qayHA
gTZteJO+qTei9rge3627cC7XZbDwz9SZ03V6t+EtGZLkrbIWAhxoE9RNyj/C
ROFbdYv+cBgF9lSdCnjbmBHbo1Jk/LxQF/if5+FAg7mUekT6oB6IF7/BHKK1
M6/VNTHN8GzG/EhDa03CgbYbtee4N6S8JJRAIBhsgZnYJXnIMCTDc1IuOcDS
ZvcAx3yo4/DmTfZKALGAQ0PCuEIatRMvb5/Uk67ZjNSyeW+TD0NHwYEG01uS
WJLheNku4eWeNKC2VbHUQuFjgkBTuKuD2tkfMjyb6YqDD8Qqa9tqmEDgY7Ek
3qaAVdKetpKBqkNSRZG03K0eh/VOAezkrQp1O81P+FjgZEshT5ieXCQ6KYpI
Ws6BKcPpHaDZU/hWhbqtkCHwseCK/hTgH2LqLh6OZ7hr5JnpPafroqPGt3CS
KjDhY8EV15GxuVGGSjGW1a0b/b91myWfLE1pNGxMxhUHykaF0D6hWGJBMfHq
9Fv9E4dbCwEOtLgxscOVcvaWS1M7i4GYfZwN0yYmp6ZwYYyT1Ve/SmQlRhJv
Nm8yB05qs43ChTEq2e5SbnFyXMFR80ibOhtggphNDAuu7CEO7pRtysd+Kx+y
t3wnb2cXzMbHhZE+vhf1SXBnk+bTIR75M7xL/fBDeRPHtdi7rviuK5/XVb8/
eb+KURiH+3MfRr0/zzN5lf156XkUkzu75p1Hi2f68Dxaev7GIYudyYqkS7um
0fk76jdicvvkf+k3Fs/0pM2wv+pT2Bj2V4TF66v9FZxcNLq/aiuU7bC/qv/2
k+lMRv1k2v4V+0lZkYvGqJ8cdU012T932z+jf+6ef7f+uSbvC33fWfG+IEO6
55++L9T67keL1Gn7JcPwvrP6fTD3KYGevg+OqGfff8P4TfffEfWM+7638+77
S+vx5/x/Y2T4j/t/zr9dVvPU
      "], {{0, 40}, {40, 0}}, {0, 255},
      ColorFunction->RGBColor],
     BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> False],
     Selectable->False],
    BaseStyle->"ImageGraphics",
    ImageSizeRaw->{40, 40},
    PlotRange->{{0, 40}, {0, 40}}], ",", 
   GraphicsBox[
    TagBox[RasterBox[CompressedData["
1:eJzFmMlOHDEQhkfJhWNeIbc8Qq4ccyXKA4CYoFwm0hApynuy7/u+L2Kn8ll/
q2K5e5rGBKZlUOMu/3+tdpmPIz+Hvr9rtVrjA/waGv492O0O//n6gT++dcZ/
jHXao186v9pj7e7nkfdMfip+wrvVPo+P9vBg9/d2e2s3N3Z1ZZeXdnFh5+d2
dlYM3plhnq/IIIk8q1ib8cSMooPi5MQOD+3gwPb2wtjdLV6YYZ6vyEiBDHYk
Gc6ILaKDZWvLNjZsbc1WVmx5uRi8M8M8X5GRAqxydgE2MfPuLngMzU9Pgy3b
27a+HigWFmxuzmZnbWbGpqeLwTszzC8uBhkkkWcVa0EAB7R6w530+jpE7ejI
dnYCztJSgAV/asomJ3sOviKDJPKsYi0I4IBWQ+2k+IcwofDmZtAfHIwCdmKi
AHcbNWS7VJIMf87PB//jeXBAA7OSOiHd3w/xwm9gxmjuzNXVEFMN3plhPtGQ
tUyCA1ovat7lXpHiJUIJCAgMbAFTsVPyIIMhGrwr5ZQDWOrsvIDDvKjlcOdV
9pIAxAIcNEQYLpFKbcWLr8fH/2pWQ7XMPF+VD7GjwAENTL4iCYsynAfbSXhy
jzRAbVbJUhYSPkwg0Cjs1YHa2h80eGfGKw58QFjFWrcaTEDAh4Ul8jYKsIq0
R1uSAVVjUopCadmrHuN6RwHYkWeVqN1p/Ak+LOBoS0EeYfTERURHRSFJluNA
lWH9DuDsKnxWidqtIEPAhwUu6Y8C+Acx6k4elmdwV+KZJx/VhUcN34KjVAET
fFjgkuuQYXNDGVSSsVjtuqH/c7dZ5JWlKg2HlclwyYFkI4XgPkExxQLFiJen
X/NHDmctCOCAJjcqdnCpnPmKS1U75UBkH2dx2shk1RRcMMrJ1Jd/UmRJDCVe
Nq8yBxzVphsFF4xSie1O5SYnyxU4Ko/UqbUBKojaxGCBS3sIB7fKVuXDfks+
aG95Ia9nF5iODxeM6MPvsj4K7gsfD3HiT/FW+uFVeRXHvtjbr/j2K5/7Vb9v
vF/JKBjj/dkPI9+f80xusj9Xnkcy2bMr7zwqn+nxeVR5/soh5c6kIWll15Sc
v0m/IZPdJ/+l3yif6UqbuL/yU5gR91cIE68n+ytwdNHw/sqtoGzj/sqsojNJ
+km1/Q37SbJCF42kn0y6Jqvtn73tz+ifvefv1T9b7X3B7zsN7wtkiPf89fcF
69/9qEyttp9kiO87ze+Duk8R6Pr7YEKdff8V47Puvwl1xn2fr3n3/cp6fJv/
bySGv97/c/4C+brz1A==
      "], {{0, 40}, {40, 0}}, {0, 255},
      ColorFunction->RGBColor],
     BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> False],
     Selectable->False],
    BaseStyle->"ImageGraphics",
    ImageSizeRaw->{40, 40},
    PlotRange->{{0, 40}, {0, 40}}]}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[2]=",ExpressionUUID->"4b7285dc-d9f3-49a1-939d-22ba66441cba"]
}, Open  ]],

Cell["The original blur written as a pure function:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"26c4a9b0-baf1-401c-b527-02dc3fdd3319"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Blur", "[", "#", "]"}], "&"}], "/@", 
  RowBox[{"{", 
   RowBox[{
    GraphicsBox[
     {RGBColor[1, 0, 0], CircleBox[{0, 0}]},
     ImageSize->{35, 35}], ",", 
    GraphicsBox[
     {RGBColor[0, 1, 0], CircleBox[{0, 0}]},
     ImageSize->{35, 35}], ",", 
    GraphicsBox[
     {RGBColor[0, 0, 1], CircleBox[{0, 0}]},
     ImageSize->{35, 35}]}], "}"}]}]], "Input",
 Deletable->False,
 CellLabel->"In[3]:=",ExpressionUUID->"2a273250-8bb8-428f-b604-bdf126bac276"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    TagBox[RasterBox[CompressedData["
1:eJy9l7lKZFEQhhsnMfQVhnkJ0wknVeYBFHvEpIVWEB9CEFzQxEBcQFBREw0U
DFwyEZdWFBRMNBDccf/nK0ovF9tuermcgr6cPrfOX3X+U6eq7s/m9oZ/NalU
qqOWR0NT1+9stqm7sY4/fzMdba2ZdMufTGe6NZ2tb/7B5K+Pn41VSN7f9fys
21udn+voSFtbWl3V/LwmJzU6ak/GzDDPW3TQRJ9VpQvKLy+6udHZmeEsLWls
TP396ulRb6/6+jQwYE/GzDDPW3TQRJ9VrC3F3NubHh91cWEL5+Y0PKzBQY2P
a3FRGxs2ubOjvT17MmaGed6igyb6TLIWBHCKW7m/18mJlpc1MmJrp6e1uflB
ztWV7u5M4eHBnoyZcWLRQRN9Vq2sGAIKhWy5FVbhmO9ibc2WgIaHr6/fEMIM
87xFB831dU1MmLmFBR0ff2/LrfAWHfifmtL2ti4v9fRUEuHooIn+7q5mZzU0
ZDj4/MUWaniFS7xFZ2ZG+/u6vjZvyxL0CYbDQ0PAW5gBE+TIVeKEE4Rbdo0/
BwcWq8VPs5CwirW5nHEC/5w1yOD7dnCDaOEcYZi987cyK5Et2IB5ThlMkAH0
W0n8eyRzmvBcLmP5AgI4xJLHPPh+9zHqkQylnGkiAg5oHvPge4bhXsMnd4Eo
LSuHFBFwQAMTZPD9upFD4JMBEZKggAYmyOB7tiRfkUkwWv3pxAU0MEEG33My
uZGslSBvLs4eyOB75icPY5HclbiACTL4Xl+4xWRj0kXiAibI4HsVo76Q+cnJ
iQuYIIPvtTLMjoKdUbCoC3aPgmWGYLkuWPaO1yMqSIL1iOoWr0fxCgufVEbq
Y5UVFkAqNfU6XmH12TNQ3+GTWk9nUmXPQNdB78F26EOinkGxLohtcovpYdDE
jQq6INjATxC84/rSBSnWPXrHhT/svYK+DubhBG9L7CHZNQxzmmV1qsSS9+Ew
k9895ts6PTVuK+69OevivXdkK8DXRERIgO+juLlEv/j+A4ISkVM=
      "], {{0, 35}, {35, 
      0}}, {0, 255},
      ColorFunction->RGBColor],
     BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> False],
     Selectable->False],
    BaseStyle->"ImageGraphics",
    ImageSizeRaw->{35, 35},
    PlotRange->{{0, 35}, {0, 35}}], ",", 
   GraphicsBox[
    TagBox[RasterBox[CompressedData["
1:eJy910tLVlEUBmCpScP+QvQnmjZsavQDjCyaGFgQ/QghKKUmDqISBBV1kgOD
Bl5mElYqCgVNciCYpXgp357Y9XHIS14+zobvsL911n7X2u9ee611Lly/03rz
TEtLy91zHq1t9y93drY9uHren2sdd2/f6mi/caXjXvut9s5L188SXvzz+z3P
AWM3u9vZ/pZvX/JlMYszmXmTNyMZ6UvfszzzNCch95YOTfpWHQS4r4md7Kxl
7XM+wxnL2PM8f5zHXel6mIeP8qg73Z7mJOTe0qFJ3yprj2LuZ35uZnM5yxYO
Z/hpnvak50VevMqrqUwRzmb2fd57mpOQe0uHJn1CayHAOdzKetY/5uN4xnvT
a+1ABqYzXchZzer3fKewkQ1Pc5JCLB2a9K16ndcQKBxkq1iximNlFxOZsAQa
D3/kx15CSMi9pUNzMpMv85K50YwuZWlfW8WKt3Tw35/+t3m7kpWtbB2FcDo0
6b/Lu6EMPckTOHz+xxY1XnHJWzqDGfyQD1/zlbf/NVEd9AXDQhYg8BYzMCE3
XBUnThC3ds2f+cyL1cNP86BhlbVzmcMJ/p01ZPhlO9wQLc4Rw/bu78msNGxh
A/NOGSZkgOVWiv8SyU4Tz8dlbO+AAEcslZiHX+4+oyWSUepMT2mlDDjQSszD
LxnGvcanuyBKj5VDDhlwoMGEDL9cNzkEnyYipClWyoAGEzL8ki3lK5mE0dOf
TnVAgwkZfsnJcqOs1UTeyijsQYZfMr88zKLc1UQrZcCEDL/UF7dYNpYumm4I
JmT4pYqpLzK/nNx0QzAhwy+1sp4d1XZGtUVdbfeotsxQW66rLXtX65EK0sR6
pLpV61G1wuJTZVQfT1lhAarU6nW1wuZvz6C+41Ot15mcsmfQdeg9bEcf0ugZ
UumCbNMt1sPQ5MYJuiBs8BNC6bj+6YJS6R5Lx8Ufez9BX4d5nPD2iD2kXWPY
aR6rUxVLpQ/HzN7uca+tT/mE2xP33s768N67YauGr4kGITV8H1XNNfeL7xcd
tZFT
      "], {{0, 35}, {35, 0}}, {0, 255},
      ColorFunction->RGBColor],
     BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> False],
     Selectable->False],
    BaseStyle->"ImageGraphics",
    ImageSizeRaw->{35, 35},
    PlotRange->{{0, 35}, {0, 35}}], ",", 
   GraphicsBox[
    TagBox[RasterBox[CompressedData["
1:eJy9l7lKZFEQhhsnMfQVhnkJ0wknVeYBFHvEpIVWEB9CEFzQxEBcQFBREw0U
DFwyEZdWFBRMNBDccf/nK0ovF9tuermcgr6cPrfOX3X+U6eq7s/m9oZ/NalU
qqOWR0NT1+9stqm7sY4/fzMdba2ZdMufTGe6NZ2tb/7B5K+Pn41VQN7f9fys
21udn+voSFtbWl3V/LwmJzU6ak/GzDDPW3TQRJ9VpQvKLy+6udHZmeEsLWls
TP396ulRb6/6+jQwYE/GzDDPW3TQRJ9VrC3F3NubHh91cWEL5+Y0PKzBQY2P
a3FRGxs2ubOjvT17MmaGed6igyb6TLIWBHCKW7m/18mJlpc1MmJrp6e1uflB
ztWV7u5M4eHBnoyZcWLRQRN9Vq2sGAIKhWy5FVbhmO9ibc2WgIaHr6/fEMIM
87xFB831dU1MmLmFBR0ff2/LrfAWHfifmtL2ti4v9fRUEuHooIn+7q5mZzU0
ZDj4/MUWaniFS7xFZ2ZG+/u6vjZvyxL0CYbDQ0PAW5gBE+TIVeKEE4Rbdo0/
BwcWq8VPs5CwirW5nHEC/5w1yOD7dnCDaOEcYZi987cyK5Et2IB5ThlMkAH0
W0n8eyRzmvBcLmP5AgI4xJLHPPh+9zHqkQylnGkiAg5oHvPge4bhXsMnd4Eo
LSuHFBFwQAMTZPD9upFD4JMBEZKggAYmyOB7tiRfkUkwWv3pxAU0MEEG33My
uZGslSBvLs4eyOB75icPY5HclbiACTL4Xl+4xWRj0kXiAibI4HsVo76Q+cnJ
iQuYIIPvtTLMjoKdUbCoC3aPgmWGYLkuWPaO1yMqSIL1iOoWr0fxCgufVEbq
Y5UVFkAqNfU6XmH12TNQ3+GTWk9nUmXPQNdB78F26EOinkGxLohtcovpYdDE
jQq6INjATxC84/rSBSnWPXrHhT/svYK+DubhBG9L7CHZNQxzmmV1qsSS9+Ew
k9895ts6PTVuK+69OevivXdkK8DXRERIgO+juLlkv/j+A7lJkVM=
      "], {{0, 35}, {35, 
      0}}, {0, 255},
      ColorFunction->RGBColor],
     BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> False],
     Selectable->False],
    BaseStyle->"ImageGraphics",
    ImageSizeRaw->{35, 35},
    PlotRange->{{0, 35}, {0, 35}}]}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[3]=",ExpressionUUID->"960beb04-410e-48c5-b14f-44287a15d530"]
}, Open  ]],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["#",
   BaseStyle->"Link",
   ButtonData->"Slot"]], "InlineCodeText",ExpressionUUID->
  "c76e44be-ac1f-46e4-bafc-1b27ba4bd504"],
 " is a \[OpenCurlyDoubleQuote]slot\[CloseCurlyDoubleQuote] into which each \
element is put. The ",
 Cell[BoxData[
  ButtonBox["&",
   BaseStyle->"Link",
   ButtonData->"Function"]], "InlineCodeText",ExpressionUUID->
  "8faed25c-1246-4f06-8b53-a7f543a26e9c"],
 " says that what comes before it is a pure function."
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:3",ExpressionUUID->"fc65759d-3360-4036-8545-a2e556a165ad"],

Cell[TextData[{
 "Here\[CloseCurlyQuote]s the equivalent of ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     ButtonBox["Blur",
      BaseStyle->"CodeLink"], "[", 
     RowBox[{
      ButtonBox["#",
       BaseStyle->"Link",
       ButtonData->"Slot"], ",", "5"}], "]"}], 
    ButtonBox["&",
     BaseStyle->"Link",
     ButtonData->"Function"], 
    ButtonBox["/@",
     BaseStyle->"Link",
     ButtonData->"Map"]}], 
   StyleBox["...",
    FontColor->GrayLevel[0.6]]}]], "InlineCode",ExpressionUUID->
  "cc847941-7c86-425a-b6bb-a3144860d5fc"],
 " expanded out:"
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"fe87a316-670c-473b-9f3a-9e3283bda682"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Blur", "[", 
    RowBox[{
     GraphicsBox[
      {RGBColor[1, 0, 0], CircleBox[{0, 0}]},
      ImagePadding->3,
      ImageSize->{40, 40}], ",", "5"}], "]"}], ",", 
   RowBox[{"Blur", "[", 
    RowBox[{
     GraphicsBox[
      {RGBColor[0, 1, 0], CircleBox[{0, 0}]},
      ImagePadding->3,
      ImageSize->{40, 40}], ",", "5"}], "]"}], ",", 
   RowBox[{"Blur", "[", 
    RowBox[{
     GraphicsBox[
      {RGBColor[0, 0, 1], CircleBox[{0, 0}]},
      ImagePadding->3,
      ImageSize->{40, 40}], ",", "5"}], "]"}]}], "}"}]], "Input",
 Deletable->False,
 CellLabel->"In[4]:=",ExpressionUUID->"dbf46102-6690-434c-bfd3-b63d3059dad9"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    TagBox[RasterBox[CompressedData["
1:eJzFmMlOHDEQhkfJhWNeIbc8Qq4ccyXKA4CYoFwm0hApynuy7/u+L2Kn8ll/
q2K5e5rGBKZlUOMu/3+tdpmPIz+Hvr9rtVrjA/waGv492O0O//n6gT++dcZ/
jHXao186v9pj7e7nkfdMfip+wrvVP4+P9vBg9/d2e2s3N3Z1ZZeXdnFh5+d2
dlYM3plhnq/IIIk8q1ib8cSMooPi5MQOD+3gwPb2wtjdLV6YYZ6vyEiBDHYk
Gc6ILaKDZWvLNjZsbc1WVmx5uRi8M8M8X5GRAqxydgE2MfPuLngMzU9Pgy3b
27a+HigWFmxuzmZnbWbGpqeLwTszzC8uBhkkkWcVa0EAB7R6w530+jpE7ejI
dnYCztJSgAV/asomJ3sOviKDJPKsYi0I4IBWQ+2k+IcwofDmZtAfHIwCdmKi
AHcbNWS7VJIMf87PB//jeXBAA7OSOiHd3w/xwm9gxmjuzNXVEFMN3plhPtGQ
tUyCA1ovat7lXpHiJUIJCAgMbAFTsVPyIIMhGrwr5ZQDWOrsvIDDvKjlcOdV
9pIAxAIcNEQYLpFKbcWLr8fH/2pWQ7XMPF+VD7GjwAENTL4iCYsynAfbSXhy
jzRAbVbJUhYSPkwg0Cjs1YHa2h80eGfGKw58QFjFWrcaTEDAh4Ul8jYKsIq0
R1uSAVVjUopCadmrHuN6RwHYkWeVqN1p/Ak+LOBoS0EeYfTERURHRSFJluNA
lWH9DuDsKnxWidqtIEPAhwUu6Y8C+Acx6k4elmdwV+KZJx/VhUcN34KjVAET
fFjgkuuQYXNDGVSSsVjtuqH/c7dZ5JWlKg2HlclwyYFkI4XgPkExxQLFiJen
X/NHDmctCOCAJjcqdnCpnPmKS1U75UBkH2dx2shk1RRcMMrJ1Jd/UmRJDCVe
Nq8yBxzVphsFF4xSie1O5SYnyxU4Ko/UqbUBKojaxGCBS3sIB7fKVuXDfks+
aG95Ia9nF5iODxeM6MPvsj4K7gsfD3HiT/FW+uFVeRXHvtjbr/j2K5/7Vb9v
vF/JKBjj/dkPI9+f80xusj9Xnkcy2bMr7zwqn+nxeVR5/soh5c6kIWll15Sc
v0m/IZPdJ/+l3yif6UqbuL/yU5gR91cIE68n+ytwdNHw/sqtoGzj/sqsojNJ
+km1/Q37SbJCF42kn0y6Jqvtn73tz+ifvefv1T9b7X3B7zsN7wtkiPf89fcF
69/9qEyttp9kiO87ze+Duk8R6Pr7YEKdff8V47Puvwl1xn2fr3n3/cp6fJv/
bySGv9r/c/4CwOPz1A==
      "], {{0, 40}, {40, 0}}, {0, 255},
      ColorFunction->RGBColor],
     BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> False],
     Selectable->False],
    BaseStyle->"ImageGraphics",
    ImageSizeRaw->{40, 40},
    PlotRange->{{0, 40}, {0, 40}}], ",", 
   GraphicsBox[
    TagBox[RasterBox[CompressedData["
1:eJzF2MmOFEcQBuARvvjIK3DzI3D1kSuIBwB5QL6MpQHJ8nuyDPu+75vYCX/o
R6FydU/RFIZu5bSqsyL/P9bMyNl39K+Dx/ZsbGyc+NXXwSN//769feSfQ3v9
OLx14s/jW5t/HNg6uXl8c3v/0V9M/vbl7/NzTX4+1aeP9fFDfXhX797W29f1
+lW9elkvX9SL5/U8w7MZ896SIUneKmunwb/KGDoUT+vpo3r0sB7er/vGvbqX
BzPmvSUTBWawkzSakS2hw3K7bt+sm9fr+tW6eqWuZHg2Y95bMlHAqmYP4Cpm
vq/3PEbzZ/WMLXfqzo26geJiXTxf58/VuZ3aOVtnMzybMX+pLpEhSd4qayHA
gTZteJO+qTei9rge3627cC7XZbDwz9SZ03V6t+EtGZLkrbIWAhxoE9RNyj/C
ROFbdYv+cBgF9lSdCnjbmBHbo1Jk/LxQF/if5+FAg7mUekT6oB6IF7/BHKK1
M6/VNTHN8GzG/EhDa03CgbYbtee4N6S8JJRAIBhsgZnYJXnIMCTDc1IuOcDS
ZvcAx3yo4/DmTfZKALGAQ0PCuEIatRMvb5/Uk67ZjNSyeW+TD0NHwYEG01uS
WJLheNku4eWeNKC2VbHUQuFjgkBTuKuD2tkfMjyb6YqDD8Qqa9tqmEDgY7Ek
3qaAVdKetpKBqkNSRZG03K0eh/VOAezkrQp1O81P+FjgZEshT5ieXCQ6KYpI
Ws6BKcPpHaDZU/hWhbqtkCHwseCK/hTgH2LqLh6OZ7hr5JnpPafroqPGt3CS
KjDhY8EV15GxuVGGSjGW1a0b/b91myWfLE1pNGxMxhUHykaF0D6hWGJBMfHq
9Fv9E4dbCwEOtLgxscOVcvaWS1M7i4GYfZwN0yYmp6ZwYYyT1Ve/SmQlRhJv
Nm8yB05qs43ChTEq2e5SbnFyXMFR80ibOhtggphNDAuu7CEO7pRtysd+Kx+y
t3wnb2cXzMbHhZE+vhf1SXBnk+bTIR75M7xL/fBDeRPHtdi7rviuK5/XVb8/
eb+KURiH+3MfRr0/zzN5lf156XkUkzu75p1Hi2f68Dxaev7GIYudyYqkS7um
0fk76jdicvvkf+k3Fs/0pM2wv+pT2Bj2V4TF66v9FZxcNLq/aiuU7bC/qv/2
k+lMRv1k2v4V+0lZkYvGqJ8cdU012T932z+jf+6ef7f+uSbvC33fWfG+IEO6
55++L9T67keL1Gn7JcPwvrP6fTD3KYGevg+OqGfff8P4TfffEfWM+7638+77
S+vx5/x/Y2T4j/t/zr9dVvPU
      "], {{0, 40}, {40, 0}}, {0, 255},
      ColorFunction->RGBColor],
     BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> False],
     Selectable->False],
    BaseStyle->"ImageGraphics",
    ImageSizeRaw->{40, 40},
    PlotRange->{{0, 40}, {0, 40}}], ",", 
   GraphicsBox[
    TagBox[RasterBox[CompressedData["
1:eJzFmMlOHDEQhkfJhWNeIbc8Qq4ccyXKA4CYoFwm0hApynuy7/u+L2Kn8ll/
q2K5e5rGBKZlUOMu/3+tdpmPIz+Hvr9rtVrjA/waGv492O0O//n6gT++dcZ/
jHXao186v9pj7e7nkfdMfip+wrvVPo+P9vBg9/d2e2s3N3Z1ZZeXdnFh5+d2
dlYM3plhnq/IIIk8q1ib8cSMooPi5MQOD+3gwPb2wtjdLV6YYZ6vyEiBDHYk
Gc6ILaKDZWvLNjZsbc1WVmx5uRi8M8M8X5GRAqxydgE2MfPuLngMzU9Pgy3b
27a+HigWFmxuzmZnbWbGpqeLwTszzC8uBhkkkWcVa0EAB7R6w530+jpE7ejI
dnYCztJSgAV/asomJ3sOviKDJPKsYi0I4IBWQ+2k+IcwofDmZtAfHIwCdmKi
AHcbNWS7VJIMf87PB//jeXBAA7OSOiHd3w/xwm9gxmjuzNXVEFMN3plhPtGQ
tUyCA1ovat7lXpHiJUIJCAgMbAFTsVPyIIMhGrwr5ZQDWOrsvIDDvKjlcOdV
9pIAxAIcNEQYLpFKbcWLr8fH/2pWQ7XMPF+VD7GjwAENTL4iCYsynAfbSXhy
jzRAbVbJUhYSPkwg0Cjs1YHa2h80eGfGKw58QFjFWrcaTEDAh4Ul8jYKsIq0
R1uSAVVjUopCadmrHuN6RwHYkWeVqN1p/Ak+LOBoS0EeYfTERURHRSFJluNA
lWH9DuDsKnxWidqtIEPAhwUu6Y8C+Acx6k4elmdwV+KZJx/VhUcN34KjVAET
fFjgkuuQYXNDGVSSsVjtuqH/c7dZ5JWlKg2HlclwyYFkI4XgPkExxQLFiJen
X/NHDmctCOCAJjcqdnCpnPmKS1U75UBkH2dx2shk1RRcMMrJ1Jd/UmRJDCVe
Nq8yBxzVphsFF4xSie1O5SYnyxU4Ko/UqbUBKojaxGCBS3sIB7fKVuXDfks+
aG95Ia9nF5iODxeM6MPvsj4K7gsfD3HiT/FW+uFVeRXHvtjbr/j2K5/7Vb9v
vF/JKBjj/dkPI9+f80xusj9Xnkcy2bMr7zwqn+nxeVR5/soh5c6kIWll15Sc
v0m/IZPdJ/+l3yif6UqbuL/yU5gR91cIE68n+ytwdNHw/sqtoGzj/sqsojNJ
+km1/Q37SbJCF42kn0y6Jqvtn73tz+ifvefv1T9b7X3B7zsN7wtkiPf89fcF
69/9qEyttp9kiO87ze+Duk8R6Pr7YEKdff8V47Puvwl1xn2fr3n3/cp6fJv/
bySGv97/c/4C+brz1A==
      "], {{0, 40}, {40, 0}}, {0, 255},
      ColorFunction->RGBColor],
     BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> False],
     Selectable->False],
    BaseStyle->"ImageGraphics",
    ImageSizeRaw->{40, 40},
    PlotRange->{{0, 40}, {0, 40}}]}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellTags->"LastCellOfAPage",
 CellLabel->"Out[4]=",ExpressionUUID->"f8ba3035-77d0-4f4d-ace8-b189cb0d694f"]
}, Open  ]],

Cell["\<\
Let\[CloseCurlyQuote]s look at some other examples. Every time, the slot \
indicates where to put each element when the pure function is applied. \
\>", "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"p:148",ExpressionUUID->"2d9b53b2-4f45-4ed4-8500-75de82eff604"],

Cell["Rotate each string by 90\[Degree]:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:4",ExpressionUUID->"8759258f-7f31-4847-aa86-93b23eb9d442"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Rotate", "[", 
    RowBox[{"#", ",", 
     RowBox[{"90", "Degree"}]}], "]"}], "&"}], "/@", 
  RowBox[{"{", 
   RowBox[{"\"\<one\>\"", ",", "\"\<two\>\"", ",", "\"\<three\>\""}], 
   "}"}]}]], "Input",
 Deletable->False,
 CellLabel->"In[5]:=",ExpressionUUID->"2c345729-6ec3-4af6-9d11-7605a79a800c"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RotationBox["\<\"one\"\>",
    BoxRotation->1.5707963267948966`], ",", 
   RotationBox["\<\"two\"\>",
    BoxRotation->1.5707963267948966`], ",", 
   RotationBox["\<\"three\"\>",
    BoxRotation->1.5707963267948966`]}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[5]=",ExpressionUUID->"690cbe97-0e95-478a-aa6a-0b4a7755c220"]
}, Open  ]],

Cell["Take a string and rotate it different amounts:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"a5c64b2b-ff1b-4ad1-bda3-7c78e5768638"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Rotate", "[", 
    RowBox[{"\"\<hello\>\"", ",", "#"}], "]"}], "&"}], "/@", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"30", "\[Degree]"}], ",", 
    RowBox[{"90", "\[Degree]"}], ",", 
    RowBox[{"180", "\[Degree]"}], ",", 
    RowBox[{"220", "\[Degree]"}]}], "}"}]}]], "Input",
 Deletable->False,
 CellLabel->"In[6]:=",ExpressionUUID->"30317eda-1b6c-4f4c-8d25-43d81cd05b71"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RotationBox["\<\"hello\"\>",
    BoxRotation->0.5235987755982988], ",", 
   RotationBox["\<\"hello\"\>",
    BoxRotation->1.5707963267948966`], ",", 
   RotationBox["\<\"hello\"\>",
    BoxRotation->3.141592653589793], ",", 
   RotationBox["\<\"hello\"\>",
    BoxRotation->3.839724354387525]}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[6]=",ExpressionUUID->"ef06147b-09c7-4252-8753-0b5e4f4ef6c7"]
}, Open  ]],

Cell["Show text in a list of different colors:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:5",ExpressionUUID->"7d72372d-f1ec-47a1-b5d8-b44fc0ab8e77"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Style", "[", 
    RowBox[{"\"\<hello\>\"", ",", "20", ",", "#"}], "]"}], "&"}], "/@", 
  RowBox[{"{", 
   RowBox[{"Red", ",", "Orange", ",", "Blue", ",", "Purple"}], 
   "}"}]}]], "Input",
 Deletable->False,
 CellLabel->"In[7]:=",ExpressionUUID->"54f71d67-c405-42f4-87ed-1d4a0fac6bdc"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   StyleBox["\<\"hello\"\>",
    StripOnInput->False,
    FontSize->20,
    FontColor->RGBColor[1, 0, 0],
    $CellContext`LineColor -> RGBColor[1, 0, 0],
    $CellContext`FrontFaceColor -> RGBColor[1, 0, 0],
    $CellContext`GraphicsColor -> RGBColor[1, 0, 0],
    $CellContext`BackFaceColor -> RGBColor[1, 0, 0]], ",", 
   StyleBox["\<\"hello\"\>",
    StripOnInput->False,
    FontSize->20,
    FontColor->RGBColor[1, 0.5, 0],
    $CellContext`LineColor -> RGBColor[1, 0.5, 0],
    $CellContext`FrontFaceColor -> RGBColor[1, 0.5, 0],
    $CellContext`GraphicsColor -> RGBColor[1, 0.5, 0],
    $CellContext`BackFaceColor -> RGBColor[1, 0.5, 0]], ",", 
   StyleBox["\<\"hello\"\>",
    StripOnInput->False,
    FontSize->20,
    FontColor->RGBColor[0, 0, 1],
    $CellContext`LineColor -> RGBColor[0, 0, 1],
    $CellContext`FrontFaceColor -> RGBColor[0, 0, 1],
    $CellContext`GraphicsColor -> RGBColor[0, 0, 1],
    $CellContext`BackFaceColor -> RGBColor[0, 0, 1]], ",", 
   StyleBox["\<\"hello\"\>",
    StripOnInput->False,
    FontSize->20,
    FontColor->RGBColor[0.5, 0, 0.5],
    $CellContext`LineColor -> RGBColor[0.5, 0, 0.5],
    $CellContext`FrontFaceColor -> RGBColor[0.5, 0, 0.5],
    $CellContext`GraphicsColor -> RGBColor[0.5, 0, 0.5],
    $CellContext`BackFaceColor -> RGBColor[0.5, 0, 0.5]]}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[7]=",ExpressionUUID->"841212ad-46a2-4d8e-89d4-3f045ab4d8ae"]
}, Open  ]],

Cell["Make circles different sizes:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:6",ExpressionUUID->"075d7a51-0e61-445e-b9fc-6ce5ff21ad22"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{"Circle", "[", "\[ThinSpace]", "]"}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "#"}]}], "]"}], "&"}], "/@", 
  RowBox[{"{", 
   RowBox[{"20", ",", "40", ",", "30", ",", "50", ",", "10"}], 
   "}"}]}]], "Input",
 Deletable->False,
 CellLabel->"In[8]:=",ExpressionUUID->"f43ab330-7803-41f9-95c5-d7033ef7f86f"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[CircleBox[{0, 0}],
    ImageSize->20], ",", 
   GraphicsBox[CircleBox[{0, 0}],
    ImageSize->40], ",", 
   GraphicsBox[CircleBox[{0, 0}],
    ImageSize->30], ",", 
   GraphicsBox[CircleBox[{0, 0}],
    ImageSize->50], ",", 
   GraphicsBox[CircleBox[{0, 0}],
    ImageSize->10]}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[8]=",ExpressionUUID->"57a0eb28-4482-46c7-bbb3-11d2fe928e94"]
}, Open  ]],

Cell["Show framed columns of a color and its negation:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:7",ExpressionUUID->"43238847-53c2-4815-b82d-7aa3ba7ed930"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Framed", "[", 
    RowBox[{"Column", "[", 
     RowBox[{"{", 
      RowBox[{"#", ",", 
       RowBox[{"ColorNegate", "[", "#", "]"}]}], "}"}], "]"}], "]"}], "&"}], "/@", 
  RowBox[{"{", 
   RowBox[{"Red", ",", "Green", ",", "Blue", ",", "Purple", ",", "Orange"}], 
   "}"}]}]], "Input",
 Deletable->False,
 CellLabel->"In[9]:=",ExpressionUUID->"944b0a95-3da5-4061-8e03-2e7987aeea04"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FrameBox[
    TagBox[GridBox[{
       {
        InterpretationBox[
         ButtonBox[
          TooltipBox[
           GraphicsBox[{
             {GrayLevel[0], RectangleBox[{0, 0}]}, 
             {GrayLevel[0], RectangleBox[{1, -1}]}, 
             {RGBColor[1, 0, 0], RectangleBox[{0, -1}, {2, 1}]}},
            AspectRatio->1,
            Frame->True,
            FrameStyle->RGBColor[0.6666666666666666, 0., 0.],
            FrameTicks->None,
            
            ImageSize->
             Dynamic[{
              Automatic, 
               1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                Magnification])}],
            PlotRangePadding->None],
           "RGBColor[1, 0, 0]"],
          Appearance->None,
          BaseStyle->{},
          BaselinePosition->Baseline,
          ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
            If[
             Not[
              AbsoluteCurrentValue["Deployed"]], 
             SelectionMove[Typeset`box$, All, Expression]; 
             FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
             FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 0, 0]; 
             FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
             MathLink`CallFrontEnd[
               FrontEnd`AttachCell[Typeset`box$, 
                FrontEndResource["RGBColorValueSelector"], {
                0, {Left, Bottom}}, {Left, Top}, 
                "ClosingActions" -> {
                 "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
          DefaultBaseStyle->{},
          Evaluator->Automatic,
          Method->"Preemptive"],
         RGBColor[1, 0, 0],
         Editable->False,
         Selectable->False]},
       {
        InterpretationBox[
         ButtonBox[
          TooltipBox[
           GraphicsBox[{
             {GrayLevel[0], RectangleBox[{0, 0}]}, 
             {GrayLevel[0], RectangleBox[{1, -1}]}, 
             {RGBColor[0., 1., 1.], RectangleBox[{0, -1}, {2, 1}]}},
            AspectRatio->1,
            Frame->True,
            FrameStyle->RGBColor[0., 0.6666666666666667, 0.6666666666666667],
            FrameTicks->None,
            
            ImageSize->
             Dynamic[{
              Automatic, 
               1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                Magnification])}],
            PlotRangePadding->None],
           "RGBColor[0., 1., 1.]"],
          Appearance->None,
          BaseStyle->{},
          BaselinePosition->Baseline,
          ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
            If[
             Not[
              AbsoluteCurrentValue["Deployed"]], 
             SelectionMove[Typeset`box$, All, Expression]; 
             FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
             FrontEnd`Private`$ColorSelectorInitialColor = 
              RGBColor[0., 1., 1.]; 
             FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
             MathLink`CallFrontEnd[
               FrontEnd`AttachCell[Typeset`box$, 
                FrontEndResource["RGBColorValueSelector"], {
                0, {Left, Bottom}}, {Left, Top}, 
                "ClosingActions" -> {
                 "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
          DefaultBaseStyle->{},
          Evaluator->Automatic,
          Method->"Preemptive"],
         RGBColor[0., 1., 1.],
         Editable->False,
         Selectable->False]}
      },
      DefaultBaseStyle->"Column",
      GridBoxAlignment->{"Columns" -> {{Left}}},
      GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
     
     "Column"],
    StripOnInput->False], ",", 
   FrameBox[
    TagBox[GridBox[{
       {
        InterpretationBox[
         ButtonBox[
          TooltipBox[
           GraphicsBox[{
             {GrayLevel[0], RectangleBox[{0, 0}]}, 
             {GrayLevel[0], RectangleBox[{1, -1}]}, 
             {RGBColor[0, 1, 0], RectangleBox[{0, -1}, {2, 1}]}},
            AspectRatio->1,
            Frame->True,
            FrameStyle->RGBColor[0., 0.6666666666666666, 0.],
            FrameTicks->None,
            
            ImageSize->
             Dynamic[{
              Automatic, 
               1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                Magnification])}],
            PlotRangePadding->None],
           "RGBColor[0, 1, 0]"],
          Appearance->None,
          BaseStyle->{},
          BaselinePosition->Baseline,
          ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
            If[
             Not[
              AbsoluteCurrentValue["Deployed"]], 
             SelectionMove[Typeset`box$, All, Expression]; 
             FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
             FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[0, 1, 0]; 
             FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
             MathLink`CallFrontEnd[
               FrontEnd`AttachCell[Typeset`box$, 
                FrontEndResource["RGBColorValueSelector"], {
                0, {Left, Bottom}}, {Left, Top}, 
                "ClosingActions" -> {
                 "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
          DefaultBaseStyle->{},
          Evaluator->Automatic,
          Method->"Preemptive"],
         RGBColor[0, 1, 0],
         Editable->False,
         Selectable->False]},
       {
        InterpretationBox[
         ButtonBox[
          TooltipBox[
           GraphicsBox[{
             {GrayLevel[0], RectangleBox[{0, 0}]}, 
             {GrayLevel[0], RectangleBox[{1, -1}]}, 
             {RGBColor[1., 0., 1.], RectangleBox[{0, -1}, {2, 1}]}},
            AspectRatio->1,
            Frame->True,
            FrameStyle->RGBColor[0.6666666666666667, 0., 0.6666666666666667],
            FrameTicks->None,
            
            ImageSize->
             Dynamic[{
              Automatic, 
               1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                Magnification])}],
            PlotRangePadding->None],
           "RGBColor[1., 0., 1.]"],
          Appearance->None,
          BaseStyle->{},
          BaselinePosition->Baseline,
          ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
            If[
             Not[
              AbsoluteCurrentValue["Deployed"]], 
             SelectionMove[Typeset`box$, All, Expression]; 
             FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
             FrontEnd`Private`$ColorSelectorInitialColor = 
              RGBColor[1., 0., 1.]; 
             FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
             MathLink`CallFrontEnd[
               FrontEnd`AttachCell[Typeset`box$, 
                FrontEndResource["RGBColorValueSelector"], {
                0, {Left, Bottom}}, {Left, Top}, 
                "ClosingActions" -> {
                 "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
          DefaultBaseStyle->{},
          Evaluator->Automatic,
          Method->"Preemptive"],
         RGBColor[1., 0., 1.],
         Editable->False,
         Selectable->False]}
      },
      DefaultBaseStyle->"Column",
      GridBoxAlignment->{"Columns" -> {{Left}}},
      GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
     
     "Column"],
    StripOnInput->False], ",", 
   FrameBox[
    TagBox[GridBox[{
       {
        InterpretationBox[
         ButtonBox[
          TooltipBox[
           GraphicsBox[{
             {GrayLevel[0], RectangleBox[{0, 0}]}, 
             {GrayLevel[0], RectangleBox[{1, -1}]}, 
             {RGBColor[0, 0, 1], RectangleBox[{0, -1}, {2, 1}]}},
            AspectRatio->1,
            Frame->True,
            FrameStyle->RGBColor[0., 0., 0.6666666666666666],
            FrameTicks->None,
            
            ImageSize->
             Dynamic[{
              Automatic, 
               1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                Magnification])}],
            PlotRangePadding->None],
           "RGBColor[0, 0, 1]"],
          Appearance->None,
          BaseStyle->{},
          BaselinePosition->Baseline,
          ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
            If[
             Not[
              AbsoluteCurrentValue["Deployed"]], 
             SelectionMove[Typeset`box$, All, Expression]; 
             FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
             FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[0, 0, 1]; 
             FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
             MathLink`CallFrontEnd[
               FrontEnd`AttachCell[Typeset`box$, 
                FrontEndResource["RGBColorValueSelector"], {
                0, {Left, Bottom}}, {Left, Top}, 
                "ClosingActions" -> {
                 "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
          DefaultBaseStyle->{},
          Evaluator->Automatic,
          Method->"Preemptive"],
         RGBColor[0, 0, 1],
         Editable->False,
         Selectable->False]},
       {
        InterpretationBox[
         ButtonBox[
          TooltipBox[
           GraphicsBox[{
             {GrayLevel[0], RectangleBox[{0, 0}]}, 
             {GrayLevel[0], RectangleBox[{1, -1}]}, 
             {RGBColor[1., 1., 0.], RectangleBox[{0, -1}, {2, 1}]}},
            AspectRatio->1,
            Frame->True,
            FrameStyle->RGBColor[0.6666666666666667, 0.6666666666666667, 0.],
            FrameTicks->None,
            
            ImageSize->
             Dynamic[{
              Automatic, 
               1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                Magnification])}],
            PlotRangePadding->None],
           "RGBColor[1., 1., 0.]"],
          Appearance->None,
          BaseStyle->{},
          BaselinePosition->Baseline,
          ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
            If[
             Not[
              AbsoluteCurrentValue["Deployed"]], 
             SelectionMove[Typeset`box$, All, Expression]; 
             FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
             FrontEnd`Private`$ColorSelectorInitialColor = 
              RGBColor[1., 1., 0.]; 
             FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
             MathLink`CallFrontEnd[
               FrontEnd`AttachCell[Typeset`box$, 
                FrontEndResource["RGBColorValueSelector"], {
                0, {Left, Bottom}}, {Left, Top}, 
                "ClosingActions" -> {
                 "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
          DefaultBaseStyle->{},
          Evaluator->Automatic,
          Method->"Preemptive"],
         RGBColor[1., 1., 0.],
         Editable->False,
         Selectable->False]}
      },
      DefaultBaseStyle->"Column",
      GridBoxAlignment->{"Columns" -> {{Left}}},
      GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
     
     "Column"],
    StripOnInput->False], ",", 
   FrameBox[
    TagBox[GridBox[{
       {
        InterpretationBox[
         ButtonBox[
          TooltipBox[
           GraphicsBox[{
             {GrayLevel[0], RectangleBox[{0, 0}]}, 
             {GrayLevel[0], RectangleBox[{1, -1}]}, 
             {RGBColor[0.5, 0, 0.5], RectangleBox[{0, -1}, {2, 1}]}},
            AspectRatio->1,
            Frame->True,
            
            FrameStyle->RGBColor[
             0.33333333333333337`, 0., 0.33333333333333337`],
            FrameTicks->None,
            
            ImageSize->
             Dynamic[{
              Automatic, 
               1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                Magnification])}],
            PlotRangePadding->None],
           "RGBColor[0.5, 0, 0.5]"],
          Appearance->None,
          BaseStyle->{},
          BaselinePosition->Baseline,
          ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
            If[
             Not[
              AbsoluteCurrentValue["Deployed"]], 
             SelectionMove[Typeset`box$, All, Expression]; 
             FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
             FrontEnd`Private`$ColorSelectorInitialColor = 
              RGBColor[0.5, 0, 0.5]; 
             FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
             MathLink`CallFrontEnd[
               FrontEnd`AttachCell[Typeset`box$, 
                FrontEndResource["RGBColorValueSelector"], {
                0, {Left, Bottom}}, {Left, Top}, 
                "ClosingActions" -> {
                 "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
          DefaultBaseStyle->{},
          Evaluator->Automatic,
          Method->"Preemptive"],
         RGBColor[0.5, 0, 0.5],
         Editable->False,
         Selectable->False]},
       {
        InterpretationBox[
         ButtonBox[
          TooltipBox[
           GraphicsBox[{
             {GrayLevel[0], RectangleBox[{0, 0}]}, 
             {GrayLevel[0], RectangleBox[{1, -1}]}, 
             {RGBColor[0.5, 1., 0.5], RectangleBox[{0, -1}, {2, 1}]}},
            AspectRatio->1,
            Frame->True,
            
            FrameStyle->RGBColor[
             0.33333333333333337`, 0.6666666666666667, 0.33333333333333337`],
            FrameTicks->None,
            
            ImageSize->
             Dynamic[{
              Automatic, 
               1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                Magnification])}],
            PlotRangePadding->None],
           "RGBColor[0.5, 1., 0.5]"],
          Appearance->None,
          BaseStyle->{},
          BaselinePosition->Baseline,
          ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
            If[
             Not[
              AbsoluteCurrentValue["Deployed"]], 
             SelectionMove[Typeset`box$, All, Expression]; 
             FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
             FrontEnd`Private`$ColorSelectorInitialColor = 
              RGBColor[0.5, 1., 0.5]; 
             FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
             MathLink`CallFrontEnd[
               FrontEnd`AttachCell[Typeset`box$, 
                FrontEndResource["RGBColorValueSelector"], {
                0, {Left, Bottom}}, {Left, Top}, 
                "ClosingActions" -> {
                 "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
          DefaultBaseStyle->{},
          Evaluator->Automatic,
          Method->"Preemptive"],
         RGBColor[0.5, 1., 0.5],
         Editable->False,
         Selectable->False]}
      },
      DefaultBaseStyle->"Column",
      GridBoxAlignment->{"Columns" -> {{Left}}},
      GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
     
     "Column"],
    StripOnInput->False], ",", 
   FrameBox[
    TagBox[GridBox[{
       {
        InterpretationBox[
         ButtonBox[
          TooltipBox[
           GraphicsBox[{
             {GrayLevel[0], RectangleBox[{0, 0}]}, 
             {GrayLevel[0], RectangleBox[{1, -1}]}, 
             {RGBColor[1, 0.5, 0], RectangleBox[{0, -1}, {2, 1}]}},
            AspectRatio->1,
            Frame->True,
            FrameStyle->RGBColor[0.6666666666666666, 0.33333333333333337`, 0.],
            FrameTicks->None,
            
            ImageSize->
             Dynamic[{
              Automatic, 
               1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                Magnification])}],
            PlotRangePadding->None],
           "RGBColor[1, 0.5, 0]"],
          Appearance->None,
          BaseStyle->{},
          BaselinePosition->Baseline,
          ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
            If[
             Not[
              AbsoluteCurrentValue["Deployed"]], 
             SelectionMove[Typeset`box$, All, Expression]; 
             FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
             FrontEnd`Private`$ColorSelectorInitialColor = 
              RGBColor[1, 0.5, 0]; 
             FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
             MathLink`CallFrontEnd[
               FrontEnd`AttachCell[Typeset`box$, 
                FrontEndResource["RGBColorValueSelector"], {
                0, {Left, Bottom}}, {Left, Top}, 
                "ClosingActions" -> {
                 "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
          DefaultBaseStyle->{},
          Evaluator->Automatic,
          Method->"Preemptive"],
         RGBColor[1, 0.5, 0],
         Editable->False,
         Selectable->False]},
       {
        InterpretationBox[
         ButtonBox[
          TooltipBox[
           GraphicsBox[{
             {GrayLevel[0], RectangleBox[{0, 0}]}, 
             {GrayLevel[0], RectangleBox[{1, -1}]}, 
             {RGBColor[0., 0.5, 1.], RectangleBox[{0, -1}, {2, 1}]}},
            AspectRatio->1,
            Frame->True,
            FrameStyle->RGBColor[0., 0.33333333333333337`, 0.6666666666666667],
            FrameTicks->None,
            
            ImageSize->
             Dynamic[{
              Automatic, 
               1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                Magnification])}],
            PlotRangePadding->None],
           "RGBColor[0., 0.5, 1.]"],
          Appearance->None,
          BaseStyle->{},
          BaselinePosition->Baseline,
          ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
            If[
             Not[
              AbsoluteCurrentValue["Deployed"]], 
             SelectionMove[Typeset`box$, All, Expression]; 
             FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
             FrontEnd`Private`$ColorSelectorInitialColor = 
              RGBColor[0., 0.5, 1.]; 
             FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
             MathLink`CallFrontEnd[
               FrontEnd`AttachCell[Typeset`box$, 
                FrontEndResource["RGBColorValueSelector"], {
                0, {Left, Bottom}}, {Left, Top}, 
                "ClosingActions" -> {
                 "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
          DefaultBaseStyle->{},
          Evaluator->Automatic,
          Method->"Preemptive"],
         RGBColor[0., 0.5, 1.],
         Editable->False,
         Selectable->False]}
      },
      DefaultBaseStyle->"Column",
      GridBoxAlignment->{"Columns" -> {{Left}}},
      GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
     
     "Column"],
    StripOnInput->False]}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[9]=",ExpressionUUID->"14313f4a-e2e3-4e68-99d9-e76b707fd29c"]
}, Open  ]],

Cell["Compute the lengths of three Wikipedia articles:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:8",ExpressionUUID->"0e2788a2-3cdf-4f23-a50c-056880074be5"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"StringLength", "[", 
    RowBox[{"WikipediaData", "[", "#", "]"}], "]"}], "&"}], "/@", 
  RowBox[{"{", 
   RowBox[{"\"\<apple\>\"", ",", "\"\<peach\>\"", ",", "\"\<pear\>\""}], 
   "}"}]}]], "Input",
 Deletable->False,
 CellLabel->"In[10]:=",ExpressionUUID->"d3dc421e-dd66-4cb0-9a86-a3f8d6e2e1b6"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"31045", ",", "24153", ",", "11115"}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[10]=",ExpressionUUID->"8e9d8c40-2a55-4dc0-b6b8-2978c6971b63"]
}, Open  ]],

Cell["Pair topics with results:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"ac49fcd8-ef25-4265-888c-8dba1eda89e5"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"#", ",", 
     RowBox[{"StringLength", "[", 
      RowBox[{"WikipediaData", "[", "#", "]"}], "]"}]}], "}"}], "&"}], "/@", 
  RowBox[{"{", 
   RowBox[{"\"\<apple\>\"", ",", "\"\<peach\>\"", ",", "\"\<pear\>\""}], 
   "}"}]}]], "Input",
 Deletable->False,
 CellLabel->"In[11]:=",ExpressionUUID->"4ab47c2c-1f6d-4386-9c77-73b3e9249c3f"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"apple\"\>", ",", "31045"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"peach\"\>", ",", "24153"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\<\"pear\"\>", ",", "11115"}], "}"}]}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellTags->"LastCellOfAPage",
 CellLabel->"Out[11]=",ExpressionUUID->"828f1972-b4ca-45dd-9f09-ee9fd54acedd"]
}, Open  ]],

Cell["Make a grid of everything:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->{
  "p:149", "i:9"},ExpressionUUID->"c58a4916-a396-4c8b-a436-e53cdfbac21e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{"#", ",", 
      RowBox[{"StringLength", "[", 
       RowBox[{"WikipediaData", "[", "#", "]"}], "]"}]}], "}"}], "&"}], "/@", 
   
   RowBox[{"{", 
    RowBox[{"\"\<apple\>\"", ",", "\"\<peach\>\"", ",", "\"\<pear\>\""}], 
    "}"}]}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[12]:=",ExpressionUUID->"76e713d5-9ede-48e9-88dc-e7e5fa5696d3"],

Cell[BoxData[
 TagBox[GridBox[{
    {"\<\"apple\"\>", "31045"},
    {"\<\"peach\"\>", "24153"},
    {"\<\"pear\"\>", "11115"}
   },
   AutoDelete->False,
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
  "Grid"]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[12]=",ExpressionUUID->"fe225b85-025f-46db-8b1e-1d1cae097045"]
}, Open  ]],

Cell["\<\
This makes a list of digits, then maps a pure function over it:\
\>", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:10",ExpressionUUID->"e53f48b9-62f9-41ae-ba6b-1846e25693cb"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Style", "[", 
    RowBox[{"#", ",", 
     RowBox[{"Hue", "[", 
      RowBox[{"#", "/", "10"}], "]"}], ",", 
     RowBox[{"5", "*", "#"}]}], "]"}], "&"}], "/@", 
  RowBox[{"IntegerDigits", "[", 
   RowBox[{"2", "^", "100"}], "]"}]}]], "Input",
 Deletable->False,
 CellLabel->"In[13]:=",ExpressionUUID->"3d46c951-2bc2-490d-bfc0-6d6ad523b43f"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   StyleBox["1",
    StripOnInput->False,
    FontSize->5,
    FontColor->Hue[
      Rational[1, 10]],
    $CellContext`LineColor -> Hue[
      Rational[1, 10]],
    $CellContext`FrontFaceColor -> Hue[
      Rational[1, 10]],
    $CellContext`GraphicsColor -> Hue[
      Rational[1, 10]],
    $CellContext`BackFaceColor -> Hue[
      Rational[1, 10]]], ",", 
   StyleBox["2",
    StripOnInput->False,
    FontSize->10,
    FontColor->Hue[
      Rational[1, 5]],
    $CellContext`LineColor -> Hue[
      Rational[1, 5]],
    $CellContext`FrontFaceColor -> Hue[
      Rational[1, 5]],
    $CellContext`GraphicsColor -> Hue[
      Rational[1, 5]],
    $CellContext`BackFaceColor -> Hue[
      Rational[1, 5]]], ",", 
   StyleBox["6",
    StripOnInput->False,
    FontSize->30,
    FontColor->Hue[
      Rational[3, 5]],
    $CellContext`LineColor -> Hue[
      Rational[3, 5]],
    $CellContext`FrontFaceColor -> Hue[
      Rational[3, 5]],
    $CellContext`GraphicsColor -> Hue[
      Rational[3, 5]],
    $CellContext`BackFaceColor -> Hue[
      Rational[3, 5]]], ",", 
   StyleBox["7",
    StripOnInput->False,
    FontSize->35,
    FontColor->Hue[
      Rational[7, 10]],
    $CellContext`LineColor -> Hue[
      Rational[7, 10]],
    $CellContext`FrontFaceColor -> Hue[
      Rational[7, 10]],
    $CellContext`GraphicsColor -> Hue[
      Rational[7, 10]],
    $CellContext`BackFaceColor -> Hue[
      Rational[7, 10]]], ",", 
   StyleBox["6",
    StripOnInput->False,
    FontSize->30,
    FontColor->Hue[
      Rational[3, 5]],
    $CellContext`LineColor -> Hue[
      Rational[3, 5]],
    $CellContext`FrontFaceColor -> Hue[
      Rational[3, 5]],
    $CellContext`GraphicsColor -> Hue[
      Rational[3, 5]],
    $CellContext`BackFaceColor -> Hue[
      Rational[3, 5]]], ",", 
   StyleBox["5",
    StripOnInput->False,
    FontSize->25,
    FontColor->Hue[
      Rational[1, 2]],
    $CellContext`LineColor -> Hue[
      Rational[1, 2]],
    $CellContext`FrontFaceColor -> Hue[
      Rational[1, 2]],
    $CellContext`GraphicsColor -> Hue[
      Rational[1, 2]],
    $CellContext`BackFaceColor -> Hue[
      Rational[1, 2]]], ",", 
   StyleBox["0",
    StripOnInput->False,
    FontSize->0,
    FontColor->Hue[0],
    $CellContext`LineColor -> Hue[0],
    $CellContext`FrontFaceColor -> Hue[0],
    $CellContext`GraphicsColor -> Hue[0],
    $CellContext`BackFaceColor -> Hue[0]], ",", 
   StyleBox["6",
    StripOnInput->False,
    FontSize->30,
    FontColor->Hue[
      Rational[3, 5]],
    $CellContext`LineColor -> Hue[
      Rational[3, 5]],
    $CellContext`FrontFaceColor -> Hue[
      Rational[3, 5]],
    $CellContext`GraphicsColor -> Hue[
      Rational[3, 5]],
    $CellContext`BackFaceColor -> Hue[
      Rational[3, 5]]], ",", 
   StyleBox["0",
    StripOnInput->False,
    FontSize->0,
    FontColor->Hue[0],
    $CellContext`LineColor -> Hue[0],
    $CellContext`FrontFaceColor -> Hue[0],
    $CellContext`GraphicsColor -> Hue[0],
    $CellContext`BackFaceColor -> Hue[0]], ",", 
   StyleBox["0",
    StripOnInput->False,
    FontSize->0,
    FontColor->Hue[0],
    $CellContext`LineColor -> Hue[0],
    $CellContext`FrontFaceColor -> Hue[0],
    $CellContext`GraphicsColor -> Hue[0],
    $CellContext`BackFaceColor -> Hue[0]], ",", 
   StyleBox["2",
    StripOnInput->False,
    FontSize->10,
    FontColor->Hue[
      Rational[1, 5]],
    $CellContext`LineColor -> Hue[
      Rational[1, 5]],
    $CellContext`FrontFaceColor -> Hue[
      Rational[1, 5]],
    $CellContext`GraphicsColor -> Hue[
      Rational[1, 5]],
    $CellContext`BackFaceColor -> Hue[
      Rational[1, 5]]], ",", 
   StyleBox["2",
    StripOnInput->False,
    FontSize->10,
    FontColor->Hue[
      Rational[1, 5]],
    $CellContext`LineColor -> Hue[
      Rational[1, 5]],
    $CellContext`FrontFaceColor -> Hue[
      Rational[1, 5]],
    $CellContext`GraphicsColor -> Hue[
      Rational[1, 5]],
    $CellContext`BackFaceColor -> Hue[
      Rational[1, 5]]], ",", 
   StyleBox["8",
    StripOnInput->False,
    FontSize->40,
    FontColor->Hue[
      Rational[4, 5]],
    $CellContext`LineColor -> Hue[
      Rational[4, 5]],
    $CellContext`FrontFaceColor -> Hue[
      Rational[4, 5]],
    $CellContext`GraphicsColor -> Hue[
      Rational[4, 5]],
    $CellContext`BackFaceColor -> Hue[
      Rational[4, 5]]], ",", 
   StyleBox["2",
    StripOnInput->False,
    FontSize->10,
    FontColor->Hue[
      Rational[1, 5]],
    $CellContext`LineColor -> Hue[
      Rational[1, 5]],
    $CellContext`FrontFaceColor -> Hue[
      Rational[1, 5]],
    $CellContext`GraphicsColor -> Hue[
      Rational[1, 5]],
    $CellContext`BackFaceColor -> Hue[
      Rational[1, 5]]], ",", 
   StyleBox["2",
    StripOnInput->False,
    FontSize->10,
    FontColor->Hue[
      Rational[1, 5]],
    $CellContext`LineColor -> Hue[
      Rational[1, 5]],
    $CellContext`FrontFaceColor -> Hue[
      Rational[1, 5]],
    $CellContext`GraphicsColor -> Hue[
      Rational[1, 5]],
    $CellContext`BackFaceColor -> Hue[
      Rational[1, 5]]], ",", 
   StyleBox["9",
    StripOnInput->False,
    FontSize->45,
    FontColor->Hue[
      Rational[9, 10]],
    $CellContext`LineColor -> Hue[
      Rational[9, 10]],
    $CellContext`FrontFaceColor -> Hue[
      Rational[9, 10]],
    $CellContext`GraphicsColor -> Hue[
      Rational[9, 10]],
    $CellContext`BackFaceColor -> Hue[
      Rational[9, 10]]], ",", 
   StyleBox["4",
    StripOnInput->False,
    FontSize->20,
    FontColor->Hue[
      Rational[2, 5]],
    $CellContext`LineColor -> Hue[
      Rational[2, 5]],
    $CellContext`FrontFaceColor -> Hue[
      Rational[2, 5]],
    $CellContext`GraphicsColor -> Hue[
      Rational[2, 5]],
    $CellContext`BackFaceColor -> Hue[
      Rational[2, 5]]], ",", 
   StyleBox["0",
    StripOnInput->False,
    FontSize->0,
    FontColor->Hue[0],
    $CellContext`LineColor -> Hue[0],
    $CellContext`FrontFaceColor -> Hue[0],
    $CellContext`GraphicsColor -> Hue[0],
    $CellContext`BackFaceColor -> Hue[0]], ",", 
   StyleBox["1",
    StripOnInput->False,
    FontSize->5,
    FontColor->Hue[
      Rational[1, 10]],
    $CellContext`LineColor -> Hue[
      Rational[1, 10]],
    $CellContext`FrontFaceColor -> Hue[
      Rational[1, 10]],
    $CellContext`GraphicsColor -> Hue[
      Rational[1, 10]],
    $CellContext`BackFaceColor -> Hue[
      Rational[1, 10]]], ",", 
   StyleBox["4",
    StripOnInput->False,
    FontSize->20,
    FontColor->Hue[
      Rational[2, 5]],
    $CellContext`LineColor -> Hue[
      Rational[2, 5]],
    $CellContext`FrontFaceColor -> Hue[
      Rational[2, 5]],
    $CellContext`GraphicsColor -> Hue[
      Rational[2, 5]],
    $CellContext`BackFaceColor -> Hue[
      Rational[2, 5]]], ",", 
   StyleBox["9",
    StripOnInput->False,
    FontSize->45,
    FontColor->Hue[
      Rational[9, 10]],
    $CellContext`LineColor -> Hue[
      Rational[9, 10]],
    $CellContext`FrontFaceColor -> Hue[
      Rational[9, 10]],
    $CellContext`GraphicsColor -> Hue[
      Rational[9, 10]],
    $CellContext`BackFaceColor -> Hue[
      Rational[9, 10]]], ",", 
   StyleBox["6",
    StripOnInput->False,
    FontSize->30,
    FontColor->Hue[
      Rational[3, 5]],
    $CellContext`LineColor -> Hue[
      Rational[3, 5]],
    $CellContext`FrontFaceColor -> Hue[
      Rational[3, 5]],
    $CellContext`GraphicsColor -> Hue[
      Rational[3, 5]],
    $CellContext`BackFaceColor -> Hue[
      Rational[3, 5]]], ",", 
   StyleBox["7",
    StripOnInput->False,
    FontSize->35,
    FontColor->Hue[
      Rational[7, 10]],
    $CellContext`LineColor -> Hue[
      Rational[7, 10]],
    $CellContext`FrontFaceColor -> Hue[
      Rational[7, 10]],
    $CellContext`GraphicsColor -> Hue[
      Rational[7, 10]],
    $CellContext`BackFaceColor -> Hue[
      Rational[7, 10]]], ",", 
   StyleBox["0",
    StripOnInput->False,
    FontSize->0,
    FontColor->Hue[0],
    $CellContext`LineColor -> Hue[0],
    $CellContext`FrontFaceColor -> Hue[0],
    $CellContext`GraphicsColor -> Hue[0],
    $CellContext`BackFaceColor -> Hue[0]], ",", 
   StyleBox["3",
    StripOnInput->False,
    FontSize->15,
    FontColor->Hue[
      Rational[3, 10]],
    $CellContext`LineColor -> Hue[
      Rational[3, 10]],
    $CellContext`FrontFaceColor -> Hue[
      Rational[3, 10]],
    $CellContext`GraphicsColor -> Hue[
      Rational[3, 10]],
    $CellContext`BackFaceColor -> Hue[
      Rational[3, 10]]], ",", 
   StyleBox["2",
    StripOnInput->False,
    FontSize->10,
    FontColor->Hue[
      Rational[1, 5]],
    $CellContext`LineColor -> Hue[
      Rational[1, 5]],
    $CellContext`FrontFaceColor -> Hue[
      Rational[1, 5]],
    $CellContext`GraphicsColor -> Hue[
      Rational[1, 5]],
    $CellContext`BackFaceColor -> Hue[
      Rational[1, 5]]], ",", 
   StyleBox["0",
    StripOnInput->False,
    FontSize->0,
    FontColor->Hue[0],
    $CellContext`LineColor -> Hue[0],
    $CellContext`FrontFaceColor -> Hue[0],
    $CellContext`GraphicsColor -> Hue[0],
    $CellContext`BackFaceColor -> Hue[0]], ",", 
   StyleBox["5",
    StripOnInput->False,
    FontSize->25,
    FontColor->Hue[
      Rational[1, 2]],
    $CellContext`LineColor -> Hue[
      Rational[1, 2]],
    $CellContext`FrontFaceColor -> Hue[
      Rational[1, 2]],
    $CellContext`GraphicsColor -> Hue[
      Rational[1, 2]],
    $CellContext`BackFaceColor -> Hue[
      Rational[1, 2]]], ",", 
   StyleBox["3",
    StripOnInput->False,
    FontSize->15,
    FontColor->Hue[
      Rational[3, 10]],
    $CellContext`LineColor -> Hue[
      Rational[3, 10]],
    $CellContext`FrontFaceColor -> Hue[
      Rational[3, 10]],
    $CellContext`GraphicsColor -> Hue[
      Rational[3, 10]],
    $CellContext`BackFaceColor -> Hue[
      Rational[3, 10]]], ",", 
   StyleBox["7",
    StripOnInput->False,
    FontSize->35,
    FontColor->Hue[
      Rational[7, 10]],
    $CellContext`LineColor -> Hue[
      Rational[7, 10]],
    $CellContext`FrontFaceColor -> Hue[
      Rational[7, 10]],
    $CellContext`GraphicsColor -> Hue[
      Rational[7, 10]],
    $CellContext`BackFaceColor -> Hue[
      Rational[7, 10]]], ",", 
   StyleBox["6",
    StripOnInput->False,
    FontSize->30,
    FontColor->Hue[
      Rational[3, 5]],
    $CellContext`LineColor -> Hue[
      Rational[3, 5]],
    $CellContext`FrontFaceColor -> Hue[
      Rational[3, 5]],
    $CellContext`GraphicsColor -> Hue[
      Rational[3, 5]],
    $CellContext`BackFaceColor -> Hue[
      Rational[3, 5]]]}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[13]=",ExpressionUUID->"3729d1b4-2203-47f7-b586-7c83b22bdd00"]
}, Open  ]],

Cell[TextData[{
 "Here\[CloseCurlyQuote]s what the pure function would do if mapped over ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"6", ",", "8", ",", "9"}], "}"}]], "InlineCode",ExpressionUUID->
  "13174721-a80c-47d5-a24c-fb756ad44475"],
 ":"
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"cc65a866-1a97-4dfa-b89a-0bdc649dd5f5"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Style", "[", 
    RowBox[{"6", ",", 
     RowBox[{"Hue", "[", 
      RowBox[{"6", "/", "10"}], "]"}], ",", 
     RowBox[{"5", "*", "6"}]}], "]"}], ",", 
   RowBox[{"Style", "[", 
    RowBox[{"8", ",", 
     RowBox[{"Hue", "[", 
      RowBox[{"8", "/", "10"}], "]"}], ",", 
     RowBox[{"5", "*", "8"}]}], "]"}], ",", 
   RowBox[{"Style", "[", 
    RowBox[{"9", ",", 
     RowBox[{"Hue", "[", 
      RowBox[{"9", "/", "10"}], "]"}], ",", 
     RowBox[{"5", "*", "9"}]}], "]"}]}], "}"}]], "Input",
 Deletable->False,
 CellLabel->"In[14]:=",ExpressionUUID->"45871b2d-7ba0-4d65-8c62-3043bad1e262"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   StyleBox["6",
    StripOnInput->False,
    FontSize->30,
    FontColor->Hue[
      Rational[3, 5]],
    $CellContext`LineColor -> Hue[
      Rational[3, 5]],
    $CellContext`FrontFaceColor -> Hue[
      Rational[3, 5]],
    $CellContext`GraphicsColor -> Hue[
      Rational[3, 5]],
    $CellContext`BackFaceColor -> Hue[
      Rational[3, 5]]], ",", 
   StyleBox["8",
    StripOnInput->False,
    FontSize->40,
    FontColor->Hue[
      Rational[4, 5]],
    $CellContext`LineColor -> Hue[
      Rational[4, 5]],
    $CellContext`FrontFaceColor -> Hue[
      Rational[4, 5]],
    $CellContext`GraphicsColor -> Hue[
      Rational[4, 5]],
    $CellContext`BackFaceColor -> Hue[
      Rational[4, 5]]], ",", 
   StyleBox["9",
    StripOnInput->False,
    FontSize->45,
    FontColor->Hue[
      Rational[9, 10]],
    $CellContext`LineColor -> Hue[
      Rational[9, 10]],
    $CellContext`FrontFaceColor -> Hue[
      Rational[9, 10]],
    $CellContext`GraphicsColor -> Hue[
      Rational[9, 10]],
    $CellContext`BackFaceColor -> Hue[
      Rational[9, 10]]]}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[14]=",ExpressionUUID->"92bdb59e-31ee-44d2-a5a5-232208f252ed"]
}, Open  ]],

Cell["\<\
Now that we\[CloseCurlyQuote]ve seen some examples of pure functions in \
action, let\[CloseCurlyQuote]s look more abstractly at \
what\[CloseCurlyQuote]s going on. \
\>", "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"d9c3931b-b765-4db8-9d3c-b265cfbc5322"],

Cell["This maps an abstract pure function over a list: ", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"eafb90c3-c880-4cfe-bb44-5da27c4e2c7d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"#", ",", "x"}], "]"}], "&"}], "/@", 
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}]}]], "Input",
 Deletable->False,
 CellLabel->"In[15]:=",ExpressionUUID->"39a23258-bf5a-4a4f-88c9-1c25b8389d79"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"a", ",", "x"}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"b", ",", "x"}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"c", ",", "x"}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"d", ",", "x"}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"e", ",", "x"}], "]"}]}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[15]=",ExpressionUUID->"4cceb998-2f2d-4f76-8199-7a5366a5be80"]
}, Open  ]],

Cell["Here\[CloseCurlyQuote]s the minimal example:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"7156013c-039d-471b-a58b-c61e5dcf8c2a"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", "#", "]"}], "&"}], "/@", 
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}]}]], "Input",
 Deletable->False,
 CellLabel->"In[16]:=",ExpressionUUID->"8b05ef2e-17b5-41eb-9e35-e2c17c17a487"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"f", "[", "a", "]"}], ",", 
   RowBox[{"f", "[", "b", "]"}], ",", 
   RowBox[{"f", "[", "c", "]"}], ",", 
   RowBox[{"f", "[", "d", "]"}], ",", 
   RowBox[{"f", "[", "e", "]"}]}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[16]=",ExpressionUUID->"9fa0baf6-9e50-46d1-ad18-8ab4cec13a58"]
}, Open  ]],

Cell["It\[CloseCurlyQuote]s equivalent to:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"04f927c4-b57a-4807-93fb-cb0adaa193df"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "/@", 
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}]}]], "Input",
 Deletable->False,
 CellLabel->"In[17]:=",ExpressionUUID->"5d50c1f0-38dd-445c-a228-5a7f2d3c956f"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"f", "[", "a", "]"}], ",", 
   RowBox[{"f", "[", "b", "]"}], ",", 
   RowBox[{"f", "[", "c", "]"}], ",", 
   RowBox[{"f", "[", "d", "]"}], ",", 
   RowBox[{"f", "[", "e", "]"}]}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[17]=",ExpressionUUID->"6950389b-cd99-4191-8a5b-4895865cd4f5"]
}, Open  ]],

Cell["\<\
We can put slots wherever we want in the pure function, as many times as we \
want. All the slots will get filled with whatever the pure function is \
applied to.\
\>", "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"619ee195-f116-4056-88f8-21effcc74caa"],

Cell["Apply a slightly more complicated pure function:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"b3bf2215-f922-441a-9d95-d887cc1176ea"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"#", ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "#"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"#", ",", "#"}], "}"}]}], "]"}], "&"}], "/@", 
  RowBox[{"{", 
   RowBox[{"a", ",", "b", ",", "c"}], "}"}]}]], "Input",
 Deletable->False,
 CellLabel->"In[18]:=",ExpressionUUID->"84d8f33e-52ff-48a3-ad02-606b8604d44c"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"a", ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "a"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"a", ",", "a"}], "}"}]}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"b", ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "b"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"b", ",", "b"}], "}"}]}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"c", ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "c"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c", ",", "c"}], "}"}]}], "]"}]}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellTags->"LastCellOfAPage",
 CellLabel->"Out[18]=",ExpressionUUID->"a3303967-0a82-4850-b549-8996b88f8bfb"]
}, Open  ]],

Cell["It\[CloseCurlyQuote]s easier to read in a column:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"p:150",ExpressionUUID->"6708b3dc-5d95-4e13-8648-cb8351433270"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"f", "[", 
     RowBox[{"#", ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "#"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"#", ",", "#"}], "}"}]}], "]"}], "&"}], "/@", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}]}], "//", "Column"}]], "Input",
 Deletable->False,
 CellLabel->"In[19]:=",ExpressionUUID->"de7ff3c4-a5ac-4c65-b5a9-27f7f921bfa7"],

Cell[BoxData[
 TagBox[GridBox[{
    {
     RowBox[{"f", "[", 
      RowBox[{"a", ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "a"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"a", ",", "a"}], "}"}]}], "]"}]},
    {
     RowBox[{"f", "[", 
      RowBox[{"b", ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "b"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"b", ",", "b"}], "}"}]}], "]"}]},
    {
     RowBox[{"f", "[", 
      RowBox[{"c", ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "c"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"c", ",", "c"}], "}"}]}], "]"}]}
   },
   DefaultBaseStyle->"Column",
   GridBoxAlignment->{"Columns" -> {{Left}}},
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
  "Column"]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[19]=",ExpressionUUID->"4982067e-b9e4-4f73-9279-629fe61c1489"]
}, Open  ]],

Cell[TextData[{
 "OK, now we\[CloseCurlyQuote]re ready to finally discuss how pure functions \
really work. When we write ",
 Cell[BoxData[
  RowBox[{"f", "[", "x", "]"}]], "InlineCodeText",ExpressionUUID->
  "a12b6d96-6a4e-4aac-b9db-3a500a6290bf"],
 ", we\[CloseCurlyQuote]re applying the function ",
 Cell[BoxData[
 "f"], "InlineCodeText",ExpressionUUID->
  "aa818cb0-d086-4f77-89fe-504cad74d5bd"],
 " to ",
 Cell[BoxData[
 "x"], "InlineCodeText",ExpressionUUID->
  "4852b226-2dc2-4f74-af56-9e35a4eae83c"],
 ". Often we\[CloseCurlyQuote]ll use a specific named function instead of ",
 Cell[BoxData[
 "f"], "InlineCodeText",ExpressionUUID->
  "8eae6a7c-6615-4fae-b503-bcb85299ff3a"],
 ", say ",
 ButtonBox["Blur",
  BaseStyle->"Link"],
 ", so we have ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Blur",
    BaseStyle->"CodeLink"], "[", "x", "]"}]], "InlineCodeText",ExpressionUUID->
  "54cee043-8eae-4041-879f-90f72a1fb6dc"],
 ", etc."
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"d97fd7fe-d5a4-49e6-a27c-3ac5367c2559"],

Cell[TextData[{
 "But the point is that we can also replace ",
 Cell[BoxData[
 "f"], "InlineCodeText",ExpressionUUID->
  "da92574e-49a1-4a47-8261-3a7a63d84ca4"],
 " with a pure function. Then whatever we apply this to will be used to fill \
the slot in the pure function."
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"efcf2342-64d0-4850-9a38-228539799321"],

Cell[TextData[{
 "Apply a pure function to ",
 Cell[BoxData[
 "x"], "InlineCode",ExpressionUUID->"4ba96068-2906-4e16-8326-c71b23f9d5d4"],
 ", so the ",
 Cell[BoxData[
  ButtonBox["#",
   BaseStyle->"Link",
   ButtonData->"Slot"]], "InlineCode",ExpressionUUID->
  "ccd7d98c-95ff-4ee5-828d-a87d2875ccbc"],
 " slot gets filled with ",
 Cell[BoxData[
 "x"], "InlineCode",ExpressionUUID->"f8df4d0f-3f24-4b5a-a942-6c9b06010e5a"],
 ":"
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"24aa3f3a-a76d-4dce-8660-de4edf7d45c8"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"#", ",", "a"}], "]"}], "&"}], "  ", "[", "x", "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[20]:=",ExpressionUUID->"41d6b94f-77ca-4448-9dd2-bdf5904885a8"],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"x", ",", "a"}], "]"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[20]=",ExpressionUUID->"f8d5b3c4-0105-4c1c-866e-5a716d4e54da"]
}, Open  ]],

Cell[TextData[{
 "An equivalent form, written with ",
 Cell[BoxData[
  ButtonBox["@",
   BaseStyle->"Link",
   ButtonData->"Prefix"]], "InlineCode",ExpressionUUID->
  "6e43c837-b8ed-412e-b748-2d1cfe08cb2f"],
 " instead of ",
 Cell[BoxData[
  RowBox[{"[", "\[ThinSpace]", "...", "\[ThinSpace]", "]"}]], "InlineCode",
  ExpressionUUID->"38a9a3f2-8ffe-4531-97d2-64de5915246c"],
 ":"
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"6902d283-176e-4fe7-82ad-2adfaa8054f8"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"#", ",", "a"}], "]"}], "&"}], " ", "@", " ", "x"}]], "Input",
 Deletable->False,
 CellLabel->"In[21]:=",ExpressionUUID->"dc6b0d19-79f9-4599-bc5c-7276248a6e02"],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"x", ",", "a"}], "]"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[21]=",ExpressionUUID->"84ef5e86-a52c-436e-a1fe-095dad6eec05"]
}, Open  ]],

Cell[TextData[{
 "So now we can see what ",
 Cell[BoxData[
  ButtonBox["/@",
   BaseStyle->"Link",
   ButtonData->"Map"]], "InlineCodeText",ExpressionUUID->
  "3852e1c1-214e-497b-a6d1-68aaa5a68e34"],
 " is doing: it\[CloseCurlyQuote]s just applying the pure function to each \
element in the list."
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"46ca2bf2-f5af-4fb5-b263-007cbfc905e8"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"#", ",", "a"}], "]"}], "&"}], "/@", 
  RowBox[{"{", 
   RowBox[{"x", ",", "y", ",", "z"}], "}"}]}]], "Input",
 Deletable->False,
 CellLabel->"In[22]:=",ExpressionUUID->"3b96dea0-75ca-4edd-8829-01c990513b68"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"x", ",", "a"}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"y", ",", "a"}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"z", ",", "a"}], "]"}]}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[22]=",ExpressionUUID->"7fa5e479-a92b-4d0e-9e82-753391b1828b"]
}, Open  ]],

Cell["The same thing, written out more explicitly:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"abd29332-7c4b-4b6a-b35a-4caca8f1cf6d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"f", "[", 
      RowBox[{"#", ",", "a"}], "]"}], "&"}], " ", "@", " ", "x"}], ",", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"f", "[", 
      RowBox[{"#", ",", "a"}], "]"}], "&"}], " ", "@", " ", "y"}], ",", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"f", "[", 
      RowBox[{"#", ",", "a"}], "]"}], "&"}], " ", "@", " ", "z"}]}], 
  "}"}]], "Input",
 Deletable->False,
 CellLabel->"In[23]:=",ExpressionUUID->"27ce2bb2-ca5b-4757-88ae-c59128606aff"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"x", ",", "a"}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"y", ",", "a"}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"z", ",", "a"}], "]"}]}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[23]=",ExpressionUUID->"11502bd3-0c8d-4395-ac5d-d79a91839813"]
}, Open  ]],

Cell[TextData[{
 "Why is this useful? First of all, because it\[CloseCurlyQuote]s the \
foundation for all the things pure functions do with ",
 Cell[BoxData[
  ButtonBox["/@",
   BaseStyle->"Link",
   ButtonData->"Map"]], "InlineCodeText",ExpressionUUID->
  "a0ee75e3-8226-415b-9500-6f843aed2623"],
 ". But ",
 "it\[CloseCurlyQuote]s actually also often useful",
 " on its own, for example as a way to avoid having to repeat things."
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"cd7029e6-c3d4-4679-bd0c-204479a337a2"],

Cell[TextData[{
 "Here\[CloseCurlyQuote]s an example of a pure function involving three \
occurrences of ",
 Cell[BoxData[
  ButtonBox["#",
   BaseStyle->"Link",
   ButtonData->"Slot"]], "InlineCodeText",ExpressionUUID->
  "6f4de5e6-6ac1-41d4-aaa5-7aa44a8a1eb3"],
 "."
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"7a43da82-6b18-4466-bdb3-8be160d8f567"],

Cell[TextData[{
 "Apply a pure function to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Blend",
    BaseStyle->"CodeLink"], "[", 
   RowBox[{"{", 
    RowBox[{
     ButtonBox["Red",
      BaseStyle->"CodeLink"], ",", 
     ButtonBox["Yellow",
      BaseStyle->"CodeLink"]}], "}"}], "]"}]], "InlineCode",ExpressionUUID->
  "d1175e78-a70a-4d57-a670-f4d924adf88e"],
 ":"
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"b3700976-4f94-45e8-9621-bd1d12b3f6c3"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Column", "[", 
    RowBox[{"{", 
     RowBox[{"#", ",", 
      RowBox[{"ColorNegate", "[", "#", "]"}], ",", "#"}], "}"}], "]"}], "&"}],
   " ", "[", 
  RowBox[{"Blend", "[", 
   RowBox[{"{", 
    RowBox[{"Red", ",", "Yellow"}], "}"}], "]"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[24]:=",ExpressionUUID->"121b9a52-2782-4c3f-8a5a-9ff738969b4b"],

Cell[BoxData[
 TagBox[GridBox[{
    {
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[1, 
            Rational[1, 2], 0], RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         Frame->True,
         FrameStyle->RGBColor[0.6666666666666666, 0.3333333333333333, 0.],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        "RGBColor[1, 1/2, 0]"],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 
             Rational[1, 2], 0]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[1, 
       Rational[1, 2], 0],
      Editable->False,
      Selectable->False]},
    {
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[0., 0.5, 1.], RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         Frame->True,
         FrameStyle->RGBColor[0., 0.33333333333333337`, 0.6666666666666667],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        "RGBColor[0., 0.5, 1.]"],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[0., 0.5, 1.]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[0., 0.5, 1.],
      Editable->False,
      Selectable->False]},
    {
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[1, 
            Rational[1, 2], 0], RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         Frame->True,
         FrameStyle->RGBColor[0.6666666666666666, 0.3333333333333333, 0.],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        "RGBColor[1, 1/2, 0]"],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 
             Rational[1, 2], 0]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[1, 
       Rational[1, 2], 0],
      Editable->False,
      Selectable->False]}
   },
   DefaultBaseStyle->"Column",
   GridBoxAlignment->{"Columns" -> {{Left}}},
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
  "Column"]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellTags->"LastCellOfAPage",
 CellLabel->"Out[24]=",ExpressionUUID->"db33c689-b663-412b-a904-8614e147589c"]
}, Open  ]],

Cell["This is what it looks like without the pure function:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"p:151",ExpressionUUID->"3f761fef-8bca-415a-80f5-2c2800410d9e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Column", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Blend", "[", 
     RowBox[{"{", 
      RowBox[{"Red", ",", "Yellow"}], "}"}], "]"}], ",", 
    RowBox[{"ColorNegate", "[", 
     RowBox[{"Blend", "[", 
      RowBox[{"{", 
       RowBox[{"Red", ",", "Yellow"}], "}"}], "]"}], "]"}], ",", 
    RowBox[{"Blend", "[", 
     RowBox[{"{", 
      RowBox[{"Red", ",", "Yellow"}], "}"}], "]"}]}], "}"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[25]:=",ExpressionUUID->"8d0569c6-ffd3-422e-a01c-5d489b3fac71"],

Cell[BoxData[
 TagBox[GridBox[{
    {
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[1, 
            Rational[1, 2], 0], RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         Frame->True,
         FrameStyle->RGBColor[0.6666666666666666, 0.3333333333333333, 0.],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        "RGBColor[1, 1/2, 0]"],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 
             Rational[1, 2], 0]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[1, 
       Rational[1, 2], 0],
      Editable->False,
      Selectable->False]},
    {
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[0., 0.5, 1.], RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         Frame->True,
         FrameStyle->RGBColor[0., 0.33333333333333337`, 0.6666666666666667],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        "RGBColor[0., 0.5, 1.]"],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[0., 0.5, 1.]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[0., 0.5, 1.],
      Editable->False,
      Selectable->False]},
    {
     InterpretationBox[
      ButtonBox[
       TooltipBox[
        GraphicsBox[{
          {GrayLevel[0], RectangleBox[{0, 0}]}, 
          {GrayLevel[0], RectangleBox[{1, -1}]}, 
          {RGBColor[1, 
            Rational[1, 2], 0], RectangleBox[{0, -1}, {2, 1}]}},
         AspectRatio->1,
         Frame->True,
         FrameStyle->RGBColor[0.6666666666666666, 0.3333333333333333, 0.],
         FrameTicks->None,
         ImageSize->
          Dynamic[{
           Automatic, 
            1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
             Magnification])}],
         PlotRangePadding->None],
        "RGBColor[1, 1/2, 0]"],
       Appearance->None,
       BaseStyle->{},
       BaselinePosition->Baseline,
       ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
         If[
          Not[
           AbsoluteCurrentValue["Deployed"]], 
          SelectionMove[Typeset`box$, All, Expression]; 
          FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
          FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 
             Rational[1, 2], 0]; 
          FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
          MathLink`CallFrontEnd[
            FrontEnd`AttachCell[Typeset`box$, 
             FrontEndResource["RGBColorValueSelector"], {0, {Left, Bottom}}, {
             Left, Top}, 
             "ClosingActions" -> {
              "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
       DefaultBaseStyle->{},
       Evaluator->Automatic,
       Method->"Preemptive"],
      RGBColor[1, 
       Rational[1, 2], 0],
      Editable->False,
      Selectable->False]}
   },
   DefaultBaseStyle->"Column",
   GridBoxAlignment->{"Columns" -> {{Left}}},
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
  "Column"]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[25]=",ExpressionUUID->"25b31b4b-7508-47c2-9ec3-8c4cc9dc005a"]
}, Open  ]],

Cell["\<\
In the Wolfram Language, a pure function works just like anything else. On \
its own, though, it doesn\[CloseCurlyQuote]t do anything. \
\>", "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"eac21be6-bdd7-4b30-9b9b-791ecf375153"],

Cell["\<\
Enter a pure function on its own and it\[CloseCurlyQuote]ll come back \
unchanged:\
\>", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"04e1a5ab-6b2e-4c41-a67c-353e0cf43b00"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", 
   RowBox[{"#", ",", "2"}], "]"}], "&"}]], "Input",
 Deletable->False,
 CellLabel->"In[26]:=",ExpressionUUID->"127d72dc-82b9-4803-a1ca-3ca7722f66f2"],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", 
   RowBox[{"#1", ",", "2"}], "]"}], "&"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[26]=",ExpressionUUID->"2b97a5ae-4df9-4276-ab0a-b099cedf45ad"]
}, Open  ]],

Cell[TextData[{
 "Give it to the function ",
 ButtonBox["Map",
  BaseStyle->"Link"],
 " (",
 Cell[BoxData[
  ButtonBox["/@",
   BaseStyle->"Link",
   ButtonData->"Map"]], "InlineCodeText",ExpressionUUID->
  "b9036e5a-a3b0-4ac3-a999-84079c714f10"],
 "), though, and it\[CloseCurlyQuote]ll be used to do a computation."
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"9bbefb55-9be4-4adf-bb7a-86b869b3a677"],

Cell[TextData[{
 ButtonBox["Map",
  BaseStyle->"Link"],
 " uses the pure function to do a computation:"
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"f85ee8c1-80a1-498e-9b5d-37822d6117be"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"f", "[", 
     RowBox[{"#", ",", "2"}], "]"}], "&"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e"}], "}"}]}], 
  "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[27]:=",ExpressionUUID->"508d81ff-2c10-4a7c-a086-507f46be0731"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"a", ",", "2"}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"b", ",", "2"}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"c", ",", "2"}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"d", ",", "2"}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"e", ",", "2"}], "]"}]}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[27]=",ExpressionUUID->"31fcbc4a-f44b-4fa0-9a9a-2da0b6a64e4b"]
}, Open  ]],

Cell["\<\
Over the course of the next few sections, we\[CloseCurlyQuote]ll see more and \
more uses of pure functions.\
\>", "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"1ed4a1b8-29c0-4483-a144-1ede1e74e748"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Vocabulary", "VocabularySection",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"2086ed7b-14fa-4dda-85fc-1907c9848c09"],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     StyleBox["code", "CodeVariableLrg"], 
     ButtonBox["&",
      BaseStyle->"CodeLink",
      ButtonData->"Function"]}], " ", Cell[
    "a pure function ", "VocabularyText",ExpressionUUID->
     "f7fb9112-86b9-4416-a62d-047d84658619"]},
   {
    ButtonBox["#",
     BaseStyle->"CodeLink",
     ButtonData->"Slot"], " ", Cell[
    "slot in a pure function ", "VocabularyText",ExpressionUUID->
     "005c8b35-4cd2-4570-92ca-f26d09791a5e"]}
  }]], "VocabularyTable",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"b486072d-75ce-4f6b-b5e7-64bfa37a5eca"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 DynamicModuleBox[{$CellContext`open$$ = False}, 
  TagBox[GridBox[{
     {
      StyleBox["\<\"Exercises\"\>",
       StripOnInput->False,
       FontSlant->"Italic"], 
      PaneBox[
       TagBox[
        ButtonBox[
         DynamicBox[ToBoxes[
           If[$CellContext`open$$, 
            Row[{
              Style["-", "ExercisePreviewButtonTextHighlight"], 
              Style[" Preview Exercises", "ExercisePreviewButtonText"]}], 
            Row[{
              Style["+", "ExercisePreviewButtonTextHighlight"], 
              Style[" Preview Exercises", "ExercisePreviewButtonText"]}]], 
           StandardForm],
          ImageSizeCache->{115., {1., 10.}}],
         Appearance->None,
         ButtonFunction:>(
          If[$CellContext`open$$, $CellContext`open$$ = 
            False, $CellContext`open$$ = True]; NotebookFind[
            EvaluationNotebook[], "ExerciseSummaryCell", Next, CellStyle, 
            WrapAround -> True, AutoScroll -> False]; FrontEndTokenExecute[
            EvaluationNotebook[], "ExpandSelection"]; FrontEndExecute[
            FrontEndToken[
             EvaluationNotebook[], "OpenCloseGroup"]]),
         Evaluator->Automatic,
         Method->"Preemptive"],
        MouseAppearanceTag["LinkHand"]],
       Alignment->Right,
       ImageSize->Full]}
    },
    AutoDelete->False,
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  DynamicModuleValues:>{}]], "ExerciseSection",
 Editable->False,
 ShowCellBracket->False,
 GeneratedCell->True,
 CellAutoOverwrite->True,
 CellChangeTimes->{3.669991951589675*^9},
 ShowStringCharacters->
  False,ExpressionUUID->"ab34a652-85cf-41e7-a918-bf5856c1a7d7"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[GridBox[{
    {
     TagBox[GridBox[{
        {
         PaneBox[
          StyleBox["\<\"8 Exercises Available\"\>", "ExerciseSummaryHeading",
           StripOnInput->False],
          ImageMargins->{{20, 0}, {0, 10}}]},
        {
         PaneBox[
          StyleBox["\<\"with 1 extras\"\>", "ExerciseSummarySubheading",
           StripOnInput->False],
          ImageMargins->{{20, 0}, {10, 0}}]}
       },
       DefaultBaseStyle->"Column",
       GridBoxAlignment->{"Columns" -> {{Left}}},
       GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
       
       GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{0}}}],
      "Column"], 
     PaneBox[
      ButtonBox[
       StyleBox["\<\"Get Started \[RightGuillemet]\"\>", 
        "ExerciseSummaryHeading",
        StripOnInput->False],
       Appearance->None,
       ButtonFunction:>
        NotebookLocate[{"EIWL2-26-pure-anonymous-functions-exercises.nb", ""}],
       Evaluator->Automatic,
       Method->"Preemptive"],
      FrameMargins->{{10, 0}, {10, 10}},
      ImageSize->Full]}
   },
   AutoDelete->False,
   GridBoxAlignment->{"Columns" -> {{Left}}},
   GridBoxItemSize->{"Columns" -> {
       Scaled[0.7], 
       Scaled[0.3]}, "Rows" -> {{Automatic}}}],
  "Grid"]], "ExerciseSummaryCell",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"ef07b86d-8b78-4894-a6e8-ac3dbb649964"],

Cell[CellGroupData[{

Cell[TextData[{
 "Use ",
 ButtonBox["Range",
  BaseStyle->"Link"],
 " and a pure function to create a list of the first 20 squares.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "26.1", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"c466acb0-95e8-42ab-9a59-3c0157789ccd"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       RowBox[{"{", 
        RowBox[{
        "1", ",", "4", ",", "9", ",", "16", ",", "25", ",", "36", ",", "49", 
         ",", "64", ",", "81", ",", "100", ",", "121", ",", "144", ",", "169",
          ",", "196", ",", "225", ",", "256", ",", "289", ",", "324", ",", 
         "361", ",", "400"}], "}"}]], "ExerciseOutput",ExpressionUUID->
       "23081ab6-0096-489a-ad56-6ac16808149b"],
      Apply[TextCell, 
       Cell[
        BoxData[
         RowBox[{"{", 
           
           RowBox[{"1", ",", "4", ",", "9", ",", "16", ",", "25", ",", "36", 
             ",", "49", ",", "64", ",", "81", ",", "100", ",", "121", ",", 
             "144", ",", "169", ",", "196", ",", "225", ",", "256", ",", 
             "289", ",", "324", ",", "361", ",", "400"}], "}"}]], 
        "ExerciseOutput", Selectable -> False, Copyable -> False, Editable -> 
        False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"ca7601d3-479b-4967-98b5-fecd426c116e"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Make a list of the result of blending yellow, green and blue with red.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "26.2", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"2be12d1c-af36-4197-97cb-6898074fede2"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       RowBox[{"{", 
        RowBox[{
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[1, 
                Rational[1, 2], 0], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->RGBColor[0.6666666666666666, 0.3333333333333333, 0.],
             
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[1, 1/2, 0]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 
                 Rational[1, 2], 0]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[1, 
           Rational[1, 2], 0],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[
                Rational[1, 2], 
                Rational[1, 2], 0], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->RGBColor[0.3333333333333333, 0.3333333333333333, 0.],
             
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[1/2, 1/2, 0]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[
                 Rational[1, 2], 
                 Rational[1, 2], 0]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[
           Rational[1, 2], 
           Rational[1, 2], 0],
          Editable->False,
          Selectable->False], ",", 
         InterpretationBox[
          ButtonBox[
           TooltipBox[
            GraphicsBox[{
              {GrayLevel[0], RectangleBox[{0, 0}]}, 
              {GrayLevel[0], RectangleBox[{1, -1}]}, 
              {RGBColor[
                Rational[1, 2], 0, 
                Rational[1, 2]], RectangleBox[{0, -1}, {2, 1}]}},
             AspectRatio->1,
             Frame->True,
             FrameStyle->RGBColor[0.3333333333333333, 0., 0.3333333333333333],
             
             FrameTicks->None,
             
             ImageSize->
              Dynamic[{
               Automatic, 
                1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                 Magnification])}],
             PlotRangePadding->None],
            "RGBColor[1/2, 0, 1/2]"],
           Appearance->None,
           BaseStyle->{},
           BaselinePosition->Baseline,
           ButtonFunction:>With[{Typeset`box$ = EvaluationBox[]}, 
             If[
              Not[
               AbsoluteCurrentValue["Deployed"]], 
              SelectionMove[Typeset`box$, All, Expression]; 
              FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
              FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[
                 Rational[1, 2], 0, 
                 Rational[1, 2]]; 
              FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
              MathLink`CallFrontEnd[
                FrontEnd`AttachCell[Typeset`box$, 
                 FrontEndResource["RGBColorValueSelector"], {
                 0, {Left, Bottom}}, {Left, Top}, 
                 "ClosingActions" -> {
                  "SelectionDeparture", "ParentChanged", "EvaluatorQuit"}]]]],
           
           DefaultBaseStyle->{},
           Evaluator->Automatic,
           Method->"Preemptive"],
          RGBColor[
           Rational[1, 2], 0, 
           Rational[1, 2]],
          Editable->False,
          Selectable->False]}], "}"}]], "ExerciseOutput",ExpressionUUID->
       "05915890-3168-49bb-9c70-a442ecd32299"],
      Apply[TextCell, 
       Cell[
        BoxData[
         RowBox[{"{", 
           RowBox[{
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[1, 
                    Rational[1, 2], 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 RGBColor[0.6666666666666666, 0.3333333333333333, 0.], 
                 FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[1, 1/2, 0]"], Appearance -> None, BaseStyle -> {}, 
               BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[1, 
                    Rational[1, 2], 0]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[1, 
               Rational[1, 2], 0], Editable -> False, Selectable -> False], 
             ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[
                    Rational[1, 2], 
                    Rational[1, 2], 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 RGBColor[0.3333333333333333, 0.3333333333333333, 0.], 
                 FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[1/2, 1/2, 0]"], Appearance -> None, BaseStyle -> {},
                BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[
                    Rational[1, 2], 
                    Rational[1, 2], 0]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[
               Rational[1, 2], 
               Rational[1, 2], 0], Editable -> False, Selectable -> False], 
             ",", 
             InterpretationBox[
              ButtonBox[
               TooltipBox[
                GraphicsBox[{{{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}}}, {{{
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}}}, {{{
                    RGBColor[
                    Rational[1, 2], 0, 
                    Rational[1, 2]], 
                    RectangleBox[{0, -1}, {2, 1}]}}}}, AspectRatio -> 1, 
                 Frame -> True, FrameStyle -> 
                 RGBColor[0.3333333333333333, 0., 0.3333333333333333], 
                 FrameTicks -> None, ImageSize -> 
                 Dynamic[{
                   Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}], PlotRangePadding -> None], 
                "RGBColor[1/2, 0, 1/2]"], Appearance -> None, BaseStyle -> {},
                BaselinePosition -> Baseline, ButtonFunction :> 
               With[{Typeset`box$ = EvaluationBox[]}, 
                 If[
                  Not[
                   AbsoluteCurrentValue["Deployed"]], 
                  SelectionMove[Typeset`box$, All, Expression]; 
                  FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                  FrontEnd`Private`$ColorSelectorInitialColor = RGBColor[
                    Rational[1, 2], 0, 
                    Rational[1, 2]]; 
                  FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                  MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], DefaultBaseStyle -> {}, Evaluator -> 
               Automatic, Method -> "Preemptive"], 
              RGBColor[
               Rational[1, 2], 0, 
               Rational[1, 2]], Editable -> False, Selectable -> False]}], 
           "}"}]], "ExerciseOutput", Selectable -> False, Copyable -> False, 
        Editable -> False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"310fbfe2-e2fe-4071-b658-757ec3980caf"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Generate a list of framed columns containing the uppercase and lowercase \
versions of each letter of the alphabet.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "26.3", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"865f428f-6497-4f9f-9198-a4cde52caff4"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       RowBox[{"{", 
        RowBox[{
         FrameBox[
          TagBox[GridBox[{
             {"\<\"A\"\>"},
             {"\<\"a\"\>"}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
           "Column"],
          StripOnInput->False], ",", 
         FrameBox[
          TagBox[GridBox[{
             {"\<\"B\"\>"},
             {"\<\"b\"\>"}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
           "Column"],
          StripOnInput->False], ",", 
         FrameBox[
          TagBox[GridBox[{
             {"\<\"C\"\>"},
             {"\<\"c\"\>"}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
           "Column"],
          StripOnInput->False], ",", 
         FrameBox[
          TagBox[GridBox[{
             {"\<\"D\"\>"},
             {"\<\"d\"\>"}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
           "Column"],
          StripOnInput->False], ",", 
         FrameBox[
          TagBox[GridBox[{
             {"\<\"E\"\>"},
             {"\<\"e\"\>"}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
           "Column"],
          StripOnInput->False], ",", 
         FrameBox[
          TagBox[GridBox[{
             {"\<\"F\"\>"},
             {"\<\"f\"\>"}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
           "Column"],
          StripOnInput->False], ",", 
         FrameBox[
          TagBox[GridBox[{
             {"\<\"G\"\>"},
             {"\<\"g\"\>"}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
           "Column"],
          StripOnInput->False], ",", 
         FrameBox[
          TagBox[GridBox[{
             {"\<\"H\"\>"},
             {"\<\"h\"\>"}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
           "Column"],
          StripOnInput->False], ",", 
         FrameBox[
          TagBox[GridBox[{
             {"\<\"I\"\>"},
             {"\<\"i\"\>"}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
           "Column"],
          StripOnInput->False], ",", 
         FrameBox[
          TagBox[GridBox[{
             {"\<\"J\"\>"},
             {"\<\"j\"\>"}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
           "Column"],
          StripOnInput->False], ",", 
         FrameBox[
          TagBox[GridBox[{
             {"\<\"K\"\>"},
             {"\<\"k\"\>"}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
           "Column"],
          StripOnInput->False], ",", 
         FrameBox[
          TagBox[GridBox[{
             {"\<\"L\"\>"},
             {"\<\"l\"\>"}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
           "Column"],
          StripOnInput->False], ",", 
         FrameBox[
          TagBox[GridBox[{
             {"\<\"M\"\>"},
             {"\<\"m\"\>"}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
           "Column"],
          StripOnInput->False], ",", 
         FrameBox[
          TagBox[GridBox[{
             {"\<\"N\"\>"},
             {"\<\"n\"\>"}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
           "Column"],
          StripOnInput->False], ",", 
         FrameBox[
          TagBox[GridBox[{
             {"\<\"O\"\>"},
             {"\<\"o\"\>"}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
           "Column"],
          StripOnInput->False], ",", 
         FrameBox[
          TagBox[GridBox[{
             {"\<\"P\"\>"},
             {"\<\"p\"\>"}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
           "Column"],
          StripOnInput->False], ",", 
         FrameBox[
          TagBox[GridBox[{
             {"\<\"Q\"\>"},
             {"\<\"q\"\>"}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
           "Column"],
          StripOnInput->False], ",", 
         FrameBox[
          TagBox[GridBox[{
             {"\<\"R\"\>"},
             {"\<\"r\"\>"}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
           "Column"],
          StripOnInput->False], ",", 
         FrameBox[
          TagBox[GridBox[{
             {"\<\"S\"\>"},
             {"\<\"s\"\>"}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
           "Column"],
          StripOnInput->False], ",", 
         FrameBox[
          TagBox[GridBox[{
             {"\<\"T\"\>"},
             {"\<\"t\"\>"}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
           "Column"],
          StripOnInput->False], ",", 
         FrameBox[
          TagBox[GridBox[{
             {"\<\"U\"\>"},
             {"\<\"u\"\>"}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
           "Column"],
          StripOnInput->False], ",", 
         FrameBox[
          TagBox[GridBox[{
             {"\<\"V\"\>"},
             {"\<\"v\"\>"}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
           "Column"],
          StripOnInput->False], ",", 
         FrameBox[
          TagBox[GridBox[{
             {"\<\"W\"\>"},
             {"\<\"w\"\>"}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
           "Column"],
          StripOnInput->False], ",", 
         FrameBox[
          TagBox[GridBox[{
             {"\<\"X\"\>"},
             {"\<\"x\"\>"}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
           "Column"],
          StripOnInput->False], ",", 
         FrameBox[
          TagBox[GridBox[{
             {"\<\"Y\"\>"},
             {"\<\"y\"\>"}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
           "Column"],
          StripOnInput->False], ",", 
         FrameBox[
          TagBox[GridBox[{
             {"\<\"Z\"\>"},
             {"\<\"z\"\>"}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
           "Column"],
          StripOnInput->False]}], "}"}]], "ExerciseOutput",ExpressionUUID->
       "63272507-5cfd-40c5-b60b-a7154ffd6137"],
      Apply[TextCell, 
       Cell[
        BoxData[
         RowBox[{"{", 
           RowBox[{
             FrameBox[
              TagBox[
               
               GridBox[{{"\"A\""}, {"\"a\""}}, DefaultBaseStyle -> "Column", 
                GridBoxAlignment -> {"Columns" -> {{Left}}}, 
                GridBoxItemSize -> {
                 "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
               "Column"], StripOnInput -> False], ",", 
             FrameBox[
              TagBox[
               
               GridBox[{{"\"B\""}, {"\"b\""}}, DefaultBaseStyle -> "Column", 
                GridBoxAlignment -> {"Columns" -> {{Left}}}, 
                GridBoxItemSize -> {
                 "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
               "Column"], StripOnInput -> False], ",", 
             FrameBox[
              TagBox[
               
               GridBox[{{"\"C\""}, {"\"c\""}}, DefaultBaseStyle -> "Column", 
                GridBoxAlignment -> {"Columns" -> {{Left}}}, 
                GridBoxItemSize -> {
                 "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
               "Column"], StripOnInput -> False], ",", 
             FrameBox[
              TagBox[
               
               GridBox[{{"\"D\""}, {"\"d\""}}, DefaultBaseStyle -> "Column", 
                GridBoxAlignment -> {"Columns" -> {{Left}}}, 
                GridBoxItemSize -> {
                 "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
               "Column"], StripOnInput -> False], ",", 
             FrameBox[
              TagBox[
               
               GridBox[{{"\"E\""}, {"\"e\""}}, DefaultBaseStyle -> "Column", 
                GridBoxAlignment -> {"Columns" -> {{Left}}}, 
                GridBoxItemSize -> {
                 "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
               "Column"], StripOnInput -> False], ",", 
             FrameBox[
              TagBox[
               
               GridBox[{{"\"F\""}, {"\"f\""}}, DefaultBaseStyle -> "Column", 
                GridBoxAlignment -> {"Columns" -> {{Left}}}, 
                GridBoxItemSize -> {
                 "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
               "Column"], StripOnInput -> False], ",", 
             FrameBox[
              TagBox[
               
               GridBox[{{"\"G\""}, {"\"g\""}}, DefaultBaseStyle -> "Column", 
                GridBoxAlignment -> {"Columns" -> {{Left}}}, 
                GridBoxItemSize -> {
                 "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
               "Column"], StripOnInput -> False], ",", 
             FrameBox[
              TagBox[
               
               GridBox[{{"\"H\""}, {"\"h\""}}, DefaultBaseStyle -> "Column", 
                GridBoxAlignment -> {"Columns" -> {{Left}}}, 
                GridBoxItemSize -> {
                 "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
               "Column"], StripOnInput -> False], ",", 
             FrameBox[
              TagBox[
               
               GridBox[{{"\"I\""}, {"\"i\""}}, DefaultBaseStyle -> "Column", 
                GridBoxAlignment -> {"Columns" -> {{Left}}}, 
                GridBoxItemSize -> {
                 "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
               "Column"], StripOnInput -> False], ",", 
             FrameBox[
              TagBox[
               
               GridBox[{{"\"J\""}, {"\"j\""}}, DefaultBaseStyle -> "Column", 
                GridBoxAlignment -> {"Columns" -> {{Left}}}, 
                GridBoxItemSize -> {
                 "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
               "Column"], StripOnInput -> False], ",", 
             FrameBox[
              TagBox[
               
               GridBox[{{"\"K\""}, {"\"k\""}}, DefaultBaseStyle -> "Column", 
                GridBoxAlignment -> {"Columns" -> {{Left}}}, 
                GridBoxItemSize -> {
                 "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
               "Column"], StripOnInput -> False], ",", 
             FrameBox[
              TagBox[
               
               GridBox[{{"\"L\""}, {"\"l\""}}, DefaultBaseStyle -> "Column", 
                GridBoxAlignment -> {"Columns" -> {{Left}}}, 
                GridBoxItemSize -> {
                 "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
               "Column"], StripOnInput -> False], ",", 
             FrameBox[
              TagBox[
               
               GridBox[{{"\"M\""}, {"\"m\""}}, DefaultBaseStyle -> "Column", 
                GridBoxAlignment -> {"Columns" -> {{Left}}}, 
                GridBoxItemSize -> {
                 "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
               "Column"], StripOnInput -> False], ",", 
             FrameBox[
              TagBox[
               
               GridBox[{{"\"N\""}, {"\"n\""}}, DefaultBaseStyle -> "Column", 
                GridBoxAlignment -> {"Columns" -> {{Left}}}, 
                GridBoxItemSize -> {
                 "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
               "Column"], StripOnInput -> False], ",", 
             FrameBox[
              TagBox[
               
               GridBox[{{"\"O\""}, {"\"o\""}}, DefaultBaseStyle -> "Column", 
                GridBoxAlignment -> {"Columns" -> {{Left}}}, 
                GridBoxItemSize -> {
                 "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
               "Column"], StripOnInput -> False], ",", 
             FrameBox[
              TagBox[
               
               GridBox[{{"\"P\""}, {"\"p\""}}, DefaultBaseStyle -> "Column", 
                GridBoxAlignment -> {"Columns" -> {{Left}}}, 
                GridBoxItemSize -> {
                 "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
               "Column"], StripOnInput -> False], ",", 
             FrameBox[
              TagBox[
               
               GridBox[{{"\"Q\""}, {"\"q\""}}, DefaultBaseStyle -> "Column", 
                GridBoxAlignment -> {"Columns" -> {{Left}}}, 
                GridBoxItemSize -> {
                 "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
               "Column"], StripOnInput -> False], ",", 
             FrameBox[
              TagBox[
               
               GridBox[{{"\"R\""}, {"\"r\""}}, DefaultBaseStyle -> "Column", 
                GridBoxAlignment -> {"Columns" -> {{Left}}}, 
                GridBoxItemSize -> {
                 "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
               "Column"], StripOnInput -> False], ",", 
             FrameBox[
              TagBox[
               
               GridBox[{{"\"S\""}, {"\"s\""}}, DefaultBaseStyle -> "Column", 
                GridBoxAlignment -> {"Columns" -> {{Left}}}, 
                GridBoxItemSize -> {
                 "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
               "Column"], StripOnInput -> False], ",", 
             FrameBox[
              TagBox[
               
               GridBox[{{"\"T\""}, {"\"t\""}}, DefaultBaseStyle -> "Column", 
                GridBoxAlignment -> {"Columns" -> {{Left}}}, 
                GridBoxItemSize -> {
                 "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
               "Column"], StripOnInput -> False], ",", 
             FrameBox[
              TagBox[
               
               GridBox[{{"\"U\""}, {"\"u\""}}, DefaultBaseStyle -> "Column", 
                GridBoxAlignment -> {"Columns" -> {{Left}}}, 
                GridBoxItemSize -> {
                 "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
               "Column"], StripOnInput -> False], ",", 
             FrameBox[
              TagBox[
               
               GridBox[{{"\"V\""}, {"\"v\""}}, DefaultBaseStyle -> "Column", 
                GridBoxAlignment -> {"Columns" -> {{Left}}}, 
                GridBoxItemSize -> {
                 "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
               "Column"], StripOnInput -> False], ",", 
             FrameBox[
              TagBox[
               
               GridBox[{{"\"W\""}, {"\"w\""}}, DefaultBaseStyle -> "Column", 
                GridBoxAlignment -> {"Columns" -> {{Left}}}, 
                GridBoxItemSize -> {
                 "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
               "Column"], StripOnInput -> False], ",", 
             FrameBox[
              TagBox[
               
               GridBox[{{"\"X\""}, {"\"x\""}}, DefaultBaseStyle -> "Column", 
                GridBoxAlignment -> {"Columns" -> {{Left}}}, 
                GridBoxItemSize -> {
                 "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
               "Column"], StripOnInput -> False], ",", 
             FrameBox[
              TagBox[
               
               GridBox[{{"\"Y\""}, {"\"y\""}}, DefaultBaseStyle -> "Column", 
                GridBoxAlignment -> {"Columns" -> {{Left}}}, 
                GridBoxItemSize -> {
                 "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
               "Column"], StripOnInput -> False], ",", 
             FrameBox[
              TagBox[
               
               GridBox[{{"\"Z\""}, {"\"z\""}}, DefaultBaseStyle -> "Column", 
                GridBoxAlignment -> {"Columns" -> {{Left}}}, 
                GridBoxItemSize -> {
                 "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], 
               "Column"], StripOnInput -> False]}], "}"}]], "ExerciseOutput", 
        Selectable -> False, Copyable -> False, Editable -> False, 
        ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"9a4b9be6-6a8b-4a86-af16-298e898d43ed"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Make a list of letters of the alphabet, in random colors, with frames \
having random background colors.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "26.4", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"f83db1a9-a2be-4f83-89b0-cd5d8ad1110f"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Sample", " ", "expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       RowBox[{"{", 
        RowBox[{
         FrameBox[
          StyleBox["\<\"a\"\>",
           StripOnInput->False,
           
           FontColor->RGBColor[
            0.9605784669619559, 0.15191951859194286`, 0.18478821678384683`],
           $CellContext`LineColor -> 
           RGBColor[
            0.9605784669619559, 0.15191951859194286`, 0.18478821678384683`],
           $CellContext`FrontFaceColor -> 
           RGBColor[
            0.9605784669619559, 0.15191951859194286`, 0.18478821678384683`],
           $CellContext`GraphicsColor -> 
           RGBColor[
            0.9605784669619559, 0.15191951859194286`, 0.18478821678384683`],
           $CellContext`BackFaceColor -> 
           RGBColor[
            0.9605784669619559, 0.15191951859194286`, 0.18478821678384683`]],
          
          Background->RGBColor[
           0.0584426420889641, 0.2568862297720107, 0.8514545236994886],
          StripOnInput->False], ",", 
         FrameBox[
          StyleBox["\<\"b\"\>",
           StripOnInput->False,
           
           FontColor->RGBColor[
            0.5924770827975059, 0.8712066332532591, 0.6501170574997406],
           $CellContext`LineColor -> 
           RGBColor[
            0.5924770827975059, 0.8712066332532591, 0.6501170574997406],
           $CellContext`FrontFaceColor -> 
           RGBColor[
            0.5924770827975059, 0.8712066332532591, 0.6501170574997406],
           $CellContext`GraphicsColor -> 
           RGBColor[
            0.5924770827975059, 0.8712066332532591, 0.6501170574997406],
           $CellContext`BackFaceColor -> 
           RGBColor[
            0.5924770827975059, 0.8712066332532591, 0.6501170574997406]],
          
          Background->RGBColor[
           0.6026179743382689, 0.07201770869232882, 0.4055008626852239],
          StripOnInput->False], ",", 
         FrameBox[
          StyleBox["\<\"c\"\>",
           StripOnInput->False,
           
           FontColor->RGBColor[
            0.6858781999084698, 0.40767754765650954`, 0.2895651875850487],
           $CellContext`LineColor -> 
           RGBColor[
            0.6858781999084698, 0.40767754765650954`, 0.2895651875850487],
           $CellContext`FrontFaceColor -> 
           RGBColor[
            0.6858781999084698, 0.40767754765650954`, 0.2895651875850487],
           $CellContext`GraphicsColor -> 
           RGBColor[
            0.6858781999084698, 0.40767754765650954`, 0.2895651875850487],
           $CellContext`BackFaceColor -> 
           RGBColor[
            0.6858781999084698, 0.40767754765650954`, 0.2895651875850487]],
          
          Background->RGBColor[
           0.2844415176815438, 0.47108122972753574`, 0.5053708365240432],
          StripOnInput->False], ",", 
         FrameBox[
          StyleBox["\<\"d\"\>",
           StripOnInput->False,
           
           FontColor->RGBColor[
            0.38517150774737496`, 0.060170780815135494`, 
             0.09554268062768001],
           $CellContext`LineColor -> 
           RGBColor[
            0.38517150774737496`, 0.060170780815135494`, 
             0.09554268062768001],
           $CellContext`FrontFaceColor -> 
           RGBColor[
            0.38517150774737496`, 0.060170780815135494`, 
             0.09554268062768001],
           $CellContext`GraphicsColor -> 
           RGBColor[
            0.38517150774737496`, 0.060170780815135494`, 
             0.09554268062768001],
           $CellContext`BackFaceColor -> 
           RGBColor[
            0.38517150774737496`, 0.060170780815135494`, 0.09554268062768001]],
          
          
          Background->RGBColor[
           0.47344799063375076`, 0.9030258895705245, 0.9309630217380565],
          StripOnInput->False], ",", 
         FrameBox[
          StyleBox["\<\"e\"\>",
           StripOnInput->False,
           
           FontColor->RGBColor[
            0.9785769223693994, 0.8793664572150963, 0.9711795477331708],
           $CellContext`LineColor -> 
           RGBColor[
            0.9785769223693994, 0.8793664572150963, 0.9711795477331708],
           $CellContext`FrontFaceColor -> 
           RGBColor[
            0.9785769223693994, 0.8793664572150963, 0.9711795477331708],
           $CellContext`GraphicsColor -> 
           RGBColor[
            0.9785769223693994, 0.8793664572150963, 0.9711795477331708],
           $CellContext`BackFaceColor -> 
           RGBColor[
            0.9785769223693994, 0.8793664572150963, 0.9711795477331708]],
          
          Background->RGBColor[
           0.3635682546564729, 0.21408609659066924`, 0.1643083844713602],
          StripOnInput->False], ",", 
         FrameBox[
          StyleBox["\<\"f\"\>",
           StripOnInput->False,
           
           FontColor->RGBColor[
            0.8566197105465485, 0.7056552003683692, 0.5757167228458095],
           $CellContext`LineColor -> 
           RGBColor[
            0.8566197105465485, 0.7056552003683692, 0.5757167228458095],
           $CellContext`FrontFaceColor -> 
           RGBColor[
            0.8566197105465485, 0.7056552003683692, 0.5757167228458095],
           $CellContext`GraphicsColor -> 
           RGBColor[
            0.8566197105465485, 0.7056552003683692, 0.5757167228458095],
           $CellContext`BackFaceColor -> 
           RGBColor[
            0.8566197105465485, 0.7056552003683692, 0.5757167228458095]],
          
          Background->RGBColor[
           0.9379084230873833, 0.7626678287262885, 0.31679728168391974`],
          StripOnInput->False], ",", 
         FrameBox[
          StyleBox["\<\"g\"\>",
           StripOnInput->False,
           
           FontColor->RGBColor[
            0.17766853743747069`, 0.6100951004959156, 0.6116642512871422],
           $CellContext`LineColor -> 
           RGBColor[
            0.17766853743747069`, 0.6100951004959156, 0.6116642512871422],
           $CellContext`FrontFaceColor -> 
           RGBColor[
            0.17766853743747069`, 0.6100951004959156, 0.6116642512871422],
           $CellContext`GraphicsColor -> 
           RGBColor[
            0.17766853743747069`, 0.6100951004959156, 0.6116642512871422],
           $CellContext`BackFaceColor -> 
           RGBColor[
            0.17766853743747069`, 0.6100951004959156, 0.6116642512871422]],
          
          Background->RGBColor[
           0.8929305658833444, 0.5275148951227111, 0.03534385990278266],
          StripOnInput->False], ",", 
         FrameBox[
          StyleBox["\<\"h\"\>",
           StripOnInput->False,
           
           FontColor->RGBColor[
            0.86377086837588, 0.8642655565373705, 0.12481961165910693`],
           $CellContext`LineColor -> 
           RGBColor[
            0.86377086837588, 0.8642655565373705, 0.12481961165910693`],
           $CellContext`FrontFaceColor -> 
           RGBColor[
            0.86377086837588, 0.8642655565373705, 0.12481961165910693`],
           $CellContext`GraphicsColor -> 
           RGBColor[
            0.86377086837588, 0.8642655565373705, 0.12481961165910693`],
           $CellContext`BackFaceColor -> 
           RGBColor[
            0.86377086837588, 0.8642655565373705, 0.12481961165910693`]],
          
          Background->RGBColor[
           0.22799569263352382`, 0.6895964810627666, 0.689635404329247],
          StripOnInput->False], ",", 
         FrameBox[
          StyleBox["\<\"i\"\>",
           StripOnInput->False,
           
           FontColor->RGBColor[
            0.08544870340446376, 0.9557823392713551, 0.8191696124259065],
           $CellContext`LineColor -> 
           RGBColor[
            0.08544870340446376, 0.9557823392713551, 0.8191696124259065],
           $CellContext`FrontFaceColor -> 
           RGBColor[
            0.08544870340446376, 0.9557823392713551, 0.8191696124259065],
           $CellContext`GraphicsColor -> 
           RGBColor[
            0.08544870340446376, 0.9557823392713551, 0.8191696124259065],
           $CellContext`BackFaceColor -> 
           RGBColor[
            0.08544870340446376, 0.9557823392713551, 0.8191696124259065]],
          
          Background->RGBColor[
           0.4501484548909995, 0.8016527788282983, 0.9932098327063934],
          StripOnInput->False], ",", 
         FrameBox[
          StyleBox["\<\"j\"\>",
           StripOnInput->False,
           
           FontColor->RGBColor[
            0.7636657492988439, 0.6255959183691555, 0.7904997766036974],
           $CellContext`LineColor -> 
           RGBColor[
            0.7636657492988439, 0.6255959183691555, 0.7904997766036974],
           $CellContext`FrontFaceColor -> 
           RGBColor[
            0.7636657492988439, 0.6255959183691555, 0.7904997766036974],
           $CellContext`GraphicsColor -> 
           RGBColor[
            0.7636657492988439, 0.6255959183691555, 0.7904997766036974],
           $CellContext`BackFaceColor -> 
           RGBColor[
            0.7636657492988439, 0.6255959183691555, 0.7904997766036974]],
          
          Background->RGBColor[
           0.5414410427604273, 0.7233153667227659, 0.5710686328817542],
          StripOnInput->False], ",", 
         FrameBox[
          StyleBox["\<\"k\"\>",
           StripOnInput->False,
           
           FontColor->RGBColor[
            0.4411417860301161, 0.41519622700742853`, 0.7381039848220301],
           $CellContext`LineColor -> 
           RGBColor[
            0.4411417860301161, 0.41519622700742853`, 0.7381039848220301],
           $CellContext`FrontFaceColor -> 
           RGBColor[
            0.4411417860301161, 0.41519622700742853`, 0.7381039848220301],
           $CellContext`GraphicsColor -> 
           RGBColor[
            0.4411417860301161, 0.41519622700742853`, 0.7381039848220301],
           $CellContext`BackFaceColor -> 
           RGBColor[
            0.4411417860301161, 0.41519622700742853`, 0.7381039848220301]],
          
          Background->RGBColor[
           0.9631574247175236, 0.687491974533827, 0.07623667174720761],
          StripOnInput->False], ",", 
         FrameBox[
          StyleBox["\<\"l\"\>",
           StripOnInput->False,
           
           FontColor->RGBColor[
            0.9616095206061639, 0.8091937104599927, 0.5402567941399012],
           $CellContext`LineColor -> 
           RGBColor[
            0.9616095206061639, 0.8091937104599927, 0.5402567941399012],
           $CellContext`FrontFaceColor -> 
           RGBColor[
            0.9616095206061639, 0.8091937104599927, 0.5402567941399012],
           $CellContext`GraphicsColor -> 
           RGBColor[
            0.9616095206061639, 0.8091937104599927, 0.5402567941399012],
           $CellContext`BackFaceColor -> 
           RGBColor[
            0.9616095206061639, 0.8091937104599927, 0.5402567941399012]],
          
          Background->RGBColor[
           0.7397975957469587, 0.8831661312195698, 0.9461121892848012],
          StripOnInput->False], ",", 
         FrameBox[
          StyleBox["\<\"m\"\>",
           StripOnInput->False,
           
           FontColor->RGBColor[
            0.9705072293734944, 0.46684070395787525`, 0.6546315288686311],
           $CellContext`LineColor -> 
           RGBColor[
            0.9705072293734944, 0.46684070395787525`, 0.6546315288686311],
           $CellContext`FrontFaceColor -> 
           RGBColor[
            0.9705072293734944, 0.46684070395787525`, 0.6546315288686311],
           $CellContext`GraphicsColor -> 
           RGBColor[
            0.9705072293734944, 0.46684070395787525`, 0.6546315288686311],
           $CellContext`BackFaceColor -> 
           RGBColor[
            0.9705072293734944, 0.46684070395787525`, 0.6546315288686311]],
          
          Background->RGBColor[
           0.3820271860979685, 0.9068964326399787, 0.08987515825266401],
          StripOnInput->False], ",", 
         FrameBox[
          StyleBox["\<\"n\"\>",
           StripOnInput->False,
           
           FontColor->RGBColor[
            0.2651046461322135, 0.6536282221465675, 0.8254569946802512],
           $CellContext`LineColor -> 
           RGBColor[
            0.2651046461322135, 0.6536282221465675, 0.8254569946802512],
           $CellContext`FrontFaceColor -> 
           RGBColor[
            0.2651046461322135, 0.6536282221465675, 0.8254569946802512],
           $CellContext`GraphicsColor -> 
           RGBColor[
            0.2651046461322135, 0.6536282221465675, 0.8254569946802512],
           $CellContext`BackFaceColor -> 
           RGBColor[
            0.2651046461322135, 0.6536282221465675, 0.8254569946802512]],
          
          Background->RGBColor[
           0.6604277061429311, 0.5942977074492097, 0.6805832712012272],
          StripOnInput->False], ",", 
         FrameBox[
          StyleBox["\<\"o\"\>",
           StripOnInput->False,
           
           FontColor->RGBColor[
            0.14525600133838834`, 0.6766852418795444, 0.8768964924748894],
           $CellContext`LineColor -> 
           RGBColor[
            0.14525600133838834`, 0.6766852418795444, 0.8768964924748894],
           $CellContext`FrontFaceColor -> 
           RGBColor[
            0.14525600133838834`, 0.6766852418795444, 0.8768964924748894],
           $CellContext`GraphicsColor -> 
           RGBColor[
            0.14525600133838834`, 0.6766852418795444, 0.8768964924748894],
           $CellContext`BackFaceColor -> 
           RGBColor[
            0.14525600133838834`, 0.6766852418795444, 0.8768964924748894]],
          
          Background->RGBColor[
           0.83508227809025, 0.09688270824239509, 0.6892021438768532],
          StripOnInput->False], ",", 
         FrameBox[
          StyleBox["\<\"p\"\>",
           StripOnInput->False,
           
           FontColor->RGBColor[
            0.5960132982411532, 0.40896940447374597`, 0.6032785119649371],
           $CellContext`LineColor -> 
           RGBColor[
            0.5960132982411532, 0.40896940447374597`, 0.6032785119649371],
           $CellContext`FrontFaceColor -> 
           RGBColor[
            0.5960132982411532, 0.40896940447374597`, 0.6032785119649371],
           $CellContext`GraphicsColor -> 
           RGBColor[
            0.5960132982411532, 0.40896940447374597`, 0.6032785119649371],
           $CellContext`BackFaceColor -> 
           RGBColor[
            0.5960132982411532, 0.40896940447374597`, 0.6032785119649371]],
          
          Background->RGBColor[
           0.6536623662907997, 0.7623964639910106, 0.04921049961929702],
          StripOnInput->False], ",", 
         FrameBox[
          StyleBox["\<\"q\"\>",
           StripOnInput->False,
           
           FontColor->RGBColor[
            0.6895497725829884, 0.8352498838543736, 0.6969612490430133],
           $CellContext`LineColor -> 
           RGBColor[
            0.6895497725829884, 0.8352498838543736, 0.6969612490430133],
           $CellContext`FrontFaceColor -> 
           RGBColor[
            0.6895497725829884, 0.8352498838543736, 0.6969612490430133],
           $CellContext`GraphicsColor -> 
           RGBColor[
            0.6895497725829884, 0.8352498838543736, 0.6969612490430133],
           $CellContext`BackFaceColor -> 
           RGBColor[
            0.6895497725829884, 0.8352498838543736, 0.6969612490430133]],
          
          Background->RGBColor[
           0.1649350500710789, 0.6523432596664296, 0.3616082614339764],
          StripOnInput->False], ",", 
         FrameBox[
          StyleBox["\<\"r\"\>",
           StripOnInput->False,
           
           FontColor->RGBColor[
            0.22481724418041926`, 0.11362113638001636`, 0.8728252572089408],
           $CellContext`LineColor -> 
           RGBColor[
            0.22481724418041926`, 0.11362113638001636`, 0.8728252572089408],
           $CellContext`FrontFaceColor -> 
           RGBColor[
            0.22481724418041926`, 0.11362113638001636`, 0.8728252572089408],
           $CellContext`GraphicsColor -> 
           RGBColor[
            0.22481724418041926`, 0.11362113638001636`, 0.8728252572089408],
           $CellContext`BackFaceColor -> 
           RGBColor[
            0.22481724418041926`, 0.11362113638001636`, 0.8728252572089408]],
          
          Background->RGBColor[
           0.944671456260961, 0.018652052830691268`, 0.4437996387871028],
          StripOnInput->False], ",", 
         FrameBox[
          StyleBox["\<\"s\"\>",
           StripOnInput->False,
           
           FontColor->RGBColor[
            0.5599053352370313, 0.7203582153430748, 0.31829434838690984`],
           $CellContext`LineColor -> 
           RGBColor[
            0.5599053352370313, 0.7203582153430748, 0.31829434838690984`],
           $CellContext`FrontFaceColor -> 
           RGBColor[
            0.5599053352370313, 0.7203582153430748, 0.31829434838690984`],
           $CellContext`GraphicsColor -> 
           RGBColor[
            0.5599053352370313, 0.7203582153430748, 0.31829434838690984`],
           $CellContext`BackFaceColor -> 
           RGBColor[
            0.5599053352370313, 0.7203582153430748, 0.31829434838690984`]],
          
          Background->RGBColor[
           0.30807415918295433`, 0.15107359195033432`, 0.2881405220738804],
          StripOnInput->False], ",", 
         FrameBox[
          StyleBox["\<\"t\"\>",
           StripOnInput->False,
           
           FontColor->RGBColor[
            0.2825204520652791, 0.13226280653768208`, 0.9854883764761257],
           $CellContext`LineColor -> 
           RGBColor[
            0.2825204520652791, 0.13226280653768208`, 0.9854883764761257],
           $CellContext`FrontFaceColor -> 
           RGBColor[
            0.2825204520652791, 0.13226280653768208`, 0.9854883764761257],
           $CellContext`GraphicsColor -> 
           RGBColor[
            0.2825204520652791, 0.13226280653768208`, 0.9854883764761257],
           $CellContext`BackFaceColor -> 
           RGBColor[
            0.2825204520652791, 0.13226280653768208`, 0.9854883764761257]],
          
          Background->RGBColor[
           0.2252376167731891, 0.8231980396345122, 0.7917295733562619],
          StripOnInput->False], ",", 
         FrameBox[
          StyleBox["\<\"u\"\>",
           StripOnInput->False,
           
           FontColor->RGBColor[
            0.6024914431862527, 0.1286363592587374, 0.281639564441321],
           $CellContext`LineColor -> 
           RGBColor[0.6024914431862527, 0.1286363592587374, 0.281639564441321],
           $CellContext`FrontFaceColor -> 
           RGBColor[0.6024914431862527, 0.1286363592587374, 0.281639564441321],
           $CellContext`GraphicsColor -> 
           RGBColor[0.6024914431862527, 0.1286363592587374, 0.281639564441321],
           $CellContext`BackFaceColor -> 
           RGBColor[
            0.6024914431862527, 0.1286363592587374, 0.281639564441321]],
          
          Background->RGBColor[
           0.7681382812972022, 0.07016768904662518, 0.5953912454685029],
          StripOnInput->False], ",", 
         FrameBox[
          StyleBox["\<\"v\"\>",
           StripOnInput->False,
           
           FontColor->RGBColor[
            0.5122853891591432, 0.33279870472224626`, 0.5465815391366218],
           $CellContext`LineColor -> 
           RGBColor[
            0.5122853891591432, 0.33279870472224626`, 0.5465815391366218],
           $CellContext`FrontFaceColor -> 
           RGBColor[
            0.5122853891591432, 0.33279870472224626`, 0.5465815391366218],
           $CellContext`GraphicsColor -> 
           RGBColor[
            0.5122853891591432, 0.33279870472224626`, 0.5465815391366218],
           $CellContext`BackFaceColor -> 
           RGBColor[
            0.5122853891591432, 0.33279870472224626`, 0.5465815391366218]],
          
          Background->RGBColor[
           0.9153856339220403, 0.7519924755577168, 0.6307472412991688],
          StripOnInput->False], ",", 
         FrameBox[
          StyleBox["\<\"w\"\>",
           StripOnInput->False,
           
           FontColor->RGBColor[
            0.83736027442348, 0.4044020834140172, 0.9214530557592653],
           $CellContext`LineColor -> 
           RGBColor[
            0.83736027442348, 0.4044020834140172, 0.9214530557592653],
           $CellContext`FrontFaceColor -> 
           RGBColor[
            0.83736027442348, 0.4044020834140172, 0.9214530557592653],
           $CellContext`GraphicsColor -> 
           RGBColor[
            0.83736027442348, 0.4044020834140172, 0.9214530557592653],
           $CellContext`BackFaceColor -> 
           RGBColor[0.83736027442348, 0.4044020834140172, 0.9214530557592653]],
          
          
          Background->RGBColor[
           0.6469635506833387, 0.7174790743389783, 0.11684064786783366`],
          StripOnInput->False], ",", 
         FrameBox[
          StyleBox["\<\"x\"\>",
           StripOnInput->False,
           
           FontColor->RGBColor[
            0.9750876701227253, 0.45659390241322884`, 0.3443435290120649],
           $CellContext`LineColor -> 
           RGBColor[
            0.9750876701227253, 0.45659390241322884`, 0.3443435290120649],
           $CellContext`FrontFaceColor -> 
           RGBColor[
            0.9750876701227253, 0.45659390241322884`, 0.3443435290120649],
           $CellContext`GraphicsColor -> 
           RGBColor[
            0.9750876701227253, 0.45659390241322884`, 0.3443435290120649],
           $CellContext`BackFaceColor -> 
           RGBColor[
            0.9750876701227253, 0.45659390241322884`, 0.3443435290120649]],
          
          Background->RGBColor[
           0.6065084362851154, 0.8037296141187871, 0.6402351549669116],
          StripOnInput->False], ",", 
         FrameBox[
          StyleBox["\<\"y\"\>",
           StripOnInput->False,
           
           FontColor->RGBColor[
            0.38862365095273366`, 0.9661625186323028, 0.46647935184203315`],
           $CellContext`LineColor -> 
           RGBColor[
            0.38862365095273366`, 0.9661625186323028, 0.46647935184203315`],
           $CellContext`FrontFaceColor -> 
           RGBColor[
            0.38862365095273366`, 0.9661625186323028, 0.46647935184203315`],
           $CellContext`GraphicsColor -> 
           RGBColor[
            0.38862365095273366`, 0.9661625186323028, 0.46647935184203315`],
           $CellContext`BackFaceColor -> 
           RGBColor[
            0.38862365095273366`, 0.9661625186323028, 0.46647935184203315`]],
          
          Background->RGBColor[
           0.15121833314189037`, 0.3294788415333836, 0.05005388141517342],
          StripOnInput->False], ",", 
         FrameBox[
          StyleBox["\<\"z\"\>",
           StripOnInput->False,
           
           FontColor->RGBColor[
            0.5155106366307074, 0.997359323765757, 0.6507661801610531],
           $CellContext`LineColor -> 
           RGBColor[0.5155106366307074, 0.997359323765757, 0.6507661801610531],
           $CellContext`FrontFaceColor -> 
           RGBColor[0.5155106366307074, 0.997359323765757, 0.6507661801610531],
           $CellContext`GraphicsColor -> 
           RGBColor[0.5155106366307074, 0.997359323765757, 0.6507661801610531],
           $CellContext`BackFaceColor -> 
           RGBColor[
            0.5155106366307074, 0.997359323765757, 0.6507661801610531]],
          
          Background->RGBColor[
           0.8200001861691399, 0.9202150507220361, 0.8658158700478431],
          StripOnInput->False]}], "}"}]], "ExerciseOutput",ExpressionUUID->
       "78b2dee9-5cd2-4b3d-85ca-7b1674737976"],
      Apply[TextCell, 
       Cell[
        BoxData[
         RowBox[{"{", 
           RowBox[{
             FrameBox[
              StyleBox[
              "\"a\"", StripOnInput -> False, $CellContext`LineColor -> 
               RGBColor[
                0.9605784669619559, 0.15191951859194286`, 
                 0.18478821678384683`], $CellContext`FrontFaceColor -> 
               RGBColor[
                0.9605784669619559, 0.15191951859194286`, 
                 0.18478821678384683`], $CellContext`GraphicsColor -> 
               RGBColor[
                0.9605784669619559, 0.15191951859194286`, 
                 0.18478821678384683`], FontColor -> 
               RGBColor[
                0.9605784669619559, 0.15191951859194286`, 
                 0.18478821678384683`], $CellContext`BackFaceColor -> 
               RGBColor[
                0.9605784669619559, 0.15191951859194286`, 
                 0.18478821678384683`]], Background -> 
              RGBColor[
               0.0584426420889641, 0.2568862297720107, 0.8514545236994886], 
              StripOnInput -> False], ",", 
             FrameBox[
              StyleBox[
              "\"b\"", StripOnInput -> False, $CellContext`LineColor -> 
               RGBColor[
                0.5924770827975059, 0.8712066332532591, 
                 0.6501170574997406], $CellContext`FrontFaceColor -> 
               RGBColor[
                0.5924770827975059, 0.8712066332532591, 
                 0.6501170574997406], $CellContext`GraphicsColor -> 
               RGBColor[
                0.5924770827975059, 0.8712066332532591, 0.6501170574997406], 
               FontColor -> 
               RGBColor[
                0.5924770827975059, 0.8712066332532591, 
                 0.6501170574997406], $CellContext`BackFaceColor -> 
               RGBColor[
                0.5924770827975059, 0.8712066332532591, 0.6501170574997406]], 
              Background -> 
              RGBColor[
               0.6026179743382689, 0.07201770869232882, 0.4055008626852239], 
              StripOnInput -> False], ",", 
             FrameBox[
              StyleBox[
              "\"c\"", StripOnInput -> False, $CellContext`LineColor -> 
               RGBColor[
                0.6858781999084698, 0.40767754765650954`, 
                 0.2895651875850487], $CellContext`FrontFaceColor -> 
               RGBColor[
                0.6858781999084698, 0.40767754765650954`, 
                 0.2895651875850487], $CellContext`GraphicsColor -> 
               RGBColor[
                0.6858781999084698, 0.40767754765650954`, 0.2895651875850487],
                FontColor -> 
               RGBColor[
                0.6858781999084698, 0.40767754765650954`, 
                 0.2895651875850487], $CellContext`BackFaceColor -> 
               RGBColor[
                0.6858781999084698, 0.40767754765650954`, 
                 0.2895651875850487]], Background -> 
              RGBColor[
               0.2844415176815438, 0.47108122972753574`, 0.5053708365240432], 
              StripOnInput -> False], ",", 
             FrameBox[
              StyleBox[
              "\"d\"", StripOnInput -> False, $CellContext`LineColor -> 
               RGBColor[
                0.38517150774737496`, 0.060170780815135494`, 
                 0.09554268062768001], $CellContext`FrontFaceColor -> 
               RGBColor[
                0.38517150774737496`, 0.060170780815135494`, 
                 0.09554268062768001], $CellContext`GraphicsColor -> 
               RGBColor[
                0.38517150774737496`, 0.060170780815135494`, 
                 0.09554268062768001], FontColor -> 
               RGBColor[
                0.38517150774737496`, 0.060170780815135494`, 
                 0.09554268062768001], $CellContext`BackFaceColor -> 
               RGBColor[
                0.38517150774737496`, 0.060170780815135494`, 
                 0.09554268062768001]], Background -> 
              RGBColor[
               0.47344799063375076`, 0.9030258895705245, 0.9309630217380565], 
              StripOnInput -> False], ",", 
             FrameBox[
              StyleBox[
              "\"e\"", StripOnInput -> False, $CellContext`LineColor -> 
               RGBColor[
                0.9785769223693994, 0.8793664572150963, 
                 0.9711795477331708], $CellContext`FrontFaceColor -> 
               RGBColor[
                0.9785769223693994, 0.8793664572150963, 
                 0.9711795477331708], $CellContext`GraphicsColor -> 
               RGBColor[
                0.9785769223693994, 0.8793664572150963, 0.9711795477331708], 
               FontColor -> 
               RGBColor[
                0.9785769223693994, 0.8793664572150963, 
                 0.9711795477331708], $CellContext`BackFaceColor -> 
               RGBColor[
                0.9785769223693994, 0.8793664572150963, 0.9711795477331708]], 
              Background -> 
              RGBColor[
               0.3635682546564729, 0.21408609659066924`, 0.1643083844713602], 
              StripOnInput -> False], ",", 
             FrameBox[
              StyleBox[
              "\"f\"", StripOnInput -> False, $CellContext`LineColor -> 
               RGBColor[
                0.8566197105465485, 0.7056552003683692, 
                 0.5757167228458095], $CellContext`FrontFaceColor -> 
               RGBColor[
                0.8566197105465485, 0.7056552003683692, 
                 0.5757167228458095], $CellContext`GraphicsColor -> 
               RGBColor[
                0.8566197105465485, 0.7056552003683692, 0.5757167228458095], 
               FontColor -> 
               RGBColor[
                0.8566197105465485, 0.7056552003683692, 
                 0.5757167228458095], $CellContext`BackFaceColor -> 
               RGBColor[
                0.8566197105465485, 0.7056552003683692, 0.5757167228458095]], 
              Background -> 
              RGBColor[
               0.9379084230873833, 0.7626678287262885, 0.31679728168391974`], 
              StripOnInput -> False], ",", 
             FrameBox[
              StyleBox[
              "\"g\"", StripOnInput -> False, $CellContext`LineColor -> 
               RGBColor[
                0.17766853743747069`, 0.6100951004959156, 
                 0.6116642512871422], $CellContext`FrontFaceColor -> 
               RGBColor[
                0.17766853743747069`, 0.6100951004959156, 
                 0.6116642512871422], $CellContext`GraphicsColor -> 
               RGBColor[
                0.17766853743747069`, 0.6100951004959156, 0.6116642512871422],
                FontColor -> 
               RGBColor[
                0.17766853743747069`, 0.6100951004959156, 
                 0.6116642512871422], $CellContext`BackFaceColor -> 
               RGBColor[
                0.17766853743747069`, 0.6100951004959156, 
                 0.6116642512871422]], Background -> 
              RGBColor[
               0.8929305658833444, 0.5275148951227111, 0.03534385990278266], 
              StripOnInput -> False], ",", 
             FrameBox[
              StyleBox[
              "\"h\"", StripOnInput -> False, $CellContext`LineColor -> 
               RGBColor[
                0.86377086837588, 0.8642655565373705, 
                 0.12481961165910693`], $CellContext`FrontFaceColor -> 
               RGBColor[
                0.86377086837588, 0.8642655565373705, 
                 0.12481961165910693`], $CellContext`GraphicsColor -> 
               RGBColor[
                0.86377086837588, 0.8642655565373705, 0.12481961165910693`], 
               FontColor -> 
               RGBColor[
                0.86377086837588, 0.8642655565373705, 
                 0.12481961165910693`], $CellContext`BackFaceColor -> 
               RGBColor[
                0.86377086837588, 0.8642655565373705, 0.12481961165910693`]], 
              Background -> 
              RGBColor[
               0.22799569263352382`, 0.6895964810627666, 0.689635404329247], 
              StripOnInput -> False], ",", 
             FrameBox[
              StyleBox[
              "\"i\"", StripOnInput -> False, $CellContext`LineColor -> 
               RGBColor[
                0.08544870340446376, 0.9557823392713551, 
                 0.8191696124259065], $CellContext`FrontFaceColor -> 
               RGBColor[
                0.08544870340446376, 0.9557823392713551, 
                 0.8191696124259065], $CellContext`GraphicsColor -> 
               RGBColor[
                0.08544870340446376, 0.9557823392713551, 0.8191696124259065], 
               FontColor -> 
               RGBColor[
                0.08544870340446376, 0.9557823392713551, 
                 0.8191696124259065], $CellContext`BackFaceColor -> 
               RGBColor[
                0.08544870340446376, 0.9557823392713551, 0.8191696124259065]],
               Background -> 
              RGBColor[
               0.4501484548909995, 0.8016527788282983, 0.9932098327063934], 
              StripOnInput -> False], ",", 
             FrameBox[
              StyleBox[
              "\"j\"", StripOnInput -> False, $CellContext`LineColor -> 
               RGBColor[
                0.7636657492988439, 0.6255959183691555, 
                 0.7904997766036974], $CellContext`FrontFaceColor -> 
               RGBColor[
                0.7636657492988439, 0.6255959183691555, 
                 0.7904997766036974], $CellContext`GraphicsColor -> 
               RGBColor[
                0.7636657492988439, 0.6255959183691555, 0.7904997766036974], 
               FontColor -> 
               RGBColor[
                0.7636657492988439, 0.6255959183691555, 
                 0.7904997766036974], $CellContext`BackFaceColor -> 
               RGBColor[
                0.7636657492988439, 0.6255959183691555, 0.7904997766036974]], 
              Background -> 
              RGBColor[
               0.5414410427604273, 0.7233153667227659, 0.5710686328817542], 
              StripOnInput -> False], ",", 
             FrameBox[
              StyleBox[
              "\"k\"", StripOnInput -> False, $CellContext`LineColor -> 
               RGBColor[
                0.4411417860301161, 0.41519622700742853`, 
                 0.7381039848220301], $CellContext`FrontFaceColor -> 
               RGBColor[
                0.4411417860301161, 0.41519622700742853`, 
                 0.7381039848220301], $CellContext`GraphicsColor -> 
               RGBColor[
                0.4411417860301161, 0.41519622700742853`, 0.7381039848220301],
                FontColor -> 
               RGBColor[
                0.4411417860301161, 0.41519622700742853`, 
                 0.7381039848220301], $CellContext`BackFaceColor -> 
               RGBColor[
                0.4411417860301161, 0.41519622700742853`, 
                 0.7381039848220301]], Background -> 
              RGBColor[
               0.9631574247175236, 0.687491974533827, 0.07623667174720761], 
              StripOnInput -> False], ",", 
             FrameBox[
              StyleBox[
              "\"l\"", StripOnInput -> False, $CellContext`LineColor -> 
               RGBColor[
                0.9616095206061639, 0.8091937104599927, 
                 0.5402567941399012], $CellContext`FrontFaceColor -> 
               RGBColor[
                0.9616095206061639, 0.8091937104599927, 
                 0.5402567941399012], $CellContext`GraphicsColor -> 
               RGBColor[
                0.9616095206061639, 0.8091937104599927, 0.5402567941399012], 
               FontColor -> 
               RGBColor[
                0.9616095206061639, 0.8091937104599927, 
                 0.5402567941399012], $CellContext`BackFaceColor -> 
               RGBColor[
                0.9616095206061639, 0.8091937104599927, 0.5402567941399012]], 
              Background -> 
              RGBColor[
               0.7397975957469587, 0.8831661312195698, 0.9461121892848012], 
              StripOnInput -> False], ",", 
             FrameBox[
              StyleBox[
              "\"m\"", StripOnInput -> False, $CellContext`LineColor -> 
               RGBColor[
                0.9705072293734944, 0.46684070395787525`, 
                 0.6546315288686311], $CellContext`FrontFaceColor -> 
               RGBColor[
                0.9705072293734944, 0.46684070395787525`, 
                 0.6546315288686311], $CellContext`GraphicsColor -> 
               RGBColor[
                0.9705072293734944, 0.46684070395787525`, 0.6546315288686311],
                FontColor -> 
               RGBColor[
                0.9705072293734944, 0.46684070395787525`, 
                 0.6546315288686311], $CellContext`BackFaceColor -> 
               RGBColor[
                0.9705072293734944, 0.46684070395787525`, 
                 0.6546315288686311]], Background -> 
              RGBColor[
               0.3820271860979685, 0.9068964326399787, 0.08987515825266401], 
              StripOnInput -> False], ",", 
             FrameBox[
              StyleBox[
              "\"n\"", StripOnInput -> False, $CellContext`LineColor -> 
               RGBColor[
                0.2651046461322135, 0.6536282221465675, 
                 0.8254569946802512], $CellContext`FrontFaceColor -> 
               RGBColor[
                0.2651046461322135, 0.6536282221465675, 
                 0.8254569946802512], $CellContext`GraphicsColor -> 
               RGBColor[
                0.2651046461322135, 0.6536282221465675, 0.8254569946802512], 
               FontColor -> 
               RGBColor[
                0.2651046461322135, 0.6536282221465675, 
                 0.8254569946802512], $CellContext`BackFaceColor -> 
               RGBColor[
                0.2651046461322135, 0.6536282221465675, 0.8254569946802512]], 
              Background -> 
              RGBColor[
               0.6604277061429311, 0.5942977074492097, 0.6805832712012272], 
              StripOnInput -> False], ",", 
             FrameBox[
              StyleBox[
              "\"o\"", StripOnInput -> False, $CellContext`LineColor -> 
               RGBColor[
                0.14525600133838834`, 0.6766852418795444, 
                 0.8768964924748894], $CellContext`FrontFaceColor -> 
               RGBColor[
                0.14525600133838834`, 0.6766852418795444, 
                 0.8768964924748894], $CellContext`GraphicsColor -> 
               RGBColor[
                0.14525600133838834`, 0.6766852418795444, 0.8768964924748894],
                FontColor -> 
               RGBColor[
                0.14525600133838834`, 0.6766852418795444, 
                 0.8768964924748894], $CellContext`BackFaceColor -> 
               RGBColor[
                0.14525600133838834`, 0.6766852418795444, 
                 0.8768964924748894]], Background -> 
              RGBColor[
               0.83508227809025, 0.09688270824239509, 0.6892021438768532], 
              StripOnInput -> False], ",", 
             FrameBox[
              StyleBox[
              "\"p\"", StripOnInput -> False, $CellContext`LineColor -> 
               RGBColor[
                0.5960132982411532, 0.40896940447374597`, 
                 0.6032785119649371], $CellContext`FrontFaceColor -> 
               RGBColor[
                0.5960132982411532, 0.40896940447374597`, 
                 0.6032785119649371], $CellContext`GraphicsColor -> 
               RGBColor[
                0.5960132982411532, 0.40896940447374597`, 0.6032785119649371],
                FontColor -> 
               RGBColor[
                0.5960132982411532, 0.40896940447374597`, 
                 0.6032785119649371], $CellContext`BackFaceColor -> 
               RGBColor[
                0.5960132982411532, 0.40896940447374597`, 
                 0.6032785119649371]], Background -> 
              RGBColor[
               0.6536623662907997, 0.7623964639910106, 0.04921049961929702], 
              StripOnInput -> False], ",", 
             FrameBox[
              StyleBox[
              "\"q\"", StripOnInput -> False, $CellContext`LineColor -> 
               RGBColor[
                0.6895497725829884, 0.8352498838543736, 
                 0.6969612490430133], $CellContext`FrontFaceColor -> 
               RGBColor[
                0.6895497725829884, 0.8352498838543736, 
                 0.6969612490430133], $CellContext`GraphicsColor -> 
               RGBColor[
                0.6895497725829884, 0.8352498838543736, 0.6969612490430133], 
               FontColor -> 
               RGBColor[
                0.6895497725829884, 0.8352498838543736, 
                 0.6969612490430133], $CellContext`BackFaceColor -> 
               RGBColor[
                0.6895497725829884, 0.8352498838543736, 0.6969612490430133]], 
              Background -> 
              RGBColor[
               0.1649350500710789, 0.6523432596664296, 0.3616082614339764], 
              StripOnInput -> False], ",", 
             FrameBox[
              StyleBox[
              "\"r\"", StripOnInput -> False, $CellContext`LineColor -> 
               RGBColor[
                0.22481724418041926`, 0.11362113638001636`, 
                 0.8728252572089408], $CellContext`FrontFaceColor -> 
               RGBColor[
                0.22481724418041926`, 0.11362113638001636`, 
                 0.8728252572089408], $CellContext`GraphicsColor -> 
               RGBColor[
                0.22481724418041926`, 0.11362113638001636`, 
                 0.8728252572089408], FontColor -> 
               RGBColor[
                0.22481724418041926`, 0.11362113638001636`, 
                 0.8728252572089408], $CellContext`BackFaceColor -> 
               RGBColor[
                0.22481724418041926`, 0.11362113638001636`, 
                 0.8728252572089408]], Background -> 
              RGBColor[
               0.944671456260961, 0.018652052830691268`, 0.4437996387871028], 
              StripOnInput -> False], ",", 
             FrameBox[
              StyleBox[
              "\"s\"", StripOnInput -> False, $CellContext`LineColor -> 
               RGBColor[
                0.5599053352370313, 0.7203582153430748, 
                 0.31829434838690984`], $CellContext`FrontFaceColor -> 
               RGBColor[
                0.5599053352370313, 0.7203582153430748, 
                 0.31829434838690984`], $CellContext`GraphicsColor -> 
               RGBColor[
                0.5599053352370313, 0.7203582153430748, 0.31829434838690984`],
                FontColor -> 
               RGBColor[
                0.5599053352370313, 0.7203582153430748, 
                 0.31829434838690984`], $CellContext`BackFaceColor -> 
               RGBColor[
                0.5599053352370313, 0.7203582153430748, 
                 0.31829434838690984`]], Background -> 
              RGBColor[
               0.30807415918295433`, 0.15107359195033432`, 
                0.2881405220738804], StripOnInput -> False], ",", 
             FrameBox[
              StyleBox[
              "\"t\"", StripOnInput -> False, $CellContext`LineColor -> 
               RGBColor[
                0.2825204520652791, 0.13226280653768208`, 
                 0.9854883764761257], $CellContext`FrontFaceColor -> 
               RGBColor[
                0.2825204520652791, 0.13226280653768208`, 
                 0.9854883764761257], $CellContext`GraphicsColor -> 
               RGBColor[
                0.2825204520652791, 0.13226280653768208`, 0.9854883764761257],
                FontColor -> 
               RGBColor[
                0.2825204520652791, 0.13226280653768208`, 
                 0.9854883764761257], $CellContext`BackFaceColor -> 
               RGBColor[
                0.2825204520652791, 0.13226280653768208`, 
                 0.9854883764761257]], Background -> 
              RGBColor[
               0.2252376167731891, 0.8231980396345122, 0.7917295733562619], 
              StripOnInput -> False], ",", 
             FrameBox[
              StyleBox[
              "\"u\"", StripOnInput -> False, $CellContext`LineColor -> 
               RGBColor[
                0.6024914431862527, 0.1286363592587374, 
                 0.281639564441321], $CellContext`FrontFaceColor -> 
               RGBColor[
                0.6024914431862527, 0.1286363592587374, 
                 0.281639564441321], $CellContext`GraphicsColor -> 
               RGBColor[
                0.6024914431862527, 0.1286363592587374, 0.281639564441321], 
               FontColor -> 
               RGBColor[
                0.6024914431862527, 0.1286363592587374, 
                 0.281639564441321], $CellContext`BackFaceColor -> 
               RGBColor[
                0.6024914431862527, 0.1286363592587374, 0.281639564441321]], 
              Background -> 
              RGBColor[
               0.7681382812972022, 0.07016768904662518, 0.5953912454685029], 
              StripOnInput -> False], ",", 
             FrameBox[
              StyleBox[
              "\"v\"", StripOnInput -> False, $CellContext`LineColor -> 
               RGBColor[
                0.5122853891591432, 0.33279870472224626`, 
                 0.5465815391366218], $CellContext`FrontFaceColor -> 
               RGBColor[
                0.5122853891591432, 0.33279870472224626`, 
                 0.5465815391366218], $CellContext`GraphicsColor -> 
               RGBColor[
                0.5122853891591432, 0.33279870472224626`, 0.5465815391366218],
                FontColor -> 
               RGBColor[
                0.5122853891591432, 0.33279870472224626`, 
                 0.5465815391366218], $CellContext`BackFaceColor -> 
               RGBColor[
                0.5122853891591432, 0.33279870472224626`, 
                 0.5465815391366218]], Background -> 
              RGBColor[
               0.9153856339220403, 0.7519924755577168, 0.6307472412991688], 
              StripOnInput -> False], ",", 
             FrameBox[
              StyleBox[
              "\"w\"", StripOnInput -> False, $CellContext`LineColor -> 
               RGBColor[
                0.83736027442348, 0.4044020834140172, 
                 0.9214530557592653], $CellContext`FrontFaceColor -> 
               RGBColor[
                0.83736027442348, 0.4044020834140172, 
                 0.9214530557592653], $CellContext`GraphicsColor -> 
               RGBColor[
                0.83736027442348, 0.4044020834140172, 0.9214530557592653], 
               FontColor -> 
               RGBColor[
                0.83736027442348, 0.4044020834140172, 
                 0.9214530557592653], $CellContext`BackFaceColor -> 
               RGBColor[
                0.83736027442348, 0.4044020834140172, 0.9214530557592653]], 
              Background -> 
              RGBColor[
               0.6469635506833387, 0.7174790743389783, 0.11684064786783366`], 
              StripOnInput -> False], ",", 
             FrameBox[
              StyleBox[
              "\"x\"", StripOnInput -> False, $CellContext`LineColor -> 
               RGBColor[
                0.9750876701227253, 0.45659390241322884`, 
                 0.3443435290120649], $CellContext`FrontFaceColor -> 
               RGBColor[
                0.9750876701227253, 0.45659390241322884`, 
                 0.3443435290120649], $CellContext`GraphicsColor -> 
               RGBColor[
                0.9750876701227253, 0.45659390241322884`, 0.3443435290120649],
                FontColor -> 
               RGBColor[
                0.9750876701227253, 0.45659390241322884`, 
                 0.3443435290120649], $CellContext`BackFaceColor -> 
               RGBColor[
                0.9750876701227253, 0.45659390241322884`, 
                 0.3443435290120649]], Background -> 
              RGBColor[
               0.6065084362851154, 0.8037296141187871, 0.6402351549669116], 
              StripOnInput -> False], ",", 
             FrameBox[
              StyleBox[
              "\"y\"", StripOnInput -> False, $CellContext`LineColor -> 
               RGBColor[
                0.38862365095273366`, 0.9661625186323028, 
                 0.46647935184203315`], $CellContext`FrontFaceColor -> 
               RGBColor[
                0.38862365095273366`, 0.9661625186323028, 
                 0.46647935184203315`], $CellContext`GraphicsColor -> 
               RGBColor[
                0.38862365095273366`, 0.9661625186323028, 
                 0.46647935184203315`], FontColor -> 
               RGBColor[
                0.38862365095273366`, 0.9661625186323028, 
                 0.46647935184203315`], $CellContext`BackFaceColor -> 
               RGBColor[
                0.38862365095273366`, 0.9661625186323028, 
                 0.46647935184203315`]], Background -> 
              RGBColor[
               0.15121833314189037`, 0.3294788415333836, 0.05005388141517342],
               StripOnInput -> False], ",", 
             FrameBox[
              StyleBox[
              "\"z\"", StripOnInput -> False, $CellContext`LineColor -> 
               RGBColor[
                0.5155106366307074, 0.997359323765757, 
                 0.6507661801610531], $CellContext`FrontFaceColor -> 
               RGBColor[
                0.5155106366307074, 0.997359323765757, 
                 0.6507661801610531], $CellContext`GraphicsColor -> 
               RGBColor[
                0.5155106366307074, 0.997359323765757, 0.6507661801610531], 
               FontColor -> 
               RGBColor[
                0.5155106366307074, 0.997359323765757, 
                 0.6507661801610531], $CellContext`BackFaceColor -> 
               RGBColor[
                0.5155106366307074, 0.997359323765757, 0.6507661801610531]], 
              Background -> 
              RGBColor[
               0.8200001861691399, 0.9202150507220361, 0.8658158700478431], 
              StripOnInput -> False]}], "}"}]], "ExerciseOutput", Selectable -> 
        False, Copyable -> False, Editable -> False, ShowCellBracket -> 
        False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"18143114-e606-48b4-837f-6edccfb88f09"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Make a table of G5 countries, together with their flags, and arrange the \
result in a fully framed grid.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "26.5", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"93a86aed-8844-4cee-999e-45e17e573734"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       TagBox[GridBox[{
          {
           TemplateBox[{"\"France\"", 
             RowBox[{"Entity", "[", 
               RowBox[{"\"Country\"", ",", "\"France\""}], "]"}], 
             "\"Entity[\\\"Country\\\", \\\"France\\\"]\"", "\"country\""},
            "Entity"], 
           GraphicsBox[
            {Thickness[0.001388888888888889], 
             {FaceForm[{RGBColor[0.9294119999999999, 0.160784, 0.223529], 
              Opacity[1.]}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}}}, {{{0., 
               0.}, {0., 480.}, {720., 480.}, {720., 0.}}}]}, 
             {FaceForm[{RGBColor[1., 1., 1.], Opacity[1.]}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}}}, {{{0., 
               480.}, {480., 480.}, {480., 0.}, {0., 0.}}}]}, 
             {FaceForm[{RGBColor[
              0., 0.13725500000000002`, 0.5843139999999999], Opacity[1.]}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}}}, {{{0., 
               480.}, {240., 480.}, {240., 0.}, {0., 0.}}}]}},
            AspectRatio->Automatic,
            ImageSize->{{128}, {85}},
            PlotRange->{{0., 720.}, {0., 480.}}]},
          {
           TemplateBox[{"\"Germany\"", 
             RowBox[{"Entity", "[", 
               RowBox[{"\"Country\"", ",", "\"Germany\""}], "]"}], 
             "\"Entity[\\\"Country\\\", \\\"Germany\\\"]\"", "\"country\""},
            "Entity"], 
           GraphicsBox[
            {Thickness[0.00125], 
             {Thickness[0.00125], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}}}, {{{0., 
               0.}, {0., 480.}, {800., 480.}, {800., 0.}}}]}, 
             {FaceForm[{RGBColor[0.8666670000000001, 0., 0.], Opacity[1.]}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}}}, {{{0., 
               320.}, {800., 320.}, {800., 0.}, {0., 0.}}}]}, 
             {FaceForm[{RGBColor[1., 0.8078430000000001, 0.], Opacity[1.]}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}}}, {{{0., 
               160.}, {800., 160.}, {800., 0.}, {0., 0.}}}]}},
            AspectRatio->Automatic,
            ImageSize->{{128}, {85}},
            PlotRange->{{0., 800.}, {0., 480.}}]},
          {
           TemplateBox[{"\"Japan\"", 
             RowBox[{"Entity", "[", 
               RowBox[{"\"Country\"", ",", "\"Japan\""}], "]"}], 
             "\"Entity[\\\"Country\\\", \\\"Japan\\\"]\"", "\"country\""},
            "Entity"], 
           GraphicsBox[
            {Thickness[0.001388888888888889], 
             {FaceForm[{RGBColor[1., 1., 1.], Opacity[1.]}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}}}, {{{0., 
               0.}, {0., 480.}, {720., 480.}, {720., 0.}}}]}, 
             {FaceForm[{RGBColor[0.737255, 0., 0.17647100000000002`], Opacity[
              1.]}], FilledCurveBox[{{{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
               3}}}, {{{504., 240.}, {504., 160.47299999999998`}, {439.527, 
               96.}, {360., 96.}, {280.47299999999996`, 96.}, {216., 
               160.47299999999998`}, {216., 240.}, {216., 319.527}, {
               280.47299999999996`, 384.}, {360., 384.}, {439.527, 384.}, {
               504., 319.527}, {504., 240.}}}]}},
            AspectRatio->Automatic,
            ImageSize->{{128}, {85}},
            PlotRange->{{0., 720.}, {0., 480.}}]},
          {
           TemplateBox[{"\"United Kingdom\"", 
             RowBox[{"Entity", "[", 
               RowBox[{"\"Country\"", ",", "\"UnitedKingdom\""}], "]"}], 
             "\"Entity[\\\"Country\\\", \\\"UnitedKingdom\\\"]\"", 
             "\"country\""},
            "Entity"], 
           GraphicsBox[{
             {RGBColor[0., 0.141176, 0.49019599999999997`], 
              PolygonBox[{{0, 201}, {400, 201}, {400, 401}, {0, 401}}]}, {
              {Thickness[0.00125], 
               {FaceForm[{RGBColor[1., 1., 1.], Opacity[1.]}], 
                FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {
                 0, 1, 0}}, {{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 0}, {0, 
                 1, 0}}}, {{{0., 401.}, {0., 378.641}, {355.277, 201.}, {400.,
                  201.}, {400., 223.359}, {44.723000000000006`, 401.}}, {{
                 400., 401.}, {400., 378.641}, {44.723000000000006`, 201.}, {
                 0., 201.}, {0., 223.363}, {355.277, 401.}}}]}, 
               {FaceForm[{RGBColor[
                0.8117650000000001, 0.07843140000000001, 0.168627], Opacity[
                1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}}, {{0,
                  2, 0}, {0, 1, 0}, {0, 1, 0}}, {{0, 2, 0}, {0, 1, 0}, {0, 1, 
                 0}}, {{0, 2, 0}, {0, 1, 0}, {0, 1, 0}}}, {{{0., 201.}, {
                 133.33200000000002`, 267.668}, {163.148, 267.668}, {29.812, 
                 201.}}, {{0., 401.}, {133.33200000000002`, 334.332}, {103.52,
                  334.332}, {0., 386.094}}, {{236.85200000000003`, 334.332}, {
                 370.188, 401.}, {400., 401.}, {266.668, 334.332}}, {{400., 
                 201.}, {266.668, 267.668}, {296.47999999999996`, 267.668}, {
                 400., 215.906}}}]}}, {
               {RGBColor[1., 1., 1.], 
                PolygonBox[{{{166.668, 401.}, {166.668, 201.}, {
                 233.33200000000002`, 201.}, {233.33200000000002`, 401.}}, {{
                 0., 334.332}, {0., 267.668}, {400., 267.668}, {400., 
                 334.332}}}]}, 
               {RGBColor[0.8117650000000001, 0.07843140000000001, 0.168627], 
                PolygonBox[{{{0., 321.}, {0., 281.}, {400., 281.}, {400., 
                 321.}}, {{180., 401.}, {180., 201.}, {220., 201.}, {220., 
                 401.}}}]}}}},
            ImageSize->{{128}, {85}},
            PlotRange->{{0, 400}, {201, 401}}]},
          {
           TemplateBox[{"\"United States\"", 
             RowBox[{"Entity", "[", 
               RowBox[{"\"Country\"", ",", "\"UnitedStates\""}], "]"}], 
             "\"Entity[\\\"Country\\\", \\\"UnitedStates\\\"]\"", 
             "\"country\""},
            "Entity"], 
           GraphicsBox[
            {Thickness[0.0010121457489878543`], 
             {FaceForm[{RGBColor[1., 1., 1.], Opacity[1.]}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}}}, {{{0., 
               0.}, {0., 520.}, {988., 520.}, {988., 0.}}}]}, 
             {FaceForm[{RGBColor[0.698039, 0.133333, 0.20392200000000002`], 
              Opacity[1.]}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}}}, {{{0., 
               520.}, {988., 520.}, {988., 480.}, {0., 480.}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}}}, {{{0., 
               440.}, {988., 440.}, {988., 400.}, {0., 400.}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}}}, {{{0., 
               360.}, {988., 360.}, {988., 320.}, {0., 320.}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}}}, {{{0., 
               280.}, {988., 280.}, {988., 240.}, {0., 240.}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}}}, {{{0., 
               200.}, {988., 200.}, {988., 160.}, {0., 160.}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}}}, {{{0., 
               120.}, {988., 120.}, {988., 80.}, {0., 80.}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}}}, {{{0., 
               40.}, {988., 40.}, {988., 0.}, {0., 0.}}}]}, 
             {FaceForm[{RGBColor[
              0.23529400000000003`, 0.231373, 0.43137300000000006`], Opacity[
              1.]}], FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}}}, {{{
               0., 520.}, {395.199, 520.}, {395.199, 240.}, {0., 240.}}}]}, 
             {FaceForm[{RGBColor[1., 1., 1.], Opacity[1.]}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{38.012, 489.262}, {
               24.387, 479.363}, {29.59, 495.379}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{32.191, 487.371}, {
               18.566, 497.27}, {35.406, 497.27}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{28.598, 492.32}, {
               33.800999999999995`, 508.33599999999996`}, {39.004, 492.32}}}],
               FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{32.191, 497.27}, {
               49.031, 497.27}, {35.406, 487.371}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{38.012, 495.379}, {
               43.215, 479.363}, {29.59, 489.262}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{103.531, 489.262}, {
               89.906, 479.363}, {95.109, 495.379}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{97.71100000000001, 
               487.371}, {84.086, 497.27}, {100.93, 497.27}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{94.117, 492.32}, {
               99.32, 508.33599999999996`}, {104.523, 492.32}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{97.71100000000001, 
               497.27}, {114.551, 497.27}, {100.93, 487.371}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{103.531, 495.379}, {
               108.73400000000001`, 479.363}, {95.109, 489.262}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{169.05100000000002`,
                489.262}, {155.42600000000002`, 479.363}, {160.629, 
               495.379}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{163.23, 487.371}, {
               149.60899999999998`, 497.27}, {166.44899999999998`, 497.27}}}],
               FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{159.637, 492.32}, {
               164.84, 508.33599999999996`}, {170.04299999999998`, 492.32}}}],
               FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{163.23, 497.27}, {
               180.07, 497.27}, {166.44899999999998`, 487.371}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{169.05100000000002`,
                495.379}, {174.254, 479.363}, {160.629, 489.262}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{234.57, 489.262}, {
               220.945, 479.363}, {226.148, 495.379}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{228.75, 487.371}, {
               215.129, 497.27}, {231.969, 497.27}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{225.156, 492.32}, {
               230.359, 508.33599999999996`}, {235.562, 492.32}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{228.75, 497.27}, {
               245.594, 497.27}, {231.969, 487.371}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{234.57, 495.379}, {
               239.77299999999997`, 479.363}, {226.148, 489.262}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{300.09, 489.262}, {
               286.465, 479.363}, {291.672, 495.379}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{294.27299999999997`,
                487.371}, {280.648, 497.27}, {297.48799999999994`, 497.27}}}],
               FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{290.676, 492.32}, {
               295.879, 508.33599999999996`}, {301.082, 492.32}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{294.27299999999997`,
                497.27}, {311.113, 497.27}, {297.48799999999994`, 487.371}}}],
               FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{300.09, 495.379}, {
               305.29299999999995`, 479.363}, {291.672, 489.262}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{365.60900000000004`,
                489.262}, {351.984, 479.363}, {357.191, 495.379}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{359.79299999999995`,
                487.371}, {346.168, 497.27}, {363.008, 497.27}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{356.195, 492.32}, {
               361.39799999999997`, 508.33599999999996`}, {366.605, 
               492.32}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{359.79299999999995`,
                497.27}, {376.633, 497.27}, {363.008, 487.371}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{365.60900000000004`,
                495.379}, {370.812, 479.363}, {357.191, 489.262}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{70.77, 461.18}, {
               57.145, 451.28099999999995`}, {62.352, 467.29699999999997`}}}],
               FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{64.953, 459.289}, {
               51.328, 469.188}, {68.16799999999999, 469.188}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{61.355, 
               464.23799999999994`}, {66.559, 480.258}, {71.766, 
               464.23799999999994`}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{64.953, 469.188}, {
               81.793, 469.188}, {68.16799999999999, 459.289}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{70.77, 
               467.29699999999997`}, {75.973, 451.28099999999995`}, {62.352, 
               461.18}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{136.289, 461.18}, {
               122.66799999999999`, 451.28099999999995`}, {127.871, 
               467.29699999999997`}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{130.47299999999998`,
                459.289}, {116.848, 469.188}, {133.68800000000002`, 
               469.188}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{126.87499999999999`,
                464.23799999999994`}, {132.078, 480.258}, {137.285, 
               464.23799999999994`}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{130.47299999999998`,
                469.188}, {147.312, 469.188}, {133.68800000000002`, 
               459.289}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{136.289, 
               467.29699999999997`}, {141.49200000000002`, 
               451.28099999999995`}, {127.871, 461.18}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{201.809, 461.18}, {
               188.18800000000002`, 451.28099999999995`}, {
               193.39100000000002`, 467.29699999999997`}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{195.99200000000002`,
                459.289}, {182.36700000000002`, 469.188}, {199.207, 
               469.188}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{192.395, 
               464.23799999999994`}, {197.602, 480.258}, {202.805, 
               464.23799999999994`}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{195.99200000000002`,
                469.188}, {212.83200000000002`, 469.188}, {199.207, 
               459.289}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{201.809, 
               467.29699999999997`}, {207.016, 451.28099999999995`}, {
               193.39100000000002`, 461.18}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{267.328, 461.18}, {
               253.707, 451.28099999999995`}, {258.90999999999997`, 
               467.29699999999997`}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{261.512, 459.289}, {
               247.88700000000003`, 469.188}, {264.727, 469.188}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{257.91799999999995`,
                464.23799999999994`}, {263.121, 480.258}, {268.324, 
               464.23799999999994`}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{261.512, 469.188}, {
               278.35200000000003`, 469.188}, {264.727, 459.289}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{267.328, 
               467.29699999999997`}, {272.53499999999997`, 
               451.28099999999995`}, {258.90999999999997`, 461.18}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{332.85200000000003`,
                461.18}, {319.227, 451.28099999999995`}, {324.42999999999995`,
                467.29699999999997`}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{327.03099999999995`,
                459.289}, {313.40599999999995`, 469.188}, {330.25, 
               469.188}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{323.43799999999993`,
                464.23799999999994`}, {328.641, 480.258}, {
               333.84400000000005`, 464.23799999999994`}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{327.03099999999995`,
                469.188}, {343.871, 469.188}, {330.25, 459.289}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{332.85200000000003`,
                467.29699999999997`}, {338.055, 451.28099999999995`}, {
               324.42999999999995`, 461.18}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{38.012, 
               433.10200000000003`}, {24.387, 423.203}, {29.59, 439.219}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{32.191, 
               431.21099999999996`}, {18.566, 441.10900000000004`}, {35.406, 
               441.10900000000004`}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{28.598, 436.16}, {
               33.800999999999995`, 452.176}, {39.004, 436.16}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{32.191, 
               441.10900000000004`}, {49.031, 441.10900000000004`}, {35.406, 
               431.21099999999996`}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{38.012, 439.219}, {
               43.215, 423.203}, {29.59, 433.10200000000003`}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{103.531, 
               433.10200000000003`}, {89.906, 423.203}, {95.109, 439.219}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{97.71100000000001, 
               431.21099999999996`}, {84.086, 441.10900000000004`}, {100.93, 
               441.10900000000004`}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{94.117, 436.16}, {
               99.32, 452.176}, {104.523, 436.16}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{97.71100000000001, 
               441.10900000000004`}, {114.551, 441.10900000000004`}, {100.93, 
               431.21099999999996`}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{103.531, 439.219}, {
               108.73400000000001`, 423.203}, {95.109, 
               433.10200000000003`}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{169.05100000000002`,
                433.10200000000003`}, {155.42600000000002`, 423.203}, {
               160.629, 439.219}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{163.23, 
               431.21099999999996`}, {149.60899999999998`, 
               441.10900000000004`}, {166.44899999999998`, 
               441.10900000000004`}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{159.637, 436.16}, {
               164.84, 452.176}, {170.04299999999998`, 436.16}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{163.23, 
               441.10900000000004`}, {180.07, 441.10900000000004`}, {
               166.44899999999998`, 431.21099999999996`}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{169.05100000000002`,
                439.219}, {174.254, 423.203}, {160.629, 
               433.10200000000003`}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{234.57, 
               433.10200000000003`}, {220.945, 423.203}, {226.148, 
               439.219}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{228.75, 
               431.21099999999996`}, {215.129, 441.10900000000004`}, {231.969,
                441.10900000000004`}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{225.156, 436.16}, {
               230.359, 452.176}, {235.562, 436.16}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{228.75, 
               441.10900000000004`}, {245.594, 441.10900000000004`}, {231.969,
                431.21099999999996`}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{234.57, 439.219}, {
               239.77299999999997`, 423.203}, {226.148, 
               433.10200000000003`}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{300.09, 
               433.10200000000003`}, {286.465, 423.203}, {291.672, 
               439.219}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{294.27299999999997`,
                431.21099999999996`}, {280.648, 441.10900000000004`}, {
               297.48799999999994`, 441.10900000000004`}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{290.676, 436.16}, {
               295.879, 452.176}, {301.082, 436.16}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{294.27299999999997`,
                441.10900000000004`}, {311.113, 441.10900000000004`}, {
               297.48799999999994`, 431.21099999999996`}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{300.09, 439.219}, {
               305.29299999999995`, 423.203}, {291.672, 
               433.10200000000003`}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{365.60900000000004`,
                433.10200000000003`}, {351.984, 423.203}, {357.191, 
               439.219}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{359.79299999999995`,
                431.21099999999996`}, {346.168, 441.10900000000004`}, {
               363.008, 441.10900000000004`}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{356.195, 436.16}, {
               361.39799999999997`, 452.176}, {366.605, 436.16}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{359.79299999999995`,
                441.10900000000004`}, {376.633, 441.10900000000004`}, {
               363.008, 431.21099999999996`}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{365.60900000000004`,
                439.219}, {370.812, 423.203}, {357.191, 
               433.10200000000003`}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{70.77, 405.02}, {
               57.145, 395.121}, {62.352, 411.141}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{64.953, 403.129}, {
               51.328, 413.027}, {68.16799999999999, 413.027}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{61.355, 408.078}, {
               66.559, 424.09799999999996`}, {71.766, 408.078}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{64.953, 413.027}, {
               81.793, 413.027}, {68.16799999999999, 403.129}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{70.77, 411.141}, {
               75.973, 395.121}, {62.352, 405.02}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{136.289, 405.02}, {
               122.66799999999999`, 395.121}, {127.871, 411.141}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{130.47299999999998`,
                403.129}, {116.848, 413.027}, {133.68800000000002`, 
               413.027}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{126.87499999999999`,
                408.078}, {132.078, 424.09799999999996`}, {137.285, 
               408.078}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{130.47299999999998`,
                413.027}, {147.312, 413.027}, {133.68800000000002`, 
               403.129}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{136.289, 411.141}, {
               141.49200000000002`, 395.121}, {127.871, 405.02}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{201.809, 405.02}, {
               188.18800000000002`, 395.121}, {193.39100000000002`, 
               411.141}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{195.99200000000002`,
                403.129}, {182.36700000000002`, 413.027}, {199.207, 
               413.027}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{192.395, 408.078}, {
               197.602, 424.09799999999996`}, {202.805, 408.078}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{195.99200000000002`,
                413.027}, {212.83200000000002`, 413.027}, {199.207, 
               403.129}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{201.809, 411.141}, {
               207.016, 395.121}, {193.39100000000002`, 405.02}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{267.328, 405.02}, {
               253.707, 395.121}, {258.90999999999997`, 411.141}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{261.512, 403.129}, {
               247.88700000000003`, 413.027}, {264.727, 413.027}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{257.91799999999995`,
                408.078}, {263.121, 424.09799999999996`}, {268.324, 
               408.078}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{261.512, 413.027}, {
               278.35200000000003`, 413.027}, {264.727, 403.129}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{267.328, 411.141}, {
               272.53499999999997`, 395.121}, {258.90999999999997`, 
               405.02}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{332.85200000000003`,
                405.02}, {319.227, 395.121}, {324.42999999999995`, 
               411.141}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{327.03099999999995`,
                403.129}, {313.40599999999995`, 413.027}, {330.25, 
               413.027}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{323.43799999999993`,
                408.078}, {328.641, 424.09799999999996`}, {
               333.84400000000005`, 408.078}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{327.03099999999995`,
                413.027}, {343.871, 413.027}, {330.25, 403.129}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{332.85200000000003`,
                411.141}, {338.055, 395.121}, {324.42999999999995`, 
               405.02}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{38.012, 376.941}, {
               24.387, 367.043}, {29.59, 383.059}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{32.191, 375.051}, {
               18.566, 384.949}, {35.406, 384.949}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{28.598, 380.}, {
               33.800999999999995`, 396.01599999999996`}, {39.004, 380.}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{32.191, 384.949}, {
               49.031, 384.949}, {35.406, 375.051}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{38.012, 383.059}, {
               43.215, 367.043}, {29.59, 376.941}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{103.531, 376.941}, {
               89.906, 367.043}, {95.109, 383.059}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{97.71100000000001, 
               375.051}, {84.086, 384.949}, {100.93, 384.949}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{94.117, 380.}, {
               99.32, 396.01599999999996`}, {104.523, 380.}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{97.71100000000001, 
               384.949}, {114.551, 384.949}, {100.93, 375.051}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{103.531, 383.059}, {
               108.73400000000001`, 367.043}, {95.109, 376.941}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{169.05100000000002`,
                376.941}, {155.42600000000002`, 367.043}, {160.629, 
               383.059}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{163.23, 375.051}, {
               149.60899999999998`, 384.949}, {166.44899999999998`, 
               384.949}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{159.637, 380.}, {
               164.84, 396.01599999999996`}, {170.04299999999998`, 380.}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{163.23, 384.949}, {
               180.07, 384.949}, {166.44899999999998`, 375.051}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{169.05100000000002`,
                383.059}, {174.254, 367.043}, {160.629, 376.941}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{234.57, 376.941}, {
               220.945, 367.043}, {226.148, 383.059}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{228.75, 375.051}, {
               215.129, 384.949}, {231.969, 384.949}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{225.156, 380.}, {
               230.359, 396.01599999999996`}, {235.562, 380.}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{228.75, 384.949}, {
               245.594, 384.949}, {231.969, 375.051}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{234.57, 383.059}, {
               239.77299999999997`, 367.043}, {226.148, 376.941}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{300.09, 376.941}, {
               286.465, 367.043}, {291.672, 383.059}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{294.27299999999997`,
                375.051}, {280.648, 384.949}, {297.48799999999994`, 
               384.949}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{290.676, 380.}, {
               295.879, 396.01599999999996`}, {301.082, 380.}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{294.27299999999997`,
                384.949}, {311.113, 384.949}, {297.48799999999994`, 
               375.051}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{300.09, 383.059}, {
               305.29299999999995`, 367.043}, {291.672, 376.941}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{365.60900000000004`,
                376.941}, {351.984, 367.043}, {357.191, 383.059}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{359.79299999999995`,
                375.051}, {346.168, 384.949}, {363.008, 384.949}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{356.195, 380.}, {
               361.39799999999997`, 396.01599999999996`}, {366.605, 380.}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{359.79299999999995`,
                384.949}, {376.633, 384.949}, {363.008, 375.051}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{365.60900000000004`,
                383.059}, {370.812, 367.043}, {357.191, 376.941}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{70.77, 
               348.85900000000004`}, {57.145, 338.96099999999996`}, {62.352, 
               354.97999999999996`}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{64.953, 
               346.97299999999996`}, {51.328, 356.871}, {68.16799999999999, 
               356.871}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{61.355, 
               351.92199999999997`}, {66.559, 367.93799999999993`}, {71.766, 
               351.92199999999997`}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{64.953, 356.871}, {
               81.793, 356.871}, {68.16799999999999, 346.97299999999996`}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{70.77, 
               354.97999999999996`}, {75.973, 338.96099999999996`}, {62.352, 
               348.85900000000004`}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{136.289, 
               348.85900000000004`}, {122.66799999999999`, 
               338.96099999999996`}, {127.871, 354.97999999999996`}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{130.47299999999998`,
                346.97299999999996`}, {116.848, 356.871}, {
               133.68800000000002`, 356.871}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{126.87499999999999`,
                351.92199999999997`}, {132.078, 367.93799999999993`}, {
               137.285, 351.92199999999997`}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{130.47299999999998`,
                356.871}, {147.312, 356.871}, {133.68800000000002`, 
               346.97299999999996`}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{136.289, 
               354.97999999999996`}, {141.49200000000002`, 
               338.96099999999996`}, {127.871, 348.85900000000004`}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{201.809, 
               348.85900000000004`}, {188.18800000000002`, 
               338.96099999999996`}, {193.39100000000002`, 
               354.97999999999996`}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{195.99200000000002`,
                346.97299999999996`}, {182.36700000000002`, 356.871}, {
               199.207, 356.871}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{192.395, 
               351.92199999999997`}, {197.602, 367.93799999999993`}, {202.805,
                351.92199999999997`}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{195.99200000000002`,
                356.871}, {212.83200000000002`, 356.871}, {199.207, 
               346.97299999999996`}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{201.809, 
               354.97999999999996`}, {207.016, 338.96099999999996`}, {
               193.39100000000002`, 348.85900000000004`}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{267.328, 
               348.85900000000004`}, {253.707, 338.96099999999996`}, {
               258.90999999999997`, 354.97999999999996`}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{261.512, 
               346.97299999999996`}, {247.88700000000003`, 356.871}, {264.727,
                356.871}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{257.91799999999995`,
                351.92199999999997`}, {263.121, 367.93799999999993`}, {
               268.324, 351.92199999999997`}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{261.512, 356.871}, {
               278.35200000000003`, 356.871}, {264.727, 
               346.97299999999996`}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{267.328, 
               354.97999999999996`}, {272.53499999999997`, 
               338.96099999999996`}, {258.90999999999997`, 
               348.85900000000004`}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{332.85200000000003`,
                348.85900000000004`}, {319.227, 338.96099999999996`}, {
               324.42999999999995`, 354.97999999999996`}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{327.03099999999995`,
                346.97299999999996`}, {313.40599999999995`, 356.871}, {330.25,
                356.871}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{323.43799999999993`,
                351.92199999999997`}, {328.641, 367.93799999999993`}, {
               333.84400000000005`, 351.92199999999997`}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{327.03099999999995`,
                356.871}, {343.871, 356.871}, {330.25, 
               346.97299999999996`}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{332.85200000000003`,
                354.97999999999996`}, {338.055, 338.96099999999996`}, {
               324.42999999999995`, 348.85900000000004`}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{38.012, 
               320.78099999999995`}, {24.387, 310.883}, {29.59, 
               326.89799999999997`}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{32.191, 
               318.89099999999996`}, {18.566, 328.789}, {35.406, 328.789}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{28.598, 
               323.84000000000003`}, {33.800999999999995`, 339.855}, {39.004, 
               323.84000000000003`}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{32.191, 328.789}, {
               49.031, 328.789}, {35.406, 318.89099999999996`}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{38.012, 
               326.89799999999997`}, {43.215, 310.883}, {29.59, 
               320.78099999999995`}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{103.531, 
               320.78099999999995`}, {89.906, 310.883}, {95.109, 
               326.89799999999997`}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{97.71100000000001, 
               318.89099999999996`}, {84.086, 328.789}, {100.93, 328.789}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{94.117, 
               323.84000000000003`}, {99.32, 339.855}, {104.523, 
               323.84000000000003`}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{97.71100000000001, 
               328.789}, {114.551, 328.789}, {100.93, 318.89099999999996`}}}],
               FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{103.531, 
               326.89799999999997`}, {108.73400000000001`, 310.883}, {95.109, 
               320.78099999999995`}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{169.05100000000002`,
                320.78099999999995`}, {155.42600000000002`, 310.883}, {
               160.629, 326.89799999999997`}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{163.23, 
               318.89099999999996`}, {149.60899999999998`, 328.789}, {
               166.44899999999998`, 328.789}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{159.637, 
               323.84000000000003`}, {164.84, 339.855}, {170.04299999999998`, 
               323.84000000000003`}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{163.23, 328.789}, {
               180.07, 328.789}, {166.44899999999998`, 
               318.89099999999996`}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{169.05100000000002`,
                326.89799999999997`}, {174.254, 310.883}, {160.629, 
               320.78099999999995`}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{234.57, 
               320.78099999999995`}, {220.945, 310.883}, {226.148, 
               326.89799999999997`}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{228.75, 
               318.89099999999996`}, {215.129, 328.789}, {231.969, 
               328.789}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{225.156, 
               323.84000000000003`}, {230.359, 339.855}, {235.562, 
               323.84000000000003`}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{228.75, 328.789}, {
               245.594, 328.789}, {231.969, 318.89099999999996`}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{234.57, 
               326.89799999999997`}, {239.77299999999997`, 310.883}, {226.148,
                320.78099999999995`}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{300.09, 
               320.78099999999995`}, {286.465, 310.883}, {291.672, 
               326.89799999999997`}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{294.27299999999997`,
                318.89099999999996`}, {280.648, 328.789}, {
               297.48799999999994`, 328.789}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{290.676, 
               323.84000000000003`}, {295.879, 339.855}, {301.082, 
               323.84000000000003`}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{294.27299999999997`,
                328.789}, {311.113, 328.789}, {297.48799999999994`, 
               318.89099999999996`}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{300.09, 
               326.89799999999997`}, {305.29299999999995`, 310.883}, {291.672,
                320.78099999999995`}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{365.60900000000004`,
                320.78099999999995`}, {351.984, 310.883}, {357.191, 
               326.89799999999997`}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{359.79299999999995`,
                318.89099999999996`}, {346.168, 328.789}, {363.008, 
               328.789}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{356.195, 
               323.84000000000003`}, {361.39799999999997`, 339.855}, {366.605,
                323.84000000000003`}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{359.79299999999995`,
                328.789}, {376.633, 328.789}, {363.008, 
               318.89099999999996`}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{365.60900000000004`,
                326.89799999999997`}, {370.812, 310.883}, {357.191, 
               320.78099999999995`}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{70.77, 292.703}, {
               57.145, 282.805}, {62.352, 298.82}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{64.953, 290.812}, {
               51.328, 300.71099999999996`}, {68.16799999999999, 
               300.71099999999996`}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{61.355, 295.762}, {
               66.559, 311.777}, {71.766, 295.762}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{64.953, 
               300.71099999999996`}, {81.793, 300.71099999999996`}, {
               68.16799999999999, 290.812}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{70.77, 298.82}, {
               75.973, 282.805}, {62.352, 292.703}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{136.289, 292.703}, {
               122.66799999999999`, 282.805}, {127.871, 298.82}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{130.47299999999998`,
                290.812}, {116.848, 300.71099999999996`}, {
               133.68800000000002`, 300.71099999999996`}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{126.87499999999999`,
                295.762}, {132.078, 311.777}, {137.285, 295.762}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{130.47299999999998`,
                300.71099999999996`}, {147.312, 300.71099999999996`}, {
               133.68800000000002`, 290.812}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{136.289, 298.82}, {
               141.49200000000002`, 282.805}, {127.871, 292.703}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{201.809, 292.703}, {
               188.18800000000002`, 282.805}, {193.39100000000002`, 
               298.82}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{195.99200000000002`,
                290.812}, {182.36700000000002`, 300.71099999999996`}, {
               199.207, 300.71099999999996`}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{192.395, 295.762}, {
               197.602, 311.777}, {202.805, 295.762}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{195.99200000000002`,
                300.71099999999996`}, {212.83200000000002`, 
               300.71099999999996`}, {199.207, 290.812}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{201.809, 298.82}, {
               207.016, 282.805}, {193.39100000000002`, 292.703}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{267.328, 292.703}, {
               253.707, 282.805}, {258.90999999999997`, 298.82}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{261.512, 290.812}, {
               247.88700000000003`, 300.71099999999996`}, {264.727, 
               300.71099999999996`}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{257.91799999999995`,
                295.762}, {263.121, 311.777}, {268.324, 295.762}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{261.512, 
               300.71099999999996`}, {278.35200000000003`, 
               300.71099999999996`}, {264.727, 290.812}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{267.328, 298.82}, {
               272.53499999999997`, 282.805}, {258.90999999999997`, 
               292.703}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{332.85200000000003`,
                292.703}, {319.227, 282.805}, {324.42999999999995`, 
               298.82}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{327.03099999999995`,
                290.812}, {313.40599999999995`, 300.71099999999996`}, {330.25,
                300.71099999999996`}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{323.43799999999993`,
                295.762}, {328.641, 311.777}, {333.84400000000005`, 
               295.762}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{327.03099999999995`,
                300.71099999999996`}, {343.871, 300.71099999999996`}, {330.25,
                290.812}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{332.85200000000003`,
                298.82}, {338.055, 282.805}, {324.42999999999995`, 
               292.703}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{38.012, 264.621}, {
               24.387, 254.72299999999998`}, {29.59, 270.73799999999994`}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{32.191, 
               262.72999999999996`}, {18.566, 272.629}, {35.406, 272.629}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{28.598, 267.68}, {
               33.800999999999995`, 283.695}, {39.004, 267.68}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{32.191, 272.629}, {
               49.031, 272.629}, {35.406, 262.72999999999996`}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{38.012, 
               270.73799999999994`}, {43.215, 254.72299999999998`}, {29.59, 
               264.621}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{103.531, 264.621}, {
               89.906, 254.72299999999998`}, {95.109, 270.73799999999994`}}}],
               FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{97.71100000000001, 
               262.72999999999996`}, {84.086, 272.629}, {100.93, 272.629}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{94.117, 267.68}, {
               99.32, 283.695}, {104.523, 267.68}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{97.71100000000001, 
               272.629}, {114.551, 272.629}, {100.93, 262.72999999999996`}}}],
               FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{103.531, 
               270.73799999999994`}, {108.73400000000001`, 
               254.72299999999998`}, {95.109, 264.621}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{169.05100000000002`,
                264.621}, {155.42600000000002`, 254.72299999999998`}, {
               160.629, 270.73799999999994`}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{163.23, 
               262.72999999999996`}, {149.60899999999998`, 272.629}, {
               166.44899999999998`, 272.629}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{159.637, 267.68}, {
               164.84, 283.695}, {170.04299999999998`, 267.68}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{163.23, 272.629}, {
               180.07, 272.629}, {166.44899999999998`, 
               262.72999999999996`}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{169.05100000000002`,
                270.73799999999994`}, {174.254, 254.72299999999998`}, {
               160.629, 264.621}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{234.57, 264.621}, {
               220.945, 254.72299999999998`}, {226.148, 
               270.73799999999994`}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{228.75, 
               262.72999999999996`}, {215.129, 272.629}, {231.969, 
               272.629}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{225.156, 267.68}, {
               230.359, 283.695}, {235.562, 267.68}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{228.75, 272.629}, {
               245.594, 272.629}, {231.969, 262.72999999999996`}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{234.57, 
               270.73799999999994`}, {239.77299999999997`, 
               254.72299999999998`}, {226.148, 264.621}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{300.09, 264.621}, {
               286.465, 254.72299999999998`}, {291.672, 
               270.73799999999994`}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{294.27299999999997`,
                262.72999999999996`}, {280.648, 272.629}, {
               297.48799999999994`, 272.629}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{290.676, 267.68}, {
               295.879, 283.695}, {301.082, 267.68}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{294.27299999999997`,
                272.629}, {311.113, 272.629}, {297.48799999999994`, 
               262.72999999999996`}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{300.09, 
               270.73799999999994`}, {305.29299999999995`, 
               254.72299999999998`}, {291.672, 264.621}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{365.60900000000004`,
                264.621}, {351.984, 254.72299999999998`}, {357.191, 
               270.73799999999994`}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{359.79299999999995`,
                262.72999999999996`}, {346.168, 272.629}, {363.008, 
               272.629}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{356.195, 267.68}, {
               361.39799999999997`, 283.695}, {366.605, 267.68}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{359.79299999999995`,
                272.629}, {376.633, 272.629}, {363.008, 
               262.72999999999996`}}}], 
              FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{365.60900000000004`,
                270.73799999999994`}, {370.812, 254.72299999999998`}, {
               357.191, 264.621}}}]}},
            AspectRatio->Automatic,
            ImageSize->{{128}, {85}},
            PlotRange->{{0., 988.}, {0., 520.}}]}
         },
         AutoDelete->False,
         GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}},
         GridBoxItemSize->{
          "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
        "Grid"]], "ExerciseOutput",ExpressionUUID->
       "c2068a80-b944-4fd7-b77e-3d929b73322d"],
      Apply[TextCell, 
       Cell[
        BoxData[
         TagBox[
          GridBox[{{
             TemplateBox[{"\"France\"", 
               RowBox[{"Entity", "[", 
                 RowBox[{"\"Country\"", ",", "\"France\""}], "]"}], 
               "\"Entity[\\\"Country\\\", \\\"France\\\"]\"", "\"country\""}, 
              "Entity"], 
             GraphicsBox[{{{
                 Thickness[0.001388888888888889], {{{
                    FaceForm[{
                    RGBColor[0.9294119999999999, 0.160784, 0.223529], 
                    Opacity[1.]}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}}}, {{{0.,
                     0.}, {0., 480.}, {720., 480.}, {720., 0.}}}]}}}, {{{
                    FaceForm[{
                    RGBColor[1., 1., 1.], 
                    Opacity[1.]}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}}}, {{{0.,
                     480.}, {480., 480.}, {480., 0.}, {0., 0.}}}]}}}, {{{
                    FaceForm[{
                    RGBColor[0., 0.13725500000000002`, 0.5843139999999999], 
                    Opacity[1.]}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}}}, {{{0.,
                     480.}, {240., 480.}, {240., 0.}, {0., 0.}}}]}}}}}}, 
              AspectRatio -> Automatic, ImageSize -> {{128}, {85}}, 
              PlotRange -> {{0., 720.}, {0., 480.}}, ImageCache -> 
              GraphicsData[
               "CompressedBitmap", 
                "eJztzb1KA1EQBeC5rE8gWIgWqxYbCy20iRZipZWlFhbKJogJ+McaUDAIWwS0\
\nEEVIL6kFu2AldqKSNxC18Td3u60ky3F2QcFn8Fy4w3Bm+GbOr5RW1v1Kuei7\n\
s4G/VSoXt92ZzUAjx4hIqH/BlbSHtj/FQfqmFy8g/afiQYbqmknvCVar1+lI\n\
cll1kLy+IxqdQpTL6140PGFgB8cNvm5bKtGhQ4cOHTp06NChQ4cOHTp06NCh\n\
Q4cOHTr/x5mcP4f0HKeOaup0H6Gwe/XXeXmD9fKwA2O6lxHtvhF1bu5/ncP6\n\
HZY3mjovBJeaLa01cdZoAdZqlny0pQvJp0Xn4Qnx/gHivZqHuFoziHdCg87j\n\
s0iY3RMx3340DGk="]]}, {
             TemplateBox[{"\"Germany\"", 
               RowBox[{"Entity", "[", 
                 RowBox[{"\"Country\"", ",", "\"Germany\""}], "]"}], 
               "\"Entity[\\\"Country\\\", \\\"Germany\\\"]\"", "\"country\""},
               "Entity"], 
             GraphicsBox[{{{
                 Thickness[0.00125], {{{
                    Thickness[0.00125], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}}}, {{{0.,
                     0.}, {0., 480.}, {800., 480.}, {800., 0.}}}]}}}, {{{
                    FaceForm[{
                    RGBColor[0.8666670000000001, 0., 0.], 
                    Opacity[1.]}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}}}, {{{0.,
                     320.}, {800., 320.}, {800., 0.}, {0., 0.}}}]}}}, {{{
                    FaceForm[{
                    RGBColor[1., 0.8078430000000001, 0.], 
                    Opacity[1.]}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}}}, {{{0.,
                     160.}, {800., 160.}, {800., 0.}, {0., 0.}}}]}}}}}}, 
              AspectRatio -> Automatic, ImageSize -> {{128}, {85}}, 
              PlotRange -> {{0., 800.}, {0., 480.}}]}, {
             TemplateBox[{"\"Japan\"", 
               RowBox[{"Entity", "[", 
                 RowBox[{"\"Country\"", ",", "\"Japan\""}], "]"}], 
               "\"Entity[\\\"Country\\\", \\\"Japan\\\"]\"", "\"country\""}, 
              "Entity"], 
             GraphicsBox[{{{
                 Thickness[0.001388888888888889], {{{
                    FaceForm[{
                    RGBColor[1., 1., 1.], 
                    Opacity[1.]}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}}}, {{{0.,
                     0.}, {0., 480.}, {720., 480.}, {720., 0.}}}]}}}, {{{
                    FaceForm[{
                    RGBColor[0.737255, 0., 0.17647100000000002`], 
                    Opacity[1.]}], 
                    
                    FilledCurveBox[{{{1, 4, 3}, {1, 3, 3}, {1, 3, 3}, {1, 3, 
                    3}}}, {{{504., 240.}, {504., 160.47299999999998`}, {
                    439.527, 96.}, {360., 96.}, {280.47299999999996`, 96.}, {
                    216., 160.47299999999998`}, {216., 240.}, {216., 
                    319.527}, {280.47299999999996`, 384.}, {360., 384.}, {
                    439.527, 384.}, {504., 319.527}, {504., 240.}}}]}}}}}}, 
              AspectRatio -> Automatic, ImageSize -> {{128}, {85}}, 
              PlotRange -> {{0., 720.}, {0., 480.}}]}, {
             TemplateBox[{"\"United Kingdom\"", 
               RowBox[{"Entity", "[", 
                 RowBox[{"\"Country\"", ",", "\"UnitedKingdom\""}], "]"}], 
               "\"Entity[\\\"Country\\\", \\\"UnitedKingdom\\\"]\"", 
               "\"country\""}, "Entity"], 
             GraphicsBox[{{{{
                  RGBColor[0., 0.141176, 0.49019599999999997`], 
                  
                  PolygonBox[{{0, 201}, {400, 201}, {400, 401}, {0, 
                   401}}]}}}, {{{{
                   Thickness[0.00125], {{{
                    FaceForm[{
                    RGBColor[1., 1., 1.], 
                    Opacity[1.]}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
                    0}, {0, 1, 0}}, {{0, 2, 0}, {0, 1, 0}, {0, 1, 0}, {0, 1, 
                    0}, {0, 1, 0}}}, {{{0., 401.}, {0., 378.641}, {355.277, 
                    201.}, {400., 201.}, {400., 223.359}, {
                    44.723000000000006`, 401.}}, {{400., 401.}, {400., 
                    378.641}, {44.723000000000006`, 201.}, {0., 201.}, {0., 
                    223.363}, {355.277, 401.}}}]}}}, {{{
                    FaceForm[{
                    RGBColor[
                    0.8117650000000001, 0.07843140000000001, 0.168627], 
                    Opacity[1.]}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}}, {{0, 2,
                     0}, {0, 1, 0}, {0, 1, 0}}, {{0, 2, 0}, {0, 1, 0}, {0, 1, 
                    0}}, {{0, 2, 0}, {0, 1, 0}, {0, 1, 0}}}, {{{0., 201.}, {
                    133.33200000000002`, 267.668}, {163.148, 267.668}, {
                    29.812, 201.}}, {{0., 401.}, {133.33200000000002`, 
                    334.332}, {103.52, 334.332}, {0., 386.094}}, {{
                    236.85200000000003`, 334.332}, {370.188, 401.}, {400., 
                    401.}, {266.668, 334.332}}, {{400., 201.}, {266.668, 
                    267.668}, {296.47999999999996`, 267.668}, {400., 
                    215.906}}}]}}}}}}, {{{{
                    RGBColor[1., 1., 1.], 
                    
                    PolygonBox[{{{166.668, 401.}, {166.668, 201.}, {
                    233.33200000000002`, 201.}, {233.33200000000002`, 
                    401.}}, {{0., 334.332}, {0., 267.668}, {400., 267.668}, {
                    400., 334.332}}}]}}}, {{{
                    RGBColor[
                    0.8117650000000001, 0.07843140000000001, 0.168627], 
                    PolygonBox[{{{0., 321.}, {0., 281.}, {400., 281.}, {400., 
                    321.}}, {{180., 401.}, {180., 201.}, {220., 201.}, {220., 
                    401.}}}]}}}}}}, ImageSize -> {{128}, {85}}, 
              PlotRange -> {{0, 400}, {201, 401}}]}, {
             TemplateBox[{"\"United States\"", 
               RowBox[{"Entity", "[", 
                 RowBox[{"\"Country\"", ",", "\"UnitedStates\""}], "]"}], 
               "\"Entity[\\\"Country\\\", \\\"UnitedStates\\\"]\"", 
               "\"country\""}, "Entity"], 
             GraphicsBox[{{{
                 Thickness[0.0010121457489878543`], {{{
                    FaceForm[{
                    RGBColor[1., 1., 1.], 
                    Opacity[1.]}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}}}, {{{0.,
                     0.}, {0., 520.}, {988., 520.}, {988., 0.}}}]}}}, {{{
                    FaceForm[{
                    RGBColor[0.698039, 0.133333, 0.20392200000000002`], 
                    Opacity[1.]}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}}}, {{{0.,
                     520.}, {988., 520.}, {988., 480.}, {0., 480.}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}}}, {{{0.,
                     440.}, {988., 440.}, {988., 400.}, {0., 400.}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}}}, {{{0.,
                     360.}, {988., 360.}, {988., 320.}, {0., 320.}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}}}, {{{0.,
                     280.}, {988., 280.}, {988., 240.}, {0., 240.}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}}}, {{{0.,
                     200.}, {988., 200.}, {988., 160.}, {0., 160.}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}}}, {{{0.,
                     120.}, {988., 120.}, {988., 80.}, {0., 80.}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}}}, {{{0.,
                     40.}, {988., 40.}, {988., 0.}, {0., 0.}}}]}}}, {{{
                    FaceForm[{
                    RGBColor[
                    0.23529400000000003`, 0.231373, 0.43137300000000006`], 
                    Opacity[1.]}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}, {0, 1, 0}}}, {{{0.,
                     520.}, {395.199, 520.}, {395.199, 240.}, {0., 
                    240.}}}]}}}, {{{
                    FaceForm[{
                    RGBColor[1., 1., 1.], 
                    Opacity[1.]}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{38.012, 
                    489.262}, {24.387, 479.363}, {29.59, 495.379}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{32.191, 
                    487.371}, {18.566, 497.27}, {35.406, 497.27}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{28.598, 
                    492.32}, {33.800999999999995`, 508.33599999999996`}, {
                    39.004, 492.32}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{32.191, 
                    497.27}, {49.031, 497.27}, {35.406, 487.371}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{38.012, 
                    495.379}, {43.215, 479.363}, {29.59, 489.262}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{103.531, 
                    489.262}, {89.906, 479.363}, {95.109, 495.379}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{
                    97.71100000000001, 487.371}, {84.086, 497.27}, {100.93, 
                    497.27}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{94.117, 
                    492.32}, {99.32, 508.33599999999996`}, {104.523, 
                    492.32}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{
                    97.71100000000001, 497.27}, {114.551, 497.27}, {100.93, 
                    487.371}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{103.531, 
                    495.379}, {108.73400000000001`, 479.363}, {95.109, 
                    489.262}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{
                    169.05100000000002`, 489.262}, {155.42600000000002`, 
                    479.363}, {160.629, 495.379}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{163.23, 
                    487.371}, {149.60899999999998`, 497.27}, {
                    166.44899999999998`, 497.27}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{159.637, 
                    492.32}, {164.84, 508.33599999999996`}, {
                    170.04299999999998`, 492.32}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{163.23, 
                    497.27}, {180.07, 497.27}, {166.44899999999998`, 
                    487.371}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{
                    169.05100000000002`, 495.379}, {174.254, 479.363}, {
                    160.629, 489.262}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{234.57, 
                    489.262}, {220.945, 479.363}, {226.148, 495.379}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{228.75, 
                    487.371}, {215.129, 497.27}, {231.969, 497.27}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{225.156, 
                    492.32}, {230.359, 508.33599999999996`}, {235.562, 
                    492.32}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{228.75, 
                    497.27}, {245.594, 497.27}, {231.969, 487.371}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{234.57, 
                    495.379}, {239.77299999999997`, 479.363}, {226.148, 
                    489.262}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{300.09, 
                    489.262}, {286.465, 479.363}, {291.672, 495.379}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{
                    294.27299999999997`, 487.371}, {280.648, 497.27}, {
                    297.48799999999994`, 497.27}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{290.676, 
                    492.32}, {295.879, 508.33599999999996`}, {301.082, 
                    492.32}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{
                    294.27299999999997`, 497.27}, {311.113, 497.27}, {
                    297.48799999999994`, 487.371}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{300.09, 
                    495.379}, {305.29299999999995`, 479.363}, {291.672, 
                    489.262}}}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{
                    365.60900000000004`, 489.262}, {351.984, 479.363}, {
                    357.191, 495.379}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{
                    359.79299999999995`, 487.371}, {346.168, 497.27}, {
                    363.008, 497.27}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{356.195, 
                    492.32}, {361.39799999999997`, 508.33599999999996`}, {
                    366.605, 492.32}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{
                    359.79299999999995`, 497.27}, {376.633, 497.27}, {363.008,
                     487.371}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{
                    365.60900000000004`, 495.379}, {370.812, 479.363}, {
                    357.191, 489.262}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{70.77, 
                    461.18}, {57.145, 451.28099999999995`}, {62.352, 
                    467.29699999999997`}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{64.953, 
                    459.289}, {51.328, 469.188}, {68.16799999999999, 
                    469.188}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{61.355, 
                    464.23799999999994`}, {66.559, 480.258}, {71.766, 
                    464.23799999999994`}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{64.953, 
                    469.188}, {81.793, 469.188}, {68.16799999999999, 
                    459.289}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{70.77, 
                    467.29699999999997`}, {75.973, 451.28099999999995`}, {
                    62.352, 461.18}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{136.289, 
                    461.18}, {122.66799999999999`, 451.28099999999995`}, {
                    127.871, 467.29699999999997`}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{
                    130.47299999999998`, 459.289}, {116.848, 469.188}, {
                    133.68800000000002`, 469.188}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{
                    126.87499999999999`, 464.23799999999994`}, {132.078, 
                    480.258}, {137.285, 464.23799999999994`}}}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{
                    130.47299999999998`, 469.188}, {147.312, 469.188}, {
                    133.68800000000002`, 459.289}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{136.289, 
                    467.29699999999997`}, {141.49200000000002`, 
                    451.28099999999995`}, {127.871, 461.18}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{201.809, 
                    461.18}, {188.18800000000002`, 451.28099999999995`}, {
                    193.39100000000002`, 467.29699999999997`}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{
                    195.99200000000002`, 459.289}, {182.36700000000002`, 
                    469.188}, {199.207, 469.188}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{192.395, 
                    464.23799999999994`}, {197.602, 480.258}, {202.805, 
                    464.23799999999994`}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{
                    195.99200000000002`, 469.188}, {212.83200000000002`, 
                    469.188}, {199.207, 459.289}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{201.809, 
                    467.29699999999997`}, {207.016, 451.28099999999995`}, {
                    193.39100000000002`, 461.18}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{267.328, 
                    461.18}, {253.707, 451.28099999999995`}, {
                    258.90999999999997`, 467.29699999999997`}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{261.512, 
                    459.289}, {247.88700000000003`, 469.188}, {264.727, 
                    469.188}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{
                    257.91799999999995`, 464.23799999999994`}, {263.121, 
                    480.258}, {268.324, 464.23799999999994`}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{261.512, 
                    469.188}, {278.35200000000003`, 469.188}, {264.727, 
                    459.289}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{267.328, 
                    467.29699999999997`}, {272.53499999999997`, 
                    451.28099999999995`}, {258.90999999999997`, 461.18}}}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{
                    332.85200000000003`, 461.18}, {319.227, 
                    451.28099999999995`}, {324.42999999999995`, 
                    467.29699999999997`}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{
                    327.03099999999995`, 459.289}, {313.40599999999995`, 
                    469.188}, {330.25, 469.188}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{
                    323.43799999999993`, 464.23799999999994`}, {328.641, 
                    480.258}, {333.84400000000005`, 464.23799999999994`}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{
                    327.03099999999995`, 469.188}, {343.871, 469.188}, {
                    330.25, 459.289}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{
                    332.85200000000003`, 467.29699999999997`}, {338.055, 
                    451.28099999999995`}, {324.42999999999995`, 461.18}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{38.012, 
                    433.10200000000003`}, {24.387, 423.203}, {29.59, 
                    439.219}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{32.191, 
                    431.21099999999996`}, {18.566, 441.10900000000004`}, {
                    35.406, 441.10900000000004`}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{28.598, 
                    436.16}, {33.800999999999995`, 452.176}, {39.004, 
                    436.16}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{32.191, 
                    441.10900000000004`}, {49.031, 441.10900000000004`}, {
                    35.406, 431.21099999999996`}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{38.012, 
                    439.219}, {43.215, 423.203}, {29.59, 
                    433.10200000000003`}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{103.531, 
                    433.10200000000003`}, {89.906, 423.203}, {95.109, 
                    439.219}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{
                    97.71100000000001, 431.21099999999996`}, {84.086, 
                    441.10900000000004`}, {100.93, 441.10900000000004`}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{94.117, 
                    436.16}, {99.32, 452.176}, {104.523, 436.16}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{
                    97.71100000000001, 441.10900000000004`}, {114.551, 
                    441.10900000000004`}, {100.93, 431.21099999999996`}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{103.531, 
                    439.219}, {108.73400000000001`, 423.203}, {95.109, 
                    433.10200000000003`}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{
                    169.05100000000002`, 433.10200000000003`}, {
                    155.42600000000002`, 423.203}, {160.629, 439.219}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{163.23, 
                    431.21099999999996`}, {149.60899999999998`, 
                    441.10900000000004`}, {166.44899999999998`, 
                    441.10900000000004`}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{159.637, 
                    436.16}, {164.84, 452.176}, {170.04299999999998`, 
                    436.16}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{163.23, 
                    441.10900000000004`}, {180.07, 441.10900000000004`}, {
                    166.44899999999998`, 431.21099999999996`}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{
                    169.05100000000002`, 439.219}, {174.254, 423.203}, {
                    160.629, 433.10200000000003`}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{234.57, 
                    433.10200000000003`}, {220.945, 423.203}, {226.148, 
                    439.219}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{228.75, 
                    431.21099999999996`}, {215.129, 441.10900000000004`}, {
                    231.969, 441.10900000000004`}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{225.156, 
                    436.16}, {230.359, 452.176}, {235.562, 436.16}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{228.75, 
                    441.10900000000004`}, {245.594, 441.10900000000004`}, {
                    231.969, 431.21099999999996`}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{234.57, 
                    439.219}, {239.77299999999997`, 423.203}, {226.148, 
                    433.10200000000003`}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{300.09, 
                    433.10200000000003`}, {286.465, 423.203}, {291.672, 
                    439.219}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{
                    294.27299999999997`, 431.21099999999996`}, {280.648, 
                    441.10900000000004`}, {297.48799999999994`, 
                    441.10900000000004`}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{290.676, 
                    436.16}, {295.879, 452.176}, {301.082, 436.16}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{
                    294.27299999999997`, 441.10900000000004`}, {311.113, 
                    441.10900000000004`}, {297.48799999999994`, 
                    431.21099999999996`}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{300.09, 
                    439.219}, {305.29299999999995`, 423.203}, {291.672, 
                    433.10200000000003`}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{
                    365.60900000000004`, 433.10200000000003`}, {351.984, 
                    423.203}, {357.191, 439.219}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{
                    359.79299999999995`, 431.21099999999996`}, {346.168, 
                    441.10900000000004`}, {363.008, 441.10900000000004`}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{356.195, 
                    436.16}, {361.39799999999997`, 452.176}, {366.605, 
                    436.16}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{
                    359.79299999999995`, 441.10900000000004`}, {376.633, 
                    441.10900000000004`}, {363.008, 431.21099999999996`}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{
                    365.60900000000004`, 439.219}, {370.812, 423.203}, {
                    357.191, 433.10200000000003`}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{70.77, 
                    405.02}, {57.145, 395.121}, {62.352, 411.141}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{64.953, 
                    403.129}, {51.328, 413.027}, {68.16799999999999, 
                    413.027}}}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{61.355, 
                    408.078}, {66.559, 424.09799999999996`}, {71.766, 
                    408.078}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{64.953, 
                    413.027}, {81.793, 413.027}, {68.16799999999999, 
                    403.129}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{70.77, 
                    411.141}, {75.973, 395.121}, {62.352, 405.02}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{136.289, 
                    405.02}, {122.66799999999999`, 395.121}, {127.871, 
                    411.141}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{
                    130.47299999999998`, 403.129}, {116.848, 413.027}, {
                    133.68800000000002`, 413.027}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{
                    126.87499999999999`, 408.078}, {132.078, 
                    424.09799999999996`}, {137.285, 408.078}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{
                    130.47299999999998`, 413.027}, {147.312, 413.027}, {
                    133.68800000000002`, 403.129}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{136.289, 
                    411.141}, {141.49200000000002`, 395.121}, {127.871, 
                    405.02}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{201.809, 
                    405.02}, {188.18800000000002`, 395.121}, {
                    193.39100000000002`, 411.141}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{
                    195.99200000000002`, 403.129}, {182.36700000000002`, 
                    413.027}, {199.207, 413.027}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{192.395, 
                    408.078}, {197.602, 424.09799999999996`}, {202.805, 
                    408.078}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{
                    195.99200000000002`, 413.027}, {212.83200000000002`, 
                    413.027}, {199.207, 403.129}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{201.809, 
                    411.141}, {207.016, 395.121}, {193.39100000000002`, 
                    405.02}}}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{267.328, 
                    405.02}, {253.707, 395.121}, {258.90999999999997`, 
                    411.141}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{261.512, 
                    403.129}, {247.88700000000003`, 413.027}, {264.727, 
                    413.027}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{
                    257.91799999999995`, 408.078}, {263.121, 
                    424.09799999999996`}, {268.324, 408.078}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{261.512, 
                    413.027}, {278.35200000000003`, 413.027}, {264.727, 
                    403.129}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{267.328, 
                    411.141}, {272.53499999999997`, 395.121}, {
                    258.90999999999997`, 405.02}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{
                    332.85200000000003`, 405.02}, {319.227, 395.121}, {
                    324.42999999999995`, 411.141}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{
                    327.03099999999995`, 403.129}, {313.40599999999995`, 
                    413.027}, {330.25, 413.027}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{
                    323.43799999999993`, 408.078}, {328.641, 
                    424.09799999999996`}, {333.84400000000005`, 408.078}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{
                    327.03099999999995`, 413.027}, {343.871, 413.027}, {
                    330.25, 403.129}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{
                    332.85200000000003`, 411.141}, {338.055, 395.121}, {
                    324.42999999999995`, 405.02}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{38.012, 
                    376.941}, {24.387, 367.043}, {29.59, 383.059}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{32.191, 
                    375.051}, {18.566, 384.949}, {35.406, 384.949}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{28.598, 
                    380.}, {33.800999999999995`, 396.01599999999996`}, {
                    39.004, 380.}}}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{32.191, 
                    384.949}, {49.031, 384.949}, {35.406, 375.051}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{38.012, 
                    383.059}, {43.215, 367.043}, {29.59, 376.941}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{103.531, 
                    376.941}, {89.906, 367.043}, {95.109, 383.059}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{
                    97.71100000000001, 375.051}, {84.086, 384.949}, {100.93, 
                    384.949}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{94.117, 
                    380.}, {99.32, 396.01599999999996`}, {104.523, 380.}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{
                    97.71100000000001, 384.949}, {114.551, 384.949}, {100.93, 
                    375.051}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{103.531, 
                    383.059}, {108.73400000000001`, 367.043}, {95.109, 
                    376.941}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{
                    169.05100000000002`, 376.941}, {155.42600000000002`, 
                    367.043}, {160.629, 383.059}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{163.23, 
                    375.051}, {149.60899999999998`, 384.949}, {
                    166.44899999999998`, 384.949}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{159.637, 
                    380.}, {164.84, 396.01599999999996`}, {
                    170.04299999999998`, 380.}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{163.23, 
                    384.949}, {180.07, 384.949}, {166.44899999999998`, 
                    375.051}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{
                    169.05100000000002`, 383.059}, {174.254, 367.043}, {
                    160.629, 376.941}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{234.57, 
                    376.941}, {220.945, 367.043}, {226.148, 383.059}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{228.75, 
                    375.051}, {215.129, 384.949}, {231.969, 384.949}}}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{225.156, 
                    380.}, {230.359, 396.01599999999996`}, {235.562, 380.}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{228.75, 
                    384.949}, {245.594, 384.949}, {231.969, 375.051}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{234.57, 
                    383.059}, {239.77299999999997`, 367.043}, {226.148, 
                    376.941}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{300.09, 
                    376.941}, {286.465, 367.043}, {291.672, 383.059}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{
                    294.27299999999997`, 375.051}, {280.648, 384.949}, {
                    297.48799999999994`, 384.949}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{290.676, 
                    380.}, {295.879, 396.01599999999996`}, {301.082, 380.}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{
                    294.27299999999997`, 384.949}, {311.113, 384.949}, {
                    297.48799999999994`, 375.051}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{300.09, 
                    383.059}, {305.29299999999995`, 367.043}, {291.672, 
                    376.941}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{
                    365.60900000000004`, 376.941}, {351.984, 367.043}, {
                    357.191, 383.059}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{
                    359.79299999999995`, 375.051}, {346.168, 384.949}, {
                    363.008, 384.949}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{356.195, 
                    380.}, {361.39799999999997`, 396.01599999999996`}, {
                    366.605, 380.}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{
                    359.79299999999995`, 384.949}, {376.633, 384.949}, {
                    363.008, 375.051}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{
                    365.60900000000004`, 383.059}, {370.812, 367.043}, {
                    357.191, 376.941}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{70.77, 
                    348.85900000000004`}, {57.145, 338.96099999999996`}, {
                    62.352, 354.97999999999996`}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{64.953, 
                    346.97299999999996`}, {51.328, 356.871}, {
                    68.16799999999999, 356.871}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{61.355, 
                    351.92199999999997`}, {66.559, 367.93799999999993`}, {
                    71.766, 351.92199999999997`}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{64.953, 
                    356.871}, {81.793, 356.871}, {68.16799999999999, 
                    346.97299999999996`}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{70.77, 
                    354.97999999999996`}, {75.973, 338.96099999999996`}, {
                    62.352, 348.85900000000004`}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{136.289, 
                    348.85900000000004`}, {122.66799999999999`, 
                    338.96099999999996`}, {127.871, 354.97999999999996`}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{
                    130.47299999999998`, 346.97299999999996`}, {116.848, 
                    356.871}, {133.68800000000002`, 356.871}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{
                    126.87499999999999`, 351.92199999999997`}, {132.078, 
                    367.93799999999993`}, {137.285, 351.92199999999997`}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{
                    130.47299999999998`, 356.871}, {147.312, 356.871}, {
                    133.68800000000002`, 346.97299999999996`}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{136.289, 
                    354.97999999999996`}, {141.49200000000002`, 
                    338.96099999999996`}, {127.871, 348.85900000000004`}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{201.809, 
                    348.85900000000004`}, {188.18800000000002`, 
                    338.96099999999996`}, {193.39100000000002`, 
                    354.97999999999996`}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{
                    195.99200000000002`, 346.97299999999996`}, {
                    182.36700000000002`, 356.871}, {199.207, 356.871}}}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{192.395, 
                    351.92199999999997`}, {197.602, 367.93799999999993`}, {
                    202.805, 351.92199999999997`}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{
                    195.99200000000002`, 356.871}, {212.83200000000002`, 
                    356.871}, {199.207, 346.97299999999996`}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{201.809, 
                    354.97999999999996`}, {207.016, 338.96099999999996`}, {
                    193.39100000000002`, 348.85900000000004`}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{267.328, 
                    348.85900000000004`}, {253.707, 338.96099999999996`}, {
                    258.90999999999997`, 354.97999999999996`}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{261.512, 
                    346.97299999999996`}, {247.88700000000003`, 356.871}, {
                    264.727, 356.871}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{
                    257.91799999999995`, 351.92199999999997`}, {263.121, 
                    367.93799999999993`}, {268.324, 351.92199999999997`}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{261.512, 
                    356.871}, {278.35200000000003`, 356.871}, {264.727, 
                    346.97299999999996`}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{267.328, 
                    354.97999999999996`}, {272.53499999999997`, 
                    338.96099999999996`}, {258.90999999999997`, 
                    348.85900000000004`}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{
                    332.85200000000003`, 348.85900000000004`}, {319.227, 
                    338.96099999999996`}, {324.42999999999995`, 
                    354.97999999999996`}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{
                    327.03099999999995`, 346.97299999999996`}, {
                    313.40599999999995`, 356.871}, {330.25, 356.871}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{
                    323.43799999999993`, 351.92199999999997`}, {328.641, 
                    367.93799999999993`}, {333.84400000000005`, 
                    351.92199999999997`}}}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{
                    327.03099999999995`, 356.871}, {343.871, 356.871}, {
                    330.25, 346.97299999999996`}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{
                    332.85200000000003`, 354.97999999999996`}, {338.055, 
                    338.96099999999996`}, {324.42999999999995`, 
                    348.85900000000004`}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{38.012, 
                    320.78099999999995`}, {24.387, 310.883}, {29.59, 
                    326.89799999999997`}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{32.191, 
                    318.89099999999996`}, {18.566, 328.789}, {35.406, 
                    328.789}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{28.598, 
                    323.84000000000003`}, {33.800999999999995`, 339.855}, {
                    39.004, 323.84000000000003`}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{32.191, 
                    328.789}, {49.031, 328.789}, {35.406, 
                    318.89099999999996`}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{38.012, 
                    326.89799999999997`}, {43.215, 310.883}, {29.59, 
                    320.78099999999995`}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{103.531, 
                    320.78099999999995`}, {89.906, 310.883}, {95.109, 
                    326.89799999999997`}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{
                    97.71100000000001, 318.89099999999996`}, {84.086, 
                    328.789}, {100.93, 328.789}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{94.117, 
                    323.84000000000003`}, {99.32, 339.855}, {104.523, 
                    323.84000000000003`}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{
                    97.71100000000001, 328.789}, {114.551, 328.789}, {100.93, 
                    318.89099999999996`}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{103.531, 
                    326.89799999999997`}, {108.73400000000001`, 310.883}, {
                    95.109, 320.78099999999995`}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{
                    169.05100000000002`, 320.78099999999995`}, {
                    155.42600000000002`, 310.883}, {160.629, 
                    326.89799999999997`}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{163.23, 
                    318.89099999999996`}, {149.60899999999998`, 328.789}, {
                    166.44899999999998`, 328.789}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{159.637, 
                    323.84000000000003`}, {164.84, 339.855}, {
                    170.04299999999998`, 323.84000000000003`}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{163.23, 
                    328.789}, {180.07, 328.789}, {166.44899999999998`, 
                    318.89099999999996`}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{
                    169.05100000000002`, 326.89799999999997`}, {174.254, 
                    310.883}, {160.629, 320.78099999999995`}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{234.57, 
                    320.78099999999995`}, {220.945, 310.883}, {226.148, 
                    326.89799999999997`}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{228.75, 
                    318.89099999999996`}, {215.129, 328.789}, {231.969, 
                    328.789}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{225.156, 
                    323.84000000000003`}, {230.359, 339.855}, {235.562, 
                    323.84000000000003`}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{228.75, 
                    328.789}, {245.594, 328.789}, {231.969, 
                    318.89099999999996`}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{234.57, 
                    326.89799999999997`}, {239.77299999999997`, 310.883}, {
                    226.148, 320.78099999999995`}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{300.09, 
                    320.78099999999995`}, {286.465, 310.883}, {291.672, 
                    326.89799999999997`}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{
                    294.27299999999997`, 318.89099999999996`}, {280.648, 
                    328.789}, {297.48799999999994`, 328.789}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{290.676, 
                    323.84000000000003`}, {295.879, 339.855}, {301.082, 
                    323.84000000000003`}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{
                    294.27299999999997`, 328.789}, {311.113, 328.789}, {
                    297.48799999999994`, 318.89099999999996`}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{300.09, 
                    326.89799999999997`}, {305.29299999999995`, 310.883}, {
                    291.672, 320.78099999999995`}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{
                    365.60900000000004`, 320.78099999999995`}, {351.984, 
                    310.883}, {357.191, 326.89799999999997`}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{
                    359.79299999999995`, 318.89099999999996`}, {346.168, 
                    328.789}, {363.008, 328.789}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{356.195, 
                    323.84000000000003`}, {361.39799999999997`, 339.855}, {
                    366.605, 323.84000000000003`}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{
                    359.79299999999995`, 328.789}, {376.633, 328.789}, {
                    363.008, 318.89099999999996`}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{
                    365.60900000000004`, 326.89799999999997`}, {370.812, 
                    310.883}, {357.191, 320.78099999999995`}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{70.77, 
                    292.703}, {57.145, 282.805}, {62.352, 298.82}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{64.953, 
                    290.812}, {51.328, 300.71099999999996`}, {
                    68.16799999999999, 300.71099999999996`}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{61.355, 
                    295.762}, {66.559, 311.777}, {71.766, 295.762}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{64.953, 
                    300.71099999999996`}, {81.793, 300.71099999999996`}, {
                    68.16799999999999, 290.812}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{70.77, 
                    298.82}, {75.973, 282.805}, {62.352, 292.703}}}], 
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{136.289, 
                    292.703}, {122.66799999999999`, 282.805}, {127.871, 
                    298.82}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{
                    130.47299999999998`, 290.812}, {116.848, 
                    300.71099999999996`}, {133.68800000000002`, 
                    300.71099999999996`}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{
                    126.87499999999999`, 295.762}, {132.078, 311.777}, {
                    137.285, 295.762}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{
                    130.47299999999998`, 300.71099999999996`}, {147.312, 
                    300.71099999999996`}, {133.68800000000002`, 290.812}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{136.289, 
                    298.82}, {141.49200000000002`, 282.805}, {127.871, 
                    292.703}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{201.809, 
                    292.703}, {188.18800000000002`, 282.805}, {
                    193.39100000000002`, 298.82}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{
                    195.99200000000002`, 290.812}, {182.36700000000002`, 
                    300.71099999999996`}, {199.207, 300.71099999999996`}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{192.395, 
                    295.762}, {197.602, 311.777}, {202.805, 295.762}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{
                    195.99200000000002`, 300.71099999999996`}, {
                    212.83200000000002`, 300.71099999999996`}, {199.207, 
                    290.812}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{201.809, 
                    298.82}, {207.016, 282.805}, {193.39100000000002`, 
                    292.703}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{267.328, 
                    292.703}, {253.707, 282.805}, {258.90999999999997`, 
                    298.82}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{261.512, 
                    290.812}, {247.88700000000003`, 300.71099999999996`}, {
                    264.727, 300.71099999999996`}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{
                    257.91799999999995`, 295.762}, {263.121, 311.777}, {
                    268.324, 295.762}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{261.512, 
                    300.71099999999996`}, {278.35200000000003`, 
                    300.71099999999996`}, {264.727, 290.812}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{267.328, 
                    298.82}, {272.53499999999997`, 282.805}, {
                    258.90999999999997`, 292.703}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{
                    332.85200000000003`, 292.703}, {319.227, 282.805}, {
                    324.42999999999995`, 298.82}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{
                    327.03099999999995`, 290.812}, {313.40599999999995`, 
                    300.71099999999996`}, {330.25, 300.71099999999996`}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{
                    323.43799999999993`, 295.762}, {328.641, 311.777}, {
                    333.84400000000005`, 295.762}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{
                    327.03099999999995`, 300.71099999999996`}, {343.871, 
                    300.71099999999996`}, {330.25, 290.812}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{
                    332.85200000000003`, 298.82}, {338.055, 282.805}, {
                    324.42999999999995`, 292.703}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{38.012, 
                    264.621}, {24.387, 254.72299999999998`}, {29.59, 
                    270.73799999999994`}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{32.191, 
                    262.72999999999996`}, {18.566, 272.629}, {35.406, 
                    272.629}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{28.598, 
                    267.68}, {33.800999999999995`, 283.695}, {39.004, 
                    267.68}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{32.191, 
                    272.629}, {49.031, 272.629}, {35.406, 
                    262.72999999999996`}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{38.012, 
                    270.73799999999994`}, {43.215, 254.72299999999998`}, {
                    29.59, 264.621}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{103.531, 
                    264.621}, {89.906, 254.72299999999998`}, {95.109, 
                    270.73799999999994`}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{
                    97.71100000000001, 262.72999999999996`}, {84.086, 
                    272.629}, {100.93, 272.629}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{94.117, 
                    267.68}, {99.32, 283.695}, {104.523, 267.68}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{
                    97.71100000000001, 272.629}, {114.551, 272.629}, {100.93, 
                    262.72999999999996`}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{103.531, 
                    270.73799999999994`}, {108.73400000000001`, 
                    254.72299999999998`}, {95.109, 264.621}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{
                    169.05100000000002`, 264.621}, {155.42600000000002`, 
                    254.72299999999998`}, {160.629, 270.73799999999994`}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{163.23, 
                    262.72999999999996`}, {149.60899999999998`, 272.629}, {
                    166.44899999999998`, 272.629}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{159.637, 
                    267.68}, {164.84, 283.695}, {170.04299999999998`, 
                    267.68}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{163.23, 
                    272.629}, {180.07, 272.629}, {166.44899999999998`, 
                    262.72999999999996`}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{
                    169.05100000000002`, 270.73799999999994`}, {174.254, 
                    254.72299999999998`}, {160.629, 264.621}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{234.57, 
                    264.621}, {220.945, 254.72299999999998`}, {226.148, 
                    270.73799999999994`}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{228.75, 
                    262.72999999999996`}, {215.129, 272.629}, {231.969, 
                    272.629}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{225.156, 
                    267.68}, {230.359, 283.695}, {235.562, 267.68}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{228.75, 
                    272.629}, {245.594, 272.629}, {231.969, 
                    262.72999999999996`}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{234.57, 
                    270.73799999999994`}, {239.77299999999997`, 
                    254.72299999999998`}, {226.148, 264.621}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{300.09, 
                    264.621}, {286.465, 254.72299999999998`}, {291.672, 
                    270.73799999999994`}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{
                    294.27299999999997`, 262.72999999999996`}, {280.648, 
                    272.629}, {297.48799999999994`, 272.629}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{290.676, 
                    267.68}, {295.879, 283.695}, {301.082, 267.68}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{
                    294.27299999999997`, 272.629}, {311.113, 272.629}, {
                    297.48799999999994`, 262.72999999999996`}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{300.09, 
                    270.73799999999994`}, {305.29299999999995`, 
                    254.72299999999998`}, {291.672, 264.621}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{
                    365.60900000000004`, 264.621}, {351.984, 
                    254.72299999999998`}, {357.191, 270.73799999999994`}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{
                    359.79299999999995`, 262.72999999999996`}, {346.168, 
                    272.629}, {363.008, 272.629}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{356.195, 
                    267.68}, {361.39799999999997`, 283.695}, {366.605, 
                    267.68}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{
                    359.79299999999995`, 272.629}, {376.633, 272.629}, {
                    363.008, 262.72999999999996`}}}], 
                    
                    FilledCurveBox[{{{0, 2, 0}, {0, 1, 0}}}, {{{
                    365.60900000000004`, 270.73799999999994`}, {370.812, 
                    254.72299999999998`}, {357.191, 264.621}}}]}}}}}}, 
              AspectRatio -> Automatic, ImageSize -> {{128}, {85}}, 
              PlotRange -> {{0., 988.}, {0., 520.}}]}}, AutoDelete -> False, 
           GridBoxFrame -> {"Columns" -> {{True}}, "Rows" -> {{True}}}, 
           GridBoxItemSize -> {
            "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], "Grid"]], 
        "ExerciseOutput", Selectable -> False, Copyable -> False, Editable -> 
        False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"6f011f26-2b0d-4b77-b1c4-4afa38769c2b"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Make a list of word clouds for the Wikipedia articles about apple, peach \
and pear.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "26.6", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"f46f3b22-e29e-45c3-859b-262810354aba"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Sample", " ", "expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       RowBox[{"{", 
        RowBox[{
         GraphicsBox[{{}, {InsetBox[
             StyleBox["\<\"apple\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.24734982332155478`],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              FontColor->RGBColor[0.368417, 0.506779, 0.709798]], {0, 0}], 
            InsetBox[
             StyleBox["\<\"Apples\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.21201413427561838`],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.880722, 0.611041, 0.142051]], {9.5, -51.5}], InsetBox[
             StyleBox["\<\"cultivars\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.0706713780918728],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.922526, 0.385626, 0.209179]], {-5.5, 30.5}], InsetBox[
             StyleBox["\<\"fruit\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.10159010600706714`],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.560181, 0.691569, 0.194885]], {-0.5, 50.5}], InsetBox[
             StyleBox["\<\"varieties\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.05962897526501767],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.363898, 0.618501, 0.782349]], {-0.5, 72.5}], InsetBox[
             StyleBox["\<\"Commercially\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.03754416961130742],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.428777913273419, 0.5052332520359486, 0.85]], {58.5, 43.5}], 
            InsetBox[
             StyleBox["\<\"characteristics\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.03754416961130742],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.6536293927965667, 0.37163285420200276`, 
                0.6534265180085832]], {-60.5, 43.5}], InsetBox[
             StyleBox["\<\"disease\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.04858657243816254],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.40082222609352647`, 0.5220066643438841, 
                0.85]], {51.5, 56.5}], InsetBox[
             StyleBox["\<\"production\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.04196113074204947],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.8857244243136628, 0.3764133635295058, 
                0.1393110607841571]], {-72.5, 28.5}], InsetBox[
             StyleBox["\<\"generally\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.044169611307420496`],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.838355547812947, 0.44746667828057946`, 
                0.0208888695323676]], {-54.5, 57.5}], InsetBox[
             StyleBox["\<\"trees\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.061837455830388695`],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.772079, 0.431554, 0.102387]], {24.5, -81.5}], InsetBox[
             StyleBox["\<\"rootstocks\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.04196113074204947],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.47401116530937026`, 0.47809330081437784`, 
                0.85]], {76.5, 27.5}], InsetBox[
             StyleBox["\<\"century\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.04858657243816254],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              FontColor->RGBColor[0.915, 0.3325, 0.2125]], {0.5, 88.5}], 
            InsetBox[
             StyleBox["\<\"mythology\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.03754416961130742],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.47929071933511125`, 0.715, 
                0.1759027208462221]], {86.5, -26.5}], InsetBox[
             StyleBox["\<\"Commercial\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.0353356890459364],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.31827505306025683`, 0.715, 
                0.3808317506505822]], {-24.5, -89.5}], InsetBox[
             StyleBox["\<\"Collection\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.03754416961130742],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.9038177251280404, 0.3492734123079395, 
                0.18454431282010084`]], {57.5, 70.5}], InsetBox[
             StyleBox["\<\"produced\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.03975265017667844],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.8564488486273256, 0.42032672705901153`, 
                0.06612212156831418]], {-59.5, 70.5}], InsetBox[
             StyleBox["\<\"Davidson\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.03975265017667844],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.7678998606330495, 0.7317110956258943, 0.]], {50.5, 83.5}], 
            InsetBox[
             StyleBox["\<\"important\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.03754416961130742],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.6897400905885174, 0.358, 
                0.5753998606330502]], {-48.5, 84.5}], InsetBox[
             StyleBox["\<\"Europe\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.044169611307420496`],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.28026441037696703`, 0.715, 
                0.4292089322474965]], {-92.5, -26.5}], InsetBox[
             StyleBox["\<\"Significant\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.0353356890459364],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.8949268664259606, 0.5032845776173072, 
                0.05843417978336459]], {28.5, -95.5}], InsetBox[
             StyleBox["\<\"commonly\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.0353356890459364],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.845266573755366, 0.437100139366951, 
                0.03816643438841502]], {-0.5, 101.5}], InsetBox[
             StyleBox["\<\"tree\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.06404593639575971],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.528488, 0.470624, 0.701351]], {-100.5, 4.5}], InsetBox[
             StyleBox["\<\"including\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.03975265017667844],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              FontColor->RGBColor[
               0.35558897405758294`, 0.5505288207539337, 
                0.8417067688690995]], {-19.5, -102.5}], InsetBox[
             StyleBox["\<\"found\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.05079505300353357],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              FontColor->RGBColor[0.571589, 0.586483, 0.]], {66.5, -80.5}], 
            InsetBox[
             StyleBox["\<\"year\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.055212014134275615`],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.647624, 0.37816, 0.614037]], {-65.5, -75.5}], InsetBox[
             StyleBox["\<\"storage\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.04196113074204947],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.16397784358994957`, 0.7038177251280403, 
                0.6117734123079395]], {-96.5, -39.5}], InsetBox[
             StyleBox["\<\"Golden\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.044169611307420496`],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.5833680111493557, 0.4126186601628758, 
                0.8290799721266107]], {-47.5, 96.5}], InsetBox[
             StyleBox["\<\"goddess\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.03754416961130742],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.9492067688690977, 0.5394711792460651, 
                0.10728609198218791`]], {47.5, 97.5}], InsetBox[
             StyleBox["\<\"controlled\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.0353356890459364],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.5750747800184488, 0.4174563783225715, 
                0.8498130499538777]], {27.5, -107.5}], InsetBox[
             StyleBox["\<\"Aphrodite\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.0353356890459364],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.7277983389807635, 0.358, 
                0.5168487092603637]], {-14.5, 111.5}], InsetBox[
             StyleBox["\<\"used\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.055212014134275615`],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              FontColor->RGBColor[1, 0.75, 0]], {102.5, -9.5}], InsetBox[
             StyleBox["\<\"University\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.0353356890459364],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.9107287510704583, 0.33890687339431275`, 
                0.20182187767614543`]], {32.5, 113.5}], InsetBox[
             StyleBox["\<\"produce\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.03975265017667844],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.37977756485605163`, 0.715, 
                0.3025558265468435]], {99.5, 56.5}], InsetBox[
             StyleBox["\<\"cultivated\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.03754416961130742],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.7513196300394465, 0.358, 
                0.48066210763162087`]], {-76.5, -92.5}], InsetBox[
             StyleBox["\<\"genome\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.03754416961130742],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.3103557220216354, 0.5867154223826917, 
                0.7874268664259625]], {-25.5, -113.5}], InsetBox[
             StyleBox["\<\"flowering\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.0353356890459364],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.26512246998569167`, 0.6229020240114467, 
                0.73314696398283]], {76.5, -94.5}], InsetBox[
             StyleBox["\<\"develop\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.03754416961130742],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.8342400905885153, 0.4628267270590103, 
                0.0038160815296638794`]], {-93.5, 82.5}], InsetBox[
             StyleBox["\<\"cooking\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.03754416961130742],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.9784200278733908, 0.649600139366954, 
                0.058265924741844846`]], {-100.5, -52.5}], InsetBox[
             StyleBox["\<\"organic\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.03975265017667844],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.9637822400302223, 0.5764112001511111, 
                0.0977879519184]], {96.5, 79.5}], InsetBox[
             StyleBox["\<\"grown\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.044169611307420496`],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.8439466852489265, 0.3467106629502147, 
                0.3309221912517893]], {-100.5, 54.5}], InsetBox[
             StyleBox["\<\"rootstock\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.0353356890459364],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.8064401951137368, 0.3542119609772526, 
                0.39343300814377197`]], {-60.5, 109.5}], InsetBox[
             StyleBox["\<\"reactions\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.0353356890459364],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.529922539669161, 0.44454647619850335`, 
                0.85]], {-68.5, -105.5}], InsetBox[
             StyleBox["\<\"orchards\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.0353356890459364],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.4177882075393331, 0.715, 
                0.25417864494993975`]], {91.5, 93.5}], InsetBox[
             StyleBox["\<\"Malus\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.046378091872791516`],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.736782672705901, 0.358, 
                0.5030266573755369]], {-102.5, -66.5}], InsetBox[
             StyleBox["\<\"popular\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.03754416961130742],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.5019668524892619, 0.46131988850644284`, 
                0.85]], {70.5, -106.5}], InsetBox[
             StyleBox["\<\"States\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.04196113074204947],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.7748409210981391, 0.358, 
                0.4444755060028629]], {-102.5, 66.5}], InsetBox[
             StyleBox["\<\"group\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.044169611307420496`],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.8996399512215667, 0.7463488834690629, 0.]], {-102.5, -8.5}], 
            InsetBox[
             StyleBox["\<\"research\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.0353356890459364],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.9986489531525362, 0.7507447657626809, 
                0.0036478264881522893`]], {-90.5, 94.5}], InsetBox[
             StyleBox["\<\"America\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.0353356890459364],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.38354466123747527`, 0.5323732032575149, 
                0.85]], {74.5, 105.5}], InsetBox[
             StyleBox["\<\"species\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.03754416961130742],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.8781534541180211, 0.4921023027453475, 
                0.04333810870621905]], {-101.5, -79.5}], InsetBox[
             StyleBox["\<\"Different\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.0353356890459364],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.9307395679624266, 0.7498043964402695, 0.]], {104.5, 12.5}], 
            InsetBox[
             StyleBox["\<\"variety\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.03975265017667844],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.8168067340273636, 0.3521386531945273, 0.3761554432877274]], 
             {111.5, 38.5}], InsetBox[
             StyleBox["\<\"National\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.0353356890459364],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.8774935098648088, 0.34000129802703827`, 
                0.2750108168919853]], {15.5, -119.5}], InsetBox[
             StyleBox["\<\"England\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.0353356890459364],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.8335801463353031, 0.3487839707329394, 
                0.3481997561078282]], {-9.5, 124.5}], InsetBox[
             StyleBox["\<\"number\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.0353356890459364],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.9603267270590103, 0.5591336352950514, 
                0.10711783694067224`]], {104.5, -76.5}], InsetBox[
             StyleBox["\<\"North\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.044169611307420496`],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.28240003484173815`, 0.6090799721266095, 
                0.7538800418100857]], {-45.5, 123.5}], InsetBox[
             StyleBox["\<\"United\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.03975265017667844],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              FontColor->RGBColor[
               0.9810598048862722, 0.7553955338762525, 0.]], {53.5, -122.5}], 
            InsetBox[
             StyleBox["\<\"known\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.04196113074204947],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.5407932311309059, 0.715, 
                0.09762679674248334]], {-65.5, -117.5}], InsetBox[
             StyleBox["\<\"Greek\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.03975265017667844],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.8878600487784333, 0.33792799024431336`, 
                0.2577332520359445]], {-114.5, 37.5}], InsetBox[
             StyleBox["\<\"brown\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.03975265017667844],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.6184987019729621, 0.39212575718243875`, 
                0.7412532450675947]], {72.5, 117.5}], InsetBox[
             StyleBox["\<\"called\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.04196113074204947],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.9324333565611593, 0.5282889043741062, 
                0.0921900209050434]], {-99.5, 105.5}], InsetBox[
             StyleBox["\<\"include\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.0353356890459364],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.4567336004533182, 0.4884598397280091, 
                0.85]], {-79.5, 120.5}], InsetBox[
             StyleBox["\<\"seeds\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.04196113074204947],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.9874666782805795, 0.6948333914028977, 
                0.033839968642435214`]], {88.5, -117.5}], InsetBox[
             StyleBox["\<\"human\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.0353356890459364],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.8926354502560807, 0.366046824615879, 
                0.15658862564020168`]], {114.5, -87.5}], InsetBox[
             StyleBox["\<\"aphids\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.0353356890459364],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.969373377466199, 0.6043668873309952, 
                0.08269188084126262]], {-107.5, -105.5}], InsetBox[
             StyleBox["\<\"allergy\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.0353356890459364],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.9046334610863751, 0.334573307782725, 
                0.22977756485604156`]], {113.5, -99.5}], InsetBox[
             StyleBox["\<\"Pests\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.03975265017667844],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.7132613816472081, 0.358, 
                0.5392132590042952]], {110.5, 105.5}], InsetBox[
             StyleBox["\<\"leaves\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.0353356890459364],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.15725938678540247`, 0.715, 
                0.5857607804549424]], {-100.5, -119.5}], InsetBox[
             StyleBox["\<\"genes\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.0353356890459364],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.5788038738141875, 0.715, 
                0.049249615145579635`]], {-19.5, -124.5}], InsetBox[
             StyleBox["\<\"stored\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.0353356890459364],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.6672593867853922, 0.7205288207539324, 0.]], {105.5, 117.5}], 
            InsetBox[
             StyleBox["\<\"aphid\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.03754416961130742],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.23716678280579248`, 0.645266573755366, 
                0.699600139366951]], {-115.5, 19.5}], InsetBox[
             StyleBox["\<\"Norse\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.0353356890459364],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.3383114092015346, 0.5643508726387724, 
                0.8209736910418415]], {115.5, -41.5}], InsetBox[
             StyleBox["\<\"sweet\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.03754416961130742],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.6319174318193065, 0.38429816477207124`, 
                0.7077064204517338]], {-112.5, 117.5}], InsetBox[
             StyleBox["\<\"high\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.04196113074204947],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.6753413537738198, 0.3589675436319385, 
                0.5991466155654507]], {114.5, -53.5}], InsetBox[
             StyleBox["\<\"world\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.03754416961130742],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.7175796237092107, 0.7261199581899123, 0.]], {115.5, 66.5}], 
            InsetBox[
             StyleBox["\<\"eaten\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.03754416961130742],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.8493197142977551, 0.7407577460330839, 0.]], {25.5, 125.5}], 
            InsetBox[
             StyleBox["\<\"early\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.03754416961130742],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.596786740995709, 0.404791067752503, 
                0.7955331475107271]], {125.5, -21.5}], InsetBox[
             StyleBox["\<\"fresh\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.0353356890459364],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.6670481226429111, 0.3638052617916352, 
                0.6198796933927223]], {124.5, 23.5}], InsetBox[
             StyleBox["\<\"small\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.03754416961130742],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.19193353076984873`, 0.681453175384121, 
                0.6453202369238185]], {9.5, -131.5}], InsetBox[
             StyleBox["\<\"fruits\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.03754416961130742],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.8607200975568693, 0.34335598048862614`, 
                0.30296650407188447`]], {-127.5, -21.5}], InsetBox[
             StyleBox["\<\"cider\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.03754416961130742],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.6361597700445392, 0.7170733077827265, 0.]], {-49.5, -129.5}],
             InsetBox[
             StyleBox["\<\"seed\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.0353356890459364],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.2198892179497479, 0.6590886256402017, 
                0.6788670615396974]], {-19.5, -26.5}], InsetBox[
             StyleBox["\<\"plant\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.0353356890459364],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.8633598745697435, 0.40996018814538476`, 
                0.08339968642435877]], {36.5, -134.5}], InsetBox[
             StyleBox["\<\"large\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.0353356890459364],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.9840111653093676, 0.677555826546838, 
                0.04316985366470745]], {41.5, 134.5}], InsetBox[
             StyleBox["\<\"form\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.0353356890459364],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.922066817647527, 0.5213778784316846, 
                0.08286013588277422]], {66.5, 129.5}], InsetBox[
             StyleBox["\<\"wild\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.04196113074204947],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              FontColor->RGBColor[
               0.8613800418100862, 0.48092002787339083`, 
                0.02824203762907758]], {-125.5, 80.5}], InsetBox[
             StyleBox["\<\"Asia\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.03754416961130742],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.9052934053395919, 0.510195603559728, 
                0.06776406480563275]], {-75.5, -131.5}], InsetBox[
             StyleBox["\<\"new\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.04858657243816254],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.9728288904374106, 0.621644452187053, 
                0.07336199581899142]], {62.5, -134.5}], InsetBox[
             StyleBox["\<\"day\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.03754416961130742],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.2187618985811806, 0.715, 
                0.5074848563512248]], {-129.5, 0.5}], InsetBox[
             StyleBox["\<\"long\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.0353356890459364],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.7989994773739094, 0.735166608597101, 0.]], {-129.5, -33.5}], 
            InsetBox[
             StyleBox["\<\"skin\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.0353356890459364],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.6453361616656581, 0.37647057236169945`, 
                0.6741595958358548]], {46.5, -26.5}], InsetBox[
             StyleBox["\<\"size\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.03754416961130742],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.7896667828057927, 0.3575666434388414, 
                0.4213886953236787]], {127.5, 77.5}], InsetBox[
             StyleBox["\<\"UK\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.03975265017667844],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.5472001045252132, 0.43417993728487203`, 
                0.85]], {130.5, -0.5}], InsetBox[
             StyleBox["\<\"late\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.0353356890459364],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.7658565873730018, 0.358, 
                0.4582975578876895]], {-130.5, -45.5}], InsetBox[
             StyleBox["\<\"nuts\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.0353356890459364],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.7042770479220728, 0.358, 
                0.5530353108891188]], {129.5, -65.5}], InsetBox[
             StyleBox["\<\"like\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.0353356890459364],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.6102054708420535, 0.39696347534213544`, 
                0.7619863228948663]], {-129.5, 49.5}], InsetBox[
             StyleBox["\<\"old\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.03754416961130742],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.8745421494417032, 0.39318677583744527`, 
                0.11135537360425793`]], {131.5, 48.5}], InsetBox[
             StyleBox["\<\"raw\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.03754416961130742],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.9930578157165594, 0.7227890785827968, 
                0.01874389756528967]], {-0.5, 135.5}], InsetBox[
             StyleBox["\<\"life\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.0353356890459364],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.8510135028964549, 0.47400900193096995`, 
                0.018912152606809424`]], {-129.5, -57.5}]}},
          
          Method->{
           "DefaultBoundaryStyle" -> Automatic, "DefaultPlotStyle" -> 
            Automatic},
          PlotRange->{{-142., 141.}, {-141., 142.}}], ",", 
         GraphicsBox[{{}, {InsetBox[
             StyleBox["\<\"peach\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.25],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              FontColor->RGBColor[0.368417, 0.506779, 0.709798]], {0, 0}], 
            InsetBox[
             StyleBox["\<\"peaches\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.1510989010989011],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.880722, 0.611041, 0.142051]], {-0.5, -41.5}], InsetBox[
             StyleBox["\<\"nectarines\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.07574568288854003],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.922526, 0.385626, 0.209179]], {-0.5, 30.5}], InsetBox[
             StyleBox["\<\"fruit\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.08751962323390895],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.560181, 0.691569, 0.194885]], {-0.5, 49.5}], InsetBox[
             StyleBox["\<\"temperatures\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.04277864992150706],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.8878600487784333, 0.33792799024431336`, 
                0.2577332520359445]], {-0.5, -61.5}], InsetBox[
             StyleBox["\<\"cultivars\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.05690737833594976],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.647624, 0.37816, 0.614037]], {-52.5, 44.5}], InsetBox[
             StyleBox["\<\"trees\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.07574568288854003],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.528488, 0.470624, 0.701351]], {47.5, 45.5}], InsetBox[
             StyleBox["\<\"nectarine\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.049843014128728415`],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.5833680111493557, 0.4126186601628758, 
                0.8290799721266107]], {-0.5, 69.5}], InsetBox[
             StyleBox["\<\"cultivation\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.045133437990580845`],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.6753413537738198, 0.3589675436319385, 
                0.5991466155654507]], {4.5, -75.5}], InsetBox[
             StyleBox["\<\"yellow\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.05690737833594976],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              FontColor->RGBColor[0.571589, 0.586483, 0.]], {-54.5, 60.5}], 
            InsetBox[
             StyleBox["\<\"Chinese\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.049843014128728415`],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.28026441037696703`, 0.715, 
                0.4292089322474965]], {56.5, 58.5}], InsetBox[
             StyleBox["\<\"China\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.05690737833594976],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              FontColor->RGBColor[1, 0.75, 0]], {3.5, 84.5}], InsetBox[
             StyleBox["\<\"persica\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.05219780219780219],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.9728288904374106, 0.621644452187053, 
                0.07336199581899142]], {61.5, -64.5}], InsetBox[
             StyleBox["\<\"clingstone\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.04042386185243328],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.9637822400302223, 0.5764112001511111, 
                0.0977879519184]], {-78.5, 28.5}], InsetBox[
             StyleBox["\<\"including\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.04277864992150706],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.16397784358994957`, 0.7038177251280403, 
                0.6117734123079395]], {-0.5, -88.5}], InsetBox[
             StyleBox["\<\"cultivated\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.04042386185243328],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.7132613816472081, 0.358, 
                0.5392132590042952]], {-51.5, -75.5}], InsetBox[
             StyleBox["\<\"flesh\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.059262166405023554`],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.363898, 0.618501, 0.782349]], {48.5, 74.5}], InsetBox[
             StyleBox["\<\"commercial\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.0380690737833595],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.8745421494417032, 0.39318677583744527`, 
                0.11135537360425793`]], {-48.5, 80.5}], InsetBox[
             StyleBox["\<\"different\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.04277864992150706],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.9874666782805795, 0.6948333914028977, 
                0.033839968642435214`]], {92.5, 28.5}], InsetBox[
             StyleBox["\<\"produced\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.0380690737833595],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.5750747800184488, 0.4174563783225715, 
                0.8498130499538777]], {57.5, -78.5}], InsetBox[
             StyleBox["\<\"European\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.0380690737833595],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.9930578157165594, 0.7227890785827968, 0.01874389756528967]], 
             {10.5, 98.5}], InsetBox[
             StyleBox["\<\"century\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.045133437990580845`],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.9324333565611593, 0.5282889043741062, 
                0.0921900209050434]], {-48.5, -88.5}], InsetBox[
             StyleBox["\<\"paintings\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.04042386185243328],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.428777913273419, 0.5052332520359486, 0.85]], {-0.5, -102.5}],
             InsetBox[
             StyleBox["\<\"Prunus\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.04748822605965463],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.8439466852489265, 0.3467106629502147, 
                0.3309221912517893]], {-41.5, 92.5}], InsetBox[
             StyleBox["\<\"tree\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.0663265306122449],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.772079, 0.431554, 0.102387]], {95.5, -29.5}], InsetBox[
             StyleBox["\<\"Common\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.0380690737833595],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.5019668524892619, 0.46131988850644284`, 
                0.85]], {95.5, 41.5}], InsetBox[
             StyleBox["\<\"breeding\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.0380690737833595],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.3103557220216354, 0.5867154223826917, 
                0.7874268664259625]], {46.5, -91.5}], InsetBox[
             StyleBox["\<\"example\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.04042386185243328],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.5472001045252132, 0.43417993728487203`, 
                0.85]], {57.5, 89.5}], InsetBox[
             StyleBox["\<\"white\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.049843014128728415`],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.8996399512215667, 0.7463488834690629, 0.]], {-99.5, -43.5}], 
            InsetBox[
             StyleBox["\<\"wood\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.05219780219780219],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.736782672705901, 0.358, 0.5030266573755369]], {99.5, -44.5}],
             InsetBox[
             StyleBox["\<\"typically\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.04042386185243328],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.2187618985811806, 0.715, 
                0.5074848563512248]], {-6.5, 109.5}], InsetBox[
             StyleBox["\<\"Europe\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.04277864992150706],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.7748409210981391, 0.358, 
                0.4444755060028629]], {-45.5, -101.5}], InsetBox[
             StyleBox["\<\"related\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.045133437990580845`],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.8857244243136628, 0.3764133635295058, 
                0.1393110607841571]], {88.5, 70.5}], InsetBox[
             StyleBox["\<\"California\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.03571428571428571],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.6672593867853922, 0.7205288207539324, 0.]], {38.5, 107.5}], 
            InsetBox[
             StyleBox["\<\"Genome\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.0380690737833595],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.8781534541180211, 0.4921023027453475, 
                0.04333810870621905]], {45.5, -105.5}], InsetBox[
             StyleBox["\<\"early\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.05219780219780219],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.40082222609352647`, 0.5220066643438841, 
                0.85]], {-100.5, 44.5}], InsetBox[
             StyleBox["\<\"Ancient\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.04042386185243328],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.35558897405758294`, 0.5505288207539337, 
                0.8417067688690995]], {-49.5, 105.5}], InsetBox[
             StyleBox["\<\"blossoms\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.03571428571428571],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.9986489531525362, 0.7507447657626809, 
                0.0036478264881522893`]], {-86.5, 89.5}], InsetBox[
             StyleBox["\<\"fruits\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.049843014128728415`],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.838355547812947, 0.44746667828057946`, 
                0.0208888695323676]], {-95.5, 58.5}], InsetBox[
             StyleBox["\<\"States\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.045133437990580845`],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.47401116530937026`, 0.47809330081437784`, 
                0.85]], {-100.5, -56.5}], InsetBox[
             StyleBox["\<\"species\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.0380690737833595],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.922066817647527, 0.5213778784316846, 
                0.08286013588277422]], {-98.5, -69.5}], InsetBox[
             StyleBox["\<\"genetic\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.04042386185243328],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.23716678280579248`, 0.645266573755366, 
                0.699600139366951]], {-98.5, 74.5}], InsetBox[
             StyleBox["\<\"flowers\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.04042386185243328],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.9810598048862722, 0.7553955338762525, 0.]], {-90.5, -87.5}], 
            InsetBox[
             StyleBox["\<\"activities\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.03571428571428571],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.7989994773739094, 0.735166608597101, 0.]], {90.5, -89.5}], 
            InsetBox[
             StyleBox["\<\"climates\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.03571428571428571],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.9107287510704583, 0.33890687339431275`, 
                0.20182187767614543`]], {-60.5, -113.5}], InsetBox[
             StyleBox["\<\"varieties\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.0380690737833595],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.4567336004533182, 0.4884598397280091, 0.85]], {84.5, 101.5}],
             InsetBox[
             StyleBox["\<\"fleshed\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.0380690737833595],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.7896667828057927, 0.3575666434388414, 
                0.4213886953236787]], {100.5, 83.5}], InsetBox[
             StyleBox["\<\"spring\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.04277864992150706],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.7678998606330495, 0.7317110956258943, 0.]], {101.5, 53.5}], 
            InsetBox[
             StyleBox["\<\"usually\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.0380690737833595],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.8926354502560807, 0.366046824615879, 
                0.15658862564020168`]], {87.5, -101.5}], InsetBox[
             StyleBox["\<\"chilling\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.0380690737833595],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.6897400905885174, 0.358, 
                0.5753998606330502]], {-89.5, 101.5}], InsetBox[
             StyleBox["\<\"skin\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.054552590266875985`],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              FontColor->RGBColor[0.915, 0.3325, 0.2125]], {101.5, -61.5}], 
            InsetBox[
             StyleBox["\<\"blossom\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.03571428571428571],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.529922539669161, 0.44454647619850335`, 
                0.85]], {-86.5, -100.5}], InsetBox[
             StyleBox["\<\"believed\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.03571428571428571],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.8633598745697435, 0.40996018814538476`, 
                0.08339968642435877]], {80.5, 112.5}], InsetBox[
             StyleBox["\<\"protect\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.0380690737833595],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.9307395679624266, 0.7498043964402695, 0.]], {-89.5, 112.5}], 
            InsetBox[
             StyleBox["\<\"grown\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.04042386185243328],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.9052934053395919, 0.510195603559728, 
                0.06776406480563275]], {-98.5, -111.5}], InsetBox[
             StyleBox["\<\"leaves\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.04277864992150706],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.8613800418100862, 0.48092002787339083`, 
                0.02824203762907758]], {110.5, 0.5}], InsetBox[
             StyleBox["\<\"brought\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.03571428571428571],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.8064401951137368, 0.3542119609772526, 
                0.39343300814377197`]], {110.5, 12.5}], InsetBox[
             StyleBox["\<\"used\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.04748822605965463],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.28240003484173815`, 0.6090799721266095, 
                0.7538800418100857]], {107.5, -13.5}], InsetBox[
             StyleBox["\<\"period\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.04042386185243328],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.9784200278733908, 0.649600139366954, 
                0.058265924741844846`]], {-111.5, 0.5}], InsetBox[
             StyleBox["\<\"bruised\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.03571428571428571],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.8949268664259606, 0.5032845776173072, 
                0.05843417978336459]], {-112.5, 12.5}], InsetBox[
             StyleBox["\<\"appear\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.03571428571428571],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.7042770479220728, 0.358, 
                0.5530353108891188]], {-112.5, -12.5}], InsetBox[
             StyleBox["\<\"almond\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.03571428571428571],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.9603267270590103, 0.5591336352950514, 
                0.10711783694067224`]], {-112.5, -26.5}], InsetBox[
             StyleBox["\<\"flower\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.0380690737833595],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.19193353076984873`, 0.681453175384121, 
                0.6453202369238185]], {4.5, -115.5}], InsetBox[
             StyleBox["\<\"New\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.045133437990580845`],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.5407932311309059, 0.715, 
                0.09762679674248334]], {-2.5, 121.5}], InsetBox[
             StyleBox["\<\"branch\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.0380690737833595],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.8607200975568693, 0.34335598048862614`, 
                0.30296650407188447`]], {30.5, 119.5}], InsetBox[
             StyleBox["\<\"Persia\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.0380690737833595],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.31827505306025683`, 0.715, 
                0.3808317506505822]], {37.5, -118.5}], InsetBox[
             StyleBox["\<\"United\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.0380690737833595],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.5788038738141875, 0.715, 
                0.049249615145579635`]], {-33.5, 120.5}], InsetBox[
             StyleBox["\<\"good\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.0380690737833595],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.6319174318193065, 0.38429816477207124`, 
                0.7077064204517338]], {-24.5, -122.5}], InsetBox[
             StyleBox["\<\"north\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.04042386185243328],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.9038177251280404, 0.3492734123079395, 
                0.18454431282010084`]], {101.5, -75.5}], InsetBox[
             StyleBox["\<\"winter\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.0380690737833595],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.9840111653093676, 0.677555826546838, 
                0.04316985366470745]], {71.5, -118.5}], InsetBox[
             StyleBox["\<\"called\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.0380690737833595],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.9492067688690977, 0.5394711792460651, 
                0.10728609198218791`]], {-65.5, 123.5}], InsetBox[
             StyleBox["\<\"brown\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.03571428571428571],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.2198892179497479, 0.6590886256402017, 
                0.6788670615396974]], {-70.5, -123.5}], InsetBox[
             StyleBox["\<\"artists\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.03571428571428571],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.4177882075393331, 0.715, 
                0.25417864494993975`]], {-54.5, -61.5}], InsetBox[
             StyleBox["\<\"State\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.0380690737833595],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.6670481226429111, 0.3638052617916352, 
                0.6198796933927223]], {101.5, -116.5}], InsetBox[
             StyleBox["\<\"plant\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.0380690737833595],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.845266573755366, 0.437100139366951, 
                0.03816643438841502]], {113.5, 112.5}], InsetBox[
             StyleBox["\<\"plum\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.04042386185243328],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.7513196300394465, 0.358, 
                0.48066210763162087`]], {-98.5, 122.5}], InsetBox[
             StyleBox["\<\"moth\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.04042386185243328],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.6361597700445392, 0.7170733077827265, 0.]], {-120.5, 24.5}], 
            InsetBox[
             StyleBox["\<\"health\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.0380690737833595],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.9046334610863751, 0.334573307782725, 
                0.22977756485604156`]], {4.5, -128.5}], InsetBox[
             StyleBox["\<\"season\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.0380690737833595],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.8335801463353031, 0.3487839707329394, 
                0.3481997561078282]], {18.5, 131.5}], InsetBox[
             StyleBox["\<\"large\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.0380690737833595],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.38354466123747527`, 0.5323732032575149, 
                0.85]], {126.5, -26.5}], InsetBox[
             StyleBox["\<\"year\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.04042386185243328],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.8342400905885153, 0.4628267270590103, 
                0.0038160815296638794`]], {34.5, -130.5}], InsetBox[
             StyleBox["\<\"allele\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.03571428571428571],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.3383114092015346, 0.5643508726387724, 
                0.8209736910418415]], {-30.5, 131.5}], InsetBox[
             StyleBox["\<\"source\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.0380690737833595],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.26512246998569167`, 0.6229020240114467, 
                0.73314696398283]], {66.5, 124.5}], InsetBox[
             StyleBox["\<\"fuzz\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.04042386185243328],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.8168067340273636, 0.3521386531945273, 
                0.3761554432877274]], {-125.5, 54.5}], InsetBox[
             StyleBox["\<\"long\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.04042386185243328],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.6536293927965667, 0.37163285420200276`, 
                0.6534265180085832]], {128.5, 24.5}], InsetBox[
             StyleBox["\<\"due\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.04042386185243328],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.37977756485605163`, 0.715, 
                0.3025558265468435]], {120.5, 63.5}], InsetBox[
             StyleBox["\<\"buds\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.03571428571428571],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.6453361616656581, 0.37647057236169945`, 
                0.6741595958358548]], {49.5, 133.5}], InsetBox[
             StyleBox["\<\"leaf\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.0380690737833595],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.969373377466199, 0.6043668873309952, 
                0.08269188084126262]], {128.5, 35.5}], InsetBox[
             StyleBox["\<\"Han\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.0380690737833595],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.7175796237092107, 0.7261199581899123, 0.]], {128.5, -57.5}], 
            InsetBox[
             StyleBox["\<\"acid\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.0380690737833595],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.596786740995709, 0.404791067752503, 
                0.7955331475107271]], {-49.5, -132.5}], InsetBox[
             StyleBox["\<\"evil\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.04042386185243328],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.8564488486273256, 0.42032672705901153`, 
                0.06612212156831418]], {-128.5, 34.5}], InsetBox[
             StyleBox["\<\"100\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.03571428571428571],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.7658565873730018, 0.358, 
                0.4582975578876895]], {-128.5, -38.5}], InsetBox[
             StyleBox["\<\"red\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.04277864992150706],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.6184987019729621, 0.39212575718243875`, 
                0.7412532450675947]], {128.5, -39.5}], InsetBox[
             StyleBox["\<\"BC\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.0380690737833595],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              FontColor->RGBColor[0.8493197142977551, 0.7407577460330839, 0.]],
              {127.5, 47.5}], InsetBox[
             StyleBox["\<\"AD\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.03571428571428571],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.8774935098648088, 0.34000129802703827`, 
                0.2750108168919853]], {-128.5, -50.5}], InsetBox[
             StyleBox["\<\"28\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.03571428571428571],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.6102054708420535, 0.39696347534213544`, 
                0.7619863228948663]], {131.5, -12.5}], InsetBox[
             StyleBox["\<\"16\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.03571428571428571],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.8510135028964549, 0.47400900193096995`, 
                0.018912152606809424`]], {-127.5, -62.5}], InsetBox[
             StyleBox["\<\"life\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.0380690737833595],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.7277983389807635, 0.358, 
                0.5168487092603637]], {-126.5, 65.5}], InsetBox[
             StyleBox["\<\"cm\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.0380690737833595],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              FontColor->RGBColor[
               0.47929071933511125`, 0.715, 
                0.1759027208462221]], {-19.5, -134.5}], InsetBox[
             StyleBox["\<\"15\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.03571428571428571],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.15725938678540247`, 0.715, 
                0.5857607804549424]], {123.5, -70.5}]}},
          
          Method->{
           "DefaultBoundaryStyle" -> Automatic, "DefaultPlotStyle" -> 
            Automatic},
          PlotRange->{{-139., 141.}, {-141., 141.}}], ",", 
         GraphicsBox[{{}, {InsetBox[
             StyleBox["\<\"pear\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.24911032028469748`],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              FontColor->RGBColor[0.368417, 0.506779, 0.709798]], {0, 0}], 
            InsetBox[
             StyleBox["\<\"pears\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.12293756065998059`],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              FontColor->RGBColor[0.560181, 0.691569, 0.194885]], {0., -34.}],
             InsetBox[
             StyleBox["\<\"species\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.1035263668715626],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              FontColor->RGBColor[0.922526, 0.385626, 0.209179]], {0., 32.}], 
            InsetBox[
             StyleBox["\<\"fruit\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.12293756065998059`],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.880722, 0.611041, 0.142051]], {-18., 54.}], InsetBox[
             StyleBox["\<\"communis\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.06955677774183112],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.772079, 0.431554, 0.102387]], {14., -54.}], InsetBox[
             StyleBox["\<\"cultivated\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.06470397929472663],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              FontColor->RGBColor[0.571589, 0.586483, 0.]], {0., -73.}], 
            InsetBox[
             StyleBox["\<\"Pyrus\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.07926237463604012],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              FontColor->RGBColor[0.528488, 0.470624, 0.701351]], {40., 54.}],
             InsetBox[
             StyleBox["\<\"centimetres\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.050145583953413134`],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.8996399512215667, 0.7463488834690629, 0.]], {0., 78.}], 
            InsetBox[
             StyleBox["\<\"varieties\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.05499838240051763],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.736782672705901, 0.358, 0.5030266573755369]], {75., -28.}], 
            InsetBox[
             StyleBox["\<\"European\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.050145583953413134`],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.28240003484173815`, 0.6090799721266095, 
                0.7538800418100857]], {-76., -41.}], InsetBox[
             StyleBox["\<\"cultivars\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.050145583953413134`],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.8439466852489265, 0.3467106629502147, 
                0.3309221912517893]], {-78., 27.}], InsetBox[
             StyleBox["\<\"temperature\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.04043998705920414],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.5019668524892619, 0.46131988850644284`, 
                0.85]], {-64., -59.}], InsetBox[
             StyleBox["\<\"used\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.06955677774183112],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              FontColor->RGBColor[0.647624, 0.37816, 0.614037]], {74., 29.}], 
            InsetBox[
             StyleBox["\<\"trees\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.06955677774183112],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              FontColor->RGBColor[1, 0.75, 0]], {83., -2.}], InsetBox[
             StyleBox["\<\"ornamental\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.04043998705920414],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.7513196300394465, 0.358, 
                0.48066210763162087`]], {12., -88.}], InsetBox[
             StyleBox["\<\"bretschneideri\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.03558718861209964],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.5750747800184488, 0.4174563783225715, 
                0.8498130499538777]], {-8., 91.}], InsetBox[
             StyleBox["\<\"distinguished\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.03558718861209964],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.7989994773739094, 0.735166608597101, 0.]], {-78., 45.}], 
            InsetBox[
             StyleBox["\<\"grown\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.05499838240051763],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.40082222609352647`, 0.5220066643438841, 0.85]], {-91., 0.}], 
            InsetBox[
             StyleBox["\<\"rootstocks\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.04043998705920414],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.3103557220216354, 0.5867154223826917, 
                0.7874268664259625]], {66., 67.}], InsetBox[
             StyleBox["\<\"wood\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.05499838240051763],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.28026441037696703`, 0.715, 
                0.4292089322474965]], {-89., -17.}], InsetBox[
             StyleBox["\<\"tree\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.06955677774183112],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.363898, 0.618501, 0.782349]], {-67., 60.}], InsetBox[
             StyleBox["\<\"pressure\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.04043998705920414],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.8342400905885153, 0.4628267270590103, 
                0.0038160815296638794`]], {63., -68.}], InsetBox[
             StyleBox["\<\"evergreen\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.03558718861209964],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.9603267270590103, 0.5591336352950514, 
                0.10711783694067224`]], {79., -40.}], InsetBox[
             StyleBox["\<\"western\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.045292785506308636`],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.7678998606330495, 0.7317110956258943, 0.]], {-92., 12.}], 
            InsetBox[
             StyleBox["\<\"ripen\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.05499838240051763],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.9728288904374106, 0.621644452187053, 
                0.07336199581899142]], {-56., 77.}], InsetBox[
             StyleBox["\<\"ripeness\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.04043998705920414],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.596786740995709, 0.404791067752503, 
                0.7955331475107271]], {-42., -87.}], InsetBox[
             StyleBox["\<\"cultivation\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.03558718861209964],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.9840111653093676, 0.677555826546838, 
                0.04316985366470745]], {85., -54.}], InsetBox[
             StyleBox["\<\"variety\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.045292785506308636`],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.6184987019729621, 0.39212575718243875`, 
                0.7412532450675947]], {94., 12.}], InsetBox[
             StyleBox["\<\"apple\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.050145583953413134`],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.838355547812947, 0.44746667828057946`, 
                0.0208888695323676]], {57., 81.}], InsetBox[
             StyleBox["\<\"desirable\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.03558718861209964],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.8510135028964549, 0.47400900193096995`, 
                0.018912152606809424`]], {-64., -73.}], InsetBox[
             StyleBox["\<\"ripening\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.04043998705920414],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.8493197142977551, 0.7407577460330839, 0.]], {-10., -101.}], 
            InsetBox[
             StyleBox["\<\"favored\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.04043998705920414],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.5472001045252132, 0.43417993728487203`, 0.85]], {92., 45.}], 
            InsetBox[
             StyleBox["\<\"known\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.045292785506308636`],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.7748409210981391, 0.358, 0.4444755060028629]], {0., 103.}], 
            InsetBox[
             StyleBox["\<\"north\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.050145583953413134`],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.9324333565611593, 0.5282889043741062, 
                0.0921900209050434]], {60., -83.}], InsetBox[
             StyleBox["\<\"gathered\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.03558718861209964],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.8949268664259606, 0.5032845776173072, 
                0.05843417978336459]], {47., 95.}], InsetBox[
             StyleBox["\<\"diameter\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.03558718861209964],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.6102054708420535, 0.39696347534213544`, 
                0.7619863228948663]], {33., -101.}], InsetBox[
             StyleBox["\<\"ripe\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.05985118084762212],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              FontColor->RGBColor[0.915, 0.3325, 0.2125]], {-56., 96.}], 
            InsetBox[
             StyleBox["\<\"green\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.045292785506308636`],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.9874666782805795, 0.6948333914028977, 0.033839968642435214`]],
              {-49., -101.}], InsetBox[
             StyleBox["\<\"China\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.045292785506308636`],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.6753413537738198, 0.3589675436319385, 
                0.5991466155654507]], {38., 107.}], InsetBox[
             StyleBox["\<\"Bradford\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.03558718861209964],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.845266573755366, 0.437100139366951, 
                0.03816643438841502]], {-41., 110.}], InsetBox[
             StyleBox["\<\"France\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.04043998705920414],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.23716678280579248`, 0.645266573755366, 
                0.699600139366951]], {-85., -84.}], InsetBox[
             StyleBox["\<\"Europe\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.04043998705920414],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.8564488486273256, 0.42032672705901153`, 
                0.06612212156831418]], {-95., 75.}], InsetBox[
             StyleBox["\<\"subsp\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.045292785506308636`],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              FontColor->RGBColor[
               0.8613800418100862, 0.48092002787339083`, 
                0.02824203762907758]], {75., -96.}], InsetBox[
             StyleBox["\<\"edible\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.045292785506308636`],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.5407932311309059, 0.715, 0.09762679674248334]], {94., 80.}], 
            InsetBox[
             StyleBox["\<\"America\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.03558718861209964],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.7277983389807635, 0.358, 0.5168487092603637]], {29., -113.}],
             InsetBox[
             StyleBox["\<\"gardens\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.03558718861209964],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.2198892179497479, 0.6590886256402017, 
                0.6788670615396974]], {98., -79.}], InsetBox[
             StyleBox["\<\"Asia\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.050145583953413134`],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.5833680111493557, 0.4126186601628758, 
                0.8290799721266107]], {-102., 58.}], InsetBox[
             StyleBox["\<\"apples\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.04043998705920414],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.8878600487784333, 0.33792799024431336`, 
                0.2577332520359445]], {-91., 89.}], InsetBox[
             StyleBox["\<\"England\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.03558718861209964],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.8774935098648088, 0.34000129802703827`, 
                0.2750108168919853]], {89., 95.}], InsetBox[
             StyleBox["\<\"densely\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.03558718861209964],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.15725938678540247`, 0.715, 
                0.5857607804549424]], {-86., -97.}], InsetBox[
             StyleBox["\<\"culinary\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.03558718861209964],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.4567336004533182, 0.4884598397280091, 0.85]], {69., -110.}], 
            InsetBox[
             StyleBox["\<\"cooking\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.03558718861209964],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.8926354502560807, 0.366046824615879, 
                0.15658862564020168`]], {76., 109.}], InsetBox[
             StyleBox["\<\"leaves\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.04043998705920414],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.6361597700445392, 0.7170733077827265, 0.]], {-90., 101.}], 
            InsetBox[
             StyleBox["\<\"gentle\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.04043998705920414],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.9052934053395919, 0.510195603559728, 
                0.06776406480563275]], {-84., -112.}], InsetBox[
             StyleBox["\<\"fruits\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.045292785506308636`],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.47401116530937026`, 0.47809330081437784`, 
                0.85]], {-77., 112.}], InsetBox[
             StyleBox["\<\"winter\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.04043998705920414],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.8781534541180211, 0.4921023027453475, 
                0.04333810870621905]], {2., 114.}], InsetBox[
             StyleBox["\<\"called\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.04043998705920414],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.9637822400302223, 0.5764112001511111, 
                0.0977879519184]], {-13., -116.}], InsetBox[
             StyleBox["\<\"accounts\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.03558718861209964],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.969373377466199, 0.6043668873309952, 
                0.08269188084126262]], {108., -64.}], InsetBox[
             StyleBox["\<\"flowers\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.03558718861209964],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.7042770479220728, 0.358, 
                0.5530353108891188]], {-104., -70.}], InsetBox[
             StyleBox["\<\"carving\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.03558718861209964],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.26512246998569167`, 0.6229020240114467, 
                0.73314696398283]], {106., -15.}], InsetBox[
             StyleBox["\<\"shape\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.04043998705920414],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.9492067688690977, 0.5394711792460651, 
                0.10728609198218791`]], {113., 25.}], InsetBox[
             StyleBox["\<\"English\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.03558718861209964],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.3383114092015346, 0.5643508726387724, 
                0.8209736910418415]], {111., 59.}], InsetBox[
             StyleBox["\<\"found\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.04043998705920414],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.8168067340273636, 0.3521386531945273, 
                0.3761554432877274]], {-112., -54.}], InsetBox[
             StyleBox["\<\"Asian\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.04043998705920414],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.35558897405758294`, 0.5505288207539337, 
                0.8417067688690995]], {36., 120.}], InsetBox[
             StyleBox["\<\"Bureau\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.03558718861209964],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.8335801463353031, 0.3487839707329394, 
                0.3481997561078282]], {-33., 122.}], InsetBox[
             StyleBox["\<\"white\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.04043998705920414],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.7896667828057927, 0.3575666434388414, 
                0.4213886953236787]], {-46., -115.}], InsetBox[
             StyleBox["\<\"times\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.04043998705920414],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.9930578157165594, 0.7227890785827968, 
                0.01874389756528967]], {67., 121.}], InsetBox[
             StyleBox["\<\"Perry\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.04043998705920414],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.2187618985811806, 0.715, 0.5074848563512248]], {108., -92.}],
             InsetBox[
             StyleBox["\<\"French\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.03558718861209964],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.529922539669161, 0.44454647619850335`, 0.85]], {77., -122.}],
             InsetBox[
             StyleBox["\<\"fruited\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.03558718861209964],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.9986489531525362, 0.7507447657626809, 
                0.0036478264881522893`]], {105., -109.}], InsetBox[
             StyleBox["\<\"Check\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.03558718861209964],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.922066817647527, 0.5213778784316846, 
                0.08286013588277422]], {98., 119.}], InsetBox[
             StyleBox["\<\"small\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.04043998705920414],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.6897400905885174, 0.358, 
                0.5753998606330502]], {-108., 113.}], InsetBox[
             StyleBox["\<\"nashi\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.04043998705920414],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.428777913273419, 0.5052332520359486, 0.85]], {109., -122.}], 
            InsetBox[
             StyleBox["\<\"genus\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.03558718861209964],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.6453361616656581, 0.37647057236169945`, 
                0.6741595958358548]], {19., -123.}], InsetBox[
             StyleBox["\<\"Neck\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.04043998705920414],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.9784200278733908, 0.649600139366954, 
                0.058265924741844846`]], {-115., -121.}], InsetBox[
             StyleBox["\<\"juice\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.04043998705920414],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.6536293927965667, 0.37163285420200276`, 
                0.6534265180085832]], {-120., 22.}], InsetBox[
             StyleBox["\<\"flesh\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.04043998705920414],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              FontColor->RGBColor[
               0.9810598048862722, 0.7553955338762525, 0.]], {-121., -24.}], 
            InsetBox[
             StyleBox["\<\"days\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.04043998705920414],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.7132613816472081, 0.358, 0.5392132590042952]], {120., -30.}],
             InsetBox[
             StyleBox["\<\"sweet\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.04043998705920414],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.47929071933511125`, 0.715, 0.1759027208462221]], {1., 125.}],
             InsetBox[
             StyleBox["\<\"forms\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.03558718861209964],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.8633598745697435, 0.40996018814538476`, 
                0.08339968642435877]], {125., -2.}], InsetBox[
             StyleBox["\<\"Like\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.045292785506308636`],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.16397784358994957`, 0.7038177251280403, 
                0.6117734123079395]], {-121., 34.}], InsetBox[
             StyleBox["\<\"broad\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.03558718861209964],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.9307395679624266, 0.7498043964402695, 0.]], {-122., -36.}], 
            InsetBox[
             StyleBox["\<\"five\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.045292785506308636`],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.8857244243136628, 0.3764133635295058, 
                0.1393110607841571]], {-125., 0.}], InsetBox[
             StyleBox["\<\"grow\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.03558718861209964],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.6672593867853922, 0.7205288207539324, 0.]], {-9., -127.}], 
            InsetBox[
             StyleBox["\<\"color\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.03558718861209964],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.5788038738141875, 0.715, 
                0.049249615145579635`]], {121., -45.}], InsetBox[
             StyleBox["\<\"cider\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.03558718861209964],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.6670481226429111, 0.3638052617916352, 
                0.6198796933927223]], {125., 35.}], InsetBox[
             StyleBox["\<\"3000\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.03558718861209964],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.6319174318193065, 0.38429816477207124`, 
                0.7077064204517338]], {-35., -129.}], InsetBox[
             StyleBox["\<\"wild\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.04043998705920414],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.19193353076984873`, 0.681453175384121, 
                0.6453202369238185]], {47., -126.}], InsetBox[
             StyleBox["\<\"long\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.04043998705920414],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.9038177251280404, 0.3492734123079395, 
                0.18454431282010084`]], {36., 132.}], InsetBox[
             StyleBox["\<\"hairy\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.03558718861209964],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.9107287510704583, 0.33890687339431275`, 
                0.20182187767614543`]], {-63., 124.}], InsetBox[
             StyleBox["\<\"food\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.03558718861209964],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.4177882075393331, 0.715, 0.25417864494993975`]], {128., 8.}],
             InsetBox[
             StyleBox["\<\"end\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.04043998705920414],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.37977756485605163`, 0.715, 
                0.3025558265468435]], {-27., 132.}], InsetBox[
             StyleBox["\<\"fully\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.03558718861209964],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.8064401951137368, 0.3542119609772526, 
                0.39343300814377197`]], {-128., 49.}], InsetBox[
             StyleBox["\<\"room\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.04043998705920414],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.8607200975568693, 0.34335598048862614`, 
                0.30296650407188447`]], {-63., -126.}], InsetBox[
             StyleBox["\<\"best\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.03558718861209964],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.31827505306025683`, 0.715, 
                0.3808317506505822]], {-115., -81.}], InsetBox[
             StyleBox["\<\"tall\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.04043998705920414],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.8745421494417032, 0.39318677583744527`, 
                0.11135537360425793`]], {-126., 61.}], InsetBox[
             StyleBox["\<\"de\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.03558718861209964],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.7658565873730018, 0.358, 0.4582975578876895]], {131., -14.}],
             InsetBox[
             StyleBox["\<\"79\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.03558718861209964],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.38354466123747527`, 0.5323732032575149, 0.85]], {129., 46.}],
             InsetBox[
             StyleBox["\<\"57\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.03558718861209964],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.9046334610863751, 0.334573307782725, 
                0.22977756485604156`]], {119., 71.}], InsetBox[
             StyleBox["\<\"40\"\>",
              StripOnInput->False,
              FontFamily->"Helvetica",
              FontSize->Scaled[0.03558718861209964],
              FontWeight->Plain,
              FontSlant->Plain,
              FontTracking->"Plain",
              
              FontColor->RGBColor[
               0.7175796237092107, 0.7261199581899123, 0.]], {-122., 73.}]}},
          
          Method->{
           "DefaultBoundaryStyle" -> Automatic, "DefaultPlotStyle" -> 
            Automatic},
          PlotRange->{{-140.5, 140.5}, {-134.5, 139.5}}]}], "}"}]], 
       "ExerciseOutput",ExpressionUUID->
       "b8b6a218-eb0c-4561-be7d-b605c1573ea2"],
      Apply[TextCell, 
       Cell[
        BoxData[
         RowBox[{"{", 
           RowBox[{
             GraphicsBox[{{}, {
                InsetBox[
                 StyleBox[
                 "\"apple\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.24734982332155478`], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[0.368417, 0.506779, 0.709798]], {0, 0}], 
                InsetBox[
                 StyleBox[
                 "\"Apples\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.21201413427561838`], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[0.880722, 0.611041, 0.142051]], {9.5, -51.5}], 
                InsetBox[
                 StyleBox[
                 "\"cultivars\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.0706713780918728], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[0.922526, 0.385626, 0.209179]], {-5.5, 30.5}], 
                InsetBox[
                 StyleBox[
                 "\"fruit\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.10159010600706714`], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[0.560181, 0.691569, 0.194885]], {-0.5, 50.5}], 
                InsetBox[
                 StyleBox[
                 "\"varieties\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.05962897526501767], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[0.363898, 0.618501, 0.782349]], {-0.5, 72.5}], 
                InsetBox[
                 StyleBox[
                 "\"Commercially\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.03754416961130742], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[0.428777913273419, 0.5052332520359486, 0.85]], {
                 58.5, 43.5}], 
                InsetBox[
                 StyleBox[
                 "\"characteristics\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.03754416961130742], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[
                   0.6536293927965667, 0.37163285420200276`, 
                    0.6534265180085832]], {-60.5, 43.5}], 
                InsetBox[
                 StyleBox[
                 "\"disease\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.04858657243816254], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[0.40082222609352647`, 0.5220066643438841, 0.85]], {
                 51.5, 56.5}], 
                InsetBox[
                 StyleBox[
                 "\"production\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.04196113074204947], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[
                   0.8857244243136628, 0.3764133635295058, 
                    0.1393110607841571]], {-72.5, 28.5}], 
                InsetBox[
                 StyleBox[
                 "\"generally\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.044169611307420496`], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[
                   0.838355547812947, 0.44746667828057946`, 
                    0.0208888695323676]], {-54.5, 57.5}], 
                InsetBox[
                 StyleBox[
                 "\"trees\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.061837455830388695`], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[0.772079, 0.431554, 0.102387]], {24.5, -81.5}], 
                InsetBox[
                 StyleBox[
                 "\"rootstocks\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.04196113074204947], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[
                   0.47401116530937026`, 0.47809330081437784`, 0.85]], {76.5, 
                 27.5}], 
                InsetBox[
                 StyleBox[
                 "\"century\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.04858657243816254], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> RGBColor[0.915, 0.3325, 0.2125]], {
                 0.5, 88.5}], 
                InsetBox[
                 StyleBox[
                 "\"mythology\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.03754416961130742], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[
                   0.47929071933511125`, 0.715, 0.1759027208462221]], {
                 86.5, -26.5}], 
                InsetBox[
                 StyleBox[
                 "\"Commercial\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.0353356890459364], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[
                   0.31827505306025683`, 0.715, 
                    0.3808317506505822]], {-24.5, -89.5}], 
                InsetBox[
                 StyleBox[
                 "\"Collection\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.03754416961130742], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[
                   0.9038177251280404, 0.3492734123079395, 
                    0.18454431282010084`]], {57.5, 70.5}], 
                InsetBox[
                 StyleBox[
                 "\"produced\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.03975265017667844], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[
                   0.8564488486273256, 0.42032672705901153`, 
                    0.06612212156831418]], {-59.5, 70.5}], 
                InsetBox[
                 StyleBox[
                 "\"Davidson\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.03975265017667844], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[0.7678998606330495, 0.7317110956258943, 0.]], {
                 50.5, 83.5}], 
                InsetBox[
                 StyleBox[
                 "\"important\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.03754416961130742], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[
                   0.6897400905885174, 0.358, 0.5753998606330502]], {-48.5, 
                 84.5}], 
                InsetBox[
                 StyleBox[
                 "\"Europe\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.044169611307420496`], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[
                   0.28026441037696703`, 0.715, 
                    0.4292089322474965]], {-92.5, -26.5}], 
                InsetBox[
                 StyleBox[
                 "\"Significant\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.0353356890459364], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[
                   0.8949268664259606, 0.5032845776173072, 
                    0.05843417978336459]], {28.5, -95.5}], 
                InsetBox[
                 StyleBox[
                 "\"commonly\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.0353356890459364], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[
                   0.845266573755366, 0.437100139366951, 
                    0.03816643438841502]], {-0.5, 101.5}], 
                InsetBox[
                 StyleBox[
                 "\"tree\"", StripOnInput -> False, FontFamily -> "Helvetica",
                   FontSize -> Scaled[0.06404593639575971], FontWeight -> 
                  Plain, FontSlant -> Plain, FontTracking -> "Plain", 
                  FontColor -> 
                  RGBColor[0.528488, 0.470624, 0.701351]], {-100.5, 4.5}], 
                InsetBox[
                 StyleBox[
                 "\"including\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.03975265017667844], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[
                   0.35558897405758294`, 0.5505288207539337, 
                    0.8417067688690995]], {-19.5, -102.5}], 
                InsetBox[
                 StyleBox[
                 "\"found\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.05079505300353357], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> RGBColor[0.571589, 0.586483, 0.]], {
                 66.5, -80.5}], 
                InsetBox[
                 StyleBox[
                 "\"year\"", StripOnInput -> False, FontFamily -> "Helvetica",
                   FontSize -> Scaled[0.055212014134275615`], FontWeight -> 
                  Plain, FontSlant -> Plain, FontTracking -> "Plain", 
                  FontColor -> 
                  RGBColor[0.647624, 0.37816, 0.614037]], {-65.5, -75.5}], 
                InsetBox[
                 StyleBox[
                 "\"storage\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.04196113074204947], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[
                   0.16397784358994957`, 0.7038177251280403, 
                    0.6117734123079395]], {-96.5, -39.5}], 
                InsetBox[
                 StyleBox[
                 "\"Golden\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.044169611307420496`], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[
                   0.5833680111493557, 0.4126186601628758, 
                    0.8290799721266107]], {-47.5, 96.5}], 
                InsetBox[
                 StyleBox[
                 "\"goddess\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.03754416961130742], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[
                   0.9492067688690977, 0.5394711792460651, 
                    0.10728609198218791`]], {47.5, 97.5}], 
                InsetBox[
                 StyleBox[
                 "\"controlled\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.0353356890459364], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[
                   0.5750747800184488, 0.4174563783225715, 
                    0.8498130499538777]], {27.5, -107.5}], 
                InsetBox[
                 StyleBox[
                 "\"Aphrodite\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.0353356890459364], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[
                   0.7277983389807635, 0.358, 0.5168487092603637]], {-14.5, 
                 111.5}], 
                InsetBox[
                 StyleBox[
                 "\"used\"", StripOnInput -> False, FontFamily -> "Helvetica",
                   FontSize -> Scaled[0.055212014134275615`], FontWeight -> 
                  Plain, FontSlant -> Plain, FontTracking -> "Plain", 
                  FontColor -> RGBColor[1, 0.75, 0]], {102.5, -9.5}], 
                InsetBox[
                 StyleBox[
                 "\"University\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.0353356890459364], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[
                   0.9107287510704583, 0.33890687339431275`, 
                    0.20182187767614543`]], {32.5, 113.5}], 
                InsetBox[
                 StyleBox[
                 "\"produce\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.03975265017667844], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[
                   0.37977756485605163`, 0.715, 0.3025558265468435]], {99.5, 
                 56.5}], 
                InsetBox[
                 StyleBox[
                 "\"cultivated\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.03754416961130742], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[
                   0.7513196300394465, 0.358, 
                    0.48066210763162087`]], {-76.5, -92.5}], 
                InsetBox[
                 StyleBox[
                 "\"genome\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.03754416961130742], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[
                   0.3103557220216354, 0.5867154223826917, 
                    0.7874268664259625]], {-25.5, -113.5}], 
                InsetBox[
                 StyleBox[
                 "\"flowering\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.0353356890459364], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[
                   0.26512246998569167`, 0.6229020240114467, 
                    0.73314696398283]], {76.5, -94.5}], 
                InsetBox[
                 StyleBox[
                 "\"develop\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.03754416961130742], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[
                   0.8342400905885153, 0.4628267270590103, 
                    0.0038160815296638794`]], {-93.5, 82.5}], 
                InsetBox[
                 StyleBox[
                 "\"cooking\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.03754416961130742], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[
                   0.9784200278733908, 0.649600139366954, 
                    0.058265924741844846`]], {-100.5, -52.5}], 
                InsetBox[
                 StyleBox[
                 "\"organic\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.03975265017667844], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[
                   0.9637822400302223, 0.5764112001511111, 
                    0.0977879519184]], {96.5, 79.5}], 
                InsetBox[
                 StyleBox[
                 "\"grown\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.044169611307420496`], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[
                   0.8439466852489265, 0.3467106629502147, 
                    0.3309221912517893]], {-100.5, 54.5}], 
                InsetBox[
                 StyleBox[
                 "\"rootstock\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.0353356890459364], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[
                   0.8064401951137368, 0.3542119609772526, 
                    0.39343300814377197`]], {-60.5, 109.5}], 
                InsetBox[
                 StyleBox[
                 "\"reactions\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.0353356890459364], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[
                   0.529922539669161, 0.44454647619850335`, 
                    0.85]], {-68.5, -105.5}], 
                InsetBox[
                 StyleBox[
                 "\"orchards\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.0353356890459364], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[
                   0.4177882075393331, 0.715, 0.25417864494993975`]], {91.5, 
                 93.5}], 
                InsetBox[
                 StyleBox[
                 "\"Malus\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.046378091872791516`], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[
                   0.736782672705901, 0.358, 
                    0.5030266573755369]], {-102.5, -66.5}], 
                InsetBox[
                 StyleBox[
                 "\"popular\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.03754416961130742], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[0.5019668524892619, 0.46131988850644284`, 0.85]], {
                 70.5, -106.5}], 
                InsetBox[
                 StyleBox[
                 "\"States\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.04196113074204947], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[
                   0.7748409210981391, 0.358, 0.4444755060028629]], {-102.5, 
                 66.5}], 
                InsetBox[
                 StyleBox[
                 "\"group\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.044169611307420496`], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[
                   0.8996399512215667, 0.7463488834690629, 
                    0.]], {-102.5, -8.5}], 
                InsetBox[
                 StyleBox[
                 "\"research\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.0353356890459364], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[
                   0.9986489531525362, 0.7507447657626809, 
                    0.0036478264881522893`]], {-90.5, 94.5}], 
                InsetBox[
                 StyleBox[
                 "\"America\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.0353356890459364], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[0.38354466123747527`, 0.5323732032575149, 0.85]], {
                 74.5, 105.5}], 
                InsetBox[
                 StyleBox[
                 "\"species\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.03754416961130742], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[
                   0.8781534541180211, 0.4921023027453475, 
                    0.04333810870621905]], {-101.5, -79.5}], 
                InsetBox[
                 StyleBox[
                 "\"Different\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.0353356890459364], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[0.9307395679624266, 0.7498043964402695, 0.]], {
                 104.5, 12.5}], 
                InsetBox[
                 StyleBox[
                 "\"variety\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.03975265017667844], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[
                   0.8168067340273636, 0.3521386531945273, 
                    0.3761554432877274]], {111.5, 38.5}], 
                InsetBox[
                 StyleBox[
                 "\"National\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.0353356890459364], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[
                   0.8774935098648088, 0.34000129802703827`, 
                    0.2750108168919853]], {15.5, -119.5}], 
                InsetBox[
                 StyleBox[
                 "\"England\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.0353356890459364], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[
                   0.8335801463353031, 0.3487839707329394, 
                    0.3481997561078282]], {-9.5, 124.5}], 
                InsetBox[
                 StyleBox[
                 "\"number\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.0353356890459364], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[
                   0.9603267270590103, 0.5591336352950514, 
                    0.10711783694067224`]], {104.5, -76.5}], 
                InsetBox[
                 StyleBox[
                 "\"North\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.044169611307420496`], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[
                   0.28240003484173815`, 0.6090799721266095, 
                    0.7538800418100857]], {-45.5, 123.5}], 
                InsetBox[
                 StyleBox[
                 "\"United\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.03975265017667844], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[0.9810598048862722, 0.7553955338762525, 0.]], {
                 53.5, -122.5}], 
                InsetBox[
                 StyleBox[
                 "\"known\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.04196113074204947], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[
                   0.5407932311309059, 0.715, 
                    0.09762679674248334]], {-65.5, -117.5}], 
                InsetBox[
                 StyleBox[
                 "\"Greek\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.03975265017667844], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[
                   0.8878600487784333, 0.33792799024431336`, 
                    0.2577332520359445]], {-114.5, 37.5}], 
                InsetBox[
                 StyleBox[
                 "\"brown\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.03975265017667844], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[
                   0.6184987019729621, 0.39212575718243875`, 
                    0.7412532450675947]], {72.5, 117.5}], 
                InsetBox[
                 StyleBox[
                 "\"called\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.04196113074204947], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[
                   0.9324333565611593, 0.5282889043741062, 
                    0.0921900209050434]], {-99.5, 105.5}], 
                InsetBox[
                 StyleBox[
                 "\"include\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.0353356890459364], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[
                   0.4567336004533182, 0.4884598397280091, 0.85]], {-79.5, 
                 120.5}], 
                InsetBox[
                 StyleBox[
                 "\"seeds\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.04196113074204947], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[
                   0.9874666782805795, 0.6948333914028977, 
                    0.033839968642435214`]], {88.5, -117.5}], 
                InsetBox[
                 StyleBox[
                 "\"human\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.0353356890459364], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[
                   0.8926354502560807, 0.366046824615879, 
                    0.15658862564020168`]], {114.5, -87.5}], 
                InsetBox[
                 StyleBox[
                 "\"aphids\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.0353356890459364], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[
                   0.969373377466199, 0.6043668873309952, 
                    0.08269188084126262]], {-107.5, -105.5}], 
                InsetBox[
                 StyleBox[
                 "\"allergy\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.0353356890459364], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[
                   0.9046334610863751, 0.334573307782725, 
                    0.22977756485604156`]], {113.5, -99.5}], 
                InsetBox[
                 StyleBox[
                 "\"Pests\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.03975265017667844], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[0.7132613816472081, 0.358, 0.5392132590042952]], {
                 110.5, 105.5}], 
                InsetBox[
                 StyleBox[
                 "\"leaves\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.0353356890459364], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[
                   0.15725938678540247`, 0.715, 
                    0.5857607804549424]], {-100.5, -119.5}], 
                InsetBox[
                 StyleBox[
                 "\"genes\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.0353356890459364], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[
                   0.5788038738141875, 0.715, 
                    0.049249615145579635`]], {-19.5, -124.5}], 
                InsetBox[
                 StyleBox[
                 "\"stored\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.0353356890459364], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[0.6672593867853922, 0.7205288207539324, 0.]], {
                 105.5, 117.5}], 
                InsetBox[
                 StyleBox[
                 "\"aphid\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.03754416961130742], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[
                   0.23716678280579248`, 0.645266573755366, 
                    0.699600139366951]], {-115.5, 19.5}], 
                InsetBox[
                 StyleBox[
                 "\"Norse\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.0353356890459364], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[
                   0.3383114092015346, 0.5643508726387724, 
                    0.8209736910418415]], {115.5, -41.5}], 
                InsetBox[
                 StyleBox[
                 "\"sweet\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.03754416961130742], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[
                   0.6319174318193065, 0.38429816477207124`, 
                    0.7077064204517338]], {-112.5, 117.5}], 
                InsetBox[
                 StyleBox[
                 "\"high\"", StripOnInput -> False, FontFamily -> "Helvetica",
                   FontSize -> Scaled[0.04196113074204947], FontWeight -> 
                  Plain, FontSlant -> Plain, FontTracking -> "Plain", 
                  FontColor -> 
                  RGBColor[
                   0.6753413537738198, 0.3589675436319385, 
                    0.5991466155654507]], {114.5, -53.5}], 
                InsetBox[
                 StyleBox[
                 "\"world\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.03754416961130742], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[0.7175796237092107, 0.7261199581899123, 0.]], {
                 115.5, 66.5}], 
                InsetBox[
                 StyleBox[
                 "\"eaten\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.03754416961130742], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[0.8493197142977551, 0.7407577460330839, 0.]], {
                 25.5, 125.5}], 
                InsetBox[
                 StyleBox[
                 "\"early\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.03754416961130742], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[
                   0.596786740995709, 0.404791067752503, 
                    0.7955331475107271]], {125.5, -21.5}], 
                InsetBox[
                 StyleBox[
                 "\"fresh\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.0353356890459364], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[
                   0.6670481226429111, 0.3638052617916352, 
                    0.6198796933927223]], {124.5, 23.5}], 
                InsetBox[
                 StyleBox[
                 "\"small\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.03754416961130742], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[
                   0.19193353076984873`, 0.681453175384121, 
                    0.6453202369238185]], {9.5, -131.5}], 
                InsetBox[
                 StyleBox[
                 "\"fruits\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.03754416961130742], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[
                   0.8607200975568693, 0.34335598048862614`, 
                    0.30296650407188447`]], {-127.5, -21.5}], 
                InsetBox[
                 StyleBox[
                 "\"cider\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.03754416961130742], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[
                   0.6361597700445392, 0.7170733077827265, 
                    0.]], {-49.5, -129.5}], 
                InsetBox[
                 StyleBox[
                 "\"seed\"", StripOnInput -> False, FontFamily -> "Helvetica",
                   FontSize -> Scaled[0.0353356890459364], FontWeight -> 
                  Plain, FontSlant -> Plain, FontTracking -> "Plain", 
                  FontColor -> 
                  RGBColor[
                   0.2198892179497479, 0.6590886256402017, 
                    0.6788670615396974]], {-19.5, -26.5}], 
                InsetBox[
                 StyleBox[
                 "\"plant\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.0353356890459364], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[
                   0.8633598745697435, 0.40996018814538476`, 
                    0.08339968642435877]], {36.5, -134.5}], 
                InsetBox[
                 StyleBox[
                 "\"large\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.0353356890459364], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[
                   0.9840111653093676, 0.677555826546838, 
                    0.04316985366470745]], {41.5, 134.5}], 
                InsetBox[
                 StyleBox[
                 "\"form\"", StripOnInput -> False, FontFamily -> "Helvetica",
                   FontSize -> Scaled[0.0353356890459364], FontWeight -> 
                  Plain, FontSlant -> Plain, FontTracking -> "Plain", 
                  FontColor -> 
                  RGBColor[
                   0.922066817647527, 0.5213778784316846, 
                    0.08286013588277422]], {66.5, 129.5}], 
                InsetBox[
                 StyleBox[
                 "\"wild\"", StripOnInput -> False, FontFamily -> "Helvetica",
                   FontSize -> Scaled[0.04196113074204947], FontWeight -> 
                  Plain, FontSlant -> Plain, FontTracking -> "Plain", 
                  FontColor -> 
                  RGBColor[
                   0.8613800418100862, 0.48092002787339083`, 
                    0.02824203762907758]], {-125.5, 80.5}], 
                InsetBox[
                 StyleBox[
                 "\"Asia\"", StripOnInput -> False, FontFamily -> "Helvetica",
                   FontSize -> Scaled[0.03754416961130742], FontWeight -> 
                  Plain, FontSlant -> Plain, FontTracking -> "Plain", 
                  FontColor -> 
                  RGBColor[
                   0.9052934053395919, 0.510195603559728, 
                    0.06776406480563275]], {-75.5, -131.5}], 
                InsetBox[
                 StyleBox[
                 "\"new\"", StripOnInput -> False, FontFamily -> "Helvetica", 
                  FontSize -> Scaled[0.04858657243816254], FontWeight -> 
                  Plain, FontSlant -> Plain, FontTracking -> "Plain", 
                  FontColor -> 
                  RGBColor[
                   0.9728288904374106, 0.621644452187053, 
                    0.07336199581899142]], {62.5, -134.5}], 
                InsetBox[
                 StyleBox[
                 "\"day\"", StripOnInput -> False, FontFamily -> "Helvetica", 
                  FontSize -> Scaled[0.03754416961130742], FontWeight -> 
                  Plain, FontSlant -> Plain, FontTracking -> "Plain", 
                  FontColor -> 
                  RGBColor[
                   0.2187618985811806, 0.715, 0.5074848563512248]], {-129.5, 
                 0.5}], 
                InsetBox[
                 StyleBox[
                 "\"long\"", StripOnInput -> False, FontFamily -> "Helvetica",
                   FontSize -> Scaled[0.0353356890459364], FontWeight -> 
                  Plain, FontSlant -> Plain, FontTracking -> "Plain", 
                  FontColor -> 
                  RGBColor[
                   0.7989994773739094, 0.735166608597101, 
                    0.]], {-129.5, -33.5}], 
                InsetBox[
                 StyleBox[
                 "\"skin\"", StripOnInput -> False, FontFamily -> "Helvetica",
                   FontSize -> Scaled[0.0353356890459364], FontWeight -> 
                  Plain, FontSlant -> Plain, FontTracking -> "Plain", 
                  FontColor -> 
                  RGBColor[
                   0.6453361616656581, 0.37647057236169945`, 
                    0.6741595958358548]], {46.5, -26.5}], 
                InsetBox[
                 StyleBox[
                 "\"size\"", StripOnInput -> False, FontFamily -> "Helvetica",
                   FontSize -> Scaled[0.03754416961130742], FontWeight -> 
                  Plain, FontSlant -> Plain, FontTracking -> "Plain", 
                  FontColor -> 
                  RGBColor[
                   0.7896667828057927, 0.3575666434388414, 
                    0.4213886953236787]], {127.5, 77.5}], 
                InsetBox[
                 StyleBox[
                 "\"UK\"", StripOnInput -> False, FontFamily -> "Helvetica", 
                  FontSize -> Scaled[0.03975265017667844], FontWeight -> 
                  Plain, FontSlant -> Plain, FontTracking -> "Plain", 
                  FontColor -> 
                  RGBColor[0.5472001045252132, 0.43417993728487203`, 0.85]], {
                 130.5, -0.5}], 
                InsetBox[
                 StyleBox[
                 "\"late\"", StripOnInput -> False, FontFamily -> "Helvetica",
                   FontSize -> Scaled[0.0353356890459364], FontWeight -> 
                  Plain, FontSlant -> Plain, FontTracking -> "Plain", 
                  FontColor -> 
                  RGBColor[
                   0.7658565873730018, 0.358, 
                    0.4582975578876895]], {-130.5, -45.5}], 
                InsetBox[
                 StyleBox[
                 "\"nuts\"", StripOnInput -> False, FontFamily -> "Helvetica",
                   FontSize -> Scaled[0.0353356890459364], FontWeight -> 
                  Plain, FontSlant -> Plain, FontTracking -> "Plain", 
                  FontColor -> 
                  RGBColor[0.7042770479220728, 0.358, 0.5530353108891188]], {
                 129.5, -65.5}], 
                InsetBox[
                 StyleBox[
                 "\"like\"", StripOnInput -> False, FontFamily -> "Helvetica",
                   FontSize -> Scaled[0.0353356890459364], FontWeight -> 
                  Plain, FontSlant -> Plain, FontTracking -> "Plain", 
                  FontColor -> 
                  RGBColor[
                   0.6102054708420535, 0.39696347534213544`, 
                    0.7619863228948663]], {-129.5, 49.5}], 
                InsetBox[
                 StyleBox[
                 "\"old\"", StripOnInput -> False, FontFamily -> "Helvetica", 
                  FontSize -> Scaled[0.03754416961130742], FontWeight -> 
                  Plain, FontSlant -> Plain, FontTracking -> "Plain", 
                  FontColor -> 
                  RGBColor[
                   0.8745421494417032, 0.39318677583744527`, 
                    0.11135537360425793`]], {131.5, 48.5}], 
                InsetBox[
                 StyleBox[
                 "\"raw\"", StripOnInput -> False, FontFamily -> "Helvetica", 
                  FontSize -> Scaled[0.03754416961130742], FontWeight -> 
                  Plain, FontSlant -> Plain, FontTracking -> "Plain", 
                  FontColor -> 
                  RGBColor[
                   0.9930578157165594, 0.7227890785827968, 
                    0.01874389756528967]], {-0.5, 135.5}], 
                InsetBox[
                 StyleBox[
                 "\"life\"", StripOnInput -> False, FontFamily -> "Helvetica",
                   FontSize -> Scaled[0.0353356890459364], FontWeight -> 
                  Plain, FontSlant -> Plain, FontTracking -> "Plain", 
                  FontColor -> 
                  RGBColor[
                   0.8510135028964549, 0.47400900193096995`, 
                    0.018912152606809424`]], {-129.5, -57.5}]}}, 
              Method -> {
               "DefaultBoundaryStyle" -> Automatic, "DefaultPlotStyle" -> 
                Automatic}, PlotRange -> {{-142., 141.}, {-141., 142.}}, 
              ImageCache -> 
              GraphicsData[
               "CompressedBitmap", 
                "eJx8vAd4G9e1Lcx3nXpLXopznWo7uYlTXuK0e1N905zYsRM7xXHvtqxiFata\
\nvVqyuqhGiqJIsffeewMJEiRIggABkmhEJXrvff17ZgBKcvL9+EQBmDlzZmbv\n\
tdde+5wzeOL1nevf2vz6zg1vvn7/o9tf37p+w5s77n/kne206a7/k5WV5WH+\n\
7s9iPoM+pv/zgF60g3u7wL7dhZhOiIBKxn77FPv/f9B/KaScIqS8RnCvJFIO\n\
MVIBJ/c16kJSUYW4uBBJwxSzO+tf2GM/gpR7HkmHhmsX9yBpEiAVif7szrMG\n\
R7Jh76lFKhHP+nB6WzIWTZ8NWR9n//8s/RdDrOPniE1cTO+KINb+MOLzndS7\n\
kz7/BpHKH1KbPyNS9Hlql8tcPJDwIdb8XURqn2G/pjTFiFz7N8TlvKw7LuVb\n\
CE3egPbYIzDlvoGVa+8iFgjB25cDn2gG7qbdMF5+Febyd2HK2QDvRCdstfl0\n\
v3Rh+hHYumqQ8KhhuvA0vPOi9CVGEev6FWKCK7cuufMPiC8MICk/h0jp95D0\n\
+tg9KW0Voh2vIhVOIOURIlL8GUTKvoukL4jExBpE8rIQHTydueTvsW+fQcIp\n\
R8xmwq1XCjGjAImAm/w5jICgCCHZCFmXDOFYQCIUQNJvQGimHGE5HzGTBBGN\n\
kLFM1n+nLe0LetCulqNOrYQ+FEMkGoTKx12mxeeGNhBkP6vdDjhicdj9LrRS\n\
+3GrDTKHGWK3ByafB4ZgCBa/B7pAiHzK9P1thMgrugtvI2rRwX79WVi7q+Co\n\
3AVbQx50e/8Hfp0Gft45aA6/hYh2FLrjm1kTR5eqoc8/jYi8hY7fjngw/P9j\n\
4scQXxxEQriRTPxtxIUXEZ+6gPj0ZXq/gVQogaTsOKK1TyPa/Di5o4WO+SNi\n\
PesRqXucMJr46Z1WDk+fg+3G6yx+2FdIDfvFH8M7SNuz6b3/EhwFj8M73Apf\n\
yyvwLwrgrXkCjoot8DRvgeXUvXD13GCt/KE0xhOJWxi/K/1/KhlHPJFgv/3L\n\
6h7yaJxtm/UV9v//RCIexN7+JmwVCHBJOIznR8YxrprDzulptsPC6SEclSyy\n\
0fruYCtqdCYcovedkxM4MtGPnzdV4abGgILpYZxbkOPmLA/H55e4y/g0gmNX\n\
YO9r5cwrrYS55SLslXvgHOyHq2kXTHkbYbr4Z+je346oaRL60ztZ08SUjTAU\n\
nkdkqRmGgjP/kr7aVR+N56RvOE5R+ijno5lNiJR8FXHBGcQnTiM+TFAv+iqS\n\
FjPi/Y8gOp6HxOQ75KffI1rzUyT004hWf4felXf46NPESCrYLj0Ev6CWUNIN\n\
f8821mdRg5QigI+ofgLuqr/BWX8a3tY15KMJeIp/BQ+vDDGzAs78nxH7LdyV\n\
djmSIcwvbkU7/wl0Tb0Eq88JleowtG4tfO5BdI3/Gt2C59ArfBZKmwIh/xT6\n\
BI/Q9icxJD6CUDyCJfk+LFlkWfemDRGPhzGgUUHucqBNMYNHOjvRI5/F/lmO\n\
L0pnh/H+/BLrtn3D7ajRGLGjtwlFGj1UDhPW9DRBEoyijNpdXJSjdG4Up6Xy\n\
1djiX4Yu+20kgn64qt4gt12Do2o3XCMj8PRcgVcyB9/QOWjfI3uahNC++yiC\n\
JiuCvLMwlmcjLKuH/tpRJBPJW7HV8zAiFb9G0q5DyiVCtPR+8tswUiv1RFFf\n\
RUJDl56IITG9i9r9AkmbGNFyaqOaoTaNiOT/H0TrX2LbxLp+Q6x8Pe2377Nv\n\
n4K/9SWYT/8ArvrNMB/7DDxjPUh6FuAqehz2G3+Ep+MsYi4XfM0vwS+fQ1w/\n\
BnfNBrhq11HsfQ1+xXxWxmlW0zXUj/waFo8cYula9IsuQSh6GvPmEQyN/xDj\n\
ymq4vEK0DnwJwuV+CKZ+DL6iBr6AHhOzL2NxRYwp4eMQLI+uOo2hzgoy9DO9\n\
7dg2Poo+ixOLWgneFnCxVikawSmpnP18YLgNdUYnFowK7OEPY8/EEJ7sbIAo\n\
EP7nTvt/iEjrYTjzB8o3a2A4/xrCVjucFVvh5k+Ss8gxl17DypUXYB9oovyi\n\
hPHs3+n7GuhP/Blu4Qi1fQ6qbT+Bd3HmltP6n6Vg+TH9/YhyyH2IVJEDHRY2\n\
8BJTWyjgvkb7fkD7HkR8iZKDuR2R8p8h6SJiD8pZJ0d5+WxviZk9iDZtQiqF\n\
rJ/c6bk4WdN+cw3lFTlF3i9JCgRoWxWsF36CsEYCf+9u+CUz8DU9R54TEYte\n\
grv3JkXiJByXv4GAenHVc6rlQxgQX+UyWCJMOcgK4ezfIVlpRtfo3+CKsKwI\n\
GYXkhKISHcP3oX3yNYzMbsagcAsW9QIIZ/4CoXZy1XNMP9u6a3FhaRkC3QL2\n\
iBcwr5XiFy316DTqsX+0HU8MDGJ0RY9XexoxYvegZH4cVxUazFs0eLazHtJQ\n\
5J977gsUpFyYxN12JKLcZ/vN9cSSfM5yXjtiXg/nlFSSsSCRipe2eblENV8B\n\
fd57t4UbSS3fCqWfEIWamOTSKFJ+F3e6T5DqmkPSOERKzMa1jriomY7TOEz3\n\
REypkC+NATd9NzD7PuAzJFxwFTwBZ+nTsJdtZC8KcT/8fQfgLP47nHXvIk65\n\
Piy8jrDJQLCRwF35HBwlT8HdeYWUWXzVZzrdUbROrGXzs9fFg0RdhynRs5Ca\n\
e9Ez+hCUDh1jBvCFj2JK3Ylh/gMYWcqB1TWEgfHvY3ShCdOzf8LQQkla+X2Y\n\
Mpsb86qL6Jx+B5PLLYgmU1l3r+aRFMQrCmzi9WPtSD96KBLNDgNOz07gwHg/\n\
NvDHUCSbxZrBThyZEyNMDlLadNg+2of1I73IpkwXpz6KZoZu9+fH2O7vQmCm\n\
A8FlPfstsy0V8SBqt7Df/sxZ8gfpXSHeARh3ZsE3K0hb5MO4JRBIIoydQ0ir\n\
Snf1WcTDC2SVH6BT8Aoah76JSWUTROJXsGRfhF57AjUD30WP4ClU9HwWIv0M\n\
LKY8NI88jIHp59HM+y0pLztmZ/+Myr770SuioExg9bx2aws6ZrdA5xhA18Rf\n\
INBOrOqHGCWi9Is0Ofd/giIjcdu1MgknEvV/lt39IeQJB0gWLKJgdoRkweJb\n\
d9540qtHcKoOiXA43eFdiCp6yE7222x3N2IRPfTmFhgdQvZkZnMHbAEH60YH\n\
QcDkmMT0/JtEtsPsJXhI9eosXfCE3Oz3QFALj38BJuc0czx3r5+jbq3gS3ag\n\
Y2Yt6kYfw/BSO6IRBXqmnkeT4AV0zh1GMBaCeGkfNF4znc2LcfEuOKMhKDWn\n\
0TDxHBoFz0NmnUXAN0UIfgJtwlfRMbcTvljsM2kbLNqMmCchK3esYM7l/kQm\n\
6ENLSK7cRMJQQBEmThvPQ5J9Nh2JhDDfNFKxAL1TDmSUG8VcytZI0UlASpH+\n\
tpTT8Tdpvyod9xHKm2RQYxn1Q7VWQPu/nMkfS5t3XrYDCruS/Zbxq0L1HuFk\n\
iv32b2nbKDVnUDOxCQ7quW/yrxRt7RAtbESr5Dq8IRP481uxYJFhdPpJSBzL\n\
dGYX2nm/h8LchfLhx2HwrsBkqUav9AKWdMWUL5vh9inQyPsZpkxLX2NP80XK\n\
EVOIj9+N+MxTiEueQIz3BWKrMTKOgBL8b9hig7np+DQjCChlTz+EJLFkynKF\n\
2t6HpFOChOIVxIR/QGJxAwnD/0f7F5HUbaHPXydBTu9j9yAufS/rA5ZIEJoT\n\
HPGuWiJBsiqeTNxhCbH8AAYWmlnz6vXXMSqrprt+AmVjz1D0bEbz5NOY0Yxg\n\
bPYZyNxMbetBN0k9yXIhCvu/jy5q0zPzKpqE++H0KzEqWY/aMQYpu2ANBjKW\n\
SKheQmz2pdXAT+r3U7lBhUJgAvHJR25ZYuY3nCVm6d3jICJ/Hwn1NSLqZcT5\n\
X0DCLqfKj/KIhuSusY36+DHBhFOFyeW3qcg9lrHEF9i3j1MMx4gdM6mDhRHC\n\
8Tj3iWg9yTESG+9hQmHytnhn6olgPP5g2lhqgk2tgJJ12IEx0UsYWmrB3OIm\n\
1AtPUPTJ0ML/LXiqAfBIGvUrGuEPzqN2mPS/fRhlg7/GolkMheYCisbWQKY8\n\
gvKxP8NIPp5eyoMrGv54OqRS0ciqoVKpZKbYBxU9Ca6cS/PJh1hCSkbSBVKm\n\
KZl74a9ILJfdumNfH2KTj9E7j8z9KJMG6Ugvmfu3ZG7RbeY+RcdR9REWEwCp\n\
9ifejUvfoHa/RlxBlcf076gdN6KRst+kfScy5v7PTOBTYZkt4WEhFMY8Fc1v\n\
TjRiDf3la5XwU5Y4JGzBhqk2HJ7rxvqpXpiicchtMmyaHYSHQUEqhrKlQTqm\n\
if7aMESSdlQzidfo+6bJZuRrlihVgsP0vQQcP4xuKWJJ7lC9g0cZQAujax6R\n\
tGBwesWwB13cZ880JlXXSf/UwhsNps0TIzfw4WG/J9jP7oif3eX2L1FtbmU/\n\
x2M2GKhfItl/TyMiGTdjePZ1NE2+inr+HzFLRBOLKIlkn6HQeRFtlID80TBE\n\
so1omHwejRQ6HZKzBLIEFMsn0ThB2wTPQGKeRigwhy7hc2idfAGts/sRTMS5\n\
u7wPofE2uNv70lcbgevaCXiGBAhOtMB8ZDes2WdhOXMArqFRUpPlsJy7SNzT\n\
CVdvL6JKESxHdsJ8YjfsFXV0yRG4y84jbKe7jTjgzMvhRhnOH4D51DHYcs7B\n\
cvkCieoWqsV707mTwdQzSGjrbgVHcBzxqT8SpsYQG/0MheE4UkEpVajfITVE\n\
7zMMmVko1A8QiZ2hYHIQ9r5BFWkPhfAKYenbhLVriM/9DgnldbotExKSh9gQ\n\
visD74ASKfJWSp6LlFPOmeNuShL9SClok7ELq/k5YkaKSCmloj+vbtWxKVMz\n\
tb1BslBILD7PbaZsmVLmUbf051bd/0EEB7FhrAk8qxavjFaj0WqFwa3BHkJ1\n\
h2YafxmphTbgxRVxK14S8llCuTDTgG913cCA20d5fBFP8+qhCnoxqp/F6YUx\n\
nJsfxZjLCbFxGo+ONBDqUxkEx0MSFPLXwEuUtLJSgDOd3yU134P8oaexEuBQ\n\
OCR8Bl2qUXjcQ8jp/Q6qhTtRTcrxBn89/ITyaGAa2R2fRa96lOhAiUudn0Pb\n\
EjcwMS7djDpJNYdmWyvyRl6GP4b/YE/PDVwGw16Ob1KpVbv5Qo5VlZZkthNn\n\
+GkbmTudUD6KcMSJUGxVNpFCD8FDBQlRaNqF9yHQmg9rfim7PzRaieXHfgp7\n\
TTNsp7fA0cpHbHkWxo3PIrC8AkfOPoIwBe5YJSwFubCd2QlnBx9xuwHmgxvh\n\
FYhhO7UJQQNVBkETzLu3wjdA1cG7hwjCVrhzdsNcUI7gIIVAUckHoFt7G3TH\n\
CLqPEw7EbAaJzz5CsP0J0d1WIl83ErINVMgLCKJfR4z/Par3CDuORjrm59T+\n\
dwRZylzRKImQboL0j6jdY3T8A4jLTqVt8yXCox7J/m8hMfo6ktPrkOj+GeHP\n\
gpT+KhKdFCKT65Ho+SrtO81iNznyCySG/47kxJNIdP2Q2hoItweRaP8WtaXj\n\
u+g+Bp6ja9cg2fsAEmNUUEy/QX38ktqa7/tHDG+daEWfXoYnB25iw3QPDoi6\n\
8JKgC0Ky5glRB7ZNd+HFkTK8LZ5FlCTX60QmxfIx7JHOQGiaxS97i7Fb1Icd\n\
wjbsJuxPWRTYLGjEq/wGnJXPI5paZeF4WIYi/qvQO+cp0X0PLYtNSEZVhOFn\n\
YE5jeGTmJfSpRjA1vwZlM+c5nMVNKOp/EEKLEjpjPs60fRG14ovQmetwseOL\n\
KJzaycb35MI2NM1zDvTYO3Bj9E0Gww9kMNZeCFtRNZJ+I0w71sF8bBucTe3k\n\
5lZYTh6mQvswDJteRMhsh/P6EfjmLYgKamG5fhnW01sRtHCJwH3zAlxN/bBf\n\
2I4Qsy1sg2XPOwgbVLBfPk40S3l+1yuwVDVRWVMFS2l5GmOfJcxQytVU3YYx\n\
SrUTv6ZQilHmiLLFY8qvJr6ipJQimWFp4ypYzWbEl47Sdk6SUHlA7bRMWKax\n\
RDQYI2EcJH6zFzH0uAoxRmOLT4FNfp5JJLtJHqq7kBz9FZKLtZyGcAqQnD2J\n\
lO4GQfA3BDVGZ5OOlp4gumwhiP4PkhquEE9pzxHEnqXTy6hf8lCc+nURo3R+\n\
k1h88p9A7J3xFvDtOrzOq8RNjQoikxi/HKrBrMuMCzIeZpwmXBK3Yf3cNPqX\n\
R7GOKtBgyIYXxxrRZ5DgqeFKjNtXUL/Qj1cF7dg7Vo6jcjH1I0fV8gJVoasQ\n\
SxCt3Rj4Ns533Y/8sbcQSDCZUEYQe46EZoi9Ad7sywSxIRKrL6KH6DJNZujg\n\
/xK9qmHwRK+ice4cKiY3okO0DY2ibBTxnoElFMDUwg40SxvZI7yOrgzEuNN/\n\
mDwYQ/2YGrvqpDjRo6aKKZZ13yr8bsJeWgnXDYJaGcm+5nw46lspQbbD1daF\n\
sEyAlW0vIKg3wXF5H9yTakT4aYo7RxVXL/ku4Ib1yDZ4BiZhO7YGroFpxHQz\n\
WHlnNyGCqLEgByGlHK7cPbBQFg/xqm+D30eR1B5B0jxwC35hCdHRNtJHqfRI\n\
OmnDBFEbVakpHxWXYQUDx/Ss0f1EZW0ktEtvHU8CJaXJQaL/e4SbHyI5tY1N\n\
q8khoq4BUo1jL9DfX5Hkv4LkHGX4ji+ntz2LBO9hwtwZakfC3s0VqSlXF2Hr\n\
GSZHIKW+QP0+SP3+CEmqE1Lh8D/B1hZ+E6Z8fkjNUmwg8bdO0ITcZQWBMoar\n\
km4Ske1YT4Kw025C4Xwvmq021tk3xD3ot1tQr+RhraCF/lox7HBAYJzBxslW\n\
vDXegEKtigmOW/S1iBL+s6jmP47rvKdIi1NOiyqQN/AQxDa2nET7+KME4TEq\n\
E7egUHCAgSaSMRPR3YMYWW5G6fBvsOhUoG38tzhNASNzkAoUPIExwyxESztQ\n\
NHmI0a0wm0qRO/wi/PH06T8Og96B091qyMx+1Awv4XCvFom0GyIkjykMVwda\n\
gmGqZjjJk/YdMxuSRDCayJAFi8lgTzmMW9+CYde7iAUTCDRehaO2jdTgFCyk\n\
BK3njlBaLkZkiQfjhr/AdC4bwRlSjP2DiKrmiEJJMR7fA+v1IiRCQbgKjsB8\n\
+hBMB7fAXt1KtEYqtOAkzGeOkrI8gIBUgzCP0m5JOcNMLKZYOXH76ElYjkTb\n\
fxI3kYr0awgHlcRhHsLQL7g0GCDq0xLmur5P2Ctl02TKpqG2y0gMfpdwdo7w\n\
R20VHRym1Cdo+/OEYykSrfdQuiTFQxSbUlVQv5E7MPURFlNrR+sx5k4PK8ZI\n\
rEQjGanpDvnIJxwHxxKJTNynKA7i6Xvwhv0kypOr9bSfagRHJJz+loGSFCWC\n\
zXCSVOqf/j3y+S/C7J7BjaEfImfwUZTz/4LzPd/BktuEoH8OhYM/RvH4OlSM\n\
/BQFgq2Q60txZeAv8NFJZxbW4UT37+AhAEgU+1E1cxJT8r040/19lI6/gNy+\n\
b6J67iRimUT8lTRNqXCwZRFH6iXY2qJEKJ5AA5+jrt21UvRr/HDZ3IRiI4vi\n\
kM+HS6MGFlolQwrsaqB2dTJMmsJwWl1sO+Y1KV1B2TRXCjXROYb0IZgtLuyv\n\
m8f+hnmc7tfCE0tlrc6OdRdB/fhD8IyzU+XwV2XDVs4lcSbzxZ2uNDpilF33\n\
wyMkN+tF8E7Nptv4EbM7MkkwxRTmlCTjxCirsUvE7CJNSlfOvEJ9BTDfLMni\n\
BP2XmKFlJMcfR4JkSJL3ayT6HmLnjWFrJJBRsqSYT3Tfi6SkgNoGSGdRDu9/\n\
mGvbS7rKT6cyXCcNRjqNR7qs427q60W6YDcRHZUtIy9wum3g99Rv7A7A3cXe\n\
V6dWCmM4mvV5dtuXWXgUT6wnhmEEtRc6xwghzwKrTw2bZx7z+npoXIurURMM\n\
qiHRVUNi7EWAVESUiiSTZ4ndHwwbYEh/jtB2i1dO6lsPm18HtbkL88YeBGLR\n\
tD++AsmCARuqFqjaDqJ2WI43auQEMTPerpJi2R2GTGHGyT4tlpQWHOpSgRlV\n\
8FP1vb1FgSGRHhtqFqCjdoI5LTbWK7BI7Q93c0NzXRNKnOjjqq6cZjEqJE5c\n\
bhCjWOyEwxtCXvciepcD6Wv5CJHrLNwdnasFR1QmREC88OG0rxMOqhsjFHnq\n\
GXgnZz6RtmhsWQTfrCRDLxzdRW3ko3oijAYyiTPDqfBJiEtqiT/YtRbci1yc\n\
WiHu0hNPBB1Zq21dE1RK0sXorrH6h6MHklv6OuqDJEHInT5d1g/TVxIPz+Pm\n\
+FtwRpLkVc6+fdPLuMSzcExHIN3dpkDzhAYvFIooI8hxrluO82RfqdyMYyQh\n\
mNgLuF3Y3a5ADUmLq3zu2BQR084qGXgUb+/1LLPb+iZVODvIjrnjets8imYs\n\
2F48g3dblnC2U4H325bQveTJeiZ9fSlXByH5KVZFfu3OS08lQ7CTwCSCWb30\n\
CbEWO5qVbNZZVpuxsUGOUbERb5VLMGvyY0Kqx4ulMszJLQQXGayk/a1GK7Y1\n\
y9Ep1GBfu5qFodfhwrpyGaYXTVhP7bx0EubS93Zwt5HbQtCYd+Jk1Szypm2Q\n\
W3w4VCNCjtCxen1uewS+ADdy+dHVbVH4g9y2ezLhFafg9LDziZlb/Fv6dsKB\n\
IA7VzWFbvRSby2fxNqHVHYjgcqsUe5sWsbtqDnlCG8wrTrxROIXdDTJsLp3B\n\
+bEV+PxBHKgV4wAx6A46NmfKihWDHa8XCLG3UYq1pbPYWCXBzloJmUcMuTcG\n\
8YIRmyskON66gK01Mii88fQA60dZ2orFbs+CKYQCcXaJQ+b2Urd2ryaXJJF+\n\
KJBIx0s6aoi7EneMZKYQCSczKyWYrrsqjZgQBVe7ZuVvhQGT4lDWrzgrfTaz\n\
K0EVbJBb2/QL9v8vUG9RSPQeaJ0hWL1cZR+PxYmXPFiwBFiAMN9NnjC0Vh9E\n\
ei9xDHf54VAEMxonJKY722nIyVLa5gtFqR831M5w5iZX7H7M6jywBzMG+zo8\n\
y340Z+tQf16H0X4vIr4oevP0aLqsQ9N1E7z+JKS9dszPcKJ/qs2CZV0US4M2\n\
2m+GZtoF/gA3neiQ+9B4VofGizr0NzrIEUkI6qmNMoD+MhtiZGRRkxn1F/Wo\n\
v6CHUkUU64mg86oODTkGNF0yQDITyMoIRcaa3VVGNDXZIBx3YVGZXl1DKXZx\n\
1g3eoBMqHWe2znIDWprtbLslFdeO4bT5KTdmZ73QqoPsvQTdERjMMcRpn3jS\n\
DeGkF0ZDCDKpHzZLGEZz9ME7HZciPRHlnWAhxI1y/xsZP6MYuVc0klwdyU6k\n\
h8ji0SQzF7s6fJNK4c4XbQh+AJoMVGOcACLfgKsjqBOZ2od+kQsiXYgdQef6\n\
fIAdJurL0WKk3wf3ShCtZMHBUiNai60IeOKYKDJgoNOF8aoVjA9wIwO9BTrM\n\
i0MYKtZDIAjBNGFDS42NvZ7uyxrwR/xElBE0ntGQ1/3ozdVifs6DmjMrMEnd\n\
KH5fD7sjBu2UE0NdLkxR323ldvgoy7afWcZQt4fLO19Gf5Ue77+nRkeLGWfo\n\
fU4RwlQHFanntOhpt+D8+8uQkwMHqg04eXwZHc1mnKZ2kuUIRF1mZJ/WopkA\n\
cHQXkzvDUI1ZUFBlh6jHgquX9OilPi4fV+BakQVT3SbcKLdlpb3HrRT8PFKB\n\
ZSriSVVrBpE08ZEQFyPatQGJpTr662AmxigsqdKyazmnEMclPVaknGLa7maz\n\
WGKpgiq5ViSNs6wST9mnEZ/LR3yBGVSIpdPsf7GDGD3NNoTJgVE/WaPQgIpc\n\
PaoKTHD6ElgYsqGE4qqhZAU113QQ8H1Y4tlRStvKrhqgpLgyytzsZ/6gHbxh\n\
LyXDMOopPiqofV2pBcEIKVUyjUwTZeNjuMoMvSmC3gojKvLpfNcMJBUiq+iZ\n\
mLJgy3UVivpN2HpdSUW3/xZ6iN26yOPLFg7N8UgcI8VGTA5zSLHNONBRbwW/\n\
2oQpXoDdNkCokUpCGC7TQ7YUg3XKjvYGbvq085IGOjvHmBOVKxB0u9Gfr4NM\n\
7EFDtgmqERvy96jRVWRC53UD2sltvXkGzPK5vmUNZoz2eG4P/y4i00E+dzni\n\
XhNKykwovaqBRMtp0MlmIxq6HegilAwLuG5mO8m8rXa0lhowNh1k+6kmEE/L\n\
wlDzrSiutWOyxYSbpURN2hB6ynRoGfFCwaCrwpYG0CfZNybgKSS7nkR04DDi\n\
4/sRKfpvxMbyEKn4PmK884i2PI4YvxRJVSGi3Zc5CpjZj9hUK+K8NYjLR5CY\n\
2I5I21rExo8iXPAjJFQ9iDY9jrioBLGeV4leSjMY8mt9KCObMAw210k3W2qF\n\
1xPDRIcZAqEP1SfVGJsNwLbsw5WjGsjJtoVntVheiWJhhPGFDYIeE1o6PZDy\n\
KLJrqRYnI9U3ueCn5Nl5U4e+IR9GKnQYl4VZ4zRd0GJu2o2+Nhvc7iiGCEtV\n\
xbb0PN0TxIlBmAi/HuJqlYXj22gohgVjiNUhDkcIvUIHhhZ8JJtTdJ4olq0c\n\
PmUKD7pnnJDpg1BZuWNDFBv9Qjv66NoXaLvVn4CRYsdC52DOZfZxeLQ7wli2\n\
RWGifcNiNyaVfrT1GXCE6CRTJTKs1Z+rwWCPF0EXUUmRka5/BS03rQhRJT5N\n\
wOhpcWKCWKqxwAafM4qWCxosKcLoJyacEYVhoWu5eVwHsz6MnqtalgEj/hia\n\
ya4iitEMhusvmGCl+yk6qKGcFoSk3YTyHDOEtWTvYq7vrnMa8Ho9WXeC2Ai+\n\
kAPn8oQV128YUUqAVFi5WFGOWlBBvNFB7SZmucFRFUnbklor2mnb5By3rb3M\n\
gGkpB+LCShtxQwTdjWbUVZiQf5Zie9gDOR13o/IfQZwgoD1NwD2N5HILInXP\n\
ICHvQrRvN7c8wD1F4F1LLEcg7svlQCw6gpiwA/GxTYgvtSDa8DyxJDevF2ui\n\
8kwrRNIwRGBuQLT9aUSHLq6CWOdDRYERTIzyCWhXTmrRUm5CVa4OA70eLE04\n\
UE1kVUtC49IxLeRTLlQRKXIxTSqL0utU1wr6xwJQCiiS6xwYqdJROc7NvS6O\n\
2dBc7cBojZ62caBqzdZCaYhgjki2mABdTkQ4vxBKD9F8g+23uF6NanEQ45Nm\n\
vE+5hnlZlqnmKtWzAHw3X4HTFCwHC5TI7qc8M2PH1R4rNMsevH1JjkttRmy7\n\
uoj9zSZEo3FcLFNiX6Ue11p0eP7sEtrmAyhpWEbDXIA9V42EE01dg0Zc6rFB\n\
JnfinTwlLrYY2H7eqTIhsioRvg6XJoBGVoxRfqx3IkRibLDAgAYSTI1XV+Bw\n\
kvAZtqPxnB7NjEC7YYVpyYvSPQrU51MikLjRRMc25a9Au+hDyyVKNiTGuihn\n\
hoNxdJNUkBKQ684a2WGt+TYrGi9T31cMUKmjiFNg9lDCas41oHS3CmMD3tWZ\n\
pS5iyeyL1E7hR9FFNXpGPeip1qOEgLisCqDwvBpDUz50l+tx8bKRbVd4QY1+\n\
gQdtBNzxGQ7ETTfJZxIOxDfpuqxk28JiM3SaIOpzl9HOIyamgDi6X4nRCS/8\n\
4VTWdz6Q01d4iE9dQ2xkNyKljxJq2xHt2cGV8QySu95AYoGQ3MOtyU/MHkJs\n\
pjON5FZEGwnJNgeH5Oa/IKEbR7TzGTpuG+X1CkK5YTWn+/V+5BxVk+tCmO0x\n\
o+CyCQZSYS3XNWjt9kAxSdAc80K35MHV94iHyewFpzVQr8Sgm3UR99jAa11B\n\
x4AXMpaPnZhuW0F9g5NVkb0EvS7i6hEyb32zEx5nGCUntFDLvbjy3jIksgDm\n\
Rh3/AOWyxmXUzQcxKbTgXBtXylo1buwnKdU5aqaiaoXdFnSSawgyE5M2FA5Y\n\
MTJpwZl2rv3kOJXGxKUGLcE7fxl2NpKSuFSpRrM4gPImDZronTlX/TwH5T7e\n\
CnK7LSikbQWT3Lo+ocCMHcSv4eStkblENAGfJz3JkuZpnyvGTnKwX9NyOeSL\n\
p7cl0V+oh0gcXh3FZAowdg/TlzvdVyyB9oskAEQeVJ2gPJkW4mF/nCn8Vudw\n\
qHvGvHM1Jgx3uTMglgqcaKWKpIKUWWOLHUEqpmIUZO3VRpTk69He7USUUots\n\
gto1cO2a2xyIULvZEQcUGo6ApoccUOljxNxWRjKQ1o9jgCqb0ht6VFdZ4PAl\n\
YSEPdpOlq0pXoLMlsj7HXsNHmdtBjJnQU2m4G6XCMKbXkhJNZf3HnUBPzF9A\n\
pGM7ElLSG0S/Ce0oIsVfIR1xgTTJ30g3XEFSU4bwje+S3riCaM3/Iq6VIj5K\n\
ukNJYndqHyLNaxHn76I230HCICC98hQL8ljXq4hJJ26JV1sIjdd1KL6qh1ob\n\
RD8l0arretSWmOEKptjbqczRoZbM1NpCxR3xh5QERzFxTCkdMz7kRNV5Fa5l\n\
66kIc0IwRkmUatomas+I4OoiM9yBJOYoiCpvGFB5RYv6ahsiVIiNERdX07nK\n\
qQhcNsbSQP/XfwR6GrgOKmIZoDcPreBCp41z+hep8kpCMmvDjX4rhgnnFzu5\n\
4VOjyoUzHUwd6sIuEpSZJxzqeon65vyrOC+lUzVIOZwPjK3gaifl0vpltC5x\n\
9aRF7cSeGg7nXGa9iyol5kkUrmLjBg4+zOpqucANK2klKd/LzihkKjyT1Itl\n\
JXuO1aHLxUEzrpVY0xhl/v8YU7zCd/0gHMf3w3ViK9yVdVSP2OA5sxHu0roP\n\
AAVxL+XzWsSnbxCzKShKfEiujBMLViIubaGqJUEC9QYiLTsQlxQhvjjAhkjS\n\
OIyk28E+VpBYouMX6xGtfwQJM+HRTUCaukrbepmKe3UtLFPXciVuCgGK3lv1\n\
6F20LwG/j43U9LZPktqLIxjiwn6qYwU9wz7YiFXFovR6IKpvvWTFTP2cShfK\n\
QeonkRlrvwt+EsFRbuzjDiIsYfNsENMzFryZq4bSHqW8bcUuEn4zEgc25qmh\n\
IfJQyh04XL8CfpoIBwVUf3ZwAFkhgJxsoyLNGcLWKwoMq5ix9gB25sjZnF5K\n\
Ob2RAUitCgeJPmwkpEuaNcgljdBKgvQoiTCbJ4qaFi02la2wOf2X6ev2WkJQ\n\
LIfTxmD+/xwSxkUE2msRnhUhMksxrVIippSRF4KIKSTsUEFcOQN/Ww1Ck0Lu\n\
ebEVBWIWut5kGOHJfgQHehHqr4f9yBbEg8yUnwqOd9ciavJyy6XSgxV3Iamm\n\
aB8pu80pdyEhPI64TnbHtljPOiQsGvbbPWk7M7QaJLxbNX5SDsFP32b4Lgq+\n\
PlUY0kUH9hYv41jFMrbkKlA17WUXj9d167H9hgrb85WoE/kwL7azkTkpIdIY\n\
4bKvhTLPddrG3OA4Vao7qEI9Vq7BJhJJbdIAeodXMETR0tWnx/4yLQ6XqPFO\n\
vhqzpihC3jDOl6uxr2SZPeY8CSwKxPQ8HROFfgTGL8JesR6unlwkgqH06rm7\n\
4AtQVjU4YAlE07f/efaZQdfhN+EqLII39wgsbzyJwBgPzhObEVlW0PtGhEV8\n\
2Hetga+lBq4jb8E3NIVQ3ftwt3Sy8/zey3vgPHcS7lPbYd36BrsSIaEXwvLU\n\
j+Dp4GV9wDOM41KR4B1eSDGrg+KxO7eFaFv6AawH01SzqPRAZomxpBenOAkE\n\
YrC4Y9wh/8Z6yOqMwOrl8qaEQuJyh4VtHolx0ch4KRzNzLD9K7yUCT0kE2vJ\n\
2jWiAElCL5bsMXYcL0nh6aDa0BVIrE4RxRMs6hO0K5FIZRZOJvwOIq/wbTfw\n\
YSSdQjhqKAlpJuBpfBnOgeK0LT5GNxahlMhJfzb+YyEkY+lSIBHLrOVOJVeH\n\
3NIkeT9sDht2NE/g1LAEW9qmILByRRbzoIHrxAZ4qusRHq6D/cA6RA0auE69\n\
g4hGCde5HfCWnITtyCFEpngIthXD3zuBYP0peDoH2Kl3xyGq15nuQkY4z+xi\n\
XRmsPgn7e1vhfP84M7POjaFm/T3jTTJ5zwhJvaUQm7uYbSo5KfIpV/pWObsN\n\
T1swTKDuISnVqwpzVP5Ndqmxs+wvsBa9CNuNR+Hsvkp2DMHb8Q7CNh18vQdg\n\
K3sT9vzHYO+5jKiiCe6xYvZ+Q4Lz8M0NwD+WjcCiBAHBJYQMZtIZVfAIqhHT\n\
DsBW+ASsBX+k772IqdthK3gS9qo1cFS+CGdbDrwDZ+hY7uk8T+9BhM1WBHh7\n\
YKvcTe5NL3T/KiW7CBbtAQJRFGIzN/CrtzpQM6dGt9rGcB/7Utvc0FM9wSwI\n\
Fq84EUmnDInejFqJBoIV7thlmwcmAh1j0EWLC36SUkv0zgzGJygOZCbyZcCH\n\
9nkthjVW3BgWIltkzERtZKoHvtoSeHIPwrrjdUR1qjvdXHEO1s1vw9daC/e5\n\
TbCfykOw4SzcdR2UT01wHH4LMWZ8KWqBM3svYjZ6P/A2IotLFOGbEFoyp8fK\n\
sw6kHcXchaf5JdjqjiMR8CPhVsKW/3v4ZWK4qv4Gz/AZMvRriDmN8LW9AXvX\n\
RWL5fNja3mfvONC9Be5Rckz7Nvim+fD27EJAoUNUdBn2tiNwEAg802OIm8dg\n\
L98MZ+XTsLecpPPoYct7mHm0A54WuiUhs8w+AWfVCwgqluCsfR4+sfhDaUdZ\n\
HBa8O6CAyWnDhhYxdHYb1tXyUTSrwqF2PnIkJtbouxsGcHTKAIPZgN8WDWCO\n\
Eq18WYMNrVNoEBPfNk5gjBx9uX8GTWoPM/SDA+0TkNq8ONw+DnmIyMfjwu6W\n\
KUgIM5uo/ZWJRaytHMSFuVVH+YuOwXmV4NlwjXIWxZNVB2fGUae3IrwogmPX\n\
WviaqomG6X1oGqHmMzC/8Ed4m2vguboXzgun4b2yG9btaxDktcK+Zw872xgs\n\
P0y0XZ9xFDf2+QASPjdMfWMw9E2z46gMsl0zYui7J+CUqeE3kNp3OOBWmIlp\n\
orBPzMG1YIBnUYdYmONN35ISPhNX5ySDfpiH+ND3CuFRamAZlSLq8dNxIriV\n\
diSIpk29o9B2jsNn5tY9xJxWGNqHYeTNwSFSUk0T/8FtOIoaZhH3hVnfhiQV\n\
sFz6AQJLUrhrn4W7fTfs3dlsNwljNxz91xARFcDRdYHDUd8OeMaq4e3cSZiY\n\
gLd/LwIqkrdzObA374e97CmE3ZycTYb9iC5TH1UvE6bWwHTmQQQIr962LfCJ\n\
5tg2ztrXEFQS7BteQ0BtzODISnewb1gFi8uO7Z1SDEsWcGSCm2G02ExY3yaB\n\
2eXEupoR7O2XoXlyAc9VDqFWZcFNcuL+oUWM6WyoFi6BZ7QjZ0iEdi2Ho6Nd\n\
k5ARjo53CaAkHAU9bhzpmEGzUIITQm6CW7CwRDgyZHCUCroQGmghbdSEmMmF\n\
lIdwdHwjl6KPb2A5O7GyCH9rFUIzIlZLJcwqshyfaHKULOFDaKgNQT6PLKJC\n\
3EhOUXJzvUkPaTepMoMjbp7zG5Toglh8Pxezp6shO5uH6XO1cIrEmFj7PhaL\n\
mjC+7iCkRWNwjAxg+mQjwqZlTGw+CR1PhJkDN+A1hyitOzH51l4IL3CraSxd\n\
LZjYXwhVTRcm3zmGySN18C3OY3zLKRgm5Fi6kIe5Sw1QltZDsK8QXpMF8wcu\n\
QpRdh8VrRRh64SgcRl96HvcbSLoofEoeh/nKI0Q+f4V3vIkyaRDO0j8RSC7D\n\
UvAcYXEF/u6NsHWeR2SuEOZrT7Pb3DUvUlbog7d9C7yCAbgp4/ikMkRmsomQ\n\
jsJZ/hQ8411IOMRwVL9KnNhFiiqfwCuG7foj8M/PUYi+AnvDJcSdy5RZHkFQ\n\
R+6ofAY+mTQrgySH24ZDI2rYqeJgkDTKIGlczdrDTmy1sX0eQ2Ly9pQKV4en\n\
8GrTFJoXtDgysojC4WmsI2TUEyPtbeDhsljLIqmOajrEw6tIOtIxgaUABRbF\n\
/sG2WbTMSHFikpvbmVmSM0jKlGkpjwHuK0cR1Wvo/TDVTAnmKaLbPR/TyzG5\n\
LxfsTwvEfdC1j8LQ1g3x5V62R1NTM6Q3R+EcG4LoXDNCegVEF6tIkAUhOlQI\n\
vyMK9+QohHuuYHJvPhUxEZhbmyA8UQfXogbKglLIyqYpay1AdLUBwZVljG8+\n\
A+MEhaFMgeW6HphGRjF1uBARdg2cH6IdF+AweFZX7QcjNvRretGg7MS0Q/Mv\n\
6UtfJmc1KFsxZJKwg+V6khc2yt3JhA8Sp5rlTVvAAGPIB3vACJXPyWYThWMB\n\
flJ0obAdKu8KS5piEx/Nqm7MOrmQ1LoWYY9y464u/zI61N0YMc0zj0XSvgW4\n\
SL5ZvQq0qrpIk0kxaxFCTO8q5jnSVVn4TQT618Fa8SZZliPLkLgGMa8TvsEj\n\
iBDd+Af2wVZCwCqlrDrdRrKlk+T8s/T3KsmklxB1OhAUFsE/Xglr7k9hbzyE\n\
8FINsWEHYoZx2IqeYoPBNVCGhFdNmZLYr5IkVO1GSvoBBPhnYC+ibcV/h6Px\n\
DCLKOphPk66s3c2IY+4y/4s1weD8El5sEKJftcxi1+x2Uabjo3huGUc7Bbg8\n\
o8X5PiFatW50CsT4W62QZEsAhzsm0UmefqdNiFommzaMY9ziQd6QEH+uGEXV\n\
nAbHuqewYPdhV/0AdvRLcYVYc0ffIowuB9Y18FEgVOCt6kGcFRlvjTGkqKL3\n\
+9mygHlnlp58ALxR7SIBJx/h9Kx50GyHpa8P83lD7HfHyBBkBF4HC94WhAl8\n\
cwTeWDzAgdfmg+LCNagGl6ApKIa8U8Z6R1XSiIVrtRDuPQ9ZuRAxoxxzOfUI\n\
GFQYX3sEkovVWMyrw+T2s1DUd2HmfBXSK/0g2X8ZDn1meuRBujYDDo/swr6p\n\
XJTLyrFpcCeajDJKNrPYOrwXdYoOvDd2GBVqAUqmj6PbbkE0KMMm/hV2mrVX\n\
WYkKus8hVSWypTzqNIxTI/uwEI7CaB5ErrQRQkMnto9dQIuqE7vHjkBIlHdz\n\
6ggGCD2xiBEHRw7gmqwOh0f3o0w5hkLhe+i3KnCS9y7yltpwc+4SXujbhwZJ\n\
IU4SQlefh/pXYtFsWK7/CQFJI3w9O2HK/i3RiBeBySJioEzqDXLNP7H6xEcq\n\
EqAShxPKofk2hI16UoMb4OwqZX8exS9LLxGnUijh963WdHR4glkktzpSgrQu\n\
8aY/R+CseR0BpW51WI8BxqRChVeaZzGp02NTm5gd/7K6XKiZUaBbRVUzYWjJ\n\
7ICDtLvP6yVZ72OPk1uccEWT0FrsqBMvY9bK6SCt3Y0pHRUxaguEGgvcRE0K\n\
iwNCrZn4WQOdnxthW3E4qYrXYZrkv8EfyXrgA2k15IZo3xks1o0RLvshOFoI\n\
bXM3JFe5hdW2vl7MXx+Bgz8M0Zk6WEeGIdibAydJL9HBm7BPiSDYcgFeVxRe\n\
0tGTR0rhnBZDfLYMriU1Fs7lQlY1BcdQH6XQXDjVBkiOXYGieRJ2wSQmtl2E\n\
XU63tecs5I3jWGnrxOhrx+E0elfxOaQqw05B/uqQ4bKpj75fRfNSNbLn+9lt\n\
RssQjhF+86fPop8q0mhwAdsnrrH47FfXoVonx+hyDXIX+KyLskcPYYnwuWId\n\
wQ1pLQqm38d74iZMmKdRs1SLUZMSpTPvg+fxwmwdwD5hIXsej59MaZ5H4fRJ\n\
DNpVyB4/iCLVIHi6dmwevQKRtg2nJXW38Pkx9rnf0GwRHBVPw9l8GBELM+kV\n\
R3CGakJfiBsq+QjCC12IrJgQJ553d+WQlhpDUD6dWQiY8FnZYh+49Wx3gLTu\n\
FjJayZwSxwYWmZtNj0ZSi1gYBaMSaEPJ1W3MMEfqjpXUH0KSyjoWt8wq9WSS\n\
O92qeg9pFJBlF2PuVDHMsxr4qTbV93GLW31SKQzDS3DwiLpOVUJ5oxIjbxyD\n\
dlgMI6lv28QsVA2j3LruEFFWeS+CNid0tS0EjxJIr7dRbnZDffUmHfce9AIN\n\
VX4GLFwuZ+FjnOL0bUAhg/RcEWTX6yCkvEvQyCCjXpaLAvU8Vl9kalvYjT5F\n\
Jc6Ku9hNJuswlVY5yBOeQbeNjBiW453xq+w8Z7+qGlW6JYwtV+OSjHnWPIFz\n\
vP1YpMJjxTKM6/M1uDlzCjvGr6ONUvte3m7kLo6ibOYksaANdjsPeyavs3k8\n\
HLZAQTn5xvQJjLpskFHlWCNvRz5VlGuGL1CQtmSQ8WDaH55ACI5QFIFoPOvT\n\
Gb8xczQETOahM04CfwFxDR/Ogpvs7UQJpK6ODoT5VbAefIFq6c2wU90dM2vh\n\
LjkA5pH+6Fw9XK3tjFPhrblMZbUT/rr3YD2+FvZLe2E7tQauuqtwlXHPyEWm\n\
a6jQ6eLGS9KDWx+l0O/BzJlGRGxGLJR00BVFIS9oRcAdXV2HH9UrISvtYm7q\n\
tvV3SczvuwS7zp11y1E5uLjEv81RCXioHGIWAO8a3o8qRReOjx1CKVF/ifAI\n\
1o2eQcHcVbzQ/TZy5iuxj7cPXRYD+MuVeLb3XRRTmnq1Zz2OTN/E2YnjyJUP\n\
YIlCeRcd10iCa8foMUy7zLg5uRcv9B9Ep7YfB8eOIlfWiBPjh5C32IUiciKf\n\
1HC77BqOz9WiZakU2ycLIKFQPsU56q9pB8SWOmB97z3OWOM3SK/kwXn6bXiH\n\
J8nYTTDv/gsixDC2Uy+B0gUifKqvC0tYUzhz9iEknYN135Pwi6gGmqmD5cDT\n\
CIzVwXb6DNtneJjMVVT+AQdEbGY45Qb2YYc4s947FYNdJCdui916EILSRpxb\n\
C36bAxJUGi0iQu0yDlhY6cbaoSNQ+JkRnxQm1NWU729yacijQMNSM6lHGatS\n\
V+j7nFWEruUhKD16KhwH0c/UyARNR2AFYpsUvcv9EDvUpEoFaFvmwcEOHqag\n\
cogox/dg0cPNEhncCsxYpiGitr6wFW2KVvQaZhBKxLFIitQcZWYU3BjVDaBV\n\
PQgjVYZqQxtOiKtvcSjdWCJEt1SPlaEyBKwuRO0yMkUboqsrvz6CRNABC+8G\n\
FFUHoW6hqmlh+taq+Y+wDxE7yfaqmsNQ1r8P81QfYplnUj+CmEsLY+9VKCr2\n\
YaniAFaYEbpo6nsZBMi7YD15mkPAZDGp1Ty4Lu5EQEpVa8wGx6W3EdGQIj/H\n\
DThHBAWwl3DPxjmvHUDEYEeg8zLt3wLbyZdhPvIyAoIm2C9c4hAwSogprkgj\n\
4InVa46hffEmNgy9iy2jB7CZ9x7z8Nm9q1wRRfN8AWa83tXfDtOa+pGz0MlG\n\
ZMZ63plC8Nf/G0a3/BBmsRKOgf0Y2fBZOEzOdJvPkTTXYuHCw+Ct+yJmzzyJ\n\
6YMPYmT9F6Boq0/PkAahKX2d9n8KwuOPQvT+L8F765MQF+wDM1CcDOgwf/LH\n\
4K2/F+JLzxKDP4zRtZ+GpOQks1T0wYwdlT0wb3mOMh2VwdV74Wgogev8VgRE\n\
TAnqgjNvO2U+qpL2UEk7J0Wg+SDMR99FzKSA7fgaREwe+JvOwT82ivBEJSxH\n\
X0Bwqhnmzc8jYjTCV7qNqoimtB0zC6dTUR+dUc3+UtH/pLfZCMkqj4558ik9\n\
ls2NHgejAcSSyVs/xpZkfhCBrbOyMs+c2Lr3YWzTF2Em5cJMmdl7DmDsnfvg\n\
NDsz/IaVxi0YeetuaHnDTG5FPEC13I0/Y2TjA3CZ6S4kpWSgT5A6ukJAi5MW\n\
DcHctQ8jaz4JvXAKnsnLZOx7oBsfX302YqVpM3hbHoBjxZWVsWhc1Q/Tht/D\n\
fn4zrEfWIaxZhrcuB2GFif2BE29rHiUAPdx5bxPaNsF2Yi1ZeTeh8E04rp/n\n\
JiOmiIvOrKc+NsHT0Uol9zTsJzfAcYH6PLYBYa3pAxZNmCdgLn2NhVlmJiVC\n\
WsmiMCMYjGc9kraUvfcgWeZeOK3cQ3H/YCkK7MXzP8X4IaokmQIlrafjHi2s\n\
010I+4LQ16wDb/M3WKux6xKYf/Eg7LNd8JkNJKiWYJeMsUsYEmG6Y8UI5Ff/\n\
SMd8DXaDI00QH2cn/Q3aLtjd3KqjVNyNJekVDFKNMzqRDZvbnpV53t7jmMPs\n\
7AUIpq9SDSOBRkNihSR2ImqDUt2CQPoXKOLMd0UjPEFuItW20gs+1Ur8yRwY\n\
jNNQazsRSaT+PcMyi0wieZ+dU0hG0vMtqdQtqXjb+uREjJpwNRsz6JlKrbIh\n\
8yhRIv0AaGahRipKPUYza8qzuN+quRdJH6Fh7DJV3xcQ0imRsM7ClP8HuMeL\n\
4RkrQCz9sGLcIYVnOBuecap+0r87GTfPwDNyiSr5NvZR3dgKZTtmopoRr3Pl\n\
cA9dJHHG/dRZknKGl3eJznORzqPKjIuoO3koefE6mo91w+tP/P4DqHCYHXei\n\
wsItbUPMA9mp/8HYtq9j+thDmD76c8wwf8d/idkTj8E6JyIZuR6jb3+O23fs\n\
5+n3h1hiUnRXsN0EtXySLK9iat93Mbbxboxu/AoWaq4SUjLPbN3HPmlcW3w/\n\
BukumSl4XtfDuJjzWbR0vYLK8q8i9+Z3sEKFWjKiQ3XxPcgp/BoaGn+N6/mf\n\
wYWcT0Jl8SLkGsKlnE9BYWZ/5wheex+yL3wU8xod7PpK5ObcheLqX6Gp8SFc\n\
zfkYLhd+GZZALD39RtFE2TFAcc5Zh3UgpweZZ3BicJY/CnPZDnjIwIYLTyBA\n\
RY/x5FdhqTkEe8WfYCx8jXLQEszXfg5b2zk4al6GiYgwapqD6fIPYWs5BnPu\n\
Q7B1VMDd/ApcFCyBsf0w5j4N90A2VrJ/Bq9MAEfp72Cu3k9OPwvDuT8h4vBk\n\
5hmjvgCsYgXq1xRiolX5+/TV/TNHjm76Et20/VZ4Z/8v+Dt/DN1wNYzDVTDy\n\
6qCp3gDe2nuwIpyDgSG1t78EZVsRjCNMm2oY+q9gfMN/YL7xGqJOOen+L9N5\n\
vg1p/nYYRkmDWowM7j+06kM3Gsu/BZ6kl0qKAVy++iEIFgQclIIqVNz8DzTz\n\
rsNrG8Tl3E9iXssNeIr5b+B87megtnoRdo/g2vUvQpn2oc85gKtXPoNF1Tz6\n\
2n6A/KoXEWTDMYmxnj/iys37WR9+/x/9FZLzEVJNwjd+EYYzv4CX6NVc/DzY\n\
Zy1TDphznoSj8wj58lcILE0iuNgLR18xycnTMBXt4gxHCsc70QpX0xtwi7th\n\
zfkRbD03qV9KDSN58M7SORQCBNUC+MbOQH/yZwiabZmsJbzYgOpdbQiEk2mk\n\
fxI+nRlzdQIIyvlYHFYimHmAgphGz1/EFG2fa5+H2+qDhUpKWa8cAYePshFp\n\
N2/0X9McxjzvkKTqMhmLpP/CzC/0cpnhw8x08W272ff0spV/h73vCJcNbBzD\n\
MPAZfetTkJacp3qVo0ND3RrwNn4dVsVyRpuZmrbQpnth09rhn72B0fV3Qz3Y\n\
m9ntFZdjbN3dWB4ZJp3Vh1HKmure3szEvaFpB+aydzILV1a1YgYwo/MDMMkv\n\
I7fwAdhC6Vn1T2O8/zEUVm+ERVePS3n3QJWJa0sXruR9HmrLP8dLztXPQiIb\n\
pa7vQefUzcwVWDVFyCn6KrvS4fu38/N98A/thfHyb2Gr3QivZBLxFQFMDFTY\n\
gakQLNeehK11L3Qn7oetcSsc9W8QbP4MJ8HHXHqI8188jKiVlEzTa3DNkU7N\n\
/T5WbjwNR9M2mHIegrWlHL6hPXSe38NWtwW+eQH7kHyGpJmnTvv2VqDo+QIs\n\
idNPn34KLqkcdWsLULejAUPnO1D58nW0nxqgQjcBXc84Sp+l78fa0XO0AbWb\n\
y1H5aj7x/BBsc3JUvZaHBakzK4OZpH8R5sY/YKX6N1ipeRjGiv+FQ1h+T3q3\n\
T3gIxsr/ZXetEE+aGl4mPEQy092++TbMvfdzjG3+IkSXN8G5bCIoEXTWfIJS\n\
wH9icu9PoOxtJCZfhOgwUf07D2Cp5n2i/mdIYv1fzF07zCxZZH9pWnntEfA2\n\
fBHSgr1Q1+zC+Ka7ITj2J6pqKX8GtZg98C1MHHgEmq5rUJa8wR4vKb7MsM0/\n\
gqcfVnUhrhZ8BSZ/ZBU8A39CQdXbMOsbWPAoTdwCJ7+LAcwXKGF4VsGjSssi\n\
Zl/O1bsxvzCOpqovoX3iRgY8FvVNAs9Xblsm8yWkQmYkdFL20JRPzc6tMVSb\n\
oFI5RqVsQj2GFFVgSQOf/eGrlFfFtWHYyzRLHqe4NE4gLqlCbKoASWf6OUzX\n\
EmKTuYhRqcX+2rRDQvsMn74Ts87y38BMFVSIimlz5TsIEwUZTtwHx1AVfCP7\n\
oM9+hBTjDKWen8PNLA2gysWQ+wJCyj4Yz34fHmEnXM1r6NhjcDa9Ctf8OHy9\n\
m2Eq2UnUOQRL7n/DNTkMZ+kvYWm5hCBdpbliC+KhDJfdA6d4EdWvF6DqzQL0\n\
5U1xz7tSOTRyuBJ1+zsRCHGyyDm3iNo3i7A4a4U4txG1B7vAzZmkoGwdQ+lL\n\
VDAqqTrQ6VD7FuF/wXULtD4xjMXfhPb6vdDm3w9N7hdg413LgNYzup42fZ7d\n\
pb3+JeiLHkY0FL4rHT5eUTXmjv4AY1u+AFH2y3AotPAvNGCpZBMsk9WQZT8B\n\
RW8Nl6MccqjL3obo1B8wd/7vULcVMpPUqz+Xnow4oW85jLkzj0F09gksVR6H\n\
z+7M7A7pBZBff4Hk0e8we/pPUNRdouI/upodoy7C6wMYETN6egbXSI30TzWx\n\
wjHsU6Gy9POoGyDZsNKMi7cD1jl0C7CeUeRe+Qh6JyrYAT3TciEu5RLnWuwY\n\
7/sNcot/B5vfR2zvxkDrz3E1nR0ziE2utCNcvodD4GIewt35SCzkI1T2LGIj\n\
7yN4+SeIz/UiUv83ZnEdkgtUwXRwD0FE2jaTbjUjWv9HhCiwYiOH6f1NJO0q\n\
RGoeQ5R/A9Euqr97LiE+8i7V53UfQGzcPg9H3XpYSl+lbMEjOjLB3Ut33PwO\n\
rGVvwK9kn7BGVNMHW+UrsFZvIqNy82whaTmsJc/CWrUFYZsTIXElggZmqbAf\n\
nu4D1OfzcA5XsD/5GrfMwF7zFixlr8Mn5bP1ZqbAZn+iNL+N0NkBcf0wKtbX\n\
wuVNMKvD0bSxCN3neTCIdTCItDDOabDYK2GX5slr+1DycjGmm+dhmF+BfUGJ\n\
ug03IZdTDtJqM6i9BVoJjKXfge7GV6Er+Bq0eZQ3R6+vgnZsI236MrtLd+N+\n\
6EseYUCbkQ1MQuZtpPCyB1YLYAYnyfSo8a1HdROZWmX1l/lTVEim14etbktE\n\
o6vHcv0xCikO/tALuJzzIeTkfxFzKj7mhVvp+7+iquEpFJMYv1byP1hxWuE2\n\
1iD72n9CnoakzzmIq5SAlQTJkJuH63kfR17BvSip+G/k0ecb1b+DhyqzgHMU\n\
JTfvxrXC/0JJ2XeRe+3/IrfkAQaSq4g0UTRUcxk0KS9EuK8ICcFRRAX1HOoa\n\
1xEie/4/2t4CPq7rTBv3xknTFLew3/dt0yRNnDZNYbdNadNuadumKW6gAXMY\n\
HIfZzI7ZjtmSbVloSZZkMTMz40gjzWiYGTV6/u85F2bG0Djd/ev3G1u698y5\n\
5573OS+f9yCQt4TlASMydpKjlt8reZsQqSXUvUp8VbBkg/kvIdhwAL7E+xAe\n\
KUC4/yyCLcRLa99FsDtPROQ3xIlx1e0gO1XY1y8VppxzWZH/0hnUpw7Bp9Mg\n\
84lT6G0kK95vxcVXk5Dxwjnkr8nCxfcykf9eBlJXJqApfYTMPi/60+tRtCYT\n\
2a+kIPvlFKQ+dQYTE1GEjI/Z/3cQYm87h/6DS8hAdokVAgRo2/SNpGb/XxTU\n\
bYHb7+PXtKpStLTuRSeJJLtHSDULB0xQzZLOGxRM2zCZemr+9xzpoQ5otN2w\n\
2ycwNHAOPQM5sLpsEpvzuhR0OQ3DE5VQDJPSlrSIScUoQcvgT3tLICgjVjUR\n\
tH0HAq2CMRgqewfh3jJiMY+TpGdEPwV/ichiil4TCFr8Cua0QhXlQN6LCDYe\n\
g+/UjxFsT0eweh18536PYBURtCn9EoIGVe0IWC1xBNW39iKZlCrFKJPyQdSs\n\
SUXhngbMEZ7K30lB4e46+Lwhvm3cNT2FzKcT0FakhI+Y6nDxMLzuAAJuH4zd\n\
Q8hky3xMIGjmkyfRlDP6v0PQ2OV9u7RQIx5cTL8VSRf+Bp1V/f/EpsbpRBxK\n\
+FfoZVXkFkQMVfAe+DYClR/An0I999fTrG9EoEWc9RKa9R6iTNL34c9/ixg2\n\
MfGTJCmriImfe5QfchG8+CB8aU/RDL9H11YQY1fTclpBf+8h5v8E9X0S4Zb1\n\
8B76LjH7JDGeteAH/L+beTCh7YMspL+RT3JfiOhO5tfh7LJkGNh28po2JC8n\n\
syG1ByqyZWq3ZCL1+XQYLUE4hyaQ8sgx1Cd3QzOgRn9yNVKWJmBK6YF/mtbO\n\
E8eR/AStyTPN0I7bxPzRf3TOvykzwghmCKLZ2fcR+2uQ5tdhqkNF3atwBubk\n\
vYvzJPojmj6ER/MRGqokscPqeSsQsQsojRgVpN6ZEdH3Yk5RhvBQFc3fOM15\n\
OuZmxzm3DRa/jFA36cfdGYjYxBrhfjOpf5lCxX7eJ6mR6haEFXUMEf8cP8UR\n\
rwMNewvReXFYdkZ6VBpUbsvDaJ+ZRw8nyzpw8fVUZL6UzO2CqQGBZ5NOgPHC\n\
VuS/nY6s1cnIeSsLHTmDfPOKX6cj26II7enNyFudgtYLY//DKV4swZrWW7Bq\n\
B6mvXikn40sy4mUvW3SXS4znjRV/8tnEsChRiiwR4XfJA3c9wl4fgh6pDOS8\n\
nL1PGpDbYEHQG4wRn/M0O1xcRkuXsYSRmKq7Ia8fXruXZXHL3wv7/PDY3Aj4\n\
QrKlJtWDD3r8TD/835qpeZ4MAXq4OFNfFMHHJnFoXxKmO4XcPOWZ82jbmc09\n\
tb7JMXTuSANzfLqGe9Hy+l40rN6Hju0ZGDxwFi3bszBTUIm+k0KEXnuxjAyv\n\
3Wh89SB69qWgc38u33dkKC4Xrr9xAA2vfIiZlqlv/I/e693Yd7iNIR1d7+zH\n\
eOMUsTUrWl/cgtKHt8KgdMA7Ooi61Uf4FpqRnYfRsimXhK0T+vIqVD62FuO1\n\
Y9AWXkTLtlyaezdaX9qOvqRGYtYqdL+/F5Uvn4Z7VoOWVTsxUTaIoNMNVUYu\n\
al8nfcI/L4bRr/oi10u3A3YE9APwqVrgpY9vthchp+Wzf/89JTDxvWy2KW4F\n\
eFWt9GlDwDxNOlpI3sk0H3QjaCKJMl0P71QlvMpa+LT9CLEqC5H5L0qrYC5A\n\
XZEAUjXDo7gIz0QufXLoU0TddiJINiU1F/jV5+Pd1TEJMSzrhpefli4xuM8J\n\
K8hvd5HR4RchvSC6mcVPM3oQirZpODpa0PDGEXRvPkx6TQe8EyOof/UYPO55\n\
TJ9ORu3LxzDbNAT71CRa39iD6Z5Z6EsLCJkXMUe6Ussre6CbFLQyS0MNqlef\n\
opXkg1utg2OShfma0fX+AdSvSSYECmOMkEXtUVwQ31Z66xJSYAPiIQM38jZe\n\
fj3axj2eQ5OtiVpqV6a0lD0U1LXAUrMamvSfQn2GNfsG2Y/foKbfxmzyf0Bf\n\
8DSco+Vs56Zohn7xauQXhu3RwtX7IZnjv8fsue/T/bt4fzP0vyrpHmjO/wGW\n\
liMIWLSfkuDC9nbrGmnk2eJbZBMcGhhdxaiyUCE3oKkli/4NaDP+k0zbf6Nu\n\
F5GZy0xderPT36Hh/gTarAdgaf4Qfv3kgs+JMxAykgLXshW6rN/RkO4RXvHE\n\
zddh5vi/0u2Z47fQ6O6Gmn09+2FYWo/TBM4KhV6YYA9h8GQZ9ApSF+c96D1d\n\
BrvBhYnkfG7bN29LR29KF8JuG9q2JGG0ehTjyYVo2nGBOE4GxqumRFrEMDER\n\
Wq1TGP8wET2nG2FtbUDDO0kwdQ2g4bVjcDsjCDssmEjKQ9f2M2hbfwxVyzZi\n\
ujcGWiSJW14laI0LEtTZ04W6107C5wlhmhZ99RPb0PjWcQwkFsOqtsqmknsc\n\
mqRvYPrY/10gTMJCTB+9BbaRdt7iSyJdvMMHMXP4C6yF+Pl/1O422BUD4ht9\n\
5sroakrkcQtHy7tQJ95B175K929nba6jRotozlV0mV2aOUlzf+I2aHKWw6Me\n\
ukkE5ZUAFgpGEJwtgS7jJ4x63MlBPdLYxS7ZCE7dxu+pkv4D1o5kAq0okRjI\n\
5mApfxjKI18SXubYl6E69yfqdk6W73MuJSyVK/kj2aBnTvFBC0+4UXgCG7T0\n\
lMTvwVSzi6X2LZCxTDzZ2b6JltJdsaPkPVzP3of1k7gopp+vQHX2Xli7M5nG\n\
Is79F7mc69yeSfa1mTnU0LI7G7reKbRsOQeLwYOZC6Vo3F0Lz/Q0mjZkwm22\n\
YCy7Dk6LCzP51ahdm8eyK//pcsnTs/Ywxoqb0PrqXurdROquAc2v7IfiQhWa\n\
3jrBeZqjsx09B4sQDNGc2/RoXr0DUx2qqwKPnTlX//opeB0OtL/yAQayOtnE\n\
wtTQiNELrTHZvTfCUf9clLYMMSe/Cl3JRl4USU45ore3FP2J7t224Do+a0SD\n\
hFuhzljCytEskDInL0ff12CqOwhb42tEZJrZhEXicxYJRKUZp5lfyLu8gV/m\n\
CEz8Lqw9BTE1lz55OQRT/gzXaBpmzzL3223CqK6X6ahidE5ctFC+LCBIW/gq\n\
Sym+MQaE1qql3H8ndHwb1GkPcRAKba5HSF9FGP+RsGoSF10XM1YObzZe9vWE\n\
2xcsjB0EAWk241F4jbPSjjKWIGGve1LAmADjO/lCEbyDHJ7sw34/9bX4od8C\n\
Q91ehsgvxgCy64NsaLnl6EHbvgvQ9yjRvi8THkKae3wU7Qfr4CFrsJWUkzlm\n\
bVc1o2FNEpo/yIGyRcnmNw6QAifs3XAErRtPovHt0/BxYymCsYMJaHj7MHHE\n\
BFKFSEarJ9H0/DY0r01AO3HO2hcPkX3vgr44/8qA7CZAMk7oncN0UgapVAfQ\n\
sSUBNU9ux3jJkKSoBGfzoSYaSFhUJRIVz/6SdG2rjMU5ew/3uTJeI2GRAABj\n\
0zneQuaqUSyK7T5NUurfBc7HaS2wO1Xi3dBk3A9dzsPQpP2MY5Sui8RcKOL0\n\
LtiHa0VM/HM8GBkQTn+bPt+U++agOHUH8cmfQnvhYZKCfyAO9C3RT3y7DFaG\n\
dwKDtvBNsvDnPnENqJTPzNGWQnPurpgVeZP4RrfykWjO/xl6MowNBUtJlfgF\n\
X5F0T34r7o5O/Qv8FqucFeYdPgzVya/wFkKfnxIgTnJdnfobGEpegLnmTZL5\n\
b8FUsQrazN9KsygzBZIj0zQxlu6LIsEEgd258Rx60rrhmlKiYVMGTONqtO5M\n\
A6um51NMoWt/NeyDY2hcex4eh5VQmoiJ+kloGzsxXjMRL7CvF2C6/kOUPbQG\n\
vWebJQeqrbURlQ+9i+pXE+AWK1EELBboW/ugbR2GxyJsPNUW5KF1Rw4/cMKt\n\
NiAkJlHMebxwqc08YYcFKW00InVtJyyThmh0h+0HtsF44WeMknEItPSUy6/M\n\
5fXgfqi4XJLQTDRIvAcenVS45Moo5cKYtae5V5+7F+aWQwiYyPj2uXjMlKWx\n\
BXTNsFQ9z74jSHE++6eI+Od+R8vFJh+GEg/VOwXZ+SlOU33RC3BPNfK8owjb\n\
cxJwk4qj5OqiNu3HDC9RuhJSj98Kc2f+gmuBqezxdU9Bn3FPDEw/w9upTt8D\n\
cxOphcYJUsg9POeY2QBzPisC2iZYql8kVeVrsS/HWKMm/03MhSPR7n0kA9N/\n\
GEOJGziyNRcWwz3ZTEa4I8aqJuvY74BfVQ5z6WJC+m1RUUYjOvtrMuzMIvHY\n\
v2EosqrRue8iVyn7s3rJeLNjOLMGvhABUKPHRHYXxjLKULLiQ0y2q6GrbUPb\n\
HlIzCVvaESlVSBztp/kOVK9yGEFNK607HeYck/DOCjE378hFmCv2wt5bFVOO\n\
kCHdRxrCAZQ9vIm6NEmX5+x6tLy4CRWrTsBlC0tcQXsxhyzRbF7s4fMimdw9\n\
G0XZJaLwFM1P3mqu3UjlMVjmo7nwEvlO7WZzX2AH7FwRrTJ/PHULZjP/Cp9J\n\
HeUko4lEPuIMsTya6Kev2sPpIdEvBpwL4phiwp2w9uWyyKT0anOOURhyfsOZ\n\
WJRuhJAkEg9Wq9jl30dlbE1QR/MrbFri+zr9C7iU/QskHdWnSCUm+232GjKr\n\
nzlxBw2tQn6ed3APLfLo9M7QdGgLXkTI65XrkzP3o5OU79ixs+kwtqTzFtKx\n\
YcyNJP3ERJM9xDTbdufLuxuY3yccjiyMR5d38CTUSbthLXoOxo4y+EbOQFOU\n\
jsBkLpQH/gRb+wXMnvodzN11MeiiyeofhqZthJhgJHo5AuvACDQdo0zNl0jg\n\
087CODTD1TIJXXOWDsyS7aKSp4jxuB/BY9DJ6JqztYttFsXwy6/B0lkkE+TK\n\
vJBhjCTqmZ/ArVWKtidN+chxYclKiGYy6PRP4DGZ/g6yqC+ChLH+GB+/RJqI\n\
WwF91s+YvhhDmq/C2JwkT8a1wYrmgsavPXc3wWVRdC5OfRP20VbZHvErszB7\n\
+vaY1UhadNpfEPRINalv5FFqc9nD3HaT3k+V9HP4LFa5n/mwGYYL/ymYRCLs\n\
NBeeYRUe5GzL+bkwgq7Ys7GiYBk+jdm0A7CVvkwWbiV8YynQlWXBXvYyphOe\n\
Jcs1lV53C9neNeJGINEIKH4gjkmw6TAJfnwZEp6BPaI5FqPEnaHhW23yCrwS\n\
qZnSZGw4zslzk/xMmvbKxy9ZObfB3JoeR55LpJywmlPuR8DtkacsqMqie7Gw\n\
IRKm/o2AH/pYZHZ3rY1/PyZw8t/hB/zEulDstU/FjImpX9+EQ9Ejk3neN0vC\n\
63tcURQsn5vJ8NrB3//TItGEPr4aVQcy7kPQGxZu3wCnUoOB9CZ0JTdhposn\n\
vInM5CqUroJ/4jx0lflw1r6Hqf1LYG3Ngvbs/TRb+8SzT+k9aWQRRSLmJvPZ\n\
mevSgH0TJyX9UBwQcf6sFaxI7wJpExK9FUz597H1HbPuyPAqXsPlmjSJl1qK\n\
fJ2fvhdewrhUJTo4WyAQUn4eaQB5L7MyFwskx+ilhOf+jpZUqQsWpjLm/VYw\n\
+yUOnvAduFTKa6K5vCTJdDMV3M/ZltzPyW/APta+QMrcDRtrSOixpf91/mF0\n\
MzSdlbh4xEV89uydMbdvhrnngvRta2XMCJgBm3ofAk6/FMGbc9hQ8845NJ1q\n\
wVhBGwpeTIZywHQ1Ype/QsIlG5bCF6A8thzusVyoDv0WxvK9UB35BaxD3WKZ\n\
c+ILc1aEy/+AENno4folCFW/xQpJyZnE3ino0r4XLwNpBp0qhUh0JgRayQ7/\n\
epx5P3NyEWzDzbKcvIzgXL14iRNTLgsessKQeS/1HzXRVEm/5av4ygRnY/k2\n\
UXNKmkZ399YYbYcprV+Dtbfg49A64p2IZ+Pc2/A7BDwBmdZsG1nQNIiAYUD4\n\
6PsQtBvl/K85P4KG2Nv9pIs6pfcMGWppLmKewFb2+fsR9Emj+BIJDZYYLETE\n\
g3YnNF2zNAIvtF1KBP0hmAeVmKwchLJJQTpqDprPD5EKZoF2UEzUCvih7VbC\n\
752T6tUJpPgUvEMJZFfsREDTDZ9RQ0xmHaYTXycTlPQKyzCZURnwqMeE5rcR\n\
N5jB3NB+zA2ewLxLSGWMqC9grmsr5sazIWzfiyCiyo5eYyll7lFEDKPCaIx1\n\
iGhaECHdfj7gpN/r+WFh/HuaKuIaVuqzkr57DpGpswhe/CsiDmn3PPHBhucv\n\
Wea3wFBzRAKgp38XUTpW5NACSv4TAcd/VQCyLoz1hznPlMjqYI+RoMHt+u+S\n\
5jF7RewxxnTu1/QIr8wA9OVQn14kfJM/4SvQ13/4cbAXNlSKPERCBon17Dc4\n\
67xT5M5z7lm4SdnTpv0w6kwQ9HBNzot8QUkgGjiUi9Y8IQvQPjyC0rcLYJ3W\n\
ouytDNjIGG7fkYXS9floPVSM3BXH0Jw+AkNzO0o31fLvzFmMKH8nAwZNIB5E\n\
pMgoLkKffw7Opn2wjg4gZGyCcs/vyX6eFc2Ar9H3XQhX/h6huvcRbnoCoYrl\n\
JFOSEcy5lxB1BqGyX/EodESdiuCFn0av9WUiojxOLCmBDHgFQhfuRnj8IkKl\n\
SxGxjiFU8igidrYRIIxw6X2Eqg6Eq/6IUMM7CDc8hmD6XdROJ8zCJ8neKoz3\n\
KnHl4Ldw9KfANZz6KbiGUmheXUOp9Oc5GLJ/zjhQrFqir9rFcSIdiRqPJWYU\n\
LIK1s1wKx8XDcZGgBA51XxlGJEPTn8RcSNwBwoJIjP98O8pNmcF2cR3HgCyP\n\
PhJLn0BgPDFOTWb6hbbswO0ys/UQX+qBeziFLM8XoEm5R/CHyY5MQRMmk1+S\n\
7RxTw8cK0F4wwvHhGB1D5dpi2Gd0qF6fA1XXOIpePg+7S4jt9e7PQWPKIIxt\n\
najcXi9gympC1bpsGLWXYWo+EuY1xVj19oiwk5nQbuXnhsuYsncgVPQXzHO9\n\
1ovIeCrCtYsRHioUOU0xr6EcbngS4WHxTCRDIUKVixGZOEX3nqV7jxJWtvLw\n\
Ubh8BSK2CYQrVjKOI2Cq6iHMkfkUIpnMT4WFHaHCX7GsE9kHNGeHMec/43xA\n\
ktt35vhXiKOwfz8RIzYlKNwN5+SIdHjFFYHUUSEByTd6LEbjYre/Dmt37VWB\n\
lPZULJDmg3ro074TI8ioyflXYiz6a2NKgfHTl9hbt5Het5zWTxLzhfadZvZW\n\
XwIcg5nMjSkq7zfxWHHQ2A/3ECGs6lVoM34heEG5k/sWrvxfLyPtK9TnSjKb\n\
pQK6hLSjBegoHuMkdI5NxCFN2TaMsvfyIRbNgCqvmpA2wJFW9YFwyt2czXwp\n\
0r4komje3o5Q8V9FFBEQrArMNS4hxJQLf9taiFsRimpJvR2tEq81cRTNTSQi\n\
mEJsJeVuQg4rSuZAuGw5/a4gbvTf9L+w0yVc8QChKAmhquXCUc6cW/2eUKSS\n\
zCB372bCCddWaGgSilhcZTFzSi64Rpj4FUmcS8TBpKfmWmESspDW9cMoVFmT\n\
zJc/JkwWxsJkQaxnjS+JE18h+5D9S6Q+/n8wk/QTBFx+OboTto3B2bkX+uz7\n\
L4EIj/gJKJGCLrdyvjSb+TgpPBqReXwJI8cLUbmvnpdBNDR2oOS9Io6WqnUX\n\
oBtVo2RVEmbG7KSa+dC6OYPzJVN7Fwpez2V7V+BVTqPo1XSYDMFL0cIcvuHy\n\
nyHcvp1k1C5CziNE2WMIFdyHuZkSUpsfRqhpByLTpLmQ8RPh1x5EqIXVcT9D\n\
/GY35jqfJd6zmliOiuQX8SKrkr5/N0I1b2Fu7AjJuN8hYpkkJN2LcMcuzPW9\n\
j2DanXRNI+8ztXVKvpaY6IQYtD15C02jGLeQ1fA74wx1Y+MZLsX+PqoqJVQF\n\
JtOhPnWrvOx5MK815eqoejoWVWwLhDHrp6J1K2rRqQ8hSLD+R1HFX/pzkON6\n\
otcu9Vcxit4niO2Z4WjbSFP1XQF7Qsj3Bv6VG0WvzC187DMJ34Am62HYSAkJ\n\
+/3izHwJYwklyHkiEeVrslDw7Gm0EVb8OgNqNhJWfGFMnq9B/gvnUPbOeVx8\n\
JgGt2aMwd/XgwrJTKH0vE8Wrz6JiFxnbIblYtJAichvmnUOYa32RMPEcab5d\n\
QoWgiWP091MId24jjhTk8xIZP0IYIhnWtZ00ZpKLSmrTzJKLQ4SNraRtN2Fu\n\
9BzhyYLIaALmBg5S+yf4eQF8+6ujD+HW56nPDaS5p5CG7Yrxf4ZgKX3oknDu\n\
HUTCn0Nf9BQBSV+4km0sKXyCtMwfxDnuBAff95haLK7eKwHpDljaC64uxe4k\n\
KVZ1ZSDdSqNYyioUR6WYAfr0S6UYGY7h+f85e4qa6ywwkfj1eFz9kuNKGOf1\n\
nE+aSx7iaRcyT7pJjKzdIiYo0ASc/T50F1fC0nwQ3tkBVjRV9DZ+ketOrTn9\n\
sE3pYFSYeEXYOZ8P+kG1cFg7K8ehMsCsNMNn97DMPuib2lGxtRaOWRMMIzr4\n\
fWGxBIvwZp+Fd3ICLr2NrPxhTGeVQd86SHZHKxwaC+w9vTC0jyLosGA2vxwz\n\
uTVwauxiJI2UzcnDCDceRfSHVKLm94mkbtmh559IiPf7cH/Oe2zHLy8My/bc\n\
zEeCsJQ8eHkEIed53u7KULlTcJLU7peg4h3+EKoTlyo8dVeGyu1QJ/0cfpdb\n\
hkpgFrrUS6Hy6sdWeEKGeEOOozJ9JTwzHQs+DZ+6nV7bp+4gw7hWsBZO3R7t\n\
K+MvJLrnZD2RHudsfV3M6hERw/VAxrPpDc7+CLr8J2Bp3AHXRB1CTj1LhBNd\n\
IgsxfKIQnYIOJEe2fWodajbnweGZl/3dDCVVu7jeI/rdxbf5HCn2ZzCeW4H+\n\
9fswVdAC5alzaF61E7ZpNfrW78V0aRvG9p/EaGolNAUF6Nl9jhXll6KY895Z\n\
tsMrBiEhMuv7mPkuI2TeNw1d2j1Rxw2L/ZxmLl9L1NPuHCTKf+uyuL2lI18m\n\
zdUdRa/weJXs1mMBHI6FqK0+c/Iu2IY6P8JRpJSwEjZVk6ZxZ7yVlbfmY1pZ\n\
NFz3GLRJd8VZ7LNZL/DqPFFZKGpYkiwkqTqb/SIrQC+zpznXEDTnvs6wK06P\n\
kJU1c/JOaHNXwkH2TdhlYuD4vPiVoNPLKrjEYYMVgPLbPNwZLW+x8fvhc8TW\n\
NpexoU0/B0VxA0b3nYAisxaa/EJ0bztFzc0Y2JcE+4gC3W/vgLKgGYaaJijO\n\
FcFjFrPU2Qa3y72vls4CKX4mrOZYtwwL5vxHDCyu5AhmKR//RcvaEyX3nAvG\n\
mGAHJ+eZ78Jj1F+d3KStWHouSr4Zb98uzreiI/0KjE3HPp4P2A3Txd9EfckM\n\
7Gd/Aq/ZKlM6bGnB7OmoyTdz6mboSvdwtUt2R6gvCB7eWLMw4Zu0EM6zAw7v\n\
uYRCaWcxWTsAa3sH1CX1mEw8h44Nx+BzWjGwnyg0OY2eN7ZhIrMGmrJSnmhs\n\
m3Z+U2JlmmIhkB4Lz9znufSU4nos3mQp+nM872Y8vuh9vhzkFXzFoM0dsPbX\n\
8hZS8COkryD2eUd0abHJTHmQ7d++esCGjStnNR+XHESZ98HMs85inO6kO9iH\n\
6j9GwOYTcHWs4VkBsdAwd+RI0PB0bxMTgaK+RXNPnvQE/9hxIbEiJn6uK90e\n\
E6ZiiYoKuIaS6JNMn3NwjuYiLAVOPsNLr8ceKxiJ+dvqDMDmFbfZsyK4EXmv\n\
QIDUPr0tAD/NiXTNzoq/C6epSIU8okhJwlT9IFRJKRg6TiZyUgb6D2XB1tWM\n\
1hc3YbqinXSaLPTvy4AiIYXXqA0G54WE/hvgDTiRPN6B7b31ODwxCEMwLC9S\n\
dmawMSdG0DHGlMCUwBkZRXM2lpd11yXoWATbYKMI/KujiDPETCGSJIf+5kOX\n\
hf4YKvUV23kOwVWRJDrcHIo+GUmBmcxLPIBs6f40JiR5jRFeZoGxQEdiDLKT\n\
/wi/0x2NzAa00HPDJ3auvg+3ekZGZHDmfExkS0CkbaRWCvZ4ujdg+ugXxbzY\n\
f8F0AvFMs0PeJzoXwtGyGQyZhbSlWbUVb6QoMGEJIr92BmszFVifPo6iMTf0\n\
egf2leh4O73WjvdSxrC3YArrc0hiO0MoblJhHbVflzqO7H4HQ+CnYmH1WVIf\n\
TkNRNUDk8JNS3w1dcx8/di2oGkL7Gzuh61Hxqv+23j7o2wYR8oXFw84/gdS+\n\
Evy6nmwp5RCeacjCCz2dLAtWyu91926Nc9tzl3zDaSnByDOw95JAMvPq/wFB\n\
t1dGyZVzBhZx3crcniXnDAQm0y7JLFzEk8wdU0N/P2eAxeczlyHkDcgIng/o\n\
SRz96hJ+yZyrW+KQeW2pKGHYqlew58YFwrXFb9NqCMWkkIQFaXvyq3GrgenX\n\
4XA0Hho2N2I28faYKb0ZprZ0aRpIQMGY+4t4jTX9fhZTjm5Dngtiey4ryhYm\n\
ooewM3UYDx4dRWW/Ge+nKmAm9qNR2bA2YxKdk+y4FmHrz/i4CWUjDpgsHmxM\n\
GkVSvQZrkicw6QhBqbLjTLUWvvl4eDEbMw8zLRPydAjOVTKJ6jsR9EvC4HZo\n\
STE+PNSC7X2NyJyd4dv5rW4TTo93Y8jjpd/NODbUjB19zSgxCDEwl8+Oar1K\n\
PNQggnbNGHb2NyFtRoEO/RQSp8agsBlROD2MJOUwssZa8UBdIQysWlnYhwuK\n\
bnxA7dOpvS8SNTfn7N0Sq5PtA3X6YzECjhHMD3NBfCCchxIqd8VlOFwO4BtE\n\
k5Rtoribp0Ex1Vc6BZzvkFHmkq74nfjUP1JfRbkuNL3pCpzx66JSQhKs+BUE\n\
7KYo93ZOwVx6CbflnpJvkdY8ek3pVbK+aWnn+xnisr/Y+ih8DQGbUX7mfNAG\n\
Z/sGxgnj1+6JRbCPNkbDAn4d9Odj1Gdm+aX8iqVWRysasr32zW8xPSLumbqy\n\
nTHZ7gK4d+YpMGQJo6FVjQ05SmzNV+JihwFbckQrxxfAXmpTO2LGtlwB3E7S\n\
tQ/StXdSJ3CiTo/2ESOeOzqE3YXT2J1L/PSCEsbgpeCO0NIUd+SJttIiuubC\n\
yupUPNVei3PjXfhLeQqydEbkD1fgRxW5aDbM4Em6/0RrNY4MNuAnxSkoNNmg\n\
No7hkdqLYCEKo3Ua95UkYe1AG9Z3FuP7BSewqq8TuWNN+GV5Btb3NeChiiTc\n\
W1UEUyCII91F+E1tAY4Mt+HBimSsGRqIOxCKl5Aqeyg+zebUN+CcHIxZmAR8\n\
Mwv0fyM+0E/tHJODC66211h1mvtXeKIqTzy9A9qLz5KKVIiAWcWTT9mGMq8i\n\
H+ayFYJDMxp949nXCd+FUzkk4uYLl+P6NC3FU9HMa3Xyr2FpPQqvph8hMpnC\n\
Lj38mhY4OrZBk3pPfB408Udd+Qdcz70WjEvY9Q7sF5VGyVz7NG+vTv4ZLC0H\n\
4Z1uRdA2i5BdA/9sC5y9B6HL/o24VSAmD47sEF3ZVh61vUGe63le74bGFs0J\n\
PsWSEH5OytxZBCwqQlFAOJIn4Kbpm4RnPBvGgr9esn7ZXoh/h0utECko4H83\n\
yf+qQQveODuGMaMXBwqnUDNkxdrkMfQb/BgkbK85r0S30opnjg6jedqNrgEt\n\
nk9XYkrvQUqtBsPTDmxIHkWd0oWmDi3eSZuEa07C/7+IWA8HXUhTDGCWGHSf\n\
cQZLKpOwY0KJ8/1l2DIxg0nDMP5YlQ+rqP+e6y/Fiq52zJgmsbKhCKzevNY4\n\
gd+WpqLabEUg5MJLtRnI1KnxWl0mEtTC8YnD2n7cV12IKbse95cnI1uvgzPo\n\
R492FEdG+pkAkDHMgyVxliAx5YoP4nbfenq3x+cTyAw+KOL8C5fjnEw4ff4q\n\
7uMQ/CCLuFXDfBzqpHswm/JjqM99j/8tIEtCwfUC6InClu40xq0EkF26zeBr\n\
mE39Kwx5f4nLQeAK0mm2N/BH9PkhXwz8mrTBRMCYJncpgh73NSVvS6nj3BvZ\n\
uYVm65Y4UcPDnDezHYT0AupzP+BQu0vytccn8p74V2guPsPCehKnng8YBBXk\n\
RGwi7+3cE0jzRNc06T+jr2vS7hXni+2luC2+V9IT604wJ4dU7YfpxPvyxvH8\n\
iSGc6bRzvWpHrgIDphD6h43YlqXAtpwptKt9sNnd+LBQiZ2FKgxpCM+VM9h+\n\
QYGT9Ub45uYxPG7GrtxJ7Lo4jc5Zn2RnfU6aFjKXneZ6WHS1CIWC0RLuEVRM\n\
tuN3hL8/VGbi3b42zAZCSOsrxeaxKfRq+7CsuRrS+ViVU814vK0OCsL6ioZi\n\
OPnxcX6kDDXi6YY8/K32An5YfBYZGiVW1WWjxCIkA7kds3isvhgjJjXuKzuD\n\
xfX5eLGpECvqL+CBpmoYQ1FFZd6vhi49xi/HNOBzv0fA5Yny/nkPTBd/GUO6\n\
hdyPY2wQokWfEqVXFO+3C5oBSWlbdz0CqjxuE8XlzYg786SddvJeJrYeEr4D\n\
a3c661uAxOdEnH9V/CoptRkvIOxUk/70F3GzVDShNqbbuO1Wx2/lYiXoclz7\n\
5q4bOKt19+3l7orLFqX8IvFP47Gj20mDeo1WlEeqkh62D5LZ93PRYIluE5Nn\n\
QvrcseDScRsqNiIcmpcLDURC2JI6iGdTleDHwhHL3nqB6eNC+btwaI6Vp5T2\n\
NCCmSkAgKDuemdoh3okH8A0wTryM0R6yOYaexWjXKwiGJOV/ET+i8s8VZ7B9\n\
Ygw2vwtnR9sx6nYjubcEa0cU0Fsn8euSNDTTGopEyFBoz8MTPT3QWpT4RXEy\n\
Co1mGqALe3rr0GW1wei1YGVlClK1GuxqycErA30Ikj5boWjGLyoLoPE6sKwq\n\
BbsmJuAK+JAyUIm/NpTDE4nJ8WxcHbeDgfmcbAMNUoZi2FiL2TOL4lDCnBMu\n\
rUp8888g4uznmfyqU4Jbaub4Ilg6hFh/yNBIovMv4mZVvjVW2CVzg8BgT97M\n\
rUnN+YfhmuoWFffP0Khe5FuVVQmC90qd9iT44X9hKxyta2lN3CXGhNgex0Xy\n\
TtsEKfxITzr9Q5gaT5ChF4ndFns10N4krsSAthbGwr+J0uur0vZDcQKkvay3\n\
ivtd74Qm60HYB/NjPOikpflUsNatJuDH9sGDWovkPYk3CypN0o9haUtlpoWs\n\
Ic1H0DNm5R4H/kN/903aYfFGpAIRUo1AxogdxnIEgwH4bDVQj22ERnmCn98b\n\
8o3Cbu7lPfhdHXA4JqlNO3TKD2HSJGCk+Y90zSj2dQdnscn9VaQyZGM5scT/\n\
qi1GqXoIvys5je8TKMuNeiQRgH5bkYHlxA5/WZWLHrcXOvMU/lx6Fr8sS8OB\n\
qUkc6y7FfVWZxDJz8OvKHIx4/ZgllfohUo3/UJ3FWfjv60pBNgK6NYP0dxoW\n\
113Ab6jfbJ1ByqMMaUtp/m6XvUHMx6gtfEMobMA4dTfX4eLCYRee5SaaRAa2\n\
3HzKWngmhY97ohoBq0k6kHGe5IFvkhTjypegzfglS41gIvfst2htzKbdB0P5\n\
G3AOl7EiWpL6HTL1w62ohmeK9VgN70xftCzJpwicQ7C3boc+7wEi7L/zZAv1\n\
mbtJ0v6YRy2trcfgt2iieexXh+OnxIXAqksEda3U7RaC5TJeuVGd9G0a5re5\n\
OqzNXQJz/Ua4p9pYdtfnRb4VNHbxrxgKlpDics9CNgx6Zfat2bTfwVC2Gvbe\n\
VAQdpgV3XwopN8bbH4ZBlY2RlnuhVWVA1f/fmBg+BIfhNEa6hDr8FuUaTIwm\n\
QT+2GmM9L0M7sR49NT8gW06q+PwvPPyuIK2x3aiBJRjGXCSMvW0X8FxvDzxz\n\
wubXCZsOrXTfLB5/GSJdw+r3wuAmq8zr56VtmBuh26xj1pY4zpvgIv45ZDXC\n\
4Cedg7TROZFRW4nn9VBbrU/KOPgUDy4Yc/8rJlGdRdB+Ci8rGEUSWvC+fi02\n\
cGZuzxUfBFbDPsIdFBGh+HXMHpcbyEZwknmso4+WPnpSMsTY7kIxLhFhBWgi\n\
sfXbPoH5MNtoaCTjib7koi/7rGyXnhzS+jvAkIK5bF7YjjvWDf/47CytT8iE\n\
+CR3Gs75SFy4VGQmKekzzZ9Ew2Pj+vblRJ/sXg7V2AaMkXrOfiKeHox1PUy8\n\
IhHjfcJBCdaZLZgcPYqJ9r8R7xAysZRdS+GwG2RnWqdmGIUGvjNZrH/yWXj6\n\
dl7ii7yN1PEShM0NwoYdWboIm428FpPswwm4HDh4rglbEptovNtON9G1Taea\n\
UD/BD8xip9bydh6bFXvONGFrbLvEZnTP8n2pcqGHvze5S648LerxrSTL3+a0\n\
D7ua6fcHYdKepv/f59esyvcxNXESio4HYbEwn0YIk52P0BQZFnxLJAjfWX3u\n\
m3GRV83FVbC1rmO8LS40VPgeN5mlGfDZLHhpZxEeX19IQ1uyoZCuPbKuENnd\n\
lrgZcBKHfnprIRbHtttQgqox5zXPgHy2QcSHwdkizDiN4hndN8LpnkSz8iya\n\
VcVwhcJ8/0e/uhAat0V0SsfNnKJrMazGNkx23Yep4Q1QdP4e0xPpcFnS0V15\n\
G5RD72Ko8d9hMA3Crt6FodaHMD24Aj3V/wanyyp2uRB+nxYpI8UwBoNy5J4J\n\
Pmv53y6xyO8S9onHZWYtYtpMdCmz6bRb8MruEizbVEztVmwupmuLNxYjt+eS\n\
6TQZ8PyOYiyPbbe5FDXjH3c6r+cxnuqBN7C/4SVYQ+IqvYlMXjXOND2GjP6D\n\
yOx6ESe7dsIftKOs9yUcanqLaaiXi3w3JjoegN1uIIZvhFmdSbPcLpzxGLLw\n\
Kn0OQwmspm6xJhAp4dZG2Ewt8HvUpEWF5Zl12AfwSNlGKHxBMch6PfyTybEW\n\
/HVRfXuhECM49wdu4XzqGmfzehH/jNcbXC7oPD45PBcMBaF1eRCIyCX4nT5v\n\
XBOm/BhIRXZxvTwiKeD/G7SRQnsBpxcOHXHxsFiLKCyqGMS02WHu7O95dr6z\n\
eJ3/Pidu3Pwm7M4+EmJCIu20sR4q4unMih3WlcMSCPAhJLc8hnJVK28TDlvQ\n\
PpWAIdLNxkm7drFuI14M6Spgp7d0uodRNrIPhcOHMe3Uc1/3MN1zhiJwuAf5\n\
vaLhI/xeZM6HMU0pGpWpaFYk4MOGRzHLztyCDwmND6NB2x8Hn4X8zszgGhLT\n\
RjFrbiG8fhNKp6uROVVJ7di/tyB9shwNJqEE64ixE8cGzyNT2YRmbQdGnFZo\n\
nArUGSZkOtncKiQPZ2Ffbxouqnv48U4uxzBWVK7HmbFiHBnIQOZ0O4l94Rtu\n\
nw7pozk42J+BXFU3/DHZGizTSJ/+A2ZYL7hB5ovMkbQzxmj+aOgJ/X2Zh3fO\n\
tDbh2aoGvFlVg1NjM9DZTXi5vAqv19Tj+epmaHwhdE+P4akyulZZg/fbhghz\n\
AZxoacYT5bV4vaICLzf2wheBNJX/GxgU+vpnGNsnULi2AnUfNqLqSAfM03o0\n\
pgoHUXcfb0DbhTG0n2khq1KDmoM9/CxB55gSNcm8IKCgNN+NkcldRAXhpKqc\n\
9qdQqKxkmdo4XvcAeq1WUmXVOFDxb9jftp27SmzOeuyoeBB92kacbVmKabb5\n\
PqTFsfpH0KPvw9mmvyBtMBH1o1uwt/5paMmGOFH/KPoMfTjT+GdkDJ1B/cgm\n\
7Kt/DrOOCWr/ENIGDiO7axXeL78fU24/gr4x7C69G0c6D3G3uLCBNurFJ51w\n\
XmBU4owtgsbcib8WvoDVLYextv0YEeMo3m75ECnKAZIMCiwvewVvdZ7FlvYD\n\
+K+CZ3F0cgBVihQ803KGh66CAQPeqn0Pz7acQNJYLpaQJn98sofzxqVlq7C0\n\
fj+ODZ2n66/hg9EGBEJObGxch2eajyFhJAfLy1/H7tF6PlyZ4zS/JtnJ0bz6\n\
U1+HQ6hd/LFBOUdL90zfCJQuL01vL5ZWNGFvYwPW907C4vMhrb8XBTNavFtc\n\
igKNFRaPA0fbe2ipj2NFeSNMJIAHp0fwWHkzvP//gHK6fgJTXWbYlHoUrynF\n\
YJ2CwNnLT2bNW1NNlqcbjfurMdE9g9ItLRyU9qExlFCbGFCOTe3H+VGhHGlB\n\
1wuc1bAdHomNj2PY7sKM+iQ+bH4Zx5pWYsLlJtbUgOOtuxEmaZbcuhIqdgx1\n\
SIfEphWoncrGkabXxRriYaS1PUczUoGklmfoXhbde1PcyR+iey/g4tAhHGvZ\n\
KNQnD83ieONyTLoCGFPux5GWV3G06WlMezzyEX3sxJfxJhPMxpC0q1tSB7Tm\n\
Dqyo2knDkYpEfhVqYyueqtkFEz+X1o7VNe/hKAGidioDq9uTBe6prcLDVTsw\n\
K54K3zaTj8X1R6C0jGB5xRq0OQTXY4+qCMsajqBjtgl/K9+AYbeLL/9BfSsS\n\
x6sQnJdrpIR0ZVIBDyGqx728zEvyKJn9US3p2hlkBHVjg1hRUo7XalpQpNTh\n\
QB0Nu6QWmxpb8Awxxf29Q3g2vwirapuwvrEZT5dVI7mvj9al4GLwknHxZHUb\n\
O7P+H8fiLaKL5dbLsOgihli9swrFW2vRmTkO26wBuc/nIvXJXLJY7FziNhAW\n\
FT0zKNvWxgnuHJ1A6bG+WCyOExZP9Z7kIy7qWYWS6VqwejeJjYsxZNEgr+NJ\n\
1Gk6SFd7FXmTVXB7unCCsDgXsuI0tRl3M4uUfm9ajlplNuHnNUhlJbLaV6F2\n\
spBjsU6ZSffeiLm3GhcG9hAW3+eiEXMWJLY8T9axBhmty9Bm6EdJz3M083Ui\n\
Fq8nnSCIpoRRZO+ZZEVRhFeQT0hi6Pe0tyPsDCCo6IZnQoilshNF7fnpMGVf\n\
gLOpFn69BYGJHvg0rPqZHrbcDHjVWniaSmE8ewqmrFwE7T7J0c5RXrkdo24P\n\
/HMB+MhS9c0FuZxnaH+96RDsQrV/HG7eisOKPo72lzuEBd6pLsIzjcfhFRUD\n\
DX1nRc1+DBv78QStgkmfcG6SzdqHVY2H+UF2D5S8ghV1W7CybhOeqNuAl9rO\n\
kZIck7EQccOUx8J7fPNcwtcZ6z3+NZbNErOf/2PAPRLE+4UFODulJa1pDBnj\n\
Slwc7Maqum6Mmkxc1p9WaHGwrhIHhpQY0qrwZEE56mdnsLK4Ek0GC/L6OvBI\n\
eQu8/yDcK5dwI5heRog+pj4QA/fPQ3G+FaUfkh4waURHci9MtCIrDrWj+XAd\n\
6pKG+blcdbsrOdxzX2DFfk0Yz25D5blhkW99CxPKQ1hb9htUT57DkbrfYXfj\n\
S6idOIT9dQ+jX1eN/TV/hZaYksF4HnvqnqN7B7CDliFT9xLr7sOprq1oUhzA\n\
3jqyyxxKEu5/RdZwMlrp2q6axzBJDOw08eQB4wC/lz2SSvf20b3HobAOIbHh\n\
zzg/lICywfewtvyPaJ3Oxb7aR2CmBTCjOYU9jW+xI1OlczvcejfaL6jQnDML\n\
zYywdWym1YimTBVG2iwYrtNjetSJqR4rPEzHDYbJtLTCy5sGkbOlH4MDnrhl\n\
wkKlXmjWroFHYYE9dRs0ScKuRVfJCUy99T4suamYXPZnmBv7YE/eDlM96aLd\n\
JZh++R3YqvMx88pLcDQ0wXhoA2YPJMekOyyC3tKDx4pX4ZHqdVhWsx5La9bi\n\
8dp9hPEAdKZ2vNZ0ELZL1kqD8jwerTtA4jsElVHg9KMeYU20KvPweN2HmDSP\n\
YFn52yg3avj19ukCLKbrA7ouPFr+LmpMajiDbuSNnMVjtR/CHo6WLQ6Zh7if\n\
0zNZS+Nk/y6EW1GDoJNLmWteK9I2wS6VAmvqSG+ua0aT2cmPFEroaMc7tQ04\n\
0DfOD/g1O8zY2thE15pwfkoIGtdNjuJN+vu9ulo8XtnGVJQFH3+hzCOg7xI8\n\
rtyHWwPPDDNr5+WF4jda0HqyGVV769BTNgO3Vo+Kk4MIk+XVc64Dk506jFeO\n\
wKCyoON0J5qOtaB8VwPUCpe4UH4Js62dlIg0lAxtRPF4Gvpnc5HZ8zZaNE2w\n\
uYi/KUu5PJkLW9Gi+BB5/W9hY9n9JKmrkNq2EgWjR5DV8w7atPwIMThcgygY\n\
WIfzfVswYlViPqTHyYbFGHO44HIPIJ/uZfZtpXvCMVh2J6l6A+tRPHYGrTNF\n\
mDDUoVFVw+8FAxo0Tp2BUzQ+wySACncMoOaCFn35M8jaPQ7VsAOZ7/Wiu9aI\n\
+sQxnHytF2PdFmRvGYDGMId5mwcZG/uhNUVovlxIeqENFxNnOZavv3y5aLds\n\
gldphSNjF7SpQhjHnrQNxooO/rvl+FqYG3rgSN8NcxOZRF2l0B7ORIQkj6e7\n\
E87qYmi3vgXNobMxy+UO6EirX1KxCXXGaSgdakzaVVA4dKTYzENtaCXzar+8\n\
XA42bcbBiV40TWfhVwWrsLh6KwrU/djbsQdLaYmdGErD38rexIlJknyucSwt\n\
fRGP1WwnLeUcXX8dB8YbyXwP4nj3QVqWO3G4P5nY9ds4PdUtVXv/qBUgl0Fj\n\
nlQx1if5b+fEQuDRn3mWWyyf6BSZh92hJUHaCve1CwihaIhQ/jccEkLZXo0O\n\
pUf7ID1vPhjAcOGAcHSJ+GTmnP6SOGaPdxi5gxm0Tk2kPK8grRNyGhc7Qu9k\n\
w+MYstvErQpfhm3CgnOv96G3kQRImxHNuWqo+my4SNy0vZKuNeiQvWsUJq0H\n\
udsHCUOEJ7sH2dsGYbBGoChV4sKBMVzYNQKjdS4OTl/mfFm3bSt8aheHk+as\n\
sI/cnrIDxqp2+XcZTs398PdWQnvkAt/DqX7rWWgO7IOFFE+/0SEpBExJWclV\n\
cemc0K/A7TOhVT/E1GT+M0Im6rjLBqNrGl3GCVI0KtFg1vE64vmKQuwdOI8q\n\
3biwsEMOdOoH0WvsJWRlopCQFpKKZ0d8qJmpwvGRXLRZpyVr4KPQI/lWggEP\n\
mklXDc9fO//7msj/wl4vZkfNUV/Y3Bw0PWp2yILokxVi7CzCwM5I0ZDQ9c5F\n\
oml7dE1rG4U3HJbpbZ+04swr3ajOUKM1expJb/ZhcsSDmS4DmrLUqDszgbRt\n\
RMtZN3K2Ev8wEs7cXmRvH4JO40PJB4MYG3Gj/ugI2prsl9A7pOrDzAtPwZxb\n\
CVvKTiieWAoLaUzm4xuJfQjc0XZmE0y1XSSNCQOlVbAm78f0W5vgaqvBzGvP\n\
wFpXB8OH1L64Tcq00Jq78FDhKrzUeADvtxzCe80H8WbjPmSrJxYIy/kmBN1h\n\
jIwbUNmqRFHTJH2mUN42g65RI0wOHh+SSx+zSfN4AjBZPTDZvHDQ76G5iCRD\n\
r02PvAk+Uj1GJ/SobBMf2Uif5inU92kwa/LwHUifvUaaS3163D4MjWlR0Rrt\n\
s5j6bBrQQmf18a1Hi0Q2EyYNaFZjQUPXNAobFNchr26CIFFIX6nuUmNo2gq7\n\
l6vuPLzL+PucL4jSXYOozdFhoFSNtM0jsJr9qDg2guYSA4mUaZzfOQab0YvM\n\
tzqQfVCBsVYT8vaMYKBah/SNw3CTgT3bqELGbgVbJeLQZQwEJ1qgfGoJDMm5\n\
8PS2wF6RD1NGOpykTXsmBSPF18OKOWvh622Eq6eHtKu1mHr2JXinNfC0VUJ/\n\
ZD995wLCnqC05tn6LpysxIXJCnpUtqKCrrFjyzusevHdBOY5ManDsbQWrNpZ\n\
hhWbCvHY2nw8uraAPvn0ewEjAJ79oBybk9pR0a2BzRcWWf0nYSJbKSGjDat2\n\
leO5neV4ntq9sKsCbx5rRN2wdeFV8XFTLD74j1FvRWZRD17fU4EnNhfh8bX5\n\
1JYGQvBjQ1m8oRBP7yjDhrPtqBnQs9QoSTW7HCo3xUKF/2hmzUjN68QrNNKV\n\
m4rYW8Z1v2QDmWE7yrE1mVSeESOjUzR0Mo+hCS1DKn2ltFVJ10oIYS3j1rhy\n\
PRaTHUWVg1hzqBpPby3BknV8Eq9js0hrks3p4+sK8QTdemF3BXald6N+2EAG\n\
47x4js2X4TN70ZI+jZoUFWanBSXXqrCjIVmJ6mTSAhRersaPNurRW6JBRxFZ\n\
4CRIBptMGGwWzqIl2xR9lXpmAccBTaivaNj8DrSJ6YyLSyWlnRcTYOsaR3Cy\n\
i4zb6kXi67AarAUlPXiKYWJ9IRGvCMs3F1/PJ/hG9itNeBGW0K3H6bP6YB0u\n\
ts8SXaLlQh1mK9btKcWjNBP09YXsCzR5f3u/AMdJ9QRidpFeBpFPcojk9Vo5\n\
AVpaRvDijhI8JnTFHn8Db3aDMIoNwijWJLajT+2UnYuXQ+OTHBq1Ey4+HVU1\n\
A3h2WzF1W3jFbqnLxYSMTcldGNVFYzjsqyfS6vDf7+RxFOXTtYffzcU7KYPc\n\
ByqlP8yHg6iqHcLLbORE/6Ubi9hQPsEf8Qm+tNhjFq8v4I9571QrOqds3xGf\n\
Mm/3crVBZ4qInFi28MO6aTjb2nmirlwaXDuNoMXJp4s0/jvEy4yOZ7OapbXM\n\
X+86PiGf5kRcEfNZtlGYxg3neqBzCH7BvJxmImDhghtEJvzYuiIkVKg+gno3\n\
YPGmEuT3mVFf04cVG+jdifbXi33EPFe8dj3NdQFWbC3HhVYNm8NPXpWCN2DJ\n\
ljLUj9tQUtyJpevyqeviv9P1Qj6/T+6oRHGvIa6W4+nMRgZtWb4spXbrMoY5\n\
CaVMOp/TjRPJjXx49Ap8FhZGcSKMe+nmMqTUq5in6ltS/+E5mGbc/BRXkXg/\n\
EG9VV/YQeytgnYhD/CRHGuNBTxJ3eIo+KwgWjxPWF9N1enXpzdmlN463QqG3\n\
YfPBCizZyBaUMJCltAaWEcAefi8fx8pmrs58r8fyLaXYkNCEZzfTVzaLvd/I\n\
e+ALjHpZQTxY+ptgG51fhtcNxTjfqllwdRpR661l2HyqkbOP5dFHLJEesSn2\n\
EXzxyY9gKFxC6CnqM0Z3HH0EuaR2bqcTO07UsImKDnmjMJc0v/TdJ7aw4a3c\n\
LM7vBj48aQ7Z2z1KAD9VqWTe+R8KhPs/0oKMyFaM7OW2G4x4ld596SaJEl/g\n\
D1xCa3tLcgfKOlSYnLVBOWtFz9AsLlaPYF9SE+c6j/OJEPDKiL+KxMJT20o4\n\
MCSKU7/YmEyigvTY4oYJ4g+OBVcirfDszwksRlwDbHJpbeD9Uy1IrRhDXc8s\n\
uke0qG2bQlJ+D97aX8GBR3RbGEPeZVvKWZa9rBbHkvdKj2E0Xba5BOtPtyGj\n\
ahwNpM51DWtR1TqJ03ldeG1PmfCYzdHH0NdX7qjCgN4X1b4/gsRSu7mAH0dO\n\
13GmJPT3Gb5c2FJ5cX8NjuUPoJxmfWjShBH69I5okE+zvucMoXEzQ2+RNAz2\n\
tUc3lJAiYhR1ms/yRA7MHiGD6CVAsYP07zZSHxIBnsBB99QHgP7lQO9iYGof\n\
EPAukDLkYM4Hhp6m+08B00eYN0I2gWEtpnvPAIPPAfpyQHcGcI2JNTO/LPYQ\n\
8U/BMboKps5HYO5/Dj7bsFy5OOSogkPJE83lnR/lpR18/azYHLO66a2e/KAK\n\
pb0GpsVLyhpLkdFpLUgv6MZzhL4lfJUXS3JPmnK2KlcQaabsIfkpsUCL8r1C\n\
vHGsGQ1kcAWlZMzr4XV7UFDaiycZa4niikHx9VMdcISiO71jcSX1yoj4XkI7\n\
2idt7MA1qVen3YWs/E6Om5heGWNfk9zHgszR/eMfAaNou3lUlnczNW1B7PJf\n\
Skg+XjYBkzskbz1gp8VN6ThjoddeGMOnntpdy/JO5QAXVGuBygVA11/o8zOg\n\
hjqpIZuLpgXKV4EqeqWBlcAYoaSBKNvztJAip9lJ9/4J6P4rIW8pUEtw76J2\n\
LMfCkkp9UJ/tP6d7hLyGLwnPUGXGoecT8EyQGdH2APyWTrjGH4eu6V5Wxlsq\n\
0eDXboWu/Vd8GqKnoAaw+2gVWxULpBdbspFEdy+vrSnLy5lJDd4nXY4x0VhZ\n\
8MSueujd4StC5foY4r91sh0Gaif119E1xvX8KO9aSKpHETI7DNJiugwkUn9L\n\
SJ1Yn9QLm19SjISdiLWNg4SQOH62mFZ32bA1rstrRYhVa8DqrUVcvYhdHYtp\n\
elIbZ2VtMOj14nRKg5hAJr4KsfYPcseYEJFNVfT/FGh9kJcjZTXuMfgHoO4W\n\
gCWt9JGsGd0X5SSqzUD9VwD7FNBG+Ol9fYGUNQtbLtD4b8RRxuh7PwKaf81S\n\
gwTBpD9JOCJsqHPisPFJRAKz8OrS4ZraCu/sORibfgCvbQZhVwu8xjopbjjn\n\
6YJz/HVYB1fDNZstpw+HnU1wjL0Oh2I3vPp8+M3t8OsPQN9yDxxTO2Abfhke\n\
Q6NcQMRtx9v7y7jqcF0MDN5M7GQRT9mtblDr8ObOEj7HsTLoiQ/qoXNdGVax\n\
7VburMaAwSf319QwwLXNqAildUrPffloO5yh+SvCKiqUaD3vrSPOF4zR9CMo\n\
K+sifERpy7DydmIPT8G5VkzdENNfTl4rswQXRLlYIcfKHKLzEvb5cPBUNV+W\n\
18W877JtlejT+RbIO40G/hPoeB3yj+EYYeqrLJeIZ/HCO0mSJpn4BvGZOsJg\n\
2x8JU630O2FkgPiRNot4z3nh/xlqZ20HWqjfkWPRFKigBmj6AmEya0EcqG6G\n\
b3Y7dPQ428ibMHfcA001GbFOLXyqd2DofE5I/g3OwNTyFRi7FsOp3AN9/Rdh\n\
m0onbcoNc+tt1O4vsA8/CS2xP1P/eviMidBUXAdT31MkCp+Ctub/wm3okYfj\n\
MZrw+gfxy3IxLbd9F4XCRJ8R2/V2jRJJ46FwrdBiJDlROc1byH6AuSCOJtTE\n\
c0qyJeun3DIPuhq0FhNnS2/RxfUXCfrwwZHKy0i8nIygXp3/Y0PL57Dj3V0l\n\
cfMivG81F1GSZ02rVOM5QebL7Ri7Olyu5C2ui4PWK1FomRIFduUm1mVOIDH0\n\
RRJLBKlWajexCfDYAV8ftfkngT11/Ik+xOLa/lNgSQpSllqJpY2ejEIrbBbg\n\
pjovQUv4j2VchmDpuAtWhRAoj3h7Yai/k15TDZ96HYzdq/n1oPEEdI3/jpDo\n\
yA5od0LX/CuEPUoYW34Cn1gk2tH/C5gH1sFnOAJ9873C7hj6cY08QlDbJJuy\n\
ZjPe2F18CboKsTd3JA5d80Evthws5xbYtaJLFiJcbtZC6QjLVBnrm+CMa0Uc\n\
VQrJkpu6Krpin/vM/kYYvBG5v86mISxbH98fUxTTmjVx/V0rusZ6xi4bHzN9\n\
t+aMcC+Y9Fy29fHYmRo8+O5F0cG2EH97Lw8vHmqBW45pfvUK6CJE1d1KKKLV\n\
NHAvCb/vE9KEUiGwklqtzef1ItBK1lj/WvmsTlgvCoqTjlTq3h+TkvQQ5F2N\n\
tlKgmgnDC3Hgup1vYjC3LSLJWyc29RH/+iW89hkBXD2vCWDS7YO+/Tfyrraw\n\
NQ36xv9AyDUGE7HSoFvIRfIq3ybetQY+/YfEz+6X2/tnd8DU+7o82IjfhbWE\n\
mnixWIA3T3fwTWbCLN6IosJWPLq+UHbMXCuyGEU2ZvRztUOiSMjrwpq9pXGI\n\
ZhR+46wgwv4espgPc0/BeByFvXYr3vig5LL+1p4f5iLs4yLrYn4HFq+9BPmk\n\
tlWIaptUVn1GoUVa6TAyKkb4J718GDkNU3CHY1DVT+pQ+wtRVBmPE4/6F0KS\n\
n9TvlwT+pSJ1Wk28qI5mskc4fx1qQlQVjXn4bTL+jpJKRTyp+XfEXeiNDKcE\n\
/sUMvpntxK9uFVWsy1BF827v/hHMw/sFanvqiWXdRjM2S5JyHXQtv0Y46EfI\n\
mkVS8+sIiOjxz24ilvVLYlmTMLXeT6iyi6h6XUCV4Si09d9BUMwFcg7+lq6v\n\
i6niFMbRkzVxkoQpqks2laFixCajqrGxH4+t/fioYnwosYZHIqLrnJ6endMU\n\
R93lmwrx9O4G6H1zfxdVj60vRk6nIb6/+TkkJNcxGyDaHylkLx5sgT00f82o\n\
ktuRtD5ytoaQFNtfERls1VDYwmIYjBAzQ4r2xLkoYhzVpJgTX/L7eSYwxl8m\n\
JNxDEu07ZL6/wbYGig1p9jV7CG2k1Df/hHgWoculi97T7qV7vyDp9ytCFSla\n\
9TfGIEZ6a4tHi9zpLtjD0ozdjKDlAulIN8PU8wSMrbdDU8V0Kla4YQv9/kno\n\
Gn5ImnkNHIN/IkH2a9hHXiA0fQX26TzMh2dI6N1HyBKCAd6p10i4vQc/06kq\n\
b4Sh4wFY+x+GtvarcJuGFkjqelVFJ3fLxa5B5gV8dl8dumecckW57s5RLBNc\n\
lx8LQcyorlK44tZzC0mopcK6F/sqxsrtFRg0S+b0jbHoEdrR/8u2lqFj1ieX\n\
eywtISM+rp8iPL2rGlPO8MdGTcjtxiYa+5JNsfNA5sPhVjgjEAM1C3kxcYR5\n\
smL0GZE5lvISc+0G7nPh5l6ITLzGzzGTXS7sEfTPwaz1w2oOyfKCnTpNioxM\n\
l6BvDiEhsr7gn+Kho3fNYHXjEWwZ7RC7/FeEHGTlTO6H19SKgK2XRhMgg24U\n\
fmsfvJpT8FmHuQ/Lo9oPBxl5XmOn+Fw3/IZGkt2Czz/sGqDvjNBbznJfgs+Q\n\
BcfEdvht49GFbbbgDVI3oy7oT/CpWrmtHEcvDqFn0kJcN8yC7dJ24n8UPcu2\n\
lKJJ7YlDz+SgEk9tjPbFkMG08fIx51XRw563Yns5+k1+GT39rSOSXiO3WUav\n\
0Kbyfmz0BFxOrLtUMjLHVyLP717wfam/wDRpzzSCmWx5u49x3ImE9ZNI2KrE\n\
0fcnkZlk4Cf7zXSbcf60SVJPtf02HKHbo1OSZ3HBQnle5tCobsGegWKkTbWg\n\
Sj8JT9CFjPEKHByuRLW2H6njTTCSTLPZx/BIzVEo/aE7xJ47moewfF1+jBn0\n\
aT4ZzDRgk/zS3irsTunAuZIh5NYpeMR8cMoMg80Hv5yJeSN6uv4xIq/cSkvf\n\
5I8h8kIYpshU2VIYnwSwqRSFgzaZNFcj9FM7q0nBDsmEnh5U4EkhGCECpogH\n\
khqn3B+b0E6rGS9vLWaxkzjh8vyhBqSVD5N5nF7GmGty8RCGtQLbk85B4z5k\n\
QyUpusYo6cJhZO+eQk66heROBHaNB6ffn0BHnw/THSYkHxNKiAUcfpxZO47c\n\
TAvz7F4CgAFtC/678jAuTLfj3aZDWNqSjUp1DR5qSEW5uhuvNe7HA/UZcIbn\n\
0a6qwvfy1yF5dloqhux1+uCw+9ihbcQI5njBx/l5SAWnPXY3lOMGzCitcHtC\n\
Eodjx7rpZiyYHDfCYPDwtBHpK0yml5f30rTz+Kbgvvssp8AyKWhL6GKRSWZw\n\
r9xSjGd2lOG1D+twKn8QbWMmNNLyXL6u4O+YWDfGoimKuG2VmLBJNYEXwqzS\n\
4Pmt8Uh6fGMJsrtNH4mkZz6ogcYTlpE0OzqFpzbHI+lxQmXVmONjI8lFSHpF\n\
RFKsX4vPC733l/i/C/HgOxeR1y1kbnxN/G7Y5sfZzVOYUkkVMz6JprMqXLxo\n\
J7ZhwtFtatgsQdScUeHYzlnixmLCnfi2n0fOYCq2jfdxbKnN/Xi7LQtN2lY8\n\
1pCEi6oeJA5lY1V3LZNf2NyaiHWd6Xito4Bl6ctiTDWgwEGi3s41JZgg3PaX\n\
dWL/3iZY3RGZJzAgDNQPY//6Inywthi71xRiz5ZKtHYb5TZOgxWZR6ux/V0y\n\
OUhB3PluIZKTe2F1SfkmN2BwcBrvH6zk7h4WMGPUvJHN2nWif3iZGOpjUHh2\n\
R+m1ehRldJGgaVV743iQ02jAC9uL4hXYdUU4V6v5SOSsJGEzZArIKDSq1HzD\n\
cazr5dF1xSjoMsf09fH40GoRPf8qoZoU/IJew2VISd4zDZUhyqf78rXIy7NB\n\
3WvGBy+N4fAaBQ6/PwXlrFQ2UIZJ3lAGNo32cJjMmHrxaut52IMeFCvqkTrV\n\
hHXtCXixpxYWpwIrGs5g2qnD0w3H0e1yyzCpS2nAljXEbpvU8JDm05nXgu1b\n\
amF2SkP6AmZ6J7D9tVycOtmF6Rk71OM6pB+owIY3izGodBMK/cg8VI4t75ai\n\
oXkWJr0d7WV99J0cnEkZREB2yH4GAa8P9S3j2HaiDs9uK+VO4Md4Co4Q9BVS\n\
MYqEHIyYtJZN8RkR/7iKQhraFaQXM33SmnQfiZx4NWUhlIMTkvSK6asEJX2x\n\
KXbXjhy/04H3dxbHpU4wfrxY+BCXXsyjGVKQMM44J4TlXwlhuwlh+ijC+gsE\n\
hM10mZD0oRbVKWocXDsNg3XuUoRNEfN5qGofDoxW4ZWGA1jZlgO9Q4WX6o8g\n\
i8TZ2raTWDfcgbyRLGJI1RyJRztPYetYj0zxioQ67NhWDxtfv0AHIWzH1jqG\n\
MOECTU3BsWps21gNozsixWUDVjsunG5Ge78Fpgk1dhAAL5appAntrexHRno/\n\
XD4pT/RzpFbPwWR20lfUyK+fQFrxAA6mtuK9Q9V44YNyxnnwBAuMrxeE2+NC\n\
jP36j8mNWA5E6agjDlOGyStrRAVxGtGVze6lZDi1qP4/2t4Duq7rOBfmiksS\n\
x/7zUl6S3z2J4yZbLpIsWU5ix1Wy45bYlNWoQokNYhU7CYBEBwiisIGdYAVB\n\
ovfeewcugNt7773fi+/NKfcCpGxF8v8/rHUXgHPP2eecvb+Z+WbP7NkP0mjl\n\
wu9nRQN/BCt6p/PEx6Kz25B/axzFt8c/hqLb43Rq8Z0J5NB4bTj+4IzFc6QM\n\
2wTWpJ/FwOp6/lpY/VkSVhwxMrNF5rvI7J1KV0FnjvIm7oP8azKLbc6KunFj\n\
uRl7xirBpHdOG2dxdrkNV6SjsIRDmDbMYt7NzbloXAq0GhUcqD6Ozst9LIgs\n\
PIjeCaoQ7hR1oCCzG/29UowNSDHaL8X4gAwjvWIIxTbI56TI2lWHu3cXkt+P\n\
9cswPijFcL8cLn+U868/wi7sDYej8PrDMFncWJaa0D+pRP2ABFerJ9kUOLJx\n\
79eusRM4XeoHkDQ3IcaGh1z+94okxv5V84HaBJIGu+fx0tFVR+r/C5IQDaP0\n\
cvcDkzeMb5lSPAhbJE4Kg1nS8qdQSWTYkN74wD1/d6wdw1LPAxC6XaRaY/v+\n\
HIImA+rqnVDPWHHnAr9FJXV7J8HofLYGZlvi3GS3WuxiHBitQCD5yh/9/eAg\n\
DWTzJPKEQqgo6ULW/kaUZLT9CUoz2+mpi8lNzdhdgzu3BeTGypGzuw4n0lpQ\n\
mtW+jjvnAyggHXuczJ5M70+mxpv1JhwpaGNTjd5vyIGZyM2uWmQnaBMj1rSa\n\
O5KcgHk5qw1julXX9/emYVNbpW2yB6f9afxu3R9m2nvw2XI7sJic0HkfCKDW\n\
79WOMfd6sL38bojsq17d5MB8IsyRtJ0v53ZBYAytTtbEV+B1RZmMvGRqatgX\n\
hc8fJ6DF4XXHkhtWxOJwWMIIhuIPAyAc8UPttrJP+f/w2qHrCgcAKz/gk3Wj\n\
yDjUBrkhwAMgjsbzxGmPdUNnDbGLVCL0camNKDpUi+oGJaxyLXIJDbUtSrZi\n\
BvM9Y2B6bw/g+OEuGO2RxNMxq2gC5JUFQwzhD7J7V4UTxTewuiHJMHXKC0ff\n\
vwvOubAjsIdW1sRzSBTPvTNKubGgD3r/u8/zsoH38xNswD/RXjwUQBYbN3vw\n\
vluKh2EPv/d53kT0YGF8ie7zUJyLSFbTAkep1wL0+t2hB+aXGW9hW+kgzPS+\n\
3NwMn+r3CSZrBk3nepBzvAdKvZ/dNGGyfgzpO2txumgYSwtGuAhDaqKsWcQY\n\
blUswM7s2+byoOX6INJ312OKKSNElPVuUTty0jowJ7QhFIxAOS9H4YE6XLg0\n\
jWASk3+KqYklpOR3YHdxF/vZXtCBU02iNUnmpPGWVXgj7b0PbTJQTVyiS+jk\n\
FRev0jR6bMpseihXogF7rk6zadzvFtB+iTT7BM8lEu2pRYp3cFQ2MFSxyC7n\n\
eb9D67XbsDun+R2BptRb80zNguTQMgWvDhe8MyB16PoCq+8eGNqPo6d8CFn7\n\
6pF7sBF5h1vJafViioa2ILMDl6jLU7dXo65Lxzqt440zyNtXh5xDdO6hBrqu\n\
AQ3NUoR5oXNoTLiaS+p8bz05tk3Iot+nTvRDYfAn2P30lBDPH6pnHQ4GcIxg\n\
7rgwzpYqSoyqfFGJjal/xKgSsUy9PceuKlm7XKGKDNHvUtdmI62mM7zbqDKE\n\
NbdW+EAmCtMNV24NsEWyEucxVuPuqP6B9t5zBsxKHHcqhx7IgHmReEe/1PUA\n\
mpj5yBcfCmAzWdPlfAA7oclXYl6sRCz0MdHH8ye81K/EfOytEA+yKxKZDTyY\n\
AobsD71SzEuv6efjNfEAs2UY3+RfYCVkQNQjpNMi/Ol8W0xmPZNUw5S1o1vG\n\
I4ltyXhwfQQWNTGKok6S906MjevJ1Y3CYSAOqHTA5/aRvZJCpvYk0rwMCiNG\n\
exlKKINS7VqzM8+H2P2158cVGO6RYnZaB88abStfSgJmjQvajkneBU1Ygp7u\n\
GXbw1xKkVwsIWP9Dxt4LNCBNCzb+pbjztLzrsXbSk2lvQ1YHU6j7XVOr2FRv\n\
er4BqSsJLMmCDBsfUhcc8Hsgc0bed7qeXqFmE9ofUD9kgXaUjcLoi65bXS5k\n\
w/4TrQ/E4FnakE20gd6D6//PIih5Ec7hr8A1/h04R74Gr+QCWyDMt/gGOY1q\n\
hDXFCJgnEfO0wiM+z1bU8AtfgnvmObgmvwO/8j7CquPwqStYFMWczXBNPAnP\n\
/Mv0+1eIBczwCd5EyKFltnOFh/4OW4fhHv8C/No+Hlh/zz91+4UeHEvrgc2/\n\
slpwzcjknj+YCcU48am350G2KTlyfqcDRwpbH7S5dN7Ws2NwhlbeFQkvsTHT\n\
XsxovMncTbvJirTiNjYXdK3qSK8QsIr+3XI3X0ojjlE8AJE5kGzPSHRofwE3\n\
ImsTKE80SNZsdP0+UntJ3suJPj23RmUxz3eofBI6Vzh53yA5rMXMYoHU1fsy\n\
5DazcnlN4uZnEVhaD5+2gWTfj7hvCq7RryNonabR24CQTUGjnIWAaRgxdwM8\n\
wjLEvQOEmCcQ8akRdXXALy9EQLoHXiUXZ/bN/wBe+QXiQhoE5KkIO8fhnX+J\n\
UKUiJNgIIS8iqKuAe3o9w10fQoJiVomBfiX84VUkMBrt4rVecpjWvDE5RvnV\n\
SzD7EvtVc1myep0FJ7g8trUvnXWPs9LvlvPNELqNBT1omNDDH4knsrNjkSim\n\
ZuQ4VNT2cHY9I/SjKm+y1d+X880I6eaiPnTMmRBazfmOhsMYHpPg7XwGuQ/4\n\
vC9nd2LRHFwd8Pe4dIDJ6N2VTU+VnlBN3Pqd7acGMbBkYch08p2iUQhFWmSd\n\
616b883NzXVhXp/YGZqBx+/g13ci8RNS7CKFUASv4HWChxJhdS4pinFSFC3w\n\
iC7R7044+v8ensXtNNTPwzX9Q/hEu+BTcYrCO/sUnBM/h3dpF1xjX4afoOBd\n\
eJUUBWOu3KwCCervwzO7gXk7Hh6P8+8oWpBiA28aEssjmOjKjpJ+XGtdxsiS\n\
AVqzB1aHD0aLGyK5CR1DEpyrGOOWBSQCNUyApBmtS9x0wB/2G/4SrxxvwYaM\n\
5mQAhtEZzHq2vWVDuNkhwuC8DvMSE8bn1KjpWERGWS+rf15Ys66ImScrbpKy\n\
1OP3gSV5r4wW1pokqBK7WCidW+NS0S3G8IKevdforAr32wRIO9PDwnbtGqb1\n\
5Fxf7lWv2X74vS8wmpsW47X0xgfCpOw6G+YZLgzjZrsQXZNqTCzqMDAux91W\n\
ATLP9+JVNuC1qmeYd1hPjPHWcGLT6ASQOpJACmvS4F7KZnVD0DSHoHgrfIpy\n\
hAzn4Jo7RPxlAe6JpxEw9CCkTCUgvYyAbC8cw99B2DaLoGI3nbcLETtZFVZn\n\
DRK4/h3uxWyEzZVkpX6EgOYygewHiAScPJASy03C5KkNqQzMLkm8K/1Bptw7\n\
btwbZld0JpfzfIQd8Od4h3NjdisbxXuDfr+WwU2CPjQBytC4zMolEvZV0fx9\n\
y9SY8MmtzmWkME5AetM7lqkxEZaM5mS8jOneD62BU8atBbjCiWnbP/8DUeJO\n\
VHQKWD/oxaR5XL3Hy4l7pHOxSgayq/doxMlqplzAyntexLR2ucLImBCvpLPQ\n\
TCwDfJGPUjDOAqM+X+Ifgw12PbxMrRHnmmVM/YZV/DwHv6GXA0/cC+/Mk8Q+\n\
7iFsakLEIaD/vwu3YA98whQ4x/4T0YAOMdcAKapt8CwdQNRrQtTeDJ9kP3yy\n\
QjKjHrJPx+FZ2EY4qWLZT0h/CX5JKimhjQjoWxFQHoa9/x9Jwc09hJ+Ay4K9\n\
ncNM9at1icWozFKJC7cGE+/I9uQHk8tSE292pB6HLk8whuvP/iA6PsSGXMbJ\n\
NRctyVnF9Xzquy8wZZtmApWVi3Alatx/5A9GX5ZtIcxMi9glY2t04u9rmYV/\n\
WjNKG0QEBrzXNYscDeFKUszOSLEju5mTlOPNSYz9vtsxq56YLJuKIQ2z4pTT\n\
YB9DQPg7OCd/RaZkDzGHH5E2eJXNMQ8qzyLisZMZyoRrPoU0Qwuxkx/TMd2a\n\
7Q2TSmddcglKIieJGI93MZXVlvwQc1T678kniqJBsIzjg9O4syzHlblldEkU\n\
eKulB9mjc8gamsGYxYNY2I8mqYpJcUU06MN9oQJOMu9tTGFRJg3KYUXB4AQK\n\
xxdwbU4MhS/Ez3r+KTlaYQwMi3DwZAfrO7MrNrmg3boP89KaWEj9Ip9R8EZ+\n\
F653y2EPxtYUhbZiS04jm5L8J+z60D8jODShT8W6TFArDcgp62F7l48tc4PA\n\
rdNORJZfy+7AnQE1kzn753zHu8xGvHa8IRleZCoo/O5YC2ZMXDU7iUiD9NNd\n\
Cf2xhvusNs0I+Rt5XagZ1zHU872uUk5U7jfqrThVPoBXjjWurmV/6AV4Lcks\n\
CM28OYVFrefP+BeIeUUImTsQMrWQBzJCZJKbz446ZxAL+WkIDGRzquhvJ+mS\n\
OkR9pqSUszCJc1lvD6HDaDZgQ00nutV6lI2M4pnqbkxqjXi5qgUn52Won5vD\n\
+qYhCPRG7OkcgoXeKOgw46X6Xii9PuxtHcK40Yr9TV3InRKjbXkZ37/ZgG6T\n\
h/e3P4wAOcnDEzIUXh3A5txWNhpA+uMDyaIL9exLM6xhU147jl4eQe2QEjp7\n\
MOkPRvxe3G8X4FqjgPr4epNg3V+hvGURcns4KRRMdayRCSmyyJIztR2eZ2s7\n\
cEPO/mYDHy1IKerB5RYhpKbV/YKZrLCKlgWUNwqY1un3Aq63LkHnSaRtfIyP\n\
VouQfqYbr2dyK4NX269n22feYXtJL653SqCyBdZM+Lw7RhL1KRivSCjR43rt\n\
FHaTMDHLzMk4f4CtX/BhliMytSlSCntwrmERM3I743w89eCYOkmKUhq7UDQj\n\
Qu2cANs6R6GykkPdNQIbVzQUe1r6UbMsw5HeMfZY0GnBxqYBqGlMU7tG0SNV\n\
YHv7MMzchqEoaOtDl8nNp+R+lE2atDu8mF3SoXVEjrp+CWp7xezvxiE5eqbU\n\
WJDbYHWHmK1nEgVt4ky1H70NvZNKNAxI2Uvq+6VoHVNink53B6LJ4jeMx6LS\n\
WNE9oWAjuIlz28ZVbBkYXzC2Zub43fv3L/k2g8EwlNTm0IwarcNyNNKnZUSB\n\
3hkNRBonkwy57jsP9iazWKJfKkcF6c4LYxN4tW0YCqsVu9uHoGfnnsLY3dyH\n\
BpEcKa2DUDMKxWvH69SbKr43++QqbGsbZApXMcoama09JCHudW+/x8fnHulv\n\
SM37oBqSIeQLQNG7jCCD/pU4ND1zGD3fh5nKOSYsQl6KHpOX+jBGx+RTevhM\n\
Vkj7uMLXbqkaihkTT2hXXzPqx96Ofpwgc1o2PIatXZOwOB1Yf7ceBwbncGZo\n\
FL9rHoXMbCHl0Ii9fTMoHhyh7hiDOxrC3pZBzFjdKOrtx+auCZwansAPbzeh\n\
3+J5368ZtVowVNzBphv1ZNfBGQCcZLZaUltgWNZj7nIHZjulmLvYg9lGMQzT\n\
S2jNaIK4ex5duUPsa+oI7D3XFhKvyQnYx6GzWXGdmro0L4HIFSS1GUK/UoMm\n\
kRSX5kQQu5mdz214u2MAVWQBL8wsYc7uY0eth3qOsYRhso6VAhEqacSPNPeg\n\
x8TVsIk7ZHDWX6OejO98v29MjzVKesVjdqD/RBM8BCx1TS8aDzdBUDWNmWsD\n\
mK0XwUOqdvH+BAYLW9BTRGAbXUJfMVeD3dA3jv4bic1p+dpBH4DHYcHB7lE4\n\
V9bu3hhGwcAUBM7EVNqHcbZrEN1m7k1iasL2kRfIiOC9vgl310fhtfrRPeQC\n\
X3ceerkHt29pca1ci8FpL1/zbQXzYzaU07Hym3osKzgjbKRzKyuNkJOczIzY\n\
cJ2+v3Zdh+llLl1kYdyOqgYLXGTY50e466/fNkCk4qxALBhFT5sJ1+mapm4H\n\
k2sE+ZwLEjXXvnzBia5+JwxaP+7d0bHPVNNsgyfIpz//DWJ2Goiz3fDaHOhO\n\
qyajHYC+ewwNB1ugIXd19lILOk+NY+lKO7qL+6Am91FFrqR5XoSO9G7EmLp/\n\
JAqDlcsPD0Sc/DKt08MGAlYHYgUGl4cYaZwfiMdgYioq8pXyYtpxGA79Erby\n\
47CUkkfQXMdSvph+Fu6u28mc9PBSJ6ylW2Eu2g53Xz93MOiA604azMXb4ay9\n\
Bnd3HUsCorpZ2Mt2wHohHZ622/BNz7Pw9vdfg6VkG90rnxiGh27igavyOJzt\n\
9xBRT8HTe59tNjTfCGvJFmp3BzykKdhbzTTCN7PIiYF5Ge6OKuZeySzTmFmB\n\
0NwQQgJiK05XohBn3G1BWDiD0PIcOTletjviRINX+NdfIfc27rKz6SPggROz\n\
EvvSqREPhNjHXqHz437fumR2FenruNvGXMvf/qNssfyIdAbB0R6EJULE+faj\n\
OikiKhmzTQ1WSKrjbmbLmnhCJJjmo6pFBIfbEehpoKefp0vj7y+a8iiMEjuy\n\
CrVsDW+/zY+CLAnuNFoxMWxDdoYU46IgNAI70tOk6B52orNRj2PZShjdMbTd\n\
0aD4kgHTY1YcPy7H0JQbY30W5OQroTSEcKlEijtNdiyMWnHsmBS9I0601+lx\n\
PFcJszuK3jodsorUGB62oyhHgvvdLvRW6tAz7SPSE0ReOtnsTjvKzylw+Y4Z\n\
CwtualOOyi5XQiQ0LVNo2H4HCy2ka47cQcP+Osin5RjJa8HwuV50ptdDsWyH\n\
tnMc3Sc6MFrahqHyadiEUlS/ch0Dpd1offs+JLOWhEhw9au+TjCehn7TF2Aq\n\
SYW38yp0Wx6Di/yRyPw96I89x5aojJlmoE/5Jmy3zsDbdQXaLU/DQ1Dz3N0J\n\
3Z5fwtNTCUvGM1DvpvP9MdgLfgZDLrlXjUXQvv5FWG/WIjRbAe22f4Or5Q5s\n\
Bb+BPvsAwvIh6FKorbFBGuDLMORvJvdrCvqt34Dt3iUSjfN0r3+Fb1kJd8Ve\n\
WK5w8I8uNUJ/9HVm40VOij/Nxq0CjcWwvfktWF57EtZXH4N160/gbalLOm3R\n\
+VbYd/w7rK98k/3etvPX8NwogO2tH8I/IeYkq+0MrK89Df+UjJPqsbuwMm2+\n\
+Di8TaPMxnNwUBuOwizG6ieia6Hui9Tk1+A4kcnMMSeja2EXvOffojt+HZbX\n\
n6KWn4D9WAr8tSWwbaan3PYMwg4fgvezYN34PQSF+mT+FrM5sq98LzVLT/v6\n\
07BuehqWl75O1+9ARG99r5mMCQkwyRwoKNWxaz7lExYUnNWBr4WA3iotLlVZ\n\
0Hhbi9tNDv4otXuaWOS0B80VWnROeOF3BDEn8MGk86OzyYj0TDlEigCulikh\n\
tUTRfEuNu+1cghhDoy+ekqNr0IkLJTIMLHC5HhalByNTXvRX6XG73oK6CjUK\n\
LujhDxHtFrih1YewMO3E6XwpuRqOhAT4FBp0pdVAr3ITOfDBpbPB5w2zVW5M\n\
ixq4rHw6I720Q26AbtHAJLLARkSjM3sANpkBZoV9TZxkVQK0YzAc+A05/JwJ\n\
89VnkDQUIbRYD2M2O3eMQF8Z9OnbkuVSPRW7YSo6CuORZ+Ge4pRuZLmBLPYG\n\
prggbJk/gHuBg5Tr5k5YyyvhuroR5kvXOB3qksPdWkWKvBWGLK7d0NgVmEp3\n\
wtN6BoacfUnYuq5uIuRfhLsmDdbrNRyUhUTDMrauSsDnEB6+AesLX4D90GsI\n\
To1Sc41wHvgRYeZJBGaYvdqDcKf/J/3/ONw3LyM00Qlv2VuwvPxVWF79Dvyj\n\
QrbpYNNJWJ7/Bvxj3OP7Lr5J5zwFT9U1RHQWrAS0cGwhHGcdZaDOY8UHd/av\n\
YHnhy7C88WOENPaECERGrrOP5cjcwZqe0FQX3Cc2kEB9mSD/Hfg6u9m6tv7b\n\
R+jYtxBc1CTzz8KDV2D53b/AkbMH4eVFRDUiBOpLSJwegaOoiBHANWb8vcjB\n\
h1g5yD+lZXtcNmJG8VUj38YXMNPO1Hg0ofamBrV9riSgKq4o0D7mRkulFu0j\n\
HmbLeNwgzGfmyHCpXI/xBR9igQgunVFAbAij/oaaPDBP8vpblxRo7rKhrFiO\n\
SXGidv8KQuE4hmv12L9XiLePSCHQca7ezIAF2ZlSnCxVob7NRnQklpxYZwr1\n\
zpS1YKJZmnRtXVIlpitZFPIzrDy4P4mYZhSG1JcR4VOvAgPnYTp5jIaiHobM\n\
V1iQBfrOwph3KAk4X2sejLkpMB7+OXxSFTfAyh4Y0l8lpUTgzv4hXLMLnCDU\n\
psJ6tQLOi6/Bers2obziJJZRaRdhdDNbQSCJ7eZSkq2sBDi8NUdhLjsBV3U6\n\
rLfqOGiL2xPQ5rHlhfvYz0l3/hAhRWKwPkMi0Abr85+H89wp4hZ2ON76Nmyp\n\
u/lJFrB7H7nzn4f55SdWsd1cRBj9JvzjYnYAvMXPkXb/BYksz4l9aji2fgv2\n\
7NQktmPKQdhefxz2w6/SM5Ds1NQmQRdqzINl/SPw982u0dtukoX/huXN7yFs\n\
4SbNWHCTHBK4kwUUKjNgTXkWYa0zmaPBiKgr7Uewbt9Irx9/f9B+lPSbA4eP\n\
SjA054NR5iKyIsOcMoSAl+BKqvxulxNzfSZknSSy7CIzrfciJ0uK0UUvQV6N\n\
hn43DAonDqdLISQYG0hV36s1wWYL4nypHDPyEKY6DMgp0bCJvVaNF1kE02mh\n\
H1VXlbhYaYGfzP8AEZ6L96wYqNajpsmMM6UKXK+3E5WIk0mRobyR+D49U2uD\n\
ETPSwOrk6gq7AS6ANXVlVpK7+DyA7CcQ001C9+ajcHb3Ek02w5rzU1iulROZ\n\
bSbS8QiRijFCeRO0W58mAiFlN6mwZNI5N2/Afmo9TKdzaKjoSSr3Q7v/RSIu\n\
Ediyvg/XzDyH7PuHSN3eh78jF7p9ryDicCM0fgP61DfgH66CPo2OkSUKjV6G\n\
kTh/cL4ZOiI4fpkKcacW5tQfwV5DfmTtAegObUTEZoevJR86Ii7xxA6sXhXs\n\
KU/BlraX2UB4dSFQLIDQSCuZIBLqEDGObU/BcSprTdnzf0Go8wxh+Rt/GNsl\n\
L8D6xn/Sc/v/ILYDVemEy29RG+TLHHsG1n0pJLo8MZ+ugPXFL8Ketpn6kZwD\n\
JxH6cAT+ilRiWE8jbHA+jO2k4l4Jk1sfDrOFPWNmFYIDVfCcSoH15S9Te0dY\n\
v+RhdK9n0f1yMgvhYXRb1S4UFCmQnydD74QHYz2E5Fw5ik/KUXJRR1Q7Tmwg\n\
iqprKuSf5M67XW+DZN6OY6lipGUqMMsgnZRzYbECObky1HY40NtiwMEDIhSe\n\
1UJvC+H+VRUK6Po8uv4OXc/US3FovSgtkuNEoYK95zxJ1WCVDn0zPnjsAfa7\n\
JpIe0aQNhQX0TKTo80hKtNboZ9ei9mtEpedgSid6fORX0O/7AdHYlxC2u4g8\n\
tMF44HvQ7/4+nD0D8NYdg273d8nzpHMztyPi9iNmmIbp4L/Tdc9Av+s70B15\n\
jTRXhEzhb+FZ5FDgbc6D7Q5xXr8J1pPP07n/Cd2Op+GovQBr7n9D8/LnYLl+\n\
lrzFWlguERIIdu7be6B7+/tEgn5KdmAftRkkpObAkPYc3f+nRNufgKO1Nqmm\n\
VmzLsG8hjViQysxBJlIBENQTUL8Nx2kWqAmchgevs7z1j8Ipu+uWDa7934Nt\n\
1yus0xisz2GvDyxIORBH/fBXHiM+/W3iMU9wzH7fetj3Pgvr5u/9Hpxq1yWS\n\
DsOjVXBmvEh6/THiPF9mr2fxLlaue4BgVwzwAZGX2dybF47U4dCdxTX4/DOW\n\
xIQjKwgyKdMBzp647CEYTEwRcL47/obNsraYgzDbePZNPXj3khI1nQ5uH1j6\n\
32oOwcp/H3GHUFoow4SE5w10ktkUhMUe4R+ROFYgCqOB6J2fu23vXR26xjn+\n\
EYvE2QxuFhzuCIzGEILhRC1l4o1cEytRctlDRG1MGtJOCdMXYelG3OsggseZ\n\
46hVg7BOxXjz6xK+10rIi6jNgoi4kzgCYdJLSpuJh/BF0ZhdaeMh/nVjYWKR\n\
ctKGXLmhyGI1dAefo9cMImZRwi+YWvXXLGqE9RoOBUw7kRCbeR5zGhGxmD6Q\n\
wF3AAMf278C6f9sqH2aMBZ1pUiPmIIcmaFgLzXWJ2k3hwfI/HpvME87XEbn9\n\
IlyXuK2fYqphIqdfof8v8vf4KKcDDXLi210ItN+B795Jzgvd/B8PYvOFbyEg\n\
UCcePybphu21RwmST8F1+jj8XbWIKJSMkXwg+1+jtWJikXEbp5YNdGxyUYdl\n\
jZt9zcSKCIXQA5UhnOgvfo4mDsG8i1mEkeSRI/VGDM56+c7hjsX9bnJR3TxM\n\
sDqRS4gPehGSLCEoESNO9JcZ55VIFHGfh5k+Sij4uMuM4LKAhsy+LlGbb4Wg\n\
FhILENZok7uJxt301HyaftzjZGaXEtGzmHaUWOse0kwryaLRcbcWvvFu9vLw\n\
ZAXMZw8x8pjYb5RJaPXkPUeuy7cRmJckujWun4Z98+Nwnj9Jz0isMeVhVHzi\n\
XVAh4cTo1EuECoY1xh5CRRr7NP6rKXT+4/BPiHgge4nW/RTWLb9C1ElyRPd1\n\
Zb9MjuFtXoQ/Sgg4xFlVPY+IO2Rl138RzrLTSWsdGStnPSxPdV3SeJLO9Zzd\n\
C99AbzKziSmOwUtechRdbRVYeJMM8LwyMYrcoH8cEekEjDufh277G2SBNsJA\n\
HMB0cBt8TPC56BC8C9xMSEQ8AsO252FK2wV9ygtw9U3R0OphOUbXHNnFfsd4\n\
AivEXSwHdxAPMiNuWoD+jf+CZ0aWDITS2zCCvIqnD7CBUUYBrR77KCKzNUQX\n\
vgTrnv+Gf7AL4dkuuDLWU6d8Fd72IbrGSm7ok0SLMletzd/Q2F2jPnoU/pG1\n\
Y/cYjSWBbaqNPOIf09j9B7wNlYhozExRITgID/bsY4jZGDb2OKw7GSc+EXX8\n\
OAI1GTCv/xJ8PSNsQUp3xs/IVX2SbHQFIkoRgt234Nj5b7Bs+gnpNe8aif4K\n\
LK88Tu7rDviqbiEi6iVP4lHYM7YgtDCDyNIQ3IUbYP6vf4a3pYMLIf41qVry\n\
JhPqkpEFnxs+sQQhu5uIrhMhs5PIqo/UNOfpxLzeNX874RGSl2y0JRZuRl10\n\
ic3OViBwdVVh+dgZkJRxcsJL0ycYO0OjRqNbco4aD7MhrcBABTS/+SEhQQ5H\n\
/h5456SsoDpyNhHTriGdTqZkrI34xh14my7AcJj6MBBCVDUDy+lThHUrzPve\n\
hFewRNdvh7GwjN1/+uv8EDOWNdR7FbZt/8rKm2XDN2B5/Wm4zp8m6WW8RiMc\n\
e39CvuXJ1SH+a4SHiJhu+vfklB03xCRug5PwZPyanzB7nJr6LtGYURI/M5z7\n\
fgLH2WKEhu7T8D8BV/m5D/CjG1cPw7793+AoKWQrosWkg3Ae/SVJI3GJjU+R\n\
An4ctreeha+jm1dVNLpV2bDt+AW890th2/QY6fLfEA0JI9RxHrYtT3M8hK63\n\
vPZtuMi/jQejTyY6OuqDgui+5BQ3lxn3WiFP3Qvh0QyI07KwlLIDyistMF48\n\
C9MQN7Okzs2DeVSMiEEG8Z69EB2j83buhq55jJSwA9L9uyApus7OafhGGjDz\n\
201wyqzrHhhjelPdHPRbXybIMxiNI2LUkAwsw5jyInyLEjgKaIznmeqGUVj2\n\
vQQ9NWstzoQlPw2WK1fhuHCUPK6XYSnOgqXoOEw5uQgbtYSbDeRx/Qq6nVuI\n\
ywYf4zVw3Komv78dwZEuRFSqpMpiVhU4LKTiPbz2+2uWLcRsJvodfVDjjolI\n\
z5tJkf+Chu1ZhORK6kvOeWKYCZOBsRLwImY1kbngNxv8CPtyzC1iTkcyPWcl\n\
4kdEMovQ9CC5VbMkSd6E7l3xe9igEytABgnCgvmkzmVfYrKPPoPUVxqmtaf4\n\
kQxJJ7H45hYI9qTDbycjrxdCsPktOJQORMzkQr+1Fw6hCabzJTAOcNMlqgxS\n\
JWPLMF8+CfHp+2zChF8wAeXVu+TnqSHNzIDPzsh+GJoTWZh/fTOUFd0Pj2RU\n\
PEis/k2EnfQ8UQdsuXtg2PMGDLu3I6AkGp63CdZb9WwQx1GwDaZTVxCxUj/e\n\
O0WjuheepivQ79mDkMFIHdIG7RuvIKTTwXp4K4wHt0KXsonUjPsH7O3+4iFa\n\
RAaw8L9IWH+IiDPID4UT/rsFJCLN637BD7OPeGtduwVaZ4xPHv0kTFeKIb/V\n\
DE1RAbQtU6R0AjBcLoXwcAYUp05BsOVtuMRMjxXDOCjgeiwzk7A/x/YG09OK\n\
0rOQnyyF7NxN+FUKyAtyEQwxAyeEcD+5s73dWD6QjXCA3/gkqeLi5iUYtr5E\n\
HcTPUDPgIeoamJ9l969xFu6E5sWfw3TmPEKiSRj3vAZzQToZthfhah0hIBpg\n\
IZfLlHEYJjKUlku3yHD5Yd67GT6RHJ5bhdSpBxA2e9Z9n4dWsKEA5v/+Ek8l\n\
yEEYvQdf/W3iqfySGY8Sthc/B+uRPQzkfs6LTsAbRmWVFkV3TcwkPcfZPkVE\n\
wwzR7rdhWzSRaDRhKfUUvUQIluZGOJeU8C5PYTmFULdEfXihANLzNawl4VAn\n\
hLmc+jr/KoIWsp3ttRC8lQq/Xk19mAPmgRwN1yDMvkYc3Q3J/v2wTKvWPdCJ\n\
f8nu/WTPJqTRsETIIMWDPvjbrhCCNiLMLN20EDc3qonJLrCSF7cRSxvqQUil\n\
XSV/ARd1SB+dI+Q1qgfm3RvhW1ZzNkEiRNTNrwx7ml1eJKmfwcCpAczWiRAh\n\
wRe3iFhvhlFVorolOG0BaPqX0E/nzFQLILg3DXGPCuLGZTjsnDlTdi+w388y\n\
31dOQTpigkehx8jZAQydH4NR5WGimJi+NgbZuBk+rRGj5wYwcHYI0mkzPWoE\n\
yzWLcLujbGEzYZMYQfK8VN2L1G4/BspGoFe6WXs8dXUM0iE1RK1kt8kpdArV\n\
GKb7DF8ch8XgpxGwY+zCIAZO92OmUcTk5yRWb8R0AgR7qsmjcq2u6Ij4EBqs\n\
QWhuit/N7QnW5Hf3mHHhjhYXKw2YU3DCGPKEUdtgwMUKHeqHnGwATzDvhFDD\n\
ZqpgaNQGtZ20vz+Cjj7SHa4QG/JkFJ5F40X3DMdg5qedWFCGWAA1NhtwqVKH\n\
ugEnIuSAzk87MK/k7hckQa9pYL6nrlzyweeh9kZcbF2k1g4jLt8zoHPYjtom\n\
E+aWPOihe1kdIXT0O9hwbJQ8v4xCKRYMiYIqn4Z/qgNLezMRZkbOpYFo70G4\n\
ZCYYLp3A8pFsKIuLsHQggw1Ima+exvyGzZCcPA1JZh4sk2JCoRzig4cgLSiB\n\
cNc+6Gp6YKq9hYXXN0F9pwKyY0eh7+EK+pivlUB6rp5BKwfyZLZg3KyAJfUN\n\
0rSvk1Z8E7pNxHq7JxOVAUgPwpK+m7iZmtdwT0PTOYP6A51QjSnRdaQOM10S\n\
dB3rglnPMN4g2vY0QD6tQPPRJghHdZA0TOLu69VQzenQvrceaqWPpNyGhgON\n\
EI/T9/XjuLuxBspxFToPNWC6gezKvRE05vTDuqRGY2ordCITutMaMdsqg25C\n\
itbjXbDorWjZWQedLkCmxI3WI10wLijRmtEO1aIZkpoxNBUMwbqgQGNaG/Ri\n\
A9qOksepMKHt7XrMtcqxeHsILfn9mC7vw8DtJVjonPaDNViasSccS8bDD5MS\n\
D0cjfI7Ft0hM4qi7r0bqWTVG5tzo6TVhf54c86ogGqs1KLptxKLYixNn5Oic\n\
96K2VofWSR/LC06XyTGiiCDg8OF4kRISjQe5ZVo2UCkaMyH7JleEoPKOGrWE\n\
o5ZmHc7eJ6Uo86LsmhpDIh/u31Wjaojb36eyQo2z98yYmrYjo1RBzq0DJ68a\n\
IJfYceSsBotSL+5VqnGwRA2h2Ims02qIVW5kFKvASIFqyY5tR5ZxvceV0MEM\n\
qfXrzODpAZEpejym1DMpRs/8DOzDEwjaOREKWywImo3wCBbhok/QxsWUYi4L\n\
HCOj8CS2LVscwfK+vbAvKeAnkhHlrUPMa4dfa07o4KRrGwsjLFsmp3qRpMeX\n\
qH3D+tA+LzNFksTjwqVOTHRxW6f6TXZYaXx7MrphMXJ47DrYBPWiHn25HRi4\n\
MAFhxzzhtwMOkxNdh5qgVTE7aXnQzVSAuzQJYfs8Gg53QTcqQWteL0Ks+o7C\n\
uEwcW6BAz4VxuFR61G6vxkTlHBbqFjB+fRwGpRmdB5rYWSpEPGyejsPkg2lR\n\
yyZXdWe2oPsS9Z5ASW2MkY73oTOjD9ohIVpPDLBbwDMz5AayfE61DfI+EcbK\n\
BtF4oAEKkTsxFWQ0d6NzJg29y3eZVROJCUujiTvct1yJYELT/i/EIg5MLZ9C\n\
1cCbKO94Dte7N6BhMp8oixkuxxh6ZtPQL6xOrmKORSwYFuSjfTYfCrsusQDV\n\
4ZhC28RBAuQu1E9kQOt2JCe3fTYfjp6QQ5KslPFNdJEyLW824+J1FeaNHOFd\n\
HiFF3mxBbb0eHdOcMJRdUmBMGUHQ6UPuaRVkOi9OXuKi9pIJMwoqOBTW3teg\n\
tseGsityArsRrb1W1DQZME5CVn1fiwZmJjAaxWlqb9HM8Vq1xg8xAb7kugF6\n\
rQeZZ5So6iSd0W5AXrkRZqMH+ec0kJEA5p0hc052+t5dDa5V6VF4UQtnBImt\n\
7bWnS0nnChPY5PRC0AVbfy+zFwyfAb3uizwiBVc6MVTNbVDrVhmhW9Kh+2gL\n\
VEzhKnq3TtJ8GoUbxmk5oU0MYcM0qne1wG5wEFobIBNxMqQbk0LUQd/XT6Hm\n\
7XZoxyVoOtbBVjBmlpgqxzVwLqtYNHnNZtSmVBN7EELWLULjzmoIZ7To3N9A\n\
92VCdH5CZA/sahPa99djuHwG0n4prEYfGwDtPj+OCPkPDCJ15JI0Hu9mKhIw\n\
2W6sZmY0csOhdix3iqGc0pBKjCcQuSDKR87dj6Oo8VW4w7EEIueFuezh4qbX\n\
4U6kM/0VjboHnSMbUFD1Rfp8HvlVj6Cw5qvIufePKG3+FWoJqSfufwYlzW8x\n\
K1c5JRMU4Xz9o8i8+wiG5ZPrEn5/POZATdczyK36AvLv/xMy7j2KOYM6gUyr\n\
2om0c1q2tHUCmfHoChssPH9FQU1xbtb8kBHnCZl1dTpUDnJqteyCHKOkpuNe\n\
P3JOETKZQCL9ZkZGMW1BLq+m66s0qOu343K5ktS0CSPTLpy/qMDNPjtqqrWo\n\
6HexOvQ0tTeh4nSeUOSGYMmJ4msGpl4mxsfsGJx0orpei8wrBtIgq8gsKNPA\n\
aA2ggNCrsoTpuZUYkgQTyIz5/GwGM5ITYUkU2uYkqNtdi8mKaTTvrcF8nxy9\n\
aQ1oONaNyWtDqNrVCoc1iLkzneglnbZwdwS1R7rhsXvQvqcG1XubsdytxNTp\n\
TvRdnMR8xTBqj/bQ9z4MFzShs3QYY2e60Zjdg8mLA6jaWQ/ZjBHT57vRdXoU\n\
MzcIMandcFocaNlRhZoDbVhqX0RrGqFQYyE724jxu3MYzO3EyI05zF2nNnY1\n\
QjqmQHtqD5wmFwayG9F9dhQjxR1oKxkhSZhEU1o3Fmqm0fR2K+yOcAKFS5Ii\n\
nKj6HE63bIJnFYWL4kKC0+dwpnULPKsoNOnvo6TmSzhZ+1Vc7tmEBU0P5IZB\n\
jJLuO9vwGCHyayiq/QrOte1h1vHwKJTgStOTyKt6HGOK6SQK/Z4ZnGv4Jl3z\n\
Tdwfz8WCqhnOoC+BQpvWiaOn1PAk63s8RtYtDj/BcnTAiIwy4jjdZhwrlpNx\n\
96OJULCH9OntOgMO50lQcFWLK2TkMy/qYTb7sO+4GKeJDJ+9rMS+fDlu1BuQ\n\
WijHsDCA+UkLsi+q0dBlQeYpBaYUAdQRIdmRI8O9DhuaW/XIvKBCLennNPp+\n\
ZI7IAiHO5w7j7Dk5qkjH3qhQobjaSvZzFYWFFzTo7TMi5xpXJmGoTYfiKgs7\n\
pfxJ9p0+ygapgpJxBOTLfIWEGGIeG7fxB5H7oGQSYaOOjjmYQBJfU+dL7K+n\n\
YBWoMV81Rx6LlgDtJ2vciSXSfYLaBWi48u8IOd0Qty5CUL8Ek9LNypVhVgft\n\
hALKST3RdM9D35O2dXkgahJgoYG8JIMbsupx1OxthFbmJs84CFmHEIuNQtiN\n\
TPgjBv2MDppxBRSk8+SDSjZ/xaM0YbFuHssdchrsIMR3R1Gzvxk6sQXKATon\n\
wuy16cZy4wIWyBtz2Yh5REg/94owX7NA7NWZyFB9Pyj9IATCAjr7CyhueAYy\n\
py0x96NUXkFp7aME3ncFaKJxj6MXp+u/gRN1/0rG0fRBvsejgTAKiqSoJ9vJ\n\
urHRGCpuqXCnz8lqwHlyqBp7rJgSc1ltWrWfdLoHXUM2zEh8WBa60Ux4UVgi\n\
hOcoOT5eTMw50TnqhIo4ee+gDf0zHjY9mmlvadGFll4b5uVce2riXQKRBwNT\n\
LvLM45iecZAcWLGkDiHkD2Nkhnsuo54sV78NHSMOWL1xspJkr89yuMwnAr5A\n\
BFdq4PPayNGbEvqYWcJPsK/5MUINXVb2ArS5r5FH/wxM188iZpfDkP8iEVs9\n\
bGXPQ5f9MvSZP4Xq0C8QsgYT9Z4+yDfh1jixRG9jmDOQLfXDOGekp6IxDoUw\n\
eV8OmykAUbsCnReWMHRfxUj2uk/w0s+k6HRn9cBmCSdjVSGzFQvt4gfWozPn\n\
DZQMwe1KuIgfQtBgxkKXDLFogL4bhscdTRLk9wekKUEqCujwuY6dzA5pyUnE\n\
uBd1PT/DieovvTcg9SWBJDBpP8TrP9myA8cLZTh1S4tTpJTSiTxpnbFEPUiH\n\
xUeOs5nhdMk3s9IYnryshYx4WeFFDYif8PUjP4awsAGaw79FJLiCFY8EuvRf\n\
wzvRB0PBi3B13YQu7XdsvfWYdhjao78g7yPw8IAZiKA0nZZDcF+AURq4pcpF\n\
CMkvF9ULUV0sJsFWoSp/EQa5C6PlAkz021YHjEDnMbuJDMWZnFskCtV4mMWL\n\
sdUKGWuP/XGDMjK3m1jL53CpP53h39zhP8fo3H4iRv/yHkzPO0YksUud20li\n\
MOfC9LIX3tBKovoZU1PM6oiwWnu1aDNgd0WIxsZhI8obXzMSoYW70Bcc5x6B\n\
vjGf2AhnZzUMhRvgbLsEY2k+91XEBmPJmwgavQ+PhJEoaNsFBZZqljA+bIeY\n\
6Gll+hQqj03DZI1CeH8RFRlzGK+SY+DaMsZbTauPRmbAMzYAa309m2jKpEL+\n\
7I/q6dG5PXxPp63t6SlBOnv2H9HTyfrt1H+eMDOztMLnv3wMUU0fNAf+A361\n\
ARFVD7QHnoVvapDVOJ6xFmgP/QQ+hRLBqZtQ73+G1ME7AJzotsXqJYyRvpU0\n\
iHA/bQJ3j83DRw6pvE2Mu5kCqJdsGLwwi/qLiWSOD7OegbEwFeJtO6G/dA7S\n\
Ta/DUNH1nntuK7yRlf+x59L+2J5LLolOBJqwWnmByS/hD6/6WUj+rOZTrVmj\n\
nDiPqVWeOJbMa1lzj2R7YTNODr2NOacnOWKMe+9tL4Au9Wf0eRb2tjqyEVLo\n\
Mv6b1IsPnrY8GsX/gD57PdSpv/l9KicxYpJWMWannBBVL0O8SHajQYymS1K4\n\
iE11Fs6hg2xEbe4sFHI//5h/zgZcXf1d8CwIETaZ4emthWTPQYT9ccTcDibg\n\
uJqYFPTCtzgHz7yACccls/AjIUTsTvCWHFE7u8SEffWYy76amxINI+p0PZBi\n\
wYSloz4fqxaShRKZREVu+UqyUMG7IYccuVPNL8AWiv7fQw6Hki+ymndkzIoT\n\
11QoqdSjY9SGViILUXKlmjvNWNRH2Pju/UY98umcvHI1mibd/FqxFSzM2VF8\n\
Q42862rc6bGTl7nCLv1p6TbR+WqcrTFiYtmN8modupZ85I75cP6uBrlXVThx\n\
W4dJOTcrzOQQtfWakEf3OEG2r2eeXXf2Ab7TVsImFAxsR7deAAmTThbiEmUD\n\
YRcC0XACy96ACQLzDBRu3bpEhD8SIQBZ5qD1muAKuZi1XPTSASgcQujomIeO\n\
heLcNIfVq4TYLiZ1l6hoFoWGzluyLpPbHeZl6y+IXzAhdS7HJ24VQJv6UyIY\n\
fM4Pk8nk05BifwUBg+dBbH+UM6enZLDKSc+bQli6u4jFOc5Pdlv8TKidnUI3\n\
Sp3EUSIcL/gUfMNNkG3eCNnO7ZDt2ArxnqMIuaMw5u+FvnaEexKHHprUXZC8\n\
tR3yvdsgffs4AiYurcvbWwHhy1sRIDodkY5D/OJ62Oe4XG191m5Y+VBdVDkN\n\
eVomwp540idjM5umL0Nx8keQnfwJlOffhN9g+yyPrIhmGIrCH8DQfJ6BfaIm\n\
0rsgvLDqS+TgPY5h+cT/fYTPTVnw+nERrnVY0dJjwpZMIQ7fMSHoj+Bojhht\n\
cz40Nmqw+aQcXbMudA2asT1HggFZEEpiY1szxbhK1/aNWrEvV0RK3Q4BtbmZ\n\
zqkdZmi2Cbvp+JYTCkwTfc4plSD1uh4jC25U1GuQUqxk6sKRu6jFlgIZGsec\n\
qGs34I1MEdoX+agVKc+wFQV9z2Nb12vIHd6NXb17ofS70bWQjwbNOPvmZucE\n\
DnS/hryRNBzqeQWVilHyqUwoHdqIwwP7cLw/Bdt6dkJKXmGtIAc7urYgc3AH\n\
Ujo2Y8ZOfpfmLt7ufp2Obce+gTTofA60LxdhX28K8oZ3Ye/gUSh9rtW1A34j\n\
nK1XEfFEVs1F1AVnx20mz/BBaH8YDjk5OK1GqIZUEBFb0gyroZL7uCjJp9kU\n\
U8Vbr8JQO0jqMATb1ZMQbt5LUCMYZ+2C7t4g+5auhosQp+wnDzVAGtoJzZEt\n\
0FxuZL8znTyIxV//ErZpOTydN7D4s59Ce4n7Tp++HZYxLo0nqpiC7PAxhN3x\n\
1RxpO9SlT8HYeZtYggKGq89Cfn4Hu+1zsk7tGlv4cR5WcZ8FrtEyiI/8E1xK\n\
fQLeItkpQuY/4zSxo2BiYddHeXh/GUW1XyUl/nPMaacQjrLb9bDN/v+A86B7\n\
NInzZYstGfOLx3GxXIbsasu6xBqfhjoN0gjrIcJ6xgkJ2me8xGVtmNMEWQJr\n\
UHtwIEeEmnEnblercPSWkSkVxlosuciF5hEnBroNSClUQOPidGRfux4HLuoQ\n\
CBKmyQXVu5g9TWKYmrbg1VwpxshlzCwkSjXq4qYryHIOkYXpXfIlsM7Qhry+\n\
N9CmF7NR0lsTu3FZ2omO+ROoV3PLUyun96OIODPThNrUjsN9e9Emuoy9A8fh\n\
JSPjcE1ib/cWLFjEyBtIwYjNgkBAgv10bEQ3Tcc2oUW7RKo+hJtTx1AluoUj\n\
3W9i0m5FKOJGzcI5DJjF6/6aw/Df8uMX0y9CujUFfi2fDquZh2z/IYSI1huz\n\
d0NXPcwet55Ph/psDdfR/wuuurOQZ55FnAyQcs/bUOdlQ3u+hph8GlSFuVCk\n\
Z7E1kfXHd8LCpwkyqlZ2lMUo1zFfQsS0BHPNNuhuvQFj9W5ITvycqXSLuEcD\n\
Y8WrUJ75OTQ3diFgcRE+jLC0nEbEx7nrAXEDbENN7N8hdRe0l39L5/8a+sZ8\n\
uvUKm/pnbsgjq+Hnz+kn0fk1VGXrYR24A9PdzbAM3IO9Kx1ejRFhTTvMHeeS\n\
OxVrCz8DVUUOH2P+WwQ8QvTMHkdl329wsuarKG34MZqn09A1fw4+GvMlyUlW\n\
0Zc2fBvFJA2FtU/gOimt2rEShOn7sbm33ykJf/U/SsK4YoYwFcTU0gk0jW5G\n\
ad03cLLuW6gc3scGWvRu5yplJSJSWiZFxag7KRJT/SYc59U/IxJt8342Fauq\n\
SY+DJVJsy5MgvVwHnT2M6/eU2HRChhPXVSgopw/9Pldrgt4SwKlyJfaVypB/\n\
ncjMRTkOXdSzIXGdxoOyCg12F0jw1gkpLjRbYSeje7xAjINlCmpLzbVFROdG\n\
v5N71E+wBOfk8NsQerm0bYH8IvJmK+nx8kkkOPV/eXw/mrSz7N/xkI4gvgMX\n\
xo6TmHAroQgmKJ04jmnjAgoGd2PBzZCkCMomstCn6kPu4B4sewJJu66x9mJL\n\
y29QMJ6HM5N5ODlyFI2a2YckIm6TQrplE9xidksfYg9jkO45wLIPAzEHzY12\n\
9rj9Rh4UuZcTEuG4V0r/XoB/vheSfWlwjw5DtuVViDbvgXd5Dordu+BRGmHI\n\
2JkkMOHlIeLqh8ki8DOaj5AAuqE9/SSkRc/D1nca8vR/gDCXpMIfgP78v0NS\n\
+Fu4pu5Bd/EHEJ/YQJp9DpKMHyNo5SbGnN1HoLiUhqhHAfmxf4DmbiadXwnZ\n\
8U9DXXMeMQ+5FocfgcfIVGUNQ1v0COQXdsM1cRfqU09icddn4FwYhSr3kzBN\n\
LMA/lQth1k/YtaJxxywkBz6I5aPfRsiXKMb+t7Abm3Ci8lME1y+huO4xFv05\n\
lZ9GbtV3YQ6HyUbkI/vOP+ACmfjp5RKU1n4Fufc+zcZ8AiQZIzPbkVnx/+Jc\n\
z8G1kjE+dxDZdLikOWVNMEeMsrqvssGcEfkM80wor/8SMis/R7f+Jn2+QUL2\n\
WRyrfASzBvWqZDDG4rocJ+qtSclob9Y9YCy6F33o7NDjjRwZWidcUBiCkGsC\n\
7PziTZKMPRe0EKr8kGr8aCCi89ZJBVNbDLMCF8TqAL2aB+UVKhw4r0MkHEXJ\n\
eQkOXtFihKiB1hSAyhhE0BvGsRMinG21Qqb2Q6by4uRFGTKqLavEyIzs3tfQ\n\
qF1mZwgqp/bj3HIzEaMsZE1dIgc7hJqZVJyYq2CNhdk+iMO929EkuoqDZCyc\n\
5JHZXVPY35OCWdKv+YO7MO9itHsUlyezMaSbJNdiE2o1XE2FVuEltMiqcajr\n\
dXTphbD7tCjsewU35YMPGotPs76mPudtSA9nwTk2BM3RFCxt3E0anWE0O7H8\n\
wgaYmCVdIy0Qb3gBlo5ReKf6IHntOZiaR2G/lg959lUSZhvkb/wGot3ppKqj\n\
rJXQV/XAcHw7hK+mwDE4CtOpdO77EBKyETUMQXz0a/Aa+d1yp0ogziVPRL8E\n\
aeonYZnsIbamQ4hk39x6jo5PQJb3SwTtnHfj6jsO9c08+ObPQ3j4G/Bp5OTP\n\
quGduwPrcAWiDrKFxx6D12Rn9Yi25MtQlKcTMdPDN3cd4vRnSFTd0BT8M8xT\n\
iwjMFEJc8Es2rdTddxiS3Mchy/pHmMcnkrIRJiskVNejfTyFrAZZh6ZfY0pe\n\
jyVNL3lhjFlfwKzsNpYNU+wz6oydaJ84iuapyyQLK7DYxzAju4Nl/STD3BKy\n\
YbVPYVZ+B4vakWQZkzipDrGmAfPKRlh9DnYuR6FrxBgx41LiT4V1T6F1/iIW\n\
VA2wB3z8I34RC0Tu38wQ496gA8PjVuwicp9eaWblIi1XjA6BjyVFW4qUEOmC\n\
GBoxY0uelJzEGFRCO1JyJagi4rQocSO1RIKCOivcrgD20rXlfQ5oyFG8dEOB\n\
A5f1iJIeOXNRipz7RmiMAdy+r8K+MqYM2gpamrTYWqTAEMnLGBGoFHIYmuZ8\n\
q3JhQenga9jdtxtFo4exp3srRF4nBpeKsbltPY6NFkBknUEmEa388Uwc6dmI\n\
a8JWEl8nTg9vx9GBA8jq34I3O7diwbxE1mffGrnIxYRVB4GmCns630Th6CHs\n\
pvaXXWb0SS9if98uuuchHBk4ArXfm5ALLqXnk2y9D+OpbMgP7IfhWjmMlbWI\n\
BmNw1NyG8UY5FAcOwqswwDvYBMXbKeTQbofhXhsbfLXevADr4BIYp9N64yJM\n\
dV3saHoG60mWOmCrpjZuXocq/SARswNwjC5xPfIVckQ7CZPfQ9DJMaIIsSBZ\n\
8XoEVLOQpv1vSLK+CFnul0kGPg9x6rfgFvVAlvMD+PkcfFfvMZKHXHhny7C8\n\
+6N03qPc+WQrpKdeQ8gogPT4E/BauXBYSDMIzYX/gjTnK5Bm/guER36IsNPx\n\
gDxICn5F7nwI2uKvQt/VCEfrNsjKdjCaKrEObtWT2Mrkx3yKPxxwjayh+Zbk\n\
hA1p7n7iMAdL5Th+Wc3ykIy7JoSJglfW6jGjDiPoCeNmlQYHTsmx/7QC9RNu\n\
fu/uFcxM25B+lo7Td2WNZpIMrgD77IwNx8vk7DUZ1zSsi8D8aFVMdEGJ/XS/\n\
oxfVmOUL80SJ/je26dnnOHhOgRpCfCgRDfkndubE4bfA5tNgSj8Cg5/rM3eA\n\
6JDfTMhcRJCp+h0wYEzbgyWbIlksIRp1Y9E0CZVTjJPj6ZizW2Dx6lnbyPzY\n\
fEbS+twY6x1LGNYOQO/jk3SZJU4OAXGgaWbGht8XOLGsZe0cZiIdZ63Tx3Tu\n\
SjyeLJbPlaRfe/5XsOKVEZo+A/NYL7tGwtH2FjGCHyPsMEKR9U/Qd9awS2p8\n\
MyWkVUl7yicgTf8UTCNdbNEac8V6KK8TD1d3QnTgs3BJpWzKquXe85CUMOuG\n\
xaTV/x7G3np2Isg7cxUmcnWZMLBvugyiw/+BkMP+IMpOEsrlfRAd+md4zB5E\n\
lDUQHfkKg+xEHYMlSTEb/ixp/BkUTgu7sOLveKgxiUpji6fRNVcKlUO/NtZZ\n\
Wvco8mu/jYXEZPOf0pXcxPJEjxHp5DBGSeFOz5OfbludJWA2141wk8hJzsFM\n\
SEfj7zwWZqYMH5poZhZGxtZMq8boHH70k8WZsOLG+ekCLLjcidWJf7em2cQ4\n\
J3MP14w91ymPwNW1j/rss5CXPAtx2icgPvk7ZlKX+vkcjcE/Q3HqF/T749C1\n\
lBO5lkOW8RmIjn0ViuIfY3nf38E80Asm0G25T8Q29atQnn6G+v0ROBYWCSci\n\
sp6fpjH+BGSXDsIze4eY5mehLPstZNlfg/xiCo1vAOr8f0qOo7TotzDX74Wk\n\
6GW2DAKidiizPw9DT9e6RIRQr61AUfXncbL2azjf9mtUDafCHgr+b37QwgER\n\
ztcl03sSY+lzjeFa+7Moa/8vCK2Gj/DdMNlnJlpqJm8oigKm+sq8f91jyRGK\n\
IxD2kT1Nrv7kxOlTbLEWW18PFrPOYCHrNJaKrsMqZDeQgF+0AOGJi7DJTXBN\n\
jmIx5wyWT92GoaMf4lM34dEZoLt9D9LKDiIzQegr70OQcxZLxTfhVHCrKpxj\n\
I1iiYwJqX15JLCaaSFH8PILKUTinmhGyGhCy6JLiG9LNwjFyhwzLMncg5kdA\n\
I0XYKodrvAIe8ewaUY/Tc3aR8biPgIlLPmIW2rDnm5bhFvDrBA0COEduwTU/\n\
QM8aZWO86vzP8uN1AuL8X8CvljFJm8kSDwYR/Wviu50bsljEiraRjSiq+Rpy\n\
iY3nVX+XFJY3OWTk3l5r+T6N6HcxoZxNRidW4uzuSCH6xFdWEkMWIUXvYlYS\n\
MisHiW6T+Kx7kheMSNhA//tYvRUKmkhk+BW1MR85of2w2CbBrZiMIRgycLNS\n\
K1H+b7CViW22AbgI6wG6nr5PJJMmht7Z34KRl/ZDfr8HlrFpKC9fxdimDLjN\n\
XuhvXcBU+jX49ErM7UyD9F4vLAMDmN68DzPpt+FTLmPyraPQkX033K/A5O5i\n\
IqnzUF+6iskD5+E3aDCTkgpF7RAcc/OY3XEYqkFpUqvEvBbEgqxjx8dVP8yW\n\
PFPl/gs7JP6pYojyfs2Izl/wvcWsLtSYhrGoriWO2Y1ANLYu0e/M1JDVKYfR\n\
Loc/HOSCeowKiWB24huYXL5EAipBf/enoLQweTgeCGaeRf/ocxgffQoT85nE\n\
CZUYHfkxmaQgVoIyjIw8S01q6LyfYGDkNxgd/Ve09z4Bhy/wUD/qiduIbg0h\n\
+UOe2wz1jXnZAP3NSxDXM+6IBwt7j0N4rRVejYn66SKWL/QjZpZhJvUMy0hF\n\
RzOxeKUdHpkKLoEAqvsd8JuscEwL4JYqoatrwsQb+6DslyT70XbzFZh6etn/\n\
/pHvqIBqBmFvkBBOxlW2wAa19vI9EgksUC/8FQYmtsNquYfW1g+Sd3edlEo7\n\
egd+wM7TxCMqDA99HzpdL0aHfwirl5m9lWJk+FnIlVcwMPQss/sRIr4x9A/8\n\
K2we30M9Eg9H2L0OvVIZdA3NEKTmYGTjcTJoXrZHRFXTbEe5F2YgvXgTgswS\n\
TLx5AMLL1CMWBfXIaQTdAbZHJveR8T1bjuUTZzH+ehrsSj3Ul69gYstRLORd\n\
hqZzksRutVCs9fqLMNReQ0AySm6Sih+RMLlP5tXl5EEn/Et98IomEI8mwiP/\n\
gJB2Dl7hKBluE7vekvmJmMXwiycQcdoQ9dj46x0IiIcR0MqSiijm1sO72IOA\n\
WpI8FvdZ6dphoptKur9lPz8Idv0ZjE7txcz8axgf/yUEy6mYmnwFRkslRsbf\n\
ToZx56bWQ6aoIlg+Q0yLWRUpJ1j+FFL5WYxNHeXv4cTExHOwetwPDULEosXi\n\
kQyMvX4I0wcKIL5WB5fKyq6eU54uwdLVHlYTakjs5Y0TCNkdkJeWYLGsizpv\n\
FlP7TsCtcUF3/RKmj1+F3+qAracFY2+dhE+nw8y2fVB0ziFk0kFUcgVOXSL5\n\
+Yuw33wJ4rf+DppT6yE/9HXYxidYK6o+vQmkA7Hi10J/8odQ5jxHWvjfoLl4\n\
hJ3F9o2cgmzvY9D8H7reAzyu67oW1pc4+d+f5CV/3vvykjjJcxzXdNvPVZJl\n\
W26yZUm2CtVYJFGiRImkRIqdFHsnQRAAid57J9F7HwwGgwEwwAADTO+99wqs\n\
f997ZwaU/MLvA2fmzrl37j1nnbXXPmeffXLovKNfhqkuHzHTNDQnvgDtzeeh\n\
+eRb1HU+QpJ0o5E9/zmoT3yTXPB6YngxdJe+S+e+Ds3J/4Slo4YaRQfD1Seo\n\
3PPQXnsUyiOPI+zwPc7e5tcQW+yF68YBOK/ug6e2DMlwahHiSAWcNz6CK/sE\n\
ohozNv0G+OurkbBr4K8jAUFAipJb7brJlDmJ8LqGJWrmPBed5y64Qe432Vud\n\
EO47ZxEWTCLQ1c0tre0v5q595zThzYENlxL++x3cALvXgEBbDWOTH+FCWf+a\n\
NXDShWewpu+HRroTnX1/BYdbjXnRb6HS1mJy8t9hps8Bbx/Gx78Nk1mA6fF/\n\
gERRiZBvkQWMwdRLngZ951qD01yMobFvwhUIf9YgOIc7MLvvBnzmVCK4qA+m\n\
gUlqvVnMvXUIM7vPwEqkFlgmz/3QJSycuIb5o1mwr2nJO8vD9MsfQnKvHVGv\n\
C4qsHIiojOjgFRjGV9nL2R60Y/7jy/R3EZKsVsRC8QxinJWvwNhQxFZDYOIa\n\
NFm7kHASYnLfYXVcSHAHqovPMfGD2AwboTv9H/CszMJw8RtwTHPk62x4C4bK\n\
m/DzsqHLOcB2Q2/XR9DmvwPfFDOI+SITDY+4qhuGog9hr3kP+oKzZBpiiCqH\n\
YG7Kg6f/PJV7hS2XME8RCr+HoN2TDsXwh6KwBmIPJQ34C1bl6mxe8OU2SEw+\n\
dtolFIpgxeiFm3zlUCQGWzC2FZ1B5d3Ez54Ma/0Ru5nKqs6JyXUrXcOPSHLz\n\
U5O2VkKT0h5gpl/Zc33RZPrUBJHtMvVr5tQV8++fqqdbm1q3YHjVgjV7cGsu\n\
/utIrPbC+s7j8LY1ITI3Btcn2+C4nYe4bAzWPc+RFRYi9CALthMfIqaahW3f\n\
DkQVfHrdiaiMB9uHLyIsXkR4qByOm2cQXeqH9f2XEBLy4M3ZDWdFNSIDebBn\n\
XUJUMgz7uYuISfpgffd5hMQiBJuvwH7mKGLrJGhOneGiNMxLcBzZxeyjkekC\n\
xHHixTfh8Drht9eBP/cGm5tHKyMGMo/AariNKd4T9Pd9SIkvEzEblhe3Y0bw\n\
GHHsBTJcvya4B2HWXaJu8B3wZ57ByOSTcPmDn+4C/wu+uQnMvncRzjUDaT8H\n\
DOVlmN5zFSF/nEgqB6t101tp/0m/RJxuNsCC7S3qJcwdvoGAM50WnVjC7SH/\n\
OpZ2iOI+LyIOz0NO0p/AWf067HxuXiBp5EFz/TVE9SSlcvcQLKg3jF+Dvugi\n\
16R/DlvxL2Htq4f+4q8QtHIdNTRXAlPVVfgmsmAoucQei623wlCxj5zaazCU\n\
Xc/kJCEdaS95FqpTP4GxeC+MRW/R6wnyWQ8T02enbjwA41Xm8i7OVfk+696c\n\
bxZiR/U8ZL50hoJNTC4osb10Gu/UzOHdagGOd0hwqlWEVyuEGNYG0CtYxfv3\n\
11m9wJ5BzXqtQYBcPudi+HwB3HiwgNdLZ3CgQUTX4uNE9zrMIe4Eg86K98qn\n\
8VrlHEbVHlxtnEXZAifzXR4fLrfPY3v51rmnemSwsT+2iUGRAtuLp/FevQgH\n\
6oXsbxTNmtiwkXT7+O7shauyPj1wvumQwXmW2KLxGoG3hCsV99CxVxEUDMJ+\n\
+B0ywgLYj7yHYP89WD94Dt6GfPjq7sJTXwZ/81U4S0u5Rw07qdOoEOm7A/f9\n\
NiQtIjgu30Co6xbJthru2iELXfs1NibEcfEy1wGsK3CeeifTAZh7y2z5tJkC\n\
XzLhRzwRyYRKMQuMA8uYnPgB7D5uvnODNPFmwoKZ2d/SMe+nkf7/YjMehqGu\n\
HnPvn4XoowsQEXItAi7hR0gpg1fjyASgMZlgnAtSJGPpbU+JsCtehr6MzcTI\n\
Erb62g7EnQpoTv8AXukqgsIiqM49SyTPrLW2QHfm3+BamIaJzLBtdJBNyOys\n\
fxNGImwWt0VcRGVc3ku4PQjfdCHU559FPLKBJEkAc+0VOBoPkGHYi5jLgYCA\n\
rn/md4Tv61CTjIiHYogbxqE++n2E7J40cBVqM3aW8PBK0TQqF7h5r2QsjGPV\n\
Mzjas8aSuc3tR/HgMn5XMI1CgZlNI32fJ8He9k8D93o9A1wDW9v1w8vYVkYg\n\
V1OPjiWwIDNiZ/EULk8a2CZidvvaWS7ApM6HSDiK87UzKGO2hKf6KulbxCvl\n\
c9x3dK6IyGZ70SRu8M0IBnx4m65zaVgFJ8mReDSOnuk1vFY+i+XMfgsxeG68\n\
A//YYmYePh5HdCwf9pvXuBJhCxynXkRwdmgLtIffRWi6FpZ3X0BwopuAmA/r\n\
h8/A13yD2PsqBxqnEqHZRUSH78FN5jppmSfQXkd4MBeOOyl68GnhOP0ydYh+\n\
9tqsu2kW0XuWsDI73m8m7FCrShGMxrZiTjZ80GhqEIhE04BMDwLF/WS7nB5G\n\
B6YiNkhHNr4F5fFvw3B3J1TH/xVO/jhpRx10F74F5bFvkqJogq18GzTkKuqu\n\
P0lW/xC1bpKMUi1UJ7/NakHV4S+QjsyGj59PYOOqJ67oIZAdQSLshuXuU8S5\n\
v4X27PdhrL1LIJbCeO1x6LJfh/bCD2Htb8UGlTPn/oqA9lvorj0BxaFvkR5O\n\
rQz92xQgxNjTvIzs3kV80C4FQ2BJ6mNHq4nR+uTwpJLrMZGK71bMoGqBGyBp\n\
/y+AljdjoqqI4KNKPi5PaDPpglbUVgwp3SzI5sVqvF0lgpWxhqSSzhHIyhdt\n\
JJJC2EeseXsmtVTxz7GssmCECDQYCqNv2Qwbc3+ERZc/jPZJKbYROfLN6cSb\n\
ccLXW/D1T6eJkcv9TXdEatV57Bm4im7Bff0t2K9fQVxPbX9oN4exg28h7jLB\n\
dWEH3IXX4b65l8VNwqaA4/DP4Sq4AufJ5+DIv0lltrHZFEJTD+A4f4k8PxmV\n\
eRru0iy4ruyAI/s2STUBLK9+B05SF87zr8F+iU0Iww1sPfIt9uW/k8x3IOGz\n\
k083QT4Zt9MCs0Iv5rQhZpEjYraw6/aDy8PkowkfSkL4P8htkCG4vgj/5B0Y\n\
y5k0Nn7E3NzKGiZHRMzBrbXcjAUQXBoi/3AxE0ixQX5gcJl+U69NqzHmlKCU\n\
j4hRCtP1XzA2NDV49HlECOH7KvjII46RqU14vWQG0+xG2GRIRUrsIkO6p34e\n\
V/vXkD+2jt1lDEzsn4JJ5LMwEZgQCfqxt2oG7zfSub0rf4DLPStUK1mDayjm\n\
6dml9gssUuZgIjZlNHQaKUGfB3sIYfuaF3Cld+UR7tw/wS06t2Sa3T2JHdp7\n\
IFTjUocYu8qmsa2Ej4tDSvjim+n0ueGOK7AefIf6Dmd7YvNtsO7fhnh4Ext2\n\
JYI9lQgOPiC/LU72TUTC8U2Cywzs+3cwdg4bbiNCTDb8kT4uBxG4tB6BzgoE\n\
x/qRdFrIVO+G7cpxxDTUuaa4LPtJyzqCXXTt4U7qo2RoQk5EF+cQEfQi0NNM\n\
HoQvtZSEWsY2i1jfu4h27UZ8tpYZwX9olHlrj/DUHj0/TX0VnifGrL/FSrb0\n\
8kJsBmHJe51xiVON+23Mr2jxSvEMJk3MaEkIh6r4uDHFrfLeIFpc1ToxtGJC\n\
44wK1zvFVJafadz70yt4o17CrIX7PQ5IEId8WDmDIx0r6F02oVNsoFcjzrbM\n\
4vVaCYJ0Y4v/Resye2V8QIA7SYauV7J17ummWeyqJxtNxqWwcwEv0r2cpOu3\n\
i01YIg8mltzMhM1HPPBm74X10Cvktu6H9cAz8A9OpOcikpZFOM4cQExL4ub0\n\
B4SVjcyuXfGVMQTFK9hwLJO3m8uOQ2Wyu/7edlqM1ogi3v8OYhN3kNRNIVr7\n\
BOKro9yo//+HDb8TmuJyrGUVQF5MDovPB1vfONziNehKKqG8WwnFnSLIS1sR\n\
JVZz9Hdi7eY9yPJq4DO4uXZKyZ9P38C/p1FAFMqkL8bDTc0QXzjIzDmkKPib\n\
bCR5focIbzZI4E6pyabRZeysFcMV38CUWIFTXTKkUgsjEfLjfaL8snmOSh7w\n\
V/FC0QxapC5uaiWtLWaM7FDx3Qci7GmSwBbhLpAIh3CWRPOhPiV728vLGra5\n\
7WzvjLPNzWgLZhfnm61CvN+2mrmveCiI03UCHBtUI0J+7umqaZwe0WQMMm9F\n\
h5tDcngT6edjKiqJ2NocwoJxxM229PIZJvkAk1dpk311ZWbWiFjZTItIx8R/\n\
ARvGEcTuk7PY/jriC61sbScl5UjqpWyNbtrFiI8cQWz4BGItz5F0Ic0c8yI+\n\
dojO2Yk42erY2HFyUPuQEOaTauBYMjF3D0mrHMmFQuIHNbs8LDFxnM7ZTuWz\n\
qeOlpcZfwj3SjpW8JgQNRjbNjaJ1EPLrBbALJFg/cQJzh7JhnyAO4ovhnhnF\n\
Iglgj0wFa3sL1vJb2EkrrkZSOvgv6TZUcLQfQ9TlZ4ewHPePImLn+nBEfh9u\n\
wTBRzgKcw1eQpD7v512FoeAZmFv2w9FzDmG7LbUulFsolQz6mAkuIlDm2Hdh\n\
sziwvXAKN6f0GXzKlEa8VDCFFrkXSrURrxZM4ninFDUzalwmz+kl4pweFTcl\n\
20ZG4kUSujvIcJzuWsWqPYSrBI7bPI6HtEYb3iFdsLdRjKIpBU40zuGVUgF4\n\
piCpMjvONotY0XpxUEY84Mc50i5FIgt7rlxjxltkoPa3LLPnHmsQ4tWyWUyb\n\
uK2/KwbE2E6gLOGpUDK2hl0kYs8MqRlHnXu8f6QqUyNa8Q3EeLVIKrsQKfsu\n\
EsTm8aG3ESfTyuzkEOv8NTE0KbPVFkRLvkpCtAIbqnqES58mUphGfHQvwoXf\n\
QFI1SwTxK0IDM0y7waIosT6KWPuLSMgEhBpqmtrXkVQMIVr3PUSn6tPAiLsd\n\
cExOQXWvFEtHzsE0JYLiViFc66QibCosHz4F0wwXRG9vK4fo4FVoG+5DW90E\n\
VWMPYvHfA0ZkpQSyfY/AuSgkn68d8v2PwDbBBTMHpk7BUH2HKPIBdHd/BN98\n\
NVTnvwz3bBc8Aweh+Pgv4FUqtoBBsllb/D4RbzQFjD+EzuxE6ZgCYlskI1wY\n\
s9zIU2BQ7mJrYEFuxs3uZRxuWcSFHimGFG52lIT5t6QwonnRBL7UgDMPlrFk\n\
j4An1oOv86bHzY1WFwoHV3CsdRG3iBBEJi6UQq934HLbAouLrBE5pISp8UUd\n\
5kz+zOiVlm7vbr+EPTdrWI4FS3BrGXgogja+AsdbF3CweRHlQiu8MXw9jQnr\n\
ECJVv80MmSfGSUiOFyM+fIDIf4KNGYvWPkWGJpVARXAK0aFibFhGECl+lCx5\n\
NRLiIkRqfkbOC+Gr4Vkkbdwi6Fj7NsLCOGFqO71OIPbgebomF5q+6VtH0iBN\n\
Y8IvGsH8XsLCAA+OaRGiARcU1/PZfFvMv/C6CIvvn4ZLZoN7uAXzH5LPxBfB\n\
1FCPhcNXmDxkn8WEq+1FqG/8Bywt9+AdPUwO8n/CUHmIjY0I8M/BWEe+hq4L\n\
+sJfwNa8G6aWvFSX98J453H4FOupS/5v1ifxSUcQtWkQ93KOQ8Krg291CCGT\n\
PEMWm4kQOceGrdnRzQRCqkn4ZZNkRbhwj7hLz0Y1MAI5KB8hZ32csMSIMHLX\n\
sp+GZ5mHAJWPh8LpfEcWvgQOM7tOJ5VHgZvb11l9MPoiKYv/x5hfVOONciEs\n\
LO42obF6YQnE/iwFk81NMvAR0rDBZfJzlxEOp+Pbv0gMEoLXOcamVImRJfD7\n\
xEgwqow4IRJSZvZaikdNiMdTSXZC5FTYBhEMahCNmNhaiIXlcFh74XLMIpk6\n\
KRZWwmHphdsj5obZN0Pkkxu5WttM0rl6KptM1TZh0kbYqniWqTyupnl7ER0p\n\
JItF4mTuAevERusYTHJuQlJ4BtGBe2zu9uRSKWuxYl1vIlz1ExI/Sir7a+Ip\n\
jqJj91/meIrF5CRh8gXivjGusUJmbNj0aUyGVgVYPHAJ2vo2LO27AOeqAoob\n\
BXCKlTA1NUB2pwTzb+yD6HgegiYdpKcvQVHWhLUL1yCrGnhokDEVcfA/2Ehz\n\
Y86TcE9UwlTyM+izf0RGqwqGe0+zcfFBwYVP47LlTZgflKfAFIIx9yeEy7U/\n\
SFUUE/jChEtpK3dDfulLUFeeo/46C/WtbxJbvk93+w1YJrl9S4KLuVg58g+p\n\
EMQkHA92QpHzDHTlz0OR9zL9vBGarCfh0ylhbXiRpBy55ET6iuK9iAdd0Nxg\n\
gjp+TNT4NEk6MvfBWDqJ7HJeIxQr7NRcJsxk46EYkfTqPWaQ5FzFNG5N6TKQ\n\
VZBfnE105yS9xOStP1bGQ8Gc+c9SWE9EFiEc/e8Q8r4K0fTXIBj/Z6yt5bBw\n\
NMjeh2DyUUhET0PE+yYE079EkBl8cNZjavBPYLZzSYDVy9ug0vYQp0xjbuIr\n\
EAtfwvzUlyGcfh5eDx8iOiZZ3AvxzHewslqAkHeCjn0Vy6I32HJyRSMigSn6\n\
jWfBKsK4DcuCn8DutqYRy+RLjdU/RhroLlnGDkSK/hMJ5SISY7sQvvdtNqVu\n\
rGs7oq0HyLLS5Qo/j2h/IbuQPFr1QyTkU0jO3yLEPkW+mI4s75eo7CEkpI0I\n\
F3+bLO8qIfd3rGVNiq8gXEGIVhKKm39KPaMyHSnOkK5/eRGm7iG4xGqWA1x8\n\
IUI2N7wLC6zccvLn4FpkE/wjbjXC0jdKEmyJiQv63KfBGlO3E4HSQ3mcMOV+\n\
EfILJB18XpjzfwD38iyB9RIMNbkZsHoF+VBf/i4CjIMoLobq9N/Dr1Kmweog\n\
jahtK2abxMe7BE3px3AMfgxl6WH2JwKSDliGShmVCXPFc5Bd/Q6M/c3YCCog\n\
v/oteNbWWG61dV2A37gE7Z2fwTlTB+XtnyHsZebNw9BlfwMOyRC0OT+HV2tg\n\
A1X1dx+FXTzHNdXXELNaIBskArTYIOsXs/XgFsux3sutJTEMz0K/asdaSRtG\n\
LnZAcOsBFuuFbPK9iMUM4Z1OTN+4z2YAYeK39EMCGKQcEfnWlZi90wvTugnL\n\
hX2Yvt2DlTYB5ktGoJ+TQz4sYX8v4bFjtXuJyDSKtcoBLHWxxx/J5Lcj4l1S\n\
Uhl7MBNAx7jIC0q6Z2f4kXTviIeFhNAfIxAJszsd+52tmB39S5itAsjmn8S6\n\
rAIJcqrU4ichWeOG3rQrr0Aw9u/kxNxI9Y4XodF1Qyd9CeKl0ywp++3lmOP9\n\
Ck5rFzTq++TSeuHQ38Ds1NNYF/8akpVL3PY1nh7MTX4TdnsPFqaf5nJqxK1Y\n\
nvkR0zs4PH0Bm04xYt17EG3eRT2hm/NGZO3kZdxEbPA8i/j4+GlEe44iLryH\n\
hGKehW5S1oTo/bcR7fiIepWY3d8lISTAzdxCtG0X6dgyshEJJKUtZDwNLAIS\n\
s9cQbdqG2NBNbAYDW3kREIe6qJoEhD2dhjuN86DoDukIbvbLQ2bDWH+Yq4Wx\n\
k7APtiC8WgkbATGm7YAu/ydkQoNwde6B9vo3ob/3GFTnvk44V6RxzkQfWoTj\n\
bOVGZY1EsAdh63wLa1RMU/wC1Lm/gLr6ACLGOSjv/Bo+cQdU+TsQ0s1Cfu5/\n\
QnX3aSpHBHzjO3CsjkKX+0s4JkqhLtueijgCbE0vwjxVC+29HdQInK6wEWkb\n\
x/o5nH8VIZkME9lkiKUKTNzqYvO4GbonMH59hC2+dKeBzTW4VtiC0evDsEk0\n\
mDpRDgmR8fy1esxUC+FY02LiaDnkMwYs5zZgsZ+L59B2jGMyaxz6AQGGT7XB\n\
qTRBnNOKgXNd9OjLmMjpZ6NkY+QiDl7qQdjlxMiBGuglti+n2yNOniOZmo1Q\n\
NNNGHJx/ilA8nbLtS9QVn8Xyynl47O0Q84ns53dgfvIfsbKehWTchAXet2C2\n\
DNPr94n8I9BKthGcH0AteY1Iv5e93WRMiiX+bxCMeqBbex+iqe8TvL8Dg4HM\n\
p/h5qPWDXLUmTFSOGlVbi0X+s5x6J29geebHDJwfysWxgQT/KnnTkof2ON5E\n\
3OdjUs58Gl9/xIb4pSNfmDdbe2f9KZtGOWYSkeBbJ75thTbvMcRTsicZIu80\n\
6YUph5wWufSRNMC842cgz3sdYXLErY3boC4/Bt9iMeS3tyFsI6nV8x5U5e/D\n\
OXgC6orjJLdiRJYEpoV+aHN/BCu/F1GDAIorX4VHIWCJ1C0ZgCrru6RtZqnV\n\
5qG89m/UVfhQX/9nmEfIFbQs0rEvwyVfyQBMLsdU3gDca0pM3enjlmz1T2Eq\n\
e4y9fcndZiwPqLFW2k7qgCNIZnPQyetdGDvVDo+bG2fUdo5htkiA5aI2LI+k\n\
HOWuSSw0kxlRaTB2shai8gkslXRjMn8MnpV1TN0b4gBm1WLkWj8LsPHTD5jt\n\
NjiAfQ4bej4cbzwB5/EjzLBnem3nFsYSGYzZFLswP38UbnMZ9LpWhAN6yEWP\n\
E8ZuwmXMhpC/k9GnWBf9mLDSBw1hS63thkn2NhbmP0IiGYfHco8w9TRctmbw\n\
R/4dducqfPYH0Bu6oZfuwOLiMVa0hD1dRJn/CputG7NjXyRckfaNKLEw9Z+w\n\
exyfwlhS3slk8U0dS8HqjxCaz4W1qw5x8zjMDbuYUImHtvQJwVb7BgI6VQYv\n\
m2EHLI2vQHGbuOrOo9BUHGGzJ9s7SSHefhKqgtcRMGkIS9vhlHCpWb1koM1D\n\
baQwR6HO+yEZ2SfJN6uh8zzQ3CLnyGBCeKUWqpzHocz5IUz9pdggt8Bc/xo0\n\
Ja8Ssf0Qhs486qKbn8WLR67C8OlWdiTdMjyNsWtD7E+u3GvC0iDhpbgVK+Mc\n\
DlRNQ+DdGcT4iXqYdZzXoajrx2zpHCQFLRC1r6VwxcN8/SrrASiHFqHnyyEp\n\
eoCxnGG4pTIMnb3PJsyMaOg9EVLE78XE6Q6EwptbiXN+P1FHept55lM61JEk\n\
KRIaCVzv/Qz+nolP44qUSKYxvgTt8q+wvHoTfkcThGQmVxZeJ+5hQoRGoBS/\n\
ALmqib22W38Z4vkjUK3ug9YwiGRUSTz0LcwLniPR+c8kfn9FPpYSK7M/I/6j\n\
a0z8C5SabvIo17E08y0sCp+n6/4b5PI68u1EEI7/PeZnnsTi9KMQze5AJJF8\n\
5Acchv7qv3za/4cd+gyv1kBTuDuzgGAzHnlo48Y/3TqP3LaNRHofHQdUV0ig\n\
adTcV4ko0WB0yxWIRT/zW18jMMgwSVbCo1Cjd3ceJm8TKRyvQve+Ksxkd2Pg\n\
QCn0Miek9xrR+UENFsuH0L+3FLoVO7QPhjFwrBniiiEM7KuAYd2J1bsN6Hi3\n\
DLOFA0QEdeg/3AqbSo/xk3WYr54E/1wdZmtF8Cvk6NqVSyTVg8lTleAVTUDT\n\
z0PnjgKIu1Yf8tm+wGbvDdbfgOv4TrjPHUBYwPWNTfKU/HePwXlkB1yffIDQ\n\
BBc8klgZg6+0hEmWyv6LL/XD31TPvRfTs559DyHeDLt9ij/vCFwn3oK3OA+B\n\
2rt07SVsRm3wF19F3L21n6//9m7YD3xE19xM1efXWKjNTXwHTq8MoYASdn0u\n\
+MN/D5ON27MgGlLDaRtHIMBlxYsEjeSyp1L3M6HcQQt8bgF8Aa6TJWJOuB1C\n\
BDxTZOqeYmdCkzEHUdkI+UeKzOAGc8xpHaRj3DD45kaE3HgH/Z4WLvs0ItHw\n\
I49yMEuPpcWty3DNdrPVmtlyZDMMF68SEa8ndYweyeOGTqBCLBAi0aGHeW6d\n\
CbOFz+iAdlgMwzw3IOvXmGFd1kA9IIZlNZUKmISvRbAKee8i7GrOzvg1JjjW\n\
9dDxpBBlt2P0fD+CAfKv9Rao6FzNpAyRUJJNGG5nfk+4DtXQCps6370kQc/u\n\
cmjmjQ+FmTGT6psI1Z+C7eWfI9hzH4H8w7Bu+zkicg38V3bC/t5OhKfodyrO\n\
wvq7JxCW6BEdLoBt+w4SplwlRruyYT/yMXePd96Fbf9biOsNdN1zsL78UwS7\n\
W+C78T4sP/8avC3d7IitfdeTZK5dmVh2nx6u3Y/RTzyKiNTwuVTnTURXSR/9\n\
GznJj2J++vvEGf8KHdkq5gnSkz669f3ELz3sp0wgeFSOtfk3GDZ+5Cmu8R5P\n\
fRXWaIhox5j5y8zSD9eKHNo5NqvxI5ndA4l01zoW2JSzmSGcCOFn94/gbexO\n\
NVIQvlsfwd9STVb5JwiMi9nkNpthP0IdVfQkWsRGi2F/a/dWZfXmwXHyBFdZ\n\
1A9chUVb7/PyuetGbHC982P4WnuosjRwvPMrRI3udGXFxstgf+MlOA+8AE9x\n\
TTqFF2tcE2H6CyJBVosZfEr7WRvJGLlfyU9VEiPZEgluYuozlcRMFYa9Ibae\n\
v5o+FtDBsfNnCEytpirki9i0Ejq3PwbHR28SaeyF6/ReOA+/icDQGKJjdJe7\n\
32H2TeIevO/u1oNnvw3XvXtbD556zyzc95x4Hr7mbu7B9/waUbMv1VXj8F14\n\
Fe68ckT6C2F7eztJoASzBpx7xIdmW9MG4eF8HZntoza2jv0t99j/mK7Bh1Z6\n\
cbez+chWCq2t077D/v814lI3XO8+CW9FaoE9ybdgwx2E+jvg2PUE4aST3Ys8\n\
rhDD9faP4a0igz1RCfvrLxA5pKKCO27Dcew4+z6Qu+fTeEhXC7mAnmO/S1WL\n\
lprhSYTmuLmEDfsK7K89hiBfShwug+O1HyI4I03l+vwndnh0XHYX92Y/Qeli\n\
LpyxAASaNqy6OR51euZRLjqNwrnzEDl00Fv7MZVaXLukbYbEpcSqoR0Fwk9Q\n\
Lymmvyx0qVrQoxhi7enGRggDq3eQLzyDuuUsjBoXYXXxUTJ3GsWis+hVDzKi\n\
NlXTf5cCDjz9jL7hno4MPlZeA8T0p21i4+qhuUQ//ybp7fcBn4WqiZ525VU6\n\
RmV0LVwZ9Xn6/AYgvwaQAwS6c+gKUlihp1uj85deod+h1gmSjNLd5b7zkmOk\n\
b07VEDPyvIlw82WivScRHB5EqCkL1me+SzW8hmDBR7C/8zLCvHGEai4TTf6E\n\
1IQZsZFSWJ/6MpxnTyI82kW66adwXrqGuGYF7iO/ITo8gJheB3/Wm3Dm5qZa\n\
MQTPx0/DR6hgWtG+7Vuwv/kM/I01CFSfJ0p9Hgk2CjIO75kX4LxymwFwejqE\n\
GbNOLFUh3PYmwv23yOD6U2OQ/wSNuQXnp05CTUasX3IBRZIqVFPlj5mo2jYD\n\
KJ15D22qcSwbmpA9cx0Ta1moWOeGUPsXTqJb2Y47vHfQq1uE1NCCT0a3Y1R7\n\
Hzf4t9kyMkMNzvPOQelaQ93sW8gR16J3NRcDOgE0jnGcG38b8kDks41szgaW\n\
bzFPTq+/BJQEZz/JjaWXyLEnCl15hz6T8y07QMdOUWM/Q+K4mI4tEBi2MaHd\n\
AP8JwigBREVlhL8AHOToL27juqPqA7ruaZKa4/TdbwC6S4hf5SrbQpW+9HFK\n\
4v0jgs4IlPMeyEReOCxEhvENBNycpmFyi+mWvZAKPHDYUxupJDfgtkTZPA5M\n\
K5jXfJAteEkSxOB1xjObzDlUAawL3TBpwpy8ZM6zxdKLERH1x+F3J/4owxgB\n\
hGqvw7nvt3DufxmB9h72UpthNwIVF+nY83Ae24MQX8jBmNml7O41+u4q0f3z\n\
cJ0kXKktxCLNsO/8AWyv/wah6RmEu4pIt/enWCuGQOUVBHkLxKc2+HIuIVCV\n\
BfeJnfDcvUD4e5Bhs9h0KzzZOYxHk9lweNM1R1jfhbhsBNHBAwhS38gQ6cZG\n\
ZsO//wu3PnxsK9nqRmaNbCaP0kMuSHpFsFiRhUoZN7vp8QuRNXMFlfMXMG3R\n\
sFtu5c98AH0qVNEbdkEoy0atnDPEw+IzGNCPYYQhurmLqFo8jwu8DzBnGcId\n\
AdfthetXUKPgvDK1uRG5S83wkNBsWb6GHP5B5Ivuwh1PfhbDljxglaFhouvZ\n\
f+FISXaIXn8LuMTMoBVhkPAo+hWRCuFP+J/0+a2tMk4eIN1F2H6PPr9Af68T\n\
XvlUZgf3KCu/I0wvpcDipff0RMtvcJ9thXTesZRE/iI0fDtKP1pBxWkmIaUc\n\
5cfW2NfuSjMbDDR8R4GS4+tou0WvH69BJotiwx9C5dE1GGxxLN3Xo+DAKppv\n\
KFD+8QrKr2oQTWxivc+Iog9X0XpDiZKDKxjtcrFbTlSfUcLr44C82mVAZ7kl\n\
06pMVEg6e2R6gNd/cyecObmsauAiYr7ErrKMzxUj3PEhwt37ECjaw7Z+QpSD\n\
UOMbCLXsQUKvYvtSfPYaQg2kN7uOIjKUx66e/vSxu+xvbhiIjJvo3MY3ERV1\n\
c3uAzlykz2/R8T1kbtex6RQh3LILoea3iS1zmR3TMkiT6Upxcy6HDdmWm5px\n\
Q3AL1XPHULfWjSi5A3m83eDbSeeGtehZL8Hk+h3kLBQiSr/TIjyKYdMilvTt\n\
mNRNYlHXjMuT70BoGcb5sf0whzyQqPORJconrzmCSell3Ftuw5D4CLLnsyC1\n\
ijCpGWLWtn8WadYcQs8O1kHDwvcIQWTKXOSETf8DYGog9D3GjHUSq1L3dS4T\n\
C1IZObGlSwDw/oaO0auGGNc6Q8xIgmLxBWahLCD4ISkLB5nD7YCinN32AqrD\n\
dM0qYI5Qy6RKNJIJXb6SqaGIPYiq/RJ0MomQuD054JB7UL5/GV01VhiXnCg8\n\
tA6TNcG2nKBajZpsA4LuIKpPrkMmdqPy0AoWRFwaRkm7HqUXNfA5Qqgm5M3N\n\
cTmmHFIX7ucb4NL5Po22bgO6KyyZZfkMOFZ5iK7JUpr9SwSCXnJWnkJ8fRzR\n\
gT0I3HuWGr4Lgbs/Q1y9SKC7g0D5TiTkHXTsl4ir5hCbOEnvnyNma0cgL3Vs\n\
/DjprmfYlXah8icQXRhFUkcAa3iD3WAxVPMqEibScOJ7CJTsIOl5GGGy/kxc\n\
abD0Z1R+MlNt8YQTVXOHkUda68bUfsza19AnvYaTw6+iQTZK5rcdV6YOIGd6\n\
H8pXmyAmY3dk6EXSVqdweeogdKEgVnW1uMU/jDLSZMVLpTB4F3Bp9GVc4Z+H\n\
nLRYufAQcun650Z/h3xJBxSm+8gRnEDh7BGUkdmP/77WctYRiMj2LJH4tpGN\n\
WHiOzCTpouUT7DIErO2h9+8SGJ6msgpOH80/w5WRnGRDsaDYR5+JuhbpXA0B\n\
J0SUNUsKao4+2+4T/f2UvnuZ/oge7cMESGq7RTp/lnxnMz9TQ5opK/IPyeBO\n\
RbHFQglEyUubKVeig2hsfdyM2tt6pAaLYZmzo/y8Gm5TADWn1yGZtKHypBze\n\
AAdKv8KDulvkKKh8qCDAtWZr0JWnQXe+Fv1lJjbpdM1ZBRkU7vekPSywvvIQ\n\
sBJ+Lzt4/ccpYCUXbiM0yEVNbIZVCFW+TmaSWKg/h7unpA/h+ucQ6T5C5Tjb\n\
shmiclU7EONdQWiAE+2bQQWd+xoSZgEC2f+GcO8lYrBrCHdeRFynQkLDQ2Tg\n\
KJX5NUKdN7Dh0iMmLCHW2k5AI5CqZSnm/wt281m9m8R9JBUJS8wSifvhDHPL\n\
ST1BA/Rebo3AguwWKtZaYCVl5YwEMgvKvEEzDD4Dt1CFWdNN1/CEbGxWHSbf\n\
qTVgxpKuAlmL3OCON2iEzqtnI9Y+/zCi/pRT3+RpMusB2N+ME70EtFvmn6Qq\n\
fFL6fmvnGiYdTarMI+lVRwgS8QfNqXMS7CgkIhZ2T2rE3XQPa2D3G/MMcGik\n\
x0TQ9LkUmJRjZlTf1LKhyMx4Sf89JWovyshGStDbaIV6xoZyYpXUqh8YeFaU\n\
XSAwWTgwrQmcqDiyBqOVg5ttwYFKsokeAhsDprFOB2lGL5a6jMjfJ4V6zYOq\n\
42vQpcqLWzXoKE+B6XOs82qvfxOGppyt9C2Ep5ViBBoOcc/oniXS2IYYWZ9g\n\
I+f0kYNL2HkKkeFLCLae5MoR7wfLXiU85CLYcoo75phBsORlIp5VBPP+FVFh\n\
MxLrLQgWEmkJ+xAq/R65IgVIrA0gYTUhPkXEVraNiLMXcek4YTnySHprJ7Wp\n\
DxNmNlNcZojA6uKhX8MmV0ztCZdKG0BtF5RwvT4zZspVfslZVSoHHwlhXRBG\n\
BfMXgIMEcNQVRs3RFfRUW6Ahc1B3fBXdDQ7ESJAwlWgwRjCYtY6q6xpIphxo\n\
OLWKYjIRkWgSk4UKVNNxhdiL/iw5a1p81GjFZH5qqMElPCdq6dr9LQ4OC18h\n\
38qKwMoAwvqUW0yw8i+SOZCJOIEd9RCiuI2rEtRTEuEIu8VWzGUinUGvdm4s\n\
biNoJSeM25Qh4eRinjZ8OvgWOhFQpCJ9wg7EvdYUGZiQCHiR9JrYvM4bARP0\n\
Wb+CT2V4JI0AhPTUy39IWuRden2STNXzSHoYxvgpQg+Ok6n5HUKtZ7Hh1SFU\n\
8SPSMFSuisoVvICkm8pVPEHnvsedW/A8GfAYJ8xr9xKbvItg1S4kHXqE655C\n\
qOsisdNvER5vJG+xgEzgC4gMniU0/RYJu+eRJ7iW/VGqZd0yDwrfl2BlNZ32\n\
j2n6DUwUaSAc5wZenMStnVkK1F2QY6TNhmB4k12HXHmMkZVEJO4IRoo1aLml\n\
wliVDjU3NAgTAcQDMczU69BwWYG+GhOcbmYr7yh4rWbMdprRelWBrlIjnJ50\n\
kNRXqWrNMOb8HPqyfdBcfRT20RYYc5+CoeoI9Hd+DctgKyKrLdBVH2TvzU7y\n\
0S4kMRRag7b4MJscR3NtJ+u2+UcvwNzFoDYBS8leIo9l6G/+CMa6E9Dd+jls\n\
U4MIz5dA33yRI7zuj2AdbISj7RDs4zxmSBzaM38NfVshZxu+iE2/HvHlBuJu\n\
AZImDmmbfh25adV0vIMYIOU9etX0uZH6XgtCZS+ykmvTlz7WTMdeIg7dZHk9\n\
sd6B+FIboYyLRdxgzl2oQZzQvMlmBU8gqehHTFSDpFWbarpH/oZ9+Z/k3RsR\n\
W+9DXLuQmo+l1jEKEVvtJ/DYiC4kRAdybDDj29Ewm2V3w5fKOBC0ICbtRkw+\n\
TncSyUReJs1ziK700rlE/x4Tax65Qe3/xrpzvAoV8g9IMTvmgk7ixWiRCnnv\n\
r0KujqYnnmLOIMo+lkJnjm8N+yvcqL5CeI6mfYavkaRrhDr/bS7KTjMDS/lu\n\
aIr3sZ+TTiHUN3YhIKyDroYbX7a3vgv7bLrBj3INfmMn628zDW7pquAavOJD\n\
uEZuQlt5kr1WwjwK9e198PMKoG+5nGrwg7AN1sHR/jGc07N0L3VQ3/wx1LfI\n\
kocTW9H6YSP1rbeZcYItc8b06fp36NhGZoSUmSlnNmhLmQMwwUsRqx0m/grs\n\
a+bMyGPM6YJ5RgLTrIxNcMj8Y7YA9GjtbFS+bZ46Fk/KpExJLRvhhPDfYcO9\n\
An/R9+EteQHevG8j0Ed8r7gPz+1/hb/2JXjLnoL7+j8hOFKOYP2TiKyLECPP\n\
yN9RTjhVwF/6I/jIJviKfwBv1VvYYHbXXquE5+ZX4SOh6737PXiKXmNGqlIt\n\
9MdEkgksdhpRd1aG2jMyNJPckktDaUcwGYhgqFwPuzeZaeig0Y/BBjOzV89W\n\
Q680QFu2n5MIcR/8ExehreDMIiIqasQ34BdUU88+wh5ytO3ltoGLKqEtOpLq\n\
2dvZCfLA+GVYuivZcpbyD+AauAJ9I7dCeTOwQo34AfxT96Bv4tYfensOwzpA\n\
Pfs+NTRvEra6nXBMjxBIXoFzXrzV0OTUbgQ8D2mUP2SFRfpY+vk2CG0WR4yR\n\
Uqlyfw+fLw6HLwGHJ8Zu8Mek4bH6OKHgpu/CTIYq6s4ShZ90f4jkF3PpDVhT\n\
g1DhUByuIKdUzJYwFsiOuhiVTL8lVQbILwjD7o5CZY4ydZi+PVNHD6aLptI3\n\
Czb0RynHxP57mL3VjImP72GhYY5dfMY/nIPpW/cxd7UavBsdCDnddCwXs7nd\n\
WLhTh7ETtVi424KRIzVwmQJ//mnsRccPEb72sijeMA/DX0Oedc9BeMv3s/y2\n\
YRwmHP6ceq2PesaP2eDmmOAiAp1VpHeu0LlvM/VLJORCsO0AYoY1sk6PUmO2\n\
sg8dF+fCc+85ZsAgtccfl6crtdcEM3XJDtduuNegvvR9OCYaqPGfh778fWiI\n\
zp3TrXASaDTFpxBaboXs6BfhGC+D9uJXiGE+gLP3E6jzPiLrrobi8N/D3FkE\n\
c/FTUFx8Fq6JQromWU81H5orT5Db/QD2hp0ExlsIzpVAduLrcPHqyXww383A\n\
+YAAdf8elf0FwoEEApOXoC05w6iFtNeVpG5zs1yNWf3WuvbCOg3aZ9woatZC\n\
6d+EQeXCpfvcSo/aHhNmVWG0ket7u92MwiY9crocMFn8uFBlYgcXF/gWVEx7\n\
oCar/UmpBoXtBlyoN6Cpx4wLtQbU9JlwOFeBsmH3Q5N8HEj4JWwO3cy2B8z9\n\
yO7WYfreGKIhcgXW5ViqHYNHb8J62ww9VhDO2XkM7S+EdUUL4c06eGxeyO+P\n\
02uApLwWE+/nQCXQP/IppPwheUa74O+sfOjn/hdZLgH8lb+Bj7wpP3lPnuxf\n\
kr5yfxopHRWIjn0I953vIdDyPvzNe6gsudySEfhLfoGoMbXwzTIGbykp4eDm\n\
/0mzi24alsZjsPYWsBsRxw18WJqOwdKZi5g3SFaMfEBeORzdV+AYrYdPWEvl\n\
zyKgUpDj4Yd3pg6uoWzYeu/BP98Ba8sncC9yqbyjqhGYG47C2p2PeDBCUmsF\n\
ntl62Luvkjtdwib6cLTsI0AUw7vA4yRiyAD3zCATUJCaNv4CRkdMuNFmxtya\n\
D1NCB06QxtLZoyhs0EJBaDASGi6n0FDfb0bvnAtn89WY04ShUAfQPuaAXO/D\n\
5RouKH2R0FDNd6GmzYCepRDbotMLTuRUaXG33w6tOYxrFRrwlJEUNfwN6aFe\n\
TFzthH1FA5tYCZfKzq7+X75RhcGD5RDltFFLN4F/swN+bxja1gFMHCnE2OFS\n\
rHaLyXTZIbxeC39kE7bpOfBOlGD0YCHmi0YRDsY/SxljRA+VqdRDQQ250FeR\n\
0EkQptpOmNYQExcREH6GhMP1+5QhukJ08CziRiUS+hl4b38Z4cVhBCoeR5DP\n\
DfuypqvgdyxlpMNTkuTOR52pKUPipcCyGC7BPPkdqY1Egl5qPSHcTOaBBLei\n\
IKJTI2SykxNggosvgFei4Ggu5ENgTcZSUNzGfDcDn2JrFVVYJYdnfpm99mYs\n\
TLWTyu7ktJEb637kP1Idwt5KdmeS63//mEKD1x7EodsKVI3YcLFQiWudTpJ7\n\
Cdyt00IVIGdU685wQwOhoUfowvEcBYr6rKjuNLHoESq8uFzFOTVLMxwaKggN\n\
w2tccmunNw61LoCWYStK2o3Yn63ElHwLDZaefgy8kwv+hVpMf1KBwd23IRsj\n\
e9vQgbFLnQi6/bAMTWL4QAV5ATqM7rkF5Qw5Qyo11luJI2yk5K/VwuvyYObo\n\
PSzWCRG027DeNA6/+7No2LAL4c39BvxNB+Eve5yQ8SahQAxfHh1rP41g8wvU\n\
mq+wiiJU96MMGjjxIoev8HH4Gt5HoO5pEikvUfcn8SIpJPHydaKLd+HN+To8\n\
+S+w4iWNBvfQAygL+tlWtjeVQnouC9rCAkgvFCLidJCPcQ3yO+VQXbsCVVUP\n\
IckO6eGT0Nc3Y+3MOXaVhOLyNZh6F0hlNEByMgd+qRjrJ05DU1aLteNnYZmR\n\
ITA3zm4wrs7LxerZAuKTcWirO1i3c/3j4zBPrm3NJBOXO8VSxuKnNkX6Q/Kn\n\
LOQ+hj6FEAaCRY068GVBFDdqMSSLsBnrrxXIkdNrQ1OXAe/dUWNA6MQ5sgYL\n\
2jAqmrSom3JjcNyKK3VmaMx+vHdFhrIRJwYGjaz1mBfacbbSAP6SGyeLteic\n\
sOFGqwViuR9nmD2CdbEMQhjLMVM2g/Q/2/AQRo42IuR2YO5yJabO1WD8UBHW\n\
+9aos0WwnNeA6Yv1mDxaBHHDNOQtfejbdROL9eNQtg1g6kw1+J+UYuoyE6aW\n\
TCGE82U+z26VE5nKQ1hQRQ4156MwCU4ifGotQSU5sBzWgzVPbKHjPhd8z/g3\n\
EUERIuQsMJswpW1uQtmHyGw1ooI8MhqvMkYjA47hB1CVMFGyQawfvgSf0c+e\n\
ortxFfrWNqxfv8uNlgWNkJ64hcD6EtZvFiNsIa0umiNqWCHZegPqsk4i/0oY\n\
xokOBu5Dkd/J/nhIOAJZVhG0d2+Q3ufCyBy9g3BNDkORXQAjk+Ivu57dYSS9\n\
7xMTQrCWWwGXLcSoiXSawmQiM2GW+rextQvLQ4EP6UBkJh9EMhDKXJRZ7rWy\n\
4MDxAhVOlerhZEQJnSde9WBo1onmUQcWZH60DVnQP+9jx18D3ig6R61oGnew\n\
m3jEyLmdWvSga9oJIXl9K8YIe40ZkRPl3WbCaQgxUrj8OScpEQvGVgJbGX//\n\
BKYH3Zi40QuvxgKvyoy1glqMnX3AChuGPF1rWvisvkwMcSIKl1QNp8LK8m2I\n\
uHbyRBGs2tReSCoD7Ks6duvAlJeUTlXIdLBgxXcRXiM3mH8WvtaCTFjPhnWK\n\
yOMFBgYpkvgnIon7UOb3gdnAfP3IdaIwzlSYSrKgqa2HPLswlR6ZOvOJ24SD\n\
ZazfKmFzOatv3cDahdvQt/UgZPHAfr8CxgnCQX87YYubbYzJBJBl34Um5was\n\
YgN7LO6wIrDEh+TtPRC9+iG8Bv9W7v0EVA09cOj8mTAtZn2LomsO6/lVmL3R\n\
iPnr9VAMUJ+L+bFeMwmSIEi6zJB1zcIytQD9tIb7aasZy7cbILpZD2nzDDuw\n\
6pMsQXStBov5DyCtHoFjaRWqwUUkYgFIcpqgn1PBOjZN5zRg/lYL7EpHGlZx\n\
cQccJ95DVGPNBEJGiYbP5MhQOO7J6HbFshOdi/5UU4L1I+0Tk+SNFGHqZDnR\n\
QwkmT9fBonCmw7gYCFjI8Y0l0pOHD7XnJrsBZZJM94ZbgYRFl2nPzagDce0c\n\
K7TS/doz0o75Vz6AsZ8H/d3b1B+bSeEPY/XgeXhJ5irOXoChawK25mpILxXD\n\
wx+E5OML5EFMYPXEBdinF6AruAfz4Cz0uVchL+5AYEUA6ZFzcPDmoLl5FZq6\n\
YTgH2rD6SR67M/nq4TNEjv3k0jbA3FhJPFGKiDc9qPZV9hnUVc1YKJlk05gz\n\
qa/EF+5BNrROMrwcy80ieGXr4B8sgE2hInNajVCQZIdJRmKsFfK6bkjqub09\n\
ZIXUeNUz8BvMmL9YDOXYCkQnC6DmK+Gcm8P43rvQDoxjrrCPZI0Sk+ea4FgQ\n\
Y+pEBRxaB2zjk3T+FNN3OcxR/4mTelmeRmR6GHEdB1FmhD9h5EbnNyPECXbS\n\
igEnOXjcUtENJ5O5xZlZOpwkhy5M58e0XBauDWJrZvqZe68mZu9HZFFEPXsD\n\
Sea7QITd2D0mXSSbHUGk6w5c94rTsccOVxQ+LldBZtw6FCAnm8tn8Ugmgys9\n\
RjIe52o1xm24mUpH/O0UIKJGDexDI2TFJ8gRdsN2v42sdz08Us6hiJnUMFTX\n\
QFffwSRyRGCmA4t7DsMuWkVwTQxdWRVM3VOIkgZUXToBKanleCyK4JKQ3L5K\n\
+m4CiQi7MRucg33QlFTDtaRBWDINTQXj3ibgGhuFT2tPWdavIKKVkf90ixR3\n\
K+avVmB0fym737G8oAZOBzcopKysh3p2FcIzDYgwxt+qgCCbyKqhD9I2CVtm\n\
5XYxjBpumlX/YBDiwh4ITjQw/YidkVg8VwHd4CTmSwcRMtD5d4fgmpnB2P67\n\
kJQQqArbyOkfYjJyp1ryK+z8jr/gEOxH9sCbfw62Pc8iNCfFpkcKx5FTrBuf\n\
lPXBmZOP6Gg53JWpBXBXX4H99BkOPLJxOI+9Tg5fFhwfvY6IdB2BIvK4hgnE\n\
EStcB1+Ct4bU29Xd8Pd2wUe/E5xaRXTgNuxH3yVFlECk4yqsO36NuCf2yK+5\n\
Jv1xut8HrdA3dbLLBNJM5Jnsh32RbdKMcYysUBNUtz0U7v0VNkBm6VIhZMTT\n\
qppmzN7lFg9JyVbLxlRIEthFp+9BvySH4FAxbBofgqsLEOSQXmjuIcnbjSiB\n\
d536rXRATtURh/RuPVbrpyE8Xkys5kbUoAafhJFucAKi4n4Eqbn52b3wra9g\n\
/MMimJc1MPb0YvRE46eqfsO5Csd7uxBP7cER7cuB83YOOZ3rcJ5IVb2cqv5O\n\
AVU9uT815dhwKaiqd8Nx6j3EzG4ES47CnX0LcYUEoQclCM8TVxSfR3BkgVwM\n\
D8I8HmJrIviy98NdXAZfwXmE+KsI152Dv4fRQ2F4Lr8Bx+Ht1Fz8TGAQI0h8\n\
1gAcKg+5/RY4Ldw9hp1hBH3xzKp3kw8ynhGaFXcmDIpJVO8yBrnJQqo6t5nz\n\
UJi9rN3GIBc6RR3ZawkiFttMJU9JDTr/DfvLDpkN8ikdTEpu3zCmKjyk2Jj0\n\
8sz22h5zIOOYhWxeqGYMMMo8SG9VGrSmjsk9mZ9zKl1wGkLpVC0bkRCiLnYY\n\
PjMdbB0YxXwO8QERrVZsY4lcWd4A/rkqzF2rxELBMKI+B6b3ZWOG/KiZk8WQ\n\
9UtgmZjG5P5czJePk9FRYPZcGVnUOrLe7URjMdjHxsE/XU4quhzjHxTCxBdh\n\
rW0SmsZW8sOyoZ+X0/s+CK/VQ3ixChqBJsUdTyKpGoH90DF2GpatReUQnLcI\n\
JDYpnEdPsI+XVA7Amcv0zyp4GqoQ7siGp64eobZb8N5/gGD5SdgP74avtgCu\n\
I+R5NVbAX3QBwUFmmWII3ptvwnnmAJuhNq43Ex+cIZAQwzdehr9vDEnNBJzn\n\
ziE23wHnpctbkV/RKPrPTaD2KB99t+ZQd3wGFnMUq3XLmB3grIlHYUHDR5MY\n\
uLuE+6cnMdqsY883jMlRvm8K7vAGZK3LqP5YwO5k5NfY0HJcyKW+IS+p6yIf\n\
GnWUq46/RjC4BK2hBUYHn23tZNwKq2sacRLNHvck1MY2eILcfF0wqEI0kVq6\n\
sRmFzd4HvaUfoRgHyIB/HjpzB1w+KQIRZ1qKpIFo4q+j8eg4BI0SdJwawdqK\n\
D1GzA/Vvd0OlCsI4JUXVAfJ+w5sIGuzoPjmM8bJFdJ0ZxUyvAQGjA10nRthj\n\
nZ/QsT4jYg4X2j7uh2jY/F32Z/4KSXIHp/ZcwMhBclxS8TfMDrFMcnO/2cUF\n\
3gZsmD5SDa/JDb/Fxc1eMutGYzGEXVycQCLoh1dnZfpIZnFelJz1EJny+ZMM\n\
CylgFmsQVCxj6kobGZlkqv84EPaFU8zKAG4Y9o+OUAdJJYqU98OZRYCzr8P+\n\
yo/gq6+D7/Z+eKobEZushKvwKlyndyIkpoa1zBKTHECE1wrnyQ8QmuqD+/ir\n\
CE4LySB8DNvb29gMXa5Dv0GQlJQv9xh9x4M//wwC/RPwXX8X7vwsAuRBeFt6\n\
yFq74Pp4GyJKToYwWTJ6L0xjZZEb9Jkvncdwmx4rDSsQDnJpZoQFIgzUch5Y\n\
QGNH0+FpuPxxzJaKULKbXNMlF3j3ZlH8zgTUyjBCRjvaTgkRSgGu+9IMA7hM\n\
Ru+wGAPj/wHRWjYmBY9h2TAElext9M2+AZniFvp5v4Bo5TB6p35KcsUMgehV\n\
qGxypoGwvraXPK63MLf0Lobm3oTZPoj+8W9DsHwMfWN/i/GVos9gzi4xQiVx\n\
wqlyYuTCEHi9RhaHFW90sfgRlwtQ+U4v3XgAis55dNxahMfih0mkxUK/Csst\n\
InRmidljxjkt5vvU8Gtt6M8VMvvTp9d6Phwrn4nd3NzaI/oPHj6WKve36WN0\n\
xNgzCvXU+lZ6T7KiijYeS+d/lqbUZAyajik4JGtQj0roYwQ+g/O/ZWA2BPuB\n\
jx+CGRm6m7dJHXoRnhxAqLOK+KoECQd5tyYJwiIewhMDbDAvo70ivF4kQ3Hi\n\
pEHSHTkITfLY249LZxHqb0BwbIp0iRC+ilvwd7SyqjO2LEBMpYDnk9fgvHqK\n\
oMiET6TSaixMkBrmxuA2wxEM3Sbvys11EdO4DB0lCkjqJBCkYMbLEUE4mlrA\n\
Ew6j+wIfsgUnBm4KwSc4DhYvY+CWCNOli5jqNSNIbNB2WohIqnzPZYKZKgOz\n\
WEwPrZGo3jECweyvML1Wg9Wl7ZCZxyGc30av3NIt2cqbmFeRY7jwFjQktJEw\n\
Y2jyO1g19MDpHsGyLAui+R2YXudybuhVH2N8+d5nYOZT29B3fhwd56bAa1pD\n\
MBCFII8PQcsqhq9Noev2HGabxZhoUmO9jYj9wDCG78xi4MoUevPmIayaRf1H\n\
IxiiY/2XJ9Gdtwg3eRsDBLNQEul5MsZT6xtwsGw5OO4EQ8VOfRBDEx5EIwk8\n\
aDGhuFKPjnEvvLYwBidd8HiiaG4woKzWhIY2M9bMpKeNAZRRuYomOtZqgZnc\n\
As2qByV0rLjKCMEqu3zliRSek5oxOI5/go0UmyYV5L/l5H1qb+646D58vX3s\n\
J87j+ByC7eTHLWkR47UhLBRz4P47lnT6qKJmh+2IR+Lg3xFisEUHaZMELdeW\n\
4HVGsVS7hAc5UjJDm3CtmtF8dAbSSTXaLojJt3eg+q1BPMiTw75qQNtVCVxa\n\
O2rfn4BSHiBPw4PWkzzo9OnUY3+DRFQJ/uxjxB7bIZaR20q9Ym2ZgcMYZufT\n\
DAPo5B9BqCygYzvpGMEhaaOa/heMzx/DgvQkuscfwwTvN1SmgS1v1d8kOOR/\n\
Bg6a4WU0npiBTeuFiPCqFulYaNh0HvQc6UXb9UW4lFb0XhdAOa1E+xk+rDof\n\
JI0L6M4ln0moyhxbbphHV84izIt0jUtTsFoiGThsxJFfoMfCnBsF1QYwjoyB\n\
hGN5rRkTIxYUNNpgMIRQXKiDYMaF0kYTZvgO5JaaqXKCyL6hwNhqAPUlGvTM\n\
+GAgrX7hshLiNT9y7mowr4xASyqwrNUKUl1PpIhok1mob7NlItaYPJwJuyPt\n\
e24G3Ozs1BYS/pDcXjPZ3PBD/Ph3rNgZvDiFBqqoBxdn0HRqlt20W9lNMuHj\n\
SbRemYdZ68HQtRm0XxaSiOFBSCJI2raKoSYdoZERS5OYGbexw3UDN0VQLFnQ\n\
foyH+1S+7fQU7metgDgtA4NYaJGa88uQm0gcUrNLjf3gCx4FbzUL67LTGJx9\n\
E1pTI3Wox6G2L2JW9Bh1pqegdaxAItmBSfE5KLXZ6Jv5LdSGevROPo41TQWG\n\
J7+EcclnjU/M48c0WcYearaR4lWYJWZMV62y46IrDWKIGEm3EQW/ahkuG/lE\n\
XRJ0np9CH7GFxRRhVbr0/nLq2DxsJj9ERTOo3N2DuQHjwzAoLjFAPO9Bab0J\n\
TDVbpB5U15vRfV+PsfWUOxROwKL0oYx6/fSMAzUPuJHe0U4DhsVeFNzVw+zl\n\
nI7WMh14M05cualEdYsFze1mFNWY4QxsZPaDJwOgcYcfmiz9Kzi8Qag8nBqM\n\
k5biK+gWVk2QubhjG8kklGSAwinHgkmyLzG6oXKH4AyGYUpFdDDlFFy5lP37\n\
HKvr7M11MJZUwifVcsuXP8/ZliwBNJoALDI3iVAubiAWjNETx+E2+MGauEgM\n\
ZqkTDlNqi15/BOHUJrhhb4TdZpn5F6L3MeLSsJ+koDcMM7k84fBGelCfQb3T\n\
0QOR5DRWNE0IhHUYn/oXjCyeJh3shV5XiNnl01Bb+Gz/sNn7odAUEeKYJLcu\n\
yFVZWFi7CZuXS5xhtbZBvH4b88s7CUEFKQSl+81Gcmt4OjNk/dBC7XRKt4eO\n\
IUKGcbhonpEnDyOksEiPpQUPsu5poHUlIJ11oKLeirF+E8q7XWQwkxjps0Io\n\
dKGixQweEUVlGzePwBszY3jJj6oCDaZWyGGlOsq5rSZG9OEWvU4tBrC26MTp\n\
LC1saYR8HpOkkPd0LCOcurNwwI891ePY0ytFiHrvtQ4BXqmfxenuebxYycOo\n\
gYgk5MGr1TwspfYZXFPo8XThGCrFRtTNSHCZxw2wBbwuvEzlVnzxdDIzT3cN\n\
DKWt/39bVxobV3WFXSG1VX9UolRFlSpV4keRKkppK7qAUgiCNgiQIJBACaQU\n\
mjQOhdAsLYEmTurYjhfsxIkTE9uJSRzbCbHJZjtO8Dgeezy2x7N6PF5m3zwe\n\
z/Jmn7Hnvfl63jITA7E0eqP3nueed757lu++e+9BVEEZ5ceUjfjjd123/527\n\
nMvvoZaj2KRo1cPPcNKkiXvgtJ+EMyhMWCss11jynoR8SkgJ8gUaH8hjRlwj\n\
waRX2cVPhGHpru5FzM/G0NxiRyN567rjNgzpk0iSDTU2OdB42oljZxdgnRFN\n\
dEITwuV+8aWoWunHmCUD9yyD+gYHmilQ7y+1YN6/giky5YZml/D/PaNRnt/k\n\
ARiZMmPb1SkJgBzOyrR4vP4mPrg1C9WcC+s/G4M5Ji5D6JTrseWaicgbgzfb\n\
FDBIAHypncP262K5kPYRPQ4rPAUANtF9pvzgxU8RHbwM+8GDcBCldRwqhaOy\n\
ASmfB77PuoWKIWzQhoWuXqSdZnhOHIO7oRHW/+5BeM6L8LV2JHxhArED9opK\n\
eFqa4K4/ipBsFL62K0LdheziDBYuD4BNhOFrrIO9pg7uYw0IKackoH9E2vcT\n\
o6NO4O8XvItg6lElIgvdSMftSBGnXU4xWEkYSPPi2qEMI6frl8jkRZaTTVlI\n\
XokFpm1YyYTzg/N8SZx8Uv9L6VyWSFUiHVndFx6U7JInLRMqBmFKsPixlnRi\n\
BQFm5c6GkSwWfBnw5SqirhiOtbrBLOeErEdonBxXVnKV/PBthD7nyQYNbnFe\n\
TCyyjHA0m9/NOg83f9Hm8JBNDeNArwa7+2fQozXj3eumwuKAObKrzRd08FCk\n\
3nyeGGBE/MlB3RzdJ8Gt0KNcccfevga3v6US1qpWxLRaxLUaxHRGrBDEll1l\n\
FGj50hkamMvq4D1aDte5HiSn1bDsIKJrdmOhbh8CGj0s2/+BkNGK2MgVzL67\n\
D0mbCZbdFXwlXqzYRmCpPYNA5xnYak4h7XbBWbIH7vY+ybDuF8opeCcfg0v3\n\
HjyaP8Oh24nl2ARsikfgJRbpmvgD5mUPIR6cpfsehWv6BGLuSthG18A3vRtW\n\
xa8QDRsoj9xCmbRYtIaZfQeLtgtFr67G8h4h+ZYNBhCI3nl9mAqncVvJ8DuJ\n\
rNpXKkc5SQAeJiu5GhGZ7demqZtksKdjGIdGXRg1WfFBnwnD03a80akGI3kj\n\
zbQVmy7q4Q2F8ca5YQwtiuY7bJjHez1i/b3OER123hRT1hXKtzadU/CesIDM\n\
mU/gPicThjQ4CsP8VDAu4YZ1b5VQrofzGWA5VAvn4Y8RtotTZ5c6jyNkcsJX\n\
fwChOTeCnZ/CUXsUrppyzO06jMyiFdaPaoTSiVnnOGz1Z7DQcAL+HvHFSuSL\n\
Vng7ewvIZALtsIyspXhqJQOj5IWIVNz/Oayj6yh+kCp8zbAqt5CMFPY1zxBl\n\
Ih6iJlTM55CJO8HYT4Dxj2DJVIygW6xhzsxtIWQ6pfB4Lz17BGxIfK/ND/6m\n\
tRexbJf25Ih7wUZFPsmGbOD4SetsUqjvJlyP8SkpI83TL3pmFVL/6jXiknIa\n\
L7ZNwE/mqDSaBRcYjsWxtU2OfQNmyOc8+OtZOSqVHrLqCF45LcMGur9VZUXl\n\
DTU2dkxA7Yuia2IKa0/J0Thhx2m5AS+0jsGVZPNIBc7WYKZ4J5xHjpC7PAzv\n\
VRkJuQhz8S5EzEtEn2RkY0fhqS/FQu+YUO/MWUouc9YlIBW2+BC51Y2g0oDo\n\
0BXM7SgjpGz0/7sRd4aQGr8G28k2BNpPw3G8E1kKwb7aUng6+wtIpRZPYX7w\n\
fri1r8Kj3UC28SjiUSfC1jK4Na/ArX6OkPob+b4MvFpCL+aEV/UwbMon4dH9\n\
BQ7lb7FgbSSktiHgvr0KqY4CUuziAJgv6gglA5gTTyHWVw6maR2SegWWJyoR\n\
HWgU3cznW5EymgidKTCnNohbOikqkFDd+DpSymkLXmoZwgtNxBXMTMFGiq8a\n\
BQ/oWwrhUK8Wxd1qNE26EeMnkWaS6ODJldqCkj49dnUpCREFeueXcGHciJ2U\n\
mdTfMmDnFS16LSH+le9qm3KdvkEapCQlGuVrCFHuuQRHyX7YSw/DsncvfH3j\n\
WHYYYSspgaOavOP+A4g5F+E7WkL9OYCYrBvW0go4qyvg7rhKgcwPx/59sJdX\n\
wfKfD+Ef1FOfJHJWVgJ7VTXmt74Db5esgBSb1sM28nswS2NkPy3kvR6jzueG\n\
T7cesbAJMVcFLGNvU25rgmvsN3SfGsHZrXAZPkY6Ng3P5O+IU15CYGYjrOMb\n\
kGS0cBMr9jtld5DyDyJy9SQyE9WI9IjLtljnZYTP7kNGWUVBXizCE+/ahtQ0\n\
j5QRkeaNwrDq8mglEpM3v4rUdzFKSK050o/3++cgDSHgNsWZv18WUpP87vQj\n\
lC7u7BO3bzon11Ho8UhO9cfwN5OGD5JHUI6CGRkGMzpOMWJZ9HAp4vxLwcIo\n\
OpdKYIWRZrGxaXiqPkRwTvQE2XBQuFe6Uxz0TUTJW4WKCvuprBADIOcbIg/o\n\
ab+WzyyS/vNEzJ+CQ7WeHJNa2AIk6iyDc/I5OFVPI+wfpyBehfmB78E1VUZ9\n\
zQ+/8XU4xp+F11QuZCNRZxW8hvfp/mfg1BYjk04W9B4YRuR6M1lDNaI3xZ0Y\n\
uCU5wq0fkd4rEemXLOQSWcj0LGXTZmEqu6j38m9ayD0wu30ou2HEDHOn3Mus\n\
cwHNE07eQgplARLE5NyMSBLlRhu6ZoKS4r+NuGoQnlOn4Glupk8TPK0dyCSW\n\
78zHyoIZoNhOuXZ+MVRSM4rwpFECH8iXPSv8cUn49K9Ts5G7rX0v/HQ2jlyY\n\
YlwmLZ3jkysWGU09Qs1vI226iPCnzyKp7UbswsuI3mrHsqoGgYqfI6Fsp3Mv\n\
IdT0NpKDBxCseBDxwUZEWp5GQjck6amm8BCUZqXDQkXWPJlAcgrs4AtgR96i\n\
4wZyXFYpmotSpFW1CJ58TZx85pYj3neQWr0oDKfyU7EyhgtIqdqQsQ4hretA\n\
QlaPzPwwUooGJBTt4NIrkhQfCIfvCy+cETGisLFyZAI590XKDEkHIXKrCaLr\n\
LPm5qFm8Th0ASecP80LFLeJyZL7crPNz5Pw6Up8auRAdJbKJlBXcbBtyi3Jw\n\
mvfA6qUlmKFxcPaLdLTmx/Ny5C5Cx9chPW+U+pMkKPXXzCw42ePI8VtUp43g\n\
hn4NzrAXubEnwfX/DAh7SfAa+v4QP5UfOd2fwCmLhVUAIr+9D5xqKzjzbTpu\n\
Bqv4EOzEP5G98gBYYzXYL3eIHSKuBzuwDuzYHmSvPwh2qpGeqhfZW2tJ8kPI\n\
3ngC3OJUgeMJU12IIrCR8DdEXiaRb68hkfnybcPgBp8UFbN4gcR/TdhkI2dY\n\
TyJTSukdQ07xC3rEJwiS1B2RJ7eDswyCGyOj0zeTKH0k6uOUTBHTkO0QFWmp\n\
oEcRV8jk7LX0OA1gVdSDxj9CLjACzlTGr8Aveu5u4pFGhbp1pDHLJ6SZ1+jz\n\
IolHeWjajdzo88jN/I+0TJ1Rs4+0+g5peWyVeMXgbOPUzJdgNeRuxoqR7X0Y\n\
3EIviblVFMlK4qmrxe8LbWCnT4JTbyaNvgjWcATszUdIs0e+Kh5Rn2UzuJv3\n\
IjddS5xjHjn1y9SMhpo/Bk6+CfC2EMDvUs9UgespQs7cjZyjikQ8wGPyg4KE\n\
26iXTYKbOyhgmrOfphbX0k8NIdt9HynpEHK+AWT711AvbaJrD4HVHadzRB8H\n\
NiJnO0/n/gjONfYNCVc8hMkOUsybdNslwrCJcHqePs/S92HkPPXU3CXhrSWn\n\
fQu5oIuUSsHWWMdjX5CQ75WWUX5HdnDzjfST1Iv9M3zYoFYvk+QtZBhEDEME\n\
pfEo2Rk9KGOV9NkDTlcJziPUI8xLWC91Tk7zb3BWYVu4ok1fvYR0ULCTVZdE\n\
MllU9K3/Az2n7DY="]], ",", 
             GraphicsBox[{{}, {
                InsetBox[
                 StyleBox[
                 "\"peach\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.25], FontWeight -> Plain, 
                  FontSlant -> Plain, FontTracking -> "Plain", FontColor -> 
                  RGBColor[0.368417, 0.506779, 0.709798]], {0, 0}], 
                InsetBox[
                 StyleBox[
                 "\"peaches\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.1510989010989011], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[0.880722, 0.611041, 0.142051]], {-0.5, -41.5}], 
                InsetBox[
                 StyleBox[
                 "\"nectarines\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.07574568288854003], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[0.922526, 0.385626, 0.209179]], {-0.5, 30.5}], 
                InsetBox[
                 StyleBox[
                 "\"fruit\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.08751962323390895], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[0.560181, 0.691569, 0.194885]], {-0.5, 49.5}], 
                InsetBox[
                 StyleBox[
                 "\"temperatures\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.04277864992150706], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[
                   0.8878600487784333, 0.33792799024431336`, 
                    0.2577332520359445]], {-0.5, -61.5}], 
                InsetBox[
                 StyleBox[
                 "\"cultivars\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.05690737833594976], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[0.647624, 0.37816, 0.614037]], {-52.5, 44.5}], 
                InsetBox[
                 StyleBox[
                 "\"trees\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.07574568288854003], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[0.528488, 0.470624, 0.701351]], {47.5, 45.5}], 
                InsetBox[
                 StyleBox[
                 "\"nectarine\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.049843014128728415`], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[
                   0.5833680111493557, 0.4126186601628758, 
                    0.8290799721266107]], {-0.5, 69.5}], 
                InsetBox[
                 StyleBox[
                 "\"cultivation\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.045133437990580845`], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[
                   0.6753413537738198, 0.3589675436319385, 
                    0.5991466155654507]], {4.5, -75.5}], 
                InsetBox[
                 StyleBox[
                 "\"yellow\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.05690737833594976], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[0.571589, 0.586483, 0.]], {-54.5, 60.5}], 
                InsetBox[
                 StyleBox[
                 "\"Chinese\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.049843014128728415`], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[
                   0.28026441037696703`, 0.715, 0.4292089322474965]], {56.5, 
                 58.5}], 
                InsetBox[
                 StyleBox[
                 "\"China\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.05690737833594976], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> RGBColor[1, 0.75, 0]], {3.5, 84.5}], 
                InsetBox[
                 StyleBox[
                 "\"persica\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.05219780219780219], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[
                   0.9728288904374106, 0.621644452187053, 
                    0.07336199581899142]], {61.5, -64.5}], 
                InsetBox[
                 StyleBox[
                 "\"clingstone\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.04042386185243328], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[
                   0.9637822400302223, 0.5764112001511111, 
                    0.0977879519184]], {-78.5, 28.5}], 
                InsetBox[
                 StyleBox[
                 "\"including\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.04277864992150706], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[
                   0.16397784358994957`, 0.7038177251280403, 
                    0.6117734123079395]], {-0.5, -88.5}], 
                InsetBox[
                 StyleBox[
                 "\"cultivated\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.04042386185243328], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[
                   0.7132613816472081, 0.358, 
                    0.5392132590042952]], {-51.5, -75.5}], 
                InsetBox[
                 StyleBox[
                 "\"flesh\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.059262166405023554`], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[0.363898, 0.618501, 0.782349]], {48.5, 74.5}], 
                InsetBox[
                 StyleBox[
                 "\"commercial\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.0380690737833595], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[
                   0.8745421494417032, 0.39318677583744527`, 
                    0.11135537360425793`]], {-48.5, 80.5}], 
                InsetBox[
                 StyleBox[
                 "\"different\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.04277864992150706], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[
                   0.9874666782805795, 0.6948333914028977, 
                    0.033839968642435214`]], {92.5, 28.5}], 
                InsetBox[
                 StyleBox[
                 "\"produced\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.0380690737833595], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[
                   0.5750747800184488, 0.4174563783225715, 
                    0.8498130499538777]], {57.5, -78.5}], 
                InsetBox[
                 StyleBox[
                 "\"European\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.0380690737833595], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[
                   0.9930578157165594, 0.7227890785827968, 
                    0.01874389756528967]], {10.5, 98.5}], 
                InsetBox[
                 StyleBox[
                 "\"century\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.045133437990580845`], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[
                   0.9324333565611593, 0.5282889043741062, 
                    0.0921900209050434]], {-48.5, -88.5}], 
                InsetBox[
                 StyleBox[
                 "\"paintings\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.04042386185243328], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[
                   0.428777913273419, 0.5052332520359486, 
                    0.85]], {-0.5, -102.5}], 
                InsetBox[
                 StyleBox[
                 "\"Prunus\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.04748822605965463], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[
                   0.8439466852489265, 0.3467106629502147, 
                    0.3309221912517893]], {-41.5, 92.5}], 
                InsetBox[
                 StyleBox[
                 "\"tree\"", StripOnInput -> False, FontFamily -> "Helvetica",
                   FontSize -> Scaled[0.0663265306122449], FontWeight -> 
                  Plain, FontSlant -> Plain, FontTracking -> "Plain", 
                  FontColor -> RGBColor[0.772079, 0.431554, 0.102387]], {
                 95.5, -29.5}], 
                InsetBox[
                 StyleBox[
                 "\"Common\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.0380690737833595], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[0.5019668524892619, 0.46131988850644284`, 0.85]], {
                 95.5, 41.5}], 
                InsetBox[
                 StyleBox[
                 "\"breeding\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.0380690737833595], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[
                   0.3103557220216354, 0.5867154223826917, 
                    0.7874268664259625]], {46.5, -91.5}], 
                InsetBox[
                 StyleBox[
                 "\"example\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.04042386185243328], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[0.5472001045252132, 0.43417993728487203`, 0.85]], {
                 57.5, 89.5}], 
                InsetBox[
                 StyleBox[
                 "\"white\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.049843014128728415`], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[
                   0.8996399512215667, 0.7463488834690629, 
                    0.]], {-99.5, -43.5}], 
                InsetBox[
                 StyleBox[
                 "\"wood\"", StripOnInput -> False, FontFamily -> "Helvetica",
                   FontSize -> Scaled[0.05219780219780219], FontWeight -> 
                  Plain, FontSlant -> Plain, FontTracking -> "Plain", 
                  FontColor -> 
                  RGBColor[0.736782672705901, 0.358, 0.5030266573755369]], {
                 99.5, -44.5}], 
                InsetBox[
                 StyleBox[
                 "\"typically\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.04042386185243328], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[
                   0.2187618985811806, 0.715, 0.5074848563512248]], {-6.5, 
                 109.5}], 
                InsetBox[
                 StyleBox[
                 "\"Europe\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.04277864992150706], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[
                   0.7748409210981391, 0.358, 
                    0.4444755060028629]], {-45.5, -101.5}], 
                InsetBox[
                 StyleBox[
                 "\"related\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.045133437990580845`], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[
                   0.8857244243136628, 0.3764133635295058, 
                    0.1393110607841571]], {88.5, 70.5}], 
                InsetBox[
                 StyleBox[
                 "\"California\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.03571428571428571], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[0.6672593867853922, 0.7205288207539324, 0.]], {
                 38.5, 107.5}], 
                InsetBox[
                 StyleBox[
                 "\"Genome\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.0380690737833595], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[
                   0.8781534541180211, 0.4921023027453475, 
                    0.04333810870621905]], {45.5, -105.5}], 
                InsetBox[
                 StyleBox[
                 "\"early\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.05219780219780219], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[
                   0.40082222609352647`, 0.5220066643438841, 0.85]], {-100.5, 
                 44.5}], 
                InsetBox[
                 StyleBox[
                 "\"Ancient\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.04042386185243328], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[
                   0.35558897405758294`, 0.5505288207539337, 
                    0.8417067688690995]], {-49.5, 105.5}], 
                InsetBox[
                 StyleBox[
                 "\"blossoms\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.03571428571428571], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[
                   0.9986489531525362, 0.7507447657626809, 
                    0.0036478264881522893`]], {-86.5, 89.5}], 
                InsetBox[
                 StyleBox[
                 "\"fruits\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.049843014128728415`], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[
                   0.838355547812947, 0.44746667828057946`, 
                    0.0208888695323676]], {-95.5, 58.5}], 
                InsetBox[
                 StyleBox[
                 "\"States\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.045133437990580845`], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[
                   0.47401116530937026`, 0.47809330081437784`, 
                    0.85]], {-100.5, -56.5}], 
                InsetBox[
                 StyleBox[
                 "\"species\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.0380690737833595], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[
                   0.922066817647527, 0.5213778784316846, 
                    0.08286013588277422]], {-98.5, -69.5}], 
                InsetBox[
                 StyleBox[
                 "\"genetic\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.04042386185243328], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[
                   0.23716678280579248`, 0.645266573755366, 
                    0.699600139366951]], {-98.5, 74.5}], 
                InsetBox[
                 StyleBox[
                 "\"flowers\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.04042386185243328], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[
                   0.9810598048862722, 0.7553955338762525, 
                    0.]], {-90.5, -87.5}], 
                InsetBox[
                 StyleBox[
                 "\"activities\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.03571428571428571], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[0.7989994773739094, 0.735166608597101, 0.]], {
                 90.5, -89.5}], 
                InsetBox[
                 StyleBox[
                 "\"climates\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.03571428571428571], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[
                   0.9107287510704583, 0.33890687339431275`, 
                    0.20182187767614543`]], {-60.5, -113.5}], 
                InsetBox[
                 StyleBox[
                 "\"varieties\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.0380690737833595], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[0.4567336004533182, 0.4884598397280091, 0.85]], {
                 84.5, 101.5}], 
                InsetBox[
                 StyleBox[
                 "\"fleshed\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.0380690737833595], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[
                   0.7896667828057927, 0.3575666434388414, 
                    0.4213886953236787]], {100.5, 83.5}], 
                InsetBox[
                 StyleBox[
                 "\"spring\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.04277864992150706], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[0.7678998606330495, 0.7317110956258943, 0.]], {
                 101.5, 53.5}], 
                InsetBox[
                 StyleBox[
                 "\"usually\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.0380690737833595], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[
                   0.8926354502560807, 0.366046824615879, 
                    0.15658862564020168`]], {87.5, -101.5}], 
                InsetBox[
                 StyleBox[
                 "\"chilling\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.0380690737833595], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[
                   0.6897400905885174, 0.358, 0.5753998606330502]], {-89.5, 
                 101.5}], 
                InsetBox[
                 StyleBox[
                 "\"skin\"", StripOnInput -> False, FontFamily -> "Helvetica",
                   FontSize -> Scaled[0.054552590266875985`], FontWeight -> 
                  Plain, FontSlant -> Plain, FontTracking -> "Plain", 
                  FontColor -> RGBColor[0.915, 0.3325, 0.2125]], {
                 101.5, -61.5}], 
                InsetBox[
                 StyleBox[
                 "\"blossom\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.03571428571428571], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[
                   0.529922539669161, 0.44454647619850335`, 
                    0.85]], {-86.5, -100.5}], 
                InsetBox[
                 StyleBox[
                 "\"believed\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.03571428571428571], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[
                   0.8633598745697435, 0.40996018814538476`, 
                    0.08339968642435877]], {80.5, 112.5}], 
                InsetBox[
                 StyleBox[
                 "\"protect\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.0380690737833595], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[
                   0.9307395679624266, 0.7498043964402695, 0.]], {-89.5, 
                 112.5}], 
                InsetBox[
                 StyleBox[
                 "\"grown\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.04042386185243328], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[
                   0.9052934053395919, 0.510195603559728, 
                    0.06776406480563275]], {-98.5, -111.5}], 
                InsetBox[
                 StyleBox[
                 "\"leaves\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.04277864992150706], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[
                   0.8613800418100862, 0.48092002787339083`, 
                    0.02824203762907758]], {110.5, 0.5}], 
                InsetBox[
                 StyleBox[
                 "\"brought\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.03571428571428571], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[
                   0.8064401951137368, 0.3542119609772526, 
                    0.39343300814377197`]], {110.5, 12.5}], 
                InsetBox[
                 StyleBox[
                 "\"used\"", StripOnInput -> False, FontFamily -> "Helvetica",
                   FontSize -> Scaled[0.04748822605965463], FontWeight -> 
                  Plain, FontSlant -> Plain, FontTracking -> "Plain", 
                  FontColor -> 
                  RGBColor[
                   0.28240003484173815`, 0.6090799721266095, 
                    0.7538800418100857]], {107.5, -13.5}], 
                InsetBox[
                 StyleBox[
                 "\"period\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.04042386185243328], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[
                   0.9784200278733908, 0.649600139366954, 
                    0.058265924741844846`]], {-111.5, 0.5}], 
                InsetBox[
                 StyleBox[
                 "\"bruised\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.03571428571428571], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[
                   0.8949268664259606, 0.5032845776173072, 
                    0.05843417978336459]], {-112.5, 12.5}], 
                InsetBox[
                 StyleBox[
                 "\"appear\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.03571428571428571], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[
                   0.7042770479220728, 0.358, 
                    0.5530353108891188]], {-112.5, -12.5}], 
                InsetBox[
                 StyleBox[
                 "\"almond\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.03571428571428571], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[
                   0.9603267270590103, 0.5591336352950514, 
                    0.10711783694067224`]], {-112.5, -26.5}], 
                InsetBox[
                 StyleBox[
                 "\"flower\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.0380690737833595], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[
                   0.19193353076984873`, 0.681453175384121, 
                    0.6453202369238185]], {4.5, -115.5}], 
                InsetBox[
                 StyleBox[
                 "\"New\"", StripOnInput -> False, FontFamily -> "Helvetica", 
                  FontSize -> Scaled[0.045133437990580845`], FontWeight -> 
                  Plain, FontSlant -> Plain, FontTracking -> "Plain", 
                  FontColor -> 
                  RGBColor[
                   0.5407932311309059, 0.715, 0.09762679674248334]], {-2.5, 
                 121.5}], 
                InsetBox[
                 StyleBox[
                 "\"branch\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.0380690737833595], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[
                   0.8607200975568693, 0.34335598048862614`, 
                    0.30296650407188447`]], {30.5, 119.5}], 
                InsetBox[
                 StyleBox[
                 "\"Persia\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.0380690737833595], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[
                   0.31827505306025683`, 0.715, 0.3808317506505822]], {
                 37.5, -118.5}], 
                InsetBox[
                 StyleBox[
                 "\"United\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.0380690737833595], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[
                   0.5788038738141875, 0.715, 0.049249615145579635`]], {-33.5,
                  120.5}], 
                InsetBox[
                 StyleBox[
                 "\"good\"", StripOnInput -> False, FontFamily -> "Helvetica",
                   FontSize -> Scaled[0.0380690737833595], FontWeight -> 
                  Plain, FontSlant -> Plain, FontTracking -> "Plain", 
                  FontColor -> 
                  RGBColor[
                   0.6319174318193065, 0.38429816477207124`, 
                    0.7077064204517338]], {-24.5, -122.5}], 
                InsetBox[
                 StyleBox[
                 "\"north\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.04042386185243328], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[
                   0.9038177251280404, 0.3492734123079395, 
                    0.18454431282010084`]], {101.5, -75.5}], 
                InsetBox[
                 StyleBox[
                 "\"winter\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.0380690737833595], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[
                   0.9840111653093676, 0.677555826546838, 
                    0.04316985366470745]], {71.5, -118.5}], 
                InsetBox[
                 StyleBox[
                 "\"called\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.0380690737833595], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[
                   0.9492067688690977, 0.5394711792460651, 
                    0.10728609198218791`]], {-65.5, 123.5}], 
                InsetBox[
                 StyleBox[
                 "\"brown\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.03571428571428571], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[
                   0.2198892179497479, 0.6590886256402017, 
                    0.6788670615396974]], {-70.5, -123.5}], 
                InsetBox[
                 StyleBox[
                 "\"artists\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.03571428571428571], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[
                   0.4177882075393331, 0.715, 
                    0.25417864494993975`]], {-54.5, -61.5}], 
                InsetBox[
                 StyleBox[
                 "\"State\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.0380690737833595], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[
                   0.6670481226429111, 0.3638052617916352, 
                    0.6198796933927223]], {101.5, -116.5}], 
                InsetBox[
                 StyleBox[
                 "\"plant\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.0380690737833595], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[
                   0.845266573755366, 0.437100139366951, 
                    0.03816643438841502]], {113.5, 112.5}], 
                InsetBox[
                 StyleBox[
                 "\"plum\"", StripOnInput -> False, FontFamily -> "Helvetica",
                   FontSize -> Scaled[0.04042386185243328], FontWeight -> 
                  Plain, FontSlant -> Plain, FontTracking -> "Plain", 
                  FontColor -> 
                  RGBColor[
                   0.7513196300394465, 0.358, 0.48066210763162087`]], {-98.5, 
                 122.5}], 
                InsetBox[
                 StyleBox[
                 "\"moth\"", StripOnInput -> False, FontFamily -> "Helvetica",
                   FontSize -> Scaled[0.04042386185243328], FontWeight -> 
                  Plain, FontSlant -> Plain, FontTracking -> "Plain", 
                  FontColor -> 
                  RGBColor[
                   0.6361597700445392, 0.7170733077827265, 0.]], {-120.5, 
                 24.5}], 
                InsetBox[
                 StyleBox[
                 "\"health\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.0380690737833595], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[
                   0.9046334610863751, 0.334573307782725, 
                    0.22977756485604156`]], {4.5, -128.5}], 
                InsetBox[
                 StyleBox[
                 "\"season\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.0380690737833595], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[
                   0.8335801463353031, 0.3487839707329394, 
                    0.3481997561078282]], {18.5, 131.5}], 
                InsetBox[
                 StyleBox[
                 "\"large\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.0380690737833595], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[0.38354466123747527`, 0.5323732032575149, 0.85]], {
                 126.5, -26.5}], 
                InsetBox[
                 StyleBox[
                 "\"year\"", StripOnInput -> False, FontFamily -> "Helvetica",
                   FontSize -> Scaled[0.04042386185243328], FontWeight -> 
                  Plain, FontSlant -> Plain, FontTracking -> "Plain", 
                  FontColor -> 
                  RGBColor[
                   0.8342400905885153, 0.4628267270590103, 
                    0.0038160815296638794`]], {34.5, -130.5}], 
                InsetBox[
                 StyleBox[
                 "\"allele\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.03571428571428571], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[
                   0.3383114092015346, 0.5643508726387724, 
                    0.8209736910418415]], {-30.5, 131.5}], 
                InsetBox[
                 StyleBox[
                 "\"source\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.0380690737833595], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[
                   0.26512246998569167`, 0.6229020240114467, 
                    0.73314696398283]], {66.5, 124.5}], 
                InsetBox[
                 StyleBox[
                 "\"fuzz\"", StripOnInput -> False, FontFamily -> "Helvetica",
                   FontSize -> Scaled[0.04042386185243328], FontWeight -> 
                  Plain, FontSlant -> Plain, FontTracking -> "Plain", 
                  FontColor -> 
                  RGBColor[
                   0.8168067340273636, 0.3521386531945273, 
                    0.3761554432877274]], {-125.5, 54.5}], 
                InsetBox[
                 StyleBox[
                 "\"long\"", StripOnInput -> False, FontFamily -> "Helvetica",
                   FontSize -> Scaled[0.04042386185243328], FontWeight -> 
                  Plain, FontSlant -> Plain, FontTracking -> "Plain", 
                  FontColor -> 
                  RGBColor[
                   0.6536293927965667, 0.37163285420200276`, 
                    0.6534265180085832]], {128.5, 24.5}], 
                InsetBox[
                 StyleBox[
                 "\"due\"", StripOnInput -> False, FontFamily -> "Helvetica", 
                  FontSize -> Scaled[0.04042386185243328], FontWeight -> 
                  Plain, FontSlant -> Plain, FontTracking -> "Plain", 
                  FontColor -> 
                  RGBColor[
                   0.37977756485605163`, 0.715, 0.3025558265468435]], {120.5, 
                 63.5}], 
                InsetBox[
                 StyleBox[
                 "\"buds\"", StripOnInput -> False, FontFamily -> "Helvetica",
                   FontSize -> Scaled[0.03571428571428571], FontWeight -> 
                  Plain, FontSlant -> Plain, FontTracking -> "Plain", 
                  FontColor -> 
                  RGBColor[
                   0.6453361616656581, 0.37647057236169945`, 
                    0.6741595958358548]], {49.5, 133.5}], 
                InsetBox[
                 StyleBox[
                 "\"leaf\"", StripOnInput -> False, FontFamily -> "Helvetica",
                   FontSize -> Scaled[0.0380690737833595], FontWeight -> 
                  Plain, FontSlant -> Plain, FontTracking -> "Plain", 
                  FontColor -> 
                  RGBColor[
                   0.969373377466199, 0.6043668873309952, 
                    0.08269188084126262]], {128.5, 35.5}], 
                InsetBox[
                 StyleBox[
                 "\"Han\"", StripOnInput -> False, FontFamily -> "Helvetica", 
                  FontSize -> Scaled[0.0380690737833595], FontWeight -> Plain,
                   FontSlant -> Plain, FontTracking -> "Plain", FontColor -> 
                  RGBColor[0.7175796237092107, 0.7261199581899123, 0.]], {
                 128.5, -57.5}], 
                InsetBox[
                 StyleBox[
                 "\"acid\"", StripOnInput -> False, FontFamily -> "Helvetica",
                   FontSize -> Scaled[0.0380690737833595], FontWeight -> 
                  Plain, FontSlant -> Plain, FontTracking -> "Plain", 
                  FontColor -> 
                  RGBColor[
                   0.596786740995709, 0.404791067752503, 
                    0.7955331475107271]], {-49.5, -132.5}], 
                InsetBox[
                 StyleBox[
                 "\"evil\"", StripOnInput -> False, FontFamily -> "Helvetica",
                   FontSize -> Scaled[0.04042386185243328], FontWeight -> 
                  Plain, FontSlant -> Plain, FontTracking -> "Plain", 
                  FontColor -> 
                  RGBColor[
                   0.8564488486273256, 0.42032672705901153`, 
                    0.06612212156831418]], {-128.5, 34.5}], 
                InsetBox[
                 StyleBox[
                 "\"100\"", StripOnInput -> False, FontFamily -> "Helvetica", 
                  FontSize -> Scaled[0.03571428571428571], FontWeight -> 
                  Plain, FontSlant -> Plain, FontTracking -> "Plain", 
                  FontColor -> 
                  RGBColor[
                   0.7658565873730018, 0.358, 
                    0.4582975578876895]], {-128.5, -38.5}], 
                InsetBox[
                 StyleBox[
                 "\"red\"", StripOnInput -> False, FontFamily -> "Helvetica", 
                  FontSize -> Scaled[0.04277864992150706], FontWeight -> 
                  Plain, FontSlant -> Plain, FontTracking -> "Plain", 
                  FontColor -> 
                  RGBColor[
                   0.6184987019729621, 0.39212575718243875`, 
                    0.7412532450675947]], {128.5, -39.5}], 
                InsetBox[
                 StyleBox[
                 "\"BC\"", StripOnInput -> False, FontFamily -> "Helvetica", 
                  FontSize -> Scaled[0.0380690737833595], FontWeight -> Plain,
                   FontSlant -> Plain, FontTracking -> "Plain", FontColor -> 
                  RGBColor[0.8493197142977551, 0.7407577460330839, 0.]], {
                 127.5, 47.5}], 
                InsetBox[
                 StyleBox[
                 "\"AD\"", StripOnInput -> False, FontFamily -> "Helvetica", 
                  FontSize -> Scaled[0.03571428571428571], FontWeight -> 
                  Plain, FontSlant -> Plain, FontTracking -> "Plain", 
                  FontColor -> 
                  RGBColor[
                   0.8774935098648088, 0.34000129802703827`, 
                    0.2750108168919853]], {-128.5, -50.5}], 
                InsetBox[
                 StyleBox[
                 "\"28\"", StripOnInput -> False, FontFamily -> "Helvetica", 
                  FontSize -> Scaled[0.03571428571428571], FontWeight -> 
                  Plain, FontSlant -> Plain, FontTracking -> "Plain", 
                  FontColor -> 
                  RGBColor[
                   0.6102054708420535, 0.39696347534213544`, 
                    0.7619863228948663]], {131.5, -12.5}], 
                InsetBox[
                 StyleBox[
                 "\"16\"", StripOnInput -> False, FontFamily -> "Helvetica", 
                  FontSize -> Scaled[0.03571428571428571], FontWeight -> 
                  Plain, FontSlant -> Plain, FontTracking -> "Plain", 
                  FontColor -> 
                  RGBColor[
                   0.8510135028964549, 0.47400900193096995`, 
                    0.018912152606809424`]], {-127.5, -62.5}], 
                InsetBox[
                 StyleBox[
                 "\"life\"", StripOnInput -> False, FontFamily -> "Helvetica",
                   FontSize -> Scaled[0.0380690737833595], FontWeight -> 
                  Plain, FontSlant -> Plain, FontTracking -> "Plain", 
                  FontColor -> 
                  RGBColor[
                   0.7277983389807635, 0.358, 0.5168487092603637]], {-126.5, 
                 65.5}], 
                InsetBox[
                 StyleBox[
                 "\"cm\"", StripOnInput -> False, FontFamily -> "Helvetica", 
                  FontSize -> Scaled[0.0380690737833595], FontWeight -> Plain,
                   FontSlant -> Plain, FontTracking -> "Plain", FontColor -> 
                  RGBColor[
                   0.47929071933511125`, 0.715, 
                    0.1759027208462221]], {-19.5, -134.5}], 
                InsetBox[
                 StyleBox[
                 "\"15\"", StripOnInput -> False, FontFamily -> "Helvetica", 
                  FontSize -> Scaled[0.03571428571428571], FontWeight -> 
                  Plain, FontSlant -> Plain, FontTracking -> "Plain", 
                  FontColor -> 
                  RGBColor[
                   0.15725938678540247`, 0.715, 0.5857607804549424]], {
                 123.5, -70.5}]}}, 
              Method -> {
               "DefaultBoundaryStyle" -> Automatic, "DefaultPlotStyle" -> 
                Automatic}, PlotRange -> {{-139., 141.}, {-141., 141.}}, 
              ImageCache -> 
              GraphicsData[
               "CompressedBitmap", 
                "eJxsvAeYZFd1LTzPAgNOP+89Y+NIsI2NAw4YDMIGgZCQAAkkhBLKaTTS5Jxz\
\n6OmJPTPd02E655xzqE7VqTpUh6rqyjnnnGu9fUP3zIi/v6+6qs6999xz9lln\n\
7bX3ObeeeXv/h+/veHv/tnff/vJP9r69+8Nt7+778pO79lLRI/9ry5YtfnoF\n\
vryF+Qz6yP/zg/7o4ENv77BvjyCdTiKdAfvtKnfoLfbtD+lfBjJ9CfIn38Rd\n\
4XtYcqxCbmrAgKqbPX9eWwCRXUufIuhf3gdFwLXlr/lqo+tNUN/4Ljzr4i3v\n\
ctU+wR9iqk0k0pvfmP8p7vtDZex5sRT77Q/4JoUC87gy9AwWbKuQ6vJxfXI3\n\
BiXnUSbOZS/uX92PHt0KXRpEieAHmHOZ+CZ9CqmgCZ6R41Bc/xUS8fTmraNh\n\
ZPhb/w5/ajoW22gOMhm8yHXgx+zb/0bCG8bwLRlarsowVKFFV44cWl0EKx06\n\
NGVJ0HpTCbMxBmmvDpLVEBLBKIZvy9B8VYruXAVEg84tv893yGFrwXXhIcTZ\n\
JqThDOohXL+AypUC9u6Da0fQb5CwHSof+zFEbvOWL/HtSAfWIDv8h3BLpOy5\n\
6YABpsrnobz5E6huP4uAQYlMwgdL7ctQXn8C+sqPYKx6BcbOfNgHL9Jxy5YX\n\
Hu6aecqCmjMyuO0RiBtUqM6WQzFlRdUpCUz6MBZrVejI12KsQIKpUR9WmxSo\n\
v66GyxzG6K01dBTqN7vmcfUha/QNuJP0PenApKoVo7JzKJy/wja3T7wdrapJ\n\
+hRF6ehTWPbaN7vmn7iItd2fg6Yumz3X0fwaVEXbELVp4e7fA03JaURUbZCd\n\
/h8EzUr4pq9BevSP4FWukQlegFuq/mTXgno/2i+uoOuuCqP35Gi/p8FKnx7d\n\
RQZuoJMp+BxRTDBdE3gxc0+C+cUQe4gxS/+9+13LpPxonn0Bd6Z3oWzqVeSK\n\
siBUXMWJ3h+jVHQAWYOP4croSyiZfRvZgpfgiEd5GP4fGqYwDPk/gLH5IpTZ\n\
jyHi8cFw55vUpR1wjhXAMXILlv5y6qoIykvfgKHhJNzTRVDd+FeE3E6Yq1+m\n\
WaX9RO/SsThWRq3QS/xYbFSj+a4a0mETGq+qWHSHTAGIBXYaOCmmx7wQlUsx\n\
3OVie6cgnPZQ77hJ9vtIJj1YMXVCZByEPxFFKGqByauAxNIPuVMCZ0CBRUMH\n\
dH4dP2P+jKwXRUIqRTpJEzmTQEIpJSvRx5ALkZFOhAWDSHqCHE4tSoQHWhEV\n\
ryKhWEFcqUTSqKYJGkPabUBUNImE1YCEgRuZTNiDhN5A85KzYNIqgPzsf5Ll\n\
3DDmfRf2qSGYSr8PdfEHcM/Ww965C7Iz30csFIFvrhxOYQWsbfuwfuGrCLkc\n\
dO4zsM/MfsKCqXAETedW0FuiRc9VgnKFgewdRvOZZXTmq9B4VIyhejOExWTB\n\
ST/ccieqDyyiO1+Bsj0idJcZGTtQXX+OjF8Dx7uvIu6OgP7Bve9NxM1m+C68\n\
B1f2GXhvHobjyGGyiAuewy/CfT2byo7D9pvH4e8ZgC/3MMJLWoSqzsG+fz9C\n\
PYVwXMxmRzIl74cj6xoyaXAU9sdwtb0GRcEO1ljegY+gLNgJz+gpKC79EJ6l\n\
NphKniDjnKYuOqDJ/idYRirhn8uD/Nw/Iuzxwlz8PUhP/gvsk70M3T3PGebf\n\
eYJMp1NIcfTMDwHdl8rCiST77fd4A8bcUahmHFAsehAKsbyNKBlgfcIO5aIX\n\
8UQGNokbFnOcPebRBaBa8EDcokVfiZ7p3JYvbhgwoIVz2+u8AT3wHP0QkalO\n\
2D98C1GZEgm1FP6qe4jp9HDv/gUCQxNI6iRwHXoJMYsL/rtHEBZrESzNQnCI\n\
YDZfTwa8whlQOQjnlRzGgBx6v8Ayr2e8AF75Etu0lEcKW3cxkokYfMKb0N59\n\
HqbWa4gHwly3VIMwlLwCbf6v4JofparS8M5UwDF0Faamq2QybOGt+K/s2xcR\n\
9LtxcnQUuwUT+IhaO+cJQ2rWoWBNz1aptRmwc3CEXgJcWVGyDsHtseHYxDx8\n\
ZLl+yRLuyLgJ0bm6hDFngG129cICZNH4Z/iBWahVYH42wH77Hb7MOmfDUJXh\n\
gTJmGDPwaNzQz1vhsoT/zyft7qexTQfhOb4NIUEDbK/9FJ5rBNwbJ+HY8xpC\n\
i1rEF3vhuXQInitHaFyeQcxs5+y+rEewIpvsvkx2ryO7X+OmvVawYfdtD9vG\n\
4zTjlc5+8tZ+jEqXsXNchD65BIenZAwv42jfAMqUJljIhtu7ezFG03JGsYz/\n\
qGzBtMuLI92deK5/CoyIKJwcRq3RzQwizvX2Q+gJb9gmGogjGk0/ZJtkLEmi\n\
IvlA2adhHJej+cAIBHdFaD0mgEriJ3jzBiL/bH/7afhauskAA3C8/wbiWhmc\n\
O19BaHIOcfEQ7FtfYEEYariBQI8AccUCHf8lokYb/PnH6LxF+G4ehK+qA7Gp\n\
etjeeRmRRTHCdRfhuHSNmYKfMJDTYcTF2UXOT0Xc+EggRM3KMk7PKagghm3d\n\
I1CEEuzhOtEEC5QC4TiOjgtxaVpEIJrAwf5RSP1R8lejaLH4WPBc7h/EtCfM\n\
de5f4TM4IBvVw7TmwNy9OYzcW2erDJo8kPSrsC40I8YpFQTIxpJ+JeTkGjfK\n\
/HoXJINqGNaccNDs5nUlazTHe8/AdW4/nEe3wlfdwuAP8eUBuE9vh+v0LgQH\n\
hey58eURuM/sonN3w1tSjHQiQUY7AV9dJZzbn4HjKNFhXxns7xNtntsD57GP\n\
EVla3/LRb0Nqa/8INOEYaVgF3huZQqdsFb/pnYAhGMCRvn40GJzk62I4PTSI\n\
MpkcHw5NYsmox1N1DbgoVqJ9eRb56yaUCkdwSqxCMBbGnq4+zHjDG3CwzKnR\n\
cnAYgnwRGrb3YLhCgRANfcvBAYyWrWDwgoAk4jp8OgeVDWKsfAUD56msSs6W\n\
Ne8fhKBYjJ7jQ6g7Q/BJ8hZjHMj7ryDujSCTTD0oiTM8FXNo/QOuLMnRLQN6\n\
3829nO+ovo6gYA2J2So4LlxhUEUeOfPxw3byuSx4rb0TO4fH8E7vIFoNdqyZ\n\
NXizqx+7JxYwqVVje98QdgwO4/jsChZ0WmTNLSNG/v7g8Ah6bAFozHrcXpCg\n\
RSzCe0RfuweG8PGYCO5E+vO8nRiwzdwew5zAwTZT3iTGaLkMij4J+u5y8jVJ\n\
7rz1yCgmS+cxWChjyxJuvqxkHn15axzy5Aa0ZIkQS/C2inkRbG1EKpLgFMxn\n\
2dtFJ/vI53qQ9jlJcsWQ0i8hODzO4G77gzb4UzjsBpyZEsEZDsEejnJkRQ4u\n\
mUrBG4mw38MUJei8BGnmhnQsmuRGKp7gwycalhiVJWgk0nSd1R9AJJnmeeNP\n\
2BZNkwGWl9j4C+ZxJSYqpFjvXoOgTMn1JBFGz1EBhvPnMF6l4stC6D46QmWz\n\
mKjTcPe02tB2bZ4xwN9tUFsighQfxX2aLwvHg4inHoyzPkXNiyGZ4U5MZzJ/\n\
snEwRS45ydpzy38+aJxH4CfOrZNrWe/8NbbsC5A2zaP1kggWkkDDF0YwWLIO\n\
x6oedQcEMKq80A5J0XR8CqoxJRoOjcGk9kIzKEHTCaZMgYbDY9BJnFiuoFlz\n\
lkX9lr/i7xeJGXFjoQSOZIpv9RdoIIIoW87DYeFFemUR5xtJaHpRulQGJyE/\n\
kXDj5vxVHJvKxhHhJUy5tBhUNqHPLMGSeRAHJs7i7NxN5C7m4MpiI8id8krm\n\
T5Gx1CM1c5KziPQQUmuV3OfVU0ib55CWnEPaOMeVUWCWNhMNO7qRGvwZMi4r\n\
MuZapIaeQmr4p0it5JEpI0ivnCTYeXgFteVlvhuMwpwrEaH36jSGbomwPGRm\n\
cbHeKUF3lhC92dNQS30slmQda5tlGhlXJmlbQffFKfRfGkNz1vxDZgtGFNg+\n\
dAymxIbZ/hgLmlpsF96CKezCnL4N2UstpOVtODt6EmaCr9E2jHML1XBGfBha\n\
L8S++UoUL95EhWIAV+YuoFg5RzhWYL9gLyrUC5/mLZYW/RrJpr9CxmunXv8T\n\
kl0/Z9k8JXweaVUnUtMvIy3v5CwmegNp9RAyivNIzZ2mOESDVN83yKJiZHwr\n\
SE2+hYxjnd5fQtph5Uflj5EIBKEdlUDStQzNtA7RCEdwIZMDhkUDIv4w9BMy\n\
qMZV8OidMC4ZEQnFYF2gWNQaYpgOllkF5AMS2NUeTpdv+RN+FlDMj9h6B0Kz\n\
ZYiq5x/jbcjPC/bbhj5IJe6nRx4qe+i8T7HCMkbzsuUyS0xc8ReJNkKQ+nxU\n\
dZpCJwcidF4o7EebUoI6lQLGaJwnsRTWHDZ4KHxK0lyeczoZlLJ/JrJzg0KK\n\
boMR4RSTOwljxetjmsCN9J8jFFFh98hRrPnt8EQ8CMQ5FmtYzsHbgpO4vXQP\n\
ueIi5C03wRE249LEOViSGaSSAUzrBpA1k4UdgkOo1k6jUnwLlepxjGiasGvs\n\
DHKXK7Bn/CQ6TMpP8b1CgkZ+/Aka/V8R1nPp/RUkBb9Exm1CevYVGnGaH7Ov\n\
I63s5VAw/y7SmhFklJeQkpaTypxFsu2LNO8OECoOIjV1CBnrHCHnTaRdzkd4\n\
zkwF/Bg/1YCeEz2YrxJi6FgjBq9MIknyev5aBwavj2O1QoDe491YqJxE984q\n\
9F4Zh31dg9Z3qqAmGaNsnkDviU72eOfuJuhk7i8+CIZPIzy8B/abP4Gv5ywc\n\
N/4NgTkBH8d9iWXkmLCbzulByh+i6NREkaqNf7fSS8aWIxlCXLXOIijtMFC5\n\
g9ySD9HRNkQmx5GQk8eUrCDtsSBK0Wo6TiGVUYpwbwMiczOcb4562fND3Y2k\n\
KI000Ti0JQMBrAkMTHpiywasVHTtRzPTSBBvHx6g3nnd2DfUhh3TQlycGcJz\n\
I6Nw0QwPByx4tKkKteQHFfoV/HtzHdbCSXi8Jvyqrx3nl0SEm04cWZJA71Lh\n\
1YlpxDKbsApHNdg2sBX7J7PIQV7Cx4IjaDHJMCovxUfCG1jzqiBQN+D14bMw\n\
hy04PXoAYgq6vf4FvN63C52GOSxaZ6AKWlAlvoky9RQsFFoN6qew6ljCYYJV\n\
s2F9A1YZdy9B6X1kDNVItnweKXEh0uL9RCZNBBOChppGYe4lotkyDlazr1KZ\n\
ABlVNlKSclLGSiQ7/wZpXT8yzhGkev6djvcRuRBM9csbsPJKaC4d6QU/8yjY\n\
c6J7H8WHjhBENwdgILpVlA9iOFcIl86F5btdEA1o4FepMZw9RYMdxuChOoh7\n\
lXDrnJC3z1HMa30IVp9BQi8kGdaOqHyIZMdxuCoPkQyxIWGW3U8z+tQITRcg\n\
KCxBwuXcUHRJcjsJp51tXMJAePdyeZqUe50EEVeeCRkQN80zvMNd9hXmBITL\n\
jpFyPgDfrX1wXTmPcFshvEVNiA6XwHu3FsGCHQjNk6r3SeE8tY/UNQWz3bnw\n\
FjYh0n4ZzhOHEai5Dcc734evrZOuvwrHkaMUwszCfeQVBBqL4Tn9NvxtPQg3\n\
noXr4imEOu7B8fGHpN/CW/6CH0q1aR275mZZgJ4W9KFTtYLfjAoQZaVSHPuH\n\
WtFi82NBvYT/bqnGZdk6ylYm8N2WOtQabOiTTOPV8XGse1wQm9UoWFmDwq7E\n\
W8LZBwEaohHfNXIckoALPpo/84Y2vCvIgt6vwsnx47g0fxdHxg7irnyCaNWN\n\
o0Pb8Q6dX0du6tDYCdwRl+PAyF60mhZQvXIHFZo5SI2dFF8dReFKKT4YPoox\n\
h4UD6J8R131MALxKQFMg2fh5AtU8YG8gLtxL3EV8p+kjrvsNku3fItC9Te//\n\
QWUMqP8DyZ6fIOOxIr28A8nB5+n4q0gOv4hM2I30xA+R7PhHpNdqeWwQ+cVj\n\
CLkC8CgtUA+tYOxMCzqOEhUlUhDlDEC74kGCkDtfOIzJ28Po21fNojSg0WL4\n\
yhTSsSAG91Zi8Hw/ZvJHMXS8EZO1kodQ+heILt6A/dp34an7APbsr8JVf5aI\n\
rAWuiu2sS8uElHDlfRvOsg/hbXgD9ttPI+5h5EgYrpyvwVV3mVxXAM6rfwlX\n\
y10WmmHBAXhGOjj4SovgKPoZkz/asonTpAuu3e+QOGfSFFFExgYRbsmDr7yV\n\
CLAcvnsNCN7bi9ASBbc+GeH5MIfTvgL4yloQab5AuLuA2LIQnpMvIrKuQ7jh\n\
PAKjq4gNFcF54EPEFicRGahCsKsJCeUSfZ8mnObD8cGLiDv8mzjVmeXYIyKV\n\
RzdgcNouF+P9SSG/IJBB1kQXKnQ23JwbwdU1JjMxRADrQb1kFscoZK8WC/Gj\n\
nnacmBPiyNQwXhjsx6xlHW9Mzj7sn5XYMXwE0qCbokg/5vWteINI00OqhlFk\n\
U6YZLBL/JlmbJ2DyW6Bwy6ALOuEOGzFGLLDgVLOqQ+FchsxnY6e70i3BmHGa\n\
JIaZObaBU/ilyES4UzKeZbBhZTpEik1Oepf8sM9I99XRdyWRbTspMAmNCgU3\n\
olfJF++n86NMWEU+uQ8ZI72iQdYaCKqIpOeIXBWbOM0kYljK60XrxzUYPNsD\n\
Ud0CvI4o4qR6BKfasEKYdEvXMZY/zSq1uSutmO1ch2mSot6jfQhQhLuQ00VR\n\
3wLcWhtGjzRgaUjH4/QL7NtfMqiCO/9b8C+MsiMTEZ6Eq/ow4uoOuKv3sGXx\n\
tbuw33kWKT4W9pU+Ct/0CNLOWTiy/xr24ncQU47BcflLsN97iyIIqmfiKLyj\n\
3HJWQlYKZ8nzDFbvQ5Xsv/c9YtoAd4pKjkjH3d+CalBEUI1o4DpziMn9ITpY\n\
DO+9ZqRsCgRrCLaF5+H48HEWqpGWyyxU44J7sH/wHPx19+DN2g5X9jHSGaTG\n\
974Of1kewtNk6GSGDZ7ZEJok5LhchNfHR6Hz+3B6pBdTFLn+qrsZjQYL0aQS\n\
z3W3Ydhqxtt9bVj1B7F/oA7f6R+FLejAGwP9GCAafoHeZ11OtBPFPjcyAYVD\n\
jf9ubyS1r4Yjlvwd3n+Fo3ocHD2EQxRPnaS4a4fgBOp1S2wc+Ae8NGkjLdes\n\
X2C//X98WWrpGFK6Ud7DcWUZ2yDFTdx5v8fjJmqxofPjaujV3KIA4+TEjYuw\n\
LcnQ8X45hq6PEY58WLg7CEF2L8ZuCmBT2bGY24WGt6ugXHEg4fNg9k4/xaDd\n\
mKmmWR5L/xZu/MRfTyCs13J30bTDU3uIcNNOHnkrWxYT34arfM/GIiBCXe/B\n\
O9aH2Pw1uKqOwlP5LvHjx/C0XIHr3i8RJZkfEZ6gc3o4UMgrCDfPPYQbkvPB\n\
wr1EU+cQarkB59HdCLYQDioINyOl8OXXIXj3AzgOfohg/TXYfvNdOkau+vw7\n\
8HdMILHaB/epvYgK++E++DLC81PwZ78F9+07SOpEcB9+E8HeNviyt8Lf0Ixw\n\
OzX18mVE+svpnmeRjqTu44ao7bawD//d1YZOvQFnRnqwHk1g2biOj0b7sY3o\n\
t0xjgi9ox4kFMeIkRtvlC8hVqFnMlS/PQEwat1++iA/p/I8nRzHvDSIQtOGq\n\
eIZig2EInIGN5Gkmk4Q34oWTgk4HvXzxyJY/4nEQiQcRTsYfwgtIJiPJLrfy\n\
yZLPkU4KYuxkAyaLRTBMKSA43oD+7El2hER3BqFbcW8ma9Mb050Za2qy4NrU\n\
5gpyOr0Z0W35LWAk4at6Eu7uHHKVYYR6PoSz6hASuk7YL/8dTWYF6wht176F\n\
mMNNbGiHO+9f4Z8ZhK/6R/DPjSE8sgvm459HaH2FHM2b8I13IjJ1Ao7CrRTr\n\
h0n5nyDHyTpSrkVfYnNVYdJLvpI8UoJWjiiKSEE4VBQgqAhLIrqsF4HaIkTF\n\
IoR7KhAgTZSmAWOi1uhkG5HDLURmF5H2muE98wIRx1UK5JJI6ZcRqLqD4NAA\n\
jXmaPIAb4W4CW1kuYho922kmOWYiUnp+sBfLLheODnZgJcwrYXadJ/N7GwOT\n\
+f9Zkn8gQn6Ury5ic2CBRIjgQh8WGlcQCnJ5uYgnyCzfb2Sj0vE4wh42mcYn\n\
LXgR8uekd4fgyv1POPKeguPO/8DTdQcJ4xict74J+41vk31nEaIwxH7z36js\n\
3+Gs2U0agoRJ4S8QsxMNKOthy34cCT+5HUkFXA1nEZ65CXvO/8BZ8CRsWX9P\n\
4zbwWZ6TokNkk4p2xBe7EWjo3yCz2DRJixU2w7blb3lwJZMRlK7Mol1vwrhW\n\
wSal/nCD1AhcsTiXXtvBdehPeaSlQxS9W+Q0DSM0chHykVHCdJgiDQ1SEW5J\n\
OWldRMK0wi6SEs8j5XNyFqe5kPK7WFNnklEKgkkfRvxsPUmHDAmb8nN8RzJh\n\
L9LE8pmQBymv788eGLhUPMHUwC9YPwK3MYDidjuiKfDB7e8yt8XyvAsX7mpx\n\
rVCHghY7/LHN8WdvGo8/NP4Zalw6yuYWtmysqiCVQCrkZb9tXkuCIc3lpLf8\n\
iLPNrzfMrBJjLacOifhG6z4Fm8KLM0VGBKJpRGLpjanNNDASSW0uIyRTmS2f\n\
e8D6G0j89Ma9iQpams0YXgrB4YriTr4G7TOc52ZC7GAwiVgyw3mlr1I4JYWj\n\
4hcw33maXj+Gs5PimbZzbB40RiGnmfyGJf9pONov0dQLwN2+A2EzE36l4O0/\n\
QZ+dBN1RWPMfh6XoWVhr9lFoGIV/8CR8S0K2+Z5+cupmF81FHZx1LyEeDCEw\n\
chTmu09R/T+BZ3aAt89TG6aL0fgnUptjxEyxNGmsmPf+ekqE1Of8qULEImkk\n\
QpENN5sMhQg9iQdG7O/hVPtw5JICV2iAL+RqUD3sIdSSnTpMOHdHg5xKI0oa\n\
jMhrd0Aq9qJn0oewn1Df7QALbhrF5iYTlK4kZsdsuFRkgsoQQEW/C9Eoc8wC\n\
a5jNiqNv0IoJaQRWOp5bosfNMgOu0j0bxoj0fFHkl2iRXajFpXwdZuRhnsL/\n\
lg0gHEXfhblsN81nPUF8Fc6KJ6A799+Ie02w5nwD3qVpCjBJodS+g5B0AbbC\n\
HyGgYJZOk3DUvIzAugzO8ifh7CsjKWGhz0/DKaiCu+F1OEdb2fbZq18kBWum\n\
+bIO881/hn+pHqbrTyJqM5Mg6IG1YisSkeRf8gaMy6cR02p5tLCD9CX+ELMt\n\
aSMruOlskmmEuWVvvme/i2goucER7F+CLBYJpzcSiQwomcVHRlNxc+ErcFF0\n\
sbj/EsSHs7nXoSyIT5chGkzBNzeBxT1nsUjl0mtF0LRMkaOxQXazFlE/R7v+\n\
eSGW9l/A4kGq48I9BF1hxBRLEO08jeUz17Gw/yLWbtQRdui+8RB0xaVY2HsB\n\
C/suQN02zS5dc+17Bg4Cz6EsJSZlYWhVfpy4qsIwMcaRK2qsGmPQKHw4elGB\n\
EUUM0hknyjtdCLpDOF9mYpiG+ptE7m0VRPoY6io0qBkPwGv142KVBeFwEnkE\n\
QH2QA09VnR7Nw27cuatGzYgXegPVc1WJRqEPsxN25DWTA/YlMD1swelyy2Z2\n\
NOWeheHSPyPqjbL1pIJe4pgWGLOfQNQ0B+P5L9LM3AlHwx7Ya/bCvyygSOCn\n\
CKhMLHicFNUGVkSwlz6NiJPTotGFa7DWnYK7/m24JrhMtqPuNQQ1NgKPHJbc\n\
b8LddwKGi9+ievfRaz9sdccRdQa2bKAn0Hgalj2/RtTo2UAP5/a+DIvcj7Js\n\
Heru6lFVaIaLTCAZtmFJHoNHG0Bljg4VOXq0t7oQIzsKGkyozDOi+o4ByysR\n\
yEYdKKPjdXl6DAt8FELF0Eyfq/IMqCu2wEfzUdxvw4qK2DsSQ0ejnWQXoF3y\n\
YrjP9wiPNHN9GZbOknYVLcMxs0ivBfq8jlQsCtmRU5CWDCIgl2Hpo4NYJdWd\n\
DOgxv/MaefEE0kErFrcdhrKR4mwzBatZhNRbbQgrVzH7+j5oukQIaZQQ7zwG\n\
ZessXENdmN15hV3zDKwsYIHQ6FC6NpFmV3IeIMrPldZmPSr7nMi9p0NOtRkj\n\
0y7k5Kux6EhBPudEZTeHtEuVZsTSHNIK8tQQGWJoqNaiXxJjRgOXa6ws0grI\n\
xxlDHNJqGw2o7bMh644W1igHIyFRV/2IhyZnAguLHtS2mnD6uhIFvS7wS7JI\n\
UqRsvPkmG1+mQ1rYKt6EtfiXsJDEi7tVMGf/DTxznRQszsB669twjdTBVvQ4\n\
vGJmU0kadvI1AekKHPd+QHQ2z9YZHN4Na/N5uBtfh723hC2zF/8EvjUZuXcF\n\
zDnfg19UAkPWYwhr5hFZqyK0fw1hi5uPrv6CTRyHxygQHe9GTDZH0sjLRvOR\n\
iQYKJooRXlpgdVvaqUVwoBJhkRBRuZicdJyk0zQC3WWIrIoRo5kRM+jZfTRJ\n\
jxdJ/RrV5eFYpXgbUXLlJ5GsJjIouG6CmyAxSV6itcWD6SYjxucDaL+tw7gw\n\
AL+HJv81LaaEXgy12eFiJnGrBaW3jeinSa0hcjCKXci9rEMPeaOGRhcCRIqD\n\
lQZ093ohrDNgYoUmdzCCe7cMCBCoZUQIjdWuDeo115djvWLqATr+CzbLuH7i\n\
HMxSG9sDW3MtVm+1k2EMxIE5iARIvilEmNtzDdEwh4Lw6gxEe2/RKE5j4fBt\n\
bOwCdXQ1Y/lKOdT5eVg4lQ/bBPHF2Az09R1wyWw8iv8eDpUXJ3MN8LNegDit\n\
XEP8FYB01QchTb5+gR0nrymxYEveR7EnhDP51C0GZqkkbt5WY82aQGMNoVj6\n\
MIpziS+lTi7eqa7Vo3HYiaxbGig8XJmg24zGcR+0a27ibRXqBp0QiX1QWmKb\n\
zjblnIEx67uIsTckpRgOIOlUIyRbZFepAoKjMOU8BXvVazDlPksO2QJHwbdh\n\
uPYobKXPwXD9+xSyRRBZzIbx6ndhb/wYxsv/RbNdCk/bG9Bf/A6spS8RSr9O\n\
15OCuvsozEXvIUnRiLPqF7CUvAVrwRPEr+cYF8qB+C8RrDsGy/4X4Ck8BNNr\n\
/wT/+AxC7SdhO/om/J33YNv7DELzc/DkvEl6nkluvwvjB48jvDALx/4fwF2R\n\
A/fNbTC9/S0EV2Xw529HYJKi5oId8I+Ms131XHkOph0vkEhLf+VhHCsJx90D\n\
3Mq8Q+ZDfYEFY80mTIh8qL2uh9HOkcACqabOfh/kM26UX9eh/LYBc/MhWJQB\n\
1OfqUXJDRwzrwWCFHhPL3M4B3bwb9UVWjJLKmqEBRZjU1V0jGKkgFzrQUufa\n\
YGRLYwUWj9+DZUgIS/84zD2jcLEhSYrFsmnFxDWxuw1rLJaNWNh1EUFfmmbr\n\
CuZ2ZhOu+Z13FEmK9tyEe2YK8/tuIBrJ8FhugTi7DNqSAszuuAhlSQOUxbWY\n\
fWc/NAOyB7Dsw66T6yjqcmBwyIqD2WrIrXFUFquR30m4IpY8S3pglfAonXag\n\
lMpC3hD2nFlHXpMNvQMWHLyqwaIiiCs3VXSNC1Yj7/tJe1y7osC5EhOGJ5w4\n\
fEkJkTqKtkY9LpaaMEhlB86uo26Cw/LRWzqIVv0oKNaiYtjLt/F/syznKHwU\n\
1gZS7ZE4u+TmafglTBWH+Eg1RQpuDCHJILuMxrI4BY4J2xpCa12I2Yx8XZ9H\n\
3DCD4FILlXF77JJuAxJ2DcLrfVRGotQhQWi1l4JMN3s8E/chIutFWDFF0i/z\n\
aR7HnivvwDc4xp7iPv8y/ENDLClHJKuIznfDvv/n8HXUw3HuZUQMhJCgGvaj\n\
zyE0PQn7QdK0NFyxlUHYTz3PhEgIFO5AYIpIungvAhMkz5yrsB/+GWyHfoXg\n\
nPgTONYQjotvWRAgsSjqsKC+0oHpFsLxQgCduTpMzDAxeRKt5PomJtwovKTG\n\
PEVLMpEHy+IgunM06Cb8GqV+zE15MdVuRn2DC/FEGpMNZrQ2uTFBxNPU5kHA\n\
FsSts2oo9XEs9FvRWHsfx82VmPnwHKSXCyC5lI+1s3eg75phJyGjLIzLRs7T\n\
dTRj9UYLkkET5t7ehZUbDfCurGJ5z3HIKocRMlDgceUalrIaiJ/EmH51BxRN\n\
4/DLZFjZcxTyBiG8U8OY/fginBI9vKIpzL13DA6FaxPHIXcUY7NuwqMNuaQk\n\
5lXctPQ4wqhrMSO3ijBI5mH2DtqNISwpSC+H4hBMuzFMQos5Llwn/av249Ql\n\
Oa5WWWGl4HJqJcA+xTBFdY9NuVBIrqtz0svq0kQ0gT4SYKWtNkyKvJDqo+wW\n\
0ZkpJ26XG1HT54I3kuZ91e8iZZ+HLf/7MF77Jkw3vgVT3rOIWHRf4THlvf4e\n\
fH2DnCMu2El8Nob4Uhth4Dk4Lm6Fr7MVSZsWjtMvIqImh53xwkn8GFHZEJ2q\n\
gytnL1zXP4Tl4M+paZ/A1NQswr2XiOILERm4DnvO9U9gSrfkxq3TJN5JYZZc\n\
M0BrSmCW8fFLYbhJrVbd0KKcFGtTjR0hUqsz7VZUkxJlFKpEEYVG5EIVOcWK\n\
mzqMTvgR8ZNaLdCjgiZ1RZ4ZVk8SK31WlksrqayalG4NKeN713RYU8Ye8vFV\n\
05/w8QnoCiqIq5zcmE6NU0w0hlTEAXlOCSQXr0NS1EV4WcbqyStYPHIFy+eL\n\
4TfRNDArsH69CNJLuVg8dIn4tIFirCSbLrU0N1FZFpaOX4euU8QkVDbTPspl\n\
LzrHuXTHp/jxY3x9d4cRk+o4Yp4wSnqcjCr9v/xJTBonbl5E3CKl2jOchvor\n\
eLLfgLe7n215oHA7DesogvUHYL14mCKYNbhvH0ZEJILj5HM0lAzrMOts7yMi\n\
18BbehiBcdJxc62wHvoZu2CzOayl++EfbIeTKCQwt0qUsQzrnp8h5gjRcD4w\n\
tr8PxZwLrZ1ehEiTRWKc9p6o0WNkjktSUTQMtzPBrC1txrR+dxyh8P2YNkyB\n\
p8/Hrxv8HnU2DbcjjniSZ2B6Z/KwAR9bDeJUZSCQ4kz3WZjrSrF4qgwO4Twc\n\
4+TLSVY55uVMLpLkSGajVnaTI3/DjbW5ZISTZ8wKVMzjv7/e9ghLNIlgiA2s\n\
N8qS4TC725f5tpGQdlkjkGq5pOSn+f9xiteZhxjiRAILshCzrW7Ld/khC7bn\n\
IrS0wt420k/SenkNaZ8Gnry9cGS9D3dtCZuw89dfQdzO2DCMQMddJJwhxOZb\n\
4bz8IRzZNGN7Wtg9H6xKYYas7CC8zaXwVmYhwTrwKPy12cxQPzxkj8CuCULM\n\
SYvNDUnqBWZ7R3xjVrDJOff4AMSE3+UT9DpJr2NXsHq7BfEYtuznr8uk7qd4\n\
P8P/v5/hpebd2Qq/cJITUYLRLdxuwy0/ZN6YTH/mfd5myUQCDaMq7GtYxdE2\n\
GQncCJ9w/xRiiyOIUYgYE49SeGHi67jAX5lKRtCpESNraQz5ilWYovHNDYwh\n\
otGNTY33HzwgiRpJPDCyn6HAIIFE6oF2k2k3zvksj1oXBTJX+lSQOcMYmddi\n\
V4Oc2YzFbf3a8srmPdKITd1EsPsCUv7gP/AX10lG8NhgEypVYuydbMJL0xPM\n\
xRuSemheh301KzjStIq9bQoYwyksio1ok3BSwevy43zLKg7T8X2tcij9SaTI\n\
ud/tW8eBRiqrX8MEuZ5YNIrLnRLsbVjDqVYJ8mZskKusuC20wucP4nKXCl4G\n\
meEo8vtVcMWT6JpS41DzGs60SbC9eg2OJC+pP0OqJEixKpfbZ9a3WcukImTy\n\
+CZyMpkUq/rxgKmYFZwH/9IpmjiJ4GbSin0sz0lVJzcS+V/ZqI2KN9ZyNhK1\n\
JJhohgYfmGLMIMboXAdDDvy1nOnjy1U0Jf4Dgbbr3Klfp7g+gjEKQSIUGq04\n\
DLDyO6StQZKgbm4zsSfkRLViCeUqCfRECmnq5Chdw+xKD0ZJzSuXUKNdx7LT\n\
jDWfl7veb0Pxugh1WgW7iqqOROEKuiD2eRBNhDDqsG4+kyd2GqEg1a4PODFo\n\
UKDDqMSQcRU/7a+DIpbYDK1qRmg8O9Sw+aMo6ZUgW2jBiFCNe3NcCHq3Zw3Z\n\
YyZqbwwt4yrUEz5mF3XY0aqEPUhsIzUhZ8yA9nEldlKZjTxl07AMe7v1NOV1\n\
2N+lg9Ptw8cVK3AQ3uPBMM41SDBJ131QtQa5K4JhkRbv0XFXEhtqLGivgHTm\n\
CcgXX4Ni4TlopEUIOOogm/kxlT8Gk26AIDUH2fQP4LAKoJfuRJhkTCI4Duns\n\
4wiRsmZ2/OklH5Np4rCuvwPl6jHoZMfh9ZoRdjVSXU9BNvc0NOtXiWFs0C49\n\
jfX5N6jsKbjcMj4rxq9JfonIcxVJyXZm3QNp622kTMPMighSkl8gOfcjJGf/\n\
C2kLp3gy/l4kF18gEDGbGero80v0mYFsCmn9MTr3u3TNd5CUZzN7mpE2X6MX\n\
p8AzgXEkRf+J5PzP6P1xpN1ynjX+it2oG1+pRWT8FmLyic3dn2m3BNHJm4iM\n\
5SJhWOfboEJCM7W5JJYyzSBpN7NtSCjbidt62YWclGEckYkcxIgwkgYRUszW\n\
z4AOCe0cU//9HaSaNniufhsJj59ntq/DF9DjewOtMEZC2D1ciXYnF482ywRE\n\
OKPwht34zWAFXhX2Ydt4Ix4T9GLFqcL/DLbBGYsia6oJ3xtqwq7ZTvxHWwEO\n\
rC4jGHbg+b4yvDU9gL3CNny1tQB5eooHFOP4aHEWFo8ajw52wsXQbDqObSNV\n\
uKk1QmxZxWO9Vfhoth/PDFbiG90VEAUi95E+LEfjCpcasplsONirRf+EGuUL\n\
DnbGnK9fwM5GKa73yXG9ex01izZUDq3jzaplXKOyG/1yFIxp6JgUjWtcPRaz\n\
DUcHDBCv6HGoRw+Xx4fdVatwk80ThPSsZim6ZzS4Mmlhz0+EwjhbtwZ7YhPp\n\
BvGPoJCQ643oWDRbDYNQih6DxTKPiLcfctEbcJnyIVk8TurBDPkcoZvcvUOx\n\
H/MDfw6DYZTqJdKdewKhkA2K+WfhdMqgEf8GTssUlARNs0lI9SugW9tLZd00\n\
W66R+nLDtPoLSFeufxLpmeA0ErNPMtkoQushdgNC2niCKwuZkLHnICH8d2SY\n\
ZULdXiSGtiDtUSGt3kqficR9ZiZLSOd8ncqVdM0akgtPIu3VIa3bR0jiNlql\n\
lbtpBuQTrXqQUryD5MohfrSY506TiPZ+BA+FF8GWdylG/QpCU51Uxyp8t/8Z\n\
/vLXEWx4A57LX0NMKUFSeheeO88wLM3+hWufRaCvmdqogu/al+FvPIukdoQ+\n\
/w38FSQyS34I98W/RGSFrl27A2/eC4yK3gB7fP4q3Cc+h5CwbxPs/qABPx7u\n\
gJnAfni0Fl0uDuwd8jG8K5pAr3IGT4x0I8RMymQIp2YH0K6X4Ckqs0UCNEGq\n\
0e7idiWdIuAfkYgxoJzCT0YpWmdnaBTvjNQgV2fCjFKI3WIRrF4NHh/ugYcF\n\
ewK7RutxV6XG8elGHJFyz6BoHHJ8r7cCsw+AvZZo/Q65YOZvekGNfb06DJPb\n\
PTuoB6M6brWv4MKwERqSFuV9EhwdNGBoWo2Pm+VQUJlgSY93qldRMCDD5VEu\n\
g7O0osOhvvtgdxPYt5YuQRFKIeYP4BgBW7CsxzaqI0bNtVld2E11OO7TesjZ\n\
QgB9AfL5lyEe/QfYDcNQzv8UoRgvvBOkPa35WF+9SaB20blPk/BWQSF6EhZd\n\
GWTzbxNwrfT9adLzNiiJV/0BB3TLb1FdA1if+jqkc7+Gcuk35AaehcetgENz\n\
EZLpxyATvQqnY+W3wT6DxNxPObAbjrJgT62/gaS6jUMSRTBJ0fcIeCtILf+c\n\
qPwXBNa79Pkl+vwMUup6ZBx5SEx8FSlmU686i64/QcDX0uQ5iJSW26mFqIEo\n\
vgip1V8jOfV3NAlq7i8mepcJmH+PqJx7WiixeBv+5hOIjhyB795v2MCC+YtP\n\
XUFknlzLegm8+S/cB3vDCwgOtCMTlsB390XuyZi12/DmPsvuGGO2eflufo08\n\
GIFdkgdf4avgxRV1OoJgxQ/gvfkv8JVtY1wCN1q/9wnA16HPzS01dRITvyca\n\
R51sAm/NTXK9+H0W1y6fjvDaSXgP4oCgFv3849ON0jGcWFtE4/oYti3Mbmaw\n\
zs93IYfI+0G8/3ikF37GaVETd4/V445SgQMTDbhn4CQJSCO+P1wLoT+yYcDm\n\
MTleyBfhbJcMb91bQK86gGlSzK8XiXCoQwGR0o7dNWJcIl5/v0KMMWMYEYq1\n\
TtQv40znOvZVL6F0yQ2ny4dtFYs42irFB0WzONhvxMqqAcf6DfD4/Hi3QIRd\n\
TRIcqhVjf7sa3hCp3yb63CzBnqpFvFmx9qCKibgGoZOXU6gqJm5/DHbTBFSi\n\
7xMfT5ArWIJm+V3YddchWybpHjMT3J+CVZeDtdm3kEz6oJj9PuxmZor8BMGg\n\
lo7/Eh4iWu3SK6R65qCe/xF0ynoEPZNYnXwUVn0N1sa/ToHDMpy6POrO8m/B\n\
PbSAhOjnnIrZgDvDvbLbnHEzblImjxJUy0iB/JyUTjOS06RpFwiG1hokl+nd\n\
XsrB3Uh+wdZKcP48qYgRDu7SGxyqzBQVCv+B4F9I5/SQorBuKom0aQDeG48j\n\
6dtYT6d2JYnvB4nvr/4TcfMz8Bc/g0DpswiNFiOxVgxfwYuMs+fh/usH4P4K\n\
I4oI7rnwFrzCn5NGqPonxO2MYsuFr+h1bhowRyxD8F7/DvkM8gU3/xNxo4VX\n\
V/cJ3kJ43zdSjWtqLXtNrXQY74iEmNDO4/GhNvLezJNDpGNF/UTwa3hK0L0J\n\
+D4Pl7Jtko4S4MUYJxXF1OlhnlyhkOI1cgJ5DxK8T4tHSZMvBiPs8s82QQ3u\n\
6XS4ONuKPStc1G50KfFY34ME/wek2+UonLJgWefBup17wjtI0b/dF4HU5GcX\n\
AJ3eEObUHui8sY2dr+FwDAsaD6R0yUYc7fWHIdb7ML2mJ1GkJ9QEMKMLULCU\n\
gtkThd4RxKzaCxe/0BmjEHdF74WK/ITFF2PC3Q3AJ8JiEi/PkIx+CetL7yNC\n\
CiHsaiXJ/mNISG5rZVegW/oBFgTfhMveD7PyAomS/TAautiqXZqT0CuLqPwy\n\
nIabEI/8GVSSwzAor8LvsyHq7SNB9CxJ9OegVRRQLOaHSfoRcfuvifefp4hT\n\
90nApw3nkJj8GwJvPwGUNJS2g6RxF5X9LVI0R1Kyl4n/f420hmT54ouEJDLe\n\
1B+QGDlIn20k1b+PtGsWqcVvE6+fQlpLQkj4NZpIdhIzJH4Ef0QT6BZ9PkXn\n\
PkVgr6CJ829Ud899fncvEL//C2Ja7mHIlE2EiKgFUcF+Eh5PI8E8kmOXIFT/\n\
c/jq9yMhrYA350kGYxzg639JgCd/FFPCl/8bZvcSC2xvwcs84DMIN72MyPIK\n\
CaECeK89St3gHqeKCXbAV/w2O8FCVT9EsK94E+8BBu/tLL/vG6rEP/dU4uPp\n\
HnynuwRZCgUSiQDeIzz+arwT2yeb8T+E/XmHCk+OdLF43zNcgx43h/daih72\n\
Ly8gHvfjLRIxvxxtw9tjDfibtiLcM5oxpRBi55IINq8W3+wqxBPDzdgubMU3\n\
e6owSZjVOtbxeG853pzsxi8GKvBPD6n3R9AyqUbXuo/9xj34/2nYLQ5kkzhZ\n\
l5txld4zD2TJMuQ8YhHnA1tDvkBm8xF4OeUetORBupxFrjUEh6ESkVjs/rN0\n\
zPSmUN9hqKXA0EkB6PPs00duSxtCAS5+T1OMH4/5NzN18QhBhd899kkEMogZ\n\
/2uiyz5C4AlSFo3cXVxtpAaeJQQeRSbiIZQMErXOctWbKpB28j+RY6pin7hA\n\
VI2UfDcFnHtIjXDHMh6iXXMdIfAcSV1CpOE6IffnLO1SH/iu/x3zpBah6GeE\n\
tqcQWyhH4O434K8/jpR1Hr4bX0OwNxvRmevwEv1GlhZIlpfDffJz8NfuQ1R4\n\
Fd7LX0Z4dhix+RtE3f9F6O0jjUzn5z1/H4F1z9C1YkJgEV37CLxFLyK63Ab/\n\
nX8mGufUVHzuPDw3aJZEknzbvs6m00R2C2LENwqXFRKvDZ2aVfSa9Ajz2b5w\n\
zI821RIqlGvQhKNs4PkjolVbPAG50wo3n0uzBt1Q+H3cEEd96NauYdSix97p\n\
NtxU60k0erHmZX7XIwKxy8amZ+pVK5hzuTaziAavFa0aCUQuO2Q+J0Kp9CYM\n\
ozFmO176ARh+iiBE7iaWYoc/FE/9KY/OdMpHCPEwu8Rh0xQilkhvZv8ySTes\n\
miIqS9I5ZvYHrZyGMgT81o2E5Z/z1TBzPjn9j+Rgm4hjyGGr6vkUFvFKxIpw\n\
3y4EKn+BYOdJCt25FHjKOIJQ0+sI1LyM6EIf9wsilmk2PRAZO49A9a8QGiTO\n\
CnsQ6X4f3uy/o+tzCJkjCI/lb6YMYqI7iBtIt1qnEBbcRGToNMLDVxDuv4yk\n\
h7NyxqdAuItJPYY2jBQMmWkeD8AaT23urnT7tXhsqB3WRIpPs30ap+c6cFNj\n\
wLxmEadWxez83fOJ3jMJEycTflIo51+jl2HLN/gqEST3X0ByJJLhx+IRGoMo\n\
Fp02xNKZzVsnKa5adrFbA7dsbENVE8YMhCNvyEtj7Nt4pjxG7m6oijuVy69u\n\
eWbjbukoaXoDk67hfxXsU4jYQ6i+YEIglEYknPpd/tSIP0GO9sFddUxZkhqX\n\
eagsHkn9Vhmz2y72id/7CPuZZ/TxW2VJLtG85dtcS7/DgysVjbILAff/MvQ9\n\
zKxobGYzmZ8DSPPP2XPN5n6UIRaMsqsf7FoFt/BAEcHmufQ5gYiH0QaZzXQs\n\
YTfqCzJprC3/xZZRIOMKo2yfEnVXdKg+q4Ggx0faIInhAjN8cbALLrPVZtRk\n\
6VBzUYvpiSC7F3G60oSqC1o03DCgI9+CMDVFOeZABdXReN2AhltGmCwJaKdd\n\
qDqvJeNrIRwJUPcS6Ms1oC6bqU8HuSLGbicXlhpRdZGrr6vIyuwo2/QQKZ+L\n\
QBvYBNqGWfgFhg0W57r0dTimZjB2oACjBwuwUD6FRCQCeXkbhnfdhfB8DWYv\n\
1MFDisg8NAr5pBHpoBMzRwqxXD0JSX4nXBZubtpGxjFxmnx/lPUykBY1QbCv\n\
EMJztZi/VgfhzUGErVZMHyrAavMCIhYSi0eLMHa0GGPHqmHX+Mi3OzF/sRiC\n\
Q8WYOl+NmexuBn+b3YgFwuya1YOAYXb5xsKJh7qbZn/4gQPRZ/n/zM8FRYNc\n\
YJkmzZDkmTWdYM99cLUq7PYj7I3wE40b9dKDarJ+FG5VAOXH1VCth9F+QQcv\n\
jbprzY3ikzrYHEk41v0oP60lhedA8XEtrPYE9LMulBzVkg5Poi1LjZnpEOwy\n\
Lwr3q7Ay50ftKTWk8ih7be0lPSZqzKjLsyJIc0E16cRAoxumeRfuHdfB7kxA\n\
M+FAKX2m6viloj9BqPYyQtPcRrbESifc+cXIJEIUa+yDff/LsO/+Fbz1Ddzv\n\
j9VeQmiO+3WltEMO18Fn4G2ohq88GzEzp3tClUcRGBPwT2pwM5HImuhldHsO\n\
FCMKBPV6jO3Mg2ZsEYLd+TCtWgkEQvS+eg1OSxDa5nas9GkQ165j5EAZPCYv\n\
Fk+WwKb3sxHB/Kk8dL56BVqxk30IbnBrLiwKBwIqFUa2XoVizoqIfA3Dh8rh\n\
twWxmnUPotIZdk5qmnohKiNAljdh9Ewbgg4ftA1d6H3nHsMg3GCSVo2EsZTX\n\
g66dlejaVY0lCpOZtUvb1BJ6dpaja28txq91Y6JomggqjrkbHVBLvAipNOij\n\
43P1Iqw3j2GxhVclhOv5yy2YqlneXPnU9U2he3sFuvdQ5H53BIKjNRB1yOBe\n\
VaB3ezkWOpexWjWM1UENu+9lJrsFXburqD2VmKlcZB8zNA/MYKJ4jotcUnEs\n\
3O6Ccta2kTOMOEKoyzKBXzbC4D09FoQBdGXr2YSCcdSG9nruuWQmp9KVo0M3\n\
sUZXI/+sciCONsKV15tA+xUN1tXs/jZ00nmzIy7UnjWAV+SIBBIYYlb8z2h/\n\
B91FJgLYYKMDqz1WdDZxS2gJTwytVB15g034BXJ3IjAoYI/HZ8vhOHWZvGwD\n\
rNueR0xnJt01AtvWJxBRmRHMI88umODqkvbBtv01JJw6uC9/jKiGWxIK3HwD\n\
nva2T8AvopJh5DCJWr61ca8fPooNRk/VgluADkK4txBOsx+61k6s9hP8dHI6\n\
Xo9oJI6l06Wwm8OIqNchOFIJaXk3pnOGWbEsOleGifMNkHcKMX30LnRKH6IK\n\
CcGriXjHj0mCvTCnG7J6AaTVg5C0zWAxqwSyUX6PkkMLwd4KhO7DT9sxiuat\n\
NbAonTBPLKDprWIYVS4ID5dhrHAWHq0Vk8cq0H6sn11HFOwtg1Tkgn14Dt1H\n\
O9jtiCv5rQRPETcnVWq0vHwbTe/VUnDL/NZKBIMf0axollE06oP4bgca3yij\n\
QDcGffMoes/2IewLQ3StEfMtq5BV96NtdwscFOS6VuRof7eIok4SDK2j6Dk/\n\
wsEvGcPY4QqsDRg2du1EnCGUE33ZCWuZcBx159RYXgii5YwGajNR3pILpRcN\n\
7C7zlD+G+gsajDVaUHXNhCghLaAPoua0Dj4fBz+ZIsHSbN89kkhjXlQd18Dk\n\
prrp5Ok2B0bIudXcstAoxrDWZ0PJWSMUkw5UXjOzj0F4VH7UnNEzuzQ3V8oD\n\
d/cgMMwtNMVFVXCev4pw2yU480t5T/GH8F54B8GJGQQLDxC1cb9wlZD1w35o\n\
B3mEANxXdyKq43Lfgdtvw9PRvuUTAIwZVBjeUQCPg5MhznkZzMIFjBMAw4wf\n\
TPk/AUAtkiYlRk/XI0ayY+lMKXFjANrqFvYXiKJ2A0Z2FcLrisAxLYZ+SgJN\n\
rxCCHTnQKUhna2QYPduEOJHTzIHbmCkQwLokx3pRM4YOVWMxuxTLzVxyNUrS\n\
fmhHGQPAjZFjJvn85RoIy1f46Z2GcXodbpMH4wcrIZnmfsDANipC98leFoRj\n\
ByogI2djH5mD4DZn0dXCNkwWc85FXtmHgYvdGD1RjeVh7qGPqdNV6L/QD+2U\n\
CobhWXR8VAPmyTNDyyjGS7nf65m/0QxR7QLpgRqI+zT8qHwW4lstGK9ahLZ1\n\
HH2XRjdBOH6sCpIh40ZXou4wSnYrUH1Nj8YsLepyrPB74mg6qcK9Y2rMjXsx\n\
kKtDfY4RjZc1aCm0U0xL6um6BlWX9agm0BYeJ9Ly8yBUciDsLTRALidabzSj\n\
7JwOzXRt7Q0L+yOqzQTk1tuktMg/T08GSWokiHM1qCberTpD9z1FgdcDPjiY\n\
/zG8Tc1sd2PjBXBm30ak7wYc58/y7iINz8lXERSKECzaAXdtPUcdyhEC4W4m\n\
1ITr9FsIL3OU4st+C97e/k9gkFlOWTpfgvGzrVC1DKP/g9tQEWaYAdnA4AT5\n\
ZYfJRxjswkqPDPq2fvR9kAv9jBwLp8tgkWowuTMHyhkL26qF0/lYbhNj9VoZ\n\
pm4NwDA0C8FHt2GUO6Ct70bf1jyYqFWmviHWH6t75zB9OA/ixnk45+Yx8O5t\n\
SBvGMXs8D70flCEcSN7fokAYzCYMlon5Mf8qYv4Qu2DOYG1tklvN8YpX0Xee\n\
iDD0AAYFcxjJEWxiUFi6SBI7gqGdpVibMFL3BOg+M8huEQqbrVi6N4Lx7C4M\n\
Hq5C6weEQZqlDLmNFc/cx2DdIoSkaVcGdBsQlBR1Y6xinoVgL0GQ22qQwMTx\n\
hyDICGifIwGnPgKtJIQosyeB2d5CksxtopjLkyTnnYJ+lSa4LEyhDb/4Q4rV\n\
RHLRJA2i6byO2W2IgCtBQTJ3POhJcDu0KNKwyINQr4YQ3shJEoR1kiBspvhm\n\
HM8EHCZ5GMZVP5ouPuyHg4Ufw/LmY/A3FcG550dwVzawEs++9cfwlBcgUHEK\n\
1q0vIW7z07kfwfzq9+CtuAV/1RlY33+a3cLtPvkL2A5sRaAlF9Z3H0d4UcpD\n\
8Iv8mEaF1xFRrrLfuHDi66RtvJBX9EB0vQ36eSNpeQ+0gmUkmHlGck8/tEDw\n\
jJMsJFrskUJb14meN29CPbYOywxFvAYzwVhEfpqLznzSdRhmNIj53JBV9GLh\n\
RhsJXyVSiRgUJc3oeSsHmikN+4SlZZR88Y0WKPpXeKunSeMtYCm3G4qWEYzs\n\
q2Jk4ZYNx6xuHELLjkZ43TFETEb0khZTia2YIG2xgUefeO0hPErnHLD0TWPo\n\
2jCbQV4hPE5VLMG9IkXLexVw+9KImXRof68UVhLRigYBZuuWWD5zzojQ+l4V\n\
AhQYa+uHMXpXSFFrGvPXG7HQugYJcWrnsW6EKNyLuUjw7yrGQo8Shs5JNL9Z\n\
DpPCg6jTgd6PSyAdN28kBVLEsb25JvhiGf5xbYqzKSDpzaPQ/QFQxMTjCE/2\n\
wV94Et57t5Dk0ylJzTy8t/fDc+scYipuG3BsaQzh8S4CRBa8RQdhffNHCAkF\n\
8FzfRaAqh/c6Cb2eLubXEDa2DaaTUYicRIV8dkXj0aNIMYdSzRpsiST3TO+W\n\
P+bP5p6vtbLP4zJ/4a63EBIPsTmbzP3omwkh0wHXAzs1Ps0+yZ8Oue8/+ZzJ\n\
3N88FfXTMS6PurkeE7CRjbgy7hH3z0Bd34rlHjXSTgNEBf3stmHp7Rbmh8o2\n\
EyuMl58rHGBohQ8fydYuLYZ3lzMx2SaMkl4vhGfr0P5RBTq3FmMga5iYL0yu\n\
qxrSGW5Rz7ciQf+lAda1jh+mcLpyCgO7S9H0RhFEjQtYqxqAqJ6Yt7QH/Zd5\n\
90fcIzxejfk2BTxr6+jeVoIeClU6PijFBFGgZ02G7g+L0PzWPSx2rWKxoJve\n\
lYh73Bij6zp2VKPro1IMXBgkSJHLJxh17apC3/4adH5Ygo79zXA5ohswYswZ\n\
4x7t3YQRY3emjDH/F3jzpwwiuO9cp9P9cF36CFFDmIfY56h7dnwgrIeWZrs3\n\
aMKvh0twdX0Wp+Za8Pb8GPNbQ/xTlVu4nbhfRiZEEXHVk/CWvwpP0c8QWVtE\n\
ZHAnXDcfg7f0OXhLfkmhhhdp1yJ8xT9lyzxlFCp4CBVhAwI1L9B1VF7+JhJu\n\
LQL12xB3OBBfo1izgOiu+GfwkQRkgBXs+pC+0/nFTyM4Xsl06494QAT1BgpN\n\
/WyPUwnuORynWIlIKLEJCGa/eIr/heUNQKSjAVgWVEyia/OX8phng91KUq5q\n\
58av6iPiDiAe43MN7HP3YXqP4P/R9hZgdhxX2rCeGAJ2stndZHcdMwccdOLA\n\
Jtk46MSO48QksMWyZcmyZMtiZrZYGo2k0bBGM9JomJmZGS8zM877n6ru23dG\n\
drLZP/n0PFdzb3d1dXWdt855z6nqU1UfJqK/QUP6kIj6ngK4rV7YxlUwyGis\n\
W5wsQW4kw5ifxqvHJk57WIiojupgVVghrJ3wY/BSIUpJLbHV3OZhBUwqgcSy\n\
t8NNw2qYxo2ReByCpM58LlJ75C+Yxw10jV9aCUhPHpZlIaTpFqNDd3B3coo9\n\
edgLb3czDSf/NJkb8G7jDZI5IcJrRr1eWE9BqgoLa65i2Bu6VeYBWT7s2ft5\n\
UglP7TYySR/AVbwK1oy9fLS7chbBln0Kzht/ga00nka0Fe7KHXA1VcBbswGW\n\
5C1UjphdzkJyN2Ngu/QiPENVsMT8Gp6BDjqngjNzFTzdWXBkb+HB3MBQGkzn\n\
XkTIHf5vUYJTrP+ZTm81wkFUqL9YyHDafyUXjUkdd4sPb2oeJPdOyP3ZeeYm\n\
jcf+WV+UOiuIQMFP4K89NOtXYoeEPSasog6ZYM6B347TPeXI10wgdbACf6rJ\n\
gp6gcusg8DvgbblIYH8BZpYbpaUM7uKVcPU1iio6C7akJaS2fwrLldmwZ6yC\n\
/dpK8mOuw5W7GI6GSqHPiRSGneRjXfoT3OT/WI5/G9aUFVR+DWxX36XOIUs8\n\
eAO25JdpDP8Q9pKzTJv+97Th7tZZ4XVHtBsZebMdLrOwuFlKGmKwRZAoatQ7\n\
hZ4o/hX8Tad4jr4pO3HKYDiS5ZSvFndo6LCOAWz669aiIp8VSXMDonZTVrkQ\n\
jpaWQzOSFZZaNeU28hwLmIqugmczNVN2NaY8wqIMlv9+yue+TxSLg0zDgG4I\n\
bzdc5/qJbCQW1CZieVsh1ndWoNlmF7PoSGIJyvNhOvIU6aRaBEbLyA8jhVD4\n\
NuzFQrY7b91OWFM3wZH2R9gLTyFkHIYr+w3C8UG4y9fAmiVslcC63N14nfTX\n\
n+AdLIPlzM/g7ixFyNAFa8zTJMYrsJx+Bq66TATkVbwMPe8zEshC8DQVwys3\n\
zfoGP/avQneX/QH+6z+nz/fhS3mc/v4BYe2I8PAeFQKlf4Yv+XE69wT8WS+T\n\
sVMLIGl+F4Has2LH/SemTPXw3/wRlfsGL++/+QrCZi3Jq5O+U50EARpDCNYs\n\
gj/lSfhT6VPwFg0zG1/3E8j/rXBd2tMI1G1HIO8X8Oe/zZAVfRXfakBAQW6w\n\
3jhrhvCnpk8G3CH8ZkKfmhLBwc9NRRkBbr3osxjU9pKqScSPK1Ih5+ExHza3\n\
5SBZPoYeoxJjdtutop2yj8IW91vYrq+B5dxP4WpvhLd8NYxHfghb6iKYTz0N\n\
z8ggQsoSEtfP6dhimM/+Aj75JJkiIkznvkfHlsB88odw95bDnvAqfBolfM2H\n\
YL7wexphr8MSt4xIlhbOa6/TKHwH1gvPwl50aqZoAzDtWQxr9Ygo2q9x0QbL\n\
XoD30gMI9RcirCP0XScRpr9EisJLYpgDX/x3EZI3YcpQh8DNr8Kf8Sp3TFjK\n\
T3/hTnHMUD0lJJprvyfyP0JjqheB7O+T6HbR9yaq40mChI3nc/Rdug+hYZYS\n\
qhT+5P+Ev3gvQp1beZmQkuirtgqBHILIRSo31in2/L9zfuZOOwwD8UPDot/A\n\
MP+XhOSP2AQoEYUWmMmB8GtFntlTCNPS5+AoJj4SswXWk1f4cefpdcQ/r0Tn\n\
iLqyecK4gMEjwuczcLj0ONJTBa24rCt/tBGrWvLwQWseTg8PiMKNJOdgveoe\n\
rkbAJWaOJlNkrTsDY+kJePTqSLEppxp+croDGiHZ8xSxlxApnsBEHYJGhcQf\n\
rWPwj9exGRWxjf/CLYxvuAJBnYz3s6+vCCFXJI1MF2mKZrqr+DKM30pVVsMv\n\
7+GvLQmN/QI5jqRZA0KKBJa7OzwVfaGGFWSJGqemHXN6TbB67ZGREgz7hFcx\n\
WHYnarkr4BE74DsI2/VwFtyAd5hsccBB36/CkhhLpKdeTGxqIfvQKiwbCrnh\n\
aawn0xHkb295Wyup602wHFsFY1Ia0f0rsOXkSCsupjiRSoElieqraxJyEpI6\n\
dre0C5lzWBeoBmBLuwRbZga5FEMk8izyNYnRdFTAUVbD2+An22a9ehmOqhp4\n\
OppppHgJ0n3wjoxEXjEKyvt5NZarifCOCpsyTDlNcOSmwBx/Hra8XGq9L6oa\n\
SCeW/Bq+4m3SJihT6pvwJT5GNbeTfroHgeZYwd6Q7zZFlDLYlcSn64LVr8Bf\n\
tFvsamLBY9kIacd5su+whgZZ1ndIF67FlIUGTtI36dgk6bkfwF9+QFJD4fEY\n\
BBsPItRKAyr+azSYBNIwZSimNtA1Joc0cEJD5dD98VuwJaQSYBTw1d+E4bWn\n\
4ahoQEhWB/28P5AfSWbXR0L/4Dnol7xJKtgO+543YdogmBX7znkwbTwcnXCt\n\
j4du7gvwK13Rl3OiGZRF0iKChE0VO6A88xIckxredfq0uZDHvw9j4WZMnPkL\n\
fHavlPGWbAEc19/jr+cKLtx/YlyXj4O1K3CmeQdONa7Blf5kFA8cQ6NJxu9X\n\
1rsLJzouoEF2A1kj5agZOoZD9R/yHXoyx0mt2rtxsOYtVKtakdK+Diebt+IY\n\
na/XjohTeM/CXXQFijkvwtnYRXplPVTvvQvLpRNQL/sTTNcKSK91Q/XOKsI4\n\
S66lgHrJPHjZW14hO3Qr/whrVQ/5qsshf/NlmC6fhnbVq9DuJ/3kdcF8+D2o\n\
33+P6jsO1dIXYb5ZRqS3FarlaxBir2YHXTBsnA3ttu0wx+yH+u0/QrFsEZGo\n\
XmiX/g76c8kkugGoF/0Buv07oN+2DPJXfwvXgAHu9P3QnT0ngEndA83bL0J/\n\
jEzDia1Qzn8ZHvKzbaQDVe8shfVaAvRr50B/MXlaNi+RTTWcktbETbm64Et4\n\
EsG+fA5lf+rXuOn3Z3yP/hIUs14gzkRmuvZV0t/7pHWr1C3B6mVU/An4rtzD\n\
WUJIwXJ9NxKSv4Wwoh+BG48j0HZlVuQ9JZZjNFj0PKH2YSpP9DbjO/Sdyhos\n\
UQTLu+C8msxX2jIm7W8vgXEeWcXsQjrXCP3s38FLLoc36wh0LzwNV70Qfbbv\n\
WQDT5qPi9/kwbTkaRXBDInRv/gl+lUuE3jS0OqG6MBtOhYFIxyRkp8lCCrNE\n\
UJ38DaxDg1G0MrLp87CMVBJa88nKHeu8CptHjQu1c1GuJe+580OU6obB7EVc\n\
7RJ0WFVom4zDpa4E5A0mQka6ZkiRgK21m9Eynobz7cdhsvchayiZNLEZ2Z3b\n\
cLz9nIRW142T0Bw6hpB5HKoFhNohBV9e4G0rhvnadQTV3VC/txZBjlYltCsW\n\
w2tgaHVA//6rsFX3wnJoOYzxBSJyOgmZc+FsqYBq0Z/hGtcK9TXlw3I9C0FF\n\
G9Sr1/MVomxLHu3y52HOFiKXjqTd0OwlTmqR0Wh5BV6TH6HJKqhWfyjwK3IT\n\
NG/9RUDrjaPQx17k93SRNVd9yF7GCPBkRParF2j0dcBZlAbPqBZBgwrWM+9D\n\
tWEvz6spobXkN/DnbYgqXm0eofVRhCZaCT73wV+xhVjHGCnQEYS6d8EX9xAR\n\
SzOCdbMJYm9IyA/WLSA28jCCnQl0foyYRx/B0UbX1hEEnyI2JBc8rqIdkuKd\n\
0pUhOHCNW9rw6HWC6QBdRyaldRO14SkOW4FJ/BtCo82wHSKit/g30L/yfRhW\n\
LYVfRoZf3gDDn78H41t/hmHOD8h1OivqztDHIbv12N+FWC9UsXPgUhrJIA9g\n\
Yt8j0OSfgL0lFuMHfwaX1iRltWOhUfc4eaukQx19yfBqxmdFkvurzPW40LwJ\n\
J5vWYlPZS6gzjKGwaz0q9EIaisS6dzDitqNDdgUJvTmY0BXgaN1bOEy6tFhW\n\
QwjOQFzXBXoaPyqGzmFvzRLStTvQrB8W70H09+YpaA4eJs+8Har5v4Vm/Qpo\n\
N78L7YZl0B04gcBkGzTvr2N5tok8qKBdScg1EuxCTgG5pGcZYbCW9gpi9Jug\n\
Wz0X1rw0Ggm/g2bDSrG+pdAdPovAeDPUaz5k9JGPVk/FNWg3LYfmg8VQL34O\n\
mv1naBRNQv3WK/BonGQSq0lXb+dL/9mSfsPOZXD26ThydTGX+S0diXuhmPtH\n\
aLe8R/daBc2aN2EtrkRwvBu6TYuhXPoy3WMdXG2DkbV5nCKXPgdf7JeInmYS\n\
aNoQyP0xfKnPkgIhPtKyigD0VaK8tWTF24kFPA3fjbk81R2n4ec/i0DVVoRV\n\
3QTcNwigv+CJ6Kc0laRvHyEqm0WeRjOxgScEqt2zBb7L9xJYidbrOwj4pJMz\n\
lxK42wn0n0egJYHKa8UBwq6J6tuwbhDGuU/D8M7rcKTEEuXsI29KWK4ZGquB\n\
Ye7PYFz6S2hf+ik8nZPiwLwFvLsJvJsORql2S6qAXqWE3kjmvjDLfa9sg5yY\n\
gIvp3ICGdO6zUKe9A03aMli62R5bkAAcNkN79fuYPPtlTJ7+MgzVaRKAlYZq\n\
pPemQGkfQUztPFSRys1vfw/H2i9A41QhtkZQvS0TlxDXnYr4urnInKjAqKYc\n\
JZOl6JhMwrn2k7C6BrGpfBHajUNonLiOevVgFMCZBOD9xL0cagIQGf6KRlJ9\n\
Zg4K1aYdCKj7oVo2G+5RPVd96oUvwt5KvD9kJaLwF/o+BMvBZdCfShDUEElc\n\
tehVuLqbyMC/CFttO6/Pfnk71Dv2IaAk4rGIyFPXmBA2qcqEo5ZUjkEL25lN\n\
UO9kZkAuAJgcIA7gNdsEwBPjNux8iwPYk30CqlWriF174CmOhXL5UvgUGpLs\n\
JPRrXoMltxyWE2ug2XMQAZ0BnqYKuLr6ZgC4YTW54C9zQ+2Lvxf+a7/kOxkI\n\
45D4AOkHX8LDZOzJRc+ZTdpQYNLB5g30ex75lV8n7kDU1tZHlPZXVO4xKn8/\n\
+YlLSPM6ifr1ULm5JGEb34AsWL+Cn/clPEjXkm+pHuUx+VD3TvIdvwpfypOc\n\
WAQazjFqLe2QEJI1Q//Cd+AsrOH3D/QQYVhIPHOQtC/pKQNZOE9XO6zrn4Nh\n\
2VzylwxRjRsB8L7F0L36C7ibuznpcF3eAN18ArDeKyj4L0benZ72LyxlKvCT\n\
WvIFxOzGRO+4ezUVDTHR99tnDgO/vg2qS7/D0KbHaBgYuaLWJb4EbWk6eTTN\n\
UMYtZDvqCVfdD9WEEwV5OtzI1KKkwgylXnBY2fKyrlYLmjqdcLqCaKw2IjfP\n\
gO4hN0b6bKhvc8DrozItrIyDv8SmHHMgj+rKLzJiXCWsNAiSk9Zca8LNm1oU\n\
lJKOtUQidWwIWqDL+BlksQ9BFvMQjLXXpSHoco0hvo3ZkA2IIRajI/7bPHIW\n\
J5rWEXffiI3Fz+FsTzI61WWokrdigNymkw3rcLR+LcqV1YhvXYO1pfPRpB9H\n\
5eBxnGhYi4+atrKs5yJp/BlCqh5oV/8Fitl/JqeuG678C1ASHzccJp67mGxE\n\
aTthaBCqhb8hyC+Bbv1SOv9naN5dxO2CavlC+PQWWI4sIz3+EnR7aBi99QJ0\n\
Zy7z0Lsz/Tjp8DfE+l6DnWxOWE/DcP7voVzwR5hSr9M9L9P3V2E8c5BYz4vk\n\
I2SSi7Ub8pf/h+zOJQSGK6H+IDIMid/vWCIMw6yz1O5fQblsPl8UYtq9BOoN\n\
7xGnXw7VmuVkzpxwU92qdxbBeHo/VG88B2t5Q7TvAz6BwfispMDHmfGIptp2\n\
KmkMsVgmpEUobM0OFzJ7Fd8lrtmiRvFrHXJIb68EneRqDrDge3SOyyETmJTf\n\
H42HevT8jegpt3VWdEsYJxwnV5Er+SyMq14mQv4jmHZsJO1DY3W8Cvo3/wi/\n\
hu5pGYVlLY25t16n30rYDyxhpFwYbweWwbDkjzAu+z0xoz9A/9J3yM4fZ5NE\n\
ktcdtqKzYxFBUSk9nmZiB3rHbsCsPoOamp+goek1tLS+hsaOd6E35KCtcyN/\n\
eo+9DF1dG9jrPOKjSOxpKmCG/uZOeHTCcrMgmV91wjwoYulJypN5JCWSwnm4\n\
1YStG4dx5pIKN25oEXNqHFv3jGNQE4BV5sTOTUPIKDKh+IYKO/dO4MZ1Lc6d\n\
nsCGdUNIyTdDPergZa6XWDDab8XuHcOIT9UgJU6OzTvHMKT2o+qGkteZl69H\n\
fMwkjsao4PBPRQOXnzD6hGf5spB73GePZM6QfHJvwIL4+lXocxiI5bWiWS2u\n\
4fE74AoI0aNhxTVc7DwnAcLls8EXDosj+2fExmywnFkP5Zr3+HQ+V3NDbXCU\n\
FcE3KU7FBFzwTYzCP94HZ0UJSVnH36N3lBXCKxPe3Q5qZQioFHDXlcDZ3Crs\n\
GiuqT99AK5UtBlvCx9vvc8I/MQH/SDfcvUM8BOUbaoejJI9+95PsAvB1F0I5\n\
57fk03QRYbOxdNciqkOk2ckHcAcQMmqJOMvh6WiAX2vl0yDu+jI462ql2WkW\n\
o/L1tcCen0We9zCP+N8bQb2FfIKUZxDSGcXgxn/wqL+/oxquvHR46uoQFrNT\n\
hEYrOeJ9cqGPplxm+Pva+RZ3IT25yGphEVRIPUFYo2PKIWKl+eS7UV/4AtLC\n\
4LARDfW/hto4KaFdMbgSrf0XMdD+M3QOX4HPa0Bn03fRM3kDNlMaaurn8hfW\n\
3JZsNDXNYws4I2iPZLqOtBJSVPsh3lOXT4zhQoYRUZMWQtzxcaSW22GZcODU\n\
GQVYWC774gTOpOh5OTd5lAd2jWBAG4RpxI5T5xT8Bezs2EmcpzIcfDR8KnJ0\n\
aBhwob7EgD65j8eP+xsM2LR9DEpz6G8BW8i8dDuB0cL3rlOYG9Gs6ZWyHpND\n\
6vQ7xZEsHPO2FsF8PZO/BfFIRH7UUaZzR+C3eaTN7eAzIDRSSOd8syLvLYRG\n\
yqF7/XeEP5ukVZ2Xd8IWkzzjHkw4jQ2/hcrIFpaxSevPQ86FcxkWbQLq6n6M\n\
lvYVaKx9HIPKQtjN6ahtXMBVkduSh+bm+dOFI8yCM148haFeO/Q2IbzJ8vSO\n\
9Fqxb9cwbtQ6uSBOn5XDQc+mGrbh+JFxHDw6gdhYGbZvG0GfKgAjCeL0eQVc\n\
pDnTz05gx75xHD/JMHT8xOSsT6Ogyg4nSxqbosT+faPYuWcMmaVmlrPqb6qY\n\
k5EuUjMHbDcCBves6Jwbe1H0CHHWDNbt0V6yoKXxKZRX/5Cqrm94nnqpvOzL\n\
aBtIgMfRhjFZFuz2buIiPydcZMNhzqCy5K8GgnAaU1HfOHd6LwnrBx7kaYC6\n\
mky4eFaGfXtHsXnLME5cVEPvCMNKPXSGYMjiFDa9B02t1JsGHwY7zdizfQQ9\n\
1EOWcSpzXsn3gMqNm8TxSxroTH6YDB7EHBpFcq4FNVkK7Nw/id5hF5QyN/oG\n\
3Ux4f7OHBIiwTb5NaGp4FiOyXNhs7fTpwlDXywSOK3BZS1FR9U20daxEdfXX\n\
IDf2wmnJQlnJo6hrehXVVU+ive98NJ+V+PB3wdtVC5/GIA1Ptp2Yu7mR1NoY\n\
j3rbC27CXpRH6i2SHfZB9NTq8OGmYcSlaFDfYofGEGBJ0PmkSWmmCrv3jqOm\n\
w4GRHjO2bB1BQYUFZXkabNtFpmjSg4osNXYTfmo7nJgYtGLXjhHcyDUiP1ON\n\
7TtHudlrK1Vj3yEZmpqtuHR6HCfiNKxnowTk4z0VVfe6Fjj6rsDWfh62jgtw\n\
9N+Ez6SeFdnKk+dZlJXC0X0R1tbTsLadg703Ea6JBgQ9TmFu+9MImPrh6I0X\n\
q7lIVabBQ25YOBRZKnEHApYRuCcq4Z5sgM+s5trhDvH6KbYloLYTzqE0OAZY\n\
XCQJTtIMfotOXHxwOzel7A0d8fOZCA4w4zBfIhR5A4Tt+OUey4W96wKsLaz1\n\
56nqFLgVHWyHJ2Gxx+eEu6sb6VQ8PeQZmBsOw1x/RCg+kAOfUcFaG9ntk7wq\n\
sgu/gsaklAK2iqGVaOo5w3vV6x6F0VgLh1tY1BkOOeH1muBy9MFk7kQwLC6k\n\
EpF1Nxxph6E5fkVCljP3FNT7T8NZFgfZwoUwnjsBw9EtUKxeTl2oFy57ANXX\n\
FThxSStdBrcPF85MonPAiew0JXYQQLLLLPATGeltMSMpUYWEJA1a+tz8tarr\n\
SXLsIKDlVFi5XpQN2nA1WYWkqxqidMIUUJCAWlmoQ9wVJa5l6ZlivC2iiG/F\n\
VWMeQrYhGArmQH75CcjO30P9I4v5CglPdv5+yK88DX3ZLuLNekl4zHr0nIc6\n\
7WeQxz487ZI72Heq+gkok5+FqSmOvfYjYYFZE2vdOiivfJ3KfUW45G76ei/k\n\
l74B9Y3XYRsokYKWrq6PoLjyFFX3KGQXHoUi+UX43W6J0bNJ9+E0aG/8jhr+\n\
NaqMt4LaQg2PeRCK+B9AV7wVHv1EJE1dQJ4DTdpPob5Kn+svwGu3i427A0Fz\n\
EzTpv+APpUr5NRwTgyI9vIPn6LI17YEq+QfUkgdueeCvQHbxa1ClPQ9rdzZj\n\
Q1KdPlmO0LxLTwgdQ1ew6+5l18XQdecfgDzu29AWfgAvjd/HphmArvaVxNhV\n\
klOhGd+P7uEbEe0QBeJnuGlRrVkA09UUWG8kQb3yDdhaadxWxEFzJCVSgz3l\n\
IDQnE/gQjkzgjbYbsY30ezZZspZWGxKJOG/aMQ6FLQw7EfNzMfyVk8ibhcZR\n\
O85dUDIzIa41uWsmoEhU2rw11JE/ZY9Jv+8X/sZQp8XcR7eVX3yE6iFZQZH0\n\
BzgVo2In38k72Vy+ROhQqkt+8WF27adYj9NpupwOPcQ/DDGqzAWESZMg2n8n\n\
lWeEIe8lAUwXH6Euf4QuvI8+VPzC/UJ3s98xD0NXsp1ITAfUiV8n/D4klD3/\n\
nyTGH8PnjOSEuJPHMW117wvXxT4otOjCfYIEqUWxD0QOkRS/B0t3fnTbmjvg\n\
H02Cgp2iu8vjvgOPxRIFm74Uikt0Z6pCdu5J2Ac7Ra36BYQdI9DnvMABw6rn\n\
D8z68MKD4pPcJxynFrEBqi3aTOPdG7ncQ/xWwVv1IO8IfgnD7MVH6fej/HKh\n\
5Y/wahWJP4dLM/poBHpsOwC2Y8lU9KXjcNjPl9J+AvRYeMu0fwU0p0hXp5yC\n\
/K23qDFTcJdehOZgvBTG7KuGZvs2nhdSSk9JRKub6EjMeRlOnZ5EHOm4QZng\n\
U4UCRElsfMfYCPSC/jBLmcnTagrQ+9cZ0JNfekzoTtYtpJRUGa/AVLsblmYy\n\
DdVroUr6Lu8HoRx1YRK5GrYIXf0in+Ixl77B+yRSlzzhJzCUfQhLSyyZlRiY\n\
Kj+AOuVHUj0MVMobixDw+IRqHoWzY7cgOVYFg+tlpj43wdqRRMbsIxhL34Ey\n\
8XuCWOgWCvrOy14i8Vz+BpXdAHPjaXrcyAu0U3C0bp5WJ4n10rdolL1N1m4v\n\
fXZDl/0njgY5F/GDmIz9OuxjHVLswz+WQpAQRpQ8/ulbkFgGRdxjwhiIoeuG\n\
uqQumfIqyMP/lYA49rj02MqU38BYtYW64wo3zsYyep6Ebwvj49KjfGRri3ex\n\
9YiReF/Y3gt10pNUhA1LQubFJ6DNfYv3qnO0DK7REqrqEHRZ4mOwrrhAPXtt\n\
AfmKfmGJozTz6am5Bt2JWDiyTkN7LlmwFMWx0BxKkADray+AetsuvlJ2+jx7\n\
5GXnyK5OH8MP64SL34K57ToxDX/kbfmgdQCG3Jemif1eaMtPTItw3An34FkO\n\
hwh01BnL4DWqI60OOWUCumLFrqSBa6hNnKaL7+QJp3Rpz3D0yplyiP8ZHJO9\n\
keXbIcckrPWbxLH/sIgGQlDyXLb9jtRYXQWUlx+WwKBI+i2c4sKWyAI+Rp2c\n\
PadIBT0q6AVS08pr81hvS0z9/wqayP0ZYO2Na7gaF0DzILQFO+B3RMbanQia\n\
uqDP/g03DwJoHoOlt/ZT06toeF/EHZ2+9FVSrtn8ESJV8EfoOihoUV7FAzB3\n\
F0csPQtHTtvuiE3KipfejqDTAbtCA6fOGtXX4mE5HdZbp6vxgM0Oh9KAAFt9\n\
w1nrlOj2ihXehSmHCtqN8yGbPwfOPmFthavoAtR7zyHs9/E80/rti6BPzpOs\n\
nbhXFaItDEYX0d0t/gzfclpcvDMVkCJULDdpOCBlPgj79AgQ1EIBt8TSbwU5\n\
E4i+5uI0Jk+96dXQSP+tWIaG6OVn4DZoJWQGCZnX/1tAJmFCkfhreC1m6VnC\n\
DpiKXhbGB9NPV/6HqJUtgqSwnehJwjdEi/MgDDWXRSTdCUf7XhrrD04D80IE\n\
I7tZ3ckf2VLxJl12vzg4v02arTfCy5ztu+jqB0QAPA77cMc/iN87EXYOcGIg\n\
YySCBrIyYwFL/y7c8vNECRTUFT8VeooGszKNRp8/sqqKnOasZ0XOQTqi9Ajv\n\
5UhzGWM1Fb4iWvJ7oSk+Hl3Q4XOiZ+9ptJ0u5fEfv06OxncPY6ioT3ykL5Gu\n\
b0TdioOofOsQKhfvR+eFEr74n/0z1TXMPHexlO+Dw/4Zq2pR+9Y+VC47iPoN\n\
MWjfG4u+G+0iiiMTKfbEfVCS0gyKSd3YViiKFYug2bEW6nXLoY+JYX7FnWJx\n\
nz4G2tpvw+sUd/fq/jkM3e9J+205R1bBPBwfWY/nHFkBU/8B1kkwd/wETlMn\n\
cTY5jM1kDOp/RzW7yMHbDW3Nf9HnEWhqvwa7qmhazuI7ZyKZ4Szx9/DZ3VG2\n\
TQ2OfVBU0Q/B1F4aRYMim9DwgMCACDGGuuRZEXcmaKglNDwunnuUNFFjdKdE\n\
WydUjCZy7D5KlqFUwi5bwqS//nNxVDDsLpiO3bBzCOqErwuKmKStzv2QdY7k\n\
U/i10F79Ab+aGQ5dzZl/ELt3wNVzRGCjbDxceByWgUbxKe+CdzReILvsSS5+\n\
F06lMMkYdo9Dk/hVbp1l578K23Cr1DOWymV86DGrpc7cMU0Y98MjG0LFqxtR\n\
sfIM82DJNJWj6MX1qNtxnbulfq0cNfO3oflwNlw6G4wNDSifuwV9OT3w65Wo\n\
eXMbWo7kwKWnc3X1dG4z+vP7+F4SVW9sQcvRbDi0ZiiuZ6P4pXVov9I4awZi\n\
P0M60U/N90Z1ZIBtA2gjd5Y8Y7v9MxFg9z4HRdEsWBWV1OsTpPzuhrLiKfIl\n\
hXlGR99sGHtORJDq6HsF+o7VLAEJOccPwKFvRdByDZqyL8Fl6EPAnE3fPw3r\n\
xFUiCWQvRldDXfkAvA7tJyKVCURbzDtPkOHdfItc3bUfibKn02X7o4tIO/eK\n\
HjHJ49K34dQqo0GTILyqJrgn6+CarIXfopfIw5RngkjWt0TKfx80hZuYjYig\n\
xtG6UXQcJJxKaPONp9Dx+yXUmLsrJdTY6lcTah4hM/sIVDnbJJP0f0WopNDZ\n\
q7UViwSFzi3Jr8jl8kRuNxVywSOvg1tGTzhRj6BL3ImQbeMpbxCenB93SsMw\n\
aO4kp/4ZrrA5UG/ujNrvu6DNyUH5ov08VYVuyIDxC0mkJElRrjgBqzkIa1MF\n\
ShYdgVnnlXpk6PhF1G5MJUVUjtIlR2HRRzJZfRaDx2JRt/kq1OUlKFl8hM6J\n\
AJzyoH3TUbRdbojg9EtiExBQwtBIeq72CRj7DsFvIjRVfwmaqn+HXSPMtTv6\n\
58LYe1pav+zofx36zg8EFDY9TChsIxSmQFPxVaJpU9RLpJVrvgevTYmAS4aA\n\
YwAOWTKB2vxX5psfhqkpV4zE3wVr2XzBXjMbdvMdtosS/2etWCDyXPrE8/1U\n\
pHfyWBIvY+5zgmvJqeNXSX8nM+9TsnHOnoOiD/5xoDk790WhHfctgrZuVmSD\n\
0amAg0iyGiGXBiG35f+vJowyFicMWb8WzfT9UKWzrsR/ipoj7LXAq6iGtWE7\n\
OYbfEqrnZuMe6OuuRCJ8bC0BN8oXy9B9iIxmegXaN3+EoZs1aPngECbqZeQA\n\
5aNi1Uk43FORRmsyb6BuI6nb7GxUrj7NNuGS4KPOyED9pgTIbtxE5ZozcErq\n\
K4y+/TFovVQvUWmWGie6OhicEDqMbjhtfmkKIeD2w2b08FxMVP6OmcgLmJMJ\n\
aaREZOegb/45rH2LyEhvgX3gdfq7cxryjt+CvPdvQV4qIe8JcnQDhLwNUJXd\n\
BV3DT+nzY/p8H5qae2FT1n4y8kh9mHvrReTdDUfbVkkVyRNfpycQVmBYy94Q\n\
GSRzfZ6FtSuedHHi5+i/BBa96r0Ml7xxmsf0r6JVfzAa8CF9qkx9jgjPPth7\n\
4ol05MOj7iUwCC+jOnsO/w1winqXQeHKD+E2W8Q4wz+CQjsMmb8UCQtpu9RX\n\
YO9LvivySD2X4eGrWyNM/G6e9t+rrIO96zwMBYuhSn6Gqn5cCEvwx3yMswl5\n\
/G/gMekjSA2aNKhduBMTjZOkALNRsfwgyt86CpPcjKGPLqDlTAWsnQ0oefMA\n\
DJPSxtOjZ+JRsy4B+qZalM4/CKPMKSF15FQcf9FaW1+D0gWHYVKJ2VxCblJ0\n\
R9BKik4o+0W+MqL8dCdkI0KZgMOD6o9akLaxHmlra1F1bZJPsJoHNLi+oRbX\n\
Njcgc2cT8k52w+ETd1+IcmH2MuM05y3kJqtgtM7IBu+3WuETkvvOiuyH5hpd\n\
Bm3zS6SPZNA3/Beh9HbYFOVEN05DU/dDruOcg3OhbXlVem3N2vFDGLr2sP0Z\n\
BLQbOok/XCe0P8mZsFdzEKryB0jkKoSJbwQsZP0r7mDl/jrYG6aBfYsIdkJp\n\
/Mukqhm7ZnvcviKqURE55+/B5Pl7PsdDy7dh8swXoS5cy4NdkTCKezAOyitP\n\
ikh4SIj/sbggDyyzSNNTUCY+QwbvHejzZ4ugu4WW3oLz+J8TbXH8gzhni2ss\n\
xIRF/1AIfPG4Pn+U0/8CfeNlUWzgTlTIPg5b0z6o0/5HADcL+V54QAx3PhIJ\n\
/XJHSpn2EqmvHlHID8BSX43ieQcIjh64hzpQ8uf1qFody3e0NBTkER89C6ta\n\
jeZ396Bu5zVYZTpifLWomLMZ3akt5M8b0PDOLtTvTufndNU1/FxPWptw7u1d\n\
qNt+lUAxgrGEdJS8vBEdCU0S0oNe5O5qxFivQB4H03twdWcHz1dimzTgxsZG\n\
yAfNKNpVi+LECbhtPrTHdSBhYxNs3plI/yx0N69B1iDsl+BTjfLNkzq2fYTe\n\
mDy+Zaa1voI6uX3D0VkPYyKvAzP+kddtbLiHdDefYoal7TEoiz8Hj12HKXcr\n\
NOVfhMs8CtfwMihL74CxexkcY+ugLpsFyxhLAeqDoeErsMnTSZhzidD8K6zD\n\
54hbjRFTeBTaxj/AKT8KQxN5Y8xD83v/in4nZtFRLkKe1HX7tmmQ/4sIeXqW\n\
8vnRAOylRz/HHKNPsV9sPoB5wyUbOd5vF+0QCxKZq6m9qT+D4vKTAlBixVh4\n\
zD1CRJ/PMTw0LXwwU6k7OvdEZwSIcbiM+r8BduvfB3a2gR6LikpBw0dnzXwY\n\
apihhb+AKs3m+pVZRM+/SWNcHHk8Ovcwf3AWumIPp0z6BfTFa8k4F7P9ZEWT\n\
QA+VnoOm/VfBXk4PWY1o23wSnfFCXi6vcozoxAWYFA5yRIbQtO4jVCw9gApi\n\
vJ0xRfAKaSBhH+xD04fHhHOL96MrthheMXRg6+tG4/tHUL54Hxq2EvN95yB5\n\
Ww3TEZ+3twnj/S6uuuqYXt/dge7CSXTmT6D52ggm2jTI3FQP+aRAZ5wTNBJ2\n\
NMN6C+I/D3VyHEbKhDXo4yfOYjCjkRBnRe/WY9A0d6N7+zGoO9XwyvrRuom4\n\
kzkSkryPWqKHfWQ1SUpYO+vTXYBleB9CLEEL0W/H+AZ4zAOk44nltK+Bbeht\n\
GNv+QGV2IRjgL3vDpTgMj6Ec1u5fEuLvhqlnPd86POwZhW1gEYztz8Pcvx5+\n\
lzEyBT6TRj8IfXV8VL83rRN9GZJh0msSmbHVLBflSsC7/CNYe3NIPqWfJkpS\n\
SsSAERNN6vdFb42wX7o9OtfxeYR9NlKpY/Ao6on3pMLSsA+myrXQFyyh4fBT\n\
MUr+yZB39RwVA9Hszt+EQz75yZC/8jTcJtPfx2PCbiL+z4uTYMRjkp6HfTj6\n\
NKNlcPZfhSr+SSk+bmxLjbzfFCaFokn9btTeXXyQ16QgvOuKVsHSEgO3qhsh\n\
j110B/4FYX+AFE40PBpiO7wHI/tVETX1+iKZI6m3vHwRotfsnBahuP3W4xHd\n\
xdKT+swOvptUr8i4Z2B9Vx1624Xksi1nW5GyuQVtOeNozxxCyjsVaCuSIWtT\n\
LcYGhfVvthEtMrZ/ItZTrmC0nK0YDKB3+1kYR4Qt99QpCeiPz0TP0Yvw8AHj\n\
ofPnYBo2SevNHH2vkWY/I/4SxUAa26OJg5+8FyEi8QQLS39OktL0oMO9UOet\n\
ZnPpUtCBrjZm/SoaucxcLnl97v5TYsCegeYHTBdKQYewVYhTcZvMordx4iTg\n\
p4VE1U4ZDDkviLGlj+MxoMydFqR/BKaWLCm6EDD3wzVSRMStCG55p+TsRHHK\n\
OP03YB8fmIbT8r8a/7LVvivRI0XyCyynkRTLmnL2Q3XlCaEd5x+Dtb9aym3m\n\
7j0qTXJFohLW3hsIuu3sEZ+QpBBE9+4zaImtm4GY3O1VSNzQjMFGAyZrx5Hy\n\
QR2GOowYKR1F0nu1UCtdaI5pQfreDow1aVGyvx6JW1o+xgc+D83VaYjZTWp9\n\
VFhbq76aSJwgHb3HL4sJFL3o3XYG+gGdhBjn8HswDybMRMyUA6bWZ8mHY9FW\n\
PdyaSpL5JyJG0An/QwrUHEFMyNJCY/qrfIqIdY+ubJ8Upgoa6qBkYuBB0weJ\n\
O6dHejqgLiCJPyxK73FY+lokCU25x2EoWQ1dwUroCtezjI2SZN39JwUQfgxF\n\
d/IopTrxKcFuEnhVN1dFsX0XLJVLMHnuXn658uYmaQmJBCQOvvuhr0+QbhfQ\n\
FhGQHhVXChCQhqNA8o0lCBPA7LrYJ4kXRYOiHmqmPDL1f/lpuFSqKN9oWCNO\n\
INPjX/4eHLKR6CKSgAmugSTyrxPhGMzkk20PSNIil6B3EMYx/TSfKoDOzGHU\n\
XulFwZleOInhjpWMIWd/M/KOdPAMlHymgLygugudyDnchtKTHUjf1ToNWdL7\n\
8OQCT15NR+v7OzFWNcDvOHLoBMbL+4Xvh09hsrQOXTtPktPo4Gt12jedglXp\n\
lBA2RZ5fWHghTFrXzqfEWD6QcDiqFj4240Q9XxUzYy7EWvOWGKpm59lwbI6a\n\
mynSVPkvRqMBiczXNd457bS5eI5IJhlqfw6PzRqRXdjRT37SE1wOk+cfgnWw\n\
U5K5s2ufqCAIYknzZ0CMT2JULhXnmpjcvwbrSJtkk53DxOCeEvXgvdDXXZQG\n\
QxRm4qR/4h/gtdqkh3XRbeXsYdmIuPwdOJVKaYhO+XXQRmZ92Txs+kK2nkBa\n\
FUOjVnfjF5I3p7w6m803Sd5c61aJbCtSn4PfH+1iv+I6ZOe+zD+Tl74Lt8E6\n\
64lIJ0V3seTfo8T7dr7zqEtmxPVtjbB4bgUSy8DtGB5Ez5Z9GKvo5zU4uprQ\n\
su4IBk7Ho3VHHPmUPmjT09C65Tz6Dp1B78U8vvTjEVHffnzenfmN3yEQVDEb\n\
EJ1KDpFSuCgqE2GaWpH6OnWPX+o+HgISR6rQfa+S0Z+UQglBF+zN64XeF1ds\n\
aAp3820ZJAmEqDXpPxai8cRLVDcXEf1zROZGQ45ROv0TUUBkNzO43YxcHdCW\n\
iw0UmI0i+Y/UAIU0Tx2wwlwyVwQr05VPwDbcHpnqnoEccemA6sZCqmFCmuoO\n\
WfsJIT/kyOPoSvgVvE535LS75xjk4qIVFv/W5K6G32aSGuDVw1w2V4T1Y9wd\n\
MjRcldaGyDNEbcag+RRsYy3SrHDYo4Yh+/fTsPcyAr6QNFPqc8LHkpgHAzw0\n\
ybJqkRqQaPNUkHTjICyjXXDphZWjEsR8DtgnemAd64XXZoksI/do7Gi8OgJX\n\
IFJU/HM3UQUDmSaXBFqPUg59Uw+8dl8ExeQ4DcHQMcyWedwj1hgIhuEn3kgf\n\
QjD7/za2kjNSixRJ/Bgiue16kIe4tYUfksLOhnuyllyLNBgK3oz6cJeEeUFL\n\
b2V0JRHRBFvdKmkFBO/eKz+CsfYo8wHgGivm4T3dzT+JKyAe49CVJ5GaM2rv\n\
EKtxduyIrvoh9KgyXoatJ4OevBs+wzA88hrYWo8Qm/y+tB6EC1dQTLdNb039\n\
u9HWcLecWlP/EVzjVXDL6KnIJOmz/8QVdWR9lDJ9ManHgBRqvRWo3Hm9ny98\n\
M1Ts4hbNOZxFLTpMLsqPpFCQ7MI90BTs5bE7qYOCNpgKXpq2rojGddKvYW6O\n\
gXOskihhPmxtH0GT/qzUJEZo+VS8S1wASprIpxUG5oWoE29qOENMsk3soDo4\n\
ei5Ae/1X0eF3/n4YW7OkELtf046uPT9E/er7MVqdB7+hA63rvwtVR1u0jGkU\n\
g2dfpDIPoP6Dx1G/5kF0nXsfLpNdWlHjHM6nep5B/XsPouH9R9Gw9hsYyjzP\n\
ssuJL8PM+qoIySmPA/svVmLlUTY9/d6xMjq2/FAJLpXJxRKYRs5+KsLwCegr\n\
9xE//A5bD3kf+Z+Mi7PDfD2f+HRMO0zScUPjeb72KbImkL0Uaq1aKkQb+Gx1\n\
JL72qDDvy0Ip3KcUvsuTfgmnYvjOSEd71dDnPC+uSHxUjDzez9erKa58a1p8\n\
WiR9VE6Z/hr8TpfUhKmgBZbyOUL1keAHj94wLD0hfhfnlbipfIbY01AExdM9\n\
AnnC0zBUrue/eeeIMRS+yjHSjMgqv8u/gFsnJhT6Amk0FYx5z0ej6ZG1lbGP\n\
Cas2IvGki8KkvPLabHIfDZGH8CvzyYd4MroYlKvdr4md8ET0cjGiq85bxcZQ\n\
BEjmqoOoWfYl9MZuhUWuhFddjbpl/wF5U60IpH8jUJsx+NHPUb38XgxnxsIy\n\
0gLZ9Q9Q//Zn0XZyDd+Hw69tReu6e1C/9vtQ1N2Eub8cQ+f/jOqld2Ekj+8d\n\
IOxfIoYp2HI3Yml2lZB5jWVd87o4vxSSeYkpm9gy/MhOf/yc8HXKrkTYphc1\n\
5rTyfPNWMde9305lNMLvcFjKKea2Yf3xQszZlksP+MaOPDr22uYcHM8enQb1\n\
LwpQv06DnQHp4pOw9HcgaGqBPutF7lcKi3fvFRfw3iss7078eWTFbYTdsYVR\n\
zt4Y0j8/jiyrmLncmg2TuO9CV7QJXqNKYvTMzlnrPoQy4SkRRF/hYbzodeQS\n\
XvmBuAzeKLFJhIlctO4ltvk1YZlEzH08lnk/X4H+FY4q9Y35cMl7IwHfmUFH\n\
crRtFrh6z9KtvyWMZLqpMMJvlxb9KpJ/C8d4h+SQE6OwteyBMlEIqXz8Kam1\n\
8T+GoeoI/A7HrIg351dXkSr8ZbRDefXTO/UBPoegK9sTXdDKQHsItWu+CYta\n\
ML5eZSWB8R4omuukyRjnQAbq3roLfdcuSOpLk70BTTtegE3vhjZ7BaoJ6Mr2\n\
NuGS23lIafj8K+g4sRq+ICLvqxn1HhQ3mlHcboPZHRbwKwrqfg7jYNMeeJJe\n\
ge/mMngTn4e/Lhn+/G0IDlbAV7SWxxCCvafhbyoCC3n4bq5FyGhCsHE3Xfca\n\
vKl/oXOpmDL3wVewlqM8rMiFv+gQpiwDVOfv4b06D56E3yDQUTNrOpY3nijC\n\
PELxpzB/Vz4dm701FydzxqZhmUXaQkRWxsgCDcKnH0DQLZIWcpw8EwUw12yE\n\
oWgF9EUrYaxYD1tXBgIOm/BODpuZNsE9kg1z7TYYyz+AoWwNTJUbYW1PgM+k\n\
vFvEUcipgKP3EkxV62AoXkm1UY3F78JUvQW27htEAPViCsvPkrUdhb3jJAyl\n\
K0kSb0Bzcw60uYv4Ml7HWB3bhUVS058QFBcab5+kOk5Tk1ZDX/gO3e9dGCs3\n\
w9aXy54w0vqQU0VkIpUecjOMZe8Lrafb2HqoSXaT9OpOwAH3WA495BYYSlZC\n\
l7cEuoK3YCj/EJbWi/AaJphcIisYOQTf/xbMCstfgeC/UZn9XLeOFafCPtkH\n\
23gPbBO9sI12wtjbBJ/bgdELf0LNmm9D3d4mnGNlqKxlqAWmwU4EA1N3i+j1\n\
2Xw4HDeBiyUGXLqhwN50LdwhfOZWPAbgS/kFfC1ZhJ1BeONeRkg9DN/1dxDs\n\
zoM3cyHXsMH2vfBVZbKmw5u2DKHBEnhT/oyQ2c53lfIkzaZjxfDeXMzxG55I\n\
hy9rIwKVH8BXkcCSZBLG34CvLv/vxuP3I6iMzqNKSVFZiiK2Hx9byxpRK580\n\
93f7J9QReVFgKiwtQhXr+GuC+i/IpwuqYj/qVvw7MaTH0bT+62hc9zU08r9P\n\
oG7VE9D0NGAsbjZq3/kPfm5GmQ8eQf2WX8OqdUTWRLIthTqHWJL3EGpaTLha\n\
bkDrsAPlzRZoTH50jTnJiZ3iCd97BmwopOOVzUZsuyLDhC0Mq8mLzAo9rpUb\n\
Maj1i15HxG6GRq/Dl7mEhPYaPOd+jZBunH6vRLAnH96sZbxfgl2H4KvNE8CQ\n\
ToLvyYb3xlJxcW8YvrS5CLQmwUtKkCsbWaYg3JK3+XvgfHj1nSfh5v69sv3L\n\
35DZDz4mC6soiyo0LP8CBnJTJVnYWmNo0HwOIwWXyCDK4daOkQeihDrrfdLX\n\
90Hb3w958jxUr3gSms529ioVlRmHh8bnwPFfonbdD2E3eYXqvgyLxolj8Uq0\n\
DpjxfowM5W0WnEiYwKqzchgsXhxKkaPfQM6Yy4cDl8ZxtkCP2OtyLD01iWGl\n\
Bx9R2dgyI4qqddgaJ4fSHsknGxVIbxL89df5PoWeyy8hpB0VBNJXSL9/guBE\n\
B42alfCkruapJ7wJcxGcbIUv9XkEabiHtRXwXJmN4FAZPJd+TOW7EGw7RMLc\n\
RX/3w3NzC8LGERLk7+FrKPznCeRezv6YQEzTBNL47pfQuPF/YBge4O5zwNCD\n\
1rVfQcuBxfDYhcTrIY8Wg0d+jNoPiRFbA+TSJKD2rc+jP+0kIjMiXmUjuS33\n\
o+3oCrZR0SxJIloXTqWo0DVkxroLMtT12VHWoCN1puds6WiaAsPmMFSTVuyM\n\
Vwnj3OPDwWQFylrNWH9mHOV0TcegHTfKdJgwBW6VyJSBevfGInjTF8BXeZq/\n\
e+rLeBvB4Xr4i9+DL/steDOWwFeyluzq66TPTgg6biyT//am0PDoq8WUcwL+\n\
wnfhy1lOx0hCEwM8SZW/8D0aTnSMJOhvLPpnSOT7okQMVefRuvUpUjsPonXf\n\
n6Fob4ZPXYsGUj31ax5C3bv3onnnc3CYPWTsDqOehk/D5l9iKGk92rc9RUPk\n\
yxjOvir0WtCB8YQ3UbP0C2g/8hqG4lei6YP7Ubv6cVJpkciyIJHjiUpYfSFU\n\
1hmQXKLDyVQZdl7T8Xzyh1PlGDKFoVfauES4Egn6cSxNkMj7x0dxmYxSRrkO\n\
a0+OonoskoNVzIJ+l/DKrV8Mi8BOFupNskriC6ec8ItfA75oGJduMRWYuWMb\n\
K/uxY4S4UP9F+Guy/m5L9L+L4t9gaUpAz4Efo271Q+g+sxDaAbYaYwKjicRv\n\
umsgy/gQHceX8Q3G2D9rTyb6z85G+4Hn0XtuMVSNRdGUJ3fyN1S1ZcfQfexP\n\
aD/0IgaufAjj8ODt04RwIpn0nMGLY1cm0TjixM0iFXal6XnYau/FUey5qkFz\n\
HwkhZgyJNWbklWqw7Ng4BklRnUyYREqtBU1tRqw7P4lRUygihM9HOgp+hFgS\n\
MZdbTGlMHaVvREgxOKND/97O840mQM4dhAd4CDmqWW6DpeYw8ZqnSP9G3voQ\n\
ttYTzXb0XnRMtORSOfaijJhJRDz2Jd49HyUKqRDaOk2IyVIjNleHPo2fe311\n\
XWZklumR1+WEWuXCpSwNkkr0yGywEK6nYDG4kZCjxvlsDVonxNRLUvzj733i\n\
kG0E9q4U2LuJ0RF/DPr80SduOIPGLb+CVW0Vt+q8DWaNC0fjFbBLWyH83bc8\n\
GumMIKlgl53zoki1LJdE35iLJ1T4P1YbmYj2+wMYlxlQ3jSB3NrRTyGndpRO\n\
lrTIMCC3wu0PiSuG7+LiMJrsaOlRIL9uDJmVQ7hRMYSb1SPIb5xAY58WapML\n\
/mBYhNVnEaDqZQojqltlyK8fQ14tferGUdamwBDV7/QGRW19J4eA1eaGzuQk\n\
k+yGwxNAKDwVcStYXNzh8GB00oDmXiXqOhWo71aiY0gHuc4BF1X1yv/WCf86\n\
vRP4P5fdgcKqPmw6WYZFu/Mxe0sOXqPP6/xvNl7fmoMFuwux5lQ10qonoLH5\n\
xawV/wK/x4v6ljEculiNt/YX4o3tudK17LrXxbro/li6vwgfnqlFWtUY5Cav\n\
uHD5C/A4XCgoF+6/eE8+5mwV7vuaeP/Z23KxcE8B3j1WgQu5A+iWWZk2iTjt\n\
bCB1do1j97lKvH2gCG/R5+2DxTxqtyepDSpntIPddKua5lEci6vFO1SG3e6N\n\
HbmfwtztuXR6/s58LNlXiBVHyvFReifKuzSweUORDSxY/KW9R468epYfpbBx\n\
go7l14+jaZQTamkmjvHK7gEVlRuXyhVQuUqqzj/tHVsH2XKNzQNfaAqBUFjK\n\
b2R3eTGqt0Nh5duwRxSE1+/HpNEBrSNiGe7gkFCZHFDbvYSUMPyhsCgbabcB\n\
v91OitkxQ9e4NAZ4nH5Rvf81qHxmBlRGhuRYf6yYi5WJ882d+XfwYneyryx+\n\
RMVzsPxYJXJb1QhMIbK3wcCgDNtPlXLBztnOr8Sbu/LvlK7OY0LgFS85WIqk\n\
inHYfOHI/hHycRV2nCzhUBLvO+uTbvzG7gLsTmpHn9IRsX0tzQOYv53flH7R\n\
fej/eXSneXuL0G3wSfveMbXZ1DyMdfR4c7ax8rl4Y6dwq9vErqAGCy2lDyvD\n\
UPneqRqUduuZyY5saAIfMelThfjzxizqRYIvHfvLhkxsuTowEyNTxBoul+Gl\n\
DZFy9+HljTfxzola2MTZv44hGebG1+D1pHqsvtmOpddaUaf1YHBUgXl0fFFq\n\
I16Pr8XeGvJ7CDsylR5LU+sxJ7keL1+pxcG6SXjCLLmaF8cL2vAXKjsvuRHv\n\
3mjBlvLxW3BiaGlDW3rvDJyMJWRCMWD4X3ByB8fJ2fwJDPaO4+09ubzD7+Ln\n\
bufymbMtD/vT+2Byhe4W1S4LaJaUdGHRTi4fDoZPsV6+Q7yOdfZrJNfNl1sg\n\
N/sig3BoYJJukc9vcaeo1kVA8V8R6LJjTE7z9xYjo1ElZIsj67HucAHm7si/\n\
Xbo0DwsOlKDX6BOnZm/nXD/jZhPeoMvn7si7W2zQPELFbHqQ45l9MHtCn54m\n\
8Y/Ol/AGRezMXLpyV8bQxyR+KqGSVSGWu49XueZsA99/lFOb7EasKBiG3ulB\n\
am0P/vtsNWomTPz4vkY5G94Yl2vw4sUa1MjM2JRRhw1lY7AHQhhRaDAvsRZV\n\
5OfVdgzh95cb0ERcQW+xYVVyDd7OHY5kGWHLt9lW0myLabYTcEDcWSfkC/JI\n\
ossRFDtD1Jxf4bFjVVkL+lKroWjsx2RRJ+TF9ag7lI+hjBoMF3bztxwmkrPQ\n\
HleGgdQqyJqEt219ej2G0irp2hoYZRbu2yiKm9F3tQbKpn5M5HfA2CeHrktz\n\
x18FGQGJJLruXA1WHSqg4/nC4U9L438ODUgmTdanoo4S9cRtXHdsje+C3R8W\n\
ifjt/Ikys1owj85R1cI4/yzHzVyqilXJvi8ki7hglzjmtzK9wNoiVMuOrT5b\n\
jwmzT9rRyG4kx+xAAebQ7W+XsCiqKKpvEVmyhbvyOURe58fyPjVNEc7eno+L\n\
lXKM9Y5hMQ0NgvVt4vOzB2RXzSFbTNrrDvE5poIBpKbTqN/CS98udgvvhi05\n\
0lX8+/ZcrtNul7olGztSO6lbpmbd+Q/D+b8kODs4nP3YmFmPKwPCsjqXzYa5\n\
sTUok9lhsrkgM9pQ3q/EgYJ2PB/fiIphHZZcrsbZFjkaxvVopE9ul4wcYAeO\n\
57dibflkRCtVtQ1gec7QNE31OVhH9Uhd3YCMHW1I39yMrFMD0BFRyN3Tiuwj\n\
XcjY2YahXnHZgIRqe18/SlddhKyhH+2Hk1BJD6BpaEXxsliMV3aheXcceguG\n\
IEvLQtn2G5gsb0PFe5eg6lOg40AqutJbCcm1qD+aB1V1B8rXxEFOo6N1fwKq\n\
9xRCUVKHxuO1n4RqQapf4PBluKBfoqrMxcqPKome9yC3bgINXQpUNI8jNb8b\n\
W8+W8z6m6yUREoTOFY/zJSKRt7UYIyorbsfcLdPwcze/cgE1andCM9IrhtHY\n\
q0b/mB6dg2oU1Awj5loz3j1QKAykyGW3cau94VIrbDR2JJCQ85l+o57uniuC\n\
6Yt80Cw9XI6YnD7U92owKjehb1iL0oZRxN3swNpjpbwJjAGwh53PjClBmR1f\n\
uDPvNtGUvEmHzuUNoIyeObNyBFpXNDcAu20+YWHu1mkP9jlG3vhl2+KakFQ8\n\
SLxrDIV1o0gr7sMRsoNLdnNzcfs0ZXCuZHLaK/b/XNRvutmA1CEhKanTasP8\n\
SzWoUjnRPDCBl+OqMTe5ATtLB1FN8LRb7Vh4sQIrstqxm1To7oJOvBZXhct9\n\
Gpwgk72xSh5BfVPPMN65BfV+sxOZW5vQXK4nPheAn5T6QEYfTwDHkvPK6ydw\n\
86PRW1DvkU+idks8BnPa0Rt7Ey3nG2Hq7ERLYjtvtL27F00HCzCckoOJTiG/\n\
pTK3GI1nC1G17hL6r7dgsrAFPcm10DX3oW5bIoby2tF97gbaLrfC2NKK5nMN\n\
n4T6iHFnfG/Z4TKk18pgdgcjuizg96GxZRirSYHO3Z4XgeB80r/zdpWgSeaU\n\
9Ozk0CSW7uQ6ddZ0Dbk+thm9Sp4sNGLPrSYbrma2YMHO3KimZ0MnFxfKZTNw\n\
YCNTtWJv3rRab+O1bk/swIQhskPMp+F1e9FAfs/ecxWYJ4wXYQTvzJOuY77Q\n\
6ksd3DeNkIWxgXECe+6MVrOBs+lSMzomreQGTEXAzpxN2aQWB85XsCKRWjkH\n\
3VOMNoXrn4De+z6uswm9KYNR9L5J6K2h/jxV0Iq384fg9IegMZhwlhwavd2F\n\
1Sk1ONikQIioicVsxptXqpAxZkVpcz/+ktwKGcEyQJ7LwawmLM8djnhtphED\n\
sne1oPD8CN/yVVEzhowjfVCP29CS1I+CONmsGbC9l8+zyEpbMFZCRPVIKprO\n\
1MPY0Yn641W8tebGVjQeLeKw7S8X9iQaS8lG65VyVH8Qi55rTZgsqUXxyksw\n\
jJDLXN5KdbWi9UAyWgg1hmai1/uLCTlT0tzKdOxKlJG09OLDFWhXOKXUmRoi\n\
ZRsPFTLQSvJnEtiU0AlvKGpdw14PDp8rITM/vRzJ/0oHTN6QWJ+gwhsaB8gf\n\
51j81DThL9hfhl69VxJ+W9MA3iCFGCW/t3GhfnC+GWYy7JEqWa6Tm7lt1Pzc\n\
KE+4jevSQ3kj05Z/3sb3Ij0WUyb6TdGn2RLfTsw3LI1Bv9uNc2Sz2QqC26bV\n\
tz25hzu60gzVPxGfW27B5wKiwlXEWZuIML0cX4edhV3kNFXjg5JB1gZ0j8hI\n\
o1ZzB2pxch3eyu6FwRsmdenA+qv1eCWpEWsymvC72AqsKhi5TdSs4UAYXleQ\n\
ZYlGO+Ex88ggLBorMtbWIftoFxJW1KOvcyafuI8g6kDLnhR0p9Si43gaOtO7\n\
YenpRsHCs+hOrkTNh5cwUiuH7FoWitdcQV9yKco/jIORah5LLEDDR/novZCD\n\
2qMlfHK3eXcyetPq0XbsKnqyyH9qb0fenI/QGFsFrzf8STHe6TpzzvYCZHYY\n\
xLnm26AaV2Ll3nzM2xmFCis3d2chaicckvx7O4bJ+clmMJHKMY29/HgtFPag\n\
JK/6ul68uW0m9BhdOJI1NO3lSGEZck5hM6cLEk52FiCn2yx2d8S+h5CT18I1\n\
5zQGwiB1JH8mREd6RrBwe87Hmrj0WA0mLdFNR91WKzYdK2J+XPSRuQotQZfG\n\
+0+A6L/M9OKolZM6C9EWIUMYey1mQGXhMwo8Ea7SgKutEygc0sEdiuS/vh1a\n\
oxVZnTJUjBrhCkgvq3vcHlQQS64aNyKrvhcrcodmRSDqVlqRd7CTbVKMoMGG\n\
G7vb0FOhQNb+AXLFwmSee1CUoRIh+jlRi/otFsgrOqBsHecOW9DlhF2ph6qu\n\
G5p+IUG112iBbVJNdLcTZqXwsg1zT/VEvGX1Q1JaG7/JBFk51dU2yeKUCNCY\n\
Ym9tajvH4fdFt5v8JHwyq7mZXDJiLFLnVlJdc7d+HE/HsoenrYG+jbclJq5y\n\
hhZlIYa0Zt1MYYX8OB1bPkOob5L1XXy4EjJ78BPxOV3VLjpQilFbILrEPuDF\n\
CdITM/TiNHBK9jgcRGxiNYsRSeVY5CC9mc/zSOOxvbHvY+Pn9S25uNqollr2\n\
j4HztunglDZ4Km/sxeJMISAVoZJM0dXFdCL7RB8KDrWhOGGC2JAT2TtbUXpp\n\
AOnbyPnvsoto+ltBdq5RdhSicsQmTbh4rRasY377NM3z5o4cLD/dALM3HE1L\n\
rTdg1X6Bf0XLEVekYa11h6Rg1UDXCOZuusm4PJUjJ4iF2Tbn4kanadpTiZIt\n\
+LhkFx8owzghINK+4c5hUie5M9TJJ0nWYdRj1b78me0jRC07Wg2NKyxJIuh1\n\
YfeJYszZMc0ok8S2XhuYqRn/yZKdUOmRKQbsIlkg2SyhotsA2QDjl8Jg9tk8\n\
mOw0wKDx3Pm/S5RJYPmpBhg84WlTaFNIz6jD69tyZ0j+jV1F6NC4JYn2d45g\n\
wdaZinoOMe+IjYhINOhx42phDy7ndFO5OPr/NsRmdaNh0PIxieYVtc6QKIvb\n\
z91ViNJhu9S+gNOOjYcLWaTob0q0r0WIEc+/RfKHqH1T0yVAv7Kym/Ha5mwq\n\
J2gyFv9ZfrwOlsDUP12i35iuttmuFb0IT5aJSvyvi4qRyX3X+nhab2mwdI9y\n\
EcxQqzvykdFpnKFmikvb8BqJZnq52VQuMqgiy/bbmgY/xjjZfXdd7WVh/2nq\n\
0oejp4t5KOyTRHD7tK69mduC2Vui6vL1bfnI6xLaF3lzSUYO9IYT5dh4upJ/\n\
NpyqwOYLDZA7Qv+vuz8si0Gg8O3/tfuZlr9YLWjvSPfbNTq8tz93hs5gvue5\n\
oslbkB1G/JWZVu3N3Xw0zeh+m1aHFXtu8VFpBCRUy/nykoh1YVbowpUKXt/f\n\
7H5WLr6CunwmRXpzXwnd2ys9B1u54Cfvzx9g3c3+//TMBDhcsfw/6H7i1YoE\n\
BLJ/jVDnQQSbtyJsFKcvfXqEuvcj2PAhQkMZwoZEpgaEdULWBjgHSXQV/OuU\n\
sQbBxrVUdgPCGnGftaAdob5DdGwjQiMZCCsKGRj/1vQ/C19dbdXPkHCIym36\n\
aCbJZLzl4PU+ruOiazZCuBBzKx/Jw8IDldCSbo3MarOJxsTUGq5bI3ExJhGy\n\
ntib0kE6UQ+HNG8sSjDu75B0KICzl8pmlGP3X3akEgpXiG168w8Ooi/fQoZ9\n\
cHZdJ57IOGQA9sYT0KavhKHwAPxWIXmYZ/A69BmrYCw+BtdgMUxlR0l38w3G\n\
4Wy7AJesX+IoYbsM5qKtVMd7MNddJXI9xdvgaDoJ3bWV0F3/EK7Jvs/fAh5V\n\
EvxJX0aw5RQJeh78N3/JNvpBsO51BEoWIzQYh0DONxHsL0Z4cBeCrVcFwKhS\n\
EChbhSlXPwKZTyLYdAyhrj3wX/8uwhY1gfEdqut3BKCzBE62p/cfWYDyb4GH\n\
AILiIesM8LDVMHtPlc4AD6MKm5M6eCbv6EZBfhw7W/Zx8OwrQ2r5yKwvIbdu\n\
jI7l1o6iqE3NZpUlwVt0BnxAtCU6KfE5rrEZoFZ+VI6TGR3IKB9GQeMkmvu1\n\
kGntsDh88AVCM7D7d2CMvde//wQbC/kzmvn2kSroien94xh75JZpMytUp38N\n\
+8AYHFUbMH7ghzBXnIT24k8hO78APl0vZPvugfbGfpjy3sfEjrsxcYYltgoh\n\
ZGjF+PpZmDy/EkJ4wQZt7DOQx7wKc+UpyA/cB23BFXgGEjC2/VGYauJgzlmB\n\
iSM/IUbrvXs6zv6NlNRlshELxEU8bgQKfkFKKR2BrGfobyEpLTLho2kIDdfQ\n\
770Idgh7RkypryFY/f/x9h7gcR1HtjDXluTstd+u1zmsLVtWzrIsW/Z6JVuy\n\
Ja+DLJkiJSpQokiKSYxiziBBBJIAARIEQILIRM4555zTYDB5BsDknGdw/rpp\n\
AJC0JO/73s/vAzG407dv3+5TVaeqq7t3k6JKJgytEpa9+xt/D/9gKvwVv0BA\n\
OcwVJTPkrXzxk8Cs8kaYLZDs36B7WJilL4fZgt+JI2drWDgujSWs5LIyVvwb\n\
P6n98r5CvB7WAr0rGOJSojEptpxg5l2FSO+X+Pny0lBGCPP32ycq8e6pauyK\n\
a0Zi6RgaBjUw21yfCF8BN4kL49AfuRlf8/9P8GWBJuF/YB3qxmz8o9DWZzBb\n\
4ME7OwB9+XG4JK2QH/smjD1N7JpLXdrTUBdcZIfLWr8FsqhnII98Cs5ZMwLa\n\
JkiPfB820RTVoYdrPAf62hS4ZI2wDJJ5MithbT4IydH74NQYb4Wv6g2CpYW/\n\
lgziKOmu4rvha9pI+ukwfLUvwtd6kHTaKTJ2V27Cl696vYCvQPda+Pvp9orf\n\
kb2U8UUzCcIvMrL+T+OLOVopqeET4MuFY+c5dffNJR7UO1FtMLiFKabbMa/R\n\
Iyq5ieXYq7ikEeIbwnwqn4shTP3S9xuj6rHxZAXjZ3wcfE5G//8Nnz/B2t9G\n\
8LmPVMeTUF38M5Txz0J25udwqubgGLgM9eX/gSL6AUgOfQ6aoiT29Gz12Qdh\n\
HGyHPvt5zFalwT9H8Nn/OShiX6Q6/gLluQegvPIWvCYF5pP+G9Lj/wlF3F9h\n\
7q1liNky+JAZVF2FN+N7CKoHaZxz4b3+KHGiGYLRrwk6sViwK+Gvf54+JyM4\n\
TQb6OnO4dTeCigzSRdtIz3aT6fsx6aJ++txDJvFHCEg6Eeh4Gb56MpPmaVZn\n\
eSv/8nH6iRmv9K7lHIqEB1HxdTebwRvww2DzEq/HWFP2FT6xh03YWZYEwk3B\n\
bE7oZZcsC7tRMPvEdffP4MTFJqw9XsEStb8f4CbHufyiUIZSKH/gVnX/Q4KV\n\
WH8TwVp3phEa5/8jdF36I2wT49Cl/gaq7GMEHAecw1cgOfFTuA0mmKoOwTI+\n\
iIDDgPnLj0FdlACvrIS+vxduWwBuoi/SqBeISk9BGfZtGLqqSTnZYSpeSYZw\n\
OxyjiZAcux/O+Vl4VR1E1CLg99+ELl09oeAtUjDPw5f/OJGiAk6jmPvgr/kj\n\
GcGn4GvcS8TLSYqIsNywhjTNKgRmKohUJbFlg+JoUmb3wlf4IGmmi9x2ts5J\n\
+Ov+QATtd/BVPUOE7aWP007U+Uhpm1uOrn9Esm6BroSE+mURvjVHK7D+TA02\n\
nKml+jaE19K1jZG1WHui4iawbU3sg9MvHKn2ZTb8q5k1cjP4laM4l96JvTH1\n\
WH+6Gu+GVYYyQZhcx5UHhMyz8ts/DmO3IPFvnqrFuN778RjL+99g7EVYJ6Xw\n\
z7dDEfkAFBd+D9mpu6GtSGPdQkv1VkhPPgB10p/o952wiIZgKnmTtNNelg4t\n\
2KahjPoprOIxOHrPQBb2A9JUz1EdP4FVNI6AdQqqs49CmfAK5Kf+E5q8w0yK\n\
5zKMcadVsdUF3OQdOIVsJnYtD3dcHvdPWCbLbHxi6iO+lbM4vj6rUHZFaMs4\n\
Zqmsj8qq0lljuBD4mARw6sRIPjoU8gBdVuyLrr4hFFOCw5lDzOGBy6JXhYXt\n\
rK+91MfvkNvg8vipPqeHiUu7XG7ExtcuC52sPsQ4BUPszNqX+CFkHF4vc7Cc\n\
04N5vRUT4nk098lQ3DyN9LJhnE1tx9aIKnZA/8GMymIUJog0JqB3YLFpK49U\n\
oWGKPfExFGK8Ja6o+j0pw2zU6R/j6vM34+riC7COcb560EGWkKixe04ROmqC\n\
hsI7O0xefAs8Bm6Rs9+sht8ubIR6B/wmFbs9PfPPp52EY6odPotJmFcJOubh\n\
mKiHQzrMbJ3Cu4aCjCwYyH4NcdtffjZ0rYO0TwwzUh8JA0Z97LrSB3tgEQZa\n\
qQYbjy0P9TBJY9GFU6FeZv7v6Bhj87WWReTI5pRPLCdVCx4HDkUybGV5YCG8\n\
YJwNLHyNf0v2fF+rHdfzO/H6odKPmptoqBnE6gM3zzmkt6k+dpiZCbbNsTR8\n\
gY8a5juWD3PQgtmkl8g/E3Eh5o+eO2AmuE83Qmb2hTqhu3tMSGVaFme70rJ8\n\
lkQzo8S6o2zW3rLOj62YWdapJtUs1p+4MR5Xhss18mU9EGRj+Ms92Vv1qGx0\n\
Bm8eXt4+Rlb3ZoyyJ/MK4UuDZg6J+QNIKBjkfuhzYtkY5hyLM2W36nV2Jiq8\n\
HiKj75P3OsHDb9EyO/V9JdRJC6Sm3GzTP2KpxNL5tLwBHa9nhCoCSE5pWhah\n\
XH2kAi1S27KRCFDPHSFtuNTaMth5n5nt8QRDI9HWMnLTfB8zL1w1aeaBzfWc\n\
j+pLKerHhZx+xOXSD/M7fwhyi39J2xj11bpsXuBWo+W0mLD9VMUNMzjUw6fr\n\
ISHUCaPVUjeIVz4sZK0y7/viTSqjcNw62Lw0cF06zAWuQ5HYgBfnb/Btl0Y7\n\
udRq5qwLJWSR0Zg8HIbp2DS4jE5+s/BQhoFXVAxL7XEYC7bCNlDPpsQ5e8jB\n\
s9jZEXYNpcBYuA2Wphg4p3rh1w4Qg+uiIdbAUrEHxvytsHaWsqbUIyqiejbB\n\
VBEGn9nJrvq3NR6la9vp/vPklk5/5AwuvcGu5D44lmgDnVKDDcfKbpofeyuy\n\
mV2IIYxCbVUf26vLFCA7Q7p8BpeZcT1zcbkd5MhOPWRWX+gYHa/Dig9OluPl\n\
A1xmPiP3fyOZrhq3LENIRkH7xyKE4Q/JGctnb5kZq8v1ihtG1Y/Y5MZlo8pw\n\
wC1xPXAG8ZEoYfVDyiCTth+qz2u14VBE5RLX9AtcHycOIHTcmM+LgJ24gkIN\n\
H59iEHS7mcOHVwjLSj2zajJ3qtA2ewteN1xqDXx2ot4eLzxkCtW51XRNDfXF\n\
aMjLu9mpmiC3mpCtj1l0xhzg4TWaqe4Fvg9DKLSXvo25y2/DOVKE+fNPwSnt\n\
gj5xFdxqPRask9DGPwVbXwEMV38LXW483OPJ0Gedh7PjCPTF4XBL2jAX9Rzs\n\
PRnQJvwGjslm2Gq3w1gaBWfnGcwnvAXHUCm05++Fsb7kVigM5WAfqkAxL2+h\n\
hTrECK9mtN4wgozZnGQpSijbb16HzSfLls0RMnOd66KaITEtattuMtev3ThH\n\
SOb/YMYIfMHF+oIeF8LOVt8wD1CKc2Xi5cgJ+nA+YXko91ZJLpODIqw5uNyy\n\
MO1763QDpgyeUH1yEZMLefPs9ZnS6WV6eSkSQ/lfRypRO2Fc1n+qGTneOrx0\n\
IvCH7PseyZmE8M9Sk4PhTbvZbQrH90XBpTVBGZsI44CaVUT6wmyM7z0F8elw\n\
iOMyWI6mio/AxNFwTBw4CHF8IXyGWcwcOw1R2DmMvb8ZM1ktMJZnQFnbwz5j\n\
9uIF6AYkMBanYfQwKSSr70YgVuyAXcQd++5sPQBj3WUYUt8hEkm4NfRDl7aa\n\
O+9GlAFD/kV4Jq9BnxNDMjQLe+clGPPWEthegqX+OGajnqTfYbBW7YO5/hzM\n\
+WtgGelk63b1RlLdRR8FRCYY9W5EA8ZmnaGObGsawRs3DCCbzEq8ukNmX8yn\n\
pg7LL+pcliDFiP7OS91QW7yh+pRiFTazCVxLDPXhClSOm3gTIghAEJnZzcum\n\
9Ni0xYhGTBu8IeCophVEmcpumJwvQVS5eBkQA14XTl9YrsIYQBy4Ngi7f/EE\n\
cb/bifD45YmDr5BBrBgxfCwQmf57h9rXJbEsTmyRr5uc1rIkwfA/WbOR2qEO\n\
AdFYnAJJahW7bYb2WjxkxbWQn7sIw6CayWTC1KFDMMusbHB/+sgp6Ft6MB12\n\
Ag6LD9bWUkyFX4ehLBXTl0tILn2YT7sIcVojDAVXIK/ghl99NhLaviloYs9i\n\
rnVUOGczhMLyLbD01rNFbeXvwtiUCkPyXwiZIkLhEKFwJZhVvL6ZfDLOpA4n\n\
U2DIu0jGmjkl8WU4BkvISHfAPXSFUPhz2IfrYas6gHnizebidTA2c8EUW90H\n\
MDbcUh0KidUMat4/14zOGSMzgkIKtJ86vLp2CGuPLkuBZscwfZg9Jl1IUbYZ\n\
jNgZXrFsAoApt+1CG/plwi7st7H9PTwkYckUtWBp0d1X+9nkNqHK/u5xdjHV\n\
Uv3JWrbL3VCYPKHhnp/T4VBMzbIsWoaZX+9ik9BD9YlGxBzjviFL+2TWMDRm\n\
T6ic2+Fg7cDqJXbgNT6bSOMI3jL5b2mG+psnqnClTsJkqAuSwBjF4qp+pvmh\n\
Khmn5dWj1eiSCm7pd2Esuoa5Nm6W2d5RiukrBZBHx8EwTK/i0kF04iScVg7B\n\
yshzUBdUYSY6Ek4XwUQ5AenZHOjykqGo7GbLOLrLMcOgsvAqFFWcetTERHOo\n\
jI+BtmvqJlRWbYIm8gmifBswF/s7eOZlMKb8NyHs1zBXx5FBfptHJUMDE+AW\n\
ZRI6k+EVZ5NRfhnm0q2Yv7IePpMapuzV0Od+AP2V52FuLYB/thXzsU8Tijdj\n\
Nvz7MDXfcu8Hrof+lbBUumyRy+tHKxGeNYDW0TkYrG7YXT7YnV7MzplQ0zKJ\n\
Q/xCl6UpDlziey0GVI4QYEaGxOwqqdWhctwylzXHqxCZPcBOLM0anbA4PLDY\n\
3VBrjKhpEyE8qRlvHC5dilumWWtO1GFA7QiFAtxWM/YwohBSt19iQx3vn2tC\n\
bosUcp0DTrcffurGALOXpZeJxLgxI5lDdskANp1aLkbMK6wJq8Ok3ht6BhPj\n\
yMntYFZd86rwi+zU7PrIRqTWTkM8a4ODOdjH7aPf1EXzJtS2TuFgbB1bbklU\n\
h9GMyY1KXj5vhrYwGsyrMpHuNfySVoYwb45pRmqNCMNSI/RmF4wWF5RqA2pa\n\
RTid1CQEkJZZpy0XOmH2Cjms34OpNA3jR2Nhl8kgPXkEqtp2yMPDMHE8EQ6V\n\
CpKw41BVdMMlHsX4dvJheoYgPkVy4CAQyscgOZMJa3cNxg6chW1mhuo4gOmU\n\
epiKr2Hs4HnYpRKI9x0mrI9BcSoMyrJ2Zpv5myjBLqqlmLhpJbxC0Mikgm92\n\
DB6lCD6jhotJuq0EbT0C5hnio0x8JgifqpuUcSX8Vi7pldk5zzVeA7d8YnFv\n\
bb0ILlEH7O3h/4gSfIrXIa8fq0BkTi/eP8nmbnyKn75iprQYaXg3rArvhdew\n\
q9WZYPIqbqpr6dLUVWTcC3pnF0Og1Iyu9jFiZ8wCx9DSQGGxKzOqa8OqPsUs\n\
gqfLQqXsoutFnDCqjXHby4a0yxYcdJE7/trSpVVfCK1Ie+tkFTZH1+NIYiuO\n\
08++2AZsPF3F7hfwKreyccWy9VXVUjZAJQiql8Y4OqlxyYKxz3Gzd0zdJyqZ\n\
2Dq2RddhQ/iSrlhCrphs4Y0EN92S2eabYyXcYuNdl9rwIbFwui70uDBR+AYN\n\
CLMNAdPzSzpHeApDzRj/vXBAx1MVAnVZJqZOREMccRbSlAL4nB4Y6qogj0+E\n\
irxYj1oCydnzbJm55mEEXWbMlpYyez2TP6/BXFkHsTEvdCW5EJ+9CGVqNvT9\n\
UtZATByPxEzUOUivElwVYoxv2IyJiKvw2P3LQP1pOBrPwimTsH+F+pT0tqk6\n\
m/1LIHTuiWuwdFSzf/3j4OXtTEwL9TMWDHRPYu3hkiVa6rbQ7Co/EXb7kq5l\n\
4JjfzcrPF5YAp6drEu8eY9YblLGlb1u8jyMEjLtePSwsRODW3ubnd2PV/mKG\n\
y97Gt0pYzs/o2FXcdBy1mK7eFmpaGbtolVmOZfEGheqcNhuik5vYnStCS1tu\n\
XzZNzL/MisVWEfBIFfcp7B+x9PV2tvVhRWIoJBpsDytb1KPsO94RgnwxTuSM\n\
whVY5LiG/BRomoaY87JWLF3Txf1jzoMLcjbgDjaKL/zTZcVDXtnFFBUGcDYx\n\
Abp+zoW8ARcMCeMPdV0kzQsB9pCupbhgPE7h2lJc7GH2/zzE7v9JNu4zWEm9\n\
XsHN7GN4cAabwyv5rA1GjBYHgenpdWSh6sYM3C4Pt2NmRoUjsbWsnAkT9p8N\n\
jUQZ2+NM1unh1D6I5hw8W7mDxUJj8zi2nq5kq2XnYI+Wf37JrWyk6HglYoon\n\
oHcKWdu3k0/pwvXCHrzBLivl1jZ/fglcmSzL7Rc7MKS0/ePV+p9ZOvMKFY3z\n\
vrPVQqoKdeoiHWQU28nsYRicAcG8uskkOTSc9yxsJOSWiGBT6Jb19QI5Fgvc\n\
ru7CEC7dcfh4QgNjCaj4+xG19EzGKtSLrSFQGPVmZBX3YUNYJatuucAGIx53\n\
sILCBinpLd45XYN46iSlwf1VtvrPkuZ1oaljCkfi69ntTv6+n1vHzslYmbD1\n\
yUo+cEbWAyfT+9A+pWdyeb/CD5LZaEVZ/RjpkVqW7r7CrSy/jW3DZ7g28IvM\n\
mZyy98JrEVs4ijGlld/WkDs3fGJCiTOJTXiLUbT8gvTXWDXP9DX3Lsx1Bj/v\n\
RzUiu1kGszuwdHON5YP3+WWDx/yzUktzygaw+XQlP7Vfymi3pb3F7SRSznKe\n\
gg4lXH4Ig+GxOGCUG5mDwYQ9zoWvmPZ7iOC5uAk69v+bNyv/PIwGKxq7ZpBU\n\
0IcjF5uxh0zlnguNOJrUgaSSUdT0qTBndn+Nx0LA74dcqUN1uxjXSgYRmdqB\n\
o2RhjyW2ITK9B9cqx+kWJRR6JyPoXDj4S/C6vRifmkVR4yTisrpwKL4Ju8/T\n\
k2IbsTe+GWEpHWz6fGHLDDon5mGweVcI9zKKQCrTooTujb7Wjm1RtdjITnCz\n\
k9zYHFWPY1c6kV49iTZi6GaXfzG09jGZC5/m1Y7FbENLjxQphf04dqkZu2Ia\n\
sJvatjuuCeFp3cism0LXlA52T2DF3bw4a7snULClEDVhtSjeXozpfj1fH2/z\n\
/wOBgAPeAHeMVSBghy/02Qafn//MHPRt7IXOMrNI2uiazTUHP5X3+vm5YmZ2\n\
0WehXl3gUrpvYxex+vwBdmP6QHDhO/xlRj8zXzE/9PHbguZiNrylkj5fIHRX\n\
MMhX9hlWLzMegYMcGxs5IIyTw2yESRUvrqL4mO4UsqEWG8Y9hlq04vu81mHi\n\
tl43H7v1eWEQa6GXmXmzQG2g5wd5oPrJg/D7gpjtnMZEkxw2nR3Tpb2oON7K\n\
zlV9anl3K+Sn0DSZzt4qmtyE5slM9vPUxPtomcqHzz2FuvYHUdT6Agob7kLT\n\
+Flm+Sw6+55BXvvfoFDnoLF/O7dPnk+K8va/YM5qOvsJ3/4e/g3nOkfQnC1C\n\
wGFHS1gpSg9UonxHEZqShuD1ONAc24T5WW5PveGL9RhsUcOhnkP1vlKU769A\n\
6c4iVJ5sYaLoN76hXHYU9eNX2Vsnxt6mz9e4z6Nv0ZvnQj7zIQra1sBNHe+y\n\
NSK37l6ozMxbPw2RfhIWQw5qe97j31CCkqbfYdZi+D88coKqenafRW/lNvjH\n\
Gvf+ky8+2z6IpgwR8YgBFO5tgMsZgEenRekHhZAOKNF4rgFzau7FB8/VoK9B\n\
ir7z1WhMGWMP6JrMakPp4SZ2CfpNL36MXjaNf/F30DCRwb/4WhrmXEzStcap\n\
HF5+vKhv+w3E+k40dDyDGaMcVkMuvfg6/sVlKGl+jl5c/1UBtgEDPNd/B29H\n\
AgJT1+FOehJ+xXRImTKHiBJFXggumXhfPPVkcdkLYze5yyu+I1xj7uP21ly2\n\
IcWCx0NOnfsTy9ayTs4UQVrQjoZ0IcIdRDuZwommaTSS2pqf5eZahmJq0F83\n\
jRbyh6a5ZTFwEGWoP9l4K3Qp5EdR1LWLVUOTY2tQ3n+CvWVs5FVCVw4k09tR\n\
0r2TTT6GX0Ma+SFIDMNo7PgdJCY17MY8FDY9BguzcbtrGAWNv4bW7uCU4r3U\n\
7xb42g7DU7oevu50djewoLIGAeUUgmrm9zQWTMOEvHJ+GMmo96UyvYSgph2+\n\
5oN0fxS8BS/B29eIBWMfvFUb4C1ZB19nPDsiC5YpeOtIhJUSBOUl8Ja+C2/Z\n\
+/BLuZTkoKwEARU7z4AFbTv8o5yKCCrL4C1/F57yTfCL+xYTMJUDcKSegmdk\n\
OkSVgwYxHBnhcHcLxwwx2tMFd+0VmMPehnH/KphPbYK9IBUBMmTC6Sm+8QZY\n\
Y7fDfOJdmCO2wVGUgYDdE9qt366FM/sMrPF7YS8v5po1Ownb5b0wHXmdblsP\n\
e1YS/CYrdUsxLNFb6BH57KSjq+QcHMXFzEySkDDLpGS6is7CUVrCYZL9OxqO\n\
srLFlLTb2Dx9d20iHLmpzCpyIU/FN9UCW+wHMO1/lR6+FtbLJ+Gdln5aeF16\n\
kKc+DZbwdTDufRnG3S/BHLUH7p6+RRL/MYAWJgDhN2JhbDeCHa8hOB6N4HQc\n\
FhwyLEyHs7lOsHYhKCnlhkyVRMPWwX02NiPYQ/d0voqFmQIu18pK7qukjK/7\n\
y4BzGsGBjVT3KgRHz7MbVcMjo2dEcHUz9Ujpun6QdICN2rETC6L8T98ga6ra\n\
PpQea+W0R8CFmr0lmGqTkBxVkNnnjlXrCKvASLsSPdHV6CjkFvzMtY+h8mjj\n\
rRSakmxVSuU3UNP7Kgrrv0kM44eo6XkZ12u+hWFNLzwkP0WNd6G69zVUd/wC\n\
RZ0bMCO7hOvV/4aKgYOYnctHTtUXUNr1Z1S1P4a8tlfg9PMrse8Ha+yb34c7\n\
bRX8w5lwJ98F32ADAn1H4O2qQKD/MP2uIXm4Dk/BB1xPuCbhvsrsgyyBN/eX\n\
8FQcIDmNgDvuB/D1V8Nb+Ad4ak8hIKmFJ+Mp+Cb7EJiIgzvlBfgnsuFOfJjK\n\
Z8PfFw1X4pMIGHXsUidvdy0H5olYuPPWkPyMwHPlZ/D1ZME/SPdfeQYB3XxI\n\
vnyd6dD9+fuwZlbw176EgKge+pU/gjmBy1VndIk9dj10K38C/YbnYA7fBOPW\n\
X0H7yk9hPLwDfqub7/Fvw9uaBv1bD0P3+mMwHXyNyj0N3d+p3JEtNOacOXJX\n\
nYfulR9Dv+YhmM6eRtCsgXn/c1TuHhh2/A2mw69Dv/Yx+vxnGDf9ErrX7qe2\n\
EFBdFpi2PAz9pk0IeoTgIkmfWwfTpoeg37yFcWa5v99/EPotWxmJ44p9nT3/\n\
2nLod9Ct/TPJJ3f+hbflGvRvP0TNfRSmY+thPvQ36Fb/lMr8Fq6+cV7hL8Bd\n\
Hg3dq3dTs34B89k9sESsp/segW7NE3A0tnwEB77nJjeEMSDBoTcRqPo1yUM6\n\
gs0PI1B+JxZ0bQjW/Ig5JQ2YJdtYv5kr3fccyWoCQUZM9/yE7iV5ksTQPT8g\n\
tduMhdnLCDZs46r2E7lreRzB9rexIM9CsO4uBPuJVNm6EKi+i+pm45tU5mEE\n\
p7KxYG5EoISIorx1qRw2pE3CZ7WgancRas60oJGcy+IDTbCRA9NwuAj5H5Sj\n\
+Vw9rr9XAJXMDtOYGEVb89AY04KSLXkoO3ELRvU1OB0zmDeNQapKxbSmHnan\n\
AiJZHH2uC+1w6XSKMC45jXH5dfK+ArCTRsqv+x46xDnQzWejtmstZCSPI9QD\n\
BocxFIyjV4Qn/VdkfLhRC861ISAbhX/gOLw91QgMklLtqac3zYen5ENeCEVw\n\
p69GYLKUhPdvpAl5vNe9Q2UrqGwHGbA+ErIYeJJJ4MZJCMdj4amKIGGMh7tg\n\
W+ic4MLfwzfUBn/PQdZesk2YSqBHEQEcuQjXleeoaT3UpA6SuUsk95pFGSQ5\n\
1q+8G7br1fy1exAQN8Hwxv2wXEnkgZrMyp/xCNU3r2MV8IJ1Ho6LW6D96w9h\n\
Sb3KK+ppkoUnoXvrN3B29HEnBljnYI9ZB93L9IyiMq6bM3ZBu+oR2Bu6WEXt\n\
68oggP8EpjNHyE66GbcJgdkpWE6touskv2EHOGblMcK84ykYtm9nZHBRBPUw\n\
b/85iexOXgTp7w+ehGHnrkUR/AYrgtYT/wP9xr+Tal8g+Elg3PIUdG//Eq6u\n\
Tu7w+IAPnrZMGNbcA/22VZyoOmfprR6F/p0/wSOShsTSL2mHaePDMOwmyfcv\n\
hMJcn0QKfXqStkexoOB2toKFJKH2QZLCTgTr7+ekcO4KAk07uMEc+BOCk9ew\n\
oE4hKfw5WT8F8TsFSfAlspTtWNAkkyTv4eqytpJUfY/KDlDTlViYK0JQROTH\n\
Qniqe3hRCtufIuuYR0SMjET1Y8w6LG78v8hKYf1V/rhkkwVTFeOYqCYuxGzp\n\
gQB001roxHOYLB+HclwvJCybJXOYqhZhXqyHQWFessSUzyRjWLEfw1NnoHPZ\n\
ianno66XXeEmHFrNylHar+GX8XTX78SC004ycGS5HCny4CnawsuRGO6M1zg5\n\
ylxJJJK/tfNDeHtr4e89QAbrZ0RGt8M3kEnvSQ4zMQRPZTjJUxzVs0eQI1/l\n\
arJ/LSRHB8iWVXNdL0okOdqIwFgCXPEPw9twCt7m42TLHoJvpPsj5OgzS+Qo\n\
me1yW/hfSdk/AdeoLFQG7nnYrxyFvTifk7XGRNY+mS/FhIIWQVU3jO8/BVNs\n\
OCc/mSQ/qx+Ds5fbTcrbmkL2605Yki7y93yW7umE4e37YTx1hIs2/F/IzmeW\n\
yw4V8zbFk0agViYnhFivu+4qLJdPE7adNCizsCXsh72MPw2BXE7tFEzbfkGG\n\
cjX87uA/JS7eWRKXnxGUZfyQj5GBevgGcblK4rJzUVymyJ9QkSEr+XcSjZcQ\n\
YH5qyID1k/+gobLNW3lxaUKg+IsINPyJrr1M9T6CQOtq0mXt9PlRJqGVq5Oo\n\
WVCUS+JSReLyCPNMYejn2ofQkMptW8JvXvs1/iu/zwyTTbkkj49hbEH4qlbC\n\
nU9MwiiFt/gFGvUcBIZOcSAfOMoyqaCqEK7Y78E/1cwC1nX1f0hnaUhAfknu\n\
awZ5MvVwX/4Bafw6eIueJ5pOptgogjf/dTIcIvi7CPgFW0nrV5IAPEj6aoC8\n\
q2q652745dP0/U5yf/9I10apPa8RCzxNb91LDJJcYlE3u+jcnUBlVdKPQPln\n\
b0C5D5a9zxI9+TUcTcQeR7o+Bc9wJ0HIM9JNPz3wjE+wBsRdFgnty/cT8Bv5\n\
qv6D7ZqAUYuAxboc6N0ibhDmhmHc8AR0bz4Fa/JZuLpb4FPKyaCNwvje42Qo\n\
DnNL//8vwP7Z5WAnT8BdcJKlkebEc8wbcC90G/3fBc8oEfihXgTM9tDdzDto\n\
ZuCqy2Q9OuOW39DdZDzPnGLcs38K90Hyh1t/SVz+NLs6ZGGG7GPVfeTEdBC5\n\
updUHelONWG88X12pUiwl0Zz7DJgrEeg7MckH+SdeMjUND9ETtE1kpF0BEqJ\n\
5GlHOIepikjcdBGVsSM4Qiq0aRNpYKIZpUTKlJ3MKcFE7kjOJNX0zCJ69kOk\n\
jt0hMNipn/TOpbgPHRxsU0N/fQfU8W9BWxQXOpV9wTkPQ2EYXPPsPAQ809Ww\n\
jo0gYBiHuTmflRMuTkJvaZ8hr/4VwuND8OS/S3Ua4O8/RrJRiQC5gf7pUXrD\n\
LvLmN8NTuIqwTJ5GHxcZWtA0wnOd7HX2anir98A/M4mF+Xb6+/ekuX8Gb30s\n\
vdEoPJm/IK1OsiGeIGNwAe5rj5OX8ysyHLlsPYHRJHgrtsOTRfel/oFkQcJd\n\
n84mwvdb9twv30AhA+ibRCSnhsf1V6m5zYsiQgbK8uFvoXvjEaIUT0G/7pfQ\n\
v0t68V3m91OsA2PYto4AubBERppCyUNLZGJFyHCN1MB88K9U38+IzpB8rKG6\n\
1z0J/Zu8AVgqEzt2MHWv+Fih2LX7JqE4+aeQULjyjpFvdB85JfSYdU9/inkH\n\
agn7NmuZFhCpahvhUDw7AWvUu6QUHiNJuItuozfc/ByZq7Pw60zL/JfIuGo+\n\
EZo7+G8lsxVwztLTL34M6CtZfyJQ+xuC5J2k1gmi+j4Sld+ReiZYNzxGEP4m\n\
gt3bEaj4HvkqBFvmLPPJvQhUPkIm41ek2v9KDMoEzGfRtXs5f0ZK7qv6Mv39\n\
n2QOfkd130OgIW3lGKJrVE/NE8SgnqLrZIq0pEzbqJ7Cz5OPlMiv3Fmx4qu8\n\
5HqgvfwSFPFbYestgyr855gt5LZvcA1ewdTqFVDncBFda90haArz4J0phZJ6\n\
KcgKEFjDD58TwlyBv3sfqf0y4j5lBGcmyCUctcicFbbkUBb2hMXgkh67gzul\n\
0ecO6ZXAMGmysqOLY+tmz3IJ/RPmfQNehouHamYsf4A72kUIm3Fo/yls2aUh\n\
tPsnKqF//W7eINAbHnuBXIKn4Ghtg1c0Au/UMP0ehXekFsaNT0C/9V22gZ7q\n\
C9D97SewZmQv0iOyvz7yqnwqLrPyVuhnct+CNjP8c3KqswPuxjzYr+4jF/++\n\
5ejfSdh8fxUCjsBHo387oX/HZubvxRibDZbDv6PbOf7jqYpmPSJLYgy84rFP\n\
Me9E4+UllWQ9vxbalY+TA8Sk/wZhj3sX2lfuJjfhdTiK08iCEHIcrsX0f58H\n\
ienNzOwWtWr7uQa6tiWyFucrJEIJ+v9OliguGMYI4eRbMsqf1CEI9WzIWhZJ\n\
0vAqdQ8p++5nEeg9zMwtcWNpnSDpGAn9zYQH4bHR/eTKOLiQ1oJDTqq0n1QT\n\
t/kJI/hw0XduLXfdZWbxtqC6SJJCBsRiWg54pjL53oegrcyGY6IDZsaHaqpl\n\
b9Je+hOUl96GPPzvLAbtzScxW1IEn6QCqhiW/68IzUtIiwncYwhKSL9PDYSO\n\
nnNqETRxS2f/jS/q67kO/eofw3BgE42oP3Q2NsOfX/5JCHyuvEOkdO6FNa84\n\
xFj8o8UsQE0RHDcOTNWSer6HVN468jj4rUWIEs40kc56AKazYVxV1z/ksNcv\n\
43vSTpR+FYyHdjD4DWHFo4Zx3aMwnjy0CL1dv2bDPPaKqo9E3o6niduQ5uyf\n\
Eoot2OTkZT7BAdfNHATXSrz+ARgPbGUOh1wEqAGWA7+Hbu1v4FVbuFNGjzwP\n\
3bv0t8ocyq0gAFkiNsBeWxcK3/rZOTz2hwDI/L98ApkTdSrtJNbd+F8sIILN\n\
z3Ks21RDTOPbCE6UEjs5QWz7p8TSB/kp3U+zQY6g6DIjB3w9/8rPiZg5/bXg\n\
R1A3Qj8iIV+EBILYyNwAvTmBz23kgM6sjyUld/ty1NkJdQfugvLyZmjzT0Fz\n\
4c9QxO6EzzAJ2f6n4VRJoQn/DUzDY7C3nbkJdb9ka3uJoJTN4kH36n0wHd0G\n\
d2czPO2FMO16hq49BHtVOycV+kmYNjMxwZ/BmnmZJH8C7tprMG5lrpHIt/fx\n\
4uOC7ewbpCHuhSnyCDyTY6SYGmA+9Gfy7e5l4yC+8TZYz6xk77NeuUJlJtne\n\
cCSQuiC8WhLOw6eQEWsfhD1xG7XjLvL/Irn6BUSteZBoxJOwxO2Ds7yY+oOB\n\
1M84E78UUqvJTq9/AY4ycpuH22GPfY8NNBqPH+WC48xzL28i5ftTmE5sI0bb\n\
B+9gI6zhr7NaznQukp/tCsCRuIXa8iC9fwr8ahW9Rzvxgpeh/eudsFXU8KsU\n\
v8Bm9sCp40yPy8BbK/rPSpzUNs+ZKdM4IcHK71z2r0xiGrxVRH0MevjbNsGT\n\
+xK8Bb8nbbuTkGCHr/4NYoJ/Z1mhJ/1B+DrIePfuh2+s/AZkMCRrPva3UCWH\n\
wTMvxmzs76FOT4Kt4Sikp97kZhDKPiADfRiWptPQFBfcAhmfI2TkEiF7jHr4\n\
GEw7nqVeu596hCjM6gdhCttBiscTMiWBadJ7+15gQ7VsOUKT/r1nYS8vXdy8\n\
6x7SYwpiQ2/zxR6AbtU99PsRmM8eR8BqgmX/H6B/4yF67OPQv/YQDKeOckff\n\
zQ5wAHqN7nn9QTYwrXvtQRj2vAXPjHoRGLv/m/yetbBGbiRF+H3oNm4k98RA\n\
gHkGhr0f8sCgv3f+F4xHNsEa8Q5XJ9OOlfcQwXse7uHJUIaQQ0+Y/ICa9AC9\n\
qW7VfXRNt+Zxau5hqtYRentGgi3H/85V8/pDLOZ0qx+GOZZey+l7OjTEWiLU\n\
7xJHKCby/SQRfwMJuAy+5nAEtZPw5j1HeneErJaICPwLCGh1CBCP842UCEMs\n\
+BgBksbZiyshPfQrqJOOwGuxw5i7G/q2Fk6NaHqgSdkPS0cuTP0DJK2lN4wv\n\
aVe7kaUkQSfpIes83O0lJNHZcPe2k/Pl51TW7az983RV0FdZcLdU0UsYQuee\n\
MSdje3ur4CpPgbOC7PvQAC8sC/ArJmCLJReIhNyWX0pN0izSNnK6GCFz12TC\n\
VZ0FT38P6Q2vMEnIyAcTTvYpZtlTgJmQsLu9nY2DBuaUXByW1TV+0hFj8M3p\n\
WJnzjrbAXUfNbCaaOK+/nX8D31Q3XaYXq8snrjLFICoUuFkg19JD1buq0uGq\n\
uU5O7Qjz9F8tHbJKsoxD18h3+gE8pW+Sz7UGnjziQrOTCEwmw5vzB7pG0plG\n\
5ENnpCHbAd9oqTBkoTxD3xKSGVz4NN8ApjXuiRKYB2mUREVQRr/DjNLXBfMT\n\
DEKhdkI+52E679c8Mp1ZRAVXPgxnr4STeraoj7RBJzwTk8wgrGIvfyWEOsai\n\
s6hTMpyIiqU+yXZmYDia/W7BMEyuHqFOM4tAx0Zy7XKZdvIZV8LJT67RQhh7\n\
yU3WTsBAYAlCWJx9G0Hdg4gkCd45MY3yYaewKMUxZ4R6VAGdzMDYVm6Qv8oO\n\
skWlw+yEhj0vMuDzwWV1cyfEuj2hzwxonAYrzGoz8fEFcgvccNnY3gil8nks\n\
Tri5pZehnK8F4qq6KRWUQ6Rz9NzJoGZ6nlln555lcjIpOEKIzqbWQd4rhqR7\n\
BiatQwhVuIsjyaT8Fe4xWaijF1w6Lii+dTMTYQmtzmfyejw+fhfGf3zN5/XD\n\
7fLB4w2EFu44bT7IJQ6o1R5mQoZ7B1Kz827MiInNOLh8C783CKeb+8wcFOTx\n\
8hubOQLw+RbYXBTG/WHC+U47d3ZhwBeEg7/f5/ZDPuOAatbDMRB6loMvx3xm\n\
6gmRHwY3ZW8iaLQhMBYNT/YzBPXfwtt2npXj4FQcd634r2x8OajpJ8P0I7iz\n\
XiY9LxyFHFq5vySdNuSuLdmoMnSqMlPQ4fChuFiJD+KVsHiFLfMeYXtTWtmJ\n\
7LeTkfN+OrLWJqH8TAOsVi42P5pWi/Q1ibi+IRW5W7NQcTAX+YeqwQRgZoob\n\
cH1fJbO3NewiGQrWJSNrQxZ0OifGkkuQc7Aabv4IUL9Zj7ItKcjdWw6Hi+u6\n\
oNeFrrOlSH8jCXmb05GzJQsNZyuR/VYSaq/1QtMzgZx16dDqhHNEubZmUvmc\n\
TRnIez8VGWvTMNwgC6VOMsm/fh/zyotC7LUS5dlLFP4Kw0w4GH6O7XBxrwSF\n\
aT3IzxqCknkKAbyzcgT1tXJ2xaug0lQE+vwr7bh0pg4J0U3IzRiASGIRvlZO\n\
qpCXzH99tgl5mYOYllkFp9NMclCW3o3LUXWIOVmNOObsuJJJ6C0+/gn3QTpo\n\
RPSxGVyMkeP8KQmuXpuHw7+AyTY9zp2UIP2KEmejFFAbAhC3aXEtlztvqD1H\n\
g+YeOztWGYkK9PZYkXFZgZn5ANw6F9LjVGBCasoRAxIS5+G0eJEWLUFyohLx\n\
URKUNVqhk1uRcF4FxqG3aRxIv6SCI5RSOA9vyatkj/mlIsTBFhxG4dVYQm3V\n\
cJNdzGYMLW/D2xTFTMMJaOW4+zdZFA4O0FumKnD6qgJpNXoYnBwSjPNOpOSp\n\
cDpFgZRqHUZFNiTnqlE/6cL0uBkV9FZC1tTEiAmVvdYQ0iVTJqw9OIV6kbDN\n\
/aOwimaQveYSai52kSJ0QNM1goxXL6I5awI+sxb5715GWXQrzFoLZDU9yFp9\n\
Edf3VoDUCsSFdcjcUcYsFoS6oQ9pq1MgHppjcwsH4wqQtZtMGx/7UDfT969f\n\
wrXXkjHZz1lQ+4wEWW9cQnvhJDwON+b6JlH4bhLS1xNvMJMCpbZkvXEV81qu\n\
Er9Vj9w3E1AR3Q6HzcuGQXtiS5GxqRBOV4BPzP0cPGYz4g6U4OiOYpw5WocJ\n\
OY2rx4nEA0UIP9nBpPeGPNKpjkmc2VWIY7tKcSW+HddiGnB8eyFOfFiJ3lGj\n\
QAom2ia4Yrv5YueZYgU4ubcS/dxaWziNRiSGlePQ1kJcPNeC4qxeJJ6pwdFt\n\
BbgQ2wWz4ODeA7fFjdhjYtS02dh98l0WD5JPzaCo3IC0C1J0jblZGW7IViKn\n\
0oyplnkkZnC91pqlRlMXh+PUODl62i1IuSDD9CyH49QYJbODFRRDely6NI/x\n\
1nlcTJpjkrdhVthwIVqG/n4TLp1VcjhWO5Aaq1zEccAMf2cssTJXaLPj2Wp4\n\
Ct4iN0y/HKvfwnCPDuuOTSG+RIuqNh0+ODOFQxlzTBovElMk2HxOhvIOI5Kv\n\
MwuLp/D+WQmGNV5UFytw8JoGfGgEZQVyHErVCIcdo7pChVf3U6fns6cpfpqH\n\
60xpI669kUGKc1HRjWU1o7uIHE2FGrnvJGKE24yX/a4rPAeZu8sW4bqTg6uq\n\
sQfpb1+Hzco9kIXrngrmMG0GaGg7cR1Fx8tQezATlTGdrEg5ZTIOrjkT8Lg4\n\
PjVT1Ij0d/PZ+1i4vpkSgiuzXcxM8xQsJg/LKUyyObScziN458PuCITOT/ST\n\
KvUFuPRF4ZBYi1KF8D2FuHCpHw7qSsaABZwk+sdKEX2mC2RKQytL3UYT4o+U\n\
4gQZmP5RPbcpFjE3cZ8YEYTZ0yeaYHAvkItiRNyhUpzcX4nB8cVy0z3TOLOz\n\
AOFhzYzBw1BlP/ZvyENBoQguH2+AiD82X+/A4S1F6BjQhbjP/LQJ0REEpNDe\n\
SP9J16xoazYiNV4OhZFDlbh9Hley9Jhspt/ZnEJuy1ajpcfBasM0KttNQL4W\n\
JyOFHITX4EYagZIZDtUIB+TB6lnkVXNLUUD9f5XA39JkQOJ5JbsdhmPWScLD\n\
ApmP43JpoPw/IXNcWJXBBFQj4mdw4ro2tPPXrNKK+LxZzBFlOxwzjchSY8jr\n\
ycqU4UQWdy53dYkCxzNmQ2itJDSfyJxlYRIgLBy/IMa+i1JsjZZCblnczWcq\n\
qwoZO0vJri9uxeuSK5C7LpG0tT60cHLsagkyd90Ctk0E27euw2L0LYMtk+zt\n\
1qhw/a3L6K2WQVHXgbR3MmFgyvk9GEiuJb5yBTlbM1BJKqrqUC4y1xcQnVuE\n\
rVbnFkJ5bvINe5PrUbg1lZR2IrLWp6G7dIphdyuErEanbQqNQ0fQNl3MbDIu\n\
AEKqKkBl/3GItJKQozanbUJF905kNr6BtIa3UNoXgXmrDjOqfFQNnILGyilQ\n\
u2UQDVRl82QhfKFx82NUnISSzh0o7NwHiV4unBhlUXEycvnqaMjk3VpGPk1E\n\
YAzHt+YjI18Uoiqj7ZMoyhmipgQw0zqKY/R9VuG08PVIG32dOwwtsWMRcXOG\n\
ycwafcL7M8s0uop6cWRzARo7NMKD1GMGxMSyeowf9R8wzUJ6jASVTVa4iQJW\n\
pshZrS4izRwZpYTRQozzshwp1/WwmT1IipFhcMiOKxEzaCQBmRVbEH5YgmmN\n\
D2MkQInpOkgH9IiKVMBEpHluyoLzEXLiDCZEUDkx6VfVKCkFYkFk+b62FPff\n\
BkM0j8ZNY+dFBRILZ3EpT4PEojmklM1DRS2prZvFupPTCEtV4VrFPMITJAjL\n\
XMS9gPOluGdV4YQR750UY0Bkxb4oEXJ77CHcz5Q2IeWNTOh1npCsmcQqaGb0\n\
cCiUyCP8jw8L+P8JpgXML8X/AsMiePyb/Mvw76XulpY049rrqZjTeeGZY2Qh\n\
ET1V3Kyh22jF3IQK0lYRJisGUXM4CxlL8J9JLEMzy1OVgBctx7Jxbc1VtF7r\n\
hLRLBuOsmTlZXHDXjPMViM79LuLqdsKzuPdkx8BmHM68E7XjTStCZ9cbWnG5\n\
+GGczvsxogqfQHz5rxCRdxdiK/6CpKpncSL3AQxquNymeWUmInO/h3Plm5k9\n\
I9l/Bm0Fzhfei3C6Jzz/SfRIB1bcKAAJV0ZCiXS3FoDbMEBvfWwr9Vb2CKbG\n\
Zj+NyVENSbpofJY+zcJGTs9A+QBbJDtnlCmygivz6VAZi9UXSsZ2212YGVGi\n\
rniIpUwndhTiyO5KjM1YQzJnkFkRcUwKnWshZBuUE1YMTjgxLyYiHSVFIunw\n\
+Asq6CwByPr0xJtkSKQfhqSkJykRe0aCi8mzMBq9KLgix+VYBWJPS5CSqGLF\n\
JDJMgpYh8qUJAVXpRNTJKbgQIUVjux1GIuiXzshwOU6BcyckKK1amhl1O9k0\n\
Hfmk5L64pfC5FAxtDXXXApNsbumFw9RNfq/zs0tF6Dtg1vIeIxW/N0mFSiI3\n\
5W0GZJVo8Ma+SXQpPfARbruHzKgklySzbBa7I6ZxijcdNaUK7EtRw7dMhLjv\n\
cq/LsCtJzRwQh/R0GfYTQfIIO+d+HqZREXHzeLSkj3B+vF6H0vevoCquCw6N\n\
RpAirvhdtxQiN+lVWW0XcZ9s6MheMguZWCEiuuuyOVG3JxUFJ+r4Y2F8aDma\n\
hfxjteyKppYDmag+3x4yeqMZNUhbl0f8hBGiUWSQa1AZ08YEMOBz2FG5+Qoq\n\
iAdzKd0edJ3JQ1V8J6sahX42aasRW3gXEhr3LZWkrqEdOJlzPxomW5alqHQO\n\
fIDw3LsQX/MmxFoRHORUSVUluFr+JCIKHkRE0VMYnpWxzdOqckhyfoq4qh0h\n\
aZqeDEdU7o9wuWEbVEYpdYf3EwlTRBfTulCre8sGCPFFOLW3FOH7yz6F8H1l\n\
5EvQR5z6sARHyCcaGDNioPIWxb60rFgfc+DZQgD99aOIOVqOYx8U4tCWApze\n\
X4HEC+3oG9IuwewXWZxfj5MSH5qFas4L+aQFUQenUdvFLWFjDm/W673CsT6f\n\
YkH9RbjsftJ1C6xnaSXPyuPj3pAJaTGrv6wWP6vTmdstVn5Kj3H/F2A2eGG1\n\
cdWxLJQ+et1BWEhiFw8u+iL0489D3PxNSDt+BEnbDyHrfQ1ulw1BzyTUPU9g\n\
pv1XkPc8g5m2J2E1TX/mBoli9jvKVWAzya+SGsPwtuoqNd4hWVfT09sa1Nh/\n\
Vc3yUyYqmZ0lw5FU7nCy+nIlXj82jdJ+G6zOACpIosKyyYG3ebCH3JHkRs4h\n\
HyWTufa4GFM6vyBRTNRyOLUOqa8moGgvUd5NV5H2dhpmxszwqpXIfvMSxoZ0\n\
AgUU5dUgdVsxPH5OorKJcauIPRdsSEb6G8nI25UPnd6JoThiEvuqoO6dQPrK\n\
eHQWi0NrMeTVHbj6ciIUMhvkVZ1Ify0BhXsL2XBR6uoE1CX0sUMx3z5MdSYi\n\
b3MKUlYlYbR7HtKydmS8noTSw0Uo2ZGB1DVXMNqmWCHYpU8sTbex0/t1rS8j\n\
jOxP/WSTsAhAIU/FucIHcKbwYwRp6gwic76PvOEr/JKrj5Ag8qMiyAcxexb1\n\
60TDCMu3MnLGoVaQm62UGUiC1AoDiq824+C2UgyME0Nq5mlZ3gTzHVfsC2yx\n\
wuQmvpiF3FolTu8swom95aRDhzEyoIZWz0ZYeRJ6BxvOKUlX4VyYFOfIKtQS\n\
KkiYhLN7FoQ9gkOQ/hJ0w7/ArCyVYE/S4TdhfvC/oBGnwDDxd0h732QPp10g\n\
4TWL15OD8yx8fuFcT949/jZsJhciycnYGD6NgxdmsP6kCPldXI6dhuzj7kgR\n\
tsdIceyShMiTCFltHFZryf1df3oaG09OkZusRk6hEhG5cxggp/7do9MYnePs\n\
h5vq/zBiCinNFr7Z3PbHmj4RBvN6MFwyjHmpKTQW8g4x44+GnBqrfBayfhWL\n\
OFEBOQm7y2GeM6M3oRJpb6ZhpHoKLuIRVtU85sRET+cMkLRMM0FPvo5/h89q\n\
h7RtCkYdF7TQTSgwVjKA4eJBSPvIN+OVjUtnomcpYaU6JqtGoFU72PLzgxKM\n\
FPRhqHAAKpFBmLL4J8Fc37YSp/IfI/s7xV3+Mgm3GqnlP0d44c8/GZiHEplY\n\
mbCdiGNOw/kXKWMh3DJ9eO1EOY7uKkVdi0q4bFFoELWnCOfPdsK6mBuw4HUi\n\
PaKKPPMqyA1+2JRqRO4uROy5LtgWc3yZQEFqeCVO7K+G2hyAqnccx7axzkiI\n\
QXdUDiItuQdzlsU9M5nTbgKB5Xs9WOeuQSor5nuAg/5CwAbV9HYMdf8JQz1/\n\
glyRz6hyoZW64aeJiMeTn2iA3y3D3OCz0EyeJc32DMz6qcUdC9RE6WKYFcwC\n\
yoXdhn1uH1kyC+p7zZiZ9QhrSixGN9r6zezlCaU75DUYCCjyeQ+UKgd6RQ6U\n\
FCmIHs1CT+XHpa7QmXQMOGQKB2RaLx+i/jym8muQsb2UPclV3dxLLD2LzBNX\n\
s7JpAD0Fo8weVsJC7f8ViB5Hj1IsgAhBO0oansepgif/GRBxKL4bljkTOsr7\n\
CUhFOBfRhr5eJcx2Mp0uFwuk47uKcXx3KbJS+9DQIKdxCaIxux2HNxUg4UIn\n\
RkbnMT2sRE5cI44QOU9NG+UIFemr+ow2HCb383JcJ0bHqNyQAtlxDWy5tEz2\n\
pClY1bOIIBCfjWjByJiWPVi2s3IY4TsLEBHWzCplDie3Lzu7Syf+AIPDEXwg\n\
hdSnqQR97Q+TWh0gBZGOnqb7oTMpBAzpR5/BdNMPIe9+FpLWb2O69S7yEWag\n\
7P497KZZLuOF7+r/A3tvI/S9InaA7f0tkIRHQH41A3N5hURk56AvKYTyUhIU\n\
cZcgj7kEbW0r5jNToUygaxcuQn4+CXa16av8aJYXyHEkjdv7+es8TiTlLSg4\n\
Xgc3k0+lM0LWIyfkcjgZSSpB/tFaxhH+hDhpnGr7WJwseFDV8jfCyRP/PE6+\n\
hvG6UYSRE3Xqw1KEESZOEAEcmXEwlAypYeU4H95KJq8dRzbl4tSxNjYaxOx2\n\
Up/djdO7inB4Gzlg2wpwghRTeuogYcy/Qpjs9DtdqM3qwikqd0QoR5jLSB+C\n\
2cG3i3A31DSKyH1ETImEHifeephwFEnOwNCUic8N/g5clhZMDv4Fw71/w8To\n\
HjipfUbZYfR0/hWikTUY7XsFs3Pc+dsmdTTmdW3sZ79nGgrJEWKeDjJ8sbDa\n\
uSCgXV9ApKOYHu8mhy0T06NrIBEdw0DbvZAqSxd11C9ZU8yEg/zuUcg7fwG7\n\
cRKa3kehVdaGdJRXQzrqKvyLlljAnDYlCjPXGtjwtmjHdsiuFRGmrmLgz2tg\n\
GCOWGXsc/SvfgaaoEtrSSpj6+iHasg7DG45AW1WL+eIquAw2AXPD/XoUd5hY\n\
Chw6YdJjg91hYieHhflWZi8Gn2d56ubSax8LwJ0Iy7kHVWMVnwSAlS0v/e8A\n\
+O9wW52Y6ppgFVVsTA8ZCRNcHnY6l6oxYG7eQR/9EI+oMDqsCzE8RobnpFoM\n\
dskx2K2AXM562UIUjfl6dsnXCoVl8evbYZozYrBTht52KXUpDZ7Fy3fnd9lM\n\
uvGuRzBCfWDQNmKy50mMTcTBKD+N1pqvYmbmKlTinWiv+y5MNiOUI7/ChJhb\n\
vOq1NaK35UdwuHQY6fwvzGm5Benz0xvR1/UhwbgZXQ3fhlh0BrLJDWit+heI\n\
5cKxEET9hn4Gxeg+OIwdxGsvYKbxbtjN86SdTmC68X5SgY3wOkYwN/RbSLrf\n\
ZiOjywD3BejSYyDNasGCSY6pvYdJgzLaxw3x7r3QD8sRsJLG3v4BAbE2FDJx\n\
T3RhbMMm6PokK37ED3dv/Vs4e+E7qGo/ywRa7+MvW3S1PGD2M8FSgYkwgAnP\n\
+wku1rwDncsdWoN+K8x86RNjRiyKZDGTP5wc2mHBrlGTRsnHxSsjKx4KDZmL\n\
kFxJ/qQYhtnrGOn4CYaGz0MvPYr+nh2hmcjJnscxoyiCauxFTM1wh7147S0Y\n\
aL+PhkyPse7nSXNwa6y04u0Y7CMhlOxDX/dWvo4gJrvvh0iaEXKNrXKiLIPv\n\
QD38HlQDa2FQlfEWjfxb5TnIOu6DpP0uKId3kWNq/szS0SL3NTMW0uvtpLQU\n\
mNp/FA4tM6XggeTAIegHuCiiXzOJiY1boK7uFwbM1lqK0Xe2wjytDR0DunTb\n\
CoHM6tSNaG96HecufBWTahl3muVXyQLpSdAyEUP9fbF+K7Q2NRxezgVgRvJM\n\
/r2IyL8HibVvo09KJFI7SYZ/2VDyb/Cvn2AsA3C6yIUYOYjI3B8iqy8KZucs\n\
aWRvqJn2uXkkR9Qip3iaCdMIRJOZJeLJQWiB1cJNMytESIP+m64tYRWh7fv1\n\
ilPobvweett+DtFEOA25FQbpfgz0Hw15JpLBX2FKkkIQ+SMmRP8AInruNXUz\n\
uwkihzAv3kG/j4bESTb8K4IIu6XJks3Q/PQ+rPfEp33wxf+NOtAF9fmjmI7L\n\
hVs6hskPD/M4cGNmD0ntwAw8CjmsYxPQXL2Agb+/TZI8DeeMCNbxMUgPfYDh\n\
dSTpescKQcHZ+5Jg6OAOHLX30ufO+hXCpHLQpsR87jrILjwPTcEhGJtiYOxl\n\
7KUfhop9sLFrXhZgaY2GMvFvsKllcAxnQE7lJdHPQJ74DuwKxe1C3y6YkXH1\n\
/+B61dHFKdPb4KExnpmpwpS4jhibWliZwGyKZLOp2Iwd4bNf2GLuNhjmezAx\n\
WYwZWRtsLoeQxeD3Wcn3UzAl2VcK+G1Ev2XkSQdCx9IxzW9o/zvCCbxnix6h\n\
n4dwJvdOZHRz2dydg1twMvc+pDe9xwKfCY3HVqxjqURd619wPOcBdClEi7h2\n\
o7zpBRzPfRCDGk4S55UZiMr7PmIqt8Lu1iK7kov/sY8rfJCqfARd0v4ViwBe\n\
EPbUC621nicdFTuUhA/aIrCNdOslUR1MfKq+yzuPqxOFUHs5N9vl0eLyeAHk\n\
Lie6VPUo0zA5wz7ki4rRa+KYDKP78qfy0aJXsn8qTeM42XsB29oicXQgHWP8\n\
LJfSNIGTPbHY2hqODzovoGqWP+4m4ESBKA/bqfzOzhhkSHuYOXthlpdRRuPd\n\
92FkPIqIrA1q8V5otF1Ed46irfFBmG1z8Di60d/0NSjmuqCeeBGdLb+AxSaF\n\
x9pIhOpuONwmjHXdS85CBLweE+Sjz2FwMAw2XTo6Gh+B2aqBy9aFvsYvQSTL\n\
Ek4FEeTDN0eWbMN6jG4+BEN3L5SpmXAzwToacM21VNLAczAU5WD6VARmIs9h\n\
+uQZzNW3QX01AdOniX5FRdO1aFgV+pB86DJegTSRy67Wpb8MWVJ06Hmm0vcw\n\
tvXrmC+PgDrxDxhdvwKKtCS2K6THv4X5wQ42c3nmyH9Akrge1uFMTO34LORp\n\
u2HuyYHq4n9h8uSLzMmeIQ0XcMmQnvIlnLt8L+asDiGGoVPmIvXqtxB7+WtI\n\
vPINnI//NzT1FXJgk1xAfPx3oLJ5oJPG0+fvQmG2sJqkv309zsfdgctXv4eE\n\
y1/GxasPkwcsFjz70Z6tiI79HIbknC2TjJ3A2fO3oXWkbYm4BDAtzURZx0bS\n\
1fchpvzPqB6IQp+imbtHcR0lPacgNc6TN5yN9LoXca3pIFw+HynGBJT2hGHG\n\
qF0UFx+GJuPpcjgUFm5DIpt5AI2DZ9A2WQavz4nukWhk1v8N0QX34FLtayjr\n\
PYMZnYJv0n3QGAexunoz/qf2OK5M1yB1IgsvlW/Eux1J0BMHsTtFWFVNOtfB\n\
rkGExTGFP5XvQLvRgNTBszgwUsUuodxevxeZSu7V4bdge902XJIOkP5W4c2a\n\
bdjQmYRyRRv2tR7GH+sjILbOYkfDdrzRFo8aVTeujiTj95X7MUSiUzRxBc9V\n\
7sLVmSZkTmbj+dKNuDDTx9ABrre/A4MyCr2tj2Og41l0Nf8URqrOrIxET/MD\n\
NFBP0+8fY7B/A7z0CpqpN9HTej86mx6DRlGA8YEX4fRYIBr8Dbpb7iFf9xfo\n\
bPwBFBpm500nZKOvoKvpcfS1PY7u5jshU5Xz0iEYOn1OHMYPx8NtdvJh7W9B\n\
f/11cmzPs++vz34N8pRYrjOo2Zr4JyBN5rZ/WvDoID36HSjSOXTLTt8J7XA3\n\
fVRBfPTr0E+Nwa/tx1xJLLsOjDlX1FS7B+PbfgKX3smB+06oRBcRE3MHomJW\n\
oGmI2xIm4JlFTupXcDn9FzSuKnhcWnQ0vIIz5z4PsW6eEH0RcRf+HSqrCzpJ\n\
HH3+Gn12QCdPR8z5FShuPEt6wwWroRfZ176My9dXMQlU1GYXynLuwunoFahs\n\
S2Wf1VH1PMKjVuB65R7GAgm7sVp0dbhAVPVS40HmcmjndGIQQY5FrBDWG4mn\n\
oniieWVxb9igB9GdR/FCfSRkTic32j+EVNeBF0rW4bJsFC63DG/VHcAwD0ir\n\
Yxorq/ai02RE5vAFHB2rZQH5YdNh5Kj4o8LJ6H3YuAfXlCPomsnBH6sPQ+7h\n\
9b1rHkkjBRjUS5E1XkSPZU5U8WJyvhMvlm1DrrQLW2q34fx0l8A1WmV1yBCz\n\
eOQh8e9kemUwG/qJ5nGzMwuk4gN+L42BDFbzNASiGPDZ6LoTLrucvpuHydBF\n\
3wXh81rZ6w7rBBwOrTBxyVAql11MrdST1XAjGPSvuAGMXo0Y0qgo8pvloZyi\n\
m8B4LWYRjOfvgzz9Uoh9MX8r0i7fAEY1gfEbVGcXe5dzPA+qhD9gat+3MLH7\n\
G1DkRpFru8C34eusWWgoeRRJ2b9FSd5juJq/hk1Cs2mqEB/3L2gabCBH3U/W\n\
zEtWR02OQhw0JgMR/XgehQIi/wMaqw0jXWtxNvFxmELzyV+EeGgfzsZ8FTJm\n\
xy5LD64k/yuuXLsLqYWvwU3WLivtm0hOvR8JV39J9/m/wPegSVtBztPdOF/2\n\
CmRGJelSV6ibbKZe1PTvRf14LviAEUSTYQjP/gZyBi+xAywkxrndSrxeuRkX\n\
pQP8a98FZtr0Uv85nJtqg4UG+m3C5ajDzeNSjFf/AS5z1ZIQLvfyuGycysAf\n\
Kj7Aro4Y7Ok4hw+JL+zrvog2vRx6Muwxg5fxZt2HeKGClGl3KsQmCTZWbcYb\n\
LeHY23Ge7jlP5eNwdqQYzoVFMfM6ejDc/Szs3gU2P4WQ80321zdhyHmDkHGB\n\
bYmBZF18/p1Q4FYTcz/kqfH8X0FCyb03o8Q3Tyj5JvTjIwiaJzC998uYiXkN\n\
pp48OBUT8Jo0vDH+OjyWISReuh21PYVQTEXgbOzXybI6oJddRRzpsEtXHkJq\n\
+tNISf8lUjKeRlr2s+gZ7YFOlrAcIXGEEIuFuM/LiMv4Iw3n4oypXp6JuPh/\n\
wdicEsrJk7hw+X6MDl1A4tWfQTx9HYlJ38XgxHUkJX0NA1IRh5A74LaPIaH0\n\
MfLA7kF04cPI64tjuoHL2fss5hRpCL/+DUSXboAQQdOoy5DX/D7aJPXCCj+H\n\
awYvV+xAvkbBc9EfszzU5hRjVdUeNBs5Tmi1jeMvVR+ix2Jahou9jftIv43w\n\
uLBhR91OpKrG0SHOwvNkDAuUfWjVDKBOVoU/lG5GnnwAJzoO4aX608iRtmHE\n\
KIXCYSS/bxbrqzdi12Au2mcH0Dbbj+Ptx/By40UmBzSEC4bSMEpncdeMr7DT\n\
033ybER0HSKdmIC8yRwonVbSv82I7j6IhOF4FE+lYdI6R+/mQ53oMqKo7HmS\n\
gUmrng/9cqtWv42gU/v/MfYd4G1cV7p6L5tk+2bztuZtejbJbrLZ4iSb3SQb\n\
x4kdJ3FJ5G5Lsq1uWc3q3ZJo9cIqUiRFkSIlUqLYe+8kWECwAETvvfcOgv87\n\
MwOAsp237+n7KACDmcHMPf/5z3/u3HsuzGW/gurGfsQ8Njjr3oTw3U/DUJeN\n\
kNlEEPs2NCn4MRAzZn+D4HiThZj6/Jdhm59AzDAC+YnPwtR/HzHzFOSHPwPr\n\
aAspDA0st34IRf5rTPdUhoiUC6dxPe+zFO4c5Fwc5LqnGxC0D6Hoxho09V6A\n\
QtkJuaILovkc5BeswcD8GJzakt9JRMLJraQf/w3uyHIGZmZ5HvLy/wekFiWF\n\
wcdRUvsqAj41Ku/8Naprf4jiiifgDTlRV/lXaBkqSsOMfcShr0f1wEu42fE4\n\
muZuMCEyPSvX4xhFw+hOtM6WM1yUHtUYIFitbX8PtUZFqjvmqwQpJV7teBdb\n\
eWUQe4xoWCrH00Q1mmiUNFku3hf2sJH05NBB/LrvA4zaVJRldeIXrTvRYjHA\n\
H5Dhlc7duCTuhzXsxF3RLTzVfQoijwXvDx/CsfkWOCNedMru4vne0zDFuPP+\n\
pv8SBG4zZM450oR7cXppKMUlfw69vQc7u19Hm3YE7ZJ8vNH6CmasIlwdewc3\n\
Fu+hW34Lb7b8Ev1WBRbJ5/cNHgLfykeD6CqOTVxml5X8w0fx8znKp/MhOfjH\n\
EB/4Kxjr8+HqOQZN4Tooz/0DDA/LYav+DYyNdzP4sZY/BRNbACBGOcQv4RKP\n\
wnTrKYjf+wSkJ78It2IRnr6jkJ/6O8hO/m/KT34Ar3Rplcwj6Hj4DRTXPIsQ\n\
qw0S6G34Noqrf4VgyI16ii+3HrwGVzDM9pQu8nazgl9qt8HBKqsPw4dRVg4S\n\
8bk5a9A9Uck+6oqFjehs+A5yb30PNpcCVWV/guaBQqZSFLoph76cvYYS3MNs\n\
x9f04FoU3n2GHcK+uvTjMlvqeDm5vObraYKnBHYrKfj3RX0pN/g6G5jqJJRM\n\
mCWEICYwHabAcg1v0O2v7TmMK6J+9tFSk6QKNxQ8Fi3Z09k4PHUTbw+cxEs9\n\
B7Fnqgq2VFI8ZxrCVlL4r/Qdw+sDWWg2crWjFk0j2DpwDK/1HsGLvSdRoZll\n\
I0g46kDOTDZepu0vU9A6Nnsf9lg0DZZxyVVkzVanDOfEByP7MELJwYXRfRAH\n\
mF6YZeSO78WAZR7VM/txeroIAvL+KV0/GiSNcMbSXRAp6vpj+JaE0M/q2b58\n\
w6yB4o8W6m6uvJZbsADB1RoIrtXCOKtlWpfrEvxD1pCO6pegLNhF0myFm0nL\n\
XFTUjwSzNkmS6UJazjzlXY6n6vgvI2paRDxMkswvg+z4n8LGH0kLxOWAC1G7\n\
AcuRWOZJgN86gAIKdO1jd9ekda1KeA5Xrv0hxCYdXMZ2lJX9BfKLv4jKqm9S\n\
gPwDEuS5TD8wrMqCj8FL53az/SW8oQ2UZ34alfd/jPLyv0FO4Z9jRtYDO0Ev\n\
O+cTmJTOs3e0wNuJ85eJ7Wa4mlt6skF2zmegcti+x17On7JO1CAsxX+17kM9\n\
hZ4oUyKOGc2la8dPGzfiDsV0Tn6fJJkTgpdUlyuSKcpjC1pgCHlZokukxliE\n\
YwE4wz7mLjK1WygrdZA/hZcTqxqWtlkCNrijodXeRGZEUthN24Kp/tY/B49y\n\
hvOC+ynguHF+9AABZxSXxg5gyRdi7VLMO0jAWcB9/kG8N3yCAHOPAu1V7Ozb\n\
AWkg/FHgWLrbIaiZhb66FoL7AnhmpzF1tZddn258fz7UYzLYxifBO10FvzP6\n\
+ym69vYcgnDHp6CvzWPw9Adpkk96ob7wLYpd03QtXljqj8On12Vm+QV0kMla\n\
4Q74MyCIh+2Qy5ph93KdS0GvDIuLeZgV5EOlm8soMosi/3eAgKstwfCCXt2E\n\
yanzmJ7NhcHODTMN+RT0e90IRLk5DEEKU1JZO9xBLktJRGykjDooXAW+z17O\n\
H7FV0XNncvBzkjubhi/h3eHTeKr1Xbw/X4/AMqNn5FhPTLwYDGewXSrIw2km\n\
6ICbPceYyugcoIDwJvqNMxiWF2FjxxuY0I/j3MheCFlTJXBjfA96LUtYIom1\n\
d+gIRC4lesXXcGjkCFyJ5EdNZe3rwnztHAwP6jH/cB7eOT5mCwbhWZjDwLZs\n\
SBqHoWgagrCiEx6LP20qZuqtn9jGL55cNdUn2AsIKWYR8wXWpKu6W+S5yKcc\n\
Q8+0sTKf3n8WWrfrL1IXwGRjfmcsM8wl/Tka5T7HKW5oF72kQnzwuBPpWi0+\n\
axjqRR/MukjmWVoynoRTF6L8L87KRJsqwB7mos+JSBxmZRChUBJhbxyRcHqB\n\
zz9FyEOfIytYji3D74qvVpGJLlPeHs8s/Bn1xaBZ8BDF+JmZL5/M8F0cc9ZZ\n\
1Cq7cV/ZB55dmZmXk1gOYM4mJisn04Y1ebVQ+p2PGPYzbLvxNPdJXewmjr+I\n\
fQN7MGGaw0NSEVpmlDUhtl1cBr5Ly8aVPlkpTgy9gwuT50lhmP7ov7PpAvyL\n\
cxAUjiIol7A2VfUtwDTAw9DWazCKrI+lDGXX3CG99V2YAxHSblXse6PXwxnq\n\
X9m1jmuOibGk4uYOMZ+rDonBn6XM2x7Cw/fFKNkvQeVRCW6+J4FIyHUmaMdt\n\
KN0lRMVxKYp3idB218JaTDZgQv6WRXTV2SDsMqFwpwh3Tkhx56QUD05LUbRP\n\
AoUsjJ5sGXj9qbU7iD07LksxNRqAS2hH+SkVxUXOXNZZG24dlMJDl+fV+HHv\n\
6BJuHaLz0TUWH5JBqYykVkb4RGYuO7A61+XRSa6ZvhO2gIEHWSN7MGbTfzqz\n\
a/Iju36s7fU1DyG4MwrF7VoM7i6FTabF/PkyCIo6IS2rw+jJuwj6M0PiIyQH\n\
hVY7FuxuSoiS306ZhBkel4in5vum36+s/EUKPIwJqo+IIVI+YpIDS5ie9GO6\n\
QomS91VEi8xQh2VMlGtwL1uPoCuCyn1CNFdaWZ/TT9uQu3kRMjLrTLUKVXl6\n\
co4EGg8J0VTJrh4Mt9qH2+8uoruJge0KOi5KMdG3apJ2+jw1TCZZJJMce8Qk\n\
M2SS/VJmNAX6rstQcVlLtEnCLEqfC5R4UGRiOnG+wt7OV7AStMFz/yJijtSC\n\
EssR+JsuwPrB67Be3AL/JFdXOzJRBd/wADuJ1l93nv3efvMYAsO1sGfvQ0Rr\n\
RXj0JuxX9yBqcCOumYDj2puwfLAOzorrSAS47oToXCtsF+jcl9+Fpy4f3u7O\n\
RwewMcs3d8vroPF70v1Dn0yZnLHyHAU4v0wO25IempomDO+vJLYIIeFxQdsy\n\
AmULjwSKf026WEA05Me+9l6s7xzH3o5+7BgQwB1fefK/s+VBMSZHvegg16ot\n\
0EMt9EIx54Vs2oXFCTesIheKdwsh1aaGwxMu1bNeuF0JTN1V4n6JiYXwyA0Z\n\
ig/LwB9ywUoE2U4u1NvMdW4ztnzUvT5kyxMfsSW5FzN18OEBEVrumIiAueuR\n\
TjqxQNeTSI+8+BM60zKsvggpbe7wSDQOmz+a4WrmKa/c6MaI1AKBwQtfLD3N\n\
6w9gdwcwIbeiX2TGvNGX6UZiluxjzrE6ovsTFGWjsHN1qTPRP+kQw7TjMYpE\n\
Dhaugeb3od/xU/hHOuFrOAf9JvpObYavYiMshQWISzuh3/xv8Pa3wN+eA+Om\n\
L8F45j2ypBP2rF/CVnQNMfUczHspwyi5jNBkO6xHfgjrDcKSeR7Grd+GvTwH\n\
wf4KGLd8BaasLAZHn38UM58mzHRjoXYelq4eSHqYx55SYuBcGOX21HCXLyJE\n\
GqJpSQmB3QuNy4Ztjb0YsHG1rbQuFwV7C3Qp9MYTCdJ80VR9miQslEPFUvU7\n\
NE4nu68+1XHGDM/VuL2UmcapxcIIpbpOrV4vZkx2mILRNRznfIYF3j0CojAF\n\
RGb5agaIvBEvurKISw9KUHdZiVr6q35fQpwvh3zKgdK9IsgNqQleX2JLFyQJ\n\
e5NVStTcNLKXGXFHMdVgwMMLCtwlmr+xbRGDbZzc6rggwXCX53fi8PZxJdMp\n\
xV0yn8MhM1e//rAIpUdleHhJiYd0OVUUnkoPyuENr6SnAjpsNrx5ZwpjJq6K\n\
BI+vxLa7AtiZknCRMG51L+DVWzzsus/HW2UT2PVQCLmbu3ORwoit5RPYWDWD\n\
vfT9ulsT+KBXxUq20Wk53qmZhzPzyJ6kV5cAOxtkzODKDBSdEoLNDxFSMXdJ\n\
UM16CvY7N5FwWpCwa+Bru4mwRgt/1XZYS4oJih0ExR8gsLBAUpeEev6rsJZy\n\
TzVs59YhtGRBnFJ/w86fE83psOyyILrQDV93IwJt52A8tCnTLR5oPAHz74Ri\n\
jPKcIFFV1OFAwMmQbRJukZxElT8FxS9hJRFFzugEXm3qx9b2ATxzvwPDdj/G\n\
JEt4tqEX7/WM4oW6bvRafTCaDTg2wOcm5US9WN86RKlDFIOUQGb2re/BEEFZ\n\
YdLiqeo21KhsKOwbxbgziCWDGmtru7C9Ywhr63oxbg98K0WLDPru7ifVUGNj\n\
IRQ2+VG6R4TFpTAmShQoP69BKFWchV+jRfFxNbzWIG7vEaKniaO4KMWT6jNS\n\
SOURSkdUuF/MzXzQEGr7uAnSrNpv/UCcOab7sgTlF7XwMjOcSQBm4ChyoIiU\n\
iljC4UncYkAxeUCQQiZzTHW+IeOFwzeVuJWlZcbJp+Fot1qxoYLgaEzBcUaJ\n\
rVWzcCeS6JuS4qXiCdTSTwRjCSgNduyuGMe+ViILos+s+zy80ygmIR1Dkjxk\n\
WqzDSyU8jBiDmJxRYHv13IfgWNApwLt10lU4forgKCY4/gghDUP4pMfP/YKg\n\
9OP/CfPxZ9d8DsZ3H4ObQpv/7ruwFBWQsA3A13gO5sNPwHzyRRi2/xNst5j6\n\
dBEWjcF5PaKCO9C//U06w3MwH3sW5kNPwHT2Lbirj8Ny4WxGaUWny2A598Ej\n\
aPxfKaTJyfovNAxAHSH5TVn+a/WEKr0RW5p7UKu2IUFhZUAswi2hHjqzEccH\n\
ZjJIW9cyDIHFhrcbu9GodbAPRHpFIlQuGTClllGCyhUqz+kZxqjNhfc7e5G9\n\
xJn/AZ+Py3NaDmn/iiQTcN8T4sbOJdRdV6P6uBg3dkuII5Pw63y4s49Om6VE\n\
a64K+duFGB3wsDcnbDQgf6sQLYU63D9BBHRcAUG/DZUHRSh6T4zxQTdM804U\n\
Etk9zNaiI19NxCfE9ISfRUnnJTFy6fhiIjXJtI+QJgFv0M8SX8GWBZQclqAl\n\
X4PiHQuouWFic1eHyI1bFPirL6rRfE2J/B0i8KfTWuMPfyfMGNZzkKtkN0xj\n\
Z5OMacL0SBql0Yk+iY0cKYEJah05o6GZrgIKH8PzKrx0cwK92gAm+f8fKPsK\n\
W8zZvPVrcDXVs0B15ayFOec02w+UpOzH8t734Rkahv/eu7DevIGVkAOeu6cR\n\
MbiwEvXDefl5gh/znGQZ9gvrERQZkdB0Q7/tuwjJ2aLUCDSdgvHoBgTHKmB4\n\
92eI2Hzs/p7814j0Pg6zz4NPcNjRy88AsmhgHI1SJdbXt+Pd3gmcHpzCsf5x\n\
5M0roDQZcYJgxjJDzIcNbSMYVevxel0bdvXy2H2P0r5Fi0pM0Hn39qdhNoIR\n\
qw3vtfVj2BnMqJRkcjVh+IeULzKLDKhmPTCpgpjrtGKixQqdMpxuxIAlBH6b\n\
BeNNViiXgqsZC4V6zYwLw/cNGG+1wWaLwUsM0HRegttnlFBKubTLKvVhssmM\n\
sQYLpAsBdmVqxqZG0pBGSoQXemzQK8OwyAhqZNCYOwzFvB96+p5Hx830OuHx\n\
LqcHNHn0AUw3m9mr1MjDv/ff8BkDNBMl++fuT2J9JR9nW4XIoj/m9VLnEvKG\n\
FDBFuH7BvnktLrQtYjOF2VdKJnCgRQJTeBnjFF4ZpLn+30gzbfsq9Fv+Ddac\n\
U4jI+mHe/V0imjdhPf4zGI9sQpwUo//OFpbQmLr8jgvPwXjgWTjytsK4/TF4\n\
BnsQ6MyFgVSc+dRWRMjOntK3Ydjzc9ivrYdhG6GV6GMl6oPj/K9p+xOwnX8Z\n\
hk1fh+Xy5d9BaCoKcS81DkBDNxKPBrC9uRc9ehO2t3ShSMQ8egzgxugoNg4u\n\
Qm81YUPTIDREflGfDS83DUHsdGNTUydKiOCZfXNHhvHOsBAzGgX29AvY5sju\n\
ZgjNjbOdfbgqNLDbRii/LxUafpICHf+BCg9vm1OUgFQHTRL8egNkC6HUU6v/\n\
uw3twSiu1U9j031K0kl3dApN6BVbcK1lDq+VT0NNWV3LhJjYYQz7GxZRKzBi\n\
jqR8IMb1U45MyrGZzmPJ1E5bxo1ORiJJmYITnA0/xwaZiHAMUdUcguNdXA0x\n\
iwT+7tvwDzYg7k0NSijfTGqde+aeDNgRHH4AX/sthOan2WNi0l6Y9/8Ezsoy\n\
JEh8MAM6w1PN8HWWISwRpUMgQzbB4WoERloR6M6B5fz532FCpjRvNlHU6y2D\n\
2NU1hKdqOjDm8GNKJsGr9b04QOTxQn0fOs0+8kAz1ta0YHMXmbSpG2/2zLAS\n\
cUy8hFdJ/Rzon8CLjYNoUehxuqcfP33QhUadEzf7xzDuCkKiU+Klui7s7hvH\n\
bx50oEbjSJswSErU5Yh/2ITEJRP3tBAJgikTfh4eu401Ic8SyZgwLSvqh0R4\n\
vZwPkTtlB7q16818bH0gYlfhY0yykd6nKiRBoTThQqeENRtvWoFXSJI0Szhh\n\
vhKN4Cy59ZEeTWbYvrd0Pcy519hPmdSZ5Kqr5DBCUvPqw/7JIphPn2IfjqZa\n\
m+vH+DN2TO6UzogpsxNmrx/eFII0DjvalXooPBwEIvTzzFAFKVFsu9IAcyie\n\
GXKustvYfVXEPAyz3OVP46WWUWj9EYgMZphTCYTO6UCTXMOkWJlKso92/aRn\n\
KDzaRfTjlKf4KF262DqHdbd5ONQoJI/xYVqgYpvaQUwV8HhxomYSG6r4yBuU\n\
43Q9Hy+U8lAv5Z5TD1L8XFc6gct9cpQMybDp9jh2NkoILSDGo+9KxrGhfAoX\n\
e6T4oHkOLxSNomrRkZkgoRhHSCJOAXkVDalLzYzRZer7hQSzKWywLZ1eElTv\n\
sKBexo2wvDnAI/UdSA3j/WdyRC88D07Ckv0WHPfz2BIdMVErEetbsORsgmec\n\
q08ZHCpGQCxn/dnXnIMoYRhhI1yNpYiqBXC332ZL4sblA/AOcMuihaaq4ZsU\n\
kF+F4HlIv5GzEdZb7yPmpaSV9vMNdnEAYyq/3jtM1/A2HPW3sEze6r6fjTgp\n\
kcjUHViuvQl7xTm46y/C1XkPgckHCMq1qzX7mOFd3CjUTPU6tolSax7+fsqS\n\
4WAQVYNLeINSujMdEqLcEKZmOUvaUoX5vL4gHoyRFZsWkU0W4+lXa4Gt0O+M\n\
i/Q417KAo/XzKB7XwpwaycDw3jvVAgzKzbjevojTLUI8nLcgEF95grPGt1NX\n\
5g6GEE6VPP90ygqBjtMwnN6C0OIwcdOTsNcWk/Z+Aq6eVoTnW6A/+FOEdGa4\n\
il+DvZOZKZSA9cwvEdQ7sOKlgHL0DaLROhjObmAnm0fGCok2z7BX5qneBfu9\n\
BrJgDgznNiOiXIS7ai/sDVUIjRaTGOOGGPsaDsJ4fg9dwxC57ONwdj2A8fAv\n\
ychaWE88BtdAP8L8Ruh3fRPuqSmy0F44h6Yzk4UpppIu/i0w9V1gkv7m3wKc\n\
orQaQoCwKdlIoPGs1jM3EYOoijgsq48A2srU+8P03UNuN/LX8BIduoVOYWfx\n\
B8MFYPo/6Zd+CMg+AOz1wNwvAX1NykU+DQ9lua+T19WJnCwu0+RIds50/jI2\n\
Y/SGdwVrnuKM9P2UQVzFr8PRxxVSXnbpEOwrhSlnR6Yny1XyGpx9Q3CXb4Sj\n\
d5Q1iO38bxEyMhXrRDCcehtBXiOMF7dwBpkooZT+Agex2v2w362F+/Y6GD94\n\
F+7mIrgeXIOrqxXBwZuw3WZ5lbTKC3CNcwNZlm0KRBU8Ur/PIEJE6C55gxpv\n\
B9wdFaR8f4SA1gDvwwNwjaQXifxjUNZG7LMGGPospawHieSPAWNEv/0U8Izc\n\
dDPY79Pn/0EXZcwYZYnaYvJltqEx/WVgZhv3fuoLgOhwxijeTjqSmttJOsTb\n\
AQzQLwnoMD1Fa/6/A33ML1Oe5ZzNGCUYDGB/FY8S2AmibTd4s0q8WT5DUWfV\n\
KIPjUrxdyVJrKlT8PuIuDxKRBDvpN+pJVW2wW+DmLyKgs6WjQcSkg3NqFl6F\n\
gUVR3Oki7ccFwLjHnXkfUinhFiwh4gpkJilHDFq455YQtjlJ+4f+8sNwcJet\n\
h62JG9ocNyySBCkkX3uFXfGA+ee88Rs4+0fJpG/B3soNIrVmPY2AhhAbUsB4\n\
ZiOC080wnFnH9tREJktgzj/OwYHMZq9rgqfmHYLDTgRnWuGmXNxwcTsCA8QD\n\
BUc5yBW9BEd3P3fzaj6Cc/0wHSM4OLz0mQdP332STuUwHvt3BNTaDBwyU+AS\n\
FmCCbmyUfNNnSA+3RkRDZv4GMPwNtkYLnHSbQ2Rfn2nVTyXP0j7rORjwyaaz\n\
O7n3MxRixCcykPD10KEkT1ykP60lBAkKTp7USP8VitD8f6QreINx8RTzfQpG\n\
mwdtcwZInGG4PUFMa9yIrI7asTHyizZFV9J13r7AUoDyOvkJ34TgQh/EZT10\n\
E2Is7DsDaW4J5t87DsMQmVIxi9ldJ6EoqYLw6FkYRgVQXSbNPyRir0h/oxCm\n\
cTHcA22YP5gFWc5NCN67AK/eheD8OAR0rORqMQTvHIC0cvAjkIjO34N+//fg\n\
fHidvPJHcPZ0wJH/HJn1IHnzcegOMJ7qIk99Gdr9v4Cj/AB0O/4exktbYS94\n\
C4YrBxCRDEC3/WuUpRwhL34Cmr3/CXv5KRiO/BieWSkF024YTzwFV0MezGee\n\
hqO9GeGZMmi2fB3WolPw9hKlH/oRXHXXYDj8Y7j6GlnKjrj88DMh5cIOeNoK\n\
oT/8HwiZLBSEH4UE/e+4y/mptiNT4YtljT56NRPpuls4LPjN/19QkJz8GBQY\n\
dghN0ns6lEesoMyhXxigQPFz4qKX2VL7X05fTXwZvHYbTLbl1PRqztaq7CLY\n\
KM0ILvRDcrsLhps3sFTcxJas9PBJ7DWPI7DEh2ViCVHiRt3NHCyVNZOtqXWG\n\
hKytDYVFMFKeLj71AQx9C4i6PbA0NsO2IIfq4hWomrjxubbacsJTb8rWX2Nf\n\
PvmoLEyBGZnJGB/7LlM/4zuIiofhbswhETTM7pYMOqhhyojxbxLhOFKuzKOQ\n\
S6KpoxDBxUmEFzrhbi2i781s3eKQcAiBsRqy9X1ENUQ9PTfhHe1iFvHjjpeP\n\
wNNaAP9kPxvolu0qhBfHSVzVIBEOIrLQTiItB/6ZERJ7QUqBWlguXQm5ERiu\n\
hJvwERROs+diQrprZCYDDx2F5H66UZ91FR7LfjIqNRaz+IazgQxLUt+lW4XH\n\
8/93eAiPZuDh7+Pg4UiN3/XxiEh2UYwh9+J9lcIWNSFvPQuP9JCt5COrPGSe\n\
ya42+5r0KAXmoUH1JRUkGnbE/erI+Y/OqWPQlYSKvN4+b+bQVdYGdXYu+O9l\n\
kecXQnz+OpauVSLsMEF5LRfzxDDi6+XkDlZCzTUYR7lxUcbiYuiJ9pcOHcXi\n\
iWxIrhRCdPICVM2DUFzIh22eE9/+yQ6Ib6fRxY2V+Hu6eSJ10WZgcQMgPcMt\n\
ZGMmVeSVs8tYYPF1kjevEGE1ccOqtCR5FkhcCd+lfUwUw2+T2FpH24haLf3s\n\
quGQvE3b6HzyK9ziBsZ8+h01fUfUbOAWG6Fkm35njH5jjttfsp1M/oCtbpye\n\
l4mYFdb8PYi4fZk8z1N7GO5Rtkci09cF7T6CyqcZibYqyxl49NOrqim1Hxl8\n\
8UeEj3Ufx8fsPxEf/AKZGoauhxQ+CFoONTtHD5IPi0nRk7T7Cyw+uFTza1gm\n\
UA8/NKM6V4f6UjMstjjmu2yYGOGeczL9Z90NTkqbI+gqM6CmQI+hDie6K02Y\n\
nfJhit4HmWU7PVEM1TtIozPvI+z7UCCO+isq3M014OENHdpqHYjEV6CedEMi\n\
DnPVhzttqMnT4X6RERJZJI2xlWgQ8vM5MA1L4Rf0EoP1wNFcg4Xz5SQ2HDDX\n\
lGPxPPn37ABmNmex1WVsrY2wCyVQX70GcWEjIjY7ZCfPwzQyBxVtU94fRIRS\n\
X9mpM1B3zcBYXgRRfh3FGzs0168Qg/V9FGNW4t2Jn1E4JrstPkMKmySzhBzM\n\
TMptgXxWSRhykyac+gFtI7sJqb39GpLXewh7hDMh4dM+T9/dJPv9mo7dTec5\n\
RJgiD5ijDEdHqdwS8bltijBDkWPmFbDjYQyEVXEptT7tq60jvNL3I/9GOLFl\n\
lqKPGtRpR85EpmQiTtDTM6NzVqOV4RThiaKVW5/C2Oc4tTKQ0rjy63QfB7l9\n\
RCc4Zp4mMuFvT+GNMNZD382spespJpFLDDBAqiLA1BOjdHbyb0gcEecb6Dp1\n\
uXSdlIPPHmDO84epZpxuMOFWthEaeQijNQZU37JCPetC7mEl5ma8KDkqx+hk\n\
AMJWM27lGKGVBdFzS4fsIxpoFUHcv6CBO86UXQ2g+KQGzETAAL0vOaWBxx/H\n\
w/MK3CuzQCnyo/KsEr2DPsw8MGFk1A8j34mi0xrIJCHM9dhQclkPdyg9deQL\n\
iDByZ+MeCC9XwD7SSa1OQSLshzqvgEjpIhZPXYdbS9lQyAXFlVyIzl7D4vFs\n\
+C02aLKzwd/zPoQnab8ThQi5oogZZRCfvYRF2ibOrkY0GMeyxwhZ1mXa5yrm\n\
d5EsujPwMaAVkMNzShnOaiIhMoiUMghTLTX8C8zIOe472RYOhA6SGEICzgwJ\n\
Ai3t42PSxHfIWARSyUUC2YvM41/uGAude5EIUvImHTfH9P5RyvEWZ1zjJdpO\n\
II7qCAgENsFvuO+i4QxJBSc6YKlrYYcScO75eXaxJkvpDQSN3CNAhnzdTZXQ\n\
nDgC3eXrsD+sgb2tG8tBO6y3bpNw4PpLEyYpLGXVFEpXkPRZYC28Cs2pEzCV\n\
lMNeUwXPlJLCt4u2X6LM9hDUR4/CWteJ5PLKKmm66jj5JStdky4pARe1geBp\n\
chQbvSfCHybsySgDmPwmME5SaY5S6BDTs0Q3Lac0WVHFDViSkJNKTxLwKQOf\n\
INDzSGvrWtIdoPBTgJ17ivtq4ivk8zsIeVYO119nn703XlOhrsKKJb4XCxNO\n\
DHc62alHs4T5c1vEeHDHznaoqIftuHlWjakRL0RjdpRnkwwnznx4WcviOWgN\n\
4PZZLXzMe0sA5VnMA9U4aq+qsaTk+uO0PDvulFoxdd8M3oQPY/eMKCF/EdFv\n\
L/I8GGqzw+5JctD+JHuzyvPZhBcevDPdEBW0ZCYRJAIBrD5oYS2ImMfLFnpi\n\
4oPi7EUYBhbYQcjLiWSm7Zm1N/zBR4LY77EzOZYjMXhGm7FU2v0xZFMIXTjL\n\
0YqecjfhObLMVqLEZmqkXxIil9gfxMJzRC+3ud4JPYVTC1Gjk2SogLSN7DJR\n\
JIVo2yBZi9CprOKuWb2X6JPQLX6NGoe8IiohixNdhynB1GeRde/QdrL2LFGZ\n\
k0K2voMZ37VaNvTuRciPn2PLRKaRnXTKIHvrZTgXtOxPxKQTkL66FsbKh5S0\n\
lEGy9mkoLxYg7lBCvmkTgiauuze2NATZpvcot03C21oG8atvwtHRDXPuBxD9\n\
+tewPByHpy4Xko3vwDMxTUKzDbINr8IxKslMhWPKkGD2O0SvhGhTPzJjb0MU\n\
Lma+SPqOyD8STiWbf5yiYGZWfWzVO5iGDjESyJQZH8tKmdSc9My25Si3Helx\n\
eV9ne/+a81SoKDBiotuJvhojCohjmaJXsj4rPtgoRlM9NwYlEYyxz71GWmyo\n\
y9Og9LKJLieKmgtqMNXZmJ7OsjOEYaYbxxFEOWHbw+D5ihpCBYdn/aQdFUWW\n\
DJ4nibPzab/xbgeGGy3IP6JkxmulJ1T7JkchyauAa14A08DC6kDaJCxNrXBK\n\
DJle6pCUT/CdT7PDhwBpKyR6oHi1QHGc959EFyoOVFYCiJ2yuCmi1PmXCHik\n\
t6J2ogaKyYtbOaq1kOLXUoycIyqdJV5QUTwMEM3OkD5boP2nSIv5LdRamzhN\n\
ICBQ80jDCyh2TtJn+wIBnsDLJ3peeIXTAsvJjPFcNVehOHP1Q1SbdMkh37oO\n\
LqGOw8JoE6TbD2aWerTlHuEA6VRB8c4OIg8uVMQkI5C/cxhxCkDOivOkiriF\n\
3hF1Qr11AymoYYSXphCQqLDspdydckL5updIxkxkSpUgSLqD9yWgl4n//0Xt\n\
QgJymOI7E7+MXDc01xe2hukLSxuKXTZuivA6vYWB49+mWn6+zYzS83poFGEM\n\
VOlxu4ACgMKPgsMK9Lc4UHxEgZmFMPx6H4qJ/lSqMBZ7Lbh5ibJYTwxlB6Vo\n\
qnNCOGTDpR1SdLa5IeiyoPCsDoFAAvfPyFB+0wKtNIjqLCU6e70Q1JkxPuaH\n\
bcmNG2fUEC+RDOiwoIjO7wyupPolUuCgK7bkkfHK6WbIUKFUbFsiMJj6uPdB\n\
8iyXgKtNyrImeaybQBE0pVx1hTvWK1tNcaNWLveLBrnPMTJQjM7tFXHLojDn\n\
9KlXPThIx7rmGW9ck14Y0vXgOmQHTyKopDRVIac/BeI+LqamAeIWGzMAkR88\n\
k1ns03nvMpSUTjEAkW/fSFLZmWK20VWA3LkI3Y2a1D2FoNu7Eeb74xSjzTBf\n\
y4Ls7Tcg27wZ+pxiRL2RTFobI6wbbhCpk3/MUd4kI3L3qTJ3EiHXMlbQbqFV\n\
3mHA7aQI7ZxhhCh7dyuxZUy3WFBBOu/hbQscrgQZ3obuFo5rZGMOdLY6kUgk\n\
yeBWVNJ+lTl6CJfCXP5Sb0VPjRkVl7QY7XWhp9KAsvMazAiC7DKpU+1W9NZa\n\
cIe2NT2wI0jqQ1BL+nDYx1pMOu5E1SUNam4YoVBH//1RTDAJGQHcyNp/1UY6\n\
Sgyc4jRq2Ltw1+VB/PJLUOx8B4pd77DsLtuxF36FFSt+avtNr8HSxmPvKDzW\n\
DPmB00zBfM5GVRc5G7nU7H720SUOOov9FCz3syP7WRsV3OMOSASh27MRFia0\n\
d1RAvIGiCn+RQrgDXt4EYv7Is6lLnaoyYnCALfSz5ofcnT2RRtX9a5BTghQL\n\
UJAPBkkEyqDb/zZUV8rZGY7yt14g0bge+rxiElV3Idt7InPFjvIsEgnZLKpk\n\
G34LyaatsFRVUUa7FdLdZ9gxjY5bWdDm3MlcsXb7OpgfTCA01QbJhrfg6OyG\n\
tfgSXf3bCFh8f5tuXGY9dm45wTX/mtqmn/NBpY58/C5SpJl17ZGFsr4A5+0s\n\
yE9fJp3pg7O1Cd7hbhiy8+Dl8ykq96VWuCVfmR+GY3CSFL8HjqYGuAd7YLxO\n\
7Xw9D34pN1QgyB+Ea4IbSsBETDelmb5FHTPsGJ7OOujOvg/t+Uvk9tLPZYC/\n\
gOTEe2yivefRq/19avOrkGzbDXtnJ5xdHbBWFEL64nMwlDUzd8CN7/4Tdmo2\n\
/CTWvTOpPyKZENcfgiAJeGsvvdIFhi0cCYWMqZv/Wzb8rxgZF5vnSCgiQHL0\n\
DWLqMaxYBzjSYU3ipc8kieyjq4TmX8CKpZPOYSZPJiILk2gOa7h1gVnk6thF\n\
Otdzd8XNh/gkOzFN3z0F3pUWTJcMwWMLpXoYPg3/wEOoDuwjPX+Q/g5AdfgQ\n\
BZ9GRkGkKo99Eyv2RiS7/5wu81+QHPtnJEe+hRXZNfo5OZLD9HnqTSSHvkWv\n\
OykZH0Zyegd3Ob4R2v5PSAr2sCugr6jIV2MqJHvpXBMv099PkJzcwwa9lZlf\n\
0PGv0eefI8nfz+ZMyeF/o2N3YIX3X3TMN+jWqakmn6Tr0bBMtSJ4hZpI8aG7\n\
/RRCCg1GzjcRKLUkMTsxeLWP6YF5LGX9FVsN/fBGFr8cgX+FTlKJ5Dh7Hqxo\n\
s5DkbU3dyE5u29ImrAhzuJvydNBNPU+kwVwgJTVMZcllSkEnfogV6RXa9mu6\n\
eLK7X4Lk0mWsmKppGyV+fgP99l1qwK1MxUba/wn6rE7dyKvMjXwp42Kr3Xrp\n\
Zbo+3lP4KXZU8of+rbB1YDmUph6Y/x18YgV4lxowRm3ClPj1SilnqV9gsRdU\n\
6yFvX4RLrIK4WQS/1kif6VVDOXGbCFEPBfS6aQr6FggfTrJrk62EPBA28hEO\n\
RKHrnsRkTgdmC9vQfboJweDKY2nQ2B4QYJ7lAjDjH14+u9LyivUe3ftm7oLd\n\
rdTGu+iVaes93D2IthBQ2lM+oKS2/jlWvBTsxrdngvbKAgGOT6Dq+xqSM+vo\n\
73UC5VMEjCWywQkCyXMEpl9RW5PEiQfp935G33EBeGXudaat/3fK9IlwHPUk\n\
Q6QmzoUUIg9u3tbjzgMzOjqtaOigfNfoRxePE24GqQfdPKYcxzK62yzsvmXV\n\
Zhjcy/RLMdTcNWBMHMTksBOL6ijCngjuVxtws1yPe21OhGNJyBbdKKLjSmhb\n\
26iHQWeq+ALXfUSyMujB8MFyCFvFMA3PoPvIA0gbRzF4toNtA/eMEBPXumCg\n\
74Yu9sIxJ8HE9V7YBRKMX+0l7tGh93gdbHNy9B6rJQFGN+41Y+BCKwxjQnS/\n\
VwXdDOGgrA2t++oQIrGVJvjlR5D2148yQM9fUIP+K/0RC4z+O1ac1KA2Avf4\n\
m5xhfH2cMT1krL5v03cTWFHso+9fJqawYUV3iYz0KoFukb7/MlbMRJzufiQH\n\
vk2E2EaG/g8KXEK29yQ58I9Y8cjI0BvpujX0fRE50ZvscuzJ0X8mhyQl6BfT\n\
++8ybJA2pk7kxN5DYtxuc7N+VXpLjcZhL2laP85flKODF4BR7kR2DbcylHDY\n\
jPyHdiyMWHGp1ASdKYLBLjMZygW7yY9zV7SwuOO4X65F75QP9ff1qCKpYzCG\n\
ca9Sj/5pD6qqdBheCMKg8uFcthoSa+IjxozqNOg98RCBlML0qmzQ94xj+EI3\n\
226e2SVM5vbCODaL0av9lNxKMZnXD8e8FLycfgSN9EunGyk9ISV+uoE9zwrl\n\
McPX2yF5OIrJIu45z4rHgoFzLQj4VxcaSkZJmXeaIHWly8B+nnLLGG53mTCn\n\
CeD+hBN+Fvkr6By2YMmZgNngw+UHWpyt0aJhzo9lopXuISv0wSTs5gAu12px\n\
5q4WJf12hJdXYNT60M7nihXGghHcou3eyDLaB0243m1jOp1Tz75S7MvbnCY6\n\
jn2dxKgL3MAOBCjcL10h484jOfsSgecndAyRlfAt8uLn6TMxrpPk1zKx6dRv\n\
yMspjIz+iMLRXZb+VvR5tM9PsTL+M8oFuYfWkL5H257FCtNXnGYWYhnM/Jb2\n\
Ixae3c10PHDy4Ktszl5/T4f7lOPm3dDBFUmit41upUiPdrq17EINpmVRWJQu\n\
FNRxD7yYtdWKG2xorNbjYrEeLZ02NLdb0NrvgoESpoIyC9vEDwksXUMuFBao\n\
UEKswezX0GjG0KwfFkMIA6Sri0u0uFpqgNGbXPMRJMXNBvQcugungyu2pich\n\
qmobQ//ZdhZJXoGIaKDn/42kRSV6jzAFs8FmxIOXWiFvGsfgeQ6RcZMWfbTf\n\
o0himqXgrgJ5Q+4MkjQyFzbmkcTU+3GUbt3BSsAk8ioUaBZ6cfqWHGWjLvCX\n\
XNiSK8e8JYqbVSrMmYI4V65A6ZiLjg3icqUS9eRDMqET11u4NVDC7gB2FKmh\n\
d4VxpFCGJpGfLeaxmqqswODVY8nnzAh/pkC/zu9AJJnO2j/FIa6faEJ1Byvq\n\
Cnoto23TmTn+bO9Liu+iLnbcldpngizAjXRjv4+HuFb4e2YFTkpqbLA4eqGz\n\
dMDPpI0kNZnl0e2uQZgcIwiEKHv1SBD0LSEai1DQNCASD5OwY+if65Dy+/jQ\n\
Ghvh9HP9BmFSbpFYaPV9ahRGiNRdjI4NhlTstHmvhweDtQ9+UoAO9xSiyfSz\n\
hK8i7ArhylU1DJSg1VRoMTAfgtMYxNikBwKBB1eyVeCJI7CoXLhcbmHvWjpu\n\
xc16B3oajLhcZoJIEkBvpxlZeXroKezduJ1akaaSAsqEB6VkkcoWB5Zov7u3\n\
NChtsqH6jhYFlWbMCv1YkgWZWSMfBS4jUBfyatGf1QxBYTO6TjZCRYq0+Y0b\n\
mCjsxcjhO5gq48M8PoPhS30fBy7Fs75T9bALlejanIshimOTl+6j51wn/CYr\n\
Bg9VYDyvG6PHK9C8t5bRISmgfAlLIge23VCgqMOEEqLCk7cVON9hRzQQxokH\n\
evJvDrTF91S4RzR3kMg+PcJUowvA6oujtIY0pdCFnfky1E26iPDdaKWmG5EF\n\
ICbQFnRw80vDngD2lGpgJNCeLlVCkZ5c/fssXquF1fhZ73UMu1PdknEb3urP\n\
hyQSW+3UJlkvPAQsHqboR6/zB5ie0cw8XvL6m3N38PO+PAj8gXQtoXhEhuHx\n\
x0ilrMUY/3W0Dv8HTD4tzLoP0DH6JGaEB4iOv4HRhVwIFrdDYpjE4tI2iA2z\n\
cBiKMK9ugdfVQiHgPzGx8B7ah38Ao1uJhcXNWNJx4WV24S0s6ZmH6svgkfJW\n\
mWcxyX8GcsM9dIw8jmnhMfSO/Avaea8gEE9kYDk7YMaFEjMLt6UxK65WWsAf\n\
suFqoQ7dfXZ8cJkIQR2Dlfj00GkZiu5Z0NVkRCFxq13nx+XrajS0WVF4Q43a\n\
bhe6W404mqXEnCqEB3cIlrMBLE7acZm4upnscJ5cYE4ZQtMDAworTWiuNyKb\n\
+NQbz8AyLY2T4RB0/XOQtgrgtQZIsfDRd7QemhEh5F1ChEMJhAleRoEBLgFF\n\
6Zw+FpIT13oo0gWgn1QgwlRykehgnpKSdBbAbeJmOYYtdqi65mGYVsImtTAp\n\
XBqRzMTEQ4VSXOqwoWvUgg1XJBjQxrASDOFQlZbtoWXgkn9XhdoxG94r08Aa\n\
5kjKYg3DGYxT9NBgXOLGuwVS3BqwoX3SgYtEz1e67ZCKycGbuNXYokSje+h4\n\
izeCM7eUkPuWOcN8mZ0pJnfroEpRXaOkDu/MdLH92nFC5uaBPLRaZBg0iaBM\n\
PeIKxmOwpOtFEF+N0vczztRMMaJKgV2KIYsclrAfC05ST5EwLEEnMXICpoCD\n\
+Iq7jbL5KhxeHE09f/8aXfJG9MzszDwq18r3oWvmAKSSneid2QyXT4jx6V9D\n\
ZpyFSLwDUgMPoiUGyByAhdpmAuvbECi5+G5QHcWo+ArmhO9CrJ9it80tvE2A\n\
TwP4VRbAU7PPQ6y8htaRZ2HzCiAWvYYxaR5nqa/ApAtBa+VuNxZJEL2FmBWz\n\
IVrwYpAC26IszD6oC/tjUGlDmBX46JL9WFRyvX9WiunDbAAMsqsOzJI137+k\n\
hdYZh4L209nirKXlEh97PomO6zeOkCabmnSjn7aZXQluNFFmUJF1dAYjVx/t\n\
8/oD2PkLmLk7CdeiDNM3h4hB5ZgsHETYasF4bhdCoXSBgC+hsUOHvAEXlApi\n\
tFLu6W3CH8L2HAmuddkxRYy2lcL1gjmEC2UKZHc7MCdzY0euDDxDmA3hC5Yw\n\
Cu4pkUP7izQ+HC2R48F8EBqpC+sJzw1zHrT0GbCzXEcN7MXeAhlalwKrS0R+\n\
heKXGE93ZiFHMcfe9H3RXXy34zpU0ThWEk5s6D2Pp/pvYN9kGZ7pzcGsP4BZ\n\
zQCyFgcRitqxbSgXG8du49W+K7goHkOLshu/IF48NHUXb9B3j/fmYdyux4mx\n\
EkgCdhwZuQk5i90kCmdv4QfdN2CKJVZLyiQxJXgBEtPimvTc35VlN2yuRYQC\n\
MiyIz2Jsdhua+78EuemjMBRQqC2FSNeOBeFmgiM3wtxtKqYwfBKCha30HS8F\n\
Q+JRAzfNanLuNSjNfOLRX5LeU0ImvwTe3DvoHPoawTAnPYRfNevE3Q5XJgaw\n\
BaUpxLT3cp7b0WLCqCi45h85nPxd5o6Y9UUszKTpjERKBELMZP4PYSdBvBNw\n\
BNjFaYOuIL1G6DVA/hyHz+JhHjxlsGPUeLDvtgrn7iqRO5B62hSK4sGgFXd7\n\
TThWoULFhJt9yuqwBXGdWcquQo0aSpVipN+GialNoSQCPkoUmnQ4XqlBzQQ7\n\
PhImQwDVdJ7iZj2OkoAZUwTJ6S1Yd1mCS6SUI8sZ7BhsfLwxVg1mSfll0lXb\n\
B67jmf5rKFDL2do/b/ZdQ4eTK/KQP1uOk2IeBLoRXF4awqC6G6+PP2DXirWT\n\
Tjs0XY8PZsqwa26AAlcc3dJm7BK0E2OHcWy0GFLCznF6VUYTFGhNeJN+55d0\n\
/ntG7YewM7sWS8aFzECsgLsbfVPbYHbST07814cwsygijGgGoZTswqjwHBTK\n\
8+iaeBFGO2kY3n9iUdeBReELaBh4HBr7Aubmn0XL6IvQGKvQOfIYDA4pxqd+\n\
Cp2TmID3ErS2IcwJnse49GZaHz86FSSjj1efKWdGPoX9UTi4kJWZi8FUsfIS\n\
4Qcijxz7u84XCyDudqag8WHsrbjhm32LsBVI9cH/HqutL5XJ8Ox5KWat8T/K\n\
7JpEW78FGl8iM8eGmbZ0oVJNsSmtb/8cRtss1pHNGYoUGYfxBtmwRz2INyfq\n\
4I8RZQ0WQJKKTZOaPuyf68CEZhRXxYNokLfi2OLg6pgt+k2lU4wd4yV4b7IK\n\
20ZysWe+k9LAD9tcSwFpUt2BjVOtaJa2Yet0OzMEKP3kRybehB7+LqRL/tiM\n\
heSIOVhOBqDR5GJcsBuLqnJEE3Gy52YKRWNwOodhcyuwKHgJ3dPb4Qu7odfl\n\
YJS/nfatohC4Apu9ExJlLjFrKyy2bsg1NzE5vwcibRudm1kxqYHCbxQ2ay3x\n\
xR7wJTnwRXxp2vKTpjQXbIYpfx0cPTXcTDTTFCxFb9O2N+HouodkxAd351WE\n\
1NNwNt9jy9p627PouLdhLdmFsDklIIS1sN3P4XKk5Si8bWfoHLRP6W5E7U4k\n\
SWbaSjfCWPgOrLeOICBXpOERVbZCW3Tu4/D4PAcP/vOImLoQs9JNhTkqSTK9\n\
48sp9b1M6LK3IGppxnKMg+hKVEeIm2SRvBK3ImZrRswxzM7O5b430rZWxD3z\n\
qSv20vth4ohABt0qlQeN0262X+JRDI7NOGEKLq/OTyPIu30xxiAZMWsk3nl9\n\
rIaOXUb2dDFOifmIx6x4qY8M6FTh7f6rqLUYWEK4xr+FY0sTmCXeuUS8w9MN\n\
Yu1wBVPNEB6/AkcFHeCb5lEqn2BrntWIarFjlq49sYrBE6Ml0EYCeH+8ALkq\n\
KSlSLZ7vzcVSKJKpx8Ks1TXC+3cS/89ijIR56+B3IDGPpGskzC9ug0TPg0qT\n\
Tzyhgs9WQXLn+7AHXKu3T3FuXnQYznA41Uxfgr34ZZgqriCi4UN/7mkEpDLY\n\
br4Ce3szoiYhLCU7EBTNEWDWwjtbD8PV44iIG6A9u56dteDvvwzrwwpWZtqL\n\
fgX5u98iURxATPIA2qy3EDHr4Ou9CDuBz1m1HaY75xFWCWA4/n04x1Ll8v4S\n\
UVUTNFd3ICAegF84wj3qSNBprDp2/GtEPQbvXCeiThPC6llCg4n7jkFDzEdo\n\
0HBByqlAiG6FCWZ/+hEwIgDf9N/DPfFjSr9epdcnkAjbERQ8hahHzT7yCgqf\n\
hWf6ObqEV+l1LQEyirD0DbinXsNyUAu/4CfwzZM3z/4UPuE+LBOQ/TPfo20b\n\
4eF9G0FtJ+K2IriHv4mYz5Qq0Pg1linOTpbgBx0XcEPcgQ2DeRjx+FgA5U6X\n\
4gNhH3aN5OGV4UJsG7uJX/cXYoaE0IKOiG1plMDixYnxfLw8UoxXqcUPkTjS\n\
umR4dSAb2ybv4I2BHFyT8dmS00dHOFCdHLsFvkOC1/tzMRdglGocp8dvoEQj\n\
y5THj3tgsNRAbbwLp9+wOtlFxVbtCwTlCBKBMMvjWh2Un0dDj7hSHG7vErsU\n\
BIdBRreuwH53PwIqO2sMd/Vu2FsqYLr0ExjytsF2Zy9MhdsQmCOSuvkafHNN\n\
MOWdJQxdgvro47BV7oe1jEinthIJmwDGK+vhqD0MW2cjgoO0z7H0PptgbyiF\n\
pWAr/CKuzJ2v6Rhc42nq/0vEyBKy3X8KbfE2aC7+B/RV2YgZx6DPeRtBWTuU\n\
Zyj3rdwLzeXvQfH+E3APlUB9aQOr8+P6Xmivr2dTJEvRk1DfIO6PfwRQzP8e\n\
AtRPEXVxNe9DwqcJAHSp888g6tVjJcSHZ/JxtpYbW9eHwBMyjiAsWY+wYw4J\n\
x224eT9APGjFsm8OQXkxYfsMuRn33GTZ24ugMh9R41UEJLe/kcISo/cmVd14\n\
uv8mFtwWqHx20tupOYARijIBJ6xBNywBK4bMYmhC3LQjm88AvpN7PBKPBzBu\n\
XSLhrMkka66gDYPmJfBdRjbSrSR8ODxcxIrqY6M3sRRw0W85MgsCO0NOmMOB\n\
f0gTSdkWOPsHCReUC2b/Fu7RfljzniNyqERYNgHd+4/DMzYIS/Eb8AkaYcw+\n\
hfD8PWiOryWDCOFp2g9dzimKTidhuluMhGUS+ktvwT9eBs3JF6l1RHA37IU+\n\
9zjspZuJoJqQpHhhy36eDD+SXtqBIRLVhfVMbSckSdNrrjwJL1Gw8cYmMlYR\n\
lHTKqNUI7+hFwsZFRFStUF98I2X3PrqEDcyjOphurINPZvizR03+19QoLgpo\n\
LyIe4gJVVHMQASUJ1PlfIcpURA7y4OWvRXp50ZDkdQTV7dQAb5PJBYhb8+Ea\n\
/mvin/UsB3mJawLSncQlWatyixowZrwMv+T2mm+mtgWCJtRq5pgiGJnANasd\n\
R454lP3EjcP6JJJEmed4VVBQMn6BBI86lljznZSBnBUboDn1NEw5L0N/9V3E\n\
wwlERQ0wXn4BpoL1MJWeQdxlIqZ/GT5RL6zleWwDO25vou83wXDpRWrJMdhK\n\
tsG3IGErj1pLiAvnKTmv2JLa5wV4RRIkDMMwfPAUteKb0O7/NvHnRMZAykZo\n\
809y7ZP0wnCT6HWCAgsplljQAVvNbujyXyEHfBza0kuIKFvIMdexzpgwDZGB\n\
OMc0FW2AT67/kIEYkvfDN/l1MsotIuwl+HhfR8g0iODcd+BbOouEdxJe3j8g\n\
TGdaDi7S+2+ST/aT7/4KQT1lA74heCb+FTG3lFTJXXr/OCKGYnr9PuI+chb9\n\
B3Tz75GfnoJv8Qw1eGLNd1MGiSWipFCjHzIIuwRzhJItUh7c68qaf0p/x9Bl\n\
1V54BAsUfiXsiPF0Ky17LYjolZyWD5lhyn4GAdrHP8Oll8yAz6hegriX67FZ\n\
9nuI/DlHToaYpG6Z20fH7ONPjxNd9ttIaBnhaz1LTjOwGn2bITv4j/AppQjO\n\
lEBx5mfUWr2sTSI2Gcx3tiBsN8DdfRSagrMUjVsh2/9VeMUL8I9eYYkzEXRB\n\
f+0ZuKZ4zE2nyfJvUrFhhRomaLSlBrcy/4IIid8mKngF3pkn4SfjMCMYwvK9\n\
tO23JDCvIe6ohm/mZ+RRT9LnG4TOLnhGPwPP1OvUWDEixgvkQU+yx4dNnewN\n\
R1QHadvT9PdzhLVVdPy/wDX6DYaQ1+xPGcrTk0dG5xKaT6WNEXXD1ZrPCmVH\n\
fQU7koUrV/C3CE3VUnMsIf0vbh6HPnstdIWv060/CSdvguhqHLrsdUhE/bDX\n\
bIQ257fQXP8VXPxZ2n+CmnId9EW0/wf/Bef4KELzlZDv+wtoSnaStPxIc30C\n\
caMCU8cLEfStZJ6FrCyH01ewOvA3Q8cxIo5Qun85vLQOIRsvc8UryxEm3UuP\n\
Sl6J+9l6Luxxhivwi29nfjmZTCAVEVI1Ez7Frk7xoX9MNZSVVBGKTyNJ0Saq\n\
USAwM47AvIhNIpnyIzGrPbO6T0wjhm9slDSlGRGFGDETyXqdgQM4pQIxPVco\n\
J0nRLDA5QppTwp4nYTUh4ebYdtlpobTAlxqQ9Ads+phMlaeOGwagvbwWaXgx\n\
E26Ty8mMfGYoeTmaLu0RoUTmLfik2j97tNn/CnGTEtPHCmDmiWEdn0fAnurm\n\
NdsQjzANRimzRAbrtBhBiwNhm4ddXixodnKVDeIRFuWJgI7oxU3v7cwPp4d3\n\
rMQslAM5U17H/P85cggPJoW7UDv+Gzwc/xWGZXdZmxrM1RTmuekIdnsjBNoW\n\
6C21mKZwEo2o0Tb1IhYMAoRCQnTQ+wbei+gRUkCj9NvjGUET73k0Tm1E9/wB\n\
yByZ8YCJuBtWn4J9yJae+hajFMvsEbI5KfPP7VvAvPYBxJZBhOLxNKiYZVac\n\
YS5fjET1dBr16pKSf4fIZAMUrz5PGcIV6PaRimvqR1w5At3VYtayy1YhNHu2\n\
wlyYB8P7u6HctBHe/m5od+9DLEwx12+C4fB+RCx6mI7tgOHiOej20nlau2HP\n\
PwdbPTf+01NxFfbGnjTrLpN0d/ZXs+N1Hx2OHLOq2eLbH7WwRYPJLccwcagA\n\
8xduYHRPAeVKPkgvFMEqtVOEm8DIxiwIzt/C+JbTEFxrRiJkA/9cOYJ+BmdS\n\
TB4vYnpaSS/IMHnsJkK+5S+lrClRnkTJwJNQ2gXQmh7gdu8/Ys4igVR1Cg38\n\
LPYGdNrL6Fq4DKHqDJrnrsHtbMe9sd/ASQw6MPkEusR34PRJ0cd/nbLKPrSP\n\
fR/dkkqYnYOo6v0yxnVzaeJ22uqQ10sxN92jvhKlw9biQsf3YIslYLZWIb/7\n\
H3Bn/GWU9v8Tisd30L7Ms9AQ6oa+haLJo6xtJkVb6ZgfwhZNVyv/O4THHkB/\n\
JZcLvAY+NPuOUBjtgf56Kff4WDkE1e5DFAr1CJHC0h4jxrZIod21N2VPClsn\n\
jsLTVQXt+1e582gFsN65D1tuFmwNnD29d67D3tS79qOeqMLk/qtw6hgPXIbk\n\
Yi4krQLIrzDFaW0w3KvCfDm32qzuTjVmLtZTNmbD7IU7KTvJMHWiGEwB97he\n\
Su9LGDt9OsWAH5l4wbBhBj0ridXF4VcnXeDj25iaeTPPYUA5nNr2V5gT70G7\n\
8DakmvNonbvEHqDXZaNXeB1L6nNoW8gle3egSbCf9IIb9/q+gIbZwxgSZqF/\n\
/gxmlLdRM/wbprw9e+y0aAfGtTOr9q5HQd9L8KXsrTeW4ELLZ3G15yewhqxo\n\
HH4M9SJuZsZyTE8E8BrEbivp1Tnkd30R13t/BWfEg5axHyKr7cvgm8WZ+Tvh\n\
0fswlqfGH0ds0B+kTI7fSfZOTbpMBOG6XwrD2ZMwnjsIzZEriFF+od29l8mO\n\
mIWXYTp1DO7mUhLp5ZmVBwMB2PPOwNY8wJ7FV5VD5u75qLmNSjLRTQS93I2Z\n\
mx5ioaQf8qucufUVFVhq5MrYu8aGyMx1rLn558ncAQagckydLEE4zLyXpc3N\n\
ZaZ/Q27hQLRjD4L3XkW4PQvJsBex0SwE775On08g0voOYrMjSEjuIq4QISGu\n\
Qoyi1IpfjvDDNxGqXodwxzmKNhRxbDMI1byG0IOtCLcdJj+QPIqIkZm1GFaP\n\
ZxAhUZ4mq1+FhBDxcPoQB1jdFXQtXkkhIg8+dy+aCREJct+Gwa+TtxdB5yDP\n\
5z2FxtmjeDD8E6hTCwoOzb5EiJhNnz6NCD9TSCaqRjl5+d3Jbbgx8AsYA0pU\n\
938DxaMvoXb6LdTObMbDmXchtqug0V/DrfFNqBl/jk7XgDtDz6Fx8hXULeYy\n\
3v2JFAlEJuqg3rMPIaUW/o4yqPeeQmiJHH/LJtLEs0h47OTM50lvGxAcpX33\n\
XSBQSKBa/zJTYgXh2T5od+4n4hiAZucWknFaBAbuw3C9CPaCLGjPXmEX2bSe\n\
3U+oGOSw+BnonW50S/UY1TkpoHFRyej0oEtiwKTJk/FGjc2FQbUNKneA8t4o\n\
W5da64ukA5s/EMSIykww96SEwQpkZjt6FWZI3KHvfgSDZhV475yHWWQjPohC\n\
9P4VSFpWKYfFYB33FMs51I/Z8w9JUjgxtfcyTAsWkjMSChkUqJRukjgLmDhc\n\
iJA/mcZgfOwYgpW7sWycQ7jmWYS7KK2/9SziahkSomL4s39IKtJGuDxCsXSI\n\
3T/C60G06SWEe28h6VAg0rIFUX4vwtW/oG1ldK4pBAv/GZHp8Y9jcOwRDJ5C\n\
+8I1SLUXkd/+VbQR1u71/zOGFG0Qq7PQNHsSI/Nv4mbvv0BilUKhuYiq4Wcw\n\
KDyGqoH/gMKpwqJ0F8oIVF2zm1HY8VlMGYQfxuDL7JqzvMW3kDP4CizuSRT1\n\
PwlTwIDagW/h3mwW5NZuSI33UNDxBfQrhjA89zo65LXgSQ4hv+cxlE2dJkar\n\
xI3BDQgkVjIYJGGhfncj9KePQ3dsP7zzSiybFylRvfh/2rrWmLbOM5xp01Rp\n\
+7Oq1aZJ3Y/9m7Yf0yptP7ZV3X6sU1dpk1otW7YqUrd2bdo0kBByg5AQIAkE\n\
kpSQcEmbBHKBJNzDzYDB2FxsY2wwtvH9fsXGNrbP8QXy7PU5x0C6WULHfBwf\n\
jp/vvTzvd773feEqO4FNkxfx3ma4zp6in1KsP8snTXjgv1QDb20lHCWHEewc\n\
44ogxfta4TpTAuepEsTUeoTbLsH62X/gPncSzrLzYL2xwr/1B/3Y3zmD63MG\n\
nByYRYPGA4fPh3/QWK1kFYceS/ClPojgegB/7ZSgfFyNAw8nUTRthZFE+sik\n\
kROVRCKO0m4pTovU+LhrGi2rPszqzfigew4NkhUc6JJhwht//WvC6HdAeawa\n\
C6eaoDzRgLlTJCHhBIyXmgX/dx/6PsEgSiXEU3qI7kSgOlWHhZONkBfXYb64\n\
nthsI+YPVWHpxrN8TcWCMKb7DoBV8vXJ84mk2/5lMnT/RLLzU6Rn6pBoO0C0\n\
PouM7AwJ1wyy8+fASp8gdfuXSPUcByuqATtchbS8Hckv91PczG97zEhOgJVL\n\
X3SRf8G0TbpHGMvI2JHJYJ3whjUweTqhdQ/ln/thI7YIa1ABvbkcd2f+AP9m\n\
gLuGJzgAjb0dnphQdWGbgd33hKRpEOOL72LuRYN4a+ogLN5eNAz9GMqAGZmU\n\
kgT090RvWGiMJ3Bt8o/QBWRYNJbhKgneWmgRt0U/wVKQWK23DVW938LA2iNy\n\
ay40i34GbdhTqEXDTN8nL9lBrJ7CpNxuREUs/7lAn/OhLsXfgmP9DrbTQr6G\n\
8NpmU3x8Tq/Q1XIiQuMUOKS5NesC+QoEQxCZaZojcbTPLOKw2IC26SVcVfEJ\n\
EU6PGwd7VRAv6/GJiO/EM6rQoGjSDJPLiWIx3wFdpTPgX8N81Rh/MIBGmQHF\n\
fVK0aLzwx5IY15jwzLz+gvC9SneTAUMmmKFgbV21BibOb1gwVDXBr/NxJYkY\n\
ocjdFrnfVCjGdYtnyBwzgQDCahNhTtdwe/j3bE4ItEnyhg6CEfONf7ZdUmQN\n\
5EX0/cjqhpFVtyBx811sb6Z3JW+ugrzQMzDtb4CZuIGcXQL2yXtIdZ9C8s7b\n\
RPT4Jc30sw/ofNleyZtVHSTfJt8hbEbrZTKDDcJM8hNndrZAvHYfTEIPufUJ\n\
F/fz4doPodKXYt65tDNxkWA/Gsd/jebJn+I+2TNubWZzjkTrd/Cx+Z6RCSwY\n\
yvCV5A3cmd2PlcAK2KSWfG4R1jP5ph5mPJW/DwPXyHoLkpUiCg5WdzrgGJXY\n\
kHG7WISEyW8iMTWMuGZNuFleNhgmgdoxBT4kA1Iu1sIYTeKWWIUHa/w21fhm\n\
BId6FBhaorme4NsNG6wWHJuykGw4UCTm16sVyzoUTQn9WvPr07EYjj2dwr/7\n\
laic1KCkbxaVczZBNl7bAXYb5usdCJqCQl2jH2Db0Ydk0y/AjFTQ/P0Kac0c\n\
0gN/Q+pxEdJjJUi0HCSNze2Z07P5ueLcXrL1z2BHK5BsfhNZuxHZhXN0jT+B\n\
6TuMzdrXkF5SFGL4JBMEk91VpnRmA5tsrPCMm/+V23MnLJJ+Fwwb5DpN707h\n\
AOoGXyL83oQnxdus1KYM10W/gZdJ/FyA2O134532GagDMYgI/l5rCGKNDgcH\n\
1XCR2gyrtPhoSIuZZQM+FdTP5LJx0JrdTrzzQAqxawM6uxN/fzxLhiUBsXYN\n\
pyZW0ShW4tysBa7oJmrIVV1Z8ggQ/0j4ItlkvnEoX2ePh/j72PIuIKP4itgp\n\
v83pOWGR1T5BZqkLWyE+85E3vhKClxjt/BSvnvZxYrYPkfMKE72dQc70jNRt\n\
hFjvwfw07GmW/nynnMXeTQKFscJCVC73v83g41EJ7svegswxvaNv6dQqUd6P\n\
EUoz+wrI5nIZ3JYu4/iQHEcGF7EcYZDbyuCmRI3iQTmKhxahjrCwEHINi/y2\n\
WXfAi0a1B55QADVTGjpvEZowAxE58MP9CzjUL8e4J44kBX7V40p8PrCAM1MG\n\
BNJbArK/Fe4/I7uAtGqehOwi0kpZYV0mK6sseEMh7eYVOGj6ap5aUD/oQPOo\n\
A3fngxApvFgJpcml0TGchVYXwgU6p6rbSi4uhWhoE53KELa2ttE/46JxC6r7\n\
HTCEs3yPv9eIJJoQmZxEdEFF5JFPgWONq4hMS5A0u3bmKKEhYzAnR9ofQHJV\n\
ixzDIqVVcZ/dXDULDz6TiC/MIiImkyjs7ki7HVy2S16hMz4Pl+FVsHXbW18L\n\
ere3hb+9xAXE7NbWnrpE9I6CUIY4HRHwl4RL5MWhkDnCkknL7C0KQR9heb8m\n\
rInv4P48GcZzNk1UI0JHdmc9LLlOQ6k9uL+K+0NGVIqC8K4nUPHVKoaMCTx4\n\
ZsKEPYVHQ2b0LK/jxD0jFF4WZlsY9aNerK2FUDPiwrIhhBNdVniiaYjlXtyZ\n\
W+fWhQqlg3MUmRgPH4b77n04q07D9WgYm3OjMBUXw9PWCtPhIoSVJqTyqaGH\n\
S+BpbYWlpAhrJ6vIS3fA9PlR+Ih4WYqPIixVI3C7FqYzNfA01cNUWsbtBnVW\n\
HkdkJb+fegvua9WILHkKa6A2kQ7iyxJMXpmCvMfI5eC4pXqILk1B0jyPhU4D\n\
V8V09ZESozXTmGkiyzHqQowIrrh2ClPXpFjo0uU7WheqPr4roKYlBM4/tqDh\n\
mR2ff6mD1M2ga9gMsSOFJ2MWdMx48EnrKjEiJ9FvOy4PuaEltOpFLowsePBR\n\
mwGNI07U99vQJgtw5RgKqGV9ZkRmVRSn2bBO0bupphHO6jK4O4ZJPP2ITQwh\n\
JNMg2nMHlpprYD0+RB7ROR3dSGg1xNeJQVj0cJ4ljn2zBeZjZ4k98Euxntrz\n\
8HWL4LxYhsgyj5qn8RIiam8BNVWLBBMty9hwhzF+XgTjgg8ztaPQKQOwjqjQ\n\
Uz4Hv9KIvrMSBO0b0N6TYuiGGvqeFazQ14u6AhgsHYTNlPw6ak5XFE9ngzC4\n\
4rjQruPQKqD2eMSCXk0IxbcNmDLFodb58eEdMzT6EOrG3FBRlHik3QSdJ4le\n\
kQ3l/a78niEBtde5Eire+iqYj5fCefUGEkYL3JVHYSqpgOvaNdjPnYatqQvZ\n\
SAC+ti/guFwHa+lncHT0Im1bhb38NCwnz8B9rxtJ/SLMR6uRFVJmQ63X4SF0\n\
nRfLsbHKe31P02WStd0U+MUOOax6/tGv8ZECChIc6Rdi+MNbFB1FMVWrgG1k\n\
CTNPeabIeDwQtawguR7F4t0FjFZNYvK6HNFo9kXYXkHQF0NlpxFXBmw4/8RG\n\
EXeOVNMkwEdHEj4pmcqKx2ZUdpnwUB2D1xFB9ZCLnHQO7SNWzmRWdJkx52S+\n\
V9BO7zL07x9CTGdBdLgToUkpQg9uwXblNsmUB776CjjuDCAXXIPj5h2wFIyF\n\
SAPt7d2I9t8lLa1ByulG4O4dRGfVsJ38DP4xJZlEM6wlRxCaUMBZTgi3PAFj\n\
1cFSeoTQCxTkbOn2LOR9duTIrMnqxFAPWSC9OkmxRxbbRI0kdQp45nQYvDQP\n\
liysY2wJo61arD1cwHD9PPxrQehFa/nM9gJg73GHl8GyWdgDKSSE1kB3+42c\n\
PXs4aMSog+fW6xssAjFBK6zrODfg4NtGkFP2hhhEma2XBaDyG7RC91pgq7oA\n\
a3kVNs0+olcR+JpIhCoqYK9vAUuXQ3YTvpsNsF2ohrXyAqKrDi4wdl+9RGPn\n\
YW9oRSaZBqtbgO1sBaznzsJzv5cuzyLU0QTnlTrYyk7C0XQPWTZXAEpzdxbd\n\
pWMYvzyJkYtziIWSUNyWIRCmkCi+ibmmJaTJXclvzWD08jSGy4Yx2kIuTuek\n\
z0xx5m/ylgrsrhnbL7gXLl5c9EG/noFsyQ/tenaHdUTIuXYvcvsPdmolb7NM\n\
YSV3t3lBZqeA++4YfaPnL4x9G1vMLi3kcN7KUgSdLnSr3nOZHZ1Skl7oFSEy\n\
RVFkhCXYfJzDeUSap3Sh6w9Fg3F/HBsWF0ablrkhdiOBsDOa35iw7y3+WzcL\n\
d2eZMMDn4N1ggYul18PQjHAPWPa9zZ8e/3+Hfd/4L+duWQA="]], ",", 
             GraphicsBox[{{}, {
                InsetBox[
                 StyleBox[
                 "\"pear\"", StripOnInput -> False, FontFamily -> "Helvetica",
                   FontSize -> Scaled[0.24911032028469748`], FontWeight -> 
                  Plain, FontSlant -> Plain, FontTracking -> "Plain", 
                  FontColor -> RGBColor[0.368417, 0.506779, 0.709798]], {0, 
                 0}], 
                InsetBox[
                 StyleBox[
                 "\"pears\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.12293756065998059`], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[0.560181, 0.691569, 0.194885]], {0., -34.}], 
                InsetBox[
                 StyleBox[
                 "\"species\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.1035263668715626], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[0.922526, 0.385626, 0.209179]], {0., 32.}], 
                InsetBox[
                 StyleBox[
                 "\"fruit\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.12293756065998059`], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[0.880722, 0.611041, 0.142051]], {-18., 54.}], 
                InsetBox[
                 StyleBox[
                 "\"communis\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.06955677774183112], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[0.772079, 0.431554, 0.102387]], {14., -54.}], 
                InsetBox[
                 StyleBox[
                 "\"cultivated\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.06470397929472663], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> RGBColor[0.571589, 0.586483, 0.]], {
                 0., -73.}], 
                InsetBox[
                 StyleBox[
                 "\"Pyrus\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.07926237463604012], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[0.528488, 0.470624, 0.701351]], {40., 54.}], 
                InsetBox[
                 StyleBox[
                 "\"centimetres\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.050145583953413134`], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[0.8996399512215667, 0.7463488834690629, 0.]], {0., 
                 78.}], 
                InsetBox[
                 StyleBox[
                 "\"varieties\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.05499838240051763], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[0.736782672705901, 0.358, 0.5030266573755369]], {
                 75., -28.}], 
                InsetBox[
                 StyleBox[
                 "\"European\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.050145583953413134`], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[
                   0.28240003484173815`, 0.6090799721266095, 
                    0.7538800418100857]], {-76., -41.}], 
                InsetBox[
                 StyleBox[
                 "\"cultivars\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.050145583953413134`], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[
                   0.8439466852489265, 0.3467106629502147, 
                    0.3309221912517893]], {-78., 27.}], 
                InsetBox[
                 StyleBox[
                 "\"temperature\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.04043998705920414], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[
                   0.5019668524892619, 0.46131988850644284`, 
                    0.85]], {-64., -59.}], 
                InsetBox[
                 StyleBox[
                 "\"used\"", StripOnInput -> False, FontFamily -> "Helvetica",
                   FontSize -> Scaled[0.06955677774183112], FontWeight -> 
                  Plain, FontSlant -> Plain, FontTracking -> "Plain", 
                  FontColor -> RGBColor[0.647624, 0.37816, 0.614037]], {74., 
                 29.}], 
                InsetBox[
                 StyleBox[
                 "\"trees\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.06955677774183112], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> RGBColor[1, 0.75, 0]], {83., -2.}], 
                InsetBox[
                 StyleBox[
                 "\"ornamental\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.04043998705920414], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[
                   0.7513196300394465, 0.358, 0.48066210763162087`]], {
                 12., -88.}], 
                InsetBox[
                 StyleBox[
                 "\"bretschneideri\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.03558718861209964], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[
                   0.5750747800184488, 0.4174563783225715, 
                    0.8498130499538777]], {-8., 91.}], 
                InsetBox[
                 StyleBox[
                 "\"distinguished\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.03558718861209964], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[0.7989994773739094, 0.735166608597101, 0.]], {-78.,
                  45.}], 
                InsetBox[
                 StyleBox[
                 "\"grown\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.05499838240051763], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[
                   0.40082222609352647`, 0.5220066643438841, 0.85]], {-91., 
                 0.}], 
                InsetBox[
                 StyleBox[
                 "\"rootstocks\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.04043998705920414], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[
                   0.3103557220216354, 0.5867154223826917, 
                    0.7874268664259625]], {66., 67.}], 
                InsetBox[
                 StyleBox[
                 "\"wood\"", StripOnInput -> False, FontFamily -> "Helvetica",
                   FontSize -> Scaled[0.05499838240051763], FontWeight -> 
                  Plain, FontSlant -> Plain, FontTracking -> "Plain", 
                  FontColor -> 
                  RGBColor[
                   0.28026441037696703`, 0.715, 
                    0.4292089322474965]], {-89., -17.}], 
                InsetBox[
                 StyleBox[
                 "\"tree\"", StripOnInput -> False, FontFamily -> "Helvetica",
                   FontSize -> Scaled[0.06955677774183112], FontWeight -> 
                  Plain, FontSlant -> Plain, FontTracking -> "Plain", 
                  FontColor -> RGBColor[0.363898, 0.618501, 0.782349]], {-67.,
                  60.}], 
                InsetBox[
                 StyleBox[
                 "\"pressure\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.04043998705920414], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[
                   0.8342400905885153, 0.4628267270590103, 
                    0.0038160815296638794`]], {63., -68.}], 
                InsetBox[
                 StyleBox[
                 "\"evergreen\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.03558718861209964], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[
                   0.9603267270590103, 0.5591336352950514, 
                    0.10711783694067224`]], {79., -40.}], 
                InsetBox[
                 StyleBox[
                 "\"western\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.045292785506308636`], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[
                   0.7678998606330495, 0.7317110956258943, 0.]], {-92., 12.}], 
                InsetBox[
                 StyleBox[
                 "\"ripen\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.05499838240051763], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[
                   0.9728288904374106, 0.621644452187053, 
                    0.07336199581899142]], {-56., 77.}], 
                InsetBox[
                 StyleBox[
                 "\"ripeness\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.04043998705920414], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[
                   0.596786740995709, 0.404791067752503, 
                    0.7955331475107271]], {-42., -87.}], 
                InsetBox[
                 StyleBox[
                 "\"cultivation\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.03558718861209964], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[
                   0.9840111653093676, 0.677555826546838, 
                    0.04316985366470745]], {85., -54.}], 
                InsetBox[
                 StyleBox[
                 "\"variety\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.045292785506308636`], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[
                   0.6184987019729621, 0.39212575718243875`, 
                    0.7412532450675947]], {94., 12.}], 
                InsetBox[
                 StyleBox[
                 "\"apple\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.050145583953413134`], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[
                   0.838355547812947, 0.44746667828057946`, 
                    0.0208888695323676]], {57., 81.}], 
                InsetBox[
                 StyleBox[
                 "\"desirable\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.03558718861209964], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[
                   0.8510135028964549, 0.47400900193096995`, 
                    0.018912152606809424`]], {-64., -73.}], 
                InsetBox[
                 StyleBox[
                 "\"ripening\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.04043998705920414], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[
                   0.8493197142977551, 0.7407577460330839, 
                    0.]], {-10., -101.}], 
                InsetBox[
                 StyleBox[
                 "\"favored\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.04043998705920414], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[0.5472001045252132, 0.43417993728487203`, 0.85]], {
                 92., 45.}], 
                InsetBox[
                 StyleBox[
                 "\"known\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.045292785506308636`], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[0.7748409210981391, 0.358, 0.4444755060028629]], {
                 0., 103.}], 
                InsetBox[
                 StyleBox[
                 "\"north\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.050145583953413134`], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[
                   0.9324333565611593, 0.5282889043741062, 
                    0.0921900209050434]], {60., -83.}], 
                InsetBox[
                 StyleBox[
                 "\"gathered\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.03558718861209964], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[
                   0.8949268664259606, 0.5032845776173072, 
                    0.05843417978336459]], {47., 95.}], 
                InsetBox[
                 StyleBox[
                 "\"diameter\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.03558718861209964], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[
                   0.6102054708420535, 0.39696347534213544`, 
                    0.7619863228948663]], {33., -101.}], 
                InsetBox[
                 StyleBox[
                 "\"ripe\"", StripOnInput -> False, FontFamily -> "Helvetica",
                   FontSize -> Scaled[0.05985118084762212], FontWeight -> 
                  Plain, FontSlant -> Plain, FontTracking -> "Plain", 
                  FontColor -> RGBColor[0.915, 0.3325, 0.2125]], {-56., 96.}], 
                InsetBox[
                 StyleBox[
                 "\"green\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.045292785506308636`], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[
                   0.9874666782805795, 0.6948333914028977, 
                    0.033839968642435214`]], {-49., -101.}], 
                InsetBox[
                 StyleBox[
                 "\"China\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.045292785506308636`], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[
                   0.6753413537738198, 0.3589675436319385, 
                    0.5991466155654507]], {38., 107.}], 
                InsetBox[
                 StyleBox[
                 "\"Bradford\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.03558718861209964], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[
                   0.845266573755366, 0.437100139366951, 
                    0.03816643438841502]], {-41., 110.}], 
                InsetBox[
                 StyleBox[
                 "\"France\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.04043998705920414], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[
                   0.23716678280579248`, 0.645266573755366, 
                    0.699600139366951]], {-85., -84.}], 
                InsetBox[
                 StyleBox[
                 "\"Europe\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.04043998705920414], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[
                   0.8564488486273256, 0.42032672705901153`, 
                    0.06612212156831418]], {-95., 75.}], 
                InsetBox[
                 StyleBox[
                 "\"subsp\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.045292785506308636`], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[
                   0.8613800418100862, 0.48092002787339083`, 
                    0.02824203762907758]], {75., -96.}], 
                InsetBox[
                 StyleBox[
                 "\"edible\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.045292785506308636`], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[0.5407932311309059, 0.715, 0.09762679674248334]], {
                 94., 80.}], 
                InsetBox[
                 StyleBox[
                 "\"America\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.03558718861209964], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[0.7277983389807635, 0.358, 0.5168487092603637]], {
                 29., -113.}], 
                InsetBox[
                 StyleBox[
                 "\"gardens\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.03558718861209964], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[
                   0.2198892179497479, 0.6590886256402017, 
                    0.6788670615396974]], {98., -79.}], 
                InsetBox[
                 StyleBox[
                 "\"Asia\"", StripOnInput -> False, FontFamily -> "Helvetica",
                   FontSize -> Scaled[0.050145583953413134`], FontWeight -> 
                  Plain, FontSlant -> Plain, FontTracking -> "Plain", 
                  FontColor -> 
                  RGBColor[
                   0.5833680111493557, 0.4126186601628758, 
                    0.8290799721266107]], {-102., 58.}], 
                InsetBox[
                 StyleBox[
                 "\"apples\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.04043998705920414], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[
                   0.8878600487784333, 0.33792799024431336`, 
                    0.2577332520359445]], {-91., 89.}], 
                InsetBox[
                 StyleBox[
                 "\"England\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.03558718861209964], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[
                   0.8774935098648088, 0.34000129802703827`, 
                    0.2750108168919853]], {89., 95.}], 
                InsetBox[
                 StyleBox[
                 "\"densely\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.03558718861209964], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[
                   0.15725938678540247`, 0.715, 
                    0.5857607804549424]], {-86., -97.}], 
                InsetBox[
                 StyleBox[
                 "\"culinary\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.03558718861209964], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[0.4567336004533182, 0.4884598397280091, 0.85]], {
                 69., -110.}], 
                InsetBox[
                 StyleBox[
                 "\"cooking\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.03558718861209964], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[
                   0.8926354502560807, 0.366046824615879, 
                    0.15658862564020168`]], {76., 109.}], 
                InsetBox[
                 StyleBox[
                 "\"leaves\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.04043998705920414], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[
                   0.6361597700445392, 0.7170733077827265, 0.]], {-90., 
                 101.}], 
                InsetBox[
                 StyleBox[
                 "\"gentle\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.04043998705920414], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[
                   0.9052934053395919, 0.510195603559728, 
                    0.06776406480563275]], {-84., -112.}], 
                InsetBox[
                 StyleBox[
                 "\"fruits\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.045292785506308636`], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[
                   0.47401116530937026`, 0.47809330081437784`, 0.85]], {-77., 
                 112.}], 
                InsetBox[
                 StyleBox[
                 "\"winter\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.04043998705920414], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[
                   0.8781534541180211, 0.4921023027453475, 
                    0.04333810870621905]], {2., 114.}], 
                InsetBox[
                 StyleBox[
                 "\"called\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.04043998705920414], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[
                   0.9637822400302223, 0.5764112001511111, 
                    0.0977879519184]], {-13., -116.}], 
                InsetBox[
                 StyleBox[
                 "\"accounts\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.03558718861209964], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[
                   0.969373377466199, 0.6043668873309952, 
                    0.08269188084126262]], {108., -64.}], 
                InsetBox[
                 StyleBox[
                 "\"flowers\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.03558718861209964], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[
                   0.7042770479220728, 0.358, 
                    0.5530353108891188]], {-104., -70.}], 
                InsetBox[
                 StyleBox[
                 "\"carving\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.03558718861209964], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[
                   0.26512246998569167`, 0.6229020240114467, 
                    0.73314696398283]], {106., -15.}], 
                InsetBox[
                 StyleBox[
                 "\"shape\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.04043998705920414], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[
                   0.9492067688690977, 0.5394711792460651, 
                    0.10728609198218791`]], {113., 25.}], 
                InsetBox[
                 StyleBox[
                 "\"English\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.03558718861209964], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[
                   0.3383114092015346, 0.5643508726387724, 
                    0.8209736910418415]], {111., 59.}], 
                InsetBox[
                 StyleBox[
                 "\"found\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.04043998705920414], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[
                   0.8168067340273636, 0.3521386531945273, 
                    0.3761554432877274]], {-112., -54.}], 
                InsetBox[
                 StyleBox[
                 "\"Asian\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.04043998705920414], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[
                   0.35558897405758294`, 0.5505288207539337, 
                    0.8417067688690995]], {36., 120.}], 
                InsetBox[
                 StyleBox[
                 "\"Bureau\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.03558718861209964], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[
                   0.8335801463353031, 0.3487839707329394, 
                    0.3481997561078282]], {-33., 122.}], 
                InsetBox[
                 StyleBox[
                 "\"white\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.04043998705920414], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[
                   0.7896667828057927, 0.3575666434388414, 
                    0.4213886953236787]], {-46., -115.}], 
                InsetBox[
                 StyleBox[
                 "\"times\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.04043998705920414], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[
                   0.9930578157165594, 0.7227890785827968, 
                    0.01874389756528967]], {67., 121.}], 
                InsetBox[
                 StyleBox[
                 "\"Perry\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.04043998705920414], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[0.2187618985811806, 0.715, 0.5074848563512248]], {
                 108., -92.}], 
                InsetBox[
                 StyleBox[
                 "\"French\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.03558718861209964], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[0.529922539669161, 0.44454647619850335`, 0.85]], {
                 77., -122.}], 
                InsetBox[
                 StyleBox[
                 "\"fruited\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.03558718861209964], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[
                   0.9986489531525362, 0.7507447657626809, 
                    0.0036478264881522893`]], {105., -109.}], 
                InsetBox[
                 StyleBox[
                 "\"Check\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.03558718861209964], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[
                   0.922066817647527, 0.5213778784316846, 
                    0.08286013588277422]], {98., 119.}], 
                InsetBox[
                 StyleBox[
                 "\"small\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.04043998705920414], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[
                   0.6897400905885174, 0.358, 0.5753998606330502]], {-108., 
                 113.}], 
                InsetBox[
                 StyleBox[
                 "\"nashi\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.04043998705920414], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[0.428777913273419, 0.5052332520359486, 0.85]], {
                 109., -122.}], 
                InsetBox[
                 StyleBox[
                 "\"genus\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.03558718861209964], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[
                   0.6453361616656581, 0.37647057236169945`, 
                    0.6741595958358548]], {19., -123.}], 
                InsetBox[
                 StyleBox[
                 "\"Neck\"", StripOnInput -> False, FontFamily -> "Helvetica",
                   FontSize -> Scaled[0.04043998705920414], FontWeight -> 
                  Plain, FontSlant -> Plain, FontTracking -> "Plain", 
                  FontColor -> 
                  RGBColor[
                   0.9784200278733908, 0.649600139366954, 
                    0.058265924741844846`]], {-115., -121.}], 
                InsetBox[
                 StyleBox[
                 "\"juice\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.04043998705920414], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[
                   0.6536293927965667, 0.37163285420200276`, 
                    0.6534265180085832]], {-120., 22.}], 
                InsetBox[
                 StyleBox[
                 "\"flesh\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.04043998705920414], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[
                   0.9810598048862722, 0.7553955338762525, 
                    0.]], {-121., -24.}], 
                InsetBox[
                 StyleBox[
                 "\"days\"", StripOnInput -> False, FontFamily -> "Helvetica",
                   FontSize -> Scaled[0.04043998705920414], FontWeight -> 
                  Plain, FontSlant -> Plain, FontTracking -> "Plain", 
                  FontColor -> 
                  RGBColor[0.7132613816472081, 0.358, 0.5392132590042952]], {
                 120., -30.}], 
                InsetBox[
                 StyleBox[
                 "\"sweet\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.04043998705920414], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[
                   0.47929071933511125`, 0.715, 0.1759027208462221]], {1., 
                 125.}], 
                InsetBox[
                 StyleBox[
                 "\"forms\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.03558718861209964], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[
                   0.8633598745697435, 0.40996018814538476`, 
                    0.08339968642435877]], {125., -2.}], 
                InsetBox[
                 StyleBox[
                 "\"Like\"", StripOnInput -> False, FontFamily -> "Helvetica",
                   FontSize -> Scaled[0.045292785506308636`], FontWeight -> 
                  Plain, FontSlant -> Plain, FontTracking -> "Plain", 
                  FontColor -> 
                  RGBColor[
                   0.16397784358994957`, 0.7038177251280403, 
                    0.6117734123079395]], {-121., 34.}], 
                InsetBox[
                 StyleBox[
                 "\"broad\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.03558718861209964], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[
                   0.9307395679624266, 0.7498043964402695, 
                    0.]], {-122., -36.}], 
                InsetBox[
                 StyleBox[
                 "\"five\"", StripOnInput -> False, FontFamily -> "Helvetica",
                   FontSize -> Scaled[0.045292785506308636`], FontWeight -> 
                  Plain, FontSlant -> Plain, FontTracking -> "Plain", 
                  FontColor -> 
                  RGBColor[
                   0.8857244243136628, 0.3764133635295058, 
                    0.1393110607841571]], {-125., 0.}], 
                InsetBox[
                 StyleBox[
                 "\"grow\"", StripOnInput -> False, FontFamily -> "Helvetica",
                   FontSize -> Scaled[0.03558718861209964], FontWeight -> 
                  Plain, FontSlant -> Plain, FontTracking -> "Plain", 
                  FontColor -> 
                  RGBColor[
                   0.6672593867853922, 0.7205288207539324, 
                    0.]], {-9., -127.}], 
                InsetBox[
                 StyleBox[
                 "\"color\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.03558718861209964], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[
                   0.5788038738141875, 0.715, 0.049249615145579635`]], {
                 121., -45.}], 
                InsetBox[
                 StyleBox[
                 "\"cider\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.03558718861209964], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[
                   0.6670481226429111, 0.3638052617916352, 
                    0.6198796933927223]], {125., 35.}], 
                InsetBox[
                 StyleBox[
                 "\"3000\"", StripOnInput -> False, FontFamily -> "Helvetica",
                   FontSize -> Scaled[0.03558718861209964], FontWeight -> 
                  Plain, FontSlant -> Plain, FontTracking -> "Plain", 
                  FontColor -> 
                  RGBColor[
                   0.6319174318193065, 0.38429816477207124`, 
                    0.7077064204517338]], {-35., -129.}], 
                InsetBox[
                 StyleBox[
                 "\"wild\"", StripOnInput -> False, FontFamily -> "Helvetica",
                   FontSize -> Scaled[0.04043998705920414], FontWeight -> 
                  Plain, FontSlant -> Plain, FontTracking -> "Plain", 
                  FontColor -> 
                  RGBColor[
                   0.19193353076984873`, 0.681453175384121, 
                    0.6453202369238185]], {47., -126.}], 
                InsetBox[
                 StyleBox[
                 "\"long\"", StripOnInput -> False, FontFamily -> "Helvetica",
                   FontSize -> Scaled[0.04043998705920414], FontWeight -> 
                  Plain, FontSlant -> Plain, FontTracking -> "Plain", 
                  FontColor -> 
                  RGBColor[
                   0.9038177251280404, 0.3492734123079395, 
                    0.18454431282010084`]], {36., 132.}], 
                InsetBox[
                 StyleBox[
                 "\"hairy\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.03558718861209964], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[
                   0.9107287510704583, 0.33890687339431275`, 
                    0.20182187767614543`]], {-63., 124.}], 
                InsetBox[
                 StyleBox[
                 "\"food\"", StripOnInput -> False, FontFamily -> "Helvetica",
                   FontSize -> Scaled[0.03558718861209964], FontWeight -> 
                  Plain, FontSlant -> Plain, FontTracking -> "Plain", 
                  FontColor -> 
                  RGBColor[
                   0.4177882075393331, 0.715, 0.25417864494993975`]], {128., 
                 8.}], 
                InsetBox[
                 StyleBox[
                 "\"end\"", StripOnInput -> False, FontFamily -> "Helvetica", 
                  FontSize -> Scaled[0.04043998705920414], FontWeight -> 
                  Plain, FontSlant -> Plain, FontTracking -> "Plain", 
                  FontColor -> 
                  RGBColor[
                   0.37977756485605163`, 0.715, 0.3025558265468435]], {-27., 
                 132.}], 
                InsetBox[
                 StyleBox[
                 "\"fully\"", StripOnInput -> False, FontFamily -> 
                  "Helvetica", FontSize -> Scaled[0.03558718861209964], 
                  FontWeight -> Plain, FontSlant -> Plain, FontTracking -> 
                  "Plain", FontColor -> 
                  RGBColor[
                   0.8064401951137368, 0.3542119609772526, 
                    0.39343300814377197`]], {-128., 49.}], 
                InsetBox[
                 StyleBox[
                 "\"room\"", StripOnInput -> False, FontFamily -> "Helvetica",
                   FontSize -> Scaled[0.04043998705920414], FontWeight -> 
                  Plain, FontSlant -> Plain, FontTracking -> "Plain", 
                  FontColor -> 
                  RGBColor[
                   0.8607200975568693, 0.34335598048862614`, 
                    0.30296650407188447`]], {-63., -126.}], 
                InsetBox[
                 StyleBox[
                 "\"best\"", StripOnInput -> False, FontFamily -> "Helvetica",
                   FontSize -> Scaled[0.03558718861209964], FontWeight -> 
                  Plain, FontSlant -> Plain, FontTracking -> "Plain", 
                  FontColor -> 
                  RGBColor[
                   0.31827505306025683`, 0.715, 
                    0.3808317506505822]], {-115., -81.}], 
                InsetBox[
                 StyleBox[
                 "\"tall\"", StripOnInput -> False, FontFamily -> "Helvetica",
                   FontSize -> Scaled[0.04043998705920414], FontWeight -> 
                  Plain, FontSlant -> Plain, FontTracking -> "Plain", 
                  FontColor -> 
                  RGBColor[
                   0.8745421494417032, 0.39318677583744527`, 
                    0.11135537360425793`]], {-126., 61.}], 
                InsetBox[
                 StyleBox[
                 "\"de\"", StripOnInput -> False, FontFamily -> "Helvetica", 
                  FontSize -> Scaled[0.03558718861209964], FontWeight -> 
                  Plain, FontSlant -> Plain, FontTracking -> "Plain", 
                  FontColor -> 
                  RGBColor[0.7658565873730018, 0.358, 0.4582975578876895]], {
                 131., -14.}], 
                InsetBox[
                 StyleBox[
                 "\"79\"", StripOnInput -> False, FontFamily -> "Helvetica", 
                  FontSize -> Scaled[0.03558718861209964], FontWeight -> 
                  Plain, FontSlant -> Plain, FontTracking -> "Plain", 
                  FontColor -> 
                  RGBColor[0.38354466123747527`, 0.5323732032575149, 0.85]], {
                 129., 46.}], 
                InsetBox[
                 StyleBox[
                 "\"57\"", StripOnInput -> False, FontFamily -> "Helvetica", 
                  FontSize -> Scaled[0.03558718861209964], FontWeight -> 
                  Plain, FontSlant -> Plain, FontTracking -> "Plain", 
                  FontColor -> 
                  RGBColor[
                   0.9046334610863751, 0.334573307782725, 
                    0.22977756485604156`]], {119., 71.}], 
                InsetBox[
                 StyleBox[
                 "\"40\"", StripOnInput -> False, FontFamily -> "Helvetica", 
                  FontSize -> Scaled[0.03558718861209964], FontWeight -> 
                  Plain, FontSlant -> Plain, FontTracking -> "Plain", 
                  FontColor -> 
                  RGBColor[
                   0.7175796237092107, 0.7261199581899123, 0.]], {-122., 
                 73.}]}}, 
              Method -> {
               "DefaultBoundaryStyle" -> Automatic, "DefaultPlotStyle" -> 
                Automatic}, PlotRange -> {{-140.5, 140.5}, {-134.5, 139.5}}, 
              ImageCache -> 
              GraphicsData[
               "CompressedBitmap", 
                "eJyUvHd8XGeVPi5IaMvufqkBFggBFr67sBsglCydAAFCaAmBQEhvpMdxiu3E\
\nJe5VtmXZsmRZ3bIsS1bvXaMZjdo0SdN7773X53fuvTOyHfb7x0+fz9XceW8/\n\
5znPec77vnd++9hrzzz14mOvPfvEY7f8cvNjm5559olXb/nFy5up6YZ3lZWV\n\
hWnx3FLGrINWi//CoD/ayH3cw358BDFXCJoZI7QLDiQSOaYVcWcQqikjrKog\n\
CuD+vCoXFNMmeO1xriGXhXXZAjXfhmg0eyN7OuZ/AaGwEv6wmTn0AHexH7Af\n\
N6CQyyCXSLLf3l1sY47IxePM3mX/zLZ9DBl/EH1vTWCqXoapch6Gq9cRdYcw\n\
uGsK0/USdL85BaUshIDKgq4tU+DXi9C1lYdAMAPtoBRX9sxj9vQ8+k5Ikc4W\n\
uEu9l66UgUL+BMYXH8Tswu+wqDqPfAH/c82dJLNZ9tuvuRu/nf34BAphK1wX\n\
LiCbyLMPnxCNwPLWJpi3bobjTANymTxyThXsb78O8/ZXYTl4GEl3DIiY6bhW\n\
2k4Gs6/BVd+IHBk5Z12l9Sbk0iVDfAxBpR38diVn3VQEvTv4kLTLMFIpY5vs\n\
syqMV0ux1CiEcMTJtkmaFiHo1mF05wzM1hS1pDFGRjJZk9xpP0oPlYLV0gq9\n\
vQs2ezNGZ36HcDKMQEiOXNG7qYQaenMjjI4xpDkMIBHXIhRjLpMluy4hnc+V\n\
fY4954fhDdrxipAHW7oAp8+ETUIB3NkCu2+dfAUr/hCaFWIsBhOIxbx4jTeM\n\
v00O480FHvZK1pEqoOxX77CwTwXT7j3IRAsoRKwwvfAAPL2TSBmUsL3+ONxd\n\
o3AfeRnWE/VIWYzwVLwF87GzyHnVMO/ejyw9fFY9C+PW7ciStTOqGRi30XqC\n\
gyWDdZfEiKnjc+g/KsZq1yr4l4zso4aVFoyeXcbcGT5UqijbphmSY+a8DEP7\n\
FhGJ5lhwLJ7lQaGKXrVsEutrD2Bi6U8QrNyHrvFvwxlawdjcfYgxDk/pMcX/\n\
DubX9kKw9Bvw5adRICNJxXdieGUzWV2FrtF/gcqp2bDsuHwen29rwpA7iKF1\n\
AW651IxhNxOzOWwTjGHU4cHbC+MYcfpRPj+ERwULkAd8eHtuAD8ZnkLyf7Gs\n\
nyx04CAyFHdZnYAs9CaySc7JkeEGsh5Z8pWXEDP72baMYgaG17chZVyD5dBR\n\
ZNN0nGYOph27OcuqebT+NmvZEnbz6TT8jij8Oif4lfOYrFdAParAbIuOPWdI\n\
bsbImWXwzwqwJmMpCKr+NbLwGob3ziMQybMWnj81A+VVC+fSaozM/BzhNAMt\n\
K6bmfgRHaAkTggfAcFXY1YLR5adYksomyVmz9yIcN2KSdxtG5p+GyVSH3vH/\n\
xLyyno1vlL2HvYxPaYWgRgh+gxheZ6LspiJAUMhin2AUD4/2o0KxjgOLE3hk\n\
tBeH5Br2uB3CCYw7vdi3NIUhqwObJ/sw6I6wj2N0KvGb8VkkCninA4JamF57\n\
FUl/FjmbCMZXNiEV5ogk3F9LDtgF8+bnyEi2ogMmYXiNHGCSw/zmdqQT5H3T\n\
AoyvbwVDT1mDAKbtu65zQMbrRef2WTgdCdh4KvRViOCQmnFl5xz8RESy5mXM\n\
tGqgHJBh8KQMEU8UU4dnIBG4IDg+A+GoDWGzG91vTMPtzZROyzqAdw+iLCsG\n\
wOP/lBywjPE5aiMHRDwXMb7yLJclsnqM0b4max1mpJuwpngFA3M/hkzXjMml\n\
x5HKgzvtB1AguCxQsCkoeeiGyG8HFpHOcJDMpbMg25S9r5QzCnmGpNlvpZyR\n\
TaaR5cir6FdKZHEvHhodwJRNi/tHevDAxCgEViXun5pFJp/FzoWrvhu2uvDq\n\
ZC86bQEOirY13D02w/juFvZ0n6TbyMNqS4JlNYpaiz1JtEkJgiJ7YSWAhbUo\n\
XN4UJIoo0WQWSkUYkwIfVlQxZOn+49E0LF7umbKpHCx0rjhh1mZPUSjjQxxE\n\
PliCSNxEDKjBxl8+hYJrlhgmyH4teGaQU9Yhb5kF8sV9kjbkda3IGwaJ44n+\n\
kg6KdS7ekHIi75inS+fLPl66RkgPw+N/IOjsRlS6BvuO54lNzyEqGIfp2Ufg\n\
GRQi0HoQBuKHyKIAjrf/DstpylEBAwyP3gP72Ub4m09Ac89dcDS2wXt2Hwzb\n\
9zG5bQOGlOHZuO4/MIfBg3zIl7xkvBxk7RIMHuJj+IQI/gCFQSQK3ol5DB3m\n\
Y6ZZSQ4ijtA7MXKEzx4nmrAzmCqdtpCPQyS6CzzZboLVk+gc/TIxLSF5/P9g\n\
bPklOLyLZPzvQKavh2ztQUyItmFN/hyWtb1wWHfj0vDN8BM+Fhd/BkvI/u6i\n\
j5mQtgnVmD4xB16VAD2vTCASz0LfL8UYBcfY4VmYVCGEFCZIxg2sYW0zKijn\n\
HYgYnZjYP0XyRICZ6gX4vAnILy5i7BgPE7To1vwlZIp0ItxFzBBNxfBwXzN+\n\
x1tEIhnBY8NdWAyEsFM4jmEHIXNxEuPE9d3rfNw5PIxuvRpPjXTgF2OzDK/f\n\
UAJ/Kgu7JcUGCfckN7EIc5hTG2rNoYthhR+E0Zhiv/scKYSjHMe6CcmJNCMx\n\
0lhbDEG5HieYFNh9IjFuHxeD1mShZKiIK4GKahNY0qJYOn7OQOIpjvZOM/bU\n\
mFHfbsWOYxrsOmdDT68d208acGnQhcOn9OhbiUK96sGJHi97K0F7DIerjJBr\n\
ozhda0HsH4Ihr9yNzPAzV2NBfRTphjLiwHkUbJeQ6fwasvzNyPR9E5mlGmIT\n\
DzIjP6blAWQGv4vM1HPIqauQGd/MMcrc7+l8T10TDDdRwHng7+uCt6UG/pEl\n\
5MI2uCr3wrp9K7z9k8jnGOEUgv/iaVjfehWuBhJ/MbJazA1/zxX42s7BdmAv\n\
Qrw5eOsrYH17NyIK03uKPkpFk0hzSqroo/chFaPIzxdw9Y/YhFiicA2x5Ynf\n\
k3GWNYqq5aOUf81QaU9CbmyCzT2NRCYAq7MXGmMNHEEPMZIUkvWdkKhrEE9F\n\
4fFOwxcNEUnqYbRNs5jw+3nwx3zF63wK2WgYQ28MQSvzwCZQovuVUVilBvS+\n\
NQWPIwbnkhr8NiVpzjVMNq2yd6u9tITlfg1kLYvgt6rh01jRs7kfBpUbwioR\n\
Ap4YdD0L6KUYv4rNj0BiVqPTyKW2IRXxgM3NPvuAWgaRL4Q5sxb6SJhkzQQG\n\
XREyfRrNq4t4iT+N8pUZ/HaSdy38w/YIao/aWA1Zgn/QyrUxWcqxGsC5YyZM\n\
D3pQd8gIhS6BoQYrFkUJBgu4fM5M3BBH/1kjOi440HrCgLGpIPrrrFiRcPu0\n\
EdaVxswG/N0JnKk1b8D/VJ0Ry/Ioqmr1uDwbIqvn0HPZjHZhGKJlP6SGBDye\n\
JC5dNKGi3w/NmheVfT7WAiGy7rEaEwv/6nrrP8D/JuRVe5EZfY6DSHQdma4v\n\
IX3xJuSMM8hO3UGQrydoxojf6buEKhhDA4XCXQz1knYwITu/DbnVQwT/Z5E3\n\
X0S6/SvI+11/K7o+7fdgYKcALMhyKczsnYJ6RIbOlwYxW7UA3uk5TNfKYJ0m\n\
edYmZ+/C0CmCaFALWesS1qa50mOhZgYWaxy2eTXGiQhH9k1jbZalbcrwKGqt\n\
HGrXl7HgD5B2GkW3I1RW8qPZrcIvx6YRL6Dsqm+jaDhpv47aQrYI28b8TdST\n\
kS94YFTHsTTiwZoyipFm24bfuhosEEz70HCMw0LCn4R0JYxBMrRYVvQ/OVJl\n\
us63p6kpwub5LCrJt4uaJDSKICrqzKhstmDPcS3aFyIIOmM4fd6InSf1ONFi\n\
g9KZYX1b0cP5Nkzbj1X/v337r0XfPs/ACLnZO5GZ3YHs9K+Q0w0gO/Z98uPd\n\
1PZ3orD7aXkZOXkFMhPP31AkhLy5FumWfyY4fBLZ9a4Hi8+QpWgffJ0qUkMM\n\
Ia0FPZtGYJUZ0L15FCaFB/oRMbp2C2GbXUfv/jnEwimsnxeQS3WQUjRLx2xs\n\
RC42zMFA+4++1ot1gR1mvgY6qeufrvGmwEIiIhrHst0IfSy14blQzId+o5mR\n\
NsW2TyPijOLsLgPmJnwQjPsgXY4iQN6so0hlImm2xYKz5WZM9rnRfEiPgTE/\n\
RsmbS+IEayDGm3OTPjSe4LxZIF3lpMQ0cN6CFRm3Twe5jiK1rOTOGKXhvUe0\n\
EBpSpLGT2Fehx6o9A6nAg+HlMMJUSlxqNuLSfBhTvVbsqrfDEyRJx/diSZeE\n\
Tu7F1gozfLEcjMoA9lRZYDTHUHX+HzNVMVQnX0PeSmF2+ZtUuAbInT9CTj+N\n\
nPA+2rYdhUQUOcXbyPT/ivzXj/SVryMfDpFClFM4U6aSHUFm6E/Ijv4UGf4h\n\
Jkv9pBiqSPnp0HZk5T0oRCPsA+eNwxT1F5BzqUgNTiHvVrIFRiEWRiGgpk+u\n\
HMm7lpAV11NNPIFChpOMBf8q25YzCGm7jNrTZddqIcvUGoXxFCaOkvY5KkA0\n\
kYG6U8zqoNEDM1BL/QjKDRjdN4HJ47Pof3sSTksEqj4ZVPMe9hyrXStw2ONQ\n\
XF7C+HEeVXeTlGV8n3wHJqbHvJgb9UK0FEGACsdjL6vQ0e7G6pyXot0C8UIQ\n\
rceMkK7HMN5IYXjIAuGEF2cPmGCyJNFxzIDhAcJLkwWX2gmyhJWqcmL5KQ+q\n\
D5pgD+avYoJYoPyUDgeqjdhVrsPeWiuClD6Mcj92HdfjaK0Jb5/QY4H8bzOE\n\
sO+0AUfOmfAmZYZVW5pCwodXD+twkI7fdliL+rEAgkQbDW12xP9RvagOINN7\n\
Fy23IbvWyxo+O/l9FhMkEZAdJj8P/AyZntuR046xCSW38CDSXV9HpvsryMxt\n\
QV5bjcz0FgKAnVTNL5BZaGR8vxFthSxJPU5KlN3M/v84ctEgwioT28OQDfoQ\n\
0ZjZ9UI6jojBijyLgTxiWi3S0QTiOiNJCwJUPIzAkghxLz1LJgE/n6T/8AzC\n\
BmcZJ2f+jU4YRrrn10i23Y/Uld/R598JmBeRPH8r0iOvI3XpTiQqv0RAnSL6\n\
2oTM+gqysy9RJbtGsTGERP3tSI9uQar5f5AaO4q8dwXJutuQ6n0BqfZfInH2\n\
P5Dzum8sPl4yFEcymaXbLxSd+CHEfVHEY1w9VcjlqCQk9RSMIR5Js225DJmx\n\
2J+VZUpIdrVA/B5GLJL+VBF/TIapL7chXdRhdAkSZhkoxWEszvjh9lOJRqXc\n\
eLcLa2txlqdsuigUohAmewifq1z3Z5TS+3SPE1PDfqo8cxhutGKg04MJ5rj1\n\
xDWi7j0kaPIIRbIIh9Ik2uIIxfMbgi/oT0FtiMMZKHHYP7NtKn0cnhDXFaeQ\n\
eFDZ64XTlYSWsM9Ec5ruWboeYbL4dfj7IKnlQ0jXlyE9/BDhpGiQie8gpxnl\n\
HjkdoOBfRCHsLl7xw2zZVvAuUJm5wsqIvOE0yYcXuP0zESIYCzZqi0wY0eFN\n\
8J77HXy1dyOy0MvgrOyzRU4MTPRg/s+vIhZKwTfUBuHf3kI8TA7xqiHde5bt\n\
zWD6JFVbtsEp1UK7fT9CJB0DU/1YfOwNeOUWWGoqIXmzHNoztRA9uw2eNfuN\n\
RSjmbSMEHVI7cUahR4liX0F6eisSF36LPKnhgmMMyaYHmVTOQVEuRnbuVYKi\n\
hDLpI0gNHiVKJvXkXKDt5yncXkWqiysUEJETpL+KnMd9G3u591LlE8PZnTo0\n\
VZpxgZbGM1aYnNn/U3QfY5WhBhtk68liaXED9OskQMbYjoWrbnbG0XSJpYuy\n\
6/xFkt9YR3H/C/KJaWP3HP9R5E2L7LcPlPaztpG0O8h+u7F4dznnPFUoTyJp\n\
0iGt7YK7/MdIefwb1UQyWnJbsWudqINCnOmtY769v0hZDC2YTh3FwqOvwLao\n\
g7mCW7eLbeR6HVYP1m64Tb19J5wyHXS7DyPsjVGxdBmqs6RewiaInqTiSUmU\n\
RbnKNdQPO09eduPGY14m2niagVfxMT9OucpCaugppDoeouX3SDT8jegqf73f\n\
SD5mhn6PZOOdSA28hHTfk0h1P4n02AtIz5zn/JYLIXXhW+Q314YXiB+pKuYq\n\
qfcVAzFX6mMq/uVSmQ2TM0RQ/Cua/L3EzHn4XSm4qTJ227nPVLrwoeIhEdIN\n\
iRTHwh8reY6CM5HMX+d8hqkTyRzLCe9wPvIZMuo7BkTS9D2Xv875zH7IpK5x\n\
/qepLY3E4mn46n4B/6Wn4DnxAyRtVrKqEUGKBk/1XfDWEWHbXchaRhEer2bB\n\
UEiYEOx6C7lYFilpFbzVf0DKvIzQKBEz1ayJhaPwVv2U2u9EaLyeIZGiBSm5\n\
Re1Y23IExsZ2KA+dw9rus7TeClXNEDnBCNn+GqTZ20z/A1J8gx2ElH6kbHKs\n\
PP4i5EeroTp5Duu7j8DQMVlWivCCfwHJ6u8iZyNVmnIh3U3iSD+L9PhuinA/\n\
kVMHkvX3E1Ky1yBlMzLKNQqQV5C8/BzdZ4QS1Dkk6u5FduEgkhf+TIwR45JR\n\
DZts3ntNCBs7hmGaNxZd8BmquqRYbZ6GoXcW1mW6jWwcypo+ttskKhNBMy5D\n\
wko1xcEmLB9shqxxCuk4qcfWfgR8Kbau0tB6yBuF8UIfFvfRfuU9CLtC0Df1\n\
YungBUhrurFyoBXude8fOFB8sejYrLkHriNfRVzBR3LlBFx7voykw4Fo7/3w\n\
XtyJrI+06NR2+K7sR2r9AgIXX+McG5XDffI3yPgo43fdD39fLRlsFd7mZ5BS\n\
jcJ9/DuIa9aQsS3AW3MX4mbThmOjixOQ7DqLmE4B0aNPQ3akFXEq0GU7TyNu\n\
1ULywnZ4Vm0EGidkz2+DT2+FdtdBhN0ReHsuQ1F5BbmEG9JnX4NtTo50iMre\n\
vXugqpvacCxTP2TntyNZezuFMy2dL1EWolzcTeHdcictdxA9HwCTuzOzL191\n\
rHydnk1NSuFucuSvkGwgBSUaoYDwsaok0fBzaqfjOcdyj3QLfBOT4B/qRZIc\n\
k0kkoKxsxmrHIjQNPdAOa9jEtvR6NaIUbkHeNMRN41g/dQHyLgkSXh/ktV1w\n\
rVogO3wOLjvRXzYByZE6aAenwH+7jaSsD7q6K1htGsbc8yfhMnrgnp7BzCsX\n\
kErlP1PEVzSYxJVuJ6z+XNk3rnd0UnKSnLO5xEYI1v0WCZMM/urb4L30BqJz\n\
1YhMnUR4jhAvbUSgfVvR0Up4Ku9Bxk+O7nkQofk5qnXV8F18EbG5criOfhOR\n\
2XOI8qoRGj6EhMGw4WhXRxNUtYPEd0ko3tgJXbuAzaOKXeXwiJYhe207pFsO\n\
QPrSFkj31CIZjcFQUQOveAXrr2/F4lNvwr3mRHB6BNIXd2B1617I3jqNqDNa\n\
xoXUh5H3SJG3i9gIZf/IcnnHMuVcqlWKGi0z/QJxuwhZHjl6TcztRx7JO0TI\n\
B1wb4ok91ikj+aAijv86cm5nWcnD+bgf8y+fwMLeixAfa8Lk0yfgc0Whb+yG\n\
flJPJo1C9OZ5djAuNM+DuG4Yot1VmH+7FdLKTiwdaIFNqMHq8QZ4PBTbuSRk\n\
x5ugaO6G7LKw6JYMUqEQdC09WD7SjpV95zH3ZifTx/+e4i1mMqUe+eLTZvLF\n\
dHsjMozCLrYTrN9dak5lMTniwNlLbqZk5iKEK8IQXQM7mhmRMTKvaBgX4GgB\n\
PLNAWErbqT0sYgZLgMAwrdPD5qnNeYHkKu2X4PpaEVcB1jrASwCJqD92PfxS\n\
sjPwnH+iqBDSCNTehYRFSTD8FrwXtiIuJcYafBau0wTLlUb4mov7Es94Tv+B\n\
Un4Gkd5HEBIShBIagt9LiC9WwXX4a4gKOxAXt8FTfjOZfrbospuQCQXJy9zo\n\
Y9rvp8BMF9cDlITWsXqoFlGbGxGlDhmmv5XMExAuIxmO0oPVYe1AAzJcBynl\n\
BgdVOUZkktkPFe2aXTiArIYK6+VDVPkq3l/i+BzVL933I+/3F0XP56CtuYi1\n\
9mW4Jycwt+cK+2Tac+0Q1cwg6XVC8NwxOLR+OPuGILkwBXllKyTneQjqTBBu\n\
OQPDtIr07BkoB9fpTiOQHq2Htn8SAqKGZCwJ5/AkdGNiGHunYZOY4Zyaxuxr\n\
l5DJleq4z7ICY7zPjjPnzahuccAdzkFKhfSpGhPqL1hxqd8Hvy+Bzj4f1DI/\n\
JsVRmNYDGF3ihlAlPC8WFTFIFr04U2tB40U76lqsGKfqeWjYBUeU822IgmL7\n\
HkrF3lzZVaxRcK4/Ttih/Ca7H3ArOMwoHwSlAGq7D5i/lQ5WA+K7iCPnAcEt\n\
gGsFUD8JYghAs5X2/ROdYx1Y/jaVKm8BKz8Flh56B9byATm8FV9CcKQckZGX\n\
4dz5OTanpZYOwX36N4jLuhBs/in8vQeR1nTCueuDCI2dJHw9DteZe5B26uCv\n\
uR2+S3uI45fhu/AcMk4VfGe/R/tVIj5/mNTv15B0Osr+tej1vE8P5Zk2isGr\n\
tRgT4vrjVYj4YkgYCbMyXVEykl2YEXJmdkaW/dwAD0GjkIwxteIGeGJKKYT7\n\
OiA+0kQA4Axn6RuHcGcjlvY3YPHABawcugD+1vOwEVumrGaIDzRjmdrE5yap\n\
5ExAXdMKwZu1MMzIoCUBEnCHoKm/AuGeBmKoJnj0HirEp7C4v4XORazUJ2YL\n\
rRJ4zHIfDlfb4PalMXLFhsFpPxrqjFjQJCHhu7D/tB0uRxQVtXaIeU60Tgah\n\
ELjQOML1Vs502TA87UN1tQHDSzHY9REcOWGAypxAQ70R+iBHXMtTLryxQ4Vu\n\
fvh68MifIcfbgbWHiZjUHHikBCSSJ8gaCTS/IPAQAUlJ3/io+BQ/RHHuAYRU\n\
XFnaqK0X0B2m9SoCUbG/OzJJ6w8XwfPv7MenkLXNItj+DOWycsQW26kCjbDd\n\
JomlagSa/krK9TT5NUXAWENU0EAAexP+pr8hoV9F1rlIJHQLPDVPI22fh6/l\n\
ac6/HhlCHX8n8fQsEjpZ2UZFR+fNkncK13RL55LJje6W/2b/f5AFkvitExh+\n\
tAJBHzfKls+SyGfuyx9iST9HijMRjG0U9nlS9nFveKOSZvbPkVxO0/PYecuI\n\
sfNM8oi7fUjF06WCIBUMIRGIllDK9vkoyZEtXJHJFgvRQAqNDSYYwqSdwknU\n\
nnfASc4/U++AlMDQNh2EUuhG6wR3DL/XjrGFEMRCAkCDFeebLdh3ygijM4Wm\n\
RhPMzOWyWdTVmTA258Pp8zbE81cTleIFSgOEozXyt2uNuw3ZA5RomDFsIif5\n\
o8ykD/L9PYB/mvN9xk+E8lU6ZjsRxx5av50Yl/wveY07PkrJTfQQE24f5fz/\n\
rWLQxsY2IyKhtBcn3VP/CLLRQnGC1g3wLYugHpCwQwYbPqS0aO6fZQq0YiK+\n\
GRaqyg9StIQTOYjmPBjj+dFID6ohlGdCKYocOxxFg0mK0aIigx2ptyMUzaKv\n\
xYKxlQjWlv2YWSIZrwrh2CkDDFQTVlfqaFsMNnUAR6tsiCWzOF9txLI+fUPJ\n\
YAky0tKPAHMzsPpjcsD3iXGpwpf+tRg8QWJjYt4gMankV4CBKn3+1yi7a4lt\n\
nyajkZHM1LZMBg0x5/omGa+cjv8urf/tY9cbrJCKU9mWY02eUPCoeiyUfaXE\n\
imkH4iEJC/CPl1gxn0DM042A+TwiXiG77d+LhmNA2k9UUXHOhBPnLJDr4xig\n\
nGVhkBZJo+eKl0Xa6ToH1KuUoyRRmClHVdaaUdtowfEaCyz+HCyKIKooz9U2\n\
WdDS60UsnsWVNgtO1JhRd86IASHXcb004cKQMLJhuKSS2n4ImC6RMUiTOejT\n\
RZ/+JdrGHEIigSpGplsLniky0jGARygL6DhJZK0lliGGiTk4lMVIa+oradlB\n\
aCsZ7o5ScDH1uF+Kgof2SqdvLkWg5yL0i39hFNyGzUL6V6Dj3wq3+m0Y5r4M\n\
t3mw7Evstg+xKcPvTxMQOAplFCLbv0BLJltAwBHB8bM2WAwRSLQkcOnEzPZo\n\
JMMc8+4ix6TIRL5AZkNAMlNemC7bSLTUvwmWl9JUoZf6WaCiyJNsYb+9t/RU\n\
aTOldUrNUZKJ+vMbiS1GZhQ/y34rRtxPSsdlHMjzf4DcyA+Rm/wJcuN3oRBw\n\
cr34XyQC1ZLt9dwN5Ahj4TXSTFdgEN6NoO0C/GYqHOL+4h2SHdwX4TOcJmwJ\n\
uLlaVKwko0Zuc9aHeIBEfz6JZFBInzmko1KkkyHuoeMy2leBFOndkL0DEfcA\n\
BcUWGMSbWH/8V/EhE+EU5oQhWNRhzK/FNvqBqEhEVHONPW5g54Ei4WLccU0P\n\
CzODxve/GiM0j/zC04yMotPFkF/8DS07N86WCoKdGIerGePatg8UjRa17IZ1\n\
bR/7ULnYLIwrTxPTj0AzeSNMovthE98JneCXBLs4woY3oJv7FpyKLdDPfQlu\n\
yxAi5j2wyY9yx0dJXPJ/R0aywSr8HpKpGDyKh+CxidjtId1jpA9eR9Rxks7z\n\
ZVilj0HP+xwMos2s0bj7vIUyD9XF0zaol71waMJIJjJwaqPk4Az08w4o511w\n\
G4IwSfzwmSII+emZ8nm4NSF2ZlSKKlCvI8Fe06P2Y3XcCqOCy3CZSAK6JQ+i\n\
lNW8mqvbmL+gOYKwP/Pbaw39GTY+CpZG5Ge+g/zsr5Gb/Slygoe4mU7Cx1CI\n\
cbOhqFIgB9yH3Oh3CJnfQF7ZWmw3Ufsfr7ar2jiIuZqQX3qNqSXYa+RXX0Ze\n\
N/vukmOsB2CXHyo6Zg4m8QuIu3rIAL+iaAU7z9O2+E14zEOwzN8Ml3mWCrQA\n\
GbcDHlMfwmY6Xnm86JhpOu4+kpJ2OuYnrGO8yifgtUvY7WH9M7CsvQTryp1w\n\
m8bZtqh5JwwrL7GO4e7p88RDGUyfWMFgtRLT1TI0bVqC3ehH9/51yLo06Dwg\n\
hWhAj/bXBZhsMWK+fp2EGsE3lULf9mUECc2OWT1G283wyl3o3CuGaNCE3j0r\n\
kK+GYRzVov3gKlQzZnTtp21DJvTsFkG1FoTw/DrEM4Gyone+W8R0lmSTLuRl\n\
/F5kG/JYYAK5vo8hr25BwdmD3PAnkJt/gjK1Brmhr6MQZkYFifzE5K3xu9ne\n\
5IK9FbmBm1Fwq1GQ/pnaf4tCiGlv4dp9dkLBUeTG7mZlJuuxuZ+R165c9dg+\n\
CqUd7/AY8c/SoxvE6JX/DQ7lWZgEN1H7H2GTPQqr6Fdk/bcRMu4jj5UXj+eR\n\
x/74jx5zcNNewobnYFmlZfmXCHo5zsuGR2GUvHGdx1L+IDq2S8GMS4AE49A+\n\
MewGP/qPyrHarUbP8XWYqYYbOyrB+kIA4ktKiGf9rMeGyPKkQeCcM2Cq24Tl\n\
5nX0n1az+6/3G6CQBiG/rMbKjAviC3IMnOG2rfWRXJf6IGyQQyYIlJX6nAok\n\
gDJBL9MHXnbr9V6MRZ14iX8RJ/SaDS8WDLuJ5X+/McRT0G5Hbo7ESFxLGeA7\n\
5EWGF1PIT9yC/PJ+8jSPllkUVJXkRRnyk19AfuXg1XZlBWULGwrWcuQm/nDV\n\
i4K7kF/rLnkxZtsLLe+/EAubSNLxyIvPESH2QjvzVUTDLuRSahjnPgGfcwlO\n\
0X/Dqqih9BeBV3EPWf8FRCz7oZv/PlLJIBKOSuiEf6K4dMO28EPyIhGT4k8w\n\
SXcgl03As/Z72NUnSaveC4v8GLXFEFD/BfrlZ67zYjoQQscOKWLMLZM0H6bY\n\
sBt96D0oR5CytniAYq1VTXG3gNV5P8QXFVimIooRDkO7VxCi49wCAya7TLRN\n\
jrbdEiz1GjC4dwnjXVaourVYmXZBdkmBS3uubpvsMrNepBje8GLGMQPTqZ8h\n\
Fc2WvMjNTv0sG1MilwYXDDIIPBboY3F29sqMXYFmapMwEwzI4lK/EyFmLIGy\n\
myjgQiqXhcitRaN2BUNOM+uYVCqMbpMEbWYFHKk0Cb44ZEG2X4rUhwb3znbC\n\
ns4VcwahRU9omf7jVbRYTiDHf6CIlq8V0ZJhUZEb+z7y8/eT5/+EXP+nkJe1\n\
ELv/B8X8D4rtxAt9zJS/cRRsFYSWezbmt+bn774WLXHneRj436AU+R3ST90s\n\
Yye8UzDOfwPGhZ+wadIsfZmKoTzSwUmY5m+DUXg7xfYPqBAw0PE10AuYfX9A\n\
CPs0HNozFCcROCSPIJVOIKB5kbb/gI75OjSz/46QT0WF4AJMwm/DMP8j9lzm\n\
tcPXoOWLZPEseCdXMHJei/mGVTRvWobTxLC0HB6VC90HZFDPO9G3bxlKaQiS\n\
1nU0bRVhmVDQ+OwcxpupcDgiAn/UjSCV+13EGatTdgwdWIF4zoXpkxL0VqmJ\n\
v2zo2S/BKqXqQTqXXBzAUuMq6l8UQsz3sSNLpamHuViAKsDgddMKGXGZS7Jp\n\
ekMoMgOBTGGLjf0+QM+TpGLIQ5HHddxmbMMwHvxP0l8ZOm+I5ZObSscXNno9\n\
S4KphE6RXYw7p9twTD6L345XY59GixHdDB5cGEKTZh5/4l2BLOLGU3NXsMx0\n\
v6dd+Mt8P0ZNa/jjdDsuGqR4XnARF6xG7F/uwqsyPk6tDuNR0Qy0Hi2eXBwA\n\
8zBa9zr+s68CFxzuq+j0tCPX+3niJSqcMlSHk+ty/IcJnQbKSB9GXnKCIB8n\n\
QUcijvcipwniq8gNfgR5I5/47feUbV7mUBiTUkaiYywyyk6nkev5LJu1kI0Q\n\
ur9J6OzlLPdPZLk4cmTRDAVBJqFH2DVFgZQiDRgntWtGMrzK6KbSbIZ82otk\n\
SIZMmptOkCc6ymWS7OHJiLJYLMQRcXRR3iXjp0Ps9lREQjdvLXUj59N+OrOG\n\
3URX51z7BXZ6x9qoCWsTFvTuEsHtSUAv8iFHTOCQubFwRQvlso+d9es3hmAU\n\
uyHqN8JEJZqGZ8XSkJXKM869Xo0Xi916aFeDpEwzmDqygp5KJaKxHHxa38Y2\n\
Zm+fMQjDshPyRRaSpY6qQiYC32Xi4qPfoeUbsDY+T7dIdxxYh+McRdbR/wtb\n\
48Ow0xI3WxCafB222t/Acvy/YTz0FbjHW1iuSSrbYCn/L5iO/xCmY99GQLyE\n\
jGsGxj2fgqXqFzAd+RrMp3+HuN1SHI9lDJJDzeolPCy4BHsqcx1Qb8Z5aRfK\n\
zWb2QXs0U9ijlOA1fiv2qSWYdBlwRj6HJUpkL873QsIC1Y0HhQMQB33gO/QY\n\
MEvx+Fwb9sp4+P30RbRYdZh0KHFEsQQpfT6/PAyma+isrA/PzHdhk4THyKfS\n\
MCNTGuWlT7KqJz/+TVJPxIwLr1JtQlgd/TLhlRh07gVSTZRjp75ObPpftA/l\n\
YMHzTDFIylFCOflWav9vav8cYf1FtgOzYKkiPN9M7bcjP0bnGSCq8hhLDJGP\n\
r8C6uoPZc6PLpJCjAkDyMBKpRHGM+j1MAYzRI1I4bCFME8OlMqXx6xvgIDdr\n\
ZWyFVhzMvhkpVSv0O7+MqEGFjEcB6wmqimfbEZ54FvpDP0LMsIhA/4NQv/JB\n\
RJRqwsTd0O78D0RUcxRpxM67PoPQOh/Os9+B48phZCh5hXk7YDhyO2L6cRi2\n\
vh/O3mNI2VfhOv99mM48xHR9/VPxlpjp9aniuPlG5UvAccRc2COswX6V6B3u\n\
r5d144TRxLq/VzuNPSoptgku4KnlMdSp5nHvRB1abGpsEvRgKcq8YObFAwuD\n\
WHTq8BivBa9KZ9BpVEDj1eHn43XYuypAzfoEvj95CZOWdbwkGoM37sX9vE4o\n\
gjY8ONcBeSLFxcW/slMUCoFFErxiAjeVNgkfCwkqCGjdyk7XY//SHqKdadpP\n\
wsC5RDkMa3LN0mJlw+xKp4hTmRrV0rYZFKKWq0VvjmiGm/hx7fQVhqWY/p4N\n\
r9OXWJBhrhzbq8hsu7l4x/mYHUmjHAntBPxjb8Gw88PwCvsRGnwQllautC3Q\n\
pU27P895uP0u2PtOlWaCu5t+DHt/OUWRHkmTDFFRPRy134Oh/OeI6yjVHPhP\n\
JILF1GMZhP7Al5EIpYuPlkfT+hU0mpU3FlGXyoRxQtSCh2er8DdeDS7bzYjG\n\
HTghGwDbW5qPonxtAOvRxEYmHFNdodRUC2+2wLzvdS0aVp2ruGv6Eqo1C7hz\n\
vAYHtXrMGvh4cHEEbYZl/JmgzGStp2cb8ZfFUVSujuDPC2NQeHT4C+8Srljk\n\
eE7QASEl0PKVXry1KkSNYgJ/XZqGhvbZJBpFn16Ix5YmWTqrEHXigE73fMm2\n\
CTsZ40fQ7/4SrOfuho8ux0zHCPb/GZaWtzkbJD2wln8XYbmCta1jpKZkW1/7\n\
r2HvPYno0ikYdn+WSPJ2ODveQMLuQNZBwXPgK5QqOJhkXbPQ7/sS4t7Yhm0P\n\
LlQR/pdvLCaoMVUX7udfgjkexLxVgL8vtEPh0+FVfgPYqM+F8PJCAxZDxVPk\n\
YtgiqMC3+vdjwO14h2mZC4jdGrRoJdgr7ccOlYbFI9+2jrOqRUhCIW4fjxk8\n\
uxLVygXIwtyEVxEdV7HOw4jTxqI8k42iR7eMet0qydIM/AEdnl0ahNhnhSzE\n\
9Rk5oi4s+Tylvp2oOw6ngc20ZY+w/29nbaB76yMIaY0UcyG42x5BzOxAePAv\n\
15jbfdXcnb+F4fi9SEco0QdVMB/4N3gEnXC3/BSm5i3M69BISKrg7D6NNAl3\n\
3RsfhJc/yvbPhcZfIQL8HtLJjaFgHF2qwV7VCvdtY+5RASeWavFH/gU0qadR\n\
r5zEafkMJC4Vts03c29wk+E3LzZhuWh4i09GAXCOUkwbXhJPsLLvw5z1v1jC\n\
vJ5HEowdoCluugHegAGvrYyzE9L+pdimGjah+wxLh0XPfYNyd5I4fAGGKxNw\n\
ifTFCUQRqp2s7Ho+EebW2S9ZhORqKptyFOIOmPunYZuVIWIywsmXIhXwI6hz\n\
cD2AVJ0GNNxLIVk/s87N8E9YTDD3TsE8soh4kOtYiuhNRAPcmDEzwSls8VA9\n\
k4Cbt4Kw1Yekwwpz3zTsc6tUrRvgFMi4a+mdrDm48UDSIQkXXHV3wFh+K8xH\n\
vwjj8V8iRecNDRB7Xdh91eUnyOVKFfxX7oVu102kNf4Lxv2foVrsD+T+NOKi\n\
k6SKvwRL5dcpZ30WHv4g6ZB5NuyMpEvMpFv0u26GTzhyzfTqPE6u1OHHo0fw\n\
wNxZ/HmmEs8tUxWTSqJZ0oh7eBcxaV2lNDSGu8ZOYsyqwHMzVdClGMhE8Ry/\n\
Cv0uF3uLl9Za8Zx0Fh5SfvdNnoE2mX2HxxOkREPFSX4lj+fJO/4kNzOVG43/\n\
Egs4tyaMePG19pA9Cp83A/2UBR2H1VjnuSCZciMc4Ygjl8xAzXNiecAOk4YD\n\
YNBGx3i4EfmELwm7nmtn5hPLRu0QjTnhdXMkHjSHIRqykcC0w2lLXW0btGGZ\n\
abOX3ii4jeUHc3ML+M9XQNPSg/kXDkA/TcrCocLC3la2+zFtWePW2be1whC/\n\
uh8OjRPKveUQHbkIxekLEDyxA8v7OxBWLWPxyBVWqIbnJyDc386t88excKgL\n\
CbMeSy8ewmpVF9YOn4VwezNSiSSUp87BsswNHthbL0LaMIGweB6zj+2Hlb+G\n\
1R1HIC6/BMWpJsw9+hZEx3oQXBNiqbyXOT+Xaj/EvkyW0E0jpp5FNs6BORex\n\
UYniLoZ+FhkiWGZupqf1F3AMkNCxLiGuESCXSJcqtAwlqZhyDEl78UVPqjsy\n\
fjvFk4V2nULSaSrbGDqh6x9bPofN0nEoQnas+jTYNHcCb6xTPHsk+MPkKTRR\n\
YjsubsDjCx2wBs24d3A77icJtESS5oW5cvyC8NWqnscjk8dw2UUxmk/ihdkT\n\
qDFpipjjhk6+zPprZN8qDGbOr+JONXjTQVjmbTjz6DIGz+vRu1eG9hN6pKi+\n\
5J9ToPWgErMtejS/KoFyLQZxlwazE1wnr5Vnw+WTOsQDCXTvlKKvSo+JahUa\n\
d5Ky1IXQtkWC4ToT+Be0aNmhpLo7jLY3xBiup7YWantLgWC0OJZyG4leqmOe\n\
2w+nhhsA9U2MQri3DXGTCstHLnNwssqxdKi9CKcIpFuPwqGktPLaPmhGV6lo\n\
iUJ57ByMk3pk7WtYPt7DQiginMLi4RK0prBysg/Wtk4Id7ci5o9QDrax0wEj\n\
vjDU1Q2wirhXqByXLkPWMo2gYArLJweRi0ew/MJugrmSrhXG+oFqWAQWJA0r\n\
WKkYYM7/b8Vo9lDasQ+fLoILRTXHpZXDWllZ6Q36IXk7/kIVC/O35pRix/JF\n\
HFkfhyWZQoYgOUCavFk1gl7KutMWEbr1fByRjeISlenu4rwmqV2EEYexlFa+\n\
yn68B1E6RbrY25rOctNbS2IzSYk5lb1+GmwinUIkde04CQeaiUPrMFk50Eh7\n\
tBDMhmCateByuY61aCEWx8WtMqjEHlwgoKjlUVagKiatWFsMQNKnA3+KS/w2\n\
vh3d1Qbo5uxo3KGgypeuSUS01G2i4/2QEpmFAkkYFxxo2iSFjipeluBI6BqF\n\
DjS+JIHdl90ATcSJxReO0WaOv2JSIYRvNSKqU2BpTyunR2wKLBJoWIbMxAg0\n\
hwmLIQSXhJAeOA/JwfMQ/P0ATFM62ncVS0e72AwYXZwmPuLWIwvT5OAeGBou\n\
Y/bpo1g91YrVky1Y3HoaHrUTmppGWCUc+zsud3CgEc6wHMNMXPZOz7DXEtPC\n\
f/ogrPMEGv0/gCbjllNidFwDmvexoDlMJHHnxGnsWenAGyTqfjayn3S2tuwL\n\
nMM/Xzx8WCbFQbHpGqd+CjkKk71CGRxMniIKaxKJ8NfeCTw/KsAe3gKenZZA\n\
bLahakXFOjNPLP3GjAgWosAemQwP9UziIcr3rRpGFxQwsraGR+j4x/omsXNJ\n\
jWiu9AoIB5bxQ2vQGK8Hi3HGgr4aropnKqGh/WsQjtnRsnkFvZVqjFRr0H14\n\
HbxuykYMWKY5hrHPO9BTrYdiwoqa58UYov2GaWnfvQbxYpAYjJhpqwSX98sh\n\
HHYjS2p8sU2HFrZNgQVqy+QKJbAU0ozzD0LVL2XfebdebMXCwU6KfrrkE3th\n\
FeqRoOKJ//dDcK27kHLoIXzmIIL+OFVFg8QqCqSCfqztq4R+RE1UL8fc00fg\n\
MwXgnxrB7ONHEHSG4B3qxeKxXvhmpsB/pQohZxBR9SoET++FzxKApqIKkjNj\n\
yMQTUJefhbxzAX7eOIH0Cju4amzrhpmnQYpkl3RnBUwzhmvBsjE1PU1Cl8CS\n\
j8c2fouBrVhz3C/kfHwDQAUovBr0G5fQS0uPYQmLPjvz2zLvBNAFPp9EjfI6\n\
AGUTATw1Mg9TosCOmt7TOYIBm590rQcPdQ6gRuOG3mzCtmkRN6eG9v9r3ywG\n\
lRrc2zmOWVcQIr0av++ZxYrJgr9cGceMKwxnwIeXh2cw5YpcA6A8RvdK0dtk\n\
ZYfaJQQg/kyIrGFB/ZZ1+ENZEqJe1BMzWA1hdGwTY5EXQCKSxOixVYxfckLW\n\
q8WlIzrEollIL2vRe94Mn8aH+tdlMBkTCDvCuPi6GCskk5o2ibAuiyLMdKC0\n\
mhG0B1H/ggjyVWqzhjDVYkI8VeDI8BsIy0ihvHIQi5vLIXy1Am4lYc5jxPK2\n\
ExBuOg5VfT9WdlZi+a1KzD+3FyvlXWwXXnBhnrYfxtIbJ7GwrQpeXQAZuwpL\n\
206y+wqePwTxvvNY2nICc4/vhW5inR0h0tW20HHlWNh0BMr2ObZHV1/XjIU3\n\
KrH0+lHMvVAO+8oapNuPYfpvb8O6rIF3doaOOULb6Vpv1iBAWTepWS6BZ+Pd\n\
z+T064gJisOy9JecfgPR0XPselZ7BeGq2xCs+DYttyPO52ZfZhWNiLRtZsoI\n\
9q8QMyHS9EuEmu5jkRjrfBIpPfczDMx0j9ilvyGpEJX9z/UouygQ4OU59fU0\n\
Rah5ZkwIM4OyfApvT/LwxOg8Wte1eGNoAlfshAKrGTtmxeytMPs/MshD9ZIY\n\
L09Lig9RgCMSA08lxy/ax3BGrEA9LacXJJh2hK+ijAzBO0Pi5i0p+htMkI2Z\n\
IVqOkCmd1CZDx951NG6WYKrLyZZNtkUn2rZJ0baTxNEhDXz+LJTDBrTuXMPl\n\
3auoe0VMdBRmry8hSmrZJsNFOvdwixVJKrUWGjV07BoukCAavWRHJpODsEFd\n\
bJNitN3OzFbmKvt/RiYYoIrKxr4dyz5UNkNpi+n3J0/6w0QbtB4OIWpyMIxX\n\
6rFO+f2IGOxIFSfvFjJpdtd0IICozctaLeX2Imb1bcxvY+eyWZyIOQOl02Si\n\
MWRTKdrNQdVChH0oz0AX5t++yEx5Yw9KeX10KQdSUY7n4/IFklp9DL5K8Ip3\n\
34fI0PGN6zDfQ237UIgYECr/LMLtb1LoqJCa34XAHoKjVo2s5ATB7S72VRo2\n\
URivIHDoC0jKhWxpGDnzQyTX14t4pe+VtyK+MlGCF1dFfhiuMGUdxzx6dSOQ\n\
BLiqNZ32YdxIKsowSZktzD74mmsBneo+jNtEzG8VwBPRsutXM9rNuCycxy87\n\
x7CXt4R9MwvYv6Ck8xP0+qcg8nOGlpjM6Nea0b2mxONdQ+iwBWG1mSnDLoDd\n\
I+5nodoiluHR4WIbMuCZnRCq1birfRQdagt4RjOe7BxEucLJWfGfkIplkU5k\n\
Efal4SJdbDUzwwg5pJI5RDxJ+B3Jq7/C8n4kSHR5rQmkMkXRF8+ytX7ImUDA\n\
U+zW/BeE6avfmdyYtcSwbsAah8/+/2zbmJyWclrgkhnZb6Xu6qRhFeutvOvo\n\
Jd77F0RGKq76n76HO44iq7qIwLFvIhtIFLekEW36HsJ9VciITyNY+bur/te3\n\
I1BB+8YLbBdr5OwdhIXiJOikm/DwTSr1pzYGzKyUUYQ2J/ypbOlFjhImBlfL\n\
8dD0HrSrOvDc1C6sh2yoXzmGw9J2dBKrbSNVLnII8cr02xgyzuLQ/A50UIXf\n\
trIHOyUd12GiXSjAn/r56Fbq0CXXokdrQygapMTWj3t7ZzBu9qJ2dg7PEC2N\n\
6Y148sow+inp2B0W/Ky5G7sX5Tg1J8C9/fMwU9A+3T2EPUtK1C4s4q6uGRj9\n\
AWwmytu1IEe7bA1/ujKGlWCipNyV40YsCLiO/T8U2wr5PPt+LTY88AHOA8On\n\
rvHAXxHuPMZZ+dTPr/lluw9x3uksR0ZUieDpezYIPqe/TB64DVnmHV7WAz++\n\
JgLpe9W3GA+UfrlrmVT3E2MzZD0hnpngQxvLlH39Wkd8CENrlWQM7neURpTn\n\
UCFtxeaZN3HZKMC8fQ518k4oqVQWO8SYMo1i59ybaDZK0LR4EHN+R2n6FpNC\n\
XuFzk8Y2enCySQyrDeikOLygdiCejOH8sgSvTy+iVUl6mwRPIBTEgNqIi5I1\n\
vDazDIGz2B/pdeMAbxFbeSIse4tToMJBnBau4O05MRZcoZLEYl4JKL7HXPbn\n\
ItoT/Q8gWL9pg1fjXfcQ2o8gZx4iBvt3pKzO4pYsos0/JLRXkh+qECj/H4oE\n\
boQxZ+rm0M4ERoYI9szXEeP3cIelXAif/Cri4umifz8HG91yl0pLRaEFb41M\n\
otPkhTcSwCW5CqNmB+ZtVog8pFY95KfiOz0qpw0t6ypMW+1Y9zNd8AUsWkzU\n\
pgTPyU0HVHi8cCSYEMxBSvkilM6yxzWvyXFFZ0Y4kysOMV/j1NMbTh1TVuOo\n\
5AI2k744JetEp7IVj05sp9sU4G3eFhyTtWLYMAt3Ks46le+3c0/0XrTP83HH\n\
pRG8Ni7A67RsGplDl8G/ZcPID8K/46OIDhxGaukkggc+jOhUMwGT5PU5Uitn\n\
70Na2Y/EyIvw77sZKa0KWWkl/Lv+CcHqPyIhaEFi9EUEjn4JiaUO5GNEIbVf\n\
h//YrUgIG5EYexn+3Z+j43QbRp7XrOHx0WlUi8W463IPLmiM2Dk9iV2La6hd\n\
WsSvKOb79RZsmZiAJlmA3WPBn3pHUSlZxXP9fXhZqMKKXoFHx3hkCSX+TnE9\n\
6/Zh7zQPfTamykli09QM+smwT/eP4bJGjwPTEzi6br7eyB/G6PopPEr01Knp\n\
xItTW4gSbLgsq8IhcSsuK5vw6sJ5qL1SbJ3dgUHTNPbP78eAVYCtU5twTD50\n\
DYW9F1aPm0LFiKHi0q8yEB7i3DvVN7J1XDjspAjwXBUmVJ2mSRVTUyqT2ZiV\n\
mU4nkM1xv6NUeoM5GSck+kyIJeIbV0wkgshksxtslGWOy2ZK8RwN2+HxGBCJ\n\
hTfSSpYu5/XqEQj7ipf7NFLLpxCf3I/YlQcQOncnIlc2UwBxHUZ5/xpiHX9F\n\
6OxPETr/ByTF3Oy9nK4TseEjiA+/gnDd/bTcQUH5GSK8l0m12hCt/Rmi3bsQ\n\
afkNQrW/RGzyPPNLJsVbZ/rZqQCf5eGyiXsto4E/hxa1Hgd5M3hbpMSEQYun\n\
xqagCYSwY2oKBuLK2bVF7JJyPYCrJgW2La7jxOw0tixIMWmxoVEqw6zThcM8\n\
PobtIRYHr87MYsYZgIiCc0ynxZbxMeyWGt8Bg5H1KtSrByj0e7Hi5YZG87kY\n\
5kzj6NZNw8nOIilA5yMRqujAvEuLQMKBrRMvoko9iUS+UJxqdguiviX0d/0Q\n\
Z2tvQnXtJ9B46edQcG+1MxwEuWgHGhpvpm2fxPnmb4An3I+29m9hcW2e3UMn\n\
P4yWtl/Dy7wjVkhhaeYR1NbfgrbBN5DOpDDd/z10jm3D1dfvChAJ/o66lq9i\n\
Va8ovWXOaA2V7BDqGj6JMzUfQ0395zDOr8Ai/++orb0Zg/NsNxrU0gN0O7eg\n\
6dJvECSJkyENwJv4I6rPfYw97mztp9E3vh2RZGk48f1wmjrQduEWnK7+MKpq\n\
P4Xe0ecx0Pcz9M9WMHqlNNOanYvP/V39DY9UAsUpNEWJ8QH2O5sUj9/KvuKH\n\
DJMEf4KUUss9H+Hmxmtwc3R2Fq0G7l2/JsEcmknXs2QqXUPFwgLuGxyDyh8k\n\
X09AGctDqFjBdhHHpFKjAltIK5ydm8FjlE3biICfHxhChUKLY4SbHivDH2nC\n\
DQ+TpCW3jQ5jy7wIVxQa6MPx63BzA0bldZhlXvwBNl5u5+uHKUdzUoIT0T+l\n\
9GNCZ/MnUX7mo5herMMaMWhjw8dxsvrzsASjVBPMoPpMGarqP48FUR1mJp/E\n\
qdNlOHKiDFMLw+ydr6+8hOOVn4EzlqZCTYvz1e/CuaYfYnl9nGRKAF2N70JN\n\
+4Mbv2SbianRVPt+HC4vQ/vw1g0RmggsoLr63ahpuRUyRRckK0fRRCApr6Dr\n\
N98JvZN7haCv7d9w8tznwVtspnMmMDvyMxw5WYY+yjta/Tjd40M4cYI59za2\n\
GznuX0B9zftRce4LmBe1YE12Fg0NH8FR2qe5bxtz/ZuKvFUIaZBYaEOe+T2S\n\
NCWMmp9SSavkxMDnINbL8eDQFOplMtLxV9BKNdmITIQ3+GLShkzumIElHMFz\n\
fd24n9LZmF6Dh8nnp0l/PEr5YfOiBhqbjvabRZtShaeHxjDn8RFuJnHv0AzO\n\
iUV4YGgWSqq4XhoeIV2jx5vjk+R7b9k7HBwnukwUu34+x/7/AgrJAEKCM/DP\n\
X0RUwWd/byEXNiLAq4CfX480OxxLClzWAu94OULSEdI3ScQ188ilotxnOs++\n\
fhIRNcE3V4OYfg5h0SCS9jVEJJ3wUySFlQusw1JmPtLRCDuhKLRQA9/MacQd\n\
thKjG9cPoZxsPL7UvZEY3MZ6nCRfTSyPwaGtxAnyLU82W+oXWOE9iCPHywiK\n\
3I+jyEWvoOLM5+FiSpvQEs5UvRvD/PPF4POhu+l9qO14ZANaJvl+nDpzAxqa\n\
iQNqvwJHmFNbXn0zTtKlZsSjZaW3OeL+eZw/W4bG3je4rtC0HZfqy9DQx0oQ\n\
xDyTOENQvzy6s6ykWZbnnkXdhZ/BR4pJOvcojp58NxaVS6X5X15LN85UlqFl\n\
4C3mlJ8qEQwz1SNkZX5mtawEJfa3mWwWdKp0ELk8cBKpZrIpjGs1aFxVUskS\n\
Y4+Tu1yYMRpJJUdhC3jQQeHeKFnCS0Lul6lZjbcqp+TASVud1wuR3Y6L1Lbs\n\
4aStyedGg0SGIYJrkhJCEUqfKDFfPoeEP8L8GGJZiSGZYa9k+PoZiswtp4IR\n\
qjPTRYMw7yRl4aUsbKp/Ap6BN6F58z8QMcnhqL8Ljr5T8PZvgqWVeV2sGcby\n\
uxFYugJL1ffgE/fDfOp+JFwqmE7cy/7+bmKtBvqjPySo1sF88jY65y4EZ3dB\n\
s+tb8E5UwnT8Wwip5fBc/D38agn8fY/SuUnFzRyEseI3SIaipVsVCx5HeeVN\n\
MAVCG9BjhspsFh78IS9sqmMsHhaUq9zmr8FvvoJTFe8iVhv5X6FXRdAb4p39\n\
R+ixYyLkuO6v4UzjHTDpr6CSYDMt4iCcDK7gfA0xWON3IVnvhNWuQCzqQW/b\n\
zajrfollqELagfb6d6G+51UWim5NLU6eehdG5qphtUpgsa7QIoLJKIRCNUNS\n\
K4Gp4TuI0b4GXzK/kf6YCZZdLZ9AU99VVmV+liSmmWAmStxatI7aqsabiyr2\n\
GzdEXZx782n4qQJVjusQWldA1iIhse3H0r6LEBxsh+BQD4KBFJ0xDtHhdth0\n\
AYSpPJw/PsxaIabXQrC7FYL9bViomkYqFoO0cgRBV5Kt1larroB/qBOCve0w\n\
zFuKd00YyrlhPvFrxL3cT3076+6DX3gBhqPfhX/xEiLiOrgGjyHhMCC6Oorg\n\
XAVMJ38E72IvrNUPI+lWw3LmAaKiPJKqC4SFHxO1dcPV9me4RnoRWSmHa2qQ\n\
PXdEcAD29lPwdD4E3/oozEe/Cvd0NSKydnjIajGvq4QhEf8hHD99M+zh6IZI\n\
tSoPs7gRKqTF2/+/CFoGUFn57v/fwGF6bRLEQVUEls6JA1RlxnGl5aM4f/kh\n\
sLMMKNys2iZ0tH8bFaffh1NnP4Tahs/gzNn3obFn8/8OHHUtTlO6rqB9Ks/+\n\
C91jZdUHCfunz/4LpfTPQGMxYnbsDlTWfo/RVBu4oUsPtH8RjUR9G7hJB2A4\n\
cTsCOmcJN8zM13BxxPA63NwBj3AJoo51+JZXsFjJh6lrEMLaeeKKBDRNPVi+\n\
IEXSasbwA4cg7ZLD3NGHnocoVTlCkB5oxvqwEklS1PJzQ3DpLBDuaofPniDF\n\
7sL6pVlEQxHoWocxd3Do6h3mvMQTv0bMyc1WctT+DoHlyzAc+BqcA2fgHd4B\n\
7aE7EVppJ465DY7ug/j/eHvr+DiPa33c31AxhbS9bXp7y23StE1SSLlN26QN\n\
oxtw0AE7McUUU8xsi2xLskySbJkEFjPDSlpptdIKV9JKWmbQopbh+Z0XdiUn\n\
uYX7x8+fz3q17zsz77wzz5zznJkzZ+y9VdQpM1ATXvzmKWhOPMG5XfltJEey\n\
Ya0/TnLpPhhrSuEWp8LYVMnhpms/dFeTYSbczEpboEn9AbTXDsDakgX5gW/D\n\
Pj2RkJNj/RtIMdyEQcXkvPAJOzE6chZq4zQJn7Q4iOLCx6Gp+j9hiGmKCfFG\n\
pJBK7Z/mgoMO9ywj2fcpyM3cAqXDRo80KeF0yWE290EmzUXuuc/gfNm6j8WQ\n\
XV2AE+mLUC1IhtM5CbtdCodThp7WZ5GScTOmDAYIW59EWtb/QJvYTX0rogHS\n\
OrmfjVMqHkROqDL+CH31cViakuAYFnBuSm4VPIqR+XjJ9hlqyiSYGlIxp+OW\n\
FIJ6ESwNh2GsTYJHOcpf6+Wu1THXuJmpgKaZyk6GfagR7ikBUdoQAloh/BZD\n\
XC/75LUw1x2GRZDDOGP/7HqZZxH1Q1I6jtn+AfRldWPmcimkndz65axYgp4j\n\
zdA0C9B9vBKSzHL0JpEtdrIM0oZhiLYTJ95TiL5j5ejcfhmqoWmI9hXDbmTm\n\
fcNQ1wog+OACyc8SKPvU8zKPmshesxzKU6/BXPkOprZ/Bx6dEuarz0NfvAeW\n\
8uVQXdoGn6wCyvS/wd5zDurMv8OjEZOse4WwK4c66VuQpy8mWdcEddbjLMXT\n\
5zxCb9kMT/9RTO25l20YZfIvqHFGYC16nnAqhattB9TnV8PWso9k5WImlkfc\n\
hdOuq0AmEZjLpa/Dw410KMZSkZSyCC3iJhhn0j8k/17959h1iFjs1nRksfJs\n\
HrtvsPsqK/K/gYxcEjL8BgenoRYZhL064UX2d33xz3Hy8uNw+bm6RPzE0S58\n\
gbC6lsVuNKhDYc7/Qw4rD2PEXvUozPsSKeI/QW/nZrgCHgWKr34H6dm/hYP0\n\
lGn6HNLoHUoadmKOiUAWDWBIuIaloperd8xjl1it+tgdmDj0MxjKt2By1//A\n\
IulGQF6A6dwPOBzPaaA8dg+UeathKHwdsoM/h0vWB0XSN6HK3wZT1VbIkn4D\n\
14wEiqP/Q9c+gImE7FTy7+CW90N55AtQ5LwD1ak/Y3Tr7XAbPESnXoCxo4qr\n\
+3QJZHt+CF3ZPqjP/BnTp5az4Wz4aVbOA+QbrI+wobUb/VclsPSK0XdKCG1t\n\
E7rS29jQFlPnK9F3rguDSVehHlFBvOM0mvdVwjw4DlFKNYbTCyC+2AuHQoOu\n\
989CKZlBz+ZsDJcO0zDSo2V9NpT9amjbxZALVRz5+y4bz8c9UEhCtxDa9D/C\n\
rTWQNHHA2UO2g7AUYW+A7XXfdBMsJFjd0yNENgNwj3aQoUj2i7IP7pFyzGm1\n\
CBpEBMgMOAbJJolE4Oo5Qm+dhllSzq5xzi/TfOVJIn6j7OYuz3AxrB158M9a\n\
b+bBy4y3fsFbSCNheDbv5ygs/gvLxE7m3gOTxwcdKe8Usjm7pYMJ8NrVZayt\n\
2CSsTYA3/dQPodL1Iv/Kt8mYoPynbyNbcjO7Maskl+zTa29BryjG8TTGONiT\n\
AEwsbEf5lS/jeM79cIcikEl24BjV5UzeL1FeuQTnc7+ElBM0UCQF9IpO1BTf\n\
gfSsRUg/fSsuFjwPF40Bo+ISzp7+FE6c/gquFj2Ac+c+R8L88xCONHPPIPu3\n\
vf5JpFCdz1y4G3mXfkz2+GdZm/w68FI3qE78BrZRTkg627awoPURoOSXON9K\n\
38R5TOz5A+lPPYI2Fcz1mbCPCmDrLiRdbKCuzYbswI8xO9YHW1ch66riHjhH\n\
IL8H1p58zCQ9wPK+mHMU04fvZMFrI8Fh6uYEgSX/EXomtRvpcL96AIaqNBqM\n\
wY+ANzSH4RNX0bKjCLLKFlYER3xuDGeWonN/PoQptdRNOgxmNxENCEFT2ojR\n\
klH2LIaRK22YJbowcKwYQqKog5d7EAr6IM2uRtfeq5AJZqCqaGPvdR28BoPM\n\
Fl9YMeW9DreO9Xid96eIWGC4ugsBp4+/9gm4RCeI3Qgx/y8Ga8m7cEzLFnFb\n\
HT7NetpMjR1HReVjKC1/BPWtW6Czct60TrMIbR00fC2meHhPP2lTQcd+TGtm\n\
5kGX9X1oLdMQNL+GjJP/D+evPoiewVJ2tlU2eh7Dsg4YNC1obdsLhT7uVPhV\n\
6ORlaO04ChsRLYbqK6cKUFf3LAHuUVTVvUX52tjzLxiH8P7ubTh9ehFOXfgl\n\
2rpzMMd5hMFu6kVL81JUVD+J2qb1VK+xBdvV7kU07MPowB5U1z6LmoZ3MTnT\n\
gYqCbxJd3Hod4JQZ91OzcK/tn7yA6cy18MqKMHNuK3vNO5SJ8e23Q3XxLWgu\n\
voGZlN/A0lcHW8N7BLR7MJ3+CIzN5xBhtvxWLWOvzdA1U9sF+LTNmE56gptc\n\
9FtIKf4Fbr2TAPciDO1lbPnGS3/D+P5fQ3PpbagvvIipVJJJegePN07d3waz\n\
sI9UdiUUdQL0HOvgq0+mA1nY0fhexwj/R4wLBMENPT5qczTMnCcQZ3asBzZZ\n\
0GF+DiLgmiMIRuKQinhdZMZHr4cZImx44Fg0lrgWDdDTA1xEyUS8UJKRUW6q\n\
ctHtPNQS2tUXQ9QzRJqXYWpn4hIIFqMEevNM3MsYUTvyzy1CdtlGfpfJT9g9\n\
LVUF372e7ZPlqEr+ETSVOexUkDHvT5AXHIJfWUVd9n3YJwZZoiXb/X3q4hmS\n\
F2OYOXQ3TC2kDA/cDrO4B0GzFLqi7fAapWSzfxnmfhFdG4O+aCeJ/lri4g8z\n\
0bZI8BjJsvg9dY0Ls+VPYjKVbD+THo7WNZhMeYZkjwOeobOY2Pt9eO3+G+Nt\n\
53ey7u9cdQM86qh1g/H530+wUYBifteCsRpBzG1kdmfNh5wKeZk8Cwf0fP7E\n\
JtoIF8yN7VE7Yh4b75bPw+gmajA7xs83Qy0ch06s+i7f4PNhS+djE42K1yD1\n\
xH/DMBdEeG4KVZWPQzTKafhYyIai7E/gZP4rCETifoA3kYqzo6P+KdR2ZzOu\n\
W5+L913YjfLLX6X+3LCg7zzQ5T2LmeMPkhz+EWTJf4WHSHqQ+msm7Q8kr++D\n\
g+x0p2A3pg7+ArIj90F1ZQ97ao+tfhOmjtxNQ+0uqIuOsAdeWGs3zl8rIZlt\n\
IkJz6h2u72joqbNfgsfkgaN5G2aIyEydeIhsKDOMV1+A7NDPMXX4Ppg6S+Zd\n\
Fb6H6FQuAiVPIVi/DMHKxQh1XUZ05jKCJU/Q5zGERloRsw8iWPEMgmXP0v1U\n\
xOYMCNU+T+mpZcrJ1rFbELMKqZwHEax6DcHSV0heqxDu3IWI0cDoIYTayfag\n\
jgm1v4WQ4AQi0kwEip9GsOYlBDtTmIHHT4fzp0FxAaaKz2khN8V3dd8Io7oW\n\
7YLjjLG7KHGSXtSP4b4j6B4sZDqE6+8vsexxULQHPcMlC/xsiIkG/OymiKBZ\n\
lvAvZ7bzMscphQmREW6sI+zQIWA1XLc9OEgWW4DebP7aFxC0TtE1NfcMQmfY\n\
6+H/jrJ+ysy+lijzzFAYIYeG37EaRdCiYIL83cR3RKiWGrv7FA0KJYJFjyM8\n\
3kqN/hgi6inETC0INmykxnoZof586gAtQo3r2JDOgYa9bBSjiGQ3gs1ZiIg/\n\
QLArkz3EKHD1IUR0kwiRuomolUxcewSrqcMMMvp+GVGjFuF+6gzNFKL6Bkr/\n\
IHWmN94Rd7Jft7CydmHoRkbXe33RuA23YGAxfyfEL+seFkL2ETnG1AF43GFG\n\
3yV2WlMjsQUlZsk+d11J7H1XCMEQFw4owM28kAKIJcKX+5jAvMHojQufuOCf\n\
1xNiTqRbEYe6tgbB2qUcbC/+FmEptWrN8wx8uH9BgmfVUmoNbjWPOc8t0r0W\n\
IUkpVx9rMwKlmxDu24HQYDE3wBvfQ0QrRajhHWppxsfJSc94i1qWWphaPeog\n\
sWfkejJY8hxCvecZpRNv4TvYr/vYF2zM1yLjtJ499am+QIvjyQqkH5ajscPJ\n\
uky3XNZhSs/5AzDDYtoQTvw9o/XhYoocyYcVyEpV4FSmFkYn4c8XRtUlDY6n\n\
KKksBVqFbjaoZH6BEaxXG3GYuiIdjh9R4OxJNa7maHD2vAkOix+5KQpU1s1i\n\
rNuCYwdncCpdjZwzGoikfhilTtRWc8uwzM7SrkoDThxVICNJgcJyG8hoXPRO\n\
vNlVVQj1kFSxjHDAlvVSFzyK8EQXYpZOBJtWUlO9TlKAwO9RI9i4hqTEDuqa\n\
tYj5HIj0b0eg8QQ1+zaEBq5yPdO4mrqJmr2GeEfPVZJQYpI+zxCwR6nsFxAx\n\
mygNSTCSNFFdN0J9WeyW/A83O6nl7KNy9I37MNFrQVqyGmZHmIxpF85lqGEh\n\
4l95UoVRFXusHgtlqTqU+Htc4cX5JDlKauxwOoIoPs28/iykQjOOpWlgpfx6\n\
mRPnTmqhV3uI4mnBbM+KOL04umcGUmUANt0c0vdOoX3YD7fKhWPJKuhNQeQl\n\
zaCxxwOz0oPUHTI0i73Q9NtRcIXbBmOedCB5vwJyQwgOE9WD6jmhC/HN/l0a\n\
/yMkU15jx3uwlYxif5iaohbB8sWE4n8gPFKDmGuCmnkJCezFCHYcYxV0uHMd\n\
pXmBBPlykgVWRCfOsMdFsj0tOslEX0dYvIdQ/iblexbB7lxEps7An/M9BIUZ\n\
bNj5YA09t/x5hAeLPvvRFr9AwJLpguit0BJglWioMaOh2oyKYiNMjhCqTqkg\n\
1XAtnkuAmtCG5v9WepFHAJ/Qc9MOTLil7LM61BVqkJakSpRVWWaGRuXGWbrn\n\
ZBgFCfeCMyqcPqlBS5MVucfkECtCmFO7kZGuhcsdxDkaBAoLxxXr81Ro7PNC\n\
O2BHUT7X4mMdZuzfI0cNlV9fRc+g+koVwXk9xBxTZdWShlci4OZnbm5mdcKc\n\
bgrOmVHMmfULokpx4SZ49nrdMa/XX7tl/lpi+2OU+f3vFhN3RWO2UM2ZNAj6\n\
/IliFrBoxq85ETGfJVoLJSp70FcsztViZHl4tDI4pwbhVMnYuY9vJKpD3M7n\n\
uv4NGG7n911XXMzrip/8FvM65rdms4dxLPgb879jfm4lAmELoexNRPnFNeY8\n\
jpjfe+uH0EZF5qUqMW0MYahFjxQaW2NSD8b6bDi8fRqTmgCqTynRMcLKQuSQ\n\
LBBPBfm/FdS7cyxa+6c5SjDSbkJOjgGCWj2NbzWkVNZIrxWHdtBYnnAhM1kJ\n\
tZl7jakBBySDLvR12nDy4DRE8iD8OjcySTR75kgtUvkzJm5yrY5Hm2HQjqyT\n\
OvbEKVW/DQd3y9EvcWNi1ImM3VNoEHv5vvw80RMFps4uQc+G70G48Q70brkH\n\
spLTCPq55wdtI5jMegbCtd9C97rvoZvSSdJehV1nTGDESkxKvOf3mDVaE9ec\n\
AzkQ7/oNjOPKBPn2Tpajf9fvoBdzB+wa6/dBvPdPcFidiXyzRAzFu38Pq1yf\n\
oEZz0mKId/4eBgk318FMQSkuLoVo8x1U5x+id/t9ZOydhzT5T5hquMym0Vdt\n\
R/+BB+Gyz93Av2rUq8d40q8wVshZU2GHFEO7f47plkL2t1/bgdHk+9G99jv0\n\
qt9F13vfgvjg07DIxlkQxLd8xZhgz2TZ8UcLcKLpdra33f1kRXGRQ+EdH4Du\n\
aj7012rgt3HXIg4jLBVlMNW0wjk8wjpvB/VyeJScbGBWQ5xDwyxMg7ppGAoK\n\
Yapvh2tQQmXEXd7vg37cgZSdUyiunYWRJPvJ/TOoqbGi+qqWEKWF2xtFeYYC\n\
R4+SLKsy4dDWSRw/pkF9uQGHSfaojX7kHJ5BaqoaHS1WpBIqmoTE+LUe0iIz\n\
qKuzofKiBicy9LBbvHRfhlSSi8Mjc6g9r8K5C0aIu2aRsW8Gg3I/emuNOLiL\n\
NCBpltMk/6Z5RFbnKFEv8rJnxO1eP4FzuXoolDQajpOGK7agtcKAVCIUWnvc\n\
fPsK27sTJ/6MjuW3YSxvJ/SCfEjT/oqON2/FZDERgIAT0qT70PHObZDm7YVl\n\
sBnKki0QrvwievYuhtfNjTJD3XZ0vPs1mNXzSLULkiFY/mVoBiYTqPQMXUTn\n\
8v+Cqp0LQK4pXgXByv+GzWhL5LPUb4Pgna8SYVEmUOkmhAuWfRWaTjGbz9ae\n\
is63P4XePX+Hqu4cpi68ge7VX0PnO2QglnAuT6orb0Kw5ruwW12JyDQeFSQb\n\
b0P/6UOcBLL1o+fdWzFWfo4NcjOe9EuqzjchK07H7GQvdA0pEG/+FoTbHybi\n\
G3jowyD0YnrjFlhHNAhMizH2zrtQ5V2D6vA+jO9IQ8gfguHkAYxt2gf16ZMY\n\
evlVqCrEsNdfhPyqgK2BT9KO8e0H4DNpIVv3HqZTz0F9Mg2DL74EQ2+84X4J\n\
jdSOIx/IcLXMyk4TzmrnUFVoQFWVFRYHJz5kQ04MkwirKDBA1O+m3w4UXzFA\n\
PDzHbn+RDjox1GdHySU9Ontc4M/PgVnlQSXlqSZQ29w05oIhDIqd6BPY0CeZ\n\
Q5As7dZqE4ouU7kDHoTDEXSW67H3gxn09Lsw2OeAfY6j+vIRJ5REb9xmP1tG\n\
R50FSmsEPrsfDaR8y4vNUBl438XPwjl4CZ3LPouhc3vmVYnfgJHdd6Br2xMw\n\
tJ1C1zu3YuTCYcZCj8NIX74eHW9/HvKWVl647YRg1Tdg1iyAXydBZMXXoJXI\n\
5uE3fBldK74OdQfnc6MteQ+da751HfysDdvRSZA0jqsS+dyS8+h897+h7ebm\n\
ztUF7xDcKc2EPJFGV7wCAoLkWGkWlyZ/GTrX/ZCB36J4VJMoceXBzf+FgbNH\n\
ePwNoHfVFzFedR4h+yR6V38JI/kn4hxBX7IS7cu/QSN6htfxP0DMXIuoNAVR\n\
TTvXXA4x/U5FVF1ONicT2NWImKGfU+i6ArKgiLKb2rhDV2JBxPT1pLk5DRyz\n\
93FlqRoQ01zjjlizNlFZdYg5BolrKqk8A/FJSjN2nH4bWMudsW3ZCZOQiQmL\n\
x0dQuW5cyD/YCdsY0emCTExl8p7YYRsm123CrFQGxc6dJEy4ZUFt6i6oy/vg\n\
aLoK5TVuctg31AnZwWTY2uowvuUIF2QPfsxsWQ9Dz8QCyhRBJVlZKms4sUfK\n\
a5xjrSV/ZH77sLF2Gwm5rxAaxhfFXe5dY7VQN+ZDUbIeghW3wzAZnwn+BAKa\n\
DghXfxHD53ezTzY1/P+LME3Ru+hc+31SCO5EmoC2HcJVXyCEnfxfEPaF/xVh\n\
0gqScNEQKTY18b4AGyDNoxqEsTUDAzvvQsfqO2BR8HsEiIvZWxCp+xOhIwOR\n\
+t8gqmhERPAAIgP7Eel4BJGmdYSWZkSaN3LhMGvuQnSqCpG2h0hlU2d5xAgX\n\
LSLUXGURE2l9ENHBs/TZgHD5d8giGaXyHkVkrJSesRWRUbJSel9GpHc3/T6M\n\
SMsLiNnGufIYFeNoQ6TxWYZT8mdxLUCbj9C2CzapFpZLx6EoFPCCxIfprVth\n\
IZqg2LkHtlEObeYLaVCXiTi0FXZxuBrpZtFmba6B7MDZBJNVH/gAeuF4gvuH\n\
w9E4v+aDiHBnK4U4UZpAm650FTpWfZ3UoSHh7aIreZeuEYK0hgTKol41+t//\n\
BvozN1yPMq3poygbnPrXKDPNfhRlE+p/gbLvwW52JNKEHaMQrfkSxko+hDKb\n\
+99AGbcJMuIxQFO+AwO7f0Fq+XZ0LLuVyOyPISs/j3AkGkdZTLYbkUFOW8cc\n\
IyS3hIi0P871uLOVen8rXafv9m3M0USEoiXUV1ZC4GOUhmyl8Q8Q6XyN7r/N\n\
GiuRrqcJoUcRlZ9FuPkBknOUtvtlklsk9ybpWf27KO0zhFCueyOdLyMqq6Dv\n\
Z/lnCgh5Sz4OZbGgHdObt8IsnoSz+RpG1x2A3+5FYEaC0eUb4ZQrOJnH7e+C\n\
KTsZ6tJeOJuuYHTtIfhNdtjK8zBxIAtzZH+NrVgP+6QO/plhjL21DAaRLBHF\n\
1NiwC+3LiDiJRxKyKkLGlt9ugb5mK0u09KR54iiKuCbRt+FrkJzdPI+iFdTz\n\
M/p5FBHV73yXCJRYOo+ikasfQZFg1Tdh1VgWoGgH5fs6DKPzms49mPevUWQf\n\
+QiKBGsJReY4ij7Hrvf/b7KKUV/y7MXoeOvT6N31F8gub4de1Aifw3FzHD1T\n\
BxDp47LGXEOkldpJpjxJvR5gA6FHBNtJRvHomZugnn2RR88TiLn1dP0RxCwy\n\
Qs0/ENVPkCZrJNmTTQjajHD9r7mJLOFrVHaIQ88AExr0acQ83DxGVPACoaec\n\
ynuSQ5Srh+ThCx+HHo+4ntjfa5BuPwavRg9tVhrGVq6nz0aoC1tZyaxOSSPO\n\
ya33WYvOQdc4BHdXNSa27cXk1m0YWb4a+mZmt24UlmvZGF25DhMf7MHosuXM\n\
idY8eohSSS6ga9lnMJx9+Lo5dEXusxDtehK61kx0L/88xi6emF9U+AQcvaeI\n\
iX0G0oITPIh2UeN/HrKKqwkwmFv2Q0CWwXhBTqKjHcJMltGrBZzi1pWupXxf\n\
wExjZSKfofJ91qKQVRUl8tk7j5F18DVousX/Nog0hUS73v4S5M3x2EOfQcgi\n\
Qe+a2wj8h68HUWU2u5wweuAnRN+fwZx7/jg8U1smZIUn2NDy8WAdMc8gabrf\n\
IjpyiDTN7xCZLFiApgFCywc8mrYgpjiFSMWdpPFIdnQ9T9rxIsKNL3Grl9MH\n\
ERERXxrZQejZQIgi5LQ+T7yrjLTkTxAZv8TJrYk8RIfXkexZTt/vk7x6keVf\n\
kbofsDPYEeHz9L3nOmr1CRJDLky//z40FW388moYQbMJQVvcqv8UIj5fYsmV\n\
XcQIhilfgF38DDtmEZx1LIqfuRyy2RBye6DatwW6LimHoZ9RciukR3+LDmJF\n\
U2WnMDvRB231bnS/+yn0Ja9AyGMjs/B33P2KXDiVUpi7z0O86VvUiT+HVWVK\n\
gKhz+a3oWv8dzNRkw9pfiuH9vyDp8QV0keU/XXkGlr4yjBz5LcunDdIZHkTr\n\
uHwbvg9FfR6s4iIM7r4Hgne/SGX9APLaHMpXgpFDv6I6fBPGSeUCEH13AYhu\n\
50F02wIQUZrln6Ny7oC85iyswy2QZT0NAUma8QrOUypkZUD0BU4SEcOcOvkQ\n\
lXsnNF01cCnGYGhMgXDFZyA6/A6zPpIg58xRQVFpFqI6EbviGbMy0QtjTDAk\n\
ojNyUmYNJEI2EzG/hnAltTPRoJiBCLpjiu7zSxghG5H8cepZDxHzYkQnrxA4\n\
7VR2HyK1v0R0upnokITAomEBHlUWEkG/xE3HkRaL2YapzGbKd5WZ0YuT83gc\n\
tNnyS0Soj2JO7+Yj29L4zDkN6ygX++RuHhkupxQ942fQPZ4DuUXBrax/HgEj\n\
6auUP9PQpZ5Y803qkS9BtPdx2ORczwXojcbS/ko9/GV2CquT7vduvx/6/n6+\n\
R74FU+NedL33bUgvrEXvuq8Tu/kvdK26nSTSQSiL1qN75Veo3C8Te/kvjOQc\n\
RIjfkq0r28DOFY2fX4me98jYf/cr6Fr9dRJHKVBcWUG67MtcvlVfxeiFJGJr\n\
XD5t8SpC0h3EpeOD5GuEijH0rfsapGWn2TRqEi09m/+M6asbiPd/icpg6vUl\n\
iA89B7fFzqNiEKL3/gsTVTnsb5+mB8MHfk31/Bq613+f6nMbevc+CptSfWt8\n\
vDq7aBQfYc8qiU4VsRuBI33vUz9F+d0BN7NjOCrPo2tksc2kIzrTyM+GJvan\n\
RLzexBk9t/HXmFAl/LmeiU7TqvKQUvQtHCy6E3UjdfEnxIIeOMcFMIpqYBsX\n\
I+gNJIhFLDQH5yTd66mGdUSIgMezKG6dM4Ei/DYNd46wZQqzY51wqiYSjh0+\n\
wzhd66LhP8Gs790QzzZno2xaNuSN3zTJZVPLeOYchVcnJduQsqkmmSnluFQO\n\
e20IzOqo9GhCujPOaYFZDZE77vyUsMdKNIgRLjHWU31W2gXH9CBCPv+8SRgN\n\
I+QyIxyIuzLcTCaIk96yG5aBJtiJfgW9Xr5xPwHuNF1uawv3jzmCmD1cdv4o\n\
U2ZnMR9flJPFt8DrtyAQDiZy+QNmuHyWuBt4NJaY0IDHp8VcwJMoPhaLct5O\n\
iYVz5pAUfoV00df53tRrruBEyZ1IKvkZGsca/54AgxHqqmSYpIP8mTi3sbsI\n\
+sc3oKDrSeR3Po4Z+zSUmnTkCx5GaffTaJ7MRYAq0Ty0EvaAG31jq1HU/Q8U\n\
dT6EQcMQZu11qBvM5Cv1q/hbU1XP1EuQ1mdgjmT9Z5UKWvrQ9fYtGCnOSlTK\n\
QdLucvujmPW7odSeQr3kIEq7HoaMOjnoV9DDn4RM14HqvhcxaSjD1Y7n4Qz6\n\
YDUXorD7JUwZClAq2vcxlUoqFmKXQPOvKhUNOmEdaIBTp1kUDxO1gBPxe3Zu\n\
g9lahGu9exI33I5+lAqfhpXv3Oa+19A/U4ja/tcwqr2E0h4+bUCN8p7nIFGe\n\
R7n4MF/R/1lQ0X6FGZVSPf2qkOoIOWWjOnRpuAhNGrMdl0UzOCdSQKK3o33G\n\
AlcoilmXG83TVvgiiVjK03oLTgkmkNI6jiqZhdsmQ8WnkYWxrmYcJQNypAtk\n\
aFXa5w9kDIXQPKbC8bZx9hETs7zVQ0NOJNMio2MC5/vVmLF5UD2iQpvShgmd\n\
FRLTXHwkTWosEOkXLgp9pKnnHQqIXEQCiDBnDAHxEyLDET+C9Alzl+PRjJlw\n\
jUzKaDSyiDt2hyycaJAImRd+GnpBPmzvt/l7bChfeRkCJW/DX7IaYZmIz/dl\n\
eFyduNxyP9QuFWbUSageOIAK4aOQ6IRwefoJVY+wKKsRv4QZczPyCZE6jw56\n\
/XkUCpdi2liA7MZfQWYZYXT5Jxd2IqPXg9hS2I2/nevAsoKeG/BWfg+J29cv\n\
d+OIQEFjyouVVzrw9GUR9tUP4R/n2/Hns92YcYcxKFPg0fN90Ps4yE2pdHj2\n\
XCtWVY1Qp4zh8XNtSBLp2A7LLBfhL6fbsL5mBHuqB/D30624OsEs1kdwtlmC\n\
R3M6cbhtAhuv9eDh8z0YsgcxIdfgsVOt2FI/hr21g3g+T4D7T7XjyqgBp+vE\n\
2N2hSQigU1U92NA4FRfsCzuxebwDoaAZksks5Le+gLP1D+Fc/eMkSrZiUN3B\n\
+FFxyp/ZRx6CSleLyu5VlIRJ9jB9nkBBJylNWTFmvW4+SN6XMDcnR/fwIeQ1\n\
PYlzDQ8jp/EfKBMdwIhGAD+vmP0kkQSDB1DStRFVfUehsXOhHkJBE8ZUJRhS\n\
FEBhm+Q15aegM7agpuc9ZDc8zD7/bN3fqboPk5BZCcHEFdi8zgXRn0nMuvSk\n\
+/y8PvsC5p28sOA+7/zGrp0yc6Q+hDqPIDxKXF9eDv/VxWSoBhmtEo8BE/OY\n\
2DCxiX/MVCtbVPD6otinhJkFUb5Zvsxel8mP4FrX07gmfAVyhxrW2QaU9TyL\n\
oq7F6GZQ7ptBBf2eDUUwrTyM4u7FKO55CZOWMbjcItSInkNp3waYvf6PQev2\n\
a0Ic6TUgGIrciEAovOinCJE1YNab8dzZdrQZOU3XIB7H384KofCEMTqtxOJL\n\
/TCwSI0ivbIXb5SPgQ+cimbJBP6e00Npg8go68W7JHICvDI/29iPVyitnETU\n\
4rNtKJXzq7tEf9ObhlE5aUPtwBj+mieGmQ9OUy2SUnki2Ahb5xvEONClTSD1\n\
XK0I21riUSRuTUA1ufSXpAxSUdr+BIn/H+IofY5c+yFB+EdIKb2Lvu/G5c6t\n\
sBAG4j7sQb8RzaJVJCZ/gmRKl1R8B45e4/Jyv+/CyboXMGIY5Sn8V2CztuFC\n\
7R/ZeymUj3vOD+jzPXrGT3G+fT101GltvW/iCJWXUnon9uX/AJ0z3CSKe7YN\n\
x0p/hIOF/4NCyakFp1d8lt0KLB7ZieNld9Pzqc7Fd1L5d7LPOkplJbF1upPq\n\
tAQyq5IjkXew7qTBGpJ8hUvhv/wUQtPcvEtkOB2+guUc1EJ2SvMWm8ZHacJE\n\
0yKjZxDsL+LSkjnrz18Cf9Gr8OU8xN4P1q3moB0LIdyzn6D+AvxXnkSor5bI\n\
KBmKla9Teqa8ZxDWTiMylI7gILeFK9y6maRwHz80byW0eZlwgfODi7rfz/uV\n\
hr2kobofhyXI3Q+xaaOJWVVGG/BRonkP3gU6lAP0cYmFb8VboVUbsPhcNyYc\n\
3HDTa03sb/lCJPvZVV2sy+9G6oA5wQOdFhuW5HRAbJ3DCULyvm5dYttU34Qc\n\
z1yVoFOqZZF8uH0SZ7umcKZ7CtnCKVKQs1DoTXgul1RBiQTZpFTPtY/i6dxe\n\
GL1hDsndH0FyPCB+HMhpFb/AsfJfsgA4XvUgSnq2ES07hPKu5The/jOklt1D\n\
936ICx1bMBefKyWrPmRBleAFwshdSCVcHq96gLJuRevwURqfe3Ch4WF6k5TS\n\
HxPTSat4EONmRaIzIiETrjU9wOI3reynSK95BDX9+yjvIVQKVyOr6tcs/tKr\n\
/op0ql4aVSG9+nFU9O2F3KzkcG3vQGblL6hqd6JkKJvBdbxDVKpcHCu5g615\n\
avl9uNq1Du2jGeiduIC2oYO41PQIVfmnVLkfIbPuTVh8Pp5E30HW7EX4Lr2D\n\
qMdGBlI+AoLLrFUbLHsa3sz7CHda0vyU5vJKNk1EdgVBZjdM32EEus4zp1UR\n\
ZgnPCrKgrb3wn38IETIIAsWLyQ6JsF5mvuz7EbEaETV2INhCon0oC778dYwf\n\
MiLj5xEUVRH+9yDQw4X0C1W/gdBIe0KVMN7Dk9oGImQJP4Sb42BlbAca1VG/\n\
cd7xJsYeqza/lc+vR8RvSfQGcy5P1G/iPIDCvBqJeLgyWI+daIJtMRjeVdyD\n\
FdVSlI5qbsC1YQ3Vq3BIC6M/DANB/x8E/XE+hKtWY7xuKDx9UQwjOwgj2EEs\n\
ZnenJjEU7CYrXsjuQD8/FHYJ4usEt6FvfAbPXJFAOK7Fs2dbsatlgh0GZ2kY\n\
vJzTho2NUyzEp4gvFvfLkdo+jrVETR49L+KGQr0YOzoUcR6ZQyNhSws7QZCY\n\
/E0Mh/KfE3B+SiznHdL/2nl6TkpUqS7EacJcatm9hLt70TLVHPcbHRs/hGQS\n\
lUzWrIbnIbcp5mczP0sqVIeOfkby/5TVDmdb1sHNxykx6UtIAv+YUH43Muqe\n\
g8KuW+ix7nKNo1H4BlJpoDGVSyGhXNh/OmEwf8xASDhgRSMOlLU8QsrqbhoJ\n\
vyal0MKsssezhoJWCBj3dXoyI/ObJ2sTAyEymAZv1u8RKF+JQNFi+CuTETV3\n\
w1/wDsL9qQgwWzmGMijNHyjNKkrzLAI1jIvlEQSEV9g9sUy+KMvyyWquehfh\n\
qQGizC8wfvyIWVrhTf8R/GUraHC8AX/x2wi17YTv9P3sM/2FTyNQfxrh3n0I\n\
9F3jBkItpRltj0c6vZkXlAHFNjh6fwvXwGNwDa+n8eGGZ3QlQm4r24IB5TY4\n\
+x6Fs/9hzCnzCdhTcPf/Aa7BF+AaegpO8VKEZoV07feUhn6LfguvunEh5neX\n\
9OKpi0JsLB+4ARvK+olyv1cqgdQVhElnZjG+EPPP8pgfk6vx4MkWnOjTwEKa\n\
7VrnEB7L68XYLJkg4TCutA/jURLXGrp3spwecUWMCXsAc14f9pYIsbRCChuZ\n\
X8vzOnCwW8M6dZlZldGOk8NkkjlmsexqDzqNXBj4DokMj10QkUSL4HKTGI9d\n\
7IXE7IV7bg5rL3VgV4cq3vfzeCchSfJ5wqpL8BSlIgfHCamphNRTTe/By/Pj\n\
cFCHy3V/REoZA6ffY1A/xef5NGvx1woW4/C17+PQtbshVHGbehXyMySMiS+V\n\
/AQVw1du5pEZY7bIdS6mwXA3i+jiwXPz4+WfgfpmeD0SYn0/pid9BzmCfcxS\n\
PF+Lm+GfG0IW5UuhfFdEWWy+z8RFu76eRO9i1ps93LmNkHcIodYNCLRfRMwr\n\
hz/veYSlxfDlPs95vAs2w1+eSmhPgu/8C4jqRgnRTyM02ISopgm+s/cjPDOM\n\
wIXfINhTxsas8l94ACFZPyJjeaRGlhAluUblLUHEIKNnrYW/+iQhei+J++WI\n\
kogI5FN5430fRrRf9i4800zoKg/mhh6C11AFt2QJgi5CdGCCEPpHhDxkW/tG\n\
CdlPwadMpRHwe0R8VvhnVsM9eoK+V8E9mUmjYQ7esSepvMJ5JwWOxST1GTnP\n\
T4IzP3UHncaEF3KEGHfE4WzC87kcLx8mOL+Y14WllwRYUjJCQs6NvWQpPnW+\n\
C2/m9+CJ3C7kT3ARkk5WivHSlR68cqUbL1zsxDMXeyDQcVNOg9MavHShAy9d\n\
FmLx+Q6sJv5uDkTZOLnH6vrxZG4n3sin4UDM6ECnknUMutw8gH9cErJ5llB5\n\
D+V2o17l/jCciXDgkvAQe25mHM7MobnXmh4k2P4Uxyr/BqWbmz+1GMqRXvYT\n\
Fubn2jbBH43HVP8UrJZ2sms2obJ3G4Y0HJVWKXN4KN+F4oGTfNqbYdTmk8b6\n\
KY/jswt2dvwzIN9EYJWivn87PWMTBrTCeHFmYwUyyu9l6cmF7nQ2FGccwwy3\n\
DovTOOpdvgER4zSCbQeJlmhYURfqTCIqPYWI5Nh8GhtRGQWZcWWvk0Q9hAhZ\n\
vIGSpZxkr99NUl2FUMsGotavI6wcQURZA/81ksglyxCeHuA2pPQe4cqr2ISo\n\
3cFRo+o1JLmZa1uJCvnmLV1CUtgXYKYQr6cnDK43ITDLxbYJanYSJjPgHnyV\n\
izPkHYBz4FnWR5hzp3wKAVMXvLI1cElehqPne3CPn4FPtpTGQydXhj51Htfz\n\
5may2MQQeHYWc9EXWS4fIWlrcPoSMfTjv5ktKUz8fOtcAA63F8M6Bxu7IxIO\n\
YVhlRse0CSpnINGfDm8ArkAYaosDvUorDJ5QYvHKSfkHVBZITW7mOfE542gk\n\
jBmTHb0KC1lRc+D3ZcI554fdF4LB7kK/ygqVw5+ARmJCpPge1I9Wxyc8xCOb\n\
iTT/GCnEakVaNuoyxqdOIIWYR3Lxj1E5nJeYDnba2glGd7Pk+Xjlg+jXiJgA\n\
1nEpOufsTgDz3wEth8BPIhLxwTw7BPF4OnJq/kDF38sSn9Jh9ty4W+NdwUxj\n\
zB+0E3c6ic1fnueU8VCCTM/HIxTexO4r4bROiBAYS/ipf6SEG7kNg/y1z/PZ\n\
oy4b+nZkQZjRxJwr/PkPA3E5XNKdiHin4en/I3yGWgLcfSQwTxD1nYCr73fw\n\
WwYQcTcT8B4ka3Ycc+M7yfKdhG/6XbjHMhDQ7INzcDXCHhk8kt/DM1O8EIgf\n\
FHXjkZxOLC/ovQHLCnqpnktJdqWLuF3J8SWSRE+X/hId8gGupz8N6fQx6lUy\n\
v0t+juZxzrVOOpVG1xhz6x5c7FgNkSzvk+idzCWC3DtxFoOaTm5CiShXu+gt\n\
HL12J8vs0ggsea3L0DpyCuLpq5BqWmB06uCwC0hK/3IhAv4ZAD7J18zhnMKo\n\
ohBN4u1kYj6CjIpfs5MXjLXFiKy0Sma638gt3d5KaopUmNXFnbrOrwIHnW54\n\
Z7ktbmGiOhEagH6TEd2bTkPRb5jfIhvww2OwEM2Z43djz3fg1AbiasT3Bp4h\n\
qbCLjXTmm9lE0mQxvDohwrNldI+4XP8z8OlqWSHmV2whSfIccb6XEaAORcQO\n\
7/ibxANfJ416Lzzy0oVufG1jauSJmJmfPBHj3JLbM41mhf1/6b1foH2mLz5O\n\
x6ePz/eetPW63jtW/gtG4xC7P1z03UVfJhrzA3ai5ei1byOrZQsfHYghWya0\n\
i9fhBKXn7nOTPszkT3IJGcRV9+Ns3d/IRv/5Qs3zz7owvjve7pCgtucd6v3f\n\
UFuTOqM7KfycFMPTjlGXXmx/DxMmWTxLhNiGtr4XdlXcb/DT7MC2DwxDerYE\n\
Y7nVMI+q4ZyYhOxKE5wKK6wiCazTprgfgGN4AvremYRUcE3IMJFThuGTJZip\n\
FsHnDiZOUmHuzRS1QD+khp3yGfrkiXzO8QlMZJdSvlLIa8SkRrlpvFg4wMbJ\n\
GMkqwuCxAkxX9sDnCSZm0uyDA2hffxLt23LRueM8JDk9bFSY9rWZ6NiaC1FS\n\
Ad0/Bd2Eme3/gZ2n0ZnSxAVbN2jRtekMBDsvoH3DGUzWTy4YFPPRsydJjVqH\n\
mKokRHmMU2j0HWTWSBMRKQmw8YiUcdQx4yOg2gH3VD4bRYYxAQ16K5r7VGjr\n\
V7OfVrEKXWNmJigev2K4cA3kXjSM1s3LkBMJFDZJW3gUppK4vovVCqfqn0Bx\n\
17qb6b81hAD6E/mtzxGgyCKggXyp5xDDreNz9FYS+t1j6ajt24ZrgmXIodwZ\n\
lb/B8YpfsOA59q9xWCQ5x7KZODFzO3pxoeZXrEpLY+cgf8JORWXVPopi4WYI\n\
xi9Aa1eyLg3cS90Lc00dah9eh+7DlYnp87mJYbQu2YGuLdkYOXEVglVH0fzS\n\
TrSuPg3bqBLidbsxQDyU+xfDePIZtK29wvasvacXrS/uQPe2HIxlFqDtNSpn\n\
XxH8zNHiRJ0l246gcelRTLUMY+zoGXS8X8jms3V2o+WFHRBuz8VYRj5aX6Uy\n\
DpWQegpDV1KOhud2QpxUiPFTRWh/cy96UyqYPdbxyT3mAK2eLRkYLhlC0O3B\n\
SPJ5dB1uxPiJy+jN6UJwzofp3Gto31nBblX1qxVofeso6tdkw2kPwdzahr4z\n\
AgS9fhgb29D2/lXSOfgQHsNWAQlYdqoncTRZmBR/cHZhfLhPoLmlH09tLscL\n\
OyrZz/PbyvHWcSHsgRgPsnmGnUyddU2cuUCgfBq9krXUiT9hlZhALmGbWa+5\n\
ihPErBlMFIiPM3vW2O21VJRJX0zE+8esvCnuz1hQ1KfYQ1MCQTLgfSZYHVK0\n\
iFayYP1n5JpBa7aAI/3x6K4MlegaWEcM6kcsRzle8WdUSzKgsEzAS40f41Ox\n\
++4jfgzvPYHW5YfQ/FYKbHrOnLY116Fp6aHEiWpeuQwdr23HcGk/69rSv/EA\n\
Bgt7E7iSpedCsPkamVw+DG4/CsGuAvBLDPBMDrOnDbEnC4Xc6Fu7lzqfmzif\n\
SD2Hrg9KEQsRgdxyGF17ixEPr+wek1C+VBiHVRg9dBIDZzoSbmO1VWh8Mxmz\n\
pkBi0jhqN1NR2bDque15s72dhKsmWDqFaNtwGgPnGkhwFqM7iQuorC6sgPBE\n\
EyRHLkLaMEUq1wt1Uy9B9wpaVmZgME/IbITgcXU/j5fWdgme31GF1/bWsJ9X\n\
d1dhxcnej8VLKllYmfWvs5H84wM/GjLgav39ZJExkw9/wqSd2wIVIIsou/rX\n\
rDzJqH8ZtkAocbrs8Ph+bpGCWSOcbIlTrWllPip6PkC1+CisgUB8IsDn6iX1\n\
9s/pLQOrY5V/h9xuTUwuMNMYNR3PIpmZqCv7FboVvXytb4LNJoJk5hIkilI4\n\
/F4uy8/gV46j9eV9mCFd1LvqIEbLuCNMPCP9rIToO1oCbdsQZiem0LdmLwaL\n\
RCziPg49nVuKaXBaIHx7J3qSy6AXDEDXNgB9xwAUlQLYFLNMEBL0rdvHoTCO\n\
nh3lCFhN6H5zB0RpFZRPwubTsfk6Mau0Edf1wWsyw9TZj8nsYnS8sZsgkY05\n\
7/z+q6hnlvRcFjTDnBWvq6xB54EG+Ix6yBuHYBqYwEhmProONbHbN3s2Z0He\n\
Z4ClvQOCA1WwSAZQ/0Y6ZHUSmIdkMI7q+FHGC/BPsnFsuO2ZYX5qGuB21qlo\n\
TNnmt6vyl+aU8+uk0eC8U00gvqaZkGL/CSrTyn9GIuUeNEgrEsthYxNJJEp+\n\
zM4HnG5aA0/cUqMR0NW3grO8CBelAxcYGzFhSbmGSIv9juXaqRV/gcxuS9g2\n\
/WO7cLjwuzhCmrlHNRpHp91ST7z5Z4TOO3Bt8PQCdN4yj05m7YXGQW77Bljm\n\
HPGJDmYutalnKbvuklb5Vyhcc/PgpYZq6H4ZBwu/jcOlv8KkzcLfuxfqKwVo\n\
fvMY5uaCmMnKRdu6XP5skRisXSIMJZECev84Ot49iqZ/fECyqW8epUV9H0Ep\n\
c6BVz/LdaCHZ1Lv7DHp2nYFwWyYaF2/FSLmE1Z0fRmk3i1IzoXsXWt9Jm8+3\n\
NRMNz26FtG4UrmEJOt85gMYluyHYcBJjeQ1w6J038gBlXlF+pRKNq7MhvdSA\n\
lrePoju5Fc6xETStOAlZBY3RpAvozeqCa3wUjSvPwOWOImzREdHLwlRlF9rX\n\
ncEUEU4RETzxRVEcoLckHkEWychziDqViBnTEVaWMps3EZE+ixAz8dZzJ8Iz\n\
x1ggR6bepN+/Q1j8B4SH15CKmEFYugKxeEg76V8QsXQm2Ny/huiHViIIjmkV\n\
f0DbRDEcPifr0uL1ajE4cZxA8ktKcy87R9A21RFf13M7+nCWmQIlOKaU/QLX\n\
+tJgcOrZrEEmEJC+DgXND/Mzr3fhUncS478TXx3S6wpwjDXn7sbJhlcwaZIh\n\
xLjGMKFIokQ2LEJca3uWvc8QyTppSSJc1Tx078Oxsp+zxTPr2YLxPAzLr0Fp\n\
4w58GWFEeTEzWXcPCnsPw8IsfEWj7MKr32/CgDSZzB7u7bMal8EZCi+Kn1TK\n\
xBfoW3sAPalcHDLXgBCNL+6DftSKGPGG6auNZKTYGQcdhKxG9K7czUlZwvLA\n\
5kPE4AvoGfwGRQbLjL4OeiHZepj4W0Vi0XhuWspKb3mnnFFMEK/fh5HKoXmJ\n\
S/o6GpxD/6ZDECZVUxtx+dwTI2h+fifUYjkmjuXQmDuBWfUsyxmdY5OkCUYY\n\
hcq9zpdZEGkbeyC90g5ZQRU6DzZwhwz2D2PkdDUmSkTwuoPwadXQ9MSNpzAM\n\
3SNwGF2wDY5hOKuKcD+AQCDyESh7Een/I7ECGWL6/QRbIq/mUwj1/p0Lie/p\n\
RnhwKd0fQGSIvt02etcphHvuRtRUTZB+iYQwR34ig3chYmz6P0D5DnYV9nzz\n\
CzhBpI9Z9D1Z8wCyGx7B6Zo/cRKXWYAi/nhZmIq5cCx+epZanY9MQngyicEU\n\
Er6MyXuu/hEye/+K42X3cjYr4ehcy5swe91xF41o2IGqjhdYVwZmnTet4rfI\n\
bvwHrrQvQ27j40gv/wUrx5nZimPV/4DGZV8UDyLAQZh0AzHZEuF25Nb+hmW8\n\
DFU9XPRtktbc/vFgQIn8podxtOQutqzM6geQ1/oWLrUsobf68w3Mg6nQ5LJf\n\
olfdF1daLIKd4m7UP70NcgHnohyds7OSVHSyhbSaG6KVe9D+fg7pbwkUBInm\n\
f2zDeM0oc04a+t8/iLpnP0DX9hyoWkYwnppNNutVFhaW5laS3DswkFENbYMQ\n\
veuPoGXFaTgJJia6J3hrD4T7rsA0qoE0iWzZTZwrhrm+iaT2Tgxm1ULT0I2e\n\
9w6jZfVZzDmD0BWVovn1Q5A3EJeo70DH6zvQk8SePhefGZjtEUCwr5bVYV/9\n\
GPgN/JngNUXwO0jwK0JU8R5Cwl8jIttBn62IjG8lzmVCzN6GyOQqhEUkXcVP\n\
IebqR3jolXlJOvST/xB+t0KnyUcGs45V/nt0KwchlZ1AVuWveT+XH/I+Lnfh\n\
GEnY6iEmZF4sYdIYjPXIb36K5Ni9XPqEn85PcaLyfpSKkmDxuuKMNkBUpalv\n\
PTIrfsVihXPR+T7vEsSs3P4K59tWYtIc3zr7eRZrJyvvIwjfg46ZRhjMNThf\n\
ez9rshwu/CaKBud3/rmdo6jofI2qcw9TDWILR4t/QCqfeQVmdTe9+hF0y5sW\n\
rC/8jDpdAMmJUsobN0Ji0NY0YehMHWteuCfGMXQ0B53r09C1OZNUbSv8c2EW\n\
aDMXizFZ0obhI9noP06AauzCZIGIr08M5vYuiLZnoGPdMQykFsMmn2U3VsrO\n\
5JEpvAttzEHSzaPQUz5ZkZjPF4WpVYDebekQMPmOlcKm5OK4Mkebz+SVonNd\n\
GtpXp0CSVQ2Pw5+IoBewWWGdMvGK5kMoIz088FdEHaSvDWQFygllJOxCvfcj\n\
OitG1EzWVOcPELX1IjzwM4THVtPffSTgmknVywhtDxDaOL4bGbgHEbPwP0DZ\n\
ZxAipWp2TMHkmIGHd7lzuYnrT5xCo2QfGgb2onXkNFSzKp5qMLPoc1AbO9A5\n\
mobmwYNoHjqMHlkxjC72FPVP8skcrkn0T56hJPvROLCPituPDmk2lFZGKcfi\n\
a6+RkAtayxBUJglmvVyD+ubUEEmJVw3sxpCud+HRcox/ldbYjvbhQ6jr302f\n\
PWgcPAKxvA52n3PeYzGGsD/AHEaWMIGYLmSCnM2pNbDNJI7wYnz/wwHOHT0R\n\
u8vnIOW7A4PXOALoUakxKzcmnKwWZInH1mbCpoV8XJjE736ok11NCHfdjvD4\n\
bkTl29hOjvlHEO4lcTHxARGtxdSRL7J+YuHB31O6LYhMLydx8iBibjnCfd9C\n\
uP8ZImzvItR1F2m++K7XW1h6E4rO+2IGud/xZR2mudRODbFpJSz+ucRlZhR4\n\
DHRZAe2cPe5y4QsSkO0qGH3cIZJBztM4vjfynwFqNd8MEydyINicz9CERKBS\n\
5oBY+eUyaCRqtlhp6ll0fnCNTXP3wqb6Mr0u4bz7G/T6JxFV7kR4+hI3aL1S\n\
urYTEcUZ9sBt9pp/hpqTmk+2kfJpiFmoSeouRpQUd0S2DFFLZ/z4rGjIgi2C\n\
XdgsucZOakQDJmwU7MS2wZLEZIXHp8ehnsN4rH4DFje8j6cbd6JIw5G+aMSD\n\
vJFzeKpuHRY3bsaT9e/j2HhLwqlz2izGW82b8RTle65pO3aJ0vFGRzpU/vjm\n\
kH+v9Ric2SYNCxatboRboYJNxg6teGt9gu/GyAix9yGSCDNbqaUuxz3CESIi\n\
L2HwFJ+u/BbUVhGeqHoDDzcfhY4os97ahyeZ302HqZZ8SK/+ZDxYtxm1hilY\n\
vUacHjiOv9RsxojHhV4yJP5YuQpZU92w+eyonyrCA1Xv4rJ2GuGQGSua1+O5\n\
tuMYdRggNfbglbpV+EvdPsi9vn+rBa5d/2aMbIvqyhBzSsmKNiXeLDqH2Cyz\n\
DyyacJuom8hj++PJ+q3onDWjfbqAxvGT9ZuomCqzjl7MjNeb1mH3aEfcTvB7\n\
FVhSvxppMiGyhPvxRncOFuw9wa6ObVjTX4QJkwiPVa5AtVmXmOdukOXhr7V7\n\
ofg3XyzuNBKJROHzk/QhSjrnC8EXiDDnmtzOFxEhe91L/eB0+9mP2xtEIMgm\n\
4XXGLexGxAAJMCYd82HuR2OxJxJjPYJRjQkNk3ro54Lc3iY+KNVnWV/s3TQE\n\
PpBU4bDwIFImu3GM7JftkmokCw9g20gLjVM1XmlYjTzNVHy+iYwJbGrbiZ2S\n\
csq+B9uGahPeW4WSVLzZew6t6iY8VPU+hj2uRDOJtXX4e82ef7v/485msUgE\n\
E1MGFNYNY8+pdqxKbsLK5Eb6NGFVSjP25vaiqHUakzp2GvRLfFWCfj8GiRvm\n\
1wxhd1Y7ViY1UZErjjZSs61IasSalBbsp6yXGydIbxnh9Ia/GH9ilJ4o06Oo\n\
fhgHz3RgDfvEJqYIvJfaggN5vchvmcLAtI1xtuck1SdZQaZSmYmsy3C1fgz5\n\
DVKUtE2hbVAH61wwrhaY+C5MP9GHKsT8fyOCibkZ8CGnb0b70ATW1Q8iu0eK\n\
1VUDjMsKP+ud6EG3S4YldStRqJejceI8nmveS8LofZQYlGgmVD7XkcEO2zeb\n\
N+DguDAxGRWexYqWTdg10oTMnn1Y1pPHyLx4B58RHcBbvTkYoUH7ZPVKtM6a\n\
E53YpSjBA9d14q3/rBPZN1IqDDia3YHX6DozHf/y7mrC5it7qulZL+2ia9sr\n\
8fqBOiQXDmHS4OG9LG5h9WdH1wS2Hm/EK7sSeW9ms97CZaVLS3ZVY1VaG652\n\
KKiZw/NTYyakLnjqS7uqqcZM1k/gld3ViSe/sqcGm051oUKkhcMfSbg/MOv3\n\
dQ0SvLm3mkl3A1MI3WSyLN5agSKRbj5mHemtS2U9WHakkRpqVUoTXVtxtAE7\n\
Lo4wjvz85qhvsAAZVupwVjSJiikzwqSl+2a09FuG5hkDKkdVGNbPolM1O3/Q\n\
mN9LAkYPF2Pjh0NkfpmgdXrQoeKIkcXhgFDvhtnmQPGQHFUTGmwr6UGd2hn3\n\
bfZMjGLmUgU0dd2w9LMrfXCIRJi5TNcaRAgF46KTB9a3IdZU4q/VmyGd80Jh\n\
7sJjVW/igfpdkHn90FiEeLx6IwacZpwVH8HjTXsxQoQzGAlBMEPwqHwXpQYV\n\
usg6/1PlepTpp9l7MxYRnqpZgf3SdkK9Gcub1uJN4QVofR6Y3DPY0vY+Hqw/\n\
wIhRruaf+XhkZYngCcUw0DeB5fur8eLOKry6t4bGH6Wg93iV+nPJzkosPdCI\n\
/E416wZ1K48Jq9GK5Ow2LNlRwSCJzfdpNt9NLCYYnKzO6IRwyvGZhLSjRw1O\n\
YyU9agn/qE/xWV5mEViFtSe70DvjiI+RQfEkXt1ZwSCLEjFJGdhUobCH85WY\n\
X5UP48zVdjy3o4quMci8ka352izxdbBR6XVYeq0HpWMqbCjtRu7ADFYUClA9\n\
pUdGqxgvECUVKdRYVTmSoC690kncd7oBjYY5wpAH22tFaJhWY00158colsmw\n\
tVOO+gEpCZkhlAxN4dm8ZpQp7fH18JBeCcnGg5BXd0CWdhJ923NhH5Wgf0sG\n\
TEIaqsezMFMzyCOH2yvIxAiKIlechBcFGbBHmZ2fSixrWoPXu07ByRzX5tcR\n\
L9qIzJkROOYUWN+2hfjVJrzWshOP1KzB7qEKMMGuwiE7jvYlk8ZYi6V074na\n\
NXir6yzUPm6f3YC2mbjXe3iyYROea9xEYm8jHuXQkwju+HHwee+MCM1dk1i2\n\
t4ogwHQNBxtqfrY/SUywf7+6N955NxGkCBrU94dLxxmjOk7DVDR0Nx2uZRCY\n\
6GfKxmYn6UJ9uoT+vzFeHJ+C+5951Kt761E9aFoUpzKyMQXe2FPFyseb2XS3\n\
sKhkYMegnKkag24q6wb+NlvM/jqU9BnZ9YOsnFaqaXW8NgzGn9tWiYKehcIq\n\
jLP5HUyyRTcsqM36U/3XoU4gGUHyALffYtbuwhDJ0w+qenBGosTF3hFCzQTU\n\
FiM21Eo5YRUJ4khDPw60DWJfN5kovjnsbRCjhTmDtoEjzQPT09jTNY0j9QNo\n\
41clLzSJUTpji6POLenB0KES9lZIM4Wx5Dyoi65CvCuHtb7VxVVQ1UuuQ90X\n\
2VGqd2mgclsSc4pqpxoqjzVhqzNGj3aOi7ceCDrQpupA4XQjRBYlu4wfV38x\n\
IskDBhEKZPVo1o3Cm9hLcwtMLhVxGyEkViUEyio8xKnCeNsuABzftp/D0v21\n\
WLqvmtUzLAj3MDKrEq/tqyUq04xdZzux92wH1qY0Yind5+VZQnBQcVmNCtYy\n\
ip9sq5Pr8N5BEnO7q3lAfQavLSh2NVGbA+d7cDSvB0fOd2NDWiPe2EdF72DV\n\
XQKEDLhe2VuHhjFb4jA9xndx1/F6Vl1ydfgCqypf2VuLjZkdOFEgRnq+CHuJ\n\
F608Ws8/t4oFJjfGCPz76nGBunzz0Tq8vIcHKyeZXyewbj1JlOpoI4r7DP8x\n\
KoXDUnzQyc00akxWDJsc6JhUo3JMjfS2frxTMw6V2YgVZRISIzFYLCasqOiH\n\
zunGpioRpGYHDjaK0UqoXFs1zMpLyZQMOwiVqYTeUoWTBVNmvQgl86j0jPRh\n\
YNdFNoieTzaIkUMXoK8pR++Gk9C1iSA7kYmBoxU8KuORhvrUlfhL1Q7MJGTS\n\
9RC5kYcILxxYkvP6gQYcKxnFoHwWc8ToQ0xYEfp4/UHISOCfK+zFG0RJaGjH\n\
u5HpgpeoG9umXYlu9Dmd2JNaz5Aj/jG3UndTN1HXpJeNYogvPsL4sTHh2KOM\n\
LRKEQmkmKjOAd/bX8IyJhwpV7Y2kdsjtwcQkVlvLIGnSygWvchNLxrbn9kFE\n\
1NgXjMTbj3kDt8cHyYgKWfk9eOdADSMcOcnMSN7dLOjjwvhlAlspiTSGJvsY\n\
syYc/Y+R4nDOYmVJF44Jx7G8uBN1SgsyW/txpFuG9PYBkkMK6G1mPHO+CZta\n\
RpHZPIADvSq2989Quuw+OZJbB9FOhO25vFYcEkixvqQTF2U2jMsVWF7ai5Nd\n\
o3g6rwWVqoTWjM45MH4gBaOZhRjZcRj9u/PgM+sxsv0Epq9WY3jnCag6pz+E\n\
lHFzD7YIc2EMBD4WKTcteNE16Z0YUrvmDWOq8OiIHO8dqMVL86hgkq473Qdn\n\
KJbwlGNURFGJkBEqC4QANf2hZjSN2xICRq3UY9eJBry4AAEMMzlYMsEsFScc\n\
cmKhIFJONuLF3fPpXiJhcJTSzYXj0z0cidLrrDh5QUBIqlygXG9k5eEbR5sx\n\
7YzM1/Nf9DEn9v8bdpcb1cSKBowuzq8t4EfnlIZGt4lR1AhR/ZQ2FwZ1Fgxq\n\
ZzHLz7673B4orS5INGZYvAGoZ93UpEa0Kyz8zluyWkw2EvFmqB1zcAXjdsEn\n\
2cNQzL0SmFraMbwvm5UgYbsFxjayeOSmW67vWDbmdGxhzOmPEwFcKyw90kr0\n\
35fgA/JJFVYcqOGZIZfuxZ3VKB0wJ9qVDWim0mE50RlGtN+woLxX9hH/k84m\n\
po0cllnsyWhkx/UNC2THEpIdQqU7UZ7HasHKgzXXl0di/Z3jnTB5o3z9bmIj\n\
dhSV9lDPVM4P3vkOnbCH/u0OvSsOKP8cTglGoUtMSJNG0iownnmN3RjDLwje\n\
vgBXWu0cOsR2dA+7YHLOh6n8uFZmWu9SF8fC460iIvP6VR6T81WrxKbcASZG\n\
xHUnypaUXT92GGZ2vJo9XztxxLxeruV6Y0F5L5GU3F8sZUKQJMqz6XR4+wDL\n\
6BLpGGma0SC/rn6Mj/np3PYFkvz/1sSsVX0D8xaJo30WxOq4ZeE13o/z5kTJ\n\
MQRJgDPTjZ9LpIsyM+nsL75TuIgRn2Bv1dbrSYWQiZEpx+a0KaxIkZM96E9E\n\
dfwoUeIE0epMIWyBaKIxEfIjKauRffmFkH1tfxNGLYFEYwbcTmxNYtnGdele\n\
P9iCCVswEZ6JeberhV1sJ97ANj3HgpYeboHSFU6UZ5xR4e1913fOi2T5X+nS\n\
XNfZs3ojVjLkbu/1Q+8/7ZzEuUGeQWBmFzB9APDaKRvxenUS4ByeD0PvJTI9\n\
tZHY9JPA4P/H23uAyXVUacN61vYCXuBjYffbNSywtglLMAbbGDAmJxtYggNY\n\
OWfJliXZymGU8yhLozBZMyNppMmanHNOPTPd0znnnMPM+5+693bPjCwb2OX/\n\
9DwtqfvWrbq36j3nvOfUqaq5gPw4kRLnQ4nLIrq8kb88MA9QnGTHESUuO2uB\n\
kZVAz8tAF33GdpA+VD4+fQxJyZFSPHRJhrQ6J4cGNklyOV2OLWk6+GL4/AcM\n\
I5OxazV8N8W7va1liJOBGeWIKeS0GWdoRvmIAkv2FM/o9jlkd/bmDHOyE0ef\n\
RkKa8eA9LDvEdqpbTn8/hEWHqtAo986oz2HQY/n9MkbDeKlGMWMY2TYSlzPq\n\
2bP/r4Zx+pQUBn8EVM8C6qlvbeRHBVqAKvouPcc/HhEVTxvQSsashn7u/hWN\n\
x3P8La0/A3zCWSLuZvr+mFDmJSrzrFDml+y0eL6MswhooMZrCUH9r9GHrtVR\n\
mcYn6Jqal/d/5d6SWWz2hyXshrRiRH28F8ayzSf5I9qn/X+S7e8h6ISIcO8k\n\
ouT8hPQKtoxFAKWAm3/iigYCUfQNu3Cn1oKKLhfq6g1Ynawk0zFJxMKD+iEP\n\
wpNT/hbLBymtNeHsDQ0u5hvQIZ3a0l8qdqO6zwMhwwXiURdq+z2JM9Rt5gAq\n\
Olxwx6026Z62Xif6VQ/mUYlBI5PXrvXNAKnbZMbaQzPNHlPIxwo4B3daff2c\n\
LpgJ5jLc7OTnc6erSLvLD6vDT+WsTvZWFocfgchMOuB32vDmobIZIOV04cVO\n\
dszirPhmZ+XlvZjDt5twJP/HAI0Sctr/g1D0A1IOHj6D0UdIqyXUyC/H02+5\n\
5c4DLxD4SMdrigQkEDI0pKIqqejAbj51sf95KkO8QFs6VUa9nS8zyJ/giKEf\n\
Ev7pEU3diQCY9SaP65EzAlX8vwiNl8BUkIOYSwX9kZegO7sI6kOvwUfm0lu1\n\
H9amUq42T/luWFvKqSk3jNfWI2QnN0FSCGP6Rbgr90N94I8wXJgDQ8ZeMlTC\n\
eisBp1/gxqakXEeelBhHs7Q4mCLHigNirDunhjUwiepiFdZfUsMl4CzsD+Pc\n\
FRmWH5UitcyM85kquleCewO8+LDI7PHzUnLDpJDZ2XlsURw5O465+2X8d/oz\n\
0GshoiGFUvjOToLafUKCM8W295sOYSZs6clmGH2xKVjFQjh+rppR/Sm4kI7c\n\
nMbzlUTn0itm35gJhQUsenSgAt3EMuM7dk0Sizt1qZpM7BRPYl5cWtN0U/ch\n\
dNYNYf6uvxf8yLR1fA5o++VUNuz98KPqAkOk1+inrqVTSaHak2wrXdJ9g6Ra\n\
mU5cOe3acXbmAV+d4QKgOjG1LC/mB4wpfBOD+xNwG8uH4WYWvNVJ0KUnc76w\n\
t/4wdFfPwV2yDeYavjp3wQaYawvpaZ3Qn12AgCWM0OhN6M4nwVl3AwGZAsHR\n\
Qih3v0TXhICQwKA+weVyeBtYJj29uqYb3tamBPkKi6rgbb43tb9FLABfTQqs\n\
l7fAnp2MkE5IMvgCaSgfNh4YQ0q1g5cysspXs8gVPa3iUFtXpsHmaxp+roD+\n\
iPotWLhbggbx1N5kV8mKb0jRwENlnHoPNh4RYxFJQcVYED6qf5PwvUhA9vCA\n\
lUyoHGrHFGoPnZHiYpn9/VDLPLy3rnZzyiuBWnrgW7eaZiCDhWOXnWqFNZGx\n\
/RBX/bkL1Vxoa8oSl2DJ0XroSQo+I5RjsYc3ZjCKhwWfpxzpdXJYPOF/+v8V\n\
uL+YOpwnAdwUvhg9o7eBN8DtP6WfdxKl20qfLfQhnag8Cugzqfer+TIdP39w\n\
Gd11xPcsZAeiwkD3jK6mpv+DV5p1n6R6GqcUp7gAhvwceEq3wVRVxGNLfg/a\n\
o1vhZEiu5X9zF26EpYGdIOyF/sJSBO3E7iX50F04RggugfbAT0iO5sNWeYft\n\
RDkDyf+MiLgc2rU/ZmelI1BzBPqda4XorxeWHd+Dcs6zCOoc3Hh7br4LzeoX\n\
4bxzHtajr0H75m8RtnsTY62TubB2jxg92vhKuUcxMmDBqlPKB8K5vkaL1aSg\n\
7SHEF9YNkCu86IAMOirT22HCW+eUOJumwMVyG4aoqo3nlTifrsDRfOHAqsH3\n\
RfOs94MzI6A7svsRRHw57odQWdMzc2aBue8HajDuDCdej9GoU2erpinqhzko\n\
Lz3eDLU9CG8g/Cl4/WEqyqb2/TynSbggQY8bO5OnR/A+wnvrBMsVx2uRUiJC\n\
46AeGpMHLl8YQTb1PxHPLvh/CHvpJb4YGRRvM6+TG8lodHyX4M8+RB/an+GL\n\
tpD/Z63kdXrjx+4r8y2+TPNnweghAgN0/Ys8162jR23/HvkqmwH7CI/4f+Ms\n\
nK/jCnSpJ+FpPgvNieUImdVw3FxLAnYN7tItUCa9joBKCVfhW1CfXImAvAWq\n\
rU/DVl8Jd9Ve6FPPwHqVqEL+ZQRGq2G+fYId5THrPthHx6uge/slHvb1J2HY\n\
9zangSPjldBt+A70m34AWyEjPw4YN38X9ooqbvnjhFsLZ/YhBLVTe8VrCfZr\n\
GOx1U7CXjtmwbhrsN13TwisYxoYaHVafnwH7MZEVS/fJoCLSk5nJw7ur24zt\n\
19S4nqPE8Ttm9PZZsJaqdFBnjg7xsNe6pmB/kGB/4QNgP5ewsz27D4FpsO9o\n\
H8Hc+yjoogPVGHdMwZ6dyLvjRCW54lPxigVJ97DiSCVWHa2kp2d/P0ReWzl2\n\
3xzhXIF4pEEmUmB1Usm0yYeP8/MlbP6e3PSlB8u5ejacriPa1onUUhEKmmTo\n\
Epth9/CeTW+jiOH+7+LGRV1TNGU67Jna7lmT0PYhGdBEDLnjj+DCgSx3nts0\n\
jkh2J2nrNiLZ3jEqQ8jteJ2vKlHGQr89xpdh31U7eMgPkzXwsi2oJ3iGbe9l\n\
K6WEV/i/3MIuW84KKHb9Fn7tKJyl+6E98Qb0V7Yi5PQh0J9LtHg5zPnn4O3J\n\
hSl9HfGWRTBlb4Y5fQ2xqHnwyqWIqFthuLQUulPz4Gyrffivg707cxWMp/bB\n\
33oVum1LEHWbYNr2ApX9GQxbSZq2/x76d34NT99gAhcceTk4hsxmVwL290o0\n\
CfLSUKHBosMy9Gn4cRSR+l64V4IOZSgO+9JiDZYSpBXkuW0/KUFWO6k+4jBv\n\
HybOsk+M3C4vvNTMW4ck6NSGIRbZsGSPBI3j/OrBCW8A7xDjTmt2/02w7+z4\n\
62C/U4A9B91/ZcUYsHYVYVP6AFsIn1j8Nz6qwtaTFVy+AbmbjwhzeNzkLiMx\n\
QnoKg308RWXFkSpu4uZKbjsWcJPLfwu+vzod38IfAlZIS3qV9HbbT+j/Xn4F\n\
mk/Q4bVU2/h5+q7l17iJf0fApLeVZfKnTTNKEger6CRf5ejL9J0wJM8WylCd\n\
yi18mZHTfBnNXvpOANPXCY9BYyNdTq4h/Wbuic8YhGRlUO18HUEjHwaZjMSD\n\
cw/zsiP8ISWbmLedvv0o2/wtFjeGCTzH5PXQbXyZLebi8XxgM7Vvh3Hj83A0\n\
tGPSPQ79+hfg7W2HeeeLsNzMJL/BR1LSBd2ab8DV3ScM+Be4DrxTpMHC/RKk\n\
V1pwo1CHVXtGidGqYPFPovaeBnN2jpJal+FamRUmcxDJl6VYlyxHeZcDBRUG\n\
rEgaQ2q9A+IROxbvHEM3O9eT/LGkM+MEgHH0GyKcK5mUPI6LFQ6MEKAX7hjl\n\
6rjVYMPVXDWx6DHUiIMfhOcd9+G5q/Mv43kiHMCBZGIvBOLHEpOAxdiUMchB\n\
Ob7+0W13IfNOF1YeuMfhldETLuGBT1T40DSYshmk2Xv+1ij2A6AblhKVeIyH\n\
aT3hoZ4oA9ve398ihMa+zKvoGrpmbGQ0mNzErwnXvkqfT/P/b3+J7hHCbEHS\n\
z11fEcp8jQ+5sf93/GYqzBYY5MN1tYSn7t/S/V/ny3S9Sm0E42F1doiEq+I8\n\
/GodU9QMfzxyP8ltp+hMWw/Noq/CdicdnvLjMOzfDH9nBtRLXiT2wpyuSdhP\n\
/AHGcyfgb7gA7arnYUvdA/O+X3O6NuIWxvpJLipb02TGkVRivfl6VLHT55od\n\
YCeoiEV23Kq3orLBjH1EohlD9jqDyC3SYdtZGXZdVqK4w8XtdS0T25F6zwKn\n\
sJVye4sF6RVWuIL89642C0o6nVBqvcittqC5245TaUrsu67C3VYngrHJ99Wn\n\
bOL4zZQuuCNT+GtoGiCs3M+eZ+KPcwTP844gp08/wfAjzLkIuRQzYsQHC8am\n\
JUl8HBaTA5VNYiRntmDt0UosI+6wMIlH4Z8I/AmwsjywKcA+8jeB89/eC84Y\n\
AUq1jXgsub5N/ylE58l+RvWkCw+xSD7puSwy8GsAB38IKEevNaQfRctIT64D\n\
1HQ9HM8Z4PM1oTk1dV1zgwFuKuIvoTEkVTw4BxgiVao8zdaePz4de//MBUDc\n\
t3ZAs/wZuGorEVb2wdfZhvB4M/H2ykQ8IqLsgKexjPse7CuFI3MvnIXXELG5\n\
Ex0xMaWBp2UzT844HDccmWCrDxPLL+iWKO/OCo/0gHAXCwicboXZH0tgpaK6\n\
+wGeVjUk07HC4hrX67jp6ul2keVS5DXJqa66bnb2XF27lMtJmR7hZdMSx0vH\n\
p21L9jHukGCfPwSj2YWRcSPqu5QorCe+UTKAU5lteOd0LVYe4SHFnpmled0/\n\
nf1X8c3LvdMi4Q9xmzCggxRM289nPRVXGYigT18PSyiMCcJB+dgFpPcfQbWm\n\
g1+E6RnBzcFjyBhIxpBdyXW91FSFjP6jKBDfQIu2ia1vmOHP0GBp26Bd+mU4\n\
SvIR6LkLWxa3ueBz7zcwJDfz91ViyBScEd7Oymp475zJ4QZo3NGEQiireO8A\n\
LjhQgWFbZGqPtbAX79w3MCzEfr1elegG7ryPCT7d3ePjB6d/WIsLmU0skvQ3\n\
z40yxbT+fDuLLkwLEjrJgSAm3r2UmfevJxoP4GrPPoy53agT7cfpHuprQxOO\n\
NixFu4HckPb1uCEuRp86D/ub34HI1EnX5qNaXYXbfVuxu2k7s7/3jQEixFZL\n\
T8N+K4WsTwvctUVTY/DgaQtShijotwkw5cvFAl5sP1HBZQ1ORdaKseYSU7px\n\
xfwQBrslWLBz5jw3m7bI77YIGpMvZ9XosGJ/yYxy1G+43cnP1f2bUG4yEsR5\n\
YV76b3W2OOE8XA2RJTQFfvbysQCLbwvr1R7iljcIKkWojx+MtL4jGCefI7X9\n\
XXRb+X34u8RHcak3Gec63oGRS/OYRHrndmQPnca5bv7gPJ+7D5c69sCfGIwf\n\
fVBvk6U4cmeUsyrx3jbINFzq6PTeYSrkwO1hrly8t91GM9YcLL1P1ZTg4K0R\n\
rlz8dJT2lmHMnSEdZDL3VaBN5RPe+B9hNNrRP2bEoIT/sP9rbf74vNBw5yh5\n\
BMWJLLK/NAiJZIidLMjPJXgKB+I8jElfAA1nOlF6cRRuT2yqz8OkUI5D5nEi\n\
u3MjavQjXH/WDychdTAFZ1o3QM7tWxXEpbbNyB+5ghNtB7kVNAZrFZLbdk4T\n\
gPiRFBMxN1kNYbcr8nGjUW+i/0J+OVyOAQRDzoR0TpIF87oG4LD3kRYIJPKU\n\
Q0aEQsK6S/I4PM4BeD3yhJcwQa5yLBaIL36IkVPPVubzzUapVQ+zW3EYPggI\n\
LGrHkt+UrujUlDHBq6Cwg/GYRI8yMUmr1yZK8LYpgpS0mVPLXGbCoRqMmENT\n\
mQlU7vzV2vtsWAmWUrt6fywBhoLSbg5wC/eVcR/G75PvSeNgUA5LsWjv3w4G\n\
FotfmdwMAzUVBwNbPaTt06NoaxMaiw1xMNicrdhZ+wZyJfkQG+7iYOMqZA8c\n\
xoHGtZB5TagXn8KRtq1I69mGI53HYfObkdW5Cme69uNk45+xvzUJoQQYeHXy\n\
JbaeD6OdT2FoiD9ozjS+ioTjpwjwh7HArHwX7XWfRXfzt9Fe/yQ0+layh2aM\n\
db+Ajsavoqfl2+hs/i4cXgPCnkZ01X0Kg4NrEPANYrj9W+hsfA6dDZ9BX+8a\n\
hCIxmBVbMTSYJKiXMCTd34Rcze9MGHY3oLf5ZfgCwQfBYnr2T0qNkisRz9Zx\n\
mS3cZO6MRBSynvP2V6GfrGc80jU6MM4J7Ux9Q/rh9giX6BSHmXxUgcV77tM3\n\
NOS780a4/aH+URj3mqp+bnKYjft8YQ7mzUvdLFkjMYM31iPGwj3vjQiLnQ/G\n\
xsPTnutEkYR7rjhcyR/HSKkMirH4Aq/HYB42oO7CAGqujEDWY0ZP7ijEZK3G\n\
G9XQKvnpJJ/egYEKHRcmi/mD6Ls9hsoz/WjMGofVwh9o4JRb0XRdhPERPllb\n\
ViJC1pYueIJxh/6TJP8GnG5Zj0ryzNkQmp0j6NDUwxgQzseYZAtOOtCl74Q3\n\
yuuYSMSJUVM3+jV3cbZtxzQrEAdh2NuMTvIa21p+RiAJYKzzK2go/yjVrkTU\n\
14aOmn+G2sCfrW5R7UVf91xYjdnoaf0+vEF2LqAPox1fg2j0BjmWGehueYEA\n\
7Idq8Bfo7liEMBHgaEiGobavQWsagEm2Af197yZAONbxOMYVVdy3kKuGQPwi\n\
vH7/B4GQ6RKWvtml9iYSB1kIIYVoEVuY8NA00GzPGmD+XgKEsVAAB8/fn11V\n\
Rj5/GW616xKg9ruc2HOmkpvJmEqlK0OlyCFoJb7cUPtI3BJNgTWpHM1yj6Cr\n\
p3Rn3u02zN45FcdibtjKEw0wBic/AIwP8/nme8pwvlLOlvbw2P4c3HIjrr1x\n\
D3kH+TUwMZcPBW/Xo/zyGIYIp/nvNiJ1ZROUEgfKk5rQWcdPCBm75ch+txNB\n\
wnP7hU7c2NYFUaUa1Ufakb2rFz7i54PX+5C1rRMall1ErkbTyQ5cmFNNMuye\n\
Wkg+idqxkzjddZrNEyUW6nqGkTVwiZs6ug9qds0R0lkvE3R+BZP+LvrbfoKB\n\
9l9CLCVG7shHe82/QDJ2AArJUXroI+Sjn0Mg5IbfPQid4iBGen6D1ppPQalp\n\
ht+agb7OX3LrmCWdT6Cn83Uoxo/R5wRko3tgNg/DKH8bA33bp0HtSYJajQC1\n\
WnTV//D9oBbXA4wxrznTiCG9V8gzfxgToRBu5Xdg3s4ZOaBv7LmHytGZ6Bjp\n\
JwK6azo6hCnbvfeQ06RiicXx7HWP04Wj1+pnAJg5TG8J+czxUIvTYMDaAzNZ\n\
Fiu38Uo7DJ5IAnAy0qKr9s0sx1Js1pxrhyuKBwKODwQ8wgkEy2nbm9mLHrmD\n\
zbMJ9X4eg1n9yNvVjrx3W6BWhxBze3FrHetMM7d8V9M4jrwd3fRqUVQebEFP\n\
I39OhalXgZu7e+AwuHFzTT2Ge5yIkb/sM7rRnS+H2xvD4LVeNJUbuPJ+vR23\n\
NjehYHcLSq9Ip5168xBnpUNs981pVojL0uI36ozjjo9EfZm7JOv9IcbGsqAW\n\
vU74+x4GehbBpLuE3q75cFruor3qnyEe3QmV7CCkw6+hueorsFt6Mdjyn2Rj\n\
fwyZ5ABMxgbEqAmf5TqHPSZ0ko4voqvt99x9Ktk+9NR9HCMjWTApNqGnZ2li\n\
Zc5YxxOEPX7HvrC7KY69We/PwT6MhSzks3cqprT0SA2y6+UwurmzzPi3fITs\n\
QhiDIjUOp9Rzmejzp6lKRpu2ZQxwWTKJHFjin+k5zdwavPjqAwZKNtuUlNWD\n\
Hn4dw6x4/WxSz+XyorZllFuXOnvXTM9zzt5yNIw7E+swWCbUpdQ6jv7F10gw\n\
Vbw5pQ09Cidb+Btftc6dZOjxobJehPWMQuyZevQ3dhbhZJl0xra376Vx/4TF\n\
+/mkocTcNVsftu8eNp1rwPk7/cgoEyG1sJ/T7ny7/4mYz4+7mxvIj7Cg9Wwn\n\
qm/xm6/L6mS4/W4zbu1oR/6WRuTt7CGgRXggt1hnANmudyF/bS1yt7bh9nYq\n\
v7ONhKKdzL4fQ2lk3sv4k5elRSLc3D8AvUiH7A2txCVjj83E50RYht7Gz0Fv\n\
HYNDfxL1pbMwQliN+gfQ1fAMkYR29Dc9DrEkg9uqRDPye3SQDvU6utBZ+zkY\n\
yKyGA8zEfhs6yyBcVEdP24vwhZwwSt9Ee+OPSbyM8DsrqfzHoDF0waLcjPrK\n\
j0OhuEMOh5tw/Fm0N/8KLreczPw+tNQ+B19wajvf96wrpB5feYzFg+5NLfMS\n\
Fu6tOFaNo9ndSCsdRmbZMK7c6cHWszU0SjPjRgzTC47VQ2QMJJZhBLwenCKf\n\
gGUr8+UeFUB9DxvONODs7T6klgzhOo3o0dRmrDlczq9hjK8CeZjjnuxRz1cq\n\
WIgrXrNMJCNaOX012Ef5tYT7yrEtpRWphJM7DRKUt8pQVC/BjXIRzuW0481j\n\
FdwTEL2djvq5B6rQp/VNSdV7fP6HudvOFA/h6GXOyUmsu9zDT++yqbBXtxZg\n\
x82xBDLN3UpkvNUCu28C+uZxZBMJZGkSsnolxodIFXtCGCseRi4ZbYbM6sPN\n\
KLku4zw/c5+CVHMP3BYv8tfVobPahAjdaxXpkbGiHlpdCKKMfjRVsrBGDBW7\n\
m1BXzB9YV0jS0N1sFZAZfylzpxi9+SMIBicSx8r4HbfQ0/wCoSNGXkczuhue\n\
JNSJOAs72v0ckbxO+Ozl6Gt+gjyQz6Kr5cew2Ma4SJ96bAl5JI9zXslg/yZy\n\
bZmG/Sxp20fJC9rG0VUFad+O+v9AB5UbHT3JdryHRb0fvW0vo7vpSShUNVAO\n\
/RGDPa/RczxBHtK/kGZP5lIY4htVP2hGaHfuADp6pFi2t5jTM/H1pPw0TUli\n\
51wWpeeW3MdtK3kPR2rRonAJtuZhIodunLxeR00UT61bjC9cLU7UxM8LlSWW\n\
1LJh312K5BIJ08eJJSWTEygt7SJXpmiq9IeFhdZ8zJ7hKD4x+gY3F1A6fZ3u\n\
n3aUIrVBwzTl+6PxES6x93KjBlaDBe8eLeMocPwtmX5OyhdPs55PcFa28Xgb\n\
8k+OcWYsbHcjZ3UtRP0ODGaTYt3QgvZcCUrJQucfE3EnclYeasblhbUoTB7G\n\
cLmYYNpJsJjEGCnBzHVNaEofRcGWJhSeHYVBZMDddxpxK6kb3cVipK1ogFLB\n\
p+31XOtB3oFBRpD+fSYk7SI5ClbchmzYLkDyY2QMIxz8pv4EE7F9FgqJxz4m\n\
oh6EgmZEY9HEVhvcSo+gEcGAIRE+celPobv1uwgIx81xZUIWhMOueJ4E2wuc\n\
O2E36kSUJY+zvcFZt4dtVMzOh/vfu5qfn2rv52hrf7eEW3P4xn1L7OPZH2vP\n\
NqNH7Ykv5A/6fEi/3c4lOLFk1amF/I8kbllCXlFBp36aO03mm7REaTnb1KEk\n\
vmqVrsXvK+PANZv46IUKGTfLmTDj74HQP3IQOl/LLSSARqbFpqMcUXz4g1BE\n\
hEneooFOFT8PeQKqDh20Ch8ZvjAktUoORb1lajjsfLa9uscIVZ8Z/fdU0Els\n\
kLSa+FwUEhU13cvKD1TrECBvyKO2o3RXCwpODELcpsNoiymRKu81kPfbaGDf\n\
BRR9WDBnvaeqMT5g5aZ8h252ofliK0YqxyBvVRO9cxER4F/SKdGh7UIzWi93\n\
QD/On7Jr7JKi6Vwj3dMOvcydiOiHyVwbdbkMRUL0/mOore3BK1uLOFLC7b6x\n\
rRBbMnohJKdCozLheGojZwoFyeYQEFdM8R0aFuwvR/LdYeic4fgsEdPg/YMK\n\
7LlQx4WyhK1ChBQMVsWHBF+jNLFvyNLDVThfNAK52Z/YckShMOJiViuW7Svj\n\
FAyjgXTPIw+qgk2gk7lMyiCWKHNMc26juJBVh99vKSSo/GlHMfXzH9+9i+Qq\n\
eUIijTozDlyqi+c1xVcisW0p9t4WC8PCV+cc16P66ui09JGHIMoaJE1vEqRP\n\
aDbi40LyU/cKl/4FvSerIRfZYWgewK31ZRirGsW9N2+j9FArrKMa1B5uJCPl\n\
RNmGO2jPHsJARjPuvFsBZfs4Ct8uwnCtDCM321G4pQJOR+RJoc9NBhsae9Vo\n\
6ddwn+Y+NXqldi68PZWTEcXwmBZXbnZi3bEqLDtwj64t5ORt8f57bOkONp5t\n\
REalGCOaqTWtk241vKl74b64B6FxffwYzFgkQmRQh9zSAew8V4tVwiTckgP3\n\
6FPOVbeaCNehzC4Ut6mgsQWEzvgElxKi0VhRVDuCgykNWE33Lj3A1uaXsQfi\n\
/mX1rDhciTXHa3AgvRO36qUYUbtYGu5012pgRIvCJim9SWkLO1CjqGkcfWou\n\
8DQrftZdJBhEQ5sYu8/VcaluS9g2AETGDhSMs31Subq8BgeGqrXcktr42EZD\n\
MbL8kzPGNtK6C/6a7A8aW+mtJjTkjnPo0jcNouJwC2xiLZqSW6Al3Vq8q06w\n\
CVEom+Xou1aL4p21MIyZyPZo0J/fD7st+LTw9H5/CBpyOofHTRiij1hpg9Hu\n\
RygyIbBTGiPLAGwrnoF59tPwNw/HT9RhS71d7gARaydkGjvkOgf0RMK8Abbr\n\
rqB7HuWmdtyeAFQ6O0ZkZgxLzRDRv1K6xWT3EV9nZ1hPfloAEjtezmx1Q6a2\n\
QaV3EiWMCKtAP4VJv5nLqo8JZ2lyKUW8KPDrloK8rgK5ADH9ECa8TqJ5Lkx6\n\
rIg0boW/7CImrBLEbNqpmcAJ8uYNQ1Snginpj75Pr99sQuNNbv0nLN1jqJre\n\
613EBvY0JHbMD3kDGMtrxO23itCV04PujDYUvlkAhcT5o3iPWodgX/sCLAu/\n\
A3/bCL8F3Gfo5y74Ln0PvuxF8F35MQINdxAl98dfmcbVPGkhkpn134g59Ajc\n\
+DG8134HX8Yr8KVQNcVHEGk7AM/Rx+HLfAXe888j2FxI/JPo850/wcfKXn4R\n\
/oLt1CcTAqtLvGgPeTWyYRvGcxvQkMPDy9QxgooDzbCOaVB/rBlunQWF625j\n\
tMME2zD5C5vuYbR0EEVvFUMrptHsHMHtNcUw64NTBzmQAyaRIGSO559+nJ7e\n\
Cr9MhojDQ5YoSIPInQqNmMeTOGkn5nQgbLZxh6/HvF62WiORf+dlx35Gpsng\n\
hxExauAdHeXI2uRkFCGdFlFfCBMBMreB0NSGZhMIqeXw9PfBJ1USNOMnfb1n\n\
SF4S5CNgc8FIqtNIqA2FJ7g9yoKeIGfu4tWGnG5oemQYbxiFrIOqn3YglpsM\n\
gLxdAkWvEk6TJ56zHbA6oeyQQEk/e11BbiMyrtqJ+HZon0FUlIlAdRa3Mi86\n\
eAHeqwsQEV0jFPNznJPmNvhSf4moooFG+1uImgntLhF8F3+CiEpHaNhFSFpL\n\
CKA+lOXDe+U3CHdQPSl/4o4rnvTIEMjfiKjJcj8aJAV90Gs80Nb2o69azTXn\n\
GFWR0SA/W2tF/51hLodV3yxC6aYiFGwoQk/pOLcZtuJeP0rfKULJ9nKMNesY\n\
P+Q74+vw1N7C+KI5GF+5FOKFC2C8U8svJOyvhYR+lyxdAumb6yDfuA66jDrE\n\
rGLIV60gtuPAhE0Kxeq5kKzbC29vK5XZioCJn2uYsMohXzEXypPXEmzW21YM\n\
yULW1jJI162Hav8OiBfMg7VVDNuVfVCfy+ELEou2ZZ6EeN5sSN9aA8nieVAe\n\
v4JoIBo/2I6tVZ/wODHhtlPHebnDQOLHdcyEzaigiqJUzpMom9CjAS9fD/s9\n\
NhnnEcwRnQwG6EFiiVPA2LHorOik38fo34fjTxIh/u118U/icXG38Nceg6qq\n\
C7eWXUfWgqv0uYJCYsvNyaW4vekWLE7eFTD3ilCwLg2Z868id0U6suZfIecm\n\
B6JWjdAXQQxl1yJ3IdWx+DpuLL6K7CVpaMnqRzg6JW+61n7cXZOGjHlXcGPJ\n\
ddxcdxN1RwuRR2TDqAsm8qVJ94ZbDsOf/lt4LzB9dBuxMULwvauCPmuH7/pP\n\
EXNZECyeDV/aawiUbob34kuIkrKJtO6AvzyD79SIBf7s2fDnLiS0v4BA0Tv0\n\
2YjA7XWI6mUzEfwxKIn6mDRebk/y+BGRXK4o4SOgt0FcPp5I9GbZdWSNEzO5\n\
7HuM36dPGOenEDWKIV30CrQZBVyiqLMgBaI/zoGPTJT1/HZINuxCkITa134P\n\
4td/D+3VKjIpY3TPPA6+oaE6iGcvgIftBqfug3TlBgSE00891TkY/eNvMLpo\n\
NXxGD6emdNuXQZZ0ip4jhpCsH4plr0K69xi3laQ5eQtUJ1P5V3LKIV0xD6aK\n\
Dk6UwpJmiOe+BvuINoHRCdMYcaxdsG/5I2yrf0S2/PuwvfXfcB7bBH9tLQPY\n\
rPihfwk8L/oe4XkYodZbcB1eQuVfhu3t38F5fDMCra2sLSF682FMGKXwpu2h\n\
+v8btjU/gW0D1X1wLbx3sxFzB+Izl5HhenhStsOxZz4VfQ2OpOXwZFxARGsS\n\
up7hnmzD7dPwZiUjLNM/LLQQ0wyR+tsO++Zfcy3Y3/49nEfegq/0Nun3aOLs\n\
nIgHwXuX4dw7F7b1P4NtJb3omp/BsZdaunEdUYdPeOgvkPVxoGQ1icvSTPSV\n\
j3IcuDbpNjJmX0bum3kkMjESVDfKN6Qha9kNDDfISYE7iWONoWxzFrJX34Td\n\
FYasqAnpr19E6ZFqaEcNMAwrUX8gH6mvXEJnKb9/kVehwO0lKbixiuqpl8FM\n\
/lXn+RJkzr2EzJV5pGoDcZGJyXLhOfVdRMYaEFM2ITzSiZj4GrzpG/iVgIZq\n\
+K7+lnMiI92piMiGEJVWkmknkVGbOJHx5e0V1GI7KftfIFh/GN7LvyIxGecO\n\
0fSefZ5wIpopMg9hvLAfOqV7GuyJuKrNGLgrmpYZ8xT8nWUYfYUYipaftWVp\n\
sM6qSoQcbuh3vwn1hbtxwYJ26xpoLpfzorB4viAK9RDPX42QPYaYtl8QBeYn\n\
R6DbsQ6qE1eh2rgK+tv8JL353DaIl66AvakdIasNFtLe0qTjnAEyn94K1ak0\n\
QXkFEFDIETIZ4GqshP7EHozOfp0cK6OAr39HTNUGx9vfh2XOV2GZ+xSsK38I\n\
27qfwrrkWVje+DIs856BK/1KIsWcE4d136fr34V991xYF32dyn0V1uUvwLrg\n\
ab6eBc/BlZrCUkz4Zh5FpL8Ejrd+AMvsr/DNrHgR1mXf4ZuY83XYdyxCWGuK\n\
F+cOe66+OPUU7Jal3+Frn/01esqX4W9pS6THOMdgW/JNmF/9BnkLPfFawq05\n\
JLrfozv+i2p4mhr9AdXybaHRp2DftxZRizMu6Qg74Tk9H9a5X+Oek72ibe1P\n\
SWhe4Kughm07V5LedSbgEDDqcHNeCiqu9kz5Pw4LStan4sa6PFjdRLDMRhSs\n\
SkdLkXhWPHF1NKMaaXPTIG5RoGpzOnLW34HDE4tXwXh6zc48lB0i0FNfDKVW\n\
IPW1FPTVqqZygkI+1OzOQcay3OnyMmFqIcr8IoIV2+C/+l0E6nNIhnLgOf4l\n\
UiSr4L/2Anz5SZx7EMx/lejyHATLSDdd+jV1hptI0h4q+1X4777F3e8vSCLL\n\
SvQ645dkapYjkPcqyd5qTPhDcXn5vNAZPmIYo68th1/vEV70y5zq1u9eTzJQ\n\
lJAB3e51D5aBeavIZEQSMsD+H9X0QzLndTiG1HDePA3xxr1kjiaJMxtgSbsA\n\
+ab1kK5dAfGcVyA/dGpKBk5nJtpzFFyFZMEbxGQWQpF0CM7O/mkq/jHOa/Kc\n\
mEsY+Trh+CV4i28holZxvDw80kqWej2P7QXfhr99cKYcLHoO1nlfg33rfPjr\n\
7yEiFyPUUQznjv+GZf7TnPx4K+sSccYJXR/sq79D9xCi179KnkwxIko5qa1B\n\
+HIPwbb8eXqOr8K+523EglH+tk8gMlgM22KC8PxvwL6LRqG5CuFxEYLVabCT\n\
XFnn06Ov+B3JkLBoxCWhZgj6c4mF1ffF3zQ2Xg/bsme4amyb5sJfV0FvqkBE\n\
0ktA2EXS8RzXuuPoXsIHTxJCNZe5N7TM/w5cF44iPDpMPWOjkRlDoPAs7Kuo\n\
mTlfgfPSBY7cxUlDwMRE4zIa74zMir8GQ0Pn2SJkr8yB2RHhCEgsQnaFnAjm\n\
WKjbx9BJ/vnt5dc4OyDtlOHuYqJuB+vhsnr+AW6ji8TDY3bBSW/q0LOEtjCa\n\
j95G1ioyUbZIonnJzVpkLM1moiH89hjZih5SCqfJ8FZxvCc2egX+ouP0PQ/h\n\
rnQyb3xAju09HxnIQrj9KrnCfAhw0q4gF1pEmiwT4b4CKiOcBhkwI9KbQb8V\n\
kUwEhHirIBNPISzthPjPrxDL5g9LjhFtUu3YTnbEBMO+DVCfL5ySi133yYWW\n\
2OJoM28byLTEdAOcXIRsITjvnMHY8k0IBycQkbYTlZpNet2EEI2kMbcI0TBb\n\
BhSC+exWsg3HOLmwkN2QbNxDJDREA+GCbMkcqM7nIhokumeSw5JzE2F3MKFh\n\
JswDpPyeIcX3DXhKGh6OK+cJH9wH/gDLn78G19ULgjgM8+Kw4Juwvvkqwjpb\n\
XAtPUMe5dr5MkkCI37SEyCK36Txx4I2cxFmW/RLBYXm89nBLBtXyFMx/fhre\n\
8ia+b6LU4uFXeAF9ex4iJnd8m5SYrJGekWRmDj1MXu6DwC8YrjCZ+aV8Fat+\n\
h5DCkKCDwcqzhO6vwfzGsyTfQ5z18ZycDctrT8J+MIlNgEwd9V18hKThq0T/\n\
ZtNTRe4He0O+SOi+/8NV05dyj8B+gwc72LpGPZpOliBv6XWk//kSMsjvyH/n\n\
DudveHUa3Fp4jfyLVKoxd3kaIT13WRpylqbi9pYCOF0+NB3JQw75FHbv1LaA\n\
usoWZC7jkR6fHomNpJBTcZ379rmZiGSZxsbTOzC6cDEMV65AuWkZxlZsJrbi\n\
J5K9kjRnfgKR2i3LCaElPCKXLoazpxeG43Tvn96AhvxF/0ALxpevh5/4nHL1\n\
G1AmZ/MzLjEPVOvnQ3n+FoKjLRh79fdQHT8DU+oFjM97HZoUfptT8+l3IfrD\n\
HyBZ/RYs5VUwHNuG8be2wZyZCsXb5BOv342wLzqFSH0fXEdXkn56G2GzM0Fz\n\
GSIP/ZGz2o7zB7lH4BH5Amf43TdyE9w83JzG4cuy5PsIiA1k9U1wvv0jDhiO\n\
s0ceiVc5GYT3+jbi5EvIHvBPO6HvJleBachvwnO3SMDEx7mB9l5cSQLxJdh2\n\
72J4IQyOvweDk04pHIyPUFOutKvxJ0LEBc/FTVxTvvp6Bnf40qnpvUvha2mN\n\
J1oFS44SSgm963+NiM3//sh7jEfeZR55jLaTM4emg3lIfT2FKEUlRBUjMMgs\n\
3BGnnIo3m1Gw5ArytxRDTYZWM6CCZlAFbb8M5e9m4sZ68nn8IXQkF5JOvQGj\n\
MZhA32hWdULPJtaB+UyI2S3T0cdf+hTMXhOOD7Vg92AzdtFnx0AjzkpF6LEo\n\
kaqUcaeeZMuG4Z3kZTZT3IlstYbUfAhZo61Y1VaGDd0NaLc7hcDxv5EKdsFe\n\
kAP10aPQX02DT8XnDnmbquHqlghoJpmm7+5+BdF+EaRLFsE1MAxzymFC8xzo\n\
M4oRNujhamkn9aKDvfQufAqL0KWfJKQ3wVbXykVTfL3NMFw+D+050hvFlQh7\n\
+PlBPz2Xs70X1lukwqpbubXB1rw0aE4dhz41C0GTMCH4CX4h57QlQ2wrmgmb\n\
DsGWu3CfWALr4mc4XuzKyBT0a9wLJUY2II9DZ9I+wv88/9vwVfVi0jFEDi3j\n\
yc/CW1AdP3NkxuKktmxYF5LaXfIiAkMqQS4+RnZOSsSlmojYIH+o4wOUaExB\n\
9GE5E4Dn6beeqfGetp3eP7B3i6+AYadQRhiDytgDG+MJJHg20jex0MR7eMIU\n\
gD/xXgCHfajakoZb75Sx1MeEfurPrEb1mUYEQ0ECeC6pwRvksXnjR1sE9Drc\n\
XXEFd/fWcrENVWkL0l+7hKbcoalNaIjklW/ORMZyjkbP+q/peP0XiIzD+PLd\n\
K1jZWYO9ffXY2VOLc+Ih5Eqa8NuWasisCrxRT4NGxXvUPfhi4TWUmszIGKrC\n\
dypv4YZyFIe6S/FceR5E/uA/C+olqu7H+ILZ8GjIxI+0QLyAqK+LiJBLS2Y4\n\
n/z2qLDhy//hmHpE1Axf1mE4Dy6kjuTtrIX5KeQQWTfOI95nnYmTpS8gKDfM\n\
iquzyYCO/K8fk4Yk1ZVPFEPewBPBhc/Cvm0uXOe3UlnX2XcJVK5zW+A+uwme\n\
zDRuZMP1VziTZ135Y4R0dj549+gDARLtziHofpNjxY7di1m1fK0P03+p1jOb\n\
4M27xch3PFQ8YRyHv/Ay3KffJCL7c+bxEQro1QgZlkXkqtQ0CjiZQkvenEuo\n\
vz0soOXzHFp6L5Uha3k2GVr+MNKO0wVIn5eKtpweyNsk6EypRObrF1ByopmD\n\
gnVgFLmEupy1N9Fb0Iehwk6UbMhC6uzrGGrVc28TcTtQ/k4mOWrXUHexCQOF\n\
3SjfkoPMNy5zdJPB5ROCfmCB9eHcFrRdbICi1wC/2QpJnZI6MAZZcTdaL9Rj\n\
IL8byj4zF1QU5bVR2XoMV0q5HYgV1aNwmITQUEKwRk0ivFB+C9JAPBj3cVTI\n\
W/BKWx1UdjVer72DLosOf6pMw9vDw2R5fPhDdQZOyeTwRiKktB24OtYFkdcX\n\
Rx5HQHfu4CbF2Y693iERW2dNSnEIiu1J5HT5hQ2yHuXQ6EleSkP6Ld71foM5\n\
0t/gggT2bbPhvZWKiNGa8Eing0+qT2AvGMfeU3Dn3kRM08GZUeti+iyimhc8\n\
Q0CwLPgWYY+RRMtsMqNJ23jpbLjKYc+y4kcIqswfiL3Bu7At/RYhKFEtX+vH\n\
+Vrf+BLsJ07E1S0CpckkSd/hKSjn3RPCl3yPiN2v4bp0EKHhocRh8BYjitZl\n\
or1MIozCP2Eosw533qUWXbwJDVqsaDpehNwl15GzLBU5S1Jx71gN7NZgIjBg\n\
7pWgjPDDAsQ36Hr+xnwMN03fgv3D8Kh0qN2XjzxWBxG/kn0V6LxUiizymAhv\n\
fDj8Uxzkx9KqUXe+FZr2EVQmlUBcPYC6420wdgyidMc9qLoVaNp7E41Zw5Dd\n\
akD9xTaYxTq0HL4H9ZgBzYfKoBI5Zj0Ac98nzIn9cWfq0QTmtA4tflJ8CY8X\n\
peCn9aUws6Bw1Ik/1mbgh9V5/4Df192mm35edQO39KaEMueTdSe5uSJMcxET\n\
vwmsJX7ctz99A40HUZ2F34Rtza/hvnYcgcZSzimfjMYSZJx3wpn5ex6+uv4E\n\
4Bg61n9fsIINmPRKqZoXON7mupRMPlU/3Rwe6aWy4ZEunjoyn/vQbj55Z6CA\n\
wPkNWBZ+j/wBkaBEP85lzE6SnE+GeHv/IBRO6NsJ3N+m356BOzuVtcU39TGE\n\
RW1w7XqZkyTHGX5PCK6pRSRRC7/Foc959F34y3MREg2SdPqn0gqZoxyOchN0\n\
8d6biE5wzvPktJk3plq9JgesCjPcFg83KxfvLRYhdentcBhdiIRi8Zk3lpnj\n\
t3vgsXpY8hz0NW0Jd2IKbhG0HCyDWsTPJ3uNDhg6RWg83QHpnTp0VfJOsqVr\n\
EC03+tB+qAi1x+swmNeFDtJ8ymEt2k5UQitx/WW4Tak4Nam4N2rzsKalAN+v\n\
LoCYHSk34cei2ky8OzyEMGHHQjrqB+Tp5BrNz8Y7YSIA9+6XSOy/Adv2xYjo\n\
4/H0j3BrwdmYh4a6WQiLH0chlmOZ8w24Ui4lXIVIz01ucLiprBYRFfTCteMX\n\
HDFznDkx5Sr44dr+MhcfdF5I5qu0ETHjtMtTxOEyEiwrWHoWtrd/A8exY+/r\n\
JsBvgHPTD7kQpSs1bVb8cECErXBu/AknGa7sLF7t3N0P61wWfv0h/K2tU/ng\n\
DxHFGEGovw1Ro2nWF4XftBXkKi6dPrYsIYOs5ZFiDHPL9yYgrx2DrLofjWc6\n\
oSxrRkNqP9sNFYqSJjTnDGLgbBlqSZVoiUnXb7uJ/lox2o+UYqRRy5p/5C8P\n\
b7mMcacaKGwqLG4uhSUYwIGOAjxLQzzgDaBL1Yvvl6VjbU89Ztfn4KXGchgj\n\
0WcFHDPXzL3vN6TRyeW/cikeOIiOlBKlIVq0hKzPuG7GyDJ7YF31a4TkukSI\n\
OeyAe/+rsM5/Cta1fySXysv3aNlxLphgWfwD+Ju747WHalM4dWSZ9xypmm5+\n\
oMgnYQHjeEwhrDLFwxKTASNcW35Jz/hF2JOPvy+jZuowkLONa9G67GcI9I0m\n\
whKBwqNC2PG7CPTybkyw+CDd/1+wvfkG2w0zMU2EkI10yy+5ULz7Zm58vDU0\n\
3lkrbkxjKp+CrWeEWMwdtJypQMW+Kqg6xWi50IOg3YaaXXfQdK4WJeuy0Jwr\n\
hkeuRM3eYrSn1KMq6R4cZje6TpWiYE0uBus0s/7iYH8MercBFQYdtDYF5jcW\n\
wTIB7sD5fKUIrQ5+ydqQWYGzo51IlY/CEArP4heC835s4PYuPhq/6mV4y0oR\n\
I2McI8oTarsLx9aXOcVt3bSYnK3wfUP+HMeQbZtfh7+uksRAg/BALdzHF/C9\n\
yqQoPSsRmJ1k+5Vt+yk/1UAj4clL5UOjsj4+MLvseb6+XasR84Xjnkp0rJpn\n\
HSwwu3Uu/E319HgG8npa4D48m29q7rPwNbQ+yGbw1fw7PbUYjo301IxdrXiJ\n\
zFYOIloVIpIu+DJ2w7b4Wa51+6EtNO585DEmreJmPSwLnye9cwoRpQIxhwmR\n\
sQ54zq4kuFLT88mE9YjieAjanTCK2aLhCeFAtU/Cq7NA3aOC3xNByOWCpo9n\n\
v2GXB6ZRI2RlrahPH+J+C1gd0A1o4Pfy4ayA00fmxg673nMfFETGIXyrNAej\n\
CSg8gi5dP3YOdkNhleNPdXdgjGLWDwQAT7rUcO3/Az9BNO+b/0Bj8F36mR8p\n\
+mnJj8kU9yYGi0vAoi5Z8CycyWthY7NQpL3ZlJJ10TO8a0TW3nkyCTFvKC7z\n\
MW03jfFLwizU17kpJUYXWfiaKXXb1mUIqcwPCWPLzUI1ZdDQPyfMaz3DHou4\n\
wbM8bSSoOJIPkBrgXVJuGoqwYH79aYJcYhoqKq2HY/NPp+a+WKusCvadTUPt\n\
fgsRkysxDTUZQeDmLi6kz5EgVny50Cp70NlPw3XtEjPbs14UetutUKE7m5uZ\n\
SCwlsveNoKdkXOixGYNj9dmQrRDDnjhc5BHInVrka5VwBtwo1Ujhm4zHbvg0\n\
Ia+N6J/kNKymVo6w8t7phzHpMZGmOkey+FvY1v+CNNPPYd/wO/Ii9yM0Io7z\n\
5UmvDr68ZHiyzyBiJwLSfw+uw4vI5/sF7G/SZ/tc+MpL2H5bU9PoTj0CRZfg\n\
3PUGlfslfX4Fx94V8JXmI+b0JfIGxSRqJ5ZS6z+ll7et+xl7+Z2L4KssxURw\n\
KniIgIUe4TTcaScRkmjiU+kTFiX8+Wfg3P4a38qGl+DYv5Zup6fxhhIxRjKT\n\
4a4SuA7Nowf+Ob3nL/gH2r8O/toqluIirOT5KMfWAr4YokJChcMQhFYZQJCA\n\
4raG4PPzgAn72SEvE4lZPyJzOpkPGnkAkfj2y4EYwuF4DtSjiPij0Eh9MOnD\n\
ie2DWeKkVuaH1RLhm40fzMjnbArZHtP2Wpn6TQBG/ODFkLMGY12/gkmTBWn3\n\
r6BV18/6bLz7yGudII+Yy8IJhqavW5j0e6mr3GxpdDy1h/mUk1yymZ8FhD4y\n\
DUkTbhtiNjMNr50swcTUtipRnl6zbTAS5Ykk8fk91LDfx24XNlF4nMpGcPuM\n\
EjJdDPpeOy7vlCHrpApZx5W4sFWKwdEAv6rinAKpZ42c2x/1R1ByXoGrR1TI\n\
2C9H7lUTd25tZ64eHR08A/Ca/bhxQI50quvKXhlKihwIkHIsPKNAyiElMo4p\n\
cG67AuLxkOApJ16B7R3PaLogyfT3s9wr27UXIe1fCtXYYZgNdfC5m2HRt1CX\n\
ysgFWwHZwEroFHeoo6Iwy7fBoCmE05gDl2sAZlU6t7YPUROM9P9w0AGz8hTU\n\
4q2Q9f0Z0sGTpAvs0I2thWJ4C7TSY/B4tXAZ0uFmUmfNo/qXQTa4DHbbAHzO\n\
WliMHdyrus23YLfLqMeV9BzLqcxSQlaD0A3Z9MxLoKJ29Mob3MKa5xKjG0JU\n\
JSbjKCY8BOJb10WIyNUWDKIwtw/dvUbO+3gyPlrU83nHFTRaUfTmapGdZubk\n\
QVxvwtVjOm50vHovUraM4+xuBdQWEoZuCy7sV8MdmETEG0LGPhkGRoPoztWh\n\
rY0fre48HTJSTAiSN2RXeVFyw4juSiMuH9LAS/d5qM6L70oxMhqaSlQn9LtJ\n\
9iLTNsBhWbkKnR9yU4gJ1odmDmxgvA9ju4/CpbIlBjZgL8Rwy7dJI9ZANfDf\n\
GOl9F3bDBYwPniX/azvkkgvw2DsganoRdnMjRtp/BptVCv3wn6DV3YS4/VV4\n\
fOROhkcw0jUXNu0NjLSRsjeWQtb9A0iGDpDmuIzhdtI4pkIM1f8fGM190A+9\n\
Bp2hEoq+1whMHXBqkyHqngO9bD+kw9e4XjGIV0IpK4V28FdQjF+i56iCpOt3\n\
cFhqMdLyXRh1lTBIVqOv+ddcHlsi3SjiJYNpIIZDoxeNJugl4TLmN9HPdCnk\n\
/ogA8KhHBZ+kCM7uK/S5DI+kliSMP5CaSyOm4lFWUyScaGGCpSKzanwmtqlR\n\
fAPzyYgLQX03/MpWBPQDiAbcU5kOTnKS1r5IZOYF+Bv64mgLOGw4s7ME+zYW\n\
YO+mErT0WGai7YQC4+oonHI3so8qkHtJizsX1Ug7zU8P9BfqkZdlIXKjRUWl\n\
G9JaI3KyLYJSnUTZJRWaWr3oytOjVUBb1WU1ziYpUZSuQ2GqDnczTajJ0CD/\n\
lj2ujHErWQmRKCig7VHOwT53Q41WhZCYTTopt0iLAzlaHM9UIbPNxcIOgl8c\n\
9yC4hcxeH594Q+LmVygRNDu4Yysmo1G65uVPa/eQ7o1FYCu7BcmpPG6d7KMC\n\
Qp36U4TGM1yjIQehanAHITQF0qHzZDQMMMoPQdo3ByOdr8Pj6MBoz0Kwk9wN\n\
ornQ6fMx3jWPbFWAECrGWO8y6McPQCbiZhXhM12DbGgnbLozkI2kcb8ZRxfC\n\
YOqi+2fDYO5EwNULDaklSfdv6b5jpMqOQj7Gz2gYxzdAKc3CWOuXCbXriVts\n\
g2JoDT1TMsSkDjnjFhFjtHspwpEphPpGzkJ95T+hvk78fXw4Tl8mPCLos78F\n\
9dXPw1i7e9py4Y9xm3i6u5KgTf8K3fo4VJc/C9Wlz0CV8nlosn8C50g5wvpq\n\
uv4lqK5+DY6BlkRzrra3qM7Hocn4Nvw2C//zRzHhk8Nc8BJV9wRd/gJV+RmY\n\
Wi8kZhX4jKSnYX7tKWIH3Txk/5FbxWHSOyEflCN5axGST7SyAzyeEFCLIKH2\n\
JKFWG4OfrFBjBal6XQDdZQZcP6mnMYsihyxT10AQtjEn6U0NhhotSDmi5adF\n\
CGl5R+Xo6PWh56YOOZlmRKKT6L6pRcopHczGEBTddlzYKUdtvgGpJ3XcfWF7\n\
ANfIejIdyWu3j6C2Wocr9cLyASIydT12jJvCMGg92JemgtozMes9kPVBcT4V\n\
PpsfpoyrEG07AsmuJIwcPAe/SgbZ2QvwKWWQJp/h9rn2tJSgd/5GeC3+BGTd\n\
xsukDNdz82Nu/UlI+t/lICsTXYJdcxBD7XNgM1UTQ6lBxDdG8JiPIAfZ2QTZ\n\
O5C0vwSbw0gMZRAj3XMJTicJujs4B9yh2g3J4C4esqIU7s3Mso0E2Q66/w36\n\
txmqnu9BOnKQ2qyAw9oBm+YQxP37uYE1iJdAKb8LWedTpNxT4aDnGGn6L2hk\n\
p0mE/sgdZR12lWO4Y84MpeoTnSS8PQbVlS/COTaQgCzbzyLzq4Sdf4ehatsM\n\
yPpFZ6C+/GnC1hME089Cfe3r0GZ9B5rUr1BV/04w/S8YixdAc/2LdP8X4Oit\n\
n4Jsy2oOj+q0b5DxN8ch6+nezt2qvvYkVUlSkPIETC2Xps1CuhGrz0GgOBMR\n\
lTFuK2tzW7BnQxHa+qzTzpKa5Ba7APHtBB7mE/YDYfh9IZLX2IcESMubbDj9\n\
tgS3CIo6mQdXd0pxN92AmwTzm1lWmCROnN/Fjq8mUkq3Zx+QoavTjTvJCqQn\n\
a4ngqXCJTLndO4GeWzqc2CBB9hU9t24w+7AcN1P03L938qzwesLIpf+nnVRz\n\
yv/om1KIJVOQNmnd2HlVDXtY2Nyzy4KdKQokXVdiZbIcQ4bIgyAtO32NtJ0V\n\
sqTjcEptCCt6MXbgJLyKcUhPnoFXPo7x46forSPQJJ/C8NtboSnvS0B6IqKH\n\
nOy5uHcRRpo/R9ptN5zmG1COZcFrzcZIx6uk+RYTTN+GRb4VfbWPQ6fKglGy\n\
HkZjJRHx70DU8Xuy3z+DeHAvsSwD8YMXIelbAlHzFyAbPUUO+GXIR9O517LI\n\
txNP6IFpbDlMViKQkrUE4VUY7/4FVLLr3N4CvTVPQDqwGMPN34HTbYHHmI7R\n\
zt8TUVxAz7GOXA4HtMNvkCjOxljH8+hvfYU0yXRInyIwfZog/aX3QvprBL/H\n\
CNLbp+3W8XEyWlYY856nWwh7Vz4PQwk5TrohMmg2hIw9cDRvhuYau0bK/dqX\n\
qY4vEawbplC9hn76D0L10wzV09ftOuoWcTpdffVLsLZcIf4whLCbnxCNEiVt\n\
KBahqlLJXNr40m1R3SD2v3UHl6/2MVUUj5kaxTqU3uzHmDSe4vlJzi3prRtF\n\
3tVWpJ1vQm5aN4bFNsj6VSi7I4LJHk6Y9bEOKW5casSFw1U4va8CKacbUV0t\n\
hy8s7HXxOJwKLycE9TUuto0VnIYAeusdGOzyIBAiv9EegoocwLhYmpV+2B3E\n\
VYnRDDU70NPkgtPDe4fMrzRpAzS6/DlR7N6BBgdGBryJxa9BdxhDLU5IRcSC\n\
yDMSjQQTAsFck9wCNW71EJcgw38gVYkh4t1+V4A7v65bHZopECwmEoD8XCr8\n\
Fjvkh07DJXNQG2bIL1+FVyaB9NRZTiC4f2WjEO8ncHa0QHzwArMivEx8mbil\n\
kzhpH6n0ZMLxevj9Kjit/NZ6Qc8wHOZWwlsEUXcDBlt+So6QgcxKI7zEGsNB\n\
K3nOCirfxZVhfyYidrhtPQjStWjET96nG+EQz9miIRuVC5GZqYXX7+TSSjy2\n\
NrhsfBaATb2P4+weWwepEF1i94CQd4za6KXHFhxtFu519MFjKYOoa8FMVvK3\n\
ysMjiDk6oU37MlGIz0Gd9VuEPIHEcT6ezu1Qc2r/ybgczPpAQeD3UHHULxEu\n\
fQsBpztxS8htx+kthTi4vQoWX+zR+C1EHwtT6rBvUxEO7ayAzDCV1jNU3ocd\n\
K2+isl4j/PYvXBO9VX3Yt+Eu9r1TjDMHqnByZykObSvF6T1l2PNOKURyfn23\n\
qEGEA2+zciVIvdBK0tOC07upzJsFyEgfYhsnJzY1Z6cmXlEh9Zwe9sBk/HQm\n\
RqXzyb0fGZ2i0kFCudsXI/fFjV3XVBgkYTqSruR2Cw+6A9hLAJbYovdhNuZQ\n\
Y2zvCdgGhiBNOgGnxEZ82ATZhcvwSqcwKzt9FtrsVIxfLCZt5YFkyx7YxaaP\n\
Cs8ZdDZALblGOCuHVlaYOHppwktQauSOK7DKDsJiEyfcRrN0Hyx2eeKNuH3y\n\
jJlkvcoTIsjFDULjkIsOcw7p/wJSEd09YgSM4H4ahspd3LWEgxXUwpjzLV79\n\
/s8g5bfbEreEPQ5c2FWCY3tryXYnIOXVG3F6RzEObismv6wQJdWqxIuLqgaQ\n\
tP4Oapq0CUjFAgFkHbmHJIIO/c5RKJ/Dg4qMZuyn+w/sqMCYmrRhKIC0A6XY\n\
v/UeekTWxKI2n8ONvLM12L2pDMNST2LGnpSefNSHQGQycdoXo4AOcu6DoclZ\n\
cQeWveHdSgOHmyPkim08J8P1Fhc6O4kZXFfhEGErrd7ObaRwH6iCsh4MrdsK\n\
fUUdTNVN7OgrQqwHlpYOBJQSjAvMQHryJHSFFXAp+W3XnHVVBCrdC9OeSviT\n\
8Hf/RyNfQSP/BD/ytXumXaPRbVzBuzx/hUH9Hwz6P6Kvog9JGwpxK7sHF9jO\n\
Jifb4I0k1qe+d9wfRoQ82+t7qab99bAHkVi26nLiSlIp9m3nhz3m9+Dm+Xrk\n\
3hAxhzARyUUM5YSQXW8Wo6ff/rQgS37SDi5vlDQE2yc5ykaf61gbmUW9LcJ1\n\
yoemjyKriYBy8DCUmVXscryro3oxJMfYANJAHjkJ8rtm/ezvNDo1u2eMjrf/\n\
AF/d33V0bP4Yj/EPcdlGeckVSNpaDqnag3vX67FnUykGpO5ZHzRELPiQmlSC\n\
Ewcb4AoJo/lxLhRUfK0Oe94tx6iSV/aJXLpAiBwzKzrqxoiYN+HwO4Vcs2K1\n\
70d8vyeOeFKNw9E5zPVEYoOxkJ/UsYp0Av07rmQKVZikeohb5RffDjlxBPc0\n\
0YnvGcHOjA/xsfPEvgLTf4tv3vd3HkT/cDK5a4/9rwfxkRmDaPFGWG4YjRK9\n\
Pkv4mEikPs6Ke3V2mRrH3inAmeRObr39WOMQ9r15BzcLpIlhiY9ubbP2QYPr\n\
nDa4pOlKMupnDm4ohLaKQVw+UomD7xSRBb+DvaSaTx+qQX2zlgVuhcH9V+HJ\n\
rONO1OQYSQbj00ufQsAWRFOWFgpVGD6DD1Xkd908PI7b5Kf1sQAYPayqw4KB\n\
Vn7N+0CxDvnHZCg8r8JYjwtN2Rq03LNNO470w/D5/MhsluJ45RjKxSxUMYGy\n\
biVuDxmnSP2HEPAFcLtVih13+vBOfj+OUPFGOXeOYCI1K0BV3WoZx/ZpZZoU\n\
zmk++V+HmeodfzVmAmOXiOP9vTBzkbjVoW1lxLWakXWpmV4sk/5+GFmXW5Gf\n\
1YPuPi4cH3ebWgs7sWf9XZRUcdvMw2+14Mz2Ihw/2Mg4WAI2+97MR3GN6gNh\n\
81EeNunTYTOJtpIuJL11Fwe2lCL1Yivqq8cxNmImVTr5ZLw28igbB8zIbjJg\n\
1BT69EwUOaROXFg6QF66N4EiWa0OJxaLIJf6UHJwFNf3yCFqc6ArX4ML60SQ\n\
KkLoySDUXDdDP2DBuWXDaLhrQU+xAWmbRTi1VITeVvc0tfNhNPSN4w+XmrEk\n\
sws5A8xrjGDXjQ6sKxplHmM8AZwh5EhBD16hDt1eOoKr9WKszmjHayltuD3C\n\
R39ZmUN3urkyO8pGcYXKrMpow2tX2nFn1M6ajY/+XwJTyqehLdrI6cC/DkwX\n\
/y5gejgBpoNbS3AqqeIfmB9LRO30vkoc31HCSX/S5mKU1/GbIMQCPqQfvod9\n\
RMzGVMKRsBNRFF2pxe63i9E1aE+A6QD5DefPkJMVnYxb8gcC6iP3ASrAzYnn\n\
X6gimleKxnbjtIzJhzDYJEZdlRTu4OSsx4UXbG7X4sg9Ler6zdiWNY5RW3zP\n\
lKmgMPWBr/kKzBkHETJqYM/aBGPyMjjKMmDL3gFXVzd8DWkIGsjzrL+OoM44\n\
K56tweKsZYfFyDmtgdsVgY/7hLnfMo5rEAxE0H5XB701yhE8u8yJa+sH0dXn\n\
Q3+OAqUZZsgadTi1Vgy9iU8gVbebcH71GKy2WHxmuqRhGK9d7UC3OX6IaRj7\n\
b3ZhY6l4OjLruiR45VILLnToIWwZDjvx4u3Z7fhzeh/MRIviZS51GiCwIqJF\n\
LmzNasfsjD4YArG/EpkswK7O+Dl5Q97/p8j8xDTTWAOtLcBFGwP+MPev3ehA\n\
c1Evjr5biEO7qqFzRmEakePw5v+PtbcAj+u62oX9tF/Tr+1N4bvlNGmbQsqY\n\
tGnTpklKaZoG7bZBxxDHMTPFzJZZli1ZLFnMzMwMIxwN85xh5tF71zlnZiSn\n\
af//ee7V88gan9mH9n7Xu961YW3WNQ7AHUTUx810kIfcXorM3JkIMidxdk8F\n\
TlEUnJk2ConEDKvNxw20/DsXeRfXhVGT2YHDO6rQ1acjtRGmuDoIybgEcXtK\n\
EUeM6giAnxpwP/eCvcR512oVuF6vwNVaObJ6GWjNblSM8rai1dlQN+uAjY7l\n\
tauQ3aXBkfR5tIocxJdGSEjPdkwaIWK8aKZGv1Itw80mNdQOPyGejpuD3MB5\n\
zagBWmc0ZeMy5HugO/57GIpT4Wy5AsXB1+Eea4Ep6TXItvwCbpUWxssrYZ8W\n\
wHRlFeyT05E2+AKkHVoi1Umk7p9F5nuzyNg3g/j1AnS380vf3QY3uslV5x6e\n\
w63NU8g5L4HBEsJojgRVGQw8Zg9KTswjZf8cyim4r7kqRuLWeTD66CZn96Km\n\
cxqrCPaTxmgio7tgH/kJIYHY+B+Zo1C6ozLjHuiMVnQIjbD7/LhRNsJhW+1Z\n\
jIagWoMV7ezX/vCKD8b7ZPRKS3h/kPD7AHQtF1izj4bT//eQjx6+G+7mD1bz\n\
4ejGQexikJL4JhzZVU10wqA1txuH3i1BRaMsNr/SbTDg6v5ynDrUBJ0jhOmG\n\
CRzfVoabF5pxngzkxM5ypGTPwudwI/m9Cpw/0QpLFOH3cgivSG3FoZ21mJbw\n\
lK6ZkeHKgUqu2yflRjcyb7RzRnNsdzXa+rWR3N73c9Zwq4wkWYMGzQITGgmm\n\
XQt2Lh3WgXxeawhmNDjVpEN1GwXYtSoMC03YkjiFxgUbtZkEvTInblVIUEDW\n\
dKFEDrGezKBOhKtdelwrlaBL5uUwcbRwAZOG4L/C2w39qefhFMrhG78Dxc6/\n\
wNZVB1dvJjRxr3ITDUzX/gnH7DTMN16HY2o2Bm+/yY2sHQKUZ+qgEbvQdVuE\n\
+G3z0JlCHOQaLgmRuHsOffVGyOecMGp93NZOw9kSVKYy3LIundAByYQNM11m\n\
tN2WIGHTPPQxeH8yBu+J98F7d+0yeId8OFk0jNcyh3CxeR7XW+bJEbfMEwBu\n\
dYiQ3C3BrMGBU8VskeFokRV8mQ/Hysxb/ctgfm0ZzAXRAY4lmH+Tfr/G9b7r\n\
6g7Ao50l56xFKJJB7P8l3tdFhqd+Rni3/pu+hRjeCVD1RLdHtlejp1eN0bYZ\n\
1JQKoNR6Ynhn7XK0bRrVpfQuxInMgga1RWNYkJqxMCpGxpVWlFaJEPQF0Fs7\n\
ieZGLvPqUm9CGNMDQtSUT0Fj8kdDAr1Uhypyjwlnm3CDYp2ctCGMTTKc9oju\n\
BMSemlQpoXDCHcOQWm3GsRI+fdDMvBYXmokyyyXoUfDtXVYrQYPQittVUgwo\n\
nEimv51iJybmjUiokeFwjhBVM1YyASn6lV6uu/pUqRhTxg+AOsXbp1+CY1rI\n\
pTWz1d+EMf80dOdfgPL0Km4PbdO1Vz4Q6qwj6r4lwp1LCi5LVdXpORQkqCM5\n\
gEKoOkkx/E0NXHbyZZ06JG6ZhY4JYvQOQT3dgIDNjcwdU+hps8JNZQSVKiTs\n\
FMJkDUeg/oUPhPrpoiFsrZyDM5psiAgtroSYOq0fx6unEFc3jQv0G1c3g915\n\
g3jxdi8aZRZcKeXLnKjhyhDWqRS9za5cvkyzyhV5ty/CPZ8Ofe06aIt/zw3e\n\
s+BWF/8dTP1aGLoT+Z1lHQJeaZM9qPOfhzL9W5GR1m9zw086vhftg4D/H3H/\n\
P+/DvYHjU9vAEejr1kOT+wjvUVK/A23VW2Bq34JlupariJgFEB1bA4h2j1vV\n\
eiSerMHxPTUYmbUtbUK2NIuPG5f9EJsr7csxHl5EWqUIu3NEuE6gukh8Wiyw\n\
Qau1YBcFSI7gIiYEapxt0SGN5doJO7fFWEKhEPXLwUnSombYgMMZM6gQWNAn\n\
MEJM2utmqQiVs04uxcDRIhGmTP8CzpCJxO3B38HM5piQdkN99AW4JUK42uKh\n\
PPYS2KVD7wdn1LvqSeUkbp3FeAuD1E0CjIy4YsvqdZMm5Lw3h7R9FGDtmkFb\n\
tZG71lS5Ai0lRu7V2d6D9D0zSCOZkrpnDu01JrZMTGLUdfHAFJh8MWCeZUGY\n\
OYJpSzSD8CJyKWpZmTqICYM3JjFKSJW/nDJI8sSDfNKOK9MG2etEJUZhuwCr\n\
6JRxky+GR1vfFkivfYJHReq36JedMfIFyOI/DkXBWyx/ERFPQJX+IGQ3PgtD\n\
VyKcgvOElAc4TMoSPwcNP0MAAVU1ge6LkCV8BprGg8vx6J6Jh/zmp+mr+2Ee\n\
aY3i0dq5jg79D+Qp34bTwPZCB2AofQzSG5+ODLZ+ix9ouvU5SK9/DNr2i8vw\n\
WINz79Wjsow8RlPVFLVNTdEobp6ux/HtrLTuh80TXvHrGOzCuF0pRuGwCQqD\n\
B3Jy3UYnSXHGis1JMzhLnLY3fRZV8y5oVBYczJ7H5SoJNt6eIbdu52DXT7C7\n\
06xE7zzF/wTh+AYFhTJCDGtdSK4Q4Z0MIeIIfodJGpDKfz/s3H0pkG94AMqL\n\
e4ijHLDXXoD68O+hOv4SWSa3mBSmq//8QNixiRdLj88gcdsUkg+JYHEsLVNm\n\
x1+Nag+sFEpGXYTb5IXVGE1zyY5c+mHSeuF0hiLO8X52r3vktwjwd4Jbu9wO\n\
BzswG4HbKuKtrWXT6CN+M7gCkCp1ePN2N7aWz2KOrMxO547Nq7E2tQebyufg\n\
JnkhkWvxOpXZXjGL+UiZkTkV1qT0YEvFHGvZMY73adpgG0uBoeENbrKTPOVb\n\
0DUehX0iGfa5Zn4Ruk8H69B1mHvj4JQO8u8hq4a+8mWocx4B03OFw13INgfL\n\
wEWunH2hPdYrFtAPwkLHzL1X4VZLo0EpN3de2QjbaCJsE5nwezwcEbqm02Hu\n\
v0zU/AQPvrTvwdBxBua+i3BIh7jb++wWxL9XxY5L/heO7yijuxzdVoozB2qQ\n\
ljQIpd7DT0ThM66a3MFYA7CB14zSglG5jYKu2AgEY3FiiMI6sSm6GPOTcFDk\n\
qKBohB3dFWtt3PdKG2/6bEeryuSisC/E8ayE/V7KtlEwKpIZiwsClR2GyN0d\n\
BA9nJPp2U/jPOAPwkd6YklswTE9Dl4rc+iuIiuQ7/SZIGTdEhGwZWYuP3sZO\n\
19MYXBBqPbH53TabFyKdGw5vEIFQENdLxGQtLgo/rdCTvvd5AxBIbVByzBXG\n\
lWIxGmZIgcodMHtC9y43EBYaXugvvELh3ezSdu+sR1yWJMB44UU4ZmLhX5Rg\n\
BESxF18dQ2UOw5aO5kkbyhSjPFkXvVaMCVKrx7AypRdvpPdjZVIvrvVpOQwc\n\
zR/E2pxh7M4fwnMJXTjdIuHw0j4iwVtU/p/k5jdmD2BVUjfW5Y9jQBfJGb4Y\n\
RsuwGKsJ6q8sK7O+YAJDencMku7ZGxGp+xCsC/Mfi714GItcjvZQpDOInGvH\n\
+pgY9VidS0srAxBPazA3xWaJYf9l9y1TQ0YgYP0I74QfgUqlx/56bgUvQgEK\n\
OasEeCdPgIP5k9hRKoTRv4h5kRbrM0ZwpHwG61JHUTpv4+r7StkEtpbMI6Nz\n\
AaszJ3CuZg5rsybpTbyQS7VYmTiMZrEV5X0irE4fxwmSp2typjBn9WNmQYt1\n\
GaPYWyTAm9kCzJAvSqsnwUa6kZ2vciRvFHHtSlyme2wpmsHx0insKp+H1hPF\n\
1CLqe1U4USjCWdKWp4tFSGjWcFtlR1NrsmWquqkOGA+qejSY0vpiZMhWZUmH\n\
ClOMP7KOcMXyFQcBvZIiGF+sQZwtd+DVaeFsy4VHo40O4PjsPoiGrTCZg7GR\n\
cLPcBbXMuwxL/BwfkdKEq1Vj+GdqPzKHVZhhh1vp+LjEgFGNnWSnC5VDMrSJ\n\
TNG+JKnGgrJhOXIGZKibYaBx+GNML1n2XT19p3UGYjPZYh0Ct78Fi2Dggcjh\n\
xVCAncjMZeDFIv5TjxW/NuaHBA8d9tbKuAqXiDV4I2sKek+Yy/ZxhEBbOGnA\n\
hbJJJI/wWbsmZ5VYkzsDB3H6yaIJdMgcKOySYITIwO7y4lzhBDInzZiaUhDs\n\
FEQMDmxIG8Eg4+OeI7t+hiJrGY7RuVkTZo678luFyJsyILV+FjkUkbcOSvBm\n\
7iwWGBtut0ph8gWh01nwTuYY+nT+Fd/jm/Onkfao65wied2PKYs/shzoHrim\n\
ohX0VegajiJg1yHksd63rEacYxegKX4B2orV8FisK+6qrbbVkN36IuRpP1xW\n\
Wx/hamt3DV9bU5Ny7KqVxTLapDXPIqFTSYGQAF3ayGZ5Vis2ZE9ATfR4ungS\n\
PRofVPQmZ6pmsClrDFuL5zhjEQjkONSgBGOyYBsZkC1iA2NjMmwpmMEBMtZ+\n\
XXSPm09wNJPROIuXbg/j1bRRtKsiIxpTahyk+6yjmjrVLKOaC7+/tjpHRNhe\n\
LIDQFq2tj8KvKCPB9mWSWA9y0l+Z9iNoqvexk28ir06hcvcGqpLPUZV8Fy6D\n\
fnlt2QYOQJ33GDSlz8Frs8WwpdEweC1jEjJHEHKJFquzp8Bw7itEJj2JzBEd\n\
LpZPImWUx5ZIypexkN87RW8xqHUjvnoSB2qlkBrdaJvUQkQOZJpq60CjEk67\n\
ExvTRzHEXxTVHXM4UCPGccJg+jjfUdkzpkTdghkZTfPYUzSFN9LG0KHxsHnQ\n\
sCllCKmjRnJmDtSOabnNxqKbGYcMSvjGhxDQMBE6CiFkNmIxEF2WuOIHkRp1\n\
9t6GbWoqRi7vTzcT3S1y0UWhq7iFLuGL7TDLTscwt/IEz4Zv8lufgbLo7btq\n\
3tpFNZ/ATqj9AdU8s3SLMDejlfUVX4nUuI6e9tXkIawhku4kYo6vmca7BdM4\n\
UjZF7mwaUhK6c2KqZcLMiRoh1lPtpYwa0DGlwj9uDeBkowSlvRJsp3POEtmv\n\
y55Er9KKU0XjFFCMYUDtQE3vAtbdmcCp6lmszRhHP1n+JCnAN8hxHK+axasp\n\
I2gmoZxO1lwyayblp8GbaRPoJfd/nZ5nX8U83qPW3V6+wG3v/JkIkQbn22HY\n\
/Aos107CuP01uIanWOkHy7EtcI+KIpUe3UqV3Z7W64vM/V4MwmrugsE8yi0B\n\
+lwEm4uxsWiSC+mrSFe2xEbhw9JU+FLuR9jCRNzDPdzCe4+kFtbheJi7z8Ay\n\
Xsl6wWg7BAxjcIkb4ZJ0IOjzPxh5bp/XR9LIjWmFFXJ7gHNuvUID8bkRencw\n\
ui2VSm9DrUCPYSU/5Y8ltE3pw8gYY+O+MKkjM2qmGEgJ4OzGDKUts3grfw4a\n\
bh3rIialJu77JYF4L2RaKx3TY0LLd4EmVU8jV8ADX0aCUETi308BQ+ccg8Y5\n\
EyxEB/8TeWz/SAPcg/yaWX9fHown47nP7pxjsGSX31Xd/w0Lk4GhcX6ZhmJh\n\
O7p6/4b+3scxPpO0NOvla+ylYKk5Bm3y69CmvEG/b0KT9Cqsk5Mc/PVZ66G6\n\
+SYMVedg7qzCot8MU1Mqgm6+qyWg7II26TUor/4DTHkKt+LJnPcWpGdepOu8\n\
DnXqLngZfkW2R1AEdfwqqOJfpdZqYk0uOsUrLEuDL+3rFLDaec24bFtNsMk8\n\
eGCseDV6jMyoekgBsT0UK6dWGVE6zdXliiV5tojUhjkUz1piyUDYPQhcbW0c\n\
ObgKz8F0JoGnC3E3DDu30KuFI+vaI1MEP8EGKhDObcWE4F0MDj6G5vaHIVWU\n\
oq/3KRgcdtIls+jueRpWV3TXPbZmHVCeeBTqzEMwN9+AuTEeprqrcClUcDQf\n\
g/jYStiHy6E4RFFy/EGEPQrIL78GnzXMZWVQnSE+zqH4abIBiqPfB9PaCEvh\n\
GoiP/I5irUboEv9G5LMfft0EZId+BmNbJZwjBZAdfRx2iYInnfuxqGtAsOsU\n\
l5+eszzHAoI9WxG2ETUqsuBL/wYC/ccRqP4z/JV/Q3Ain1fuHMwMCA7sgb/s\n\
KfgrnqbPcRRIRa6jrqDrXGDplS8bsiLYtxch+dSKDZHatzt9cPALyyMLLD+G\n\
oKgL+tefhunYVpgObYdPqokYfBCOm3tgq2j7l9oPuzE59AMMCs5CIjqM7v53\n\
YdQ1YmD4ZfCRkgNDAyvBWPXLtj+3Uw0+DYdCH9FnX4I59y1oa/iUsc7uK1DE\n\
76daV0JxYx38ZOMhTQ+kJ5+Dnx92gqPzHH23C8bct6Gr4fvTwvoByM//HZb6\n\
SxAf+jUsQ42wj9TDWJMAhzg6L5FYau4sfMk/R9jB91Iu6jsI4PfSPSRYVObA\n\
l/op+LIfQXA0AcGON+BLIj4dK+GYMdj0Fyr7IH13A6GRI/BlfBr+psOcYYSn\n\
6f+pv+bWovEGqIY/6z5qwvJlc5gQ/Vlyb+HYwdjkRbZvLjr/6RPLjn3QudGM\n\
Ok9x/34cYe0MLOfeg1+jQdDErrkNcYt4QyYTAsIeGHasg1esjej4T0TO8rtG\n\
MDT0JkSSyxiZvEUCbwb9gy9GWtGJwf6XYbDql0zICfW5J8gMKJZvphi/KQWm\n\
5kKy0CDM+WuhrebznLoGb/KN6VVDfu4leC1hhJkBasxnKB7gX8jZexny65th\n\
yHmbQBBpTMMQZGdWwtJwBaJd34W+7Co15GXI3vsm9C3t/Pt/BmHhRTKTx5ba\n\
kumCL+sLXBZXri1TPo6gsC8G42DLX+EreQVhdQfXdsHp9thS67A0C/6qDezm\n\
IISRU/BlPrWsLTXw534TgcEq/tY/ho+hNx79PQzDT8Equh5NmE/8UA7T2FNg\n\
Bh6HSbAJPidvRT5DJuyK5FjY7TNkwSa+wWcgsnXDPP4i7Mo0eA259JdPbu+S\n\
nYXbMMW/mm8B1vl3yQfxlO3VJ8EqvManGgkoYZt7G8zgb2AY+RMc6hr+PmEn\n\
HAs76Dn+Dr/HRN72CF1vJJYEI+yXwTa7NnLe03Bq6vjz2Oyp0oMwDP2O3uM3\n\
dP4OOt/4ZKSm2Owj1rhNMB7bCeORrXCPjMKRcwXGAxuJPLbAsOVFWIubIgjj\n\
JdvHYNYlo6nxsxicIOcYNqOv51dQGITwOgbQ2f0X2NyeFXfD67cEnQ3Q5R6G\n\
LucAtDkXKfTww5zzOjSVfIp1V981yK/uRNinh2z/16C4uRNuyRSd+2to8uLh\n\
lQ9CeeZX0JYVEMe8DtHBp+ESjsCYuRLSK8Qt2inIj/4cxo5auKdLId3/LdiE\n\
4mgqBx5ev/k38MrmqCBsNX8oikaWWe78GaGpG/QV2VTTdgR7jxIZHyECPolg\n\
/yU2yxPCs/8WXZEa+B0CpnxoWz4K0/R+OBWnoW37L5iElxG0d0PX9t8wTm6D\n\
W5sN4+D3oaWaZLcNcknegX70lRjEXFIyqN7nOIg4Fl6FuvMHFIENwCl+G/rx\n\
1VwZ89CvYBFHjM7ZBU37x+C28ZB1zK+EpuNphINeWMcfhabrYTjVOXAIN0Ld\n\
sgIOXT85gAFo6NnM82cR8ttg6nsIZkkuIheEZfRndN4vufPs8+vpvA/ByYzD\n\
pz0LdfOHYJUkwaMvgKH/G2BGd3DZrZb2ogvD0nKczKwuNpN00aOBvmgz1Yl2\n\
xY+ieGSzHrCbkrM74/B5Cej/bv7/Lic9o5s99j48slcXTa/B8AQvMgzKs6QU\n\
/ojevj9iTlZ216Qj3mf9BXa5LuazHJ2JVHt8F6ZX2ASmJofTYIbiU9ClrgFD\n\
FBg0TEJz7Rny/I9Cm3cVQU8Ajp406PMPQ3n+D1BcXs3Nv+CuMd8IVdyzkJ95\n\
Fqbu2mXJtaNA/CW3bc0HA/E+MinDEhDPEBD/hNBMBp12L/w1byPQuZ/bAypQ\n\
Q8yb/EkuqQ5XjgViNMlmQMsDcag68urfhmP2RWj7/8oNLrI/HuVRGCY2wy5c\n\
T8D7PSIrcshhiIifTiPg98Mt2wpm/K0lIMo2Qzewigfi3PNgSKxxxwmwzOTb\n\
3GfLyJMEhoYIbnqg7frfcNv5qnEsvAZt98sI2Pqhbf8EHNpJ/vG+AJc8Hk59\n\
P0KOVjrlc/CxWSNIOZsGfgyLtIB/NGcHYZRO00X2p6HHcMpI75Ej8jGl1KrV\n\
/G39DKwTT9KtVnIz8ZbjUJXwI8hKL8RwGLbOQLjzf7HplSJR132w2Kcwp2mE\n\
0jIbqy421mXI5uZ17TC5dbB7KHBdDMFBf71BH7f3qZWOM9ZxLFAZi5eXOMGg\n\
DVaPLlaFJtskf23rPLcZBR9IRWKKe7iBOW/kVPbH79XD6TYsDauT4j35cygT\n\
qWFKzoMpPgd9wUnY54RLW2kv0yafjAJp4Rrpn3sRmKhkXwSLhp67/WvyRxEY\n\
Lo6cRm/T8Fv4Cl+gcpPwZ3+etM+d2EBeaGQH+dyfcXI3PHeezv0cghI+tdai\n\
uZ+A+CUEZ6K+ehHWsV9AP7Fm2eTNX8EpfI0Y6ovkrP5Gv3+FcZRsZfwf8Fh1\n\
cMu3E+jWLAPdlmWgeyEGtH8FXf37QKdbBrqVCFhaoO34b3KST8I48ix3X9PY\n\
83ReATluHnVep4mLrznUyfj6CNnqCKz30HlPLTvvBVjFeVyfk1t1A8bh31CZ\n\
z9A1vgGbvGLZu95H2o1i+okaOEUj3EJyn2oUHp0U6tu/gow4xi3ph22iCT4z\n\
3+MTts2Rf6O66eqAa64J9pluBL0Rvgh6KGIQE5PzsWHYa4FjuoHquI6EhCaC\n\
6vshUlzBtcbvI6PrOcQ3PoTiyZvc9uqTwoO4XP8tOv4sElp+hoSOP8DoMaO0\n\
9y/oU49CJr+MuLqHcKvtCdxuexjX256FymmBVpeBxK63wPbgzUvP4FrDD7hr\n\
X6drl02nsSsiozlVluZY+GFtS4Iu7whBR19wjF2nmXuEXmc+UjH8o4bnLxE0\n\
P0KQ+irJtpcRms7kJB0n4+UUPSV9lCD1LQRaNiBQ92eSgp/mcoZyTTO6l/7/\n\
GYLrGgSaX+a+C/TwezKFp0/w5+b8AIHWN+Av+QFx6JcoNlVGoPw4HDPPQTe4\n\
Mga1oGMMLnUzOcY10HR+Dy5dHTxME9yKi1C3riCHNw+PYhfx6PNLS5k4TuSv\n\
4Zh/iThx47/A0zr8KEzziXwTugah7fwM3NYIPEVvEv8SPG19HMwswqt0z0YK\n\
6Ztg7L8furEdCNl7CVqfh9dl5zSdeeD7MC2kRuDeSaT4EVgWbkTOayAn/GUy\n\
uQPwM4XQtH4Ypqn99F0L/LZpgpIhGkEFKBoTHf0ShMe/AdHJb0N86deY33cP\n\
FMXXoE5/BjO7P0vfPYSFY1/G7KEfwiahJnFJIDn8vzBLKk105rtU/lMQXX4e\n\
PocfQaYbcwe+SrLVRiiegTzu+5h77+sQn/k+ZvfcD0NfXaTqH0DAJ0V683fQ\n\
JGnmXsNm7UBuHyk7wwBuN3wbbbJ27viM+CSutP6KQ2lJ7x/Rrx6CRHoBl5p+\n\
CTmbXShkQ0XPb5A/kQq1NgtJ3W8RD4uQQsjskPdw1zCZ6nGn7zXoPNHJ6vzA\n\
91cQNg1ROJ6LkKSaALYFYQV5oLlseksnFu1ChCZvUzxRhUD7ZgLZRoQWmpfx\n\
axBhyR0EmsgpN29DSFjP5YbkGoXpISCXIiSjc1s30u92hKSdH47gzqe/TqLp\n\
40QVJQg4R2EaegC6kbfhpwfVtn0MFrpsyCMmW2GF20PkXHyEwT1QNd5DtJNJ\n\
8rmHsPFFEn/vkFjTk7P7DfQjL3LJQVySDWAm1vK4G30Y6o77KFboIFo9AHXT\n\
ChJnG+C3DpHD+zF0w+/QI3thGf4u2cE/4HeIyZFm0TN8FFZFMVFKClHmp8gx\n\
d1A5N8mk70LV9kXYZLkUIUrp/9+Bfuh1Cu3Z3YrS6LyPwEb2w4peTdun4DKy\n\
68SnYBz4Kgwz5/nX/wmstesxs+/r8DhDhGYrdCRdZg58mTQtMU3aE5g7+Sy8\n\
VjupJC0pq+9g4fpOYmgZxAf/C7I7h+mVQ/ApOrCw/xP0SiUIGgcxt/8Bwp0F\n\
ptJXCHO/hcfCdimGYa7ZhIW458mR8k3jdQuQ3PhV5AxtRsXYPlSPH0Tt5DlM\n\
KvJws+030EUklNc1hoyOx8FwuPsThzux5CxSe49GBxwk0jik9OyDRJOJ291r\n\
YbCPEnQfQN7wNv7SEwfp8iT5nZYoOT4eJUePlrB1hwISS6Tbhr5Z9MApITLp\n\
/BIRBAGi7zGqEX4LXo86Dvqer0LX9U06/mu49L2R4+fIHxGHD/2QvvsydD0/\n\
hts0RZe/Ro3xcWqET1JUcBFu9UWYhSe4c+zT/4Rx7A0wpNS1XfcROWyFZfIv\n\
dP59RETfhlPHJ5IKuYdhHnmc82m67q/CTCIzSOLQOPAgkcqHiPQe5oJi29RK\n\
mMi/67q+ApuqjoA7TuB6bNl5Z7k+S7aHzzb9ApX7Fv0+CGboRTo/0nVPwcr4\n\
Tczu/AhUJccowBiEve8S5o48ALfFAk0yhZiVCbHhKGf3Ecwfe5I4bYZA8UWY\n\
Jxci330fuozfQ5x2AgFmEPMHvgaHXAnN7UewEL+e+L4NdkEDbIIamHoruMkh\n\
7I/PPY3b9V9DxdRlTCoLMCw+hyu130a7MAW3Wh6GzMn3JTspaEtu/y0M7wPF\n\
7e7tsU34ZhcOI6V3fwwVRscEEuu+huqZeO7agwsnEFf9TUwblFFUfD2CirBJ\n\
CmsBmb47vCzrmwf27FSKs8yxJTaLZM6+nG8iqJqP9TSFSCgGnAo2+1OsVykc\n\
sFOL6dlteiLX+xzX+8X1XoX9/HfLNkm3T/0RekIG69pCXgVVj4z/JroBe8BG\n\
55hi5UMehhSNJ3Y/lv6CpHVDfkesayJoqSQK+wQ8kRAgdi2KsMKByAIJtkeO\n\
O88ZleUhMpCAS8V2jMUSq7JTDh3DOVDcfhHiCz/EwuHPYfbwVwkhZmrhX0NR\n\
lRhDiGvgCiHkYbg0AogPfekuhOjvPAPRrYMI6AdiCFGnPIbZA1+B9PozkF75\n\
GyRnf4gZohS7LJKgP+xG7eCzSO3bBp1dhKG57bjS8gS0DgXKuh9Fev9eKEyD\n\
qKYyl1of49xVUc9T6FUNQiq7hHN1X0KruAgqYyNSmr5GoqkAal0WEjtXw0vM\n\
WkXBaubAfugdIvRNb8DV1j/C4Au8HyEhxRA0e7dRSy+Paa3Qb14Nl0hzV97p\n\
yM+ycovRPsqlUX8KNxZtajYzVWTo7h54VDc5gmd/XOKN5GQ2sC4vmhA87JmG\n\
ZXoPEao7si30A6RPFqDKeptoiU8i5hq+SoLhftI4VmhTH4Pwwj9i8SWT+yzm\n\
T5FWM4kg2U9ioyyJr2GPAbIz90NWGI+AYTAiJMwwFrxE5Z+FPzKZxNZ8gFrq\n\
m3Rtd3RijscjQfXQy0gkxZrS9SIEen6zL6ttEPlkpklksgUDbyK58wkwFFx1\n\
CHZhyiCEmHTE9ZY/Iqfvb7jV+hPkjRyC3e8lHZFKDfM62M4it2seFYPP0bUf\n\
QWr3Kswa5iIhGz++SCpqtguG0zvBnDsOW0UuTNfPwD3YDO2218CcPQz9yV2w\n\
VrZQ3bvA7FkN3clDYE7ugTElmcsDHpSOwV5Txy2/clanQX98N51zCK5JTijD\n\
3ZIP5hh7bDddp4ndcXXFL6N4oKfz2bkcw9ymbWxjsD0rsrMPYv7Ew1Blvw7x\n\
sc+TB1yDYChEMcdjmN52L8RX/gjFzd9ieuu90He1cnmxRPtXkFf+KuRJz0Ea\n\
912CP5mGQk3etZfzrnalDSHjAMTHPw/h6d9Cmfw85nbeC1UFl4woarkBglRE\n\
Gy8NzbNkQZG41zWBzPZfQetxQaSuhY7CLaHoGJJ7DrOTfOALeGJwVaiTcLPj\n\
FbgXlyDMXjvanR5phfsib83ewnRiNZjb6fCO94HZvQraw3EIyMahWfs0TLkF\n\
cPdWQ73uJTjGxmDYQ3rw9GV4Rvqg3/EyTIWt8I/VwxB3CZ6hGqg3rYNrfByu\n\
qiRo9u2HTyygFl0DR/sQfFMddM3X4ZEb1kYgGDSLYWq5CG3pYRjaUuE18cOw\n\
7oVWCvyGYOm8Cm3ZMVgne7k3WCRqdggqyMAGYag7CV3VObgUfLLogK6Tr3AZ\n\
n9QuaBLC2HgOuspTsI5zGSv4vq//hsc1jZKBV2HyWlE/8jpG9WNQKG+icOQS\n\
2+8VWz/DFCFvaBc8i3yn7PvqzXZrN9XVfjj7+mDLioPhdjnChmloWaax8xVu\n\
zzwKY3oODAfegXNOxR3zdhVAf/oMPMMUqly9Atudk3TOQbh6O+HsaoClIBd+\n\
vQ5ewSgda4Y5/hDUa4nwNOYfLiOqaItGGWbZhLZY183yAZeHomjQtlNYQWpU\n\
ysSmKLABeRQl4XCQ3zY3zM6/Cyx1PVKZEO+GorURteWgaga24juwZCZAt/N1\n\
GBKpJpgpaPZspQCNfwZHxlEYUrKoJjYu1UR3AXQnThByqCauUU0UnIN663pY\n\
ywtgzb8J9Zp/wC2cg+nMFmh2vQtL/h24+gZYXbTUbxNywJl0mk2VGBl9/wXc\n\
Og/a7mhQm6pBTYYOFmcYGoENggFekNg1btTfVqMqUY3Bbgc3qjjbzKC5zIy5\n\
DhOqbqlRk6zG3IyHW549WqVH5S0V2spNcDkD6KO/3iCbVN2LviYrzDIXhjv5\n\
gQn9tAOTA05OJHVmaVCdqEJnrYXLTCdoMsBgCWK+1YiyG0o05WrR22znBk9G\n\
KvT0PCrU5zJweMIQ91qwMM13vAt76POs98HIKwdJqsqT3oKbsa944u6WcDek\n\
QnuUQniZGJYbe8HcLCFMzkD9ylMwZReT3TYTlp6FfWAQzA6y9VNn4J0ehX73\n\
KzDeqYV/ogmGq9cIey3QrH8dzqExOKsSoXp3BwJqGXTvriJX0g3vQCW0B/ci\n\
YPUttUSAgfHNx2G9XRFrCeu8DWlHJJAuuNGfo0ZtoRGTjQwaCi2cDTVclqKn\n\
3QGD3IWaeDV0TAC1ZyUYHrKh7roaUrEX4g4Gd+I1EHaakHdRBZXIjboEOfrb\n\
LSg4rQQ7OuHROJATr4VqiCRmKq+ZRFTbjfkGqlktKrONMKq9aExVQUit2pwo\n\
x1CbCXdOyyESujCUr0JWvA7CVgMK6V4GjQ8DeVqM9DvQm6dBbws/1aI7S81+\n\
juktB0NSjZvWsyJqmyEzQ5EcP9r/o7tbJ2wjLCadgHbHGugvnIVXacKiVQ1L\n\
zi2YEijk2b4GlrI6dloP7MUZMKdfhW4XhUg3k7iNBP3DNRzTsjXnbi2Efv8G\n\
6E8chXuaj3e8g7XQH9gA3e53Ye8c4PrQ+da5h9tA27T+j7Bl8P19i17v0gYG\n\
bE4eL8L8CHrE4n8B84wVzUU8m/r1ThQnaTBEptBWwUI9gJx9YlSl6tCWqyeY\n\
k/tUUAXHyaG1hqCfd6ApVY2Si3K0V5sxUqlDeyVvIgFPEFaNC4XnVGBDCa/O\n\
gfxbOqhHLKjI5jZSgbTNiOYcBi23ZMi7rEYr3YMzyVEX2tKU6CjSoraEF9V+\n\
xonSDD167qiRdVKOtjw9Gsi8B3ps6CvQYqiTN/u+XA0G2iP7Zd3D1aJn6BKY\n\
5JdgyPgnTLXXWWb5XuzrMByksrRH9xBJ7YWxqJqtML6ZYzO2/BQPMWfOcl2X\n\
SwkDg3DnkGeqaogNry66dHDcOkaGJaULW2B+52luWwz7lV0wbfs7zIc3wT0w\n\
En22RQvh+uZ+GLevgnHHK7BePgu/OrJcksxqzoaSBDU8/jC0BPni2xqM1+np\n\
mJ5kXQCVp8RorbdAMWNHzkERZoUeNFyQQan1ofaMGG11FkhGbUQwLsySOZYm\n\
6TkSFPaaMd5tQeFxOZRMCE6ZDbkJWqjHLMi5rILHF8ZcDYOmAgN6c1UoTWag\n\
nCdknJGgr8WOtlQF+ug58q+p4aay6kEj8m/rIajWI+eSCnIytfYkBWqKjegv\n\
IHLONsFP79CXo0F/mzO24pzCQu9UGZykLHySNhhS/wSvwYKwXQ7PXBOZF0VZ\n\
2ikyPwdCFiH8BgWJaS3CXj4yCtlUFPWEuc0fvaJWeMX9JBMXuf8Hzdrouvug\n\
cRae2QYEjDxhsMGdT9oOr2yQiinpEtGg8GvcvJ6gVg6/RMj/iufpPCvCTguC\n\
Nl6/s5Yfctrg6qqHo3cQ3rEOaI/toEd30b103FQFv3gK7olJ4nADvZqI2MNI\n\
r+GMnK8nM/dxz+EVDNGrzlG0pWdnstx/N+qCink4Ojrfhzo/rNt/D/P5Syui\n\
M8UWzfMwvP4oHHXsQIMN5k1PQ/+3n8J0eDdcFZkwb/4DdC//Dp4JOTdPxnpw\n\
FfQv/wr2nDS4ihJgeO1RMBvWcTunfyiCPduCHRn7RCgjh5h3WoaJcTck/Sak\n\
7RWhMscA8ZAFxZcUxAhK1N1hIBq3InmLEHXU5oNFGpQnqVFKLNHX5YDf4Uf1\n\
JRnnDPPOKLAw50TeITHyrypRdFaKtlobLGLC8HEJyul+OSelmJrywqlyoewi\n\
4ei2CkUJGpjJqfbmqiFT+tCZQceuK5F/SoJs1h5sPjTcVKKKGKGInktBZSYJ\n\
o2nEXg0VJgxVMpgYcPGv9w3O7N0DF6FPWglTzmvQnPseXLNDMCX/FqbyQzDd\n\
eRnaC0/BszAKY9JPYOmpIr2yFY6RIe5cc9GbJF+FFJsQb+dshClvJVHHaWrI\n\
HjBJ/C7uQTnxdOKTsFRR6Jrwe7jl83C1vwfdrRdgyn8d6gs/h0fJLIHPY4R+\n\
3ytQ7dhAXncr6aq3YSprgavuNphifqqJ9fZJWFq74ahMheYIXffMHsjfWQO3\n\
YBaGywdg7yJ1vnsLjLdvQLPzDWiuxJNmuw5jRR13viXhKGxd/bDlXIX60D7o\n\
L+6DYuN6imudEfD9ZhnQbHuegeXStdj6kkWyQuPa38HROMoDbcNTFCtso0CZ\n\
V39hZgbGN8ilkLbwDVRA/+yP4Wjqj0YowdlWYsGVcPXPxfagNE9b0XBHDxO5\n\
bSPDh8FB4gqvOwhLZJquy+yHTunlepECTj9KDoshlPo4fczI3ey+AbEeFS/F\n\
cQsu2O0hMjIvck8ooFP5oJV5udFKdn8pNuGeTe+FQRs57bPwuwJcET+XR2IR\n\
0lGyEna7TpKFRpUXumlixps6NmcamW0IOpkHThffGRqgy3FPawhAOeuAVumP\n\
oSzogDHtKQpetOziTJgynoVjtBFM/E9JHfcS+6USQtghDAmMt57jcmfayt9d\n\
QlkxxVSDJdBfeRhuyQj8inbYGs/Dq2gmlb2LQ5m99B8wlp+gwGiS4oircI6W\n\
UCzyDDx6csOLThgzX4BbplmaTeVioD+7HV57dB3Yl+GqvhFDmC35NMylRdCf\n\
2gq3lpSxVwvd0V3E0lMwXDlIUXYq1AeOwSeXwHLzAIx1HXDV3IKhnEeY9dYJ\n\
mCuKoTu1ndvsnJ3Ep6Oo3S23/VuEXV+x5BGXI4w097rf0xMVRacIOC78E4aD\n\
e+AqvAr9C4/A2dwI33g/fKO93F/vYAcCClUUcHa5k/SfNeIIoncl0IjJYwQW\n\
YwFUyONHRwED8qlLOpc85Ui5HmpjKBZi+/RutFeZuRE9vjfpIcy0mzA/Gemr\n\
4/Bgp3Z+moyZdxeWotVwCRfgncyHuew9wgOR8c3N1OYKYpaXOFDbyt4hXIxw\n\
5c0l6+AYKIIu7kEYSw7Q/7dBd/0xipBqKfbcyrd52d+hS3iG6vkIaf/HYao+\n\
DmPWi/BaeQMyF62FW6qOMcui2wD90Q0w1zTC2dMBRyfF82Yb3HW3qN2r+HZP\n\
OUvnUcx6YQ+3MTe7pIq5dBTOEQGYuD3wKFQUuaXCkEDR22bSK3XtkXbnpzNY\n\
E08SbijSO0/nO6LnH6fnsEbanf/zGYqDLHC4+dk3iyE7NPo6yHT0ZJHcpuyo\n\
lYZphNLQQ/LCCMbcR3EYv2jc5lxgJz8v5TP1KiHXVlLZPvgj0xFczhlI1KWQ\n\
6VvgC0az9H+Cx9teqrW4i0s5zd+Pt/V/gDWl5K7OGWccgW7PLrjyLkH//E9g\n\
fPd5mLa8COPml+jzX+nYT2FLL46Mm32D67G1V5FfKDoM11AS1KcfhEskgq1i\n\
M2x95eR3zkOfTIJB3ATdxZ/BrRDBXvEmdLdXE4+T3k8gV60m67rzPKwduUSX\n\
dN/k1fBpeqA5/gWYm5Lh7osHk0q8P08xdcqfCT3NsFWuhbH4GFyD16E5/0Nq\n\
sWW+xU2+5T2KR27dhDknBcaM2/S9liLJW8T/hLjuNuj2boC9bxTmhPfApGTD\n\
UZ0B+ZpX4RqfppbcR/5RAP3xg3BNTsB4fjNMDd2EgAQoNhF6e9qg3b0BjqFJ\n\
mK4d4M63V6dB8c5q8nHOuxBwP0xMFpqHyW+EKV4c+RPKuv6Mpv4/oajzzzC7\n\
LZideRVFHY+gaXAVKjq+i4LWX8LgccFmKkF2zccwqeF3GnM7x1Db+X3UDLyC\n\
6s7voHF8P4mEPlS0fgENw++gofeXaBgjPIaj3WRf5FFw4K9gtm5ghSKPAuvC\n\
3X5t/ZMwnTy6rLPFC9v+v8J45AA8TTnQP/djapVpbq8CduZpkJ26veph2As7\n\
HuNu8yAWPRTgt56HpfEyNy064HAjqOuHtZoesZIiBJ2IQvJsaE58DfapXmq8\n\
TTAW0neleyhs52cohq0EmrqjsNSchY/RUPTGwDmQSqH5FYqGzKQec6n8PjiG\n\
q7ilC4tuNexNp2FtYAH2V6J9bYz1ncT6Z+5m/YB4lIpXUfx5HaaScnJsixS7\n\
amDJS4apII9iyw74VRLoz+2Ez+yGp68OhluXYCoqRdBOzpI7vxKm1Oswl1ex\n\
XbQU86gozk2CKZe8xHu74YmxfrTtzUw2Wkf3wGiqRFHLj6AlWRzw2zE6dQhi\n\
4xx6+76Nzvl0suYwBNNvoHmCnxowKViJvOaHUD+yn5uNv7CwDeV9G4jHQ2Tx\n\
AvRMnIFIVYLRhQz4Ak6olNeQ3/YU7P67295+6AXon/kBLOeOknSfQEg3DeNb\n\
v4WjYYRv+3f/AP1LvyGFVYugSgp30WUq/z3YcisQJtYyvfMEDBvfhm92HiHl\n\
HGzHXoF+1W/YnYmjPTfsSsswn2A5skP9R9ipsLCWneAe3Va2ie1mjSWCZAMh\n\
c/6aZZR9T8Rg3yKDfw/6uGPQnTkIU017LLmug7zymd0s4y95LDip6GFqduuK\n\
D6j0Nqp0lS4dd+o/j6bht9A6vBoN/X/BpGoIRl0W6np+hYbB11Dd9TO0T2VS\n\
PKJGZfvDEGtrUdX5a+hdNkxP/RN5rT9B28haOv9N1A+8Cq1diKm5LSjv+BVK\n\
O36IIXEOt540OnmN7UOwH18N04GtpP6eIeN5Et6JPph3rYSzjR2MsMOy/1WY\n\
926EcQNV/gs/IUr9OSznTyLk4gfggrNdMG19lhrmEej//mswbz0DZ2NrZNCP\n\
HBy5B2VuIaxa3oUYm+qwkFoL68gwJIUtkQUFQWjLy6AbYKMgPzTFxZg4FIfx\n\
w1cgrxmMzVmx9nVhIbmGy78Q0JLSvElUqOcHWPTV1dD28j3RYacR4tsFcFq8\n\
0TVCQaOIQkPO+S3tEUtNHtALEfL6lxo3HIBfJoRnepL/nRqHT62PSRT2awU7\n\
XLm4bOIaRZUkuULe4Ac1buvIHlisjShs+jrEjJDEqQR1bf8bg/J2GJgijIpL\n\
uY2ThideRetkKnSaeJR0PQs/1czg8BPoE1VCJjuCYjpmphczMeUoaH4YU6Ir\n\
yOeuOQ2TsRcCaQk3My86340bvDBoKBZ3club+Ui5hp1uhIwMxekB7u1DRj3C\n\
JK1CjIKiglb4pqdYuloRzZKz6LLAP95DIq6fAmbb56Nt6ndhajcJHAURhHYB\n\
g69vhbh6DOaWWgwdSIpsROaH8PhJSErHYe6oRd/qw1B3TsDQ1oyBt/ZBMyDj\n\
2kocdx6dq/bCZvHDXFeOzr+sg6yRX8skiovDfB6fRCFolmFoPVma2vHuv1Zy\n\
M7eHRwCT0+tR2vlb1Pc+joreF2Dze6jC7qCk9XtoHHoW5e0/xai0lir2aXTM\n\
5nFX1qrjUd67moSPBO19j6Kq92lUdv4crYIrcLsoRu2l6w0+Q+d+D52zidzE\n\
3NiAJbvzVdxOuAfnV3yTO/ZJbvf4mb1HIasbhPjCBYwcSecQa6XaGTmcGqmd\n\
ABbOnoekeBCSq3GYy+6KbvGouJ0AQXIdxUgmTGw9jIHNJ6DpnoE8OQmDGw5h\n\
MqGcr7irV7BQ2M1XjkWOkU1H2Y0R76qcj1LlZJKv3siFR2zTMsZOyPXtcPsD\n\
sU4Ku2MKUk0RtJZ5dqwVVtscXH6+5zscojjFtsCRI5tFX0WKUGWcjM0v9XlU\n\
kGny6Ngwe2xp4MNGKmn/K3B2CpYqJuDC7J5D6HrxHfS8dhBmOT/YZGmuoUpK\n\
i0xFCEJ07gJRwwDEl6iCysejFaMrzqOKqYV9uAsje5OgzCrA9NU0TB44B1V7\n\
J0Z3XILX5YXkGlVMMT/RJGhTRCuG71S9j8yU1O+EFNLOWWgEGm5cgHtTnw82\n\
lRXR9Pteox1Os4d8L388TCGtW2+F2xbZxjdA5Kk0c+WDbjfUQwtQjijgsXtg\n\
WVCzt4y0AkUxRjUCDN9N/b3lDfRhik1L0TF2kMv5HfVS/MbV/JD35yPHolMn\n\
EesfvjslcSygIPTNHjqJ+fRCDK8/AHkTb0vWtnr0rz0Om4YlQS9mDp2AtHwM\n\
mjupGDmewQW47BRS4ZmzmL3TBEU61ezNWnjEExhYvR0DW67DY7NCsPc4dKMy\n\
yBKvY/RMDld9fvUcht4+yL4y/xhfgVejQ8eBHJSuy0TzgWJUrk9B04kmOCn6\n\
d0vmUbm5APbIvoSCm9XozB6HQ7KAqi2FFFn4MHihECOV/EiyV6tG9aY7YHQO\n\
jF0uQeWmHLQeKUX9vnyUvZGE8UYJPyzI9hmT5Cg7C+bUehjOroOlOJetyO/e\n\
XefhkJduwudl5cH5IJfz00wBvvLWi1AlroQqfRMF2QyCeuKsFn7fGp+sFeqk\n\
V6DO2gd98R7oW7LglXZDdeslKr8N2oLTFKDZYWtPgdfmIskmgjbtVShvvw5d\n\
JbuHZgi2tgtwatn+zjDJuItQ3Pg71NnvQFeTzHZxfmhZM84cPAmDwg47hc4D\n\
q/dB1jIFS3sj+l7djpHdFyB47zx6Vx8EM2dEQCPB2JaDGDt0nY6fI9Y4RyhU\n\
YGrnQcjqp7lobmztNoxd5Ve5SeOvYSatGuLEm0TNBzB+5CrGNh/E0M54MqLA\n\
hyLcyirHkQtFKN9WAoMqMktCqULDxmR0pE3AIRWiemsBcSfflFOJ1eiKNGX1\n\
NmpKrw9DcYUYjTalXoXarblQi3RoeDsFs338bFJFbSdBoohoB7HJwOy0Is9w\n\
C/xKPrvZosdM/2+Ee2yA70xmW5sRU8BVC69wjjdiO8N1SnO2TwohyKgRNBj4\n\
4zYLf45JSWXoWn2VcPV1kHOrI7y8RkLatyIClD/EQOGC+sIjYFpy4ZhsoSh9\n\
N8SX18E1UQl5ylqOFQ13VkKZkwyvchDykw/CMNQE1eXHYeiu4tb0iPb9BC5G\n\
DybzbfprIo3+FpR51wjVQqjin4axtw9MxvMwi6WkeHshPk3KeGEClro9EJ1/\n\
hd0FPhrycqA4cAI6ET/u4hYvwDwth5/e0CFVwTE/R5jsg3VeGevF8xtIjjZ3\n\
QtvcT7d3cARrm5wlnLI9eBRCz83DqeFrxkeGZpdq4JYr4VIzMA+OQN8xzM6P\n\
ieUlshpRtYYarl8by/ujaRlAy5lWmOZmUbOtgBs9/U9gGKsSxsBQsyUHBr0D\n\
U7erUUnA6L7ahMH4SipPYPBFcws9gLBhFsyBF2C6dRC63c/DNTIISzxF8vFH\n\
YYp7E8bUFGrwGTB7qSYzzoE5/BLsvYPwNMTD3t1HNTsK3Y7n4WjJ4Ubw3LUX\n\
YS7jBYA9eSvs7a1wVlwgIGyk662FetOf4FXYInj4TISKPTojFOSLFf1ieFwB\n\
zmc4dZEVE6StHNp//exS6aDsnYdZYaaKpkqVGqhCrQj4Qtymxy6rN5pVILyM\n\
z2MdYCQdfHymn0hlPMh1Hmqu/AEOHb8+PMiQszz9IhFFMRSZmzlYukaSobi+\n\
CtrcHZCe+gnMggbIL77BbqvKtbvu1kp6DC0MOVvg0umhT6eKW+BTZtpbz0CT\n\
nQgm5xVYFTr45wuhyNrFP5l9irh/KyvTo31vnBzcdRjaBWMkqPowPAoJKt7N\n\
hFbnjeGEXUEa9AfhFM2RsefBFsk/OX27Bp1ZY/+Ck4FiPmWu36RBzeY7MBh9\n\
cCi05LnnIG2fxvCNClRtvRsn3tbLMKTwK6p8o/UUvN+C/sA2fpW4Qw4DGbo1\n\
5xjXy8L+BOaqoT91Cu66azBnX4HlypuwlFUjpOqFgcTbcpw4UnfCVpEF4/lX\n\
4WVzoPg0YI6/Bo/UHMHJpyNv6tNq0LotCV2X69B3Oh8d11qhH6YI+lwd9yRM\n\
9zDajtdyToXpHkLH6SauEdq2J6PrfAU6j+WjZu1NjBQMEf2WEF1aoKxrxVDp\n\
3IpoljcutW+DHgOzXna5DspLdJAb+VmKrHGX56pwLV6GvCI9Kkq1EOrJ8NVu\n\
lFQY2N5UTPYZkZCoxIzCi4FWPa5T2WvXZcgtM7CbBH4ohjUvNJd+AFn8P6DO\n\
WA/Roa9DVX4HfmkzJGf/CI/RDK+IQpmGXLjmuyE//wOYBJ1QXvgjbAsyhOwz\n\
kJ14jMMak72RzIUhzP2TOKma0ziGvDUU+xURBT4HbVMlfJJGSNiJzw4XvFNZ\n\
pI7XLlHghzmHZBufgtfpX9Z3sEgkP8eNKrACIKCfYmM6nuyt/A4PIRv9dUdG\n\
Jx0K4jE13/66cXjVoogZCeAcK4ZHMsarr4AdAbM6tsuLWobytzOgkrkiC6o/\n\
B5dEiNI3EtGV1AfdpAzN29LQVzTD+cXKTflwEZSHLxWgaN0diPulEOa3kCTK\n\
Juj7SF1VoOFsM8lgIx1vQvmWYpLly6DcGAdjDr8Sl/V9vrEy6N/by3d9BW1E\n\
U2/BfHs/TAU5XJmwZgDMwX1wNd2C5s2HoNm0iq05hNhAMwrl0kIeymm7YSvL\n\
hPHSmsiidoqTLm8ktWd8H5QdEhkEJcMk9D0w9I+hbm8B5GR8/XE8lA29w+g4\n\
yfeKMT3DBF96o5kF1G+lq+tc8JEHbt6RC7POiYnzxVCLCcr1rRgunb8Lyvk3\n\
JChsJf9Ecvv8aREmFXwDTnTrceCYBP1jdlQWqLBzF5mRyAdm1oqT5+SwkvIo\n\
pHPTy42YHTXjyJEF9Iw7IRM7EX9+AaXt9iUou4g2n4Blegx+vRzG4o3kuS/B\n\
rx2G7OyPIbu+hrBVAcW1v0FN3loe/ypJXhc3LVR64S9Q3nwGovd+AUt/KWRH\n\
vw91RTq8ki7IL/8BSpKFsmuvw2O2wlT4JkQnHgXTmgdj+Q667t+Jeh+F6PJa\n\
NhkMHzt+iQxLA/WpL8LYUk0UqoDy+P/A3NXGvbWlaj1sE2Ow1r4D69gEd8zZ\n\
ugm6svfI6TDQnPsK9NUJ8Amrobr0Q+jukMuK+zYMTRkIqBpI1R/kAvlopBB0\n\
WlFPemu4Yj5Gx9q2UfSnjsImnEfVu9novliDxl15aDlZD7PeCx+55/6ETvgC\n\
QcwVdWE4vQvtR4pRv7sAE5VzXIt71BoitXI07MlH48FSzPcply0iewBBaSd0\n\
u16As7cepjP/IGrNgunEKthqyuGsvAD9ye3wznRAv38VXIOtsN54G8bsPHga\n\
b8JanQfz9fUw52eRB2oCc/os0fQFaLb+lcLKSk4OOIdGYEt6l9z/dbreZajX\n\
Pw6PzPI+DLNp2BYKWtC8J5Pe8A4mq6ZgnphH74VaHsN9hOHT/LQcQ+8IfW4g\n\
P+nFdHI12o4VoTeuFLWbWAw7/iOGixOlKGnnMXzpvBhTSh7D/U0aJGTxSnfR\n\
6UXcGcLogg+GORvOXVRwGGbPZXHtsfkxv+AGY/BhfNiM8yeEKGywxrJlc4r0\n\
lzD2lJKxdkOXvgry1L1caBHyeYmvtPR5EWGXiXzwHLviNxbnE5eRHBRBFfck\n\
nCoZdLefhb6bHyMKOY1wy2boGpF57l4P8SbxnzUiDcle2FERyY0NrOtfEQWx\n\
X1QGxdFPUuhzFN65ciiOfAqavEM8iKvfIRCPw1q3iUDMz212tW0lEB8lLhZB\n\
ffFP8BNBmvP+Bn35TYq0A/DJW2CoTIZPWglNzpFlIOYTs4kLWlH4WhqmGoWw\n\
qkzQ9E+THr2F7lwBURVPuk5vmK2PqMvwW0wQNs/AH1z8wEnlUWkbogj77k1/\n\
7odvgmwh8T1Yqwq5TvigZgLW9BMwZ10lJ8+nk/KzZZIOw1rKLoHww1N3ieRk\n\
J8fZjoZ8oogZuAeHEZCNwNlRAuud87BVF3Gd8osODezF12ErTycbaaJmiMUg\n\
UfC6FkSoWZcE6YgGNokS83UCEnMLaNyeBYuFiLBnkFR0HpzsQHlrL9pO1NOr\n\
uCHI6QIjNVMUKETD1hyY1Pb//+C9IIZAzYN3oJnAmxFZCRwOIPGSGN0fAN7O\n\
OS/RGOmQHCWOHl9A3GUZSutMbMLWpQlfFGNXn4AqdRP9vgNN/il4DeaPx772\n\
wURGzCaKd/Vfh+rOUbaSYh3r1gXiPDaR0BL8bA27oM+hkCB5NQyF28EUkXJN\n\
eJ7bGspaszECv82wTkzz8GvfDl3pEWonMTSX/0y+zwZj+mNQXf8D9Hkb6Fpv\n\
EJduh3uhBJqsg8vyjn+cS6MnLO4kKZpJsjMLlRuz0Js2AB/BzaOUoYPEncsT\n\
jsKJ3Xq47UwNSYBwpOPhHrjrr8HW2oroT0g7Dkt6xs/vbnE2W0r/2QJ0HC9F\n\
y850DGQPwyaSoXFjElqPFlLLp6FpVzbaDuej7p0kjJXNcJOFxy8Xo2l/PrpJ\n\
PTYdq4LT7sPEuaL/2OLFndTiAR/izgqRVUVSjkKN/68Wt3n5Fu9e8FMU68Sx\n\
g/OkQokviIOaKnWY0wT4Tq77OJ2iv/UT2AQU0Bb8BdJjX4VTLIIpi9Th1ARH\n\
DVwbVb8JPdkBuxDRWv4q9DXxCHukUF8iivD4YSl5mXzaPgRsNriHLkNx/nmi\n\
v1ooz/4SbqWco4no4hCf3UlC10SBlTtm28tWP0Z62e5B2GqIzRzjmNlrI98Z\n\
2bPqXoQMAngF5fCJesDPug4iZBLxmciCToSMUp4prSISqhUIKKdiCU6DKoLF\n\
bCM34sBOmQ9ZeaoIW4Ts/LfI3jDRqDJIpXTDIugEGq5fleVxJ2ODTUahu0BF\n\
zUMVIFTSZzWC0c1Bqc0Mk1JoRmRwO/h8jKOnCiKRQguGSuaiTS0aN+HYYSGO\n\
n5dhbMaOqxdEnEq6nq5FXYUKN9J1fHhETR1/XoQuIZHKvA3nL8nRWqfDiSNC\n\
nLsqh0DoREqCBNduKnArQYpjZ9hUfsFoU4eMwyRFnqTmCsDZcxSKs09zwauj\n\
7TCYqgRYmw/DNj0NW/27UJz7ObRJf4Di9LdgF/TTsS2QH/4k9LXZCGh6ob32\n\
KH3/LF3vEZh76hHUdUN14SFq9l/APimINWuA+EZKkVgwttjis1xQISP54qWD\n\
CpUL7ZMWDIldYKcjOh0BmLhU8IsQKZzombVDY/VDqnZByU5lMvkRzVqlI261\n\
eiIT/74I/3QmTNd+AVvJPvIAf4a14DC306c95wUEKJANGwfo+GoEjFOwJv8Z\n\
jrqzsKX9Ca6xNgSmM2BJfhb20o2wZK8hxVMEe0MW8R0D681fwD05FIHEgzHv\n\
E4bgaiW0civUbd0YrxHFdJvd5EVinBgpxUZYHEEoFB7otV4IZl3Q67xQqqM7\n\
BC9CKXVzBM2mip6ZdUKrcuMmtX9+vZklZk5tjA0T3QzYoDMHV3w/0piLPjtJ\n\
ZH7PpbDbDD/Dh0thF302aeGV9sBnMhGwtWRDRngWGuFV8pmC/LJqKE79CE4i\n\
QO4cpxae2SZ4NTL+sfxsWGWAXz2GgMUUa0yX1YWt8QsY0QVijSkTGrEhUYLW\n\
IQZbby4goVaDo2kipA9Y0dGuQf6gDeI5E7beWsClUiWOZIix7qoQNWNmXMom\n\
icP11YdxtVCKcoHrwxGLYyN3mLrpr5VAIeayBcKxECFlx7LP9qXPi3QtA8Xs\n\
qhI6xndJImjFoq4ci4o8kHPmL/8ldkI1rLd/DfcEn+CaXhO2lCfg7MqFveCf\n\
EbwMwpa9Hp7e87BkbkZQPQLfZAYphXI4cl+DZ5qfSOEZLoB3jCLG/L1w1a6F\n\
tfgkN608AphvcH/Y/SzcCLJ7AZFsJQuM6v7aLDkOk53O/p+2rjS4res6q+M6\n\
/dNMp0l/ZJLMdJr8a2eaejyt07QTu6ljj2OnjtJYXhVZlhRLluSIFk3S1EKR\n\
EilSJCXuuxZSliiJpEiKEinuCwhwAwkuAAli5wKA2B+WR4AAga/nLYBIu/zz\n\
Hh8e8O675zvnfOfec89d3xLTrJ6HVe1FadUa/MRn+pvNUKxs7fm5eD/TnUq2\n\
WiX+qHAtFiYnLrnL7woYH6nimlDbZEBBt51ktWILkqyqmo3IeWrHJFf2ddEH\n\
nz+Mzr41pLRY0T9gQZOcgXTEglSK4tzsNrRqB5JurYEh85Vfb0jIqviBAe1z\n\
gcSokfIAooP/xteciUn3EmWaRWz0TaHwn28Q0aE3xPM+On+L32Y4tniEzn+B\n\
qHw/ogMvIOZQIDb/AV37NaKzx+naS4g5dQk6GHVOkdLu5cLlBFuOOpWIrI6D\n\
+fodhFkuE0UBpv4TEthlOK+9yiu49+5eeIjteu9+guCyOPnMkMXWtsKZ+yPY\n\
c/6RVMcXXw75T+LjfKTBkmGuZv2zSsSbZIaUpMFb288yimMBhjTMt0Maf42I\n\
0wp2cRGsSoXAkpbIuGCvuNxlZnwCASIKIbuTvKefSLstHjcEtSp4RqXYXLOL\n\
t1vBSKUIUHgfJN4cNHvoUcJPsDoT/YQjMcEdpTiA4+aifeXNoW7RgY8KFpFK\n\
SnaelO69fDWGjCGCdhDVbSYkVWv5z4YMm5AMWdBIChvwbKK0yYisuyZk3zEg\n\
qWENHq8g/I0tQfglBKq2HcKf+V/EjBSZbWlF4c/R8X8EgftJ+MNxIPQjKtlL\n\
1xYQ7f97AouRS/9ETEecwtCG2HIJ4HXxn8dG/gUx09NdwndX/TeI3om26PvU\n\
82ayzD+DtzMf7EA6cfY0RDYm4Kl4k0jBE/gfvAfvwAMERzNIew8jOHubYoC3\n\
SXtvgemsQKDnCwJGCrerV1xTXxcftzX9GI6UwwitOkSh/hiOxiIsHj0FQ1Ym\n\
dKnJ0OdWYYshT37hDAz5pdB/+Tl0RXXYXJDCUFzOkxl2sgfalHOwNNRDm5YG\n\
76Iea1lpMFXWYa00D0uHjsMtm+N/w1hYBv3pE9Bdq9m55nErEoxP5CZwGCUW\n\
sHsd5HP8xHFESNQQ7/sBIhS4nanRoN8QhEphw9FqI/x0y5TUjCM1Rugofp1X\n\
ujCoCWCYAHCXAODzsKjts8NBXmeKvvP5jVUwBIDzlRr06IN8revMG1p0a4IJ\n\
ACjeIQE+IQBoRADM0/E1QeiBIQLAbwVux4FB8nvEGGJr3X+D2ARpvvwgouO/\n\
QXS5kQDRjqjs52RJ/pmuH6XucyeqPceChPvq/0BAPiKY62gA/tajYKfbyL2/\n\
Cf9AEXwdGdgyCw4xYuqF/3EGxShNpBfcKgc/gmOl8LamI6hRILLyCMyT6/zQ\n\
aXCqHluW9TgI/p0//C22N4z0FKGm+Paaji8Ztr2+hE1JL8IrK9hS08/YyLfa\n\
zEQa7di2uUQnRD67OR/u0pod4CmFdUAwPlzWhSn9JBxTkzB8dRncLH5wtgeG\n\
0lqwCzIYy/j8BViLiaBdbwdLRsv5qAkuqZy+l4SN7lFiLEPQJueS9TBCn5ID\n\
ahp5oSfQl+yoD/tD4l7raJs+hnLpEVTKDmHGJkw0m8lHNs4W8xkHRusD3F+o\n\
EvcAjGBSW4gKyX76zkEMrY3xgjNZ21ElPYByut66VI8QoW8zoEL92AGMrEm/\n\
IwKhjdu9rseG2lYjigaE3rCZfUi7oUfWPROOEwPo1rAYl23wnibEhnCRmEL6\n\
HRPO3NDhSqed377vUq0Gp28a8BV9drzGACOz/WyCYoYD22MRbG8j5leRq6Dr\n\
TrIm3gFEe/+BAObgRjYEV8Pq6fMfk4UapG62IzrxIqLz2QS+/yJ3c5kAakNM\n\
W0rfsYrPoNCAIkt38S/A3P0j8cXX4K4n37+hIRfyASKbiNvciIkw1Hmd/+9H\n\
O7HzXfjLjsE/ycWz2/Cc+xib0xK40j4khlEC94VDsJ3aD3bwIdzlFxDoqCMm\n\
0pTQZLYxA9b9exHxxavrE37ulcJY0QivfIqwcB+6lBT49GoYz+ZRLLVNQeoC\n\
TNcbCD9kfK6W8UKzFp+FJjWHYuRb0KedgrlJAlY5BvPNeqxeyYL6RBZCFooP\n\
0vP4FfCRVQWMNTd34kdlLEex7CTWvSZMa3KRN3qaN0aD88dxquMlmFgvehUf\n\
I+nxy1gnLXPY25DT9wfMO5RYNjejcPggNM5pFPW/jv6VQay6Zage+T0myPRb\n\
zQ3IHjyM9YAjvimA3czgT0VqHChahtwSjieVuF1BTC77oN0QsjrMFAmoBSZC\n\
cAlDofNhboVFiGsat6iB3LTTE8K01k+RQyQRTjvaEO2j0H3kDcTsk4hNHiL0\n\
LBNKforo6Ct0fIFM1c/o/Ffkn36CqCKXN1uxlWtkkl5ETEb3jLxC5o3Cbn06\n\
nb9M116i46uEIiZeRy3q1iKkophUMyxYHq6mqM3Ar61P1GkNcZ7c/m3kfA/+\n\
iuPwywXkMBnEPce74Uz6EOzYBIJdVXBdzURYLYW77ALYx9fB3GgRjEqIIo2z\n\
R+BMP0iOVh4HjpOAozlfAEvjXZgyvoQuv5r4px260yR8hgPOHIzVRGlVY1jc\n\
/xHWGx/B1dUE/bkCMLJRGMhrOWf0cD6oxurtDjDDj7CcfJk3PLrTl7g8KgLO\n\
NAwVtTuBwwYtUFl6MaAuQtnwGyiXX0WIiHg9Cf+a5GN0aTrx9ehHdP4hBtYW\n\
MKfLxcWhgxg1tkJmaMbTxZsY19Ygu+d1DOiaMWZoQc9iJRYcOpgJOMXjuVwq\n\
Uhw4XDJO7X090VYzKGKKjzJIR61okfPrKUVW/F1uphKx8V8ipiK2EXIhRq3k\n\
SlUgsMHVpCBkSPjBFnBOzD7ITds92xPFS8zExtkRcVdbboTSTSZyg5xfKPCv\n\
OyX5ffjLSZJTQjlB5twBBImyBfuaKOIshOv8fjjyziO8NCpKkmxAVSN/b3ia\n\
bH0eiWfsIX+MJQJnwY9Y+oQ8irBxDOpT5+klPEQbp4hlUmsCdjBzKordrHAP\n\
9cP2kIDIEM8nn7Vedyu+wTox1HXY7t/GOtkCr9qEWCQAj2SS4+WI+sjVziq5\n\
++LitNkfI7fnP3FrJgcyEpHOQ+GBuwcFki8wa6jH1f63UDKRTRpXifrZUrpW\n\
jIzefRjU3YdEW4vc3pfRrixDTu8v0bncAKm+EWUUEzzUdVE4/IDEmceJM56x\n\
FwpG+AFiYMeIUWgb7K459t0jxMJ3n0fM3EbdbSI5k92f+JhToz2vfUMwZUdh\n\
/+ok2L77cJzYj7DVBubKSfi7uhBovARXITnUpWFyAWfBPqmGdd8r8HU9hbfw\n\
M3hbBrl1vnB+/j6xQ1di5Y2zqQLqL85gpbAAurQvyXG3cGmzPxA7cM3SiKy+\n\
d7HomMJjxSncUd7CmPoCKqfz4A8s4mzHT9CgbIDfL0fe0CHo7SPIp04dXHmK\n\
KV0Bcgd+B5NXgxvDv0GTqh4q80Pq1DcgsygxtnQOlwYPYcVn+btEl20jKGmE\n\
I+MQHJmH4blzk+hLLFGskhvCE1apfKtvKk/AU1cMb90VsLJxHmjbpjn46q9R\n\
lFWL8LqDXOUqhbsTpPdqsL3N8D9qBtvdQYG2oBahsU5sWeN98zwiLjtYrRas\n\
RgPWuMpR10TqRGR7KzGgn0jY5HJ+xYrVfyl2YJRb66ApQZnkHdyczsYG68Kc\n\
8TamLNycRRB9ykLM201cFj/6VWWwEvVdt/Xg5tgh1E0kQ+kU5o+9/nmiHidR\n\
IfsMktVRCuVcuDe2D+ldv8KEdSaR5RFMLEkSx5a/w1sLd/4x+AZGEdbL4Uj6\n\
LfyS2b07O/A56sA/IzCr3YXdbSOFqHeu8yPVgoi4ZTw+tCqvIkOSjIvSdIyT\n\
ZQsFjahfagKfmxPbRPtCAdQBL9w+JQplybhE99UoitCi5+fERML6HDYIXTXT\n\
5Xx+4l+JguQg4G+vRNDACUwHT+GnsJ87CEdWMgnHg6h5Ekxri1AxhCUFqEtH\n\
mKL88NII3Hmfkp9JhSNtH7yPOvd84xW3N9awHQjuesVY0IeImV8inHjFcX0d\n\
kofToWYMGDfcQoY0jxiAHGdlefBx4o36UTT0RwzbNaiW/QlXFA3QuhZQMPIR\n\
zkwW8a8Tf8VIhIVPWOG04xXDpKOfIaDQwVdFr5d9lrReDW/lMdiys7Gl7IC9\n\
oEB4RWIw9lO/xiZ97jz9KgV+dxGa7MDGgZfAPO6Nv+J7/OF7PATvTZ/GWekl\n\
ip660KtvQ9NiM4xk7S+MXxW2qqTml48cRp9lElmDR6FmBfgvGBtwaeoqNQ4/\n\
3dFST/kpBCZm4c56nwAijE1FbTOwnXwfmxPNcJSUiC1dpdjzLbCKAdg//5AL\n\
efk/f10qmLaOb7c0hpbZdHwpSUMftbRzqRaf9R4hqj+CM6NZ8PB6xOLa8BGM\n\
2BS4OHAEs16hxoBCfx0X/7+WJiEwOQ9X5j74x8WkvQ05bCfexeZkC/VzptDS\n\
ALU0+W0+4rWd+APBRyzWXpeys6Xvi3BYNrcjue9TDK/L0LqQi9OSPFiYBRzr\n\
ehslc7cxrK/Hse5PsBL0oHUmDanSi6Si3TjT9w4uyMt4OOxqZtmfie+ugG3K\n\
xEYSMSW5BJ4rB2HLuUIMqQeWd18Ec+8O/PczYT1OHel3w33xd3AU55DZ+hrW\n\
D14A8+jpN5vJ8bXZ1XbkyVJRNFMBg9/DFz9sU99Di7KSlPULtBqlfCZ0iDzB\n\
/bl85E3mom7qDHKnS7jO/FYzAwqyTGEf/Pcuw/HVe3CVFSLs9lOvLpJHuUnK\n\
lwHH+QMIjAsDilHHMpiyFDivZcDXdhvBJW28mZ+KCrFIxi9z4sqOxz0nKEQR\n\
RR5y3Z6Du2+3eVQYNct5s/HsdvIS8n7OHMRv9+467PmL/wNPEFz+"]]}], "}"}]], 
        "ExerciseOutput", Selectable -> False, Copyable -> False, Editable -> 
        False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"36cd8aad-0c13-4a2d-910f-faea99767041"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Make a list of histograms of the word lengths in Wikipedia articles on \
apple, peach and pear.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "26.7", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"b625477f-c403-4c74-94c3-90eddf16f798"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Sample", " ", "expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       RowBox[{"{", 
        RowBox[{
         GraphicsBox[{
           {RGBColor[0.987148, 0.8073604000000001, 0.49470040000000004`], 
            EdgeForm[{Opacity[0.5389999999999999], Thickness[Small]}], {}, 
            {RGBColor[0.987148, 0.8073604000000001, 0.49470040000000004`], 
             EdgeForm[{Opacity[0.5389999999999999], Thickness[Small]}], 
             TagBox[
              TooltipBox[
               TagBox[
                DynamicBox[{
                  FEPrivate`If[
                   CurrentValue["MouseOver"], 
                   EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                  RectangleBox[{1., 0}, {2., 116}, "RoundingRadius" -> 0]},
                 
                 ImageSizeCache->{{23.94855884707766, 34.445127530595904`}, {
                  36.87182743465587, 55.19557447059147}}],
                StatusArea[#, 116]& ,
                TagBoxNote->"116"],
               StyleBox["116", {}, StripOnInput -> False]],
              Annotation[#, 
               Style[116, {}], "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                DynamicBox[{
                  FEPrivate`If[
                   CurrentValue["MouseOver"], 
                   EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                  RectangleBox[{2., 0}, {3., 760}, "RoundingRadius" -> 0]},
                 
                 ImageSizeCache->{{33.945127530595904`, 
                  44.441696214114145`}, {-62.080699213124475`, 
                  55.19557447059147}}],
                StatusArea[#, 760]& ,
                TagBoxNote->"760"],
               StyleBox["760", {}, StripOnInput -> False]],
              Annotation[#, 
               Style[760, {}], "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                DynamicBox[{
                  FEPrivate`If[
                   CurrentValue["MouseOver"], 
                   EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                  RectangleBox[{3., 0}, {4., 818}, "RoundingRadius" -> 0]},
                 
                 ImageSizeCache->{{43.941696214114145`, 
                  54.438264897632386`}, {-70.99257273109228, 
                  55.19557447059147}}],
                StatusArea[#, 818]& ,
                TagBoxNote->"818"],
               StyleBox["818", {}, StripOnInput -> False]],
              Annotation[#, 
               Style[818, {}], "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                DynamicBox[{
                  FEPrivate`If[
                   CurrentValue["MouseOver"], 
                   EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                  RectangleBox[{4., 0}, {5., 731}, "RoundingRadius" -> 0]},
                 
                 ImageSizeCache->{{53.938264897632386`, 
                  64.43483358115063}, {-57.62476245414058, 
                  55.19557447059147}}],
                StatusArea[#, 731]& ,
                TagBoxNote->"731"],
               StyleBox["731", {}, StripOnInput -> False]],
              Annotation[#, 
               Style[731, {}], "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                DynamicBox[{
                  FEPrivate`If[
                   CurrentValue["MouseOver"], 
                   EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                  RectangleBox[{5., 0}, {6., 692}, "RoundingRadius" -> 0]},
                 
                 ImageSizeCache->{{63.93483358115063, 
                  74.43140226466888}, {-51.632295778265686`, 
                  55.19557447059147}}],
                StatusArea[#, 692]& ,
                TagBoxNote->"692"],
               StyleBox["692", {}, StripOnInput -> False]],
              Annotation[#, 
               Style[692, {}], "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                DynamicBox[{
                  FEPrivate`If[
                   CurrentValue["MouseOver"], 
                   EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                  RectangleBox[{6., 0}, {7., 488}, "RoundingRadius" -> 0]},
                 
                 ImageSizeCache->{{73.93140226466888, 
                  84.42797094818711}, {-20.287085473689302`, 
                  55.19557447059147}}],
                StatusArea[#, 488]& ,
                TagBoxNote->"488"],
               StyleBox["488", {}, StripOnInput -> False]],
              Annotation[#, 
               Style[488, {}], "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                DynamicBox[{
                  FEPrivate`If[
                   CurrentValue["MouseOver"], 
                   EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                  RectangleBox[{7., 0}, {8., 402}, "RoundingRadius" -> 0]},
                 
                 ImageSizeCache->{{83.92797094818711, 
                  94.42453963170536}, {-7.072928188426708, 
                  55.19557447059147}}],
                StatusArea[#, 402]& ,
                TagBoxNote->"402"],
               StyleBox["402", {}, StripOnInput -> False]],
              Annotation[#, 
               Style[402, {}], "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                DynamicBox[{
                  FEPrivate`If[
                   CurrentValue["MouseOver"], 
                   EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                  RectangleBox[{8., 0}, {9., 267}, "RoundingRadius" -> 0]},
                 
                 ImageSizeCache->{{93.92453963170536, 104.4211083152236}, {
                  13.670225689601786`, 55.19557447059147}}],
                StatusArea[#, 267]& ,
                TagBoxNote->"267"],
               StyleBox["267", {}, StripOnInput -> False]],
              Annotation[#, 
               Style[267, {}], "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                DynamicBox[{
                  FEPrivate`If[
                   CurrentValue["MouseOver"], 
                   EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                  RectangleBox[{9., 0}, {10., 298}, "RoundingRadius" -> 0]},
                 
                 ImageSizeCache->{{103.9211083152236, 114.41767699874184`}, {
                  8.90698294723969, 55.19557447059147}}],
                StatusArea[#, 298]& ,
                TagBoxNote->"298"],
               StyleBox["298", {}, StripOnInput -> False]],
              Annotation[#, 
               Style[298, {}], "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                DynamicBox[{
                  FEPrivate`If[
                   CurrentValue["MouseOver"], 
                   EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                  RectangleBox[{10., 0}, {11., 172}, "RoundingRadius" -> 0]},
                 
                 ImageSizeCache->{{113.91767699874184`, 
                  124.41424568226009`}, {28.26725990006628, 
                  55.19557447059147}}],
                StatusArea[#, 172]& ,
                TagBoxNote->"172"],
               StyleBox["172", {}, StripOnInput -> False]],
              Annotation[#, 
               Style[172, {}], "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                DynamicBox[{
                  FEPrivate`If[
                   CurrentValue["MouseOver"], 
                   EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                  RectangleBox[{11., 0}, {12., 90}, "RoundingRadius" -> 0]},
                 
                 ImageSizeCache->{{123.91424568226009`, 
                  134.41081436577835`}, {40.86680521857247, 
                  55.19557447059147}}],
                StatusArea[#, 90]& ,
                TagBoxNote->"90"],
               StyleBox["90", {}, StripOnInput -> False]],
              Annotation[#, 
               Style[90, {}], "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                DynamicBox[{
                  FEPrivate`If[
                   CurrentValue["MouseOver"], 
                   EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                  RectangleBox[{12., 0}, {13., 37}, "RoundingRadius" -> 0]},
                 
                 ImageSizeCache->{{133.91081436577835`, 
                  144.40738304929658`}, {49.01041377809477, 
                  55.19557447059147}}],
                StatusArea[#, 37]& ,
                TagBoxNote->"37"],
               StyleBox["37", {}, StripOnInput -> False]],
              Annotation[#, 
               Style[37, {}], "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                DynamicBox[{
                  FEPrivate`If[
                   CurrentValue["MouseOver"], 
                   EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                  RectangleBox[{13., 0}, {14., 25}, "RoundingRadius" -> 0]},
                 
                 ImageSizeCache->{{143.90738304929658`, 
                  154.40395173281482`}, {50.85424967836397, 
                  55.19557447059147}}],
                StatusArea[#, 25]& ,
                TagBoxNote->"25"],
               StyleBox["25", {}, StripOnInput -> False]],
              Annotation[#, 
               Style[25, {}], "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                DynamicBox[{
                  FEPrivate`If[
                   CurrentValue["MouseOver"], 
                   EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                  RectangleBox[{14., 0}, {15., 18}, "RoundingRadius" -> 0]},
                 
                 ImageSizeCache->{{153.90395173281482`, 
                  164.40052041633308`}, {51.92982062018767, 
                  55.19557447059147}}],
                StatusArea[#, 18]& ,
                TagBoxNote->"18"],
               StyleBox["18", {}, StripOnInput -> False]],
              Annotation[#, 
               Style[18, {}], "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                DynamicBox[{
                  FEPrivate`If[
                   CurrentValue["MouseOver"], 
                   EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                  RectangleBox[{15., 0}, {16., 17}, "RoundingRadius" -> 0]},
                 
                 ImageSizeCache->{{163.90052041633308`, 174.3970890998513}, {
                  52.08347361187677, 55.19557447059147}}],
                StatusArea[#, 17]& ,
                TagBoxNote->"17"],
               StyleBox["17", {}, StripOnInput -> False]],
              Annotation[#, 
               Style[17, {}], "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                DynamicBox[{
                  FEPrivate`If[
                   CurrentValue["MouseOver"], 
                   EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                  RectangleBox[{16., 0}, {17., 3}, "RoundingRadius" -> 0]},
                 
                 ImageSizeCache->{{173.8970890998513, 184.39365778336955`}, {
                  54.23461549552417, 55.19557447059147}}],
                StatusArea[#, 3]& ,
                TagBoxNote->"3"],
               StyleBox["3", {}, StripOnInput -> False]],
              Annotation[#, 
               Style[3, {}], "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                DynamicBox[{
                  FEPrivate`If[
                   CurrentValue["MouseOver"], 
                   EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                  RectangleBox[{17., 0}, {18., 4}, "RoundingRadius" -> 0]},
                 
                 ImageSizeCache->{{183.89365778336955`, 194.3902264668878}, {
                  54.08096250383507, 55.19557447059147}}],
                StatusArea[#, 4]& ,
                TagBoxNote->"4"],
               StyleBox["4", {}, StripOnInput -> False]],
              Annotation[#, 
               Style[4, {}], "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                DynamicBox[{
                  FEPrivate`If[
                   CurrentValue["MouseOver"], 
                   EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                  RectangleBox[{18., 0}, {19., 1}, "RoundingRadius" -> 0]},
                 
                 ImageSizeCache->{{193.8902264668878, 204.38679515040604`}, {
                  54.54192147890237, 55.19557447059147}}],
                StatusArea[#, 1]& ,
                TagBoxNote->"1"],
               StyleBox["1", {}, StripOnInput -> False]],
              Annotation[#, 
               Style[1, {}], "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                DynamicBox[{
                  FEPrivate`If[
                   CurrentValue["MouseOver"], 
                   EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                  RectangleBox[{19., 0}, {20., 1}, "RoundingRadius" -> 0]},
                 
                 ImageSizeCache->{{203.88679515040604`, 
                  214.38336383392428`}, {54.54192147890237, 
                  55.19557447059147}}],
                StatusArea[#, 1]& ,
                TagBoxNote->"1"],
               StyleBox["1", {}, StripOnInput -> False]],
              Annotation[#, 
               Style[1, {}], "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                DynamicBox[{
                  FEPrivate`If[
                   CurrentValue["MouseOver"], 
                   EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                  RectangleBox[{21., 0}, {22., 1}, "RoundingRadius" -> 0]},
                 
                 ImageSizeCache->{{223.87993251744254`, 
                  234.37650120096077`}, {54.54192147890237, 
                  55.19557447059147}}],
                StatusArea[#, 1]& ,
                TagBoxNote->"1"],
               StyleBox["1", {}, StripOnInput -> False]],
              Annotation[#, 
               Style[1, {}], 
               "Tooltip"]& ]}, {}, {}}, {{}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}}},
          AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
          Axes->{True, True},
          AxesLabel->{None, None},
          AxesOrigin->{0.5800000000000001, 0},
          FrameLabel->{{None, None}, {None, None}},
          FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
          GridLines->{None, None},
          GridLinesStyle->Directive[
            GrayLevel[0.5, 0.4]],
          PlotRange->{{1., 22.}, {All, All}},
          PlotRangePadding->{{
             Scaled[0.02], 
             Scaled[0.02]}, {
             Scaled[0.02], 
             Scaled[0.05]}},
          Ticks->{Automatic, Automatic}], ",", 
         GraphicsBox[{
           {RGBColor[0.987148, 0.8073604000000001, 0.49470040000000004`], 
            EdgeForm[{Opacity[0.567], Thickness[Small]}], {}, 
            {RGBColor[0.987148, 0.8073604000000001, 0.49470040000000004`], 
             EdgeForm[{Opacity[0.567], Thickness[Small]}], 
             TagBox[
              TooltipBox[
               TagBox[
                DynamicBox[{
                  FEPrivate`If[
                   CurrentValue["MouseOver"], 
                   EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                  RectangleBox[{1., 0}, {2., 110}, "RoundingRadius" -> 0]},
                 ImageSizeCache->{{23.948558847077663`, 36.79726133848255}, {
                  32.36003942667351, 55.19557447059145}}],
                StatusArea[#, 110]& ,
                TagBoxNote->"110"],
               StyleBox["110", {}, StripOnInput -> False]],
              Annotation[#, 
               Style[110, {}], "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                DynamicBox[{
                  FEPrivate`If[
                   CurrentValue["MouseOver"], 
                   EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                  RectangleBox[{2., 0}, {3., 564}, "RoundingRadius" -> 0]},
                 
                 ImageSizeCache->{{36.29726133848255, 
                  49.14596382988744}, {-59.8248052091333, 55.19557447059145}}],
                StatusArea[#, 564]& ,
                TagBoxNote->"564"],
               StyleBox["564", {}, StripOnInput -> False]],
              Annotation[#, 
               Style[564, {}], "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                DynamicBox[{
                  FEPrivate`If[
                   CurrentValue["MouseOver"], 
                   EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                  RectangleBox[{3., 0}, {4., 619}, "RoundingRadius" -> 0]},
                 
                 ImageSizeCache->{{48.64596382988744, 
                  61.49466632129233}, {-70.99257273109227, 
                  55.19557447059145}}],
                StatusArea[#, 619]& ,
                TagBoxNote->"619"],
               StyleBox["619", {}, StripOnInput -> False]],
              Annotation[#, 
               Style[619, {}], "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                DynamicBox[{
                  FEPrivate`If[
                   CurrentValue["MouseOver"], 
                   EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                  RectangleBox[{4., 0}, {5., 506}, "RoundingRadius" -> 0]},
                 
                 ImageSizeCache->{{60.99466632129233, 
                  73.84336881269721}, {-48.047886731431106`, 
                  55.19557447059145}}],
                StatusArea[#, 506]& ,
                TagBoxNote->"506"],
               StyleBox["506", {}, StripOnInput -> False]],
              Annotation[#, 
               Style[506, {}], "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                DynamicBox[{
                  FEPrivate`If[
                   CurrentValue["MouseOver"], 
                   EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                  RectangleBox[{5., 0}, {6., 494}, "RoundingRadius" -> 0]},
                 
                 ImageSizeCache->{{73.34336881269721, 
                  86.1920713041021}, {-45.611282908458236`, 
                  55.19557447059145}}],
                StatusArea[#, 494]& ,
                TagBoxNote->"494"],
               StyleBox["494", {}, StripOnInput -> False]],
              Annotation[#, 
               Style[494, {}], "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                DynamicBox[{
                  FEPrivate`If[
                   CurrentValue["MouseOver"], 
                   EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                  RectangleBox[{6., 0}, {7., 350}, "RoundingRadius" -> 0]},
                 ImageSizeCache->{{85.6920713041021, 
                  98.54077379550698}, {-16.372037032783837`, 
                  55.19557447059145}}],
                StatusArea[#, 350]& ,
                TagBoxNote->"350"],
               StyleBox["350", {}, StripOnInput -> False]],
              Annotation[#, 
               Style[350, {}], "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                DynamicBox[{
                  FEPrivate`If[
                   CurrentValue["MouseOver"], 
                   EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                  RectangleBox[{7., 0}, {8., 383}, "RoundingRadius" -> 0]},
                 
                 ImageSizeCache->{{98.04077379550698, 
                  110.88947628691187`}, {-23.072697545959215`, 
                  55.19557447059145}}],
                StatusArea[#, 383]& ,
                TagBoxNote->"383"],
               StyleBox["383", {}, StripOnInput -> False]],
              Annotation[#, 
               Style[383, {}], "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                DynamicBox[{
                  FEPrivate`If[
                   CurrentValue["MouseOver"], 
                   EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                  RectangleBox[{8., 0}, {9., 229}, "RoundingRadius" -> 0]},
                 
                 ImageSizeCache->{{110.38947628691187`, 
                  123.23817877831677`}, {8.197051515525906, 
                  55.19557447059145}}],
                StatusArea[#, 229]& ,
                TagBoxNote->"229"],
               StyleBox["229", {}, StripOnInput -> False]],
              Annotation[#, 
               Style[229, {}], "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                DynamicBox[{
                  FEPrivate`If[
                   CurrentValue["MouseOver"], 
                   EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                  RectangleBox[{9., 0}, {10., 199}, "RoundingRadius" -> 0]},
                 
                 ImageSizeCache->{{122.73817877831677`, 
                  135.58688126972166`}, {14.288561072958075`, 
                  55.19557447059145}}],
                StatusArea[#, 199]& ,
                TagBoxNote->"199"],
               StyleBox["199", {}, StripOnInput -> False]],
              Annotation[#, 
               Style[199, {}], "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                DynamicBox[{
                  FEPrivate`If[
                   CurrentValue["MouseOver"], 
                   EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                  RectangleBox[{10., 0}, {11., 140}, "RoundingRadius" -> 0]},
                 
                 ImageSizeCache->{{135.08688126972166`, 
                  147.93558376112654`}, {26.268529869241338`, 
                  55.19557447059145}}],
                StatusArea[#, 140]& ,
                TagBoxNote->"140"],
               StyleBox["140", {}, StripOnInput -> False]],
              Annotation[#, 
               Style[140, {}], "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                DynamicBox[{
                  FEPrivate`If[
                   CurrentValue["MouseOver"], 
                   EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                  RectangleBox[{11., 0}, {12., 87}, "RoundingRadius" -> 0]},
                 ImageSizeCache->{{147.43558376112654`, 
                  160.28428625253144`}, {37.030196754038165`, 
                  55.19557447059145}}],
                StatusArea[#, 87]& ,
                TagBoxNote->"87"],
               StyleBox["87", {}, StripOnInput -> False]],
              Annotation[#, 
               Style[87, {}], "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                DynamicBox[{
                  FEPrivate`If[
                   CurrentValue["MouseOver"], 
                   EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                  RectangleBox[{12., 0}, {13., 34}, "RoundingRadius" -> 0]},
                 
                 ImageSizeCache->{{159.78428625253144`, 
                  172.63298874393632`}, {47.791863638835, 55.19557447059145}}],
                StatusArea[#, 34]& ,
                TagBoxNote->"34"],
               StyleBox["34", {}, StripOnInput -> False]],
              Annotation[#, 
               Style[34, {}], "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                DynamicBox[{
                  FEPrivate`If[
                   CurrentValue["MouseOver"], 
                   EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                  RectangleBox[{13., 0}, {14., 22}, "RoundingRadius" -> 0]},
                 
                 ImageSizeCache->{{172.13298874393632`, 184.9816912353412}, {
                  50.22846746180787, 55.19557447059145}}],
                StatusArea[#, 22]& ,
                TagBoxNote->"22"],
               StyleBox["22", {}, StripOnInput -> False]],
              Annotation[#, 
               Style[22, {}], "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                DynamicBox[{
                  FEPrivate`If[
                   CurrentValue["MouseOver"], 
                   EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                  RectangleBox[{14., 0}, {15., 18}, "RoundingRadius" -> 0]},
                 
                 ImageSizeCache->{{184.4816912353412, 197.3303937267461}, {
                  51.040668736132154`, 55.19557447059145}}],
                StatusArea[#, 18]& ,
                TagBoxNote->"18"],
               StyleBox["18", {}, StripOnInput -> False]],
              Annotation[#, 
               Style[18, {}], "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                DynamicBox[{
                  FEPrivate`If[
                   CurrentValue["MouseOver"], 
                   EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                  RectangleBox[{15., 0}, {16., 6}, "RoundingRadius" -> 0]},
                 
                 ImageSizeCache->{{196.8303937267461, 209.679096218151}, {
                  53.47727255910502, 55.19557447059145}}],
                StatusArea[#, 6]& ,
                TagBoxNote->"6"],
               StyleBox["6", {}, StripOnInput -> False]],
              Annotation[#, 
               Style[6, {}], "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                DynamicBox[{
                  FEPrivate`If[
                   CurrentValue["MouseOver"], 
                   EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                  RectangleBox[{16., 0}, {17., 3}, "RoundingRadius" -> 0]},
                 
                 ImageSizeCache->{{209.179096218151, 222.02779870955587`}, {
                  54.086423514848235`, 55.19557447059145}}],
                StatusArea[#, 3]& ,
                TagBoxNote->"3"],
               StyleBox["3", {}, StripOnInput -> False]],
              Annotation[#, 
               Style[3, {}], "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                DynamicBox[{
                  FEPrivate`If[
                   CurrentValue["MouseOver"], 
                   EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                  RectangleBox[{18., 0}, {19., 2}, "RoundingRadius" -> 0]},
                 
                 ImageSizeCache->{{233.87650120096077`, 
                  246.72520369236565`}, {54.289473833429305`, 
                  55.19557447059145}}],
                StatusArea[#, 2]& ,
                TagBoxNote->"2"],
               StyleBox["2", {}, StripOnInput -> False]],
              Annotation[#, 
               Style[2, {}], "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                DynamicBox[{
                  FEPrivate`If[
                   CurrentValue["MouseOver"], 
                   EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                  RectangleBox[{21., 0}, {22., 1}, "RoundingRadius" -> 0]},
                 
                 ImageSizeCache->{{270.9226086751754, 283.7713111665803}, {
                  54.49252415201038, 55.19557447059145}}],
                StatusArea[#, 1]& ,
                TagBoxNote->"1"],
               StyleBox["1", {}, StripOnInput -> False]],
              Annotation[#, 
               Style[1, {}], "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                DynamicBox[{
                  FEPrivate`If[
                   CurrentValue["MouseOver"], 
                   EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                  RectangleBox[{24., 0}, {25., 1}, "RoundingRadius" -> 0]},
                 
                 ImageSizeCache->{{307.9687161493901, 320.817418640795}, {
                  54.49252415201038, 55.19557447059145}}],
                StatusArea[#, 1]& ,
                TagBoxNote->"1"],
               StyleBox["1", {}, StripOnInput -> False]],
              Annotation[#, 
               Style[1, {}], 
               "Tooltip"]& ]}, {}, {}}, {{}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}}},
          AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
          Axes->{True, True},
          AxesLabel->{None, None},
          AxesOrigin->{0.6599999999999999, 0},
          FrameLabel->{{None, None}, {None, None}},
          FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
          GridLines->{None, None},
          GridLinesStyle->Directive[
            GrayLevel[0.5, 0.4]],
          PlotRange->{{1., 18.}, {All, All}},
          PlotRangePadding->{{
             Scaled[0.02], 
             Scaled[0.02]}, {
             Scaled[0.02], 
             Scaled[0.05]}},
          Ticks->{Automatic, Automatic}], ",", 
         GraphicsBox[{
           {RGBColor[0.987148, 0.8073604000000001, 0.49470040000000004`], 
            EdgeForm[{Opacity[0.567], Thickness[Small]}], {}, 
            {RGBColor[0.987148, 0.8073604000000001, 0.49470040000000004`], 
             EdgeForm[{Opacity[0.567], Thickness[Small]}], 
             TagBox[
              TooltipBox[
               TagBox[
                DynamicBox[{
                  FEPrivate`If[
                   CurrentValue["MouseOver"], 
                   EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                  RectangleBox[{1., 0}, {2., 55}, "RoundingRadius" -> 0]},
                 
                 ImageSizeCache->{{23.948558847077663`, 36.79726133848255}, {
                  32.030498745697656`, 55.195574470591446`}}],
                StatusArea[#, 55]& ,
                TagBoxNote->"55"],
               StyleBox["55", {}, StripOnInput -> False]],
              Annotation[#, 
               Style[55, {}], "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                DynamicBox[{
                  FEPrivate`If[
                   CurrentValue["MouseOver"], 
                   EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                  RectangleBox[{2., 0}, {3., 292}, "RoundingRadius" -> 0]},
                 
                 ImageSizeCache->{{36.29726133848255, 
                  49.14596382988744}, {-65.6353730142992, 55.19557447059145}}],
                StatusArea[#, 292]& ,
                TagBoxNote->"292"],
               StyleBox["292", {}, StripOnInput -> False]],
              Annotation[#, 
               Style[292, {}], "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                DynamicBox[{
                  FEPrivate`If[
                   CurrentValue["MouseOver"], 
                   EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                  RectangleBox[{3., 0}, {4., 305}, "RoundingRadius" -> 0]},
                 
                 ImageSizeCache->{{48.64596382988744, 
                  61.49466632129233}, {-70.99257273109228, 
                  55.19557447059145}}],
                StatusArea[#, 305]& ,
                TagBoxNote->"305"],
               StyleBox["305", {}, StripOnInput -> False]],
              Annotation[#, 
               Style[305, {}], "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                DynamicBox[{
                  FEPrivate`If[
                   CurrentValue["MouseOver"], 
                   EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                  RectangleBox[{4., 0}, {5., 288}, "RoundingRadius" -> 0]},
                 
                 ImageSizeCache->{{60.99466632129233, 
                  73.84336881269721}, {-63.98700387067057, 
                  55.195574470591446`}}],
                StatusArea[#, 288]& ,
                TagBoxNote->"288"],
               StyleBox["288", {}, StripOnInput -> False]],
              Annotation[#, 
               Style[288, {}], "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                DynamicBox[{
                  FEPrivate`If[
                   CurrentValue["MouseOver"], 
                   EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                  RectangleBox[{5., 0}, {6., 263}, "RoundingRadius" -> 0]},
                 
                 ImageSizeCache->{{73.34336881269721, 
                  86.1920713041021}, {-53.68469672299158, 
                  55.195574470591446`}}],
                StatusArea[#, 263]& ,
                TagBoxNote->"263"],
               StyleBox["263", {}, StripOnInput -> False]],
              Annotation[#, 
               Style[263, {}], "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                DynamicBox[{
                  FEPrivate`If[
                   CurrentValue["MouseOver"], 
                   EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                  RectangleBox[{6., 0}, {7., 143}, "RoundingRadius" -> 0]},
                 
                 ImageSizeCache->{{85.6920713041021, 
                  98.54077379550698}, {-4.233622414132405, 
                  55.195574470591446`}}],
                StatusArea[#, 143]& ,
                TagBoxNote->"143"],
               StyleBox["143", {}, StripOnInput -> False]],
              Annotation[#, 
               Style[143, {}], "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                DynamicBox[{
                  FEPrivate`If[
                   CurrentValue["MouseOver"], 
                   EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                  RectangleBox[{7., 0}, {8., 137}, "RoundingRadius" -> 0]},
                 
                 ImageSizeCache->{{98.04077379550698, 
                  110.88947628691187`}, {-1.7610686986894493`, 
                  55.195574470591446`}}],
                StatusArea[#, 137]& ,
                TagBoxNote->"137"],
               StyleBox["137", {}, StripOnInput -> False]],
              Annotation[#, 
               Style[137, {}], "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                DynamicBox[{
                  FEPrivate`If[
                   CurrentValue["MouseOver"], 
                   EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                  RectangleBox[{8., 0}, {9., 114}, "RoundingRadius" -> 0]},
                 
                 ImageSizeCache->{{110.38947628691187`, 
                  123.23817877831677`}, {7.717053877175232, 
                  55.195574470591446`}}],
                StatusArea[#, 114]& ,
                TagBoxNote->"114"],
               StyleBox["114", {}, StripOnInput -> False]],
              Annotation[#, 
               Style[114, {}], "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                DynamicBox[{
                  FEPrivate`If[
                   CurrentValue["MouseOver"], 
                   EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                  RectangleBox[{9., 0}, {10., 76}, "RoundingRadius" -> 0]},
                 
                 ImageSizeCache->{{122.73817877831677`, 
                  135.58688126972166`}, {23.3765607416473, 
                  55.195574470591446`}}],
                StatusArea[#, 76]& ,
                TagBoxNote->"76"],
               StyleBox["76", {}, StripOnInput -> False]],
              Annotation[#, 
               Style[76, {}], "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                DynamicBox[{
                  FEPrivate`If[
                   CurrentValue["MouseOver"], 
                   EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                  RectangleBox[{10., 0}, {11., 53}, "RoundingRadius" -> 0]},
                 
                 ImageSizeCache->{{135.08688126972166`, 
                  147.93558376112654`}, {32.85468331751198, 
                  55.195574470591446`}}],
                StatusArea[#, 53]& ,
                TagBoxNote->"53"],
               StyleBox["53", {}, StripOnInput -> False]],
              Annotation[#, 
               Style[53, {}], "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                DynamicBox[{
                  FEPrivate`If[
                   CurrentValue["MouseOver"], 
                   EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                  RectangleBox[{11., 0}, {12., 37}, "RoundingRadius" -> 0]},
                 
                 ImageSizeCache->{{147.43558376112654`, 
                  160.28428625253144`}, {39.44815989202653, 
                  55.195574470591446`}}],
                StatusArea[#, 37]& ,
                TagBoxNote->"37"],
               StyleBox["37", {}, StripOnInput -> False]],
              Annotation[#, 
               Style[37, {}], "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                DynamicBox[{
                  FEPrivate`If[
                   CurrentValue["MouseOver"], 
                   EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                  RectangleBox[{12., 0}, {13., 15}, "RoundingRadius" -> 0]},
                 
                 ImageSizeCache->{{159.78428625253144`, 
                  172.63298874393632`}, {48.51419018198405, 
                  55.195574470591446`}}],
                StatusArea[#, 15]& ,
                TagBoxNote->"15"],
               StyleBox["15", {}, StripOnInput -> False]],
              Annotation[#, 
               Style[15, {}], "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                DynamicBox[{
                  FEPrivate`If[
                   CurrentValue["MouseOver"], 
                   EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                  RectangleBox[{13., 0}, {14., 16}, "RoundingRadius" -> 0]},
                 
                 ImageSizeCache->{{172.13298874393632`, 184.9816912353412}, {
                  48.10209789607689, 55.195574470591446`}}],
                StatusArea[#, 16]& ,
                TagBoxNote->"16"],
               StyleBox["16", {}, StripOnInput -> False]],
              Annotation[#, 
               Style[16, {}], "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                DynamicBox[{
                  FEPrivate`If[
                   CurrentValue["MouseOver"], 
                   EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                  RectangleBox[{14., 0}, {15., 6}, "RoundingRadius" -> 0]},
                 
                 ImageSizeCache->{{184.4816912353412, 197.3303937267461}, {
                  52.22302075514849, 55.195574470591446`}}],
                StatusArea[#, 6]& ,
                TagBoxNote->"6"],
               StyleBox["6", {}, StripOnInput -> False]],
              Annotation[#, 
               Style[6, {}], "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                DynamicBox[{
                  FEPrivate`If[
                   CurrentValue["MouseOver"], 
                   EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                  RectangleBox[{15., 0}, {16., 2}, "RoundingRadius" -> 0]},
                 
                 ImageSizeCache->{{196.8303937267461, 209.679096218151}, {
                  53.871389898777124`, 55.195574470591446`}}],
                StatusArea[#, 2]& ,
                TagBoxNote->"2"],
               StyleBox["2", {}, StripOnInput -> False]],
              Annotation[#, 
               Style[2, {}], "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                DynamicBox[{
                  FEPrivate`If[
                   CurrentValue["MouseOver"], 
                   EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                  RectangleBox[{16., 0}, {17., 1}, "RoundingRadius" -> 0]},
                 
                 ImageSizeCache->{{209.179096218151, 222.02779870955587`}, {
                  54.28348218468429, 55.195574470591446`}}],
                StatusArea[#, 1]& ,
                TagBoxNote->"1"],
               StyleBox["1", {}, StripOnInput -> False]],
              Annotation[#, 
               Style[1, {}], "Tooltip"]& ], 
             TagBox[
              TooltipBox[
               TagBox[
                DynamicBox[{
                  FEPrivate`If[
                   CurrentValue["MouseOver"], 
                   EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                  RectangleBox[{17., 0}, {18., 1}, "RoundingRadius" -> 0]},
                 
                 ImageSizeCache->{{221.52779870955587`, 
                  234.37650120096077`}, {54.28348218468429, 
                  55.195574470591446`}}],
                StatusArea[#, 1]& ,
                TagBoxNote->"1"],
               StyleBox["1", {}, StripOnInput -> False]],
              Annotation[#, 
               Style[1, {}], 
               "Tooltip"]& ]}, {}, {}}, {{}, {}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}}},
          AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
          Axes->{True, True},
          AxesLabel->{None, None},
          AxesOrigin->{0.6599999999999999, 0},
          FrameLabel->{{None, None}, {None, None}},
          FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
          GridLines->{None, None},
          GridLinesStyle->Directive[
            GrayLevel[0.5, 0.4]],
          PlotRange->{{1., 18.}, {All, All}},
          PlotRangePadding->{{
             Scaled[0.02], 
             Scaled[0.02]}, {
             Scaled[0.02], 
             Scaled[0.05]}},
          Ticks->{Automatic, Automatic}]}], "}"}]], "ExerciseOutput",
       ExpressionUUID->"4686a2d6-4102-4564-9c01-b6e5098d6c11"],
      Apply[TextCell, 
       Cell[
        BoxData[
         RowBox[{"{", 
           RowBox[{
             GraphicsBox[{{
                RGBColor[0.987148, 0.8073604000000001, 0.49470040000000004`], 
                
                EdgeForm[{
                  Opacity[0.5389999999999999], 
                  Thickness[Small]}], {}, {
                 RGBColor[0.987148, 0.8073604000000001, 0.49470040000000004`], 
                 EdgeForm[{
                   Opacity[0.5389999999999999], 
                   Thickness[Small]}], 
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    RectangleBox[{1., 0}, {2., 116}, "RoundingRadius" -> 0]}, 
                    ImageSizeCache -> {{24.929343474779824`, 
                    35.38016127187464}, {37.34724241207161, 
                    55.58941623502808}}], StatusArea[#, 116]& , TagBoxNote -> 
                    "116"], 
                   StyleBox["116", {}, StripOnInput -> False]], 
                  Annotation[#, 
                   Style[116, {}], "Tooltip"]& ], 
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    RectangleBox[{2., 0}, {3., 760}, "RoundingRadius" -> 0]}, 
                    ImageSizeCache -> {{34.88016127187464, 
                    45.330979068969455`}, {-61.15241226020402, 
                    55.58941623502808}}], StatusArea[#, 760]& , TagBoxNote -> 
                    "760"], 
                   StyleBox["760", {}, StripOnInput -> False]], 
                  Annotation[#, 
                   Style[760, {}], "Tooltip"]& ], 
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    RectangleBox[{3., 0}, {4., 818}, "RoundingRadius" -> 0]}, 
                    ImageSizeCache -> {{44.830979068969455`, 
                    55.281796866064276`}, {-70.02349917168226, 
                    55.58941623502808}}], StatusArea[#, 818]& , TagBoxNote -> 
                    "818"], 
                   StyleBox["818", {}, StripOnInput -> False]], 
                  Annotation[#, 
                   Style[818, {}], "Tooltip"]& ], 
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    RectangleBox[{4., 0}, {5., 731}, "RoundingRadius" -> 0]}, 
                    ImageSizeCache -> {{54.781796866064276`, 
                    65.2326146631591}, {-56.716868804464895`, 
                    55.58941623502808}}], StatusArea[#, 731]& , TagBoxNote -> 
                    "731"], 
                   StyleBox["731", {}, StripOnInput -> False]], 
                  Annotation[#, 
                   Style[731, {}], "Tooltip"]& ], 
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    RectangleBox[{5., 0}, {6., 692}, "RoundingRadius" -> 0]}, 
                    ImageSizeCache -> {{64.7326146631591, 
                    75.18343246025391}, {-50.75182760536745, 
                    55.58941623502808}}], StatusArea[#, 692]& , TagBoxNote -> 
                    "692"], 
                   StyleBox["692", {}, StripOnInput -> False]], 
                  Annotation[#, 
                   Style[692, {}], "Tooltip"]& ], 
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    RectangleBox[{6., 0}, {7., 488}, "RoundingRadius" -> 0]}, 
                    ImageSizeCache -> {{74.68343246025391, 
                    85.13425025734873}, {-19.55007364085779, 
                    55.58941623502808}}], StatusArea[#, 488]& , TagBoxNote -> 
                    "488"], 
                   StyleBox["488", {}, StripOnInput -> False]], 
                  Annotation[#, 
                   Style[488, {}], "Tooltip"]& ], 
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    RectangleBox[{7., 0}, {8., 402}, "RoundingRadius" -> 0]}, 
                    ImageSizeCache -> {{84.63425025734873, 
                    95.08506805444355}, {-6.396393047976261, 
                    55.58941623502808}}], StatusArea[#, 402]& , TagBoxNote -> 
                    "402"], 
                   StyleBox["402", {}, StripOnInput -> False]], 
                  Annotation[#, 
                   Style[402, {}], "Tooltip"]& ], 
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    RectangleBox[{8., 0}, {9., 267}, "RoundingRadius" -> 0]}, 
                    ImageSizeCache -> {{94.58506805444355, 
                    105.03588585153835`}, {14.251826487361015`, 
                    55.58941623502808}}], StatusArea[#, 267]& , TagBoxNote -> 
                    "267"], 
                   StyleBox["267", {}, StripOnInput -> False]], 
                  Annotation[#, 
                   Style[267, {}], "Tooltip"]& ], 
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    RectangleBox[{9., 0}, {10., 298}, "RoundingRadius" -> 0]},
                     ImageSizeCache -> {{104.53588585153835`, 
                    114.98670364863318`}, {9.510383482950232, 
                    55.58941623502808}}], StatusArea[#, 298]& , TagBoxNote -> 
                    "298"], 
                   StyleBox["298", {}, StripOnInput -> False]], 
                  Annotation[#, 
                   Style[298, {}], "Tooltip"]& ], 
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    RectangleBox[{10., 0}, {11., 172}, "RoundingRadius" -> 
                    0]}, ImageSizeCache -> {{114.48670364863318`, 
                    124.93752144572801`}, {28.78205504926503, 
                    55.58941623502808}}], StatusArea[#, 172]& , TagBoxNote -> 
                    "172"], 
                   StyleBox["172", {}, StripOnInput -> False]], 
                  Annotation[#, 
                   Style[172, {}], "Tooltip"]& ], 
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    RectangleBox[{11., 0}, {12., 90}, "RoundingRadius" -> 0]},
                     ImageSizeCache -> {{124.43752144572801`, 
                    134.8883392428228}, {41.32393654480323, 
                    55.58941623502808}}], StatusArea[#, 90]& , TagBoxNote -> 
                    "90"], 
                   StyleBox["90", {}, StripOnInput -> False]], Annotation[#, 
                   Style[90, {}], "Tooltip"]& ], 
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    RectangleBox[{12., 0}, {13., 37}, "RoundingRadius" -> 0]},
                     ImageSizeCache -> {{134.3883392428228, 
                    144.83915703991764`}, {49.43027458460231, 
                    55.58941623502808}}], StatusArea[#, 37]& , TagBoxNote -> 
                    "37"], 
                   StyleBox["37", {}, StripOnInput -> False]], Annotation[#, 
                   Style[37, {}], "Tooltip"]& ], 
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    RectangleBox[{13., 0}, {14., 25}, "RoundingRadius" -> 0]},
                     ImageSizeCache -> {{144.33915703991764`, 
                    154.78997483701247`}, {51.26567187663229, 
                    55.58941623502808}}], StatusArea[#, 25]& , TagBoxNote -> 
                    "25"], 
                   StyleBox["25", {}, StripOnInput -> False]], Annotation[#, 
                   Style[25, {}], "Tooltip"]& ], 
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    RectangleBox[{14., 0}, {15., 18}, "RoundingRadius" -> 0]},
                     ImageSizeCache -> {{154.28997483701247`, 
                    164.74079263410727`}, {52.33632029698311, 
                    55.58941623502808}}], StatusArea[#, 18]& , TagBoxNote -> 
                    "18"], 
                   StyleBox["18", {}, StripOnInput -> False]], Annotation[#, 
                   Style[18, {}], "Tooltip"]& ], 
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    RectangleBox[{15., 0}, {16., 17}, "RoundingRadius" -> 0]},
                     ImageSizeCache -> {{164.24079263410727`, 
                    174.6916104312021}, {52.48927007131894, 
                    55.58941623502808}}], StatusArea[#, 17]& , TagBoxNote -> 
                    "17"], 
                   StyleBox["17", {}, StripOnInput -> False]], Annotation[#, 
                   Style[17, {}], "Tooltip"]& ], 
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    RectangleBox[{16., 0}, {17., 3}, "RoundingRadius" -> 0]}, 
                    ImageSizeCache -> {{174.1916104312021, 
                    184.64242822829692`}, {54.63056691202059, 
                    55.58941623502808}}], StatusArea[#, 3]& , TagBoxNote -> 
                    "3"], 
                   StyleBox["3", {}, StripOnInput -> False]], Annotation[#, 
                   Style[3, {}], "Tooltip"]& ], 
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    RectangleBox[{17., 0}, {18., 4}, "RoundingRadius" -> 0]}, 
                    ImageSizeCache -> {{184.14242822829692`, 
                    194.59324602539172`}, {54.47761713768475, 
                    55.58941623502808}}], StatusArea[#, 4]& , TagBoxNote -> 
                    "4"], 
                   StyleBox["4", {}, StripOnInput -> False]], Annotation[#, 
                   Style[4, {}], "Tooltip"]& ], 
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    RectangleBox[{18., 0}, {19., 1}, "RoundingRadius" -> 0]}, 
                    ImageSizeCache -> {{194.09324602539172`, 
                    204.54406382248655`}, {54.93646646069225, 
                    55.58941623502808}}], StatusArea[#, 1]& , TagBoxNote -> 
                    "1"], 
                   StyleBox["1", {}, StripOnInput -> False]], Annotation[#, 
                   Style[1, {}], "Tooltip"]& ], 
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    RectangleBox[{19., 0}, {20., 1}, "RoundingRadius" -> 0]}, 
                    ImageSizeCache -> {{204.04406382248655`, 
                    214.49488161958135`}, {54.93646646069225, 
                    55.58941623502808}}], StatusArea[#, 1]& , TagBoxNote -> 
                    "1"], 
                   StyleBox["1", {}, StripOnInput -> False]], Annotation[#, 
                   Style[1, {}], "Tooltip"]& ], 
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    RectangleBox[{21., 0}, {22., 1}, "RoundingRadius" -> 0]}, 
                    ImageSizeCache -> {{223.94569941667618`, 
                    234.396517213771}, {54.93646646069225, 
                    55.58941623502808}}], StatusArea[#, 1]& , TagBoxNote -> 
                    "1"], 
                   StyleBox["1", {}, StripOnInput -> False]], Annotation[#, 
                   Style[1, {}], 
                   "Tooltip"]& ]}, {}, {}}, {{}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}}}, AspectRatio -> 
              NCache[GoldenRatio^(-1), 0.6180339887498948], 
              Axes -> {True, True}, AxesLabel -> {None, None}, 
              AxesOrigin -> {0.5800000000000001, 0}, 
              FrameLabel -> {{None, None}, {None, None}}, 
              FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
              GridLines -> {None, None}, GridLinesStyle -> Directive[
                GrayLevel[0.5, 0.4]], PlotRange -> {{1., 22.}, {All, All}}, 
              PlotRangePadding -> {{
                 Scaled[0.02], 
                 Scaled[0.02]}, {
                 Scaled[0.02], 
                 Scaled[0.05]}}, Ticks -> {Automatic, Automatic}], ",", 
             GraphicsBox[{{
                RGBColor[0.987148, 0.8073604000000001, 0.49470040000000004`], 
                
                EdgeForm[{
                  Opacity[0.567], 
                  Thickness[Small]}], {}, {
                 RGBColor[0.987148, 0.8073604000000001, 0.49470040000000004`], 
                 EdgeForm[{
                   Opacity[0.567], 
                   Thickness[Small]}], 
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    RectangleBox[{1., 0}, {2., 110}, "RoundingRadius" -> 0]}, 
                    ImageSizeCache -> {{24.929343474779824`, 
                    37.72153016530872}, {32.85610331945763, 
                    55.58941623502813}}], StatusArea[#, 110]& , TagBoxNote -> 
                    "110"], 
                   StyleBox["110", {}, StripOnInput -> False]], 
                  Annotation[#, 
                   Style[110, {}], "Tooltip"]& ], 
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    RectangleBox[{2., 0}, {3., 564}, "RoundingRadius" -> 0]}, 
                    ImageSizeCache -> {{37.22153016530872, 
                    50.013716855837615`}, {-58.90684271389697, 
                    55.58941623502813}}], StatusArea[#, 564]& , TagBoxNote -> 
                    "564"], 
                   StyleBox["564", {}, StripOnInput -> False]], 
                  Annotation[#, 
                   Style[564, {}], "Tooltip"]& ], 
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    RectangleBox[{3., 0}, {4., 619}, "RoundingRadius" -> 0]}, 
                    ImageSizeCache -> {{49.513716855837615`, 
                    62.30590354636651}, {-70.0234991716822, 
                    55.589416235028125`}}], StatusArea[#, 619]& , TagBoxNote -> 
                    "619"], 
                   StyleBox["619", {}, StripOnInput -> False]], 
                  Annotation[#, 
                   Style[619, {}], "Tooltip"]& ], 
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    RectangleBox[{4., 0}, {5., 506}, "RoundingRadius" -> 0]}, 
                    ImageSizeCache -> {{61.80590354636651, 
                    74.5980902368954}, {-47.18382317659616, 
                    55.58941623502813}}], StatusArea[#, 506]& , TagBoxNote -> 
                    "506"], 
                   StyleBox["506", {}, StripOnInput -> False]], 
                  Annotation[#, 
                   Style[506, {}], "Tooltip"]& ], 
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    RectangleBox[{5., 0}, {6., 494}, "RoundingRadius" -> 0]}, 
                    ImageSizeCache -> {{74.0980902368954, 
                    86.8902769274243}, {-44.75837085853393, 
                    55.58941623502813}}], StatusArea[#, 494]& , TagBoxNote -> 
                    "494"], 
                   StyleBox["494", {}, StripOnInput -> False]], 
                  Annotation[#, 
                   Style[494, {}], "Tooltip"]& ], 
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    RectangleBox[{6., 0}, {7., 350}, "RoundingRadius" -> 0]}, 
                    ImageSizeCache -> {{86.3902769274243, 
                    99.18246361795319}, {-15.65294304178709, 
                    55.58941623502813}}], StatusArea[#, 350]& , TagBoxNote -> 
                    "350"], 
                   StyleBox["350", {}, StripOnInput -> False]], 
                  Annotation[#, 
                   Style[350, {}], "Tooltip"]& ], 
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    RectangleBox[{7., 0}, {8., 383}, "RoundingRadius" -> 0]}, 
                    ImageSizeCache -> {{98.68246361795319, 
                    111.47465030848208`}, {-22.32293691645824, 
                    55.58941623502813}}], StatusArea[#, 383]& , TagBoxNote -> 
                    "383"], 
                   StyleBox["383", {}, StripOnInput -> False]], 
                  Annotation[#, 
                   Style[383, {}], "Tooltip"]& ], 
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    RectangleBox[{8., 0}, {9., 229}, "RoundingRadius" -> 0]}, 
                    ImageSizeCache -> {{110.97465030848208`, 
                    123.76683699901098`}, {8.803701165340456, 
                    55.58941623502813}}], StatusArea[#, 229]& , TagBoxNote -> 
                    "229"], 
                   StyleBox["229", {}, StripOnInput -> False]], 
                  Annotation[#, 
                   Style[229, {}], "Tooltip"]& ], 
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    RectangleBox[{9., 0}, {10., 199}, "RoundingRadius" -> 0]},
                     ImageSizeCache -> {{123.26683699901098`, 
                    136.05902368953986`}, {14.867331960496053`, 
                    55.58941623502813}}], StatusArea[#, 199]& , TagBoxNote -> 
                    "199"], 
                   StyleBox["199", {}, StripOnInput -> False]], 
                  Annotation[#, 
                   Style[199, {}], "Tooltip"]& ], 
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    
                    RectangleBox[{10., 0}, {11., 140}, "RoundingRadius" -> 
                    0]}, ImageSizeCache -> {{135.55902368953986`, 
                    148.35121038006875`}, {26.792472524302042`, 
                    55.58941623502813}}], StatusArea[#, 140]& , TagBoxNote -> 
                    "140"], 
                   StyleBox["140", {}, StripOnInput -> False]], 
                  Annotation[#, 
                   Style[140, {}], "Tooltip"]& ], 
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    RectangleBox[{11., 0}, {12., 87}, "RoundingRadius" -> 0]},
                     ImageSizeCache -> {{147.85121038006875`, 
                    160.64339707059764`}, {37.50488692907692, 
                    55.58941623502813}}], StatusArea[#, 87]& , TagBoxNote -> 
                    "87"], 
                   StyleBox["87", {}, StripOnInput -> False]], Annotation[#, 
                   Style[87, {}], "Tooltip"]& ], 
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    RectangleBox[{12., 0}, {13., 34}, "RoundingRadius" -> 0]},
                     ImageSizeCache -> {{160.14339707059764`, 
                    172.93558376112654`}, {48.21730133385179, 
                    55.58941623502813}}], StatusArea[#, 34]& , TagBoxNote -> 
                    "34"], 
                   StyleBox["34", {}, StripOnInput -> False]], Annotation[#, 
                   Style[34, {}], "Tooltip"]& ], 
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    RectangleBox[{13., 0}, {14., 22}, "RoundingRadius" -> 0]},
                     ImageSizeCache -> {{172.43558376112654`, 
                    185.22777045165543`}, {50.642753651914035`, 
                    55.58941623502813}}], StatusArea[#, 22]& , TagBoxNote -> 
                    "22"], 
                   StyleBox["22", {}, StripOnInput -> False]], Annotation[#, 
                   Style[22, {}], "Tooltip"]& ], 
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    RectangleBox[{14., 0}, {15., 18}, "RoundingRadius" -> 0]},
                     ImageSizeCache -> {{184.72777045165543`, 
                    197.51995714218432`}, {51.45123775793478, 
                    55.58941623502813}}], StatusArea[#, 18]& , TagBoxNote -> 
                    "18"], 
                   StyleBox["18", {}, StripOnInput -> False]], Annotation[#, 
                   Style[18, {}], "Tooltip"]& ], 
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    RectangleBox[{15., 0}, {16., 6}, "RoundingRadius" -> 0]}, 
                    ImageSizeCache -> {{197.01995714218432`, 
                    209.81214383271322`}, {53.87669007599701, 
                    55.58941623502813}}], StatusArea[#, 6]& , TagBoxNote -> 
                    "6"], 
                   StyleBox["6", {}, StripOnInput -> False]], Annotation[#, 
                   Style[6, {}], "Tooltip"]& ], 
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    RectangleBox[{16., 0}, {17., 3}, "RoundingRadius" -> 0]}, 
                    ImageSizeCache -> {{209.31214383271322`, 
                    222.1043305232421}, {54.48305315551257, 
                    55.58941623502813}}], StatusArea[#, 3]& , TagBoxNote -> 
                    "3"], 
                   StyleBox["3", {}, StripOnInput -> False]], Annotation[#, 
                   Style[3, {}], "Tooltip"]& ], 
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    RectangleBox[{18., 0}, {19., 2}, "RoundingRadius" -> 0]}, 
                    ImageSizeCache -> {{233.896517213771, 
                    246.6887039042999}, {54.68517418201776, 
                    55.58941623502813}}], StatusArea[#, 2]& , TagBoxNote -> 
                    "2"], 
                   StyleBox["2", {}, StripOnInput -> False]], Annotation[#, 
                   Style[2, {}], "Tooltip"]& ], 
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    RectangleBox[{21., 0}, {22., 1}, "RoundingRadius" -> 0]}, 
                    ImageSizeCache -> {{270.77307728535766`, 
                    283.5652639758866}, {54.88729520852294, 
                    55.58941623502813}}], StatusArea[#, 1]& , TagBoxNote -> 
                    "1"], 
                   StyleBox["1", {}, StripOnInput -> False]], Annotation[#, 
                   Style[1, {}], "Tooltip"]& ], 
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    RectangleBox[{24., 0}, {25., 1}, "RoundingRadius" -> 0]}, 
                    ImageSizeCache -> {{307.64963735694437`, 
                    320.44182404747323`}, {54.88729520852294, 
                    55.58941623502813}}], StatusArea[#, 1]& , TagBoxNote -> 
                    "1"], 
                   StyleBox["1", {}, StripOnInput -> False]], Annotation[#, 
                   Style[1, {}], 
                   "Tooltip"]& ]}, {}, {}}, {{}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}}}, AspectRatio -> 
              NCache[GoldenRatio^(-1), 0.6180339887498948], 
              Axes -> {True, True}, AxesLabel -> {None, None}, 
              AxesOrigin -> {0.6599999999999999, 0}, 
              FrameLabel -> {{None, None}, {None, None}}, 
              FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
              GridLines -> {None, None}, GridLinesStyle -> Directive[
                GrayLevel[0.5, 0.4]], PlotRange -> {{1., 18.}, {All, All}}, 
              PlotRangePadding -> {{
                 Scaled[0.02], 
                 Scaled[0.02]}, {
                 Scaled[0.02], 
                 Scaled[0.05]}}, Ticks -> {Automatic, Automatic}], ",", 
             GraphicsBox[{{
                RGBColor[0.987148, 0.8073604000000001, 0.49470040000000004`], 
                
                EdgeForm[{
                  Opacity[0.567], 
                  Thickness[Small]}], {}, {
                 RGBColor[0.987148, 0.8073604000000001, 0.49470040000000004`], 
                 EdgeForm[{
                   Opacity[0.567], 
                   Thickness[Small]}], 
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    RectangleBox[{1., 0}, {2., 55}, "RoundingRadius" -> 0]}, 
                    ImageSizeCache -> {{24.92934347477982, 
                    37.721530165308714`}, {32.52807083381808, 
                    55.58941623502814}}], StatusArea[#, 55]& , TagBoxNote -> 
                    "55"], 
                   StyleBox["55", {}, StripOnInput -> False]], Annotation[#, 
                   Style[55, {}], "Tooltip"]& ], 
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    RectangleBox[{2., 0}, {3., 292}, "RoundingRadius" -> 0]}, 
                    ImageSizeCache -> {{37.221530165308714`, 
                    50.01371685583761}, {-64.69081753139619, 
                    55.58941623502814}}], StatusArea[#, 292]& , TagBoxNote -> 
                    "292"], 
                   StyleBox["292", {}, StripOnInput -> False]], 
                  Annotation[#, 
                   Style[292, {}], "Tooltip"]& ], 
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    RectangleBox[{3., 0}, {4., 305}, "RoundingRadius" -> 0]}, 
                    ImageSizeCache -> {{49.51371685583761, 
                    62.3059035463665}, {-70.02349917168222, 
                    55.58941623502814}}], StatusArea[#, 305]& , TagBoxNote -> 
                    "305"], 
                   StyleBox["305", {}, StripOnInput -> False]], 
                  Annotation[#, 
                   Style[305, {}], "Tooltip"]& ], 
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    RectangleBox[{4., 0}, {5., 288}, "RoundingRadius" -> 0]}, 
                    ImageSizeCache -> {{61.8059035463665, 
                    74.5980902368954}, {-63.049992411308196`, 
                    55.58941623502814}}], StatusArea[#, 288]& , TagBoxNote -> 
                    "288"], 
                   StyleBox["288", {}, StripOnInput -> False]], 
                  Annotation[#, 
                   Style[288, {}], "Tooltip"]& ], 
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    RectangleBox[{5., 0}, {6., 263}, "RoundingRadius" -> 0]}, 
                    ImageSizeCache -> {{74.0980902368954, 
                    86.8902769274243}, {-52.79483541075817, 
                    55.58941623502814}}], StatusArea[#, 263]& , TagBoxNote -> 
                    "263"], 
                   StyleBox["263", {}, StripOnInput -> False]], 
                  Annotation[#, 
                   Style[263, {}], "Tooltip"]& ], 
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    RectangleBox[{6., 0}, {7., 143}, "RoundingRadius" -> 0]}, 
                    ImageSizeCache -> {{86.3902769274243, 
                    99.18246361795319}, {-3.570081808118026, 
                    55.58941623502814}}], StatusArea[#, 143]& , TagBoxNote -> 
                    "143"], 
                   StyleBox["143", {}, StripOnInput -> False]], 
                  Annotation[#, 
                   Style[143, {}], "Tooltip"]& ], 
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    RectangleBox[{7., 0}, {8., 137}, "RoundingRadius" -> 0]}, 
                    ImageSizeCache -> {{98.68246361795319, 
                    111.47465030848208`}, {-1.1088441279860177`, 
                    55.58941623502814}}], StatusArea[#, 137]& , TagBoxNote -> 
                    "137"], 
                   StyleBox["137", {}, StripOnInput -> False]], 
                  Annotation[#, 
                   Style[137, {}], "Tooltip"]& ], 
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    RectangleBox[{8., 0}, {9., 114}, "RoundingRadius" -> 0]}, 
                    ImageSizeCache -> {{110.97465030848208`, 
                    123.76683699901098`}, {8.325900312520005, 
                    55.58941623502814}}], StatusArea[#, 114]& , TagBoxNote -> 
                    "114"], 
                   StyleBox["114", {}, StripOnInput -> False]], 
                  Annotation[#, 
                   Style[114, {}], "Tooltip"]& ], 
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    RectangleBox[{9., 0}, {10., 76}, "RoundingRadius" -> 0]}, 
                    ImageSizeCache -> {{123.26683699901098`, 
                    136.05902368953986`}, {23.913738953356052`, 
                    55.58941623502814}}], StatusArea[#, 76]& , TagBoxNote -> 
                    "76"], 
                   StyleBox["76", {}, StripOnInput -> False]], Annotation[#, 
                   Style[76, {}], "Tooltip"]& ], 
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    RectangleBox[{10., 0}, {11., 53}, "RoundingRadius" -> 0]},
                     ImageSizeCache -> {{135.55902368953986`, 
                    148.35121038006875`}, {33.34848339386208, 
                    55.58941623502814}}], StatusArea[#, 53]& , TagBoxNote -> 
                    "53"], 
                   StyleBox["53", {}, StripOnInput -> False]], Annotation[#, 
                   Style[53, {}], "Tooltip"]& ], 
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    RectangleBox[{11., 0}, {12., 37}, "RoundingRadius" -> 0]},
                     ImageSizeCache -> {{147.85121038006875`, 
                    160.64339707059764`}, {39.911783874214095`, 
                    55.58941623502814}}], StatusArea[#, 37]& , TagBoxNote -> 
                    "37"], 
                   StyleBox["37", {}, StripOnInput -> False]], Annotation[#, 
                   Style[37, {}], "Tooltip"]& ], 
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    RectangleBox[{12., 0}, {13., 15}, "RoundingRadius" -> 0]},
                     ImageSizeCache -> {{160.14339707059764`, 
                    172.93558376112654`}, {48.93632203469812, 
                    55.58941623502814}}], StatusArea[#, 15]& , TagBoxNote -> 
                    "15"], 
                   StyleBox["15", {}, StripOnInput -> False]], Annotation[#, 
                   Style[15, {}], "Tooltip"]& ], 
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    RectangleBox[{13., 0}, {14., 16}, "RoundingRadius" -> 0]},
                     ImageSizeCache -> {{172.43558376112654`, 
                    185.22777045165543`}, {48.52611575467612, 
                    55.58941623502814}}], StatusArea[#, 16]& , TagBoxNote -> 
                    "16"], 
                   StyleBox["16", {}, StripOnInput -> False]], Annotation[#, 
                   Style[16, {}], "Tooltip"]& ], 
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    RectangleBox[{14., 0}, {15., 6}, "RoundingRadius" -> 0]}, 
                    ImageSizeCache -> {{184.72777045165543`, 
                    197.51995714218432`}, {52.62817855489613, 
                    55.58941623502814}}], StatusArea[#, 6]& , TagBoxNote -> 
                    "6"], 
                   StyleBox["6", {}, StripOnInput -> False]], Annotation[#, 
                   Style[6, {}], "Tooltip"]& ], 
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    RectangleBox[{15., 0}, {16., 2}, "RoundingRadius" -> 0]}, 
                    ImageSizeCache -> {{197.01995714218432`, 
                    209.81214383271322`}, {54.269003674984134`, 
                    55.58941623502814}}], StatusArea[#, 2]& , TagBoxNote -> 
                    "2"], 
                   StyleBox["2", {}, StripOnInput -> False]], Annotation[#, 
                   Style[2, {}], "Tooltip"]& ], 
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    RectangleBox[{16., 0}, {17., 1}, "RoundingRadius" -> 0]}, 
                    ImageSizeCache -> {{209.31214383271322`, 
                    222.1043305232421}, {54.67920995500614, 
                    55.58941623502814}}], StatusArea[#, 1]& , TagBoxNote -> 
                    "1"], 
                   StyleBox["1", {}, StripOnInput -> False]], Annotation[#, 
                   Style[1, {}], "Tooltip"]& ], 
                 TagBox[
                  TooltipBox[
                   TagBox[
                    DynamicBox[{
                    FEPrivate`If[
                    CurrentValue["MouseOver"], 
                    EdgeForm[{
                    GrayLevel[0.5], 
                    AbsoluteThickness[1.5], 
                    Opacity[0.66]}], {}, {}], 
                    RectangleBox[{17., 0}, {18., 1}, "RoundingRadius" -> 0]}, 
                    ImageSizeCache -> {{221.6043305232421, 
                    234.396517213771}, {54.67920995500614, 
                    55.58941623502814}}], StatusArea[#, 1]& , TagBoxNote -> 
                    "1"], 
                   StyleBox["1", {}, StripOnInput -> False]], Annotation[#, 
                   Style[1, {}], 
                   "Tooltip"]& ]}, {}, {}}, {{}, {}, {}, {}, {}, {}, {}, {}, \
{}, {}, {}, {}, {}, {}, {}, {}, {}}}, AspectRatio -> 
              NCache[GoldenRatio^(-1), 0.6180339887498948], 
              Axes -> {True, True}, AxesLabel -> {None, None}, 
              AxesOrigin -> {0.6599999999999999, 0}, 
              FrameLabel -> {{None, None}, {None, None}}, 
              FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
              GridLines -> {None, None}, GridLinesStyle -> Directive[
                GrayLevel[0.5, 0.4]], PlotRange -> {{1., 18.}, {All, All}}, 
              PlotRangePadding -> {{
                 Scaled[0.02], 
                 Scaled[0.02]}, {
                 Scaled[0.02], 
                 Scaled[0.05]}}, Ticks -> {Automatic, Automatic}]}], "}"}]], 
        "ExerciseOutput", Selectable -> False, Copyable -> False, Editable -> 
        False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"c939a2bc-e2e7-42d2-a184-89dce0748aa6"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Make a list of maps of Central America, highlighting each country in \
turn.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "26.8", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CellTags->
  "LastCellOfAPage",ExpressionUUID->"e473422b-eea2-4735-b2bf-7d023f32b11c"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       RowBox[{"{", 
        RowBox[{
         GraphicsBox[{{
            {Texture[
              FormBox[
               GraphicsBox[
                TagBox[
                 RasterBox[CompressedData["
1:eJzsvdtzHFee5zdh+2Ef/S/4v9hH+9Gv6/C+74ZnNhzhGDt2HbGxOzGz7unu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