(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    663447,      11971]
NotebookOptionsPosition[    596532,      10572]
NotebookOutlinePosition[    655610,      11787]
CellTagsIndexPosition[    655530,      11782]
WindowTitle->Pure Anonymous Function: Elementary Introduction to the Wolfram \
Language
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[TextData[{
 "Use ",
 StyleBox["Range",
  FontFamily->"Source Sans Pro"],
 " and a pure function to create a list of the first 20 squares."
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "26.1", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 26}, {"ExerciseNumber", 1}, {
   "WebOnly", 0}},ExpressionUUID->"472fd02e-9528-4a5a-8a3f-22b8983b6e4f"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"6efccdd8-5a51-4df1-9e30-8a1972dc6328"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztXL/rpNoVN0mTMpC/IH9ArNNapsnAC+mmeY+sjzQb2RcItkIKIY2p7Kys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            "], {{0, 
            19}, {458, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{458, 19},
          PlotRange->{{0, 458}, {0, 19}}]], "ExerciseOutput",
         ImageSize->{462, 19},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "21808c18-7ea1-46ae-830a-061b31c25b24"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztXL/rpNoVN0mTMpC/IH9ArNNapsnAC+mmeY+sjzQb2RcItkIKIY2p7Kys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              "], {{
              0, 19}, {458, 0}}, {0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {458, 19}, 
            PlotRange -> {{0, 458}, {0, 19}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"cc0fdd43-b0c1-4393-8436-e651bac7954c"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["26.1"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"e543806e-b7dc-4a3d-9f3d-1253966c40be"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"936186e3-2f98-4079-a54e-788d9e18997d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"067351f2-8e47-4bcc-ad08-8502578bf0aa"],

Cell["\<\
Make a list of the result of blending yellow, green and blue with red.\
\>", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "26.2", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 26}, {"ExerciseNumber", 2}, {
   "WebOnly", 0}},ExpressionUUID->"7a4eef0b-b86c-4371-9df3-42a253c6c997"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"d6200981-55f8-4fe6-aba8-d921f4ee6176"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztliFvg0AUx182M7lkn2Bf4HTtyaklXXCYNus1Mx1plyx1BHcSh0NhVlWF
qsfUYM5gMRMIzAlE9+7aJtta4JgZoi/v4N2FP/nleO8e9+PXIbsCgMUNXoaj
dzqfj5ZPtzixZouX6Wzy/DB7m0wn88H4GhfvcAxwqHh3sYv13YqYM0KcVP43
yA8rI0ap7SWf1WGeBlhQjK8/LGj2s6+zLGj286oWkbXbVSIObQDCkwPn1gfw
cS8ViVvrDZyuW+sNnPUiV3MqE+EjEL/QsUwVZ9lLzjSgQIJSx1lk75l7yCk0
G3IW2cYBoDoHeshZZSusHb4WHG9ANjoDesiJWRkQhVgVwsPA2/STU4oQIcMk
xzhbYfUb52cllgSoF8tOnKcqM05dO8Fe1a3eZWqrTPHLTpynqu71rs9Pbn4u
qf0/as2/+2+VYb0jJz2o9jlAWWDSj/IYjweI0uJ7frb2ozOq9n4kk3CpwPzt
USSTiDPmCYP+XpV5lnf+D/iTSsbccbwwK9sfvVhX+wJhrioU
            "], {{0, 19}, {
            56, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{56, 19},
          PlotRange->{{0, 56}, {0, 19}}]], "ExerciseOutput",
         ImageSize->{60, 19},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "40a41d2a-a8bc-4709-a4f2-2d730e539002"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztliFvg0AUx182M7lkn2Bf4HTtyaklXXCYNus1Mx1plyx1BHcSh0NhVlWF
qsfUYM5gMRMIzAlE9+7aJtta4JgZoi/v4N2FP/nleO8e9+PXIbsCgMUNXoaj
dzqfj5ZPtzixZouX6Wzy/DB7m0wn88H4GhfvcAxwqHh3sYv13YqYM0KcVP43
yA8rI0ap7SWf1WGeBlhQjK8/LGj2s6+zLGj286oWkbXbVSIObQDCkwPn1gfw
cS8ViVvrDZyuW+sNnPUiV3MqE+EjEL/QsUwVZ9lLzjSgQIJSx1lk75l7yCk0
G3IW2cYBoDoHeshZZSusHb4WHG9ANjoDesiJWRkQhVgVwsPA2/STU4oQIcMk
xzhbYfUb52cllgSoF8tOnKcqM05dO8Fe1a3eZWqrTPHLTpynqu71rs9Pbn4u
qf0/as2/+2+VYb0jJz2o9jlAWWDSj/IYjweI0uJ7frb2ozOq9n4kk3CpwPzt
USSTiDPmCYP+XpV5lnf+D/iTSsbccbwwK9sfvVhX+wJhrioU
              "], {{0, 19}, {
              56, 0}}, {0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {56, 19}, 
            PlotRange -> {{0, 56}, {0, 19}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"fbc26ac6-f90c-4121-acf3-d3f9d48feda7"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["26.2"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"6a7e548c-d511-4cbc-bd51-7343d5361aed"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"c92c9315-e3a3-4a4e-a57f-bd7f01d85028"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"f1750d7d-6abf-4926-89a2-ddf07b705018"],

Cell["\<\
Generate a list of framed columns containing the uppercase and lowercase \
versions of each letter of the alphabet.\
\>", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "26.3", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 26}, {"ExerciseNumber", 3}, {
   "WebOnly", 0}},ExpressionUUID->"29e267e5-c5a1-42ca-a134-37fce93d795a"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"7d20de52-b69e-4f0f-9a4f-b97511fb4aa6"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztXSuzrcp2ZifmyvyF/AF0LPIqqm4qDnNvcrgVc0Kdm6oUFofE4VAoFAqF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            "], {{0, 
            99}, {357, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{357, 99},
          PlotRange->{{0, 357}, {0, 99}}]], "ExerciseOutput",
         ImageSize->{361, 99},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "6777752a-ef4b-4918-8aa5-89f7ecfbd21e"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztXSuzrcp2ZifmyvyF/AF0LPIqqm4qDnNvcrgVc0Kdm6oUFofE4VAoFAqF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              "], {{0, 
              99}, {357, 0}}, {0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {357, 99}, 
            PlotRange -> {{0, 357}, {0, 99}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"7f10a70b-4146-482e-b7c0-4488dc7a1cda"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["26.3"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"bb3293f8-f227-4b7b-a393-bcca7346c983"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"a73ad4ce-3afe-4221-a934-021fdf009685"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"30f1d40d-e4ce-413c-9b28-9db3b3ddb6ef"],

Cell["\<\
Make a list of letters of the alphabet, in random colors, with frames having \
random background colors.\
\>", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "26.4", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 TaggingRules->{"MultipleSolutions" -> "True"},
 CounterAssignments->{{"SectionNumber", 26}, {"ExerciseNumber", 4}, {
   "WebOnly", 0}},ExpressionUUID->"cdfeeb47-a9e4-451b-af37-230213a01486"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{
    "SAMPLE", " ", "EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"c8eecb76-8032-4d52-8bf2-de368ce0d846"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztnQlUVFeax2umz5yZ9Dl9MpN0T5xzotE+nTE6SkY96bhgK4otYgSJGkBx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            "], {{0, 65}, {342, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{342, 65},
          PlotRange->{{0, 342}, {0, 65}}]], "ExerciseOutput",
         ImageSize->{346, 65},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "cc3b3504-0873-4a6b-9b25-ba5f5a036778"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztnQlUVFeax2umz5yZ9Dl9MpN0T5xzotE+nTE6SkY96bhgK4otYgSJGkBx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              "], {{0, 65}, {342, 0}}, {0, 255}, ColorFunction -> 
              RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {342, 65}, 
            PlotRange -> {{0, 342}, {0, 65}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"c4b9fe5d-2c46-4fbf-b9e8-84f5ced070b1"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["26.4"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"524b2721-cd29-4a54-987e-00049b5f0645"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"bdd26239-1a47-496c-ba6c-7be81c833711"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"57fdc5ec-76c3-47b9-ba8e-a066950d2502"],

Cell["\<\
Make a table of G5 countries, together with their flags, and arrange the \
result in a fully framed grid.\
\>", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "26.5", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 26}, {"ExerciseNumber", 5}, {
   "WebOnly", 0}},ExpressionUUID->"c310d800-d5ec-4aec-b32d-15c0f3451223"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"3d82db73-1861-4afe-9e4e-0d94a08a300f"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztnX9UW1W+6FHXu+/dNf+gc+9dd92ly/XenbXeves9Zp73ivqeiqMjjg7+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            "], {{0, 417}, {267, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{267, 417},
          PlotRange->{{0, 267}, {0, 417}}]], "ExerciseOutput",
         ImageSize->{271, 417},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "d116bd7f-0ec1-468b-b46f-21b7de2932d3"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztnX9UW1W+6FHXu+/dNf+gc+9dd92ly/XenbXeves9Zp73ivqeiqMjjg7+
mozijMqgzsBQRyy0ouk4FFoc0DikVAwjklKpaMQCCp0BKo1iymRKU0opjRQi
SRsKlNCkDU3TkNKet885IRz2PuFncvamfD/rqyvunHOy8937c/aPJPjfX1iv
yrw2Li5u439D/1I9/9q9GzY8v+ln8eg/nnx547rfvJzx64defiXjNxkb7njh
OlRYc01c3HfQP/xjDgCAyMQBADAvtB1du0DyGQcEoQskn3FAELpA8hkHBKEL
JJ9xQBC6kMn/16QPKEbZO/unR0YpxtkfP0ExLn74KdlAIAhFyOTH/auOYhRu
P0glD2Hc//5/KYb/XT1WHxCELiAIBggCSAFBMEAQQAoIggGCAFJAEAwQBJAC
gmCAIIAUEAQDBAGkgCAYIAggBQTBAEEAKSAIBggCSAFBMEAQQAoIggGCAFJA
EAwQBJACgmCAIIAUEAQDBAGkgCAYIAggBQTBAEEAKSAIBggCSAFBMEAQQAoI
ggGCAFJAEAwQBJACgmCAIIAUEAQDBAGkgCAYIAggBQTBAEEAKSAIBggCSAFB
MEAQQAoIggGCAFJAEAwQhLtymdu7gSu7mdt6HbcljpVAlUFVOqjjLgWUTAYI
grHWBUHdT/Ndbss1nOsoFzzLBT1c0M1ETLm58W5uxx2c5gZeYaUAQTDWuiB7
N3KNz3CXkBoTjAYaTQ6WK5YPEARjrQuCpjHoRj2nT47ZzY2dxsYuabQ2Ol1j
dAQ5fYDbdpNi+QBBMNa6IFuv5aZcc/ukw5Acn5GIh95soyMIqh6qpFKAIBhr
XRA0gcH7pKNeFZ9d0uiddHhdtnAEqNghxhblEgKCYIAgsoLk6UxE+XBHSbre
UNdSkpqRmGr1TPgGGvWZScL4kqApLHd6+MOmh+o0meouc11FWgJ6Kjstt3c0
NDcbMZbni2OTKrXJ1CMWoouEjlSlNxktIAgIsioEyS6p83ps7tF+Mbwe1Mkd
TWmh6VZ+TrHTY9Hwj1PqG2pbdFl8eU41GmV8llLxmLwcdb1WKE8rR+VuU4Hw
WN3eXK7hNUnoGp0IDFQLB6fWN1RWCBevaO0DQUAQxgUJizAbJW28OHx5utUl
HDZp0iQmtAyEzmrPRONCsRcJcoQXJF+3Ryzv1aIhJsvutyHpMpJznX7h+NE6
YVFzrD0HXTB3JPS6Nv76qlIfCAKCsC0I35nV5b0WY6+5TYg91gFbqLxkT/jI
6VFzR01xhTo9XyVIlMb3bVGQ+iMO8ZjBqhQ0yvQOG/ORNVWz07aAxxHw2wz8
iUkVJWo9Cq26CF0kucANgoAgzAsitwYRy42hHh6aHcUXqXMNhmpDTujmLwpi
sNikglgJQfjwW8p4I1LKCrPK1HzotQV6XTUIAoKsBkGM85db+Z6f1C1Ot4Jj
TWnzCuISXFDXhi7l2pOdGL/LfIQfktLKp2dewt5QUKFrlNkuA0HoAYIsTxBn
QzovQqvJ7bS0a1P40SRZbfeMyQrS65mw6vj9rgpD27jTZMgMLdLthlRUqKlq
HHf19xrU/NJe2waLdBBklQrSJC33GMvCnyeqsgz83i+/lg9Yy6VrEHsNvyc8
OIke97eok2Y/dmw2i9fsKEkJF+apK2XmVyAIVUAQmQ652Bh2D/WMj9rEOZLP
ZfP5FzjFN9o/7uzHDgu4+kaG+tyu4YgngiD0AEFWIIhSAYLQY60LIvNdLMYC
votFlbUuyLab+K/LUrdgnuC/zXujYvkAQTDWuiBt6/lfS1G3YJ7Q38a1rlMs
HyAIxloX5PI0p7me23E7f6Nmaq6FKoOqtP1mvnr+UcXyAYJgrHVBEFPn+Vs0
msagqT71n6LP/ib9Wr5KqGLIlMtBxZIBgmCAIIAUEAQDBAGkgCAYIAggBQTB
AEEAKSAIBggCSAFBMEAQQAoIggGCAFJAEAwQBJACgmCAIIAUEAQDBAGkgCAY
IAggBQTBAEEAKSAIBggCSAFBMEAQQAoIggGCAFJAEAwQBJACgmCAIIAUEAQD
BAGkgCAYIAggBQTBAEEAKSAIBggCSAFBMEAQQAoIggGCAFJAEAwQBJACgmCA
IIAUEAQDBAGkgCAYIAggBQTBAEEAKSAIBggCSAFBMEAQQAoIggGCAFJAEAwQ
BJACgmCAIIAUEAQDBAGkgCAYIAggBZLPOCAIXSD5jAOC0AWSzzhxAAAsBG1N
1y6QfMYBQegCyWccEIQukHzGAUHoQib/ewBVyAYCQShCJl/RxSdAINscSnUH
ACdSiwC0kG0OpboDgBOpRQBayDaHUt0BwInUIgAtZJtDqe4A4ERqEYAWss2h
VHcAcCK1CEAL2eZQqjsAOJFaBKCFbHMo1R0AnEgtAtBCtjmU6g4ATqQWAWgh
2xxKdQcAJ1KLALSQbQ6lugOAE6lFAFrINodS3QHAidQiAC1km0Op7gDgRGoR
gBayzaFUdwBwIrUIQAvZ5lCqOwA4kVoEoIVscyjVHQCcSC0C0EK2OZTqDgBO
pBYBaCHbHEp1BwAnUosAtJBtDqW6A4ATqUUAWsg2h1LdAcCJ1CIALWSbQ6nu
AOBEahGAFrLNoVR3AHAitQhAC9nmUKo7ADiRWgSghWxzKNUdAJxILQLQQrY5
lOoOAA6Z/Dvi4iAoBtlAMRTkymVu7wau7GZu63XclrjVF6jaqPIHddylQIwy
RCZ/KC4OgmKQDRQrQVCn0nyX23IN5zrKBc9yQQ8XdK+ymHJz493cjjs4zQ28
7DEABGEtyAaKlSB7N3KNz3CXkBoTqz7QaHKwPBZJAkFYC7KBYiUImpyg269M
fxtzmmt3leRWFObqtaWdFss09f6/YJw+wG27KRZJAkFYC7KBYiXI1mu5KRfR
2fqbchIyEuNRZCeHHmRklrupKzB/oDeC3k4MAEFYC7KBYiUImpYQPa27hJei
SFvn9QslfluXLp0vMZjpWzB/bIlJlkAQ1oJsIOUEcdZlo/Eip3runKpPn4wK
KwPCf/oGGivSeImyVelNRot4zEhrQVFJZXdzMTq93nKsoyS9oqq6qSSVPywt
t9tq7tCmC4NRSpO5n5u5jj4zSShM0BSWOz18obO5oKiwvKu5OE8YuYpKan3B
CXuDOj9NPegJ1cdrqcxXpXcNDYMgazPIBlJMEJ+lFHVLg9kW6S4dGKgWunRq
fUNlRRrfhyta+1D5YFVKaFamSu8YOF4vPJWhyqrX5WaLk7TEJL2uoCiZd8Q6
iQYmi0bwpb6htkWXlSFYGZBcp0xXqhdmevk1Jq+lmH8hY59Qh7GOHHRAut0P
I8gaDbKBlBPkyBxB7A25eaqU/LTUoszU/MwC5+RwO985c0dCx9t4EVSlPr5j
84OFIdSHHXx5csG4cJhVx/f5jqExQUDU1RM6nWPcpEmTmNAyEHrd9kx0nWLv
zHWajjhCI1difJ7OyAUtZTMGoROLkIbaPTDFWrNBNpDCgtRbxP7JT3g0OVkV
hVnChCel12MzqPixoKJErUehVaO+ikRwh+78wtAgCqISO/bEzOCiHicEnB41
d9QUV6jT81XCEJMmioYOzh0P1cfRNHOdXm0Sf33/hM9cwBtkJeZXIMiaCbKB
FJxi8ZOZsuYerHxQJ/R/l3AnT04pK8wqU/Oh1xboddWzgnhkBUnKSOY7/6wg
FtvMVC2+SJ1rMFQbcsIj0ezB0usEBioFs3q6SuLDuoEgazPIBlJuke4x8oNC
Yq59UlI4uidfGEGsHr7HZqSVh5fw9oaCCl1jYOmCWPnjk7pd4vFjTWkLCMIF
+3eh9YsqBY1l+VUm2MVay0E2kJLbvHaDsN2UnN5uMo0MmbtnNpSEKRZ6ll8j
aKoax139vQY1epynbZuZR/EHLFIQZwP/KoZWk9tpadcKC/Nktd0zFlmQCXuN
uA+W0OEcA0HWcpANpKQg6H4+2FAws/UkbEypy61m1LFTB/lhxdFRkhJ+Kk9d
KX6AOFiTOnOA3BpEFRakPLQG9xjLkmdeQpVlEDaEM0raBmtmD5auQfhw1oaX
KiDIWg6ygZQVRAi/Y3yoZ2Sox+2SWQ4HXH0jQ32yTy0lht1DPeOjNnHC5nPZ
fOTOrTSGqsO7yiDIWg6ygSgIwlT4+7saKvX8ZytZznkkAkHWRpANpOx3sdiL
SaOwS5BQP/MpvEzAd7HWTJANFCtBtt3EfwmWev+PSvDf5r0xFkkCQVgLsoFi
JUjbev7XUtT7dlRCfxvXui4WSQJBWAuygWIlyOVpTnM9t+N2/va7KuZaZKBq
o8pvv5l/I/7RWCQJBGEtyAaK4W/Sp87zN140OUETeOo/MF/Ob9Kv5SuP3gIy
5XIwFhkCQVgLsoHgr5pQBARhLcgGAkEoAoKwFmQDgSAUAUFYC7KBQBCKgCCs
BdlAIAhFyOSfL4mDoBhkA4EgFJFJ/uE4CJpBNBAIQhEQhLkgGggEoQgIwlwQ
DQSCUAQEYS6IBgJBKAKCMBdEA4EgFAFBmAuigUAQioAgzAXRQCAIRUAQ5oJo
IBCEIiAIc0E0EAhCERCEuSAaCAShCAjCXBANBIJQBARhLogGAkEoAoIwF0QD
gSAUAUGYC6KBQBCKgCDMBdFAIAhFQBDmgmggEIQiIAhzQTQQCEIREIS5IBoI
BKEICMJcEA0EglAEBGEuiAYCQSgCgjAXRAOBIBQBQZgLooFAEIqAIMwF0UAg
CEVAEOaCaCAQhCJk8qdNcRAUg2wgEIQikHzGAUHoAslnHBCELpB8xokDAGAh
aGu6doHkMw4IQhdIPuOAIHSB5DMOCEIXSD7jgCB0geQzDghCF0g+44AgdIHk
Mw4IQhdIPuOAIHSB5DMOCEIXSD7jgCB0geQzDghCF0g+44AgdIHkMw4IQhdI
PuOAIHSB5DMOCEIXSD7jgCB0geQzDghCF0g+44AgdIHkMw4IQhdIPuOAIHRZ
1ckPnvW6mr9yFFcdS3+9+94Xum59yvxvjxz4vspyZ9qRR14a2KA5Vbl7snfg
ypUrtGu6fEAQuqzG5F8cHnO8uQPpsO/a7++LS1gwvv6Hu/ueee1M6/4r09O0
675kQBC6rK7knzvQi4aGRXpBhulf7jvx9s5L5y/Qfh9LAAShy2pJ/gXbyZ6H
1i3PCyw6brhzWGe4cvky7fe0KEAQurCffDQvsm99z/hf/yMqdoSj6z+fOt83
SPvNLQwIQhfGkx8YdR364fPRVSMcX/79rSM7Gmm/xQUAQejCcvLPH7Ptv/H+
GNkRjoENGpa3uUAQujCb/HNdRzuuvzPWdohxLG0Ts0sSEIQubCbf980QWkor
Y4cY/euKaL9peUAQujCY/KnxM/tvivnMigxHiZ72W5cBBKELa8lHy4HDD2Qq
bwcf1/3A02GhnQAcEIQurCX/xNs76dghhOlf7rt0bpJ2DuYAgtCFqeRfdI59
+Z3bKAqC4nh2Me00zIGmIFcuc3s3cGU3c1uv47bE0Qn00qgCB3XcpQCVHDAl
yNHUjXTtECda548O0M7ELNQEQR1S811uyzWc6ygXPMsFPVzQTSGm3Nx4N7fj
Dk5zAy+s4rAjyHnrt/uuoW2HEEefeoV2MmahJsjejVzjM9wlpMYEE4FGk4Pl
yqeBHUGOPaumrkYorv3+hcETtPMRgpogaGKDbt0RuqtvyNjZ2ub2KyjI6QPc
tpuUTwMjggTPeqP+bauVhO21bbRTEoKaIFuv5aZckbqrVZeUkZjQ61FQEFQZ
VCXFYUSQU5W7qUshjf033s/IZ+vUBEFTmsjddbAqJSMxxaqkIOIsS3EYEeTw
g1nUpcDi3IFe2lnhYV8Q30CjPhMNKPFoTNEUljuFQmdzgaaktL0qN5svT9Ib
2qbFcyd72rVZQmF8XmZux5F+4YKOjpL0ipraFm26cJ2kemMPCBLmcjBIfXeX
DEdxFe3E8LAuiN+i4bt0Sn1DbYsui+/eOdWB0AF8eVNzrSEnAT0uMpi54FhX
If+4TFfZ0VBalMwfYJ3kBWlK45XJSE411BQL5QmdzjEQRATdq6nrQAYa1Ggn
hod1QSZNmsSEloFQeXtmfIaq2Bs6IKF9YFgo7zfw/V89HnS0ZCYU1ZjEg33m
AjRYCAsZRz06IFntFFb9PksxksVgtoEgIiM7GqnrQMb+m+6nnRge1gUJTkyP
mjtqiivU6fkqYRRIK/XxByRlJPMPxOPtNakzLth6Wyt3lWQVpYmzMvEijnpV
fJ7OGLq+x5iHBLGAICFsr2qp6yAT1yRMX/DTzg07ggx36XINM0uDsCCBgWqh
n8cXqXMNhmpDDhpBZAQZDAnSp+enT/HZael6XXmTNlVekEljPggioe+Z1+jr
IBcXbCdp54YdQRz1qG+r6ySC8COCVXjQ7RKPGeOXEiFBUHmWM3TuWIean2IN
D1QiOypa+8SLeI3q8BoEEwRGEClHHs2m7oJsTB7+hnZuGBJEWEcntZjNI5bq
fH7UyBrxTzgb+H0nQ6vJ7bS0a4WFebLa7hkbrEoVFuyVI67+7hp+8Z6n3cO5
9mSjB4XVztE+a2uxuGHVfsQGgsxP949+Td0F2Ti7v5t2btgRBM2m6gQv4kMd
2+oQ1wtlyTOFqixDieBFSZsoSPbM8dmZpSN+cTs3ZeYKCXpdQR7/oMArP8Vy
gCAiPSkvUndBNryWY7Rzw5Ag4kpkfKjHabW4J+cUuod6xkdt4icdPpfN5xfW
IKpyX3BMfEp6Ed9o38hQn0/YsJqetHk9w/PsBoAgiKNPvULdBdnwHbfTzg1r
giw2hEV6sW8FVwBBwhx/6Q/UXZCN4JmztHPD6HexFhakJjUjrTyagqzh72I5
3/mIugtkdNxwJ+3E8FATZNtN/BdoozsErCT4b/PeqHwaWBDkzBdm6jqQYfl/
z9JODA81QdrW87+Wou5FOPS3ca3rlE8DC4JcOje577ofUDcCi8FX/kg7MTzU
BLk8zWmu53bczt+6VzDXWmmgl0YV2H4zXxn/qPJpYEEQRFfiz6kbgcXEX0y0
s8JD8zfpU+f5mzaa2KDJP7XfpF/LVwBVA5lyOah8DhgRZKhAR90IaXz5ndum
fUz8XxLgr5rQhZHkX/jWSV0KaRxL20Q7JSFAELqwk/xDd6dT9yIcbuMB2vkI
AYLQhZ3kT/z5a+peiNF161O0kzELCEIXppJ/4P88Qd0OFK7PjbQzMQsIQhem
ku/psFC3o/veF2inYQ4gCF1YSz7dv45l/LtbfN8M0c7BHEAQurCW/KDH23nz
A7QEOVlaQzsBOCAIXRhM/rm/HTH+l1uUt+PIo9m037oMIAhd2Ez+2Ed/Vvjv
9Hb951Ns/v/TQRC6MJt85/Zaxeww/9sjUy437XcsDwhCF5aTz/85oNh/ibEr
8edTEx7a7zUiIAhdGE/+xF9MMf2/eR59YgObM6swIAhd2E/+xZOjljvToq7G
l39/q/Pdj2m/uYUBQeiyKpJ/5cqVU5W7oziU9Dz8W799mPbbWhQgCF1WUfKD
Hu9Qga7j+hVp0n3fr9j5IuJiAEHosuqSj5YMaPF+6J7nlrQP/PU/Jh1/ucTb
baVd/SUDgtBl9SZ/yuU+XdfWv67o0N3pX//TPZgRxr+7xfzvj/b+dL3jzR3e
g31Xpqdp13eZgCB0uWqSfzkwNTXh8TtOBUbGL0360LKFdo2iAwhCF0g+44Ag
dIHkMw4IQhdIPuOAIHSB5DMOCEIXSD7jgCB0geQzDghCF0g+44AgdIHkMw4I
QhdIPuOAIHSB5DMOCEIXSD7jgCB0geQzDghCF0g+44AgdIHkMw4IQhdIPuOA
IHSB5DMOCEIXSD7jgCB0geQzDghCF0g+48QBALAQtDVdu0DyGQcEoQskn3FA
ELqs6uT3/MP/WkzQruaKAEHoQibfmvHaUNc3J06dXTDMh51pG+u/d982xQKr
6vIEUbLCKJ56ua7z0EkxY44TEwO6j47e+XjvLQ+Q0ffwc7bPvyQbCAShCJl8
vlP98w9O5mwOnDy1mCt0Hjrxo7Sdcd/LVyBkqrp0QZSpKoq7nqrqOGAXX/TK
pUtnPv7MeuuDsjW03pJ8ZtfuK8GgbAOBIBSRF0QM9jSJWFXGBImKGuEGAkEo
Mp8g7GmyQFUZECSKaoQbCAShiIwg//i/ZRqUDU3wqrIkyN0/10dXjXADgSAU
IZPv77c5frVBvrMtRZP9luhrgr0EI4LESI1wA4EgFImUfDY1wS5OXZCYqhGq
LQhCFTL5b1ftv+CfEh9HS5NoTbqwy1IUBKlhOugQLxgtNVDaUfLJBgJBKEIm
H7X+P9325h/1nVHXZOWjCXZBKoLEYtRAqUYJR2kn3yMIQhdZQcRgUBPsUgoL
Ems1ZN8jCEKXeQRhUBPsIooJoowaIAiDLCgIU5pgpysgiJJqgCAMskhBGNEE
OzGmgiT9Qmk1QBAGWZIg1DXBTomRILTUAEEYZBmCUNQEOzjqgtBVAwRhkGUL
QkUT7LAoCoLU+LrLIR5ASw0QhEFWKIjCmmAHREUQdtQAQRgkKoIopgn21AoF
YU0NEIRBoiiIAppghcsWhE01QBAGibogMdUEY3mCMKvGcgS5cpnbu4Eru5nb
eh23JQ5iCYEyhvJ2UMddCszTuKv67rQ8QVYX8wmCWlbzXW7LNdzEN1zQywU9
XNANsdiYOsOdtnA7buc0N/D3mcj5j1XTxp61LsjejVzjs9zli1xwAmL5gUaT
rrJ58h+rpo09a10QNEOYsBIt7hg01nVb+6WF0y5zZ+setz9iJ/EOtHWazNPL
6WBjTlNt15H+uYW23tY664BDWiursbGzudHpGbOb8OotI6ZHTR3Nbd6oCHL6
ALftxnnyH6umjT1rXRA0iw6ew5vb05aXGJ+tbZMW+iwFGYkJvZ6InaS3JD4j
Uc33N3+PITNlV7Nl0R3MYUiMz5j7ckQdbC05CRnosJxKd9C2Cz0o3LPCXu2z
FM//jpYQUy5u67Xz5D9WTRt71rogaG4QPIM396QxPzE+T2ec052OlGYkJlkj
d6dpV59zSLir+03C6aZFd7DhJlV89tyXE+uQHyoM2ZFXUhcQnvUOWUZGh1fY
q6etC7yjpcWWiBZgyV9kl4OIXSxREKKt5xVkeqhOk6nuMtdVpPGdNjstt3d0
DB0wYiwu09YF/D270uL5W31ifEWDmT9xoDF0pCq9yWgJX3DEWJqfjMoTynTF
GuLlQnWoQpY5RDvytY0z87fhTm2WMEI5OkrSK2pqW7Tpwism1Rt7Qp1/1Lgr
J4V3Kqe4y1hZUVg+4hfL2/SZSUJ5QYchNyMxRRRkxFRelCxUOzmlPlRJ4eJV
1U0lqeLb7LaaO0IvlNJkJiZ4IMjqiZgK4rOUiv0/L0ddr83iH6eVoxu7VZeU
kVzs9fe3FKaIvQh118BAtfA4tb6hskIQp6K1D13NbSoQemN6fVVBvnC1/CrZ
EaS2pVAYO7TSCZWjPlkccRxNoozJqYaaYqGHJ3Q6xziPsUjwZVdNeUXI1hR+
KjVpEsoTKqpKw+XoHYUqk6buMNbpM4VKNvfwryIeo8qq1+VmJ4rHJ+l1BcIL
pVgnQZDVGisVxCOd3hCC8A/Qs6Ee26tFN+Qsu39isAoJUurjC81FfIdHw8dw
ew7qS7kjoYvY+C6nQsfYDCrUq9Wh8tE95MshQYpCfZKPbHV1QCqISvRX6MPJ
aqcwOghriniD2WY38Pf5piOO0ItmhkRwNkjLHU2hchu6WoaqYDx08X4Df81i
b+jioXKrjre+Y2hs5oUEE0GQ1RkrFcRvLiNHEL5XzApSH+pmyIsU8f48K8js
ACSIkJhUUaLWo9Cq+T6fXOAWBZwdMvg1iOwUi7+ZGxpbCvlJkcZglhFEeqLH
iNb1BotNGMtEVfkQvEAijHUVij0/VO7lB44k67BYmdkVk70mVTh+zsWFt6ke
n71X8CaCIKs0ViqIOHURJk7hwsFQt5npHhabVBCrrCB+S5kwqy8rzCpT86HX
Fuh11YQgjkiCZJc0Co9NGmFqJN7AIwoinIIq1lkojlOYII6Z8WtmEdQqrEGG
scqE3ykmyKx0WAZAkFUXKxeEn3UkZg3OTrMd7eqExQriCd+TheuklYc/HLE3
FFToGgPiWkBdN3PxvooIi/Rwv/WKC5/QrCyiIOIIIlQpdTD0kc1wx0zNhWnS
7NpBmBymWF2CxYXhygzzUy+VMMUCQa7SWLEgE+NGtdAhszotlpEBo0HYRxLv
57KCzJli+c3ohp+dU2ofddgN/BaQpqpx3NXfa1ALy23+o41uvnPGl9W0uV09
4gyKXINgGwXiKcJqfQFBxBqiClgHLJ26lPAiPVxuH+0fbC4IL9IFU9Bcrs3r
sXXX8NsORfx0DgS5amPlgnDBsd6qrAzJMjlPXS7OwAPWcukaRJixp6KxZrAm
ZWYCMybctOMzStqEzdIUyUUq3aFlTl99ZkKoPDm9Io0cQUxFc5cGXLBHz49r
8S3W4/NOsfiKjRhL80IXTxE2oNTiNu8gv7UbqkwRv9/L1xxVpiknIVyeX1Lr
mzNOzdwHVGFByiWLfRBk9UU0BBG7nGN8qGdkqMftWfKncgGPIzDzvZSAq29k
qM/twi/idaKL9weWeOWFX9pp7Gje40Wv7ufXLOL+c3jpIVQGvaMxjqiMc8Ay
MupY5uuCIKsnoibI6gxxvzevsNI+1NNdk0t8jBKbAEFWTyxBkK3X8d8jot2l
ox2OTt3s/LBIWxf1QQqPpXwXi3r3gFiCIGU3899Epd+lYxFjgUmHj5hKxSSW
8m1e6t0DYgmC7N3A/1qKfmde5aG/jWtdB4KslliCIFcu87+G23E7fw+8Cuda
MQ6UMZS37Tdzmus5f8RffMPX3Rlngd+kBy9yrb/lZwhoFk39V96rK1DGUN7Q
2DE1zl3yzpP/mLSrIoAgQKxZ1ckHQYBYs6qTD4IAsSZGfxcrHPc+Ux3+f/nN
T+DE8MmczT3//APZTu741QZ/vw07JRaCXAkGz+zabf2PB2QvZb31wTMff3bl
0iXxYAX+T74gCF1iJ8h9z8ZQDZHlCRL+c3bzQFETsoFAEIrEQpAlqHHy1CLV
EP96IXb68gTB/urjPIQ0uSVZSU3IBgJBKBJdQWKnhuz/AXZ5gohVZVYTsoFA
EIpES5BYqyHbeVYiCLOakA0EglBk5YIgNVB/WMxrrUSNGAnCoCZkA4EgFFmJ
IEqqEVNBmNKEbCAQhCLLE0R5NRQQhBFNyAYCQSiyVEFoqaGYINQ1IRsIBKHI
4gVBLUtRDYUFoagJ2UAgCEUWIwgLalARhIomZAOBIBSZXxB21KAoiMKakA0E
glAkkiCsqUFdEMU0IRsIBKEImXw21WBEEAU0IRsIBKHI8pKvvBpMCRJTTfDa
giBUWWryaanBoCDKaAKC0GXxyaerBrOCRF0TsoFAEIosJvksqMG4IFHUhGwg
EIQi8yefHTVWhSBR0YRsIBCEIpGSz5oaq0iQFWpCNhAIQhEy+WyqseoEWbYm
ZAOBIBSB5DMOCEIXSD7jgCB0geQzThwAAAtBW9O1CySfcUAQukDyGQcEoQsk
n3FAELqQyX/0znVsxsf3PLnv3sev+iAbCAShCJn8u+58ORw/um+j9D8XLI/p
Ke//z3ua/8etV32QDQSCUGR+QT7+yCjbdd/W1D2VupUsv/uu9R99tE/2lG3a
3T9TFZDl9yTl1H7YLntK+TuNjz36exAEBKFIJEGe+Fnht9+eunhxquUvB+7/
0SvSfrt9e8OFC4Fz53zZL70jLU99covdPub3TzU3mbGbv+7dz/3+i2fPnv/t
i9ul5b/4edGJE6f9/kBDg+m+ezdIRXvvvWZ0itvtzfqNFgRRqjsAOPOMILW1
+wYGhl99tRK7sf/kIbXdPnr4sI2853/66VeDA8Mbciuw8kceft0+NGqxHCdP
QWoMDg5jrqH46eP5Q0OjBw58AyMICEKReQR5OOV34X+jeObpP4gPHnpQjeZF
KT/ZhO7z4hwpPN2KdApyKunu9Q+nbBL/894f5j75ROGCp6Drh09B0VndMNpq
vOqDbCAQhCLzr0HEQFOs3Bzdt9+OqF97H93YpU+lp7/5fmWz0XgYmzsl35+H
TkFDQF5e5eOPzTnlufS39PqWL76wvLiuTFr+QDJ/isMx9srGP0mXHuE43u+k
kiK6gCB0WYwgd/Gr8k8CgSmz2YrGC2k5usO7XOcuXLiY/ss3sVPKyhoCgaDp
6140dmDTLbSy8PkuPvtsMXbKnyqa0Kvs23dYHJtAEA4Eoc0iBdmkrirYvPOd
7Y1YOer8NTV7dbrP0aIee+r3r+8o2PwB0gQrR4qhU/70p2ZsMEKxOX/n5vxq
rXa3bB1AEEB55hfkjTdqZfvqq3mVaCUi+1SkU5BiaBIl+1RR0Yey5a//bod0
Aw0EAZRnnm3er78+cvFioLa2HdvmLS391OU6i7oruc27f/9Rvz/w4a4vsG1e
NI5MTJyzWk+Q27xo2oamWx98sBfb5i1/p/HMGe+xPkd4m7etYPvx7e9f9UE2
EAhCkXlGkE8++fL8eT9aOGM39vvu24jKbbZT5D2/sWE/6u2YBXcJa3Z0Sn//
SfKUPXvM6JTfZJZi5T956DWfz3+szx4ugW1eQHnmEeTFdWVoIPjVC2+L//nj
B14VH6hUBWh8WbeuLLyUDj+F1Ei+/5UXntdg5U8+Uaj66WbptlV4uiWckvdc
+lvYKWg8evyxfKlrIAigPItcpKP4/LNObD9KjOefe6v0j5/KntL0+V9lyzMz
St8s+Vj+lCb5U0AQgAqL/ByktfVgIDB14sTp8Ad8YuTk6PwXAlNTl7CtJzQo
tLcfCgSCQ0Mjqrlfwdq4oQItbaamgm9r6qTlaEz56qsedMrg4DC5wQWCAFRY
5Ajyu9/pD/ztmw8//IJ8quvAN729Qyk/2YSVb87f+be/WXfubCVPsViOHz06
9OCPX8PKt27ZhU6pev/PsnWoT8vtytxw1QfZQCAIReYXJLwAQSNC+N8o0n/5
5g/vyb1L+BxE3LBCS4/5T0GrDPFDRvRvccNqwVPQWkb6iSFs8wLKM88271tv
GUZGzhQW1mDbvK+9+v4hy8DHHxkzfv1HaTlaVr/9dt3w8ERhwQfYNq/6tfcP
H7bt2vVF2AUxnkrdWlr66cmT4+gUbJt30yY9GmV27mwLL/lBEEB55hlBjMbD
aEWwpbAGm+ogES5c8I+OuskfOplMR9Epr7++Ayv/+VNFFy4ETp1y3Xcvfgqa
U6FT8vLw7ww/8/Qf/P7AyZOnw+KAIIDyzCOI5q1Psl96J++V98J39fBtv6Bg
57vvfhYuCT9A6+6Xs8vRMhwrf/oXb+TnV6NTpGOE+KD0j5+uf7k8Z/27WHna
syW/26QvL589BQQBlGfx27zbInxF6vHH8tF0aEmnoPnbq8SQMf8pKI50HLrg
PHXVB9lAyxHkymVu7wau7GZu63Xclri1HigJKBUHddylQCwEQWuQ+t1fX7hw
8dChAXKb1+kcd7snyW3ezxr3o2nVgQPfkNu8aK7ldnvJbd6mz/+KplXmvx6D
bd4VCYK6gea73JZrONdRLniWC3q4oHtNx5SbG+/mdtzBaW7gbx3RFoQXYf27
Z89OfvLJl+RTNtups2fP3/vDXKwcjREez/kPd8nsDNvtox7PJPbN+buEzWR0
yo4dLbJ1AEEWy96NXOMz3CWkxgTEnECjycHyKAoS/qHfs88Wo/6cnv7mTHno
U4+ku9ejxQI6LPwTp/ApqBw9KzklVI6u8+wzf3j0kdcfefh18hS0BiFPAUGW
JgiaTqAb5py+4Rg01nVb+6WF0y5zZ+setz9id/IOtHWazNPL6YpjTlNt15F+
2Ws2adUVhbl6bXGH2RxQWJDTB7htN0VFEDSteuzR1zs6jiAXxI88JNZs+uCD
tpdfLn/owTmf9CXf/8rjj/3+qy970AHk76o+qm1/cV0Z9uEgOuVnqs1GYzd2
ivhj27pPvsrMKA2fAoIslq3XclOuOR3D05aXGJ+tbZMW+iwFGYkJvZ6I3am3
JD4jUe1Fj/09hsyUXc2WRXdFhyExPmPuy6GwG7IyUHlifJ4qSXyQkVY8Ljzl
bFbnF9b65rnmkusgFygtKDnREAT1z+PHTwYCQdRLsd5eWFjj909NTl4If8NQ
DDQi2GzDgcBUbe0+7JQ33qi9eHHq3Lnzv0wrkZajcQdNt9ApyDjsi14lJR8H
AgE040LDDQiyNEHQRALrGJPGfNQtdcY5ghwpzUhMskYWZNrV5xwSRgG/STjd
tOiuONykis+e+3JcsKcCGZFZOjIZkqhLm4oc2WXiX8JelZSRXDrfgLLkOkSI
LUtL5jxTrOrq1uamv+b/vhpbC6h+uvnLLw/v29dNLhM++GDvnj3mTeoqrDz1
yS3Gfd1ffHGIPKX2w3Z0SngzORxP/+KN9i8OtbV2hUuOHR64dN531YfygkwP
1Wky1V3muoq0BNRjs9Nye0fH0AEjxuIybV3A37MrLV684Vc0mPkTBxpDR6rS
m4yzt/QRY2l+MipPKNMVa4iX4zx8HbK1ksJJU1lyfEWzBQ0f2fz1E/IyC+yT
/PX1meIQk6ApLHd6+OFjUXXw97Vr00ODVE7xoGsspoKI6+7w6vulmZ9HiSVo
jBA/s0DTpPDn4/OfEp6q/fiBV59/7q0lnXIXfA6yeJYoiM9SOtOp1PVaYRaU
Vo5u5lYduqsXe/39LYUpwgEp9caewEC18Di1vqGyQui0Fa196GpuUwFfnpxe
X1WQL1wtv2quIJOmIqHPl+kqe49YvJ7Z3jtiLC9SoaeSyrSVI5MWjfhaDbUt
OqEyOdWBxdWBr3BivL6musNQIBhX4I6lIOFA6xGtdveZM97qHS3YNu9Lv92+
t81itToKNn8wd3GRt0272+OZ1Ff9BdvmfTm7HI0+R4/a8/PnjE0PJOeVbas/
e/b8+5V7ZLd5QZDFQgoi3L3zIwnCP0DP7hHLe7Wom2XZ/RODwrRHWBeYi/gO
j27dw+05qOPljoQuYqtH/VOFjrEZUA9PVofKR/eQL8dLZKkU3REjW5VqaDaK
mwD2mhT0WtOCR5rEhJaB0Cntmej6xd7F1yExSywPHKksyil2klsQMRDkLuEX
5Wil0NLShZWjcWRkZOLChYvkt3kLNu9E6w7y9x1oUBgbc/t8F8lftf9BWKrs
3v21bB1AkMVCCuI3l5EjiKVYKkj9EYdYPliF7tUpaPE+K8jsACR2wqSKErUe
hVbNDwrJBW5RwNkhg1+D4FOsUIy5h8zdzZW71KmiJhqDWXjRsIwT06Pmjpri
CnV6vkpcyC+uDrza4iiTUKRWtxtN8kv+qAoSXmvnrH8XLZYLZ76XFS5HK+vi
4o9yc3Thv2oSfmpDbsUzT/8hPLKEy9EDJMIrG98LDxPhpzZu/NMzT7+xOX8n
Vg6CLO0cUpCgoyktNHEKFw7WoC6aEhbEYLFJBbHKCuK3lPG9MaWsMKtMzYde
W6DXVROCOEhBAkONFepS56R0XDPxV1OVeiWCzEyf4ovUuQZDtSFHHB0WUQdx
tmapReplhwap9EFyCyKqgqDZjuzNvKjoQ7RUl32q8j35U0pKPn70kdfJcvHP
8MqeotF88pOHZkeZTx7P6Ez91VUfMRKkXph+DM72T0e7OmGxgoT6vyl0nbTy
8Icj9oaCCl1jQFxfqOtmLt5XIT9gxetN/XithBnU4MwulpV/9aRuV2i4aUqb
EWTBOgTROiW9yRx6F87mXH6LbOY/oy4IGhGOHbP7/YHmpr+Sf7za670wftpD
/lWT/v6TaLrV0GAi/3g1OgXNrMi/ajJw3ImmW2haRf7xaq/Xh+Zv8MeroyHI
xLhRLSyiszotlpEBoyFH2AIqaZxZjOCCzJli+c1o4ZydU2ofddgN/NRIU9U4
7urvNfDXzBM+7+jmVy7xZTVtbldPS2FSBrkG8YiL9PhdDW0jzj7nkT31av6w
ohp+59aqQy+a2mGxfNvAb0MZWk1up6VdnDIlq+1oRb9wHWyGZP4m0DXQ73P1
derQMQldozEcQT7+2Hj6tGfDBvwvUaMF+Pj4Wav1BHnPr9/9NToFLcOx8oce
fM01fvZo7xB5yuefdaJT1mVtw8ofTtmEXuVw9+DscAaCrEAQdDfurcrKkKyR
89Tl4od0AWu5dA1i56deqWisGUQLZ/HuHRzr4Ieb+IwS1A8dHSUpkotUhnaK
/H31mQmh8uT0ijSZNUhgoFGjipfWQaOr84r+tqrF5UPvsLEseeYAVZahJHXm
dReug9dSmSe9eNUema8BRE8QNCKE/y2NRx5+HY0paIgh/0CoeDC203WX8IHg
ffduJMvFU9B1yD/MKJyyQfrqIMjKBBFi0jE+1DMy1OP2DEc8JkIEPI7AzKZQ
wNU3MtTnduEX8TrRxfvn/QLJGDrGbrU4h/p8c7eYpieHA5Pi3u+we6hnfNQm
dm+fyxY+cuE6+Pk36BywjMt+CBLtNQhTAYJEQRCIFQvy/mvb2Ywj739k//DT
qz6iIAj5XSwIMaLxXSyAKZYjyLab+K+tUu+NDAb/bd4bl5r/pSUfUJblCNK2
nv+1FPXeyGDob+Na1y01/0tLPqAsyxHk8jSnuZ7bcTt/w4S5VlCYWaFUbL+Z
T4t/dKn5X1ryAWVZ5m/Sp87zt0o0nUBTbuo/CaceKAkoFSghyJTLwaXmHys5
8XEDBMWIjiBAlCCTT32fc40H2UAgCEVAENaCbCAQhCIgCGtBNhAIQhEQhLUg
GwgEoQiZfNNP0yEoBtlAIAhFIPmMA4LQBZLPOCAIXSD5jAOC0AWSzzggCF3I
5E9fvAhBMcgGAkEoAtu8rAXZQCAIRUAQ1oJsIBCEIiAIa0E2EAhCERCEtSAb
CAShCAjCWpANBIJQhEz+eftJCIpBNhAIQhFIPuOAIHSB5DMOCEIXSD7jgCB0
geQzDghCFzL5lhdfhaAYZAOBIBSBbV7WgmwgEIQiIAhrQTYQCEIREIS1IBsI
BKEICMJakA0EglAEks84IAhdIPmMA4LQBZLPOHEAAMwLbUcBgGn+PxLal4U=

              "], {{0, 417}, {267, 0}}, {0, 255}, ColorFunction -> RGBColor], 
             
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {267, 417}, 
            PlotRange -> {{0, 267}, {0, 417}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"773c6e09-f53f-44c3-b0c8-c96211195416"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["26.5"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"690ee224-322e-4305-b4ef-f4f0e74f2f0a"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"6f05e4a0-7f38-4b3b-ab0b-ac75ef256b99"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"0ef26bbe-1588-4c13-8f10-e085f38107dd"],

Cell["\<\
Make a list of word clouds for the Wikipedia articles about apple, peach and \
pear.\
\>", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "26.6", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 TaggingRules->{"MultipleSolutions" -> "True"},
 CounterAssignments->{{"SectionNumber", 26}, {"ExerciseNumber", 6}, {
   "WebOnly", 0}},ExpressionUUID->"8eeed8e9-0b50-4a01-ac90-9b99f2ead8f8"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{
    "SAMPLE", " ", "EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"0ae731d8-d125-4929-a189-16651625b656"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJzsvVlwG1ea7+k7ExU9MfMyjzMxTxPRz57ojq6Kjo550a1wRd+6MaHq63JF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            "], {{0, 399}, {386, 
            0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{386, 399},
          PlotRange->{{0, 386}, {0, 399}}]], "ExerciseOutput",
         ImageSize->{390, 399},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "4e2bb851-b644-42da-8f3f-7f2bcb6c88d8"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJzsvVlwG1ea7+k7ExU9MfMyjzMxTxPRz57ojq6Kjo550a1wRd+6MaHq63JF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              "], {{0, 399}, {386, 
              0}}, {0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {386, 399}, 
            PlotRange -> {{0, 386}, {0, 399}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"b99db3ab-d037-4e87-bd32-3f49dff30b95"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["26.6"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"0118d7af-13ff-4d85-8b3c-bbf6cb4f2a54"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"b5c73fd7-f5a4-46f1-a1c5-a5faf8ff1f78"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"8416894f-23f8-4f38-a1b5-49f83d2da410"],

Cell["\<\
Make a list of histograms of the word lengths in Wikipedia articles on apple, \
peach and pear.\
\>", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "26.7", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 TaggingRules->{"MultipleSolutions" -> "True"},
 CounterAssignments->{{"SectionNumber", 26}, {"ExerciseNumber", 7}, {
   "WebOnly", 0}},ExpressionUUID->"2292512a-a05e-4f1d-823d-90e44f17efe4"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{
    "SAMPLE", " ", "EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"b1000725-3315-4a7d-97ac-ff383a944bfd"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJzt3T2L41qex3HvTrLhvoV9AxUuy2YdbtQww8IGDcsMO2dYGLSXO4OWG2iC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            "], {{0, 259}, {
            386, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{386, 259},
          PlotRange->{{0, 386}, {0, 259}}]], "ExerciseOutput",
         ImageSize->{390, 259},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "b24d3aff-55e0-4019-9433-762735a409cb"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJzt3T2L41qex3HvTrLhvoV9AxUuy2YdbtQww8IGDcsMO2dYGLSXO4OWG2iC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              "], {{0, 
              259}, {386, 0}}, {0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {386, 259}, 
            PlotRange -> {{0, 386}, {0, 259}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"8f4fd5d6-38a4-47b4-bf6f-480d6404cd0e"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["26.7"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"9ac1b784-f198-42be-b2ea-dd5810ce3c46"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"d2fe9a8f-49af-4707-b2fb-2119bddb3363"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"6614e3e7-f006-45b8-8fb7-88b2bfd4dcfd"],

Cell["\<\
Make a list of maps of Central America, highlighting each country in turn.\
\>", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "26.8", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 26}, {"ExerciseNumber", 8}, {
   "WebOnly", 0}},ExpressionUUID->"47255d4a-3f02-4692-bc07-71853b8c7fca"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"ed9b1087-fdac-4c2e-949f-72cd59d8b854"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJzsvWd0ZNd1qMmZ+TM/58f8fvast+bNLD+PHGRJtmxZpiRbtiVLViBFiaQo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            "], {{0, 655}, {382, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{382, 655},
          PlotRange->{{0, 382}, {0, 655}}]], "ExerciseOutput",
         ImageSize->{386, 655},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "46836a1a-abe9-440b-87b8-d73aedbdfacd"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJzsvWd0ZNd1qMmZ+TM/58f8fvast+bNLD+PHGRJtmxZpiRbtiVLViBFiaQo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              "], {{0, 655}, {382, 0}}, {0, 255}, 
              ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {382, 655}, 
            PlotRange -> {{0, 382}, {0, 655}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"dc96d9ff-ce8d-46b7-892d-e1c3010bc449"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["26.8"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"3a20b95c-4c3d-4838-820c-7e9ed0f57819"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"b1c5d738-8429-47d6-b304-e24d01e57947"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"16666499-4ff0-4621-b8dc-ea5d6f0dcd03"],

Cell[TextData[{
 "Give a simpler form for ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      StyleBox["#",
       FontFamily->"Source Sans Pro"], "^", "2"}], "+", 
     RowBox[{"1", 
      StyleBox["&",
       FontFamily->"Source Sans Pro"]}]}], ")"}], 
   StyleBox["/@",
    FontFamily->"Source Sans Pro"], 
   RowBox[{
    StyleBox["Range",
     FontFamily->"Source Sans Pro"], "[", "10", "]"}]}]], "InlineCode",
  ExpressionUUID->"4085bd40-50f0-46a3-b316-8280c3530a5d"],
 "."
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+26.1", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 26}, {"ExerciseNumber", 1}, {
   "WebOnly", 1}},ExpressionUUID->"d948119e-c4e2-4461-b1d8-b6b12ceb56c5"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"4e729b37-4e55-42b2-8535-288b6b7e149b"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztWa2vpUYUJ62pbNK/oP8AuhZZdZNt6q7ZzS6bmi3ZbdJgcUgcDoVCoVAY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            "], {{0, 19}, {195, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{195, 19},
          PlotRange->{{0, 195}, {0, 19}}]], "ExerciseOutput",
         ImageSize->{199, 19},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "490a5877-c228-4969-ac2e-c07a9a4ad97a"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztWa2vpUYUJ62pbNK/oP8AuhZZdZNt6q7ZzS6bmi3ZbdJgcUgcDoVCoVAY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              "], {{0, 19}, {195, 0}}, {0, 255}, 
              ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {195, 19}, 
            PlotRange -> {{0, 195}, {0, 19}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"20929bb8-7db3-4139-be99-81135c589f3b"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["x26.1"], StandardForm],
   ImageSizeCache->{145., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"cd0f5704-98ae-4fbf-a20a-81adde0dda2a"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"630cd0eb-4b7c-452d-b495-c55d3f18e535"]
}, Open  ]]
}, Open  ]],

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"73051e49-0550-4324-a4a1-52143479d586"]
},
WindowSize->{808, 755},
WindowMargins->{{314, Automatic}, {Automatic, 50}},
WindowTitle->"Pure Anonymous Function: Elementary Introduction to the Wolfram \
Language",
DockedCells->{
  Cell[
   BoxData[
    DynamicModuleBox[{}, 
     TagBox[
      GridBox[{{
         TagBox[
          ButtonBox[
           PaneBox[
            GraphicsBox[
             TagBox[
              RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UFAEiEGSIPafvQ3/iQM/qxmAiEjFmOohXKwIouDvuQXEGw4xENM6POaT5Hiq
qP97c+uvfvWfDVy/59j/ahX5Pdfx3/sHuNSDFE/UBpI/G3l+TTP9vS7p7+nZ
QBG4FjT1QJOBin+vCAcpaxcHWgEU/HOk7/ciHzzqgSYD2b/XJQO5UPFueezq
J+sDFf/qVQY64PeSgN8b0n5NMfz34DAu9T+beIFm/upV+jXF4PcC9z87K4C6
fk3SwaUeGBq/18QDDQQ5e2f5rw6pP0f7gd4BCmJVD3QG0HygBxHO61UG6sIV
nhAtwNAAOgCEgOEPMxmXevyAEvV4EidaQiU+P0IAAEIjNUM=
               "], {{0, 
               20}, {16, 0}}, {0, 255}, ColorFunction -> RGBColor], 
              BoxForm`ImageTag[
              "Byte", ColorSpace -> ColorProfileData[CompressedData["
1:eJydlndcFNcWx+/MbC+0XZYiZem9twVEehOQXkVh2V1gKQsuuxTFhogKRBQR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                 "], "RGB", "XYZ"], 
               Interleaving -> True], Selectable -> False], DefaultBaseStyle -> 
             "ImageGraphics", ImageSizeRaw -> {16, 20}, 
             PlotRange -> {{0, 16}, {0, 20}}], Alignment -> {Center, Center}, 
            ImageMargins -> {{15, 10}, {4, 0}}], Appearance -> None, 
           ButtonFunction :> NotebookLocate[{
              URL["http://www.wolfram.com/language/elementary-introduction/"],
               None}], Evaluator -> Automatic, Method -> "Preemptive"], 
          MouseAppearanceTag["LinkHand"]], 
         ItemBox[
          TagBox[
           GridBox[{{
              TagBox[
               ButtonBox[
                StyleBox[
                "STEPHEN WOLFRAM Elementary Introduction to the Wolfram \
Language", "DockedCellAuthorName"], Appearance -> None, ButtonFunction :> 
                NotebookLocate[{
                   URL[
                   "http://www.wolfram.com/language/elementary-introduction/"]\
, None}], Evaluator -> Automatic, Method -> "Preemptive"], 
               MouseAppearanceTag["LinkHand"]]}, {
              TagBox[
               ButtonBox[
                TemplateBox[{
                  StyleBox["Exercises ", "DockedCellSectionTitle"], 
                  StyleBox["|", "DockedCellSectionTitleDivider"], 
                  StyleBox[
                  " 26  Pure Anonymous Functions", "DockedCellSectionTitle"]},
                  "RowDefault"], Appearance -> None, ButtonFunction :> 
                NotebookLocate[{
                   URL[
                   "http://www.wolfram.com/language/elementary-introduction/\
26-pure-anonymous-functions.html"], None}], Evaluator -> Automatic, Method -> 
                "Preemptive"], 
               MouseAppearanceTag["LinkHand"]]}}, DefaultBaseStyle -> 
            "Column", GridBoxAlignment -> {"Columns" -> {{Left}}}, 
            GridBoxSpacings -> {"Columns" -> {{0}}, "Rows" -> {{0}}}], 
           "Column"], Alignment -> Left, ItemSize -> 30]}}, AutoDelete -> 
       False, GridBoxSpacings -> {"Columns" -> {{0}}, "Rows" -> {{0}}}, 
       GridBoxAlignment -> {"Columns" -> {Left}, "Rows" -> {Center}}, 
       GridBoxItemSize -> {
        "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], "Grid"], 
     DynamicModuleValues :> {}, 
     Initialization :> (
      Clear[$CellContext`SolutionResponseText]; \
$CellContext`SolutionResponseText[
         Pattern[ElementaryIntroToWLWeb`Private`a, 
          BlankNullSequence[]]] := " "; 
      Map[($CellContext`SolutionResponseText[#] := " ")& , {
        "+26.1", "26.1", "26.2", "26.3", "26.4", "26.5", "26.6", "26.7", 
         "26.8"}]; 
      Clear[$CellContext`SolutionResponseDetails]; \
$CellContext`SolutionResponseDetails[
         Pattern[ElementaryIntroToWLWeb`Private`str, 
          Blank[String]], True] := 
       Style[ElementaryIntroToWLWeb`Private`str, 
         "SolutionTrue"]; $CellContext`SolutionResponseDetails[
         Pattern[ElementaryIntroToWLWeb`Private`str, 
          Blank[String]], False] := 
       Style[ElementaryIntroToWLWeb`Private`str, 
         "SolutionFalse"]; $CellContext`SolutionResponseDetails[
         Pattern[ElementaryIntroToWLWeb`Private`str, 
          Blank[String]]] := 
       ElementaryIntroToWLWeb`Private`str; \
$CellContext`SolutionResponseDetails[
         Missing[
          BlankSequence[]]] := " "; $CellContext`SolutionResponseDetails[
         BlankNullSequence[]] := " "; 
      Clear[$CellContext`GetUserSolutions]; $CellContext`GetUserSolutions[] := 
       Flatten[
         Cases[
          Options[
           EvaluationNotebook[], TaggingRules], ("EIWLExercises" -> 
           Pattern[ElementaryIntroToWLWeb`Private`ex, 
             Blank[]]) :> ElementaryIntroToWLWeb`Private`ex, Infinity]]; 
      Clear[$CellContext`GetUserSolutionsTotal]; \
$CellContext`GetUserSolutionsTotal[] := Length[
         Union[
          Flatten[
           Cases[
            Cases[
             Options[
              EvaluationNotebook[], TaggingRules], ("EIWLExercises" -> 
              Pattern[ElementaryIntroToWLWeb`Private`ex, 
                Blank[]]) :> ElementaryIntroToWLWeb`Private`ex, Infinity], (
             "ExercisesTotal" -> Pattern[ElementaryIntroToWLWeb`Private`t, 
               Blank[]]) :> ElementaryIntroToWLWeb`Private`t, Infinity]]]]; 
      Clear[$CellContext`GetUserSolutionsTried]; \
$CellContext`GetUserSolutionsTried[] := Length[
         Union[
          Flatten[
           Cases[
            Cases[
             Options[
              EvaluationNotebook[], TaggingRules], ("EIWLExercises" -> 
              Pattern[ElementaryIntroToWLWeb`Private`ex, 
                Blank[]]) :> ElementaryIntroToWLWeb`Private`ex, Infinity], (
             "ExercisesTried" -> Pattern[ElementaryIntroToWLWeb`Private`t, 
               Blank[]]) :> ElementaryIntroToWLWeb`Private`t, Infinity]]]]; 
      Clear[$CellContext`GetUserSolutionsCorrect]; \
$CellContext`GetUserSolutionsCorrect[] := Length[
         Union[
          Flatten[
           Cases[
            Cases[
             Options[
              EvaluationNotebook[], TaggingRules], ("EIWLExercises" -> 
              Pattern[ElementaryIntroToWLWeb`Private`ex, 
                Blank[]]) :> ElementaryIntroToWLWeb`Private`ex, Infinity], (
             "ExercisesCorrect" -> Pattern[ElementaryIntroToWLWeb`Private`t, 
               Blank[]]) :> ElementaryIntroToWLWeb`Private`t, 
            
            Infinity]]]]; $CellContext`EIWLExerciseSolutionsTotal = \
$CellContext`GetUserSolutionsTotal[]; $CellContext`EIWLExerciseSolutionsTried = \
$CellContext`GetUserSolutionsTried[]; \
$CellContext`EIWLExerciseSolutionsCorrect = \
$CellContext`GetUserSolutionsCorrect[]; 
      Clear[$CellContext`SetUserSolutionsTried]; \
$CellContext`SetUserSolutionsTried[
         Pattern[ElementaryIntroToWLWeb`Private`value, 
          Blank[]]] := 
       Module[{ElementaryIntroToWLWeb`Private`data, 
          ElementaryIntroToWLWeb`Private`tr}, 
         ElementaryIntroToWLWeb`Private`data = Flatten[
            Cases[
             Options[
              EvaluationNotebook[], TaggingRules], ("EIWLExercises" -> 
              Pattern[ElementaryIntroToWLWeb`Private`ex, 
                Blank[]]) :> ElementaryIntroToWLWeb`Private`ex, Infinity]]; 
         ElementaryIntroToWLWeb`Private`tr = ReplaceAll[TaggingRules, 
            Options[
             EvaluationNotebook[], TaggingRules]]; 
         ElementaryIntroToWLWeb`Private`tr = 
          DeleteCases[
           ElementaryIntroToWLWeb`Private`tr, "EIWLExercises" -> Blank[], 
            Infinity]; 
         AppendTo[
          ElementaryIntroToWLWeb`Private`tr, 
           "EIWLExercises" -> {
            "ExercisesTotal" -> 
             ReplaceAll[
              "ExercisesTotal", ElementaryIntroToWLWeb`Private`data], 
             "ExercisesTried" -> Append[
               Flatten[
                Cases[
                ElementaryIntroToWLWeb`Private`data, ("ExercisesTried" -> 
                  Pattern[ElementaryIntroToWLWeb`Private`t, 
                    Blank[]]) :> ElementaryIntroToWLWeb`Private`t, Infinity]],
                ElementaryIntroToWLWeb`Private`value], "ExercisesCorrect" -> 
             ReplaceAll[
              "ExercisesCorrect", ElementaryIntroToWLWeb`Private`data]}]; 
         SetOptions[
           EvaluationNotebook[], TaggingRules -> 
           ElementaryIntroToWLWeb`Private`tr]; \
$CellContext`EIWLExerciseSolutionsTried = \
$CellContext`GetUserSolutionsTried[]; Null]; 
      Clear[$CellContext`SetUserSolutionsCorrect]; \
$CellContext`SetUserSolutionsCorrect[
         Pattern[ElementaryIntroToWLWeb`Private`value, 
          Blank[]]] := 
       Module[{ElementaryIntroToWLWeb`Private`data, 
          ElementaryIntroToWLWeb`Private`tr}, 
         ElementaryIntroToWLWeb`Private`data = Flatten[
            Cases[
             Options[
              EvaluationNotebook[], TaggingRules], ("EIWLExercises" -> 
              Pattern[ElementaryIntroToWLWeb`Private`ex, 
                Blank[]]) :> ElementaryIntroToWLWeb`Private`ex, Infinity]]; 
         ElementaryIntroToWLWeb`Private`tr = ReplaceAll[TaggingRules, 
            Options[
             EvaluationNotebook[], TaggingRules]]; 
         ElementaryIntroToWLWeb`Private`tr = 
          DeleteCases[
           ElementaryIntroToWLWeb`Private`tr, "EIWLExercises" -> Blank[], 
            Infinity]; 
         AppendTo[
          ElementaryIntroToWLWeb`Private`tr, 
           "EIWLExercises" -> {
            "ExercisesTotal" -> 
             ReplaceAll[
              "ExercisesTotal", ElementaryIntroToWLWeb`Private`data], 
             "ExercisesTried" -> 
             ReplaceAll[
              "ExercisesTried", ElementaryIntroToWLWeb`Private`data], 
             "ExercisesCorrect" -> Append[
               Flatten[
                Cases[
                ElementaryIntroToWLWeb`Private`data, ("ExercisesCorrect" -> 
                  Pattern[ElementaryIntroToWLWeb`Private`t, 
                    Blank[]]) :> ElementaryIntroToWLWeb`Private`t, Infinity]],
                ElementaryIntroToWLWeb`Private`value]}]; SetOptions[
           EvaluationNotebook[], TaggingRules -> 
           ElementaryIntroToWLWeb`Private`tr]; \
$CellContext`EIWLExerciseSolutionsCorrect = \
$CellContext`GetUserSolutionsCorrect[]; Null]; 
      Clear[ElementaryIntroToWLWeb`Private`GetCurrentTallyCell]; \
$CellContext`GetCurrentTallyCell[] := Module[{}, 
         With[{
          ElementaryIntroToWLWeb`Private`solutionsTried = \
$CellContext`GetUserSolutionsTried[], 
           ElementaryIntroToWLWeb`Private`solutionsTotal = \
$CellContext`GetUserSolutionsTotal[], 
           ElementaryIntroToWLWeb`Private`solutionsCorrect = \
$CellContext`GetUserSolutionsCorrect[]}, 
          Cell[
           BoxData[
            PaneBox[
             TemplateBox[{
               StyleBox[
               "COMPLETED\[ThickSpace]\[ThickSpace]", 
                "DockedCellCompletedExerciseText"], 
               StyleBox[
               ElementaryIntroToWLWeb`Private`solutionsTried, 
                "DockedCellCompletedExerciseText"], 
               StyleBox["/", "DockedCellSolutionDivider"], 
               StyleBox[
               ElementaryIntroToWLWeb`Private`solutionsTotal, 
                "DockedCellCompletedExerciseText"], 
               StyleBox[
               "\[ThinSpace]|\[ThinSpace]", "DockedCellSolutionDivider"], 
               StyleBox[
               ElementaryIntroToWLWeb`Private`solutionsCorrect, 
                "DockedCellCorrectExerciseText"], 
               StyleBox[
               "\[ThickSpace]\[ThickSpace]CORRECT", 
                "DockedCellCorrectExerciseText"]}, "RowDefault"], Alignment -> 
             Right, ImageSize -> Full]], "Output", TextAlignment -> Right, 
           CellFrame -> 1, CellMargins -> {{0, 0}, {10, 0}}, 
           CellFrameMargins -> {{14, 24}, {4, 7}}, CellFrameColor -> 
           RGBColor[1, 0.956862, 0.878431], MenuSortingValue -> 10000, 
           Background -> RGBColor[1, 0.956862, 0.878431], CellTags -> 
           "SolutionTallyCell"]]])]], "Output", CellMargins -> 0, 
   CellFrameMargins -> {{0, 24}, {3, 6}}, Background -> 
   RGBColor[0.97647, 0.482352, 0], CellFrame -> 1, CellFrameColor -> 
   RGBColor[0.97647, 0.482352, 0]], 
  Cell["SECOND EDITION", "Text", FontFamily -> "Source Sans Pro", 
   CellFrame -> {{0, 0}, {3, 0}}, ShowCellBracket -> False, 
   CellMargins -> {{0, 0}, {-1, -1}}, CellFrameMargins -> {{44, 0}, {2, 4}}, 
   CellFrameColor -> RGBColor[0.952941, 0.509804, 0], FontSize -> 10, 
   FontTracking -> "Extended", FontColor -> RGBColor[1, 0.929412, 0.721569], 
   Background -> RGBColor[0.862745, 0.309804, 0], CellTags -> 
   "DockedCellLogoCell"]},
TaggingRules->{
 "EIWLExercises" -> {
   "ExercisesTotal" -> {
     "+26.1", "26.1", "26.2", "26.3", "26.4", "26.5", "26.6", "26.7", "26.8"},
     "ExercisesTried" -> {}, "ExercisesCorrect" -> {}}},
FrontEndVersion->"11.1 for Mac OS X x86 (32-bit, 64-bit Kernel) (April 18, \
2017)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[StyleDefinitions -> "Default.nb"]], 
   Cell[
    CellGroupData[{
      Cell[
      "Style Environments", "Section", 
       CellChangeTimes -> {{3.64661165091824*^9, 3.646611654013329*^9}, 
         3.6485723794335403`*^9, 3.651347081728628*^9, 3.651347179462186*^9, 
         3.651347384135805*^9, 3.651348171662589*^9, {3.662385415502224*^9, 
         3.662385415587447*^9}, {3.662385986094821*^9, 
         3.662385986340312*^9}, {3.662386515144682*^9, 
         3.662386515438078*^9}, {3.662386561676188*^9, 
         3.662386561889332*^9}, {3.668356126688795*^9, 
         3.6683561270120687`*^9}, {3.670169943059537*^9, 
         3.670169943254141*^9}}], 
      Cell[
       StyleData[All, "Working"]], 
      Cell[
       StyleData[All, "Printout"], 
       PrintingOptions -> {
        "PageSize" -> {504, 720}, "PrintRegistrationMarks" -> True}, 
       Magnification -> 0.6]}, Closed]], 
   Cell[
    CellGroupData[{
      Cell[
      "Custom Styles", "Section", 
       CellChangeTimes -> {{3.646611660445352*^9, 3.646611669493331*^9}}], 
      Cell[
       StyleData["Notebook"], CreateCellID -> True, CellContext -> Notebook, 
       CellLabelAutoDelete -> False, DefaultNewCellStyle -> "Input", 
       ShowSyntaxStyles -> True, MenuSortingValue -> None], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Title"], CellMargins -> {{64, Inherited}, {50, 72}}, 
          MenuCommandKey -> None, FontFamily -> "Verdana", FontSize -> 42, 
          FontWeight -> "Bold", FontColor -> GrayLevel[0.4]], 
         Cell[
          StyleData["Title", "Printout"], 
          CellMargins -> {{64, Inherited}, {50, 72}}]}, Closed]], 
      Cell[
       StyleData["Chapter"], MenuCommandKey -> None], 
      Cell[
       StyleData["Subchapter"], MenuCommandKey -> None], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Section"], CellFrame -> {{0, 0}, {0, 0}}, CellDingbat -> 
          Cell[
            TextData[
             CounterBox["Section"], 
             StyleBox[
             "|\[NegativeThinSpace]", FontColor -> 
              RGBColor[
               0.9019607843137255, 0.4117647058823529, 0.027450980392156862`],
               FontFamily -> "Courier", FontSize -> 36, FontWeight -> Plain]],
             "SectionNumber"], CellMargins -> {{96, Inherited}, {12, 64}}, 
          Evaluatable -> True, CellGroupingRules -> {"SectionGrouping", 60}, 
          PageBreakAbove -> True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["Section", "Printout"], 
          CellMargins -> {{96, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionDoubleDigit"], CellFrame -> {{0, 0}, {0, 0}}, 
          CellDingbat -> Cell[
            TextData[
             CounterBox["Section"], 
             StyleBox[
             "|\[NegativeThinSpace]", FontColor -> 
              RGBColor[
               0.9019607843137255, 0.4117647058823529, 0.027450980392156862`],
               FontFamily -> "Courier", FontSize -> 36, FontWeight -> Plain]],
             "SectionNumber"], CellMargins -> {{112, Inherited}, {12, 64}}, 
          Evaluatable -> True, CellGroupingRules -> {"SectionGrouping", 60}, 
          PageBreakAbove -> True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["SectionDoubleDigit", "Printout"], 
          CellMargins -> {{112, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionNumber"], CellBaseline -> Baseline, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 26, FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SectionNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionInline"], FontFamily -> 
          "Source Sans Pro Semibold", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SectionInline", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionNoDingbat"], 
          CellMargins -> {{64, Inherited}, {12, 64}}, Evaluatable -> True, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakAbove -> 
          True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["SectionNoDingbat", "Printout"], 
          CellMargins -> {{64, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Exercise"], CellDingbat -> Cell[
            TextData[{"  ", 
              CounterBox["Section"], ".", 
              CounterBox["Exercise"]}], "ExerciseNumber", FontColor -> 
            RGBColor[
             0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
          ShowGroupOpener -> True, CellMargins -> {{90, 40}, {4, 18}}, 
          CellGroupingRules -> "InputGrouping", CounterIncrements -> 
          "Exercise", MenuSortingValue -> 10020, MenuCommandKey -> "2", 
          FontFamily -> "Source Sans Pro", FontSize -> 16, FontWeight -> 
          "Plain", FontSlant -> "Plain", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["Exercise", "Printout"], ShowGroupOpener -> False, 
          CellMargins -> {{110, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseNumber"], FontFamily -> "Source Sans Pro", 
          FontSize -> 16, FontWeight -> "Bold", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["ExerciseNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseInput", StyleDefinitions -> StyleData["Input"]], 
          CellMargins -> {{70, 30}, {4, 7}}, ShowCellLabel -> False, 
          CellFrameLabels -> {{None, None}, {None, None}}, SpanMaxSize -> 1, 
          FontSize -> 
          14, $CellContext`GeneratedCellStyles -> {
           "Output" -> "ExerciseOutput"}], 
         Cell[
          StyleData["ExerciseInput", "Printout"], 
          CellMargins -> {{88, 10}, {4, 7}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "ExerciseOutput", StyleDefinitions -> StyleData["Output"]], 
          CellMargins -> {{90, 40}, {0, 6}}, CellGroupingRules -> 
          "OutputGrouping", ShowCellLabel -> False, FontSize -> 14], 
         Cell[
          StyleData["ExerciseOutput", "Printout"], 
          CellMargins -> {{88, 10}, {10, 4}}]}, Closed]], 
      Cell[
       StyleData["ExerciseExpectedResult"], ShowCellBracket -> False, 
       ShowGroupOpener -> False, CellMargins -> {{90, 40}, {3, 9}}, 
       CellGroupingRules -> "InputGrouping", CounterIncrements -> "Exercise", 
       MenuSortingValue -> 10000, FontFamily -> "Source Sans Pro", FontSize -> 
       12, FontWeight -> "Plain", FontSlant -> "Plain"], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Picture"], CellMargins -> {{66, 10}, {10, 10}}, 
          CellGroupingRules -> "GraphicsGrouping", StyleMenuListing -> None], 
         
         Cell[
          StyleData["Picture", "Printout"], 
          CellMargins -> {{66, 10}, {8, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Tentative"], 
          CellBracketOptions -> {
           "Color" -> RGBColor[
             0.30000000000000016`, 0.6000000000000003, 0.7000000000000003], 
            "Thickness" -> 5}, Evaluatable -> False, CellFrameMargins -> 4, 
          StyleMenuListing -> None, Background -> 
          RGBColor[0.8500000000000003, 0.9500000000000003, 1]], 
         Cell[
          StyleData["Tentative", "Printout"], 
          CellElementSpacings -> {"CellMinHeight" -> 0.1}, CellOpen -> False, 
          CellFrameMargins -> 0, FontSize -> 0.1, Magnification -> 0.01]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["WebOnly"], 
          CellBracketOptions -> {
           "Color" -> RGBColor[0.91, 0.92, 0.9], "Thickness" -> 5}, 
          CellFrameMargins -> 4, StyleMenuListing -> None, Background -> 
          RGBColor[0.91, 0.92, 0.86]], 
         Cell[
          StyleData["WebOnly", "Printout"], 
          CellElementSpacings -> {"CellMinHeight" -> 0.1}, CellOpen -> False, 
          CellFrameMargins -> 0, FontSize -> 0.1, Magnification -> 0.01]}, 
        Closed]], 
      Cell[
       StyleData["Lockdown"], 
       CellBracketOptions -> {
        "Color" -> RGBColor[0.8, 0.5, 0.4], "Thickness" -> 3}, Evaluatable -> 
       False, StyleMenuListing -> None], 
      Cell[
       StyleData["InlineCode"], SpanMaxSize -> 0, FontColor -> GrayLevel[0]], 
      
      Cell[
       StyleData["ExpectedOutputNote"], Selectable -> False, FontFamily -> 
       "Source Sans Pro", FontColor -> GrayLevel[0.3]], 
      Cell[
       StyleData["EIWLTextLink"], LineBreakWithin -> False, 
       TemplateBoxOptions -> {DisplayFunction :> (TagBox[
           
           ButtonBox[#, Appearance -> None, ButtonData -> #2, 
            BaseStyle -> {
             "Hyperlink", FontWeight -> Bold, FontSize -> 16, FontFamily -> 
              "Source Sans Pro"}], 
           MouseAppearanceTag["LinkHand"]]& )}, 
       ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
      Cell[
       StyleData["CheckAnswerDividerCloud"], ShowCellBracket -> False, 
       CellMargins -> {{40, 40}, {3, 6}}, 
       CellBracketOptions -> {"OverlapContent" -> True}, 
       CellGroupingRules -> {"SectionGrouping", 40}, 
       CellFrameMargins -> {{20, 20}, {2, 2}}, TextAlignment -> Right], 
      Cell[
       StyleData["CodeSectionDividerCloud"], Editable -> False, Selectable -> 
       False, ShowCellBracket -> False, CellMargins -> {{0, 0}, {0, 35}}, 
       CellBracketOptions -> {"OverlapContent" -> True}, 
       CellElementSpacings -> {"CellMinHeight" -> 6}, 
       CellGroupingRules -> {"SectionGrouping", -5}, 
       CellFrameMargins -> {{20, 20}, {2, 2}}, DefaultNewCellStyle -> "Input",
        FontSize -> 6, Background -> GrayLevel[0.95]], 
      Cell[
       StyleData["InlineCode"], SpanMaxSize -> 0, FontColor -> GrayLevel[0]], 
      
      Cell[
       StyleData["InlineCodeText"], SpanMaxSize -> 0, FontFamily -> 
       "Source Sans Pro"], 
      Cell[
       StyleData["Input"], CellMargins -> {{92, 20}, {5, 8}}, 
       CellFrameLabels -> {{None, 
          
          DynamicModuleBox[{$CellContext`EIWLExerciseCheck = 
            Automatic, $CellContext`buttonLabel = " CHECK MY SOLUTION "}, 
           DynamicBox[
            ToBoxes[
             If[
              TrueQ[$CellContext`EIWLExerciseCheck == Automatic], 
              MouseAppearance[
               Tooltip[
                Button[
                 Framed[
                  Panel[
                   
                   Style[$CellContext`buttonLabel, FontFamily -> 
                    "Source Sans Pro", FontSize -> 10, FontColor -> 
                    RGBColor[0.953948, 0.305638, 0.0285344]], Appearance -> 
                   None, Background -> GrayLevel[1], 
                   FrameMargins -> {{2, 2}, {0, 0}}, ImageMargins -> 0], 
                  FrameStyle -> {
                    Thickness[Tiny], 
                    RGBColor[0.953948, 0.305638, 0.0285344]}, RoundingRadius -> 
                  3], 
                 
                 Block[{$CellContext`usersCell, $CellContext`solutionResult, \
$CellContext`exerciseNumber, $CellContext`exerciseSwitchResult}, \
$CellContext`exerciseNumber = StringJoin[
                    If[
                    TrueQ[CurrentValue[{"CounterValue", "WebOnly"}] == 1], 
                    "x", ""], 
                    ToString[
                    CurrentValue[{"CounterValue", "SectionNumber"}]], ".", 
                    ToString[
                    
                    CurrentValue[{
                    "CounterValue", 
                    "ExerciseNumber"}]]]; $CellContext`buttonLabel = 
                   Row[{" CHECKING ", 
                    ProgressIndicator[Appearance -> "Percolate"]}]; 
                  SelectionMove[
                    ButtonNotebook[], All, ButtonCell, AutoScroll -> 
                    False]; $CellContext`usersCell = NotebookRead[
                    InputNotebook[]]; If[
                    TrueQ[Length[
                    Flatten[{$CellContext`usersCell}]] == 
                    1], $CellContext`solutionResult = ToExpression[
                    URLFetch[
                    "https://www.wolframcloud.com/objects/user-9b23d046-b2a9-\
4a5c-8723-08465cce25ed/EIWLGradingAPI", "Method" -> "POST", 
                    "Parameters" -> {
                    "exNum" -> $CellContext`exerciseNumber, "answer" -> 
                    ToString[$CellContext`usersCell, InputForm, 
                    CharacterEncoding -> "ASCII"], "user" -> 
                    ToString[$WolframID], "referer" -> "eiwl-nb", "uuid" -> 
                    ToString[$WolframUUID]}]]; \
$CellContext`SolutionResponseText[$CellContext`exerciseNumber] = \
$CellContext`SolutionResponseDetails[
                    $CellContext`solutionResult["Text"], 
                    $CellContext`solutionResult[
                    "CorrectQ"]]; $CellContext`exerciseSwitchResult = Switch[
                    $CellContext`solutionResult["CorrectQ"], 
                    True, $CellContext`EIWLExerciseCheck = 
                    True; $CellContext`SetUserSolutionsCorrect[$CellContext`\
exerciseNumber]; \
$CellContext`SetUserSolutionsTried[$CellContext`exerciseNumber]; Null, 
                    
                    Blank[], $CellContext`EIWLExerciseCheck = 
                    False; $CellContext`SetUserSolutionsTried[$CellContext`\
exerciseNumber]], 
                    CloudSystem`CreateCloudDialog[
                    StyleBox[
                    "Select a cell to be checked.", Selectable -> False], 
                    WindowTitle -> " "]]], Appearance -> None, Evaluator -> 
                 Automatic, Method -> "Queued"], 
                "Click to check your solution.", TooltipDelay -> 0.15], 
               "LinkHand"], 
              If[
               TrueQ[$CellContext`EIWLExerciseCheck], 
               MouseAppearance[
                Button[
                 Framed[
                  Row[{
                    Panel[
                    Style[
                    ToExpression[
                    "\!\(\* GraphicsBox[ TagBox[RasterBox[CompressedData[\" \
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBLECOU2VJahIzkCECxFJADGKrbtYa \
RUMUpZzMcNnnQRWjMk5lf/vzDWggtYwCkgNiFDBAsPqCPFcBjcLURYkH0fRS \
HlZwE6gV7EATfvz98f3Pd6rEIBClncpMPZlJFaNGEd0QANRpOvM= \"], {{0, 20}, { 26, \
0}}, {0, 255}, ColorFunction->RGBColor], BoxForm`ImageTag[ \"Byte\", \
Interleaving -> True, Magnification -> 1], Selectable->False], \
BaseStyle->\"ImageGraphics\", ImageSize->Magnification[1], ImageSizeRaw->{26, \
20}, PlotRange->{{0, 26}, {0, 20}}]\)"], Selectable -> False], Background -> 
                    RGBColor[0.146944, 0.70164, 0.16466], 
                    FrameMargins -> {{5, 5}, {0, 0}}, ImageMargins -> 0, 
                    Appearance -> None], 
                    Panel[
                    Style[
                    " CORRECT ", FontSize -> 10, FontColor -> 
                    RGBColor[0.146944, 0.70164, 0.16466], FontFamily -> 
                    "Source Sans Pro"], Background -> White, 
                    FrameMargins -> {{5, 5}, {0, 0}}, Appearance -> None]}], 
                  FrameStyle -> {
                    Thickness[Tiny], 
                    RGBColor[0.146944, 0.70164, 0.16466]}, FrameMargins -> 0, 
                  RoundingRadius -> 3], $CellContext`buttonLabel = 
                  " CHECK MY SOLUTION "; $CellContext`EIWLExerciseCheck = 
                  Automatic, Appearance -> None], "LinkHand"], 
               MouseAppearance[
                Button[
                 Framed[
                  Row[{
                    Panel[
                    Style[
                    ToExpression[
                    "\!\(\* GraphicsBox[ TagBox[RasterBox[CompressedData[\" \
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBLECOU2VJahIzkCECxGJADGK/YtAZ \
RTRCb1W8PnhlYooDBYFSxJgAVPnvy7cPfrkogn65IEFsJmM3BKIeZggal1RD \
yNOOMOT7DyAiTzvlJlDoCwpDkvLYpDxFjSLyEAAHORZk \"], {{0, 20}, {22, 0}}, { 0, \
255}, ColorFunction->RGBColor], BoxForm`ImageTag[ \"Byte\", Interleaving -> \
True, Magnification -> 1], Selectable->False], BaseStyle->\"ImageGraphics\", \
ImageSize->Magnification[1], ImageSizeRaw->{22, 20}, PlotRange->{{0, 22}, {0, \
20}}]\)"], Selectable -> False], Background -> 
                    RGBColor[0.918257, 0, 0.172488], 
                    FrameMargins -> {{5, 5}, {0, 0}}, ImageMargins -> 0, 
                    Appearance -> None], 
                    Panel[
                    Style[
                    " TRY AGAIN ", FontSize -> 10, FontColor -> 
                    RGBColor[0.918257, 0, 0.172488], FontFamily -> 
                    "Source Sans Pro"], Background -> White, 
                    FrameMargins -> {{5, 5}, {0, 0}}, Appearance -> None]}], 
                  FrameStyle -> {
                    Thickness[Tiny], 
                    RGBColor[0.918257, 0, 0.172488]}, FrameMargins -> 0, 
                  RoundingRadius -> 3], $CellContext`buttonLabel = 
                  " CHECK MY SOLUTION "; $CellContext`EIWLExerciseCheck = 
                  Automatic, Appearance -> None], "LinkHand"]]], 
             StandardForm], ImageSizeCache -> {109., {9., 16.}}], 
           DynamicModuleValues :> {}]}, {None, None}}, 
       CellChangeTimes -> {{3.6688095471029243`*^9, 3.66880959932793*^9}}, 
       MenuSortingValue -> 10000, FontSize -> 15], 
      Cell[
       StyleData["Output"], Deletable -> True, ShowCellBracket -> True, 
       CellMargins -> {{92, 50}, {10, 5}}, 
       CellBracketOptions -> {"OverlapContent" -> True}, CellEditDuplicate -> 
       True, GeneratedCell -> True, CellAutoOverwrite -> True, 
       LinebreakAdjustments -> {1, 2., 12., 1.25, 1.}, MenuSortingValue -> 
       None, FontSize -> 15], 
      Cell[
       StyleData["Message"], 
       CellMargins -> {{92, Inherited}, {Inherited, Inherited}}], 
      Cell[
       StyleData["EmptyCell"], Editable -> False, Selectable -> False, 
       CellMargins -> {{0, 0}, {-2, 0}}, 
       CellElementSpacings -> {"CellMinHeight" -> 1}, MenuSortingValue -> 
       10000, FontSize -> 1], 
      Cell[
       StyleData["CellLabel"], MenuSortingValue -> 10000, FontColor -> 
       GrayLevel[0.6]], 
      Cell[
       StyleData["Link"], LineBreakWithin -> False, 
       TemplateBoxOptions -> {DisplayFunction :> (TagBox[
           
           ButtonBox[#, Appearance -> None, ButtonData -> #2, 
            BaseStyle -> {
             "Hyperlink", FontSize -> 15, FontFamily -> "Source Sans Pro"}], 
           MouseAppearanceTag["LinkHand"]]& )}, 
       ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
      Cell[
       StyleData["ExpectedOutputText"], FontFamily -> "Arial", FontSize -> 13,
        FontColor -> RGBColor[0.8579079880979629, 0.4263828488593881, 0.]], 
      Cell[
       StyleData["CodeSectionDividerCloud"], Selectable -> False, 
       ShowCellBracket -> False, CellMargins -> {{0, 0}, {0, 35}}, 
       CellBracketOptions -> {"OverlapContent" -> True}, 
       CellElementSpacings -> {"CellMinHeight" -> 6}, 
       CellGroupingRules -> {"SectionGrouping", -5}, 
       CellFrameMargins -> {{20, 20}, {2, 2}}, DefaultNewCellStyle -> 
       "EmptyCell", FontSize -> 6, Background -> GrayLevel[0.95]], 
      Cell[
       StyleData["DockedCellAuthorName"], MenuSortingValue -> 10000, 
       FontFamily -> "Source Sans Pro", FontSize -> 12, FontColor -> 
       RGBColor[1, 0.929411, 0.721568]], 
      Cell[
       StyleData["DockedCellSectionTitle"], MenuSortingValue -> 10000, 
       FontFamily -> "Source Sans Pro", FontSize -> 18, FontColor -> 
       GrayLevel[1]], 
      Cell[
       StyleData["DockedCellSecondCell"], CellFrame -> 1, 
       CellMargins -> {{0, 0}, {0, 0}}, 
       CellFrameMargins -> {{10, 10}, {10, 10}}, CellFrameColor -> 
       RGBColor[1, 0.956862, 0.878431], MenuSortingValue -> 10000, Background -> 
       RGBColor[1, 0.956862, 0.878431]], 
      Cell[
       StyleData["CompletedExerciseHeader"], MenuSortingValue -> 10000, 
       FontFamily -> "Source Sans Pro", FontSize -> 14, FontColor -> 
       GrayLevel[0.5]], 
      Cell[
       StyleData["DockedCellShareButton"], MenuSortingValue -> 10000, 
       FontFamily -> "Source Sans Pro", FontSize -> 13, FontColor -> 
       GrayLevel[1]], 
      Cell[
       StyleData["DockedCellLinksSections"], MenuSortingValue -> 10000, 
       FontFamily -> "Source Sans Pro", FontSize -> 14, FontWeight -> "Plain",
        FontSlant -> "Plain", FontColor -> RGBColor[0.97647, 0.482352, 0]], 
      Cell[
       StyleData["DockedCellLinksDivider"], MenuSortingValue -> 10000, 
       FontFamily -> "Courier", FontSize -> 18, FontWeight -> "Plain", 
       FontSlant -> "Plain", FontColor -> RGBColor[0.97647, 0.482352, 0]], 
      Cell[
       StyleData["DockedCellSectionTitleDivider"], MenuSortingValue -> 10000, 
       FontFamily -> "Courier", FontSize -> 24, FontWeight -> "Plain", 
       FontSlant -> "Plain", FontColor -> GrayLevel[1]], 
      Cell[
       StyleData["SolutionTrue"], MenuSortingValue -> 10000, FontFamily -> 
       "Source Sans Pro", FontSize -> 12, FontWeight -> "Plain", FontSlant -> 
       "Plain", FontColor -> RGBColor[0.12, 0.7, 0.22]], 
      Cell[
       StyleData["SolutionFalse"], MenuSortingValue -> 10000, FontFamily -> 
       "Source Sans Pro", FontSize -> 12, FontWeight -> "Plain", FontSlant -> 
       "Plain", FontColor -> RGBColor[0.94, 0.08, 0.2]], 
      Cell[
       StyleData["SolutionResponseText"], ShowStringCharacters -> False, 
       FontFamily -> "Source Sans Pro", FontSize -> 12, FontWeight -> "Plain",
        FontSlant -> "Plain", FontColor -> GrayLevel[1]], 
      Cell[
       StyleData["SolutionResponse"], ShowCellBracket -> False, 
       CellMargins -> {{24, 25}, {6, 0}}, 
       CellFrameMargins -> {{8, 0}, {0, 12}}, TextAlignment -> Right, 
       ShowStringCharacters -> False, FontFamily -> "Source Sans Pro", 
       FontSize -> 12, FontWeight -> "Plain", FontSlant -> "Plain", 
       Background -> GrayLevel[1]], 
      Cell[
       StyleData["DockedCellCompletedExerciseText"], MenuSortingValue -> 
       10000, FontFamily -> "Source Sans Pro", FontSize -> 12, FontWeight -> 
       "Plain", FontSlant -> "Plain", FontColor -> GrayLevel[0.4]], 
      Cell[
       StyleData["DockedCellSolutionDivider"], MenuSortingValue -> 10000, 
       FontFamily -> "Courier", FontSize -> 16, FontWeight -> "Plain", 
       FontSlant -> "Plain", FontColor -> GrayLevel[0.6]], 
      Cell[
       StyleData["DockedCellCorrectExerciseText"], MenuSortingValue -> 10000, 
       FontFamily -> "Source Sans Pro", FontSize -> 12, FontWeight -> "Plain",
        FontSlant -> "Plain", FontColor -> RGBColor[0.12, 0.7, 0.22]], 
      Cell[
       CellGroupData[{
         Cell[
         "EIWL Cloud Link styles", "Subsubsection", 
          CellChangeTimes -> {{3.663512229965006*^9, 3.66351224118613*^9}}], 
         Cell[
          StyleData["EIWLTextLink"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 16, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkAnswer"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkCodeCaption"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontColor -> GrayLevel[0.6], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkExercise"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkExerciseNote"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkInlineCode"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkMoreExplore"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkQuestion"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontWeight -> Bold, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkTechNote"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkText"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 17, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkInlineCodeLink"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 17, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkVocabularyTable"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
         "EIWL Cloud Link", "Subsubsection", 
          CellChangeTimes -> {{3.664234597774767*^9, 3.664234605661516*^9}}], 
         
         Cell[
          StyleData["CodeLinkAnswer"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkCodeCaption"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontColor -> GrayLevel[0.6], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkExercise"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkQuestion"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontWeight -> Bold, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkTechNote"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkText"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 17, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkVocabularyTable"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkVocabularyTable3Column"], LineBreakWithin -> 
          False, TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkAnswer"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkCodeCaption"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontColor -> GrayLevel[0.6], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkExercise"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkExerciseNote"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkIndex"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkIndexSubentry"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkMoreExplore"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkQuestion"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontWeight -> Bold, FontColor -> 
                 GrayLevel[0], FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkTechNote"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkText"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 16, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkVocabularyTable"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}]}, 
        Closed]]}, Open]]}, Visible -> False, FrontEndVersion -> 
  "11.1 for Mac OS X x86 (32-bit, 64-bit Kernel) (April 18, 2017)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "FirstInputCell"->{
  Cell[12195, 274, 813, 26, 
  70, "Input", "ExpressionUUID" -> "936186e3-2f98-4079-a54e-788d9e18997d",
   CellTags->"FirstInputCell"],
  Cell[18941, 469, 813, 26, 
  70, "Input", "ExpressionUUID" -> "c92c9315-e3a3-4a4e-a57f-bd7f01d85028",
   CellTags->"FirstInputCell"],
  Cell[42717, 944, 813, 26, 
  70, "Input", "ExpressionUUID" -> "a73ad4ce-3afe-4221-a934-021fdf009685",
   CellTags->"FirstInputCell"],
  Cell[62179, 1350, 813, 26, 
  70, "Input", "ExpressionUUID" -> "bdd26239-1a47-496c-ba6c-7be81c833711",
   CellTags->"FirstInputCell"],
  Cell[102304, 2094, 813, 26, 
  70, "Input", "ExpressionUUID" -> "6f05e4a0-7f38-4b3b-ab0b-ac75ef256b99",
   CellTags->"FirstInputCell"],
  Cell[379494, 6725, 813, 26, 
  70, "Input", "ExpressionUUID" -> "b5c73fd7-f5a4-46f1-a1c5-a5faf8ff1f78",
   CellTags->"FirstInputCell"],
  Cell[399657, 7142, 813, 26, 
  70, "Input", "ExpressionUUID" -> "d2fe9a8f-49af-4707-b2fb-2119bddb3363",
   CellTags->"FirstInputCell"],
  Cell[584858, 10263, 813, 26, 
  70, "Input", "ExpressionUUID" -> "b1c5d738-8429-47d6-b304-e24d01e57947",
   CellTags->"FirstInputCell"],
  Cell[595404, 10531, 813, 26, 
  70, "Input", "ExpressionUUID" -> "630cd0eb-4b7c-452d-b495-c55d3f18e535",
   CellTags->"FirstInputCell"]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"FirstInputCell", 654269, 11751}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[646, 22, 524, 14, 70, "Exercise", "ExpressionUUID" -> \
"472fd02e-9528-4a5a-8a3f-22b8983b6e4f",
 CounterAssignments->{{"SectionNumber", 26}, {"ExerciseNumber", 1}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[1195, 40, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"6efccdd8-5a51-4df1-9e30-8a1972dc6328"],
Cell[1834, 61, 9754, 188, 70, "ExerciseOutput", "ExpressionUUID" -> \
"cc0fdd43-b0c1-4393-8436-e651bac7954c"]
}, Closed]],
Cell[CellGroupData[{
Cell[11625, 254, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"e543806e-b7dc-4a3d-9f3d-1253966c40be"],
Cell[12195, 274, 813, 26, 70, "Input", "ExpressionUUID" -> \
"936186e3-2f98-4079-a54e-788d9e18997d",
 CellTags->"FirstInputCell"]
}, Open  ]],
Cell[CellGroupData[{
Cell[13045, 305, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"067351f2-8e47-4bcc-ad08-8502578bf0aa"],
Cell[13332, 316, 463, 11, 70, "Exercise", "ExpressionUUID" -> \
"7a4eef0b-b86c-4371-9df3-42a253c6c997",
 CounterAssignments->{{"SectionNumber", 26}, {"ExerciseNumber", 2}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[13820, 331, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"d6200981-55f8-4fe6-aba8-d921f4ee6176"],
Cell[14459, 352, 3875, 92, 70, "ExerciseOutput", "ExpressionUUID" -> \
"fbc26ac6-f90c-4121-acf3-d3f9d48feda7"]
}, Closed]],
Cell[CellGroupData[{
Cell[18371, 449, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"6a7e548c-d511-4cbc-bd51-7343d5361aed"],
Cell[18941, 469, 813, 26, 70, "Input", "ExpressionUUID" -> \
"c92c9315-e3a3-4a4e-a57f-bd7f01d85028",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[19803, 501, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"f1750d7d-6abf-4926-89a2-ddf07b705018"],
Cell[20090, 512, 508, 12, 70, "Exercise", "ExpressionUUID" -> \
"29e267e5-c5a1-42ca-a134-37fce93d795a",
 CounterAssignments->{{"SectionNumber", 26}, {"ExerciseNumber", 3}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[20623, 528, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"7d20de52-b69e-4f0f-9a4f-b97511fb4aa6"],
Cell[21262, 549, 20848, 370, 70, "ExerciseOutput", "ExpressionUUID" -> \
"7f10a70b-4146-482e-b7c0-4488dc7a1cda"]
}, Closed]],
Cell[CellGroupData[{
Cell[42147, 924, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"bb3293f8-f227-4b7b-a393-bcca7346c983"],
Cell[42717, 944, 813, 26, 70, "Input", "ExpressionUUID" -> \
"a73ad4ce-3afe-4221-a934-021fdf009685",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[43579, 976, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"30f1d40d-e4ce-413c-9b28-9db3b3ddb6ef"],
Cell[43866, 987, 545, 13, 70, "Exercise", "ExpressionUUID" -> \
"cdfeeb47-a9e4-451b-af37-230213a01486",
 CounterAssignments->{{"SectionNumber", 26}, {"ExerciseNumber", 4}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[44436, 1004, 656, 20, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"c8eecb76-8032-4d52-8bf2-de368ce0d846"],
Cell[45095, 1026, 16477, 299, 70, "ExerciseOutput", "ExpressionUUID" -> \
"c4b9fe5d-2c46-4fbf-b9e8-84f5ced070b1"]
}, Closed]],
Cell[CellGroupData[{
Cell[61609, 1330, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"524b2721-cd29-4a54-987e-00049b5f0645"],
Cell[62179, 1350, 813, 26, 70, "Input", "ExpressionUUID" -> \
"bdd26239-1a47-496c-ba6c-7be81c833711",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[63041, 1382, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"57fdc5ec-76c3-47b9-ba8e-a066950d2502"],
Cell[63328, 1393, 498, 12, 70, "Exercise", "ExpressionUUID" -> \
"c310d800-d5ec-4aec-b32d-15c0f3451223",
 CounterAssignments->{{"SectionNumber", 26}, {"ExerciseNumber", 5}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[63851, 1409, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"3d82db73-1861-4afe-9e4e-0d94a08a300f"],
Cell[64490, 1430, 37207, 639, 70, "ExerciseOutput", "ExpressionUUID" -> \
"773c6e09-f53f-44c3-b0c8-c96211195416"]
}, Closed]],
Cell[CellGroupData[{
Cell[101734, 2074, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"690ee224-322e-4305-b4ef-f4f0e74f2f0a"],
Cell[102304, 2094, 813, 26, 70, "Input", "ExpressionUUID" -> \
"6f05e4a0-7f38-4b3b-ab0b-ac75ef256b99",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[103166, 2126, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"0ef26bbe-1588-4c13-8f10-e085f38107dd"],
Cell[103453, 2137, 525, 13, 70, "Exercise", "ExpressionUUID" -> \
"8eeed8e9-0b50-4a01-ac90-9b99f2ead8f8",
 CounterAssignments->{{"SectionNumber", 26}, {"ExerciseNumber", 6}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[104003, 2154, 656, 20, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"0ae731d8-d125-4929-a189-16651625b656"],
Cell[104662, 2176, 274225, 4524, 70, "ExerciseOutput", "ExpressionUUID" -> \
"b99db3ab-d037-4e87-bd32-3f49dff30b95"]
}, Closed]],
Cell[CellGroupData[{
Cell[378924, 6705, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"0118d7af-13ff-4d85-8b3c-bbf6cb4f2a54"],
Cell[379494, 6725, 813, 26, 70, "Input", "ExpressionUUID" -> \
"b5c73fd7-f5a4-46f1-a1c5-a5faf8ff1f78",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[380356, 6757, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"8416894f-23f8-4f38-a1b5-49f83d2da410"],
Cell[380643, 6768, 536, 13, 70, "Exercise", "ExpressionUUID" -> \
"2292512a-a05e-4f1d-823d-90e44f17efe4",
 CounterAssignments->{{"SectionNumber", 26}, {"ExerciseNumber", 7}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[381204, 6785, 656, 20, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"b1000725-3315-4a7d-97ac-ff383a944bfd"],
Cell[381863, 6807, 17187, 310, 70, "ExerciseOutput", "ExpressionUUID" -> \
"8f4fd5d6-38a4-47b4-bf6f-480d6404cd0e"]
}, Closed]],
Cell[CellGroupData[{
Cell[399087, 7122, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"9ac1b784-f198-42be-b2ea-dd5810ce3c46"],
Cell[399657, 7142, 813, 26, 70, "Input", "ExpressionUUID" -> \
"d2fe9a8f-49af-4707-b2fb-2119bddb3363",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[400519, 7174, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"6614e3e7-f006-45b8-8fb7-88b2bfd4dcfd"],
Cell[400806, 7185, 467, 11, 70, "Exercise", "ExpressionUUID" -> \
"47255d4a-3f02-4692-bc07-71853b8c7fca",
 CounterAssignments->{{"SectionNumber", 26}, {"ExerciseNumber", 8}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[401298, 7200, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"ed9b1087-fdac-4c2e-949f-72cd59d8b854"],
Cell[401937, 7221, 182314, 3017, 70, "ExerciseOutput", "ExpressionUUID" -> \
"dc96d9ff-ce8d-46b7-892d-e1c3010bc449"]
}, Closed]],
Cell[CellGroupData[{
Cell[584288, 10243, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"3a20b95c-4c3d-4838-820c-7e9ed0f57819"],
Cell[584858, 10263, 813, 26, 70, "Input", "ExpressionUUID" -> \
"b1c5d738-8429-47d6-b304-e24d01e57947",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[585720, 10295, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" \
-> "16666499-4ff0-4621-b8dc-ea5d6f0dcd03"],
Cell[586007, 10306, 888, 28, 70, "Exercise", "ExpressionUUID" -> \
"d948119e-c4e2-4461-b1d8-b6b12ceb56c5",
 CounterAssignments->{{"SectionNumber", 26}, {"ExerciseNumber", 1}, {
   "WebOnly", 1}}],
Cell[CellGroupData[{
Cell[586920, 10338, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" \
-> "4e729b37-4e55-42b2-8535-288b6b7e149b"],
Cell[587559, 10359, 7237, 147, 70, "ExerciseOutput", "ExpressionUUID" -> \
"20929bb8-7db3-4139-be99-81135c589f3b"]
}, Closed]],
Cell[CellGroupData[{
Cell[594833, 10511, 568, 18, 70, "Subsection", "ExpressionUUID" -> \
"cd0f5704-98ae-4fbf-a20a-81adde0dda2a"],
Cell[595404, 10531, 813, 26, 70, "Input", "ExpressionUUID" -> \
"630cd0eb-4b7c-452d-b495-c55d3f18e535",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[596244, 10561, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" \
-> "73051e49-0550-4324-a4a1-52143479d586"]
}
]
*)

(* End of internal cache information *)
(* NotebookSignature UQczvxM#oLYQPje6jVdiS2H# *)
