(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    720257,      14207]
NotebookOptionsPosition[    638655,      12470]
NotebookOutlinePosition[    699902,      13729]
CellTagsIndexPosition[    699822,      13724]
WindowTitle->Machine Learning: Elementary Introduction to the Wolfram \
Language
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell["Identify what language the word \[OpenCurlyDoubleQuote]ajatella\
\[CloseCurlyDoubleQuote] comes from.", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "22.1", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 22}, {"ExerciseNumber", 1}, {
   "WebOnly", 0}},ExpressionUUID->"d1c0fe2e-580c-4b85-90e1-519e15f4c7dc"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"0b332ebd-9d60-4e11-9272-72e11f0ccbab"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztl9FLWmEUwF172aPbHjc29gf02LaXCXvwYezNsdhLSDFrPdjKJmsPkS1Q
ELSGKIzcQyGIcBVMKHu4ECKSc6EREU1uFxR1GAm3SdxV27fzXa+l13srZcP7
4OFc+Tz3nHN/nnPU73sw8FYz2KVQKMZvwIum//1Tg6H/wwslvHk5Mj48NKJ7
/WzknW5IZ3g8cB2Md+B6Ahdeo4505Ory5zdaNaC5e+hjF5pWyEiBB6i+OtAJ
K2QGi/U29vmxjn4V0fG+jBR4gMr9EFlv4drWyuo48r9qP+HFClVdn63Dhi7A
J6pzK+zFAlEyEK/VlUCmmN2L+Da2d5p+aCmJw0sFCYfCd9ITT12YFghn79Zh
w/wIZ4P2qpW6HqG6Y98WYWEKNYtdjk1x4WkJB9oLae3hS6YFOGsF6t+Qh9Ao
9ZYAc0gzxfSZssf7DJXI5bNNV/uIzu0mmSMpB/w4ozNy+ZxcAVssTzZqf7O4
lACHNYvWteBZtmu5RqgIMlkJFLWfZkKu0bE4hT8vS4XcgyrubvfcfKB8VqUJ
G2Hp5aMiWy1j6y0+ppQ+yO9UlMGTSRNqpd5JwiLYx02Oute7YJ7BE9UdzRSk
7OWEGYzeBAxJ0oXvaoNLniAHOTkfqYnSEl5bJSqebwWbz1OrlnC1CxibAAf1
RIbrO0+FR1fcXk7ZeOxS2NijnJnn+xi3a93+2FlUjjOy59laqbZuwrGZIDdj
YU5D27vpOmx+wfmXSCNfTHH7OfYRV21c2Ocuu6P6oySIClez/avZlsA+JCdF
sav2c2xsT2/4zda+yngr9SbfqWS21rDJq2OLV/tQWG2W8llHpzJ8tvSaqVun
NjOS2eSCjfI+WBhNn3NF+oAiF2GkNbZy+7C5ttJSdnbbAbREChyyG05tzTdd
tZySGi26eez/q2xxK0clMtRWWfIPSEzbjd2iCrBF9iTy08Y9icgOUH7auAMM
j6Hpa+0Hu1jhpLAyXIcNpwY4O3x5JN/Tzaf7yHoTsSUkEDiXrehxF2R4lgQq
qPPJTyFzRzoiLX8BbyeaBA==
            "], {{0, 27}, {61, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{61, 27},
          PlotRange->{{0, 61}, {0, 27}}]], "ExerciseOutput",
         ImageSize->{65, 27},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "045a0a3d-9098-48ca-834a-aaf8f2a304d8"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztl9FLWmEUwF172aPbHjc29gf02LaXCXvwYezNsdhLSDFrPdjKJmsPkS1Q
ELSGKIzcQyGIcBVMKHu4ECKSc6EREU1uFxR1GAm3SdxV27fzXa+l13srZcP7
4OFc+Tz3nHN/nnPU73sw8FYz2KVQKMZvwIum//1Tg6H/wwslvHk5Mj48NKJ7
/WzknW5IZ3g8cB2Md+B6Ahdeo4505Ory5zdaNaC5e+hjF5pWyEiBB6i+OtAJ
K2QGi/U29vmxjn4V0fG+jBR4gMr9EFlv4drWyuo48r9qP+HFClVdn63Dhi7A
J6pzK+zFAlEyEK/VlUCmmN2L+Da2d5p+aCmJw0sFCYfCd9ITT12YFghn79Zh
w/wIZ4P2qpW6HqG6Y98WYWEKNYtdjk1x4WkJB9oLae3hS6YFOGsF6t+Qh9Ao
9ZYAc0gzxfSZssf7DJXI5bNNV/uIzu0mmSMpB/w4ozNy+ZxcAVssTzZqf7O4
lACHNYvWteBZtmu5RqgIMlkJFLWfZkKu0bE4hT8vS4XcgyrubvfcfKB8VqUJ
G2Hp5aMiWy1j6y0+ppQ+yO9UlMGTSRNqpd5JwiLYx02Oute7YJ7BE9UdzRSk
7OWEGYzeBAxJ0oXvaoNLniAHOTkfqYnSEl5bJSqebwWbz1OrlnC1CxibAAf1
RIbrO0+FR1fcXk7ZeOxS2NijnJnn+xi3a93+2FlUjjOy59laqbZuwrGZIDdj
YU5D27vpOmx+wfmXSCNfTHH7OfYRV21c2Ocuu6P6oySIClez/avZlsA+JCdF
sav2c2xsT2/4zda+yngr9SbfqWS21rDJq2OLV/tQWG2W8llHpzJ8tvSaqVun
NjOS2eSCjfI+WBhNn3NF+oAiF2GkNbZy+7C5ttJSdnbbAbREChyyG05tzTdd
tZySGi26eez/q2xxK0clMtRWWfIPSEzbjd2iCrBF9iTy08Y9icgOUH7auAMM
j6Hpa+0Hu1jhpLAyXIcNpwY4O3x5JN/Tzaf7yHoTsSUkEDiXrehxF2R4lgQq
qPPJTyFzRzoiLX8BbyeaBA==
              "], {{0, 27}, {61, 0}}, {0, 255}, 
              ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {61, 27}, 
            PlotRange -> {{0, 61}, {0, 27}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"ae327f56-1305-446c-bf91-accbb8342568"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["22.1"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"5e2bd33d-2308-4b2c-a7e4-d24fa02b856e"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"fc5366a0-206a-4df9-8bb8-3c5db3e53652"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"ccb6a435-83c9-4d64-a85c-1b6147732715"],

Cell[TextData[{
 "Apply ",
 StyleBox["ImageIdentify",
  FontFamily->"Source Sans Pro"],
 " to an image of a tiger, getting the image using ",
 Cell[TextData[Cell[TextData[Cell[BoxData[
  RowBox[{
  Cell["ctrl", "KeyEvent",ExpressionUUID->
    "fd81ef23-f5d1-4c99-84ee-dfe4a7dbab40"], 
   StyleBox["+", "KeyEventDelimiter"], Cell[
   "=", "KeyEvent",ExpressionUUID->"d7b067e4-f4ac-4c3d-910d-9f1a58b76440"]}]],
   NotebookDefault,
  ShowStringCharacters->False,ExpressionUUID->
  "d9f14b7c-20a6-4146-a748-50b7659d6beb"]], "MenuName",ExpressionUUID->
  "ad68c584-3df5-42aa-8aad-5b984ed77d71"]],ExpressionUUID->
  "050d81f5-f8b5-486a-b5cf-44ba0942e379"],
 "."
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "22.2", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 22}, {"ExerciseNumber", 2}, {
   "WebOnly", 0}},ExpressionUUID->"1fb70927-ff4e-413f-ae03-186ce6ed0125"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"f68f9c14-1737-455d-af74-2c2c1707bd85"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztVk1oGlEQtumlR9seW1p6Ljna9hToIYeyN0ullyAJ3fwckhpT6fYgMQ0o
CBqLuCDaQLxIQAMmkBjKQhCRtFJMEAka4oLBpFWykFSWrUn7Ou9pxJ8krSa2
PWT4VmZnx5lv5s3ue/f6Xir7O2Qy2dg1+FH2vn6s1fa+eSqHm2cjY0MDI/SL
JyOv6AFa+6jvKhhvwXUfLqyjS/l/5OcPtKxFtjvobQeakLUFEBnif7KjQ6k+
O1jMN7HPl1X0PYeK+bYAIkN89wNkvoHrrZblMeR/3q68jYBKV6dqCEBngNsp
/vvJYDgUObpAApBr6nYNAVidus6LMW8/5ZmPgr5uktMKZv9i1wIyVgv0pM5H
DOkVcp0jBPpRLp7Z2rj4VTiDgBjz9EDVGKw/kuWMNuusRB4d7XAeDQV2ncb4
kXOyBntWxPZCco7t6QT7sFId4KIkzvaKSe32zi6aVLRClRCaIrCxaKAIAcrH
xRKOLrrbiJdA4CaxscszY2fLDKl1IS8lp4mu8vmdJTu7FEdFPnBchV5jzBw0
QwAjArn0rgjoKRcQsBSK+bRXDdECazxx2PT1YwIJYfuDBpTRbPmPmz7IqwR/
HisKdSLX/BIADjgyA1w1AdIKrJR8Mn41IbDpVeK2sCbGDbAyuEvd43tAAOym
hVZm4BQCYUOptFoCuagNZ6RshkEbg+G2jrsd0yUCpQitEBAwAb0rVE0g5YLB
UKXEfHnGmE7SAVJpj73yoUj7x1nHnHROAmLEDCOtsaR3+AqBwpqFJsZEMhp2
UJUhTHthzuVm19zX3Ma6l8HviDWIzkmguEsKhEUMpmaoSueznEVHBht6PowV
hryG/IqpxAdDxzj3sDMfOBcBDEngJbHqNsOtzC/sg0XcReWZNFZGQsrFs1vx
vdz2779Cf0ygDoWoERdocKa3Yp9nRkmrTxnyZgk07gUngw87Biutnjz+PDaN
xr3gzN2wcTykA74g7LZYe/Gk3TA4iiautB6wWcCZZGmohgCcT+CU8v7h3zgR
vbuLzNeRJKA6gVPZ0jDuTFvPhBAfaj/8Vp/9Uv6d/AI0hamw
            "], {{0, 27}, {
            43, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{43, 27},
          PlotRange->{{0, 43}, {0, 27}}]], "ExerciseOutput",
         ImageSize->{47, 27},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "b845747d-e166-4cb8-9117-36a3e8b18403"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztVk1oGlEQtumlR9seW1p6Ljna9hToIYeyN0ullyAJ3fwckhpT6fYgMQ0o
CBqLuCDaQLxIQAMmkBjKQhCRtFJMEAka4oLBpFWykFSWrUn7Ou9pxJ8krSa2
PWT4VmZnx5lv5s3ue/f6Xir7O2Qy2dg1+FH2vn6s1fa+eSqHm2cjY0MDI/SL
JyOv6AFa+6jvKhhvwXUfLqyjS/l/5OcPtKxFtjvobQeakLUFEBnif7KjQ6k+
O1jMN7HPl1X0PYeK+bYAIkN89wNkvoHrrZblMeR/3q68jYBKV6dqCEBngNsp
/vvJYDgUObpAApBr6nYNAVidus6LMW8/5ZmPgr5uktMKZv9i1wIyVgv0pM5H
DOkVcp0jBPpRLp7Z2rj4VTiDgBjz9EDVGKw/kuWMNuusRB4d7XAeDQV2ncb4
kXOyBntWxPZCco7t6QT7sFId4KIkzvaKSe32zi6aVLRClRCaIrCxaKAIAcrH
xRKOLrrbiJdA4CaxscszY2fLDKl1IS8lp4mu8vmdJTu7FEdFPnBchV5jzBw0
QwAjArn0rgjoKRcQsBSK+bRXDdECazxx2PT1YwIJYfuDBpTRbPmPmz7IqwR/
HisKdSLX/BIADjgyA1w1AdIKrJR8Mn41IbDpVeK2sCbGDbAyuEvd43tAAOym
hVZm4BQCYUOptFoCuagNZ6RshkEbg+G2jrsd0yUCpQitEBAwAb0rVE0g5YLB
UKXEfHnGmE7SAVJpj73yoUj7x1nHnHROAmLEDCOtsaR3+AqBwpqFJsZEMhp2
UJUhTHthzuVm19zX3Ma6l8HviDWIzkmguEsKhEUMpmaoSueznEVHBht6PowV
hryG/IqpxAdDxzj3sDMfOBcBDEngJbHqNsOtzC/sg0XcReWZNFZGQsrFs1vx
vdz2779Cf0ygDoWoERdocKa3Yp9nRkmrTxnyZgk07gUngw87Biutnjz+PDaN
xr3gzN2wcTykA74g7LZYe/Gk3TA4iiautB6wWcCZZGmohgCcT+CU8v7h3zgR
vbuLzNeRJKA6gVPZ0jDuTFvPhBAfaj/8Vp/9Uv6d/AI0hamw
              "], {{0, 27}, {
              43, 0}}, {0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {43, 27}, 
            PlotRange -> {{0, 43}, {0, 27}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"3ee645c7-7cf8-4ec3-bb2d-c80481a73043"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["22.2"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"60d51917-5f40-4da0-b066-844d809addde"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"a26483d4-ba99-406a-b40e-f526920a54d3"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"bccae46f-fcd6-4357-9996-eba3d7caa54d"],

Cell["\<\
Make a table of image identifications for an image of a tiger, blurred by an \
amount from 1 to 5.\
\>", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "22.3", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 22}, {"ExerciseNumber", 3}, {
   "WebOnly", 0}},ExpressionUUID->"3aa7df4e-7610-4be7-8d4f-743895b6b9fd"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"7b728fcd-c8fb-4fa4-a66a-61cacc9f8121"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztXd9PYtkdZ7cvfaTtY5s2/QP0zW2fTHzwoeFhEpqaPiwxuyms++AUZ0p6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            "], {{0, 27}, {373, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{373, 27},
          PlotRange->{{0, 373}, {0, 27}}]], "ExerciseOutput",
         ImageSize->{377, 27},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "78687b87-8653-480f-8f60-8e5ea3316726"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztXd9PYtkdZ7cvfaTtY5s2/QP0zW2fTHzwoeFhEpqaPiwxuyms++AUZ0p6
fTC4mmgkkdUQiEbrRKO5IeIkOIm4MSSETIhTlvirhAoK5hKwYiSRWqEju7ff
c87lCtyrXKeiuJxvvru5nDlzvt/v53y/3/Pz3vn153/WGj5WqVQvfwz/0372
144XLz7r/70afvzh+csvv3iu/9Pvnv9F/4X+xW8//xEU/hz+M32kUqFnnhIl
SpQoUaJE6WlSPhVamhrr7588yD+2KpQoUXpqlD/yDvUPTb5yH+Ukf5bbfKbC
1GHcLU8v33/Hf/OCn/glP/Qx/5WqLgwtQ/t/t/FXBUVmNKdKjcwUrmaDS86E
fGSpg+SQ1slMpQUZ/xBkFs9R5cQF/q7lZ6i1f23y/83w70/rwtAytD/7CW/5
KULydmpalRqZKVzNBtfNJmQ2pyDBuI+uygtDkx2q1qnqSc03L/mVPz6czoDh
5tc10KYqNTJTuJoNLqkJ+V1YB42FsuVlu1Ny6QXmP5Cjbmj5fH/9rT9QvEdV
QdbXv6iB9lNTCbiY9vtW188fo/fvHxAKV4PB9cgsNSEfgiXSpJL0AiusqvnY
5RZr0CysBuF5Z1Stb2Pu0w1AFki8nZ6ESpV8ERzRt7XsZB+qx+sKCObC/uKw
jonnKFyPD9cjs9QE5ekFZj7VfeEfaFOb7H54Lmb2uMPIPWv7Va17OE9CpUou
hsf1be3hh4uXOgNSsih6SeF6fLgen6tMyH1oerncWtBBekfsWAmkvCMTVmeB
AJj2Lhg1UG4yjrzzTjsGbSkM5sX+a4euBcp7td1ubxC3k/SNds+yzrXRLn1b
V7UX3RXtBlRJkL4+a2jH0s0+tk/fpiHNpvy24U6scKfGJUhPgHTHzJwbSVf3
6vpC4YDP2o2N0rgDEdHStdHuXlTY7rAvngm+ehz3jA8IDXatBfduBQRUasF/
1OKYcUrHaNkKABcxBAotgzYui8diLNGk7doIJ+4lXihcyuEqHDonjIzPM02a
HWBsXGlepMC3JQhcB0tJbasAV/HQaTEw7wJOoU1d3076uHZ64Y/6UXqpyCWb
Q62tY5u1YjmyNqgh/ejyboXt7frOEYRq1juM+3Fh3uYQOkuzg4Cdw89drpVp
Uu7wgDkJd6lDB4wjXO7/Q7sBVQLO+YcFrxsXpUO8nPnN6FnH+LzOWQOWvroF
0l2kjrbHZe/DEYE0n7Wbsf9owkifvQXsEg77tNuKwkpvnCugWfc0drAR3+q0
Q4sqbES3bweEXVlkGeRIlpVghc6yFS6DFtLUyuKavYfI/Q/3hvibhWHeHSbv
Ib1QuO4C18X2OPHVCfvcxgyWokU6K/Htg10JAqCSgD/Y4tyw40RtmL5Aq1RB
kMnIuKxYkM5WqJ1eclOtKqMnVVaSgoRjWD6o7QnvA6DJwEwAnqMz0BfjoEac
RSq5t0lmjrkMxD2SG0Z46EsJfzGGvEIL9Yl7dIczEj0/cOxrOJW4lXLpCbcg
PeaCDtWaT4RqERaEImfG0juF8rAdebvvEA0TZBfiLXd84oEBXb0WTpbaR30N
5fF5iJ0WUpl/H1wwkPHxRkBcQUElFqJPN13uKvIVcn5LW8vavlBnwyB4cjFs
u8fZPoXrTnCR9DI84yU/o8gotWv7n0p8WxYBDtuyIRSexjFc7nCSCBqwvyHl
O1bIoj1xqRUSE7wom7iFH1cZ99Az+L0rvawrM9B48ULVW94XOOejhzJvQe7B
avHUdJSZBbYyKEN2ms/AXigffSMD9QeOfY2m0vG7QbUwCGI+R6NweziJ9ByY
8V+7KOpr0ApJJ/pjEyBemJMyR2IDsfAMciETwywgtc0TeNxZCMSKwoClNum6
WdbJZY5vAmQHACk1i/gyWchVTHRvqlBMB3zzIw6mewAL1etQa1ixG7ZHKFz1
hUswE7KlUJJ+DVM4NvitEt+WRQDnDagptF/YtiEYgzEiyCWkfQK1RmbLXWJC
/mBZpVL1L4fy6LruGDw/W5JMXRTH8ttBkicrYzkTnMBL5onBngkGMXT0rH2O
2Cu6R53Sy6OqlCgNHEJJyoM3E4R4uZYSlY+X68QoxEswFsXx0mvocWC1wYUW
Rs0hLon92b9m7RNW0xBE/j05QBJrhgqVJCxfoTTfVg8zfSw7xxqFOvcaLxSu
uzk8bo2sAQX/N4HVm16Fvi1B4NsqWwolGEU8y9OLjBVyJix/im7v+tEGTG5z
ygAJZlP6poA0lrPXY4rYs1huV2nul/QxLaIbwGJNvEUQXzE77K8L955eGk8l
PGO/dgA8OpSS26CzVC3pFibPSuIFGmzfET3q0OlgxrncKbdqtlhfl9xmHRb+
vdb1mwERVUqi9bhhrny2L1thG8sNCWvGY7euMl6kJ60UrvrDRcyEyRj5eeZn
8FrmH0p8WxaBymA5PfEyZGn5weklt/sKcsukV5yx4L0X91HtWL4MIJWM4/F0
QuwLogYUhveDb+0acR81zqJBxDLz+iQT2WGRziboTYWxfBXpb1V1DHmqV2xP
QSVRejwdia6axb1KHDhqB7t+no2F5tEKd5gN8Aripcgt4pm2OcpFUtuLeCOu
L3UpmLOw6ocGuYCtlzQoB0gBLf9xIbdHRFftVcpWILsirMd/xgU3rBjGTiae
Pca7HOqJ+Tdn0pChcD0IXJAQ3u1HUsG5gTZhy0WJb8sicLFdsiWdOAnOmUp7
xbLpRcHi6MpjRNmk/K0AfHIUqp1e3h/jmQCs5taj8xpxTpXyjpvahANEvJnP
4FPghG+UhDZe7jHTeH2XcCuJ5fzup/jdqNpXcRpRpdMoOl0VpAyjk8quKLjW
5Z7b2CKWD4wuYlUlmwlaMV5s4p5nyj9eOiXBrkWW3rnArE4sRAGF727JAxJf
ZcoNP5Hs0clUyHonSrNovbaHxWfB0CyU4yMS9WxpDKVwPRhcJOpNOhEZjW9f
2GGu7dvyCJxGV67x13f2hPEBNEmh4t4L3vvC/VIjveCTo8q5Crr30vFKiScg
udlEoQztAuf1rb45h5JLpBU53bteymX2Uod7ZxnJkdztsczzB7B+U3LTr2FV
QlK2zrLVVwXOuS1uP5hKS65A1ORcDBo8Sccqb60fQ4MpaJCrcN0qQAgXs7ET
7jbD5Sokz8qEXmRiF6Ul50U2KXN/nsJVZ7jI3guEeSGN3LjqpFiBb8sjUMxG
oJA73LvzOxEK7r0ovbUrx2TuZxqcjh9uheb78KzshlMYxaqm0ARLtbSb5X8o
KjULU7jqDBfZyXm4lyYUmyCQ8lu7St93SLwll4jI5LZ07/HOXPb+wlUudZCS
+6zVE1apCZjCVX+48JpFcre8AUwQSPk7R3d7W/O4kEtcSCa3d+D7f4G0AVX6
QTOFq9ngUvbGNPreS4ckvaz38V999HCqzn7Ce76sgTZVqZGZwtVscElNkPve
S9Y/plK1ug8qE8z336GvUf3tNw/xabjJX/GWn/AFydqzippWpUZmClezwXWz
CSkvuqa7XPXB7vyugXwnU2XYLc8xVwXe04vmP3X9sC20Dznw6t81oG5mlRqZ
KVzNBpecCfnIUqvwve7qb+0iI7IH7qWpoaEp+i8FUKJE6a6E/6WAsVfLXtkt
akqUKFGiRIkSpSdB/wOkLSES
              "], {{0, 27}, {373, 0}}, {0, 255}, 
              ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {373, 27}, 
            PlotRange -> {{0, 373}, {0, 27}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"e7f6ca7b-d9c0-4d5c-824d-e8fb22f8b888"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["22.3"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"3fefd6e0-8a61-4a79-83ce-9aa41e9ba691"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"58c64c29-ec4d-473e-9500-afe78140cd8a"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"e4e6852f-964e-4958-ad5a-c18dfb35e5bd"],

Cell["Classify the sentiment of \[OpenCurlyDoubleQuote]I\[CloseCurlyQuote]m \
so happy to be here\[CloseCurlyDoubleQuote].", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "22.4", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 22}, {"ExerciseNumber", 4}, {
   "WebOnly", 0}},ExpressionUUID->"b05d423d-ee30-4862-921f-b070ae8643c7"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"4ae100f0-abab-43a1-ad13-fdbb1e58798e"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztVa9v3DAUjjYyOGl/wf4Bj44aDkXqNBbSak010lntpOlo2EGzsKCgoKCg
ECOTEBOTgBCTAE8yMTDInp3k7tq703p4fVJOtt8Pf/7eZ9/Hm59X6Zsoih7f
wc/V9W/88HC9+foeJt/uH3/c3d9+/3L/6/bu9uHzzVtY/ADfJ/j8eHq1/8Wc
dacd9pzjrFleFflsRVm3XJnL0ssEpEd6N8Pab99XBBy5uKicyTEk4TRNk9iP
oihm4wVgWE7SrNIeygDbbzs9O3RXJsmGqYvI8WBwLpaZagEQpt3O7aw5ItsZ
Y09UcgJyqTjlOmu+/HMw+90PplpsExS4ijYFm3PGrpzpi1BaS0+CLAkilbWS
LLFgaWcm21cYEWFNmaIkX+u7PsOIBuoVL+M5HBOm7AlmRgYBfur6TShbc9GW
fhhDQSdTGNBWqb7aEsoUZAjIR1Q7zWsKcBJaM8ZHNxlBoRI3E6cAnwyhvOaw
GDWjs7KIfHDTD7Lw4spUAFN4fDjxmglnQxsQnel8VjUsHWIZuFL5R0AsIoUc
99wGMLkJbYq9YheXETmUBYrcUK9KdjXsG5d2shWcClEA4NxkFQQgbgIzUCLO
qrqqqpp1/VxraDwbrV6b1y3H1LJJ0cJtO5gnYGznNbMKeAcG+PB3ZMOgpbBV
1kKPTLiDh5Z05qhNq+nATKOWKd9CuWSnTaO6DPujmWMw610+ADOpBhghTZ1B
EemLhAchLo60/kzAq1nhseOM90q0HhjaMqfaBJNGKmtH/4rswdAZDBw8LZhS
g3ZPwACzMxM4Y8th+dYrMm+V1kPX5CV3ewEfgQFHX++4xKT0F+DgfsHBajm3
KY5wEfZ0jC4ZtDMBTLyAmVzrqYxKeSC2Kts1CWfNC14EZ7TWxv1j6ZBR73zx
U+Pm8Ev/NV7t1Rb7C7BV0lM=
            "], {{0, 19}, {47, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{47, 19},
          PlotRange->{{0, 47}, {0, 19}}]], "ExerciseOutput",
         ImageSize->{51, 19},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "347ebbe0-ad8d-4640-b43c-4f9b52acbb17"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztVa9v3DAUjjYyOGl/wf4Bj44aDkXqNBbSak010lntpOlo2EGzsKCgoKCg
ECOTEBOTgBCTAE8yMTDInp3k7tq703p4fVJOtt8Pf/7eZ9/Hm59X6Zsoih7f
wc/V9W/88HC9+foeJt/uH3/c3d9+/3L/6/bu9uHzzVtY/ADfJ/j8eHq1/8Wc
dacd9pzjrFleFflsRVm3XJnL0ssEpEd6N8Pab99XBBy5uKicyTEk4TRNk9iP
oihm4wVgWE7SrNIeygDbbzs9O3RXJsmGqYvI8WBwLpaZagEQpt3O7aw5ItsZ
Y09UcgJyqTjlOmu+/HMw+90PplpsExS4ijYFm3PGrpzpi1BaS0+CLAkilbWS
LLFgaWcm21cYEWFNmaIkX+u7PsOIBuoVL+M5HBOm7AlmRgYBfur6TShbc9GW
fhhDQSdTGNBWqb7aEsoUZAjIR1Q7zWsKcBJaM8ZHNxlBoRI3E6cAnwyhvOaw
GDWjs7KIfHDTD7Lw4spUAFN4fDjxmglnQxsQnel8VjUsHWIZuFL5R0AsIoUc
99wGMLkJbYq9YheXETmUBYrcUK9KdjXsG5d2shWcClEA4NxkFQQgbgIzUCLO
qrqqqpp1/VxraDwbrV6b1y3H1LJJ0cJtO5gnYGznNbMKeAcG+PB3ZMOgpbBV
1kKPTLiDh5Z05qhNq+nATKOWKd9CuWSnTaO6DPujmWMw610+ADOpBhghTZ1B
EemLhAchLo60/kzAq1nhseOM90q0HhjaMqfaBJNGKmtH/4rswdAZDBw8LZhS
g3ZPwACzMxM4Y8th+dYrMm+V1kPX5CV3ewEfgQFHX++4xKT0F+DgfsHBajm3
KY5wEfZ0jC4ZtDMBTLyAmVzrqYxKeSC2Kts1CWfNC14EZ7TWxv1j6ZBR73zx
U+Pm8Ev/NV7t1Rb7C7BV0lM=
              "], {{0, 19}, {47, 0}}, {0, 255}, 
              ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {47, 19}, 
            PlotRange -> {{0, 47}, {0, 19}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"4607b5cf-0194-4648-9e02-aab9c777525a"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["22.4"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"55b2c58e-c8cc-448e-b86e-308e073afddb"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"9995ebac-f6ad-48d1-b274-eadf646a4997"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"0bf49169-6b5e-429d-b4d3-4ceba0cb5677"],

Cell[TextData[{
 "Find the 10 words in ",
 Cell[BoxData[
  RowBox[{
   StyleBox["WordList",
    FontFamily->"Source Sans Pro"], "[", " ", "]"}]], "InlineCode",
  ExpressionUUID->"b6384f87-cd03-44d5-8909-c2ac8219b889"],
 " that are nearest to \[OpenCurlyDoubleQuote]happy\[CloseCurlyDoubleQuote]."
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "22.5", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 TaggingRules->{"MultipleSolutions" -> "True"},
 CounterAssignments->{{"SectionNumber", 22}, {"ExerciseNumber", 5}, {
   "WebOnly", 0}},ExpressionUUID->"3f38341e-0db6-4923-8425-8fcea2b5ded2"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{
    "SAMPLE", " ", "EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"a0c86a58-b9f6-4e6b-bff5-a9af5916cda0"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztWzGPrMgRxnbi0JJ/gf9Ax04JLQdIZzkjubMfJyfP6N1JFimRCcnIiIiI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            "], {{0, 19}, {421, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{421, 19},
          PlotRange->{{0, 421}, {0, 19}}]], "ExerciseOutput",
         ImageSize->{425, 19},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "a8a2a505-e698-40e5-9ca0-8d72bea0cde1"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztWzGPrMgRxnbi0JJ/gf9Ax04JLQdIZzkjubMfJyfP6N1JFimRCcnIiIiI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              "], {{0, 19}, {421, 0}}, {0, 255}, 
              ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {421, 19}, 
            PlotRange -> {{0, 421}, {0, 19}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"47803965-fbc7-466d-b977-8097a948f247"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["22.5"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"17dafe48-93c3-44dd-b728-d889f9410fcc"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"16cb33e2-a5de-46a7-9795-a64d7ec20a7d"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"e78d4e96-9bf3-4cac-b196-27fae2d825ac"],

Cell["\<\
Generate 20 random numbers up to 1000 and find which 3 are nearest to 100.\
\>", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "22.6", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 TaggingRules->{"MultipleSolutions" -> "True"},
 CounterAssignments->{{"SectionNumber", 22}, {"ExerciseNumber", 6}, {
   "WebOnly", 0}},ExpressionUUID->"fbb47e51-8d01-44a7-92d9-7ec98ca3f8c0"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{
    "SAMPLE", " ", "EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"6133e682-67ab-417a-baef-05c8349e5ae0"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztViGL3EAUDq2pLPQX9A9E146oqFpoqVtzRy9HzTXcFUpsTBk5blxUagKF
QCEqJioUxowZMyImJiJiKkZEbN/MZPdud5Ps0WupuQcbkm/zvfe+N++93Zfn
n94GTzzPu3kGl7dnX9D19Vn07jk8vL+6+Xh5dfHhzdXni8uL61fnTwF8AZ/X
8DH3m0d7tEf7c+sLHPh+yDXcK1bmWVawpj94aegkY0INC36muUPfcC7V6TSU
5Ly5E0C1vMizvKhkp+dBlQYIreO6G4mKU9gJAc5b3WAEt57vm2tUNHdiNbH9
pp5La5jk6jy06ALRmswi+5qHa1eKgSWhIzo84f0cKIpkDRCuRzmMeB4BqW1p
fGYSZA55BJRwp4fRtXWwYjNZzXB1meAo8BeIY7HKNA5X4IGy8WRFEqyIzXCQ
xnVUzoEWX3k+cUzNjRyIxgjagZu2MPKFstTMKIki5K3mijzHNXSReB5aluOS
Aj2EHTY51BuDu3Wq50FOITp1EWS6dpmYlDw8uusrNDrvMFTXJ53iKw8tyZng
2sCmme8hRzN0IGdQXSPLxJ5DLhdAYSVAhF6W0I7INp6WqenLdUxp7LqTMsVN
Y7pD4chDfGYVTHIfKMdOgbNQ6CXQ9Q/OBbaTVW599LIicRTFtKpzcP71xzc3
MoQSHJsxDCJcNvvHvpnm4oefjs1UtcwUCFG1BGpqizj0wuBxeeTbFOE7/0kJ
oRQuhOBRTjUj54Cbt+NBamHlnCBBjtzMDt9OnL4ldAW0lunzSdCGSMy01u3G
LEloJzM7Q1eF67gSjWSZ2TJhPuyHg2ZjDhoEbC8UFzvvk1woIueiSqEOflIx
LqzCI65pVc55ZVKK0kpw3v4SpsVxJru+lRXsIFjE3TAFWr4df+oc7jbb0NXB
uNE9P6DNwZiYZtiuAs3N4rbTt5Uzwb3T5+4Lu/qOuOB5tfcetJxqqgTtnlFY
tSbZSXCzv9lsULxzrvq+Vyc7w56pTw8G4iHcSVOqV0cOj0EBcrZz5BoPHR/H
vLWFmaOUH/9G/FvulOnaLm1E2C2S4iCIxem6jgZDIdt7v/33uFOmCxyGcXKf
P4WP9n/tN1MQ7jA=
            "], {{0, 19}, {69, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{69, 19},
          PlotRange->{{0, 69}, {0, 19}}]], "ExerciseOutput",
         ImageSize->{73, 19},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "519d0ec4-6e17-4e4f-86bc-2589e39d53fa"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztViGL3EAUDq2pLPQX9A9E146oqFpoqVtzRy9HzTXcFUpsTBk5blxUagKF
QCEqJioUxowZMyImJiJiKkZEbN/MZPdud5Ps0WupuQcbkm/zvfe+N++93Zfn
n94GTzzPu3kGl7dnX9D19Vn07jk8vL+6+Xh5dfHhzdXni8uL61fnTwF8AZ/X
8DH3m0d7tEf7c+sLHPh+yDXcK1bmWVawpj94aegkY0INC36muUPfcC7V6TSU
5Ly5E0C1vMizvKhkp+dBlQYIreO6G4mKU9gJAc5b3WAEt57vm2tUNHdiNbH9
pp5La5jk6jy06ALRmswi+5qHa1eKgSWhIzo84f0cKIpkDRCuRzmMeB4BqW1p
fGYSZA55BJRwp4fRtXWwYjNZzXB1meAo8BeIY7HKNA5X4IGy8WRFEqyIzXCQ
xnVUzoEWX3k+cUzNjRyIxgjagZu2MPKFstTMKIki5K3mijzHNXSReB5aluOS
Aj2EHTY51BuDu3Wq50FOITp1EWS6dpmYlDw8uusrNDrvMFTXJ53iKw8tyZng
2sCmme8hRzN0IGdQXSPLxJ5DLhdAYSVAhF6W0I7INp6WqenLdUxp7LqTMsVN
Y7pD4chDfGYVTHIfKMdOgbNQ6CXQ9Q/OBbaTVW599LIicRTFtKpzcP71xzc3
MoQSHJsxDCJcNvvHvpnm4oefjs1UtcwUCFG1BGpqizj0wuBxeeTbFOE7/0kJ
oRQuhOBRTjUj54Cbt+NBamHlnCBBjtzMDt9OnL4ldAW0lunzSdCGSMy01u3G
LEloJzM7Q1eF67gSjWSZ2TJhPuyHg2ZjDhoEbC8UFzvvk1woIueiSqEOflIx
LqzCI65pVc55ZVKK0kpw3v4SpsVxJru+lRXsIFjE3TAFWr4df+oc7jbb0NXB
uNE9P6DNwZiYZtiuAs3N4rbTt5Uzwb3T5+4Lu/qOuOB5tfcetJxqqgTtnlFY
tSbZSXCzv9lsULxzrvq+Vyc7w56pTw8G4iHcSVOqV0cOj0EBcrZz5BoPHR/H
vLWFmaOUH/9G/FvulOnaLm1E2C2S4iCIxem6jgZDIdt7v/33uFOmCxyGcXKf
P4WP9n/tN1MQ7jA=
              "], {{0, 19}, {69, 0}}, {0, 255}, 
              ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {69, 19}, 
            PlotRange -> {{0, 69}, {0, 19}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"bb47eda8-f2b1-440a-9519-52dc7969302f"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["22.6"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"563cf47f-1249-4804-9b30-7d13db4e7aea"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"51f8ac7b-2227-4123-a3ad-f93eeb604f50"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"6feb2866-cf2e-474d-9764-4a1519ec2f96"],

Cell[TextData[{
 "Generate a list of 10 random colors, and find which 5 are closest to ",
 StyleBox["Red",
  FontFamily->"Source Sans Pro"],
 "."
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "22.7", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 TaggingRules->{"MultipleSolutions" -> "True"},
 CounterAssignments->{{"SectionNumber", 22}, {"ExerciseNumber", 7}, {
   "WebOnly", 0}},ExpressionUUID->"45125d8a-4186-4742-b24e-49cda9c87cc1"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{
    "SAMPLE", " ", "EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"5f3815e7-800c-4007-8b8c-933e3e6497ca"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztlzFIw1AQhh/t4ih1UwcdxEEIDoJO4hsdRKjoVIcWm+JSSytIR7Nls1vA
IaDEpVOnTN2zdMkSh6wZdMgQlCAZ6uW1dehrnlcRFJLjT3op/dP2I+/u3nrl
qijnCCGtBTgVyze02Sy3Txbh4rTeuqzVqxeH9etqrdrcq+ThzSU4SnDE+TCL
LLLI4jfDN1VZkhp2+Nc/5M8iMGRKS4r1Go2vbQ2Kraz27gsFsWbe7mk/J9ZM
18PGllgzXXc7y2LNdD2erYk1HEaOqUPbkVRrzGTQIaQDzwj865eV1SQJmHyc
55MkYPK2e5AkAZPno80kCZi8324niTGJw9GPidTxWR7aMZMg9UxsjRJJC1ju
GqURn5QzcRgHYOK7/QYhlK2jlDOJ3C7UVbXnqPBCpD5bRSlnAlVEk2Icke8o
kCj9jEno6ABEtzzI3S50IXQ9iZy2RKhifs0yKCacC8WEc6GYcC4kE1ZXtZFr
vr4T2vH2kdWiOZhwLhQTzoViwrl+0HfYfKLie3H8XE28WCacC7l2plzItTPl
wvYdYELHrtE6orKGmWM9E9oUMWx/8oWoOZZ3YeZY3oWZY3kXYo4NLb0dQ+gM
JqbQMlRZVhzEficKPNebe1/0712hqTYaiu4G3380iyxG8Qkx25gf
            "], {{0, 
            19}, {92, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{92, 19},
          PlotRange->{{0, 92}, {0, 19}}]], "ExerciseOutput",
         ImageSize->{96, 19},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "029c1fa2-9f06-4a1a-8780-073077cc49c3"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztlzFIw1AQhh/t4ih1UwcdxEEIDoJO4hsdRKjoVIcWm+JSSytIR7Nls1vA
IaDEpVOnTN2zdMkSh6wZdMgQlCAZ6uW1dehrnlcRFJLjT3op/dP2I+/u3nrl
qijnCCGtBTgVyze02Sy3Txbh4rTeuqzVqxeH9etqrdrcq+ThzSU4SnDE+TCL
LLLI4jfDN1VZkhp2+Nc/5M8iMGRKS4r1Go2vbQ2Kraz27gsFsWbe7mk/J9ZM
18PGllgzXXc7y2LNdD2erYk1HEaOqUPbkVRrzGTQIaQDzwj865eV1SQJmHyc
55MkYPK2e5AkAZPno80kCZi8324niTGJw9GPidTxWR7aMZMg9UxsjRJJC1ju
GqURn5QzcRgHYOK7/QYhlK2jlDOJ3C7UVbXnqPBCpD5bRSlnAlVEk2Icke8o
kCj9jEno6ABEtzzI3S50IXQ9iZy2RKhifs0yKCacC8WEc6GYcC4kE1ZXtZFr
vr4T2vH2kdWiOZhwLhQTzoViwrl+0HfYfKLie3H8XE28WCacC7l2plzItTPl
wvYdYELHrtE6orKGmWM9E9oUMWx/8oWoOZZ3YeZY3oWZY3kXYo4NLb0dQ+gM
JqbQMlRZVhzEficKPNebe1/0712hqTYaiu4G3380iyxG8Qkx25gf
              "], {{0, 
              19}, {92, 0}}, {0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {92, 19}, 
            PlotRange -> {{0, 92}, {0, 19}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"2ac2ed4e-140f-4f48-9e46-5db56c36dcec"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["22.7"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"58b689ae-47bb-46a0-b632-16828f925152"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"7ef804d4-f754-48a2-a243-a3b317b3127d"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"7075db87-5c93-46a2-9266-647c0ae6b84f"],

Cell["Of the first 100 squares, find the one nearest to 2000.", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "22.8", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 22}, {"ExerciseNumber", 8}, {
   "WebOnly", 0}},ExpressionUUID->"b1c81f98-046e-41d3-b2a6-7bd1de1aed25"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"313ea652-0505-4a9e-a883-5a2f94c9c52f"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztUiFv3DAUtjpSWGl0ZH8geDSwKFKnsZBWu1Qlt+g6aToaFhgWFhRkZBQU
csgkxCTEIMQkwMDEwCB7z7lLrj2pmqbCfpKT5+fvPb/3+X19+HWXXBFCnq/h
c3f/J9zt7vffb2DzY/v89Ljd/Lzd/t48bnbfHj6B8zOsL7DQnj7w7jCKN4xS
xvtxdbrx0NCaMqHs4tODaCgQ20G7JViKFb0ySBM0IIj5m9LeM4c8JCcETGLa
rkr8biaGrfJpbbcSATkHn6xjsJS/scagHGpV7R4sKiFqQCthbrJVSKKy8+Vy
iAkLtJ1iYB5GN7kZx+K1OVqa50DgxrEU/qXxzh4vTXo7OaNPKpjilNN0YEZi
UeICXQF9ZGoyZXAMweZE6S86J6oMNJhz4ikJ4jRN9yV9yYIuBoZd1qCnKcM1
p48KuzO2qKDyoPF6WklBkoIyVqFIJKFnL4oSkbj2oW/VqVrQh+yZvGxz8JId
mSPHxwmL0yS5Bg+r+UaJL5f0XrHBJ0wqsXZnVynHNptzWtXGfgrKthNdxzmX
2s0qZUyMEk+D7IDJWTaP20HMRKFtD6dx0QzjKHmNQxVVUKYoI/ISOdfTMo1I
KwasRZfhKyJOSN+euaNMvHqkC1ij9TJnb8EZmEf7D8QP/Bf+ApVAHZk=
            "], {{0, 
            19}, {28, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{28, 19},
          PlotRange->{{0, 28}, {0, 19}}]], "ExerciseOutput",
         ImageSize->{32, 19},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "5518bf7e-ede6-4211-b85a-2d9fcf6f7535"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztUiFv3DAUtjpSWGl0ZH8geDSwKFKnsZBWu1Qlt+g6aToaFhgWFhRkZBQU
csgkxCTEIMQkwMDEwCB7z7lLrj2pmqbCfpKT5+fvPb/3+X19+HWXXBFCnq/h
c3f/J9zt7vffb2DzY/v89Ljd/Lzd/t48bnbfHj6B8zOsL7DQnj7w7jCKN4xS
xvtxdbrx0NCaMqHs4tODaCgQ20G7JViKFb0ySBM0IIj5m9LeM4c8JCcETGLa
rkr8biaGrfJpbbcSATkHn6xjsJS/scagHGpV7R4sKiFqQCthbrJVSKKy8+Vy
iAkLtJ1iYB5GN7kZx+K1OVqa50DgxrEU/qXxzh4vTXo7OaNPKpjilNN0YEZi
UeICXQF9ZGoyZXAMweZE6S86J6oMNJhz4ikJ4jRN9yV9yYIuBoZd1qCnKcM1
p48KuzO2qKDyoPF6WklBkoIyVqFIJKFnL4oSkbj2oW/VqVrQh+yZvGxz8JId
mSPHxwmL0yS5Bg+r+UaJL5f0XrHBJ0wqsXZnVynHNptzWtXGfgrKthNdxzmX
2s0qZUyMEk+D7IDJWTaP20HMRKFtD6dx0QzjKHmNQxVVUKYoI/ISOdfTMo1I
KwasRZfhKyJOSN+euaNMvHqkC1ij9TJnb8EZmEf7D8QP/Bf+ApVAHZk=
              "], {{
              0, 19}, {28, 0}}, {0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {28, 19}, 
            PlotRange -> {{0, 28}, {0, 19}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"36d55505-3c20-41c9-b35b-e993457fd6e5"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["22.8"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"cedb0972-94bf-4e40-bc6e-f94090654e7f"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"6053f40f-6f87-4125-afdf-24e20623ad3f"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"1e885bc6-8a86-4588-a4c7-bdddd6d0b0c3"],

Cell["Find the 3 European flags nearest to the flag of Brazil.", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "22.9", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 22}, {"ExerciseNumber", 9}, {
   "WebOnly", 0}},ExpressionUUID->"6054dbd3-adb2-4be4-ad25-12429c5949b0"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"4db4ce76-c147-44bb-b238-a4b935e1a08f"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJzt3dtzE9cdB/Bt+9LH/gudGIZhEqWhmZChlMTttA23yHfjYGMMxtjgGt8w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            "], {{0, 87}, {401, 
            0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{401, 87},
          PlotRange->{{0, 401}, {0, 87}}]], "ExerciseOutput",
         ImageSize->{405, 87},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "2f3e1171-77ec-4077-bc84-d830d39c10d9"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJzt3dtzE9cdB/Bt+9LH/gudGIZhEqWhmZChlMTttA23yHfjYGMMxtjgGt8w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              "], {{0, 87}, {401,
               0}}, {0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {401, 87}, 
            PlotRange -> {{0, 401}, {0, 87}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"9126b460-cc65-4a3b-80f6-558090123a06"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["22.9"], StandardForm],
   ImageSizeCache->{140., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"28ae3cb1-8fee-45c0-a368-d6ec8b401a4b"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"129b7de7-fa95-4a88-9442-53a8cecd630a"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"f5e2c203-d16e-4e03-9655-165d76a1b793"],

Cell[TextData[{
 "Make a graph of the 2 nearest neighbors of each color in ",
 Cell[BoxData[
  RowBox[{
   StyleBox["Table",
    FontFamily->"Source Sans Pro"], "[", 
   RowBox[{
    RowBox[{
     StyleBox["Hue",
      FontFamily->"Source Sans Pro"], "[", "h", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"h", ",", "0", ",", "1", ",", ".05"}], "}"}]}], "]"}]], 
  "InlineCode",ExpressionUUID->"f58a084c-3574-4f60-826b-f8e4ab81ba3b"],
 "."
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "22.10", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 22}, {"ExerciseNumber", 10}, {
   "WebOnly", 0}},ExpressionUUID->"31613e48-22e5-490a-806f-45e37d1f553d"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"dfc02f4e-b64e-4675-be60-d6224ba50cd5"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJzt3elbm1eaJnBm5st8nP7YH6f/gZmuSqqSqzpJT189tSRVqaSWlFML7eru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            "], {{0, 
            335}, {360, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{360, 335},
          PlotRange->{{0, 360}, {0, 335}}]], "ExerciseOutput",
         ImageSize->{364, 335},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "bd702e08-63a6-4f8d-a4cc-d04542c5f685"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJzt3elbm1eaJnBm5st8nP7YH6f/gZmuSqqSqzpJT189tSRVqaSWlFML7eru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              "], {{
              0, 335}, {360, 0}}, {0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {360, 335}, 
            PlotRange -> {{0, 360}, {0, 335}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"33fb19b9-1109-4df7-b057-3e1f71a8e607"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["22.10"], StandardForm],
   ImageSizeCache->{146., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"b4aa7d08-0b6a-43e7-b8c7-45813045ee16"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"9e9854eb-ac7d-4b26-9ed4-c447f3c2b253"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"a09027bb-a856-4061-af3d-c48dcb855532"],

Cell["\<\
Generate a list of 100 random numbers from 0 to 100, and make a graph of the \
2 nearest neighbors of each one.\
\>", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "22.11", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 TaggingRules->{"MultipleSolutions" -> "True"},
 CounterAssignments->{{"SectionNumber", 22}, {"ExerciseNumber", 11}, {
   "WebOnly", 0}},ExpressionUUID->"26f1a9d8-e706-4098-a424-2dd9a83dd12c"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{
    "SAMPLE", " ", "EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"b75e83b6-6422-4f6b-8f1b-37e5bbd21c6b"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJzt3ftfU2e+L/B19vnl/Hj+hHPOL/v12ue188P0dHpVm2prp3Z2Zs+M05kx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            "], {{0, 258}, {838, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{838, 258},
          PlotRange->{{0, 838}, {0, 258}}]], "ExerciseOutput",
         ImageSize->{842, 258},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "f08ed223-5e30-4219-b5ac-4a2ea6c38f99"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJzt3ftfU2e+L/B19vnl/Hj+hHPOL/v12ue188P0dHpVm2prp3Z2Zs+M05kx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              "], {{0, 258}, {838, 0}}, {0, 255}, ColorFunction -> 
              RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {838, 258}, 
            PlotRange -> {{0, 838}, {0, 258}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"168f4c7b-6245-439b-82d3-b15d8b7347de"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["22.11"], StandardForm],
   ImageSizeCache->{146., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"a5605ebd-0f1d-49f0-b9cc-645b3a2d95d4"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"081e55f7-5c41-4385-bc1a-b6fcbd96f341"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"e3c3ad09-72ce-4fa4-a3d3-bd3425397351"],

Cell["Collect the flags of Asia into clusters of similar flags.", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "22.12", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 22}, {"ExerciseNumber", 12}, {
   "WebOnly", 0}},ExpressionUUID->"dcd9ae84-b72c-4a6b-a2ee-a12d87585112"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"69f1d7df-b046-45db-afe1-5839c848267f"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJzsnQdcE+cbx6OttbtV++/Qtra1bkURJGwICXvJUkT2EFBAQFAQVBQnuEXF
ATgAN2HvJOyhggiIoLj3QsUtYv8PnE0RlBEgd+Dz/fw+fC6Xu8tdr37vyZv3
3vvTeo7+zL40Gm3u5/BH32o+w93dytvge3hh5DLX0d7FzlbdxcPO3s5d0voT
mKndn0Z70odGa5j+B0EQBEEQyrB+iZOu2B8kJmymIolZv93S74QfiSH7/CMI
0jsBu9JIhUdqLLRotO1khuzzjyBI7wTdjm5HEKT3gW5HtyMI0vtAt6PbEQTp
faDb0e0IgvQ+0O3odgRBeh/odnQ7giC9D3Q7uh1BkN4Huh3djiCdJyts3zLv
BX4ISbQ8I+h2qrk94/pDv+OXMWSl+y3YO9mvpp/5/TD7zwd93acvuUr5OGl5
RtDtVHM76IUWnI0hK91vwd4JuL14wAgIGp4UWp4RdDu6HYNu7zx8t6PhSaHl
GUG3o9sx6PbO08ztaHgh0/KMoNvR7Rh0e+d5r9vR8EKj5RlBt6PbMej2ztOK
29HwQqDlGUG3o9sx6PbO06bb0fDdSsszgm5Ht2PQ7Z2nnW5Hw3cTLc8Iuh3d
jkG3d54OuR0N3+W0PCPodnQ7Bt3eeQRwOxq+C2l5RtDt6HYMur3zCOx2NHyX
0PKMoNvR7Rh0e+fppNvR8J2k5RlBt6PbMej2ztMlbkfDC0zLM9JD3Z7x6aeQ
ghEjjo0fj27HoNtJpwvdjoYXgJZnpAe5PXvgwGMTJxbLy1fPm3fO1fUEnX5C
WvrSypXZgwZlffdd3tChFaamYHt0OwbdLny63O1o+A7R8oz0CLfn/O9/eb/+
WkSng70vr1pVJCUFhj+lqXlh0aISVdX8P//M+eGHYyIihaNGVXt6FjMYFRYW
RdLS6HYMul1odJPb0fDtpOUZ6QFu79s35+efz1hbZ/Trd2X9enD4cVFRUPrp
GTMuLF58QkKiREUl/6+/ihUUygwMzrq4FI4dW6qlVaavDwvkDhmCbseg27uE
utqaO9ev36mte+/MbnU7Gr5NWp4virs984svTmlp5Q4eXPD338WKinl//nlc
TOyMldVpE5OCESNA+OVGRuDws87O5729T4iLn50zB/QOq+T89FPe0KHnfX3h
KpD9/ffodgy6vRPUxizVffsvdmnBe2cKwe1o+FZoec6o7PbMr746qaRUMHJk
hbl5hZlZpb09VOZQvef9+mvWt98WjhmTPWBAkZQUSD570KDMr7/O+v77CguL
ClNTKN2LpKVL1NVB+LAuLI9ux6DbBeb5mTD4p6rrHVZQeuZSzfP3zhSa29Hw
76XlWaOm2zO+7Z/5w1fcvn3y//67ysGhytHxv/bzvn2hIL+6efPFpUuhXIdc
9PO7uW8f1PMZn30GC+T/+ecJOv2cu/tJFZUztralWlrcvrTsPwei2zHodsGo
jjCF0vxOqzOF7HY0fDNanjVqur2QNeGkkfJxVcmcIUNOGxufEBdvuczxiRPL
9PRgIvfnn6GGh3r+nZr/m29KdXWhhocLRLmzcYmlJlws0O0YdLsAlAYzaCLB
ta3OPKw1TfhuJ5IzcITvbyPFR40e8xHT8qxRze1cGi17xKDKZc5nljue9rLO
k/i7Yr4d99Pmi5WoqBTLyhaMGFEkKQklepGMTEtvn1CmH5OZWGKmVrXSpXL5
nJNWGtxvPqG+21emlf296DCGrHS1F3sD7XF7nr07WW4nUjJ00o2Vm+oePhL2
fx2qQjW3Z//5Y7Gl+oVg/6qA2cXWamcWO1atds0aMuDtAv0/yfn9p7dXgb40
3refHNcU537y73WhX5/cYb/wN3VyhkqFt0XVSteqdW6lbobVm3zzpIc3rEVt
t7PtAi7RxHtcLn8pc+VH5ctfyJC+J52M8P8NUp8e4XY0fDMo5Xaoz4ttlS/u
WFbiolPuNeO0l8XpRdYlFurcfxc442lz/3ga94s+IPmqFc5PLp979fj+zdT9
BVJj4d3SmfoPTmVlDPjybbPM919VBc0tsdcqnTu91MOgeuvCMg/jfMnhXHR7
1+WGhHntlkN1l27w9//V+auPNkRen2hC+r6h27uKHuR2NDwf6rgdlHtcU7Jk
pnr1lsWlrgaVS2aVeZucXe/J++JT/jL50iOKTOQ5n9DKbafer+I+uXmm/nVd
TRX3Bjccrgu5Yn8Wz1Dm9u/LX75YX77c1+zsGvfyhWanXHTPbfQqnTWF0x/d
3gW58j/WkyPp/N1+8+bNi4Ky2u1HH64Ihb/P80tr9yVc/l6R9P1Et3eeHud2
NPw/VHJ77sghpU4GReZKFf52lYvtS62mVK6YfYIp0bSwr17h/ez2BW4/2tlV
HverePWvX8Eh1F4pfng+j/dVv8r5js8fXM8c8FXTLwLn1nhULp9VIDXy7BqP
0/62pxz1CtTGots7metjjPi1Oli9dlf01d80my0Dcx4sC7n6lw7pe4tu7yQ9
1O0fueGp4/Z8ieGl9nrHNCSKDZQK1cdVLnI4ri/BfbfR5sLqxS9r74HbS+0M
ntw6++rZw9evnj+5XXUnKw40XuXlXPficebAr99pwB/3c4mt5klz5XypYZVL
HYt0FY9PlUa3dyZXflTmi73+ybPbOu6tLHyL6XjpOwXS9xnd3hlKg3Xf53bd
HuH2j9bwFHE7ODxPYtjJGap5YsNyhg4+v3nR1dgdhdoTmv3Ses5vbu35UnB7
5WyHWzEHGxJ94CY78sr2DbmDB59xs31242LTur3B7cP+V+Yz9d7J1IJJo4s0
ZE5OVckRHZI56Csuul3QPGXziF2Fiv22bmtiJ3JddAb8vfyFzA0Jc9J3Ht3e
cepiZtJEVhe0PrMzbj8jp4OG73Io4vZ82ZFVvrPyJP7KH/v33bi4swHzyjyn
F5soN2i/P43bp2GZMj29qxs2QO4lJbU8kFf371/bsgXevejvn9G/f8OKnzWs
mPXzdyet1CtXOZ1xtrkVEZFL/6PYSOWkmRrnS3S7ILkhZcXf1dqd7DaXv9xY
tF8don5nqlftruimM6mZbvzH1kOpyRKh0TYW1bY+s8NuHziSmCgXZT5ISHs7
c9AoNHxXQRG3l87WL59vdm7NgtfPnsFeVa/1PmnCOsaY2KB09+k5on/ARNY3
35wP8Lu0OeBSUODlLWsubwm8uGnZhU1LLgWturx1LT/FLCVYmEOjnVnukPnj
l9xPYeMGJQ7ajytK39TX15YVlzjrnds4L2/SX+h2AVK7/Sixn1C0t2xjb5lb
rFnPUgtuabk+jcmof/j4+tiptTuiHvjvIv1A0O3toeZSwVIGjWYaUdvWTAHq
9rt7Dt5YsfH2ltD65y/Om86qiUo4p2cpnAL+YzA8FdwOlXm5l3mp57QSK60b
h/a8fvHkUcmJPNm/uY2d2Mtdp58NmMtpLN1LXQyqd/qc0JYtkB91QkfymJJI
Pn1Eocq4XPrvpTN1T83UOrttbtaQ/zX8Mjv298tHN2f/8UPD9LBfSm304WCf
3DxbKD7u9EKrSxFrciYORrcLkLrrb+8yf1FQ1s5VXhwrb3qAb168vPKzKukH
gm5vD6sb/o2KcGqazqt530xB3F4+Uan+6TP+Fu4fjhWa2D8Gw1PB7ZBTTkan
XPVLnQ0rfOxqTuXCjpWoqHA+pRXZKLx4dLv2QkmhomhDe/vmefdOJxVqiJ2Y
Ruf2a9LHRmRIkbF8xXLb2yeP5o0YyvmEdil09etXLy6zN2T/3aD6h3l5r57W
3IgKzZr4S9m86Rd2+Gf+8R26vaO5/L0ifz+hgG/PKleHqD+JTG56gK8qLtwQ
NyP9WNDt7eF5TXWwKY3G2HinrZkCuL16mt2rW/9to4adWDpcUvh6h5SNV3xx
+arQ/qsKByq4PWvYoJPOWqdcDUrdplaumH1+40L4vn9p5cqc0YMzf//u3Nb5
j86Xls81434KlwDds1vdC+VFMgZ8wW38BZav90LWhBJbjbNb3bKH/K9Aauzl
vWsfnT153EjymOyEjM8/hyO9y4mr8LYq85x+ao7e2bXuuaxh6PaO5upvmvz9
fLgitI3lP5F4sCj4TV1dy2MEnkZnXPmBSfoRodvb5nmRLo22uqCm9ZkddfsF
a9farHy+UetfvnxaXHr/YHTpaFms2wWh7oy3CI2xNOn5vzOo4HZOf1qxu+qp
+UZlXiblPsbl7sa3Dx+u9vDIVxoBpTtvYP+s8T9lfPfFcQWxoimKlb6zi3UV
Lm5aeWnjivOrffnV+3GFScXGKpW+Tpk/fnNCWQpK92O6Yhwo6cf/xv2kT92j
R6cstEvmTCn1MSiZpVO2zCJfczQl3N7ijFDZ7YLU7b9qvKduFzMl/Vg+6PYW
Z+Sjpy7Jtemw7e+fKVg/mQs2rlDIPa+++OrmbSHX6r3H6gTPS+G7FE1kI/9H
ECq4nffNZ5dCAipX25e5mVStdyufZ1akqVCsp3gSXL3aqVBhHKdxrLDj8pOK
Z6icXeF5Qp/x+Mbpl7W3a6+VXjqwrkCiwdLZQ384OUO9aoXHMVVJ4tbUvEl/
HTMQvxC6nPNVn6olbkXGDPhqUDJHv8LPptJ/VoWrJSXc3uKMUNntlwRrby9s
3t5+9RdV0g/kg25vcUaQxq7sG2tanSmY268vXXvFYwlo9unJspO/jEerd4bq
w6ZN7ziggts5fWkXN694fuvy1bCt5zbOqwp0q/CxO64kXjyN8bruZbn7DKLt
hfsJ7WL4yhvH9580VX98vex+JefJzTMPzudVhy7kfv1Jvviw6q2LbhyPPM56
OyAwZ+CnD88V3c/ncL6lnVvvWeZiXLnO6XzAgppczosHN3NHDaGE21ucEYq7
vcP9ZJQcnqUX3tJ2exr9bz+Z7UcfLgsh/UA+6PYWZwTpvvtSyyexiIlTf0mc
GiqGVheY6w3fo2gRpf9dgangdu5nfYqnM2+lHXp2//Kb+vr613X1r189ri7N
Hf1HhZvlMVlRfqN6qZPRZfaG4qms2qunaq+XPblxuu7F4/uV3LI503NFfi93
NbkUtS5z4Df8gSKr13hl/TaoeuX816+ewzZh43Uvnz66fKrC2yZvEiXa21ue
EYq7/Z3+7f/2V28l//VvN5z3OKQH9G9veUaQHj3mQK+3OkFd7fXq6++0I1LB
7ZAChkiZv9mZ1fZlLiY3IkNqq0pev3x2actq4q4lfi4GLX9UXlhipltz9lih
quj5nYvvZsU8vl5+50Rszl+Dzwf6Pio/VjBxZNNVcv8a8vJJzfMHt+5mJJxf
vbDU3ahypVP5EkuinYd0t7c8IxR3+yVB70u99Ll0j7gvteUZQXq023u91T8E
RdzO+YJWtsT09EKzMrfpnM9oxTOVy+bPqN68kPd9/6YDRZ52sTgX6JX587eF
SqL3C9KO68lcORhUZMK6U5pUPte01Nrw/PpFOcN/a+r2Emvt6g0+p1z1ssb8
mDPhjzPL7CvXORdoi+B4MgKn+Xgyreodx5PpBfRQt3+0ViegiNsbRm6fo3E2
yKN8sWXmyO9O2qmdDrQp9zIpYPw3pEzObz8+v3mp/vWrR6eL7mUn5I374/x6
n1I7/arFLjfidudNHHY7Pbq+7uUZL3t+30huX1qZ5/QzKxxL/YzzVcYWzVAo
X2RaudYpe9Jv6PbOBMeB/KjocW7/yK1OQBG3Q45NET+7dd5pH4sSW51iG+WK
gNmnPI1KHHSJJyVlffttudX0c4s9iZz1mXN8sniJkXqpkXYRQ/6M28yT+upn
XB0r3WZVzrHPHzni7eVg1C8lcwyqNrsVz1Q7pjz5/Gafk85qp5dbZf7wLbq9
k8Hx2z8eijYyaIzmbm82kyJuR6vzoY7buV/0K1tgXGTOqFozt8RJ+7SPVfli
0/IFpsc0JhWOGvW0qqr9B/Wmvv68l1fmD1+d9jYtdmCVzjc6vci22E7tjK99
5UrHfPn/GuTR7Z0MPnfpY6D68EwazfVSqzNJdztavRnUcXtDfvmifKllodak
s6s8ThgrnNCRKvczq97oc3bh3GPiE3IG/5I7ePB/+fXXvD/+yB82LO/339+Z
P3hwzq+/lFlOq17lc3adZ9n8qQWK449pTD493+z0IpsCg4lNPxHd3lXB56X2
YuqqI+CfqsjM1UmcrNJLte+duV5dlSyrZ/04cpb8hIEz6Z85SX20aXnWKOV2
zqd9Ts2ZUrXapchE8cqODS8f3SO6RNZeLL6etqdQTuS/hfv0KdXWPr9gwYVF
i05ISBwbN+6/+r9f33Nr5t45nvj03kU4wPq6lw+L8ypmW5Z6Tj29yDyPPpzi
btdJiOgX6YohK93pyJ5LXVGEtwjxL/a/e1HfmblShSF8q2f+NNJeWfTruTK0
BXIfeVqeM0q5nduHdtrV7NWT+yDkfxqbVp5ePV/uanFmmX2Jx5QCRoPAi6Sk
iqQbHpyUPWBA9sCBWd99lz98eEOt/uOPp9TU4CXnM1qZu8kpH4NT9voNo0q+
et64qdevXz6rKc7MHjyI4m5XTN9Hi7LDkJXu82PPp+55be3z53XvnSlkt6PV
e5bbCb2XmGlfjQw6v2FRha8t78/vuX99XTZ3epGNQuWSWfmyI49NmHDWyalI
Tu7mnj13oqLO2NicdXG5HhxcaWtbYWqa+fNXx3UkyheaVfjb5jL+5v7Q/7iW
dNUqtythG85vXpz96/+afRy6HYNu7xKE5na0eg91O6H3IkOFM/6OJx00S72m
lvkYl/ual3pMOzVbqzLQPaN//5PKyiUqKgWjRuX9/ntGv36Fo0fn/vZbuZER
aL98lmnZEtvSebCw/mkfs4pldifdtY4ZTK5cOit78MCWn4Vux6DbuwQhuB2t
3tPd3tjdvU+RnsLZTZ5nVs4qcdEum2dcuWz2tegdLx7ceHLlzJVdm8rMDY5L
0osZjGMiIsfFxE7qKFd6Od84GPbs+oXaiyXl3mYXti0pX2Bc7KLSMPiYl3nu
8MHv/SB0Owbd3iV0q9vR6r3G7Q35tn+xjerp+VZlXiaVfrMvH1j/+sWT18+e
PczNfXbhQu2JEw9PFrx4eON5zbXb8UefVJ55Wll5Zd26SlvbZ9XVD88UVm9d
XO41A6xe5jEjT/rvD30Kuh2Dbu8SusntaPVe6PaGZ+31LTWdci0y+A4v5tXj
e/eSkmqLil7V1Jx1cnp569b9tLT6urrnly/DxPXt2wtHj77o51c9fz64/U19
/aNzx64f3nU+wDdv5FDuhz8C3Y5Bt3cJXe52tHovdjuRjH79boWHv6y9/+zm
+WshW+/ERL24ceNWRMTNffugUL++c+fVjRsfZGfDzDf1r6GSf/Hg+otHN19c
u1YsK9vmxtHtGHR7l9CFbkerfyRuJ5L1zTdnbGzO+/hUuc2udLOvrSy+unPj
1ZCga2Fbr+7aVHM8E15WzZ11aflyUP2x8eN5ffu2Z7Podgy6vUvoErej1T9C
t0NOTJ58gk4vlpM7yWSWGxk1fQtkXqanV6qrCws0ewvdjkG3C4FOuh2t/jG7
vTuCbseg27sEgd2OVke3o9sx6HbKIoDb0erodnQ7Bt1OcTrkdrQ6uh3djkG3
9wja6Xa0Orod3Y5Bt/cg2nQ7Wh3djm4n3W8fc7rfgr2TVtyOVke3o9v/QbeT
ne63YO/kvW5Hq6Pb0e180O3o9p5IM7ej1dHt6PZmoNvR7T0RvtvR6uh2dDu6
nYLpfgv2TsDtaHV0O7od3U7ZdL8FEUQYoNup5nYEQZDOg25HtyMI0vtAt6Pb
EQTpfaDb0e0IgvQ+0O3odgRBeh/odnQ7giC9D3Q7uh1BkN4Huh3djiBI7wPd
jm5HEKT3gW5HtyMI0vtAt6PbEQRBEARBEARBEARBEARBEARBEARBEARBEARB
EARBEARBEARBEARBEARBEARBEARBEARBEARBEARBEARBEARBEARBEARBEARB
EARBEARBEARBEARBEARBEARBEARByOLc7Rt+8ZEYshJxLIPs/wUQBOmFJJaf
oM3SwZAV9SA/sv8XQBCkF4JuR7cjCNL7QLej2xEE6X2g29HtCIL0PtDt6HYE
QXof6Haqub3y/EPTtXt0165rM1PWru/mbOhQ9DqcjR2K/tpN3ZzNEN/w2GZn
5Nzj535nrmHISsSVe8LSYa8C3U41tyfybtKGHfpSw/9nX91fA5QwQs5YnznN
z8itBzT2MQxZUc+tEpYOexXodiq6/c+jDUHDo9sx6HZBQbdT1+1o+HZn80G5
qdsVusjtLs3PCLod3d4DQbdT3e1o+HYkP0nmda7UonD57nZ7X3Z+QKr1bzFx
aTy5eK5SDFd5UHSaT4oz6QLsxUG3Cwa6vWe4HQ3favSCFf7Jk4KEHJH9LYDR
fW6H7EnX00rYEJJu+DWby+XJWCf5OSb7kC7AXhx0u2Cg23uS29HwH05mggyh
99gY2T8DBdd7m26Hij0wzSqOy2TEbQtKM0niKvqn2pMuwF4cdLtgUNntn9tr
S87QMNNTX6qqGsRU2a2gvF9eeSdDeT1LxVNTVddIfaSFJuk7SYLb0fDvi1OY
POF2CDdBZpigem/T7dVZwz1T3PMzxAsyxA5xNBamOIHtSRdgLw66XTAo6PZf
rbXcNVWTpVg1YxlPxrSRCxOUwPn6hur97bVJ33Ohuh0N/27kNim+yZXi652X
IPOXQHpv3e192IUnMkSXp870SHGvzvzbPMl/SapjAleJdAH24qDbBYNSbmca
a8RJsx635fP35vp4xhplFbgukH4UQnU7Gr5Jth6S47sdkhgrI0Dbe5t1++50
vUtZf0LFrhC/PZ0ney3rd9dkT9IF2IuDbhcMirhdxkQji84UQOnN8mAsYzNT
ZZBtjzF817gdDd+Y0WsZz3Okmuo9+JBcl7t9P0crON04haewL103NN0AinZ0
O7qdgpDu9gF22jsYyp23etNcFWFYTFEj3dvCdjsaPkAp9IhsU7dDLHd1rN/7
WB/n5mfkXbefyhy/Ic1sfZo5VO/+qfZ+qY4ZPGnSBdiLg24XDHLdLjFD84yo
UteKnZ9weeVvZ1K9Eb7r3f5xGx5K92tc6aZuv8SV7lDLTJtur8gcvTPd6AhH
PY7LDEozieWywtL1SRdgLw66XTBIdPsMPfWH7fi1tDMpEVMaakXp9pnucvtH
bHjlLYo1me+U7mpbFLvQ7Xs5U6yT/Hg86aExMYc4GpvSTJ2SvUgXYC8Oul0w
yHK7q5Zqt1qdn+qJSuPMqdtVsnvd3rsM/0cgIyJKdushObOdCqPWtlaK62xT
aOp2l7AO3K/apttD0g3tkhZ5pLj7pTrAtGnSsjnJ80gXYHsyIS4S/jLjt33J
zuS/pH7Q7YJBitsddNSEI3YiFyYo/WVJ0epdGG7vRYbfefhtc/rrXKnSVGl4
abpD4Y/39XV8mv2f29fs78AvqmN9W3N7X3a+dHxoFk9yctyeDJ7UuNgD4Rxd
qfhQ0gXYSmAnITCRxFX8hJ2/Ns1SNSFoTOzBDWlmMHN64grS9xDd3h0I3+16
huqC9XLsTMomKf1Ayc4zwnN7bzH8rsPNfy2tyZTaflhOfMN/hh8awHjdpK87
VPtd5XZChn6pjjFc5aKMCatSbQ5xNP6OjSJdgO8NPW73F+ysQdFpZzJHQ61+
NesPo8TVeRmTF6fO2pVuBJkYFwEvYcnhsUeHxCSQvsPo9i5EyG4fbql1a7yw
xU4kWoZFc6TcT6vd5Pb+I9m92PCrI+Wa3qZE5HmOVOB+OWK0AelNik3f4ibI
dJXb+7ALs3n0gdFp30TzeDwpmANlPEiSdAE2Sx92AfyF4rwgQ3xAdPqt7F/n
p7huSzeekrDWJmkxfNGAq5JF0lIuT2ZPuh58BynOmACHxl+RUkG3C4Yw3f6p
g3b+5C7oxC5wXLVUSZe5ENz+u0yi75ry3l3D24Uo1GY11zvkRLKM6HqGfvA7
7e1n06W7yu1K8cERHJ04LtMh2ed4hqhjss8RjnoWTxL8SboDm0Y2fhfIvB87
93jGpP0cLfn4nb/HxMJ8qOHHx+4fEXuEaHKHC9NfMVH3sn9Zljrzp5jkDWlm
VDsQdLvACNPt7ppC+v30Q7k7jkG1bjNd6/YZrsfmrSzdFn7+0rWnBo75q7ZV
fvp3VG81vMRGxdxEmZZ6r8mUusF7Z86zbKlf290NcoyvU/Mz0sTtoHS7pEXW
SX6pPPmyzLGBaVbmSf7B6cYT4yJIdyARfuEdy2WVZo4Tjds3Nvbg99GcpakO
VZkj3+R+TeR1zjeZPCko3WF5VvxWRnxwTfZPs5O9adQr3dHtgiE0tw+x1roz
jkyxEzkkxyLd593n9gETYu8/eMnflJXnCSG3ww8NYIxbxxjdaieWLg3DMVT+
8rsd2t8bmU3t7QbZutuHxsSezJgQztEtzBBjxm89lTkeyvgMnjRUyKQ7kEh/
ds7W9OnzUtzGx0buSJ/6BTtLN2Hd/eyf+VZvluKMCX/GRIvERa5Ls4BV1qeZ
O1OsSye6XTCE5vZ1LBXSxU5kkimFukR2rdunuxQ+ePSf2zeEnvu89Yb3LjK8
zjaFsCOyZ9Ol6/5tBn+aLVWYJLMy8p2fOLspfwYyVkXKPctuze2zQtvbDbJ1
t3/Ozg7n6BTwxAJSrQZFp+znaOVniPulOpIuwKYZEJ1eljmuIEMcpuErRn3O
+63Oz93swaNiDw+MTqvL+TY03YBoeKdO0O2CIRy3/2Sjdb+bb1Nqfw7IKZOu
9O5w+69SiX4bKjIK7hDbuXbz2Za91arm2R3eVEcMr7pFERzeilRf5UjtOSo7
dl23G15hs+IFzgcL+PjY9v6c2rrbLZOWLEhxAROm8uQzeZL+qfajYw/FcJVh
DukOhPwSkwjlN+yhQvz2YbFsetzulznftS52ImczR3zJzpwYF2GQGLA8daZ3
yhzqfBNBtwuGcNzuSXZLe9PUjmEMocxwkV3+W6qlx/Hrt56lZd+OS7/Rme20
x/Cee+Rf5rRWLfNzmSvNCurAzaGCBa4gGQnvv9DU50p57ZUfs5ahuVVxWYSc
bcj7e8W36fZpias2ppmVZo6L4OiUZo4N5+hCeczmqgxt/KWSCvk9JjaLJ3ki
QxSmYd/aI3YiC1OcfopJhmvB5rQZ/dk5pB8Iur2TCMftJ8W6a9AYwTJXkyod
Zrrc7Tq2eUNlEvsNj3JafLJTbm/L8IH75dpjdX6eZEtpbe12vf8WwEiOa+17
xO2Mhq8SMFGRJs3Y/J79ad3tUNzmZkj8ERPzbTQXFApzpOJDk7mKpAsQ8hk7
RzNho0niCrgAfc3mScaFtV/skNvZQ/qwC+DQLJKWwhZk4kNIPyJ0e2cQgtvH
m2mSLvNmyZNgkm71bnJ7t6SF4e1CFFr2MH9vYLGZIQ2t8VmJMrcypMS6v/nd
dKdCK/uTkygDVic6zyx+37OzW3c7xDfFyTzJf1HK7IIMMcukJYFpVsoJW0gX
IBHiPtkXOd9PigtfnjqzQ26HwOVgforrvexf/FPtB0WnkX446PbOIAS3u2gL
dYSB9uTxGAZFxnjvGW5/1/Ci6xnv7VveMlBCu+5+68+QxtF3O3QbkWDx3CPf
5o6dTJE23P7+sX9bd3tfdj5UthyerGFiANTtUNym8+Soo8E+7MLRsYcU4rfD
9CGORkfdDtesz9nZKglBP8ckkX4s6PZOIgS3H5ZjkS7zltE1Uidd7D3M7f8a
fttGY8KQuw7L1rVavTftneK2+61yPyTVrgo3vrU2Gbgq8RJkpDZ+sHVojO/s
5mfk3bo9ON14ZaqtdZLfUY7qwhQnl+T5C1JcSBcg5KeY5C1pJneyBz/PGdCf
nZPKk++o2+FYVBOCiJ9W3ZI9KfJzKrpdMITg9spuG6G9M/FRp0STO7lu7/Pn
0a/HRndolS9HHnjMfWtptS2KfuHvL5Jf50r57nunxYO/ZEK7u6wIENil9+4P
XIPS4mWM2nFZadPtO9KnTklYG89lfhedDgU8ONAuaRFZ3ms5liN8s5CP2wF/
wzm6HXW7ceLKgdFpYrF7m23zU3be+Nj96PaeRXe7/Qt7beGPDNae7FGgRE9I
ct2uYpY9e1HHfnKdYriKL8y7GVLj1zH8I+QKk2Su/nsDUX2uFCdeRrXFkOnT
dygQyzzLlhLsKdXtyf6od0YSe57T0C4EXxnGtbsTZptuz82QALEf4aivTbXY
mGZWkimyLs2CFOl9ws6/l/0LaJwosOGvQ7LPhaxhYOnJcXvmpbh11O1jYg/6
pDjDRCZPihW/lfgU+AqgFB8cw1VGt/csutvtIy0o90MqkQw6JX5OJcvt3gFl
AduruHl3yiofLggsX7PjbDtXXO3t0rR9Q3T9W2eOWcuwD1WYsUNh/AcsKr/5
v0dmdFOHmdmh8vzhH0+lSrvulh+xpsMXkTbdXpU5cnay9wGOVnXm3xvSzFyS
55P4TL372T+rJ2yK4zJpjY3t30Vzf4uJGxe7H+r5EbFHOiR2OC7YiGJ88PCY
I4NjEogBZ+AvlyezItVuJ3njoaHbBaO73S5uSlG3F4l/1G7/RSLhydM64hPr
699M0uK0c8VD6y34bm//jfxr9ss1bZlv/12i7cyk9YzE2LfN7GWp0qY7BG/S
b9Pt6Ty5RSmzweonMkTdkj03p81Yn2YufOPB51omLTnE0QhMs3qQ/dOn7Dxi
vmbCxrvZg4syJsL0YY56h35I/SkmuS7n2+MZk4bFsomtqSYEcXiysDXjxJVH
uWqwcXR7T6G73c4w1iBd4+/N2YlKpIudLLd/PpINhToonf+h28LPfzm6XQ3v
CVtNCIWeSWvv4IoL9jZvk/fY02Vu/z2AMX+v/MPGfjs3eFJzGrrldKrBp023
70vXPZM5KjRdf2jM0XiuUlXmCI9kN+EbjxEf/CRnkGuyZ2XmqJrsnzQSNtEa
70u1TvKTi98pFReil7jm95jYO9mD2yP2VJ58X3YefAcZFXtILWGzWZI/0c4T
km5YmCF2L/uX+SmuV7L++IKdhW7vKXS32xWmU9TtZ0Sp4fZNTt4iNMbSpOf8
M/IBt/80Ob6r3D5MIdl+QTEn9zbxicdP1cxdfmqCenp71j24zhIsGhcrK7aB
sTJSbuE+eb9w+VYGjbHcpfCoRYdJhy6q22fsUDjT2Fn9RY7U5oNywzveAvMe
ty8waX5GqFe3f87OtkhauivdqDhjAjG6Y3xjswyRCXGRUMmzuSq0xlF8wfyt
ix0O5PtoznfR3OtZv0PR/nV0BrGdgdFpcPmABeK4zKc5A6F0hw8lwe1ZSc3O
CNIeutvtk6jaJnOMIm0y6x1NaTSayMZa/hl51+19GgMTgTuq5KZmdGH1vmRj
RWbh3XjOja37zrd/reXzXcGl2YkyBU2GkbnIkY6OkWXHyBoGKzTzfHX6e8Z4
Ue9ce/sfgQznMPmSFOmazIZnKs0OlRfpuvFqxngZNz8jLdrbZyUvIL29PZKj
vSrV5nTmmBc53xODxtDjdsN8KK29U+ZIxoXBSyjpB0WnjYg9kpcx+b1Wf53z
DTFWpHrCJjD8oOgU/cQ1NkmLiY8ISLUmFoPtw2LZPLpBYiAJbufFNTsjSHvo
brcPs9QiXePvTZokJQb7VQ/yqz5sShMJ/pDbIYcSrgbtqb57/wUv/86BuKtd
M5jAn0c1rXM/H8nuNzxKzz6/A2vpBbR5Z9DWQ/89nzS/xUhiT7Klmo7l8lsA
Y2aIgl6wgsRGxQ+N8fJr42CPipsVXcLk4SLyIEvqfqbUhgNyI7thMOExvrOa
n5EP9pOxJLGfDAgZZJvAVYLSfWhMLHyVADl/ws4n3oWJU5njQci6CWumJa6C
ORoJm/ak61VnDYcKHCp52G1Q95jYg/DWklRHmbhd+RnixBNUiYyLPQBXjbvZ
gx9l/68iczQsPz/FVfiHSWtsk2l2RpD20N1u/9RB+yFlRoBsmh0MSvSBVJol
CSVJRGnNf2ekhdtljTL47165/rRjw/Z2dfoPP/gwvbWb+v959zlHl1oMrh4V
3fzppWpbFDcdlDueLPM8p+HJGuc50sUp0nmJMpkJMjmJMjAN3wuIDjC3MqSO
RMva7FLovl6UI6ZPaH5G3te/PY4C/dt/iE7l8mSg9ibK6RWpdqBr4i3p+FBI
H3bB5aw/16RZuiZ7KsQ3dHrnrwtv9WEXOiV7sRpHod+VbgRzLJKWwjbh3a+i
M0H1pknLYJksnmR9ztdeKXM+I2kAMaV1Fs3OCNIehHDvUgnFBgoj4kGN4cLU
1s6tvv5OO2Izt49RTj1+6r//q+vr3wTuqGrjcajdnIAFLq27vfpft8tses+d
RBprNFopzpWCFG1DFHz2ya/dLxd0UA6K88D9cnP3yE/brjB5Q7cPNQYZPc+i
+Rmh6n2pMxKXQymezpP7MTqZ0HUyV9Eh2Ye/gGL89i1pJn3Y+Y9zfrBMWnI8
YxLs7db06bAifPVYnjpzP0frKFcNfJ7Gk+OP/diPnQvfSogWnl9j4g9yNOHb
QV7GZLIe+a2Wlt3sjCDtQQhuD1NUJt3kLcM01iBd7LR29JMZzkg2nFVwquIh
8e6uAxd1bPP+JxbXIRuLqKd1odsHjgu/l8Joxe1QaROe3HKo+ViRRzaYU/wp
fmN8ZzU/IxQeT0YtYfOZzNG+KU7EywHR6eWZY6FKJ17CrhJ+BpNDBQ41POww
aNwjxX1pqsPOdKP/RafAsdAa+7HDNEx8HZ0BFwio2IktgPYvZg2DyMfvJOsY
sZ+MYAjB7ZZTKDdW2IOxjC/ttUkXe3vcTiQ95/aSjRV5RffM3Y8LYOOI6Cvt
78HenqjqrHmd88EHYUTHvG112XP0nbtEL0SrDRof/nYjVDX86FbdTqPeOJAm
iSsOcTTgqwTxcmB0WjhHNyTd8JtoHjHnz5jogY1Xnx3pU+Ev7DnU5GDyZakz
4eXkuD38TU2IizyWMQnmE49MhQuZU7JXWLo+oX10e89CCG4fakW5n1OTpCjx
Q2r73S7f2EPmqzHRk3W5HZKwpcfx1Kxbz56/vnDlSVz6jT/lkrpK7872Ph8a
5rc8VXpJeMPzL5oO2wWl/nj54ObboZ7hW3c7Bcdv/z6a45zsVZIpQlTpRL6L
5i5McbJO8uPf0wQhmm7Gxh4kGt6Jl0SgPgfnQwb++x0E9A6Sr8wcFZBqjW7v
iQjn2RwcSSbpPm8aqylqpFu9Q27vTPw3n4HN1tXVD5VJ7NotG0xd+YTb9oC6
DfeKHtT+ix7ywU1RyfCtu/3d5y6No8hzl/6OjdrLmZLBkybqbX6Wpjpcyfpj
SaqjSFzke5+CCpcqrYQN+zi6cVzmLzGJ/PmfsPN9UpwvZg2bn+L6VXQmiYeG
bhcY4bjdRpdCzTL3xjG+s6NEg4xw3L5p97mVWyuTM28pmWR17ZYhwyV3xWw2
beU5HY+58svmuX458kDbW6OG4Vt3O2Wfl/pbTFxIuuGedL1mvVkMEgPB23AZ
OpkxgcOTjeRoK8Zvd0v2hH0uyxz3LGdAddZwWLHZWo7JPkc46nAh+6RJ1xp0
e89COG7/0l77sgj5VieykalCutKF6fa/FZOJid+ku7hu52eU9I6lnm45YQY1
aQ0dY+pzpK7GKYPzHWwXDhgX0bGtkW340Qsdm5+RJm7/nJ0dztEpyBALSLUa
FJ2yn6OVnyHul+pIugBpjUW4ceJKsyT/po0zTQMCN01aBnsORb5e4hpY7L3q
looPvZ09RCk+mPQjQrd3BuG4HTJfgxKPw344ljHUihJPXBKa24Wcvn8d6YLt
kGf41t0+NCa2JFMknKNbmCHGbOwZHsHRyeBJU+QxFkQk4vZoJGwSiYskxnJs
GudkrxmJy9+7FhwCWH1Fqt3udH2xuH2kHwW6vZMIze3fzNSunkh+R/e1LAoV
7b3S7V0ZMgzfutsdkn3skhZZJ/ml8uTLMscGplmZJ/kHpxtPjIsg3YGt5At2
FtTzAanWI2KPfGiZPuwCKrTAoNu7CqG5HWJkoE6u2M9PUKJOSzu6nZqGb93t
SvHBUKjHcZkg+eMZoo7JPoc56lk8yQHR6aQ78EOB6n1fmtbmVJMkruLn7Oxm
78KckHTDS1l/nc4cw+HJ7uPowpWL9H1Gt3ceYbodcojUZ6fqUOMZqeh2Khu+
dbf3YRdm8+gDo9O+iebxeFK0xrv7d5H33Ir2ZF6KG5cnAwJ3T/ZgxAdD6T48
9uj30RxaY//JxamziAHBnucMiORo+6U6isaFk77P6PbOI2S3D7DTPkPS41PX
KFOrNQbdTk3Dt+52yPTEFSDAGK5yUcaEVak2hzgaZN2M39FMiguHvT2XOQKq
dMjt7CGg9Mc5P2TwpHen6w+LZQ+JSSB9J9HtXYWQ3Q6ZaKZ5a7ywxZ4ozern
QK3WGHQ7NQ3futv7svOhUM/iSU6O25PBkxoXeyCcoysVH0q6ANuTBSkusKte
KXOWp840SAycmrjaPMn/15j4lj+5UirodsEQvtshSsYaNUIcHDJPgvnNTCqK
Hd1OQcO3WbeHpBvaJi3ySHFfnOoYmm5gmrRsTvI80gXYi4NuFwxS3A5RnqZx
e5wwxJ5BZw6ypVCnR3Q7xQ0/eqFD8zPyrtv3cqZYJ/nxeNJDY2IOcTQ2pZk6
JXuRLsBeHHS7YJDldlrjY7IvTOjetvcjsiyKjAkmZLezTLv+FlRKp+sM36bb
KzJH70w3OsJRj+Myg9JMYrmssHR90gXYi4NuFwwS3Q750UYrQbpbes48GsOY
q6lKc6S02Lvc7YPpCUNlEr8dH3Ov5sWACbE/T46HOeSLt0cZvk23n8ocvyHN
bH2a+aWsP/1T7f1SHUl5pt7HE3S7YJDrdkgfR21HHbUbXfrrao4Ec5KpJune
Fr7bvxjFvnL96dUbT2E7l689vXH72TfjYshXbo8yfJtu38/RCk43TuEp7EvX
DU03SOAq8cdLx6DbqQPpbicCBfwmpkrnf2CtEFWynqLWh/Lleje5HbJ133n+
poL2VJNv2p5m+DbdvjtdDyr2Qxx1hbjt6TzZa1m/o9vR7RSEIm4n8ouNlr+q
6jmBhiZIl2TO0FP/lJIdHYXj9k//jgKZN9va5t3VnwwjW7M9yvCtu70Pu/BE
hujy1JkeKe7VmX+bJ/kvSXWE0p10AfbioNsFg1JuJ9LXUVvJWGOlikqeBPNx
qz6/NZ7BlmXN0VL7y5K6PWGE5nYiAyfGwkZevqx/8+bNINGOPXqv16Yjhm+z
bq/OGu6Z4p6fIV6QIXaIo7EwxSmNJ0e6AHtx0O2CQUG3N80X9trjzDX1DNVt
dNXA4fM0VGdrq5nrqTGNNX630upBbS9Cc/vPk+NTs24NkUzIPnb3O5GPr7G9
04Zv0+1g8sA0qzgukxG/LSitYZAW/1R70gXYi4NuFwyKu73Xp8vd/uXo6M9G
RNEaf1f9fCSbfKNSLW0ZfvRC++Zn5F2370nX00rYEJJu+DWby+XJWCf5OSb7
kC7AXhx0u2Cg23uZ2zGdNHzrbu/Lzg9Itf4tJg6q93iuUgxXeVB0mk+KM+kC
7MVBtwsGuh3d/vHmfYZvs27HoNt7BOh2dPvHnncNj26nWtDtgoFuR7djmhp+
FLqdYkG3Cwa6nWpuRxAE6TzodnQ7giC9D3Q7uh1BkN4Huh3djiBI7wPdjm5H
EKT3gW5HtyMI0vtAt6PbEQRBEARBEARBEARBEARBEARBEARBEARBEARBEARB
EARBEARBEARBEARBEARBEARBEARBEARBEARBEARBEARBEARBEARBEARBEARB
EARBEARBEARBEARBEARBEARBEAQhi3N3rvgl7MCQlesP7zQ7Iw9ePsm/c6ad
yb10IjlkHi9mHzcmMu1oaPrhbdyokPy0mNaTtG91+tFQTuz+zIRDKZFrUo+u
af8n9u7cfvaAlH+GCNLlJJbn0pwmY8hK4cXyZmck82bZqKiZ7YzyLpMY+8nR
JpKVwWMP60vFOInn05nH6MqQPSyVjZpqTZMoq0y8lcZUjJ0jdsR2cvH68fEs
+YMe9PZ/Yu/O/vMZpPwzRJAuB93eo91O32PFnip5atO4WE3ZGDuJQjoL1H2A
ocLy0Vu+SnabD33rdKNtc6ZuMjMLiztoE7rYYqZOtmTDMlwFRsxMCbYVvWj9
+KCpaqRLlSJBtyO9BnR7j3b75HCbFEXFtIUTU5TlQ5VVWL76akt05wYw03wn
HjSSSpRRifVfFbHYLGqq1GFl3QOz3dMyuVODPdVW2Rg46/KkWGxLOnuW+PZp
WqRLlSJBtyO9BnR7T3d7KlMxfdHEEJbyzLVqlVvHhivJ5yyaGMaSi7aip/vI
2y20WWKgtm2a8u3r1/fpm+yf6x3lsSDC3qWorIS5xjpJWQGuAjvQ7eh2pNeB
bu/RbpcNM0+aPylHirlUXz1sLf30+vHhetIbrPUCAow9vGdIbrSEZbYoKefQ
WdvVlXZ7O4Q6m4TMdtrvseDNmzeG2z0yJVmJGnL752J7O7od6W2g23u02yX3
WOVIKk2drTM3kMlbILp/uiTXXcxjrhl9w4yt8kxVv6nMCLe9q1bnSqvqO03R
cNGNl2TstrPKOxodMc0iOz9HZ4vLqilqwcaapEuVIkG3I70GdHuPdvvkcJtM
OstjLevazrGHV646YO3IXaYwbY1Vw7uHbdfNnx+pMy2Rztw702mtg90xunIG
nRW71mufveMRV6ndplNevnwpt8hol7EO6VKlSNDtSK8B3d4L3D53n3/81m1H
lujtd5+ya4XLejXmEWnmXmWtPQuXRMmoJNOZ4Yoaa3ZsUFxpzFhh7L7Acucc
s5i9wWEOM0vDVOV89dvv9vHRs/h/e2XQ7UivAd3e092eS2cpb7LPKMzZP2d2
hP60+7duB03XSpFiGTrp2llo7p/vG754qdFOj0XaqtMddceHWEa5M89tGn9A
Q69klci6QFljR532u31O4fbd59ICy46QLmF0O9XIOlU4n73ZLz0UQ0oiSlKb
nRF0e492u/RuiwxZpRw6y9BlCpuXxDtwKJKhuc1h6jodVWdjtXiphvuYpjvr
wZKKftPMHfQMAmeGmLB2KMtc3TXWPFB9jbYaLLDNpF3920WiZx28kAV7mHP7
tFS8+4eWmZm7aSzbgXRLo9uFzJId62hf9aMZjqEtkMMIP+q7PZqdEXR7j3a7
1G6L1AWiHAVGw52nMbvv3b69V9c4ZunKKO/FB2xmxW/1j1BUMp2lN22VTcYa
VqSGbPp80XA1mYgZ9MeHRmus1gGxx06VCneVbM9njY6yH892PHghc3z0rDFR
9jBHPHbOpFhnuQTPpjJnJntn3CxVSvIiXdTodmHS4HaCcT/S3CRJd93HFnQ7
1dL5NhmOPCNz2YQsSaaxo86skCXLgwMS05PYq9bw9kYcYGpGq8oFL3BI0jCM
MpU8bDM5Y4Ho1mWS/t5yGqt1l+upJzb2b+/Qb6ngc/40KL285hKU8c2WcSkI
vvmsRjnFh3RXo9uFxn9uB7CAR7d/9Om82xNV5FMWTkzQlIMinCPFipVlWdvp
WG1fcNBv2SEn96P2kw/vCAw3t4qyom93piuv0AvQUYuXZeU2jk4Q6yTOdpwc
LOi9S57HQ249q7lQe9Mqe12zt4rvVZ99dF00xol0XaPbhcM7bscCHt3+0afz
bTLsKdKnt4yL1pWNcxXLkXw7UFiirPI0J10tT/2mcTfRLGhUOiRZVT7eTYxt
SS8MFAkyVm3nx5lnrVVPXTQ7fyt/jkPeZrXUhS2XdC/cAceyoyqJdF2j24XD
e9yOBTy6/SNO58eBTPacFK0jXbRh/EE1WdB1lvRbvbeSBG25w/biB00kc1dM
iFeRj14g3s6PcykIhj0MqojjzyEa3ltmUqxzXf3rl69ffehXV2oG3S4w73c7
FvDo9o81nXd73soJsSpyKd6ih1VlY+eIpbIU23Q724y+34R+0EAy3kk81lA6
ecmkD21/HNuR/3dijNPik+Hna28uKzkgm+DR5r6dfXQdDmfFqYOkGxvdLgRa
czsW8Oj2jy+ddLtcqFmUtkzx+vFsa4kkL9F0xf/EnkdnpdCZ/KTR36nno6dJ
JXmLxs4WT/cR3Wah9KHth55N3X0uzYC7jD/HOGNVO/ct+1bDofFulpJubHS7
EGjD7VjAo9s/snT+t9Q4fZm0xRNjdGXz/21LT6IzD9AZYXTGfrrCDnn5MLoi
/I2kK8JMSN6/i8HyyfMnsZ3Fgo013rtxpSSv0w8uwy75l+wXwJNwILDu9af3
STc2ul0ItMvtWMCj2z+adMGYA1LMnFUixFM5IulKe+iMcDpjEUtpvhpzn7N4
8drxYWb0ym3jFhgo+KqwtsophdIZsEx8YxkfryqfukD0Q30gJ8Y4sZIX7K3m
SMS5jm5sVyeaYtrTIAMpq7kIh/O07gXpxka3C4H2uh0LeHR7k0gEWvCnf/ZW
g7/jlk9rusC3Hoqk7yQpbpfYa5Uwd1KCthxU6XvpjCg6Y5+lxN4ZdPF1xiZ7
fDatkYmdLb5cQ7lq87iJW02N9/qYuapF2k7eqi19kK60t0HyijGOk3fZy7Xy
EfQ4V/60Q15Q4Z2q9ow5MI7t+KzuJRxO7atnpBsb3S4EOuZ2LOB7i9sPnEiV
W28HEyIrpsuss4EJ6/CldpHLlTfPhml6oKVKkFPT5WGx3QVxUmusYdpg5zyH
/SuJ+X2dJa7W3Jq4csaDp7VfuMnO2L2w/Ea12GqzV6/rgrOP9nORXJYcQmx/
wkoTxQ32xFVglL8hTNjvX9GnyUds5O0fscTgh/ms2NIs2OxofyNO5THYAvGu
V0zQ1+7y1He7fKhZspo8VOBe6spMbwMFH8Pz28Zmek1ibbBcHLpu7QqpXbpS
R+lKmYsmMDfaLQgNnL+WGe0gHrd6Eiys5KkHBTysu93qg+3tTQNl/IELmS/r
6zg3Stos3eEqQBxO1cNrpBsb3S4EOux2LOB7hdttIvy3ZR+BCd+4bWXXq2Hi
/N1rb968MQ5dANMX7l579OzxN3MV+MsHpu/bV5jon7QLZLueGwkTnzjTV6fu
kV8/s/T6Oat9S2DPpddax5U1DG9ScrUKVA8TKRX5MH3x3nXQ8tQQb9jmV+5y
23Oiokq4sM07tTXExxEpvlJ5u/a+2Z5FsKLFXr/50ZthAi4WxLuw8I6cKOq7
fXK4DdF47mSgart3iXzo7Gy/iYesJSQ2G7tO1Q6Tld+tKL/bWPIAnREkK6e9
wNhzldKuKdKRK8Sd962gb7Ml3N6h+1LXlbPbs1jq9WLicPZVc0k3NrpdCAjo
dizge7jbf1mg5npk7aB5LFAoKN3xwCqQ/N9+erXPn0C9fezSadgTKOP5y//s
rXb38QMo5rdmHQY/93eVXp4cCsssjA/W2+EJdThM6wS7b844CBNrOeHuR9fD
RH19/ZMXz2ACFoaNpJ4pgKI981wRzJ8cYA7zrz24za/GeWdPEIcPf6/U3LKN
WAYTWeeKYceG+GgQFwvW5lk9xe1KHnrM5dMW6KhuV5DbKiu/ha64TYVxZLb4
IRPJoGmyh6ZLhtuL75JnrpdShHd3KMhbW+uIbzZ11lftqNvbMw7YjMwA/uFY
trhllcpBtwuM4G7HAr5nuv2H+SwQdR+nyYyNDnWv63blRsOHglefv3rxq68m
eP51/WvC7TCTWAVq9ZC8mOo7V3/z1Xz47DHMgYvCs5fPYZk5h9cQy0BNPj3M
B7YM82ECtg8H8rLuFbuEB4tBQQ5zvGOCPpsjxak8BnM82RuJ4wV1E1uArwDw
0VW3LxHLux1dBxOwP7Ad+JpQcfMCbNlg57ye4nYZX0PtBYZrlJW3Sytsk1TY
SWcsn8I67CAeaSK5bBrjkBl9h5VkkLLyVnC+pEKYlKKHkbrkehNbY/WOur3N
iMfOqX50gziW8ppLpOsa3S4cOut2LOB7mtsl11g5HQqACaL9ZHXqHvgLFTX8
lV1ny606DnZdELsFpEq0rv/krZpdffL6wzt/LdYFM8N8uAQ47F8Jc+7U1hCb
gtx6dA++CMDEoeI0uF7QGkt9WIA4qIjjSZ840z93lYH5cJk4ebWSWOX0jfNN
m9w9ojYQy0O5Dp/16nUdrAifG1XCjS3NgisFbKSnuN3JQNVhz1L50Nn5Syew
Z06WXD/VR0V5L0tuv6JCpKUEW5KxnSk7zUHXc5XS3qlSkSvE3fauEqxNpvWI
RM8qvFNFHAicO7OsNaTrGt0uHLrA7QRYwPcQt8uttwvNjwVJgs/zLpyaGbkc
6uGgzEPw0ZNWmYqtNoOJedGb4O8fi3TEV5uDwy/fv6kS5DTAUwlWP3fnCqyS
dDo3IG1vydWqZckhMHPEEgP4CnD0ZEMrenD20ftPHpruWbinIN6ysR3+n8aG
d8UN9qzNs6DwXhgffOPhXVgyuSIPPrqvswSxYyDzwQvU4dIAy5ffaPgJAP4e
LEqFbw1LE3eu50bCfOJHWCq7XSbMIl2p4X4lDy1lqeXTJq80PrtlXKq7GGuD
5dLdGwIWSO3Wk4qSUkqbJ6q61sY3bO38tcwD1hIxgZMkl0+T8jMi3B5srtwl
YlRJ8al4cIV/IO1smadU0O0C02Vup2EB3zPcDvY+c/PiaH+jTRkH0s4U6u/0
hJf7ChMfv3galh8Lgj1/95pv3DbYE8ZGh0HzWFA2f+EmCxoHgX/tLg+afV3/
Gt5V2uQIRT4oHda60Pg7LEDMgctB7vlT4H/4uB05UbAw1OdETX7s0mnzvYth
Ara8IiXsn8YrCOh9coA5OL/m6aOB85iVty6B84f4aBwuTodpKOy/92TAFwRY
mPptMpJ7rFK8JqUoN9ygFEJnRNIVjzqJHXYQF99obLFn0aY1MtEO4huUmaVr
RCYEm5ntXWjpoRbtKhZsKLmPzgilM3bTGdFW9LDZMu38uHFsR2L8gWaRTfAI
OZvytO4F/yiCKxNJFzW6XZh0pdsJsICnttt/WaAGnwIVO6gVSneoqImfKQmu
1tx69brOLnI5KNomwp+/FqfyGEjvc1eZr9zl4suyE8pzQMhEk/g/jT+Jjlxq
sCRxJ/ESDAzXhR/ms2BFWB4uFk9ePPvRS0VkxfRv5ipA9Q7LKGyYaRTiBRPK
m2fDtwOYgAsEFO2wgEmY7z+Npf7y5ND6+nq4ssB2tIPd/mlspae42yeH23Cl
mdkr3t671NhlnXGQruSqyXI0UA33mHx8pchGY9nzO8fMMVFy0VMNUGLublwm
hq7UMGiYsnxHx293yAs6cCEzqCJuUfG+JScjdlQlFd6prGu8/hLcfv7QtXA7
6ZZGtwuZrnc7DQt4SrsdAmL/p7GfIVia+FAoxbdmHX5Z9wqmoeQGwUIxT3Ru
aZZPXSSJZvOgzEOa21xnRi5flhzy+0ItmAMFtsw6G9FVM9ZywqHkJprrIVDY
w2YPnEglXo5dNo34dKJ3jeOBVf1cJOFDYRo2CAuoBDkRe0XMhA3SGjvY/9PY
A4f6bk/QkktZODFOR5Y/VkwsXeltWS6tEKwsu0tKYTtTNkJKEWZCcv8dc6Bh
KGCPSVEN47e/f8yBD0Us1mVteVTFgyvw1Ym/2zB98v75VaWHJva0MdvR7V1C
t7idYOz/sICnptt/9lYz27MILA2VM9Hd5frDO7TGZnOQM/F7JbuEt/9ECtEY
DrX3l26yoFyJQIu0M4W3Ht37Y5HOvScPiFZxiNOhgLiyLGLPib6RwOMXT4km
ev4c1SBneDlwHvOfxu4xsANwNVmTvo/WeB8rFO3EXU6Sa6z+aew/SaxF9IEn
1tpbmEBxt8uEWUTpyJQFjWNPl4r3nJQpq8T3djadFUVX4ieW/t9bkLgpMgnz
RKNsJ2ctm7BlhoDt7fQ41ymcpRZZa414KySa3L7ac4NuF5g1YVu7y+00Wv/v
vpJwN9TeMw/zoXglBzc7I8IccwDs+sN81gbe/hevXsJLw13zQcigbiiSN/L2
P335/OztyzA/61wx1OElV6tAzvDuP439XiKPJ//TeL8SLDA5wDy7+iTU57TG
X0jB80QvSuLdWQdXwTRoHL4LQIkO5X3d6zr4mgBvlV4/R/wCS+R/XsoxpZlE
mwxsH644MOEdE0S8C/tDtOFT2e3Ku0x4iyfGqMlm+k84pNbweA6OAqPNMX5j
jKT3W0ocNJJK8xaN1ZaJXyRGulQpEnS7wCQmJnaf2wF1dXWyD7GHIRy3g2MX
J2x/8LQWymOii/v3noyap48KLpa9el0HE8Q9R0D1nav8fYPCnmhUdz2ylrmp
odl8ZUoYf5tQ8I9fblxx88KbN2+ev3oBKibqdv2dnrDkOk4E/J0btQHm3Hh4
F9QNE/DVoPhKJbG68ubZNx/dhcMfulAbltyZy4ZLCUzwb0e9cPdaTnVJD3D7
womx6rLZyyccUZGLdxPjyrft9lhD6QOWEoemSnF8ROO00O3o9i4A3U41hOD2
r9zlMs8Vva5/DeX32GXTLPb6/dPYrA1/A9L28n9a5beKgIehwIaynOiLDpU5
lPEwfen+DU7lMVpjIw8U//efPOQfBYidP54AcRWQXWebf6EUNj5oHuvUtbNQ
28Nbq1P3wFowAQvDKlCiw/eFL91kYfk9BfEw/3bt/Wcvn4/2N4JpuO6cuFxB
cbc3tslIlweNi5rW2CYjo5T5b3P6ah21ZVPUtqqrLjZQPyDP8jXU2K+kAvNz
6Kx8OiteR7ahTcZGIme54G0yvS/odoFBt1MNIbh9W/YRKIaH+U2hNQ4RNj3M
Bz73lwVqUGz/09i3HP5GlXDB/1BLQyn+6b8DdhFxO7oOinOYAP1CLS21xhrq
fGLn617XwUzHA6v+56XMX54eaAlvqQQ5TQ4wh5J+Veru9MrCjLNF8JbzoUB4
q7+rtMw6m78W60Ll/+jZY4lAi5d1r+C6AwsQt6kev3wa3oLLAb+Fn7Jub3gW
tmbDb6nxjb+lxsorG1hrRjaM3K40V1N59hRVfyUlm2lqm6QZVibqG2WVYP5y
JtPMXPPtw/XmNvyWum2aJulSpUjQ7QKDbqcaQnA7VM78aZDzrIOrbj5quJkI
7MrY6ABqvfHw7rzoTZW3LsHMUf6Gp2+c5+u9n4tk1rni3POnaI1jM4KriVbx
lsBbUPmD7eHyAS+n7PCAVeArwJMXz46e5BJbgJnw1q++mvz9CcmLgRoeyvWD
RQ39aqDUJ644nuyNcNUA1VPf7TwZpewVEwrpLBtLzWAWa09DDxlFQ3vtyauN
jay1LH2Up9loWM5X1pmtI7Fimq+mckRjt3ZLG629SoL0gezdQbcLDLqdagjz
t9TfF2rBJ84+uBpKcWLOdx6KJy5XhObHQtlM/JAKWceJEFkxXXf7XKJzO6xC
jPFLDAjGrTq+JHFnWH5sSkU+0YuyKbyzJ4hOj1NDvGGVv/30wPbRpzLyLjS4
negSA18NaI19I79wk4VNTVw5A6p3wu2wzeIrlVCxP3v5HOYQlxsqu73x3iXR
FGUFKMID5JXYdKWd8kq6DtqW09TmaitruRhYGCnrORvMMFUztp0y20jNwUDF
ZIb6EbpiIl1prVpDE020BX23U3vvXer1QbcLDLqdagjB7USDCVTpRKt7YGMv
xL7OElrb3MDnMIceaHn/yUOiLR1iFOIFbgfNnrxaCXtYcLGMKOPTKwv/aTLY
l8KGmefvXuMfCBTtsLzBznmE203CfInFgrOPbs+Jyq4+OdrfSHadLbw1ZtlU
mCBGLfjWQ3GIjwbM3FeYCAsnnc49dun0ML8pL169zKkuIdqCqOz2hjEHGIrr
tNQMnacsYzC9dJU9ViqZT1MJl1GKl2MxfQx9p6ipe+q7mWiY2uvk0VmLVFnz
zBgzfZXXyylNtdXSmzMlm84KNsP2dnR7Z0G3Uw0hjANJDN6rE+xedfsSMWLY
hbvX+G3mi+KDifFk+NKGLE7YTrxbdr2aeNCSTYQ/Mefy/ZvfezKIe4ugrl6W
HGKx1096rTV/+Pdxyxvcrr/Tk3g5wFNpS+bh/SdSVqaEwUXkwdPaz+ZIlVyt
4n86XGtgYj03EhZOKM+BnYEJ2GzWueIe0d4OtfcmDVU7a+1lDCXFZQbJc8X0
7XRk/Iwan4jKjLGXiNuyOnZGw2K7Wcqia00WmcnudJHUmaVjYqlpYacDbsc2
GXR750G3U43udvvMyOXEAy+mh/lAqQzFc/GVSuKjoVaffXC1SpDTy7pXME2U
9z96qUQcTyIWCMmL+cpdDmbqbp8Ly4DVCcOfunbWJ3YrTPy5WJf4lD5Ok4nO
7bTGEWzgg6AaJ15CAQ8vtYPdQvNjrfYtgSsIfOLDxiGCrz24zf/vQDwWyjZi
GXEv1ZduslDA84cdprjb12mp6s9pqNvB7UenSZmYadpYa8P8o24yS1cyfKdo
5qWksG0dY+RYhk5TfKfJBVnIgtuNbLV0XfXQ7ej2LgHdTjW62+2bMw6CUccv
NybaQ/YVJoK9xy6bNmmV6dCF2qtSd4N4X7x6qRrk3NdZYtbBVfwukXcfPwCx
Q40NNfzr+tePXzwlRgPgj8QORJ/K+GORDq2xiR5KcajnQdESgRZEez4IH4rw
N2/eZJ5r6CSzJHEn0fCSUpFP3Pc0eIH6waJUWNEoxAs27h0TxP8N1/XIWtg+
Mewk9d2+WUPV0VIL6na5pQaxVnQjYxXnaWoN3WYC1nG27jCeN4W3rqEjzVFZ
prmZps9U+S3mDW43sdCwttVGt6PbuwR0O9UQgttrnj7aln0E6uEzNy/CJ756
XVd95yoxluM/je0zUHJDmQ0GhpfgOrgW7Mxlw3Tt8yfEGAVQ1RN1NRHGRgdY
mFj9+asX/V2l4bpQdfvS8cun/RJ2EAMXDF+in1yRBwtAiQ7TxBz4aKLLpXX4
0mb7CdeIyluXhvlNGTiPuSIlDDb+5MUz/vcCirt9rZaqrpteQ92+Ui/NRbyh
TWax0duxBeZ6H3XXT1FueKbqbmZDm8xiS9lQV/oUBx1DOy1td6zb0e1dA7qd
anS32+XXzzx7+zIxcstfi3U5lccIJ9fX1x+7dHr2wdWfu8qATtklPCiSoZ4n
1vrOQzGhPIdYDEprqPBbbvmXBWrawW5QchMv+Y0wkDHLpsLXgX8a73KlB1ry
54PS4Vpw69E94g7WpplzeA3Mh8969OzxP41DTcIVpLvF3nm3y4eaJanLB2mo
OptD3c5cw2KaLFOfpc/aK8eMl2NJrDReoKcq6zfVwVxrypwpBXSWh66K51Ql
Mze17ZKKphYattYNdft2awbpUqVI0O0Cg24nmboz3iI0xtKk5//OEGYfSCLf
eiiCq4mhdFsPGBgkL9ingNJZm2d9Nkeq2fwfvVSa9rfnB2b2c5GcGuI9N2oD
WL3lit3l9nNxzc5Ix+r2vVYJ7mIJjTcu+Sozj9AZ0ZJKqk46doYq1oYqUx0M
zC0YJvb6ppbKM6z1TM00LMzUbQ1UYhpGD2P46KkV0lkxs8R3zVQgXaoUyf6q
vc1OB9JO0O0k87zUFP4ziWzkD6EufLdj3nF7ZVSzM9LRNpksKWbuqobx2xcZ
qO9iKYfRGWF0xZnT1BheBtoztfXdNbRnaum7qWs66jDn6a9mKB2kM7bKKrma
aiZJM+NU5VO9RbFN5j+3V4Q2Ox1IO0G3k071YVOaSDC6nSIpvFje7Ix01O1x
BjJpiyfE6Mrm05nJsspajtoxjSP6ms3QmGKnNVdLWXWOboCCEstDbzWTBfMX
qyvbmWoQPSRTvCaxXcS2GXds/PZenP3nM5qdDqSdoNvJ5XqSK/xXiiit4c9B
t5Ob+N1mzc5IR9vb2doyJ9aNZ9tIJHmJEs9OJbKX2ZCDDJUwZZVkKdYuZZUE
uf+GgoyeLpXkLRrnLJ7mLbrNAtvb32ZrmGGz04G0E3Q7udTVXq++/k5TIrqd
3OSVc5udkY6O8VuwSiRORT55/qRDarKxLmIpLMVjbY3xyzan759BP6gvGT9L
PNZIOmXJJNKlSpGElx5pdjqQdoJupxrodnLT+fHbkzwmxehKn9w4/pC6TLyb
WJY0s023J2rJHbEXPzBDMm+lSLyKHHvBZNKlSpFgPxmBQbdTDXR7j3a71G4L
tp7U6S3jYnRk4+aI5Uq+Ffs+OmM7XXEbXXEHXTGkcTq4cSKZ/naBFBX5OFex
KEv6sUCRoOmqpEuVIkG3Cwy6nWqg23u02yeH2yQpy6cunJigKQfG3tM4fm9Y
4zOvI+lKMLF3quTW+fRdTNnwxjkhjQtADtMbHs8UM0uc3fAsbC3SpUqRoNsF
Bt1ONdDtPd3tHHlGhn/D+O3g6oNqsguXKLgsVSLitIwps9HIZr2GeqAufyYk
yEdyd6PbE5UVcPx2dHuXgG6nGuj2Hu126d0WqQtEufKMvVCrK8ofMZaUW2YY
xFR2mq4x6pAtY9X0rWZmO3SZAdMMGy4EQWYr1VV8ddVsVqoeYcpHyiim05lx
RtLhrpKkS5UiQbcLzNF1G7pP7D/0+yx4pHiFpDrmQ7nstrDZGUG392i3S+22
4Mg0PEEP6vBlS+VkNk2VWW3sYqIptsV07D6rndPMNtLld00z26Zl4GugM+qo
nfwKYw9D9Qk7zWQ2TmXbScBaR+lKwSZqpEuVIkG3C8zhZau7Sexqn33D+25Y
8YARmFZSbWTb7Iyg23u02xueqUdnxenJrPSSMV7V8NhTiT1m6+epR5pJ+/uq
q/hN3WVstk1FZYueocKuaZvd1fZZyXn6qTese9RuzRLpnd70PXRFbJNBt3ee
7nD7oD6frPtqMOna7BFBt/+fvbOAb+J+//jB2A+ZIRswZwIMd4q7w7DhMoYM
2B8GjDHcvchwKK5F66WFFqdAC6XULUmTVFJ39/2f9CCEtA1pkvYu4fN+Pa++
0uv3Lnc85H1Pvt+77/Et9OJ2u99Mfro0k12yZ8vg8+uHnJg/4eyyfvtMR/Y5
Pn7jzp6DD40+ZfrLyQVDj//fcPPt437d+/JG1CG7R56G2+F2faB3t6Nch9sN
OvTl9jaHJzc78xst+c10oO3OkZcWdrLbPnj4vyP+WtLPYnm7sauGLdvS03rr
6Et/d7fY1qfzmcnUstWxqVN3DIHb4Xa9oEe3o1yH240g9OJ26149rUZ1WbC1
Ly1pdn76yIUjd/ft323ruMUTRhwcN2XPoBF7Rk4YvnTMpLnDTfv377x9gnxd
y9/t/257dVSXU3A73K4P9OV2lOtwu3bBPrmDP6Gj23uemGL/S1f2ynazf0yW
burVd+2YK1379tsyocnlmesmjT84bvL+0RP2jZsyecEY8vncacNO9ug3YPeo
v9f3tp7Q+aZJXzeTfifndudcqjwJuF1rdHc7ynW4Xev48+rOKx7OnO+GHt1O
dbvt3A62Ezpbm/QhvVsM72qya/y4BaNGLR79k/mMNsd+XT6zl8WC9pMWDP3p
yqwO+6fQn4atGDNry4CLRe3vmvRx+Lvt0el9OJcqTwJu1xod3Y5y3ZjcPu+K
qY33/cvPnU+72h1xsdhz96Kp89lNN05scDy+zuHo2utmq+2PrLQ7tML24FKb
/Uus9i623LPIYveCa7vmX93xf1e2z720bfbFLb9f3DLTfNP08xumnVv/67l1
U86umXR69cTTqyacWjn+1IpxJ1eMObGM4pfjSykOPbiWkJ485PDCXnvntN42
+avVQ1tsmdBp1/RKhux2l859H21v6VZ075Jlz552MzoqwnJ2h9+3Dui4b9z2
NV2Vl9tMennvkt3QbjeXtkWfDNyuO1q7HeW68bm92qKuJx7bsI/Y4xY6rRiu
26lov7tRPn/7g65975n0u2PSz9mk71GTXgfZ+WS69LQa2fWUSW/69ahJ72Mm
ve4UtXEx6UftnZa3cVja5vD4wZxLlScBt2uNdm4fjHLdGN3ORoO1w2dc2Ljr
9vlTrnYXnjlSnH8qj3NPHSjOul2nOONmT0HlPcWpojj5xJaCTg0Uxx9bUxx7
ZHW0KMxcLCnoiwAbhx9eo6CKnYIONj0786HwhavY53logHeEIDolnv4RUjLT
uCrdde1vPznF5uduj7a0slvQ3nFp2xuDe7ycCsyk7yn55GC9qD63l7/uzb5m
y3v5NL/TTag9Fe3289ofm4n52+F2XSmr21GuG73bKzLoJBKWGD3n0tb/u7Ld
zufh3Evb6PTB/jvU0OD5rTx0e/8Tk7z3tbDv28N2YbtLg7rZ/tnOcWCPt87x
azOnw6UxnS+O6mQ91cRuaqc7m9twLlWeBNyuNWVyO8p1uF2/8d26Ec+k/hsc
j293PrPz9vkdt85R5ObnXfd14WqXdHe73dwONhM7B5k1uzaqs+389q4mb5+/
3blfL7sF7SxndXixp4VDvx5X/unIuVR5EnC71mjodpTrcHuFRXWOKna9uN3k
7HTrcZ28DzS3G9rNZnZHdjZIN5N+f00cMndz/41b+mzc2n+F2bItJ7dsvnTw
l22zTw4YwOr9Ts/etnM6WE838djT4tB4zCcDt+uKJm5HuQ63vzuh+1iqU69e
zmtaO/V/2RWzafTgqRsG2q9q47+zZbh5Z5cbF5yu7nt4YlJ4kCA6NOzw/l2j
Vk+91utV58x0E+v/a38U87fD7Tqj3u0o1+H2dy10d7tzn16317amiv3AkIFj
1w05t22o4/4xFt16UyRdbHLP7uyZZeOf2u5w3LDVfNKMS8PH3z2zcN/F/WMX
j3Ps1v9G0fztx+B2uF1n1Lgd5Trc/g6Gjm7venrazWVtXbr03T5i0NEdnVz3
dbA/8ff9g4PvrupitWKU+c7tF4eNvdNz6Omxwy4sH/PgysGnVrYPLq68f3GV
RCyadmyl/PEcQ7tf+tuEc6nyJOB2rSnR7SjX4fZ3NnR0e6ez09lnpK4dO8Tj
SMurw7ue+7mrxZguTy8vODdq0i3zS45nzlts23n9xGmLtRstJncqLCy81Pfn
S4N/8Xa6veXKYbZnxmzCUM6lypOA27WmuNtRrsPt73Lo3ifD+pncfvNgf8t5
fe7t6GuzsM/NkwsvT5t9cdY8603b7f/dbzt/sfmmbeeG9Q4RBF1eufb6gUNP
nZ1WndnGrov7UuF23VF2O8p1uB2hR7d7B/hZzv/bctV6m6Wrn9ntuPbnYsfj
p2yPHLNYstJ6554HjjeuTJuTY9nk/MDul0d09TZttWl7D7gdbtcXCrejXIfb
EXp3u/3qjbdPnHbcsvPp9b2Xxnc+//cyu0NHr61cZ7Nn/4lxUx0PHCG3X/yl
i/U0k8B/W8DtcLseIbejXIfbEXp3+6n+A+YeX3/z+iXbrV3sjy2wXrracslK
pxN/XRrZ1b5zf6ut260XD3i0uo3FVJPHty3uXlp/bWeHUSuGwe1wOzBW4HYj
cLtX/96+I3q6mPSbOePnFae3375+8fLAUZcGjkpPT79zYsbVY2s9zGdcn93x
ypjOFwZ1s94zZML6wbuHDaIVg3/tCrfD7cAogduNwO0+w3rKVrVni/DbXfpN
+HP0TsvjycnJIj/XO2bjnU8tvGd9KOVyU0+zFjM2D1w9dohi8oHEva3gdrgd
GCVwuxG4PWBcd79RPbyH9FJI27ZH/zF/jR2zfibF6BWjxywb+suyofOmDnV9
NQ8kBbUPntLNZyieqQe3AyMEbjcOt0euae87vOdbZwlTin6SeZ0ilndw79oX
bofbgfEBtxuB26kCF/zWVTSri+ZuDxjT3W90j5C5ndEnA7cDowRuNwK3U0jm
d6LS3bNvH03E7t6lHxX5caZt/H/pAbfD7cAogduNw+0hczqT3iV/dvIZ2ovU
rUbsnv16U2OyOp0L2C56uB1uB8YH3G4cbqcImtQtfGmHoMndIlZ0KE3sXv17
SxeaUIT+ZeI1qBeub4fbgbECtxuN25916iec2SVqXbuwvzsGT+0aOLEb/Uo/
BdO7BE+hn12pVg9dZEIRubq974jXA69wO9wOjA+43XjcXhQ+w3pSWR62pKPg
ty6SeZ0Cx3f36NFHNKuLcGZn8R+dw5d2pNcePd947h7cDrcD4wNuNzK3vx4w
7drPs1/v11ezD+pVWku4HW4HAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAACGizAuev0tKwRXIUtJ5Pq/AADACHEM8mKW/4rgKp6Gibj+LwAA
MELgdrgdAGB8wO1wOwDA+IDb4XYAgPEBt8PtAADjA26H2wEAxgfcDrcDAIwP
uB1uBwAYH3A73A6A7giT09c/FyC4CnNhhEpG4Ha+uT0pK+lR6CMEV+Ef619R
OjQqHENjmKMOCK5isOMz1YzA7Txzu6PAkVnPILiKwRcGV5QOjQq4HW5HwO18
DrhdO8rk9h62T44FhD6NSdr6QtjV5knds7eqnbih4bq/3vV665LJdzzfP+7I
uW/h9nc54Ha+BdyuHRq6vfYZZ3tpNLW3lUTXO3errAb746FvTn7BUrcAxZJh
N57l5OefCQqr9GpJe0uXzLy8x5EJ1Y5rer4wgoDb+RZwO98CbtcOTdz+2dlb
guR0anwy8LWKyxTtLF2WuwVQ2a+0TefVz4LG3/JQLKEt05LZD3w49y3c/i6H
Ht3+7U5mxElmwRVmpSWz+Coz6SzTah9TmWtVGlzA7dqhidtvR8RRy+exye9a
hwncrkXUWjuB833g1u11tzPrrBmBD/OftIRICGaOOTGt93PvTH1FJbidl7zV
7T/fcGdb9rF349yExhfG5/ZTNq053weu3F5tE7PRhskUlWx1lbh2n/lqB/dm
1j1mXyzfLyNwu3a81e2W4ihqFpqWybkGjTKMzO3Nt43K9ar7xYZxnO9Jxbv9
x92M9wuNrK6IxGBm2Anu5axdNNnzUuleL5juh+UvGuxiPtgMt/OFt7o9LiuH
mp0XRJRJWQOuP9ViSb/rbpW5li3crkW0NR3RY/cwikOW7fK86269ZML+2mL7
KM73rWLc3mofExP4FpM/esrcd2N+u8AcvPF6YYGEmXGBe1FrEX3MmDB/Zr+j
/CicnzB3XOXfRMrjjeB27VDv9vePO7LNdniFaO6rHZ6irNz88bdeKJbMeeCT
nZe35Im/YsmwG8+y8vKP+UuVr5NJz827HRGL62Q491tZo+GWX57e+5Gsrhx3
bzX+auNYzvetAtz+zU4mKuDtVfrkc0ydbcwnW+QmVD4RkN5HnOTe1VrE4Zuv
jyI+SD7QALfzh7fW7dn5+dTssL9Uc1+Nv+VhIYpoYH5XsaSD5SMLUWRfe1fF
ks/OOluIZDPuvb7EnSRvLoxY+yyIc9/C7VrE+yunHLFsqxD7tssmlVdM5Xyv
KsDt721gXJ+pajxTxFy9z1y8y4hejaimC5nqm+Tta25lPtzMnLz1RvtkgbxD
g3NXl025x98YL84VMzvs5YcGt/OEt7rdOz6Fmt2VxXOuQaMMA3L76EMDKi2f
SsYeuG9wiQ2Wn+uqcPvvx3uV2GbI/kHM8qnvrZgy4uBAzo9IL26ff7mEEp3K
+D5m8r9WWs/Mu8xIfBmbhy/bU5G/z5EplKiuYu/Cva41j9b7mT0ODJVvWa8G
jp88Y8ycmDnlMK4Kt2vHW92+4bmAmuUWFNQ+48y5CY0vDMjtmy+Z3LjZ5OGd
RgtO9yjZivd+vHq9RZOto6kZRYlt1pt3vunU5MHtRovPdOf8iHR3O5Xi0cW6
2a0fyDvVyflLrskHWKnZ3Evycp1dpfZW5sxtueodHjFB3m+s2OkQ99IuU5DG
c0Lkgwj0849L5fUucLt2vNXtn551TsnJpZbbPUWcm9D4woDcvuZCZ7YmH3Vw
QPG/1ls/XqlWn7rwdI8PVk8q3mzW8d7sRuad6sn5Eenu9mnnVcV++R7T/gAz
0/xlg65FF5BU3chssHm5ZOwZZrml/MV3u5hw/zfWpTKYc12XKRrsYq67MO9v
YEadYrbbw+38QpN7lybd8aSWOfkFXW2elNiglcXDty5prdUSow+DcHul5VOX
n+vqfv+HVI/68e5f+Ll8N+FIPy22M/tEr4BHDZKef574/PNn9374v5N81HuZ
3O74SNXtdi7ybgo3d/mfSPKKlm32M1+Yyl9QJc/e7NPzCBPgJR9IVaybIZKf
BTg3tuZRb7v8kn729bc74XZ+oeF8Mn+4+OYVFMRn5SjPG8DIL6RxuBAckZyV
3V1p+WYPQWpOjvJ1MrMf+KTl5C567KdYMuzGs9Sc3H0+IcrXySRm59hIonCd
DOd+Ky2OWbUprSNd81hxruvWSyacH4vubn9vA5MmVHX7Njum7X75JTFvvfP0
o83yy2Y+2ybvjVeszl4ojoDbdUfzeSDbWro4hcdm5+fv9RF/cf62YvnG5wLP
2KQqx15PRzDljqdfQurXF163aWfp4h+f2lfpztZap518E1Lmu/gqv4V7dOJe
XzHnvoXbS4tB+wbXeduUAvU2z1ff4PvNY7rs+pnzY9Hd7T/sfsPqVIH/Y1HC
SOI3bxa0dEb4+s3bUZdce72R/yu3XmvDDbhdO8o6f3u9c7eG33Sfed+773U3
1vBs4a08h5i+lrwLYVhuf2v8dvVYZm7OyHN7Od+TCnA71dgKJ6cImJ9PyHue
V1nJZwZbZiG/9tvNXX4dO9XwH26W39xUdSPTZAlTY5P8js6PtzC9zJhG/8ov
pxl+8vV2Ntty71K+BdyuHXg2B9xeWnxY0mCoSvywY0nN9XPZ1wNP7sgvKKBD
yMrN6XRoA7vwq60L31rJa/hefHP7gGOvnSzxZV54lND9XiiRd7zMuCA3ec8D
zJlpTJdXF8NssGHyxfI2Ur/X7Xc76E2JdAb59bx81jLa5jY75s8r8n2ovklv
24fbec7N0JhqZvYIrmK4w1OVjPDH7Qcs2r21zSn3B6ucrjFFXTFx6amKo5Am
xn28bjYt3+Nyc8cDh7du56AG78U3t3c9rGry4nHqlrzlehv5+Onkw4zlfPl9
+vVNX26BqnSV9httdDVh7a3MWmtG7Fvy/mSI5FfjKA/yVmT0PKLaQwW3lx/J
zvdf1GqE4CpEY2epZIRzt7c2Hfn78V4LTvdIf1GvxOsYFfHR2tlUoufk5TXY
vvj8i0cqB0JWb71vdUFBQUJGWpWVv6nZTv3143K96k4/1mfOiV6Nt4w2FLeT
pt7qdqqWqeUmW3k//NzdjNUC+cJQP3kJTcuLzy02y7zM6lMOersUQcl7Qt8g
Ivzl83r5esrnB7h4l6m1Vaf30jy+3CEfZaAX+x2ZRVflL6ptKsMEBXC7dqS5
eaQ+eILgKhKtHFQywrnbmeVT/73aQXGHqZlV29I6TCZdOkw7HJ2a3GrvqoKi
3hhlyPlNdi9Ly86i1wNO7ihxC7XXTjC3a6l4rzUXunB97GVwO5XiCcFvdzsV
yQIfeeluuoK5ueZ1/fzjbtXr2yk6aFtRV98kv7S+xH1wfCS/qF7F5N/uZIae
KJcpAopHg13yf4Ed9vKTi6eHfCTCx1M+4gC3lyvpHj5c78I7TfoL1X9/Hrj9
1zamI1jZrjqvTraHntymHd7/2PnAY+cSj279LauLnk/oxcbbNmq2s7voVJLt
Wfe7TWM4P/YyXd9+7f5b3H7UiTldNHVMroA5NY55qLbUTwx+Wd+WNWpsko/b
Ft+gnydf7nX949IbOzbwWBnWhdu1A27nFn66fdtlk4lH+i043YOsq6bZI0kw
7fDPZ/6l0r3Eo/OPjph29Si9sPH3ULOdUzatpx3tM+t479VqTyU8dPvoU2/v
lmEj+Tmzw4TxOKqujZmTNtqkrw9XSzrFWD3QsizX+rtDaUF1u/WDN3qHjjkx
n26D28sXuJ1b+On2KiumsC/UT8AeHCt/bsugUzvVHCD71ydSoZrtKN5F8b6G
4vYqG5iQUkYtVUJgyaz9gQm+VmoDMl7TPdqYc/HVErZm51LmObsUj8a77iKf
D0FlodZRb7u8m932IRMX9HLfwvzl552tdvK7t+D28gNu5xZ+ul3DCE9OyM3P
Y3vdS2PMhQP001Mm5Xxvy8PtFBPOvl3s5G3bv5h13zNRpffhnL6lpTnTi90b
G+StqTaV4/eL8gkqux+WT/y10UY+v9mFO/q8ZvKBm/zqnfgg+VRpZVoRbtcO
uJ1bDNrt3pGh8elp/zhcUnOAMy1OFBYW3hX5c7635eR2CipK1bs93pXZ3YXZ
3ZlJel5ygwj/MvRRKAdVv8W3pt1z+t7bwLgr7R6dj/Q7AYKbu7xzpt0B+fcC
uL0CgNu5xaDdfkvol5SZvv6WlZoDXGR/gX5e9nLjfG/Lz+21tjKBXqWKPTeY
Of8bs+475txUpiCkhAaZIqazViOeldczkcWe9+T6TEv3Uqlvfvf1dqIDmY4H
9Sb2SuuZhrtfvm78L9xeEcDt3MJnt1da/uuAkzt6H9vWet/qD9bMKt5g+317
qslX3rym5gCX37hCP5c4XCq++sfrZrfdv6bPsW30FpwfrC5up/h6h+pk7Ip4
uJvZ1IrZ0JjZ3pm5X+w6mQxR2S4aUQ6qgYu/3ZyL2myq9X550Z6jdOqhuj0+
SD7Xjd6ftVHWgNu1A27nFj67nWK+7Tl2r8jhwbFRh57c7mG2pdKrv7LjpHtc
bqo5QPav7Q+sZVepvGIanS+OPb0nTohVtJlw8RDnR6qj2ynqbCthzgGK7EB5
nwwbmW9e0B7iK580Umvp/d+lEt7ux93ab5AiRSD/HkHbmXaeY6XD7ToCt3ML
z91OGh9+ds+vV46ucba45OUamZJEexgUGznlshlZuuqqGTFpKWeeu6g5QPqr
MC6atlNl5W+zrU5JEuVKD02Kv/DiMRX8U6+YDT61i/PD1IvbmaKeh98uyDvP
3zq6Sv40tWc+2KyT9HZdV90sFd66lNmfbpM/DbDhbvnjXNfrPPsB3M4tcDu3
8NbtZOOGO/8Zenr3tKtH51qfpp9Upf+wY0m7A2sPPHZOz8l2CxU1+3fF5ju2
t4V+KVmZJR4dmdwjQrLI/kKHg+u8I0OTMtN3PXRssWdlo13yLf929RhtmU4c
tOXvd/zN+SHr7nY2/reRmXqeufn4ZQGsHAUSxsND/twlze+4VxPHnFS3HxOo
0wbJ6s32yl/QCWL4SZ029b5WN2HB7XoEbueWdHfbFS2Z3htvZL1awrnbR5/f
d83naUJGWok7HJuWcs7jEal+3yOn1OzMhXYXaAl7E1NxHoqDpIlxSx0vp2Vn
bb9vP/3a8SvebomZ6SU2pq8AVMyT5zl2u9hJNSNldLuy5FvslV+1MuEsM/KU
/BbRTzS+0V6TOHRT1e1JwfrcvtbRap8+H586+Gx3lYwATYDbuSXd1XIKwzAt
9ymmUOTc7XdF/prsuSg+mvQekhBDBblPVFjxBoWFhb5R4V6RoQExMmoZnpyg
yWav+jzl2O1CB9WMaOv28o611iX09lTMFDGlxWfb5A8oue/GiHyYFZbyU5se
3H66m0pGgCbA7dyS/sJHdG0K09KMP27vf8JU8/33iw4PS4ovKCiIT1et86me
p58kf/b2VQ1p92rUlTO3h4lUM8JXt/9yugS3szNMchizL77ck+POWk6Po+r2
C4NVMgI0AW7nFuFBeUli7pOoWMK52yksfFWfGKKGnLw8KtHzi80DSUuI3Pw8
zTd19Oldzo/9+rnpqhnhq9upSFZ+lDYbe/T3dA/tovV++fQCQd5665bps7SB
SkaAJsDt3JL86I5I9kY/Ih/cXnfTvKjUpAr+pxDFR3+0djbnx/4k8IlqRvjq
doo7riV0udeuqInZS4wme+SXg76/gTHR061Pg070UckI0AS4nVt4e51Mq72r
Srv6pTyISUv5cecSzo+a0cd1MhUZI06W0C2jxwfz8SFwnYx2wO3cwkO3t9m3
evt9+5Hn9pocWl8x1bskMbb5nhVTr5htumPTZPcyuF3zqLSeefJM1e35Yu3v
deVhwO3aAbdzCw/d/sm6OeS3goKCtc6W327/64E4UPPDiUhOmHTpcPFxVTU4
BHp9sWXBroeO9PqW0K/66plwe5miyR4mtdhUkEnBOt3xyquA27UDbucWHrqd
ggTLPi/JI0LS6+jWyZePCOLefq2LW6jo622LvjNd3HDnP75R4W9tT23o28Hg
U7sCYmT06xHXO++vnM75sRuc2ymGnihhUDVDJL+unvN9g9u5As9LxfNSS4tx
5geliXH/FUn7D+szM64dJ/36RYcXFhaq7HNKVuZSx8tVV83YdMcmv6BgicMl
OjtsvG2TkZOt0pK+DnjKpPsfO0+7enSh3QWvyFBaGBwbxZ+ZBwzR7RRTzzPZ
JU0yafWAabmv5FUqFT2Mj/M9h9vLiWTn+y9qNUJwFaKxs1Qywh+3U/xv1fTp
1467SILZSxwjU5IeiAOvB3o+lgpkKYl5+fmk+mU3rtTaMLfl3lW0kNqwFb6z
wLfRrn/qbpq37paVMC46Nz8vLCmetkPr0s+YokvfafXbQr8JFw+9t2Ia50dq
6G6n6HyohCl/2fDwYLbZMZPPyfvhhxyXP4bjwA35r7o/Vglu5y33Yly/d+yO
4CqmP1uikhFeuV0RZO+BJ3cssDtPrqaC/O/rF0ee2/vV1oWVV0zrfWzbNZ+n
VJAnZ2VMvnyEGlORTxU7+fysh0uXwxtpyXemi385v/8fh0tU2K91tpxnc7bv
8e0fr+P+ikdjcjvFJ1vkE4hlFJvHRiVuPzGk3ni4XTvuxjz5xqELgqv49dli
lYxw7naqwKdcNlMTU6+YzbU+TYa39HWPS5ffLJiWnbXroePnW/5UbOTb7X8d
enI7Kzfnv6Jq/4q3G50U5lidpnXVb7zxrqVwu45Ra6t8Fnfbh2+U8ST8p+7y
5zTpZR4AuJ3/wO1wu0rU3/wn22einrz8fFF8NEl7psUJqupL3FTdTfOohrfy
c5ckxha/cbU44oTYT9bNgdv1GNU2yW9fpXreILpf4HY9ArfD7cWj2uqZH6+b
rSZqrJlVqYzbpPYfrJmlfrNVV83g/NiNzO1GEHC7dsDtcHuJQaX4ypvXVjlV
UCy7caVGSY/tg9sRcLt2wO1we2nRYs/Kzoc3VExwfjsq3K51lPf0NXC7dsDt
cLuaqFT0UNSR5/aWX/Q9vp3zw4TbdYn9jsxHm+F23gG3w+3qo+PB9S6S4Gdh
IeURd0X+zf5dwfkxwu1axKhTTNfD8hnaYwLlN8DW287Mu6zrE2Dhdj0Ct8Pt
mgQV8J9v+VOPUX/zn+W9z3B7ucbnpkxi8MsHf0cHMnliZsm1cnkjuF074Ha4
XcPoYbaFKm29/K+7HxLYnuvnK8Htuscm29fXz0cGMNXLZwYDuF074Ha4XfOg
6r3v8e06drDTOYLzA4HbdYy625nTt5jCNycoC/Yul7mF4XbtgNvhdi2i8a6l
625ZeUWG5uTlvTWy83Ldw8XLb1z5znQx53sOt+slPjeVT18z8hST9mp64b2O
TN+j8pteK8Pt/ABuh9t1ibqb5o0+v2+V07Uzz12cgn0eSwUvZNJHkuCbwT6n
3B+suHl1+Nk9dTb+wfl+wu3lEdU3yecW/uuqvGL/x6K83gVu1w64HW5HwO3a
RbO9Lx94/dUOZrkl3M4v4Ha4HQG3axdVNpT8Gm7nA3A73I6A2/kccLt2wO1w
OwJu53PA7doBt8PtCLidzwG3awfcDrcj4HY+B9yuHXA73I6A2/kccDswDuB2
vrkdAAB0B26H2wEAxgfcDrcDAIwPuB1uBwAYH3A73A4AMD7gdrgdAGB8wO1w
OwDA+IDb4XYAgPEBt8PtAADjA26H2wEAxgfcDrcDAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAGC7Bj1w3rVy1HnCEubk5MsIrimcEAEPk9tZdNh83aPheVQZw
weDBg5ERXlE8IwAYImSSF7Uaudb8cfT/PuH6U/UuUqLbkREOgduBccCahI2t
H9SvwVTi+rP1blGa25ERroDbgXGgbBIK9AZUMOrdjoxUPHA7MA5UTILegArm
rW5HRioYuB0YB8VNgt6AikQTtyMjFQncDoyD0kzC9gY0Qm9AOaO525GRigFu
B8aBGpOgN6ACKJPbkZEKAG4HxoF6k6A3oLwpq9uRkfIGbgfGgSYmQW9A+aGd
25GR8gNuB8aBhiZBb0A5obXbkZFyAm4HxoHmJkFvQHmgi9uRkfIAbgfGQVlN
gt4A/aK725ER/QK3A+NAC5OwvQG/oDdAH+jF7ciIHoHbgXGgnUnQG6Av9OV2
ZERfwO3AONDFJOgN0B39uh0Z0R24HRgHOpoEvQE6one3IyM6Mmhgv9jY2MTU
LE4+jwDoC91Nwsa2Dz5Hb4AWlIfbkRFd6Nr4I/ZFy0XmsZx8JgHQB/oyCXoD
tKP83I6MaMfAfn0CA31s982m16ZuiZx8KgHQHT2aBL0BWlCubkdGtOBVRlL3
tWRa7vOo+I8kAHrBdd8RPZqEjbMN2/0yeOjPQAOWL1+OjPCKVxnJMh8BtwMD
Jtn5vt5NQuHfrn+GTwDXB2eQICP8IPV0b6Y33A4MlnIyCYVn/eZxpy5xfXyG
BzLCD1LN4HZgyJSfSdgQz1iUn5rG9VEaEsgIP4DbgWFT3iZ5gd6AMoKM8AO4
HRg2FWCSF2xvwMmLXB+rYYCM8INUs5ZwOzBgKsYkbKA3QBOQEZ7gZtqypakb
13sBgJZUpEleoDdAA5ARnuBzWn4RZCrXuwGAdlSwSV6gN+BtICM8IU96jWEY
W2ke1zsCgDZUvEnYQG9AaSAjvCHvxoqWDLPojgjzygDDgyuTvEBvQCkgIzwi
y6NoHgJTTCsDDA4OTULh/W27HFk01/8G/AIZ4Q2p5lMYprepTyzm+wWGB6pE
jskLpO/9vTfeUOgDGeEJWYGnqWS/w/bHFEsTADwHvbsck+VDtaHy9RjICE/w
kd+8ZPYyL8XSBADPwVUZnCO6NoVpacah25GREnm4sWVL09f3LqmkCQCeg6up
uUV2YxHVg+Y+rwfrkBF+8MZ9qcXTBADPwV2Q3JKXKhPJ3ujERUb4wRvzyRRP
EwA8B7OX8A1khB9grjBg2GDWQb6BjPADuB0YNpgtnG8gI/wAbgeGTfk+5Qff
+ssOMsIP4HZg2ODpnHwDGeEHifta4lnYwIB5cuGM3jVyuGunttsnNt0zBfHW
mGO9ExnhVcw4+c/DO3dObxzBMMw+D1z0CAyV26fN9OgQtzqNxoxox6zsjtAw
Bp9ZgozwKrqO+6xofjBmkdlDXPUIDBc9msSmQZNGsztx/tk0rChXtyMjWsSg
k4tSU1MxaTswdPRlkm3tW9RY0pXzD6bBRfm5HRnRV0YAMER0Nwm+9evXJMgI
3zICgCGio0nwrV/vJkFG+JYRAAwRXUyCb/3lYRJkhG8ZAcAQ0c4k+NZffiZB
RviWEQAMES1Mgm/95WoSZIRvGQHAECmrSfCtv7xNgozwLSMAGCKamwTf+ivG
JMgI3zICgCGioUnwrb/CTIKM8C0jABgimpgE3/or0iTICN8yAoAhot4k+NZf
8SZBRviWEQAMETUmwbd+TkyCjPAtIwAYIqWZBN/6uTIJMsK3jABgiBQ3Cb71
c2sSZIRvGQHAEFExCb71c24SZIRvGQHAEFE2Cb7188EkyAjfMgKAIcKaBN/6
+WMSZIRvGQHAECGT4Fs/r0yCjPAtIwAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAGBDZ/t6JB7chuIqC9FRkhFdRPCMAGCKp186Km9REcBV50TJkhFdRPCMA
GCIwCd9MgozwLSMAGCIwCd9MgozwLSMAGCKcm+Q/MUPB+SeaPybhPCPveMDt
wDjgxCTKPofb+ZARhJqMAGCIcOh25eD8E80fk8DtfMsIAIYIVyaB20szCdzO
t4wAYIjoaBKttVy8dH83DQ+38y3gdmAc6GISrYVcotjhdt0zgiiPjABNyHrh
Hb9+O4KrSLO7oZIR3d2uhZOhdDUmgdv5lhGgCcnHzwUztRFcRdSsBSoZ4cTt
Klvg/OPMK5PA7XzLCNAEuN1o3K6vwhtu11dGEOWUEaAJcLtRul2/fn6ninm4
nW8Bt2sH3A63a7hlsT76fPgfcDvfAm7XDrjdONxerpe4vFMjrXA73wJu1w64
3Vjdri8Jv2sXRsLtfAu4XTvgdgNye2lXoWsRmnym3s2L3uF2vgXcrh1wuwG5
XawnvZf1w/VO6d0I3d6sduT04YmHTdOdbLPcHycd3ytpVY/7vdIhI0AT4HbD
crtYZ71r9/kyeqWrMYnhul3S/uvEA9vyoiIUx5J+x0HcvA7nO6ZjRoAmwO0G
53axtnrX5fMFtxtcRC/8NS8mUvlACnNypF1/5HzHdM8I0AS43RDdzkaFiV38
Lt3QZBxuTzy8o/iHPev5E853TC8ZAZoAtxuu28Ua653zj6cBhRG4Pfns4RI/
7JmuDzjfN71kBGgC3G7QbhdroHfOP5uGFYbu9thV80r7sOcnJRhcZ3uJGQGa
ALcbtNtRtFeASQzI7aG9mhZkZqj5vMf88zvnO6l7RoAmwO1G73a96P3dOU0Y
tNvT7K6o/7znSoSc76TuGQGaALfD7Zq/Eecfc05MYihuD+3xU2F+vvKeJ53c
X5CanO3vrbwwYlwfzndVx4wANeSlJsbKZLGpeXC7kbm9tIU6BtzO/0jYtVZ5
t/NTksOHdBA3r5N+x0F5eczi6Zzvqo4ZAaWQartxBMOy0Q1uN1y3qxG4vvT+
DnbjG67bMx/fU+xzYWFh8tnDYX1b0PL4rcuVDydqzljOd1XHjIASyQo8TVIf
seK0m0+gNDELbjcOt2vXoExv8S6IvUSTcOz2lnU1bJmflKi823mxUaT3LC/3
/KQEUj27kF4Y3O1LcLuGiMynUL0e++pXuN0I3K5jG83fyLitXppJuHV74oFt
mjSTtK6vvM90FGkOFgXZWSrHQrV98RXDB7eXTRwQMbp7aJ/mnP/7a5IRUCI+
Zr2Zlmapr36VHjzrUK0JgqvwmrZYJUFlcrveW5a2+rujd365vWktqsY16UWR
dPhGZZ8L8/JUDqSwoEA2vh/bPrRX08SD27L9PBUlPQsV+Rn3bsj75DX+vlDx
GQElouL2fYvPMu3OILiKSQN2qSSIb727xUdpOd+lCjYJhxkJH9KBdiA/LiZi
ZDf1LVXq9lTLC8U/+wm71spbtvsq+bxZYU62elHkx8fGrp7PeTpKzAgoEbid
V2Eoblf+lfNdqmCTcJiR6P+byO5DYW5u+g3rhJ1rKGh/Mh/fTb9pE7fhb0n7
r1/veWwU27ggIz3dyVb5EOhPMX/9Rm3Cf+6UIxZoross98fSLj/wLSOgROB2
XgUP3f4uFOdlMgmHGYld/of6j3NebHTU3PFsY7I9uzBXIsryfPp6/y0vUK1O
DcIHt89PSiirMXLDpWGD2vIqI6BE4HZeBU/cXvzaeA4/y9wGv9y+bM5bP9GF
BQWxy+ZS45jFM9gluRJhlpf7y523Mmc3Je3UgCytWKsgKzMnyDfz2aNsHw9W
+GkOloWFhXmR4cXfgk4WUpNv+ZMRUCJwO6+CV25/dwZMy2QSDt0e9fsvmnyo
C3Oyw4d3Ebf8jH0MR0Fqcvrt6/8V9ZkrOm1SLh6Xt8zLo/I+9do5Mnm2v3du
RGiOKCjj3o2C7GzZ5EGhPX5KuXC0xLfIuO/En4yAEvExGwG38yd44nYx9F66
STh0u7Rbw+If4fyU5IL0NJWF6U62YqU6nx1LJVGz2wn/uVNhfj4V6slnDys/
hklB8umD0k7fiYsuuSxNHYrOH84zAkoiz3Y209LUTfE73A63s/Gu3aOkuUm4
HQEpPvSZGy6NGNcndsUfuRKhYmFBeqq4WW1qz46i0j7Tz9hV89iNJJ83y3x8
l2pvNWqgE0HK1TPZPh4qk9IooAqfJxkBJZD4sCXD7PNQlO1wO9wuD1hdjUm4
dXuS2Rv/Q/IT4qLnTaLlod0bq1zHGDG6Oy2XtP0i64VbrkSU8ehO7Oo/5Rtp
VjvjgXOGy+08WVia3RUSeOazR4U5OSqHqXJbKwu9BZ0skk7uT79lT68Vl8dz
mxGgQqLUbWNvhplinqq0EG6H28Xv2N1JZTUJt24P7dlE5S6kvNio0N7NEvZs
JHsrL086uptdRdLuy4z7N1MunUwxP0G/Rkzol3zmUOzyP1Q2m2pzSb0xstwf
h/ZqqlglrG+LmMUz+JAR8CaJpvLZwVreefPkDLfD7coBt/PN7RTJ546o7FLm
M5eC9NQcUZDyQlrCTg7GRtyWpYkHtkl7NY2cNVo2eVCJW07YsbqwoKBEX2S6
PpC0rs95OkrMCFAhK1FkNoVheu+LVVoIt8PtKgG38y0jkrZf5EaEFv9Ep12/
lhPkq7wkRxioPCeMtHtjKtrFfVuEDe0YNXdc3MYl8VuWxS6bK5s4QNLmc7ZN
1MxR2X6eyhspyMpMOrkfcw4YGFkeIxjG1O117Q63c+z2/ktXtGR6b7yhmNSJ
c5O845EX8YCHGYkY1a0gLaX4Bzrj4a1Ua/PC3FzFkoLU5MRD2yN+6Rnas0n4
mF4RY3tLezcNG9QubvM/8l6aK6fZK9jlHem3rkf+OpTdPp0RomaPiVk0LXLq
EJ6U62oyAkoi78Yi+bTtit/hdo7d3u/vKfKusn2KQRA+mORdjjzpHX5mJHLq
0BL1TjJPuXwqxfxY5rNH+QlxBZkZ+XExma4PSOMJ+zZLOn0X9ceEsAFtaAuy
KYPz01LSne3SHK0Uq2e6PVTuyeFhFM8IKJGi69v3KQp3uJ1jtw/YJbo2RfmO
A56Y5J2NvGgZbzNC5XeOMLC0j3ZuuDTjgXO6ky0V87kRobTbbAUev2ttwq51
7Bbi1sjnlKa/plw9o1iRThmRM0ZyfnSaZwSUCO5L5VWMatuDShJzn9e9ZPwx
ybsZoZd+53VGWn4Wb7oqPyVZzWc8298rcsaIl+2b1sp8/iT9jqO4xafyX5vX
yU+Mpzby6yHtrypWKcjOipw+nPuj0ywjoETgdl7FxL5rRbI3+hH5ZZJ3L7JE
L/ifESrIYxZPT79pQxU4e6tRQWZGdqBPyoWjsimDlVsm7FyT7fsiR+AvmziA
XcJOR/BfUV+98o1R+UkJod0bc35ommQElAjczqvg4XUy73jw8DqZtwdbkxcL
+SWO+flptpcLc3LityxjF6baXFQcWvJ5M+UjzbjryP2xaJARUCJwO68Cbudb
GKLbJa3qRc0dH799ZdzahVGzx0TPn5y4b7OiJme71pPPHGIbZz57pDi0dCfb
vNho5YON+KUn54fz1oyAEoHbeRVwO9/CwNze4tOEPRsLUkvtfs8J9stwuU0v
Ui6fEhc9dKkgK1PxV3qd5mCp3D7N7gr3B/W2jIAS8djXm+kNt/Ml4Ha+hQG5
XdL+a+UivDiFhYVUrrOv2bo9Yeca1aOzNlf+NT8lmZ1zjD8Bt2uI6Npshlmk
mKMfbofbEepNwtuMZNy/qf7DnmpxPj8hjn0dt+kfWkVlmoKs508K8/KUK3ki
Ylwfzg9NfUZAieSJzOX3Acw2vXHnoY80VXZsftTu/yG4itBNnVQSxFuTvCNh
KG6PmjlKeSdV5nWkip12W/li+IgxvcTN66jMHiObOCBy6hCV+Wpilszi/OjU
ZwSUQp6H+YqWTBEb3ZLPzEi9zCC4ioTdzVTSw0+TvDthKG5XEXL6TZvk0weT
zx5mL4ZMPnUgP/71xFF5sjD5Ws1qK5aQ/BMPm4qb1hK/eeUMkbBzDedHpz4j
QC15WampWVl5cDvcjlBvEn5mJNP1gWIP81OS2Sl8o+aMLUhLyXxyX+UQFBdA
qsw5lnhwG0W6sx2pXrEwYcdqzo9OfUaAJsDtcDtCvUn4mJHmdfKTkxR7SPtM
Fbu4Zd3I334uPimBvGh/Nakj+zwmBbnhUmWrs8StW8T9AarNCNAEuB1uR6g3
CQ8zErvijxI+y2/eiMRSmJcnmzRQsWLE6O6lTdiugG+TD8Dt2gG3w+0I9Sbh
W0ZkEweUOCFkcagmj1v/l8rqScf3qFuloEDS7ivOj1F9RoAmwO1wO0K9SXiS
Efmdp6ar5H3jpTyrWgWq2FWeo6eIxP1bC7JLnqEl86kL50f61owATYDb4XaE
epPwJCOSDt+o3GekhpxgP/WzB4T2bKI8za+CmMXTOT/St2YEaALcDrcj1JuE
VxmRje+bfsdBTelOVo9d8Udps4epRNy6Rcrr5oaKNVyR24wATYDb4XaEepPw
MCPSbg1jl81NMT+Wcd8p89mjjPs3aSfjNy8NH9qxrJvKeHhLcaRRs0Zzfmia
ZARoAtwOtyPUm8S4MxK7+k/2MJOO7+F8ZzTMCNAEuB1uR6g3iXFnJGbxdPkx
Wpmz96jyMOB27YDb4XaEepMYd0aSjuxMPLyD890oU0aAJsDtcDtCvUmMOyNh
g9pxvg9lzQjQBLgdbkeoNwkywreMAE2A2+F2hHqTICN8ywjQBLgdbkeoNwky
wreMAE2A2+F2hHqTICN8ywjQBLgdbkeoNwkywreMAE2A2+F2hHqTICN8ywjQ
BLgdbkeoNwkywreMAGCIwCR8MwkywreMAGCIwCR8MwkywreMAGCIwCR8Mwky
wreMAGCIwCR8MwkywreMAGCIwCR8MwkywreMAGCIwCR8MwkywreMAGCIwCR8
MwkywreMAGCIwCR8MwkywreMAGCIwCR8MwkywreMAGCIwCR8MwkywreMAGCI
wCR8MwkywreMAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
NQhue6/rtcNw49GMzYXr1xtwyGQqGclPD80KOozgJDKe7cqNDOLkkwiAfnHY
YMEwhww3tjP9ChnGgOPpU5WM5EY/TLJrgaj4iN3RLKz/TxluVpx8EgHQL3A7
3I5IuNQ8ckaTsO4/UcDtwDiA2+H2dzzYcp0VO9wOjAa4HW5/Z0O5XIfbgZFR
3m6vXBluh9v5GCrlOtwOjIzydvuvv96G2+F2XkWJ5TrcDoyM8nZ7UFDiRx8d
g9vhdp5EaeU63A6MDH25vXnzS507q27qu+/O0Vv8/LODyvJvvz07YIAd3A63
V2SoL9fhdmBk6MvtVaocDg9P69Tpja39/vtdeov9+72VF37zzVmJJOX778/D
7XB7hcVby3W4HRgZeuyTsbUVp6TkKOv9yhUhvUVAQIKy2MXiFAp9vSncjlAf
GpbratxekCvOS9qJ4Cry0y0ryIbGhR7dPn/+A9og6d3E5Br9WqnSofj4LPZd
vvzyjELs9KuZmR/cDrfrMQR2U0tcrnm5rsbt+Zm3s6T1EFxFTvTE8hehEaJH
tzdubM5uk9V769aX/fwS7t4N9/SMmzDBSSF24pdfbsDtcLteIs66ufDW0tD7
S1WWl7Vch9t5G3C7dmjn9ipVDn/44dHiy8PCUmmbd+6EDxhgR22oXG/T5kqD
Bufef/9w+/ZXzc2DCwsLCwoKa9U6obLi//53pEaNEjYItxtfRFu2CLL7NdJ9
b7jXRZnLykgrk0Tb5lpvTXB7ZeSLowk2b2xBi3IdbudtwO3aoXXdvnz5kwcP
ZKtXu1GJ/t57h9mFhw75jB594/PPT+/b5x0Zma54l+Tk7PPng5o2vdix4zV7
e7FiI82aXVy0yMXBQXr8uL9iI3A75/otp4ixbBZh1z/Ktiu98L38s+DuOj+3
K7JwaeCDf2OttNkgFe2RwXejbDorlmhdrsPtvA24XTt06ZNZs8aN3UhSUral
pWj69Dt16pwYP94pPT23xPfKzy9YudL1ww+PDR/ucPZsoEL+Fy8KtBM73G4Q
EWQ9Vvxkv8j1yFPHneJ7qyK8r8SEPJLdXyi06CsVC/zuH46LDosLto+y60Gu
LtOWo+26x0UKoy2bsb/qUq6rc3u2Z2FeeH66fW7ixpyo0VmhP3Kuu3cq4Hbt
0LG/XaF3YuBAu6lTb731HU1NPRo3Nk9Le+l/XcQOtxtEhFu0o0JdfLGFwP7X
wGdW/k9t/G9vTYkPTZD5RgbYB7vsD3Y5FBdyJz09NUnqEvFgcbxmho+ybp8g
fZQc4R5r1Vz3cl2925V/lfcr5gbnp13JTViRHTk4S/oN5/Yz7oDbtUP3sdTV
q+V6v3JF2KjRhezsfE3edOjQ6+xJwdw8WBexw+18jkTb5mRduXhtmodc6SJy
mhfiaRsjk/g6bwh2+lvoeSNWJggNfCi5Pj7A1TzwnmnI3TVRYcFxcXHB7lZR
ATbJ4W5RHgdlNt2kTtMjrDqpbJy2GetzKi8vL/zW7LAtTQR9Gom6NhYM6hjc
v215u12FwsLcgmyvvNQzuXELs2U9s6Sfcy5DIwu4XTv0cp0M6b1168vs1eya
4O+f8OGHR0+fDtBR7HA7byPSrneU57Gk0Cek6Lggq4hH62T2/ZPCnsSHewfZ
/RYe4Ozz8HRCXFRCQkJ6erpEIsnJyYmMjExMTMzMzIyNjY2Pj8/OzqZ/jbBQ
SUFBQajgeZS1ifL246ybp0Z5JYZ5eW2akRwdlZ6SHCcWBZ4/Ieqha/VeVrer
UFiQUZD1JC/lcE7s7OyIDpyL0QgCbtcOvbi9du3j5GoNi3aWNm2u1Kt3Sve3
htt5GFEWzWJDvWL8r0U+NY3yPJIgvp2RmpCRkZGXK9d1RPAD/8fnIsLEVHWT
2JOSkqKjo+lnTEwM6Z1ekN5zc3OpPamelshkspMnTz6/fznq0Yoo63bhV5rG
WDaTXm2TkhAdcudmXk5OekxU0Jq/hIM6irs1roA+mTJRmJ+Yn3knL2lXTsyU
rLDmnHvSEANu1w6t3V69utmAAXY7d77w9IyztBT17m1Tpvf988+HGzY8EwqT
Dx/2HT36RvGrIuF2w43wqy1DAp6EXmmZaNs89HJTP4e/Qq+0CnX+PdLPKjMj
jZBKxZkZ8stlw8LC6FcSeHJyMvmcZE7Cp6KdXkQVIZVKqYGXlxcJn2wvk/qn
xYlCBc+SoiKEQiHV9pFBAb4TBocs+C3GyT7O0yPSyV58wDRo0wqP0X354HYV
CvMiisZkN+VE/4IxWbi9XCmr26tVM1uw4OHdu+HKVTr5eeJEpzK979atz//4
477i14KCwmfPotevf1a7dtkkD7fzM8JuTPK8vkJ0uX3EzSkhzy9HhwVFSbzE
3g5BT6/KJC8SE2KDg4JI1ykpKTk5OeTwgoIC0jvZOysrKzw8vLCwkPQeFxfX
rVs3V1dXEj5pnP5Ey+k1CZ/+oSKFwbLH9xP8fZLCpAmCQOnujeKF08VzJ4b8
Pk44oodE2xq+XN2uTNGYrCA/7SrGZOH28kCLuv3994/06GG1caO7q2tUfn4B
beTs2cDhwx3K9L4rV7r+889j9rWPT/y//3oNGWL/wQdlvn0JbudVyIc4rZpH
WzaTXW0W7rozLTmOhJyamhobGysigv3I4exhJiUlSSSSmJiYhIQEqtvpNbmd
ltOvuUVER0dTAX/r1i2SPy2nX/Pz88nwZH7Se0ZqSoRUmpmWFvvonnjjUmHv
5nq5SKYi3a6C0pjsIozJwu26o2N/+yefHB8xwoEq+SZNLpbpfceOvTl58q3J
k5117HWH2/kTYTa9g132y/zsooQPY8L9Y2TCqFD/iNCQuNjo5CQqwxPDwkJJ
6WwfO9vNLpPJqDin16Rx0ju1oZqcfpLb2TMCvSaZ0z8L+Z+WUKnPds77P7z/
aOYEQc9meulj54PbVSgak3XNSzmi+5hsqmv9dK/6nCsabq9g9DKW+vXXZ6jk
FomSNXzTnJx8Oim0anVJ97eG2/kTIY6zoqxNYiybUURZNIu06RZiPVgiFpHM
qRqnAp78/PTp04CAABI4eZtEnVgEiZ2WUDNaQsU5FeokcHlxnpEREyEM87gU
KfRPkkXQFmhdUj2Z//6Vi95dGunX6rxyuwqvxmR358RMLeuYrGzr19I/v0n3
5d7ScHtForvb2UnAZs++N2fOPQ3f9MABny5dLBUzRsLtyhiu24uHt9Mmnxdu
RYOnUtI7/aQqnR0zZXtjqBSPioqKiIigAp71PP0qFApJ8vLOnFihwLRzcN/G
nv9u9e3WJMTLKy0+Tj7YKpWEP7pXHmLnrdtVkI/JZlzXcEw2csfXnp82DOr1
feozg6ze4Xbt0NHtitkdZbL0jz8+9uCB7K3vKJGk1KlzwsUl8r+iGSNVHucB
txuT20OCXpClk5KSSN2kdPI5/RSLxey1jtIg12h/qwSZPx01le7JycnUgGxP
r4OCgsjtQhcn8aZlwhE9BF0aBfduIVjw26O1y0RuT+JiY1OlYkHXRsKujXwG
tA+e/6tUfz0zBuF2ZZTGZFeWOCYr2/Z18KDvovd/xbml4faKRBe3K0/bSxw/
7v/ppyefP49R83ZhYalNm15csOChYomOeofbeRsy684ezx5THR4SEkKVOXsx
DNmbyniq2OX3n/o/D/G+ERPiQnbKzs5mTwGhoaH0MyUlhVYJ9vIMOnUkxtUl
7I6T//L5fgt+C7xhn56aGnLvVtj5Y8/HDgih5UM7S2yvBq1cEKonvRuc21Uo
GpP1zks9qxiTpbo9+f7nKY8NsmiH27VGa7d/+6380XgZGbk3b4b+/fejli0v
V6p0aNiw61S9//uvV06O6n1M9Pm9dElQr96pESMcaPXvvz8/Z849CwtRYmIW
6b34s1bhdoOOGMvmwtvLyM9Uh1NBTj/p0DIyMvz8/OhXWi6VSgOdV4WKPKVu
hyIfLpU+P5WTk0NVPXshTXpamnyMNSEhWhYRcu64zy99g+/dCnj0UPrgrvjc
ceGZo4JJQ4J6NY8JCvA7/G+SMFj2wl20e5No0hCtL300Grcrk/rEPbDzYNGE
CcEDe4dM7Zbm2ZZzUcPtFYbW87fPnn2vd2+bqlWPKC+/fz/C3T2me3er+vVP
zZ17/8QJf1tb8Zkzgf/887hhwws//WR+/bokLi6TzgKKVSpXPtShw7X58x/Q
SQFu/88o3B5j3TrM14ZK8fT0dPI5e9tRYmIiWT0sLCymCFoY5G4nsv1FEuzp
fWNtwJPzoY4Twg8OFq+YE7Jqof/koSHr/5EFBUSESuNiooX+/l4nj/h2byIy
Pym64+R+7WKAxcVof99EP6/QS2elW1eJ/54tXjrX9+Au380r4HYFkt8X+zbp
Ftx3TEDnIV71miXZOxeNyd59OSYb3oJzb8Pt5Ycen7v0wQdHFeX6pk3uTZua
jxlzo0cPKyrUqSyfPNmZvRieaNv2ir7eFG7nWyTYNBfc3RD+aJ3U40JUVFSg
v1dCQkJAQADpPSQkhNxOko+Ojo6NjfX3dvV2uRAl9ZSEBIrvbZX83kZFs0H9
28mePKBK3tfXlyp/b+ur4sWzBP/M9e3S0G/uhMAV8/1H9xZ3fX21TGi3xj5L
5+nd7U4OOzu1r/Xn3I7nTy4M8r+tuESf5xTm5QkGT/T6vIVfi54BnQZ71W8e
9vf6Ym1kRWOym/l8nyzcrh16dPuQIfbsNtnZHWvXPlFQUMgu6dbNknk1YySx
bNkTuN1Y3R5p0TLcslOMdZvUhNDCwkKPp/dycnJI72y5zl7uSD/J7ZERkuTk
JMmNqeKt7cNO7BE4XRf1aKqq98EmUV4v2Mtmgi6cDFo43Xvyz6Eu9/Pz82nj
WZmZAtO1yj3tug+qFne7vfVWRolPPq7ct0e9ZX/1tLyyNiKUvyV9XlJyQXZO
VpAo4ZJV+nOvTN/AnLCIwtJPTEVjssL8tGuljcnC7YaFHt2+Z4/Xf2/Ox+7u
Lh9XTUvLff/9l1037NS+t2+Hw+3G6naKeOvm0V4nkiL9Ir3PeT+yDg7wzC4i
PDycPM/OIUN1eHp6Onk+RiJ88cdkQZeGouXzJCcOirq+lnNI18b+a/4S+/lE
BAcFPLwvdnYMGNQx7Nwx+leSd+kEBbF9PoIJg/Qyiqqh21WoX7fK8MFfb1wz
9Ib9rvjYkIr40L6NVBc3ycxFgd1+Dh4wLubASencf2KPX5DMWBTQYWBQr1ER
K7fmhEe+dSOFhXkvx2Tj/+L2Plm4XTv06HY/vwSVB21s2+ZBb3H9ukS5Gek9
KyuvenUzuN1Y3R5l0UziZR1p0SrBpnmYt4VUKpFFyLvZ04sICQkhM0dGRspL
d5mMSnr55TE+3iEnDnrPnuA9tLNCs8I+rQTrlnhNGxn28G7g9FFhztcF9Nfn
8n+xlJQUKv7ZG1qDLS8Jf+7KldtV+OG7auNH/7hr21iXuyfS0+Iq5lOsIC8+
gUzuWauRcnh/09anQbs3lnzdJu7EhcK8PM23XHSfrFteillO7JzsiI5wO//R
l9s///x08Sco9e0rnxxy4UIXlcZr1z7t398WbjdWt8daNZdY9mVfy2x7SJ7s
83/uJJ+zMTIyKioqLy+PZP5f0ZQyJPzo6GhaKJFI6NcwqTR0//aQbm/IVtqt
8YvRfXxMfvQZ0jncwTrcTT4NEZX9tG4WVQl5eTHeHqG3HEO6ltc1kGVyuzKV
KzMtmn4wc2qLI/tneDy7lpubVR4f4WxxaMzh07FmZ0PnLff+spVX3WaenzZR
0btK+Pxg4lm7sV/TbmELV8k27o7ed7ysb/pqTPbfChiThdu1Q19ur1//VPEH
bVSrZpaZmdes2cXi7b/66gzcbohul1zrFnqtHRXkxf8UbdWyxFUinKfl5uaG
Cd1FIhHV28nJyVSxk5lJ5vQ67hXh4eEREfKZe8M8ngkP7RItmimcNEQwfoBo
1ULhxVNxXs+jPZ7RKiJ7q4yMDHbeSNpIiJur597tiYmJrtPH8M3tKlStynRq
X2v+nA76HZMtzM+XzFgkd3WLXoLBE4N6jvRv28/n23aliT2w6zD5xTMDx1Nj
/zZ9g7oPz/D01XUf5GOyDuU0Jgu3a4ce+2RKjLNnA8t1+3B7BUf4tVb+j07H
BDtKnH5X+ZPg4W6B5ZDiq0RZtooSPRQKBdHhAlI3eZ7qbSrUqeQmP5PtExIS
QkNDyfz0VyrIBQJBYGAgaZwW0q9U2JPMpVIpmZ8cnhAVFf7ofrjbo1CBgM4R
T8z2J0gltJHoe848d7sKH39UuU/3usv+6mlxeXW41EPHD3KWIMSvRU8qyAVD
Jvk1607S9m/dh4Tv27gLq3S/5j086/xEf/X+uk1g5yHCn6d6ftY0dMEqHd+3
OEpjsquyI4foPiYLt2tHebu9QYNzcLvRuF3+rA3rPgKL/iTnzMz0kIc7wtyP
im7OEznMklh0E974PUYmirZqpdxeeG2AzHmq6NE+KlOD3N3I1ZGRkenp6fSC
anX2uve0tDR2dsecnBxyPhmb9O7v7+/t7R0fHx8WFkZWJ89TS/oT+68UFhKi
uJuVfo2XRQjXLzEst6tQv26Vnwd9vWH1kOJjsqn3H1NpnRsTW9pVLjkRUfQz
Ly4h0fK6T4P2gqGTyfOenzaJP3uFdbtX/eYRq7aFjP+dXgf3G0OGpzYFWfLH
YKU9ekqVf4mbLcjJyfALSrruXKaeeRXkY7I5Pnmp54rGZHtpMSYLt2tHebu9
vANur8iIcJ6WkpIcHBQg9L0v9HMR+jwIenHb3+uBr9ez6ChZuMCV5Cx22RFv
/bLHJs66ufTmb1F+12l5ZmZmiI9XfHgYe7MqiVomk9E5gp1JhhQdHh7O9tUE
BwdTbU/CpwYhISFUk7Ozuwe/eCHx86WWeUX8V1Qi/id/sEuBaPdGfU0pw5Xb
VfihQVV2TPbhnWPiRSukc5ZIZv+daHG9+Ec4NyaOHK68JPWha9jf6zI8vOl1
4jV7eQf7dx3ovECRcNFKtmFXQUamonG2ODR6j1nxzVLjsMVrJTMWCYZPVXPl
ZFnRYkwWbtcOuB1u1yRC7YdFvDjpedcsOtSXamxyMpXW+fn5UqmU7TCJlIWF
BbtJgx5FysKf2m8OebA+zlq+Yqxps5C+jYXj+vv983/UXuznQ7omt5OWydgJ
CQnsA1KpmCeHhz99EvvclWxPS6hQj4qKCi0iNirKe+dGYa/mQeP6x/p40g6Q
+enfiur/iNs3Ajav1OMs7jxxuzJTqtXc/8WX51s0tpw0qPiYLBk4K1hU2gc8
+ebdiBVbZBt3U1VfWpsAk0F5CYkqC7MlYbRl6R/LBMOmaGIS7Sgak72nfkwW
btcOuB1uLy0SbJpH2vWKer4/8ul2oYelRPCcSuvs7Gy5ySMjqbSmn1SEk2ZJ
1+RbKq1ZLYcJ3aWBLh626yXntgeMHeC+fIFg/EDfqcNjxSHSFx7sGYHqczop
kL3lXeXR0VTG+y2YQYoWdGkodH0cEyqNkYhFgQGp0VFB1teEvw5X3KAk7NrI
f8qwkP3bwk4dClk0Q/cJZPjv9nZVqjt+8t32GvU316g/s1rtqlUZk3Y158/p
cO7EgoBn9j4N2rPfX0okydrR+9u2gV2G5qemldYmZOJclUtlSOz+JoPCV2yW
zPpLPO3PsntFSwrzIovGZLfkRI/JCm0It+sC3A63lxhCi0HCJ0fiY8ILCgry
8vI8nzqTydlJA9gJG6l0Dw4OJkWzl5rTC/I81eHsPGC0SqhEHPb0ifDxwwdL
/s/X3jonJyfAyzPMx4vWpY3QqYGWUAFPqo+Li6PXwjF9SK3+o/tInrklREfT
SSTo3y1kcr0/Wcng3F6VqfSk5o9ra9SdX7X2w09+GFf1E8Wfer3/gVPN7/p0
r7t0UcljsqR0z1qNJL8tUCOB0HnLgweOV/yaLQ3zb9svbPkm8fQF/h0Hxp24
oINgtKdoTFaUn2aRm7SHkx0wdOB2uL3EiLKQPz4p+GLHkKAXbk/uk3vZLnFS
d2xsLNmbFE1KJ7GT84OCgugUEFEE+9Bq9lkb/xVdiB4vi/C5eyvY5b7I04N+
lUgktCJb8LOnA/qVNuI/tAup1XdkT58x/cn8fhaXol88E+npqnWDdjsxp1od
UvS+D744+OEX9OLP6p8qlt/55HvllvU+ezkm62i3Iz42JOX2Q/lFMi16qpGA
9I+lXvWasQOmmX6BPt91oFUi1ph6N2jv36pPfkqpBX/FUGCwc7VxS6GjI/d+
e5fjyZUVLZneG28oulB54nY2RDfnkclTkuL8/PxIwvIb/AUCKqhoISlaJBKR
lqOiokjF9KtQKCTVk9XJ/KR6tsKnv9KKVMbTz/+KHntKDeiv1J7cTicL9omo
cZGRglf1eXDf1vGRspCJg4PX/R082KSi3f74gEpGQoLM502v0ant+9WrcaH1
Vyyt/hkp171mQ/r5rGZDduGaGvU8ajasxlQqba2N9eqz10C6XN5V2n2yorGz
qAF7sU3Eqm0vr4T/tAmJnWr4cnfQ2yhIt1LJCNAEuJ3jeGg+hT6BLfelvsoI
f9webd024M52b7cb5GH2ydT0ggr4omdthAX7PhH6PRD6PhT5PYyU+kfJ5Nei
BwcHs5c4svcl0eHExMTExcVRfU5r0RbI8OR8xQgs/WS/BQQ62CrfWOr71++C
Hs1CejbX4wOVNHX7gz0qGcnPvM12/KaH1HVzqH1o20fTJ1Rv0aTKe+9VjNRf
s7pGXVa8Hq/cvqFGPfq15XulnnXmVatz6sOvn9T8sU6l9ypXZpo3+WDGlOaH
901//vRKTk4Ge4B+zbrTRrLFofQ6fNkmxb2rObLoivZRSRQkX1XJCNAEuJ3j
ePpUdG0K09KMh26PcD8sf56pTC529nJEsVgcGhrq5WoXGx0WEuwp74cJF1MZ
Hx0dnZmZSeaXBPj7PXVlx0bZq9bJ5PQnWp29fJ19LraiH4bq/KgiQravqWCH
q+mTUcmIwu0qkRRU965lrR1rPhw/otoPDSpC9CZVaihuL2WXLCsq5udUq1Pa
KpOrfnL8w6/+qFb7m8rvq/yJHZNdPunlHazZMnndHr5kA/tryKQ/ODFScQqy
PVUyAjQBbuc2IvZOoE+Zuc/rK9D44/ZovysxMvlliuTsrKwscjvZWOBz19fj
bmZmuvCJWYTbDr9rc8Kun5HecYr086a/0v6zXehUjYd4eUSGiLKzs2lF9s5T
OjWwj2EKCAhgb1Oi5bQwQigQDGjHudXZEO39WSUjpbldJaJ9Prt+vub6JR/8
PKDq53Url4fbW7xXTeF29g1+q1qLXt/85LsqpawyoWpNamD7cYPStjn/k1qB
bb59XrNhzY8q9+722VWT1uz2Jb8v5sBHJRFuN5l5MyNAE+B2biP33nWR7I1+
RD64PdG2ucxpfLCHvcezx2Rj0i9V3b6+vgFe9+JiwqXup8KutIy3bh5r2iys
/0slCrs28h3dW7h/R4jro4z0NCrpqVanij0hLi7QzTVKKgkLDAh68ZyUTqcA
qudps1S005apvA9a/4++nnaqe6TcPaGSEQ3drhLiZ59ePfbJ0nkf9On2v1qf
lNofXiaavldV4XZW5t2qfMD+Sg4vcZXl1eXdOI9r/lhin3zNSpXdm38dNvUz
q8++ZpesedXts7P258MGfrV+5SB2TLZitfQGOfHOKhkBmgC3cxz8u04m1qp5
1NNtOTnZZF3Sb0xMTFRUFIlaIBCIg5753NsfY9ks4WLzyOlNSnQjWVo4vJtk
7V9+puuinz6mup2dsD226NkcdI5gL25nJweTP33phr2gSyM9ylnHKOGZelq5
XSV879U5vffj+TN0GpNVdnvVIld/WKmyv8nXAa2+dan5w1fFel2oxb1PfmDb
D/vfx8U3uP/rz2jdsKl1N//08rrKdUUd+BQbatRTbvn9t1XHjfph59YxD26b
VfDcxbhORjvgdrhdEdLLrUS3l0YG30kIexYtuisOehoYGEhip+qavfrFx8cn
+Gpv5XJdfYR0bSzo0ypgcKfgv+d4rFwoOHZAJBJR3c4OudLJgk4eftNGcu7z
CnC7cqSH1H3qWPvwdvmYbMumZRiTbabUJ1PjVR3uPLam73ffC3t/ZfnJN1SH
K7evW6kKtbT6uMHzmg1X1qirsrXZ1WrL/qgj6v9l5Pw6jf/38ryw4ZXbN9eo
X9pusGOy0yc3O7R3mvKYbDkBt2sH3A63v9EVY2USad0x7HKzpBhxYIA/ldlU
YJOQo6Oj09PTPR/ZBU9rwTrQr2cLwZh+gh7N3tqdIu3WWNC9Kf30+3U4e1tr
UFBQREQEbVy4ZaWaFWnLElq3b2vBoA76mp6dD24vcUx259oPJ7xtTLZzlRrb
P6h/+qOvD3zwxWevNN63TrXw3z4LbPutaMCXpHHFmGmtSu/Vr1SF6vadNT7f
VKPe3Gp1Pq/8slf+vVeDsJ51fyS37/noc8Vb/FXt0xMffnX4wy//LH18VoWq
VZmObWvOm93h7PE/A3yd9P48WbhdO+B2uL14hFn3zMrKCpcEkYf9/Pzy8vIS
ExOphg90ucf2nwgmDBJ4y+8wjRMGB/46Qr0tBQPaik6biRxsIoMCi66fjKBt
0skiPDxc2KuFujOC6TrBdZus9PT4EKHXzLHG6naViPb5zOHCyzHZL+q9UYf/
Xq32xhr1yNWrq9dto3Td478ffCEZVV8yur5X3R/df2gwrXrN/zGV3mcqXfjo
m/nV6rjV/HFN9bpHP/yS7ZYxqVLjaq2vqdQPaPVtwtaP3Ov+8F3l/ymcT243
/aA+nUFWVq9bvJNHEz4uGpP9Z1GPa5dWhUncdXcU3K4dcDvcXjxCrXr4e9wK
C5WIxeKYmJjQ0FASclRUlMe/W9laOtLeksozv/MnAjo31OTW0cDh3YNu3UhN
TQ0JDpJIJOT24OBg8rz/+qWCAe1og6FFoWgv7tb42bhBubm5CQkJQsuLwmFd
KkbsfHC7SrBjssvmfzC0S9XtNeuRpdfVqEdV91SlwdPald67/+M3Kfs/iVxQ
O+y3z3y///7up98trf7Z4Pc/Wluj7sWPvjn64Vczq9aaWa221ZdfBrb7xqv+
D/GbP4r6q5Z/0wYTlbbT7L1qf1f/dG2NevKoXrf/+x9q4XYV6n1WhR2TdbA1
1W5MFm7XDrgdbleJaMtmsZLHIpGIfS5GbGws1ecpKSlkeIHNVXHXRsIxfcm6
ycnJLyYOEa/5K2CfqeTMkcBZ40qt26nUv+Mkc3aIDfQLcXtC2yGxC4VCf39/
+joQ/OBemOVF6cmDtCk6TZDn5bOBbVlJXxzy8/Njw0I9Jw4RDGhPJ5F30+3K
kfqkvs/qLxzG1f+3f52+rauyY7IzqtU+/dHXI/73sWuDb31//E72Rx1Bj6+o
Jvf59gevz17exKropfeq/2P0kloU1EbY98tVNeqS8P+s/qniEso2VapPrlqT
hN+hSnXdxV6c77+tOnbkDzu2/PLgtllaaowmjoLbtQNuh9uVI8aqleT+amHA
i4RYGRXt8kl0IyKo0qYXVLdnZGR4z/vVc9MK+fQyCQnpyUlUvZP24yLC4yIi
ggd1LNGWvrPGhWxeQaW45MJJzzkTxQ/vSUQi2hp9I6ATB51EgoKC6AV5PlIQ
JDp7LMLlLjsXzX9Ft7VmpKYmJiREh4iejOzzjrtdJeRjsg61X9QuEnithrOq
13as1cCzVkPJyM/FP3+eerxayJAvFFaXjKov7PMVvZCOkY+WBrT9ZsmHdY59
SEvkq/fTR4leVipXZpr99HJM1t31cmljsnC7dsDtcLsi/Cz+n72zAG/i/OP4
VShWCi11d6fIgA0dNoY7AwbDHYZt6IAO9yH7IxuMMUGGO4OhQ4u2WKFOPalr
qtn/vV5JQ2ppmuQu1+/n+T590uvd5d6k/eTX9957b4gw/B45hpjIkIiICCJt
Yt0XL16QKp2U7kT1pNhm7mdNJE9P01dYGPDvrbiYGPJtQlTki6VzKnAmKcif
DewUUVSWvxgzIDHw5fMnT8hTBAYGkjKeGP7Zs2fMnfVIuU4+SphXIz8/nzxL
YmIikX/s65fBXZvB7SVl/APzpBOWoUMcgzq6vvJ2fenq+mCA9T99zMKGmBGr
0z3q3vbkQfhg87A+FsGdrCNHmyYsrffKy/5wA9vRtRs97GIW2MI2rB894cxg
vYada+nXKn9eGjXAnJOdPqmlzDlZuF0x4Ha4XZKYo95hN5Y/vvN3dCR9DSnR
bFJSEvnKzN9LrE4WRkUVz/pLDjX81UvmlnYiEX1pSVZGRtCw7nIqlBj+5cje
4b/uerJ/D/Msfn5+5KMkPr5kDpPk+PjX+3bG+92Nv3Mj6JedL37ZGTJlGNwu
Ebu/WXFnCxF77By3V01cw4e4ve3gHL3CJnK+7YvWjkxJz+RpI5dLhvbrLUxG
1zbcVp+u598NM4ueZPzM1FmyztJS4yRZxKCBdqeic7JXLyj/pq41Abgdbpck
8KpvXGx0cMCz5ORkf3//gICAd3537167Ss/Tm5gYGhpKvhK9M3U1eRz1jL7R
Bjlmsj5ZTr6Gr19eJZGSMp7Er0/7gLGDXvX82G/FopjA1+S/ALLP6Pu3w+/c
lL7rRMyThy/6dYDbmaTesHgmpe7nNq4RX7pFDHd7ZkR/G2DlEjLCPtrXJnaL
ddx267htVm98LW/2tP7X1tHf1DmsnwVZJ/hTa6Zol2ReXROVzJVQPT7vYqFi
C/ITuB1uJ4m4PC7m3g7/k/v9798npTgppEl9/vb5c6JZUlFHvaNna3/79u2L
Fy/Cn/vTpziL7kkd8/wZU8AT+UdERJDqPcz3m+p4NfCzj5JjY5jXIfzcydK3
Ewo/sFvVsxNohNvTH5q/cHV+283xdWunkvOkpq4Rw9yCu7i9bV+8JKSnG4m/
ievbDq6vmxd9BNjS60eNNXnTyvZ1UzvJtucNHH7Rt75g4DBd7mHtagNuVwy4
nd9uf3P0s7CHvyTHBMQ92hpzf130neUxZ7slnabvVR1/smnQNV/h6+PxAb++
PruNlOUvnj4hio6MjHz58mVQUBBx9asbV9/4P3vu94CZH4AU52+XfxM0blDQ
vp15eXnxUVHRYSWj2pJCg4O6t6iOV4P6tY8ICyO7SngbKPS7y+yWfJQwd/og
nyNp4aGqvluHRrg9K9As623x45TLFoHtHRlFv27jRPLKyzVynFvUBLfQPm5B
HV2DPnUN6uQaM8ONnt2xh2VId8uQXlYxa2yKC34X5/gDlg8vGe3eYDB+RN32
7nq65c07xhJwu2LA7fx2Oz33y2nvmL+HCgIOxD7ZFf/8j6TYNzH+v8XeXxX5
YFv4o9/iokJTU1MDAgLu37t369at4ODgp0+f0rdGehcetnLB6zYur9q7v1z9
3esiiPmDRvaJLBp/Hjp1RNjtm+8e+wVd/TstJCj67PG3g6s7joUePH/oV/Ii
iLKyEp8/ZV6QzMxMZnox4vaMuJjgdqqdfEYj3C6T7BAz4uqgvg4Jf1plh5kJ
91sFD3IIsHN584lrUBfXV56ur3xc37R2fe7oHDzAIW67VeZLeqvYDTaRC20z
npjL7C3ljemNE4abfRuMGFDH2UHtk9TD7UoCbue32yVJPkPX6sKT3hHH28U8
3h0fE0pUSSrzN2/ePHjw4N69e/fv3yeGf/PiRVxc3Lsjvwd/3oqYNqDnxyGT
hz35aXtISMirV69I3R7Us2SgY1A716DPmr/u4KlEtb6dOZrIXCAQhBwtvk1n
bm4uOSRm3E78pTNKv/k1D9xetvDDzdLvm6dcskg6bZnyj0XGU1mHy5n45yYX
DzZaMV+/3+e1rcxZ6I+H2xUDbue324nSE095x5/wijvVMvbfb5Ojnubk5OTl
5TE3OfX3979+/Tpx+6NHj16+fBka9Jaep/3X3ZLJW54P7Bxw7NDb16+fPXtG
xE5K98CBnVSqVvKB8nRk35jXL9/evikMCZJ+ZVLi44JH9FTps/PJ7SpK+EPj
Y3sbLppZv1tHpc1dDLerArid325/e3p45LM/U+JeC989jb6/PvLe2qSkJKLx
p0+fBgYGMsbOyMggC5nLhQTP/d++H0NONPty0czUmKisrCz/ZzTks+DtmeNB
3VuqWrBvhnQN//3nZ1tWx1w8nZ2amp2RHn/jcuCXvVT9vHB7VfPqVuPfdjT8
ekK9ti1VdT9ZuF0x4HZ+uz36qHfsMa+IY5+EX/wq1m9zWPArYnVmqq53wUHM
5SHE7elpaaSYjzi4P+Sz5hLLBQzqEnP3VthvPwvevL5/5OCLFy+I20npft9X
HbfSiCiauCasnSvd80MeqOvmHXC7wskMNWXOyU74sm5TL11lnZOF2xUDbuex
25PPeMef/kj4/EBOTnZBQUFsbOzDhw8FAkF+fv7bv8+HPbxPSuKom1ejAp7m
5+UFfzdb5sbTRKch7dyCOng8XzD9WZfmT69fffz4MflcEAqFr4tOm6pt3l11
Bm5XVlLemN48WXxO1sVR8XOycLtiwO28dHvsyZaxtxcJXvyRJgzNzs6MDvIj
bmdm30qLCAv57afQk0diL55+1avNu4P7s7Oz365ZUt45yrCiGRrJT+9sXhMR
EUFK99DQ0Ph/r4VuXUu++n8393XvNqwLGW7nfphzsisX6PfvUbVzsnC7YsDt
/HO74Gx7Yfi9hNCrUXeWh137JvDospR34czO465eet2tud+CGUGrlzyeMyno
t73hOze9HDuw0j6WoHauz/f+j56wPSGBuaQoKyuLmXwgMSQoqJM3606G2zUr
4Q+Nj+9rJM85WbhdMeB2nrn97ZlRkf5H3l2ZGHFxROLby9kZ6UTFGclJEQf3
h69eFNzRg2icvtVde7fAL7pHyNeJHTR+UILfHVF2NnMVal5eXlxcXPDTx8H/
2yQIDwsPD3+tlrOccDuPw5yTnTWRPidbry7crgTgdp65XXiSHvEYfXd1Tk4O
s8NUQfyLcYMVdl1Q949SiuYByMjIIFbPzc0ViYjmsxMTE4MnffGkrVvs/TsR
W1ax7mS4nTfJDDV99LfRnqJzss28dPt+bqUGE/IPuJ1nbk845R15cw1j4PS4
GME/F4OqNyY8dMpwoVCYmZn5/NzpqId+ccFvBWGhb98EpqWlvVixkKzwclCX
oB0bWHcy3M7X5MQNV5cOeQXczhu3F42KaRnxz27B3RthC6eRepu5jVE1XRfQ
rz3ReNClM8xEvv8V9clEhoXmiETRf/7yrr3bm27NX04YwrqT4Xa+Jjd+hDpU
yDvgdn64Pem099tTU4J+2xg8pr9yhyaSvYVfPpcUFyt9kPR9l4SCVwtnRBYN
RGddyHA7jwO3Kwbczg+3C9d7RX6mKt0FjBuSnZ39X9E9OKKjo6MYgt6EfOrF
uorhdt4HblcMuF3T3Z50yDt2nIdKdRfcszXTIVNYWBgWFhYZGUkeJ9y9ybqH
1eN2ADQRuF2j3a7Scl0Sekbfv35nDo/onXg+Ly8v9JvJrHsYbgegPOB2DXW7
Gsp16YR0bRpz4qAoO5tYPVMQ/3r5NzzrZofbAc+A2zXR7eop12VCqnd67M0X
3YI6eqlhrjC4HYDqALdrltvVXK7XwMDtgB/A7RrkdlbK9ZoWuB3wA7hdI9yO
ch1uB6BKwO3cdzvKdbgdgKoCt3PZ7SjX4XYAFANu56zbUa7D7QAoDNzOQbeT
cj1mLMp1uB0AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
QHXJCY2IXb8DYSt5sfFs/woAAHhI6pWbTw1dEbaS+TiA7V8BAAAPgdvhdgAA
/4Db4XYAqk9+6LuM9bsQtpJ97LzMOwK3w+0AVJ+cK//GGzZB2Ery0Gky7wjc
DrcDUH3gdrgdgdsB/4Db4XYEbgf8A26H2xG4HfAPuB1uR+D26hN2+2zk1iVJ
27cirCT9zCmZdwRuh9sRuL36nN441dm61p1Z1hGf2IU4I+pO7PgxMu8I3A63
I3B79SFupyiqjp7WnvmmaeucYHi4vYYHbuda4HbFYNzOMLxbg7TLTjA83F6T
A7dzLXC7Yki7neBiXcv/d1vxbRcYHm6vmYHbuRa4XTFk3M70z/y00PS/+64w
PNxeAwO3cy1wu2KUdrukfyb9qjMMD7fXtMDtXAvcrhjluZ3pn3n2my3ROwwP
t9ecwO1cC9yuGBW4Xbp/BoaH22tI4HauBW5XjIrdLtM/A8PD7bwP3M61wO2K
IY/bZfpnYHi4vXSSujoyD4Rebkm9HJjHiR2cWT8wuF3TA7crhpxuL90/A8PD
7QIHj5RhtszjjKVmSd1pvQucPUSHDZiF2fsbxRt6kwcJLVyFnm6sH7Bibg8/
dXmvaWuErcTdfqQmG/IL+d1eZv8MDF8D3Z7wkYvA2pN5nHOiAfmWPEibZpW1
04g8SGzvnP+wNv1TI++CIF1mzbTZFsl97ZlNhK7urDehSm4/tu0Q5T4VYSs3
/7qiJhvyi6q6vcz+GRi+RrldYOuZe6m+wIaWduYak6xtjcmD9LkWuVfr0Rqf
aZn/mHY7kXlhlDa9ibF3/hO9xDZ0/wwp4NNmWbLeBLhdgwK3K4YCbqeY+WcW
yPbPwPD8dntSV8fET52Yx8TnmVtopRNR5wfo0ZJfa8I8EB0xYCSfc1o/90J9
WvvzzQve6pIyPt7QO+esfnKf4t74hOaurDcKbud+4HbFUMztDGX2z8DwfHU7
kXPOOf2UUTa0APvbi+O0BA4eqeOt/0uhhG7u2QcaFobpkBK9MFJbdNgg8RMX
sjxjmSkROFkzY5VJfFGRX/C8Vnxjugc+dZy1pK+eU4HbuRa4XTGq43aq/P4Z
GJ43bhc4eyS0dmEeJ7ZzJqJOaOEqsPMk6k7/xiLlS1vygHzNvVhfnESRwp58
m7XLKOt/RuRBUnfH3Mv1xAmU0N09bbYFsybtz4F2Ba914y296N0S1Zt4s95M
3rhd22Nap6+2rN598fLtV+HRiRmZooKCwvRMUWik8OKtF74/nms7fKMW2wcJ
t6uBarqdqrB/BobngdtJSNUt+qMho2Li6txLdE9Lvr9e/hO9pJ72jMxzr9Wj
C/V1xuRr9kGDwlBt8iB1LF3Viw4ZpIy0FSdTOScaxBf1zBPbM/U/SeZ643gz
L9bbyAO3G7aeR9QdHZ9S6V89cf6CTSf0W8xm/ZjhdtVRfbczDOuqX17/DAyv
6W4nER02IFYnEk6dZEWX36Nssvc3ou09kf5WHK9VGE3LXDpE5oXhOnR5v9RU
HKtFCn5hcxdmq8x1dBeNwN5D9GfDzE3GrLdO091OavWvVx1JTc+u0t++MCl9
3OLfWD94uF1FKMvtVGX9MzC8xrk9qatjxjJTYRN6XLrQxb0wUjv7QEOBtSfR
eEGQbuqUIqsLtGSUXjpE8nRtv7dh7sX6dFX/W8P4xl5pMy0LQ3VyzurHmxb3
zAi9OTEAXuPcbt5+wfUHbxQ2wJlr/qTgZ70VcLvSUaLbKTn6Z2B4DXJ7fNE5
U2LgtDkW5HH6InPm9GjWtsbkQWHYB4W6OJHKu1tH9EfDrJ1G2XsMc042KHit
K7MC+UrWSerhkO9Xm5b8/kaM2BOauor+MhB6we1VjlsP34joxGpK4HVIrE2n
xay3BW5XLsp1O0Ol/TMwvKa4Pb5omLo4ge5Rj7fwzPfXo3tUdhgxomaSd6dO
6kRrgS093F1g5UnKb6G7OzMYJuEjl8w1JoUROiUr+9Um25JKPn2JGVmHfHaI
DhqQfwRShtqx3lKNc7tD1+9iBalK8UBopNCs3XzWWwS3K5FK3W5nZ1erVq2q
6l2e/hkYnrNuT2jtQorz9HkWAnuP+KKzn0TLOaf0kwfYEc9LRF0YrpM6hj4l
mtDKJXOjcf5TvZIqXaCVc04/baZlvIUX0T4p5qVr+LR5Zhm+pgVv6cI+70bd
xE+Kx+GQjwbmMwJurzT1m88KDI1Togr8AsL1msxgvV1wu7Ko1O3u7u7//vuv
AnqXs3+mhhuem26PLzrRmf1ro8JI7fRvzUmBzZwDLXilWxhV3BWT/6i20Mc1
3sozc71xYXy5ne15T/SSh9LjHkltL+mcL4zVKurV0UmdYlU84UxLF1LJkxq+
6BInuL3y7D9xV+k22PTLFdbbBbcri0rdrqOjIxKJLly4oKurW8FqpLwvc7mc
/TM11vCcdTuT9Pnm4mQq73adxG6OOScaSIxNzypg4ylwc6MvQfrSNrGtMyn1
02ZY5hxvQAr7giBdUvYnD7FLaOaa1N0xdbJVUj974vDkgXbipPfOv187ebBd
xiqTnLP6pP4XJ1LZewyZeQzg9krz6VdbVGGDgoLCpv1Xsd46uF0pyNPf/u7d
O7LmX3/9RTxf+qddunQJCAjo169feZvL3z9TAw3PPbd7p462yfA1TR1vLXCm
O2RSJ1gTXdOGv1GnuOqO0BE2c4238EweYEfUndTFkVg9a1+jrD2G9KQEZl7x
5p6kIBcdMsjY3DjlC9ukzk7JvR0S2zsxHxbFnTbCYsmTDwJS+TOjcYrTmM3S
XSPcfu9pqIqEcO56AOutg9uVgjxuP336NLPyoUOHpPXetWvX+/fvi8Xihw8f
VryHOnpau+fL2z9TowzPPbfTak3ua597oT7Rr+igQdJnjsl9HAqDS86Hpoyk
+9iTPndI7m+fMtw2c5Nx9v6GKV/axJt7xZt4p46zSmznHG/qJXDyIJ8R2fsa
pS82IzskZTwzzS/Z8/vueu3UiVZCL9eEj1wSOzgn9XIgFX7WLiPJVPBwe5lp
/+UmlTrBs/f3rLcRbq8+8rh948aNkvV///13bW1tYvXbt29LFrZq1arSnVBV
7J+pIYbnotvfJ2WUTWEorfR8v9pZ+xsW98Y8qE33rvSzL666X9XK3Nw4oSkp
470SWjrTXesm3gJrUrdbkgJeYOOZ/IUt3VETR3ew5z/Tizf2TuzoVOz2GC1x
bMnwePKYfJTQnwustpr7bt937I7KfECz/ue/WW8j3F595HH7hAkTpDeJj4//
YA+nT8sjdoaq9s/w3vCcc7upF92F0schoRk9SSOpvbMPNPxgiMt0eoZeSe1N
j585q0/EntTTQeDoEW/hmdjDnmwVb+2Z2NVB6OGW1N2x8J22TM2fe72upGcm
52SD9PnmSd0ciy9iYjscd7uW+1RBYpoKTFBCYGgc682E26uPPG7v0KFDeZsX
FhY2adJEfrdTCvXP8NjwXHM7sXrGUrPcS/XpGQNCdUQHG6bNtiBFeGG4NnOF
KfG2wM5TMhIy9wo9EUH6t+aiYw2InBNaudC33rDyFDZxS+zgnOdXmz6d+pmj
OL64PqcvSpXqdc+5XC9rl1HmRmN62rERtnTvfTdH8v8Cizdp4rjbPXt/r3QJ
lIZTY93hdsWQx+2DBw8ub/NDhw5VSewSFOif4aXhueZ2SRJ83LK2NZbuM6E7
VZ7QM7QnD7aTdMgI7D1SR9vkXKxPDJ+5yThjgzHd0+7gkXe7Nt2F3tkp30+P
1POp46yLN3mjS/aQ2MmpzAGThWE6OWf0k4eweR0Tx90+dPbPSpdAabqM2cp6
S+H2alKx22X61WUgRbuLi4tibqcU7Z/hmeG56HYjb1KZF90Lz5uoO32uRc6V
4i6UHFKcGzZJ+9qSqeFJmZ3QwjX/WS1SzKfNtMz+tRExfO7lemlTrYTebvkP
9UgNnzrJipn+kRkhTxJvTO+2WPVvdVOnWiZ87EyPyeHGbJAcd/v8jSeULoHS
jF/yO+sthdurSXlur9jqErZv366w2wmN9LWjzzgopneSwpsu0X3sWfczf9xu
6pW+yDzvXh1mgKJYoEUqc/ItsXdxjwp9b+viy1SzfzaML5ryN3mQXUJrl7z7
teMtvZjrT8nmpDIny3PO6ZN1yCcCqduJvZmOd9rhRt4fTDUTq0XK9fR5FvQF
qqwOgOS+21ftuqCsv/0KmL3mL9ZbCrdXk9JuHzx48Js3VZhWbsuWLYqJHXU7
7faxAxb7UJ1XXhK9fz3Zr9tJzLySujlmrDDNu1FXMhCdhJ7FveiWSWSh0NMt
5UvbnJMNaMNfqp/UyyG5j8MHFzeZeJP1U0fbJPi45b/QJfvMWE5P9svsv9jq
cVq5/9TLu1W34EUtpk+eHi1ztEFSDwfW3D5kuMw7Arez7PZDv8i8I0AeZNxu
YGAwderUTZs2nTp16sWLFyKRXC/nhg0bqip29LcXu31Mv1Hk5fDZnv7+xeSE
20lMvIWu7gktXZL62KWvMS4+c3qZvhEqqa6zf6EL+LzbdZjrkuihMobepHT/
YETNbIuEpq55j/RIlZ69t1HadEuBnWdO0X09hE3cSsY9HjJIGWEbb+zNOJ+Z
goDFJA/6QuYd4ZTb1dMnw6l53W/+8ZPMOwLkoeL+dm1tbWdn5/79+x88eLDi
/axfv15Oq2OczAduHz8m5NgoymcPR9wusPfI3GSc76/HTLoue64zQoeZ74W+
L3Y757x7dchj0bEGyf3skwfZyaxc8LIWWVl0xCB5oB35CCDFOVmZuUdqyhe2
pVdOn2tR1MnP8oda8tBpMu8Ip9xeM8+lyrwjQB7knOO3adOm0lsdP3588eLF
f/zxx9OnT5naPjc3d/fu3ZXuB+PbZfKsuyd5WQ4+T5a8tiyPgeztkNTNkVTm
SV0cSTmd/o1F5jqTzI2N818Ud7kndnIqWtM7c41J+hIzUornv9aNb+wtOmhQ
+rMguY8DkXn2Abonh9ibnqHdkrZ31o/F00KKjunTz7LEjFT+4hgtErKf9IXm
9CzBLL0Crzv4yLwjnHJ7DRwDeXzxIJl3BMiDnG6vV6+eWCxmNklLSzMyMpL8
iNT2Tk5Offv23bFjR7t27SrYCa5LLZ3Ir4aGxHzQ8cWVPpmiYZCp46yzdhkR
LUt0TbTM/DTnjD7xPK3u/Y2I2yXzQ0onc0tjgY1nwVsdsn72T4aJnYsmEzD3
KgwrmcGAbEg+Qeh/Bxp7011A3RzpEfLstVo4cLTMO8Ipt9fAa5eu/XZY5h0B
8iD/vTkiIyOZTXx9feXcRALmkykv3Bonw8TYO32+ef4zqcnYk6n8p3rM/TjE
cVoCK7r2ThpkS49pX2OSNtsisY1zmePV827Q/TD5D2qTij1ljDU94Yxhk7Rp
lsXnW5/pZf1oWBhCez73ar2Ej1xYbnhROD5OhsKcA0A+5Hf7P//8Q9ZPTk5u
0KBBlcSOeSA1y+0Zy03TF5kn97Mnxk5o6ip0cU9o5ZK9r5GkBz6pV8kgFtFB
g+S+9ikjbcq+FumddnzRfbSTujvGWxYPX8+5UE+yQu7f9QXu9H8HeTfpATlZ
240SWruwezqV+25X9VxhHr0wVxgfkN/tu3btIuvPnz+/SmLH/O2a5nYprxp7
E2nTE0IWWV0cX3zn65QvbQUOHsw6xPOJ7Z3TZlqW6XZ6NHtj7/TvzJiKPd6E
/ppzTp+5xDX/ET2uJj9Aj55qrOj2HGnTLdO/sWC3gOe+2ynM8QvkQH63E6un
p6fXrVtXzvWr1A9TA63OVbe/V1wfB3q0jJC+MUfWbsPU8dapkywLi6ZzTBlq
l9jWOXnA+5kBjL2J4cUxWqXFTk/8SF+LVPR5YeSdsaEx7fZTtNvFiVTqZCsi
88IInYIgXfIBwXqTNcjtuDcHqBT53T5s2LB169bJuTLul6rRbk/q7ij6o2Hy
AHum3hZ6uYkOG7zXda3Usdak0mbmlimp88286PsoLTfN2to4c6Nx2hwLyV1Q
6Zh7EXvnnKcHt+f8XS/7TwPyqUH0ntzfXujinv1rI3GsVtoMS9ZvqKcpbqdw
Tz1QGfK73crKSk9PT65PAfn6YWq41bnsduLb4sdG3ukLzcVxWsTDOScbEHvn
3ayTvsCcHusSTV9hmr7YrNJhLSlf2SR87JI6zjp7H33FE/l3IP9B7cTPHEi5
Tor24g6ZVi4Z35uS52J9VhlNcbt+i9m4FzaoAPndLg+1a8nVDwOrc9ztxTHx
zjnRoOB5LXrAuZu70MM97x59W72MFca0ogPo8eppX1tmrjcW2Hqmf2+a3MeB
LBFYewrsPYiridKZUrwgWId8FtDj4ReZ0/u8SM/9nrHKhKyc/7h2vl9tsjn7
jdU0t5M4dP0uVpCqFA+ERgo5NaYdbq8+SnS7PP0wsLoGuZ0oPW2WJTN5V2In
J1JmixPoIetJvezJkqyfG9EFeSuXvJv0QMe823VK97enTaPvr0fP8W7YJPu3
homdHZM+d0js4ph3p444Xov+ILD1FB02IHso+U+B7WiQ20ncevhGRCdWUwKv
Q2JtOi1mvS1wu3JRltsr7YeB1TXO7fRlpEUPkro70lM1nmiQ8JFLQkuXwnfa
Qk83obdr9l66jyXnal1hEzfJ7TZKRsULKYGDR8Zak9QJVgJnj7yH9MQyGatN
sn82JP8CkE8KZuax+KJbr6YvNuNI9a5Zbicxb7/g+oMqTO4nw5lr/oat57He
Crhd6VTf7ZX2w8DqGup2JkS5+f56KV/S88CQ6rrgZa3CCB1hE9d4E7qzRWDl
mTLKJnOticDaUxyjVVB0y2xxIj2yne5dN/HOf16L7CF5iG3Wtsbxht5Z+xoV
RmvHW3oldnAujNJOGcrmbTj44XYSbY9pX686kpqeXaW/fWFSOqfmBIPblUs1
3V5xPwyszgO3p461TmxTNEDRyJuej/d+bfqCpqYu9OWr88wFDu5E7zn/1I23
8MpYaZrxvSl9M74o7Yy1xmS1hNbOmRuMyZoJHZyKtnJNaOEqFmilTrAmO6Rn
G7tZN6mzE+tt1HS3MyHlt++P56LjUyr9qw+PTlyw6YR+i9msHzPcrjqq4/YK
+mFgdd64XXKL6tQpVrmX6wls6J4T8oCU68T2ad+aC13dhT5u9D2yzb2ELVyI
24mxE9s5CZw9kgbYkXo+7WvLoj14Z6yhT8JmLDPNu1OnePBkY29iePbbyAu3
MyE1fKevtqzeffHy7VfE4RmZooKCwvRMUWik8OKtF0T+bYdv1GL7IOF2NaCY
2yvoh4HV+eb298naacR0iacMsaO7Zeixi96p46zTF5qRhdkHGtITCxh7i2O0
UqfRw2NyTusLHD0Edh55j+mR8AktXQoC6Zul0hP/HjQgnxSst4iXbudf4HbF
UMDt5fXDwOr8drvQu/jUqugvA+Z21cx8vwJbWuACB4/Erg70NUqdHekZHZu7
Zqw2IfIXtndK7mdPV+kWXsTtxd07ht6k7OfCbO1wO/cDtytGVd1eZj8MrF4T
3C5J5iZj5kHWLiOmRyWpvx0jcKEPc8NTb4GTO92ZY+JFf2vhJXCjhzgm93HI
2mHE+vHD7ZoVuF0x5Hd7mf0wsHoNdLvAqXiiMHrm9qL5fukJB8YyfSzeKVMs
mAdpS0yZTvWUcdYpX9kwm5B6nvUrT+F2zQrcrhhyur10PwysXmPdLgndwc7Y
3tm9+NyouWfJnDAW729+akz3wLB+tAq7PfzU5b2mrRG2Enf7kZpsyC/kcbtM
PwysDrfLxtQr3rq4mE9o8X6KMCJ5Bzf2j63abk+9cvOpoSvCVjIfB6jJhvyi
YrfL9MPA6nA77wO3cy1wu2JU4HbpfhhYHW6vIYHbuRa4XTHKc7ukHwZWh9tr
VOB2rgVuV4zSbpf0w8DqcHsNDNzOtcDtiiHjdqYfBlaH22ts4HauBW5XDGm3
D+uqn3bZCVaH22ty4HauBW5XDMbttWtp7frGBFaH2xG4nWuB2xWDuN3Zutbt
r61hdbgdgds5GLgd8AO4HW5H4HbAP+B2uB2B2wH/gNvhdgRuB/wDbofbEbgd
8A+4HW5H4HbAP+B2uB2B2wH/gNvhdgRuBwCoGrgdbgcA8A+4HW4HAPAPuB1u
BwDwD7gdbgcAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAEB+
ckIj49f9hLCVvFgh278CAAAekn7lzvNGLRG2kvX4Jdu/AgAAHgK3w+0AAP4B
t8PtAAD+AbfD7QAA/gG3w+0AAP4Bt8PtAAD+AbfD7QAA/gG3w+0AAP4Bt8Pt
AFSfl1cfftPpG83N/wYtiPn+e81N0sGDMu8I3M41t2dHvHv3424Ws3f57rnz
2EzIdjabLzx7QV065BXHVvyqRU3W3LSjej6mtDQ3QT17yrwjcDvX3J586/Yd
t6Ysplfn2VoDd7OYf9w/YrH5LydOV5cOeQXcDrcjcDvczj/gdrgdgdvhdv4B
t8PtCNwOt/OPE1uPV9OurrZffDPqk5Ob7F/+ZRj7d73oi/UCDhud2mw//6uP
PR2GqtrtPbpuzk9K0tyk37ol847A7XA73A63V5+T204o7NWurXrf+tn8v8eU
dAr8tAKPN7q0w5rY/uZPFr/6uvZs20N1bu/ZczvbL2G1yHz4UGYJ3A63w+1w
e/VRzO2GDcYcXe8oY/XreyyHd+/SUH+szMomjb4ybjRaZmHpJXA7A9wOt8Pt
cHv1UcDtbnZfhJ/Vl7b6m+MNO33Up+KtGumPkf521vC2WtQkybelPxHgdgRu
h9vhdoU5selIlVzqYjNMcKWOtNjPbbU1qF+5mUmhPnlgB8m3JzfZO1oNl/wX
MHVwe8Xc3s1nYeKff2puhPv2ybwjcDsv3X6/mTfcDrerkyqNk9GvO+7tiYbS
Yj+02klba5Kcm9/eZ97MdRDzmFT+gzp/xjw+s8Wu0rK/vGCcDKIRbg+eY+X3
sSfcDrerjSq5fc9iD2mx+x0wqaM3vuLPAh3tiZJv10xvFnTSoEG9saRQJ5uv
mtqcLPxm1Cfpt2rV0i1ZTZ7/AuD28uLfqOV+r1Y1Ngc8WnHT7RG+Zv79neF2
uF1tyO92H+fB4kclYs++o+NgObziTUhJT3w+7LOuTNd6x+Z9yYaH1zh1btmH
6cxp06R/3gPt05vtmPVtzb/cOs+bPBHcrnAeNm5JLW9bY1N7SRvuuP1xF7fA
SbZhS8xjthqlnK0bu9MQbofb1Yb8bv9zlbN00b5pto88W5HC/vY+c/9DRn3a
f06Kc1Kik20f/W5MvsZfrht5vj55MHVwe/PGo3Z865Xxr273T3qhTwZu54fb
QxdZ5D7TliRynQncDrerjRNbjsqj0Ab1xpJCXSJ2UsCTGltO/RoZjA483ohs
dW+/afApA5mRkyRH1jpm3dElD0b37lQlsZN0b7My089Pc5N86pTMOwK388bt
95p5p56ry4g9/Z/a6G+H29WJnGMg+3b4XNrGxNJVMrCd+YjYv+uVtrp0Fo9t
VVWxa2EMJNzOYbeT3PVu8nqcXeBE23tNMU4Gblcrcrp95dQW0h7e8HXTitc3
bzxqwejWJzba/7nK+acl7lvneZ/9wbYCsRPzr53RjKxGVv5jpfOexR4dm/eF
2+F2TXf7k89cg+daBc+zfNbbBW6H29WJnG6X6Wwf36+jPFt52A/dudAz41/d
iit2mbE3o3t3ql1rAup2uF2z3e7hE7PVSLq/Pf7nhvd8msDtcLt6kLO//dzW
D6rugZ0+k7/bxKD+2Dkj2mTersTwpLBv5Tmgqn0y6G/nrNu1lrc139jHdfsw
hx8G66/uWtPcHrHCVFrsTGK2GcHtcLt6kHOczMlN9tIeHtqtm5zuNTIYPf+r
j8PONKi0Ys++o/PLMrfmboOq5HaMk+Ga2523DfW9vu/uu+fZeTmkOamijL2P
z/Q/uNBoXY+a4/Z7TZqI/HRKuz3nqbbfJ1U+owq3q8mG/EJOt8tctVQ0G0wl
m7RwH7R/uavork6lVpfJnX1mw7t3kb6aCW7XCLd77Bhx6vUtsVhc3JCczEVX
djVY3U2dx8ARtz/p7lpa7EyeD3WE2+F2NSCn22cPbyOt331L3Spe38J4VNdW
vdv69GvmOsjV9gtr0y/3LnWvwOcxl+qRzwI3uy/I1/bN+n3+Sc9PvPvD7Zri
dm3fdt9d/SmvIF/Simuhjy039VP/kXDC7e4+jzp4lOf2Z32qfHUq3K5yD/IR
Od1OFC2t4ohz+tKzOFYaUuczGxY+LEPszEK/Ayb16lQ0gwHczk2311nZ6eTr
m9JN2P3wJLG9+sXOEbcHDHQiX1PO1i0t9oxrenc8fJ72qNqYGbhdtRLkKfLP
Axly+oPLjuSf3Wtot27E3q+ONhrStRv5WtrtY/t8emi1k/gRPQuB9Pwz8gTz
QLLrdh3f9mff3JY+/j0PT7Fide64PWqj8f0W3v59nWW63HMea78Y4XDXu0lV
z6jC7aqVIE+Rf/72b0Z9Ii3kK/+zkmerjs37Ep9/1auTttYkK5ORZMPk63rM
aPmHv5kcWUvf4IN8S9Zs4jzkzBa7PYs9quR2jIFk1+0bb/8pffD/Rjwjtq/h
bn8z1SbpL/0Hrbyefu4q/NVA9FBH9Eg74WAD/37O95p5kyWhiyzgdrhd1cjv
9vp1xkVf/ODa0sFdKhkt00h/DCnadXWKS/EJ/TuSrfp/2r25G93D89MS9wb1
xgadNPA7YCLZ5GPvAW2ayNXTDrez7vZ2e6dIzpwSsnJFdlsGsih2jrj9rmeT
tIt1Mm/VCvnG8mFbjztuPiQPWnsGzbTOuKqXeUPvfvOqXaMKt6v875CPVOm+
SwM6dZd2e/qtWl6OQ+Tf/Oh6xy1zmpAHeroT8h5oM/fjaOY6KOuOrpGBgrfY
g9tZdPvjmEDpI19181d2xc4Rt98pmgGSOJzpism+r5N9T5d5TH7VcS4VblcP
J7Yer5JLt87zltZ72JkGTtaVzPTLREd74sXtNpKRjQGHjVp7FV+pNG1I+y+6
dVXM7T26bs5PStLcpN+6JfOOaIrbPzswW/qwRXk5Rus+h9sl8fvEM2arkaTL
XfRIJ2634aMOHgrsCm5XrQR5SpXuzaFVNCX77ytcpPWedK1211a9K93Qze4L
6akjf1nmVrd2yaiYzz/pqZjbMU6GLbcfDLgsfdhHX15jXeyccjuTu95NnnRz
e9Ld9Z4P5gqD29VKVd1elEmrpjaXvk9H4UPq5+/cbczknfWX5LOPqzZPO9zO
Kbdr+7ZLzk6TPuwxJ1exLnZW3B66yEKwr6EkwfMs73o2CZlvKb1QOuHLzO75
NHkzxUZ6YcRKU7gdblcuCrmdTsfmfV8cMZQu4PMfaJ3bajtlUPvmboOMDEbX
0RtvYTzqI/eB3T/pJV2iS+p/uF1z3e6+Y7jMYbttH8662Flxe/zPDaUHOsb+
yNxcySdwkm3mzVrSP8q6qxs0y+qOuw9Z4d2qD2abSTpaH26H25WLwm5n/Dy4
S7dLO6zzHmiXHrVe4Kf1z06rL3t0kYyTUUXgdlbc3vfP+dLHXFhYqPt9B9bF
ziW307nfzDtynUnOE3oamZhtRg9aeUl+BLfD7armxIZD1Rds/TrjOn3UZ/LA
DovHtlo4pvXEAR07t+yjX3ec6pQuSRfnr2N8fTU3cRs2yLwjGuH2r06s+OCY
czJZtzoH3c7kyWeu/n1lx8bA7XC7qqnSGEgORuPHQN4/utiH6rzykuj9Erid
Zbf7nZN5R6rq9oftPIJmW1WQx13c4PYquH38CJl3BMgD3M4umbcPjaIoymd7
+vslGuH20n0ytXjTJ3P3pMw7UlW3vxjmWN5EYUwCJ9vC7VVw+7hhMu8IkAe4
nV0yHz4MOTaK8tmjWW7n97lUmXekqm5/2sO1vEEyTAIGO8HtVXD7xOky7wiQ
B7idXYK3jyAlycHnyZIlGuF2Ho+BDPnxK5l3RPH+ds8mjz51f/KZ6/2PvO43
9yLfSn4Et8uf6z2ayrwjQB4Szl242chMc3PX0OSZkZHmJrBvz5CYD/oRNcLt
FH+vXUr797rMO6KY2x+284hYYZp+pXbOU3qczLs1JgFDHO8194Lbq5qAMWNk
3hEgD6kXL7I+DrAmR0PHQFJlzTnQWC13zVO125UyTuZ+C6/I9cbMkuB5lm+m
2BC9h31nHuFrRip5uL1KwTgZxYDb4XaFg7nCynT7Xa8mROOSJfebe9/1bJJ9
Tzdyg3HiIf2YHUb3mnrD7XC7qoHb4XaFgzl+y3T7405uGdf0JEtSz9dNOV0v
63atZz1dMq7rEck/6eYasRJuh9tVS9q1a2EjRyJsJWrBApl3RIPcTuHeHGW5
/VkvF8m3Ij+dpL/0hQcMXn1lT74yC59/4Ri2xBxuh9tVSun5w4E60ej52ync
U68st/v3c2YeZ97Qe9TR/d0ak5jtRmkX6kjWefGlQ9hiuB1uVy1wO7toutup
su6FvcvvRM25F3YZfTJd3bLv6ooe6QTPsSK1Oinds+/rllTyj7Sf9nCJ+B59
MnC7aoHb2YUHbqeKhrt/d/WnvIJ8SSuuhT623NSvZrr9XlPv2F2NUs/VDV9m
RpaQ0v1BKy/JTTqEvzW439IL51LhdlUDt7MLP9zOxGPHiNOBtyRnV9NzMhdd
2dVgdbea5vY7RfODxe1qFLLAgiwJGOhEviXlOn1e9Vxd5mapcDvcrmpSr1x5
3bo1wlbCJ06UeUc01+1MnLcN9b2+7+6759l5OfQvmChj7+Mz/Q8uNFLL6HeO
uJ3kro83PR5mlQmzPOeJdsIh/ac9XIpujQ23w+0qB2MgMQZSRdFa3tZ8Yx/X
7cMcfhistuqdO24nudfC68HHno+7uL0aZ/est/ODVp6SH8HtcLuqgdvhdj6F
C25/1NE9bIk5k5AF5oGTrN/OsiQPJAuffOYKt8PtqgZuh9v5FC64HXP8wu1c
AP3t6G/nU7jgdlKWx2w3qiD+/Zzhdrhd1WCcDLvwaZwMF8IFt9/1bEJK9xcj
HMrOcId7Pk3gdrhd1cDt7AK388/td4rGQCYe0S/dG5Nyuh5z71S4HW5XNXA7
u8DtvHR7UXwCJ9lm3qzFLM+6qxs0y+qOuw/zU7gdblc1cDu7KN3t/o1a7vdq
VWNzwKOVmt0evbVxxnU9SSLXG0v/9H4z78h1JjHbjB608pJeHrbEXHorwb6G
cDvcrlwwDyTP5oFE1Ox2NQRuV5cOeQXGQPJsDCQCt8Pt4D+4ne3A7VwL3A63
8wO4HW5H4Ha4nX+kXrr0zMgIYSvBAwfKvCNwO9wOt8Pt1QfjZNhF6eNkELgd
bgf/we1sA7dzLXA73M4P4HZ2gdu5FrgdbucHcDu7wO1cC9wOtwOgCuB2rrkd
AACqD9wOtwMA+AfcDrcDAPgH3A63AwD4B9wOtwMA+AfcDrcDAPgH3A63AwD4
B9wOtwMA+AfcDrcDAPgH3A63AwD4B9wOtwMAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAACA/YlGwOOZ7hLXkxrD9KwAA4CHi1IviRxTCWjL8
2P4VAADwELgdbgcA8A+4HW4HAPAPuB1uBwDwD7gdbgcA8A+4HW4HAPAPuB1u
BwDwD7gdbgcA8A+4HW4HAPAPuJ1rbs8NC0vauEV1Sfn5l6w7d5Hyku33UPaP
JDP4v+DvEdYSc1BNNuQXcDvX3J559VqwqZXqEjN8FCu/aZqC6Jm/7CLhxf8u
UQhredSTjV8EjQduh9uBNHA75wK3KwTcruluD3HxhNuVCNzOucDtCqHxbn9S
j/1jUJvbLe3il30vvSRqzIScyMiMB34hbl6ShWGfdouZNhNuVwy4nXOB2xVC
490e9wP7x6A2t5taZdy8JViyTPJt9OTpufHxmU+ehjZpUbzQ3iX7dWB4j95w
u2LI4/bAw/VeVTHRh/X+O0xVOec+eF7Rce3E/Xq8T/IBPbi9+mi22587icX5
4qeN2T8SdbldsMy3ID0jrFUbyZLkX34N69BJ8m3Wvfu54eHok1EYedxe/8uO
1Bedq5QvZ3r+N5Kqcg588LzPFhpusHPztXNc38Zs18CGS1o3XmvrusXeQ6Oz
2c59mbvN5h6NdvQyXOluu9zaaVcTF7i9+mi226MW0k0In8D+kajL7cFm1vmJ
Sblv3pS4/fc/IwcMZh7HzZ5bKBLFzpwNtysMx92+toWl/04q9Tj9bdpx6pdh
Bmtt3Vj3c3Wywt02YLtW4QWKJOp36ucxdbZ5OcHt1Uez3Z75UOObUPVzqcJV
awtzcoQr19DfWtmnXfw7Zv4i+rGdc0Fqam5UFM6lVgeOu/3ngY3yz5csebNb
y9famXU/Vye7+hkSq5e0aJf2ei87uL36aLAY/W3EYjHdhMJc8dOG7B+PutxO
khsXlxsTE+zskXnrtujV64zHT6InTkn/99/8jIyYCZPh9urAcbf/s6CO9BLB
YWqlmz3rflY4G+zcj4zXl25Rxklqa0czuL36aLDb380paUXoKPaPR41uj/12
UU54eMYz/6xXr3IiI0WRkYK9+3PfvROFhFW6LdxeMRx3+/Y+DVOOlSxJOkpt
aGbDuqIVznpbt9Nf15M0R3yRur5SZ10TG7i9+miw29Nvl7Qi+TT7x6NKt4d9
3C7p1JmEk6cTT58V7NgZ2rpt5jP/9Jev0vz8ssLC0sPDU65cy3oTFDl7XuSw
kcITp4XHT5I143xXwO1VheNuX2frtrJt41Mz6r3do0Ukn32a2tHNRB6LjrIy
aWtbi3WZy2SFjcuTTbq5Z6m4g9S9VbX2DDZY6mKLc6lKQVPd/sxcLC4saUVh
tvhJffaPSmVuj502U1xQkC8QFIpE+YmJOUHB0ZOnZb9+nfnkqSg0LDvwTcab
oDRi/h+25cXFicXivJgYcU6O6PUbuL2qcNztW4oGlqy1dfO1dVr3idmFBXp/
jtHfaOdegT832bmPcTYM2keNtTVlXeYyWeVuF/4rtbVPw1VudittXDYVNQRu
Vwqa6vaIabINCfmC/aNSmdsjuvdKvXc/8c6dFD+/lPMXQjybRnTrEdy6bcq1
G8nXrydeuRr3097w9p0ievSNnf0NWSfx1r+pDx4k/rQXbq8q3He7dBbb2//8
VT1ixQr8OcnSMvAn6uVu6htLB2U52dfaebq53SRTm0lmNtPNbcmeFRuus6qd
8cqOhhs+/GyC25WCpro97apsQ5L+Yv+oVOZ2Oq6eUWMmJPxvV/yqNcItWxN+
3JV27VrKjVvJRO/Xrof06V9pTzvcLg+a5XaSr13Mvi1f2qttXX8YrUu2PblI
+/sKPwK2FJ3ZJP8CrLF1/aRhA2af402tlr4fh7PKhh5LP9/ScXIL/b/ma0f9
QeWfp3LP0udzn+6gdk/WGefZcJGVU5XcPtremNkt3K50NNLtTxuLxfmyDSnI
ED+uw/6xqczt8QsX58XF5QkTskNCs0NCssPCRAJB8o2bpG5PuXlL+MM2uF0p
aJzbK84EC0vm3Ou2sTqb3pfH5MGmD0vl76ycFvXT3TlRZ1r7ugONTEVnqMPf
aA+yMIo4QP00VWempc1iK6fujnUmWJsfW1x8MC92UYl/UTKvzPnlWuM8Gq6o
7EOk4sDtSkEj3R4+oey2BPdn/9hU5nY6Lp5xy78Xbt2ReuFi9qvAnMTE1Hv3
ki9ciF61JifiXcK6DXB79eGZ2+d2Lh4zuayvHrNkprX1t4OoEc3rSPfSDzQx
CX//XAH/K34Q82fxg1d7qOvrqGmfa/2zWot8G7aftvrsz3X7mBteWkGv8N1w
6sqq4pXzzlHbx+pOtbCG29lFI92eerHstiT+zv6xqdTt7/OuR5/Mly+Tzl0I
dnYvPtk6eVpuaGjyrj1wezXhk9vX2rr9OlOb2XZOx7rMwsW96NlaAn+iWuo3
mOBq9G0v3R/G6ATslK3ASfLP02Ms3+6lHu+g/t1IDWhCb7hhHDXTzMbFkupn
3ZDutHEzIgt/maE9xNw44UjJUMbH26kxzkbMx8dmO/cq9dXA7UohM+lUyL06
GpQwP1NxYW6ZbSnITwm5r8/6EVYpotQ7su9IZW6PHjkm583blGMngq0dPpD2
qLG5UVGpfx2VWQ63Vwk+uX2hleODLVrMtlNbGDALZ3WsS74tOE/lnCnZc9Yp
yn8nrfH/iq6HSiua0+Dyairw5+IV1g/Tm96B/hdgXFP9NbauPSwaDrVrtMza
eYqnIVk4t1vtKabW0X9Q68bSFx8dmKP1xxxt8rkwvQ19nne4Z/0/v6WG2xrB
7erkTti2lmc/0qAse7K0gubMevA160dYpbyI+UumCRW53cpesNQ3JzwiYfMP
wWbWZdbzWY+fZFy5FtaqLdyuGHxy+wxzOyJqZtsJ7sXbDjM3iTsoW6IH7aPu
bKZI4f1yD/ViN7VrBvV8F/X6J0pSipP9dLbQzz1LnV5KjepCn0I9voT60sJ0
TCftsZ20icAHNtPbNoWabWk71svg8ELKp1HdNUNrkcp/33SdI4uK+m0GacPt
6kTj3H4j9kYFzTn97hTrR6gqt7t65QSF5ASHJlR42jT0k/ai4ODciAjBitVw
uwLwye0TzKwkU7WMsy++xGmjnfsEnwZMZS6d0idGmZBinqwc8yc1xMRky1e6
zMJ3v1GjTay6mzZaYOnIjGAk/yMwI2rI/udaOAxrbLHIymlam3rM/wKxB6kR
bgZwuzrRLLe3v9BOVCCqoDkpOSmtz7Zi/TiV7vaIXn1z4wR5cfFxS5ZXfsLU
0ycn8E1evCD1+InSP43qMyD3zVukvGT+c032t0pj3T7OzlSy7XgLC2bhGlvX
xVZOQ5rric7QiiaFemmfk08EUqiTn2aeos740lV66nFqoInJRDsz8pjpiifV
e/JRqmnjOpvfn5Ndb+u23NqZiJ38vzDZzGaKGT3ufZqZ7Tgb01GmFpsrvMAK
blc6muX2hY8WVtqiqXensH6cSnf7u/6D4xYsrtzqUgnv8plwZdmlO1JByvi/
RmPdPsndSOLqiabF0870cKq7fZLWOPdGg7xrf2xeu5ttvbubivcf/Qf99emP
1JFF1NEldH97yC/U1bVUwE769Oh4E6sFPfWYop18y2wSup/aOl573QjdzV/p
7p2mc9FX6+VuKv4Q3euedJS6ulprQnP90iPY4XY1oFluvxJzpdIWHQ07yvpx
Kt3tCNyugNsnezViNiSmJVU0s/AbC7ud02nx3lxPLe6rO9q1UR9rg9iDxWdU
b26gu1+uraOHMjL9OaREf7OX1jspxYc0qXNsCf1gnHPjzaN0/X7QEh6hmKnX
00/QY2/OL9faOVHn+4G1lvfT+2G0TvA+evMJHWptkrtoh9uVhQa5ve35Nln5
WZW2KEGUwPqhwu2aGz65fUrThpK+9Gnv3T7e2kx0hoo4QJ8tfbWH8ttGd7k8
3lH8FHnnSgryk0upWxupS0UD11d+Ra2xdfW1dulqVjx9zQY79/mWjtPN7Ug9
T/4pIJ8dcyzsl1k7b5S6QqqnqeG7A1TUH9Rk0yoMd4fblYIGuX2e3zw5GzX+
9njWjxZu19Dwyu3NDJgNSSk+w9yOWTirqx4ps+MPlZwqJWX50x+Lv/XfSRft
RPjJR+kBkKnH6akmieHPf08tsHRkOtXlPwDycfDXAnoQ5ji7KkxTBrcrBfW4
vd2Fdn+E/HEz7kZ1Ep8dJ2ejojIjq/lc+97u/fjcx3B7DQyf3D6tRbHbSZU+
26L4Fh7TbC2+MDWd8Dm1dDj17H/0HGKkVs88RXeepJ+gO9KJ9pOOUocW0qW7
ZDhNK1fqu6rf4Km3qREp2hOOUBPNrOB2NaO2ur3jhQ4Xo8q+npRrHAs/1vZ8
G/W8LHA718JLtwfvo+ZYfHB7piVWThvs3LwN6vbw0enxETVnAHV7E90J8+RH
unQ/40ufV727hbqxgXqwlUo5Rs3tq1XeTMKkkl9l47rCxoVkZdHX76ycJptb
f9223uNt9LMv66dX8UyVcLsqUHOfzPKny+TpM2eL1NzUeX7z1PmCwO1cC6/c
3rzY7a/3UHMtypgrcrOd+1Jr53Et6gXto0v02IN0DU+K/LBf6REy934ofl6y
/K/FVNdm1NyudeZ2qju7fb2Zn9Sf3rr+7Hb1lvXV+2mKzpFvtI8vpHNsgfaJ
Rdq31mlJCv6lQ7WWV7Hgh9uVgvr72wdc7f8q5RXb7S6DxwmPe13pqeZXA27n
Wvjkdsm51Gc/UvOLestlMtfSbvMYenKAd7/RfTJZp4o7cIjMr6z54KlJDf/P
Wqr0FU+VZts4narerRtuVwqsnEv9+NzHf4T8wdzJmgsUiAv2vNnd6mxL9b8U
cDvXwhu3L7ZyGuBcn9nwxjqtL40tZE6DTre0YeZ1JPX5rY30KMf7P9CPL62i
LqygS3fRGbqL5umP9Mwzr8q6xEmeFJynxnk0gtvVD4vjZGben5GYk8j2C/Bf
bFYsi+Nq4HauhR9u/9bSYd8sepQjM3CdKDpoL/WFVz3JCqSMP/KNtvTOj39H
+/zGBvpxxsniJQlFw9eJ2FOrXrFL8ufcym8LArcrHXbHQHb/+7N7gnssNv9q
zD+dLn7K4isAt3Mt/HD7GBMrwWF6EOPDbfR0u3e30JtP7UlJVpjaur7Crq5q
Xu8pGaUDt6uNG1f3smg2Jttebc0rzFNzw0X5ojX+q1lvu//9XYt9qM4rL0lm
yYHbWXb7sL4y74gmun2TnfvIpnWvrdGK+ZMe5RL8C/XLHGqGpY2kaL+xVktt
bg//lZr5fnS9Im5/0EH2HQFywAW3k4y6NfJdxju1tTooLWjI9cGst5p2++0d
oyiK8tme/v7Y4HaW3T60j8w7oolu31I0Bsaxke7fq6k9M6izvnQv+lcf6622
pad2GW9lzkz5pZ4E76te3X6nvew7AuSAI24n6XCh/fnI81U9fgVOyP4VdqTN
+U9Yb2+x2x+eDTk2ivLZA7dzJDHDR8m8Ixrqdtrh3YuHMs7oQx1bQp8S/bpD
3VU2rtNaNlCb2EnubNRaaFXGKB35+2Rk3xEgB9xxO5OlT77LzM+U//ir5PaU
3JS5fnNYb6N0/tnej5QkB58nSw4Sbmc3Tz91l3lHNNftXo1rPfsfffHpN4Po
65L+K5ouZtandWbI3dkuuWVqdbJrkk6VZiqQcXvMDnvZdwTIAdfcTtL/av+X
yS+V3tJHCY96XP6c9dbJ5MnNAyExH/Qjwu3s5t2QwTLviOa6vWMDo/Mr6EEy
8wZSB+YV74TWew8dObXMnIStZqZ81KBKhy3j9vxbXWTfESAHHHR7y6IB8L8F
H1DWAPj8wvydgTtZGb5eafwfnpU5Wrid3fBjnMyWovHtHRsYkor9+BJqYFtq
2YiS/aQep++XJ73n8oY4kpq/mmJ/d4CabmZTHbdjnIxicNPtTKbfm15QWFDN
BuYW5I67PZb1tsDtmhLeuH2MidXx76jI3+lrTi+upNzq15He1aPtJffXqMDh
ATtlv/3fBJ0F3etMbFU3/AA9hyRZIn1P7dKpaocM3K4suOz2ETeHV7+BpPhX
/0wCcLvmhjduJxlkZHZpJX1hqWvdul80tpCWeeEF+ipUybfBv5ShZbIw/QT9
IOsU9dss7UneDedZODAzhs0wt2Nu0kTyZAcleVw6Mz+uX6VjhtuVBZfdvvft
XqW0cfOLTay3BW7XlPDG7UTCX1maCQ7TdXV/e4OBRmZ7Z1M/Ty+5FjX7ND1p
DHNzpZCy3E5qeyLtjV/qjrM1k5nIcYWNy54pJZ32pIAvT+/jbMzgdlbgsttD
00OV0saniU9ZbwvcrinhjdvX2brNtbC/sFzr8Tb6thrzLOxHGVsut3ZeOaQW
U8DnnaOGdaTGN6v/7Mcy+mQeb6e6eulMMbcur0dlvI1Z5G8l64fup6c4kNlJ
7tmSe/nB7WqGs24ffH2wstpYKC7s/vdnrLeII24/7GPsPEsXKS+jZrvI/gJp
ptu7NKG+7kffTU90hprehxrdtXjCAV9rl6nta/82R2tC0wbE25vt3Gea2bR0
0JK+monIf1LzSga3bLJzn9iifv75kq3WjNSe91lt8p+C9DFPsEbdzg6cdfvO
wJ1KbObagLWst4gjbt/XsjH1PYWUl87fWsr+9mim28fZm/zxbfEJ01PLqEEu
FfV7L7FyurKyZBaC44u05Zl0fbWt645xJT0zoy3N1ti6DrA2vLyq5JgX9tTb
UJUbYcPtyoKzbn+T+kaJzXwgfMB6i+B2jQhv3E7S0Ysu2klBPvxTanNlgl3S
W0/yRIv76RIhb5LDyePsTCRb/W8aNaJlrWXWziNNzYP2FS9MOEJN76k1pzrz
ycDtCsFNt/e/2k+5zcwvzO9yqTPr7YLbuR8+uX2ame3IzvR9UceaWFe68kSX
xpInEh6hfpykPcC9bqXDF6eb20qPjf99rtZIY0uy1a9fl5y0fbWH6trQCG5X
M8k3bzzu+AnXErXrRzmPX1wg7wD48HWrWG9X6WT4P5M5TrgdbleW2zfYuX1p
bDnfUq55uiaZWksPkgz8mRpiVbmQZ5rbxbyfl+D1Hmqy1fs7gIzWZRY+2kYN
szOS518AuF255Ny6J3Rvw7Xk+cs154Do/JXEroNybtyRq6U37rDerjJaGiB7
e0G4HW5XlturlN4etf97P+JlXk/d8Zbm8mw1y8I+4v1Bzu1Ycu+PNSOL6/bu
VvpVPRK4XSlw0O2Jn/ardLYBcVZ22uLVkk0y1m4V5+ZWskluXsJHXVlvHdzO
8dQct2+2cx9qbTShTe3Z7est6qsrGaC+72uttZV1xaywcZltYT/d3HZckwbM
9U0kM1rXX2XjOtrWZNZntcL2Fy/E+Ha24KDbM1b/UPEx5716k9TjC5mtkgaM
zg+LqHjDtG99WW8d3M7xaJzbv3Yx+9bSQQG3j7GwCN1PyTSN5NxSrSVWTpWI
vR99vVLy0Q82XDNC53/T6RukSi/cOlqXmTS+zIy2N15tI/tTuF0pcNDtuQ+f
lne0pJ7POnBE2KRD2ds275x9XPbU5AeNvXKT9dbB7RyPZrl9sb399mF1V1bl
bqSSon3wx9q/zKYCf6JOLNK+u4l69iN1YLZ2+K/U5I6VjFocYtX42jpqx3id
V7uprZPpu6xuGK1FPiZ+nUv9MJHezx9ztC99r3VjPbV7utbL3dQos3K7d1a3
M17Z0VDm6eB2pcA1tye06yUuLCzzUAuTklMnz6t0D2lzlxamZ5S5B7Eoh/if
9TbC7VwO991OtLzW1m25rdO6T8xuLNX7c4z+xioOIGcyx8Le19plgqn1AkvH
6eZ2M8ztyGfECGPLSjtkyNPNtrAn1ftEU5tl1s5fNKbPn440tvza3I4sHG9q
vdjKaaqZLXmw3Nq54utSV7nbkU+TrX0arnKjn5055Qq3KwWuuT3dd0OZx5l7
92FC+95y7iSxy8C8p8/L3E/qrCWstxFu53I47vZ1tm4r2zY+NaPe2z1aKcfo
OWF2dDNRQOwcCfkseLJJN/csFXeQureq1p7BBktdbOF2pcA1txOHyxyhOC8/
Y/POKu/Kq33mngOl/wUQnb/Cehvhdi6H427f3qchUbpkSdJRakOzqs2OzqmQ
gv/01/UkzRFfpK6v1FnXxAZurz6ccnvCx93F+fnSh1cQGZ08dLzCO0wZPaNA
IJTeYWFmprBJR9ZbCrdzNhx3+z8LPpiGXXCYWulWhdtMcy0b7NyPjNeXblHG
SWprRzO4vfpwyu1pi1dLH5vo3OWEFtUdtZjwyec5129L7zZ16restxRu52w4
7vafBzaSnp7rzW4tXzkmfuFydvUzZOYZLm7RLu31XnZwe/XhlNslVyGJM7PS
Fq1U4p7TV22RDIAXnbrIekvhds6G425f28LSf2fxLfDSjlO/DDOo9NQnx7PC
3fbxD1pE7yRRv1M/j6mzzcsJbq8+3HF7wkddxbl55JDyXgYmfT5U6ftP6jcq
PySc7L8wNU3o3Z719sLt3AzH3b7Bzs3XznFDG7NdAxsu+bjx2vKHjmtKNtu5
L3e32dyj0Y5ehivdbZdbO+FcqlLgjtvTvllOD1/ff6jc4evVT7NO2UfPkFan
TJjDenvhdm5GHrcHHq73qoqJPqz332Gqyjn3wfOKjmsn7tfjfZIP6MHt1Yc7
bs8+fDJlojqUmzb7u6x9f7LeXridm5HH7YhaA7crBHfcrs7JXrgzsQzczrXA
7ZwL3K4Q3HF7zQzczrXA7ZwL3K4QcDvcjsDtnA7crhBwO9fcDgAA1Qduh9sB
APwDbofbAQD8A26H2wEA/ANuh9sBAPwDbofbAQD8A26H2wEA/ANuh9sBAPwD
bofbAQD8A26H2wEA/ANuh9sBAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAmkt+SFja6k0IWymIjZN5R3IjwhN3/IAoN6z8cQHAItl/X42q
Z4awldxHT2Tekcyb14NcbBDlhpU/LgBYBG6H22tCWPnjAoBF4Ha4vSaElT8u
AFgEbofba0JY+eMCgEXgdri9JoSVPy4AWARuh9trQlj54wKAReB2uL0mhJU/
LgBYBG6H22tCWPnjAoBF4Ha4vSaElT8uAFgEbofba0JkXuTg2LTvD/sjbOXg
zTB1Ga7mArfD7TUhMi/yxcfR2v1/R9hKrxVX1WW4mgvcDrfXhMi8yHA73M57
4Ha4vSZE5kWG2+F23gO3w+01ITIvMtwOt/MeuB1urwmReZHhdrid98DtcHtN
iMyLDLfD7bwHbofba0JkXmS4HW7nPXA73F4TIvMiw+1wO++B2+H2mhCZFxlu
h9t5D9wOt9eEyLzIcDvczntYd3uMU9P41p0EnXsLOvaMa9Eh2sqNdd/C7fyL
zIt8/43wVWQKwlYuPI5Sl+FqLiy4Xd9C2HtI+pYfidYKMzNLH1KBMEF09Wbq
stVxrT5l3b1wOz8i8yI/DIwTp2cgbOXxi2hVGQ28R51uj7HzStu4rSA2Xv7D
yw14mTzz26hGNqxLGG7X6Mi8yC//OJtk7YawlahBY6opLlAp6nF7tLEDKdTF
2dmKHWRBbFzSlNmsexhu19zIvMhwO9zOe9TgdmHvIflRSvgXLOfug1j3lqzb
GG7XxMi8yHA73M57VO321NUbxYWFlR5GYUZm1smzybMWCLr0iXHwjjK0jWpg
GW3pGtfq08RRkzJ278sPDadXS0lNGDSSdSHD7UySdjVg/Rjgdk0M3K4GVOj2
BpaZvx2q9ADy3gQlTZ4V3di+0h0KOvfOOnWuMD8/adpc1p0Mt4f3MCvMoVg/
DLhdExPef4RQKExOFylNZKAUqnN75p9/VfzUhckp9HnS+uZV2m182245Dx+T
jwPWtVzD3Z56rN5//1FRX5mwfiSa4vbULr0zl3wvOnAw9+Jl0YUruecuZe/5
JWPW/OSWHViXrZpz0duQKsJnzkGhMn0GSlCR29M2bqv4eXPu+cU6N1Nw//oW
qWs2C/oMZd3MNdnt+UJt4vaMf+qwfiRcd7tz00zfNQUhodIHkPHtd5LHYrE4
7/7D9IkzWVeu2hLSd2hg4PMz2ycTvW94kFwNgYFyUYXbEwaNJL+uFTxp1vHT
UQ2tq/ssw8dFO/qwLuea6fbQNpZiMUXcXpCuxfrBcNnt6ZO+Liw16Dc/4EWy
x0fivDzZ5c+ep3bvz7p41ZD3/e3p230on+2yfwJAKSjd7dGWrgXChAqeMevU
uar2w5QXQbd+rMu5Zro98UcDInYmET3NWD8eLrrdzlP0e9nnmzJXricr5F7/
t/SPxDm5mfO/Y9296nK76GB/uF1VKN3tGXsPVPB0uU8DlHshUlzTtqz7uQa6
PTdcR+L2lEP1WT8ezrndzjP3crlTpiS37kTWIQ4vb4WstZtZ169a3J7+a2eq
M9yuGpTr9ljPVuKCgvKeqzArK9artaptmTJ/KevG5rfbQ1pZigspidvzhdqs
HxLX3J5z+Fh5fwX5gW+ZdZK9W1fwx5IxZyHrBlaD2/fA7SpDuW7P+OX3Cp4r
dfkaVegx2sRB+tvC9AxBx56sS5vHbo9f1kgidibhXc1ZPyruuD1j1vwK/gqy
tuyQrJl39355q4mzRSmf9mBdwnC75qJEt0c3ti/MKGPuL4aCeCF9RZLqbSkW
ifLDI6LNnFj3Nl/dLgqoJeP2xO0GrB8VR9ye7NWqMKmigR+pXftIVs5c8n0F
axLzsy5huF1zUaLbE8dOreCJUr9fq0JJNrCQdjt5uqyjJ8tbmVPTCGuc20Oa
W4kLKBm350bosH5gHHF79pYfK/grKAgN++CDoEX7ikeUpX0xmnUPq9btPnC7
qlCi2zMPldvHSH6BY12aq8eWjNsJMtOLxXq1Tlmygrg0acIM1pXOTbdHjTGO
/65R3LeGsbOMYqY0jh5nHDWSxEQ6STsbyIidCdlEZs2oUcbR441jpjWOnWMU
t8AwflmjcPZG1Mi8yKpyu61HYYWDxLJ/3COzSd7DisyWe/Ey6x5Wpdv/e7DB
x2fDgwpeAaAwSnR7fnRMec9CD49Rly0lbi/MzIzzaRPXvH3qinW5/i+YhVmH
j7Puc866PayjRV6UTpnqrmbEYirzdu0gdyt+u52U2Xl37qd+PiClw+epn/dP
GzA8bfBI6SS5NpfZJLllR5l1Uvt+kdKtb0q7bmnDxuSHhSe5NGNdxapz+/Nf
6UGQ6UpxGfgQZbk92tK1gmdJ375b/W7/jz4h9cGswvmh4dGmjqz7nLNuZ5Ly
mz5zXZLSxJ5Lxc4zYrdRMi+yityevW0n2Xne6zfJrTpW92Ni0MjC5BSyt7QR
41hXsercnh9xjKKoMxH5CvoLlI+y3C74tGcFz5I0dY56VBnf/vPSl/sxkOXk
p6zLnPtuJ4kcbFqQqqUUsee8rRXSypL1Fsm8yCpye+6lf4p/2UQ5GYt9FdyP
o7f0RU+Z369lXcWqczux+6XFPhQ151oI5pVRMspye8KQryp4FmHPwSo0ZH1z
Qde+6T/+VPEs8SnfrWTd5JridpJgb6uM63WqVa4XUok7uDJ+RuZFVpHb8/2f
Sz8LUX2SV6sq7SG1a5/8N0Ef/IXu+YV1FavS7f/9J3pSNG3YBkwro1yU5fbE
cdMqeJb4dt2VL0Z9C2GvwRk//1oQJ6i0maJrt1jXuGa5nUncXKPCHEXEni/U
jujNobkIZF5kVbn9Qy0TCmPj0oaMknPzzMW+pOCX/dX97RDrKlal29MPjqKo
zhueCzHfr5LRYLc3sOSD2x+cIP+Sdl55SfKbzSm3k4R1sMh5IzugveKkn6tL
yn7Wj7wkzuYyL7J66nYGcWFh9tadSTbuFW3r8VHuxStl/4Xyum4XBf5KSvZr
TH9MfqDM2wSqA0/6ZLr1S//fzxX3yaQuXcW6yctw+52/RtHTWJcMFeCa2+m4
WSftbiDPCdbCXCpmRmP2D7iU22VeZFX3t5fx6/f5gAo2zPRdU96G/O5vf05f
vLSn+H0RPZd5m0B14Nu51A49KjqX2qEH6zKXdfujJyHHRlE+ezjtdhIPa3k6
Z0QvarF/qGVF5kVW6TiZ0hQmJiXZelSwYUrnXuX97fB7nMy/K318NpR0S8q8
TaA61KwxkGERXBsDGbHjS1KqHHxech6Jm26PHm8s1/nTAiqkBZd6Y4pyx6qB
zIusuvHtZf7+i/48Uum2MjfvKP4Fzs3l9fj2D65Ljbk0R+ZtAtWhply7FPCS
Wci1a5eybv0dEvNB/yI33Z5+Wd4xM3ELDVk/Wpm8drKUeZHVfF1q2pfjZdf0
+EhmSfb2XWX84fD8utQP5pPJT4+ReZtAdeDznAMf3lOVnnPgu5WYc0CRuFkX
iuQ9kZrtz8VuGZkXWZ3zyRSmpCbZe5as4+xDynixKCdz6UrpDVO69y/9h8P/
+WQwV5jK4O1cYX9hrjClJWpMGR0y4nwq+3EZ42fEBVRwU851y8i8yOqcBzLn
6EnJT1O79S14Gyz5Ue7lq8neH0t+WvAuSnpDzAMJqgPm+IXbK03GDdkOmbxY
nYie9JztMdMaly7p45ZwrltG5kVW5/ztacPHMsszv1tRevh6YWy8ZAB81q69
kuWYvx1UE9ybA26vLLIdMunn6wZ7WUtWCG1vkROk+8FomVec65aReZHVdt8l
cUYGPULGpVnu3+XeYk9cWJi1jR4An9zuM8lC3HcJVBPcUw9urzhRUiNkxHnl
zPrlap1yoGSGMXEhxa1rl9i7X2r23gOk/CbFeaV/iXkPnyQ3b1cQSXfL1Jj7
pSZv98G9sFUF7oUNt1ecrLu1i/thonXC2ld077yoMcaF2cV6F6xoyPqRs+n2
/7N3HvBNVYsfr+Op7z39+9x742S4BZFhGcpGEFGGgiAoKkMEFQUEBBmC7NmW
3QItLaVAaYEOuveedO/dptnrhv9pgyEkbZqmSc5J8vt+fvBJb889997c229O
zr333Fa9Sw57yIIvk2a5kX+MXGOTLDJGuPg36u61dHJGfBQWFHRg1VgnJ6et
ibjo0SKY3e3lj76gNPh4AtGpM2X/fdgsy6oZMoa6nO3e7ZysZfT1Zt//kMZ5
h4Xz33hUmtvSPyO9civ1Nafs9tbwZ801ptGuRpGcxvtgLHXxWiH+Pe5pHR/M
acGeMFz1aCHM7naSuvFTDD8pTHTSt+zux7u6lM++LH+2F3U527fbK769r6Uf
Zn7nRl9vPHAnmetKd4a6ZXTeZKu5vSXdXhX+vqbNW5PUkD8WeXQc/6vvqSvX
aikaN5XP52PQdotiCbeTNG/YYni50qjYym6vmVj/nY/w1mysGfUJdTPbvdur
l9xT8N4jJsxYNv3+0s8eoL7+TLj9n/AGjxL+ukJy0F3mHygLCpWdOS/e4yaY
t7jxrf7UZWvl3DDGL7AMFnI7ifDoCcOL5hqbGr9f1Nn+meq+Q6RxCTr3Jdlu
GHe73UTnTabidgRutyaWc3vZXY8KD3l0uALynCtE1OX3Pd1hhTXOI0WnznAK
RcOcH6g7GW63rei8yXA73G73WNDtreGt3mDMdQKcQCjy8Wuc91PNoFEVz/Ro
ucvprkfLH32h6u2B9VNnCXa7KgqKrrbevl03fgp1IcPtNhedNxluh9vtHku7
naR25ATDI6sbiTQypvKlt6jbGG63xei8yXA73G73WMHtJOX3P8PftF1nxF3j
UVZWNXw9n7qH4Xbbjc6bDLfD7XaPddyuTsVT3Zs3bFEafbkvQZaa0XK+1ay3
OzEVuJ2K2+Oyq1R8AUIrCelm+CIPDGNNt1/LnY/UjpzA/3sH0RonbGNsMWVt
neRSKG/Z6qq3B1J3L9xuH9F5k6NzajNLmxBaOZdQdhVYGApuvzEVz71a/c77
NYNG1QwYXvXmAKYG4IXb7SY6b7J/QvnNYw8jtDJiZbsjpwFzQd3tDh64HW53
wMDtVgBuh9sdITpvMtwOt9s9cDvc7gjReZPhdrjd7oHb4XZHiM6bDLfD7XYP
3A63O0J03mS4HW63e+B2uN0RovMmw+1wu90Dt8PtjhCdNxluh9vtHrgdbneE
6LzJcDvcbvfA7XC7I0TnTYbb4Xa7B26H2x0hVP64AKAI3A63O0Ko/HEBQBG4
HW53hFD54wKAInA73O4IofLHBQBF4Ha43RFC5Y8LAIrA7XC7I4TKHxcAFIHb
4XZHCJU/LgAoArfD7Y4QKn9cAFAEbofbHSFU/rgAoAjcDrc7Qqj8cQFAEbgd
bneEUPnjAgAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAwGHh
GnmCtTs7FdFed9prDQAAwBCKgpLqe3p2KnVvjKC91gAAAAwBtwMAgP0BtwMA
gP0BtwOKJOU0r3DJQ2jFL6yG9iEALAXcDiji4lvm1CcAoZWv/kynfQgASwG3
A4rA7XA7sBBwO6AI3A63AwsBtwOKwO1wu4NTP+iz2pec63qPISEv6odMNlfN
dN2urKiuebJPbc+hdX3H1b05sqbbAMEf28xVOWAfuB1ud3CapszTtmvT1Pnm
qpmu21UqVfUjb2lXLjroZa7KAfvA7XC7g8NftlFbgPzf/zZXzdT7ZEiLXbty
WVisGSsHjAO3w+0Ojmi/p4Uat9TdrvOVRFlWZcbKAePA7XC7gyMNCNUWoDQw
zFw1U3d786I12pWrOM6MlQPGgdvhdoeC+FawaqvY/ZQsOlFZXadSKmUR8Td0
XETGk4nkV6SA+OgpUlhRWGrysqzpdol/sGDTPolPgDwlk+M1q1Qq/orN1yt/
5C1SRiWVKYrKpJciRC4e/JWbTV4WYB+4HW53KOTpObpGffANQz/e01OemWva
sqzsduFmN71Ne/3663t7Vd//mvZva18eZPKyAPvA7XC7Q6Esreisb5VllaYt
y8pu1zlx0PGy+ow1eVmAfeB2uN2hUFbXdda3XG29acuystvF7qc6taz6AZ+Y
vCzAPnA73O5QKK4Udta3ivxiE5dl5T6Z3Uc6t6zXhpu8LMA+cDvc7lDIE9KI
1mqeH9jw4VTeN7/yl/7F+365tvF4c5e3TPzmV1KAFCNT5Ikm7iMru12wblf1
vb1qe33YOG5W8w8r+Ss2N4z+8nrlD78pWL2dv2R907SF9f0n1Dz+Ts0z75m8
LMA+CgUnFCsQWpHJcVmaVVGJJRxfqD1FGhylbVdpSLT2b7lmgUoiNW1ZVnZ7
y7UxMrn2FP5vG65Xfv9ruuVN7WsCAAD2kZwK1LarxDfQXDVTv76d991S7co5
gciMlQMAAMsIN7tqC1C4xc1cNVN3e8PI6dqVyzNMvJgTAOuzz7dUpVLRXgtg
w/Dm3tDf3jzvd3PVTN3tta8MvuErid9FM1YOgOVIy+Pf0jfgwNly2isCbBid
xm3DqC/NVTPlcSBFYp3KzfiVBACL4vxtnFOfgIdHBPOFCtrrAmwVkYuHaM9R
8bHTJOQF+dFcNdN1O9fIE2zaJ3I9JvY8Kz7sLdx+UHrBbEPlAGA5TgZXaa4k
/GlHDu3VAUAX6n0yANgcUhn3zLjLGrff1i8wvwzXANg/Cn5jbUVFLd82vqbB
7QB0ljUHCnRuAhqzKJH2SgGLwj+9aqyTmlUxtFfGKBzK7U18WWYhD6EVhcIe
7pSpqJXc6XxRrfQnxoRq9H4xFvdi2C2S7ANE6mOXHIhJyy5ulNBeHaNwKLe7
nM53etcDoZXyWnvouPh8Rapa5v99/2JxpfiVz8LVP3afFK5U4npI+yTffSpp
r9fSXo1OAbcjcLvxxGY03fRPQ331gXwyJTCmTtN03+5p4rBOgHHS9jg79drD
p70anQJuR+B2I1GpVL1nRKs1/vRHoRKpUj19zKJE9cR7Pwhq4MnoriSwBHA7
48DtcLsB1hwo6P91jIG8MDFM00R/6dNwzfS3pkdpGvOPjAoxXMnnK1Jpbyjo
NHA748DtcLsBrpQKb+sXaOlhdT0v4WnvtoeO2+UpmYK1OxlP809/dtbtNc+8
R321jYnOWJpX4XbaYdzthMXbcywq9oFzYmlvIjAFHbeLDp3srDYRM0ZZUa2z
g+B2uN0wzULFQ8OD1R6+/8OgzceK1Fm298qt711r0r/7VbRmunY+W5qicfiM
1ema6W9Mi1RPvPndgJQrzbQ3EZgC3M5U4HbWwr7bCW5+1x8F5Xu5Rj3x41+S
1VPuHnyptrHts6Ucp9JovNuEMPVjL4oqxXcMuKCe+PW6DOttBjAraXvGwu3s
BG5nLTbhdn1FhyQ2aGz/t0eRgXnDUxo1JdcfLrxq3IcCYB7F6dlOvdZfvx0V
bofbEZtz+9UbFb32UMGrU6+p/sWJYfKObq3V9MzcNeiid0iVkR8KgGkaw3o5
OW1NvH6ZDNwOtyO26ParWoq+/Z8eFRL/qI5vTCytFv974LVZ7hl6yfgPBcAm
jcUxq5ydnKa6a18ACbfD7YiNul1b0eoMX5Bg5LwrXPJ0Lo85F2lbd6sDDY3r
W0YH6xXUeMNUuB1uR2zU7VdvVPStfQNyinUvqW0PkUT52KgQzbwjfjD2QwEw
iKQxf89UJyfnrdofz3A73I7YrtuTcngaPz86KqRT8w7/IUEz70b3QsusILAW
ksSxTk7rY6633eF2ym4vCV/Sy8l51XnNiJxbltP3myOnKC1IZ4+wzPAFCdr9
Kh6BlUbOmF0k+Nd71+9vfWJMKGnJW3RVTUeRbUN7hB6K8wtuGLYdbqfs9oKQ
qS1dZVs1J0HgdspuTwrQ2SPMci6yVqfP3HhF63wokPzukmfpFTYRSZqt7BG6
tF7fvlXTcIfbKbu9ojrfa6r2HQdwO2W3Zxbr7BE2kSu4F/8ZFuz5CWE3vXtN
0cv3daxo7Q+FvrNi1C/+PfBCSZXYCmtuAjaxR6iD+1KZSqn7bNIkcU+73ksG
t9NNzN6ZOnuETTZ5FGn8HJLYMHNNupGK1v5QeHVqZGWd5K5B157Q9OlvKVZb
f+OpaOlrsIE9Qh24nalIr6TkV9zQjwi3001eXKzOHmGQ2kbZ3YOvXZc+YUky
mVLdIDVS0TofCmTKhiOFminhKcwpVMGvYH+PsADczlT0r5OB2+mmKNMGHks0
e22GWsV3DLhQVHmtlW6MovU/FAgyOddtwrWW/BvTIjkOD92zSeB2pgK3sxb2
3Z6c23zzP73rdzpfJDZW57UvIm7vH6jpmXn9iwjNrzS5/8MgdYGb3g3oPjlc
M10zsCSJ6+ky2psITAFuZypwO2th3+0D58TqXOJi3jw4PLhZqKC9laDTJG51
dnLGszlYif6zOeB2uN0AnpeqLCp2dRZty6G9oaDT5HvNdnJawPThq4dDPVMP
bofbDXAusnafb6mBrHDN0/TYfDAvXjN99roMjbpnrE4zXMnBs+W0NxR0GkW+
e8t9ALPXnw8KSyu2jStG4XYEbjeeuZuy1A6/rV/gldKWL4YSqfKpj0LVE/vM
jFapcLbULlEkui/p5dSK1g2qLAO3I3C78TTwZPd+cO2c6ehFiWTKH/vzr51C
7RMQm9FEewWBRVFI+HyJxDbOmMDtCNzeKXZ4lWh6YNz8yv77/rVL379YmUZ7
1QC4DtyOwO2dQqlU9ZgcoXOG9E7nixW1uAkIMIRDub3oiMfpnm8htCKuqKB9
CJiHS3H1Om7/82AB7ZUC4AYcyu2NXh6Z3Z9EaEVeXUX7EDAbYxcnasT+zLjL
UhkemQfYAm5H4HYTyC8Tae5U9Q7RvUsOACMRuXiI9hwVHztNQl6QH81VM123
c4084d8uItdjYs+z4sPewu0HpRfDzVW5PnA73G5Gft6RS8Tu/G0c7RUBNkzD
yOnadm0Y9aW5aqbrdpVIrFO5cIubuSrXB26H280IX6h4bHRIap5t3MkC2IQ3
d7m2AJvnrzBXzdT7ZGpfGaxducTvohkr1wFuh9vNS2GFLT0BFjCIcLOrhRq3
1N2u85VEnpFrxsp1gNvhdgCYQnIq8IbGrW+guWqm7nbed0u1K1cJLdgQgtvh
dgAoohJLdMYwlAZHaQtQGhqt/VuuWaCSSE1blpXdzvGaVTK59hT+bxuuV37/
a7rla+tNXpY+cDtrbs8uEuz2LkVoJbT14VDAasgT0ojoap4f2PDhVN43v/KX
/sX7/ob+dt7c5S0Tv/mVFCDFWroyEtNNW5aV3S5Yt6v6vldre33YOG5W8w8r
+Ss2N4z+8nrlD78pWL2dv2R907SF9f0n1Dz+Ts0z75m8LH3gdtbc7uJbZoVh
dZH28tWfJnoDmIYir6izvlXkm3g3t5XdLtx9pHPLem24ycvSB26H2xG4nSLK
6rrO+tbkvgsru13sfqpTy6of8InJy9IHbofbEbidIsrSis76VllWadqyrOx2
0X7Pzi2rz1iTl6UP3A63I3A7ReTpObqWe/ANQz/e01OeaeKlg9buk9nsprdp
r19/fW+v6vtf0/5t7cuDTF6WPnA73I7A7RQhvhWs2io+ekoWnaisrlMplbKI
eG3jySLjVQoF+ZUsKoEUI4UVhaUmL8uabpf4Bws27pX4BMhTMluumVGp+Cs2
X6/8kbdIGZVURjZHeilC5OLBX7nZ5GXpA7fD7QjczhTSgFBtu0oDw8xVM/Xr
25sXrdGuXMVZcDw9uB1uR+B2ptDpphYd9DJXzdTd3jRlnnblyjIL3t4Ct8Pt
CNzOFPxlG7UFyF++yVw1U3d7Xd9xN3Q3hcWasXId4Ha4HYHbmUKncds0db65
aqY8DqRKVf3IWzd8JTlgtq8k+sDtcDsCtzNF/aDPal9yrus9hoS8qB88yVw1
03W7sqK65sk+tT2HktY7qbam2wDBqq3mqlwfuB1uR+B2B4F6n4w1gdvhdgRu
dxDgdgRud9jA7XYM3I7A7Q4buN2OgdsRim4HAFgIuB2B2wGwP+B2BG4HwP6A
2xG4HQD7A25H4HYAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAF1HWlBcuW4bQivyymrahwAAZqCkUrDzWDZCK2dCS3X2CO9CaNI9LyC0
IkxIpfKXCIB58Q8vv6XXIYRWRs65qLNH4Ha4HYCuA7fD7Qjczj7yqpqaXQcq
125D2kyD52mddwxuh9sRuN0m4MSS+mOncodPon6QMJj8T77Sebvgdrgd0Q7c
zj6SKwXly9alPd+H+tHCTuB21gK3sxa43VZQyeVNpwPyJsxMuvdF6ocN9cDt
rAVuZy1wu80hK6usXLctvedA6gcPxcDtrAVuZy1wu42i4rjmS2EFX3yf9MAr
1I8i6wduZy1wO2uB220deV1D9TbXzHeGUT+WrBm4nbXA7awFbrcbBNHxxXN+
Sn60F/WDygqB21kL3M5a4Ha7QaVS8UMjifSoH1RWCNzOWuB21gK32wGyiuqq
jbsyXh1E/XCyWuB21gK3sxa43XZRKRQ8/0v5n85Ouu8l6geSlQO3sxa4nbXA
7baItKC4YuXGtJfeo3780ArczlrgdtYCt9sQnETa4OV3ZfTn1A8b6oHbWQvc
zlrgdptAnJFd+tOq1Kffon7AMBK4nbXA7awFbmcZJV9Qd/BEzuCPqR8nrAVu
Zy1wO2uB29lEnJlb/P2SlMdepX6EsBm4nbXA7awFbmcTTiZr9DmXN2469SOE
zcDtrAVuZy1wO+NIS8oqVm9O796f+qHCVOB21gK3sxa43SZQKZW8wJCCKd8m
3f8y9WOGhei7nR8Qnv6/3gitFI+fp7NH4Ha6gdttC3l1bfXmvZlvDqV+5NCN
vtvF/qHFTs8jtFI9fKbOHoHb6QZut1H44TFFs35MfrgH9UOISuB21gK3sxa4
3aZR8Jpr9x3J7jea+oFk5dif2/2eeCfH6TnqqwG3203gdvtAlJRW8sOylCdf
p35EWSd25vbEB970WbHu9MBx1NcEbrebwO32hLJZ0PIkJtoHlRViT26/4tTt
6Nc/nP1ry9n1W6IefYf6+sDt9hG43T6QFpe2XCr5Sj/qR5R1Yk9uj7j5Wb8t
u45t3nZ+t2vAoE+orw/cbh+B222aa7c4fTSN+oFk5diN23Odntvx9lD3I0f2
7NmzdevWDTPnxDg9Q32t4HY7CNxuo4izrpT9+mfqs+9QP4SoxG7cHuX09LpZ
c3x8fC5evHjw4ME9q/70feND6msFt9tB4HbbQikU1R/xyvlgIvUjh27Yd3um
03P7n3qr0KmbgTJFTt0OvDPswJLfXV1dIyIiSLudSP7vQWPSnZ41XPmlu14O
fOh16tsIt7McuN1WECamlsz/LeUJR7kSxnAYdzuR9nHncZHnA4NfH2bY/x49
3i8qKoqJiSkuLiZ6T0tL8545P/LeVw3MlX7Tcz6//XFm886U/3anvqVwO7OB
2xlH0cSr3Xs46z2Hu4LdcBh3e/TtL/hs23X+/PnjC39Lve3F9oolOj2zd/5P
ISEhp0+fTkxMTEhI8PPz27967cU+o9ubhXwROP/ce6RmUjJgwPg8g98L4HZH
DtzOJiqVih8WXTRrocPeeWo4LLu9wKmb6zsfeh07tmvXrsOubr5P9W6vZIbT
c74TZpaXl588eTIrK8vDwyMyMjL6gHvkf15ub5ZIp6cPfL1g//79a9asObnm
r+hbWLndCW5nLXA7m4hSMvI/+9oBH3JtZFh2e4LTM3u++Jro98SJEy4uLvs/
mJDfTuv6stNT+1esCQgIuHDhwsWLF+Pi4nwJ7h5nXxva3j2qZ+/odnjHrsOH
D5OaD+3Z5/8EK9fDw+2sBW5nGXllddXGXRmvDaJ+nLAWlt1+6dZnfd0Onj17
lhj76NGjB39aFu70tH6xRKdnXOct9p71Q2lpaXh4eHV1dVBQUFJSUsyREy7j
p50d0MY9qslOz57p/9EpDw/ycUCa+r7k38gpmWyMVAC3sxa4nX1a+mdCIwtn
Lkh+qDv1A4aRsOz2LUPH+e51Je3w+Ph4f3//fQt+OTtmmn6xg28McZs2x23h
kgt+ZyJCL0dERGRnZx/bf+D4mg1Hfl15/Lk+lx9+U2eWkKf7uo6d4ufnRwqT
D4KQkJB94z+Pevcj6psMtzMYuN2GUDQ21ew+mNV3JPXDhnrYdHvgG8MOzpib
djaQtNgvX76ckJBw7ty54ODg9L/36Rc+u3TNyUOHMzIyLl26FBgYSFrv5IOA
SDs/P/9yUPDxRb8lPP++ziyJ3d5PTk4+duxYVlZWTEyMj49Penp68MSvTw+a
QH3b4XbWArfbIsK45JK5v6Y8/hr144dWGHR7gtPTexf95rZ7T2Z4NCEnJ6eg
oICoWO321NtfLryx8yRwwzbSUCcfAUTUxPDk21l1dTX5sa6ujjT4L7keiu92
g9sjb3+RuL2wsJBUnpmZScrExsaSGY+t2XBp2Vr/t0bA7Yh24HbbRSkQ1h06
kTNkAvWjyPph0O2XnZ66GBh48Zx/blRsRCstnecxMeT/qFNnTp486em6P94/
UJMLgYFE0eS3p0+fJk338PBw8uPu3bvLyspyc3NDgoODvE9plz988KCvt09R
UVFAQAD5yEhNTSWLKCkpiTrmfWm3W9zn8+F2RDtwux0gzswt+2V16jNvUz+c
rBY23X7Mw2O/q2t2eHRLw/vSJdLAJt4uLS2NOON/6NAhNze3NC1IE52UcXFx
WbJkybp16xoaGkiZhQsX+vr6nj17lvwqLCxMu/zWrVtP+/qSVv3FixfJr8jX
ASJ58uOFA0cP7NwVD7cjNwZutxs4qazB60zu8EnUDyorhE23u7u7E6t7ue4/
4+ND/NzU1ERUH+J//sgel4SEhCNHjlT8Q3l5OfFzVFQUac9v27bt2LFjSqWS
NNc3bNgQGhpKGuTkt6RJX6FFS8vf0zMhKPS4xzGielKYVB5/Kdhjy/azfn6x
U+fB7Yh24Ha7QZKbX75sXVq33tQPKiskf8KEJb2cnFedl/yz+dTdnuH03LGd
e44ePBQZGenfSkhIyKVWrly54nH4CNF17D/ExMQQV2dkZMTFxSUnJ585cyYw
MJB8HISHh5PWeFFREZmLNOxjtdi/fz8prK6ZFCYFzp8/TxbR0ktz0iem20DK
bh/2sc4eESam0flLAK2I0wN09giwLTiRuP7YKQdprl93+/jxU52cnHpt5f/z
PlB3O4nvQ6+mJSWT5npWVlZ6erpEIiHeTklJkcvlMa3d6blaEL0LhULSIK+s
rCRlRCIRmYu053NycsjmkPZ/dna2dnmid4FAUFJSQgqQWWpqaqKjo/Py8pqb
m08v+JX6tld/OE5nj8DtdBEnn9HZI8BWEKVklP74e8pTb1A3LQW3f/JVvtdU
p157mHL7+btejgi9HBoaSjSucTtpnJMWe+A5/9TUVOJn0qonDidaJm1v4nbS
StdxO5m9qqqKNODJxMTExIiICPUVj6QkmUimkB/JLLW1taQq0pJvqfyHZdS3
vXr4TJ09ArfTRZx1RWePAMZRNvNrXY9mDxhLXbAUE9W/B2mSuKc1at4WRtwe
FhyS2Yq220nrOujCBeJq0hQnr8kU0vYmWiZuT0hI0HE70T6ZQtrtaWlppHx+
fj6pjbwg5UmxpKQkbbeT2ckUFtye8pbuHoHb6VKwb7rOHgHMIoiKL/p6cfIj
PamrlXpyxk3Or7ihH5EptxN7O5rby4dO0tkjcDtd+PEROnsEsIa8tr56q0vm
Wx9QNyo7YfA6GRKv/3U/sv+Au7v78ePH/fz8iN59fX1Pnz597ty5vbv3HDp0
6GgrpAD5f9OmTUTLe/fuvXz5sqenZ2pqqr+//6VLl0ixmJgY8v+RI0c8WlGX
37ZtGyng5eV17NixiIgI8hFAluLj40MWtHTsxELao8roXycDt9NFnHWF9iqA
tlFxHO9CaMHn3yU98Ap1l7IW1tye6/RcyGdzNvz4k98Jz0MursTYhw8dIuIl
it69Y+dhF1ffYyc8d+0943bwWlwPeO4/4HvC8+SJE6779h08eNDb2/vw4cOH
Dhzw9vI6sn//6ROeBzZvu17e7eD+7TtJeY/DR9yPHCFWP3H8uJubG/koOXnE
3X3nnlMz5sW94Ay3Aw1wO5uIktMzXh9MXaHMhjW3X374zYQz5/PCo9WJOn8h
JCSk5Y7UqKgYP3/N9DYTe+Y8aairT5uSGQ0XJkmIiAxrJfTCDYUvTPku97aX
4HagBm5nFkV9Q/V2t8zew6iLlMGw5vYc77N8LTIzM9PS0sRicUpKSmFhId8g
RUVFpJhQKFR31BsuTEhPT6+oqKiuriYfHNrTm5qa4rsPhduBGridfQTRCcXf
/pz8aC/qRmUn7Lg949+vhH3zc/DmXZf3HdTE3+0QabcTYxP9nt60TftX+jm9
aXts67AzpN3uv/+w4cIk4f4Bka1c8PXT/dWilRG9x8Dt4CrcbjsomwV1+49l
O4+n7lUWwo7bk+57nTSYdVaGtNU1bq+trTW8Z+vq6uLi4tRuLygo6PBIyM3N
Vbs9Pj5e/7fx8+hcMwO3swbcbnOI0rNLF61MfepN6oKF25Of6BsyfGrU4WMp
J05pJ+SYJ3F7cnIycXuwy0Gd3+oWdjkU29rfHh4eHnLcy3BhkpiLQepxJoPP
+uv/NnDer7E0ntYBt7MG3G6jcBJpwwnfKyOnUNesI7s9btJ3EolEqkdOTg5x
75UrV2JjY8vKyvQLaFNeXk5a4GSWmJgY8r/hwoSsrCzyQaAeQLjNAoXB4XA7
gNttHUl+UfmKv9JeeJe6bx3T7SKRSKxHdnY20W9DQwMxcElJiX4BbUpLS0mx
urq61NRU4m3DhQmZmZkFBQXFxcXE7W0WyAkMhtsB3G4fqBSKpjMX8id+lXTf
S9TF6yBuj1m0MtvnbNa5i/oJ9/HT9LdHeHi1WUaTSI+TmnOp4afOGC5MEhdy
Wd3fHhJwoc0CmWcC0w57Jj3aG253ZOB2e0KUnl0w5Vvq4nUQt+e6n2xvR6jP
par72y1xLlXd397muVQ1fD4/sZvu41bhdocCbrcDWi6hOXA8Z9DH1JXrUG6P
Xb6hMDCkzUR5n74YEJibk3M5KCj5pF97xdRJ8T5z4dy59NS04IuXIr1PGy5M
cvn02eioKNLU9/f0aq9M3vlLCY+/C7c7MnC7TSOISSz+7hcHvPSdBbcjcDvL
wO22iKK+oWaHQ9+yCrezFridNeB2G0KlUjUHRxR+OT/5we7U7Qq3I3A7y8Dt
NoGsvKpyw46MXs7UpcpI9N0eEFF++xuHEVoZ8/0lnT0Ct9MFbmeZ61c23vsi
dZ0yFX23+4eX39LrEEIrI+dc1NkjcDtd4HY2kRaWOOAdSXC77QZuZw24nU1a
HorqcsTBH4oKt9tQ4HbWgNsZR5ScXrJwecqTr1PXKVOB21kL3M4acLtNwInE
9R4+ucMnUZcqI4HbWQvczhpwu20hyc0vX7o2rVtv6naF2xG4nWXgdltEJZc3
+p7P+3iGw14/A7ezFridNeB2m0ZWVlG5dlt6jwHUZQu3O3jgdtaA2+0AFcfx
LoQWfP5d0gOvULcu3O6YgdtZA263J+S19QVffE9dvHC7AwZuZw243T5QNDbV
7DmU1XckdevC7Y4ZuJ014HabRqVS8S9HFX31Q/JDjjV6GNzOWuB21oDbbRR5
ZXXVpt0Zrw2irlm4HYHbGQRuty1USiXvfFD+pG8c5LmocLutBG5nDbjdVpAW
lVas2pT2cj/qXmUhcDtrgdtZA25nHE4qa/A6c2XMF9R1ylTgdtYCt7MG3M4s
4szcsl9Wpz7zNnWRMhi4nbXA7awBtwP7AG6H24E2cDuwD+B2uB1oA7cDACwB
3E4XuB0AYAngdrrA7QAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAwLZQFhaLN21FaIWrqtbZI7WNYrFEQeVgsBvic1JWHNyEtJeKuirauwhY
HFlwaMPj3RBaUSSl6OyRwJiSZ8cfCogupnI82Ae7fA/d5Pw40l5is5Jo7yJg
ceB2Bt3u1Gc7yaRlAdUNIipHha0Dt8PtAG5nze2kxa52O8n/huzdeypdpVJR
OTZsF7gdbgdwO2tuV7fb8+/vR6I2fN9ZXhkF9VQODxsFbofbAdzOmtvV7Xa1
2zV6/9d7O3/dHYVzrEYCt8PtAG5nze3a7XYdwz/38aELsSVUjhPbAm6H2wHc
zprbddrt+oafvDywBudYDQK3w+0AbmfN7W2223X0fs/Qfa6nM3GOtT3gdrgd
wO2sud1Au13H8P2/PplZ2EDlsGEcuB1uB3A7a2433G7X0ftt/XYu2xstkeIc
6w3A7XA7gNtt1O3ahn9+wuFLcaVUjh82gdvhdgC327TbtQ3/xcoLtY1iKkcR
a8DtcDuA2+3A7Rq93/eBy/4zmVQOJKaA2+F2ALfbh9u1DT9wjnd2USOVw4kR
4Ha4HcDt9uR27XOsv7vESGVKKgcVdeB2uB3A7Xbmdm3Dv/DJkZDEMirHFV3g
dri9QziZXJhVUHMqqHyvV/HGg4V/7CnZdKh8n1etX4got4hT2Py1Z3C7Xbpd
2/DTV12s5znWOVa4HW5vD15sWv7S7fF9pwb96/VLTj3bS9DtbyQMnF6wcjc/
JYf2KpsI3M6a2425d6mzer//Q5eDZ7OoHGBUoOX217764N7R3amrG27XR9Es
KFrnFvXiaAM+by/RPceXbj2qFNlYAwluZ83tZmy36xje+Vuf3BKHOMdqZbff
N7bH8v0bt5x0/feH3ah7G27XQSkU5S/bHnL3uyZYXTuX7+9ftNaVk8pob5Cx
wO2O4HaN3m/vv3OVW5xMbufnWK3m9rtHvbzh2C6BWLjvjDt1Y8Pt+tR4Xwx/
YkgXra6dyG4j6gMjaW+WUcjCIponTLbR1EycRH0duhhFSprOHrGQ27UN/9Kn
Ry4nlVM53qyDddw+dc3c6oZasrj9/sep6xpu10EpEmd+udSMVtdO7oL1nFxO
exM7QK7nFhtiXoJrTF0u7bXoEooc3fU3b397e4a/qc/2mWsuNfAkVLba0lja
7f838qUTwX7qZV1Oif7XkKep6xpu10ZSWhXdY5yFxK5OXO/JslqmR+qzXbcH
Vibf7DHe+dIy2ivSJai4XdOAf2CYy5HztnoZgAEs6vbnp/bLKy9UL6imse6B
j3pRdzXcro0gMz/8cXP2w7TbP/PCKHERu99/bdTtAZVJ/z3xmZPHOJLVGV60
V8d0aLld2/BD5p7KK22isvkWwnJuf/Pr4bVN159dO375V12ssPecUQPmfwy3
mwtRXsnlBwdaQezqRDz9obSihvZGt40tun1dpvctxz5Wi12dn5IP8WRC2utl
Cvput2h/e3t6v2PArtUH4uQKOznHaiG395wxpEnA0yzFL/JC1+sk3wJInd2/
HAS3dx1pdX3Es8OtJnZ1onuOV/D4tDe9DWzO7d/E7da2uiY3e4zveW7+nLg9
4bW2dCF319vt9St2kf+LX/u4etbvXTT8K58dDU+poPI+mBdLuP2pz3pX1FVp
FsFxnFmEfOfwF0htpTUVj33ylvb0Rye8+cfhLc9O7gu3G4mK4xKdZ1hZ7Oqk
jl9Ae+vbwLbcns+v8iuPmxW7s029azL28p81EtvoZDC53V42eGbVV8sLHh+k
ksnrV+6WJGQITgcXPDW0Yb1bVwx/U5/ts/4Mamy27XOsZnf7bUOfictO1l6E
Z8gZc1XOFwlIhWkFWXePepn8+PY3I90v+sgVctdzHpYQu726vWDFLipiV6d0
hwftN0AX23J7maju04iNhsWuzkM+00Oq02mvb8cY4/ayD2fre7ik9ySVSsU/
HSwrLFdJZUq+UJKYKYlLl6ZdafuzoK1K2mvAPzjc1SPQhi9AMrvbN3u56Cxi
4PwJ5qo8t7RAXWdURkJkerz6NU/Q/OC4V+F2IxFk5hseQ8DSCf7vO5Kyqo5X
1IrYitslStnPyYf/5zXlSd9Zxrj97YDF/S4sIY182iveAca4nbffhzTINT8W
vzmR7xlQv2avLK9Ev0KBX2jTDo+mPZ7aNVROWlw1c1lnu2g+mOdbUM7TXwT7
mNft78wZxXGcdv155YVmrD80JUp/E37YucJCYrdLtye8/yVFsV/rmfn4B9pv
ww3YhNtJA/WziE2kKf5VzM51md4agT/h+xXJy2e/H3P5T/Lju4E/3+U5Sf2r
KZGbxQop7RXvGGP62xvWuzUf9tOeIjgVJE3Pa69OaWZ+1bRfNYULnx2mKK8u
eXeKCT3w/x6468+D8TZ3jtWMbr950BOJubp/IxtP7DFL5S983n+n70GRRHeg
kqziK7cOfgpuN5L6wEjqYlenOYGhJ+PYhNvVZDSV/PvEpxqxb8g6peSUqzO8
BgctX5i4v/u5eeRH4nlNATIlvr5dATKCMe328hFzyPSa+WtbRP3c8Kovlzbt
M3TZp7ysqmGda/mob/MfHJD/8EDhhSjidpN74El6THaPTK204Ltgbszo9okr
v9Gvf9DCiV2sduiiSeeig0ijpc31N9dnh4O4PWHAdOpWv9Z0Hzef9ptxHZtw
e5GgZlzYuntPfk6M3c1vTlBV6nN+38xNcHG+tExzMeRNHuPu9ppCXjzlOzu5
sTCwMpk09UnhRUkHS4V1tLegXYw8lyovKFNxXM33awqfH0FcLUnq4FogZVNz
/e87Cx4bJPALIT82bjpomts1hr+pz/Zv1oc08W3gq9BVs7o9JU+3JUaE/H8j
XzK5wv8M6/a35z6eoNnA+nMc98mKr+F2Y+AnZ1NX+vXc1FNSwkoriH23k9b4
i2e+Uwv88VNfVYubvEoiDfS0E8nPjt1lZ9fJ1Mz7U/1b3j6vwhdHCvzDDFdb
v9al5J3PpKktlXMCUdHLo7vidk0D/uERbscvXrHE+2BezOX29xdM0K88t7TA
LJW/Mt15xoYf951x19zlqo1UJrXcPU325PbcHzbQV7pWCtfso/2WXINxt9dJ
m6dGbdZ4+4Uz3w4OWq7vc809qprcf/KL8xWJtFe/Y4y9BvKB/uKoayNGqhQK
eXEHV6GrFEqV8trpv9qf/+6i2HUMP3zB6cIKQ81O6pjL7fv9j+tXHhgXal7T
Dlo4UVN5an5WHe/aKCWWu6fJntwe9ogzdZ9rJ7rHONpvyTWYdbtQIVma6n7n
P+dGSe44PvEp39k3e4xX/3iX5yT3osuRtdn/5zm5UFDdzW8OMfzI0NWaC2lu
Ofbx3rxA2tvRAcZf307a3oryak2x9rpqdX7FP37eXGLX1vt/Bu5efzhRoeDa
Wwe6mMXt/xrydLOwjfsNzT7q40tfDFTXXFpT8Z9hLSPAPzflvSmr52732e8T
5m+JKyHtxu2CjDzqMtePtIqJTmA23R5cnaZR9KjQ1fvyLjzkM52YXMEpu5+b
p7H9rcc+/texCY+emjE6dA35UX3FY42kSbsBvzBxv5xj99GHnbp3qaTvVHlR
J+4bFfhcyn/U2bxu1zZ8rykeMRlsXdOrxixuf+/7j9qsnCjXvKa9e9TL6po/
XTnH7Bq3b7eXbnOnbnL9VHmco/3GtMCg2/P4lXd7TXnxzHdz4vbMjNnxWcQm
MtGnNJq0ySdG/GWgp/3Z098Qk5NZdKa/ef7H9KZi2pvVNp29L7Xw+RGi8I7/
MFUKZf2q3Zawuo7eb353+7cbQngCts6xmsXty/b/1WblW066ml22Yqk4NCXK
OmK3J7dbboT2ruTK4k2035gWGHS7NqTJff/JL76L36e+gt3kkBY+0T6D44mZ
NuZA5eSfxJHJbXbLcEJx85EzxW9/alGx6xj+kZFuXkEMXW5qFrf7hPm3Wfke
vyNml21uaUGvmUPg9s4S33cqdZPrJ2XMXNpvTAuMu71RJvhf65WNnco9XlPT
moqXpXqQ13d6TnK+tKz7uXl3HJ/4sM+XQVWptLfpBroyVlhRz3HVc/5o3Hy4
+dBpnpt3/eq9lZ/+WPDkEOtYXd/wIxf6FVcycY7VLG7PLGp71AXvy/5ml+2k
P76zmtjtye1hD79P3eT6YeR0Kstu51TcqNDV7Qn8w+CVj52a2eav/nPi0205
ZyeEbyCve56bn9xYqK6tTFRXK2HrJnrqY/yaV+//fX/3RvckpZLyOVazuF0i
a3vANCJGa3oYbjdA8L/fom5y/YQ/MYT2G9MCm25XqVTx9Xkj2xL7rNidPyUf
Up8kJW6fl+D6buDPHbbkH/CeRlTvkn+hUszWY7DoPpvD7G5X57XPj8VlVre5
vdah626/begz7VUuFItuHvQEdT/D7SqlkrrG20zo//rSfm9aYNDtYTWZz/l9
Y0DUpCmueX22PP5SVerUqM13HJ9oTHfNzR7jh4WsEjEz1Ex77XaS449/1FnB
Jj7o3P21ldqapZWb390+d9NlvlBG5V3tutvvG9vDQP0vfTGQup/hdrj9BhTZ
S3o5Oa86r/m2yZrbvUujbzv+idrDfQJ//jXl6OZsv205Z7XvYNLOvSc/Hx6y
anDQ8ge9p7dZ4H9eUxYkuu2+EuBZEhlQmRRbf6VeytBDUhQZ53X2iLrdbprb
mdI7yWOj93uH5OsfdZbG0m6fu20ZdT93ye3pPlbeIxYCfTLXkaRNdXJy6rVV
Yzem3H64MOTW1vFhup+bR5ru38btVU8XK6SLkw6adoXMo6dm/Jx8eEfuuQIB
i1diK1LP6OyRLrpdR++vTvWITK2MzaimGFFTks42WhqL9skQzscGU/dzl9ye
7GnlPWIhcC5Vm3yvqU699jDo9pOlUU6towf8mXFSwSlzmsvvOD7xj3TPGTHb
1aOEdTHkU2NrzhnaW6mLIidXZ490pU+mTb1/8ut56jeQ6myjpbHouVSCQql4
5OM3qCvadLdnJVl5j1gIXAOpoeL8AvJx7Z7WqJnCjtsJV/gVTf9cgl4lbtR5
4LXxDv815SiZvUhQc1PrlAe9p2uq2pjlS3cbdShxmaazR8zidqb0rn/UWRqL
XgOp5jfX9dQVbXLO7pti5T1iIXDvkgYFvyK/4obWCFNuV8OpuEOFwY+emqF/
GtQYtz/pOyuu/kqJsHZ27C7y4y/Jh8m3gDPl8ZoCcxNclBwrD5uQJIbr7BFz
uZ0dvesfdZbGovcuqaluqFWP/WKLiYoPtPIesRAYc8AArLk9pbHw9fML25T2
51FbEhvyb2q9NUndDv8r65ThUQge8plOvgvIlPJRoatJ650UVo/x/kHwiiY2
7lE173UyzOrdylh0zAENP+9dQ93SpsU+rpO5irHCDMKU2/cXXLr9n4tk9PP0
6dmkzAPe0wYHLd+Xd4FMOV+R+H38PmN6aV4++32zXERmb5DySUu+m9+cTyM2
sjCGmHnc/kB/6F0bi44VpoEvEjwx8W3qonZkt1/FGL/tw47b12R4aWxMWuar
M7xOlkZ9GLxS29Lfxu1Vt9hfOTuX/N9eC18//znx6bmKBNqb2AZmcXvdr1uK
Xx0PvWuw6Bi/2pyLDqIuagd3O57N0R4suJ1TcZpLHO84PnFO3B7NU5NWpB3v
+hUymnwWsalIUEN3Y3Uwwe0tGn9ooHajXV5U0bjliKEyDqZ3iz6bQ4dFu/+g
7mpHdjueqdce1N3ukn/hKd/ZpDX+3oUlW3POaG4sKhHWTove2ll7jwpdvScv
4P1LS9srcPvxTxYlHWRnQEgT3F45abEkNq2o5zjNj2QuZX1TwWODNFPkZW08
/Npx9G7RZ+rpoFQqP1g82TpOvuPDZ+F2ffAs7Dah7varrU/TECqunbWXKGWn
y2I/Dlv/r2MT1DZ+5ezcvXmBddLm0JqMF858a0Ds/+c5mcyurieqLod8F5gU
uWlixF+TI/8mHxOfR20ZcPE3dZfOwz5fniyNorfF1zHB7aX9Pr/aKvOKiT+S
H0VBMeoZa75fQ9rqjduOqlQqWXahI3fOWPRZ2PoIxaL+88ZbWux9vx9rrqrs
zO31gZHUra5Oc0LHR4vVYMHtBJFCeqw4jChd8xC9mzzGDQ9Zdb4iUXuUctKY
v7X9i95f9f+hwwXl86s0Q8HPidtD/WJIE9xe8NRQdUnyzjRsPSLNzJcVlMny
SoT+YaKwa+cUhIGRjtz3bka3T1z5jTFLFIiFgxd+ajmxz9ywqNuU9+D29kh4
/0vqYk/9uGP/WBNG3B5Zm/2QT8uAMHd7Tel3YcmKtOOFgrYHEnzKd3Z7bn87
YLGRiztVFkOa7mSW5ake5tsIUzDtXKqysZnjC+WVtTrzqjhOXlROnM9z83bk
U6tmdPvNg55IzDXqb0ShVHy7+VezW/3WwU9tOenqes7DjHXan9sFmflB/3qd
otiD//uOpIytUU0YcbsaA893VtMg5Ru4WfU1I9rtGhplgj8zTlK/eMZItzdu
PiwKjm0+dLr+jz3Vs1cIL0YbeK8Ujc0NW47U/LC+cdNBvlegODq1fMz3DqV3
M7qd5J05ozjO2PfH+7L/Ax/1MteiX/xiQGR6fENz431je8DthilYsYui20t3
UG4l6sOU2ztkVfoJA/3tj56aQXsFO42Rbi985kPNU7DlxR0/DlvZxFcprl29
314b3o71bl63k2z2cjF+6XW8BtKA/9eQp7uyxLtGvLji4CaprGUw6imr55p3
c+zS7eRLa6LzDPTGaLAhtxcIqv5z4lPD18kUC9m6xLFDjO+TKRs8UyWVkeY6
JzFq8Hl567VY0pSc/EedHa1zxuxuv23oM3HZyZ1ah/zyou+2/EYU3dllPTz+
9d9c19fzrg324nbumHm3xV7dTpBW10c8O9zKYo/uOV7BY3HQNVtxu0Qpeytg
kVrgD/t8qb599SY9t8+M2UF7TTtHp/rba3/aJM0uML5yeVl18ZsTDXS826ve
ze52kqc+611R1+kOVb5IcPSi98SV39w7poNOlcc+eWvmhkW+EQEK5fXbpaMz
E//9oflHrbFXtxNEeSWXHxxoNbFHPP2htILR9qRNuJ2IfWzrxS0PeE87Wx5P
pjTLRXH1V6RK+bCQVTp638LeQL4GMN7tBU8Nrf35b5kRHTIa+H4hFZ8sNOx2
u9S7JdxO0nPGkCaB6c/bLago9gnz3+bttsRl7cKdKxfs+H35/o07Th04Fx1U
XtvGDS9ZxVfM283uCG6/2npeNfzxIVYQe+QLo8RF5bQ3t10Yd7uydQjHXv4L
iLSdLy0rFeoOwpPRVKJ+AN/I0NUkr/n/QJr0y2hf/WI8xri9pM9knstJTtAy
Ho7K6JN6BFlOUcv/eSV1S7YUPP2B4+jdQm4nefPr4bVN9VbYhNT8LMsNEW/f
bidISquie4yzqNjjek+W1bL18GUdmHU7p+JWpB3vHfjThPANPyUfCqtp96YA
gVw8OnTNocJg9Y88mXB82LopkZtZGAqsQzp0e+nAadKsTvTDaCP/p1GhUir5
ngEFTw5xEL1bzu0kz0/tl1deaNH1D0qMuHvUy5bbBLt3O0EpEltudPfcBes5
mZz2JnYAs26fm+ByojjCyMLkg+BSVarmR2J10oYfEfIH9VuTOsTIPpnysXMF
Z0KJolXyThxR0sx8ZQOvcevR4tc+7rBnxp70blG3k/zfyJdOBPtZYs05jvvj
8JZbBj9p0fV3BLerqfG+GP6EOftnIruNqA+MpL1ZRiELi2ieMJnBJE37rCuz
N06YFDj706YJk6hviOEo9D5bDZxLLe4zWZJm6GFAOjR7nNMMMmNk7EPvlna7
OlPXzK1u0L19rCtkFOZYYewCh3I7QSkU5S/bHnL3u120+uX7+xetdeWkMtob
ZCyy4NCGx7shtKJIStHZIwbcLjgVJC9v+3ZdfchBqFIoq6b92im324fereN2
krtHvbzh2C6BuKtDz1XWV8/fvvzWwU9ZZ7Udyu1qFDx+0Tq3qBdHm2D16J7j
S7ceVYrEtDeic8DttuL22n8ewqioNeoxl/LSlgv2lM2CDi+DtD+9W83t6tw3
tsfy/RsLK0tMWNWE3NSvN/18+wfmGeARbu8QXmxa/tLt8X2nGh6jIOj2NxIG
Ti9YuZufkkN7lU0EbrcJt6tvXFIXUDbwOGEHTQhpzvWTfYZvX7JLvVvZ7Zr0
mzturfsOYk6l0tCJHrFUfCkx/FeXda9Md6ayno7sdg2cTC7MKqg5FVS+16t4
48HCP/aUbDpUvs+r1i9ElFvEKWzgSgzDwO024faa+WtrF26o+GRhSe9JBY8N
EsemEcO3u08LShvWuRZ2G146aEbVF0vqlm4rG/Z1Z91u03qn5XZNSDu8+5eD
xi//irTJF+3+Y6nbhh92rpi1cfHIX77oNqWfpU+Vwu3gKtxOO53qb9eEE7cM
OyAvrtQeClLFcbK8EmVj89XWs6gmyNxu9E7d7YwHbncE4Habc3vRS6PUJeVl
1eUfzeP+OcUjOHu5/ved6iHCxBFJZnG7jeodbofbAdxuc24vGzrrauvTNwq7
DSc/8ty81TOWj/qW/Fg+Yo6iokZeXGEut9ui3uF2uB3A7Tbn9qovltSv3K35
seTdKWQuaXqeZkrhCyOFARH5Dw5wWL3D7XA7gNttzu360hZdjq9ZsE632AP9
zeh229I73A63A7jd9tyul/Ix3xc83rn7T+1b73A73A7gdjtwuzVjE3qH2+F2
ALfD7SbovQfbeofb4XYAt8Pt9qd3uB1uB3A73G5/eofb4XYAt8Pt9qd3uB1u
B3A7a24PiC62Fbczq3e4HW4HcDvcbn96h9vhdgC3M+v2o0+My76/v00k5qHB
L72+ih29w+1wO4DbWXO7pr/ddkNd73A73A7gdtbcrmm323To6h1uh9sBAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACghbK4TLzDFaEVrqaW
9iEAALBDZJejGl5+F6EVRWom7UMAAGCHwO1wOwDA/oDb4XYAgP0Bt8PtAAD7
w7xub+w/kvfR57xPv+KNndrYdzh1c7IfuB0AYAm67vbG90YIV28i9XB8gU7l
ipIyscuR5pnzG95wpm5RNgO3AwAsQVfc3jR4nPSkn0qu0KlTmV8k2rizadQk
6uZkP3A7AMASmOx20cYdKolUpzZlUQn/u5/anav7e9RdylrgdgCAJTDF7W8O
loVH69SjUqnErkcbevU3MKNw6Z/onIHbzUJRheCvo9krXNIRKnEPKKZ9CIAO
6KzbG98ZqsjM0alEJZMLfvitw3nlkXH873+mrlOmArebRlxWA18oX7Qt+bZ+
nk59jiNWzvAFobQPAdABnXN7z37y+GSdGlRKJf/bxQbm4o2fJt57iEQlVyhS
MsgL0aZdDa8NpO5VFgK3mwZxu/pFfplg9KIw6q5ztMDt7NMpt4sPeOjXIFy7
pcMZhcvXqaTXOucVWblNH06gLlVGArebhsbtai7GVnWf5E/deI4TuJ19jHc7
b+IMlUqlM7s8IsbI2WUBQepZmqd9R92o7ARuNw0dtxOUSm7bidx7P/Ch7j1H
CNzOPsa7XZ6QojOvSqFoGvaJUbP36s/V1gt/Xye7GCo5eIy6UdkJ3G4a+m5X
08CTfrsh4Za+J6jbz74Dt7OPkW5vnjxbf16pr3/bhT+fozOladhE3pgp6tf8
eUuMmcVBArebhsbtKpWSq3e/9lqcof5qmVHAGzI3hLoA7ThwO/sY6XbpST/9
eXmfztQv2TTiM1lQWKf81jR4nPF9O3YWuN00tNvtyqIZXNlCrngWV/KtdplT
oWXPfXyGugbtMvpu55VWlkYlUckV/9D43R5Rm/Y7cvICwnT2iJFu55p4OjMq
K6puKNOzH+/j6STi/e4qiZQ3cQZ53TRkvKFqe/wzy56DKrmi+bNZLbN84Fin
WeF207jebudEyrwRyrxhytQHVQLd2y5kcuXaQ1l3DTpJXYZ2Fn23VyVnW2PH
twP5vlaTkRe3y93r0wVbnh286bH+jpbz89fovCfGuJ03eor+myk9dU6nmOCn
FSqRWFNAHpfU2H+U4ZoFP/ymEgqvz5Kc1vj+GOq+hdvZR+12lTBOmfUmsboy
61Vl6uPK/I9USt1BjQhV9eLpq2Juou1DewprbtdGLpYWhcaGrtxxaPA06spl
3O2ChUv138A2L31s/nzOtbc3MdXIEQZIC189iyIjmzT+qcsWbrcJtNrtUhU/
mOidq9nO1e5S8c62N0t8VkPfWRepW9E+wrLb1XBKZUV82oWfNvz9xEDq4mXW
7aK/tuu/dfy5v+iXFC5by/GaZSHhXENjwyt9jZFbS2tfIJQFhXF8AdwOjES7
v12l4pRXhpL/jZnRPaD48dGnqbvR1sOs25uKK1IOnzo989ftLw2j7lv23S7e
6ab/HjbPmNdGyR2uTYPHtUh+5V+kQW6M3ERb96pvZRIsXdM89RvqsoXbbQKd
ayBV0nzj5xVJFMv2pv17oBd1Q9pumHK7lC/MOx928ZeNrn0/pe5Y23I70a/+
+8n/+sc2Cmu31Y1rt5syix0FbjeN9q5vN56SKuHE3yKpS9JGw5TbKxMzIza4
uo+a7SDdL2Z0u3DlBv33U/DLKupitIPA7abRdberCUuuff2LAOqqtLkw5XYN
kiZ+7tmQCz9tcOn9CXXZ2oTbm2fM1X8bxXsPURejHQRuNw1zuZ3Acap9vvkP
Dj9FXZg2FDbdrk1jQWnyAe9T0352kMa8aW5vfGeoitM9USWPTexwRt7YqYYK
9OrfNOIz6naF220RM7pdTbNQ/uNWjBhsJ24X1jZkeQeen796z+sfUbcuy25v
U0Eqmbyx9weG5ur+XsuVkO0XaJ45X7zTjbpd4XZbxOxuV3OllD9y4WXq5mQ/
DLpdIZUVh8VfXr3r8NAvqZvWhtwu/HOz/pspXLG+zcKN741o7Duc//WPpAxv
4oyWH98ddr1ArwHqAhKv04rsK+QF+bHhzUHUNQu32xAWcruagOjKlz89R92f
LIcptxdfjvOe8uPW5xzxdtSuu73x7SEqgVBnXmVRaZs3KOncbco1NJImurbb
JcdPaddjzB2s9hq43TRMdrtKyVfmj1OJMwwXUyi4Lcdz7xnqTd2ibIYptxME
VXUZnv7nvlu5q+co6pq1LbeTiLa76L+lwlUb2yzcNGyiSiYjBbjGpsaBo9uo
beOOaysQGOzIz8iG203DNLerJHmcKLXlJtb6AypRaofl63nSOevjMWIw+27X
0DKwTHpu7PYjnp/M2/y0M3Xl2oTbG14dqCwp05md4wvaHBCMN3oy+a0iJV3F
cS1dLnoFxLvcOF6zsrBYHh1PXbBwu81hmtu5iqUcP6LF7U2nlAUTjJwrLa9p
0HfB1HXKVJh1uzbCmvqLP/+F62SMCW/ClyqZXKcGRWaOfm+58I+N6kEJBEvX
CBb/rl+V1PtMyx2sbzhLff07OCdr14HbTaNDt6uUQpVKqZKVqLjr49dxjZ5c
k1+L23lnudIFN5SX5LbOJWhv7ALvkLJnx2PEYNbdThqTlUmZ0VsOHh/33d9P
vk9dubbi9hZXL1zWxpP1IuOIpW8o+erAtl9r0mtA268dLHC7aXTodmXG88rC
zzheAFe2UDNRJcnhavco057gGk9w9Qc001ucX/kHV72pZaBgcbt7RCpT/nkw
805njBjMnNuby6pSj/r5zV6645Xh1DVro25v0fvPK1UKhU49xFFNzmOpq9Lm
ArebRodu56r/ammfl/3AVa1T8YPVE1UtrbrVysweXJ2rSpR4baK8Wlk0Xdlw
vGWs4MIpKk5iuObKOvEXKx19xGCm3F4UGntq2s/bnv+AumBt3e0NrWP5cjW1
OlVxTc2CJX9Qt6VtBW43DcNuV3FCrmqDst5dmfqosmojVzpXpWxW/4qr2arM
6cdV/61xOFf2Y2tHzaNc2WKu6Yz+Az7aXoHM+j4zHXfEYKbcrkYpV5RFJ4ev
23d0xKxNjw+gLlsbdTtJY+8PJB7eKqVSp0JFZo5g4TJH7maB261Ax+32+gPK
oi+5ptPK9GeVdW4trXd5DflfmfWWMu1xZearxOQqcRrXeJJrOKZM76as3sxV
ruTKf1VxIiPXQaVSHTlf9JhDjhjMoNu1ETc25/gFBS5av+/tj6lb1+bcrk7T
kPGSQ8e5et0/NI4vkJ0PEq75u3nmfN6oyY19hzf07E9dpAwGbjcNY66TUclK
SYuda/Bs8XnJt8rUJ1p6XXSSN1qZ/baybn9L214QZcKaCMWKpXvS7hjgWIMV
MO52Qn1uUcLeE95TfsR1Ml1K9/d4E2cI/9wsOX5KdjFUFh5N/pd4nBSu3sQb
P80BR+6F2y2NkddAkqY113C0Vex6Vr+u91GtXTTGNtfbpLhSOGFJBHXlOrjb
xQ1N2b6XAn74c++b46jL1k7cjsDt1sX469tViiZl+nOG3N7yEG1TWuzX6pdX
q0TJ6tehiTWvfe4QIwYz5faK+LTwtXuPDJtJXbBwOwK3d5H23K6SlSqLpnNV
a1W8cypZOZnC1bkYFntLir682vopoOJfbnnuavFXquZLhldAJUpQCeNUnEyZ
P1bF89dM5zjV3lP5Dwyz8xGDmXK7XCQuuBgZvGzL/gFTqDsWbkfg9q7QpttV
ikZV8wWOH9ZyWXuDJ1e7k6verMwd1LHb055pUXrNVq7BneOd4/ihKn6I4ef0
tYxLk/WGMu3p1sdwb1GpbriogCeQ/bAl6V/v2e1gBUy5XRt+RXWax5kzXy/f
2X0kdd/C7Y4cuN00EsNz9Sdy+v3q6d2U6c907HaSzB66U7LfVql07+O4YXEN
x5V5Y6+leBand9NTyqXUr5//Zna3r+0vP49Zr7OxjLhdg4rjqlKyL/y0AedS
Ebjdhkg+Hak/8Z92e3hru/2ESe32o/+024O70m5XNvPLl61LeuCVpHtesMsc
6z50SS8n51XnNTd6seN2mVBUcDEyaOlmh+qiOT93gc4eAZRRZGOPmECbbr9q
hv72UK5mW1f620lzse6wZ9rzfajr18JuHzzVycmp11b+PxtO1+3qVnrM1sMn
Pv5+81MONIzMdbd/N1dnjwDKSNKwR0ygPbfrY83rZASRcdkDxlIXrzXc3mN8
vtdUp157WHB78eU4x3zW0g1un79GZ48A6mCPmICRbm+9vt3dCte3y0rLC2cs
oK5cq2XX091Ik8Q9rVHzDlDvk6m/UpTo4unz+eKt3YZSN631c/Sj93T2CKBL
xfkF2CMmYIzbb7wvdY6F7kvlROLKtduSH+lJ3bfWzNFXRuRX3NCPSN3tGpQy
eUlEYtife4586EBXvJ+d87POHgF0UfArsEdMoEO3c/UHbxxPZr1KXt3WeDLe
N4wnU/FbpxrwDV5n0rv3p25a6+dYj/E6bwU7blejHjrswuL1DnudDAC2iGG3
3zgO5KbWcSCvdXq1jgP5XtfHgRQlpeV8MJG6Y+F2HRryS5LcTvp88ZOjDfkL
twP7oON2+/Xx29e2NX67m8njt8ura4u/+4W6XeF2DeLG5twzwQ416iPcDuyV
Dt1u0nOX/jb83CVOKqvesi/lidepq5V6mHJ7dWqO+iF6jnn1I9wO7IkO3W72
56U2nbuY8fpg6lJlJEy5XYNMIMq/EBH022a3fpOoyxZuB8AEjL++XRuuYinH
D29xe5OPsuBjI+cSZ+ZeGTuNuk6ZCptu10b9BNXTX/2Gc6kA2BCmuV0lyeNE
qS1urz+gEqV2WF7R0Fi6eGXSfS9RdylrYdzt/Mra9OPnzs75fWePUdStC7cD
YDymuf2qehyY/HEqcUYHxRSK2n1HUp9+i7pF2QyDbpeLJYVB0SG/bzvw/lTq
poXbATANk91uDM3BEVl9hlP3J8thyu1FobFeny7Y8swg6oKF2wHoIhZyu7Sg
OH/SN9TNyX6YcjtBVNeY5R1I/Lbn9Y+oaxZuB8BkzO52ZbOg/PcNyQ92p65N
mwhrbtemLrsgYe/xk5N/3PrcYOrKhdsB6BRmdLuK4+qPeKW98C51YdpQWHa7
BkF13cWf/8J1MgDYEOZyuyA6PnvgR9RVaXNh1u2cQlEemxqxwdV91OxNjw+g
rly4HYBO0XW3y8oqi776gbokbTSsub2xoDT5gPep6b9se8GxhpGB24GdoeN2
lSTP+Hk5saRyncONymvHbi++HOc3a+mOl4dTFyzcDkAX0Xa7SsUprwxtb6wA
HRq9z6b3GEDdjbYeptyuhlMqKxIyov4+cGzsnL+fdLiBZeB2YB9o3K7ipCp+
cOsDqbdztbtUvLPtzSJKTs8d9hl1K9pHGHS7NtJmQd75sIs/b3R9dyJ168Lt
ABiP2u0qYZwy682WsXkzX1WmPaHM/0ilFOgXltfUlcz9NeneF6kr0W7CuNtV
KlVNxpW4ne6eE+fjOhkAbAitdrtImTdCeWV46yOtdR+rwclk1VtdUp7EqLwO
4XZBdV2G5/lz36/a/eoY6rKF2wEwAe3+dmXxDK5sIVc8iyv5VrsM73xQxhtD
qGvQLqPvdgAA6DrX2+0qJdfgfu21OIN8GScvxNl5eeOmUxegHQduBwBYgvau
b1c08Up/WpV0/8vU7WffgdsBAJZA3+0qpbLW9Wjqs+9Q954jBG4HAFgCHbfz
QyOz+o6kbjzHCdwOALAEGrdLC0sKpnxL3XWOFrgdAGAJiNuVfEH5ir+SH8Ko
vHA7AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAMAGUBYWizdtRWiF
q6qmfQgA88ErvZqwF6EWYS3tI4AhZMGhDY93Q2hFkZRC+xAA5qMk4ureNxFq
qUmnfQQwBNwOtwOzAbfD7cwAt8PtwGzA7XA7M8DtcDswG3A73M4McDvcDswG
3A63MwPcDrcDswG3w+3MALfD7cBswO1wOzPA7Q7ldolEUlxcbM0lmp28vDyl
Ukl7LdoBbofbmQFudyi3L168+M4779y9e7dKpbLmcs0CUfqGDRvuuOOOdevW
0V6XdoDb4XZmgNsdx+3R0dG33HKLUyujR49WKBRWW3TXkUql/fv3V6/87bff
npWVRXuN2gJuh9uZAW53ELdLJJKXXnrJ6R/2799PJiYkJLDfgCfN9aSkJPLi
r7/+0qz/O++8w2LPDNwOtzMD3O4gbl+8eLFGjMOHDydT0tLSbrvttkGDBhUV
FVlnHUwgOzu7d+/ed955J1lJjuP69Omj2QoWe2bgdridGeB2R3C7dm/M3Xff
XVZWplAo3njjDfUUYs7U1FQrrEZnCQsLu+OOO9QrST6DyFcMonrNFBZ7ZuB2
uJ0ZZBGRgq/nIrSiSLX40dhmb8yqVas0U/r370+0WV5ezs4lNLm5uXV1dXK5
vFevXpr13LlzJ/nVhg0bNFNIk56tnhm4HW5nBnlKGu1VcGgUObmWXkR7vTHq
Kf/5z3/y8vI4juvXrx9pwO/atYtuDzxx9fr160njfMyYMeTHpKSkW2+9VfP9
oqioiBRgt2cGbofbmQFup4ul3W64N4awdetWUmzz5s2aKfPmzbPoKhlm8uTJ
mjU5cuQImbJs2TLNlDZ7Zqqqqiiu8A3A7XA7M8DtdLGo243sjSHtdtJ6V08h
7XnSqrfcKnVIeHj4zTffrF6Ze+65p7KyUqdnhnyzuPpPz8yzzz4bGhpKfmTl
ah+4HW5nBridLhZ1u/G9MZpiq1evttz6GMmCBQs069Nmz0xhYaFSqfzrr7+E
QiH57dmzZ3fs2EF7rVuB2+F2ZoDb6WI5t5vQG0N+y8INTWKxuFu3bgZ6Zh55
5BHykUQmNjU1TZs2zYmda2bgdridGeB2uljI7bbYG6NNmz0zL7zwgk7PzM6d
OzVTmLhmBm6H25kBbqeLhdxu/d4YTioT5xULEjOaIxLJ/+L8Ek4m70qF+j0z
np6emm8it956a1RUlM41M+vXr+/KEs0A3A63MwPcThdLuD0mJsY6vTHy+qaa
Q6euzPw1scfIqLtej7rztRvyf28k9Rqd9/WyWo8zCh6/s5WLRCJNz8xNN90U
Gxt79Z+eGfIj+d/Z2Zm5u5ngdridGeB2upjd7dbpjWkOT8j+dEH0/97S9Xk7
ib737dzPF5P2fKeWou6Z0VwMQ75oEOHfe++9Oj0zDN3NBLfD7cwAt9PF7G43
oTfmjz/+ML5+YUp2+gdfGql0/WSN+058pRN3v548eVJzMcz06dPJi8TERMN3
M9HsmYHb4XZmgNvpYl63d9gbs2XLlqum9sZwMnnRkk1t9L10MtH3vFW2dq+q
9UIXY2hublZfDONk9N1M1Hpm4Ha4nRngdrqY1+0HDhzQKM7Nze2q+XpjpBU1
qf0mddHq2skY/pW8rtGYRcfGxupcMyOTyXr27NlezwxpzPv4+HTlbTQduB1u
Zwa4nS5m75NRD4o7bNiwq+brjRFl5Se8+KEZxa5O0utjpaWVxqyA/jUz7fXM
dH3IYoWksba2tpEv6cQs/MbaiopavgJuh9vZoSk6/kpuKUIrwrTOnV40BmI5
Pp9vrt4YSWFZ/LODzS52dRJfGS6rqu1wHbSvmTHQM9PY2Nj1wQcS118b36DX
AveO1+wq//SqsddWYlXM1dKoqycmINRSY/6/JtvlkuvJbk+MRWgl0feihfZs
XV0dacB3sTdG0dic2HOUhcSuTkqfiUqhuMM10bmbqaqqSrtnhri9ubnZHG/b
VUljRXZ22umts0m162M66DWSZB8gxcYuORCTll3cKIFbKNOQT3sNGAJut1e3
X/1nvFxiQpN7Y7I/XWBRsauT9/UyY1amzZ6Zu+++2zLjEvO39nLqtTXRcKF8
96mkvX69eQ+30wVu1wJut2O3q2loaCD/b9mypbO9MdUHfawgdnXqTwd1uD5t
9sw0Nhp1QrbzSNzHduz2tD3OTr32XL8vyzbdTj4Zc3MbAgIKvL1zAgML8/Mt
9JZaHrhdC7jd7t1+tfWPd9OmTepLaIzsjeFV1EU95Ww1tye8PFwp7vj0paZn
5s4773Rzc7Pk0L78A85Ozvbu9uzs+q++8r/vPvK5v047Dz+8/fvvLxQV8Wiv
YCeB27WA2x3B7WrUl9AY2RtzZv5Gq4ldnYotB41Zsfnz51vl+d38PXbtdj5f
Onv2+VtuWX/XXX/PnHluz56kjRtj8/MbVq2K2LcvefLk0//978bbbtuwcGGQ
REJ/aFBjgdu1gNsdx+1XW3vgjbklv6m6Yc2zH1nZ7fHdhhozvJhcLrfKkzjs
2e0FBU3du7v++99/rVkTGRNTwXGqwsImMj0rq478T17LZMrY2IqlSy8Tvb/z
zqHKSgHtVTYOuF0LuN2h3G4kfy/avePBQVZ2O0m97yXam67Bbt1eXS184omd
Tz+9i7TJpVIF8TyZGBzcMhBEYGCh5nVuboNSyc2ZE/jII9tfemkfjyelu9pG
AbdrAbfD7fr07rPw8H39rO/2nMkLaW+6Bv6eXnbodqLrvn2P3HXX36SJXlsr
IlP8/fOJ4Q8dSietdxeXFLFYfvx4FjF5UFCL4ckHQUxMOWnhjxjhSXvdjQBu
1wJuh9t1aK5uuOXNn6i4Peahd1UMPPhJTcz6Xr3Wxxguk7ZnrG253dU1xclp
3Zo1ka2D8NQnJ1cTmW/ZEk/a6pcvly5fHubjk5uaWrNhQwz5FIiJqSgsbCLm
X7o0jMx16pRln9tuBuB2LeB2uF0Hnx0+Tm/9svGhIeYy9ol7+i55bOSMpyd8
8uxn5P+fHh/1/+2dB3gU1RqG13YtF0VA77VcO4o1KjZQVEBFEAERRKWjFCnS
eyfU0EMvUkMJhF4SEgglCaSRQEJIIL33umnbc//N4DrsbpLNsJtzNnzv8z95
Zs+eOeef2ew7Z8/OzO5qXOWBQx7My2Xj4dv0J0FWe9959dHBstv8z7fblUrN
M8+sbtfONSOjODlZf6mXh0fciROxq1dfPn8+adSo0wMGnBw40N3TM37Xroh9
+yJ9fVOoTkJCIY3wP/po+xtvbOblN8erAm4XAbfD7UZMG7CY3D7s+a53qHSf
Bu9Pevb7598ZQa2ZxsvvDJ/9dAfTtTK3HGC9A26hTnSTyWRHE6v+HJHv4yCT
OYeI9M+3248ejabh94gRXhWVX6du3nw1Ojpvw4bQNWsud+ly4Pff3UeO1Ov9
++/dFi685OoaGR6eTeP81FT9BvbseZTW9fNLYb0R1QK3i4Db4XYjenw7hdz7
3puD70TsLk1aVWV1cXzRbID3ox+IV0yYsoz1DjCg9phC8h7tHWvmvjL5iQGO
bWSy3rtvG9jz7fbhwz2feWZNTk5pRER2WZn+dKP160OpcNKkc7Nn+86c6ePi
cm3atAszZ/rOmeM7ZMipnTv1n6GKi5VUPzOzuEGDZVSH9UZUC9wuAm6H2434
stU4su69H0za3+hTaWJf/t+vH2w+oUaxC/H6W0PFeo/+fSrrHSCiPKTyElgn
kws1850qbyfmbfQE327//PNdTZtuKC1VKZUaD4+45cuDJkw4u2iR/9ix3osX
B3z22c4GDZZ+9dWeJUsCxo49Q0N3etbZOfjMmQS1WpuVVfL882u7dj3IeiOq
BW4XAbfD7UZ82GKsYN32r/aRMmJv3OqR98dbKHYhvnm1r2H1qB6jWO8AA3L9
3WLaOIVnm7lgtjw/doP+WefbxvR8u71Zs02//XZCLlekpBRdv55z6VLq8eMx
s2b5ksN///2k4aLUP//0Gj/+7Ny5fidPxvr7p0ZG5qSmymktEvunn7qw3ohq
gdtFwO2M3X5wK33ub+PoUYvbhduYDz4ZIyj3ng8mLa/lN6onG370lMPIWold
CMNXt1E/j2a9A24h3OPRW3C3OsrMy1Qe0sXoXpH24PaiIr3bIyKyb3e7u8Ht
I0d6jh/vbXA7HQXsxu1Znry9mxgCtzN2+/5NvfUf7qs/H6NO+aJyTkaIR98f
u6fxZxaK3fOxD99+a4gEsQszM7fmZAZMYb0DbqE/d73N3+c3loebe5nUHqMr
b9tugG+3m87J0Pi8ck7mjJNTAHlbmJNZvDhg7FjvhQv9yfkrV9rVnEzaSd7e
TQyB2xm7/cjpWLfet50jzZpuld+livQ+ztmCa1S3Nfn8WUkjdkPsrjyI8PNd
qo+jg4PTP9cumX2ZKs9vd/5n4M6322v8LnXnzvDp0y/Qwpw5voMHe4i/S83I
sI/vUnl7NzEEbmcbp2b+SAON3eEc3VV1UuU5kOK454NJnZr22lfFV6s7m7Rq
92pfqnMnYqcYXnnWZcZmTq5/vO261DT9AN3My2Rf16WKz4GMjy/YtOnK3+dA
hlhwDuQx/s+BTNs/gLd3E0PgdrYRtNc1No2v2UFX5wNV6fe1t4d1faXnwBe6
jX6uy4AXu3/XtPdT7466Q6UbQvjqVh7EyQ/43nY/GbU8zezLZF9ut/japTg7
vXZJnXSJt3cTQ+B2tsHheTL5Gbn3fTDRWsa2PJq/MSjgPy24uedA/bxXmNl7
Djg7B3t7J/r4JM+a5Wv2ngPTpl3APQfsDrgdbjflo5Zjmbidr3uF1Ue3C/cK
e+wx8/cKI/Ob3issMBD3CrNL4Ha43ZTl4zfUvdvbvNY/95AX6003UD/dXoF7
/N41wO13ldst/22OR5vX7vqjO4/f3u5nd7/NEeIsOk+ywj7cXiH6bY4FCy7h
tznqK3D73eN24Tf1HB0dLak88pd5dez2Q1PXW5JYXf2mXr6zQ82/hR3rNlgm
G51oeGwnbq+o9jf1Nm7Eb+rVB+D2u8HtNNBdvnx5rX4LOzclq3Hzupt1f7H5
aHVpWY1ZiX8Le+vWrbYYwMvTony8vbc5dpHp7/FYw9l06tjd+mtlBjt5ePuE
J8rtyO0C+C3segzcXu/dnpeXR39Xrlwp+5vmzZurLTgdZc2kjXXmdpclrjXm
U1pa2rRpU8NW7Nq1iwrz8618MnOIk4PQ/ugNPhacTqcO2T3l1gqOAXbndgE6
RN68mXfqVNzBgzc8PeNjY+32/HC4XQTcXo/drtFoFi9e3KhRo5iYGK1W+/nn
nxvEaOHMzLdf1sWse/f2Ft37cdSoUYb8O3fuTCUhISENGzZcv369FQfwanW5
XC6v5TSEfh393IV9ur3+ALeLgNvrq9tzcnI++eQTwYRkdXI7Gf6RRx4RSiyc
mclJynyh+Ribir3Zh2PkeUU1ZmKYjSEaN26ckZGhVCrfeecdoaRt27ZFRTU3
YnPgdrbA7SIK/IOjbyYjWEVJuPVtQMN1/chTrW7evLlhoLty5coKSTMzNwKu
P/G+rSbe/9d8THJUYo05mJ2NmT59uqGE3E5D9/z8fLYXTvpf3thyWRMEq7ge
dZjhq88bqqucXOJ9l6K+YeVr/YSTYdq3b0/LNDKn8blgPxqxm87MzJ0715I2
w86FPmWD71Vf/mB0TIhFm292Nub+++8XSho0aJCQkEBHNNrwOjmFpkpO+y9r
vOhBBKu4HLGX1UvPIXA7W6zr9u3btwsnwxBbtmyhErK3wYqSZ2aI+PDYtz+2
5uTMpy3HZiVkWNJ1YGBgNbMxxPr1+pMnnZycDKo/fJjN+A1uh9v5AW5ni3Xd
HhAQcN999wmKa9iwYUpKirVmZghFWfmgbo733vH9Hv/VfMLkfou0Ft83pqio
qG/fvtXPxtCnFcNBjRYiIyMl78M7AW6H2/kBbmeL1edkJk6caPCedWdmBPxP
XDL86J6EaNNqXMSFq5Z35+bmVlJSQgsnTpzo379/RdWzMYbNoQF8LfeZ1YDb
4XZ+gNvZYnW3l5eXv/766wbRVTUzo1AomjRpUtuZGQOeOz2/+XLCAxbfLvLB
5hM6tZ108fCFWvUinBvz8ssvnz9/nh5S2vQRo5rZGIIkb8lNFWwE3A638wPc
zharu72i2pkZgyeJvXv3SpiZEZOdmLF68qZu3+ivKjW9LTCVPP/BmO7fTl03
Y2t+Rm5tGxefG3PPPfcEBgYK5TSAf+aZZ8zOxjz44IOsZmME4Ha4nR/gdrbY
wu0VVczMjBo1SpjfcHd3j4+Pp2Fwq1atpM3MmKIsKYv0C6eR+WkXL78jvpGX
rinK7uhXEkzPjbl27ZpwYCooKBg0aBBXszECcDvczg9wO1ts5HajmRkaogvl
ZMV+/frJ7uycmTpAfKVSo0aNDOfG0AB+xIgRwhGKWLt2LSezMQJwO9zOD3A7
W2zk9orbZ2aee+45tVpNMm/Xrp1BhndyzoxNMbpSycXFpeL2c2N69eolXKNk
OFQxn40RgNvhdn6A29liO7dX3D4z07Nnz4oqzpmx4syMVbDwSqUlS5YYTqGh
ATzrrPXA7XA7P8DtbLGp2y05Z4YGwFzNzFQ1G2PIed26dVRt8eLFMtFXw5z8
RjPcDrfzA9zOFpu6vULS1Ux//vmnTVOqHvp8YTQbM2PGDEOJ2XNjyP8MExYD
t8Pt/AC3s8XWbicmTJhgcGM1VzO1atWqQYMGNCpmOwbWaDROTk6k7mpmY1q0
aGHYIubnxoiB2+F2flD6XSwe8ieCVajDrtn6JbZwZiY1NTUxseZbMtYNN2/e
zMnJqWY2RoCHc2PEwO1wOz8oz57P+19TBKtQh9biAnzJVD8zQ+PhsLCwOkij
tvj4+BjmXji8UskUuB1u5we4/W5we0XVMzNsb4pbI8Iti/mfjRGA2+F2foDb
7xK3m52ZCQ4O5uQMk2ogpYeGhlbwPRsjALfD7fwAt98lbq+4fWamU6dOPFym
ZDkKhcJw70oOZ2ME4Ha4nR/g9rvH7RWVMzM8nAwjDcMpNBzOxgjA7XA7P8Dt
d5Xby8vL+TkZRhoxMTEczsYIwO1wOz/A7XeV24FNgdvhdn6A2+F2YC3gdrid
H+B2uB1YC7gdbucHuB1uB9YCbofb+QFuh9uBtYDb4XZ+gNvhdmAt4Ha4nR/g
drgdWAu4HW4HAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAABA
EZeYvmgVglWo0jONXpE4n4uX/hiLYBWpYdeYvBMBsC6FXudDG72GYBUll8OM
XpHgtZuZZ3U3R/j+w0zeiQBYF7idbcDtvAXcDuoHcDvbgNt5C7gd1A/gdrYB
t/MWcDuoH8DtbANu5y3gdmkkFKU6X9mGYBVH404bvSJwO9uA23kLuF0a51MC
XtnWGsEqBnhNNHpF4Ha2AbfzFnC7NOB2uB0hDridt4DbpQG3w+0IccDtvAXc
Lg24HW5HiANu5y3gdmnA7XA7QhxwO28Bt0sDbofbEeKA23kLuF0acDvcjhAH
3M5bwO3SgNvhdoQ44HbeAm6XBtwOtyPEAbfzFnC7NOB2uB0hDridt4DbpQG3
w+0IccDtvAXcLg24HW5HiANu5y3gdmnA7XA7QhxwO28Bt0sDbofbEeKA23kL
uF0acDvcjhAH3M5bwO3SgNvhdoQ44HbeAm6XBtwOtyPEAbfzFnC7NOB2uB0h
Dridt4DbpQG3w+0IccDtvAXcLg3B7e/u+q6F649G8eGezvTU2y7tm25r02z7
V6YVKF7b3paepTpUk+qbVqCWhfaFpkwrfLy3Kz31xs5vqAtaMNsLPWto5P3d
35tWoEJDhTd2fGO2EXqKuhCaok5NKwhbYUi4+h1CG262F2Er3rFsh8DtHAbc
zlvA7dIQ3N731Din4I3iWBG6bW7gmgVB65Ze3jzUe3o/z/FGFZZc3rz2qss4
nwXDzs5YdWX7RN9Fk3ydjOqsvrJjzIV5tLD9+sHxPgt/ODbEqMLykC0rQrdO
u7jUMWDVBJ+FAzwnGFWgoF6okeFnZ+6IPDgvcM1Q7xlGFZxDt0/1W7I8dAv1
MuTMtH6njFNdevkvamS8zwKKeQFrqCnHgNVGddZU9jLt4rLt1w/M9l/Zy2OM
8Q4J2To/aO3cwNULg9ZRC/2r2iEX5lOG68J2TfFbTJtsVGfVlR1jL8xbFvIX
pUoLLV27we28BdzOW8Dt0hDcTq4j4RyLO9Pp6EDy0oxLyw/FeC6+vPFgzKk1
V3eSdcf5zD8ad5qWSeO9PEYfjvUik68M3XYg2oOsvjbMhSq7RbuTvuiprw72
ppqDTk85EX+WDg27o466RB5eGLyepEer7Lt5gp6iLtaH7d574xiteCjm1ILA
dTMvrSBFU7/UyP7ok5QJ5fPnudl0gNgReYh8uzPy0OZrrhvCdy+5vOlIZS/U
I7mUloVGqBfKasyFudT71gg36mLwmamUIW0axeEYzyl+S5yCN5DAD8Z4UC/0
t92hvpTkwNOT3RPOU26rr+6kXmhzZvmvpIPF8Tjvrsf/oE2eE+BMu0LYIStD
t9Im0z6hHUK5UeVf3EdS2nTgoBb23zxJOWwM30MbTltBvdBTXx/sQynRced4
vDcl73rjBKU6P3DtF24/m7q9ODAk9pfBCFZRFnnT6BUJ2uoS2aIDglWEHz1Z
VzqsVwhu73Js8G9eE7scHUQW3Xvj+Ihzs8iNpJ2pF5ecSwkg79GQu8PhAaTK
bdfdNl1zpb9kKqrTan+PUwkXfFODSWi/uo8adnYm2ZjKhVVInqQ1ErJf2mVy
ZvvD/UmD3U8MJ//T8JjGwKRNGr5SRx4J588m+9OzHY/8To2Q9qkXMn9Pj1Gk
0BZ7fyRPXkwPoUF+j5MjhnnP+OnEcGqBtNnfcwIdO+gh2fti2mWyfZejg6nr
vp7jaPVNlccC+lxAWqbeqT5t7++nJ3c7MZR6IWP/FbGPDg1Un6z78d6uLlGH
KVUqpB1CLdPx5WTCOWpn5Pk5tBV0CKCh+NnkS56JvrRK+0P9//CeLuwQSuY3
r0m0jZ/t6+4ef44aoU7pIEi9UB3aIXQE+fH4UErv20P9NlXuEEr73V3fmbod
8EZQUBDrFO5qIiIiWKdgl1xICSQ/02iWJGaIuYFrDsV6iktI3eKHR+POzA5w
FpcsDdlMDhSXTL59FYqpF5eKH9Igeet1t9tW8VtstAqNtMUPybrrw3ZV06Zp
qruijtAIXFwy038Fmfb2VG/r90CMx4KgdeISekiF1fQiNCt+SJ1S19X0QtH2
YK+R5+aw/hcANQC3swVul0Z4ThTrFO5qwuxq/+t0OtYpMABuZwvcLg24nS12
5HatVvvbwYXWaq2f23x7OVLA7WyB26UBt7PFjty+8LyLbOrnOSUFVmltS/CJ
a5lxFaLPAkkFmc4X3azSuHWpe7er1Ko67tFCmCQGt0vDft2uSk6mvzqtlv6q
09J0Gg3rjKRgL26/mh7zrxltHpr5lVeM1USXWZyn0Wrmnd2hVKvi89JeWtJj
2NFl1mrcitS929dcOngs0q+OO7UEJonB7dKwX7fnzZ+fOWRI0kcfZQ4cmNK2
rU6tZp2RFOzC7eReB+d+90378lxcqFUaDM+I9Y69/MWmET1d5ww9spRKOu+c
TB8KBh1yskr71qXu3d5y/R/f7+DxBComicHt0rA7t9NAXRkdrVMqaaHU25vE
XrRjhzori0o0ubkUrBOsHXbh9smnNpB453hvq6rCjeykWjUYnZO8P/xsXmkR
Lbvf8NfpdKduBlAXwnz+hfgrd5avlaljt2u12gdntG04p31ddmoJrBKD26Vh
X24v8/dP7dCh9MKF0tOn6SFZPVomS/rwQ1rWlpcXbt2aPWFCrqOjHc3P8O/2
S0nXaMROAzaN1vxepbd8k7kdhcnz2nLyxqV/zWhTrlJ4xQSR2wccWEDLD8/8
6jxPeq9jt5+PC6VdQXE9K6Eu+60RVonB7dKwI7cXHz4c89BDpRcvpv3wg2Bv
sduJvHnzyvz8klu2TOvUyV6maDh3e4myrOnSX/4965uY3JSq6pCN6f3+5Lzv
a/uW90sMf2B6a1pXrig1uL2ovIQWHpn1dWDy9TvN3krUsdt7us4RFDrefW1d
9lsjrBKD26VhL25XxsbGPPJI5sCBJe7u9FcoNHK7Iiws9bvvykNDo++9N2fq
VHbJ1gLO3f7HkaX0Xl4fYHxDj+NRF49G+grL5H+qQ4PttKIcy1umymqN+j/z
O9G6BWVyg9vzy+S0QB/8qVmrbcadUZdu1+l0jzt2EBT6vFO3Ouu3RhgmBrdL
w17cntGvX/R996mSk2mhcPNmodDI7TSYj33sMU1hYVrXrjTC1+TUQjWs4Nnt
7jf86Y387bZx4kIS8qjjzsJ7fJrXJnrL06ibll9d9qvlLS84t1OYvX9jRW9a
N/9vt/c/sCCvtIgWqNy623In2M7tLqGeTeZ1bDC7XUPHDo3ndnxyfid6KOxb
IZ6Y9z0VNp77XUPH9lTtvws601HVRslwmxjcLg27cLtOq41t2DC5VStaTmja
tOTUKaHcyO23nvXwkLu6UnnR9u1s0q0N3LqdHPvsoq6NHDsYjcYHH15Mb+23
V/ZttrwnLUw6tV6YRXlrZR8LW3b03kb1p3vpD9DvOPejZerL4Pbc0kJacHDu
Z/UtkoxNx+2hqTeEDy81xnNO3aJzqpwZq8eJwe3SsAu3q1NTydXZY8aQ5KMf
eKDkxAmhXL5nD5Unt2xpqBn/0ksF69er4uOpPGfyZEb51gJu3f7z3ln0tt19
1cuo/PONw6k8Li/NJ+EqLfR0nVNYXizY3sKW+7nNp/pTPDfSskOl28nnRm5/
d1V/K2/PHWDrORmlWtV739zq/Tni2Apt5aUcdQknicHt0rALt6uSk8nVeQsX
ahUKWihYtUooLz5yhB6mfP218FCnVJL585cu1RYX690+kcczhI0Iyzg5xUHW
xtGjnHUmhEpz6wto17Az9Lbttnu6aZ1PNwylp5ILMiW7fUvwCao/+dSGCnNu
zykpYOx2dZTRK1I38+3uNy49PPNrU3k+PqeDX2J4HSTAbWIRYcf5eY/YEXbh
dp1GE/Pww7kzZtBy3JNPpnXqJJSXnjlDDk/r0kV4WOLlRQ/l+/aps7JooXDj
RmYZW0xYytHeMpnMwVnOOhNiwIEFGq0mQ57beO539Ob9eN3gH1ymdN89vcee
mYZoMrejZLdHZMYvOr+L2uTa7eXhRq9InX2XOuzIMlOFOlZ9WUGdwTaxiJBD
/LxH7Ai7cDuR1rlz+k8/0UJGnz7R99+vSkioqDzdnRye0bPnrTo//EBPaXJz
yy5ciL73XlViIsOELSQsJyrWrbfMYQOT/1v60F1Qdqvntf6H6A1bqizvtHNS
jVOsEtzufsP/vmlfGlrg1+0VFUavSJ25/b8LOpvu6mbLe9ZN79wmFhERwfA9
Yr/Yi9vLfHxin3hCp1KV+fnpx+pdu1ZUnvRIy5mDBlX8PYZP/1V/tkbO1Knp
PXowztgyzuzrR0OS3eH5THqnodfUynnv8/FXhDcsDdpdrnhuD3HfdvnkluAT
FH8FHzeNEmVZbd3eccdEqjb37HbhnmPcuj3NY7TRK1I3bqcPNQZtPr2w6xPz
vjc8TK/NyaX1L7GzG/owfI/YL/bidiJr+HC5qystZPTtSxrPX7FCFRen/451
9GhVcnLcU0/FPv64KimJ/J/UvLk6PZ11vhYRmnAhNo3NPOIyX1d6e764+Cfy
eXZJwdMLfxAG5GRaS+J41EWx299Y0Zu0TE3tuuKpNHe3wNeX97p32hdhGbEL
zu2k+r8fXETSeG3Zr7Tslxi+KeiY2O00JqRnr6bHLPXda7Y126GWpxm9InXj
9t8OLhSESbu0XKWQK0q/2z5BKJnhtbkOEuA2sbDAs6zeI3aNHbldp9HkL19O
6taWlia3bBl9zz25M2bo52R69Up45ZWYhx4q8dKf1FF85IjiOi+XNNYIw/Nk
YnNTH575VY3TL9WHwe2G+HDtQLPdvbC4e42tGdxuiBbrh9TxbjGlbtz+uGOH
+6e3dgk9JS50vuhGB8T/LfqxDhKoCuaJ4TwZadiR2wWEm/pqi4vTu3UjsQtB
g/ayCxfEFewFtudAdqn8WvOB6a3/NaONtOjrNq+ovOShmV/pr3OZ077J3I5V
3af3vdUDnnPqVn2MO7kmv0z+vFO3l5b0eHXZr/RZQDhVki114PaA5OtPL/gh
LjfN9KnwjNgn53dKzM+wdQ5m4SExuF0a9ud2na48IKBg3brMwYNprK53+333
JbdokTd/fvHBg5rCQtYJ1g7mbqfRV34ZvqSqjjpw+/WshGrOEleolNE5ybbO
wSw8JAa3S8Pu3C6gyctTJSZqy8pyJk9WJSer09NVKSl2dPtHA0zcToMxjVZz
Pv4KDby/3DSiovKnN6YzndTlGfymHlvgdmnYqdvrDUzcvvuq10OVM+0NZrcL
TL6eV1r03/n6k9zWmdwTDFTA7ayB26UBt7OF1ZxMSmHWhfgrwq9jEOPd1764
+KfUwmwmyXAO3M4WuF0acDtbOLmfjE6ny5Db2U9W1RlwO1vgdmkEnNxx6r3n
IhfPyvT2METE3MlpJw+LS66M/0P8MMPz2LVZ48QlN5Y5Jh/YVc0qFGFT/hQ/
jFm3NGHnRnHJ1YlDjVa5MnGY+GH89vWxG1fetsrkEcarTLit36R9O26smC8u
CZ8xJvOM++2pDhE/TD3mdn3BNHEJPaTCala51ax4h6yYn+S6o/od4tXi1UN9
vmL9LwBqAG5nC9wuDf+dy/WXc3bvXuDsbBQ5EycmvPpqaocO8U2bJrzzjmkF
ioS336Y6ad9/n9C0ac6kSaYV0rp1S3zzzfSff6YKKa1bm1bIc3KKf+GF5C++
SHz//fiXXzbbS9Knn8Y//zw1kvjWW5kDB5pWyBw8WOiFqiW3aGG2EWo88b33
klu3pu7yFi40rZDy7beUpD7V119P69rVzA6ZMoUqpH7zDW0ybbjZXhIdHOJf
eSW1S5eE117LHj/etEJ6jx63dsgrr8Q8/LDHRy+x/hcANQC3swVul4bg9sR3
3838/fesP/+M+fe/M3r3Tnz7bZJb5m+/yffvz5k2LaNfv9Rvv83644/MQYOS
Pvkk6f336VhAAiTNFv71V3qfPrnz5uVMnkyGp1UyevWKffxxqhn7xBNUIWvY
sMLt2wtWrSLRkVT1JcOHxz39dGrHjsmtWqW2a0erFLm6Zo8dm/nHH+m//EJ9
UUlq+/Zk0Yw+feL+9z9qKm/JElqrYPXq/CVLkj//nFKldkiMWUOHxr/0UkbP
nrRK8aFD1EvmgAFJrVrRKpRtwhtv6Lvo2DHp449plaJdu2gtOmBlDhmS/tNP
tEp6t26UCR0XKNWsESNoE/IWLdIfbubNS3znHf0OGTkypkGD9F9/pYdpP/wg
7JDsiRMz+vdP/e47aocaTP70U9p71CAJX3/c2biRNoHayZk6lbrW75DevW/t
kCefpIe0FmWi3yFjxsS/+KKp2319fd8E7AgPN763oaenJ+uk7mpwbJWG4HYS
OMlcr/H+/Qs3bKBhbdmlSzQALty0qWjPnsKtWzOHDs2ZPp2sVeLpSTKkZ3Nn
zyYZZgwYQOqWHzxI1qVqad27F23bRjajZRJvma9v0ocfFh87Vnz8eNHu3Xpp
d+6cNWoUPZs7a5bcza30/PmUtm1z584l1xW5uNBT1DU1UubvT5nQ6tnjxpHS
0378sWj79pKTJ+WurvkrV5JISZ7UC/mcFFrm50f2lh84UHziROGWLZnDhtHY
mJKkEjoiUKpUSK2RqCln+Z49JNWCNWuoF0qMDh9lPj50WKG/dMyilChVWpE+
g5DMsydPpt6pcv6yZfod0rJlwdq1RTt30ibTKrkzZ6b37Vt6+jR5m56lTHJn
zMjo25dSLT58OH/FClqgXmgf6nfI5s10+NCnSjvkxAn9Dtm1iz5lmLrd3d1d
BtgRGBiIV4QrTF8RYAmC2/WXdj77bMyDD5JpKWicmdCsWfzLL8c9+WT6zz8n
t2kjXCJEA+/EN9+kCjQkjn3sMRoV62+f/tVX5FKqScsJr7wS26iR0Ij+VzNa
tIht3DjhtdfSe/VKdHCgktgmTahxGutSBRoz6xt8662YRx+lIwuNcqPvv19o
hEbjVCGpefPoBx7QN3XvvWRvaoRkSBUosZiHHhJ6odE7DZsp+fjnnqMKVI0q
xDzySNxTT9HqVEG/Ff/5DxmV8qcu6DBB3Qm9UB2qkPzZZ/qt+PJL+sxC43Nq
hBLW75BnntH30qaNfoc0akSF9FGCRvi0sbTJ+h1y77008KbPL1RB2Ar6TKHf
6tat6QMIdXprhzRseGuH3HMPpUd7QD/zQzvk3XepAtzOG3A7b8Dt0jC4HcEk
4HbegNt5A26XBtwOtwMxcDtvwO3SgNvhdiAGbucNuF0acDvcDsTA7bwBt0sD
bofbgRi4nTfgdmnA7XA7EAO38wbcLg24HW4HYuB23oDbpQG3w+1ADNzOG3C7
NOB2uB2Igdt5A26XBtwOtwMxcDtvwO3SgNvhdiAGbucNuF0acDvcDsTA7bwB
t0sDbofbgRi4nTfgdmnA7XA7EAO38wbcLg24HW4HYuB23oDbpQG3w+1ADNzO
G3C7NOB2uB2Igdt5A26XBtwOtwMxcDtvwO3SgNvhdiAGbucNuB3UD2AStsDt
vAG3g/oBTMIWuJ034HZQP4BJ2AK38wbcDuoHMAlb4HbegNtB/QAmYQvczhtw
O6gfwCRsgdt5A24HAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAA3AmKuMT0RasQrEKVnsn6XwAAUA8p9Dof2ug1BKsouRzG+l8AAFAPgdvh
dgBA/QNuh9sBAPUPuB1uBwDUP+B2uB0AUP+A2+F2AED9A26H2wEA9Q+4HW4H
ANQ/4Ha43R6JCzp/cUQ/BKu4tHym0StyMyxoz6hBtovNSybNDt2FqCp2x541
ekXgdrjdHgnatvKyTIZgFcFftjR6Rc7s2WzTd8rqlu/JtnZAVBUdPGcYvSJw
O9uA26UBt8PtCLid54DbpQG3w+0IuJ3ngNulAbfD7Qi4neeA26UBt8PtCLid
54DbpQG3w+0IuJ3ngNulAbfD7Qi4neeA26UBt8PtCLid54DbpQG3w+0IuJ3n
gNulAbfD7Qi4neeA26UBt8PtCLid54DbpQG3w+0IuJ3ngNulAbfD7Qi4neeA
26UBt8PtCLid54DbpQG3w+0IuJ3ngNulAbfD7Qi4neeA26UBt8PtCLid5yi8
6JudnZ0vLxe/KOryfNNCICbo4F+RH3+MYBXBA34xekXgdt7cXuwfHNmiA4JV
XBrXTFaJw+jd2X+/KCFODqaFQExQQhDrFO5qTPc/3M6b2wFbyvPToqLCjzoP
JpM7BeRXUwjE2LvbtUV+rFO4I+B23gJu5xW5s4PMwTnEgkKgx77crtPp/llW
5WkLzqjjJ2jzvbTFV6uqxjmm+9/fzcWmbt/X5stOXrMQVcXk4K1M/hNATZTv
7mKqcbOFQI8duZ2MrUnfIC5RpyzVaYqpUKdM/6eaMl2Te7TOs5OI6f639Td3
sT8NZLKlANwZ8m1tZG1Mxu3mCoEee3G7tuC0OnWZJuMvdcJUnerWlyearF2a
jI2qG30M1TSZ2zVpq8j26pRFOq2CUbK1AG4HwDLkG8y53Vwh0GMvbhcG7dqS
cG2+xz+FmpLKv6X/lGjLNRmbaNyuK0+o+yQlALcDYBlwe+2wF7cT6qS52kJf
Tfa+auro1AXqFCdNzkGtPKDOErsT4HYALANurx2cu51czbwFmwK3A2AZ8g0O
5txuphDo4dztqpjBOp3mTlpQJ87UKVKtlY/VgdsBsJAAJwcHJ+PP42YLQQXH
bichqyK768piVTHDzJ7ErtOUqWNHKSM6Ka931soDzVRQy1U3+2vlAeqk2Zps
V9unLAW4HQALCd+mP99RbkEhqODY7YQm95gma6c6ZZHZZ1XRA7UFZyr0ki9W
hrfVKTNN62hLItRpzur4CbZN9A6A2wGwEHWim0wmO5qorrEQVPDtdhqu67Qq
bcE5s88qgl5UJ87SqbI12XvI7ZqsXWZaKA7VqQu1RRepHdvmKhW4HQCLUXtM
cZDJRnvHZtdUCLh2e/Vo8k5qiy8rgpupE2dqS6O0JddYZyQFuB2AWlAeUnmH
MKf8GgvveuzX7QLKa99qy6JZZyEduB0Ai5Hv7i2TtXEKzy6vqRDw63ZtwVmd
MqPGaspr7XVlMTVW02TttkZS1icoZj99oGzj6GH4v4TbGaOOMnpFACeUR22j
0bl3ds2FoIJLt+u0Sk36uspbB6yr0ck1ul1bGkVNqVOWaNLWaEsirJqpFQi6
sae3/ibU/3zRD7czpjzc6BUBnBCuv05pg/F5MuYKQQWXbie0ZTe1+Z4kdp0q
r/qaipDmNfpfk7lV/5VrxhbrJWg1aP/HuvWWOWyA2/nB6BUBnODj6ODgZHyZ
ktlCUMGt2+XB+vt9JUyp3u2a3GOKoJeVYV9Wf1Nfdcpibf4pdfJCa6dpBU5u
/5UGibvD//kWCG5nS5rHaKNXBPABrkutHXy63eBqI2mr48aS9vXlWoUmc5vi
YgN12hqFf2NVVA9deaK+XJ2vTpyhLQk3bY3Pm7r7R5yMTbttZhduZ4tanmb0
igA+wP1kagefbjeg0xTfWtBp1PHjlNe+Vfg3IqUr/P6l8JUpw1tTuSZ7j8L3
HnqouNRQ4XufKuoX5eVmurJY00Y4BOfJAGAZcHvt4NztymvfqKJ+Vd3srwh6
UXHxYU1xiKbARxX5o/LKxzQ+12nL1anLdeoCbb6nKqKD8upnmvS12vIk5bX2
JH/V9U6qmMHKKx/y/Lt7cDsAlgG31w7O3a4ti1aGt1UE/Jckr5UHaHIPK69+
qi30FZ7VZGyksboqoqNwt3adMlOd5qwM+4IG6uq4sYqglxTBTTXp61huQE3A
7QBYBtxeOzh3uxhStyLoBYWvTJ00VyjRFl9WRf2sTp6v02n1FcrjFYHP6Cuk
LGaaaS2A2wGwDLi9dtiT27UqTdEldepKdcJU1c2+ymvtlFc/U4Y2V175RBne
WhX5ozp2pDp5kSZ7j06VwzpZS4HbAbCMfGcH05+9NlsI9NiF27WlkfpvUS/+
W/+Fqf4700eVl99QhrdVXe+siuqhn36/1l555UNFwNO3vlT1lSlD3qKjAOvE
a8Z0/19auc6mbt/2VLM3QdUMGTKEyX8CqAp5WpSPt/c2xy4ymcw5JL+aQiDG
LtxO43AanKsTJmvyjusUydXV1JRoi/w1aav1w/jUFXWWoWRM9/+ZBUtt6vbV
DZ6Vgarp0KEDk/8EUBUhTg7CSzN6g095tYVAjF24vR4Dt/MG3M4banW5XC5X
W1AIxHhd9/p4wccIVjFwh/HsN9zOFrgd1A/cr7nLBssQrKKDs7FJ4Ha2mLrd
19eX9ZcAdzXh4eEVoPbA7XA7EGPqdnd3d9ZJ3dUEBpr5NWRQI3A73A7EwO28
AbdLA26H24EYuJ034HZpwO1wOxADt/MG3C4NuB1uB2Lgdt6A26UBt8PtQAzc
zhtwuzTgdrgdiIHbeQNulwbcDrcDMXA7b8Dt0oDb4XYgBm7nDbhdGnA73A7E
wO28AbdLA26H24EYuJ034HZpwO1wOxADt/MG3C4NuB1uB2Lgdt6A26UBt8Pt
QAzczhtwuzTgdrgdiIHbeQNulwbcDrcDMXA7b8DtAABbALezBW4HANgCuJ0t
cDsAwBbA7WyB2wEAtgBuZwvcDgCwBXA7W+B2AIAtgNvZArcDAGwB3M4WuB0A
YAvgdrbA7QAAWwC3swVuBwDYAridLXA7AMAWwO1sgdsBAADYO/8HuYK17w==

            "], {{0, 1869}, {500, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{500, 1869},
          PlotRange->{{0, 500}, {0, 1869}}]], "ExerciseOutput",
         ImageSize->{504, 1869},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "c9a58ce2-46fb-4865-9112-88e295f3e13e"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJzsnQdcE+cbx6OttbtV++/Qtra1bkURJGwICXvJUkT2EFBAQFAQVBQnuEXF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              "], {{0, 1869}, {500, 0}}, {0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {500, 1869}, 
            PlotRange -> {{0, 500}, {0, 1869}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"ce458a41-4368-4fde-8e8c-db5ebde48176"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["22.12"], StandardForm],
   ImageSizeCache->{146., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"f12a1acd-6140-4a73-8331-8a8b960c1daf"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"29720589-595b-496a-831e-a07e457256be"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"de12e976-5ebf-4b0e-91e9-11c7b6eeebb6"],

Cell["\<\
Make raster images of the letters of the alphabet at size 20, then make a \
graph of the 2 nearest neighbors of each one.\
\>", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "22.13", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 22}, {"ExerciseNumber", 13}, {
   "WebOnly", 0}},ExpressionUUID->"382ab264-ee7c-4061-815a-1abc826099ca"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"cb02ca02-c9a4-4a3f-bdc8-05aaaaed41ea"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztnflXWmm67733/nJ/vP/C/Qdc63R1n64+51b1Yp17zumpyqpKuqqrm+5z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            "], {{0, 330}, {360, 0}}, {0, 
            255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{360, 330},
          PlotRange->{{0, 360}, {0, 330}}]], "ExerciseOutput",
         ImageSize->{240, 226},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "479b5420-5fab-4f2d-bf97-aa6b1032236f"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztnflXWmm67733/nJ/vP/C/Qdc63R1n64+51b1Yp17zumpyqpKuqqrm+5z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              "], {{0, 330}, {360, 0}}, {0, 
              255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {360, 330}, 
            PlotRange -> {{0, 360}, {0, 330}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"dac54562-cd42-41e4-bc58-01875dc4566e"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["22.13"], StandardForm],
   ImageSizeCache->{146., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"2ac90c9e-efc6-4d7a-a4d2-58ffc7de2b1b"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"d413052c-2016-46de-a378-1226e652b748"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"38157209-f401-4727-9fff-09f57de22551"],

Cell[TextData[{
 "Generate a table of the results of using ",
 StyleBox["TextRecognize",
  FontFamily->"Source Sans Pro"],
 " on \[OpenCurlyDoubleQuote]hello\[CloseCurlyDoubleQuote] rasterized at size \
50 and then blurred by between 1 and 10."
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "22.14", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 22}, {"ExerciseNumber", 14}, {
   "WebOnly", 0}},ExpressionUUID->"f9dc6978-a6d7-497f-bbb9-76ea308fd9e5"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"b3201f7a-ba82-48a5-ba5f-e9d2b5a73c8d"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztmiFv3DAUx72ODE7aJ9gXCB41HDqp01hIqzXVSHdqJ02hZoHHwoKCgg4F
hRwKCQkJCQgJuUkBHjAwuD07SS+9phff0pL1/aWefE/2+z1H9/T8nH68/HHu
nBFC7t7Bx/nFL3p7e+F+eQ9fvt7cfb++ufr2+ebn1fXV7afLt2D8AH9nbwhR
4x0KhUKhUCgU6oFEmWVVI02m8irPiu2pqxCEIEPQPJ//oCb2HMta5r9TixCW
NiZrMg/memoqP2FVp1OWIOh1gmb5NKCGDqU2S7ddcvHchzbZ8db1n2xByCoz
wuU+JZbPYSROWNXplCUIep2gWT6nJYs4sAmxvLT9zrMVQITGURjlesj5YQWS
Qoi9bRgkPQxSCi6OhYAgBE2BZvk0UxEsiLVq/YpcZcF90rlhxIAKspZZVy94
4i+1iSxY1BwNsk7DRTvVsqNs+9TGEYSg46BZPs20R+x2ZWh3GSEyW7t3o02u
WXSVgXnjQRSWnxRVHju9cTRIngewnLpBlqe+A6c5EpVjOYsgBE2BZvk0U6F/
+YBoygQSm7anI52VLGnzS0YQnBMJbXTCAixSxdYVkbEgRQTPhbC6g1QuPC+9
o8cbRxCCjoFm+jSTLCNw560LT5eWpDsbtbi2RPR77FN1r0XAx4Pk6pzFNj2k
YWpyV3EONo4gBB0DzfRpKuGrekJkUzB1D5UM4mn6eHQYXBmX6+pg/WGQOQxF
qLvuvo3ZskEPPrZxBCHoCdBMn2YShTpfBamqLaUqQrov4I/jAbtYq2aIhpuy
aeo08iM9QeUsYZVU3bUqYkEGwyaFRpvYq7iqyzVTTYyfNztZuBahLN4f4BCE
oAnQPJ8mlq4j9lvL4I5I4QbxLNp6t5N14ND7Gugllc4d9TjsqFSnNV0mN7oy
ZaF7P5Oti13vtm1D+iREEIImQPN9Tlge3hHp9wXe5OFK8gY0TCUw8O7SWMBQ
Ppw6uE7W5cYyPb8hCEHzfZpYCsgC2lna0xF1/Opl/lOjjlVSh/nzvvtDEIKe
9GlgEWmgagrdXzGJNPQchxXP8DpuRJLXZf0yrhGEoDGfBhYRe8slC8oZF0wo
FAqF+p/0F3DjvC8=
            "], {{0, 19}, {258, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{258, 19},
          PlotRange->{{0, 258}, {0, 19}}]], "ExerciseOutput",
         ImageSize->{262, 19},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "80038792-616f-49b0-9b33-7acae5b7b01f"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztmiFv3DAUx72ODE7aJ9gXCB41HDqp01hIqzXVSHdqJ02hZoHHwoKCgg4F
hRwKCQkJCQgJuUkBHjAwuD07SS+9phff0pL1/aWefE/2+z1H9/T8nH68/HHu
nBFC7t7Bx/nFL3p7e+F+eQ9fvt7cfb++ufr2+ebn1fXV7afLt2D8AH9nbwhR
4x0KhUKhUCgU6oFEmWVVI02m8irPiu2pqxCEIEPQPJ//oCb2HMta5r9TixCW
NiZrMg/memoqP2FVp1OWIOh1gmb5NKCGDqU2S7ddcvHchzbZ8db1n2xByCoz
wuU+JZbPYSROWNXplCUIep2gWT6nJYs4sAmxvLT9zrMVQITGURjlesj5YQWS
Qoi9bRgkPQxSCi6OhYAgBE2BZvk0UxEsiLVq/YpcZcF90rlhxIAKspZZVy94
4i+1iSxY1BwNsk7DRTvVsqNs+9TGEYSg46BZPs20R+x2ZWh3GSEyW7t3o02u
WXSVgXnjQRSWnxRVHju9cTRIngewnLpBlqe+A6c5EpVjOYsgBE2BZvk0U6F/
+YBoygQSm7anI52VLGnzS0YQnBMJbXTCAixSxdYVkbEgRQTPhbC6g1QuPC+9
o8cbRxCCjoFm+jSTLCNw560LT5eWpDsbtbi2RPR77FN1r0XAx4Pk6pzFNj2k
YWpyV3EONo4gBB0DzfRpKuGrekJkUzB1D5UM4mn6eHQYXBmX6+pg/WGQOQxF
qLvuvo3ZskEPPrZxBCHoCdBMn2YShTpfBamqLaUqQrov4I/jAbtYq2aIhpuy
aeo08iM9QeUsYZVU3bUqYkEGwyaFRpvYq7iqyzVTTYyfNztZuBahLN4f4BCE
oAnQPJ8mlq4j9lvL4I5I4QbxLNp6t5N14ND7Gugllc4d9TjsqFSnNV0mN7oy
ZaF7P5Oti13vtm1D+iREEIImQPN9Tlge3hHp9wXe5OFK8gY0TCUw8O7SWMBQ
Ppw6uE7W5cYyPb8hCEHzfZpYCsgC2lna0xF1/Opl/lOjjlVSh/nzvvtDEIKe
9GlgEWmgagrdXzGJNPQchxXP8DpuRJLXZf0yrhGEoDGfBhYRe8slC8oZF0wo
FAqF+p/0F3DjvC8=
              "], {{0, 19}, {258, 0}}, {0, 255}, 
              ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {258, 19}, 
            PlotRange -> {{0, 258}, {0, 19}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"9016cc58-9e16-48e3-8831-b532ad89b547"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["22.14"], StandardForm],
   ImageSizeCache->{146., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"fe456a21-2636-4ef7-a0ac-aa2ae02c71e1"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"f316bdc8-a711-4fcb-a6d8-dfdeda738e21"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"d81f8583-61ea-4807-8b56-516e85409e4b"],

Cell["\<\
Make a dendrogram for images of the first 10 letters of the alphabet.\
\>", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "22.15", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 22}, {"ExerciseNumber", 15}, {
   "WebOnly", 0}},ExpressionUUID->"c2461380-f09a-49c7-b45d-ff2cb9524d50"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"0fe77d9a-b83d-4ba9-a9a8-63b440022eba"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJzt3M9PHOcdx/FtK0W9tf9CD75y7nWPlSqtlKg3pCpRQ9pLipJKFVduK/Wy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            "], {{0, 271}, {360, 0}}, {0,
             255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{360, 271},
          PlotRange->{{0, 360}, {0, 271}}]], "ExerciseOutput",
         ImageSize->{364, 271},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "6fb64e0c-3bf9-425d-bbea-62695b3eae4b"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJzt3M9PHOcdx/FtK0W9tf9CD75y7nWPlSqtlKg3pCpRQ9pLipJKFVduK/Wy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              "], {{0, 271}, {360, 0}}, {
              0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {360, 271}, 
            PlotRange -> {{0, 360}, {0, 271}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"44d12ba6-dbd4-4a22-b783-1d9ecb1d2cb4"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["22.15"], StandardForm],
   ImageSizeCache->{146., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"15c1d2a3-298f-4de5-b6e4-38ef4557dd51"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"207f67bf-e042-4a05-81a9-fc6e6c3f2e85"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"06ec0a46-e17e-4ddc-bc99-67dc4bf1fb2b"],

Cell["\<\
Make a feature space plot for the uppercase letters of the alphabet.\
\>", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "22.16", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 22}, {"ExerciseNumber", 16}, {
   "WebOnly", 0}},ExpressionUUID->"08675f8e-c120-4483-bbe9-401a05ac9b40"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"0493db1c-1034-4655-82dd-ec0ca6ce8468"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJzt3S+T48p6x3ElIYF5C3kDxqGCQaq6qTCTe+se34ScuM5NVcrUTFBMTEhI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            "], {{0, 360}, {360, 0}}, {0, 
            255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{360, 360},
          PlotRange->{{0, 360}, {0, 360}}]], "ExerciseOutput",
         ImageSize->{364, 360},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "955450cc-232b-4dda-b82f-d9f6c6255f76"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJzt3S+T48p6x3ElIYF5C3kDxqGCQaq6qTCTe+se34ScuM5NVcrUTFBMTEhI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              "], {{0, 360}, {360, 0}}, {0, 
              255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {360, 360}, 
            PlotRange -> {{0, 360}, {0, 360}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"41da65a5-2086-4b75-b78b-6bf2c76a7527"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["22.16"], StandardForm],
   ImageSizeCache->{146., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"a96a3bd4-8a7a-4e66-9552-f4b16e3d1a40"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"7e74f3df-89d9-41c4-8562-8d1f86bc6a4c"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"028cdb3c-54c1-4d7b-ab69-d6419c76d4f3"],

Cell["\<\
Make a table of image identifications for a picture of the Eiffel Tower, \
blurred by an amount from 1 to 5.\
\>", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+22.1", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 22}, {"ExerciseNumber", 1}, {
   "WebOnly", 1}},ExpressionUUID->"73a46b76-e5ff-4e80-b2e4-064497e37730"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"ea7d6159-8250-436a-8529-08b060985987"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztXN9La8kdz25f+pi2jy0t/QP0zW2fBB/yUAK9kNLQhxXZpcm6D7lN7q30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            "], {{0, 27}, {334, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{334, 27},
          PlotRange->{{0, 334}, {0, 27}}]], "ExerciseOutput",
         ImageSize->{338, 27},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "a7823e48-a7b4-4d31-8760-04e5529f70b4"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztXN9La8kdz25f+pi2jy0t/QP0zW2fBB/yUAK9kNLQhxXZpcm6D7lN7q30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              "], {{0, 27}, {334, 0}}, {0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {334, 27}, 
            PlotRange -> {{0, 334}, {0, 27}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"ccc6560f-7635-4869-8f21-0e12c8f16858"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["x22.1"], StandardForm],
   ImageSizeCache->{145., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"575b1e58-b6c8-4341-8ff4-e14a012bdab5"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"1ba8ffff-2f47-49d6-a722-5ce2e391bf04"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"9fc6c7f2-78a4-4906-938a-31c3512f54cd"],

Cell["\<\
Classify the sentiment of the Wikipedia article on \
\[OpenCurlyDoubleQuote]happiness\[CloseCurlyDoubleQuote].\
\>", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+22.2", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 22}, {"ExerciseNumber", 2}, {
   "WebOnly", 1}},ExpressionUUID->"b2c6597e-74e0-402c-9220-b1975af4d64c"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"9894275c-42a8-47e6-b05d-b168983c5a53"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztVK+vnEAQ3rSmskn/gvoGXbuyiuQ1dZj30uOl5kruNWmwOOS6dSgU6hTq
DAqzBrNmxRoqEIg1KxB0Zjmu3K+8nG1uEggwzLfffN/sfnz6+RC+IYS8vIPb
w+Nvutk8xl/fw8u39cuP5/Xq+5f1r9XzavP56S18/ADXJ7jwebzHPcbR6EbI
zj3aOud82xxStq14VtlbEQdr7HBThUg9QtLe0eEUZpNs9R7BiHRO3RBGMEKo
MDeUNLCwx12FyXzkQMJi6t00gMaWYBZafA1wkBw5nP23LLXHUi05wGOYRMCC
uzaOOPRNGniOosdK5YBk5NFcTnlbRDTMpSxiMocX5pCTeRSybR5jbSr+yF2+
h4HXCeeMQ8BLHkB9CiNiDxwGhdA0qZWu3SqFtiA6WMfE5BXWekyYVm45dpEW
u0qoAfGduCHbVbU2XUpJxEupZJH4B8tOOFAuh7aAonjXOVWRg7MY5sSOA6B2
MCWUi9GecqBMzF74zSy14xDrY7s6raoiRcEbc4GDw6kS0Cuuaw69QUqX/xSe
IrjOwTR8OZMLfFy9ziIHQMMQ9ZnKL3IAG4JpMYqpHnXwqpMdMnnRTPCGeccc
7AUOVmZoU9W6N+lf4eBNHMaxLZMDB8BFSn4qdNe1Tc5zhUvoyCmiOr1Fc4k/
cXDG5UJp3Q17fDZzyLH3Svddw0JvoQOUJ+5IQA4+P5xRfRbMHCCnymAx8VWL
BWIvLI5cFtNZQ5XQvWNycPg0m71o2YwSxLhVpnlQheumUOPrMZge4mjnW/x0
fh4N+N+V09JVnKbg462n6z3++/gLOec2kA==
            "], {{0, 19}, {44, 0}}, {0, 
            255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{44, 19},
          PlotRange->{{0, 44}, {0, 19}}]], "ExerciseOutput",
         ImageSize->{48, 19},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "c6c631d5-8224-4f0e-ac40-eab7b5f7486f"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztVK+vnEAQ3rSmskn/gvoGXbuyiuQ1dZj30uOl5kruNWmwOOS6dSgU6hTq
DAqzBrNmxRoqEIg1KxB0Zjmu3K+8nG1uEggwzLfffN/sfnz6+RC+IYS8vIPb
w+Nvutk8xl/fw8u39cuP5/Xq+5f1r9XzavP56S18/ADXJ7jwebzHPcbR6EbI
zj3aOud82xxStq14VtlbEQdr7HBThUg9QtLe0eEUZpNs9R7BiHRO3RBGMEKo
MDeUNLCwx12FyXzkQMJi6t00gMaWYBZafA1wkBw5nP23LLXHUi05wGOYRMCC
uzaOOPRNGniOosdK5YBk5NFcTnlbRDTMpSxiMocX5pCTeRSybR5jbSr+yF2+
h4HXCeeMQ8BLHkB9CiNiDxwGhdA0qZWu3SqFtiA6WMfE5BXWekyYVm45dpEW
u0qoAfGduCHbVbU2XUpJxEupZJH4B8tOOFAuh7aAonjXOVWRg7MY5sSOA6B2
MCWUi9GecqBMzF74zSy14xDrY7s6raoiRcEbc4GDw6kS0Cuuaw69QUqX/xSe
IrjOwTR8OZMLfFy9ziIHQMMQ9ZnKL3IAG4JpMYqpHnXwqpMdMnnRTPCGeccc
7AUOVmZoU9W6N+lf4eBNHMaxLZMDB8BFSn4qdNe1Tc5zhUvoyCmiOr1Fc4k/
cXDG5UJp3Q17fDZzyLH3Svddw0JvoQOUJ+5IQA4+P5xRfRbMHCCnymAx8VWL
BWIvLI5cFtNZQ5XQvWNycPg0m71o2YwSxLhVpnlQheumUOPrMZge4mjnW/x0
fh4N+N+V09JVnKbg462n6z3++/gLOec2kA==
              "], {{0, 19}, {44, 0}}, {0,
               255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {44, 19}, 
            PlotRange -> {{0, 44}, {0, 19}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"dc75c35b-c6a1-4673-9292-f702d35a3f0f"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["x22.2"], StandardForm],
   ImageSizeCache->{145., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"f7ca98c6-c125-4a17-90e8-a023de841e2c"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"db4cd4b7-4789-4589-af1a-56c3e8077bc0"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"4ff4d96d-2a24-45f5-8cc8-374d1df700c0"],

Cell[TextData[{
 "Of colors in the list ",
 Cell[BoxData[
  RowBox[{
   StyleBox["Table",
    FontFamily->"Source Sans Pro"], "[", 
   RowBox[{
    RowBox[{
     StyleBox["Hue",
      FontFamily->"Source Sans Pro"], "[", "h", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"h", ",", "0", ",", "1", ",", ".05"}], "}"}]}], "]"}]], 
  "InlineCode",ExpressionUUID->"39a93e6b-3235-4c99-bfab-c3504501fa94"],
 ", find which are the 3 nearest to ",
 StyleBox["Pink",
  FontFamily->"Source Sans Pro"],
 "."
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+22.3", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 22}, {"ExerciseNumber", 3}, {
   "WebOnly", 1}},ExpressionUUID->"715dd43f-d66f-4d29-9bb3-4f39f9183954"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"a91ec503-1ce6-49b3-94d0-de32c6bdf290"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztlqFuwzAQhk8bGZy0J9gLmJSUGg5UkzaNhbRaXY10UTtpKg0zDMtQUEiL
ioLKQ0pCTEJDBgJCDAK8s9tK29qmzsgCejonZyt/8im58+V28PrALgBgeoWH
h/47nUz6s8drnDyNpy+j8fD5bvw2HA0n3cElLt7g6OLQsTrb2dpuRcwZIW4q
/xvkh5URo9Txks9qO08DLCjGl3Po1PvB282B1fthVQfqXalKxKEDQHiy5Vz7
AL7UT+wo6B3zGk4FH8e8hlP1jrrh1CbCeyB+YWKZas6ylZxpQIEEpYmzyNkw
t5BTGDbkLLKVC0BNDrSQs8oWWDt8KTiegKwK1U5OzMqAaMSqEB4G3qqdnFKE
CBkmOcbZAqvfOj8rMSNAvVg24txX2XGa2gk2qmb1LlNHZ4pfNuLcVzWvd7N/
cvt9Sb//ndb+u/9WWdY7ctKtapMDlAU2/SiPcXuAKC2+5+fJfnRAdbofySSc
aTB/vRPJJOKMecKiv1dlnuWN/wP+pJIxd10vzMrTl56tqX0BJQx0rQ==
            "], {{0, 
            19}, {56, 0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{56, 19},
          PlotRange->{{0, 56}, {0, 19}}]], "ExerciseOutput",
         ImageSize->{60, 19},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "77730c4b-f9f2-43d3-a30e-545640b6e972"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztlqFuwzAQhk8bGZy0J9gLmJSUGg5UkzaNhbRaXY10UTtpKg0zDMtQUEiL
ioLKQ0pCTEJDBgJCDAK8s9tK29qmzsgCejonZyt/8im58+V28PrALgBgeoWH
h/47nUz6s8drnDyNpy+j8fD5bvw2HA0n3cElLt7g6OLQsTrb2dpuRcwZIW4q
/xvkh5URo9Txks9qO08DLCjGl3Po1PvB282B1fthVQfqXalKxKEDQHiy5Vz7
AL7UT+wo6B3zGk4FH8e8hlP1jrrh1CbCeyB+YWKZas6ylZxpQIEEpYmzyNkw
t5BTGDbkLLKVC0BNDrSQs8oWWDt8KTiegKwK1U5OzMqAaMSqEB4G3qqdnFKE
CBkmOcbZAqvfOj8rMSNAvVg24txX2XGa2gk2qmb1LlNHZ4pfNuLcVzWvd7N/
cvt9Sb//ndb+u/9WWdY7ctKtapMDlAU2/SiPcXuAKC2+5+fJfnRAdbofySSc
aTB/vRPJJOKMecKiv1dlnuWN/wP+pJIxd10vzMrTl56tqX0BJQx0rQ==
              "], {{
              0, 19}, {56, 0}}, {0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {56, 19}, 
            PlotRange -> {{0, 56}, {0, 19}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"4428107d-167f-43ed-9449-730b9c9fa176"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["x22.3"], StandardForm],
   ImageSizeCache->{145., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"368a4e9b-cb5e-4842-9fe4-60110d832b73"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"e8a6faba-fdbd-458c-91a6-fd3dbea1db56"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"9b57dd9a-687c-4a89-bc2e-2e203398bc4f"],

Cell[TextData[{
 "Compute all fractions ",
 Cell[BoxData[
  RowBox[{"i", "/", "j"}]], "InlineCode",ExpressionUUID->
  "38f59556-0419-49c7-b841-8d4991d004b2"],
 " for ",
 Cell[BoxData[
 "i"], "InlineCode",ExpressionUUID->"24fde331-4cc8-4053-8d95-7aa188bc8013"],
 " and ",
 Cell[BoxData[
 "j"], "InlineCode",ExpressionUUID->"84174f76-6862-4eca-ae84-c09c56be271e"],
 " up to 500, and find the 10 fractions closest to pi."
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+22.4", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 22}, {"ExerciseNumber", 4}, {
   "WebOnly", 1}},ExpressionUUID->"3272802d-3c9a-41b3-8e6a-fe3e1c8fbcf0"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"319ea650-5313-43e7-b295-2adc14cbcb71"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztXT2r5MgVbduJQ/8F+wco3lShI8EaZ53s4unFyWwzazDKjDKFSoyChY7k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            "], {{0, 34}, {312, 
            0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{312, 34},
          PlotRange->{{0, 312}, {0, 34}}]], "ExerciseOutput",
         ImageSize->{316, 34},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "4b24603f-be7e-455e-89e6-af2f6c6448e3"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztXT2r5MgVbduJQ/8F+wco3lShI8EaZ53s4unFyWwzazDKjDKFSoyChY7k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              "], {{0, 34}, {312,
               0}}, {0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {312, 34}, 
            PlotRange -> {{0, 312}, {0, 34}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"ac0d37bb-db63-41b2-8e91-a6ffe0e85463"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["x22.4"], StandardForm],
   ImageSizeCache->{145., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"7f9a39ee-e243-40e0-a163-c0d32ec70d0a"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"6df2ea12-a214-4f52-9f7d-e4090bede2a3"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"e6adbfad-9d07-441a-b7de-3433e436771a"],

Cell["\<\
Generate a list of 10 random numbers from 0 to 10, and make a graph of the 3 \
nearest neighbors of each one.\
\>", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+22.5", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 TaggingRules->{"MultipleSolutions" -> "True"},
 CounterAssignments->{{"SectionNumber", 22}, {"ExerciseNumber", 5}, {
   "WebOnly", 1}},ExpressionUUID->"860343bb-19f7-4b7a-9f83-9ecc31334957"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{
    "SAMPLE", " ", "EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"9847e390-5cba-4d76-9343-3c65793f4474"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztnfdXm1eax9ndX/bH/Qf2nN1zdndmz8xyZjInkz4T4sRJZpJhEqdOcIod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            "], {{0, 117}, {360, 0}}, {0, 
            255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{360, 117},
          PlotRange->{{0, 360}, {0, 117}}]], "ExerciseOutput",
         ImageSize->{364, 117},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "533af536-b296-4f48-88a7-2a89f409e165"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztnfdXm1eax9ndX/bH/Qf2nN1zdndmz8xyZjInkz4T4sRJZpJhEqdOcIod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              "], {{0, 117}, {360, 0}}, {0, 
              255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {360, 117}, 
            PlotRange -> {{0, 360}, {0, 117}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"c884e48a-9349-423f-8953-38016bc5456d"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["x22.5"], StandardForm],
   ImageSizeCache->{145., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"af5c5df9-7010-4b3c-bed9-a65c8973f88f"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"2b55e5db-cee2-4f16-9702-769aa968bbcc"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"a19a4c2a-13ed-4d6b-bd97-11cc1d995682"],

Cell["\<\
Find clusters of similar colors in a list of 100 random colors.\
\>", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+22.6", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 TaggingRules->{"MultipleSolutions" -> "True"},
 CounterAssignments->{{"SectionNumber", 22}, {"ExerciseNumber", 6}, {
   "WebOnly", 1}},ExpressionUUID->"51bb6898-761a-4f24-a18f-cfff3a434fc6"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{
    "SAMPLE", " ", "EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"4191781a-c2ef-48f0-85a9-6bb35c096ae6"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJztnXuM1OUZhX9clFqsCkpVChaMd3EKii1ViBmQKqiIXLzAioDugAVxuRiz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            "], {{0, 86}, {480, 
            0}}, {0, 255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{480, 86},
          PlotRange->{{0, 480}, {0, 86}}]], "ExerciseOutput",
         ImageSize->{484, 86},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "68b1d8ab-2274-4b06-bd49-22a82414fe22"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJztnXuM1OUZhX9clFqsCkpVChaMd3EKii1ViBmQKqiIXLzAioDugAVxuRiz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              "], {{0, 86}, {480, 
              0}}, {0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {480, 86}, 
            PlotRange -> {{0, 480}, {0, 86}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"5426a1cc-f56e-425b-8826-3e5aa5158e84"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["x22.6"], StandardForm],
   ImageSizeCache->{145., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"64bfdfe9-5276-4501-97de-6a09548db0de"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"fdb4927f-8978-440c-96d7-58a656981d2e"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"9c469721-8452-45ad-93f9-596f338f9996"],

Cell["\<\
Make a feature space plot for both upper and lowercase letters of the \
alphabet.\
\>", "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+22.7", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->False,
 CounterAssignments->{{"SectionNumber", 22}, {"ExerciseNumber", 7}, {
   "WebOnly", 1}},ExpressionUUID->"11c2f1b6-03e8-459a-a635-962e08c35037"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  ButtonBox[
   StyleBox[
    RowBox[{"EXPECTED", " ", "OUTPUT", " ", "\[RightGuillemet]"}],
    FontFamily->"Source Sans Pro",
    FontSize->12,
    FontColor->GrayLevel[0.6]],
   Appearance->None,
   ButtonFunction:>(SelectionMove[
      ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; FrontEndExecute[
      FrontEndToken[
       ButtonNotebook[], "OpenCloseGroup"]]),
   Evaluator->Automatic,
   Method->"Preemptive"],
  MouseAppearanceTag["LinkHand"]]], "ExerciseExpectedResult",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"a9d18c61-0ed5-4fa5-bc5b-3a64dc5b93c4"],

Cell[BoxData[
 FrameBox[
  TagBox[GridBox[{
     {
      PaneBox[
       InterpretationBox[Cell[BoxData[
         GraphicsBox[
          TagBox[RasterBox[CompressedData["
1:eJzt3a+TrNp2B3CSmMj8CxGx6FhkFFUv9RzmvcrlVcwNdV+qUlgcEodDoVCo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            "], {{0, 293}, {293, 0}}, {0,
             255},
            ColorFunction->RGBColor],
           BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
           Selectable->False],
          DefaultBaseStyle->"ImageGraphics",
          ImageSize->Magnification[1],
          ImageSizeRaw->{293, 293},
          PlotRange->{{0, 293}, {0, 293}}]], "ExerciseOutput",
         ImageSize->{297, 293},
         ImageMargins->{{0, 0}, {0, 0}},
         ImageRegion->{{0, 1}, {0, 1}},
         Magnification->1,ExpressionUUID->
         "eadad38b-2d79-41a3-9ed0-e46e7a998e9d"],
        Apply[TextCell, 
         Cell[
          BoxData[
           GraphicsBox[
            TagBox[
             RasterBox[CompressedData["
1:eJzt3a+TrNp2B3CSmMj8CxGx6FhkFFUv9RzmvcrlVcwNdV+qUlgcEodDoVCo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              "], {{0, 293}, {293, 0}}, {
              0, 255}, ColorFunction -> RGBColor], 
             BoxForm`ImageTag[
             "Byte", ColorSpace -> "RGB", Interleaving -> True], Selectable -> 
             False], DefaultBaseStyle -> "ImageGraphics", ImageSize -> 
            Magnification[1], ImageSizeRaw -> {293, 293}, 
            PlotRange -> {{0, 293}, {0, 293}}]], "ExerciseOutput", 
          Magnification -> 1, CellFrameColor -> GrayLevel[0], Selectable -> 
          False, Copyable -> False, Editable -> False, ShowCellBracket -> 
          False, CellLabel -> "Out[]=", CellFrame -> False]]],
       FrameMargins->{{10, 0}, {10, 12}},
       ImageMargins->0,
       ImageSize->Full], 
      ButtonBox[
       PaneBox[
        StyleBox["\[Times]",
         FontFamily->"MathematicaMono",
         FontSize->18,
         FontWeight->"Bold",
         FontColor->GrayLevel[0.75]],
        Alignment->Right,
        FrameMargins->{{0, 6}, {0, 0}},
        ImageMargins->0],
       Appearance->None,
       ButtonFunction:>(SelectionMove[
          ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
        NotebookFind[
          EvaluationNotebook[], "ExerciseExpectedResult", Previous, CellStyle,
           WrapAround -> False, AutoScroll -> False]; FrontEndExecute[
          FrontEndToken[
           ButtonNotebook[], "OpenCloseGroup"]])]}
    },
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {Top}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  FrameMargins->0,
  FrameStyle->GrayLevel[0.7],
  StripOnInput->False]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameMargins->{{0, 0}, {0, 0}},
 CellFrameColor->GrayLevel[1],
 LineBreakWithin->
  Automatic,ExpressionUUID->"c40b514d-ff82-4be2-9974-3a296f360b79"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  DynamicBox[ToBoxes[
    $CellContext`SolutionResponseText["x22.7"], StandardForm],
   ImageSizeCache->{145., {3., 9.}}], "SolutionResponseText"]], "Subsection",
 Editable->False,
 Selectable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellMargins->{{24, 25}, {3, 0}},
 CellFrameMargins->{{8, 0}, {0, 0}},
 TextAlignment->Right,
 ShowStringCharacters->False,
 FontFamily->"Source Sans Pro",
 FontSize->12,
 FontWeight->"Plain",
 FontSlant->"Plain",
 Background->GrayLevel[
  1],ExpressionUUID->"05e1bee9-5353-432f-81e4-30d12add8089"],

Cell[BoxData[
 ButtonBox[
  PaneBox[
   StyleBox[
    RowBox[{"[", " ", 
     RowBox[{"Click", " ", "to", " ", "enter", " ", "code"}], " ", "]"}],
    Selectable->False,
    StripOnInput->False,
    FontFamily->"Source Sans Pro",
    FontSize->14,
    FontWeight->Plain,
    FontColor->GrayLevel[0.6]],
   ImageSize->Full],
  Appearance->None,
  ButtonFunction:>(SelectionMove[
     InputNotebook[], All, ButtonCell]; NotebookWrite[
     InputNotebook[], 
     Cell[
      BoxData[""], "Input"]]; SelectionMove[
     InputNotebook[], Before, CellContents]; Null),
  Evaluator->Automatic,
  Method->"Preemptive"]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 ShowSyntaxStyles->False,
 ShowStringCharacters->False,
 CellTags->
  "FirstInputCell",ExpressionUUID->"0a1b697e-06bd-4bbb-96cf-4eccc0d13a7c"]
}, Open  ]]
}, Open  ]],

Cell[BoxData[
 PaneBox["\[ThickSpace]",
  ImageSize->Full]], "CodeSectionDividerCloud",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellMargins->{{0, 0}, {0, 35}},
 CellBracketOptions->{
 "OverlapContent"->
  True},ExpressionUUID->"c610d1d6-3335-44c5-b441-21bd7ca7fec8"]
},
WindowSize->{808, 755},
WindowMargins->{{314, Automatic}, {Automatic, 50}},
WindowTitle->"Machine Learning: Elementary Introduction to the Wolfram \
Language",
DockedCells->{
  Cell[
   BoxData[
    DynamicModuleBox[{}, 
     TagBox[
      GridBox[{{
         TagBox[
          ButtonBox[
           PaneBox[
            GraphicsBox[
             TagBox[
              RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UFAEiEGSIPafvQ3/iQM/qxmAiEjFmOohXKwIouDvuQXEGw4xENM6POaT5Hiq
qP97c+uvfvWfDVy/59j/ahX5Pdfx3/sHuNSDFE/UBpI/G3l+TTP9vS7p7+nZ
QBG4FjT1QJOBin+vCAcpaxcHWgEU/HOk7/ciHzzqgSYD2b/XJQO5UPFueezq
J+sDFf/qVQY64PeSgN8b0n5NMfz34DAu9T+beIFm/upV+jXF4PcC9z87K4C6
fk3SwaUeGBq/18QDDQQ5e2f5rw6pP0f7gd4BCmJVD3QG0HygBxHO61UG6sIV
nhAtwNAAOgCEgOEPMxmXevyAEvV4EidaQiU+P0IAAEIjNUM=
               "], {{0, 
               20}, {16, 0}}, {0, 255}, ColorFunction -> RGBColor], 
              BoxForm`ImageTag[
              "Byte", ColorSpace -> ColorProfileData[CompressedData["
1:eJydlndcFNcWx+/MbC+0XZYiZem9twVEehOQXkVh2V1gKQsuuxTFhogKRBQR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                 "], "RGB", "XYZ"], 
               Interleaving -> True], Selectable -> False], DefaultBaseStyle -> 
             "ImageGraphics", ImageSizeRaw -> {16, 20}, 
             PlotRange -> {{0, 16}, {0, 20}}], Alignment -> {Center, Center}, 
            ImageMargins -> {{15, 10}, {4, 0}}], Appearance -> None, 
           ButtonFunction :> NotebookLocate[{
              URL["http://www.wolfram.com/language/elementary-introduction/"],
               None}], Evaluator -> Automatic, Method -> "Preemptive"], 
          MouseAppearanceTag["LinkHand"]], 
         ItemBox[
          TagBox[
           GridBox[{{
              TagBox[
               ButtonBox[
                StyleBox[
                "STEPHEN WOLFRAM Elementary Introduction to the Wolfram \
Language", "DockedCellAuthorName"], Appearance -> None, ButtonFunction :> 
                NotebookLocate[{
                   URL[
                   "http://www.wolfram.com/language/elementary-introduction/"]\
, None}], Evaluator -> Automatic, Method -> "Preemptive"], 
               MouseAppearanceTag["LinkHand"]]}, {
              TagBox[
               ButtonBox[
                TemplateBox[{
                  StyleBox["Exercises ", "DockedCellSectionTitle"], 
                  StyleBox["|", "DockedCellSectionTitleDivider"], 
                  StyleBox[
                  " 22  Machine Learning", "DockedCellSectionTitle"]}, 
                 "RowDefault"], Appearance -> None, ButtonFunction :> 
                NotebookLocate[{
                   URL[
                   "http://www.wolfram.com/language/elementary-introduction/\
22-machine-learning.html"], None}], Evaluator -> Automatic, Method -> 
                "Preemptive"], 
               MouseAppearanceTag["LinkHand"]]}}, DefaultBaseStyle -> 
            "Column", GridBoxAlignment -> {"Columns" -> {{Left}}}, 
            GridBoxSpacings -> {"Columns" -> {{0}}, "Rows" -> {{0}}}], 
           "Column"], Alignment -> Left, ItemSize -> 30]}}, AutoDelete -> 
       False, GridBoxSpacings -> {"Columns" -> {{0}}, "Rows" -> {{0}}}, 
       GridBoxAlignment -> {"Columns" -> {Left}, "Rows" -> {Center}}, 
       GridBoxItemSize -> {
        "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], "Grid"], 
     DynamicModuleValues :> {}, 
     Initialization :> (
      Clear[$CellContext`SolutionResponseText]; \
$CellContext`SolutionResponseText[
         Pattern[ElementaryIntroToWLWeb`Private`a, 
          BlankNullSequence[]]] := " "; 
      Map[($CellContext`SolutionResponseText[#] := " ")& , {
        "+22.1", "22.1", "22.10", "22.11", "22.12", "22.13", "22.14", "22.15",
          "22.16", "+22.2", "22.2", "+22.3", "22.3", "+22.4", "22.4", "+22.5",
          "22.5", "+22.6", "22.6", "+22.7", "22.7", "22.8", "22.9"}]; 
      Clear[$CellContext`SolutionResponseDetails]; \
$CellContext`SolutionResponseDetails[
         Pattern[ElementaryIntroToWLWeb`Private`str, 
          Blank[String]], True] := 
       Style[ElementaryIntroToWLWeb`Private`str, 
         "SolutionTrue"]; $CellContext`SolutionResponseDetails[
         Pattern[ElementaryIntroToWLWeb`Private`str, 
          Blank[String]], False] := 
       Style[ElementaryIntroToWLWeb`Private`str, 
         "SolutionFalse"]; $CellContext`SolutionResponseDetails[
         Pattern[ElementaryIntroToWLWeb`Private`str, 
          Blank[String]]] := 
       ElementaryIntroToWLWeb`Private`str; \
$CellContext`SolutionResponseDetails[
         Missing[
          BlankSequence[]]] := " "; $CellContext`SolutionResponseDetails[
         BlankNullSequence[]] := " "; 
      Clear[$CellContext`GetUserSolutions]; $CellContext`GetUserSolutions[] := 
       Flatten[
         Cases[
          Options[
           EvaluationNotebook[], TaggingRules], ("EIWLExercises" -> 
           Pattern[ElementaryIntroToWLWeb`Private`ex, 
             Blank[]]) :> ElementaryIntroToWLWeb`Private`ex, Infinity]]; 
      Clear[$CellContext`GetUserSolutionsTotal]; \
$CellContext`GetUserSolutionsTotal[] := Length[
         Union[
          Flatten[
           Cases[
            Cases[
             Options[
              EvaluationNotebook[], TaggingRules], ("EIWLExercises" -> 
              Pattern[ElementaryIntroToWLWeb`Private`ex, 
                Blank[]]) :> ElementaryIntroToWLWeb`Private`ex, Infinity], (
             "ExercisesTotal" -> Pattern[ElementaryIntroToWLWeb`Private`t, 
               Blank[]]) :> ElementaryIntroToWLWeb`Private`t, Infinity]]]]; 
      Clear[$CellContext`GetUserSolutionsTried]; \
$CellContext`GetUserSolutionsTried[] := Length[
         Union[
          Flatten[
           Cases[
            Cases[
             Options[
              EvaluationNotebook[], TaggingRules], ("EIWLExercises" -> 
              Pattern[ElementaryIntroToWLWeb`Private`ex, 
                Blank[]]) :> ElementaryIntroToWLWeb`Private`ex, Infinity], (
             "ExercisesTried" -> Pattern[ElementaryIntroToWLWeb`Private`t, 
               Blank[]]) :> ElementaryIntroToWLWeb`Private`t, Infinity]]]]; 
      Clear[$CellContext`GetUserSolutionsCorrect]; \
$CellContext`GetUserSolutionsCorrect[] := Length[
         Union[
          Flatten[
           Cases[
            Cases[
             Options[
              EvaluationNotebook[], TaggingRules], ("EIWLExercises" -> 
              Pattern[ElementaryIntroToWLWeb`Private`ex, 
                Blank[]]) :> ElementaryIntroToWLWeb`Private`ex, Infinity], (
             "ExercisesCorrect" -> Pattern[ElementaryIntroToWLWeb`Private`t, 
               Blank[]]) :> ElementaryIntroToWLWeb`Private`t, 
            Infinity]]]]; $CellContext`EIWLExerciseSolutionsTotal = \
$CellContext`GetUserSolutionsTotal[]; $CellContext`EIWLExerciseSolutionsTried = \
$CellContext`GetUserSolutionsTried[]; \
$CellContext`EIWLExerciseSolutionsCorrect = \
$CellContext`GetUserSolutionsCorrect[]; 
      Clear[$CellContext`SetUserSolutionsTried]; \
$CellContext`SetUserSolutionsTried[
         Pattern[ElementaryIntroToWLWeb`Private`value, 
          Blank[]]] := 
       Module[{ElementaryIntroToWLWeb`Private`data, 
          ElementaryIntroToWLWeb`Private`tr}, 
         ElementaryIntroToWLWeb`Private`data = Flatten[
            Cases[
             Options[
              EvaluationNotebook[], TaggingRules], ("EIWLExercises" -> 
              Pattern[ElementaryIntroToWLWeb`Private`ex, 
                Blank[]]) :> ElementaryIntroToWLWeb`Private`ex, Infinity]]; 
         ElementaryIntroToWLWeb`Private`tr = ReplaceAll[TaggingRules, 
            Options[
             EvaluationNotebook[], TaggingRules]]; 
         ElementaryIntroToWLWeb`Private`tr = 
          DeleteCases[
           ElementaryIntroToWLWeb`Private`tr, "EIWLExercises" -> Blank[], 
            Infinity]; 
         AppendTo[
          ElementaryIntroToWLWeb`Private`tr, 
           "EIWLExercises" -> {
            "ExercisesTotal" -> 
             ReplaceAll[
              "ExercisesTotal", ElementaryIntroToWLWeb`Private`data], 
             "ExercisesTried" -> Append[
               Flatten[
                Cases[
                ElementaryIntroToWLWeb`Private`data, ("ExercisesTried" -> 
                  Pattern[ElementaryIntroToWLWeb`Private`t, 
                    Blank[]]) :> ElementaryIntroToWLWeb`Private`t, Infinity]],
                ElementaryIntroToWLWeb`Private`value], "ExercisesCorrect" -> 
             ReplaceAll[
              "ExercisesCorrect", ElementaryIntroToWLWeb`Private`data]}]; 
         SetOptions[
           EvaluationNotebook[], TaggingRules -> 
           ElementaryIntroToWLWeb`Private`tr]; \
$CellContext`EIWLExerciseSolutionsTried = \
$CellContext`GetUserSolutionsTried[]; Null]; 
      Clear[$CellContext`SetUserSolutionsCorrect]; \
$CellContext`SetUserSolutionsCorrect[
         Pattern[ElementaryIntroToWLWeb`Private`value, 
          Blank[]]] := 
       Module[{ElementaryIntroToWLWeb`Private`data, 
          ElementaryIntroToWLWeb`Private`tr}, 
         ElementaryIntroToWLWeb`Private`data = Flatten[
            Cases[
             Options[
              EvaluationNotebook[], TaggingRules], ("EIWLExercises" -> 
              Pattern[ElementaryIntroToWLWeb`Private`ex, 
                Blank[]]) :> ElementaryIntroToWLWeb`Private`ex, Infinity]]; 
         ElementaryIntroToWLWeb`Private`tr = ReplaceAll[TaggingRules, 
            Options[
             EvaluationNotebook[], TaggingRules]]; 
         ElementaryIntroToWLWeb`Private`tr = 
          DeleteCases[
           ElementaryIntroToWLWeb`Private`tr, "EIWLExercises" -> Blank[], 
            Infinity]; 
         AppendTo[
          ElementaryIntroToWLWeb`Private`tr, 
           "EIWLExercises" -> {
            "ExercisesTotal" -> 
             ReplaceAll[
              "ExercisesTotal", ElementaryIntroToWLWeb`Private`data], 
             "ExercisesTried" -> 
             ReplaceAll[
              "ExercisesTried", ElementaryIntroToWLWeb`Private`data], 
             "ExercisesCorrect" -> Append[
               Flatten[
                Cases[
                ElementaryIntroToWLWeb`Private`data, ("ExercisesCorrect" -> 
                  Pattern[ElementaryIntroToWLWeb`Private`t, 
                    Blank[]]) :> ElementaryIntroToWLWeb`Private`t, Infinity]],
                ElementaryIntroToWLWeb`Private`value]}]; SetOptions[
           EvaluationNotebook[], TaggingRules -> 
           ElementaryIntroToWLWeb`Private`tr]; \
$CellContext`EIWLExerciseSolutionsCorrect = \
$CellContext`GetUserSolutionsCorrect[]; Null]; 
      Clear[ElementaryIntroToWLWeb`Private`GetCurrentTallyCell]; \
$CellContext`GetCurrentTallyCell[] := Module[{}, 
         With[{
          ElementaryIntroToWLWeb`Private`solutionsTried = \
$CellContext`GetUserSolutionsTried[], 
           ElementaryIntroToWLWeb`Private`solutionsTotal = \
$CellContext`GetUserSolutionsTotal[], 
           ElementaryIntroToWLWeb`Private`solutionsCorrect = \
$CellContext`GetUserSolutionsCorrect[]}, 
          Cell[
           BoxData[
            PaneBox[
             TemplateBox[{
               StyleBox[
               "COMPLETED\[ThickSpace]\[ThickSpace]", 
                "DockedCellCompletedExerciseText"], 
               StyleBox[
               ElementaryIntroToWLWeb`Private`solutionsTried, 
                "DockedCellCompletedExerciseText"], 
               StyleBox["/", "DockedCellSolutionDivider"], 
               StyleBox[
               ElementaryIntroToWLWeb`Private`solutionsTotal, 
                "DockedCellCompletedExerciseText"], 
               StyleBox[
               "\[ThinSpace]|\[ThinSpace]", "DockedCellSolutionDivider"], 
               StyleBox[
               ElementaryIntroToWLWeb`Private`solutionsCorrect, 
                "DockedCellCorrectExerciseText"], 
               StyleBox[
               "\[ThickSpace]\[ThickSpace]CORRECT", 
                "DockedCellCorrectExerciseText"]}, "RowDefault"], Alignment -> 
             Right, ImageSize -> Full]], "Output", TextAlignment -> Right, 
           CellFrame -> 1, CellMargins -> {{0, 0}, {10, 0}}, 
           CellFrameMargins -> {{14, 24}, {4, 7}}, CellFrameColor -> 
           RGBColor[1, 0.956862, 0.878431], MenuSortingValue -> 10000, 
           Background -> RGBColor[1, 0.956862, 0.878431], CellTags -> 
           "SolutionTallyCell"]]])]], "Output", CellMargins -> 0, 
   CellFrameMargins -> {{0, 24}, {3, 6}}, Background -> 
   RGBColor[0.97647, 0.482352, 0], CellFrame -> 1, CellFrameColor -> 
   RGBColor[0.97647, 0.482352, 0]], 
  Cell["SECOND EDITION", "Text", FontFamily -> "Source Sans Pro", 
   CellFrame -> {{0, 0}, {3, 0}}, ShowCellBracket -> False, 
   CellMargins -> {{0, 0}, {-1, -1}}, CellFrameMargins -> {{44, 0}, {2, 4}}, 
   CellFrameColor -> RGBColor[0.952941, 0.509804, 0], FontSize -> 10, 
   FontTracking -> "Extended", FontColor -> RGBColor[1, 0.929412, 0.721569], 
   Background -> RGBColor[0.862745, 0.309804, 0], CellTags -> 
   "DockedCellLogoCell"]},
TaggingRules->{
 "EIWLExercises" -> {
   "ExercisesTotal" -> {
     "+22.1", "22.1", "22.10", "22.11", "22.12", "22.13", "22.14", "22.15", 
      "22.16", "+22.2", "22.2", "+22.3", "22.3", "+22.4", "22.4", "+22.5", 
      "22.5", "+22.6", "22.6", "+22.7", "22.7", "22.8", "22.9"}, 
    "ExercisesTried" -> {}, "ExercisesCorrect" -> {}}},
FrontEndVersion->"11.1 for Mac OS X x86 (32-bit, 64-bit Kernel) (April 18, \
2017)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[StyleDefinitions -> "Default.nb"]], 
   Cell[
    CellGroupData[{
      Cell[
      "Style Environments", "Section", 
       CellChangeTimes -> {{3.64661165091824*^9, 3.646611654013329*^9}, 
         3.6485723794335403`*^9, 3.651347081728628*^9, 3.651347179462186*^9, 
         3.651347384135805*^9, 3.651348171662589*^9, {3.662385415502224*^9, 
         3.662385415587447*^9}, {3.662385986094821*^9, 
         3.662385986340312*^9}, {3.662386515144682*^9, 
         3.662386515438078*^9}, {3.662386561676188*^9, 
         3.662386561889332*^9}, {3.668356126688795*^9, 
         3.6683561270120687`*^9}, {3.670169943059537*^9, 
         3.670169943254141*^9}}], 
      Cell[
       StyleData[All, "Working"]], 
      Cell[
       StyleData[All, "Printout"], 
       PrintingOptions -> {
        "PageSize" -> {504, 720}, "PrintRegistrationMarks" -> True}, 
       Magnification -> 0.6]}, Closed]], 
   Cell[
    CellGroupData[{
      Cell[
      "Custom Styles", "Section", 
       CellChangeTimes -> {{3.646611660445352*^9, 3.646611669493331*^9}}], 
      Cell[
       StyleData["Notebook"], CreateCellID -> True, CellContext -> Notebook, 
       CellLabelAutoDelete -> False, DefaultNewCellStyle -> "Input", 
       ShowSyntaxStyles -> True, MenuSortingValue -> None], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Title"], CellMargins -> {{64, Inherited}, {50, 72}}, 
          MenuCommandKey -> None, FontFamily -> "Verdana", FontSize -> 42, 
          FontWeight -> "Bold", FontColor -> GrayLevel[0.4]], 
         Cell[
          StyleData["Title", "Printout"], 
          CellMargins -> {{64, Inherited}, {50, 72}}]}, Closed]], 
      Cell[
       StyleData["Chapter"], MenuCommandKey -> None], 
      Cell[
       StyleData["Subchapter"], MenuCommandKey -> None], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Section"], CellFrame -> {{0, 0}, {0, 0}}, CellDingbat -> 
          Cell[
            TextData[
             CounterBox["Section"], 
             StyleBox[
             "|\[NegativeThinSpace]", FontColor -> 
              RGBColor[
               0.9019607843137255, 0.4117647058823529, 0.027450980392156862`],
               FontFamily -> "Courier", FontSize -> 36, FontWeight -> Plain]],
             "SectionNumber"], CellMargins -> {{96, Inherited}, {12, 64}}, 
          Evaluatable -> True, CellGroupingRules -> {"SectionGrouping", 60}, 
          PageBreakAbove -> True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["Section", "Printout"], 
          CellMargins -> {{96, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionDoubleDigit"], CellFrame -> {{0, 0}, {0, 0}}, 
          CellDingbat -> Cell[
            TextData[
             CounterBox["Section"], 
             StyleBox[
             "|\[NegativeThinSpace]", FontColor -> 
              RGBColor[
               0.9019607843137255, 0.4117647058823529, 0.027450980392156862`],
               FontFamily -> "Courier", FontSize -> 36, FontWeight -> Plain]],
             "SectionNumber"], CellMargins -> {{112, Inherited}, {12, 64}}, 
          Evaluatable -> True, CellGroupingRules -> {"SectionGrouping", 60}, 
          PageBreakAbove -> True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["SectionDoubleDigit", "Printout"], 
          CellMargins -> {{112, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionNumber"], CellBaseline -> Baseline, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 26, FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SectionNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionInline"], FontFamily -> 
          "Source Sans Pro Semibold", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SectionInline", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionNoDingbat"], 
          CellMargins -> {{64, Inherited}, {12, 64}}, Evaluatable -> True, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakAbove -> 
          True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["SectionNoDingbat", "Printout"], 
          CellMargins -> {{64, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Exercise"], CellDingbat -> Cell[
            TextData[{"  ", 
              CounterBox["Section"], ".", 
              CounterBox["Exercise"]}], "ExerciseNumber", FontColor -> 
            RGBColor[
             0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
          ShowGroupOpener -> True, CellMargins -> {{90, 40}, {4, 18}}, 
          CellGroupingRules -> "InputGrouping", CounterIncrements -> 
          "Exercise", MenuSortingValue -> 10020, MenuCommandKey -> "2", 
          FontFamily -> "Source Sans Pro", FontSize -> 16, FontWeight -> 
          "Plain", FontSlant -> "Plain", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["Exercise", "Printout"], ShowGroupOpener -> False, 
          CellMargins -> {{110, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseNumber"], FontFamily -> "Source Sans Pro", 
          FontSize -> 16, FontWeight -> "Bold", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["ExerciseNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseInput", StyleDefinitions -> StyleData["Input"]], 
          CellMargins -> {{70, 30}, {4, 7}}, ShowCellLabel -> False, 
          CellFrameLabels -> {{None, None}, {None, None}}, SpanMaxSize -> 1, 
          FontSize -> 
          14, $CellContext`GeneratedCellStyles -> {
           "Output" -> "ExerciseOutput"}], 
         Cell[
          StyleData["ExerciseInput", "Printout"], 
          CellMargins -> {{88, 10}, {4, 7}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "ExerciseOutput", StyleDefinitions -> StyleData["Output"]], 
          CellMargins -> {{90, 40}, {0, 6}}, CellGroupingRules -> 
          "OutputGrouping", ShowCellLabel -> False, FontSize -> 14], 
         Cell[
          StyleData["ExerciseOutput", "Printout"], 
          CellMargins -> {{88, 10}, {10, 4}}]}, Closed]], 
      Cell[
       StyleData["ExerciseExpectedResult"], ShowCellBracket -> False, 
       ShowGroupOpener -> False, CellMargins -> {{90, 40}, {3, 9}}, 
       CellGroupingRules -> "InputGrouping", CounterIncrements -> "Exercise", 
       MenuSortingValue -> 10000, FontFamily -> "Source Sans Pro", FontSize -> 
       12, FontWeight -> "Plain", FontSlant -> "Plain"], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Picture"], CellMargins -> {{66, 10}, {10, 10}}, 
          CellGroupingRules -> "GraphicsGrouping", StyleMenuListing -> None], 
         
         Cell[
          StyleData["Picture", "Printout"], 
          CellMargins -> {{66, 10}, {8, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Tentative"], 
          CellBracketOptions -> {
           "Color" -> RGBColor[
             0.30000000000000016`, 0.6000000000000003, 0.7000000000000003], 
            "Thickness" -> 5}, Evaluatable -> False, CellFrameMargins -> 4, 
          StyleMenuListing -> None, Background -> 
          RGBColor[0.8500000000000003, 0.9500000000000003, 1]], 
         Cell[
          StyleData["Tentative", "Printout"], 
          CellElementSpacings -> {"CellMinHeight" -> 0.1}, CellOpen -> False, 
          CellFrameMargins -> 0, FontSize -> 0.1, Magnification -> 0.01]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["WebOnly"], 
          CellBracketOptions -> {
           "Color" -> RGBColor[0.91, 0.92, 0.9], "Thickness" -> 5}, 
          CellFrameMargins -> 4, StyleMenuListing -> None, Background -> 
          RGBColor[0.91, 0.92, 0.86]], 
         Cell[
          StyleData["WebOnly", "Printout"], 
          CellElementSpacings -> {"CellMinHeight" -> 0.1}, CellOpen -> False, 
          CellFrameMargins -> 0, FontSize -> 0.1, Magnification -> 0.01]}, 
        Closed]], 
      Cell[
       StyleData["Lockdown"], 
       CellBracketOptions -> {
        "Color" -> RGBColor[0.8, 0.5, 0.4], "Thickness" -> 3}, Evaluatable -> 
       False, StyleMenuListing -> None], 
      Cell[
       StyleData["InlineCode"], SpanMaxSize -> 0, FontColor -> GrayLevel[0]], 
      
      Cell[
       StyleData["ExpectedOutputNote"], Selectable -> False, FontFamily -> 
       "Source Sans Pro", FontColor -> GrayLevel[0.3]], 
      Cell[
       StyleData["EIWLTextLink"], LineBreakWithin -> False, 
       TemplateBoxOptions -> {DisplayFunction :> (TagBox[
           
           ButtonBox[#, Appearance -> None, ButtonData -> #2, 
            BaseStyle -> {
             "Hyperlink", FontWeight -> Bold, FontSize -> 16, FontFamily -> 
              "Source Sans Pro"}], 
           MouseAppearanceTag["LinkHand"]]& )}, 
       ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
      Cell[
       StyleData["CheckAnswerDividerCloud"], ShowCellBracket -> False, 
       CellMargins -> {{40, 40}, {3, 6}}, 
       CellBracketOptions -> {"OverlapContent" -> True}, 
       CellGroupingRules -> {"SectionGrouping", 40}, 
       CellFrameMargins -> {{20, 20}, {2, 2}}, TextAlignment -> Right], 
      Cell[
       StyleData["CodeSectionDividerCloud"], Editable -> False, Selectable -> 
       False, ShowCellBracket -> False, CellMargins -> {{0, 0}, {0, 35}}, 
       CellBracketOptions -> {"OverlapContent" -> True}, 
       CellElementSpacings -> {"CellMinHeight" -> 6}, 
       CellGroupingRules -> {"SectionGrouping", -5}, 
       CellFrameMargins -> {{20, 20}, {2, 2}}, DefaultNewCellStyle -> "Input",
        FontSize -> 6, Background -> GrayLevel[0.95]], 
      Cell[
       StyleData["InlineCode"], SpanMaxSize -> 0, FontColor -> GrayLevel[0]], 
      
      Cell[
       StyleData["InlineCodeText"], SpanMaxSize -> 0, FontFamily -> 
       "Source Sans Pro"], 
      Cell[
       StyleData["Input"], CellMargins -> {{92, 20}, {5, 8}}, 
       CellFrameLabels -> {{None, 
          
          DynamicModuleBox[{$CellContext`EIWLExerciseCheck = 
            Automatic, $CellContext`buttonLabel = " CHECK MY SOLUTION "}, 
           DynamicBox[
            ToBoxes[
             If[
              TrueQ[$CellContext`EIWLExerciseCheck == Automatic], 
              MouseAppearance[
               Tooltip[
                Button[
                 Framed[
                  Panel[
                   
                   Style[$CellContext`buttonLabel, FontFamily -> 
                    "Source Sans Pro", FontSize -> 10, FontColor -> 
                    RGBColor[0.953948, 0.305638, 0.0285344]], Appearance -> 
                   None, Background -> GrayLevel[1], 
                   FrameMargins -> {{2, 2}, {0, 0}}, ImageMargins -> 0], 
                  FrameStyle -> {
                    Thickness[Tiny], 
                    RGBColor[0.953948, 0.305638, 0.0285344]}, RoundingRadius -> 
                  3], 
                 
                 Block[{$CellContext`usersCell, $CellContext`solutionResult, \
$CellContext`exerciseNumber, $CellContext`exerciseSwitchResult}, \
$CellContext`exerciseNumber = StringJoin[
                    If[
                    TrueQ[CurrentValue[{"CounterValue", "WebOnly"}] == 1], 
                    "x", ""], 
                    ToString[
                    CurrentValue[{"CounterValue", "SectionNumber"}]], ".", 
                    ToString[
                    
                    CurrentValue[{
                    "CounterValue", 
                    "ExerciseNumber"}]]]; $CellContext`buttonLabel = 
                   Row[{" CHECKING ", 
                    ProgressIndicator[Appearance -> "Percolate"]}]; 
                  SelectionMove[
                    ButtonNotebook[], All, ButtonCell, AutoScroll -> 
                    False]; $CellContext`usersCell = NotebookRead[
                    InputNotebook[]]; If[
                    TrueQ[Length[
                    Flatten[{$CellContext`usersCell}]] == 
                    1], $CellContext`solutionResult = ToExpression[
                    URLFetch[
                    "https://www.wolframcloud.com/objects/user-9b23d046-b2a9-\
4a5c-8723-08465cce25ed/EIWLGradingAPI", "Method" -> "POST", 
                    "Parameters" -> {
                    "exNum" -> $CellContext`exerciseNumber, "answer" -> 
                    ToString[$CellContext`usersCell, InputForm, 
                    CharacterEncoding -> "ASCII"], "user" -> 
                    ToString[$WolframID], "referer" -> "eiwl-nb", "uuid" -> 
                    ToString[$WolframUUID]}]]; \
$CellContext`SolutionResponseText[$CellContext`exerciseNumber] = \
$CellContext`SolutionResponseDetails[
                    $CellContext`solutionResult["Text"], 
                    $CellContext`solutionResult[
                    "CorrectQ"]]; $CellContext`exerciseSwitchResult = Switch[
                    $CellContext`solutionResult["CorrectQ"], 
                    True, $CellContext`EIWLExerciseCheck = 
                    True; $CellContext`SetUserSolutionsCorrect[$CellContext`\
exerciseNumber]; \
$CellContext`SetUserSolutionsTried[$CellContext`exerciseNumber]; Null, 
                    
                    Blank[], $CellContext`EIWLExerciseCheck = 
                    False; $CellContext`SetUserSolutionsTried[$CellContext`\
exerciseNumber]], 
                    CloudSystem`CreateCloudDialog[
                    StyleBox[
                    "Select a cell to be checked.", Selectable -> False], 
                    WindowTitle -> " "]]], Appearance -> None, Evaluator -> 
                 Automatic, Method -> "Queued"], 
                "Click to check your solution.", TooltipDelay -> 0.15], 
               "LinkHand"], 
              If[
               TrueQ[$CellContext`EIWLExerciseCheck], 
               MouseAppearance[
                Button[
                 Framed[
                  Row[{
                    Panel[
                    Style[
                    ToExpression[
                    "\!\(\* GraphicsBox[ TagBox[RasterBox[CompressedData[\" \
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBLECOU2VJahIzkCECxFJADGKrbtYa \
RUMUpZzMcNnnQRWjMk5lf/vzDWggtYwCkgNiFDBAsPqCPFcBjcLURYkH0fRS \
HlZwE6gV7EATfvz98f3Pd6rEIBClncpMPZlJFaNGEd0QANRpOvM= \"], {{0, 20}, { 26, \
0}}, {0, 255}, ColorFunction->RGBColor], BoxForm`ImageTag[ \"Byte\", \
Interleaving -> True, Magnification -> 1], Selectable->False], \
BaseStyle->\"ImageGraphics\", ImageSize->Magnification[1], ImageSizeRaw->{26, \
20}, PlotRange->{{0, 26}, {0, 20}}]\)"], Selectable -> False], Background -> 
                    RGBColor[0.146944, 0.70164, 0.16466], 
                    FrameMargins -> {{5, 5}, {0, 0}}, ImageMargins -> 0, 
                    Appearance -> None], 
                    Panel[
                    Style[
                    " CORRECT ", FontSize -> 10, FontColor -> 
                    RGBColor[0.146944, 0.70164, 0.16466], FontFamily -> 
                    "Source Sans Pro"], Background -> White, 
                    FrameMargins -> {{5, 5}, {0, 0}}, Appearance -> None]}], 
                  FrameStyle -> {
                    Thickness[Tiny], 
                    RGBColor[0.146944, 0.70164, 0.16466]}, FrameMargins -> 0, 
                  RoundingRadius -> 3], $CellContext`buttonLabel = 
                  " CHECK MY SOLUTION "; $CellContext`EIWLExerciseCheck = 
                  Automatic, Appearance -> None], "LinkHand"], 
               MouseAppearance[
                Button[
                 Framed[
                  Row[{
                    Panel[
                    Style[
                    ToExpression[
                    "\!\(\* GraphicsBox[ TagBox[RasterBox[CompressedData[\" \
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBLECOU2VJahIzkCECxGJADGK/YtAZ \
RTRCb1W8PnhlYooDBYFSxJgAVPnvy7cPfrkogn65IEFsJmM3BKIeZggal1RD \
yNOOMOT7DyAiTzvlJlDoCwpDkvLYpDxFjSLyEAAHORZk \"], {{0, 20}, {22, 0}}, { 0, \
255}, ColorFunction->RGBColor], BoxForm`ImageTag[ \"Byte\", Interleaving -> \
True, Magnification -> 1], Selectable->False], BaseStyle->\"ImageGraphics\", \
ImageSize->Magnification[1], ImageSizeRaw->{22, 20}, PlotRange->{{0, 22}, {0, \
20}}]\)"], Selectable -> False], Background -> 
                    RGBColor[0.918257, 0, 0.172488], 
                    FrameMargins -> {{5, 5}, {0, 0}}, ImageMargins -> 0, 
                    Appearance -> None], 
                    Panel[
                    Style[
                    " TRY AGAIN ", FontSize -> 10, FontColor -> 
                    RGBColor[0.918257, 0, 0.172488], FontFamily -> 
                    "Source Sans Pro"], Background -> White, 
                    FrameMargins -> {{5, 5}, {0, 0}}, Appearance -> None]}], 
                  FrameStyle -> {
                    Thickness[Tiny], 
                    RGBColor[0.918257, 0, 0.172488]}, FrameMargins -> 0, 
                  RoundingRadius -> 3], $CellContext`buttonLabel = 
                  " CHECK MY SOLUTION "; $CellContext`EIWLExerciseCheck = 
                  Automatic, Appearance -> None], "LinkHand"]]], 
             StandardForm], ImageSizeCache -> {109., {9., 16.}}], 
           DynamicModuleValues :> {}]}, {None, None}}, 
       CellChangeTimes -> {{3.6688095471029243`*^9, 3.66880959932793*^9}}, 
       MenuSortingValue -> 10000, FontSize -> 15], 
      Cell[
       StyleData["Output"], Deletable -> True, ShowCellBracket -> True, 
       CellMargins -> {{92, 50}, {10, 5}}, 
       CellBracketOptions -> {"OverlapContent" -> True}, CellEditDuplicate -> 
       True, GeneratedCell -> True, CellAutoOverwrite -> True, 
       LinebreakAdjustments -> {1, 2., 12., 1.25, 1.}, MenuSortingValue -> 
       None, FontSize -> 15], 
      Cell[
       StyleData["Message"], 
       CellMargins -> {{92, Inherited}, {Inherited, Inherited}}], 
      Cell[
       StyleData["EmptyCell"], Editable -> False, Selectable -> False, 
       CellMargins -> {{0, 0}, {-2, 0}}, 
       CellElementSpacings -> {"CellMinHeight" -> 1}, MenuSortingValue -> 
       10000, FontSize -> 1], 
      Cell[
       StyleData["CellLabel"], MenuSortingValue -> 10000, FontColor -> 
       GrayLevel[0.6]], 
      Cell[
       StyleData["Link"], LineBreakWithin -> False, 
       TemplateBoxOptions -> {DisplayFunction :> (TagBox[
           
           ButtonBox[#, Appearance -> None, ButtonData -> #2, 
            BaseStyle -> {
             "Hyperlink", FontSize -> 15, FontFamily -> "Source Sans Pro"}], 
           MouseAppearanceTag["LinkHand"]]& )}, 
       ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
      Cell[
       StyleData["ExpectedOutputText"], FontFamily -> "Arial", FontSize -> 13,
        FontColor -> RGBColor[0.8579079880979629, 0.4263828488593881, 0.]], 
      Cell[
       StyleData["CodeSectionDividerCloud"], Selectable -> False, 
       ShowCellBracket -> False, CellMargins -> {{0, 0}, {0, 35}}, 
       CellBracketOptions -> {"OverlapContent" -> True}, 
       CellElementSpacings -> {"CellMinHeight" -> 6}, 
       CellGroupingRules -> {"SectionGrouping", -5}, 
       CellFrameMargins -> {{20, 20}, {2, 2}}, DefaultNewCellStyle -> 
       "EmptyCell", FontSize -> 6, Background -> GrayLevel[0.95]], 
      Cell[
       StyleData["DockedCellAuthorName"], MenuSortingValue -> 10000, 
       FontFamily -> "Source Sans Pro", FontSize -> 12, FontColor -> 
       RGBColor[1, 0.929411, 0.721568]], 
      Cell[
       StyleData["DockedCellSectionTitle"], MenuSortingValue -> 10000, 
       FontFamily -> "Source Sans Pro", FontSize -> 18, FontColor -> 
       GrayLevel[1]], 
      Cell[
       StyleData["DockedCellSecondCell"], CellFrame -> 1, 
       CellMargins -> {{0, 0}, {0, 0}}, 
       CellFrameMargins -> {{10, 10}, {10, 10}}, CellFrameColor -> 
       RGBColor[1, 0.956862, 0.878431], MenuSortingValue -> 10000, Background -> 
       RGBColor[1, 0.956862, 0.878431]], 
      Cell[
       StyleData["CompletedExerciseHeader"], MenuSortingValue -> 10000, 
       FontFamily -> "Source Sans Pro", FontSize -> 14, FontColor -> 
       GrayLevel[0.5]], 
      Cell[
       StyleData["DockedCellShareButton"], MenuSortingValue -> 10000, 
       FontFamily -> "Source Sans Pro", FontSize -> 13, FontColor -> 
       GrayLevel[1]], 
      Cell[
       StyleData["DockedCellLinksSections"], MenuSortingValue -> 10000, 
       FontFamily -> "Source Sans Pro", FontSize -> 14, FontWeight -> "Plain",
        FontSlant -> "Plain", FontColor -> RGBColor[0.97647, 0.482352, 0]], 
      Cell[
       StyleData["DockedCellLinksDivider"], MenuSortingValue -> 10000, 
       FontFamily -> "Courier", FontSize -> 18, FontWeight -> "Plain", 
       FontSlant -> "Plain", FontColor -> RGBColor[0.97647, 0.482352, 0]], 
      Cell[
       StyleData["DockedCellSectionTitleDivider"], MenuSortingValue -> 10000, 
       FontFamily -> "Courier", FontSize -> 24, FontWeight -> "Plain", 
       FontSlant -> "Plain", FontColor -> GrayLevel[1]], 
      Cell[
       StyleData["SolutionTrue"], MenuSortingValue -> 10000, FontFamily -> 
       "Source Sans Pro", FontSize -> 12, FontWeight -> "Plain", FontSlant -> 
       "Plain", FontColor -> RGBColor[0.12, 0.7, 0.22]], 
      Cell[
       StyleData["SolutionFalse"], MenuSortingValue -> 10000, FontFamily -> 
       "Source Sans Pro", FontSize -> 12, FontWeight -> "Plain", FontSlant -> 
       "Plain", FontColor -> RGBColor[0.94, 0.08, 0.2]], 
      Cell[
       StyleData["SolutionResponseText"], ShowStringCharacters -> False, 
       FontFamily -> "Source Sans Pro", FontSize -> 12, FontWeight -> "Plain",
        FontSlant -> "Plain", FontColor -> GrayLevel[1]], 
      Cell[
       StyleData["SolutionResponse"], ShowCellBracket -> False, 
       CellMargins -> {{24, 25}, {6, 0}}, 
       CellFrameMargins -> {{8, 0}, {0, 12}}, TextAlignment -> Right, 
       ShowStringCharacters -> False, FontFamily -> "Source Sans Pro", 
       FontSize -> 12, FontWeight -> "Plain", FontSlant -> "Plain", 
       Background -> GrayLevel[1]], 
      Cell[
       StyleData["DockedCellCompletedExerciseText"], MenuSortingValue -> 
       10000, FontFamily -> "Source Sans Pro", FontSize -> 12, FontWeight -> 
       "Plain", FontSlant -> "Plain", FontColor -> GrayLevel[0.4]], 
      Cell[
       StyleData["DockedCellSolutionDivider"], MenuSortingValue -> 10000, 
       FontFamily -> "Courier", FontSize -> 16, FontWeight -> "Plain", 
       FontSlant -> "Plain", FontColor -> GrayLevel[0.6]], 
      Cell[
       StyleData["DockedCellCorrectExerciseText"], MenuSortingValue -> 10000, 
       FontFamily -> "Source Sans Pro", FontSize -> 12, FontWeight -> "Plain",
        FontSlant -> "Plain", FontColor -> RGBColor[0.12, 0.7, 0.22]], 
      Cell[
       CellGroupData[{
         Cell[
         "EIWL Cloud Link styles", "Subsubsection", 
          CellChangeTimes -> {{3.663512229965006*^9, 3.66351224118613*^9}}], 
         Cell[
          StyleData["EIWLTextLink"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 16, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkAnswer"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkCodeCaption"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontColor -> GrayLevel[0.6], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkExercise"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkExerciseNote"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkInlineCode"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkMoreExplore"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkQuestion"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontWeight -> Bold, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkTechNote"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkText"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 17, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkInlineCodeLink"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 17, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["EIWLTextLinkVocabularyTable"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
         "EIWL Cloud Link", "Subsubsection", 
          CellChangeTimes -> {{3.664234597774767*^9, 3.664234605661516*^9}}], 
         
         Cell[
          StyleData["CodeLinkAnswer"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkCodeCaption"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontColor -> GrayLevel[0.6], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkExercise"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkQuestion"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontWeight -> Bold, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkTechNote"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkText"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 17, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkVocabularyTable"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["CodeLinkVocabularyTable3Column"], LineBreakWithin -> 
          False, TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkAnswer"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkCodeCaption"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontColor -> GrayLevel[0.6], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkExercise"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkExerciseNote"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkIndex"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkIndexSubentry"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkMoreExplore"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkQuestion"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 14, FontWeight -> Bold, FontColor -> 
                 GrayLevel[0], FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkTechNote"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontColor -> GrayLevel[0.25], 
                 FontFamily -> "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkText"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 16, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}], 
         Cell[
          StyleData["LinkVocabularyTable"], LineBreakWithin -> False, 
          TemplateBoxOptions -> {DisplayFunction :> (TagBox[
              
              ButtonBox[#, Appearance -> None, ButtonData -> #2, 
               BaseStyle -> {
                "Hyperlink", FontSize -> 13, FontFamily -> 
                 "Source Sans Pro"}], 
              MouseAppearanceTag["LinkHand"]]& )}, 
          ButtonBoxOptions -> {Appearance -> None, BaseStyle -> "Link"}]}, 
        Closed]]}, Open]]}, Visible -> False, FrontEndVersion -> 
  "11.1 for Mac OS X x86 (32-bit, 64-bit Kernel) (April 18, 2017)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "FirstInputCell"->{
  Cell[7308, 191, 813, 26, 
  70, "Input", "ExpressionUUID" -> "fc5366a0-206a-4df9-8bb8-3c5db3e53652",
   CellTags->"FirstInputCell"],
  Cell[15725, 419, 813, 26, 
  70, "Input", "ExpressionUUID" -> "a26483d4-ba99-406a-b40e-f526920a54d3",
   CellTags->"FirstInputCell"],
  Cell[28801, 719, 813, 26, 
  70, "Input", "ExpressionUUID" -> "58c64c29-ec4d-473e-9500-afe78140cd8a",
   CellTags->"FirstInputCell"],
  Cell[36390, 927, 813, 26, 
  70, "Input", "ExpressionUUID" -> "9995ebac-f6ad-48d1-b274-eadf646a4997",
   CellTags->"FirstInputCell"],
  Cell[49094, 1224, 813, 26, 
  70, "Input", "ExpressionUUID" -> "16cb33e2-a5de-46a7-9795-a64d7ec20a7d",
   CellTags->"FirstInputCell"],
  Cell[57067, 1441, 813, 26, 
  70, "Input", "ExpressionUUID" -> "51f8ac7b-2227-4123-a3ad-f93eeb604f50",
   CellTags->"FirstInputCell"],
  Cell[64208, 1646, 813, 26, 
  70, "Input", "ExpressionUUID" -> "7ef804d4-f754-48a2-a243-a3b317b3127d",
   CellTags->"FirstInputCell"],
  Cell[71203, 1844, 813, 26, 
  70, "Input", "ExpressionUUID" -> "6053f40f-6f87-4125-afdf-24e20623ad3f",
   CellTags->"FirstInputCell"],
  Cell[85014, 2154, 813, 26, 
  70, "Input", "ExpressionUUID" -> "129b7de7-fa95-4a88-9442-53a8cecd630a",
   CellTags->"FirstInputCell"],
  Cell[119367, 2808, 813, 26, 
  70, "Input", "ExpressionUUID" -> "9e9854eb-ac7d-4b26-9ed4-c447f3c2b253",
   CellTags->"FirstInputCell"],
  Cell[166898, 3674, 813, 26, 
  70, "Input", "ExpressionUUID" -> "081e55f7-5c41-4385-bc1a-b6fcbd96f341",
   CellTags->"FirstInputCell"],
  Cell[443399, 8290, 813, 26, 
  70, "Input", "ExpressionUUID" -> "29720589-595b-496a-831e-a07e457256be",
   CellTags->"FirstInputCell"],
  Cell[489965, 9139, 813, 26, 
  70, "Input", "ExpressionUUID" -> "d413052c-2016-46de-a378-1226e652b748",
   CellTags->"FirstInputCell"],
  Cell[498038, 9358, 813, 26, 
  70, "Input", "ExpressionUUID" -> "f316bdc8-a711-4fcb-a6d8-dfdeda738e21",
   CellTags->"FirstInputCell"],
  Cell[513694, 9700, 813, 26, 
  70, "Input", "ExpressionUUID" -> "207f67bf-e042-4a05-81a9-fc6e6c3f2e85",
   CellTags->"FirstInputCell"],
  Cell[530439, 10060, 813, 26, 
  70, "Input", "ExpressionUUID" -> "7e74f3df-89d9-41c4-8562-8d1f86bc6a4c",
   CellTags->"FirstInputCell"],
  Cell[543586, 10361, 813, 26, 
  70, "Input", "ExpressionUUID" -> "1ba8ffff-2f47-49d6-a722-5ce2e391bf04",
   CellTags->"FirstInputCell"],
  Cell[550972, 10568, 813, 26, 
  70, "Input", "ExpressionUUID" -> "db4cd4b7-4789-4589-af1a-56c3e8077bc0",
   CellTags->"FirstInputCell"],
  Cell[558160, 10779, 813, 26, 
  70, "Input", "ExpressionUUID" -> "e8a6faba-fdbd-458c-91a6-fd3dbea1db56",
   CellTags->"FirstInputCell"],
  Cell[572575, 11105, 813, 26, 
  70, "Input", "ExpressionUUID" -> "6df2ea12-a214-4f52-9f7d-e4090bede2a3",
   CellTags->"FirstInputCell"],
  Cell[599798, 11638, 813, 26, 
  70, "Input", "ExpressionUUID" -> "2b55e5db-cee2-4f16-9702-769aa968bbcc",
   CellTags->"FirstInputCell"],
  Cell[616736, 12002, 813, 26, 
  70, "Input", "ExpressionUUID" -> "fdb4927f-8978-440c-96d7-58a656981d2e",
   CellTags->"FirstInputCell"],
  Cell[637527, 12429, 813, 26, 
  70, "Input", "ExpressionUUID" -> "0a1b697e-06bd-4bbb-96cf-4eccc0d13a7c",
   CellTags->"FirstInputCell"]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"FirstInputCell", 696630, 13651}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[639, 22, 486, 10, 70, "Exercise", "ExpressionUUID" -> \
"d1c0fe2e-580c-4b85-90e1-519e15f4c7dc",
 CounterAssignments->{{"SectionNumber", 22}, {"ExerciseNumber", 1}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[1150, 36, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"0b332ebd-9d60-4e11-9272-72e11f0ccbab"],
Cell[1789, 57, 4912, 109, 70, "ExerciseOutput", "ExpressionUUID" -> \
"ae327f56-1305-446c-bf91-accbb8342568"]
}, Closed]],
Cell[CellGroupData[{
Cell[6738, 171, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"5e2bd33d-2308-4b2c-a7e4-d24fa02b856e"],
Cell[7308, 191, 813, 26, 70, "Input", "ExpressionUUID" -> \
"fc5366a0-206a-4df9-8bb8-3c5db3e53652",
 CellTags->"FirstInputCell"]
}, Open  ]],
Cell[CellGroupData[{
Cell[8158, 222, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"ccb6a435-83c9-4d64-a85c-1b6147732715"],
Cell[8445, 233, 1036, 26, 70, "Exercise", "ExpressionUUID" -> \
"1fb70927-ff4e-413f-ae03-186ce6ed0125",
 CounterAssignments->{{"SectionNumber", 22}, {"ExerciseNumber", 2}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[9506, 263, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"f68f9c14-1737-455d-af74-2c2c1707bd85"],
Cell[10145, 284, 4973, 110, 70, "ExerciseOutput", "ExpressionUUID" -> \
"3ee645c7-7cf8-4ec3-bb2d-c80481a73043"]
}, Closed]],
Cell[CellGroupData[{
Cell[15155, 399, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"60d51917-5f40-4da0-b066-844d809addde"],
Cell[15725, 419, 813, 26, 70, "Input", "ExpressionUUID" -> \
"a26483d4-ba99-406a-b40e-f526920a54d3",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[16587, 451, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"bccae46f-fcd6-4357-9996-eba3d7caa54d"],
Cell[16874, 462, 491, 12, 70, "Exercise", "ExpressionUUID" -> \
"3aa7df4e-7610-4be7-8d4f-743895b6b9fd",
 CounterAssignments->{{"SectionNumber", 22}, {"ExerciseNumber", 3}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[17390, 478, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"7b728fcd-c8fb-4fa4-a66a-61cacc9f8121"],
Cell[18029, 499, 10165, 195, 70, "ExerciseOutput", "ExpressionUUID" -> \
"e7f6ca7b-d9c0-4d5c-824d-e8fb22f8b888"]
}, Closed]],
Cell[CellGroupData[{
Cell[28231, 699, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"3fefd6e0-8a61-4a79-83ce-9aa41e9ba691"],
Cell[28801, 719, 813, 26, 70, "Input", "ExpressionUUID" -> \
"58c64c29-ec4d-473e-9500-afe78140cd8a",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[29663, 751, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"e4e6852f-964e-4958-ad5a-c18dfb35e5bd"],
Cell[29950, 762, 501, 10, 70, "Exercise", "ExpressionUUID" -> \
"b05d423d-ee30-4862-921f-b070ae8643c7",
 CounterAssignments->{{"SectionNumber", 22}, {"ExerciseNumber", 4}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[30476, 776, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"4ae100f0-abab-43a1-ad13-fdbb1e58798e"],
Cell[31115, 797, 4668, 105, 70, "ExerciseOutput", "ExpressionUUID" -> \
"4607b5cf-0194-4648-9e02-aab9c777525a"]
}, Closed]],
Cell[CellGroupData[{
Cell[35820, 907, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"55b2c58e-c8cc-448e-b86e-308e073afddb"],
Cell[36390, 927, 813, 26, 70, "Input", "ExpressionUUID" -> \
"9995ebac-f6ad-48d1-b274-eadf646a4997",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[37252, 959, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"0bf49169-6b5e-429d-b4d3-4ceba0cb5677"],
Cell[37539, 970, 725, 18, 70, "Exercise", "ExpressionUUID" -> \
"3f38341e-0db6-4923-8425-8fcea2b5ded2",
 CounterAssignments->{{"SectionNumber", 22}, {"ExerciseNumber", 5}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[38289, 992, 656, 20, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"a0c86a58-b9f6-4e6b-bff5-a9af5916cda0"],
Cell[38948, 1014, 9539, 185, 70, "ExerciseOutput", "ExpressionUUID" -> \
"47803965-fbc7-466d-b977-8097a948f247"]
}, Closed]],
Cell[CellGroupData[{
Cell[48524, 1204, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"17dafe48-93c3-44dd-b728-d889f9410fcc"],
Cell[49094, 1224, 813, 26, 70, "Input", "ExpressionUUID" -> \
"16cb33e2-a5de-46a7-9795-a64d7ec20a7d",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[49956, 1256, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"e78d4e96-9bf3-4cac-b196-27fae2d825ac"],
Cell[50243, 1267, 515, 12, 70, "Exercise", "ExpressionUUID" -> \
"fbb47e51-8d01-44a7-92d9-7ec98ca3f8c0",
 CounterAssignments->{{"SectionNumber", 22}, {"ExerciseNumber", 6}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[50783, 1283, 656, 20, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"6133e682-67ab-417a-baef-05c8349e5ae0"],
Cell[51442, 1305, 5018, 111, 70, "ExerciseOutput", "ExpressionUUID" -> \
"bb47eda8-f2b1-440a-9519-52dc7969302f"]
}, Closed]],
Cell[CellGroupData[{
Cell[56497, 1421, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"563cf47f-1249-4804-9b30-7d13db4e7aea"],
Cell[57067, 1441, 813, 26, 70, "Input", "ExpressionUUID" -> \
"51f8ac7b-2227-4123-a3ad-f93eeb604f50",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[57929, 1473, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"6feb2866-cf2e-474d-9764-4a1519ec2f96"],
Cell[58216, 1484, 574, 15, 70, "Exercise", "ExpressionUUID" -> \
"45125d8a-4186-4742-b24e-49cda9c87cc1",
 CounterAssignments->{{"SectionNumber", 22}, {"ExerciseNumber", 7}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[58815, 1503, 656, 20, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"5f3815e7-800c-4007-8b8c-933e3e6497ca"],
Cell[59474, 1525, 4127, 96, 70, "ExerciseOutput", "ExpressionUUID" -> \
"2ac2ed4e-140f-4f48-9e46-5db56c36dcec"]
}, Closed]],
Cell[CellGroupData[{
Cell[63638, 1626, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"58b689ae-47bb-46a0-b632-16828f925152"],
Cell[64208, 1646, 813, 26, 70, "Input", "ExpressionUUID" -> \
"7ef804d4-f754-48a2-a243-a3b317b3127d",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[65070, 1678, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"7075db87-5c93-46a2-9266-647c0ae6b84f"],
Cell[65357, 1689, 440, 9, 70, "Exercise", "ExpressionUUID" -> \
"b1c81f98-046e-41d3-b2a6-7bd1de1aed25",
 CounterAssignments->{{"SectionNumber", 22}, {"ExerciseNumber", 8}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[65822, 1702, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"313ea652-0505-4a9e-a883-5a2f94c9c52f"],
Cell[66461, 1723, 4135, 96, 70, "ExerciseOutput", "ExpressionUUID" -> \
"36d55505-3c20-41c9-b35b-e993457fd6e5"]
}, Closed]],
Cell[CellGroupData[{
Cell[70633, 1824, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"cedb0972-94bf-4e40-bc6e-f94090654e7f"],
Cell[71203, 1844, 813, 26, 70, "Input", "ExpressionUUID" -> \
"6053f40f-6f87-4125-afdf-24e20623ad3f",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[72065, 1876, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"1e885bc6-8a86-4588-a4c7-bdddd6d0b0c3"],
Cell[72352, 1887, 441, 9, 70, "Exercise", "ExpressionUUID" -> \
"6054dbd3-adb2-4be4-ad25-12429c5949b0",
 CounterAssignments->{{"SectionNumber", 22}, {"ExerciseNumber", 9}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[72818, 1900, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"4db4ce76-c147-44bb-b238-a4b935e1a08f"],
Cell[73457, 1921, 10950, 208, 70, "ExerciseOutput", "ExpressionUUID" -> \
"9126b460-cc65-4a3b-80f6-558090123a06"]
}, Closed]],
Cell[CellGroupData[{
Cell[84444, 2134, 567, 18, 70, "Subsection", "ExpressionUUID" -> \
"28ae3cb1-8fee-45c0-a368-d6ec8b401a4b"],
Cell[85014, 2154, 813, 26, 70, "Input", "ExpressionUUID" -> \
"129b7de7-fa95-4a88-9442-53a8cecd630a",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[85876, 2186, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"f5e2c203-d16e-4e03-9655-165d76a1b793"],
Cell[86163, 2197, 821, 23, 70, "Exercise", "ExpressionUUID" -> \
"31613e48-22e5-490a-806f-45e37d1f553d",
 CounterAssignments->{{"SectionNumber", 22}, {"ExerciseNumber", 10}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[87009, 2224, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"dfc02f4e-b64e-4675-be60-d6224ba50cd5"],
Cell[87648, 2245, 31111, 538, 70, "ExerciseOutput", "ExpressionUUID" -> \
"33fb19b9-1109-4df7-b057-3e1f71a8e607"]
}, Closed]],
Cell[CellGroupData[{
Cell[118796, 2788, 568, 18, 70, "Subsection", "ExpressionUUID" -> \
"b4aa7d08-0b6a-43e7-b8c7-45813045ee16"],
Cell[119367, 2808, 813, 26, 70, "Input", "ExpressionUUID" -> \
"9e9854eb-ac7d-4b26-9ed4-c447f3c2b253",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[120229, 2840, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"a09027bb-a856-4061-af3d-c48dcb855532"],
Cell[120516, 2851, 554, 13, 70, "Exercise", "ExpressionUUID" -> \
"26f1a9d8-e706-4098-a424-2dd9a83dd12c",
 CounterAssignments->{{"SectionNumber", 22}, {"ExerciseNumber", 11}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[121095, 2868, 656, 20, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"b75e83b6-6422-4f6b-8f1b-37e5bbd21c6b"],
Cell[121754, 2890, 44536, 759, 70, "ExerciseOutput", "ExpressionUUID" -> \
"168f4c7b-6245-439b-82d3-b15d8b7347de"]
}, Closed]],
Cell[CellGroupData[{
Cell[166327, 3654, 568, 18, 70, "Subsection", "ExpressionUUID" -> \
"a5605ebd-0f1d-49f0-b9cc-645b3a2d95d4"],
Cell[166898, 3674, 813, 26, 70, "Input", "ExpressionUUID" -> \
"081e55f7-5c41-4385-bc1a-b6fcbd96f341",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[167760, 3706, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"e3c3ad09-72ce-4fa4-a3d3-bd3425397351"],
Cell[168047, 3717, 444, 9, 70, "Exercise", "ExpressionUUID" -> \
"dcd9ae84-b72c-4a6b-a2ee-a12d87585112",
 CounterAssignments->{{"SectionNumber", 22}, {"ExerciseNumber", 12}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[168516, 3730, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"69f1d7df-b046-45db-afe1-5839c848267f"],
Cell[169155, 3751, 273636, 4514, 70, "ExerciseOutput", "ExpressionUUID" -> \
"ce458a41-4368-4fde-8e8c-db5ebde48176"]
}, Closed]],
Cell[CellGroupData[{
Cell[442828, 8270, 568, 18, 70, "Subsection", "ExpressionUUID" -> \
"f12a1acd-6140-4a73-8331-8a8b960c1daf"],
Cell[443399, 8290, 813, 26, 70, "Input", "ExpressionUUID" -> \
"29720589-595b-496a-831e-a07e457256be",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[444261, 8322, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"de12e976-5ebf-4b0e-91e9-11c7b6eeebb6"],
Cell[444548, 8333, 516, 12, 70, "Exercise", "ExpressionUUID" -> \
"382ab264-ee7c-4061-815a-1abc826099ca",
 CounterAssignments->{{"SectionNumber", 22}, {"ExerciseNumber", 13}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[445089, 8349, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"cb02ca02-c9a4-4a3f-bdc8-05aaaaed41ea"],
Cell[445728, 8370, 43629, 744, 70, "ExerciseOutput", "ExpressionUUID" -> \
"dac54562-cd42-41e4-bc58-01875dc4566e"]
}, Closed]],
Cell[CellGroupData[{
Cell[489394, 9119, 568, 18, 70, "Subsection", "ExpressionUUID" -> \
"2ac90c9e-efc6-4d7a-a4d2-58ffc7de2b1b"],
Cell[489965, 9139, 813, 26, 70, "Input", "ExpressionUUID" -> \
"d413052c-2016-46de-a378-1226e652b748",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[490827, 9171, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"38157209-f401-4727-9fff-09f57de22551"],
Cell[491114, 9182, 627, 15, 70, "Exercise", "ExpressionUUID" -> \
"f9dc6978-a6d7-497f-bbb9-76ea308fd9e5",
 CounterAssignments->{{"SectionNumber", 22}, {"ExerciseNumber", 14}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[491766, 9201, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"b3201f7a-ba82-48a5-ba5f-e9d2b5a73c8d"],
Cell[492405, 9222, 5025, 111, 70, "ExerciseOutput", "ExpressionUUID" -> \
"9016cc58-9e16-48e3-8831-b532ad89b547"]
}, Closed]],
Cell[CellGroupData[{
Cell[497467, 9338, 568, 18, 70, "Subsection", "ExpressionUUID" -> \
"fe456a21-2636-4ef7-a0ac-aa2ae02c71e1"],
Cell[498038, 9358, 813, 26, 70, "Input", "ExpressionUUID" -> \
"f316bdc8-a711-4fcb-a6d8-dfdeda738e21",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[498900, 9390, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"d81f8583-61ea-4807-8b56-516e85409e4b"],
Cell[499187, 9401, 464, 11, 70, "Exercise", "ExpressionUUID" -> \
"c2461380-f09a-49c7-b45d-ff2cb9524d50",
 CounterAssignments->{{"SectionNumber", 22}, {"ExerciseNumber", 15}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[499676, 9416, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"0fe77d9a-b83d-4ba9-a9a8-63b440022eba"],
Cell[500315, 9437, 12771, 238, 70, "ExerciseOutput", "ExpressionUUID" -> \
"44d12ba6-dbd4-4a22-b783-1d9ecb1d2cb4"]
}, Closed]],
Cell[CellGroupData[{
Cell[513123, 9680, 568, 18, 70, "Subsection", "ExpressionUUID" -> \
"15c1d2a3-298f-4de5-b6e4-38ef4557dd51"],
Cell[513694, 9700, 813, 26, 70, "Input", "ExpressionUUID" -> \
"207f67bf-e042-4a05-81a9-fc6e6c3f2e85",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[514556, 9732, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" -> \
"06ec0a46-e17e-4ddc-bc99-67dc4bf1fb2b"],
Cell[514843, 9743, 463, 11, 70, "Exercise", "ExpressionUUID" -> \
"08675f8e-c120-4483-bbe9-401a05ac9b40",
 CounterAssignments->{{"SectionNumber", 22}, {"ExerciseNumber", 16}, {
   "WebOnly", 0}}],
Cell[CellGroupData[{
Cell[515331, 9758, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" -> \
"0493db1c-1034-4655-82dd-ec0ca6ce8468"],
Cell[515970, 9779, 13861, 256, 70, "ExerciseOutput", "ExpressionUUID" -> \
"41da65a5-2086-4b75-b78b-6bf2c76a7527"]
}, Closed]],
Cell[CellGroupData[{
Cell[529868, 10040, 568, 18, 70, "Subsection", "ExpressionUUID" -> \
"a96a3bd4-8a7a-4e66-9552-f4b16e3d1a40"],
Cell[530439, 10060, 813, 26, 70, "Input", "ExpressionUUID" -> \
"7e74f3df-89d9-41c4-8562-8d1f86bc6a4c",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[531301, 10092, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" \
-> "028cdb3c-54c1-4d7b-ab69-d6419c76d4f3"],
Cell[531588, 10103, 502, 12, 70, "Exercise", "ExpressionUUID" -> \
"73a46b76-e5ff-4e80-b2e4-064497e37730",
 CounterAssignments->{{"SectionNumber", 22}, {"ExerciseNumber", 1}, {
   "WebOnly", 1}}],
Cell[CellGroupData[{
Cell[532115, 10119, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" \
-> "ea7d6159-8250-436a-8529-08b060985987"],
Cell[532754, 10140, 10224, 196, 70, "ExerciseOutput", "ExpressionUUID" -> \
"ccc6560f-7635-4869-8f21-0e12c8f16858"]
}, Closed]],
Cell[CellGroupData[{
Cell[543015, 10341, 568, 18, 70, "Subsection", "ExpressionUUID" -> \
"575b1e58-b6c8-4341-8ff4-e14a012bdab5"],
Cell[543586, 10361, 813, 26, 70, "Input", "ExpressionUUID" -> \
"1ba8ffff-2f47-49d6-a722-5ce2e391bf04",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[544448, 10393, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" \
-> "9fc6c7f2-78a4-4906-938a-31c3512f54cd"],
Cell[544735, 10404, 504, 12, 70, "Exercise", "ExpressionUUID" -> \
"b2c6597e-74e0-402c-9220-b1975af4d64c",
 CounterAssignments->{{"SectionNumber", 22}, {"ExerciseNumber", 2}, {
   "WebOnly", 1}}],
Cell[CellGroupData[{
Cell[545264, 10420, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" \
-> "9894275c-42a8-47e6-b05d-b168983c5a53"],
Cell[545903, 10441, 4461, 102, 70, "ExerciseOutput", "ExpressionUUID" -> \
"dc75c35b-c6a1-4673-9292-f702d35a3f0f"]
}, Closed]],
Cell[CellGroupData[{
Cell[550401, 10548, 568, 18, 70, "Subsection", "ExpressionUUID" -> \
"f7ca98c6-c125-4a17-90e8-a023de841e2c"],
Cell[550972, 10568, 813, 26, 70, "Input", "ExpressionUUID" -> \
"db4cd4b7-4789-4589-af1a-56c3e8077bc0",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[551834, 10600, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" \
-> "4ff4d96d-2a24-45f5-8cc8-374d1df700c0"],
Cell[552121, 10611, 876, 26, 70, "Exercise", "ExpressionUUID" -> \
"715dd43f-d66f-4d29-9bb3-4f39f9183954",
 CounterAssignments->{{"SectionNumber", 22}, {"ExerciseNumber", 3}, {
   "WebOnly", 1}}],
Cell[CellGroupData[{
Cell[553022, 10641, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" \
-> "a91ec503-1ce6-49b3-94d0-de32c6bdf290"],
Cell[553661, 10662, 3891, 92, 70, "ExerciseOutput", "ExpressionUUID" -> \
"4428107d-167f-43ed-9449-730b9c9fa176"]
}, Closed]],
Cell[CellGroupData[{
Cell[557589, 10759, 568, 18, 70, "Subsection", "ExpressionUUID" -> \
"368a4e9b-cb5e-4842-9fe4-60110d832b73"],
Cell[558160, 10779, 813, 26, 70, "Input", "ExpressionUUID" -> \
"e8a6faba-fdbd-458c-91a6-fd3dbea1db56",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[559022, 10811, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" \
-> "9b57dd9a-687c-4a89-bc2e-2e203398bc4f"],
Cell[559309, 10822, 800, 21, 70, "Exercise", "ExpressionUUID" -> \
"3272802d-3c9a-41b3-8e6a-fe3e1c8fbcf0",
 CounterAssignments->{{"SectionNumber", 22}, {"ExerciseNumber", 4}, {
   "WebOnly", 1}}],
Cell[CellGroupData[{
Cell[560134, 10847, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" \
-> "319ea650-5313-43e7-b295-2adc14cbcb71"],
Cell[560773, 10868, 11194, 212, 70, "ExerciseOutput", "ExpressionUUID" -> \
"ac0d37bb-db63-41b2-8e91-a6ffe0e85463"]
}, Closed]],
Cell[CellGroupData[{
Cell[572004, 11085, 568, 18, 70, "Subsection", "ExpressionUUID" -> \
"7f9a39ee-e243-40e0-a163-c0d32ec70d0a"],
Cell[572575, 11105, 813, 26, 70, "Input", "ExpressionUUID" -> \
"6df2ea12-a214-4f52-9f7d-e4090bede2a3",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[573437, 11137, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" \
-> "e6adbfad-9d07-441a-b7de-3433e436771a"],
Cell[573724, 11148, 551, 13, 70, "Exercise", "ExpressionUUID" -> \
"860343bb-19f7-4b7a-9f83-9ecc31334957",
 CounterAssignments->{{"SectionNumber", 22}, {"ExerciseNumber", 5}, {
   "WebOnly", 1}}],
Cell[CellGroupData[{
Cell[574300, 11165, 656, 20, 70, "ExerciseExpectedResult", "ExpressionUUID" \
-> "9847e390-5cba-4d76-9343-3c65793f4474"],
Cell[574959, 11187, 24231, 426, 70, "ExerciseOutput", "ExpressionUUID" -> \
"c884e48a-9349-423f-8953-38016bc5456d"]
}, Closed]],
Cell[CellGroupData[{
Cell[599227, 11618, 568, 18, 70, "Subsection", "ExpressionUUID" -> \
"af5c5df9-7010-4b3c-bed9-a65c8973f88f"],
Cell[599798, 11638, 813, 26, 70, "Input", "ExpressionUUID" -> \
"2b55e5db-cee2-4f16-9702-769aa968bbcc",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[600660, 11670, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" \
-> "a19a4c2a-13ed-4d6b-bd97-11cc1d995682"],
Cell[600947, 11681, 505, 12, 70, "Exercise", "ExpressionUUID" -> \
"51bb6898-761a-4f24-a18f-cfff3a434fc6",
 CounterAssignments->{{"SectionNumber", 22}, {"ExerciseNumber", 6}, {
   "WebOnly", 1}}],
Cell[CellGroupData[{
Cell[601477, 11697, 656, 20, 70, "ExerciseExpectedResult", "ExpressionUUID" \
-> "4191781a-c2ef-48f0-85a9-6bb35c096ae6"],
Cell[602136, 11719, 13992, 258, 70, "ExerciseOutput", "ExpressionUUID" -> \
"5426a1cc-f56e-425b-8826-3e5aa5158e84"]
}, Closed]],
Cell[CellGroupData[{
Cell[616165, 11982, 568, 18, 70, "Subsection", "ExpressionUUID" -> \
"64bfdfe9-5276-4501-97de-6a09548db0de"],
Cell[616736, 12002, 813, 26, 70, "Input", "ExpressionUUID" -> \
"fdb4927f-8978-440c-96d7-58a656981d2e",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[617598, 12034, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" \
-> "9c469721-8452-45ad-93f9-596f338f9996"],
Cell[617885, 12045, 475, 12, 70, "Exercise", "ExpressionUUID" -> \
"11c2f1b6-03e8-459a-a635-962e08c35037",
 CounterAssignments->{{"SectionNumber", 22}, {"ExerciseNumber", 7}, {
   "WebOnly", 1}}],
Cell[CellGroupData[{
Cell[618385, 12061, 636, 19, 70, "ExerciseExpectedResult", "ExpressionUUID" \
-> "a9d18c61-0ed5-4fa5-bc5b-3a64dc5b93c4"],
Cell[619024, 12082, 17895, 322, 70, "ExerciseOutput", "ExpressionUUID" -> \
"c40b514d-ff82-4be2-9974-3a296f360b79"]
}, Closed]],
Cell[CellGroupData[{
Cell[636956, 12409, 568, 18, 70, "Subsection", "ExpressionUUID" -> \
"05e1bee9-5353-432f-81e4-30d12add8089"],
Cell[637527, 12429, 813, 26, 70, "Input", "ExpressionUUID" -> \
"0a1b697e-06bd-4bbb-96cf-4eccc0d13a7c",
 CellTags->"FirstInputCell"]
}, Open  ]]
}, Open  ]],
Cell[638367, 12459, 284, 9, 70, "CodeSectionDividerCloud", "ExpressionUUID" \
-> "c610d1d6-3335-44c5-b441-21bd7ca7fec8"]
}
]
*)

(* End of internal cache information *)
(* NotebookSignature ESGj6CXH#gz6kluA6c6e0SD3 *)
