(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    817179,      16129]
NotebookOptionsPosition[    706366,      13911]
NotebookOutlinePosition[    802738,      15884]
CellTagsIndexPosition[    801932,      15851]
WindowTitle->Graphs and Networks: Elementary Introduction to the Wolfram \
Language
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
 InterpretationBox[Cell[
  "Graphs and Networks", "SectionInline",ExpressionUUID->
   "675a850e-1541-4c65-b61b-4fa5dfe9bea2"],
  $Line = 0; Null]], "SectionDoubleDigit",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CounterAssignments->{{"Section", 20}, {"Subsection", 0}, {
   "Subsubsection", 0}, {"Exercise", 0}, {"Question", 0}},
 CellTags->"p:115",
 CellLabel->"In[11]:=",ExpressionUUID->"81328702-d886-480a-a64e-619cfa227ee7"],

Cell[TextData[{
 "A ",
 StyleBox["graph",
  FontSlant->"Italic"],
 " is a way of showing connections between things\[LongDash]say, how webpages \
are linked, or how people form a social network. "
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:1",ExpressionUUID->"ff4922e1-7678-43a5-9368-2588d7cc805b"],

Cell[TextData[{
 "Let\[CloseCurlyQuote]s start with a very simple graph, in which 1 connects \
to 2, 2 to 3 and 3 to 4. Each of the connections is represented by ",
 Cell[BoxData[
  ButtonBox["\[Rule]",
   BaseStyle->"Link",
   ButtonData->"Rule"]], "InlineCodeText",ExpressionUUID->
  "dd7f9b81-eb0c-42ad-919a-d945a87bd521"],
 " (typed as ",
 Cell[BoxData["->"], "InlineCodeText",ExpressionUUID->
  "ae345bda-fecb-4b85-9de8-a7fd37c03ade"],
 ")."
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"213dbfd8-b317-4b65-8830-1ebd08d40e57"],

Cell["A very simple graph of connections: ", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"6593ec6b-93ad-4b3f-b906-2452d1d942e5"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graph", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"1", "\[Rule]", "2"}], ",", 
    RowBox[{"2", "\[Rule]", "3"}], ",", 
    RowBox[{"3", "\[Rule]", "4"}]}], "}"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[1]:=",ExpressionUUID->"96adfee2-c9cd-437a-bab1-91a649875917"],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{1, 2, 3, 4}, {{{1, 2}, {2, 3}, {3, 4}}, Null}]]}, 
    TagBox[
     GraphicsGroupBox[
      GraphicsComplexBox[{{0., 6.123233995736766*^-16}, {1., 
       4.898587196589413*^-16}, {2., 2.4492935982947064`*^-16}, {3., 0.}}, {
        {Hue[0.6, 0.7, 0.5], Opacity[0.7], Arrowheads[Medium], 
         ArrowBox[{{1, 2}, {2, 3}, {3, 4}}, 0.030239520958083826`]}, 
        {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[0.7]}], 
         DiskBox[1, 0.030239520958083826], DiskBox[2, 0.030239520958083826], 
         DiskBox[3, 0.030239520958083826], 
         DiskBox[4, 0.030239520958083826]}}]],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->{
   "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
  FrameTicks->None,
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]]]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[1]=",ExpressionUUID->"32804589-04e0-403a-a286-098169f01efe"]
}, Open  ]],

Cell["Automatically label all the \[OpenCurlyDoubleQuote]vertices\
\[CloseCurlyDoubleQuote]:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:2",ExpressionUUID->"50dc86c9-1be8-4aaf-aa0b-835113745ff5"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graph", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "2"}], ",", 
     RowBox[{"2", "\[Rule]", "3"}], ",", 
     RowBox[{"3", "\[Rule]", "4"}]}], "}"}], ",", 
   RowBox[{"VertexLabels", "\[Rule]", "All"}]}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[2]:=",ExpressionUUID->"e5dfd890-97f5-4ccb-87ff-703fe20a1097"],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{1, 2, 3, 4}, {{{1, 2}, {2, 3}, {3, 4}}, Null}, {
      VertexLabels -> {All}}]]}, 
    TagBox[GraphicsGroupBox[{
       {Hue[0.6, 0.7, 0.5], Opacity[0.7], Arrowheads[Medium], 
        ArrowBox[{{{0., 6.123233995736766*^-16}, {1., 
         4.898587196589413*^-16}}, {{1., 4.898587196589413*^-16}, {2., 
         2.4492935982947064`*^-16}}, {{2., 2.4492935982947064`*^-16}, {3., 
         0.}}}, 0.030239520958083826`]}, 
       {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[
        0.7]}], {DiskBox[{0., 6.123233995736766*^-16}, 0.030239520958083826], 
         InsetBox["1", 
          Offset[{2, 2}, {0.030239520958083826, 0.030239520958084437}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1., 4.898587196589413*^-16}, 0.030239520958083826], 
         InsetBox["2", 
          Offset[{2, 2}, {1.030239520958084, 0.030239520958084316}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{2., 2.4492935982947064*^-16}, 0.030239520958083826], 
         InsetBox["3", 
          Offset[{2, 2}, {2.0302395209580837, 0.030239520958084073}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {DiskBox[{3., 0.}, 0.030239520958083826], 
         InsetBox["4", 
          Offset[{2, 2}, {3.0302395209580837, 0.030239520958083826}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}}}],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->{
   "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
  FrameTicks->None,
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]]]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[2]=",ExpressionUUID->"ecd10cbe-4710-4dbf-8832-50cf4d3e2a98"]
}, Open  ]],

Cell["\<\
Let\[CloseCurlyQuote]s add one more connection: to connect 4 to 1. Now we \
have a loop. \
\>", "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:3",ExpressionUUID->"90ed244e-c8af-40d2-983a-8b58c5bec411"],

Cell["Add another connection, forming a loop:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:4",ExpressionUUID->"abe4463c-0e1a-424e-9c9a-fd7bb1eef0e7"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graph", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "2"}], ",", 
     RowBox[{"2", "\[Rule]", "3"}], ",", 
     RowBox[{"3", "\[Rule]", "4"}], ",", 
     RowBox[{"4", "\[Rule]", "1"}]}], "}"}], ",", 
   RowBox[{"VertexLabels", "\[Rule]", "All"}]}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[3]:=",ExpressionUUID->"2f876efa-0d7a-4412-91b7-0b16532b3e31"],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{1, 2, 3, 4}, {{{1, 2}, {2, 3}, {3, 4}, {4, 1}}, Null}, {
      VertexLabels -> {All}}]]}, 
    TagBox[GraphicsGroupBox[{
       {Hue[0.6, 0.7, 0.5], Opacity[0.7], Arrowheads[Medium], 
        ArrowBox[{{{-1., 1.0106430996148606`*^-15}, {
         6.049014748177263*^-16, -1.}}, {{6.049014748177263*^-16, -1.}, {
         1., -1.133107779529596*^-15}}, {{
         1., -1.133107779529596*^-15}, {-7.044813998280222*^-16, 
         1.}}, {{-7.044813998280222*^-16, 1.}, {-1., 
         1.0106430996148606`*^-15}}}, 0.02261146496815286]}, 
       {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[
        0.7]}], {DiskBox[{-1., 1.0106430996148606*^-15}, 0.02261146496815286],
          InsetBox["1", 
          Offset[{2, 2}, {-0.9773885350318472, 0.02261146496815387}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{6.049014748177263*^-16, -1.}, 0.02261146496815286], 
         InsetBox["2", 
          Offset[{2, 2}, {0.022611464968153465, -0.9773885350318472}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1., -1.133107779529596*^-15}, 0.02261146496815286], 
         InsetBox["3", 
          Offset[{2, 2}, {1.0226114649681528, 0.022611464968151727}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{-7.044813998280222*^-16, 1.}, 0.02261146496815286], 
         InsetBox["4", 
          Offset[{2, 2}, {0.022611464968152157, 1.0226114649681528}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}}}],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->{
   "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
  FormatType->TraditionalForm,
  FrameTicks->None,
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImageSize->{197.21484375, Automatic}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[3]=",ExpressionUUID->"2907b1cc-55af-4e44-8d4f-2c36a35d8a92"]
}, Open  ]],

Cell["\<\
Add two more connections, including one connecting 2 right back to 2:\
\>", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"b7dba443-da80-42a9-854c-f4e37fce4dfe"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graph", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "2"}], ",", 
     RowBox[{"2", "\[Rule]", "3"}], ",", 
     RowBox[{"3", "\[Rule]", "4"}], ",", 
     RowBox[{"4", "\[Rule]", "1"}], ",", 
     RowBox[{"3", "\[Rule]", "1"}], ",", 
     RowBox[{"2", "\[Rule]", "2"}]}], "}"}], ",", 
   RowBox[{"VertexLabels", "\[Rule]", "All"}]}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[4]:=",ExpressionUUID->"26ff87a0-6198-400c-8897-9cbd4e24c3d8"],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{1, 2, 3, 
      4}, {{{1, 2}, {2, 3}, {3, 4}, {4, 1}, {3, 1}, {2, 2}}, Null}, {
      VertexLabels -> {All}}]]}, 
    TagBox[GraphicsGroupBox[{
       {Hue[0.6, 0.7, 0.5], Opacity[0.7], Arrowheads[Medium], 
        ArrowBox[{{0.9354936772708413, 0.8689270718341167}, {
         1.868133713977325, 0.43483507009715616`}}, 0.021532449762789008`], 
        ArrowBox[BezierCurveBox[{{1.868133713977325, 0.43483507009715616`}, {
         1.9566007845671334`, 0.6256242529634835}, {2.1554756598622813`, 
         0.6820331970032674}, {2.2826500494661484`, 0.6230842403053416}, {
         2.282674091757282, 0.24663884893104518`}, {2.155507232930956, 
         0.18767364831970695`}, {1.9566251539621367`, 0.24405718897107395`}, {
         1.868133713977325, 0.43483507009715616`}},
         SplineDegree->7], 0.021532449762789008`], 
        ArrowBox[{{1.868133713977325, 0.43483507009715616`}, {
         0.9342090487617015, 0.}}, 0.021532449762789008`], 
        ArrowBox[{{0.9342090487617015, 0.}, {0.9354936772708413, 
         0.8689270718341167}}, 0.021532449762789008`], 
        ArrowBox[{{0.9342090487617015, 0.}, {0., 0.435432028024631}}, 
         0.021532449762789008`], 
        ArrowBox[{{0., 0.435432028024631}, {0.9354936772708413, 
         0.8689270718341167}}, 0.021532449762789008`]}, 
       {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[
        0.7]}], {
         DiskBox[{0.9354936772708413, 0.8689270718341167}, 
          0.021532449762789008], 
         InsetBox["1", 
          Offset[{2, 2}, {0.9570261270336303, 0.8904595215969057}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.868133713977325, 0.43483507009715616}, 
          0.021532449762789008], 
         InsetBox["2", 
          Offset[{2, 2}, {1.889666163740114, 0.45636751985994517}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.9342090487617015, 0.}, 0.021532449762789008], 
         InsetBox["3", 
          Offset[{2, 2}, {0.9557414985244905, 0.021532449762789008}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0., 0.435432028024631}, 0.021532449762789008], 
         InsetBox["4", 
          Offset[{2, 2}, {0.021532449762789008, 0.45696447778742}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}}}],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->{
   "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
  FrameTicks->None,
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImageSize->{314.765625, Automatic}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[4]=",ExpressionUUID->"de8abea1-9f16-4a20-954c-ed53471aca32"]
}, Open  ]],

Cell["\<\
As we add connections, the Wolfram Language chooses to place the vertices or \
nodes of the graph differently. All that really matters for the meaning, \
however, is how the vertices are connected. And if you don\[CloseCurlyQuote]t \
specify otherwise, the Wolfram Language will try to lay the graph out so it\
\[CloseCurlyQuote]s as untangled and easy to understand as possible.\
\>", "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->
  "LastCellOfAPage",ExpressionUUID->"c33931ad-8df9-4d7b-900c-a5c5e5956f96"],

Cell["\<\
There are options, though, to specify other layouts. Here\[CloseCurlyQuote]s \
an example. It\[CloseCurlyQuote]s the same graph as before, with the same \
connections, but the vertices are laid out differently.\
\>", "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->{
  "p:116", "i:5"},ExpressionUUID->"e22cb62e-4482-417d-9a70-2ca77e871e88"],

Cell["\<\
A different layout of the same graph (check by tracing the connections):\
\>", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:6",ExpressionUUID->"fe3704ce-ad9d-4d5b-b088-60bc7247d47b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graph", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "2"}], ",", 
     RowBox[{"2", "\[Rule]", "3"}], ",", 
     RowBox[{"3", "\[Rule]", "4"}], ",", 
     RowBox[{"4", "\[Rule]", "1"}], ",", 
     RowBox[{"3", "\[Rule]", "1"}], ",", 
     RowBox[{"2", "\[Rule]", "2"}]}], "}"}], ",", 
   RowBox[{"VertexLabels", "\[Rule]", "All"}], ",", 
   RowBox[{"GraphLayout", "\[Rule]", " ", "\"\<RadialDrawing\>\""}]}], 
  "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[5]:=",ExpressionUUID->"15d94fa9-d725-41a5-9aaa-8455b0241074"],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{1, 2, 3, 
      4}, {{{1, 2}, {2, 3}, {3, 4}, {4, 1}, {3, 1}, {2, 2}}, Null}, {
      GraphLayout -> "RadialDrawing", VertexLabels -> {All}}]]}, 
    TagBox[GraphicsGroupBox[{
       {Hue[0.6, 0.7, 0.5], Opacity[0.7], Arrowheads[Medium], 
        ArrowBox[{{0.6454972243679027, 0.7453559924999299}, {
         1.2909944487358058`, 1.1180339887498942`}}, 0.016586569233993625`], 
        ArrowBox[BezierCurveBox[{{1.2909944487358058`, 1.1180339887498942`}, {
         1.327080435009694, 1.3252168463230622`}, {1.5045858711352822`, 
         1.4311649710691328`}, {1.642682476491016, 1.407130985629494}, {
         1.7401137134184645`, 1.0435126591719759`}, {1.6325355377238244`, 
         0.9536503145491962}, {1.4258372583561942`, 0.9566513639998215}, {
         1.2909944487358058`, 1.1180339887498942`}},
         SplineDegree->7], 0.016586569233993625`], 
        ArrowBox[{{1.2909944487358058`, 1.1180339887498942`}, {0., 
         1.1180339887498951`}}, 0.016586569233993625`], 
        ArrowBox[{{0., 1.1180339887498951`}, {0.6454972243679027, 
         0.7453559924999299}}, 0.016586569233993625`], 
        ArrowBox[{{0., 1.1180339887498951`}, {0.6454972243679026, 0.}}, 
         0.016586569233993625`], 
        ArrowBox[{{0.6454972243679026, 0.}, {0.6454972243679027, 
         0.7453559924999299}}, 0.016586569233993625`]}, 
       {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[
        0.7]}], {
         DiskBox[{0.6454972243679027, 0.7453559924999299}, 
          0.016586569233993625], 
         InsetBox["1", 
          Offset[{2, 2}, {0.6620837936018963, 0.7619425617339235}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.2909944487358058, 1.1180339887498942}, 
          0.016586569233993625], 
         InsetBox["2", 
          Offset[{2, 2}, {1.3075810179697995, 1.134620557983888}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0., 1.1180339887498951}, 0.016586569233993625], 
         InsetBox["3", 
          Offset[{2, 2}, {0.016586569233993625, 1.1346205579838888}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.6454972243679026, 0.}, 0.016586569233993625], 
         InsetBox["4", 
          Offset[{2, 2}, {0.6620837936018962, 0.016586569233993625}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}}}],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->{
   "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
  FrameTicks->None,
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImageSize->{231.37109375, Automatic}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[5]=",ExpressionUUID->"3f379b89-ceaa-497c-a07a-8a9312575955"]
}, Open  ]],

Cell["\<\
You can do computations on the graph, say finding the shortest path that gets \
from 4 to 2, always following the arrows.\
\>", "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:7",ExpressionUUID->"581def16-70d8-44c3-9072-27db580f7e6f"],

Cell["The shortest path from 4 to 2 on the graph goes through 1:", \
"CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"b5c67abe-0a16-4057-9c1a-5e69940715b7"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindShortestPath", "[", 
  RowBox[{
   RowBox[{"Graph", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"1", "\[Rule]", "2"}], ",", 
      RowBox[{"2", "\[Rule]", "3"}], ",", 
      RowBox[{"3", "\[Rule]", "4"}], ",", 
      RowBox[{"4", "\[Rule]", "1"}], ",", 
      RowBox[{"3", "\[Rule]", "1"}], ",", 
      RowBox[{"2", "\[Rule]", "2"}]}], "}"}], "]"}], ",", "4", ",", "2"}], 
  "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[6]:=",ExpressionUUID->"f95c1f12-b3f3-4ab2-a356-4500459e2f4d"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"4", ",", "1", ",", "2"}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[6]=",ExpressionUUID->"85359688-0098-4dfd-b310-abfb5cdb9409"]
}, Open  ]],

Cell["\<\
Now let\[CloseCurlyQuote]s make another graph. This time \
let\[CloseCurlyQuote]s have 3 nodes, and let\[CloseCurlyQuote]s have a \
connection between every one of them. \
\>", "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"3f013417-679e-4ebe-b21f-65379cb1d4c4"],

Cell["\<\
Start by making an array of all possible connections between 3 objects:\
\>", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"75e1fd8f-b9c3-492e-88bf-163c6a5db753"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"i", "\[Rule]", "j"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"j", ",", "3"}], "}"}]}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[7]:=",ExpressionUUID->"d1ee5a13-a890-4531-a943-860d4c4290fe"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "1"}], ",", 
     RowBox[{"1", "\[Rule]", "2"}], ",", 
     RowBox[{"1", "\[Rule]", "3"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"2", "\[Rule]", "1"}], ",", 
     RowBox[{"2", "\[Rule]", "2"}], ",", 
     RowBox[{"2", "\[Rule]", "3"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"3", "\[Rule]", "1"}], ",", 
     RowBox[{"3", "\[Rule]", "2"}], ",", 
     RowBox[{"3", "\[Rule]", "3"}]}], "}"}]}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[7]=",ExpressionUUID->"6abba896-68ce-48a2-8099-29a56c4259d5"]
}, Open  ]],

Cell[TextData[{
 "The result here is a list of lists. But what ",
 ButtonBox["Graph",
  BaseStyle->"Link"],
 " needs is just a single list of ",
 "connections.",
 " We can get that by using ",
 ButtonBox["Flatten",
  BaseStyle->"Link"],
 " to \[OpenCurlyDoubleQuote]flatten\[CloseCurlyDoubleQuote] out the sublists."
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:8",ExpressionUUID->"571c6de3-3f45-4dab-bb16-67745077473b"],

Cell[TextData[{
 ButtonBox["Flatten",
  BaseStyle->"Link"],
 " \[OpenCurlyDoubleQuote]flattens out\[CloseCurlyDoubleQuote] all sublists, \
wherever they appear:"
}], "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"8d48977e-e83a-4fff-8c94-9e5e8f33e501"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Flatten", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a", ",", "b"}], "}"}], ",", "1", ",", "2", ",", "3", ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y", ",", 
      RowBox[{"{", "z", "}"}]}], "}"}]}], "}"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[8]:=",ExpressionUUID->"3fd4b0b9-25f0-4261-ae6c-6c5e5d476d8e"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "a", ",", "b", ",", "1", ",", "2", ",", "3", ",", "x", ",", "y", ",", "z"}],
   "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[8]=",ExpressionUUID->"cd49886e-6e59-4e6a-911d-59d51e6b06cf"]
}, Open  ]],

Cell["Get a \[OpenCurlyDoubleQuote]flattened\[CloseCurlyDoubleQuote] list of \
connections from the array:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"15d4f96d-a8b6-4c01-9618-348414091552"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Flatten", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"i", "\[Rule]", "j"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "3"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"j", ",", "3"}], "}"}]}], "]"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[9]:=",ExpressionUUID->"5bf21a96-4fcf-4093-bc28-7959701f3698"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"1", "\[Rule]", "1"}], ",", 
   RowBox[{"1", "\[Rule]", "2"}], ",", 
   RowBox[{"1", "\[Rule]", "3"}], ",", 
   RowBox[{"2", "\[Rule]", "1"}], ",", 
   RowBox[{"2", "\[Rule]", "2"}], ",", 
   RowBox[{"2", "\[Rule]", "3"}], ",", 
   RowBox[{"3", "\[Rule]", "1"}], ",", 
   RowBox[{"3", "\[Rule]", "2"}], ",", 
   RowBox[{"3", "\[Rule]", "3"}]}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellTags->"LastCellOfAPage",
 CellLabel->"Out[9]=",ExpressionUUID->"662b2a72-edeb-437e-bc03-efb3dcb5e61a"]
}, Open  ]],

Cell["Show the graph of these connections:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"p:117",ExpressionUUID->"d0a78463-0c69-4725-bb52-2613c170905f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graph", "[", 
  RowBox[{
   RowBox[{"Flatten", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"i", "\[Rule]", "j"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "3"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"j", ",", "3"}], "}"}]}], "]"}], "]"}], ",", 
   RowBox[{"VertexLabels", "\[Rule]", "All"}]}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[10]:=",ExpressionUUID->"519027aa-f4a0-493b-9023-15501e6d5793"],

Cell[BoxData[
 GraphicsBox[InsetBox[
   GraphicsBox[
    NamespaceBox["NetworkGraphics",
     DynamicModuleBox[{Typeset`graph = HoldComplete[
       Graph[{1, 2, 
        3}, {{{1, 1}, {1, 2}, {1, 3}, {2, 1}, {2, 2}, {2, 3}, {3, 1}, {3, 
         2}, {3, 3}}, Null}, {VertexLabels -> {All}}]]}, 
      TagBox[GraphicsGroupBox[{
         {Hue[0.6, 0.7, 0.5], Opacity[0.7], Arrowheads[Medium], 
          ArrowBox[BezierCurveBox[{{0.4969222153812606, 0.}, {
           0.6873904251757703, -0.08915602018494104}, {
           0.7430802511242329, -0.2882334630989339}, {
           0.6836720610015965, -0.4151939759099758}, {
           0.30722904122918515`, -0.413857514310497}, {
           0.2487238169004704, -0.2864783810384543}, {
           0.3058257650517279, -0.08780137555297982}, {0.4969222153812606, 
           0.}},
           SplineDegree->7], 0.012729919251096006`], 
          ArrowBox[BezierCurveBox[{{0.4969222153812606, 0.}, {
           0.6063408523521697, 0.514847913886857}, {0.9999936568025142, 
           0.8642449403459487}}], 0.012729919251096006`], 
          ArrowBox[BezierCurveBox[{{0.4969222153812606, 0.}, {
           0.1057602456031444, 0.3521832514257624}, {0., 
           0.8677950236298684}}], 0.012729919251096006`], 
          ArrowBox[BezierCurveBox[{{0.9999936568025142, 0.8642449403459487}, {
           0.8905750198316025, 0.3493970264591557}, {0.4969222153812606, 
           0.}}], 0.012729919251096006`], 
          ArrowBox[BezierCurveBox[{{0.9999936568025142, 0.8642449403459487}, {
           0.981970912857964, 1.0737732572347456`}, {1.126532110476953, 
           1.2215407947194983`}, {1.2661872339094185`, 1.233572060901945}, {
           1.4532513612710862`, 0.9068946274612545}, {1.3721904176215585`, 
           0.7925380435601159}, {1.1715801137970816`, 0.7426512618359438}, {
           0.9999936568025142, 0.8642449403459487}},
           SplineDegree->7], 0.012729919251096006`], 
          ArrowBox[BezierCurveBox[{{0.9999936568025142, 0.8642449403459487}, {
           0.4994130500534916, 0.7015802778846691}, {0., 
           0.8677950236298684}}], 0.012729919251096006`], 
          ArrowBox[BezierCurveBox[{{0., 0.8677950236298684}, {
           0.3911619697781157, 0.5156117722041118}, {0.4969222153812606, 
           0.}}], 0.012729919251096006`], 
          ArrowBox[BezierCurveBox[{{0., 0.8677950236298684}, {
           0.5005806067490268, 1.0304596860909105`}, {0.9999936568025142, 
           0.8642449403459487}}], 0.012729919251096006`], 
          ArrowBox[BezierCurveBox[{{0., 
           0.8677950236298684}, {-0.1724454776055367, 
           0.747422717300957}, {-0.37269651588156283`, 
           0.7987326253180023}, {-0.4529434556078141, 
           0.9136618797811782}, {-0.26356455135602697`, 
           1.2390028761056062`}, {-0.12399837325238695`, 1.22598032656901}, {
           0.019509993581533297`, 1.0771900928841167`}, {0., 
           0.8677950236298684}},
           SplineDegree->7], 0.012729919251096006`]}, 
         {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[
          0.7]}], {DiskBox[{0.4969222153812606, 0.}, 0.012729919251096006], 
           InsetBox["1", 
            Offset[{2, 2}, {0.5096521346323566, 0.012729919251096006}], 
            ImageScaled[{0, 0}],
            BaseStyle->"Graphics"]}, {
           DiskBox[{0.9999936568025142, 0.8642449403459487}, 
            0.012729919251096006], 
           InsetBox["2", 
            Offset[{2, 2}, {1.0127235760536102, 0.8769748595970447}], 
            ImageScaled[{0, 0}],
            BaseStyle->"Graphics"]}, {
           DiskBox[{0., 0.8677950236298684}, 0.012729919251096006], 
           InsetBox["3", 
            Offset[{2, 2}, {0.012729919251096006, 0.8805249428809644}], 
            ImageScaled[{0, 0}],
            BaseStyle->"Graphics"]}}}],
       MouseAppearanceTag["NetworkGraphics"]],
      AllowKernelInitialization->False]],
    Background->None,
    DefaultBaseStyle->{
     "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
    
    FrameTicks->None,
    GridLinesStyle->Directive[
      GrayLevel[0.5, 0.4]],
    ImageMargins->0.,
    ImageSize->{251.3984375, Automatic}], {-0.19921875, -0.10967916790785637},
    ImageScaled[{0., 0.}], {251., 219.},
   ContentSelectable->True],
  AspectRatio->0.8896716182400267,
  Background->None,
  ContentSelectable->True,
  ImageMargins->0.,
  ImagePadding->0.,
  ImageSize->{220.046875, 195.},
  PlotRange->{{12.38658752602629, 237.1391901550701}, {8.209624289132648, 
   208.16563597377183`}},
  PlotRangePadding->None]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[10]=",ExpressionUUID->"8e802e04-56ab-4d1f-978e-5188fa2c935d"]
}, Open  ]],

Cell["Generate the completely connected graph with 6 nodes:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:9",ExpressionUUID->"d2a81e48-6e99-4bfe-99ed-1df4729db166"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graph", "[", 
  RowBox[{"Flatten", "[", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"i", "\[Rule]", "j"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "6"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "6"}], "}"}]}], "]"}], "]"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[11]:=",ExpressionUUID->"db10238b-4115-46ce-bd6e-06fd845cf578"],

Cell[BoxData[
 GraphicsBox[InsetBox[
   GraphicsBox[
    NamespaceBox["NetworkGraphics",
     DynamicModuleBox[{Typeset`graph = HoldComplete[
       Graph[{1, 2, 3, 4, 5, 
        6}, {{{1, 1}, {1, 2}, {1, 3}, {1, 4}, {1, 5}, {1, 6}, {2, 1}, {2, 
         2}, {2, 3}, {2, 4}, {2, 5}, {2, 6}, {3, 1}, {3, 2}, {3, 3}, {3, 4}, {
         3, 5}, {3, 6}, {4, 1}, {4, 2}, {4, 3}, {4, 4}, {4, 5}, {4, 6}, {5, 
         1}, {5, 2}, {5, 3}, {5, 4}, {5, 5}, {5, 6}, {6, 1}, {6, 2}, {6, 3}, {
         6, 4}, {6, 5}, {6, 6}}, Null}]]}, 
      TagBox[GraphicsGroupBox[GraphicsComplexBox[CompressedData["
1:eJw9l3k0VV/cxiWkSBLRSEUDJVRS4lGplFIkIREhlSSpVPpFUpSZTEnmqcxj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         "], {
          {Hue[0.6, 0.7, 0.5], Opacity[0.7], Arrowheads[Medium], 
           ArrowBox[BezierCurveBox[{1, 10, 13, 15, 21, 23, 26, 1},
            SplineDegree->7], 0.016581374985794817`], 
           ArrowBox[BezierCurveBox[{
            1, {0.5728652130059795, 0.6854302304429063}, 2}], 
            0.016581374985794817`], 
           ArrowBox[BezierCurveBox[{
            1, {1.1507451690785873`, 0.5756897944495608}, 3}], 
            0.016581374985794817`], 
           ArrowBox[BezierCurveBox[{
            1, {1.2141035578818684`, 0.909688643363438}, 4}], 
            0.016581374985794817`], 
           ArrowBox[BezierCurveBox[{
            1, {0.6355323269323422, 1.0184416279791}, 5}], 
            0.016581374985794817`], 
           ArrowBox[BezierCurveBox[{
            1, {0.8300849027164697, 0.46298061068486945`}, 6}], 
            0.016581374985794817`], 
           ArrowBox[BezierCurveBox[{
            2, {0.383112637089971, 0.999833654363482}, 1}], 
            0.016581374985794817`], 
           ArrowBox[BezierCurveBox[{2, 129, 132, 134, 140, 142, 145, 2},
            SplineDegree->7], 0.016581374985794817`], 
           ArrowBox[BezierCurveBox[{
            2, {0.5778799560725998, 0.44440982050411315`}, 3}], 
            0.016581374985794817`], 
           ArrowBox[BezierCurveBox[{
            2, {0.6412383448758822, 0.7784086694177904}, 4}], 
            0.016581374985794817`], 
           ArrowBox[BezierCurveBox[{
            2, {0.06266711392635452, 0.8871616540323694}, 5}], 
            0.016581374985794817`], 
           ArrowBox[BezierCurveBox[{
            2, {0.25721968971048365`, 0.3317006367392613}, 6}], 
            0.016581374985794817`], 
           ArrowBox[BezierCurveBox[{
            3, {0.7830461240517357, 0.5685084720136794}, 1}], 
            0.016581374985794817`], 
           ArrowBox[BezierCurveBox[{
            3, {0.39993348696176567`, 0.122825074147577}, 2}], 
            0.016581374985794817`], 
           ArrowBox[BezierCurveBox[{3, 248, 251, 253, 259, 261, 264, 3},
            SplineDegree->7], 0.016581374985794817`], 
           ArrowBox[BezierCurveBox[{
            3, {1.041171831837647, 0.34708348706790887`}, 4}], 
            0.016581374985794817`], 
           ArrowBox[BezierCurveBox[{
            3, {0.4626006008881211, 0.4558364716828036}, 5}], 
            0.016581374985794817`], 
           ArrowBox[BezierCurveBox[{
            3, {0.6571531766722517, -0.09962454561049204}, 6}], 
            0.016581374985794817`], 
           ArrowBox[BezierCurveBox[{
            4, {1.0322851121956158`, 0.7996998284621032}, 1}], 
            0.016581374985794817`], 
           ArrowBox[BezierCurveBox[{
            4, {0.6491724751056555, 0.3540164305958811}, 2}], 
            0.016581374985794817`], 
           ArrowBox[BezierCurveBox[{
            4, {1.2270524311782516`, 0.24427599460260926`}, 3}], 
            0.016581374985794817`], 
           ArrowBox[BezierCurveBox[{4, 367, 370, 372, 378, 380, 383, 4},
            SplineDegree->7], 0.016581374985794817`], 
           ArrowBox[BezierCurveBox[{
            4, {0.7118395890320042, 0.6870278281311317}, 5}], 
            0.016581374985794817`], 
           ArrowBox[BezierCurveBox[{
            4, {0.9063921648161363, 0.1315668108378182}, 6}], 
            0.016581374985794817`], 
           ArrowBox[BezierCurveBox[{
            5, {0.6312091819165198, 1.2306406354150765`}, 1}], 
            0.016581374985794817`], 
           ArrowBox[BezierCurveBox[{
            5, {0.24809654482655216`, 0.784957237547265}, 2}], 
            0.016581374985794817`], 
           ArrowBox[BezierCurveBox[{
            5, {0.8259765008991578, 0.6752168015538844}, 3}], 
            0.016581374985794817`], 
           ArrowBox[BezierCurveBox[{
            5, {0.8893348897024336, 1.0092156504674905`}, 4}], 
            0.016581374985794817`], 
           ArrowBox[BezierCurveBox[{5, 486, 489, 491, 497, 499, 502, 5},
            SplineDegree->7], 0.016581374985794817`], 
           ArrowBox[BezierCurveBox[{
            5, {0.5053162345370379, 0.562507617789114}, 6}], 
            0.016581374985794817`], 
           ArrowBox[BezierCurveBox[{
            6, {0.45808256234017913`, 0.6681330176242328}, 1}], 
            0.016581374985794817`], 
           ArrowBox[BezierCurveBox[{
            6, {0.07496992525021023, 0.22244961975803013`}, 2}], 
            0.016581374985794817`], 
           ArrowBox[BezierCurveBox[{
            6, {0.6528498813228114, 0.11270918376482722`}, 3}], 
            0.016581374985794817`], 
           ArrowBox[BezierCurveBox[{
            6, {0.7162082701260942, 0.44670803267850195`}, 4}], 
            0.016581374985794817`], 
           ArrowBox[BezierCurveBox[{
            6, {0.13763703917656456`, 0.5554610172932668}, 5}], 
            0.016581374985794817`], 
           ArrowBox[BezierCurveBox[{6, 605, 608, 610, 616, 618, 621, 6},
            SplineDegree->7], 0.016581374985794817`]}, 
          {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[0.7]}], 
           DiskBox[1, 0.016581374985794817], DiskBox[2, 0.016581374985794817],
            DiskBox[3, 0.016581374985794817], 
           DiskBox[4, 0.016581374985794817], DiskBox[5, 0.016581374985794817],
            DiskBox[6, 0.016581374985794817]}}]],
       MouseAppearanceTag["NetworkGraphics"]],
      AllowKernelInitialization->False]],
    Background->None,
    DefaultBaseStyle->{
     "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
    
    FrameTicks->None,
    GridLinesStyle->Directive[
      GrayLevel[0.5, 0.4]],
    ImageMargins->0.,
    ImageSize->{242.78515625, Automatic}], {0.107421875, 0.0778810910664447}, 
   ImageScaled[{0., 0.}], {243., 233.},
   ContentSelectable->True],
  AspectRatio->0.8636063892145369,
  Background->None,
  ContentSelectable->True,
  ImageMargins->0.,
  ImagePadding->0.,
  ImageSize->{214.59375, 185.},
  PlotRange->{{3.8549707978697256`, 235.80262090984598`}, {
   13.398149769708937`, 218.81697371043612`}},
  PlotRangePadding->None]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[11]=",ExpressionUUID->"e87a60a1-8d6d-42d1-b3b0-505f6f9614a2"]
}, Open  ]],

Cell["\<\
Sometimes the \[OpenCurlyDoubleQuote]direction\[CloseCurlyDoubleQuote] of a \
connection doesn\[CloseCurlyQuote]t matter, so we can drop the arrows. \
\>", "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:10",ExpressionUUID->"4b1958e1-1ef6-4075-aa0f-4aa0ad1223f4"],

Cell["The \[OpenCurlyDoubleQuote]undirected\[CloseCurlyDoubleQuote] version \
of the graph:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:11",ExpressionUUID->"abe9b686-97f8-4a6e-a032-8cc12aa1f3e7"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UndirectedGraph", "[", 
  RowBox[{"Flatten", "[", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"i", "\[Rule]", "j"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "6"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "6"}], "}"}]}], "]"}], "]"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[12]:=",ExpressionUUID->"2975aaa3-6bd8-4996-8b59-c1351bd92f4d"],

Cell[BoxData[
 GraphicsBox[InsetBox[
   GraphicsBox[
    NamespaceBox["NetworkGraphics",
     DynamicModuleBox[{Typeset`graph = HoldComplete[
       Graph[{1, 2, 3, 4, 5, 6}, {
        Null, SparseArray[
         Automatic, {6, 6}, 0, {
          1, {{0, 6, 11, 15, 18, 20, 21}, {{1}, {2}, {3}, {4}, {5}, {6}, {
            2}, {3}, {4}, {5}, {6}, {3}, {4}, {5}, {6}, {4}, {5}, {6}, {5}, {
            6}, {6}}}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
           1, 1, 1}}]}]]}, 
      TagBox[GraphicsGroupBox[GraphicsComplexBox[CompressedData["
1:eJw9lXk0FfoWxzm3kIR0CuUWN0OpXOUayvCVNOklKUpJUujJ1HDdlEJFdBHl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         "], {
          {Hue[0.6, 0.7, 0.5], Opacity[0.7], 
           {Arrowheads[0.], 
            ArrowBox[BezierCurveBox[{1, 10, 13, 15, 21, 23, 26, 1},
             SplineDegree->7], 0.016581374985794817`]}, 
           {Arrowheads[0.], ArrowBox[{1, 2}, 0.016581374985794817`]}, 
           {Arrowheads[0.], ArrowBox[{1, 3}, 0.016581374985794817`]}, 
           {Arrowheads[0.], ArrowBox[{1, 4}, 0.016581374985794817`]}, 
           {Arrowheads[0.], ArrowBox[{1, 5}, 0.016581374985794817`]}, 
           {Arrowheads[0.], ArrowBox[{1, 6}, 0.016581374985794817`]}, 
           {Arrowheads[0.], 
            ArrowBox[BezierCurveBox[{2, 33, 36, 38, 44, 46, 49, 2},
             SplineDegree->7], 0.016581374985794817`]}, 
           {Arrowheads[0.], ArrowBox[{2, 3}, 0.016581374985794817`]}, 
           {Arrowheads[0.], ArrowBox[{2, 4}, 0.016581374985794817`]}, 
           {Arrowheads[0.], ArrowBox[{2, 5}, 0.016581374985794817`]}, 
           {Arrowheads[0.], ArrowBox[{2, 6}, 0.016581374985794817`]}, 
           {Arrowheads[0.], 
            ArrowBox[BezierCurveBox[{3, 56, 59, 61, 67, 69, 72, 3},
             SplineDegree->7], 0.016581374985794817`]}, 
           {Arrowheads[0.], ArrowBox[{3, 4}, 0.016581374985794817`]}, 
           {Arrowheads[0.], ArrowBox[{3, 5}, 0.016581374985794817`]}, 
           {Arrowheads[0.], ArrowBox[{3, 6}, 0.016581374985794817`]}, 
           {Arrowheads[0.], 
            ArrowBox[BezierCurveBox[{4, 79, 82, 84, 90, 92, 95, 4},
             SplineDegree->7], 0.016581374985794817`]}, 
           {Arrowheads[0.], ArrowBox[{4, 5}, 0.016581374985794817`]}, 
           {Arrowheads[0.], ArrowBox[{4, 6}, 0.016581374985794817`]}, 
           {Arrowheads[0.], 
            ArrowBox[BezierCurveBox[{5, 102, 105, 107, 113, 115, 118, 5},
             SplineDegree->7], 0.016581374985794817`]}, 
           {Arrowheads[0.], ArrowBox[{5, 6}, 0.016581374985794817`]}, 
           {Arrowheads[0.], 
            ArrowBox[BezierCurveBox[{6, 125, 128, 130, 136, 138, 141, 6},
             SplineDegree->7], 0.016581374985794817`]}}, 
          {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[0.7]}], 
           DiskBox[1, 0.016581374985794817], DiskBox[2, 0.016581374985794817],
            DiskBox[3, 0.016581374985794817], 
           DiskBox[4, 0.016581374985794817], DiskBox[5, 0.016581374985794817],
            DiskBox[6, 0.016581374985794817]}}]],
       MouseAppearanceTag["NetworkGraphics"]],
      AllowKernelInitialization->False]],
    Background->None,
    DefaultBaseStyle->{
     "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
    
    FrameTicks->None,
    GridLinesStyle->Directive[
      GrayLevel[0.5, 0.4]],
    ImageMargins->0.,
    ImageSize->{247.35546875, Automatic}], {-0.177734375, -0.11332169943153758},
    ImageScaled[{0., 0.}], {247., 237.},
   ContentSelectable->True],
  AspectRatio->0.8997428413448796,
  Background->None,
  ContentSelectable->True,
  ImageMargins->0.,
  ImagePadding->0.,
  ImageSize->{219.72265625, 197.},
  PlotRange->{{4.548142065284367, 247.}, {6.432149455963867, 
   224.57647300349007`}},
  PlotRangePadding->None]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellTags->"LastCellOfAPage",
 CellLabel->"Out[12]=",ExpressionUUID->"7cb41b6d-2d86-4b63-8da0-0feed542e102"]
}, Open  ]],

Cell["\<\
Now let\[CloseCurlyQuote]s make a graph with random connections. Here is an \
example with 20 connections between randomly chosen nodes.\
\>", "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->{
  "p:118", "i:12"},ExpressionUUID->"ba8749b6-394d-42c5-a979-0bdca355932e"],

Cell["\<\
Make a graph with 20 connections between randomly chosen nodes numbered from \
0 to 10:\
\>", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"e1f7c7dd-549f-490d-bd66-0d94c38613ac"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graph", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"RandomInteger", "[", "10", "]"}], "\[Rule]", 
      RowBox[{"RandomInteger", "[", "10", "]"}]}], ",", "20"}], "]"}], ",", 
   RowBox[{"VertexLabels", "\[Rule]", "All"}]}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[13]:=",ExpressionUUID->"29e446ff-3bd2-4ce3-a0c0-77cb1698b9c3"],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{7, 6, 10, 8, 1, 4, 9, 3, 0, 5, 
      2}, {{{1, 2}, {3, 4}, {5, 2}, {4, 6}, {1, 7}, {8, 6}, {9, 2}, {3, 3}, {
       1, 10}, {4, 1}, {3, 4}, {8, 2}, {8, 3}, {3, 8}, {8, 6}, {5, 7}, {11, 
       4}, {10, 5}, {9, 1}, {11, 7}}, Null}, {VertexLabels -> {"Name"}}]]}, 
    TagBox[GraphicsGroupBox[{
       {Hue[0.6, 0.7, 0.5], Opacity[0.7], Arrowheads[0.027646746410537347`], 
        ArrowBox[{{2.171607508894414, 1.3426397542556134`}, {
         1.8487811710313142`, 1.9337032191429815`}}, 0.03264325246390193], 
        ArrowBox[{{2.171607508894414, 1.3426397542556134`}, {
         2.3014649116538033`, 0.390178905822978}}, 0.03264325246390193], 
        ArrowBox[{{2.171607508894414, 1.3426397542556134`}, {
         3.3420537548112836`, 1.3541733260727544`}}, 0.03264325246390193], 
        ArrowBox[BezierCurveBox[{{0.05234468737908404, 1.094154904829825}, {
         0.04253914112143717, 0.8840816172844255}, {-0.12027021105790353`, 
         0.7566991230621519}, {-0.26029104134611736`, 
         0.7632161739511092}, {-0.4025755678335735, 
         1.1117362548463416`}, {-0.3071225830372824, 
         1.2143863038495888`}, {-0.10168121664457855`, 1.2373434370774754`}, {
         0.05234468737908404, 1.094154904829825}},
         SplineDegree->7], 0.03264325246390193], 
        ArrowBox[BezierCurveBox[{{0.05234468737908404, 1.094154904829825}, {
         0.5040585263868099, 1.1505651095491847`}, {0.9010755971620058, 
         0.9278434243437199}}], 0.03264325246390193], 
        ArrowBox[BezierCurveBox[{{0.05234468737908404, 1.094154904829825}, {
         0.44936175815427953`, 0.8714332196246946}, {0.9010755971620058, 
         0.9278434243437199}}], 0.03264325246390193], 
        ArrowBox[BezierCurveBox[{{0.05234468737908404, 1.094154904829825}, {
         0.2026727985994146, 1.6084936636634641`}, {0.6289468660690523, 
         1.9331986363145184`}}], 0.03264325246390193], 
        ArrowBox[{{0.9010755971620058, 0.9278434243437199}, {
         2.171607508894414, 1.3426397542556134`}}, 0.03264325246390193], 
        ArrowBox[{{0.9010755971620058, 0.9278434243437199}, {0., 
         1.667217465257041}}, 0.03264325246390193], 
        ArrowBox[{{2.7479355189141916`, 1.164149518769242}, {
         1.8487811710313142`, 1.9337032191429815`}}, 0.03264325246390193], 
        ArrowBox[{{2.7479355189141916`, 1.164149518769242}, {
         2.3014649116538033`, 0.390178905822978}}, 0.03264325246390193], 
        ArrowBox[{{0.6289468660690523, 1.9331986363145184`}, {
         1.8487811710313142`, 1.9337032191429815`}}, 0.03264325246390193], 
        ArrowBox[BezierCurveBox[{{0.6289468660690523, 1.9331986363145184`}, {
         0.4786187548487224, 1.4188598774813508`}, {0.05234468737908404, 
         1.094154904829825}}], 0.03264325246390193], 
        ArrowBox[BezierCurveBox[{{0.6289468660690523, 1.9331986363145184`}, {
         0.3582115755398744, 1.6967835581917148`}, {0., 1.667217465257041}}], 
         0.03264325246390193], 
        ArrowBox[BezierCurveBox[{{0.6289468660690523, 1.9331986363145184`}, {
         0.27073529052919887`, 1.903632543380294}, {0., 1.667217465257041}}], 
         0.03264325246390193], 
        ArrowBox[{{2.44951514549009, 2.371265686084975}, {2.171607508894414, 
         1.3426397542556134`}}, 0.03264325246390193], 
        ArrowBox[{{2.44951514549009, 2.371265686084975}, {1.8487811710313142`,
          1.9337032191429815`}}, 0.03264325246390193], 
        ArrowBox[{{3.3420537548112836`, 1.3541733260727544`}, {
         2.7479355189141916`, 1.164149518769242}}, 0.03264325246390193], 
        ArrowBox[{{1.4242532142505218`, 0.}, {0.9010755971620058, 
         0.9278434243437199}}, 0.03264325246390193], 
        ArrowBox[{{1.4242532142505218`, 0.}, {2.3014649116538033`, 
         0.390178905822978}}, 0.03264325246390193]}, 
       {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[
        0.7]}], {
         DiskBox[{2.171607508894414, 1.3426397542556134}, 
          0.03264325246390193], 
         InsetBox["7", 
          Offset[{2, 2}, {2.204250761358316, 1.3752830067195154}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.8487811710313142, 1.9337032191429815}, 
          0.03264325246390193], 
         InsetBox["6", Offset[{2, 2}, {1.8814244234952162, 1.9663464716068835}],\
 ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.05234468737908404, 1.094154904829825}, 
          0.03264325246390193], 
         InsetBox["10", 
          Offset[{2, 2}, {0.08498793984298597, 1.126798157293727}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.9010755971620058, 0.9278434243437199}, 
          0.03264325246390193], 
         InsetBox["8", 
          Offset[{2, 2}, {0.9337188496259077, 0.9604866768076219}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{2.7479355189141916, 1.164149518769242}, 
          0.03264325246390193], 
         InsetBox["1", 
          Offset[{2, 2}, {2.7805787713780936, 1.196792771233144}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0., 1.667217465257041}, 0.03264325246390193], 
         InsetBox["4", 
          Offset[{2, 2}, {0.03264325246390193, 1.699860717720943}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{2.3014649116538033, 0.390178905822978}, 
          0.03264325246390193], 
         InsetBox["9", 
          Offset[{2, 2}, {2.3341081641177053, 0.4228221582868799}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{0.6289468660690523, 1.9331986363145184}, 
          0.03264325246390193], 
         InsetBox["3", 
          Offset[{2, 2}, {0.6615901185329542, 1.9658418887784204}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{2.44951514549009, 2.371265686084975}, 0.03264325246390193], 
         InsetBox["0", 
          Offset[{2, 2}, {2.482158397953992, 2.4039089385488768}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{3.3420537548112836, 1.3541733260727544}, 
          0.03264325246390193], 
         InsetBox["5", 
          Offset[{2, 2}, {3.3746970072751856, 1.3868165785366564}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         DiskBox[{1.4242532142505218, 0.}, 0.03264325246390193], 
         InsetBox["2", 
          Offset[{2, 2}, {1.4568964667144237, 0.03264325246390193}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}}}],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->{
   "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
  FrameTicks->None,
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImageSize->{314.69140625, Automatic}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[13]=",ExpressionUUID->"a9f0ac53-937b-47a4-a489-ddfe47f7de7a"]
}, Open  ]],

Cell["\<\
You\[CloseCurlyQuote]ll get a different graph if you generate different \
random numbers. Here are 6 graphs.\
\>", "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"1c26fe8d-239a-41bb-8793-07e76cbc40f6"],

Cell["Six randomly generated graphs:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"0f79d6de-cd9f-4233-aa5b-a7c7d5a9ca71"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graph", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"RandomInteger", "[", "10", "]"}], "\[Rule]", 
       RowBox[{"RandomInteger", "[", "10", "]"}]}], ",", "20"}], "]"}], "]"}],
    ",", "6"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[14]:=",ExpressionUUID->"d45fd0cd-3f76-45d5-942a-283c2dd96f6c"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    NamespaceBox["NetworkGraphics",
     DynamicModuleBox[{Typeset`graph = HoldComplete[
       Graph[{7, 2, 4, 5, 10, 6, 9, 0, 8, 1, 
        3}, {{{1, 2}, {3, 4}, {5, 4}, {6, 7}, {8, 4}, {5, 1}, {9, 10}, {9, 
         1}, {7, 1}, {3, 3}, {1, 8}, {2, 11}, {3, 2}, {11, 11}, {8, 3}, {1, 
         9}, {8, 5}, {9, 3}, {9, 3}, {6, 10}}, Null}]]}, 
      TagBox[GraphicsGroupBox[GraphicsComplexBox[CompressedData["
1:eJw9UXs0lIse/QYzzEzGECeKJikhRXOcjiK/36FSSjUaUsrkFXWo9PA6Xrle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         "], {
          {Hue[0.6, 0.7, 0.5], Opacity[0.7], Arrowheads[Medium], 
           ArrowBox[{1, 2}, 0.03591686318203137], 
           ArrowBox[{1, 8}, 0.03591686318203137], 
           ArrowBox[BezierCurveBox[{
            1, {2.0917426977222613`, 1.4896517776745621`}, 9}], 
            0.03591686318203137], ArrowBox[{2, 11}, 0.03591686318203137], 
           ArrowBox[{3, 2}, 0.03591686318203137], 
           ArrowBox[BezierCurveBox[{3, 31, 34, 36, 42, 44, 47, 3},
            SplineDegree->7], 0.03591686318203137], 
           ArrowBox[{3, 4}, 0.03591686318203137], 
           ArrowBox[{5, 1}, 0.03591686318203137], 
           ArrowBox[{5, 4}, 0.03591686318203137], 
           ArrowBox[{6, 7}, 0.03591686318203137], 
           ArrowBox[{6, 10}, 0.03591686318203137], 
           ArrowBox[{7, 1}, 0.03591686318203137], 
           ArrowBox[{8, 3}, 0.03591686318203137], 
           ArrowBox[{8, 4}, 0.03591686318203137], 
           ArrowBox[{8, 5}, 0.03591686318203137], 
           ArrowBox[BezierCurveBox[{
            9, {1.8574319396697623`, 1.6342873703872756`}, 1}], 
            0.03591686318203137], 
           ArrowBox[BezierCurveBox[{
            9, {2.2769582388433984`, 1.6155595110535854`}, 3}], 
            0.03591686318203137], 
           ArrowBox[BezierCurveBox[{
            9, {2.418256536836245, 1.2255651228103828`}, 3}], 
            0.03591686318203137], ArrowBox[{9, 10}, 0.03591686318203137], 
           ArrowBox[BezierCurveBox[{11, 102, 105, 107, 113, 115, 118, 11},
            SplineDegree->7], 0.03591686318203137]}, 
          {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[0.7]}], 
           DiskBox[1, 0.03591686318203137], DiskBox[2, 0.03591686318203137], 
           DiskBox[3, 0.03591686318203137], DiskBox[4, 0.03591686318203137], 
           DiskBox[5, 0.03591686318203137], DiskBox[6, 0.03591686318203137], 
           DiskBox[7, 0.03591686318203137], DiskBox[8, 0.03591686318203137], 
           DiskBox[9, 0.03591686318203137], DiskBox[10, 0.03591686318203137], 
           DiskBox[11, 0.03591686318203137]}}]],
       MouseAppearanceTag["NetworkGraphics"]],
      AllowKernelInitialization->False]],
    DefaultBaseStyle->{
     "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
    
    FrameTicks->None,
    GridLinesStyle->Directive[
      GrayLevel[0.5, 0.4]],
    ImageSize->{179.67578125, Automatic}], ",", 
   GraphicsBox[
    NamespaceBox["NetworkGraphics",
     DynamicModuleBox[{Typeset`graph = HoldComplete[
       Graph[{2, 7, 8, 1, 0, 4, 9, 5, 3, 10, 
        6}, {{{1, 1}, {2, 3}, {4, 5}, {5, 6}, {7, 4}, {4, 3}, {2, 8}, {9, 
         1}, {5, 4}, {5, 8}, {7, 2}, {4, 7}, {10, 6}, {9, 8}, {9, 6}, {6, 
         5}, {8, 6}, {10, 4}, {7, 10}, {4, 11}}, Null}]]}, 
      TagBox[GraphicsGroupBox[GraphicsComplexBox[CompressedData["
1:eJw1VXlYjAsXn5maMS2zUER8SH1JKmUNV+cgWVpMJCK0IVEyhaiPkmilyM3S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         "], {
          {Hue[0.6, 0.7, 0.5], Opacity[0.7], Arrowheads[Medium], 
           ArrowBox[BezierCurveBox[{1, 15, 18, 20, 26, 28, 31, 1},
            SplineDegree->7], 0.044018656614346646`], 
           ArrowBox[{2, 3}, 0.044018656614346646`], 
           ArrowBox[{2, 8}, 0.044018656614346646`], 
           ArrowBox[{4, 3}, 0.044018656614346646`], 
           ArrowBox[BezierCurveBox[{
            4, {3.487431659433802, 0.9064770405025556}, 5}], 
            0.044018656614346646`], 
           ArrowBox[BezierCurveBox[{
            4, {3.947123369723664, 0.8638934337037665}, 7}], 
            0.044018656614346646`], ArrowBox[{4, 11}, 0.044018656614346646`], 
           ArrowBox[BezierCurveBox[{
            5, {3.4681217228682915`, 1.3182208726429159`}, 4}], 
            0.044018656614346646`], 
           ArrowBox[BezierCurveBox[{
            5, {2.436652671989926, 1.0845832579729857`}, 6}], 
            0.044018656614346646`], ArrowBox[{5, 8}, 0.044018656614346646`], 
           ArrowBox[BezierCurveBox[{
            6, {2.518638832971528, 1.3306885411781102`}, 5}], 
            0.044018656614346646`], ArrowBox[{7, 2}, 0.044018656614346646`], 
           ArrowBox[BezierCurveBox[{
            7, {3.812800371512594, 1.0110947401682184`}, 4}], 
            0.044018656614346646`], ArrowBox[{7, 10}, 0.044018656614346646`], 
           ArrowBox[{8, 6}, 0.044018656614346646`], 
           ArrowBox[{9, 1}, 0.044018656614346646`], 
           ArrowBox[{9, 6}, 0.044018656614346646`], 
           ArrowBox[{9, 8}, 0.044018656614346646`], 
           ArrowBox[{10, 4}, 0.044018656614346646`], 
           ArrowBox[{10, 6}, 0.044018656614346646`]}, 
          {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[0.7]}], 
           DiskBox[1, 0.044018656614346646], DiskBox[2, 0.044018656614346646],
            DiskBox[3, 0.044018656614346646], 
           DiskBox[4, 0.044018656614346646], DiskBox[5, 0.044018656614346646],
            DiskBox[6, 0.044018656614346646], 
           DiskBox[7, 0.044018656614346646], DiskBox[8, 0.044018656614346646],
            DiskBox[9, 0.044018656614346646], 
           DiskBox[10, 0.044018656614346646], 
           DiskBox[11, 0.044018656614346646]}}]],
       MouseAppearanceTag["NetworkGraphics"]],
      AllowKernelInitialization->False]],
    DefaultBaseStyle->{
     "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
    
    FrameTicks->None,
    GridLinesStyle->Directive[
      GrayLevel[0.5, 0.4]],
    ImageSize->{180.44140625, Automatic}], ",", 
   GraphicsBox[
    NamespaceBox["NetworkGraphics",
     DynamicModuleBox[{Typeset`graph = HoldComplete[
       Graph[{4, 7, 5, 10, 8, 2, 3, 1, 0, 6, 
        9}, {{{1, 2}, {3, 1}, {4, 1}, {5, 6}, {6, 1}, {4, 7}, {3, 4}, {8, 
         9}, {1, 4}, {10, 7}, {11, 3}, {8, 10}, {9, 9}, {1, 6}, {3, 4}, {10, 
         2}, {8, 3}, {11, 4}, {11, 4}, {9, 1}}, Null}]]}, 
      TagBox[GraphicsGroupBox[GraphicsComplexBox[CompressedData["
1:eJw1VXk01YkXf2vv+30tVNoNRYgkZQ/dSyqSxtIrZanJMiWUGGs0bSaVFtla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         "], {
          {Hue[0.6, 0.7, 0.5], Opacity[0.7], Arrowheads[Medium], 
           ArrowBox[{1, 2}, 0.03887327549562149], 
           ArrowBox[BezierCurveBox[{
            1, {2.9172195264805163`, 1.177475506713323}, 4}], 
            0.03887327549562149], 
           ArrowBox[BezierCurveBox[{
            1, {1.6585590727765007`, 1.07211561845128}, 6}], 
            0.03887327549562149], ArrowBox[{3, 1}, 0.03887327549562149], 
           ArrowBox[BezierCurveBox[{
            3, {3.117488377925034, 0.8866900354366913}, 4}], 
            0.03887327549562149], 
           ArrowBox[BezierCurveBox[{
            3, {3.033310536285647, 0.7266491238502572}, 4}], 
            0.03887327549562149], 
           ArrowBox[BezierCurveBox[{
            4, {2.6995373707897126`, 0.8417980585450895}, 1}], 
            0.03887327549562149], ArrowBox[{4, 7}, 0.03887327549562149], 
           ArrowBox[{5, 6}, 0.03887327549562149], 
           ArrowBox[BezierCurveBox[{
            6, {1.6240442250204268`, 1.504098094159061}, 1}], 
            0.03887327549562149], ArrowBox[{8, 3}, 0.03887327549562149], 
           ArrowBox[{8, 9}, 0.03887327549562149], 
           ArrowBox[{8, 10}, 0.03887327549562149], 
           ArrowBox[{9, 1}, 0.03887327549562149], 
           ArrowBox[BezierCurveBox[{9, 111, 114, 116, 122, 124, 127, 9},
            SplineDegree->7], 0.03887327549562149], 
           ArrowBox[{10, 2}, 0.03887327549562149], 
           ArrowBox[{10, 7}, 0.03887327549562149], 
           ArrowBox[{11, 3}, 0.03887327549562149], 
           ArrowBox[BezierCurveBox[{
            11, {3.072729388929013, 0.38354062558639856`}, 4}], 
            0.03887327549562149], 
           ArrowBox[BezierCurveBox[{
            11, {3.29593916492133, 0.29515300666689026`}, 4}], 
            0.03887327549562149]}, 
          {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[0.7]}], 
           DiskBox[1, 0.03887327549562149], DiskBox[2, 0.03887327549562149], 
           DiskBox[3, 0.03887327549562149], DiskBox[4, 0.03887327549562149], 
           DiskBox[5, 0.03887327549562149], DiskBox[6, 0.03887327549562149], 
           DiskBox[7, 0.03887327549562149], DiskBox[8, 0.03887327549562149], 
           DiskBox[9, 0.03887327549562149], DiskBox[10, 0.03887327549562149], 
           DiskBox[11, 0.03887327549562149]}}]],
       MouseAppearanceTag["NetworkGraphics"]],
      AllowKernelInitialization->False]],
    DefaultBaseStyle->{
     "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
    
    FrameTicks->None,
    GridLinesStyle->Directive[
      GrayLevel[0.5, 0.4]],
    ImageSize->{179.64453125, Automatic}], ",", 
   GraphicsBox[
    NamespaceBox["NetworkGraphics",
     DynamicModuleBox[{Typeset`graph = HoldComplete[
       Graph[{1, 8, 5, 2, 7, 3, 10, 4, 9, 0, 
        6}, {{{1, 2}, {3, 4}, {5, 5}, {6, 6}, {5, 7}, {8, 5}, {7, 7}, {9, 
         4}, {8, 6}, {8, 5}, {4, 2}, {1, 10}, {4, 7}, {8, 9}, {10, 3}, {8, 
         10}, {5, 11}, {6, 6}, {8, 2}, {6, 9}}, Null}]]}, 
      TagBox[GraphicsGroupBox[GraphicsComplexBox[CompressedData["
1:eJyNVws4VWkXPpz7xXE5J2XoYpJSEYoQvmVCVCMjUylEIakRuqILCpVSoUjS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         "], {
          {Hue[0.6, 0.7, 0.5], Opacity[0.7], Arrowheads[Medium], 
           ArrowBox[BezierCurveBox[{1, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30,
             31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 
            47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 
            63, 64, 2}], 0.043048128342245986`], 
           ArrowBox[{1, 10}, 0.043048128342245986`], 
           ArrowBox[{3, 4}, 0.043048128342245986`], 
           ArrowBox[{4, 2}, 0.043048128342245986`], 
           ArrowBox[{4, 7}, 0.043048128342245986`], 
           ArrowBox[{5, 7}, 0.043048128342245986`], 
           ArrowBox[{5, 11}, 0.043048128342245986`], 
           ArrowBox[BezierCurveBox[{5, 68, 71, 73, 79, 81, 84, 5},
            SplineDegree->7], 0.043048128342245986`], 
           ArrowBox[{6, 9}, 0.043048128342245986`], 
           ArrowBox[BezierCurveBox[{6, 91, 94, 96, 102, 104, 107, 6},
            SplineDegree->7], 0.043048128342245986`], 
           ArrowBox[BezierCurveBox[{6, 114, 117, 119, 125, 127, 130, 6},
            SplineDegree->7], 0.043048128342245986`], 
           ArrowBox[BezierCurveBox[{7, 137, 140, 142, 148, 150, 153, 7},
            SplineDegree->7], 0.043048128342245986`], 
           ArrowBox[BezierCurveBox[{8, 157, 158, 159, 160, 161, 162, 163, 164,
             165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 175, 176, 177, 
            178, 179, 180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 
            191, 192, 193, 194, 195, 196, 197, 198, 199, 200, 2}], 
            0.043048128342245986`], 
           ArrowBox[BezierCurveBox[{8, 201, 202, 203, 204, 205, 206, 207, 208,
             209, 210, 211, 212, 213, 214, 215, 216, 217, 218, 219, 220, 221, 
            222, 223, 224, 225, 226, 227, 228, 229, 230, 231, 232, 233, 234, 
            235, 5}], 0.043048128342245986`], 
           ArrowBox[BezierCurveBox[{8, 236, 237, 238, 239, 240, 241, 242, 243,
             244, 245, 246, 247, 248, 249, 250, 251, 252, 253, 254, 255, 256, 
            257, 258, 259, 260, 261, 262, 263, 264, 265, 266, 267, 268, 269, 
            270, 5}], 0.043048128342245986`], 
           ArrowBox[{8, 6}, 0.043048128342245986`], 
           ArrowBox[BezierCurveBox[{8, 271, 272, 273, 274, 275, 276, 277, 278,
             279, 280, 281, 282, 283, 284, 285, 286, 287, 288, 289, 290, 291, 
            292, 293, 294, 295, 296, 9}], 0.043048128342245986`], 
           ArrowBox[{8, 10}, 0.043048128342245986`], 
           ArrowBox[{9, 4}, 0.043048128342245986`], 
           ArrowBox[{10, 3}, 0.043048128342245986`]}, 
          {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[0.7]}], 
           DiskBox[1, 0.043048128342245986], DiskBox[2, 0.043048128342245986],
            DiskBox[3, 0.043048128342245986], 
           DiskBox[4, 0.043048128342245986], DiskBox[5, 0.043048128342245986],
            DiskBox[6, 0.043048128342245986], 
           DiskBox[7, 0.043048128342245986], DiskBox[8, 0.043048128342245986],
            DiskBox[9, 0.043048128342245986], 
           DiskBox[10, 0.043048128342245986], 
           DiskBox[11, 0.043048128342245986]}}]],
       MouseAppearanceTag["NetworkGraphics"]],
      AllowKernelInitialization->False]],
    DefaultBaseStyle->{
     "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
    
    FrameTicks->None,
    GridLinesStyle->Directive[
      GrayLevel[0.5, 0.4]],
    ImageSize->{179.92578125, Automatic}], ",", 
   GraphicsBox[
    NamespaceBox["NetworkGraphics",
     DynamicModuleBox[{Typeset`graph = HoldComplete[
       Graph[{6, 2, 0, 8, 7, 9, 3, 1, 10, 4, 
        5}, {{{1, 2}, {3, 4}, {5, 5}, {6, 6}, {6, 1}, {6, 6}, {7, 7}, {5, 
         8}, {1, 4}, {9, 10}, {3, 9}, {6, 6}, {1, 3}, {3, 6}, {11, 7}, {7, 
         6}, {5, 3}, {9, 9}, {7, 1}, {3, 9}}, Null}]]}, 
      TagBox[GraphicsGroupBox[GraphicsComplexBox[CompressedData["
1:eJw9Vnk01IsXn/kSxiyIyitblERGu4R3bxRTaFKWFqSEykOy01NUyvOECtVL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         "], {
          {Hue[0.6, 0.7, 0.5], Opacity[0.7], Arrowheads[Medium], 
           ArrowBox[{1, 2}, 0.041577534459150564`], 
           ArrowBox[{1, 3}, 0.041577534459150564`], 
           ArrowBox[{1, 4}, 0.041577534459150564`], 
           ArrowBox[{3, 4}, 0.041577534459150564`], 
           ArrowBox[{3, 6}, 0.041577534459150564`], 
           ArrowBox[BezierCurveBox[{
            3, {3.2793947529064766`, 2.1857695234336987`}, 9}], 
            0.041577534459150564`], 
           ArrowBox[BezierCurveBox[{
            3, {3.4855923752636735`, 1.8313215652804633`}, 9}], 
            0.041577534459150564`], ArrowBox[{5, 3}, 0.041577534459150564`], 
           ArrowBox[BezierCurveBox[{5, 47, 50, 52, 58, 60, 63, 5},
            SplineDegree->7], 0.041577534459150564`], 
           ArrowBox[{5, 8}, 0.041577534459150564`], 
           ArrowBox[{6, 1}, 0.041577534459150564`], 
           ArrowBox[BezierCurveBox[{6, 70, 73, 75, 81, 83, 86, 6},
            SplineDegree->7], 0.041577534459150564`], 
           ArrowBox[BezierCurveBox[{6, 93, 96, 98, 104, 106, 109, 6},
            SplineDegree->7], 0.041577534459150564`], 
           ArrowBox[BezierCurveBox[{6, 116, 119, 121, 127, 129, 132, 6},
            SplineDegree->7], 0.041577534459150564`], 
           ArrowBox[{7, 1}, 0.041577534459150564`], 
           ArrowBox[{7, 6}, 0.041577534459150564`], 
           ArrowBox[BezierCurveBox[{7, 139, 142, 144, 150, 152, 155, 7},
            SplineDegree->7], 0.041577534459150564`], 
           ArrowBox[BezierCurveBox[{9, 162, 165, 167, 173, 175, 178, 9},
            SplineDegree->7], 0.041577534459150564`], 
           ArrowBox[{9, 10}, 0.041577534459150564`], 
           ArrowBox[{11, 7}, 0.041577534459150564`]}, 
          {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[0.7]}], 
           DiskBox[1, 0.041577534459150564], DiskBox[2, 0.041577534459150564],
            DiskBox[3, 0.041577534459150564], 
           DiskBox[4, 0.041577534459150564], DiskBox[5, 0.041577534459150564],
            DiskBox[6, 0.041577534459150564], 
           DiskBox[7, 0.041577534459150564], DiskBox[8, 0.041577534459150564],
            DiskBox[9, 0.041577534459150564], 
           DiskBox[10, 0.041577534459150564], 
           DiskBox[11, 0.041577534459150564]}}]],
       MouseAppearanceTag["NetworkGraphics"]],
      AllowKernelInitialization->False]],
    DefaultBaseStyle->{
     "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
    
    FrameTicks->None,
    GridLinesStyle->Directive[
      GrayLevel[0.5, 0.4]],
    ImageSize->{179.83984375, Automatic}], ",", 
   GraphicsBox[
    NamespaceBox["NetworkGraphics",
     DynamicModuleBox[{Typeset`graph = HoldComplete[
       Graph[{10, 7, 3, 1, 0, 4, 8, 9, 6, 5, 
        2}, {{{1, 2}, {3, 4}, {5, 3}, {3, 3}, {6, 6}, {5, 6}, {7, 6}, {3, 
         8}, {5, 3}, {7, 6}, {6, 9}, {3, 8}, {7, 9}, {8, 10}, {11, 7}, {11, 
         6}, {2, 8}, {10, 8}, {10, 6}, {6, 9}}, Null}]]}, 
      TagBox[GraphicsGroupBox[GraphicsComplexBox[CompressedData["
1:eJxdlnk01A0Xx2fGvvvNoCyplDUJSWXpXilbmyXaFImSrHlKpdWSyNtCKEtU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         "], {
          {Hue[0.6, 0.7, 0.5], Opacity[0.7], Arrowheads[Medium], 
           ArrowBox[{1, 2}, 0.043820136618879874`], 
           ArrowBox[{2, 8}, 0.043820136618879874`], 
           ArrowBox[BezierCurveBox[{3, 15, 18, 20, 26, 28, 31, 3},
            SplineDegree->7], 0.043820136618879874`], 
           ArrowBox[{3, 4}, 0.043820136618879874`], 
           ArrowBox[BezierCurveBox[{
            3, {2.3091281554923864`, 1.189618603367728}, 8}], 
            0.043820136618879874`], 
           ArrowBox[BezierCurveBox[{
            3, {1.9934430366165072`, 1.3266809445013796`}, 8}], 
            0.043820136618879874`], 
           ArrowBox[BezierCurveBox[{
            5, {2.839006069979014, 1.441614860113337}, 3}], 
            0.043820136618879874`], 
           ArrowBox[BezierCurveBox[{
            5, {2.921407277529381, 1.784009825602438}, 3}], 
            0.043820136618879874`], ArrowBox[{5, 6}, 0.043820136618879874`], 
           ArrowBox[BezierCurveBox[{6, 102, 105, 107, 113, 115, 118, 6},
            SplineDegree->7], 0.043820136618879874`], 
           ArrowBox[BezierCurveBox[{
            6, {4.673500975956767, 0.5140213227438056}, 9}], 
            0.043820136618879874`], 
           ArrowBox[BezierCurveBox[{
            6, {4.437688178020583, 0.31013623831292314`}, 9}], 
            0.043820136618879874`], 
           ArrowBox[BezierCurveBox[{
            7, {4.6578406788842885`, 0.5239767206237581}, 6}], 
            0.043820136618879874`], 
           ArrowBox[BezierCurveBox[{
            7, {4.72374970386113, 0.8167917652493795}, 6}], 
            0.043820136618879874`], ArrowBox[{7, 9}, 0.043820136618879874`], 
           ArrowBox[BezierCurveBox[{
            8, {2.544699466705823, 0.8524064065473697}, 10}], 
            0.043820136618879874`], ArrowBox[{10, 6}, 0.043820136618879874`], 
           ArrowBox[BezierCurveBox[{
            10, {2.4712618999340474`, 0.4807232387493367}, 8}], 
            0.043820136618879874`], ArrowBox[{11, 6}, 0.043820136618879874`], 
           ArrowBox[{11, 7}, 0.043820136618879874`]}, 
          {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[0.7]}], 
           DiskBox[1, 0.043820136618879874], DiskBox[2, 0.043820136618879874],
            DiskBox[3, 0.043820136618879874], 
           DiskBox[4, 0.043820136618879874], DiskBox[5, 0.043820136618879874],
            DiskBox[6, 0.043820136618879874], 
           DiskBox[7, 0.043820136618879874], DiskBox[8, 0.043820136618879874],
            DiskBox[9, 0.043820136618879874], 
           DiskBox[10, 0.043820136618879874], 
           DiskBox[11, 0.043820136618879874]}}]],
       MouseAppearanceTag["NetworkGraphics"]],
      AllowKernelInitialization->False]],
    DefaultBaseStyle->{
     "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
    
    FrameTicks->None,
    GridLinesStyle->Directive[
      GrayLevel[0.5, 0.4]],
    ImageSize->{180.109375, Automatic}]}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellTags->"LastCellOfAPage",
 CellLabel->"Out[14]=",ExpressionUUID->"13ab11a5-322c-4ac7-a349-f1061a8d2d71"]
}, Open  ]],

Cell["\<\
There\[CloseCurlyQuote]s lots of analysis that can be done on graphs. One \
example is to break a graph into \[OpenCurlyDoubleQuote]communities\
\[CloseCurlyDoubleQuote]\[LongDash]clumps of nodes that are more connected to \
each other than to the rest of the graph. Let\[CloseCurlyQuote]s do that for \
a random graph. \
\>", "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->{
  "p:119", "i:13"},ExpressionUUID->"a1702fa8-1fd2-4352-beaa-d5775c4478d1"],

Cell["Make a plot that collects \[OpenCurlyDoubleQuote]communities\
\[CloseCurlyDoubleQuote] of nodes together:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:14",ExpressionUUID->"8955f7b3-b002-4403-a921-f157958364ff"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CommunityGraphPlot", "[", 
  GraphicsBox[
   NamespaceBox["NetworkGraphics",
    DynamicModuleBox[{Typeset`graph = HoldComplete[
      Graph[{18, 17, 14, 12, 4, 2, 1, 11, 6, 16, 13, 0, 10, 15, 20, 7, 5, 8, 
       9, 3, 19}, {{{1, 2}, {1, 3}, {4, 5}, {6, 1}, {7, 6}, {3, 7}, {8, 3}, {
        9, 10}, {6, 11}, {12, 7}, {9, 13}, {9, 4}, {14, 9}, {10, 15}, {4, 
        13}, {14, 2}, {10, 11}, {3, 12}, {10, 9}, {9, 7}, {16, 16}, {17, 1}, {
        2, 5}, {10, 14}, {2, 10}, {18, 13}, {17, 19}, {4, 6}, {2, 4}, {12, 
        10}, {12, 8}, {4, 20}, {15, 12}, {6, 11}, {2, 15}, {19, 1}, {20, 9}, {
        15, 10}, {1, 2}, {17, 6}, {6, 14}, {5, 14}, {12, 7}, {14, 7}, {9, 
        8}, {6, 11}, {3, 21}, {18, 15}, {13, 16}, {5, 8}}, Null}]]}, 
     TagBox[GraphicsGroupBox[GraphicsComplexBox[CompressedData["
1:eJw9Vgk01O33n/nOmLF8v8PY15cQqV9eLZYkzyVlaRFF2QslQmSXFkp4E0mU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        "], {
         {Hue[0.6, 0.7, 0.5], Opacity[0.7], Arrowheads[0.021710536694215837`],
           ArrowBox[BezierCurveBox[{
           1, {3.9516932575197803`, 1.6786127197810763`}, 2}], 
           0.046840312738230916`], 
          ArrowBox[BezierCurveBox[{
           1, {3.942488939232073, 2.1388895994433716`}, 2}], 
           0.046840312738230916`], ArrowBox[{1, 3}, 0.046840312738230916`], 
          ArrowBox[{2, 4}, 0.046840312738230916`], 
          ArrowBox[{2, 5}, 0.046840312738230916`], 
          ArrowBox[{2, 10}, 0.046840312738230916`], 
          ArrowBox[{2, 15}, 0.046840312738230916`], 
          ArrowBox[{3, 7}, 0.046840312738230916`], 
          ArrowBox[{3, 12}, 0.046840312738230916`], 
          ArrowBox[{3, 21}, 0.046840312738230916`], 
          ArrowBox[{4, 5}, 0.046840312738230916`], 
          ArrowBox[{4, 6}, 0.046840312738230916`], 
          ArrowBox[{4, 13}, 0.046840312738230916`], 
          ArrowBox[{4, 20}, 0.046840312738230916`], 
          ArrowBox[{5, 8}, 0.046840312738230916`], 
          ArrowBox[{5, 14}, 0.046840312738230916`], 
          ArrowBox[{6, 1}, 0.046840312738230916`], 
          ArrowBox[BezierCurveBox[{
           6, {3.5030842254492804`, 2.5535550585345943`}, 11}], 
           0.046840312738230916`], ArrowBox[{6, 11}, 0.046840312738230916`], 
          ArrowBox[BezierCurveBox[{
           6, {3.831710739394434, 2.65357042004921}, 11}], 
           0.046840312738230916`], ArrowBox[{6, 14}, 0.046840312738230916`], 
          ArrowBox[{7, 6}, 0.046840312738230916`], 
          ArrowBox[{8, 3}, 0.046840312738230916`], 
          ArrowBox[{9, 4}, 0.046840312738230916`], 
          ArrowBox[{9, 7}, 0.046840312738230916`], 
          ArrowBox[{9, 8}, 0.046840312738230916`], 
          ArrowBox[BezierCurveBox[{
           9, {2.53987111328563, 1.7495543938902882`}, 10}], 
           0.046840312738230916`], ArrowBox[{9, 13}, 0.046840312738230916`], 
          ArrowBox[BezierCurveBox[{
           10, {2.9077671567847547`, 1.5933644746578552`}, 9}], 
           0.046840312738230916`], ArrowBox[{10, 11}, 0.046840312738230916`], 
          ArrowBox[{10, 14}, 0.046840312738230916`], 
          ArrowBox[BezierCurveBox[{
           10, {2.662381264132733, 2.1845311111714807`}, 15}], 
           0.046840312738230916`], 
          ArrowBox[BezierCurveBox[{
           12, {3.676352478346518, 1.3202886493576447`}, 7}], 
           0.046840312738230916`], 
          ArrowBox[BezierCurveBox[{
           12, {3.558198032323462, 1.253295570504861}, 7}], 
           0.046840312738230916`], ArrowBox[{12, 8}, 0.046840312738230916`], 
          ArrowBox[{12, 10}, 0.046840312738230916`], 
          ArrowBox[{13, 16}, 0.046840312738230916`], 
          ArrowBox[{14, 2}, 0.046840312738230916`], 
          ArrowBox[{14, 7}, 0.046840312738230916`], 
          ArrowBox[{14, 9}, 0.046840312738230916`], 
          ArrowBox[BezierCurveBox[{
           15, {2.6932811430138037`, 2.3709701896509108`}, 10}], 
           0.046840312738230916`], ArrowBox[{15, 12}, 0.046840312738230916`], 
          ArrowBox[BezierCurveBox[{16, 185, 188, 190, 196, 198, 201, 16},
           SplineDegree->7], 0.046840312738230916`], 
          ArrowBox[{17, 1}, 0.046840312738230916`], 
          ArrowBox[{17, 6}, 0.046840312738230916`], 
          ArrowBox[{17, 19}, 0.046840312738230916`], 
          ArrowBox[{18, 13}, 0.046840312738230916`], 
          ArrowBox[{18, 15}, 0.046840312738230916`], 
          ArrowBox[{19, 1}, 0.046840312738230916`], 
          ArrowBox[{20, 9}, 0.046840312738230916`]}, 
         {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[0.7]}], 
          DiskBox[1, 0.046840312738230916], DiskBox[2, 0.046840312738230916], 
          DiskBox[3, 0.046840312738230916], DiskBox[4, 0.046840312738230916], 
          DiskBox[5, 0.046840312738230916], DiskBox[6, 0.046840312738230916], 
          DiskBox[7, 0.046840312738230916], DiskBox[8, 0.046840312738230916], 
          DiskBox[9, 0.046840312738230916], DiskBox[10, 0.046840312738230916],
           DiskBox[11, 0.046840312738230916], 
          DiskBox[12, 0.046840312738230916], 
          DiskBox[13, 0.046840312738230916], 
          DiskBox[14, 0.046840312738230916], 
          DiskBox[15, 0.046840312738230916], 
          DiskBox[16, 0.046840312738230916], 
          DiskBox[17, 0.046840312738230916], 
          DiskBox[18, 0.046840312738230916], 
          DiskBox[19, 0.046840312738230916], 
          DiskBox[20, 0.046840312738230916], 
          DiskBox[21, 0.046840312738230916]}}]],
      MouseAppearanceTag["NetworkGraphics"]],
     AllowKernelInitialization->False]],
   DefaultBaseStyle->{
    "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
   FrameTicks->None,
   GridLinesStyle->Directive[
     GrayLevel[0.5, 0.4]],
   ImageSize->{320.4296875, Automatic}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[15]:=",ExpressionUUID->"bafa07e2-a577-460c-8abf-94fc6caf6ae2"],

Cell[BoxData[
 GraphicsBox[{{
    {EdgeForm[GrayLevel[0.5]], FaceForm[None], 
     FilledCurveBox[
      BSplineCurve[{{1.9745798452201426`, 0.8767547408884411}, {
       2.4555796571866852`, 0.2546323509623776}, {2.6558354489137437`, 
       0.2546323509623776}, {3.085949688672961, 0.3747788866914875}, {
       3.549251615826192, 0.7897533548576648}, {3.549251615826192, 
       0.990009146584723}, {2.9849903988263313`, 1.6003783232461153`}, {
       2.784734607099273, 1.6003783232461153`}, {1.9745798452201426`, 
       1.0770105326154993`}}, SplineClosed -> True]]}, 
    {EdgeForm[GrayLevel[0.5]], FaceForm[None], 
     FilledCurveBox[
      BSplineCurve[{{0.05052580308146715, 0.20743988959014426`}, {
       0.18027651480324225`, -0.09536106970123004}, {
       1.3819044280243107`, -0.1001278958635291}, {
       1.5821602197513691`, -0.1001278958635291}, {1.8019452725553253`, 
       0.018198638785900223`}, {1.8019452725553253`, 0.21845443051295843`}, {
       1.5922576330123142`, 0.4265540978497937}, {0.6814795247815221, 
       0.45495934225246537`}, {0.48122373305446386`, 0.45495934225246537`}, {
       0.05052580308146715, 0.40769568131720246`}}, SplineClosed -> True]]}, 
    {EdgeForm[GrayLevel[0.5]], FaceForm[None], 
     FilledCurveBox[
      BSplineCurve[{{1.0153429812583923`, 2.261466832649069}, {
       1.2498855648234786`, 1.5240128234907417`}, {1.450141356550537, 
       1.5240128234907417`}, {1.8453405532454297`, 1.7582406380417197`}, {
       1.8453405532454297`, 1.9584964297687781`}, {1.7721340767196683`, 
       2.1984363182543576`}, {1.2155987729854507`, 2.461722624376127}, {
       1.0153429812583923`, 2.461722624376127}}, SplineClosed -> True]]}, 
    {EdgeForm[GrayLevel[0.5]], FaceForm[None], 
     FilledCurveBox[
      BSplineCurve[{{-0.1001278958635291, 1.7455764210740483`}, {
       0.730504475068853, 0.9150825542138202}, {0.9307602667959112, 
       0.9150825542138202}, {0.9307602667959112, 1.1153383459408786`}, {
       0.1001278958635291, 1.9458322128011067`}, {-0.1001278958635291, 
       1.9458322128011067`}}, SplineClosed -> True]]}}, {
    {Hue[0.6, 0.7, 0.5], Opacity[0.7], 
     Arrowheads[{{0.027273271125469387`, 0.8}}], 
     ArrowBox[BezierCurveBox[{{0.581351628917993, 0.35483144638893627`}, {
      1.0900407245711754`, 0.32552432964869654`}, {1.48203232388784, 0.}}]], 
     ArrowBox[BezierCurveBox[{{0.581351628917993, 0.35483144638893627`}, {
      0.9733432282346537, 0.029307116740218398`}, {1.48203232388784, 0.}}]], 
     ArrowBox[BezierCurveBox[{{0.581351628917993, 0.35483144638893627`}, {
      1.3090968114090906`, 0.6500240061597159}, {1.3597607085653232`, 
      1.0335199513112217`}, {1.4104246057215557`, 1.4170158964627275`}, {
      1.2880393905644567`, 1.91902627158318}},
      SplineDegree->2]], 
     ArrowBox[BezierCurveBox[{{1.48203232388784, 0.}, {1.7559859169041165`, 
      0.328695920725001}, {1.9899428633660854`, 0.5288620183463422}, {
      2.2238998098280542`, 0.7290281159676834}, {2.687948223596029, 
      0.9985177774913093}},
      SplineDegree->2]], 
     ArrowBox[{{1.48203232388784, 0.}, {1.7018173766917961`, 
      0.11832653464942933`}}], 
     ArrowBox[BezierCurveBox[{{1.48203232388784, 0.}, {1.7559859169041165`, 
      0.328695920725001}, {1.9899428633660854`, 0.5288620183463422}, {
      2.2238998098280542`, 0.7290281159676834}, {2.074707741083672, 
      0.9768826367519702}},
      SplineDegree->2]], 
     ArrowBox[BezierCurveBox[{{1.48203232388784, 0.}, {1.7559859169041165`, 
      0.328695920725001}, {1.9899428633660854`, 0.5288620183463422}, {
      2.2238998098280542`, 0.7290281159676834}, {2.5557075530502145`, 
      0.3547602468259067}},
      SplineDegree->2]], 
     ArrowBox[{{1.2880393905644567`, 1.91902627158318}, {1.3500134606870078`, 
      1.624140719354271}}], 
     ArrowBox[{{1.2880393905644567`, 1.91902627158318}, {1.6720061808561393`, 
      2.0983084223908284`}}], 
     ArrowBox[{{1.2880393905644567`, 1.91902627158318}, {1.1154708771219215`, 
      2.361594728512598}}], 
     ArrowBox[BezierCurveBox[{{2.687948223596029, 0.9985177774913093}, {
      2.2238998098280542`, 0.7290281159676834}, {1.9899428633660854`, 
      0.5288620183463422}, {1.7559859169041165`, 0.328695920725001}, {
      1.7018173766917961`, 0.11832653464942933`}},
      SplineDegree->2]], 
     ArrowBox[BezierCurveBox[{{2.687948223596029, 0.9985177774913093}, {
      1.8898250331214352`, 1.0983895012180958`}, {1.3983220839030206`, 
      1.2090787953145516`}, {0.9068191346846057, 1.3197680894110075`}, {
      0.8306323709323821, 1.0152104500773493`}},
      SplineDegree->2]], 
     ArrowBox[{{2.687948223596029, 0.9985177774913093}, {2.988440555685215, 
      0.8846456395006829}}], 
     ArrowBox[{{2.687948223596029, 0.9985177774913093}, {2.884862502962802, 
      1.5002504273825863`}}], 
     ArrowBox[BezierCurveBox[{{1.7018173766917961`, 0.11832653464942933`}, {
      1.3090968114090906`, 0.6500240061597159}, {1.3597607085653232`, 
      1.0335199513112217`}, {1.4104246057215557`, 1.4170158964627275`}, {
      1.7452126573819005`, 1.858368533905249}},
      SplineDegree->2]], 
     ArrowBox[{{1.7018173766917961`, 0.11832653464942933`}, {
      1.492129737148785, 0.3264262019862646}}], 
     ArrowBox[BezierCurveBox[{{0.8306323709323821, 1.0152104500773493`}, {
      0.8083188669502677, 0.8438099570437515}, {0.7860053629681534, 
      0.6724094640101537}, {0.7636918589860391, 0.501008970976556}, {
      0.581351628917993, 0.35483144638893627`}},
      SplineDegree->2]], 
     ArrowBox[BezierCurveBox[{{0.8306323709323821, 1.0152104500773493`}, {
      0.2787491534687006, 1.2938675757966973`}, {0., 1.8457043169375775`}}]], 
     ArrowBox[{{0.8306323709323821, 1.0152104500773493`}, {0., 
      1.8457043169375775`}}], 
     ArrowBox[BezierCurveBox[{{0.8306323709323821, 1.0152104500773493`}, {
      0.5518832174636848, 1.5670471912172028`}, {0., 1.8457043169375775`}}]], 
     ArrowBox[BezierCurveBox[{{0.8306323709323821, 1.0152104500773493`}, {
      0.8083188669502677, 0.8438099570437515}, {0.7860053629681534, 
      0.6724094640101537}, {0.7636918589860391, 0.501008970976556}, {
      1.492129737148785, 0.3264262019862646}},
      SplineDegree->2]], 
     ArrowBox[BezierCurveBox[{{1.3500134606870078`, 1.624140719354271}, {
      1.2201681882483515`, 1.4719081520350406`}, {1.090322915809695, 
      1.3196755847158101`}, {0.9604776433710385, 1.1674430173965797`}, {
      0.8306323709323821, 1.0152104500773493`}},
      SplineDegree->2]], 
     ArrowBox[{{1.7452126573819005`, 1.858368533905249}, {1.2880393905644567`,
       1.91902627158318}}], 
     ArrowBox[{{2.6661210553305255`, 1.2696042062216817`}, {2.687948223596029,
       0.9985177774913093}}], 
     ArrowBox[BezierCurveBox[{{2.6661210553305255`, 1.2696042062216817`}, {
      2.270450668385375, 1.205729999131556}, {2.0502369855720155`, 
      1.443747174257802}, {1.830023302758656, 1.6817643493840482`}, {
      1.3500134606870078`, 1.624140719354271}},
      SplineDegree->2]], 
     ArrowBox[BezierCurveBox[{{2.6661210553305255`, 1.2696042062216817`}, {
      2.270450668385375, 1.205729999131556}, {2.0502369855720155`, 
      1.443747174257802}, {1.830023302758656, 1.6817643493840482`}, {
      1.7452126573819005`, 1.858368533905249}},
      SplineDegree->2]], 
     ArrowBox[BezierCurveBox[{{2.6661210553305255`, 1.2696042062216817`}, {
      2.4185497518073125`, 1.0259909741995108`}, {2.074707741083672, 
      0.9768826367519702}}]], 
     ArrowBox[{{2.6661210553305255`, 1.2696042062216817`}, {2.988440555685215,
       0.8846456395006829}}], 
     ArrowBox[BezierCurveBox[{{2.074707741083672, 0.9768826367519702}, {
      2.322279044606884, 1.2204958687780534`}, {2.6661210553305255`, 
      1.2696042062216817`}}]], 
     ArrowBox[BezierCurveBox[{{2.074707741083672, 0.9768826367519702}, {
      1.8898250331214352`, 1.0983895012180958`}, {1.3983220839030206`, 
      1.2090787953145516`}, {0.9068191346846057, 1.3197680894110075`}, {0., 
      1.8457043169375775`}},
      SplineDegree->2]], 
     ArrowBox[BezierCurveBox[{{2.074707741083672, 0.9768826367519702}, {
      2.2238998098280542`, 0.7290281159676834}, {1.9899428633660854`, 
      0.5288620183463422}, {1.7559859169041165`, 0.328695920725001}, {
      1.492129737148785, 0.3264262019862646}},
      SplineDegree->2]], 
     ArrowBox[BezierCurveBox[{{2.074707741083672, 0.9768826367519702}, {
      2.4175099177057278`, 0.7449174102634071}, {2.5557075530502145`, 
      0.3547602468259067}}]], 
     ArrowBox[BezierCurveBox[{{1.6720061808561393`, 2.0983084223908284`}, {
      1.5889823121490017`, 1.8082758473826415`}, {1.3500134606870078`, 
      1.624140719354271}}]], 
     ArrowBox[BezierCurveBox[{{1.6720061808561393`, 2.0983084223908284`}, {
      1.43303732939414, 1.9141732943656242`}, {1.3500134606870078`, 
      1.624140719354271}}]], 
     ArrowBox[{{1.6720061808561393`, 2.0983084223908284`}, {
      1.7452126573819005`, 1.858368533905249}}], 
     ArrowBox[BezierCurveBox[{{1.6720061808561393`, 2.0983084223908284`}, {
      1.830023302758656, 1.6817643493840482`}, {2.0502369855720155`, 
      1.443747174257802}, {2.270450668385375, 1.205729999131556}, {
      2.074707741083672, 0.9768826367519702}},
      SplineDegree->2]], 
     ArrowBox[{{2.988440555685215, 0.8846456395006829}, {3.449123719962663, 
      0.889881250721194}}], 
     ArrowBox[{{1.492129737148785, 0.3264262019862646}, {1.48203232388784, 
      0.}}], ArrowBox[BezierCurveBox[{{1.492129737148785, 
      0.3264262019862646}, {1.3090968114090906`, 0.6500240061597159}, {
      1.3597607085653232`, 1.0335199513112217`}, {1.4104246057215557`, 
      1.4170158964627275`}, {1.3500134606870078`, 1.624140719354271}},
      SplineDegree->2]], 
     ArrowBox[BezierCurveBox[{{1.492129737148785, 0.3264262019862646}, {
      1.7559859169041165`, 0.328695920725001}, {1.9899428633660854`, 
      0.5288620183463422}, {2.2238998098280542`, 0.7290281159676834}, {
      2.6661210553305255`, 1.2696042062216817`}},
      SplineDegree->2]], 
     ArrowBox[BezierCurveBox[{{2.5557075530502145`, 0.3547602468259067}, {
      2.2129053764281577`, 0.5867254733140536}, {2.074707741083672, 
      0.9768826367519702}}]], 
     ArrowBox[BezierCurveBox[{{2.5557075530502145`, 0.3547602468259067}, {
      2.270450668385375, 1.205729999131556}, {2.0502369855720155`, 
      1.443747174257802}, {1.830023302758656, 1.6817643493840482`}, {
      1.6720061808561393`, 2.0983084223908284`}},
      SplineDegree->2]], 
     ArrowBox[BezierCurveBox[{{3.449123719962663, 0.889881250721194}, {
      3.5354291690572333`, 1.0816579550784422`}, {3.7336539087791865`, 
      1.140310640895103}, {3.8614863184889594`, 1.0828025554228597`}, {
      3.865764300845228, 0.706381471884838}, {3.7392718854509166`, 
      0.645983014002181}, {3.5397653548756685`, 0.7001155296390128}, {
      3.449123719962663, 0.889881250721194}},
      SplineDegree->7]], 
     ArrowBox[{{0.15065369894499625`, 0.30756778545367336`}, {
      0.581351628917993, 0.35483144638893627`}}], 
     ArrowBox[BezierCurveBox[{{0.15065369894499625`, 0.30756778545367336`}, {
      0.7636918589860391, 0.501008970976556}, {0.7860053629681534, 
      0.6724094640101537}, {0.8083188669502677, 0.8438099570437515}, {
      0.8306323709323821, 1.0152104500773493`}},
      SplineDegree->2]], 
     ArrowBox[{{0.15065369894499625`, 0.30756778545367336`}, {
      0.28040441066677135`, 0.004766826162299065}}], 
     ArrowBox[{{2.985821792809432, 0.4749067825550166}, {2.988440555685215, 
      0.8846456395006829}}], 
     ArrowBox[{{2.985821792809432, 0.4749067825550166}, {2.5557075530502145`, 
      0.3547602468259067}}], 
     ArrowBox[{{0.28040441066677135`, 0.004766826162299065}, {
      0.581351628917993, 0.35483144638893627`}}], 
     ArrowBox[{{2.884862502962802, 1.5002504273825863`}, {2.6661210553305255`,
       1.2696042062216817`}}]}, 
    {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[0.7]}], 
     {Hue[0.14, 1, 0.9], 
      DiskBox[{0.581351628917993, 0.35483144638893627}, 
       0.033375965287843035]}, 
     {Hue[0.14, 1, 0.9], 
      DiskBox[{1.48203232388784, 0.}, 0.033375965287843035]}, 
     {Hue[0.8, 0.6, 0.8], 
      DiskBox[{1.2880393905644567, 1.91902627158318}, 
       0.033375965287843035]}, 
     {Hue[0, 1, 0.8], 
      DiskBox[{2.687948223596029, 0.9985177774913093}, 0.033375965287843035]}, 
     {Hue[0.14, 1, 0.9], 
      DiskBox[{1.7018173766917961, 0.11832653464942933}, 
       0.033375965287843035]}, 
     {Hue[0.07, 1, 1], 
      DiskBox[{0.8306323709323821, 1.0152104500773493}, 
       0.033375965287843035]}, 
     {Hue[0.8, 0.6, 0.8], 
      DiskBox[{1.3500134606870078, 1.624140719354271}, 0.033375965287843035]}, 
     {Hue[0.8, 0.6, 0.8], 
      DiskBox[{1.7452126573819005, 1.858368533905249}, 0.033375965287843035]}, 
     {Hue[0, 1, 0.8], 
      DiskBox[{2.6661210553305255, 1.2696042062216817}, 
       0.033375965287843035]}, 
     {Hue[0, 1, 0.8], 
      DiskBox[{2.074707741083672, 0.9768826367519702}, 0.033375965287843035]}, 
     {Hue[0.07, 1, 1], 
      DiskBox[{0., 1.8457043169375775}, 0.033375965287843035]}, 
     {Hue[0.8, 0.6, 0.8], 
      DiskBox[{1.6720061808561393, 2.0983084223908284}, 
       0.033375965287843035]}, 
     {Hue[0, 1, 0.8], 
      DiskBox[{2.988440555685215, 0.8846456395006829}, 0.033375965287843035]}, 
     {Hue[0.14, 1, 0.9], 
      DiskBox[{1.492129737148785, 0.3264262019862646}, 0.033375965287843035]}, 
     {Hue[0, 1, 0.8], 
      DiskBox[{2.5557075530502145, 0.3547602468259067}, 
       0.033375965287843035]}, 
     {Hue[0, 1, 0.8], 
      DiskBox[{3.449123719962663, 0.889881250721194}, 
       0.033375965287843035]}, 
     {Hue[0.14, 1, 0.9], 
      DiskBox[{0.15065369894499625, 0.30756778545367336}, 
       0.033375965287843035]}, 
     {Hue[0, 1, 0.8], 
      DiskBox[{2.985821792809432, 0.4749067825550166}, 0.033375965287843035]}, 
     {Hue[0.14, 1, 0.9], 
      DiskBox[{0.28040441066677135, 0.004766826162299065}, 
       0.033375965287843035]}, 
     {Hue[0, 1, 0.8], 
      DiskBox[{2.884862502962802, 1.5002504273825863}, 0.033375965287843035]}, 
     {Hue[0.8, 0.6, 0.8], 
      DiskBox[{1.1154708771219215, 2.361594728512598}, 
       0.033375965287843035]}}}},
  FrameTicks->None,
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImageSize->{314.4921875, Automatic}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[15]=",ExpressionUUID->"91c2e387-fc26-4ae4-96fe-3fcb85d0d8f9"]
}, Open  ]],

Cell["\<\
The result is a graph with the exact same connections as the original, but \
with the nodes arranged to illustrate the \[OpenCurlyDoubleQuote]community \
structure\[CloseCurlyDoubleQuote] of the graph. \
\>", "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"1859df01-7e4d-4214-bd6d-03e2a47223cb"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Vocabulary", "VocabularySection",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"3fde2de1-80fb-4625-b55d-a0ee90c6423f"],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Graph",
      BaseStyle->"CodeLink"], "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        StyleBox["i", "CodeVariableLrg"], "\[Rule]", 
        StyleBox["j", "CodeVariableLrg"]}], ",", " ", 
       StyleBox["...", "GrayPointSix"]}], "}"}], "]"}], " ", Cell[
    "a graph or network of connections ", "VocabularyText",ExpressionUUID->
     "0f890800-2767-435c-9fc9-93c5e9357655"]},
   {
    RowBox[{
     ButtonBox["UndirectedGraph",
      BaseStyle->"CodeLink"], "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        StyleBox["i", "CodeVariableLrg"], "\[Rule]", 
        StyleBox["j", "CodeVariableLrg"]}], ",", " ", 
       StyleBox["...", "GrayPointSix"]}], "}"}], "]"}], " ", Cell[
    "a graph with no directions to connections ", "VocabularyText",
     ExpressionUUID->"f36dac60-df31-4fd2-817f-b8877eec145f"]},
   {
    ButtonBox["VertexLabels",
     BaseStyle->"CodeLink"], " ", Cell[TextData[{
     "an option for what vertex labels to include (e.g. ",
     ButtonBox["All",
      BaseStyle->"Link"],
     ") "
    }], "VocabularyText",ExpressionUUID->
     "4e808738-c036-492d-b454-1e4dd12f31a0"]},
   {
    RowBox[{
     ButtonBox["FindShortestPath",
      BaseStyle->"CodeLink"], "[", 
     RowBox[{
      StyleBox["graph", "CodeVariableLrg"], ",", 
      StyleBox["a", "CodeVariableLrg"], ",", 
      StyleBox["b", "CodeVariableLrg"]}], "]"}], " ", Cell[
    "find the shortest path from one node to another ", "VocabularyText",
     ExpressionUUID->"120fd77e-dd89-41f9-9142-d86d9d499cdc"]},
   {
    RowBox[{
     ButtonBox["CommunityGraphPlot",
      BaseStyle->"CodeLink"], "[", 
     StyleBox["list", "CodeVariableLrg"], "]"}], " ", Cell[
    "display a graph arranged into \[OpenCurlyDoubleQuote]communities\
\[CloseCurlyDoubleQuote] ", "VocabularyText",ExpressionUUID->
     "e861a602-0c29-481d-8d5b-66dcee10676c"]},
   {
    RowBox[{
     ButtonBox["Flatten",
      BaseStyle->"CodeLink"], "[", 
     StyleBox["list", "CodeVariableLrg"], "]"}], " ", Cell[
    "flatten out sublists in a list ", "VocabularyText",ExpressionUUID->
     "de000a17-f84a-4e5c-8f9f-889b8d07bbc1"]}
  }]], "VocabularyTable",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "Rows" -> {False, {True, True, True, True, 
      Directive[
       Thickness[1.5], "VocabDivColor"], True}, False}}},
 CellTags->
  "LastCellOfAPage",ExpressionUUID->"aa990fbb-71e1-4f80-af66-4cb6ff8868a6"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 DynamicModuleBox[{$CellContext`open$$ = False}, 
  TagBox[GridBox[{
     {
      StyleBox["\<\"Exercises\"\>",
       StripOnInput->False,
       FontSlant->"Italic"], 
      PaneBox[
       TagBox[
        ButtonBox[
         DynamicBox[ToBoxes[
           If[$CellContext`open$$, 
            Row[{
              Style["-", "ExercisePreviewButtonTextHighlight"], 
              Style[" Preview Exercises", "ExercisePreviewButtonText"]}], 
            Row[{
              Style["+", "ExercisePreviewButtonTextHighlight"], 
              Style[" Preview Exercises", "ExercisePreviewButtonText"]}]], 
           StandardForm],
          ImageSizeCache->{115., {1., 10.}}],
         Appearance->None,
         ButtonFunction:>(
          If[$CellContext`open$$, $CellContext`open$$ = 
            False, $CellContext`open$$ = True]; NotebookFind[
            EvaluationNotebook[], "ExerciseSummaryCell", Next, CellStyle, 
            WrapAround -> True, AutoScroll -> False]; FrontEndTokenExecute[
            EvaluationNotebook[], "ExpandSelection"]; FrontEndExecute[
            FrontEndToken[
             EvaluationNotebook[], "OpenCloseGroup"]]),
         Evaluator->Automatic,
         Method->"Preemptive"],
        MouseAppearanceTag["LinkHand"]],
       Alignment->Right,
       ImageSize->Full]}
    },
    AutoDelete->False,
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  DynamicModuleValues:>{}]], "ExerciseSection",
 Editable->False,
 ShowCellBracket->False,
 GeneratedCell->True,
 CellAutoOverwrite->True,
 CellChangeTimes->{3.669991951589675*^9},
 ShowStringCharacters->
  False,ExpressionUUID->"0b557a52-d63c-41ff-99f1-562e2db62131"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[GridBox[{
    {
     TagBox[GridBox[{
        {
         PaneBox[
          
          StyleBox["\<\"11 Exercises Available\"\>", "ExerciseSummaryHeading",
           
           StripOnInput->False],
          ImageMargins->{{20, 0}, {0, 10}}]},
        {
         PaneBox[
          StyleBox["\<\"with 7 extras\"\>", "ExerciseSummarySubheading",
           StripOnInput->False],
          ImageMargins->{{20, 0}, {10, 0}}]}
       },
       DefaultBaseStyle->"Column",
       GridBoxAlignment->{"Columns" -> {{Left}}},
       GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
       
       GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{0}}}],
      "Column"], 
     PaneBox[
      ButtonBox[
       StyleBox["\<\"Get Started \[RightGuillemet]\"\>", 
        "ExerciseSummaryHeading",
        StripOnInput->False],
       Appearance->None,
       ButtonFunction:>
        NotebookLocate[{"EIWL2-21-graphs-and-networks-exercises.nb", ""}],
       Evaluator->Automatic,
       Method->"Preemptive"],
      FrameMargins->{{10, 0}, {10, 10}},
      ImageSize->Full]}
   },
   AutoDelete->False,
   GridBoxAlignment->{"Columns" -> {{Left}}},
   GridBoxItemSize->{"Columns" -> {
       Scaled[0.7], 
       Scaled[0.3]}, "Rows" -> {{Automatic}}}],
  "Grid"]], "ExerciseSummaryCell",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"896ddd81-efe7-4605-b8a8-5b414487834b"],

Cell[CellGroupData[{

Cell[TextData[{
 "Make a graph consisting of a loop of 3 nodes.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "21.1", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"56a1d729-410c-44f8-9bd0-e6235e51ebce"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       GraphicsBox[
        NamespaceBox["NetworkGraphics",
         DynamicModuleBox[{Typeset`graph = HoldComplete[
           Graph[{1, 2, 3}, {{{1, 2}, {2, 3}, {3, 1}}, Null}]]}, 
          
          TagBox[GraphicsGroupBox[
            GraphicsComplexBox[{{-0.8660254037844384, -0.4999999999999994}, {
             0.8660254037844389, -0.5000000000000012}, {
             1.8369701987210297`*^-16, 1.}}, {
              {Hue[0.6, 0.7, 0.5], Opacity[0.7], Arrowheads[
               0.03555748430834104], 
               ArrowBox[{{1, 2}, {2, 3}, {3, 1}}, 0.020399597244776385`]}, 
              {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[0.7]}], 
               DiskBox[1, 0.020399597244776385], 
               DiskBox[2, 0.020399597244776385], 
               DiskBox[3, 0.020399597244776385]}}]],
           MouseAppearanceTag["NetworkGraphics"]],
          AllowKernelInitialization->False]],
        DefaultBaseStyle->{
         "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> 
          Hue[0.8, 1., 0.6]},
        FrameTicks->None,
        GridLinesStyle->Directive[
          GrayLevel[0.5, 0.4]],
        ImageSize->{251.44921875, Automatic}]], "ExerciseOutput",
       ExpressionUUID->"6042ff72-3ab1-414c-a439-0bd25c94c0e1"],
      Apply[TextCell, 
       Cell[
        BoxData[
         GraphicsBox[
          NamespaceBox["NetworkGraphics", 
           DynamicModuleBox[{Typeset`graph = HoldComplete[
               Graph[{1, 2, 3}, {{{1, 2}, {2, 3}, {3, 1}}, Null}]]}, 
            TagBox[
             GraphicsGroupBox[{
               
               GraphicsComplexBox[{{-0.8660254037844384, \
-0.4999999999999994}, {0.8660254037844389, -0.5000000000000012}, {
                1.8369701987210297`*^-16, 1.}}, {{{{{
                    Hue[0.6, 0.7, 0.5], 
                    Opacity[0.7], 
                    Arrowheads[0.03555748430834104], 
                    
                    ArrowBox[{{1, 2}, {2, 3}, {3, 1}}, 
                    0.020399597244776385`]}}}}, {{{{
                    Hue[0.6, 0.2, 0.8], 
                    EdgeForm[{
                    GrayLevel[0], 
                    Opacity[0.7]}], 
                    DiskBox[1, 0.020399597244776385`], 
                    DiskBox[2, 0.020399597244776385`], 
                    DiskBox[3, 0.020399597244776385`]}}}}}]}], 
             MouseAppearanceTag["NetworkGraphics"]], 
            AllowKernelInitialization -> False]], 
          DefaultBaseStyle -> {
           "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> 
            Hue[0.8, 1., 0.6]}, FrameTicks -> None, GridLinesStyle -> 
          Directive[
            GrayLevel[0.5, 0.4]], ImageSize -> {251.44921875, Automatic}]], 
        "ExerciseOutput", Selectable -> False, Copyable -> False, Editable -> 
        False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"b31bacad-03dd-4527-b4e9-6c6c82f2d312"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Make a graph with 4 nodes in which every node is connected.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "21.2", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"38764a98-65cb-4e71-9f6f-1dfec92ddb95"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       GraphicsBox[
        NamespaceBox["NetworkGraphics",
         DynamicModuleBox[{Typeset`graph = HoldComplete[
           
           Graph[{1, 2, 3, 
            4}, {{{1, 1}, {1, 2}, {1, 3}, {1, 4}, {2, 1}, {2, 2}, {2, 3}, {2, 
             4}, {3, 1}, {3, 2}, {3, 3}, {3, 4}, {4, 1}, {4, 2}, {4, 3}, {4, 
             4}}, Null}]]}, 
          TagBox[GraphicsGroupBox[GraphicsComplexBox[CompressedData["
1:eJw9l3lUzV3Ux6+hIj2eaJCQkqFJkmgg3yTkKcpTSEJKEanEQ0QKiRRJoqR5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             "], {
              {Hue[0.6, 0.7, 0.5], Opacity[0.7], Arrowheads[
               0.04281987102487267], 
               ArrowBox[BezierCurveBox[{1, 8, 11, 13, 19, 21, 24, 1},
                SplineDegree->7], 0.011203619719880126`], 
               ArrowBox[BezierCurveBox[{
                1, {0.44883264576791826`, -0.13596794329641698`}, 2}], 
                0.011203619719880126`], 
               ArrowBox[BezierCurveBox[{
                1, {0.7309949895486002, 0.4433180284956463}, 3}], 
                0.011203619719880126`], 
               ArrowBox[BezierCurveBox[{
                1, {0.29986003504833547`, 0.2946889433269365}, 4}], 
                0.011203619719880126`], 
               ArrowBox[BezierCurveBox[{
                2, {0.4445058597386266, 0.14912400742106555`}, 1}], 
                0.011203619719880126`], 
               ArrowBox[BezierCurveBox[{2, 95, 98, 100, 106, 108, 111, 2},
                SplineDegree->7], 0.011203619719880126`], 
               ArrowBox[BezierCurveBox[{
                2, {0.29540503468548973`, 0.5792859717922063}, 3}], 
                0.011203619719880126`], 
               ArrowBox[BezierCurveBox[{
                2, {-0.1357299198147777, 0.4306568866233442}, 4}], 
                0.011203619719880126`], 
               ArrowBox[BezierCurveBox[{
                3, {1.0154287821569952`, 0.44784602204377333`}, 1}], 
                0.011203619719880126`], 
               ArrowBox[BezierCurveBox[{
                3, {0.5841656133231781, 0.29872201462287473`}, 2}], 
                0.011203619719880126`], 
               ArrowBox[BezierCurveBox[{3, 182, 185, 187, 193, 195, 198, 3},
                SplineDegree->7], 0.011203619719880126`], 
               ArrowBox[BezierCurveBox[{
                3, {0.43519300260359495`, 0.7293789012466422}, 4}], 
                0.011203619719880126`], 
               ArrowBox[BezierCurveBox[{
                4, {0.5802357795534063, 0.5841361700185372}, 1}], 
                0.011203619719880126`], 
               ArrowBox[BezierCurveBox[{
                4, {0.1489726107195836, 0.4350121625975511}, 2}], 
                0.011203619719880126`], 
               ArrowBox[BezierCurveBox[{
                4, {0.4311349545002647, 1.014298134389481}, 3}], 
                0.011203619719880126`], 
               ArrowBox[BezierCurveBox[{4, 269, 272, 274, 280, 282, 285, 4},
                SplineDegree->7], 0.011203619719880126`]}, 
              {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[0.7]}], 
               DiskBox[1, 0.011203619719880126], 
               DiskBox[2, 0.011203619719880126], 
               DiskBox[3, 0.011203619719880126], 
               DiskBox[4, 0.011203619719880126]}}]],
           MouseAppearanceTag["NetworkGraphics"]],
          AllowKernelInitialization->False]],
        DefaultBaseStyle->{
         "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> 
          Hue[0.8, 1., 0.6]},
        FrameTicks->None,
        GridLinesStyle->Directive[
          GrayLevel[0.5, 0.4]],
        ImageSize->{260.11328125, Automatic}]], "ExerciseOutput",
       ExpressionUUID->"3fb3f14a-90f7-4866-b8bd-4fb5f66a11c4"],
      Apply[TextCell, 
       Cell[
        BoxData[
         GraphicsBox[
          NamespaceBox["NetworkGraphics", 
           DynamicModuleBox[{Typeset`graph = HoldComplete[
               
               Graph[{1, 2, 3, 
                4}, {{{1, 1}, {1, 2}, {1, 3}, {1, 4}, {2, 1}, {2, 2}, {2, 
                 3}, {2, 4}, {3, 1}, {3, 2}, {3, 3}, {3, 4}, {4, 1}, {4, 2}, {
                 4, 3}, {4, 4}}, Null}]]}, 
            TagBox[
             GraphicsGroupBox[{
               GraphicsComplexBox[CompressedData["
1:eJw9l3lUzV3Ux6+hIj2eaJCQkqFJkmgg3yTkKcpTSEJKEanEQ0QKiRRJoqR5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                "], {{{{{
                    Hue[0.6, 0.7, 0.5], 
                    Opacity[0.7], 
                    Arrowheads[0.04281987102487267], 
                    ArrowBox[
                    
                    BezierCurveBox[{1, 8, 11, 13, 19, 21, 24, 1}, 
                    SplineDegree -> 7], 0.011203619719880126`], 
                    ArrowBox[
                    
                    BezierCurveBox[{
                    1, {0.44883264576791826`, -0.13596794329641698`}, 2}], 
                    0.011203619719880126`], 
                    ArrowBox[
                    
                    BezierCurveBox[{
                    1, {0.7309949895486002, 0.4433180284956463}, 3}], 
                    0.011203619719880126`], 
                    ArrowBox[
                    
                    BezierCurveBox[{
                    1, {0.29986003504833547`, 0.2946889433269365}, 4}], 
                    0.011203619719880126`], 
                    ArrowBox[
                    
                    BezierCurveBox[{
                    2, {0.4445058597386266, 0.14912400742106555`}, 1}], 
                    0.011203619719880126`], 
                    ArrowBox[
                    
                    BezierCurveBox[{2, 95, 98, 100, 106, 108, 111, 2}, 
                    SplineDegree -> 7], 0.011203619719880126`], 
                    ArrowBox[
                    
                    BezierCurveBox[{
                    2, {0.29540503468548973`, 0.5792859717922063}, 3}], 
                    0.011203619719880126`], 
                    ArrowBox[
                    
                    BezierCurveBox[{
                    2, {-0.1357299198147777, 0.4306568866233442}, 4}], 
                    0.011203619719880126`], 
                    ArrowBox[
                    BezierCurveBox[{
                    3, {1.0154287821569952`, 0.44784602204377333`}, 1}], 
                    0.011203619719880126`], 
                    ArrowBox[
                    
                    BezierCurveBox[{
                    3, {0.5841656133231781, 0.29872201462287473`}, 2}], 
                    0.011203619719880126`], 
                    ArrowBox[
                    
                    BezierCurveBox[{3, 182, 185, 187, 193, 195, 198, 3}, 
                    SplineDegree -> 7], 0.011203619719880126`], 
                    ArrowBox[
                    
                    BezierCurveBox[{
                    3, {0.43519300260359495`, 0.7293789012466422}, 4}], 
                    0.011203619719880126`], 
                    ArrowBox[
                    
                    BezierCurveBox[{
                    4, {0.5802357795534063, 0.5841361700185372}, 1}], 
                    0.011203619719880126`], 
                    ArrowBox[
                    
                    BezierCurveBox[{
                    4, {0.1489726107195836, 0.4350121625975511}, 2}], 
                    0.011203619719880126`], 
                    ArrowBox[
                    
                    BezierCurveBox[{
                    4, {0.4311349545002647, 1.014298134389481}, 3}], 
                    0.011203619719880126`], 
                    ArrowBox[
                    
                    BezierCurveBox[{4, 269, 272, 274, 280, 282, 285, 4}, 
                    SplineDegree -> 7], 0.011203619719880126`]}}}}, {{{{
                    Hue[0.6, 0.2, 0.8], 
                    EdgeForm[{
                    GrayLevel[0], 
                    Opacity[0.7]}], 
                    DiskBox[1, 0.011203619719880126`], 
                    DiskBox[2, 0.011203619719880126`], 
                    DiskBox[3, 0.011203619719880126`], 
                    DiskBox[4, 0.011203619719880126`]}}}}}]}], 
             MouseAppearanceTag["NetworkGraphics"]], 
            AllowKernelInitialization -> False]], 
          DefaultBaseStyle -> {
           "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> 
            Hue[0.8, 1., 0.6]}, FrameTicks -> None, GridLinesStyle -> 
          Directive[
            GrayLevel[0.5, 0.4]], ImageSize -> {260.11328125, Automatic}]], 
        "ExerciseOutput", Selectable -> False, Copyable -> False, Editable -> 
        False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"fd329010-db9b-48fc-8e08-78332a538c4b"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Make a table of undirected graphs with between 2 and 10 nodes in which \
every node is connected.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "21.3", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"5164f0c2-6235-43fa-88aa-0ea2f4048342"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       RowBox[{"{", 
        RowBox[{
         GraphicsBox[
          NamespaceBox["NetworkGraphics",
           DynamicModuleBox[{Typeset`graph = HoldComplete[
             
             Graph[{1, 2}, {
              Null, SparseArray[
               Automatic, {2, 2}, 0, {
                1, {{0, 2, 3}, {{1}, {2}, {2}}}, {1, 1, 1}}]}]]}, 
            TagBox[GraphicsGroupBox[GraphicsComplexBox[CompressedData["
1:eJxTTMoPSmViYGAwAGIQDQEf7BnQAHuMiLHasoU22Wul1zkA5T+fdDcKFi2w
3xzE1H1J94O98eXg+rnPN9mLyFduu73yg73l981et5YctHfY42mZmfXR/voL
KZcZ2SfsXdvv63AmfLK/9bbF/bHNWfvGvQoP2cs/25/I7Ttwbut5+0PaEjks
M7/Y/+WbaTNt8Xl7IS1Fgz3rvtrnGIY9XM9+1v6n3aqaFwu/2cvv+Je5TvyE
fcHMxz/Z47/bOziWC3+1OGj/Rn2+3vtr3+2lrf9laH/cCPXHD3sm8aM9nZlH
bN5C5c9YgeX3F0H1S0H07/8NNf/fdrD5+0Wg9gdA7N9/BOq+ZxD37W+Bun87
xP373aH+Ow/x334nqP9PQ/y/XwwaPmaQ8NkPCz9lSPjth4XvJ0j47me4EPW6
TVtgfyqUPyFSs9H1Zdt+Laj6OY+Uz5dZL91vAjVP7MjsKZOXbdt/EWqfntWf
NE+Gw/svQt0j8oaV037H6f17oO7lWZ+wQTDl0v53UP/4rGg58GHXtf0xUP++
+L3i08L2W/t5IOG9/0hq33P5mrv7taHhtWl+za490ff3v4eGJyS8H+yHpJeJ
NjB5Bmh8HIXq14fGF8x8QWh8+kLtT4TGN8x9X6DpQRzq/sPQ9GIA9d8NaHqS
gPoflt4WQMPHBpoeC6DhpwtNr7DwbTgFSc8AbuqF6Q==
               "], {
                {Hue[0.6, 0.7, 0.5], Opacity[0.7], 
                 {Arrowheads[0.], 
                  ArrowBox[BezierCurveBox[{1, 6, 9, 11, 17, 19, 22, 1},
                   SplineDegree->7], 0.01273]}, 
                 {Arrowheads[0.], ArrowBox[{1, 2}, 0.01273]}, 
                 {Arrowheads[0.], 
                  ArrowBox[BezierCurveBox[{2, 29, 32, 34, 40, 42, 45, 2},
                   SplineDegree->7], 0.01273]}}, 
                {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[0.7]}], 
                 DiskBox[1, 0.01273], DiskBox[2, 0.01273]}}]],
             MouseAppearanceTag["NetworkGraphics"]],
            AllowKernelInitialization->False]],
          
          DefaultBaseStyle->{
           "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> 
            Hue[0.8, 1., 0.6]},
          FormatType->TraditionalForm,
          FrameTicks->None,
          GridLinesStyle->Directive[
            GrayLevel[0.5, 0.4]]], ",", 
         GraphicsBox[
          NamespaceBox["NetworkGraphics",
           DynamicModuleBox[{Typeset`graph = HoldComplete[
             
             Graph[{1, 2, 3}, {
              Null, SparseArray[
               Automatic, {3, 3}, 0, {
                1, {{0, 3, 5, 6}, {{1}, {2}, {3}, {2}, {3}, {3}}}, {1, 1, 1, 
                 1, 1, 1}}]}]]}, 
            TagBox[GraphicsGroupBox[GraphicsComplexBox[CompressedData["
1:eJw1UntMk1cU/5RQkqFxK2RhShZfAf5QaAgSiehBEFGHYQIuRqxAoRU3KyRA
pYgRnbbEIDImMgERXJbgKxIzYAkzp5D6HCICFWqDIDCgFLWtlNIW7OSebze5
uTm5957ze62RZCdKl3Ict+vzXjwb4w9MFraY0OZeXEN4l2rw5hbXMH5xoS4+
QnkrkpWcGSRDgSXpNSZc6BUuaRINY1NSdoh32BTGNKTK/3k9irtSChpXjxhR
dsRh8NROoGoiXxB2Zwp9d/jYV9SasH6ypn/F2Wn09b0rdvl8wO71e5we2z5g
R5KuOc5qxsSMHI0tyYJB3YUDbqMFtzwpffIq8iN2vrmWGSe2YktGv+R4qA1D
LR2ioWgrTmstXcXL7Hgw7d7Jf2st+OdxryNef8xhjc+o/FaBGX8I2JC31eDA
vex8h9H7g5dvv+JE8TPZ5bHwKRQlfuUlfOzEieiHQT4J4/i04bTr4VEnxj4S
VLhyR7DZFdw0cN6Bv3gqNJXGQTwmER2r2DiHbYWeXnWhAxgirSwrL5rFnsLT
LVmb+zB+MOjnssoZVFcJuxvie9CodJbXXrdijOCTuu1KD26XqVsXOsxY1D4W
p/1Sh2OChFH9d+/x4/6otmG1HvOqg8V+vSbU7H62Kq1+CFPusxrsUqqT/dl7
gAJ6n5LN+kHsJPULPMPmgSqE5v06wvDA1+2EpzyL4YUTNwivfybjA7I64rNs
nvEF1TriG0l6gOYl6RG7j+kFJXtIL3Uy0xO+6SI9eb0hndfblM38gJVC8qPt
MfMLmsXk1+Es5ieMvyM/9V3Mb5AayG/9TywPEPac8rAzguUFtPsoLzo3yxNM
CylPFZxiMW8g20l5+zaf5REuyimP4XKWV/j+NuW12M7yDK1vKc9zOX+tMxhO
Yqf7gcfmz3k/5H+TO5WqwZYDb1YHJpjhQpWycfxSF6qcxutcgAWmCuZbUwN0
mJY/3F6Sa4XQjKt/Fyfq8YRkC37ynwFV+JK9NxUG7FSXronmZmFTb67ircyA
Sj8P9aVZO6xNzomRr9fjK0dcdW2/A4ptLx7cH+xDd6lI1lvkAm/pxZSluufY
YXnd+KN2Hqw3nAI/X8T6vHO/rbq8AGUzOw4pr3ZGku4LkPk7u4c6/j6K/kM7
/7+a+sM83z+C5kMfP3834QMFj6+K8MNTHn8U8YN8np+N+MNhnv810gfO8/qk
k37QzOu3PJfpC//r+x/Wi3vt
               "], {
                {Hue[0.6, 0.7, 0.5], Opacity[0.7], 
                 {Arrowheads[0.], 
                  ArrowBox[BezierCurveBox[{1, 7, 10, 12, 18, 20, 23, 1},
                   SplineDegree->7], 0.020399597244776385`]}, 
                 {Arrowheads[0.], ArrowBox[{1, 2}, 0.020399597244776385`]}, 
                 {Arrowheads[0.], ArrowBox[{1, 3}, 0.020399597244776385`]}, 
                 {Arrowheads[0.], 
                  ArrowBox[BezierCurveBox[{2, 30, 33, 35, 41, 43, 46, 2},
                   SplineDegree->7], 0.020399597244776385`]}, 
                 {Arrowheads[0.], ArrowBox[{2, 3}, 0.020399597244776385`]}, 
                 {Arrowheads[0.], 
                  ArrowBox[BezierCurveBox[{3, 53, 56, 58, 64, 66, 69, 3},
                   SplineDegree->7], 0.020399597244776385`]}}, 
                {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[0.7]}], 
                 DiskBox[1, 0.020399597244776385], 
                 DiskBox[2, 0.020399597244776385], 
                 DiskBox[3, 0.020399597244776385]}}]],
             MouseAppearanceTag["NetworkGraphics"]],
            AllowKernelInitialization->False]],
          
          DefaultBaseStyle->{
           "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> 
            Hue[0.8, 1., 0.6]},
          FormatType->TraditionalForm,
          FrameTicks->None,
          GridLinesStyle->Directive[
            GrayLevel[0.5, 0.4]]], ",", 
         GraphicsBox[
          NamespaceBox["NetworkGraphics",
           DynamicModuleBox[{Typeset`graph = HoldComplete[
             
             Graph[{1, 2, 3, 4}, {
              Null, SparseArray[
               Automatic, {4, 4}, 0, {
                1, {{0, 4, 7, 9, 10}, {{1}, {2}, {3}, {4}, {2}, {3}, {4}, {
                  3}, {4}, {4}}}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1}}]}]]}, 
            TagBox[GraphicsGroupBox[GraphicsComplexBox[CompressedData["
1:eJw9k3s01AkUxyeFUhttqdHDIakmVlYq5lTXI5akmUqPJYkyKcKq1ZNViKQT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               "], {
                {Hue[0.6, 0.7, 0.5], Opacity[0.7], 
                 {Arrowheads[0.], 
                  ArrowBox[BezierCurveBox[{1, 8, 11, 13, 19, 21, 24, 1},
                   SplineDegree->7], 0.011203619719880126`]}, 
                 {Arrowheads[0.], ArrowBox[{1, 2}, 0.011203619719880126`]}, 
                 {Arrowheads[0.], ArrowBox[{1, 3}, 0.011203619719880126`]}, 
                 {Arrowheads[0.], ArrowBox[{1, 4}, 0.011203619719880126`]}, 
                 {Arrowheads[0.], 
                  ArrowBox[BezierCurveBox[{2, 31, 34, 36, 42, 44, 47, 2},
                   SplineDegree->7], 0.011203619719880126`]}, 
                 {Arrowheads[0.], ArrowBox[{2, 3}, 0.011203619719880126`]}, 
                 {Arrowheads[0.], ArrowBox[{2, 4}, 0.011203619719880126`]}, 
                 {Arrowheads[0.], 
                  ArrowBox[BezierCurveBox[{3, 54, 57, 59, 65, 67, 70, 3},
                   SplineDegree->7], 0.011203619719880126`]}, 
                 {Arrowheads[0.], ArrowBox[{3, 4}, 0.011203619719880126`]}, 
                 {Arrowheads[0.], 
                  ArrowBox[BezierCurveBox[{4, 77, 80, 82, 88, 90, 93, 4},
                   SplineDegree->7], 0.011203619719880126`]}}, 
                {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[0.7]}], 
                 DiskBox[1, 0.011203619719880126], 
                 DiskBox[2, 0.011203619719880126], 
                 DiskBox[3, 0.011203619719880126], 
                 DiskBox[4, 0.011203619719880126]}}]],
             MouseAppearanceTag["NetworkGraphics"]],
            AllowKernelInitialization->False]],
          
          DefaultBaseStyle->{
           "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> 
            Hue[0.8, 1., 0.6]},
          FormatType->TraditionalForm,
          FrameTicks->None,
          GridLinesStyle->Directive[
            GrayLevel[0.5, 0.4]]], ",", 
         GraphicsBox[
          NamespaceBox["NetworkGraphics",
           DynamicModuleBox[{Typeset`graph = HoldComplete[
             Graph[{1, 2, 3, 4, 5}, {
              Null, SparseArray[
               Automatic, {5, 5}, 0, {
                1, {{0, 5, 9, 12, 14, 15}, {{1}, {2}, {3}, {4}, {5}, {2}, {
                  3}, {4}, {5}, {3}, {4}, {5}, {4}, {5}, {5}}}, {1, 1, 1, 1, 
                 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}}]}]]}, 
            TagBox[GraphicsGroupBox[GraphicsComplexBox[CompressedData["
1:eJw9lHk01XkDxg3DqyJLtpKluoW6NKGSmeZB3hSjSE0qIyNbk2gxk0FN2Un2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               "], {
                {Hue[0.6, 0.7, 0.5], Opacity[0.7], 
                 {Arrowheads[0.], 
                  ArrowBox[BezierCurveBox[{1, 9, 12, 14, 20, 22, 25, 1},
                   SplineDegree->7], 0.015799942848996912`]}, 
                 {Arrowheads[0.], ArrowBox[{1, 2}, 0.015799942848996912`]}, 
                 {Arrowheads[0.], ArrowBox[{1, 3}, 0.015799942848996912`]}, 
                 {Arrowheads[0.], ArrowBox[{1, 4}, 0.015799942848996912`]}, 
                 {Arrowheads[0.], ArrowBox[{1, 5}, 0.015799942848996912`]}, 
                 {Arrowheads[0.], 
                  ArrowBox[BezierCurveBox[{2, 32, 35, 37, 43, 45, 48, 2},
                   SplineDegree->7], 0.015799942848996912`]}, 
                 {Arrowheads[0.], ArrowBox[{2, 3}, 0.015799942848996912`]}, 
                 {Arrowheads[0.], ArrowBox[{2, 4}, 0.015799942848996912`]}, 
                 {Arrowheads[0.], ArrowBox[{2, 5}, 0.015799942848996912`]}, 
                 {Arrowheads[0.], 
                  ArrowBox[BezierCurveBox[{3, 55, 58, 60, 66, 68, 71, 3},
                   SplineDegree->7], 0.015799942848996912`]}, 
                 {Arrowheads[0.], ArrowBox[{3, 4}, 0.015799942848996912`]}, 
                 {Arrowheads[0.], ArrowBox[{3, 5}, 0.015799942848996912`]}, 
                 {Arrowheads[0.], 
                  ArrowBox[BezierCurveBox[{4, 78, 81, 83, 89, 91, 94, 4},
                   SplineDegree->7], 0.015799942848996912`]}, 
                 {Arrowheads[0.], ArrowBox[{4, 5}, 0.015799942848996912`]}, 
                 {Arrowheads[0.], 
                  ArrowBox[BezierCurveBox[{5, 101, 104, 106, 112, 114, 117, 5},
                   SplineDegree->7], 0.015799942848996912`]}}, 
                {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[0.7]}], 
                 DiskBox[1, 0.015799942848996912], 
                 DiskBox[2, 0.015799942848996912], 
                 DiskBox[3, 0.015799942848996912], 
                 DiskBox[4, 0.015799942848996912], 
                 DiskBox[5, 0.015799942848996912]}}]],
             MouseAppearanceTag["NetworkGraphics"]],
            AllowKernelInitialization->False]],
          
          DefaultBaseStyle->{
           "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> 
            Hue[0.8, 1., 0.6]},
          FormatType->TraditionalForm,
          FrameTicks->None,
          GridLinesStyle->Directive[
            GrayLevel[0.5, 0.4]]], ",", 
         GraphicsBox[
          NamespaceBox["NetworkGraphics",
           DynamicModuleBox[{Typeset`graph = HoldComplete[
             
             Graph[{1, 2, 3, 4, 5, 6}, {
              Null, SparseArray[
               Automatic, {6, 6}, 0, {
                1, {{0, 6, 11, 15, 18, 20, 21}, {{1}, {2}, {3}, {4}, {5}, {
                  6}, {2}, {3}, {4}, {5}, {6}, {3}, {4}, {5}, {6}, {4}, {5}, {
                  6}, {5}, {6}, {6}}}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                  1, 1, 1, 1, 1, 1, 1, 1}}]}]]}, 
            TagBox[GraphicsGroupBox[GraphicsComplexBox[CompressedData["
1:eJw9lXk0FfoWxzm3kIR0CuUWN0OpXOUayvCVNOklKUpJUujJ1HDdlEJFdBHl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               "], {
                {Hue[0.6, 0.7, 0.5], Opacity[0.7], 
                 {Arrowheads[0.], 
                  ArrowBox[BezierCurveBox[{1, 10, 13, 15, 21, 23, 26, 1},
                   SplineDegree->7], 0.016581374985794817`]}, 
                 {Arrowheads[0.], ArrowBox[{1, 2}, 0.016581374985794817`]}, 
                 {Arrowheads[0.], ArrowBox[{1, 3}, 0.016581374985794817`]}, 
                 {Arrowheads[0.], ArrowBox[{1, 4}, 0.016581374985794817`]}, 
                 {Arrowheads[0.], ArrowBox[{1, 5}, 0.016581374985794817`]}, 
                 {Arrowheads[0.], ArrowBox[{1, 6}, 0.016581374985794817`]}, 
                 {Arrowheads[0.], 
                  ArrowBox[BezierCurveBox[{2, 33, 36, 38, 44, 46, 49, 2},
                   SplineDegree->7], 0.016581374985794817`]}, 
                 {Arrowheads[0.], ArrowBox[{2, 3}, 0.016581374985794817`]}, 
                 {Arrowheads[0.], ArrowBox[{2, 4}, 0.016581374985794817`]}, 
                 {Arrowheads[0.], ArrowBox[{2, 5}, 0.016581374985794817`]}, 
                 {Arrowheads[0.], ArrowBox[{2, 6}, 0.016581374985794817`]}, 
                 {Arrowheads[0.], 
                  ArrowBox[BezierCurveBox[{3, 56, 59, 61, 67, 69, 72, 3},
                   SplineDegree->7], 0.016581374985794817`]}, 
                 {Arrowheads[0.], ArrowBox[{3, 4}, 0.016581374985794817`]}, 
                 {Arrowheads[0.], ArrowBox[{3, 5}, 0.016581374985794817`]}, 
                 {Arrowheads[0.], ArrowBox[{3, 6}, 0.016581374985794817`]}, 
                 {Arrowheads[0.], 
                  ArrowBox[BezierCurveBox[{4, 79, 82, 84, 90, 92, 95, 4},
                   SplineDegree->7], 0.016581374985794817`]}, 
                 {Arrowheads[0.], ArrowBox[{4, 5}, 0.016581374985794817`]}, 
                 {Arrowheads[0.], ArrowBox[{4, 6}, 0.016581374985794817`]}, 
                 {Arrowheads[0.], 
                  ArrowBox[BezierCurveBox[{5, 102, 105, 107, 113, 115, 118, 5},
                   SplineDegree->7], 0.016581374985794817`]}, 
                 {Arrowheads[0.], ArrowBox[{5, 6}, 0.016581374985794817`]}, 
                 {Arrowheads[0.], 
                  ArrowBox[BezierCurveBox[{6, 125, 128, 130, 136, 138, 141, 6},
                   SplineDegree->7], 0.016581374985794817`]}}, 
                {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[0.7]}], 
                 DiskBox[1, 0.016581374985794817], 
                 DiskBox[2, 0.016581374985794817], 
                 DiskBox[3, 0.016581374985794817], 
                 DiskBox[4, 0.016581374985794817], 
                 DiskBox[5, 0.016581374985794817], 
                 DiskBox[6, 0.016581374985794817]}}]],
             MouseAppearanceTag["NetworkGraphics"]],
            AllowKernelInitialization->False]],
          
          DefaultBaseStyle->{
           "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> 
            Hue[0.8, 1., 0.6]},
          FormatType->TraditionalForm,
          FrameTicks->None,
          GridLinesStyle->Directive[
            GrayLevel[0.5, 0.4]]], ",", 
         GraphicsBox[
          NamespaceBox["NetworkGraphics",
           DynamicModuleBox[{Typeset`graph = HoldComplete[
             
             Graph[{1, 2, 3, 4, 5, 6, 7}, {
              Null, SparseArray[
               Automatic, {7, 7}, 0, {
                1, {{0, 7, 13, 18, 22, 25, 27, 28}, {{1}, {2}, {3}, {4}, {
                  5}, {6}, {7}, {2}, {3}, {4}, {5}, {6}, {7}, {3}, {4}, {5}, {
                  6}, {7}, {4}, {5}, {6}, {7}, {5}, {6}, {7}, {6}, {7}, {
                  7}}}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                  1, 1, 1, 1, 1, 1, 1, 1, 1, 1}}]}]]}, 
            TagBox[GraphicsGroupBox[GraphicsComplexBox[CompressedData["
1:eJw1lnk4FPoXxskSrnITZalwEyXVlJQtL/1ar0giUooSkkqKVIQoWrS5Ecna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               "], {
                {Hue[0.6, 0.7, 0.5], Opacity[0.7], 
                 {Arrowheads[0.], 
                  ArrowBox[BezierCurveBox[{1, 11, 14, 16, 22, 24, 27, 1},
                   SplineDegree->7], 0.01767595102569003]}, 
                 {Arrowheads[0.], ArrowBox[{1, 2}, 0.01767595102569003]}, 
                 {Arrowheads[0.], ArrowBox[{1, 3}, 0.01767595102569003]}, 
                 {Arrowheads[0.], ArrowBox[{1, 4}, 0.01767595102569003]}, 
                 {Arrowheads[0.], ArrowBox[{1, 5}, 0.01767595102569003]}, 
                 {Arrowheads[0.], ArrowBox[{1, 6}, 0.01767595102569003]}, 
                 {Arrowheads[0.], ArrowBox[{1, 7}, 0.01767595102569003]}, 
                 {Arrowheads[0.], 
                  ArrowBox[BezierCurveBox[{2, 34, 37, 39, 45, 47, 50, 2},
                   SplineDegree->7], 0.01767595102569003]}, 
                 {Arrowheads[0.], ArrowBox[{2, 3}, 0.01767595102569003]}, 
                 {Arrowheads[0.], ArrowBox[{2, 4}, 0.01767595102569003]}, 
                 {Arrowheads[0.], ArrowBox[{2, 5}, 0.01767595102569003]}, 
                 {Arrowheads[0.], ArrowBox[{2, 6}, 0.01767595102569003]}, 
                 {Arrowheads[0.], ArrowBox[{2, 7}, 0.01767595102569003]}, 
                 {Arrowheads[0.], 
                  ArrowBox[BezierCurveBox[{3, 57, 60, 62, 68, 70, 73, 3},
                   SplineDegree->7], 0.01767595102569003]}, 
                 {Arrowheads[0.], ArrowBox[{3, 4}, 0.01767595102569003]}, 
                 {Arrowheads[0.], ArrowBox[{3, 5}, 0.01767595102569003]}, 
                 {Arrowheads[0.], ArrowBox[{3, 6}, 0.01767595102569003]}, 
                 {Arrowheads[0.], ArrowBox[{3, 7}, 0.01767595102569003]}, 
                 {Arrowheads[0.], 
                  ArrowBox[BezierCurveBox[{4, 80, 83, 85, 91, 93, 96, 4},
                   SplineDegree->7], 0.01767595102569003]}, 
                 {Arrowheads[0.], ArrowBox[{4, 5}, 0.01767595102569003]}, 
                 {Arrowheads[0.], ArrowBox[{4, 6}, 0.01767595102569003]}, 
                 {Arrowheads[0.], ArrowBox[{4, 7}, 0.01767595102569003]}, 
                 {Arrowheads[0.], 
                  ArrowBox[BezierCurveBox[{5, 103, 106, 108, 114, 116, 119, 5},
                   SplineDegree->7], 0.01767595102569003]}, 
                 {Arrowheads[0.], ArrowBox[{5, 6}, 0.01767595102569003]}, 
                 {Arrowheads[0.], ArrowBox[{5, 7}, 0.01767595102569003]}, 
                 {Arrowheads[0.], 
                  ArrowBox[BezierCurveBox[{6, 126, 129, 131, 137, 139, 142, 6},
                   SplineDegree->7], 0.01767595102569003]}, 
                 {Arrowheads[0.], ArrowBox[{6, 7}, 0.01767595102569003]}, 
                 {Arrowheads[0.], 
                  ArrowBox[BezierCurveBox[{7, 149, 152, 154, 160, 162, 165, 7},
                   SplineDegree->7], 0.01767595102569003]}}, 
                {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[0.7]}], 
                 DiskBox[1, 0.01767595102569003], 
                 DiskBox[2, 0.01767595102569003], 
                 DiskBox[3, 0.01767595102569003], 
                 DiskBox[4, 0.01767595102569003], 
                 DiskBox[5, 0.01767595102569003], 
                 DiskBox[6, 0.01767595102569003], 
                 DiskBox[7, 0.01767595102569003]}}]],
             MouseAppearanceTag["NetworkGraphics"]],
            AllowKernelInitialization->False]],
          
          DefaultBaseStyle->{
           "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> 
            Hue[0.8, 1., 0.6]},
          FormatType->TraditionalForm,
          FrameTicks->None,
          GridLinesStyle->Directive[
            GrayLevel[0.5, 0.4]]], ",", 
         GraphicsBox[
          NamespaceBox["NetworkGraphics",
           DynamicModuleBox[{Typeset`graph = HoldComplete[
             
             Graph[{1, 2, 3, 4, 5, 6, 7, 8}, {
              Null, SparseArray[
               Automatic, {8, 8}, 0, {
                1, {{0, 8, 15, 21, 26, 30, 33, 35, 36}, {{1}, {2}, {3}, {4}, {
                  5}, {6}, {7}, {8}, {2}, {3}, {4}, {5}, {6}, {7}, {8}, {3}, {
                  4}, {5}, {6}, {7}, {8}, {4}, {5}, {6}, {7}, {8}, {5}, {6}, {
                  7}, {8}, {6}, {7}, {8}, {7}, {8}, {8}}}, {1, 1, 1, 1, 1, 1, 
                 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
                 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}}]}]]}, 
            TagBox[GraphicsGroupBox[GraphicsComplexBox[CompressedData["
1:eJw9Vnk4FPr3VqK4QtlahSYiSbaK6vV13VSILN3qWkIpIS0SdRMlOykp4bYK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               "], {
                {Hue[0.6, 0.7, 0.5], Opacity[0.7], 
                 {Arrowheads[0.], 
                  ArrowBox[BezierCurveBox[{1, 12, 15, 17, 23, 25, 28, 1},
                   SplineDegree->7], 0.017362936827810344`]}, 
                 {Arrowheads[0.], ArrowBox[{1, 2}, 0.017362936827810344`]}, 
                 {Arrowheads[0.], ArrowBox[{1, 3}, 0.017362936827810344`]}, 
                 {Arrowheads[0.], ArrowBox[{1, 4}, 0.017362936827810344`]}, 
                 {Arrowheads[0.], ArrowBox[{1, 5}, 0.017362936827810344`]}, 
                 {Arrowheads[0.], ArrowBox[{1, 6}, 0.017362936827810344`]}, 
                 {Arrowheads[0.], ArrowBox[{1, 7}, 0.017362936827810344`]}, 
                 {Arrowheads[0.], ArrowBox[{1, 8}, 0.017362936827810344`]}, 
                 {Arrowheads[0.], 
                  ArrowBox[BezierCurveBox[{2, 35, 38, 40, 46, 48, 51, 2},
                   SplineDegree->7], 0.017362936827810344`]}, 
                 {Arrowheads[0.], ArrowBox[{2, 3}, 0.017362936827810344`]}, 
                 {Arrowheads[0.], ArrowBox[{2, 4}, 0.017362936827810344`]}, 
                 {Arrowheads[0.], ArrowBox[{2, 5}, 0.017362936827810344`]}, 
                 {Arrowheads[0.], ArrowBox[{2, 6}, 0.017362936827810344`]}, 
                 {Arrowheads[0.], ArrowBox[{2, 7}, 0.017362936827810344`]}, 
                 {Arrowheads[0.], ArrowBox[{2, 8}, 0.017362936827810344`]}, 
                 {Arrowheads[0.], 
                  ArrowBox[BezierCurveBox[{3, 58, 61, 63, 69, 71, 74, 3},
                   SplineDegree->7], 0.017362936827810344`]}, 
                 {Arrowheads[0.], ArrowBox[{3, 4}, 0.017362936827810344`]}, 
                 {Arrowheads[0.], ArrowBox[{3, 5}, 0.017362936827810344`]}, 
                 {Arrowheads[0.], ArrowBox[{3, 6}, 0.017362936827810344`]}, 
                 {Arrowheads[0.], ArrowBox[{3, 7}, 0.017362936827810344`]}, 
                 {Arrowheads[0.], ArrowBox[{3, 8}, 0.017362936827810344`]}, 
                 {Arrowheads[0.], 
                  ArrowBox[BezierCurveBox[{4, 81, 84, 86, 92, 94, 97, 4},
                   SplineDegree->7], 0.017362936827810344`]}, 
                 {Arrowheads[0.], ArrowBox[{4, 5}, 0.017362936827810344`]}, 
                 {Arrowheads[0.], ArrowBox[{4, 6}, 0.017362936827810344`]}, 
                 {Arrowheads[0.], ArrowBox[{4, 7}, 0.017362936827810344`]}, 
                 {Arrowheads[0.], ArrowBox[{4, 8}, 0.017362936827810344`]}, 
                 {Arrowheads[0.], 
                  ArrowBox[BezierCurveBox[{5, 104, 107, 109, 115, 117, 120, 5},
                   SplineDegree->7], 0.017362936827810344`]}, 
                 {Arrowheads[0.], ArrowBox[{5, 6}, 0.017362936827810344`]}, 
                 {Arrowheads[0.], ArrowBox[{5, 7}, 0.017362936827810344`]}, 
                 {Arrowheads[0.], ArrowBox[{5, 8}, 0.017362936827810344`]}, 
                 {Arrowheads[0.], 
                  ArrowBox[BezierCurveBox[{6, 127, 130, 132, 138, 140, 143, 6},
                   SplineDegree->7], 0.017362936827810344`]}, 
                 {Arrowheads[0.], ArrowBox[{6, 7}, 0.017362936827810344`]}, 
                 {Arrowheads[0.], ArrowBox[{6, 8}, 0.017362936827810344`]}, 
                 {Arrowheads[0.], 
                  ArrowBox[BezierCurveBox[{7, 150, 153, 155, 161, 163, 166, 7},
                   SplineDegree->7], 0.017362936827810344`]}, 
                 {Arrowheads[0.], ArrowBox[{7, 8}, 0.017362936827810344`]}, 
                 {Arrowheads[0.], 
                  ArrowBox[BezierCurveBox[{8, 173, 176, 178, 184, 186, 189, 8},
                   SplineDegree->7], 0.017362936827810344`]}}, 
                {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[0.7]}], 
                 DiskBox[1, 0.017362936827810344], 
                 DiskBox[2, 0.017362936827810344], 
                 DiskBox[3, 0.017362936827810344], 
                 DiskBox[4, 0.017362936827810344], 
                 DiskBox[5, 0.017362936827810344], 
                 DiskBox[6, 0.017362936827810344], 
                 DiskBox[7, 0.017362936827810344], 
                 DiskBox[8, 0.017362936827810344]}}]],
             MouseAppearanceTag["NetworkGraphics"]],
            AllowKernelInitialization->False]],
          
          DefaultBaseStyle->{
           "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> 
            Hue[0.8, 1., 0.6]},
          FormatType->TraditionalForm,
          FrameTicks->None,
          GridLinesStyle->Directive[
            GrayLevel[0.5, 0.4]]], ",", 
         GraphicsBox[
          NamespaceBox["NetworkGraphics",
           DynamicModuleBox[{Typeset`graph = HoldComplete[
             
             Graph[{1, 2, 3, 4, 5, 6, 7, 8, 9}, {
              Null, SparseArray[
               Automatic, {9, 9}, 0, {
                1, {{0, 9, 17, 24, 30, 35, 39, 42, 44, 45}, {{1}, {2}, {3}, {
                  4}, {5}, {6}, {7}, {8}, {9}, {2}, {3}, {4}, {5}, {6}, {7}, {
                  8}, {9}, {3}, {4}, {5}, {6}, {7}, {8}, {9}, {4}, {5}, {6}, {
                  7}, {8}, {9}, {5}, {6}, {7}, {8}, {9}, {6}, {7}, {8}, {9}, {
                  7}, {8}, {9}, {8}, {9}, {9}}}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 
                 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
                 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}}]}]]}, 
            TagBox[GraphicsGroupBox[GraphicsComplexBox[CompressedData["
1:eJw9lnk01Gv8x6XtEt1IIsuVVikUkqK3XFdalCtlTWWLKCnJvYlIisitqISy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               "], {
                {Hue[0.6, 0.7, 0.5], Opacity[0.7], 
                 {Arrowheads[0.], 
                  ArrowBox[BezierCurveBox[{1, 13, 16, 18, 24, 26, 29, 1},
                   SplineDegree->7], 0.016764840903384343`]}, 
                 {Arrowheads[0.], ArrowBox[{1, 2}, 0.016764840903384343`]}, 
                 {Arrowheads[0.], ArrowBox[{1, 3}, 0.016764840903384343`]}, 
                 {Arrowheads[0.], ArrowBox[{1, 4}, 0.016764840903384343`]}, 
                 {Arrowheads[0.], ArrowBox[{1, 5}, 0.016764840903384343`]}, 
                 {Arrowheads[0.], ArrowBox[{1, 6}, 0.016764840903384343`]}, 
                 {Arrowheads[0.], ArrowBox[{1, 7}, 0.016764840903384343`]}, 
                 {Arrowheads[0.], ArrowBox[{1, 8}, 0.016764840903384343`]}, 
                 {Arrowheads[0.], ArrowBox[{1, 9}, 0.016764840903384343`]}, 
                 {Arrowheads[0.], 
                  ArrowBox[BezierCurveBox[{2, 36, 39, 41, 47, 49, 52, 2},
                   SplineDegree->7], 0.016764840903384343`]}, 
                 {Arrowheads[0.], ArrowBox[{2, 3}, 0.016764840903384343`]}, 
                 {Arrowheads[0.], ArrowBox[{2, 4}, 0.016764840903384343`]}, 
                 {Arrowheads[0.], ArrowBox[{2, 5}, 0.016764840903384343`]}, 
                 {Arrowheads[0.], ArrowBox[{2, 6}, 0.016764840903384343`]}, 
                 {Arrowheads[0.], ArrowBox[{2, 7}, 0.016764840903384343`]}, 
                 {Arrowheads[0.], ArrowBox[{2, 8}, 0.016764840903384343`]}, 
                 {Arrowheads[0.], ArrowBox[{2, 9}, 0.016764840903384343`]}, 
                 {Arrowheads[0.], 
                  ArrowBox[BezierCurveBox[{3, 59, 62, 64, 70, 72, 75, 3},
                   SplineDegree->7], 0.016764840903384343`]}, 
                 {Arrowheads[0.], ArrowBox[{3, 4}, 0.016764840903384343`]}, 
                 {Arrowheads[0.], ArrowBox[{3, 5}, 0.016764840903384343`]}, 
                 {Arrowheads[0.], ArrowBox[{3, 6}, 0.016764840903384343`]}, 
                 {Arrowheads[0.], ArrowBox[{3, 7}, 0.016764840903384343`]}, 
                 {Arrowheads[0.], ArrowBox[{3, 8}, 0.016764840903384343`]}, 
                 {Arrowheads[0.], ArrowBox[{3, 9}, 0.016764840903384343`]}, 
                 {Arrowheads[0.], 
                  ArrowBox[BezierCurveBox[{4, 82, 85, 87, 93, 95, 98, 4},
                   SplineDegree->7], 0.016764840903384343`]}, 
                 {Arrowheads[0.], ArrowBox[{4, 5}, 0.016764840903384343`]}, 
                 {Arrowheads[0.], ArrowBox[{4, 6}, 0.016764840903384343`]}, 
                 {Arrowheads[0.], ArrowBox[{4, 7}, 0.016764840903384343`]}, 
                 {Arrowheads[0.], ArrowBox[{4, 8}, 0.016764840903384343`]}, 
                 {Arrowheads[0.], ArrowBox[{4, 9}, 0.016764840903384343`]}, 
                 {Arrowheads[0.], 
                  ArrowBox[BezierCurveBox[{5, 105, 108, 110, 116, 118, 121, 5},
                   SplineDegree->7], 0.016764840903384343`]}, 
                 {Arrowheads[0.], ArrowBox[{5, 6}, 0.016764840903384343`]}, 
                 {Arrowheads[0.], ArrowBox[{5, 7}, 0.016764840903384343`]}, 
                 {Arrowheads[0.], ArrowBox[{5, 8}, 0.016764840903384343`]}, 
                 {Arrowheads[0.], ArrowBox[{5, 9}, 0.016764840903384343`]}, 
                 {Arrowheads[0.], 
                  ArrowBox[BezierCurveBox[{6, 128, 131, 133, 139, 141, 144, 6},
                   SplineDegree->7], 0.016764840903384343`]}, 
                 {Arrowheads[0.], ArrowBox[{6, 7}, 0.016764840903384343`]}, 
                 {Arrowheads[0.], ArrowBox[{6, 8}, 0.016764840903384343`]}, 
                 {Arrowheads[0.], ArrowBox[{6, 9}, 0.016764840903384343`]}, 
                 {Arrowheads[0.], 
                  ArrowBox[BezierCurveBox[{7, 151, 154, 156, 162, 164, 167, 7},
                   SplineDegree->7], 0.016764840903384343`]}, 
                 {Arrowheads[0.], ArrowBox[{7, 8}, 0.016764840903384343`]}, 
                 {Arrowheads[0.], ArrowBox[{7, 9}, 0.016764840903384343`]}, 
                 {Arrowheads[0.], 
                  ArrowBox[BezierCurveBox[{8, 174, 177, 179, 185, 187, 190, 8},
                   SplineDegree->7], 0.016764840903384343`]}, 
                 {Arrowheads[0.], ArrowBox[{8, 9}, 0.016764840903384343`]}, 
                 {Arrowheads[0.], 
                  ArrowBox[BezierCurveBox[{9, 197, 200, 202, 208, 210, 213, 9},
                   SplineDegree->7], 0.016764840903384343`]}}, 
                {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[0.7]}], 
                 DiskBox[1, 0.016764840903384343], 
                 DiskBox[2, 0.016764840903384343], 
                 DiskBox[3, 0.016764840903384343], 
                 DiskBox[4, 0.016764840903384343], 
                 DiskBox[5, 0.016764840903384343], 
                 DiskBox[6, 0.016764840903384343], 
                 DiskBox[7, 0.016764840903384343], 
                 DiskBox[8, 0.016764840903384343], 
                 DiskBox[9, 0.016764840903384343]}}]],
             MouseAppearanceTag["NetworkGraphics"]],
            AllowKernelInitialization->False]],
          
          DefaultBaseStyle->{
           "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> 
            Hue[0.8, 1., 0.6]},
          FormatType->TraditionalForm,
          FrameTicks->None,
          GridLinesStyle->Directive[
            GrayLevel[0.5, 0.4]]], ",", 
         GraphicsBox[
          NamespaceBox["NetworkGraphics",
           DynamicModuleBox[{Typeset`graph = HoldComplete[
             
             Graph[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10}, {
              Null, SparseArray[
               Automatic, {10, 10}, 0, {
                1, {{0, 10, 19, 27, 34, 40, 45, 49, 52, 54, 55}, {{1}, {2}, {
                  3}, {4}, {5}, {6}, {7}, {8}, {9}, {10}, {2}, {3}, {4}, {
                  5}, {6}, {7}, {8}, {9}, {10}, {3}, {4}, {5}, {6}, {7}, {
                  8}, {9}, {10}, {4}, {5}, {6}, {7}, {8}, {9}, {10}, {5}, {
                  6}, {7}, {8}, {9}, {10}, {6}, {7}, {8}, {9}, {10}, {7}, {
                  8}, {9}, {10}, {8}, {9}, {10}, {9}, {10}, {10}}}, {1, 1, 1, 
                 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
                 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
                 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}}]}]]}, 
            TagBox[GraphicsGroupBox[GraphicsComplexBox[CompressedData["
1:eJxdlnk0FHwXxyktkiXZsrSnRZS0Sn3J+iBPlrdSkiS0EuVpU0hlq1QitMj6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               "], {
                {Hue[0.6, 0.7, 0.5], Opacity[0.7], 
                 {Arrowheads[0.], 
                  ArrowBox[BezierCurveBox[{1, 14, 17, 19, 25, 27, 30, 1},
                   SplineDegree->7], 0.017493248281900298`]}, 
                 {Arrowheads[0.], ArrowBox[{1, 2}, 0.017493248281900298`]}, 
                 {Arrowheads[0.], ArrowBox[{1, 3}, 0.017493248281900298`]}, 
                 {Arrowheads[0.], ArrowBox[{1, 4}, 0.017493248281900298`]}, 
                 {Arrowheads[0.], ArrowBox[{1, 5}, 0.017493248281900298`]}, 
                 {Arrowheads[0.], ArrowBox[{1, 6}, 0.017493248281900298`]}, 
                 {Arrowheads[0.], ArrowBox[{1, 7}, 0.017493248281900298`]}, 
                 {Arrowheads[0.], ArrowBox[{1, 8}, 0.017493248281900298`]}, 
                 {Arrowheads[0.], ArrowBox[{1, 9}, 0.017493248281900298`]}, 
                 {Arrowheads[0.], ArrowBox[{1, 10}, 0.017493248281900298`]}, 
                 {Arrowheads[0.], 
                  ArrowBox[BezierCurveBox[{2, 37, 40, 42, 48, 50, 53, 2},
                   SplineDegree->7], 0.017493248281900298`]}, 
                 {Arrowheads[0.], ArrowBox[{2, 3}, 0.017493248281900298`]}, 
                 {Arrowheads[0.], ArrowBox[{2, 4}, 0.017493248281900298`]}, 
                 {Arrowheads[0.], ArrowBox[{2, 5}, 0.017493248281900298`]}, 
                 {Arrowheads[0.], ArrowBox[{2, 6}, 0.017493248281900298`]}, 
                 {Arrowheads[0.], ArrowBox[{2, 7}, 0.017493248281900298`]}, 
                 {Arrowheads[0.], ArrowBox[{2, 8}, 0.017493248281900298`]}, 
                 {Arrowheads[0.], ArrowBox[{2, 9}, 0.017493248281900298`]}, 
                 {Arrowheads[0.], ArrowBox[{2, 10}, 0.017493248281900298`]}, 
                 {Arrowheads[0.], 
                  ArrowBox[BezierCurveBox[{3, 60, 63, 65, 71, 73, 76, 3},
                   SplineDegree->7], 0.017493248281900298`]}, 
                 {Arrowheads[0.], ArrowBox[{3, 4}, 0.017493248281900298`]}, 
                 {Arrowheads[0.], ArrowBox[{3, 5}, 0.017493248281900298`]}, 
                 {Arrowheads[0.], ArrowBox[{3, 6}, 0.017493248281900298`]}, 
                 {Arrowheads[0.], ArrowBox[{3, 7}, 0.017493248281900298`]}, 
                 {Arrowheads[0.], ArrowBox[{3, 8}, 0.017493248281900298`]}, 
                 {Arrowheads[0.], ArrowBox[{3, 9}, 0.017493248281900298`]}, 
                 {Arrowheads[0.], ArrowBox[{3, 10}, 0.017493248281900298`]}, 
                 {Arrowheads[0.], 
                  ArrowBox[BezierCurveBox[{4, 83, 86, 88, 94, 96, 99, 4},
                   SplineDegree->7], 0.017493248281900298`]}, 
                 {Arrowheads[0.], ArrowBox[{4, 5}, 0.017493248281900298`]}, 
                 {Arrowheads[0.], ArrowBox[{4, 6}, 0.017493248281900298`]}, 
                 {Arrowheads[0.], ArrowBox[{4, 7}, 0.017493248281900298`]}, 
                 {Arrowheads[0.], ArrowBox[{4, 8}, 0.017493248281900298`]}, 
                 {Arrowheads[0.], ArrowBox[{4, 9}, 0.017493248281900298`]}, 
                 {Arrowheads[0.], ArrowBox[{4, 10}, 0.017493248281900298`]}, 
                 {Arrowheads[0.], 
                  ArrowBox[BezierCurveBox[{5, 106, 109, 111, 117, 119, 122, 5},
                   SplineDegree->7], 0.017493248281900298`]}, 
                 {Arrowheads[0.], ArrowBox[{5, 6}, 0.017493248281900298`]}, 
                 {Arrowheads[0.], ArrowBox[{5, 7}, 0.017493248281900298`]}, 
                 {Arrowheads[0.], ArrowBox[{5, 8}, 0.017493248281900298`]}, 
                 {Arrowheads[0.], ArrowBox[{5, 9}, 0.017493248281900298`]}, 
                 {Arrowheads[0.], ArrowBox[{5, 10}, 0.017493248281900298`]}, 
                 {Arrowheads[0.], 
                  ArrowBox[BezierCurveBox[{6, 129, 132, 134, 140, 142, 145, 6},
                   SplineDegree->7], 0.017493248281900298`]}, 
                 {Arrowheads[0.], ArrowBox[{6, 7}, 0.017493248281900298`]}, 
                 {Arrowheads[0.], ArrowBox[{6, 8}, 0.017493248281900298`]}, 
                 {Arrowheads[0.], ArrowBox[{6, 9}, 0.017493248281900298`]}, 
                 {Arrowheads[0.], ArrowBox[{6, 10}, 0.017493248281900298`]}, 
                 {Arrowheads[0.], 
                  ArrowBox[BezierCurveBox[{7, 152, 155, 157, 163, 165, 168, 7},
                   SplineDegree->7], 0.017493248281900298`]}, 
                 {Arrowheads[0.], ArrowBox[{7, 8}, 0.017493248281900298`]}, 
                 {Arrowheads[0.], ArrowBox[{7, 9}, 0.017493248281900298`]}, 
                 {Arrowheads[0.], ArrowBox[{7, 10}, 0.017493248281900298`]}, 
                 {Arrowheads[0.], 
                  ArrowBox[BezierCurveBox[{8, 175, 178, 180, 186, 188, 191, 8},
                   SplineDegree->7], 0.017493248281900298`]}, 
                 {Arrowheads[0.], ArrowBox[{8, 9}, 0.017493248281900298`]}, 
                 {Arrowheads[0.], ArrowBox[{8, 10}, 0.017493248281900298`]}, 
                 {Arrowheads[0.], 
                  ArrowBox[BezierCurveBox[{9, 198, 201, 203, 209, 211, 214, 9},
                   SplineDegree->7], 0.017493248281900298`]}, 
                 {Arrowheads[0.], ArrowBox[{9, 10}, 0.017493248281900298`]}, 
                 {Arrowheads[0.], 
                  ArrowBox[BezierCurveBox[{10, 221, 224, 226, 232, 234, 237, 
                   10},
                   SplineDegree->7], 0.017493248281900298`]}}, 
                {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[0.7]}], 
                 DiskBox[1, 0.017493248281900298], 
                 DiskBox[2, 0.017493248281900298], 
                 DiskBox[3, 0.017493248281900298], 
                 DiskBox[4, 0.017493248281900298], 
                 DiskBox[5, 0.017493248281900298], 
                 DiskBox[6, 0.017493248281900298], 
                 DiskBox[7, 0.017493248281900298], 
                 DiskBox[8, 0.017493248281900298], 
                 DiskBox[9, 0.017493248281900298], 
                 DiskBox[10, 0.017493248281900298]}}]],
             MouseAppearanceTag["NetworkGraphics"]],
            AllowKernelInitialization->False]],
          
          DefaultBaseStyle->{
           "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> 
            Hue[0.8, 1., 0.6]},
          FormatType->TraditionalForm,
          FrameTicks->None,
          GridLinesStyle->Directive[
            GrayLevel[0.5, 0.4]]]}], "}"}]], "ExerciseOutput",ExpressionUUID->
       "bfbedc77-5c70-4dd1-aa3f-d2adea1d52ac"],
      Apply[TextCell, 
       Cell[
        BoxData[
         RowBox[{"{", 
           RowBox[{
             GraphicsBox[
              NamespaceBox["NetworkGraphics", 
               DynamicModuleBox[{Typeset`graph = HoldComplete[
                   
                   Graph[{1, 2}, {
                    Null, SparseArray[
                    Automatic, {2, 2}, 0, {
                    1, {{0, 2, 3}, {{1}, {2}, {2}}}, {1, 1, 1}}]}]]}, 
                TagBox[
                 GraphicsGroupBox[{
                   GraphicsComplexBox[CompressedData["
1:eJxTTMoPSmViYGAwAGIQDQEf7BnQAHuMiLHasoU22Wul1zkA5T+fdDcKFi2w
3xzE1H1J94O98eXg+rnPN9mLyFduu73yg73l981et5YctHfY42mZmfXR/voL
KZcZ2SfsXdvv63AmfLK/9bbF/bHNWfvGvQoP2cs/25/I7Ttwbut5+0PaEjks
M7/Y/+WbaTNt8Xl7IS1Fgz3rvtrnGIY9XM9+1v6n3aqaFwu/2cvv+Je5TvyE
fcHMxz/Z47/bOziWC3+1OGj/Rn2+3vtr3+2lrf9laH/cCPXHD3sm8aM9nZlH
bN5C5c9YgeX3F0H1S0H07/8NNf/fdrD5+0Wg9gdA7N9/BOq+ZxD37W+Bun87
xP373aH+Ow/x334nqP9PQ/y/XwwaPmaQ8NkPCz9lSPjth4XvJ0j47me4EPW6
TVtgfyqUPyFSs9H1Zdt+Laj6OY+Uz5dZL91vAjVP7MjsKZOXbdt/EWqfntWf
NE+Gw/svQt0j8oaV037H6f17oO7lWZ+wQTDl0v53UP/4rGg58GHXtf0xUP++
+L3i08L2W/t5IOG9/0hq33P5mrv7taHhtWl+za490ff3v4eGJyS8H+yHpJeJ
NjB5Bmh8HIXq14fGF8x8QWh8+kLtT4TGN8x9X6DpQRzq/sPQ9GIA9d8NaHqS
gPoflt4WQMPHBpoeC6DhpwtNr7DwbTgFSc8AbuqF6Q==
                    "], {{{{{
                    Hue[0.6, 0.7, 0.5], 
                    Opacity[0.7], {{{{
                    Arrowheads[0.], 
                    ArrowBox[
                    
                    BezierCurveBox[{1, 6, 9, 11, 17, 19, 22, 1}, SplineDegree -> 
                    7], 0.01273]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[{1, 2}, 0.01273]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[
                    
                    BezierCurveBox[{2, 29, 32, 34, 40, 42, 45, 2}, 
                    SplineDegree -> 7], 0.01273]}}}}}}}}, {{{{
                    Hue[0.6, 0.2, 0.8], 
                    EdgeForm[{
                    GrayLevel[0], 
                    Opacity[0.7]}], 
                    DiskBox[1, 0.01273], 
                    DiskBox[2, 0.01273]}}}}}]}], 
                 MouseAppearanceTag["NetworkGraphics"]], 
                AllowKernelInitialization -> False]], 
              DefaultBaseStyle -> {
               "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> 
                Hue[0.8, 1., 0.6]}, FormatType -> TraditionalForm, FrameTicks -> 
              None, GridLinesStyle -> Directive[
                GrayLevel[0.5, 0.4]], ImageCache -> 
              GraphicsData[
               "CompressedBitmap", 
                "eJy9V9lPV1cQPgZ5aGyLWu1ijdLF/gF9aGJSH3xp+9LH9q1NiGmqbV2KtrUY\
\nNzYBURRBEQERpYD4ExSQTRAQUBAXQBRUBAGxrOKC7Eznm9/cm4uStDVpfwnc\n\
c76Z+ebcc+bMzP3SZ8PK71b7bFi1wsf7c1+fdStXrVjv/dlaX4Y8ZhhjBvjv\n\
C2+DMfFQ/w0Q/1j4nz8Wy8ODevqf0MjomMxcimEOHLNFbvUF8niNJiYmqaWj\n\
l4ouNlJs+nnauDuDfo/IpJ8CU8lvTybtO3aOThRcoYord6jlfi89HRw2SWrL\n\
Y8EqrzaTq/AqRSWfExvYguO3XSeFE9zwwb7Ur3lbHnPo6bMRMVsdlEYBB3Io\n\
ObuaLly7S93u1dLk5CR19T2m2sYOyj1/nQ5nVFLQwVxat+O4LIvtTYKDCxhk\n\
0Ek4WcE2DXStsV04wIUfdgI+4As+4RtrwKu512XeksdMutXaJW+RU1pPQ8Oj\n\
swT2xFCsfUPTRTQ8MmZiVcZjwSCDzrPhUTNL6WAHGSiZ2u3FzFcp1pdVUke/\n\
hLuo4U6nlxJiufGuCoGxk2PjE2a/yngsGGTQYV3jpXRMITgoeefdXsw8lSIk\n\
vt+WTKHxBfToydBchTu6HlJ0SiltjMig0ppbUQrzUCCIWMXSZkOKSCqinQkF\n\
eO95ThcetOtwIaXnX5HZfMWa27pp+/5sOlN23UQqxmPBWGbeVOx4Xo0sD7M3\n\
3LRvqKicIzE4NhfbpefkQYNDI0LBUWj2KIaIBMYyWw9bjAhnDot2rorwLuvD\n\
XHg9845iiKgdsXmUnFVtdivGY8EQeZYedg22zKF8Nm1MWhmdKq6V2QJHGOxK\n\
PEtxJ8pxMmEK4yriELFvrPKuMsAaLO4gF/I5Krp6s522RGVJSCxUltGxcYnm\n\
6JQS4CEKj09MCIT7PDI6vlAZEECb950Gk0U+W0WwADnfcE0abhbc6IgjZ7Hc\n\
YMfKt7IqyFllkTK03u8TcoaU1SZ/+PiZ3BAc4mLH4ezjlTOLCXbs9t6jxS/o\n\
+YadAMfztMhEWB9m3ophtxFKzW09JtAOwx76NfwkZOY9xQ7xaSDLYeY1ldYt\n\
apaZpX75Rhtti86Wl/N3bBkwlpn3FYMd7KehxUv0PxqUmaWOo8OFwGy744IA\n\
d+rBDvYOWi8V3evsk9PA7APF+gaeyn5zXjXbFEOOBcYy86FiWD2ODbPXp9Ii\n\
/eJOYWapF1bekASA2VbFMAfu1HNxWkYqnob2TFk9ZRZdc6h7SjwFxJyhQ0ku\n\
CgwMoqqqKuOnssrKSsHij2WIDorKEuXKLKqV/Po3bpYo1dniMvr4k2W0xi+M\n\
li5bDmqzUWXV1dWCQQadvMJi89HLucFqQXM0u4bWbgqnr75ZxW6QUzzp629/\n\
mCLz9w94WTfYGKwYNEs/XU4xienshjM3y6IT0gQTGetgQ1/KzUy5OptD47BS\n\
uPRTGPsFaNOOg1D5l+RWnKB4ojjevtdttijGY8FwV//BQRdXNUndddKm5dbQ\n\
kVMXpoQp5sCderBDOZ2Gtqv3sVQOclwqXJQNO11SYaxLhUoEjGU2Lexg76C1\n\
UgDapAc9j2RmZRaJfu5Lqupa7MzCY8EQ7VYKgB3s6cXMcvT0RftFLNrCypv2\n\
XQ1QDPP88oYperCD/TS0lxvuSYYmR3rt0SyC1iPQgSHlArNoURuQM6ehxZ6t\n\
CU6TMrZYMWRt9JKcNexicKm+lTbtPSWRYOmhgK3lhg9n8FwxQJ1Ao1Db2G6s\n\
kvRkcIj89+cggEyIIzqwtyyz9eqaOqSHRN1RWqvoWqeOdtEqoyhnqJVcq02Y\n\
YqjbwFCmLD10zOjJuBu2yq3VKKTnXZbuFrMFjn3ECRdU3DDhivFYMOyt1SLA\n\
DvaYPUeLPg/7yN2g3a50dg9I9SuruW23NTwWjGW2HjpIuGIOq62xmrCbzQ/k\n\
hNH5Ws0VemxsTHV9q92E8Vgwltl6WBJomcNqwuyWkbuicHf7Y3eqKKol1U2y\n\
b3yUkQrzUJghYhWLAXGDdjQx84KZ0o+6u5SUnEvi+25Hr3ujPCVMLta2yC5F\n\
HivmfNNlolTGY8Eggw7CYY7S4csHa0K/wbg6sxpYfHSs5/qcV95gd+T4iEFH\n\
Ghqfj6wWozASHCCIWMXKOPl80GgqmUlZdQc9pfjvTCikA6mldIc7alycV1SG\n\
t0SIhhzKk0ivu3XfxKmMx4JBBh1kE8sOFwlc4AzjjwL2of70o2i2UCOqcalW\n\
B6VSaFy+NPhIC4hsxBWueDZ/caDlgasfA1Joc+RpBEKi0iAmAEGEd8YGZp2r\n\
E1NQgAqUoIYLuIJLuOYl6CeaO/ZfRTNLTS1/SnsR9UcJ/RySLk3ngdQyKS/I\n\
nG2d/dIX8zElqRlOHVD7g35RQUWBCUxBASpQgppduL39D5/xUx9mxl+Lt8lR\n"]], ",", 
             GraphicsBox[
              NamespaceBox["NetworkGraphics", 
               DynamicModuleBox[{Typeset`graph = HoldComplete[
                   
                   Graph[{1, 2, 3}, {
                    Null, SparseArray[
                    Automatic, {3, 3}, 0, {
                    1, {{0, 3, 5, 6}, {{1}, {2}, {3}, {2}, {3}, {3}}}, {1, 1, 
                    1, 1, 1, 1}}]}]]}, 
                TagBox[
                 GraphicsGroupBox[{
                   GraphicsComplexBox[CompressedData["
1:eJw1UntMk1cU/5RQkqFxK2RhShZfAf5QaAgSiehBEFGHYQIuRqxAoRU3KyRA
pYgRnbbEIDImMgERXJbgKxIzYAkzp5D6HCICFWqDIDCgFLWtlNIW7OSebze5
uTm5957ze62RZCdKl3Ict+vzXjwb4w9MFraY0OZeXEN4l2rw5hbXMH5xoS4+
QnkrkpWcGSRDgSXpNSZc6BUuaRINY1NSdoh32BTGNKTK/3k9irtSChpXjxhR
dsRh8NROoGoiXxB2Zwp9d/jYV9SasH6ypn/F2Wn09b0rdvl8wO71e5we2z5g
R5KuOc5qxsSMHI0tyYJB3YUDbqMFtzwpffIq8iN2vrmWGSe2YktGv+R4qA1D
LR2ioWgrTmstXcXL7Hgw7d7Jf2st+OdxryNef8xhjc+o/FaBGX8I2JC31eDA
vex8h9H7g5dvv+JE8TPZ5bHwKRQlfuUlfOzEieiHQT4J4/i04bTr4VEnxj4S
VLhyR7DZFdw0cN6Bv3gqNJXGQTwmER2r2DiHbYWeXnWhAxgirSwrL5rFnsLT
LVmb+zB+MOjnssoZVFcJuxvie9CodJbXXrdijOCTuu1KD26XqVsXOsxY1D4W
p/1Sh2OChFH9d+/x4/6otmG1HvOqg8V+vSbU7H62Kq1+CFPusxrsUqqT/dl7
gAJ6n5LN+kHsJPULPMPmgSqE5v06wvDA1+2EpzyL4YUTNwivfybjA7I64rNs
nvEF1TriG0l6gOYl6RG7j+kFJXtIL3Uy0xO+6SI9eb0hndfblM38gJVC8qPt
MfMLmsXk1+Es5ieMvyM/9V3Mb5AayG/9TywPEPac8rAzguUFtPsoLzo3yxNM
CylPFZxiMW8g20l5+zaf5REuyimP4XKWV/j+NuW12M7yDK1vKc9zOX+tMxhO
Yqf7gcfmz3k/5H+TO5WqwZYDb1YHJpjhQpWycfxSF6qcxutcgAWmCuZbUwN0
mJY/3F6Sa4XQjKt/Fyfq8YRkC37ynwFV+JK9NxUG7FSXronmZmFTb67ircyA
Sj8P9aVZO6xNzomRr9fjK0dcdW2/A4ptLx7cH+xDd6lI1lvkAm/pxZSluufY
YXnd+KN2Hqw3nAI/X8T6vHO/rbq8AGUzOw4pr3ZGku4LkPk7u4c6/j6K/kM7
/7+a+sM83z+C5kMfP3834QMFj6+K8MNTHn8U8YN8np+N+MNhnv810gfO8/qk
k37QzOu3PJfpC//r+x/Wi3vt
                    "], {{{{{
                    Hue[0.6, 0.7, 0.5], 
                    Opacity[0.7], {{{{
                    Arrowheads[0.], 
                    ArrowBox[
                    
                    BezierCurveBox[{1, 7, 10, 12, 18, 20, 23, 1}, 
                    SplineDegree -> 7], 0.020399597244776385`]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[{1, 2}, 0.020399597244776385`]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[{1, 3}, 0.020399597244776385`]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[
                    
                    BezierCurveBox[{2, 30, 33, 35, 41, 43, 46, 2}, 
                    SplineDegree -> 7], 0.020399597244776385`]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[{2, 3}, 0.020399597244776385`]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[
                    
                    BezierCurveBox[{3, 53, 56, 58, 64, 66, 69, 3}, 
                    SplineDegree -> 7], 0.020399597244776385`]}}}}}}}}, {{{{
                    Hue[0.6, 0.2, 0.8], 
                    EdgeForm[{
                    GrayLevel[0], 
                    Opacity[0.7]}], 
                    DiskBox[1, 0.020399597244776385`], 
                    DiskBox[2, 0.020399597244776385`], 
                    DiskBox[3, 0.020399597244776385`]}}}}}]}], 
                 MouseAppearanceTag["NetworkGraphics"]], 
                AllowKernelInitialization -> False]], 
              DefaultBaseStyle -> {
               "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> 
                Hue[0.8, 1., 0.6]}, FormatType -> TraditionalForm, FrameTicks -> 
              None, GridLinesStyle -> Directive[
                GrayLevel[0.5, 0.4]]], ",", 
             GraphicsBox[
              NamespaceBox["NetworkGraphics", 
               DynamicModuleBox[{Typeset`graph = HoldComplete[
                   
                   Graph[{1, 2, 3, 4}, {
                    Null, SparseArray[
                    Automatic, {4, 4}, 0, {
                    1, {{0, 4, 7, 9, 10}, {{1}, {2}, {3}, {4}, {2}, {3}, {
                    4}, {3}, {4}, {4}}}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1}}]}]]}, 
                TagBox[
                 GraphicsGroupBox[{
                   GraphicsComplexBox[CompressedData["
1:eJw9k3s01AkUxyeFUhttqdHDIakmVlYq5lTXI5akmUqPJYkyKcKq1ZNViKQT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                    "], {{{{{
                    Hue[0.6, 0.7, 0.5], 
                    Opacity[0.7], {{{{
                    Arrowheads[0.], 
                    ArrowBox[
                    
                    BezierCurveBox[{1, 8, 11, 13, 19, 21, 24, 1}, 
                    SplineDegree -> 7], 0.011203619719880126`]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[{1, 2}, 0.011203619719880126`]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[{1, 3}, 0.011203619719880126`]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[{1, 4}, 0.011203619719880126`]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[
                    
                    BezierCurveBox[{2, 31, 34, 36, 42, 44, 47, 2}, 
                    SplineDegree -> 7], 0.011203619719880126`]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[{2, 3}, 0.011203619719880126`]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[{2, 4}, 0.011203619719880126`]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[
                    
                    BezierCurveBox[{3, 54, 57, 59, 65, 67, 70, 3}, 
                    SplineDegree -> 7], 0.011203619719880126`]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[{3, 4}, 0.011203619719880126`]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[
                    
                    BezierCurveBox[{4, 77, 80, 82, 88, 90, 93, 4}, 
                    SplineDegree -> 7], 0.011203619719880126`]}}}}}}}}, {{{{
                    Hue[0.6, 0.2, 0.8], 
                    EdgeForm[{
                    GrayLevel[0], 
                    Opacity[0.7]}], 
                    DiskBox[1, 0.011203619719880126`], 
                    DiskBox[2, 0.011203619719880126`], 
                    DiskBox[3, 0.011203619719880126`], 
                    DiskBox[4, 0.011203619719880126`]}}}}}]}], 
                 MouseAppearanceTag["NetworkGraphics"]], 
                AllowKernelInitialization -> False]], 
              DefaultBaseStyle -> {
               "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> 
                Hue[0.8, 1., 0.6]}, FormatType -> TraditionalForm, FrameTicks -> 
              None, GridLinesStyle -> Directive[
                GrayLevel[0.5, 0.4]]], ",", 
             GraphicsBox[
              NamespaceBox["NetworkGraphics", 
               DynamicModuleBox[{Typeset`graph = HoldComplete[
                   
                   Graph[{1, 2, 3, 4, 5}, {
                    Null, SparseArray[
                    Automatic, {5, 5}, 0, {
                    1, {{0, 5, 9, 12, 14, 15}, {{1}, {2}, {3}, {4}, {5}, {
                    2}, {3}, {4}, {5}, {3}, {4}, {5}, {4}, {5}, {5}}}, {1, 1, 
                    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}}]}]]}, 
                TagBox[
                 GraphicsGroupBox[{
                   GraphicsComplexBox[CompressedData["
1:eJw9lHk01XkDxg3DqyJLtpKluoW6NKGSmeZB3hSjSE0qIyNbk2gxk0FN2Un2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                    "], {{{{{
                    Hue[0.6, 0.7, 0.5], 
                    Opacity[0.7], {{{{
                    Arrowheads[0.], 
                    ArrowBox[
                    
                    BezierCurveBox[{1, 9, 12, 14, 20, 22, 25, 1}, 
                    SplineDegree -> 7], 0.015799942848996912`]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[{1, 2}, 0.015799942848996912`]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[{1, 3}, 0.015799942848996912`]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[{1, 4}, 0.015799942848996912`]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[{1, 5}, 0.015799942848996912`]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[
                    
                    BezierCurveBox[{2, 32, 35, 37, 43, 45, 48, 2}, 
                    SplineDegree -> 7], 0.015799942848996912`]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[{2, 3}, 0.015799942848996912`]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[{2, 4}, 0.015799942848996912`]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[{2, 5}, 0.015799942848996912`]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[
                    
                    BezierCurveBox[{3, 55, 58, 60, 66, 68, 71, 3}, 
                    SplineDegree -> 7], 0.015799942848996912`]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[{3, 4}, 0.015799942848996912`]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[{3, 5}, 0.015799942848996912`]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[
                    
                    BezierCurveBox[{4, 78, 81, 83, 89, 91, 94, 4}, 
                    SplineDegree -> 7], 0.015799942848996912`]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[{4, 5}, 0.015799942848996912`]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[
                    
                    BezierCurveBox[{5, 101, 104, 106, 112, 114, 117, 5}, 
                    SplineDegree -> 7], 0.015799942848996912`]}}}}}}}}, {{{{
                    Hue[0.6, 0.2, 0.8], 
                    EdgeForm[{
                    GrayLevel[0], 
                    Opacity[0.7]}], 
                    DiskBox[1, 0.015799942848996912`], 
                    DiskBox[2, 0.015799942848996912`], 
                    DiskBox[3, 0.015799942848996912`], 
                    DiskBox[4, 0.015799942848996912`], 
                    DiskBox[5, 0.015799942848996912`]}}}}}]}], 
                 MouseAppearanceTag["NetworkGraphics"]], 
                AllowKernelInitialization -> False]], 
              DefaultBaseStyle -> {
               "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> 
                Hue[0.8, 1., 0.6]}, FormatType -> TraditionalForm, FrameTicks -> 
              None, GridLinesStyle -> Directive[
                GrayLevel[0.5, 0.4]]], ",", 
             GraphicsBox[
              NamespaceBox["NetworkGraphics", 
               DynamicModuleBox[{Typeset`graph = HoldComplete[
                   
                   Graph[{1, 2, 3, 4, 5, 6}, {
                    Null, SparseArray[
                    Automatic, {6, 6}, 0, {
                    1, {{0, 6, 11, 15, 18, 20, 21}, {{1}, {2}, {3}, {4}, {
                    5}, {6}, {2}, {3}, {4}, {5}, {6}, {3}, {4}, {5}, {6}, {
                    4}, {5}, {6}, {5}, {6}, {6}}}, {1, 1, 1, 1, 1, 1, 1, 1, 1,
                     1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}}]}]]}, 
                TagBox[
                 GraphicsGroupBox[{
                   GraphicsComplexBox[CompressedData["
1:eJw9lXk0FfoWxzm3kIR0CuUWN0OpXOUayvCVNOklKUpJUujJ1HDdlEJFdBHl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                    "], {{{{{
                    Hue[0.6, 0.7, 0.5], 
                    Opacity[0.7], {{{{
                    Arrowheads[0.], 
                    ArrowBox[
                    
                    BezierCurveBox[{1, 10, 13, 15, 21, 23, 26, 1}, 
                    SplineDegree -> 7], 0.016581374985794817`]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[{1, 2}, 0.016581374985794817`]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[{1, 3}, 0.016581374985794817`]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[{1, 4}, 0.016581374985794817`]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[{1, 5}, 0.016581374985794817`]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[{1, 6}, 0.016581374985794817`]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[
                    
                    BezierCurveBox[{2, 33, 36, 38, 44, 46, 49, 2}, 
                    SplineDegree -> 7], 0.016581374985794817`]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[{2, 3}, 0.016581374985794817`]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[{2, 4}, 0.016581374985794817`]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[{2, 5}, 0.016581374985794817`]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[{2, 6}, 0.016581374985794817`]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[
                    
                    BezierCurveBox[{3, 56, 59, 61, 67, 69, 72, 3}, 
                    SplineDegree -> 7], 0.016581374985794817`]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[{3, 4}, 0.016581374985794817`]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[{3, 5}, 0.016581374985794817`]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[{3, 6}, 0.016581374985794817`]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[
                    
                    BezierCurveBox[{4, 79, 82, 84, 90, 92, 95, 4}, 
                    SplineDegree -> 7], 0.016581374985794817`]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[{4, 5}, 0.016581374985794817`]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[{4, 6}, 0.016581374985794817`]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[
                    
                    BezierCurveBox[{5, 102, 105, 107, 113, 115, 118, 5}, 
                    SplineDegree -> 7], 0.016581374985794817`]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[{5, 6}, 0.016581374985794817`]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[
                    
                    BezierCurveBox[{6, 125, 128, 130, 136, 138, 141, 6}, 
                    SplineDegree -> 7], 0.016581374985794817`]}}}}}}}}, {{{{
                    Hue[0.6, 0.2, 0.8], 
                    EdgeForm[{
                    GrayLevel[0], 
                    Opacity[0.7]}], 
                    DiskBox[1, 0.016581374985794817`], 
                    DiskBox[2, 0.016581374985794817`], 
                    DiskBox[3, 0.016581374985794817`], 
                    DiskBox[4, 0.016581374985794817`], 
                    DiskBox[5, 0.016581374985794817`], 
                    DiskBox[6, 0.016581374985794817`]}}}}}]}], 
                 MouseAppearanceTag["NetworkGraphics"]], 
                AllowKernelInitialization -> False]], 
              DefaultBaseStyle -> {
               "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> 
                Hue[0.8, 1., 0.6]}, FormatType -> TraditionalForm, FrameTicks -> 
              None, GridLinesStyle -> Directive[
                GrayLevel[0.5, 0.4]]], ",", 
             GraphicsBox[
              NamespaceBox["NetworkGraphics", 
               DynamicModuleBox[{Typeset`graph = HoldComplete[
                   
                   Graph[{1, 2, 3, 4, 5, 6, 7}, {
                    Null, SparseArray[
                    Automatic, {7, 7}, 0, {
                    1, {{0, 7, 13, 18, 22, 25, 27, 28}, {{1}, {2}, {3}, {4}, {
                    5}, {6}, {7}, {2}, {3}, {4}, {5}, {6}, {7}, {3}, {4}, {
                    5}, {6}, {7}, {4}, {5}, {6}, {7}, {5}, {6}, {7}, {6}, {
                    7}, {7}}}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
                    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}}]}]]}, 
                TagBox[
                 GraphicsGroupBox[{
                   GraphicsComplexBox[CompressedData["
1:eJw1lnk4FPoXxskSrnITZalwEyXVlJQtL/1ar0giUooSkkqKVIQoWrS5Ecna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                    "], {{{{{
                    Hue[0.6, 0.7, 0.5], 
                    Opacity[0.7], {{{{
                    Arrowheads[0.], 
                    ArrowBox[
                    
                    BezierCurveBox[{1, 11, 14, 16, 22, 24, 27, 1}, 
                    SplineDegree -> 7], 0.01767595102569003]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[{1, 2}, 0.01767595102569003]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[{1, 3}, 0.01767595102569003]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[{1, 4}, 0.01767595102569003]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[{1, 5}, 0.01767595102569003]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[{1, 6}, 0.01767595102569003]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[{1, 7}, 0.01767595102569003]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[
                    
                    BezierCurveBox[{2, 34, 37, 39, 45, 47, 50, 2}, 
                    SplineDegree -> 7], 0.01767595102569003]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[{2, 3}, 0.01767595102569003]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[{2, 4}, 0.01767595102569003]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[{2, 5}, 0.01767595102569003]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[{2, 6}, 0.01767595102569003]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[{2, 7}, 0.01767595102569003]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[
                    
                    BezierCurveBox[{3, 57, 60, 62, 68, 70, 73, 3}, 
                    SplineDegree -> 7], 0.01767595102569003]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[{3, 4}, 0.01767595102569003]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[{3, 5}, 0.01767595102569003]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[{3, 6}, 0.01767595102569003]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[{3, 7}, 0.01767595102569003]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[
                    
                    BezierCurveBox[{4, 80, 83, 85, 91, 93, 96, 4}, 
                    SplineDegree -> 7], 0.01767595102569003]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[{4, 5}, 0.01767595102569003]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[{4, 6}, 0.01767595102569003]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[{4, 7}, 0.01767595102569003]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[
                    
                    BezierCurveBox[{5, 103, 106, 108, 114, 116, 119, 5}, 
                    SplineDegree -> 7], 0.01767595102569003]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[{5, 6}, 0.01767595102569003]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[{5, 7}, 0.01767595102569003]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[
                    
                    BezierCurveBox[{6, 126, 129, 131, 137, 139, 142, 6}, 
                    SplineDegree -> 7], 0.01767595102569003]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[{6, 7}, 0.01767595102569003]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[
                    
                    BezierCurveBox[{7, 149, 152, 154, 160, 162, 165, 7}, 
                    SplineDegree -> 7], 0.01767595102569003]}}}}}}}}, {{{{
                    Hue[0.6, 0.2, 0.8], 
                    EdgeForm[{
                    GrayLevel[0], 
                    Opacity[0.7]}], 
                    DiskBox[1, 0.01767595102569003], 
                    DiskBox[2, 0.01767595102569003], 
                    DiskBox[3, 0.01767595102569003], 
                    DiskBox[4, 0.01767595102569003], 
                    DiskBox[5, 0.01767595102569003], 
                    DiskBox[6, 0.01767595102569003], 
                    DiskBox[7, 0.01767595102569003]}}}}}]}], 
                 MouseAppearanceTag["NetworkGraphics"]], 
                AllowKernelInitialization -> False]], 
              DefaultBaseStyle -> {
               "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> 
                Hue[0.8, 1., 0.6]}, FormatType -> TraditionalForm, FrameTicks -> 
              None, GridLinesStyle -> Directive[
                GrayLevel[0.5, 0.4]]], ",", 
             GraphicsBox[
              NamespaceBox["NetworkGraphics", 
               DynamicModuleBox[{Typeset`graph = HoldComplete[
                   Graph[{1, 2, 3, 4, 5, 6, 7, 8}, {
                    Null, SparseArray[
                    Automatic, {8, 8}, 0, {
                    1, {{0, 8, 15, 21, 26, 30, 33, 35, 36}, {{1}, {2}, {3}, {
                    4}, {5}, {6}, {7}, {8}, {2}, {3}, {4}, {5}, {6}, {7}, {
                    8}, {3}, {4}, {5}, {6}, {7}, {8}, {4}, {5}, {6}, {7}, {
                    8}, {5}, {6}, {7}, {8}, {6}, {7}, {8}, {7}, {8}, {8}}}, {
                    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
                    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}}]}]]}, 
                
                TagBox[
                 GraphicsGroupBox[{
                   GraphicsComplexBox[CompressedData["
1:eJw9Vnk4FPr3VqK4QtlahSYiSbaK6vV13VSILN3qWkIpIS0SdRMlOykp4bYK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                    "], {{{{{
                    Hue[0.6, 0.7, 0.5], 
                    Opacity[0.7], {{{{
                    Arrowheads[0.], 
                    ArrowBox[
                    
                    BezierCurveBox[{1, 12, 15, 17, 23, 25, 28, 1}, 
                    SplineDegree -> 7], 0.017362936827810344`]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[{1, 2}, 0.017362936827810344`]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[{1, 3}, 0.017362936827810344`]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[{1, 4}, 0.017362936827810344`]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[{1, 5}, 0.017362936827810344`]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[{1, 6}, 0.017362936827810344`]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[{1, 7}, 0.017362936827810344`]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[{1, 8}, 0.017362936827810344`]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[
                    
                    BezierCurveBox[{2, 35, 38, 40, 46, 48, 51, 2}, 
                    SplineDegree -> 7], 0.017362936827810344`]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[{2, 3}, 0.017362936827810344`]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[{2, 4}, 0.017362936827810344`]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[{2, 5}, 0.017362936827810344`]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[{2, 6}, 0.017362936827810344`]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[{2, 7}, 0.017362936827810344`]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[{2, 8}, 0.017362936827810344`]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[
                    
                    BezierCurveBox[{3, 58, 61, 63, 69, 71, 74, 3}, 
                    SplineDegree -> 7], 0.017362936827810344`]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[{3, 4}, 0.017362936827810344`]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[{3, 5}, 0.017362936827810344`]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[{3, 6}, 0.017362936827810344`]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[{3, 7}, 0.017362936827810344`]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[{3, 8}, 0.017362936827810344`]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[
                    
                    BezierCurveBox[{4, 81, 84, 86, 92, 94, 97, 4}, 
                    SplineDegree -> 7], 0.017362936827810344`]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[{4, 5}, 0.017362936827810344`]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[{4, 6}, 0.017362936827810344`]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[{4, 7}, 0.017362936827810344`]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[{4, 8}, 0.017362936827810344`]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[
                    
                    BezierCurveBox[{5, 104, 107, 109, 115, 117, 120, 5}, 
                    SplineDegree -> 7], 0.017362936827810344`]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[{5, 6}, 0.017362936827810344`]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[{5, 7}, 0.017362936827810344`]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[{5, 8}, 0.017362936827810344`]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[
                    
                    BezierCurveBox[{6, 127, 130, 132, 138, 140, 143, 6}, 
                    SplineDegree -> 7], 0.017362936827810344`]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[{6, 7}, 0.017362936827810344`]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[{6, 8}, 0.017362936827810344`]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[
                    
                    BezierCurveBox[{7, 150, 153, 155, 161, 163, 166, 7}, 
                    SplineDegree -> 7], 0.017362936827810344`]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[{7, 8}, 0.017362936827810344`]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[
                    
                    BezierCurveBox[{8, 173, 176, 178, 184, 186, 189, 8}, 
                    SplineDegree -> 7], 0.017362936827810344`]}}}}}}}}, {{{{
                    Hue[0.6, 0.2, 0.8], 
                    EdgeForm[{
                    GrayLevel[0], 
                    Opacity[0.7]}], 
                    DiskBox[1, 0.017362936827810344`], 
                    DiskBox[2, 0.017362936827810344`], 
                    DiskBox[3, 0.017362936827810344`], 
                    DiskBox[4, 0.017362936827810344`], 
                    DiskBox[5, 0.017362936827810344`], 
                    DiskBox[6, 0.017362936827810344`], 
                    DiskBox[7, 0.017362936827810344`], 
                    DiskBox[8, 0.017362936827810344`]}}}}}]}], 
                 MouseAppearanceTag["NetworkGraphics"]], 
                AllowKernelInitialization -> False]], 
              DefaultBaseStyle -> {
               "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> 
                Hue[0.8, 1., 0.6]}, FormatType -> TraditionalForm, FrameTicks -> 
              None, GridLinesStyle -> Directive[
                GrayLevel[0.5, 0.4]]], ",", 
             GraphicsBox[
              NamespaceBox["NetworkGraphics", 
               DynamicModuleBox[{Typeset`graph = HoldComplete[
                   
                   Graph[{1, 2, 3, 4, 5, 6, 7, 8, 9}, {
                    Null, SparseArray[
                    Automatic, {9, 9}, 0, {
                    1, {{0, 9, 17, 24, 30, 35, 39, 42, 44, 45}, {{1}, {2}, {
                    3}, {4}, {5}, {6}, {7}, {8}, {9}, {2}, {3}, {4}, {5}, {
                    6}, {7}, {8}, {9}, {3}, {4}, {5}, {6}, {7}, {8}, {9}, {
                    4}, {5}, {6}, {7}, {8}, {9}, {5}, {6}, {7}, {8}, {9}, {
                    6}, {7}, {8}, {9}, {7}, {8}, {9}, {8}, {9}, {9}}}, {1, 1, 
                    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
                    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
                    1, 1, 1, 1, 1}}]}]]}, 
                TagBox[
                 GraphicsGroupBox[{
                   GraphicsComplexBox[CompressedData["
1:eJw9lnk01Gv8x6XtEt1IIsuVVikUkqK3XFdalCtlTWWLKCnJvYlIisitqISy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                    "], {{{{{
                    Hue[0.6, 0.7, 0.5], 
                    Opacity[0.7], {{{{
                    Arrowheads[0.], 
                    ArrowBox[
                    
                    BezierCurveBox[{1, 13, 16, 18, 24, 26, 29, 1}, 
                    SplineDegree -> 7], 0.016764840903384343`]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[{1, 2}, 0.016764840903384343`]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[{1, 3}, 0.016764840903384343`]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[{1, 4}, 0.016764840903384343`]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[{1, 5}, 0.016764840903384343`]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[{1, 6}, 0.016764840903384343`]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[{1, 7}, 0.016764840903384343`]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[{1, 8}, 0.016764840903384343`]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[{1, 9}, 0.016764840903384343`]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[
                    
                    BezierCurveBox[{2, 36, 39, 41, 47, 49, 52, 2}, 
                    SplineDegree -> 7], 0.016764840903384343`]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[{2, 3}, 0.016764840903384343`]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[{2, 4}, 0.016764840903384343`]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[{2, 5}, 0.016764840903384343`]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[{2, 6}, 0.016764840903384343`]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[{2, 7}, 0.016764840903384343`]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[{2, 8}, 0.016764840903384343`]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[{2, 9}, 0.016764840903384343`]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[
                    
                    BezierCurveBox[{3, 59, 62, 64, 70, 72, 75, 3}, 
                    SplineDegree -> 7], 0.016764840903384343`]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[{3, 4}, 0.016764840903384343`]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[{3, 5}, 0.016764840903384343`]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[{3, 6}, 0.016764840903384343`]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[{3, 7}, 0.016764840903384343`]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[{3, 8}, 0.016764840903384343`]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[{3, 9}, 0.016764840903384343`]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[
                    
                    BezierCurveBox[{4, 82, 85, 87, 93, 95, 98, 4}, 
                    SplineDegree -> 7], 0.016764840903384343`]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[{4, 5}, 0.016764840903384343`]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[{4, 6}, 0.016764840903384343`]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[{4, 7}, 0.016764840903384343`]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[{4, 8}, 0.016764840903384343`]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[{4, 9}, 0.016764840903384343`]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[
                    
                    BezierCurveBox[{5, 105, 108, 110, 116, 118, 121, 5}, 
                    SplineDegree -> 7], 0.016764840903384343`]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[{5, 6}, 0.016764840903384343`]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[{5, 7}, 0.016764840903384343`]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[{5, 8}, 0.016764840903384343`]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[{5, 9}, 0.016764840903384343`]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[
                    
                    BezierCurveBox[{6, 128, 131, 133, 139, 141, 144, 6}, 
                    SplineDegree -> 7], 0.016764840903384343`]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[{6, 7}, 0.016764840903384343`]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[{6, 8}, 0.016764840903384343`]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[{6, 9}, 0.016764840903384343`]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[
                    
                    BezierCurveBox[{7, 151, 154, 156, 162, 164, 167, 7}, 
                    SplineDegree -> 7], 0.016764840903384343`]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[{7, 8}, 0.016764840903384343`]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[{7, 9}, 0.016764840903384343`]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[
                    
                    BezierCurveBox[{8, 174, 177, 179, 185, 187, 190, 8}, 
                    SplineDegree -> 7], 0.016764840903384343`]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[{8, 9}, 0.016764840903384343`]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[
                    
                    BezierCurveBox[{9, 197, 200, 202, 208, 210, 213, 9}, 
                    SplineDegree -> 7], 0.016764840903384343`]}}}}}}}}, {{{{
                    Hue[0.6, 0.2, 0.8], 
                    EdgeForm[{
                    GrayLevel[0], 
                    Opacity[0.7]}], 
                    DiskBox[1, 0.016764840903384343`], 
                    DiskBox[2, 0.016764840903384343`], 
                    DiskBox[3, 0.016764840903384343`], 
                    DiskBox[4, 0.016764840903384343`], 
                    DiskBox[5, 0.016764840903384343`], 
                    DiskBox[6, 0.016764840903384343`], 
                    DiskBox[7, 0.016764840903384343`], 
                    DiskBox[8, 0.016764840903384343`], 
                    DiskBox[9, 0.016764840903384343`]}}}}}]}], 
                 MouseAppearanceTag["NetworkGraphics"]], 
                AllowKernelInitialization -> False]], 
              DefaultBaseStyle -> {
               "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> 
                Hue[0.8, 1., 0.6]}, FormatType -> TraditionalForm, FrameTicks -> 
              None, GridLinesStyle -> Directive[
                GrayLevel[0.5, 0.4]]], ",", 
             GraphicsBox[
              NamespaceBox["NetworkGraphics", 
               DynamicModuleBox[{Typeset`graph = HoldComplete[
                   
                   Graph[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10}, {
                    Null, SparseArray[
                    Automatic, {10, 10}, 0, {
                    1, {{0, 10, 19, 27, 34, 40, 45, 49, 52, 54, 55}, {{1}, {
                    2}, {3}, {4}, {5}, {6}, {7}, {8}, {9}, {10}, {2}, {3}, {
                    4}, {5}, {6}, {7}, {8}, {9}, {10}, {3}, {4}, {5}, {6}, {
                    7}, {8}, {9}, {10}, {4}, {5}, {6}, {7}, {8}, {9}, {10}, {
                    5}, {6}, {7}, {8}, {9}, {10}, {6}, {7}, {8}, {9}, {10}, {
                    7}, {8}, {9}, {10}, {8}, {9}, {10}, {9}, {10}, {10}}}, {1,
                     1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
                    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
                    1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}}]}]]}, 
                TagBox[
                 GraphicsGroupBox[{
                   GraphicsComplexBox[CompressedData["
1:eJxdlnk0FHwXxyktkiXZsrSnRZS0Sn3J+iBPlrdSkiS0EuVpU0hlq1QitMj6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                    "], {{{{{
                    Hue[0.6, 0.7, 0.5], 
                    Opacity[0.7], {{{{
                    Arrowheads[0.], 
                    ArrowBox[
                    
                    BezierCurveBox[{1, 14, 17, 19, 25, 27, 30, 1}, 
                    SplineDegree -> 7], 0.017493248281900298`]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[{1, 2}, 0.017493248281900298`]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[{1, 3}, 0.017493248281900298`]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[{1, 4}, 0.017493248281900298`]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[{1, 5}, 0.017493248281900298`]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[{1, 6}, 0.017493248281900298`]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[{1, 7}, 0.017493248281900298`]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[{1, 8}, 0.017493248281900298`]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[{1, 9}, 0.017493248281900298`]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[{1, 10}, 0.017493248281900298`]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[
                    
                    BezierCurveBox[{2, 37, 40, 42, 48, 50, 53, 2}, 
                    SplineDegree -> 7], 0.017493248281900298`]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[{2, 3}, 0.017493248281900298`]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[{2, 4}, 0.017493248281900298`]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[{2, 5}, 0.017493248281900298`]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[{2, 6}, 0.017493248281900298`]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[{2, 7}, 0.017493248281900298`]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[{2, 8}, 0.017493248281900298`]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[{2, 9}, 0.017493248281900298`]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[{2, 10}, 0.017493248281900298`]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[
                    
                    BezierCurveBox[{3, 60, 63, 65, 71, 73, 76, 3}, 
                    SplineDegree -> 7], 0.017493248281900298`]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[{3, 4}, 0.017493248281900298`]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[{3, 5}, 0.017493248281900298`]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[{3, 6}, 0.017493248281900298`]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[{3, 7}, 0.017493248281900298`]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[{3, 8}, 0.017493248281900298`]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[{3, 9}, 0.017493248281900298`]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[{3, 10}, 0.017493248281900298`]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[
                    
                    BezierCurveBox[{4, 83, 86, 88, 94, 96, 99, 4}, 
                    SplineDegree -> 7], 0.017493248281900298`]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[{4, 5}, 0.017493248281900298`]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[{4, 6}, 0.017493248281900298`]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[{4, 7}, 0.017493248281900298`]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[{4, 8}, 0.017493248281900298`]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[{4, 9}, 0.017493248281900298`]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[{4, 10}, 0.017493248281900298`]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[
                    
                    BezierCurveBox[{5, 106, 109, 111, 117, 119, 122, 5}, 
                    SplineDegree -> 7], 0.017493248281900298`]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[{5, 6}, 0.017493248281900298`]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[{5, 7}, 0.017493248281900298`]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[{5, 8}, 0.017493248281900298`]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[{5, 9}, 0.017493248281900298`]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[{5, 10}, 0.017493248281900298`]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[
                    
                    BezierCurveBox[{6, 129, 132, 134, 140, 142, 145, 6}, 
                    SplineDegree -> 7], 0.017493248281900298`]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[{6, 7}, 0.017493248281900298`]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[{6, 8}, 0.017493248281900298`]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[{6, 9}, 0.017493248281900298`]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[{6, 10}, 0.017493248281900298`]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[
                    
                    BezierCurveBox[{7, 152, 155, 157, 163, 165, 168, 7}, 
                    SplineDegree -> 7], 0.017493248281900298`]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[{7, 8}, 0.017493248281900298`]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[{7, 9}, 0.017493248281900298`]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[{7, 10}, 0.017493248281900298`]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[
                    
                    BezierCurveBox[{8, 175, 178, 180, 186, 188, 191, 8}, 
                    SplineDegree -> 7], 0.017493248281900298`]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[{8, 9}, 0.017493248281900298`]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[{8, 10}, 0.017493248281900298`]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[
                    
                    BezierCurveBox[{9, 198, 201, 203, 209, 211, 214, 9}, 
                    SplineDegree -> 7], 0.017493248281900298`]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[{9, 10}, 0.017493248281900298`]}}}}, {{{{
                    Arrowheads[0.], 
                    ArrowBox[
                    
                    BezierCurveBox[{10, 221, 224, 226, 232, 234, 237, 10}, 
                    SplineDegree -> 7], 0.017493248281900298`]}}}}}}}}, {{{{
                    Hue[0.6, 0.2, 0.8], 
                    EdgeForm[{
                    GrayLevel[0], 
                    Opacity[0.7]}], 
                    DiskBox[1, 0.017493248281900298`], 
                    DiskBox[2, 0.017493248281900298`], 
                    DiskBox[3, 0.017493248281900298`], 
                    DiskBox[4, 0.017493248281900298`], 
                    DiskBox[5, 0.017493248281900298`], 
                    DiskBox[6, 0.017493248281900298`], 
                    DiskBox[7, 0.017493248281900298`], 
                    DiskBox[8, 0.017493248281900298`], 
                    DiskBox[9, 0.017493248281900298`], 
                    DiskBox[10, 0.017493248281900298`]}}}}}]}], 
                 MouseAppearanceTag["NetworkGraphics"]], 
                AllowKernelInitialization -> False]], 
              DefaultBaseStyle -> {
               "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> 
                Hue[0.8, 1., 0.6]}, FormatType -> TraditionalForm, FrameTicks -> 
              None, GridLinesStyle -> Directive[
                GrayLevel[0.5, 0.4]]]}], "}"}]], "ExerciseOutput", Selectable -> 
        False, Copyable -> False, Editable -> False, ShowCellBracket -> 
        False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"6fa0bbf8-49fc-408d-a885-8e238c598472"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Use ",
 ButtonBox["Table",
  BaseStyle->"Link"],
 " and ",
 ButtonBox["Flatten",
  BaseStyle->"Link"],
 " to get ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"1", ",", "2", ",", "1", ",", "2", ",", "1", ",", "2"}], "}"}]], 
  "InlineCode",ExpressionUUID->"602ae94f-d1bc-4898-ad17-9c7c9ed4022a"],
 ".",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "21.4", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"b0a0586b-f467-4ae2-a6b6-45537f676447"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       RowBox[{"{", 
        RowBox[{"1", ",", "2", ",", "1", ",", "2", ",", "1", ",", "2"}], 
        "}"}]], "ExerciseOutput",ExpressionUUID->
       "2ca5395b-b724-4000-827e-ea9da2d75355"],
      Apply[TextCell, 
       Cell[
        BoxData[
         RowBox[{"{", 
           RowBox[{"1", ",", "2", ",", "1", ",", "2", ",", "1", ",", "2"}], 
           "}"}]], "ExerciseOutput", Selectable -> False, Copyable -> False, 
        Editable -> False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"18d6d92d-b61e-4e48-a032-011a1e80f603"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Make a line plot of the result of concatenating all digits of all integers \
from 1 to 100 (i.e. ..., 8, 9, 1, 0, 1, 1, 1, 2, ...).",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "21.5", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"857538c5-7f7f-4d1a-8633-053fec85ee6f"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       GraphicsBox[{{}, {{}, {}, 
          {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
           0.01388888888888889], AbsoluteThickness[1.6], 
           LineBox[CompressedData["
1:eJxdlUluFUEQBVusWLJgwYJFu4QQQgiBmcHgZp4nM5m5MBjYcYU6Sh8lj9JH
8BEAOeNLFSlZqXA4u7qe0v+v7fzZ2j0wDEP8+/nf92tvs+/D1PeD6ofUD6sf
UT+qPqoX9WNT/z7HeZ+sE/InxafEp5nPfkb+bDL3W5c/l8x9z8tfSOb+F+Uv
JZPHZfkryeRzVf5aMnltyF9PLtlvZOe+mzC/7n2Ded5NefFwSx4mv9vyMPnd
kYfJ7648TH735GHyuy8Pk98Debhkf5g979Ng6pE8TH6P5WHyeyIvHp7Kw+T3
TB4mv+fyMPm96P0EZ35NPmDye6l5uOQ8nO8bMLXV+wnO/Jp8wOT3SvMw95UP
8fBa83Dm1+QDJr83mofJTz5g8nurebjkPJzvEzD1rvcTTH7yAZPftuZh8pMP
mPzea17cxAGT3wfNw+QnHzD5fdQ8XHIezvMCpj71foLJTz5g8vuseZj85AMm
vy+ah8lPPsTDV83D5CcfMPnV3o9wyefB+bwKZzX5Gc78Qn5ZzWf/1vsR5vNE
vsKZX5OfYfZFfoHJb0fniydxhTO/Jj/DJc/X3y8w9b33I5z5TfIV5vtKfob5
vJZfYPbvh86H+X+Sr3Dm1+RnOPMI+UU87Op8uOT54gpnNfkZZv/kl9V89p+9
H2H2T77C7J/8DLN/8gvM/v3S+TD7J19h9k9+FgeceSww9XvFfwGZmfoI
            
            "]]}}, {}},
        AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
        Axes->{True, True},
        AxesLabel->{None, None},
        AxesOrigin->{0, 0},
        DisplayFunction->Identity,
        Frame->{{False, False}, {False, False}},
        FrameLabel->{{None, None}, {None, None}},
        FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
        GridLines->{None, None},
        GridLinesStyle->Directive[
          GrayLevel[0.5, 0.4]],
        ImageSize->{400.04296875, Automatic},
        Method->{},
        PlotRange->{{0., 192.}, {0, 9.}},
        PlotRangeClipping->True,
        PlotRangePadding->{{
           Scaled[0.02], 
           Scaled[0.02]}, {
           Scaled[0.02], 
           Scaled[0.05]}},
        Ticks->{Automatic, Automatic}]], "ExerciseOutput",ExpressionUUID->
       "391fdb25-29d3-4b6c-987e-99045f75fd3c"],
      Apply[TextCell, 
       Cell[
        BoxData[
         GraphicsBox[{{}, {{}, {}, {{{{
                RGBColor[0.368417, 0.506779, 0.709798], 
                PointSize[0.01388888888888889], 
                AbsoluteThickness[1.6], 
                LineBox[CompressedData["
1:eJxdlUluFUEQBVusWLJgwYJFu4QQQgiBmcHgZp4nM5m5MBjYcYU6Sh8lj9JH
8BEAOeNLFSlZqXA4u7qe0v+v7fzZ2j0wDEP8+/nf92tvs+/D1PeD6ofUD6sf
UT+qPqoX9WNT/z7HeZ+sE/InxafEp5nPfkb+bDL3W5c/l8x9z8tfSOb+F+Uv
JZPHZfkryeRzVf5aMnltyF9PLtlvZOe+mzC/7n2Ded5NefFwSx4mv9vyMPnd
kYfJ7648TH735GHyuy8Pk98Debhkf5g979Ng6pE8TH6P5WHyeyIvHp7Kw+T3
TB4mv+fyMPm96P0EZ35NPmDye6l5uOQ8nO8bMLXV+wnO/Jp8wOT3SvMw95UP
8fBa83Dm1+QDJr83mofJTz5g8nurebjkPJzvEzD1rvcTTH7yAZPftuZh8pMP
mPzea17cxAGT3wfNw+QnHzD5fdQ8XHIezvMCpj71foLJTz5g8vuseZj85AMm
vy+ah8lPPsTDV83D5CcfMPnV3o9wyefB+bwKZzX5Gc78Qn5ZzWf/1vsR5vNE
vsKZX5OfYfZFfoHJb0fniydxhTO/Jj/DJc/X3y8w9b33I5z5TfIV5vtKfob5
vJZfYPbvh86H+X+Sr3Dm1+RnOPMI+UU87Op8uOT54gpnNfkZZv/kl9V89p+9
H2H2T77C7J/8DLN/8gvM/v3S+TD7J19h9k9+FgeceSww9XvFfwGZmfoI
                 
                 "]]}}}}}, {}}, AspectRatio -> 
          NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
          AxesLabel -> {None, None}, AxesOrigin -> {0, 0}, DisplayFunction -> 
          Identity, Frame -> {{False, False}, {False, False}}, 
          FrameLabel -> {{None, None}, {None, None}}, 
          FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
          GridLines -> {None, None}, GridLinesStyle -> Directive[
            GrayLevel[0.5, 0.4]], ImageSize -> {400.04296875, Automatic}, 
          Method -> {}, PlotRange -> {{0., 192.}, {0, 9.}}, PlotRangeClipping -> 
          True, PlotRangePadding -> {{
             Scaled[0.02], 
             Scaled[0.02]}, {
             Scaled[0.02], 
             Scaled[0.05]}}, Ticks -> {Automatic, Automatic}]], 
        "ExerciseOutput", Selectable -> False, Copyable -> False, Editable -> 
        False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"fb250656-7f69-44c3-8b78-2cefca884e7d"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Make a graph with 50 nodes, in which node ",
 Cell[BoxData[
 "i"], "InlineCode",ExpressionUUID->"4918ffc6-2470-4cd5-bb3b-d46a8374f76a"],
 " connects to node ",
 Cell[BoxData[
  RowBox[{"i", "+", "1"}]], "InlineCode",ExpressionUUID->
  "4a8c6ffd-0121-4084-b5fe-60bf5c205963"],
 ".",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "21.6", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"7ba93278-e055-424b-9351-a9d437514dea"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       GraphicsBox[
        NamespaceBox["NetworkGraphics",
         DynamicModuleBox[{Typeset`graph = HoldComplete[
           
           Graph[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 
            18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 
            34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 
            50, 51}, {{{1, 2}, {2, 3}, {3, 4}, {4, 5}, {5, 6}, {6, 7}, {7, 
             8}, {8, 9}, {9, 10}, {10, 11}, {11, 12}, {12, 13}, {13, 14}, {14,
              15}, {15, 16}, {16, 17}, {17, 18}, {18, 19}, {19, 20}, {20, 
             21}, {21, 22}, {22, 23}, {23, 24}, {24, 25}, {25, 26}, {26, 
             27}, {27, 28}, {28, 29}, {29, 30}, {30, 31}, {31, 32}, {32, 
             33}, {33, 34}, {34, 35}, {35, 36}, {36, 37}, {37, 38}, {38, 
             39}, {39, 40}, {40, 41}, {41, 42}, {42, 43}, {43, 44}, {44, 
             45}, {45, 46}, {46, 47}, {47, 48}, {48, 49}, {49, 50}, {50, 51}},
              Null}]]}, 
          TagBox[GraphicsGroupBox[GraphicsComplexBox[CompressedData["
1:eJyFkDEKgDAMRYNTxgwdHFw8gwewZ/AIgrNX9wgqJYW+UhIon1c++b9dz/u4
JhHZvvNrmSUXffaWfWZwAhtYwQL2nGg6X5DDHuzp7/C99V25ZQUbOIFHSh/3
MIc9vGcCG1jBAh4pfdzDnPqfuWUFG3ik9HGPwCfwSaD0Ge4tUO30BcxwKZI=

             "], {
              {Hue[0.6, 0.7, 0.5], Opacity[0.7], Arrowheads[
               0.01906487232574189], 
               ArrowBox[{{1, 2}, {2, 3}, {3, 4}, {4, 5}, {5, 6}, {6, 7}, {7, 
                8}, {8, 9}, {9, 10}, {10, 11}, {11, 12}, {12, 13}, {13, 14}, {
                14, 15}, {15, 16}, {16, 17}, {17, 18}, {18, 19}, {19, 20}, {
                20, 21}, {21, 22}, {22, 23}, {23, 24}, {24, 25}, {25, 26}, {
                26, 27}, {27, 28}, {28, 29}, {29, 30}, {30, 31}, {31, 32}, {
                32, 33}, {33, 34}, {34, 35}, {35, 36}, {36, 37}, {37, 38}, {
                38, 39}, {39, 40}, {40, 41}, {41, 42}, {42, 43}, {43, 44}, {
                44, 45}, {45, 46}, {46, 47}, {47, 48}, {48, 49}, {49, 50}, {
                50, 51}}, 0.05338164251207729]}, 
              {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[0.7]}], 
               DiskBox[1, 0.05338164251207729], 
               DiskBox[2, 0.05338164251207729], 
               DiskBox[3, 0.05338164251207729], 
               DiskBox[4, 0.05338164251207729], 
               DiskBox[5, 0.05338164251207729], 
               DiskBox[6, 0.05338164251207729], 
               DiskBox[7, 0.05338164251207729], 
               DiskBox[8, 0.05338164251207729], 
               DiskBox[9, 0.05338164251207729], 
               DiskBox[10, 0.05338164251207729], 
               DiskBox[11, 0.05338164251207729], 
               DiskBox[12, 0.05338164251207729], 
               DiskBox[13, 0.05338164251207729], 
               DiskBox[14, 0.05338164251207729], 
               DiskBox[15, 0.05338164251207729], 
               DiskBox[16, 0.05338164251207729], 
               DiskBox[17, 0.05338164251207729], 
               DiskBox[18, 0.05338164251207729], 
               DiskBox[19, 0.05338164251207729], 
               DiskBox[20, 0.05338164251207729], 
               DiskBox[21, 0.05338164251207729], 
               DiskBox[22, 0.05338164251207729], 
               DiskBox[23, 0.05338164251207729], 
               DiskBox[24, 0.05338164251207729], 
               DiskBox[25, 0.05338164251207729], 
               DiskBox[26, 0.05338164251207729], 
               DiskBox[27, 0.05338164251207729], 
               DiskBox[28, 0.05338164251207729], 
               DiskBox[29, 0.05338164251207729], 
               DiskBox[30, 0.05338164251207729], 
               DiskBox[31, 0.05338164251207729], 
               DiskBox[32, 0.05338164251207729], 
               DiskBox[33, 0.05338164251207729], 
               DiskBox[34, 0.05338164251207729], 
               DiskBox[35, 0.05338164251207729], 
               DiskBox[36, 0.05338164251207729], 
               DiskBox[37, 0.05338164251207729], 
               DiskBox[38, 0.05338164251207729], 
               DiskBox[39, 0.05338164251207729], 
               DiskBox[40, 0.05338164251207729], 
               DiskBox[41, 0.05338164251207729], 
               DiskBox[42, 0.05338164251207729], 
               DiskBox[43, 0.05338164251207729], 
               DiskBox[44, 0.05338164251207729], 
               DiskBox[45, 0.05338164251207729], 
               DiskBox[46, 0.05338164251207729], 
               DiskBox[47, 0.05338164251207729], 
               DiskBox[48, 0.05338164251207729], 
               DiskBox[49, 0.05338164251207729], 
               DiskBox[50, 0.05338164251207729], 
               DiskBox[51, 0.05338164251207729]}}]],
           MouseAppearanceTag["NetworkGraphics"]],
          AllowKernelInitialization->False]],
        DefaultBaseStyle->{
         "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> 
          Hue[0.8, 1., 0.6]},
        FormatType->TraditionalForm,
        FrameTicks->None,
        GridLinesStyle->Directive[
          GrayLevel[0.5, 0.4]]]], "ExerciseOutput",ExpressionUUID->
       "05cb97c4-f088-4d1b-82ad-1b4eefd713be"],
      Apply[TextCell, 
       Cell[
        BoxData[
         GraphicsBox[
          NamespaceBox["NetworkGraphics", 
           DynamicModuleBox[{Typeset`graph = HoldComplete[
               
               Graph[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 
                17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 
                32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 
                47, 48, 49, 50, 
                51}, {{{1, 2}, {2, 3}, {3, 4}, {4, 5}, {5, 6}, {6, 7}, {7, 
                 8}, {8, 9}, {9, 10}, {10, 11}, {11, 12}, {12, 13}, {13, 
                 14}, {14, 15}, {15, 16}, {16, 17}, {17, 18}, {18, 19}, {19, 
                 20}, {20, 21}, {21, 22}, {22, 23}, {23, 24}, {24, 25}, {25, 
                 26}, {26, 27}, {27, 28}, {28, 29}, {29, 30}, {30, 31}, {31, 
                 32}, {32, 33}, {33, 34}, {34, 35}, {35, 36}, {36, 37}, {37, 
                 38}, {38, 39}, {39, 40}, {40, 41}, {41, 42}, {42, 43}, {43, 
                 44}, {44, 45}, {45, 46}, {46, 47}, {47, 48}, {48, 49}, {49, 
                 50}, {50, 51}}, Null}]]}, 
            TagBox[
             GraphicsGroupBox[{
               GraphicsComplexBox[CompressedData["
1:eJyFkDEKgDAMRYNTxgwdHFw8gwewZ/AIgrNX9wgqJYW+UhIon1c++b9dz/u4
JhHZvvNrmSUXffaWfWZwAhtYwQL2nGg6X5DDHuzp7/C99V25ZQUbOIFHSh/3
MIc9vGcCG1jBAh4pfdzDnPqfuWUFG3ik9HGPwCfwSaD0Ge4tUO30BcxwKZI=

                "], {{{{{
                    Hue[0.6, 0.7, 0.5], 
                    Opacity[0.7], 
                    Arrowheads[0.01906487232574189], 
                    
                    ArrowBox[{{1, 2}, {2, 3}, {3, 4}, {4, 5}, {5, 6}, {6, 
                    7}, {7, 8}, {8, 9}, {9, 10}, {10, 11}, {11, 12}, {12, 
                    13}, {13, 14}, {14, 15}, {15, 16}, {16, 17}, {17, 18}, {
                    18, 19}, {19, 20}, {20, 21}, {21, 22}, {22, 23}, {23, 
                    24}, {24, 25}, {25, 26}, {26, 27}, {27, 28}, {28, 29}, {
                    29, 30}, {30, 31}, {31, 32}, {32, 33}, {33, 34}, {34, 
                    35}, {35, 36}, {36, 37}, {37, 38}, {38, 39}, {39, 40}, {
                    40, 41}, {41, 42}, {42, 43}, {43, 44}, {44, 45}, {45, 
                    46}, {46, 47}, {47, 48}, {48, 49}, {49, 50}, {50, 51}}, 
                    0.05338164251207729]}}}}, {{{{
                    Hue[0.6, 0.2, 0.8], 
                    EdgeForm[{
                    GrayLevel[0], 
                    Opacity[0.7]}], 
                    DiskBox[1, 0.05338164251207729], 
                    DiskBox[2, 0.05338164251207729], 
                    DiskBox[3, 0.05338164251207729], 
                    DiskBox[4, 0.05338164251207729], 
                    DiskBox[5, 0.05338164251207729], 
                    DiskBox[6, 0.05338164251207729], 
                    DiskBox[7, 0.05338164251207729], 
                    DiskBox[8, 0.05338164251207729], 
                    DiskBox[9, 0.05338164251207729], 
                    DiskBox[10, 0.05338164251207729], 
                    DiskBox[11, 0.05338164251207729], 
                    DiskBox[12, 0.05338164251207729], 
                    DiskBox[13, 0.05338164251207729], 
                    DiskBox[14, 0.05338164251207729], 
                    DiskBox[15, 0.05338164251207729], 
                    DiskBox[16, 0.05338164251207729], 
                    DiskBox[17, 0.05338164251207729], 
                    DiskBox[18, 0.05338164251207729], 
                    DiskBox[19, 0.05338164251207729], 
                    DiskBox[20, 0.05338164251207729], 
                    DiskBox[21, 0.05338164251207729], 
                    DiskBox[22, 0.05338164251207729], 
                    DiskBox[23, 0.05338164251207729], 
                    DiskBox[24, 0.05338164251207729], 
                    DiskBox[25, 0.05338164251207729], 
                    DiskBox[26, 0.05338164251207729], 
                    DiskBox[27, 0.05338164251207729], 
                    DiskBox[28, 0.05338164251207729], 
                    DiskBox[29, 0.05338164251207729], 
                    DiskBox[30, 0.05338164251207729], 
                    DiskBox[31, 0.05338164251207729], 
                    DiskBox[32, 0.05338164251207729], 
                    DiskBox[33, 0.05338164251207729], 
                    DiskBox[34, 0.05338164251207729], 
                    DiskBox[35, 0.05338164251207729], 
                    DiskBox[36, 0.05338164251207729], 
                    DiskBox[37, 0.05338164251207729], 
                    DiskBox[38, 0.05338164251207729], 
                    DiskBox[39, 0.05338164251207729], 
                    DiskBox[40, 0.05338164251207729], 
                    DiskBox[41, 0.05338164251207729], 
                    DiskBox[42, 0.05338164251207729], 
                    DiskBox[43, 0.05338164251207729], 
                    DiskBox[44, 0.05338164251207729], 
                    DiskBox[45, 0.05338164251207729], 
                    DiskBox[46, 0.05338164251207729], 
                    DiskBox[47, 0.05338164251207729], 
                    DiskBox[48, 0.05338164251207729], 
                    DiskBox[49, 0.05338164251207729], 
                    DiskBox[50, 0.05338164251207729], 
                    DiskBox[51, 0.05338164251207729]}}}}}]}], 
             MouseAppearanceTag["NetworkGraphics"]], 
            AllowKernelInitialization -> False]], 
          DefaultBaseStyle -> {
           "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> 
            Hue[0.8, 1., 0.6]}, FormatType -> TraditionalForm, FrameTicks -> 
          None, GridLinesStyle -> Directive[
            GrayLevel[0.5, 0.4]]]], "ExerciseOutput", Selectable -> False, 
        Copyable -> False, Editable -> False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"3dcf0ce5-4f77-479d-ba40-52da0d314991"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Make a graph with 4 nodes, in which each connection connects ",
 Cell[BoxData[
 "i"], "InlineCode",ExpressionUUID->"929c026b-c091-49a4-ab43-3b82694f34e8"],
 " to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Max",
    BaseStyle->"CodeLink"], "[", 
   RowBox[{"i", ",", "j"}], "]"}]], "InlineCode",ExpressionUUID->
  "b20f385c-de43-48a7-9bf1-cf7ee0fedf16"],
 ".",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "21.7", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"c1ad6ad5-1d8a-4e9e-966e-dd6e77cfbba5"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       GraphicsBox[
        NamespaceBox["NetworkGraphics",
         DynamicModuleBox[{Typeset`graph = HoldComplete[
           
           Graph[{1, 2, 3, 
            4}, {{{1, 1}, {1, 2}, {1, 3}, {1, 4}, {2, 2}, {2, 2}, {2, 3}, {2, 
             4}, {3, 3}, {3, 3}, {3, 3}, {3, 4}, {4, 4}, {4, 4}, {4, 4}, {4, 
             4}}, Null}]]}, 
          TagBox[GraphicsGroupBox[GraphicsComplexBox[CompressedData["
1:eJxtVgk4VVsbPg6hSEmDRkUDDZpF07ev0kiTiGuIMpUGRSqp2yXJ0ODSYEgD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             "], {
              {Hue[0.6, 0.7, 0.5], Opacity[0.7], Arrowheads[
               0.028937842778793414`], 
               ArrowBox[{1, 2}, 0.030239520958083826`], 
               ArrowBox[BezierCurveBox[{1, 9, 10, 11, 12, 13, 14, 15, 16, 17, 
                18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 
                33, 34, 3}], 0.030239520958083826`], 
               ArrowBox[BezierCurveBox[{1, 35, 36, 37, 38, 39, 40, 41, 42, 43,
                 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 
                59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 4}], 
                0.030239520958083826`], 
               ArrowBox[BezierCurveBox[{1, 73, 76, 78, 84, 86, 89, 1},
                SplineDegree->7], 0.030239520958083826`], 
               ArrowBox[{2, 3}, 0.030239520958083826`], 
               ArrowBox[BezierCurveBox[{2, 93, 94, 95, 96, 97, 98, 99, 100, 
                101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 
                113, 114, 115, 116, 117, 118, 4}], 0.030239520958083826`], 
               ArrowBox[BezierCurveBox[{2, 122, 125, 127, 133, 135, 138, 2},
                SplineDegree->7], 0.030239520958083826`], 
               ArrowBox[BezierCurveBox[{2, 145, 148, 150, 156, 158, 161, 2},
                SplineDegree->7], 0.030239520958083826`], 
               ArrowBox[{3, 4}, 0.030239520958083826`], 
               ArrowBox[BezierCurveBox[{3, 168, 171, 173, 179, 181, 184, 3},
                SplineDegree->7], 0.030239520958083826`], 
               ArrowBox[BezierCurveBox[{3, 191, 194, 196, 202, 204, 207, 3},
                SplineDegree->7], 0.030239520958083826`], 
               ArrowBox[BezierCurveBox[{3, 214, 217, 219, 225, 227, 230, 3},
                SplineDegree->7], 0.030239520958083826`], 
               ArrowBox[BezierCurveBox[{4, 237, 240, 242, 248, 250, 253, 4},
                SplineDegree->7], 0.030239520958083826`], 
               ArrowBox[BezierCurveBox[{4, 260, 263, 265, 271, 273, 276, 4},
                SplineDegree->7], 0.030239520958083826`], 
               ArrowBox[BezierCurveBox[{4, 283, 286, 288, 294, 296, 299, 4},
                SplineDegree->7], 0.030239520958083826`], 
               ArrowBox[BezierCurveBox[{4, 306, 309, 311, 317, 319, 322, 4},
                SplineDegree->7], 0.030239520958083826`]}, 
              {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[0.7]}], 
               DiskBox[1, 0.030239520958083826], 
               DiskBox[2, 0.030239520958083826], 
               DiskBox[3, 0.030239520958083826], 
               DiskBox[4, 0.030239520958083826]}}]],
           MouseAppearanceTag["NetworkGraphics"]],
          AllowKernelInitialization->False]],
        DefaultBaseStyle->{
         "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> 
          Hue[0.8, 1., 0.6]},
        FrameTicks->None,
        GridLinesStyle->Directive[
          GrayLevel[0.5, 0.4]],
        ImageSize->{227.74751227305296`, Automatic}]], "ExerciseOutput",
       ExpressionUUID->"a103f241-26fd-4513-94ff-d14834b35134"],
      Apply[TextCell, 
       Cell[
        BoxData[
         GraphicsBox[
          NamespaceBox["NetworkGraphics", 
           DynamicModuleBox[{Typeset`graph = HoldComplete[
               
               Graph[{1, 2, 3, 
                4}, {{{1, 1}, {1, 2}, {1, 3}, {1, 4}, {2, 2}, {2, 2}, {2, 
                 3}, {2, 4}, {3, 3}, {3, 3}, {3, 3}, {3, 4}, {4, 4}, {4, 4}, {
                 4, 4}, {4, 4}}, Null}]]}, 
            TagBox[
             GraphicsGroupBox[{
               GraphicsComplexBox[CompressedData["
1:eJxtVgk4VVsbPg6hSEmDRkUDDZpF07ev0kiTiGuIMpUGRSqp2yXJ0ODSYEgD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                "], {{{{{
                    Hue[0.6, 0.7, 0.5], 
                    Opacity[0.7], 
                    Arrowheads[0.028937842778793414`], 
                    ArrowBox[{1, 2}, 0.030239520958083826`], 
                    ArrowBox[
                    
                    BezierCurveBox[{1, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 
                    19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 
                    33, 34, 3}], 0.030239520958083826`], 
                    ArrowBox[
                    
                    BezierCurveBox[{1, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44,
                     45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 
                    59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 4}], 
                    0.030239520958083826`], 
                    ArrowBox[
                    
                    BezierCurveBox[{1, 73, 76, 78, 84, 86, 89, 1}, 
                    SplineDegree -> 7], 0.030239520958083826`], 
                    ArrowBox[{2, 3}, 0.030239520958083826`], 
                    ArrowBox[
                    
                    BezierCurveBox[{2, 93, 94, 95, 96, 97, 98, 99, 100, 101, 
                    102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 
                    113, 114, 115, 116, 117, 118, 4}], 0.030239520958083826`], 
                    ArrowBox[
                    
                    BezierCurveBox[{2, 122, 125, 127, 133, 135, 138, 2}, 
                    SplineDegree -> 7], 0.030239520958083826`], 
                    ArrowBox[
                    
                    BezierCurveBox[{2, 145, 148, 150, 156, 158, 161, 2}, 
                    SplineDegree -> 7], 0.030239520958083826`], 
                    ArrowBox[{3, 4}, 0.030239520958083826`], 
                    ArrowBox[
                    
                    BezierCurveBox[{3, 168, 171, 173, 179, 181, 184, 3}, 
                    SplineDegree -> 7], 0.030239520958083826`], 
                    ArrowBox[
                    
                    BezierCurveBox[{3, 191, 194, 196, 202, 204, 207, 3}, 
                    SplineDegree -> 7], 0.030239520958083826`], 
                    ArrowBox[
                    
                    BezierCurveBox[{3, 214, 217, 219, 225, 227, 230, 3}, 
                    SplineDegree -> 7], 0.030239520958083826`], 
                    ArrowBox[
                    
                    BezierCurveBox[{4, 237, 240, 242, 248, 250, 253, 4}, 
                    SplineDegree -> 7], 0.030239520958083826`], 
                    ArrowBox[
                    
                    BezierCurveBox[{4, 260, 263, 265, 271, 273, 276, 4}, 
                    SplineDegree -> 7], 0.030239520958083826`], 
                    ArrowBox[
                    
                    BezierCurveBox[{4, 283, 286, 288, 294, 296, 299, 4}, 
                    SplineDegree -> 7], 0.030239520958083826`], 
                    ArrowBox[
                    
                    BezierCurveBox[{4, 306, 309, 311, 317, 319, 322, 4}, 
                    SplineDegree -> 7], 0.030239520958083826`]}}}}, {{{{
                    Hue[0.6, 0.2, 0.8], 
                    EdgeForm[{
                    GrayLevel[0], 
                    Opacity[0.7]}], 
                    DiskBox[1, 0.030239520958083826`], 
                    DiskBox[2, 0.030239520958083826`], 
                    DiskBox[3, 0.030239520958083826`], 
                    DiskBox[4, 0.030239520958083826`]}}}}}]}], 
             MouseAppearanceTag["NetworkGraphics"]], 
            AllowKernelInitialization -> False]], 
          DefaultBaseStyle -> {
           "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> 
            Hue[0.8, 1., 0.6]}, FrameTicks -> None, GridLinesStyle -> 
          Directive[
            GrayLevel[0.5, 0.4]], 
          ImageSize -> {227.74751227305296`, Automatic}]], "ExerciseOutput", 
        Selectable -> False, Copyable -> False, Editable -> False, 
        ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"21d3bc8c-c0be-4e5f-b454-195270b3bc51"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Make a graph in which each connection connects ",
 Cell[BoxData[
 "i"], "InlineCode",ExpressionUUID->"b10e0623-1e8b-4692-bc3e-e9005a18a0ce"],
 " to ",
 Cell[BoxData[
  RowBox[{"j", "-", "i"}]], "InlineCode",ExpressionUUID->
  "115bc689-2069-4c8d-ad34-9fb3f51a984c"],
 ", where ",
 Cell[BoxData[
 "i"], "InlineCode",ExpressionUUID->"f826e0ef-8783-4a06-8c33-11f010ea28d4"],
 " and ",
 Cell[BoxData[
 "j"], "InlineCode",ExpressionUUID->"bb418a54-b3b8-4e82-9027-c8c5984282a3"],
 " both range from 1 to 5.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "21.8", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"69de389f-a2ad-4d7f-b896-016314867ef3"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       GraphicsBox[
        NamespaceBox["NetworkGraphics",
         DynamicModuleBox[{Typeset`graph = HoldComplete[
           
           Graph[{1, 0, 2, 3, 4, -1, -2, -3, 
            5, -4}, {{{1, 2}, {1, 1}, {1, 3}, {1, 4}, {1, 5}, {3, 6}, {3, 
             2}, {3, 1}, {3, 3}, {3, 4}, {4, 7}, {4, 6}, {4, 2}, {4, 1}, {4, 
             3}, {5, 8}, {5, 7}, {5, 6}, {5, 2}, {5, 1}, {9, 10}, {9, 8}, {9, 
             7}, {9, 6}, {9, 2}}, Null}]]}, 
          TagBox[GraphicsGroupBox[GraphicsComplexBox[CompressedData["
1:eJw9Vnk01A0XZgx+Mz9GtmgnydYoWqx1b1lK4s2SFkuLZQ7JltQrkinalBKS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             "], {
              {Hue[0.6, 0.7, 0.5], Opacity[0.7], Arrowheads[Medium], 
               ArrowBox[BezierCurveBox[{1, 14, 17, 19, 25, 27, 30, 1},
                SplineDegree->7], 0.03347463079713678], 
               ArrowBox[{1, 2}, 0.03347463079713678], 
               ArrowBox[BezierCurveBox[{
                1, {3.526674174335069, 0.7287787158194411}, 3}], 
                0.03347463079713678], 
               ArrowBox[BezierCurveBox[{
                1, {3.1243457893076525`, 1.1091995777399712`}, 4}], 
                0.03347463079713678], 
               ArrowBox[BezierCurveBox[{
                1, {2.781821946913229, 0.6261315167016707}, 5}], 
                0.03347463079713678], 
               ArrowBox[BezierCurveBox[{
                3, {3.3358872949595484`, 0.7074910978235246}, 1}], 
                0.03347463079713678], ArrowBox[{3, 2}, 0.03347463079713678], 
               ArrowBox[BezierCurveBox[{3, 101, 104, 106, 112, 114, 117, 3},
                SplineDegree->7], 0.03347463079713678], 
               ArrowBox[BezierCurveBox[{
                3, {3.061316010023813, 0.808501626687408}, 4}], 
                0.03347463079713678], ArrowBox[{3, 6}, 0.03347463079713678], 
               ArrowBox[BezierCurveBox[{
                4, {3.2379012061591657`, 1.2524561315642253`}, 1}], 
                0.03347463079713678], ArrowBox[{4, 2}, 0.03347463079713678], 
               ArrowBox[BezierCurveBox[{
                4, {3.3656583062508765`, 0.973045798492173}, 3}], 
                0.03347463079713678], ArrowBox[{4, 6}, 0.03347463079713678], 
               ArrowBox[{4, 7}, 0.03347463079713678], 
               ArrowBox[BezierCurveBox[{
                5, {2.675511292550138, 1.066997458860627}, 1}], 
                0.03347463079713678], ArrowBox[{5, 2}, 0.03347463079713678], 
               ArrowBox[{5, 6}, 0.03347463079713678], 
               ArrowBox[{5, 7}, 0.03347463079713678], 
               ArrowBox[{5, 8}, 0.03347463079713678], 
               ArrowBox[{9, 2}, 0.03347463079713678], 
               ArrowBox[{9, 6}, 0.03347463079713678], 
               ArrowBox[{9, 7}, 0.03347463079713678], 
               ArrowBox[{9, 8}, 0.03347463079713678], 
               ArrowBox[{9, 10}, 0.03347463079713678]}, 
              {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[0.7]}], 
               DiskBox[1, 0.03347463079713678], 
               DiskBox[2, 0.03347463079713678], 
               DiskBox[3, 0.03347463079713678], 
               DiskBox[4, 0.03347463079713678], 
               DiskBox[5, 0.03347463079713678], 
               DiskBox[6, 0.03347463079713678], 
               DiskBox[7, 0.03347463079713678], 
               DiskBox[8, 0.03347463079713678], 
               DiskBox[9, 0.03347463079713678], 
               DiskBox[10, 0.03347463079713678]}}]],
           MouseAppearanceTag["NetworkGraphics"]],
          AllowKernelInitialization->False]],
        DefaultBaseStyle->{
         "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> 
          Hue[0.8, 1., 0.6]},
        FormatType->TraditionalForm,
        FrameTicks->None,
        GridLinesStyle->Directive[
          GrayLevel[0.5, 0.4]],
        ImageSize->{517.796875, Automatic}]], "ExerciseOutput",ExpressionUUID->
       "6d15b9f3-61ca-4058-94f7-98816dbae0ba"],
      Apply[TextCell, 
       Cell[
        BoxData[
         GraphicsBox[
          NamespaceBox["NetworkGraphics", 
           DynamicModuleBox[{Typeset`graph = HoldComplete[
               
               Graph[{1, 0, 2, 3, 4, -1, -2, -3, 
                5, -4}, {{{1, 2}, {1, 1}, {1, 3}, {1, 4}, {1, 5}, {3, 6}, {3, 
                 2}, {3, 1}, {3, 3}, {3, 4}, {4, 7}, {4, 6}, {4, 2}, {4, 1}, {
                 4, 3}, {5, 8}, {5, 7}, {5, 6}, {5, 2}, {5, 1}, {9, 10}, {9, 
                 8}, {9, 7}, {9, 6}, {9, 2}}, Null}]]}, 
            TagBox[
             GraphicsGroupBox[{
               GraphicsComplexBox[CompressedData["
1:eJw9Vnk01A0XZgx+Mz9GtmgnydYoWqx1b1lK4s2SFkuLZQ7JltQrkinalBKS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                "], {{{{{
                    Hue[0.6, 0.7, 0.5], 
                    Opacity[0.7], 
                    Arrowheads[Medium], 
                    ArrowBox[
                    
                    BezierCurveBox[{1, 14, 17, 19, 25, 27, 30, 1}, 
                    SplineDegree -> 7], 0.03347463079713678], 
                    ArrowBox[{1, 2}, 0.03347463079713678], 
                    ArrowBox[
                    
                    BezierCurveBox[{
                    1, {3.526674174335069, 0.7287787158194411}, 3}], 
                    0.03347463079713678], 
                    ArrowBox[
                    
                    BezierCurveBox[{
                    1, {3.1243457893076525`, 1.1091995777399712`}, 4}], 
                    0.03347463079713678], 
                    ArrowBox[
                    
                    BezierCurveBox[{
                    1, {2.781821946913229, 0.6261315167016707}, 5}], 
                    0.03347463079713678], 
                    ArrowBox[
                    
                    BezierCurveBox[{
                    3, {3.3358872949595484`, 0.7074910978235246}, 1}], 
                    0.03347463079713678], 
                    ArrowBox[{3, 2}, 0.03347463079713678], 
                    ArrowBox[
                    
                    BezierCurveBox[{3, 101, 104, 106, 112, 114, 117, 3}, 
                    SplineDegree -> 7], 0.03347463079713678], 
                    ArrowBox[
                    
                    BezierCurveBox[{
                    3, {3.061316010023813, 0.808501626687408}, 4}], 
                    0.03347463079713678], 
                    ArrowBox[{3, 6}, 0.03347463079713678], 
                    ArrowBox[
                    
                    BezierCurveBox[{
                    4, {3.2379012061591657`, 1.2524561315642253`}, 1}], 
                    0.03347463079713678], 
                    ArrowBox[{4, 2}, 0.03347463079713678], 
                    ArrowBox[
                    BezierCurveBox[{
                    4, {3.3656583062508765`, 0.973045798492173}, 3}], 
                    0.03347463079713678], 
                    ArrowBox[{4, 6}, 0.03347463079713678], 
                    ArrowBox[{4, 7}, 0.03347463079713678], 
                    ArrowBox[
                    
                    BezierCurveBox[{
                    5, {2.675511292550138, 1.066997458860627}, 1}], 
                    0.03347463079713678], 
                    ArrowBox[{5, 2}, 0.03347463079713678], 
                    ArrowBox[{5, 6}, 0.03347463079713678], 
                    ArrowBox[{5, 7}, 0.03347463079713678], 
                    ArrowBox[{5, 8}, 0.03347463079713678], 
                    ArrowBox[{9, 2}, 0.03347463079713678], 
                    ArrowBox[{9, 6}, 0.03347463079713678], 
                    ArrowBox[{9, 7}, 0.03347463079713678], 
                    ArrowBox[{9, 8}, 0.03347463079713678], 
                    ArrowBox[{9, 10}, 0.03347463079713678]}}}}, {{{{
                    Hue[0.6, 0.2, 0.8], 
                    EdgeForm[{
                    GrayLevel[0], 
                    Opacity[0.7]}], 
                    DiskBox[1, 0.03347463079713678], 
                    DiskBox[2, 0.03347463079713678], 
                    DiskBox[3, 0.03347463079713678], 
                    DiskBox[4, 0.03347463079713678], 
                    DiskBox[5, 0.03347463079713678], 
                    DiskBox[6, 0.03347463079713678], 
                    DiskBox[7, 0.03347463079713678], 
                    DiskBox[8, 0.03347463079713678], 
                    DiskBox[9, 0.03347463079713678], 
                    DiskBox[10, 0.03347463079713678]}}}}}]}], 
             MouseAppearanceTag["NetworkGraphics"]], 
            AllowKernelInitialization -> False]], 
          DefaultBaseStyle -> {
           "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> 
            Hue[0.8, 1., 0.6]}, FormatType -> TraditionalForm, FrameTicks -> 
          None, GridLinesStyle -> Directive[
            GrayLevel[0.5, 0.4]], ImageSize -> {517.796875, Automatic}]], 
        "ExerciseOutput", Selectable -> False, Copyable -> False, Editable -> 
        False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"9f887348-9c5f-4856-9394-adaad287a931"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Generate a graph with 100 nodes, each with a connection going to one \
randomly chosen node.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "21.9", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"7f09311c-6962-409d-b15b-707906666b25"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       GraphicsBox[
        NamespaceBox["NetworkGraphics",
         DynamicModuleBox[{Typeset`graph = HoldComplete[
           
           Graph[{1, 67, 2, 100, 3, 22, 4, 37, 5, 76, 6, 7, 11, 8, 35, 9, 78, 
            10, 55, 52, 12, 75, 13, 64, 14, 15, 60, 16, 82, 17, 18, 66, 19, 
            38, 20, 98, 21, 23, 47, 24, 25, 26, 42, 27, 28, 86, 29, 90, 30, 
            93, 31, 65, 32, 92, 33, 34, 59, 36, 80, 85, 39, 95, 40, 41, 84, 
            43, 44, 97, 45, 46, 61, 54, 48, 49, 73, 50, 62, 51, 53, 56, 71, 
            57, 77, 58, 63, 68, 69, 70, 91, 72, 74, 89, 79, 81, 83, 87, 88, 
            94, 96, 99}, {{{1, 2}, {3, 4}, {5, 6}, {7, 8}, {9, 10}, {11, 2}, {
             12, 13}, {14, 15}, {16, 17}, {18, 19}, {13, 20}, {21, 22}, {23, 
             24}, {25, 9}, {26, 27}, {28, 29}, {30, 14}, {31, 32}, {33, 34}, {
             35, 36}, {37, 21}, {6, 8}, {38, 39}, {40, 19}, {41, 15}, {42, 
             43}, {44, 38}, {45, 46}, {47, 48}, {49, 50}, {51, 52}, {53, 
             54}, {55, 42}, {56, 52}, {15, 57}, {58, 59}, {8, 60}, {34, 24}, {
             61, 62}, {63, 30}, {64, 65}, {43, 64}, {66, 45}, {67, 68}, {69, 
             46}, {70, 71}, {39, 72}, {73, 1}, {74, 75}, {76, 77}, {78, 78}, {
             20, 7}, {79, 6}, {72, 43}, {19, 52}, {80, 81}, {82, 83}, {84, 
             67}, {57, 60}, {27, 74}, {71, 33}, {77, 7}, {85, 78}, {24, 76}, {
             52, 82}, {32, 63}, {2, 18}, {86, 30}, {87, 12}, {88, 81}, {81, 
             89}, {90, 37}, {75, 63}, {91, 92}, {22, 87}, {10, 57}, {83, 5}, {
             17, 44}, {93, 42}, {59, 30}, {94, 19}, {29, 45}, {95, 12}, {65, 
             4}, {60, 63}, {46, 81}, {96, 32}, {97, 78}, {92, 45}, {48, 91}, {
             89, 44}, {54, 61}, {50, 46}, {98, 33}, {62, 33}, {99, 10}, {68, 
             54}, {36, 71}, {100, 69}, {4, 22}}, Null}]]}, 
          TagBox[GraphicsGroupBox[GraphicsComplexBox[CompressedData["
1:eJxVVHs41HkXnyJEbZkZl2EwFyTMzG/cBhPO/Cbl8hIG9ex2EaGNUrmMJF7d
RLViia3tXrIVtaRFtzOVxOpCJet1TXKpl0QMq3q9z7Ovfd4/znP+OM855/P5
nM/3yw6NCQifTaFQdk7Hf/Pagl/TDQNY4Kj/c8epWm280unQmNbCgqmypJ52
Xzq+PNbuVN5nB+cf7j9kkkLgsvF69XM5duD347WbMZUE/lDZFqco48ARl+N7
a2ss8GzgQaOvLRzwXf30g7DSCk9/shmz2WMGRVfs9OJKCUw+VhC26wkHRtuu
B+bU8NGUksrceIgJqbdCQ5jxQpzc+8fBW58MQS3MJCKrgcA5YjHLyJwNjszl
icX+VCzyLbPMOCwAuFTweEMNgaV4Uf2kqzXUZIjUapFAPld8Ti9ID/QTPPTt
y/gYOCJfGePHAE9G4PLwSgF6W8V6b0t3hTgtD695C4UYv4z9e/IuVygbM1DE
nCdwIFZutdOaDSB46yMb1kMiVpnISWdD4uFRE9v5TPSa2xqe9tYCNHcWpD2d
5r/ohvJugMwWWv3bzB1kQuxfrcjPVLUFZorL1NsXBIbYLoQNrqbQJ0mVuufY
o5tw6QPHBi4EvI6WqzjbI/P5cKe0jAnq71cYlY8J0To3ie2WQYeQeeumNAws
0DL84281djpQzyh91sdcjKOPo/U/mZOgkTbKzIwh8FTGuD9jWAIJmr4ZMgaB
fSotogNlOrBqTuKa17t5WNcVX/OphwYJDhPtHroCjHghMt/2hw58u6bk6lAA
H6Nb87gXwznQX7hMPKDuiE0tOsaehlyIy+qlL77ggM3vH6ZSoozBxHOzZXWc
E/7ZWl79Ro0F3CrV8c8MJyT7N0fpF9iCimbWjpFnQrzloT7coOUCuXtKxvvc
CbxT8/yyf5UYqrMLPs9ZQ2AhLShF2MqC05paK+UnDDDpZY4uqdADjVGq7tYl
BNo1+1bfWe0EGqYF/9CbK0Sbi+zCY18doai+y6rxGIGmFeGzF692hf0R7f2R
NgQuvkHZICqWQOrd8IQCXwHmJMXM2UaXQJ2Rg1P0AQH2fPyi3dtLAttCMttT
k4fP2irSu8pIsHUulDVv5qH1icuZOiIJ5Ad8HNeM5GHn1qYPuTwJ3NdxOj4Y
wsdDeZkDlUc48EG2ZbnBIxMkbd7fsO9hwwbKgSb3VBZ6CLRab2dz4Hr6wp3m
18QYsb6ofxODA3cWgHTIS4z54jDt3dVOcPZW9kCThRAb/cJGT0rZwDLq6h5p
MMFGceSj2AgmfGe/qWFCKUBWheSLnLcAwvZYp6tTeLi6q841bBEVLO/Nynkl
4CHF7bl6p74JyPNk9zvO8FHkf0mWDxy4PKFlme/ljJ2x17eFruMAsfTLbWc7
JyxpVmXWJDBgvThF+fkKD09pVbybf1AErCvbiv3OEsg4Y3O4keoAGsGq0cor
035S5PV0d0mgd4jIyermY2/lRPrp3WyQXijxvvpkCe63dWh3ucOGlwfNfJis
Jeg37HfRy0UCiTf/HbXHi8BBLdbxU3wWJK9qMq4954ju4surfDXZMCUcG3v1
oyMW7ntxTxzqDCo0lZ805QQ+ecNqNn5rAn/xRqXrzrqNobrAfEjrr4q0xEnD
vV1GPXpwQvCeWzBohSdCb8c2bDGFB1vUZrfcsUVXY58Y+1lmsGru466vYhsk
lQ/91I/SYL3XmV/7n5HonHet2HI7F4o8DTWU+lb4Opo6UiwHMFuzljcwjVcU
HfJKJw5ANqEh16wToO6Tz7Ov2nFg7aL5TGc+F4kMXopGIgdKtquT/xwyw02g
rBz0YkOVeWlYfLALrtR277h5VG9m34FvooJmfaaB6S/p56vqrdE0/WVscaQQ
LGCT4NFjAsfmDcgiUgDedlAmCyf56Dgyhz5yzg2cqoKuFc8l8Kz2iSD7p7Zg
oTOqiHO2wSS1I01DMSQE83K9fh/lYXWm4HECgwTBklTPhlw++n1XXa6/2QmC
mdqzVJKFaB/45l2IKgewjS+5KjPAjak3c0g2AY/U7q5trCXwNFvVvjOQBsL7
ZYx7sXxk/+W3/+HnZn/zU+wEB0QMo3/pBztixYrXlarJBvC98h19XCDEL1VB
D2zWTb+3Isv4/VUE+l7LVlvUTYPfFEl5Wi9ILKddGPzEpMPeKfn+xFckbpUO
WPX60CFtcvD9yVYSqSVRKfe30+GDjZ+FRTeJp+pzOoyn/zur/F3LCwdIbJnY
5ZaWRYd8iQF5/COJP+y+7Jy6jw4XiD3TM6bvqb3SQhFFh87vzSKfz5LivqFm
TaWUDt6ipdm6GlK03aDDVCykQ0XNqo1d86R48XzWix0vaXBUZXhF9wLp//tj
oRTbvL/U5wb/Xfc/lLjPx5A20/+VUn5Ut486M9+rw2GHD1Jn9o9tfh2RVUid
wXdpbEHo4Z+pM/h7uH8qhs5SZ/htJzlc70rqDH968bn4Re3UGX2etvaV6i+g
zejnAFPHej3+1vc/znl7aA==
             "], {
              {Hue[0.6, 0.7, 0.5], Opacity[0.7], Arrowheads[
               0.00796089444549677], ArrowBox[{1, 2}, 0.1079960218576366], 
               ArrowBox[{2, 18}, 0.1079960218576366], 
               ArrowBox[{3, 4}, 0.1079960218576366], 
               ArrowBox[{4, 22}, 0.1079960218576366], 
               ArrowBox[{5, 6}, 0.1079960218576366], 
               ArrowBox[{6, 8}, 0.1079960218576366], 
               ArrowBox[{7, 8}, 0.1079960218576366], 
               ArrowBox[{8, 60}, 0.1079960218576366], 
               ArrowBox[{9, 10}, 0.1079960218576366], 
               ArrowBox[{10, 57}, 0.1079960218576366], 
               ArrowBox[{11, 2}, 0.1079960218576366], 
               ArrowBox[{12, 13}, 0.1079960218576366], 
               ArrowBox[{13, 20}, 0.1079960218576366], 
               ArrowBox[{14, 15}, 0.1079960218576366], 
               ArrowBox[{15, 57}, 0.1079960218576366], 
               ArrowBox[{16, 17}, 0.1079960218576366], 
               ArrowBox[{17, 44}, 0.1079960218576366], 
               ArrowBox[{18, 19}, 0.1079960218576366], 
               ArrowBox[{19, 52}, 0.1079960218576366], 
               ArrowBox[{20, 7}, 0.1079960218576366], 
               ArrowBox[{21, 22}, 0.1079960218576366], 
               ArrowBox[{22, 87}, 0.1079960218576366], 
               ArrowBox[{23, 24}, 0.1079960218576366], 
               ArrowBox[{24, 76}, 0.1079960218576366], 
               ArrowBox[{25, 9}, 0.1079960218576366], 
               ArrowBox[{26, 27}, 0.1079960218576366], 
               ArrowBox[{27, 74}, 0.1079960218576366], 
               ArrowBox[{28, 29}, 0.1079960218576366], 
               ArrowBox[{29, 45}, 0.1079960218576366], 
               ArrowBox[{30, 14}, 0.1079960218576366], 
               ArrowBox[{31, 32}, 0.1079960218576366], 
               ArrowBox[{32, 63}, 0.1079960218576366], 
               ArrowBox[{33, 34}, 0.1079960218576366], 
               ArrowBox[{34, 24}, 0.1079960218576366], 
               ArrowBox[{35, 36}, 0.1079960218576366], 
               ArrowBox[{36, 71}, 0.1079960218576366], 
               ArrowBox[{37, 21}, 0.1079960218576366], 
               ArrowBox[{38, 39}, 0.1079960218576366], 
               ArrowBox[{39, 72}, 0.1079960218576366], 
               ArrowBox[{40, 19}, 0.1079960218576366], 
               ArrowBox[{41, 15}, 0.1079960218576366], 
               ArrowBox[{42, 43}, 0.1079960218576366], 
               ArrowBox[{43, 64}, 0.1079960218576366], 
               ArrowBox[{44, 38}, 0.1079960218576366], 
               ArrowBox[{45, 46}, 0.1079960218576366], 
               ArrowBox[{46, 81}, 0.1079960218576366], 
               ArrowBox[{47, 48}, 0.1079960218576366], 
               ArrowBox[{48, 91}, 0.1079960218576366], 
               ArrowBox[{49, 50}, 0.1079960218576366], 
               ArrowBox[{50, 46}, 0.1079960218576366], 
               ArrowBox[{51, 52}, 0.1079960218576366], 
               ArrowBox[{52, 82}, 0.1079960218576366], 
               ArrowBox[{53, 54}, 0.1079960218576366], 
               ArrowBox[{54, 61}, 0.1079960218576366], 
               ArrowBox[{55, 42}, 0.1079960218576366], 
               ArrowBox[{56, 52}, 0.1079960218576366], 
               ArrowBox[{57, 60}, 0.1079960218576366], 
               ArrowBox[{58, 59}, 0.1079960218576366], 
               ArrowBox[{59, 30}, 0.1079960218576366], 
               ArrowBox[{60, 63}, 0.1079960218576366], 
               ArrowBox[{61, 62}, 0.1079960218576366], 
               ArrowBox[{62, 33}, 0.1079960218576366], 
               ArrowBox[{63, 30}, 0.1079960218576366], 
               ArrowBox[{64, 65}, 0.1079960218576366], 
               ArrowBox[{65, 4}, 0.1079960218576366], 
               ArrowBox[{66, 45}, 0.1079960218576366], 
               ArrowBox[{67, 68}, 0.1079960218576366], 
               ArrowBox[{68, 54}, 0.1079960218576366], 
               ArrowBox[{69, 46}, 0.1079960218576366], 
               ArrowBox[{70, 71}, 0.1079960218576366], 
               ArrowBox[{71, 33}, 0.1079960218576366], 
               ArrowBox[{72, 43}, 0.1079960218576366], 
               ArrowBox[{73, 1}, 0.1079960218576366], 
               ArrowBox[{74, 75}, 0.1079960218576366], 
               ArrowBox[{75, 63}, 0.1079960218576366], 
               ArrowBox[{76, 77}, 0.1079960218576366], 
               ArrowBox[{77, 7}, 0.1079960218576366], 
               ArrowBox[BezierCurveBox[{78, 104, 107, 109, 115, 117, 120, 78},
                
                SplineDegree->7], 0.1079960218576366], 
               ArrowBox[{79, 6}, 0.1079960218576366], 
               ArrowBox[{80, 81}, 0.1079960218576366], 
               ArrowBox[{81, 89}, 0.1079960218576366], 
               ArrowBox[{82, 83}, 0.1079960218576366], 
               ArrowBox[{83, 5}, 0.1079960218576366], 
               ArrowBox[{84, 67}, 0.1079960218576366], 
               ArrowBox[{85, 78}, 0.1079960218576366], 
               ArrowBox[{86, 30}, 0.1079960218576366], 
               ArrowBox[{87, 12}, 0.1079960218576366], 
               ArrowBox[{88, 81}, 0.1079960218576366], 
               ArrowBox[{89, 44}, 0.1079960218576366], 
               ArrowBox[{90, 37}, 0.1079960218576366], 
               ArrowBox[{91, 92}, 0.1079960218576366], 
               ArrowBox[{92, 45}, 0.1079960218576366], 
               ArrowBox[{93, 42}, 0.1079960218576366], 
               ArrowBox[{94, 19}, 0.1079960218576366], 
               ArrowBox[{95, 12}, 0.1079960218576366], 
               ArrowBox[{96, 32}, 0.1079960218576366], 
               ArrowBox[{97, 78}, 0.1079960218576366], 
               ArrowBox[{98, 33}, 0.1079960218576366], 
               ArrowBox[{99, 10}, 0.1079960218576366], 
               ArrowBox[{100, 69}, 0.1079960218576366]}, 
              {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[0.7]}], 
               DiskBox[1, 0.1079960218576366], DiskBox[2, 0.1079960218576366],
                DiskBox[3, 0.1079960218576366], 
               DiskBox[4, 0.1079960218576366], DiskBox[5, 0.1079960218576366],
                DiskBox[6, 0.1079960218576366], 
               DiskBox[7, 0.1079960218576366], DiskBox[8, 0.1079960218576366],
                DiskBox[9, 0.1079960218576366], 
               DiskBox[10, 0.1079960218576366], 
               DiskBox[11, 0.1079960218576366], 
               DiskBox[12, 0.1079960218576366], 
               DiskBox[13, 0.1079960218576366], 
               DiskBox[14, 0.1079960218576366], 
               DiskBox[15, 0.1079960218576366], 
               DiskBox[16, 0.1079960218576366], 
               DiskBox[17, 0.1079960218576366], 
               DiskBox[18, 0.1079960218576366], 
               DiskBox[19, 0.1079960218576366], 
               DiskBox[20, 0.1079960218576366], 
               DiskBox[21, 0.1079960218576366], 
               DiskBox[22, 0.1079960218576366], 
               DiskBox[23, 0.1079960218576366], 
               DiskBox[24, 0.1079960218576366], 
               DiskBox[25, 0.1079960218576366], 
               DiskBox[26, 0.1079960218576366], 
               DiskBox[27, 0.1079960218576366], 
               DiskBox[28, 0.1079960218576366], 
               DiskBox[29, 0.1079960218576366], 
               DiskBox[30, 0.1079960218576366], 
               DiskBox[31, 0.1079960218576366], 
               DiskBox[32, 0.1079960218576366], 
               DiskBox[33, 0.1079960218576366], 
               DiskBox[34, 0.1079960218576366], 
               DiskBox[35, 0.1079960218576366], 
               DiskBox[36, 0.1079960218576366], 
               DiskBox[37, 0.1079960218576366], 
               DiskBox[38, 0.1079960218576366], 
               DiskBox[39, 0.1079960218576366], 
               DiskBox[40, 0.1079960218576366], 
               DiskBox[41, 0.1079960218576366], 
               DiskBox[42, 0.1079960218576366], 
               DiskBox[43, 0.1079960218576366], 
               DiskBox[44, 0.1079960218576366], 
               DiskBox[45, 0.1079960218576366], 
               DiskBox[46, 0.1079960218576366], 
               DiskBox[47, 0.1079960218576366], 
               DiskBox[48, 0.1079960218576366], 
               DiskBox[49, 0.1079960218576366], 
               DiskBox[50, 0.1079960218576366], 
               DiskBox[51, 0.1079960218576366], 
               DiskBox[52, 0.1079960218576366], 
               DiskBox[53, 0.1079960218576366], 
               DiskBox[54, 0.1079960218576366], 
               DiskBox[55, 0.1079960218576366], 
               DiskBox[56, 0.1079960218576366], 
               DiskBox[57, 0.1079960218576366], 
               DiskBox[58, 0.1079960218576366], 
               DiskBox[59, 0.1079960218576366], 
               DiskBox[60, 0.1079960218576366], 
               DiskBox[61, 0.1079960218576366], 
               DiskBox[62, 0.1079960218576366], 
               DiskBox[63, 0.1079960218576366], 
               DiskBox[64, 0.1079960218576366], 
               DiskBox[65, 0.1079960218576366], 
               DiskBox[66, 0.1079960218576366], 
               DiskBox[67, 0.1079960218576366], 
               DiskBox[68, 0.1079960218576366], 
               DiskBox[69, 0.1079960218576366], 
               DiskBox[70, 0.1079960218576366], 
               DiskBox[71, 0.1079960218576366], 
               DiskBox[72, 0.1079960218576366], 
               DiskBox[73, 0.1079960218576366], 
               DiskBox[74, 0.1079960218576366], 
               DiskBox[75, 0.1079960218576366], 
               DiskBox[76, 0.1079960218576366], 
               DiskBox[77, 0.1079960218576366], 
               DiskBox[78, 0.1079960218576366], 
               DiskBox[79, 0.1079960218576366], 
               DiskBox[80, 0.1079960218576366], 
               DiskBox[81, 0.1079960218576366], 
               DiskBox[82, 0.1079960218576366], 
               DiskBox[83, 0.1079960218576366], 
               DiskBox[84, 0.1079960218576366], 
               DiskBox[85, 0.1079960218576366], 
               DiskBox[86, 0.1079960218576366], 
               DiskBox[87, 0.1079960218576366], 
               DiskBox[88, 0.1079960218576366], 
               DiskBox[89, 0.1079960218576366], 
               DiskBox[90, 0.1079960218576366], 
               DiskBox[91, 0.1079960218576366], 
               DiskBox[92, 0.1079960218576366], 
               DiskBox[93, 0.1079960218576366], 
               DiskBox[94, 0.1079960218576366], 
               DiskBox[95, 0.1079960218576366], 
               DiskBox[96, 0.1079960218576366], 
               DiskBox[97, 0.1079960218576366], 
               DiskBox[98, 0.1079960218576366], 
               DiskBox[99, 0.1079960218576366], 
               DiskBox[100, 0.1079960218576366]}}]],
           MouseAppearanceTag["NetworkGraphics"]],
          AllowKernelInitialization->False]],
        DefaultBaseStyle->{
         "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> 
          Hue[0.8, 1., 0.6]},
        FormatType->TraditionalForm,
        FrameTicks->None,
        GridLinesStyle->Directive[
          GrayLevel[0.5, 0.4]],
        ImageSize->{542.43359375, Automatic}]], "ExerciseOutput",
       ExpressionUUID->"8aa555c3-c3d6-401b-905c-9ec5567457a9"],
      Apply[TextCell, 
       Cell[
        BoxData[
         GraphicsBox[
          NamespaceBox["NetworkGraphics", 
           DynamicModuleBox[{Typeset`graph = HoldComplete[
               
               Graph[{1, 67, 2, 100, 3, 22, 4, 37, 5, 76, 6, 7, 11, 8, 35, 9, 
                78, 10, 55, 52, 12, 75, 13, 64, 14, 15, 60, 16, 82, 17, 18, 
                66, 19, 38, 20, 98, 21, 23, 47, 24, 25, 26, 42, 27, 28, 86, 
                29, 90, 30, 93, 31, 65, 32, 92, 33, 34, 59, 36, 80, 85, 39, 
                95, 40, 41, 84, 43, 44, 97, 45, 46, 61, 54, 48, 49, 73, 50, 
                62, 51, 53, 56, 71, 57, 77, 58, 63, 68, 69, 70, 91, 72, 74, 
                89, 79, 81, 83, 87, 88, 94, 96, 
                99}, {{{1, 2}, {3, 4}, {5, 6}, {7, 8}, {9, 10}, {11, 2}, {12, 
                 13}, {14, 15}, {16, 17}, {18, 19}, {13, 20}, {21, 22}, {23, 
                 24}, {25, 9}, {26, 27}, {28, 29}, {30, 14}, {31, 32}, {33, 
                 34}, {35, 36}, {37, 21}, {6, 8}, {38, 39}, {40, 19}, {41, 
                 15}, {42, 43}, {44, 38}, {45, 46}, {47, 48}, {49, 50}, {51, 
                 52}, {53, 54}, {55, 42}, {56, 52}, {15, 57}, {58, 59}, {8, 
                 60}, {34, 24}, {61, 62}, {63, 30}, {64, 65}, {43, 64}, {66, 
                 45}, {67, 68}, {69, 46}, {70, 71}, {39, 72}, {73, 1}, {74, 
                 75}, {76, 77}, {78, 78}, {20, 7}, {79, 6}, {72, 43}, {19, 
                 52}, {80, 81}, {82, 83}, {84, 67}, {57, 60}, {27, 74}, {71, 
                 33}, {77, 7}, {85, 78}, {24, 76}, {52, 82}, {32, 63}, {2, 
                 18}, {86, 30}, {87, 12}, {88, 81}, {81, 89}, {90, 37}, {75, 
                 63}, {91, 92}, {22, 87}, {10, 57}, {83, 5}, {17, 44}, {93, 
                 42}, {59, 30}, {94, 19}, {29, 45}, {95, 12}, {65, 4}, {60, 
                 63}, {46, 81}, {96, 32}, {97, 78}, {92, 45}, {48, 91}, {89, 
                 44}, {54, 61}, {50, 46}, {98, 33}, {62, 33}, {99, 10}, {68, 
                 54}, {36, 71}, {100, 69}, {4, 22}}, Null}]]}, 
            TagBox[
             GraphicsGroupBox[{
               GraphicsComplexBox[CompressedData["
1:eJxVVHs41HkXnyJEbZkZl2EwFyTMzG/cBhPO/Cbl8hIG9ex2EaGNUrmMJF7d
RLViia3tXrIVtaRFtzOVxOpCJet1TXKpl0QMq3q9z7Ovfd4/znP+OM855/P5
nM/3yw6NCQifTaFQdk7Hf/Pagl/TDQNY4Kj/c8epWm280unQmNbCgqmypJ52
Xzq+PNbuVN5nB+cf7j9kkkLgsvF69XM5duD347WbMZUE/lDZFqco48ARl+N7
a2ss8GzgQaOvLRzwXf30g7DSCk9/shmz2WMGRVfs9OJKCUw+VhC26wkHRtuu
B+bU8NGUksrceIgJqbdCQ5jxQpzc+8fBW58MQS3MJCKrgcA5YjHLyJwNjszl
icX+VCzyLbPMOCwAuFTweEMNgaV4Uf2kqzXUZIjUapFAPld8Ti9ID/QTPPTt
y/gYOCJfGePHAE9G4PLwSgF6W8V6b0t3hTgtD695C4UYv4z9e/IuVygbM1DE
nCdwIFZutdOaDSB46yMb1kMiVpnISWdD4uFRE9v5TPSa2xqe9tYCNHcWpD2d
5r/ohvJugMwWWv3bzB1kQuxfrcjPVLUFZorL1NsXBIbYLoQNrqbQJ0mVuufY
o5tw6QPHBi4EvI6WqzjbI/P5cKe0jAnq71cYlY8J0To3ie2WQYeQeeumNAws
0DL84281djpQzyh91sdcjKOPo/U/mZOgkTbKzIwh8FTGuD9jWAIJmr4ZMgaB
fSotogNlOrBqTuKa17t5WNcVX/OphwYJDhPtHroCjHghMt/2hw58u6bk6lAA
H6Nb87gXwznQX7hMPKDuiE0tOsaehlyIy+qlL77ggM3vH6ZSoozBxHOzZXWc
E/7ZWl79Ro0F3CrV8c8MJyT7N0fpF9iCimbWjpFnQrzloT7coOUCuXtKxvvc
CbxT8/yyf5UYqrMLPs9ZQ2AhLShF2MqC05paK+UnDDDpZY4uqdADjVGq7tYl
BNo1+1bfWe0EGqYF/9CbK0Sbi+zCY18doai+y6rxGIGmFeGzF692hf0R7f2R
NgQuvkHZICqWQOrd8IQCXwHmJMXM2UaXQJ2Rg1P0AQH2fPyi3dtLAttCMttT
k4fP2irSu8pIsHUulDVv5qH1icuZOiIJ5Ad8HNeM5GHn1qYPuTwJ3NdxOj4Y
wsdDeZkDlUc48EG2ZbnBIxMkbd7fsO9hwwbKgSb3VBZ6CLRab2dz4Hr6wp3m
18QYsb6ofxODA3cWgHTIS4z54jDt3dVOcPZW9kCThRAb/cJGT0rZwDLq6h5p
MMFGceSj2AgmfGe/qWFCKUBWheSLnLcAwvZYp6tTeLi6q841bBEVLO/Nynkl
4CHF7bl6p74JyPNk9zvO8FHkf0mWDxy4PKFlme/ljJ2x17eFruMAsfTLbWc7
JyxpVmXWJDBgvThF+fkKD09pVbybf1AErCvbiv3OEsg4Y3O4keoAGsGq0cor
035S5PV0d0mgd4jIyermY2/lRPrp3WyQXijxvvpkCe63dWh3ucOGlwfNfJis
Jeg37HfRy0UCiTf/HbXHi8BBLdbxU3wWJK9qMq4954ju4surfDXZMCUcG3v1
oyMW7ntxTxzqDCo0lZ805QQ+ecNqNn5rAn/xRqXrzrqNobrAfEjrr4q0xEnD
vV1GPXpwQvCeWzBohSdCb8c2bDGFB1vUZrfcsUVXY58Y+1lmsGru466vYhsk
lQ/91I/SYL3XmV/7n5HonHet2HI7F4o8DTWU+lb4Opo6UiwHMFuzljcwjVcU
HfJKJw5ANqEh16wToO6Tz7Ov2nFg7aL5TGc+F4kMXopGIgdKtquT/xwyw02g
rBz0YkOVeWlYfLALrtR277h5VG9m34FvooJmfaaB6S/p56vqrdE0/WVscaQQ
LGCT4NFjAsfmDcgiUgDedlAmCyf56Dgyhz5yzg2cqoKuFc8l8Kz2iSD7p7Zg
oTOqiHO2wSS1I01DMSQE83K9fh/lYXWm4HECgwTBklTPhlw++n1XXa6/2QmC
mdqzVJKFaB/45l2IKgewjS+5KjPAjak3c0g2AY/U7q5trCXwNFvVvjOQBsL7
ZYx7sXxk/+W3/+HnZn/zU+wEB0QMo3/pBztixYrXlarJBvC98h19XCDEL1VB
D2zWTb+3Isv4/VUE+l7LVlvUTYPfFEl5Wi9ILKddGPzEpMPeKfn+xFckbpUO
WPX60CFtcvD9yVYSqSVRKfe30+GDjZ+FRTeJp+pzOoyn/zur/F3LCwdIbJnY
5ZaWRYd8iQF5/COJP+y+7Jy6jw4XiD3TM6bvqb3SQhFFh87vzSKfz5LivqFm
TaWUDt6ipdm6GlK03aDDVCykQ0XNqo1d86R48XzWix0vaXBUZXhF9wLp//tj
oRTbvL/U5wb/Xfc/lLjPx5A20/+VUn5Ut486M9+rw2GHD1Jn9o9tfh2RVUid
wXdpbEHo4Z+pM/h7uH8qhs5SZ/htJzlc70rqDH968bn4Re3UGX2etvaV6i+g
zejnAFPHej3+1vc/znl7aA==
                "], {{{{{
                    Hue[0.6, 0.7, 0.5], 
                    Opacity[0.7], 
                    Arrowheads[0.00796089444549677], 
                    ArrowBox[{1, 2}, 0.1079960218576366], 
                    ArrowBox[{2, 18}, 0.1079960218576366], 
                    ArrowBox[{3, 4}, 0.1079960218576366], 
                    ArrowBox[{4, 22}, 0.1079960218576366], 
                    ArrowBox[{5, 6}, 0.1079960218576366], 
                    ArrowBox[{6, 8}, 0.1079960218576366], 
                    ArrowBox[{7, 8}, 0.1079960218576366], 
                    ArrowBox[{8, 60}, 0.1079960218576366], 
                    ArrowBox[{9, 10}, 0.1079960218576366], 
                    ArrowBox[{10, 57}, 0.1079960218576366], 
                    ArrowBox[{11, 2}, 0.1079960218576366], 
                    ArrowBox[{12, 13}, 0.1079960218576366], 
                    ArrowBox[{13, 20}, 0.1079960218576366], 
                    ArrowBox[{14, 15}, 0.1079960218576366], 
                    ArrowBox[{15, 57}, 0.1079960218576366], 
                    ArrowBox[{16, 17}, 0.1079960218576366], 
                    ArrowBox[{17, 44}, 0.1079960218576366], 
                    ArrowBox[{18, 19}, 0.1079960218576366], 
                    ArrowBox[{19, 52}, 0.1079960218576366], 
                    ArrowBox[{20, 7}, 0.1079960218576366], 
                    ArrowBox[{21, 22}, 0.1079960218576366], 
                    ArrowBox[{22, 87}, 0.1079960218576366], 
                    ArrowBox[{23, 24}, 0.1079960218576366], 
                    ArrowBox[{24, 76}, 0.1079960218576366], 
                    ArrowBox[{25, 9}, 0.1079960218576366], 
                    ArrowBox[{26, 27}, 0.1079960218576366], 
                    ArrowBox[{27, 74}, 0.1079960218576366], 
                    ArrowBox[{28, 29}, 0.1079960218576366], 
                    ArrowBox[{29, 45}, 0.1079960218576366], 
                    ArrowBox[{30, 14}, 0.1079960218576366], 
                    ArrowBox[{31, 32}, 0.1079960218576366], 
                    ArrowBox[{32, 63}, 0.1079960218576366], 
                    ArrowBox[{33, 34}, 0.1079960218576366], 
                    ArrowBox[{34, 24}, 0.1079960218576366], 
                    ArrowBox[{35, 36}, 0.1079960218576366], 
                    ArrowBox[{36, 71}, 0.1079960218576366], 
                    ArrowBox[{37, 21}, 0.1079960218576366], 
                    ArrowBox[{38, 39}, 0.1079960218576366], 
                    ArrowBox[{39, 72}, 0.1079960218576366], 
                    ArrowBox[{40, 19}, 0.1079960218576366], 
                    ArrowBox[{41, 15}, 0.1079960218576366], 
                    ArrowBox[{42, 43}, 0.1079960218576366], 
                    ArrowBox[{43, 64}, 0.1079960218576366], 
                    ArrowBox[{44, 38}, 0.1079960218576366], 
                    ArrowBox[{45, 46}, 0.1079960218576366], 
                    ArrowBox[{46, 81}, 0.1079960218576366], 
                    ArrowBox[{47, 48}, 0.1079960218576366], 
                    ArrowBox[{48, 91}, 0.1079960218576366], 
                    ArrowBox[{49, 50}, 0.1079960218576366], 
                    ArrowBox[{50, 46}, 0.1079960218576366], 
                    ArrowBox[{51, 52}, 0.1079960218576366], 
                    ArrowBox[{52, 82}, 0.1079960218576366], 
                    ArrowBox[{53, 54}, 0.1079960218576366], 
                    ArrowBox[{54, 61}, 0.1079960218576366], 
                    ArrowBox[{55, 42}, 0.1079960218576366], 
                    ArrowBox[{56, 52}, 0.1079960218576366], 
                    ArrowBox[{57, 60}, 0.1079960218576366], 
                    ArrowBox[{58, 59}, 0.1079960218576366], 
                    ArrowBox[{59, 30}, 0.1079960218576366], 
                    ArrowBox[{60, 63}, 0.1079960218576366], 
                    ArrowBox[{61, 62}, 0.1079960218576366], 
                    ArrowBox[{62, 33}, 0.1079960218576366], 
                    ArrowBox[{63, 30}, 0.1079960218576366], 
                    ArrowBox[{64, 65}, 0.1079960218576366], 
                    ArrowBox[{65, 4}, 0.1079960218576366], 
                    ArrowBox[{66, 45}, 0.1079960218576366], 
                    ArrowBox[{67, 68}, 0.1079960218576366], 
                    ArrowBox[{68, 54}, 0.1079960218576366], 
                    ArrowBox[{69, 46}, 0.1079960218576366], 
                    ArrowBox[{70, 71}, 0.1079960218576366], 
                    ArrowBox[{71, 33}, 0.1079960218576366], 
                    ArrowBox[{72, 43}, 0.1079960218576366], 
                    ArrowBox[{73, 1}, 0.1079960218576366], 
                    ArrowBox[{74, 75}, 0.1079960218576366], 
                    ArrowBox[{75, 63}, 0.1079960218576366], 
                    ArrowBox[{76, 77}, 0.1079960218576366], 
                    ArrowBox[{77, 7}, 0.1079960218576366], 
                    ArrowBox[
                    
                    BezierCurveBox[{78, 104, 107, 109, 115, 117, 120, 78}, 
                    SplineDegree -> 7], 0.1079960218576366], 
                    ArrowBox[{79, 6}, 0.1079960218576366], 
                    ArrowBox[{80, 81}, 0.1079960218576366], 
                    ArrowBox[{81, 89}, 0.1079960218576366], 
                    ArrowBox[{82, 83}, 0.1079960218576366], 
                    ArrowBox[{83, 5}, 0.1079960218576366], 
                    ArrowBox[{84, 67}, 0.1079960218576366], 
                    ArrowBox[{85, 78}, 0.1079960218576366], 
                    ArrowBox[{86, 30}, 0.1079960218576366], 
                    ArrowBox[{87, 12}, 0.1079960218576366], 
                    ArrowBox[{88, 81}, 0.1079960218576366], 
                    ArrowBox[{89, 44}, 0.1079960218576366], 
                    ArrowBox[{90, 37}, 0.1079960218576366], 
                    ArrowBox[{91, 92}, 0.1079960218576366], 
                    ArrowBox[{92, 45}, 0.1079960218576366], 
                    ArrowBox[{93, 42}, 0.1079960218576366], 
                    ArrowBox[{94, 19}, 0.1079960218576366], 
                    ArrowBox[{95, 12}, 0.1079960218576366], 
                    ArrowBox[{96, 32}, 0.1079960218576366], 
                    ArrowBox[{97, 78}, 0.1079960218576366], 
                    ArrowBox[{98, 33}, 0.1079960218576366], 
                    ArrowBox[{99, 10}, 0.1079960218576366], 
                    ArrowBox[{100, 69}, 0.1079960218576366]}}}}, {{{{
                    Hue[0.6, 0.2, 0.8], 
                    EdgeForm[{
                    GrayLevel[0], 
                    Opacity[0.7]}], 
                    DiskBox[1, 0.1079960218576366], 
                    DiskBox[2, 0.1079960218576366], 
                    DiskBox[3, 0.1079960218576366], 
                    DiskBox[4, 0.1079960218576366], 
                    DiskBox[5, 0.1079960218576366], 
                    DiskBox[6, 0.1079960218576366], 
                    DiskBox[7, 0.1079960218576366], 
                    DiskBox[8, 0.1079960218576366], 
                    DiskBox[9, 0.1079960218576366], 
                    DiskBox[10, 0.1079960218576366], 
                    DiskBox[11, 0.1079960218576366], 
                    DiskBox[12, 0.1079960218576366], 
                    DiskBox[13, 0.1079960218576366], 
                    DiskBox[14, 0.1079960218576366], 
                    DiskBox[15, 0.1079960218576366], 
                    DiskBox[16, 0.1079960218576366], 
                    DiskBox[17, 0.1079960218576366], 
                    DiskBox[18, 0.1079960218576366], 
                    DiskBox[19, 0.1079960218576366], 
                    DiskBox[20, 0.1079960218576366], 
                    DiskBox[21, 0.1079960218576366], 
                    DiskBox[22, 0.1079960218576366], 
                    DiskBox[23, 0.1079960218576366], 
                    DiskBox[24, 0.1079960218576366], 
                    DiskBox[25, 0.1079960218576366], 
                    DiskBox[26, 0.1079960218576366], 
                    DiskBox[27, 0.1079960218576366], 
                    DiskBox[28, 0.1079960218576366], 
                    DiskBox[29, 0.1079960218576366], 
                    DiskBox[30, 0.1079960218576366], 
                    DiskBox[31, 0.1079960218576366], 
                    DiskBox[32, 0.1079960218576366], 
                    DiskBox[33, 0.1079960218576366], 
                    DiskBox[34, 0.1079960218576366], 
                    DiskBox[35, 0.1079960218576366], 
                    DiskBox[36, 0.1079960218576366], 
                    DiskBox[37, 0.1079960218576366], 
                    DiskBox[38, 0.1079960218576366], 
                    DiskBox[39, 0.1079960218576366], 
                    DiskBox[40, 0.1079960218576366], 
                    DiskBox[41, 0.1079960218576366], 
                    DiskBox[42, 0.1079960218576366], 
                    DiskBox[43, 0.1079960218576366], 
                    DiskBox[44, 0.1079960218576366], 
                    DiskBox[45, 0.1079960218576366], 
                    DiskBox[46, 0.1079960218576366], 
                    DiskBox[47, 0.1079960218576366], 
                    DiskBox[48, 0.1079960218576366], 
                    DiskBox[49, 0.1079960218576366], 
                    DiskBox[50, 0.1079960218576366], 
                    DiskBox[51, 0.1079960218576366], 
                    DiskBox[52, 0.1079960218576366], 
                    DiskBox[53, 0.1079960218576366], 
                    DiskBox[54, 0.1079960218576366], 
                    DiskBox[55, 0.1079960218576366], 
                    DiskBox[56, 0.1079960218576366], 
                    DiskBox[57, 0.1079960218576366], 
                    DiskBox[58, 0.1079960218576366], 
                    DiskBox[59, 0.1079960218576366], 
                    DiskBox[60, 0.1079960218576366], 
                    DiskBox[61, 0.1079960218576366], 
                    DiskBox[62, 0.1079960218576366], 
                    DiskBox[63, 0.1079960218576366], 
                    DiskBox[64, 0.1079960218576366], 
                    DiskBox[65, 0.1079960218576366], 
                    DiskBox[66, 0.1079960218576366], 
                    DiskBox[67, 0.1079960218576366], 
                    DiskBox[68, 0.1079960218576366], 
                    DiskBox[69, 0.1079960218576366], 
                    DiskBox[70, 0.1079960218576366], 
                    DiskBox[71, 0.1079960218576366], 
                    DiskBox[72, 0.1079960218576366], 
                    DiskBox[73, 0.1079960218576366], 
                    DiskBox[74, 0.1079960218576366], 
                    DiskBox[75, 0.1079960218576366], 
                    DiskBox[76, 0.1079960218576366], 
                    DiskBox[77, 0.1079960218576366], 
                    DiskBox[78, 0.1079960218576366], 
                    DiskBox[79, 0.1079960218576366], 
                    DiskBox[80, 0.1079960218576366], 
                    DiskBox[81, 0.1079960218576366], 
                    DiskBox[82, 0.1079960218576366], 
                    DiskBox[83, 0.1079960218576366], 
                    DiskBox[84, 0.1079960218576366], 
                    DiskBox[85, 0.1079960218576366], 
                    DiskBox[86, 0.1079960218576366], 
                    DiskBox[87, 0.1079960218576366], 
                    DiskBox[88, 0.1079960218576366], 
                    DiskBox[89, 0.1079960218576366], 
                    DiskBox[90, 0.1079960218576366], 
                    DiskBox[91, 0.1079960218576366], 
                    DiskBox[92, 0.1079960218576366], 
                    DiskBox[93, 0.1079960218576366], 
                    DiskBox[94, 0.1079960218576366], 
                    DiskBox[95, 0.1079960218576366], 
                    DiskBox[96, 0.1079960218576366], 
                    DiskBox[97, 0.1079960218576366], 
                    DiskBox[98, 0.1079960218576366], 
                    DiskBox[99, 0.1079960218576366], 
                    DiskBox[100, 0.1079960218576366]}}}}}]}], 
             MouseAppearanceTag["NetworkGraphics"]], 
            AllowKernelInitialization -> False]], 
          DefaultBaseStyle -> {
           "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> 
            Hue[0.8, 1., 0.6]}, FormatType -> TraditionalForm, FrameTicks -> 
          None, GridLinesStyle -> Directive[
            GrayLevel[0.5, 0.4]], ImageSize -> {542.43359375, Automatic}]], 
        "ExerciseOutput", Selectable -> False, Copyable -> False, Editable -> 
        False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"7ef34418-1ffc-4431-acb5-81cf438a42b6"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Generate a graph with 100 nodes, each connecting to two randomly chosen \
nodes.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "21.10", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"7a1571a5-b06d-473c-bef0-b6fec71e0222"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Sample", " ", "expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       GraphicsBox[
        NamespaceBox["NetworkGraphics",
         DynamicModuleBox[{Typeset`graph = HoldComplete[
           
           Graph[{1, 47, 40, 2, 16, 12, 3, 46, 8, 4, 70, 36, 5, 37, 6, 28, 7, 
            25, 92, 9, 66, 35, 10, 85, 15, 11, 97, 79, 67, 13, 98, 78, 14, 30,
             39, 100, 69, 93, 17, 76, 22, 18, 48, 19, 54, 32, 20, 21, 68, 44, 
            61, 23, 65, 24, 26, 51, 27, 29, 33, 94, 31, 99, 64, 58, 87, 88, 
            34, 74, 49, 38, 50, 71, 41, 42, 77, 43, 52, 45, 82, 75, 60, 53, 
            56, 55, 57, 59, 72, 62, 63, 73, 91, 80, 81, 86, 83, 84, 96, 89, 
            90, 95}, {CompressedData["
1:eJwVxWt7qQAAAGBLTFO5RBQpRUstSnIZo1K5Zbm0sdmYtu/7m+dnnXM+vM9b
DX93IRCJRP788/8b4CYKxsD4beIWukvewQiKJFJIKp1BM1EoC2G5fA4vFAsE
WSLL8XycqtAVpspWOaJG1GN8DLgX7hsiIEoP8kOzpbRUBVfaDaWhdUodvQt3
wWw2q/T6PWTQHQBpOk09go8yO2RHT+OnSdNomkNkaE3tKYPreAEewBjqoBm3
7M44iSOj8yixIBaz5WqJe6Zntddt71l89hOphAvQwEZSJMbxHGemzZA+1EfX
6Hq7U3cV2ZL3gR/Ye2/PveAvpCEb3KvyOtwWtgfN1eyjcfTf6DdhYkwm+kKH
8m6+R40oXq2ruXqvvkqiSWXuzo+H1KHz3nk/2b7d2HQ3geAK4MpciQzBHMp4
Gf2QPtRP7/PsC759oS7BF/ZFFoOifb6eEdMzd9bCYkMkDL9b3/BJOInYHtvw
A345qoyon/5P5lq8XktaaUo7dGKsjy81vsb+BaflTGM=
             "], Null}]]}, 
          TagBox[GraphicsGroupBox[GraphicsComplexBox[CompressedData["
1:eJw1l3k0FF7Yx2fDLJYZZmyJZKnsW5FwH1lbZImyk0j5CRFJKkRESVJZSouS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             "], {
              {Hue[0.6, 0.7, 0.5], Opacity[0.7], Arrowheads[
               0.020073972170377628`], 
               ArrowBox[{1, 2}, 0.049006281161920934`], 
               ArrowBox[{1, 3}, 0.049006281161920934`], 
               ArrowBox[{2, 31}, 0.049006281161920934`], 
               ArrowBox[{2, 80}, 0.049006281161920934`], 
               ArrowBox[{3, 25}, 0.049006281161920934`], 
               ArrowBox[{3, 72}, 0.049006281161920934`], 
               ArrowBox[{4, 5}, 0.049006281161920934`], 
               ArrowBox[{4, 6}, 0.049006281161920934`], 
               ArrowBox[{5, 2}, 0.049006281161920934`], 
               ArrowBox[{5, 38}, 0.049006281161920934`], 
               ArrowBox[{6, 21}, 0.049006281161920934`], 
               ArrowBox[{6, 29}, 0.049006281161920934`], 
               ArrowBox[{7, 8}, 0.049006281161920934`], 
               ArrowBox[{7, 9}, 0.049006281161920934`], 
               ArrowBox[{8, 15}, 0.049006281161920934`], 
               ArrowBox[{8, 70}, 0.049006281161920934`], 
               ArrowBox[{9, 18}, 0.049006281161920934`], 
               ArrowBox[{9, 19}, 0.049006281161920934`], 
               ArrowBox[{10, 11}, 0.049006281161920934`], 
               ArrowBox[{10, 12}, 0.049006281161920934`], 
               ArrowBox[{11, 14}, 0.049006281161920934`], 
               ArrowBox[{11, 48}, 0.049006281161920934`], 
               ArrowBox[{12, 19}, 0.049006281161920934`], 
               ArrowBox[{12, 57}, 0.049006281161920934`], 
               ArrowBox[{13, 8}, 0.049006281161920934`], 
               ArrowBox[{13, 14}, 0.049006281161920934`], 
               ArrowBox[BezierCurveBox[{
                14, {4.769001578238094, 2.036523318536489}, 17}], 
                0.049006281161920934`], 
               ArrowBox[{14, 69}, 0.049006281161920934`], 
               ArrowBox[{15, 13}, 0.049006281161920934`], 
               ArrowBox[{15, 16}, 0.049006281161920934`], 
               ArrowBox[{16, 29}, 0.049006281161920934`], 
               ArrowBox[{16, 31}, 0.049006281161920934`], 
               ArrowBox[{17, 3}, 0.049006281161920934`], 
               ArrowBox[BezierCurveBox[{
                17, {5.143673671184928, 1.8883713525799235`}, 14}], 
                0.049006281161920934`], 
               ArrowBox[BezierCurveBox[{18, 136, 139, 141, 147, 149, 152, 18},
                
                SplineDegree->7], 0.049006281161920934`], 
               ArrowBox[{18, 48}, 0.049006281161920934`], 
               ArrowBox[{19, 80}, 0.049006281161920934`], 
               ArrowBox[{19, 83}, 0.049006281161920934`], 
               ArrowBox[{20, 21}, 0.049006281161920934`], 
               ArrowBox[{20, 22}, 0.049006281161920934`], 
               ArrowBox[{21, 55}, 0.049006281161920934`], 
               ArrowBox[{21, 70}, 0.049006281161920934`], 
               ArrowBox[{22, 23}, 0.049006281161920934`], 
               ArrowBox[{22, 53}, 0.049006281161920934`], 
               ArrowBox[{23, 24}, 0.049006281161920934`], 
               ArrowBox[{23, 25}, 0.049006281161920934`], 
               ArrowBox[{24, 68}, 0.049006281161920934`], 
               ArrowBox[{24, 84}, 0.049006281161920934`], 
               ArrowBox[{25, 36}, 0.049006281161920934`], 
               ArrowBox[{25, 37}, 0.049006281161920934`], 
               ArrowBox[{26, 27}, 0.049006281161920934`], 
               ArrowBox[{26, 28}, 0.049006281161920934`], 
               ArrowBox[{27, 51}, 0.049006281161920934`], 
               ArrowBox[{27, 67}, 0.049006281161920934`], 
               ArrowBox[{28, 14}, 0.049006281161920934`], 
               ArrowBox[{28, 22}, 0.049006281161920934`], 
               ArrowBox[{29, 38}, 0.049006281161920934`], 
               ArrowBox[BezierCurveBox[{
                29, {2.6502454992215063`, 2.799327595550823}, 60}], 
                0.049006281161920934`], 
               ArrowBox[{30, 31}, 0.049006281161920934`], 
               ArrowBox[{30, 32}, 0.049006281161920934`], 
               ArrowBox[{31, 8}, 0.049006281161920934`], 
               ArrowBox[{31, 69}, 0.049006281161920934`], 
               ArrowBox[{32, 25}, 0.049006281161920934`], 
               ArrowBox[{32, 87}, 0.049006281161920934`], 
               ArrowBox[{33, 34}, 0.049006281161920934`], 
               ArrowBox[{33, 35}, 0.049006281161920934`], 
               ArrowBox[{34, 59}, 0.049006281161920934`], 
               ArrowBox[{34, 60}, 0.049006281161920934`], 
               ArrowBox[{35, 26}, 0.049006281161920934`], 
               ArrowBox[{35, 43}, 0.049006281161920934`], 
               ArrowBox[{36, 34}, 0.049006281161920934`], 
               ArrowBox[{36, 38}, 0.049006281161920934`], 
               ArrowBox[{37, 55}, 0.049006281161920934`], 
               ArrowBox[{37, 75}, 0.049006281161920934`], 
               ArrowBox[{38, 57}, 0.049006281161920934`], 
               ArrowBox[{38, 74}, 0.049006281161920934`], 
               ArrowBox[{39, 40}, 0.049006281161920934`], 
               ArrowBox[{39, 41}, 0.049006281161920934`], 
               ArrowBox[{40, 4}, 0.049006281161920934`], 
               ArrowBox[{40, 70}, 0.049006281161920934`], 
               ArrowBox[{41, 48}, 0.049006281161920934`], 
               ArrowBox[{41, 51}, 0.049006281161920934`], 
               ArrowBox[{42, 2}, 0.049006281161920934`], 
               ArrowBox[{42, 43}, 0.049006281161920934`], 
               ArrowBox[{43, 32}, 0.049006281161920934`], 
               ArrowBox[{43, 48}, 0.049006281161920934`], 
               ArrowBox[{44, 45}, 0.049006281161920934`], 
               ArrowBox[{44, 46}, 0.049006281161920934`], 
               ArrowBox[{45, 66}, 0.049006281161920934`], 
               ArrowBox[{45, 83}, 0.049006281161920934`], 
               ArrowBox[{46, 64}, 0.049006281161920934`], 
               ArrowBox[{46, 65}, 0.049006281161920934`], 
               ArrowBox[{47, 48}, 0.049006281161920934`], 
               ArrowBox[{47, 49}, 0.049006281161920934`], 
               ArrowBox[{48, 22}, 0.049006281161920934`], 
               ArrowBox[{48, 50}, 0.049006281161920934`], 
               ArrowBox[{49, 20}, 0.049006281161920934`], 
               ArrowBox[{49, 37}, 0.049006281161920934`], 
               ArrowBox[{50, 76}, 0.049006281161920934`], 
               ArrowBox[{50, 77}, 0.049006281161920934`], 
               ArrowBox[{51, 68}, 0.049006281161920934`], 
               ArrowBox[{51, 70}, 0.049006281161920934`], 
               ArrowBox[{52, 27}, 0.049006281161920934`], 
               ArrowBox[{52, 53}, 0.049006281161920934`], 
               ArrowBox[{53, 9}, 0.049006281161920934`], 
               ArrowBox[{53, 73}, 0.049006281161920934`], 
               ArrowBox[{54, 4}, 0.049006281161920934`], 
               ArrowBox[{54, 12}, 0.049006281161920934`], 
               ArrowBox[{55, 13}, 0.049006281161920934`], 
               ArrowBox[{55, 56}, 0.049006281161920934`], 
               ArrowBox[{56, 9}, 0.049006281161920934`], 
               ArrowBox[{56, 14}, 0.049006281161920934`], 
               ArrowBox[{57, 2}, 0.049006281161920934`], 
               ArrowBox[{57, 54}, 0.049006281161920934`], 
               ArrowBox[{58, 4}, 0.049006281161920934`], 
               ArrowBox[{58, 45}, 0.049006281161920934`], 
               ArrowBox[{59, 13}, 0.049006281161920934`], 
               ArrowBox[{59, 66}, 0.049006281161920934`], 
               ArrowBox[BezierCurveBox[{
                60, {2.325401736746616, 2.83715938991489}, 29}], 
                0.049006281161920934`], 
               ArrowBox[{60, 30}, 0.049006281161920934`], 
               ArrowBox[{61, 62}, 0.049006281161920934`], 
               ArrowBox[{61, 63}, 0.049006281161920934`], 
               ArrowBox[{62, 53}, 0.049006281161920934`], 
               ArrowBox[{62, 95}, 0.049006281161920934`], 
               ArrowBox[BezierCurveBox[{63, 191, 194, 196, 202, 204, 207, 63},
                
                SplineDegree->7], 0.049006281161920934`], 
               ArrowBox[{63, 64}, 0.049006281161920934`], 
               ArrowBox[{64, 35}, 0.049006281161920934`], 
               ArrowBox[{64, 45}, 0.049006281161920934`], 
               ArrowBox[BezierCurveBox[{
                65, {2.695757019481839, 0.873897262955156}, 76}], 
                0.049006281161920934`], 
               ArrowBox[{65, 82}, 0.049006281161920934`], 
               ArrowBox[{66, 34}, 0.049006281161920934`], 
               ArrowBox[{66, 73}, 0.049006281161920934`], 
               ArrowBox[{67, 32}, 0.049006281161920934`], 
               ArrowBox[{67, 68}, 0.049006281161920934`], 
               ArrowBox[{68, 41}, 0.049006281161920934`], 
               ArrowBox[BezierCurveBox[{
                68, {2.8397382352912195`, 3.2935654909573904`}, 79}], 
                0.049006281161920934`], 
               ArrowBox[BezierCurveBox[{69, 246, 249, 251, 257, 259, 262, 69},
                
                SplineDegree->7], 0.049006281161920934`], 
               ArrowBox[{69, 76}, 0.049006281161920934`], 
               ArrowBox[{70, 28}, 0.049006281161920934`], 
               ArrowBox[{70, 71}, 0.049006281161920934`], 
               ArrowBox[{71, 13}, 0.049006281161920934`], 
               ArrowBox[{71, 51}, 0.049006281161920934`], 
               ArrowBox[{72, 70}, 0.049006281161920934`], 
               ArrowBox[{72, 88}, 0.049006281161920934`], 
               ArrowBox[{73, 25}, 0.049006281161920934`], 
               ArrowBox[{73, 71}, 0.049006281161920934`], 
               ArrowBox[{74, 22}, 0.049006281161920934`], 
               ArrowBox[{74, 75}, 0.049006281161920934`], 
               ArrowBox[{75, 42}, 0.049006281161920934`], 
               ArrowBox[{75, 65}, 0.049006281161920934`], 
               ArrowBox[BezierCurveBox[{
                76, {2.6349628959443323`, 0.40535178081571965`}, 65}], 
                0.049006281161920934`], 
               ArrowBox[{76, 66}, 0.049006281161920934`], 
               ArrowBox[{77, 14}, 0.049006281161920934`], 
               ArrowBox[{77, 81}, 0.049006281161920934`], 
               ArrowBox[{78, 42}, 0.049006281161920934`], 
               ArrowBox[{78, 79}, 0.049006281161920934`], 
               ArrowBox[{79, 40}, 0.049006281161920934`], 
               ArrowBox[BezierCurveBox[{
                79, {2.9682269715627094`, 3.6620893743798972`}, 68}], 
                0.049006281161920934`], 
               ArrowBox[{80, 54}, 0.049006281161920934`], 
               ArrowBox[{80, 84}, 0.049006281161920934`], 
               ArrowBox[{81, 23}, 0.049006281161920934`], 
               ArrowBox[{81, 87}, 0.049006281161920934`], 
               ArrowBox[{82, 30}, 0.049006281161920934`], 
               ArrowBox[{82, 49}, 0.049006281161920934`], 
               ArrowBox[{83, 35}, 0.049006281161920934`], 
               ArrowBox[{83, 76}, 0.049006281161920934`], 
               ArrowBox[{84, 68}, 0.049006281161920934`], 
               ArrowBox[{84, 79}, 0.049006281161920934`], 
               ArrowBox[{85, 22}, 0.049006281161920934`], 
               ArrowBox[{85, 26}, 0.049006281161920934`], 
               ArrowBox[{86, 48}, 0.049006281161920934`], 
               ArrowBox[{86, 59}, 0.049006281161920934`], 
               ArrowBox[{87, 15}, 0.049006281161920934`], 
               ArrowBox[{87, 52}, 0.049006281161920934`], 
               ArrowBox[{88, 64}, 0.049006281161920934`], 
               ArrowBox[{88, 79}, 0.049006281161920934`], 
               ArrowBox[{89, 31}, 0.049006281161920934`], 
               ArrowBox[{89, 40}, 0.049006281161920934`], 
               ArrowBox[{90, 52}, 0.049006281161920934`], 
               ArrowBox[{90, 91}, 0.049006281161920934`], 
               ArrowBox[{91, 40}, 0.049006281161920934`], 
               ArrowBox[{91, 42}, 0.049006281161920934`], 
               ArrowBox[{92, 43}, 0.049006281161920934`], 
               ArrowBox[{92, 49}, 0.049006281161920934`], 
               ArrowBox[{93, 76}, 0.049006281161920934`], 
               ArrowBox[{93, 94}, 0.049006281161920934`], 
               ArrowBox[{94, 13}, 0.049006281161920934`], 
               ArrowBox[{94, 97}, 0.049006281161920934`], 
               ArrowBox[{95, 29}, 0.049006281161920934`], 
               ArrowBox[{95, 84}, 0.049006281161920934`], 
               ArrowBox[{96, 19}, 0.049006281161920934`], 
               ArrowBox[{96, 26}, 0.049006281161920934`], 
               ArrowBox[{97, 24}, 0.049006281161920934`], 
               ArrowBox[BezierCurveBox[{97, 301, 304, 306, 312, 314, 317, 97},
                
                SplineDegree->7], 0.049006281161920934`], 
               ArrowBox[{98, 13}, 0.049006281161920934`], 
               ArrowBox[BezierCurveBox[{98, 324, 327, 329, 335, 337, 340, 98},
                
                SplineDegree->7], 0.049006281161920934`], 
               ArrowBox[{99, 12}, 0.049006281161920934`], 
               ArrowBox[{99, 47}, 0.049006281161920934`], 
               ArrowBox[{100, 17}, 0.049006281161920934`], 
               ArrowBox[{100, 56}, 0.049006281161920934`]}, 
              {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[0.7]}], 
               DiskBox[1, 0.049006281161920934], 
               DiskBox[2, 0.049006281161920934], 
               DiskBox[3, 0.049006281161920934], 
               DiskBox[4, 0.049006281161920934], 
               DiskBox[5, 0.049006281161920934], 
               DiskBox[6, 0.049006281161920934], 
               DiskBox[7, 0.049006281161920934], 
               DiskBox[8, 0.049006281161920934], 
               DiskBox[9, 0.049006281161920934], 
               DiskBox[10, 0.049006281161920934], 
               DiskBox[11, 0.049006281161920934], 
               DiskBox[12, 0.049006281161920934], 
               DiskBox[13, 0.049006281161920934], 
               DiskBox[14, 0.049006281161920934], 
               DiskBox[15, 0.049006281161920934], 
               DiskBox[16, 0.049006281161920934], 
               DiskBox[17, 0.049006281161920934], 
               DiskBox[18, 0.049006281161920934], 
               DiskBox[19, 0.049006281161920934], 
               DiskBox[20, 0.049006281161920934], 
               DiskBox[21, 0.049006281161920934], 
               DiskBox[22, 0.049006281161920934], 
               DiskBox[23, 0.049006281161920934], 
               DiskBox[24, 0.049006281161920934], 
               DiskBox[25, 0.049006281161920934], 
               DiskBox[26, 0.049006281161920934], 
               DiskBox[27, 0.049006281161920934], 
               DiskBox[28, 0.049006281161920934], 
               DiskBox[29, 0.049006281161920934], 
               DiskBox[30, 0.049006281161920934], 
               DiskBox[31, 0.049006281161920934], 
               DiskBox[32, 0.049006281161920934], 
               DiskBox[33, 0.049006281161920934], 
               DiskBox[34, 0.049006281161920934], 
               DiskBox[35, 0.049006281161920934], 
               DiskBox[36, 0.049006281161920934], 
               DiskBox[37, 0.049006281161920934], 
               DiskBox[38, 0.049006281161920934], 
               DiskBox[39, 0.049006281161920934], 
               DiskBox[40, 0.049006281161920934], 
               DiskBox[41, 0.049006281161920934], 
               DiskBox[42, 0.049006281161920934], 
               DiskBox[43, 0.049006281161920934], 
               DiskBox[44, 0.049006281161920934], 
               DiskBox[45, 0.049006281161920934], 
               DiskBox[46, 0.049006281161920934], 
               DiskBox[47, 0.049006281161920934], 
               DiskBox[48, 0.049006281161920934], 
               DiskBox[49, 0.049006281161920934], 
               DiskBox[50, 0.049006281161920934], 
               DiskBox[51, 0.049006281161920934], 
               DiskBox[52, 0.049006281161920934], 
               DiskBox[53, 0.049006281161920934], 
               DiskBox[54, 0.049006281161920934], 
               DiskBox[55, 0.049006281161920934], 
               DiskBox[56, 0.049006281161920934], 
               DiskBox[57, 0.049006281161920934], 
               DiskBox[58, 0.049006281161920934], 
               DiskBox[59, 0.049006281161920934], 
               DiskBox[60, 0.049006281161920934], 
               DiskBox[61, 0.049006281161920934], 
               DiskBox[62, 0.049006281161920934], 
               DiskBox[63, 0.049006281161920934], 
               DiskBox[64, 0.049006281161920934], 
               DiskBox[65, 0.049006281161920934], 
               DiskBox[66, 0.049006281161920934], 
               DiskBox[67, 0.049006281161920934], 
               DiskBox[68, 0.049006281161920934], 
               DiskBox[69, 0.049006281161920934], 
               DiskBox[70, 0.049006281161920934], 
               DiskBox[71, 0.049006281161920934], 
               DiskBox[72, 0.049006281161920934], 
               DiskBox[73, 0.049006281161920934], 
               DiskBox[74, 0.049006281161920934], 
               DiskBox[75, 0.049006281161920934], 
               DiskBox[76, 0.049006281161920934], 
               DiskBox[77, 0.049006281161920934], 
               DiskBox[78, 0.049006281161920934], 
               DiskBox[79, 0.049006281161920934], 
               DiskBox[80, 0.049006281161920934], 
               DiskBox[81, 0.049006281161920934], 
               DiskBox[82, 0.049006281161920934], 
               DiskBox[83, 0.049006281161920934], 
               DiskBox[84, 0.049006281161920934], 
               DiskBox[85, 0.049006281161920934], 
               DiskBox[86, 0.049006281161920934], 
               DiskBox[87, 0.049006281161920934], 
               DiskBox[88, 0.049006281161920934], 
               DiskBox[89, 0.049006281161920934], 
               DiskBox[90, 0.049006281161920934], 
               DiskBox[91, 0.049006281161920934], 
               DiskBox[92, 0.049006281161920934], 
               DiskBox[93, 0.049006281161920934], 
               DiskBox[94, 0.049006281161920934], 
               DiskBox[95, 0.049006281161920934], 
               DiskBox[96, 0.049006281161920934], 
               DiskBox[97, 0.049006281161920934], 
               DiskBox[98, 0.049006281161920934], 
               DiskBox[99, 0.049006281161920934], 
               DiskBox[100, 0.049006281161920934]}}]],
           MouseAppearanceTag["NetworkGraphics"]],
          AllowKernelInitialization->False]],
        DefaultBaseStyle->{
         "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> 
          Hue[0.8, 1., 0.6]},
        FormatType->TraditionalForm,
        FrameTicks->None,
        GridLinesStyle->Directive[
          GrayLevel[0.5, 0.4]]]], "ExerciseOutput",ExpressionUUID->
       "466e3943-9cde-46a8-bb72-e0f88131bd58"],
      Apply[TextCell, 
       Cell[
        BoxData[
         GraphicsBox[
          NamespaceBox["NetworkGraphics", 
           DynamicModuleBox[{Typeset`graph = HoldComplete[
               
               Graph[{1, 47, 40, 2, 16, 12, 3, 46, 8, 4, 70, 36, 5, 37, 6, 28,
                 7, 25, 92, 9, 66, 35, 10, 85, 15, 11, 97, 79, 67, 13, 98, 78,
                 14, 30, 39, 100, 69, 93, 17, 76, 22, 18, 48, 19, 54, 32, 20, 
                21, 68, 44, 61, 23, 65, 24, 26, 51, 27, 29, 33, 94, 31, 99, 
                64, 58, 87, 88, 34, 74, 49, 38, 50, 71, 41, 42, 77, 43, 52, 
                45, 82, 75, 60, 53, 56, 55, 57, 59, 72, 62, 63, 73, 91, 80, 
                81, 86, 83, 84, 96, 89, 90, 95}, {CompressedData["
1:eJwVxWt7qQAAAGBLTFO5RBQpRUstSnIZo1K5Zbm0sdmYtu/7m+dnnXM+vM9b
DX93IRCJRP788/8b4CYKxsD4beIWukvewQiKJFJIKp1BM1EoC2G5fA4vFAsE
WSLL8XycqtAVpspWOaJG1GN8DLgX7hsiIEoP8kOzpbRUBVfaDaWhdUodvQt3
wWw2q/T6PWTQHQBpOk09go8yO2RHT+OnSdNomkNkaE3tKYPreAEewBjqoBm3
7M44iSOj8yixIBaz5WqJe6Zntddt71l89hOphAvQwEZSJMbxHGemzZA+1EfX
6Hq7U3cV2ZL3gR/Ye2/PveAvpCEb3KvyOtwWtgfN1eyjcfTf6DdhYkwm+kKH
8m6+R40oXq2ruXqvvkqiSWXuzo+H1KHz3nk/2b7d2HQ3geAK4MpciQzBHMp4
Gf2QPtRP7/PsC759oS7BF/ZFFoOifb6eEdMzd9bCYkMkDL9b3/BJOInYHtvw
A345qoyon/5P5lq8XktaaUo7dGKsjy81vsb+BaflTGM=
                 "], Null}]]}, 
            TagBox[
             GraphicsGroupBox[{
               GraphicsComplexBox[CompressedData["
1:eJw1l3k0FF7Yx2fDLJYZZmyJZKnsW5FwH1lbZImyk0j5CRFJKkRESVJZSouS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                "], {{{{{
                    Hue[0.6, 0.7, 0.5], 
                    Opacity[0.7], 
                    Arrowheads[0.020073972170377628`], 
                    ArrowBox[{1, 2}, 0.049006281161920934`], 
                    ArrowBox[{1, 3}, 0.049006281161920934`], 
                    ArrowBox[{2, 31}, 0.049006281161920934`], 
                    ArrowBox[{2, 80}, 0.049006281161920934`], 
                    ArrowBox[{3, 25}, 0.049006281161920934`], 
                    ArrowBox[{3, 72}, 0.049006281161920934`], 
                    ArrowBox[{4, 5}, 0.049006281161920934`], 
                    ArrowBox[{4, 6}, 0.049006281161920934`], 
                    ArrowBox[{5, 2}, 0.049006281161920934`], 
                    ArrowBox[{5, 38}, 0.049006281161920934`], 
                    ArrowBox[{6, 21}, 0.049006281161920934`], 
                    ArrowBox[{6, 29}, 0.049006281161920934`], 
                    ArrowBox[{7, 8}, 0.049006281161920934`], 
                    ArrowBox[{7, 9}, 0.049006281161920934`], 
                    ArrowBox[{8, 15}, 0.049006281161920934`], 
                    ArrowBox[{8, 70}, 0.049006281161920934`], 
                    ArrowBox[{9, 18}, 0.049006281161920934`], 
                    ArrowBox[{9, 19}, 0.049006281161920934`], 
                    ArrowBox[{10, 11}, 0.049006281161920934`], 
                    ArrowBox[{10, 12}, 0.049006281161920934`], 
                    ArrowBox[{11, 14}, 0.049006281161920934`], 
                    ArrowBox[{11, 48}, 0.049006281161920934`], 
                    ArrowBox[{12, 19}, 0.049006281161920934`], 
                    ArrowBox[{12, 57}, 0.049006281161920934`], 
                    ArrowBox[{13, 8}, 0.049006281161920934`], 
                    ArrowBox[{13, 14}, 0.049006281161920934`], 
                    ArrowBox[
                    
                    BezierCurveBox[{
                    14, {4.769001578238094, 2.036523318536489}, 17}], 
                    0.049006281161920934`], 
                    ArrowBox[{14, 69}, 0.049006281161920934`], 
                    ArrowBox[{15, 13}, 0.049006281161920934`], 
                    ArrowBox[{15, 16}, 0.049006281161920934`], 
                    ArrowBox[{16, 29}, 0.049006281161920934`], 
                    ArrowBox[{16, 31}, 0.049006281161920934`], 
                    ArrowBox[{17, 3}, 0.049006281161920934`], 
                    ArrowBox[
                    
                    BezierCurveBox[{
                    17, {5.143673671184928, 1.8883713525799235`}, 14}], 
                    0.049006281161920934`], 
                    ArrowBox[
                    
                    BezierCurveBox[{18, 136, 139, 141, 147, 149, 152, 18}, 
                    SplineDegree -> 7], 0.049006281161920934`], 
                    ArrowBox[{18, 48}, 0.049006281161920934`], 
                    ArrowBox[{19, 80}, 0.049006281161920934`], 
                    ArrowBox[{19, 83}, 0.049006281161920934`], 
                    ArrowBox[{20, 21}, 0.049006281161920934`], 
                    ArrowBox[{20, 22}, 0.049006281161920934`], 
                    ArrowBox[{21, 55}, 0.049006281161920934`], 
                    ArrowBox[{21, 70}, 0.049006281161920934`], 
                    ArrowBox[{22, 23}, 0.049006281161920934`], 
                    ArrowBox[{22, 53}, 0.049006281161920934`], 
                    ArrowBox[{23, 24}, 0.049006281161920934`], 
                    ArrowBox[{23, 25}, 0.049006281161920934`], 
                    ArrowBox[{24, 68}, 0.049006281161920934`], 
                    ArrowBox[{24, 84}, 0.049006281161920934`], 
                    ArrowBox[{25, 36}, 0.049006281161920934`], 
                    ArrowBox[{25, 37}, 0.049006281161920934`], 
                    ArrowBox[{26, 27}, 0.049006281161920934`], 
                    ArrowBox[{26, 28}, 0.049006281161920934`], 
                    ArrowBox[{27, 51}, 0.049006281161920934`], 
                    ArrowBox[{27, 67}, 0.049006281161920934`], 
                    ArrowBox[{28, 14}, 0.049006281161920934`], 
                    ArrowBox[{28, 22}, 0.049006281161920934`], 
                    ArrowBox[{29, 38}, 0.049006281161920934`], 
                    ArrowBox[
                    
                    BezierCurveBox[{
                    29, {2.6502454992215063`, 2.799327595550823}, 60}], 
                    0.049006281161920934`], 
                    ArrowBox[{30, 31}, 0.049006281161920934`], 
                    ArrowBox[{30, 32}, 0.049006281161920934`], 
                    ArrowBox[{31, 8}, 0.049006281161920934`], 
                    ArrowBox[{31, 69}, 0.049006281161920934`], 
                    ArrowBox[{32, 25}, 0.049006281161920934`], 
                    ArrowBox[{32, 87}, 0.049006281161920934`], 
                    ArrowBox[{33, 34}, 0.049006281161920934`], 
                    ArrowBox[{33, 35}, 0.049006281161920934`], 
                    ArrowBox[{34, 59}, 0.049006281161920934`], 
                    ArrowBox[{34, 60}, 0.049006281161920934`], 
                    ArrowBox[{35, 26}, 0.049006281161920934`], 
                    ArrowBox[{35, 43}, 0.049006281161920934`], 
                    ArrowBox[{36, 34}, 0.049006281161920934`], 
                    ArrowBox[{36, 38}, 0.049006281161920934`], 
                    ArrowBox[{37, 55}, 0.049006281161920934`], 
                    ArrowBox[{37, 75}, 0.049006281161920934`], 
                    ArrowBox[{38, 57}, 0.049006281161920934`], 
                    ArrowBox[{38, 74}, 0.049006281161920934`], 
                    ArrowBox[{39, 40}, 0.049006281161920934`], 
                    ArrowBox[{39, 41}, 0.049006281161920934`], 
                    ArrowBox[{40, 4}, 0.049006281161920934`], 
                    ArrowBox[{40, 70}, 0.049006281161920934`], 
                    ArrowBox[{41, 48}, 0.049006281161920934`], 
                    ArrowBox[{41, 51}, 0.049006281161920934`], 
                    ArrowBox[{42, 2}, 0.049006281161920934`], 
                    ArrowBox[{42, 43}, 0.049006281161920934`], 
                    ArrowBox[{43, 32}, 0.049006281161920934`], 
                    ArrowBox[{43, 48}, 0.049006281161920934`], 
                    ArrowBox[{44, 45}, 0.049006281161920934`], 
                    ArrowBox[{44, 46}, 0.049006281161920934`], 
                    ArrowBox[{45, 66}, 0.049006281161920934`], 
                    ArrowBox[{45, 83}, 0.049006281161920934`], 
                    ArrowBox[{46, 64}, 0.049006281161920934`], 
                    ArrowBox[{46, 65}, 0.049006281161920934`], 
                    ArrowBox[{47, 48}, 0.049006281161920934`], 
                    ArrowBox[{47, 49}, 0.049006281161920934`], 
                    ArrowBox[{48, 22}, 0.049006281161920934`], 
                    ArrowBox[{48, 50}, 0.049006281161920934`], 
                    ArrowBox[{49, 20}, 0.049006281161920934`], 
                    ArrowBox[{49, 37}, 0.049006281161920934`], 
                    ArrowBox[{50, 76}, 0.049006281161920934`], 
                    ArrowBox[{50, 77}, 0.049006281161920934`], 
                    ArrowBox[{51, 68}, 0.049006281161920934`], 
                    ArrowBox[{51, 70}, 0.049006281161920934`], 
                    ArrowBox[{52, 27}, 0.049006281161920934`], 
                    ArrowBox[{52, 53}, 0.049006281161920934`], 
                    ArrowBox[{53, 9}, 0.049006281161920934`], 
                    ArrowBox[{53, 73}, 0.049006281161920934`], 
                    ArrowBox[{54, 4}, 0.049006281161920934`], 
                    ArrowBox[{54, 12}, 0.049006281161920934`], 
                    ArrowBox[{55, 13}, 0.049006281161920934`], 
                    ArrowBox[{55, 56}, 0.049006281161920934`], 
                    ArrowBox[{56, 9}, 0.049006281161920934`], 
                    ArrowBox[{56, 14}, 0.049006281161920934`], 
                    ArrowBox[{57, 2}, 0.049006281161920934`], 
                    ArrowBox[{57, 54}, 0.049006281161920934`], 
                    ArrowBox[{58, 4}, 0.049006281161920934`], 
                    ArrowBox[{58, 45}, 0.049006281161920934`], 
                    ArrowBox[{59, 13}, 0.049006281161920934`], 
                    ArrowBox[{59, 66}, 0.049006281161920934`], 
                    ArrowBox[
                    
                    BezierCurveBox[{
                    60, {2.325401736746616, 2.83715938991489}, 29}], 
                    0.049006281161920934`], 
                    ArrowBox[{60, 30}, 0.049006281161920934`], 
                    ArrowBox[{61, 62}, 0.049006281161920934`], 
                    ArrowBox[{61, 63}, 0.049006281161920934`], 
                    ArrowBox[{62, 53}, 0.049006281161920934`], 
                    ArrowBox[{62, 95}, 0.049006281161920934`], 
                    ArrowBox[
                    
                    BezierCurveBox[{63, 191, 194, 196, 202, 204, 207, 63}, 
                    SplineDegree -> 7], 0.049006281161920934`], 
                    ArrowBox[{63, 64}, 0.049006281161920934`], 
                    ArrowBox[{64, 35}, 0.049006281161920934`], 
                    ArrowBox[{64, 45}, 0.049006281161920934`], 
                    ArrowBox[
                    
                    BezierCurveBox[{
                    65, {2.695757019481839, 0.873897262955156}, 76}], 
                    0.049006281161920934`], 
                    ArrowBox[{65, 82}, 0.049006281161920934`], 
                    ArrowBox[{66, 34}, 0.049006281161920934`], 
                    ArrowBox[{66, 73}, 0.049006281161920934`], 
                    ArrowBox[{67, 32}, 0.049006281161920934`], 
                    ArrowBox[{67, 68}, 0.049006281161920934`], 
                    ArrowBox[{68, 41}, 0.049006281161920934`], 
                    ArrowBox[
                    
                    BezierCurveBox[{
                    68, {2.8397382352912195`, 3.2935654909573904`}, 79}], 
                    0.049006281161920934`], 
                    ArrowBox[
                    
                    BezierCurveBox[{69, 246, 249, 251, 257, 259, 262, 69}, 
                    SplineDegree -> 7], 0.049006281161920934`], 
                    ArrowBox[{69, 76}, 0.049006281161920934`], 
                    ArrowBox[{70, 28}, 0.049006281161920934`], 
                    ArrowBox[{70, 71}, 0.049006281161920934`], 
                    ArrowBox[{71, 13}, 0.049006281161920934`], 
                    ArrowBox[{71, 51}, 0.049006281161920934`], 
                    ArrowBox[{72, 70}, 0.049006281161920934`], 
                    ArrowBox[{72, 88}, 0.049006281161920934`], 
                    ArrowBox[{73, 25}, 0.049006281161920934`], 
                    ArrowBox[{73, 71}, 0.049006281161920934`], 
                    ArrowBox[{74, 22}, 0.049006281161920934`], 
                    ArrowBox[{74, 75}, 0.049006281161920934`], 
                    ArrowBox[{75, 42}, 0.049006281161920934`], 
                    ArrowBox[{75, 65}, 0.049006281161920934`], 
                    ArrowBox[
                    
                    BezierCurveBox[{
                    76, {2.6349628959443323`, 0.40535178081571965`}, 65}], 
                    0.049006281161920934`], 
                    ArrowBox[{76, 66}, 0.049006281161920934`], 
                    ArrowBox[{77, 14}, 0.049006281161920934`], 
                    ArrowBox[{77, 81}, 0.049006281161920934`], 
                    ArrowBox[{78, 42}, 0.049006281161920934`], 
                    ArrowBox[{78, 79}, 0.049006281161920934`], 
                    ArrowBox[{79, 40}, 0.049006281161920934`], 
                    ArrowBox[
                    
                    BezierCurveBox[{
                    79, {2.9682269715627094`, 3.6620893743798972`}, 68}], 
                    0.049006281161920934`], 
                    ArrowBox[{80, 54}, 0.049006281161920934`], 
                    ArrowBox[{80, 84}, 0.049006281161920934`], 
                    ArrowBox[{81, 23}, 0.049006281161920934`], 
                    ArrowBox[{81, 87}, 0.049006281161920934`], 
                    ArrowBox[{82, 30}, 0.049006281161920934`], 
                    ArrowBox[{82, 49}, 0.049006281161920934`], 
                    ArrowBox[{83, 35}, 0.049006281161920934`], 
                    ArrowBox[{83, 76}, 0.049006281161920934`], 
                    ArrowBox[{84, 68}, 0.049006281161920934`], 
                    ArrowBox[{84, 79}, 0.049006281161920934`], 
                    ArrowBox[{85, 22}, 0.049006281161920934`], 
                    ArrowBox[{85, 26}, 0.049006281161920934`], 
                    ArrowBox[{86, 48}, 0.049006281161920934`], 
                    ArrowBox[{86, 59}, 0.049006281161920934`], 
                    ArrowBox[{87, 15}, 0.049006281161920934`], 
                    ArrowBox[{87, 52}, 0.049006281161920934`], 
                    ArrowBox[{88, 64}, 0.049006281161920934`], 
                    ArrowBox[{88, 79}, 0.049006281161920934`], 
                    ArrowBox[{89, 31}, 0.049006281161920934`], 
                    ArrowBox[{89, 40}, 0.049006281161920934`], 
                    ArrowBox[{90, 52}, 0.049006281161920934`], 
                    ArrowBox[{90, 91}, 0.049006281161920934`], 
                    ArrowBox[{91, 40}, 0.049006281161920934`], 
                    ArrowBox[{91, 42}, 0.049006281161920934`], 
                    ArrowBox[{92, 43}, 0.049006281161920934`], 
                    ArrowBox[{92, 49}, 0.049006281161920934`], 
                    ArrowBox[{93, 76}, 0.049006281161920934`], 
                    ArrowBox[{93, 94}, 0.049006281161920934`], 
                    ArrowBox[{94, 13}, 0.049006281161920934`], 
                    ArrowBox[{94, 97}, 0.049006281161920934`], 
                    ArrowBox[{95, 29}, 0.049006281161920934`], 
                    ArrowBox[{95, 84}, 0.049006281161920934`], 
                    ArrowBox[{96, 19}, 0.049006281161920934`], 
                    ArrowBox[{96, 26}, 0.049006281161920934`], 
                    ArrowBox[{97, 24}, 0.049006281161920934`], 
                    ArrowBox[
                    
                    BezierCurveBox[{97, 301, 304, 306, 312, 314, 317, 97}, 
                    SplineDegree -> 7], 0.049006281161920934`], 
                    ArrowBox[{98, 13}, 0.049006281161920934`], 
                    ArrowBox[
                    
                    BezierCurveBox[{98, 324, 327, 329, 335, 337, 340, 98}, 
                    SplineDegree -> 7], 0.049006281161920934`], 
                    ArrowBox[{99, 12}, 0.049006281161920934`], 
                    ArrowBox[{99, 47}, 0.049006281161920934`], 
                    ArrowBox[{100, 17}, 0.049006281161920934`], 
                    ArrowBox[{100, 56}, 0.049006281161920934`]}}}}, {{{{
                    Hue[0.6, 0.2, 0.8], 
                    EdgeForm[{
                    GrayLevel[0], 
                    Opacity[0.7]}], 
                    DiskBox[1, 0.049006281161920934`], 
                    DiskBox[2, 0.049006281161920934`], 
                    DiskBox[3, 0.049006281161920934`], 
                    DiskBox[4, 0.049006281161920934`], 
                    DiskBox[5, 0.049006281161920934`], 
                    DiskBox[6, 0.049006281161920934`], 
                    DiskBox[7, 0.049006281161920934`], 
                    DiskBox[8, 0.049006281161920934`], 
                    DiskBox[9, 0.049006281161920934`], 
                    DiskBox[10, 0.049006281161920934`], 
                    DiskBox[11, 0.049006281161920934`], 
                    DiskBox[12, 0.049006281161920934`], 
                    DiskBox[13, 0.049006281161920934`], 
                    DiskBox[14, 0.049006281161920934`], 
                    DiskBox[15, 0.049006281161920934`], 
                    DiskBox[16, 0.049006281161920934`], 
                    DiskBox[17, 0.049006281161920934`], 
                    DiskBox[18, 0.049006281161920934`], 
                    DiskBox[19, 0.049006281161920934`], 
                    DiskBox[20, 0.049006281161920934`], 
                    DiskBox[21, 0.049006281161920934`], 
                    DiskBox[22, 0.049006281161920934`], 
                    DiskBox[23, 0.049006281161920934`], 
                    DiskBox[24, 0.049006281161920934`], 
                    DiskBox[25, 0.049006281161920934`], 
                    DiskBox[26, 0.049006281161920934`], 
                    DiskBox[27, 0.049006281161920934`], 
                    DiskBox[28, 0.049006281161920934`], 
                    DiskBox[29, 0.049006281161920934`], 
                    DiskBox[30, 0.049006281161920934`], 
                    DiskBox[31, 0.049006281161920934`], 
                    DiskBox[32, 0.049006281161920934`], 
                    DiskBox[33, 0.049006281161920934`], 
                    DiskBox[34, 0.049006281161920934`], 
                    DiskBox[35, 0.049006281161920934`], 
                    DiskBox[36, 0.049006281161920934`], 
                    DiskBox[37, 0.049006281161920934`], 
                    DiskBox[38, 0.049006281161920934`], 
                    DiskBox[39, 0.049006281161920934`], 
                    DiskBox[40, 0.049006281161920934`], 
                    DiskBox[41, 0.049006281161920934`], 
                    DiskBox[42, 0.049006281161920934`], 
                    DiskBox[43, 0.049006281161920934`], 
                    DiskBox[44, 0.049006281161920934`], 
                    DiskBox[45, 0.049006281161920934`], 
                    DiskBox[46, 0.049006281161920934`], 
                    DiskBox[47, 0.049006281161920934`], 
                    DiskBox[48, 0.049006281161920934`], 
                    DiskBox[49, 0.049006281161920934`], 
                    DiskBox[50, 0.049006281161920934`], 
                    DiskBox[51, 0.049006281161920934`], 
                    DiskBox[52, 0.049006281161920934`], 
                    DiskBox[53, 0.049006281161920934`], 
                    DiskBox[54, 0.049006281161920934`], 
                    DiskBox[55, 0.049006281161920934`], 
                    DiskBox[56, 0.049006281161920934`], 
                    DiskBox[57, 0.049006281161920934`], 
                    DiskBox[58, 0.049006281161920934`], 
                    DiskBox[59, 0.049006281161920934`], 
                    DiskBox[60, 0.049006281161920934`], 
                    DiskBox[61, 0.049006281161920934`], 
                    DiskBox[62, 0.049006281161920934`], 
                    DiskBox[63, 0.049006281161920934`], 
                    DiskBox[64, 0.049006281161920934`], 
                    DiskBox[65, 0.049006281161920934`], 
                    DiskBox[66, 0.049006281161920934`], 
                    DiskBox[67, 0.049006281161920934`], 
                    DiskBox[68, 0.049006281161920934`], 
                    DiskBox[69, 0.049006281161920934`], 
                    DiskBox[70, 0.049006281161920934`], 
                    DiskBox[71, 0.049006281161920934`], 
                    DiskBox[72, 0.049006281161920934`], 
                    DiskBox[73, 0.049006281161920934`], 
                    DiskBox[74, 0.049006281161920934`], 
                    DiskBox[75, 0.049006281161920934`], 
                    DiskBox[76, 0.049006281161920934`], 
                    DiskBox[77, 0.049006281161920934`], 
                    DiskBox[78, 0.049006281161920934`], 
                    DiskBox[79, 0.049006281161920934`], 
                    DiskBox[80, 0.049006281161920934`], 
                    DiskBox[81, 0.049006281161920934`], 
                    DiskBox[82, 0.049006281161920934`], 
                    DiskBox[83, 0.049006281161920934`], 
                    DiskBox[84, 0.049006281161920934`], 
                    DiskBox[85, 0.049006281161920934`], 
                    DiskBox[86, 0.049006281161920934`], 
                    DiskBox[87, 0.049006281161920934`], 
                    DiskBox[88, 0.049006281161920934`], 
                    DiskBox[89, 0.049006281161920934`], 
                    DiskBox[90, 0.049006281161920934`], 
                    DiskBox[91, 0.049006281161920934`], 
                    DiskBox[92, 0.049006281161920934`], 
                    DiskBox[93, 0.049006281161920934`], 
                    DiskBox[94, 0.049006281161920934`], 
                    DiskBox[95, 0.049006281161920934`], 
                    DiskBox[96, 0.049006281161920934`], 
                    DiskBox[97, 0.049006281161920934`], 
                    DiskBox[98, 0.049006281161920934`], 
                    DiskBox[99, 0.049006281161920934`], 
                    DiskBox[100, 0.049006281161920934`]}}}}}]}], 
             MouseAppearanceTag["NetworkGraphics"]], 
            AllowKernelInitialization -> False]], 
          DefaultBaseStyle -> {
           "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> 
            Hue[0.8, 1., 0.6]}, FormatType -> TraditionalForm, FrameTicks -> 
          None, GridLinesStyle -> Directive[
            GrayLevel[0.5, 0.4]]]], "ExerciseOutput", Selectable -> False, 
        Copyable -> False, Editable -> False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"8143878f-bb79-4b8e-b4df-d6bb93655dcc"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "For the graph ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"1", 
     ButtonBox["\[Rule]",
      BaseStyle->"Link",
      ButtonData->"Rule"], "2"}], ",", 
    RowBox[{"2", 
     ButtonBox["\[Rule]",
      BaseStyle->"Link",
      ButtonData->"Rule"], "3"}], ",", 
    RowBox[{"3", 
     ButtonBox["\[Rule]",
      BaseStyle->"Link",
      ButtonData->"Rule"], "4"}], ",", 
    RowBox[{"4", 
     ButtonBox["\[Rule]",
      BaseStyle->"Link",
      ButtonData->"Rule"], "1"}], ",", 
    RowBox[{"3", 
     ButtonBox["\[Rule]",
      BaseStyle->"Link",
      ButtonData->"Rule"], "1"}], ",", 
    RowBox[{"2", 
     ButtonBox["\[Rule]",
      BaseStyle->"Link",
      ButtonData->"Rule"], "2"}]}], "}"}]], "InlineCode",ExpressionUUID->
  "1b29f8ea-978d-47ad-a5e8-b5d55761c987"],
 ", make a grid giving the shortest paths between every pair of nodes, with \
the start node as row and end node as column.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "21.11", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"b2c2068a-c694-4ae7-bca5-c38ba167858f"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       TagBox[GridBox[{
          {
           RowBox[{"{", "1", "}"}], 
           RowBox[{"{", 
            RowBox[{"1", ",", "2"}], "}"}], 
           RowBox[{"{", 
            RowBox[{"1", ",", "2", ",", "3"}], "}"}], 
           RowBox[{"{", 
            RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}]},
          {
           RowBox[{"{", 
            RowBox[{"2", ",", "3", ",", "1"}], "}"}], 
           RowBox[{"{", "2", "}"}], 
           RowBox[{"{", 
            RowBox[{"2", ",", "3"}], "}"}], 
           RowBox[{"{", 
            RowBox[{"2", ",", "3", ",", "4"}], "}"}]},
          {
           RowBox[{"{", 
            RowBox[{"3", ",", "1"}], "}"}], 
           RowBox[{"{", 
            RowBox[{"3", ",", "1", ",", "2"}], "}"}], 
           RowBox[{"{", "3", "}"}], 
           RowBox[{"{", 
            RowBox[{"3", ",", "4"}], "}"}]},
          {
           RowBox[{"{", 
            RowBox[{"4", ",", "1"}], "}"}], 
           RowBox[{"{", 
            RowBox[{"4", ",", "1", ",", "2"}], "}"}], 
           RowBox[{"{", 
            RowBox[{"4", ",", "1", ",", "2", ",", "3"}], "}"}], 
           RowBox[{"{", "4", "}"}]}
         },
         AutoDelete->False,
         GridBoxItemSize->{
          "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
        "Grid"]], "ExerciseOutput",ExpressionUUID->
       "b9984ecf-dcf2-4747-82c0-d682b2a67497"],
      Apply[TextCell, 
       Cell[
        BoxData[
         TagBox[
          GridBox[{{
             RowBox[{"{", "1", "}"}], 
             RowBox[{"{", 
               RowBox[{"1", ",", "2"}], "}"}], 
             RowBox[{"{", 
               RowBox[{"1", ",", "2", ",", "3"}], "}"}], 
             RowBox[{"{", 
               RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}]}, {
             RowBox[{"{", 
               RowBox[{"2", ",", "3", ",", "1"}], "}"}], 
             RowBox[{"{", "2", "}"}], 
             RowBox[{"{", 
               RowBox[{"2", ",", "3"}], "}"}], 
             RowBox[{"{", 
               RowBox[{"2", ",", "3", ",", "4"}], "}"}]}, {
             RowBox[{"{", 
               RowBox[{"3", ",", "1"}], "}"}], 
             RowBox[{"{", 
               RowBox[{"3", ",", "1", ",", "2"}], "}"}], 
             RowBox[{"{", "3", "}"}], 
             RowBox[{"{", 
               RowBox[{"3", ",", "4"}], "}"}]}, {
             RowBox[{"{", 
               RowBox[{"4", ",", "1"}], "}"}], 
             RowBox[{"{", 
               RowBox[{"4", ",", "1", ",", "2"}], "}"}], 
             RowBox[{"{", 
               RowBox[{"4", ",", "1", ",", "2", ",", "3"}], "}"}], 
             RowBox[{"{", "4", "}"}]}}, AutoDelete -> False, 
           GridBoxItemSize -> {
            "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], "Grid"]], 
        "ExerciseOutput", Selectable -> False, Copyable -> False, Editable -> 
        False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"7529080c-e3f6-446c-a388-8bd3e14a9156"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Make a graph with 4 nodes in which every node is connected, displaying the \
resulting graph with radial drawing.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+21.1", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"523ae5b2-2bef-4de5-b073-9bf191cd8deb"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       GraphicsBox[
        NamespaceBox["NetworkGraphics",
         DynamicModuleBox[{Typeset`graph = HoldComplete[
           
           Graph[{1, 2, 3, 
            4}, {{{1, 1}, {1, 2}, {1, 3}, {1, 4}, {2, 1}, {2, 2}, {2, 3}, {2, 
             4}, {3, 1}, {3, 2}, {3, 3}, {3, 4}, {4, 1}, {4, 2}, {4, 3}, {4, 
             4}}, Null}, {GraphLayout -> "RadialDrawing"}]]}, 
          TagBox[GraphicsGroupBox[GraphicsComplexBox[CompressedData["
1:eJxFmHk8ldsax1GIKESUBpUGJVSnFDo/EUU0oCIVp5CkNIcjlURFKkma0Cky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             "], {
              {Hue[0.6, 0.7, 0.5], Opacity[0.7], Arrowheads[Medium], 
               ArrowBox[BezierCurveBox[{1, 8, 11, 13, 19, 21, 24, 1},
                SplineDegree->7], 0.015994359217912757`], 
               ArrowBox[BezierCurveBox[{
                1, {0.24804763412961603`, 0.7831844956030691}, 2}], 
                0.015994359217912757`], 
               ArrowBox[BezierCurveBox[{
                1, {0.7286496031323592, 0.3535533905932901}, 3}], 
                0.015994359217912757`], 
               ArrowBox[BezierCurveBox[{
                1, {0.8604200698254088, 0.9845824573633464}, 4}], 
                0.015994359217912757`], 
               ArrowBox[BezierCurveBox[{
                2, {0.3643248015661797, 0.9845824573636416}, 1}], 
                0.015994359217912757`], 
               ArrowBox[BezierCurveBox[{2, 95, 98, 100, 106, 108, 111, 2},
                SplineDegree->7], 0.015994359217912757`], 
               ArrowBox[BezierCurveBox[{
                2, {0.48060196900274327`, 0.6310290667700216}, 3}], 
                0.015994359217912757`], 
               ArrowBox[BezierCurveBox[{
                2, {0.6123724356957887, 1.262058133539835}, 4}], 
                0.015994359217912757`], 
               ArrowBox[BezierCurveBox[{
                3, {0.4960952682592301, 0.3535533905933764}, 1}], 
                0.015994359217912757`], 
               ArrowBox[BezierCurveBox[{
                3, {0.13177046669305145`, 0.42963110500972973`}, 2}], 
                0.015994359217912757`], 
               ArrowBox[BezierCurveBox[{3, 182, 185, 187, 193, 195, 198, 3},
                SplineDegree->7], 0.015994359217912757`], 
               ArrowBox[BezierCurveBox[{
                3, {0.7441429023888458, 0.6310290667699904}, 4}], 
                0.015994359217912757`], 
               ArrowBox[BezierCurveBox[{
                4, {0.9766972372619754, 0.7831844956033949}, 1}], 
                0.015994359217912757`], 
               ArrowBox[BezierCurveBox[{
                4, {0.6123724356957956, 0.8592622100196223}, 2}], 
                0.015994359217912757`], 
               ArrowBox[BezierCurveBox[{
                4, {1.0929744046985426`, 0.4296311050097179}, 3}], 
                0.015994359217912757`], 
               ArrowBox[BezierCurveBox[{4, 269, 272, 274, 280, 282, 285, 4},
                SplineDegree->7], 0.015994359217912757`]}, 
              {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[0.7]}], 
               DiskBox[1, 0.015994359217912757], 
               DiskBox[2, 0.015994359217912757], 
               DiskBox[3, 0.015994359217912757], 
               DiskBox[4, 0.015994359217912757]}}]],
           MouseAppearanceTag["NetworkGraphics"]],
          AllowKernelInitialization->False]],
        DefaultBaseStyle->{
         "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> 
          Hue[0.8, 1., 0.6]},
        FormatType->TraditionalForm,
        FrameTicks->None,
        GridLinesStyle->Directive[
          GrayLevel[0.5, 0.4]]]], "ExerciseOutput",ExpressionUUID->
       "0925145a-700c-4f5b-9f34-e4a622f6f0ea"],
      Apply[TextCell, 
       Cell[
        BoxData[
         GraphicsBox[
          NamespaceBox["NetworkGraphics", 
           DynamicModuleBox[{Typeset`graph = HoldComplete[
               
               Graph[{1, 2, 3, 
                4}, {{{1, 1}, {1, 2}, {1, 3}, {1, 4}, {2, 1}, {2, 2}, {2, 
                 3}, {2, 4}, {3, 1}, {3, 2}, {3, 3}, {3, 4}, {4, 1}, {4, 2}, {
                 4, 3}, {4, 4}}, Null}, {GraphLayout -> "RadialDrawing"}]]}, 
            TagBox[
             GraphicsGroupBox[{
               GraphicsComplexBox[CompressedData["
1:eJxFmHk8ldsax1GIKESUBpUGJVSnFDo/EUU0oCIVp5CkNIcjlURFKkma0Cky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                "], {{{{{
                    Hue[0.6, 0.7, 0.5], 
                    Opacity[0.7], 
                    Arrowheads[Medium], 
                    ArrowBox[
                    
                    BezierCurveBox[{1, 8, 11, 13, 19, 21, 24, 1}, 
                    SplineDegree -> 7], 0.015994359217912757`], 
                    ArrowBox[
                    
                    BezierCurveBox[{
                    1, {0.24804763412961603`, 0.7831844956030691}, 2}], 
                    0.015994359217912757`], 
                    ArrowBox[
                    
                    BezierCurveBox[{
                    1, {0.7286496031323592, 0.3535533905932901}, 3}], 
                    0.015994359217912757`], 
                    ArrowBox[
                    
                    BezierCurveBox[{
                    1, {0.8604200698254088, 0.9845824573633464}, 4}], 
                    0.015994359217912757`], 
                    ArrowBox[
                    
                    BezierCurveBox[{
                    2, {0.3643248015661797, 0.9845824573636416}, 1}], 
                    0.015994359217912757`], 
                    ArrowBox[
                    
                    BezierCurveBox[{2, 95, 98, 100, 106, 108, 111, 2}, 
                    SplineDegree -> 7], 0.015994359217912757`], 
                    ArrowBox[
                    
                    BezierCurveBox[{
                    2, {0.48060196900274327`, 0.6310290667700216}, 3}], 
                    0.015994359217912757`], 
                    ArrowBox[
                    
                    BezierCurveBox[{
                    2, {0.6123724356957887, 1.262058133539835}, 4}], 
                    0.015994359217912757`], 
                    ArrowBox[
                    
                    BezierCurveBox[{
                    3, {0.4960952682592301, 0.3535533905933764}, 1}], 
                    0.015994359217912757`], 
                    ArrowBox[
                    
                    BezierCurveBox[{
                    3, {0.13177046669305145`, 0.42963110500972973`}, 2}], 
                    0.015994359217912757`], 
                    ArrowBox[
                    
                    BezierCurveBox[{3, 182, 185, 187, 193, 195, 198, 3}, 
                    SplineDegree -> 7], 0.015994359217912757`], 
                    ArrowBox[
                    
                    BezierCurveBox[{
                    3, {0.7441429023888458, 0.6310290667699904}, 4}], 
                    0.015994359217912757`], 
                    ArrowBox[
                    
                    BezierCurveBox[{
                    4, {0.9766972372619754, 0.7831844956033949}, 1}], 
                    0.015994359217912757`], 
                    ArrowBox[
                    
                    BezierCurveBox[{
                    4, {0.6123724356957956, 0.8592622100196223}, 2}], 
                    0.015994359217912757`], 
                    ArrowBox[
                    
                    BezierCurveBox[{
                    4, {1.0929744046985426`, 0.4296311050097179}, 3}], 
                    0.015994359217912757`], 
                    ArrowBox[
                    
                    BezierCurveBox[{4, 269, 272, 274, 280, 282, 285, 4}, 
                    SplineDegree -> 7], 0.015994359217912757`]}}}}, {{{{
                    Hue[0.6, 0.2, 0.8], 
                    EdgeForm[{
                    GrayLevel[0], 
                    Opacity[0.7]}], 
                    DiskBox[1, 0.015994359217912757`], 
                    DiskBox[2, 0.015994359217912757`], 
                    DiskBox[3, 0.015994359217912757`], 
                    DiskBox[4, 0.015994359217912757`]}}}}}]}], 
             MouseAppearanceTag["NetworkGraphics"]], 
            AllowKernelInitialization -> False]], 
          DefaultBaseStyle -> {
           "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> 
            Hue[0.8, 1., 0.6]}, FormatType -> TraditionalForm, FrameTicks -> 
          None, GridLinesStyle -> Directive[
            GrayLevel[0.5, 0.4]]]], "ExerciseOutput", Selectable -> False, 
        Copyable -> False, Editable -> False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"a08f3b4d-09ea-4ffc-b9a0-671d4f6ef91e"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Generate a graph in which a single node is connected to 10 others.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+21.2", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"8ba5ece2-b3ee-4959-bf40-c329790f32ee"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       GraphicsBox[
        NamespaceBox["NetworkGraphics",
         DynamicModuleBox[{Typeset`graph = HoldComplete[
           
           Graph[{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 
            10}, {{{1, 2}, {1, 3}, {1, 4}, {1, 5}, {1, 6}, {1, 7}, {1, 8}, {1,
              9}, {1, 10}, {1, 11}}, Null}]]}, 
          
          TagBox[GraphicsGroupBox[
            GraphicsComplexBox[{{1.4795908857482156`, 0.3287979746107146}, {
             0., 0.}, {0.3287979746107146, 0.}, {0.6575959492214292, 0.}, {
             0.9863939238321437, 0.}, {1.3151918984428583`, 0.}, {
             1.643989873053573, 0.}, {1.9727878476642875`, 0.}, {
             2.301585822275002, 0.}, {2.6303837968857167`, 0.}, {
             2.9591817714964312`, 0.}}, {
              {Hue[0.6, 0.7, 0.5], Opacity[0.7], Arrowheads[Medium], 
               ArrowBox[{{1, 2}, {1, 3}, {1, 4}, {1, 5}, {1, 6}, {1, 7}, {1, 
                8}, {1, 9}, {1, 10}, {1, 11}}, 0.029946084541681087`]}, 
              {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[0.7]}], 
               DiskBox[1, 0.029946084541681087], 
               DiskBox[2, 0.029946084541681087], 
               DiskBox[3, 0.029946084541681087], 
               DiskBox[4, 0.029946084541681087], 
               DiskBox[5, 0.029946084541681087], 
               DiskBox[6, 0.029946084541681087], 
               DiskBox[7, 0.029946084541681087], 
               DiskBox[8, 0.029946084541681087], 
               DiskBox[9, 0.029946084541681087], 
               DiskBox[10, 0.029946084541681087], 
               DiskBox[11, 0.029946084541681087]}}]],
           MouseAppearanceTag["NetworkGraphics"]],
          AllowKernelInitialization->False]],
        DefaultBaseStyle->{
         "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> 
          Hue[0.8, 1., 0.6]},
        FormatType->TraditionalForm,
        FrameTicks->None,
        GridLinesStyle->Directive[
          GrayLevel[0.5, 0.4]]]], "ExerciseOutput",ExpressionUUID->
       "c8113f2b-8baf-4102-b27b-06665d3b828e"],
      Apply[TextCell, 
       Cell[
        BoxData[
         GraphicsBox[
          NamespaceBox["NetworkGraphics", 
           DynamicModuleBox[{Typeset`graph = HoldComplete[
               
               Graph[{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 
                10}, {{{1, 2}, {1, 3}, {1, 4}, {1, 5}, {1, 6}, {1, 7}, {1, 
                 8}, {1, 9}, {1, 10}, {1, 11}}, Null}]]}, 
            TagBox[
             GraphicsGroupBox[{
               
               GraphicsComplexBox[{{1.4795908857482156`, 
                0.3287979746107146}, {0., 0.}, {0.3287979746107146, 0.}, {
                0.6575959492214292, 0.}, {0.9863939238321437, 0.}, {
                1.3151918984428583`, 0.}, {1.643989873053573, 0.}, {
                1.9727878476642875`, 0.}, {2.301585822275002, 0.}, {
                2.6303837968857167`, 0.}, {2.9591817714964312`, 0.}}, {{{{{
                    Hue[0.6, 0.7, 0.5], 
                    Opacity[0.7], 
                    Arrowheads[Medium], 
                    
                    ArrowBox[{{1, 2}, {1, 3}, {1, 4}, {1, 5}, {1, 6}, {1, 
                    7}, {1, 8}, {1, 9}, {1, 10}, {1, 11}}, 
                    0.029946084541681087`]}}}}, {{{{
                    Hue[0.6, 0.2, 0.8], 
                    EdgeForm[{
                    GrayLevel[0], 
                    Opacity[0.7]}], 
                    DiskBox[1, 0.029946084541681087`], 
                    DiskBox[2, 0.029946084541681087`], 
                    DiskBox[3, 0.029946084541681087`], 
                    DiskBox[4, 0.029946084541681087`], 
                    DiskBox[5, 0.029946084541681087`], 
                    DiskBox[6, 0.029946084541681087`], 
                    DiskBox[7, 0.029946084541681087`], 
                    DiskBox[8, 0.029946084541681087`], 
                    DiskBox[9, 0.029946084541681087`], 
                    DiskBox[10, 0.029946084541681087`], 
                    DiskBox[11, 0.029946084541681087`]}}}}}]}], 
             MouseAppearanceTag["NetworkGraphics"]], 
            AllowKernelInitialization -> False]], 
          DefaultBaseStyle -> {
           "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> 
            Hue[0.8, 1., 0.6]}, FormatType -> TraditionalForm, FrameTicks -> 
          None, GridLinesStyle -> Directive[
            GrayLevel[0.5, 0.4]]]], "ExerciseOutput", Selectable -> False, 
        Copyable -> False, Editable -> False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"a9b61ae1-5f00-41e7-a758-8620347a2059"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Use ",
 ButtonBox["Flatten",
  BaseStyle->"Link"],
 " to generate a table of the numbers 1 to 50 in which even numbers are \
colored red.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+21.3", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"96b944bb-0780-4573-bed9-c39c9913fada"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       RowBox[{"{", 
        RowBox[{"1", ",", 
         StyleBox["2",
          StripOnInput->False,
          FontColor->RGBColor[1, 0, 0],
          $CellContext`LineColor -> RGBColor[1, 0, 0],
          $CellContext`FrontFaceColor -> RGBColor[1, 0, 0],
          $CellContext`GraphicsColor -> RGBColor[1, 0, 0],
          $CellContext`BackFaceColor -> RGBColor[1, 0, 0]], ",", "3", ",", 
         StyleBox["4",
          StripOnInput->False,
          FontColor->RGBColor[1, 0, 0],
          $CellContext`LineColor -> RGBColor[1, 0, 0],
          $CellContext`FrontFaceColor -> RGBColor[1, 0, 0],
          $CellContext`GraphicsColor -> RGBColor[1, 0, 0],
          $CellContext`BackFaceColor -> RGBColor[1, 0, 0]], ",", "5", ",", 
         StyleBox["6",
          StripOnInput->False,
          FontColor->RGBColor[1, 0, 0],
          $CellContext`LineColor -> RGBColor[1, 0, 0],
          $CellContext`FrontFaceColor -> RGBColor[1, 0, 0],
          $CellContext`GraphicsColor -> RGBColor[1, 0, 0],
          $CellContext`BackFaceColor -> RGBColor[1, 0, 0]], ",", "7", ",", 
         StyleBox["8",
          StripOnInput->False,
          FontColor->RGBColor[1, 0, 0],
          $CellContext`LineColor -> RGBColor[1, 0, 0],
          $CellContext`FrontFaceColor -> RGBColor[1, 0, 0],
          $CellContext`GraphicsColor -> RGBColor[1, 0, 0],
          $CellContext`BackFaceColor -> RGBColor[1, 0, 0]], ",", "9", ",", 
         StyleBox["10",
          StripOnInput->False,
          FontColor->RGBColor[1, 0, 0],
          $CellContext`LineColor -> RGBColor[1, 0, 0],
          $CellContext`FrontFaceColor -> RGBColor[1, 0, 0],
          $CellContext`GraphicsColor -> RGBColor[1, 0, 0],
          $CellContext`BackFaceColor -> RGBColor[1, 0, 0]], ",", "11", ",", 
         StyleBox["12",
          StripOnInput->False,
          FontColor->RGBColor[1, 0, 0],
          $CellContext`LineColor -> RGBColor[1, 0, 0],
          $CellContext`FrontFaceColor -> RGBColor[1, 0, 0],
          $CellContext`GraphicsColor -> RGBColor[1, 0, 0],
          $CellContext`BackFaceColor -> RGBColor[1, 0, 0]], ",", "13", ",", 
         StyleBox["14",
          StripOnInput->False,
          FontColor->RGBColor[1, 0, 0],
          $CellContext`LineColor -> RGBColor[1, 0, 0],
          $CellContext`FrontFaceColor -> RGBColor[1, 0, 0],
          $CellContext`GraphicsColor -> RGBColor[1, 0, 0],
          $CellContext`BackFaceColor -> RGBColor[1, 0, 0]], ",", "15", ",", 
         StyleBox["16",
          StripOnInput->False,
          FontColor->RGBColor[1, 0, 0],
          $CellContext`LineColor -> RGBColor[1, 0, 0],
          $CellContext`FrontFaceColor -> RGBColor[1, 0, 0],
          $CellContext`GraphicsColor -> RGBColor[1, 0, 0],
          $CellContext`BackFaceColor -> RGBColor[1, 0, 0]], ",", "17", ",", 
         StyleBox["18",
          StripOnInput->False,
          FontColor->RGBColor[1, 0, 0],
          $CellContext`LineColor -> RGBColor[1, 0, 0],
          $CellContext`FrontFaceColor -> RGBColor[1, 0, 0],
          $CellContext`GraphicsColor -> RGBColor[1, 0, 0],
          $CellContext`BackFaceColor -> RGBColor[1, 0, 0]], ",", "19", ",", 
         StyleBox["20",
          StripOnInput->False,
          FontColor->RGBColor[1, 0, 0],
          $CellContext`LineColor -> RGBColor[1, 0, 0],
          $CellContext`FrontFaceColor -> RGBColor[1, 0, 0],
          $CellContext`GraphicsColor -> RGBColor[1, 0, 0],
          $CellContext`BackFaceColor -> RGBColor[1, 0, 0]], ",", "21", ",", 
         StyleBox["22",
          StripOnInput->False,
          FontColor->RGBColor[1, 0, 0],
          $CellContext`LineColor -> RGBColor[1, 0, 0],
          $CellContext`FrontFaceColor -> RGBColor[1, 0, 0],
          $CellContext`GraphicsColor -> RGBColor[1, 0, 0],
          $CellContext`BackFaceColor -> RGBColor[1, 0, 0]], ",", "23", ",", 
         StyleBox["24",
          StripOnInput->False,
          FontColor->RGBColor[1, 0, 0],
          $CellContext`LineColor -> RGBColor[1, 0, 0],
          $CellContext`FrontFaceColor -> RGBColor[1, 0, 0],
          $CellContext`GraphicsColor -> RGBColor[1, 0, 0],
          $CellContext`BackFaceColor -> RGBColor[1, 0, 0]], ",", "25", ",", 
         StyleBox["26",
          StripOnInput->False,
          FontColor->RGBColor[1, 0, 0],
          $CellContext`LineColor -> RGBColor[1, 0, 0],
          $CellContext`FrontFaceColor -> RGBColor[1, 0, 0],
          $CellContext`GraphicsColor -> RGBColor[1, 0, 0],
          $CellContext`BackFaceColor -> RGBColor[1, 0, 0]], ",", "27", ",", 
         StyleBox["28",
          StripOnInput->False,
          FontColor->RGBColor[1, 0, 0],
          $CellContext`LineColor -> RGBColor[1, 0, 0],
          $CellContext`FrontFaceColor -> RGBColor[1, 0, 0],
          $CellContext`GraphicsColor -> RGBColor[1, 0, 0],
          $CellContext`BackFaceColor -> RGBColor[1, 0, 0]], ",", "29", ",", 
         StyleBox["30",
          StripOnInput->False,
          FontColor->RGBColor[1, 0, 0],
          $CellContext`LineColor -> RGBColor[1, 0, 0],
          $CellContext`FrontFaceColor -> RGBColor[1, 0, 0],
          $CellContext`GraphicsColor -> RGBColor[1, 0, 0],
          $CellContext`BackFaceColor -> RGBColor[1, 0, 0]], ",", "31", ",", 
         StyleBox["32",
          StripOnInput->False,
          FontColor->RGBColor[1, 0, 0],
          $CellContext`LineColor -> RGBColor[1, 0, 0],
          $CellContext`FrontFaceColor -> RGBColor[1, 0, 0],
          $CellContext`GraphicsColor -> RGBColor[1, 0, 0],
          $CellContext`BackFaceColor -> RGBColor[1, 0, 0]], ",", "33", ",", 
         StyleBox["34",
          StripOnInput->False,
          FontColor->RGBColor[1, 0, 0],
          $CellContext`LineColor -> RGBColor[1, 0, 0],
          $CellContext`FrontFaceColor -> RGBColor[1, 0, 0],
          $CellContext`GraphicsColor -> RGBColor[1, 0, 0],
          $CellContext`BackFaceColor -> RGBColor[1, 0, 0]], ",", "35", ",", 
         StyleBox["36",
          StripOnInput->False,
          FontColor->RGBColor[1, 0, 0],
          $CellContext`LineColor -> RGBColor[1, 0, 0],
          $CellContext`FrontFaceColor -> RGBColor[1, 0, 0],
          $CellContext`GraphicsColor -> RGBColor[1, 0, 0],
          $CellContext`BackFaceColor -> RGBColor[1, 0, 0]], ",", "37", ",", 
         StyleBox["38",
          StripOnInput->False,
          FontColor->RGBColor[1, 0, 0],
          $CellContext`LineColor -> RGBColor[1, 0, 0],
          $CellContext`FrontFaceColor -> RGBColor[1, 0, 0],
          $CellContext`GraphicsColor -> RGBColor[1, 0, 0],
          $CellContext`BackFaceColor -> RGBColor[1, 0, 0]], ",", "39", ",", 
         StyleBox["40",
          StripOnInput->False,
          FontColor->RGBColor[1, 0, 0],
          $CellContext`LineColor -> RGBColor[1, 0, 0],
          $CellContext`FrontFaceColor -> RGBColor[1, 0, 0],
          $CellContext`GraphicsColor -> RGBColor[1, 0, 0],
          $CellContext`BackFaceColor -> RGBColor[1, 0, 0]], ",", "41", ",", 
         StyleBox["42",
          StripOnInput->False,
          FontColor->RGBColor[1, 0, 0],
          $CellContext`LineColor -> RGBColor[1, 0, 0],
          $CellContext`FrontFaceColor -> RGBColor[1, 0, 0],
          $CellContext`GraphicsColor -> RGBColor[1, 0, 0],
          $CellContext`BackFaceColor -> RGBColor[1, 0, 0]], ",", "43", ",", 
         StyleBox["44",
          StripOnInput->False,
          FontColor->RGBColor[1, 0, 0],
          $CellContext`LineColor -> RGBColor[1, 0, 0],
          $CellContext`FrontFaceColor -> RGBColor[1, 0, 0],
          $CellContext`GraphicsColor -> RGBColor[1, 0, 0],
          $CellContext`BackFaceColor -> RGBColor[1, 0, 0]], ",", "45", ",", 
         StyleBox["46",
          StripOnInput->False,
          FontColor->RGBColor[1, 0, 0],
          $CellContext`LineColor -> RGBColor[1, 0, 0],
          $CellContext`FrontFaceColor -> RGBColor[1, 0, 0],
          $CellContext`GraphicsColor -> RGBColor[1, 0, 0],
          $CellContext`BackFaceColor -> RGBColor[1, 0, 0]], ",", "47", ",", 
         StyleBox["48",
          StripOnInput->False,
          FontColor->RGBColor[1, 0, 0],
          $CellContext`LineColor -> RGBColor[1, 0, 0],
          $CellContext`FrontFaceColor -> RGBColor[1, 0, 0],
          $CellContext`GraphicsColor -> RGBColor[1, 0, 0],
          $CellContext`BackFaceColor -> RGBColor[1, 0, 0]], ",", "49", ",", 
         StyleBox["50",
          StripOnInput->False,
          FontColor->RGBColor[1, 0, 0],
          $CellContext`LineColor -> RGBColor[1, 0, 0],
          $CellContext`FrontFaceColor -> RGBColor[1, 0, 0],
          $CellContext`GraphicsColor -> RGBColor[1, 0, 0],
          $CellContext`BackFaceColor -> RGBColor[1, 0, 0]]}], "}"}]], 
       "ExerciseOutput",ExpressionUUID->
       "00a293d6-96ba-45fd-9559-b42f979c6211"],
      Apply[TextCell, 
       Cell[
        BoxData[
         RowBox[{"{", 
           RowBox[{"1", ",", 
             StyleBox[
             "2", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[1, 0, 0], $CellContext`FrontFaceColor -> 
              RGBColor[1, 0, 0], $CellContext`GraphicsColor -> 
              RGBColor[1, 0, 0], FontColor -> 
              RGBColor[1, 0, 0], $CellContext`BackFaceColor -> 
              RGBColor[1, 0, 0]], ",", "3", ",", 
             StyleBox[
             "4", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[1, 0, 0], $CellContext`FrontFaceColor -> 
              RGBColor[1, 0, 0], $CellContext`GraphicsColor -> 
              RGBColor[1, 0, 0], FontColor -> 
              RGBColor[1, 0, 0], $CellContext`BackFaceColor -> 
              RGBColor[1, 0, 0]], ",", "5", ",", 
             StyleBox[
             "6", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[1, 0, 0], $CellContext`FrontFaceColor -> 
              RGBColor[1, 0, 0], $CellContext`GraphicsColor -> 
              RGBColor[1, 0, 0], FontColor -> 
              RGBColor[1, 0, 0], $CellContext`BackFaceColor -> 
              RGBColor[1, 0, 0]], ",", "7", ",", 
             StyleBox[
             "8", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[1, 0, 0], $CellContext`FrontFaceColor -> 
              RGBColor[1, 0, 0], $CellContext`GraphicsColor -> 
              RGBColor[1, 0, 0], FontColor -> 
              RGBColor[1, 0, 0], $CellContext`BackFaceColor -> 
              RGBColor[1, 0, 0]], ",", "9", ",", 
             StyleBox[
             "10", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[1, 0, 0], $CellContext`FrontFaceColor -> 
              RGBColor[1, 0, 0], $CellContext`GraphicsColor -> 
              RGBColor[1, 0, 0], FontColor -> 
              RGBColor[1, 0, 0], $CellContext`BackFaceColor -> 
              RGBColor[1, 0, 0]], ",", "11", ",", 
             StyleBox[
             "12", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[1, 0, 0], $CellContext`FrontFaceColor -> 
              RGBColor[1, 0, 0], $CellContext`GraphicsColor -> 
              RGBColor[1, 0, 0], FontColor -> 
              RGBColor[1, 0, 0], $CellContext`BackFaceColor -> 
              RGBColor[1, 0, 0]], ",", "13", ",", 
             StyleBox[
             "14", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[1, 0, 0], $CellContext`FrontFaceColor -> 
              RGBColor[1, 0, 0], $CellContext`GraphicsColor -> 
              RGBColor[1, 0, 0], FontColor -> 
              RGBColor[1, 0, 0], $CellContext`BackFaceColor -> 
              RGBColor[1, 0, 0]], ",", "15", ",", 
             StyleBox[
             "16", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[1, 0, 0], $CellContext`FrontFaceColor -> 
              RGBColor[1, 0, 0], $CellContext`GraphicsColor -> 
              RGBColor[1, 0, 0], FontColor -> 
              RGBColor[1, 0, 0], $CellContext`BackFaceColor -> 
              RGBColor[1, 0, 0]], ",", "17", ",", 
             StyleBox[
             "18", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[1, 0, 0], $CellContext`FrontFaceColor -> 
              RGBColor[1, 0, 0], $CellContext`GraphicsColor -> 
              RGBColor[1, 0, 0], FontColor -> 
              RGBColor[1, 0, 0], $CellContext`BackFaceColor -> 
              RGBColor[1, 0, 0]], ",", "19", ",", 
             StyleBox[
             "20", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[1, 0, 0], $CellContext`FrontFaceColor -> 
              RGBColor[1, 0, 0], $CellContext`GraphicsColor -> 
              RGBColor[1, 0, 0], FontColor -> 
              RGBColor[1, 0, 0], $CellContext`BackFaceColor -> 
              RGBColor[1, 0, 0]], ",", "21", ",", 
             StyleBox[
             "22", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[1, 0, 0], $CellContext`FrontFaceColor -> 
              RGBColor[1, 0, 0], $CellContext`GraphicsColor -> 
              RGBColor[1, 0, 0], FontColor -> 
              RGBColor[1, 0, 0], $CellContext`BackFaceColor -> 
              RGBColor[1, 0, 0]], ",", "23", ",", 
             StyleBox[
             "24", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[1, 0, 0], $CellContext`FrontFaceColor -> 
              RGBColor[1, 0, 0], $CellContext`GraphicsColor -> 
              RGBColor[1, 0, 0], FontColor -> 
              RGBColor[1, 0, 0], $CellContext`BackFaceColor -> 
              RGBColor[1, 0, 0]], ",", "25", ",", 
             StyleBox[
             "26", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[1, 0, 0], $CellContext`FrontFaceColor -> 
              RGBColor[1, 0, 0], $CellContext`GraphicsColor -> 
              RGBColor[1, 0, 0], FontColor -> 
              RGBColor[1, 0, 0], $CellContext`BackFaceColor -> 
              RGBColor[1, 0, 0]], ",", "27", ",", 
             StyleBox[
             "28", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[1, 0, 0], $CellContext`FrontFaceColor -> 
              RGBColor[1, 0, 0], $CellContext`GraphicsColor -> 
              RGBColor[1, 0, 0], FontColor -> 
              RGBColor[1, 0, 0], $CellContext`BackFaceColor -> 
              RGBColor[1, 0, 0]], ",", "29", ",", 
             StyleBox[
             "30", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[1, 0, 0], $CellContext`FrontFaceColor -> 
              RGBColor[1, 0, 0], $CellContext`GraphicsColor -> 
              RGBColor[1, 0, 0], FontColor -> 
              RGBColor[1, 0, 0], $CellContext`BackFaceColor -> 
              RGBColor[1, 0, 0]], ",", "31", ",", 
             StyleBox[
             "32", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[1, 0, 0], $CellContext`FrontFaceColor -> 
              RGBColor[1, 0, 0], $CellContext`GraphicsColor -> 
              RGBColor[1, 0, 0], FontColor -> 
              RGBColor[1, 0, 0], $CellContext`BackFaceColor -> 
              RGBColor[1, 0, 0]], ",", "33", ",", 
             StyleBox[
             "34", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[1, 0, 0], $CellContext`FrontFaceColor -> 
              RGBColor[1, 0, 0], $CellContext`GraphicsColor -> 
              RGBColor[1, 0, 0], FontColor -> 
              RGBColor[1, 0, 0], $CellContext`BackFaceColor -> 
              RGBColor[1, 0, 0]], ",", "35", ",", 
             StyleBox[
             "36", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[1, 0, 0], $CellContext`FrontFaceColor -> 
              RGBColor[1, 0, 0], $CellContext`GraphicsColor -> 
              RGBColor[1, 0, 0], FontColor -> 
              RGBColor[1, 0, 0], $CellContext`BackFaceColor -> 
              RGBColor[1, 0, 0]], ",", "37", ",", 
             StyleBox[
             "38", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[1, 0, 0], $CellContext`FrontFaceColor -> 
              RGBColor[1, 0, 0], $CellContext`GraphicsColor -> 
              RGBColor[1, 0, 0], FontColor -> 
              RGBColor[1, 0, 0], $CellContext`BackFaceColor -> 
              RGBColor[1, 0, 0]], ",", "39", ",", 
             StyleBox[
             "40", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[1, 0, 0], $CellContext`FrontFaceColor -> 
              RGBColor[1, 0, 0], $CellContext`GraphicsColor -> 
              RGBColor[1, 0, 0], FontColor -> 
              RGBColor[1, 0, 0], $CellContext`BackFaceColor -> 
              RGBColor[1, 0, 0]], ",", "41", ",", 
             StyleBox[
             "42", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[1, 0, 0], $CellContext`FrontFaceColor -> 
              RGBColor[1, 0, 0], $CellContext`GraphicsColor -> 
              RGBColor[1, 0, 0], FontColor -> 
              RGBColor[1, 0, 0], $CellContext`BackFaceColor -> 
              RGBColor[1, 0, 0]], ",", "43", ",", 
             StyleBox[
             "44", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[1, 0, 0], $CellContext`FrontFaceColor -> 
              RGBColor[1, 0, 0], $CellContext`GraphicsColor -> 
              RGBColor[1, 0, 0], FontColor -> 
              RGBColor[1, 0, 0], $CellContext`BackFaceColor -> 
              RGBColor[1, 0, 0]], ",", "45", ",", 
             StyleBox[
             "46", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[1, 0, 0], $CellContext`FrontFaceColor -> 
              RGBColor[1, 0, 0], $CellContext`GraphicsColor -> 
              RGBColor[1, 0, 0], FontColor -> 
              RGBColor[1, 0, 0], $CellContext`BackFaceColor -> 
              RGBColor[1, 0, 0]], ",", "47", ",", 
             StyleBox[
             "48", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[1, 0, 0], $CellContext`FrontFaceColor -> 
              RGBColor[1, 0, 0], $CellContext`GraphicsColor -> 
              RGBColor[1, 0, 0], FontColor -> 
              RGBColor[1, 0, 0], $CellContext`BackFaceColor -> 
              RGBColor[1, 0, 0]], ",", "49", ",", 
             StyleBox[
             "50", StripOnInput -> False, $CellContext`LineColor -> 
              RGBColor[1, 0, 0], $CellContext`FrontFaceColor -> 
              RGBColor[1, 0, 0], $CellContext`GraphicsColor -> 
              RGBColor[1, 0, 0], FontColor -> 
              RGBColor[1, 0, 0], $CellContext`BackFaceColor -> 
              RGBColor[1, 0, 0]]}], "}"}]], "ExerciseOutput", Selectable -> 
        False, Copyable -> False, Editable -> False, ShowCellBracket -> 
        False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"23080b47-bba6-47ba-8326-017a3fc37f32"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Use ",
 ButtonBox["ImageData",
  BaseStyle->"Link"],
 ", ",
 ButtonBox["Flatten",
  BaseStyle->"Link"],
 " and ",
 ButtonBox["Total",
  BaseStyle->"Link"],
 " to find the number of white pixels in ",
 StyleBox[ButtonBox["Binarize",
  BaseStyle->"Link"], "InlineCode"],
 StyleBox["[", "InlineCode"],
 StyleBox[ButtonBox["Rasterize",
  BaseStyle->"Link"], "InlineCode"],
 StyleBox["[\"W\"]]", "InlineCode"],
 ".",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+21.4", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"12f759d7-84d5-4701-ba31-3b99648ab41c"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
      "191"], "ExerciseOutput",ExpressionUUID->
       "b5d45004-9f7e-40a4-8b1f-cb90e59fc880"],
      Apply[TextCell, 
       Cell[
        BoxData["191"], "ExerciseOutput", Selectable -> False, Copyable -> 
        False, Editable -> False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"d3b368dd-32d8-475b-b525-f171f76d8787"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Use ",
 ButtonBox["Flatten",
  BaseStyle->"Link"],
 ", ",
 ButtonBox["IntegerDigits",
  BaseStyle->"Link"],
 " and ",
 ButtonBox["Total",
  BaseStyle->"Link"],
 " to find the sum of all digits of all whole numbers up to 1000.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+21.5", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"888f6349-ea05-4fa8-9f47-84f5ecf824f5"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
      "13501"], "ExerciseOutput",ExpressionUUID->
       "e3cd12eb-2aec-4ec3-a796-7c06f2f9086b"],
      Apply[TextCell, 
       Cell[
        BoxData["13501"], "ExerciseOutput", Selectable -> False, Copyable -> 
        False, Editable -> False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"5d3c81e5-2f9e-4c33-9e7a-b64aae618790"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Generate a graph with 200 connections, each between nodes with numbers \
randomly chosen between 0 and 100.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+21.6", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"18e59b2a-fbd6-4448-ba72-d1b2756df6ef"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       GraphicsBox[
        NamespaceBox["NetworkGraphics",
         DynamicModuleBox[{Typeset`graph = HoldComplete[
           
           Graph[{17, 54, 3, 22, 45, 89, 2, 92, 79, 76, 60, 99, 8, 28, 29, 66,
             88, 58, 50, 43, 18, 24, 96, 37, 78, 47, 5, 4, 97, 49, 64, 83, 13,
             94, 48, 46, 56, 69, 70, 14, 12, 23, 73, 20, 81, 80, 40, 34, 33, 
            21, 53, 85, 32, 90, 26, 82, 63, 36, 1, 75, 72, 95, 16, 9, 7, 27, 
            30, 35, 91, 0, 19, 15, 38, 68, 55, 71, 62, 6, 42, 44, 52, 41, 51, 
            57, 59, 74, 31, 11, 67, 98, 77, 65, 93, 10, 84, 86, 61, 25, 39, 
            87}, {CompressedData["
1:eJwVxd1amgAAAFAl/hQHiAgKIgoIBUxCBcFGBokoaiTqcrlZud3vNfdY2y7O
d7qX3/kFKBQKf/75fxG4AkEIRlC4VMYqn3CCrFI1us6wjSaHQnxLAEC8LYid
riQrPRXqotr1jW6Yn/vWrT2gweHIaaEuOPYk0+kj3aY/uaO+YEER8e+paa0i
PoSDSH9UoxmuDgiFoLHYd+e6p1WTx4Uz95klk654XQDXlBXwaXnTNu0nwcqU
Rct4BuDxUMBm21le1PI+T3ilsDGEd3gnWzvYPjLkrHPwNk+9W/GrUve3L+xx
HTkHwRzukm+vmUOqArEnJ43NsQpmrHRq74jiuDZlXktu7J9YVg8AIpTV74nN
xXDtx9mGPGY7DiSas8N77y3BKVICTO6u6T6gE9c7X4Fy2T5Je+1tnr+k0zRO
miVeNvP3DKksPcgMj7go67E/2uGufc0k2Crss+9SUD/i1qjlLsFz+pH3bmg5
RUX2YmrkZr04/PxlYCtOCZ4jy/g4Rwj+F1BfR7M=
             "], Null}]]}, 
          TagBox[GraphicsGroupBox[GraphicsComplexBox[CompressedData["
1:eJw9lwk0VVv8x3G597pX3HPuuUQS70mkkeQpvfPNTCpKQqVJk2SIJhSFyEyk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             "], {
              {Hue[0.6, 0.7, 0.5], Opacity[0.7], Arrowheads[
               0.01865142039318295], ArrowBox[{1, 2}, 0.05710279699299331], 
               ArrowBox[{1, 7}, 0.05710279699299331], 
               ArrowBox[{2, 15}, 0.05710279699299331], 
               ArrowBox[{2, 44}, 0.05710279699299331], 
               ArrowBox[BezierCurveBox[{
                3, {5.095375761186901, 2.053997497178286}, 4}], 
                0.05710279699299331], 
               ArrowBox[BezierCurveBox[{
                3, {5.430842086423266, 2.219720086317736}, 4}], 
                0.05710279699299331], ArrowBox[{4, 5}, 0.05710279699299331], 
               ArrowBox[{4, 14}, 0.05710279699299331], 
               ArrowBox[{4, 51}, 0.05710279699299331], 
               ArrowBox[{4, 76}, 0.05710279699299331], 
               ArrowBox[{4, 94}, 0.05710279699299331], 
               ArrowBox[{5, 33}, 0.05710279699299331], 
               ArrowBox[{5, 44}, 0.05710279699299331], 
               ArrowBox[{6, 7}, 0.05710279699299331], 
               ArrowBox[{6, 19}, 0.05710279699299331], 
               ArrowBox[{6, 55}, 0.05710279699299331], 
               ArrowBox[{6, 83}, 0.05710279699299331], 
               ArrowBox[{7, 12}, 0.05710279699299331], 
               ArrowBox[{7, 14}, 0.05710279699299331], 
               ArrowBox[{7, 33}, 0.05710279699299331], 
               ArrowBox[{8, 5}, 0.05710279699299331], 
               ArrowBox[{8, 6}, 0.05710279699299331], 
               ArrowBox[{8, 31}, 0.05710279699299331], 
               ArrowBox[{8, 39}, 0.05710279699299331], 
               ArrowBox[{9, 10}, 0.05710279699299331], 
               ArrowBox[{9, 65}, 0.05710279699299331], 
               ArrowBox[{11, 12}, 0.05710279699299331], 
               ArrowBox[{11, 61}, 0.05710279699299331], 
               ArrowBox[{11, 68}, 0.05710279699299331], 
               ArrowBox[BezierCurveBox[{
                11, {3.118995855374083, 4.270112714901705}, 75}], 
                0.05710279699299331], 
               ArrowBox[BezierCurveBox[{
                11, {3.150507501053919, 4.567512217992062}, 75}], 
                0.05710279699299331], ArrowBox[{13, 14}, 0.05710279699299331],
                ArrowBox[{14, 18}, 0.05710279699299331], 
               ArrowBox[{14, 31}, 0.05710279699299331], 
               ArrowBox[{14, 32}, 0.05710279699299331], 
               ArrowBox[{14, 38}, 0.05710279699299331], 
               ArrowBox[{14, 47}, 0.05710279699299331], 
               ArrowBox[{14, 54}, 0.05710279699299331], 
               ArrowBox[{15, 1}, 0.05710279699299331], 
               ArrowBox[{15, 16}, 0.05710279699299331], 
               ArrowBox[{15, 56}, 0.05710279699299331], 
               ArrowBox[{16, 34}, 0.05710279699299331], 
               ArrowBox[{16, 38}, 0.05710279699299331], 
               ArrowBox[{16, 77}, 0.05710279699299331], 
               ArrowBox[{17, 4}, 0.05710279699299331], 
               ArrowBox[{17, 18}, 0.05710279699299331], 
               ArrowBox[{18, 47}, 0.05710279699299331], 
               ArrowBox[{18, 60}, 0.05710279699299331], 
               ArrowBox[{18, 63}, 0.05710279699299331], 
               ArrowBox[{19, 12}, 0.05710279699299331], 
               ArrowBox[{19, 20}, 0.05710279699299331], 
               ArrowBox[{20, 11}, 0.05710279699299331], 
               ArrowBox[{20, 26}, 0.05710279699299331], 
               ArrowBox[{21, 22}, 0.05710279699299331], 
               ArrowBox[{21, 88}, 0.05710279699299331], 
               ArrowBox[{22, 71}, 0.05710279699299331], 
               ArrowBox[{22, 73}, 0.05710279699299331], 
               ArrowBox[{22, 74}, 0.05710279699299331], 
               ArrowBox[BezierCurveBox[{23, 168, 171, 173, 179, 181, 184, 23},
                
                SplineDegree->7], 0.05710279699299331], 
               ArrowBox[{23, 24}, 0.05710279699299331], 
               ArrowBox[{23, 96}, 0.05710279699299331], 
               ArrowBox[{23, 98}, 0.05710279699299331], 
               ArrowBox[{24, 51}, 0.05710279699299331], 
               ArrowBox[{25, 9}, 0.05710279699299331], 
               ArrowBox[{25, 26}, 0.05710279699299331], 
               ArrowBox[{25, 54}, 0.05710279699299331], 
               ArrowBox[{25, 57}, 0.05710279699299331], 
               ArrowBox[{26, 36}, 0.05710279699299331], 
               ArrowBox[{26, 59}, 0.05710279699299331], 
               ArrowBox[{26, 69}, 0.05710279699299331], 
               ArrowBox[{27, 28}, 0.05710279699299331], 
               ArrowBox[{27, 35}, 0.05710279699299331], 
               ArrowBox[{28, 8}, 0.05710279699299331], 
               ArrowBox[{28, 43}, 0.05710279699299331], 
               ArrowBox[{29, 2}, 0.05710279699299331], 
               ArrowBox[{29, 15}, 0.05710279699299331], 
               ArrowBox[{30, 29}, 0.05710279699299331], 
               ArrowBox[{30, 83}, 0.05710279699299331], 
               ArrowBox[{31, 32}, 0.05710279699299331], 
               ArrowBox[{31, 64}, 0.05710279699299331], 
               ArrowBox[{31, 86}, 0.05710279699299331], 
               ArrowBox[{33, 34}, 0.05710279699299331], 
               ArrowBox[{34, 44}, 0.05710279699299331], 
               ArrowBox[BezierCurveBox[{
                34, {4.821677248732705, 4.458683679957214}, 61}], 
                0.05710279699299331], ArrowBox[{34, 84}, 0.05710279699299331],
                ArrowBox[{34, 91}, 0.05710279699299331], 
               ArrowBox[{35, 10}, 0.05710279699299331], 
               ArrowBox[{35, 36}, 0.05710279699299331], 
               ArrowBox[{35, 42}, 0.05710279699299331], 
               ArrowBox[{35, 74}, 0.05710279699299331], 
               ArrowBox[{36, 15}, 0.05710279699299331], 
               ArrowBox[{36, 21}, 0.05710279699299331], 
               ArrowBox[{36, 72}, 0.05710279699299331], 
               ArrowBox[{37, 38}, 0.05710279699299331], 
               ArrowBox[{37, 48}, 0.05710279699299331], 
               ArrowBox[{38, 92}, 0.05710279699299331], 
               ArrowBox[{39, 17}, 0.05710279699299331], 
               ArrowBox[{39, 82}, 0.05710279699299331], 
               ArrowBox[{39, 95}, 0.05710279699299331], 
               ArrowBox[{40, 41}, 0.05710279699299331], 
               ArrowBox[{41, 20}, 0.05710279699299331], 
               ArrowBox[{42, 29}, 0.05710279699299331], 
               ArrowBox[{42, 43}, 0.05710279699299331], 
               ArrowBox[{42, 56}, 0.05710279699299331], 
               ArrowBox[{42, 61}, 0.05710279699299331], 
               ArrowBox[{43, 35}, 0.05710279699299331], 
               ArrowBox[{43, 97}, 0.05710279699299331], 
               ArrowBox[{44, 39}, 0.05710279699299331], 
               ArrowBox[{44, 45}, 0.05710279699299331], 
               ArrowBox[{44, 49}, 0.05710279699299331], 
               ArrowBox[{44, 51}, 0.05710279699299331], 
               ArrowBox[{44, 82}, 0.05710279699299331], 
               ArrowBox[{46, 27}, 0.05710279699299331], 
               ArrowBox[{46, 47}, 0.05710279699299331], 
               ArrowBox[{47, 79}, 0.05710279699299331], 
               ArrowBox[{48, 49}, 0.05710279699299331], 
               ArrowBox[{49, 5}, 0.05710279699299331], 
               ArrowBox[{49, 40}, 0.05710279699299331], 
               ArrowBox[{49, 65}, 0.05710279699299331], 
               ArrowBox[{49, 91}, 0.05710279699299331], 
               ArrowBox[{50, 15}, 0.05710279699299331], 
               ArrowBox[{50, 20}, 0.05710279699299331], 
               ArrowBox[{51, 29}, 0.05710279699299331], 
               ArrowBox[{52, 28}, 0.05710279699299331], 
               ArrowBox[{52, 53}, 0.05710279699299331], 
               ArrowBox[{52, 83}, 0.05710279699299331], 
               ArrowBox[{53, 11}, 0.05710279699299331], 
               ArrowBox[{53, 46}, 0.05710279699299331], 
               ArrowBox[{54, 4}, 0.05710279699299331], 
               ArrowBox[{54, 69}, 0.05710279699299331], 
               ArrowBox[{54, 70}, 0.05710279699299331], 
               ArrowBox[{54, 73}, 0.05710279699299331], 
               ArrowBox[{55, 19}, 0.05710279699299331], 
               ArrowBox[{55, 56}, 0.05710279699299331], 
               ArrowBox[{56, 22}, 0.05710279699299331], 
               ArrowBox[{56, 94}, 0.05710279699299331], 
               ArrowBox[{57, 62}, 0.05710279699299331], 
               ArrowBox[{57, 81}, 0.05710279699299331], 
               ArrowBox[{57, 91}, 0.05710279699299331], 
               ArrowBox[{58, 24}, 0.05710279699299331], 
               ArrowBox[{58, 54}, 0.05710279699299331], 
               ArrowBox[{58, 59}, 0.05710279699299331], 
               ArrowBox[{61, 27}, 0.05710279699299331], 
               ArrowBox[BezierCurveBox[{
                61, {4.801757521683945, 4.866116791833445}, 34}], 
                0.05710279699299331], ArrowBox[{61, 80}, 0.05710279699299331],
                ArrowBox[{62, 56}, 0.05710279699299331], 
               ArrowBox[{63, 22}, 0.05710279699299331], 
               ArrowBox[{63, 74}, 0.05710279699299331], 
               ArrowBox[{64, 8}, 0.05710279699299331], 
               ArrowBox[{65, 35}, 0.05710279699299331], 
               ArrowBox[{65, 46}, 0.05710279699299331], 
               ArrowBox[{65, 50}, 0.05710279699299331], 
               ArrowBox[{65, 88}, 0.05710279699299331], 
               ArrowBox[{66, 42}, 0.05710279699299331], 
               ArrowBox[{66, 47}, 0.05710279699299331], 
               ArrowBox[{66, 53}, 0.05710279699299331], 
               ArrowBox[{66, 68}, 0.05710279699299331], 
               ArrowBox[{67, 38}, 0.05710279699299331], 
               ArrowBox[BezierCurveBox[{
                69, {4.065497866002981, 4.731130244250564}, 57}], 
                0.05710279699299331], 
               ArrowBox[BezierCurveBox[{
                69, {4.354643973615882, 4.732521597005693}, 57}], 
                0.05710279699299331], ArrowBox[{69, 71}, 0.05710279699299331],
                ArrowBox[{70, 57}, 0.05710279699299331], 
               ArrowBox[{70, 82}, 0.05710279699299331], 
               ArrowBox[{71, 49}, 0.05710279699299331], 
               ArrowBox[{71, 67}, 0.05710279699299331], 
               ArrowBox[{72, 53}, 0.05710279699299331], 
               ArrowBox[{73, 56}, 0.05710279699299331], 
               ArrowBox[{74, 10}, 0.05710279699299331], 
               ArrowBox[{74, 97}, 0.05710279699299331], 
               ArrowBox[{75, 27}, 0.05710279699299331], 
               ArrowBox[{76, 72}, 0.05710279699299331], 
               ArrowBox[{77, 30}, 0.05710279699299331], 
               ArrowBox[{77, 78}, 0.05710279699299331], 
               ArrowBox[{77, 88}, 0.05710279699299331], 
               ArrowBox[{78, 29}, 0.05710279699299331], 
               ArrowBox[{79, 23}, 0.05710279699299331], 
               ArrowBox[{79, 32}, 0.05710279699299331], 
               ArrowBox[{79, 53}, 0.05710279699299331], 
               ArrowBox[{79, 76}, 0.05710279699299331], 
               ArrowBox[{80, 2}, 0.05710279699299331], 
               ArrowBox[{81, 55}, 0.05710279699299331], 
               ArrowBox[{81, 68}, 0.05710279699299331], 
               ArrowBox[{82, 1}, 0.05710279699299331], 
               ArrowBox[{82, 37}, 0.05710279699299331], 
               ArrowBox[{83, 71}, 0.05710279699299331], 
               ArrowBox[{84, 16}, 0.05710279699299331], 
               ArrowBox[{84, 66}, 0.05710279699299331], 
               ArrowBox[{85, 29}, 0.05710279699299331], 
               ArrowBox[{85, 56}, 0.05710279699299331], 
               ArrowBox[{85, 99}, 0.05710279699299331], 
               ArrowBox[{87, 23}, 0.05710279699299331], 
               ArrowBox[{87, 74}, 0.05710279699299331], 
               ArrowBox[{88, 76}, 0.05710279699299331], 
               ArrowBox[{89, 90}, 0.05710279699299331], 
               ArrowBox[{90, 9}, 0.05710279699299331], 
               ArrowBox[{93, 94}, 0.05710279699299331], 
               ArrowBox[{94, 66}, 0.05710279699299331], 
               ArrowBox[{95, 71}, 0.05710279699299331], 
               ArrowBox[{96, 79}, 0.05710279699299331], 
               ArrowBox[{100, 43}, 0.05710279699299331]}, 
              {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[0.7]}], 
               DiskBox[1, 0.05710279699299331], 
               DiskBox[2, 0.05710279699299331], 
               DiskBox[3, 0.05710279699299331], 
               DiskBox[4, 0.05710279699299331], 
               DiskBox[5, 0.05710279699299331], 
               DiskBox[6, 0.05710279699299331], 
               DiskBox[7, 0.05710279699299331], 
               DiskBox[8, 0.05710279699299331], 
               DiskBox[9, 0.05710279699299331], 
               DiskBox[10, 0.05710279699299331], 
               DiskBox[11, 0.05710279699299331], 
               DiskBox[12, 0.05710279699299331], 
               DiskBox[13, 0.05710279699299331], 
               DiskBox[14, 0.05710279699299331], 
               DiskBox[15, 0.05710279699299331], 
               DiskBox[16, 0.05710279699299331], 
               DiskBox[17, 0.05710279699299331], 
               DiskBox[18, 0.05710279699299331], 
               DiskBox[19, 0.05710279699299331], 
               DiskBox[20, 0.05710279699299331], 
               DiskBox[21, 0.05710279699299331], 
               DiskBox[22, 0.05710279699299331], 
               DiskBox[23, 0.05710279699299331], 
               DiskBox[24, 0.05710279699299331], 
               DiskBox[25, 0.05710279699299331], 
               DiskBox[26, 0.05710279699299331], 
               DiskBox[27, 0.05710279699299331], 
               DiskBox[28, 0.05710279699299331], 
               DiskBox[29, 0.05710279699299331], 
               DiskBox[30, 0.05710279699299331], 
               DiskBox[31, 0.05710279699299331], 
               DiskBox[32, 0.05710279699299331], 
               DiskBox[33, 0.05710279699299331], 
               DiskBox[34, 0.05710279699299331], 
               DiskBox[35, 0.05710279699299331], 
               DiskBox[36, 0.05710279699299331], 
               DiskBox[37, 0.05710279699299331], 
               DiskBox[38, 0.05710279699299331], 
               DiskBox[39, 0.05710279699299331], 
               DiskBox[40, 0.05710279699299331], 
               DiskBox[41, 0.05710279699299331], 
               DiskBox[42, 0.05710279699299331], 
               DiskBox[43, 0.05710279699299331], 
               DiskBox[44, 0.05710279699299331], 
               DiskBox[45, 0.05710279699299331], 
               DiskBox[46, 0.05710279699299331], 
               DiskBox[47, 0.05710279699299331], 
               DiskBox[48, 0.05710279699299331], 
               DiskBox[49, 0.05710279699299331], 
               DiskBox[50, 0.05710279699299331], 
               DiskBox[51, 0.05710279699299331], 
               DiskBox[52, 0.05710279699299331], 
               DiskBox[53, 0.05710279699299331], 
               DiskBox[54, 0.05710279699299331], 
               DiskBox[55, 0.05710279699299331], 
               DiskBox[56, 0.05710279699299331], 
               DiskBox[57, 0.05710279699299331], 
               DiskBox[58, 0.05710279699299331], 
               DiskBox[59, 0.05710279699299331], 
               DiskBox[60, 0.05710279699299331], 
               DiskBox[61, 0.05710279699299331], 
               DiskBox[62, 0.05710279699299331], 
               DiskBox[63, 0.05710279699299331], 
               DiskBox[64, 0.05710279699299331], 
               DiskBox[65, 0.05710279699299331], 
               DiskBox[66, 0.05710279699299331], 
               DiskBox[67, 0.05710279699299331], 
               DiskBox[68, 0.05710279699299331], 
               DiskBox[69, 0.05710279699299331], 
               DiskBox[70, 0.05710279699299331], 
               DiskBox[71, 0.05710279699299331], 
               DiskBox[72, 0.05710279699299331], 
               DiskBox[73, 0.05710279699299331], 
               DiskBox[74, 0.05710279699299331], 
               DiskBox[75, 0.05710279699299331], 
               DiskBox[76, 0.05710279699299331], 
               DiskBox[77, 0.05710279699299331], 
               DiskBox[78, 0.05710279699299331], 
               DiskBox[79, 0.05710279699299331], 
               DiskBox[80, 0.05710279699299331], 
               DiskBox[81, 0.05710279699299331], 
               DiskBox[82, 0.05710279699299331], 
               DiskBox[83, 0.05710279699299331], 
               DiskBox[84, 0.05710279699299331], 
               DiskBox[85, 0.05710279699299331], 
               DiskBox[86, 0.05710279699299331], 
               DiskBox[87, 0.05710279699299331], 
               DiskBox[88, 0.05710279699299331], 
               DiskBox[89, 0.05710279699299331], 
               DiskBox[90, 0.05710279699299331], 
               DiskBox[91, 0.05710279699299331], 
               DiskBox[92, 0.05710279699299331], 
               DiskBox[93, 0.05710279699299331], 
               DiskBox[94, 0.05710279699299331], 
               DiskBox[95, 0.05710279699299331], 
               DiskBox[96, 0.05710279699299331], 
               DiskBox[97, 0.05710279699299331], 
               DiskBox[98, 0.05710279699299331], 
               DiskBox[99, 0.05710279699299331], 
               DiskBox[100, 0.05710279699299331]}}]],
           MouseAppearanceTag["NetworkGraphics"]],
          AllowKernelInitialization->False]],
        DefaultBaseStyle->{
         "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> 
          Hue[0.8, 1., 0.6]},
        FrameTicks->None,
        GridLinesStyle->Directive[
          GrayLevel[0.5, 0.4]]]], "ExerciseOutput",ExpressionUUID->
       "3fe4348b-73e7-4f36-8afb-d4c452d5f85f"],
      Apply[TextCell, 
       Cell[
        BoxData[
         GraphicsBox[
          NamespaceBox["NetworkGraphics", 
           DynamicModuleBox[{Typeset`graph = HoldComplete[
               
               Graph[{17, 54, 3, 22, 45, 89, 2, 92, 79, 76, 60, 99, 8, 28, 29,
                 66, 88, 58, 50, 43, 18, 24, 96, 37, 78, 47, 5, 4, 97, 49, 64,
                 83, 13, 94, 48, 46, 56, 69, 70, 14, 12, 23, 73, 20, 81, 80, 
                40, 34, 33, 21, 53, 85, 32, 90, 26, 82, 63, 36, 1, 75, 72, 95,
                 16, 9, 7, 27, 30, 35, 91, 0, 19, 15, 38, 68, 55, 71, 62, 6, 
                42, 44, 52, 41, 51, 57, 59, 74, 31, 11, 67, 98, 77, 65, 93, 
                10, 84, 86, 61, 25, 39, 87}, {CompressedData["
1:eJwVxd1amgAAAFAl/hQHiAgKIgoIBUxCBcFGBokoaiTqcrlZud3vNfdY2y7O
d7qX3/kFKBQKf/75fxG4AkEIRlC4VMYqn3CCrFI1us6wjSaHQnxLAEC8LYid
riQrPRXqotr1jW6Yn/vWrT2gweHIaaEuOPYk0+kj3aY/uaO+YEER8e+paa0i
PoSDSH9UoxmuDgiFoLHYd+e6p1WTx4Uz95klk654XQDXlBXwaXnTNu0nwcqU
Rct4BuDxUMBm21le1PI+T3ilsDGEd3gnWzvYPjLkrHPwNk+9W/GrUve3L+xx
HTkHwRzukm+vmUOqArEnJ43NsQpmrHRq74jiuDZlXktu7J9YVg8AIpTV74nN
xXDtx9mGPGY7DiSas8N77y3BKVICTO6u6T6gE9c7X4Fy2T5Je+1tnr+k0zRO
miVeNvP3DKksPcgMj7go67E/2uGufc0k2Crss+9SUD/i1qjlLsFz+pH3bmg5
RUX2YmrkZr04/PxlYCtOCZ4jy/g4Rwj+F1BfR7M=
                 "], Null}]]}, 
            TagBox[
             GraphicsGroupBox[{
               GraphicsComplexBox[CompressedData["
1:eJw9lwk0VVv8x3G597pX3HPuuUQS70mkkeQpvfPNTCpKQqVJk2SIJhSFyEyk
RBRPPDykIkMl0UxEJXmVMjxDhvdIxv/5r/Vf/7PWWWf91t777N/nt397/75b
bY/Hpn0SYmJiE8z7v1+zxV90P7AVYHu9dsmmxyQWcTf2p90V4cxF3oF/GoT4
1k1YHZaTB//Bx+Q4zjhdYdsZc4RPoUqskvd8kRTkvS755IXLY/gy3f0gaBYy
K66+urJPiNuDfb9v1Bbgd2nKbc1XEdIWNDaxXsjhVZRt4PZiEcb1ft2nEsVG
8sXTdECCOBpzqUOrXAjs06p/3eMqhjv2Xnc6uXxsdqxX+rdIBg27bsXW+RFI
rHs0u20ridGKSwafX5BYHkv2nzutCF9KVuXwzQk6+bcjJ+n/RIhZppm42FES
Wb4W06q1JKhRSKS/IuBrINNmJquAqbYEr4XqAmR5mCbY5shjxuVYjXS9OCRf
N5fMY/zfIWKz1A0n6Kljzs0aIQS2nugVy99JIeixL7vQTAZfuH6xvrtF+KP2
Wf6pC3xES3fJrjbl4NH5Hs/GGFlwt6YManpKQ+P0I8dORx7EcgTUYPV3Wuh5
ZfhRpywMt8X/vPVQDMK8JXGxeTzYv/o5k9ZFwMi6aWnJJy5sEqcu3n5EoF1+
XtycuTzYbXw8o3ZRFi+XCB+qbZHDNYGfTtlcDqpSDWs1+4S4onHKN35YgKnv
bccOvZPHvNCW5yeVZaAm30CueayAR+mew3oVE3TCSE+UeDkFt18E9j/Nxuj0
EY/1urazEbsw1/GX5wTk3nsX+98TweVtMGdjDYnp/ebfz2WzsV1TN/dGOh8n
RrsuD9Ty8TZ9LOLfIRlIlpfYcyyUEbJ+7z/5vxCgtk0XuQwoITXldIGAx8c3
79x3vednI3Vt2qI9ndIIDqeu/tgrhPUmFb6f4myMtQz/971ZDpr6xoeN3RTx
6JVgs7PGLKzvTY1Z3ywLH/+hpZd7JeFyRyeyqoWDc7MP2F38QwGNz1LFnZsE
GJA1UHk/PQfKY/sFKySEULfua5RylkF6eoGTz25pOFbFmQRcIzB6UtQcq8JC
SGm/lLe4EsbNper+aReCXTe87MA7CpFaggi3TyRMbrWEnufL4q9f+5qf3hPi
u0OXFLdKiDT+31dKIqXxMuDIFvleApcOvk8w0JGCw7r4PaI5snCuCm+dLmHD
tfG6Rm04gUPZj3vyaBlM6s7U1h0SYL2SY33DoBC/KutNfecJwH3z99j6HQTe
L6zZNMxw3JHfXxBaQIEeLogj/5aGRc2ewZedHPibPJ/MfsbCKZVXbNbQLJg1
HK/+uZjCCj97l+9WX+my3McT3Y8FGOMvOmEZSmKTXIb1aLwslmTsjRXrEcEp
j6dlrzsLdTEPzDqCxEC/anX5V1wR0xY+6z77iyFWyCr82i2Dxive7h3WAhw/
6lRqt1OA83+P1qn4yyC44yH3ZIsi3ONWnTv5QAaRGU3dbjF8yLrG3DBh4n1L
r87evEWAlYdHP9LaBJpOhSRXelBoS6hQS5AhoaHd2ohvFCirNRssj87Cqkvc
9vJsPqy0uwxJVWZdD74YMODIgbWQWOQ0PgvFi9v16PNS8CtXX5OrLonS17tM
p49J4UgF61lvG4Gl5AntkX4B1D/v3pRCiqNNx7xzU7cI2YnzgiWf8BAYvphU
/aqADdzQBdUjsvjefaDwxWoByuYnb/voNka3dWa9vnVFCN/Mh8uuK8ijMzvk
913hMrAb6XV/ckgeN8jzrcIVirj4oyJnUpLAinI0/ZlDQTzipt2BUWn039zv
6+dPgdlum5cz8WozeeVx7wgJJbXlzm/vi6CyPT/Lw1MJr3eq3jC53Ut/SyZ0
ppZJwqm+5kioyihtIHQ0/WM1k4/zjceHL3Ah9n8Pr49Kvv+CwmuV8RUR8X20
g9XH+SPMOfTcIDy4/BaF4+/Xvsxj/h/oVfuBtJ2HvrISL4PX0jjQ9uH59QvS
yOCZmV7yEseW6B+XU38V4HXqlKbUZi4UXuz7aXVIEeRLvbDJBGl8HgkmNljO
gqS/anuQfDud+ftKGZ0FM/RKwf0lpBoLJof6xdwG2f/vV5FP3pmECRJBEivC
Kr2V8O2HV9HE/DF6M11ob3xOCja7/9OyuSVCdHcUL8xngvY8EDfb7qoIviei
HYg3E3RUgnLp2RAR3MWaDXv0JunY/kX/dXiK4KX4Ztn7lEl6zUovsagdIvS7
6htf40zRd08ctz23ToTKAQnDqWNTtHvRp8TXq0S4ovujqrhrij5eShae1RZB
eb/52TPbp2ndggM6yjsozI/ScmzxkkDu+C0dg40UFENhlJUvAfOmAdvnRhSs
TW9al/RIwFUps++tPgUthy023ZospBzLOrNvCYVlNlW+1EEWNC+Zp/lpUBCT
+stFPpuF0AcS03NVKQR2bdR82s1CclLJTps5FC4bVZ5gLZQENwO+YTMi7Fn9
8aHKrElayW+ktWxchPihuzsTYybpU5mFq3Yw9Sj+7njnmGCKlqyx3ebdJ8Iy
1aayydgpWl/Vrl+cqY+/C/LktshN0077uWGy70UY0+MqlERM06O06c20FyLs
utWs3SI1Q7tHxN6sqBTBPIs1ffT0DK19rkNr6wCF1fmhSZslWNC9MNuE+5mC
X+3SH6WGLPQ+OhtmX0/BtVtrVcIxFlwkQ1vWVVJ482fM3eo8FgTrX3QMM/kd
+6bqgUY7C1RWq9rWRArk54f3UkWSWP5mf1VwAHM+qn/T5plLwqaFVRh2kIKE
27fGDccl0ZzrekSpi4/2eTcrB/cSuKlx3Ti0mI/605t7Q5wJ/BguljwTwEeQ
yy4FJycCi5Z2Bsxdx8f+CH6Zx1YC4UsXlAbL8xEeuSbq6RYC5jN3Ghq/8GBC
B0fsY2x/zaIZjXweZHaeGTCzJ/AoP9Ur/SQPa96W6ro5EOg1/l35/UUO/BJk
FHIDCCSXx/Ym7uQgO8B2lAwisNHPWLpEm4NbZQfdykMJ1JcFazuNsZEeYlly
PYrA0PnQ8tQaNnQiKxweJRB4aXGuOu0iGy8cjsxWTCVgF97x8fQeNub8PMS+
nkXAMrBZZYsOG58d5c7YFRGoznFamzLCh3N1Vuu+bAIlaVZB3jV8/KpuvVmx
mAD9JT/FNoEP78cWa69XEFDKyM7cvIcPmbifYmOPCRh65K5IWsrHtSS3G7Nf
Eqj8q89+1SQPkXvW9083EDjqnuaz7SkPl1Jd9t58S0C1c8hYMYGH6rAcI7kP
jD/+8d9tCjgQN5+av0GcRKx4wK7nvhwsv6/v6s0iUbPQN1rFjIPxtuV1dpIk
zo5zs90IDu7Ennw5xLR/Grf8/OYjG+/i/kyzkmB0kr7/Nm+m3peXbjHaNUPA
hRWj7OrDhkfaHvcVEwT0z9QMvwWjB6ZkU56NEAhc+tdzZzNptChXNW017KYr
WHJHT1DS2JcpllRo3kVPRi27YPSOizspUrmWgZ20p2roPOM4Lrb3jMhu+t5B
Z9/WvO5gyoVr3JjDk6QO+l3m4uz0UQ7GhmtqVwZ20PZ1T2GfzcFU1pu+pOwO
uj1KfKxgBwfbo7WijOQ66eRteYr3FTm4NpIuJlbYSVPuGwKtPrGx3CzdTz+4
i5adrWRZXshGk63BDt2gbjrjfUPazxg2rB19C/1v/ENTXs65O86wgfRoFcu3
PTSZKume7s+GeXVk3SjRR8ubpy1uCmejLdt3bpxFP316VWbxXiY+1sa/VDgc
+U5bb2tym93EhlNlWoqlzwCd/ic0F8hwEEFYXLbWGqR5ifcGjDZwsOjJo28X
Awbpq/o5uneSOLA5Z7nK894g3VDsYu3bwcE7rX8KzzYN0pF6J+fvXsFF7n1R
R279IN2zTbd20VkuYp7FZKjlDtIX1CPrX+qJ4Pn5cFRbDAl6IvDQEkoE2eWG
EQuCSFx6tzRkaojRqSe2CoUnSSh6Se3ewOz/TDOtO1nuJEp8l5zXy6MgK2JJ
de8n0TbiXvEkjMLX6LrLrbtIeB5vmlLcR8E/zF4qZDuJq+lWrmvXUri6WPNj
pyOJ/G0Nqm9MSUgbX2tWWEtifCRt6JsaiW/VQRm6IBHzo8VtdIrA1f1XBqSZ
9jWsmvfKTJ4qh02tSjYmkfAYHkfuMvWvfI74V3PmvpGpZzsVT8Dj7/jSL+sZ
f01I3y8eBD7E3mmK38LMt2hn8ZL1BJwNM58MOZNYuzPv02ULAgPipkNlFSQi
wkpM9V0J2BT5/Ov5jMSKPO7Cg5EEWl0dD4c0kSgidTcoFBAouxr6bKiNhFCa
p7Wsken/Kv9UYQeJ/qhnw6lMHvttbu+o6CXhNMulaJ0iiXZHp1PCQRJLv/ab
qK8hUX077EbRMIm5mgei43+jsCWNzAnkC/E66nJl4HYKviqLW11khFgd6Wzk
EUih2k8hJpppjwr0fmuRScHIqdh4mivEygc/6LEnFA5qJJ6+IynEtU8Szgd7
KQywVGrvTjP+0hp6wbIiBNtO5Ej9YObb2jKxcrkIYlkyJVn9JHg9oU3hJQIc
lSBHtBmdufaPw1RSgQDyyXbqu24Q4MXoJNZnC1AbN196oIxAZJur028ZApSG
LVR8/obA0zn+xU3XBHATG0xp72PWxb3I4OZVAcTF0ku12CQacwrqiq4IcMCo
zid2HqP/NR2ujlwWQFBm94RjQOLDVjWxVUmMTnzRdVb9uhDOOu3eJYxtaVhn
n1rG6G8THxN3Zjyy9K9wm4S4sYDjviNFgIP6NoZb+4VI5rXqBqUL0OO30sSX
TYEtYaHW9ocAu0I+1O2ZRwFrdfgH8wSof/pKWYKJs8Chh1C9LUC83/QVSxsK
p7g5SYrjAjixnYdPM/xW83ZfaxAnoHIv2qOG4Q92Xhe2nctwT56tdCknMLil
9NjdWQQk2BoW65sIdP0WufojwfSzkrHx7Gfum8rz9r2gCOS3qv97n+HXXlKk
d06eQIZptN5CVRIF3KM5M4x9/K4PL4Phj9BfLWsiIvDxCafmAcNfcvfrh1Bm
fAgdraBfLsSR4S8e8SSBvrMVb1IZ/ioThVEXOeacPOs28I3hnzqnuVGcz+jK
n8u9pxj+gIZdlKsUAY3BlUHvGX6L8gWJN6YFeNfFOXiA4Q84zm/+a1QA3wCr
pKsM//8ABQOaEA==
                "], {{{{{
                    Hue[0.6, 0.7, 0.5], 
                    Opacity[0.7], 
                    Arrowheads[0.01865142039318295], 
                    ArrowBox[{1, 2}, 0.05710279699299331], 
                    ArrowBox[{1, 7}, 0.05710279699299331], 
                    ArrowBox[{2, 15}, 0.05710279699299331], 
                    ArrowBox[{2, 44}, 0.05710279699299331], 
                    ArrowBox[
                    
                    BezierCurveBox[{
                    3, {5.095375761186901, 2.053997497178286}, 4}], 
                    0.05710279699299331], 
                    ArrowBox[
                    
                    BezierCurveBox[{
                    3, {5.430842086423266, 2.219720086317736}, 4}], 
                    0.05710279699299331], 
                    ArrowBox[{4, 5}, 0.05710279699299331], 
                    ArrowBox[{4, 14}, 0.05710279699299331], 
                    ArrowBox[{4, 51}, 0.05710279699299331], 
                    ArrowBox[{4, 76}, 0.05710279699299331], 
                    ArrowBox[{4, 94}, 0.05710279699299331], 
                    ArrowBox[{5, 33}, 0.05710279699299331], 
                    ArrowBox[{5, 44}, 0.05710279699299331], 
                    ArrowBox[{6, 7}, 0.05710279699299331], 
                    ArrowBox[{6, 19}, 0.05710279699299331], 
                    ArrowBox[{6, 55}, 0.05710279699299331], 
                    ArrowBox[{6, 83}, 0.05710279699299331], 
                    ArrowBox[{7, 12}, 0.05710279699299331], 
                    ArrowBox[{7, 14}, 0.05710279699299331], 
                    ArrowBox[{7, 33}, 0.05710279699299331], 
                    ArrowBox[{8, 5}, 0.05710279699299331], 
                    ArrowBox[{8, 6}, 0.05710279699299331], 
                    ArrowBox[{8, 31}, 0.05710279699299331], 
                    ArrowBox[{8, 39}, 0.05710279699299331], 
                    ArrowBox[{9, 10}, 0.05710279699299331], 
                    ArrowBox[{9, 65}, 0.05710279699299331], 
                    ArrowBox[{11, 12}, 0.05710279699299331], 
                    ArrowBox[{11, 61}, 0.05710279699299331], 
                    ArrowBox[{11, 68}, 0.05710279699299331], 
                    ArrowBox[
                    
                    BezierCurveBox[{
                    11, {3.118995855374083, 4.270112714901705}, 75}], 
                    0.05710279699299331], 
                    ArrowBox[
                    
                    BezierCurveBox[{
                    11, {3.150507501053919, 4.567512217992062}, 75}], 
                    0.05710279699299331], 
                    ArrowBox[{13, 14}, 0.05710279699299331], 
                    ArrowBox[{14, 18}, 0.05710279699299331], 
                    ArrowBox[{14, 31}, 0.05710279699299331], 
                    ArrowBox[{14, 32}, 0.05710279699299331], 
                    ArrowBox[{14, 38}, 0.05710279699299331], 
                    ArrowBox[{14, 47}, 0.05710279699299331], 
                    ArrowBox[{14, 54}, 0.05710279699299331], 
                    ArrowBox[{15, 1}, 0.05710279699299331], 
                    ArrowBox[{15, 16}, 0.05710279699299331], 
                    ArrowBox[{15, 56}, 0.05710279699299331], 
                    ArrowBox[{16, 34}, 0.05710279699299331], 
                    ArrowBox[{16, 38}, 0.05710279699299331], 
                    ArrowBox[{16, 77}, 0.05710279699299331], 
                    ArrowBox[{17, 4}, 0.05710279699299331], 
                    ArrowBox[{17, 18}, 0.05710279699299331], 
                    ArrowBox[{18, 47}, 0.05710279699299331], 
                    ArrowBox[{18, 60}, 0.05710279699299331], 
                    ArrowBox[{18, 63}, 0.05710279699299331], 
                    ArrowBox[{19, 12}, 0.05710279699299331], 
                    ArrowBox[{19, 20}, 0.05710279699299331], 
                    ArrowBox[{20, 11}, 0.05710279699299331], 
                    ArrowBox[{20, 26}, 0.05710279699299331], 
                    ArrowBox[{21, 22}, 0.05710279699299331], 
                    ArrowBox[{21, 88}, 0.05710279699299331], 
                    ArrowBox[{22, 71}, 0.05710279699299331], 
                    ArrowBox[{22, 73}, 0.05710279699299331], 
                    ArrowBox[{22, 74}, 0.05710279699299331], 
                    ArrowBox[
                    
                    BezierCurveBox[{23, 168, 171, 173, 179, 181, 184, 23}, 
                    SplineDegree -> 7], 0.05710279699299331], 
                    ArrowBox[{23, 24}, 0.05710279699299331], 
                    ArrowBox[{23, 96}, 0.05710279699299331], 
                    ArrowBox[{23, 98}, 0.05710279699299331], 
                    ArrowBox[{24, 51}, 0.05710279699299331], 
                    ArrowBox[{25, 9}, 0.05710279699299331], 
                    ArrowBox[{25, 26}, 0.05710279699299331], 
                    ArrowBox[{25, 54}, 0.05710279699299331], 
                    ArrowBox[{25, 57}, 0.05710279699299331], 
                    ArrowBox[{26, 36}, 0.05710279699299331], 
                    ArrowBox[{26, 59}, 0.05710279699299331], 
                    ArrowBox[{26, 69}, 0.05710279699299331], 
                    ArrowBox[{27, 28}, 0.05710279699299331], 
                    ArrowBox[{27, 35}, 0.05710279699299331], 
                    ArrowBox[{28, 8}, 0.05710279699299331], 
                    ArrowBox[{28, 43}, 0.05710279699299331], 
                    ArrowBox[{29, 2}, 0.05710279699299331], 
                    ArrowBox[{29, 15}, 0.05710279699299331], 
                    ArrowBox[{30, 29}, 0.05710279699299331], 
                    ArrowBox[{30, 83}, 0.05710279699299331], 
                    ArrowBox[{31, 32}, 0.05710279699299331], 
                    ArrowBox[{31, 64}, 0.05710279699299331], 
                    ArrowBox[{31, 86}, 0.05710279699299331], 
                    ArrowBox[{33, 34}, 0.05710279699299331], 
                    ArrowBox[{34, 44}, 0.05710279699299331], 
                    ArrowBox[
                    
                    BezierCurveBox[{
                    34, {4.821677248732705, 4.458683679957214}, 61}], 
                    0.05710279699299331], 
                    ArrowBox[{34, 84}, 0.05710279699299331], 
                    ArrowBox[{34, 91}, 0.05710279699299331], 
                    ArrowBox[{35, 10}, 0.05710279699299331], 
                    ArrowBox[{35, 36}, 0.05710279699299331], 
                    ArrowBox[{35, 42}, 0.05710279699299331], 
                    ArrowBox[{35, 74}, 0.05710279699299331], 
                    ArrowBox[{36, 15}, 0.05710279699299331], 
                    ArrowBox[{36, 21}, 0.05710279699299331], 
                    ArrowBox[{36, 72}, 0.05710279699299331], 
                    ArrowBox[{37, 38}, 0.05710279699299331], 
                    ArrowBox[{37, 48}, 0.05710279699299331], 
                    ArrowBox[{38, 92}, 0.05710279699299331], 
                    ArrowBox[{39, 17}, 0.05710279699299331], 
                    ArrowBox[{39, 82}, 0.05710279699299331], 
                    ArrowBox[{39, 95}, 0.05710279699299331], 
                    ArrowBox[{40, 41}, 0.05710279699299331], 
                    ArrowBox[{41, 20}, 0.05710279699299331], 
                    ArrowBox[{42, 29}, 0.05710279699299331], 
                    ArrowBox[{42, 43}, 0.05710279699299331], 
                    ArrowBox[{42, 56}, 0.05710279699299331], 
                    ArrowBox[{42, 61}, 0.05710279699299331], 
                    ArrowBox[{43, 35}, 0.05710279699299331], 
                    ArrowBox[{43, 97}, 0.05710279699299331], 
                    ArrowBox[{44, 39}, 0.05710279699299331], 
                    ArrowBox[{44, 45}, 0.05710279699299331], 
                    ArrowBox[{44, 49}, 0.05710279699299331], 
                    ArrowBox[{44, 51}, 0.05710279699299331], 
                    ArrowBox[{44, 82}, 0.05710279699299331], 
                    ArrowBox[{46, 27}, 0.05710279699299331], 
                    ArrowBox[{46, 47}, 0.05710279699299331], 
                    ArrowBox[{47, 79}, 0.05710279699299331], 
                    ArrowBox[{48, 49}, 0.05710279699299331], 
                    ArrowBox[{49, 5}, 0.05710279699299331], 
                    ArrowBox[{49, 40}, 0.05710279699299331], 
                    ArrowBox[{49, 65}, 0.05710279699299331], 
                    ArrowBox[{49, 91}, 0.05710279699299331], 
                    ArrowBox[{50, 15}, 0.05710279699299331], 
                    ArrowBox[{50, 20}, 0.05710279699299331], 
                    ArrowBox[{51, 29}, 0.05710279699299331], 
                    ArrowBox[{52, 28}, 0.05710279699299331], 
                    ArrowBox[{52, 53}, 0.05710279699299331], 
                    ArrowBox[{52, 83}, 0.05710279699299331], 
                    ArrowBox[{53, 11}, 0.05710279699299331], 
                    ArrowBox[{53, 46}, 0.05710279699299331], 
                    ArrowBox[{54, 4}, 0.05710279699299331], 
                    ArrowBox[{54, 69}, 0.05710279699299331], 
                    ArrowBox[{54, 70}, 0.05710279699299331], 
                    ArrowBox[{54, 73}, 0.05710279699299331], 
                    ArrowBox[{55, 19}, 0.05710279699299331], 
                    ArrowBox[{55, 56}, 0.05710279699299331], 
                    ArrowBox[{56, 22}, 0.05710279699299331], 
                    ArrowBox[{56, 94}, 0.05710279699299331], 
                    ArrowBox[{57, 62}, 0.05710279699299331], 
                    ArrowBox[{57, 81}, 0.05710279699299331], 
                    ArrowBox[{57, 91}, 0.05710279699299331], 
                    ArrowBox[{58, 24}, 0.05710279699299331], 
                    ArrowBox[{58, 54}, 0.05710279699299331], 
                    ArrowBox[{58, 59}, 0.05710279699299331], 
                    ArrowBox[{61, 27}, 0.05710279699299331], 
                    ArrowBox[
                    
                    BezierCurveBox[{
                    61, {4.801757521683945, 4.866116791833445}, 34}], 
                    0.05710279699299331], 
                    ArrowBox[{61, 80}, 0.05710279699299331], 
                    ArrowBox[{62, 56}, 0.05710279699299331], 
                    ArrowBox[{63, 22}, 0.05710279699299331], 
                    ArrowBox[{63, 74}, 0.05710279699299331], 
                    ArrowBox[{64, 8}, 0.05710279699299331], 
                    ArrowBox[{65, 35}, 0.05710279699299331], 
                    ArrowBox[{65, 46}, 0.05710279699299331], 
                    ArrowBox[{65, 50}, 0.05710279699299331], 
                    ArrowBox[{65, 88}, 0.05710279699299331], 
                    ArrowBox[{66, 42}, 0.05710279699299331], 
                    ArrowBox[{66, 47}, 0.05710279699299331], 
                    ArrowBox[{66, 53}, 0.05710279699299331], 
                    ArrowBox[{66, 68}, 0.05710279699299331], 
                    ArrowBox[{67, 38}, 0.05710279699299331], 
                    ArrowBox[
                    
                    BezierCurveBox[{
                    69, {4.065497866002981, 4.731130244250564}, 57}], 
                    0.05710279699299331], 
                    ArrowBox[
                    
                    BezierCurveBox[{
                    69, {4.354643973615882, 4.732521597005693}, 57}], 
                    0.05710279699299331], 
                    ArrowBox[{69, 71}, 0.05710279699299331], 
                    ArrowBox[{70, 57}, 0.05710279699299331], 
                    ArrowBox[{70, 82}, 0.05710279699299331], 
                    ArrowBox[{71, 49}, 0.05710279699299331], 
                    ArrowBox[{71, 67}, 0.05710279699299331], 
                    ArrowBox[{72, 53}, 0.05710279699299331], 
                    ArrowBox[{73, 56}, 0.05710279699299331], 
                    ArrowBox[{74, 10}, 0.05710279699299331], 
                    ArrowBox[{74, 97}, 0.05710279699299331], 
                    ArrowBox[{75, 27}, 0.05710279699299331], 
                    ArrowBox[{76, 72}, 0.05710279699299331], 
                    ArrowBox[{77, 30}, 0.05710279699299331], 
                    ArrowBox[{77, 78}, 0.05710279699299331], 
                    ArrowBox[{77, 88}, 0.05710279699299331], 
                    ArrowBox[{78, 29}, 0.05710279699299331], 
                    ArrowBox[{79, 23}, 0.05710279699299331], 
                    ArrowBox[{79, 32}, 0.05710279699299331], 
                    ArrowBox[{79, 53}, 0.05710279699299331], 
                    ArrowBox[{79, 76}, 0.05710279699299331], 
                    ArrowBox[{80, 2}, 0.05710279699299331], 
                    ArrowBox[{81, 55}, 0.05710279699299331], 
                    ArrowBox[{81, 68}, 0.05710279699299331], 
                    ArrowBox[{82, 1}, 0.05710279699299331], 
                    ArrowBox[{82, 37}, 0.05710279699299331], 
                    ArrowBox[{83, 71}, 0.05710279699299331], 
                    ArrowBox[{84, 16}, 0.05710279699299331], 
                    ArrowBox[{84, 66}, 0.05710279699299331], 
                    ArrowBox[{85, 29}, 0.05710279699299331], 
                    ArrowBox[{85, 56}, 0.05710279699299331], 
                    ArrowBox[{85, 99}, 0.05710279699299331], 
                    ArrowBox[{87, 23}, 0.05710279699299331], 
                    ArrowBox[{87, 74}, 0.05710279699299331], 
                    ArrowBox[{88, 76}, 0.05710279699299331], 
                    ArrowBox[{89, 90}, 0.05710279699299331], 
                    ArrowBox[{90, 9}, 0.05710279699299331], 
                    ArrowBox[{93, 94}, 0.05710279699299331], 
                    ArrowBox[{94, 66}, 0.05710279699299331], 
                    ArrowBox[{95, 71}, 0.05710279699299331], 
                    ArrowBox[{96, 79}, 0.05710279699299331], 
                    ArrowBox[{100, 43}, 0.05710279699299331]}}}}, {{{{
                    Hue[0.6, 0.2, 0.8], 
                    EdgeForm[{
                    GrayLevel[0], 
                    Opacity[0.7]}], 
                    DiskBox[1, 0.05710279699299331], 
                    DiskBox[2, 0.05710279699299331], 
                    DiskBox[3, 0.05710279699299331], 
                    DiskBox[4, 0.05710279699299331], 
                    DiskBox[5, 0.05710279699299331], 
                    DiskBox[6, 0.05710279699299331], 
                    DiskBox[7, 0.05710279699299331], 
                    DiskBox[8, 0.05710279699299331], 
                    DiskBox[9, 0.05710279699299331], 
                    DiskBox[10, 0.05710279699299331], 
                    DiskBox[11, 0.05710279699299331], 
                    DiskBox[12, 0.05710279699299331], 
                    DiskBox[13, 0.05710279699299331], 
                    DiskBox[14, 0.05710279699299331], 
                    DiskBox[15, 0.05710279699299331], 
                    DiskBox[16, 0.05710279699299331], 
                    DiskBox[17, 0.05710279699299331], 
                    DiskBox[18, 0.05710279699299331], 
                    DiskBox[19, 0.05710279699299331], 
                    DiskBox[20, 0.05710279699299331], 
                    DiskBox[21, 0.05710279699299331], 
                    DiskBox[22, 0.05710279699299331], 
                    DiskBox[23, 0.05710279699299331], 
                    DiskBox[24, 0.05710279699299331], 
                    DiskBox[25, 0.05710279699299331], 
                    DiskBox[26, 0.05710279699299331], 
                    DiskBox[27, 0.05710279699299331], 
                    DiskBox[28, 0.05710279699299331], 
                    DiskBox[29, 0.05710279699299331], 
                    DiskBox[30, 0.05710279699299331], 
                    DiskBox[31, 0.05710279699299331], 
                    DiskBox[32, 0.05710279699299331], 
                    DiskBox[33, 0.05710279699299331], 
                    DiskBox[34, 0.05710279699299331], 
                    DiskBox[35, 0.05710279699299331], 
                    DiskBox[36, 0.05710279699299331], 
                    DiskBox[37, 0.05710279699299331], 
                    DiskBox[38, 0.05710279699299331], 
                    DiskBox[39, 0.05710279699299331], 
                    DiskBox[40, 0.05710279699299331], 
                    DiskBox[41, 0.05710279699299331], 
                    DiskBox[42, 0.05710279699299331], 
                    DiskBox[43, 0.05710279699299331], 
                    DiskBox[44, 0.05710279699299331], 
                    DiskBox[45, 0.05710279699299331], 
                    DiskBox[46, 0.05710279699299331], 
                    DiskBox[47, 0.05710279699299331], 
                    DiskBox[48, 0.05710279699299331], 
                    DiskBox[49, 0.05710279699299331], 
                    DiskBox[50, 0.05710279699299331], 
                    DiskBox[51, 0.05710279699299331], 
                    DiskBox[52, 0.05710279699299331], 
                    DiskBox[53, 0.05710279699299331], 
                    DiskBox[54, 0.05710279699299331], 
                    DiskBox[55, 0.05710279699299331], 
                    DiskBox[56, 0.05710279699299331], 
                    DiskBox[57, 0.05710279699299331], 
                    DiskBox[58, 0.05710279699299331], 
                    DiskBox[59, 0.05710279699299331], 
                    DiskBox[60, 0.05710279699299331], 
                    DiskBox[61, 0.05710279699299331], 
                    DiskBox[62, 0.05710279699299331], 
                    DiskBox[63, 0.05710279699299331], 
                    DiskBox[64, 0.05710279699299331], 
                    DiskBox[65, 0.05710279699299331], 
                    DiskBox[66, 0.05710279699299331], 
                    DiskBox[67, 0.05710279699299331], 
                    DiskBox[68, 0.05710279699299331], 
                    DiskBox[69, 0.05710279699299331], 
                    DiskBox[70, 0.05710279699299331], 
                    DiskBox[71, 0.05710279699299331], 
                    DiskBox[72, 0.05710279699299331], 
                    DiskBox[73, 0.05710279699299331], 
                    DiskBox[74, 0.05710279699299331], 
                    DiskBox[75, 0.05710279699299331], 
                    DiskBox[76, 0.05710279699299331], 
                    DiskBox[77, 0.05710279699299331], 
                    DiskBox[78, 0.05710279699299331], 
                    DiskBox[79, 0.05710279699299331], 
                    DiskBox[80, 0.05710279699299331], 
                    DiskBox[81, 0.05710279699299331], 
                    DiskBox[82, 0.05710279699299331], 
                    DiskBox[83, 0.05710279699299331], 
                    DiskBox[84, 0.05710279699299331], 
                    DiskBox[85, 0.05710279699299331], 
                    DiskBox[86, 0.05710279699299331], 
                    DiskBox[87, 0.05710279699299331], 
                    DiskBox[88, 0.05710279699299331], 
                    DiskBox[89, 0.05710279699299331], 
                    DiskBox[90, 0.05710279699299331], 
                    DiskBox[91, 0.05710279699299331], 
                    DiskBox[92, 0.05710279699299331], 
                    DiskBox[93, 0.05710279699299331], 
                    DiskBox[94, 0.05710279699299331], 
                    DiskBox[95, 0.05710279699299331], 
                    DiskBox[96, 0.05710279699299331], 
                    DiskBox[97, 0.05710279699299331], 
                    DiskBox[98, 0.05710279699299331], 
                    DiskBox[99, 0.05710279699299331], 
                    DiskBox[100, 0.05710279699299331]}}}}}]}], 
             MouseAppearanceTag["NetworkGraphics"]], 
            AllowKernelInitialization -> False]], 
          DefaultBaseStyle -> {
           "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> 
            Hue[0.8, 1., 0.6]}, FrameTicks -> None, GridLinesStyle -> 
          Directive[
            GrayLevel[0.5, 0.4]]]], "ExerciseOutput", Selectable -> False, 
        Copyable -> False, Editable -> False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"28c8fdea-cfdd-48c2-aef2-22e51cc11d8b"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Generate a plot that shows communities in a random graph with nodes \
numbered between 0 and 100, and 200 connections.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+21.7", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"857b2e9d-ce1d-453c-913a-cf45960a6e18"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       GraphicsBox[{{
          {EdgeForm[GrayLevel[0.5]], FaceForm[None], 
           FilledCurveBox[
            BSplineCurve[{{2.504715299661507, 3.1400946209658365`}, {
             2.5268358758883713`, 2.4692117191278045`}, {2.642100376413589, 
             2.310477248120802}, {2.904304017991039, 2.0906624799305074`}, {
             3.0556158126381425`, 1.9921960231876032`}, {3.2806603749620735`, 
             1.9921960231876032`}, {3.5483665011210506`, 2.12045331079764}, {
             3.6226430350488825`, 2.849003609807569}, {3.6226430350488825`, 
             3.0740481721315}, {2.729759861985438, 3.3651391832897675`}, {
             2.504715299661507, 3.3651391832897675`}}, SplineClosed -> 
             True]]}, 
          {EdgeForm[GrayLevel[0.5]], FaceForm[None], 
           FilledCurveBox[
            BSplineCurve[{{3.106394676285794, 1.1920636913642164`}, {
             3.135140997395571, 0.9603523061984222}, {3.2918076522479143`, 
             0.5225280241367393}, {3.840878966098638, 0.22193927382477702`}, {
             4.0659235284225685`, 0.22193927382477702`}, {4.191473794341938, 
             0.8699743032063462}, {4.191473794341938, 1.095018865530277}, {
             3.935462070022693, 1.6844487330130873`}, {3.710417507698762, 
             1.6844487330130873`}, {3.549099223414473, 1.629897524319239}, {
             3.106394676285794, 1.4171082536881474`}}, SplineClosed -> 
             True]]}, 
          {EdgeForm[GrayLevel[0.5]], FaceForm[None], 
           FilledCurveBox[
            BSplineCurve[{{1.1732728798408523`, 0.44878936639088624`}, {
             1.2100860995296623`, 0.08105356581455088}, {1.7215021358968445`, 
             0.03861726611577561}, {1.9465466982207755`, 
             0.03861726611577561}, {2.1213484013209736`, 
             0.4321083552891863}, {2.1937783907412585`, 0.7639779616261382}, {
             2.1937783907412585`, 0.989022523950069}, {1.9687338284173275`, 
             0.989022523950069}, {1.587737106116113, 0.870883355248861}, {
             1.1732728798408523`, 0.6738339287148171}}, SplineClosed -> 
             True]]}, 
          {EdgeForm[GrayLevel[0.5]], FaceForm[None], 
           FilledCurveBox[
            BSplineCurve[{{1.0655688310185523`, 2.5436401120919814`}, {
             1.369910182401233, 2.031277321476504}, {1.594954744725164, 
             2.031277321476504}, {1.9383492957563964`, 2.085185424610264}, {
             2.0137791237182068`, 2.523687223833418}, {2.0137791237182068`, 
             2.748731786157349}, {1.8998352842555688`, 3.1219297350825985`}, {
             1.6142131041748682`, 3.2436185300707607`}, {1.3891685418509372`, 
             3.2436185300707607`}, {1.0655688310185523`, 
             2.7686846744159124`}}, SplineClosed -> True]]}, 
          {EdgeForm[GrayLevel[0.5]], FaceForm[None], 
           FilledCurveBox[
            BSplineCurve[{{2.2496643109184085`, 0.41191927015310875`}, {
             2.2666189077895016`, -0.11252228116196543`}, {
             2.4916634701134326`, -0.11252228116196543`}, {
             2.9727410223676975`, -0.05063798488799136}, {3.0100102167266773`,
              0.47482084921012696`}, {3.0100102167266773`, 
             0.6998654115340578}, {2.7954437515182082`, 1.26004063106314}, {
             2.5703991891942772`, 1.26004063106314}, {2.2496643109184085`, 
             0.6369638324770396}}, SplineClosed -> True]]}, 
          {EdgeForm[GrayLevel[0.5]], FaceForm[None], 
           FilledCurveBox[
            BSplineCurve[{{-0.11252228116196543`, 1.6468367492376133`}, {
             0.08356490369628718, 1.3401463188107152`}, {0.3739660392236553, 
             1.1549429304834957`}, {0.5990106015475861, 
             1.1549429304834957`}, {1.544263251549029, 1.5311044983777358`}, {
             1.8762482545477508`, 1.688190183125934}, {1.8762482545477508`, 
             1.913234745449865}, {1.1714243182510646`, 2.4778569195150957`}, {
             0.9463797559271337, 2.4778569195150957`}, {-0.11252228116196543`,
              1.8718813115615442`}}, SplineClosed -> True]]}, 
          {EdgeForm[GrayLevel[0.5]], FaceForm[None], 
           FilledCurveBox[
            BSplineCurve[{{0.8377146037837145, 1.4036350768903367`}, {
             1.1165680059525396`, 0.912587359228403}, {1.3416125682764706`, 
             0.912587359228403}, {2.2333414282473405`, 1.2808545438438474`}, {
             2.2333414282473405`, 1.5058991061677784`}, {1.6726811582186512`, 
             1.7250898628160494`}, {1.4476365958947202`, 
             1.7250898628160494`}, {0.8377146037837145, 1.6286796392142677`}},
              SplineClosed -> True]]}}, {
          {Hue[0.6, 0.7, 0.5], Opacity[0.7], 
           Arrowheads[{{0.025323543815906433`, 0.8}}], 
           ArrowBox[BezierCurveBox[{{3.047075167056113, 
            2.7096635269133085`}, {2.6337432270398957`, 
            2.5742030070953428`}, {2.3373922908159024`, 
            2.5534080863295934`}, {2.0410413545919086`, 
            2.5326131655638444`}, {1.9012568425562415`, 2.6362095049953833`}},
            
            SplineDegree->2]], 
           ArrowBox[{{3.047075167056113, 2.7096635269133085`}, {
            2.979741943261697, 2.8525353858563727`}}], 
           ArrowBox[BezierCurveBox[{{3.047075167056113, 
            2.7096635269133085`}, {2.6337432270398957`, 
            2.5742030070953428`}, {2.3373922908159024`, 
            2.5534080863295934`}, {2.0410413545919086`, 
            2.5326131655638444`}, {1.8258270145944309`, 2.1977077057722294`}},
            
            SplineDegree->2]], 
           ArrowBox[{{3.047075167056113, 2.7096635269133085`}, {
            3.0268882963975825`, 2.501500726277051}}], 
           ArrowBox[BezierCurveBox[{{1.9012568425562415`, 
            2.6362095049953833`}, {2.1626772832503267`, 2.251474675317372}, {
            2.608100532649501, 1.9495263896002226`}, {3.053523782048675, 
            1.647578103883073}, {3.5177675418365486`, 1.1068835324227273`}},
            SplineDegree->2]], 
           ArrowBox[{{3.2189169574477594`, 1.304585972526182}, {
            3.436163837646358, 1.3991233158636618`}}], 
           ArrowBox[BezierCurveBox[{{3.2189169574477594`, 
            1.304585972526182}, {3.1392143941244517`, 0.9477234833919665}, {
            2.7442381089012415`, 0.8472558914549363}, {2.3492618236780314`, 
            0.746788299517906}, {2.081256109579293, 0.8765002427881036}},
            SplineDegree->2]], 
           ArrowBox[BezierCurveBox[{{3.2189169574477594`, 
            1.304585972526182}, {3.4282202750403057`, 1.5711907900515059`}, {
            3.310866474508976, 1.831789805678353}, {3.1935126739776463`, 
            2.0923888213052}, {3.435844219959085, 2.2329755919596055`}},
            SplineDegree->2]], 
           ArrowBox[BezierCurveBox[{{3.2189169574477594`, 
            1.304585972526182}, {3.053523782048675, 1.647578103883073}, {
            2.608100532649501, 1.9495263896002226`}, {2.1626772832503267`, 
            2.251474675317372}, {1.5709661391269687`, 2.6898873166852377`}},
            SplineDegree->2]], 
           ArrowBox[{{3.2189169574477594`, 1.304585972526182}, {
            3.4024975480581325`, 1.0360003985902304`}}], 
           ArrowBox[BezierCurveBox[{{3.436163837646358, 
            1.3991233158636618`}, {3.053523782048675, 1.647578103883073}, {
            2.608100532649501, 1.9495263896002226`}, {2.1626772832503267`, 
            2.251474675317372}, {1.8258270145944309`, 2.1977077057722294`}},
            SplineDegree->2]], 
           ArrowBox[{{3.436163837646358, 1.3991233158636618`}, {
            3.6616215045764386`, 1.5173752431572736`}}], 
           ArrowBox[{{3.436163837646358, 1.3991233158636618`}, {
            3.639524520551916, 1.423984925743525}}], 
           ArrowBox[{{3.436163837646358, 1.3991233158636618`}, {
            3.5177675418365486`, 1.1068835324227273`}}], 
           ArrowBox[{{2.8945169498586005`, 2.3278299921410754`}, {
            3.0168262991530046`, 2.203184761092473}}], 
           ArrowBox[BezierCurveBox[{{2.8945169498586005`, 
            2.3278299921410754`}, {3.1935126739776463`, 2.0923888213052}, {
            3.310866474508976, 1.831789805678353}, {3.4282202750403057`, 
            1.5711907900515059`}, {3.3698316224333045`, 1.3648023304164223`}},
            
            SplineDegree->2]], 
           ArrowBox[{{2.8945169498586005`, 2.3278299921410754`}, {
            3.0268882963975825`, 2.501500726277051}}], 
           ArrowBox[{{3.0168262991530046`, 2.203184761092473}, {
            3.168138093800108, 2.1047183043495687`}}], 
           ArrowBox[BezierCurveBox[{{3.863785160828577, 0.7483996524154757}, {
            3.1392143941244517`, 0.9477234833919665}, {2.7442381089012415`, 
            0.8472558914549363}, {2.3492618236780314`, 0.746788299517906}, {
            2.008826120159008, 0.5446306364511517}},
            SplineDegree->2]], 
           ArrowBox[{{3.863785160828577, 0.7483996524154757}, {
            3.9046185181312127`, 1.0791172991906632`}}], 
           ArrowBox[{{2.008826120159008, 0.5446306364511517}, {
            1.913334641285302, 0.7078373027089306}}], 
           ArrowBox[{{2.008826120159008, 0.5446306364511517}, {
            1.83402441705881, 0.15113954727774104`}}], 
           ArrowBox[BezierCurveBox[{{2.008826120159008, 0.5446306364511517}, {
            1.8354730322673434`, 0.3080379350795079}, {1.55552811144987, 
            0.2205265602056279}}]], 
           ArrowBox[BezierCurveBox[{{1.4317409703870636`, 
            1.6436267795397013`}, {1.794907056856041, 1.3911927256604393`}, {
            2.3624956923259255`, 1.2117839661631908`}, {2.9300843277958104`, 
            1.0323752066659424`}, {3.3698316224333045`, 1.3648023304164223`}},
            
            SplineDegree->2]], 
           ArrowBox[{{3.3698316224333045`, 1.3648023304164223`}, {
            3.2189169574477594`, 1.304585972526182}}], 
           ArrowBox[{{3.3698316224333045`, 1.3648023304164223`}, {
            3.8229397888607277`, 1.5719264518511218`}}], 
           ArrowBox[{{2.081256109579293, 0.8765002427881036}, {
            2.008826120159008, 0.5446306364511517}}], 
           ArrowBox[BezierCurveBox[{{2.081256109579293, 0.8765002427881036}, {
            2.3492618236780314`, 0.746788299517906}, {2.7442381089012415`, 
            0.8472558914549363}, {3.1392143941244517`, 0.9477234833919665}, {
            3.6312554533642967`, 1.276311392234716}},
            SplineDegree->2]], 
           ArrowBox[BezierCurveBox[{{2.081256109579293, 0.8765002427881036}, {
            2.064021962687497, 0.5471129920335013}, {2.208578974914188, 
            0.5736468787025666}, {2.3531359871408792`, 0.600180765371632}, {
            2.6435932129269224`, 0.6692393249864104}},
            SplineDegree->2]], 
           ArrowBox[{{3.435844219959085, 2.2329755919596055`}, {
            3.2558740995825404`, 2.299180100054544}}], 
           ArrowBox[BezierCurveBox[{{3.435844219959085, 
            2.2329755919596055`}, {2.7266410303727757`, 2.246568346752464}, {
            2.371836510866026, 1.9961473546963213`}, {2.0170319913592767`, 
            1.745726362640179}, {1.5601588770566857`, 1.6125675816540839`}},
            SplineDegree->2]], 
           ArrowBox[{{3.435844219959085, 2.2329755919596055`}, {
            3.343942158688346, 2.3809192251939044`}}], 
           ArrowBox[{{3.2558740995825404`, 2.299180100054544}, {
            3.047075167056113, 2.7096635269133085`}}], 
           ArrowBox[{{3.2558740995825404`, 2.299180100054544}, {
            3.168138093800108, 2.1047183043495687`}}], 
           ArrowBox[{{2.639358157050337, 2.58173400028977}, {
            2.8945169498586005`, 2.3278299921410754`}}], 
           ArrowBox[BezierCurveBox[{{2.639358157050337, 2.58173400028977}, {
            2.411252020272176, 2.4914499007369013`}, {2.031705016574954, 
            2.351729815828958}, {1.6521580128777318`, 2.212009730921015}, {
            1.2089139891580554`, 1.7577768430581273`}},
            SplineDegree->2]], 
           ArrowBox[{{2.639358157050337, 2.58173400028977}, {
            2.885749972239753, 2.5908377725505027`}}], 
           ArrowBox[{{2.639358157050337, 2.58173400028977}, {
            2.6381209230278255`, 2.8595746735201546`}}], 
           ArrowBox[{{1.2089139891580554`, 1.7577768430581273`}, {
            1.4317409703870636`, 1.6436267795397013`}}], 
           ArrowBox[{{1.2089139891580554`, 1.7577768430581273`}, {
            0.8641894439884323, 1.729865325243864}}], 
           ArrowBox[{{1.2089139891580554`, 1.7577768430581273`}, {
            1.0565798231281445`, 1.9692461660448652`}}], 
           ArrowBox[{{1.5709661391269687`, 2.6898873166852377`}, {
            1.659602271005506, 2.5661590599428186`}}], 
           ArrowBox[BezierCurveBox[{{1.5709661391269687`, 
            2.6898873166852377`}, {1.294215389986469, 2.2322515466569253`}, {
            1.076487091221816, 2.1386742526597917`}, {0.8587587924571634, 
            2.0450969586626577`}, {0., 1.7593590303995787`}},
            SplineDegree->2]], 
           ArrowBox[BezierCurveBox[{{1.5709661391269687`, 
            2.6898873166852377`}, {2.1626772832503267`, 2.251474675317372}, {
            2.608100532649501, 1.9495263896002226`}, {3.053523782048675, 
            1.647578103883073}, {3.8229397888607277`, 1.5719264518511218`}},
            SplineDegree->2]], 
           ArrowBox[BezierCurveBox[{{1.4077729862113624`, 
            1.3627094940221658`}, {2.0170319913592767`, 1.745726362640179}, {
            2.371836510866026, 1.9961473546963213`}, {2.7266410303727757`, 
            2.246568346752464}, {3.2558740995825404`, 2.299180100054544}},
            SplineDegree->2]], 
           ArrowBox[{{1.4077729862113624`, 1.3627094940221658`}, {
            1.2844991781478532`, 1.3776207935937406`}}], 
           ArrowBox[{{1.2844991781478532`, 1.3776207935937406`}, {
            1.4872871787099529`, 1.2260793094448104`}}], 
           ArrowBox[{{3.153603273248364, 2.9306699008070343`}, {
            2.885749972239753, 2.5908377725505027`}}], 
           ArrowBox[{{3.153603273248364, 2.9306699008070343`}, {
            3.247766799018454, 2.714317113377208}}], 
           ArrowBox[{{1.7262385797428599`, 2.90059760515629}, {
            1.659602271005506, 2.5661590599428186`}}], 
           ArrowBox[BezierCurveBox[{{1.7262385797428599`, 2.90059760515629}, {
            2.0410413545919086`, 2.5326131655638444`}, {2.3373922908159024`, 
            2.5534080863295934`}, {2.6337432270398957`, 
            2.5742030070953428`}, {2.7546226575755544`, 2.4229995292827673`}},
            
            SplineDegree->2]], 
           ArrowBox[{{1.7262385797428599`, 2.90059760515629}, {
            1.5016908230129027`, 3.1310962489087952`}}], 
           ArrowBox[{{1.659602271005506, 2.5661590599428186`}, {
            1.7765265466405027`, 2.4779315488363594`}}], 
           ArrowBox[{{1.659602271005506, 2.5661590599428186`}, {
            1.6936108638638805`, 2.443351346309686}}], 
           ArrowBox[BezierCurveBox[{{1.659602271005506, 
            2.5661590599428186`}, {1.838338177911715, 1.9476339047721272`}, {
            2.064794489679235, 1.5108311399139298`}, {2.2912508014467545`, 
            1.0740283750557325`}, {2.362186592080374, 0.5244415513150742}},
            SplineDegree->2]], 
           ArrowBox[BezierCurveBox[{{1.5601588770566857`, 
            1.6125675816540839`}, {1.228389712547824, 1.5949583654878405`}, {
            1.2015815440944655`, 1.6255542611224878`}, {1.1747733756411067`, 
            1.6561501567571353`}, {1.4317409703870636`, 1.6436267795397013`}},
            
            SplineDegree->2]], 
           ArrowBox[{{1.5601588770566857`, 1.6125675816540839`}, {
            1.2844991781478532`, 1.3776207935937406`}}], 
           ArrowBox[BezierCurveBox[{{1.5601588770566857`, 
            1.6125675816540839`}, {2.0170319913592767`, 1.745726362640179}, {
            2.371836510866026, 1.9961473546963213`}, {2.7266410303727757`, 
            2.246568346752464}, {2.6172375808234727`, 3.252616902127802}},
            SplineDegree->2]], 
           ArrowBox[{{1.5601588770566857`, 1.6125675816540839`}, {
            1.7892970888888562`, 1.3839977852843286`}}], 
           ArrowBox[BezierCurveBox[{{1.5601588770566857`, 
            1.6125675816540839`}, {1.5336830797576235`, 
            1.6957096003879502`}, {1.5436431316319277`, 
            1.9720957552264533`}, {1.5536031835062318`, 
            2.2484819100649562`}, {1.4936031083055394`, 2.3466448592302127`}},
            
            SplineDegree->2]], 
           ArrowBox[BezierCurveBox[{{2.75647819250503, 2.6658384200680523`}, {
            2.6804205208083554`, 2.024931712359108}, {2.4620411094771133`, 
            1.623380895826643}, {2.2436616981458712`, 1.2218300792941776`}, {
            2.081256109579293, 0.8765002427881036}},
            SplineDegree->2]], 
           ArrowBox[{{2.75647819250503, 2.6658384200680523`}, {
            2.941964292630955, 2.3750910006693067`}}], 
           ArrowBox[{{2.75647819250503, 2.6658384200680523`}, {
            2.7949307783187454`, 2.7932962145942843`}}], 
           ArrowBox[{{1.7765265466405027`, 2.4779315488363594`}, {
            1.9012568425562415`, 2.6362095049953833`}}], 
           ArrowBox[BezierCurveBox[{{1.7765265466405027`, 
            2.4779315488363594`}, {1.5536031835062318`, 
            2.2484819100649562`}, {1.5436431316319277`, 
            1.9720957552264533`}, {1.5336830797576235`, 
            1.6957096003879502`}, {1.4872871787099529`, 1.2260793094448104`}},
            
            SplineDegree->2]], 
           ArrowBox[{{1.8659877072932964`, 0.3556277108148027}, {
            2.008826120159008, 0.5446306364511517}}], 
           ArrowBox[BezierCurveBox[{{1.8659877072932964`, 
            0.3556277108148027}, {2.064021962687497, 0.5471129920335013}, {
            2.208578974914188, 0.5736468787025666}, {2.3531359871408792`, 
            0.600180765371632}, {2.4769053868232604`, 0.7462115076005172}},
            SplineDegree->2]], 
           ArrowBox[{{1.8659877072932964`, 0.3556277108148027}, {
            1.6322141299670254`, 0.32782518429781415`}}], 
           ArrowBox[BezierCurveBox[{{2.7105021551043778`, 
            0.9070036280291717}, {2.787798387597087, 0.8324265149818357}, {
            3.0035027884902825`, 0.9646248618534529}, {3.219207189383478, 
            1.0968232087250698`}, {3.2189169574477594`, 1.304585972526182}},
            SplineDegree->2]], 
           ArrowBox[BezierCurveBox[{{2.7105021551043778`, 
            0.9070036280291717}, {2.81067077425526, 1.1280611434185157`}, {
            2.9159297206102837`, 1.5703238351934834`}, {3.021188666965308, 
            2.012586526968451}, {2.941964292630955, 2.3750910006693067`}},
            SplineDegree->2]], 
           ArrowBox[{{2.7105021551043778`, 0.9070036280291717}, {
            2.4769053868232604`, 0.7462115076005172}}], 
           ArrowBox[{{2.7105021551043778`, 0.9070036280291717}, {
            2.897487935564712, 0.5873431303720924}}], 
           ArrowBox[{{2.941964292630955, 2.3750910006693067`}, {
            3.0168262991530046`, 2.203184761092473}}], 
           ArrowBox[BezierCurveBox[{{2.941964292630955, 
            2.3750910006693067`}, {2.411252020272176, 2.4914499007369013`}, {
            2.031705016574954, 2.351729815828958}, {1.6521580128777318`, 
            2.212009730921015}, {1.0589020370890991`, 2.36533463835313}},
            SplineDegree->2]], 
           ArrowBox[{{1.7892970888888562`, 1.3839977852843286`}, {
            2.120819147085375, 1.393376825005813}}], 
           ArrowBox[BezierCurveBox[{{1.7892970888888562`, 
            1.3839977852843286`}, {1.8687814253183264`, 1.155710264596793}, {
            2.099270716837248, 1.0063819818290165`}, {2.32976000835617, 
            0.8570536990612403}, {2.4769053868232604`, 0.7462115076005172}},
            SplineDegree->2]], 
           ArrowBox[BezierCurveBox[{{3.2191147448421815`, 
            2.591814620447461}, {3.1935126739776463`, 2.0923888213052}, {
            3.310866474508976, 1.831789805678353}, {3.4282202750403057`, 
            1.5711907900515059`}, {3.2189169574477594`, 1.304585972526182}},
            SplineDegree->2]], 
           ArrowBox[{{3.2191147448421815`, 2.591814620447461}, {
            2.941964292630955, 2.3750910006693067`}}], 
           ArrowBox[BezierCurveBox[{{1.4936031083055394`, 
            2.3466448592302127`}, {2.0410413545919086`, 
            2.5326131655638444`}, {2.3373922908159024`, 
            2.5534080863295934`}, {2.6337432270398957`, 
            2.5742030070953428`}, {3.047075167056113, 2.7096635269133085`}},
            SplineDegree->2]], 
           ArrowBox[{{1.4936031083055394`, 2.3466448592302127`}, {
            1.7765265466405027`, 2.4779315488363594`}}], 
           ArrowBox[BezierCurveBox[{{1.4936031083055394`, 
            2.3466448592302127`}, {1.637616326493326, 1.821540005334698}, {
            1.6746117908322624`, 1.413695954789092}, {1.711607255171199, 
            1.0058519042434861`}, {1.7002593872780785`, 0.7583610740868956}},
            SplineDegree->2]], 
           ArrowBox[{{1.4936031083055394`, 2.3466448592302127`}, {
            1.4824324635631985`, 2.1437996026384694`}}], 
           ArrowBox[{{1.4936031083055394`, 2.3466448592302127`}, {
            1.1780911121805178`, 2.656162393253947}}], 
           ArrowBox[{{1.7002593872780785`, 0.7583610740868956}, {
            2.081256109579293, 0.8765002427881036}}], 
           ArrowBox[{{1.7002593872780785`, 0.7583610740868956}, {
            1.5770143574601727`, 0.6524818163347639}}], 
           ArrowBox[{{2.696123673956549, 2.9770171690697973`}, {
            2.6172375808234727`, 3.252616902127802}}], 
           ArrowBox[{{2.696123673956549, 2.9770171690697973`}, {
            2.75647819250503, 2.6658384200680523`}}], 
           ArrowBox[BezierCurveBox[{{2.696123673956549, 
            2.9770171690697973`}, {2.411252020272176, 2.4914499007369013`}, {
            2.031705016574954, 2.351729815828958}, {1.6521580128777318`, 
            2.212009730921015}, {1.0589020370890991`, 2.36533463835313}},
            SplineDegree->2]], 
           ArrowBox[{{1.4872871787099529`, 1.2260793094448104`}, {
            1.4077729862113624`, 1.3627094940221658`}}], 
           ArrowBox[BezierCurveBox[{{1.4872871787099529`, 
            1.2260793094448104`}, {1.5336830797576235`, 
            1.6957096003879502`}, {1.5436431316319277`, 
            1.9720957552264533`}, {1.5536031835062318`, 
            2.2484819100649562`}, {1.4824324635631985`, 2.1437996026384694`}},
            
            SplineDegree->2]], 
           ArrowBox[BezierCurveBox[{{1.4872871787099529`, 
            1.2260793094448104`}, {1.7104439007428545`, 
            1.1182909487320065`}, {1.748928030816812, 0.9091933546397499}, {
            1.7874121608907694`, 0.7000957605474933}, {1.913334641285302, 
            0.7078373027089306}},
            SplineDegree->2]], 
           ArrowBox[BezierCurveBox[{{1.4872871787099529`, 
            1.2260793094448104`}, {2.347917726246338, 1.3009371077712735`}, {
            2.7861936281991087`, 1.2642632290570681`}, {3.224469530151879, 
            1.2275893503428628`}, {4.078951513179973, 0.9824965843683116}},
            SplineDegree->2]], 
           ArrowBox[BezierCurveBox[{{1.4872871787099529`, 
            1.2260793094448104`}, {1.8687814253183264`, 1.155710264596793}, {
            2.099270716837248, 1.0063819818290165`}, {2.32976000835617, 
            0.8570536990612403}, {2.6435932129269224`, 0.6692393249864104}},
            SplineDegree->2]], 
           ArrowBox[BezierCurveBox[{{0.8641894439884323, 1.729865325243864}, {
            0.751376302364705, 1.436555813464101}, {0.48648832038562073`, 
            1.2674652116454612`}}]], 
           ArrowBox[{{2.860218741205732, 0.06188429627397407}, {
            2.728134301269645, 0.547410220538946}}], 
           ArrowBox[{{2.728134301269645, 0.547410220538946}, {
            2.479471842206366, 0.5332217204409468}}], 
           ArrowBox[{{2.728134301269645, 0.547410220538946}, {
            2.6435932129269224`, 0.6692393249864104}}], 
           ArrowBox[{{3.6879572559236125`, 0.7806372519986963}, {
            3.7188573339539, 0.5590467057909552}}], 
           ArrowBox[{{3.7188573339539, 0.5590467057909552}, {
            3.863785160828577, 0.7483996524154757}}], 
           ArrowBox[BezierCurveBox[{{2.120819147085375, 1.393376825005813}, {
            2.0170319913592767`, 1.745726362640179}, {2.371836510866026, 
            1.9961473546963213`}, {2.7266410303727757`, 2.246568346752464}, {
            3.0168262991530046`, 2.203184761092473}},
            SplineDegree->2]], 
           ArrowBox[BezierCurveBox[{{2.120819147085375, 1.393376825005813}, {
            1.7104439007428545`, 1.1182909487320065`}, {1.748928030816812, 
            0.9091933546397499}, {1.7874121608907694`, 0.7000957605474933}, {
            2.008826120159008, 0.5446306364511517}},
            SplineDegree->2]], 
           ArrowBox[BezierCurveBox[{{2.120819147085375, 1.393376825005813}, {
            2.347917726246338, 1.3009371077712735`}, {2.7861936281991087`, 
            1.2642632290570681`}, {3.224469530151879, 1.2275893503428628`}, {
            3.2476632785575363`, 1.0728745873603875`}},
            SplineDegree->2]], 
           ArrowBox[{{2.7546226575755544`, 2.4229995292827673`}, {
            2.639358157050337, 2.58173400028977}}], 
           ArrowBox[{{2.7546226575755544`, 2.4229995292827673`}, {
            2.885749972239753, 2.5908377725505027`}}], 
           ArrowBox[BezierCurveBox[{{2.7546226575755544`, 
            2.4229995292827673`}, {2.6337432270398957`, 
            2.5742030070953428`}, {2.3373922908159024`, 
            2.5534080863295934`}, {2.0410413545919086`, 
            2.5326131655638444`}, {1.7765265466405027`, 2.4779315488363594`}},
            
            SplineDegree->2]], 
           ArrowBox[{{2.7546226575755544`, 2.4229995292827673`}, {
            2.941964292630955, 2.3750910006693067`}}], 
           ArrowBox[BezierCurveBox[{{2.7546226575755544`, 
            2.4229995292827673`}, {3.021188666965308, 2.012586526968451}, {
            2.9159297206102837`, 1.5703238351934834`}, {2.81067077425526, 
            1.1280611434185157`}, {2.728134301269645, 0.547410220538946}},
            SplineDegree->2]], 
           ArrowBox[{{2.7546226575755544`, 2.4229995292827673`}, {
            3.0268882963975825`, 2.501500726277051}}], 
           ArrowBox[BezierCurveBox[{{2.479471842206366, 0.5332217204409468}, {
            2.126662012046929, 0.8482328451065787}, {1.8324948069504872`, 
            1.1676340543351469`}, {1.5383276018540455`, 1.487035263563715}, {
            1.0565798231281445`, 1.9692461660448652`}},
            SplineDegree->2]], 
           ArrowBox[{{2.479471842206366, 0.5332217204409468}, {
            2.4769053868232604`, 0.7462115076005172}}], 
           ArrowBox[{{2.479471842206366, 0.5332217204409468}, {
            2.508013277206207, 0.2397169293763568}}], 
           ArrowBox[BezierCurveBox[{{2.7717835101136528`, 
            2.5088908622570987`}, {2.6804205208083554`, 2.024931712359108}, {
            2.4620411094771133`, 1.623380895826643}, {2.2436616981458712`, 
            1.2218300792941776`}, {2.081256109579293, 0.8765002427881036}},
            SplineDegree->2]], 
           ArrowBox[{{2.7717835101136528`, 2.5088908622570987`}, {
            2.7546226575755544`, 2.4229995292827673`}}], 
           ArrowBox[{{2.7717835101136528`, 2.5088908622570987`}, {
            3.247766799018454, 2.714317113377208}}], 
           ArrowBox[{{3.247766799018454, 2.714317113377208}, {
            3.2191147448421815`, 2.591814620447461}}], 
           ArrowBox[{{3.247766799018454, 2.714317113377208}, {
            3.510120753886917, 2.9615258909695346`}}], 
           ArrowBox[BezierCurveBox[{{1.4824324635631985`, 
            2.1437996026384694`}, {1.294215389986469, 2.2322515466569253`}, {
            1.076487091221816, 2.1386742526597917`}, {0.8587587924571634, 
            2.0450969586626577`}, {0.8641894439884323, 1.729865325243864}},
            SplineDegree->2]], 
           ArrowBox[BezierCurveBox[{{1.4824324635631985`, 
            2.1437996026384694`}, {1.637616326493326, 1.821540005334698}, {
            1.6746117908322624`, 1.413695954789092}, {1.711607255171199, 
            1.0058519042434861`}, {1.913334641285302, 0.7078373027089306}},
            SplineDegree->2]], 
           ArrowBox[{{1.4824324635631985`, 2.1437996026384694`}, {
            1.8258270145944309`, 2.1977077057722294`}}], 
           ArrowBox[BezierCurveBox[{{1.4824324635631985`, 
            2.1437996026384694`}, {1.294215389986469, 2.2322515466569253`}, {
            1.076487091221816, 2.1386742526597917`}, {0.8587587924571634, 
            2.0450969586626577`}, {1.0589020370890991`, 2.36533463835313}},
            SplineDegree->2]], 
           ArrowBox[BezierCurveBox[{{1.913334641285302, 0.7078373027089306}, {
            2.2436616981458712`, 1.2218300792941776`}, {2.4620411094771133`, 
            1.623380895826643}, {2.6804205208083554`, 2.024931712359108}, {
            3.168138093800108, 2.1047183043495687`}},
            SplineDegree->2]], 
           ArrowBox[BezierCurveBox[{{1.913334641285302, 0.7078373027089306}, {
            2.3492618236780314`, 0.746788299517906}, {2.7442381089012415`, 
            0.8472558914549363}, {3.1392143941244517`, 0.9477234833919665}, {
            3.7188573339539, 0.5590467057909552}},
            SplineDegree->2]], 
           ArrowBox[{{1.913334641285302, 0.7078373027089306}, {
            1.5770143574601727`, 0.6524818163347639}}], 
           ArrowBox[{{2.979741943261697, 2.8525353858563727`}, {
            3.2191147448421815`, 2.591814620447461}}], 
           ArrowBox[{{2.979741943261697, 2.8525353858563727`}, {
            2.696123673956549, 2.9770171690697973`}}], 
           ArrowBox[{{2.979741943261697, 2.8525353858563727`}, {
            2.7949307783187454`, 2.7932962145942843`}}], 
           ArrowBox[{{2.7949307783187454`, 2.7932962145942843`}, {
            2.7546226575755544`, 2.4229995292827673`}}], 
           ArrowBox[{{1.8258270145944309`, 2.1977077057722294`}, {
            1.6936108638638805`, 2.443351346309686}}], 
           ArrowBox[{{1.6936108638638805`, 2.443351346309686}, {
            1.9012568425562415`, 2.6362095049953833`}}], 
           ArrowBox[BezierCurveBox[{{1.5016908230129027`, 
            3.1310962489087952`}, {1.5536031835062318`, 
            2.2484819100649562`}, {1.5436431316319277`, 
            1.9720957552264533`}, {1.5336830797576235`, 
            1.6957096003879502`}, {1.5601588770566857`, 1.6125675816540839`}},
            
            SplineDegree->2]], 
           ArrowBox[BezierCurveBox[{{3.6616215045764386`, 
            1.5173752431572736`}, {3.224469530151879, 1.2275893503428628`}, {
            2.7861936281991087`, 1.2642632290570681`}, {2.347917726246338, 
            1.3009371077712735`}, {2.120819147085375, 1.393376825005813}},
            SplineDegree->2]], 
           ArrowBox[BezierCurveBox[{{3.6616215045764386`, 
            1.5173752431572736`}, {3.4282202750403057`, 
            1.5711907900515059`}, {3.310866474508976, 1.831789805678353}, {
            3.1935126739776463`, 2.0923888213052}, {2.7717835101136528`, 
            2.5088908622570987`}},
            SplineDegree->2]], 
           ArrowBox[{{3.6616215045764386`, 1.5173752431572736`}, {
            3.639524520551916, 1.423984925743525}}], 
           ArrowBox[BezierCurveBox[{{3.6616215045764386`, 
            1.5173752431572736`}, {3.219207189383478, 1.0968232087250698`}, {
            3.0035027884902825`, 0.9646248618534529}, {2.787798387597087, 
            0.8324265149818357}, {2.362186592080374, 0.5244415513150742}},
            SplineDegree->2]], 
           ArrowBox[BezierCurveBox[{{3.639524520551916, 1.423984925743525}, {
            3.4282202750403057`, 1.5711907900515059`}, {3.310866474508976, 
            1.831789805678353}, {3.1935126739776463`, 2.0923888213052}, {
            3.0168262991530046`, 2.203184761092473}},
            SplineDegree->2]], 
           ArrowBox[{{2.4769053868232604`, 0.7462115076005172}, {
            2.362186592080374, 0.5244415513150742}}], 
           ArrowBox[{{4.078951513179973, 0.9824965843683116}, {
            3.863785160828577, 0.7483996524154757}}], 
           ArrowBox[BezierCurveBox[{{4.078951513179973, 0.9824965843683116}, {
            3.4282202750403057`, 1.5711907900515059`}, {3.310866474508976, 
            1.831789805678353}, {3.1935126739776463`, 2.0923888213052}, {
            3.168138093800108, 2.1047183043495687`}},
            SplineDegree->2]], 
           ArrowBox[BezierCurveBox[{{3.9046185181312127`, 
            1.0791172991906632`}, {3.90939819980242, 1.2893649853150646`}, {
            4.069115161332321, 1.4206039932014407`}, {4.20925178761289, 
            1.417436842811863}, {4.359829095244178, 1.0724185712790484`}, {
            4.266857865980218, 0.9675154950799296}, {4.062024164931119, 
            0.9396526182386514}, {3.9046185181312127`, 1.0791172991906632`}},
            SplineDegree->7]], 
           ArrowBox[{{3.9046185181312127`, 1.0791172991906632`}, {
            3.6312554533642967`, 1.276311392234716}}], 
           ArrowBox[{{3.6312554533642967`, 1.276311392234716}, {
            3.3698316224333045`, 1.3648023304164223`}}], 
           ArrowBox[{{3.6312554533642967`, 1.276311392234716}, {
            3.639524520551916, 1.423984925743525}}], 
           ArrowBox[BezierCurveBox[{{3.6312554533642967`, 
            1.276311392234716}, {3.4282202750403057`, 1.5711907900515059`}, {
            3.310866474508976, 1.831789805678353}, {3.1935126739776463`, 
            2.0923888213052}, {3.0268882963975825`, 2.501500726277051}},
            SplineDegree->2]], 
           ArrowBox[BezierCurveBox[{{3.4024975480581325`, 
            1.0360003985902304`}, {3.1392143941244517`, 0.9477234833919665}, {
            2.7442381089012415`, 0.8472558914549363}, {2.3492618236780314`, 
            0.746788299517906}, {2.008826120159008, 0.5446306364511517}},
            SplineDegree->2]], 
           ArrowBox[{{3.4024975480581325`, 1.0360003985902304`}, {
            3.6879572559236125`, 0.7806372519986963}}], 
           ArrowBox[{{2.6435932129269224`, 0.6692393249864104}, {
            2.7105021551043778`, 0.9070036280291717}}], 
           ArrowBox[{{2.6435932129269224`, 0.6692393249864104}, {
            2.4769053868232604`, 0.7462115076005172}}], 
           ArrowBox[{{2.6829214703562427`, 1.1475183499011745`}, {
            2.7105021551043778`, 0.9070036280291717}}], 
           ArrowBox[BezierCurveBox[{{2.6829214703562427`, 
            1.1475183499011745`}, {2.81067077425526, 1.1280611434185157`}, {
            2.9159297206102837`, 1.5703238351934834`}, {3.021188666965308, 
            2.012586526968451}, {3.247766799018454, 2.714317113377208}},
            SplineDegree->2]], 
           ArrowBox[BezierCurveBox[{{2.6829214703562427`, 
            1.1475183499011745`}, {2.2912508014467545`, 
            1.0740283750557325`}, {2.064794489679235, 1.5108311399139298`}, {
            1.838338177911715, 1.9476339047721272`}, {1.6936108638638805`, 
            2.443351346309686}},
            SplineDegree->2]], 
           ArrowBox[{{0., 1.7593590303995787`}, {0.1960871848582526, 
            1.4526685999726807`}}], 
           ArrowBox[{{3.2476632785575363`, 1.0728745873603875`}, {
            3.2189169574477594`, 1.304585972526182}}], 
           ArrowBox[{{3.2476632785575363`, 1.0728745873603875`}, {
            3.4043299334098798`, 0.6350503052987047}}], 
           ArrowBox[{{3.343942158688346, 2.3809192251939044`}, {
            2.885749972239753, 2.5908377725505027`}}], 
           ArrowBox[{{1.83402441705881, 0.15113954727774104`}, {
            1.3226083806916278`, 0.1935758469765163}}], 
           ArrowBox[{{1.3226083806916278`, 0.1935758469765163}, {
            1.2857951610028178`, 0.5613116475528517}}], 
           ArrowBox[{{3.4184546835413303`, 2.658053342032937}, {
            2.941964292630955, 2.3750910006693067`}}], 
           ArrowBox[{{1.0589020370890991`, 2.36533463835313}, {
            1.0565798231281445`, 1.9692461660448652`}}], 
           ArrowBox[{{3.5177675418365486`, 1.1068835324227273`}, {
            3.4024975480581325`, 1.0360003985902304`}}], 
           ArrowBox[{{3.5177675418365486`, 1.1068835324227273`}, {
            3.424196308805824, 0.8651034511066054}}], 
           ArrowBox[BezierCurveBox[{{1.55552811144987, 0.2205265602056279}, {
            1.7288811993415338`, 0.45711926157705735`}, {2.008826120159008, 
            0.5446306364511517}}]], 
           ArrowBox[BezierCurveBox[{{1.55552811144987, 0.2205265602056279}, {
            1.7874121608907694`, 0.7000957605474933}, {1.748928030816812, 
            0.9091933546397499}, {1.7104439007428545`, 1.1182909487320065`}, {
            1.4077729862113624`, 1.3627094940221658`}},
            SplineDegree->2]], 
           ArrowBox[{{1.55552811144987, 0.2205265602056279}, {
            1.7752671079791367`, 0.470509225953319}}], 
           ArrowBox[BezierCurveBox[{{2.897487935564712, 0.5873431303720924}, {
            2.81067077425526, 1.1280611434185157`}, {2.9159297206102837`, 
            1.5703238351934834`}, {3.021188666965308, 2.012586526968451}, {
            3.343942158688346, 2.3809192251939044`}},
            SplineDegree->2]], 
           ArrowBox[{{2.897487935564712, 0.5873431303720924}, {
            2.648658069975757, 0.39873378586359465`}}], 
           ArrowBox[{{2.648658069975757, 0.39873378586359465`}, {
            2.6435932129269224`, 0.6692393249864104}}], 
           ArrowBox[BezierCurveBox[{{2.508013277206207, 0.2397169293763568}, {
            2.2912508014467545`, 1.0740283750557325`}, {2.064794489679235, 
            1.5108311399139298`}, {1.838338177911715, 1.9476339047721272`}, {
            1.4824324635631985`, 2.1437996026384694`}},
            SplineDegree->2]], 
           ArrowBox[BezierCurveBox[{{2.508013277206207, 0.2397169293763568}, {
            2.81067077425526, 1.1280611434185157`}, {2.9159297206102837`, 
            1.5703238351934834`}, {3.021188666965308, 2.012586526968451}, {
            3.343942158688346, 2.3809192251939044`}},
            SplineDegree->2]], 
           ArrowBox[BezierCurveBox[{{2.362186592080374, 0.5244415513150742}, {
            2.3531359871408792`, 0.600180765371632}, {2.208578974914188, 
            0.5736468787025666}, {2.064021962687497, 0.5471129920335013}, {
            2.008826120159008, 0.5446306364511517}},
            SplineDegree->2]], 
           ArrowBox[BezierCurveBox[{{2.362186592080374, 0.5244415513150742}, {
            2.126662012046929, 0.8482328451065787}, {1.8324948069504872`, 
            1.1676340543351469`}, {1.5383276018540455`, 1.487035263563715}, {
            1.4317409703870636`, 1.6436267795397013`}},
            SplineDegree->2]], 
           ArrowBox[BezierCurveBox[{{2.362186592080374, 0.5244415513150742}, {
            2.3531359871408792`, 0.600180765371632}, {2.208578974914188, 
            0.5736468787025666}, {2.064021962687497, 0.5471129920335013}, {
            1.8659877072932964`, 0.3556277108148027}},
            SplineDegree->2]], 
           ArrowBox[{{2.362186592080374, 0.5244415513150742}, {
            2.648658069975757, 0.39873378586359465`}}], 
           ArrowBox[BezierCurveBox[{{1.6322141299670254`, 
            0.32782518429781415`}, {2.3492618236780314`, 0.746788299517906}, {
            2.7442381089012415`, 0.8472558914549363}, {3.1392143941244517`, 
            0.9477234833919665}, {3.3698316224333045`, 1.3648023304164223`}},
            SplineDegree->2]], 
           ArrowBox[BezierCurveBox[{{1.6322141299670254`, 
            0.32782518429781415`}, {1.711607255171199, 1.0058519042434861`}, {
            1.6746117908322624`, 1.413695954789092}, {1.637616326493326, 
            1.821540005334698}, {1.8258270145944309`, 2.1977077057722294`}},
            SplineDegree->2]], 
           ArrowBox[{{1.6322141299670254`, 0.32782518429781415`}, {
            1.55552811144987, 0.2205265602056279}}], 
           ArrowBox[BezierCurveBox[{{1.6322141299670254`, 
            0.32782518429781415`}, {1.3061787728066507`, 
            0.7115815687819482}, {1.1533529001283798`, 0.9785947216385636}, {
            1.000527027450109, 1.2456078744951788`}, {0.48648832038562073`, 
            1.2674652116454612`}},
            SplineDegree->2]], 
           ArrowBox[BezierCurveBox[{{0.48648832038562073`, 
            1.2674652116454612`}, {0.5993014620093488, 1.5607747234214011`}, {
            0.8641894439884323, 1.729865325243864}}]], 
           ArrowBox[{{0.48648832038562073`, 1.2674652116454612`}, {
            0.1960871848582526, 1.4526685999726807`}}], 
           ArrowBox[BezierCurveBox[{{0.48648832038562073`, 
            1.2674652116454612`}, {1.794907056856041, 1.3911927256604393`}, {
            2.3624956923259255`, 1.2117839661631908`}, {2.9300843277958104`, 
            1.0323752066659424`}, {3.4043299334098798`, 0.6350503052987047}},
            SplineDegree->2]], 
           ArrowBox[BezierCurveBox[{{3.424196308805824, 0.8651034511066054}, {
            3.219207189383478, 1.0968232087250698`}, {3.0035027884902825`, 
            0.9646248618534529}, {2.787798387597087, 0.8324265149818357}, {
            2.6435932129269224`, 0.6692393249864104}},
            SplineDegree->2]], 
           ArrowBox[{{3.424196308805824, 0.8651034511066054}, {
            3.2476632785575363`, 1.0728745873603875`}}], 
           ArrowBox[{{1.5194871010494955`, 0.46597995469881126`}, {
            1.8659877072932964`, 0.3556277108148027}}], 
           ArrowBox[{{1.5194871010494955`, 0.46597995469881126`}, {
            1.7002593872780785`, 0.7583610740868956}}], 
           ArrowBox[{{1.7752671079791367`, 0.470509225953319}, {
            2.008826120159008, 0.5446306364511517}}], 
           ArrowBox[{{1.7752671079791367`, 0.470509225953319}, {
            1.7002593872780785`, 0.7583610740868956}}], 
           ArrowBox[BezierCurveBox[{{1.7752671079791367`, 
            0.470509225953319}, {2.064021962687497, 0.5471129920335013}, {
            2.208578974914188, 0.5736468787025666}, {2.3531359871408792`, 
            0.600180765371632}, {2.6435932129269224`, 0.6692393249864104}},
            SplineDegree->2]], 
           ArrowBox[{{1.7873130030936033`, 3.009407453920633}, {
            1.9012568425562415`, 2.6362095049953833`}}], 
           ArrowBox[{{1.7873130030936033`, 3.009407453920633}, {
            1.7262385797428599`, 2.90059760515629}}], 
           ArrowBox[BezierCurveBox[{{1.2857951610028178`, 
            0.5613116475528517}, {1.3061787728066507`, 0.7115815687819482}, {
            1.1533529001283798`, 0.9785947216385636}, {1.000527027450109, 
            1.2456078744951788`}, {1.2089139891580554`, 1.7577768430581273`}},
            
            SplineDegree->2]], 
           ArrowBox[{{1.2857951610028178`, 0.5613116475528517}, {
            1.7002593872780785`, 0.7583610740868956}}], 
           ArrowBox[{{3.9534012472606035`, 0.33446155498674246`}, {
            3.7188573339539, 0.5590467057909552}}], 
           ArrowBox[{{0.6956755051279591, 2.0931413686684124`}, {
            1.0565798231281445`, 1.9692461660448652`}}], 
           ArrowBox[{{0.9502368849456799, 1.5161573580523022`}, {
            1.5601588770566857`, 1.6125675816540839`}}], 
           ArrowBox[BezierCurveBox[{{0.9502368849456799, 
            1.5161573580523022`}, {1.228389712547824, 1.5949583654878405`}, {
            1.2015815440944655`, 1.6255542611224878`}, {1.1747733756411067`, 
            1.6561501567571353`}, {0.8641894439884323, 1.729865325243864}},
            SplineDegree->2]], 
           ArrowBox[{{1.7637259733857853`, 1.8007124642878996`}, {
            1.4317409703870636`, 1.6436267795397013`}}], 
           ArrowBox[BezierCurveBox[{{1.7637259733857853`, 
            1.8007124642878996`}, {1.6521580128777318`, 2.212009730921015}, {
            2.031705016574954, 2.351729815828958}, {2.411252020272176, 
            2.4914499007369013`}, {2.885749972239753, 2.5908377725505027`}},
            SplineDegree->2]], 
           ArrowBox[BezierCurveBox[{{1.7637259733857853`, 
            1.8007124642878996`}, {1.794907056856041, 1.3911927256604393`}, {
            2.3624956923259255`, 1.2117839661631908`}, {2.9300843277958104`, 
            1.0323752066659424`}, {3.7188573339539, 0.5590467057909552}},
            SplineDegree->2]], 
           ArrowBox[{{2.379141188951467, 0.}, {2.362186592080374, 
            0.5244415513150742}}], 
           ArrowBox[{{2.6381209230278255`, 2.8595746735201546`}, {
            2.7717835101136528`, 2.5088908622570987`}}], 
           ArrowBox[{{1.229090287114505, 1.0251096403903683`}, {
            1.7892970888888562`, 1.3839977852843286`}}]}, 
          {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[0.7]}], 
           {Hue[0, 1, 0.8], 
            DiskBox[{3.047075167056113, 2.7096635269133085}, 
             0.037507427053988476]}, 
           {Hue[0.07, 1, 1], 
            DiskBox[{1.9012568425562415, 2.6362095049953833}, 
             0.037507427053988476]}, 
           {Hue[0.14, 1, 0.9], 
            DiskBox[{3.2189169574477594, 1.304585972526182}, 
             0.037507427053988476]}, 
           {Hue[0.14, 1, 0.9], 
            DiskBox[{3.436163837646358, 1.3991233158636618}, 
             0.037507427053988476]}, 
           {Hue[0, 1, 0.8], 
            DiskBox[{2.8945169498586005, 2.3278299921410754}, 
             0.037507427053988476]}, 
           {Hue[0, 1, 0.8], 
            DiskBox[{3.0168262991530046, 2.203184761092473}, 
             0.037507427053988476]}, 
           {Hue[0.14, 1, 0.9], 
            DiskBox[{3.863785160828577, 0.7483996524154757}, 
             0.037507427053988476]}, 
           {Hue[0.8, 0.6, 0.8], 
            DiskBox[{2.008826120159008, 0.5446306364511517}, 
             0.037507427053988476]}, 
           {Hue[0.1, 0.6, 0.7], 
            DiskBox[{1.4317409703870636, 1.6436267795397013}, 
             0.037507427053988476]}, 
           {Hue[0.14, 1, 0.9], 
            DiskBox[{3.3698316224333045, 1.3648023304164223}, 
             0.037507427053988476]}, 
           {Hue[0.8, 0.6, 0.8], 
            DiskBox[{2.081256109579293, 0.8765002427881036}, 
             0.037507427053988476]}, 
           {Hue[0, 1, 0.8], 
            DiskBox[{3.435844219959085, 2.2329755919596055}, 
             0.037507427053988476]}, 
           {Hue[0, 1, 0.8], 
            DiskBox[{3.2558740995825404, 2.299180100054544}, 
             0.037507427053988476]}, 
           {Hue[0, 1, 0.8], 
            DiskBox[{2.639358157050337, 2.58173400028977}, 
             0.037507427053988476]}, 
           {Hue[0.1, 0.6, 0.7], 
            DiskBox[{1.2089139891580554, 1.7577768430581273}, 
             0.037507427053988476]}, 
           {Hue[0.07, 1, 1], 
            DiskBox[{1.5709661391269687, 2.6898873166852377}, 
             0.037507427053988476]}, 
           {Hue[0.5, 1, 0.7], 
            DiskBox[{1.4077729862113624, 1.3627094940221658}, 
             0.037507427053988476]}, 
           {Hue[0.5, 1, 0.7], 
            DiskBox[{1.2844991781478532, 1.3776207935937406}, 
             0.037507427053988476]}, 
           {Hue[0, 1, 0.8], 
            DiskBox[{3.153603273248364, 2.9306699008070343}, 
             0.037507427053988476]}, 
           {Hue[0, 1, 0.8], 
            DiskBox[{2.885749972239753, 2.5908377725505027}, 
             0.037507427053988476]}, 
           {Hue[0.07, 1, 1], 
            DiskBox[{1.7262385797428599, 2.90059760515629}, 
             0.037507427053988476]}, 
           {Hue[0.07, 1, 1], 
            DiskBox[{1.659602271005506, 2.5661590599428186}, 
             0.037507427053988476]}, 
           {Hue[0.5, 1, 0.7], 
            DiskBox[{1.5601588770566857, 1.6125675816540839}, 
             0.037507427053988476]}, 
           {Hue[0, 1, 0.8], 
            DiskBox[{2.6172375808234727, 3.252616902127802}, 
             0.037507427053988476]}, 
           {Hue[0, 1, 0.8], 
            DiskBox[{2.75647819250503, 2.6658384200680523}, 
             0.037507427053988476]}, 
           {Hue[0.07, 1, 1], 
            DiskBox[{1.7765265466405027, 2.4779315488363594}, 
             0.037507427053988476]}, 
           {Hue[0.8, 0.6, 0.8], 
            DiskBox[{1.8659877072932964, 0.3556277108148027}, 
             0.037507427053988476]}, 
           {Hue[0.2, 1, 0.6], 
            DiskBox[{2.7105021551043778, 0.9070036280291717}, 
             0.037507427053988476]}, 
           {Hue[0, 1, 0.8], 
            DiskBox[{2.941964292630955, 2.3750910006693067}, 
             0.037507427053988476]}, 
           {Hue[0, 1, 0.8], 
            DiskBox[{3.168138093800108, 2.1047183043495687}, 
             0.037507427053988476]}, 
           {Hue[0.5, 1, 0.7], 
            DiskBox[{1.7892970888888562, 1.3839977852843286}, 
             0.037507427053988476]}, 
           {Hue[0, 1, 0.8], 
            DiskBox[{3.2191147448421815, 2.591814620447461}, 
             0.037507427053988476]}, 
           {Hue[0.07, 1, 1], 
            DiskBox[{1.4936031083055394, 2.3466448592302127}, 
             0.037507427053988476]}, 
           {Hue[0.8, 0.6, 0.8], 
            DiskBox[{1.7002593872780785, 0.7583610740868956}, 
             0.037507427053988476]}, 
           {Hue[0, 1, 0.8], 
            DiskBox[{2.696123673956549, 2.9770171690697973}, 
             0.037507427053988476]}, 
           {Hue[0.5, 1, 0.7], 
            DiskBox[{1.4872871787099529, 1.2260793094448104}, 
             0.037507427053988476]}, 
           {Hue[0.1, 0.6, 0.7], 
            DiskBox[{0.8641894439884323, 1.729865325243864}, 
             0.037507427053988476]}, 
           {Hue[0.2, 1, 0.6], 
            DiskBox[{2.860218741205732, 0.06188429627397407}, 
             0.037507427053988476]}, 
           {Hue[0.2, 1, 0.6], 
            DiskBox[{2.728134301269645, 0.547410220538946}, 
             0.037507427053988476]}, 
           {Hue[0.14, 1, 0.9], 
            DiskBox[{3.6879572559236125, 0.7806372519986963}, 
             0.037507427053988476]}, 
           {Hue[0.14, 1, 0.9], 
            DiskBox[{3.7188573339539, 0.5590467057909552}, 
             0.037507427053988476]}, 
           {Hue[0.5, 1, 0.7], 
            DiskBox[{2.120819147085375, 1.393376825005813}, 
             0.037507427053988476]}, 
           {Hue[0, 1, 0.8], 
            DiskBox[{2.7546226575755544, 2.4229995292827673}, 
             0.037507427053988476]}, 
           {Hue[0.2, 1, 0.6], 
            DiskBox[{2.479471842206366, 0.5332217204409468}, 
             0.037507427053988476]}, 
           {Hue[0.1, 0.6, 0.7], 
            DiskBox[{1.0565798231281445, 1.9692461660448652}, 
             0.037507427053988476]}, 
           {Hue[0, 1, 0.8], 
            DiskBox[{2.7717835101136528, 2.5088908622570987}, 
             0.037507427053988476]}, 
           {Hue[0, 1, 0.8], 
            DiskBox[{3.247766799018454, 2.714317113377208}, 
             0.037507427053988476]}, 
           {Hue[0.07, 1, 1], 
            DiskBox[{1.4824324635631985, 2.1437996026384694}, 
             0.037507427053988476]}, 
           {Hue[0.8, 0.6, 0.8], 
            DiskBox[{1.913334641285302, 0.7078373027089306}, 
             0.037507427053988476]}, 
           {Hue[0, 1, 0.8], 
            DiskBox[{2.979741943261697, 2.8525353858563727}, 
             0.037507427053988476]}, 
           {Hue[0, 1, 0.8], 
            DiskBox[{2.7949307783187454, 2.7932962145942843}, 
             0.037507427053988476]}, 
           {Hue[0.07, 1, 1], 
            DiskBox[{1.8258270145944309, 2.1977077057722294}, 
             0.037507427053988476]}, 
           {Hue[0.07, 1, 1], 
            DiskBox[{1.6936108638638805, 2.443351346309686}, 
             0.037507427053988476]}, 
           {Hue[0.07, 1, 1], 
            DiskBox[{1.5016908230129027, 3.1310962489087952}, 
             0.037507427053988476]}, 
           {Hue[0.14, 1, 0.9], 
            DiskBox[{3.6616215045764386, 1.5173752431572736}, 
             0.037507427053988476]}, 
           {Hue[0.14, 1, 0.9], 
            DiskBox[{3.639524520551916, 1.423984925743525}, 
             0.037507427053988476]}, 
           {Hue[0.2, 1, 0.6], 
            DiskBox[{2.4769053868232604, 0.7462115076005172}, 
             0.037507427053988476]}, 
           {Hue[0.14, 1, 0.9], 
            DiskBox[{4.078951513179973, 0.9824965843683116}, 
             0.037507427053988476]}, 
           {Hue[0.14, 1, 0.9], 
            DiskBox[{3.9046185181312127, 1.0791172991906632}, 
             0.037507427053988476]}, 
           {Hue[0.14, 1, 0.9], 
            DiskBox[{3.6312554533642967, 1.276311392234716}, 
             0.037507427053988476]}, 
           {Hue[0.14, 1, 0.9], 
            DiskBox[{3.4024975480581325, 1.0360003985902304}, 
             0.037507427053988476]}, 
           {Hue[0.2, 1, 0.6], 
            DiskBox[{2.6435932129269224, 0.6692393249864104}, 
             0.037507427053988476]}, 
           {Hue[0.2, 1, 0.6], 
            DiskBox[{2.6829214703562427, 1.1475183499011745}, 
             0.037507427053988476]}, 
           {Hue[0.1, 0.6, 0.7], 
            DiskBox[{0., 1.7593590303995787}, 0.037507427053988476]}, 
           {Hue[0.1, 0.6, 0.7], 
            DiskBox[{0.1960871848582526, 1.4526685999726807}, 
             0.037507427053988476]}, 
           {Hue[0.14, 1, 0.9], 
            DiskBox[{3.2476632785575363, 1.0728745873603875}, 
             0.037507427053988476]}, 
           {Hue[0.14, 1, 0.9], 
            DiskBox[{3.4043299334098798, 0.6350503052987047}, 
             0.037507427053988476]}, 
           {Hue[0, 1, 0.8], 
            DiskBox[{3.343942158688346, 2.3809192251939044}, 
             0.037507427053988476]}, 
           {Hue[0.8, 0.6, 0.8], 
            DiskBox[{1.83402441705881, 0.15113954727774104}, 
             0.037507427053988476]}, 
           {Hue[0.8, 0.6, 0.8], 
            DiskBox[{1.3226083806916278, 0.1935758469765163}, 
             0.037507427053988476]}, 
           {Hue[0, 1, 0.8], 
            DiskBox[{3.4184546835413303, 2.658053342032937}, 
             0.037507427053988476]}, 
           {Hue[0.1, 0.6, 0.7], 
            DiskBox[{1.0589020370890991, 2.36533463835313}, 
             0.037507427053988476]}, 
           {Hue[0.14, 1, 0.9], 
            DiskBox[{3.5177675418365486, 1.1068835324227273}, 
             0.037507427053988476]}, 
           {Hue[0.8, 0.6, 0.8], 
            DiskBox[{1.55552811144987, 0.2205265602056279}, 
             0.037507427053988476]}, 
           {Hue[0.2, 1, 0.6], 
            DiskBox[{2.897487935564712, 0.5873431303720924}, 
             0.037507427053988476]}, 
           {Hue[0.2, 1, 0.6], 
            DiskBox[{2.648658069975757, 0.39873378586359465}, 
             0.037507427053988476]}, 
           {Hue[0.2, 1, 0.6], 
            DiskBox[{2.508013277206207, 0.2397169293763568}, 
             0.037507427053988476]}, 
           {Hue[0.2, 1, 0.6], 
            DiskBox[{2.362186592080374, 0.5244415513150742}, 
             0.037507427053988476]}, 
           {Hue[0.8, 0.6, 0.8], 
            DiskBox[{1.6322141299670254, 0.32782518429781415}, 
             0.037507427053988476]}, 
           {Hue[0.1, 0.6, 0.7], 
            DiskBox[{0.48648832038562073, 1.2674652116454612}, 
             0.037507427053988476]}, 
           {Hue[0.14, 1, 0.9], 
            DiskBox[{3.424196308805824, 0.8651034511066054}, 
             0.037507427053988476]}, 
           {Hue[0, 1, 0.8], 
            DiskBox[{3.0268882963975825, 2.501500726277051}, 
             0.037507427053988476]}, 
           {Hue[0.8, 0.6, 0.8], 
            DiskBox[{1.5194871010494955, 0.46597995469881126}, 
             0.037507427053988476]}, 
           {Hue[0.8, 0.6, 0.8], 
            DiskBox[{1.7752671079791367, 0.470509225953319}, 
             0.037507427053988476]}, 
           {Hue[0.07, 1, 1], 
            DiskBox[{1.7873130030936033, 3.009407453920633}, 
             0.037507427053988476]}, 
           {Hue[0, 1, 0.8], 
            DiskBox[{3.510120753886917, 2.9615258909695346}, 
             0.037507427053988476]}, 
           {Hue[0.14, 1, 0.9], 
            DiskBox[{3.8229397888607277, 1.5719264518511218}, 
             0.037507427053988476]}, 
           {Hue[0.8, 0.6, 0.8], 
            DiskBox[{1.2857951610028178, 0.5613116475528517}, 
             0.037507427053988476]}, 
           {Hue[0.14, 1, 0.9], 
            DiskBox[{3.9534012472606035, 0.33446155498674246}, 
             0.037507427053988476]}, 
           {Hue[0.1, 0.6, 0.7], 
            DiskBox[{0.6956755051279591, 2.0931413686684124}, 
             0.037507427053988476]}, 
           {Hue[0.5, 1, 0.7], 
            DiskBox[{0.9502368849456799, 1.5161573580523022}, 
             0.037507427053988476]}, 
           {Hue[0.07, 1, 1], 
            DiskBox[{1.1780911121805178, 2.656162393253947}, 
             0.037507427053988476]}, 
           {Hue[0.1, 0.6, 0.7], 
            DiskBox[{1.7637259733857853, 1.8007124642878996}, 
             0.037507427053988476]}, 
           {Hue[0.2, 1, 0.6], 
            DiskBox[{2.379141188951467, 0.}, 0.037507427053988476]}, 
           {Hue[0.8, 0.6, 0.8], 
            DiskBox[{1.5770143574601727, 0.6524818163347639}, 
             0.037507427053988476]}, 
           {Hue[0, 1, 0.8], 
            DiskBox[{2.6381209230278255, 2.8595746735201546}, 
             0.037507427053988476]}, 
           {Hue[0.5, 1, 0.7], 
            DiskBox[{1.229090287114505, 1.0251096403903683}, 
             0.037507427053988476]}}}},
        FrameTicks->None,
        GridLinesStyle->Directive[
          GrayLevel[0.5, 0.4]],
        ImageSize->{449.9453125, Automatic}]], "ExerciseOutput",
       ExpressionUUID->"e67a64a8-5e24-4c76-ac94-9b7bf95e0729"],
      Apply[TextCell, 
       Cell[
        BoxData[
         GraphicsBox[{{{{{{
                EdgeForm[
                 GrayLevel[0.5]], 
                FaceForm[None], 
                FilledCurveBox[
                 
                 BSplineCurve[{{2.504715299661507, 3.1400946209658365`}, {
                  2.5268358758883713`, 2.4692117191278045`}, {
                  2.642100376413589, 2.310477248120802}, {2.904304017991039, 
                  2.0906624799305074`}, {3.0556158126381425`, 
                  1.9921960231876032`}, {3.2806603749620735`, 
                  1.9921960231876032`}, {3.5483665011210506`, 
                  2.12045331079764}, {3.6226430350488825`, 
                  2.849003609807569}, {3.6226430350488825`, 
                  3.0740481721315}, {2.729759861985438, 
                  3.3651391832897675`}, {2.504715299661507, 
                  3.3651391832897675`}}, SplineClosed -> True]]}}}}, {{{{
                EdgeForm[
                 GrayLevel[0.5]], 
                FaceForm[None], 
                FilledCurveBox[
                 
                 BSplineCurve[{{3.106394676285794, 1.1920636913642164`}, {
                  3.135140997395571, 0.9603523061984222}, {
                  3.2918076522479143`, 0.5225280241367393}, {
                  3.840878966098638, 0.22193927382477702`}, {
                  4.0659235284225685`, 0.22193927382477702`}, {
                  4.191473794341938, 0.8699743032063462}, {4.191473794341938, 
                  1.095018865530277}, {3.935462070022693, 
                  1.6844487330130873`}, {3.710417507698762, 
                  1.6844487330130873`}, {3.549099223414473, 
                  1.629897524319239}, {3.106394676285794, 
                  1.4171082536881474`}}, SplineClosed -> True]]}}}}, {{{{
                EdgeForm[
                 GrayLevel[0.5]], 
                FaceForm[None], 
                FilledCurveBox[
                 
                 BSplineCurve[{{1.1732728798408523`, 0.44878936639088624`}, {
                  1.2100860995296623`, 0.08105356581455088}, {
                  1.7215021358968445`, 0.03861726611577561}, {
                  1.9465466982207755`, 0.03861726611577561}, {
                  2.1213484013209736`, 0.4321083552891863}, {
                  2.1937783907412585`, 0.7639779616261382}, {
                  2.1937783907412585`, 0.989022523950069}, {
                  1.9687338284173275`, 0.989022523950069}, {1.587737106116113,
                   0.870883355248861}, {1.1732728798408523`, 
                  0.6738339287148171}}, SplineClosed -> True]]}}}}, {{{{
                EdgeForm[
                 GrayLevel[0.5]], 
                FaceForm[None], 
                FilledCurveBox[
                 
                 BSplineCurve[{{1.0655688310185523`, 2.5436401120919814`}, {
                  1.369910182401233, 2.031277321476504}, {1.594954744725164, 
                  2.031277321476504}, {1.9383492957563964`, 
                  2.085185424610264}, {2.0137791237182068`, 
                  2.523687223833418}, {2.0137791237182068`, 
                  2.748731786157349}, {1.8998352842555688`, 
                  3.1219297350825985`}, {1.6142131041748682`, 
                  3.2436185300707607`}, {1.3891685418509372`, 
                  3.2436185300707607`}, {1.0655688310185523`, 
                  2.7686846744159124`}}, SplineClosed -> True]]}}}}, {{{{
                EdgeForm[
                 GrayLevel[0.5]], 
                FaceForm[None], 
                FilledCurveBox[
                 
                 BSplineCurve[{{2.2496643109184085`, 0.41191927015310875`}, {
                  2.2666189077895016`, -0.11252228116196543`}, {
                  2.4916634701134326`, -0.11252228116196543`}, {
                  2.9727410223676975`, -0.05063798488799136}, {
                  3.0100102167266773`, 0.47482084921012696`}, {
                  3.0100102167266773`, 0.6998654115340578}, {
                  2.7954437515182082`, 1.26004063106314}, {
                  2.5703991891942772`, 1.26004063106314}, {
                  2.2496643109184085`, 0.6369638324770396}}, SplineClosed -> 
                  True]]}}}}, {{{{
                EdgeForm[
                 GrayLevel[0.5]], 
                FaceForm[None], 
                FilledCurveBox[
                 
                 BSplineCurve[{{-0.11252228116196543`, 1.6468367492376133`}, {
                  0.08356490369628718, 1.3401463188107152`}, {
                  0.3739660392236553, 1.1549429304834957`}, {
                  0.5990106015475861, 1.1549429304834957`}, {
                  1.544263251549029, 1.5311044983777358`}, {
                  1.8762482545477508`, 1.688190183125934}, {
                  1.8762482545477508`, 1.913234745449865}, {
                  1.1714243182510646`, 2.4778569195150957`}, {
                  0.9463797559271337, 
                  2.4778569195150957`}, {-0.11252228116196543`, 
                  1.8718813115615442`}}, SplineClosed -> True]]}}}}, {{{{
                EdgeForm[
                 GrayLevel[0.5]], 
                FaceForm[None], 
                FilledCurveBox[
                 
                 BSplineCurve[{{0.8377146037837145, 1.4036350768903367`}, {
                  1.1165680059525396`, 0.912587359228403}, {
                  1.3416125682764706`, 0.912587359228403}, {
                  2.2333414282473405`, 1.2808545438438474`}, {
                  2.2333414282473405`, 1.5058991061677784`}, {
                  1.6726811582186512`, 1.7250898628160494`}, {
                  1.4476365958947202`, 1.7250898628160494`}, {
                  0.8377146037837145, 1.6286796392142677`}}, SplineClosed -> 
                  True]]}}}}}, {{{{{
                Hue[0.6, 0.7, 0.5], 
                Opacity[0.7], 
                Arrowheads[{{0.025323543815906433`, 0.8}}], 
                ArrowBox[
                 
                 BezierCurveBox[{{3.047075167056113, 2.7096635269133085`}, {
                  2.6337432270398957`, 2.5742030070953428`}, {
                  2.3373922908159024`, 2.5534080863295934`}, {
                  2.0410413545919086`, 2.5326131655638444`}, {
                  1.9012568425562415`, 2.6362095049953833`}}, SplineDegree -> 
                  2]], 
                
                ArrowBox[{{3.047075167056113, 2.7096635269133085`}, {
                 2.979741943261697, 2.8525353858563727`}}], 
                ArrowBox[
                 
                 BezierCurveBox[{{3.047075167056113, 2.7096635269133085`}, {
                  2.6337432270398957`, 2.5742030070953428`}, {
                  2.3373922908159024`, 2.5534080863295934`}, {
                  2.0410413545919086`, 2.5326131655638444`}, {
                  1.8258270145944309`, 2.1977077057722294`}}, SplineDegree -> 
                  2]], 
                
                ArrowBox[{{3.047075167056113, 2.7096635269133085`}, {
                 3.0268882963975825`, 2.501500726277051}}], 
                ArrowBox[
                 
                 BezierCurveBox[{{1.9012568425562415`, 2.6362095049953833`}, {
                  2.1626772832503267`, 2.251474675317372}, {2.608100532649501,
                   1.9495263896002226`}, {3.053523782048675, 
                  1.647578103883073}, {3.5177675418365486`, 
                  1.1068835324227273`}}, SplineDegree -> 2]], 
                
                ArrowBox[{{3.2189169574477594`, 1.304585972526182}, {
                 3.436163837646358, 1.3991233158636618`}}], 
                ArrowBox[
                 
                 BezierCurveBox[{{3.2189169574477594`, 1.304585972526182}, {
                  3.1392143941244517`, 0.9477234833919665}, {
                  2.7442381089012415`, 0.8472558914549363}, {
                  2.3492618236780314`, 0.746788299517906}, {2.081256109579293,
                   0.8765002427881036}}, SplineDegree -> 2]], 
                ArrowBox[
                 
                 BezierCurveBox[{{3.2189169574477594`, 1.304585972526182}, {
                  3.4282202750403057`, 1.5711907900515059`}, {
                  3.310866474508976, 1.831789805678353}, {3.1935126739776463`,
                   2.0923888213052}, {3.435844219959085, 
                  2.2329755919596055`}}, SplineDegree -> 2]], 
                ArrowBox[
                 
                 BezierCurveBox[{{3.2189169574477594`, 1.304585972526182}, {
                  3.053523782048675, 1.647578103883073}, {2.608100532649501, 
                  1.9495263896002226`}, {2.1626772832503267`, 
                  2.251474675317372}, {1.5709661391269687`, 
                  2.6898873166852377`}}, SplineDegree -> 2]], 
                
                ArrowBox[{{3.2189169574477594`, 1.304585972526182}, {
                 3.4024975480581325`, 1.0360003985902304`}}], 
                ArrowBox[
                 
                 BezierCurveBox[{{3.436163837646358, 1.3991233158636618`}, {
                  3.053523782048675, 1.647578103883073}, {2.608100532649501, 
                  1.9495263896002226`}, {2.1626772832503267`, 
                  2.251474675317372}, {1.8258270145944309`, 
                  2.1977077057722294`}}, SplineDegree -> 2]], 
                ArrowBox[{{3.436163837646358, 1.3991233158636618`}, {
                 3.6616215045764386`, 1.5173752431572736`}}], 
                
                ArrowBox[{{3.436163837646358, 1.3991233158636618`}, {
                 3.639524520551916, 1.423984925743525}}], 
                
                ArrowBox[{{3.436163837646358, 1.3991233158636618`}, {
                 3.5177675418365486`, 1.1068835324227273`}}], 
                
                ArrowBox[{{2.8945169498586005`, 2.3278299921410754`}, {
                 3.0168262991530046`, 2.203184761092473}}], 
                ArrowBox[
                 
                 BezierCurveBox[{{2.8945169498586005`, 2.3278299921410754`}, {
                  3.1935126739776463`, 2.0923888213052}, {3.310866474508976, 
                  1.831789805678353}, {3.4282202750403057`, 
                  1.5711907900515059`}, {3.3698316224333045`, 
                  1.3648023304164223`}}, SplineDegree -> 2]], 
                
                ArrowBox[{{2.8945169498586005`, 2.3278299921410754`}, {
                 3.0268882963975825`, 2.501500726277051}}], 
                
                ArrowBox[{{3.0168262991530046`, 2.203184761092473}, {
                 3.168138093800108, 2.1047183043495687`}}], 
                ArrowBox[
                 
                 BezierCurveBox[{{3.863785160828577, 0.7483996524154757}, {
                  3.1392143941244517`, 0.9477234833919665}, {
                  2.7442381089012415`, 0.8472558914549363}, {
                  2.3492618236780314`, 0.746788299517906}, {2.008826120159008,
                   0.5446306364511517}}, SplineDegree -> 2]], 
                
                ArrowBox[{{3.863785160828577, 0.7483996524154757}, {
                 3.9046185181312127`, 1.0791172991906632`}}], 
                
                ArrowBox[{{2.008826120159008, 0.5446306364511517}, {
                 1.913334641285302, 0.7078373027089306}}], 
                
                ArrowBox[{{2.008826120159008, 0.5446306364511517}, {
                 1.83402441705881, 0.15113954727774104`}}], 
                ArrowBox[
                 
                 BezierCurveBox[{{2.008826120159008, 0.5446306364511517}, {
                  1.8354730322673434`, 0.3080379350795079}, {1.55552811144987,
                   0.2205265602056279}}]], 
                ArrowBox[
                 
                 BezierCurveBox[{{1.4317409703870636`, 1.6436267795397013`}, {
                  1.794907056856041, 1.3911927256604393`}, {
                  2.3624956923259255`, 1.2117839661631908`}, {
                  2.9300843277958104`, 1.0323752066659424`}, {
                  3.3698316224333045`, 1.3648023304164223`}}, SplineDegree -> 
                  2]], 
                
                ArrowBox[{{3.3698316224333045`, 1.3648023304164223`}, {
                 3.2189169574477594`, 1.304585972526182}}], 
                
                ArrowBox[{{3.3698316224333045`, 1.3648023304164223`}, {
                 3.8229397888607277`, 1.5719264518511218`}}], 
                
                ArrowBox[{{2.081256109579293, 0.8765002427881036}, {
                 2.008826120159008, 0.5446306364511517}}], 
                ArrowBox[
                 
                 BezierCurveBox[{{2.081256109579293, 0.8765002427881036}, {
                  2.3492618236780314`, 0.746788299517906}, {
                  2.7442381089012415`, 0.8472558914549363}, {
                  3.1392143941244517`, 0.9477234833919665}, {
                  3.6312554533642967`, 1.276311392234716}}, SplineDegree -> 
                  2]], 
                ArrowBox[
                 
                 BezierCurveBox[{{2.081256109579293, 0.8765002427881036}, {
                  2.064021962687497, 0.5471129920335013}, {2.208578974914188, 
                  0.5736468787025666}, {2.3531359871408792`, 
                  0.600180765371632}, {2.6435932129269224`, 
                  0.6692393249864104}}, SplineDegree -> 2]], 
                
                ArrowBox[{{3.435844219959085, 2.2329755919596055`}, {
                 3.2558740995825404`, 2.299180100054544}}], 
                ArrowBox[
                 
                 BezierCurveBox[{{3.435844219959085, 2.2329755919596055`}, {
                  2.7266410303727757`, 2.246568346752464}, {2.371836510866026,
                   1.9961473546963213`}, {2.0170319913592767`, 
                  1.745726362640179}, {1.5601588770566857`, 
                  1.6125675816540839`}}, SplineDegree -> 2]], 
                
                ArrowBox[{{3.435844219959085, 2.2329755919596055`}, {
                 3.343942158688346, 2.3809192251939044`}}], 
                
                ArrowBox[{{3.2558740995825404`, 2.299180100054544}, {
                 3.047075167056113, 2.7096635269133085`}}], 
                
                ArrowBox[{{3.2558740995825404`, 2.299180100054544}, {
                 3.168138093800108, 2.1047183043495687`}}], 
                ArrowBox[{{2.639358157050337, 2.58173400028977}, {
                 2.8945169498586005`, 2.3278299921410754`}}], 
                ArrowBox[
                 
                 BezierCurveBox[{{2.639358157050337, 2.58173400028977}, {
                  2.411252020272176, 2.4914499007369013`}, {2.031705016574954,
                   2.351729815828958}, {1.6521580128777318`, 
                  2.212009730921015}, {1.2089139891580554`, 
                  1.7577768430581273`}}, SplineDegree -> 2]], 
                
                ArrowBox[{{2.639358157050337, 2.58173400028977}, {
                 2.885749972239753, 2.5908377725505027`}}], 
                
                ArrowBox[{{2.639358157050337, 2.58173400028977}, {
                 2.6381209230278255`, 2.8595746735201546`}}], 
                
                ArrowBox[{{1.2089139891580554`, 1.7577768430581273`}, {
                 1.4317409703870636`, 1.6436267795397013`}}], 
                
                ArrowBox[{{1.2089139891580554`, 1.7577768430581273`}, {
                 0.8641894439884323, 1.729865325243864}}], 
                
                ArrowBox[{{1.2089139891580554`, 1.7577768430581273`}, {
                 1.0565798231281445`, 1.9692461660448652`}}], 
                
                ArrowBox[{{1.5709661391269687`, 2.6898873166852377`}, {
                 1.659602271005506, 2.5661590599428186`}}], 
                ArrowBox[
                 
                 BezierCurveBox[{{1.5709661391269687`, 2.6898873166852377`}, {
                  1.294215389986469, 2.2322515466569253`}, {1.076487091221816,
                   2.1386742526597917`}, {0.8587587924571634, 
                  2.0450969586626577`}, {0., 1.7593590303995787`}}, 
                  SplineDegree -> 2]], 
                ArrowBox[
                 
                 BezierCurveBox[{{1.5709661391269687`, 2.6898873166852377`}, {
                  2.1626772832503267`, 2.251474675317372}, {2.608100532649501,
                   1.9495263896002226`}, {3.053523782048675, 
                  1.647578103883073}, {3.8229397888607277`, 
                  1.5719264518511218`}}, SplineDegree -> 2]], 
                ArrowBox[
                 
                 BezierCurveBox[{{1.4077729862113624`, 1.3627094940221658`}, {
                  2.0170319913592767`, 1.745726362640179}, {2.371836510866026,
                   1.9961473546963213`}, {2.7266410303727757`, 
                  2.246568346752464}, {3.2558740995825404`, 
                  2.299180100054544}}, SplineDegree -> 2]], 
                
                ArrowBox[{{1.4077729862113624`, 1.3627094940221658`}, {
                 1.2844991781478532`, 1.3776207935937406`}}], 
                
                ArrowBox[{{1.2844991781478532`, 1.3776207935937406`}, {
                 1.4872871787099529`, 1.2260793094448104`}}], 
                
                ArrowBox[{{3.153603273248364, 2.9306699008070343`}, {
                 2.885749972239753, 2.5908377725505027`}}], 
                
                ArrowBox[{{3.153603273248364, 2.9306699008070343`}, {
                 3.247766799018454, 2.714317113377208}}], 
                
                ArrowBox[{{1.7262385797428599`, 2.90059760515629}, {
                 1.659602271005506, 2.5661590599428186`}}], 
                ArrowBox[
                 
                 BezierCurveBox[{{1.7262385797428599`, 2.90059760515629}, {
                  2.0410413545919086`, 2.5326131655638444`}, {
                  2.3373922908159024`, 2.5534080863295934`}, {
                  2.6337432270398957`, 2.5742030070953428`}, {
                  2.7546226575755544`, 2.4229995292827673`}}, SplineDegree -> 
                  2]], 
                
                ArrowBox[{{1.7262385797428599`, 2.90059760515629}, {
                 1.5016908230129027`, 3.1310962489087952`}}], 
                
                ArrowBox[{{1.659602271005506, 2.5661590599428186`}, {
                 1.7765265466405027`, 2.4779315488363594`}}], 
                
                ArrowBox[{{1.659602271005506, 2.5661590599428186`}, {
                 1.6936108638638805`, 2.443351346309686}}], 
                ArrowBox[
                 
                 BezierCurveBox[{{1.659602271005506, 2.5661590599428186`}, {
                  1.838338177911715, 1.9476339047721272`}, {2.064794489679235,
                   1.5108311399139298`}, {2.2912508014467545`, 
                  1.0740283750557325`}, {2.362186592080374, 
                  0.5244415513150742}}, SplineDegree -> 2]], 
                ArrowBox[
                 
                 BezierCurveBox[{{1.5601588770566857`, 1.6125675816540839`}, {
                  1.228389712547824, 1.5949583654878405`}, {
                  1.2015815440944655`, 1.6255542611224878`}, {
                  1.1747733756411067`, 1.6561501567571353`}, {
                  1.4317409703870636`, 1.6436267795397013`}}, SplineDegree -> 
                  2]], 
                
                ArrowBox[{{1.5601588770566857`, 1.6125675816540839`}, {
                 1.2844991781478532`, 1.3776207935937406`}}], 
                ArrowBox[
                 
                 BezierCurveBox[{{1.5601588770566857`, 1.6125675816540839`}, {
                  2.0170319913592767`, 1.745726362640179}, {2.371836510866026,
                   1.9961473546963213`}, {2.7266410303727757`, 
                  2.246568346752464}, {2.6172375808234727`, 
                  3.252616902127802}}, SplineDegree -> 2]], 
                
                ArrowBox[{{1.5601588770566857`, 1.6125675816540839`}, {
                 1.7892970888888562`, 1.3839977852843286`}}], 
                ArrowBox[
                 
                 BezierCurveBox[{{1.5601588770566857`, 1.6125675816540839`}, {
                  1.5336830797576235`, 1.6957096003879502`}, {
                  1.5436431316319277`, 1.9720957552264533`}, {
                  1.5536031835062318`, 2.2484819100649562`}, {
                  1.4936031083055394`, 2.3466448592302127`}}, SplineDegree -> 
                  2]], 
                ArrowBox[
                 
                 BezierCurveBox[{{2.75647819250503, 2.6658384200680523`}, {
                  2.6804205208083554`, 2.024931712359108}, {
                  2.4620411094771133`, 1.623380895826643}, {
                  2.2436616981458712`, 1.2218300792941776`}, {
                  2.081256109579293, 0.8765002427881036}}, SplineDegree -> 
                  2]], 
                
                ArrowBox[{{2.75647819250503, 2.6658384200680523`}, {
                 2.941964292630955, 2.3750910006693067`}}], 
                
                ArrowBox[{{2.75647819250503, 2.6658384200680523`}, {
                 2.7949307783187454`, 2.7932962145942843`}}], 
                
                ArrowBox[{{1.7765265466405027`, 2.4779315488363594`}, {
                 1.9012568425562415`, 2.6362095049953833`}}], 
                ArrowBox[
                 
                 BezierCurveBox[{{1.7765265466405027`, 2.4779315488363594`}, {
                  1.5536031835062318`, 2.2484819100649562`}, {
                  1.5436431316319277`, 1.9720957552264533`}, {
                  1.5336830797576235`, 1.6957096003879502`}, {
                  1.4872871787099529`, 1.2260793094448104`}}, SplineDegree -> 
                  2]], 
                
                ArrowBox[{{1.8659877072932964`, 0.3556277108148027}, {
                 2.008826120159008, 0.5446306364511517}}], 
                ArrowBox[
                 
                 BezierCurveBox[{{1.8659877072932964`, 0.3556277108148027}, {
                  2.064021962687497, 0.5471129920335013}, {2.208578974914188, 
                  0.5736468787025666}, {2.3531359871408792`, 
                  0.600180765371632}, {2.4769053868232604`, 
                  0.7462115076005172}}, SplineDegree -> 2]], 
                
                ArrowBox[{{1.8659877072932964`, 0.3556277108148027}, {
                 1.6322141299670254`, 0.32782518429781415`}}], 
                ArrowBox[
                 
                 BezierCurveBox[{{2.7105021551043778`, 0.9070036280291717}, {
                  2.787798387597087, 0.8324265149818357}, {
                  3.0035027884902825`, 0.9646248618534529}, {
                  3.219207189383478, 1.0968232087250698`}, {
                  3.2189169574477594`, 1.304585972526182}}, SplineDegree -> 
                  2]], 
                ArrowBox[
                 
                 BezierCurveBox[{{2.7105021551043778`, 0.9070036280291717}, {
                  2.81067077425526, 1.1280611434185157`}, {
                  2.9159297206102837`, 1.5703238351934834`}, {
                  3.021188666965308, 2.012586526968451}, {2.941964292630955, 
                  2.3750910006693067`}}, SplineDegree -> 2]], 
                
                ArrowBox[{{2.7105021551043778`, 0.9070036280291717}, {
                 2.4769053868232604`, 0.7462115076005172}}], 
                
                ArrowBox[{{2.7105021551043778`, 0.9070036280291717}, {
                 2.897487935564712, 0.5873431303720924}}], 
                
                ArrowBox[{{2.941964292630955, 2.3750910006693067`}, {
                 3.0168262991530046`, 2.203184761092473}}], 
                ArrowBox[
                 
                 BezierCurveBox[{{2.941964292630955, 2.3750910006693067`}, {
                  2.411252020272176, 2.4914499007369013`}, {2.031705016574954,
                   2.351729815828958}, {1.6521580128777318`, 
                  2.212009730921015}, {1.0589020370890991`, 
                  2.36533463835313}}, SplineDegree -> 2]], 
                
                ArrowBox[{{1.7892970888888562`, 1.3839977852843286`}, {
                 2.120819147085375, 1.393376825005813}}], 
                ArrowBox[
                 
                 BezierCurveBox[{{1.7892970888888562`, 1.3839977852843286`}, {
                  1.8687814253183264`, 1.155710264596793}, {2.099270716837248,
                   1.0063819818290165`}, {2.32976000835617, 
                  0.8570536990612403}, {2.4769053868232604`, 
                  0.7462115076005172}}, SplineDegree -> 2]], 
                ArrowBox[
                 
                 BezierCurveBox[{{3.2191147448421815`, 2.591814620447461}, {
                  3.1935126739776463`, 2.0923888213052}, {3.310866474508976, 
                  1.831789805678353}, {3.4282202750403057`, 
                  1.5711907900515059`}, {3.2189169574477594`, 
                  1.304585972526182}}, SplineDegree -> 2]], 
                
                ArrowBox[{{3.2191147448421815`, 2.591814620447461}, {
                 2.941964292630955, 2.3750910006693067`}}], 
                ArrowBox[
                 
                 BezierCurveBox[{{1.4936031083055394`, 2.3466448592302127`}, {
                  2.0410413545919086`, 2.5326131655638444`}, {
                  2.3373922908159024`, 2.5534080863295934`}, {
                  2.6337432270398957`, 2.5742030070953428`}, {
                  3.047075167056113, 2.7096635269133085`}}, SplineDegree -> 
                  2]], 
                
                ArrowBox[{{1.4936031083055394`, 2.3466448592302127`}, {
                 1.7765265466405027`, 2.4779315488363594`}}], 
                ArrowBox[
                 
                 BezierCurveBox[{{1.4936031083055394`, 2.3466448592302127`}, {
                  1.637616326493326, 1.821540005334698}, {1.6746117908322624`,
                   1.413695954789092}, {1.711607255171199, 
                  1.0058519042434861`}, {1.7002593872780785`, 
                  0.7583610740868956}}, SplineDegree -> 2]], 
                
                ArrowBox[{{1.4936031083055394`, 2.3466448592302127`}, {
                 1.4824324635631985`, 2.1437996026384694`}}], 
                
                ArrowBox[{{1.4936031083055394`, 2.3466448592302127`}, {
                 1.1780911121805178`, 2.656162393253947}}], 
                
                ArrowBox[{{1.7002593872780785`, 0.7583610740868956}, {
                 2.081256109579293, 0.8765002427881036}}], 
                
                ArrowBox[{{1.7002593872780785`, 0.7583610740868956}, {
                 1.5770143574601727`, 0.6524818163347639}}], 
                
                ArrowBox[{{2.696123673956549, 2.9770171690697973`}, {
                 2.6172375808234727`, 3.252616902127802}}], 
                
                ArrowBox[{{2.696123673956549, 2.9770171690697973`}, {
                 2.75647819250503, 2.6658384200680523`}}], 
                ArrowBox[
                 
                 BezierCurveBox[{{2.696123673956549, 2.9770171690697973`}, {
                  2.411252020272176, 2.4914499007369013`}, {2.031705016574954,
                   2.351729815828958}, {1.6521580128777318`, 
                  2.212009730921015}, {1.0589020370890991`, 
                  2.36533463835313}}, SplineDegree -> 2]], 
                
                ArrowBox[{{1.4872871787099529`, 1.2260793094448104`}, {
                 1.4077729862113624`, 1.3627094940221658`}}], 
                ArrowBox[
                 
                 BezierCurveBox[{{1.4872871787099529`, 1.2260793094448104`}, {
                  1.5336830797576235`, 1.6957096003879502`}, {
                  1.5436431316319277`, 1.9720957552264533`}, {
                  1.5536031835062318`, 2.2484819100649562`}, {
                  1.4824324635631985`, 2.1437996026384694`}}, SplineDegree -> 
                  2]], 
                ArrowBox[
                 
                 BezierCurveBox[{{1.4872871787099529`, 1.2260793094448104`}, {
                  1.7104439007428545`, 1.1182909487320065`}, {
                  1.748928030816812, 0.9091933546397499}, {
                  1.7874121608907694`, 0.7000957605474933}, {
                  1.913334641285302, 0.7078373027089306}}, SplineDegree -> 
                  2]], 
                ArrowBox[
                 
                 BezierCurveBox[{{1.4872871787099529`, 1.2260793094448104`}, {
                  2.347917726246338, 1.3009371077712735`}, {
                  2.7861936281991087`, 1.2642632290570681`}, {
                  3.224469530151879, 1.2275893503428628`}, {4.078951513179973,
                   0.9824965843683116}}, SplineDegree -> 2]], 
                ArrowBox[
                 
                 BezierCurveBox[{{1.4872871787099529`, 1.2260793094448104`}, {
                  1.8687814253183264`, 1.155710264596793}, {2.099270716837248,
                   1.0063819818290165`}, {2.32976000835617, 
                  0.8570536990612403}, {2.6435932129269224`, 
                  0.6692393249864104}}, SplineDegree -> 2]], 
                ArrowBox[
                 
                 BezierCurveBox[{{0.8641894439884323, 1.729865325243864}, {
                  0.751376302364705, 1.436555813464101}, {
                  0.48648832038562073`, 1.2674652116454612`}}]], 
                
                ArrowBox[{{2.860218741205732, 0.06188429627397407}, {
                 2.728134301269645, 0.547410220538946}}], 
                
                ArrowBox[{{2.728134301269645, 0.547410220538946}, {
                 2.479471842206366, 0.5332217204409468}}], 
                
                ArrowBox[{{2.728134301269645, 0.547410220538946}, {
                 2.6435932129269224`, 0.6692393249864104}}], 
                
                ArrowBox[{{3.6879572559236125`, 0.7806372519986963}, {
                 3.7188573339539, 0.5590467057909552}}], 
                
                ArrowBox[{{3.7188573339539, 0.5590467057909552}, {
                 3.863785160828577, 0.7483996524154757}}], 
                ArrowBox[
                 
                 BezierCurveBox[{{2.120819147085375, 1.393376825005813}, {
                  2.0170319913592767`, 1.745726362640179}, {2.371836510866026,
                   1.9961473546963213`}, {2.7266410303727757`, 
                  2.246568346752464}, {3.0168262991530046`, 
                  2.203184761092473}}, SplineDegree -> 2]], 
                ArrowBox[
                 
                 BezierCurveBox[{{2.120819147085375, 1.393376825005813}, {
                  1.7104439007428545`, 1.1182909487320065`}, {
                  1.748928030816812, 0.9091933546397499}, {
                  1.7874121608907694`, 0.7000957605474933}, {
                  2.008826120159008, 0.5446306364511517}}, SplineDegree -> 
                  2]], 
                ArrowBox[
                 
                 BezierCurveBox[{{2.120819147085375, 1.393376825005813}, {
                  2.347917726246338, 1.3009371077712735`}, {
                  2.7861936281991087`, 1.2642632290570681`}, {
                  3.224469530151879, 1.2275893503428628`}, {
                  3.2476632785575363`, 1.0728745873603875`}}, SplineDegree -> 
                  2]], 
                
                ArrowBox[{{2.7546226575755544`, 2.4229995292827673`}, {
                 2.639358157050337, 2.58173400028977}}], 
                
                ArrowBox[{{2.7546226575755544`, 2.4229995292827673`}, {
                 2.885749972239753, 2.5908377725505027`}}], 
                ArrowBox[
                 
                 BezierCurveBox[{{2.7546226575755544`, 2.4229995292827673`}, {
                  2.6337432270398957`, 2.5742030070953428`}, {
                  2.3373922908159024`, 2.5534080863295934`}, {
                  2.0410413545919086`, 2.5326131655638444`}, {
                  1.7765265466405027`, 2.4779315488363594`}}, SplineDegree -> 
                  2]], 
                
                ArrowBox[{{2.7546226575755544`, 2.4229995292827673`}, {
                 2.941964292630955, 2.3750910006693067`}}], 
                ArrowBox[
                 
                 BezierCurveBox[{{2.7546226575755544`, 2.4229995292827673`}, {
                  3.021188666965308, 2.012586526968451}, {2.9159297206102837`,
                   1.5703238351934834`}, {2.81067077425526, 
                  1.1280611434185157`}, {2.728134301269645, 
                  0.547410220538946}}, SplineDegree -> 2]], 
                
                ArrowBox[{{2.7546226575755544`, 2.4229995292827673`}, {
                 3.0268882963975825`, 2.501500726277051}}], 
                ArrowBox[
                 
                 BezierCurveBox[{{2.479471842206366, 0.5332217204409468}, {
                  2.126662012046929, 0.8482328451065787}, {
                  1.8324948069504872`, 1.1676340543351469`}, {
                  1.5383276018540455`, 1.487035263563715}, {
                  1.0565798231281445`, 1.9692461660448652`}}, SplineDegree -> 
                  2]], 
                
                ArrowBox[{{2.479471842206366, 0.5332217204409468}, {
                 2.4769053868232604`, 0.7462115076005172}}], 
                
                ArrowBox[{{2.479471842206366, 0.5332217204409468}, {
                 2.508013277206207, 0.2397169293763568}}], 
                ArrowBox[
                 
                 BezierCurveBox[{{2.7717835101136528`, 2.5088908622570987`}, {
                  2.6804205208083554`, 2.024931712359108}, {
                  2.4620411094771133`, 1.623380895826643}, {
                  2.2436616981458712`, 1.2218300792941776`}, {
                  2.081256109579293, 0.8765002427881036}}, SplineDegree -> 
                  2]], 
                
                ArrowBox[{{2.7717835101136528`, 2.5088908622570987`}, {
                 2.7546226575755544`, 2.4229995292827673`}}], 
                
                ArrowBox[{{2.7717835101136528`, 2.5088908622570987`}, {
                 3.247766799018454, 2.714317113377208}}], 
                
                ArrowBox[{{3.247766799018454, 2.714317113377208}, {
                 3.2191147448421815`, 2.591814620447461}}], 
                
                ArrowBox[{{3.247766799018454, 2.714317113377208}, {
                 3.510120753886917, 2.9615258909695346`}}], 
                ArrowBox[
                 
                 BezierCurveBox[{{1.4824324635631985`, 2.1437996026384694`}, {
                  1.294215389986469, 2.2322515466569253`}, {1.076487091221816,
                   2.1386742526597917`}, {0.8587587924571634, 
                  2.0450969586626577`}, {0.8641894439884323, 
                  1.729865325243864}}, SplineDegree -> 2]], 
                ArrowBox[
                 
                 BezierCurveBox[{{1.4824324635631985`, 2.1437996026384694`}, {
                  1.637616326493326, 1.821540005334698}, {1.6746117908322624`,
                   1.413695954789092}, {1.711607255171199, 
                  1.0058519042434861`}, {1.913334641285302, 
                  0.7078373027089306}}, SplineDegree -> 2]], 
                
                ArrowBox[{{1.4824324635631985`, 2.1437996026384694`}, {
                 1.8258270145944309`, 2.1977077057722294`}}], 
                ArrowBox[
                 
                 BezierCurveBox[{{1.4824324635631985`, 2.1437996026384694`}, {
                  1.294215389986469, 2.2322515466569253`}, {1.076487091221816,
                   2.1386742526597917`}, {0.8587587924571634, 
                  2.0450969586626577`}, {1.0589020370890991`, 
                  2.36533463835313}}, SplineDegree -> 2]], 
                ArrowBox[
                 
                 BezierCurveBox[{{1.913334641285302, 0.7078373027089306}, {
                  2.2436616981458712`, 1.2218300792941776`}, {
                  2.4620411094771133`, 1.623380895826643}, {
                  2.6804205208083554`, 2.024931712359108}, {3.168138093800108,
                   2.1047183043495687`}}, SplineDegree -> 2]], 
                ArrowBox[
                 
                 BezierCurveBox[{{1.913334641285302, 0.7078373027089306}, {
                  2.3492618236780314`, 0.746788299517906}, {
                  2.7442381089012415`, 0.8472558914549363}, {
                  3.1392143941244517`, 0.9477234833919665}, {3.7188573339539, 
                  0.5590467057909552}}, SplineDegree -> 2]], 
                
                ArrowBox[{{1.913334641285302, 0.7078373027089306}, {
                 1.5770143574601727`, 0.6524818163347639}}], 
                
                ArrowBox[{{2.979741943261697, 2.8525353858563727`}, {
                 3.2191147448421815`, 2.591814620447461}}], 
                
                ArrowBox[{{2.979741943261697, 2.8525353858563727`}, {
                 2.696123673956549, 2.9770171690697973`}}], 
                
                ArrowBox[{{2.979741943261697, 2.8525353858563727`}, {
                 2.7949307783187454`, 2.7932962145942843`}}], 
                
                ArrowBox[{{2.7949307783187454`, 2.7932962145942843`}, {
                 2.7546226575755544`, 2.4229995292827673`}}], 
                
                ArrowBox[{{1.8258270145944309`, 2.1977077057722294`}, {
                 1.6936108638638805`, 2.443351346309686}}], 
                
                ArrowBox[{{1.6936108638638805`, 2.443351346309686}, {
                 1.9012568425562415`, 2.6362095049953833`}}], 
                ArrowBox[
                 
                 BezierCurveBox[{{1.5016908230129027`, 3.1310962489087952`}, {
                  1.5536031835062318`, 2.2484819100649562`}, {
                  1.5436431316319277`, 1.9720957552264533`}, {
                  1.5336830797576235`, 1.6957096003879502`}, {
                  1.5601588770566857`, 1.6125675816540839`}}, SplineDegree -> 
                  2]], 
                ArrowBox[
                 
                 BezierCurveBox[{{3.6616215045764386`, 1.5173752431572736`}, {
                  3.224469530151879, 1.2275893503428628`}, {
                  2.7861936281991087`, 1.2642632290570681`}, {
                  2.347917726246338, 1.3009371077712735`}, {2.120819147085375,
                   1.393376825005813}}, SplineDegree -> 2]], 
                ArrowBox[
                 
                 BezierCurveBox[{{3.6616215045764386`, 1.5173752431572736`}, {
                  3.4282202750403057`, 1.5711907900515059`}, {
                  3.310866474508976, 1.831789805678353}, {3.1935126739776463`,
                   2.0923888213052}, {2.7717835101136528`, 
                  2.5088908622570987`}}, SplineDegree -> 2]], 
                
                ArrowBox[{{3.6616215045764386`, 1.5173752431572736`}, {
                 3.639524520551916, 1.423984925743525}}], 
                ArrowBox[
                 
                 BezierCurveBox[{{3.6616215045764386`, 1.5173752431572736`}, {
                  3.219207189383478, 1.0968232087250698`}, {
                  3.0035027884902825`, 0.9646248618534529}, {
                  2.787798387597087, 0.8324265149818357}, {2.362186592080374, 
                  0.5244415513150742}}, SplineDegree -> 2]], 
                ArrowBox[
                 
                 BezierCurveBox[{{3.639524520551916, 1.423984925743525}, {
                  3.4282202750403057`, 1.5711907900515059`}, {
                  3.310866474508976, 1.831789805678353}, {3.1935126739776463`,
                   2.0923888213052}, {3.0168262991530046`, 
                  2.203184761092473}}, SplineDegree -> 2]], 
                
                ArrowBox[{{2.4769053868232604`, 0.7462115076005172}, {
                 2.362186592080374, 0.5244415513150742}}], 
                
                ArrowBox[{{4.078951513179973, 0.9824965843683116}, {
                 3.863785160828577, 0.7483996524154757}}], 
                ArrowBox[
                 
                 BezierCurveBox[{{4.078951513179973, 0.9824965843683116}, {
                  3.4282202750403057`, 1.5711907900515059`}, {
                  3.310866474508976, 1.831789805678353}, {3.1935126739776463`,
                   2.0923888213052}, {3.168138093800108, 
                  2.1047183043495687`}}, SplineDegree -> 2]], 
                ArrowBox[
                 
                 BezierCurveBox[{{3.9046185181312127`, 1.0791172991906632`}, {
                  3.90939819980242, 1.2893649853150646`}, {4.069115161332321, 
                  1.4206039932014407`}, {4.20925178761289, 
                  1.417436842811863}, {4.359829095244178, 
                  1.0724185712790484`}, {4.266857865980218, 
                  0.9675154950799296}, {4.062024164931119, 
                  0.9396526182386514}, {3.9046185181312127`, 
                  1.0791172991906632`}}, SplineDegree -> 7]], 
                
                ArrowBox[{{3.9046185181312127`, 1.0791172991906632`}, {
                 3.6312554533642967`, 1.276311392234716}}], 
                
                ArrowBox[{{3.6312554533642967`, 1.276311392234716}, {
                 3.3698316224333045`, 1.3648023304164223`}}], 
                
                ArrowBox[{{3.6312554533642967`, 1.276311392234716}, {
                 3.639524520551916, 1.423984925743525}}], 
                ArrowBox[
                 
                 BezierCurveBox[{{3.6312554533642967`, 1.276311392234716}, {
                  3.4282202750403057`, 1.5711907900515059`}, {
                  3.310866474508976, 1.831789805678353}, {3.1935126739776463`,
                   2.0923888213052}, {3.0268882963975825`, 
                  2.501500726277051}}, SplineDegree -> 2]], 
                ArrowBox[
                 
                 BezierCurveBox[{{3.4024975480581325`, 1.0360003985902304`}, {
                  3.1392143941244517`, 0.9477234833919665}, {
                  2.7442381089012415`, 0.8472558914549363}, {
                  2.3492618236780314`, 0.746788299517906}, {2.008826120159008,
                   0.5446306364511517}}, SplineDegree -> 2]], 
                
                ArrowBox[{{3.4024975480581325`, 1.0360003985902304`}, {
                 3.6879572559236125`, 0.7806372519986963}}], 
                
                ArrowBox[{{2.6435932129269224`, 0.6692393249864104}, {
                 2.7105021551043778`, 0.9070036280291717}}], 
                
                ArrowBox[{{2.6435932129269224`, 0.6692393249864104}, {
                 2.4769053868232604`, 0.7462115076005172}}], 
                
                ArrowBox[{{2.6829214703562427`, 1.1475183499011745`}, {
                 2.7105021551043778`, 0.9070036280291717}}], 
                ArrowBox[
                 
                 BezierCurveBox[{{2.6829214703562427`, 1.1475183499011745`}, {
                  2.81067077425526, 1.1280611434185157`}, {
                  2.9159297206102837`, 1.5703238351934834`}, {
                  3.021188666965308, 2.012586526968451}, {3.247766799018454, 
                  2.714317113377208}}, SplineDegree -> 2]], 
                ArrowBox[
                 
                 BezierCurveBox[{{2.6829214703562427`, 1.1475183499011745`}, {
                  2.2912508014467545`, 1.0740283750557325`}, {
                  2.064794489679235, 1.5108311399139298`}, {1.838338177911715,
                   1.9476339047721272`}, {1.6936108638638805`, 
                  2.443351346309686}}, SplineDegree -> 2]], 
                
                ArrowBox[{{0., 1.7593590303995787`}, {0.1960871848582526, 
                 1.4526685999726807`}}], 
                
                ArrowBox[{{3.2476632785575363`, 1.0728745873603875`}, {
                 3.2189169574477594`, 1.304585972526182}}], 
                
                ArrowBox[{{3.2476632785575363`, 1.0728745873603875`}, {
                 3.4043299334098798`, 0.6350503052987047}}], 
                
                ArrowBox[{{3.343942158688346, 2.3809192251939044`}, {
                 2.885749972239753, 2.5908377725505027`}}], 
                
                ArrowBox[{{1.83402441705881, 0.15113954727774104`}, {
                 1.3226083806916278`, 0.1935758469765163}}], 
                
                ArrowBox[{{1.3226083806916278`, 0.1935758469765163}, {
                 1.2857951610028178`, 0.5613116475528517}}], 
                
                ArrowBox[{{3.4184546835413303`, 2.658053342032937}, {
                 2.941964292630955, 2.3750910006693067`}}], 
                ArrowBox[{{1.0589020370890991`, 2.36533463835313}, {
                 1.0565798231281445`, 1.9692461660448652`}}], 
                
                ArrowBox[{{3.5177675418365486`, 1.1068835324227273`}, {
                 3.4024975480581325`, 1.0360003985902304`}}], 
                
                ArrowBox[{{3.5177675418365486`, 1.1068835324227273`}, {
                 3.424196308805824, 0.8651034511066054}}], 
                ArrowBox[
                 
                 BezierCurveBox[{{1.55552811144987, 0.2205265602056279}, {
                  1.7288811993415338`, 0.45711926157705735`}, {
                  2.008826120159008, 0.5446306364511517}}]], 
                ArrowBox[
                 
                 BezierCurveBox[{{1.55552811144987, 0.2205265602056279}, {
                  1.7874121608907694`, 0.7000957605474933}, {
                  1.748928030816812, 0.9091933546397499}, {
                  1.7104439007428545`, 1.1182909487320065`}, {
                  1.4077729862113624`, 1.3627094940221658`}}, SplineDegree -> 
                  2]], 
                
                ArrowBox[{{1.55552811144987, 0.2205265602056279}, {
                 1.7752671079791367`, 0.470509225953319}}], 
                ArrowBox[
                 
                 BezierCurveBox[{{2.897487935564712, 0.5873431303720924}, {
                  2.81067077425526, 1.1280611434185157`}, {
                  2.9159297206102837`, 1.5703238351934834`}, {
                  3.021188666965308, 2.012586526968451}, {3.343942158688346, 
                  2.3809192251939044`}}, SplineDegree -> 2]], 
                
                ArrowBox[{{2.897487935564712, 0.5873431303720924}, {
                 2.648658069975757, 0.39873378586359465`}}], 
                
                ArrowBox[{{2.648658069975757, 0.39873378586359465`}, {
                 2.6435932129269224`, 0.6692393249864104}}], 
                ArrowBox[
                 
                 BezierCurveBox[{{2.508013277206207, 0.2397169293763568}, {
                  2.2912508014467545`, 1.0740283750557325`}, {
                  2.064794489679235, 1.5108311399139298`}, {1.838338177911715,
                   1.9476339047721272`}, {1.4824324635631985`, 
                  2.1437996026384694`}}, SplineDegree -> 2]], 
                ArrowBox[
                 
                 BezierCurveBox[{{2.508013277206207, 0.2397169293763568}, {
                  2.81067077425526, 1.1280611434185157`}, {
                  2.9159297206102837`, 1.5703238351934834`}, {
                  3.021188666965308, 2.012586526968451}, {3.343942158688346, 
                  2.3809192251939044`}}, SplineDegree -> 2]], 
                ArrowBox[
                 
                 BezierCurveBox[{{2.362186592080374, 0.5244415513150742}, {
                  2.3531359871408792`, 0.600180765371632}, {2.208578974914188,
                   0.5736468787025666}, {2.064021962687497, 
                  0.5471129920335013}, {2.008826120159008, 
                  0.5446306364511517}}, SplineDegree -> 2]], 
                ArrowBox[
                 
                 BezierCurveBox[{{2.362186592080374, 0.5244415513150742}, {
                  2.126662012046929, 0.8482328451065787}, {
                  1.8324948069504872`, 1.1676340543351469`}, {
                  1.5383276018540455`, 1.487035263563715}, {
                  1.4317409703870636`, 1.6436267795397013`}}, SplineDegree -> 
                  2]], 
                ArrowBox[
                 
                 BezierCurveBox[{{2.362186592080374, 0.5244415513150742}, {
                  2.3531359871408792`, 0.600180765371632}, {2.208578974914188,
                   0.5736468787025666}, {2.064021962687497, 
                  0.5471129920335013}, {1.8659877072932964`, 
                  0.3556277108148027}}, SplineDegree -> 2]], 
                
                ArrowBox[{{2.362186592080374, 0.5244415513150742}, {
                 2.648658069975757, 0.39873378586359465`}}], 
                ArrowBox[
                 
                 BezierCurveBox[{{1.6322141299670254`, 
                  0.32782518429781415`}, {2.3492618236780314`, 
                  0.746788299517906}, {2.7442381089012415`, 
                  0.8472558914549363}, {3.1392143941244517`, 
                  0.9477234833919665}, {3.3698316224333045`, 
                  1.3648023304164223`}}, SplineDegree -> 2]], 
                ArrowBox[
                 
                 BezierCurveBox[{{1.6322141299670254`, 
                  0.32782518429781415`}, {1.711607255171199, 
                  1.0058519042434861`}, {1.6746117908322624`, 
                  1.413695954789092}, {1.637616326493326, 
                  1.821540005334698}, {1.8258270145944309`, 
                  2.1977077057722294`}}, SplineDegree -> 2]], 
                
                ArrowBox[{{1.6322141299670254`, 0.32782518429781415`}, {
                 1.55552811144987, 0.2205265602056279}}], 
                ArrowBox[
                 
                 BezierCurveBox[{{1.6322141299670254`, 
                  0.32782518429781415`}, {1.3061787728066507`, 
                  0.7115815687819482}, {1.1533529001283798`, 
                  0.9785947216385636}, {1.000527027450109, 
                  1.2456078744951788`}, {0.48648832038562073`, 
                  1.2674652116454612`}}, SplineDegree -> 2]], 
                ArrowBox[
                 
                 BezierCurveBox[{{0.48648832038562073`, 
                  1.2674652116454612`}, {0.5993014620093488, 
                  1.5607747234214011`}, {0.8641894439884323, 
                  1.729865325243864}}]], 
                
                ArrowBox[{{0.48648832038562073`, 1.2674652116454612`}, {
                 0.1960871848582526, 1.4526685999726807`}}], 
                ArrowBox[
                 
                 BezierCurveBox[{{0.48648832038562073`, 
                  1.2674652116454612`}, {1.794907056856041, 
                  1.3911927256604393`}, {2.3624956923259255`, 
                  1.2117839661631908`}, {2.9300843277958104`, 
                  1.0323752066659424`}, {3.4043299334098798`, 
                  0.6350503052987047}}, SplineDegree -> 2]], 
                ArrowBox[
                 
                 BezierCurveBox[{{3.424196308805824, 0.8651034511066054}, {
                  3.219207189383478, 1.0968232087250698`}, {
                  3.0035027884902825`, 0.9646248618534529}, {
                  2.787798387597087, 0.8324265149818357}, {
                  2.6435932129269224`, 0.6692393249864104}}, SplineDegree -> 
                  2]], 
                
                ArrowBox[{{3.424196308805824, 0.8651034511066054}, {
                 3.2476632785575363`, 1.0728745873603875`}}], 
                
                ArrowBox[{{1.5194871010494955`, 0.46597995469881126`}, {
                 1.8659877072932964`, 0.3556277108148027}}], 
                
                ArrowBox[{{1.5194871010494955`, 0.46597995469881126`}, {
                 1.7002593872780785`, 0.7583610740868956}}], 
                
                ArrowBox[{{1.7752671079791367`, 0.470509225953319}, {
                 2.008826120159008, 0.5446306364511517}}], 
                
                ArrowBox[{{1.7752671079791367`, 0.470509225953319}, {
                 1.7002593872780785`, 0.7583610740868956}}], 
                ArrowBox[
                 
                 BezierCurveBox[{{1.7752671079791367`, 0.470509225953319}, {
                  2.064021962687497, 0.5471129920335013}, {2.208578974914188, 
                  0.5736468787025666}, {2.3531359871408792`, 
                  0.600180765371632}, {2.6435932129269224`, 
                  0.6692393249864104}}, SplineDegree -> 2]], 
                
                ArrowBox[{{1.7873130030936033`, 3.009407453920633}, {
                 1.9012568425562415`, 2.6362095049953833`}}], 
                
                ArrowBox[{{1.7873130030936033`, 3.009407453920633}, {
                 1.7262385797428599`, 2.90059760515629}}], 
                ArrowBox[
                 
                 BezierCurveBox[{{1.2857951610028178`, 0.5613116475528517}, {
                  1.3061787728066507`, 0.7115815687819482}, {
                  1.1533529001283798`, 0.9785947216385636}, {
                  1.000527027450109, 1.2456078744951788`}, {
                  1.2089139891580554`, 1.7577768430581273`}}, SplineDegree -> 
                  2]], 
                
                ArrowBox[{{1.2857951610028178`, 0.5613116475528517}, {
                 1.7002593872780785`, 0.7583610740868956}}], 
                
                ArrowBox[{{3.9534012472606035`, 0.33446155498674246`}, {
                 3.7188573339539, 0.5590467057909552}}], 
                
                ArrowBox[{{0.6956755051279591, 2.0931413686684124`}, {
                 1.0565798231281445`, 1.9692461660448652`}}], 
                
                ArrowBox[{{0.9502368849456799, 1.5161573580523022`}, {
                 1.5601588770566857`, 1.6125675816540839`}}], 
                ArrowBox[
                 
                 BezierCurveBox[{{0.9502368849456799, 1.5161573580523022`}, {
                  1.228389712547824, 1.5949583654878405`}, {
                  1.2015815440944655`, 1.6255542611224878`}, {
                  1.1747733756411067`, 1.6561501567571353`}, {
                  0.8641894439884323, 1.729865325243864}}, SplineDegree -> 
                  2]], 
                
                ArrowBox[{{1.7637259733857853`, 1.8007124642878996`}, {
                 1.4317409703870636`, 1.6436267795397013`}}], 
                ArrowBox[
                 
                 BezierCurveBox[{{1.7637259733857853`, 1.8007124642878996`}, {
                  1.6521580128777318`, 2.212009730921015}, {2.031705016574954,
                   2.351729815828958}, {2.411252020272176, 
                  2.4914499007369013`}, {2.885749972239753, 
                  2.5908377725505027`}}, SplineDegree -> 2]], 
                ArrowBox[
                 
                 BezierCurveBox[{{1.7637259733857853`, 1.8007124642878996`}, {
                  1.794907056856041, 1.3911927256604393`}, {
                  2.3624956923259255`, 1.2117839661631908`}, {
                  2.9300843277958104`, 1.0323752066659424`}, {3.7188573339539,
                   0.5590467057909552}}, SplineDegree -> 2]], 
                
                ArrowBox[{{2.379141188951467, 0.}, {2.362186592080374, 
                 0.5244415513150742}}], 
                
                ArrowBox[{{2.6381209230278255`, 2.8595746735201546`}, {
                 2.7717835101136528`, 2.5088908622570987`}}], 
                
                ArrowBox[{{1.229090287114505, 1.0251096403903683`}, {
                 1.7892970888888562`, 1.3839977852843286`}}]}}}}, {{{{
                Hue[0.6, 0.2, 0.8], 
                EdgeForm[{
                  GrayLevel[0], 
                  Opacity[0.7]}], {{{{
                    Hue[0, 1, 0.8], 
                    
                    DiskBox[{3.047075167056113, 2.7096635269133085`}, 
                    0.037507427053988476`]}}}}, {{{{
                    Hue[0.07, 1, 1], 
                    
                    DiskBox[{1.9012568425562415`, 2.6362095049953833`}, 
                    0.037507427053988476`]}}}}, {{{{
                    Hue[0.14, 1, 0.9], 
                    
                    DiskBox[{3.2189169574477594`, 1.304585972526182}, 
                    0.037507427053988476`]}}}}, {{{{
                    Hue[0.14, 1, 0.9], 
                    
                    DiskBox[{3.436163837646358, 1.3991233158636618`}, 
                    0.037507427053988476`]}}}}, {{{{
                    Hue[0, 1, 0.8], 
                    
                    DiskBox[{2.8945169498586005`, 2.3278299921410754`}, 
                    0.037507427053988476`]}}}}, {{{{
                    Hue[0, 1, 0.8], 
                    
                    DiskBox[{3.0168262991530046`, 2.203184761092473}, 
                    0.037507427053988476`]}}}}, {{{{
                    Hue[0.14, 1, 0.9], 
                    
                    DiskBox[{3.863785160828577, 0.7483996524154757}, 
                    0.037507427053988476`]}}}}, {{{{
                    Hue[0.8, 0.6, 0.8], 
                    
                    DiskBox[{2.008826120159008, 0.5446306364511517}, 
                    0.037507427053988476`]}}}}, {{{{
                    Hue[0.1, 0.6, 0.7], 
                    
                    DiskBox[{1.4317409703870636`, 1.6436267795397013`}, 
                    0.037507427053988476`]}}}}, {{{{
                    Hue[0.14, 1, 0.9], 
                    
                    DiskBox[{3.3698316224333045`, 1.3648023304164223`}, 
                    0.037507427053988476`]}}}}, {{{{
                    Hue[0.8, 0.6, 0.8], 
                    
                    DiskBox[{2.081256109579293, 0.8765002427881036}, 
                    0.037507427053988476`]}}}}, {{{{
                    Hue[0, 1, 0.8], 
                    
                    DiskBox[{3.435844219959085, 2.2329755919596055`}, 
                    0.037507427053988476`]}}}}, {{{{
                    Hue[0, 1, 0.8], 
                    
                    DiskBox[{3.2558740995825404`, 2.299180100054544}, 
                    0.037507427053988476`]}}}}, {{{{
                    Hue[0, 1, 0.8], 
                    
                    DiskBox[{2.639358157050337, 2.58173400028977}, 
                    0.037507427053988476`]}}}}, {{{{
                    Hue[0.1, 0.6, 0.7], 
                    
                    DiskBox[{1.2089139891580554`, 1.7577768430581273`}, 
                    0.037507427053988476`]}}}}, {{{{
                    Hue[0.07, 1, 1], 
                    
                    DiskBox[{1.5709661391269687`, 2.6898873166852377`}, 
                    0.037507427053988476`]}}}}, {{{{
                    Hue[0.5, 1, 0.7], 
                    
                    DiskBox[{1.4077729862113624`, 1.3627094940221658`}, 
                    0.037507427053988476`]}}}}, {{{{
                    Hue[0.5, 1, 0.7], 
                    
                    DiskBox[{1.2844991781478532`, 1.3776207935937406`}, 
                    0.037507427053988476`]}}}}, {{{{
                    Hue[0, 1, 0.8], 
                    
                    DiskBox[{3.153603273248364, 2.9306699008070343`}, 
                    0.037507427053988476`]}}}}, {{{{
                    Hue[0, 1, 0.8], 
                    
                    DiskBox[{2.885749972239753, 2.5908377725505027`}, 
                    0.037507427053988476`]}}}}, {{{{
                    Hue[0.07, 1, 1], 
                    
                    DiskBox[{1.7262385797428599`, 2.90059760515629}, 
                    0.037507427053988476`]}}}}, {{{{
                    Hue[0.07, 1, 1], 
                    
                    DiskBox[{1.659602271005506, 2.5661590599428186`}, 
                    0.037507427053988476`]}}}}, {{{{
                    Hue[0.5, 1, 0.7], 
                    
                    DiskBox[{1.5601588770566857`, 1.6125675816540839`}, 
                    0.037507427053988476`]}}}}, {{{{
                    Hue[0, 1, 0.8], 
                    
                    DiskBox[{2.6172375808234727`, 3.252616902127802}, 
                    0.037507427053988476`]}}}}, {{{{
                    Hue[0, 1, 0.8], 
                    
                    DiskBox[{2.75647819250503, 2.6658384200680523`}, 
                    0.037507427053988476`]}}}}, {{{{
                    Hue[0.07, 1, 1], 
                    
                    DiskBox[{1.7765265466405027`, 2.4779315488363594`}, 
                    0.037507427053988476`]}}}}, {{{{
                    Hue[0.8, 0.6, 0.8], 
                    
                    DiskBox[{1.8659877072932964`, 0.3556277108148027}, 
                    0.037507427053988476`]}}}}, {{{{
                    Hue[0.2, 1, 0.6], 
                    
                    DiskBox[{2.7105021551043778`, 0.9070036280291717}, 
                    0.037507427053988476`]}}}}, {{{{
                    Hue[0, 1, 0.8], 
                    
                    DiskBox[{2.941964292630955, 2.3750910006693067`}, 
                    0.037507427053988476`]}}}}, {{{{
                    Hue[0, 1, 0.8], 
                    
                    DiskBox[{3.168138093800108, 2.1047183043495687`}, 
                    0.037507427053988476`]}}}}, {{{{
                    Hue[0.5, 1, 0.7], 
                    
                    DiskBox[{1.7892970888888562`, 1.3839977852843286`}, 
                    0.037507427053988476`]}}}}, {{{{
                    Hue[0, 1, 0.8], 
                    
                    DiskBox[{3.2191147448421815`, 2.591814620447461}, 
                    0.037507427053988476`]}}}}, {{{{
                    Hue[0.07, 1, 1], 
                    
                    DiskBox[{1.4936031083055394`, 2.3466448592302127`}, 
                    0.037507427053988476`]}}}}, {{{{
                    Hue[0.8, 0.6, 0.8], 
                    
                    DiskBox[{1.7002593872780785`, 0.7583610740868956}, 
                    0.037507427053988476`]}}}}, {{{{
                    Hue[0, 1, 0.8], 
                    
                    DiskBox[{2.696123673956549, 2.9770171690697973`}, 
                    0.037507427053988476`]}}}}, {{{{
                    Hue[0.5, 1, 0.7], 
                    
                    DiskBox[{1.4872871787099529`, 1.2260793094448104`}, 
                    0.037507427053988476`]}}}}, {{{{
                    Hue[0.1, 0.6, 0.7], 
                    
                    DiskBox[{0.8641894439884323, 1.729865325243864}, 
                    0.037507427053988476`]}}}}, {{{{
                    Hue[0.2, 1, 0.6], 
                    
                    DiskBox[{2.860218741205732, 0.06188429627397407}, 
                    0.037507427053988476`]}}}}, {{{{
                    Hue[0.2, 1, 0.6], 
                    
                    DiskBox[{2.728134301269645, 0.547410220538946}, 
                    0.037507427053988476`]}}}}, {{{{
                    Hue[0.14, 1, 0.9], 
                    
                    DiskBox[{3.6879572559236125`, 0.7806372519986963}, 
                    0.037507427053988476`]}}}}, {{{{
                    Hue[0.14, 1, 0.9], 
                    
                    DiskBox[{3.7188573339539, 0.5590467057909552}, 
                    0.037507427053988476`]}}}}, {{{{
                    Hue[0.5, 1, 0.7], 
                    
                    DiskBox[{2.120819147085375, 1.393376825005813}, 
                    0.037507427053988476`]}}}}, {{{{
                    Hue[0, 1, 0.8], 
                    
                    DiskBox[{2.7546226575755544`, 2.4229995292827673`}, 
                    0.037507427053988476`]}}}}, {{{{
                    Hue[0.2, 1, 0.6], 
                    
                    DiskBox[{2.479471842206366, 0.5332217204409468}, 
                    0.037507427053988476`]}}}}, {{{{
                    Hue[0.1, 0.6, 0.7], 
                    
                    DiskBox[{1.0565798231281445`, 1.9692461660448652`}, 
                    0.037507427053988476`]}}}}, {{{{
                    Hue[0, 1, 0.8], 
                    
                    DiskBox[{2.7717835101136528`, 2.5088908622570987`}, 
                    0.037507427053988476`]}}}}, {{{{
                    Hue[0, 1, 0.8], 
                    
                    DiskBox[{3.247766799018454, 2.714317113377208}, 
                    0.037507427053988476`]}}}}, {{{{
                    Hue[0.07, 1, 1], 
                    DiskBox[{1.4824324635631985`, 2.1437996026384694`}, 
                    0.037507427053988476`]}}}}, {{{{
                    Hue[0.8, 0.6, 0.8], 
                    
                    DiskBox[{1.913334641285302, 0.7078373027089306}, 
                    0.037507427053988476`]}}}}, {{{{
                    Hue[0, 1, 0.8], 
                    
                    DiskBox[{2.979741943261697, 2.8525353858563727`}, 
                    0.037507427053988476`]}}}}, {{{{
                    Hue[0, 1, 0.8], 
                    
                    DiskBox[{2.7949307783187454`, 2.7932962145942843`}, 
                    0.037507427053988476`]}}}}, {{{{
                    Hue[0.07, 1, 1], 
                    
                    DiskBox[{1.8258270145944309`, 2.1977077057722294`}, 
                    0.037507427053988476`]}}}}, {{{{
                    Hue[0.07, 1, 1], 
                    
                    DiskBox[{1.6936108638638805`, 2.443351346309686}, 
                    0.037507427053988476`]}}}}, {{{{
                    Hue[0.07, 1, 1], 
                    
                    DiskBox[{1.5016908230129027`, 3.1310962489087952`}, 
                    0.037507427053988476`]}}}}, {{{{
                    Hue[0.14, 1, 0.9], 
                    
                    DiskBox[{3.6616215045764386`, 1.5173752431572736`}, 
                    0.037507427053988476`]}}}}, {{{{
                    Hue[0.14, 1, 0.9], 
                    
                    DiskBox[{3.639524520551916, 1.423984925743525}, 
                    0.037507427053988476`]}}}}, {{{{
                    Hue[0.2, 1, 0.6], 
                    
                    DiskBox[{2.4769053868232604`, 0.7462115076005172}, 
                    0.037507427053988476`]}}}}, {{{{
                    Hue[0.14, 1, 0.9], 
                    
                    DiskBox[{4.078951513179973, 0.9824965843683116}, 
                    0.037507427053988476`]}}}}, {{{{
                    Hue[0.14, 1, 0.9], 
                    
                    DiskBox[{3.9046185181312127`, 1.0791172991906632`}, 
                    0.037507427053988476`]}}}}, {{{{
                    Hue[0.14, 1, 0.9], 
                    
                    DiskBox[{3.6312554533642967`, 1.276311392234716}, 
                    0.037507427053988476`]}}}}, {{{{
                    Hue[0.14, 1, 0.9], 
                    DiskBox[{3.4024975480581325`, 1.0360003985902304`}, 
                    0.037507427053988476`]}}}}, {{{{
                    Hue[0.2, 1, 0.6], 
                    
                    DiskBox[{2.6435932129269224`, 0.6692393249864104}, 
                    0.037507427053988476`]}}}}, {{{{
                    Hue[0.2, 1, 0.6], 
                    
                    DiskBox[{2.6829214703562427`, 1.1475183499011745`}, 
                    0.037507427053988476`]}}}}, {{{{
                    Hue[0.1, 0.6, 0.7], 
                    
                    DiskBox[{0., 1.7593590303995787`}, 
                    0.037507427053988476`]}}}}, {{{{
                    Hue[0.1, 0.6, 0.7], 
                    
                    DiskBox[{0.1960871848582526, 1.4526685999726807`}, 
                    0.037507427053988476`]}}}}, {{{{
                    Hue[0.14, 1, 0.9], 
                    
                    DiskBox[{3.2476632785575363`, 1.0728745873603875`}, 
                    0.037507427053988476`]}}}}, {{{{
                    Hue[0.14, 1, 0.9], 
                    
                    DiskBox[{3.4043299334098798`, 0.6350503052987047}, 
                    0.037507427053988476`]}}}}, {{{{
                    Hue[0, 1, 0.8], 
                    
                    DiskBox[{3.343942158688346, 2.3809192251939044`}, 
                    0.037507427053988476`]}}}}, {{{{
                    Hue[0.8, 0.6, 0.8], 
                    
                    DiskBox[{1.83402441705881, 0.15113954727774104`}, 
                    0.037507427053988476`]}}}}, {{{{
                    Hue[0.8, 0.6, 0.8], 
                    
                    DiskBox[{1.3226083806916278`, 0.1935758469765163}, 
                    0.037507427053988476`]}}}}, {{{{
                    Hue[0, 1, 0.8], 
                    
                    DiskBox[{3.4184546835413303`, 2.658053342032937}, 
                    0.037507427053988476`]}}}}, {{{{
                    Hue[0.1, 0.6, 0.7], 
                    
                    DiskBox[{1.0589020370890991`, 2.36533463835313}, 
                    0.037507427053988476`]}}}}, {{{{
                    Hue[0.14, 1, 0.9], 
                    
                    DiskBox[{3.5177675418365486`, 1.1068835324227273`}, 
                    0.037507427053988476`]}}}}, {{{{
                    Hue[0.8, 0.6, 0.8], 
                    DiskBox[{1.55552811144987, 0.2205265602056279}, 
                    0.037507427053988476`]}}}}, {{{{
                    Hue[0.2, 1, 0.6], 
                    
                    DiskBox[{2.897487935564712, 0.5873431303720924}, 
                    0.037507427053988476`]}}}}, {{{{
                    Hue[0.2, 1, 0.6], 
                    
                    DiskBox[{2.648658069975757, 0.39873378586359465`}, 
                    0.037507427053988476`]}}}}, {{{{
                    Hue[0.2, 1, 0.6], 
                    
                    DiskBox[{2.508013277206207, 0.2397169293763568}, 
                    0.037507427053988476`]}}}}, {{{{
                    Hue[0.2, 1, 0.6], 
                    
                    DiskBox[{2.362186592080374, 0.5244415513150742}, 
                    0.037507427053988476`]}}}}, {{{{
                    Hue[0.8, 0.6, 0.8], 
                    
                    DiskBox[{1.6322141299670254`, 0.32782518429781415`}, 
                    0.037507427053988476`]}}}}, {{{{
                    Hue[0.1, 0.6, 0.7], 
                    
                    DiskBox[{0.48648832038562073`, 1.2674652116454612`}, 
                    0.037507427053988476`]}}}}, {{{{
                    Hue[0.14, 1, 0.9], 
                    
                    DiskBox[{3.424196308805824, 0.8651034511066054}, 
                    0.037507427053988476`]}}}}, {{{{
                    Hue[0, 1, 0.8], 
                    
                    DiskBox[{3.0268882963975825`, 2.501500726277051}, 
                    0.037507427053988476`]}}}}, {{{{
                    Hue[0.8, 0.6, 0.8], 
                    
                    DiskBox[{1.5194871010494955`, 0.46597995469881126`}, 
                    0.037507427053988476`]}}}}, {{{{
                    Hue[0.8, 0.6, 0.8], 
                    
                    DiskBox[{1.7752671079791367`, 0.470509225953319}, 
                    0.037507427053988476`]}}}}, {{{{
                    Hue[0.07, 1, 1], 
                    
                    DiskBox[{1.7873130030936033`, 3.009407453920633}, 
                    0.037507427053988476`]}}}}, {{{{
                    Hue[0, 1, 0.8], 
                    
                    DiskBox[{3.510120753886917, 2.9615258909695346`}, 
                    0.037507427053988476`]}}}}, {{{{
                    Hue[0.14, 1, 0.9], 
                    DiskBox[{3.8229397888607277`, 1.5719264518511218`}, 
                    0.037507427053988476`]}}}}, {{{{
                    Hue[0.8, 0.6, 0.8], 
                    
                    DiskBox[{1.2857951610028178`, 0.5613116475528517}, 
                    0.037507427053988476`]}}}}, {{{{
                    Hue[0.14, 1, 0.9], 
                    
                    DiskBox[{3.9534012472606035`, 0.33446155498674246`}, 
                    0.037507427053988476`]}}}}, {{{{
                    Hue[0.1, 0.6, 0.7], 
                    
                    DiskBox[{0.6956755051279591, 2.0931413686684124`}, 
                    0.037507427053988476`]}}}}, {{{{
                    Hue[0.5, 1, 0.7], 
                    
                    DiskBox[{0.9502368849456799, 1.5161573580523022`}, 
                    0.037507427053988476`]}}}}, {{{{
                    Hue[0.07, 1, 1], 
                    
                    DiskBox[{1.1780911121805178`, 2.656162393253947}, 
                    0.037507427053988476`]}}}}, {{{{
                    Hue[0.1, 0.6, 0.7], 
                    
                    DiskBox[{1.7637259733857853`, 1.8007124642878996`}, 
                    0.037507427053988476`]}}}}, {{{{
                    Hue[0.2, 1, 0.6], 
                    
                    DiskBox[{2.379141188951467, 0.}, 
                    0.037507427053988476`]}}}}, {{{{
                    Hue[0.8, 0.6, 0.8], 
                    
                    DiskBox[{1.5770143574601727`, 0.6524818163347639}, 
                    0.037507427053988476`]}}}}, {{{{
                    Hue[0, 1, 0.8], 
                    
                    DiskBox[{2.6381209230278255`, 2.8595746735201546`}, 
                    0.037507427053988476`]}}}}, {{{{
                    Hue[0.5, 1, 0.7], 
                    
                    DiskBox[{1.229090287114505, 1.0251096403903683`}, 
                    0.037507427053988476`]}}}}}}}}}}, FrameTicks -> None, 
          GridLinesStyle -> Directive[
            GrayLevel[0.5, 0.4]], ImageSize -> {449.9453125, Automatic}]], 
        "ExerciseOutput", Selectable -> False, Copyable -> False, Editable -> 
        False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"00ec7af5-5a94-4557-8edb-9d82de091294"]
}, Closed]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Q&A", "QASection",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"53875622-3f15-4bc3-9c72-d59cd039c843"],

Cell["What\[CloseCurlyQuote]s the difference between a \
\[OpenCurlyDoubleQuote]graph\[CloseCurlyDoubleQuote] and a \
\[OpenCurlyDoubleQuote]network\[CloseCurlyDoubleQuote]?", "Question",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"d250519a-79cf-4cd2-9067-a61001bba513"],

Cell["\<\
There\[CloseCurlyQuote]s no difference. They\[CloseCurlyQuote]re just \
different words for the same thing, though \[OpenCurlyDoubleQuote]graph\
\[CloseCurlyDoubleQuote] tends to be more common in math and other formal \
areas, and \[OpenCurlyDoubleQuote]network\[CloseCurlyDoubleQuote] more common \
in more applied areas.\
\>", "Answer",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"5eb73312-6e93-4ea2-88fb-0c9226816e17"],

Cell["What are the vertices and edges of a graph?", "Question",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:15",ExpressionUUID->"f0ad2894-b414-45d1-9166-263c4ed227b4"],

Cell["\<\
Vertices are the points, or nodes, of a graph. Edges are the connections. \
Because graphs have arisen in so many different places, there are quite a few \
different names used for the same thing.\
\>", "Answer",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"2250d0c7-c56c-4855-bc9b-f11207df818b"],

Cell[TextData[{
 "How is ",
 Cell[BoxData[
  RowBox[{"i", 
   ButtonBox["\[Rule]",
    BaseStyle->"Link",
    ButtonData->"Rule"], "j"}]], "InlineCode",ExpressionUUID->
  "e9d248ae-6bd2-4ba4-a6b5-f68e918ed168"],
 " understood?"
}], "Question",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"b5b91a8b-a28f-44af-9f1a-83686697de48"],

Cell[TextData[{
 "It\[CloseCurlyQuote]s ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Rule",
    BaseStyle->"CodeLink"], "[", 
   RowBox[{"i", ",", "j"}], "]"}]], "InlineCode",ExpressionUUID->
  "717178ce-5118-4a34-b0f7-7fcfd1634ec7"],
 ". Rules are used in lots of places in the Wolfram Language\[LongDash]such \
as giving settings for options."
}], "Answer",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:16",ExpressionUUID->"77d250fa-bdda-4e6e-86a1-be7edd787d2e"],

Cell["Can I compute my Facebook friend graph?", "Question",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:17",ExpressionUUID->"4aef5864-0921-4caa-b37b-051d203a96e0"],

Cell[TextData[{
 "Yes. Use ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["SocialMediaData",
    BaseStyle->"CodeLink"], "[", 
   RowBox[{"\<\"Facebook\"\>", ",", "\<\"FriendNetwork\"\>"}], "]"}]], 
  "InlineCode",ExpressionUUID->"a90bbfa0-4b07-4244-a6d2-6e1d250a90f2"],
 ". Note, though, that only your friends who\[CloseCurlyQuote]ve opted in \
through Facebook will be included. (See ",
 ButtonBox["Section 44",
  BaseStyle->"Hyperlink",
  ButtonData->{"EIWL2-44-importing-and-exporting.nb", "SocialMediaData"}],
 ".)"
}], "Answer",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"6c10a6e6-b53c-4599-a2aa-169d67ac4ad1"],

Cell["How big a graph can the Wolfram Language handle?", "Question",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"110a296a-0173-46d6-b81b-273abb3864d3"],

Cell["\<\
It\[CloseCurlyQuote]s mostly limited by the amount of memory in your \
computer. Graphs with tens or hundreds of thousands of nodes are not a \
problem. \
\>", "Answer",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"b0b52a58-ffbe-4e9e-a12e-499c839af1f1"],

Cell["Can I specify properties of nodes and edges?", "Question",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"a6f10f5f-b631-4bda-905a-e98a4fb03725"],

Cell[TextData[{
 "Yes. You can give ",
 ButtonBox["Graph",
  BaseStyle->"Link"],
 " lists of nodes and edges that include things like ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Property",
    BaseStyle->"CodeLink"], "[", 
   RowBox[{
    StyleBox["node", "CodeVariable"], ",", 
    RowBox[{
     ButtonBox["VertexStyle",
      BaseStyle->"CodeLink"], 
     ButtonBox["\[Rule]",
      BaseStyle->"Link",
      ButtonData->"Rule"], 
     ButtonBox["Red",
      BaseStyle->"CodeLink"]}]}], "]"}]], "InlineCode",ExpressionUUID->
  "679a44e6-94f6-464e-9317-333a5d08b7e9"],
 " or ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Property",
    BaseStyle->"CodeLink"], "[", 
   RowBox[{
    StyleBox["edge", "CodeVariable"], ",", " ", 
    RowBox[{
     ButtonBox["EdgeWeight",
      BaseStyle->"CodeLink"], 
     ButtonBox["\[Rule]",
      BaseStyle->"Link",
      ButtonData->"Rule"], "20"}]}], "]"}]], "InlineCode",ExpressionUUID->
  "f2e32de9-c492-4fd9-9ee1-c8d24fd4b4fb"],
 ". You can also give overall options to ",
 ButtonBox["Graph",
  BaseStyle->"Link"],
 "."
}], "Answer",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->{
  "LastCellOfAPage", 
   "i:18"},ExpressionUUID->"f56415a7-fd0c-4d7d-80d3-c7ed18753de0"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Tech Notes", "TechNoteSection",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"p:121",ExpressionUUID->"b61b4f26-75d8-4f43-802b-2f2392613ce1"],

Cell["\<\
Graphs, like strings, images, graphics, etc., are first-class objects in the \
Wolfram Language.\
\>", "TechNote",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"a663fad2-c271-4bc6-bff2-a20fac1ca68c"],

Cell[TextData[{
 "You can enter undirected edges in a graph using ",
 Cell[BoxData["<->"], "InlineCode",ExpressionUUID->
  "5cc35175-f1d9-44fa-abed-e5955c24d077"],
 ", which displays as ",
 ButtonBox["\[UndirectedEdge]",
  BaseStyle->"Link"],
 "."
}], "TechNote",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"786fdf47-f0ab-4d68-88f8-7e26383e3173"],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["CompleteGraph",
    BaseStyle->"CodeLink"], "[", 
   StyleBox["n", "CodeVariable"], "]"}]], "InlineCode",ExpressionUUID->
  "1f8a7984-9033-4d1f-9378-33f0d52ff8a8"],
 " gives the completely connected graph with ",
 Cell[BoxData[
  StyleBox["n", "CodeVariable"]], "InlineCode",ExpressionUUID->
  "db7bc9eb-6c3e-4065-a20c-c14c9d4965e7"],
 " nodes. Among other ",
 ButtonBox["kinds of special graphs",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/GraphConstructionAndRepresentation"],
 " are ",
 ButtonBox["KaryTree",
  BaseStyle->"Link"],
 ", ",
 ButtonBox["ButterflyGraph",
  BaseStyle->"Link"],
 ", ",
 ButtonBox["HypercubeGraph",
  BaseStyle->"Link"],
 ", etc. "
}], "TechNote",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:19",ExpressionUUID->"b54d8ed2-b5e1-436a-abef-71162197d24c"],

Cell[TextData[{
 "There are lots of ways to make ",
 ButtonBox["random graphs",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/RandomGraphs"],
 " (random connections, random numbers of connections, scale-free networks, \
etc.). ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["RandomGraph",
    BaseStyle->"CodeLink"], "[", 
   RowBox[{"{", 
    RowBox[{"100", ",", "200"}], "}"}], "]"}]], "InlineCode",ExpressionUUID->
  "bcec5b85-b31b-476a-8eb6-05075a8d4358"],
 " makes a random graph with 100 nodes and 200 edges."
}], "TechNote",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:20",ExpressionUUID->"082d5a70-91eb-4b2d-838e-272449ddb273"],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["AdjacencyMatrix",
    BaseStyle->"CodeLink"], "[", 
   StyleBox["graph", "CodeVariable"], "]"}]], "InlineCode",ExpressionUUID->
  "b33a14d2-9655-461d-af1f-af36058c5055"],
 " gives the adjacency matrix for a graph. ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["AdjacencyGraph",
    BaseStyle->"CodeLink"], "[", 
   StyleBox["matrix", "CodeVariable"], "]"}]], "InlineCode",ExpressionUUID->
  "83656dec-fe5b-4639-982b-8cad2514dfb0"],
 " constructs a graph from an adjacency matrix."
}], "TechNote",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:21",ExpressionUUID->"dbed4faa-d17a-47bd-a75a-a67e9ac75446"],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["PlanarGraph",
    BaseStyle->"CodeLink"], "[", 
   StyleBox["graph", "CodeVariable"], "]"}]], "InlineCode",ExpressionUUID->
  "0d4d38ca-b1b4-44b5-9f3d-e8834c73851d"],
 " tries to lay a graph out without any edges crossing\[LongDash]if that\
\[CloseCurlyQuote]s possible."
}], "TechNote",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:22",ExpressionUUID->"ce23b07e-c33c-439c-b956-09005a376cfe"]
}, Open  ]],

Cell[CellGroupData[{

Cell["More to Explore", "MoreExploreSection",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"2a21043d-8b4d-41a2-85db-95ce137d80c8"],

Cell[TextData[ButtonBox["Guide to Graphs and Networks in the Wolfram Language\
\[NonBreakingSpace]\[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphsAndNetworks"]], "MoreExplore",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->
  "LastCellOfAPage",ExpressionUUID->"ceb37b4b-1dd7-4223-a941-e264d9b05177"]
}, Open  ]]
},
Saveable->False,
WindowToolbars->{},
BlinkingCellInsertionPoint->False,
CellInsertionPointCell->None,
WindowSize->{830, 800},
WindowMargins->Automatic,
WindowPersistentStyles->{
 WindowFrame, WindowMargins, WindowSize, Magnification},
WindowTitle->"Graphs and Networks: Elementary Introduction to the Wolfram \
Language",
DockedCells->{
  Cell[
   BoxData[
    TagBox[
     GridBox[{{
        TemplateBox[{
         "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]", 
          "\"\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\"", 
          GraphicsBox[
           TagBox[
            RasterBox[CompressedData["
1:eJztl01IVFEUxyctMFzUysjIyUDCTauiIJFM6ENpM4NEtJrBUaSYZMYPhCRm
rYuoICgiW0VEBVIUEbTNEMTAIqRsk6JGCVFBHx7//+4JLo/36DqvB4Ie+Mk7
7+t3733nHpzq9NlEW0ksFsuX4U8i1duQy6X6kpuRtGTzHe3ZTOuxbFemPZPb
ny7FyZ2gEqwHInICfJToguOIReywPVHHlYDzcY4hJHZ486giyBOXtfms5Pms
Bs9zUBDTow6DJOgBT8DP/+B5CepAPbgqZm+zT70Bt9VXCx6H8DwE28Gw5ufB
IT2eA1N6PKquC0V4xtUxqfkE6ARD4BHYAx5Y938Gu8GdZXq4VsNWngIfwDzY
Aa6Bm55nOKYq8NXRw29eb+Uz4JSVd4Nn4IbPs2fARUdPQcfLWAQJ8Mq6Tkdd
gGcEHHT0sHYn9Jg1dcnnnhf6vnee8xzXVkcP9wdr97eY7z0NnlrX74qpxffg
iOZ2VDp6kvqOe6AVXAb7xNQB462YNfsCfoBzoE1MzTEqHD096mgE98WsEec4
Jqamvvk8cx2kwWuw19HDXnIAbNAx03ka9IO8mO+3ScyebRZTi01i1rqguHjY
r3aJWaugOA5O6vEC+K6ebWDW0cNgv6oBnwKus87KwKDmv8BRMOBz77/6G/sV
e8lkwHWuTwm4pQ7WzGIRHgb7FXsJ9/mI5z2si42gXMw8/ByuHgb7FXsJ9yX3
IPfHFjF1xTl5v0exnrCx5gnn+fu7JC7h/z/0Y52+P+rfWX9iCXVYErg=
             "], {{0,
              34}, {26, 0}}, {0, 255}, ColorFunction -> RGBColor], 
            BoxForm`ImageTag[
            "Byte", ColorSpace -> "RGB", Interleaving -> True, Magnification -> 
             1], Selectable -> False], DefaultBaseStyle -> "ImageGraphics", 
           ImageSize -> Magnification[1], ImageSizeRaw -> {26, 34}, 
           PlotRange -> {{0, 26}, {0, 34}}], 
          GraphicsBox[
           TagBox[
            RasterBox[CompressedData["
1:eJztXUuS47gRLX8WXtYRaJ+gl17SS+8U4/CeM+H2hDdtRY8jHF6ZR9AReATt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             "], {{0, 34}, {383, 0}}, {0, 255}, 
             ColorFunction -> RGBColor], 
            BoxForm`ImageTag[
            "Byte", ColorSpace -> "RGB", Interleaving -> True, Magnification -> 
             1], Selectable -> False], DefaultBaseStyle -> "ImageGraphics", 
           ImageSize -> Magnification[1], ImageSizeRaw -> {383, 34}, 
           PlotRange -> {{0, 383}, {0, 34}}]}, "RowWithSeparators"], 
        PaneBox[
         StyleBox["\[VeryThinSpace]", ShowStringCharacters -> False], 
         Alignment -> Right, ImageSize -> {174, 47}], 
        PaneBox[
         PaneBox[
          TemplateBox[{"\[ThinSpace]", "\" \"", 
            TagBox[
             TooltipBox[
              PaneSelectorBox[{False -> ButtonBox[
                  PaneBox[
                   GraphicsBox[
                    TagBox[
                    RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UJAPiDmBmIUBO/j//z8jEDcA8W8g3oBFnhmIZ/9HgE9o8mxAvBZJ/hsQuyPJ
8wPxfiT5N0BsjiQvCsTnkOSfALEWkrwSEN9Bkr8OxDJobniAJP8ZZCYWfxCj
RpGQXcS4mVi/ExuGxMYFmlp4nAIAG14fWQ==
                    "], {{0, 14}, {9, 
                    0}}, {0, 255}, ColorFunction -> RGBColor], 
                    BoxForm`ImageTag[
                    "Byte", ColorSpace -> "RGB", Interleaving -> True], 
                    Selectable -> False], DefaultBaseStyle -> "ImageGraphics",
                     ImageSizeRaw -> {9, 14}, PlotRange -> {{0, 9}, {0, 14}}, 
                    ImageSize -> Magnification[1]], ImageSize -> {35, 30}, 
                   Alignment -> Center], 
                  ButtonFunction :> (
                   NotebookLocate[{"EIWL2-20-options.nb", ""}, 
                    FrontEnd`HistoryData :> {
                    EvaluationNotebook[]}]& ), Enabled -> True, Appearance -> 
                  None, Evaluator -> Automatic, Method -> "Preemptive"], True -> 
                ButtonBox[
                  PaneBox[
                   GraphicsBox[
                    TagBox[
                    RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UJAPiDmBmIUBO/j//z8jEDcA8W8g3oBFnhmIZ/9HgE9o8mxAvBZJ/hsQuyPJ
8wPxfiT5N0BsjiQvCsTnkOSfALEWkrwSEN9Bkr8OxDJobniAJP8ZZCYWfxCj
RpGQXcS4mVi/ExuGxMYFmlp4nAIAG14fWQ==
                    "], {{0, 14}, {9, 
                    0}}, {0, 255}, ColorFunction -> RGBColor], 
                    BoxForm`ImageTag[
                    "Byte", ColorSpace -> "RGB", Interleaving -> True], 
                    Selectable -> False], DefaultBaseStyle -> "ImageGraphics",
                     ImageSizeRaw -> {9, 14}, PlotRange -> {{0, 9}, {0, 14}}, 
                    ImageSize -> Magnification[1]], ImageSize -> {35, 30}, 
                   Alignment -> Center], 
                  ButtonFunction :> (
                   NotebookLocate[{"EIWL2-20-options.nb", ""}, 
                    FrontEnd`HistoryData :> {
                    EvaluationNotebook[]}]& ), Enabled -> True, Appearance -> 
                  None, Background -> RGBColor[0.835294, 0.364706, 0.0196078],
                   Evaluator -> Automatic, Method -> "Preemptive"]}, 
               Dynamic[
                CurrentValue["MouseOver"]], ImageSize -> Automatic, 
               FrameMargins -> 0], "\"Options\"", TooltipDelay -> 0.15, 
              LabelStyle -> "TextStyling"], 
             Annotation[#, "Options", "Tooltip"]& ], 
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {5, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[5], Selectable -> False], 
            TagBox[
             TooltipBox[
              PaneSelectorBox[{False -> ButtonBox[
                  PaneBox[
                   GraphicsBox[
                    TagBox[
                    RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UJAfiDmBmAWI////vwKIfwFxMQMOAJT7+R8B6nGoSf+PCjpwqMskUl0SEP9F
UtcHxIxY1EWjqZuOQ10Mmr2TcNj7BEnNP1LNIeQeIDsZn78IhQ8x4fwfNb4a
cPgTFu8l2ORBAAC+1hnm
                    "], {{0, 15}, {9, 0}}, {0, 255}, 
                    ColorFunction -> RGBColor], 
                    BoxForm`ImageTag[
                    "Byte", ColorSpace -> "RGB", Interleaving -> True], 
                    Selectable -> False], DefaultBaseStyle -> "ImageGraphics",
                     ImageSizeRaw -> {9, 15}, PlotRange -> {{0, 9}, {0, 15}}, 
                    ImageSize -> Magnification[1]], ImageSize -> {35, 30}, 
                   Alignment -> Center], 
                  ButtonFunction :> (
                   NotebookLocate[{"EIWL2-22-machine-learning.nb", ""}, 
                    FrontEnd`HistoryData :> {
                    EvaluationNotebook[]}]& ), Appearance -> None, Evaluator -> 
                  Automatic, Method -> "Preemptive"], True -> ButtonBox[
                  PaneBox[
                   GraphicsBox[
                    TagBox[
                    RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UJAfiDmBmAWI////vwKIfwFxMQMOAJT7+R8B6nGoSf+PCjpwqMskUl0SEP9F
UtcHxIxY1EWjqZuOQ10Mmr2TcNj7BEnNP1LNIeQeIDsZn78IhQ8x4fwfNb4a
cPgTFu8l2ORBAAC+1hnm
                    "], {{0, 15}, {9, 0}}, {0, 255}, 
                    ColorFunction -> RGBColor], 
                    BoxForm`ImageTag[
                    "Byte", ColorSpace -> "RGB", Interleaving -> True], 
                    Selectable -> False], DefaultBaseStyle -> "ImageGraphics",
                     ImageSizeRaw -> {9, 15}, PlotRange -> {{0, 9}, {0, 15}}, 
                    ImageSize -> Magnification[1]], ImageSize -> {35, 30}, 
                   Alignment -> Center], 
                  ButtonFunction :> (
                   NotebookLocate[{"EIWL2-22-machine-learning.nb", ""}, 
                    FrontEnd`HistoryData :> {
                    EvaluationNotebook[]}]& ), Appearance -> None, Background -> 
                  RGBColor[0.835294, 0.364706, 0.0196078], Evaluator -> 
                  Automatic, Method -> "Preemptive"]}, 
               Dynamic[
                CurrentValue["MouseOver"]], ImageSize -> Automatic, 
               FrameMargins -> 0], "\"Machine Learning\"", TooltipDelay -> 
              0.15, LabelStyle -> "TextStyling"], 
             Annotation[#, "Machine Learning", "Tooltip"]& ]}, 
           "RowWithSeparators"], Alignment -> Right], ImageSize -> {100, 30}, 
         FrameMargins -> {{0, 6}, {0, 0}}, Alignment -> Right], 
        ActionMenuBox[
         PaneSelectorBox[{True -> PanelBox[
             GraphicsBox[
              TagBox[
               RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UBAkIQ3ELED8////Jf/pA0D2/KWTXSB7ZtPBPrA9DKOAYgAMR1Eg9gPiABpi
P6g912mcLmAAZM9XOtkFsicKiNcD8QYaYpD5UQOdXoYD+E/HMooO9iDbR7c6
BQDxtyEt
                "], {{0, 16}, {27, 0}}, {0, 255}, ColorFunction -> 
                RGBColor], 
               BoxForm`ImageTag[
               "Byte", ColorSpace -> "RGB", Interleaving -> True, 
                Magnification -> 1], Selectable -> False], DefaultBaseStyle -> 
              "ImageGraphics", ImageSize -> Magnification[1], 
              ImageSizeRaw -> {27, 16}, PlotRange -> {{0, 27}, {0, 16}}], 
             Appearance -> None, Background -> 
             RGBColor[0.835294, 0.364706, 0.0196078], ImageSize -> {35, 30}, 
             Alignment -> Center], False -> PanelBox[
             GraphicsBox[
              TagBox[
               RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UBAkIQ3ELED8////Jf/pA0D2/KWTXSB7ZtPBPrA9DKOAYgAMR1Eg9gPiABpi
P6g912mcLmAAZM9XOtkFsicKiNcD8QYaYpD5UQOdXoYD+E/HMooO9iDbR7c6
BQDxtyEt
                "], {{0, 16}, {27, 0}}, {0, 255}, ColorFunction -> 
                RGBColor], 
               BoxForm`ImageTag[
               "Byte", ColorSpace -> "RGB", Interleaving -> True, 
                Magnification -> 1], Selectable -> False], DefaultBaseStyle -> 
              "ImageGraphics", ImageSize -> Magnification[1], 
              ImageSizeRaw -> {27, 16}, PlotRange -> {{0, 27}, {0, 16}}], 
             Appearance -> None, Background -> 
             RGBColor[0.952941, 0.509804, 0], ImageSize -> {35, 30}, 
             Alignment -> Center]}, 
          Dynamic[
           CurrentValue["MouseOver"]]], {
         "Preface" :> 
          NotebookLocate[{"EIWL2-0a-preface.nb", ""}, FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], "What Is the Wolfram Language?" :> 
          NotebookLocate[{"EIWL2-0b-what-is-the-wolfram-language.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "Practicalities of Using the Wolfram Language" :> 
          NotebookLocate[{
            "EIWL2-0c-practicalities-of-using-the-wolfram-language.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], "Other Resources" :> 
          NotebookLocate[{"EIWL2-0d-other-resources.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]1\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]Starting Out: Elementary Arithmetic" :> 
          NotebookLocate[{
            "EIWL2-01-starting-out-elementary-arithmetic.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]2\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]Introducing Functions" :> 
          NotebookLocate[{"EIWL2-02-introducing-functions.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]3\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]First Look at Lists" :> 
          NotebookLocate[{"EIWL2-03-first-look-at-lists.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]4\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]Displaying Lists" :> 
          NotebookLocate[{"EIWL2-04-displaying-lists.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]5\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]Operations on Lists" :> 
          NotebookLocate[{"EIWL2-05-operations-on-lists.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]6\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]Making Tables" :> 
          NotebookLocate[{"EIWL2-06-making-tables.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]7\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]Colors and Styles" :> 
          NotebookLocate[{"EIWL2-07-colors-and-styles.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]8\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]Basic Graphics Objects" :> 
          NotebookLocate[{"EIWL2-08-basic-graphics-objects.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]9\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]Interactive Manipulation" :> 
          NotebookLocate[{"EIWL2-09-interactive-manipulation.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "10\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Images" :> 
          NotebookLocate[{"EIWL2-10-images.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "11\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Strings and \
Text" :> NotebookLocate[{"EIWL2-11-strings-and-text.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "12\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Sound" :> 
          NotebookLocate[{"EIWL2-12-sound.nb", ""}, FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          
          "13\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Arrays, or \
Lists of Lists" :> 
          NotebookLocate[{"EIWL2-13-arrays-or-lists-of-lists.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "14\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Coordinates \
and Graphics" :> 
          NotebookLocate[{"EIWL2-14-coordinates-and-graphics.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "15\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]The Scope \
of the Wolfram Language" :> 
          NotebookLocate[{
            "EIWL2-15-the-scope-of-the-wolfram-language.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "16\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Real\
\[Hyphen]World Data" :> 
          NotebookLocate[{"EIWL2-16-real-world-data.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "17\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Units" :> 
          NotebookLocate[{"EIWL2-17-units.nb", ""}, FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "18\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
Geocomputation" :> 
          NotebookLocate[{"EIWL2-18-geocomputation.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "19\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Dates and \
Times" :> NotebookLocate[{"EIWL2-19-dates-and-times.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "20\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Options" :> 
          NotebookLocate[{"EIWL2-20-options.nb", ""}, FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "21\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Graphs and \
Networks" :> 
          NotebookLocate[{"EIWL2-21-graphs-and-networks.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "22\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Machine \
Learning" :> NotebookLocate[{"EIWL2-22-machine-learning.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "23\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]More about \
Numbers" :> NotebookLocate[{"EIWL2-23-more-about-numbers.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "24\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]More Forms \
of Visualization" :> 
          NotebookLocate[{"EIWL2-24-more-forms-of-visualization.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "25\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Ways to \
Apply Functions" :> 
          NotebookLocate[{"EIWL2-25-ways-to-apply-functions.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "26\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Pure \
Anonymous Functions" :> 
          NotebookLocate[{"EIWL2-26-pure-anonymous-functions.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "27\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Applying \
Functions Repeatedly" :> 
          NotebookLocate[{"EIWL2-27-applying-functions-repeatedly.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "28\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Tests and \
Conditionals" :> 
          NotebookLocate[{"EIWL2-28-tests-and-conditionals.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "29\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]More about \
Pure Functions" :> 
          NotebookLocate[{"EIWL2-29-more-about-pure-functions.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "30\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Rearranging \
Lists" :> NotebookLocate[{"EIWL2-30-rearranging-lists.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "31\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Parts of \
Lists" :> NotebookLocate[{"EIWL2-31-parts-of-lists.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "32\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Patterns" :> 
          NotebookLocate[{"EIWL2-32-patterns.nb", ""}, FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "33\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Expressions \
and Their Structure" :> 
          NotebookLocate[{"EIWL2-33-expressions-and-their-structure.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "34\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
Associations" :> 
          NotebookLocate[{"EIWL2-34-associations.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "35\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Natural \
Language Understanding" :> 
          NotebookLocate[{"EIWL2-35-natural-language-understanding.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "36\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Creating \
Websites and Apps" :> 
          NotebookLocate[{"EIWL2-36-creating-websites-and-apps.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "37\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Layout and \
Display" :> NotebookLocate[{"EIWL2-37-layout-and-display.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "38\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Assigning \
Names to Things" :> 
          NotebookLocate[{"EIWL2-38-assigning-names-to-things.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "39\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Immediate \
and Delayed Values" :> 
          NotebookLocate[{"EIWL2-39-immediate-and-delayed-values.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "40\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Defining \
Your Own Functions" :> 
          NotebookLocate[{"EIWL2-40-defining-your-own-functions.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "41\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]More about \
Patterns" :> 
          NotebookLocate[{"EIWL2-41-more-about-patterns.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "42\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]String \
Patterns and Templates " :> 
          NotebookLocate[{"EIWL2-42-string-patterns-and-templates.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "43\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Storing \
Things" :> NotebookLocate[{"EIWL2-43-storing-things.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "44\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Importing \
and Exporting" :> 
          NotebookLocate[{"EIWL2-44-importing-and-exporting.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "45\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Datasets" :> 
          NotebookLocate[{"EIWL2-45-datasets.nb", ""}, FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "46\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Writing \
Good Code" :> 
          NotebookLocate[{"EIWL2-46-writing-good-code.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "47\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Debugging \
Your Code" :> 
          NotebookLocate[{"EIWL2-47-debugging-your-code.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "What We Haven\[CloseCurlyQuote]t Discussed" :> 
          NotebookLocate[{"EIWL2-what-we-havent-discussed.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], "Afterword: Being a Programmer" :> 
          NotebookLocate[{"EIWL2-being-a-programmer.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], "Answers to Exercises" :> 
          NotebookLocate[{"EIWL2-answers-to-exercises.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], "Index" :> 
          NotebookLocate[{"EIWL2-book-index.nb", ""}, FrontEnd`HistoryData :> {
              EvaluationNotebook[]}]}, Appearance -> None]}}, 
      GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Center}}}, 
      GridBoxItemSize -> {
       "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], "Grid"]], 
   "Text", ShowCellBracket -> False, CellFrame -> {{0, 0}, {3, 0}}, 
   Selectable -> False, CellFrameColor -> 
   RGBColor[0.835294, 0.364706, 0.0196078], CellMargins -> {{0, 0}, {0, -1}}, 
   CellFrameMargins -> {{27, 0}, {1, 7}}, Background -> 
   RGBColor[0.952941, 0.509804, 0], CellTags -> "DockedCellLogoCell"], 
  Cell["SECOND EDITION", "Text", FontFamily -> "Source Sans Pro", 
   CellFrame -> {{0, 0}, {3, 0}}, ShowCellBracket -> False, 
   CellMargins -> {{0, 0}, {-1, -1}}, CellFrameMargins -> {{66, 0}, {2, 4}}, 
   CellFrameColor -> RGBColor[0.952941, 0.509804, 0], FontSize -> 10, 
   FontTracking -> "Extended", FontColor -> RGBColor[1, 0.929412, 0.721569], 
   Background -> RGBColor[0.862745, 0.309804, 0], CellTags -> 
   "DockedCellLogoCell"]},
PrintingStartingPageNumber->169,
PageHeaders->{{
   Cell[
    TextData[{
      StyleBox[
       CounterBox["Page"], "PageNumber"], 
      StyleBox[
      "    An Elementary Introduction to the Wolfram Language", "Header"]}], 
    "Header", CellMargins -> {{37, Inherited}, {Inherited, Inherited}}], None,
    None}, {None, None, 
   Cell[
    TextData[{
      StyleBox[
       CounterBox["Section"], "Header"], 
      StyleBox[" | Graphs and Networks \[LongDash] wolfr.am/eiwl-", "Header"], 
      StyleBox[
       CounterBox["Section"], "Header"], 
      StyleBox["    ", "Header"], 
      StyleBox[
       CounterBox["Page"], "PageNumber"]}], "Header", 
    CellMargins -> {{Inherited, 17}, {Inherited, Inherited}}]}},
PrintingOptions->{"FirstPageHeader"->True},
PrivateNotebookOptions->{"PluginToolbarEnabled"->False},
ShowCellBracket->Automatic,
ShowAutoSpellCheck->False,
ShowPredictiveInterface->False,
ShowSyntaxStyles->False,
Magnification->1.,
FrontEndVersion->"12.3 for Mac OS X x86 (64-bit) (July 30, 2021)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[StyleDefinitions -> "Default.nb"]], 
   Cell[
    CellGroupData[{
      Cell[
      "Style Environments", "Section", 
       CellChangeTimes -> {{3.64661165091824*^9, 3.646611654013329*^9}, 
         3.6485723794335403`*^9, 3.651347081728628*^9, 3.651347179462186*^9, 
         3.651347384135805*^9, 3.651348171662589*^9}], 
      Cell[
       StyleData[All, "Working"], CellInsertionPointCell -> 
       FEPrivate`FrontEndResource["FEExpressions", "CellInsertionMenu"], 
       CreateCellID -> True, $CellContext`GhostCellInEmptyNotebook -> False], 
      
      Cell[
       StyleData[All, "Printout"], 
       PrintingOptions -> {
        "PageSize" -> {504, 720}, "PrintRegistrationMarks" -> True}, 
       Magnification -> 0.6]}, Closed]], 
   Cell[
    CellGroupData[{
      Cell["Styles for Headers and Footers", "Section"], 
      Cell[
       StyleData["Header"], StyleMenuListing -> None, FontFamily -> "Verdana",
        FontSize -> 7, FontSlant -> "Plain", FontColor -> GrayLevel[0.6]], 
      Cell[
       StyleData["PageNumber"], CellMargins -> {{0, 0}, {4, 1}}, 
       StyleMenuListing -> None, FontFamily -> "Verdana", FontSize -> 7, 
       FontWeight -> "Bold", FontSlant -> "Plain", FontColor -> 
       GrayLevel[0]]}, Closed]], 
   Cell[
    CellGroupData[{
      Cell[
      "WPL Specific", "Section", 
       CellChangeTimes -> {{3.6556608433734913`*^9, 3.6556608489412746`*^9}}], 
      Cell[
       StyleData["Link"], FontFamily -> "Source Sans Pro", FontSize :> 
       If[CurrentValue[
           EvaluationCell[], "FontFamily"] === "Source Sans Pro", Inherited, 
         If[CurrentValue[
            EvaluationCell[], "FontFamily"] === "WolframCodeSans", Inherited, 
          Inherited 0.9]], FontColor -> GrayLevel[0]], 
      Cell[
       StyleData["CodeLink"], 
       ButtonBoxOptions -> {
        Appearance -> None, ButtonFunction :> (FEPrivate`FrontEndExecute[
           FrontEndToken["OpenHelpLink", {
             Part[#, 1], Null}]]& ), ButtonSource -> ButtonContents, 
         Evaluator -> None, Method -> "Preemptive"}]}, Closed]], 
   Cell[
    CellGroupData[{
      Cell[
      "Custom Styles", "Section", 
       CellChangeTimes -> {{3.646611660445352*^9, 3.646611669493331*^9}}], 
      Cell[
       StyleData["Notebook"], PageWidth :> 700, 
       PrintingOptions -> {
        "InnerOuterMargins" -> {35, 16}, "PaperOrientation" -> "Portrait", 
         "PaperSize" -> {504, 720}, 
         "PrintingMargins" -> {{20, 20}, {54, 54}}}, CellLabelAutoDelete -> 
       False, ShowSyntaxStyles -> True, 
       AutoStyleOptions -> {
        "FormattingErrorTooltips" -> False, "HighlightComments" -> False, 
         "HighlightEmphasizedSyntaxErrors" -> False, 
         "HighlightExcessArguments" -> False, "HighlightFormattingErrors" -> 
         False, "HighlightGlobalToLocalScopeConflicts" -> False, 
         "HighlightGraphicsCompatibilityProblems" -> False, 
         "HighlightLocalScopeConflicts" -> False, "HighlightMissingArguments" -> 
         False, "HighlightNoKernelPresent" -> False, 
         "HighlightOrderOfEvaluationConflicts" -> False, "HighlightStrings" -> 
         True, "HighlightSymbolContexts" -> False, "HighlightSymbolShadowing" -> 
         False, "HighlightSyntaxErrors" -> False, "HighlightUndefinedSymbols" -> 
         False, "HighlightUnknownOptions" -> False, 
         "HighlightUnwantedAssignments" -> False}, MenuSortingValue -> None, 
       GraphicsBoxOptions -> {ImageSize -> 240}, 
       Graphics3DBoxOptions -> {ImageSize -> 240}], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Title"], CellMargins -> {{64, Inherited}, {50, 72}}, 
          MenuCommandKey :> None, FontFamily -> "Verdana", FontSize -> 42, 
          FontWeight -> "Bold", FontColor -> GrayLevel[0.4]], 
         Cell[
          StyleData["Title", "Printout"], 
          CellMargins -> {{64, Inherited}, {50, 72}}]}, Closed]], 
      Cell[
       StyleData["Chapter"], MenuCommandKey :> None], 
      Cell[
       StyleData["Subchapter"], MenuCommandKey :> None], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Section"], CellFrame -> {{0, 0}, {0, 0}}, CellDingbat -> 
          Cell[
            TextData[
             CounterBox["Section"], 
             StyleBox[
             "|\[NegativeThinSpace]", FontColor -> 
              RGBColor[
               0.9019607843137255, 0.4117647058823529, 0.027450980392156862`],
               FontFamily -> "Courier", FontSize -> 36, FontWeight -> Plain]],
             "SectionNumber"], CellMargins -> {{96, Inherited}, {12, 44}}, 
          Evaluatable -> True, CellGroupingRules -> {"SectionGrouping", 60}, 
          PageBreakAbove -> True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["Section", "Printout"], 
          CellMargins -> {{96, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionDoubleDigit"], CellFrame -> {{0, 0}, {0, 0}}, 
          CellDingbat -> Cell[
            TextData[
             CounterBox["Section"], 
             StyleBox[
             "|\[NegativeThinSpace]", FontColor -> 
              RGBColor[
               0.9019607843137255, 0.4117647058823529, 0.027450980392156862`],
               FontFamily -> "Courier", FontSize -> 36, FontWeight -> Plain]],
             "SectionNumber"], CellMargins -> {{112, Inherited}, {12, 44}}, 
          Evaluatable -> True, CellGroupingRules -> {"SectionGrouping", 60}, 
          PageBreakAbove -> True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["SectionDoubleDigit", "Printout"], 
          CellMargins -> {{112, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionNumber"], CellBaseline -> Baseline, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 26, FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SectionNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionInline"], FontFamily -> 
          "Source Sans Pro Semibold", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SectionInline", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionNoDingbat"], 
          CellMargins -> {{64, Inherited}, {12, 44}}, Evaluatable -> True, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakAbove -> 
          True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["SectionNoDingbat", "Printout"], 
          CellMargins -> {{64, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       StyleData["AnswerKeyNumberedSection"], 
       CellMargins -> {{64, Inherited}, {8, 28}}, Evaluatable -> True, 
       CellGroupingRules -> {"SectionGrouping", 60}, PageBreakAbove -> True, 
       ShowCellLabel -> False, 
       CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
       CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
       CounterIncrements -> "Section", 
       CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
         "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", FontSize -> 
       18, FontSlant -> "Plain", FontColor -> 
       RGBColor[
        0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
       InterpretationBoxOptions -> {Editable -> True}], 
      Cell[
       StyleData["AnswerKeySectionNumber"], CellBaseline -> Baseline, 
       FontFamily -> "Source Sans Pro Semibold", FontSize -> 18, FontColor -> 
       RGBColor[
        0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
      Cell[
       StyleData["IndexLinkGuide"], 
       CellMargins -> {{64, Inherited}, {48, 28}}, Evaluatable -> True, 
       CellGroupingRules -> {"SectionGrouping", 60}, PageBreakAbove -> True, 
       ShowCellLabel -> False, 
       CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
       CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
       CounterIncrements -> "Section", 
       CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
         "Exercise", 0}}, FontFamily -> "Source Sans Pro", FontSize -> 14, 
       FontSlant -> "Plain", FontColor -> 
       RGBColor[
        0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
       InterpretationBoxOptions -> {Editable -> True}], 
      Cell[
       StyleData["Index"], MenuSortingValue -> 10000, FontFamily -> 
       "Source Sans Pro", FontSize -> 11], 
      Cell[
       StyleData["IndexSubentry"], MenuSortingValue -> 10000, FontFamily -> 
       "Source Sans Pro", FontSize -> 11], 
      Cell[
       StyleData["FunctionName"], MenuSortingValue -> 10000, FontFamily -> 
       "Source Sans Pro Semibold", FontWeight -> "Bold"], 
      Cell[
       StyleData["IndexColumn"], 
       CellMargins -> {{66, 0}, {Inherited, Inherited}}, TabSpacings -> {2.}, 
       MenuSortingValue -> 10000, FontFamily -> "Source Sans Pro", 
       GridBoxOptions -> {
        GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
         GridBoxItemSize -> {"Columns" -> {{25}}}, 
         GridBoxSpacings -> {"Columns" -> {{2}}}}], 
      Cell[
       StyleData["IndexSubsection"], 
       CellMargins -> {{64, Inherited}, {9, 28}}, 
       CellGroupingRules -> {"SectionGrouping", 40}, MenuSortingValue -> 
       10000, FontFamily -> "Source Sans Pro", FontSize -> 24], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Subsection"], CellMargins -> {{64, Inherited}, {12, 32}},
           FontFamily -> "Source Sans Pro Semibold", FontSize -> 18, 
          FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["Subsection", "Printout"], 
          CellMargins -> {{64, Inherited}, {12, 32}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ResourcesSubsection"], 
          CellMargins -> {{64, Inherited}, {4, 16}}, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 15, FontSlant -> "Plain", 
          FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["ResourcesSubsection", "Printout"], 
          CellMargins -> {{64, Inherited}, {4, 16}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Subsubsection"], 
          CellMargins -> {{64, Inherited}, {6, 12}}, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 16, FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["Subsubsection", "Printout"], 
          CellMargins -> {{64, Inherited}, {6, 12}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularySection"], PageWidth :> 700, 
          CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 24}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 18, FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["VocabularySection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 24}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularyTable", StyleDefinitions -> StyleData["Text"]],
           SpanMaxSize -> 1, FontFamily -> "Source Sans Pro Light", FontColor -> 
          GrayLevel[0.8], 
          GridBoxOptions -> {
           GridBoxAlignment -> {"Columns" -> {{Left}}}, 
            GridBoxDividers -> {"Columns" -> {{False}}, "Rows" -> {False, {
                 Directive[
                  Thickness[0.5], "VocabDivColor"]}, False}}, 
            GridBoxItemStyle -> {
             "Columns" -> {"VocabularyCode", Inherited, Inherited}, 
              "Rows" -> {{Automatic}}}, 
            GridBoxSpacings -> {
             "Columns" -> {{0, 1, 2, 1, 2}}, "Rows" -> {{1}}}}], 
         Cell[
          StyleData["VocabularyTable", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "VocabularyTable3Column", StyleDefinitions -> StyleData["Text"]], 
          SpanMaxSize -> 1, FontFamily -> "Source Sans Pro Light", FontColor -> 
          GrayLevel[0.8], 
          GridBoxOptions -> {
           GridBoxAlignment -> {"Columns" -> {{Left}}}, 
            GridBoxDividers -> {"Columns" -> {{False}}, "Rows" -> {False, {
                 Directive[
                  Thickness[0.5], "VocabDivColor"]}, False}}, 
            GridBoxItemStyle -> {
             "Columns" -> {
               "VocabularyCode", Inherited, "VocabularyCode", Inherited, 
                Inherited}, "Rows" -> {{Automatic}}}, 
            GridBoxSpacings -> {
             "Columns" -> {{0, 1, 2, 1, 2}}, "Rows" -> {{1}}}}], 
         Cell[
          StyleData["VocabularyTable3Column", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularyText"], FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["VocabularyText", "Printout"], 
          CellMargins -> {{66, 10}, {7, 7}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularyCode", StyleDefinitions -> StyleData["Text"]], 
          Deletable -> False, FontFamily -> "Source Sans Pro", FontSize -> 14,
           FontWeight -> "Bold", FontColor -> GrayLevel[0.25], 
          GridBoxOptions -> {
           GridBoxAlignment -> {"Columns" -> {{Left}}}, 
            GridBoxDividers -> {
             "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {True, {True}, True}, "RowsIndexed" -> {}}}], 
         Cell[
          StyleData["VocabularyCode", "Printout"], FontColor -> 
          GrayLevel[0.25]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabDivColor"], FontColor -> GrayLevel[0.8]], 
         Cell[
          StyleData["VocabDivColor", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseSection"], PageWidth :> 700, 
          CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, Evaluatable -> True, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, ShowCellLabel -> False, CellFrameMargins -> {{8, 8}, {4, 6}},
           CellFrameColor -> RGBColor[0.901961, 0.411765, 0.027451], 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro", FontSize -> 18, 
          FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["ExerciseSection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 30}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Exercise"], PageWidth :> 700, CellDingbat -> Cell[
            TextData[{"  ", 
              CounterBox["Section"], ".", 
              CounterBox["Exercise"]}], "ExerciseNumber", FontColor -> 
            RGBColor[
             0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
          ShowGroupOpener -> True, CellMargins -> {{108, Inherited}, {4, 8}}, 
          CellGroupingRules -> {"SectionGrouping", 67}, CounterIncrements -> 
          "Exercise", MenuSortingValue -> 10020, MenuCommandKey :> "2", 
          FontFamily -> "Source Sans Pro", FontSize -> 14, FontWeight -> 
          "Plain", FontSlant -> "Plain", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["Exercise", "Printout"], ShowGroupOpener -> False, 
          CellMargins -> {{110, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseNumber"], FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Bold", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["ExerciseNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseSubsection"], PageWidth :> 500, 
          CellFrame -> {{False, False}, {1, False}}, 
          CellMargins -> {{64, Inherited}, {8, 18}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, CellFrameColor -> 
          RGBColor[0.65, 0.6, 0.6], FontFamily -> "Source Sans Pro", FontSize -> 
          18, FontSlant -> "Italic", FontColor -> RGBColor[0.65, 0.6, 0.6]], 
         Cell[
          StyleData["ExerciseSubsection", "Printout"], 
          CellFrame -> {{False, False}, {1, False}}, CellFrameColor -> 
          RGBColor[0.65, 0.6, 0.6]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseNote"], PageWidth :> 700, 
          CellMargins -> {{64, Inherited}, {4, 8}}, PageBreakBelow -> False, 
          MenuSortingValue -> 10050, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0.25], $CellContext`ReturnCreatesNewCell -> 
          True], 
         Cell[
          StyleData["ExerciseNote", "Printout"], 
          CellMargins -> {{64, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["QASection"], PageWidth :> 700, 
          CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Question", 0}}, FontFamily -> "Source Sans Pro", FontSize -> 18, 
          FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["QASection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 30}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Question"], PageWidth :> 700, 
          CellMargins -> {{64, Inherited}, {2, 12}}, PageBreakBelow -> False, 
          CounterIncrements -> "Question", MenuSortingValue -> 10030, 
          MenuCommandKey :> "3", FontFamily -> "Source Sans Pro", FontSize -> 
          14, FontWeight -> "Bold", FontSlant -> 
          "Plain", $CellContext`ReturnCreatesNewCell -> 
          True, $CellContext`DefaultReturnCreatedCellStyle -> "Answer"], 
         Cell[
          StyleData["Question", "Printout"], 
          CellMargins -> {{65, Inherited}, {2, 12}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Answer"], PageWidth :> 700, 
          CellMargins -> {{66, 10}, {4, 1}}, LineSpacing -> {1.125, 1., 2.}, 
          MenuSortingValue -> 10032, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0.25], $CellContext`ReturnCreatesNewCell -> 
          True, $CellContext`DefaultReturnCreatedCellStyle -> "Question"], 
         Cell[
          StyleData["Answer", "Printout"], 
          CellMargins -> {{66, 10}, {4, 1}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["QuestionNumber"], FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Bold", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["QuestionNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TechNoteSection"], PageWidth :> 700, 
          CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 18, FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["TechNoteSection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 30}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TechNote"], PageWidth :> 700, CellDingbat -> Cell[
            TextData[{"\[FilledSmallSquare]"}], FontSize -> 12, FontColor -> 
            GrayLevel[0.5]], CellMargins -> {{78, Inherited}, {4, 8}}, 
          CellChangeTimes -> {{3.651515120816633*^9, 3.651515125814807*^9}, 
            3.6515155174947033`*^9}, LineSpacing -> {1.25, 1., 2.}, 
          MenuSortingValue -> 10040, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0.25], $CellContext`ReturnCreatesNewCell -> 
          True], 
         Cell[
          StyleData["TechNote", "Printout"], 
          CellMargins -> {{82, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["MoreExploreSection"], PageWidth :> 700, 
          CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 18, FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["MoreExploreSection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 30}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["MoreExplore"], PageWidth :> 700, 
          CellMargins -> {{64, Inherited}, {4, 8}}, PageBreakBelow -> False, 
          MenuSortingValue -> 10050, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0], $CellContext`ReturnCreatesNewCell -> 
          True], 
         Cell[
          StyleData["MoreExplore", "Printout"], 
          CellMargins -> {{64, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["MoreExploreShortURL"], 
          CellMargins -> {{64, Inherited}, {4, 8}}, PageBreakBelow -> False, 
          FontFamily -> "Source Sans Pro Light", FontSize -> 14, FontSlant -> 
          "Plain", FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["MoreExploreShortURL", "Printout"], 
          CellMargins -> {{64, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Text"], CellMargins -> {{66, 10}, {4, 14}}, FontFamily -> 
          "Baskerville", FontSize -> 18, FontColor -> 
          GrayLevel[0], $CellContext`ReturnCreatesNewCell -> True], 
         Cell[
          StyleData["Text", "Printout"], CellMargins -> {{66, 10}, {7, 7}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ResourcesText"], CellMargins -> {{66, 10}, {2, 0}}, 
          FontFamily -> "Source Sans Pro", FontSize -> 14, FontWeight -> 
          "Plain", FontSlant -> "Plain", FontColor -> 
          GrayLevel[0], $CellContext`ReturnCreatesNewCell -> True], 
         Cell[
          StyleData["ResourcesText", "Printout"], 
          CellMargins -> {{66, 10}, {2, 0}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ResourcesLink"], CellMargins -> {{66, 10}, {2, 0}}, 
          FontFamily -> "Source Sans Pro", FontSize -> 14, FontWeight -> 
          "Plain", FontSlant -> "Italic", FontColor -> 
          GrayLevel[0], $CellContext`ReturnCreatesNewCell -> True], 
         Cell[
          StyleData["ResourcesLink", "Printout"], 
          CellMargins -> {{66, 10}, {2, 0}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["CodeCaption"], CellFrame -> {{0, 0}, {0, 0}}, 
          CellMargins -> {{66, 10}, {4, 12}}, PageBreakBelow -> False, 
          CellFrameColor -> GrayLevel[0.4], MenuSortingValue -> 10010, 
          MenuCommandKey :> "1", FontFamily -> "Source Sans Pro", FontSize -> 
          16, FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["CodeCaption", "Printout"], 
          CellMargins -> {{66, 10}, {4, 12}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Input"], CellMargins -> {{99, 10}, {3, 7}}, SpanMaxSize -> 
          1, FontSize -> 15], 
         Cell[
          StyleData["Input", "Printout"], CellMargins -> {{99, 10}, {3, 7}}]},
         Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Output"], CellMargins -> {{99, 10}, {14, 7}}, FontSize -> 
          15], 
         Cell[
          StyleData["Output", "Printout"], 
          CellMargins -> {{99, 10}, {14, 7}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["InputOnly"], CellMargins -> {{99, 10}, {25, 10}}, 
          SpanMaxSize -> 1, MenuSortingValue -> 1500, FontSize -> 15], 
         Cell[
          StyleData["InputOnly", "Printout"], 
          CellMargins -> {{99, 10}, {15, 10}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["CellLabel"], 
          CellLabelMargins -> {{12, Inherited}, {Inherited, Inherited}}, 
          LanguageCategory -> None, StyleMenuListing -> None, FontFamily -> 
          "Helvetica Neue", FontSize -> 9, FontWeight -> "Plain", FontSlant -> 
          "Plain", FontColor -> GrayLevel[0.5]], 
         Cell[
          StyleData["CellLabel", "Printout"], FontSize -> 8, FontColor -> 
          GrayLevel[0.5]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Message"], Editable -> False, 
          CellMargins -> {{66, Inherited}, {Inherited, Inherited}}, 
          CellGroupingRules -> "OutputGrouping", TextClipboardType -> 
          "PlainText", PageBreakWithin -> False, GroupPageBreakWithin -> 
          False, GeneratedCell -> True, CellAutoOverwrite -> True, 
          ShowCellLabel -> False, DefaultFormatType -> 
          DefaultOutputFormatType, ContextMenu -> 
          FEPrivate`FrontEndResource["ContextMenus", "Output"], 
          ShowAutoStyles -> False, ShowSyntaxStyles -> False, 
          AutoStyleOptions -> {
           "StringStyle" -> None, "SyntaxErrorStyle" -> None}, 
          HyphenationOptions -> {"HyphenationCharacter" -> "\[Continuation]"},
           AutoItalicWords -> {}, AutoQuoteCharacters -> {}, 
          PasteAutoQuoteCharacters -> {}, LanguageCategory -> None, 
          FormatType -> InputForm, ShowStringCharacters -> False, 
          CounterIncrements -> "Message", MenuSortingValue -> 1600, 
          StyleMenuListing -> None, FontFamily :> 
          CurrentValue["PanelFontFamily"], FontSize -> 11, FontColor -> 
          RGBColor[0.5072, 0.16933, 0.15221], $CellContext`StripStyleOnPaste -> 
          True], 
         Cell[
          StyleData["Message", "Printout"], 
          CellMargins -> {{100, Inherited}, {Inherited, Inherited}}, 
          CellFrameLabels -> {{None, None}, {None, None}}, FontColor -> 
          GrayLevel[0]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseInput", StyleDefinitions -> StyleData["Input"]], 
          CellMargins -> {{88, 10}, {4, 7}}, ShowCellLabel -> False, 
          SpanMaxSize -> 1, FontSize -> 
          14, $CellContext`GeneratedCellStyles -> {
           "Output" -> "ExerciseOutput"}], 
         Cell[
          StyleData["ExerciseInput", "Printout"], 
          CellMargins -> {{88, 10}, {4, 7}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "ExerciseOutput", StyleDefinitions -> StyleData["Output"]], 
          CellMargins -> {{88, 10}, {10, 4}}, ShowCellLabel -> False, 
          FontSize -> 14], 
         Cell[
          StyleData["ExerciseOutput", "Printout"], 
          CellMargins -> {{88, 10}, {10, 4}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Picture"], CellMargins -> {{66, 10}, {10, 10}}, 
          CellGroupingRules -> "GraphicsGrouping", StyleMenuListing -> None], 
         
         Cell[
          StyleData["Picture", "Printout"], 
          CellMargins -> {{66, 10}, {8, 8}}]}, Closed]], 
      Cell[
       StyleData["ExerciseSummaryCell"], PageWidth :> 700, CellFrame -> 0, 
       CellMargins -> {{64, Inherited}, {8, 10}}, 
       CellGroupingRules -> {"SectionGrouping", 64}, PageBreakBelow -> False, 
       ShowCellLabel -> False, CellFrameMargins -> 0, ShowStringCharacters -> 
       False, FontFamily -> "Source Sans Pro", FontSize -> 18, FontColor -> 
       RGBColor[1, 1, 1], 
       GridBoxOptions -> {GridBoxBackground -> {"Columns" -> {{
              RGBColor[0.990997, 0.539528, 0.155779], 
              RGBColor[0.989487, 0.434699, 0.0320439]}}, "Rows" -> {{None}}}, 
         GridBoxItemSize -> {"Columns" -> {
             Scaled[0.7], 
             Scaled[0.3]}, "Rows" -> {{Automatic}}}}], 
      Cell[
       StyleData["ExerciseSummaryHeading"], ShowStringCharacters -> False, 
       FontFamily -> "Source Sans Pro", FontSize -> 18, FontColor -> 
       RGBColor[1, 1, 1]], 
      Cell[
       StyleData["ExerciseSummarySubheading"], ShowStringCharacters -> False, 
       FontFamily -> "Source Sans Pro", FontSize -> 15, FontColor -> 
       RGBColor[1., 0.9294117647058824, 0.7215686274509804]], 
      Cell[
       StyleData["ExercisePreviewButtonText"], ShowStringCharacters -> False, 
       FontFamily -> "Source Sans Pro", FontSize -> 14, FontSlant -> "Plain", 
       FontColor -> RGBColor[0.6, 0.6, 0.6]], 
      Cell[
       StyleData["ExercisePreviewButtonTextHighlight"], ShowStringCharacters -> 
       False, FontFamily -> "Source Sans Pro", FontSize -> 14, FontSlant -> 
       "Plain", FontColor -> 
       RGBColor[
        0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]]}, 
     Open]], 
   Cell[
    CellGroupData[{
      Cell[
      "Inline and special formatting", "Section", 
       CellChangeTimes -> {{3.646681732592888*^9, 3.646681749414035*^9}}], 
      Cell[
       StyleData["Graphics"], MenuSortingValue -> None], 
      Cell[
       StyleData["Graphics3D"], MenuSortingValue -> None], 
      Cell[
       StyleData["StandardForm"], 
       InputAutoReplacements -> {
        "->" -> "\[Rule]", ":>" -> "\[RuleDelayed]", "<=" -> "\[LessEqual]", 
         ">=" -> "\[GreaterEqual]", "!=" -> "\[NotEqual]", "==" -> "\[Equal]",
          "@>" -> "\\[InlinePart]", "<->" -> "\[UndirectedEdge]", ParentList},
        LineSpacing -> {1.25, 0, 2}, SingleLetterItalics -> False, 
       StyleMenuListing -> None, FontFamily -> "Source Sans Pro", 
       PrivateFontOptions -> {"OperatorSubstitution" -> True}], 
      Cell[
       StyleData["OutputForm"], PageWidth :> DirectedInfinity[1], 
       TextAlignment -> Left, LineSpacing -> {0.6, 1}, 
       AutoQuoteCharacters -> {}, PasteAutoQuoteCharacters -> {}, 
       StyleMenuListing -> None, FontFamily -> "Source Sans Pro", 
       PrivateFontOptions -> {"OperatorSubstitution" -> True}], 
      Cell[
       StyleData["InputForm"], PageWidth :> DirectedInfinity[1], 
       InputAutoReplacements -> {}, AllowInlineCells -> False, Hyphenation -> 
       False, AutoQuoteCharacters -> {}, PasteAutoQuoteCharacters -> {}, 
       AutoSpacing -> False, NumberMarks -> True, AutoNumberFormatting -> 
       False, StyleMenuListing -> None, FontFamily -> "Source Sans Pro", 
       PrivateFontOptions -> {"OperatorSubstitution" -> True}], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["DetailsLink"], FontFamily -> "Source Sans Pro", FontSize :> 
          If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.9]], FontColor -> GrayLevel[0], 
          ButtonBoxOptions -> {
           ButtonFunction :> (
             Function[$CellContext`t, 
              NotebookFind[$CellContext`t, "Notes", All, CellStyle]; 
              NotebookFind[$CellContext`t, "NotesSection", All, CellStyle, 
                AutoScroll -> Top]][
              Documentation`HelpLookup[
               StringJoin["ref/", #]]]& ), ButtonSource -> ButtonContents, 
            Evaluator -> Automatic}], 
         Cell[
          StyleData["DetailsLink", "Printout"], FontFamily -> 
          "Source Sans Pro", FontSize :> If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.88]], FontColor -> GrayLevel[0]]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["LinkAlt"], FontFamily -> "Source Sans Pro", FontSize :> 
          If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.9]], FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["LinkAlt", "Printout"], FontFamily -> "Source Sans Pro", 
          FontSize :> If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.88]], FontColor -> GrayLevel[0]]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Hyperlink"], MenuSortingValue -> None, FontColor -> 
          RGBColor[0.3, 0.35, 0.5]], 
         Cell[
          StyleData["Hyperlink", "Printout"]]}, Closed]], 
      Cell[
       StyleData[
       "IndexNavigationLink", StyleDefinitions -> StyleData["Hyperlink"]], 
       MenuSortingValue -> None, FontColor -> 
       RGBColor[
        0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
      Cell[
       StyleData["Crosslink"], 
       ButtonBoxOptions -> {ButtonFunction :> (FrontEndExecute[{
            
            NotebookLocate[#2, "OpenInNewWindow" -> 
             CurrentValue["HyperlinkModifierKey"]]}]& ), Evaluator -> None, 
         Method -> "Queued"}], 
      Cell[
       StyleData["VocabularyLink"], FontColor -> GrayLevel[0], 
       ButtonBoxOptions -> {ButtonFunction :> (FrontEndExecute[{
            
            NotebookLocate[#2, "OpenInNewWindow" -> 
             CurrentValue["HyperlinkModifierKey"]]}]& ), Evaluator -> None, 
         Method -> "Queued"}], 
      Cell[
       StyleData["InlineCode"], SpanMaxSize -> 1, FontColor -> GrayLevel[0]], 
      
      Cell[
       StyleData["InlineCodeText"], SpanMaxSize -> 1, FontFamily -> 
       "Source Sans Pro", FontSize -> 0.95 Inherited], 
      Cell[
       StyleData["NoLabel"], ShowCellLabel -> 
       False, $CellContext`GeneratedCellStyles -> {
        "Output" -> "ExerciseOutput"}], 
      Cell[
       StyleData["MenuName"], FontFamily -> "Verdana", FontWeight -> "Bold", 
       FontColor -> GrayLevel[0.286275]], 
      Cell[
       StyleData["KeyEvent"], CellFrame -> {{0.5, 0.5}, {0.5, 0.5}}, 
       CellFrameMargins -> {{2, 2}, {2, 2}}, CellFrameColor -> GrayLevel[0.7],
        FontFamily -> "Verdana", FontColor -> GrayLevel[0.4]], 
      Cell[
       StyleData["KeyEventDelimiter"], FontColor -> GrayLevel[0.5]], 
      Cell[
       CellGroupData[{
         Cell["Key Styles", "Subsubsection"], 
         Cell[
          StyleData["Key0"], 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              TagBox[
               GridBox[{{
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> GrayLevel[1], StripOnInput -> 
                   False]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Center}}, "Rows" -> {{Baseline}}}, AutoDelete -> 
                False, GridBoxDividers -> {"Rows" -> {{None}}}, 
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{1.45}}},
                 GridBoxSpacings -> {"Columns" -> {{0}}}, 
                BaselinePosition -> {{1, 1}, Baseline}], "Grid"], 
              RoundingRadius -> 4, Background -> 
              GrayLevel[0.9333333333333333], 
              FrameMargins -> {{0, 0}, {-2, -2}}, FrameStyle -> {
                GrayLevel[0.8352941176470589], 
                AbsoluteThickness[1]}, BaselinePosition -> Baseline, 
              StripOnInput -> False]& )}], 
         Cell[
          StyleData["Key1"], 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              TagBox[
               GridBox[{{
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #2, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> GrayLevel[1], StripOnInput -> 
                   False]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Center}}, "Rows" -> {{Baseline}}}, AutoDelete -> 
                False, GridBoxDividers -> {
                 "ColumnsIndexed" -> {2 -> GrayLevel[0.8352941176470589]}, 
                  "Rows" -> {{None}}}, 
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{1.45}}},
                 GridBoxSpacings -> {"Columns" -> {{0}}}, 
                BaselinePosition -> {{1, 1}, Baseline}], "Grid"], 
              RoundingRadius -> 4, Background -> 
              GrayLevel[0.9333333333333333], 
              FrameMargins -> {{0, 0}, {-2, -2}}, FrameStyle -> {
                GrayLevel[0.8352941176470589], 
                AbsoluteThickness[1]}, BaselinePosition -> Baseline, 
              StripOnInput -> False]& )}], 
         Cell[
          StyleData["Key2"], 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              TagBox[
               GridBox[{{
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #2, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #3, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> GrayLevel[1], StripOnInput -> 
                   False]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Center}}, "Rows" -> {{Baseline}}}, AutoDelete -> 
                False, GridBoxDividers -> {
                 "ColumnsIndexed" -> {
                   2 -> GrayLevel[0.8352941176470589], 3 -> 
                    GrayLevel[0.8352941176470589]}, "Rows" -> {{None}}}, 
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{1.45}}},
                 GridBoxSpacings -> {"Columns" -> {{0}}}, 
                BaselinePosition -> {{1, 1}, Baseline}], "Grid"], 
              RoundingRadius -> 4, Background -> 
              GrayLevel[0.9333333333333333], 
              FrameMargins -> {{0, 0}, {-2, -2}}, FrameStyle -> {
                GrayLevel[0.8352941176470589], 
                AbsoluteThickness[1]}, BaselinePosition -> Baseline, 
              StripOnInput -> False]& )}], 
         Cell[
          StyleData["Key3"], 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              TagBox[
               GridBox[{{
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #2, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #3, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #4, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> GrayLevel[1], StripOnInput -> 
                   False]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Center}}, "Rows" -> {{Baseline}}}, AutoDelete -> 
                False, GridBoxDividers -> {
                 "ColumnsIndexed" -> {
                   2 -> GrayLevel[0.8352941176470589], 3 -> 
                    GrayLevel[0.8352941176470589], 4 -> 
                    GrayLevel[0.8352941176470589]}, "Rows" -> {{None}}}, 
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{1.45}}},
                 GridBoxSpacings -> {"Columns" -> {{0}}}, 
                BaselinePosition -> {{1, 1}, Baseline}], "Grid"], 
              RoundingRadius -> 4, Background -> 
              GrayLevel[0.9333333333333333], 
              FrameMargins -> {{0, 0}, {-2, -2}}, FrameStyle -> {
                GrayLevel[0.8352941176470589], 
                AbsoluteThickness[1]}, BaselinePosition -> Baseline, 
              StripOnInput -> False]& )}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell["Entity styles", "Subsubsection"], 
         Cell[
          StyleData["Entity"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              FrameBox[
               PaneSelectorBox[{True -> GridBox[{{
                    
                    StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]], 
                    StyleBox[
                    RowBox[{"(", #4, ")"}], FontFamily -> "Source Sans Pro", 
                    FontWeight -> "Plain", FontColor -> GrayLevel[0.65], 
                    Selectable -> False]}}, 
                   GridBoxItemSize -> {
                    "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                   GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}},
                    BaselinePosition -> {1, 1}], False -> 
                 PaneBox[#, 
                   BaseStyle -> {
                    FontColor -> RGBColor[0.395437, 0.20595, 0.061158]}, 
                   BaselinePosition -> Baseline]}, 
                Dynamic[
                 CurrentValue[Evaluatable]], ImageSize -> Automatic, 
                BaselinePosition -> Baseline, 
                BaseStyle -> {FontFamily -> "Helvetica"}], FrameStyle -> 
               RGBColor[1., 0.504768, 0.], Background -> 
               RGBColor[1., 0.980392, 0.921569], 
               FrameMargins -> {{5, 5}, {1.5, 1.5}}, 
               ImageMargins -> {{2, 2}, {2, 2}}, BaselinePosition -> Baseline,
                RoundingRadius -> 4], #3, 
              BaseStyle -> {
               FontWeight -> "Plain", ShowStringCharacters -> False, 
                LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityFrameless"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              PaneSelectorBox[{True -> GridBox[{{
                    
                    StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]], 
                    StyleBox[
                    RowBox[{"(", #4, ")"}], FontFamily -> "Source Sans Pro", 
                    FontWeight -> "Plain", FontColor -> GrayLevel[0.65], 
                    Selectable -> False]}}, 
                  GridBoxItemSize -> {
                   "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                  BaselinePosition -> {1, 1}], False -> 
                PaneBox[#, 
                  BaseStyle -> {
                   FontColor -> RGBColor[0.395437, 0.20595, 0.061158]}, 
                  BaselinePosition -> Baseline]}, 
               Dynamic[
                CurrentValue[Evaluatable]], ImageSize -> Automatic, 
               BaselinePosition -> Baseline, 
               BaseStyle -> {FontFamily -> "Helvetica"}], #3, 
              BaseStyle -> {
               ShowStringCharacters -> False, LineIndent -> 0, 
                PrivateFontOptions -> {
                 FontWeight -> "Plain", "OperatorSubstitution" -> False}}]& ),
             Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityFramelessHot"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {
           DisplayFunction -> (PaneSelectorBox[{True -> GridBox[{{
                   
                   StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0]], 
                   StyleBox[
                    RowBox[{"(", #4, ")"}], FontWeight -> "Plain", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0], Selectable -> 
                    False]}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                 BaselinePosition -> {1, 1}], False -> 
               PaneBox[#, BaseStyle -> {FontColor -> GrayLevel[0]}, 
                 BaselinePosition -> Baseline]}, 
              Dynamic[
               CurrentValue[Evaluatable]], ImageSize -> Automatic, 
              BaselinePosition -> Baseline, 
              BaseStyle -> {
               FontWeight -> "Plain", FontFamily -> "Helvetica", 
                ShowStringCharacters -> False, LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityClass"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              FrameBox[
               PaneSelectorBox[{True -> GridBox[{{
                    PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                    
                    StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]], 
                    StyleBox[
                    RowBox[{"(", #4, ")"}], FontWeight -> "Plain", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0.65], 
                    Selectable -> False]}}, 
                   GridBoxItemSize -> {
                    "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                   GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}},
                    BaselinePosition -> {1, 2}], False -> GridBox[{{
                    PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                    
                    StyleBox[#, FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]]}}, 
                   GridBoxItemSize -> {
                    "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                   GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}},
                    BaselinePosition -> {1, 2}]}, 
                Dynamic[
                 CurrentValue[Evaluatable]], ImageSize -> Automatic, 
                BaselinePosition -> Baseline, 
                BaseStyle -> {FontFamily -> "Helvetica"}], FrameStyle -> 
               RGBColor[1., 0.504768, 0.], Background -> 
               RGBColor[1., 0.980392, 0.921569], 
               FrameMargins -> {{5, 5}, {1.5, 1.5}}, 
               ImageMargins -> {{2, 2}, {2, 2}}, BaselinePosition -> Baseline,
                RoundingRadius -> 4], #3, 
              BaseStyle -> {
               FontWeight -> "Plain", ShowStringCharacters -> False, 
                LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityClassFrameless"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              PaneSelectorBox[{True -> GridBox[{{
                    PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                    
                    StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]], 
                    StyleBox[
                    RowBox[{"(", #4, ")"}], FontWeight -> "Plain", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0.65], 
                    Selectable -> False]}}, 
                  GridBoxItemSize -> {
                   "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                  BaselinePosition -> {1, 2}], False -> GridBox[{{
                    PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                    
                    StyleBox[#, FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]]}}, 
                  GridBoxItemSize -> {
                   "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                  BaselinePosition -> {1, 2}]}, 
               Dynamic[
                CurrentValue[Evaluatable]], ImageSize -> Automatic, 
               BaselinePosition -> Baseline, 
               BaseStyle -> {FontFamily -> "Helvetica"}], #3, 
              BaseStyle -> {
               FontWeight -> "Plain", ShowStringCharacters -> False, 
                LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityClassFramelessHot"], ShowStringCharacters -> False,
           TemplateBoxOptions -> {
           DisplayFunction -> (PaneSelectorBox[{True -> GridBox[{{
                   PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                   
                   StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0]], 
                   StyleBox[
                    RowBox[{"(", #4, ")"}], FontWeight -> "Plain", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0], Selectable -> 
                    False]}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                 BaselinePosition -> {1, 2}], False -> GridBox[{{
                   PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                   StyleBox[#, FontColor -> GrayLevel[0]]}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                 BaselinePosition -> {1, 2}]}, 
              Dynamic[
               CurrentValue[Evaluatable]], ImageSize -> Automatic, 
              BaselinePosition -> Baseline, 
              BaseStyle -> {
               FontWeight -> "Plain", FontFamily -> "Helvetica", 
                ShowStringCharacters -> False, LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityProperty"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              FrameBox[
               
               PaneBox[#, 
                BaseStyle -> {
                 FontSlant -> Italic, FontWeight -> Plain, FontFamily -> 
                  "Source Sans Pro", FontColor -> 
                  RGBColor[0.395437, 0.20595, 0.061158]}, BaselinePosition -> 
                Baseline], FrameStyle -> 
               RGBColor[0.94227, 0.703639, 0.033387], Background -> 
               RGBColor[1., 0.980392, 0.921569], 
               FrameMargins -> {{5, 5}, {1.5, 1.5}}, 
               ImageMargins -> {{2, 2}, {2, 2}}, BaselinePosition -> Baseline,
                RoundingRadius -> 4], #3, 
              BaseStyle -> {
               FontWeight -> "Plain", ShowStringCharacters -> False, 
                LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityPropertyClass"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              FrameBox[
               PaneBox[
                GridBox[{{
                   PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], #}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                 BaselinePosition -> {1, 2}], 
                BaseStyle -> {
                 FontSlant -> Italic, FontWeight -> Plain, FontFamily -> 
                  "Source Sans Pro", FontColor -> 
                  RGBColor[0.395437, 0.20595, 0.061158]}, BaselinePosition -> 
                Baseline], FrameStyle -> 
               RGBColor[0.94227, 0.703639, 0.033387], Background -> 
               RGBColor[1., 0.980392, 0.921569], 
               FrameMargins -> {{5, 5}, {1.5, 1.5}}, 
               ImageMargins -> {{2, 2}, {2, 2}}, BaselinePosition -> Baseline,
                RoundingRadius -> 4], #3, 
              BaseStyle -> {
               FontWeight -> "Plain", ShowStringCharacters -> False, 
                LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityValue"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              
              GridBox[{{#, #2}}, GridBoxAlignment -> {"Rows" -> {{Baseline}}},
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}}, 
               GridBoxSpacings -> {"Columns" -> {{0}}}, 
               BaselinePosition -> {1, 1}], Background -> 
              RGBColor[{0.9921568627450981, 0.9529411764705882, 
                0.8509803921568627}], BaselinePosition -> Baseline, 
              FrameMargins -> {{1, 1}, {1, 1}}, ImageMargins -> 2, FrameStyle -> 
              RGBColor[{0.9333333333333333, 0.8470588235294118, 
                0.5529411764705883}], RoundingRadius -> 5]& )}]}, Closed]]}, 
     Closed]]}, Visible -> False, FrontEndVersion -> 
  "12.3 for Mac OS X x86 (64-bit) (July 30, 2021)", StyleDefinitions -> 
  "StylesheetFormatting.nb"],
ExpressionUUID->"6370fddb-c50c-42d8-aa50-0586d25a05a2"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "p:115"->{
  Cell[664, 24, 463, 11, 93, "SectionDoubleDigit",ExpressionUUID->"81328702-d886-480a-a64e-619cfa227ee7",
   CounterAssignments->{{"Section", 20}, {"Subsection", 0}, {"Subsubsection", 0}, {"Exercise", 0}, {"Question", 0}},
   CellTags->"p:115"]},
 "i:1"->{
  Cell[1130, 37, 343, 10, 65, "Text",ExpressionUUID->"ff4922e1-7678-43a5-9368-2588d7cc805b",
   CellTags->"i:1"]},
 "i:2"->{
  Cell[3721, 113, 244, 5, 37, "CodeCaption",ExpressionUUID->"50dc86c9-1be8-4aaf-aa0b-835113745ff5",
   CellTags->"i:2"]},
 "i:3"->{
  Cell[6322, 179, 248, 7, 40, "Text",ExpressionUUID->"90ed244e-c8af-40d2-983a-8b58c5bec411",
   CellTags->"i:3"]},
 "i:4"->{
  Cell[6573, 188, 197, 4, 37, "CodeCaption",ExpressionUUID->"abe4463c-0e1a-424e-9c9a-fd7bb1eef0e7",
   CellTags->"i:4"]},
 "LastCellOfAPage"->{
  Cell[13075, 348, 553, 11, 70, "Text",ExpressionUUID->"c33931ad-8df9-4d7b-900c-a5c5e5956f96",
   CellTags->"LastCellOfAPage"],
  Cell[22805, 634, 587, 16, 70, "Output",ExpressionUUID->"662b2a72-edeb-437e-bc03-efb3dcb5e61a",
   Evaluatable->False,
   CellTags->"LastCellOfAPage"],
  Cell[50197, 1187, 6956, 130, 70, "Output",ExpressionUUID->"7cb41b6d-2d86-4b63-8da0-0feed542e102",
   Evaluatable->False,
   CellTags->"LastCellOfAPage"],
  Cell[66181, 1523, 41070, 725, 70, "Output",ExpressionUUID->"13ab11a5-322c-4ac7-a349-f1061a8d2d71",
   Evaluatable->False,
   CellTags->"LastCellOfAPage"],
  Cell[133198, 2740, 2531, 69, 70, "VocabularyTable",ExpressionUUID->"aa990fbb-71e1-4f80-af66-4cb6ff8868a6",
   CellTags->"LastCellOfAPage"],
  Cell[701003, 13725, 1233, 44, 70, "Answer",ExpressionUUID->"f56415a7-fd0c-4d7d-80d3-c7ed18753de0",
   CellTags->{"LastCellOfAPage", "i:18"}],
  Cell[705999, 13900, 351, 8, 70, "MoreExplore",ExpressionUUID->"ceb37b4b-1dd7-4223-a941-e264d9b05177",
   CellTags->"LastCellOfAPage"]},
 "p:116"->{
  Cell[13631, 361, 383, 9, 70, "Text",ExpressionUUID->"e22cb62e-4482-417d-9a70-2ca77e871e88",
   CellTags->{"p:116", "i:5"}]},
 "i:5"->{
  Cell[13631, 361, 383, 9, 70, "Text",ExpressionUUID->"e22cb62e-4482-417d-9a70-2ca77e871e88",
   CellTags->{"p:116", "i:5"}]},
 "i:6"->{
  Cell[14017, 372, 238, 6, 70, "CodeCaption",ExpressionUUID->"fe3704ce-ad9d-4d5b-b088-60bc7247d47b",
   CellTags->"i:6"]},
 "i:7"->{
  Cell[17843, 463, 280, 7, 70, "Text",ExpressionUUID->"581def16-70d8-44c3-9072-27db580f7e6f",
   CellTags->"i:7"]},
 "i:8"->{
  Cell[20713, 561, 463, 14, 70, "Text",ExpressionUUID->"571c6de3-3f45-4dab-bb16-67745077473b",
   CellTags->"i:8"]},
 "p:117"->{
  Cell[23407, 653, 196, 4, 70, "CodeCaption",ExpressionUUID->"d0a78463-0c69-4725-bb52-2613c170905f",
   CellTags->"p:117"]},
 "i:9"->{
  Cell[28849, 774, 211, 4, 70, "CodeCaption",ExpressionUUID->"d2a81e48-6e99-4bfe-99ed-1df4729db166",
   CellTags->"i:9"]},
 "i:10"->{
  Cell[49207, 1156, 309, 7, 70, "Text",ExpressionUUID->"4b1958e1-1ef6-4075-aa0f-4aa0ad1223f4",
   CellTags->"i:10"]},
 "i:11"->{
  Cell[49519, 1165, 244, 5, 70, "CodeCaption",ExpressionUUID->"abe9b686-97f8-4a6e-a032-8cc12aa1f3e7",
   CellTags->"i:11"]},
 "p:118"->{
  Cell[57168, 1320, 310, 8, 70, "Text",ExpressionUUID->"ba8749b6-394d-42c5-a979-0bdca355932e",
   CellTags->{"p:118", "i:12"}]},
 "i:12"->{
  Cell[57168, 1320, 310, 8, 70, "Text",ExpressionUUID->"ba8749b6-394d-42c5-a979-0bdca355932e",
   CellTags->{"p:118", "i:12"}]},
 "p:119"->{
  Cell[107266, 2251, 494, 11, 70, "Text",ExpressionUUID->"a1702fa8-1fd2-4352-beaa-d5775c4478d1",
   CellTags->{"p:119", "i:13"}]},
 "i:13"->{
  Cell[107266, 2251, 494, 11, 70, "Text",ExpressionUUID->"a1702fa8-1fd2-4352-beaa-d5775c4478d1",
   CellTags->{"p:119", "i:13"}]},
 "i:14"->{
  Cell[107763, 2264, 264, 5, 70, "CodeCaption",ExpressionUUID->"8955f7b3-b002-4403-a921-f157958364ff",
   CellTags->"i:14"]},
 "i:15"->{
  Cell[698063, 13630, 199, 4, 70, "Question",ExpressionUUID->"f0ad2894-b414-45d1-9166-263c4ed227b4",
   CellTags->"i:15"]},
 "i:16"->{
  Cell[698976, 13661, 493, 14, 70, "Answer",ExpressionUUID->"77d250fa-bdda-4e6e-86a1-be7edd787d2e",
   CellTags->"i:16"]},
 "i:17"->{
  Cell[699472, 13677, 195, 4, 70, "Question",ExpressionUUID->"4aef5864-0921-4caa-b37b-051d203a96e0",
   CellTags->"i:17"]},
 "i:18"->{
  Cell[701003, 13725, 1233, 44, 70, "Answer",ExpressionUUID->"f56415a7-fd0c-4d7d-80d3-c7ed18753de0",
   CellTags->{"LastCellOfAPage", "i:18"}]},
 "p:121"->{
  Cell[702273, 13774, 174, 4, 70, "TechNoteSection",ExpressionUUID->"b61b4f26-75d8-4f43-802b-2f2392613ce1",
   CellTags->"p:121"]},
 "i:19"->{
  Cell[703083, 13803, 874, 29, 70, "TechNote",ExpressionUUID->"b54d8ed2-b5e1-436a-abef-71162197d24c",
   CellTags->"i:19"]},
 "i:20"->{
  Cell[703960, 13834, 665, 19, 70, "TechNote",ExpressionUUID->"082d5a70-91eb-4b2d-838e-272449ddb273",
   CellTags->"i:20"]},
 "i:21"->{
  Cell[704628, 13855, 684, 19, 70, "TechNote",ExpressionUUID->"dbed4faa-d17a-47bd-a75a-a67e9ac75446",
   CellTags->"i:21"]},
 "i:22"->{
  Cell[705315, 13876, 479, 13, 70, "TechNote",ExpressionUUID->"ce23b07e-c33c-439c-b956-09005a376cfe",
   CellTags->"i:22"]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"p:115", 796960, 15745},
 {"i:1", 797217, 15749},
 {"i:2", 797342, 15752},
 {"i:3", 797474, 15755},
 {"i:4", 797599, 15758},
 {"LastCellOfAPage", 797743, 15761},
 {"p:116", 798773, 15779},
 {"i:5", 798910, 15782},
 {"i:6", 799047, 15785},
 {"i:7", 799180, 15788},
 {"i:8", 799306, 15791},
 {"p:117", 799435, 15794},
 {"i:9", 799570, 15797},
 {"i:10", 799704, 15800},
 {"i:11", 799833, 15803},
 {"p:118", 799970, 15806},
 {"i:12", 800110, 15809},
 {"p:119", 800251, 15812},
 {"i:13", 800393, 15815},
 {"i:14", 800535, 15818},
 {"i:15", 800672, 15821},
 {"i:16", 800807, 15824},
 {"i:17", 800941, 15827},
 {"i:18", 801076, 15830},
 {"p:121", 801233, 15833},
 {"i:19", 801376, 15836},
 {"i:20", 801512, 15839},
 {"i:21", 801648, 15842},
 {"i:22", 801784, 15845}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[664, 24, 463, 11, 93, "SectionDoubleDigit",ExpressionUUID->"81328702-d886-480a-a64e-619cfa227ee7",
 CounterAssignments->{{"Section", 20}, {"Subsection", 0}, {"Subsubsection", 0}, {"Exercise", 0}, {"Question", 0}},
 CellTags->"p:115"],
Cell[1130, 37, 343, 10, 65, "Text",ExpressionUUID->"ff4922e1-7678-43a5-9368-2588d7cc805b",
 CellTags->"i:1"],
Cell[1476, 49, 578, 16, 66, "Text",ExpressionUUID->"213dbfd8-b317-4b65-8830-1ebd08d40e57"],
Cell[2057, 67, 179, 4, 37, "CodeCaption",ExpressionUUID->"6593ec6b-93ad-4b3f-b906-2452d1d942e5"],
Cell[CellGroupData[{
Cell[2261, 75, 305, 8, 29, "Input",ExpressionUUID->"96adfee2-c9cd-437a-bab1-91a649875917"],
Cell[2569, 85, 1137, 25, 40, "Output",ExpressionUUID->"32804589-04e0-403a-a286-098169f01efe",
 Evaluatable->False]
}, Open  ]],
Cell[3721, 113, 244, 5, 37, "CodeCaption",ExpressionUUID->"50dc86c9-1be8-4aaf-aa0b-835113745ff5",
 CellTags->"i:2"],
Cell[CellGroupData[{
Cell[3990, 122, 376, 10, 29, "Input",ExpressionUUID->"e5dfd890-97f5-4ccb-87ff-703fe20a1097"],
Cell[4369, 134, 1938, 42, 46, "Output",ExpressionUUID->"ecd10cbe-4710-4dbf-8832-50cf4d3e2a98",
 Evaluatable->False]
}, Open  ]],
Cell[6322, 179, 248, 7, 40, "Text",ExpressionUUID->"90ed244e-c8af-40d2-983a-8b58c5bec411",
 CellTags->"i:3"],
Cell[6573, 188, 197, 4, 37, "CodeCaption",ExpressionUUID->"abe4463c-0e1a-424e-9c9a-fd7bb1eef0e7",
 CellTags->"i:4"],
Cell[CellGroupData[{
Cell[6795, 196, 418, 11, 29, "Input",ExpressionUUID->"2f876efa-0d7a-4412-91b7-0b16532b3e31"],
Cell[7216, 209, 2155, 47, 225, "Output",ExpressionUUID->"2907b1cc-55af-4e44-8d4f-2c36a35d8a92",
 Evaluatable->False]
}, Open  ]],
Cell[9386, 259, 220, 6, 37, "CodeCaption",ExpressionUUID->"b7dba443-da80-42a9-854c-f4e37fce4dfe"],
Cell[CellGroupData[{
Cell[9631, 269, 502, 13, 70, "Input",ExpressionUUID->"26ff87a0-6198-400c-8897-9cbd4e24c3d8"],
Cell[10136, 284, 2924, 61, 70, "Output",ExpressionUUID->"de8abea1-9f16-4a20-954c-ed53471aca32",
 Evaluatable->False]
}, Open  ]],
Cell[13075, 348, 553, 11, 70, "Text",ExpressionUUID->"c33931ad-8df9-4d7b-900c-a5c5e5956f96",
 CellTags->"LastCellOfAPage"],
Cell[13631, 361, 383, 9, 70, "Text",ExpressionUUID->"e22cb62e-4482-417d-9a70-2ca77e871e88",
 CellTags->{"p:116", "i:5"}],
Cell[14017, 372, 238, 6, 70, "CodeCaption",ExpressionUUID->"fe3704ce-ad9d-4d5b-b088-60bc7247d47b",
 CellTags->"i:6"],
Cell[CellGroupData[{
Cell[14280, 382, 580, 15, 70, "Input",ExpressionUUID->"15d94fa9-d725-41a5-9aaa-8455b0241074"],
Cell[14863, 399, 2965, 61, 70, "Output",ExpressionUUID->"3f379b89-ceaa-497c-a07a-8a9312575955",
 Evaluatable->False]
}, Open  ]],
Cell[17843, 463, 280, 7, 70, "Text",ExpressionUUID->"581def16-70d8-44c3-9072-27db580f7e6f",
 CellTags->"i:7"],
Cell[18126, 472, 203, 5, 70, "CodeCaption",ExpressionUUID->"b5c67abe-0a16-4057-9c1a-5e69940715b7"],
Cell[CellGroupData[{
Cell[18354, 481, 524, 14, 70, "Input",ExpressionUUID->"f95c1f12-b3f3-4ab2-a356-4500459e2f4d"],
Cell[18881, 497, 227, 6, 70, "Output",ExpressionUUID->"85359688-0098-4dfd-b310-abfb5cdb9409",
 Evaluatable->False]
}, Open  ]],
Cell[19123, 506, 314, 8, 70, "Text",ExpressionUUID->"3f013417-679e-4ebe-b21f-65379cb1d4c4"],
Cell[19440, 516, 222, 6, 70, "CodeCaption",ExpressionUUID->"75e1fd8f-b9c3-492e-88bf-163c6a5db753"],
Cell[CellGroupData[{
Cell[19687, 526, 316, 9, 70, "Input",ExpressionUUID->"d1ee5a13-a890-4531-a943-860d4c4290fe"],
Cell[20006, 537, 692, 21, 70, "Output",ExpressionUUID->"6abba896-68ce-48a2-8099-29a56c4259d5",
 Evaluatable->False]
}, Open  ]],
Cell[20713, 561, 463, 14, 70, "Text",ExpressionUUID->"571c6de3-3f45-4dab-bb16-67745077473b",
 CellTags->"i:8"],
Cell[21179, 577, 300, 9, 70, "CodeCaption",ExpressionUUID->"8d48977e-e83a-4fff-8c94-9e5e8f33e501"],
Cell[CellGroupData[{
Cell[21504, 590, 373, 10, 70, "Input",ExpressionUUID->"3fd4b0b9-25f0-4261-ae6c-6c5e5d476d8e"],
Cell[21880, 602, 283, 8, 70, "Output",ExpressionUUID->"cd49886e-6e59-4e6a-911d-59d51e6b06cf",
 Evaluatable->False]
}, Open  ]],
Cell[22178, 613, 243, 5, 70, "CodeCaption",ExpressionUUID->"15d4f96d-a8b6-4c01-9618-348414091552"],
Cell[CellGroupData[{
Cell[22446, 622, 356, 10, 70, "Input",ExpressionUUID->"5bf21a96-4fcf-4093-bc28-7959701f3698"],
Cell[22805, 634, 587, 16, 70, "Output",ExpressionUUID->"662b2a72-edeb-437e-bc03-efb3dcb5e61a",
 Evaluatable->False,
 CellTags->"LastCellOfAPage"]
}, Open  ]],
Cell[23407, 653, 196, 4, 70, "CodeCaption",ExpressionUUID->"d0a78463-0c69-4725-bb52-2613c170905f",
 CellTags->"p:117"],
Cell[CellGroupData[{
Cell[23628, 661, 470, 13, 70, "Input",ExpressionUUID->"519027aa-f4a0-493b-9023-15501e6d5793"],
Cell[24101, 676, 4733, 95, 70, "Output",ExpressionUUID->"8e802e04-56ab-4d1f-978e-5188fa2c935d",
 Evaluatable->False]
}, Open  ]],
Cell[28849, 774, 211, 4, 70, "CodeCaption",ExpressionUUID->"d2a81e48-6e99-4bfe-99ed-1df4729db166",
 CellTags->"i:9"],
Cell[CellGroupData[{
Cell[29085, 782, 396, 11, 70, "Input",ExpressionUUID->"db10238b-4115-46ce-bd6e-06fd845cf578"],
Cell[29484, 795, 19708, 358, 70, "Output",ExpressionUUID->"e87a60a1-8d6d-42d1-b3b0-505f6f9614a2",
 Evaluatable->False]
}, Open  ]],
Cell[49207, 1156, 309, 7, 70, "Text",ExpressionUUID->"4b1958e1-1ef6-4075-aa0f-4aa0ad1223f4",
 CellTags->"i:10"],
Cell[49519, 1165, 244, 5, 70, "CodeCaption",ExpressionUUID->"abe9b686-97f8-4a6e-a032-8cc12aa1f3e7",
 CellTags->"i:11"],
Cell[CellGroupData[{
Cell[49788, 1174, 406, 11, 70, "Input",ExpressionUUID->"2975aaa3-6bd8-4996-8b59-c1351bd92f4d"],
Cell[50197, 1187, 6956, 130, 70, "Output",ExpressionUUID->"7cb41b6d-2d86-4b63-8da0-0feed542e102",
 Evaluatable->False,
 CellTags->"LastCellOfAPage"]
}, Open  ]],
Cell[57168, 1320, 310, 8, 70, "Text",ExpressionUUID->"ba8749b6-394d-42c5-a979-0bdca355932e",
 CellTags->{"p:118", "i:12"}],
Cell[57481, 1330, 238, 7, 70, "CodeCaption",ExpressionUUID->"e1f7c7dd-549f-490d-bd66-0d94c38613ac"],
Cell[CellGroupData[{
Cell[57744, 1341, 403, 10, 70, "Input",ExpressionUUID->"29e446ff-3bd2-4ce3-a0c0-77cb1698b9c3"],
Cell[58150, 1353, 7158, 137, 70, "Output",ExpressionUUID->"a9f0ac53-937b-47a4-a489-ddfe47f7de7a",
 Evaluatable->False]
}, Open  ]],
Cell[65323, 1493, 252, 7, 70, "Text",ExpressionUUID->"1c26fe8d-239a-41bb-8793-07e76cbc40f6"],
Cell[65578, 1502, 173, 4, 70, "CodeCaption",ExpressionUUID->"0f79d6de-cd9f-4233-aa5b-a7c7d5a9ca71"],
Cell[CellGroupData[{
Cell[65776, 1510, 402, 11, 70, "Input",ExpressionUUID->"d45fd0cd-3f76-45d5-942a-283c2dd96f6c"],
Cell[66181, 1523, 41070, 725, 70, "Output",ExpressionUUID->"13ab11a5-322c-4ac7-a349-f1061a8d2d71",
 Evaluatable->False,
 CellTags->"LastCellOfAPage"]
}, Open  ]],
Cell[107266, 2251, 494, 11, 70, "Text",ExpressionUUID->"a1702fa8-1fd2-4352-beaa-d5775c4478d1",
 CellTags->{"p:119", "i:13"}],
Cell[107763, 2264, 264, 5, 70, "CodeCaption",ExpressionUUID->"8955f7b3-b002-4403-a921-f157958364ff",
 CellTags->"i:14"],
Cell[CellGroupData[{
Cell[108052, 2273, 10094, 177, 70, "Input",ExpressionUUID->"bafa07e2-a577-460c-8abf-94fc6caf6ae2"],
Cell[118149, 2452, 14489, 266, 70, "Output",ExpressionUUID->"91c2e387-fc26-4ae4-96fe-3fcb85d0d8f9",
 Evaluatable->False]
}, Open  ]],
Cell[132653, 2721, 346, 8, 70, "Text",ExpressionUUID->"1859df01-7e4d-4214-bd6d-03e2a47223cb"]
}, Open  ]],
Cell[CellGroupData[{
Cell[133036, 2734, 159, 4, 70, "VocabularySection",ExpressionUUID->"3fde2de1-80fb-4625-b55d-a0ee90c6423f"],
Cell[133198, 2740, 2531, 69, 70, "VocabularyTable",ExpressionUUID->"aa990fbb-71e1-4f80-af66-4cb6ff8868a6",
 CellTags->"LastCellOfAPage"]
}, Open  ]],
Cell[CellGroupData[{
Cell[135766, 2814, 1780, 46, 70, "ExerciseSection",ExpressionUUID->"0b557a52-d63c-41ff-99f1-562e2db62131"],
Cell[CellGroupData[{
Cell[137571, 2864, 1454, 45, 70, "ExerciseSummaryCell",ExpressionUUID->"896ddd81-efe7-4605-b8a8-5b414487834b"],
Cell[CellGroupData[{
Cell[139050, 2913, 710, 20, 70, "Exercise",ExpressionUUID->"56a1d729-410c-44f8-9bd0-e6235e51ebce"],
Cell[139763, 2935, 3625, 86, 70, "ExerciseOutput",ExpressionUUID->"b31bacad-03dd-4527-b4e9-6c6c82f2d312"]
}, Closed]],
Cell[CellGroupData[{
Cell[143425, 3026, 724, 20, 70, "Exercise",ExpressionUUID->"38764a98-65cb-4e71-9f6f-1dfec92ddb95"],
Cell[144152, 3048, 21191, 404, 70, "ExerciseOutput",ExpressionUUID->"fd329010-db9b-48fc-8e08-78332a538c4b"]
}, Closed]],
Cell[CellGroupData[{
Cell[165380, 3457, 762, 21, 70, "Exercise",ExpressionUUID->"5164f0c2-6235-43fa-88aa-0ea2f4048342"],
Cell[166145, 3480, 138544, 2487, 70, "ExerciseOutput",ExpressionUUID->"6fa0bbf8-49fc-408d-a885-8e238c598472"]
}, Closed]],
Cell[CellGroupData[{
Cell[304726, 5972, 964, 31, 70, "Exercise",ExpressionUUID->"b0a0586b-f467-4ae2-a6b6-45537f676447"],
Cell[305693, 6005, 1278, 36, 70, "ExerciseOutput",ExpressionUUID->"18d6d92d-b61e-4e48-a032-011a1e80f603"]
}, Closed]],
Cell[CellGroupData[{
Cell[307008, 6046, 796, 21, 70, "Exercise",ExpressionUUID->"857538c5-7f7f-4d1a-8633-053fec85ee6f"],
Cell[307807, 6069, 4580, 102, 70, "ExerciseOutput",ExpressionUUID->"fb250656-7f69-44c3-8b78-2cefca884e7d"]
}, Closed]],
Cell[CellGroupData[{
Cell[312424, 6176, 944, 27, 70, "Exercise",ExpressionUUID->"7ba93278-e055-424b-9351-a9d437514dea"],
Cell[313371, 6205, 11630, 225, 70, "ExerciseOutput",ExpressionUUID->"3dcf0ce5-4f77-479d-ba40-52da0d314991"]
}, Closed]],
Cell[CellGroupData[{
Cell[325038, 6435, 1022, 30, 70, "Exercise",ExpressionUUID->"c1ad6ad5-1d8a-4e9e-966e-dd6e77cfbba5"],
Cell[326063, 6467, 18987, 348, 70, "ExerciseOutput",ExpressionUUID->"21d3bc8c-c0be-4e5f-b454-195270b3bc51"]
}, Closed]],
Cell[CellGroupData[{
Cell[345087, 6820, 1165, 33, 70, "Exercise",ExpressionUUID->"69de389f-a2ad-4d7f-b896-016314867ef3"],
Cell[346255, 6855, 17276, 329, 70, "ExerciseOutput",ExpressionUUID->"9f887348-9c5f-4856-9394-adaad287a931"]
}, Closed]],
Cell[CellGroupData[{
Cell[363568, 7189, 757, 21, 70, "Exercise",ExpressionUUID->"7f09311c-6962-409d-b15b-707906666b25"],
Cell[364328, 7212, 33477, 603, 70, "ExerciseOutput",ExpressionUUID->"7ef34418-1ffc-4431-acb5-81cf438a42b6"]
}, Closed]],
Cell[CellGroupData[{
Cell[397842, 7820, 746, 21, 70, "Exercise",ExpressionUUID->"7a1571a5-b06d-473c-bef0-b6fec71e0222"],
Cell[398591, 7843, 57594, 1013, 70, "ExerciseOutput",ExpressionUUID->"8143878f-bb79-4b8e-b4df-d6bb93655dcc"]
}, Closed]],
Cell[CellGroupData[{
Cell[456222, 8861, 1580, 50, 70, "Exercise",ExpressionUUID->"b2c2068a-c694-4ae7-bca5-c38ba167858f"],
Cell[457805, 8913, 3679, 101, 70, "ExerciseOutput",ExpressionUUID->"7529080c-e3f6-446c-a388-8bd3e14a9156"]
}, Closed]],
Cell[CellGroupData[{
Cell[461521, 9019, 779, 21, 70, "Exercise",ExpressionUUID->"523ae5b2-2bef-4de5-b073-9bf191cd8deb"],
Cell[462303, 9042, 19183, 371, 70, "ExerciseOutput",ExpressionUUID->"a08f3b4d-09ea-4ffc-b9a0-671d4f6ef91e"]
}, Closed]],
Cell[CellGroupData[{
Cell[481523, 9418, 732, 20, 70, "Exercise",ExpressionUUID->"8ba5ece2-b3ee-4959-bf40-c329790f32ee"],
Cell[482258, 9440, 5266, 114, 70, "ExerciseOutput",ExpressionUUID->"a9b61ae1-5f00-41e7-a758-8620347a2059"]
}, Closed]],
Cell[CellGroupData[{
Cell[487561, 9559, 803, 24, 70, "Exercise",ExpressionUUID->"96b944bb-0780-4573-bed9-c39c9913fada"],
Cell[488367, 9585, 19361, 386, 70, "ExerciseOutput",ExpressionUUID->"23080b47-bba6-47ba-8326-017a3fc37f32"]
}, Closed]],
Cell[CellGroupData[{
Cell[507765, 9976, 1075, 36, 70, "Exercise",ExpressionUUID->"12f759d7-84d5-4701-ba31-3b99648ab41c"],
Cell[508843, 10014, 1069, 31, 70, "ExerciseOutput",ExpressionUUID->"d3b368dd-32d8-475b-b525-f171f76d8787"]
}, Closed]],
Cell[CellGroupData[{
Cell[509949, 10050, 891, 29, 70, "Exercise",ExpressionUUID->"888f6349-ea05-4fa8-9f47-84f5ecf824f5"],
Cell[510843, 10081, 1073, 31, 70, "ExerciseOutput",ExpressionUUID->"5d3c81e5-2f9e-4c33-9e7a-b64aae618790"]
}, Closed]],
Cell[CellGroupData[{
Cell[511953, 10117, 773, 21, 70, "Exercise",ExpressionUUID->"18e59b2a-fbd6-4448-ba72-d1b2756df6ef"],
Cell[512729, 10140, 51381, 922, 70, "ExerciseOutput",ExpressionUUID->"28c8fdea-cfdd-48c2-aef2-22e51cc11d8b"]
}, Closed]],
Cell[CellGroupData[{
Cell[564147, 11067, 784, 21, 70, "Exercise",ExpressionUUID->"857b2e9d-ce1d-453c-913a-cf45960a6e18"],
Cell[564934, 11090, 132139, 2507, 70, "ExerciseOutput",ExpressionUUID->"00ec7af5-5a94-4557-8edb-9d82de091294"]
}, Closed]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[697134, 13604, 144, 4, 70, "QASection",ExpressionUUID->"53875622-3f15-4bc3-9c72-d59cd039c843"],
Cell[697281, 13610, 307, 6, 70, "Question",ExpressionUUID->"d250519a-79cf-4cd2-9067-a61001bba513"],
Cell[697591, 13618, 469, 10, 70, "Answer",ExpressionUUID->"5eb73312-6e93-4ea2-88fb-0c9226816e17"],
Cell[698063, 13630, 199, 4, 70, "Question",ExpressionUUID->"f0ad2894-b414-45d1-9166-263c4ed227b4",
 CellTags->"i:15"],
Cell[698265, 13636, 342, 8, 70, "Answer",ExpressionUUID->"2250d0c7-c56c-4855-bc9b-f11207df818b"],
Cell[698610, 13646, 363, 13, 70, "Question",ExpressionUUID->"b5b91a8b-a28f-44af-9f1a-83686697de48"],
Cell[698976, 13661, 493, 14, 70, "Answer",ExpressionUUID->"77d250fa-bdda-4e6e-86a1-be7edd787d2e",
 CellTags->"i:16"],
Cell[699472, 13677, 195, 4, 70, "Question",ExpressionUUID->"4aef5864-0921-4caa-b37b-051d203a96e0",
 CellTags->"i:17"],
Cell[699670, 13683, 650, 18, 70, "Answer",ExpressionUUID->"6c10a6e6-b53c-4599-a2aa-169d67ac4ad1"],
Cell[700323, 13703, 188, 4, 70, "Question",ExpressionUUID->"110a296a-0173-46d6-b81b-273abb3864d3"],
Cell[700514, 13709, 299, 8, 70, "Answer",ExpressionUUID->"b0b52a58-ffbe-4e9e-a12e-499c839af1f1"],
Cell[700816, 13719, 184, 4, 70, "Question",ExpressionUUID->"a6f10f5f-b631-4bda-905a-e98a4fb03725"],
Cell[701003, 13725, 1233, 44, 70, "Answer",ExpressionUUID->"f56415a7-fd0c-4d7d-80d3-c7ed18753de0",
 CellTags->{"LastCellOfAPage", "i:18"}]
}, Open  ]],
Cell[CellGroupData[{
Cell[702273, 13774, 174, 4, 70, "TechNoteSection",ExpressionUUID->"b61b4f26-75d8-4f43-802b-2f2392613ce1",
 CellTags->"p:121"],
Cell[702450, 13780, 244, 7, 70, "TechNote",ExpressionUUID->"a663fad2-c271-4bc6-bff2-a20fac1ca68c"],
Cell[702697, 13789, 383, 12, 70, "TechNote",ExpressionUUID->"786fdf47-f0ab-4d68-88f8-7e26383e3173"],
Cell[703083, 13803, 874, 29, 70, "TechNote",ExpressionUUID->"b54d8ed2-b5e1-436a-abef-71162197d24c",
 CellTags->"i:19"],
Cell[703960, 13834, 665, 19, 70, "TechNote",ExpressionUUID->"082d5a70-91eb-4b2d-838e-272449ddb273",
 CellTags->"i:20"],
Cell[704628, 13855, 684, 19, 70, "TechNote",ExpressionUUID->"dbed4faa-d17a-47bd-a75a-a67e9ac75446",
 CellTags->"i:21"],
Cell[705315, 13876, 479, 13, 70, "TechNote",ExpressionUUID->"ce23b07e-c33c-439c-b956-09005a376cfe",
 CellTags->"i:22"]
}, Open  ]],
Cell[CellGroupData[{
Cell[705831, 13894, 165, 4, 70, "MoreExploreSection",ExpressionUUID->"2a21043d-8b4d-41a2-85db-95ce137d80c8"],
Cell[705999, 13900, 351, 8, 70, "MoreExplore",ExpressionUUID->"ceb37b4b-1dd7-4223-a941-e264d9b05177",
 CellTags->"LastCellOfAPage"]
}, Open  ]]
}
]
*)

(* NotebookSignature zI4XfBEnqk#fHJOz8oUZKPA9 *)
