(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    470946,      10686]
NotebookOptionsPosition[    356789,       8398]
NotebookOutlinePosition[    453745,      10390]
CellTagsIndexPosition[    452837,      10353]
WindowTitle->Dates and Times: Elementary Introduction to the Wolfram Language
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
 InterpretationBox[Cell[
  "Dates and Times", "SectionInline",ExpressionUUID->
   "de4b1817-b2b1-4ace-8881-60806b12201b"],
  $Line = 0; Null]], "SectionDoubleDigit",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CounterAssignments->{{"Section", 18}, {"Subsection", 0}, {
   "Subsubsection", 0}, {"Exercise", 0}, {"Question", 0}},
 CellTags->"p:101",ExpressionUUID->"012c4330-46eb-4711-a1dc-28ca57bfb0ac"],

Cell[TextData[{
 "In the Wolfram Language, ",
 ButtonBox["Now",
  BaseStyle->"Link"],
 " gives your current date and time."
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:1",ExpressionUUID->"5f7594a6-58b4-46fb-a5ab-fa308c190827"],

Cell["Get the current date and time (as of when I wrote this!):", \
"CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:2",ExpressionUUID->"a5a17762-a3bd-455f-b772-d36d77172a21"],

Cell[CellGroupData[{

Cell[BoxData["Now"], "Input",
 Deletable->False,
 CellLabel->"In[1]:=",ExpressionUUID->"d3789b74-d6ba-4229-931e-787f810cd606"],

Cell[BoxData[
 TemplateBox[{
   RowBox[{"\"Fri 17 Mar 2017 13:39:00\"", 
     StyleBox[
      RowBox[{"\"GMT\"", "\[InvisibleSpace]", 
        RowBox[{"-", "5."}]}], FontColor -> GrayLevel[0.5]]}], 
   RowBox[{"DateObject", "[", 
     RowBox[{
       RowBox[{"{", 
         RowBox[{
          "2017", ",", "3", ",", "10", ",", "13", ",", "39", ",", 
           "0.6479377746582031"}], "}"}], ",", "\"Instant\"", ",", 
       "\"Gregorian\"", ",", 
       RowBox[{"-", "5.`"}]}], "]"}]},
  "DateObject",
  Editable->False]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[1]=",ExpressionUUID->"ca25b694-a4cc-49fe-b70e-1fc604b1ea00"]
}, Open  ]],

Cell["You can do computations on this, for example adding a week.", "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:3",ExpressionUUID->"988f6b86-8dc1-4f85-8f4e-175d03433cd4"],

Cell["Add a week to the current date and time:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"44c6cdcd-2055-4a0a-ba71-5b0b486b30c7"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Now", "+", 
  NamespaceBox["LinguisticAssistant",
   DynamicModuleBox[{Typeset`query$$ = "1 week", Typeset`boxes$$ = 
    TemplateBox[{"1", "\"wk\"", "weeks", "\"Weeks\""}, "Quantity", SyntaxForm -> 
     Mod], Typeset`allassumptions$$ = {}, Typeset`assumptions$$ = {}, 
    Typeset`open$$ = {1}, Typeset`querystate$$ = {
    "Online" -> True, "Allowed" -> True, "mparse.jsp" -> 
     0.615871`6.241034748103367, "Messages" -> {}}}, 
    DynamicBox[ToBoxes[
      AlphaIntegration`LinguisticAssistantBoxes["", 4, Automatic, 
       Dynamic[Typeset`query$$], 
       Dynamic[Typeset`boxes$$], 
       Dynamic[Typeset`allassumptions$$], 
       Dynamic[Typeset`assumptions$$], 
       Dynamic[Typeset`open$$], 
       Dynamic[Typeset`querystate$$]], StandardForm],
     ImageSizeCache->{68., {9.5, 16.5}},
     TrackedSymbols:>{
      Typeset`query$$, Typeset`boxes$$, Typeset`allassumptions$$, 
       Typeset`assumptions$$, Typeset`open$$, Typeset`querystate$$}],
    DynamicModuleValues:>{},
    UndoTrackedVariables:>{Typeset`open$$}],
   BaseStyle->{"Deploy"},
   DeleteWithContents->True,
   Editable->False,
   SelectWithContents->True]}]], "Input",
 Deletable->False,
 CellLabel->"In[2]:=",ExpressionUUID->"b7f9c45b-438a-40ea-a250-7341884cfdf9"],

Cell[BoxData[
 TemplateBox[{
   RowBox[{"\"Fri 24 Mar 2017 13:39:00\"", 
     StyleBox[
      RowBox[{"\"GMT\"", "\[InvisibleSpace]", 
        RowBox[{"-", "5."}]}], FontColor -> GrayLevel[0.5]]}], 
   RowBox[{"DateObject", "[", 
     RowBox[{
       RowBox[{"{", 
         RowBox[{
          "2017", ",", "3", ",", "17", ",", "13", ",", "39", ",", 
           "0.6479377746582031`"}], "}"}], ",", "\"Instant\"", ",", 
       "\"Gregorian\"", ",", 
       RowBox[{"-", "5.`"}]}], "]"}]},
  "DateObject",
  Editable->False]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[2]=",ExpressionUUID->"5495c012-118a-4b55-9e9f-2585bd794e2c"]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[TextData[Cell[BoxData[
  TemplateBox[{"ctrl", "="},
   "Key1"]],ExpressionUUID->"b4de6efd-1b41-439c-a2ed-e251bb45e4e6"]],
  FontSize->16,ExpressionUUID->"d926d89a-618e-4202-8270-d09580883ce0"],
 " to enter a date in any standard format."
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:4",ExpressionUUID->"3c51a4ce-78c5-4e64-9b70-8887b90ca8d3"],

Cell["Enter a date:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"f578bcca-4dd4-413c-b486-8bea382713ae"],

Cell[CellGroupData[{

Cell[BoxData[
 NamespaceBox["LinguisticAssistant",
  DynamicModuleBox[{Typeset`query$$ = "june 23, 1988", Typeset`boxes$$ = 
   RowBox[{"DateObject", "[", 
     RowBox[{"{", 
       RowBox[{"1988", ",", " ", "6", ",", " ", "23"}], "}"}], "]"}], 
   Typeset`allassumptions$$ = {}, Typeset`assumptions$$ = {}, 
   Typeset`open$$ = {1}, Typeset`querystate$$ = {
   "Online" -> True, "Allowed" -> True, "mparse.jsp" -> 
    0.37304`6.0233003959424085, "Messages" -> {}}}, 
   DynamicBox[ToBoxes[
     AlphaIntegration`LinguisticAssistantBoxes["", 4, Automatic, 
      Dynamic[Typeset`query$$], 
      Dynamic[Typeset`boxes$$], 
      Dynamic[Typeset`allassumptions$$], 
      Dynamic[Typeset`assumptions$$], 
      Dynamic[Typeset`open$$], 
      Dynamic[Typeset`querystate$$]], StandardForm],
    ImageSizeCache->{112., {9.5, 16.5}},
    TrackedSymbols:>{
     Typeset`query$$, Typeset`boxes$$, Typeset`allassumptions$$, 
      Typeset`assumptions$$, Typeset`open$$, Typeset`querystate$$}],
   DynamicModuleValues:>{},
   UndoTrackedVariables:>{Typeset`open$$}],
  BaseStyle->{"Deploy"},
  DeleteWithContents->True,
  Editable->False,
  SelectWithContents->True]], "Input",
 Deletable->False,
 CellLabel->"In[3]:=",ExpressionUUID->"8872b302-5862-4510-883b-9d571817df77"],

Cell[BoxData[
 TemplateBox[{
   RowBox[{
     StyleBox["\"Day: \"", FontColor -> GrayLevel[0.5], FontWeight -> Plain], 
     "\"Thu 23 Jun 1988\""}], 
   RowBox[{"DateObject", "[", 
     RowBox[{
       RowBox[{"{", 
         RowBox[{"1988", ",", "6", ",", "23"}], "}"}], ",", "\"Day\"", ",", 
       "\"Gregorian\"", ",", 
       RowBox[{"-", "5.`"}]}], "]"}]},
  "DateObject",
  Editable->False]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[3]=",ExpressionUUID->"189cecf7-b20e-48d8-892d-f120f296cd1d"]
}, Open  ]],

Cell["\<\
You can do arithmetic with dates, say, subtracting them to find how far apart \
they are. \
\>", "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:5",ExpressionUUID->"ddab02ca-e0a3-431c-81d0-afe3fd71da4d"],

Cell["Subtract two dates:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"58cfbe93-29a3-43bc-8cdd-78adde6ddbd1"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Now", "-", 
  NamespaceBox["LinguisticAssistant",
   DynamicModuleBox[{Typeset`query$$ = "june 23, 1988", Typeset`boxes$$ = 
    RowBox[{"DateObject", "[", 
      RowBox[{"{", 
        RowBox[{"1988", ",", " ", "6", ",", " ", "23"}], "}"}], "]"}], 
    Typeset`allassumptions$$ = {}, Typeset`assumptions$$ = {}, 
    Typeset`open$$ = {1}, Typeset`querystate$$ = {
    "Online" -> True, "Allowed" -> True, "mparse.jsp" -> 
     0.37304`6.0233003959424085, "Messages" -> {}}}, 
    DynamicBox[ToBoxes[
      AlphaIntegration`LinguisticAssistantBoxes["", 4, Automatic, 
       Dynamic[Typeset`query$$], 
       Dynamic[Typeset`boxes$$], 
       Dynamic[Typeset`allassumptions$$], 
       Dynamic[Typeset`assumptions$$], 
       Dynamic[Typeset`open$$], 
       Dynamic[Typeset`querystate$$]], StandardForm],
     ImageSizeCache->{112., {9.5, 16.5}},
     TrackedSymbols:>{
      Typeset`query$$, Typeset`boxes$$, Typeset`allassumptions$$, 
       Typeset`assumptions$$, Typeset`open$$, Typeset`querystate$$}],
    DynamicModuleValues:>{},
    UndoTrackedVariables:>{Typeset`open$$}],
   BaseStyle->{"Deploy"},
   DeleteWithContents->True,
   Editable->False,
   SelectWithContents->True]}]], "Input",
 Deletable->False,
 CellLabel->"In[4]:=",ExpressionUUID->"a9cbb602-1e98-4751-a529-0a387f14e811"],

Cell[BoxData[
 TemplateBox[{"10494.", "\"days\"", "days", "\"Days\""},
  "Quantity"]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[4]=",ExpressionUUID->"7f6d352c-2503-4e81-bb1a-8a278b1f1b7f"]
}, Open  ]],

Cell["Convert the date difference to years:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:6",ExpressionUUID->"258b6df1-894a-43e9-8c7d-bacb94eacc54"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UnitConvert", "[", 
  RowBox[{
   RowBox[{"Now", "-", 
    NamespaceBox["LinguisticAssistant",
     DynamicModuleBox[{Typeset`query$$ = "june 23, 1988", Typeset`boxes$$ = 
      RowBox[{"DateObject", "[", 
        RowBox[{"{", 
          RowBox[{"1988", ",", " ", "6", ",", " ", "23"}], "}"}], "]"}], 
      Typeset`allassumptions$$ = {}, Typeset`assumptions$$ = {}, 
      Typeset`open$$ = {1}, Typeset`querystate$$ = {
      "Online" -> True, "Allowed" -> True, "mparse.jsp" -> 
       0.37304`6.0233003959424085, "Messages" -> {}}}, 
      DynamicBox[ToBoxes[
        AlphaIntegration`LinguisticAssistantBoxes["", 4, Automatic, 
         Dynamic[Typeset`query$$], 
         Dynamic[Typeset`boxes$$], 
         Dynamic[Typeset`allassumptions$$], 
         Dynamic[Typeset`assumptions$$], 
         Dynamic[Typeset`open$$], 
         Dynamic[Typeset`querystate$$]], StandardForm],
       ImageSizeCache->{112., {9.5, 16.5}},
       TrackedSymbols:>{
        Typeset`query$$, Typeset`boxes$$, Typeset`allassumptions$$, 
         Typeset`assumptions$$, Typeset`open$$, Typeset`querystate$$}],
      DynamicModuleValues:>{},
      UndoTrackedVariables:>{Typeset`open$$}],
     BaseStyle->{"Deploy"},
     DeleteWithContents->True,
     Editable->False,
     SelectWithContents->True]}], ",", "\"\<Years\>\""}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[5]:=",ExpressionUUID->"a1e3a5f2-12e3-42b4-ab4e-ed4e0cd62684"],

Cell[BoxData[
 TemplateBox[{"28.75068493150685`", "\"yr\"", "years", "\"Years\""},
  "Quantity"]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[5]=",ExpressionUUID->"45bc5449-c142-4056-aa23-9158f23fa209"]
}, Open  ]],

Cell[TextData[{
 ButtonBox["DayRange",
  BaseStyle->"Link"],
 " is the analog of ",
 ButtonBox["Range",
  BaseStyle->"Link"],
 " for dates:"
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->{
  "p:102", "i:7"},ExpressionUUID->"b48f1113-ccbc-4df5-9cfd-32f189413921"],

Cell["Give a list of the days spanning from yesterday to tomorrow:", \
"CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:8",ExpressionUUID->"9489dda2-a4fe-4693-86c5-14b9a533ed69"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DayRange", "[", 
  RowBox[{"Yesterday", ",", "Tomorrow"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[6]:=",ExpressionUUID->"b4e23265-15f4-468d-a827-0a13e2fc5e00"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TemplateBox[{
     RowBox[{
       StyleBox[
       "\"Day: \"", FontColor -> GrayLevel[0.5], FontWeight -> Plain], 
       "\"Thu 16 Mar 2017\""}], 
     RowBox[{"DateObject", "[", 
       RowBox[{
         RowBox[{"{", 
           RowBox[{"2017", ",", "3", ",", "16"}], "}"}], ",", "\"Day\"", ",", 
         "\"Gregorian\"", ",", 
         RowBox[{"-", "5.`"}]}], "]"}]},
    "DateObject",
    Editable->False], ",", 
   TemplateBox[{
     RowBox[{
       StyleBox[
       "\"Day: \"", FontColor -> GrayLevel[0.5], FontWeight -> Plain], 
       "\"Fri 17 Mar 2017\""}], 
     RowBox[{"DateObject", "[", 
       RowBox[{
         RowBox[{"{", 
           RowBox[{"2017", ",", "3", ",", "17"}], "}"}], ",", "\"Day\"", ",", 
         "\"Gregorian\"", ",", 
         RowBox[{"-", "5.`"}]}], "]"}]},
    "DateObject",
    Editable->False], ",", 
   TemplateBox[{
     RowBox[{
       StyleBox[
       "\"Day: \"", FontColor -> GrayLevel[0.5], FontWeight -> Plain], 
       "\"Sat 18 Mar 2017\""}], 
     RowBox[{"DateObject", "[", 
       RowBox[{
         RowBox[{"{", 
           RowBox[{"2017", ",", "3", ",", "18"}], "}"}], ",", "\"Day\"", ",", 
         "\"Gregorian\"", ",", 
         RowBox[{"-", "5.`"}]}], "]"}]},
    "DateObject",
    Editable->False]}], "}"}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellTags->"LastCellOfAPage",
 CellLabel->"Out[6]=",ExpressionUUID->"2dd978c0-9f10-4947-9093-94c1ff446f35"]
}, Open  ]],

Cell[TextData[{
 ButtonBox["DayName",
  BaseStyle->"Link"],
 " finds the day of the week for a particular date."
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:9",ExpressionUUID->"32eaf23b-24dc-4713-89d3-819289328892"],

Cell["Compute the day of the week 45 days from now:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"492b9254-004a-4302-812b-3a42deb12b74"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DayName", "[", 
  RowBox[{"Today", "+", 
   NamespaceBox["LinguisticAssistant",
    DynamicModuleBox[{Typeset`query$$ = "45 days", Typeset`boxes$$ = 
     TemplateBox[{"45", "\"days\"", "days", "\"Days\""}, "Quantity", 
      SyntaxForm -> Mod], Typeset`allassumptions$$ = {}, 
     Typeset`assumptions$$ = {}, Typeset`open$$ = {1}, 
     Typeset`querystate$$ = {
     "Online" -> True, "Allowed" -> True, "mparse.jsp" -> 
      0.405133`6.059142613461083, "Messages" -> {}}}, 
     DynamicBox[ToBoxes[
       AlphaIntegration`LinguisticAssistantBoxes["", 4, Automatic, 
        Dynamic[Typeset`query$$], 
        Dynamic[Typeset`boxes$$], 
        Dynamic[Typeset`allassumptions$$], 
        Dynamic[Typeset`assumptions$$], 
        Dynamic[Typeset`open$$], 
        Dynamic[Typeset`querystate$$]], StandardForm],
      ImageSizeCache->{74., {9.5, 16.5}},
      TrackedSymbols:>{
       Typeset`query$$, Typeset`boxes$$, Typeset`allassumptions$$, 
        Typeset`assumptions$$, Typeset`open$$, Typeset`querystate$$}],
     DynamicModuleValues:>{},
     UndoTrackedVariables:>{Typeset`open$$}],
    BaseStyle->{"Deploy"},
    DeleteWithContents->True,
    Editable->False,
    SelectWithContents->True]}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[7]:=",ExpressionUUID->"bdf64366-589e-4b70-889d-a37e7a6441e2"],

Cell[BoxData["Monday"], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[7]=",ExpressionUUID->"1994eb1b-7aaf-48ef-834d-c880bd97f2d5"]
}, Open  ]],

Cell[TextData[{
 "Once you know a date, there are lots of things you can compute. For \
example, ",
 ButtonBox["MoonPhase",
  BaseStyle->"Link"],
 " gives the phase of the moon",
 " (or, more accurately, the fraction of the Moon that is illuminated when \
seen from the Earth)",
 "."
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:10",ExpressionUUID->"070151e2-2d71-416c-8e00-c80767e3ea36"],

Cell["Compute the phase of the moon now:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"d50bbd0c-5749-42c4-a6e1-3c3573d5341d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MoonPhase", "[", "Now", "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[8]:=",ExpressionUUID->"ea4241d7-bded-4ee7-aed1-2ccc9d3b2c24"],

Cell[BoxData["0.7605871713096552522`4."], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[8]=",ExpressionUUID->"3e57e5e9-1656-471c-af8f-dda00bd1a594"]
}, Open  ]],

Cell["Compute the phase of the moon on a certain date:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"7b69be00-6569-4307-aac9-d90a7dd98c45"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MoonPhase", "[", 
  NamespaceBox["LinguisticAssistant",
   DynamicModuleBox[{Typeset`query$$ = "june 23, 1988", Typeset`boxes$$ = 
    RowBox[{"DateObject", "[", 
      RowBox[{"{", 
        RowBox[{"1988", ",", " ", "6", ",", " ", "23"}], "}"}], "]"}], 
    Typeset`allassumptions$$ = {}, Typeset`assumptions$$ = {}, 
    Typeset`open$$ = {1}, Typeset`querystate$$ = {
    "Online" -> True, "Allowed" -> True, "mparse.jsp" -> 
     0.344105`5.98823597665638, "Messages" -> {}}}, 
    DynamicBox[ToBoxes[
      AlphaIntegration`LinguisticAssistantBoxes["", 4, Automatic, 
       Dynamic[Typeset`query$$], 
       Dynamic[Typeset`boxes$$], 
       Dynamic[Typeset`allassumptions$$], 
       Dynamic[Typeset`assumptions$$], 
       Dynamic[Typeset`open$$], 
       Dynamic[Typeset`querystate$$]], StandardForm],
     ImageSizeCache->{112., {9.5, 16.5}},
     TrackedSymbols:>{
      Typeset`query$$, Typeset`boxes$$, Typeset`allassumptions$$, 
       Typeset`assumptions$$, Typeset`open$$, Typeset`querystate$$}],
    DynamicModuleValues:>{},
    UndoTrackedVariables:>{Typeset`open$$}],
   BaseStyle->{"Deploy"},
   DeleteWithContents->True,
   Editable->False,
   SelectWithContents->True], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[9]:=",ExpressionUUID->"f76500f4-8e42-4dde-a07d-d7c643b6b440"],

Cell[BoxData["0.5755981383115221783`4."], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[9]=",ExpressionUUID->"f36eea10-4f2d-4f48-879d-9b6ef8061bd4"]
}, Open  ]],

Cell["Generate an icon for the phase of the moon:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"37cceee3-f578-40b5-a84b-e120eef63080"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MoonPhase", "[", 
  RowBox[{
   NamespaceBox["LinguisticAssistant",
    DynamicModuleBox[{Typeset`query$$ = "june 23, 1988", Typeset`boxes$$ = 
     RowBox[{"DateObject", "[", 
       RowBox[{"{", 
         RowBox[{"1988", ",", " ", "6", ",", " ", "23"}], "}"}], "]"}], 
     Typeset`allassumptions$$ = {}, Typeset`assumptions$$ = {}, 
     Typeset`open$$ = {1}, Typeset`querystate$$ = {
     "Online" -> True, "Allowed" -> True, "mparse.jsp" -> 
      0.344105`5.98823597665638, "Messages" -> {}}}, 
     DynamicBox[ToBoxes[
       AlphaIntegration`LinguisticAssistantBoxes["", 4, Automatic, 
        Dynamic[Typeset`query$$], 
        Dynamic[Typeset`boxes$$], 
        Dynamic[Typeset`allassumptions$$], 
        Dynamic[Typeset`assumptions$$], 
        Dynamic[Typeset`open$$], 
        Dynamic[Typeset`querystate$$]], StandardForm],
      ImageSizeCache->{112., {9.5, 16.5}},
      TrackedSymbols:>{
       Typeset`query$$, Typeset`boxes$$, Typeset`allassumptions$$, 
        Typeset`assumptions$$, Typeset`open$$, Typeset`querystate$$}],
     DynamicModuleValues:>{},
     UndoTrackedVariables:>{Typeset`open$$}],
    BaseStyle->{"Deploy"},
    DeleteWithContents->True,
    Editable->False,
    SelectWithContents->True], ",", "\"\<Icon\>\""}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[10]:=",ExpressionUUID->"e705305c-d0fa-41de-b164-a0a580055a82"],

Cell[BoxData[
 GraphicsBox[{
   {GrayLevel[0.75], 
    PolygonBox[{{-1.1, -1.3}, {1.1, -1.3}, {1.3, -1.1}, {1.3, 1.1}, {1.1, 
     1.3}, {-1.1, 1.3}, {-1.3, 1.1}, {-1.3, -1.1}}], 
    DiskBox[{-1.1, -1.1}, 0.2], DiskBox[{1.1, -1.1}, 0.2], 
    DiskBox[{1.1, 1.1}, 0.2], DiskBox[{-1.1, 1.1}, 0.2]}, 
   {GrayLevel[1], 
    DiskBox[{0, 0}, 1, 
     NCache[{Rational[3, 2] Pi, Rational[5, 2] Pi}, {4.71238898038469, 
      7.853981633974483}]]}, 
   {GrayLevel[1], DiskBox[{0, 0}, {0.15119627662304427, 1.}]}, 
   {GrayLevel[0.6], CircleBox[{0, 0}]}},
  AspectRatio->1,
  ImageSize->100]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[10]=",ExpressionUUID->"54b3ed21-f629-4161-9814-ca11871d3d53"]
}, Open  ]],

Cell["\<\
If you know both the date and a location on Earth, you can work out when the \
sun will rise and set.\
\>", "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"18cbd2c2-f6d4-4b1c-a827-c61190adca5f"],

Cell["Compute when sunset will be today at my current location:", \
"CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:11",ExpressionUUID->"4d13863d-f091-4317-9f54-89fe35e95eb8"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sunset", "[", 
  RowBox[{"Here", ",", "Today"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[11]:=",ExpressionUUID->"539dfcad-6012-4883-8542-833fd964fecf"],

Cell[BoxData[
 TemplateBox[{
   RowBox[{
     StyleBox[
     "\"Minute: \"", FontColor -> GrayLevel[0.5], FontWeight -> Plain], 
     "\"Fri 17 Mar 2017 19:04\"", 
     StyleBox[
      RowBox[{"\"GMT\"", "\[InvisibleSpace]", 
        RowBox[{"-", "5."}]}], FontColor -> GrayLevel[0.5]]}], 
   RowBox[{"DateObject", "[", 
     RowBox[{
       RowBox[{"{", 
         RowBox[{"2017", ",", "3", ",", "17", ",", "19", ",", "4"}], "}"}], 
       ",", "\"Minute\"", ",", "\"Gregorian\"", ",", 
       RowBox[{"-", "5.`"}]}], "]"}]},
  "DateObject",
  Editable->False]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[11]=",ExpressionUUID->"7aa432dc-01d5-40c1-ad5d-71d8b50b99cb"]
}, Open  ]],

Cell["Compute the time between successive sunrises:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:12",ExpressionUUID->"8b854b10-74d5-41c4-bff7-8d94ce1e916f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Sunrise", "[", 
   RowBox[{"Here", ",", "Tomorrow"}], "]"}], "-", 
  RowBox[{"Sunrise", "[", 
   RowBox[{"Here", ",", "Today"}], "]"}]}]], "Input",
 Deletable->False,
 CellLabel->"In[12]:=",ExpressionUUID->"02e91112-15bc-471d-8bd4-d8703baa563f"],

Cell[BoxData[
 TemplateBox[{"1438", "\"min\"", "minutes", "\"Minutes\""},
  "Quantity"]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellTags->"LastCellOfAPage",
 CellLabel->"Out[12]=",ExpressionUUID->"b7e97b0c-2f38-4543-bb8b-d60f9b67e5cb"]
}, Open  ]],

Cell["\<\
They\[CloseCurlyQuote]re about a minute off from being exactly 1 day (24 \
hours) apart:\
\>", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"a99de35a-0985-4565-8b44-70230e25b302"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Sunrise", "[", 
   RowBox[{"Here", ",", "Tomorrow"}], "]"}], "-", 
  RowBox[{"Sunrise", "[", 
   RowBox[{"Here", ",", "Today"}], "]"}], "-", 
  NamespaceBox["LinguisticAssistant",
   DynamicModuleBox[{Typeset`query$$ = "1 day", Typeset`boxes$$ = 
    TemplateBox[{"1", "\"day\"", "days", "\"Days\""}, "Quantity", SyntaxForm -> 
     Mod], Typeset`allassumptions$$ = {}, Typeset`assumptions$$ = {}, 
    Typeset`open$$ = {1, 2}, Typeset`querystate$$ = {
    "Online" -> True, "Allowed" -> True, "mparse.jsp" -> 
     0.475633`6.1288169723709585, "Messages" -> {}}}, 
    DynamicBox[ToBoxes[
      AlphaIntegration`LinguisticAssistantBoxes["", 4, Automatic, 
       Dynamic[Typeset`query$$], 
       Dynamic[Typeset`boxes$$], 
       Dynamic[Typeset`allassumptions$$], 
       Dynamic[Typeset`assumptions$$], 
       Dynamic[Typeset`open$$], 
       Dynamic[Typeset`querystate$$]], StandardForm],
     ImageSizeCache->{78., {11.5, 16.5}},
     TrackedSymbols:>{
      Typeset`query$$, Typeset`boxes$$, Typeset`allassumptions$$, 
       Typeset`assumptions$$, Typeset`open$$, Typeset`querystate$$}],
    DynamicModuleValues:>{},
    UndoTrackedVariables:>{Typeset`open$$}],
   BaseStyle->{"Deploy"},
   DeleteWithContents->True,
   Editable->False,
   SelectWithContents->True]}]], "Input",
 Deletable->False,
 CellLabel->"In[13]:=",ExpressionUUID->"148886a8-5560-4d27-84fb-0d77a073b501"],

Cell[BoxData[
 TemplateBox[{
   RowBox[{"-", "2"}], "\"min\"", "minutes", "\"Minutes\""},
  "Quantity"]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[13]=",ExpressionUUID->"d6296b44-31ae-48d9-93c6-3dc17763eea0"]
}, Open  ]],

Cell[TextData[{
 "Time zones are one of many subtleties.",
 " ",
 ButtonBox["LocalTime",
  BaseStyle->"Link"],
 " gives the time in the time zone of a particular location."
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:13",ExpressionUUID->"615c57ba-7e08-4eaf-9e0b-34c0bef724b7"],

Cell["Find the local time now in New York City:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:14",ExpressionUUID->"e6dfc220-99ac-4092-8d8d-0dadb15c0401"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LocalTime", "[", 
  NamespaceBox["LinguisticAssistant",
   DynamicModuleBox[{Typeset`query$$ = "New York", Typeset`boxes$$ = 
    TemplateBox[{"\"New York City\"", 
      RowBox[{"Entity", "[", 
        RowBox[{"\"City\"", ",", 
          RowBox[{"{", 
            
            RowBox[{"\"NewYork\"", ",", "\"NewYork\"", ",", 
              "\"UnitedStates\""}], "}"}]}], "]"}], 
      "\"Entity[\\\"City\\\", {\\\"NewYork\\\", \\\"NewYork\\\", \
\\\"UnitedStates\\\"}]\"", "\"city\""}, "Entity"], 
    Typeset`allassumptions$$ = {{
     "type" -> "Clash", "word" -> "New York", "template" -> 
      "Assuming \"${word}\" is ${desc1}. Use as ${desc2} instead", "count" -> 
      "8", "Values" -> {{
        "name" -> "City", "desc" -> "a city", "input" -> 
         "*C.New+York-_*City-"}, {
        "name" -> "USState", "desc" -> "a US state", "input" -> 
         "*C.New+York-_*USState-"}, {
        "name" -> "Periodical", "desc" -> "a periodical", "input" -> 
         "*C.New+York-_*Periodical-"}, {
        "name" -> "NFLTeam", "desc" -> "an NFL team", "input" -> 
         "*C.New+York-_*NFLTeam-"}, {
        "name" -> "MLBTeam", "desc" -> "an MLB team", "input" -> 
         "*C.New+York-_*MLBTeam-"}, {
        "name" -> "NBATeam", "desc" -> "an NBA team", "input" -> 
         "*C.New+York-_*NBATeam-"}, {
        "name" -> "MusicWork", "desc" -> "a music work", "input" -> 
         "*C.New+York-_*MusicWork-"}, {
        "name" -> "MusicAlbum", "desc" -> "a music album", "input" -> 
         "*C.New+York-_*MusicAlbum-"}}}}, Typeset`assumptions$$ = {}, 
    Typeset`open$$ = {1}, Typeset`querystate$$ = {
    "Online" -> True, "Allowed" -> True, "mparse.jsp" -> 
     0.447017`6.101869033106217, "Messages" -> {}}}, 
    DynamicBox[ToBoxes[
      AlphaIntegration`LinguisticAssistantBoxes["", 4, Automatic, 
       Dynamic[Typeset`query$$], 
       Dynamic[Typeset`boxes$$], 
       Dynamic[Typeset`allassumptions$$], 
       Dynamic[Typeset`assumptions$$], 
       Dynamic[Typeset`open$$], 
       Dynamic[Typeset`querystate$$]], StandardForm],
     ImageSizeCache->{86., {9.5, 16.5}},
     TrackedSymbols:>{
      Typeset`query$$, Typeset`boxes$$, Typeset`allassumptions$$, 
       Typeset`assumptions$$, Typeset`open$$, Typeset`querystate$$}],
    DynamicModuleValues:>{},
    UndoTrackedVariables:>{Typeset`open$$}],
   BaseStyle->{"Deploy"},
   DeleteWithContents->True,
   Editable->False,
   SelectWithContents->True], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[14]:=",ExpressionUUID->"07db839d-7271-4d21-9865-2e9bb6f1b6ba"],

Cell[BoxData[
 TemplateBox[{
   RowBox[{"\"Fri 17 Mar 2017 14:44:22\"", 
     StyleBox[
      RowBox[{"\"GMT\"", "\[InvisibleSpace]", 
        RowBox[{"-", "4."}]}], FontColor -> GrayLevel[0.5]]}], 
   RowBox[{"DateObject", "[", 
     RowBox[{
       RowBox[{"{", 
         RowBox[{
          "2017", ",", "3", ",", "21", ",", "14", ",", "44", ",", 
           "22.893074`"}], "}"}], ",", "\"Instant\"", ",", "\"Gregorian\"", 
       ",", 
       RowBox[{"-", "4.`"}]}], "]"}]},
  "DateObject",
  Editable->False]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[14]=",ExpressionUUID->"49e70374-765c-49b9-bfa5-d9ddfc0363f4"]
}, Open  ]],

Cell["Find the local time now in London:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:15",ExpressionUUID->"d8b64ce1-cdfe-43be-9136-c36b3eafedfc"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LocalTime", "[", 
  NamespaceBox["LinguisticAssistant",
   DynamicModuleBox[{Typeset`query$$ = "London", Typeset`boxes$$ = 
    TemplateBox[{"\"London\"", 
      RowBox[{"Entity", "[", 
        RowBox[{"\"City\"", ",", 
          RowBox[{"{", 
            
            RowBox[{"\"London\"", ",", "\"GreaterLondon\"", ",", 
              "\"UnitedKingdom\""}], "}"}]}], "]"}], 
      "\"Entity[\\\"City\\\", {\\\"London\\\", \\\"GreaterLondon\\\", \
\\\"UnitedKingdom\\\"}]\"", "\"city\""}, "Entity"], 
    Typeset`allassumptions$$ = {{
     "type" -> "Clash", "word" -> "London", "template" -> 
      "Assuming \"${word}\" is ${desc1}. Use as ${desc2} instead", "count" -> 
      "4", "Values" -> {{
        "name" -> "City", "desc" -> "a city", "input" -> 
         "*C.London-_*City-"}, {
        "name" -> "AdministrativeDivision", "desc" -> 
         "an administrative division", "input" -> 
         "*C.London-_*AdministrativeDivision-"}, {
        "name" -> "Surname", "desc" -> "a surname", "input" -> 
         "*C.London-_*Surname-"}, {
        "name" -> "GivenName", "desc" -> "a given name", "input" -> 
         "*C.London-_*GivenName-"}}}, {
     "type" -> "SubCategory", "word" -> "London", "template" -> 
      "Assuming ${desc1}. Use ${desc2} instead", "count" -> "7", 
      "Values" -> {{
        "name" -> "{London, GreaterLondon, UnitedKingdom}", "desc" -> 
         "London (United Kingdom)", "input" -> 
         "*DPClash.CityE.London-_**London.GreaterLondon.UnitedKingdom--"}, {
        "name" -> "{London, Ontario, Canada}", "desc" -> "London (Canada)", 
         "input" -> "*DPClash.CityE.London-_**London.Ontario.Canada--"}, {
        "name" -> "{London, Ohio, UnitedStates}", "desc" -> 
         "London (Ohio, USA)", "input" -> 
         "*DPClash.CityE.London-_**London.Ohio.UnitedStates--"}, {
        "name" -> "{London, Kentucky, UnitedStates}", "desc" -> 
         "London (Kentucky, USA)", "input" -> 
         "*DPClash.CityE.London-_**London.Kentucky.UnitedStates--"}, {
        "name" -> "{London, Arkansas, UnitedStates}", "desc" -> 
         "London (Arkansas, USA)", "input" -> 
         "*DPClash.CityE.London-_**London.Arkansas.UnitedStates--"}, {
        "name" -> "{London, California, UnitedStates}", "desc" -> 
         "London (California, USA)", "input" -> 
         "*DPClash.CityE.London-_**London.California.UnitedStates--"}, {
        "name" -> "{London, Kiritimati, Kiribati}", "desc" -> 
         "London (Kiribati)", "input" -> 
         "*DPClash.CityE.London-_**London.Kiritimati.Kiribati--"}}}}, 
    Typeset`assumptions$$ = {}, Typeset`open$$ = {1}, Typeset`querystate$$ = {
    "Online" -> True, "Allowed" -> True, "mparse.jsp" -> 
     0.378258`6.029333115436709, "Messages" -> {}}}, 
    DynamicBox[ToBoxes[
      AlphaIntegration`LinguisticAssistantBoxes["", 4, Automatic, 
       Dynamic[Typeset`query$$], 
       Dynamic[Typeset`boxes$$], 
       Dynamic[Typeset`allassumptions$$], 
       Dynamic[Typeset`assumptions$$], 
       Dynamic[Typeset`open$$], 
       Dynamic[Typeset`querystate$$]], StandardForm],
     ImageSizeCache->{71., {9.5, 16.5}},
     TrackedSymbols:>{
      Typeset`query$$, Typeset`boxes$$, Typeset`allassumptions$$, 
       Typeset`assumptions$$, Typeset`open$$, Typeset`querystate$$}],
    DynamicModuleValues:>{},
    UndoTrackedVariables:>{Typeset`open$$}],
   BaseStyle->{"Deploy"},
   DeleteWithContents->True,
   Editable->False,
   SelectWithContents->True], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[15]:=",ExpressionUUID->"f7286a3a-c7f0-4adf-af08-7c503fb11c2b"],

Cell[BoxData[
 TemplateBox[{
   RowBox[{"\"Fri 17 Mar 2017 18:44:29\"", 
     StyleBox["\"GMT\"", FontColor -> GrayLevel[0.5]]}], 
   RowBox[{"DateObject", "[", 
     RowBox[{
       RowBox[{"{", 
         RowBox[{
          "2017", ",", "3", ",", "21", ",", "18", ",", "44", ",", 
           "29.520457`"}], "}"}], ",", "\"Instant\"", ",", "\"Gregorian\"", 
       ",", "0.`"}], "]"}]},
  "DateObject",
  Editable->False]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[15]=",ExpressionUUID->"8f984b38-5067-4091-b33a-041691b36192"]
}, Open  ]],

Cell[TextData[{
 "Among the many areas where the Wolfram Language has extensive data is ",
 "weather",
 ". The function ",
 ButtonBox["AirTemperatureData",
  BaseStyle->"Link"],
 " uses this data to give the historical air temperature at a particular time \
and place. "
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:16",ExpressionUUID->"72d5442a-fde8-420b-bd51-4c2e0d145f8e"],

Cell["Find the air temperature here at 6 pm yesterday:", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"24dbd890-fd31-4b42-a3ca-6bb3ac28f9db"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AirTemperatureData", "[", 
  RowBox[{"Here", ",", 
   NamespaceBox["LinguisticAssistant",
    DynamicModuleBox[{Typeset`query$$ = "6 pm yesterday", Typeset`boxes$$ = 
     RowBox[{"DateObject", "[", 
       RowBox[{"Yesterday", ",", " ", 
         RowBox[{"TimeObject", "[", 
           RowBox[{"{", "18", "}"}], "]"}]}], "]"}], 
     Typeset`allassumptions$$ = {}, Typeset`assumptions$$ = {}, 
     Typeset`open$$ = {1}, Typeset`querystate$$ = {
     "Online" -> True, "Allowed" -> True, "mparse.jsp" -> 
      0.505717`6.155452546460331, "Messages" -> {}}}, 
     DynamicBox[ToBoxes[
       AlphaIntegration`LinguisticAssistantBoxes["", 4, Automatic, 
        Dynamic[Typeset`query$$], 
        Dynamic[Typeset`boxes$$], 
        Dynamic[Typeset`allassumptions$$], 
        Dynamic[Typeset`assumptions$$], 
        Dynamic[Typeset`open$$], 
        Dynamic[Typeset`querystate$$]], StandardForm],
      ImageSizeCache->{123., {9.5, 16.5}},
      TrackedSymbols:>{
       Typeset`query$$, Typeset`boxes$$, Typeset`allassumptions$$, 
        Typeset`assumptions$$, Typeset`open$$, Typeset`querystate$$}],
     DynamicModuleValues:>{},
     UndoTrackedVariables:>{Typeset`open$$}],
    BaseStyle->{"Deploy"},
    DeleteWithContents->True,
    Editable->False,
    SelectWithContents->True]}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[16]:=",ExpressionUUID->"2a8656ff-c384-424b-bf5a-cceb910c84a4"],

Cell[BoxData[
 TemplateBox[{
  "39.9199999999999`", "\"\[Degree]F\"", "degrees Fahrenheit", 
   "\"DegreesFahrenheit\""},
  "Quantity"]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[16]=",ExpressionUUID->"f4d6d8f1-630a-4427-bbb4-a04bc9bdb1e9"]
}, Open  ]],

Cell[TextData[{
 "If you provide a pair of dates, ",
 ButtonBox["AirTemperatureData",
  BaseStyle->"Link"],
 " computes ",
 "a ",
 StyleBox["time series",
  FontSlant->"Italic"],
 " ",
 "of estimated temperatures between those dates. "
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:17",ExpressionUUID->"92603fda-52cc-47dd-9733-5a9f9b1e060f"],

Cell["\<\
Give a time series of air temperature measurements from a week ago until now:\
\
\>", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"b88bf2bc-5d14-4dd2-a7b3-4512f71078af"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AirTemperatureData", "[", 
  RowBox[{"Here", ",", 
   RowBox[{"{", 
    RowBox[{
     NamespaceBox["LinguisticAssistant",
      DynamicModuleBox[{Typeset`query$$ = "1 week ago", Typeset`boxes$$ = 
       RowBox[{"DatePlus", "[", 
         RowBox[{"Today", ",", " ", 
           RowBox[{"-", 
             
             TemplateBox[{"1", "\"wk\"", "weeks", "\"Weeks\""}, "Quantity", 
              SyntaxForm -> Mod]}]}], "]"}], Typeset`allassumptions$$ = {}, 
       Typeset`assumptions$$ = {}, Typeset`open$$ = {1}, 
       Typeset`querystate$$ = {
       "Online" -> True, "Allowed" -> True, "mparse.jsp" -> 
        0.419148`6.073912391722935, "Messages" -> {}}}, 
       DynamicBox[ToBoxes[
         AlphaIntegration`LinguisticAssistantBoxes["", 4, Automatic, 
          Dynamic[Typeset`query$$], 
          Dynamic[Typeset`boxes$$], 
          Dynamic[Typeset`allassumptions$$], 
          Dynamic[Typeset`assumptions$$], 
          Dynamic[Typeset`open$$], 
          Dynamic[Typeset`querystate$$]], StandardForm],
        ImageSizeCache->{97., {9.5, 16.5}},
        TrackedSymbols:>{
         Typeset`query$$, Typeset`boxes$$, Typeset`allassumptions$$, 
          Typeset`assumptions$$, Typeset`open$$, Typeset`querystate$$}],
       DynamicModuleValues:>{},
       UndoTrackedVariables:>{Typeset`open$$}],
      BaseStyle->{"Deploy"},
      DeleteWithContents->True,
      Editable->False,
      SelectWithContents->True], ",", "Now"}], "}"}]}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[17]:=",ExpressionUUID->"6e2d9f6e-e9db-43c3-9722-b5411daf1d52"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox["TimeSeries",
    "SummaryHead"], "[", 
   DynamicModuleBox[{Typeset`open$$ = False}, 
    PanelBox[
     PaneSelectorBox[{False->GridBox[{
        {
         PaneBox[
          ButtonBox[
           
           DynamicBox[FEPrivate`FrontEndResource[
            "FEBitmaps", "SquarePlusIconMedium"],
            ImageSizeCache->{12., {0., 12.}}],
           Appearance->None,
           ButtonFunction:>(Typeset`open$$ = True),
           Evaluator->Automatic,
           Method->"Preemptive"],
          Alignment->{Center, Center},
          
          ImageSize->
           Dynamic[{
            Automatic, 
             3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
              Magnification])}]], 
         GraphicsBox[{{}, {{}, {}, 
            {GrayLevel[0.5], PointSize[0.125], AbsoluteThickness[1.5], 
             StyleBox[LineBox[CompressedData["
1:eJxTTMoPSmViYGAwAmIQDQEf7Fl11LwinD7aQwUcXn2Jtl8b9ArK53Bw3utt
q3f4M5Qv4CC+Otg/K43RAcIXcfi+f0F40nsYX8JBX1jtBbsrL5Qv45DtoBvW
xcwP5Ss4NFwMEp60GWafksOc359Whf/9BeWrOARoR64NnnwNyldzMHERNjG5
+no/hK/hIKRdVZBY8w3K13LIMJWbeIH9L5Sv4zDLV7txKvsXKF/PoWzi1MhL
TFwHIHwDB/cgkWNzBTmgfEOHQ2p/W4VucUL5Rg7G79Iu8t1mg/KNHcrd9WVC
ixmhfBOHrX+2zedZ8B9qvqnDPJ3j61kKGKDyZg5FiwwE9lTA7DN3qN+4vmmS
siiUb+HAtbzy3bJ4ISjf0oFzYux88dMCUL6VQ5zaARf5axJQvrWDmCZL36VN
UlC+jYPfBC+BlBJxKN/WoX+K14Vt8jJQvp3DgYTiXbPeiUD59g48fy+4bYoW
g/IdHL4IXz2XEgqVb3BwONa2ilHOixsq7+jg3yuU9L5AECrv6NBaqXjidDLM
vU4OTZOznfNi2KHyTg4WG+6H/hWBhY+zQ5qveFfD7s+Q8Glwdviw+EOTxY2j
0Ph0cVj18NqRC96XIfwGF4dlb2fpWLbB0perwzqzL3Nnz/wElXd1YCgOSXoi
cRUq7+ZgkHHN7dvHG1Dz3RxO/X996GnXG2h8uDusTTv5fqPlTai8u4O3Uoqa
3YkrUP0eDlu+ZYpfimJwgMh7OPwpNvZ9PpcDwmfwdPgt/Kj+tbigAwD0Q951

               "]],
              StripOnInput->False,
              FontFamily->"Arial"]}}, {}},
          AspectRatio->1,
          Axes->{False, False},
          AxesLabel->{None, None},
          AxesOrigin->{0., 0.},
          Background->GrayLevel[0.93],
          BaseStyle->{FontFamily -> "Arial"},
          DisplayFunction->Identity,
          Frame->{{True, True}, {True, True}},
          FrameLabel->{{None, None}, {None, None}},
          FrameStyle->Directive[
            Thickness[Tiny], 
            GrayLevel[0.7]],
          FrameTicks->{{None, None}, {None, None}},
          GridLines->{None, None},
          GridLinesStyle->Directive[
            GrayLevel[0.5, 0.4]],
          ImageSize->{Automatic, 
            Dynamic[
            3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
              Magnification])]},
          LabelStyle->{FontFamily -> "Arial"},
          Method->{"ScalingFunctions" -> None},
          PlotRange->{{0., 50.}, {-7.030970816185017, 4.273359296964368}},
          PlotRangeClipping->True,
          PlotRangePadding->{{1, 1}, {1, 1}},
          Ticks->{Automatic, Automatic}], GridBox[{
           {
            TagBox[
             TemplateBox[{
               RowBox[{
                 TagBox["\"Time: \"", "SummaryItemAnnotation"], 
                 "\[InvisibleSpace]", 
                 TagBox["\"10 Mar 2017\"", "SummaryItem"]}], 
               RowBox[{
                 TagBox["\" to \"", "SummaryItemAnnotation"], 
                 "\[InvisibleSpace]", 
                 TagBox["\"17 Mar 2017\"", "SummaryItem"]}]},
              "RowDefault"],
             "SummaryItem"], "\[SpanFromLeft]"},
           {
            RowBox[{
             TagBox["\<\"Data points: \"\>",
              "SummaryItemAnnotation"], "\[InvisibleSpace]", 
             TagBox["247",
              "SummaryItem"]}], "\[SpanFromLeft]"}
          },
          AutoDelete->False,
          
          BaseStyle->{
           ShowStringCharacters -> False, NumberMarks -> False, 
            PrintPrecision -> 3, ShowSyntaxStyles -> False},
          GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Automatic}}},
          
          GridBoxItemSize->{
           "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
          GridBoxSpacings->{"Columns" -> {{2}}, "Rows" -> {{Automatic}}}]}
       },
       AutoDelete->False,
       BaselinePosition->{1, 1},
       GridBoxAlignment->{"Rows" -> {{Top}}},
       GridBoxItemSize->{
        "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], True->
      GridBox[{
        {
         PaneBox[
          ButtonBox[
           
           DynamicBox[FEPrivate`FrontEndResource[
            "FEBitmaps", "SquareMinusIconMedium"]],
           Appearance->None,
           ButtonFunction:>(Typeset`open$$ = False),
           Evaluator->Automatic,
           Method->"Preemptive"],
          Alignment->{Center, Center},
          
          ImageSize->
           Dynamic[{
            Automatic, 
             3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
              Magnification])}]], 
         GraphicsBox[{{}, {{}, {}, 
            {GrayLevel[0.5], PointSize[0.125], AbsoluteThickness[1.5], 
             StyleBox[LineBox[CompressedData["
1:eJxTTMoPSmViYGAwAmIQDQEf7Fl11LwinD7aQwUcXn2Jtl8b9ArK53Bw3utt
q3f4M5Qv4CC+Otg/K43RAcIXcfi+f0F40nsYX8JBX1jtBbsrL5Qv45DtoBvW
xcwP5Ss4NFwMEp60GWafksOc359Whf/9BeWrOARoR64NnnwNyldzMHERNjG5
+no/hK/hIKRdVZBY8w3K13LIMJWbeIH9L5Sv4zDLV7txKvsXKF/PoWzi1MhL
TFwHIHwDB/cgkWNzBTmgfEOHQ2p/W4VucUL5Rg7G79Iu8t1mg/KNHcrd9WVC
ixmhfBOHrX+2zedZ8B9qvqnDPJ3j61kKGKDyZg5FiwwE9lTA7DN3qN+4vmmS
siiUb+HAtbzy3bJ4ISjf0oFzYux88dMCUL6VQ5zaARf5axJQvrWDmCZL36VN
UlC+jYPfBC+BlBJxKN/WoX+K14Vt8jJQvp3DgYTiXbPeiUD59g48fy+4bYoW
g/IdHL4IXz2XEgqVb3BwONa2ilHOixsq7+jg3yuU9L5AECrv6NBaqXjidDLM
vU4OTZOznfNi2KHyTg4WG+6H/hWBhY+zQ5qveFfD7s+Q8Glwdviw+EOTxY2j
0Ph0cVj18NqRC96XIfwGF4dlb2fpWLbB0perwzqzL3Nnz/wElXd1YCgOSXoi
cRUq7+ZgkHHN7dvHG1Dz3RxO/X996GnXG2h8uDusTTv5fqPlTai8u4O3Uoqa
3YkrUP0eDlu+ZYpfimJwgMh7OPwpNvZ9PpcDwmfwdPgt/Kj+tbigAwD0Q951

               "]],
              StripOnInput->False,
              FontFamily->"Arial"]}}, {}},
          AspectRatio->1,
          Axes->{False, False},
          AxesLabel->{None, None},
          AxesOrigin->{0., 0.},
          Background->GrayLevel[0.93],
          BaseStyle->{FontFamily -> "Arial"},
          DisplayFunction->Identity,
          Frame->{{True, True}, {True, True}},
          FrameLabel->{{None, None}, {None, None}},
          FrameStyle->Directive[
            Thickness[Tiny], 
            GrayLevel[0.7]],
          FrameTicks->{{None, None}, {None, None}},
          GridLines->{None, None},
          GridLinesStyle->Directive[
            GrayLevel[0.5, 0.4]],
          ImageSize->{Automatic, 
            Dynamic[
            3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
              Magnification])]},
          LabelStyle->{FontFamily -> "Arial"},
          Method->{"ScalingFunctions" -> None},
          PlotRange->{{0., 50.}, {-7.030970816185017, 4.273359296964368}},
          PlotRangeClipping->True,
          PlotRangePadding->{{1, 1}, {1, 1}},
          Ticks->{Automatic, Automatic}], GridBox[{
           {
            TagBox[
             TemplateBox[{
               RowBox[{
                 TagBox["\"Time: \"", "SummaryItemAnnotation"], 
                 "\[InvisibleSpace]", 
                 TagBox["\"10 Mar 2017\"", "SummaryItem"]}], 
               RowBox[{
                 TagBox["\" to \"", "SummaryItemAnnotation"], 
                 "\[InvisibleSpace]", 
                 TagBox["\"17 Mar 2017\"", "SummaryItem"]}]},
              "RowDefault"],
             "SummaryItem"], "\[SpanFromLeft]"},
           {
            RowBox[{
             TagBox["\<\"Data points: \"\>",
              "SummaryItemAnnotation"], "\[InvisibleSpace]", 
             TagBox["247",
              "SummaryItem"]}], "\[SpanFromLeft]"},
           {
            RowBox[{
             TagBox["\<\"Regular: \"\>",
              "SummaryItemAnnotation"], "\[InvisibleSpace]", 
             TagBox["False",
              "SummaryItem"]}], 
            RowBox[{
             TagBox["\<\"Output dimension: \"\>",
              "SummaryItemAnnotation"], "\[InvisibleSpace]", 
             TagBox["1",
              "SummaryItem"]}]},
           {
            RowBox[{
             TagBox["\<\"Metadata: \"\>",
              "SummaryItemAnnotation"], "\[InvisibleSpace]", 
             TagBox["None",
              "SummaryItem"]}], 
            RowBox[{
             TagBox["\<\"Minimum increment: \"\>",
              "SummaryItemAnnotation"], "\[InvisibleSpace]", 
             TagBox["120",
              "SummaryItem"]}]},
           {
            TagBox["\<\"\"\>",
             "SummaryItem"], 
            RowBox[{
             TagBox["\<\"Resampling: \"\>",
              "SummaryItemAnnotation"], "\[InvisibleSpace]", 
             TagBox["\<\"LinearInterpolation\"\>",
              "SummaryItem"]}]}
          },
          AutoDelete->False,
          
          BaseStyle->{
           ShowStringCharacters -> False, NumberMarks -> False, 
            PrintPrecision -> 3, ShowSyntaxStyles -> False},
          GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Automatic}}},
          
          GridBoxItemSize->{
           "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
          GridBoxSpacings->{"Columns" -> {{2}}, "Rows" -> {{Automatic}}}]}
       },
       AutoDelete->False,
       BaselinePosition->{1, 1},
       GridBoxAlignment->{"Rows" -> {{Top}}},
       GridBoxItemSize->{
        "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}]}, Dynamic[
      Typeset`open$$],
      ImageSize->Automatic],
     BaselinePosition->Baseline],
    DynamicModuleValues:>{}], "]"}],
  TemporalData[TimeSeries, {{{
      Quantity[42.98000000000002, "DegreesFahrenheit"], 
      Quantity[40.99999999999994, "DegreesFahrenheit"], 
      Quantity[39.019999999999925`, "DegreesFahrenheit"], 
      Quantity[39.019999999999925`, "DegreesFahrenheit"], 
      Quantity[35.95999999999992, "DegreesFahrenheit"], 
      Quantity[33.079999999999984`, "DegreesFahrenheit"], 
      Missing["NotAvailable"], 
      Quantity[33.98000000000002, "DegreesFahrenheit"], 
      Quantity[33.98000000000002, "DegreesFahrenheit"], 
      Quantity[33.98000000000002, "DegreesFahrenheit"], 
      Quantity[33.079999999999984`, "DegreesFahrenheit"], 
      Quantity[30.919999999999902`, "DegreesFahrenheit"], 
      Quantity[30.019999999999925`, "DegreesFahrenheit"], 
      Quantity[28.939999999999998`, "DegreesFahrenheit"], 
      Quantity[30.919999999999902`, "DegreesFahrenheit"], 
      Quantity[33.079999999999984`, "DegreesFahrenheit"], 
      Quantity[35.059999999999945`, "DegreesFahrenheit"], 
      Quantity[37.039999999999964`, "DegreesFahrenheit"], 
      Quantity[37.94, "DegreesFahrenheit"], 
      Quantity[37.94, "DegreesFahrenheit"], 
      Quantity[39.019999999999925`, "DegreesFahrenheit"], 
      Quantity[39.019999999999925`, "DegreesFahrenheit"], 
      Quantity[37.94, "DegreesFahrenheit"], 
      Quantity[33.079999999999984`, "DegreesFahrenheit"], 
      Quantity[30.919999999999902`, "DegreesFahrenheit"], 
      Quantity[30.919999999999902`, "DegreesFahrenheit"], 
      Quantity[30.919999999999902`, "DegreesFahrenheit"], 
      Quantity[30.019999999999925`, "DegreesFahrenheit"], 
      Quantity[28.939999999999998`, "DegreesFahrenheit"], 
      Quantity[28.939999999999998`, "DegreesFahrenheit"], 
      Quantity[28.039999999999964`, "DegreesFahrenheit"], 
      Quantity[26.959999999999923`, "DegreesFahrenheit"], 
      Quantity[26.959999999999923`, "DegreesFahrenheit"], 
      Quantity[26.059999999999945`, "DegreesFahrenheit"], 
      Quantity[26.059999999999945`, "DegreesFahrenheit"], 
      Quantity[24.980000000000018`, "DegreesFahrenheit"], 
      Quantity[24.980000000000018`, "DegreesFahrenheit"], 
      Quantity[26.059999999999945`, "DegreesFahrenheit"], 
      Quantity[28.039999999999964`, "DegreesFahrenheit"], 
      Quantity[28.939999999999998`, "DegreesFahrenheit"], 
      Quantity[30.919999999999902`, "DegreesFahrenheit"], 
      Quantity[33.079999999999984`, "DegreesFahrenheit"], 
      Quantity[33.98000000000002, "DegreesFahrenheit"], 
      Quantity[35.059999999999945`, "DegreesFahrenheit"], 
      Quantity[33.98000000000002, "DegreesFahrenheit"], 
      Quantity[33.98000000000002, "DegreesFahrenheit"], 
      Quantity[24.980000000000018`, "DegreesFahrenheit"], 
      Quantity[26.959999999999923`, "DegreesFahrenheit"], 
      Quantity[27.049999999999955`, "DegreesFahrenheit"], 
      Quantity[26.059999999999945`, "DegreesFahrenheit"], 
      Quantity[24.980000000000018`, "DegreesFahrenheit"], 
      Missing["NotAvailable"], 
      Quantity[26.959999999999923`, "DegreesFahrenheit"], 
      Quantity[26.959999999999923`, "DegreesFahrenheit"], 
      Quantity[26.059999999999945`, "DegreesFahrenheit"], 
      Quantity[22.999999999999943`, "DegreesFahrenheit"], 
      Quantity[21.019999999999925`, "DegreesFahrenheit"], 
      Quantity[19.939999999999998`, "DegreesFahrenheit"], 
      Quantity[22.999999999999943`, "DegreesFahrenheit"], 
      Quantity[26.059999999999945`, "DegreesFahrenheit"], 
      Quantity[28.939999999999998`, "DegreesFahrenheit"], 
      Quantity[30.919999999999902`, "DegreesFahrenheit"], 
      Quantity[31.999999999999943`, "DegreesFahrenheit"], 
      Quantity[35.059999999999945`, "DegreesFahrenheit"], 
      Quantity[37.039999999999964`, "DegreesFahrenheit"], 
      Quantity[35.95999999999992, "DegreesFahrenheit"], 
      Quantity[35.95999999999992, "DegreesFahrenheit"], 
      Quantity[37.94, "DegreesFahrenheit"], 
      Quantity[35.059999999999945`, "DegreesFahrenheit"], 
      Quantity[35.059999999999945`, "DegreesFahrenheit"], 
      Quantity[35.059999999999945`, "DegreesFahrenheit"], 
      Quantity[33.98000000000002, "DegreesFahrenheit"], 
      Quantity[33.98000000000002, "DegreesFahrenheit"], 
      Quantity[33.079999999999984`, "DegreesFahrenheit"], 
      Quantity[33.079999999999984`, "DegreesFahrenheit"], 
      Missing["NotAvailable"], 
      Quantity[33.079999999999984`, "DegreesFahrenheit"], 
      Quantity[31.999999999999943`, "DegreesFahrenheit"], 
      Quantity[30.019999999999925`, "DegreesFahrenheit"], 
      Quantity[28.939999999999998`, "DegreesFahrenheit"], 
      Quantity[28.939999999999998`, "DegreesFahrenheit"], 
      Quantity[28.939999999999998`, "DegreesFahrenheit"], 
      Quantity[28.939999999999998`, "DegreesFahrenheit"], 
      Quantity[28.939999999999998`, "DegreesFahrenheit"], 
      Quantity[28.939999999999998`, "DegreesFahrenheit"], 
      Quantity[28.939999999999998`, "DegreesFahrenheit"], 
      Quantity[28.939999999999998`, "DegreesFahrenheit"], 
      Quantity[28.939999999999998`, "DegreesFahrenheit"], 
      Quantity[28.939999999999998`, "DegreesFahrenheit"], 
      Quantity[28.939999999999998`, "DegreesFahrenheit"], 
      Quantity[28.939999999999998`, "DegreesFahrenheit"], 
      Quantity[28.939999999999998`, "DegreesFahrenheit"], 
      Quantity[28.939999999999998`, "DegreesFahrenheit"], 
      Quantity[28.039999999999964`, "DegreesFahrenheit"], 
      Quantity[28.039999999999964`, "DegreesFahrenheit"], 
      Quantity[28.039999999999964`, "DegreesFahrenheit"], 
      Quantity[28.039999999999964`, "DegreesFahrenheit"], 
      Quantity[28.039999999999964`, "DegreesFahrenheit"], 
      Quantity[28.399999999999977`, "DegreesFahrenheit"], 
      Quantity[28.939999999999998`, "DegreesFahrenheit"], 
      Quantity[28.939999999999998`, "DegreesFahrenheit"], 
      Quantity[28.939999999999998`, "DegreesFahrenheit"], 
      Quantity[28.939999999999998`, "DegreesFahrenheit"], 
      Quantity[30.019999999999925`, "DegreesFahrenheit"], 
      Quantity[30.019999999999925`, "DegreesFahrenheit"], 
      Quantity[30.019999999999925`, "DegreesFahrenheit"], 
      Quantity[30.019999999999925`, "DegreesFahrenheit"], 
      Quantity[30.019999999999925`, "DegreesFahrenheit"], 
      Quantity[30.019999999999925`, "DegreesFahrenheit"], 
      Quantity[30.919999999999902`, "DegreesFahrenheit"], 
      Quantity[30.919999999999902`, "DegreesFahrenheit"], 
      Quantity[30.919999999999902`, "DegreesFahrenheit"], 
      Quantity[30.019999999999925`, "DegreesFahrenheit"], 
      Quantity[30.199999999999932`, "DegreesFahrenheit"], 
      Quantity[30.019999999999925`, "DegreesFahrenheit"], 
      Quantity[30.019999999999925`, "DegreesFahrenheit"], 
      Quantity[28.939999999999998`, "DegreesFahrenheit"], 
      Quantity[28.939999999999998`, "DegreesFahrenheit"], 
      Quantity[28.939999999999998`, "DegreesFahrenheit"], 
      Quantity[28.939999999999998`, "DegreesFahrenheit"], 
      Quantity[28.039999999999964`, "DegreesFahrenheit"], 
      Quantity[28.039999999999964`, "DegreesFahrenheit"], 
      Quantity[26.959999999999923`, "DegreesFahrenheit"], 
      Quantity[26.959999999999923`, "DegreesFahrenheit"], 
      Quantity[26.059999999999945`, "DegreesFahrenheit"], 
      Quantity[26.059999999999945`, "DegreesFahrenheit"], 
      Quantity[24.980000000000018`, "DegreesFahrenheit"], 
      Quantity[24.980000000000018`, "DegreesFahrenheit"], 
      Missing["NotAvailable"], 
      Quantity[24.980000000000018`, "DegreesFahrenheit"], 
      Quantity[24.079999999999984`, "DegreesFahrenheit"], 
      Quantity[22.999999999999943`, "DegreesFahrenheit"], 
      Quantity[21.019999999999925`, "DegreesFahrenheit"], 
      Quantity[21.919999999999902`, "DegreesFahrenheit"], 
      Quantity[19.039999999999964`, "DegreesFahrenheit"], 
      Quantity[17.959999999999923`, "DegreesFahrenheit"], 
      Quantity[17.059999999999945`, "DegreesFahrenheit"], 
      Quantity[19.939999999999998`, "DegreesFahrenheit"], 
      Quantity[24.079999999999984`, "DegreesFahrenheit"], 
      Quantity[24.980000000000018`, "DegreesFahrenheit"], 
      Quantity[26.059999999999945`, "DegreesFahrenheit"], 
      Quantity[26.959999999999923`, "DegreesFahrenheit"], 
      Quantity[26.959999999999923`, "DegreesFahrenheit"], 
      Quantity[26.059999999999945`, "DegreesFahrenheit"], 
      Quantity[26.059999999999945`, "DegreesFahrenheit"], 
      Quantity[26.959999999999923`, "DegreesFahrenheit"], 
      Quantity[26.959999999999923`, "DegreesFahrenheit"], 
      Quantity[26.959999999999923`, "DegreesFahrenheit"], 
      Quantity[28.039999999999964`, "DegreesFahrenheit"], 
      Quantity[26.959999999999923`, "DegreesFahrenheit"], 
      Quantity[26.959999999999923`, "DegreesFahrenheit"], 
      Quantity[26.059999999999945`, "DegreesFahrenheit"], 
      Quantity[26.059999999999945`, "DegreesFahrenheit"], 
      Quantity[26.059999999999945`, "DegreesFahrenheit"], 
      Quantity[26.059999999999945`, "DegreesFahrenheit"], 
      Quantity[24.980000000000018`, "DegreesFahrenheit"], 
      Quantity[24.079999999999984`, "DegreesFahrenheit"], 
      Quantity[24.079999999999984`, "DegreesFahrenheit"], 
      Quantity[24.079999999999984`, "DegreesFahrenheit"], 
      Quantity[24.799999999999955`, "DegreesFahrenheit"], 
      Quantity[24.079999999999984`, "DegreesFahrenheit"], 
      Quantity[22.999999999999943`, "DegreesFahrenheit"], 
      Quantity[21.919999999999902`, "DegreesFahrenheit"], 
      Quantity[21.919999999999902`, "DegreesFahrenheit"], 
      Quantity[19.939999999999998`, "DegreesFahrenheit"], 
      Quantity[19.039999999999964`, "DegreesFahrenheit"], 
      Quantity[17.059999999999945`, "DegreesFahrenheit"], 
      Missing["NotAvailable"], 
      Quantity[15.079999999999984`, "DegreesFahrenheit"], 
      Quantity[13.999999999999943`, "DegreesFahrenheit"], 
      Quantity[12.919999999999902`, "DegreesFahrenheit"], 
      Quantity[12.019999999999925`, "DegreesFahrenheit"], 
      Quantity[13.999999999999943`, "DegreesFahrenheit"], 
      Quantity[12.919999999999902`, "DegreesFahrenheit"], 
      Quantity[13.999999999999943`, "DegreesFahrenheit"], 
      Quantity[17.959999999999923`, "DegreesFahrenheit"], 
      Quantity[21.019999999999925`, "DegreesFahrenheit"], 
      Quantity[22.999999999999943`, "DegreesFahrenheit"], 
      Quantity[24.980000000000018`, "DegreesFahrenheit"], 
      Quantity[26.059999999999945`, "DegreesFahrenheit"], 
      Quantity[26.059999999999945`, "DegreesFahrenheit"], 
      Quantity[26.959999999999923`, "DegreesFahrenheit"], 
      Quantity[28.939999999999998`, "DegreesFahrenheit"], 
      Quantity[28.939999999999998`, "DegreesFahrenheit"], 
      Quantity[28.939999999999998`, "DegreesFahrenheit"], 
      Quantity[26.959999999999923`, "DegreesFahrenheit"], 
      Quantity[22.999999999999943`, "DegreesFahrenheit"], 
      Quantity[24.980000000000018`, "DegreesFahrenheit"], 
      Quantity[22.999999999999943`, "DegreesFahrenheit"], 
      Quantity[21.019999999999925`, "DegreesFahrenheit"], 
      Quantity[21.019999999999925`, "DegreesFahrenheit"], 
      Quantity[21.019999999999925`, "DegreesFahrenheit"], 
      Missing["NotAvailable"], 
      Quantity[21.019999999999925`, "DegreesFahrenheit"], 
      Quantity[19.039999999999964`, "DegreesFahrenheit"], 
      Quantity[17.959999999999923`, "DegreesFahrenheit"], 
      Quantity[17.059999999999945`, "DegreesFahrenheit"], 
      Quantity[17.059999999999945`, "DegreesFahrenheit"], 
      Quantity[17.059999999999945`, "DegreesFahrenheit"], 
      Quantity[21.019999999999925`, "DegreesFahrenheit"], 
      Quantity[26.959999999999923`, "DegreesFahrenheit"], 
      Quantity[31.999999999999943`, "DegreesFahrenheit"], 
      Quantity[35.059999999999945`, "DegreesFahrenheit"], 
      Quantity[37.94, "DegreesFahrenheit"], 
      Quantity[39.9199999999999, "DegreesFahrenheit"], 
      Quantity[42.98000000000002, "DegreesFahrenheit"], 
      Quantity[44.059999999999945`, "DegreesFahrenheit"], 
      Quantity[44.95999999999992, "DegreesFahrenheit"], 
      Quantity[44.95999999999992, "DegreesFahrenheit"], 
      Quantity[39.9199999999999, "DegreesFahrenheit"], 
      Quantity[39.9199999999999, "DegreesFahrenheit"], 
      Quantity[37.94, "DegreesFahrenheit"], 
      Quantity[37.94, "DegreesFahrenheit"], 
      Quantity[39.019999999999925`, "DegreesFahrenheit"], 
      Quantity[37.39999999999998, "DegreesFahrenheit"], 
      Quantity[37.94, "DegreesFahrenheit"], 
      Missing["NotAvailable"], 
      Quantity[39.019999999999925`, "DegreesFahrenheit"], 
      Quantity[37.94, "DegreesFahrenheit"], 
      Quantity[37.94, "DegreesFahrenheit"], 
      Quantity[39.9199999999999, "DegreesFahrenheit"], 
      Quantity[39.9199999999999, "DegreesFahrenheit"], 
      Quantity[40.99999999999994, "DegreesFahrenheit"], 
      Quantity[39.9199999999999, "DegreesFahrenheit"], 
      Quantity[40.99999999999994, "DegreesFahrenheit"], 
      Quantity[40.99999999999994, "DegreesFahrenheit"], 
      Quantity[39.9199999999999, "DegreesFahrenheit"], 
      Quantity[39.9199999999999, "DegreesFahrenheit"], 
      Quantity[39.9199999999999, "DegreesFahrenheit"], 
      Quantity[40.99999999999994, "DegreesFahrenheit"], 
      Quantity[42.079999999999984`, "DegreesFahrenheit"], 
      Quantity[42.079999999999984`, "DegreesFahrenheit"], 
      Quantity[42.98000000000002, "DegreesFahrenheit"], 
      Quantity[42.98000000000002, "DegreesFahrenheit"], 
      Quantity[42.98000000000002, "DegreesFahrenheit"], 
      Quantity[44.059999999999945`, "DegreesFahrenheit"], 
      Quantity[44.95999999999992, "DegreesFahrenheit"], 
      Quantity[44.95999999999992, "DegreesFahrenheit"], 
      Quantity[46.39999999999998, "DegreesFahrenheit"], 
      Quantity[46.94, "DegreesFahrenheit"], 
      Quantity[48.9199999999999, "DegreesFahrenheit"], 
      Quantity[49.99999999999994, "DegreesFahrenheit"], 
      Quantity[51.98000000000002, "DegreesFahrenheit"], 
      Quantity[53.05999999999989, "DegreesFahrenheit"], 
      Quantity[53.95999999999998, "DegreesFahrenheit"], 
      Quantity[55.94, "DegreesFahrenheit"], 
      Quantity[49.99999999999994, "DegreesFahrenheit"]}}, CompressedData["
1:eJxdljuOHEcQBVeALN6CN6jKb+URCNDiEWgIkEWDurtcvfUyZHDBh556PR0Z
1TVff/768dcfHx8fv//Un+9///7nf+nfnb590X+85p1J/VlxcsV7/CJW76jL
iD6I4bFjo9kumi3QbA/NftHsiSofVIWhKgpVMahKR1U2quqgqgJV1ajqi6p+
WPsMax+w30fsQ+wD7HaA3Q6w2wFnYb6I4GwXnM3A2QyczcDZHJzNwdkcnC3A
WdNGVYKzJThbgrMVwFoDrDVIyiPc6JHk67sUtSHYIdgBWD8A6wdg/QCsX4D1
C7CyG1UGsG4A6waw7gDrDrDagKgKgPWEsdpVWJvg7AXOXhBY/1DVwK6YsSOm
4NopZ8epWvFhKK4dvD/86d2OooWIL/nSsTZ5o76MeKL3AnGOrShz9gMO3RjD
txoPRJoz9RAp0sxeG+d2IO7njQPN5ILbjrAuLqyLC+vitu21FxKGndxX7e6h
hEFRvZ5xX4ei4fZ2lbAi4lUgm3FfmbGvBvSOsC1hBGyPgO0RY0uVyFN7beok
3BFbI3QbrMVOiSx8q9REV6xz9xMV9lFUFK5iH0Vjp0RD/mj4HA+KxoOE8WBd
DL0aejUNVgOvUorWjtBMXB0RXuWFOXpdbdvzQiTFvbsVA1ffxdo5jFvvtNxD
SQPnNJwainkQHyOeyB6adWwgwlj9NsEDOhTNgHUpV3ZV4IWcCZEy+UQFc7Jg
jj6LqoY5GgmqGubkgzn5YI5OmINIc4aqDFUZqKIn2M118Vapi4OvLoZSBuxl
wF4G7OXArridLMdmF0g0B6ag3YzmxBQqMYVKTKEKU6jCFKowhWpMQfNEVQN7
PWCvB+z1gF0HdyOCcx9wljiJCM7azPs4VkSzfiMtzjqNcCMD9jZgbwf2dmDX
+FAVwC67jRHNPCYU9/u5EzPq9H2IdGJknbVP9tZGwocxUL1RbV+ty6sYd5dO
4x3TsRYydEGG7gPsDTf68823I1TpfrOf6PMX5fkPMU9aBw==
    "], 1, {
    "Continuous", 1}, {"Discrete", 1}, 1, {
    ValueDimensions -> 1, DateFunction -> Automatic, 
     ResamplingMethod -> {"Interpolation", InterpolationOrder -> 1}}}, True, 
   11.1],
  Editable->False,
  SelectWithContents->True,
  Selectable->False]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellTags->"LastCellOfAPage",
 CellLabel->"Out[17]=",ExpressionUUID->"3da0ce73-c3ff-48a2-a4d1-a0b8dfb84b5c"]
}, Open  ]],

Cell[TextData[{
 ButtonBox["DateListPlot",
  BaseStyle->"Link"],
 " is the analog of ",
 ButtonBox["ListPlot",
  BaseStyle->"Link"],
 " for time series, where each value occurs at a particular date."
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->{
  "p:104", "i:18"},ExpressionUUID->"68287844-f5e1-4958-9b30-8110b4ebbf3b"],

Cell["Plot the list of air temperature measurements: ", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"9d8cc9df-8a8b-4061-827f-e8d795727c1b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DateListPlot", "[", 
  RowBox[{"AirTemperatureData", "[", 
   RowBox[{"Here", ",", 
    RowBox[{"{", 
     RowBox[{
      NamespaceBox["LinguisticAssistant",
       DynamicModuleBox[{Typeset`query$$ = "1 week ago", Typeset`boxes$$ = 
        RowBox[{"DatePlus", "[", 
          RowBox[{"Today", ",", " ", 
            RowBox[{"-", 
              
              TemplateBox[{"1", "\"wk\"", "weeks", "\"Weeks\""}, "Quantity", 
               SyntaxForm -> Mod]}]}], "]"}], Typeset`allassumptions$$ = {}, 
        Typeset`assumptions$$ = {}, Typeset`open$$ = {1}, 
        Typeset`querystate$$ = {
        "Online" -> True, "Allowed" -> True, "mparse.jsp" -> 
         0.419148`6.073912391722935, "Messages" -> {}}}, 
        DynamicBox[ToBoxes[
          AlphaIntegration`LinguisticAssistantBoxes["", 4, Automatic, 
           Dynamic[Typeset`query$$], 
           Dynamic[Typeset`boxes$$], 
           Dynamic[Typeset`allassumptions$$], 
           Dynamic[Typeset`assumptions$$], 
           Dynamic[Typeset`open$$], 
           Dynamic[Typeset`querystate$$]], StandardForm],
         ImageSizeCache->{97., {9.5, 16.5}},
         TrackedSymbols:>{
          Typeset`query$$, Typeset`boxes$$, Typeset`allassumptions$$, 
           Typeset`assumptions$$, Typeset`open$$, Typeset`querystate$$}],
        DynamicModuleValues:>{},
        UndoTrackedVariables:>{Typeset`open$$}],
       BaseStyle->{"Deploy"},
       DeleteWithContents->True,
       Editable->False,
       SelectWithContents->True], ",", "Now"}], "}"}]}], "]"}], 
  "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[18]:=",ExpressionUUID->"0f2b0d7e-2fad-4c1f-8d52-232bbcc75b30"],

Cell[BoxData[
 GraphicsBox[{{}, {{}, {}, 
    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.009166666666666668], 
     AbsoluteThickness[1.6], 
     LineBox[{{3.69809598*^9, 42.98000000000002}, {3.69809958*^9, 
      40.99999999999994}, {3.69810318*^9, 39.019999999999925`}, {
      3.69810678*^9, 39.019999999999925`}, {3.69811038*^9, 
      35.95999999999992}, {3.69811398*^9, 33.079999999999984`}}], 
     LineBox[CompressedData["
1:eJxTTMoPSmViYGDQAWIQzcDQUDmz97WjA9f1xQV/HRyAfOvZqPy/c1D5++cB
+RxArm0XmN+4AMi/ELhDrvW1HYjvvAjIL3gNFGAF81mXgPi2QAM+2ID4x5ei
qu9cjmqe90qQfQ+rRNa1O4L4vKuB/AaQea1OIP75NUA+SHfgDzB/4jpUfvAG
EP+rRkx/kzOIL7oJlX99M6r66O2o9svuRHXf/V2o/IV7UPnJ+1D9q3oA1b/P
D6LyVx4G8hlA9nGB+dlHgfwHQOcd+moF4useR+W/PwHy/yGgB/jB/I2nUPnF
Z0B8kXXuD39ZgPim51D538+jqt95EdX+6suo7rO9iuq//9dQw+fgDdT00HwL
Nb5c76DKs99D5fs+RnUf/1NU/05+AeQfOAMEPNYgfugrVPeLv0HSDwBXUzlN

      "]], LineBox[CompressedData["
1:eJxTTMoPSmViYGAQB2IQzcDQcPNt72vHBxox/Ye+WjkA+bPfo/JjPwL5DYe+
asTwg/nyn4H8D/9BwAzEf/gFyC94HbhDjtUUxF/8DcS35bq++IMxiJ/6A1W9
+i9U817+hqu3AfFX/wXyLwCNa31tB+Ln/ofrtwfx9Rn7Xjs6PKwSWdfuCOJ/
ZALyG0D2tzqB+JtZgPwCkXXuD3+B5UvZUPnmHEA+yPTAH2D1u7lRzavlReXb
86PyGQVBfKBzC/46gPiHhVD5rSJAPgeQa9sF5ruLIfEBIZ+mXQ==
      "]], 
     LineBox[CompressedData["
1:eJxTTMoPSmViYGAwAWIQzcDQwCnR99qR4/riAtsuBwcg/yeI/+E/CNiD+IWS
QH7B68Adcqx2IP5pMN+W6/riDzZAPoO3FCr/MCq/wVgald+LxjeSQeXHo/IZ
pGVR5f1R+QwH0OSZ5VD5K9D4gvKo/BlofD0FIJ8BFB5cYP5lVD7DLUVU+alK
qHwZZVS+pQqQn5AGAmB+uAqqfZJqqP75jMpvuK2Oyp+riRof8dqo/BNofEVd
FD5DKhr/HCq/4bEekH8ByG19DeYvNUDlpxuh8tOMUfX/AfEVjEEAzH9timqf
vhkq/5MZqv/WmqPyVS1Q+fmWqHxDa9T4SUPjS9kA+Q80YvoPfbUCqfdD438G
8RsOfdWI4QfxGfbZovAbttqB+CLr3B/+sgDxGeyR+AB/ckGN
      "]], 
     LineBox[CompressedData["
1:eJxTTMoPSmViYGBQA2IQDQS7HfpeOzaIrHN/+MvCgYGhwdIJyBcAcqtEwPy3
IP6H/yBgBuL/dgbyC14H7pBjNQXx97oC+ReA3NbXYH69O5DPcH1xgS2XMYjv
6AnkP9CI6T/01RDEZ/YG2Xfoq0YMP5h/1Adkni3X9cUfwOrb/VDt9wxAdR93
EFy/FZDPcC0Ibj6I33A2GIXPIBCKor6hH40fGI6qXzgSlX81CpX/OBruPxsQ
f3oMqvwyVD7D3hhU+/hjUd3fgMpvmIbGv5eA6n/3RNTwKUHjL0TlMxwH8Q+c
AQGw/F009aFJKPHLIJiMGp/z0fiJqajxpZyOGt9PM5DiFwDmzP7A
      "]], 
     LineBox[CompressedData["
1:eJxTTMoPSmViYGCQAGIQzcDQkJnT99pRIab/0FcNPQcgXzsPyH/wHwS0Qfy3
+UD+gsUFtlzXNUH89YUg+WsgAQ0Qv7AYVb1xKar6r2Wo8tsrQHwNkIWGIH5l
FZBf8DpwhxyrKYhvXQPkfwCrNwPx/9YC+Q0i69wf/rIA8hl21oH4QNfG8FuB
5PfXo/IbG+Hmg/nOzSDzga5Z/MEGxGdtReUfb0Ple3eh6uftQXXP+V4U9zRM
7EeVD56I6h/Ryaj861OQ+ADigbOC
      "]], LineBox[CompressedData["
1:eJxTTMoPSmViYGAQB2IQzcDQMHNa32vHgteBO+RYTR2A/OgZQD7D9cUFtlzG
IL7sLCD/gUZM/6GvhiD+/dlAfsOhrxox/GD+wrmo/OT5qHzVhajmP18EN88K
xF+5BMj/8B8E7EH87GVAvsPDKpF17Y4gvu4KIH+HXOvrwB9OIP77lUD+C7B+
ZxB/42qQei6gg2tdQfzitTD97G4gvul6kP0i69wfVoH53zeg8m23oZr3fzsq
/+BOVPubd6PyXfeC+EDv9jeB1f/YB+QbGAPBZrA8+34k9QAyzqSW
      "]], 
     LineBox[CompressedData["
1:eJxTTMoPSmViYGCQA2IQzcDQcPJA32vHHV81YvqbnB2A/O5DIL5c6+vAH04g
vu8RVD7/MSD/BVD5oa9g9RePo/InnwTyf/wHgnoXED/0NIo8w6czqPLiZ1H4
DI/Oopondg6VfxOVz8B7AdW82SA+x/XFBbZcriB+7kUUPoPUJSDfgQsoUAuW
j0XlM7hdRpW/AuY/rBJZx+4G4stfAfILRNa5P6wC8RleofIbDl8F8g2MQcAd
xH94FRZ+FWD+4usw95d6gPjSN2Du/w/mp96E2f/XE2R+9S0g3wJkf7sXSF79
NpBfAbLvF4jPkHUHHj/eIPnV95DMAwCjP+JO
      "]]}}, {}, {}, {{}, {}}, {{}, {}}},
  
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{False, False},
  AxesLabel->{None, None},
  AxesOrigin->{3.69809598*^9, 0},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->
   FrontEndValueCache[{{Automatic, Automatic}, {Charting`FindScaledTicks[
       (Charting`getDateTicks[Automatic, {Automatic}, 
        (Map[DateList, {
          SlotSequence[1]}]& )[
         SlotSequence[1]], None, 5, {{0.0125, 0}, {0.0075, 0}}, Automatic]& )[
       
        SlotSequence[1]], {Identity, Identity}]& , Charting`ScaledFrameTicks[
       (Charting`getDateTicks[Charting`getDateTicks[Automatic, {Automatic}, 
         (Map[DateList, {
           SlotSequence[1]}]& )[
          SlotSequence[1]], None, 5, {{0.0125, 0}, {0.0075, 0}}, 
         Automatic]& , {Automatic}, 
        (Map[DateList, {
          SlotSequence[1]}]& )[
         SlotSequence[1]], None, 5, {{0.0125, 0}, {0.0075, 0}}, None]& )[
        SlotSequence[1]], {Identity, Identity}]& }}, {{
     Automatic, Automatic}, {{{3.6980928*^9, 
        FormBox["\"Mar 10\"", TraditionalForm], {0.008333333333333333, 0.}}, {
       3.6982656*^9, 
        FormBox["\"Mar 12\"", TraditionalForm], {0.008333333333333333, 0.}}, {
       3.6984384*^9, 
        FormBox["\"Mar 14\"", TraditionalForm], {0.008333333333333333, 0.}}, {
       3.6986112*^9, 
        FormBox["\"Mar 16\"", TraditionalForm], {0.008333333333333333, 0.}}, {
       3.698784*^9, 
        FormBox["\"Mar 18\"", TraditionalForm], {0.008333333333333333, 0.}}, {
       3.6980928*^9, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
        0.008333333333333333, 0.}}, {3.6981792*^9, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
        0.008333333333333333, 0.}}, {3.6982656*^9, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
        0.008333333333333333, 0.}}, {3.698352*^9, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
        0.008333333333333333, 0.}}, {3.6984384*^9, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
        0.008333333333333333, 0.}}, {3.6985248*^9, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
        0.008333333333333333, 0.}}, {3.6986112*^9, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
        0.008333333333333333, 0.}}, {3.6986976*^9, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
        0.008333333333333333, 0.}}, {3.698784*^9, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
        0.008333333333333333, 0.}}}, {{3.6980928*^9, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
        0.008333333333333333, 0.}}, {3.6982656*^9, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
        0.008333333333333333, 0.}}, {3.6984384*^9, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
        0.008333333333333333, 0.}}, {3.6986112*^9, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
        0.008333333333333333, 0.}}, {3.698784*^9, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
        0.008333333333333333, 0.}}, {3.6980928*^9, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
        0.008333333333333333, 0.}}, {3.6981792*^9, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
        0.008333333333333333, 0.}}, {3.6982656*^9, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
        0.008333333333333333, 0.}}, {3.698352*^9, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
        0.008333333333333333, 0.}}, {3.6984384*^9, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
        0.008333333333333333, 0.}}, {3.6985248*^9, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
        0.008333333333333333, 0.}}, {3.6986112*^9, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
        0.008333333333333333, 0.}}, {3.6986976*^9, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
        0.008333333333333333, 0.}}, {3.698784*^9, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
        0.008333333333333333, 0.}}}}}],
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{3.69809598*^9, 3.69878358*^9}, {0, 55.94}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.05]}},
  Ticks->{{}, Automatic}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[18]=",ExpressionUUID->"700fc3f9-1990-4575-83b7-3c8ff0af5396"]
}, Open  ]],

Cell["\<\
The plot shows that, not surprisingly, the temperature is higher during the \
day than at night.\
\>", "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:19",ExpressionUUID->"099fb920-f395-49f6-8694-a503d3b0d560"],

Cell[TextData[{
 "As another example, let\[CloseCurlyQuote]s look at data that goes much \
further back in time. ",
 ButtonBox["WordFrequencyData",
  BaseStyle->"Link"],
 " tells one how frequently a particular word occurs, say in a sample of \
books published in a given year. There\[CloseCurlyQuote]s a lot of history \
one can see by looking at how this changes over the years and centuries."
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:20",ExpressionUUID->"37affbaf-0512-4bfe-936a-17eac66eca5c"],

Cell["\<\
Find the time series of how frequently the word \
\[OpenCurlyDoubleQuote]automobile\[CloseCurlyDoubleQuote] occurs:\
\>", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:21",ExpressionUUID->"c8e0aeb7-1a20-41dd-b9ae-f66deb3cad5a"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"WordFrequencyData", "[", 
  RowBox[{"\"\<automobile\>\"", ",", "\"\<TimeSeries\>\""}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[19]:=",ExpressionUUID->"4c1beeda-c094-4ab3-b44e-22467fcab246"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox["TimeSeries",
    "SummaryHead"], "[", 
   DynamicModuleBox[{Typeset`open$$ = False}, 
    PanelBox[
     PaneSelectorBox[{False->GridBox[{
        {
         PaneBox[
          ButtonBox[
           
           DynamicBox[FEPrivate`FrontEndResource[
            "FEBitmaps", "SquarePlusIconMedium"],
            ImageSizeCache->{12., {0., 12.}}],
           Appearance->None,
           ButtonFunction:>(Typeset`open$$ = True),
           Evaluator->Automatic,
           Method->"Preemptive"],
          Alignment->{Center, Center},
          
          ImageSize->
           Dynamic[{
            Automatic, 
             3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
              Magnification])}]], 
         GraphicsBox[{{{}, {}, 
            TagBox[
             {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
              Opacity[1.], LineBox[CompressedData["
1:eJwB0QMu/CFib1JlAgAAADwAAAACAAAAbIvnzW/O9sFQR3sqw7WHPgBo+nNG
OvbBmCO8vZnTtT4KNZ2wppn1wc51BawTMrw+WWMi3asD9cG+sXwSHMO5Pqki
GTGicPTB7E9D1Fxgtz5u0p8bItHzwSSSj6fZybQ+eeMI9kY888GuFRD7jF+y
PvnkAWf1mvLBgHoswPiCrz55d2z/lPzxwRaO10BIX6o+P2u5h9lo8cFVJOvB
BJSlPnpPlqanyPDBpAIKZjlhoD77lFW1GjPwwRuoLOnfHJo++NYM1/1A78HI
1GTh+TqXPuRkjnDZAu7BZK6WZY2Okz5ctdTp/tnswaATxakOIZA+vuY6kDeY
68H8XYicxNOIPiE6hIVSXOrBUsi3JTWIgT4PUJJatzXpwcaTwF0CdXU+6EbA
XC/258FVGvYcSlNbPkwAsz7xy+bBJQpZmh8hUz6bmsVNxojlwRzwxKj5B1U+
6la7q31L5ME2Adx29uVWPsXVdel+I+PB5cvaFcG0VD6KNVBUk+LhwbBO11wK
EE0+21fvnvG24MHw2BCrSohBPlg443BkIt/BWJgGASFLTD7Qgif+C6XcwVxN
fkyJoF0+X1L1SkdS2sELZY9jqAFFPsPjAvKozdfB2rU5EtByNz4oudY2z1TV
waIakAjrC2E+pBM0O4kG08HoGIs40dRUPvUv0ZlphtDBITcXL3jYPT66ou9v
u2HMwVBDjSsnezI+i23J5yzOx8FG2ijIRUUqPge8IhTr1sLB9bxuQR1tRD5h
KR5/oWm8wV1rrXIsYYA+C+L1PgZessEpqJ8BaopTPh5e5/lz+aHBzBAgG5Kr
ZD6M9Ln65r9KQTQ4lopKibE+Fh+/X0BepEGqctmcDV7OPtKWo5NxfrNBdEcK
iV7h5D7ElmiOKZW9QRJTCDG2Z/A+WUMKiWe+w0GYyfZD/Vj7PiMxzcsSXchB
f9LINPWK9T5CmxBacV/NQV7lqlNc1/Y+mn2gNFQG0UFyuUXp5gf9PpJpch4r
UdNBlhfEFAMsBD+0kwSu283VQTmNf2BoRPc+wDgNfvgf2EHx6jkoPwn2PvYb
1vPuo9pBTMtXtdP68z4ru9jLIBzdQe5ZfAsqc/A+StVR5L5p30Fcoc2UUAzx
PsqWRVGb9OBBqkDi3dL48j5jgJ1QDR/iQeZaHBePVfE+EonVImxi40FM6ubA
IYrxPsBvKqbon+RBIafYwh3k7T7jk7pJG8jlQYfmdBi/nes+G9cqwDoJ50FN
Kc3w0WvqPshX1lYQNehBI27YeJfk5j7ZFs8LgGTpQdnx2cClj+E+9+Tt9g==

               "]]},
             Annotation[#, "Charting`Private`Tag$136379#1"]& ]}, {}, {}},
          AspectRatio->1,
          Axes->{False, False},
          AxesLabel->{None, None},
          AxesOrigin->{0, 0},
          DisplayFunction->Identity,
          Frame->{{True, True}, {True, True}},
          FrameLabel->{{None, None}, {None, None}},
          FrameStyle->Directive[
            Opacity[0.5], 
            Thickness[Tiny], 
            RGBColor[0.368417, 0.506779, 0.709798]],
          FrameTicks->{{{}, {}}, {{}, {}}},
          GridLines->{None, None},
          GridLinesStyle->Directive[
            GrayLevel[0.5, 0.4]],
          ImagePadding->All,
          
          ImageSize->
           Dynamic[{
            Automatic, 
             3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
              Magnification])}],
          
          Method->{
           "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
            AbsolutePointSize[6], "ScalingFunctions" -> None, 
            "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
                (Identity[#]& )[
                 Part[#, 1]], 
                (Identity[#]& )[
                 Part[#, 2]]}& ), "CopiedValueFunction" -> ({
                (Identity[#]& )[
                 Part[#, 1]], 
                (Identity[#]& )[
                 Part[#, 2]]}& )}},
          PlotRange->{{-6122044800, 3408134400}, {0., 0.00003847488787482517}},
          PlotRangeClipping->True,
          PlotRangePadding->{{
             Scaled[0.1], 
             Scaled[0.1]}, {
             Scaled[0.1], 
             Scaled[0.1]}},
          Ticks->{Automatic, Automatic}], GridBox[{
           {
            TagBox[
             TemplateBox[{
               RowBox[{
                 TagBox["\"Time: \"", "SummaryItemAnnotation"], 
                 "\[InvisibleSpace]", 
                 TagBox["\"01 Jan 1706\"", "SummaryItem"]}], 
               RowBox[{
                 TagBox["\" to \"", "SummaryItemAnnotation"], 
                 "\[InvisibleSpace]", 
                 TagBox["\"01 Jan 2008\"", "SummaryItem"]}]},
              "RowDefault"],
             "SummaryItem"], "\[SpanFromLeft]"},
           {
            RowBox[{
             TagBox["\<\"Data points: \"\>",
              "SummaryItemAnnotation"], "\[InvisibleSpace]", 
             TagBox["158",
              "SummaryItem"]}], "\[SpanFromLeft]"}
          },
          AutoDelete->False,
          
          BaseStyle->{
           ShowStringCharacters -> False, NumberMarks -> False, 
            PrintPrecision -> 3, ShowSyntaxStyles -> False},
          GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Automatic}}},
          
          GridBoxItemSize->{
           "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
          GridBoxSpacings->{"Columns" -> {{2}}, "Rows" -> {{Automatic}}}]}
       },
       AutoDelete->False,
       BaselinePosition->{1, 1},
       GridBoxAlignment->{"Rows" -> {{Top}}},
       GridBoxItemSize->{
        "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], True->
      GridBox[{
        {
         PaneBox[
          ButtonBox[
           
           DynamicBox[FEPrivate`FrontEndResource[
            "FEBitmaps", "SquareMinusIconMedium"]],
           Appearance->None,
           ButtonFunction:>(Typeset`open$$ = False),
           Evaluator->Automatic,
           Method->"Preemptive"],
          Alignment->{Center, Center},
          
          ImageSize->
           Dynamic[{
            Automatic, 
             3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
              Magnification])}]], 
         GraphicsBox[{{{}, {}, 
            TagBox[
             {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
              Opacity[1.], LineBox[CompressedData["
1:eJwB0QMu/CFib1JlAgAAADwAAAACAAAAbIvnzW/O9sFQR3sqw7WHPgBo+nNG
OvbBmCO8vZnTtT4KNZ2wppn1wc51BawTMrw+WWMi3asD9cG+sXwSHMO5Pqki
GTGicPTB7E9D1Fxgtz5u0p8bItHzwSSSj6fZybQ+eeMI9kY888GuFRD7jF+y
PvnkAWf1mvLBgHoswPiCrz55d2z/lPzxwRaO10BIX6o+P2u5h9lo8cFVJOvB
BJSlPnpPlqanyPDBpAIKZjlhoD77lFW1GjPwwRuoLOnfHJo++NYM1/1A78HI
1GTh+TqXPuRkjnDZAu7BZK6WZY2Okz5ctdTp/tnswaATxakOIZA+vuY6kDeY
68H8XYicxNOIPiE6hIVSXOrBUsi3JTWIgT4PUJJatzXpwcaTwF0CdXU+6EbA
XC/258FVGvYcSlNbPkwAsz7xy+bBJQpZmh8hUz6bmsVNxojlwRzwxKj5B1U+
6la7q31L5ME2Adx29uVWPsXVdel+I+PB5cvaFcG0VD6KNVBUk+LhwbBO11wK
EE0+21fvnvG24MHw2BCrSohBPlg443BkIt/BWJgGASFLTD7Qgif+C6XcwVxN
fkyJoF0+X1L1SkdS2sELZY9jqAFFPsPjAvKozdfB2rU5EtByNz4oudY2z1TV
waIakAjrC2E+pBM0O4kG08HoGIs40dRUPvUv0ZlphtDBITcXL3jYPT66ou9v
u2HMwVBDjSsnezI+i23J5yzOx8FG2ijIRUUqPge8IhTr1sLB9bxuQR1tRD5h
KR5/oWm8wV1rrXIsYYA+C+L1PgZessEpqJ8BaopTPh5e5/lz+aHBzBAgG5Kr
ZD6M9Ln65r9KQTQ4lopKibE+Fh+/X0BepEGqctmcDV7OPtKWo5NxfrNBdEcK
iV7h5D7ElmiOKZW9QRJTCDG2Z/A+WUMKiWe+w0GYyfZD/Vj7PiMxzcsSXchB
f9LINPWK9T5CmxBacV/NQV7lqlNc1/Y+mn2gNFQG0UFyuUXp5gf9PpJpch4r
UdNBlhfEFAMsBD+0kwSu283VQTmNf2BoRPc+wDgNfvgf2EHx6jkoPwn2PvYb
1vPuo9pBTMtXtdP68z4ru9jLIBzdQe5ZfAsqc/A+StVR5L5p30Fcoc2UUAzx
PsqWRVGb9OBBqkDi3dL48j5jgJ1QDR/iQeZaHBePVfE+EonVImxi40FM6ubA
IYrxPsBvKqbon+RBIafYwh3k7T7jk7pJG8jlQYfmdBi/nes+G9cqwDoJ50FN
Kc3w0WvqPshX1lYQNehBI27YeJfk5j7ZFs8LgGTpQdnx2cClj+E+9+Tt9g==

               "]]},
             Annotation[#, "Charting`Private`Tag$136379#1"]& ]}, {}, {}},
          AspectRatio->1,
          Axes->{False, False},
          AxesLabel->{None, None},
          AxesOrigin->{0, 0},
          DisplayFunction->Identity,
          Frame->{{True, True}, {True, True}},
          FrameLabel->{{None, None}, {None, None}},
          FrameStyle->Directive[
            Opacity[0.5], 
            Thickness[Tiny], 
            RGBColor[0.368417, 0.506779, 0.709798]],
          FrameTicks->{{{}, {}}, {{}, {}}},
          GridLines->{None, None},
          GridLinesStyle->Directive[
            GrayLevel[0.5, 0.4]],
          ImagePadding->All,
          
          ImageSize->
           Dynamic[{
            Automatic, 
             3.5 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
              Magnification])}],
          
          Method->{
           "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
            AbsolutePointSize[6], "ScalingFunctions" -> None, 
            "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
                (Identity[#]& )[
                 Part[#, 1]], 
                (Identity[#]& )[
                 Part[#, 2]]}& ), "CopiedValueFunction" -> ({
                (Identity[#]& )[
                 Part[#, 1]], 
                (Identity[#]& )[
                 Part[#, 2]]}& )}},
          PlotRange->{{-6122044800, 3408134400}, {0., 0.00003847488787482517}},
          PlotRangeClipping->True,
          PlotRangePadding->{{
             Scaled[0.1], 
             Scaled[0.1]}, {
             Scaled[0.1], 
             Scaled[0.1]}},
          Ticks->{Automatic, Automatic}], GridBox[{
           {
            TagBox[
             TemplateBox[{
               RowBox[{
                 TagBox["\"Time: \"", "SummaryItemAnnotation"], 
                 "\[InvisibleSpace]", 
                 TagBox["\"01 Jan 1706\"", "SummaryItem"]}], 
               RowBox[{
                 TagBox["\" to \"", "SummaryItemAnnotation"], 
                 "\[InvisibleSpace]", 
                 TagBox["\"01 Jan 2008\"", "SummaryItem"]}]},
              "RowDefault"],
             "SummaryItem"], "\[SpanFromLeft]"},
           {
            RowBox[{
             TagBox["\<\"Data points: \"\>",
              "SummaryItemAnnotation"], "\[InvisibleSpace]", 
             TagBox["158",
              "SummaryItem"]}], "\[SpanFromLeft]"},
           {
            RowBox[{
             TagBox["\<\"Regular: \"\>",
              "SummaryItemAnnotation"], "\[InvisibleSpace]", 
             TagBox["False",
              "SummaryItem"]}], 
            RowBox[{
             TagBox["\<\"Output dimension: \"\>",
              "SummaryItemAnnotation"], "\[InvisibleSpace]", 
             TagBox["1",
              "SummaryItem"]}]},
           {
            RowBox[{
             TagBox["\<\"Metadata: \"\>",
              "SummaryItemAnnotation"], "\[InvisibleSpace]", 
             TagBox["None",
              "SummaryItem"]}], 
            RowBox[{
             TagBox["\<\"Minimum increment: \"\>",
              "SummaryItemAnnotation"], "\[InvisibleSpace]", 
             TagBox["31536000",
              "SummaryItem"]}]},
           {
            TagBox["\<\"\"\>",
             "SummaryItem"], 
            RowBox[{
             TagBox["\<\"Resampling: \"\>",
              "SummaryItemAnnotation"], "\[InvisibleSpace]", 
             TagBox["\<\"LinearInterpolation\"\>",
              "SummaryItem"]}]}
          },
          AutoDelete->False,
          
          BaseStyle->{
           ShowStringCharacters -> False, NumberMarks -> False, 
            PrintPrecision -> 3, ShowSyntaxStyles -> False},
          GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Automatic}}},
          
          GridBoxItemSize->{
           "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
          GridBoxSpacings->{"Columns" -> {{2}}, "Rows" -> {{Automatic}}}]}
       },
       AutoDelete->False,
       BaselinePosition->{1, 1},
       GridBoxAlignment->{"Rows" -> {{Top}}},
       GridBoxItemSize->{
        "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}]}, Dynamic[
      Typeset`open$$],
      ImageSize->Automatic],
     BaselinePosition->Baseline],
    DynamicModuleValues:>{}], "]"}],
  TemporalData[TimeSeries, {CompressedData["
1:eJwNwwk01AkAB+CRCiFJ6UYbNmw2HWMc7zfkiJArV5sc40ioUevFKI8eD0l0
oxfZpiVLbUhTNGbGEbHYR15UUjOMc4z5M+PYYfve+3aHnvcKX0UikRR+LPqR
wiN/Z73MgELgaHZm21uE7njp/ibgATLyWu/4L9zHoroZU6P+N/g3bC8IU/dC
zOvk78uv/FAd5F/t7GWLXSd0mda1wTgtoIcwyDYoq0pSIgfsh4vmjdiQHg/E
3J7zN8mKwQS1sYqSREOQhnnLU+oxjHFp0p2sXUjzmWWGW50Fjx5N880Ixt1m
J3mxy24s+izvs7rIQFhZO6vooD4Muo0Clq0PQIkR3f0q8wA6zaKzbChW+GrU
/IlPWCLYWEkRkbZwuGn3cJbQRUSI4/OCBKCOUmHub2qD/nevvUMRgLVN6vK6
ODvomA3wTdxSkLRJMGx7Yy+UOacrErsiQXBK+w+XpGIk5ig3XXoIrdejelet
8kbcVKXmdIYzurdar0SpJKF0OozZ1+CJ+MElkVFkAIrfCy48Mg8CY/OzIt3y
HIyEpKhGcC9iR+LnbfHeNLTcZbA/hkUh4r3P+3oPOgLyatw5+SlwpjS2xvKz
QIRvbnU1fwHl84paLVtr0OVUtYHPfI21Tzpv9XxpwAQvr0NuxsYe2RVtXYV2
GN83VnTJ+ReJbxquqHX1Yh0zVy6P7YXlHrbKHt0h8GL97qD3G7TXHzwZaTqO
omQGjTMmhIhqKFofxUdr5ff2pLvDcLXjn/OwnsRCz/HAyzYz4Do1Wh26TMD7
SODIimgWTcc3RU5aElgp6OPaF01De3RCLy16CerS6cqrmvPQGVw6b/APgXYa
UsVxEgz+TBFYnyJgnn+y7F7THJTdQ0iqyf9hNuPYpP6ADKkZQ9ZbeCTq2PPD
JqyYWUhdO2t0SqV4SVbLfBAvw4bOC4yUSzJMaZV0tx1aQPREmm1htwI1+ydn
nnKsHJrpMWp1V5ewhdgasMZxHvThtngyewF+z/Xyfc1XsK3Y2bE+YTW12daj
3KuaRO1vK33yzkQOu6Mchf0HFlBvNnZM//YirpWtY/eqS9FAatWQ+S7Aka41
mdQoRW8ctzBk5xw814XWVXdIscx2+chZnMOLi2c6jhhL8bj9SImzkQSvfKKf
TK6X4UTJrRzyBwIJCkYkBp3ADsOcS6b2syhUFdAbLCSwSLUztCoiIBRU3M76
WwJefPRyoiuBZgvh9puGYkg2lgj/sBBjxk/YLZASYD3lZL/rkOERhWU6dX8G
QXKVfXvHxdjoMNDnuWYG2p9Ln53tn0Zuwa1ye64YtEjKW7GEwAnTuVzNOQmu
X1YUXthMgBb0gSjXm4Nz3Jld2/UImBFKThWXJPBWiTXwSJiBX9h88kOzaSSy
FSO60yUw7CsMPqkmRo9WLr9ySYx66pe8qFMSeAZvca9NE8PhRlB6p4MYq895
3SkNEuHrW/2KlXARQkR1A7WECG4jS/nGSVNocuviDalPITm7qpnnOYXlx7/q
mvpNgBv62EYmmoBnbZfiUfoEUv5MD2T9PgnTCKmOgf44Pi3PP8j4OI5v9fYR
5M5R+NZ0fZbGjyOQNain+tcYHC0T+moXhEjRsAv9EDaK4p2R5MyxEdR5pugH
C0bQWclq+aV9GG7l7dSwjUI8JVeJmI182GdqHBxSGkaJ4ot7zNxv+B/uIXfc

    "], CompressedData["
1:eJxdlktuHEkMRGVgFm7NKXwAA/wkf0cQ4JWP4IUBr2ahOY/Paiazimx509Br
VWeRwWBUffnx3/efn15eXt7/yY9vv97//4t+P9Pbv/nHV0UiWMsBDksAIgHc
vBZamGkzkYt7X8+Ebkv6/4wiatxMKuDsq5kWCM398u4eT+cRWh5HT4yLYs3v
wcnk6TyQ7ICaMUTr5ze7ovPUg0tQQef6lc0aDLO78NwPKar6ZozAp34RUz3Z
ir29bg7z3VLjUvU1iILLG9059R+UPLxKOZiDkdVoJHsMN2qsavtGJXUfZESh
RokQCm1Ui+BBWEHYuIwpojvaDlAeRCCyRjbXmPZ5Geg0uN3A0yA5R+hgGkFH
q63bccrrmVww0KCkC3WQlLi0elw6Q3X/ON2DUVMWsXuFt70M8PY5P/urDX31
hg8H5U1wraauoKjL2zS1Fwmxrabu+nFufUlS1HoVpZiwbhqli3oMRT2jTTlA
Z2liXWWVQz3rojbCozpHUGlqCxW1vzaN+YrE6pCL3AO793FtUVu6aFfZCs4y
PI7w16YUfVgjBAgTHVzI1g7FHF+U2w9+3EhElnAb1GykV+FpnQvTU+o4qJSB
NNhZUMgkXKpcKGcTbnSvXL1wcuZgx9BB57yiMYVR88GVHh010ocZHI3ZDhsN
LgjwwRwdjxq7BB01LIsGHlRDHmEthdNRw9PwMWpMsr5e+8A6wgatMuiNHcsH
s0Dt9CLAslNjZ/rBjvzCeSIcXOIMg/38eL328nq8HOynz8FUYhIoh5+ythrE
6VaMQVUTGQynST7KmgJbjQy2TI4YDApvm+3gk0lcykfmlTMHU3UfNRRPOt8o
YBPtubJ31hTu+eGoYXsXddA0q250uPPm4AJco4bb3pXGSJ/MwypX4c6cg6ps
o0aEBbTNtm/W4kG9c+dgkEKrkWbd6z3YLxQH/c6ewnz9qIndKFCbcaNjpc+F
jHf+HFwCSoOmmRSNqQTWi8AfRVFy7g==
    "], 1, {"Continuous", 1}, {
    "Discrete", 1}, 1, {
    DateFunction -> Automatic, 
     ResamplingMethod -> {"Interpolation", InterpolationOrder -> 1}}}, True, 
   11.1],
  Editable->False,
  SelectWithContents->True,
  Selectable->False]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[19]=",ExpressionUUID->"809b9438-4e1b-4de3-b026-ca8c1f876435"]
}, Open  ]],

Cell["\<\
Cars started to exist around 1900, but gradually stopped being called \
\[OpenCurlyDoubleQuote]automobiles\[CloseCurlyDoubleQuote]:\
\>", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"aa7f45b7-c2d3-4887-a27f-5d1da8621dc1"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DateListPlot", "[", 
  RowBox[{"WordFrequencyData", "[", 
   RowBox[{"\"\<automobile\>\"", ",", "\"\<TimeSeries\>\""}], "]"}], 
  "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[20]:=",ExpressionUUID->"4fc0ae50-e7c7-4583-80fd-282fd88ca580"],

Cell[BoxData[
 GraphicsBox[{{}, {{}, {}, 
    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.009166666666666668], 
     AbsoluteThickness[1.6], LineBox[CompressedData["
1:eJw1lQk41ekawI/MjD3JFNqcuaEw4zIVx/LgzRJt9q07sjNCjuRmaTxHw6Xb
hLTXHUspZciSpIjzHUu2jtNYsjucw2GsdSxhcPP5///Pc57z/J73/d7v/d71
O+9Qe79NFAol/ctv/f/L1xnKnkc0lu5Q2YtE4y9MrVqeQyLuo1eSGt6sM8cm
YgZ573xh89rt/jpn+sZNo8TU+huui7exvsWyAC3J6GTLVvxrnU0/XxIg16od
d31l7Ne5cCuTh4JfxQ6tvnTB8n8XcdFzD9fn1vZA2Oei3Y7K2Ualnuvsqa7P
Raf5dK9oXVPivgH0pDhGTNdNe52ZChID6JhccohXq+06cxtT+1Hw9TlXzcvB
mFP29aFxk+piWowPZsfKHuQhq1f31OQotk/PakdjyGd+V9nudWbsVW9H8U6z
2X6GZ/B9HYVtiEUP8nFOxP5k3j/Sim7WWq1kHPsOs2f/e7TktPqDYXg0ZtUI
DvJ90lSWfkAF2zPc9w6pctTdVo1+xP5m6TYjseggzsskzBRxyybE1gm6bEoz
xPE469SIBtRre3hCA6yv6duAPDXERI0DcHwoaeH1yOKa2e+zQmXMu7Jqkb+X
ZcHdSGN8/lJhDSqn5em5auF4MUarqlHX21cO3sZu2N7JFhb6pkZmpTzMDOtL
9yO0R6ebp3mCgfXPTTJRzLf8YUjej+3HKlYicebpvKiWAMyLhyqQkJnTdSgr
DuvXOr5GI8FHUML8QcK/MlT/W2Dbpk0OWH46rRSFTebLTSdaY+4qKEEcRaO1
QIkYrP+YXYxypn2zO6rsiPsLUUT/8pR6gBtx/zOU0cg/l6nngfm8Qy6K3vYs
XTn3KmaZa4/RiBdDyh+FE/YeoJ1RvUoRDj7E+XRUdzO6stM3EPOZ5FvIv9Gp
scKWjpkmn4zcUktsmHcYBMcia1p1fQjvsjGF+IR+2+qP6xWRchAPFZWvUywh
z0OLVfEWXvYr0j5884id1tpXRcjTYZyV2ryiU0n6B3sXftmuLNJE+g8atzVE
j119T74Pol5X/SLd0oa5Z9szkMxOWVkJaSPjAwZ7KyX2KnPJ+AErxOWGcdsg
GV/YvvnAqQCtvwj7pZAeG+3DHBOQ+YEpE7WpzYE8Mn9Qnz/UFHNzmMwvHDfj
nbU1msDy7xUqYbH1pPtF04+YixarAFlVGx68KCTrBRwOu4+sTc2S9QQ1J78N
mDAQEv6xYO1uBzJPnybrEbaPjlPjg5bJegWZ+en8S3KfyXqGPf3Loarv8Hnm
i2t10ORjHDcT9omYJ2+hfx+Nb/STkOwH0Ltz6smtmjmyX0DcxosiFfs38b5G
mE08OqHSvUD2G8Qlco0UWBQToh9hrOCQZlnwLNmvMH+cXbInZx7f167Ahhe6
0kn3IxaIedMCW9jnohkXFoh4tMCkfBan4eAi2f8QNB4P9zgiJhvx4cCVf1iz
xENW8Hl5//cglxAsXX5pmZwfoCBUdPvaEr+fke/8J9CHGyJ0K7E9zyX2n+BS
QL3jrLdGzh9QyrC2rIj8ymQjnq1QC7a59s/xezwP0dqgqyHn0VvNFSK+bWB2
hCmi/eMiOd+gQmfsqMr1JXL+wX+fSFa2yWy8941SB1RR6mUXnLE+VTKtAyzp
8hMx1Vju+YfkB2gLQ/e8ds0R+fgAdpLe5c+b54n5/wFWK491MpfmiPx0QlH4
z82HNTbsH5johIdNh7Os1XE+qQzfLnjpFPRoYvNGft71doFjVtpV3XacX66S
UzdEiqhToumYqeXvumGn2tULWuazRD574J4Un16l/4mc76AfZ6ZmmC4k5m0v
CPh51y8XYjnFrKAXWBFBq1HHheR+gFp9wY5rajNYvzejDz5tzRI80Mecqa7Y
Dx9dBBz+vJDcL1D2lHnlbTNZDwOQSSvTmrz9kdxP4LEi8cP+v2aI+hiArRbd
HXZffyT3GWzvzXl2pmua3HeQcjct1xzNkPsQfAJob2Y+4fsK/zfJBUetuRS5
Oey/7aT6IPx2UVRwbpuQqKdB8PFoF+ZScby1DR4MgnXYz7t3UIVEfQ2CjlDM
Ku/CRv8U7RgCB4kQVdtI7E/hB+chcPH9HPu7DvaHupo2BFGVov6cBKyfqtIy
BGod9zxPSWP/tCOkeNAqn8LLX54h6pEHFSZ9qYE/Yf0trF95YOepYFMaP0P0
Ow8skj0S2BaYqfp/8+Crs/Y3cjymsH0PGh8G3qjkrflhpvznPB+8psq7S4WY
6XmFfDgxsnxHI2YS21+Z4EPNiRYWV2aSqOdhiL1SXMuywzxj7TcMqw//qazl
Mk7U9zAg74emC1OYKahvGOxKW0SP0DHTBUojwHic4F52Hs87rozzCGj5z+9R
VcHz0/Zg2gj0rH6+n9iJeSaePQKDFeb+uuxRoh8E4FzS0jsfgeWc95YCcC/r
p0r9MUb0hwAsDSI7Shfx/OVaVQmAIWvm3e6Lz9uGLgsgY1eAbtLYCM7nTb1R
KLdjqHjyMWtXhI8CO7+s7vsmPJ850oWjcCK3ycR3q4Dop1F4qls8lV2N53mh
2/4xME+SPcAVGyb6awyyRItuZacMGv8fcYgMtA==
      
      "]]}}, {}, {}, {{}, {}}, {{}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{False, False},
  AxesLabel->{None, None},
  AxesOrigin->{-6.1220448*^9, 0},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->
   FrontEndValueCache[{{Automatic, Automatic}, {Charting`FindScaledTicks[
       (Charting`getDateTicks[Automatic, {Automatic}, 
        (Map[DateList, {
          SlotSequence[1]}]& )[
         SlotSequence[1]], None, 5, {{0.0125, 0}, {0.0075, 0}}, Automatic]& )[
       
        SlotSequence[1]], {Identity, Identity}]& , Charting`ScaledFrameTicks[
       (Charting`getDateTicks[Charting`getDateTicks[Automatic, {Automatic}, 
         (Map[DateList, {
           SlotSequence[1]}]& )[
          SlotSequence[1]], None, 5, {{0.0125, 0}, {0.0075, 0}}, 
         Automatic]& , {Automatic}, 
        (Map[DateList, {
          SlotSequence[1]}]& )[
         SlotSequence[1]], None, 5, {{0.0125, 0}, {0.0075, 0}}, None]& )[
        SlotSequence[1]], {Identity, Identity}]& }}, {{
     Automatic, Automatic}, {{{-6.3113472*^9, 
        FormBox["\"1700\"", TraditionalForm], {0.008333333333333333, 
        0.}}, {-3.1556736*^9, 
        FormBox["\"1800\"", TraditionalForm], {0.008333333333333333, 0.}}, {
       0., 
        FormBox["\"1900\"", TraditionalForm], {0.008333333333333333, 0.}}, {
       3.1556736*^9, 
        FormBox["\"2000\"", TraditionalForm], {0.008333333333333333, 0.}}, {
       6.3114336*^9, 
        FormBox["\"2100\"", TraditionalForm], {0.008333333333333333, 
        0.}}, {-6.3113472*^9, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
        0.008333333333333333, 0.}}, {-5.6802816*^9, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
        0.008333333333333333, 0.}}, {-5.0491296*^9, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
        0.008333333333333333, 0.}}, {-4.4179776*^9, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
        0.008333333333333333, 0.}}, {-3.7868256*^9, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
        0.008333333333333333, 0.}}, {-3.1556736*^9, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
        0.008333333333333333, 0.}}, {-2.524608*^9, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
        0.008333333333333333, 0.}}, {-1.893456*^9, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
        0.008333333333333333, 0.}}, {-1.262304*^9, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
        0.008333333333333333, 0.}}, {-6.31152*^8, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
        0.008333333333333333, 0.}}, {0., 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
        0.008333333333333333, 0.}}, {6.310656*^8, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
        0.008333333333333333, 0.}}, {1.2622176*^9, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
        0.008333333333333333, 0.}}, {1.8933696*^9, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
        0.008333333333333333, 0.}}, {2.5245216*^9, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
        0.008333333333333333, 0.}}, {3.1556736*^9, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
        0.008333333333333333, 0.}}}, {{-6.3113472*^9, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
        0.008333333333333333, 0.}}, {-3.1556736*^9, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
        0.008333333333333333, 0.}}, {0., 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
        0.008333333333333333, 0.}}, {3.1556736*^9, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
        0.008333333333333333, 0.}}, {6.3114336*^9, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
        0.008333333333333333, 0.}}, {-6.3113472*^9, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
        0.008333333333333333, 0.}}, {-5.6802816*^9, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
        0.008333333333333333, 0.}}, {-5.0491296*^9, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
        0.008333333333333333, 0.}}, {-4.4179776*^9, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
        0.008333333333333333, 0.}}, {-3.7868256*^9, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
        0.008333333333333333, 0.}}, {-3.1556736*^9, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
        0.008333333333333333, 0.}}, {-2.524608*^9, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
        0.008333333333333333, 0.}}, {-1.893456*^9, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
        0.008333333333333333, 0.}}, {-1.262304*^9, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
        0.008333333333333333, 0.}}, {-6.31152*^8, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
        0.008333333333333333, 0.}}, {0., 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
        0.008333333333333333, 0.}}, {6.310656*^8, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
        0.008333333333333333, 0.}}, {1.2622176*^9, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
        0.008333333333333333, 0.}}, {1.8933696*^9, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
        0.008333333333333333, 0.}}, {2.5245216*^9, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
        0.008333333333333333, 0.}}, {3.1556736*^9, 
        FormBox[
         InterpretationBox[
          StyleBox[
           
           GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
            Baseline], "CacheGraphics" -> False], 
          Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
        0.008333333333333333, 0.}}}}}],
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{-6.1220448*^9, 3.4081344*^9}, {0, 0.00003904652183877987}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.05]}},
  Ticks->{{}, Automatic}]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[20]=",ExpressionUUID->"58526deb-c301-4f63-9346-390ee2b53594"]
}, Open  ]],

Cell[TextData[{
 ButtonBox["WordFrequencyData",
  BaseStyle->"Link"],
 " is set up to make it easy to compare frequencies of different words. Let\
\[CloseCurlyQuote]s see how \[OpenCurlyDoubleQuote]monarchy\
\[CloseCurlyDoubleQuote] and \[OpenCurlyDoubleQuote]democracy\
\[CloseCurlyDoubleQuote] have fared over the years. \
\[OpenCurlyDoubleQuote]Democracy\[CloseCurlyDoubleQuote] is definitely more \
popular now, but \[OpenCurlyDoubleQuote]monarchy\[CloseCurlyDoubleQuote] was \
more popular in the 1700s and 1800s."
}], "Text",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->{
  "LastCellOfAPage", 
   "i:22"},ExpressionUUID->"ffcede94-db0c-484e-9793-70727c569c1b"],

Cell["\<\
Compare historical word frequency between \[OpenCurlyDoubleQuote]monarchy\
\[CloseCurlyDoubleQuote] and \[OpenCurlyDoubleQuote]democracy\
\[CloseCurlyDoubleQuote]:\
\>", "CodeCaption",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"f036bc86-8791-485d-a6ed-930f11db651e"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DateListPlot", "[", 
  RowBox[{"WordFrequencyData", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\"\<monarchy\>\"", ",", "\"\<democracy\>\""}], "}"}], ",", 
    "\"\<TimeSeries\>\""}], "]"}], "]"}]], "Input",
 Deletable->False,
 CellLabel->"In[21]:=",ExpressionUUID->"4a71c3d1-908d-46ac-8717-6983ffe54190"],

Cell[BoxData[
 TemplateBox[{
   GraphicsBox[{{}, {{{}, {}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         PointSize[0.0055000000000000005`], 
         RGBColor[0.368417, 0.506779, 0.709798], 
         AbsoluteThickness[1.6]], 
        LineBox[CompressedData["
1:eJw1V3k8lOsXV27Zs5W1ol9KiXYiwtNG3euSivYmVyoVriXt2ZLSIktUKmW5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         "]]}, {
        Hue[0.9060679774997897, 0.6, 0.6], 
        Directive[
         PointSize[0.0055000000000000005`], 
         RGBColor[0.880722, 0.611041, 0.142051], 
         AbsoluteThickness[1.6]], 
        LineBox[CompressedData["
1:eJw1V3k8lekXJ9mjqQgp0TTJ8ps0NfbBU7JMjVKEmgptU9lSRKulLE0jY2nT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         "]]}}}, {}, {}, {{}, {}}, {{}, {}}}, {
    DisplayFunction -> Identity, DisplayFunction -> Identity, 
     PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {
        Scaled[0.02], 
        Scaled[0.05]}}, AxesOrigin -> {-6.3113472*^9, 0}, 
     PlotRange -> {{-6.3113472*^9, 3.4081344*^9}, {
       0, 0.00008006671353682453}}, PlotRangeClipping -> True, ImagePadding -> 
     All, DisplayFunction -> Identity, AspectRatio -> 
     NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {False, False}, 
     AxesLabel -> {None, None}, AxesOrigin -> {-6.3113472*^9, 0}, 
     DisplayFunction :> Identity, Frame -> {{True, True}, {True, True}}, 
     FrameLabel -> {{None, None}, {None, None}}, 
     FrameTicks -> {{Automatic, Automatic}, {Charting`FindScaledTicks[
         (Charting`getDateTicks[Automatic, {Automatic}, 
          (Map[DateList, {
            SlotSequence[1]}]& )[
           SlotSequence[1]], None, 5, {{0.0125, 0}, {0.0075, 0}}, 
          Automatic]& )[
          SlotSequence[1]], {Identity, Identity}]& , Charting`ScaledFrameTicks[
         (Charting`getDateTicks[
         Charting`getDateTicks[Automatic, {Automatic}, 
           (Map[DateList, {
             SlotSequence[1]}]& )[
            SlotSequence[1]], None, 5, {{0.0125, 0}, {0.0075, 0}}, 
           Automatic]& , {Automatic}, 
          (Map[DateList, {
            SlotSequence[1]}]& )[
           SlotSequence[1]], None, 5, {{0.0125, 0}, {0.0075, 0}}, None]& )[
          SlotSequence[1]], {Identity, Identity}]& }}, 
     GridLines -> {None, None}, GridLinesStyle -> Directive[
       GrayLevel[0.5, 0.4]], 
     Method -> {"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
           (Identity[#]& )[
            Part[#, 1]], 
           (Identity[#]& )[
            Part[#, 2]]}& ), "CopiedValueFunction" -> ({
           (Identity[#]& )[
            Part[#, 1]], 
           (Identity[#]& )[
            Part[#, 2]]}& )}}, 
     PlotRange -> {{-6.3113472*^9, 3.4081344*^9}, {
       0, 0.00008006671353682453}}, PlotRangeClipping -> True, 
     PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {
        Scaled[0.02], 
        Scaled[0.05]}}, Ticks -> {{}, Automatic}}], 
   FormBox[
    FormBox[
     TemplateBox[{"\"monarchy\"", "\"democracy\""}, "LineLegend", 
      DisplayFunction -> (FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.099], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.099], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.099], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.099], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #2}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {
                  "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
         FontFamily -> "Arial"}, Background -> Automatic, StripOnInput -> 
         False], TraditionalForm]& ), 
      InterpretationFunction :> (RowBox[{"LineLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", "0.0055000000000000005`", "]"}], 
                   ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> 
                    RGBColor[
                    0.24561133333333335`, 0.3378526666666667, 
                    0.4731986666666667], FrameTicks -> None, PlotRangePadding -> 
                    None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    "RGBColor[0.368417, 0.506779, 0.709798]"], Appearance -> 
                    None, BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.368417, 0.506779, 0.709798]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.368417, 0.506779, 0.709798], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", "0.0055000000000000005`", "]"}], 
                   ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> 
                    RGBColor[
                    0.587148, 0.40736066666666665`, 0.09470066666666668], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    "RGBColor[0.880722, 0.611041, 0.142051]"], Appearance -> 
                    None, BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.880722, 0.611041, 0.142051]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.880722, 0.611041, 0.142051], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}]}],
              "}"}], ",", 
           RowBox[{"{", 
             RowBox[{#, ",", #2}], "}"}], ",", 
           RowBox[{"LegendMarkers", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}]}], "}"}]}], ",", 
           RowBox[{"Joined", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{"True", ",", "True"}], "}"}]}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"{", "}"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& ), 
      Editable -> True], TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"], 
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]], "Output",
 Editable->False,
 CellEditDuplicate->False,
 Evaluatable->False,
 CellLabel->"Out[21]=",ExpressionUUID->"5aa02b2b-adfc-4f99-aabd-b52dd4df85b1"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Vocabulary", "VocabularySection",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"8ad40a74-9391-48a7-aeb7-7cc758c8f905"],

Cell[BoxData[GridBox[{
   {
    ButtonBox["Now",
     BaseStyle->"CodeLink"], " ", Cell[
    "current date and time ", "VocabularyText",ExpressionUUID->
     "6f71f830-18de-4d35-92d1-4740c26c0d71"]},
   {
    ButtonBox["Today",
     BaseStyle->"CodeLink"], " ", Cell[
    "date object for today ", "VocabularyText",ExpressionUUID->
     "90734239-6af1-47d8-a13d-b4f3ebb0588a"]},
   {
    ButtonBox["Tomorrow",
     BaseStyle->"CodeLink"], " ", Cell[
    "date object for tomorrow ", "VocabularyText",ExpressionUUID->
     "d329a8b6-9b02-44d0-89c3-62cce2aeaf00"]},
   {
    ButtonBox["Yesterday",
     BaseStyle->"CodeLink"], " ", Cell[
    "date object for yesterday ", "VocabularyText",ExpressionUUID->
     "ae891278-c032-49c5-a926-7cae847b4071"]},
   {
    RowBox[{
     ButtonBox["DayRange",
      BaseStyle->"CodeLink"], "[", 
     RowBox[{
      SubscriptBox[
       StyleBox["date", "CodeVariableLrg"], "1"], ",", 
      SubscriptBox[
       StyleBox["date", "CodeVariableLrg"], "2"]}], "]"}], " ", Cell[TextData[{
     "list of dates from ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["date", "CodeVariable"], "1"]], "InlineCode",ExpressionUUID->
      "87bcad7b-99e9-4abc-80e1-110948e49cb5"],
     " to ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["date", "CodeVariable"], "2"]], "InlineCode",ExpressionUUID->
      "2b58f74e-df00-40bd-b0ba-914a8892f23c"],
     " "
    }], "VocabularyText",ExpressionUUID->
     "5c9f5044-ef2f-43b6-a2c9-ae59ee21fba7"]},
   {
    RowBox[{
     ButtonBox["DayName",
      BaseStyle->"CodeLink"], "[", 
     StyleBox["date", "CodeVariableLrg"], "]"}], " ", Cell[TextData[{
     "day of the week of ",
     Cell[BoxData[
      StyleBox["date", "CodeVariable"]], "InlineCode",ExpressionUUID->
      "9c4736fa-b78a-4d1b-a3a8-8c573b26ae47"]
    }], "VocabularyText",ExpressionUUID->
     "152f1a1e-8343-461b-b08d-ed9ddd0a2b96"]},
   {
    RowBox[{
     ButtonBox["MoonPhase",
      BaseStyle->"CodeLink"], "[", 
     StyleBox["date", "CodeVariableLrg"], "]"}], " ", Cell[TextData[{
     "moon phase on ",
     Cell[BoxData[
      StyleBox["date", "CodeVariable"]], "InlineCode",ExpressionUUID->
      "57ae07b1-251e-4304-8809-21dacf28541a"],
     " "
    }], "VocabularyText",ExpressionUUID->
     "59ccd9bb-d891-4883-a3dc-50e72a781f25"]},
   {
    RowBox[{
     ButtonBox["Sunrise",
      BaseStyle->"CodeLink"], "[", 
     RowBox[{
      StyleBox["location", "CodeVariableLrg"], ",", 
      StyleBox["date", "CodeVariableLrg"]}], "]"}], " ", Cell[TextData[{
     "time of sunrise on ",
     Cell[BoxData[
      StyleBox["date", "CodeVariable"]], "InlineCode",ExpressionUUID->
      "d7c97769-740d-4404-a0cd-3abb0a019889"],
     " at ",
     Cell[BoxData[
      StyleBox["location", "CodeVariable"]], "InlineCode",ExpressionUUID->
      "a2d1c5c2-7010-427c-86aa-637d226130f0"],
     " "
    }], "VocabularyText",ExpressionUUID->
     "f3f88ec1-98cc-44bc-a213-8c1aa851b53c"]},
   {
    RowBox[{
     ButtonBox["Sunset",
      BaseStyle->"CodeLink"], "[", 
     RowBox[{
      StyleBox["location", "CodeVariableLrg"], ",", 
      StyleBox["date", "CodeVariableLrg"]}], "]"}], " ", Cell[TextData[{
     "time of sunset on ",
     Cell[BoxData[
      StyleBox["date", "CodeVariable"]], "InlineCode",ExpressionUUID->
      "9cc7590c-e531-4611-8c25-414e4903c183"],
     " at ",
     Cell[BoxData[
      StyleBox["location", "CodeVariable"]], "InlineCode",ExpressionUUID->
      "ef539f86-2855-4a01-a594-69bf33752e11"],
     " "
    }], "VocabularyText",ExpressionUUID->
     "cead2acc-c248-4cda-8d38-8c82ab48897c"]},
   {
    RowBox[{
     ButtonBox["LocalTime",
      BaseStyle->"CodeLink"], "[", 
     StyleBox["location", "CodeVariableLrg"], "]"}], " ", Cell[TextData[{
     "current time at ",
     Cell[BoxData[
      StyleBox["location", "CodeVariable"]], "InlineCode",ExpressionUUID->
      "5c7ae218-7876-4ac7-85d8-d3e262b086e1"],
     " "
    }], "VocabularyText",ExpressionUUID->
     "8b118ad6-7475-4f90-ad9b-f98deda5a11b"]},
   {
    RowBox[{
     ButtonBox["AirTemperatureData",
      BaseStyle->"CodeLink"], "[", 
     RowBox[{
      StyleBox["location", "CodeVariableLrg"], ",", 
      StyleBox["time", "CodeVariableLrg"]}], "]"}], " ", Cell[TextData[{
     "air temperature at ",
     Cell[BoxData[
      StyleBox["time", "CodeVariable"]], "InlineCode",ExpressionUUID->
      "eac6243a-c686-437b-b3e1-40743cadaeaa"],
     " at ",
     Cell[BoxData[
      StyleBox["location", "CodeVariable"]], "InlineCode",ExpressionUUID->
      "596d1229-0106-4b64-bc8a-a11c9dc744fd"],
     " "
    }], "VocabularyText",ExpressionUUID->
     "4110eaed-92f4-4d74-b5d7-09c86574dada"]},
   {
    RowBox[{
     ButtonBox["AirTemperatureData",
      BaseStyle->"CodeLink"], "[", 
     RowBox[{
      StyleBox["location", "CodeVariableLrg"], ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["time", "CodeVariableLrg"], "1"], ",", 
        SubscriptBox[
         StyleBox["time", "CodeVariableLrg"], "2"]}], "}"}]}], "]"}], " ", 
    Cell[TextData[{
     "time series of air temperatures from\[LineSeparator]",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["time", "CodeVariable"], "1"]], "InlineCode",ExpressionUUID->
      "c08f62e1-7ea0-46f6-891f-4368e8a7ca9e"],
     " to ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["time", "CodeVariable"], "2"]], "InlineCode",ExpressionUUID->
      "eb80f4b2-a53f-490a-8250-8c1ada4099e5"],
     " at ",
     Cell[BoxData[
      StyleBox["location", "CodeVariable"]], "InlineCode",ExpressionUUID->
      "a63d4518-21bb-4772-98d7-df77d93d468e"],
     " "
    }], "VocabularyText",ExpressionUUID->
     "d5d0eb6e-dbf2-44b1-a11d-9f8c9542c978"]},
   {
    RowBox[{
     ButtonBox["DateListPlot",
      BaseStyle->"CodeLink"], "[", 
     StyleBox["timeseries", "CodeVariableLrg"], "]"}], " ", Cell[
    "plot a time series ", "VocabularyText",ExpressionUUID->
     "04afde81-1fbc-4d77-a976-734f124c979f"]},
   {
    RowBox[{
     ButtonBox["WordFrequencyData",
      BaseStyle->"CodeLink"], "[", 
     RowBox[{
     "\"\<\!\(\*StyleBox[\"word\", \"CodeVariableLrg\"]\)\>\"", ",", 
      "\"\<TimeSeries\>\""}], "]"}], " ", Cell[
    "time series of word frequencies", "VocabularyText",ExpressionUUID->
     "635448e9-e78f-46d0-ae68-07be7f27cea8"]}
  }]], "VocabularyTable",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 GridBoxOptions->{GridBoxDividers->{"Columns" -> {{False}}}},
 CellTags->
  "LastCellOfAPage",ExpressionUUID->"41623163-6491-4748-81af-e1ecb58c1fa9"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 DynamicModuleBox[{$CellContext`open$$ = False}, 
  TagBox[GridBox[{
     {
      StyleBox["\<\"Exercises\"\>",
       StripOnInput->False,
       FontSlant->"Italic"], 
      PaneBox[
       TagBox[
        ButtonBox[
         DynamicBox[ToBoxes[
           If[$CellContext`open$$, 
            Row[{
              Style["-", "ExercisePreviewButtonTextHighlight"], 
              Style[" Preview Exercises", "ExercisePreviewButtonText"]}], 
            Row[{
              Style["+", "ExercisePreviewButtonTextHighlight"], 
              Style[" Preview Exercises", "ExercisePreviewButtonText"]}]], 
           StandardForm],
          ImageSizeCache->{115., {1., 10.}}],
         Appearance->None,
         ButtonFunction:>(
          If[$CellContext`open$$, $CellContext`open$$ = 
            False, $CellContext`open$$ = True]; NotebookFind[
            EvaluationNotebook[], "ExerciseSummaryCell", Next, CellStyle, 
            WrapAround -> True, AutoScroll -> False]; FrontEndTokenExecute[
            EvaluationNotebook[], "ExpandSelection"]; FrontEndExecute[
            FrontEndToken[
             EvaluationNotebook[], "OpenCloseGroup"]]),
         Evaluator->Automatic,
         Method->"Preemptive"],
        MouseAppearanceTag["LinkHand"]],
       Alignment->Right,
       ImageSize->Full]}
    },
    AutoDelete->False,
    GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Grid"],
  DynamicModuleValues:>{}]], "ExerciseSection",
 Editable->False,
 ShowCellBracket->False,
 GeneratedCell->True,
 CellAutoOverwrite->True,
 CellChangeTimes->{3.669991951589675*^9},
 ShowStringCharacters->
  False,ExpressionUUID->"57381f34-021a-470b-bb01-e077726ad48a"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[GridBox[{
    {
     TagBox[GridBox[{
        {
         PaneBox[
          
          StyleBox["\<\"13 Exercises Available\"\>", "ExerciseSummaryHeading",
           
           StripOnInput->False],
          ImageMargins->{{20, 0}, {0, 10}}]},
        {
         PaneBox[
          StyleBox["\<\"with 7 extras\"\>", "ExerciseSummarySubheading",
           StripOnInput->False],
          ImageMargins->{{20, 0}, {10, 0}}]}
       },
       DefaultBaseStyle->"Column",
       GridBoxAlignment->{"Columns" -> {{Left}}},
       GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
       
       GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{0}}}],
      "Column"], 
     PaneBox[
      ButtonBox[
       StyleBox["\<\"Get Started \[RightGuillemet]\"\>", 
        "ExerciseSummaryHeading",
        StripOnInput->False],
       Appearance->None,
       ButtonFunction:>
        NotebookLocate[{"EIWL2-19-dates-and-times-exercises.nb", ""}],
       Evaluator->Automatic,
       Method->"Preemptive"],
      FrameMargins->{{10, 0}, {10, 10}},
      ImageSize->Full]}
   },
   AutoDelete->False,
   GridBoxAlignment->{"Columns" -> {{Left}}},
   GridBoxItemSize->{"Columns" -> {
       Scaled[0.7], 
       Scaled[0.3]}, "Rows" -> {{Automatic}}}],
  "Grid"]], "ExerciseSummaryCell",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"07d71e2e-fcb8-415b-8ad1-eae1095625ad"],

Cell[CellGroupData[{

Cell[TextData[{
 "Compute how many days have elapsed since January 1, 1900.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "19.1", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"20dc3d30-a0ae-4181-ad1f-b70f3bedb5d5"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Sample", " ", "expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       TemplateBox[{"42809.`", "\"days\"", "days", "\"Days\""},
        "Quantity"]], "ExerciseOutput",ExpressionUUID->
       "5c5b1f01-0faf-4ca3-809d-f165f43c3408"],
      Apply[TextCell, 
       Cell[
        BoxData[
         TemplateBox[{"42809.`", "\"days\"", "days", "\"Days\""}, 
          "Quantity"]], "ExerciseOutput", Selectable -> False, Copyable -> 
        False, Editable -> False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"fb588fed-d453-471c-9df6-308ca360ecac"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Compute what day of the week January 1, 2000 was.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "19.2", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"abafec3e-e60b-428b-8bb2-72c8c3c53250"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Sample", " ", "expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
      "Saturday"], "ExerciseOutput",ExpressionUUID->
       "01564a9a-d480-4072-8c4f-0d3adab254fa"],
      Apply[TextCell, 
       Cell[
        BoxData["Saturday"], "ExerciseOutput", Selectable -> False, Copyable -> 
        False, Editable -> False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"4e5cc5f1-62c4-4bc2-a8f6-bc688c57ee44"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Find the date a hundred thousand days ago.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "19.3", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"c17111ed-a7df-4efe-a89d-089d06ee8434"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Sample", " ", "expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       TemplateBox[{
         RowBox[{"\"Sun 2 Jun 1743 14:40:00\"", 
           StyleBox[
            RowBox[{"\"GMT\"", "\[InvisibleSpace]", 
              RowBox[{"-", "5.`"}]}], FontColor -> GrayLevel[0.5]]}], 
         RowBox[{"DateObject", "[", 
           RowBox[{
             RowBox[{"{", 
               
               RowBox[{
                "1743", ",", "6", ",", "2", ",", "14", ",", "40", ",", 
                 "0.4116687774658203`"}], "}"}], ",", "\"Instant\"", ",", 
             "\"Gregorian\"", ",", 
             RowBox[{"-", "5.`"}]}], "]"}]},
        "DateObject",
        Editable->False]], "ExerciseOutput",ExpressionUUID->
       "c51a7589-9250-4fb3-a9da-59ee40a11cf0"],
      Apply[TextCell, 
       Cell[
        BoxData[
         TemplateBox[{
           RowBox[{"\"Sun 2 Jun 1743 14:40:00\"", 
             StyleBox[
              RowBox[{"\"GMT\"", "\[InvisibleSpace]", 
                RowBox[{"-", "5.`"}]}], FontColor -> GrayLevel[0.5]]}], 
           RowBox[{"DateObject", "[", 
             RowBox[{
               RowBox[{"{", 
                 
                 RowBox[{
                  "1743", ",", "6", ",", "2", ",", "14", ",", "40", ",", 
                   "0.4116687774658203`"}], "}"}], ",", "\"Instant\"", ",", 
               "\"Gregorian\"", ",", 
               RowBox[{"-", "5.`"}]}], "]"}]}, "DateObject", Editable -> 
          False]], "ExerciseOutput", Selectable -> False, Copyable -> False, 
        Editable -> False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"9158a55d-544a-4c82-a9f4-532e65a278c8"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Find the local time in Delhi.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "19.4", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"f5733391-fb6e-4ce4-a9db-399b207bbe48"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Sample", " ", "expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       TemplateBox[{
         RowBox[{"\"Fri 17 Mar 2017 01:15:29\"", 
           StyleBox[
            RowBox[{"\"GMT+\"", "\[InvisibleSpace]", "5.5`"}], FontColor -> 
            GrayLevel[0.5]]}], 
         RowBox[{"DateObject", "[", 
           RowBox[{
             RowBox[{"{", 
               
               RowBox[{
                "2017", ",", "3", ",", "23", ",", "1", ",", "15", ",", 
                 "29.69546890258789`"}], "}"}], ",", "\"Instant\"", ",", 
             "\"Gregorian\"", ",", "5.5`"}], "]"}]},
        "DateObject",
        Editable->False]], "ExerciseOutput",ExpressionUUID->
       "a1829790-78f0-4ed1-9115-0ee64940f8b8"],
      Apply[TextCell, 
       Cell[
        BoxData[
         TemplateBox[{
           RowBox[{"\"Fri 17 Mar 2017 01:15:29\"", 
             StyleBox[
              RowBox[{"\"GMT+\"", "\[InvisibleSpace]", "5.5`"}], FontColor -> 
              GrayLevel[0.5]]}], 
           RowBox[{"DateObject", "[", 
             RowBox[{
               RowBox[{"{", 
                 
                 RowBox[{
                  "2017", ",", "3", ",", "23", ",", "1", ",", "15", ",", 
                   "29.69546890258789`"}], "}"}], ",", "\"Instant\"", ",", 
               "\"Gregorian\"", ",", "5.5`"}], "]"}]}, "DateObject", Editable -> 
          False]], "ExerciseOutput", Selectable -> False, Copyable -> False, 
        Editable -> False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"71d91be6-4247-4ced-8a64-f637c46f703f"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Find the length of daylight today by subtracting today\[CloseCurlyQuote]s \
sunrise from today\[CloseCurlyQuote]s sunset.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "19.5", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"502df17c-7dbe-4c1c-8f2d-e4b2851ca0e0"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Sample", " ", "expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       TemplateBox[{
         RowBox[{"-", "717"}], "\"min\"", "minutes", "\"Minutes\""},
        "Quantity"]], "ExerciseOutput",ExpressionUUID->
       "22e50067-ae04-44f2-b47f-7de85b728cd4"],
      Apply[TextCell, 
       Cell[
        BoxData[
         TemplateBox[{
           RowBox[{"-", "717"}], "\"min\"", "minutes", "\"Minutes\""}, 
          "Quantity"]], "ExerciseOutput", Selectable -> False, Copyable -> 
        False, Editable -> False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"17b58ac6-732f-48c6-8d5b-91aaa5bab660"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Generate an icon for the current phase of the moon.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "19.6", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"d0021686-37eb-4ed3-8a48-f559a9ea766a"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Sample", " ", "expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       GraphicsBox[{
         {GrayLevel[0.75], 
          PolygonBox[{{-1.1, -1.3}, {1.1, -1.3}, {1.3, -1.1}, {1.3, 1.1}, {
           1.1, 1.3}, {-1.1, 1.3}, {-1.3, 1.1}, {-1.3, -1.1}}], 
          DiskBox[{-1.1, -1.1}, 0.2], DiskBox[{1.1, -1.1}, 0.2], 
          DiskBox[{1.1, 1.1}, 0.2], DiskBox[{-1.1, 1.1}, 0.2]}, 
         {GrayLevel[1], 
          DiskBox[{0, 0}, 1, 
           NCache[{Rational[1, 2] Pi, Rational[3, 2] Pi}, {
            1.5707963267948966`, 4.71238898038469}]]}, 
         {GrayLevel[1], DiskBox[{0, 0}, {0.5194101409662437, 1.}]}, 
         {GrayLevel[0.6], CircleBox[{0, 0}]}},
        AspectRatio->1,
        ImageSize->100]], "ExerciseOutput",ExpressionUUID->
       "1baff29a-572f-417c-85e8-5ad17cee1d8c"],
      Apply[TextCell, 
       Cell[
        BoxData[
         GraphicsBox[{{{{
              GrayLevel[0.75], 
              
              PolygonBox[{{-1.1, -1.3}, {1.1, -1.3}, {1.3, -1.1}, {1.3, 
               1.1}, {1.1, 1.3}, {-1.1, 1.3}, {-1.3, 1.1}, {-1.3, -1.1}}], 
              DiskBox[{-1.1, -1.1}, 0.2], 
              DiskBox[{1.1, -1.1}, 0.2], 
              DiskBox[{1.1, 1.1}, 0.2], 
              DiskBox[{-1.1, 1.1}, 0.2]}}}, {{{
              GrayLevel[1], 
              DiskBox[{0, 0}, 1, 
               
               NCache[{Rational[1, 2] Pi, Rational[3, 2] Pi}, {
                1.5707963267948966`, 4.71238898038469}]]}}}, {{{
              GrayLevel[1], 
              DiskBox[{0, 0}, {0.5194101409662437, 1.}]}}}, {{{
              GrayLevel[0.6], 
              CircleBox[{0, 0}]}}}}, AspectRatio -> 1, ImageSize -> 100]], 
        "ExerciseOutput", Selectable -> False, Copyable -> False, Editable -> 
        False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"d299d1e1-9c64-4b4b-89f1-1f30228ad7d7"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Make a list of the numerical phase of the moon for each of the next 10 \
days.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "19.7", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"73bc7c59-e0ac-4d59-983d-cc6e0f63100e"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Sample", " ", "expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       RowBox[{"{", 
        RowBox[{
        "0.6748069317397358269`4.", ",", "0.5837122958235516634`4.", ",", 
         "0.4889508361462783781`4.", ",", "0.3931915847125573293`4.", ",", 
         "0.2994370661806210476`4.", ",", "0.2112052889478011064`4.", ",", 
         "0.1326295333353827433`4.", ",", "0.0683842844373459546`4.", ",", 
         "0.0233463591836003959`4.", ",", "0.0019560343830115623`4."}], 
        "}"}]], "ExerciseOutput",ExpressionUUID->
       "8d0abd18-5117-4d28-8e0b-4314701e952a"],
      Apply[TextCell, 
       Cell[
        BoxData[
         RowBox[{"{", 
           
           RowBox[{"0.6748069317397358269`4.", ",", 
             "0.5837122958235516634`4.", ",", "0.4889508361462783781`4.", ",",
              "0.3931915847125573293`4.", ",", "0.2994370661806210476`4.", 
             ",", "0.2112052889478011064`4.", ",", "0.1326295333353827433`4.",
              ",", "0.0683842844373459546`4.", ",", 
             "0.0233463591836003959`4.", ",", "0.0019560343830115623`4."}], 
           "}"}]], "ExerciseOutput", Selectable -> False, Copyable -> False, 
        Editable -> False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"9977d5ef-815e-4f26-a610-e7b932641b28"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Generate a list of icons for the moon phases from today until 10 days from \
now.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "19.8", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"490630da-ed97-402d-a76f-15c8fb2ce519"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Sample", " ", "expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       RowBox[{"{", 
        RowBox[{
         GraphicsBox[{
           {GrayLevel[0.75], 
            PolygonBox[{{-1.1, -1.3}, {1.1, -1.3}, {1.3, -1.1}, {1.3, 1.1}, {
             1.1, 1.3}, {-1.1, 1.3}, {-1.3, 1.1}, {-1.3, -1.1}}], 
            DiskBox[{-1.1, -1.1}, 0.2], DiskBox[{1.1, -1.1}, 0.2], 
            DiskBox[{1.1, 1.1}, 0.2], DiskBox[{-1.1, 1.1}, 0.2]}, 
           {GrayLevel[1], 
            DiskBox[{0, 0}, 1, 
             NCache[{Rational[1, 2] Pi, Rational[3, 2] Pi}, {
              1.5707963267948966`, 4.71238898038469}]]}, 
           {GrayLevel[1], DiskBox[{0, 0}, {0.3496138634794717, 1.}]}, 
           {GrayLevel[0.6], CircleBox[{0, 0}]}},
          AspectRatio->1,
          ImageSize->100], ",", 
         GraphicsBox[{
           {GrayLevel[0.75], 
            PolygonBox[{{-1.1, -1.3}, {1.1, -1.3}, {1.3, -1.1}, {1.3, 1.1}, {
             1.1, 1.3}, {-1.1, 1.3}, {-1.3, 1.1}, {-1.3, -1.1}}], 
            DiskBox[{-1.1, -1.1}, 0.2], DiskBox[{1.1, -1.1}, 0.2], 
            DiskBox[{1.1, 1.1}, 0.2], DiskBox[{-1.1, 1.1}, 0.2]}, 
           {GrayLevel[1], 
            DiskBox[{0, 0}, 1, 
             NCache[{Rational[1, 2] Pi, Rational[3, 2] Pi}, {
              1.5707963267948966`, 4.71238898038469}]]}, 
           {GrayLevel[1], DiskBox[{0, 0}, {0.16742459164710333, 1.}]}, 
           {GrayLevel[0.6], CircleBox[{0, 0}]}},
          AspectRatio->1,
          ImageSize->100], ",", 
         GraphicsBox[{
           {GrayLevel[0.75], 
            PolygonBox[{{-1.1, -1.3}, {1.1, -1.3}, {1.3, -1.1}, {1.3, 1.1}, {
             1.1, 1.3}, {-1.1, 1.3}, {-1.3, 1.1}, {-1.3, -1.1}}], 
            DiskBox[{-1.1, -1.1}, 0.2], DiskBox[{1.1, -1.1}, 0.2], 
            DiskBox[{1.1, 1.1}, 0.2], DiskBox[{-1.1, 1.1}, 0.2]}, 
           {GrayLevel[1], 
            DiskBox[{0, 0}, 1, 
             NCache[{Rational[1, 2] Pi, Rational[3, 2] Pi}, {
              1.5707963267948966`, 4.71238898038469}]]}, 
           {GrayLevel[0.75], DiskBox[{0, 0}, {0.02209832770744313, 1.}]}, 
           {GrayLevel[0.6], CircleBox[{0, 0}]}},
          AspectRatio->1,
          ImageSize->100], ",", 
         GraphicsBox[{
           {GrayLevel[0.75], 
            PolygonBox[{{-1.1, -1.3}, {1.1, -1.3}, {1.3, -1.1}, {1.3, 1.1}, {
             1.1, 1.3}, {-1.1, 1.3}, {-1.3, 1.1}, {-1.3, -1.1}}], 
            DiskBox[{-1.1, -1.1}, 0.2], DiskBox[{1.1, -1.1}, 0.2], 
            DiskBox[{1.1, 1.1}, 0.2], DiskBox[{-1.1, 1.1}, 0.2]}, 
           {GrayLevel[1], 
            DiskBox[{0, 0}, 1, 
             NCache[{Rational[1, 2] Pi, Rational[3, 2] Pi}, {
              1.5707963267948966`, 4.71238898038469}]]}, 
           {GrayLevel[0.75], DiskBox[{0, 0}, {0.21361683057488523, 1.}]}, 
           {GrayLevel[0.6], CircleBox[{0, 0}]}},
          AspectRatio->1,
          ImageSize->100], ",", 
         GraphicsBox[{
           {GrayLevel[0.75], 
            PolygonBox[{{-1.1, -1.3}, {1.1, -1.3}, {1.3, -1.1}, {1.3, 1.1}, {
             1.1, 1.3}, {-1.1, 1.3}, {-1.3, 1.1}, {-1.3, -1.1}}], 
            DiskBox[{-1.1, -1.1}, 0.2], DiskBox[{1.1, -1.1}, 0.2], 
            DiskBox[{1.1, 1.1}, 0.2], DiskBox[{-1.1, 1.1}, 0.2]}, 
           {GrayLevel[1], 
            DiskBox[{0, 0}, 1, 
             NCache[{Rational[1, 2] Pi, Rational[3, 2] Pi}, {
              1.5707963267948966`, 4.71238898038469}]]}, 
           {GrayLevel[0.75], DiskBox[{0, 0}, {0.40112586763875785, 1.}]}, 
           {GrayLevel[0.6], CircleBox[{0, 0}]}},
          AspectRatio->1,
          ImageSize->100], ",", 
         GraphicsBox[{
           {GrayLevel[0.75], 
            PolygonBox[{{-1.1, -1.3}, {1.1, -1.3}, {1.3, -1.1}, {1.3, 1.1}, {
             1.1, 1.3}, {-1.1, 1.3}, {-1.3, 1.1}, {-1.3, -1.1}}], 
            DiskBox[{-1.1, -1.1}, 0.2], DiskBox[{1.1, -1.1}, 0.2], 
            DiskBox[{1.1, 1.1}, 0.2], DiskBox[{-1.1, 1.1}, 0.2]}, 
           {GrayLevel[1], 
            DiskBox[{0, 0}, 1, 
             NCache[{Rational[1, 2] Pi, Rational[3, 2] Pi}, {
              1.5707963267948966`, 4.71238898038469}]]}, 
           {GrayLevel[0.75], DiskBox[{0, 0}, {0.5775894221043977, 1.}]}, 
           {GrayLevel[0.6], CircleBox[{0, 0}]}},
          AspectRatio->1,
          ImageSize->100], ",", 
         GraphicsBox[{
           {GrayLevel[0.75], 
            PolygonBox[{{-1.1, -1.3}, {1.1, -1.3}, {1.3, -1.1}, {1.3, 1.1}, {
             1.1, 1.3}, {-1.1, 1.3}, {-1.3, 1.1}, {-1.3, -1.1}}], 
            DiskBox[{-1.1, -1.1}, 0.2], DiskBox[{1.1, -1.1}, 0.2], 
            DiskBox[{1.1, 1.1}, 0.2], DiskBox[{-1.1, 1.1}, 0.2]}, 
           {GrayLevel[1], 
            DiskBox[{0, 0}, 1, 
             NCache[{Rational[1, 2] Pi, Rational[3, 2] Pi}, {
              1.5707963267948966`, 4.71238898038469}]]}, 
           {GrayLevel[0.75], DiskBox[{0, 0}, {0.7347409333292344, 1.}]}, 
           {GrayLevel[0.6], CircleBox[{0, 0}]}},
          AspectRatio->1,
          ImageSize->100], ",", 
         GraphicsBox[{
           {GrayLevel[0.75], 
            PolygonBox[{{-1.1, -1.3}, {1.1, -1.3}, {1.3, -1.1}, {1.3, 1.1}, {
             1.1, 1.3}, {-1.1, 1.3}, {-1.3, 1.1}, {-1.3, -1.1}}], 
            DiskBox[{-1.1, -1.1}, 0.2], DiskBox[{1.1, -1.1}, 0.2], 
            DiskBox[{1.1, 1.1}, 0.2], DiskBox[{-1.1, 1.1}, 0.2]}, 
           {GrayLevel[1], 
            DiskBox[{0, 0}, 1, 
             NCache[{Rational[1, 2] Pi, Rational[3, 2] Pi}, {
              1.5707963267948966`, 4.71238898038469}]]}, 
           {GrayLevel[0.75], DiskBox[{0, 0}, {0.8632314311253081, 1.}]}, 
           {GrayLevel[0.6], CircleBox[{0, 0}]}},
          AspectRatio->1,
          ImageSize->100], ",", 
         GraphicsBox[{
           {GrayLevel[0.75], 
            PolygonBox[{{-1.1, -1.3}, {1.1, -1.3}, {1.3, -1.1}, {1.3, 1.1}, {
             1.1, 1.3}, {-1.1, 1.3}, {-1.3, 1.1}, {-1.3, -1.1}}], 
            DiskBox[{-1.1, -1.1}, 0.2], DiskBox[{1.1, -1.1}, 0.2], 
            DiskBox[{1.1, 1.1}, 0.2], DiskBox[{-1.1, 1.1}, 0.2]}, 
           {GrayLevel[1], 
            DiskBox[{0, 0}, 1, 
             NCache[{Rational[1, 2] Pi, Rational[3, 2] Pi}, {
              1.5707963267948966`, 4.71238898038469}]]}, 
           {GrayLevel[0.75], DiskBox[{0, 0}, {0.9533072816327991, 1.}]}, 
           {GrayLevel[0.6], CircleBox[{0, 0}]}},
          AspectRatio->1,
          ImageSize->100], ",", 
         GraphicsBox[{
           {GrayLevel[0.75], 
            PolygonBox[{{-1.1, -1.3}, {1.1, -1.3}, {1.3, -1.1}, {1.3, 1.1}, {
             1.1, 1.3}, {-1.1, 1.3}, {-1.3, 1.1}, {-1.3, -1.1}}], 
            DiskBox[{-1.1, -1.1}, 0.2], DiskBox[{1.1, -1.1}, 0.2], 
            DiskBox[{1.1, 1.1}, 0.2], DiskBox[{-1.1, 1.1}, 0.2]}, 
           {GrayLevel[1], 
            DiskBox[{0, 0}, 1, 
             NCache[{Rational[1, 2] Pi, Rational[3, 2] Pi}, {
              1.5707963267948966`, 4.71238898038469}]]}, 
           {GrayLevel[0.75], DiskBox[{0, 0}, {0.9960879312339769, 1.}]}, 
           {GrayLevel[0.6], CircleBox[{0, 0}]}},
          AspectRatio->1,
          ImageSize->100]}], "}"}]], "ExerciseOutput",ExpressionUUID->
       "42a5063f-f429-45ad-8ea4-3e03235b8858"],
      Apply[TextCell, 
       Cell[
        BoxData[
         RowBox[{"{", 
           RowBox[{
             GraphicsBox[{{{{
                  GrayLevel[0.75], 
                  
                  PolygonBox[{{-1.1, -1.3}, {1.1, -1.3}, {1.3, -1.1}, {1.3, 
                   1.1}, {1.1, 1.3}, {-1.1, 1.3}, {-1.3, 1.1}, {-1.3, -1.1}}], 
                  DiskBox[{-1.1, -1.1}, 0.2], 
                  DiskBox[{1.1, -1.1}, 0.2], 
                  DiskBox[{1.1, 1.1}, 0.2], 
                  DiskBox[{-1.1, 1.1}, 0.2]}}}, {{{
                  GrayLevel[1], 
                  DiskBox[{0, 0}, 1, 
                   
                   NCache[{Rational[1, 2] Pi, Rational[3, 2] Pi}, {
                    1.5707963267948966`, 4.71238898038469}]]}}}, {{{
                  GrayLevel[1], 
                  DiskBox[{0, 0}, {0.3496138634794717, 1.}]}}}, {{{
                  GrayLevel[0.6], 
                  CircleBox[{0, 0}]}}}}, AspectRatio -> 1, ImageSize -> 100], 
             ",", 
             GraphicsBox[{{{{
                  GrayLevel[0.75], 
                  
                  PolygonBox[{{-1.1, -1.3}, {1.1, -1.3}, {1.3, -1.1}, {1.3, 
                   1.1}, {1.1, 1.3}, {-1.1, 1.3}, {-1.3, 1.1}, {-1.3, -1.1}}], 
                  DiskBox[{-1.1, -1.1}, 0.2], 
                  DiskBox[{1.1, -1.1}, 0.2], 
                  DiskBox[{1.1, 1.1}, 0.2], 
                  DiskBox[{-1.1, 1.1}, 0.2]}}}, {{{
                  GrayLevel[1], 
                  DiskBox[{0, 0}, 1, 
                   
                   NCache[{Rational[1, 2] Pi, Rational[3, 2] Pi}, {
                    1.5707963267948966`, 4.71238898038469}]]}}}, {{{
                  GrayLevel[1], 
                  DiskBox[{0, 0}, {0.16742459164710333`, 1.}]}}}, {{{
                  GrayLevel[0.6], 
                  CircleBox[{0, 0}]}}}}, AspectRatio -> 1, ImageSize -> 100], 
             ",", 
             GraphicsBox[{{{{
                  GrayLevel[0.75], 
                  
                  PolygonBox[{{-1.1, -1.3}, {1.1, -1.3}, {1.3, -1.1}, {1.3, 
                   1.1}, {1.1, 1.3}, {-1.1, 1.3}, {-1.3, 1.1}, {-1.3, -1.1}}], 
                  DiskBox[{-1.1, -1.1}, 0.2], 
                  DiskBox[{1.1, -1.1}, 0.2], 
                  DiskBox[{1.1, 1.1}, 0.2], 
                  DiskBox[{-1.1, 1.1}, 0.2]}}}, {{{
                  GrayLevel[1], 
                  DiskBox[{0, 0}, 1, 
                   
                   NCache[{Rational[1, 2] Pi, Rational[3, 2] Pi}, {
                    1.5707963267948966`, 4.71238898038469}]]}}}, {{{
                  GrayLevel[0.75], 
                  DiskBox[{0, 0}, {0.02209832770744313, 1.}]}}}, {{{
                  GrayLevel[0.6], 
                  CircleBox[{0, 0}]}}}}, AspectRatio -> 1, ImageSize -> 100], 
             ",", 
             GraphicsBox[{{{{
                  GrayLevel[0.75], 
                  
                  PolygonBox[{{-1.1, -1.3}, {1.1, -1.3}, {1.3, -1.1}, {1.3, 
                   1.1}, {1.1, 1.3}, {-1.1, 1.3}, {-1.3, 1.1}, {-1.3, -1.1}}], 
                  DiskBox[{-1.1, -1.1}, 0.2], 
                  DiskBox[{1.1, -1.1}, 0.2], 
                  DiskBox[{1.1, 1.1}, 0.2], 
                  DiskBox[{-1.1, 1.1}, 0.2]}}}, {{{
                  GrayLevel[1], 
                  DiskBox[{0, 0}, 1, 
                   NCache[{Rational[1, 2] Pi, Rational[3, 2] Pi}, {
                    1.5707963267948966`, 4.71238898038469}]]}}}, {{{
                  GrayLevel[0.75], 
                  DiskBox[{0, 0}, {0.21361683057488523`, 1.}]}}}, {{{
                  GrayLevel[0.6], 
                  CircleBox[{0, 0}]}}}}, AspectRatio -> 1, ImageSize -> 100], 
             ",", 
             GraphicsBox[{{{{
                  GrayLevel[0.75], 
                  
                  PolygonBox[{{-1.1, -1.3}, {1.1, -1.3}, {1.3, -1.1}, {1.3, 
                   1.1}, {1.1, 1.3}, {-1.1, 1.3}, {-1.3, 1.1}, {-1.3, -1.1}}], 
                  DiskBox[{-1.1, -1.1}, 0.2], 
                  DiskBox[{1.1, -1.1}, 0.2], 
                  DiskBox[{1.1, 1.1}, 0.2], 
                  DiskBox[{-1.1, 1.1}, 0.2]}}}, {{{
                  GrayLevel[1], 
                  DiskBox[{0, 0}, 1, 
                   
                   NCache[{Rational[1, 2] Pi, Rational[3, 2] Pi}, {
                    1.5707963267948966`, 4.71238898038469}]]}}}, {{{
                  GrayLevel[0.75], 
                  DiskBox[{0, 0}, {0.40112586763875785`, 1.}]}}}, {{{
                  GrayLevel[0.6], 
                  CircleBox[{0, 0}]}}}}, AspectRatio -> 1, ImageSize -> 100], 
             ",", 
             GraphicsBox[{{{{
                  GrayLevel[0.75], 
                  
                  PolygonBox[{{-1.1, -1.3}, {1.1, -1.3}, {1.3, -1.1}, {1.3, 
                   1.1}, {1.1, 1.3}, {-1.1, 1.3}, {-1.3, 1.1}, {-1.3, -1.1}}], 
                  DiskBox[{-1.1, -1.1}, 0.2], 
                  DiskBox[{1.1, -1.1}, 0.2], 
                  DiskBox[{1.1, 1.1}, 0.2], 
                  DiskBox[{-1.1, 1.1}, 0.2]}}}, {{{
                  GrayLevel[1], 
                  DiskBox[{0, 0}, 1, 
                   
                   NCache[{Rational[1, 2] Pi, Rational[3, 2] Pi}, {
                    1.5707963267948966`, 4.71238898038469}]]}}}, {{{
                  GrayLevel[0.75], 
                  DiskBox[{0, 0}, {0.5775894221043977, 1.}]}}}, {{{
                  GrayLevel[0.6], 
                  CircleBox[{0, 0}]}}}}, AspectRatio -> 1, ImageSize -> 100], 
             ",", 
             GraphicsBox[{{{{
                  GrayLevel[0.75], 
                  
                  PolygonBox[{{-1.1, -1.3}, {1.1, -1.3}, {1.3, -1.1}, {1.3, 
                   1.1}, {1.1, 1.3}, {-1.1, 1.3}, {-1.3, 1.1}, {-1.3, -1.1}}], 
                  DiskBox[{-1.1, -1.1}, 0.2], 
                  DiskBox[{1.1, -1.1}, 0.2], 
                  DiskBox[{1.1, 1.1}, 0.2], 
                  DiskBox[{-1.1, 1.1}, 0.2]}}}, {{{
                  GrayLevel[1], 
                  DiskBox[{0, 0}, 1, 
                   
                   NCache[{Rational[1, 2] Pi, Rational[3, 2] Pi}, {
                    1.5707963267948966`, 4.71238898038469}]]}}}, {{{
                  GrayLevel[0.75], 
                  DiskBox[{0, 0}, {0.7347409333292344, 1.}]}}}, {{{
                  GrayLevel[0.6], 
                  CircleBox[{0, 0}]}}}}, AspectRatio -> 1, ImageSize -> 100], 
             ",", 
             GraphicsBox[{{{{
                  GrayLevel[0.75], 
                  
                  PolygonBox[{{-1.1, -1.3}, {1.1, -1.3}, {1.3, -1.1}, {1.3, 
                   1.1}, {1.1, 1.3}, {-1.1, 1.3}, {-1.3, 1.1}, {-1.3, -1.1}}], 
                  DiskBox[{-1.1, -1.1}, 0.2], 
                  DiskBox[{1.1, -1.1}, 0.2], 
                  DiskBox[{1.1, 1.1}, 0.2], 
                  DiskBox[{-1.1, 1.1}, 0.2]}}}, {{{
                  GrayLevel[1], 
                  DiskBox[{0, 0}, 1, 
                   
                   NCache[{Rational[1, 2] Pi, Rational[3, 2] Pi}, {
                    1.5707963267948966`, 4.71238898038469}]]}}}, {{{
                  GrayLevel[0.75], 
                  DiskBox[{0, 0}, {0.8632314311253081, 1.}]}}}, {{{
                  GrayLevel[0.6], 
                  CircleBox[{0, 0}]}}}}, AspectRatio -> 1, ImageSize -> 100], 
             ",", 
             GraphicsBox[{{{{
                  GrayLevel[0.75], 
                  
                  PolygonBox[{{-1.1, -1.3}, {1.1, -1.3}, {1.3, -1.1}, {1.3, 
                   1.1}, {1.1, 1.3}, {-1.1, 1.3}, {-1.3, 1.1}, {-1.3, -1.1}}], 
                  DiskBox[{-1.1, -1.1}, 0.2], 
                  DiskBox[{1.1, -1.1}, 0.2], 
                  DiskBox[{1.1, 1.1}, 0.2], 
                  DiskBox[{-1.1, 1.1}, 0.2]}}}, {{{
                  GrayLevel[1], 
                  DiskBox[{0, 0}, 1, 
                   
                   NCache[{Rational[1, 2] Pi, Rational[3, 2] Pi}, {
                    1.5707963267948966`, 4.71238898038469}]]}}}, {{{
                  GrayLevel[0.75], 
                  DiskBox[{0, 0}, {0.9533072816327991, 1.}]}}}, {{{
                  GrayLevel[0.6], 
                  CircleBox[{0, 0}]}}}}, AspectRatio -> 1, ImageSize -> 100], 
             ",", 
             GraphicsBox[{{{{
                  GrayLevel[0.75], 
                  
                  PolygonBox[{{-1.1, -1.3}, {1.1, -1.3}, {1.3, -1.1}, {1.3, 
                   1.1}, {1.1, 1.3}, {-1.1, 1.3}, {-1.3, 1.1}, {-1.3, -1.1}}], 
                  DiskBox[{-1.1, -1.1}, 0.2], 
                  DiskBox[{1.1, -1.1}, 0.2], 
                  DiskBox[{1.1, 1.1}, 0.2], 
                  DiskBox[{-1.1, 1.1}, 0.2]}}}, {{{
                  GrayLevel[1], 
                  DiskBox[{0, 0}, 1, 
                   
                   NCache[{Rational[1, 2] Pi, Rational[3, 2] Pi}, {
                    1.5707963267948966`, 4.71238898038469}]]}}}, {{{
                  GrayLevel[0.75], 
                  DiskBox[{0, 0}, {0.9960879312339769, 1.}]}}}, {{{
                  GrayLevel[0.6], 
                  CircleBox[{0, 0}]}}}}, AspectRatio -> 1, ImageSize -> 
              100]}], "}"}]], "ExerciseOutput", Selectable -> False, Copyable -> 
        False, Editable -> False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"aaf8ca6b-ecb9-45aa-8341-e674f4398ef7"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Compute the time today between sunrise in New York City and in London.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "19.9", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"a297b226-1cf3-46d7-bf47-5db8aa2a9291"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Sample", " ", "expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       TemplateBox[{"294", "\"min\"", "minutes", "\"Minutes\""},
        "Quantity"]], "ExerciseOutput",ExpressionUUID->
       "9bf80035-3839-408a-8dd9-ee6e3d244eda"],
      Apply[TextCell, 
       Cell[
        BoxData[
         TemplateBox[{"294", "\"min\"", "minutes", "\"Minutes\""}, 
          "Quantity"]], "ExerciseOutput", Selectable -> False, Copyable -> 
        False, Editable -> False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"2ec20eae-67f5-496d-8993-2879aa93e574"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Find the air temperature at the Eiffel Tower at noon yesterday.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "19.10", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"de4b5f59-9ba3-4e7d-9934-ceb3b4aaf6e0"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Sample", " ", "expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       TemplateBox[{
        "64.94`", "\"\[Degree]F\"", "degrees Fahrenheit", 
         "\"DegreesFahrenheit\""},
        "Quantity"]], "ExerciseOutput",ExpressionUUID->
       "da0904a4-2ef2-492b-ae49-fbe7dac7811b"],
      Apply[TextCell, 
       Cell[
        BoxData[
         TemplateBox[{
          "64.94`", "\"\[Degree]F\"", "degrees Fahrenheit", 
           "\"DegreesFahrenheit\""}, "Quantity"]], "ExerciseOutput", 
        Selectable -> False, Copyable -> False, Editable -> False, 
        ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"434941f6-a1c0-4289-bb52-4fe84469c30a"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Plot the temperature at the Eiffel Tower over the past week.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "19.11", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"bd2520db-7e26-459f-96c0-2dfdfba87ddd"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Sample", " ", "expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       GraphicsBox[{{}, {{}, {}, 
          {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
           0.007333333333333334], AbsoluteThickness[1.6], 
           LineBox[CompressedData["
1:eJxdmHdczl8Ux7Op7GwiGZER2YpEopJKZhllRUaZyYiIhFt2EUqoRCXS0hAN
iWSVlU1EIpGRfvee33N7+Xj+6fV+fZ7vfc4953POvd807Jdaza2upKRkXk1J
Sfzln6TgXUUjWtp6p5ZpmRpwPhbCOTNbfEwEbwzlXKjFvxBNbHcadcMwzgbK
eUFOFWMFa57hPGse/7whrnmWc36Qk75yC+LXgn38+KfVGMHp4WJ9y1h1jyJj
wcERnHV0xYfYMxJ5wTlkkyjOFuLx3aMFa5+X8ZkRq17gHFsmNmAk+OMFGd88
4pvRyBEXOZdX8o/bKME+McjOschWcZw3FvENpBHrxqOuliB/332k4LIEuX8/
4vuXONcNN37uak0ckyj3d95QsG8S8ppk5GkpYv+ifP7EQy+j3jaVcwhfXm0J
cUUq6gVXZPwexMlXMf6ANBnfPsrPpnTMv30G8shMrG+na6L+rmrhxoFU/1pZ
6J83WVXxkf8yrnPWoviIQ7I5DxL+0jcTvP0GZ1/KH/HCm9JfB8cJNs2pip+4
xy25Xilx/VzODlRvc8HFuVX+IM65XeWf8YIj74jf5+GF1yHefRefX3ZP6hkU
z4T7GH+/PLE/Hl7eS9pvs3zc/7d8+fuGxHkPZPyVlL/Yh/L7O4n9HqHu+hh1
myeYf70CsT5vD0sXqk+7p1ivP4JFeEElVN+nz7B/Up7L9R6QHvgC+8X9JfLs
V8i138r9HSc/vX0rf7+UOLNQ+vcxceg7fN7rvfCfKL8ysWMR+tPsg+x/S+Ke
H1FvUFzlD+JPxbj+rU9yfRPKx7kSzN+ez3L9XOLlX3C+WZdi/fp/xfo3L6vq
b/LH9zL0b/432R8a5Ke47+i/Q+WcXdTEAsRrf3DeR/FZCLb9KfeXR7r+L3xe
/TfnMTQfiSt/o/6sQsx/DzEAiC//QX8fr+Q8hepD/bNZiUH8c6ox6E+j6gz2
36UGU9RjOHGdmgz8XyjYRfjPifhaLQb5PV2bKerjRbyjDgP/L6rL2UnkJ554
XD0G9eulzOB8aajCwP8lKgzqn6uKelR95L0NGPTHiobIExshD2jM4Pxp0YSB
/8oF/+X/B00Z+DdejSnO1/X0/cPN8Pl1zTkHiPJr0vent8Dnh7XE9du3wviU
WuP+n7fG/KW2YXB+B7XF+mxpJ/0wleo3Vx3rP7o9g/netQPqdTXQP+800F9Z
HZnCnwXEYZqo7+zEFP62JH8u7sxg/pt3wed7d8XnG2nJ+rgTf9ZC/XY3puiH
LsTnu2P8+7RlfiYTr+yB/p7UE3lgL+SWvWV8R4l/9Mb8PtRhMF8S+qDu31f6
cznxel3sjxn9mOL+tpJ4eH+sb4cBDM6HagPR7y8Gyv5yJb9cGYT+OTFYxq9O
7DEE/TlvKJPzjdhYD3Utfc4dxP3TgfxZbxiD+9H7YQzuT9eHo37GQPaHPvGu
EagvMayqP/H4kfj7OqMw/sZGuP8vRrK/gihfd0Zj/i8YM8V8V6P67B+D9V01
Fv0y2QR5kKnMfzlxKzP030/Bf83fR+PQ35fMGdxvjoxHfYMF9sdMS1zfwAr7
T2MCxlfdmsH9/6U17u/qRNz/yUmYn62TcT7Mn4L6mKkM3h+6TUNd2YbB/bHI
BvVsW/T/2enofzaDKe63RqQvnYm6xSycb33sUG9iL/1ZSFxqj/rd2QzuB9Fz
UD8wF/2zeh7qU+YzuL8NdkC99QI8334tQP3xQtQTHVE/ugh1t8Woz1qC+xux
FPWOTpi/Gs6Y/1fO8nzVpvqmLUN/nFqO83PbCvSXw0r5vCPpY1ehP7uvluup
kn9VXNDfH1zQ3zfWoB7uiuy9lsH9xmkdg/cHy/X4/b4bmOL+rknc1A3j++qG
+7m3EfniJhlfY+KD7pg/l83yfLYlnroF8z/EQ86nGcRttuL8/r1V9k8izasn
23B+JXnK9ZJpvh3bjvN7o5esfwix3Q7UDXcyuL9o7sL5WZMxuJ+/Zqine8v5
Nog42IfB/cRzN1PcD8KJF+xB3WQvg/dr7X2oq+5H/vgP3zyAvx9xEPfn4yvn
ix3ly9kP8291iMH9U/cw1lfNn8H7X5k/+uv+Eaa435YQxxxlcH/3PcaZ/v2i
R7wmgDO1z07iaYGc/Wl+EA89zvk3xUfcNojzB9E/KpaCK4JQLzjB+S7NN9KT
T6IecIqzqpjfX4k3BaNuH8LZmuYb8chQjK/TaQbvF7XCcP9vwrC/Ms5g/4Sc
xfNnezjmd2EEg/9PmUZi//Q4J/wh2ieHuH4U1q84Cudbznnsn8gLTPH+q0O8
Oxr1ZRexPyfE4Pr9YkX/ifobEzeLw+e/xWE/5sUjxybI9dsS+11C3TVR7s+b
2CYJ19dLlufv3f/f71NQ//MPP72MnJKK8yXwCu7P/Srmb3Ya6qPS8XzunIH1
qZ3J4H77NhPPh8xrOB9Ds1D3us7Zk/4/RbpjNvrD7AaeLz1v/uWv/wDsXKUf

            "]]}}, {}, {}, {{}, {}}, {{}, {}}},
        AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
        Axes->{False, False},
        AxesLabel->{None, None},
        AxesOrigin->{3.6981468*^9, 35.284999999999954`},
        DisplayFunction->Identity,
        Frame->{{True, True}, {True, True}},
        FrameLabel->{{None, None}, {None, None}},
        FrameTicks->
         FrontEndValueCache[{{Automatic, Automatic}, {Charting`FindScaledTicks[
             (Charting`getDateTicks[Automatic, {Automatic}, 
              (Map[DateList, {
                SlotSequence[1]}]& )[
               SlotSequence[1]], None, 5, {{0.0125, 0}, {0.0075, 0}}, 
              Automatic]& )[
              SlotSequence[1]], {Identity, Identity}]& , 
            Charting`ScaledFrameTicks[
             (Charting`getDateTicks[
             Charting`getDateTicks[Automatic, {Automatic}, 
               (Map[DateList, {
                 SlotSequence[1]}]& )[
                SlotSequence[1]], None, 5, {{0.0125, 0}, {0.0075, 0}}, 
               Automatic]& , {Automatic}, 
              (Map[DateList, {
                SlotSequence[1]}]& )[
               SlotSequence[1]], None, 5, {{0.0125, 0}, {0.0075, 0}}, None]& )[
              SlotSequence[1]], {Identity, Identity}]& }}, {{
           Automatic, Automatic}, {{{3.6980928*^9, 
              FormBox["\"Mar 10\"", TraditionalForm], {0.008333333333333333, 
              0.}}, {3.6982656*^9, 
              FormBox["\"Mar 12\"", TraditionalForm], {0.008333333333333333, 
              0.}}, {3.6984384*^9, 
              FormBox["\"Mar 14\"", TraditionalForm], {0.008333333333333333, 
              0.}}, {3.6986112*^9, 
              FormBox["\"Mar 16\"", TraditionalForm], {0.008333333333333333, 
              0.}}, {3.698784*^9, 
              FormBox["\"Mar 18\"", TraditionalForm], {0.008333333333333333, 
              0.}}, {3.6980928*^9, 
              FormBox[
               InterpretationBox[
                StyleBox[
                 
                 GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                  Baseline], "CacheGraphics" -> False], 
                Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
              0.008333333333333333, 0.}}, {3.6981792*^9, 
              FormBox[
               InterpretationBox[
                StyleBox[
                 
                 GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                  Baseline], "CacheGraphics" -> False], 
                Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
              0.008333333333333333, 0.}}, {3.6982656*^9, 
              FormBox[
               InterpretationBox[
                StyleBox[
                 
                 GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                  Baseline], "CacheGraphics" -> False], 
                Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
              0.008333333333333333, 0.}}, {3.698352*^9, 
              FormBox[
               InterpretationBox[
                StyleBox[
                 
                 GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                  Baseline], "CacheGraphics" -> False], 
                Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
              0.008333333333333333, 0.}}, {3.6984384*^9, 
              FormBox[
               InterpretationBox[
                StyleBox[
                 
                 GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                  Baseline], "CacheGraphics" -> False], 
                Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
              0.008333333333333333, 0.}}, {3.6985248*^9, 
              FormBox[
               InterpretationBox[
                StyleBox[
                 
                 GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                  Baseline], "CacheGraphics" -> False], 
                Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
              0.008333333333333333, 0.}}, {3.6986112*^9, 
              FormBox[
               InterpretationBox[
                StyleBox[
                 
                 GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                  Baseline], "CacheGraphics" -> False], 
                Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
              0.008333333333333333, 0.}}, {3.6986976*^9, 
              FormBox[
               InterpretationBox[
                StyleBox[
                 
                 GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                  Baseline], "CacheGraphics" -> False], 
                Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
              0.008333333333333333, 0.}}}, {{3.6980928*^9, 
              FormBox[
               InterpretationBox[
                StyleBox[
                 
                 GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                  Baseline], "CacheGraphics" -> False], 
                Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
              0.008333333333333333, 0.}}, {3.6982656*^9, 
              FormBox[
               InterpretationBox[
                StyleBox[
                 
                 GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                  Baseline], "CacheGraphics" -> False], 
                Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
              0.008333333333333333, 0.}}, {3.6984384*^9, 
              FormBox[
               InterpretationBox[
                StyleBox[
                 
                 GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                  Baseline], "CacheGraphics" -> False], 
                Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
              0.008333333333333333, 0.}}, {3.6986112*^9, 
              FormBox[
               InterpretationBox[
                StyleBox[
                 
                 GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                  Baseline], "CacheGraphics" -> False], 
                Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
              0.008333333333333333, 0.}}, {3.698784*^9, 
              FormBox[
               InterpretationBox[
                StyleBox[
                 
                 GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                  Baseline], "CacheGraphics" -> False], 
                Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
              0.008333333333333333, 0.}}, {3.6980928*^9, 
              FormBox[
               InterpretationBox[
                StyleBox[
                 
                 GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                  Baseline], "CacheGraphics" -> False], 
                Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
              0.008333333333333333, 0.}}, {3.6981792*^9, 
              FormBox[
               InterpretationBox[
                StyleBox[
                 
                 GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                  Baseline], "CacheGraphics" -> False], 
                Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
              0.008333333333333333, 0.}}, {3.6982656*^9, 
              FormBox[
               InterpretationBox[
                StyleBox[
                 
                 GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                  Baseline], "CacheGraphics" -> False], 
                Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
              0.008333333333333333, 0.}}, {3.698352*^9, 
              FormBox[
               InterpretationBox[
                StyleBox[
                 
                 GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                  Baseline], "CacheGraphics" -> False], 
                Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
              0.008333333333333333, 0.}}, {3.6984384*^9, 
              FormBox[
               InterpretationBox[
                StyleBox[
                 
                 GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                  Baseline], "CacheGraphics" -> False], 
                Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
              0.008333333333333333, 0.}}, {3.6985248*^9, 
              FormBox[
               InterpretationBox[
                StyleBox[
                 
                 GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                  Baseline], "CacheGraphics" -> False], 
                Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
              0.008333333333333333, 0.}}, {3.6986112*^9, 
              FormBox[
               InterpretationBox[
                StyleBox[
                 
                 GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                  Baseline], "CacheGraphics" -> False], 
                Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
              0.008333333333333333, 0.}}, {3.6986976*^9, 
              FormBox[
               InterpretationBox[
                StyleBox[
                 
                 GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                  Baseline], "CacheGraphics" -> False], 
                Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
              0.008333333333333333, 0.}}}}}],
        GridLines->{None, None},
        GridLinesStyle->Directive[
          GrayLevel[0.5, 0.4]],
        ImagePadding->All,
        Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
              (Identity[#]& )[
               Part[#, 1]], 
              (Identity[#]& )[
               Part[#, 2]]}& ), "CopiedValueFunction" -> ({
              (Identity[#]& )[
               Part[#, 1]], 
              (Identity[#]& )[
               Part[#, 2]]}& )}},
        PlotRange->{{3.6981468*^9, 3.6987498*^9}, {36.85999999999996, 
         68.35999999999996}},
        PlotRangeClipping->True,
        PlotRangePadding->{{
           Scaled[0.02], 
           Scaled[0.02]}, {
           Scaled[0.05], 
           Scaled[0.05]}},
        Ticks->{{}, Automatic}]], "ExerciseOutput",ExpressionUUID->
       "3aeab099-5314-4e60-8dd7-1716c199d42c"],
      Apply[TextCell, 
       Cell[
        BoxData[
         GraphicsBox[{{}, {{{}, {}, {{{{
                 RGBColor[0.368417, 0.506779, 0.709798], 
                 PointSize[0.007333333333333334], 
                 AbsoluteThickness[1.6], 
                 LineBox[CompressedData["
1:eJxdmHdczl8Ux7Op7GwiGZER2YpEopJKZhllRUaZyYiIhFt2EUqoRCXS0hAN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                  "]]}}}}}}, {}, {}, {{}, {}}, {{}, {}}}, AspectRatio -> 
          NCache[GoldenRatio^(-1), 0.6180339887498948], 
          Axes -> {False, False}, AxesLabel -> {None, None}, 
          AxesOrigin -> {3.6981468*^9, 35.284999999999954`}, DisplayFunction -> 
          Identity, Frame -> {{True, True}, {True, True}}, 
          FrameLabel -> {{None, None}, {None, None}}, FrameTicks -> 
          FrontEndValueCache[{{Automatic, Automatic}, {
             Charting`FindScaledTicks[
               (Charting`getDateTicks[Automatic, {Automatic}, 
                (Map[DateList, {
                  SlotSequence[1]}]& )[
                 SlotSequence[1]], None, 5, {{0.0125, 0}, {0.0075, 0}}, 
                Automatic]& )[
                SlotSequence[1]], {Identity, Identity}]& , 
              Charting`ScaledFrameTicks[
               (Charting`getDateTicks[
               Charting`getDateTicks[Automatic, {Automatic}, 
                 (Map[DateList, {
                   SlotSequence[1]}]& )[
                  SlotSequence[1]], None, 5, {{0.0125, 0}, {0.0075, 0}}, 
                 Automatic]& , {Automatic}, 
                (Map[DateList, {
                  SlotSequence[1]}]& )[
                 SlotSequence[1]], None, 5, {{0.0125, 0}, {0.0075, 0}}, 
                None]& )[
                SlotSequence[1]], {Identity, Identity}]& }}, {{
             Automatic, Automatic}, {{{3.6980928*^9, 
                FormBox["\"Mar 10\"", TraditionalForm], {0.008333333333333333,
                 0.}}, {3.6982656*^9, 
                FormBox["\"Mar 12\"", TraditionalForm], {0.008333333333333333,
                 0.}}, {3.6984384*^9, 
                FormBox["\"Mar 14\"", TraditionalForm], {0.008333333333333333,
                 0.}}, {3.6986112*^9, 
                FormBox["\"Mar 16\"", TraditionalForm], {0.008333333333333333,
                 0.}}, {3.698784*^9, 
                FormBox["\"Mar 18\"", TraditionalForm], {0.008333333333333333,
                 0.}}, {3.6980928*^9, 
                FormBox[
                 InterpretationBox[
                  StyleBox[
                   
                   GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                  Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
                0.008333333333333333, 0.}}, {3.6981792*^9, 
                FormBox[
                 InterpretationBox[
                  StyleBox[
                   
                   GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                  Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
                0.008333333333333333, 0.}}, {3.6982656*^9, 
                FormBox[
                 InterpretationBox[
                  StyleBox[
                   
                   GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                  Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
                0.008333333333333333, 0.}}, {3.698352*^9, 
                FormBox[
                 InterpretationBox[
                  StyleBox[
                   
                   GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                  Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
                0.008333333333333333, 0.}}, {3.6984384*^9, 
                FormBox[
                 InterpretationBox[
                  StyleBox[
                   
                   GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                  Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
                0.008333333333333333, 0.}}, {3.6985248*^9, 
                FormBox[
                 InterpretationBox[
                  StyleBox[
                   
                   GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                  Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
                0.008333333333333333, 0.}}, {3.6986112*^9, 
                FormBox[
                 InterpretationBox[
                  StyleBox[
                   
                   GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                  Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
                0.008333333333333333, 0.}}, {3.6986976*^9, 
                FormBox[
                 InterpretationBox[
                  StyleBox[
                   
                   GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                  Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
                0.008333333333333333, 0.}}}, {{3.6980928*^9, 
                FormBox[
                 InterpretationBox[
                  StyleBox[
                   
                   GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                  Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
                0.008333333333333333, 0.}}, {3.6982656*^9, 
                FormBox[
                 InterpretationBox[
                  StyleBox[
                   
                   GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                  Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
                0.008333333333333333, 0.}}, {3.6984384*^9, 
                FormBox[
                 InterpretationBox[
                  StyleBox[
                   
                   GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                  Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
                0.008333333333333333, 0.}}, {3.6986112*^9, 
                FormBox[
                 InterpretationBox[
                  StyleBox[
                   
                   GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                  Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
                0.008333333333333333, 0.}}, {3.698784*^9, 
                FormBox[
                 InterpretationBox[
                  StyleBox[
                   
                   GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                  Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
                0.008333333333333333, 0.}}, {3.6980928*^9, 
                FormBox[
                 InterpretationBox[
                  StyleBox[
                   
                   GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                  Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
                0.008333333333333333, 0.}}, {3.6981792*^9, 
                FormBox[
                 InterpretationBox[
                  StyleBox[
                   
                   GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                  Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
                0.008333333333333333, 0.}}, {3.6982656*^9, 
                FormBox[
                 InterpretationBox[
                  StyleBox[
                   
                   GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                  Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
                0.008333333333333333, 0.}}, {3.698352*^9, 
                FormBox[
                 InterpretationBox[
                  StyleBox[
                   
                   GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                  Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
                0.008333333333333333, 0.}}, {3.6984384*^9, 
                FormBox[
                 InterpretationBox[
                  StyleBox[
                   
                   GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                  Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
                0.008333333333333333, 0.}}, {3.6985248*^9, 
                FormBox[
                 InterpretationBox[
                  StyleBox[
                   
                   GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                  Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
                0.008333333333333333, 0.}}, {3.6986112*^9, 
                FormBox[
                 InterpretationBox[
                  StyleBox[
                   
                   GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                  Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
                0.008333333333333333, 0.}}, {3.6986976*^9, 
                FormBox[
                 InterpretationBox[
                  StyleBox[
                   
                   GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                  Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
                0.008333333333333333, 0.}}}}}], GridLines -> {None, None}, 
          GridLinesStyle -> Directive[
            GrayLevel[0.5, 0.4]], ImagePadding -> All, 
          Method -> {"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
                (Identity[#]& )[
                 Part[#, 1]], 
                (Identity[#]& )[
                 Part[#, 2]]}& ), "CopiedValueFunction" -> ({
                (Identity[#]& )[
                 Part[#, 1]], 
                (Identity[#]& )[
                 Part[#, 2]]}& )}}, 
          PlotRange -> {{3.6981468*^9, 3.6987498*^9}, {36.85999999999996, 
           68.35999999999996}}, PlotRangeClipping -> True, 
          PlotRangePadding -> {{
             Scaled[0.02], 
             Scaled[0.02]}, {
             Scaled[0.05], 
             Scaled[0.05]}}, Ticks -> {{}, Automatic}]], "ExerciseOutput", 
        Selectable -> False, Copyable -> False, Editable -> False, 
        ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"00401236-2bfc-4377-93d0-d490802bd0e6"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Find the difference in air temperatures between Los Angeles and New York \
City now.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "19.12", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"62da9067-1b33-4926-981e-ec8f09134367"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Sample", " ", "expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       TemplateBox[{
        "19.07999999999987`", "\"\[Degree]F\"", "degrees Fahrenheit", 
         "\"DegreesFahrenheit\""},
        "Quantity"]], "ExerciseOutput",ExpressionUUID->
       "be65de9d-3225-43b1-957a-7dc339cf8435"],
      Apply[TextCell, 
       Cell[
        BoxData[
         TemplateBox[{
          "19.07999999999987`", "\"\[Degree]F\"", "degrees Fahrenheit", 
           "\"DegreesFahrenheit\""}, "Quantity"]], "ExerciseOutput", 
        Selectable -> False, Copyable -> False, Editable -> False, 
        ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"d617aeb2-05a6-40ea-96e5-f259eb1ba142"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Plot the historical frequency of the word \[OpenCurlyDoubleQuote]groovy\
\[CloseCurlyDoubleQuote].",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "19.13", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"1f52c0f8-0009-46f1-b655-68ace7108854"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       GraphicsBox[{{}, {{}, {}, 
          {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
           0.009166666666666668], AbsoluteThickness[1.6], 
           LineBox[CompressedData["
1:eJw1lAk0lAsUx2mhhfYaxDORmCdMhUa9vLmE0jZZel6ppvfGKyrNsxVpGpXS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            
            "]]}}, {}, {}, {{}, {}}, {{}, {}}},
        AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
        Axes->{False, False},
        AxesLabel->{None, None},
        AxesOrigin->{-2.1774528*^9, 0},
        DisplayFunction->Identity,
        Frame->{{True, True}, {True, True}},
        FrameLabel->{{None, None}, {None, None}},
        FrameTicks->
         FrontEndValueCache[{{Automatic, Automatic}, {Charting`FindScaledTicks[
             (Charting`getDateTicks[Automatic, {Automatic}, 
              (Map[DateList, {
                SlotSequence[1]}]& )[
               SlotSequence[1]], None, 5, {{0.0125, 0}, {0.0075, 0}}, 
              Automatic]& )[
              SlotSequence[1]], {Identity, Identity}]& , 
            Charting`ScaledFrameTicks[
             (Charting`getDateTicks[
             Charting`getDateTicks[Automatic, {Automatic}, 
               (Map[DateList, {
                 SlotSequence[1]}]& )[
                SlotSequence[1]], None, 5, {{0.0125, 0}, {0.0075, 0}}, 
               Automatic]& , {Automatic}, 
              (Map[DateList, {
                SlotSequence[1]}]& )[
               SlotSequence[1]], None, 5, {{0.0125, 0}, {0.0075, 0}}, None]& )[
              SlotSequence[1]], {Identity, Identity}]& }}, {{
           Automatic, Automatic}, {{{-3.1556736*^9, 
              FormBox["\"1800\"", TraditionalForm], {0.008333333333333333, 
              0.}}, {-1.5778368*^9, 
              FormBox["\"1850\"", TraditionalForm], {0.008333333333333333, 
              0.}}, {0., 
              FormBox["\"1900\"", TraditionalForm], {0.008333333333333333, 
              0.}}, {1.5778368*^9, 
              FormBox["\"1950\"", TraditionalForm], {0.008333333333333333, 
              0.}}, {3.1556736*^9, 
              FormBox["\"2000\"", TraditionalForm], {0.008333333333333333, 
              0.}}, {4.7335968*^9, 
              FormBox["\"2050\"", TraditionalForm], {0.008333333333333333, 
              0.}}, {-3.1556736*^9, 
              FormBox[
               InterpretationBox[
                StyleBox[
                 
                 GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                  Baseline], "CacheGraphics" -> False], 
                Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
              0.008333333333333333, 0.}}, {-2.8401408*^9, 
              FormBox[
               InterpretationBox[
                StyleBox[
                 
                 GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                  Baseline], "CacheGraphics" -> False], 
                Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
              0.008333333333333333, 0.}}, {-2.524608*^9, 
              FormBox[
               InterpretationBox[
                StyleBox[
                 
                 GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                  Baseline], "CacheGraphics" -> False], 
                Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
              0.008333333333333333, 0.}}, {-2.2089888*^9, 
              FormBox[
               InterpretationBox[
                StyleBox[
                 
                 GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                  Baseline], "CacheGraphics" -> False], 
                Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
              0.008333333333333333, 0.}}, {-1.893456*^9, 
              FormBox[
               InterpretationBox[
                StyleBox[
                 
                 GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                  Baseline], "CacheGraphics" -> False], 
                Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
              0.008333333333333333, 0.}}, {-1.5778368*^9, 
              FormBox[
               InterpretationBox[
                StyleBox[
                 
                 GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                  Baseline], "CacheGraphics" -> False], 
                Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
              0.008333333333333333, 0.}}, {-1.262304*^9, 
              FormBox[
               InterpretationBox[
                StyleBox[
                 
                 GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                  Baseline], "CacheGraphics" -> False], 
                Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
              0.008333333333333333, 0.}}, {-9.466848*^8, 
              FormBox[
               InterpretationBox[
                StyleBox[
                 
                 GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                  Baseline], "CacheGraphics" -> False], 
                Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
              0.008333333333333333, 0.}}, {-6.31152*^8, 
              FormBox[
               InterpretationBox[
                StyleBox[
                 
                 GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                  Baseline], "CacheGraphics" -> False], 
                Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
              0.008333333333333333, 0.}}, {-3.155328*^8, 
              FormBox[
               InterpretationBox[
                StyleBox[
                 
                 GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                  Baseline], "CacheGraphics" -> False], 
                Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
              0.008333333333333333, 0.}}, {0., 
              FormBox[
               InterpretationBox[
                StyleBox[
                 
                 GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                  Baseline], "CacheGraphics" -> False], 
                Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
              0.008333333333333333, 0.}}, {3.155328*^8, 
              FormBox[
               InterpretationBox[
                StyleBox[
                 
                 GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                  Baseline], "CacheGraphics" -> False], 
                Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
              0.008333333333333333, 0.}}, {6.310656*^8, 
              FormBox[
               InterpretationBox[
                StyleBox[
                 
                 GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                  Baseline], "CacheGraphics" -> False], 
                Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
              0.008333333333333333, 0.}}, {9.466848*^8, 
              FormBox[
               InterpretationBox[
                StyleBox[
                 
                 GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                  Baseline], "CacheGraphics" -> False], 
                Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
              0.008333333333333333, 0.}}, {1.2622176*^9, 
              FormBox[
               InterpretationBox[
                StyleBox[
                 
                 GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                  Baseline], "CacheGraphics" -> False], 
                Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
              0.008333333333333333, 0.}}, {1.5778368*^9, 
              FormBox[
               InterpretationBox[
                StyleBox[
                 
                 GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                  Baseline], "CacheGraphics" -> False], 
                Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
              0.008333333333333333, 0.}}, {1.8933696*^9, 
              FormBox[
               InterpretationBox[
                StyleBox[
                 
                 GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                  Baseline], "CacheGraphics" -> False], 
                Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
              0.008333333333333333, 0.}}, {2.2089888*^9, 
              FormBox[
               InterpretationBox[
                StyleBox[
                 
                 GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                  Baseline], "CacheGraphics" -> False], 
                Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
              0.008333333333333333, 0.}}, {2.5245216*^9, 
              FormBox[
               InterpretationBox[
                StyleBox[
                 
                 GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                  Baseline], "CacheGraphics" -> False], 
                Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
              0.008333333333333333, 0.}}, {2.8401408*^9, 
              FormBox[
               InterpretationBox[
                StyleBox[
                 
                 GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                  Baseline], "CacheGraphics" -> False], 
                Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
              0.008333333333333333, 0.}}, {3.1556736*^9, 
              FormBox[
               InterpretationBox[
                StyleBox[
                 
                 GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                  Baseline], "CacheGraphics" -> False], 
                Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
              0.008333333333333333, 0.}}, {3.4712928*^9, 
              FormBox[
               InterpretationBox[
                StyleBox[
                 
                 GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                  Baseline], "CacheGraphics" -> False], 
                Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
              0.008333333333333333, 0.}}}, {{-3.1556736*^9, 
              FormBox[
               InterpretationBox[
                StyleBox[
                 
                 GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                  Baseline], "CacheGraphics" -> False], 
                Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
              0.008333333333333333, 0.}}, {-1.5778368*^9, 
              FormBox[
               InterpretationBox[
                StyleBox[
                 
                 GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                  Baseline], "CacheGraphics" -> False], 
                Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
              0.008333333333333333, 0.}}, {0., 
              FormBox[
               InterpretationBox[
                StyleBox[
                 
                 GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                  Baseline], "CacheGraphics" -> False], 
                Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
              0.008333333333333333, 0.}}, {1.5778368*^9, 
              FormBox[
               InterpretationBox[
                StyleBox[
                 
                 GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                  Baseline], "CacheGraphics" -> False], 
                Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
              0.008333333333333333, 0.}}, {3.1556736*^9, 
              FormBox[
               InterpretationBox[
                StyleBox[
                 
                 GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                  Baseline], "CacheGraphics" -> False], 
                Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
              0.008333333333333333, 0.}}, {4.7335968*^9, 
              FormBox[
               InterpretationBox[
                StyleBox[
                 
                 GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                  Baseline], "CacheGraphics" -> False], 
                Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
              0.008333333333333333, 0.}}, {-3.1556736*^9, 
              FormBox[
               InterpretationBox[
                StyleBox[
                 
                 GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                  Baseline], "CacheGraphics" -> False], 
                Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
              0.008333333333333333, 0.}}, {-2.8401408*^9, 
              FormBox[
               InterpretationBox[
                StyleBox[
                 
                 GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                  Baseline], "CacheGraphics" -> False], 
                Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
              0.008333333333333333, 0.}}, {-2.524608*^9, 
              FormBox[
               InterpretationBox[
                StyleBox[
                 
                 GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                  Baseline], "CacheGraphics" -> False], 
                Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
              0.008333333333333333, 0.}}, {-2.2089888*^9, 
              FormBox[
               InterpretationBox[
                StyleBox[
                 
                 GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                  Baseline], "CacheGraphics" -> False], 
                Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
              0.008333333333333333, 0.}}, {-1.893456*^9, 
              FormBox[
               InterpretationBox[
                StyleBox[
                 
                 GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                  Baseline], "CacheGraphics" -> False], 
                Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
              0.008333333333333333, 0.}}, {-1.5778368*^9, 
              FormBox[
               InterpretationBox[
                StyleBox[
                 
                 GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                  Baseline], "CacheGraphics" -> False], 
                Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
              0.008333333333333333, 0.}}, {-1.262304*^9, 
              FormBox[
               InterpretationBox[
                StyleBox[
                 
                 GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                  Baseline], "CacheGraphics" -> False], 
                Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
              0.008333333333333333, 0.}}, {-9.466848*^8, 
              FormBox[
               InterpretationBox[
                StyleBox[
                 
                 GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                  Baseline], "CacheGraphics" -> False], 
                Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
              0.008333333333333333, 0.}}, {-6.31152*^8, 
              FormBox[
               InterpretationBox[
                StyleBox[
                 
                 GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                  Baseline], "CacheGraphics" -> False], 
                Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
              0.008333333333333333, 0.}}, {-3.155328*^8, 
              FormBox[
               InterpretationBox[
                StyleBox[
                 
                 GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                  Baseline], "CacheGraphics" -> False], 
                Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
              0.008333333333333333, 0.}}, {0., 
              FormBox[
               InterpretationBox[
                StyleBox[
                 
                 GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                  Baseline], "CacheGraphics" -> False], 
                Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
              0.008333333333333333, 0.}}, {3.155328*^8, 
              FormBox[
               InterpretationBox[
                StyleBox[
                 
                 GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                  Baseline], "CacheGraphics" -> False], 
                Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
              0.008333333333333333, 0.}}, {6.310656*^8, 
              FormBox[
               InterpretationBox[
                StyleBox[
                 
                 GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                  Baseline], "CacheGraphics" -> False], 
                Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
              0.008333333333333333, 0.}}, {9.466848*^8, 
              FormBox[
               InterpretationBox[
                StyleBox[
                 
                 GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                  Baseline], "CacheGraphics" -> False], 
                Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
              0.008333333333333333, 0.}}, {1.2622176*^9, 
              FormBox[
               InterpretationBox[
                StyleBox[
                 
                 GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                  Baseline], "CacheGraphics" -> False], 
                Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
              0.008333333333333333, 0.}}, {1.5778368*^9, 
              FormBox[
               InterpretationBox[
                StyleBox[
                 
                 GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                  Baseline], "CacheGraphics" -> False], 
                Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
              0.008333333333333333, 0.}}, {1.8933696*^9, 
              FormBox[
               InterpretationBox[
                StyleBox[
                 
                 GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                  Baseline], "CacheGraphics" -> False], 
                Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
              0.008333333333333333, 0.}}, {2.2089888*^9, 
              FormBox[
               InterpretationBox[
                StyleBox[
                 
                 GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                  Baseline], "CacheGraphics" -> False], 
                Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
              0.008333333333333333, 0.}}, {2.5245216*^9, 
              FormBox[
               InterpretationBox[
                StyleBox[
                 
                 GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                  Baseline], "CacheGraphics" -> False], 
                Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
              0.008333333333333333, 0.}}, {2.8401408*^9, 
              FormBox[
               InterpretationBox[
                StyleBox[
                 
                 GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                  Baseline], "CacheGraphics" -> False], 
                Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
              0.008333333333333333, 0.}}, {3.1556736*^9, 
              FormBox[
               InterpretationBox[
                StyleBox[
                 
                 GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                  Baseline], "CacheGraphics" -> False], 
                Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
              0.008333333333333333, 0.}}, {3.4712928*^9, 
              FormBox[
               InterpretationBox[
                StyleBox[
                 
                 GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                  Baseline], "CacheGraphics" -> False], 
                Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
              0.008333333333333333, 0.}}}}}],
        GridLines->{None, None},
        GridLinesStyle->Directive[
          GrayLevel[0.5, 0.4]],
        ImagePadding->All,
        Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
              (Identity[#]& )[
               Part[#, 1]], 
              (Identity[#]& )[
               Part[#, 2]]}& ), "CopiedValueFunction" -> ({
              (Identity[#]& )[
               Part[#, 1]], 
              (Identity[#]& )[
               Part[#, 2]]}& )}},
        PlotRange->{{-2.1774528*^9, 3.4081344*^9}, {0, 3.133426731371261*^-7}},
        PlotRangeClipping->True,
        PlotRangePadding->{{
           Scaled[0.02], 
           Scaled[0.02]}, {
           Scaled[0.02], 
           Scaled[0.05]}},
        Ticks->{{}, Automatic}]], "ExerciseOutput",ExpressionUUID->
       "d41cd0a7-9479-40f2-b005-73f517cafb9c"],
      Apply[TextCell, 
       Cell[
        BoxData[
         GraphicsBox[{{}, {{{}, {}, {{{{{
                  RGBColor[0.368417, 0.506779, 0.709798], 
                  PointSize[0.009166666666666668], 
                  AbsoluteThickness[1.6], 
                  LineBox[CompressedData["
1:eJw1lAk0lAsUx2mhhfYaxDORmCdMhUa9vLmE0jZZel6ppvfGKyrNsxVpGpXS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                   
                   "]]}}}}}}}, {}, {}, {{}, {}}, {{}, {}}}, AspectRatio -> 
          NCache[GoldenRatio^(-1), 0.6180339887498948], 
          Axes -> {False, False}, AxesLabel -> {None, None}, 
          AxesOrigin -> {-2.1774528*^9, 0}, DisplayFunction -> Identity, 
          Frame -> {{True, True}, {True, True}}, 
          FrameLabel -> {{None, None}, {None, None}}, FrameTicks -> 
          FrontEndValueCache[{{Automatic, Automatic}, {
             Charting`FindScaledTicks[
               (Charting`getDateTicks[Automatic, {Automatic}, 
                (Map[DateList, {
                  SlotSequence[1]}]& )[
                 SlotSequence[1]], None, 5, {{0.0125, 0}, {0.0075, 0}}, 
                Automatic]& )[
                SlotSequence[1]], {Identity, Identity}]& , 
              Charting`ScaledFrameTicks[
               (Charting`getDateTicks[
               Charting`getDateTicks[Automatic, {Automatic}, 
                 (Map[DateList, {
                   SlotSequence[1]}]& )[
                  SlotSequence[1]], None, 5, {{0.0125, 0}, {0.0075, 0}}, 
                 Automatic]& , {Automatic}, 
                (Map[DateList, {
                  SlotSequence[1]}]& )[
                 SlotSequence[1]], None, 5, {{0.0125, 0}, {0.0075, 0}}, 
                None]& )[
                SlotSequence[1]], {Identity, Identity}]& }}, {{
             Automatic, Automatic}, {{{-3.1556736*^9, 
                FormBox["\"1800\"", TraditionalForm], {0.008333333333333333, 
                0.}}, {-1.5778368*^9, 
                FormBox["\"1850\"", TraditionalForm], {0.008333333333333333, 
                0.}}, {0., 
                FormBox["\"1900\"", TraditionalForm], {0.008333333333333333, 
                0.}}, {1.5778368*^9, 
                FormBox["\"1950\"", TraditionalForm], {0.008333333333333333, 
                0.}}, {3.1556736*^9, 
                FormBox["\"2000\"", TraditionalForm], {0.008333333333333333, 
                0.}}, {4.7335968*^9, 
                FormBox["\"2050\"", TraditionalForm], {0.008333333333333333, 
                0.}}, {-3.1556736*^9, 
                FormBox[
                 InterpretationBox[
                  StyleBox[
                   
                   GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                  Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
                0.008333333333333333, 0.}}, {-2.8401408*^9, 
                FormBox[
                 InterpretationBox[
                  StyleBox[
                   
                   GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                  Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
                0.008333333333333333, 0.}}, {-2.524608*^9, 
                FormBox[
                 InterpretationBox[
                  StyleBox[
                   
                   GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                  Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
                0.008333333333333333, 0.}}, {-2.2089888*^9, 
                FormBox[
                 InterpretationBox[
                  StyleBox[
                   
                   GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                  Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
                0.008333333333333333, 0.}}, {-1.893456*^9, 
                FormBox[
                 InterpretationBox[
                  StyleBox[
                   
                   GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                  Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
                0.008333333333333333, 0.}}, {-1.5778368*^9, 
                FormBox[
                 InterpretationBox[
                  StyleBox[
                   
                   GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                  Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
                0.008333333333333333, 0.}}, {-1.262304*^9, 
                FormBox[
                 InterpretationBox[
                  StyleBox[
                   
                   GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                  Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
                0.008333333333333333, 0.}}, {-9.466848*^8, 
                FormBox[
                 InterpretationBox[
                  StyleBox[
                   
                   GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                  Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
                0.008333333333333333, 0.}}, {-6.31152*^8, 
                FormBox[
                 InterpretationBox[
                  StyleBox[
                   
                   GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                  Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
                0.008333333333333333, 0.}}, {-3.155328*^8, 
                FormBox[
                 InterpretationBox[
                  StyleBox[
                   
                   GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                  Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
                0.008333333333333333, 0.}}, {0., 
                FormBox[
                 InterpretationBox[
                  StyleBox[
                   
                   GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                  Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
                0.008333333333333333, 0.}}, {3.155328*^8, 
                FormBox[
                 InterpretationBox[
                  StyleBox[
                   
                   GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                  Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
                0.008333333333333333, 0.}}, {6.310656*^8, 
                FormBox[
                 InterpretationBox[
                  StyleBox[
                   
                   GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                  Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
                0.008333333333333333, 0.}}, {9.466848*^8, 
                FormBox[
                 InterpretationBox[
                  StyleBox[
                   
                   GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                  Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
                0.008333333333333333, 0.}}, {1.2622176*^9, 
                FormBox[
                 InterpretationBox[
                  StyleBox[
                   
                   GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                  Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
                0.008333333333333333, 0.}}, {1.5778368*^9, 
                FormBox[
                 InterpretationBox[
                  StyleBox[
                   
                   GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                  Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
                0.008333333333333333, 0.}}, {1.8933696*^9, 
                FormBox[
                 InterpretationBox[
                  StyleBox[
                   
                   GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                  Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
                0.008333333333333333, 0.}}, {2.2089888*^9, 
                FormBox[
                 InterpretationBox[
                  StyleBox[
                   
                   GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                  Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
                0.008333333333333333, 0.}}, {2.5245216*^9, 
                FormBox[
                 InterpretationBox[
                  StyleBox[
                   
                   GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                  Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
                0.008333333333333333, 0.}}, {2.8401408*^9, 
                FormBox[
                 InterpretationBox[
                  StyleBox[
                   
                   GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                  Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
                0.008333333333333333, 0.}}, {3.1556736*^9, 
                FormBox[
                 InterpretationBox[
                  StyleBox[
                   
                   GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                  Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
                0.008333333333333333, 0.}}, {3.4712928*^9, 
                FormBox[
                 InterpretationBox[
                  StyleBox[
                   
                   GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                  Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
                0.008333333333333333, 0.}}}, {{-3.1556736*^9, 
                FormBox[
                 InterpretationBox[
                  StyleBox[
                   
                   GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                  Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
                0.008333333333333333, 0.}}, {-1.5778368*^9, 
                FormBox[
                 InterpretationBox[
                  StyleBox[
                   
                   GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                  Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
                0.008333333333333333, 0.}}, {0., 
                FormBox[
                 InterpretationBox[
                  StyleBox[
                   
                   GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                  Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
                0.008333333333333333, 0.}}, {1.5778368*^9, 
                FormBox[
                 InterpretationBox[
                  StyleBox[
                   
                   GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                  Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
                0.008333333333333333, 0.}}, {3.1556736*^9, 
                FormBox[
                 InterpretationBox[
                  StyleBox[
                   
                   GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                  Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
                0.008333333333333333, 0.}}, {4.7335968*^9, 
                FormBox[
                 InterpretationBox[
                  StyleBox[
                   
                   GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                  Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
                0.008333333333333333, 0.}}, {-3.1556736*^9, 
                FormBox[
                 InterpretationBox[
                  StyleBox[
                   
                   GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                  Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
                0.008333333333333333, 0.}}, {-2.8401408*^9, 
                FormBox[
                 InterpretationBox[
                  StyleBox[
                   
                   GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                  Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
                0.008333333333333333, 0.}}, {-2.524608*^9, 
                FormBox[
                 InterpretationBox[
                  StyleBox[
                   
                   GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                  Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
                0.008333333333333333, 0.}}, {-2.2089888*^9, 
                FormBox[
                 InterpretationBox[
                  StyleBox[
                   
                   GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                  Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
                0.008333333333333333, 0.}}, {-1.893456*^9, 
                FormBox[
                 InterpretationBox[
                  StyleBox[
                   
                   GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                  Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
                0.008333333333333333, 0.}}, {-1.5778368*^9, 
                FormBox[
                 InterpretationBox[
                  StyleBox[
                   
                   GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                  Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
                0.008333333333333333, 0.}}, {-1.262304*^9, 
                FormBox[
                 InterpretationBox[
                  StyleBox[
                   
                   GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                  Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
                0.008333333333333333, 0.}}, {-9.466848*^8, 
                FormBox[
                 InterpretationBox[
                  StyleBox[
                   
                   GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                  Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
                0.008333333333333333, 0.}}, {-6.31152*^8, 
                FormBox[
                 InterpretationBox[
                  StyleBox[
                   
                   GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                  Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
                0.008333333333333333, 0.}}, {-3.155328*^8, 
                FormBox[
                 InterpretationBox[
                  StyleBox[
                   
                   GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                  Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
                0.008333333333333333, 0.}}, {0., 
                FormBox[
                 InterpretationBox[
                  StyleBox[
                   
                   GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                  Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
                0.008333333333333333, 0.}}, {3.155328*^8, 
                FormBox[
                 InterpretationBox[
                  StyleBox[
                   
                   GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                  Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
                0.008333333333333333, 0.}}, {6.310656*^8, 
                FormBox[
                 InterpretationBox[
                  StyleBox[
                   
                   GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                  Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
                0.008333333333333333, 0.}}, {9.466848*^8, 
                FormBox[
                 InterpretationBox[
                  StyleBox[
                   
                   GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                  Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
                0.008333333333333333, 0.}}, {1.2622176*^9, 
                FormBox[
                 InterpretationBox[
                  StyleBox[
                   
                   GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                  Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
                0.008333333333333333, 0.}}, {1.5778368*^9, 
                FormBox[
                 InterpretationBox[
                  StyleBox[
                   
                   GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                  Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
                0.008333333333333333, 0.}}, {1.8933696*^9, 
                FormBox[
                 InterpretationBox[
                  StyleBox[
                   
                   GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                  Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
                0.008333333333333333, 0.}}, {2.2089888*^9, 
                FormBox[
                 InterpretationBox[
                  StyleBox[
                   
                   GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                  Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
                0.008333333333333333, 0.}}, {2.5245216*^9, 
                FormBox[
                 InterpretationBox[
                  StyleBox[
                   
                   GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                  Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
                0.008333333333333333, 0.}}, {2.8401408*^9, 
                FormBox[
                 InterpretationBox[
                  StyleBox[
                   
                   GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                  Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
                0.008333333333333333, 0.}}, {3.1556736*^9, 
                FormBox[
                 InterpretationBox[
                  StyleBox[
                   
                   GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                  Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
                0.008333333333333333, 0.}}, {3.4712928*^9, 
                FormBox[
                 InterpretationBox[
                  StyleBox[
                   
                   GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
                    Baseline], "CacheGraphics" -> False], 
                  Spacer[{0., 0.}], Selectable -> False], TraditionalForm], {
                0.008333333333333333, 0.}}}}}], GridLines -> {None, None}, 
          GridLinesStyle -> Directive[
            GrayLevel[0.5, 0.4]], ImagePadding -> All, 
          Method -> {"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
                (Identity[#]& )[
                 Part[#, 1]], 
                (Identity[#]& )[
                 Part[#, 2]]}& ), "CopiedValueFunction" -> ({
                (Identity[#]& )[
                 Part[#, 1]], 
                (Identity[#]& )[
                 Part[#, 2]]}& )}}, 
          PlotRange -> {{-2.1774528*^9, 3.4081344*^9}, {
            0, 3.133426731371261*^-7}}, PlotRangeClipping -> True, 
          PlotRangePadding -> {{
             Scaled[0.02], 
             Scaled[0.02]}, {
             Scaled[0.02], 
             Scaled[0.05]}}, Ticks -> {{}, Automatic}]], "ExerciseOutput", 
        Selectable -> False, Copyable -> False, Editable -> False, 
        ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"37a76c85-283a-4c80-9e7c-4811e76ce1d2"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Compute how many weeks have elapsed since January 1, 1900.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+19.1", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"368d345a-1dd8-4ba8-966e-44428adfd846"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       TemplateBox[{"6115.571428571428`", "\"wk\"", "weeks", "\"Weeks\""},
        "Quantity"]], "ExerciseOutput",ExpressionUUID->
       "797d5956-92fa-484c-8a24-1a760056be98"],
      Apply[TextCell, 
       Cell[
        BoxData[
         TemplateBox[{"6115.571428571428`", "\"wk\"", "weeks", "\"Weeks\""}, 
          "Quantity"]], "ExerciseOutput", Selectable -> False, Copyable -> 
        False, Editable -> False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"f3f01072-e815-4c45-82f2-d07135230777"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Compute the time between 3 pm today and sunset today.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+19.2", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"41b35cc4-1bcd-434b-858d-e40107725b46"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       TemplateBox[{"4`", "\"h\"", "hours", "\"Hours\""},
        "Quantity"]], "ExerciseOutput",ExpressionUUID->
       "2219f70b-861b-4c9c-9378-1fc42d90e71f"],
      Apply[TextCell, 
       Cell[
        BoxData[
         TemplateBox[{"4`", "\"h\"", "hours", "\"Hours\""}, "Quantity"]], 
        "ExerciseOutput", Selectable -> False, Copyable -> False, Editable -> 
        False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"1a066845-eed1-445d-bb7e-c361ef5166e5"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Generate an icon of the phase of the moon on August 29, 1959.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+19.3", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"896bfd65-d6ce-4c66-80ca-5c6e3bc8b9ac"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       GraphicsBox[{
         {GrayLevel[0.75], 
          PolygonBox[{{-1.1, -1.3}, {1.1, -1.3}, {1.3, -1.1}, {1.3, 1.1}, {
           1.1, 1.3}, {-1.1, 1.3}, {-1.3, 1.1}, {-1.3, -1.1}}], 
          DiskBox[{-1.1, -1.1}, 0.2], DiskBox[{1.1, -1.1}, 0.2], 
          DiskBox[{1.1, 1.1}, 0.2], DiskBox[{-1.1, 1.1}, 0.2]}, 
         {GrayLevel[1], 
          DiskBox[{0, 0}, 1, 
           NCache[{Rational[1, 2] Pi, Rational[3, 2] Pi}, {
            1.5707963267948966`, 4.71238898038469}]]}, 
         {GrayLevel[0.75], DiskBox[{0, 0}, {0.5226366703055084, 1.}]}, 
         {GrayLevel[0.6], CircleBox[{0, 0}]}},
        AspectRatio->1,
        ImageSize->100]], "ExerciseOutput",ExpressionUUID->
       "268d82dd-1562-4ab5-b0d3-e954e5cb80b8"],
      Apply[TextCell, 
       Cell[
        BoxData[
         GraphicsBox[{{{{{{
                GrayLevel[0.75], 
                
                PolygonBox[{{-1.1, -1.3}, {1.1, -1.3}, {1.3, -1.1}, {1.3, 
                 1.1}, {1.1, 1.3}, {-1.1, 1.3}, {-1.3, 1.1}, {-1.3, -1.1}}], 
                DiskBox[{-1.1, -1.1}, 0.2], 
                DiskBox[{1.1, -1.1}, 0.2], 
                DiskBox[{1.1, 1.1}, 0.2], 
                DiskBox[{-1.1, 1.1}, 0.2]}}}}}, {{{{{
                GrayLevel[1], 
                DiskBox[{0, 0}, 1, 
                 
                 NCache[{Rational[1, 2] Pi, Rational[3, 2] Pi}, {
                  1.5707963267948966`, 4.71238898038469}]]}}}}}, {{{{{
                GrayLevel[0.75], 
                DiskBox[{0, 0}, {0.5226366703055084, 1.}]}}}}}, {{{{{
                GrayLevel[0.6], 
                CircleBox[{0, 0}]}}}}}}, AspectRatio -> 1, ImageSize -> 100]],
         "ExerciseOutput", Selectable -> False, Copyable -> False, Editable -> 
        False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"f483dfbe-96e6-4304-87e0-291d2ecbb7fc"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Make a line plot of the numerical phase of the moon for each of the next 30 \
days.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+19.4", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"b53347b6-b8be-47ab-8037-875596285b76"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       GraphicsBox[{{}, {{}, {}, 
          {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
           0.019444444444444445`], AbsoluteThickness[1.6], 
           LineBox[CompressedData["
1:eJxTTMoPSmViYGCQA2IQDQEf7N98vbuFZcZTe6iAg8WuWRlH1z6C8jkc4jOW
Ff3wug/lCzg4nIjk5NW6CeWLOMTpzRX9pXkZypdwuPEpKeEYx2koX8aBJVFE
i/HXAShfweEKg8XLhY0boXwlB4WsTUukX0yH8lUcGnL7vkmyJUD5ag4NtczP
VQ3qoHwNhwyVHwlLLyyB8rUcZKLvWpWv3wnl6zjUJT2cVRtzHMrXc9hdNKlO
leUSlG/g8M7AwP0rI8z9hg6XuhMFZso+gPKNHCaKOtVzLnsM5Rs7JEkeXeny
/hmUb+LgGp+syH7tJZRv6jApKrfvjd0bKN/MgT8x5KKv2Dso39yhIdopWDDg
PZRv4fCB569I5HMY39LhQsQl1ad3YXwrB7/T07hErWF8a4d06Qk2s7hg5tk4
hPpzVQtGw+yzdfism3nwhM0rKN/OYcrJRo1PB57bAwB8/3/z
            
            "]]}}, {}, {}, {{}, {}}, {{}, {}}},
        AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
        Axes->{True, True},
        AxesLabel->{None, None},
        AxesOrigin->{0., 0},
        DisplayFunction->Identity,
        Frame->{{False, False}, {False, False}},
        FrameLabel->{{None, None}, {None, None}},
        FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
        GridLines->{None, None},
        GridLinesStyle->Directive[
          GrayLevel[0.5, 0.4]],
        ImagePadding->All,
        Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
              (Identity[#]& )[
               Part[#, 1]], 
              (Identity[#]& )[
               Part[#, 2]]}& ), "CopiedValueFunction" -> ({
              (Identity[#]& )[
               Part[#, 1]], 
              (Identity[#]& )[
               Part[#, 2]]}& )}},
        PlotRange->{{0., 30.}, {0, 0.996990719788668}},
        PlotRangeClipping->True,
        PlotRangePadding->{{
           Scaled[0.02], 
           Scaled[0.02]}, {
           Scaled[0.02], 
           Scaled[0.05]}},
        Ticks->{Automatic, Automatic}]], "ExerciseOutput",ExpressionUUID->
       "4dc9197f-6b19-44be-a83b-a3d31988c98d"],
      Apply[TextCell, 
       Cell[
        BoxData[
         GraphicsBox[{{}, {{{}, {}, {{{{
                 RGBColor[0.368417, 0.506779, 0.709798], 
                 PointSize[0.019444444444444445`], 
                 AbsoluteThickness[1.6], 
                 LineBox[CompressedData["
1:eJxTTMoPSmViYGCQA2IQDQEf7N98vbuFZcZTe6iAg8WuWRlH1z6C8jkc4jOW
Ff3wug/lCzg4nIjk5NW6CeWLOMTpzRX9pXkZypdwuPEpKeEYx2koX8aBJVFE
i/HXAShfweEKg8XLhY0boXwlB4WsTUukX0yH8lUcGnL7vkmyJUD5ag4NtczP
VQ3qoHwNhwyVHwlLLyyB8rUcZKLvWpWv3wnl6zjUJT2cVRtzHMrXc9hdNKlO
leUSlG/g8M7AwP0rI8z9hg6XuhMFZso+gPKNHCaKOtVzLnsM5Rs7JEkeXeny
/hmUb+LgGp+syH7tJZRv6jApKrfvjd0bKN/MgT8x5KKv2Dso39yhIdopWDDg
PZRv4fCB569I5HMY39LhQsQl1ad3YXwrB7/T07hErWF8a4d06Qk2s7hg5tk4
hPpzVQtGw+yzdfism3nwhM0rKN/OYcrJRo1PB57bAwB8/3/z
                  
                  "]]}}}}}}, {}, {}, {{}, {}}, {{}, {}}}, AspectRatio -> 
          NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
          AxesLabel -> {None, None}, AxesOrigin -> {0., 0}, DisplayFunction -> 
          Identity, Frame -> {{False, False}, {False, False}}, 
          FrameLabel -> {{None, None}, {None, None}}, 
          FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
          GridLines -> {None, None}, GridLinesStyle -> Directive[
            GrayLevel[0.5, 0.4]], ImagePadding -> All, 
          Method -> {"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
                (Identity[#]& )[
                 Part[#, 1]], 
                (Identity[#]& )[
                 Part[#, 2]]}& ), "CopiedValueFunction" -> ({
                (Identity[#]& )[
                 Part[#, 1]], 
                (Identity[#]& )[
                 Part[#, 2]]}& )}}, 
          PlotRange -> {{0., 30.}, {0, 0.996990719788668}}, PlotRangeClipping -> 
          True, PlotRangePadding -> {{
             Scaled[0.02], 
             Scaled[0.02]}, {
             Scaled[0.02], 
             Scaled[0.05]}}, Ticks -> {Automatic, Automatic}]], 
        "ExerciseOutput", Selectable -> False, Copyable -> False, Editable -> 
        False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"8116f4d2-b4b7-453f-ac8f-5dbe2a2b43d4"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Make a ",
 ButtonBox["Manipulate",
  BaseStyle->"Link"],
 " of the icon for the moon phase over the next 15 days.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+19.5", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"d2677d14-16fd-407d-b784-1bfa4929aaa0"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       TagBox[
        StyleBox[
         DynamicModuleBox[{$CellContext`n$$ = 0, Typeset`show$$ = True, 
          Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
          Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
          "\"untitled\"", Typeset`specs$$ = {{
            Hold[$CellContext`n$$], 0, 15}}, Typeset`size$$ = {
          100., {47., 53.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
          Typeset`skipInitDone$$ = True, $CellContext`n$205031$$ = 0}, 
          
          DynamicBox[Manipulate`ManipulateBoxes[
           1, StandardForm, "Variables" :> {$CellContext`n$$ = 0}, 
            "ControllerVariables" :> {
              Hold[$CellContext`n$$, $CellContext`n$205031$$, 0]}, 
            "OtherVariables" :> {
             Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
              Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
              Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
              Typeset`initDone$$, Typeset`skipInitDone$$}, "Body" :> 
            MoonPhase[Today + $CellContext`n$$ Quantity[1, "Days"], "Icon"], 
            "Specifications" :> {{$CellContext`n$$, 0, 15}}, "Options" :> {}, 
            "DefaultOptions" :> {}],
           ImageSizeCache->{247., {94., 100.}},
           SingleEvaluation->True],
          Deinitialization:>None,
          DynamicModuleValues:>{},
          SynchronousInitialization->True,
          UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
          UnsavedVariables:>{Typeset`initDone$$},
          UntrackedVariables:>{Typeset`size$$}], "Manipulate",
         Deployed->True,
         StripOnInput->False],
        Manipulate`InterpretManipulate[1]]], "ExerciseOutput",ExpressionUUID->
       "89db5200-4aa1-43e2-bff0-9f73747d2217"],
      Apply[TextCell, 
       Cell[
        BoxData[
         TagBox[
          StyleBox[
           
           DynamicModuleBox[{$CellContext`n$$ = 0, Typeset`show$$ = True, 
             Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
             Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
             "\"untitled\"", Typeset`specs$$ = {{
                Hold[$CellContext`n$$], 0, 15}}, 
             Typeset`size$$ = {100., {47., 53.}}, Typeset`update$$ = 0, 
             Typeset`initDone$$, Typeset`skipInitDone$$ = 
             True, $CellContext`n$205031$$ = 0}, 
            DynamicBox[
             Manipulate`ManipulateBoxes[
             1, StandardForm, "Variables" :> {$CellContext`n$$ = 0}, 
              "ControllerVariables" :> {
                Hold[$CellContext`n$$, $CellContext`n$205031$$, 0]}, 
              "OtherVariables" :> {
               Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$,
                 Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
                Typeset`specs$$, Typeset`size$$, Typeset`update$$, 
                Typeset`initDone$$, Typeset`skipInitDone$$}, "Body" :> 
              MoonPhase[Today + $CellContext`n$$ Quantity[1, "Days"], "Icon"],
               "Specifications" :> {{$CellContext`n$$, 0, 15}}, 
              "Options" :> {}, "DefaultOptions" :> {}], 
             ImageSizeCache -> {258., {95., 102.}}, SingleEvaluation -> True],
             Deinitialization :> None, DynamicModuleValues :> {}, 
            SynchronousInitialization -> True, 
            UndoTrackedVariables :> {Typeset`show$$, Typeset`bookmarkMode$$}, 
            UnsavedVariables :> {Typeset`initDone$$}, 
            UntrackedVariables :> {Typeset`size$$}], "Manipulate", Deployed -> 
           True, StripOnInput -> False], 
          Manipulate`InterpretManipulate[1]]], "ExerciseOutput", Selectable -> 
        False, Copyable -> False, Editable -> False, ShowCellBracket -> 
        False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"28658296-1a71-4823-a5a1-f452603399e9"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Show in a column the times of sunrise for 10 days, starting today.",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+19.6", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"263f4a43-f05d-4543-b794-343eab0e25cd"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       TagBox[GridBox[{
          {
           TemplateBox[{
             RowBox[{
               StyleBox[
               "\"Minute: \"", FontColor -> GrayLevel[0.5], FontWeight -> 
                Plain], "\"Sat 18 Mar 2017 07:00\"", 
               StyleBox[
                RowBox[{"\"GMT\"", "\[InvisibleSpace]", 
                  RowBox[{"-", "5.`"}]}], FontColor -> GrayLevel[0.5]]}], 
             RowBox[{"DateObject", "[", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"2017", ",", "3", ",", "18", ",", "7", ",", "0"}], 
                   "}"}], ",", "\"Minute\"", ",", "\"Gregorian\"", ",", 
                 RowBox[{"-", "5.`"}]}], "]"}]},
            "DateObject",
            Editable->False]},
          {
           TemplateBox[{
             RowBox[{
               StyleBox[
               "\"Minute: \"", FontColor -> GrayLevel[0.5], FontWeight -> 
                Plain], "\"Sun 19 Mar 2017 06:59\"", 
               StyleBox[
                RowBox[{"\"GMT\"", "\[InvisibleSpace]", 
                  RowBox[{"-", "5.`"}]}], FontColor -> GrayLevel[0.5]]}], 
             RowBox[{"DateObject", "[", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"2017", ",", "3", ",", "19", ",", "6", ",", "59"}],
                    "}"}], ",", "\"Minute\"", ",", "\"Gregorian\"", ",", 
                 RowBox[{"-", "5.`"}]}], "]"}]},
            "DateObject",
            Editable->False]},
          {
           TemplateBox[{
             RowBox[{
               StyleBox[
               "\"Minute: \"", FontColor -> GrayLevel[0.5], FontWeight -> 
                Plain], "\"Mon 20 Mar 2017 06:57\"", 
               StyleBox[
                RowBox[{"\"GMT\"", "\[InvisibleSpace]", 
                  RowBox[{"-", "5.`"}]}], FontColor -> GrayLevel[0.5]]}], 
             RowBox[{"DateObject", "[", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"2017", ",", "3", ",", "20", ",", "6", ",", "57"}],
                    "}"}], ",", "\"Minute\"", ",", "\"Gregorian\"", ",", 
                 RowBox[{"-", "5.`"}]}], "]"}]},
            "DateObject",
            Editable->False]},
          {
           TemplateBox[{
             RowBox[{
               StyleBox[
               "\"Minute: \"", FontColor -> GrayLevel[0.5], FontWeight -> 
                Plain], "\"Tue 21 Mar 2017 06:56\"", 
               StyleBox[
                RowBox[{"\"GMT\"", "\[InvisibleSpace]", 
                  RowBox[{"-", "5.`"}]}], FontColor -> GrayLevel[0.5]]}], 
             RowBox[{"DateObject", "[", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"2017", ",", "3", ",", "21", ",", "6", ",", "56"}],
                    "}"}], ",", "\"Minute\"", ",", "\"Gregorian\"", ",", 
                 RowBox[{"-", "5.`"}]}], "]"}]},
            "DateObject",
            Editable->False]},
          {
           TemplateBox[{
             RowBox[{
               StyleBox[
               "\"Minute: \"", FontColor -> GrayLevel[0.5], FontWeight -> 
                Plain], "\"Wed 22 Mar 2017 06:54\"", 
               StyleBox[
                RowBox[{"\"GMT\"", "\[InvisibleSpace]", 
                  RowBox[{"-", "5.`"}]}], FontColor -> GrayLevel[0.5]]}], 
             RowBox[{"DateObject", "[", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"2017", ",", "3", ",", "22", ",", "6", ",", "54"}],
                    "}"}], ",", "\"Minute\"", ",", "\"Gregorian\"", ",", 
                 RowBox[{"-", "5.`"}]}], "]"}]},
            "DateObject",
            Editable->False]},
          {
           TemplateBox[{
             RowBox[{
               StyleBox[
               "\"Minute: \"", FontColor -> GrayLevel[0.5], FontWeight -> 
                Plain], "\"Thu 23 Mar 2017 06:52\"", 
               StyleBox[
                RowBox[{"\"GMT\"", "\[InvisibleSpace]", 
                  RowBox[{"-", "5.`"}]}], FontColor -> GrayLevel[0.5]]}], 
             RowBox[{"DateObject", "[", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"2017", ",", "3", ",", "23", ",", "6", ",", "52"}],
                    "}"}], ",", "\"Minute\"", ",", "\"Gregorian\"", ",", 
                 RowBox[{"-", "5.`"}]}], "]"}]},
            "DateObject",
            Editable->False]},
          {
           TemplateBox[{
             RowBox[{
               StyleBox[
               "\"Minute: \"", FontColor -> GrayLevel[0.5], FontWeight -> 
                Plain], "\"Fri 24 Mar 2017 06:51\"", 
               StyleBox[
                RowBox[{"\"GMT\"", "\[InvisibleSpace]", 
                  RowBox[{"-", "5.`"}]}], FontColor -> GrayLevel[0.5]]}], 
             RowBox[{"DateObject", "[", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"2017", ",", "3", ",", "24", ",", "6", ",", "51"}],
                    "}"}], ",", "\"Minute\"", ",", "\"Gregorian\"", ",", 
                 RowBox[{"-", "5.`"}]}], "]"}]},
            "DateObject",
            Editable->False]},
          {
           TemplateBox[{
             RowBox[{
               StyleBox[
               "\"Minute: \"", FontColor -> GrayLevel[0.5], FontWeight -> 
                Plain], "\"Sat 25 Mar 2017 06:49\"", 
               StyleBox[
                RowBox[{"\"GMT\"", "\[InvisibleSpace]", 
                  RowBox[{"-", "5.`"}]}], FontColor -> GrayLevel[0.5]]}], 
             RowBox[{"DateObject", "[", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"2017", ",", "3", ",", "25", ",", "6", ",", "49"}],
                    "}"}], ",", "\"Minute\"", ",", "\"Gregorian\"", ",", 
                 RowBox[{"-", "5.`"}]}], "]"}]},
            "DateObject",
            Editable->False]},
          {
           TemplateBox[{
             RowBox[{
               StyleBox[
               "\"Minute: \"", FontColor -> GrayLevel[0.5], FontWeight -> 
                Plain], "\"Sun 26 Mar 2017 06:47\"", 
               StyleBox[
                RowBox[{"\"GMT\"", "\[InvisibleSpace]", 
                  RowBox[{"-", "5.`"}]}], FontColor -> GrayLevel[0.5]]}], 
             RowBox[{"DateObject", "[", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"2017", ",", "3", ",", "26", ",", "6", ",", "47"}],
                    "}"}], ",", "\"Minute\"", ",", "\"Gregorian\"", ",", 
                 RowBox[{"-", "5.`"}]}], "]"}]},
            "DateObject",
            Editable->False]},
          {
           TemplateBox[{
             RowBox[{
               StyleBox[
               "\"Minute: \"", FontColor -> GrayLevel[0.5], FontWeight -> 
                Plain], "\"Mon 27 Mar 2017 06:46\"", 
               StyleBox[
                RowBox[{"\"GMT\"", "\[InvisibleSpace]", 
                  RowBox[{"-", "5.`"}]}], FontColor -> GrayLevel[0.5]]}], 
             RowBox[{"DateObject", "[", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"2017", ",", "3", ",", "27", ",", "6", ",", "46"}],
                    "}"}], ",", "\"Minute\"", ",", "\"Gregorian\"", ",", 
                 RowBox[{"-", "5.`"}]}], "]"}]},
            "DateObject",
            Editable->False]}
         },
         DefaultBaseStyle->"Column",
         GridBoxAlignment->{"Columns" -> {{Left}}},
         GridBoxItemSize->{
          "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
        "Column"]], "ExerciseOutput",ExpressionUUID->
       "a5526aeb-0dc2-4a56-8b86-a0d3e32a5653"],
      Apply[TextCell, 
       Cell[
        BoxData[
         TagBox[
          GridBox[{{
             TemplateBox[{
               RowBox[{
                 StyleBox[
                 "\"Minute: \"", FontColor -> GrayLevel[0.5], FontWeight -> 
                  Plain], "\"Sat 18 Mar 2017 07:00\"", 
                 StyleBox[
                  RowBox[{"\"GMT\"", "\[InvisibleSpace]", 
                    RowBox[{"-", "5.`"}]}], FontColor -> GrayLevel[0.5]]}], 
               RowBox[{"DateObject", "[", 
                 RowBox[{
                   RowBox[{"{", 
                    RowBox[{"2017", ",", "3", ",", "18", ",", "7", ",", "0"}],
                     "}"}], ",", "\"Minute\"", ",", "\"Gregorian\"", ",", 
                   RowBox[{"-", "5.`"}]}], "]"}]}, "DateObject", Editable -> 
              False]}, {
             TemplateBox[{
               RowBox[{
                 StyleBox[
                 "\"Minute: \"", FontColor -> GrayLevel[0.5], FontWeight -> 
                  Plain], "\"Sun 19 Mar 2017 06:59\"", 
                 StyleBox[
                  RowBox[{"\"GMT\"", "\[InvisibleSpace]", 
                    RowBox[{"-", "5.`"}]}], FontColor -> GrayLevel[0.5]]}], 
               RowBox[{"DateObject", "[", 
                 RowBox[{
                   RowBox[{"{", 
                    
                    RowBox[{
                    "2017", ",", "3", ",", "19", ",", "6", ",", "59"}], "}"}],
                    ",", "\"Minute\"", ",", "\"Gregorian\"", ",", 
                   RowBox[{"-", "5.`"}]}], "]"}]}, "DateObject", Editable -> 
              False]}, {
             TemplateBox[{
               RowBox[{
                 StyleBox[
                 "\"Minute: \"", FontColor -> GrayLevel[0.5], FontWeight -> 
                  Plain], "\"Mon 20 Mar 2017 06:57\"", 
                 StyleBox[
                  RowBox[{"\"GMT\"", "\[InvisibleSpace]", 
                    RowBox[{"-", "5.`"}]}], FontColor -> GrayLevel[0.5]]}], 
               RowBox[{"DateObject", "[", 
                 RowBox[{
                   RowBox[{"{", 
                    
                    RowBox[{
                    "2017", ",", "3", ",", "20", ",", "6", ",", "57"}], "}"}],
                    ",", "\"Minute\"", ",", "\"Gregorian\"", ",", 
                   RowBox[{"-", "5.`"}]}], "]"}]}, "DateObject", Editable -> 
              False]}, {
             TemplateBox[{
               RowBox[{
                 StyleBox[
                 "\"Minute: \"", FontColor -> GrayLevel[0.5], FontWeight -> 
                  Plain], "\"Tue 21 Mar 2017 06:56\"", 
                 StyleBox[
                  RowBox[{"\"GMT\"", "\[InvisibleSpace]", 
                    RowBox[{"-", "5.`"}]}], FontColor -> GrayLevel[0.5]]}], 
               RowBox[{"DateObject", "[", 
                 RowBox[{
                   RowBox[{"{", 
                    
                    RowBox[{
                    "2017", ",", "3", ",", "21", ",", "6", ",", "56"}], "}"}],
                    ",", "\"Minute\"", ",", "\"Gregorian\"", ",", 
                   RowBox[{"-", "5.`"}]}], "]"}]}, "DateObject", Editable -> 
              False]}, {
             TemplateBox[{
               RowBox[{
                 StyleBox[
                 "\"Minute: \"", FontColor -> GrayLevel[0.5], FontWeight -> 
                  Plain], "\"Wed 22 Mar 2017 06:54\"", 
                 StyleBox[
                  RowBox[{"\"GMT\"", "\[InvisibleSpace]", 
                    RowBox[{"-", "5.`"}]}], FontColor -> GrayLevel[0.5]]}], 
               RowBox[{"DateObject", "[", 
                 RowBox[{
                   RowBox[{"{", 
                    
                    RowBox[{
                    "2017", ",", "3", ",", "22", ",", "6", ",", "54"}], "}"}],
                    ",", "\"Minute\"", ",", "\"Gregorian\"", ",", 
                   RowBox[{"-", "5.`"}]}], "]"}]}, "DateObject", Editable -> 
              False]}, {
             TemplateBox[{
               RowBox[{
                 StyleBox[
                 "\"Minute: \"", FontColor -> GrayLevel[0.5], FontWeight -> 
                  Plain], "\"Thu 23 Mar 2017 06:52\"", 
                 StyleBox[
                  RowBox[{"\"GMT\"", "\[InvisibleSpace]", 
                    RowBox[{"-", "5.`"}]}], FontColor -> GrayLevel[0.5]]}], 
               RowBox[{"DateObject", "[", 
                 RowBox[{
                   RowBox[{"{", 
                    
                    RowBox[{
                    "2017", ",", "3", ",", "23", ",", "6", ",", "52"}], "}"}],
                    ",", "\"Minute\"", ",", "\"Gregorian\"", ",", 
                   RowBox[{"-", "5.`"}]}], "]"}]}, "DateObject", Editable -> 
              False]}, {
             TemplateBox[{
               RowBox[{
                 StyleBox[
                 "\"Minute: \"", FontColor -> GrayLevel[0.5], FontWeight -> 
                  Plain], "\"Fri 24 Mar 2017 06:51\"", 
                 StyleBox[
                  RowBox[{"\"GMT\"", "\[InvisibleSpace]", 
                    RowBox[{"-", "5.`"}]}], FontColor -> GrayLevel[0.5]]}], 
               RowBox[{"DateObject", "[", 
                 RowBox[{
                   RowBox[{"{", 
                    
                    RowBox[{
                    "2017", ",", "3", ",", "24", ",", "6", ",", "51"}], "}"}],
                    ",", "\"Minute\"", ",", "\"Gregorian\"", ",", 
                   RowBox[{"-", "5.`"}]}], "]"}]}, "DateObject", Editable -> 
              False]}, {
             TemplateBox[{
               RowBox[{
                 StyleBox[
                 "\"Minute: \"", FontColor -> GrayLevel[0.5], FontWeight -> 
                  Plain], "\"Sat 25 Mar 2017 06:49\"", 
                 StyleBox[
                  RowBox[{"\"GMT\"", "\[InvisibleSpace]", 
                    RowBox[{"-", "5.`"}]}], FontColor -> GrayLevel[0.5]]}], 
               RowBox[{"DateObject", "[", 
                 RowBox[{
                   RowBox[{"{", 
                    
                    RowBox[{
                    "2017", ",", "3", ",", "25", ",", "6", ",", "49"}], "}"}],
                    ",", "\"Minute\"", ",", "\"Gregorian\"", ",", 
                   RowBox[{"-", "5.`"}]}], "]"}]}, "DateObject", Editable -> 
              False]}, {
             TemplateBox[{
               RowBox[{
                 StyleBox[
                 "\"Minute: \"", FontColor -> GrayLevel[0.5], FontWeight -> 
                  Plain], "\"Sun 26 Mar 2017 06:47\"", 
                 StyleBox[
                  RowBox[{"\"GMT\"", "\[InvisibleSpace]", 
                    RowBox[{"-", "5.`"}]}], FontColor -> GrayLevel[0.5]]}], 
               RowBox[{"DateObject", "[", 
                 RowBox[{
                   RowBox[{"{", 
                    RowBox[{
                    "2017", ",", "3", ",", "26", ",", "6", ",", "47"}], "}"}],
                    ",", "\"Minute\"", ",", "\"Gregorian\"", ",", 
                   RowBox[{"-", "5.`"}]}], "]"}]}, "DateObject", Editable -> 
              False]}, {
             TemplateBox[{
               RowBox[{
                 StyleBox[
                 "\"Minute: \"", FontColor -> GrayLevel[0.5], FontWeight -> 
                  Plain], "\"Mon 27 Mar 2017 06:46\"", 
                 StyleBox[
                  RowBox[{"\"GMT\"", "\[InvisibleSpace]", 
                    RowBox[{"-", "5.`"}]}], FontColor -> GrayLevel[0.5]]}], 
               RowBox[{"DateObject", "[", 
                 RowBox[{
                   RowBox[{"{", 
                    
                    RowBox[{
                    "2017", ",", "3", ",", "27", ",", "6", ",", "46"}], "}"}],
                    ",", "\"Minute\"", ",", "\"Gregorian\"", ",", 
                   RowBox[{"-", "5.`"}]}], "]"}]}, "DateObject", Editable -> 
              False]}}, DefaultBaseStyle -> "Column", 
           GridBoxAlignment -> {"Columns" -> {{Left}}}, 
           GridBoxItemSize -> {
            "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], "Column"]],
         "ExerciseOutput", Selectable -> False, Copyable -> False, Editable -> 
        False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"3959ae8e-8caf-47c5-9ada-7b7dfd44e6e6"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Plot together the historical frequencies of the words \
\[OpenCurlyDoubleQuote]science\[CloseCurlyDoubleQuote] and \
\[OpenCurlyDoubleQuote]technology\[CloseCurlyDoubleQuote].",
 StyleBox[ButtonBox["\[NonBreakingSpace]\[RightGuillemet]",
  Appearance->None,
  Evaluator->Automatic,
  Method->"Preemptive",
  ButtonFunction:>(SelectionMove[
     ButtonNotebook[], All, ButtonCell, AutoScroll -> False]; 
   FrontEndExecute[
     FrontEndToken[
      ButtonNotebook[], "OpenCloseGroup"]])],
  FontColor->RGBColor[1, 0.501961, 0]]
}], "Exercise",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellDingbat->Cell[
  "+19.7", "ExerciseNumber", FontColor -> 
   RGBColor[0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]],
 ShowCellBracket->
  False,ExpressionUUID->"b946f493-e2fc-4d1d-84ee-f9216e4785f6"],

Cell[BoxData[
 PaneBox[GridBox[{
    {" ", 
     StyleBox[
      RowBox[{"Expected", " ", 
       RowBox[{"output", ":"}]}],
      Editable->False,
      Selectable->False,
      StripOnInput->False,
      FontColor->RGBColor[0.45, 0.45, 0.45]], " "},
    {" ", 
     InterpretationBox[Cell[BoxData[
       TemplateBox[{
         GraphicsBox[{{}, {{{}, {}, {
              Hue[0.67, 0.6, 0.6], 
              Directive[
               PointSize[0.0055000000000000005`], 
               RGBColor[0.368417, 0.506779, 0.709798], 
               AbsoluteThickness[1.6]], 
              LineBox[CompressedData["
1:eJw9V3k8lekX1zItlqzhLpa0YKhpKNHCfZJQWbIUWtxEi/JLZUtlVKaplGwt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               "]]}, {
              Hue[0.9060679774997897, 0.6, 0.6], 
              Directive[
               PointSize[0.0055000000000000005`], 
               RGBColor[0.880722, 0.611041, 0.142051], 
               AbsoluteThickness[1.6]], 
              LineBox[CompressedData["
1:eJw1Vwk4lVsX9ncvMt1LIlRESqU/RSENzmq+pUiRZk1oMEQ0mEnklzkN5iRX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               
               "]]}}}, {}, {}, {{}, {}}, {{}, {}}}, {
          DisplayFunction -> Identity, DisplayFunction -> Identity, 
           PlotRangePadding -> {{
              Scaled[0.02], 
              Scaled[0.02]}, {
              Scaled[0.02], 
              Scaled[0.05]}}, AxesOrigin -> {-6.3113472*^9, 0}, 
           PlotRange -> {{-6.3113472*^9, 3.4081344*^9}, {
             0, 0.00013027117460428077`}}, PlotRangeClipping -> True, 
           ImagePadding -> All, DisplayFunction -> Identity, AspectRatio -> 
           NCache[GoldenRatio^(-1), 0.6180339887498948], 
           Axes -> {False, False}, AxesLabel -> {None, None}, 
           AxesOrigin -> {-6.3113472*^9, 0}, DisplayFunction :> Identity, 
           Frame -> {{True, True}, {True, True}}, 
           FrameLabel -> {{None, None}, {None, None}}, 
           FrameTicks -> {{Automatic, Automatic}, {Charting`FindScaledTicks[
               (Charting`getDateTicks[Automatic, {Automatic}, 
                (Map[DateList, {
                  SlotSequence[1]}]& )[
                 SlotSequence[1]], None, 5, {{0.0125, 0}, {0.0075, 0}}, 
                Automatic]& )[
                SlotSequence[1]], {Identity, Identity}]& , 
              Charting`ScaledFrameTicks[
               (Charting`getDateTicks[
               Charting`getDateTicks[Automatic, {Automatic}, 
                 (Map[DateList, {
                   SlotSequence[1]}]& )[
                  SlotSequence[1]], None, 5, {{0.0125, 0}, {0.0075, 0}}, 
                 Automatic]& , {Automatic}, 
                (Map[DateList, {
                  SlotSequence[1]}]& )[
                 SlotSequence[1]], None, 5, {{0.0125, 0}, {0.0075, 0}}, 
                None]& )[
                SlotSequence[1]], {Identity, Identity}]& }}, 
           GridLines -> {None, None}, GridLinesStyle -> Directive[
             GrayLevel[0.5, 0.4]], 
           Method -> {"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
                 (Identity[#]& )[
                  Part[#, 1]], 
                 (Identity[#]& )[
                  Part[#, 2]]}& ), "CopiedValueFunction" -> ({
                 (Identity[#]& )[
                  Part[#, 1]], 
                 (Identity[#]& )[
                  Part[#, 2]]}& )}}, 
           PlotRange -> {{-6.3113472*^9, 3.4081344*^9}, {
             0, 0.00013027117460428077`}}, PlotRangeClipping -> True, 
           PlotRangePadding -> {{
              Scaled[0.02], 
              Scaled[0.02]}, {
              Scaled[0.02], 
              Scaled[0.05]}}, Ticks -> {{}, Automatic}}], 
         FormBox[
          FormBox[
           
           TemplateBox[{"\"science\"", "\"technology\""}, "LineLegend", 
            DisplayFunction -> (FormBox[
              StyleBox[
               StyleBox[
                PaneBox[
                 TagBox[
                  GridBox[{{
                    TagBox[
                    GridBox[{{
                    GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.099], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.099], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #}, {
                    GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.099], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.099], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #2}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                    AutoDelete -> False, 
                    GridBoxDividers -> {
                    "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                    GridBoxItemSize -> {
                    "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
                   GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Top}}}, AutoDelete -> 
                   False, GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                   GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
                  "Grid"], Alignment -> Left, AppearanceElements -> None, 
                 ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
                 "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
               FontFamily -> "Arial"}, Background -> Automatic, StripOnInput -> 
               False], TraditionalForm]& ), 
            InterpretationFunction :> (RowBox[{"LineLegend", "[", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"PointSize", "[", "0.0055000000000000005`", "]"}],
                     ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> 
                    RGBColor[0.24561133333333335`, 0.3378526666666667, 
                    0.4731986666666667], FrameTicks -> None, PlotRangePadding -> 
                    None, ImageSize -> 
                    Dynamic[{Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    "RGBColor[0.368417, 0.506779, 0.709798]"], Appearance -> 
                    None, BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.368417, 0.506779, 0.709798]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.368417, 0.506779, 0.709798], Editable -> False,
                     Selectable -> False], ",", 
                    RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
                    ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"PointSize", "[", "0.0055000000000000005`", "]"}],
                     ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> 
                    RGBColor[0.587148, 0.40736066666666665`, 
                    0.09470066666666668], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    "RGBColor[0.880722, 0.611041, 0.142051]"], Appearance -> 
                    None, BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.880722, 0.611041, 0.142051]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.880722, 0.611041, 0.142051], Editable -> False,
                     Selectable -> False], ",", 
                    RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], 
                    "]"}]}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{#, ",", #2}], "}"}], ",", 
                 RowBox[{"LegendMarkers", "\[Rule]", 
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"False", ",", "Automatic"}], "}"}]}], "}"}]}], 
                 ",", 
                 RowBox[{"Joined", "\[Rule]", 
                   RowBox[{"{", 
                    RowBox[{"True", ",", "True"}], "}"}]}], ",", 
                 RowBox[{"LabelStyle", "\[Rule]", 
                   RowBox[{"{", "}"}]}], ",", 
                 RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], 
               "]"}]& ), Editable -> True], TraditionalForm], 
          TraditionalForm]},
        "Legended",
        DisplayFunction->(GridBox[{{
            TagBox[
             ItemBox[
              PaneBox[
               TagBox[#, "SkipImageSizeLevel"], 
               Alignment -> {Center, Baseline}, BaselinePosition -> Baseline],
               DefaultBaseStyle -> "Labeled"], "SkipImageSizeLevel"], 
            ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
          GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}},
           AutoDelete -> False, GridBoxItemSize -> Automatic, 
          BaselinePosition -> {1, 1}]& ),
        Editable->True,
        InterpretationFunction->(RowBox[{"Legended", "[", 
           RowBox[{#, ",", 
             RowBox[{"Placed", "[", 
               RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]], 
       "ExerciseOutput",ExpressionUUID->
       "dceac48e-39a7-4023-9d00-da8ab642c07a"],
      Apply[TextCell, 
       Cell[
        BoxData[
         TemplateBox[{
           GraphicsBox[{{}, {{{}, {}, {
                Hue[0.67, 0.6, 0.6], 
                Directive[
                 PointSize[0.0055000000000000005`], 
                 RGBColor[0.368417, 0.506779, 0.709798], 
                 AbsoluteThickness[1.6]], 
                LineBox[CompressedData["
1:eJw9V3k8lekX1zItlqzhLpa0YKhpKNHCfZJQWbIUWtxEi/JLZUtlVKaplGwt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                 "]]}, {
                Hue[0.9060679774997897, 0.6, 0.6], 
                Directive[
                 PointSize[0.0055000000000000005`], 
                 RGBColor[0.880722, 0.611041, 0.142051], 
                 AbsoluteThickness[1.6]], 
                LineBox[CompressedData["
1:eJw1Vwk4lVsX9ncvMt1LIlRESqU/RSENzmq+pUiRZk1oMEQ0mEnklzkN5iRX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                 
                 "]]}}}, {}, {}, {{}, {}}, {{}, {}}}, {
            DisplayFunction -> Identity, DisplayFunction -> Identity, 
             PlotRangePadding -> {{
                Scaled[0.02], 
                Scaled[0.02]}, {
                Scaled[0.02], 
                Scaled[0.05]}}, AxesOrigin -> {-6.3113472*^9, 0}, 
             PlotRange -> {{-6.3113472*^9, 3.4081344*^9}, {
               0, 0.00013027117460428077`}}, PlotRangeClipping -> True, 
             ImagePadding -> All, DisplayFunction -> Identity, AspectRatio -> 
             NCache[GoldenRatio^(-1), 0.6180339887498948], 
             Axes -> {False, False}, AxesLabel -> {None, None}, 
             AxesOrigin -> {-6.3113472*^9, 0}, DisplayFunction :> Identity, 
             Frame -> {{True, True}, {True, True}}, 
             FrameLabel -> {{None, None}, {None, None}}, 
             FrameTicks -> {{Automatic, Automatic}, {
               Charting`FindScaledTicks[
                 (Charting`getDateTicks[Automatic, {Automatic}, 
                  (Map[DateList, {
                    SlotSequence[1]}]& )[
                   SlotSequence[1]], None, 5, {{0.0125, 0}, {0.0075, 0}}, 
                  Automatic]& )[
                  SlotSequence[1]], {Identity, Identity}]& , 
                Charting`ScaledFrameTicks[
                 (Charting`getDateTicks[
                 Charting`getDateTicks[Automatic, {Automatic}, 
                   (Map[DateList, {
                    SlotSequence[1]}]& )[
                    SlotSequence[1]], None, 5, {{0.0125, 0}, {0.0075, 0}}, 
                   Automatic]& , {Automatic}, 
                  (Map[DateList, {
                    SlotSequence[1]}]& )[
                   SlotSequence[1]], None, 5, {{0.0125, 0}, {0.0075, 0}}, 
                  None]& )[
                  SlotSequence[1]], {Identity, Identity}]& }}, 
             GridLines -> {None, None}, GridLinesStyle -> Directive[
               GrayLevel[0.5, 0.4]], 
             Method -> {"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
                   (Identity[#]& )[
                    Part[#, 1]], 
                   (Identity[#]& )[
                    Part[#, 2]]}& ), "CopiedValueFunction" -> ({
                   (Identity[#]& )[
                    Part[#, 1]], 
                   (Identity[#]& )[
                    Part[#, 2]]}& )}}, 
             PlotRange -> {{-6.3113472*^9, 3.4081344*^9}, {
               0, 0.00013027117460428077`}}, PlotRangeClipping -> True, 
             PlotRangePadding -> {{
                Scaled[0.02], 
                Scaled[0.02]}, {
                Scaled[0.02], 
                Scaled[0.05]}}, Ticks -> {{}, Automatic}}], 
           FormBox[
            FormBox[
             
             TemplateBox[{"\"science\"", "\"technology\""}, "LineLegend", 
              DisplayFunction -> (FormBox[
                StyleBox[
                 StyleBox[
                  PaneBox[
                   TagBox[
                    GridBox[{{
                    TagBox[
                    GridBox[{{
                    GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.099], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.099], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #}, {
                    GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.099], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.099], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #2}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                    AutoDelete -> False, 
                    GridBoxDividers -> {
                    "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                    GridBoxItemSize -> {
                    "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                    GridBoxSpacings -> {
                    "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
                    GridBoxAlignment -> {
                    "Columns" -> {{Left}}, "Rows" -> {{Top}}}, AutoDelete -> 
                    False, GridBoxItemSize -> {
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
                    GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}],
                     "Grid"], Alignment -> Left, AppearanceElements -> None, 
                   ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
                   "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
                 FontFamily -> "Arial"}, Background -> Automatic, 
                 StripOnInput -> False], TraditionalForm]& ), 
              InterpretationFunction :> (RowBox[{"LineLegend", "[", 
                 RowBox[{
                   RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"PointSize", "[", "0.0055000000000000005`", "]"}],
                     ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> 
                    RGBColor[0.24561133333333335`, 0.3378526666666667, 
                    0.4731986666666667], FrameTicks -> None, PlotRangePadding -> 
                    None, ImageSize -> 
                    Dynamic[{Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    "RGBColor[0.368417, 0.506779, 0.709798]"], Appearance -> 
                    None, BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.368417, 0.506779, 0.709798]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.368417, 0.506779, 0.709798], Editable -> False,
                     Selectable -> False], ",", 
                    RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
                    ",", 
                    RowBox[{"Directive", "[", 
                    RowBox[{
                    RowBox[{"PointSize", "[", "0.0055000000000000005`", "]"}],
                     ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> 
                    RGBColor[0.587148, 0.40736066666666665`, 
                    0.09470066666666668], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    "RGBColor[0.880722, 0.611041, 0.142051]"], Appearance -> 
                    None, BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.880722, 0.611041, 0.142051]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.880722, 0.611041, 0.142051], Editable -> False,
                     Selectable -> False], ",", 
                    RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], 
                    "]"}]}], "}"}], ",", 
                   RowBox[{"{", 
                    RowBox[{#, ",", #2}], "}"}], ",", 
                   RowBox[{"LegendMarkers", "\[Rule]", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"False", ",", "Automatic"}], "}"}]}], "}"}]}], 
                   ",", 
                   RowBox[{"Joined", "\[Rule]", 
                    RowBox[{"{", 
                    RowBox[{"True", ",", "True"}], "}"}]}], ",", 
                   RowBox[{"LabelStyle", "\[Rule]", 
                    RowBox[{"{", "}"}]}], ",", 
                   RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], 
                 "]"}]& ), Editable -> True], TraditionalForm], 
            TraditionalForm]}, "Legended", DisplayFunction -> (GridBox[{{
              TagBox[
               ItemBox[
                PaneBox[
                 TagBox[#, "SkipImageSizeLevel"], 
                 Alignment -> {Center, Baseline}, BaselinePosition -> 
                 Baseline], DefaultBaseStyle -> "Labeled"], 
               "SkipImageSizeLevel"], 
              ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
            GridBoxAlignment -> {
             "Columns" -> {{Center}}, "Rows" -> {{Center}}}, AutoDelete -> 
            False, GridBoxItemSize -> Automatic, 
            BaselinePosition -> {1, 1}]& ), Editable -> True, 
          InterpretationFunction -> (RowBox[{"Legended", "[", 
             RowBox[{#, ",", 
               RowBox[{"Placed", "[", 
                 RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]], 
        "ExerciseOutput", Selectable -> False, Copyable -> False, Editable -> 
        False, ShowCellBracket -> False]]], " "}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
   GridBoxBackground->{"Columns" -> {{
        RGBColor[1, 1, 1]}}},
   GridBoxSpacings->{"Columns" -> {{Automatic}}, "Rows" -> {{1}}}],
  FrameMargins->0]], "ExerciseOutput",
 Editable->False,
 Selectable->False,
 Deletable->False,
 CellFrame->{{1, 1}, {1, 1}},
 ShowCellBracket->False,
 CellFrameColor->RGBColor[0.85, 0.85, 0.85],
 LineBreakWithin->
  Automatic,ExpressionUUID->"24025198-f47e-4eda-aac8-99f2ef6f1abf"]
}, Closed]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Q&A", "QASection",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"c6bc8ff6-2522-447f-8c37-e21de4aabfbb"],

Cell["How can I get a date as a string?", "Question",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"1887bf1f-fe1c-4b04-b043-e6790a9886eb"],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["DateString",
    BaseStyle->"CodeLink"], "[", 
   StyleBox["date", "CodeVariable"], "]"}]], "InlineCode",ExpressionUUID->
  "ed81b1f3-a9fc-475d-a03c-e86401b35800"],
 ". There are many options for the format of the string. For example, ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["DateString",
    BaseStyle->"CodeLink"], "[", 
   RowBox[{
    StyleBox["date", "CodeVariable"], ",", "\<\"DateShort\"\>"}], "]"}]], 
  "InlineCode",ExpressionUUID->"ef579dd9-cb01-447d-8430-e8aa2f12c07f"],
 " uses short day and month names."
}], "Answer",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:23",ExpressionUUID->"008404cd-03c0-44a7-ac0a-696c49f34e3b"],

Cell["\<\
How can I extract the month or some other element from a date?\
\>", "Question",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"8aa95f8f-ca26-4e13-a8fe-54d0be2584d6"],

Cell[TextData[{
 "Use ",
 ButtonBox["DateValue",
  BaseStyle->"Link"],
 ". ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["DateValue",
    BaseStyle->"CodeLink"], "[", 
   RowBox[{
    StyleBox["date", "CodeVariable"], ",", "\<\"Month\"\>"}], "]"}]], 
  "InlineCode",ExpressionUUID->"1e536dcd-5696-4d80-b896-df0771295bf3"],
 " gives the month number, ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["DateValue",
    BaseStyle->"CodeLink"], "[", 
   RowBox[{
    StyleBox["date", "CodeVariable"], ",", "\<\"MonthName\"\>"}], "]"}]], 
  "InlineCode",ExpressionUUID->"a5308cee-b677-4eb4-849b-8809ad8bb4b1"],
 " gives the month name, etc."
}], "Answer",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:24",ExpressionUUID->"4cd299f7-760c-48d3-99cf-645fc3f2cff7"],

Cell["How far in the past can dates be in the Wolfram Language?", "Question",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"2bf27e29-4703-451d-a455-5e75b114fa4c"],

Cell["\<\
As far as you want. The Wolfram Language knows about historical calendar \
systems, and the history of time zones. It also has the data to accurately \
compute sunrise, etc. going back at least 1000 years.\
\>", "Answer",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:25",ExpressionUUID->"9f72bf3c-92b5-4118-8e00-62c4975c3ea3"],

Cell["Why are sunrise and sunset given only to the minute?", "Question",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"2bfc27c6-b576-4c13-bc5e-70929fdd1675"],

Cell["\<\
Because you can\[CloseCurlyQuote]t compute more accurately than that exactly \
when the sun will actually rise and set without knowing things like air \
temperature that affect the bending of light in the Earth\[CloseCurlyQuote]s \
atmosphere.\
\>", "Answer",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"5f44c2d2-8ad0-431d-b74f-f1fd5e197f03"],

Cell["\<\
Where does the Wolfram Language get air temperature data from?\
\>", "Question",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"41b55ab8-b790-4fae-8b8c-558213ee36c6"],

Cell[TextData[{
 "The worldwide network of weather stations, located at airports and other \
places. If you\[CloseCurlyQuote]ve got your own air temperature measuring \
device, you can connect it to the Wolfram Language through the ",
 ButtonBox["Wolfram Data Drop",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["https://datadrop.wolframcloud.com/"], None},
  ButtonNote->"https://datadrop.wolframcloud.com/"],
 " (see ",
 ButtonBox["Section 43",
  BaseStyle->"Hyperlink",
  ButtonData->{"EIWL2-43-storing-things.nb", "WolframDataDrop"}],
 ")."
}], "Answer",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"9c96cee7-9c11-4223-9a62-2b28e64ad7cf"],

Cell["What is a time series?", "Question",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"1f50252a-af1b-40db-8185-4b0a8936c711"],

Cell[TextData[{
 "It\[CloseCurlyQuote]s a way of specifying the values of something at a \
series of times. You can enter a time series in the Wolfram Language as ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["TimeSeries",
    BaseStyle->"CodeLink"], "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["time", "CodeVariable"], 
        StyleBox["1",
         FontSlant->"Plain"]], ",", 
       SubscriptBox[
        StyleBox["value", "CodeVariable"], "1"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["time", "CodeVariable"], "2"], ",", 
       SubscriptBox[
        StyleBox["value", "CodeVariable"], "2"]}], "}"}], ",", 
     "\[NegativeThinSpace]", 
     StyleBox["...", "GrayPointSix"]}], "}"}], "]"}]], "InlineCode",
  ExpressionUUID->"8d2609b9-00ce-4fa8-8105-f3d68f1cec75"],
 ". The Wolfram Language lets you do arithmetic and many other operations \
with time series. "
}], "Answer",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:26",ExpressionUUID->"7a3ddbd2-2ed2-45a7-8d93-9f1cca329706"],

Cell[TextData[{
 "What does ",
 ButtonBox["DateListPlot",
  BaseStyle->"Link"],
 " do?"
}], "Question",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"894de397-357b-4181-8b22-3113f31cfbe2"],

Cell[TextData[{
 "It plots values against times or dates. The values can be given in a ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["TimeSeries",
    BaseStyle->"CodeLink"], "[", "\[NegativeThinSpace]", 
   StyleBox["...", "GrayPointSix"], "]"}]], "InlineCode",ExpressionUUID->
  "09a57cf2-30f3-4640-a658-ed5b63bb9ec1"],
 " or in a list of the form ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["time", "CodeVariable"], 
       StyleBox["1",
        FontSlant->"Plain"]], 
      StyleBox[",", "CodeVariable"], 
      SubscriptBox[
       StyleBox["value", "CodeVariable"], "1"]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["time", "CodeVariable"], "2"], ",", 
      SubscriptBox[
       StyleBox["value", "CodeVariable"], "2"]}], "}"}], ",", 
    "\[NegativeThinSpace]", 
    StyleBox["...", "GrayPointSix"]}], "}"}]], "InlineCode",ExpressionUUID->
  "ac90e4e4-bfc5-4729-9d14-389d01cf37dd"],
 ". "
}], "Answer",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->
  "LastCellOfAPage",ExpressionUUID->"2f995462-da30-49a3-b7f2-88771ee1a2c5"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Tech Notes", "TechNoteSection",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"p:106",ExpressionUUID->"85817595-011e-4565-91e8-e30585162152"],

Cell["\<\
The Wolfram Language decides whether to interpret a date like 8/10/15 as \
month/day/year or day/month/year based on what country \
you\[CloseCurlyQuote]re in. You can pick the other interpretation if you want.\
\>", "TechNote",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:27",ExpressionUUID->"9a0bd9b5-a576-448e-8fa6-061e93261bca"],

Cell[TextData[{
 ButtonBox["Monday",
  BaseStyle->"Link"],
 ", etc. are ",
 StyleBox["symbols",
  FontSlant->"Italic"],
 " with intrinsic meaning, not strings."
}], "TechNote",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"90d306a7-8b72-4976-9fcf-2414d4bc0a90"],

Cell[TextData[{
 ButtonBox["DateObject",
  BaseStyle->"Link"],
 " lets you specify the \[OpenCurlyDoubleQuote]granularity\
\[CloseCurlyDoubleQuote] of a date (day, week, month, year, decade, etc.). ",
 ButtonBox["CurrentDate",
  BaseStyle->"Link"],
 ", ",
 ButtonBox["NextDate",
  BaseStyle->"Link"],
 ", ",
 ButtonBox["DateWithinQ",
  BaseStyle->"Link"],
 ", etc. operate on granular dates."
}], "TechNote",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->"i:28",ExpressionUUID->"d9abb382-14cf-4e02-9c91-7b4b0a431750"],

Cell[TextData[{
 "You can see what\[CloseCurlyQuote]s \[OpenCurlyDoubleQuote]inside\
\[CloseCurlyDoubleQuote] ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["DateObject",
    BaseStyle->"CodeLink"], "[", 
   StyleBox["...",
    FontColor->GrayLevel[0.6]], "]"}]], "InlineCode",ExpressionUUID->
  "1f806450-1c9e-4b82-8865-e71172f2ac8c"],
 " using ",
 ButtonBox["InputForm",
  BaseStyle->"Link"],
 "."
}], "TechNote",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"96dd97e4-1a6c-44f3-b594-7033379772a3"]
}, Open  ]],

Cell[CellGroupData[{

Cell["More to Explore", "MoreExploreSection",
 Editable->False,
 Deletable->False,
 ShowCellBracket->
  False,ExpressionUUID->"6b266d92-d97f-4be7-8d91-c81665c65680"],

Cell[TextData[ButtonBox["Guide to Dates & Times in the Wolfram Language\
\[NonBreakingSpace]\[RightGuillemet]",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DateAndTime"]], "MoreExplore",
 Editable->False,
 Deletable->False,
 ShowCellBracket->False,
 CellTags->
  "LastCellOfAPage",ExpressionUUID->"d0f53de7-b841-45eb-aaee-db62786407a3"]
}, Open  ]]
},
Saveable->False,
WindowToolbars->{},
BlinkingCellInsertionPoint->False,
CellInsertionPointCell->None,
WindowSize->{830, 800},
WindowMargins->Automatic,
WindowPersistentStyles->{
 WindowFrame, WindowMargins, WindowSize, Magnification},
WindowTitle->"Dates and Times: Elementary Introduction to the Wolfram \
Language",
DockedCells->{
  Cell[
   BoxData[
    TagBox[
     GridBox[{{
        TemplateBox[{
         "\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]", 
          "\"\[ThickSpace]\[ThickSpace]\[ThickSpace]\[ThickSpace]\"", 
          GraphicsBox[
           TagBox[
            RasterBox[CompressedData["
1:eJztl01IVFEUxyctMFzUysjIyUDCTauiIJFM6ENpM4NEtJrBUaSYZMYPhCRm
rYuoICgiW0VEBVIUEbTNEMTAIqRsk6JGCVFBHx7//+4JLo/36DqvB4Ie+Mk7
7+t3733nHpzq9NlEW0ksFsuX4U8i1duQy6X6kpuRtGTzHe3ZTOuxbFemPZPb
ny7FyZ2gEqwHInICfJToguOIReywPVHHlYDzcY4hJHZ486giyBOXtfms5Pms
Bs9zUBDTow6DJOgBT8DP/+B5CepAPbgqZm+zT70Bt9VXCx6H8DwE28Gw5ufB
IT2eA1N6PKquC0V4xtUxqfkE6ARD4BHYAx5Y938Gu8GdZXq4VsNWngIfwDzY
Aa6Bm55nOKYq8NXRw29eb+Uz4JSVd4Nn4IbPs2fARUdPQcfLWAQJ8Mq6Tkdd
gGcEHHT0sHYn9Jg1dcnnnhf6vnee8xzXVkcP9wdr97eY7z0NnlrX74qpxffg
iOZ2VDp6kvqOe6AVXAb7xNQB462YNfsCfoBzoE1MzTEqHD096mgE98WsEec4
Jqamvvk8cx2kwWuw19HDXnIAbNAx03ka9IO8mO+3ScyebRZTi01i1rqguHjY
r3aJWaugOA5O6vEC+K6ebWDW0cNgv6oBnwKus87KwKDmv8BRMOBz77/6G/sV
e8lkwHWuTwm4pQ7WzGIRHgb7FXsJ9/mI5z2si42gXMw8/ByuHgb7FXsJ9yX3
IPfHFjF1xTl5v0exnrCx5gnn+fu7JC7h/z/0Y52+P+rfWX9iCXVYErg=
             "], {{0,
              34}, {26, 0}}, {0, 255}, ColorFunction -> RGBColor], 
            BoxForm`ImageTag[
            "Byte", ColorSpace -> "RGB", Interleaving -> True, Magnification -> 
             1], Selectable -> False], DefaultBaseStyle -> "ImageGraphics", 
           ImageSize -> Magnification[1], ImageSizeRaw -> {26, 34}, 
           PlotRange -> {{0, 26}, {0, 34}}], 
          GraphicsBox[
           TagBox[
            RasterBox[CompressedData["
1:eJztXUuS47gRLX8WXtYRaJ+gl17SS+8U4/CeM+H2hDdtRY8jHF6ZR9AReATt
qrwyj6AjcO+ZaN0gLZCZwEMiQVJqSd2qwYvgdBGf/AF4+LFqfvvd37/56y+f
np5++M3pP998+88/fPz47b/+9Hx6+fOHH/72/Yf3f/njh3+8//79x99/96tT
4u9Oz79/8fT066cY9NNLSz++9uPz0+uOPv3n3Zj+40vj083npZktd5IVdJzk
hvT9pHOq78uc9I75rD/KA31n6/z03+dY1lRX64jkQh3LLpevbWI7t6N/Esv/
vdSJDpcOdpr5M74lvk/tt6VPL1VG3j7v79Qedr2XLlevoKDgsTHx8Cud+OTA
XDKM7yfOijnmlB+XC9zvuGfMm+HhqfwR8sjLY54ddbJuw05yesL7Sp2qHtY1
4+F8VjZ4Xajf2/q6Gd/HuUDH6OTvZOM21jHZmm0TsTvH/d531WZOn5o3x3lL
Ys22pnFN87Bezs6CgoLHhFsnMqd1IW1cz26TsrO8nOdSX8bgO+CwZlmHzf2L
OoXbYE08y/2e80AXcDGkbVEuzEXbIAvmA9S/kvuz+aIL5yeJHbTlVHbcQwzT
/BDncT5l6xXuLyh4k4C1Xfb8wZe9Bfcrnr0J949r43H9vV9bl2Oyn2w88Te/
Yx0+DxmiOiddiSyDk2/B/cEGFWPm/GkOeDmavo5zQ5wnaYX7CwreJvy61HGb
cc7uy63g/rEMPLEeg/tl7cxrZa/DpStZ2TOfFTo1Vy5yP88Zk02vGzkTic54
prjx/JDuFWJ501nXXCwS/Wev+9m+aN/Bdrk8dUYVZE1zv7n/4vScHQUFBY8L
f2fpz99PP1v8vob71ROV8efSruxYfj9xojujVuf92cfg/mWdPf88yDp9ed0f
8uXMZJIxroP5zN3ar6Tn6cGOsK5efd6f8S1/3n/6Nzrbirl7sj852yFuk87P
Zfzzmr1VQUHBY2M6+x/HPJnnCddY9yOXjevmkz7kqhut+xPZS9zv1/juvnvc
N3STTv5+R8XCsi+2Y+Joyy67fLijxifxXbhf5uzkeyZ/zt/yt0ADzrXs06RH
fJ7uKI7TnXfh/oKCnwvgDiD67u8W5/1JmZuc92vOndbus9wvd+D+TEq+ZQ3v
wpNTebkTMO5S4b4gZ5dp9xlnPp7/cR7F73v0g9/K4v7Ff4c17VEK9xcUvE2M
vJR828dcpc/m3wL3e05fvsPktW/0jY7n02m9PSS6FP+infHvJlyZ+4352p/h
671AWi5wv/+2R/Y5hfsLCt4icKzD2cpe3xmOZS8484nuIm/E/efqpJXfLkIc
hihdvtnP7YvcuYq/Ww1nM7EM/v5I2y5zzCV3vXJeF/YCg7Yx8kv2LMj9MofI
7/YV7i8oeJOY1vhwxh+e5JvPS+5643vGG3H/mTr9efYi9/vf5+qUHebc6O0P
c4M8e+Mc3rzLDWcvF3C/P6fnuSdno5xX+d/Lm7mnKNxfUPDmodeeBZdjXD+P
sYw5v6CgoKCgoKCgoKCgoKCgoKCgoKCgoKCgoKCgoKCgoKCgoKCgoKCgoOBr
BxE9n57aPV/aloLr4dSeFbdr9m/CXlmf60fVPXTdGi5mHLvqS9uyhNz45fTm
9LTu3y9jXcFacHu1/NRXktlmnprzXb8ZcQ19Pxdw3K7WTtcG2+bQ30nf4fQc
7zXX3BIuZhy79kryKhl3Kt1K23J6tVK2OX7Bh69mbFv+FkzgeVpg/r9bL5CZ
Q8v5D8n99+S1jP4W43hm3Zvbfivuz/nN6Y7/b/57dCcdwzX6K/T9VqXfgvuj
MYZpBPPluWPRGr9KdkdfyXz8iDxzLzi+5/Ac+d/PHkfQB7bcT+SpOP/huJ+m
PflDcj/Eu7+NZV7PXbn/nrhWf70X97NMGdM1v+M6b8tp0q+T/+/cCh/ISrsG
h1wLj8Yz9wJN5z3C+x3/3KgyY7/g8XeE8vn/z1dAncnP7Rk3xOsrRof9SHiF
6x/gXc4Zxb6dkvuO4v1oT/G6R/JQhvt3w/mNsmuUAbL3Kk/rF50tlNnyv3tV
VvQk8SWDA0HeJba3UFfi2UIbYb2Dtol9HyBf4thr+1a0/Vbpk3bdUYoWZRP0
M8Nu3dai38ntVLmEs9jHAylAvu6zkT4lC9tI+yKx2yt5jZJh6TO5FmQKz6O/
e7DJv4PPOF6cPh1jHweK+4H2S2yUdnT+yzkz1hkobifpmxsK3HNkeysKYy6q
Z8TA25nJrykdv63hK/ogequZmCFqMtZfZI9nHIsSr0bZvKW0H3nZNMW3W5Cx
4bwOftZcRErG0SqXqROt+4146jEkcPZIv+gytmC/ORpp77hOBfk9hfY5gFxs
syPIGYz2OHL5HeftVLqgUXajjcJrggr6j9drxHWO+0XHEWUs2N5COnG5DduB
aVhfbMW4DqT4SNu30PYt1JUz/IEC9+vYNcr3WsVvzu6aYuA4S//+Xcr9PYUx
Vis5EoOR3wxZDZTRvmjewHg+G/51YFevdam4SnsPYOfR6lOUtiv6LmPK4n4d
I91G6HMFaRi33rBdxwPXN6u5aCa/A3nYBtKndH/BdulADtoXjQUK9/g5H1tD
jo59ZdiD+a68tDPOix3EqTb8dn0SuUivtYntdGU8Ry/FWwPyrfEvfjT8/sw2
Hw25so4R3h0otNWg5EgZbCdp43fqfc96fd80bPZtB3Zu4F307SBN0Km6En/x
p9V1Vfk57u8usB25H9dcYheuBSVGnRH7Z1Wvh3o5WzBN+qbEYfTD0O39Vr7X
/C593rJbxoXo92sh8MXkEMtmpa+DNOl/yTyiYq59ETt7CuM8GrOgbwv1RJ81
12xQptgKunCtKjokFr3hp+wVrDbMxUig98IbitcRWp7E6cD5yE/S18W/41MG
lk0q38nG8St9uNV+UeifjREjgV47VUoO1rHGs6uLY1F4sTbigvviDuo74LgU
e5GTxL4NxecoTS52ZLRTLt4cx1YeyLf6jqCH52iVMWKH8Yx4At4PIFfGS63K
1DO6TP6E2O4hntomwbOqJzIP/C7xrzJxneP+s22nzFwDduCYiPq7jrOSl/hu
2ELWe8bvtdwv7Tpn99wYjOKTszmnf6WsJe5vjTTxD/di0RhBG6C+jFVXRniy
ARsaUnMH6MT5Rfw/qvfV3J+xbUfqPG0uTpSO2zV9Zzafy1jjt13ha2/YJnEU
v/ReCetYPjo+30I7aHsiHieY3/l9y++yj+lJ7Q8pPmPRwHVTEjsrzcqnM877
oU6vn5xeupz75dHr/npGV44/8cynA1lZu1V935/Fzpm43or7W5U+GDJ1H/sa
ud/a22q7H5n7BVZfrjL6JCbST/H8we/dDJ1Nzn8rHksxUmm4Lu4hJkvcr+Px
2dxP8ZnPTrfDgq89pAknu7EjXHtYqBP5SBPvH0BOS2EsYhwkrYc4bpRM5H55
RE8H9Vt+pC9k19or4ymoM/lWPMWfjVXH0kvruL/D94zcc7jf2WmdidUzNmXj
BeWlzc2zAlW2hbQk1mfYvsRDuEeMzkUgrp1RJvGdwt5X1iXCI7iX9z5k7OlU
uo69xZ9ipz6vQBuX+BrP2a39eGPo6zKyTF0Z2zXXJby8BKjjoM9PPf/O2a9t
ps/n/tbQoeXdnPspvneQ9brm47Xc731iO7cUjzWpg/OBnKVpXdhOms/ceHHj
WOb/PcVj34/1mZhIu+tvNyIOtmK3Nt6kznwonK/WUEbSJHbjOSyFfdhGyzXi
jW2gY4W6XPmN2GXUqWd04fjvKb3LOpD6bmRNvCjufw7VTFw/l/u17Tnuxz1h
C+W8Hoq/F9zN+C79aU9qH2vE/8i6OoL7UiXb6ZL92pxNObvP5n6ly/nTqnrO
1i3F34HUGTlbKOPHLa3jfvFP4iRjpJmxG2Ng3YNondhXdhS+sSEK/QbHQqPr
WXGbsWlHcDdqlJmLx2rup5iHWq6LY8/Jxn7W5nSQ3YfEhx2F71twnYAxi3y2
dFE6XqSM9IGBfxZdlWGLq79hfXKXKWN7MGIl/nczbZekZeKtgbGaW3MIjmTw
HLwvcr+KF8IaB/Wcj6S+veI0HO/OXpnL+zlZSq7Umf3Gmi7k/hnbTe43/CKr
HKXfkUkc0fdWyfD9GcrgXhfL1Zxfq7x2xnfLbuvs2rLRp62IR2XEQNDMyHG+
JvdCtIL7M3aMZxUz+qJ5PCNno+pY40XfCUXjl87jfjzzIYI7OChzbe7XaJVM
iWVuLb523a8x3skauhyk76CPOA4GsvsFzhsI/J0NXebA6RWpeQnkRnn8c63K
JGlWvvHgPOj0bLUNbJ9LT85+tF7LD8r8XRQu2/Cj71yljt6jJT7SNJYaZccG
5Ro2ZeNFExdI+2bPe5S/FaTVa2ynMOd72y15hj6JWa6MtJfpO5RpQW8utjWX
S3RBf9lQ/O1E5PuS3RT+Fo3ui+Z4UHU3FL5bxnhLDLJxMmwQ+2ScJf3W6pfK
v+z5qOGvtrmy0g0dpk96/KIeVS7X1lK/Ql8N+7LxyOm09BsPyh3HhZJZqXe0
zepDbgwPFP4+hoxpUnWlD1VaF8j2bavjQGHe6Sic0yfraCi7pRV9suC+4H4g
87w/4ygoKHgcUNhb4f2YnMsTLawpztTVa5kUzhH7a+kpuC0o3vc2X9qegoKC
80Hp78Phmr+7si48q5O9hqwdrzbHFNwWFL61rr60LQUFBZeDwt9N7Sl8O1nf
SFdD4XuijtQ3RXP4P6lulfg=
             "], {{0, 34}, {383, 0}}, {0, 255}, 
             ColorFunction -> RGBColor], 
            BoxForm`ImageTag[
            "Byte", ColorSpace -> "RGB", Interleaving -> True, Magnification -> 
             1], Selectable -> False], DefaultBaseStyle -> "ImageGraphics", 
           ImageSize -> Magnification[1], ImageSizeRaw -> {383, 34}, 
           PlotRange -> {{0, 383}, {0, 34}}]}, "RowWithSeparators"], 
        PaneBox[
         StyleBox["\[VeryThinSpace]", ShowStringCharacters -> False], 
         Alignment -> Right, ImageSize -> {174, 47}], 
        PaneBox[
         PaneBox[
          TemplateBox[{"\[ThinSpace]", "\" \"", 
            TagBox[
             TooltipBox[
              PaneSelectorBox[{False -> ButtonBox[
                  PaneBox[
                   GraphicsBox[
                    TagBox[
                    RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UJAPiDmBmIUBO/j//z8jEDcA8W8g3oBFnhmIZ/9HgE9o8mxAvBZJ/hsQuyPJ
8wPxfiT5N0BsjiQvCsTnkOSfALEWkrwSEN9Bkr8OxDJobniAJP8ZZCYWfxCj
RpGQXcS4mVi/ExuGxMYFmlp4nAIAG14fWQ==
                    "], {{0, 14}, {9, 
                    0}}, {0, 255}, ColorFunction -> RGBColor], 
                    BoxForm`ImageTag[
                    "Byte", ColorSpace -> "RGB", Interleaving -> True], 
                    Selectable -> False], DefaultBaseStyle -> "ImageGraphics",
                     ImageSizeRaw -> {9, 14}, PlotRange -> {{0, 9}, {0, 14}}, 
                    ImageSize -> Magnification[1]], ImageSize -> {35, 30}, 
                   Alignment -> Center], 
                  ButtonFunction :> (
                   NotebookLocate[{"EIWL2-18-geocomputation.nb", ""}, 
                    FrontEnd`HistoryData :> {
                    EvaluationNotebook[]}]& ), Enabled -> True, Appearance -> 
                  None, Evaluator -> Automatic, Method -> "Preemptive"], True -> 
                ButtonBox[
                  PaneBox[
                   GraphicsBox[
                    TagBox[
                    RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UJAPiDmBmIUBO/j//z8jEDcA8W8g3oBFnhmIZ/9HgE9o8mxAvBZJ/hsQuyPJ
8wPxfiT5N0BsjiQvCsTnkOSfALEWkrwSEN9Bkr8OxDJobniAJP8ZZCYWfxCj
RpGQXcS4mVi/ExuGxMYFmlp4nAIAG14fWQ==
                    "], {{0, 14}, {9, 
                    0}}, {0, 255}, ColorFunction -> RGBColor], 
                    BoxForm`ImageTag[
                    "Byte", ColorSpace -> "RGB", Interleaving -> True], 
                    Selectable -> False], DefaultBaseStyle -> "ImageGraphics",
                     ImageSizeRaw -> {9, 14}, PlotRange -> {{0, 9}, {0, 14}}, 
                    ImageSize -> Magnification[1]], ImageSize -> {35, 30}, 
                   Alignment -> Center], 
                  ButtonFunction :> (
                   NotebookLocate[{"EIWL2-18-geocomputation.nb", ""}, 
                    FrontEnd`HistoryData :> {
                    EvaluationNotebook[]}]& ), Enabled -> True, Appearance -> 
                  None, Background -> RGBColor[0.835294, 0.364706, 0.0196078],
                   Evaluator -> Automatic, Method -> "Preemptive"]}, 
               Dynamic[
                CurrentValue["MouseOver"]], ImageSize -> Automatic, 
               FrameMargins -> 0], "\"Geocomputation\"", TooltipDelay -> 0.15,
               LabelStyle -> "TextStyling"], 
             Annotation[#, "Geocomputation", "Tooltip"]& ], 
            InterpretationBox[
             StyleBox[
              
              GraphicsBox[{}, ImageSize -> {5, 0}, BaselinePosition -> 
               Baseline], "CacheGraphics" -> False], 
             Spacer[5], Selectable -> False], 
            TagBox[
             TooltipBox[
              PaneSelectorBox[{False -> ButtonBox[
                  PaneBox[
                   GraphicsBox[
                    TagBox[
                    RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UJAfiDmBmAWI////vwKIfwFxMQMOAJT7+R8B6nGoSf+PCjpwqMskUl0SEP9F
UtcHxIxY1EWjqZuOQ10Mmr2TcNj7BEnNP1LNIeQeIDsZn78IhQ8x4fwfNb4a
cPgTFu8l2ORBAAC+1hnm
                    "], {{0, 15}, {9, 0}}, {0, 255}, 
                    ColorFunction -> RGBColor], 
                    BoxForm`ImageTag[
                    "Byte", ColorSpace -> "RGB", Interleaving -> True], 
                    Selectable -> False], DefaultBaseStyle -> "ImageGraphics",
                     ImageSizeRaw -> {9, 15}, PlotRange -> {{0, 9}, {0, 15}}, 
                    ImageSize -> Magnification[1]], ImageSize -> {35, 30}, 
                   Alignment -> Center], 
                  ButtonFunction :> (
                   NotebookLocate[{"EIWL2-20-options.nb", ""}, 
                    FrontEnd`HistoryData :> {
                    EvaluationNotebook[]}]& ), Appearance -> None, Evaluator -> 
                  Automatic, Method -> "Preemptive"], True -> ButtonBox[
                  PaneBox[
                   GraphicsBox[
                    TagBox[
                    RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UJAfiDmBmAWI////vwKIfwFxMQMOAJT7+R8B6nGoSf+PCjpwqMskUl0SEP9F
UtcHxIxY1EWjqZuOQ10Mmr2TcNj7BEnNP1LNIeQeIDsZn78IhQ8x4fwfNb4a
cPgTFu8l2ORBAAC+1hnm
                    "], {{0, 15}, {9, 0}}, {0, 255}, 
                    ColorFunction -> RGBColor], 
                    BoxForm`ImageTag[
                    "Byte", ColorSpace -> "RGB", Interleaving -> True], 
                    Selectable -> False], DefaultBaseStyle -> "ImageGraphics",
                     ImageSizeRaw -> {9, 15}, PlotRange -> {{0, 9}, {0, 15}}, 
                    ImageSize -> Magnification[1]], ImageSize -> {35, 30}, 
                   Alignment -> Center], 
                  ButtonFunction :> (
                   NotebookLocate[{"EIWL2-20-options.nb", ""}, 
                    FrontEnd`HistoryData :> {
                    EvaluationNotebook[]}]& ), Appearance -> None, Background -> 
                  RGBColor[0.835294, 0.364706, 0.0196078], Evaluator -> 
                  Automatic, Method -> "Preemptive"]}, 
               Dynamic[
                CurrentValue["MouseOver"]], ImageSize -> Automatic, 
               FrameMargins -> 0], "\"Options\"", TooltipDelay -> 0.15, 
              LabelStyle -> "TextStyling"], 
             Annotation[#, "Options", "Tooltip"]& ]}, "RowWithSeparators"], 
          Alignment -> Right], ImageSize -> {100, 30}, 
         FrameMargins -> {{0, 6}, {0, 0}}, Alignment -> Right], 
        ActionMenuBox[
         PaneSelectorBox[{True -> PanelBox[
             GraphicsBox[
              TagBox[
               RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UBAkIQ3ELED8////Jf/pA0D2/KWTXSB7ZtPBPrA9DKOAYgAMR1Eg9gPiABpi
P6g912mcLmAAZM9XOtkFsicKiNcD8QYaYpD5UQOdXoYD+E/HMooO9iDbR7c6
BQDxtyEt
                "], {{0, 16}, {27, 0}}, {0, 255}, ColorFunction -> 
                RGBColor], 
               BoxForm`ImageTag[
               "Byte", ColorSpace -> "RGB", Interleaving -> True, 
                Magnification -> 1], Selectable -> False], DefaultBaseStyle -> 
              "ImageGraphics", ImageSize -> Magnification[1], 
              ImageSizeRaw -> {27, 16}, PlotRange -> {{0, 27}, {0, 16}}], 
             Appearance -> None, Background -> 
             RGBColor[0.835294, 0.364706, 0.0196078], ImageSize -> {35, 30}, 
             Alignment -> Center], False -> PanelBox[
             GraphicsBox[
              TagBox[
               RasterBox[CompressedData["
1:eJxTTMoPSmNiYGAo5gASQYnljkVFiZXBAkBOaF5xZnpeaopnXklqemqRRRIz
UBAkIQ3ELED8////Jf/pA0D2/KWTXSB7ZtPBPrA9DKOAYgAMR1Eg9gPiABpi
P6g912mcLmAAZM9XOtkFsicKiNcD8QYaYpD5UQOdXoYD+E/HMooO9iDbR7c6
BQDxtyEt
                "], {{0, 16}, {27, 0}}, {0, 255}, ColorFunction -> 
                RGBColor], 
               BoxForm`ImageTag[
               "Byte", ColorSpace -> "RGB", Interleaving -> True, 
                Magnification -> 1], Selectable -> False], DefaultBaseStyle -> 
              "ImageGraphics", ImageSize -> Magnification[1], 
              ImageSizeRaw -> {27, 16}, PlotRange -> {{0, 27}, {0, 16}}], 
             Appearance -> None, Background -> 
             RGBColor[0.952941, 0.509804, 0], ImageSize -> {35, 30}, 
             Alignment -> Center]}, 
          Dynamic[
           CurrentValue["MouseOver"]]], {
         "Preface" :> 
          NotebookLocate[{"EIWL2-0a-preface.nb", ""}, FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], "What Is the Wolfram Language?" :> 
          NotebookLocate[{"EIWL2-0b-what-is-the-wolfram-language.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "Practicalities of Using the Wolfram Language" :> 
          NotebookLocate[{
            "EIWL2-0c-practicalities-of-using-the-wolfram-language.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], "Other Resources" :> 
          NotebookLocate[{"EIWL2-0d-other-resources.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]1\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]Starting Out: Elementary Arithmetic" :> 
          NotebookLocate[{
            "EIWL2-01-starting-out-elementary-arithmetic.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]2\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]Introducing Functions" :> 
          NotebookLocate[{"EIWL2-02-introducing-functions.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]3\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]First Look at Lists" :> 
          NotebookLocate[{"EIWL2-03-first-look-at-lists.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]4\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]Displaying Lists" :> 
          NotebookLocate[{"EIWL2-04-displaying-lists.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]5\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]Operations on Lists" :> 
          NotebookLocate[{"EIWL2-05-operations-on-lists.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]6\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]Making Tables" :> 
          NotebookLocate[{"EIWL2-06-making-tables.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]7\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]Colors and Styles" :> 
          NotebookLocate[{"EIWL2-07-colors-and-styles.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]8\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]Basic Graphics Objects" :> 
          NotebookLocate[{"EIWL2-08-basic-graphics-objects.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "\[ThickSpace]\[ThickSpace]\[ThinSpace]9\[ThickSpace]\[ThickSpace]|\
\[ThickSpace]\[ThickSpace]Interactive Manipulation" :> 
          NotebookLocate[{"EIWL2-09-interactive-manipulation.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "10\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Images" :> 
          NotebookLocate[{"EIWL2-10-images.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "11\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Strings and \
Text" :> NotebookLocate[{"EIWL2-11-strings-and-text.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "12\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Sound" :> 
          NotebookLocate[{"EIWL2-12-sound.nb", ""}, FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "13\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Arrays, or \
Lists of Lists" :> 
          NotebookLocate[{"EIWL2-13-arrays-or-lists-of-lists.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "14\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Coordinates \
and Graphics" :> 
          NotebookLocate[{"EIWL2-14-coordinates-and-graphics.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "15\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]The Scope \
of the Wolfram Language" :> 
          NotebookLocate[{
            "EIWL2-15-the-scope-of-the-wolfram-language.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "16\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Real\
\[Hyphen]World Data" :> 
          NotebookLocate[{"EIWL2-16-real-world-data.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "17\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Units" :> 
          NotebookLocate[{"EIWL2-17-units.nb", ""}, FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "18\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
Geocomputation" :> 
          NotebookLocate[{"EIWL2-18-geocomputation.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "19\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Dates and \
Times" :> NotebookLocate[{"EIWL2-19-dates-and-times.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "20\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Options" :> 
          NotebookLocate[{"EIWL2-20-options.nb", ""}, FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "21\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Graphs and \
Networks" :> 
          NotebookLocate[{"EIWL2-21-graphs-and-networks.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          
          "22\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Machine \
Learning" :> 
          NotebookLocate[{"EIWL2-22-machine-learning.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "23\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]More about \
Numbers" :> NotebookLocate[{"EIWL2-23-more-about-numbers.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "24\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]More Forms \
of Visualization" :> 
          NotebookLocate[{"EIWL2-24-more-forms-of-visualization.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "25\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Ways to \
Apply Functions" :> 
          NotebookLocate[{"EIWL2-25-ways-to-apply-functions.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "26\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Pure \
Anonymous Functions" :> 
          NotebookLocate[{"EIWL2-26-pure-anonymous-functions.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "27\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Applying \
Functions Repeatedly" :> 
          NotebookLocate[{"EIWL2-27-applying-functions-repeatedly.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "28\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Tests and \
Conditionals" :> 
          NotebookLocate[{"EIWL2-28-tests-and-conditionals.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "29\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]More about \
Pure Functions" :> 
          NotebookLocate[{"EIWL2-29-more-about-pure-functions.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "30\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Rearranging \
Lists" :> NotebookLocate[{"EIWL2-30-rearranging-lists.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          
          "31\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Parts of \
Lists" :> NotebookLocate[{"EIWL2-31-parts-of-lists.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "32\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Patterns" :> 
          NotebookLocate[{"EIWL2-32-patterns.nb", ""}, FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "33\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Expressions \
and Their Structure" :> 
          NotebookLocate[{"EIWL2-33-expressions-and-their-structure.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "34\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
Associations" :> 
          NotebookLocate[{"EIWL2-34-associations.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "35\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Natural \
Language Understanding" :> 
          NotebookLocate[{"EIWL2-35-natural-language-understanding.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "36\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Creating \
Websites and Apps" :> 
          NotebookLocate[{"EIWL2-36-creating-websites-and-apps.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "37\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Layout and \
Display" :> NotebookLocate[{"EIWL2-37-layout-and-display.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "38\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Assigning \
Names to Things" :> 
          NotebookLocate[{"EIWL2-38-assigning-names-to-things.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "39\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Immediate \
and Delayed Values" :> 
          NotebookLocate[{"EIWL2-39-immediate-and-delayed-values.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "40\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Defining \
Your Own Functions" :> 
          NotebookLocate[{"EIWL2-40-defining-your-own-functions.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "41\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]More about \
Patterns" :> 
          NotebookLocate[{"EIWL2-41-more-about-patterns.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "42\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]String \
Patterns and Templates " :> 
          NotebookLocate[{"EIWL2-42-string-patterns-and-templates.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "43\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Storing \
Things" :> NotebookLocate[{"EIWL2-43-storing-things.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "44\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Importing \
and Exporting" :> 
          NotebookLocate[{"EIWL2-44-importing-and-exporting.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "45\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Datasets" :> 
          NotebookLocate[{"EIWL2-45-datasets.nb", ""}, FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "46\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Writing \
Good Code" :> 
          NotebookLocate[{"EIWL2-46-writing-good-code.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "47\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]Debugging \
Your Code" :> 
          NotebookLocate[{"EIWL2-47-debugging-your-code.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], 
          "What We Haven\[CloseCurlyQuote]t Discussed" :> 
          NotebookLocate[{"EIWL2-what-we-havent-discussed.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], "Afterword: Being a Programmer" :> 
          NotebookLocate[{"EIWL2-being-a-programmer.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], "Answers to Exercises" :> 
          NotebookLocate[{"EIWL2-answers-to-exercises.nb", ""}, 
            FrontEnd`HistoryData :> {
              EvaluationNotebook[]}], "Index" :> 
          NotebookLocate[{"EIWL2-book-index.nb", ""}, FrontEnd`HistoryData :> {
              EvaluationNotebook[]}]}, Appearance -> None]}}, 
      GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Center}}}, 
      GridBoxItemSize -> {
       "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}], "Grid"]], 
   "Text", ShowCellBracket -> False, CellFrame -> {{0, 0}, {3, 0}}, 
   Selectable -> False, CellFrameColor -> 
   RGBColor[0.835294, 0.364706, 0.0196078], CellMargins -> {{0, 0}, {0, -1}}, 
   CellFrameMargins -> {{27, 0}, {1, 7}}, Background -> 
   RGBColor[0.952941, 0.509804, 0], CellTags -> "DockedCellLogoCell"], 
  Cell["SECOND EDITION", "Text", FontFamily -> "Source Sans Pro", 
   CellFrame -> {{0, 0}, {3, 0}}, ShowCellBracket -> False, 
   CellMargins -> {{0, 0}, {-1, -1}}, CellFrameMargins -> {{66, 0}, {2, 4}}, 
   CellFrameColor -> RGBColor[0.952941, 0.509804, 0], FontSize -> 10, 
   FontTracking -> "Extended", FontColor -> RGBColor[1, 0.929412, 0.721569], 
   Background -> RGBColor[0.862745, 0.309804, 0], CellTags -> 
   "DockedCellLogoCell"]},
PrintingStartingPageNumber->150,
PageHeaders->{{
   Cell[
    TextData[{
      StyleBox[
       CounterBox["Page"], "PageNumber"], 
      StyleBox[
      "    An Elementary Introduction to the Wolfram Language", "Header"]}], 
    "Header", CellMargins -> {{37, Inherited}, {Inherited, Inherited}}], None,
    None}, {None, None, 
   Cell[
    TextData[{
      StyleBox[
       CounterBox["Section"], "Header"], 
      StyleBox[" | Dates and Times \[LongDash] wolfr.am/eiwl-", "Header"], 
      StyleBox[
       CounterBox["Section"], "Header"], 
      StyleBox["    ", "Header"], 
      StyleBox[
       CounterBox["Page"], "PageNumber"]}], "Header", 
    CellMargins -> {{Inherited, 17}, {Inherited, Inherited}}]}},
PrintingOptions->{"FirstPageHeader"->True},
PrivateNotebookOptions->{"PluginToolbarEnabled"->False},
ShowCellBracket->Automatic,
ShowAutoSpellCheck->False,
ShowPredictiveInterface->False,
ShowSyntaxStyles->False,
Magnification->1.,
FrontEndVersion->"12.3 for Mac OS X x86 (64-bit) (July 30, 2021)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[StyleDefinitions -> "Default.nb"]], 
   Cell[
    CellGroupData[{
      Cell[
      "Style Environments", "Section", 
       CellChangeTimes -> {{3.64661165091824*^9, 3.646611654013329*^9}, 
         3.6485723794335403`*^9, 3.651347081728628*^9, 3.651347179462186*^9, 
         3.651347384135805*^9, 3.651348171662589*^9}], 
      Cell[
       StyleData[All, "Working"], CellInsertionPointCell -> 
       FEPrivate`FrontEndResource["FEExpressions", "CellInsertionMenu"], 
       CreateCellID -> True, $CellContext`GhostCellInEmptyNotebook -> False], 
      
      Cell[
       StyleData[All, "Printout"], 
       PrintingOptions -> {
        "PageSize" -> {504, 720}, "PrintRegistrationMarks" -> True}, 
       Magnification -> 0.6]}, Closed]], 
   Cell[
    CellGroupData[{
      Cell["Styles for Headers and Footers", "Section"], 
      Cell[
       StyleData["Header"], StyleMenuListing -> None, FontFamily -> "Verdana",
        FontSize -> 7, FontSlant -> "Plain", FontColor -> GrayLevel[0.6]], 
      Cell[
       StyleData["PageNumber"], CellMargins -> {{0, 0}, {4, 1}}, 
       StyleMenuListing -> None, FontFamily -> "Verdana", FontSize -> 7, 
       FontWeight -> "Bold", FontSlant -> "Plain", FontColor -> 
       GrayLevel[0]]}, Closed]], 
   Cell[
    CellGroupData[{
      Cell[
      "WPL Specific", "Section", 
       CellChangeTimes -> {{3.6556608433734913`*^9, 3.6556608489412746`*^9}}], 
      Cell[
       StyleData["Link"], FontFamily -> "Source Sans Pro", FontSize :> 
       If[CurrentValue[
           EvaluationCell[], "FontFamily"] === "Source Sans Pro", Inherited, 
         If[CurrentValue[
            EvaluationCell[], "FontFamily"] === "WolframCodeSans", Inherited, 
          Inherited 0.9]], FontColor -> GrayLevel[0]], 
      Cell[
       StyleData["CodeLink"], 
       ButtonBoxOptions -> {
        Appearance -> None, ButtonFunction :> (FEPrivate`FrontEndExecute[
           FrontEndToken["OpenHelpLink", {
             Part[#, 1], Null}]]& ), ButtonSource -> ButtonContents, 
         Evaluator -> None, Method -> "Preemptive"}]}, Closed]], 
   Cell[
    CellGroupData[{
      Cell[
      "Custom Styles", "Section", 
       CellChangeTimes -> {{3.646611660445352*^9, 3.646611669493331*^9}}], 
      Cell[
       StyleData["Notebook"], PageWidth :> 700, 
       PrintingOptions -> {
        "InnerOuterMargins" -> {35, 16}, "PaperOrientation" -> "Portrait", 
         "PaperSize" -> {504, 720}, 
         "PrintingMargins" -> {{20, 20}, {54, 54}}}, CellLabelAutoDelete -> 
       False, ShowSyntaxStyles -> True, 
       AutoStyleOptions -> {
        "FormattingErrorTooltips" -> False, "HighlightComments" -> False, 
         "HighlightEmphasizedSyntaxErrors" -> False, 
         "HighlightExcessArguments" -> False, "HighlightFormattingErrors" -> 
         False, "HighlightGlobalToLocalScopeConflicts" -> False, 
         "HighlightGraphicsCompatibilityProblems" -> False, 
         "HighlightLocalScopeConflicts" -> False, "HighlightMissingArguments" -> 
         False, "HighlightNoKernelPresent" -> False, 
         "HighlightOrderOfEvaluationConflicts" -> False, "HighlightStrings" -> 
         True, "HighlightSymbolContexts" -> False, "HighlightSymbolShadowing" -> 
         False, "HighlightSyntaxErrors" -> False, "HighlightUndefinedSymbols" -> 
         False, "HighlightUnknownOptions" -> False, 
         "HighlightUnwantedAssignments" -> False}, MenuSortingValue -> None, 
       GraphicsBoxOptions -> {ImageSize -> 240}, 
       Graphics3DBoxOptions -> {ImageSize -> 240}], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Title"], CellMargins -> {{64, Inherited}, {50, 72}}, 
          MenuCommandKey :> None, FontFamily -> "Verdana", FontSize -> 42, 
          FontWeight -> "Bold", FontColor -> GrayLevel[0.4]], 
         Cell[
          StyleData["Title", "Printout"], 
          CellMargins -> {{64, Inherited}, {50, 72}}]}, Closed]], 
      Cell[
       StyleData["Chapter"], MenuCommandKey :> None], 
      Cell[
       StyleData["Subchapter"], MenuCommandKey :> None], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Section"], CellFrame -> {{0, 0}, {0, 0}}, CellDingbat -> 
          Cell[
            TextData[
             CounterBox["Section"], 
             StyleBox[
             "|\[NegativeThinSpace]", FontColor -> 
              RGBColor[
               0.9019607843137255, 0.4117647058823529, 0.027450980392156862`],
               FontFamily -> "Courier", FontSize -> 36, FontWeight -> Plain]],
             "SectionNumber"], CellMargins -> {{96, Inherited}, {12, 44}}, 
          Evaluatable -> True, CellGroupingRules -> {"SectionGrouping", 60}, 
          PageBreakAbove -> True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["Section", "Printout"], 
          CellMargins -> {{96, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionDoubleDigit"], CellFrame -> {{0, 0}, {0, 0}}, 
          CellDingbat -> Cell[
            TextData[
             CounterBox["Section"], 
             StyleBox[
             "|\[NegativeThinSpace]", FontColor -> 
              RGBColor[
               0.9019607843137255, 0.4117647058823529, 0.027450980392156862`],
               FontFamily -> "Courier", FontSize -> 36, FontWeight -> Plain]],
             "SectionNumber"], CellMargins -> {{112, Inherited}, {12, 44}}, 
          Evaluatable -> True, CellGroupingRules -> {"SectionGrouping", 60}, 
          PageBreakAbove -> True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["SectionDoubleDigit", "Printout"], 
          CellMargins -> {{112, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionNumber"], CellBaseline -> Baseline, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 26, FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SectionNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionInline"], FontFamily -> 
          "Source Sans Pro Semibold", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["SectionInline", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["SectionNoDingbat"], 
          CellMargins -> {{64, Inherited}, {12, 44}}, Evaluatable -> True, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakAbove -> 
          True, ShowCellLabel -> False, 
          CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
          CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
          CounterIncrements -> "Section", 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", 
          FontSize -> 26, FontSlant -> "Plain", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          InterpretationBoxOptions -> {Editable -> True}], 
         Cell[
          StyleData["SectionNoDingbat", "Printout"], 
          CellMargins -> {{64, Inherited}, {12, 2}}]}, Closed]], 
      Cell[
       StyleData["AnswerKeyNumberedSection"], 
       CellMargins -> {{64, Inherited}, {8, 28}}, Evaluatable -> True, 
       CellGroupingRules -> {"SectionGrouping", 60}, PageBreakAbove -> True, 
       ShowCellLabel -> False, 
       CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
       CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
       CounterIncrements -> "Section", 
       CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
         "Exercise", 0}}, FontFamily -> "Source Sans Pro Semibold", FontSize -> 
       18, FontSlant -> "Plain", FontColor -> 
       RGBColor[
        0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
       InterpretationBoxOptions -> {Editable -> True}], 
      Cell[
       StyleData["AnswerKeySectionNumber"], CellBaseline -> Baseline, 
       FontFamily -> "Source Sans Pro Semibold", FontSize -> 18, FontColor -> 
       RGBColor[
        0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
      Cell[
       StyleData["IndexLinkGuide"], 
       CellMargins -> {{64, Inherited}, {48, 28}}, Evaluatable -> True, 
       CellGroupingRules -> {"SectionGrouping", 60}, PageBreakAbove -> True, 
       ShowCellLabel -> False, 
       CellFrameLabelMargins -> {{2, Inherited}, {Inherited, Inherited}}, 
       CellChangeTimes -> {3.652728456208679*^9, 3.652728527108994*^9}, 
       CounterIncrements -> "Section", 
       CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
         "Exercise", 0}}, FontFamily -> "Source Sans Pro", FontSize -> 14, 
       FontSlant -> "Plain", FontColor -> 
       RGBColor[
        0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
       InterpretationBoxOptions -> {Editable -> True}], 
      Cell[
       StyleData["Index"], MenuSortingValue -> 10000, FontFamily -> 
       "Source Sans Pro", FontSize -> 11], 
      Cell[
       StyleData["IndexSubentry"], MenuSortingValue -> 10000, FontFamily -> 
       "Source Sans Pro", FontSize -> 11], 
      Cell[
       StyleData["FunctionName"], MenuSortingValue -> 10000, FontFamily -> 
       "Source Sans Pro Semibold", FontWeight -> "Bold"], 
      Cell[
       StyleData["IndexColumn"], 
       CellMargins -> {{66, 0}, {Inherited, Inherited}}, TabSpacings -> {2.}, 
       MenuSortingValue -> 10000, FontFamily -> "Source Sans Pro", 
       GridBoxOptions -> {
        GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
         GridBoxItemSize -> {"Columns" -> {{25}}}, 
         GridBoxSpacings -> {"Columns" -> {{2}}}}], 
      Cell[
       StyleData["IndexSubsection"], 
       CellMargins -> {{64, Inherited}, {9, 28}}, 
       CellGroupingRules -> {"SectionGrouping", 40}, MenuSortingValue -> 
       10000, FontFamily -> "Source Sans Pro", FontSize -> 24], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Subsection"], CellMargins -> {{64, Inherited}, {12, 32}},
           FontFamily -> "Source Sans Pro Semibold", FontSize -> 18, 
          FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["Subsection", "Printout"], 
          CellMargins -> {{64, Inherited}, {12, 32}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ResourcesSubsection"], 
          CellMargins -> {{64, Inherited}, {4, 16}}, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 15, FontSlant -> "Plain", 
          FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["ResourcesSubsection", "Printout"], 
          CellMargins -> {{64, Inherited}, {4, 16}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Subsubsection"], 
          CellMargins -> {{64, Inherited}, {6, 12}}, FontFamily -> 
          "Source Sans Pro Semibold", FontSize -> 16, FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
         Cell[
          StyleData["Subsubsection", "Printout"], 
          CellMargins -> {{64, Inherited}, {6, 12}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularySection"], PageWidth :> 700, 
          CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 24}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 18, FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["VocabularySection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 24}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularyTable", StyleDefinitions -> StyleData["Text"]],
           SpanMaxSize -> 1, FontFamily -> "Source Sans Pro Light", FontColor -> 
          GrayLevel[0.8], 
          GridBoxOptions -> {
           GridBoxAlignment -> {"Columns" -> {{Left}}}, 
            GridBoxDividers -> {"Columns" -> {{False}}, "Rows" -> {False, {
                 Directive[
                  Thickness[0.5], "VocabDivColor"]}, False}}, 
            GridBoxItemStyle -> {
             "Columns" -> {"VocabularyCode", Inherited, Inherited}, 
              "Rows" -> {{Automatic}}}, 
            GridBoxSpacings -> {
             "Columns" -> {{0, 1, 2, 1, 2}}, "Rows" -> {{1}}}}], 
         Cell[
          StyleData["VocabularyTable", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "VocabularyTable3Column", StyleDefinitions -> StyleData["Text"]], 
          SpanMaxSize -> 1, FontFamily -> "Source Sans Pro Light", FontColor -> 
          GrayLevel[0.8], 
          GridBoxOptions -> {
           GridBoxAlignment -> {"Columns" -> {{Left}}}, 
            GridBoxDividers -> {"Columns" -> {{False}}, "Rows" -> {False, {
                 Directive[
                  Thickness[0.5], "VocabDivColor"]}, False}}, 
            GridBoxItemStyle -> {
             "Columns" -> {
               "VocabularyCode", Inherited, "VocabularyCode", Inherited, 
                Inherited}, "Rows" -> {{Automatic}}}, 
            GridBoxSpacings -> {
             "Columns" -> {{0, 1, 2, 1, 2}}, "Rows" -> {{1}}}}], 
         Cell[
          StyleData["VocabularyTable3Column", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularyText"], FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["VocabularyText", "Printout"], 
          CellMargins -> {{66, 10}, {7, 7}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabularyCode", StyleDefinitions -> StyleData["Text"]], 
          Deletable -> False, FontFamily -> "Source Sans Pro", FontSize -> 14,
           FontWeight -> "Bold", FontColor -> GrayLevel[0.25], 
          GridBoxOptions -> {
           GridBoxAlignment -> {"Columns" -> {{Left}}}, 
            GridBoxDividers -> {
             "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
              "Rows" -> {True, {True}, True}, "RowsIndexed" -> {}}}], 
         Cell[
          StyleData["VocabularyCode", "Printout"], FontColor -> 
          GrayLevel[0.25]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["VocabDivColor"], FontColor -> GrayLevel[0.8]], 
         Cell[
          StyleData["VocabDivColor", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseSection"], PageWidth :> 700, 
          CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, Evaluatable -> True, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, ShowCellLabel -> False, CellFrameMargins -> {{8, 8}, {4, 6}},
           CellFrameColor -> RGBColor[0.901961, 0.411765, 0.027451], 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Exercise", 0}}, FontFamily -> "Source Sans Pro", FontSize -> 18, 
          FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["ExerciseSection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 30}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Exercise"], PageWidth :> 700, CellDingbat -> Cell[
            TextData[{"  ", 
              CounterBox["Section"], ".", 
              CounterBox["Exercise"]}], "ExerciseNumber", FontColor -> 
            RGBColor[
             0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
          ShowGroupOpener -> True, CellMargins -> {{108, Inherited}, {4, 8}}, 
          CellGroupingRules -> {"SectionGrouping", 67}, CounterIncrements -> 
          "Exercise", MenuSortingValue -> 10020, MenuCommandKey :> "2", 
          FontFamily -> "Source Sans Pro", FontSize -> 14, FontWeight -> 
          "Plain", FontSlant -> "Plain", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["Exercise", "Printout"], ShowGroupOpener -> False, 
          CellMargins -> {{110, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseNumber"], FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Bold", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["ExerciseNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseSubsection"], PageWidth :> 500, 
          CellFrame -> {{False, False}, {1, False}}, 
          CellMargins -> {{64, Inherited}, {8, 18}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, CellFrameColor -> 
          RGBColor[0.65, 0.6, 0.6], FontFamily -> "Source Sans Pro", FontSize -> 
          18, FontSlant -> "Italic", FontColor -> RGBColor[0.65, 0.6, 0.6]], 
         Cell[
          StyleData["ExerciseSubsection", "Printout"], 
          CellFrame -> {{False, False}, {1, False}}, CellFrameColor -> 
          RGBColor[0.65, 0.6, 0.6]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseNote"], PageWidth :> 700, 
          CellMargins -> {{64, Inherited}, {4, 8}}, PageBreakBelow -> False, 
          MenuSortingValue -> 10050, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0.25], $CellContext`ReturnCreatesNewCell -> 
          True], 
         Cell[
          StyleData["ExerciseNote", "Printout"], 
          CellMargins -> {{64, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["QASection"], PageWidth :> 700, 
          CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], 
          CounterAssignments -> {{"Subsection", 0}, {"Subsubsection", 0}, {
            "Question", 0}}, FontFamily -> "Source Sans Pro", FontSize -> 18, 
          FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["QASection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 30}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Question"], PageWidth :> 700, 
          CellMargins -> {{64, Inherited}, {2, 12}}, PageBreakBelow -> False, 
          CounterIncrements -> "Question", MenuSortingValue -> 10030, 
          MenuCommandKey :> "3", FontFamily -> "Source Sans Pro", FontSize -> 
          14, FontWeight -> "Bold", FontSlant -> 
          "Plain", $CellContext`ReturnCreatesNewCell -> 
          True, $CellContext`DefaultReturnCreatedCellStyle -> "Answer"], 
         Cell[
          StyleData["Question", "Printout"], 
          CellMargins -> {{65, Inherited}, {2, 12}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Answer"], PageWidth :> 700, 
          CellMargins -> {{66, 10}, {4, 1}}, LineSpacing -> {1.125, 1., 2.}, 
          MenuSortingValue -> 10032, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0.25], $CellContext`ReturnCreatesNewCell -> 
          True, $CellContext`DefaultReturnCreatedCellStyle -> "Question"], 
         Cell[
          StyleData["Answer", "Printout"], 
          CellMargins -> {{66, 10}, {4, 1}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["QuestionNumber"], FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Bold", FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["QuestionNumber", "Printout"]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TechNoteSection"], PageWidth :> 700, 
          CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 18, FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["TechNoteSection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 30}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["TechNote"], PageWidth :> 700, CellDingbat -> Cell[
            TextData[{"\[FilledSmallSquare]"}], FontSize -> 12, FontColor -> 
            GrayLevel[0.5]], CellMargins -> {{78, Inherited}, {4, 8}}, 
          CellChangeTimes -> {{3.651515120816633*^9, 3.651515125814807*^9}, 
            3.6515155174947033`*^9}, LineSpacing -> {1.25, 1., 2.}, 
          MenuSortingValue -> 10040, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0.25], $CellContext`ReturnCreatesNewCell -> 
          True], 
         Cell[
          StyleData["TechNote", "Printout"], 
          CellMargins -> {{82, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["MoreExploreSection"], PageWidth :> 700, 
          CellFrame -> {{0, 0}, {0, 3}}, 
          CellMargins -> {{64, Inherited}, {8, 30}}, 
          CellGroupingRules -> {"SectionGrouping", 60}, PageBreakBelow -> 
          False, CellFrameMargins -> {{8, 8}, {4, 6}}, CellFrameColor -> 
          RGBColor[0.901961, 0.411765, 0.027451], FontFamily -> 
          "Source Sans Pro", FontSize -> 18, FontSlant -> "Italic", FontColor -> 
          RGBColor[
           0.9019607843137255, 0.4117647058823529, 0.027450980392156862`], 
          GridBoxOptions -> {GridBoxAlignment -> {}}], 
         Cell[
          StyleData["MoreExploreSection", "Printout"], 
          CellMargins -> {{64, Inherited}, {8, 30}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["MoreExplore"], PageWidth :> 700, 
          CellMargins -> {{64, Inherited}, {4, 8}}, PageBreakBelow -> False, 
          MenuSortingValue -> 10050, FontFamily -> "Source Sans Pro", 
          FontSize -> 14, FontWeight -> "Plain", FontSlant -> "Plain", 
          FontColor -> GrayLevel[0], $CellContext`ReturnCreatesNewCell -> 
          True], 
         Cell[
          StyleData["MoreExplore", "Printout"], 
          CellMargins -> {{64, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["MoreExploreShortURL"], 
          CellMargins -> {{64, Inherited}, {4, 8}}, PageBreakBelow -> False, 
          FontFamily -> "Source Sans Pro Light", FontSize -> 14, FontSlant -> 
          "Plain", FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["MoreExploreShortURL", "Printout"], 
          CellMargins -> {{64, Inherited}, {4, 8}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Text"], CellMargins -> {{66, 10}, {4, 14}}, FontFamily -> 
          "Baskerville", FontSize -> 18, FontColor -> 
          GrayLevel[0], $CellContext`ReturnCreatesNewCell -> True], 
         Cell[
          StyleData["Text", "Printout"], CellMargins -> {{66, 10}, {7, 7}}]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ResourcesText"], CellMargins -> {{66, 10}, {2, 0}}, 
          FontFamily -> "Source Sans Pro", FontSize -> 14, FontWeight -> 
          "Plain", FontSlant -> "Plain", FontColor -> 
          GrayLevel[0], $CellContext`ReturnCreatesNewCell -> True], 
         Cell[
          StyleData["ResourcesText", "Printout"], 
          CellMargins -> {{66, 10}, {2, 0}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ResourcesLink"], CellMargins -> {{66, 10}, {2, 0}}, 
          FontFamily -> "Source Sans Pro", FontSize -> 14, FontWeight -> 
          "Plain", FontSlant -> "Italic", FontColor -> 
          GrayLevel[0], $CellContext`ReturnCreatesNewCell -> True], 
         Cell[
          StyleData["ResourcesLink", "Printout"], 
          CellMargins -> {{66, 10}, {2, 0}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["CodeCaption"], CellFrame -> {{0, 0}, {0, 0}}, 
          CellMargins -> {{66, 10}, {4, 12}}, PageBreakBelow -> False, 
          CellFrameColor -> GrayLevel[0.4], MenuSortingValue -> 10010, 
          MenuCommandKey :> "1", FontFamily -> "Source Sans Pro", FontSize -> 
          16, FontColor -> GrayLevel[0.25]], 
         Cell[
          StyleData["CodeCaption", "Printout"], 
          CellMargins -> {{66, 10}, {4, 12}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Input"], CellMargins -> {{99, 10}, {3, 7}}, SpanMaxSize -> 
          1, FontSize -> 15], 
         Cell[
          StyleData["Input", "Printout"], CellMargins -> {{99, 10}, {3, 7}}]},
         Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Output"], CellMargins -> {{99, 10}, {14, 7}}, FontSize -> 
          15], 
         Cell[
          StyleData["Output", "Printout"], 
          CellMargins -> {{99, 10}, {14, 7}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["InputOnly"], CellMargins -> {{99, 10}, {25, 10}}, 
          SpanMaxSize -> 1, MenuSortingValue -> 1500, FontSize -> 15], 
         Cell[
          StyleData["InputOnly", "Printout"], 
          CellMargins -> {{99, 10}, {15, 10}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["CellLabel"], 
          CellLabelMargins -> {{12, Inherited}, {Inherited, Inherited}}, 
          LanguageCategory -> None, StyleMenuListing -> None, FontFamily -> 
          "Helvetica Neue", FontSize -> 9, FontWeight -> "Plain", FontSlant -> 
          "Plain", FontColor -> GrayLevel[0.5]], 
         Cell[
          StyleData["CellLabel", "Printout"], FontSize -> 8, FontColor -> 
          GrayLevel[0.5]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Message"], Editable -> False, 
          CellMargins -> {{66, Inherited}, {Inherited, Inherited}}, 
          CellGroupingRules -> "OutputGrouping", TextClipboardType -> 
          "PlainText", PageBreakWithin -> False, GroupPageBreakWithin -> 
          False, GeneratedCell -> True, CellAutoOverwrite -> True, 
          ShowCellLabel -> False, DefaultFormatType -> 
          DefaultOutputFormatType, ContextMenu -> 
          FEPrivate`FrontEndResource["ContextMenus", "Output"], 
          ShowAutoStyles -> False, ShowSyntaxStyles -> False, 
          AutoStyleOptions -> {
           "StringStyle" -> None, "SyntaxErrorStyle" -> None}, 
          HyphenationOptions -> {"HyphenationCharacter" -> "\[Continuation]"},
           AutoItalicWords -> {}, AutoQuoteCharacters -> {}, 
          PasteAutoQuoteCharacters -> {}, LanguageCategory -> None, 
          FormatType -> InputForm, ShowStringCharacters -> False, 
          CounterIncrements -> "Message", MenuSortingValue -> 1600, 
          StyleMenuListing -> None, FontFamily :> 
          CurrentValue["PanelFontFamily"], FontSize -> 11, FontColor -> 
          RGBColor[0.5072, 0.16933, 0.15221], $CellContext`StripStyleOnPaste -> 
          True], 
         Cell[
          StyleData["Message", "Printout"], 
          CellMargins -> {{100, Inherited}, {Inherited, Inherited}}, 
          CellFrameLabels -> {{None, None}, {None, None}}, FontColor -> 
          GrayLevel[0]]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["ExerciseInput", StyleDefinitions -> StyleData["Input"]], 
          CellMargins -> {{88, 10}, {4, 7}}, ShowCellLabel -> False, 
          SpanMaxSize -> 1, FontSize -> 
          14, $CellContext`GeneratedCellStyles -> {
           "Output" -> "ExerciseOutput"}], 
         Cell[
          StyleData["ExerciseInput", "Printout"], 
          CellMargins -> {{88, 10}, {4, 7}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData[
          "ExerciseOutput", StyleDefinitions -> StyleData["Output"]], 
          CellMargins -> {{88, 10}, {10, 4}}, ShowCellLabel -> False, 
          FontSize -> 14], 
         Cell[
          StyleData["ExerciseOutput", "Printout"], 
          CellMargins -> {{88, 10}, {10, 4}}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Picture"], CellMargins -> {{66, 10}, {10, 10}}, 
          CellGroupingRules -> "GraphicsGrouping", StyleMenuListing -> None], 
         
         Cell[
          StyleData["Picture", "Printout"], 
          CellMargins -> {{66, 10}, {8, 8}}]}, Closed]], 
      Cell[
       StyleData["ExerciseSummaryCell"], PageWidth :> 700, CellFrame -> 0, 
       CellMargins -> {{64, Inherited}, {8, 10}}, 
       CellGroupingRules -> {"SectionGrouping", 64}, PageBreakBelow -> False, 
       ShowCellLabel -> False, CellFrameMargins -> 0, ShowStringCharacters -> 
       False, FontFamily -> "Source Sans Pro", FontSize -> 18, FontColor -> 
       RGBColor[1, 1, 1], 
       GridBoxOptions -> {GridBoxBackground -> {"Columns" -> {{
              RGBColor[0.990997, 0.539528, 0.155779], 
              RGBColor[0.989487, 0.434699, 0.0320439]}}, "Rows" -> {{None}}}, 
         GridBoxItemSize -> {"Columns" -> {
             Scaled[0.7], 
             Scaled[0.3]}, "Rows" -> {{Automatic}}}}], 
      Cell[
       StyleData["ExerciseSummaryHeading"], ShowStringCharacters -> False, 
       FontFamily -> "Source Sans Pro", FontSize -> 18, FontColor -> 
       RGBColor[1, 1, 1]], 
      Cell[
       StyleData["ExerciseSummarySubheading"], ShowStringCharacters -> False, 
       FontFamily -> "Source Sans Pro", FontSize -> 15, FontColor -> 
       RGBColor[1., 0.9294117647058824, 0.7215686274509804]], 
      Cell[
       StyleData["ExercisePreviewButtonText"], ShowStringCharacters -> False, 
       FontFamily -> "Source Sans Pro", FontSize -> 14, FontSlant -> "Plain", 
       FontColor -> RGBColor[0.6, 0.6, 0.6]], 
      Cell[
       StyleData["ExercisePreviewButtonTextHighlight"], ShowStringCharacters -> 
       False, FontFamily -> "Source Sans Pro", FontSize -> 14, FontSlant -> 
       "Plain", FontColor -> 
       RGBColor[
        0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]]}, 
     Open]], 
   Cell[
    CellGroupData[{
      Cell[
      "Inline and special formatting", "Section", 
       CellChangeTimes -> {{3.646681732592888*^9, 3.646681749414035*^9}}], 
      Cell[
       StyleData["Graphics"], MenuSortingValue -> None], 
      Cell[
       StyleData["Graphics3D"], MenuSortingValue -> None], 
      Cell[
       StyleData["StandardForm"], 
       InputAutoReplacements -> {
        "->" -> "\[Rule]", ":>" -> "\[RuleDelayed]", "<=" -> "\[LessEqual]", 
         ">=" -> "\[GreaterEqual]", "!=" -> "\[NotEqual]", "==" -> "\[Equal]",
          "@>" -> "\\[InlinePart]", "<->" -> "\[UndirectedEdge]", ParentList},
        LineSpacing -> {1.25, 0, 2}, SingleLetterItalics -> False, 
       StyleMenuListing -> None, FontFamily -> "Source Sans Pro", 
       PrivateFontOptions -> {"OperatorSubstitution" -> True}], 
      Cell[
       StyleData["OutputForm"], PageWidth :> DirectedInfinity[1], 
       TextAlignment -> Left, LineSpacing -> {0.6, 1}, 
       AutoQuoteCharacters -> {}, PasteAutoQuoteCharacters -> {}, 
       StyleMenuListing -> None, FontFamily -> "Source Sans Pro", 
       PrivateFontOptions -> {"OperatorSubstitution" -> True}], 
      Cell[
       StyleData["InputForm"], PageWidth :> DirectedInfinity[1], 
       InputAutoReplacements -> {}, AllowInlineCells -> False, Hyphenation -> 
       False, AutoQuoteCharacters -> {}, PasteAutoQuoteCharacters -> {}, 
       AutoSpacing -> False, NumberMarks -> True, AutoNumberFormatting -> 
       False, StyleMenuListing -> None, FontFamily -> "Source Sans Pro", 
       PrivateFontOptions -> {"OperatorSubstitution" -> True}], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["DetailsLink"], FontFamily -> "Source Sans Pro", FontSize :> 
          If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.9]], FontColor -> GrayLevel[0], 
          ButtonBoxOptions -> {
           ButtonFunction :> (
             Function[$CellContext`t, 
              NotebookFind[$CellContext`t, "Notes", All, CellStyle]; 
              NotebookFind[$CellContext`t, "NotesSection", All, CellStyle, 
                AutoScroll -> Top]][
              Documentation`HelpLookup[
               StringJoin["ref/", #]]]& ), ButtonSource -> ButtonContents, 
            Evaluator -> Automatic}], 
         Cell[
          StyleData["DetailsLink", "Printout"], FontFamily -> 
          "Source Sans Pro", FontSize :> If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.88]], FontColor -> GrayLevel[0]]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["LinkAlt"], FontFamily -> "Source Sans Pro", FontSize :> 
          If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.9]], FontColor -> GrayLevel[0]], 
         Cell[
          StyleData["LinkAlt", "Printout"], FontFamily -> "Source Sans Pro", 
          FontSize :> If[CurrentValue[
              EvaluationCell[], "FontFamily"] === "Source Sans Pro", 
            Inherited, 
            If[CurrentValue[
               EvaluationCell[], "FontFamily"] === "WolframCodeSans", 
             Inherited, Inherited 0.88]], FontColor -> GrayLevel[0]]}, 
        Closed]], 
      Cell[
       CellGroupData[{
         Cell[
          StyleData["Hyperlink"], MenuSortingValue -> None, FontColor -> 
          RGBColor[0.3, 0.35, 0.5]], 
         Cell[
          StyleData["Hyperlink", "Printout"]]}, Closed]], 
      Cell[
       StyleData[
       "IndexNavigationLink", StyleDefinitions -> StyleData["Hyperlink"]], 
       MenuSortingValue -> None, FontColor -> 
       RGBColor[
        0.9019607843137255, 0.4117647058823529, 0.027450980392156862`]], 
      Cell[
       StyleData["Crosslink"], 
       ButtonBoxOptions -> {ButtonFunction :> (FrontEndExecute[{
            
            NotebookLocate[#2, "OpenInNewWindow" -> 
             CurrentValue["HyperlinkModifierKey"]]}]& ), Evaluator -> None, 
         Method -> "Queued"}], 
      Cell[
       StyleData["VocabularyLink"], FontColor -> GrayLevel[0], 
       ButtonBoxOptions -> {ButtonFunction :> (FrontEndExecute[{
            
            NotebookLocate[#2, "OpenInNewWindow" -> 
             CurrentValue["HyperlinkModifierKey"]]}]& ), Evaluator -> None, 
         Method -> "Queued"}], 
      Cell[
       StyleData["InlineCode"], SpanMaxSize -> 1, FontColor -> GrayLevel[0]], 
      
      Cell[
       StyleData["InlineCodeText"], SpanMaxSize -> 1, FontFamily -> 
       "Source Sans Pro", FontSize -> 0.95 Inherited], 
      Cell[
       StyleData["NoLabel"], ShowCellLabel -> 
       False, $CellContext`GeneratedCellStyles -> {
        "Output" -> "ExerciseOutput"}], 
      Cell[
       StyleData["MenuName"], FontFamily -> "Verdana", FontWeight -> "Bold", 
       FontColor -> GrayLevel[0.286275]], 
      Cell[
       StyleData["KeyEvent"], CellFrame -> {{0.5, 0.5}, {0.5, 0.5}}, 
       CellFrameMargins -> {{2, 2}, {2, 2}}, CellFrameColor -> GrayLevel[0.7],
        FontFamily -> "Verdana", FontColor -> GrayLevel[0.4]], 
      Cell[
       StyleData["KeyEventDelimiter"], FontColor -> GrayLevel[0.5]], 
      Cell[
       CellGroupData[{
         Cell["Key Styles", "Subsubsection"], 
         Cell[
          StyleData["Key0"], 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              TagBox[
               GridBox[{{
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> GrayLevel[1], StripOnInput -> 
                   False]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Center}}, "Rows" -> {{Baseline}}}, AutoDelete -> 
                False, GridBoxDividers -> {"Rows" -> {{None}}}, 
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{1.45}}},
                 GridBoxSpacings -> {"Columns" -> {{0}}}, 
                BaselinePosition -> {{1, 1}, Baseline}], "Grid"], 
              RoundingRadius -> 4, Background -> 
              GrayLevel[0.9333333333333333], 
              FrameMargins -> {{0, 0}, {-2, -2}}, FrameStyle -> {
                GrayLevel[0.8352941176470589], 
                AbsoluteThickness[1]}, BaselinePosition -> Baseline, 
              StripOnInput -> False]& )}], 
         Cell[
          StyleData["Key1"], 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              TagBox[
               GridBox[{{
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #2, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> GrayLevel[1], StripOnInput -> 
                   False]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Center}}, "Rows" -> {{Baseline}}}, AutoDelete -> 
                False, GridBoxDividers -> {
                 "ColumnsIndexed" -> {2 -> GrayLevel[0.8352941176470589]}, 
                  "Rows" -> {{None}}}, 
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{1.45}}},
                 GridBoxSpacings -> {"Columns" -> {{0}}}, 
                BaselinePosition -> {{1, 1}, Baseline}], "Grid"], 
              RoundingRadius -> 4, Background -> 
              GrayLevel[0.9333333333333333], 
              FrameMargins -> {{0, 0}, {-2, -2}}, FrameStyle -> {
                GrayLevel[0.8352941176470589], 
                AbsoluteThickness[1]}, BaselinePosition -> Baseline, 
              StripOnInput -> False]& )}], 
         Cell[
          StyleData["Key2"], 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              TagBox[
               GridBox[{{
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #2, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #3, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> GrayLevel[1], StripOnInput -> 
                   False]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Center}}, "Rows" -> {{Baseline}}}, AutoDelete -> 
                False, GridBoxDividers -> {
                 "ColumnsIndexed" -> {
                   2 -> GrayLevel[0.8352941176470589], 3 -> 
                    GrayLevel[0.8352941176470589]}, "Rows" -> {{None}}}, 
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{1.45}}},
                 GridBoxSpacings -> {"Columns" -> {{0}}}, 
                BaselinePosition -> {{1, 1}, Baseline}], "Grid"], 
              RoundingRadius -> 4, Background -> 
              GrayLevel[0.9333333333333333], 
              FrameMargins -> {{0, 0}, {-2, -2}}, FrameStyle -> {
                GrayLevel[0.8352941176470589], 
                AbsoluteThickness[1]}, BaselinePosition -> Baseline, 
              StripOnInput -> False]& )}], 
         Cell[
          StyleData["Key3"], 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              TagBox[
               GridBox[{{
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #2, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #3, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> 
                   GrayLevel[0.9333333333333333], StripOnInput -> False], 
                  ItemBox[
                   
                   TemplateBox[{"\[ThickSpace]", #4, "\[ThickSpace]"}, 
                    "RowDefault"], Background -> GrayLevel[1], StripOnInput -> 
                   False]}}, 
                GridBoxAlignment -> {
                 "Columns" -> {{Center}}, "Rows" -> {{Baseline}}}, AutoDelete -> 
                False, GridBoxDividers -> {
                 "ColumnsIndexed" -> {
                   2 -> GrayLevel[0.8352941176470589], 3 -> 
                    GrayLevel[0.8352941176470589], 4 -> 
                    GrayLevel[0.8352941176470589]}, "Rows" -> {{None}}}, 
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{1.45}}},
                 GridBoxSpacings -> {"Columns" -> {{0}}}, 
                BaselinePosition -> {{1, 1}, Baseline}], "Grid"], 
              RoundingRadius -> 4, Background -> 
              GrayLevel[0.9333333333333333], 
              FrameMargins -> {{0, 0}, {-2, -2}}, FrameStyle -> {
                GrayLevel[0.8352941176470589], 
                AbsoluteThickness[1]}, BaselinePosition -> Baseline, 
              StripOnInput -> False]& )}]}, Closed]], 
      Cell[
       CellGroupData[{
         Cell["Entity styles", "Subsubsection"], 
         Cell[
          StyleData["Entity"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              FrameBox[
               PaneSelectorBox[{True -> GridBox[{{
                    
                    StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]], 
                    StyleBox[
                    RowBox[{"(", #4, ")"}], FontFamily -> "Source Sans Pro", 
                    FontWeight -> "Plain", FontColor -> GrayLevel[0.65], 
                    Selectable -> False]}}, 
                   GridBoxItemSize -> {
                    "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                   GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}},
                    BaselinePosition -> {1, 1}], False -> 
                 PaneBox[#, 
                   BaseStyle -> {
                    FontColor -> RGBColor[0.395437, 0.20595, 0.061158]}, 
                   BaselinePosition -> Baseline]}, 
                Dynamic[
                 CurrentValue[Evaluatable]], ImageSize -> Automatic, 
                BaselinePosition -> Baseline, 
                BaseStyle -> {FontFamily -> "Helvetica"}], FrameStyle -> 
               RGBColor[1., 0.504768, 0.], Background -> 
               RGBColor[1., 0.980392, 0.921569], 
               FrameMargins -> {{5, 5}, {1.5, 1.5}}, 
               ImageMargins -> {{2, 2}, {2, 2}}, BaselinePosition -> Baseline,
                RoundingRadius -> 4], #3, 
              BaseStyle -> {
               FontWeight -> "Plain", ShowStringCharacters -> False, 
                LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityFrameless"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              PaneSelectorBox[{True -> GridBox[{{
                    
                    StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]], 
                    StyleBox[
                    RowBox[{"(", #4, ")"}], FontFamily -> "Source Sans Pro", 
                    FontWeight -> "Plain", FontColor -> GrayLevel[0.65], 
                    Selectable -> False]}}, 
                  GridBoxItemSize -> {
                   "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                  BaselinePosition -> {1, 1}], False -> 
                PaneBox[#, 
                  BaseStyle -> {
                   FontColor -> RGBColor[0.395437, 0.20595, 0.061158]}, 
                  BaselinePosition -> Baseline]}, 
               Dynamic[
                CurrentValue[Evaluatable]], ImageSize -> Automatic, 
               BaselinePosition -> Baseline, 
               BaseStyle -> {FontFamily -> "Helvetica"}], #3, 
              BaseStyle -> {
               ShowStringCharacters -> False, LineIndent -> 0, 
                PrivateFontOptions -> {
                 FontWeight -> "Plain", "OperatorSubstitution" -> False}}]& ),
             Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityFramelessHot"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {
           DisplayFunction -> (PaneSelectorBox[{True -> GridBox[{{
                   
                   StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0]], 
                   StyleBox[
                    RowBox[{"(", #4, ")"}], FontWeight -> "Plain", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0], Selectable -> 
                    False]}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                 BaselinePosition -> {1, 1}], False -> 
               PaneBox[#, BaseStyle -> {FontColor -> GrayLevel[0]}, 
                 BaselinePosition -> Baseline]}, 
              Dynamic[
               CurrentValue[Evaluatable]], ImageSize -> Automatic, 
              BaselinePosition -> Baseline, 
              BaseStyle -> {
               FontWeight -> "Plain", FontFamily -> "Helvetica", 
                ShowStringCharacters -> False, LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityClass"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              FrameBox[
               PaneSelectorBox[{True -> GridBox[{{
                    PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                    
                    StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]], 
                    StyleBox[
                    RowBox[{"(", #4, ")"}], FontWeight -> "Plain", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0.65], 
                    Selectable -> False]}}, 
                   GridBoxItemSize -> {
                    "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                   GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}},
                    BaselinePosition -> {1, 2}], False -> GridBox[{{
                    PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                    
                    StyleBox[#, FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]]}}, 
                   GridBoxItemSize -> {
                    "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                   GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}},
                    BaselinePosition -> {1, 2}]}, 
                Dynamic[
                 CurrentValue[Evaluatable]], ImageSize -> Automatic, 
                BaselinePosition -> Baseline, 
                BaseStyle -> {FontFamily -> "Helvetica"}], FrameStyle -> 
               RGBColor[1., 0.504768, 0.], Background -> 
               RGBColor[1., 0.980392, 0.921569], 
               FrameMargins -> {{5, 5}, {1.5, 1.5}}, 
               ImageMargins -> {{2, 2}, {2, 2}}, BaselinePosition -> Baseline,
                RoundingRadius -> 4], #3, 
              BaseStyle -> {
               FontWeight -> "Plain", ShowStringCharacters -> False, 
                LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityClassFrameless"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              PaneSelectorBox[{True -> GridBox[{{
                    PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                    
                    StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]], 
                    StyleBox[
                    RowBox[{"(", #4, ")"}], FontWeight -> "Plain", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0.65], 
                    Selectable -> False]}}, 
                  GridBoxItemSize -> {
                   "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                  BaselinePosition -> {1, 2}], False -> GridBox[{{
                    PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                    
                    StyleBox[#, FontColor -> 
                    RGBColor[0.395437, 0.20595, 0.061158]]}}, 
                  GridBoxItemSize -> {
                   "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                  BaselinePosition -> {1, 2}]}, 
               Dynamic[
                CurrentValue[Evaluatable]], ImageSize -> Automatic, 
               BaselinePosition -> Baseline, 
               BaseStyle -> {FontFamily -> "Helvetica"}], #3, 
              BaseStyle -> {
               FontWeight -> "Plain", ShowStringCharacters -> False, 
                LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityClassFramelessHot"], ShowStringCharacters -> False,
           TemplateBoxOptions -> {
           DisplayFunction -> (PaneSelectorBox[{True -> GridBox[{{
                   PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                   
                   StyleBox[#, FontWeight -> "Bold", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0]], 
                   StyleBox[
                    RowBox[{"(", #4, ")"}], FontWeight -> "Plain", FontFamily -> 
                    "Source Sans Pro", FontColor -> GrayLevel[0], Selectable -> 
                    False]}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                 BaselinePosition -> {1, 2}], False -> GridBox[{{
                   PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], 
                   StyleBox[#, FontColor -> GrayLevel[0]]}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                 BaselinePosition -> {1, 2}]}, 
              Dynamic[
               CurrentValue[Evaluatable]], ImageSize -> Automatic, 
              BaselinePosition -> Baseline, 
              BaseStyle -> {
               FontWeight -> "Plain", FontFamily -> "Helvetica", 
                ShowStringCharacters -> False, LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityProperty"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              FrameBox[
               
               PaneBox[#, 
                BaseStyle -> {
                 FontSlant -> Italic, FontWeight -> Plain, FontFamily -> 
                  "Source Sans Pro", FontColor -> 
                  RGBColor[0.395437, 0.20595, 0.061158]}, BaselinePosition -> 
                Baseline], FrameStyle -> 
               RGBColor[0.94227, 0.703639, 0.033387], Background -> 
               RGBColor[1., 0.980392, 0.921569], 
               FrameMargins -> {{5, 5}, {1.5, 1.5}}, 
               ImageMargins -> {{2, 2}, {2, 2}}, BaselinePosition -> Baseline,
                RoundingRadius -> 4], #3, 
              BaseStyle -> {
               FontWeight -> "Plain", ShowStringCharacters -> False, 
                LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityPropertyClass"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (TooltipBox[
              FrameBox[
               PaneBox[
                GridBox[{{
                   PaneBox[
                    DynamicBox[
                    FEPrivate`ImportImage[
                    
                    FrontEnd`ToFileName[{"Typeset", "Entity"}, 
                    "EntityClass.png"]], ImageSizeCache -> {8., {2., 6.}}], 
                    BaselinePosition -> Bottom], #}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.2}}, "Rows" -> {{0}}}, 
                 BaselinePosition -> {1, 2}], 
                BaseStyle -> {
                 FontSlant -> Italic, FontWeight -> Plain, FontFamily -> 
                  "Source Sans Pro", FontColor -> 
                  RGBColor[0.395437, 0.20595, 0.061158]}, BaselinePosition -> 
                Baseline], FrameStyle -> 
               RGBColor[0.94227, 0.703639, 0.033387], Background -> 
               RGBColor[1., 0.980392, 0.921569], 
               FrameMargins -> {{5, 5}, {1.5, 1.5}}, 
               ImageMargins -> {{2, 2}, {2, 2}}, BaselinePosition -> Baseline,
                RoundingRadius -> 4], #3, 
              BaseStyle -> {
               FontWeight -> "Plain", ShowStringCharacters -> False, 
                LineIndent -> 0, 
                PrivateFontOptions -> {"OperatorSubstitution" -> False}}]& ), 
            Editable -> False, InterpretationFunction -> (#2& )}], 
         Cell[
          StyleData["EntityValue"], ShowStringCharacters -> False, 
          TemplateBoxOptions -> {DisplayFunction -> (FrameBox[
              
              GridBox[{{#, #2}}, GridBoxAlignment -> {"Rows" -> {{Baseline}}},
                GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}}, 
               GridBoxSpacings -> {"Columns" -> {{0}}}, 
               BaselinePosition -> {1, 1}], Background -> 
              RGBColor[{0.9921568627450981, 0.9529411764705882, 
                0.8509803921568627}], BaselinePosition -> Baseline, 
              FrameMargins -> {{1, 1}, {1, 1}}, ImageMargins -> 2, FrameStyle -> 
              RGBColor[{0.9333333333333333, 0.8470588235294118, 
                0.5529411764705883}], RoundingRadius -> 5]& )}]}, Closed]]}, 
     Closed]]}, Visible -> False, FrontEndVersion -> 
  "12.3 for Mac OS X x86 (64-bit) (July 30, 2021)", StyleDefinitions -> 
  "StylesheetFormatting.nb"],
ExpressionUUID->"cae30ab8-09fe-4358-83e8-1131f6ed1ed9"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "p:101"->{
  Cell[658, 23, 435, 10, 93, "SectionDoubleDigit",ExpressionUUID->"012c4330-46eb-4711-a1dc-28ca57bfb0ac",
   CounterAssignments->{{"Section", 18}, {"Subsection", 0}, {"Subsubsection", 0}, {"Exercise", 0}, {"Question", 0}},
   CellTags->"p:101"]},
 "i:1"->{
  Cell[1096, 35, 270, 9, 40, "Text",ExpressionUUID->"5f7594a6-58b4-46fb-a5ab-fa308c190827",
   CellTags->"i:1"]},
 "i:2"->{
  Cell[1369, 46, 217, 5, 37, "CodeCaption",ExpressionUUID->"a5a17762-a3bd-455f-b772-d36d77172a21",
   CellTags->"i:2"]},
 "i:3"->{
  Cell[2432, 81, 210, 4, 40, "Text",ExpressionUUID->"988f6b86-8dc1-4f85-8f4e-175d03433cd4",
   CellTags->"i:3"]},
 "i:4"->{
  Cell[4824, 147, 415, 11, 41, "Text",ExpressionUUID->"3c51a4ce-78c5-4e64-9b70-8887b90ca8d3",
   CellTags->"i:4"]},
 "i:5"->{
  Cell[7261, 218, 249, 7, 65, "Text",ExpressionUUID->"ddab02ca-e0a3-431c-81d0-afe3fd71da4d",
   CellTags->"i:5"]},
 "i:6"->{
  Cell[9276, 276, 195, 4, 37, "CodeCaption",ExpressionUUID->"258b6df1-894a-43e9-8c7d-bacb94eacc54",
   CellTags->"i:6"]},
 "p:102"->{
  Cell[11212, 327, 301, 12, 70, "Text",ExpressionUUID->"b48f1113-ccbc-4df5-9cfd-32f189413921",
   CellTags->{"p:102", "i:7"}]},
 "i:7"->{
  Cell[11212, 327, 301, 12, 70, "Text",ExpressionUUID->"b48f1113-ccbc-4df5-9cfd-32f189413921",
   CellTags->{"p:102", "i:7"}]},
 "i:8"->{
  Cell[11516, 341, 220, 5, 70, "CodeCaption",ExpressionUUID->"9489dda2-a4fe-4693-86c5-14b9a533ed69",
   CellTags->"i:8"]},
 "LastCellOfAPage"->{
  Cell[11960, 356, 1496, 46, 70, "Output",ExpressionUUID->"2dd978c0-9f10-4947-9093-94c1ff446f35",
   Evaluatable->False,
   CellTags->"LastCellOfAPage"],
  Cell[22537, 670, 274, 7, 70, "Output",ExpressionUUID->"b7e97b0c-2f38-4543-bb8b-d60f9b67e5cb",
   Evaluatable->False,
   CellTags->"LastCellOfAPage"],
  Cell[37627, 1066, 25190, 519, 70, "Output",ExpressionUUID->"3da0ce73-c3ff-48a2-a4d1-a0b8dfb84b5c",
   Evaluatable->False,
   CellTags->"LastCellOfAPage"],
  Cell[111936, 2781, 695, 16, 70, "Text",ExpressionUUID->"ffcede94-db0c-484e-9793-70727c569c1b",
   CellTags->{"LastCellOfAPage", "i:22"}],
  Cell[135573, 3260, 6525, 184, 70, "VocabularyTable",ExpressionUUID->"41623163-6491-4748-81af-e1ecb58c1fa9",
   CellTags->"LastCellOfAPage"],
  Cell[353097, 8268, 1165, 36, 70, "Answer",ExpressionUUID->"2f995462-da30-49a3-b7f2-88771ee1a2c5",
   CellTags->"LastCellOfAPage"],
  Cell[356434, 8387, 339, 8, 70, "MoreExplore",ExpressionUUID->"d0f53de7-b841-45eb-aaee-db62786407a3",
   CellTags->"LastCellOfAPage"]},
 "i:9"->{
  Cell[13471, 405, 259, 8, 70, "Text",ExpressionUUID->"32eaf23b-24dc-4713-89d3-819289328892",
   CellTags->"i:9"]},
 "i:10"->{
  Cell[15485, 462, 431, 13, 70, "Text",ExpressionUUID->"070151e2-2d71-416c-8e00-c80767e3ea36",
   CellTags->"i:10"]},
 "i:11"->{
  Cell[20860, 615, 218, 5, 70, "CodeCaption",ExpressionUUID->"4d13863d-f091-4317-9f54-89fe35e95eb8",
   CellTags->"i:11"]},
 "i:12"->{
  Cell[22025, 653, 204, 4, 70, "CodeCaption",ExpressionUUID->"8b854b10-74d5-41c4-bff7-8d94ce1e916f",
   CellTags->"i:12"]},
 "i:13"->{
  Cell[24788, 735, 320, 10, 70, "Text",ExpressionUUID->"615c57ba-7e08-4eaf-9e0b-34c0bef724b7",
   CellTags->"i:13"]},
 "i:14"->{
  Cell[25111, 747, 200, 4, 70, "CodeCaption",ExpressionUUID->"e6dfc220-99ac-4092-8d8d-0dadb15c0401",
   CellTags->"i:14"]},
 "i:15"->{
  Cell[28603, 834, 193, 4, 70, "CodeCaption",ExpressionUUID->"d8b64ce1-cdfe-43be-9136-c36b3eafedfc",
   CellTags->"i:15"]},
 "i:16"->{
  Cell[33015, 934, 418, 12, 70, "Text",ExpressionUUID->"72d5442a-fde8-420b-bd51-4c2e0d145f8e",
   CellTags->"i:16"]},
 "i:17"->{
  Cell[35391, 1001, 383, 14, 70, "Text",ExpressionUUID->"92603fda-52cc-47dd-9733-5a9f9b1e060f",
   CellTags->"i:17"]},
 "p:104"->{
  Cell[62832, 1588, 361, 12, 70, "Text",ExpressionUUID->"68287844-f5e1-4958-9b30-8110b4ebbf3b",
   CellTags->{"p:104", "i:18"}]},
 "i:18"->{
  Cell[62832, 1588, 361, 12, 70, "Text",ExpressionUUID->"68287844-f5e1-4958-9b30-8110b4ebbf3b",
   CellTags->{"p:104", "i:18"}]},
 "i:19"->{
  Cell[77983, 1959, 256, 7, 70, "Text",ExpressionUUID->"099fb920-f395-49f6-8694-a503d3b0d560",
   CellTags->"i:19"]},
 "i:20"->{
  Cell[78242, 1968, 543, 12, 70, "Text",ExpressionUUID->"37affbaf-0512-4bfe-936a-17eac66eca5c",
   CellTags->"i:20"]},
 "i:21"->{
  Cell[78788, 1982, 282, 7, 70, "CodeCaption",ExpressionUUID->"c8e0aeb7-1a20-41dd-b9ae-f66deb3cad5a",
   CellTags->"i:21"]},
 "i:22"->{
  Cell[111936, 2781, 695, 16, 70, "Text",ExpressionUUID->"ffcede94-db0c-484e-9793-70727c569c1b",
   CellTags->{"LastCellOfAPage", "i:22"}]},
 "i:23"->{
  Cell[347798, 8098, 734, 21, 70, "Answer",ExpressionUUID->"008404cd-03c0-44a7-ac0a-696c49f34e3b",
   CellTags->"i:23"]},
 "i:24"->{
  Cell[348748, 8129, 774, 25, 70, "Answer",ExpressionUUID->"4cd299f7-760c-48d3-99cf-645fc3f2cff7",
   CellTags->"i:24"]},
 "i:25"->{
  Cell[349725, 8162, 367, 8, 70, "Answer",ExpressionUUID->"9f72bf3c-92b5-4118-8e00-62c4975c3ea3",
   CellTags->"i:25"]},
 "i:26"->{
  Cell[351746, 8223, 1122, 32, 70, "Answer",ExpressionUUID->"7a3ddbd2-2ed2-45a7-8d93-9f1cca329706",
   CellTags->"i:26"]},
 "p:106"->{
  Cell[354299, 8309, 174, 4, 70, "TechNoteSection",ExpressionUUID->"85817595-011e-4565-91e8-e30585162152",
   CellTags->"p:106"]},
 "i:27"->{
  Cell[354476, 8315, 374, 8, 70, "TechNote",ExpressionUUID->"9a0bd9b5-a576-448e-8fa6-061e93261bca",
   CellTags->"i:27"]},
 "i:28"->{
  Cell[355152, 8338, 544, 18, 70, "TechNote",ExpressionUUID->"d9abb382-14cf-4e02-9c91-7b4b0a431750",
   CellTags->"i:28"]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"p:101", 447399, 10235},
 {"i:1", 447656, 10239},
 {"i:2", 447780, 10242},
 {"i:3", 447911, 10245},
 {"i:4", 448035, 10248},
 {"i:5", 448161, 10251},
 {"i:6", 448286, 10254},
 {"p:102", 448420, 10257},
 {"i:7", 448558, 10260},
 {"i:8", 448696, 10263},
 {"LastCellOfAPage", 448841, 10266},
 {"i:9", 449867, 10284},
 {"i:10", 449994, 10287},
 {"i:11", 450123, 10290},
 {"i:12", 450258, 10293},
 {"i:13", 450393, 10296},
 {"i:14", 450522, 10299},
 {"i:15", 450657, 10302},
 {"i:16", 450792, 10305},
 {"i:17", 450921, 10308},
 {"p:104", 451052, 10311},
 {"i:18", 451193, 10314},
 {"i:19", 451334, 10317},
 {"i:20", 451463, 10320},
 {"i:21", 451593, 10323},
 {"i:22", 451729, 10326},
 {"i:23", 451881, 10329},
 {"i:24", 452014, 10332},
 {"i:25", 452147, 10335},
 {"i:26", 452279, 10338},
 {"p:106", 452414, 10341},
 {"i:27", 452556, 10344},
 {"i:28", 452690, 10347}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[658, 23, 435, 10, 93, "SectionDoubleDigit",ExpressionUUID->"012c4330-46eb-4711-a1dc-28ca57bfb0ac",
 CounterAssignments->{{"Section", 18}, {"Subsection", 0}, {"Subsubsection", 0}, {"Exercise", 0}, {"Question", 0}},
 CellTags->"p:101"],
Cell[1096, 35, 270, 9, 40, "Text",ExpressionUUID->"5f7594a6-58b4-46fb-a5ab-fa308c190827",
 CellTags->"i:1"],
Cell[1369, 46, 217, 5, 37, "CodeCaption",ExpressionUUID->"a5a17762-a3bd-455f-b772-d36d77172a21",
 CellTags->"i:2"],
Cell[CellGroupData[{
Cell[1611, 55, 126, 2, 29, "Input",ExpressionUUID->"d3789b74-d6ba-4229-931e-787f810cd606"],
Cell[1740, 59, 677, 19, 46, "Output",ExpressionUUID->"ca25b694-a4cc-49fe-b70e-1fc604b1ea00",
 Evaluatable->False]
}, Open  ]],
Cell[2432, 81, 210, 4, 40, "Text",ExpressionUUID->"988f6b86-8dc1-4f85-8f4e-175d03433cd4",
 CellTags->"i:3"],
Cell[2645, 87, 183, 4, 37, "CodeCaption",ExpressionUUID->"44c6cdcd-2055-4a0a-ba71-5b0b486b30c7"],
Cell[CellGroupData[{
Cell[2853, 95, 1275, 28, 38, "Input",ExpressionUUID->"b7f9c45b-438a-40ea-a250-7341884cfdf9"],
Cell[4131, 125, 678, 19, 46, "Output",ExpressionUUID->"5495c012-118a-4b55-9e9f-2585bd794e2c",
 Evaluatable->False]
}, Open  ]],
Cell[4824, 147, 415, 11, 41, "Text",ExpressionUUID->"3c51a4ce-78c5-4e64-9b70-8887b90ca8d3",
 CellTags->"i:4"],
Cell[5242, 160, 156, 4, 37, "CodeCaption",ExpressionUUID->"f578bcca-4dd4-413c-b486-8bea382713ae"],
Cell[CellGroupData[{
Cell[5423, 168, 1267, 29, 38, "Input",ExpressionUUID->"8872b302-5862-4510-883b-9d571817df77"],
Cell[6693, 199, 553, 16, 46, "Output",ExpressionUUID->"189cecf7-b20e-48d8-892d-f120f296cd1d",
 Evaluatable->False]
}, Open  ]],
Cell[7261, 218, 249, 7, 65, "Text",ExpressionUUID->"ddab02ca-e0a3-431c-81d0-afe3fd71da4d",
 CellTags->"i:5"],
Cell[7513, 227, 162, 4, 37, "CodeCaption",ExpressionUUID->"58cfbe93-29a3-43bc-8cdd-78adde6ddbd1"],
Cell[CellGroupData[{
Cell[7700, 235, 1318, 30, 38, "Input",ExpressionUUID->"a9cbb602-1e98-4751-a529-0a387f14e811"],
Cell[9021, 267, 240, 6, 44, "Output",ExpressionUUID->"7f6d352c-2503-4e81-bb1a-8a278b1f1b7f",
 Evaluatable->False]
}, Open  ]],
Cell[9276, 276, 195, 4, 37, "CodeCaption",ExpressionUUID->"258b6df1-894a-43e9-8c7d-bacb94eacc54",
 CellTags->"i:6"],
Cell[CellGroupData[{
Cell[9496, 284, 1446, 32, 38, "Input",ExpressionUUID->"a1e3a5f2-12e3-42b4-ab4e-ed4e0cd62684"],
Cell[10945, 318, 252, 6, 70, "Output",ExpressionUUID->"45bc5449-c142-4056-aa23-9158f23fa209",
 Evaluatable->False]
}, Open  ]],
Cell[11212, 327, 301, 12, 70, "Text",ExpressionUUID->"b48f1113-ccbc-4df5-9cfd-32f189413921",
 CellTags->{"p:102", "i:7"}],
Cell[11516, 341, 220, 5, 70, "CodeCaption",ExpressionUUID->"9489dda2-a4fe-4693-86c5-14b9a533ed69",
 CellTags->"i:8"],
Cell[CellGroupData[{
Cell[11761, 350, 196, 4, 70, "Input",ExpressionUUID->"b4e23265-15f4-468d-a827-0a13e2fc5e00"],
Cell[11960, 356, 1496, 46, 70, "Output",ExpressionUUID->"2dd978c0-9f10-4947-9093-94c1ff446f35",
 Evaluatable->False,
 CellTags->"LastCellOfAPage"]
}, Open  ]],
Cell[13471, 405, 259, 8, 70, "Text",ExpressionUUID->"32eaf23b-24dc-4713-89d3-819289328892",
 CellTags->"i:9"],
Cell[13733, 415, 188, 4, 70, "CodeCaption",ExpressionUUID->"492b9254-004a-4302-812b-3a42deb12b74"],
Cell[CellGroupData[{
Cell[13946, 423, 1344, 30, 70, "Input",ExpressionUUID->"bdf64366-589e-4b70-889d-a37e7a6441e2"],
Cell[15293, 455, 177, 4, 70, "Output",ExpressionUUID->"1994eb1b-7aaf-48ef-834d-c880bd97f2d5",
 Evaluatable->False]
}, Open  ]],
Cell[15485, 462, 431, 13, 70, "Text",ExpressionUUID->"070151e2-2d71-416c-8e00-c80767e3ea36",
 CellTags->"i:10"],
Cell[15919, 477, 177, 4, 70, "CodeCaption",ExpressionUUID->"d50bbd0c-5749-42c4-a6e1-3c3573d5341d"],
Cell[CellGroupData[{
Cell[16121, 485, 161, 3, 70, "Input",ExpressionUUID->"ea4241d7-bded-4ee7-aed1-2ccc9d3b2c24"],
Cell[16285, 490, 195, 4, 70, "Output",ExpressionUUID->"3e57e5e9-1656-471c-af8f-dda00bd1a594",
 Evaluatable->False]
}, Open  ]],
Cell[16495, 497, 191, 4, 70, "CodeCaption",ExpressionUUID->"7b69be00-6569-4307-aac9-d90a7dd98c45"],
Cell[CellGroupData[{
Cell[16711, 505, 1328, 30, 70, "Input",ExpressionUUID->"f76500f4-8e42-4dde-a07d-d7c643b6b440"],
Cell[18042, 537, 195, 4, 70, "Output",ExpressionUUID->"f36eea10-4f2d-4f48-879d-9b6ef8061bd4",
 Evaluatable->False]
}, Open  ]],
Cell[18252, 544, 186, 4, 70, "CodeCaption",ExpressionUUID->"37cceee3-f578-40b5-a84b-e120eef63080"],
Cell[CellGroupData[{
Cell[18463, 552, 1390, 31, 70, "Input",ExpressionUUID->"e705305c-d0fa-41de-b164-a0a580055a82"],
Cell[19856, 585, 741, 18, 70, "Output",ExpressionUUID->"54b3ed21-f629-4161-9814-ca11871d3d53",
 Evaluatable->False]
}, Open  ]],
Cell[20612, 606, 245, 7, 70, "Text",ExpressionUUID->"18cbd2c2-f6d4-4b1c-a827-c61190adca5f"],
Cell[20860, 615, 218, 5, 70, "CodeCaption",ExpressionUUID->"4d13863d-f091-4317-9f54-89fe35e95eb8",
 CellTags->"i:11"],
Cell[CellGroupData[{
Cell[21103, 624, 187, 4, 70, "Input",ExpressionUUID->"539dfcad-6012-4883-8542-833fd964fecf"],
Cell[21293, 630, 717, 20, 70, "Output",ExpressionUUID->"7aa432dc-01d5-40c1-ad5d-71d8b50b99cb",
 Evaluatable->False]
}, Open  ]],
Cell[22025, 653, 204, 4, 70, "CodeCaption",ExpressionUUID->"8b854b10-74d5-41c4-bff7-8d94ce1e916f",
 CellTags->"i:12"],
Cell[CellGroupData[{
Cell[22254, 661, 280, 7, 70, "Input",ExpressionUUID->"02e91112-15bc-471d-8bd4-d8703baa563f"],
Cell[22537, 670, 274, 7, 70, "Output",ExpressionUUID->"b7e97b0c-2f38-4543-bb8b-d60f9b67e5cb",
 Evaluatable->False,
 CellTags->"LastCellOfAPage"]
}, Open  ]],
Cell[22826, 680, 239, 7, 70, "CodeCaption",ExpressionUUID->"a99de35a-0985-4565-8b44-70230e25b302"],
Cell[CellGroupData[{
Cell[23090, 691, 1420, 32, 70, "Input",ExpressionUUID->"148886a8-5560-4d27-84fb-0d77a073b501"],
Cell[24513, 725, 260, 7, 70, "Output",ExpressionUUID->"d6296b44-31ae-48d9-93c6-3dc17763eea0",
 Evaluatable->False]
}, Open  ]],
Cell[24788, 735, 320, 10, 70, "Text",ExpressionUUID->"615c57ba-7e08-4eaf-9e0b-34c0bef724b7",
 CellTags->"i:13"],
Cell[25111, 747, 200, 4, 70, "CodeCaption",ExpressionUUID->"e6dfc220-99ac-4092-8d8d-0dadb15c0401",
 CellTags->"i:14"],
Cell[CellGroupData[{
Cell[25336, 755, 2579, 55, 70, "Input",ExpressionUUID->"07db839d-7271-4d21-9865-2e9bb6f1b6ba"],
Cell[27918, 812, 670, 19, 70, "Output",ExpressionUUID->"49e70374-765c-49b9-bfa5-d9ddfc0363f4",
 Evaluatable->False]
}, Open  ]],
Cell[28603, 834, 193, 4, 70, "CodeCaption",ExpressionUUID->"d8b64ce1-cdfe-43be-9136-c36b3eafedfc",
 CellTags->"i:15"],
Cell[CellGroupData[{
Cell[28821, 842, 3597, 71, 70, "Input",ExpressionUUID->"f7286a3a-c7f0-4adf-af08-7c503fb11c2b"],
Cell[32421, 915, 579, 16, 70, "Output",ExpressionUUID->"8f984b38-5067-4091-b33a-041691b36192",
 Evaluatable->False]
}, Open  ]],
Cell[33015, 934, 418, 12, 70, "Text",ExpressionUUID->"72d5442a-fde8-420b-bd51-4c2e0d145f8e",
 CellTags->"i:16"],
Cell[33436, 948, 191, 4, 70, "CodeCaption",ExpressionUUID->"24dbd890-fd31-4b42-a3ca-6bb3ac28f9db"],
Cell[CellGroupData[{
Cell[33652, 956, 1429, 32, 70, "Input",ExpressionUUID->"2a8656ff-c384-424b-bf5a-cceb910c84a4"],
Cell[35084, 990, 292, 8, 70, "Output",ExpressionUUID->"f4d6d8f1-630a-4427-bbb4-a04bc9bdb1e9",
 Evaluatable->False]
}, Open  ]],
Cell[35391, 1001, 383, 14, 70, "Text",ExpressionUUID->"92603fda-52cc-47dd-9733-5a9f9b1e060f",
 CellTags->"i:17"],
Cell[35777, 1017, 230, 7, 70, "CodeCaption",ExpressionUUID->"b88bf2bc-5d14-4dd2-a7b3-4512f71078af"],
Cell[CellGroupData[{
Cell[36032, 1028, 1592, 36, 70, "Input",ExpressionUUID->"6e2d9f6e-e9db-43c3-9722-b5411daf1d52"],
Cell[37627, 1066, 25190, 519, 70, "Output",ExpressionUUID->"3da0ce73-c3ff-48a2-a4d1-a0b8dfb84b5c",
 Evaluatable->False,
 CellTags->"LastCellOfAPage"]
}, Open  ]],
Cell[62832, 1588, 361, 12, 70, "Text",ExpressionUUID->"68287844-f5e1-4958-9b30-8110b4ebbf3b",
 CellTags->{"p:104", "i:18"}],
Cell[63196, 1602, 190, 4, 70, "CodeCaption",ExpressionUUID->"9d8cc9df-8a8b-4061-827f-e8d795727c1b"],
Cell[CellGroupData[{
Cell[63411, 1610, 1667, 38, 70, "Input",ExpressionUUID->"0f2b0d7e-2fad-4c1f-8d52-232bbcc75b30"],
Cell[65081, 1650, 12887, 306, 70, "Output",ExpressionUUID->"700fc3f9-1990-4575-83b7-3c8ff0af5396",
 Evaluatable->False]
}, Open  ]],
Cell[77983, 1959, 256, 7, 70, "Text",ExpressionUUID->"099fb920-f395-49f6-8694-a503d3b0d560",
 CellTags->"i:19"],
Cell[78242, 1968, 543, 12, 70, "Text",ExpressionUUID->"37affbaf-0512-4bfe-936a-17eac66eca5c",
 CellTags->"i:20"],
Cell[78788, 1982, 282, 7, 70, "CodeCaption",ExpressionUUID->"c8e0aeb7-1a20-41dd-b9ae-f66deb3cad5a",
 CellTags->"i:21"],
Cell[CellGroupData[{
Cell[79095, 1993, 225, 4, 70, "Input",ExpressionUUID->"4c1beeda-c094-4ab3-b44e-22467fcab246"],
Cell[79323, 1999, 14959, 353, 70, "Output",ExpressionUUID->"809b9438-4e1b-4de3-b026-ca8c1f876435",
 Evaluatable->False]
}, Open  ]],
Cell[94297, 2355, 282, 7, 70, "CodeCaption",ExpressionUUID->"aa7f45b7-c2d3-4887-a27f-5d1da8621dc1"],
Cell[CellGroupData[{
Cell[94604, 2366, 268, 6, 70, "Input",ExpressionUUID->"4fc0ae50-e7c7-4583-80fd-282fd88ca580"],
Cell[94875, 2374, 17046, 404, 70, "Output",ExpressionUUID->"58526deb-c301-4f63-9346-390ee2b53594",
 Evaluatable->False]
}, Open  ]],
Cell[111936, 2781, 695, 16, 70, "Text",ExpressionUUID->"ffcede94-db0c-484e-9793-70727c569c1b",
 CellTags->{"LastCellOfAPage", "i:22"}],
Cell[112634, 2799, 314, 8, 70, "CodeCaption",ExpressionUUID->"f036bc86-8791-485d-a6ed-930f11db651e"],
Cell[CellGroupData[{
Cell[112973, 2811, 335, 8, 70, "Input",ExpressionUUID->"4a71c3d1-908d-46ac-8717-6983ffe54190"],
Cell[113311, 2821, 22051, 427, 70, "Output",ExpressionUUID->"5aa02b2b-adfc-4f99-aabd-b52dd4df85b1",
 Evaluatable->False]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[135411, 3254, 159, 4, 70, "VocabularySection",ExpressionUUID->"8ad40a74-9391-48a7-aeb7-7cc758c8f905"],
Cell[135573, 3260, 6525, 184, 70, "VocabularyTable",ExpressionUUID->"41623163-6491-4748-81af-e1ecb58c1fa9",
 CellTags->"LastCellOfAPage"]
}, Open  ]],
Cell[CellGroupData[{
Cell[142135, 3449, 1780, 46, 70, "ExerciseSection",ExpressionUUID->"57381f34-021a-470b-bb01-e077726ad48a"],
Cell[CellGroupData[{
Cell[143940, 3499, 1450, 45, 70, "ExerciseSummaryCell",ExpressionUUID->"07d71e2e-fcb8-415b-8ad1-eae1095625ad"],
Cell[CellGroupData[{
Cell[145415, 3548, 722, 20, 70, "Exercise",ExpressionUUID->"20dc3d30-a0ae-4181-ad1f-b70f3bedb5d5"],
Cell[146140, 3570, 1240, 34, 70, "ExerciseOutput",ExpressionUUID->"fb588fed-d453-471c-9df6-308ca360ecac"]
}, Closed]],
Cell[CellGroupData[{
Cell[147417, 3609, 714, 20, 70, "Exercise",ExpressionUUID->"abafec3e-e60b-428b-8bb2-72c8c3c53250"],
Cell[148134, 3631, 1094, 31, 70, "ExerciseOutput",ExpressionUUID->"4e5cc5f1-62c4-4bc2-a8f6-bc688c57ee44"]
}, Closed]],
Cell[CellGroupData[{
Cell[149265, 3667, 707, 20, 70, "Exercise",ExpressionUUID->"c17111ed-a7df-4efe-a89d-089d06ee8434"],
Cell[149975, 3689, 2320, 61, 70, "ExerciseOutput",ExpressionUUID->"9158a55d-544a-4c82-a9f4-532e65a278c8"]
}, Closed]],
Cell[CellGroupData[{
Cell[152332, 3755, 694, 20, 70, "Exercise",ExpressionUUID->"f5733391-fb6e-4ce4-a9db-399b207bbe48"],
Cell[153029, 3777, 2232, 59, 70, "ExerciseOutput",ExpressionUUID->"71d91be6-4247-4ced-8a64-f637c46f703f"]
}, Closed]],
Cell[CellGroupData[{
Cell[155298, 3841, 786, 21, 70, "Exercise",ExpressionUUID->"502df17c-7dbe-4c1c-8f2d-e4b2851ca0e0"],
Cell[156087, 3864, 1294, 36, 70, "ExerciseOutput",ExpressionUUID->"17b58ac6-732f-48c6-8d5b-91aaa5bab660"]
}, Closed]],
Cell[CellGroupData[{
Cell[157418, 3905, 716, 20, 70, "Exercise",ExpressionUUID->"d0021686-37eb-4ed3-8a48-f559a9ea766a"],
Cell[158137, 3927, 2533, 63, 70, "ExerciseOutput",ExpressionUUID->"d299d1e1-9c64-4b4b-89f1-1f30228ad7d7"]
}, Closed]],
Cell[CellGroupData[{
Cell[160707, 3995, 743, 21, 70, "Exercise",ExpressionUUID->"73bc7c59-e0ac-4d59-983d-cc6e0f63100e"],
Cell[161453, 4018, 1964, 47, 70, "ExerciseOutput",ExpressionUUID->"9977d5ef-815e-4f26-a610-e7b932641b28"]
}, Closed]],
Cell[CellGroupData[{
Cell[163454, 4070, 746, 21, 70, "Exercise",ExpressionUUID->"490630da-ed97-402d-a76f-15c8fb2ce519"],
Cell[164203, 4093, 17042, 363, 70, "ExerciseOutput",ExpressionUUID->"aaf8ca6b-ecb9-45aa-8341-e674f4398ef7"]
}, Closed]],
Cell[CellGroupData[{
Cell[181282, 4461, 735, 20, 70, "Exercise",ExpressionUUID->"a297b226-1cf3-46d7-bf47-5db8aa2a9291"],
Cell[182020, 4483, 1242, 34, 70, "ExerciseOutput",ExpressionUUID->"2ec20eae-67f5-496d-8993-2879aa93e574"]
}, Closed]],
Cell[CellGroupData[{
Cell[183299, 4522, 729, 20, 70, "Exercise",ExpressionUUID->"de4b5f59-9ba3-4e7d-9934-ceb3b4aaf6e0"],
Cell[184031, 4544, 1344, 38, 70, "ExerciseOutput",ExpressionUUID->"434941f6-a1c0-4289-bb52-4fe84469c30a"]
}, Closed]],
Cell[CellGroupData[{
Cell[185412, 4587, 726, 20, 70, "Exercise",ExpressionUUID->"bd2520db-7e26-459f-96c0-2dfdfba87ddd"],
Cell[186141, 4609, 27812, 575, 70, "ExerciseOutput",ExpressionUUID->"00401236-2bfc-4377-93d0-d490802bd0e6"]
}, Closed]],
Cell[CellGroupData[{
Cell[213990, 5189, 750, 21, 70, "Exercise",ExpressionUUID->"62da9067-1b33-4926-981e-ec8f09134367"],
Cell[214743, 5212, 1368, 38, 70, "ExerciseOutput",ExpressionUUID->"d617aeb2-05a6-40ea-96e5-f259eb1ba142"]
}, Closed]],
Cell[CellGroupData[{
Cell[216148, 5255, 764, 21, 70, "Exercise",ExpressionUUID->"1f52c0f8-0009-46f1-b655-68ace7108854"],
Cell[216915, 5278, 49146, 1032, 70, "ExerciseOutput",ExpressionUUID->"37a76c85-283a-4c80-9e7c-4811e76ce1d2"]
}, Closed]],
Cell[CellGroupData[{
Cell[266098, 6315, 724, 20, 70, "Exercise",ExpressionUUID->"368d345a-1dd8-4ba8-966e-44428adfd846"],
Cell[266825, 6337, 1247, 34, 70, "ExerciseOutput",ExpressionUUID->"f3f01072-e815-4c45-82f2-d07135230777"]
}, Closed]],
Cell[CellGroupData[{
Cell[268109, 6376, 719, 20, 70, "Exercise",ExpressionUUID->"41b35cc4-1bcd-434b-858d-e40107725b46"],
Cell[268831, 6398, 1211, 34, 70, "ExerciseOutput",ExpressionUUID->"1a066845-eed1-445d-bb7e-c361ef5166e5"]
}, Closed]],
Cell[CellGroupData[{
Cell[270079, 6437, 727, 20, 70, "Exercise",ExpressionUUID->"896bfd65-d6ce-4c66-80ca-5c6e3bc8b9ac"],
Cell[270809, 6459, 2574, 63, 70, "ExerciseOutput",ExpressionUUID->"f483dfbe-96e6-4304-87e0-291d2ecbb7fc"]
}, Closed]],
Cell[CellGroupData[{
Cell[273420, 6527, 749, 21, 70, "Exercise",ExpressionUUID->"b53347b6-b8be-47ab-8037-875596285b76"],
Cell[274172, 6550, 4807, 111, 70, "ExerciseOutput",ExpressionUUID->"8116f4d2-b4b7-453f-ac8f-5dbe2a2b43d4"]
}, Closed]],
Cell[CellGroupData[{
Cell[279016, 6666, 779, 23, 70, "Exercise",ExpressionUUID->"d2677d14-16fd-407d-b784-1bfa4929aaa0"],
Cell[279798, 6691, 4621, 96, 70, "ExerciseOutput",ExpressionUUID->"28658296-1a71-4823-a5a1-f452603399e9"]
}, Closed]],
Cell[CellGroupData[{
Cell[284456, 6792, 732, 20, 70, "Exercise",ExpressionUUID->"263f4a43-f05d-4543-b794-343eab0e25cd"],
Cell[285191, 6814, 16466, 380, 70, "ExerciseOutput",ExpressionUUID->"3959ae8e-8caf-47c5-9ada-7b7dfd44e6e6"]
}, Closed]],
Cell[CellGroupData[{
Cell[301694, 7199, 841, 22, 70, "Exercise",ExpressionUUID->"b946f493-e2fc-4d1d-84ee-f9216e4785f6"],
Cell[302538, 7223, 44876, 856, 70, "ExerciseOutput",ExpressionUUID->"24025198-f47e-4eda-aac8-99f2ef6f1abf"]
}, Closed]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[347475, 8086, 144, 4, 70, "QASection",ExpressionUUID->"c6bc8ff6-2522-447f-8c37-e21de4aabfbb"],
Cell[347622, 8092, 173, 4, 70, "Question",ExpressionUUID->"1887bf1f-fe1c-4b04-b043-e6790a9886eb"],
Cell[347798, 8098, 734, 21, 70, "Answer",ExpressionUUID->"008404cd-03c0-44a7-ac0a-696c49f34e3b",
 CellTags->"i:23"],
Cell[348535, 8121, 210, 6, 70, "Question",ExpressionUUID->"8aa95f8f-ca26-4e13-a8fe-54d0be2584d6"],
Cell[348748, 8129, 774, 25, 70, "Answer",ExpressionUUID->"4cd299f7-760c-48d3-99cf-645fc3f2cff7",
 CellTags->"i:24"],
Cell[349525, 8156, 197, 4, 70, "Question",ExpressionUUID->"2bf27e29-4703-451d-a455-5e75b114fa4c"],
Cell[349725, 8162, 367, 8, 70, "Answer",ExpressionUUID->"9f72bf3c-92b5-4118-8e00-62c4975c3ea3",
 CellTags->"i:25"],
Cell[350095, 8172, 192, 4, 70, "Question",ExpressionUUID->"2bfc27c6-b576-4c13-bc5e-70929fdd1675"],
Cell[350290, 8178, 389, 9, 70, "Answer",ExpressionUUID->"5f44c2d2-8ad0-431d-b74f-f1fd5e197f03"],
Cell[350682, 8189, 210, 6, 70, "Question",ExpressionUUID->"41b55ab8-b790-4fae-8b8c-558213ee36c6"],
Cell[350895, 8197, 683, 18, 70, "Answer",ExpressionUUID->"9c96cee7-9c11-4223-9a62-2b28e64ad7cf"],
Cell[351581, 8217, 162, 4, 70, "Question",ExpressionUUID->"1f50252a-af1b-40db-8185-4b0a8936c711"],
Cell[351746, 8223, 1122, 32, 70, "Answer",ExpressionUUID->"7a3ddbd2-2ed2-45a7-8d93-9f1cca329706",
 CellTags->"i:26"],
Cell[352871, 8257, 223, 9, 70, "Question",ExpressionUUID->"894de397-357b-4181-8b22-3113f31cfbe2"],
Cell[353097, 8268, 1165, 36, 70, "Answer",ExpressionUUID->"2f995462-da30-49a3-b7f2-88771ee1a2c5",
 CellTags->"LastCellOfAPage"]
}, Open  ]],
Cell[CellGroupData[{
Cell[354299, 8309, 174, 4, 70, "TechNoteSection",ExpressionUUID->"85817595-011e-4565-91e8-e30585162152",
 CellTags->"p:106"],
Cell[354476, 8315, 374, 8, 70, "TechNote",ExpressionUUID->"9a0bd9b5-a576-448e-8fa6-061e93261bca",
 CellTags->"i:27"],
Cell[354853, 8325, 296, 11, 70, "TechNote",ExpressionUUID->"90d306a7-8b72-4976-9fcf-2414d4bc0a90"],
Cell[355152, 8338, 544, 18, 70, "TechNote",ExpressionUUID->"d9abb382-14cf-4e02-9c91-7b4b0a431750",
 CellTags->"i:28"],
Cell[355699, 8358, 530, 18, 70, "TechNote",ExpressionUUID->"96dd97e4-1a6c-44f3-b594-7033379772a3"]
}, Open  ]],
Cell[CellGroupData[{
Cell[356266, 8381, 165, 4, 70, "MoreExploreSection",ExpressionUUID->"6b266d92-d97f-4be7-8d91-c81665c65680"],
Cell[356434, 8387, 339, 8, 70, "MoreExplore",ExpressionUUID->"d0f53de7-b841-45eb-aaee-db62786407a3",
 CellTags->"LastCellOfAPage"]
}, Open  ]]
}
]
*)

(* NotebookSignature LLj3dMRv5HddxJ#MUUdm9xLW *)
